﻿USE sofia;
DROP TABLE IF EXISTS sofia.cntNT_vpl;
CREATE TABLE cntNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cntNT_vpl WRITE;
INSERT INTO cntNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","A₂la₂ bá₄ caun₂ lista ja₁le₁ton₅ dsa₂ can'₅₄ quián₅ Jesucristo i₂jme₁lɨ́n₄ tsɨ₁jon₂ quián₅ David quian'₅₄ Abraham. ");
INSERT INTO cntNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ca₂lɨn₃ jmei₂ Isaac, Isaac guë'₂ ca₂lɨn₃ jmei₂ Jacob; Jacob guë'₂ ca₂lɨn₃ jmei₂ Judá quian'₅₄ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá guë'₂ në́₃ ca₂lɨn₃ jmei₂ Fares quian'₅₄ Zara të₂le₃ quian'₅₄ Tamar. Fares guë'₂ ca₂lɨn₃ jmei₂ Esrom; Esrom guë'₂ ca₂lɨn₃ jmei₂ Aram. ");
INSERT INTO cntNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram guë'₂ ca₂lɨn₃ jmei₂ Aminadab; Aminadab guë'₂ ca₂lɨn₃ jmei₂ Na'asón; Na'asón guë'₂ ca₂lɨn₃ jmei₂ Salmón; ");
INSERT INTO cntNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón guë'₂ ca₂lɨn₃ jmei₂ Bo'oz të₂le₃ quian'₅₄ Rahab. Bo'oz guë'₂ ca₂lɨn₃ jmei₂ Obed të₂le₃ quian'₅₄ Ruth. Obed guë'₂ ca₂lɨn₃ jmei₂ Isaí; ");
INSERT INTO cntNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí guë'₂ ca₂lɨn₃ jmei₂ Rag₅₄ David. Rag₅₄ David guë'₂ në́₃ ca₂lɨn₃ jmei₂ Salomón, (të₂le₃ quian'₅₄ i₂jme₁lɨ́n₄ dsa₂ mɨ́₂ quián₅ Urías le₂jŋiá₅). ");
INSERT INTO cntNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón guë'₂ ca₂lɨn₃ jmei₂ Roboam; Roboam guë'₂ ca₂lɨn₃ jmei₂ Abías; Abías guë'₂ ca₂lɨn₃ jmei₂ Asa; ");
INSERT INTO cntNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa guë'₂ ca₂lɨn₃ jmei₂ Josafat; Josafat guë'₂ ca₂lɨn₃ jmei₂ Joram; Joram guë'₂ ca₂lɨn₃ jmei₂ Usías; ");
INSERT INTO cntNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usías guë'₂ ca₂lɨn₃ jmei₂ Jotam; Jotam guë'₂ ca₂lɨn₃ jmei₂ Acaz; Acaz guë'₂ ca₂lɨn₃ jmei₂ Ezequías; ");
INSERT INTO cntNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías guë'₂ ca₂lɨn₃ jmei₂ Manasés; Manasés guë'₂ ca₂lɨn₃ jmei₂ Amón; Amón guë'₂ ca₂lɨn₃ jmei₂ Josías; ");
INSERT INTO cntNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías guë'₂ ca₂lɨn₃ jmei₂ Jeconías quian'₅₄ rɨin'₅₄, (lia'₂ con'₂ jmɨg₄ jme₁ca₂i₃lén₂ dsa₂ israelitas a₂ca₂tág₃ dsa₂ juɨ₅ 'uë₃ Babilonia). ");
INSERT INTO cntNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Cang₂ jme₁ma₂tág₃ dsa₂ 'uë₃ Babilonia jaun₂, ca₂lɨn₃ Jeconías jmei₂ Salatiel; i₂ca₂lɨn₃ jmei₂ Zorobabel; ");
INSERT INTO cntNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel në́₃ ca₂lɨn₃ jmei₂ Abiud; Abiud guë'₂ ca₂lɨn₃ jmei₂ Eliaquim; Eliaquim guë'₂ ca₂lɨn₃ jmei₂ Azor; ");
INSERT INTO cntNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor në́₃ ca₂lɨn₃ jmei₂ Sadoc; Sadoc guë'₂ ca₂lɨn₃ jmei₂ Aquim; Aquim guë'₂ ca₂lɨn₃ jmei₂ Eliud; ");
INSERT INTO cntNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud guë'₂ ca₂lɨn₃ jmei₂ Eleazar, i₂ca₂lɨn₃ jmei₂ Matán; Matán guë'₂ ca₂lɨn₃ jmei₂ Jacob; ");
INSERT INTO cntNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob në́₃ ca₂lɨn₃ jmei₂ José, dsɨ₂i₂gu₂ María; María guë'₂ në́₃ ca₂lɨn₃ chog₅₄ Jesús i₂të́'₂ dsa₂ Cristo*. ");
INSERT INTO cntNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jaun₂ në́₃, con'₂ guia₃-quén₂ tsɨ₁jon₂ dsa₂ ca₂ŋɨ́₂ ca₂le₃ jme₁chan₂ Abraham ca₂të₂ jmɨg₄ jme₁ca₂rë₃chán₃ David, ján₃ bá₄ le₂jaun₂ guia₃-quén₂ tsɨ₁jon₂ dsa₂ ca₂ŋɨ́₂ ca₂le₃ jme₁chan₂ David, ca₂të₂ jmɨg₄ jme₁ca₂tág₃ dsa₂ dsa₂ israelitas juɨ₅ 'uë₃ Babilonia; cang₂ jaun₂ guë́₄ në́₃, con'₂ guia₃-quén₂ tsɨ₁jon₂ dsa₂ ca₂ŋɨ́₂ ca₂le₃ ca₂tág₃ dsa₂, ca₂të₂ jmɨg₄ jme₁ca₂rë₃chán₃ dsa₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Le₂la₂ bá₄ ca₂lë₃ a₂ca₂rë₃chán₃ Jesús: chog₅₄ jme₁chen₂ María jme₁ma₂lɨ'₅₄ jág₁ a₂jéin'₂ gu₂ quian'₅₄ José; la₁ né'₃ guë́₄ a₂tiain'₃, María në́₃ ca₂can₃ guein₂ të₂le₃ quian'₅₄ juɨ₅bí₂ quió'₅ Jme₂dsí₂ Jŋió₅. ");
INSERT INTO cntNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José dsa₂ ŋe'₂ quiáin₅ në́₃ jme₁lɨ́in₄ jan₂ dsa₂ dsen₃, jaun₂ tsá₃ jme₁'nio₃ chein'₃ o₂guí'₃ María jua'₅₄ le₃ŋi₅ dsa₂ juɨn₅; jŋia'₅₄ lia'₂ a₂jaun₂ bá₄ jme₁dsɨ₂jiog₅ dsɨ́₅ a₂jme₁téi₂ bá₄ con'₂ tsá₃ 'ein₂ ŋi₅. ");
INSERT INTO cntNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Le₂jaun₂ bá₄ jme₁ma₂ca₂'náu'₃ dsɨ́₅ jmo₃, jme₁ca₂quɨ₃ a₂ca₂jme₃jnia₅ jan₂ ángel quián₅ Te₁gui'₅₄ ne₅₄ ca₂juá'₂: ―Së́₄, tsɨ₁jon₂ David, tsá₃ lë₁jmo₂ gang'₃ jua'₅₄ cán'₁ o₂guí'₃ a₂guéng'₄ María a₂léin₂ dsɨ₂i₂gog'₂, ia₁ guein₂ i₂le₃chan₂ quiáin₅ já₅ ja₁con₂ Jme₂dsí₂ Jŋió₅. ");
INSERT INTO cntNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Jaun₂ le₃chan₂ jan₂ guein₂ dsa₂ ŋe'₂ quiáin₅, jaun₂ quiain'₅₄ 'ne₂ JESÚS. Le₃chein₂ le₂në₅ ia₁ a₂lióin₂ dsa₂ juɨg₂ quiáin₅ 'uɨg₅₄ dsáu₁. ");
INSERT INTO cntNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ca₂lë₃ ca₂le₃jë́₃ a₂në₅ ia₁jaun₂ le₃ti₃ juɨ₁lia'₂ ca₂juá'₂ Te₁gui'₅₄ të₂le₃ quian'₅₄ dsa₂ i₂jme₁'ë́₂ jág₁ quiáin₅, jme₁ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Cán₂ jan₂ dsa₂ mɨ₄ guein₂, jaun₂ le₃chan₂ jan₂ guein₂ dsa₂ ŋe'₂ quiáin₅, jaun₂ le₃chein₂ Emanuel, co₂'nió'₄ a₂juá'₂: Quiong'₅₄ Diú₄ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jaun₂ jme₁ca₂ŋé₃ Së́₄ a₂jme₁rë₂güɨ́in₃ jaun₂, le₂jaun₂ bá₄ ca₂jmo₃ lia'₂ con'₂ lë́₅ ca₂juá'₂ ángel quián₅ Te₁gui'₅₄, jaun₂ ca₂guein₃ bá₄ María a₂lén₂ 'éi₂ dsɨ₂i₂gu₂. ");
INSERT INTO cntNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","La₁ia₁ tsá₃ ca₂tiáin'₂ dsɨ₂juɨ₅ jme₁né₄, jua'₅₄ a₂ca₂rë₃cuɨin₂₃ rɨin'₅₄, ca₂lia'₂ jme₁ca₂rë₃chán₃ guein₂ i₂le₂'uɨg₅₄ 'éi₂ quián₅ bá₄ María; jaun₂ ca₂quiain₃ guein₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ca₂rë₃chán₃ Jesús jë₄ juɨg₂ Belén, ja₁tén₄ 'uë₃ Judea, jmɨg₄ lia'₂ con'₂ jme₁lɨ́n₄ Herodes rag₅₄ 'uë₃ jaun₂. Jaun₂ ca₂o₃lén₂ co₂nió'₃ dsa₂ i₂chan₂ uɨ́ng₂ të₂le₃ ja₁'ia₂ 'iog₂, jaun₂ ca₂dsi₃léin₂ juɨg₂ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jaun₂ ca₂ŋag₃: ―¿Na₅ Rag₅₄ quián₅ dsa₂ judíos i₂ca₂rë₃chán₃? Ia₁ 'uë₃ të₂le₃ ja₁'ŋia₂ 'iog₂, ma₂në₂jɨn₄ jnia'₅₄ nei₅ quiáin₅, jaun₂ ja₂náu₅ jnia'₅₄ a₂jme₁juɨin'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jme₁ca₂rë₃ŋi₅ Rag₅₄ Herodes jág₁ në₅, 'ŋio₅ lɨn₃ tsá₃ ma₃tei₄ ca₂'ág₂ dsɨ́₅, ján₃ bá₄ le₂jaun₂ ca₂le₃jɨ́n₃ dsa₂ juɨg₂ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jaun₂ në́₃ ca₂të́'₃ rag₅₄ ca₂le₃jɨ́n₃ juɨg₅₄ jme₂dsa₂ quian'₅₄ ca₂le₃jɨ́n₃ të₅juá'₅ quián₅ dsa₂, jaun₂ ca₂ŋag₃ a₂já'₄ dsón'₂ lë́₅ jág₁ le₃chan₂ dsa₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jaun₂ ca₂juá'₂ dsa₂ 'éi₂: ―Juɨg₂ Belén, ja₁tén₄ 'uë₃ Judea. Ia₁ le₂la₂ ca₂tó'₂ ne₄ si₂ dsa₂ i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄: ");
INSERT INTO cntNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Jaun₂ 'ne₂, Belén, juɨg₂ tén₅ 'uë₃ Judá, on₃jua'₅₄ 'ne₂ lɨ́ng'₅ juɨg₂ i₂me'₂ guë́₄ të₂le₃ ne₄ juɨ₁lia'₂ dsa₂ i₂qui₂dsɨ₅ 'éi'₃ 'uë₃ në₅; ia₁ ja₁con'₂ 'ne₂ bá₄ o₃'ɨn₅ jan₂ i₂gon₂, cán₂ ne₄ juɨ₅, jmo₃ 'í₁ dsa₂ juɨg₂ Israel quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jaun₂ Herodes në́₃ ca₂të́'₃ dsa₂ can'₅₄ 'éi₂ con'₂ jë₄ të₃co'₅₄, jaun₂ ca₂ŋag₃ lɨ́g'₂ 'e₂ jmɨg₄ të₃dsón'₂ ca₂rë₃jniá₂ nei₅ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jme₁ma₂në₂ŋag₃ dsa₂ 'éi₂ jaun₂ guë́₄ ca₂chei₃ juɨ₅ juɨg₂ Belén, jaun₂ ca₂tsɨ́'₃ dsa₂: ―O₂nó'₅ 'nia'₂ ja₁jaun₂, o₂quion₂ de'₂ 'nia'₂ 'í₁ rë₂ të₂le₃ quió'₅ chi'₂ bë'₅₄ i₂'ɨ́n'₅ 'nia'₂ në₅; jaun₂ jë₁ma₂ca₂dsáin'₂ 'nia'₂, i₂con'₄ 'nia'₂ jág₁ ia₁jaun₂ nei₅₄ jniá₂ ján₃ i₂jme₁juɨin'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jme₁ma₂në₂néi₂ dsa₂ 'éi₂ jág₁ quió'₅ rag₅₄, jaun₂ ca₂i₃léin₂. Jaun₂ në́₃, nei₅ a₂ma₂ca₂jág₃a të₂le₃ 'uë₃ ja₁'ia₂a 'iog₂, ca₂ŋó₃ ne₄ juɨ₅ quió'₅, ca₂lia'₂ ca₂'ág₂ tei₄ ne₄ ja₁jme₁'en₅₄ guein₂. ");
INSERT INTO cntNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jme₁ca₂jág₃ jaun₂, ca₂jmo₃ 'io'₂ 'ŋio₅ lɨn₃; ");
INSERT INTO cntNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","jaun₂ jme₁ca₂i₃toin'₅₄ dsi₂néi₂, ca₂jɨ́in₂ guein₂ bë'₅₄ quiain'₅₄ chog₅₄ i₂chen₂ María. Jaun₂ në́₃, ca₂chi₃jné₃ ca₂jme₃juɨin'₂ guein₂. Jaun₂ dsɨ₂juɨ₅ le₂jaun₂ qui₂ca₂niá₃ tsɨ₁gu₅ quió'₅, ca₂cuë₃ cu₄nióg₄, chen₂, no'₅₄ mirra në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Cang₂ guë́₄ jaun₂ ca₂quɨ₃ dsa₂ 'éi₂ a₂ca₂jmo₃ Diú₄ jág₁ a₂tsá₃ ma₃dsɨ₃lein₃ juɨ₅ ja₁con₂ Rag₅₄ Herodes, jaun₂ juɨ₅ siá'₂ bá₄ ca₂i₃lein₃ juɨ₅ go₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cang₂ guë́₄ jaun₂, jme₁ma₂i₂len₃ dsa₂ can'₅₄ 'éi₂, ca₂quɨ₃ Së́₄ a₂ca₂jme₃jnia₅ jan₂ ángel quián₅ Te₁gui'₅₄ ja₁coin₂, a₂ca₂juá'₂: ―Nau₂, jŋia₅ i₂bë'₅₄ quiáng'₂, chog₅₄ në́₃, cuɨng₅ 'nia'₂ juɨ₅ 'uë₃ Egipto. Ja₁jaun₂ o₂'ú₅ ca₂lia'₂ ca₂juá'₃ jniá₂. Ia₁ 'nau'₂ Herodes 'nai'₂ guein₂ a₂jŋag'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A₂ca₂nau₂ jaun₂ Së́₄, ca₂tág₃ guein₂ quian'₅₄ chog₅₄ a₂'uë₂ jaun₂, ca₂i₃léin₂ juɨ₅ Egipto. ");
INSERT INTO cntNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ja₁jaun₂ ca₂tóin'₂ ca₂lia'₂ ca₂jon₃ Herodes. Ca₂lë₃ le₂në₅ ia₁jaun₂ le₃ti₃ jág₁ a₂ca₂juá'₂ Te₁gui'₅₄ të₂le₃ quian'₅₄ dsa₂ i₂jme₁'ë́₂ jág₁ o₄quió'₄, jme₁ca₂juá'₂: “Të₂ Egipto bá₄ ca₂të₃ jniá₂ jón₃ quiáng₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jme₁ca₂rë₃lí'₄ Herodes ca₂jme₃gau₅ dsa₂ can'₅₄ 'éi₂ quió'₅, ca₂rë₃'néi₃ 'ŋio₅ lɨn₃. Jaun₂ ca₂chein₃ dsa₂ a₂jme₃dsiain₂₃ ca₂le₃jɨ́n₃ guein₂ i₂con'₂ ma₂tion'₅₄ tɨn₃ ŋi₂, guein₂ i₂pí'₁ guë́₄ në́₃ i₂chan₂ ma₂quián₅ Belén, lia'₂ con'₂ tí₅ ma₂ne₁ŋó₄ jmɨg₄ a₂ca₂juá'₂ dsa₂ can'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jaun₂ le₂në₅ ca₂rë₃ti₃ jág₁ a₂ca₂tó'₂ ne₄ si₂ Jeremías i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄: ");
INSERT INTO cntNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ca₂né'₂ të₁tsɨ'₅₄ co₂mɨ'₅₄ jë₄ juɨg₂ Ramá, a₂'o₅ dsa₂ a₂quɨ'₂ dsɨ́₅ guë́₄ lɨn₃; Raquel bá₄ 'éi₂ ca₂'o₃ o₄quió'₄ chi'₂-guein₂ quiáin₅, jaun₂ tsá₃ ca₂gue₃ jua'₅₄ 'ein₂ guë́₃ jmo₃ lián'₂ dsɨ́₅, ia₁ ma₂ca₂dsan₃ bá₄ guein₂. ");
INSERT INTO cntNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","La₁ cang₂ guë́₄ jaun₂, jme₁ma₂ca₂jon₃ Herodes, ca₂quɨ₃ Së́₄ a₂ca₂jme₃jnia₅ táng₃ jan₂ ángel quián₅ Te₁gui'₅₄ ja₁coin₂ 'ein₅₄ Egipto, ");
INSERT INTO cntNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ca₂juá'₂ ángel: ―Nau₂, jŋia₅ táng₃ i₂bë'₅₄ quiáng'₂, chog₅₄ në́₃, jaun₂ o₂nó'₅ táng₃ 'nia'₂ juɨ₅ 'uë₃ Israel, ia₁ ma₂ca₂dsan₃ bá₄ i₂jme₁'nio₃ jme₁jŋɨ'₃ guein₂. ");
INSERT INTO cntNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A₂ca₂nau₂ jaun₂ táng₃ Së́₄, ca₂tág₃ chi'₂ quiáin₅, quian'₅₄ chog₅₄, juɨ₅ 'uë₃ Israel. ");
INSERT INTO cntNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","La₁ jme₁ca₂rë₃ŋi₅ Së́₄ a₂ma₂lɨ́n₅ ta₁ Arquelao 'uë₃ Judea, ta₁ a₂jme₁lɨ́n₄ Herodes jmei₂, jaun₂ ca₂rë₃gó'₅ dsó₃ ja₁jaun₂. Ia₁ ca₂'ë́₂ táng₃ Diú₄ jág₁ jë₄ quɨ₂₃, jaun₂ juɨ₅ 'uë₃ Galilea bá₄ ca₂ŋó₃. ");
INSERT INTO cntNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jme₁ca₂dsióg₃ ja₁jaun₂, ca₂ŋó₃ ca₂i₁gua₂ juɨg₂ ja₁chei₂ Nazaret. Le₂në₅ bá₄ ca₂rë₃ti₃ jág₁ quió'₅ dsa₂ i₂ca₂'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂: “A₂quiong₃ dsa₂ nazareno.” ");
INSERT INTO cntNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jmɨg₄ jaun₂ guan₃ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂, caun₂ 'uë₃ quein₂ co₂'ŋiog₅ ja₁tén₄ 'uë₃ Judea, a₂'ë́₂ jág₁, ");
INSERT INTO cntNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","a₂juá'₂: ―Jein'₅₄ 'nia'₂ 'au'₂, ia₁ ma₂ja₂quián₃ jmɨg₄ jë₁gon₃ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan₅₄ la₂ bá₄ 'éi₂ i₂ca₂'ɨn₃ Isaías i₂jme₁juá'₂ o₄quió'₄ Diú₄ jme₁ca₂tó'₂ ne₄ si₂ a₂juá'₂ le₂la₂: Né'₂ a₂táun₂ dsa₂ tiá₂ jág₁ caun₂ 'uë₃ quein₂ ja₁co₂'ŋiog₅, a₂juá'₂: “Jmo₄ 'nia'₂ co₂jŋia₅₄ juɨ₅ quió'₅ Te₁gui'₅₄; nia₄ 'nia'₂ caun₂ juɨ₅ co₂dsau₅.” ");
INSERT INTO cntNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nɨ₁tsɨn'₅₄ Juan₅₄ 'éi₂ jme₁lë́₄ 'mɨ'₂ a₂rë₂ta₄ quian'₅₄ jŋi₄ já'₂ camello; a₂jme₁jén'₅ tú'₅ guë'₂ quian'₅₄ lo₄ já'₂; má₃ a₂jme₁guë́'₅ guë'₂, jmá'₃ i₁nɨ'₂ tia₄ quian'₅₄ jmɨ₁tá'₄ cha₂ ja₁nau₂. ");
INSERT INTO cntNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jme₁ja₂lén₂ dsa₂ chan₂ Jerusalén, quian'₅₄ dsa₂ i₂tián'₅ 'uë₃ Judea quian'₅₄ dsa₂ i₂tián'₅ cau₅ Cuá₃ Jordán në́₃, jme₁qui₂ja₂néi₃ jág₁ a₂cuë₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jme₁ma₂ca₂lë₃ jmo₂₃ qui₂ŋí₃ quió'₅ ne₄ Diú₄ ca₂le₃jë́₃ dso₄ a₂qui₂rë₂cáin'₄, jaun₂ guë́₄ ca₂cho₃ Juan₅₄ jmɨg₂ Cuá₃ Jordán. ");
INSERT INTO cntNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","La₁ jme₁ca₂jág₃ Juan₅₄ juɨn₅ lɨn₃ dsa₂ fariseos ja₂lén₂ quian'₅₄ dsa₂ saduceos në́₃, a₂mɨ₂₃ cho₃ Juan₅₄ jmɨg₂, jaun₂ ca₂juá'₂ Juan₅₄: ―¡'Nia'₂ tsɨ₁jon₂ dsɨ₂mɨ'₂! ¿'Ein₂ bá₄ në₂chí'₃ 'nia'₂ a₂cuɨng'₂ long'₅₄ a₂'i₄ 'nei₂ dsɨ́₅ Diú₄ a₂ja₂quián₃? ");
INSERT INTO cntNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Jmo₄ 'nia'₂ jaun₂ juɨ₁le₂jniá₂ a₂léi₄ të₃dsón'₂ a₂ma₂ca₂jein'₅₄ 'nia'₂ 'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Tsá₃ o₁len'₂ 'nia'₂ jua'₅₄ lé₂ le₃jua'₅₄ 'nia'₂: “Lág₅ jnia'₅₄ tsɨ₁jon₂ Abraham”; ia₁ jniá₂ juá'₅, ca₂të₂ nɨ₁cang₁ tio'₅₄ la₂, lé₂ le₃jmo₃ Diú₄ jmói'₂ tsɨ₁jon₂ Abraham. ");
INSERT INTO cntNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ia₁ ma₂lë́₅ co₂jŋia₅₄ ŋi₁dsi₁ a₂qui₂uɨ́n'₂ 'ma₂. Ca₂le₃jë́₃ 'ma₂ a₂tsá₃ dse₃ mɨ́g₂ 'ag₅, uɨ́n'₂ bá₄, dsɨ₂to'₅₄ si₂. ");
INSERT INTO cntNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jniá₂ në́₃, dsau₅ bá₄ në₂tiáng₃ 'nia'₂ jmɨg₂ co₂'nió'₄ a₂jáng'₅ léi₄ a₂jein'₅₄ 'nia'₂ 'au'₂; la₁ i₂já₅ chi₁co'₅₄ quió₃ në́₃, 'éi₂ bá₄ i₂'uan'₂ guë́₄ lia'₂ con'₂ guë́₄ jniá₂, ca₂lia'₂ jŋia'₅₄ lau₂ ton₅ tag₅₄ bá₄ tsá₃ ca₂tɨ́ng₂ i₁quian₃. 'Éi₂ guë́₄ në́₃, tióg₂ Jme₂dsí₂ Jŋió₅, dsi₂si₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Në₂jag₄ bá₄ a₂ma₂chi₁chan'₂ ŋí₁ a₂quió'₅ mɨ́g₂ trigo, dsia₃ jma₃quén₅ quian'₅₄ jme₁qui₅. Jmá'₃ mɨ́g₂ bá₄ cág'₃, 'ma₃ dsi₂néi₂, la₁ qui₂dsɨ́'₂ bá₄ jme₁qui₅ dsi₂si₂ ja₁tsá₃ ma₃o₁lɨ́g'₂ jmɨg₄ éi₃. ");
INSERT INTO cntNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jaun₂ në́₃, Jesús, o₂'ɨ́in₃ 'uë₃ Galilea, ca₂dsióg₃ të₂ Cuá₃ Jordán ia₁jaun₂ cho₃ Juan₅₄ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tsá₃ jme₁gue₅ Juan₅₄ le₂'uɨg₅₄, jaun₂ ca₂juá'₂ tsɨ́'₅ Jesús: ―Jniá₂ bá₄ i₂'nió'₅ quió₃ tsón'₄ 'ne₂ jmɨg₂. ¿'A₂ bá₄ lia'₂ 'ne₂ ŋe'₃ ja₁con₂ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","La₁ ca₂juá'₂ Jesús: ―Juɨ₁le₅₄ bá₄ le₂në₅ të₂në₃, ia₁ dsi₂ten₅₄ de'₂ jmó₁ jniog₄ le₂në₅ ia₁jaun₂ jme₁ti₁ ca₂le₃jë́₃ a₂dse₃. Jaun₂ bá₄ ca₂gue₃ Juan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jme₁ma₂lë₅ cho₅ Juan₅₄ jmɨg₂, jaun₂ ca₂o₃'ɨ́n₃ Jesús dsi₂jmɨg₂. Jaun₂ dsɨ₂juɨ₅ le₂jaun₂ ca₂niá₃ dsɨ₄ mɨ₂güɨ́g₃ ca₂lë₃, jaun₂ ca₂jɨ́n₂ Jesús Jme₂dsí₂ quián₅ Diú₄ ca₂sión₃ ne₄ quió'₅, i₂lɨ́n₅ lia'₂ lɨ́n₅ jan₂ i₁ju₂. ");
INSERT INTO cntNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jaun₂ ca₂né'₂ jág₁ guei'₅₄ a₂ca₂juá'₂: ―I₂la₂ bá₄ jón₃ quiáng₃ i₂ŋɨ́₄ lë₃ 'nióg₃ guë́₄ lɨn₃. 'E₂ bá₄ 'ŋio₂ dsɨ₃ quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Dsɨ₂juɨ₅ jaun₂ ca₂të₃ Jme₂dsí₂ quián₅ Diú₄ ca₂të́'₃ Jesús caun₂ 'uë₃ quein₂ co₂'ŋiog₅ ia₁jaun₂ ja₁jaun₂ cáun₂ táu₂ i₂së₃dsen₃. ");
INSERT INTO cntNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Të₂láu₃ jmɨg₄ të₂láu₃ nei₅, ca₂jme₃'ɨn₅₄ Jesús; cang₂ guë́₄ jaun₂ ca₂lë₃ i₁cón'₅ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jaun₂ ca₂jme₃quián₃ i₂së₃dsen₃ ja₁coin₂, a₂cáun₂ táu₂, jaun₂ ca₂juá'₂ tsɨ́'₅ Jesús: ―Chi₂jua'₂ dsón'₂ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄, jmo₄ juɨ₁le₅₄ i₁ŋí'₄ nɨ₁cang₁ tio'₅₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","La₁ ca₂ŋag₃ Jesús: ―Chi₁ton₅ ne₄ Si₂: “On₃jua'₅₄ jmá'₃ quian'₅₄ i₁ŋí'₄ le₃tan₅₄ dsa₂ mɨ₂güɨ́g₃ le₃chain₂, ján₃ bá₄ 'nió'₅ jme₃tan₅₄ dsa₂ quian'₅₄ ca₂le₃jë́₃ jág₁ a₂'uë'₂ mɨ₂'o₄ Diú₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ŋó₃ jaun₂, ca₂jiog₃ táng₃ i₂së₃dsen₃ të₂ juɨg₂ Jerusalén ciudad jŋió₅, jaun₂ ca₂jiog₃ të₂ guei'₅₄ guá'₅ templo ja₁ŋei₅ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ Jesús: ―Chi₂jua'₂ 'ne₂ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄, tian'₅₄ ja₁në₅; ia₁ juá'₂ ne₄ Si₂: Chen₃ Diú₄ ángeles quiáin₅ ia₁jaun₂ jmo₃ 'í₁; chó'₂ quian'₅₄ gu₂ ia₁jaun₂ tsá₃ jéng'₂ uɨg₅ nióg'₃ quian'₅₄ cang₄. ");
INSERT INTO cntNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jaun₂ ca₂ŋag₃ Jesús: ―Ján₃ bá₄ juá'₂ ne₄ Si₂: “Tsá₃ tang'₅₄ Te₁gui'₅₄ Diú₄ quiáng'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Con'₂ guë́₄ siá'₂ táng₃ ca₂jiog₃ i₂së₃dsen₃ juɨ₅ caun₂ má'₂ ja₁ŋei₅ 'ŋio₅ lɨn₃. Jaun₂ ca₂'ë₃ le₃jë́₃ juɨg₂ a₂cha₂ mɨ₂güɨ́g₃ quian'₅₄ ca₂le₃jë́₃ a₂jlá'₁ cha₂. ");
INSERT INTO cntNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jaun₂ ca₂tsɨ́'₃ Jesús: ―Dsia₅₄ jniá₂ gog'₂ 'ne₂ ca₂le₃jë́₃ a₂në₅, në₁jua'₂ ca₂chi₁jne'₄ ne₃ a₂jme₁juag'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jaun₂ në́₃ ca₂ŋag₃ Jesús: Guan'₂ Satanás, ia₁ ne₄ Si₂ juá'₂: “Jme₁juɨn'₂ Te₁gui'₅₄ Diú₄ quiáng'₂, jŋia'₅₄ lia'₂ ne₄ 'éi₂ bá₄ jme₁ti₁.” ");
INSERT INTO cntNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jaun₂ në́₃ ca₂ŋá'₃ i₂së₃dsen₃, jaun₂ ca₂o₃lén₂ ángeles ca₂jme₃ti₃ ta₁ ne₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jme₁ca₂rë₃ŋi₅ Jesús a₂'en₅₄ Juan₅₄ né'₃ 'má₃, jaun₂ ŋó₃ juɨ₅ 'uë₃ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tsá₃ ca₂jŋia₃ jë₄ juɨg₂ Nazaret, ŋó₃ bá₄ ca₂i₁'i₅ të₂ Capernaum, caun₂ juɨg₂ a₂niog₅ chei'₅₄ jmɨ₁ŋí'₄ 'uë₃ ja₁tén₄ Zabulón quian'₅₄ Neftalí. ");
INSERT INTO cntNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jaun₂ le₂në₅ ca₂rë₃ti₃ jág₁ a₂ca₂tó'₂ ne₄ si₂ Isaías i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄: ");
INSERT INTO cntNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","'Uë₃ ja₁tén₄ Zabulón quian'₅₄ Neftalí a₂niog₅ le₃quióng₄ Cuá₃ Jordán, chei'₅₄ jmɨ₁ŋí'₄, 'uë₃ Galilea le₃quió'₅ dsɨ₂nau₂: ");
INSERT INTO cntNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","dsa₂ i₂jme₁tián'₄ jë₄ qui₁né'₃ ma₂ca₂jág₃ caun₂ si₂ juë'₂; dsa₂ i₂jme₁tián'₄ 'uë₃ ja₁'ei₅ 'én'₁ 'mú₃, ne₄ quió'₅ ma₂ca₂'ág₂ si₂. ");
INSERT INTO cntNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Të₂le₃ ne₄ juɨ₅ jaun₂ ca₂jme₃lióg₃ Jesús ca₂'ë́₂ jág₁, ca₂juá'₂: ―Jein'₅₄ 'nia'₂ 'au'₂, ia₁ ma₂ja₂quián₃ guá₂ 'éi'₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Co₂ráun₂ ŋó₃ Jesús i₁ŋɨ₂ chei'₅₄ jmɨ₁ŋí'₄ Galilea. Ja₁jaun₂, ca₂jɨ́in₂ Si₂mu₅₄ i₂të́'₂ dsa₂ Pe₄, quiain'₅₄ dsó₂ rɨin'₅₄ i₂chen₂ Drë́₄. Dsa₂ i₂tsán'₂ ju₄ bá₄ 'éi₂, jaun₂ hora jaun₂ dé₄ në́₃ jme₁tioin'₅₄ táun₂ 'má₅ dsi₂jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jaun₂ ca₂juá'₂ Jesús: ―'Éin₃ jniá₂, jaun₂ cuë₅₄ ta₁ a₂chi₁liang'₂ dsa₂ mɨ₂güɨ́g₃, juɨ₁lia'₂ chi₂liáng'₁ ju₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂dsia₃ cau₅ 'má₅ quió'₅, jaun₂ i₃léin₂ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Me'₂ guë́₄ ne₄ juɨ₅ ja₁i₃léin₂ jaun₂, ca₂jɨ́in₂ con'₂ guë́₄ on₃ dsó₂: Jacobo quian'₅₄ Juan₅₄ rɨin'₅₄, ja₁ŋi'₅₄ Zebedeo. Jme₁tioin'₅₄ 'ŋió'₃ tsɨ₁mu₅ qui₂'méi₅ 'má₅ quió'₅, quiain'₅₄ jmei₂. Jaun₂ ca₂të₃ Jesús, ");
INSERT INTO cntNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","jaun₂ dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂tí₂ tsɨ₁mu₅ quió'₅ ca₂téin₂ jmei₂, jaun₂ ca₂i₃léin₂ ca₂jme₃quiain'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","I₂ŋɨ₅₄ Jesús le₂tan₅₄ 'uë₃ Galilea, qui₂jme₂tɨin₂₃ dsa₂ dsi₂néi₂ guá'₅ sinagogas lia'₂ caun₂ ja₁qui₂ŋɨ́i₅. Qui₂'ë́₂ jág₁ dse₃ juɨ₁lia'₂ ja₁gon₂ Diú₄, ján₃ bá₄ qui₂jme₂'lióin₂ dsa₂ ca₂le₃jë́₃ ne₅₄ dso₄ 'e₂ niog₅ lɨ́n₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Le₂tan₅₄ 'uë₃ Siria ca₂i₃'ág₃ jág₁ 'a₂ lia'₂ lë́₅ jmo₅ Jesús ŋɨ₂₃, jaun₂ ca₂o₃jŋia₃ dsa₂ ca₂le₃jɨ́n₃ dsa₂ i₂le₁quian₅ ca₂le₃jë́₃ ne₅₄ jmɨ₁uɨg₅, quian'₅₄ juɨ₁'ein₂ guë́₃ i₂quɨ'₂ uɨg₅ quió'₅. Ca₂i₁quiain₅₄ ca₂le₃jɨ́n₃ dsa₂ i₂tion'₅₄ jme₂dsí₂ je₂na'₅₄, dsa₂ i₂lɨ́n₅ dso₄ 'ei₂, quian'₅₄ dsa₂ 'lian'₂ në́₃. Ja₁jaun₂ ca₂jme₃'lión₂ Jesús ca₂le₃jɨ́n₃ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Juɨn₅ lɨn₃ dsa₂ i₂chan₂ Galilea, dsa₂ i₂chan₂ ta₁guia₃ juɨg₂ ja₁të́'₂ dsa₂ Decápolis, quian'₅₄ dsa₂ i₂chan₂ Jerusalén, dsa₂ i₂tián'₅ 'uë₃ Judea quian'₅₄ dsa₂ i₂tián'₅ le₂'ŋo'₅₄ Cuá₃ Jordán në́₃, ca₂jme₃quiong'₅₄ ca₂jme₃quiain'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jɨ́n₂ Jesús dsa₂ juɨn₅ 'éi₂, jaun₂ ca₂uɨ́g₂ caun₂ dsɨ₂con'₂ ja₁ŋei₅ guë́₄, jaun₂ ca₂guá₂. Jaun₂ ca₂ŋɨ'₂ dsa₂ i₂quiain'₅₄ le₃lág'₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jaun₂ ca₂jme₃lióg₃ ca₂jme₃tɨin₂₃ dsa₂, ca₂juá'₂ le₂la₂: ");
INSERT INTO cntNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―'E₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ i₂rë₂lí'₄ qui₂chi₁quiain₁₂ jmɨg₄ o₄quió'₄ jme₂dsí₂ quió'₅, ia₁ i₂le₂'éi₂ bá₄ ca₂tɨ́n₂ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’'E₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ i₂ta'₂ 'lia'₂ dsɨ́₅, ia₁ cuë₃ bá₄ Diú₄ lián'₂ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’'E₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ i₂jmo₅ me'₂, ia₁ gua'₅₄ 'uë₃ bá₄ tɨin₅₄, cuë₃ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’'E₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ i₂ŋɨ́₄ lë₃ 'ɨ́n₅ dsɨ́₅ jmo₃ a₂'ŋio₂ dsɨ́₅ Diú₄, ia₁ lë́₂ dsɨ́₅ në₂jag₄ bá₄ a₂i₁cón'₅, a₂rë₂quein₂ dsɨ́₅ në́₃; ia₁ 'ág'₄ bá₄ dsɨ́₅, jmo₃ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’'E₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ i₂ŋéi₂ dsɨ́₅ dsa₂ sián'₂, ia₁ dsia₃ bá₄ Diú₄ ŋéi₂ dsɨ́₅ guioin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’'E₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ i₂qui₂le₁jë́₃ dsɨ́₅, ia₁ jɨ́in₂ bá₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’'E₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ i₂quɨ́n'₅ bí₂ 'no'₂ juɨ₅ 'a₂ lia'₂ 'ag₃ tei₄, ia₁ quiong₃ Diú₄ chi'₂-guein₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’'E₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ i₂qui₂co₂'ein₅ dsa₂ 'uɨg₅₄ ia₁ a₂jmo₂₃ a₂'ŋio₂ dsɨ́₅ Diú₄, ia₁ ja₁gon₂ Diú₄ bá₄ ca₂tɨ́in₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’'E₂ guë́₄ dsen'₃ 'nia'₂, jë₁ma₂të́₂ rë₁qui₃jnáu'₂ dsa₂ jág₁, qui₂co₂jmóg'₂, a₂juá'₂ ca₂le₃jë́₃ ne₅₄ jág₁ a₂tsá₃ tí₅ ja₁con'₂ 'nia'₂ o₄quió₃ jniá₂; ");
INSERT INTO cntNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","jmo₄ 'nia'₂ 'io'₂, juɨ₁le₁'ág₄ bá₄ dse₃ 'au'₂, ia₁ guéi'₁ 'nia'₂ 'liang'₅₄ jó₄ guei'₅₄ i₂juɨ́g₃. Ia₁ le₂në₅ bá₄ ján₃ qui₂ca₂co₃'ein₃ dsa₂ quió'₅ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, i₂ma₂ca₂rë₃chán₃ le₂jŋiá₅ con'₂ guë́₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Tén'₅ 'nia'₂ ta₁ ne₄ gua'₅₄ 'uë₃ juɨ₁lia'₂ jmo₅ tsɨ₁ŋi₁ jë₄ má₃. La₁ në₁jua'₂ ma₂ca₂'en₃ ŋi'₅₄ tsɨ₁ŋi₁, ¿'a₂ bá₄ lia'₂ lé₂ le₃lei₂ táng₃? Tsá₃ ma₃'e₂ ta₁ jmo₃, a₂jŋia'₅₄ lia'₂ a₂dsɨ₃ga'₅₄ bá₄ jaun₂, qui₃tsó'₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ján₃ bá₄ rë₂jniá'₁ 'nia'₂ co₂'nió'₄ a₂lɨ́ng'₅ si₂ quió'₅ dsa₂ mɨ₂güɨ́g₃. Juɨ₁lia'₂ caun₂ juɨg₂ a₂niog₅ dsɨ₂con'₂ tsá₃ lé₂ le₃dsɨ₃'ma₄, ");
INSERT INTO cntNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ján₃ bá₄ tsá₃ guí'₅ dsa₂ si₂ caun₂ nɨ₁tsɨ́₅ a₂chi'₃ né'₃ tsɨ₁gu₅; guei'₅₄ bá₄ chi'₂ dsa₂ ia₁jaun₂ tág'₅ si₂ ja₁con₂ ca₂le₃jɨ́n₃ i₂tion'₅₄ dsi₂néi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Le₂në₅ bá₄ 'nia'₂ në́₃, jmo₄ tág₅ si₂ quiáng'₂ jɨn₄ dsa₂ mɨ₂güɨ́g₃, ia₁jaun₂ të₅₄ ne₄ dsa₂ a₂dse₃ a₂jmo'₂ 'nia'₂, jaun₂ jme₃juɨin'₂ Ŋéi'₅ 'nia'₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","'Tsá₃ o₁len'₂ 'nia'₂ jua'₅₄ a₂guio₃ jniá₂ a₂jŋiá'₄ Si₂ 'Éi'₃ quió'₅ Moisés, on₃ guë'₂ jág₁ a₂jme₁jme₂tag₅ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄. On₃jua'₅₄ ta₁ jaun₂ guio₃ jniá₂ a₂jŋiá'₄, të₂le₃ a₂jme₁'ŋia₅ bá₄ jniá₂ guio₃. ");
INSERT INTO cntNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ia₁ a₂dsɨ₂jó'₃ juá'₅ jniá₂, të₁lia'₂ niog₅ mɨ₂güɨ́g₃, të₁lia'₂ jniá₂ dsɨ₄ guei'₅₄ në₅, 'i₁caun₂ punto, on₃ guë'₂ 'i₁caun₂ letra pí'₁ quió'₅ Si₂ 'Éi'₃ tsá₃ dsɨ₃'én₂ ca₂lia'₂ ca₂rë₃ti₃ ca₂le₃jë́₃ a₂niog₅ lé₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","'Uɨg₅₄ jaun₂, juɨ₁lia'₂ i₂jmo₅ cau₅ caun₂ 'Éi'₃ Juá'₅ ne₄ Si₂ 'Éi'₃, o₁jŋia'₅₄ lɨ́in₂ caun₂ 'éi'₃ tsá₃ lɨn₄ quen₅, në₁jua'₂ le₂jaun₂ jme₁tɨin₂₃ dsa₂ rɨin'₅₄, le₂jaun₂ bá₄ lén₂ dsa₂ 'éi₂ jan₂ dsa₂ i₂tsá₃ lɨn₄ quen₅ ja₁gon₂ Diú₄. La₁ juɨ₁lia'₂ dsa₂ i₂nag₅ gau₂, jme₂ti₃, le₂jaun₂ jme₂tɨin₂₃ i₂sián'₂ në́₃, le₂jaun₂ bá₄ lén₂ dsa₂ 'éi₂ juɨin'₂ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ia₁ a₂dsɨ₂jó'₃ juá'₅ jniá₂ juɨ́g₂ 'nia'₂, në₁jua'₂ tsá₃ ca₂jmo'₅₄ 'nia'₂ a₂dse₃ guë́₄ con'₂ guë́₄ të₅juá'₅ quian'₅₄ dsa₂ fariseos, lia'₂ o₁lɨ́g'₂ jmɨg₄ tsá₃ lé₂ dsi₁no'₃ 'nia'₂ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ma₂ŋi'₅₄ bá₄ 'nia'₂ 'a₂ lia'₂ lë́₅ ma₂nág₂ dsa₂ can'₅₄ quián'₂ 'nia'₂: “Tsá₃ jŋɨ́g'₄ dsa₂, ia₁ në₁jua'₂ 'ein₂ ca₂jŋɨ'₃ rɨn'₅₄, tion₅₄ të₃dsɨ₅₄ bá₄ 'éi'₃ ja₁coin₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","La₁ jniá₂ juá'₅ juɨ́g₂ 'nia'₂, chi₂jua'₂ 'ein₂ ca₂rë₃'né₃ quian'₅₄ rɨn'₅₄, ján₃ bá₄ le₂jaun₂ jióg'₂ 'í₁ ja₁coin₂, të₃dsɨ₅₄ 'éi'₃. Ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ i₂të₂'on'₂ rɨn'₅₄, ne₄ dsɨ₂tan₅₄ quián₅ guá'₅ bá₄ dsi₁léin₂, la₁ juɨ₁lia'₂ i₂quian₅ tonto rɨn'₅₄, go'₂ 'liáin'₃ quióin'₄ dsi₂si₂ ja₁'lɨg'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Uɨg₅₄ jaun₂ në́₃, në₁jua'₂ dsi₂can'₅₄ 'e₂ dsi₂can'₅₄ ne₄chei₂, a₂jen'₅₄ ne₄ Diú₄, në₁ca₂dsáu'₃ 'au'₂ tsá₃ 'ei₅ caun₂ jág₁ quian'₅₄ rɨ́ng'₂, ");
INSERT INTO cntNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ja₁jaun₂ de'₂ dsia₄ a₂jaun₂ cau₅ ne₄chei₂, jaun₂ guë́₄ guan'₂ jme₁dsian₅ mɨ'₅₄ o₂'éi₂ caun₂ jág₁ quian'₅₄ rɨ́ng'₂. Jaun₂ guë́₄ ŋe'₅₄ táng₃ i₂dsia₄ a₂cuë'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Chi₂jua'₂ 'ein₂ 'nio₃ 'nag₃ ne₄ dsɨ₂tan₅₄, ŋi'₅₄ ta₁ 'nio'₂ juɨ₅ 'éi₂ caun₂ jág₁ quiain'₅₄ né'₃ a₂jmo₃ le₂jaun₂, ia₁jaun₂ tsá₃ jáng'₂ ne₄ dsɨ₂tan₅₄ i₂qui₂dsɨ₅ 'éi'₃; ia₁ dsɨ₂tan₅₄ në́₃, con'₂ tsá₃ ŋó₅ në₁ca₂jáng'₂ o₄gú₃ chi'₂ 'ɨ'₅₄; i₂'éi₂ guë́₄ në́₃ 'liog'₃ né'₃ 'má₃. ");
INSERT INTO cntNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A₂dsɨ₂jó'₃ juá'₅ jniá₂, tsá₃ a₁jaun₂ o₃'ɨng'₂ ja₁jaun₂ ca₂lia'₂ ca₂qui'₅₄ ca₂le₃jë́₃ 'a₂ con'₂ mɨ₅ dsa₂ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ma₂ŋi'₅₄ bá₄ 'nia'₂ ján₃ 'a₂ lia'₂ lë́₅ ma₂juá'₂ dsa₂ le₂jŋiá₅: “Tsá₃ nióg'₄ jág₁ quian'₅₄ dsa₂ on₃jua'₅₄ dsɨ₂i₂gog'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","La₁ jniá₂ guë'₂ juá'₅ juɨ́g₂ 'nia'₂, chi₂jua'₂ 'ein₂ dsɨ₂jiog₅ dsɨ́₅ 'lɨg'₅₄ qui₂jɨ́in₂ jan₂ dsa₂ mɨ́₂, co₂'nió'₄ ma₂në₂'nióg₂ dso₄ quiong'₅₄ juɨ₅ të₂dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Në₁jua'₂ mɨ₂ne'₅₄ jmo₅ a₂tang'₂ dso₄, co₂dsia₅ dsi₄, tiong₂ uɨ́ng₂; ia₁ dse₃ guë́₄ a₂dsɨ₃'én₂ ca₂jne₄ quiáng'₂, con'₂ guë́₄ jme₁o₁'ú'₃ ta₁jang'₂ ja₁'lɨg'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ján₃ bá₄ le₂në₅ në₁jua'₂ mɨ₂gog'₂ jmo₅ a₂tang'₂ dso₄, co₂dsia₅ ti₄, tiong₂ uɨ́ng₂; ia₁ dse₃ guë́₄ a₂dsɨ₃'én₂ ca₂jne₄ nɨ₁ŋɨ'₁ con'₂ guë́₄ jme₁o₁'ú'₃ ta₁jang'₂ ja₁'lɨg'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Ján₃ bá₄ ma₂juá'₂ dsa₂ le₂jŋiá₅: “Chi₂jua'₂ 'ein₂ ca₂tén₂ dsa₂ mɨ́₂ quián₅, ca₂tɨ́in₂ cho₃ caun₂ si₂ a₂jáng'₅ léi₄ a₂ma₂ca₂téin₂ dsón'₂ rɨin'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","La₁ jniá₂ juá'₅ juɨ́g₂ 'nia'₂, chi₂jua'₂ 'ein₂ ca₂tén₂ dsa₂ mɨ́₂ quián₅, on₃jua'₅₄ cha₂ 'uɨg₅₄, jua'₅₄ a₂ma₂nió'₅ jág₁ quian'₅₄ i₂sián'₂, jmo₂₃ a₂'no₃ 'io₅₄ quiáin₅ dso₄. Ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ dsa₂ ŋe'₂ i₂cán₂ 'io₅₄ i₂ma₂téi₂ dsa₂, ján₃ bá₄ le₂jaun₂ 'no₂₃ dso₄. ");
INSERT INTO cntNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Ma₂nei'₂ bá₄ 'nia'₂ ján₃, 'a₂ lia'₂ lë́₅ ca₂nág₂ dsa₂ can'₅₄ ma₂lɨ́g'₂: “Tsá₃ jmó'₂ jua'₅₄ a₂tsá₃ jme₁ti'₄ jág₁ quiáng'₂ a₂ma₂cuë'₅₄ a₂'ɨ́ng'₅ Te₁gui'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","La₁ jniá₂ juá'₅ juɨ́g₂ 'nia'₂ tsá₃ 'e₂ 'uɨg₅₄ cha₂ jua'₅₄ a₂'ɨ́ng'₄ Diú₄; tsá₃ 'ë́'₁ guei'₅₄ i₂juɨ́g₃, ia₁ ne₄ta₁ quió'₅ Diú₄ bá₄ jaun₂; ");
INSERT INTO cntNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","on₃ guë'₂ 'ë́'₁ gua'₅₄ 'uë₃, ia₁ co₂'nió'₄ ja₁tióng₂ tag₄ bá₄ Diú₄; on₃ guë'₂ 'nió'₅ 'ë́'₁ 'nia'₂ Jerusalén, ia₁ juɨg₂ quió'₅ Rag₅₄ Juɨn'₂ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tsá₃ lë₁'ë₂ 'nia'₂ mɨ₂dsei'₂ guiong'₅₄ në́₃, ia₁ 'i₁ca₂mɨ'₂ nɨ₁jŋi₂ dsei'₂ 'nia'₂ tsá₃ lé₂ le₃jmó'₂ tiog₂, on₃ guë́₄ a₂lia'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jua'₅₄ bá₄ 'nia'₂ quian'₅₄ ca₂jon₄ jág₁, “ján₅”, o₃ “jan₂'ón₄” 'e₂, ia₁ në₁jua'₂ 'ein₂ ca₂juá'₂ ŋag₅₄ guë́₄ con'₂ lë́₅ në₅, já₅ ja₁con₂ i₂së₃dsen₃ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ma₂nei'₂ bá₄ 'nia'₂ a₂ma₂juá'₂ dsa₂ le₂jŋiá₅: “Në₁jua'₂ 'ein₂ ca₂'én₂ ca₂mɨ́g₂ mɨ₂ne₄ rɨn'₅₄, le₂jaun₂ bá₄ lé₂ 'éi'₃ dsɨ₃'én₂ ca₂mɨ́g₂ mɨ₂ne₄ juɨ₁lia'₂ i₂ca₂jmo₃ ján₃; o₃ në₁jua'₂ 'ein₂ ca₂tia'₃ ca₂mɨ́g₂ mɨ₂jan₄ rɨn'₅₄ në́₃, le₂jaun₂ bá₄ lé₂ táng₃ 'éi'₃, tiá'₃ ca₂mɨ́g₂ quió'₅.” ");
INSERT INTO cntNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","La₁ jniá₂ guë'₂ juá'₅ juɨ́g₂ 'nia'₂, tsá₃ lë₁nau₂ 'nia'₂ queng'₂ quian'₅₄ dsa₂ 'lɨn'₅₄. Në₁jua'₂ 'ein₂ ca₂quein₃ rë₂jog'₂, jein'₅₄ të₂le₃ ca₂ton₂, juɨ₁quein₂₃ ta₁tɨn₃ ton₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chi₂jua'₂ 'ein₂ 'nag₅ quiáng'₂, a₂'nio₃ jŋiá'₂ nɨ₁tsɨ́n'₂, le₂jiog₅ tsɨ₁'mɨ'₂ dsiog₂ qui'₅₄ cuë'₅₄ juɨ₁quion₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Në₁jua'₂ 'ein₂ ca₂chi₃quióng₂ jmɨg₄ a₂caun'₅₄ lio₅₄ caun₂ kilómetro, o₂con₄ tɨn₃ kilómetros. ");
INSERT INTO cntNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Juɨ₁'ein₂ guë́₃ mɨ₅ 'e₂ mɨ₅ quiáng'₂ a₂dsi₂, cuë'₅₄; 'a₃ lë₁jein'₅₄ le₃mɨ₂ca'₅₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ján₃ bá₄ ma₂nei'₂ 'nia'₂ a₂ma₂juá'₂ dsa₂ le₂jŋiá₅: “Jme₁'nió₄ a₂mei₅₄ quiáng'₂, jme₁'ŋia₅₄ juɨ₁lia'₂ dsa₂ i₂'iog₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","La₁ jniá₂ guë'₂ juá'₅ juɨ́g₂ 'nia'₂: Jme₁'nió₄ bá₄ 'nia'₂ juɨ₁lia'₂ dsa₂ i₂'iog₅₄, mɨ₄ ne₄ Diú₄ o₄quió'₄ juɨ₁lia'₂ dsa₂ i₂co₂'ein₅. ");
INSERT INTO cntNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jaun₂ le₂në₅ bá₄ a₂rë₂jniá'₁ 'nia'₂ a₂lɨ́ng'₅ chi'₂-guein₂ quián₅ Ŋéi'₅ i₂guá₅ guei'₅₄ i₂juɨ́g₃; ia₁ 'éi₂ bá₄ cuë₅ 'iog₂ cuë́'₅ lia'₂ dsa₂ 'lɨn'₅₄ lia'₂ dsa₂ dsen₃; ján₃ bá₄ chein₁₂ jmɨ́₅ cuë́'₅ lia'₂ dsa₂ i₂cuɨn₅ Diú₄ lia'₂ dsa₂ i₂tsá₃ Diú₄ cuɨn₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ia₁ në₁jua'₂ 'nió'₃ 'nia'₂ jmá'₃ lia'₂ dsa₂ i₂'nio₃ 'nia'₂, ¿'e₂ 'lian'₅₄ 'nia'₂ guéi'₁ le₂jaun₂? Le₂jiog₅ dsa₂ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄ tɨn₂ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Chi₂jua'₂ cuɨ́n'₅ 'nia'₂ Diú₄ jmá'₃ lia'₂ dsa₂ rɨ́ng'₂, ¿'e₂ a₂ŋag₅₄ guë́₄ a₂dse₃ jmo'₂ 'nia'₂ në₁jua'₂ le₂jaun₂? Ia₁ le₂në₅ bá₄ jmo₅ dsa₂ i₂tsá₃ Diú₄ cuɨn₅ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Juɨ₁dsi₂can'₅₄ bá₄ 'nia'₂ a₂dsi₁nóg'₅ léng'₂ dsa₂ dsen₃ juɨ₁lia'₂ dsen₃ Ŋéi'₅ 'nia'₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Jmo₄ 'nia'₂ 'í₁ tsá₃ lë₁jmo₂ 'nia'₂ a₂lɨ́ng'₅ dsa₂ dsen₃ jŋia'₅₄ lia'₂ jmá'₃ jë₄ jág₃ dsa₂. Në₁jua'₂ le₂në₅ jmo'₂ 'nia'₂, Ŋéi'₅ 'nia'₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃ tsá₃ 'e₂ 'lian'₅₄ 'nia'₂ cuë₃ 'i₁caun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’'Uɨg₅₄ jaun₂, jë₁ma₂të́₂ rë₁jme₁'on'₁ 'nia'₂ 'ein₂ jme₁'ong'₁ juɨ₁lia'₂ i₂'nió'₅ quió'₅, tsá₃ jmó'₂ jua'₅₄ uɨ́ng₂ ma₂dsɨ₂'ag₅ jág₁ juɨ₁lia'₂ jmo₅ dsa₂ i₂lë₁jmo₅ o₁ne₁ dsi₂néi₂ guá'₅ sinagogas juɨ₁lia'₂ jë₄ calles në́₃. Jmo₂₃ le₂jaun₂ a₂chein'₂ dse₃ guioin₅₄ ia₁jaun₂ 'ag₃ dsa₂ dse₃; la₁ia₁ a₂të₃dsón'₂ juá'₅ jniá₂ i₂ma₂gue₃ 'lian'₅₄ bá₄ i₂le₂'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","La₁ 'ne₂ në́₃, jë₁ma₂të́₂ rë₁jme₁'ong'₁ juɨ₁lia'₂ 'ein₂ jme₁'ong'₁, jmo₄ ca₂lia'₂ jŋia'₅₄ a₂mei₅₄ dsen₃ quiáng'₂ tsá₃ ŋi₅. ");
INSERT INTO cntNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ja₂lɨn₃ guë́₄ dse₃ jmó'₂ jë₄ të₃co'₅₄. Jaun₂ Ŋéi'₅ i₂jág₅ a₂dse₃ jmo'₂ jë₄ të₃co'₅₄ jaun₂, cuë₃ 'liang'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Jë₁ma₂të́₂ rë₁chi₁len'₄ 'nia'₂ Diú₄, tsá₃ lë₁jmo₂ 'nia'₂ juɨ₁lia'₂ jmo₅ dsa₂ i₂lë₁jmo₅-dsáu₅ o₁ne₁, a₂të₅ dsɨ́₅ chi₂léin'₂ Diú₄ të₃ tióin₂ dsi₂néi₂ guá'₅ sinagogas jë₄ calles në́₃, ia₁jaun₂ jág₃ dsa₂. A₂dsɨ₂jó'₃ juá'₅ jniá₂, i₂ma₂gue₃ 'lian'₅₄ bá₄ i₂le₂'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","La₁ jë₁ma₂të́₂ rë₁mɨ́'₁ 'ne₂ ne₄ Diú₄, jne₅₄ dsi₂néi₂ quiáng'₂. Ja₁jaun₂ chi₁len'₄ 'ne₂ Diú₄ Ŋéi'₅ i₂tsá₃ jniá₂. Jaun₂ në́₃ Ŋéi'₅ i₂ŋi₅ 'e₂ a₂jmo'₂ jë₄ të₃co'₅₄, cuë₃ 'liang'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Jë₁ma₂të́₂ rë₁juɨg'₅₄ Diú₄, tsá₃ jmó'₂ 'nia'₂ jua'₅₄ a₂lë₁të₁'ɨ́'₁ jág₁ a₂tsá₃ ta₁ tí₄, juɨ₁lia'₂ jmo₅ dsɨ₂nau₂ i₂tsá₃ 'én₂, ia₁ lɨ́in₂ nag₃ Diú₄ të₂le₃ ia₁ a₂'lióng₂ jág₁ juá'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tsá₃ lë₁o₁len'₅₄ 'nia'₂ juɨ₁lia'₂ lɨ́n₅ dsa₂ le₂'éi₂. Ia₁ i₂ma₂ŋi₅ bá₄ Ŋéi'₅ 'nia'₂ 'e₂ a₂'nió'₅ quián'₂ 'nia'₂ né'₃ guë́₄ a₂mɨ́'₁. ");
INSERT INTO cntNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jaun₂ në́₃, le₂la₂ bá₄ juɨg'₅₄ 'nia'₂ Diú₄: Tia₅₄ quián₂ jniog₄, 'ne₂ i₂ŋéi'₂ guei'₅₄ i₂juɨ́g₃, juɨ₁jme₂go₃ bá₄ dsa₂ a₂rë₂jŋió₄ a₂cheng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Juɨ₁le₅₄ bá₄ 'éi'₃ quiáng'₂, juɨ₁le₅₄ bá₄ a₂'ŋio₂ 'au'₂ 'ne₂ ne₄ gua'₅₄ 'uë₃, juɨ₁lia'₂ lë́₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cuë₄ a₂'nió'₅ que₅₄ jnia'₅₄ jmɨg₄ në₃. ");
INSERT INTO cntNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","'Én₃ dso₄ quián₂ jnia'₅₄, juɨ₁lia'₂ 'én₅ jnia'₅₄ dsáu₁ rɨn'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","'A₃ cuë₂ jmɨg₄ jiá₃ juɨ₅bí₂ a₂cáun₂ táu₂, të₂le₃ lio₄ bá₄ o₄gú₃ i₂së₃dsen₃. ");
INSERT INTO cntNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Ia₁ në₁jua'₂ 'én'₅ 'nia'₂ dsáu₁ rɨ́ng'₂ jë₁ma₂'náu₂ dso₄ ja₁cong'₂, ján₃ bá₄ le₂jaun₂ Ŋéi'₅ 'nia'₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃ 'éin₂ dsáu'₂ 'nia'₂ guiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","La₁ në₁jua'₂ tsá₃ 'éng'₅ dsáu₁ rɨ́ng'₂, ján₃ bá₄ le₂jaun₂ tsá₃ 'én₂ Ŋéi'₅ dsáu'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Jë₁ma₂të́₂ rë₁jme₁'ɨn'₄ 'nia'₂, tsá₃ jme₁tsɨ́n₄ 'nia'₂ o₄-ne'₅₄ jua'₅₄ a₂jmó'₂ lë₁'ág₄ 'lia'₂ 'au'₂ juɨ₁lia'₂ jmo₅ dsa₂ i₂lë₁jmo₅-dsáu₅ o₁ne₁. Jmo₅ dsa₂ le₂'éi₂ le₂jaun₂ ia₁jaun₂ jág₃ dsa₂ a₂dsón'₂ bá₄ jme₂'ɨin₅₄. A₂dsɨ₂jó'₃ juá'₅ jniá₂, i₂ma₂gue₃ 'lian'₅₄ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","La₁ 'ne₂ në́₃, jë₁ma₂të́₂ rë₁jme₁'ɨng'₄, sio₅ rë₂ dsei'₂, rang₂ ne'₅₄ në́₃, ");
INSERT INTO cntNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ia₁jaun₂ tsá₃ 'ein₂ le₃lí'₄ a₂jme₂'ɨng'₄. Jŋia'₅₄ lia'₂ Ŋéi'₅ i₂tsá₃ jniá₂ bá₄ ŋi₅. Jaun₂ Ŋéi'₅ i₂jág₅ ca₂le₃jë́₃ a₂jmo'₂ jë₄ të₃co'₅₄ jaun₂, 'éi₂ bá₄ cuë₃ 'liang'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Tsá₃ lë₁dsia₂ 'nia'₂ lo'₂ le₁má'₂ a₂jmo'₂ 'nia'₂ a₂quen₅ lɨn₃ quiáng'₂ ne₄ gua'₅₄ 'uë₃ la₂, ia₁ ja₁lá₃ ja₁lë₁qui₂rë₂juɨ₁ tón'₅ i₁cá₁ qui₂'éin₂, ján₃ bá₄ ja₁lá₃ ja₁qui₂dsɨ₂'én₂ qui₂rë₃'áu₁ cosas në́₃; ja₁lá₃ bá₄ chan₂ dsa₂ qui₂juɨin₂₃ 'e₂ qui₂juɨin₂₃ a₂tóin'₅ 'ang₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Guei'₅₄ i₂juɨ́g₃ bá₄ 'nió'₅ dsiá'₁ 'nia'₂ lo'₂ quiáng'₂, ja₁tsá₃ 'e₂ lé₂ jua'₅₄ a₂qui₃'én₂ cá₁, on₃ guë'₂ 'e₂ rë₂'áu₁, on₃ guë́₄ lé₂ dsɨ₃ton'₅₄ 'ang₂. ");
INSERT INTO cntNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ia₁ juɨ₁lia'₂ jë₁tio'₅₄ a₂quen₅ quiáng'₂, ja₁jaun₂ bá₄ 'i₄ a₂'ɨ₅ 'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Lë́₅ jme₁ne₁ dsa₂ juɨ₁lia'₂ lë́₅ caun₂ si₂ nɨ₁tsɨ́₅ quió'₅ nɨ₁ŋɨ₁ dsa₂; 'uɨg₅₄ jaun₂ në́₃, në₁jua'₂ dse₃ jme₁ne'₁, ján₃ bá₄ le₂jaun₂ co₂'nió'₄ tág₅ bá₄ si₂ ta₁jang'₂; ");
INSERT INTO cntNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","la₁ në₁jua'₂ tsá₃ dse₃ jme₁ne'₁, ta₁jang'₂ bá₄ lë́₅ qui₁né'₃. Në₁jua'₂ si₂ quiáng'₂ në́₃, chí'₅ chi₁liá'₃, ¡'e₂ guë́₄ 'ŋio₅ juë'₂ lë́₅ qui₁né'₃ në₁jua'₂ le₂jaun₂! ");
INSERT INTO cntNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’'I₁jan₂ tsá₃ 'ein₂ lé₂ jme₃ti₃ ta₁ ne₄ on₃ juɨg₅₄; ia₁ jme₃'ŋiai₅₄ jan₂, i₂jan₂ guë'₂ jme₃'nioi₃. O₃ náu₃ tiá₂ quian'₅₄ jan₂, i₂jan₂ guë'₂ tsá₃ le₃jein₅₄. Tsá₃ 'ein₂ lé₂ jme₃ti₃ ne₄ Diú₄, le₂jiog₅ ne₄ a₂'ɨ́n₅ dsɨ́₅ cu₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Jaun₂ në́₃ juɨ́g₂ jniá₂ 'nia'₂: Tsá₃ lë₁can₂ 'nia'₂ o₂i₁ dsɨ₅ jua'₅₄ a₂ŋɨ́₄ 'ɨ₅ 'au'₂ 'e₂ quë'₅₄, o₃ 'e₂ 'ag'₅₄ të₁lia'₂ chang'₂, on₃ guë'₂ o₄quió'₄ nɨ₁ŋɨ'₁ 'nia'₂, 'e₂ 'mɨ'₂ a₂quɨ'₅₄. ¿Tsa₁ quen₅ guë́₄ jme₂dsí₂ a₂chan₂ dsa₂ lia'₂ con'₂ guë́₄ má₃? ");
INSERT INTO cntNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jɨn₄ de'₂ 'nia'₂ juɨ₁lia'₂ i₁tan₅ i₂i₂nio₄ guei'₅₄: tsá₃ 'e₂ jne₂₃, on₃ guë'₂ 'e₂ cág'₅, jua'₅₄ a₂dsia₂₃ lo'₂; la₁ Ŋéi'₅ 'nia'₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃ qui₂jme₂tau₅₄. Jaun₂ në́₃, ¿Tsa₁ quen'₅ guë́₄ 'nia'₂ lia'₂ con'₂ guë́₄ já'₂ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿'Ein₂ 'nia'₂, të₂le₃ ia₁ a₂ŋɨ́₄ 'ɨ₅ 'au'₂, lé₂ le₃jmó'₂ 'nia'₂ a₂lé₂ le₃chang'₂ caun₂ hora ŋag₅₄ guë́₄? ");
INSERT INTO cntNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿'E₂ 'uɨg₅₄ a₂ŋɨ́₄ lë₃ 'ɨ₅ 'au'₂ 'nia'₂ juɨ₁lia'₂ o₄quió'₄ 'mɨ'₂ a₂quɨ'₅₄? Jag₄ de'₂ 'nia'₂ juɨ₁lia'₂ 'a₂ lia'₂ dsɨ₂cón₃ lí₁ a₂cha₂ ja₁nau₂; on₃jua'₅₄ i₂jmo₅ ta₁ 'ua'₂, on₃ guë'₂ 'me₂₃; ");
INSERT INTO cntNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","la₁ juɨ́g₂ jniá₂ 'nia'₂, ca₂lia'₂ jŋia'₅₄ Rag₅₄ Salomón lia'₂ con'₂ jme₁quɨ́'₅ tsɨn'₅₄ a₂jlá'₁ guë́₄, tsá₃ ca₂rë₃jláin'₁ juɨ₁lia'₂ jlá'₁ lí₁. ");
INSERT INTO cntNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jaun₂ në́₃, chi₂jua'₂ Diú₄ le₂në₅ jmo₂₃ jlá'₁ nau₂ a₂cha₂ jmɨg₄ në₃, la₁ 'ióg₃ guë'₂ dsɨ₃'én₂ dsi₂si₂, ¡'ë₂ guë́₄ bá₄ 'nia'₂ dsa₂ tsá₃ lɨn₄ 'én₂ jmo₃ 'í₁ qui₃chein'₃ 'nia'₂ dse₃! ");
INSERT INTO cntNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jaun₂ le₂në₅, tsá₃ lë₁can₂ 'nia'₂ o₂i₁ dsɨ₅, jua'₅₄ a₂qui₁ŋag'₅₄ 'nia'₂: “¿'E₂ que₅₄ jniog₄?” o₃ “¿'E₂ 'ne'₅₄ jniog₄?” o₃ “¿'E₂ 'mɨ'₂ qui'₅₄ jniog₄?” ");
INSERT INTO cntNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ia₁ dsa₂ mɨ₂güɨ́g₃ bá₄ i₂nio₄ qui₂'en₅ 'ɨ́n₅ dsɨ́₅ ca₂le₃jë́₃ a₂në₅. I₂ŋi₅ bá₄ Ŋéi'₅ 'nia'₂ i₂guá₅ guei'₅₄, a₂'nió'₅ quián'₂ 'nia'₂ le₃jë́₃ a₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","La₁ jmo₄ de'₂ jŋiá₅ 'nia'₂ 'ɨ́n₅ 'au'₂ a₂jiá₃ 'éi'₃ quió'₅ Diú₄ ja₁cong'₂, quian'₅₄ a₂jmó'₂ 'nia'₂ ca₂le₃jë́₃ a₂dse₃ a₂të₅ dsɨ́₅ 'éi₂, jaun₂ guë́₄ guéi'₁ 'nia'₂ le₃jë́₃ a₂në₅ a₂ŋag₅₄ guë́₄. ");
INSERT INTO cntNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tsá₃ lë₁can₂ 'nia'₂ o₂i₁ dsɨ₅ jaun₂, o₄quió'₄ jmɨg₄ 'ióg₃, ia₁ jma₃quén₅ o₂i₁ dsɨ₅ cha₂ bá₄ lia'₂ co₂jmɨg₄ lia'₂ co₂jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Tsá₃ lë₁cáun₂ 'nia'₂ 'í₁ quió'₅ rɨ́ng'₂, ia₁jaun₂ tsá₃ con₂ Diú₄ 'í₁ ja₁con'₂ 'nia'₂ guiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ia₁ le₂në₅ bá₄ con₂ Diú₄ 'í₁ ja₁con'₂ 'nia'₂ guiong'₅₄ juɨ₁lia'₂ cáun'₂ 'nia'₂ 'í₁ ja₁con₂ rɨ́ng'₂. Quian'₅₄ 'éi'₃ a₂dsia'₂ 'nia'₂, 'éi'₃ jaun₂ bá₄ dsiog₃ Diú₄ quián'₂ 'nia'₂ guiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","’¿'A₂ lia'₂ jniag'₃ 'ne₂ jag'₅₄ jme₁qui₅ pí'₁ a₂'i₄ jme₁ne₁ rɨ́ng'₂, ton'₂ tsá₃ leng'₅₄ guë'₂ a₂'i₄ ca₂'nau₅₄ nɨ₁chá₅ pa₁ jme₁ne'₁ 'ŋiag'₂? ");
INSERT INTO cntNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿O₃ 'a₂ lia'₂ lé₂ le₃juɨg'₅₄ rɨ́ng'₂: “Cuë₄ jmɨg₄ dsi₄ jniá₂ jme₁qui₅ pí'₁ a₂'i₄ jme₁ne'₁,” ton'₂ në₅ bá₄ chi₁'i₁ ca₂'nau₅₄ nɨ₁'ma₂ chá₅ jme₁ne'₁ 'ŋiag'₂? ");
INSERT INTO cntNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡'Ne₂ dsa₂ i₂lë₁jmo₅ o₁ne₁! Dsi₄ de'₂ jŋiá₅ nɨ₁'ma₂ chá₅ mɨ₂ne'₅₄ 'ŋiag'₂, jaun₂ guë́₄ lé₂ le₃jag'₅₄ rë₂, jaun₂ guë́₄ lé₂ dsí'₁ qui₅ pí'₁ jme₁ne₁ rɨ́ng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Tsá₃ cuë'₂ 'nia'₂ juɨ₁lia'₂ dsɨ₂jɨ'₅₄ a₂lë́₅ a₂jŋió₅ quió'₅ jme₂dsí₂, ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ ja₂dsɨ́in₂ a₂jmo₃ le₁juɨg₁ quiáng'₂. Ján₃ bá₄ tsá₃ dsia₂ 'nia'₂ juɨ₁lia'₂ mɨ́g₂ jlá'₁ a₂quen₅ quiáng'₂ ne₄ i₁ŋí₅, con'₂ tsá₃ ŋó₅ në₁jua'₂ qui₂ca₂tsó'₃, jme₃'ióg₃. ");
INSERT INTO cntNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Mɨ₄ 'nia'₂ ne₄ Diú₄, jaun₂ guéi'₁ 'nia'₂; 'nio'₂ 'nia'₂, jaun₂ bá₄ dsiang'₂; té₃ 'nia'₂ o₄'né₄, jaun₂ bá₄ niá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ia₁ juɨ₁lia'₂ i₂mɨ₅, gue₃ bá₄; juɨ₁lia'₂ i₂'no'₂, dsio'₂ bá₄ ján₃; ján₃ bá₄ le₂jaun₂, quió'₅ juɨ₁lia'₂ i₂të́₂ o₄'né₄, niá₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿O₃ chan₂ juɨ₁lia'₂ 'ein₂ 'nia'₂, jme₁mɨ₅ chi'₂ quiáng'₂ i₁ŋí'₄, cuë'₂ 'nia'₂ ca₂mɨ́g₂ nɨ₁cang₁? ");
INSERT INTO cntNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O₃ chan'₂ 'nia'₂ jë₁ma₂ca₂mɨ₃ chi'₂ quiáng'₂ quió'₅ ju₄, cuɨ́in'₄ 'nia'₂ dsɨ₂mɨ'₂? ");
INSERT INTO cntNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jaun₂ në́₃, chi₂jua'₂ 'nia'₂ dsa₂ i₂rë₂cán'₄ dso₄ tɨng'₂ cuë'₂ cosa dse₃ chi'₂-guein₂ quiáng'₂, ¡'ë₂ guë́₄ bá₄ Ŋéi'₅ 'nia'₂ i₂guá₅ guei'₅₄ cuë₃ a₂dse₃ cuë́'₃ juɨ₁lia'₂ i₂mɨ₅ ja₁coin₂! ");
INSERT INTO cntNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’'Uɨg₅₄ jaun₂ në́₃, jmo₄ bá₄ 'nia'₂ quian'₅₄ dsa₂ mɨ₂güɨ́g₃ rɨ́ng'₂ juɨ₁lia'₂ 'e₂ a₂'niog'₂ 'nia'₂ jmo₃ 'éi₂ quian'₅₄ 'nia'₂; ia₁ a₂në₅ bá₄ ta₁ quí'₅ ca₂le₃jë́₃ Si₂ 'Éi'₃, quian'₅₄ guë́₄ Si₂ a₂qui₂ca₂jmo₃ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Tión'₂ 'nia'₂ të₂le₃ o₄juɨ₅ dsag₂. Ia₁ a₂'ɨ́₂ juë'₂ bá₄ ja₁dsɨ₂ton'₅₄ dsa₂ juɨ₅ a₂jiog₅ ja₁dsɨ₃'éin₂. Ja₂lɨn₃ guë́₄ juɨn₅ dsa₂ i₂dsɨ₂ton'₅₄ juɨ₅ jaun₂; ");
INSERT INTO cntNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ia₁ caun₂ o₄juɨ₅ dsag₂ rë₂quɨ́'₅ bá₄ ja₁i₂nio₄ dsa₂ a₂dsi₁lein₅ ja₁le₃chan₂ jme₂dsí₂, jaun₂ tsá₃ lɨn₄ juɨn₅ i₂dso'₂ juɨ₅ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Jmo₄ 'nia'₂ 'í₁ jaun₂ tsá₃ jme₃gau₅ dsa₂ i₂i₂nio₄ 'ë́₂ jág₁ a₂juɨ₁gain₂, i₂ja₂lén₂ ja₁con'₂ 'nia'₂ qui₂rë₂lɨin₅₄ a₂lɨ́in₅ já'₂ cha'₂, la₁ të₂le₃ né'₃ të₂dsɨ́₅ lɨ́in₅ juɨ₁lia'₂ lɨ́n₅ dsɨ₂jɨ'₅₄ náu₂ tsau₂ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","La₁ të₂le₃ 'a₂ lia'₂ jmo₅-dsáu₅ bá₄ le₃cuɨin'₂ 'nia'₂; ia₁ tsá₃ guei'₅₄ chi₁uɨ́ng₃ taun₅ quɨn₅ dsa₂ juɨ₁lia'₂ mɨ́g₂ uvas. On₃ guë'₂ lé₂ le₃quɨn₃ dsa₂ mɨ́g₂ higos guei'₅₄ 'ma₂ taun₅ jmɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jaun₂ në́₃, ca₂le₃jë́₃ 'ma₂ dse₃, mɨ́g₂ dse₃ bá₄ 'ag₅; ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ nɨ₁'ma₂ 'lɨg'₅₄, mɨ́g₂ 'lɨg'₅₄ bá₄ 'ag₅. ");
INSERT INTO cntNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Juɨ₁lia'₂ nɨ₁'ma₂ dse₃, tsá₃ lé₂ le₃'ag₃ mɨ́g₂ 'lɨg'₅₄; ján₃ guë'₂ le₂jaun₂ tsá₃ lé₂ le₃'ag₃ mɨ́g₂ dse₃ juɨ₁lia'₂ nɨ₁'ma₂ 'lɨg'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ca₂le₃jë́₃ nɨ₁'ma₂ a₂tsá₃ 'ag₅ mɨ́g₂ dse₃, jŋia'₅₄ lia'₂ a₂uɨ́n'₂ bá₄, dsɨ'₂ dsi₂si₂. ");
INSERT INTO cntNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jaun₂ le₂në₅ bá₄ le₃cuɨin'₂ 'nia'₂: të₂le₃ 'a₂ lia'₂ lë́₅ jmo₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Tsá₃ ca₂le₃jɨ́n₃ i₂të́₂ jniá₂: “Te₁gui'₅₄, Te₁gui'₅₄,” dsi₁lein₅ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄; jŋia'₅₄ lia'₂ jmá'₃ i₂jmo₅ a₂'ŋio₂ dsɨ́₅ Ŋe'₃ i₂guá₅ guei'₅₄ bá₄ dsi₁len₅. ");
INSERT INTO cntNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Juɨn₅ dsa₂ lé₂ jmɨg₄ jaun₂ i₂juá'₂ tság₃ jniá₂: “Te₁gui'₅₄, Te₁gui'₅₄, ma₂qui₂ca₂'ë́₄ jnia'₅₄ jág₁ o₄quián'₂ 'ne₂. Quian'₅₄ bí₂ 'éi'₃ quiáng'₂ në́₃, ma₂qui₂ma₂'uɨn'₅₄ jnia'₅₄ je₂na'₅₄, ma₂qui₂ma₂jmó₁ jnia'₅₄ 'lióng₂ léi₄ juë'₂ në́₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","La₁ jaun₂ guë́₄ në́₃ juɨg₅₄ jniá₂: “O₁lɨ́g'₂ tsá₃ 'nia'₂ ca₂rë₃cuɨ́ng₅. Cau₅ jŋia'₃ 'nia'₂ i₂jmo'₂ a₂'lɨg'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Jaun₂ në́₃, ca₂le₃jɨ́n₃ juɨ₁lia'₂ dsa₂ i₂nag₅ jág₁ quió₃, jmo₂₃ a₂juɨ́g₂ jniá₂, lɨ́in₅ juɨ₁lia'₂ lɨ́n₅ jan₂ dsa₂ i₂ŋɨ́'₂ dsɨ́₅ i₂ca₂jmóg'₃ 'ne₄ ne₄ 'lau₂. ");
INSERT INTO cntNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ca₂já₃ jmɨ́₅, qui₂ca₂juë'₂ jmɨg₂ cuá₃, ca₂'ág₂ dsí₂ tiá₂ lɨn₃ ca₂jnáu₃ 'né₅ jaun₂; la₁ tsá₃ ca₂quɨ'₃, ia₁ jme₁chí'₄ bá₄ 'uɨg₅₄ ne₄ 'lau₂. ");
INSERT INTO cntNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","La₁ ca₂le₃jɨ́n₃ juɨ₁lia'₂ dsa₂ i₂nag₅ jág₁ quió₃, tsá₃ jmo₂₃ guë'₂ a₂juɨ́g₂ jniá₂, lɨ́in₅ juɨ₁lia'₂ lɨ́n₅ jan₂ dsa₂ co₄ i₂tsá₃ 'en₅₄ dsɨ́₅, ca₂chi'₃ 'né₅ quió'₅ ne₄ ti₁tsag₁. ");
INSERT INTO cntNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jme₁ca₂já₃ jmɨ́₅, ca₂juë'₂ jmɨg₂ cuá₃, ca₂'ág₂ dsí₂ tiá₂ ca₂jnáu₃ dso'₂ tsɨ₁'né₅ jaun₂; jaun₂ ca₂quɨ'₃ ca₂gon₃ gau₂ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jme₁ca₂lë₃ juá'₂ Jesús jág₁ le₂në₅, 'ŋio₅ lɨn₃ qui₂dsɨ₂gó'₃ dsɨ́₅ dsa₂ 'a₂ lia'₂ lë́₅ jág₁ a₂jme₂tag₂₃, ");
INSERT INTO cntNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ia₁ jme₂tag₂₃ juɨ₁lia'₂ jan₂ i₂quian₅ 'éi'₃ dsón'₂, on₃jua'₅₄ rë'₂ lia'₂ të₅juá'₅ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jme₁ca₂sión₃ Jesús má'₂, juɨn₅ lɨn₃ dsa₂ jme₂quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jaun₂ ca₂jme₃quián₃ jan₂ dsa₂ dso'₅₄ i₂lɨ́n₅ 'mé'₅ 'iog₅, ca₂chi₃jné₃ ne₄ Jesús, jaun₂ ca₂juá'₂: ―Chi₂jua'₂ 'niog'₂ 'ne₂, Te₁gui'₅₄, lé₂ bá₄ jme₁'lio'₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jaun₂ Jesús në́₃ ca₂néi'₃ gu₂, ca₂jŋa'₃ quió'₅ dsa₂ 'éi₂, jaun₂ ca₂juá'₂: ―'Nio₃ bá₄ jniá₂. Jme₁'liong₅₄ 'ne₂. Dsɨ₂juɨ₅ jme₁ca₂juá'₂ le₂në₅, ca₂'lón₂ dsa₂ 'éi₂ 'mé'₅ 'iog₅ a₂jme₁lɨ́in₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jaun₂ ca₂juá'₂ Jesús: ―Në₃ jaun₂, tsá₃ lë₁'ein₂ juɨg'₂ 'i₁jan₂; jŋia'₅₄ lia'₂ guan'₂ o₂jme₁jnia₅ ne₄ jme₂dsa₂, jaun₂ o₂jen'₅₄ a₂'nió'₅ jme₁ti'₄ con'₂ lë́₅ 'Éi'₃ quió'₅ Moisés, ia₁jaun₂ le₃ŋi₅ dsa₂ a₂ma₂le₁jɨ́ng'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jme₁ca₂'í₃ Jesús jë₄ juɨg₂ Capernaum, ca₂jme₃quián₃ jan₂ juɨg₅₄ 'lióg₂ romano coin₂, jaun₂ ca₂mɨ₃ a₂jme₃'o₅₄ 'éi₂, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―Te₁gui'₅₄, jan₂ dsó₂ i₂jme₂ti₃ ta₁ ne₃, ron₅ dso'₅₄ ŋág₅ uɨg₅ ja₁quió₃; a₂'ua'₂ quió'₅, tsá₃ lé₂ jë́'₂ gu₂-tag₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jaun₂ ca₂juá'₂ Jesús: ―Nei₅₄ bá₄ jniá₂ i₁jme₁'lioin₁₂. ");
INSERT INTO cntNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jaun₂ ca₂ŋag₃ juɨg₅₄ 'lióg₂: ―Te₁gui'₅₄, tsá₃ ca₂tɨ́n₂ jniá₂ jua'₅₄ o₁'ú'₃ 'ne₂ dsi₂néi₂ quió₃; jŋia'₅₄ lia'₂ a₂jme₁jmó'₂ 'éi'₃ bá₄, jaun₂ 'lión₂ dsa₂ 'éi₂ quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ia₁ le₂në₅ bá₄ jniá₂ 'ŋió₃, chéng'₅ a₂jme₂ti₅₄ 'éi'₃ quió'₅ juɨg₃, ján₃ bá₄ le₂në₅ te₁neg'₅₄ 'lióg₂ i₂niog₅ gu₃, 'e₂ caun₂ 'nio₃ jniá₂ lé₂. Në₁jua'₂ ca₂juɨ́g₂ jniá₂: “Gua₂ jó₄”, ja₁jaun₂ dsó₃ bá₄; në₁jua'₂ ca₂juɨ́g₂ jniá₂ i₂sián'₂ guë'₂ táng₃: “Ŋia₅”, jiá₃ bá₄. Në₁jua'₂ ca₂juɨ́g₂ jniá₂ dsa₂ sián'₂ quiáng₃: “O₂jmo₄ a₂la₂ a₂ó₃”, a₂jaun₂ dsɨ₃jmó₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jme₁ca₂nág₂ Jesús a₂juá'₂ dsa₂ 'éi₂, ca₂i₃gó'₃ dsɨ́₅, jaun₂ ca₂tsɨ́'₃ dsa₂ i₂jme₁quiain'₅₄: ―A₂dsɨ₂jó'₃ juá'₅ jniá₂ juɨ́g₂ 'nia'₂, ca₂lia'₂ 'i₁jan₂ dsa₂ juɨg₂ Israel, tsá₃ i₂ma₂jɨn₄ jniá₂ i₂'én₂ guë́₄ lɨn₃ lia'₂ 'én₂ dsa₂ la₂. ");
INSERT INTO cntNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jniá₂ juɨ́g₂ 'nia'₂, juɨn₅ dsa₂ i₂qui₂ja₃lén₂ ca₂le₂con₂ gua'₅₄ 'uë₃, a₂tiain'₃ co₂lë₅ guë́'₃ quian'₅₄ Abraham, quian'₅₄ Isaac, Jacob në́₃ ja₁gon₂ Diú₄ guei'₅₄ i₂juɨ́g₃; ");
INSERT INTO cntNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","la₁ dsa₂ i₂jme₁ca₂tɨ́n₂ tón'₃ ja₁gon₂ Diú₄, dsɨ₃toin'₅₄ jë₄ qui₁né'₃ uɨ́ng₂, qui₂dsɨ₃'áu₃, quɨ́g'₃ jan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ juɨg₅₄ 'lióg₂: ―Guan'₂ dsi₂néi₂ quiáng'₂. Lé₂ bá₄ con'₂ lë́₅ 'éng'₂. Dsón'₂ rë'₂ hora jaun₂ ca₂'lón₂ dsó₂ mozo quián₅ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Co₂ráun₂ ŋó₃ Jesús ja₁quió'₄ Pe₄. Ja₁jaun₂ jme₁rë₂quian₅ ma₂chog₅₄ Pe₄ a₂dso'₅₄ 'i₄ dséi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jaun₂ ca₂jŋa'₃ Jesús gu₂ dsa₂ dso'₅₄, jaun₂ dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂o₃'ág₃ dséi₂. Jaun₂ ca₂nau₂ ma₂chog₅₄ Pe₄ ca₂jme₃lióg₃ ca₂jme₃ti₃ ta₁ ne₄ mesa, a₂ag'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Le₃ca₂nei₂ jaun₂, juɨn₅ lɨn₃ dsa₂ i₂jiog₅ jme₂dsí₂ je₂na'₅₄, ca₂o₃jŋia₃ dsa₂ ne₄ Jesús; jaun₂ quian'₅₄ ca₂jon₄ jág₁ bá₄ ca₂'uɨ́in'₂ jme₂dsí₂ 'lɨn'₅₄. Jaun₂ ca₂jme₃'lióin₂ ján₃ ca₂le₃jɨ́n₃ dsa₂ dso'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Le₂në₅ bá₄ ca₂rë₃ti₃ jág₁ quió'₅ Isaías i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄ jme₁ca₂juá'₂: 'Éi₂ bá₄ ca₂jŋiá'₂ a₂jme₁'uau₅₄ jniog₄, 'éi₂ bá₄ ca₂can₃ guei₂ jmɨ₁uɨg₅ quián₂ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jme₁ca₂jág₃ Jesús juɨn₅ lɨn₃ dsa₂ le₁lio₃, jaun₂ ca₂jmo₃ 'éi'₃ a₂ŋɨ́₃ dsa₂ quiáin₅ të₂le₃ 'ŋo'₅₄ jmɨ₁ŋí'₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jaun₂ ca₂jme₃quián₃ jan₂ të₅juá'₅ coin₂, jaun₂ ca₂juá'₂: ―Të₅, nei₅₄ jniá₂ quian'₅₄ 'ne₂ ca₂le₂con₂ ja₁gog'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jaun₂ ca₂ŋag₃ Jesús: ―I₂cha₂ të₂'lau₂ quió'₅ bá₄ juɨ₁lia'₂ i₁güɨ₅, ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ i₁tan₅ i₂'ɨn₅ guei'₅₄, i₂tio'₅₄ tsag₄ bá₄ 'éi₂. La₁ Jaun₅ dsa₂ mɨ₂güɨ́g₃ në́₃, tsá₃ ja₁cha₂ jua'₅₄ ja₁quióg₃ ca₂tiá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jan₂ guë'₂ i₂sián'₂ i₂jme₁ma₂ŋó₅ quiong'₅₄ ca₂juá'₂: ―Te₁gui'₅₄, ¿tsa₁ cuë́'₁ jmɨg₄ a₂nég'₄ i₁'ong₃ de'₂ jŋiá₅ ŋe'₃? ");
INSERT INTO cntNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","La₁ ca₂ŋag₃ Jesús: ―'Éin₃ 'ne₂ jniá₂, juɨ₁dsi₂'ón₃ bá₄ 'lag₄, 'lag₄ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jaun₂ në́₃, ca₂'í₃ Jesús 'ŋió'₃ tsɨ₁mu₅, quian'₅₄ dsa₂ i₂ma₂quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jme₁ma₂tioin'₅₄ ne₄ jmɨg₂, ca₂'ág₂ dsí₂ tiá₂ lɨn₃ con'₂ tsá₃ jáin₅. Ca₂lia'₂ ma₂dsɨ₂jein₃ jmɨg₂ 'ŋió'₃ tsɨ₁mu₅. La₁ jme₁rë₂güɨ́n₃ bá₄ Jesús ŋó₅. ");
INSERT INTO cntNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jaun₂ ca₂i₁ŋei₅₄ bá₄ dsa₂ quiáin₅, jaun₂ ca₂juá'₂: ―¡Te₁gui'₅₄, lio₄! ¡Ia₁ dsɨ₃'éin₂ jnia'₅₄ ja₁lá₃! ");
INSERT INTO cntNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jaun₂ ca₂ŋag₃ Jesús: ―¿'E₂ lë₃ ŋɨ́₄ lë₃ gan'₃ 'nia'₂ dsa₂ i₂tsá₃ lɨn₄ 'én₂? Jaun₂ ca₂nau₂ ca₂jéin₂ dsí₂, jmɨ₁ŋí'₄ në́₃, jaun₂ co₂ŋei'₅₄ ca₂të₁tsɨ'₅₄ táng₃ tei₄. ");
INSERT INTO cntNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jaun₂ ca₂i₃gó'₃ dsɨ́₅ dsa₂, qui₂ca₂ŋɨ́i'₃ rɨin'₅₄: ―¿I₂'ein₂ bá₄ dsa₂ në₅, le₂jiog₅ dsí₂ le₂jiog₅ jmɨ₁ŋí'₄ nag₅ gau₂ jág₁ quió'₅? ");
INSERT INTO cntNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jme₂ca₂dsióg₃ Jesús le₃ca₂ton₂ jmɨ₁ŋí'₄, të₂le₃ 'uë₃ Gadara, jaun₂ ca₂'uɨn₂ on₃ dsa₂ jë₄ le₁'on₅ 'lag₄, jaun₂ ca₂jme₃quiáin₃ con₂ Jesús. Le₃on₃ dsa₂ 'éi₂ jme₁jiog₅ je₂na'₅₄, jaun₂ 'ŋio₅ lɨn₃ jme₁tsau₂ dsɨ́₅, 'i₁jan₂ dsa₂ tsá₃ 'ein₂ lé₂ le₃ŋɨ́₃ juɨ₅ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jaun₂ ca₂tóin'₂ co₂mɨ'₅₄ ca₂juá'₂ tiá₂: ―¿'E₂ 'uɨg₅₄ tián'₅ 'ne₂ jë₄ quian'₅₄ jnia'₅₄, Jesús Ja₁ŋi'₅₄ Diú₄? ¿A₂ŋe'₃ 'ne₂ ja₁lá₃ a₂jmog'₅₄ jnia'₅₄ të₃jŋiá₅? ");
INSERT INTO cntNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Me'₂ cau₅ jaun₂, jme₁tion'₅₄ juɨn₅ i₁ŋí₅ guë́'₅; ");
INSERT INTO cntNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","jaun₂ qui₂ca₂mɨ₃ je₂na'₅₄ ne₄ Jesús, ca₂juá'₂: ―Chi₂jua'₂ 'uag'₅₄ jnia'₅₄ ja₁lá₃, chei₅ jnia'₅₄ dsi₁tió'₄ quió'₅ i₁ŋí₅ 'o₃. ");
INSERT INTO cntNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jaun₂ ca₂juá'₂ Jesús: ―O₂nó'₅ 'nia'₂. Jaun₂ ca₂'uɨn₂ jme₂dsí₂ 'lɨn'₅₄ të₂dsɨ́₅ dsa₂ 'éi₂, jaun₂ ca₂i₃toin'₅₄ të₂dsɨ́₅ i₁ŋí₅. Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂i₁nio₁ co₂chi'₅₄ i₁ŋí₅ cuɨng₂₃ juɨ₅ siá₅, jaun₂ ca₂i₁sein'₃ të₂ jmɨ₁ŋí'₄. Ja₁jaun₂ ca₂dsain₃ ca₂'ɨn'₃ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Dsa₂ i₂jme₁jmo₅ 'í₁ i₁ŋí₅ në́₃ ca₂cuɨng₃. Jme₁dsi₃lein₃ jë₄ juɨg₂ ca₂dsia₃ a₂ca₂lë₃ jaun₂, quian'₅₄ a₂ca₂lë₃ quian'₅₄ dsa₂ i₂jme₁tion'₅₄ je₂na'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ca₂le₃jɨ́n₃ dsa₂ chan₂ juɨg₂ jaun₂ në́₃ ca₂'uɨin₂ i₃léin₂ ja₁'en₅₄ Jesús. Jaun₂ jme₁ca₂jɨ́in₂ Jesús në́₃, ca₂chi₃quióng₂ jmɨg₄ a₂o₃'ɨin₅ le₂con₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jaun₂ ca₂'í₃ Jesús 'ŋió'₃ tsɨ₁mu₅, ca₂ŋɨ́i₃ le₃'ŋo'₅₄ jmɨ₁ŋí'₄, jaun₂ ca₂dsiáin'₃ juɨg₂ ja₁jme₁guá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jaun₂ ca₂o₃jŋia₃ dsa₂ jan₂ dsa₂ 'lian'₂, dsɨ́in₂ ne₄ tsɨ₁jein₁. Jme₁ca₂jág₃ Jesús a₂'én₂ dsa₂ 'éi₂ 'ŋio₅ lɨn₃, ca₂tsɨ́'₃ dsa₂ dso'₅₄: ―Jmo₄ lían'₂ 'au'₂, jón₃; ma₂rë₂'én₄ bá₄ dsáu'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jaun₂ ca₂i₃jiog₅ dsɨ́₅ i₂lɨn₅₄ të₅juá'₅: “A₂'ɨn₅ 'lɨg'₅₄ Diú₄ bá₄ i₂në₅ a₂juá'₂ le₂në₅.” ");
INSERT INTO cntNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","La₁ i₂ŋi₅ rë₂ bá₄ Jesús a₂dsɨ₂jiog₅ dsɨ́₅ dsa₂ 'éi₂, jaun₂ ca₂juá'₂: ―¿'E₂ lë₃ dsɨ₂jiog₅ 'au'₂ 'nia'₂ 'lɨg'₅₄ le₂në₅? ");
INSERT INTO cntNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Na₂ a₂'ua₁ guë́₄ ta₁ jua'₅₄ a₂jme₁juɨg₅₄ jniá₂ dsa₂ la₂: “Ma₂rë₂'én₄ bá₄ dsáu'₂”, o₃ a₂jme₁juɨg₅₄ 'e₂ jniá₂: “Nau₂, ŋɨ₄?” ");
INSERT INTO cntNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dse₃ jaun₂. La₂ jmo₅₄ jniá₂ jaun₂ le₃ŋi'₅₄ 'nia'₂ a₂'io₅ 'éi'₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ ne₄ gua'₅₄ 'uë₃ a₂qui₃'éin₂ dsáu₁ dsa₂. Jaun₂ guë́₄ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂ 'lian'₂: ―Nau₂, quion₂ tsɨ₁jein₁ quiáng'₂, guan'₂ ja₁quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jaun₂ ca₂nau₂ bá₄ dsa₂ 'éi₂, ca₂ŋái'₃ ja₁quió'₄. ");
INSERT INTO cntNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jme₁ca₂jág₃ dsa₂ a₂ca₂lë₃ jaun₂, ca₂i₃gó'₃ dsɨ́₅, jaun₂ ca₂jme₃juɨin'₂ Diú₄ ne₄ 'uɨg₅₄ ia₁ a₂ma₂cuë₃ bí₂ jaun₂ ma₂cuë́'₃ jan₂ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ca₂o₃'ɨ́n₃ bá₄ Jesús ja₁jme₁'ein₅₄ jaun₂. Ja₁ŋó₄ jaun₂, ca₂jɨ́in₂ jan₂ dsa₂ i₂chen₂ Mateo, guá₅ caun₂ dsi₂néi₂ cán₂ 'lia'₅₄ o₄quió'₄ dsɨ₂tan₅₄. Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ 'éi₂: ―'Éin₃ jniá₂. Jaun₂ ca₂nau₂ bá₄ Të₅₄, ca₂jme₃quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ca₂lë₃ jme₁ma₂'en₅₄ Jesús guë́'₅ dsi₂néi₂ quió'₅ Të₅₄, ca₂dsi₃lén₂ juɨn₅ guë́₄ dsa₂ i₂cán₂ cu₄ rɨin'₅₄, dsa₂ “i₂le₁cán'₄ dso₄” sián'₂ guë́₄ në́₃, ca₂i₃toin'₅₄ i₁guë'₂ quiain'₅₄ Jesús, quiain'₅₄ dsa₂ i₂ma₂quiain'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dsa₂ fariseos në́₃, jme₁ca₂jág₃ a₂në₅, jaun₂ ca₂ŋɨ́i'₃ dsa₂ quián₅ Jesús: ―¿'A₂ lia'₂ guë́'₅ të₅ quián'₂ 'nia'₂ co₂lë₅ quian'₅₄ dsa₂ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄, dsa₂ i₂le₁cán'₄ dso₄ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ca₂nág₂ Jesús jág₁ jaun₂, jaun₂ ca₂juá'₂: ―On₃jua'₅₄ dsa₂ i₂qui₂le₁'ág₄ dse₃ dsɨ́₅ i₂'nió'₅ të₅mɨ́₅ quió'₅; të₂le₃ ja₁con₂ dsa₂ i₂le₁dso'₅₄ bá₄ 'nió'₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","O₂nó'₅ 'nia'₂ o₂jme₁tɨn₅ 'e₂ jein₅ jág₁ la₂ tio'₅₄ ne₄ Si₂: “A₂'nio₃ jniá₂ dsiá'₁ 'nia'₂ ŋéi₂ 'au'₂ dsa₂ mɨ₂güɨ́g₃ rɨ́ng'₂, on₃jua'₅₄ rë'₂ a₂jŋia'₅₄ qui₁jen'₄ 'nia'₂ 'e₂ qui₁jen'₄ ne₃.” Ia₁ tsá₃ ta₁ jaun₂ guio₃ jniá₂ jua'₅₄ a₂të́₄ dsa₂ dsen₃; a₂të́₄ dsa₂ i₂le₁cán'₄ dso₄ bá₄ jniá₂ guio₃. ");
INSERT INTO cntNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jaun₂ ca₂dsi₃lén₂ dsa₂ i₂jme₁i₂nio₄ quian'₅₄ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂ ca₂jme₃quiáin₃ ne₄ Jesús, jaun₂ ca₂ŋag₃: ―¿'A₂ lia'₂ jme₂'ɨn₅₄ bá₄ dsa₂ fariseos, le₂jaun₂ guë'₂ jnia'₅₄ në́₃, la₁ dsa₂ i₂quian'₅₄ 'ne₂ guë'₂ tsá₃ jme₂'ɨin₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jaun₂ ca₂ŋag₃ Jesús: ―¿Lé₂ le₃tón'₃ 'lia'₂ dsɨ́₅ juɨ₁lia'₂ dsa₂ i₂té₁ ja₁niog₅ jmɨg₄ ja₁jen'₂ gu₂ dsa₂, chi₂jua'₂ jaun₂ bá₄ guá₅ guë'₂ dsa₂ ŋe'₂ i₂jen'₂ gu₂? Já₅ jmɨg₄ jë₁tsá₃ ma₃dsa₂ i₂jen'₂ gu₂ 'éi₂ chan₂ lé₂; jaun₂ guë́₄ tóin'₃ jme₃'ɨin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Ma₁ tsá₃ 'ein₂ tɨn₂ tióng₅ tsɨ₁'mɨ'₂ gui'₅₄ quian'₅₄ 'nau₅₄ tsɨ₁'mɨ'₂ 'mɨ́₂. Ia₁ dsán'₅ tsɨ₁'mɨ'₂ 'mɨ́₂, jaun₂ juë'₂ guë́₄ ja₁gag₂ lë́₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ján₃ bá₄ le₂jaun₂ tsá₃ tia'₂ dsa₂ vino 'mɨ́₂ 'ŋió'₃ nɨ₁lau₂ gui'₅₄, ia₁ ne'₂. Në₅ bá₄ téin₃ vino, ton'₂ dsɨ₃'én₂ nɨ₁lau₂ në́₃ në₁jua'₂ ca₂jmo₃ dsa₂ le₂jaun₂. Jaun₂ lë₃, 'ŋió'₃ lau₂ 'mɨ́₂ bá₄ 'nió'₅ tia'₃ dsa₂ vino 'mɨ́₂, ia₁jaun₂ le₃tɨn₃ bá₄ lé₂ 'í₁. ");
INSERT INTO cntNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Të₃ 'en₅₄ Jesús dsia₂₃ jág₁, jme₁ca₂dsióg₃ jan₂ i₂niog₅ gu₂ guá'₅ sinagoga. Ca₂chi₃jné₃ ne₄ Jesús, jaun₂ ca₂juá'₂: ―Lia'₂ ca₂jon₃ jan₂ chi'₂ dsa₂ mɨ́₂ quiáng₃. La₁ në₁jua'₂ gog'₅₄ 'ne₂ quian'₅₄ jniá₂ o₁quiog'₂ gog'₂ ne₄ quió'₅, le₃chain₂ bá₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jaun₂ ca₂nau₂ Jesús, jaun₂ ca₂ŋó₃ quiain'₅₄ dsa₂ 'éi₂, lia'₂ jma₃quiain'₅₄ dsa₂ i₂ma₂ja₂lén₂ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Të₃jë₄ jaun₂, ŋó₃ jan₂ dsa₂ mɨ́₂ i₂dso'₅₄ ma₂guia₃-tɨ́n₂ ŋi₂ a₂tɨin₂. Ca₂jme₃quiáin₃ të₂le₃ chi₁co'₅₄ quió'₅ Jesús, jaun₂ ca₂nɨ́i'₂ chei'₅₄ tsɨn'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ia₁ lɨ́in₂: “Tsá₃ nag₅₄ në₁jua'₂ jŋia'₅₄ nɨ́g'₄ ca₂juɨg₄ tsɨn'₅₄, jŋia₃ quió₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jaun₂ ca₂jén'₃ Jesús, ca₂jɨ́in₂ 'io₅₄, jaun₂ ca₂juá'₂: ―Jmo₄ lián'₂ 'au'₂, jón₃. Ma₂'lóng'₂ bá₄, ia₁ 'éng'₂. Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂jŋia₃ co₂ŋei'₅₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jme₁ca₂dsióg₃ Jesús ja₁quió'₄ dsa₂ juɨg₅₄ sinagoga 'éi₂, jaun₂ ca₂jág₃ ma₂tion'₅₄ dsa₂ i₂jmo₅ son₅₄, ma₂tion'₅₄ dsa₂ juɨn₅ go₂'i₃ në́₃, quɨ'₂-'o₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jaun₂ ca₂juá'₂: ―'Uɨ́n'₂ 'nia'₂ ja₁lá₃; tsá₃ rë₂jon₅₄ i₂bë'₅₄ në₅. Jŋia'₅₄ lia'₂ a₂rë₂güɨ́in₃ bá₄. La₁ jŋia'₅₄ ca₂ŋág₂ bá₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jme₁ma₂'uɨn'₂ dsa₂, jaun₂ ca₂'í₃ Jesús dsi₂néi₂, ca₂jŋa'₃ mɨ₂gu₂ i₂bë'₅₄, jaun₂ ca₂nau₂ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ca₂le₂con₂ juɨg₂ tio'₅₄ 'uë₃ jaun₂, ca₂i₃'ág₃ jág₁ a₂ca₂lë₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jme₁o₂'ɨ́n₃ Jesús ja₁jaun₂, ca₂'ein₃ on₃ dsa₂ ten₄, ja₂léin₂ të́₂ tiá₂: ―¡Dsia₄ ŋéi₂ 'au'₂ jnia'₅₄, 'ne₂ tsɨ₁jon₂ David! ");
INSERT INTO cntNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jme₁ca₂'í₃ Jesús dsi₂néi₂, ca₂jme₃quián₃ dsa₂ ten₄ 'éi₂ cau₅ quió'₅. Jaun₂ ca₂ŋag₃ Jesús: ―¿'Én'₂ 'nia'₂ a₂lé₂ le₃jme₁'lio₅₄ jniá₂? Jaun₂ ca₂ŋag₃: ―'Éin₂ bá₄ jnia'₅₄, Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jaun₂ ca₂nɨ́'₃ Jesús gu₂ jme₁ne₁₂ jaun₂ ca₂juá'₂: ―Juɨ₁le₅₄ bá₄ con'₂ lë́₅ 'én'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jaun₂ ca₂lág₃ bá₄ mɨ₂ne₄ dsa₂ 'éi₂. Jaun₂ ca₂jmo₃ Jesús 'éi'₃ ca₂juá'₂: ―Të₃ŋi'₅₄ 'nia'₂ jnag₅₄ tsá₃ 'ein₂ juɨ₁le₂ŋi₅ a₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","La₁ 'éi₂ në́₃, jme₁ca₂'uɨin₂ jaun₂, ca₂dsia₃ ca₂le₂con₂ ja₁tén₄ 'uë₃ jaun₂ 'e₂ a₂ca₂jmo₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jme₁ma₂'uɨn₂ dsa₂ i₂jme₁ten₄ 'éi₂, ca₂o₃lén₂ i₂sián'₂ táng₃ jŋiai₂₃ jan₂ dsa₂ con₄ i₂'en₅₄ jme₂dsí₂ je₂na'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dsɨ₂juɨ₅ jme₁ca₂dsen₅ Jesús je₂na'₅₄, jaun₂ ca₂jme₃lióg₃ dsa₂ con₄ 'éi₂ ca₂dsia₃ jág₁. Dsa₂ juɨn₅ i₂jme₁tion'₅₄ ca₂të́₂ ne₅₄, ca₂i₃gó'₃ dsɨ́₅, jaun₂ ca₂dsia₃: ―Ca₂le₂con₂ 'uë₃ Israel la₂, tsá₃ 'ein₂ ma₂ca₂jág₃ a₂le₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","La₁ dsa₂ fariseos guë'₂ në́₃, ca₂juá'₂: ―Të₂le₃ quian'₅₄ juɨ₅bí₂ quió'₅ 'ŋiog₅ juɨg₅₄ je₂na'₅₄ bá₄, jmo₅ i₂në₅ 'uɨ́in'₂ je₂na'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ca₂ŋɨ₃ Jesús ca₂le₂con₂ juɨg₂ ca'₅₄, ca₂le₂con₂ juɨg₂ pí'₁ në́₃, jme₂tɨin₂₃ dsa₂ dsi₂néi₂ guá'₅ sinagogas. Jme₁'ë́₂ jág₁ dse₃ juɨ₁lia'₂ ja₁gon₂ Diú₄. Jme₁jme₂'lióin₂ dsa₂ ca₂le₃jë́₃ ne₅₄ dso₄, quian'₅₄ ca₂le₃jë́₃ jmɨ₁uɨg₅ a₂jme₁le₁quian₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jme₁ca₂jɨ́in₂ dsa₂, ca₂tá'₂ ŋéi₂ dsɨ́₅, ia₁ jme₁chain₂ o₂i₁ dsɨ₅ ca₂lia'₂ ma₂ja₂'ú'₃ dsɨ́₅ chain₂, në₂jag₄ bá₄ já'₂ cha'₂ i₂tsá₃ chan₂ jmo₃ 'í₁. ");
INSERT INTO cntNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jaun₂ në́₃ ca₂tsɨ́'₃ dsa₂ i₂jme₁quiain'₅₄: ―Dsón'₂ bá₄ dsau₅ 'lióng₂ a₂ca₂rau₂, la₁ tsá₃ juɨn₅ dsa₂ i₂jmo₅ ta₁ ja₁nau₂. ");
INSERT INTO cntNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jaun₂ lë₃, mɨ₄ 'nia'₂ ne₄ juɨg₅₄ ja₁nau₂ a₂chein₃ guë́₄ juɨn₅ dsa₂ i₂jmo₃ ta₁ ja₁nau₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jaun₂ ca₂të́'₃ Jesús chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂cuë₃ bí₂ 'éi'₃ a₂'uɨ́in'₂ jme₂dsí₂ 'lɨn'₅₄, a₂qui₂jme₃'lióin₂ ca₂le₃jë́₃ ne₅₄ dso₄ a₂niog₅ lɨ́n₅ dsa₂, ca₂le₃jë́₃ jmɨ₁uɨg₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Le₂la₂ bá₄ chen₂ ta₁guia₃-tɨ́n₂ dsa₂ i₂ca₂quión'₂ Jesús 'éi₂ quiáin₅: Si₂mu₅₄, i₁të́'₂ dsa₂ Pe₄; quiain'₅₄ Drë́₄ rɨin'₅₄; Jacobo quian'₅₄ Juan₅₄ rɨin'₅₄, ja₁ŋí'₄ Zebedeo; ");
INSERT INTO cntNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fe₂li₄ quian'₅₄ Bartolomé; To₁má₄ në́₃ quian'₅₄ Të₅₄ i₂jme₁cán₂ 'lia'₅₄ a₂ca₂tɨ́n₂ dsɨ₂tan₅₄; Jacobo i₂lɨ́n₅ ja₁ŋí'₄ Alfeo; Tadeo në́₃; ");
INSERT INTO cntNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Si₂mu₅₄ në́₃ i₂të́'₂ dsa₂ cananista; Judas Iscariote në́₃, i₂ca₂jɨ́n'₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dsa₂ guia₃-tɨ́n₂ në₅ bá₄ ca₂chen₃ Jesús jme₁ma₂në₂cuë₃ jág₁ la₂: ―Tsá₃ o₁nó'₅ 'nia'₂ juɨ₅ 'uë₃ go₄ dsɨ₂nau₂, on₃ guë'₂ o₂ton'₅₄ 'nia'₂ 'i₁caun₂ juɨg₂ a₂tén₅ 'uë₃ Samaria. ");
INSERT INTO cntNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ja₁jaun₂ bá₄ o₂nó'₅ 'nia'₂ ja₁tion'₅₄ dsa₂ i₂lɨ́n₅ co₂'nió'₄ já'₂ cha'₂ i₂ma₂i₂cón'₅ i₂chan₂ juɨg₂ Israel. ");
INSERT INTO cntNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","O₂nó'₅ 'nia'₂ qui₂o₂'ë́₃ jág₁ dse₃ la₂ chei'₅₄ 'nia'₂ dsa₂, ma₂ja₂quián₃ 'éi'₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","O₂jmo₄ 'nia'₂ le₁jɨ́n₃ dsa₂ i₂lɨ́n₅ 'mé'₅ 'iog₅; ca₂le₃jɨ́n₃ guë'₂ i₂lɨ́n₅ dso₄ siá'₂ në́₃, o₂jme₁'lioin₅₄; o₂jme₁jen'₅₄ 'nia'₂ 'lag₄; o₂'uɨn'₅₄ 'nia'₂ je₂na'₅₄ quió'₅ dsa₂ në́₃. Jaun₂ le₂në₅ juɨ₁lia'₂ në₂gue'₅₄ 'nia'₂ bí₂ la₂ on₃jua'₅₄ a₂cha₂ 'lia'₅₄, le₂në₅ o₂jmo₄ 'nia'₂ ján₃, o₂cuë'₅₄ dsa₂ bí₂ tsá₃ 'lia'₅₄ cán'₁. ");
INSERT INTO cntNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tsá₃ 'e₂ cán'₁ 'nia'₂, juɨ₁lia'₂ a₂'nió'₅ le₂'i₄ juɨ₅, on₃ guë'₂ cu₄nióg₄, on₃ guë'₂ cu₄tiog₂, on₃ guë'₂ ŋí₁ guéin₂ të₂lau₂ quiáng'₂, ");
INSERT INTO cntNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","on₃ guë'₂ të₂'mɨ'₂ jua'₅₄ a₂to'₅₄ lio₅₄ cán'₁. Jmá'₃ co₂dsán'₃ tsɨ́n'₂ bá₄ 'nia'₂ cán'₁, tsá₃ cán'₁ 'nia'₂ lau₂ ton₂ tag'₅₄ a₂ŋag₅₄ guë́₄ con'₂ a₂ma₂le₁ton₅ tag'₅₄, on₃ guë'₂ 'ma₂'ɨ₅₄; ia₁ juɨ₁lia'₂ dsa₂ i₂jmo₅ ta₁, ca₂tɨ́in₂ bá₄ gue₃ má₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Jë₁ma₂ca₂dsi₃nó'₅ 'nia'₂ lia'₂ caun₂ juɨg₂ ca'₅₄ o₃ juɨg₂ pí'₁ 'e₂, ja₁jaun₂ jŋia₄ 'nia'₂ ja₁quió'₄ dsa₂ i₂léi₄ dsen₃ 'ua₁ dsɨ́₅, quió'₅ 'éi₂ tión'₂ 'nia'₂ ca₂lia'₂ ca₂të́₂ jmɨg₄ i₁'uɨ́ng'₃ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jë₁ma₂të́₂ rë₁tóng'₁ dsi₂néi₂ quió'₅, cuɨin₅₄ 'nia'₂ Diú₄ jua'₅₄ 'nia'₂: “Juɨ₁'ei₅ bá₄ tei₄ dsi₂néi₂ la₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Në₁jua'₂ dsa₂ dsi₂néi₂ jaun₂ léi₄ gue₂₃ bá₄ lia'₂ i₁rë₂ jág₁, jág₁ quián'₂ 'nia'₂ a₂cuɨ́in'₅ Diú₄, juɨ₁të₂'ŋiá₄ bá₄ 'ei₅ tei₄ ja₁con₂ dsa₂ 'éi₂ dsi₂néi₂ jaun₂. La₁ në₁jua'₂ léi₄ tsá₃ dse₃ le₁'ág₄ dsɨ́₅ dsa₂ gue₂₃ jág₁ quián'₂ 'nia'₂, juɨ₁të₂'ŋiá₄ bá₄ jág₁ 'ei₅ tei₄ jaun₂ ja₁con'₂ 'nia'₂ guiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Në₁jua'₂ cha₂ ja₁lɨn₅₄ tsá₃ 'nio₃ dsa₂ guein₃ 'nia'₂, on₃ guë'₂ 'nio₃ nag₃ jág₁ quián'₂ 'nia'₂ në́₃, co₂ŋei'₅₄ 'uɨ́n'₂ 'nia'₂ dsi₂néi₂ jaun₂, o₃ juɨg₂ jaun₂, séi'₃ 'nia'₂ 'liog₂ tag'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ia₁ a₂dsɨ₂jó'₃ juá'₅ jniá₂, jë₁ma₂të́₂ rë₁qui₃dsɨ₅ Diú₄ 'éi'₃, 'ŋio₅ guë́₄ uɨg₅ gue₃ dsa₂ juɨg₂ jaun₂ con'₂ guë́₄ dsa₂ i₂jme₁chan₂ Sodoma quian'₅₄ Gomorra. ");
INSERT INTO cntNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Tsɨ́n₂ jniá₂ 'nia'₂ jaun₂, a₂lɨ́ng'₅ në₂jag₄ bá₄ já'₂ cha'₂ jɨn₄ co₂'nió'₄ já'₂ tsau₂ dsɨ́₅. Jmo₄ 'nia'₂ jaun₂ a₂lɨ́ng'₅ dsa₂ i₂'io₅ mai₅₄ juɨ₁lia'₂ dsɨ₂mɨ'₂, ton'₂ 'ua₁ 'au'₂ 'nia'₂ juɨ₁lia'₂ lɨ́n₅ i₁ju₂. ");
INSERT INTO cntNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Rë₂ján'₁ 'nia'₂ jaun₂ ia₁ qui₃jáng'₂ dsa₂ ne₄ dsɨ₂tan₅₄, qui₃bóg₂ dsa₂ në́₃ dsi₂néi₂ guá'₅ sinagogas. ");
INSERT INTO cntNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lia'₂ ne₄ dsi₄má'₂ lia'₂ ne₄ rag₅₄ në́₃, dsi₁jŋia₃ dsa₂ 'nia'₂ 'uɨg₅₄ quió₃ jniá₂; jaun₂ le₂në₅ bá₄ lé₂ le₃o₁jang'₄ 'nia'₂ jág₁ dsau₅ ne₄ 'éi₂, quian'₅₄ ja₁con₂ dsɨ₂nau₂ sián'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","La₁ jë₁ma₂të́₂ rë₁qui₃jáng'₂ dsa₂ ne₄ta₁, tsá₃ lë₁jmo₂ 'nia'₂ 'ɨ₅ 'au'₂ 'e₂ jua'₅₄ o₃ 'a₂ lia'₂ ŋag'₅₄; ia₁ jë₁ma₂të́₂ rë₁jua'₅₄ 'nia'₂ jág₁, Diú₄ bá₄ cuë₃ jág₁ a₂ŋi'₅₄ 'nia'₂ 'a₂ lia'₂ ŋag'₅₄ juɨg'₅₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ia₁ on₃jua'₅₄ guion'₅₄ 'nia'₂ jua'₅₄ jág₁; 'ŋiog₅ bá₄ Jme₂dsí₂ quián₅ Ŋéi'₅ 'nia'₂ juá'₂ juɨ₅ të₂'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ia₁ lé₂ táng₃, juɨ₁lia'₂ rɨn'₅₄ dsa₂ qui₃jɨ́in'₂ rɨin'₅₄ jaun₂ jŋag'₃ dsa₂, juɨ₁lia'₂ jmei₂ guë'₂ dsa₂ qui₃jɨ́in'₂ chi'₂ quiáin₅; chi'₂ guë'₂ në́₃ qui₃náu₃ 'nei₂ jmái'₃ chog₅₄-jmei₂, qui₃jáng'₂ a₂jme₃dsiog₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ca₂le₃jɨ́n₃ juɨ₁lia'₂ dsa₂ mɨ₂güɨ́g₃ jme₃'ŋiai₅₄ 'nia'₂ 'uɨg₅₄ quió₃ jniá₂; la₁ia₁ juɨ₁lia'₂ i₂tión₂ tiá₂ ca₂të₂ jë₁ca₂tó'₂, i₂'éi₂ bá₄ i₂lión₂. ");
INSERT INTO cntNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jë₁ma₂qui₂co₃'ein₃ dsa₂ juɨ₁lia'₂ caun₂ juɨg₂, cuɨng₅ 'nia'₂ juɨ₅ juɨg₂ siá'₂ táng₃; a₂dsɨ₂jó'₃ juá'₅ jniá₂, të₃ tsá₃ ma₂lë₅ quen'₄ 'nia'₂ i₁niog'₄ ca₂le₃jë́₃ juɨg₂ ja₁tén₄ 'uë₃ Israel, a₂guan'₂ táng₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Juɨ₁lia'₂ jan₂ i₂jme₂tɨn₅, tsá₃ juɨin'₂ con'₂ guë́₄ të₅ quiáin₅; ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ jan₂ dsa₂ i₂jme₂ti₃, tsá₃ juɨin'₂ con'₂ guë́₄ juɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tió'₅ juɨ₁lia'₂ i₂jme₂tɨn₅ léin₂ juɨ₁lia'₂ lɨ́n₅ të₅ quiáin₅; juɨ₁lia'₂ dsa₂ i₂jme₂ti₃ guë'₂ në́₃, dsi₁léin₂ juɨ₁lia'₂ lɨ́n₅ juɨg₅₄. Chi₂jua'₂ 'ŋiog₅ dsa₂ juɨn'₂ caun₂ dsi₂néi₂ ma₂quion₅ dsa₂ Be'elzebú, ¡'ë₂ guë́₄ bá₄ 'ɨn₃ dsa₂, juɨ₁lia'₂ i₂tion'₅₄ dsi₂néi₂ quió'₅! ");
INSERT INTO cntNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’'Uɨg₅₄ jaun₂, tsá₃ lë₁jmo₂ 'nia'₂ gang'₃ dsa₂ mɨ₂güɨ́g₃. Ia₁ 'i₁caun₂ juɨ₁lia'₂ a₂rë₂jlë₅ tsá₃ cha₂ jua'₅₄ a₂tsá₃ le₃jniá₂, ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ a₂rë₂'ma₄ tsá₃ cha₂ jua'₅₄ a₂tsá₃ le₃ŋi₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Juɨ₁lia'₂ a₂juɨ́g₂ jniá₂ 'nia'₂ la₂ jë₄ të₃co'₅₄, jua'₅₄ 'nia'₂ të₃jɨn₄ dsa₂ juɨn₅; ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ a₂juɨ́g₂ jniá₂ 'nia'₂ con'₂ tei₄, jua'₅₄ 'nia'₂ co₂mɨ'₅₄ juɨ₁lia'₂ ja₁ŋei₅. ");
INSERT INTO cntNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tsá₃ lë₁jmo₂ 'nia'₂ gang'₃ quian'₅₄ i₂jŋɨ'₃ nɨ₁ŋɨ́₅, la₁ të₂'au'₂ 'nia'₂ tsá₃ 'e₂ lé₂ le₃jmo₃; i₂'éi₂ bá₄ ca₂tɨ́n'₂ 'nia'₂ jme₁gang'₃ juɨ₁lia'₂ i₂lé₂ le₃jŋɨ'₃ nɨ₁ŋɨ́₅ quian'₅₄ guë'₂ të₂'au'₂ 'nia'₂ a₂jeng'₃ ja₁'lɨg'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Tsa₁ 'nɨ₅ dsa₂ on₃ i₁tan₅ pí'₁ quian'₅₄ caun₂ ŋí₁ guéin₂? La₁ 'i₁jan₂ i₁tan₅ tsá₃ tián'₃ 'uë₃ jua'₅₄ tsá₃ ŋi₅ Ŋéi'₅ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ia₁ le₂jiog₅ nɨ₁jŋi₂ dsei'₂ 'nia'₂ le₁'í₁ je₂liá'₂ mɨ'₂ tí₅ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tsá₃ lë₁jmo₂ 'nia'₂ gang'₃, ia₁ 'ŋio₅ lɨn₃ guë́₄ quen'₄ 'nia'₂ lia'₂ con'₂ guë́₄ juɨn₅ lɨn₃ i₁tan₅. ");
INSERT INTO cntNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Juɨ₁lia'₂ i₂jme₂jnia₅ të₂le₃ quió₃ jniá₂ jɨn₄ dsa₂ mɨ₂güɨ́g₃, ján₃ bá₄ le₂jaun₂ jniá₂ në́₃ jme₁jniag₅ të₂le₃ quió'₅ 'éi₂ ne₄ Ŋe'₃ i₂guá₅ guei'₅₄ i₂juɨ́g₃; ");
INSERT INTO cntNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","la₁ juɨ₁lia'₂ i₂jme₂jnia₅ a₂tsá₃ cuɨg₂₃ jniá₂ jɨn₄ dsa₂ mɨ₂güɨ́g₃, ján₃ bá₄ le₂jaun₂ jme₁jnia₅ jniá₂ a₂tsá₃ cuɨ́in₅ ne₄ Ŋe'₃ i₂guá₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Tsá₃ o₁len'₂ 'nia'₂ jua'₅₄ a₂guio₃ jniá₂ a₂i₃'ei₃ tei₄ mɨ₂güɨ́g₃; ia₁ tsá₃ ta₁ jaun₂ guio₃ jniá₂ a₂i₃'ei₃ tei₄. Mɨ'₅₄ 'nei₂ bá₄ a₂quian₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A₂jaun₂ bá₄ guio₃ jniá₂ a₂i₃dsia₃ mɨ'₅₄ dsi₂néi₂: Chi'₂ jme₃'ŋiai₅₄ jmei₂, chi'₂ ja₁mɨ́g₄ dsa₂ në́₃ jme₃'ŋiai₅₄ chog₅₄; i₂lɨ́n₅ mɨ₂lo₅₄ në́₃ tóin'₃ mɨ'₅₄ quian'₅₄ ma₂chog₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dsa₂ i₂lɨ́n₅ jmei₂ dsi₂néi₂ qui₂jme₃'iog₅₄ chi'₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Juɨ₁lia'₂ i₂'nio₃ guë́₄ 'ŋio₅ lɨn₃ chog₅₄-jmei₂ lia'₂ con'₂ guë́₄ jniá₂, tsá₃ ca₂tɨ́in₂ léin₂ dsa₂ quiáng₃; le₂në₅ bá₄ ján₃, juɨ₁lia'₂ i₂'nio₃ 'ŋio₅ lɨn₃ guë́₄ ja₁ŋi'₅₄ o₃ ja₁mɨ́g₄ 'e₂, lia'₂ con'₂ guë́₄ jniá₂, tsá₃ ca₂tɨ́in₂ léin₂ dsa₂ quiáng₃; ");
INSERT INTO cntNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","juɨ₁lia'₂ i₂tsá₃ ca₂'ág₂ caun₂ dsɨ́₅ ca₂join₃ chi₂jua'₂ ca₂join₃, a₂jiá₃ chi₁co'₅₄ quió₃, tsá₃ ca₂tɨ́in₂ léin₂ dsa₂ quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Juɨ₁lia'₂ i₂ŋɨ́₄ lë₃ 'nio₃ lí'₂ le₃chain₂ dse₃, dsɨ₃'én₂ quió'₅; ján₃ bá₄ le₂në₅, juɨ₁lia'₂ i₂ca₂guen₃ 'mú₃ o₄quió₃ jniá₂, lí'₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Juɨ₁lia'₂ i₂guen₅ 'nia'₂, guei₂₃ jniá₂; juɨ₁lia'₂ i₂guei₅ jniá₂ guein₂₃ i₂ca₂chei₃ jniá₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","I₂guen₅ juɨ₁lia'₂ jan₂ dsa₂ i₂'ë́₂ jág₁ o₄quió'₄ Diú₄ ia₁ a₂lɨ́in₅ i₂chen₄ quián₅ Diú₄, co₂jaun₂ bá₄ 'lia'₅₄ gue₃ ján₃ juɨ₁lia'₂ 'lian'₅₄ jan₂ i₂'ë́₂ jág₁ quián₅ Diú₄. Le₂në₅ bá₄ ján₃, juɨ₁lia'₂ i₂guen₅ jan₂ dsa₂ dsen₃ ia₁ lɨ́in₅ dsa₂ dsen₃, gue₃ 'liain'₅₄ ján₃ con'₂ 'lia'₅₄ a₂ca₂tɨ́n₂ jan₂ dsa₂ dsen₃. ");
INSERT INTO cntNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Juɨ₁'ein₂ guë́₃ dsa₂ i₂cuë₅ caun₂ vaso jmɨg₂ güɨ́g'₂, cuë́'₅ jan₂ dsa₂ me'₂ le₂në₅ quiáng₃ 'uɨg₅₄ ia₁ a₂'ein₂₃ jniá₂, a₂dsɨ₂jó'₃ juá'₅, tion₅₄ bá₄ gue₃ 'liain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jme₁ca₂dsan₃ cuë₅ Jesús jág₁ në₅ cuë́'₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, ca₂o₃'ɨ́in₃ táng₃ ja₁jaun₂, ca₂'í₃ juɨ₅ ca₂i₁'ë́₄ jág₁, i₂jme₁tɨin₂₃ dsa₂ juɨg₂ tio'₅₄ con'₂ ma₂quián₅ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan₅₄ në́₃, të₃ 'ein₅₄ né'₃ 'má₃, ca₂rë₃ŋi₅ 'a₂ lia'₂ lë́₅ jmo₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄. Jaun₂ ca₂chein₃ i₂lɨn₅₄ dsa₂ i₂jme₁quiain'₅₄ ");
INSERT INTO cntNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","a₂ca₂i₁ŋag₁₂: ―¿'Ne₂ líng'₅ dsa₂ i₂lë́₅ jág₁ jiá₃, o₃ jŋia₄ jnia'₅₄ i₂sián'₂ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jaun₂ ca₂ŋag₃ Jesús: ―O₂nó'₅ 'nia'₂ o₂chei'₅₄ Juan₅₄ 'e₂ a₂të₅ ne'₅₄ 'nia'₂ la₂, 'e₂ a₂nag'₂ 'nia'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","O₂dsia₄ 'nia'₂ 'a₂ lia'₂ lë́₅ qui₂jág₅ dsa₂ ten₄; dsa₂ i₂jme₁guian'₅₄ guë'₂ në́₃, ma₂i₂nioi₅₄ rë'₂ táng₃; dsa₂ i₂jme₁lɨ́n₄ 'mé'₅ 'iog₅ ma₂le₁jɨ́in₃ táng₃ dso₄ a₂jme₁lɨ́in₄; dsa₂ i₂jme₁guɨn₄ guë'₂ në́₃ ma₂nag₂₃; dsa₂ i₂ma₂dsan₃, jein'₅₄ táng₃; ja₁con₂ dsa₂ te₂ŋé₂ në́₃ dsɨ₂'ag₅ jág₁ dse₃ la₂ a₂lión₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","'E₂ guë́₄ dsen₃ dsa₂ i₂tsá₃ 'ag₅ caun₂-tɨn₃ dsɨ́₅ ja₁con₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jme₁ma₂i₂len₃ dsa₂ 'éi₂, jaun₂ ca₂jme₃lióg₃ Jesús ca₂tsɨ́'₃ dsa₂ a₂'ɨin₂₃ Juan₅₄: ―¿'E₂ jme₁lɨ́n'₂ 'nia'₂ jme₁të₃ ne'₅₄ lia'₂ con'₂ jme₁i₁nóg'₄ 'uë₃ quein₂ co₂'ŋiog₅ jaun₂? ¿O₃ bá₄ jme₁lɨ́n'₂ 'nia'₂ a₂jme₁jɨng'₄ jan₂ dsa₂ i₂lɨ́n₅ juɨ₁lia'₂ lë́₅ ca₂'nau₂ nɨ₁'ma₂ ta₅ a₂lë₁qui₂bí₂ dsí₂ juɨ₅ la₂ juɨ₅ në₅? ");
INSERT INTO cntNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Chi₂jua'₂ tsá₃ le₂jaun₂ në́₃, ¿'e₂ guë'₂ ca₂i₁jag'₄ 'nia'₂? ¿O₃ bá₄ a₂jme₁lɨ́n'₂ 'nia'₂ a₂jme₁jɨng'₄ jan₂ dsa₂ i₂qui'₂ tsɨn'₅₄ jlá'₁? La₁ on₃jua'₅₄ le₂jaun₂. Ia₁ juɨ₁lia'₂ dsa₂ i₂quɨ́'₅ tsɨn'₅₄ jlá'₁, i₂tón'₅ dsi₂néi₂ quió'₅ rag₅₄ bá₄ i₂le₂'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿'E₂ guë'₂ ca₂i₁jag'₄ 'nia'₂ jaun₂ në́₃? ¿O₃ bá₄ jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄ 'e₂? Dsón'₂ bá₄ jaun₂ juá'₅ jniá₂. I₂lɨ́n₅ tson₂ guë́₄ jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan₅₄ 'éi₂ bá₄ i₂'ɨn₅ Si₂ quió'₅ Diú₄ ja₁juá'₂: Tsɨng₅₄ jan₂ dsa₂ quiáng₃ ne₄ juɨ₅ quiáng'₂, jón₃, a₂dsɨ₃can₅ jág₁, jmo₃ co₂jŋia₅₄ juɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, 'i₁jan₂ dsa₂ i₂ma₂can₅ dsa₂ mɨ́₂ i₂chan₂ mɨ₂güɨ́g₃, tsá₃ 'ein₂ ma₂lɨn₅ i₂juɨn'₂ guë́₄ i₂'ë́₂ jág₁ o₄quió'₄ Diú₄, lia'₂ con'₂ guë́₄ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂. La₁ia₁, i₂lɨ́n₅ i₂me'₂ guë́₄ ja₁gon₂ Diú₄, i₂'éi₂ bá₄ lɨ́n₅ i₂juɨn'₂ guë́₄ lia'₂ con'₂ guë́₄ Juan₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ca₂le₃ ca₂guan₃ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂, ca₂të₂ jmɨg₄ në₃, con'₂ 'i₄ juɨ₅ bá₄ ma₂já₅ tiá₂ ja₁gon₂ Diú₄. Jaun₂ dsa₂ con'₂ i₂tiá₂ dsɨ́₅ bá₄ chan'₂ tiá₂ juɨ₅ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ca₂le₃jɨ́n₃ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, quian'₅₄ 'Éi'₃ quió'₅ Moisés në́₃, a₂jŋia'₅₄ con'₂ ca₂'ë́₂ jág₁ ja₁gon₂ Diú₄ bá₄ jaun₂, ca₂lia'₂ ca₂të́₂ jmɨg₄ jme₁ca₂guan₃ Juan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ján₃ bá₄ chi₂jua'₂ 'niog'₂ 'nia'₂ guéi'₁ jág₁ la₂, Juan₅₄ 'éi₂ bá₄ i₂ca₂jme₃ti₃ jág₁ a₂lë́₅ a₂jme₁jiá₃ Elías. ");
INSERT INTO cntNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Juɨ₁lia'₂ i₂le₁dsɨ₅₄ rë₂gua₄, juɨ₁nei₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿'E₂ quian'₅₄ lé₂ le₃quɨ́ng₄ a₂lɨ́n₅ dsa₂ i₂chan₂ jmɨg₄ në₃? Lɨ́in₅ juɨ₁lia'₂ lɨ́n₅ i₂bë'₅₄ i₂tion'₅₄ co₅ jë₄ 'ma'₅₄, tioin'₅₄ co₂mɨ'₅₄ qui₂guió'₅ tsɨ́'₅ rɨin'₅₄: ");
INSERT INTO cntNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Në₂jéi₄ jnia'₅₄ te₁fi₁ o₄quián'₂ 'nia'₂, la₁ tsá₃ në₂dsián'₃ guë'₂ 'nia'₂; ján₃ guë'₂ në₂jmó₁ jnia'₅₄ son₅₄ quió'₅ 'lag₄ a₂ta'₂ 'lia'₂ dsɨ́₅ dsa₂, la₁ tsá₃ ca₂tá'₂ guë'₂ quɨ'₂ 'au'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ia₁ ca₂guan₃ Juan₅₄, i₂tsá₃ 'e₂ 'lióng₂ jme₁guë́'₅ on₃ guë'₂ 'e₂ jme₁'ɨ́n'₂ në́₃, jaun₂ ca₂'ag₃ dsa₂ a₂'ein₅₄ je₂na'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ca₂guan₃ guë'₂ táng₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ i₂guë́'₅ i₂'ɨ́n'₂, 'ag₅ táng₃ dsa₂ a₂lɨ́in₅ jlé₂ 'í₅ quian'₅₄ má₄ jmɨ́g₃, a₂lɨ́in₅ a₂mei₅₄ quián₅ dsa₂ cha₂ dsáu₁, quian'₅₄ dsa₂ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄ në́₃. La₁ tion₅₄ bá₄ le₃lí'₄ dsa₂ a₂dsau₅ jág₁ a₂ŋɨ́'₂ dsɨ́₅ Diú₄, 'uɨg₅₄ ia₁ ŋɨ́'₂ bá₄ dsɨ́₅ dsa₂ i₂gue₅ jág₁ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jaun₂ në́₃, ca₂jme₃lióg₃ Jesús qui₂ca₂jéin₂ dsa₂ ja₁'lióng₂ guë́₄ léi₄ juë'₂ ma₂qui₂ma₂jmo₃, ia₁ tsá₃ ma₂jéin'₃ dsa₂ dsɨ́₅. Jaun₂ ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ dsa₂ juɨg₂ Corazín! ¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ i₂chan₂ Betsaida! Ia₁ jua'₅₄ mei'₂ guë́₃ jniá₂ ma₂jmo₃ léi₄ juë'₂ në₅ jë₄ juɨg₂ Tiro quian'₅₄ juɨg₂ Sidón juɨ₁lia'₂ a₂ma₂jmo₃ jniá₂ jë₄ quián'₂ 'nia'₂, lɨ́g'₂ bá₄ tsá₃ ma₂ca₂jéin'₃ dsa₂ 'éi₂ dsɨ́₅, jme₁cuë₃ léi₄ a₂quɨ'₂ dsɨ́₅ jme₁i₃nioi₅₄ le₁qui'₂ 'mɨ'₂ taun₅ qui₂le₁séin₅ ti₁juá₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","La₁ juɨ́g₂ jniá₂ 'nia'₂, jmɨg₄ i₁qui₃dsɨ₅ Diú₄ 'éi'₃, ja₂lɨn₃ guë́₄ tson₂ uɨg₅ a₂guéi'₁ 'nia'₂ con'₂ guë́₄ dsa₂ i₂jme₁chan₂ Tiro quian'₅₄ Sidón. ");
INSERT INTO cntNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","'Nia'₂ guë'₂ dsa₂ i₂chan₂ juɨg₂ Capernaum, ¿lɨ́n'₂ 'nia'₂ a₂uɨg'₅₄ guei'₅₄ lɨn₃? On₃jua'₅₄ le₂jaun₂. Të₂ ja₁jɨ'₂ lɨn₃ ja₁tion'₅₄ 'lag₄ bá₄ sén'₂ 'nia'₂. Ia₁ jua'₂ mei'₂ guë́₃ jniá₂ ca₂jmo₃ léi₄ juë'₂ jë₄ juɨg₂ Sodoma juɨ₁lia'₂ a₂ma₂ca₂jmo₃ jniá₂ jë₄ quián'₂ 'nia'₂, a₂niog₅ bá₄ juɨg₂ jaun₂ ca₂të₂ jmɨg₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jaun₂ juá'₅ jniá₂, jmɨg₄ jë₁ma₂të́₂ rë₁qui₃dsɨ₅ Diú₄ 'éi'₃, 'ŋio₅ guë́₄ uɨg₅ guéi'₁ 'nia'₂ con'₂ guë́₄ dsa₂ i₂jme₁chan₂ juɨg₂ Sodoma. ");
INSERT INTO cntNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jmɨg₄ jaun₂ ca₂juá'₂ Jesús: ―Jme₁juɨ́n'₁ jniá₂ 'ne₂, Tia₅₄, i₂lɨ́ng'₅ juɨg₅₄ gua'₅₄ 'uë₃ quian'₅₄ guei'₅₄ i₂juɨ́g₃, ia₁ ca₂'ma'₅₄ a₂në₅ ja₁con₂ dsa₂ i₂tɨn₂ si₂, i₂ŋɨ́'₂ dsɨ́₅, a₂ma₂ca₂jme₁jniag'₂ ja₁con₂ dsa₂ i₂lɨ́n₅ lia'₂ lɨ́n₅ guein₂, i₂tsá₃ 'e₂ cuɨ́'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Dsón'₂ bá₄ jaun₂, Tia₅₄, ia₁ le₂në₅ ca₂rë₃'ŋió₃ 'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jaun₂ ca₂tsɨ́'₃ dsa₂: ―O₄gu₃ jniá₂ ma₂ca₂dsia₃ Ŋe'₃ ca₂le₃jë́₃. 'I₁jan₂ tsá₃ 'ein₂ cuɨn₅ Ja₁ŋi'₅₄ Diú₄ 'a₂ lia'₂ të₃dsón'₂ lɨ́in₅, jŋia'₅₄ lia'₂ 'ŋiog₅ bá₄ Jmei₂; ján₃ bá₄ 'i₁jan₂ tsá₃ 'ein₂ cuɨn₅ Jmei₂ 'a₂ lia'₂ të₃dsón'₂ lɨ́in₅, jŋia'₅₄ lia'₂ 'ŋiog₅ bá₄ Ja₁ŋi'₅₄ táng₃, ján₃ bá₄ jme₃jniai₂₃ ja₁con₂ i₂'nio₃ le₃ŋi₅. ");
INSERT INTO cntNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","I₂nó'₅ 'nia'₂ ja₁con₂ jniá₂, ca₂le₃jɨ́n'₃ 'nia'₂ i₂qui₂ma₂'ú'₃ dsɨ́₅, i₂qui₂le₁quian₅ guei₂, jaun₂ cuë₅₄ jniá₂ ja₁jan'₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gue₄ 'nia'₂ ta₁ quió₃ a₂cuë́₅ jniá₂ 'nia'₂, jme₁tɨn₅ 'nia'₂ jmó'₂ ján₃, 'a₂ lia'₂ lɨ́n₅ jniá₂, ia₁ juɨn'₂ dsɨ₃ lɨ́ng₅, meg'₂ bá₄ lë́₅ dsɨ₃; jaun₂ le₂në₅ bá₄ dsi₁nó'₅ 'nia'₂ dsiang'₂ ja₁jŋia₃ të₂'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ia₁ ta₁ a₂cuë́₅ jniá₂ 'nia'₂, on₃jua'₅₄ a₂'ua'₂ ta₁; ján₃ bá₄ le₂jaun₂ on₃jua'₅₄ a₂guei₂ cán'₁ 'nia'₂ a₂cuë́₅ jniá₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jmɨg₄ jaun₂ ca₂ŋɨ₃ Jesús ja₁lë́₄ ja₁nau₂ quió'₅ dsa₂ caun₂ jmɨg₄ sa₅₄. Dsa₂ i₂quiain'₅₄ në́₃ ca₂tá'₂ i₁cón'₅, jaun₂ qui₂ca₂gág₃ mɨ́'₂ trigo, jaun₂ ca₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jme₁ca₂jág₂ dsa₂ fairseos, jaun₂ ca₂o₃léin₂ ca₂tsɨ́'₃ Jesús: ―Jag₄ 'a₂ lia'₂ tion'₅₄ dsa₂ quiáng'₂ jmo₂₃ ta₁ a₂tsá₃ 'i₄ 'éi'₃ jmo₃ dsa₂ jmɨg₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jaun₂ ca₂ŋag₃ Jesús: ―¿Tsa₁ ma₂ca₂'í'₂ 'nia'₂ ne₄ Si₂ 'a₂ lia'₂ lë́₅ ca₂jmo₃ David co₂ráun₂ jme₁ca₂lë₃ i₁cón'₅ quiain'₅₄ rɨin'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ca₂'í₃ dsi₂néi₂ quió'₅ Diú₄, ca₂guë́'₃ i₁ŋí'₄ jŋió₅, a₂tsá₃ jme₁'i₄ 'éi'₃ guë́'₃, a₂'i₄ 'éi'₃ guë́'₃ jmá'₃ jme₂dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O₃ tsa₁ ma₂ca₂'í'₂ 'nia'₂ ne₄ Si₂ 'Éi'₃ quió'₅ Moisés, juɨ₁lia'₂ jme₂dsa₂ tsá₃ jme₂gó'₃ jmɨg₄ sa₅₄? La₁ tsá₃ 'ein₂ bón'₂ guë'₂ dso₄ 'éi₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Juɨ́g₂ jniá₂ 'nia'₂, ja₁lá₃ chén'₅ jan₂ i₂juɨn'₂ guë́₄ con'₂ guë́₄ guá'₅ templo. ");
INSERT INTO cntNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jua'₅₄ mei'₂ guë́₃ ma₂ŋɨ́'₂ 'nia'₂ 'e₂ jein₅ jág₁ la₂: “A₂'nio₃ jniá₂ a₂dsiá'₁ 'nia'₂ ŋéi₂ 'au'₂, on₃jua'₅₄ rë'₂ a₂jŋia'₅₄ qui₁jen'₅₄ 'nia'₂ 'e₂ qui₁jen'₅₄ ne₃”, tsá₃ jua'₅₄ jme₁bong'₅₄ dso₄ dsa₂ i₂tsá₃ 'e₂ dso₄ rɨn₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ia₁ le₂në₅ jaun₂, jniá₂, Jaun₅ dsa₂ mɨ₂güɨ́g₃, jmo₂₃ 'éi'₃ juɨ₁lia'₂ jmɨg₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ca₂o₃'ɨ́n₃ bá₄ Jesús ja₁jaun₂, jaun₂ ca₂'í₃ táng₃ dsi₂néi₂ guá'₅ sinagoga. ");
INSERT INTO cntNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ja₁jaun₂ jme₁'en₅₄ jan₂ dsa₂ i₂jle₅ caun₂ mɨ₂gu₂. Dsa₂ fariseos në́₃ jme₁'nio₃ 'no'₂ juɨ₅ bóin'₂ dso₄ Jesús, jaun₂ ca₂ŋag₃: ―¿'I₄ 'éi'₃ jme₃'lión₂ dsa₂ jan₂ dsa₂ dso'₅₄ jme₁jmɨg₄ sa₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jaun₂ ca₂ŋag₃ Jesús: ―¿'Ein₂ 'nia'₂, i₂'ŋio₅ jan₂ já'₂ cha'₂, në₁jua'₂ ca₂bain₃ siá₅ juɨ₁lia'₂ caun₂ jmɨg₄ sa₅₄, tsa₁ dsó₅ dsɨ₃dsein₂₃ já'₂ quiáin₅? ");
INSERT INTO cntNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡'Ë₂ guë́₄ bá₄ quen₅ jan₂ dsa₂ con'₂ guë́₄ jan₂ já'₂ cha'₂! Jaun₂ lë₃, 'i₄ bá₄ 'éi'₃ jmo₃ dsa₂ a₂dse₃ juɨ₁lia'₂ jmig₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jaun₂ guë́₄ ca₂tsɨ́'₃ dsa₂ dso'₅₄ 'éi₂: ―Nei'₅₄ gog'₂. Jaun₂ ca₂néi'₃ 'éi₂ gu₂, ca₂jŋia₃ quió'₅, jaun₂ ca₂lë₃ co₂rë₂ quian'₅₄ a₂caun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ca₂'uɨn₂ bá₄ dsa₂ fariseos 'éi₂ në́₃, jaun₂ ca₂jmo₃ jág₁ a₂jŋɨi'₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jme₁ca₂rë₃ŋi₅ Jesús jág₁ jaun₂, ca₂o₃'ɨ́in₃ bá₄. Jaun₂ juɨn₅ lɨn₃ dsa₂ i₃lén₂ chi₁co'₅₄ quió'₅ 'ein₂₃. Jme₁jme₂'lión₂ Jesús ca₂le₃jɨ́n₃ dsa₂ i₂le₁dso'₅₄, ");
INSERT INTO cntNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","jaun₂ ca₂juá'₂ a₂tsá₃ 'e₂ dsia₃ dsa₂ jua'₅₄ a₂'ag₃ 'ein₂ lɨ́in₅. ");
INSERT INTO cntNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Le₂në₅ bá₄ ca₂lë₃ ia₁jaun₂ le₃ti₃ jág₁ a₂ca₂'ë́₂ Isaías, dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, jme₁ca₂juá'₂ le₂la₂: ");
INSERT INTO cntNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","I₂la₂ bá₄ dsa₂ i₂jme₃ti₃ ta₁ ne₃, i₂ma₂ca₂quiong'₅₄, i₂'nióg₃ guë́₄ lɨn₃, jaun₂ 'io'₂ jéin₅ jniá₂ quiain'₅₄. Tón'₁ jniá₂ Jme₂dsí₂ quiáng₃ të₂dsɨ́₅, jaun₂ jme₃jniai₂₃ ca₂le₃jë́₃ juɨg₂ jɨn₄ dsɨ₂nau₂ 'ë₃ juɨ₅ dsau₅ të₃dsón'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tsá₃ quein₅ náu₃, on₃ guë'₂ guió'₃, on₃ guë'₂ né'₂ jág₁ quió'₅ jë₄ calle, ");
INSERT INTO cntNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Lia'₂ 'i₁ca₂tag₄ nɨ₁'ma₂ ta₅ tsá₃ jio₃, on₃ guë'₂ ei₃ nɨ₁mecha a₂ca₂juɨg₄ 'ia₂ guë́₄ jme₁ŋi₁. Jmo₃ le₂në₅ ca₂lia'₂ ca₂tió'₃ a₂lí'₂ a₂dsi₂ten₅₄ dsón'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jaun₂ caun₂ ja₁con₂ 'éi₂ bá₄ 'ag₃ dsa₂ caun₂ dsɨ́₅ ca₂le₃jɨ́n₃ dsa₂ i₂chan₂ ca₂le₃jë́₃ juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jaun₂ ca₂o₃jŋia₃ dsa₂ ja₁coin₂ jan₂ dsa₂ ten₄ i₂con₄ në́₃ i₂jme₁'en₅₄ jan₂ jme₂dsí₂ je₂na'₅₄. Jesús në́₃ ca₂jme₃'lió₂, ca₂jág₃ táng₃ dse₃, ca₂dsia₃ dse₃ jág₁ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ca₂i₃gó'₃ dsɨ́₅ ca₂le₃jɨ́n₃ dsa₂, jaun₂ ca₂juá'₂: ―¿On₁jua'₅₄ i₂në₅ lɨ́n₅ tsɨ₁jon₂ David? ");
INSERT INTO cntNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","La₁ jme₁ca₂nág₂ dsa₂ fariseos jág₁ jaun₂, ca₂dsia₃ jág₁ quian'₅₄ rɨin'₅₄: ―A₂'uɨn'₂ i₂në₅ je₂na'₅₄ quió'₅ dsa₂ të₂le₃ quian'₅₄ juɨ₅bí₂ quió'₅ Be'elzebú, juɨg₅₄ je₂na'₅₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","La₁ i₂ŋi₅ rë₂ bá₄ Jesús 'e₂ dsɨ₂jiog₅ dsɨ́₅ dsa₂ 'éi₂, jaun₂ ca₂juá'₂: ―Juɨ₁lia'₂ dsɨ₂tan₅₄ tion'₅₄ le₁dsoin'₅₄, nió'₅ mɨ'₅₄, tsá₃ uë́₂ tió'₅ jua'₅₄ tsá₃ dsɨ₃'én₂ 'éi'₃ quió'₅. Le₂në₅ bá₄ ján₃ juɨ₁lia'₂ dsa₂ caun₂ dsi₂néi₂, në₁jua'₂ lë́₅ le₁dsoin'₅₄, niog₅ mɨ'₅₄, ján₃ bá₄ tsá₃ uë́₂ tió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ján₃ bá₄ le₂në₅, në₁jua'₂ ca₂jmo₃ Satanás mɨ'₅₄ dsein₂₃ jan₂ i₂quiáin₅ 'ŋiog₅, co₂'nió'₄ 'ŋiog₅ bá₄ jmo₂₃ le₁dsoin'₅₄. ¿'A₂ lia'₂ lé₂ le₃'io₃ guë́₄ bí₂ 'éi'₃ quió'₅, chi₂jua'₂ le₂jaun₂? ");
INSERT INTO cntNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Chi₂jua'₂ jniá₂ 'uɨng'₅₄ je₂na'₅₄ quian'₅₄ bí₂ quió'₅ Be'elzebú juɨ₁lia'₂ juá'₂ 'nia'₂, ¿'ein₂ bá₄ guë'₂ cuë₅ bí₂ cuë́'₅ dsa₂ quián'₂ 'nia'₂ a₂'uɨ́in'₂ je₂na'₅₄ jaun₂ në́₃? 'Uɨg₅₄ jaun₂, guion₅₄ bá₄ dsa₂ quiáng'₂ jme₃li₅₄ a₂lɨ́n'₅ 'nia'₂ guiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","La₁ jniá₂ në́₃ në₂'uɨng'₅₄ je₂na'₅₄ të₂le₃ quian'₅₄ bí₂ quió'₅ Jme₂dsí₂ quián₅ Diú₄. Jaun₂ në́₃ le₂në₅ bá₄ cuë₅ jniá₂ léi₄ a₂ma₂gua₅ 'éi'₃ quió'₅ Diú₄ ja₁con'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Jaun₂ në́₃, ¿'a₂ lia'₂ lé₂ le₃'í₂ jan₂ dsa₂ dsi₂néi₂ quió'₅ juɨ₁lia'₂ jan₂ dsa₂ i₂'uan'₂, a₂jŋiá'₃ a₂te₁'i₁ quió'₅, chi₂jua'₂ le₂'uɨg₅₄ tsá₃ ma₂në₂'nei'₂ de'₂ dsa₂? Jŋia'₅₄ lia'₂ le₂jaun₂ bá₄ lé₂ le₃jŋiá'₃ a₂cha₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’I₂tsá₃ tión₂ le₃quió₃ jniá₂, dsa₂ i₂'iog₅₄ jniá₂ bá₄ 'éi₂; le₂jaun₂ guë'₂ i₂tsá₃ quian'₅₄ jniá₂ cág'₅, jŋia'₅₄ jmo₂₃ tsɨ₁rë₂ja₅₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Juɨ́g₂ jniá₂ 'nia'₂ jaun₂ në́₃, a₂lé₂ le₃'én₂ bá₄ ca₂le₃jë́₃ dsáu₁ dsa₂, ca₂le₃jë́₃ 'e₂ a₂'lɨg'₅₄ juá'₂ në́₃. La₁ në₁jua'₂ ca₂'ɨin₃ 'lɨg'₅₄ Jme₂dsí₂ quián₅ Diú₄, a₂në₅ guë́₄ tsá₃ ma₃o₂'én₂ dso₄ cha₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","La₁ në₁jua'₂ chan₂ i₂ca₂'ɨn₃ 'lɨg'₅₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃, lé₂ bá₄ le₂'én₂ dsáu₁; la₁ juɨ₁lia'₂ i₂'ɨn₅ 'lɨg'₅₄ Jme₂dsí₂ Jŋió₅, tsá₃ ma₃o₂'én₂ dso₄ cha₂ quió'₅, mɨ₂güɨ́g₃ la₂, on₃ guë'₂ mɨ₂güɨ́g₃ caun₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Chi₂jua'₂ jmo'₂ 'nia'₂ a₂le₃dse₃ nɨ₁'ma₂, mɨ́g₂ dse₃ bá₄ 'ag₃; la₁ chi₂jua'₂ jmo'₂ 'nia'₂ a₂le₃'lɨg'₅₄ nɨ₁'ma₂, mɨ́g₂ 'lɨg'₅₄ bá₄ 'ag₃ ján₃. 'Uɨg₅₄ jaun₂, të₂le₃ quian'₅₄ mɨ́g₂ a₂'ag₅ bá₄ nɨ₁'ma₂, jáng'₅ léi₄ chi₂jua'₂ dse₃ o₃ a₂'lɨg'₅₄ 'e₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡'Nia'₂ tsɨ₁jon₂ dsɨ₂mɨ'₂! ¿'A₂ bá₄ lia'₂ lé₂ le₃dsiá'₁ 'nia'₂ jág₁ dse₃, ton'₂ 'lɨn'₅₄ bá₄ guë'₂ 'nia'₂ guiong'₅₄? Ia₁ lia'₂ con'₂ lë́₅ a₂'lióng₂ ŋag₅₄ cha₂ të₂dsɨ́₅ dsa₂, a₂jaun₂ bá₄ 'uë₂ mɨ₂'o₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Juɨ₁lia'₂ dsa₂ dsen₃, jág₁ dse₃ bá₄ dsia₂₃, ia₁ jmá'₃ lia'₂ a₂dse₃ bá₄ rë₂'ma₄ të₂dsɨ́₅; le₂në₅ bá₄ juɨ₁lia'₂ dsa₂ 'lɨn'₅₄, jág₁ 'lɨg'₅₄ bá₄ dsia₂₃, ia₁ jmá'₃ lia'₂ a₂'lɨg'₅₄ bá₄ rë₂'ma₄ të₂dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jaun₂ juá'₅ jniá₂, jáng'₃ bá₄ dsa₂ mɨ₂güɨ́g₃ cuenta quió'₅ jë₁ma₂të́₂ jmɨg₄ i₁con₂ Diú₄ 'í₁, qui₃dsɨ₂₃ 'éi'₃ ne₄ ca₂le₃jë́₃ jág₁ a₂tsá₃ ta₁ tí₄. ");
INSERT INTO cntNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ia₁ të₂le₃ 'a₂ lia'₂ lë́₅ jág₁ quián'₂ bá₄ 'nia'₂, jióg'₂ 'í₁, rɨng'₂ o₃ tsá₃ rɨng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jaun₂ në́₃ i₂lɨn₅₄ dsa₂ fariseos quian'₅₄ të₅juá'₅ ca₂tsɨ́'₃ Jesús: ―Të₅, 'niog₂ jnia'₅₄ jag₅₄ caun₂ léi₄ juë'₂ a₂jmó'₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jaun₂ ca₂ŋag₃ Jesús: ―Tsɨ₁jon₂ dsa₂ 'lɨn'₅₄ i₂tsá₃ nag₃ la₂ mɨ₂₃ a₂jmo₅₄ jniá₂ caun₂ léi₄ juë'₂. La₁ tsá₃ ma₃'e₂ léi₄ lé₂ le₃cuë₅₄ jniá₂ ja₁con'₂ 'nia'₂, jŋia'₅₄ lia'₂ con'₂ léi₄ juɨ₁lia'₂ a₂ca₂i₃ŋɨ́₂ Jonás i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ia₁ juɨ₁lia'₂ ca₂'í₃ Jonás 'nɨ₅ jmɨg₄, 'nɨ₅ nei₅ të₂dsɨ́₅ já'₂ jmɨg₂ pan₅₄ 'éi₂, le₂jaun₂ bá₄ 'í₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ né'₃ 'uë₃ 'nɨ₅ jmɨg₄, 'nɨ₅ nei₅. ");
INSERT INTO cntNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jmɨg₄ jë₁ma₂të́₂ rë₁con₂ Diú₄ 'í₁, dsa₂ i₂jme₁chan₂ juɨg₂ ciudad Nínive, dsa₂ 'éi₂ bá₄ náu₃ qui₃dsɨ₂₃ 'éi'₃ ján₃ ja₁con'₂ 'nia'₂ dsa₂ chang'₂ jmɨg₄ në₃. Ia₁ dsa₂ 'éi₂ ca₂jéin'₃ dsɨ́₅ lia'₂ con'₂ jme₁ca₂'ë́₂ Jonás jág₁ quió'₅ Diú₄. La₁ në₃ në́₃ la₂ chén'₅ jan₂ i₂juɨn'₂ guë́₄ lia'₂ con'₂ guë́₄ Jonás 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","'Io₅₄ rag₅₄ i₂jme₁gon₂ 'uë₃ të₂le₃ sur, ján₃ bá₄ náu₃ 'éi₂ jmɨg₄ i₁qui₃dsɨ₅ Diú₄ 'éi'₃, ján₃ guë'₂ 'liog'₃ 'éi₂ 'liain'₃ 'nia'₂ i₂chang'₂ jmɨg₄ në₃. Ia₁ 'éi₂ në́₃ ca₂já₃ uɨ́ng₂ lɨn₃ ca₂'í₃ juɨ₅ a₂ca₂o₃néi₃ jág₁ quió'₅ Salomón 'a₂ lia'₂ jme₁ŋɨ́'₂ dsɨ́₅ 'éi₂ a₂ŋɨ́₄ lë₃ jme₁tɨin₂; la₁ në₃ në́₃, la₂ chén'₅ jan₂ i₂juɨn'₂ guë́₄ con'₂ guë́₄ Salomón 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Jë₁ma₂o₂'ɨ́n₃ jan₂ jme₂dsí₂ 'lɨn'₅₄ quió'₅ jan₂ dsa₂, jaun₂ dsɨ₂ŋɨ́₃ le₂tan₅₄ ja₁quein₂ 'no'₂ ja₁jŋia₃. Në₁jua'₂ tsá₃ ca₂dsó'₂ ja₁jŋia₃ në́₃, jaun₂ 'no'₂ táng₃ dsɨ́₅: ");
INSERT INTO cntNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Nég'₄ táng₃ dsi₂néi₂ quió₃ ja₁ca₂o₃'ɨ́ng₃.” Jë₁ma₂ca₂dsiáin'₃ jaun₂, dsain'₂ táng₃ dsa₂ 'éi₂ lɨ́in₅ co₂'nió'₄ bá₄ caun₂ dsi₂néi₂ a₂rë₂jë₄, rë₂'ia'₅₄, rë₂ chí'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jaun₂ në́₃ o₂'ɨin₅₄ táng₃ dsó₅ chi₂liain'₂ con'₂ guë́₄ guion₃ jme₂dsí₂ 'lɨn'₅₄ rɨin'₅₄ i₂lë₁'ŋio₅ guë́₄ con'₂ guë́₄ 'ŋiog₅. Dsɨ₂lein₅ dsɨ₂tiain'₂ të₂dsɨ́₅ dsa₂ 'éi₂. Jaun₂ dsa₂ 'éi₂ në́₃, dsióg₄ léin₂ le₃'lɨin'₅₄ guë́₄ lɨn₃ guë́₄ con'₂ guë́₄ jme₁lɨ́in₄ le₂'uɨg₅₄. Le₂në₅ bá₄ dsɨ₃ŋɨ́₂ tsɨ₁jon₂ 'lɨn'₅₄ i₂chan₂ rë₂në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Të₃ 'en₅₄ Jesús dsia₂₃ jág₁ tsɨ́'₅ dsa₂, jme₁ca₂dsi₃lén₂ chi'₂ rɨin'₅₄ quiain'₅₄ chog₅₄ në́₃. Ca₁'né₄ bá₄ ca₂tiáin'₂ a₂'nio₃ dsia₃ jág₁ quiain'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jaun₂ ca₂i₁con₂ jan₂ jág₁, ca₂juá'₂: ―Chog'₂ quian'₅₄ chi'₂ rɨ́ng'₂ tiáin'₅ ca₁'né₄, a₂'nio₃ dsia₃ jág₁ quian'₅₄ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jaun₂ ca₂ŋag₃ Jesús: ―¿'Ein₂ 'éi₂ cha₃ jniá₂, 'ein₂ 'éi₂ rɨ́n'₃ jniá₂ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jaun₂ në́₃ ca₂'ɨin₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂juá'₂: ―I₂la₂ bá₄ lɨ́n₅ co₂'nió'₄ cha₃ jniá₂, quian'₅₄ rɨ́ng'₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ia₁ juɨ₁'ein₂ guë́₃ i₂jmo₅ a₂'ŋio₂ dsɨ́₅ Ŋe'₃ jniá₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃, i₂'éi₂ bá₄ lɨ́n₅ juɨ₁lia'₂ dsó₂ rɨ́ng'₃, 'io₅₄ rɨ́ng'₃, cha₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jmɨg₄ jaun₂ ca₂o₃'ɨ́n₃ Jesús dsi₂néi₂ ja₁jme₁'ein₅₄, ca₂ŋó₃ ca₂i₁gua₂ chei'₅₄ jmɨ₁'ŋí'₄. ");
INSERT INTO cntNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ia₁ ca₂ŋɨ'₂ táng₃ juɨn₅ lɨn₃ dsa₂ le₃lág'₃ quió'₅ ja₁guá₄, jaun₂ ca₂'í₃ 'ŋió'₃ tsɨ₁mu₅, jaun₂ ca₂guá₂. Jaun₂ dsa₂ guë'₂ në́₃ ca₂tóin'₂ ca₂le₃jɨ́in₃ chei'₅₄ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jaun₂ në́₃ ca₂jme₃tɨin₂₃ dsa₂ 'lióng₂ lɨn₃ jág₁ të₂le₃ quian'₅₄ jág₁ a₂jáng'₅ léi₄. Ca₂juá'₂: ―Jan₂ dsa₂ ca₂ŋe₄ ja₁nau₂ ca₂i₁séi₄ mɨ́g₂ jon₂; ");
INSERT INTO cntNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","jme₁ma₂'ein₅₄ séi₂ në́₃, a₂lɨn₅₄ mɨ́g₂ jon₂ ca₂i₃ga'₅₄ le₂'i₄ juɨ₅, jaun₂ në́₃ i₁tan₅ bá₄ ca₂o₃lén₂ ca₂cág'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A₂lɨn₅₄ guë'₂ mɨ́g₂ jon₂ ca₂i₃to'₅₄ jë₄ nɨ₁cang₁, ja₁tsá₃ lɨn₄ gua'₅₄ lë́₅. A₂jaun₂ në́₃ tsá₃ uë́₂ ca₂rë₃'ag₄ ca₂'ia₂, ia₁ tsá₃ jɨ'₂ gua'₅₄ ja₁i₃to'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","La₁ jme₁ca₂të́₂ 'iog₂, ca₂rë₃juɨng₅, ca₂cáu₂ bá₄ a₂jaun₂, ia₁ tsá₃ jmú₄ 'lióng₂ jme₁ma₂cha₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A₂lɨn₅₄ guë'₂ i₃ga'₅₄ ja₁lë́₄ nɨ₁taun₅. Jme₁ca₂i₃cón₃ nɨ₁taun₅ në́₃, ca₂jlë₃ bá₄ jon₂ jaun₂ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","La₁ a₂lɨn₅₄ guë'₂ në́₃ ca₂tɨ́n₂ ja₁'o'₅₄ 'uë₃; a₂jaun₂ ca₂rau₂ dse₃; a₂lɨn₅₄ mɨ́g₂ jon₂ ca₂'ág₂ jma₃cáun₃ 'ŋiá₂-láu₂ mɨ́g₂ lia'₂ ca₂mɨ́g₂ jon₂ a₂i₃jnia₄; a₂lɨn₅₄ guë'₂ jma₃'nag'₂ ne₂guióg₂ mɨ́g₂, a₂lɨn₅₄ guë'₂ jma₃guióg₂-guiá₂ mɨ́g₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Chi₂jua'₂ 'ein₂ 'nia'₂ i₂dsi₅₄ rë₂gua₄, nei₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jaun₂ ca₂jme₃quián₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ con₂ Jesús, jaun₂ ca₂ŋag₃: ―¿'E₂ lë₃ jme₂tɨ́ng'₁ dsa₂ jmá'₃ lia'₂ quian'₅₄ jág₁ a₂jáng'₅ léi₄? ");
INSERT INTO cntNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jaun₂ në́₃ ca₂ŋag₃ Jesús: ―Diú₄ bá₄ jmo₅ a₂rë₃ŋɨ́'₂ 'au'₂ 'nia'₂ jág₁ rë₂'ma₄ juɨ₁lia'₂ 'a₂ lia'₂ lë́₅ ja₁goin₂ guei'₅₄ i₂juɨ́g₃. La₁ ja₁con₂ dsa₂ në₅ në́₃, tsá₃ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ia₁ juɨ₁lia'₂ dsa₂ i₂ŋɨ́'₂ dse₃, Diú₄ bá₄ jmo₃ le₃ŋɨ́i'₂ guë́₄ 'lióng₂, jaun₂ dsi₁léin₂ léin₂ dsa₂ i₂niog₅ dsi₄. La₁ juɨ₁lia'₂ i₂tsá₃ 'nio₃ le₃ŋɨ́'₂ në́₃, Diú₄ bá₄ jmo₃ co₂dsia₅ tsá₃ le₃ŋɨ́i'₂ co₂ŋei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'Uɨg₅₄ jaun₂ bá₄ a₂jme₂tɨ́n₂ jniá₂ dsa₂ të₂le₃ quian'₅₄ jág₁ a₂jáng'₅ léi₄: Ia₁jaun₂ i₂jág₃, la₁ tsá₃ le₃lí'₄ 'e₂ a₂në₂jág₃; i₂në₂néi₂ guë'₂ në́₃, la₁ tsá₃ ca₂rë₃lí'₄ 'e₂ a₂në₂néi₂, on₃ guë́₄ ca₂ŋɨ́i'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jaun₂ le₂në₅ rë₂ti₃ të₂le₃ quió'₅ dsa₂ në₅ juɨ₁lia'₂ ca₂juá'₂ Isaías i₂ca₂'ë́₂ jág₁ quián₅ Diú₄: Dsón'₂ bá₄ nág'₁ 'nia'₂, la₁ tsá₃ le₃ŋɨ́g'₂ 'e₂ a₂nág'₁; Caun₂ qui₁jag'₅₄ 'nia'₂ në́₃, la₁ tsá₃ le₃len'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ia₁ a₂ma₂'ua'₂ dsi₄ bá₄ dsa₂ la₂, ja₂lag₃ bá₄ nag₂₃, në₂jag₄ bá₄ i₂ma₂rë₂jnɨ₅ rë₂gua₄; ján₃ bá₄ le₂në₅, në₂jag₄ bá₄ a₂tsá₃ jniá₂ mɨ₂ne₅₄, ia₁jaun₂ tsá₃ jág₃ quian'₅₄ mɨ₂ne₅₄, on₃ guë'₂ nag₃ quian'₅₄ rë₂gua₅₄, on₃ guë́₄ le₃ŋɨ́'₂ dsɨ́₅, ia₁jaun₂ tsá₃ jéin'₃ dsɨ́₅ ja₁con₂ jniá₂ ia₁jaun₂ jme₁'lioin₁₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’La₁ 'e₂ guë́₄ dsen'₃ 'nia'₂ ia₁ jniá₂ mɨ₂ne'₅₄, nag'₂ bá₄ 'nia'₂ në́₃ quian'₅₄ rë₂guá'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, juɨn₅ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂, juɨn₅ dsa₂ dsen₃, jme₁'nio₃ të₃ ne₅₄ a₂jág'₂ 'nia'₂ rë₂në́₃, la₁ tsá₃ ca₂jág₃; jme₁'nio₃ nag₃ në́₃ juɨ₁lia'₂ a₂nag'₂ 'nia'₂ rë₂në́₃, la₁ tsá₃ ca₂nág₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","'Nei₂ 'nia'₂ jaun₂, 'e₂ jág₁ dsau₅ jáng'₅ juɨ₁lia'₂ jág₁ quió'₅ dsa₂ i₂séi₂ mɨ́g₂ jon₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Juɨ₁lia'₂ dsa₂ i₂nag₅ jág₁ dse₃ a₂já₅ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄, në₁jua'₂ tsá₃ ŋɨ́i'₂, lɨ́in₅ juɨ₁lia'₂ mɨ́g₂ jon₂ a₂ca₂séi'₂ dsi₂juɨ₅. I₂së₃dsen₃ bá₄ ja₂ ja₁coin₂, jaun₂ jŋiá'₂ táng₃ jág₁ dse₃ a₂jme₁ma₂jnia₄ të₂dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mɨ́g₂ jon₂ a₂ca₂séi'₂ guë'₂ jë₄ nɨ₁cang₁, lë́₅ juɨ₁lia'₂ lɨ́n₅ dsa₂ i₂gue₅ 'ŋio₂ dsɨ́₅ jág₁ dse₃ a₂nag₂₃, ");
INSERT INTO cntNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","la₁ia₁ tsá₃ cha₂ guë'₂ jë₁dsɨ₃'má₂ jmú₄ né'₃ 'uë₃, tsá₃ uë́₂ tió'₅; jaun₂ jë₁ma₂já₅ o₂i₁ dsɨ₅ a₂dsɨ₂ŋɨ́i₂ 'e₂ dsɨ₂ŋɨ́i₂, o₃ qui₂co₂'ein₅ dsa₂ o₄quió'₄ jág₁ quió'₅ Diú₄, guein₂₃ tí₂ bá₄ táng₃ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Juɨ₁lia'₂ mɨ́g₂ jon₂ a₂i₃ga'₅₄ jë₄ nɨ₁taun₅ guë'₂ táng₃, jáng'₅ jág₁ dsau₅ juɨ₁lia'₂ dsa₂ i₂nag₅ jág₁ dse₃, la₁ia₁ 'ŋio₅ lɨn₃ guë́₄ 'ɨ₅ dsɨ́₅ o₂me'₅₄ dsɨ₅ a₂cha₂ mɨ₂güɨ́g₃ la₂, a₂'ɨ́n₅ dsɨ́₅ a₂le₃cha₂ cu₄ a₂le₃chain₂ dse₃ në́₃, a₂në₅ bá₄ a₂jme₂gau₅ táng₃ quió'₅. Ca₂le₃jë́₃ a₂në₅ jlë́₂ bá₄ táng₃ jág₁ dse₃ a₂jme₁ma₂nág₂, jaun₂ tsá₃ ma₂'e₂ a₂dse₃ ráu₃ ja₁con₂ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","La₁ juɨ₁lia'₂ mɨ́g₂ jon₂ a₂ca₂séi'₂ ja₁dse₃ gua'₅₄, jáng'₅ táng₃ jág₁ dsau₅ të₂le₃ ja₁con₂ dsa₂ i₂nag₅ jág₁, ton'₂ ŋɨ́i'₂ në́₃; jaun₂ jmá'₃ lia'₂ ca₂ne₅₄ a₂dse₃ bá₄ rau₂ ja₁coin₂. I₂lɨn₅₄ guë'₂ dsa₂ 'éi₂ të₂le₃ quian'₅₄ a₂dse₃ rë₂jniá₂ a₂jmo₂₃, lɨ́in₅ juɨ₁lia'₂ lë́₅ lia'₂ ca₂cho'₅₄ mɨ́g₂ a₂ca₂i₃jnia₄, rau₂ caun₂ 'ŋiá₂-láu₂ mɨ́g₂ lia'₂ ca₂mɨ́g₂; i₂lɨn₅₄ guë'₂ jma₃'nag'₂ co₂ne₂guióg₂; i₂lɨn₅₄ guë'₂ jma₃guióg₂-guiá₂ mɨ́g₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ca₂juá'₂ Jesús táng₃ ca₂tsɨ́'₃ dsa₂ caun₂ jág₁ a₂jáng'₅ léi₄ siá'₂: ―A₂lë́₅ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄ lia'₂ lɨ́n₅ jan₂ dsa₂ i₂ca₂séi₂ ca₂ne₅₄ mɨ́g₂ jon₂ dse₃ 'uë₃ quió'₅; ");
INSERT INTO cntNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","la₁ caun₂ 'uë₂ jme₁ma₂le₁güɨ́n₃ dsa₂ le₃jɨ́in₃, ca₂guan₃ jan₂ dsa₂ 'lɨn'₅₄ i₂'iog₅₄ ca₂jmo₃ uɨg₅ dsɨ́₅ ca₂guia'₃ jon₂ nɨ₁nau₂ 'lɨg'₅₄ jë₄ trigo, jaun₂ ca₂ŋái'₃ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jme₁ca₂i₃cón₃ trigo, jme₁ma₂tio'₅₄ mɨ́'₂ në́₃, jë₄ jaun₂ ca₂'ia₂ nɨ₁nau₂ 'lɨg'₅₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jaun₂ në́₃, dsa₂ i₂jme₂ti₃ ta₁ ne₄ juɨg₅₄ ja₁nau₂, ca₂i₁con₂ jág₁ ne₄ juɨg₅₄, ca₂juá'₂: “Gui'₅₄, ¿on₁jua'₅₄ jmá'₃ ca₂ne₅₄ mɨ́g₂ jon₃ dse₃ ca₂jŋí'₂ ja₁nau₂ quiáng'₂ jme₁ca₂jŋí'₂? ¿'A₂ guë'₂ lia'₂ ca₂lë₃ a₂ca₂'ia₂ nɨ₁nau₂ 'lɨg'₅₄ jaun₂ në́₃?” ");
INSERT INTO cntNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jaun₂ ca₂ŋag₃ dsa₂ juɨg₅₄: “'An₁ jan₂ dsa₂ 'lɨn'₅₄ i₂'iog₅₄ bá₄ ca₂jmo₃ a₂në₅.” Jaun₂ ca₂ŋag₃ dsa₂ i₂jme₂ti₃ ta₁ ne₅₄: “¿Tsa₁ 'niog'₂ jua'₅₄ co₂dsia₅ dsɨ₁guéi₁ jnia'₅₄ nɨ₁nau₂ 'lɨg'₅₄ jaun₂?” ");
INSERT INTO cntNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Jaun₂ ca₂ŋag₃ táng₃ 'éi₂, ca₂juá'₂: “Jan₂'ón₄. Tió'₅ bá₄. Ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ le₂jiog₅ tag₄ trigo dse₃ bá₄ ca₂cang₅. ");
INSERT INTO cntNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ja₂lɨn₃ guë́₄ dse₃ juɨ₁le₁dsi₅₄ me'₂ jaun₂, juɨ₁dsi₂cón₃ bá₄ co₂lë₅, ca₂lia'₂ ca₂të́₂ jmɨg₄ i₁ráu₃; jaun₂ guë́₄ tsɨng₅₄ dsa₂ a₂dsɨ₃cang₅₄ de'₂ le₂'uɨg₅₄ nɨ₁nau₂ 'lɨg'₅₄, jaun₂ cág'₃ jmá'₃ co₂dsong'₅₄ ia₁jaun₂ 'nei₃, dsɨ'₂, jaun₂ guë́₄ cág'₃ trigo tó'₃ caun₂ ja₁tó'₃ dsi₂néi₂ quió₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ca₂dsia₃ Jesús ján₃ caun₂ jág₁ a₂jáng'₅ léi₄ le₂la₂: ―Ja₁gon₂ Diú₄ guei'₅₄ i₂juɨ́g₃, lë́₅ juɨ₁lia'₂ lë́₅ mɨ́g₂ jon₂ quió'₅ nɨ₁'ma₂ mostaza a₂ca₂jné₂ jan₂ dsa₂ ja₁nau₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Dsón'₂ mɨ́g₂ jon₂ jaun₂ lë́₅ mɨ́g₂ a₂pí'₁ tei₄ guë́₄ 'ŋio₅ lɨn₃ lia'₂ con'₂ guë́₄ mɨ́g₂ jon₂ siá'₂; la₁ia₁ jë₁ma₂ca₂i₃cón₃ në́₃, lë́₂ caun₂ nɨ₁'ma₂ pa₁ guë́₄ lia'₂ con'₂ guë́₄ rɨn'₅₄ a₂cha₂ ja₁nau₂ quió'₅, ca₂të₂ i₁tan₅ lé₂ le₃tiain'₃ gu'₂ nei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ca₂dsia₃ Jesús jág₁ a₂jáng'₅ léi₄ le₂la₂ táng₃: ―Lë́₅ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄, juɨ₁lia'₂ lë́₅ levadura a₂co₂güɨ́n'₂ jan₂ 'io₅₄ quian'₅₄ 'nɨ₅ tio'₅₄ ŋí₁ ca'₅₄ ti₁juɨ₁ harina, ia₁jaun₂ ron'₂ dse₃ ca₂le₃jë́₃ ti₁can₁. ");
INSERT INTO cntNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ca₂le₃jë́₃ jág₁ la₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂ të₂le₃ quian'₅₄ jág₁ a₂jáng'₅ léi₄; 'i₁co₂ráun₂ tsá₃ jme₁jme₂tag₂₃ jua'₅₄ tsá₃ të₂le₃ quian'₅₄ jág₁ a₂jáng'₅ léi₄. ");
INSERT INTO cntNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Le₂në₅ ca₂jmo₃ ia₁jaun₂ le₃ti₃ jág₁ a₂jme₁ma₂rë₂'ë́₂ quió'₅ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂ jme₁ca₂juá'₂: 'Uë'₅₄ jniá₂ jág₁ 'o₃ të₂le₃ quian'₅₄ jág₁ a₂jáng'₅ léi₄; dsia₅₄ jniá₂ jág₁ a₂tsá₃ ma₂ca₂rë₃jniá₂ ca₂le₃ ca₂jmo₃ Diú₄ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jaun₂ në́₃, ca₂o₃'ɨ́n₃ Jesús jɨn₄ dsa₂ juɨn₅ ja₁jme₁'ein₅₄ jaun₂ ca₂'í₃ táng₃ caun₂ dsi₂néi₂. Jaun₂ ca₂o₃lén₂ táng₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ ja₁coin₂, ca₂juá'₂: ―Dsia₄ lia'₂ tí₅ jág₁ 'e₂ jág₁ dsau₅ jáng'₅ juɨ₁lia'₂ jág₁ quió'₅ nɨ₁nau₂ 'lɨg'₅₄ a₂ca₂'ia₂ jë₄ trigo. ");
INSERT INTO cntNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jaun₂ ca₂ŋag₃ Jesús: ―Dsa₂ i₂ŋɨ₅ séi₂ mɨ́g₂ jon₂ dse₃, Jaun₅ dsa₂ mɨ₂güɨ́g₃ bá₄ 'éi₂; ");
INSERT INTO cntNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ja₁nau₂ guë'₂ lë́₅ co₂'nió'₄ mɨ₂güɨ́g₃ la₂. Jon₂ dse₃ guë'₂ në́₃, co₂'nió'₄ lɨ́n₅ chi'₂-guein₂ i₂tion'₅₄ 'éi'₃ quió'₅ Diú₄. Nɨ₁nau₂ 'lɨg'₅₄ guë'₂ në́₃, co₂'nió'₄ dsa₂ i₂tion'₅₄ juɨ₅ 'éi'₃ quió'₅ i₂së₃dsen₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dsa₂ 'lɨn'₅₄ i₂'iog₅₄ i₂ca₂jné₂ jon₂ nɨ₁nau₂ 'lɨg'₅₄, i₂së₃dsen₃ bá₄ 'éi₂. I₁ráu₃ guë'₂ në́₃, lë́₅ jmɨg₄ jë₁ca₂tó'₂; i₂ja₃lén₂ ja₃cag'₅₄ guë́₄ në́₃, ángeles quián₅ bá₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jaun₂, juɨ₁lia'₂ cág'₅ dsa₂ nɨ₁nau₂ 'lɨg'₅₄, a₂tó'₅ dsi₂si₂, le₂në₅ bá₄ lé₂ ján₃ jmɨg₄ jë₁ca₂tó'₂ mɨ₂güɨ́g₃ la₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Chen₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ ángeles quiáin₅ ia₁jaun₂ 'uɨ́in'₂ jë₄ quió'₅ dsa₂ quiáin₅ ca₂le₃jɨ́n₃ i₂jmo₅ qui₂sén'₂ rɨn'₅₄ a₂'no₂₃ dso₄, ca₂le₃jɨ́n₃ guë́₄ i₂ca₂rë₃chán₃ i₂tsá₃ ca₂tí₂ juɨ₅ 'lɨg'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jaun₂ to'₂ ja₁néi'₅ tsɨ'₄ si₂, ja₁tóin'₃ quɨ'₂-'o₂₃, qui₃quɨ́g'₃ jan₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jaun₂, dsa₂ dsen₃ quián₅ Diú₄ guë'₂ dsɨ₃lein₅ dsɨ₃tiain'₂ ja₁jniai₅₄ tág₅ juɨ₁lia'₂ jniá₂ 'iog₂ ja₁jmo₅ Diú₄ Jmei₂ 'éi'₃. Chi₂jua'₂ 'ein₂ 'nia'₂ i₂dsi₅₄ rë₂gua₄, rë₂ nei₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄ ján₃ bá₄ lë́₅ juɨ₁lia'₂ caun₂ a₂quen₅ 'ŋio₅ lɨn₃ a₂rë₂'ma₄ rë₂'o₅ né'₃ 'uë₃. La₁ juɨ₁lia'₂ jan₂ dsa₂ i₂dso'₂ në́₃, ja₁jaun₂ bá₄ 'ma₂₃ táng₃; ia₁ a₂ŋɨ́₄ lë₃ 'io'₂ jén'₅, jaun₂ dsáin'₅ dsɨ₂'nág₂ ca₂le₃jë́₃ 'e₂ a₂cha₂ quió'₅, jaun₂ lá₅ 'uë₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Ján₃ bá₄ lë́₅ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄ juɨ₁lia'₂ lɨ́n₅ jan₂ dsa₂ i₂ŋɨ₅ 'no'₂ perlas jlá'₁ ia₁jaun₂ jmo₃ 'ma'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jë₁ma₂ca₂dsó'₂ ca₂mɨ́g₂ a₂quen₅ lɨn₃, dsáin'₅ dsɨ₂'nág₂ ca₂le₃jë́₃ 'e₂ a₂cha₂ quió'₅, jaun₂ lá₅ mɨ́g₂ jlá'₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ján₃ bá₄ le₂jaun₂ lë́₅ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄ juɨ₁lia'₂ lë́₅ caun₂ tsɨ₁'má₅ a₂táun₂ dsa₂ ne₄ jmɨ₁ŋí'₄ jaun₂ 'uɨ́in'₂ ca₂le₃jɨ́n₃ ne₅₄ já'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jë₁ma₂ca₂rɨn₅ tsɨ₁'má₅, dsa₂ në́₃ 'ɨ́in₅ të₂le₃ chei'₅₄ jmɨ₁ŋí'₄; jaun₂ quióin'₂ jmá'₃ lia'₂ ju₄ dsen₃ caun₂ ja₁to'₂, jaun₂ guiain'₂ bá₄ juɨ₁lia'₂ já'₂ i₂tsá₃ dsen₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ján₃ bá₄ le₂jaun₂ lé₂ jmɨg₄ jë₁ca₂tó'₂ mɨ₂güɨ́g₃ la₂: 'uɨ́n₃ ángeles ja₃jmó₂ jma₃quén₅ dsa₂ 'lɨn'₅₄ jë₄ quió'₅ dsa₂ dsen₃ ");
INSERT INTO cntNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","jaun₂ toin'₂ i₂'lɨn'₅₄ ja₁néi'₅ tsɨ'₄ si₂ ja₁dsɨ₃toin'₅₄ quɨ'₂-'o₂₃ qui₃quɨ́g'₃ jan₅₄ në́₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jaun₂ ca₂ŋɨ́'₃ Jesús chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―¿Ŋɨ́g'₂ 'nia'₂ ca₂le₃jë́₃ jág₁ a₂juá'₅ jniá₂ në₅? Jaun₂ ca₂ŋag₃: ―Ŋág'₂ bá₄ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jaun₂ ca₂juá'₂ Jesús në́₃: ―Juɨ₁lia'₂ jan₂ të₅juá'₅ i₂ma₂ca₂jme₃tɨn₅ 'a₂ lia'₂ lë́₅ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄, lɨ́in₅ juɨ₁lia'₂ lɨ́n₅ jan₂ juɨg₅₄ tsɨ₁'né₅ i₂'uë́'₅ a₂quen₅ a₂te₁'i₁ le₁'ma₁ dsi₂néi₂ quió'₅, lia'₂ cosas 'mɨ́₂ lia'₂ cosas gui'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jme₁ca₂dsan₃ jme₂tɨn₅ Jesús dsa₂ jág₁ a₂jáng'₅ léi₄ në₅, ca₂o₃'ɨ́in₃ bá₄ ja₁jaun₂, ŋái'₃ juɨg₂ go₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jme₁ca₂dsiáin'₃ jaun₂ në́₃, ca₂jme₃lióg₃ ca₂jme₃tɨin₂₃ dsa₂ jág₁ dse₃ quió'₅ Diú₄ dsi₂néi₂ guá'₅ sinagoga quió'₅ dsa₂ ja₁jaun₂, jaun₂ dsa₂ në́₃, ca₂i₃gó'₃ dsɨ́₅ jág₁ a₂ca₂nág₂, jaun₂ ca₂dsia₃: ―¿A₂já'₄ ca₂i₁jme₁tɨn₅ i₂në₅ jág₁ a₂ŋɨ́₄ lë₃ tɨin₂₃ në₅? ¿'A₂ bá₄ lia'₂ 'io₂₃ bí₂ a₂tɨin₂ jmo₃ o₂dsain₂ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿On₁jua'₅₄ i₂në₅ ja₁ŋi'₅₄ të₅'má₃? ¿On₁jua'₅₄ chog₅₄ i₂chen₂ María? ¿On₁jua'₅₄ i₂në₅ i₂lɨ́n₅ rɨn'₅₄ Santiago quian'₅₄ Së́₄, Si₂mu₅₄, Judas në́₃? ");
INSERT INTO cntNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿On₁jua'₅₄ jë₄ quián₂ jniog₄ la₂ tián'₅ 'io₅₄ rɨin'₅₄ në́₃? ¿'A₂ bá₄ já'₄ já₅ a₂ŋɨ́₄ lë₃ cuɨ́'₅ i₂në₅ ca₂le₃jë́₃ jág₁ a₂tɨin₂ në₅? ");
INSERT INTO cntNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jaun₂ tsá₃ dse₃ ca₂tɨ́n₂ dsa₂ jág₁ jaun₂ quió'₅, tsá₃ juɨ₅ ca₂tón'₃ dsa₂. La₁ ca₂juá'₂ Jesús: ―Ca₂le₂con₂ bá₄ juɨg₂ siá'₂ jme₂gan₃ dsa₂ juɨ₁lia'₂ jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄; jŋia'₅₄ lia'₂ dsa₂ go₅₄ bá₄, tsá₃ jei₅₄, quian'₅₄ dsa₂ dsi₂néi₂ quió'₅ 'ŋiog₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jaun₂ tsá₃ ma₃léi₄ juë'₂ lɨn₅₄ ca₂jmo₃ ja₁jaun₂, ia₁ tsá₃ guë'₂ 'én₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jmɨg₄ jaun₂ Herodes, i₂jme₁lɨ́n₄ dsi₄má'₂ 'uë₃ Galilea, ca₂rë₃ŋi₅ jág₁ a₂ŋɨ₅ Jesús le₂con₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jaun₂ dsia₂₃ tsɨ́'₅ dsa₂ i₂jme₂ti₃ ta₁ ne₅₄: ―Juan₅₄ i₂chon₅ dsa₂ jmɨg₂ bá₄ në₅ ŋɨ₅; ma₂ca₂jein'₅₄ táng₃. 'Uɨg₅₄ jaun₂ 'io₂₃ juɨ₅bí₂ a₂jmo₂₃ léi₄ juë'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ia₁ le₂jŋiá₅ ma₂ca₂jŋa'₃ dsa₂ Juan₅₄ 'éi'₃ quió'₅ Herodes, ca₂'nei'₂, ca₂to'₂ dsa₂ né'₃ 'má₃ në́₃. Ca₂jmo₃ le₂në₅ 'uɨg₅₄ quió'₄ 'io₅₄ Herodías i₂jme₁lë́₄ dsa₂ mɨ́₂ quián₅ Fe₂li₄ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ia₁ 'lióng₂ ráun₂ ma₂qui₂ma₂juá'₂ Juan₅₄ ma₂qui₂ma₂tsɨ́'₃ Herodes: “Tsá₃ 'i₄ 'éi'₃ cáng'₄ 'io₅₄ në₅.” ");
INSERT INTO cntNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","'Uɨg₅₄ jág₁ jaun₂, jme₁'nio₃ Herodes jŋɨi'₃ Juan₅₄, la₁ tsá₃ tiá₂ dsɨ́₅, ia₁ jme₁gain₃ dsa₂; ia₁ ca₂le₃jɨ́n₃ bá₄ dsa₂ jme₁'éin₂ a₂lɨ́n₅ Juan₅₄ jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","La₁ caun₂ jmɨg₄ në́₃, jme₁ca₂dsɨ́'₃ Herodes ŋi₂, ca₂o₃'ɨ́n₃ ja₁mɨ́g₄ 'io₅₄ Herodías, ca₂dsáin₂ jɨn₄ dsa₂ i₂té₁ jmɨg₄. A₂në₅ në́₃ ca₂të́₂ dsɨ́₅ 'ŋio₅ lɨn₃ Herodes, ");
INSERT INTO cntNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ca₂lia'₂ ca₂cuë₃ jág₁ quió'₅, ca₂le₃jë́₃ 'ɨin₂₃ Diú₄ a₂cuë₃ 'e₂ caun₂ a₂mɨ₃ 'io₅₄ bë'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jaun₂ në́₃, jme₁ma₂në₂tio'₂ chog₅₄ jág₁, ŋó₃, ca₂juá'₂: ―Cuë₄ mɨ₂dsi₄ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂, të₂në₃, 'i₄ 'ŋió'₃ uɨng₅. ");
INSERT INTO cntNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jaun₂ ca₂tá'₂ 'lia'₂ dsɨ́₅ rag₅₄ jme₁ca₂nág₂ le₂në₅, la₁ tsá₃ ma₃'e₂ ŋi₅ jmo₃, ia₁ ma₂në₂cuë₃ jág₁ quió'₅ a₂'ɨin₂₃ Diú₄, të₃nag₅ dsa₂ i₂tion'₅₄ dsi₂néi₂ ja₁niog₅ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jaun₂ lë₃, ca₂jmo₃ 'éi'₃ a₂ca₂i₁qui'₂ dsa₂ mɨ₂dsi₄ Juan₅₄ dsi₂néi₂ tsɨ₁'né₅ 'má₃. ");
INSERT INTO cntNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dsɨ₂juɨ₅ jaun₂ bá₄ ca₂o₃can₅ dsa₂ mɨ₂dsi₄ Juan₅₄ rë₂'i₄ 'ŋió'₃ uɨng₅, jaun₂ ca₂cuë́'₃ 'io₅₄ bë'₅₄ 'éi₂, jaun₂ 'éi₂ në́₃ ca₂i₁con₂ ne₄ chog₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jme₁co₂lág₂ jaun₂ në́₃, ca₂o₃lén₂ dsa₂ i₂jme₁quian'₅₄ Juan₅₄, jaun₂ ca₂tág₃ 'lag₄ 'éi₂ ca₂i₁'ó₄. Jaun₂ guë́₄ ca₂i₁lein₅₄ ca₂i₁chi'₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jme₁ca₂rë₃ŋi₅ Jesús jág₁ në₅, ca₂o₃'ɨ́in₃ ja₁jme₁'ein₅₄, ca₂'í₃ 'ŋió'₃ caun₂ tsɨ₁mu₅, a₂jme₁i₂'i₅ caun₂ ja₁co₂'ŋiog₅. La₁ juɨn₅ dsa₂ juɨg₂ te₁'i₁ con'₂ ma₂quián₅ jaun₂ ca₂rë₃ŋi₅, jaun₂ ca₂'uɨin₂, ca₂i₁lein₅₄ ca₂i₁'ein₂₃ Jesús juɨ₅ tag₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jme₁ca₂dsióg₃ Jesús le₂'ŋo'₅₄ jmɨg₂, ca₂jág₃ juɨn₅ lɨn₃ dsa₂ ma₂tión₂ le₁jŋiog₅. Jaun₂ ca₂dsia₃ ŋéi₂ dsɨ́₅ dsa₂ 'éi₂, ca₂jme₃'lióin₂ dsa₂ i₂jme₁qui₂le₁dso'₅₄ quián₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Të₂le₃ ca₂'láu₂ jaun₂, ca₂o₃lén₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ ca₂juá'₂ ca₂tsɨ́'₃ Jesús: ―Ca₂'láu₂ bá₄ la₂, ton'₂ caun₂ ja₁co₂'ŋiog₅ bá₄ la₂ ja₁tsá₃ 'ein₂ tián'₅. 'Ei'₂ jág₁ dsa₂ ia₁jaun₂ dsɨ₃léin₂ le₂con₂ juɨg₂ ma₂quián₅ në₅, qui₂dsɨ₃lia₅ ca₂la₂ a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jaun₂ ca₂ŋag₃ Jesús: ―Tsá₃ tion₅₄; cuë'₅₄ 'nia'₂ dsa₂ guiong'₅₄ a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―Tsá₃ 'e₂ a₂siá'₂ cha₂ ja₁lá₃, jŋia'₅₄ lia'₂ 'ŋiá₂ i₁ŋí'₄ bá₄, quian'₅₄ on₃ i₁ju₁. ");
INSERT INTO cntNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jaun₂ ca₂juá'₂ táng₃ Jesús: ―O₂quian₂ 'nia'₂ ja₁lá₃. ");
INSERT INTO cntNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jaun₂ në́₃, ca₂tsɨ́'₃ dsa₂ a₂tiain'₃ ne₄ 'uë₃. Jaun₂ ca₂jŋa'₃ ta₁'ŋiá₂ i₁ŋí'₄ quian'₅₄ le₃on₃ i₁ju₁, jaun₂ ca₂chóg'₃ ne₅₄ guei'₅₄ i₂juɨ́g₃, ca₂cuë́'₃ ti₁'mag'₄ Diú₄. Jaun₂ ca₂dsioin₃ le₂caun₂ le₂caun₂ i₁ŋí'₄, ca₂cuë́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂. Jaun₂ 'éi₂ guë́₄ në́₃ ca₂dsió'₃ jɨn₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ca₂le₃jɨ́n₃ bá₄ dsa₂ ca₂guë́'₃ ca₂lia'₂ ca₂'ág'₃ dsɨ́₅. Jme₁ca₂lë₃ guë́'₅, jaun₂ ca₂cág'₃ bá₄ guë́₄ guia₃-tɨ́n₂ tsɨ₁mɨ'₂ 'nau₅₄ a₂ca₂chóng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dsa₂ i₂ca₂guë́'₃ 'éi₂ jme₁tén₄ 'ŋiá₂ mei₅ jmá'₃ lia'₂ dsa₂ ŋe'₂, i₂sián'₂ bá₄ dsa₂ mɨ́₂, chi'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dsɨ₂juɨ₅ jme₁ca₂lë₃ jaun₂, ca₂jmo₃ Jesús 'éi'₃ a₂tón'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ 'ŋió'₃ tsɨ₁mu₅, a₂ŋɨ́₃ de'₂ 'éi₂ jmɨg₂ le₁jŋiái₄ lia'₂ con'₂ guë́₄ 'ŋiog₅ a₂dsɨ₃lein₃, të₁lia'₂ 'í₂ 'ŋiog₅ 'ág'₅ jág₁ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jme₁ca₂lë₃ 'ág'₅ jág₁ dsa₂, ca₂ŋó₃ juɨ₅ má'₂ i₁chi₂i₁lein'₄ Diú₄. Ca₂tó'₂ nei₂ jme₁ca₂tó'₂, jaun₂ bá₄ 'ein₅₄ 'ŋiog₅. ");
INSERT INTO cntNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tsɨ₁mu₅ a₂tion'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ në́₃, jme₁ma₂dsióg'₃ dsi₂jo₂ jmɨ₁ŋí'₄. Jmɨg₂ në́₃, qui₂jná'₅ tiá₂ lɨn₃ dso'₂ tsɨ₁mu₅, ia₁ 'ei₅ tiá₂ dsí₂ 'liog'₂ le₃ca'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Le₁né₃ të₂le₃ ca₂jnia₃ jaun₂, ca₂jme₃quián₃ Jesús ja₁ŋáu'₄ tsɨ₁mu₅ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jaun₂ në́₃ jme₁ca₂jág₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ jóin'₅ ŋɨ₂₃ ne₄ jmɨ₁ŋí'₄, ca₂juɨin'₂ ca₂tóin'₂ co₂mɨ'₅₄ ca₂guió'₃ ca₂juá'₂: ―¡Jme₂dsí₂ 'lɨn'₅₄ bá₄ ó₃! ");
INSERT INTO cntNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","La₁ dsɨ₂juɨ₅ bá₄ ca₂juá'₂ Jesús në́₃: ―¡Dsia₄ 'nia'₂ tiá₂ 'au'₂! ¡Jniá₂ bá₄ la₂; tsá₃ lë₁juɨ́n'₂ 'nia'₂! ");
INSERT INTO cntNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jaun₂ Pe₄ në́₃ ca₂ŋag₃: ―Te₁gui'₅₄, chi₂jua'₂ 'ne₂ në₅, jmo₄ 'éi'₃ a₂nei₅₄ ŋɨ₅₄ ne₄ jmɨg₂ a₂dsióg₄ të₂ ja₁chéng'₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","―Ŋia₅ jaun₂ ―ca₂juá'₂. Jaun₂ ca₂sión₃ Pe₄ 'ŋió'₃ tsɨ₁mu₅, ca₂ŋɨ₃ ne₄ jmɨg₂ jme₁ŋó₄ ja₁chén'₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","La₁ jme₁ca₂tón'₃ juɨ₅ ca₂jág₃ 'a₂ lia'₂ 'ei₅ tiá₂ dsí₂, ca₂ja₃gó'₃ dsɨ́₅, jaun₂ guë́₄ ca₂rë₃lióg₃ ca₂i₃'óin'₅ jmɨg₂. Ca₂guió'₃ tiá₂, ca₂juá'₂: ―¡Lio₄ jniá₂, Te₁gui'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Dsɨ₂juɨ₅ jaun₂ ca₂néi'₃ Jesús gu₂, ca₂tɨ́in₂ quió'₅ Pe₄, jaun₂ juá'₂: ―¡'E₂ guë́₄ ca₂juɨg₄ 'én'₂ 'ne₂! ¿'E₂ lë₃ në₂'éi'₂ caun₂-tɨn₃ 'au'₂? ");
INSERT INTO cntNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jme₁ca₂i₃toin'₅₄ 'ŋió'₃ tsɨ₁mu₅, ca₂'ág₂ táng₃ tei₄ dsí₂. ");
INSERT INTO cntNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jaun₂ i₂jme₁tion'₅₄ 'ŋió'₃ tsɨ₁mu₅ ca₂jmo₃ i₁'áin₃ ne₄ Jesús, ca₂jme₃juag'₂. Jaun₂ ca₂juá'₂: ―Dsón'₂ bá₄ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","A₂ca₂'ain₂ jmɨg₂ jaun₂, ca₂dsi₃lein₃ 'uë₃ Genesaret. ");
INSERT INTO cntNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dsa₂ chan₂ ja₁jaun₂ në́₃, jme₁ca₂rë₃cuɨin₂₃ Jesús, jaun₂ ca₂i₁nioi₁₂ ca₂i₁can₅ jág₁ ca₂le₃jë́₃ juɨg₂ te₁'i₁ le₃lág'₃ jaun₂, jaun₂ ca₂o₃jŋia₃ dsa₂ ca₂le₃jɨ́n₃ dsa₂ i₂jme₁le₁dso'₅₄ ja₁'en₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jaun₂ ca₂mɨ₃ tsá₃ a₂nag₅₄ o₁jŋia'₅₄ 'ág₃ tag₄ tsɨn'₅₄ bá₄ cuë₃ jmɨg₄ nɨ́'₃ dsa₂ i₂le₁dso'₅₄; jaun₂ në́₃, ca₂le₃jɨ́n₃ dsa₂ dso'₅₄ i₂qui₂ca₂nɨ́'₃ tsɨn'₅₄ Jesús, ca₂'lóin₂ co₂ŋei'₅₄ dso₄ a₂jme₁lɨ́in₄. ");
INSERT INTO cntNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jaun₂ në́₃ ca₂o₃lén₂ i₂lɨn₅₄ dsa₂ fariseos quian'₅₄ të₅juá'₅ i₂ja₂lén₂ Jerusalén, ca₂jme₃quiáin₃ ja₁con₂ Jesús, jaun₂ ca₂ŋag₃: ");
INSERT INTO cntNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿'E₂ lë₃ tsá₃ jme₂ti₃ dsa₂ i₂quiang'₅₄ tag₄ 'éi'₃ a₂chí'₅ quió'₅ dsa₂ can'₅₄? Tsá₃ rang₂₃ gu₂ né'₃ guë́₄ a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jaun₂ ca₂ŋag₃ Jesús: ―'Nia'₂ guë'₂ në́₃, ¿'E₂ lë₃ qui₂tsó'₂ 'nia'₂ 'éi'₃ quió'₅ Diú₄ a₂jme₂tí'₁ 'nia'₂ jmá'₃ lia'₂ tag₄ quián'₂ 'nia'₂ guiong'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ia₁ ca₂juá'₂ Diú₄: “Jme₁gan₃ 'nia'₂ chog'₂-ŋéi'₅.” Ján₃ bá₄ ca₂juá'₂: “I₂të₂'on'₂ jmei₂, o₃ i₂të₃'on'₂ chog₅₄, ca₂tɨ́in₂ jóin₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","La₁ 'nia'₂ në́₃ jme₂tɨ́ng'₁ dsa₂, në₁'ein₂ cha₂ quió'₅ a₂lé₂ le₃jme₃'oin₅₄ chog₅₄-jmei₂, la₁ lag₃ në₁ca₂tsɨ́'₃ dsa₂ chog₅₄-jmei₂: “A₂ma₂rë₂jen'₅₄ ne₄ Diú₄ bá₄ a₂jaun₂”, ");
INSERT INTO cntNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","jaun₂ në́₃, jme₂tɨ́n'₂ 'nia'₂ dsa₂ 'éi'₃ a₂tsá₃ ma₃tion₅₄ 'nió'₅ jme₃'on₅₄ dsa₂ chog₅₄-jmei₂. O₄quió'₄ tag₄ quián'₂ 'nia'₂ guiong'₅₄ bá₄ ma₂ja₂nó'₅ 'nia'₂ jmo'₂ tsá₃ ma₃'e₂ quen₅ 'éi'₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡'Nia'₂ dsa₂ i₂lë₁jmo₅-dsáu₅ o₁ne₁ a₂jmo'₂ 'nia'₂ a₂jme₂juɨ́ng'₁ Diú₄ quian'₅₄ tag₄ quiáng'₂ ja₂nóg'₅! Dsón'₂ bá₄ dsau₅ a₂ca₂juá'₂ Isaías i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, jme₁ca₂tióng₃ ne₄ si₂, 'ɨin₂₃ 'nia'₂, jme₁ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Dsa₂ juɨg₂ la₂ jme₂juag'₂ jniá₂ jmá'₃ lia'₂ quian'₅₄ mɨ₂'o₅₄ bá₄, la₁ia₁ uɨ́ng₂ bá₄ 'i₄ dsɨ́₅ ja₁con₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","La₁ tsá₃ 'e₂ ta₁ tí₄ a₂jme₂juag'₂, ia₁ jág₁ a₂jme₂tag₂₃ jmá'₃ 'éi'₃ quió'₅ dsa₂ mɨ₂güɨ́g₃ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jaun₂ ca₂të́'₃ Jesús dsa₂ juɨn₅ i₂ma₂quiain'₅₄ a₂jme₃quián₃ 'éi₂ ja₁coin₂, jaun₂ ca₂juá'₂: ―Rë₂ nei₂ 'nia'₂ a₂la₂; juɨ₁le₂ŋɨ́'₂ 'nia'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Juɨ₁lia'₂ a₂dsɨ₂to'₅₄ juɨ₅ mɨ₂'o₄ dsa₂, on₃jua'₅₄ a₂jaun₂ jmo₅ a₂rë₃'iog₅ jme₂dsí₂ quió'₅ dsa₂. Ca₂le₃jë́₃ a₂'uë₂ juɨ₅ mɨ₂'o₄ dsa₂, a₂jaun₂ bá₄ jmo₅ a₂rë₂'iog₅ jme₂dsí₂ quió'₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jaun₂ ca₂jme₃quián₃ chi'₂ dsɨ₂guia₃-tɨ́n₂, jaun₂ ca₂juá'₂: ―¿Tsa₁ ŋi'₅₄, 'ŋio₅ lɨn₃ tsá₃ dse₃ ca₂tɨ́n₂ dsa₂ fariseos jág₁ a₂në₂chei'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","La₁ ca₂ŋag₃ Jesús: ―Ca₂le₃jë́₃ nɨ₁'ma₂ a₂tsá₃ ca₂chéin'₃ Ŋe'₃ jniá₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃, guéi₃ le₂jiog₅ jmú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","O₁lë́₄ me'₂; ia₁ dsa₂ ten₄ bá₄ në₅ quian₅ ne₄ juɨ₅. Ia₁ në₁jua'₂ jan₂ dsa₂ ten₄ jŋiai₂₃ dsa₂ ten₄ rɨin'₅₄, le₃oin₃ bá₄ tsɨ₃séin'₂ siá₅. ");
INSERT INTO cntNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jaun₂ ca₂juá'₂ Pe₄ ca₂tsɨ́'₃ Jesús: ―Jua'₅₄ 'e₂ jág₁ dsau₅ jáng'₅ jág₁ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jaun₂ ca₂ŋag₃ Jesús: ―¿Ján₃ bá₄ tsá₃ ŋɨ́'₂ 'au'₂ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ia₁, ¿tsa₁ ŋɨ́'₂ 'nia'₂, juɨ₁lia'₂ ca₂le₃jë́₃ a₂dsɨ₂to'₅₄ juɨ₅ rë₂'o₄ dsa₂, dsɨ₂lé₂ rë₂tú'₅ bá₄ dsa₂, cang₂ jaun₂ 'uë₂ táng₃? ");
INSERT INTO cntNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","La₁ juɨ₁lia'₂ a₂'uë₂ juɨ₅ mɨ₂'o₄ dsa₂, a₂jaun₂ a₂já₅ të₂dsɨ́₅ bá₄ dsa₂. A₂jaun₂ bá₄ jmo₅ a₂rë₂'iog₅ jme₂dsí₂ quió'₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ia₁ të₂dsɨ́₅ bá₄ dsa₂ já₅ ca₂le₃jë́₃ a₂'lɨg'₅₄ a₂dsɨ₂jiog₅ dsɨ́₅: juɨ₁lia'₂ a₂jme₂dsian₅ dsa₂ dsa₂ mɨ₂güɨ́g₃ rɨin'₅₄: juɨ₁lia'₂ a₂nió'₅ dsa₂ jág₁ quian'₅₄ dsa₂ i₂tsá₃ lɨ́n₅ dsɨ₂i₂gu₂, juɨ₁lia'₂ a₂lë₁i₂nio₄ dsa₂ tiáin'₅, tsá₃ gu₂ le₁jen'₂; juɨ₁lia'₂ a₂'ang₅ dsa₂; juɨ₁lia'₂ a₂nau₂ dsa₂ a₂jáng'₅ jág₁ dsau₅ a₂jmo₂₃ të₂jɨ́in₁; juɨ₁lia'₂ a₂jmo₅ dsa₂ a₂lë₁bóin'₂ dso₄ rɨin'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ca₂le₃jë́₃ a₂në₅ bá₄ jmo₅ a₂rë₂'iog₅ jme₂dsí₂ quió'₅ dsa₂; la₁ a₂guë́'₅ dsa₂ të₃ tsá₃ ma₂në₂jme₃ti₃ 'éi'₃ tag₄ a₂chí'₅ a₂rang₂₃ gu₂, on₃jua'₅₄ a₂jaun₂ jmo₅ a₂rë₂'ŋio₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","O₂'ɨ́n₃ bá₄ Jesús ja₁jaun₂, ca₂ŋó₃ táng₃ juɨ₅ juɨg₂ Tiro quian'₅₄ Sidón. ");
INSERT INTO cntNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ja₁jaun₂ jan₂ 'io₅₄ cananea i₂guá₅ jë₄ juɨg₂ jaun₂, ca₂guain₃ con₂ Jesús 'o₂₃ co₂mɨ'₅₄, juá'₂ tiá₂: ―¡Te₁gui'₅₄, jaun₅ David, dsia₄ ŋéi₂ 'au'₂ jniá₂! Jan₂ chi'₂ ja₁mɨ́g₄ jniá₂ 'en₅₄ jan₂ jme₂dsí₂ je₂na'₅₄ të₂dsɨ́₅, 'ŋio₅ lɨn₃ ŋág₅ uɨg₅. ");
INSERT INTO cntNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","La₁ tsá₃ 'e₂ ca₂ŋag₃ Jesús 'i₁caun₂. Jaun₂ o₃lén₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂juá'₂: ―Chei'₅₄ i₂në₅ juɨ₁dsiain'₅₄, ia₁ já₅ guió'₅ co₂mɨ'₅₄ chi₁co'₅₄ quián₂ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jaun₂ ca₂ŋag₃ Jesús ca₂tsɨ́'₃ 'io₅₄ 'éi₂: ―Ca₂chei₃ Diú₄ jniá₂ a₂guio₃ jmá'₃ lia'₂ ca₂ne₅₄ o₄quió'₄ já'₂ cha'₂ i₂ma₂i₂cón'₅ chan₂ juɨg₂ Israel. ");
INSERT INTO cntNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","La₁ caun₂ já₅ bá₄ 'io₅₄ 'éi₂, ca₂chi₃jné₃ ne₄ Jesús, ca₂juá'₂: ―¡Te₁gui'₅₄, jme₁'o₄ jniá₂! ");
INSERT INTO cntNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jaun₂ ca₂ŋag₃ Jesús: ―Tsá₃ dsi₂ten₅₄ jua'₅₄ a₂jŋiá'₄ jniá₂ i₁ŋí'₄ quió'₅ chi'₂-guein₂ a₂cuë́₄ dsɨ₂jɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jaun₂ ca₂ŋag₃ táng₃ 'io₅₄: ―Dsón'₂ bá₄ dsau₅, Te₁gui'₅₄; la₁ cág'₅ bá₄ dsɨ₂jɨ'₅₄ nɨ₁jne₁ a₂tsɨ₂séi'₂ ne₄ mesa ja₁guë́'₅ juɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―¡'E₂ guë́₄ tson₂ 'én'₂ 'ne₂, dsa₂ mɨ́₂! Juɨ₁le₅₄ bá₄ lia'₂ con'₂ lë́₅ a₂mɨ'₂ në₅. Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂'lón₂ chi'₂ ja₁mɨ́g₄ 'io₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","O₂'ɨ́n₃ bá₄ táng₃ Jesús ja₁jaun₂, jaun₂ ca₂ŋɨ́i₃ juɨ₅ chei'₅₄ jmɨ₁ŋí'₄ Galilea; jaun₂ ca₂uɨ́g₂ juɨ₅ ne₄ má'₂, jaun₂ ca₂guá₂ jme₁dsióg₃. ");
INSERT INTO cntNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Juɨn₅ dsa₂ ca₂dsi₃lén₂ táng₃ cau₅ quió'₅ ja₁jaun₂, le₁jŋiai₂₃ dsa₂ guian'₅₄, dsa₂ i₂le₁já'₂ gu₂-tag₄, dsa₂ ten₄, dsa₂ con₄, juɨn₅ guë́₄ dsa₂ sián'₂ i₂jme₁le₁dso'₅₄ në́₃. Qui₂ca₂dsiog₃ ja₁chén'₄ Jesús, jaun₂ ca₂jme₃'lió₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jaun₂ guë́₄ ca₂i₃gó'₃ dsɨ́₅ dsa₂ jme₁ca₂të́₂ ne₅₄ ma₂dsia₅ jág₁ dsa₂ i₂jme₁con₄, ma₂i₂nio₄ dsa₂ i₂jme₁qui₂le₁já'₂ quió'₅, quian'₅₄ dsa₂ guian'₅₄ në́₃; dsa₂ ten₄ në́₃ qui₂ca₂jág₃. Jaun₂ ca₂tón'₂ dsa₂ ca₂jme₃juɨin'₂ Diú₄ quián₅ dsa₂ Israel. ");
INSERT INTO cntNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jaun₂ ca₂të́'₃ Jesús chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂juá'₂: ―'Ŋio₅ ŋéi₂ dsɨ₃ jɨng₅₄ dsa₂ në₅, ia₁ ma₂'nɨ₅ jmɨg₄ tioin'₅₄ ja₁lá₃ quian'₅₄ jniá₂, 'i₁ca₂juɨg₄ tsá₃ 'e₂ cha₂ a₂guë́'₃ ja₁lá₃. Jaun₂ në́₃, tsá₃ 'nio₃ jniá₂ dsiain'₅₄ të₃ tsá₃ ma₂në₂guë́'₃, ia₁ con'₂ tsá₃ ŋó₅ në₁ca₂'uáin₂ le₂'i₄ juɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jaun₂ ca₂juá'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―¿A₂já'₄ lé₂ dsɨ₁liá₄ i₁ŋí'₄ ja₁co₂'ŋiog₅ la₂ a₂guë́'₃ dsa₂ juɨn₅ në₅? ");
INSERT INTO cntNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jaun₂ ca₂ŋag₃ Jesús ca₂ŋɨ́i'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―¿Je₂liá'₂ i₁ŋí'₄ 'i₄ guë́₄ quián'₂ 'nia'₂? Jaun₂ ca₂ŋag₃ 'éi₂: ―Guio₃ i₁ŋí'₄ bá₄ 'i₄, quian'₅₄ guë'₂ on₃-ún₂ ju₄ pí'₁. ");
INSERT INTO cntNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jaun₂ ca₂jmo₃ 'éi'₃ a₂tian'₃ dsa₂ 'uë₃, ");
INSERT INTO cntNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","jaun₂ ca₂jŋa'₃ ta₁guio₃ i₁ŋí'₄ quian'₅₄ i₁ju₁ në́₃, ca₂cuë́'₃ ti₁'mag'₄ Diú₄. Jaun₂ ca₂dsioin₃ le₂caun₂ le₂caun₂ i₁ŋí'₄, ca₂cuë́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ 'éi₂ guë́₄ në́₃ ca₂dsió'₃ jɨn₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ca₂le₃jɨ́n₃ bá₄ dsa₂ 'éi₂ ca₂guë́'₃ ca₂lia'₂ ca₂'ág'₃ dsɨ́₅. Jaun₂ ca₂cág'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ guio₃ tsɨ₁mɨ'₂ jmá'₃ nɨ₁jne₁ a₂ca₂chóng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dsa₂ i₂ca₂guë́'₃ 'éi₂ jme₁lë́₂ quén₂ mei₅ jmá'₃ dsa₂ ŋe'₂, i₂sián'₂ bá₄ dsa₂ mɨ́₂ quian'₅₄ chi'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jme₁ca₂lë₃ jaun₂, ca₂'ág'₃ Jesús jág₁ dsa₂, jaun₂ ca₂'í₃ 'ŋió'₃ tsɨ₁mu₅ a₂ŋó₃ juɨ₅ jë₄ juɨg₂ Magadán. ");
INSERT INTO cntNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Dsa₂ fariseos quian'₅₄ dsa₂ saduceos i₁lein₅₄ i₁jɨin₅₄ Jesús, ia₁ a₂'no'₂ juɨ₅ 'a₂ lia'₂ tiain'₃ Jesús quian'₅₄ jág₁; jaun₂ ca₂mɨ₃ a₂jmo₃ 'éi₂ caun₂ léi₄ a₂já₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","La₁ ca₂ŋag₃ Jesús: ―'Nia'₂ tɨng'₂ jág'₁ të₂le₃ ca₂'láu₂ jme₁lɨn₅₄, juá'₂ 'nia'₂: “Dse₃ bá₄ 'ei₅ táng₃ 'ióg₃, ia₁ guéin₂ bá₄ jniá₂ guei'₅₄ mɨ₂güɨ́g₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ján₃ bá₄ juá'₂ 'nia'₂ jme₁lɨn₅₄ juɨ₁lia'₂ të₃ o₃'iog₂, “Tiá'₃ jmɨ́₅ në₃, ia₁ guéin₂ jniá₂ jnei₅ tio'₅₄ guei'₅₄.” Ŋi'₅₄ bá₄ 'nia'₂ 'a₂ lia'₂ jua'₅₄ 'e₂ jein₅ jág₁ 'a₂ lia'₂ jniá₂ guei'₅₄, jŋia'₅₄ lia'₂ 'e₂ a₂të₅ ne'₅₄ 'nia'₂ jmɨg₄ në₃ bá₄, tsá₃ ŋi'₅₄ 'nia'₂ 'e₂ jein₅ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tsɨ₁jon₂ dsa₂ 'lɨn'₅₄ i₂tsá₃ nag₃ la₂, mɨ₂₃ a₂jmo₅₄ jniá₂ caun₂ léi₄ a₂o₂dsang₂. La₁ 'i₁caun₂ léi₄ siá'₂ tsá₃ 'e₂ ŋe'₂ 'nia'₂, jŋia'₅₄ lia'₂ caun₂ léi₄ juɨ₁lia'₂ a₂ca₂i₃ŋɨ́₂ Jonás bá₄. Jaun₂ ca₂tén₂ bá₄ Jesús dsa₂ 'éi₂, ca₂ŋái'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jme₁ca₂'an₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ jmɨ₁ŋí'₄, ca₂dsáu'₃ dsɨ́₅ tsá₃ 'e₂ i₁ŋí'₄ le₁quian₅ guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jaun₂ ca₂juá'₂ Jesús: ―Jmo₄ 'nia'₂ 'í₁ jaun₂ tsá₃ le₃tɨn'₂ 'nia'₂ juá'₅ a₂jme₂tag₅ dsa₂ fariseos, dsa₂ saduceos në́₃. Ia₁ juá'₅ quió'₅ lë́₅ lia'₂ lë́₅ juɨ₁ levadura. ");
INSERT INTO cntNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jaun₂ ca₂dsia₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ jág₁ tsɨ́'₅ rɨin'₅₄: ―Ia₁ tsá₃ i₁ŋí'₄ le₁quian₁ bá₄ jniog₄, jaun₂ bá₄ juá'₂ le₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","La₁ ca₂rë₃lí'₄ bá₄ Jesús 'e₂ jág₁ dsia₂₃, jaun₂ ca₂juá'₂: ―¿'E₂ lë₃ juá'₂ 'nia'₂ tsá₃ le₁quian'₄ i₁ŋí'₄? ¡'E₂ guë́₄ ca₂juɨg₄ 'én'₂ 'nia'₂! ");
INSERT INTO cntNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿'E₂? ¿Tsa₁ ma₂ca₂rë₃ŋɨ́'₂ 'nia'₂? ¿Tsa₁ ma₃dsá₂ 'au'₂ 'nia'₂ lia'₂ con'₂ ca₂dsio'₄ jniá₂ 'ŋiá₂ i₁ŋí'₄ ca₂lɨn₅ quió'₅ 'ŋiá₂ mei₅ dsa₂, on₃ guë'₂ dsá₂ 'au'₂ 'nia'₂ je₂liá'₂ tsɨ₁mɨ'₂ 'nau₅₄ a₂ca₂cag'₅₄ táng₃ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿On₃ guë'₂ dsá₂ 'au'₂ 'nia'₂ lia'₂ con'₂ ca₂dsio'₄ jniá₂ guio₃ i₁ŋí'₄ ca₂lɨn₅ quió'₅ quén₂ mei₅ dsa₂, on₃ guë'₂ dsá₂ 'au'₂ 'nia'₂ je₂liá'₂ tsɨ₁mɨ'₂ 'nau₅₄ a₂ca₂chóng₂ a₂ca₂cag'₅₄ 'nia'₂ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿'A₂ bá₄ lia'₂ ŋɨ́₄ tsá₃ rë₂len'₅₄ 'nia'₂? On₃jua'₅₄ i₁ŋí'₄ 'ë₅ jniá₂ jme₁në₂juá'₃ jmo₄ 'nia'₂ 'í₁ quian'₅₄ levadura quió'₅ dsa₂ fariseos quian'₅₄ dsa₂ saduceos. ");
INSERT INTO cntNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jaun₂ guë́₄ ca₂ŋɨ́'₂ dsɨ́₅ 'éi₂ a₂'ë₅ Jesús jaun₂, on₃jua'₅₄ a₂ca₂tɨ́in₂ jmo₃ 'í₁ juɨ₁lia'₂ juɨ₁ levadura a₂cón'₂ dsa₂ i₁ŋí'₄, a₂ca₂tɨ́in₂ jmo₃ 'í₁ 'a₂ lia'₂ lë́₅ juá'₅ a₂jme₂tag₅ dsa₂ fariseos quian'₅₄ dsa₂ saduceos bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jme₁ca₂dsióg₃ Jesús ma₂quián₅ juɨg₂ Cesarea ja₁tén₄ Filipo, jaun₂ ca₂ŋɨ́i'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―¿'Ein₂ lɨ́n₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃, juá'₂ dsa₂? ");
INSERT INTO cntNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jaun₂ ca₂ŋag₃ 'éi₂: ―I₂lɨn₅₄ dsa₂ juá'₂ a₂lɨ́ng'₅ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂; i₂sián'₂ guë'₂ juá'₂ a₂lɨ́ng'₅ Elías; i₂lɨn₅₄ guë'₂ juá'₂ táng₃ a₂lɨ́ng'₅ Jeremías, o₃ jan₂ i₂sián'₂ i₂já₅ 'ë́₂ jág₁ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jaun₂ ca₂ŋag₃ Jesús: ―¿'Nia'₂ guë'₂ në́₃? ¿'E₂ juá'₂ 'nia'₂ 'ein₂ lɨ́n₅ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jaun₂ ca₂ŋag₃ Si₂mu₅₄ Pe₄: ―'Ne₂ lɨ́ng'₅ dsa₂ I₂rë₂'ɨ́n₁, Ja₁ŋi'₅₄ Diú₄ jén'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jaun₂ ca₂ŋag₃ Jesús: ―'E₂ guë́₄ dsen'₃ 'ne₂, Si₂mu₅₄, ja₁ŋi'₅₄ Jonás, ia₁ 'i₁jan₂ dsa₂ mɨ₂güɨ́g₃ tsá₃ në₂jme₃jnia₅ ne'₅₄ a₂në₅, jŋia'₅₄ lia'₂ Ŋe'₃ jniá₂ i₂guá₅ i₂juɨ́g₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jaun₂ juá'₅ jniá₂ juɨ́g₂ 'ne₂, a₂ma₂cheng'₂ Pedro, jaun₂ ne₄ nɨ₁'lau₂ la₂ jmóg'₄ jniá₂ guá'₅ quió₃, jaun₂ ca₂lia'₂ jŋia'₅₄ i₂'io₅ bí₂ 'mú₃ tsá₃ le₃quɨ'₅₄ jmɨg₄ jua'₅₄ a₂tió'₃ quiong'₅₄ quian'₅₄ mai₅₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jaun₂ o₄gog'₂ 'ne₂ dsia₅₄ jniá₂ jág₁ dse₃ quió₃ a₂lë́₅ co₂'nió'₄ ŋí₁ llave a₂niá₃ ja₁dsɨ₃tion'₅₄ dsa₂ ja₁gon₂ Diú₄. Ca₂le₃jë́₃ 'e₂ a₂tsá₃ cuë́'₂ 'ne₂ jmɨg₄ ne₄ gua'₅₄ 'uë₃ la₂ lia'₂ con'₂ lë́₅ jág₁ quió₃, ján₃ bá₄ le₂jaun₂ tsá₃ lé₂ guei'₅₄ i₂juɨ́g₃; ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ a₂cuë́'₂ 'ne₂ jmɨg₄ gua'₅₄ 'uë₃ la₂ lia'₂ con'₂ lë́₅ jág₁ quió₃, a₂jaun₂ bá₄ lé₂ guei'₅₄ i₂juɨ́g₃ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jaun₂ ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ a₂tsá₃ 'ein₂ tsɨ́'₃ 'i₁jan₂ a₂lɨ́in₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Të₂le₃ ne₄ juɨ₅ ja₁ŋó₄ jaun₂, ca₂jme₃lióg₃ Jesús ca₂'ë́₂ jág₁ ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, a₂tion₅₄ dsó₃ juɨ₅ Jerusalén, ja₁dsɨ₃ŋɨ́i₂ 'lióng₂ ne₅₄ jmɨ₁uɨg₅ a₂jmóg'₂ dsa₂ can'₅₄ quián₅ guá'₅, quian'₅₄ juɨg₅₄ jme₂dsa₂, të₅juá'₅ në́₃. Jaun₂ ca₂juá'₂ a₂jŋag'₃ dsa₂, la₁ a₂'nɨ₅ jmɨg₄ jaun₂, jein'₅₄ bá₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jaun₂ Pe₄ në́₃ ca₂jiog₃ le₃cau₅, jaun₂ ca₂jme₃lióg₃ a₂të₂néi'₂ a₂jme₁jnéi₂ juɨ₅, ca₂juá'₂: ―¡Tsá₃ o₁le₅₄ le₂në₅, Te₁gui'₅₄! ¡O₁lɨ́g'₂ bá₄ tsá₃ juɨ₁dsi₂ŋɨ́'₂ 'ne₂ le₂në₅! ");
INSERT INTO cntNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","La₁ Jesús në́₃, ca₂jéin'₃ le₂ca'₃, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ Pe₄: ―¡Jŋiag'₃ cau₅ quió₃, Satanás! Jŋia'₅₄ jnɨ'₂ bá₄ 'ne₂ juɨ₅ quió₃, ia₁ tsá₃ le₂jaun₂ dsɨ₂jiog₅ 'au'₂ juɨ₁lia'₂ dsɨ₂jiog₅ dsɨ́₅ Diú₄. Ia₁ lia'₂ dsɨ₂jiog₅ dsɨ́₅ dsa₂ mɨ₂güɨ́g₃ bá₄ dsɨ₂jiog₅ 'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ ca₂le₃jɨ́n₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Chi₂jua'₂ 'ein₂ 'nio₃ 'éin₃ jniá₂, co₂dsia₅ juɨ₁dsi₂'én₂ dsɨ́₅ guioin₅₄, juɨ₁jmo₁₂ co₂jŋiai₅₄ a₂jóin₂, juɨ₁jia₂ chi₁co'₅₄ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ia₁ juɨ₁'ein₂ guë́₃ i₂tsá₃ 'nio₃ jón₂ ia₁ a₂'ɨ́n₅ dsɨ́₅ le₃chain₂ dse₃ mɨ₂güɨ́g₃ la₂, dsɨ₂'én₂ quió'₅. La₁ juɨ₁'ein₂ guë́₃ i₂tén'₂ dsɨ́₅ gue₃ 'mú₃ 'uɨg₅₄ quió₃ jniá₂, le₃chain₂ dse₃ mɨ₂güɨ́g₃ caun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ia₁, ¿'e₂ bá₄ ta₁ jmo₃ a₂lí'₂ dsa₂ 'ŋio₅ lɨn₃ ne₄ gua'₅₄ 'uë₃ la₂, në₁jua'₂ dsɨ₃'én₂ bá₄ guë'₂ jme₂dsí₂ quió'₅ mɨ₂güɨ́g₃ caun₂? ¿O₃ je₂liá'₂ lé₂ le₃quí₃ dsa₂ 'lia'₅₄ ia₁jaun₂ tɨ́n'₄ jme₂dsí₂ quió'₅? ");
INSERT INTO cntNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ia₁ Jaun₅ dsa₂ mɨ₂güɨ́g₃ jŋiói'₂ quian'₅₄ juɨ₅bí₂ jlá'₁ quió'₅ Jmei₂, quian'₅₄ ángeles quiáin₅, ja₃qui₅ 'lian'₅₄ dsa₂ 'a₂ con'₂ jŋia'₅₄ niog₅ ca₂jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A₂dsɨ₂jó'₃ juá'₅ jniá₂ juɨ́g₂ 'nia'₂, chan₂ i₂lɨn₅₄ juɨ₁lia'₂ i₂tion'₅₄ ja₁lá₃ tsá₃ dsián₃ ca₂lia'₂ ca₂të́₂ ne₅₄ jɨ́in₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ a₂jŋiói'₂ lɨ́in₅ rag₅₄ a₂qui₃dsɨ₂₃ 'éi'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jŋéi₂ jmɨg₄ cang₂ jaun₂, ca₂jŋia₃ Jesús Pe₄, Jacobo, quian'₅₄ Juan₅₄ rɨn'₅₄ Jacobo në́₃, ca₂i₃léin₂ con'₂ guioin₅₄ caun₂ má'₂ ŋei₅. ");
INSERT INTO cntNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ja₁jaun₂ ca₂rë₃tsɨ́n₃ 'a₂ lia'₂ jniá₂ Jesús të₃ jág₅ 'éi₂. Ne₄ Jesús ca₂jnia₃ tág₅ juɨ₁lia'₂ jniá₂ 'iog₂; tsɨn'₅₄ guë'₂ në́₃ ca₂jnia₃ tiog₂ jau₂ ca₂lia'₂ tág₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jaun₂ dsɨ₂juɨ₅ jaun₂ ca₂jnia₃ Moisés quian'₅₄ Elías, tióin₂ dsia₂₃ jág₁ quiain'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jaun₂ ca₂juá'₂ Pe₄ ca₂tsɨ́'₃ Jesús: ―Te₁gui'₅₄, ¡'e₂ guë́₄ dse₃ lia'₂ tio'₅₄ jniog₄ ja₁lá₃! Chi₂jua'₂ niog'₂, jmo₅₄ jniá₂ 'nɨ₅ tsɨ₁'io₅ láu₃: caun₂ quiáng'₂, caun₂ quió'₅ Moisés, caun₂ guë'₂ quió'₅ Elías në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Të₃jë₄ dsia₅ Pe₄ jág₁ jaun₂, ca₂lioin₂ caun₂ jnei₅ tág₅; jaun₂ jë₄ jnei₅ jaun₂ ca₂né'₂ jág₁ a₂juá'₂: ―I₂la₂ bá₄ jón₃ quiáng₃, i₂ŋɨ́₄ lë₃ 'nióg₃ guë́₄ lɨn₃. 'E₂ bá₄ 'ŋio₂ dsɨ₃ quiain'₅₄. Nei₂ 'nia'₂ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jme₁ca₂nág₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ jág₁ jaun₂, ca₂rë₃gó'₅ ca₂le₃jë́₃ ca₂i₃gain'₅₄ 'uë₃ le₁'éin₂, ");
INSERT INTO cntNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jaun₂ ca₂guán'₃ táng₃ Jesús cau₅ quió'₅, ca₂jŋau'₃, jaun₂ ca₂juá'₂: ―Nau₂ 'nia'₂; Tsá₃ lë₁jmo₂ 'nia'₂ gang'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jaun₂ jme₁ca₂jág₃ táng₃, tsá₃ ma₂'ein₂ i₂sián'₂ ca₂jɨ́in₂; jŋia'₅₄ lia'₂ 'ŋiog₅ bá₄ Jesús ma₂chéin'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jme₁ja₂lein₃ sióin₅ táng₃ má'₂ jaun₂, ca₂jmo₃ Jesús 'éi'₃, ca₂juá'₂: ―Tsá₃ 'ein₂ juɨg'₅₄ 'nia'₂ a₂në₂jag'₅₄ 'nia'₂ në₅, ca₂lia'₂ ca₂të́₂ jmɨg₄ jë₁ma₂ca₂jen'₅₄ táng₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ ne₄ 'mú₃. ");
INSERT INTO cntNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ ca₂ŋɨ́i'₃ Jesús: ―Chi₂jua'₂ le₂në₅, ¿'E₂ lë₃ juá'₂ të₅juá'₅, Elías bá₄ i₂jiá₃ le₂'uɨg₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jaun₂ ca₂ŋag₃ Jesús: ―Dsón'₂ Elías bá₄ jiá₃ le₂'uɨg₅₄, jaun₂ 'éi₂ bá₄ jme₃rë́₃ ca₂le₃jë́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","La₁ juá'₅ jniá₂, i₂ma₂guan₅ bá₄ Elías, la₁ tsá₃ 'ein₂ ca₂rë₃cuɨg₅. Jaun₂ qui₂ca₂jmóg'₂ dsa₂ lia'₂ lë́₂ dsɨ́₅ ca₂le₃jë́₃ guë́₄ 'a₂ lia'₂ 'nio₃ jmóg'₂. Ján₃ bá₄ le₂në₅, Jaun₅ dsa₂ mɨ₂güɨ́g₃ dsɨ₃ŋɨ́i₂ uɨg₅ o₄gú₃ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jaun₂ guë́₄ ca₂rë₃lí'₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, Juan₅₄ i₂ca₂chon₃ dsa₂ jmɨg₂ bá₄ 'ɨn₅ Jesús, a₂juá'₂ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jme₁ca₂dsi₃lein₃ ja₁tion'₅₄ dsa₂ juɨn₅, jaun₂ ca₂jme₃quián₃ jan₂ dsa₂ ja₁chén'₄ Jesús, jaun₂ ca₂chi₃jné₃ ne₅₄, jaun₂ ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Te₁gui'₅₄, dsia₄ ŋéi₂ 'au'₂ chi'₂ quiáng₃, 'ŋio₅ lɨn₃ ŋág₅ uɨg₅ lɨ́in₅ dso₄ 'ei₂; 'lióng₂ ráun₂ ma₂ca₂táin'₂ dsi₂si₂, dsi₂jmɨg₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma₂i₁jŋiai₅₄ jniá₂ ne₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáng'₂, la₁ tsá₃ ca₂tió'₃ jme₃'lió₂. ");
INSERT INTO cntNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jaun₂ ca₂ŋag₃ Jesús: ―¡'En₁ jmá'₃ tsá₃ 'e₂ 'én'₂ 'nia'₂! ¿Je₂liá'₂ jmɨg₄ jmá'₃ 'nió'₅ 'ú₄ quian'₅₄ 'nia'₂? ¿Je₂liá'₂ jmɨg₄ jmá'₃ 'nió'₅ jmo₅₄ tió'₅ dsɨ₃ quian'₅₄ 'nia'₂? I₂jŋia₅ chi'₂ ja₁lá₃. ");
INSERT INTO cntNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jaun₂ ca₂jí₂ Jesús ca₂jéin₂ je₂na'₅₄. Jaun₂ ca₂o₃'ɨ́in₃ të₂dsɨ́₅ chi'₂ 'éi₂, jaun₂ guë́₄ në́₃ ca₂'lóin₂ dsɨ₂juɨ₅ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jme₁co₂lág₂ jaun₂ ca₂dsia₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ jág₁ quian'₅₄ Jesús jë₄ con'₂ guioin₅₄, jaun₂ ca₂ŋɨ́i'₃ 'éi₂: ―¿'E₂ 'uɨg₅₄ tsá₃ ca₂tián₃ jnia'₅₄ dsén₄ i₂'lɨn'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jaun₂ ca₂ŋag₃ Jesús: ―Ne₄ ia₁ a₂ŋɨ́₄ lë₃ ca₂juɨg₄ 'én'₂ bá₄ 'nia'₂. A₂dsɨ₂jó'₃ juá'₅ jniá₂, jua'₅₄ mei'₂ guë́₃ 'én'₂ 'nia'₂, tsá₃ a₂nag₅₄ o₁jŋia'₅₄ con'₂ tí₅ ca₂mɨ́g₂ mɨ₂jon₂ mostaza, lé₂ le₃jme₁juɨg'₅₄ 'nia'₂ juɨ₁lia'₂ má'₂ ó₃: “Jŋiag'₃ ja₁në₅, gua₂ të₂le₃ ca₂taun₂”; má'₂ jaun₂ në́₃ jŋióg'₃ ja₁'ë'₂ 'nia'₂. 'I₁caun₂ tsá₃ 'e₂ cha₂ jua'₅₄ a₂tsá₃ lé₂ le₃jmó'₂ 'nia'₂ jua'₅₄ mei'₂ guë́₃ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Të₁lia'₂ i₂nioi₅₄ co₂lë₅ le₂con₂ ja₁tén₄ 'uë₃ Galilea, jaun₂ ca₂juá'₂ táng₃ Jesús a₂jáng'₂ dsa₂ jɨ́in'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ o₄gú₃ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Jaun₂ jŋag'₃ dsa₂, la₁ a₂'nɨ₅ jmɨg₄ jaun₂, jein'₅₄ bá₄ táng₃. Ca₂tá'₂ 'lia'₂ bá₄ dsɨ́₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ jme₁ca₂nág₂ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jme₁ca₂dsióg₃ Jesús juɨg₂ Capernaum quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, jaun₂ ca₂o₃lén₂ dsa₂ i₂cág'₅ jma₃tɨn₃ 'éi'₃ cu₄ dracma a₂'nió'₅ quió'₅ guá'₅ templo, jaun₂ dsa₂ 'éi₂ ca₂jme₃quiáin₃ con₂ Pe₄, ca₂ŋag₃: ―¿Tsa₁ quí₅ të₅ quián'₂ 'nia'₂ 'lia'₅₄ quió'₅ guá'₅? ");
INSERT INTO cntNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Jaun₂ ca₂ŋag₃ Pe₄: ―Ján₅. Quí₅ bá₄. Jme₁ca₂'i₃ Pe₄ dsi₂néi₂, jaun₂ 'ŋiog₅ Jesús de'₂ jŋiá₅ ca₂juá'₂ ca₂tsɨ́'₃ Pe₄: ―¿'A₂ lia'₂ lɨ́n'₂ 'ne₂, Si₂mu₅₄? Juɨ₁lia'₂ jan₂ rag₅₄ dsa₂ mɨ₂güɨ́g₃, ¿'Ein₂ quió'₅ mɨ₂₃ 'lia'₅₄? ¿Quió'₅ dsa₂ go₅₄, o₃ quió'₅ jmá'₃ dsɨ₂nau₂ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jaun₂ ca₂ŋag₃ Pe₄: ―Quió'₅ dsɨ₂nau₂ bá₄. Jaun₂ ca₂juá'₂ táng₃ Jesús ca₂tsɨ́'₃ 'éi₂: ―Tsá₃ ca₂tɨ́n₂ dsa₂ go₅₄ quí₃ jaun₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","La₁, jaun₂ tsá₃ tɨin₃ 'lɨg'₅₄, gua₂ o₂'éi₂ mɨ₂cu₄ dsi₂jmɨg₂, O₂dsen₅₄ i₁ju₁ i₂nág'₃ le₂'uɨg₅₄ mɨ₂cu₄. Mɨ₂'o₄ i₁ju₁ 'éi₂, dsiang'₂ caun₂ cu₄ 'ua'₂. A₂jaun₂ quɨ'₅₄ quián₂ jniog₄ le₃ó₃. ");
INSERT INTO cntNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ján₃ bá₄ jmɨg₄ jaun₂ táng₃ ca₂jme₃quián₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ con₂ Jesús jaun₂ ca₂ŋag₃: ―¿'Ein₂ lɨ́n₅ i₂dsen₅₄ guë́₄ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jaun₂ ca₂të́'₃ Jesús jan₂ i₂bë'₅₄, jaun₂ ca₂chei'₃ dsi₂jo₂ ja₁tiáin'₄, ");
INSERT INTO cntNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","jaun₂ ca₂juá'₂: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, në₁jua'₂ tsá₃ ca₂jme₁tsɨ́n'₄ 'nia'₂ 'au'₂, a₂léng'₂ lia'₂ lɨ́n₅ jan₂ i₂bë'₅₄, o₁lɨ́g'₂ jmɨg₄ tsá₃ lé₂ le₃dsi₁no'₃ 'nia'₂ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jaun₂ në́₃, i₂'éi₂ bá₄ i₂lén₂ i₂dsen₅₄ guë́₄ guei'₅₄ i₂juɨ́g₃ juɨ₁lia'₂ i₂jmo₅ me'₂ lia'₂ lɨ́n₅ chi'₂ bë'₅₄ la₂. ");
INSERT INTO cntNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Con'₂ siá'₂ táng₃, juɨ₁lia'₂ dsa₂ i₂guen₅ jan₂ guein₂ o₄quió₃ jniá₂ juɨ₁lia'₂ i₂la₂, jniá₂ bá₄ guei₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Juɨ₁'ein₂ guë́₃ i₂jmo₅ tsɨ₂sén'₂ juɨ₁lia'₂ chi'₂ bë'₅₄ i₂le₂la₂ i₂'én₂ të₂le₃ quió₃ jniá₂, ja₂lɨn₃ guë́₄ co₂ŋei'₅₄ dse₃ tón₂ dsa₂ ne₄ jmɨ₁ŋí'₄ rë₂quein₅ ca₂mɨ́g₂ nɨ₁to₂ dsɨ₂lag₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡'E₂ guë́₄ juɨ́g₂ dsa₂ mɨ₂güɨ́g₃ ia₁ tsá₃ caun₂ a₂ja₂lé₂ ja₁coin₂ a₂jmo₅ a₂tsɨ₂séin'₂! La₁ le₂jaun₂ dsón'₂ dsɨ₃ŋɨ́i₂ bá₄, la₁ 'e₂ guë́₄ juɨ́g₂ juɨ₁lia'₂ dsa₂ i₂ton'₂ jág₁ rɨn'₅₄ jaun₂ jén'₃ dsɨ́₅ 'éi₂ a₂'no₃ dso₄. ");
INSERT INTO cntNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’'Uɨg₅₄ jaun₂, chi₂jua'₂ mɨ₂gog'₂ o₃ mɨ₂tag'₅₄ 'e₂, jmo₅ a₂tang'₂ dso₄, co₂dsia₅ dse₃ 'nia₄, tiong₂ uɨ́ng₂; ia₁ ja₂lɨn₃ guë́₄ dse₃ a₂dsiáng'₄ ja₁le₃chang'₂ co₂tan₅₄ a₂rë₂'liáng'₃, con'₂ guë́₄ a₂jme₁o₁'ú'₃ a₂rë₂'ŋia₅ gog'₂-tag'₅₄ dsi₂si₂ ja₁tsá₃ ton₅ jmɨg₄ éi₃. ");
INSERT INTO cntNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Në₁jua'₂ mɨ₂ne'₅₄ jmo₅ a₂tang'₂ dso₄, dsi₄ ján₃, tiong₂ uɨ́ng₂: ia₁ ja₂lɨn₃ guë́₄ dse₃ a₂dsiáng'₄ ja₁le₃chang'₂ co₂tan₅₄ a₂teng'₅₄ ca₂mɨ́g₂ mɨ₂ne'₅₄, lia'₂ con'₂ guë́₄ a₂jme₁gog'₅₄ a₂rë₂'ŋia₅ ta₁tɨn₃ mɨ́g₂ mɨ₂ne'₅₄ dsi₂si₂ guio₃-juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Tsá₃ jmo₂ 'nia'₂ jua'₅₄ a₂tsá₃ jen'₅₄ juɨ₁lia'₂ jan₂ chi'₂ bë'₅₄ le₂la₂. Ia₁ juɨ́g₂ jniá₂ 'nia'₂, ia₁ ángeles i₂jmo₅ 'í₁ quiáin₅ co₂tan₅₄ bá₄ jɨ́in₂ Ŋe'₃ i₂guá₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿'A₂ lia'₂ lɨ́n'₂ 'nia'₂? Jua'₅₄ mei'₂ guë́₃ jan₂ dsa₂ 'ŋio₅ caun₂ 'ŋiá₂-lón₂ já'₂ cha'₂, në₁jua'₂ ca₂i₃cón'₅ jan₂, ¿tsa₁ ja₁jaun₂ chein'₂ ne₄ dsɨ₂con'₂ i₂quéin'₂ co₂ne₂guión₂ rë₂dsɨ́₂ guia₃-né₂ (99) con'₂ i₂te₂ 'éi₂, jaun₂ dsó₅ táng₃ dsɨ₂'niai'₂ i₂tsá₃ chan₂ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jë₁ma₂ca₂dsáu'₂ në́₃, a₂dsɨ₂jó'₃ juá'₅ jniá₂, 'ŋio₅ lɨn₃ guë́₄ 'io'₂ jmo₂₃ o₄quió'₄ i₂jan₂ 'éi₂ con'₂ guë́₄ i₂quéin'₂ co₂ne₂guióg₂ rë₂dsɨ́₂ guia₃-né₂ i₂tsá₃ i₂cón'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Le₂në₅ bá₄ ján₃, Ŋéi'₅ 'nia'₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃ tsá₃ 'nio₃ jua'₅₄ dsɨ₃cón'₅ ca₂lia'₂ 'i₁jan₂ i₂lɨ́n₅ guein₂ bë'₅₄ juɨ₁lia'₂ i₂la₂. ");
INSERT INTO cntNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Chi₂jua'₂ 'e₂ caun₂ a₂ca₂jmóg'₂ jan₂ rɨ́ng'₂, dsia₄ de'₂ 'nia'₂ jág₁ ja₁con'₂ guiong'₅₄, ja₁jaun₂ jme₁jniag'₂ ne₅₄ 'e₂ a₂ca₂jmóg'₂. Në₁jua'₂ ca₂tón'₃ juɨ₅ jág₁ quiáng'₂, ja₁jaun₂ ca₂dsan₃ bá₄ mɨ'₅₄, ca₂lë₃ bá₄ táng₃ rɨ́ng'₂ quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","La₁ në₁jua'₂ tsá₃ ca₂tón'₃ juɨ₅ jág₁ quiáng'₂ në́₃, te'₂ on₃-ún₂ dsa₂ sián'₂ ia₁jaun₂ “ca₂le₃jë́₃ 'e₂ niog₅ lé₂ jióg'₂ 'í₁ quian'₅₄ on₃-ún₂ dsa₂ i₂jáng'₃ jág₁ dsau₅, në₁jua'₂ tí₅ jág₁ jaun₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Në₁jua'₂ tsá₃ ca₂tón'₃ juɨ₅ jág₁ quió'₅ dsa₂ 'éi₂, chei'₅₄ guá'₅; në₁jua'₂ tsá₃ ca₂tón'₃ juɨ₅ on₃ guë'₂ jág₁ quió'₅ guá'₅ në́₃, të₂le₃ ja₁ŋó₄ jaun₂, jmo₄ 'au'₂ jɨin'₅₄ lia'₂ ja₁jɨng'₄ jan₂ dsɨ₂nau₂, o₃ juɨ₁lia'₂ jan₂ i₂cág'₅ cu₄ a₂ca₂tɨ́n₂ dsɨ₂tan₅₄ 'e₂. ");
INSERT INTO cntNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, ca₂le₃jë́₃ 'e₂ a₂tsá₃ cuë'₂ 'nia'₂ jmɨg₄ ne₄ gua'₅₄ 'uë₃ la₂, lia'₂ con'₂ lë́₅ jág₁ quió₃, ján₃ bá₄ tsá₃ lé₂ guei'₅₄ i₂juɨ́g₃; ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ a₂cuë'₂ 'nia'₂ jmɨg₄ ne₄ gua'₅₄ 'uë₃ la₂, lia'₂ con'₂ lë́₅ jág₁ quió₃, a₂jaun₂ bá₄ lé₂ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Ján₃ bá₄ juá'₅ jniá₂, në₁jua'₂ on'₃ 'nia'₂ jmo'₂ caun₂ jág₁ ne₄ gua'₅₄ 'uë₃ la₂, a₂mɨ́'₁ 'nia'₂ 'e₂ a₂'niog'₂ mɨ́'₁, cuë₃ bá₄ Ŋe'₃ jniá₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ia₁ jë₁le₁ŋɨ'₂ on₃-ún₂ o₄quió₃ jniá₂, jë₄ jaun₂ bá₄ 'eng₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jaun₂ Pe₄ në́₃ ca₂ŋag₃: ―Te₁gui'₅₄, ¿con'₂ je₂liá'₂ ráun₂ 'nió'₅ 'én₄ jniá₂ dsáu₁ rɨ́ng'₃ në₁jua'₂ 'e₂ caun₂ a₂ca₂jmóg'₂? ¿'A₂ lia'₂? ¿Guio₃ ráun₂? ");
INSERT INTO cntNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jaun₂ ca₂ŋag₃ Jesús: ―Ma₁ tsá₃ juá'₅ jniá₂ jŋia'₅₄ guio₃ ráun₂. Ta₁'nag'₂ co₂ne₂guióg₂ rë₂dsɨ́₂ guia₃ ráun₂ a₂jma₃guio₃ (70 X 7 = 490) bá₄ juá'₅ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Uɨg₅₄ jaun₂, lë́₅ guei'₅₄ i₂juɨ́g₃ juɨ₁lia'₂ lɨ́n₅ jan₂ rag₅₄ i₂ca₂mág₃ cuentas quió'₅ ca₂le₃jɨ́n₃ dsa₂ i₂jme₂ti₃ ta₁ ne₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jaun₂ jme₁ma₂jme₂lióg₃ chein'₂ cuentas, jme₁ca₂dsi₃lén₂ dsa₂ le₁jŋiai₂₃ jan₂ dsa₂ i₂rɨn₅ guia₃ mei₅ talentos. ");
INSERT INTO cntNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","La₁, ia₁ tsá₃ 'e₂ cha₂ quian'₅₄ a₂quí₃, jaun₂ ca₂jmo₃ rag₅₄ 'éi'₃ a₂dsɨ₃'nɨ₄ dsa₂ 'éi₂ lia'₂ jma₃quian'₅₄ 'io₅₄ quiáin₅, chi'₂ quiáin₅ në́₃, ca₂le₃jë́₃ 'e₂ a₂jme₁cha₂ quió'₅ në́₃, ia₁jaun₂ le₂jaun₂ jme₁dsian₅ a₂rɨin₂. ");
INSERT INTO cntNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","La₁ dsa₂ 'éi₂ në́₃, ca₂já₃ ca₂chi₃jné₃ ne₄ rag₅₄ juɨg₅₄, jaun₂ ca₂mɨ₃ tion₅₄ ca₂juá'₂: “Gui'₅₄ quiáng₃, jmo₄ juɨn'₂ 'au'₂ quian'₅₄ jniá₂, a₂quɨ́₄ bá₄ jniá₂ quiáng'₂, ca₂le₃jë́₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jaun₂ juɨg₅₄ në́₃ ca₂dsia₃ bá₄ ŋéi₂ dsɨ́₅ ja₁coin₂, jaun₂ ca₂'éin₂ bá₄ ca₂le₃jë́₃ a₂jme₁rɨin₂, jaun₂ ca₂lió₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","'La₁ dsɨ₂juɨ₅ jme₁o₂'ɨ́in₃ jaun₂ në́₃, ca₂jein'₂ jan₂ dsa₂ i₂jme₂ti₃ rɨin'₅₄ i₂rɨn₂ caun₂ 'ŋiá₂-láu₂ cu₄ denarios quió'₅. Jaun₂ ca₂tɨ́in₂ dsɨ₂lag₄ rɨin'₅₄, ca₂güɨ'₃ tiá₂, ca₂juá'₂: “¡Qui₄ a₂rɨng'₂ quió₃!” ");
INSERT INTO cntNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jaun₂ rɨin'₅₄ 'éi₂ në́₃ ca₂chi₃jné₃ ne₅₄, jaun₂ ca₂mɨ₃ tion₅₄ ca₂juá'₂: “Jmo₄ juɨn'₂ 'au'₂ quian'₅₄ jniá₂, a₂quɨ́₄ bá₄ jniá₂ quiáng'₂, ca₂le₃jë́₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","La₁ i₂jan₂ në́₃ tsá₃ ca₂gue₃, jaun₂ juɨ₅ 'né₅ 'má₃ bá₄ ca₂i₁tio'₂. Ca₂lia'₂ jaun₂ ca₂'mag'₂ dsɨ́₅ ca₂lia'₂ ca₂quí₃ rɨin'₅₄ ca₂le₃jë́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jaun₂ jme₁ca₂jág₃ rɨin'₅₄ i₂jme₂ti₃ ta₁ sián'₂, ca₂tá'₂ 'lia'₂ dsɨ́₅, jaun₂ ca₂i₁con₂ jág₁ ne₄ juɨg₅₄ ca₂i₁jua'₄ ca₂le₃jë́₃ a₂ca₂lë₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jaun₂ ca₂jmo₃ juɨg₅₄ 'éi'₃ ca₂i₁quiong₅₄ táng₃ dsa₂, jaun₂ ca₂të₃ juɨg₅₄ dsi₂néi₂ quió'₅, jaun₂ ca₂juá'₂: “'Ne₂ i₂jme₂ti₃ ta₁ ne₃, ¡'e₂ guë́₄ 'ŋio₅ 'lɨn'₅₄ 'ne₂ ca₂'uɨ́ng'₂! Jua'₂ në₂'én₃ bá₄ jniá₂ ca₂le₃jë́₃ a₂jme₁rɨng'₂ quió₃, ia₁ në₂mɨ'₅₄ tion₅₄-jan₃. ");
INSERT INTO cntNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Tsa₁ dse₃ jua'₅₄ le₂jaun₂ bá₄ në₂dsia'₅₄ ŋéi₂ 'au'₂ rɨ́ng'₂, juɨ₁lia'₂ në₂dsia₃ jniá₂ ŋéi₂ dsɨ₃ 'ŋiag'₂?” ");
INSERT INTO cntNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Të₃ ma₂'ne₂ jaun₂ juɨg₅₄, ca₂jɨ́in'₂ dsa₂ 'éi₂ o₄gú₃ dsa₂ i₂niog₅ ne₄ 'né₅ 'má₃, ca₂jmo₃ ca₂lia'₂ ca₂quí₃ jë₂ a₂jme₁rɨin₂. ");
INSERT INTO cntNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jaun₂ ca₂juá'₂ Jesús guë́₄ në́₃: ―Ján₃ bá₄ le₂në₅ jmo₃ Ŋe'₃ jniá₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃ quian'₅₄ 'nia'₂ le₂jang'₂ le₂jang'₂ në₁jua'₂ tsá₃ ca₂'én'₃ 'nia'₂ ca₂le₃jë́₃ 'au'₂ dsáu₁ rɨ́ng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jme₁ca₂dsan₃ juá'₂ Jesús jág₁ në₅, jaun₂ ca₂o₃'ɨ́in₃ 'uë₃ Galilea, jaun₂ ca₂dsióg₃ të₂le₃ quióng₄ Cuá₃ Jordán. ");
INSERT INTO cntNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Juɨn₅ lɨn₃ dsa₂ ca₂jme₃quiong'₅₄, jaun₂ ca₂jme₃'lióin₂ dsa₂ i₂qui₂le₁dso'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jaun₂ në́₃, i₂lɨn₅₄ dsa₂ fariseos ca₂jme₃quiáin₃ con₂ Jesús a₂jŋia'₅₄ con'₂ cáun₂ táu₂. Jaun₂ ca₂ŋag₃: ―¿'I₄ 'éi'₃ a₂tén₂ dsa₂ dsɨ₂i₂gu₂ ne₄ 'uɨg₅₄ në₁'e₂ caun₂ a₂lë₃? ");
INSERT INTO cntNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jaun₂ ca₂ŋag₃ Jesús: ―¿Tsa₁ ma₂ca₂'í'₂ 'nia'₂ ne₄ Si₂, ja₁juá'₂ i₂ca₂jmó'₂ dsa₂ mɨ₂güɨ́g₃ le₂ne₁: “Ca₂jmói'₂ dsa₂ ŋe'₂ dsa₂ mɨ́₂ në́₃”? ");
INSERT INTO cntNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ca₂juá'₂ në́₃: “'Uɨg₅₄ jaun₂ ca₂tɨ́n₂ dsa₂ ŋe'₂ téin₂ chog₅₄-jmei₂ jaun₂ con'₂ tiain'₃ quiain'₅₄ dsɨ₂i₂gu₂, jaun₂ jë₁le₃oin₃ léin₂ caun₂ bá₄ nɨ₁ŋɨ́₅.” ");
INSERT INTO cntNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jaun₂ dsióg₄ léin₂ jan₂ bá₄, tsá₃ ma₃lë́₂ oin₃. Jaun₂ tsá₃ 'i₄ 'éi'₃ jua'₅₄ jmo₃ dsa₂ mɨ₂güɨ́g₃ jma₃quén₅ a₂ma₂ca₂dsia₃ Diú₄ rë₂. ");
INSERT INTO cntNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jaun₂ ca₂ŋag₃ táng₃ dsa₂ fariseos: ―¿'E₂ guë'₂ lë₃ në́₃ ca₂jmo₃ Moisés 'éi'₃ a₂lé₂ le₃jmo₃ dsa₂ ŋe'₂ caun₂ si₂ të₃ron₅₄ cuë́'₃ 'io₅₄ ja₁juá'₂ a₂téin₂ rɨin'₅₄, jaun₂ guë́₄ ma₂lé₂ dsei₂₃? ");
INSERT INTO cntNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jaun₂ ca₂juá'₂ Jesús: ―'Uɨg₅₄ ia₁ a₂ŋɨ́₄ tsá₃ nág'₁ 'nia'₂ guiong'₅₄ bá₄ jaun₂ ca₂cuë₃ 'éi₂ jmɨg₄ a₂tén₂ dsa₂ dsɨ₂i₂gu₂; la₁ lia'₂ con'₂ le₂'uɨg₅₄ tsá₃ le₂në₅ jme₁lë́₄. ");
INSERT INTO cntNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","La₁ jniá₂ juá'₅, juɨ₁'ein₂ guë́₃ i₂lë₁tén₂ dsɨ₂i₂gu₂, on₃jua'₅₄ a₂cha₂ lë₃, në₁jua'₂ on₃ guë'₂ jua'₅₄ ia₁ a₂nió'₅ jág₁ quian'₅₄ i₂sián'₂; në₁jua'₂ jë₁ma₂ca₂lë₃ jaun₂, cáin₂ táng₃ 'io₅₄ sián'₂, 'no₂₃ dso₄ ne₄ Diú₄; ján₃ bá₄ le₂në₅ quian'₅₄ dsa₂ ŋe'₂ i₂jén'₂ gu₂ quian'₅₄ jan₂ 'io₅₄ i₂ma₂téi₂ dsa₂ në́₃, ján₃ bá₄ le₂jaun₂ 'no₂₃ dso₄ ne₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jaun₂ lë₃, ca₂juá'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Në₁jua'₂ le₂në₅ cha₂ o₂me'₅₄ dsɨ₅ quió'₅ dsa₂ ŋe'₂ dsa₂ mɨ́₂, ¿tsa₁ dse₃ jua'₅₄ a₂tsá₃ jéin'₂ co₂ŋei'₅₄ gu₂? ");
INSERT INTO cntNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jaun₂ ca₂juá'₂ táng₃ Jesús: ―Tsá₃ ca₂le₃jɨ́n₃ lé₂ le₃ŋɨ́'₂ dsɨ́₅ jua'₅₄ lé₂ le₃jmo₃ le₂në₅; jŋia'₅₄ lia'₂ i₂ma₂cuë₃ Diú₄ bí₂ a₂le₃ŋɨ́i'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","'Lióng₂ bá₄ 'uɨg₅₄ cha₂ a₂tsá₃ le₃jén'₂ dsa₂ ŋe'₂ i₂lɨn₅₄ gu₂; ia₁ i₂lɨn₅₄ le₂jaun₂ ma₂lɨ́in₅ lia'₂ con'₂ jme₁ca₂rë₃cháin₃ a₂tsá₃ lé₂ le₃jéin'₂ gu₂; i₂lɨn₅₄ guë'₂ në́₃, ia₁ a₂ma₂ca₂jmóg'₂ dsa₂ mɨ₂güɨ́g₃ rɨin'₅₄ té'₃; i₂lɨn₅₄ guë'₂ në́₃, ia₁ a₂co₂ŋei'₅₄ ma₂quí'₃ dsɨ́₅ a₂tsá₃ jéin'₂ gu₂ ne₄ o₄quió'₄ ja₁gon₂ Diú₄. Juɨ₁lia'₂ i₂tió'₅ jme₃ti₃ jág₁ la₂, juɨ₁jmo₁₂. ");
INSERT INTO cntNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jaun₂ ca₂o₃jŋia₃ i₂lɨn₅₄ dsa₂ ca₂o₃jŋiai₃ guein₂ quiáin₅ ne₄ Jesús ia₁jaun₂ qui₃nɨ́i'₂ gu₂, tsɨ́'₃ Diú₄ o₄quió'₄ në́₃. La₁ chi'₂ dsɨ₂guia₃-tɨ́n₂ në́₃ ca₂jéin₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","La₁ Jesús në́₃, ca₂juá'₂: ―Cuë₄ 'nia'₂ jmɨg₄ juɨ₁ja₂lén₂ chi'₂-guein₂ cong₂; tsá₃ lë₁jmo₂ 'nia'₂ le₂në₅ jua'₅₄ jnɨg'₅₄, ia₁ juɨ₁lia'₂ i₂le₂në₅ bá₄ guë'₂ i₂ca₂tɨ́n₂ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jme₁ca₂lë₃ chi₂láin'₂ le₂jan₂ le₂jan₂ guein₂ a₂jme₂gu'₅₄, ca₂ŋái'₃ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jan₂ dsó₂ chi'₂ ca₂jme₃quián₃ con₂ Jesús, jaun₂ ca₂ŋag₃: ―Të₅ dsen₃, ¿'e₂ jmo₅₄ jniá₂ ia₁jaun₂ léi₂ ja₁le₃chang₂ co₂tan₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jaun₂ ca₂juá'₂ Jesús: ―¿'E₂ lë₃ të́'₅ jniá₂ dsen₃? Jŋia'₅₄ lia'₂ jan₂ bá₄ i₂chan₂ i₂lɨ́n₅ i₂dsen₃, i₂'éi₂ lɨ́n₅ Diú₄. La₁ në₁jua'₂ 'niog'₂ 'ú'₄ ja₁le₃chang'₂ co₂tan₅₄, jme₁ti₁ 'éi'₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jaun₂ ca₂ŋag₃ táng₃ dsó₂ 'éi₂: ―¿'E₂ 'éi'₃? Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―Tsá₃ jŋɨ́g'₄ dsa₂ mɨ₂güɨ́g₃ rɨ́ng'₂; tsá₃ nióg'₄ jág₁ quian'₅₄ dsa₂ i₂tsá₃ lɨ́n₅ dsɨ₂i₂gog'₂; tsá₃ 'áng'₁ a₂cha₂ quió'₅ rɨ́ng'₂; tsá₃ jmó'₂ jua'₅₄ jang'₅₄ jág₁ të₂jág₁ a₂jmag'₅₄ rɨ́ng'₂; ");
INSERT INTO cntNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","a₂jme₁gang'₃ chog'₂-ŋéi'₅; a₂jme₁'nióg'₄ dsa₂ mɨ₂güɨ́g₃ rɨ́ng'₂ juɨ₁lia'₂ 'nióg'₃ 'ŋiag'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jaun₂ ca₂ŋag₃ táng₃ dsó₂ 'éi₂ ca₂tsɨ́'₃ Jesús: ―Ca₂le₃jë́₃ a₂në₅ ma₂guio₃ jme₂tí₂. ¿'E₂ guë́₄ a₂siá'₂ 'nió'₅ jmo₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―Në₁jua'₂ 'niog'₂ léng'₂ jan₂ dsa₂ i₂rë₂'ŋia₅ të₂le₃ quió'₅ jme₂dsí₂, guan'₂ o₂'nag₄ ca₂le₃jë́₃ a₂cha₂ quiáng'₂, jaun₂ o₂dsio'₅₄ ja₁con₂ dsa₂ te₂ŋé₂, jaun₂ le₂në₅ le₃cha₂ a₂jlá'₁ quiáng'₂ guei'₅₄ i₂juɨ́g₃; jaun₂ guë́₄ ŋe'₅₄ quian'₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","La₁ jme₁ca₂nág₂ dsó₂ jág₁ në₅, ca₂ŋái'₃ 'lia'₂ dsɨ́₅, ia₁ 'ŋio₅ lɨn₃ jme₁cha₂ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, 'e₂ guë́₄ quian₅ ta₁ quió'₅ jan₂ dsa₂ cha₂ cu₄ a₂'í₂ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Juá'₅ jniá₂, tsá₃ guë́₄ 'e₂ ta₁ quian₅ a₂lé₂ le₃ŋɨ́₃ jan₂ já'₂ camello juɨ₅ tau₂ mɨ₂cu₄, lia'₂ con'₂ guë́₄ jan₂ dsa₂ cha₂ cu₄ a₂'í₂ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jme₁ca₂nág₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ jág₁ në₅, 'ŋio₅ lɨn₃ ca₂i₃gó'₃ dsɨ́₅, jaun₂ qui₂ca₂ŋɨ́i'₃ rɨin'₅₄ con'₂ guioin₅₄: ―¿I₂'ein₂ bá₄ guë'₂ jaun₂ në́₃ i₂lé₂ le₃tɨ́n'₄? ");
INSERT INTO cntNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jaun₂ ca₂jág₃ Jesús ca₂jɨ́in₂ 'éi₂, jaun₂ ca₂juá'₂: ―Dsón'₂ bá₄ jaun₂, të₂le₃ quió'₅ dsa₂ mɨ₂güɨ́g₃ o₁lɨ́g'₂ tsá₃ lé₂ le₃lé₂. La₁ të₂le₃ quió'₅ Diú₄, ca₂le₃jë́₃ bá₄ lé₂ le₃lé₂. ");
INSERT INTO cntNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jaun₂ ca₂juá'₂ Pe₄ në́₃: ―Te₁gui'₅₄, ca₂le₃jë́₃ 'e₂ a₂jme₁cha₂ quián₂ jnia'₅₄ ma₂ca₂tén'₃ dsɨ₅ jnia'₅₄ ma₂qui₂ca₂tí₄ ia₁ a₂'én₅ jnia'₅₄ 'ne₂. ¿'E₂ a₂tag₃ jnia'₅₄ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jaun₂ ca₂ŋag₃ Jesús ca₂juá'₂: ―A₂dsɨ₂jó'₃ juá'₅ jniá₂ juɨ́g₂ 'nia'₂, jë₁ma₂ca₂të́₂ jmɨg₄ i₁le₃'mag'₂ ca₂le₃jë́₃ 'a₂ lia'₂ niog₅ lë́₅ mɨ₂güɨ́g₃, jë₁ma₂ca₂të́₂ rë₁guá₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ ne₄ta₁ jlá'₁ quió'₅, jaun₂ 'nia'₂ në́₃ i₂ma₂ja₂nóg'₅ quiong'₅₄ jniá₂, nio₃ gog'₂ 'nia'₂ jma₃cáun₃ ta₁ a₂tiáng'₄ jmó'₂ gong'₂ qui₁dsɨ́'₂ 'éi'₃ ta₁guia₃-tɨ́n₂ nió'₃ dsa₂ juɨg₂ tsɨ₁jon₂ Israel. ");
INSERT INTO cntNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ján₃ bá₄ le₂jaun₂ ján₃, ca₂le₃jɨ́n₃ i₂ma₂ca₂tén'₃ dsɨ́₅ dsi₂néi₂ quió'₅, i₂ma₂ca₂tén'₃ dsɨ́₅ chi'₂ rɨn'₅₄, o₃ chog₅₄-jmei₂, o₃ dsa₂ mɨ́₂ quiáin₅, o₃ chi'₂ quiáin₅, i₂ca₂tén'₃ dsɨ́₅ ca₂tí₂ ja₁nau₂ quió'₅ në́₃, 'uɨg₅₄ quió₃ jniá₂, ia₁ gue₃ caun₂ 'ŋiá₂-láu₂ ŋag₅₄ guë́₄ lia'₂ con'₂ guë́₄ a₂ma₂ca₂tí₂, ton'₂ gue₃ ján₃ a₂le₃chain₂ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","La₁ rë₂në́₃ juɨn₅ lɨn₃ i₂lɨ́n₅ i₂quen₅, la₁ jmɨg₄ jaun₂ léin₂ dsa₂ të₂le₃ jë₁ca₂tó'₂; le₂jaun₂ bá₄ ján₃ juɨ₁lia'₂ i₂tsá₃ 'e₂ quen₅ rë₂në́₃ lia'₂ con'₂ niog₅ lɨ́n₂ dsa₂ mɨ₂güɨ́g₃, léin₂ i₂le₂'uɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Lë́₅ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄ juɨ₁lia'₂ jan₂ dsa₂ juɨg₅₄ ja₁nau₂ i₂o₂'ɨn₅ të₃ o₃'iog₂, ca₂i₁tioin₁₂ dsa₂ i₂jmo₃ ta₁ ja₁nau₂ quió'₅ ja₁jnia₄ cho'₅₄ uɨng₂ uvas. ");
INSERT INTO cntNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ca₂lɨ́'₃ bá₄ jág₁ quian'₅₄ dsa₂ i₂jmo₃ ta₁ a₂'liain'₅₄ jma₃ca₂'éi'₃ cu₄ denario lia'₂ co₂jmɨg₄, jaun₂ ca₂chein₃ dsa₂ 'éi₂ juɨ₅ ja₁nau₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jme₁co₂lág₂ jaun₂ o₂'ɨ́in₃ táng₃ con'₂ hora ŋí₁ ŋi₃ të₂le₃ o₃'iog₂, jaun₂ ca₂jɨ́in₂ dsa₂ sián'₂ i₂tión₂ jɨn₅₄ jë₄ 'ma'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jaun₂ ca₂tsɨ́'₃ dsa₂ 'éi₂: “O₂nó'₅ 'nia'₂ ján₃ o₂jmo₄ ta₁ ja₁nau₂ quió₃, quɨ́₄ bá₄ jniá₂ 'liang'₅₄ 'nia'₂ con'₂ dsi₂ten₅₄.” Jaun₂ i₃lén₂ bá₄ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jaun₂ o₂'ɨ́in₃ táng₃ con'₂ dsi₂ŋí'₃, con'₂ siá'₂ hora ŋí₁ 'nɨ₅ të₂le₃ ca₂'láu₂ në́₃; le₂jaun₂ bá₄ ca₂jmo₃ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Con'₂ siá'₂ o₂'ɨ́in₃ bá₄ guë́₄ con'₂ hora ŋí₁ 'ŋiá₂ të₂le₃ ca₂'láu₂, ŋó₃ juɨ₅ jë₄ 'ma'₅₄, jaun₂ ca₂dsáin'₂ táng₃ dsa₂ i₂jɨn₅₄ tión₂. Jaun₂ ca₂tsɨ́'₃ 'éi₂: “¿'E₂ lë₃ tión'₂ 'nia'₂ ja₁lá₃ ta₁ne₁jmɨg₄ tsá₃ 'e₂ ta₁ jmo'₂?” ");
INSERT INTO cntNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂ ca₂juá'₂: “Ia₁ 'i₁jan₂ tsá₃ 'ein₂ tio₅.” Jaun₂ ca₂ŋag₃ dsa₂ juɨg₅₄ ja₁nau₂ ca₂juá'₂: “O₂nó'₅ 'nia'₂ ján₃, o₂jmo₄ ta₁ ja₁nau₂ quió₃; quɨ́₄ bá₄ jniá₂ 'lian'₅₄ 'nia'₂ con'₂ dsi₂ten₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","'Jme₁ca₂nei₂ jmɨg₄ jaun₂, ca₂juá'₂ juɨg₅₄ ja₁nau₂ ca₂tsɨ́'₃ dsa₂ i₂niog₅ ne₄ i₂te₂né'₂ dsa₂ ta₁: “Te'₂ dsa₂ i₂ma₂në₂jmo₃ ta₁, jaun₂ quɨ'₅₄ 'liain'₅₄. Jme₁lióg₄ de'₂ jŋiá₅ quian'₅₄ dsa₂ i₂në₂tión'₂ jë₁ca₂tó'₂, jaun₂ dsian₅ quian'₅₄ i₂në₂tión'₂ le₂'uɨg₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jaun₂ dsi₃lén₂ dsa₂ i₂ca₂tón'₂ ca₂jmo₃ ta₁ hora ŋí₁ 'ŋiá₂ të₂le₃ ca₂'láu₂, jaun₂ le₂jain₂ le₂jain₂ ca₂gue₃ 'liain'₅₄ jma₃ca₂'éi'₃ cu₄ denario. ");
INSERT INTO cntNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jme₁co₂lág₂ jaun₂, ca₂tɨ́n₂ dsa₂ i₂ca₂i₃ton'₅₄ le₂'uɨg₅₄, i₃jiog₅ dsɨ́₅ a₂jme₁gue₃ guë́₄ ŋag₅₄ 'liain'₅₄; la₁ co₂rë₂ bá₄ 'liain'₅₄ ca₂gue₃ jma₃ca₂'éi'₃ cu₄ denario le₂jain₂ le₂jain₂. ");
INSERT INTO cntNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","La₁ jme₁ma₂në₂gue₃ 'liain'₅₄, i₃léin₂ i₃chog'₄ dso₄ ne₄ juɨg₅₄, ");
INSERT INTO cntNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","jaun₂ ca₂juá'₂: “Dsa₂ i₂o₃lén₂ jë₁ca₂tó'₂, caun₂ hora bá₄ në₂tióin'₂ në₂jmo₃ ta₁; co₂jaun₂ bá₄ 'liain'₅₄ në₂gue₃ ján₃ con'₂ 'liog'₅₄ jnia'₅₄ i₂në₂tió'₄ në₂jmó₁ ta₁ ta₁ne₁jmɨg₄ në₂ŋag₅₄ 'iog₂ dséi₂ 'ŋio₅ lɨn₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","La₁ ca₂ŋag₃ juɨg₅₄ ca₂tsɨ́'₃ jan₂: “A₂mei₅₄ quiáng₃, tsá₃ 'e₂ jua'₅₄ a₂tsá₃ dsi₂ten₅₄ jmo₅ jniá₂ ja₁cong'₂. ¿Tsa₁ ca₂lë₃ jág₁ a₂'liang'₅₄ ca₂'éi'₃ cu₄ denario guë'₂? ");
INSERT INTO cntNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Juɨ₁le₂'ŋio₂ 'au'₂ con'₂ ma₂'liang'₅₄ në₅, guan'₂ quiáng'₂. Në₁jua'₂ jniá₂ le₂në₅ ca₂lë₃ dsɨ₃ quɨ́₄ 'lian'₅₄ dsa₂ i₂në₂tong₅₄ jë₁ca₂tó'₂ con'₂ 'lian'₅₄ 'ne₂, ");
INSERT INTO cntNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿o₃ tsa₁ ca₂tɨ́n₂ jniá₂ jmo₅₄ quian'₅₄ cu₄ quió₃ 'a₂ lia'₂ jŋia'₅₄ 'nio₃ jmo₅₄? ¿O₃ ja₂ uɨg₅ 'au'₂ 'e₂, ia₁ a₂'ua₁ dsɨ₃?” ");
INSERT INTO cntNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","'Jaun₂ në́₃ juɨ₁lia'₂ dsa₂ i₂lɨ́n₅ të₂le₃ jë₁ca₂tó'₂ rë₂në́₃, léin₂ i₂le₂'uɨg₅₄ jmɨg₄ jaun₂; le₂në₅ bá₄ ján₃, juɨ₁lia'₂ i₂lɨ́n₅ i₂le₂'uɨg₅₄ rë₂në́₃, léin₂ dsa₂ të₂le₃ jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jme₁ma₂'en₅₄ Jesús juɨ₅ uɨ́g₂ tso₄ a₂dsióg₄ Jerusalén, jaun₂ ca₂të́'₃ cau₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Juɨ₁lia'₂ jág'₂ 'nia'₂, tio'₅₄ jniog₄ juɨ₅ tso₄ la₂ a₂dsi₁náu₅ Jerusalén. Ja₁jaun₂ jáng'₂ dsa₂ jɨ́in'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ o₄gú₃ juɨg₅₄ jme₂dsa₂, ne₄ të₅juá'₅ në́₃; 'éi₂ guë́₄ në́₃ cuë₃ 'éi'₃ a₂jŋag'₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Jáng'₂ dsa₂ në́₃ o₄gú₃ dsɨ₂nau₂ ia₁jaun₂ jmóg'₂ burlas, qui₃bóg₂ dsa₂, jaun₂ guë́₄ tioin₃ cróg₄ jŋag'₃; la₁ a₂'nɨ₅ jmɨg₄ jaun₂, jein'₅₄ le₃chain₂ bá₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jaun₂ ca₂jme₃quián₃ chog₅₄ Jacobo quian'₅₄ Juan₅₄, ja₁ŋi'₅₄ Zebedeo, ja₁'en₅₄ Jesús. Jaun₂ ca₂chi₃jné₃ ca₂mɨ₃ a₂jmo₃ 'éi₂ dse₃ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jaun₂ ca₂ŋag₃ Jesús: ―¿'E₂ 'niog'₂ 'ne₂? Jaun₂ ca₂ŋag₃ chog₅₄ chi'₂ 'éi₂: ―¿Tsa₁ cuë́'₁ jmɨg₄ a₂tian'₃ jma₃jan₂ chi'₂ quiáng₃ cong'₂, jë₁ma₂të́₂ rë₁ne'₅₄ gong'₂ ne₄ta₁ quiáng'₂, jan₂ të₂le₃ gog'₂ ne₁, jan₂ guë'₂ të₂le₃ gog'₂ jen₅? ");
INSERT INTO cntNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","La₁ Jesús në́₃ ca₂ŋag₃: ―Tsá₃ ŋi'₅₄ 'nia'₂ 'e₂ a₂mɨ'₂. ¿Tian'₃ 'nia'₂ dsɨ₃ŋɨ́g'₂ ca₂le₃jë́₃ juɨ₁lia'₂ a₂dsɨ₃ŋɨ́₂ jniá₂ guë'₂? Jaun₂ ca₂ŋag₃ 'éi₂: ―Tián₂ bá₄ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jaun₂ ca₂juá'₂ táng₃ Jesús: ―Dsón'₂ bá₄ jaun₂ dsɨ₃ŋɨ́'₂ 'nia'₂ juɨ₁lia'₂ 'a₂ lia'₂ niog₅ dsɨ₃ŋɨ́₂ jniá₂, la₁ juɨ₁lia'₂ a₂juá'₂ 'nia'₂ në₅ a₂tiáng'₄ jma₃ca₂ton₂ cau₅ quió₃, on₃jua'₅₄ jniá₂ ca₂tɨ́ng₂ cuë₅₄ a₂jaun₂. Ja₁jaun₂ ma₂jmo₃ Ŋe'₃ jniá₂ co₂jŋia₅₄ a₂tian'₃ con'₂ i₂ca₂tɨ́n₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Rɨin'₅₄ i₂guian₃ guë́₄ 'éi₂ në́₃ ca₂rë₃'néi₃ quian'₅₄ i₂on₃ 'éi₂ jme₁ca₂nág₂ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","La₁ ca₂të₃ Jesús, jaun₂ ca₂juá'₂: ―Ŋi'₅₄ bá₄ 'nia'₂, juɨ₁lia'₂ dsɨ₂tan₅₄ dsa₂ can'₅₄ i₂tián'₅ gon₂ ca₂le₃jë́₃ juɨg₂, qui₂toin'₂ dsa₂ 'éi'₃ bén₂. Le₂jaun₂ bá₄ jmo₅ juɨ₁lia'₂ dsɨ₂tan₅₄ i₂sion₅ guë́₄, tiáin'₅ goin₂ jmo₂₃ 'éi'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","La₁ jɨn'₄ 'nia'₂, tsá₃ le₂jaun₂ lé₂. Chi₂jua'₂ 'ein₂ 'nio₃ jmo₃ juɨn'₂, ca₂tɨ́in₂ jme₃ti₃ ta₁ ne₄ rɨin'₅₄; ");
INSERT INTO cntNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","chi₂jua'₂ 'ein₂ 'nia'₂ 'nio₃ cán₂ ne₄ juɨ₅, 'nió'₅ jme₃ti₃ ne₄ ca₂le₃jɨ́n₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ia₁ le₂në₅ bá₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃, tsá₃ ta₁ jaun₂ já₅ jua'₅₄ a₂jme₃ti₃ dsa₂ ne₅₄; a₂jme₃ti₃ ta₁ ne₄ dsa₂ bá₄ já₅, a₂quí₃ quian'₅₄ 'mú₃ co₂'nió'₄ 'lia'₅₄ ia₁jaun₂ tɨ́n'₄ juɨn₅. ");
INSERT INTO cntNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jme₁ma₂tioin'₅₄ juɨ₅ 'uɨin₂ juɨg₂ Jericó, juɨn₅ dsa₂ ja₁jaun₂ ca₂jme₃quiain'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Juɨ₅ ja₁ŋó₄ jaun₂, jme₁tián'₄ on₃ dsa₂ ten₄ cau₅ juɨ₅. Dsa₂ 'éi₂ në́₃ jme₁ca₂nág₂ a₂ŋó₅ Jesús cau₅ jaun₂, ca₂juá'₂ tiá₂: ―¡Te₁gui'₅₄, tsɨ₁jon₂ David, dsia₄ ŋéi₂ 'au'₂ jnia'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jaun₂ ca₂jí₂ bá₄ dsa₂ ia₁jaun₂ dsɨ₃léin₂ tei₄. La₁ të₂le₃ i₂juɨ'₂ guë́₄ co₂mɨ'₅₄ ca₂tóin'₂ bá₄, ca₂juá'₂: ―¡Te₁gui'₅₄, tsɨ₁jon₂ David, dsia₄ ŋéi₂ 'au'₂ jnia'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jme₁ca₂nág₂ Jesús, jaun₂ ca₂nau₂, jaun₂ ca₂të́'₃ le₃on₃ dsa₂ 'éi₂, jaun₂ ca₂ŋag₃: ―¿'E₂ 'niog'₂ 'nia'₂ jmo₅₄ jniá₂ o₄quián'₂ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂: ―Te₁gui'₅₄, a₂jnia₅₄ mɨ₂ne₄ bá₄ jnia'₅₄ 'niog₂. ");
INSERT INTO cntNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jaun₂ ca₂dsia₃ bá₄ Jesús ŋéi₂ dsɨ́₅, jaun₂ ca₂tí₂ gu₂ jme₁ne₁ dsa₂ 'éi₂. Jaun₂ dsɨ₂juɨ₅ le₂jaun₂ ca₂jnia₃ jme₁ne₁ dsa₂, jaun₂ i₃léin₂ bá₄ jaun₂ ca₂jme₃quiain'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jme₁ma₂quián₅ dsi₁léin₂ Jerusalén, dsi₃léin₂ quián₅ juɨg₂ Betfagé a₂niog₅ cau₅ Má'₂ Olivos, ja₁jaun₂ ca₂chen₃ Jesús on₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, ");
INSERT INTO cntNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ca₂juá'₂: ―O₂nó'₅ 'nia'₂ juɨg₂ pí'₁ niog₅ të₂le₃ ne₄ juɨ₅ ja₁dsau₅₄ në₅. Ja₁jaun₂ dsian'₂ 'nia'₂ jan₂ i₂bú'₄ mɨ́₂ rë₂'ŋe'₅₄, chéin'₅ quian'₅₄ guein₂ quiáin₅. O₂chein'₅₄ 'nia'₂ jaun₂ të'₅₄ ja₁lá₃. ");
INSERT INTO cntNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Në₁jua'₂ 'ein₂ ŋag₅ 'e₂ lë₃ tsɨin'₅₄, jaun₂ juɨg'₅₄ 'nia'₂: “Te₁gui'₅₄ bá₄ 'nio₃ ca₂tiá₂.” Jaun₂ në₃ cón'₅ bá₄ cuag₃. ");
INSERT INTO cntNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ca₂lë₃ le₂në₅ ia₁jaun₂ le₃ti₃ jág₁ a₂ca₂tó'₂ ne₄ si₂ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂, jme₁ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Chei'₅₄ dsa₂ juɨg₂ i₂tián'₅ Sión: “Jag₄, në₅ jón'₅ Rag₅₄ quián'₂ 'nia'₂ ja₁cong'₂, a₂lɨ́in₅ jan₂ dsa₂ me'₂, tsá₃ jláin'₁, jóin'₅ co₂dsɨin₅₄ jan₂ bú'₄, jóin'₅ quian'₅₄ jaun₅ já'₂ i₂cán₂ lio₅₄ bá₄”. ");
INSERT INTO cntNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jaun₂ ca₂i₃lén₂ bá₄ i₂on₃ 'éi₂, ca₂jmo₃ bá₄ con'₂ lë́₅ jág₁ a₂ca₂cuë₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jaun₂ ca₂i₁te₂ bú'₄ lia'₂ jma₃quian'₅₄ guein₂ quiáin₅, ca₂i₁jiog₃ ja₁'en₅₄ Jesús. Jaun₂ ca₂jlág₂ nɨ₁tsɨn'₅₄ mɨ₂ca'₄ já'₂, jaun₂ guë́₄ ca₂co₃dsag₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jaun₂ dsa₂ juɨn₅ i₂quiain'₅₄ në́₃ i₂jŋiá₅ le₃ne₄ juɨ₅ qui₂ca₂néi'₃ 'mɨ'₂ le₂'i₄ juɨ₅ ja₁ŋɨ́₃ Jesús; i₂lɨn₅₄ guë'₂ qui₂ca₂'nia₃ mog'₅₄ 'ma₂tsɨ́n₅, qui₂ca₂jó₃ dsi₂juɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dsa₂ i₂i₃lén₂ le₃ne₄ juɨ₅, quian'₅₄ i₂ja₂lén₂ le₃chi₁co'₅₄ në́₃, qui₂ca₂tóin'₂ co₂mɨ'₅₄ ca₂juá'₂: ¡Juɨ₁le₂juɨn'₂ bá₄ tsɨ₁jon₂ David! ¡Juɨ₁le₂jŋió₃ bá₄ i₂në₅ i₂já₅ o₄quió'₄ Te₁gui'₅₄! ¡Juɨ₁le₂juɨn'₂ bá₄ i₂guá₅ guei'₅₄ i₂juɨ́g₃! ");
INSERT INTO cntNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jme₁ca₂'í₃ Jesús jë₄ juɨg₂ Jerusalén, jaun₂ qui₂ca₂tón'₂ go₂'i₃ dsa₂ juɨg₂, juɨn₅ i₂qui₂ca₂ŋag₃: ―¿'Ein₂ bá₄ në₅? ");
INSERT INTO cntNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jaun₂ qui₂ca₂ŋag₃ dsa₂ juɨn₅ i₂quian'₅₄ Jesús, ca₂juá'₂: ―Jesús bá₄ la₂, dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄, i₂chan₂ juɨg₂ Nazaret ja₁tén₄ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ca₂dsióg₃ Jesús jme₁ca₂dsióg₃ i₁dsi₅ guá'₅ templo, jaun₂ qui₂ca₂'uɨ́in'₂ ca₂le₃jɨ́n₃ dsa₂ i₂jme₁ma₂tion'₅₄ dsia₅ 'ma'₅₄ i₁dsi₅ guá'₅, dsa₂ i₂'nag₅, i₂qui₂lá₅ në́₃, qui₂ca₂jéin'₃ nɨ₁mesa ja₁jme₁jmó'₂ dsa₂ ta₁ jme₂tsɨ́in₃ cu₄, qui₂ca₂quɨ́'₂ 'ma₂sɨ₅₄ ja₁jme₁tián'₄ dsa₂ i₂'nɨ₅ i₁ju₂; ");
INSERT INTO cntNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","jaun₂ ca₂juá'₂: ―Ne₄ Si₂ juá'₂: “'Né₅ quió₃ lë́₅ ca₂ne₅₄ 'né₅ ja₁të₁ja₂lén₂ dsa₂ ja₂chi'₅₄ Diú₄”; la₁ 'nia'₂ në́₃ ma₂jmo'₅₄ në₂jag₄ bá₄ të₂'lau₂ quió'₅ dsa₂ 'ang₂. ");
INSERT INTO cntNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jaun₂ ca₂jme₃quián₃ i₂lɨn₅₄ dsa₂ ten₄ quian'₅₄ dsa₂ guian'₅₄ në́₃ con₂ Jesús i₁dsi₅ guá'₅, jaun₂ ca₂jme₃'lióin₂ bá₄ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","La₁ jme₁ca₂jág₃ juɨg₅₄ jme₂dsa₂ quian'₅₄ të₅juá'₅ léi₄ jlá'₁ a₂ca₂jmo₃ Jesús jaun₂, ton'₂ ia₁ ca₂nág₂ në́₃ tion'₅₄ chi'₂ co₂mɨ'₅₄ qui₂guió'₅ i₁dsi₅ guá'₅, a₂juá'₂: “¡Juɨ₁le₂juɨn'₂ tsɨ₁jon₂ David!”, jaun₂ ca₂rë₃'néi₃. ");
INSERT INTO cntNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ Jesús: ―¿Tsa₁ nag'₂ 'e₂ juá'₂ chi'₂? Jaun₂ ca₂ŋag₃ Jesús: ―Ján₅, nag₅ bá₄ jniá₂. Ia₁, ¿tsa₁ ma₂'í'₂ 'nia'₂ ne₄ Si₂ ja₁juá'₂: Te₁gui'₅₄, 'ne₂ bá₄ ma₂ca₂jmo'₅₄ 'e₂ a₂'uë₂ mɨ₂'o₄ chi'₂ bë'₅₄ quian'₅₄ mɨ₂'o₄ guein₂ tei₄ i₂guén'₅ dsi'₅₄, 'uë₂ jág₁ a₂jme₂juɨin'₂ 'ne₂? ");
INSERT INTO cntNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jaun₂ ca₂o₃'ɨ́in₃ bá₄ ja₁tion'₅₄ 'éi₂, jaun₂ ca₂ŋái'₃ táng₃ juɨg₂ Betania. Ja₁jaun₂ ca₂jŋia₂ caun₂ nei₅. ");
INSERT INTO cntNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jme₁jnia₃ jaun₂, jme₁ma₂tioin'₅₄ juɨ₅ a₂i₂lein₃ táng₃ juɨ₅ jë₄ juɨg₂ Jerusalén. Jesús në́₃ ca₂tá'₂ i₁cón'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jaun₂ ca₂jág₃ caun₂ nɨ₁'ma₂ higuera a₂dsi₅₄ cau₅ juɨ₅, jaun₂ ca₂jme₃quiáin₃ 'uɨg₅₄, la₁ tsá₃ 'e₂ mɨ́g₂ ca₂dsó'₂ guë'₂ guei'₅₄ nɨ₁'ma₂; jŋia'₅₄ lia'₂ jmá'₃ mog'₅₄ bá₄ cha₂. Jaun₂ në́₃ ca₂juá'₂ Jesús ca₂tsɨ́'₃ nɨ₁'ma₂: ―¡Lia'₂ o₁lɨ́g'₂ jmɨg₄, tsá₃ ma₃juɨ₁'ag₅₄ mɨ́g₂ quiáng'₂! Dsɨ₂juɨ₅ jaun₂ bá₄ ca₂rë₃quéin₃ nɨ₁'ma₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jme₁ca₂të́₂ ne₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ a₂ca₂lë₃ jaun₂, ca₂i₃gó'₃ dsɨ́₅, jaun₂ ca₂ŋɨ́i'₃ Jesús: ―¿'A₂ bá₄ lia'₂ con'₂ tan₅₄ lia'₂ dsɨ₂juɨ₅ ca₂rë₃quéin₃ nɨ₁'ma₂ në₅? ");
INSERT INTO cntNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jaun₂ ca₂ŋag₃ Jesús: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, në₁jua'₂ tsá₃ ca₂'éi'₂ 'nia'₂ caun₂-tɨn₃ 'au'₂ lia'₂ 'éng'₂, on₃jua'₅₄ jmá'₃ juɨ₁lia'₂ a₂në₂jmo₃ jniá₂ quian'₅₄ nɨ₁'ma₂ higuera në₅, lé₂ le₃jmó'₂ 'nia'₂, ia₁ lé₂ le₃jua'₅₄ 'nia'₂ ján₃ juɨg'₅₄ nɨ₁má'₂ ó₃: “Jŋiag'₃ ja₁në₅, o₃ o₂'ú₅ jmɨ₁ŋí'₄”, le₂jaun₂ dsón'₂ lé₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Le₂jaun₂ bá₄ ján₃ ca₂le₃jë́₃ 'e₂ a₂mɨ'₂ 'nia'₂ jme₁mɨ'₂ ne₄ Diú₄, në₁jua'₂ 'én'₂ të₃dsón'₂ 'nia'₂, guéi'₁ bá₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jaun₂ ca₂'í₃ táng₃ Jesús i₁dsi₅ guá'₅ templo, jaun₂ të₁lia'₂ 'ein₅₄ jme₂tɨin₂₃ dsa₂, jaun₂ ca₂jme₃quián₃ juɨg₅₄ jme₂dsa₂ quian'₅₄ i₂lɨ́n₅ dsa₂ can'₅₄ quián₅ dsa₂ juɨg₂, con₂ Jesús, jaun₂ ca₂ŋag₃: ―¿'E₂ ta₁ lɨ́n'₅ 'ne₂, 'e₂ lë₃ jmo'₂ ca₂le₃jë́₃ 'e₂ a₂jmo'₂ ŋɨ'₂? ¿'Ein₂ ca₂cuë₃ bí₂ 'éi'₃ në₅? ");
INSERT INTO cntNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jaun₂ ca₂ŋag₃ Jesús: ―Ján₃ bá₄ ŋag₄ jniá₂ caun₂ 'nia'₂: në₁jua'₂ ca₂ŋag'₅₄ 'nia'₂ lia'₂ tí₅, jaun₂ guë́₄ juá'₄ jniá₂ 'ein₂ cuë₅ bí₂ 'éi'₃ a₂jmo₂₃ ca₂le₃jë́₃ a₂jmo₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juɨ₁lia'₂ a₂ca₂chon₃ Juan₅₄ jmɨg₂ dsa₂, ¿'ein₂ quió'₅ 'éi'₃ jaun₂? ¿Quió'₅ Diú₄, o₃ quió'₅ dsa₂ mɨ₂güɨ́g₃ 'e₂? Jaun₂ ca₂dsia₃ dsa₂ can'₅₄ jág₁ con'₂ guioin₅₄, ca₂juá'₂: ―Në₁jua'₂ ca₂chei₅₄ jniog₄ 'éi'₃ quió'₅ Diú₄ bá₄ jaun₂, në₃ cón'₅ bá₄ ŋag₃: “¿'E₂ lë₃ tsá₃ ca₂rë₃'én'₂ 'nia'₂ jág₁ quió'₅ 'éi₂?” ");
INSERT INTO cntNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","La₁ në₁jua'₂ ca₂ŋag₄ guë'₂ jniog₄ 'éi'₃ quió'₅ dsa₂ mɨ₂güɨ́g₃ në́₃, le₃'ne₂ dsa₂ juɨg₂ quian'₅₄ jniog₄, ia₁ ca₂le₃jɨ́n₃ bá₄ dsa₂ jmo₂₃ dsɨ́₅ a₂jme₁lɨ́n₄ Juan₅₄ jan₂ dsa₂ i₂ca₂'ë́₂ jág₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jaun₂ në́₃, ca₂ŋag₃ dsa₂ can'₅₄ 'éi₂ ca₂tsɨ́'₃ Jesús: ―Tsá₃ a₂jaun₂ ne₄ jnia'₅₄ 'ein₂ ca₂chen₃ 'éi₂. Jaun₂ në́₃, ca₂ŋag₃ Jesús: ―Ján₃ bá₄ le₂në₅ tsá₃ juá'₄ jniá₂ 'ein₂ cuë₅ bí₂ a₂jmo₂₃ ca₂le₃jë́₃ a₂jmo₂₃ ŋɨ₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂ 'éi₂: ―¿'A₂ lia'₂ lɨ́n'₂ 'nia'₂ juɨ₁lia'₂ jág₁ la₂? Jan₂ dsa₂ jme₁chan₂ on₃ ja₁ŋi'₅₄. Jaun₂ ca₂tsɨ́'₃ chi'₂ quiáin₅ i₂lɨ́n₅ i₂juɨn'₂ guë́₄: “Jón₃, gua₂ o₂jmo₄ ta₁ ja₁nau₂ quián₂ jmɨg₄ në₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jaun₂ ca₂ŋag₃ chi'₂ quiáin₅: “¡Tsá₃ nei₅₄!” La₁ jme₁co₂lág₂ jaun₂ ca₂jme₃tsɨ́in₃ 'a₂ lia'₂ dsɨ₂jiog₅ dsɨ́₅, jaun₂ ŋó₃ bá₄ i₁jmo₅₄ ta₁. ");
INSERT INTO cntNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jaun₂ ca₂ŋe₄ táng₃ jmei₂ i₁chi'₄ chi'₂ jan₂ quiáin₅. Ján₃ bá₄ le₂jaun₂ ca₂tsɨ́'₃ 'éi₂. I₂'éi₂ në́₃ ca₂ŋag₃: “Nei₅₄ bá₄ jniá₂, tia₅₄, i₁jmo₃ ta₁.” La₁ tsá₃ ŋei₅₄ guë'₂ jaun₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jë₄ le₃oin₃ le₂jaun₂, ¿'ein₂ ca₂jmo₃ a₂'ŋio₂ dsɨ́₅ jmei₂? Jaun₂ ca₂ŋag₃: ―Chi'₂ i₂le₂'uɨg₅₄ bá₄. Jaun₂ ca₂juá'₂ Jesús: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, dsa₂ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄, o₃ juɨ₁lia'₂ 'io₅₄ i₂'nag₅ quió'₅ në́₃, i₂le₂'éi₂ bá₄ tiá₂ le₂'uɨg₅₄ dsɨ₃ton'₅₄ ja₁gon₂ Diú₄ lia'₂ con'₂ guë́₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ia₁ lia'₂ con'₂ jme₁guan₃ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂, ca₂jme₃jniai₂₃ ja₁con'₂ 'nia'₂ 'a₂ lia'₂ dsón'₂ ca₂tɨ́ng'₂ 'nia'₂ tiáng'₄. La₁ tsá₃ a₂jaun₂ ca₂rë₃'én'₂ 'nia'₂. Ia₁ a₂dsau₅ bá₄ juɨ₁lia'₂ dsa₂ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄, quian'₅₄ 'io₅₄ i₂'nag₅ quió'₅ në́₃, ca₂rë₃'éin₂ jág₁ quió'₅ Juan₅₄. La₁ a₂dsau₅ bá₄ o₁jŋia'₅₄ a₂ca₂të́₂ ne'₅₄ 'nia'₂ jaun₂, tsá₃ ca₂tá'₂ jén₂ 'au'₂ 'nia'₂, on₃ guë'₂ ca₂rë₃'éng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Nei₂ 'nia'₂ jág₁ a₂jáng'₅ léi₄ siá'₂ la₂: Jan₂ dsa₂ ca₂chéin'₃ cho'₅₄ uɨng₂ uvas ja₁nau₂ quió'₅. Jaun₂ ca₂jmo₃ jnɨ́₁ le₃lág'₃; ca₂jmo₃ co₂jŋia₅₄ ja₁jlein'₃ mɨ́g₂ në́₃; caun₂ guë'₂ tsɨ₁'né₅ ŋei₅ ca₂chi'₃ ja₁guá₃ jmo₃ 'í₁. Jaun₂ ca₂lɨ́'₃ jág₁ quian'₅₄ dsa₂ sián'₂ i₂nio₃ ne₄ ja₁nau₂, jaun₂ ca₂ŋó₃ bá₄ 'ŋiog₅ i₁ŋɨ₂ juɨg₂ siá'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jme₁ca₂të́₂ jein₂ a₂ca₂rau₂ mɨ́g₂, jaun₂ dsa₂ juɨg₅₄ ja₁nau₂ ca₂chein₃ co₂nió'₃ dsa₂ mozo quiáin₅, a₂jme₁i₂mɨ́₃ a₂jáng'₃ dsa₂ i₂niog₅ gu₂ ja₁nau₂ ca₂dsio₄ mɨ́g₂ con'₂ a₂ca₂tɨ́n₂ juɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","La₁ dsa₂ i₂tion'₅₄ jmó'₂ ta₁ ja₁nau₂ në́₃, ca₂jŋai'₃ bá₄ dsa₂ mozo i₂chen₄ quián₅ juɨg₅₄. Ca₂cuë́'₃ bá₄ jan₂ tioin'₅₄; jan₂ guë'₂ ca₂jŋɨi'₃; jan₂ guë'₂ ca₂cuë́'₃ quian'₅₄ nɨ₁cang₁. ");
INSERT INTO cntNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","La₁ juɨg₅₄ ja₁nau₂ në́₃, juɨn₅ guë́₄ i₂ca₂chein₃ cang₂ jaun₂ con'₂ guë́₄ le₂'uɨg₅₄; la₁ dsa₂ 'lɨn'₅₄ i₂tion'₅₄ jmo₅ ta₁ ja₁nau₂ në́₃, le₂jaun₂ bá₄ qui₂ca₂jmái'₂ ca₂le₃jɨ́n₃ dsa₂ mozo i₂chen₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’La₁ jë₁ca₂tó'₂ në́₃, dsa₂ juɨg₅₄ ja₁nau₂ ca₂chein₃ ja₁ŋi'₅₄, ia₁ lɨ́in₂: “Jme₃go₃ dsa₂ jme₃gain₃ chi'₂ quiáng₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","La₁ jme₁ca₂jág₃ dsa₂ i₂jmo₅ ta₁ ja₁nau₂ ca₂jɨ́in₂ ja₁ŋi'₅₄ dsa₂ juɨg₅₄ ca₂dsióg₃, jaun₂ ca₂dsia₃ jág₁ tioin'₅₄: “I₂në₅ bá₄ tɨn₃ ja₁nau₂ la₂ cang₂; në₃ o₁jŋɨ́i'₄ jniog₄ ia₁jaun₂ jniog₄ bá₄ lé₂ quián₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Le₂jaun₂ bá₄ ca₂jmo₃. Ca₂jŋai'₃ bá₄ 'éi₂ tioin'₅₄, jaun₂ ca₂dsei₂₃ le₃co'₅₄ jnɨ́₁; ja₁jaun₂ ca₂jŋag'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Jaun₂ në́₃, jë₁ma₂të́₂ jmɨg₄ rë₁jŋió'₂ dsa₂ juɨg₅₄ ja₁nau₂, ¿'e₂ lɨ́n'₂ 'nia'₂ jmo₃ quian'₅₄ dsa₂ i₂jmó'₂ ta₁ ja₁nau₂ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂: ―A₂jme₃dsiain₂₃ dsa₂ 'lɨn'₅₄ 'éi₂ ca₂lia'₂ tsá₃ ŋéi₂ dsɨ́₅, jaun₂ cuë́'₃ dsa₂ sián'₂ ja₁nau₂ con'₂ i₂léi₄ jáng'₃ ca₂dsio₄ con'₂ ca₂tɨ́in₂ jë₁ma₂të́₂ jein₂ a₂ráu₃. ");
INSERT INTO cntNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jaun₂ në́₃, ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂: ―¿Tsa₁ ma₂'í'₂ 'nia'₂ ne₄ Si₂ ja₁juá'₂: Nɨ₁cang₁ a₂tsá₃ ca₂rë₃ji'₅₄ të₅'ia'₂, ca₂dsióg₃ ca₂lë₃ nɨ₁cang₁ a₂dsen₅₄ guë́₄ të₁ron₅₄ qui'₅₄ 'ia'₂; a₂ca₂jmo₃ Te₁gui'₅₄ bá₄ jaun₂, jaun₂ 'ŋio₅ lɨn₃ bá₄ jlá'₁, lág₂ jniog₄? ");
INSERT INTO cntNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’'Uɨg₅₄ jaun₂ juɨ́g₂ jniá₂ 'nia'₂, co₂dsia₅ jŋiá'₂ Diú₄ o₄gog'₂ 'nia'₂ 'éi'₃ quió'₅, o₄gú₃ i₂sián'₂ bá₄ dsia₃ con'₂ i₂léi₄ jáng'₃ a₂ráu₃. ");
INSERT INTO cntNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","La₁ juɨ₁lia'₂ nɨ₁cang₁ la₂ në́₃, juɨ₁'ein₂ guë́₃ i₂ca₂tán'₂ ne₄, lé₂ le₁juɨg₁ le₁dsog'₅₄ quió'₅; o₃ në₁jua'₂ ca₂jlɨ́in₃, lé₂ ti₁'liog₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jme₁ca₂nág₂ juɨg₅₄ jme₂dsa₂ quian'₅₄ dsa₂ fariseos jág₁ a₂jáng'₅ léi₄ në₅, ca₂rë₃lí'₄ bá₄ guioin₅₄ a₂'ɨn₅ 'éi₂ bá₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jaun₂ jme₁'nio₃ jme₁tsáun'₂, la₁ ca₂rë₃gain₃ bá₄ dsa₂ juɨn₅ i₂quian'₅₄ Jesús, ia₁ ca₂le₃jɨ́n₃ bá₄ dsa₂ jmo₂₃ dsɨ́₅ a₂lɨ́n₅ 'éi₂ jan₂ i₂'ë́₂ jág₁ quián₅ Diú₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ca₂jme₃lióg₃ táng₃ Jesús ca₂tsɨ́'₃ dsa₂ të₂le₃ quian'₅₄ jág₁ a₂jáng'₅ léi₄, le₂la₂: ");
INSERT INTO cntNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Lë́₅ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄ juɨ₁lia'₂ jan₂ rag₅₄ i₂ca₂jmo₃ co₂jŋia₅₄ caun₂ má₃ a₂ca₂jmo₃ jmɨg₄ ja₁jen'₂ gu₂ chi'₂ ja₁ŋi'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jaun₂ ca₂chein₃ dsa₂ i₂jme₂ti₃ ta₁ ne₅₄ a₂dsɨ₃quiáin₂ dsa₂ i₂ma₂lë́₅ jág₁ ja₃lén₂ ja₃guë́'₃. La₁ dsa₂ 'éi₂ në́₃ tsá₃ ma₃ca₂gue₃ ja₃léin₂. ");
INSERT INTO cntNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jaun₂ ca₂chein₃ táng₃ i₂sián'₂, jaun₂ ca₂tsɨ́'₃ 'éi₂: “Chei'₅₄ 'nia'₂ dsa₂ i₂ma₂lë́₅ jág₁ ja₃lén₂ jmɨg₄, ma₂lë́₅ bá₄ co₂jŋia₅₄ má₃. Ca₂jme₁dsiang₂₃ bá₄ ca₁juɨ₅ 'on'₅₄ quiáng₃; ma₂lë₅ bá₄ co₂jŋia₅₄ ca₂le₃jë́₃. Jaun₂ juɨ₁ja₂léin₂ bá₄ jmɨg₄ quió'₅ chi'₂ quiáng₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","La₁ tsá₃ juɨ₅ ca₂tón'₃ dsa₂ i₂jme₁ma₂lë́₅ jág₁ rë₂té₄ 'éi₂. Juɨ₅ siá'₂ bá₄ i₃léin₂: jan₂ ŋó₃ juɨ₅ ja₁nau₂ quió'₅ bá₄; jan₂ guë'₂ ŋó₃ i₃dsiá₃ 'ma'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Rɨn'₅₄ dsa₂ 'éi₂ në́₃, ca₂jŋai'₃ bá₄ dsa₂ i₂jme₂ti₃ ta₁ ne₄ rag₅₄ 'éi₂, ca₂cuë₃, ca₂jme₃dsiog₂₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jaun₂ në́₃, ca₂rë₃'né₃ rag₅₄ 'ŋio₅ lɨn₃, jaun₂ ca₂chein₃ 'lióg₂ quiáin₅ ca₂i₁jme₁dsiain₂₃ dsa₂ 'éi₂ qui₂ca₂i₁dsɨ́'₄ 'lióg₂ 'né₅, co₂dsia₅ ca₂'éin₂ go₄ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jaun₂ ca₂juá'₂ rag₅₄ ca₂tsɨ́'₃ dsa₂ i₂jme₂ti₃ ne₅₄: “Ca₂le₃jë́₃ ma₂lë́₅ co₂jŋia₅₄ a₂jen'₂ gu₂ chi'₂ quiáng₃ a₂nio₃ jmɨg₄, la₁ dsa₂ i₂jme₁lë́₄ jág₁ rë₂té₄ 'éi₂, tsá₃ ma₃ca₂tɨ́in₂ ja₃léin₂. ");
INSERT INTO cntNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","O₂nó'₅ 'nia'₂ në́₃, o₂nau₂ jë₄ calle juë'₂ ja₁i₂nio₄ guë́₄ dsa₂ juɨn₅, o₂chei'₅₄ ca₂le₃jɨ́n₃ dsa₂ i₂jeng'₂ juɨ₁ja₂léin₂ jmɨg₄ jë₁jen'₂ gu₂ chi'₂ quiáng₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jaun₂ ca₂'uɨn₂ bá₄ dsa₂ 'éi₂ në́₃ ca₂i₁lein₅₄ jë₄ calle, jaun₂ chi₂ca₂liain'₃ ca₂le₃jɨ́n₃ dsa₂ i₂ca₂jein'₂ lia'₂ dsa₂ dsen₃ lia'₂ dsa₂ 'lɨn'₅₄ në́₃; jaun₂ ca₂can'₂ bá₄ dsi₂néi₂ ca₂lë₃, quian'₅₄ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Jaun₂ guë́₄ ca₂'í₃ rag₅₄ dsi₂néi₂ ca₂i₁jɨin₁₂ dsa₂ i₂tion'₅₄ 'éi₂, jaun₂ ca₂jɨ́in₂ jan₂ i₂'en₅₄ jë₄ jaun₂, tsá₃ jme₁rë₂lɨin₅₄ jua'₅₄ a₂qui'₂ 'mɨ'₂ a₂quɨ́'₅ dsa₂ dsɨ₂léin₂ ja₁niog₅ jmɨg₄ jen'₂ gu₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jaun₂ ca₂tsɨ́'₃ dsa₂ 'éi₂, ca₂juá'₂: “A₂mei₅₄, ¿'a₂ bá₄ lia'₂ në₂'ú'₃ 'ne₂ ja₁lá₃ të₃ tsá₃ rë₂lɨng'₅₄ con'₂ dsi₂ten₅₄ a₂gog'₅₄ ja₁niog₅ jmɨg₄ jen'₂ gu₂ dsa₂?” Jaun₂ tei₄ bá₄ ca₂nau₂ dsa₂ 'éi₂, tsá₃ 'e₂ ŋi₅ ŋag₃. ");
INSERT INTO cntNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jaun₂ bá₄ ca₂juá'₂ rag₅₄ ca₂tsɨ́'₃ dsa₂ i₂tion'₅₄ jme₂ti₃ ne₄ mesa: “Quéin₂ 'nia'₂ gu₂-tag₄ i₂në₅, dsein₅₄ ca₁'né₄, qui₂dsɨin₅ 'nia'₂ güɨg₂, 'liain'₅₄ jë₄ qui₁né'₃ ja₁quɨ'₂-'o₃, qui₃quɨ́g'₃ jan₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ia₁ juɨn₅ lɨn₃ dsa₂ i₂rë₂té₄, la₁ me'₂ bá₄ i₂rë₂quion'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jme₁co₂lág₂ jaun₂ ca₂i₃len₃ dsa₂ fariseos ca₂i₁jmo₅₄ jág₁ 'a₂ lia'₂ join₅₄ Jesús juɨ₁lia'₂ bá₄ 'ŋiái₃ ca₂jon₄ jág₁ 'lia'₂, ia₁jaun₂ cuɨn₃ jmɨg₄ a₂bóg'₂ dso₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jaun₂ ca₂chein₃ táng₃ i₂lɨn₅₄ dsa₂ quiáin₅ quian'₅₄ i₂lɨn₅₄ dsa₂ i₂quian'₅₄ Herodes, a₂ca₂i₁chi'₄ Jesús: ―Të₅, ne₄ bá₄ jnia'₅₄, a₂dsón'₂ bá₄ juá'₂ 'ne₂ lia'₂ tí₅ jág₁, qui₂jme₂tɨ́ng'₁ dsa₂ juɨ₅ dse₃ quió'₅ Diú₄, jaun₂ tsá₃ can'₂ 'ne₂ jág₁ jua'₅₄ a₂quian'₅₄ o₂i₁ dsɨ₅ 'e₂ a₂'ag₅ dsa₂, ia₁ tsá₃ gang'₃ jmag'₅₄ juɨ₁lia'₂ dsa₂ dsen₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jaun₂ 'niog₂ jnia'₅₄ jua'₅₄ 'ne₂ 'a₂ lia'₂ dsɨ₂jiog₅ 'au'₂: ¿Dsióg₅ guë'₂ jua'₅₄ a₂caun₂ qui₅₄ 'lia'₅₄ a₂ca₂tɨ́n₂ dsɨ₂tan₅₄ César? ¿'Nió'₅ qui₅₄, o₃ tsá₃ qui₅₄ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","La₁ ca₂rë₃lí'₄ bá₄ Jesús a₂dsɨ₂jiog₅ dsɨ́₅ dsa₂ 'éi₂ 'lɨg'₅₄, jaun₂ ca₂juá'₂: ―¡'Nia'₂ dsa₂ i₂lë₁co₂jmo₅ o₁ne₁! ¿'E₂ lë₃ 'niog'₂ 'nia'₂ jo'₅₄ jniá₂ juɨ₁lia'₂ tsán'₂ dsa₂ jan₂ já'₂ quian'₅₄ liá₂? ");
INSERT INTO cntNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","'Ë₄ de'₂ 'nia'₂ caun₂ cu₄ 'ua'₂ juɨ₁lia'₂ a₂quí₅ dsa₂ 'lia'₅₄ a₂ca₂tɨ́n₂ dsɨ₂tan₅₄. Jaun₂ ca₂o₃can₅ dsa₂ caun₂ cu₄ denario. ");
INSERT INTO cntNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jme₁ma₂në₂jág₃ Jesús, jaun₂ ca₂ŋɨ́i'₃ dsa₂ 'éi₂: ―¿'Ein₂ dsɨ₂ne₄ chi₁ton₅ ja₁lá₃? ¿'Ein₂ guë'₂ quió'₅ letra në́₃? ");
INSERT INTO cntNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jaun₂ ca₂ŋag₃: ―Quió'₅ gui'₅₄ emperador César. Jaun₂ ca₂juá'₂ táng₃ Jesús: ―Jang'₅₄ guë'₂ 'nia'₂ jaun₂ ne₄ César con'₂ a₂ca₂tɨ́n₂ César; ne₄ Diú₄ në́₃ jang'₅₄ 'nia'₂ con'₂ a₂ca₂tɨ́n₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dsa₂ 'éi₂ në́₃, jme₁ca₂nág₂ jág₁ në₅, ca₂i₃gó'₃ dsɨ́₅. Ca₂téin₂ bá₄ ca₂juë'₂ Jesús, ca₂i₃lein₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jmɨg₄ jaun₂ ca₂o₃lén₂ i₂lɨn₅₄ dsa₂ saduceos ca₂o₃jɨin₅₄ Jesús. Ia₁ tsá₃ 'én₂ dsa₂ 'éi₂ a₂jen'₅₄ táng₃ dsa₂ jë₁ma₂dsain₃. Jaun₂ jág₁ në₅ ca₂ŋɨ́i'₃ Jesús ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Të₅, le₂la₂ ca₂juá'₂ Moisés: në₁jua'₂ ca₂jon₃ jan₂ dsa₂ ŋe'₂ të₃ tsá₃ ca₂can₃ 'io₅₄ quiáin₅ guein₂, tion₅₄ 'nió'₅ jén'₂ gu₂ dsó₂ rɨn'₅₄ dsa₂ ŋe'₂ i₂ca₂jon₃ quian'₅₄ 'io₅₄ 'nág₂ 'éi₂, ia₁jaun₂ guein₂ i₂le₃chan₂ quiáin₅, lé₂ co₂'nió'₄ tsɨ₁jon₂ 'lag₄ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Dse₃ jaun₂. Jë₄ quián₂ jnia'₅₄ la₂, jme₁chan₂ guion₃ dsa₂ ŋe'₂ i₂lɨ́n₅ rɨn'₅₄. Ca₂jen'₂ gu₂ i₂le₂'uɨg₅₄, la₁ ca₂join₃ bá₄, të₃ tsá₃ guein₂ ca₂can₃ 'io₅₄ quiáin₅. Jaun₂ ca₂të₁'ŋiá₄ bá₄ 'io₅₄ 'nág₂ 'éi₂ o₄gú₃ dsó₂ rɨin'₅₄ i₂jë₁ca₂të́₂ on₃. ");
INSERT INTO cntNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","La₁ ján₃ bá₄ le₂jaun₂ ca₂i₃ŋɨ́i₂, ca₂join₃ bá₄ ján₃. Jaun₂ ca₂guá₂ táng₃ 'io₅₄ 'éi₂ quian'₅₄ i₂jë₁ca₂të́₂ ún₂ dsó₂; ján₃ bá₄ le₂jaun₂ ca₂lë₃ quian'₅₄ 'éi₂. Jaun₂ le₂në₅ bá₄ ca₂lë₃ quian'₅₄ ta₁guion₃ dsó₂ 'éi₂ con'₂ i₂jme₁lë́₄ rɨn'₅₄, ca₂dsain₃ bá₄ të₃ tsá₃ guein₂ ca₂can₃ 'io₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jaun₂ ca₂jon₃ bá₄ 'io₅₄ jme₁ca₂jon₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jaun₂ në́₃, jmɨg₄ jë₁ma₂të́₂ rë₁jen'₅₄ 'lag₄, ¿'ein₂ bá₄ quián₅ lé₂ 'io₅₄ 'éi₂? Ia₁ ta₁guion₃ bá₄ guë'₂ dsa₂ ŋe'₂ ca₂guá₂ quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jaun₂ ca₂ŋag₃ Jesús: ―Tsá₃ le₂jaun₂ lia'₂ ŋɨ́'₂ 'au'₂ 'nia'₂, ia₁ tsá₃ cuɨn'₂ 'nia'₂ 'a₂ lia'₂ juá'₂ Si₂, on₃ guë'₂ cuɨn'₂ 'nia'₂ 'a₂ lia'₂ lë́₅ juɨ₅bí₂ quió'₅ Diú₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Jë₁ma₂të́₂ jmɨg₄ a₂jen'₅₄ 'lag₄, on₃jua'₅₄ a₂le₃chain₂ jua'₅₄ a₂qui₃jéin'₂ guë́₄ gu₂, on₃ guë'₂ në₅ tóin'₃ guë́₄ jua'₅₄ a₂qui₃cuɨin₃ chi'₂ quiáin₅ a₂jéin'₂ gu₂, ia₁ i₂lén₂ juɨ₁lia'₂ lɨ́n₅ ángeles i₂tion'₅₄ guei'₅₄ i₂juɨ́g₃ bá₄ 'éi₂ jmɨg₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","La₁ juɨ₁lia'₂ a₂jen'₅₄ táng₃ 'lag₄, ¿tsa₁ ma₂'í'₂ 'nia'₂ ne₄ Si₂ juɨ₁lia'₂ a₂ca₂juá'₂ 'ŋiog₅ Diú₄ jme₁ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Jniá₂ bá₄ lɨ́ng₅ Diú₄ quián₅ Abraham, quián₅ Isaac, quián₅ Jacob në́₃?” A₂lɨ́in₅ Diú₄ quián₅ dsa₂ jén'₃ bá₄, on₃jua'₅₄ rë'₂ Diú₄ quián₅ 'lag₄. ");
INSERT INTO cntNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jme₁ca₂nág₂ dsa₂ jág₁ në₅, ca₂i₃gó'₃ dsɨ́₅ 'a₂ lia'₂ jme₂tag₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jme₁ca₂rë₃ŋi₅ dsa₂ fariseos ca₂lɨ́'₃ bá₄ táng₃ Jesús jág₁ a₂ca₂tsɨ́in₂ quian'₅₄ dsa₂ saduceos, jaun₂ ca₂ŋɨi'₂ ca₂jmo₃ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jaun₂ jan₂ rɨin'₅₄ i₂lɨ́n₅ të₅juá'₅, jme₁'nio₃ jme₁jo₅₄ quian'₅₄ jág₁, jaun₂ ca₂ŋɨ́i'₃ Jesús: ");
INSERT INTO cntNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Të₅, ¿'e₂ 'Éi'₃ Juá'₅ a₂dsen₅₄ guë́₄ con'₂ guë́₄ ca₂le₃jë́₃ Si₂ 'Éi'₃ quió'₅ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jaun₂ ca₂ŋag₃ Jesús: ―“Jme₁'nió₄ Te₁gui'₅₄ Diú₄ quiáng'₂, ca₂le₃jë́₃ 'au'₂, ca₂le₃jë́₃ jme₂dsí₂ quiáng'₂, ca₂le₃jë́₃ 'a₂ lia'₂ niog₅ ŋɨ́'₂ dsei'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A₂në₅ bá₄ 'Éi'₃ Juá'₅ a₂le₂'uɨg₅₄ a₂dsen₅₄ guë́₄ con'₂ guë́₄ ca₂le₃jë́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jë₁ca₂të́₂ tɨn₃ 'Éi'₃ në́₃, mei'₂ tsá₃ co₂rë₂ quian'₅₄ a₂le₂'uɨg₅₄: “Jme₁'nió₄ dsa₂ mɨ₂güɨ́g₃ rɨ́ng'₂ juɨ₁lia'₂ 'nióg'₃ 'ŋiag'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tɨn₃ 'éi'₃ në₅ bá₄ lë́₅ 'uɨg₅₄ cho'₅₄ ca₂le₃jë́₃ 'Éi'₃ quió'₅ Moisés quian'₅₄ ca₂le₃jë́₃ jág₁ a₂ca₂'ë́₂ dsa₂ i₂chen₄ quián₅ Diú₄ ma₂lɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Të₃ tion'₅₄ dsa₂ fariseos le₁ŋɨi'₂, ");
INSERT INTO cntNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","jaun₂ ca₂ŋag₃ Jesús ca₂juá'₂: ―¿'A₂ lia'₂ lɨ́n'₂ 'nia'₂? ¿'Ein₂ tsɨ₁jon₂ quián₅ lɨ́n₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄? ―Tsɨ₁jon₂ David ―ca₂ŋag₃ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jaun₂ ca₂juá'₂ táng₃ Jesús: ―¿'A₂ lia'₂ jaun₂? Ia₁ 'ŋiog₅ bá₄ guë'₂ David ca₂juá'₂ lia'₂ con'₂ jme₁ca₂'í₃ Jme₂dsí₂ Jŋió₅ të₂dsɨ́₅, ca₂të₃ “Te₁gui'₅₄.” ¿'A₂ lia'₂ lë́₅ jaun₂? Ia₁ 'ŋiog₅ bá₄ guë'₂ David ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ca₂juá'₂ Diú₄ ca₂tsɨ́'₃ Te₁gui'₅₄ quiáng₃: “Né₂ con₂ jniá₂ të₂le₃ gu₃ ne₁, ca₂lia'₂ ca₂të́₂ jmɨg₄ a₂tón'₁ jniá₂ dsa₂ i₂'iog₅₄ o₄tag'₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿'A₂ bá₄ lia'₂ lë́₅ a₂lɨ́in₅ tsɨ₁jon₂ David, ton'₂ 'ŋiog₅ bá₄ guë'₂ David ca₂të₃ “Te₁gui'₅₄ quiáng₃?” ");
INSERT INTO cntNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jaun₂ të₂le₃ ne₄ juɨ₅ guë́₄ jaun₂, tsá₃ ma₃'ein₂ ca₂tiá₂ dsɨ́₅ jua'₅₄ a₂ŋag₃ guë́₄ 'e₂ ŋag₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jaun₂ në́₃ ca₂ton₃ Jesús jág₁ ca₂tsɨ́'₃ dsa₂ juɨn₅ i₂quiain'₅₄, ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ në́₃, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Dsa₂ fariseos quian'₅₄ të₅juá'₅ në́₃, tiáin'₅ ta₁ a₂jme₁lɨ́n₄ Moisés. ");
INSERT INTO cntNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jaun₂ lë₃ ca₂tɨ́n'₂ 'nia'₂ nág'₁ gau₂ jág₁ quió'₅, jme₁ti'₄ 'nia'₂ 'e₂ a₂te₂néi'₂. La₁ tsá₃ can₂ 'nia'₂ juɨ₅ jua'₅₄ a₂jmó'₂ juɨ₁lia'₂ a₂jmo₂₃ guioin₅₄, ia₁ juɨ₁lia'₂ jme₂tag₂₃, tsá₃ jme₂ti₃ guioin₅₄; të₂le₃ siá'₂ bá₄ jmo₂₃ dsó₅. ");
INSERT INTO cntNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Qui₂'nei₂₃ lio₅₄ guei₂ 'ŋio₅ lɨn₃ qui₂dsɨ₂₃ mɨ₂ca'₄ dsa₂, la₁ guioin₅₄ në́₃ ca₂lia'₂ jŋia'₅₄ caun₂ chi₁gú₃ bá₄ tsá₃ 'nio₃ tí₂ jua'₅₄ a₂jme₃'o₅₄ cán₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ca₂le₃jë́₃ 'e₂ a₂jmo₂₃, jmo₂₃ a₂jŋia'₅₄ con'₂ 'nio₃ jág₂ dsa₂ bá₄. Ia₁ tɨn₂ dsɨ́₅ i₃quian₅₄ le₁ton₅ jma₃ca₂tsɨ́n'₅ tsɨ₁'mɨ'₂ 'ɨ́₂ le₂con₂ chi₁quí₃ quian'₅₄ mɨ₂cu₅ në́₃ qui₂le₁ton₅ 'éi'₃ quió'₅ Diú₄; a₂ta₁ dsɨ́₅ i₂nioi₅₄ le₁qui'₂ tsɨ₁'mɨ'₂ chen'₅₄ jang₄ qui₂le₁'ág₄ a₂lë́₅ lí₁ ca'₅₄ a₃tag₄. ");
INSERT INTO cntNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","'Ŋio₅ të₅ dsɨ́₅ qui₂dsɨ₂toin'₅₄ jmá'₃ lia'₂ ja₁jlá'₁ bá₄ ja₁qui₂dsɨ₂guë́'₃, qui₂dsɨ₂tiain'₂ ja₁dsen₅₄ guë́₄ juɨ₁lia'₂ dsi₂néi₂ guá'₅ sinagoga në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ton'₂ 'ŋio₅ të₅ dsɨ́₅ qui₃cuag₃ dsa₂ Diú₄ jë₄ 'ma'₅₄, qui₃të́₂ dsa₂ “të₅” në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’La₁ 'nia'₂ në́₃, tsá₃ ca₂tɨ́ng'₂ jua'₅₄ të́₂ dsa₂ “të₅”, ia₁ ca₂le₃jɨ́n'₃ bá₄ 'nia'₂ lë́₅ rɨ́ng'₂; ia₁ jan₂ bá₄ Të₅ quián'₂ 'nia'₂ chan₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tsá₃ të'₅₄ 'nia'₂ “tia₅₄” 'i₁jan₂ dsa₂ mɨ₂güɨ́g₃, ia₁ jan₂ bá₄ Ŋéi'₅ 'nia'₂ i₂chan₂, i₂guá₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tsá₃ cuë́'₁ 'nia'₂ jmɨg₄ a₂të́₂ dsa₂ 'nia'₂ guiong'₅₄ a₂lɨ́ng'₅ juɨg₅₄ dsa₂, ia₁ jan₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄ bá₄ i₂lɨ́n₅ juɨg'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Juɨ₁lia'₂ i₂jme₃ti₃ ta₁ ne₄ rɨn'₅₄, i₂'éi₂ bá₄ i₂juɨn'₂ guë́₄. ");
INSERT INTO cntNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ia₁ juɨ₁lia'₂ i₂jme₂can'₅₄ guion₅₄ jɨn₄ rɨn'₅₄, të₂le₃ sióin₂, lé₂ mei'₂; la₁ juɨ₁lia'₂ i₂jmo₅ me'₂ jɨn₄ rɨn'₅₄, i₂'éi₂ bá₄ lén₂ i₂juɨn'₂ guë́₄ con'₂ guë́₄ ca₂le₃jɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ të₅juá'₅, 'nia'₂ dsa₂ fariseos në́₃, i₂lë₁jmo₅-dsáu₅ o₁ne₁! Ia₁ jnág'₂ 'nia'₂ o₄'né₄ guei'₅₄ i₂juɨ́g₃ ja₁gon₂ Diú₄, tsá₃ cuë'₂ 'nia'₂ jmɨg₄ tón'₃ i₂sián'₂. Ia₁ on₃ guë'₂ tón'₂ 'nia'₂ guiong'₅₄, on₃ guë'₂ cuë'₂ 'nia'₂ juɨ₅ tón'₃ juɨ₁lia'₂ i₂'nio₃ tón'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ të₅juá'₅, 'nia'₂ dsa₂ fariseos në́₃, i₂lë₁jmo₅-dsáu₅ o₁ne₁! Ia₁ qui₂i₂nio'₄ 'nia'₂ ca₂le₂con₂ mɨ₂güɨ́g₃ qui₁'ang'₄ jmɨ₁ŋí'₄, a₂qui₂jme₂tɨ́ng'₁ dsa₂ lia'₂ lë́₅ 'én'₂ 'nia'₂ guiong'₅₄. Jë₁ma₂ca₂jon'₃ 'nia'₂ dsa₂ a₂dsɨ₃léin₂ juɨ₅ quiáng'₂, qui₂jme₂tɨ́in'₁ 'nia'₂ a₂jŋia'₅₄ con'₂ a₂jme₃'lɨin'₅₄ guë́₄ lia'₂ con'₂ guë́₄ guion'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂, dsa₂ ten₄ i₂quian₅ ne₄ juɨ₅! Ia₁ juá'₂ 'nia'₂ jme₂tɨ́ng'₁ dsa₂: “Në₁jua'₂ 'ein₂ ca₂cuë₃ jág₁ quió'₅ 'ë₂₃ guá'₅, tsá₃ 'e₂ quen₅ jág₁ jaun₂; la₁ në₁jua'₂ ca₂'ë₃ cu₄nióg₄ a₂te₁'i₁ guá'₅, a₂jaun₂ guë́₄ dsón'₂ quen₅ jág₁ quió'₅”, tion₅₄ 'nió'₅ jme₃ti₃ jág₁ a₂në₂cuë₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡'Nia'₂ dsa₂ ten₄, dsa₂ co₄! ¿'E₂ a₂quen₅ guë́₄ 'ŋio₅ lɨn₃? ¿Cu₄nióg₄, o₃ guá'₅ ja₁rë₂jŋió₃ cu₄nióg₄ jaun₂ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Juá'₂ 'nia'₂ ján₃: “Në₁jua'₂ 'ein₂ cuë₅ jág₁ quió'₅ a₂'ë₂₃ ne₄chei₂, ján₃ bá₄ tsá₃ 'e₂ quen₅ jág₁ jaun₂; la₁ në₁jua'₂ ca₂'ɨin₃ já'₂ i₂rë₂jen'₅₄ ne₄ ne₄chei₂, jaun₂ guë́₄ dsón'₂ tion₅₄ 'nió'₅ jme₃ti₃ jág₁ quió'₅.” ");
INSERT INTO cntNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡'Nia'₂ dsa₂ ten₄! ¿'E₂ jaun₂ a₂lë́₅ a₂dsen₅₄ guë́₄? ¿Já'₂ i₂rë₂jen'₅₄ ne₄ Diú₄, o₃ ne₄chei₂ a₂rë₂jŋió₃ já'₂ 'éi₂ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jaun₂ lë₃, juɨ₁lia'₂ jme₁cuë₅ dsa₂ jág₁ quió'₅ a₂'ë₂₃ ne₄chei₂, on₃jua'₅₄ jmá'₃ ne₄chei₂ 'ë₂₃; a₂'ë₂₃ ca₂le₃jë́₃ 'e₂ a₂te₁'i₁ ne₄chei₂ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Le₂në₅ bá₄ ján₃, juɨ₁lia'₂ i₂'ë₅ guá'₅, on₃jua'₅₄ jmá'₃ ca₂ne₅₄ guá'₅ 'ë₂₃, a₂'ɨin₂₃ le₂jiog₅ Diú₄ i₂guá₅ dsi₂néi₂ jaun₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ján₃ bá₄ le₂në₅ juɨ₁lia'₂ i₂'ë₅ guei'₅₄ i₂juɨ́g₃, a₂ma₂në₂'ë₃ le₂jiog₅ ne₄ta₁ quió'₅ Diú₄, ton'₂ a₂ma₂në₂'ɨin₃ le₂jiog₅ 'ŋiog₅ Diú₄ i₂guá₅ ne₄ta₁ jaun₂ bá₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ të₅juá'₅, 'nia'₂ dsa₂ fariseos në́₃, i₂lë₁jmo₅-dsáu₅ o₁ne₁! Ia₁ qui₂jáng'₂ 'nia'₂ caun₂ qui'₅₄ a₂guia₃ quió'₅ mɨ₁'au₂ mɨ₂juɨg₂, juɨ₁lia'₂ menta, anís, quian'₅₄ qui₂má₃ në́₃. La₁ tsá₃ tón'₂ guë'₂ 'nia'₂ juɨ₅ 'Éi'₃ Juá'₅ a₂dsen₅₄ guë́₄ quió'₅ Diú₄ ron₅, juɨ₁lia'₂ ja₁juá'₂ a₂'nió'₅ jmo₃ dsa₂ a₂dse₃, a₂dsia₃ dsa₂ ŋéi₂ dsɨ́₅ dsa₂ mɨ₂güɨ́g₃ rɨin'₅₄, a₂jmo₃ dsa₂ tí₅ jág₁ quió'₅ quian'₅₄ rɨin'₅₄. A₂në₅ bá₄ a₂dsen₅₄ guë́₄ a₂ca₂tɨ́n'₂ 'nia'₂ jmó'₂, la₁ on₃jua'₅₄ a₂tsá₃ ma₃jme₁ti'₄ 'nia'₂ 'Éi'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡'Nia'₂ dsa₂ ten₄ i₂quian₅ ne₄ juɨ₅! Qui₁ŋɨ'₄ 'nia'₂ quió'₅ i₁lu₂ pí'₁, la₁ nɨ́'₅ bá₄ guë'₂ 'nia'₂ guiong'₅₄ juɨ₁lia'₂ já'₂ camello. ");
INSERT INTO cntNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ të₅juá'₅, 'nia'₂ dsa₂ fariseos në́₃, i₂lë₁jmo₅-dsáu₅ o₁ne₁! Ia₁ lɨ́n'₅ 'nia'₂ juɨ₁lia'₂ lë́₅ nɨ₁vaso, nɨ₁uɨng₅ në́₃, qui₁rɨn'₄ 'nia'₂ jmá'₃ lia'₂ le₃co'₅₄. La₁ të₂le₃ juɨ₅ të₂'au'₂ 'nia'₂, qui₂rë₂can'₂ ca₂le₃jë́₃ ne₅₄ a₂'lɨg'₅₄ a₂qui₂dsɨ₂jŋia₅ 'au'₂ 'nia'₂, 'niog'₂ 'nia'₂ jua'₅₄ jmá'₃ lia'₂ guiong'₅₄ bá₄ qui₂le₃cha₂ quiáng'₂; qui₂ja₂nó'₅ 'nia'₂ 'ang'₂ quió'₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡'Nia'₂ dsa₂ fariseos ten₄! Rang₂ 'nia'₂ de'₂ jŋiá₅ le₃'ŋió'₂ nɨ₁vaso quian'₅₄ nɨ₁uɨng₅, jaun₂ guë́₄ lé₂ le₁jë́₃ le₂tan₅₄ le₃co'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ të₅juá'₅, 'nia'₂ dsa₂ fariseos në́₃, i₂lë₁jmo₅-dsáu₅ o₁ne₁! Ia₁ lɨ́n'₅ 'nia'₂ juɨ₁lia'₂ lë́₅ tau₂ 'ŋio₅ a₂jŋia'₅₄ con'₂ jniá₂ tiog₂, jniá₂ jlá'₁ jmá'₃ lia'₂ le₃co'₅₄ bá₄, la₁ le₃'ŋió'₂ qui₂rë₂can'₂ nɨ₁mu₅, chí'₅ ma₂'lɨg'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Le₂në₅ bá₄ lɨ́n'₅ 'nia'₂; 'e₂ guë́₄ dsen'₃ 'nia'₂ jniág'₂ jmá'₃ lia'₂ le₃co'₅₄ të₃jë₄ jág₅ dsa₂, la₁ të₂'au'₂ guë'₂ 'nia'₂ qui₂rë₂can'₂ ca₂le₃jë́₃ ne₅₄ a₂'lɨg'₅₄, a₂jmo'₂ dsáu'₂ 'nia'₂ o₁ne₁ 'e₂ a₂jmo'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ të₅juá'₅, 'nia'₂ dsa₂ fariseos në́₃, i₂lë₁jmo₅-dsáu₅ o₁ne₁! Ia₁ qui₂jmóg'₂ 'nia'₂ tau₂ 'ŋio₅ quió'₅ dsa₂ i₂ca₂'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂, qui₂jmóg'₂ 'nia'₂ jlá'₁ qui₂rë₂lag₄ juɨ₁lia'₂ ja₁le₁'on₅ dsa₂ dsen₃ i₂ma₂dsan₃. ");
INSERT INTO cntNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jaun₂ jag'₅₄ 'nia'₂: “Jua'₅₄ mei'₂ bá₄ ca₂rë₃chóng₃ jniog₄ jmɨg₄ jaun₂ lia'₂ con'₂ jme₁chan₂ dsa₂ can'₅₄ quián₂ ma₂lɨ́g'₂, tsá₃ jme₁jme₁quiain'₅₄ jniog₄ lia'₂ con'₂ jme₁ca₂jmo₃ a₂ca₂i₃'o₅₄ jmɨ₂ 'an₅₄ dsa₂ i₂chen₄ 'éi₂ quián₅ Diú₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jaun₂ le₂në₅, quian'₅₄ jág₁ quián'₂ 'nia'₂ guiong'₅₄, jáng'₂ 'nia'₂ jág₁ dsau₅ a₂lɨ́ng'₅ tsɨ₁jon₂ dsa₂ i₂ca₂jme₃dsian₅ dsa₂ i₂ma₂chen₃ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jaun₂ në́₃, jme₁'ŋia₅ 'nia'₂ dso₄ a₂ca₂jme₃lióg₃ dsa₂ can'₅₄ quián'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Já'₂ 'lɨn'₅₄! ¡Tsɨ₁jon₂ dsɨ₂mɨ'₂! ¿'A₂ bá₄ lia'₂ le₃lon'₅₄ 'nia'₂ 'éi'₃ uɨg₅ a₂já₅ ja₁con'₂ 'nia'₂ a₂dsi₁nog'₃ guio₃-juɨ́g₃? ");
INSERT INTO cntNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","'Uɨg₅₄ jaun₂, tsɨn₅₄ jniá₂ ja₁con'₂ 'nia'₂ dsa₂ i₂'ë́₂ jág₁ o₄quió₃, dsa₂ i₂ŋɨ́'₂ niog₅ dsi₄, i₂lɨ́n₅ të₅ në́₃. I₂lɨn₅₄ 'éi₂ jme₁dsiain'₂ bá₄ 'nia'₂, i₂lɨn₅₄ guë'₂ qui₁tóin'₄ 'nia'₂ cróg₄. I₂sián'₂ guë'₂ në́₃ qui₁cuë'₅₄ 'nia'₂ dsi₂néi₂ guá'₅ sinagogas quiáng'₂, qui₂co₁'éin'₄ 'nia'₂ në́₃ le₂'í₁ juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jaun₂ lë₃, 'nia'₂ bá₄ le₁cáng'₄ jmɨ₄ ca₂le₃jɨ́n₃ dsa₂ dsen₃ i₂qui₂ma₂dsan₃ mɨ₂güɨ́g₃, ca₂të₂ jmɨ₄ Abel i₂jme₁lɨ́n₄ dsa₂ dsen₃, ca₂të₂ jmɨ₄ Zacarías ja₁ŋi'₅₄ Berequías, i₂ca₂jŋɨ́'₃ 'nia'₂ i₁dsi₅ guá'₅ jë₄ ja₁lë́₄ ja₁jŋió₅ quian'₅₄ ja₁chí'₄ ne₄chei₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, dsa₂ chan₂ jmɨg₄ në₃ bá₄ rë₂cán'₄ ca₂le₃jë́₃ dso₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡'Nia'₂ dsa₂ juɨg₂ Jerusalén! ¡'Nia'₂ dsa₂ juɨg₂ Jerusalén, 'nia'₂ i₂jme₂dsiáng'₁ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄, 'nia'₂ i₂qui₂jnag'₅₄ cang₄ dsa₂ i₂chen₅ Diú₄ jɨn'₄ 'nia'₂! ¡'Lióng₂ ráun₂ jme₁'ɨ́n₅ dsɨ₃ jme₁chi₁liang'₂ guein₂ dsa₂ juɨg₂ quiáng'₂, juɨ₁lia'₂ jmo₅ i₁tsɨ́n'₃ a₂chi₂lain'₂ guein₂ quiáin₅ to'₂ né'₃ tsɨ₁rë₂cu₅, la₁ guion'₅₄ 'nia'₂ tsá₃ ca₂gue'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jag₄ jaun₂, dsi₂néi₂ quiáng'₂ në́₃ të₃'ŋiá₄, të₃tsɨ'₅₄ tei₄, tsá₃ 'ein₂ chan₂ lé₂. ");
INSERT INTO cntNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ia₁ juá'₅ jniá₂, tsá₃ ma₃la₂ jag'₅₄ 'nia'₂ jniá₂, ca₂lia'₂ ca₂të́₂ jmɨg₄ jë₁ma₂të́₂ rë₁jua'₅₄ 'nia'₂: “Juɨ₁le₂jŋió₃ bá₄ i₂në₅ i₂jón'₅ o₄quió'₄ Te₁gui'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jaun₂ ca₂o₃'ɨ́n₃ Jesús i₁dsi₅ guá'₅ templo ja₁jme₁'ein₅₄. Jme₁ma₂'ein₅₄ juɨ₅ ŋái'₅, ca₂jme₃quián₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ të́₂, ca₂juá'₂: ―Jag₄ 'a₂ lia'₂ lë́₅ guá'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","La₁ jaun₂ ca₂ŋag₃ Jesús: ―¿Jág'₂ 'nia'₂ ca₂le₃jë́₃ a₂në₅? A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, já₅ jmɨg₄ lia'₂ 'i₁ca₂mɨ́g₂ nɨ₁cang₁ tsá₃ ma₃'e₂ jua'₅₄ a₂le₁juɨ́₄ guë́₄ lé₂ quian'₅₄ rɨn'₅₄. Ca₂le₃jë́₃ bá₄ 'én₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jme₁ca₂dsióg₃ Jesús Má'₂ Olivos; ja₁jaun₂ ca₂guá₂. Jaun₂ ca₂i₁len₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ con'₂ jë₄ jmá'₃ guioin₅₄, ca₂nɨ́i'₃ Jesús: ―'Niog₂ jnia'₅₄ le₃ne₄ lɨ́g'₂ lé₂ a₂juá'₂ 'ne₂ në₅. ¿'E₂ léi₄ lé₂ jë₁ma₂të́₂ rë₁ŋeg'₅₄ táng₃? ¿'E₂ bá₄ léi₄ lé₂ jë₁ma₂të́₂ rë₁të₅₄ jmɨg₄ jaun₂? ");
INSERT INTO cntNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jaun₂ ca₂ŋag₃ Jesús: ―Jmo₄ 'nia'₂ 'í₁ ia₁jaun₂ tsá₃ 'ein₂ jme₃gau₅. ");
INSERT INTO cntNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ia₁ juɨn₅ i₂të₁i₃nio₄ a₂juá'₂ i₂nioi₅₄ o₄quió₃ jniá₂, juá'₂: “Jniá₂ bá₄ lɨ́ng₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄”; jaun₂ juɨn₅ dsa₂ i₂qui₂jme₃gain₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jë₁ma₂nei'₂ 'nia'₂ 'ei₅ jág₁ a₂nio₃ 'nei₂ a₂quɨ́n'₂ dsa₂ ja₁lá₃ ja₁ó₃, la₁ tsá₃ jmó'₂ 'nia'₂ gang'₃, ia₁ le₂jaun₂ dsón'₂ lé₂ bá₄. La₁ 'nió'₅ bá₄ guë́₄ a₂ŋɨ́₂ jein₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ia₁ nio₃ 'nei₂, qui₃quɨ́n'₂ dsa₂ le₂caun₂ le₂caun₂ juɨg₂ nación; dsɨ₂tan₅₄ guë'₂ në́₃ qui₃tóin'₃ mɨ'₅₄ quɨ́in'₂ quian'₅₄ dsɨ₂tan₅₄ rɨin'₅₄ i₂chan₂ juɨg₂ siá'₂. Jaun₂ guë́₄ në́₃ 'lióng₂ ja₁qui₂i₂nio₄ dsa₂ 'oin₅₄ lé₂, ton'₂ 'lióng₂ ja₁qui₂dsɨ₃bi₅₄ 'uë₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ca₂le₃jë́₃ a₂në₅ lé₂ a₂le₂'uɨg₅₄ jmɨ₁uɨg₅ juɨ₁lia'₂ jan₂ 'io₅₄ i₂rë₂chan₂ guein₂ quián₅. ");
INSERT INTO cntNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Jaun₂ guë́₄ në́₃, qui₃jɨ́n'₂ dsa₂ 'nia'₂ ne₄ dsɨ₂tan₅₄ ia₁jaun₂ cuë₃ dsa₂ uɨg₅, jaun₂ guë́₄ jme₃dsian₅ dsa₂ 'nia'₂. Le₂con₂ mɨ₂güɨ́g₃ bá₄ jme₃'ŋia₅₄ dsa₂ 'nia'₂ 'uɨg₅₄ quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jmɨg₄ jaun₂, juɨn₅ dsa₂ i₂tí₂ juɨ₅ quió'₅ Diú₄ a₂jme₁'éin₂, qui₂jme₃'ŋiai₅₄ bá₄ rɨin'₅₄, qui₃jáng'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Juɨn₅ dsa₂ le₃chan₂ i₂'ë́₂ jág₁ i₂juɨ₁gan₂, jaun₂ juɨn₅ dsa₂ i₂jme₃gain₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","'Uɨg₅₄ ia₁ a₂ŋɨ́₄ lë₃ juɨ₁si ŋag₅₄ le₃'lɨn'₅₄ dsa₂, co₂dsia₅ le₃güɨ́g'₂ bá₄ 'a₂ lia'₂ jme₁'nio₃ dsa₂ rɨin'₅₄ le₂jain₂ le₂jain₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","La₁ juɨ₁lia'₂ i₂náu₃ tiá₂ të₂ jë₁ca₂tó'₂, 'éi₂ bá₄ lión₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jág₁ dse₃ la₂ juɨ₁lia'₂ 'a₂ lia'₂ lë́₅ ja₁gon₂ Diú₄ qui₂dsɨ₃'ag₅ ta₁caun₂ mɨ₂güɨ́g₃, ia₁jaun₂ le₃ŋi₅ ca₂le₃jë́₃ juɨg₂ te₁'i₁ gua'₅₄ 'uë₃ jág₁ dse₃ jaun₂; jaun₂ guë́₄ në́₃ të₅₄ jmɨg₄ jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Jaun₂ në́₃, já₅ jmɨg₄ a₂të₅₄ ne'₅₄ 'nia'₂ a₂náu₃ jan₂ dsa₂ i₂'lɨn'₅₄ guë́₄ lɨn₃, a₂jme₃'ióg₃ ja₁jŋió₅, a₂le₃ti₃ jág₁ a₂ca₂'ë́₂ Daniel i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, (jaun₂ juɨ₁le₂ŋɨ́'₂ bá₄ i₂'ɨ₅ si₂ la₂), ");
INSERT INTO cntNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","jaun₂ në́₃, dsa₂ i₂tián'₅ le₂tan₅₄ 'uë₃ Judea, juɨ₁cuɨng₁₂ juɨ₅ má'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Juɨ₁lia'₂ i₂'en₅₄ guei'₅₄ 'ne₄, tsá₃ ma₃juɨ₁sióin₄ jua'₅₄ a₂'uë́'₃ 'e₂ 'uë́'₃ dsi₂néi₂ quió'₅; ");
INSERT INTO cntNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","juɨ₁lia'₂ i₂'en₅₄ ja₁nau₂ quió'₅ táng₃, tsá₃ ma₃juɨ₁jŋioi'₅₄ jua'₅₄ a₂ja₃quián₂ tsɨ₁'mɨ'₂ dsiog₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Juɨ́g₂ bá₄ juɨ₁lia'₂ dsa₂ mɨ́₂ i₂le₁quian₅ guein₂, juɨ₁lia'₂ i₂le₁jŋia₅ guein₂ i₂'ɨ́n'₂ dsi'₅₄ në́₃, jmɨg₄ jaun₂! ");
INSERT INTO cntNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mɨ₄ 'nia'₂ ne₄ Diú₄ ia₁jaun₂ tsá₃ o₁le₅₄ jua'₅₄ a₂cuɨ́ng'₂ 'nia'₂ jein₂ güɨ́g₂, on₃ guë'₂ jmɨg₄ sa₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ia₁ juá'₅ jniá₂, caun₂ o₂i₁ dsɨ₅ lɨn₃ a₂le₃chan₂ dsa₂ jmɨg₄ jaun₂, caun₂ jmɨ₁uɨg₅ a₂tsá₃ ma₂ca₂rë₃chá₃ ca₂le₃ ca₂nio₃ mɨ₂güɨ́g₃, on₃ guë'₂ ma₃niog₅ jmɨg₄ jua'₅₄ a₂le₃cha₂ guë́₄ cang₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jua'₅₄ mei'₂ guë́₃ Diú₄ tsá₃ ma₂ca₂jme₃të́₃ jmɨg₄ jaun₂, 'i₁jan₂ tsá₃ 'ein₂ jme₁lión₂ jua'₅₄ mei'₂ guë́₃ tsá₃ le₂jaun₂. La₁ o₄quió'₄ i₂rë₂quion'₅₄ quiáin₅, jme₃të́₃ bá₄ jmɨg₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Në₁jua'₂ chan₂ i₂ca₂juá'₂ tsɨ́'₅ 'nia'₂ jmɨg₄ jaun₂: “¡Jag₄ 'nia'₂! ¡La₂ bá₄ chén'₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄!” o₃ në₁jua'₂ 'ein₂ ca₂juá'₂: “Jó₄ 'ein₅₄”, tsá₃ o₁'en'₅₄ 'nia'₂ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ia₁ juɨn₅ dsa₂ i₂juɨ₁gan₂ ja₃lén₂ a₂juá'₂ a₂lɨ́in₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄, a₂juá'₂ në́₃ a₂lɨ́in₅ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄; 'lióng₂ léi₄ juë'₂ a₂o₂dsain₂ jmo₃ a₂jme₃gain₂₃ dsa₂. Jua'₅₄ mei'₂ guë́₃ lé₂, ca₂të₂ dsa₂ i₂quion'₅₄ quián₅ Diú₄ jme₃gain₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jaun₂ në₅ ma₂në₂juɨ́g₂ jniá₂ 'nia'₂ të₃jŋiá₅. ");
INSERT INTO cntNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jaun₂ në́₃, në₁jua'₂ 'ein₂ ca₂tsɨ́'₃ 'nia'₂: “Ŋí₂ 'nia'₂, jó₄ 'ein₅₄ ja₁lë́₄ 'uë₃ quein₂ co₂'ŋiog₅”, tsá₃ lë₁o₂nó'₅ 'nia'₂ ja₁jaun₂; o₃ në₁jua'₂ 'ein₂ ca₂juá'₂: “Ŋí₂ 'nia'₂, ja₁lá₃ rë₂'mai₅₄ dsi₂néi₂”, tsá₃ juɨ₁le₂'én'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ia₁ juɨ₁lia'₂ jme₁lë́₂ si₁ŋí'₃ ca₂taun₂ ca₂taun₂, le₂jaun₂ bá₄ lé₂ jë₁ma₂të́₂ rë₁guan'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ia₁ juɨ₁lia'₂ ja₁ron₅ 'lag₄, ja₁jaun₂ bá₄ ŋɨ'₂ i₁tú₃ tsɨn'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Dsɨ₂juɨ₅ jë₁ma₂ca₂ŋag₅ jmɨg₄ o₂i₁ dsɨ₅ jaun₂, 'iog₂ në́₃ co₂dsia₅ le₃lia'₂, tsɨ'₂ në́₃ tsá₃ ma₃tág₅ jnia₅₄; nei₅ guë'₂ në́₃ qui₂tsɨ₃séi'₂, ca₂le₃jë́₃ guë́₄ 'e₂ bí₂ cha₂ guei'₅₄ mɨ₂güɨ́g₃ qui₃guian'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","’Të₃jë₄ jaun₂ guë́₄ në́₃, le₃jniá₂ guei'₅₄ dsi₂güɨg₂ léi₄ quió'₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃, ca₂le₃jë́₃ juɨg₂ te₁'i₁ le₂con₂ mɨ₂güɨ́g₃ tóin'₃ quɨ'₃-'o₃. Jɨ́in₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃, guain'₂ guei'₅₄ jë₄ jnei₅ quian'₅₄ ca₂le₃jë́₃ juɨ₅bí₂ a₂'io₂₃ jláin'₁. ");
INSERT INTO cntNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jaun₂ qui₃chein₃ ángeles quiáin₅ jéi₂ ŋí₂ trompeta tiá₂ lɨn₃ a₂të₂ dsa₂ i₂quion'₅₄ quiáin₅ i₂chan₂ ca₂le₃jë́₃ juɨg₂ te₁'i₁ ta₁caun₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Jme₁tɨn₅ 'nia'₂, juɨ₁le₂ŋɨ́'₂ 'au'₂ jág₁ a₂jáng'₅ léi₄ juɨ₁lia'₂ nɨ₁'ma₂ a₂'ag₅ mɨ́g₂ higos: jme₁chéi'₂ gu'₂ nei'₅₄, a₂ja₂'ŋio₃ mog'₅₄, ŋi'₅₄ 'nia'₂ a₂ma₂ja₂quián₃ jein₂ 'iog₂ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Le₂në₅ bá₄ 'nia'₂ jaun₂ në́₃, jë₁ma₂të₅ ne'₅₄ a₂lë́₂ ca₂le₃jë́₃ a₂në₅, juɨ₁le₂ŋi'₅₄ bá₄ 'nia'₂ a₂ma₂ja₂quiáin₃, në₂jag₄ bá₄ i₂ma₂chén'₅ o₄'né₄ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A₂dsɨ₂jó'₃ juá'₅ jniá₂ juɨ́g₂ 'nia'₂, tsá₃ dsɨ₃ŋɨ́₂ tsɨ₁jon₂ la₂, ca₂lia'₂ ca₂lë₃ ca₂le₃jë́₃ a₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Já₅ jmɨg₄, guei'₅₄ dsi₂güɨg₂ quian'₅₄ mɨ₂güɨ́g₃ la₂ ŋag₅, la₁ jág₁ quió₃ o₁lɨ́g'₂ tsá₃ ŋag₅ jua'₅₄ a₂tsá₃ le₃ti₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’La₁ 'i₁jan₂ tsá₃ 'ein₂ ŋi₅ 'e₂ 'ió'₄, 'e₂ hora lé₂ a₂jaun₂, on₃ guë'₂ ángeles i₂tion'₅₄ guei'₅₄ i₂juɨ́g₃, on₃ guë'₂ 'ŋiog₅ Ja₁ŋi'₅₄ Diú₄. Jŋia'₅₄ lia'₂ 'ŋiog₅ bá₄ Diú₄ Jmei₂ ŋi₅. ");
INSERT INTO cntNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ia₁ juɨ₁lia'₂ ca₂lë₃ jmɨg₄ lia'₂ con'₂ jme₁chan₂ Noé, le₂jaun₂ bá₄ lé₂ ján₃ jë₁ma₂të́₂ rë₁guan'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ia₁ jmɨg₄ jaun₂, né'₃ a₂can'₂ mɨ₂güɨ́g₃ quian'₅₄ jmɨg₂, jme₁chan₂ dsa₂ qui₂guë́'₅, qui₂'ɨ́n'₂, qui₂jéin'₂ gu₂, qui₂cuɨin₂₃ ja₁mɨ́g₄ jme₁jéin'₂ gu₂ në́₃, ca₂lia'₂ ca₂të́₂ jmɨg₄ jme₁ca₂'í₃ Noé 'ŋió'₃ nɨ₁barco; ");
INSERT INTO cntNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","la₁ con'₂ tsá₃ 'ein₂ rë₁ján₁ jme₁ca₂dság'₃ jmɨg₂ ca₂jiog₃ quió'₅ ca₂le₃jɨ́in₃. Le₂jaun₂ bá₄ lé₂ táng₃ jë₁ma₂të́₂ rë₁guan'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jmɨg₄ jaun₂, on₃ dsa₂ ŋe'₂ tion'₅₄ ja₁nau₂; jan₂ i₂dsán'₃, jan₂ guë'₂ i₂të₃'ŋiá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","On₃ guë'₂ dsa₂ mɨ́₂ tioin'₅₄ éi'₅ ne₄ nɨ₁to₂; jan₂ i₂dsán'₃, jan₂ guë'₂ i₂të₃'ŋiá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Jme₁jnio₂ 'nia'₂ ne'₅₄ jaun₂, ia₁ tsá₃ ŋi'₅₄ 'nia'₂ 'e₂ hora jŋió'₂ juɨg'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","La₁ juɨ₁le₂ŋɨ́'₂ 'au'₂ 'nia'₂ a₂la₂: jua'₅₄ mei'₂ guë́₃ ŋi₅ dsa₂ juɨg₅₄ caun₂ dsi₂néi₂ 'e₂ hora jiá₃ dsa₂ 'ang₂ të₂le₃ ca₂nei₂, jme₃jnio₅₄ ne₅₄, tsá₃ cuë₃ jmɨg₄ a₂'í₂ dsa₂, 'ang₃ dsi₂néi₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Le₂në₅ bá₄ 'nia'₂, rë₂ján'₁ 'nia'₂ chang'₂; ia₁ con'₂ tsá₃ ŋi'₅₄ bá₄ 'nia'₂ guan'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿'Ein₂ dsa₂ i₂ŋɨ́'₂ dsɨ́₅ jme₂ti₃ con'₂ dsi₂ten₅₄ ne₄ juɨg₅₄? Juɨg₅₄ në́₃ ca₂dsia₃ o₄gú₃ 'éi₂ dsi₂néi₂ quió'₅ lia'₂ jma₃quian'₅₄ ca₂le₃jɨ́n₃ rɨin'₅₄ i₂jme₂ti₃, a₂ŋɨi'₃ rɨin'₅₄ jë₁ma₂të́₂ hora a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","'E₂ guë́₄ dsen₃ 'éi₂ jë₁ma₂të́₂ rë₁jo₅₄ juɨg₅₄ jë₁ma₂guáin'₅ jme₂ti₃ bá₄ ta₁ a₂chéin'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A₂dsɨ₂jó'₃ juá'₅ jniá₂, cuë₃ juɨg₅₄ ta₁ a₂nio₃ ne₅₄ ca₂le₃jë́₃ 'e₂ a₂cha₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","La₁ jua'₅₄ mei'₂ guë́₃ dsa₂ i₂jme₂ti₃ lɨ́in₅ jan₂ dsa₂ 'lɨn'₅₄ i₂tsá₃ tón'₂ juɨ₅ ta₁ a₂chéin'₅, ia₁ lɨ́in₂, “i₂le₃'ɨn₄ bá₄ juɨg₃”, ");
INSERT INTO cntNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","jaun₂ jme₂lióg₃ qui₂cuë́'₅ bá₄ rɨin'₅₄, dsó₂ qui₂dsɨ₂guë́'₃ qui₂dsɨ₂'én'₃ quian'₅₄ dsa₂ 'en₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","La₁ caun₂ jmɨg₄ con'₂ tsá₃ rë₂jáin₁, caun₂ hora con'₂ tsá₃ lí'₄ bá₄, dsián'₄ juɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Juɨg₅₄ në́₃ cuë₃ uɨg₅, 'liog'₃ ja₁jaun₂ bá₄ ján₃, ja₁ca₂tɨ́n₂ dsi₁len₅ i₂lë₁jmo₅-dsáu₅ o₁ne₁, ja₁quɨ'₂-'o₃, qui₃quɨ́g'₃ jan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","'Jmɨg₄ jaun₂ juɨ₁lia'₂ ja₁gon₂ Diú₄, lé₂ juɨ₁lia'₂ ca₂jmo₃ guian₃ chi'₂ dsa₂ mɨ₄ jme₁ca₂can₃ nɨ₁tsɨ́₅ le₁guí'₂ si₂ quió'₅. Ca₂i₃léin₂ ca₂i₁jme₁jein'₂ dsa₂ ŋe'₂ i₂jen'₂ gu₂. ");
INSERT INTO cntNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","'Ŋiá₂ chi'₂ dsa₂ mɨ₄ 'éi₂ jme₁coin₅₄; 'ŋiá₂ guë'₂ i₂'ŋio₄, i₂dse₃ niog₅ dsi₄. ");
INSERT INTO cntNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Dsa₂ mɨ₄ i₂co₄ 'éi₂ në́₃, jmá'₃ nɨ₁tsɨ́₅ chi₁guí'₂ si₂ bá₄ ca₂can₃; tsá₃ ca₂can₃ guë'₂ nɨ₁dsɨg₁ a₂'a₄ aceite. ");
INSERT INTO cntNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","La₁ dsa₂ mɨ₄ i₂niog₅ dse₃ dsi₄ në́₃ ca₂jmo₃ co₂jŋia₅₄ quió'₅, jme₁le₁quian₅ nɨ₁tsɨ́₅ le₁guí'₂ si₂, ton'₂ jme₁le₁quian₅ rë₂tsón₂ aceite 'a₄ nɨ₁dsɨg₁. ");
INSERT INTO cntNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","La₁ ca₂rë₃'ɨn₄ bá₄ guë'₂ dsa₂ ŋe'₂ i₂lë₅ jág₁ jen'₂ gu₂, jaun₂ le₃jɨ́n₃ bá₄ dsa₂ mɨ́₂ 'éi₂ në́₃ ca₂tá'₂ i₁güɨ́in₃, jaun₂ ca₂güɨin₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jaun₂ jme₁ca₂të́₂ dsi₃nei₅, ca₂né'₂ tiá₂ i₁juá'₄ dsa₂: “¡Në₅ jón'₅ dsa₂ ŋe'₂ i₂jen'₂ gu₂! ¡'Uɨn'₂ 'nia'₂ o₂jme₁jein'₂!” ");
INSERT INTO cntNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jaun₂ qui₂ca₂nau₂ ca₂le₃jɨ́in₃, ca₂jmo₃ dse₃ mecha tsɨ́₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jaun₂ ca₂juá'₂ dsa₂ mɨ́₂ i₂'ŋiá₂ i₂co₄ 'éi₂ ca₂tsɨ́'₃ rɨin'₅₄ i₂'ŋio₄: “Cuë́'₁ 'nia'₂ ca₂juɨg₄ aceite quiáng'₂, ia₁ ma₂i₁ei₃ si₂ tsɨ́₅ quián₂ jnia'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","La₁ ca₂ŋag₃ dsa₂ mɨ́₂ i₂'ŋio₄: “Jan₂'ón₄. Ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ tsá₃ ca₂tɨ́n'₂ quián₂ jnia'₅₄ guio₅₄, on₃ guë'₂ quián'₂ 'nia'₂ tɨ́n'₂ në́₃. Co₂ŋei'₅₄ guë́₄ dse₃ o₂nó'₅ 'nia'₂ guiong'₅₄ o₂liá₃ quiáng'₂ ja₁'nag₅ dsa₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","La₁ të₁lia'₂ i₂lén₂ 'éi₂ i₂lia₅ aceite, të₃jë₄ jaun₂ ca₂guán'₃ dsa₂ ŋe'₂ i₂lë₅ jág₁ jen'₂ gu₂. Dsa₂ mɨ́₂ i₂tián'₅ lë́₅ co₂jŋia₅₄ ca₂i₃toin'₅₄ bá₄ co₂lë₅ quiong'₅₄ i₁guë'₂ ja₁niog₅ jmɨg₄ a₂jen'₂ gu₂ dsa₂. Jaun₂ ca₂jnág₃ o₄'né₄ jme₁ca₂jnág₃. ");
INSERT INTO cntNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jme₁co₂lág₂ jaun₂, o₃len₅ i₂'ŋiá₂ 'éi₂, jaun₂ ca₂tóin'₂ ca₂të₃, ca₂juá'₂: “¡Te₁gui'₅₄, Te₁gui'₅₄! ¡Nia₄ o₄'né₄ jaun₂ tió'₄ jnia'₅₄!” ");
INSERT INTO cntNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","La₁ jaun₂ ca₂ŋag₃ dsa₂ ŋe'₂: “A₂dsɨ₂jó'₃ juá'₅, tsá₃ cuɨ́ng₅ 'ein₂ 'nia'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","'Jaun₂ le₂në₅, chan'₂ 'nia'₂ co₂jŋiag'₅₄, ia₁ tsá₃ ŋi'₅₄ 'nia'₂ 'e₂ 'ió'₄, 'e₂ hora guan'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Con'₂ siá'₂ lë́₅ ja₁gon₂ Diú₄ juɨ₁lia'₂ jan₂ dsa₂ i₂'en₅₄ juɨ₅ dsó₃ dsɨ₃ŋɨ́₃ uɨ́ng₂ juɨg₂ siá'₂. Jaun₂ ca₂të́'₃ dsa₂ i₂jme₁jme₂ti₃ ta₁ ne₅₄, jaun₂ o₄gú₃ 'éi₂ ca₂dsia₃ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jan₂ i₂ca₂cuë́'₃ 'ŋiá₂ mei₅ 'éi'₃ cu₄ talentos; jan₂ guë'₂ i₂ca₂cuë́'₃ tɨn₃ mei₅, jan₂ guë'₂ caun₂ mei₅. Ca₂cuë́'₃ le₂jan₂ dsa₂ 'éi₂ 'a₂ con'₂ jŋia'₅₄ quɨ'₅₄ jmɨg₄. Jaun₂ guë́₄ ŋó₃ i₁ŋɨ́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dsa₂ i₂ca₂gue₃ 'ŋiá₂ mei₅ 'éi'₃ cu₄ në́₃, ca₂jmói'₂ ta₁ cu₄ jaun₂, jaun₂ ca₂lɨ́'₃ con'₂ guë́₄ 'ŋiá₂ mei₅ jmá'₃ a₂dsɨ́₂. ");
INSERT INTO cntNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ján₃ bá₄ le₂jaun₂ ca₂jmo₃ i₂ca₂gue₃ tɨn₃ mei₅, ca₂lɨ́'₃ con'₂ guë́₄ tɨn₃ mei₅ táng₃ a₂të₁dsɨ₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","La₁ dsa₂ i₂ca₂gue₃ caun₂ mei₅ në́₃, ca₂'ma₃ bá₄ a₂caun₂ mei₅ a₂ca₂cuë₃ juɨg₅₄, ca₂i₁'ó₄ né'₃ 'uë₃. ");
INSERT INTO cntNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Uë́₂ lɨn₃ bá₄ i₁ŋɨ₂ juɨg₅₄ në́₃; la₁ ca₂guáin'₃ jme₁ca₂guáin'₃ cang₂. Jaun₂ ca₂cáun₃ 'í₁ ca₂chein'₃ cuentas quió'₅ dsa₂ i₂jme₂ti₃ i₂ca₂cuë́'₃ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jaun₂ ca₂dsióg₃ i₂le₂'uɨg₅₄ i₂ca₂gue₃ 'ŋiá₂ mei₅, jaun₂ ca₂jɨ́in'₂ juɨg₅₄ con'₂ guë́₄ 'ŋiá₂ mei₅ a₂të₁dsɨ₅₄ a₂ca₂lɨ́'₃, jaun₂ juá'₂ tsɨ́'₃ juɨg₅₄: “Te₁gui'₅₄, ca₂cuë'₅₄ 'ne₂ 'ŋiá₂ mei₅; jag₄, la₂ ron₅ con'₂ guë́₄ 'ŋiá₂ mei₅ táng₃ a₂ca₂lág₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jaun₂ ca₂juá'₂ juɨg₅₄: “'Ŋio₅ dse₃ ca₂jmo'₅₄. Lɨ́ng'₅ bá₄ jan₂ dsa₂ dsen₃ i₂ca₂rë₃ti'₅₄; ca₂rë₃teng'₅₄ bá₄ quian'₅₄ a₂ca₂juɨg₄ a₂ca₂dsia₃ jniá₂ gog'₂, në₃ në́₃ 'lióng₂ guë́₄ a₂dsia₅₄ jniá₂ gog'₂. 'Ú₅ dsi₂néi₂, o₁quián₁ o₂'ŋió₃ dsɨ₅ co₂dsia₅.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jme₁co₂lág₂ jaun₂ ca₂dsióg₃ i₂ca₂gue₃ tɨn₃ mei₅, jaun₂ ca₂juá'₂: “Te₁gui'₅₄, ca₂cuë'₅₄ 'ne₂ tɨn₃ mei₅; jag₄, la₂ ron₅ con'₂ guë́₄ tɨn₃ mei₅ táng₃ a₂ca₂lág₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jaun₂ ca₂juá'₂ juɨg₅₄, “'Ŋio₅ dse₃ ca₂jmo'₅₄. Lɨ́ng'₅ bá₄ jan₂ dsa₂ dsen₃ i₂ca₂rë₃ti'₅₄; ca₂rë₃teng'₅₄ bá₄ quian'₅₄ a₂ca₂juɨg₄ a₂ca₂dsia₃ jniá₂ gog'₂, në₃ në́₃ 'lióng₂ guë́₄ a₂dsia₅₄ jniá₂ gog'₂. 'Ú₅ dsi₂néi₂, o₁quián₁ o₂'ŋió₃ dsɨ₅ co₂dsia₅.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","'La₁ jme₁ca₂dsióg₃ i₂ca₂gue₃ caun₂ mei₅, ca₂juá'₂ tsɨ́'₅ juɨg₅₄: “Te₁gui'₅₄, guion₄ jniá₂ a₂lɨ́ng'₅ jan₂ dsa₂ i₂tsá₃ 'e₂ ŋéi₂ dsɨ́₅, 'aun'₂ ja₁tsá₃ 'e₂ ca₂jŋí'₂, ton'₂ cag'₅₄ ja₁tsá₃ 'e₂ ca₂séi'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","'Uɨg₅₄ jaun₂ ca₂rë₃gó₅ jniá₂, ca₂i₁'ó₄ bá₄ jniá₂ cu₄ quiáng'₂ né'₃ 'uë₃. La₁, la₂ bá₄ ron₅ quiáng'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jaun₂ ca₂ŋag₃ juɨg₅₄: “¡Dsa₂ 'lɨn'₅₄ juɨ́'₅! 'An₁, ŋi'₅₄ bá₄ jaun₂ në́₃ a₂'on₂₃ ja₁tsá₃ 'e₂ ca₂jan₃, ton'₂ cag'₅₄ ja₁tsá₃ 'e₂ ca₂séi₃. ");
INSERT INTO cntNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","'Uɨg₅₄ jaun₂, jua'₅₄ banco bá₄ co₂ŋei'₅₄ ca₂i₁tio'₂ cu₄ quió₃, ia₁jaun₂ jme₁guéi'₄ cu₄ quió₃ jë₁ma₂guáng'₃ lia'₂ jma₃quian'₅₄ a₂të₁dsɨ₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jŋiá'₃ 'nia'₂ a₂caun₂ mei₅ chan'₂ i₂në₅ jaun₂ në́₃, o₂cuë'₅₄ i₂chan'₂ guia₃ mei₅. ");
INSERT INTO cntNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ia₁ juɨ₁lia'₂ i₂ma₂le₁'io₅ 'lióng₂, të₂le₃ 'lióng₂ guë́₄ ŋei₂ bá₄, ia₁jaun₂ le₃cha₂ quió'₅ lia'₂ qui₂rë₂tsón₂; la₁ juɨ₁lia'₂ i₂tsá₃ 'e₂ le₁'io₅, le₂jiog₅ a₂ca₂juɨg₄ a₂ma₂le₁'io₂₃, co₂dsia₅ jŋia'₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jaun₂ dsa₂ i₂tsá₃ ta₁ tén₄ la₂, dsein₅₄ ca₁'né₄ tioin'₂ 'nia'₂ jë₄ qui₁né'₃, ja₁quɨ'₂-'o₃ quɨ́g'₃ jan₅₄ në́₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Jë₁ma₂të́₂ rë₁guan'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ a₂lɨ́in₅ rag₅₄ jlán'₁ lɨn₃, a₂qui₂le₁lio₃ ángeles quiáin₅, jaun₂ guë́₄ guá₃ ne₄ta₁ quió'₅ a₂'uain'₂ lɨn₃, ");
INSERT INTO cntNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","jaun₂ ŋɨ'₂ ne₅₄ ca₂le₃jɨ́n₃ dsa₂ chan₂ juɨg₂ ca₂le₂con₂ mɨ₂güɨ́g₃. Jaun₂ guë́₄ në́₃ jmo₃ jma₃quén₅ con'₂ ca₂tɨ́n₂ le₂jan₂ le₂jan₂ dsa₂ quian'₅₄ rɨin'₅₄, juɨ₁lia'₂ jmo₅ dsa₂ i₂jmo₅ 'í₁ já'₂ cha'₂, jmo₂₃ jma₃quén₅ já'₂ cha'₂ quian'₅₄ chein₄ lau₂. ");
INSERT INTO cntNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Të₂le₃ gu₂ ne₁ quió'₅, chein'₃ já'₂ cha'₂; chein₄ lau₂ guë'₂ të₂le₃ gu₂ jen₅. ");
INSERT INTO cntNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jaun₂ në́₃, juá'₂ Rag₅₄ tsɨ́'₅ i₂tión₂ të₂le₃ gu₂ ne₁: “I₂no'₄ 'nia'₂ i₂ma₂rë₂gon'₅₄ quián₅ Ŋe'₃; gue₄ 'nia'₂ a₂ca₂tɨ́ng'₂ ja₁gon₂ Diú₄, ja₁ma₂lë́₅ co₂jŋia₅₄ quián'₂ 'nia'₂ ca₂le₃ ca₂nio₃ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ia₁ ca₂ŋɨ₃ jniá₂ 'ong₅₄, 'nia'₂ bá₄ i₂ca₂cuë'₅₄ a₂ca₂guë'₃; ca₂ŋɨ₃ a₂rë₂quein₂ dsɨ₃ i₁guɨ'₄ jmɨg₂, 'nia'₂ bá₄ i₂ca₂cuë'₅₄ jmɨg₂ ca₂guɨ'₃; ca₂ŋɨ₃ jniá₂ 'no₂₃ ja₁jan₁₂, 'nia'₂ bá₄ i₂ca₂cuë'₅₄ dsi₂néi₂ quiáng'₂ ca₂jan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ca₂ŋɨ₃ jniá₂ 'ɨn₂ tsɨ́n'₅, 'nia'₂ bá₄ i₂ca₂cuë'₅₄ tsɨ́n'₅ ca₂quɨ́'₃; ca₂tsán₂ dsong₅₄, 'nia'₂ bá₄ i₂ca₂jmo'₅₄ 'í₁; ca₂i₁'ú₄ né'₃ 'má₃, ca₂i₁jag'₄ bá₄ 'nia'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jaun₂ në́₃, ŋag₃ dsa₂ dsen₃ 'éi₂: “Te₁gui'₅₄, ¿lɨ́g'₂ bá₄ jaun₂ ca₂né₄ jnia'₅₄ 'ne₂ a₂ŋɨ'₂ i₁cuang'₃ jaun₂ ca₂cuë́₁ jnia'₅₄ a₂ca₂qué'₂? ¿O₃ lɨ́g'₂ jaun₂ ca₂né₄ jnia'₅₄ 'ne₂ a₂ŋɨ'₂ rë₂quein₂ 'au'₂, jaun₂ ca₂cuë́₁ jnia'₅₄ jmɨg₂ ca₂'én'₂? ");
INSERT INTO cntNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿O₃ lɨ́g'₂ jaun₂ ca₂né₄ jnia'₅₄ 'ne₂ a₂ŋɨ'₂ 'náu'₂ ja₁jan'₄, jaun₂ jnia'₅₄ bá₄ ca₂cuë́₁ dsi₂néi₂ ca₂jŋia'₅₄, o₃ ca₂ŋɨ'₅₄ 'ɨn₂ tsɨ́n'₂, jaun₂ jnia'₅₄ bá₄ ca₂cuë́₁? ");
INSERT INTO cntNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿O₃ lɨ́g'₂ jaun₂ ca₂né₄ jnia'₅₄ 'ne₂ a₂rong'₂ dsong'₅₄ o₃ lia'₂ con'₂ ca₂'ú'₃ né'₃ 'má₃, jaun₂ ca₂i₁jag₅₄ jnia'₅₄?” ");
INSERT INTO cntNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jaun₂ në́₃, ŋag₃ Rag₅₄: “A₂dsɨ₂jó'₃ juá'₅ jniá₂, ca₂le₃jë́₃ a₂dse₃ a₂'ua₁ 'au'₂ 'nia'₂ ca₂jmo'₅₄ ja₁con₂ le₂jan₂ le₂jan₂ rɨ́ng'₃ la₂ i₂jɨ́n₂ dsa₂ mɨ₂güɨ́g₃ 'uɨn₃, o₄quió₃ jniá₂ bá₄ a₂ca₂jmo'₅₄ 'nia'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Jaun₂ juá'₂ táng₃ Rag₅₄ tsɨ́'₃ i₂tión₂ të₂le₃ gu₂ jen₅: “Jŋia'₃ 'nia'₂ ja₁con₂ jniá₂, 'nia'₂ i₂tiong'₅₄ 'éi'₃ o₁nóg'₅ dsi₂si₂ ja₁tsá₃ ton₅ jmɨg₄ éi₃, ja₁lë́₄ co₂jŋia₅₄ quió'₅ i₂së₃dsen₃ quian'₅₄ ángeles quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ia₁ ca₂ŋɨ₃ jniá₂ i₁cón₅, 'nia'₂ në́₃ tsá₃ 'e₂ ca₂cuë'₅₄ a₂guë'₅₄; ca₂ŋɨ₃ rë₂quein₂ dsɨ₃ i₁guɨ'₄ jmɨg₂, tsá₃ 'e₂ jmɨg₂ ca₂cuë'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ca₂ŋɨ₃ jniá₂ 'no₂₃ ja₁jan₁₂, tsá₃ ja₁ca₂cuë'₅₄ 'nia'₂ jan₅₄. Ca₂ŋɨ₃ 'ɨn₂ tsɨ́n'₅, tsá₃ 'e₂ tsɨ́n'₅ ca₂cuë'₅₄ 'nia'₂. Ca₂tsán₂ dsong₅₄, jme₁ca₂'ú₃ né'₃ 'má₃ në́₃, tsá₃ ca₂i₁jag'₄ 'nia'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jaun₂ në́₃, ŋag₃ dsa₂ 'éi₂: “Te₁gui'₅₄, ¿lɨ́g'₂ bá₄ jaun₂ ca₂né₄ jnia'₅₄ 'ne₂ a₂ŋɨ'₂ i₁cuang'₃, o₃ rë₂quein₂ 'au'₂ o₃ ca₂ŋɨ'₅₄ 'náu'₂ ja₁jan'₄, o₃ ca₂ŋɨ'₅₄ tsá₃ tsɨ́n'₂ cha₂ quɨ'₅₄, o₃ jme₁ca₂rë₃dsong'₅₄, o₃ lia'₂ con'₂ ca₂'ú'₃ né'₃ 'má₃, tsá₃ ca₂jme₁'o₁ jnia'₅₄?” ");
INSERT INTO cntNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jaun₂ ŋag₃ Rag₅₄: “A₂dsɨ₂jó'₃ juá'₅ jniá₂, ca₂le₃jë́₃ a₂dse₃ a₂tsá₃ ca₂jmo'₅₄ 'nia'₂ ja₁con₂ le₂jan₂ le₂jan₂ rɨ́ng'₃ la₂ i₂jɨ́n₂ dsa₂ mɨ₂güɨ́g₃ 'uɨn₃, o₄quió₃ jniá₂ bá₄ tsá₃ 'e₂ ca₂jmo'₅₄ 'nia'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jaun₂ dsa₂ 'éi₂ dsɨ₃léin₂ ja₁dsɨ₃ŋag₅₄ uɨg₅ co₂tan₅₄, la₁ dsa₂ dsen₃ në́₃, dsɨ₃lein₅ ja₁le₃chain₂ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jme₁ca₂dsan₃ juá'₂ Jesús ca₂le₃jë́₃ jág₁ në₅, jaun₂ ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ");
INSERT INTO cntNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ma₂ŋi'₅₄ 'nia'₂ jaun₂, a₂tɨn₃ jmɨg₄ në₃ te₅₄ Jmɨg₄ Të₂'ɨn₅₄, ja₁jáng'₂ dsa₂ jɨ́in'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ a₂tion₃ ne₄ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jaun₂ në́₃, juɨg₅₄ jme₂dsa₂, quian'₅₄ të₅juá'₅, dsa₂ can'₅₄ quián₅ dsa₂ judíos në́₃, ca₂ŋɨi'₂ i₁dsi₅ ne₄ta₁ quió'₅ i₂lɨ́n₅ jme₂dsa₂ dsen₅₄, i₂chen₂ Caifás. ");
INSERT INTO cntNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ja₁jaun₂ ca₂quɨin₃ jág₁ quió'₅ a₂jmo₃ të₂le₃ quian'₅₄ caun₂ mai₅₄ ia₁jaun₂ cuɨn₃ jmɨg₄ tsáun'₂, jaun₂ jŋang'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jaun₂ tioin'₅₄ ca₂dsia₃ jág₁ ca₂juá'₂: ―La₁ tsá₃ 'nió'₅ jmó₁ jniog₄ të₃ niog₅ jmɨg₄, jme₁né₄, ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ ca₂tó'₂ dsa₂ juɨg₂ mɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Lia'₂ con'₂ 'en₅₄ guë́₄ Jesús juɨg₂ Betania ja₁quió'₄ i₂të́'₂ dsa₂ Si₂mu₅₄ 'mé'₅ 'iog₅, ");
INSERT INTO cntNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","jaun₂ ca₂dsióg₃ jan₂ 'io₅₄ quian₅ caun₂ tsɨ́₅ no'₅₄ mɨ₂juɨg₂ a₂'mu'₅₄. Jme₁ma₂guá₅ Jesús ne₄ mesa guë́'₅, jaun₂ ca₂'ág₂ 'io₅₄ 'éi₂ no'₅₄ mɨ₂juɨg₂ mɨ₂dsi₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jme₁ca₂jág₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ a₂jaun₂, tsá₃ dse₃ ca₂tɨ́in₂, jaun₂ ca₂tsɨ́'₃ rɨin'₅₄ tioin'₅₄: ―Tsá₃ ne₄ 'e₂ lë₃ në₂'éin₂ a₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Jua'₅₄ co₂ŋei'₅₄ bá₄ në₂'nag₃ ia₁jaun₂ jme₁jme₂'oin₅₄ dsa₂ te₂ŋé₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jme₁ca₂nág₂ Jesús jág₁ a₂dsia₂₃ tioin'₅₄, jaun₂ ca₂juá'₂: ―¿'E₂ lë₃ cuë'₂ 'nia'₂ o₂me'₅₄ dsɨ₅ 'io₅₄ la₂? A₂në₂jmóg'₂ la₂ caun₂ a₂dse₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ca₂le₃jë́₃ jmɨg₄ bá₄ i₂nio₄ dsa₂ te₂ŋé₂ jɨn'₄ 'nia'₂, la₁ jniá₂ në́₃ tsá₃ ma₃uë́₂ 'en₅₄ jniá₂ quian'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Juɨ₁lia'₂ no'₅₄ mɨ₂juɨg₂ a₂në₂tsáng₂ nɨ₁ŋɨ₃, jua'₂ a₂ma₂në₂jmóg'₂ co₂jŋia₅₄ jë₁ma₂të́₂ rë₁'ong₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, ca₂le₂con₂ mɨ₂güɨ́g₃ ja₁'ë́₂ dsa₂ jág₁ dse₃ quió₃, ján₃ bá₄ le₂jaun₂ dsiog'₂ dsɨ́₅ dsa₂ 'ɨin₃ 'io₅₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jaun₂ në́₃, jan₂ i₂lɨ́n₅ dsa₂ guia₃-tɨ́n₂, i₂chen₂ Judas Iscariote, ŋei₅₄ i₁dsia₂ jág₁ quian'₅₄ juɨg₅₄ jme₂dsa₂, ");
INSERT INTO cntNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","jaun₂ ca₂i₁jua'₄: ―¿Je₂liá'₂ cuë́'₁ 'nia'₂ në₁jua'₂ jɨn'₄ jniá₂ Jesús o₄gog'₂? Jaun₂ në́₃, ca₂quí₃ juɨg₅₄ jme₂dsa₂ guióg₂-guiá₂ 'éi'₃ cu₄tiog₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jaun₂ në́₃ të₃ne₄ juɨ₅ ja₁ŋó₄ jaun₂, ca₂'náu'₃ Judas dsɨ́₅ 'a₂ lia'₂ cuɨn₃ jmɨg₄ jɨ́in'₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jmɨg₄ le₂'uɨg₅₄ a₂niog₅ Jmɨg₄ Të₂'ɨn₅₄ a₂guë́'₅ dsa₂ i₁ŋí'₄ a₂tsá₃ quian'₅₄ levadura, chi'₂ dsɨ₂guia₃-tɨ́n₂ në́₃ ca₂jme₃quiáin₃ ja₁con₂ Jesús ca₂ŋag₃: ―¿A₂já'₄ 'niog'₂ dsɨ₁jmó₁ jnia'₅₄ co₂jŋia₅₄ má₃ Jmɨg₄ Të₂'ɨn₅₄ quiáng'₂? ");
INSERT INTO cntNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jaun₂ ca₂juá'₂ Jesús: ―O₂nó'₅ 'nia'₂ jë₄ juɨg₂, ja₁quió'₄ jan₂ dsa₂, jaun₂ juɨg'₅₄ 'nia'₂: “Le₂la₂ juá'₂ të₅: Ma₂ja₂quián₃ hora quió₃, jaun₂ ja₁quiáng'₂ i₁guë'₃ Jmɨg₄ Të₂'ɨn₅₄ co₂lë₅ quian'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáng₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jaun₂ në́₃ i₃lén₂ bá₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, jaun₂ ca₂jmo₃ con'₂ lë́₅ jág₁ ca₂juá'₂ Jesús. Jaun₂ ca₂tóin'₂ ca₂jmo₃ co₂jŋia₅₄ a₂guë́'₃ Jmɨg₄ Të₂'ɨn₅₄ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jme₁ca₂nei₂ jaun₂, jme₁ma₂guá₅ Jesús ne₄ mesa co₂lë₅ quiain'₅₄ ta₁guia₃-tɨ́n₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Të₃jë₄ tiáin'₄ guë́'₅ jaun₂, ca₂juá'₂ Jesús: ―A₂dsɨ₂jó'₃ juá'₅ jniá₂, jan'₂ 'nia'₂ i₂'en₅₄ jë₄ la₂ bá₄ i₂jáng'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jaun₂ në́₃ ca₂tá'₂ 'lia'₂ dsɨ́₅ 'ŋio₅ lɨn₃ bá₄ tiáin'₅, jaun₂ ca₂jme₃lióg₃ ca₂ŋɨ́i'₃ Jesús le₂jain₂ le₂jain₂ ca₂juá'₂: ―Te₁gui'₅₄, ¿On₁jua'₅₄ jniá₂ 'ág'₅? ");
INSERT INTO cntNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jaun₂ ca₂ŋag₃ Jesús: ―I₂tiá₂ gu₂ co₂lë₅ 'ŋió'₃ uɨng₅ quian'₅₄ jniá₂, i₂'éi₂ bá₄ i₂jáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dsón'₂ bá₄ dsau₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃ 'ein₅₄ juɨ₅ lia'₂ con'₂ lë́₅ juá'₂ ne₄ Si₂; la₁ ¡'e₂ guë́₄ juɨ́g₂ dsa₂ i₂jáng'₂! Dse₃ quió'₅ jua'₅₄ co₂ŋei'₅₄ bá₄ tsá₃ ca₂rë₃cháin₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jaun₂ në́₃ Judas, dsa₂ i₂ma₂lë́₂ dsɨ́₅ jáng'₂, ca₂juá'₂: ―Të₅, ¿On₁ jniá₂ bá₄ 'ág'₅ 'ne₂? Jaun₂ ca₂ŋag₃ Jesús: ―'Ŋiag'₂ bá₄ ma₂në₂jua'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Të₁lia'₂ tiáin'₅ guë́'₅, ca₂jŋa'₃ Jesús i₁ŋí'₄, ca₂cuë́'₃ ti₁'mag'₄ Diú₄, jaun₂ guë́₄ ca₂dsioin₃, ca₂cuë́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂juá'₂: ―Qué'₂ 'nia'₂, ia₁ ŋɨ₃ bá₄ jniá₂ i₁ŋí'₄ la₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jaun₂ ca₂can₃ táng₃ copa 'a₄ vino, ján₃ bá₄ le₂jaun₂ ca₂cuë́'₃ ti₁'mag'₄ Diú₄, jaun₂ guë́₄ ca₂cuë́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂, jaun₂ ca₂juá'₂: ―'Én'₂ 'nia'₂ ca₂le₃jɨ́ng'₃ a₂la₂, ");
INSERT INTO cntNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ia₁ jmɨ₃ bá₄ jniá₂ la₂, a₂lɨ'₅₄ jág₁ 'mɨ́₂ a₂të₃ron₅₄, a₂niog₅ dsɨ₃'o₅₄ o₄quió'₄ juɨn₅ dsa₂, ia₁jaun₂ 'én₂ dsáu₁. ");
INSERT INTO cntNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Dsón'₂ juá'₅ jniá₂, tsá₃ ma₃lɨ́g'₂ jmɨg₄ jua'₅₄ a₂guɨ'₅₄ guë́₄ táng₃ vino ca₂lia'₂ ca₂të́₂ jmɨg₄ i₁guɨ'₄ táng₃ caun₂ vino 'mɨ́₂ co₂lë₅ quian'₅₄ 'nia'₂ ja₁gon₂ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jme₁ca₂lë₃ 'ë₂₃ jme₂juɨin'₂ Diú₄, jaun₂ guë́₄ i₃léin₂ juɨ₅ Má'₂ Olivos. ");
INSERT INTO cntNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―Ca₂le₃jɨ́n'₃ bá₄ 'nia'₂ tiá'₃ jén₂ 'au'₂ o₄quió₃ jniá₂ a₂'uë₂ në₃, 'ág'₁ 'nia'₂ caun₂-tɨn₃ 'au'₂; ia₁ rë₂ton₅ ne₄ Si₂, juá'₂: “Jŋɨ́'₄ jniá₂ dsa₂ i₂jŋia₅ já'₂ cha'₂, jaun₂ já'₂ cha'₂ në́₃ dsɨ₃léin₂ tsɨ₁rë₂jain₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","La₁ cang₂ jë₁ma₂ca₂jeng'₅₄ táng₃, nei₅₄ jniá₂ jŋiág₅ juɨ₅ Galilea lia'₂ con'₂ guë́₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jaun₂ në́₃ ca₂ŋag₃ Pe₄: ―O₁jŋia'₅₄ la₂ ca₂'ág₂ caun₂-tɨn₃ dsɨ́₅ ca₂le₃jɨ́n₃ rɨ́ng'₃, la₁ jniá₂, o₁lɨ́g'₂ jmɨg₄ tsá₃ 'ag₅₄ caun₂-tɨn₃ dsɨ₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jaun₂ ca₂juá'₂ Jesús: ―A₂dsɨ₂jó'₃ juá'₅ jniá₂, a₂'uë₂ në₃, né'₃ a₂'o₃ të₁guí₄ dsó₂, hora jaun₂ dé₄ dsón'₂ chéng'₅ tsá₃ tóng'₄ ta₁'nɨ₅ ráun₂ a₂cuɨg'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Jaun₂ ca₂ŋag₃ táng₃ Pe₄: ―O₁jŋia'₅₄ la₂ ca₂dsau₃ jniog₄ co₂lë₅, o₁lɨ́g'₂ jmɨg₄ jua'₅₄ a₂tsá₃ 'ɨ́n₄ jniá₂ 'ne₂. Le₂jaun₂ bá₄ ca₂juá'₂ ca₂le₃jɨ́n₃ rɨin'₅₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jaun₂ ca₂dsióg₃ Jesús jme₁ca₂dsióg₃ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ caun₂ ja₁chei₂ Getsemaní, jaun₂ ca₂juá'₂: ―Ja₁lá₃ tián'₂ 'nia'₂ të₁lia'₂ nei₅₄ jó₄ i₁chi₁leng'₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jaun₂ ca₂jŋiai₃ Pe₄, quian'₅₄ le₃on₃ ja₁ŋi'₅₄ Zebedeo, jaun₂ Jesús në́₃ ca₂tá'₂ quian₅ o₂i₁ dsɨ₅ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ i₂ún₂ i₂quiain'₅₄: ―'Ŋio₅ lɨn₃ quian₅₄ o₂i₁ dsɨ₅, ca₂lia'₂ jmá'₃ le₃jóng₂ të₂në₃. Ja₁lá₃ tián'₂ 'nia'₂, jme₁jnio₂ 'nia'₂ ne'₅₄, jme₁quiong'₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ca₂juɨg₄ bá₄ ca₂ŋó₃ guë́₄ ne₄ juɨ₅. Ja₁jaun₂ ca₂lia'₂ ca₂i₃'ɨ́in₃ chi₁'ɨn₅ ne₅₄ ca₂të₂ 'uë₃, ca₂mɨ₃ ca₂tsɨ́'₃ Diú₄, ca₂juá'₂: ―Tia₅₄ quiáng₃, jua'₅₄ mei'₂ bá₄ lé₂ le₃lé₂, lio₄ jniá₂ jmɨ₁uɨg₅ la₂. La₁ tsá₃ juɨ₁le₅₄ con'₂ 'nio₃ jniá₂, juɨ₁le₅₄ bá₄ a₂'ŋio₂ 'au'₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jaun₂ në́₃, ca₂nau₂ Jesús, jaun₂ ca₂ŋái'₃ ja₁tián'₄ i₂ún₂ i₂quiain'₅₄, la₁ ma₂le₁güɨ́n₃ bá₄ guë'₂ 'éi₂ tiáin'₅; jaun₂ ca₂të́'₃ Pe₄, ca₂juá'₂: ―¿Tsa₁ ma₃tian'₃ guë́₄ 'nia'₂ jua'₅₄ caun₂ hora bá₄ jme₁jnio'₂ guë́₄ 'nia'₂ ne'₅₄ quian'₅₄ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jme₁jnio₂ 'nia'₂ ne'₅₄, chi₁len'₄ 'nia'₂ Diú₄, ia₁jaun₂ tsá₃ tsɨ₃sén'₂ 'nia'₂. Dsón'₂ bá₄ jaun₂ 'ŋio₂ bá₄ dsɨ́₅ jme₂dsí₂ quián'₂ 'nia'₂, la₁ nɨ₁ŋɨ'₁ guion'₅₄ bá₄ 'nia'₂ 'uan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A₂ca₂të́₂ tɨn₃ ráun₂ ŋó₃ táng₃ i₁chi'₄ Diú₄ le₂la₂: ―Tia₅₄ quiáng₃, chi₂jua'₂ tsá₃ lé₂ jua'₅₄ a₂tsá₃ jme₁ŋag₅₄ jniá₂ uɨg₅ la₂, juɨ₁le₅₄ bá₄ a₂'ŋio₂ 'au'₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jaun₂ ca₂guáin'₃ táng₃ ja₁tián'₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, la₁ le₁güɨ́n₃ bá₄ táng₃ 'éi₂ tiáin'₅, ia₁ a₂ŋɨ́₄ lë₃ ma₂i₁güɨ́in₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jaun₂ ŋó₃ bá₄ táng₃ jë₁ca₂të́₂ 'nɨ₅ ráun₂, a₂chi₂i₁lein'₄ Diú₄; ján₃ bá₄ le₂jaun₂ ca₂juá'₂ tsɨ́'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jaun₂ guáin'₃ në́₃ ja₁tián'₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, jaun₂ ca₂juá'₂: ―¿'E₂? ¿Lia'₂ ma₂tián'₅ jaun₂ bá₄ 'nia'₂ le₁güɨ́ng'₃? Ŋí₂ 'nia'₂, ca₂të́₂ bá₄ hora në́₃. Ma₂rë₂jɨn'₅₄ bá₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃ o₄gú₃ dsa₂ i₂le₁cán'₄ dso₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nau₂ 'nia'₂ në́₃, ma₃; ia₁ në₅ ma₂já₅ i₂jáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Të₃jë₄ dsia₂₃ jág₁ jaun₂, jme₁ca₂dsióg₃ Judas, i₂lɨ́n₅ jan₂ dsa₂ i₂guia₃-tɨ́n₂. Juɨn₅ lɨn₃ dsa₂ i₂ja₂lén₂ quiong'₅₄ qui₂le₁quian₅ ŋi₁tág₂, i₂le₁quian₅ nɨ₁'ma₂ në́₃, i₂chen₄ quián₅ juɨg₅₄ jme₂dsa₂ quian'₅₄ dsɨ₂gui'₅₄ can'₅₄ quián₅ dsa₂ juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jaun₂ Judas në́₃, ia₁ ma₂ca₂jmo₃ bá₄ jág₁ le₂jŋiá₅ 'e₂ léi₄ jmo₃ jë₁ma₂të́₂ rë₁jáng'₂, jme₁ma₂juá'₂: ―I₂chen'₄ jniá₂ quió'₅, i₂'éi₂ bá₄ jma'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jaun₂ dsɨ₂juɨ₅ jme₁dsióg₃ Judas, ca₂jme₃quiáin₃ con₂ Jesús, jaun₂ ca₂juá'₂: ―¡Siang'₃, të₅! Jaun₂ ca₂chen'₃ rë₂jú'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jaun₂ ca₂jéin'₃ Jesús jág₁ quió'₅, ca₂juá'₂: ―A₂mei₅₄, ¿'E₂ ta₁ ŋɨ'₂? Jaun₂ guë́₄ ca₂jme₃quián₃ ca₂le₃jɨ́n₃ dsa₂ ca₂jŋai'₃ Jesús, jaun₂ ca₂tág₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Të₃jë₄ jaun₂, jan₂ dsa₂ i₂jme₁quian'₅₄ Jesús ca₂dsi₂ ŋi₁tág₂, ca₂ti₃ caun₂ rë₂gua₄ dsa₂ i₂jme₂ti₃ quián₅ jme₂dsa₂ dsen₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jaun₂ ca₂juá'₂ Jesús: ―Tiá₃ táng₃ ŋi₁tág₂ quiáng'₂ ja₁jme₁'i₄. Ia₁ ca₂le₃jɨ́n₃ i₂quɨ́n'₂ quian'₅₄ ŋi₁tág₂, ján₃ bá₄ quian'₅₄ ŋi₁tág₂ dsiáin₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿'E₂ lɨ́ng'₂? ¿A₁tsá₃ lé₂ le₃jme₁mɨ₁₂ ne₄ Ŋe'₃, a₂chein₃ ja₁cong₂ guia₃-tɨ́n₂ mei₅ ángeles quiáin₅? ");
INSERT INTO cntNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","La₁ jua'₅₄ mei'₂ guë́₃ le₂jaun₂, ¿'A₂ bá₄ lia'₂ le₃ti₃ jág₁ a₂tio'₅₄ ne₄ Si₂ ja₁juá'₂ a₂dsɨ₃ŋɨ́g₂ le₂la₂? ");
INSERT INTO cntNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jaun₂ juá'₂ Jesús tsɨ́'₅ dsa₂: ―¿'E₂? ¿Ja₁nó'₅ 'nia'₂ le₁quian'₅₄ ŋi₁tág₂, nɨ₁'ma₂, ja₂chong'₂ jniá₂, në₂jag₄ bá₄ lɨ́ng₅ dsa₂ 'ang₂? Jua'₂ ca₂le₃jë́₃ jmɨg₄ bá₄ 'eng₅₄ jme₁tɨ́ng₂ dsa₂ jɨn'₄ 'nia'₂ i₁dsi₅ guá'₅ templo, tsá₃ ma₂chong'₂ guë'₂ 'nia'₂ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","La₁ ca₂le₃jë́₃ a₂lë́₂ la₂ rë₂ti₃ jág₁ quió'₅ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂. Jaun₂ guë́₄ qui₂ca₂cuɨng₃ ca₂le₃jɨ́n₃ chi'₂ dsɨ₂guia₃-tɨ́n₂, ca₂téin₂ bá₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jaun₂ dsa₂ i₂ca₂i₁chan'₅₄ Jesús ca₂i₁jo₅₄ ne₄ Caifás, i₂lɨ́n₅ jme₂dsa₂ dsen₅₄. Ja₁jaun₂ ma₂le₁ŋɨ'₂ të₅juá'₅ quian'₅₄ guë́₄ dsa₂ can'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pe₄ në́₃ ca₂ŋó₃ uɨ́ng₂ të₂quɨ́in₃ 'ein₂₃ Jesús ca₂të₂ i₁dsi₅ quió'₅ jme₂dsa₂ dsen₅₄. Ja₁jaun₂ ca₂'í₃ ca₂guá₂ quiain'₅₄ 'lióg₂, ia₁ 'nio₃ të₅ ne₅₄ 'a₂ lia'₂ jŋia'₅₄ dsióg₄ quian'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jaun₂ juɨg₅₄ jme₂dsa₂, quian'₅₄ ca₂le₃jɨ́n₃ dsɨ₂tan₅₄ quián₅ guá'₅ në́₃, qui₂ca₂'náu'₃ juɨ₅ 'a₂ lia'₂ jme₃cáin'₂ Jesús dso₄ quian'₅₄ jág₁ të₂jág₁ ia₁jaun₂ jŋag'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","La₁ tsá₃ dso'₂ guë'₂ 'a₂ lia'₂ jme₃cáu'₂, o₁jŋia'₅₄ juɨn₅ i₂qui₂ca₂nau₂ jmo₂₃ jág₁ të₂jág₁. Dsi₃lén₂ jme₁dsi₃lén₂ on₃ dsa₂, ");
INSERT INTO cntNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","jaun₂ ca₂juá'₂: ―I₂në₅ ma₂ca₂juá'₂, “Quɨ'₅₄ jniá₂ jmɨg₄ lé₂ le₃'éng₄ guá'₅ templo quió'₅ Diú₄, quian'₅₄ 'nɨ₅ jmɨg₄ bá₄ lé₂ le₃jmóg'₄ táng₃.” ");
INSERT INTO cntNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jaun₂ ca₂nau₂ jme₂dsa₂ dsen₅₄, jaun₂ ca₂tsɨ́'₃ Jesús: ―¿Tsa₁ 'e₂ ŋag'₅₄ 'i₁caun₂? ¿I₂'e₂ bá₄ jág₁ në₅ a₂jáng'₅ dsa₂ a₂rë₂cáng'₄? ");
INSERT INTO cntNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","La₁ tei₄ bá₄ ca₂nau₂ Jesús. Jaun₂ ca₂ŋag₃ táng₃ jme₂dsa₂ dsen₅₄, ca₂juá'₂: ―Dsi₅₄ jniá₂ 'éi'₃ a₂jua'₅₄ 'ɨ́ng'₅ Diú₄ jén'₃ ne₄ jnia'₅₄, chi₂jua'₂ të₃dsón'₂ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄, I₂rë₂'ɨ́n₁ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jaun₂ ca₂ŋag₃ Jesús: ―Ján₅, jniá₂ bá₄ 'éi₂, juɨ₁lia'₂ i₁juá'₂ 'ne₂ në₅. La₁ juá'₅ jniá₂ juɨ́g₂ 'nia'₂ ján₃, ca₂le₃jɨ́ng'₃, a₂já₅ jmɨg₄ a₂jag'₅₄ 'nia'₂ jɨng'₅₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃ guá₃ të₂le₃ gu₂ ne₁ Diú₄ i₂'uan'₂ guë́₄ lɨn₃, a₂jŋiói'₂ jë₄ jnei₅ guei'₅₄ dsi₂güɨg₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jme₂dsa₂ dsen₅₄ në́₃, jme₁ca₂nág₂ jág₁ jaun₂, ca₂chein₃ nɨ₁tsɨn'₅₄ 'ŋiog₅, jaun₂ ca₂juá'₂: ―¡'E₂ guë́₄ 'ŋio₅ 'lɨg'₅₄ juá'₂ i₂në₅ 'ɨin₂₃ Diú₄ quian'₅₄ jág₁ në₅ quió'₅! ¿'E₂ guë́₄ jmá'₃ jág₁ 'lióng₂ 'niog₂ jniog₄ jua'₅₄ a₂jáng'₅ guë́₄ dsa₂ sián'₂ jág₁ dsau₅? Ma₂në₂nei'₂ bá₄ 'nia'₂ guiong'₅₄ jág₁ 'lɨg'₅₄ a₂ma₂në₂juá'₂ i₂në₅ 'ɨin₂₃ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿'A₂ lia'₂ lɨ́n'₂ 'nia'₂? Jaun₂ ca₂juá'₂ ca₂le₃jɨ́in₃ tioin'₅₄: ―I₂ca₂tɨ́n₂ jón₂ bá₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jaun₂ qui₂ca₂'ŋéi₃ dsa₂ dsɨ₂ne₄ Jesús tioin'₅₄, tsá₃ caun₂ a₂qui₂ca₂jmóg'₂. I₂lɨn₅₄ guë'₂ qui₂ca₂quein₃ tioin'₅₄, ");
INSERT INTO cntNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","jaun₂ ca₂juá'₂: ―'Ne₂ guë'₂ i₂juá'₂ lɨ́ng'₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄: ¡Dsi₄ jág₁ jua'₅₄ 'ein₂ në₂quein₃ quiáng'₂! ");
INSERT INTO cntNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Të₃jë₄ jaun₂ jme₁guá₄ Pe₄ i₁dsi₅; jaun₂ ca₂dsióg₃ jan₂ 'io₅₄ i₂jme₂ti₃ ta₁ ja₁jaun₂, jaun₂ ca₂tsɨ́'₃ Pe₄: ―¿Ján₃ guë'₂ jme₁quian'₄ 'ne₂ Jesús i₂chan₂ Galilea? ");
INSERT INTO cntNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","La₁ jɨn₄ dsa₂ ja₁guá₄ jaun₂ tsá₃ ca₂tioin₃, jaun₂ ca₂juá'₂: ―Tsá₃ guion₅₄ 'e₂ a₂juá'₂ 'ne₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ca₂nau₂ Pe₄ ŋó₅ të₂le₃ o₄'né₄, jaun₂ ca₂jág₂ táng₃ jan₂ 'io₅₄ sián'₂. 'Éi₂ në́₃ ca₂tsɨ́'₃ dsa₂ i₂tion'₅₄: ―I₂jme₁quian'₅₄ Jesús Nazareno bá₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","La₁ jme₁ca₂nág₂ Pe₄, tsá₃ ca₂tioin₃ táng₃ jë́₃ 'ɨin₂₃ Diú₄, ca₂juá'₂: ―¡Tsá₃ dsa₂ 'éi₂ cuɨ́n₅ jniá₂! ");
INSERT INTO cntNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jme₁co₂lág₂ jaun₂, ca₂jme₃quián₃ dsa₂ i₂tion'₅₄ con₂ Pe₄, jaun₂ ca₂juá'₂: ―Të₃dsón'₂ bá₄ lɨ́ng'₅ jan₂ rɨn'₅₄ 'éi₂, ia₁ në₅ rë₂jniág'₂ 'a₂ lia'₂ né'₂ jag'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jaun₂ në́₃, Pe₄ ca₂'ɨin₃ Diú₄ ca₂mɨ₃ a₂dsɨ₃ŋɨ́i₂ 'e₂ dsɨ₃ŋɨ́i₂, ca₂juá'₂: ―¡Tsá₃ dsa₂ 'éi₂ cuɨ́n₅ jniá₂! Të₃jë₄ jaun₂ ca₂'o₃ jan₂ të₁guí₄ dsó₂. ");
INSERT INTO cntNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jaun₂ guë́₄ në́₃ ca₂dsáu'₃ dsɨ́₅ Pe₄ a₂ca₂juá'₂ Jesús le₂jŋiá₅: “Né'₃ a₂'o₃ të₁guí₄ dsó₂; hora jaun₂ dé₄ dsón'₂ chéng'₅ tsá₃ tóng'₄ ta₁'nɨ₅ ráun₂ a₂cuɨg'₂ jniá₂.” Jaun₂ guë́₄ o₂'ɨ́n₃ Pe₄ të₂le₃ ca₁'né₄, ca₂tá'₂ quɨ'₂ dsɨ́₅, ca₂'o₃ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Jme₁jnia₃ jaun₂, ca₂le₃jɨ́n₃ juɨg₅₄ jme₂dsa₂ quian'₅₄ gui'₅₄ can'₅₄ quián₅ dsa₂ juɨg₂ ca₂jmo₃ caun₂ jág₁ a₂jŋɨi'₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Qui₂ca₂'néi₂ tioin'₅₄, jaun₂ ca₂tág₃ ca₂i₁jang'₂ ne₄ Dsi₄má'₂ Poncio Pilato. ");
INSERT INTO cntNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jme₁ma₂të₅ ne₄ Judas i₂ca₂'nag₃, a₂ma₂në₂dsí₃ dsa₂ 'éi'₃ a₂jŋɨi'₃ Jesús, jaun₂ ca₂tá'₂ quɨ'₂ dsɨ́₅. Jaun₂ ca₂i₁con₂ táng₃ ta₁guiog₃-guiá₂ 'éi'₃ cu₄tiog₂ jaun₂, ca₂jɨ́in'₃ juɨg₅₄ jme₂dsa₂ quian'₅₄ gui'₅₄ can'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Jaun₂ ca₂juá'₂: ―Ma₂në₂'no₃ jniá₂ dso₄, ia₁ në₂jɨng'₅₄ ne₄ 'mú₃ jan₂ i₂tsá₃ dso₄ rɨn₂. La₁ ca₂ŋag₃ dsa₂ 'éi₂: ―Tsá₃ 'e₂ a₂jaun₂ dsan₂ dsɨ₅ jnia'₅₄. A₂ca₂tɨ́n'₂ 'ne₂ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Con'₂ ca₂i₁guia'₂ jaun₂ bá₄ Judas cu₄ jaun₂ dsi₂néi₂ ja₁jŋió₅ guá'₅ templo, jaun₂ ca₂o₃'ɨ́in₃ ca₂i₁tiá₄ ché₂ dsɨ₂lag₅₄ ca₂jŋɨi'₃ 'ŋiog₅. ");
INSERT INTO cntNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Juɨg₅₄ jme₂dsa₂ në́₃ ca₂i₁cag'₂ cu₄ jaun₂, jaun₂ ca₂juá'₂: ―Tsá₃ 'i₄ 'éi'₃ dsɨ₃to'₅₄ cu₄ la₂ 'ŋió'₃ gu₅ ja₁tio'₅₄ cu₄ quió'₅ guá'₅, ia₁ cu₄ a₂ca₂quɨ́n₂ jmɨ₂ bá₄ la₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jaun₂ ca₂jmo₃ caun₂ jág₁ a₂lá₃ caun₂ 'uë₃ quian'₅₄ cu₄ jaun₂ quió'₅ jan₂ dsa₂ i₂jme₁jmo₅ nɨ₁dsɨg₁ gua'₅₄, ja₁jmo₃ 'uë₃ ja₁'óin₂ jmá'₃ lia'₂ dsɨ₂nau₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","'Uɨg₅₄ jaun₂ chei₂ ja₁jaun₂ ca₂të₂ jmɨg₄ në₃, 'Uë₃ Jmɨ₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Le₂në₅ ca₂rë₃ti₃ jág₁ a₂ca₂juá'₂ Jeremías, dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂, jme₁ca₂juá'₂: “Ca₂can₃ dsa₂ guióg₂-guiá₂ cu₄tiog₂, con'₂ 'ma'₅₄ a₂ca₂dsi₂ dsa₂ juɨg₂ Israel quió'₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Quian'₅₄ cu₄ jaun₂ ca₂lá₃ caun₂ 'uë₃ quió'₅ dsa₂ i₂jmo₅ nɨ₁dsɨg₁, lia'₂ con'₂ lë́₅ 'éi'₃ quió'₅ Te₁gui'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Të₁lia'₂ jaun₂, chén'₅ Jesús ne₄ dsi₄má'₂, jaun₂ 'éi₂ në́₃ ca₂ŋag₃: ―¿Dsón'₂ lɨ́ng'₅ Rag₅₄ quián₅ dsa₂ judíos? Jaun₂ ca₂ŋag₃ Jesús: ―Le₂në₅ bá₄, juɨ₁lia'₂ juá'₂ 'ne₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jaun₂ caun₂ qui₂ca₂'nag₃ bá₄ juɨg₅₄ jme₂dsa₂ quian'₅₄ gui'₅₄ can'₅₄ tioin'₅₄. La₁ tsá₃ ma₃'e₂ ca₂ŋag₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jaun₂ ca₂juá'₂ Pilato: ―¿Tsa₁ nag'₂ ca₂le₃jë́₃ 'e₂ i₁juá'₄ dsa₂ në₅ 'nɨi₂₃ 'ne₂? ");
INSERT INTO cntNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","La₁ tsá₃ ma₃'e₂ ca₂ŋag₃ Jesús 'i₁caun₂; jaun₂ ca₂i₃gó'₃ dsɨ́₅ Pilato. ");
INSERT INTO cntNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jmɨg₄ jaun₂ jme₁chí'₄ tag₄ quió'₅ dsi₄má'₂ a₂lióin₂ ca₂le₃jë́₃ ŋi₂, jan₂ dsa₂ i₂'en₅₄ né'₃ 'má₃, jme₁të₅ Jmɨg₄ Të₂'ɨn₅₄, 'ein₂ ca₂'ɨn₃ dsa₂ juɨg₂ i₂lión₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jmɨg₄ jaun₂ jme₁rë₂jnɨ́₅ jan₂ dsa₂ i₂chen₂ Barrabás, ca₂le₂con₂ bá₄ 'ei₅ jág₁ quió'₅ a₂'lɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Të₃jë₄ le₁ŋɨ'₂ dsa₂ jaun₂, ca₂ŋag₃ Pilato ca₂ŋɨ́i'₃ dsa₂ juɨg₂: ―¿I₂'ein₂ 'niog'₂ 'nia'₂ lon₄ jniá₂ quián'₂ 'nia'₂? ¿Barrabás, o₃ Jesús i₂të́'₂ dsa₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ia₁ ca₂rë₃lí'₄ bá₄ Pilato 'ŋiog₅, a₂'iog₅₄ uɨg₅ dsɨ́₅ bá₄ dsa₂ ca₂jɨ́in'₂ Jesús ne₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Të₁lia'₂ guá₅ Pilato ne₄ta₁ quió'₅, ja₁qui₂dsɨ₂₃ 'éi'₃, të₃jë₄ jaun₂ ca₂chen₃ 'io₅₄ quiáin₅ jág₁ ne₅₄ a₂ca₂juá'₂: “Tsá₃ lë₁tián₅ 'ne₂ cuente quió'₅ dsa₂ i₂tsá₃ 'e₂ rɨn₂ në₅. Ia₁ 'ŋio₅ gau₂ qui₂chóg₂ i₃ŋɨ́g₂ ca₂néi₃ o₄quió'₄.” ");
INSERT INTO cntNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","La₁ juɨg₅₄ jme₂dsa₂ quian'₅₄ gui'₅₄ can'₅₄ në́₃, ca₂toin'₂ jág₁ dsa₂ juɨg₂ ia₁jaun₂ mɨ₃ dsa₂ tsɨ́'₃ Pilato a₂lióin₂ Barrabás bá₄, jaun₂ jŋɨi'₃ bá₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jaun₂ ca₂juá'₂ Pilato ca₂tsɨ́'₃ dsa₂: ―¿I₂'ein₂ dsa₂ on₃ la₂ 'niog'₂ 'nia'₂ lon₄ jniá₂? Jaun₂ ca₂ŋag₃ dsa₂ juɨg₂ tioin'₅₄: ―Barrabás bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jaun₂ ca₂ŋag₃ táng₃ Pilato ca₂ŋɨ́i'₃ dsa₂ juɨg₂: ―¿'E₂ guë'₂ 'niog'₂ 'nia'₂ jmo₅₄ jniá₂ quian'₅₄ Jesús i₂të́'₂ dsa₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄? Jaun₂ ca₂ŋag₃ co₂dsia₅ ca₂le₃jɨ́in₃ tioin'₅₄: ―¡Tióin₃ cróg₄! ");
INSERT INTO cntNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Jaun₂ ca₂ŋag₃ táng₃ Pilato: ―¿'E₂ 'uɨg₅₄ në́₃? ¿'E₂ guë'₂ dso₄ ma₂'náu₂? La₁ të₂le₃ i₂juɨ'₂ guë́₄ co₂mɨ'₅₄ ca₂tóin'₂, ca₂juá'₂: ―¡Tióin₃ cróg₄! ");
INSERT INTO cntNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","La₁ ca₂rë₃lí'₄ bá₄ Pilato tsá₃ 'e₂ ta₁ jmo₃ jág₁ quió'₅, ia₁ të₂le₃ 'ŋio₅ lɨn₃ guë́₄ juɨ₁si co₂mɨ'₅₄ ca₂tóin'₂. Jaun₂ lë₃, ca₂chein₃ jan₂ dsa₂ i₁quian₅₄ jmɨg₂, jaun₂ ca₂rang₃ gu₂ të₃ne₄ dsa₂ juɨg₂, jaun₂ ca₂juá'₂: ―Tsá₃ 'e₂ rë₃cán'₄ jniá₂ jmɨ₄ dsa₂ në₅; guion'₅₄ bá₄ 'nia'₂ rë₂cáng'₄ në₁'e₂ ca₂jmai'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jaun₂ ca₂ŋag₃ ca₂le₃jɨ́n₃ dsa₂ juɨg₂ tioin'₅₄: ―¡Jmɨ₄ 'mú₃ quió'₅ i₂në₅, juɨ₁dsi₂ŋag₂ jnia'₅₄ 'e₂ dsɨ₃ŋág₂, quian'₅₄ tsɨ₁jon₂ quián₂ jnia'₅₄ i₂në₃ guë́₄ të₁ja₃lén₂! ");
INSERT INTO cntNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jaun₂ ca₂lión₂ bá₄ Pilato Barrabás i₂mɨ₅ dsa₂ lión₂; jaun₂ ca₂jmo₃ 'éi'₃ a₂bán₂ dsa₂ Jesús, jaun₂ guë́₄ ca₂jáng'₂ o₄gú₃ dsa₂ juɨg₂ jaun₂ tion₃ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jme₁co₂lág₂ jaun₂, 'lióg₂ quián₅ dsi₄má'₂ ca₂jŋiai₃ Jesús juɨ₅ i₁dsi₅ ne₄ta₁ jaun₂. Jaun₂ ca₂ŋɨ'₂ ca₂le₃jɨ́n₃ 'lióg₂ le₃lág'₃ quió'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jaun₂ guë́₄ ca₂dsi₂ tsɨn'₅₄ Jesús, ca₂quei'₃ caun₂ tsɨ₁'mɨ'₂ guéin₂ 'uɨ'₃, ");
INSERT INTO cntNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","jaun₂ ca₂jmo₃ caun₂ corona quian'₅₄ chi₁uɨ́ng₃ taun₅, ca₂tó'₂ mɨ₂dsi₄ Jesús. Ca₂chong'₂ ca₂'nau₅₄ guë'₂ nɨ₁'ma₂ ta₅ gu₂ ne₁. Jaun₂ guë́₄ ca₂chi₃jné₃ ne₄ Jesús tioin'₅₄, a₂lë₁qui₂co₂jmóg'₂, ca₂juá'₂: ―¡Sian'₃ 'ne₂, Rag₅₄ quián₅ dsa₂ judíos! ");
INSERT INTO cntNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ján₃ qui₂ca₂'ŋéi₂ dsa₂, qui₂ca₂bá₂ dsa₂ mɨ₂dsi₅₄ quian'₅₄ nɨ₁'ma₂ a₂ca₂chong'₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jme₁ca₂lë₃ a₂lë₁co₂jmóg'₂ jaun₂, ca₂dsei₂₃ táng₃ tsɨ₁'mɨ'₂ 'uɨ'₃ a₂jme₁ca₂quei'₃, jaun₂ ca₂quei'₃ táng₃ nɨ₁tsɨn'₅₄ a₂jme₁qui'₂. Jaun₂ guë́₄ ca₂jiog₃ ca₂të₂ ja₁të₃toin₅₄ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","A₂ca₂'uɨin₂ jaun₂, ca₂jein'₂ jan₂ dsa₂ i₂chan₂ Cirene, i₂chen₂ Si₂mu₅₄. Jaun₂ ca₂chi₃quiáin₂ jmɨg₄ 'éi₂ a₂cán₂ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jaun₂ ca₂dsi₃léin₂ jme₁dsi₃léin₂ caun₂ ja₁chei₂ Gólgota, co₂'nió'₄ ja₁të́'₂ dsa₂ Dsɨ₂con'₂ Nɨ₁mu₅ Mɨ₂dsi₄ 'Lag₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ja₁jaun₂ ca₂jén'₃ dsa₂ ne₄ Jesús vino a₂rë₃cón'₅ quian'₅₄ dsɨ́'₁ já'₂; la₁ dsɨ₂juɨ₅ jme₁ca₂tí₂ Jesús 'o₅₄, tsá₃ ma₃ca₂'ɨn'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jme₁ca₂lë₃ tion₂₃ cróg₄, 'lióg₂ në́₃ ca₂jmo₃ dsióg₁ tsɨn'₅₄ Jesús, ca₂co₃ o₁ne₄ 'ein₂ lí'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ja₁jaun₂ ca₂tiáin'₂ jmo₂₃ 'í₁. ");
INSERT INTO cntNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dsi₄ cróg₄ ca₂tióng₃ dsa₂ letra ja₁juá'₂ 'e₂ dso₄ a₂bóin'₂ Jesús, a₂juá'₂ le₂la₂: “I₂LA₂ BÁ₄ JESÚS, I₂LƗ́N₅ RAG₅₄ QUIÁN₅ DSA₂ JUDÍOS”. ");
INSERT INTO cntNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ján₃ bá₄ ca₂tioin₃ guë́₄ on₃ dsa₂ 'ang₂ co₂lë₅ quiong'₅₄, jan₂ të₂le₃ gu₂ ne₁, jan₂ guë'₂ të₂le₃ gu₂ jen₅. ");
INSERT INTO cntNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jaun₂ ca₂le₃jɨ́n₃ dsa₂ i₂qui₂ca₂ŋɨ́₃ juɨ₅ jaun₂ qui₂ca₂jnáu'₂ jág₁ uɨg₅, qui₂bí₂ dsi₅₄, ");
INSERT INTO cntNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ca₂juá'₂: ―'Ne₂ guë'₂ i₂juá'₂ a₂'éng'₄ guá'₅, con'₂ siá'₂ tɨng'₂ jmog'₅₄ táng₃ quian'₅₄ 'nɨ₅ jmɨg₄, në₃ në́₃, lion₄ 'ŋiag'₂. Sión₅ ja₁tong'₂ në₅, chi₂jua'₂ dsón'₂ 'ne₂ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ján₃ bá₄ le₂jaun₂ a₂lë₁qui₂co₂jmóg'₂ juɨg₅₄ jme₂dsa₂ quian'₅₄ të₅juá'₅, gui'₅₄ can'₅₄ në́₃, dsia₂₃ jág₁ qui₂tsɨ́'₅ rɨin'₅₄, juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ca₂lióin₂ bá₄ i₂sián'₂, la₁ 'ŋiog₅ bá₄ tsá₃ lé₂ le₃lióin₂. Chi₂jua'₂ i₂në₅ lɨ́n₅ Rag₅₄ quián₅ dsa₂ juɨg₂ Israel, juɨ₁sióin₄ cróg₄ ia₁jaun₂ bá₄ le₃'éin₂ jniog₄ le₃quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I₂në₅ guë'₂ juá'₂ 'ei₅ caun₂ dsɨ́₅ ne₄ Diú₄; në₃ në́₃ 'éi₂ juɨ₁lio₅₄ chi₂jua'₂ të₃dsón'₂ bá₄ 'nioi₃ i₂në₅; ia₁ 'ŋiog₅ guë'₂ ma₂juá'₂ lɨ́in₅ Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Le₂jiog₅ dsa₂ 'ang₂ i₂le₁ton₅ quian'₅₄ Jesús qui₂ca₂juá'₂ uɨg₅. ");
INSERT INTO cntNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jme₁ca₂të́₂ dsi₂ŋí'₃, ca₂'ág₂ nei₂ le₂tan₅₄ le₂con₂ 'uë₃ jaun₂ ca₂lia'₂ ca₂të́₂ hora ŋí₁ 'nɨ₅ të₂le₃ ca₂'láu₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Hora jaun₂, ca₂'ŋia₂ guë́₄ Jesús, jág₁ ca₂juá'₂ tiá₂: ―Elí, Elí, ¿lama sabactani? ―co₂'nió'₄ a₂juá'₂: Diú₄ quiáng₃, Diú₄ quiáng₃, ¿'e₂ lë₃ ma₂në₂téi'₃ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","I₂lɨn₅₄ dsa₂ i₂jme₁tión₂ cau₅ jaun₂ ca₂nág₂, jaun₂ ca₂dsia₃ jág₁ tsɨ́'₅ rɨin'₅₄: ―Nei₂ 'nia'₂. Elías, i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂, të́'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jaun₂ dsɨ₂juɨ₅ le₂jaun₂ ŋó₃ jan₂ co₂chi'₅₄ i₁quian₅₄ caun₂ nɨ₁jau₂ guion₅ jmɨg₂. Jaun₂ ca₂guioin₃ vino dsi'₃, jaun₂ ca₂chi₃dsí₂ nei'₅₄ caun₂ nɨ₁'ma₂ ta₅, jaun₂ ca₂jén'₃ ne₄ Jesús ia₁jaun₂ jme₁'ɨ́n'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","La₁ ca₂juá'₂ rɨin'₅₄: ―Tsá₃ lein'₅₄; o₁ne₄ chi₂jua'₂ jiá₃ Elías ja₃lio₅₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Con'₂ bá₄ ca₂'ŋióg₂ guë́₄ Jesús tiá₂ lɨn₃, jaun₂ guë́₄ ca₂jáng'₃ jme₂dsí₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hora jaun₂ dé₄ dsón'₂ co₂dsia₅ ca₂chen₃ ca₂të₂ guei'₅₄ ca₂të₂ 'uë₃ ca₂lë₃ tɨn₃ tsɨ́n'₅ tsɨ₁'mɨ'₂ pa₁ a₂jme₁'ei₅ dsi₂néi₂ guá'₅ templo. 'Uë₃ guë'₂ në́₃ ca₂i₁bi₅₄, nɨ₁'lau₂ a₂te₁'i₁ ja₁jaun₂ qui₂ca₂dsón₂; ");
INSERT INTO cntNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","tau₂ 'ŋio₅ në́₃ qui₂ca₂niá₃ ca₂lë₃; ján₃ bá₄ qui₂ca₂jen'₅₄ juɨn₅ 'lag₄ jŋió₅ quián₅ Diú₄ i₂ma₂dsan₃ le₂jŋiá₅. ");
INSERT INTO cntNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Qui₂ca₂'uɨin₂ tau₂ 'ŋio₅; ca₂i₃toin'₅₄ Jerusalén ciudad jŋió₅ jme₁ca₂jen'₅₄ Jesús, ton'₂ ca₂jme₃jniai₂₃ në́₃ ne₄ juɨn₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jaun₂ juɨg₅₄ 'lióg₂ quian'₅₄ guë́₄ dsa₂ i₂jme₁quiain'₅₄ jmo₂₃ 'í₁ Jesús, jme₁ma₂të₅ ne₅₄ dsɨ₂bi₅₄ 'uë₃ ma₂lë́₂ ca₂le₃jë́₃ guë́₄ 'e₂ a₂ca₂lë₃ jaun₂, jaun₂ guë́₄ ca₂rë₃gó'₅ 'ŋio₅ lɨn₃; jaun₂ guë́₄ ca₂juá'₂: ―Të₃dsón'₂ bá₄ jme₁lɨ́n₄ i₂në₅ Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jme₁tion'₅₄ juɨn₅ 'io₅₄ ja₁jaun₂ jág₅, tióin₂ uɨ́ng₂. 'Éi₂ ma₂ja₂léin₂ jme₂ti₃ ne₄ Jesús le₂tan₅₄ 'uë₃ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jɨn₄ 'io₅₄ 'éi₂ jme₁'en₅₄ María i₂chan₂ Magdala, quiain'₅₄ María chog₅₄ Jacobo quian'₅₄ Së́₄; quian'₅₄ chog₅₄ chi'₂ quián₅ Zebedeo. ");
INSERT INTO cntNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jme₁ca₂tó'₂ nei₂ jmɨg₄ jaun₂, guan₃ jan₂ dsa₂ cha₂ cu₄ i₂chen₂ José, i₂chan₂ juɨg₂ Arimatea, ia₁ ján₃ bá₄ ca₂rë₃'éin₂ le₃quió'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","'Éi₂ në́₃, ŋei₅₄ i₂jɨin₁₂ Pilato, ca₂i₁mɨi'₄ 'lag₄ Jesús. Jaun₂ ca₂jmo₃ Pilato 'éi'₃ a₂jáng'₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jaun₂ në́₃ ca₂tág₃ Së́₄, ca₂lio₃ rë₂ quian'₅₄ caun₂ tsɨ₁'mɨ'₂ le₁jë́₃. ");
INSERT INTO cntNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jaun₂ ca₂i₁tio'₂ 'ŋió'₃ caun₂ tau₂ 'ŋio₅ 'mɨ́₂ quió'₅ 'ŋiog₅, a₂jme₁ma₂guéi₃ dso'₂ nɨ₁'lau₂. Jaun₂ ca₂jŋiói'₃ ca₂mɨ́g₂ nɨ₁cang₁ lɨ'₂ pa₁, ca₂jlë́₂ 'o₄ tau₂ 'ŋio₅, jaun₂ guë́₄ ca₂ŋái'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","La₁ María i₂chan₂ Magdala quiain'₅₄ María jan₂ 'éi₂, jaun₂ bá₄ jme₁tiáin'₄ të₂le₃ ja₁jniá₂ o₄'né₄ tau₂ 'ŋio₅. ");
INSERT INTO cntNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jme₁jnia₃ táng₃ jaun₂, co₂'nió'₄ jme₁ca₂dsan₃ tion'₅₄ dsa₂ jmo₂₃ co₂jŋia₅₄ a₂'nió'₅ quió'₅ jmɨg₄, jaun₂ ca₂i₁len₅₄ juɨg₅₄ jme₂dsa₂ quian'₅₄ dsa₂ fariseos në́₃ ca₂ŋɨi'₂ ne₄ Pilato, ");
INSERT INTO cntNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ca₂i₁jua'₄: ―Gui'₅₄, dsáu'₅ dsɨ₅ jnia'₅₄, a₂ca₂juá'₂ të₂jág₁ 'éi₂ lia'₂ con'₂ jme₁chain₂ guë́₄, a₂jein'₅₄ táng₃ a₂'nɨ₅ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","'Uɨg₅₄ jaun₂, chen₅ 'lióg₂ juɨ₁dsi₂jmó₂ 'í₁ tau₂ 'ŋio₅ ca₂lia'₂ ca₂të́₂ jmɨg₄ 'nɨ₅, ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ ja₂lén₂ dsa₂ i₂jme₁quiain'₅₄ të₂, jaun₂ táun₂ jág₁ cang₂, lé₂ le₃juá'₂: “Ma₂ca₂jein'₅₄ bá₄ táng₃.” Ia₁ në₁jua'₂ ca₂lë₃ le₂jaun₂, ja₂lɨn₃ guë́₄ juë'₂ lé₂ jág₁ të₂jág₁ jë₁ca₂tó'₂ në₅, con'₂ guë́₄ jág₁ të₂jág₁ le₂'uɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jaun₂ ca₂juá'₂ Pilato: ―Në₅ tión₂ co₂nió'₃ i₂në₅. O₂nó'₅ 'nia'₂ quiain'₅₄, o₂jmo₄ 'nia'₂ 'í₁ 'a₂ con'₂ jŋia'₅₄ tian'₃ 'nia'₂ jmó'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jaun₂ ca₂i₃léin₂ jaun₂ në́₃, i₁jmo₅₄ 'í₁ dse₃ lɨn₃ tau₂ 'ŋio₅, ca₂tióng₃ caun₂ sello dso'₂ nɨ₁cang₁ a₂chi₁jnɨ₅, jaun₂ ca₂chein'₃ co₂nió'₃ 'lióg₂ i₂jmo₃ 'í₁. ");
INSERT INTO cntNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ca₂ŋɨ́₂ bá₄ jmɨg₄ sa₅₄. Jaun₂ në́₃, të₂le₃ ca₂jnia₃ jmɨg₄ le₂'uɨg₅₄ semana, ca₂ŋe₄ María i₂chan₂ Magdala quiain'₅₄ María jan₂; ca₂i₁lein₅₄ i₁jag₅₄ tau₂ 'ŋio₅ quió'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Con'₂ tsá₃ rë₂jáin₁ dsɨ₂juɨ₅ le₂jaun₂ ca₂i₁bi₅₄ 'uë₃ tiá₂ lɨn₃ ia₁ a₂ca₂sión₃ guei'₅₄ i₂juɨ́g₃ jan₂ ángel quián₅ Te₁gui'₅₄. Ca₂të₁tsɨin'₅₄ o₄'né₄ tau₂ 'ŋio₅, ca₂mói₂ nɨ₁cang₁ a₂jme₁chi₁jnɨ₅, jaun₂ ca₂guá₂ ne₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ca₂lia'₂ tág₅ 'ŋio₅ lɨn₃ jniái₂ juɨ₁lia'₂ tág₅ si₁ŋí'₃. Tsɨn'₅₄ a₂qui'₂ guë'₂ tiog₂ jau₂ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jme₁ca₂jág₂ 'lióg₂ i₂tion'₅₄ jmo₅ 'í₁, ca₂rë₃gó'₅ 'ŋio₅ lɨn₃ ca₂jlein₃ në₂jag₄ bá₄ tsá₃ dsɨ́₅ chan₂ ca₂jén'₃. ");
INSERT INTO cntNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jaun₂ ca₂juá'₂ ángel ca₂tsɨ́'₃ 'io₅₄: ―Tsá₃ jmo₂ 'nia'₂ gang'₃. Ia₁ guion₄ jniá₂ a₂'na'₂ Jesús i₂ca₂tion₃ dsa₂ cróg₄ bá₄ 'nia'₂ i₂niog'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tsá₃ 'éi₂ ma₃chan₂ ja₁lá₃; ma₂ca₂jein'₅₄ bá₄ táng₃ juɨ₁lia'₂ lë́₅ ca₂juá'₂ 'ŋiog₅. La₂ i₂jag₄ de'₂ 'nia'₂ ja₁jme₁rë₂quiain₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","O₂nó'₅ 'nia'₂ i₂ŋáu'₂ o₂chei'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ a₂ma₂ca₂jein'₅₄ táng₃ ne₄ 'mú₃; ma₂'ein₅₄ juɨ₅ ŋó₅ jŋiái₅ lia'₂ con'₂ guë́₄ 'nia'₂ juɨ₅ Galilea. Ja₁jaun₂ o₁jɨin'₄ 'nia'₂. Jág₁ në₅ ma₂në₂juɨ́g₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jaun₂ në́₃ ca₂'uɨn₂ 'io₅₄ i₂ŋáu'₂, të₃ ma₂gó'₅, ton'₂ jén'₅ rë'₂ 'io'₂ ján₃. Jaun₂ ca₂i₃lein₃ co₂chi'₅₄ i₁con₂ jág₁ ne₄ dsa₂ guia₃-tɨ́n₂. ");
INSERT INTO cntNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Të₃jë₄ i₂lein₃ jaun₂, con'₂ tsá₃ jáin₅ ca₂jme₃jnia₅ Jesús ne₅₄, ca₂juá'₂: ―¡Siang'₃! Jaun₂ në́₃ ca₂jme₃quiáin₃ con₂ Jesús, ca₂chi₃jné₃ ca₂jmo₃ i₁'áin₃ ca₂të₂ 'uë₃, ca₂quɨ́'₃ cu₅ tag₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús në́₃ ca₂juá'₂: ―Tsá₃ lë₁jmo₂ 'nia'₂ gang'₃. O₂nó'₅ 'nia'₂ o₂con₄ jág₁ ne₄ rɨ́ng'₃ o₂chei'₅₄ 'nia'₂ juɨ₁dsi₂lein₅ juɨ₅ Galilea, jaun₂ ja₁jaun₂ jág₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Të₁lia'₂ i₃len₃ 'io₅₄ 'éi₂ i₂con₃ jág₁, i₂lɨn₅₄ 'lióg₂ i₂jme₁jmo₅ 'í₁ i₃lein₃ jë₄ juɨg₂ i₁con₂ jág₁ ne₄ juɨg₅₄ jme₂dsa₂ ca₂i₁jua'₄ ca₂le₃jë́₃ 'a₂ lia'₂ niog₅ ca₂lë₃. ");
INSERT INTO cntNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Juɨg₅₄ jme₂dsa₂ në́₃ ca₂ŋɨi'₂ quian'₅₄ gui'₅₄ can'₅₄ ca₂jmo₃ jág₁, jaun₂ ca₂cuë́'₃ 'lióng₂ cu₄ 'lióg₂ 'éi₂, ");
INSERT INTO cntNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ca₂juá'₂: ―Le₂la₂ dsiá'₁ 'nia'₂ juɨg'₅₄ dsa₂: të₁lia'₂ jme₁rë₂güɨ́n'₃ 'nia'₂ a₂'uë₂ ca₂dsi₃lén₂ dsa₂ i₂jme₁quiain'₅₄, jaun₂ ca₂tág₃ 'lag₄. ");
INSERT INTO cntNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Në₁jua'₂ ca₂rë₃ŋi₅ dsi₄má'₂ jág₁ në₅, la₂ bá₄ ne₄ jnia'₅₄ 'a₂ lia'₂ jme₁'uan₅₄ dsɨ́₅ ia₁jaun₂ tsá₃ cán'₁ 'nia'₂ o₂i₁ dsɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jaun₂ ca₂gue₃ bá₄ 'lióg₂ cu₄, jaun₂ le₂jaun₂ bá₄ ca₂jmo₃ con'₂ lë́₅ jág₁ ca₂to'₂ dsa₂ 'éi₂. Jaun₂ le₂në₅ bá₄ jág₁ 'ei₅ ca₂le₂con₂ le₁ŋi₅ dsa₂ judíos ca₂të₂ jmɨg₄ në₃. ");
INSERT INTO cntNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jaun₂ në́₃ i₃len₃ bá₄ ta₁guia₃-ján₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ juɨ₅ Galilea, ca₂i₃léin₂ ja₁lë́₄ caun₂ má'₂, lia'₂ con'₂ lë́₅ ma₂ca₂juá'₂ Jesús le₂jŋiá₅. ");
INSERT INTO cntNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jaun₂ dsɨ₂juɨ₅ jme₁ca₂jɨ́in₂ Jesús, ca₂chi₃jné₃ ca₂jmo₃ i₁'áin₃, la₁ i₂lɨn₅₄ në́₃ tsá₃ caun₂ jme₁ma₂le₁'ág₄ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jaun₂ ca₂jme₃quián₂ Jesús ja₁tióin₂, jaun₂ ca₂juá'₂: ―Ca₂le₃jë́₃ bí₂ 'éi'₃ lia'₂ guei'₅₄ i₂juɨ́g₃ lia'₂ ne₄ gua'₅₄ 'uë₃ në́₃ ma₂ca₂ŋɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jaun₂ lë₃, o₂nó'₅ 'nia'₂ në́₃ ca₂le₂con₂ mɨ₂güɨ́g₃, o₂jme₁tɨn₅ 'nia'₂ dsa₂ a₂léin₂ dsa₂ quiáng₃, o₂qui₂o₂chon₄ 'nia'₂ dsa₂ jmɨg₂, lia'₂ con'₂ lë́₅ 'éi'₃ quió'₅ Ŋe'₃, quian'₅₄ lia'₂ con'₂ lë́₅ 'éi'₃ quió'₅ Ja₁ŋi'₅₄, quian'₅₄ lia'₂ con'₂ lë́₅ 'éi'₃ quió'₅ Jme₂dsí₂ Jŋió₅, ");
INSERT INTO cntNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","o₂jme₁tɨin₅ 'nia'₂ a₂nag₃ gau₂ ca₂le₃jë́₃ 'éi'₃ a₂ma₂cuë́₃ jniá₂ 'nia'₂. Jaun₂ ŋi'₅₄ 'nia'₂ në́₃, la₂ bá₄ 'eng₅₄ quian'₅₄ 'nia'₂ ca₂le₃jë́₃ jmɨg₄, ca₂lia'₂ ca₂'ŋia₅ jmɨg₄ jë₁ca₂tó'₂. Co₂në₅.");
INSERT INTO cntNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Le₂la₂ bá₄ ca₂rë₃lióg₃ jág₁ dse₃ quió'₅ Jesucristo, Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Juɨ₁lia'₂ lë́₅ tio'₅₄ ne₄ si₂ quió'₅ dsa₂ i₂jme₁'ë́₂ jág₁ quián₂ Diú₄ ma₂lɨ́g'₂, ja₁juá'₂ le₂la₂: Tsɨng₅₄ jan₂ dsa₂ quiáng₃ ne₄ juɨ₅ quiáng'₂, jón₃, a₂dsɨ₃can₅ jág₁ dse₃ jɨn₄ dsa₂ mɨ₂güɨ́g₃, jaun₂ jmo₃ co₂jŋia₅₄ juɨ₅ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jaun₂ né'₂ 'ë́₂ dsa₂ 'éi₂ jág₁ co₂mɨ'₅₄ caun₂ 'uë₃ quein₂ co₂'ŋiog₅, jaun₂ i₂'éi₂ juá'₂: “Jmo₄ 'nia'₂ co₂jŋia₅₄ juɨ₅ quió'₅ Te₁gui'₅₄ i₂jiá₃. Nia₄ 'nia'₂ caun₂ juɨ₅ co₂dsau₅.” ");
INSERT INTO cntNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jaun₂ le₂la₂ ca₂rë₃ti₃ jág₁ në₅: Ca₂guan₃ Juan₅₄ caun₂ ja₁lë́₄ 'uë₃ co₂'ŋiog₅ ca₂choin₃ jmɨg₂ dsa₂, qui₂ca₂'ë́₂ jág₁ a₂tsón₃ dsa₂ jmɨg₂, jë₁ma₂ca₂dsi₃quén'₅ dsɨ́₅ ia₁jaun₂ le₃'én₂ dsáu₁. ");
INSERT INTO cntNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jaun₂ ca₂le₃jɨ́n₃ dsa₂ chan₂ juɨg₂ Judea quian'₅₄ dsa₂ i₂chan₂ Jerusalén në́₃, ca₂i₁lein₅₄ ja₁jme₁'en₅₄ Juan₅₄. Qui₂ca₂jmo₃ dsa₂ qui₂ŋí₃ quió'₅ ca₂le₃jë́₃ dsáu₁. Jaun₂ guë́₄ ca₂cho₃ Juan₅₄ jmɨg₂ Cuá₃ Jordán. ");
INSERT INTO cntNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nɨ₁tsɨn'₅₄ Juan₅₄ 'éi₂ jme₁lë́₄ quian'₅₄ nɨ₁jŋí₁ já'₂ camello. A₂jme₁jén'₅ tú'₅ guë'₂ në́₃, lo₄ já'₂. Má₃ a₂jme₁guë́'₅ guë'₂, jmá'₃ i₁nɨ'₂ tia₄ quian'₅₄ jmɨ₁tá'₄ cha₂ ja₁nau₂. ");
INSERT INTO cntNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Caun₂ ca₂ŋɨ₃ bá₄ 'ë́₂ jág₁ dse₃, juá'₂: ―I₂jiá₃ chi₁co'₅₄ quió₃, i₂'éi₂ bá₄ i₂'uan'₂ i₂tɨn₂ guë́₄ lia'₂ con'₂ guë́₄ jniá₂, ca₂lia'₂ jŋia'₅₄ lau₂ ton₅ tag₅₄ tsá₃ ca₂tɨ́ng₂ tsɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jniá₂ në₂tiáng₃ 'nia'₂ jmɨg₂; la₁ 'éi₂ guë'₂ në́₃ tióg₂ Jme₂dsí₂ Jŋió₅. ");
INSERT INTO cntNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jmɨg₄ jaun₂ o₂'ɨ́n₃ Jesús juɨg₂ Nazaret, ja₁tén₄ Galilea. Ŋó₃ ja₁'en₅₄ Juan₅₄. Ja₁jaun₂ ca₂cho₃ Juan₅₄ jmɨg₂ ca₂choin₃ Jesús Cuá₃ Jordán. ");
INSERT INTO cntNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jaun₂ dsɨ₂juɨ₅ jme₁ca₂'ŋio₂ Jesús ne₄ jmɨg₂, ca₂jág₃ ca₂niá₃ dsɨ₄ mɨ₂güɨ́g₃. Jaun₂ ca₂sión₃ Jme₂dsí₂ quián₅ Diú₄ i₂lɨ́n₅ lia'₂ lɨ́n₅ jan₂ i₁ju₂, ne₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jaun₂ ca₂né'₂ jág₁ a₂já₅ guei'₅₄ i₂juɨ́g₃ a₂juá'₂: ―'Ne₂ bá₄ lɨ́ng'₅ jón₃ quiáng₃, i₂ŋɨ́₄ lë₃ 'nióg₃ guë́₄ lɨn₃; 'E₂ bá₄ 'ŋio₂ dsɨ₃ quian'₅₄ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dsɨ₂juɨ₅ jaun₂ ca₂jiog₃ Jme₂dsí₂ quián₅ Diú₄ caun₂ juɨ₅ 'uë₃ co₂'ŋiog₅. ");
INSERT INTO cntNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jaun₂ ja₁jaun₂ ca₂'í₃ të₂láu₃ jmɨg₄ ia₁jaun₂ cáun₂ táu₂ i₂së₃dsen₃. Ja₁jaun₂ jme₁tion'₅₄ já'₂ tsau₂ dsɨ́₅. La₁ ca₂o₃lén₂ ángeles ca₂jme₃'o₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jme₁ma₂ca₂ton'₂ dsa₂ Juan₅₄ né'₃ 'má₃, Jesús në́₃ ca₂ŋei₅₄ juɨ₅ Galilea i₁'ë́₄ jág₁ dse₃ quió'₅ Diú₄, ");
INSERT INTO cntNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","juá'₂ ŋɨ₂₃: ―Ca₂dsɨn₃ jmɨg₄ a₂ja₂quián₃ a₂jme₃gón₃ Diú₄. Jaun₂ lë₃ juɨ₁dsi₂quén'₅ 'au'₂, juɨ₁le₂'én'₂ 'nia'₂ jág₁ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Co₂ráun₂ ca₂ŋɨ₅ Jesús chei'₅₄ jmɨ₁ŋí'₄ Galilea. Ja₁jaun₂ ca₂jɨ́in₂ Si₂mu₅₄ quiain'₅₄ Drë́₄ rɨin'₅₄. Jme₁tioin'₅₄ táun₂ 'má₅ dsi₂jmɨg₂, ia₁ jme₁lɨ́in₄ dsa₂ i₂jmo₅ ta₁ tsán'₂ ju₄. ");
INSERT INTO cntNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jaun₂ ca₂juá'₂ Jesús: ―I₂nó'₅ 'nia'₂, jme₁quiong'₅₄ jniá₂, jaun₂ cuë₅₄ ta₁ a₂chi₁liang'₂ dsa₂ mɨ₂güɨ́g₃, juɨ₁lia'₂ chi₂lián'₁ 'nia'₂ ju₄. ");
INSERT INTO cntNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jaun₂ dsɨ₂juɨ₅ bá₄ i₃léin₂ quiong'₅₄; ja₁jaun₂ ca₂dsia₃ bá₄ tsɨ₁'má₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Me'₂ bá₄ ja₁i₃léin₂ guë́₄ jme₁ca₂jɨ́in₂ i₂chen₂ Jacobo quiain'₅₄ Juan₅₄ rɨin'₅₄, ja₁ŋi'₅₄ Zebedeo. Jme₁tioin'₅₄ 'ŋió'₃ tsɨ₁mu₅ jmóg'₅ 'má₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Dsɨ₂juɨ₅ ca₂të́'₃ i₂'éi₂ ján₃; ca₂tén₂ bá₄ guë'₂ 'éi₂ në́₃ Zebedeo jmei₂ 'ŋió'₃ tsɨ₁mu₅ quian'₅₄ mozo quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jaun₂ dsi₃léin₂ juɨg₂ Capernaum. Caun₂ jmɨg₄ sa₅₄, ca₂'í₃ Jesús guá'₅ sinagoga. Jaun₂ ca₂jme₃lióg₃ ca₂jme₃tɨin₂₃ dsa₂ jág₁ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ca₂le₃jɨ́n₃ i₂ca₂nág₂ në́₃ ca₂i₃gó'₃ dsɨ́₅ jág₁ quió'₅, ia₁ ca₂jme₃tag₂₃ juɨ₁lia'₂ jë₁jme₂tag₅ jan₂ i₂'io₅ 'éi'₃, on₃jua'₅₄ rë'₂ juɨ₁lia'₂ jme₂tag₅ të₅juá'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jë₄ jaun₂ ca₂dsióg₃ jan₂ dsa₂ i₂'en₅₄ jme₂dsí₂ 'lɨn'₅₄, ca₂juá'₂ guió'₅ tiá₂: ");
INSERT INTO cntNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿'E₂ lë₃ tián'₅ 'ne₂ Jesús Nazareno jë₄ quián₂ jnia'₅₄? A₂jŋia'₅₄ 'niog'₂ 'éng'₄ jnia'₅₄ bá₄ 'ne₂ ŋe'₃. Guion₄ jniá₂ 'ein₂ lɨ́ng'₅. 'Ne₂ lɨ́ng'₅ dsa₂ jŋió₅ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jaun₂ ca₂jén₂ Jesús i₂'lɨn'₅₄ i₂'en₅₄ të₂dsɨ́₅ dsa₂ 'éi₂, ca₂juá'₂: ―Tei₄ jmo₄. Jú₅ quió'₅ dsa₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jaun₂ ca₂jmo₃ i₂'lɨn'₅₄ ca₂ba₂ca₂lɨ́n'₂ dsa₂ 'éi₂ 'uë₃, ca₂guió'₃ tiá₂. Jaun₂ guë́₄ o₂'ɨ́in₃ jaun₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jaun₂ ca₂le₃jɨ́n₃ dsa₂ i₂ca₂të́₂ ne₄ ca₂i₃gó'₃ dsɨ́₅, qui₂ca₂ŋɨ́i'₃ rɨin'₅₄, ca₂juá'₂: ―¿'E₂ bá₄ në₅? ¿'An₁ a₂në₅ bá₄ juá'₅ 'mɨ́₂? ¡'Io₅ 'éi'₃ i₂në₅ ca₂të₂ ne₄ quió'₅ i₂'lɨn'₅₄, jaun₂ 'éi₂ në́₃ nag₂₃ gau₂ jág₁ quió'₅! ");
INSERT INTO cntNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jaun₂ dsɨ₂juɨ₅ bá₄ ca₂i₃'ág₃ jág₁ quió'₅ ca₂le₂con₂ ja₁tén₄ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jaun₂ dsɨ₂juɨ₅ jme₁ca₂'uɨin₂ guá'₅, ca₂ŋó₃ quiain'₅₄ Jacobo, Juan₅₄ në́₃, ja₁quió'₄ Si₂mu₅₄ quian'₅₄ Drë́₄. ");
INSERT INTO cntNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ma₂chog₅₄ Si₂mu₅₄ në́₃ jme₁roin₂₃ dso'₅₄, 'i₄ dséi₂. Jaun₂ dsɨ₂juɨ₅ ca₂'ɨn₃ dsa₂ dsa₂ dso'₅₄ 'éi₂ ca₂tsɨ́'₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jaun₂ në́₃ ca₂jme₃quiáin₃ con₂ dsa₂ dso'₅₄, ca₂jŋa'₃ gu₂, ca₂chó'₂ jaun₂ në́₃. Jaun₂ dsɨ₂juɨ₅ bá₄ ca₂o₃'ág₃ dséi₂ dsa₂. Jaun₂ 'io₅₄ 'éi₂ në₃ ca₂jme₃lióg₃ ca₂jme₃ti₃ ta₁ ne₄ 'éi₂ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jme₁ma₂rɨn₂ 'iog₂ jmɨg₄ jaun₂, ca₂o₃jŋia₃ dsa₂ ne₅₄ ca₂le₃jɨ́n₃ dsa₂ dso'₅₄, dsa₂ i₂tion'₅₄ jme₂dsí₂ je₂na'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ca₂le₃jɨ́n₃ dsa₂ juɨg₂ bá₄ ca₂ŋɨ'₂ o₄'né₄. ");
INSERT INTO cntNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jaun₂ Jesús në́₃ ca₂jme₃'lióin₂ dsa₂ ca₂le₃jë́₃ ne₅₄ dso₄ a₂jme₁lɨ́in₄. Qui₂ca₂'uɨ́in'₂ rë'₂ juɨn₅ je₂na'₅₄ në́₃. La₁ tsá₃ ma₃ca₂cuë₃ Jesús jmɨg₄ jua'₅₄ a₂juá'₂ guë́₄ je₂na'₅₄ jág₁, ia₁ ŋi₅ bá₄ je₂na'₅₄ 'ein₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Le₁né₃ guë́₄ jme₁jnia₃ jaun₂, ca₂nau₂ Jesús o₂'ɨ́in₃ 'nɨ'₂ juɨg₂, caun₂ ja₁lë́₄ co₂'ŋiog₅, i₁chi'₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jaun₂ ŋó₃ Si₂mu₅₄ quiain'₅₄ rɨin'₅₄ i₁'niong'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jme₁ca₂dsáu'₂ në́₃, ca₂juá'₂: ―Ca₂le₃jɨ́n₃ dsa₂ i₂nioi₅₄ 'nai'₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","La₁ Jesús në́₃ ca₂ŋag₃: ―Ma₃dsau₅₄ dsɨ₂i₁nio₁ le₂tan₅₄ juɨg₂ ma₂quián₅ në₅, dsɨ₁'ë́₄ jág₁ dse₃, ia₁ ta₁ jaun₂ bá₄ guio₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jaun₂ le₂në₅ ca₂i₁ŋɨ₂ Jesús le₂tan₅₄ juɨg₂ tio'₅₄ ja₁tén₄ 'uë₃ Galilea, qui₂i₁'ë́₄ jág₁ dse₃ dsi₂néi₂ guá'₅ sinagogas le₂caun₂ juɨg₂. Qui₂ca₂'uɨ́in'₂ je₂na'₅₄ të₂dsɨ́₅ dsa₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ca₂guan₃ jan₂ dsa₂ dso'₅₄ i₂lɨ́n₅ 'mé'₅ 'iog₅ coin₂. Jaun₂ ca₂chi₃jné₃ ne₅₄, ca₂juá'₂: ―Chi₂jua'₂ 'ŋio₂ 'au'₂, jŋia'₅₄ lia'₂ 'ne₂ bá₄ quɨ'₅₄ jmɨg₄ jmó'₂ le₁jë́₃ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jaun₂ ca₂dsia₃ Jesús ŋéi₂ dsɨ́₅ dsa₂ 'éi₂, ca₂néi'₃ gu₂ ca₂nɨ́i'₂ quió'₅, jaun₂ ca₂juá'₂: ―'Ŋio₂ bá₄ dsɨ₃. Juɨ₁le₅₄ le₁jë́₃ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dsɨ₂juɨ₅ le₂jaun₂ ca₂jŋia'₃ 'mé'₅ 'iog₅, ca₂'lón₂ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jaun₂ ca₂dsióg'₂, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―La₁ të₃ŋi'₅₄ tsá₃ 'ein₂ i₂juɨg'₂ 'i₁jan₂. Jŋia'₅₄ gua₂ o₂jme₁jnia₅ ne₄ jme₂dsa₂, o₂jen'₅₄ ne₄ Diú₄ o₂jmo₄ con'₂ lë́₅ 'Éi'₃ quió'₅ Moisés, o₂jang'₅₄ jág₁ dsau₅ jɨn₄ dsa₂ juɨg₂ a₂ma₂'lóng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","La₁ dsa₂ 'éi₂ në́₃ të₂le₃ i₂juɨ'₂ guë́₄ ca₂dsia₃ bá₄ jme₁o₂'ɨ́in₃, qui₂ca₂'ë́₂ jág₁ ca₂le₂con₂. 'Uɨg₅₄ jaun₂ tsá₃ ma₃lé₂ 'í₂ Jesús jë₄ juɨg₂ të₃ jág₅ dsa₂; jmá'₃ lia'₂ ja₁co₂'ŋiog₅ bá₄ jme₁jŋia₂₃. La₁ tion₅₄ bá₄ jme₁dsɨ₂lén₂ dsa₂ coin₂ i₂ja₂lén₂ ca₂le₂con₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cang₂ jaun₂ ca₂'í₃ táng₃ Jesús jë₄ juɨg₂ Capernaum. Jaun₂ ca₂rë₃ŋi₅ dsa₂ a₂ma₂dsiáin'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jaun₂ dsɨ₂juɨ₅ bá₄ ca₂ŋɨ'₂ dsa₂ juɨn₅ lɨn₃, ca₂lia'₂ jŋia'₅₄ tsá₃ ma₃të₂ ja₁'éin'₄ dsi₂néi₂, le₂tan₅₄ o₄'né₄ në́₃. Jaun₂ ca₂ton₃ jág₁ dse₃ ca₂tsɨ́'₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jaun₂ ca₂dsi₃lén₂ co₂nió'₃; jë₄ jaun₂ i₃lén₂ quén₂ le₁jŋiai₂₃ jan₂ dsa₂ i₂rë₂já'₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ia₁ tsá₃ lé₂ ŋɨ́i₃ të₂ dsi₂néi₂ ja₁'en₅₄ Jesús, ia₁ juɨn₅ dsa₂ tion'₅₄, jaun₂ juɨ₅ co'₅₄ tsɨ₁'né₅ bá₄ ca₂niá₃ caun₂ tau₂ pa₁, co₂dsau₅ ja₁chén'₄ Jesús. Juɨ₅ jaun₂ ca₂sióin₂ dsa₂ 'lian'₂ 'éi₂, dsɨ́in₂ caun₂ tsɨ₁jein₁. ");
INSERT INTO cntNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jme₁ca₂rë₃lí'₄ Jesús 'a₂ lia'₂ 'én₂ dsa₂ 'éi₂, jaun₂ ca₂tsɨ́'₃ dsa₂ 'lian'₂: ―Jón₃, ma₂rë₂'én₄ bá₄ dsáu'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jaun₂ i₂lɨn₅₄ të₅juá'₅ i₂jme₁tián'₄ jë₄ jaun₂, ca₂i₃jiog₅ dsɨ́₅: ");
INSERT INTO cntNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿'E₂ lë₃ juá'₂ i₂në₅ le₂në₅? A₂'ɨn₅ 'lɨg'₅₄ Diú₄ bá₄ i₂në₅. 'I₁jan₂ tsá₃ 'ein₂ lé₂ le₃'én₂ dsáu₁ dsa₂, jŋia'₅₄ lia'₂ jan₂ Diú₄ bá₄.” ");
INSERT INTO cntNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","La₁ ma₂ŋi₅ bá₄ Jesús dsɨ₂juɨ₅ a₂dsɨ₂jiog₅ dsɨ́₅ dsa₂ 'éi₂ tiáin'₅, jaun₂ ca₂juá'₂: ―¿'E₂ lë₃ dsɨ₂jiog₅ 'au'₂ 'nia'₂ le₂në₅? ");
INSERT INTO cntNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿'E₂ a₂quian₅ guë́₄ ta₁, a₂juɨg₅₄ jniá₂ dsa₂ 'lian'₂ në₅: “Ma₂rë₂'én₄ dsáu'₂”, o₃ a₂juɨg₅₄ 'e₂ jniá₂: “Nau₂ guan'₂ ŋɨ₄ quion₂ tsɨ₁jein₁ quiáng'₂?” ");
INSERT INTO cntNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","La₁, ia₁jaun₂ le₃ŋi'₅₄ 'nia'₂ a₂'io₅ bí₂ 'éi'₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ ne₄ gua'₅₄ 'uë₃ a₂lé₂ le₃'éin₂ dsáu₁ dsa₂ ―jaun₂ ca₂tsɨ́'₃ dsa₂ 'lian'₂ 'éi₂: ");
INSERT INTO cntNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―'Ne₂ juɨ́g₂ jniá₂, nau₂ quion₂ tsɨ₁jein₁ quiáng'₂, guan'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jaun₂ ca₂nau₂ 'éi₂, ca₂cáun₃ tsɨ₁jein₁ quió'₅, të₃ jág₅ dsa₂. Jaun₂ ca₂i₃gó'₃ dsɨ́₅ ca₂le₃jɨ́in₃, qui₂jme₂juɨin'₂ Diú₄, tsɨ́'₅ rɨin'₅₄: ―'I₁co₂ráun₂ tsá₃ 'ein₂ ma₂jág₃ jniog₄ le₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Con'₂ siá'₂ táng₃ ca₂ŋó₃ Jesús chei'₅₄ jmɨ₁ŋí'₄. Jaun₂ dsi₃lén₂ dsa₂ juɨn₅ ca₂ŋɨi'₂. Jaun₂ qui₂ca₂jme₃tag₅ Jesús jág₁ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jme₁ca₂ŋɨi₅ ja₁jaun₂, ca₂jɨ́in₂ Leví ja₁ŋi'₅₄ Alfeo, guá₅ 'éi₂ gue₂₃ 'lia'₅₄ a₂ca₂tɨ́n₂ dsɨ₂tan₅₄ romano. Jaun₂ ca₂juá'₂ Jesús: ―Jme₁quiong'₅₄ jniá₂. Jaun₂ ca₂nau₂ 'éi₂, ca₂ŋó₃ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jme₁ma₂'en₅₄ Jesús guë́'₅ ja₁quió'₄ Leví; ja₁jaun₂ jme₁le₁ŋɨ'₂ juɨn₅ dsa₂ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄ ján₃, quian'₅₄ dsa₂ sián'₂ “i₂le₁cán'₄ dso₄” në́₃, tiáin'₅ co₂lë₅ guë́'₅ quian'₅₄ Jesús quian'₅₄ dsa₂ quiáin₅, ia₁ i₂juɨn₅ lɨn₃ i₂le₂'éi₂ ma₂quiain'₅₄ ŋɨ₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jaun₂ jme₁ca₂jág₃ të₅juá'₅ quián₅ dsa₂ fariseos a₂guë́'₅ Jesús co₂lë₅ quian'₅₄ dsa₂ le₂'éi₂, jaun₂ ca₂tsɨ́'₃ dsa₂ quián₅ Jesús: ―¿'A₂ bá₄ lia'₂ guë́'₅ të₅ quián'₂ 'nia'₂ quian'₅₄ dsa₂ 'lɨn'₅₄ i₂le₁cán'₄ dso₄, quian'₅₄ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jaun₂ jme₁ca₂nág₂ Jesús jág₁ në₅, jaun₂ ca₂ŋag₃: ―Tsá₃ të₅mɨ́₅ 'nió'₅ quió'₅ dsa₂ dsen₃ i₂tsá₃ le₁dso'₅₄, jŋia'₅₄ lia'₂ dsa₂ i₂le₁dso'₅₄ bá₄ 'nió'₅ të₅mɨ́₅ quió'₅. Ia₁ tsá₃ ta₁ jaun₂ guio₃ jniá₂ a₂të́₄ dsa₂ dsen₃, a₂të́₄ dsa₂ i₂qui₂le₁cán'₄ dso₄ bá₄ jniá₂ guio₃. ");
INSERT INTO cntNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Co₂ráun₂ dsa₂ i₂jme₁i₂nio₄ quian'₅₄ Juan₅₄, quian'₅₄ dsa₂ i₂tén₅ le₃quió'₅ dsa₂ fariseos në́₃, jme₁jme₂'ɨin₅₄. Jaun₂ dsi₃lén₂ i₂lɨn₅₄ ca₂ŋɨ́i'₃ Jesús: ―¿'E₂ 'uɨg₅₄ jme₂'ɨn₅₄ dsa₂ i₂i₂nio₄ quian'₅₄ Juan₅₄, dsa₂ quián₅ fariseos në́₃, ton'₂ tsá₃ jme₂'ɨn₅₄ guë'₂ dsa₂ quián'₂ 'ne₂? ");
INSERT INTO cntNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jaun₂ ca₂ŋag₃ Jesús: ―¿Lé₂ le₃jme₃'ɨn₅₄ juɨ₁lia'₂ dsa₂ i₂té₄ ja₁niog₅ jmɨg₄ ja₁jen'₂ gu₂ dsa₂, të₁lia'₂ quiong'₅₄ dsa₂ ŋe'₂ i₂jén'₂ gu₂? Ma₁ tsá₃ le₂jaun₂ jmo₅ dsa₂, të₁lia'₂ quiong'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","La₁ jiá₃ caun₂ jmɨg₄ a₂jŋia'₃ dsa₂ i₂jén'₂ gu₂ 'éi₂. Jaun₂ guë́₄ lé₂ le₃jme₃'ɨin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ma₁ tsá₃ jmo₅ dsa₂ jua'₅₄ a₂tióng₅ quian'₅₄ 'nau₅₄ 'mɨ'₂ 'mɨ́₂ tsɨ₁'mɨ'₂ gui'₅₄, ia₁ dsáu'₅ tsɨ₁'mɨ'₂ 'mɨ́₂ jë₁ma₂jŋɨ₂. Jaun₂ juë'₂ guë́₄ jë₁gag₂ lë́₂ tsɨ₁'mɨ'₂ gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","On₃ guë́₄ jmo₅ dsa₂ jua'₅₄ a₂tia'₂ vino 'mɨ́₂ 'ŋió'₃ nɨ₁lau₂ gui'₅₄. Ia₁ guéi₃ nɨ₁lau₂ gui'₅₄ quian'₅₄ dsió'₁ vino 'mɨ́₂. Dsɨ₂'én₂ bá₄ vino, lia'₂ nɨ₁lau₂ në́₃. Jaun₂ 'ŋió'₃ nɨ₁lau₂ 'mɨ́₂ bá₄ 'nió'₅ tia'₃ dsa₂ vino 'mɨ́₂ ia₁jaun₂ tsá₃ dsɨ₃'én₂. ");
INSERT INTO cntNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Caun₂ jmɨg₄ sa₅₄ ca₂ŋɨ₅ Jesús quiain'₅₄ dsa₂ quiáin₅ caun₂ ja₁nau₂ ja₁jnia₄ trigo. Dsa₂ i₂jme₁quiain'₅₄ në́₃ ca₂jme₃lióg₃ qui₂ca₂gág₃ mɨ́'₂ trigo jme₁ca₂ŋɨi₅ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jaun₂ në́₃, ca₂juá'₂ dsa₂ fariseos: ―¿'E₂ lë₃ jmo₅ dsa₂ i₂quiang'₅₄ ta₁ a₂tsá₃ 'i₄ 'éi'₃ jmo₃ jmɨg₄ sa₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jaun₂ ca₂ŋag₃ Jesús: ―¿Tsa₁ ma₂'í'₂ 'nia'₂ 'i₁cón'₂ a₂ca₂jmo₃ David ma₂lɨ́g'₂ quian'₅₄ rɨin'₅₄ lia'₂ con'₂ jme₁ca₂rë₃'ɨ́n₂ quió'₅, a₂ca₂lë₃ i₁cón'₅? ");
INSERT INTO cntNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ca₂'í₃ David dsi₂néi₂ quió'₅ Diú₄, lia'₂ con'₂ jme₁lɨ́n₄ Abiatar juɨg₅₄ jme₂dsa₂. Ca₂guë́'₃ i₁ŋí'₄ jŋió₅ a₂'i₄ 'éi'₃ a₂guë́'₅ jmá'₃ jme₂dsa₂. Jaun₂ ca₂cuë́'₃ dsa₂ i₂jme₁quiain'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ján₃ bá₄ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂: ―O₄quió'₄ dsa₂ mɨ₂güɨ́g₃ bá₄ ca₂lë₃ jmɨg₄ sa₅₄, on₃jua'₅₄ rë'₂ o₄quió'₄ jmɨg₄ sa₅₄ ca₂jmó'₂ Diú₄ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jaun₂ lë₃, Jaun₅ dsa₂ mɨ₂güɨ́g₃ bá₄ i₂'io₅ 'éi'₃ ne₄ quió'₅ jmɨg₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Con'₂ siá'₂ táng₃ ca₂'í₃ Jesús guá'₅ sinagoga. Ja₁jaun₂ jme₁'en₅₄ jan₂ dsa₂ i₂'lia'₂ caun₂ mɨ₂gu₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jaun₂ ca₂tiog₃ dsa₂ ca₂tiain₃ Jesús, o₁ne₄ chi₂jua'₂ jme₃'lióin₂ dsa₂ 'éi₂, të₃ jmɨg₄ sa₅₄, ia₁jaun₂ chain₂ bí₂ a₂bóin'₂ dso₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jaun₂ ca₂tsɨ́'₃ Jesús dsa₂ i₂'lia'₂ mɨ₂gu₂: ―Ŋia₅, dsi₂jo₂ la₂ nau₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jaun₂ ca₂ŋag₃ Jesús ca₂ŋɨ́i'₃ dsa₂ i₂tion'₅₄ jág₅: ―Juɨ₁lia'₂ jmɨg₄ sa₅₄, ¿'e₂ 'i₄ 'éi'₃ jmo₃ dsa₂? ¿A₁dse₃, o₃ a₂'lɨg'₅₄ 'e₂? ¿A₂lión₂ dsa₂ jme₂dsí₂ rɨin'₅₄, o₃ a₂jŋɨ'₃ dsa₂ rɨin'₅₄ 'e₂? Jaun₂ jŋia'₅₄ lë₁tión₂ tei₄ le₂jaun₂ bá₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jaun₂ 'ne₂ Jesús ca₂jɨ́in₂ dsa₂ i₂tion'₅₄, co₂'na₂ guë'₂ quɨ'₂ dsɨ́₅, ia₁ a₂ŋɨ́₄ lë₃ tsá₃ ŋɨ́'₂ dsɨ́₅ dsa₂. Jaun₂ ca₂tsɨ́'₃ dsa₂ dso'₅₄: ―Nei'₅₄ gog'₂. Jaun₂ ca₂néi'₃ 'éi₂ gu₂; ca₂lág₃ bá₄ jaun₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Dsɨ₂juɨ₅ le₂jaun₂ ca₂'uɨn₂ dsa₂ fariseos ca₂i₁jmo₅₄ jág₁ quian'₅₄ dsa₂ quián₅ Herodes a₂jŋɨi'₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jaun₂ ca₂ŋó₃ táng₃ Jesús juɨ₅ chei'₅₄ jmɨ₁ŋí'₄ quian'₅₄ dsa₂ i₂quiain'₅₄. Jaun₂ juɨn₅ lɨn₃ dsa₂ chan₂ Galilea ca₂jme₃quiong'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jme₁ca₂rë₃ŋi₅ dsa₂ ca₂le₃jë́₃ 'e₂ a₂niog₅ lë́₂ a₂jmo₅ Jesús, ca₂o₃lén₂ juɨn₅ lɨn₃ dsa₂ chan₂ Judea, dsa₂ chan₂ Jerusalén, dsa₂ chan₂ Idumea, dsa₂ chan₂ le₂'ŋo'₅₄ Cuá₃ Jordán, dsa₂ chan₂ Tiro, dsa₂ chan₂ Sidón në́₃, a₂ca₂o₃jɨin₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jaun₂ ca₂tsɨ́'₃ Jesús dsa₂ quiáin₅, a₂jmo₃ co₂jŋia₅₄ caun₂ tsɨ₁mu₅, ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ ca₂quɨ́in'₃ jɨn₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ia₁ juɨn₅ lɨn₃ dsa₂ dso'₅₄ ma₂ca₂jme₃'lióin₂ le₂jŋiá₅. Jaun₂ në́₃, ca₂le₃jɨ́n₃ dsa₂ dso'₅₄ tioin'₅₄ co₂'liain'₂ rɨin'₅₄ ca₂lia'₂ qui₂co₂dsɨin₅₄ Jesús, ia₁ a₂'nio₃ qui₃nɨ́i'₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jme₁ca₂jág₂ jme₂dsí₂ 'lɨn'₅₄ i₂tion'₅₄ të₂dsɨ́₅ dsa₂, jaun₂ ca₂chi₃jné₃, tioin'₅₄ co₂mɨ'₅₄, juá'₂: ―¡'Ne₂ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄! ");
INSERT INTO cntNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jaun₂ lë₃ ca₂jmo₃ Jesús 'éi'₃ a₂tsá₃ jme₃jniog₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Cang₂ jaun₂ ca₂i₃léin₂ caun₂ ja₁lë́₄ dsɨ₂con'₂. Ja₁jaun₂ ca₂quión'₂ Jesús dsa₂ i₂'nioi₃ jme₃quiong'₅₄. Jaun₂ ca₂o₃lén₂ 'éi₂ ja₁chéin'₄. ");
INSERT INTO cntNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jaun₂ ca₂'ɨin₃ guia₃-tɨ́n₂ dsa₂ 'éi₂, ia₁jaun₂ jme₃quiong'₅₄ ton'₂ ia₁jaun₂ chei₃ a₂dsɨ₃lén₂ 'éi₂ a₂qui₂dsɨ₃'ë́₃ jág₁, ");
INSERT INTO cntNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ia₁jaun₂ 'io₃ 'éi₂ bí₂ ján₃ a₂le₃'uɨ́in'₂ je₂na'₅₄ dsɨ́₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","I₂la₂ bá₄ dsa₂ i₂guia₃-tɨ́n₂ i₂ca₂'ɨn₃ Jesús: Si₂mu₅₄ i₂të́'₂ Jesús Pe₄; ");
INSERT INTO cntNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Le₂on₃ ja₁ŋi'₅₄ Zebedeo: Jacobo quian'₅₄ Juan₅₄, i₂ca₂të́'₃ Jesús Boanerges, co₂'nió'₄ a₂juá'₂, jaun₅ ŋí'₃; ");
INSERT INTO cntNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Drë́₄, Fe₂li₄, Bartolomé, Të₅₄, To₁má₄ në́₃; Jacobo ja₁ŋi'₅₄ Alfeo. Tadeo, Si₂mu₅₄ i₂lɨ́n₅ cananista; ");
INSERT INTO cntNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote në́₃, dsa₂ i₂ca₂jɨ́n'₂ Jesús. Jaun₂ ca₂dsián'₃ Jesús jme₁ca₂dsiáin'₃ caun₂ dsi₂néi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Con'₂ guë'₂ siá'₂, ca₂ŋɨ'₂ táng₃ dsa₂ juɨn₅ lɨn₃, jŋia'₅₄ tsá₃ jɨin₅₄ guë́'₃ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jme₁ca₂rë₃ŋi₅ o₁rɨin'₅₄, jaun₂ ca₂o₃léin₂ a₂jme₁tsáun'₂ të₂, ia₁ 'ei₅ jág₁ a₂lë₁ma₂të₂'ɨ₂₃ ŋɨ₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ján₃ bá₄ le₂jaun₂ të₅juá'₅ i₂ja₂lén₂ Jerusalén, ca₂juá'₂: ―Quian₅ dsa₂ në₅ Be'elzebú, i₂lɨ́n₅ juɨg₅₄ je₂na'₅₄. A₂jaun₂ bá₄ quɨ'₅₄ jmɨg₄ 'uɨ́in'₂ je₂na'₅₄ tion'₅₄ dsɨ́₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jaun₂ lë₃ ca₂të́'₃ Jesús të₅juá'₅ 'éi₂, jaun₂ ca₂juá'₂ të₂le₃ quian'₅₄ jág₁ a₂jáng'₅ léi₄: ―¿'A₂ lia'₂ le₃lé₂ jua'₅₄ jmo₃ Satanás a₂dsein₂₃ 'ŋiog₅ quió'₅ dsa₂? ");
INSERT INTO cntNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Në₁jua'₂ co₂nió'₃ dsɨ₂tan₅₄ ca₂niói'₃ mɨ'₅₄ quiain'₅₄ rɨin'₅₄, dsɨ₂tan₅₄ 'éi₂ tsá₃ uë́₂ lé₂ le₃tóin'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Në₁jua'₂ dsa₂ dsi₂néi₂ tioin'₅₄ mɨ'₅₄ quɨ́in'₂, ján₃ bá₄ le₂jaun₂ tsá₃ uë́₂ tió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Në₁jua'₂ ca₂dsia₃ Satanás 'nei₂ a₂jmo₃ le₁dsoin'₅₄ 'ŋiog₅, ján₃ bá₄ le₂jaun₂ tsá₃ uë́₂ 'oin₅₄ bí₂ quió'₅; ja₁jaun₂ ca₂dsan₃ bá₄ quió'₅ në₁jua'₂ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’'I₁jan₂ tsá₃ 'ein₂ lé₂ le₃'í₂ tion₅₄ dsi₂néi₂ quió'₅ juɨ₁lia'₂ jan₂ dsa₂ 'uan'₂, jua'₅₄ a₂jŋiá'₂ dsa₂ a₂te₁'i₁ quió'₅, jŋia'₅₄ lia'₂ a₂'nei'₂ bá₄ de'₂ jŋiá₅ dsa₂. Jaun₂ bá₄ lé₂ le₃jŋia'₃ a₂cha₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’A₂dsɨ₂jó'₃ juá'₅ jniá₂, a₂lé₂ le₃'én₂ ca₂le₃jë́₃ bá₄ dsáu₁ dsa₂, ca₂le₃jë́₃ 'e₂ a₂'lɨg'₅₄ juá'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","La₁ në₁jua'₂ ca₂juá'₂ 'lɨg'₅₄ 'ɨin₂₃ Jme₂dsí₂ Jŋió₅, tsá₃ ma₃a₁jaun₂ lé₂ le₃'én₂ dsáu₁. A₂rë₂cáin'₄ ca₂le₃jë́₃ jmɨg₄ chain₂ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Le₂në₅ ca₂juá'₂ ia₁ dsia₅ dsa₂ 'ag₂₃ 'ein₅₄ jme₂dsí₂ 'lɨn'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jaun₂ ca₂dsi₃lén₂ chi'₂ rɨn'₅₄ Jesús, quian'₅₄ chog₅₄ në́₃. La₁ ca₁'né₄ bá₄ ca₂tóin'₂. Jaun₂ ca₂chein₃ jág₁ a₂të́'₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jaun₂ ca₂juá'₂ dsa₂ i₂jme₁tián'₄ cau₅ quió'₅ Jesús: ―Chog'₂ quian'₅₄ chi'₂ rɨ́ng'₂, në₅ tiáin'₅ ca₁'né₄, a₂'nai'₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jaun₂ ca₂ŋag₃: ―¿'Ein₂ 'éi₂ lɨ́n₅ cha₃ jniá₂, rɨ́n'₃ jniá₂ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jaun₂ ca₂jɨ́in₂ dsa₂ i₂tián'₅ cau₅ quió'₅, jaun₂ ca₂juá'₂: ―¡Jag₄! I₂la₂ bá₄ lɨ́n₅ cha₃, rɨ́ng'₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ia₁ juɨ₁'ein₂ guë́₃ i₂jmo₅ a₂'ŋio₂ dsɨ́₅ Diú₄, i₂'éi₂ bá₄ lɨ́n₅ juɨ₁lia'₂ rɨ́ng'₃, cha₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Con'₂ siá'₂ táng₃, co₂ráun₂ ca₂jme₃lióg₃ Jesús ca₂jme₃tɨin₂₃ dsa₂ chei'₅₄ jmɨ₁ŋí'₄. Ia₁ juɨn₅ lɨn₃ dsa₂ ca₂lë₃ në́₃ ca₂ŋɨ'₂ ja₁chéin'₄, jaun₂ ca₂'í₃ 'ŋió'₃ tsɨ₁mu₅ 'ei₅ chei'₅₄ jmɨg₂; jaun₂ ja₁jaun₂ ca₂guá₂. Dsa₂ guë'₂ në́₃ ca₂tóin'₂ chei'₅₄ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","'Lióng₂ jág₁ dse₃ ca₂jme₃tag₂₃ të₂le₃ quian'₅₄ jág₁ a₂jáng'₅ léi₄. Jë₄ juá'₅ quió'₅ a₂jme₂tag₂₃, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Nei₂ 'nia'₂: Jan₂ dsa₂ ca₂ŋe₄ ja₁nau₂ ca₂i₁séi₄ mɨ́g₂ jon₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Jme₁ma₂'ein₅₄ séi₂ në́₃, a₂lɨn₅₄ mɨ́g₂ jon₂ i₂ga'₅₄ le₂'i₄ juɨ₅. I₁tan₅ bá₄ ca₂dsi₃lén₂ ca₂cág'₃ a₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A₂lɨn₅₄ guë'₂ mɨ́g₂ jon₂ táng₃, ca₂i₃to'₅₄ jë₄ nɨ₁cang₁, ja₁tsá₃ gua'₅₄ lɨn₄ cha₂. A₂jaun₂ në́₃ tsá₃ uë́₂ ca₂rë₃'ag₄, ca₂'ia₂, ia₁ tsá₃ jɨ'₂ gua'₅₄ ja₁i₃to'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","La₁ jme₁ca₂jnióg₃ 'iog₂ në́₃, ca₂rë₃juɨng₅ ca₂rë₃quéin₃ bá₄, ia₁ tsá₃ jmú₄ 'lióng₂ jme₁cha₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A₂lɨn₅₄ guë'₂ ca₂séi'₂ ja₁lë́₄ nɨ₁taun₅. Jme₁ca₂i₃cón₃ nɨ₁taun₅ në́₃, ca₂jlë₃ bá₄ a₂jaun₂, tsá₃ 'e₂ ca₂rau₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","La₁ a₂lɨn₅₄ guë'₂ në́₃ ca₂tɨ́n₂ ja₁dse₃ 'uë₃. A₂jaun₂ ca₂rau₂ bá₄ dse₃. A₂lɨn₅₄ ca₂'ág₂ jma₃guióg₂-guiá₂ mɨ́g₂, lia'₂ ca₂mɨ́g₂ jon₂. A₂lɨn₅₄ guë'₂ jma₃'nag'₂ ne₂guióg₂ mɨ́g₂; a₂lɨn₅₄ guë'₂ jma₃caun₂ 'ŋiá₂-láu₂ mɨ́g₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jaun₂ në́₃, ca₂juá'₂ Jesús: ―Ca₂le₃jɨ́n'₃ 'nia'₂ i₂le₁dsɨ₅₄ rë₂gua₄, rë₂ nei₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jme₁ma₂i₂len₃ dsa₂, jme₁ma₂të₁'ŋiái₄ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, quiain'₅₄ i₂lɨn₅₄ guë́₄ dsa₂ sián'₂, jaun₂ ca₂ŋag₃ 'éi₂ 'e₂ jág₁ dsau₅ jáng'₅ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jaun₂ ca₂juá'₂ Jesús: ―Diú₄ bá₄ jmo₅ a₂rë₂ŋɨ́'₂ 'au'₂ 'nia'₂ jág₁ a₂rë₂'ma₄ 'a₂ lia'₂ lë́₅ ja₁goin₂, la₁ dsa₂ i₂tsá₃ i₂nio₄ quian'₅₄ jniá₂ në́₃, 'nió'₅ juá'₂ dsa₂ të₂le₃ quian'₅₄ jág₁ a₂jáng'₅ léi₄: ");
INSERT INTO cntNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ia₁jaun₂ i₂në₂jág₃, la₁ tsá₃ ca₂rë₃lí'₄ 'e₂ në₂jág₃. I₂në₂néi₂ në́₃, la₁ tsá₃ ca₂rë₃lí'₄ 'e₂ në₂néi₂, on₃ guë'₂ ca₂ŋɨ́i'₂; con'₂ tsá₃ ŋó₅ në₁ca₂jéin'₃ dsɨ́₅, ia₁jaun₂ jme₁'lioin₁₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ca₂juá'₂ ján₃: ―¿Tsa₁ ŋɨ́'₂ 'nia'₂ jág₁ a₂jáng'₅ léi₄ në₅? ¿'A₂ bá₄ guë'₂ lé₂ le₃ŋɨ́'₂ 'nia'₂ juɨ₁lia'₂ jág₁ a₂jáng'₅ léi₄ siá'₂? ");
INSERT INTO cntNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Juɨ₁lia'₂ lɨ́n₅ dsa₂ i₂séi₂ mɨ́g₂ jon₂, le₂jaun₂ bá₄ lɨ́n₅ juɨ₁lia'₂ dsa₂ i₂'ë́₂ jág₁ dse₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","I₂lɨn₅₄ dsa₂ lɨ́in₅ juɨ₁lia'₂ mɨ́g₂ jon₂ a₂i₃ga'₅₄ le₂'i₄ juɨ₅. Nag₂₃ jág₁ dse₃, la₁ dsɨ₂juɨ₅ jaun₂ ja₂ Satanás jŋiá'₂ jág₁ a₂ma₂jnia₄ të₂dsɨ́₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","I₂lɨn₅₄ guë'₂ dsa₂ lɨ́in₅ juɨ₁lia'₂ lë́₅ mɨ́g₂ jon₂ a₂i₃ga'₅₄ jë₄ nɨ₁cang₁. Nag₂₃, gue₂₃ jág₁ a₂'ŋio₂ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","La₁ia₁ tsá₃ uë́₂ tió'₅, ia₁ tsá₃ lɨn₄ jmú₄ cha₂ jua'₅₄ a₂chan'₂ tiá₂ jág₁. Jaun₂ jë₁ma₂ca₂can₃ o₂i₁ dsɨ₅, a₂co₂'ein₅ dsa₂ 'uɨg₅₄ jág₁ dse₃, dsɨ₂juɨ₅ bá₄ tí₂ táng₃ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","I₂sián'₂ guë'₂ në́₃ lɨ́n₅ co₂'nió'₄ mɨ́g₂ jon₂ a₂i₃ga'₅₄ jë₄ nɨ₁taun₅. Nag₂₃ jág₁ dse₃, ");
INSERT INTO cntNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","la₁ 'ŋio₅ guë́₄ 'ɨ₅ dsɨ́₅ o₂me'₅₄ dsɨ₅ a₂cha₂ mɨ₂güɨ́g₃ la₂; ne₄ 'uɨg₅₄ ia₁ a₂'ɨ́n₅ dsɨ́₅ juɨ₅ ja₁le₃cha₂ cu₄, ja₁në₅ bá₄ ja₁rë₂gain₂ táng₃; tsá₃ caun₂ a₂'ɨ́n₅ dsɨ́₅. Ca₂le₃jë́₃ a₂jaun₂ në́₃ jmo₅ jlë₅ jág₁ dse₃, tsá₃ ma₃cuë₂₃ jmɨg₄ a₂ráu₃. ");
INSERT INTO cntNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","La₁ i₂lɨn₅₄ guë́₄ në́₃ nag₂₃, gue₂₃ bá₄ jág₁, chan'₂ tiá₂. Lɨ́in₅ juɨ₁lia'₂ lë́₅ mɨ́g₂ jon₂ a₂i₃ga'₅₄ ja₁dse₃ gua'₅₄. 'Lióng₂ rau₂. I₂lɨn₅₄ guë'₂ lɨ́n₅ co₂'nió'₄ mɨ́g₂ a₂qui₂ca₂'ág₂ guióg₂-guiá₂; i₂lɨn₅₄ guë'₂ co₂'nió'₄ a₂qui₂ca₂'ág₂ 'nag'₂ ne₂guióg₂, o₃ caun₂ 'ŋiá₂-láu₂ mɨ́g₂ lia'₂ ca₂mɨ́g₂ mɨ́g₂ jon₂ a₂i₃jnia₄. ");
INSERT INTO cntNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jaun₂ ca₂juá'₂ táng₃ Jesús: ―Në₁jua'₂ quian₅ dsa₂ caun₂ nɨ₁tsɨ́₅ a₂guí'₂ si₂, ¿'a₂ chi'₃? ¿né'₃ tsɨ₁mɨ'₂, o₃ né'₃ tsɨ₁cama? Jan₂'ón₄. A₂'ag₅ guei'₅₄ bá₄ dsa₂ si₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ia₁ 'i₁caun₂ cosa tsá₃ cha₂ jua'₅₄ a₂lɨ́n₂ dsa₂ rë₂'ma₄, a₂tsá₃ le₃jniá₂; tion₅₄ bá₄ rë₂jniá₂. Ján₃ guë'₂ 'i₁caun₂ jág₁ tsá₃ cha₂ jua'₅₄ lɨ́n₂ dsa₂ a₂tsá₃ 'ein₂ le₃ŋi₅; tion₅₄ bá₄ rë₂ŋi₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Chi₂jua'₂ 'ein₂ dsi₅₄ rë₂gua₄, juɨ₁nei₅₄ rë₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Con'₂ siá'₂ táng₃ ca₂juá'₂ Jesús: ―Tion'₂ 'nia'₂ juɨ₅ 'e₂ a₂nag'₂. Quian'₅₄ 'éi'₃ a₂cau'₂ 'nia'₂ guiong'₅₄, 'éi'₃ jaun₂ bá₄ quióg₃ Diú₄ quián'₂ 'nia'₂ ján₃, jŋia'₅₄ të₂le₃ lë́₅ guë́₄. ");
INSERT INTO cntNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ia₁ juɨ₁lia'₂ dsa₂ i₂'ŋio₂ dsɨ́₅ le₃ŋɨ́i'₂, Diú₄ bá₄ jmo₃ le₃ŋɨ́i'₂ guë́₄ dse₃. La₁ i₂tsá₃ 'nio₃ le₃ŋɨ́'₂ në́₃, Diú₄ bá₄ jmo₃ a₂tsá₃ ma₃le₃ŋɨ́i'₂ co₂ŋei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jaun₂ ca₂juá'₂ Jesús: ―Le₂jaun₂ bá₄ lë́₅ ja₁gon₂ Diú₄, juɨ₁lia'₂ lë́₅ quian'₅₄ dsa₂ i₂jne₅ 'e₂ jne₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Jë₁ma₂ca₂'ia₂, qui₂dsɨ₂cón₃ a₂jaun₂. La₁ juɨ₁lia'₂ dsa₂ i₂jne₅ 'éi₂ në́₃, o₁jŋia'₅₄ a₂'uë₂-jmɨ₂ güɨin₂, nau₂ në́₃, la₁ tsá₃ jaun₂ ŋi₅ 'a₂ lia'₂ lë́₂ a₂dsɨ₂cón₃. ");
INSERT INTO cntNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","'Uë₃ bá₄ lia'₂ lë́₅, jaun₂ bá₄ rau₂. Le₂'uɨg₅₄, tag₄ de'₂ jŋiá₅ 'ia₂; ŋó₅ jaun₂ 'ia₂ nɨ₁la₁, lë́₂ nɨ₁guein₂. Ŋó₅ jaun₂ lë́₂ nɨ₁cuɨg₂ lá₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jë₁ma₂ca₂ron₂, jaun₂ guë́₄ dsɨ₂'áun₂ dsa₂; ia₁ ca₂të́₂ jmɨg₄ a₂ca₂rau₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Con'₂ siá'₂ táng₃ ca₂juá'₂ Jesús. ―¿'A₂ lia'₂ lë́₅ ja₁gon₂ Diú₄, o₃ 'e₂ quian'₅₄ lé₂ le₃quɨn₃? ");
INSERT INTO cntNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lë́₅ juɨ₁lia'₂ lë́₅ mɨ́g₂ nɨ₁'ma₂ mostaza. Mɨ́g₂ jon₂ jaun₂ lë́₅ a₂pí'₁ guë́₄ 'ŋio₅ lɨn₃, lia'₂ con'₂ guë́₄ ca₂le₃jë́₃ jon₂ a₂jne₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jë₁ma₂ca₂i₃jnia₄ në́₃, dsɨ₂cón₃ dsiog₅ lë́₂ caun₂ nɨ₁'ma₂ pa₁, ca₂lia'₂ qui₂rë₂já₂ nɨ₁gu'₂ quió'₅. Jaun₂ tian'₅ i₁tan₅ ja₁lë́₄ 'en'₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ca₂jme₃tɨn₅ Jesús dsa₂ jág₁ dse₃ të₂le₃ quian'₅₄ 'lióng₂ jág₁ a₂jáng'₅ léi₄ le₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","'I₁caun₂ jág₁ tsá₃ jme₁cuë₂₃ jua'₅₄ tsá₃ të₂le₃ quian'₅₄ jág₁ a₂jáng'₅ léi₄. La₁ jë₁ma₂të₁'ŋiái₄ con'₂ guioin₅₄ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jme₁juá'₂ lia'₂ rë₂jiá₃ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Le₃ca₂nei₂ jmɨg₄ jaun₂ ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Ma₃ le₃'ŋo'₅₄ jmɨ₁ŋí'₄ le₃ó₃. ");
INSERT INTO cntNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tion'₅₄ jaun₂ dsa₂ chei'₅₄ jmɨ₁ŋí'₄, ca₂ŋó₃ Jesús ca₂jiog₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ 'ŋió'₃ tsɨ₁mu₅ ja₁jme₁'ein₅₄ táun₂ jág₁. Ján₃ bá₄ i₂lé₂ guë́₄ tsɨ₁mu₅ siá'₂ quiong'₅₄, tion'₅₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jme₁co₂lág₂ jaun₂ ca₂'ág₂ dsí₂ tiá₂ lɨn₃, jaun₂ qui₂ca₂jná'₃ jmɨg₂ 'ŋio₅ lɨn₃ ca₂lia'₂ ca₂i₃'a₄ jmɨg₂ 'ŋió'₃ tsɨ₁mu₅, jŋia'₅₄ mei'₂ tsá₃ ca₂can'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jme₁rë₂güɨ́n₃ bá₄ Jesús ŋó₃ le₃chi₁co'₅₄ rë₂dsɨn₅ 'mɨ'₂ dsi₅₄. Jaun₂ ca₂ŋei₃ dsa₂, ca₂juá'₂: ―¡Të₅! ¿Tsa₁ dsan₂ 'au'₂ jua'₂ dsɨ₃'éin₂ jnia'₅₄ ja₁lá₃? ");
INSERT INTO cntNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ca₂nau₂ Jesús jaun₂ në́₃, ca₂jéin₂ dsí₂, ca₂jéin₂ jmɨ₁ŋí'₄ në́₃, ca₂juá'₂: ―¡Jme₁'ua₅₄! ¡Tei₄ jmo₄! Jaun₂ dsɨ₂juɨ₅ jaun₂ bá₄ ca₂'ág₂ táng₃ tei₄ jmɨ₁ŋí'₄, dsí₂ në́₃ ca₂jŋia'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―¿'E₂ lë₃ ŋɨ́₄ 'ŋio₅ gan'₃ 'nia'₂? ¿'A₂ bá₄ lia'₂ ŋɨ́₄ tsá₃ rë₂'én'₂ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jaun₂ i₃gó'₃ dsɨ́₅ 'ŋio₅ lɨn₃, qui₂ca₂tsɨ́'₃ rɨin'₅₄: ―¿'Ein₂ bá₄ lɨ́n₅ i₂në₅ ca₂të₂ jmɨ₁ŋí'₄, ca₂të₂ dsí₂ në́₃ qui₂nag₅ gau₂ jág₁ quió'₅? ");
INSERT INTO cntNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jaun₂ dsi₃léin₂ jme₁dsi₃léin₂ 'ŋo'₅₄ jmɨ₁ŋí'₄, go₄ dsa₂ Gadarenos. ");
INSERT INTO cntNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jaun₂ dsɨ₂juɨ₅ jme₁ca₂o₃'ɨ́n₃ Jesús 'ŋió'₃ tsɨ₁mu₅, dsióg₃ jan₂ dsa₂ i₂o₂'ɨ́n₃ ja₁le₁'on₅ 'lag₄, dsa₂ i₂'en₅₄ jme₂dsí₂ 'lɨn'₅₄ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jme₁guá₄ dsa₂ 'éi₂ jë₄ tau₂ 'ŋio₅; jaun₂ tsá₃ ma₃'ein₂ jme₁quɨ'₅₄ jmɨg₄ tió'₅ 'nei'₂ quian'₅₄ ŋí₁ cadena, ");
INSERT INTO cntNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ia₁ 'lióng₂ ráun₂ jme₁ma₂'nei'₂ dsa₂ le₂jŋiá₅, jme₁ma₂tó'₂ dsa₂ cadena mɨ₂tag₅₄, mɨ₂gu₂ në́₃. La₁ jë₂ bá₄ jŋia'₅₄ ma₂gág₃; ma₂juɨin₃ nɨ₁ŋí₁ jme₁chi₁quɨ́'₅ mɨ₂tag₅₄ në́₃. Jaun₂ 'i₁jan₂ tsá₃ ma₃'ein₂ jme₁tio₃. ");
INSERT INTO cntNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jaun₂ në́₃, jme₁i₂ŋɨ₅₄ lia'₂ 'uë₂-jmɨ₂ dsɨ₂guio'₂ ja₁le₁'on₅ 'lag₄ lia'₂ juɨ₅ má'₂ në́₃, qui₂jmái'₂ uɨg₅ 'ŋiog₅ qui₂uɨng₂ quió'₅ quian'₅₄ nɨ₁cang₁. ");
INSERT INTO cntNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","La₁ jme₁ca₂jɨ́in₂ Jesús já₅ uɨ́ng₂, ŋó₃ jaun₂ në́₃ co₂chi'₅₄ le₃ne₄ ja₁ŋó₄ Jesús, jaun₂ ca₂chi₃jné₃. ");
INSERT INTO cntNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jaun₂ ca₂'í₃ co₂mɨ'₅₄ ca₂juá'₂: ―¿'E₂ lë₃ tián'₅ 'ne₂ jë₄ quió₃ jniá₂, 'ne₂ Jesús Ja₁ŋi'₅₄ Diú₄ juɨn'₂? Ca₂Diú₄, jnag₅₄, mɨ₅ jniá₂ ne'₅₄ tsá₃ lë₁'ë́₅ uɨg₅. ");
INSERT INTO cntNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ca₂juá'₂ le₂në₅, ia₁ jme₁ma₂në₂chí'₃ Jesús jme₂dsí₂ 'lɨn'₅₄, ca₂juá'₂: “¡Jú₅ quió'₅ dsa₂ në₅, 'ne₂ jme₂dsí₂ 'lɨn'₅₄!” ");
INSERT INTO cntNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jaun₂ ca₂ŋag₃ Jesús: ―¿'A₂ lia'₂ cheng'₂? Jaun₂ ca₂ŋag₃: ―Juɨn₅ bá₄ cheng₂, ia₁ a₂juag₅ jnia'₅₄ lë́₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jaun₂ ca₂mɨ₃ tion₅₄-jan₃ ne₄ Jesús a₂tsá₃ chein₂ jme₂dsí₂ 'lɨn'₅₄ ja₁siá'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ia₁ jme₁tion'₅₄ juɨn₅ i₁ŋí₅, guë́'₅ quián₅ 'uɨg₅₄ má'₂, ");
INSERT INTO cntNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","jaun₂ qui₂ca₂mɨ₃ i₂'lɨn'₅₄ ne₄ Jesús, ca₂juá'₂: ―Chei₅ jnia'₅₄ ja₁tion'₅₄ i₁ŋí₅, jaun₂ dsɨ₁tió'₄ jnia'₅₄ quió'₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jaun₂ ca₂cuë₃ bá₄ Jesús jmɨg₄. Jaun₂ ca₂'uɨin₂ ca₂i₃léin₂ i₃toin'₅₄ quió'₅ i₁ŋí₅. Jme₁lë́₂ con'₂ tɨn₃ mei₅ i₁ŋí₅ jme₁tion'₅₄. Ca₂le₃jɨ́n₃ 'éi₂ ca₂i₁nioi₁₂ co₂chi'₅₄ cuɨng₂₃ ca₂sein₃ siá₅ i₃toin'₅₄ jmɨ₁ŋí'₄, ca₂dsain₃. ");
INSERT INTO cntNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jaun₂ ca₂i₃len₃ dsa₂ i₂jme₁jmo₅ 'í₁ cuɨng₂₃ ca₂i₁chi'₄ dsa₂ jë₄ juɨg₂, quian'₅₄ i₂tion'₅₄ ja₁nau₂ në́₃. Jaun₂ i₃lén₂ dsa₂ i₁jag₅₄ 'e₂ ca₂lë₃ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jme₁ca₂o₃léin₂ ja₁'en₅₄ Jesús, ca₂jɨ́in₂ dsa₂ i₂jme₁tion'₅₄ juɨn₅ jme₂dsí₂ je₂na'₅₄ quió'₅. Jaun₂ ma₂guá₅ ma₂qui'₂ tsɨn'₅₄, ma₂'en₅₄ bá₄ dsɨ́₅. Tioin'₅₄ ca₂jág₂ dsɨ₂gó'₃ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jaun₂ dsa₂ i₂ca₂jág₃ ca₂dsia₃ 'e₂ ca₂lë₃ quian'₅₄ dsa₂ i₂jme₁tion'₅₄ je₂na'₅₄ quió'₅, 'e₂ ca₂lë₃ quian'₅₄ i₁ŋí₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jaun₂ ca₂jme₃lióg₃ qui₂ca₂mɨ₃ tion₅₄ ne₄ Jesús a₂o₃'ɨin₅ 'uë₃ go₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jme₁ma₂ŋó₅ Jesús 'í₂ tsɨ₁mu₅, jaun₂ jme₁mɨ₅ dsa₂ i₂jme₁tion'₅₄ je₂na'₅₄ quió'₅, jme₁mɨ₂₃ jág₁ ne₄ Jesús a₂dsó₃ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","La₁ tsá₃ ca₂cuë₃ 'éi₂ jmɨg₄. Jaun₂ ca₂tsɨ́'₃ dsa₂ 'éi₂: ―Guan'₂ ja₁quiáng'₂, ja₁tián'₄ rɨ́ng'₂, o₂dsia₄ ca₂le₃jë́₃ 'e₂ në₂jmo₃ Te₁gui'₅₄ o₄quiáng'₂, 'a₂ lia'₂ në₂dsia₃ ŋéi₂ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jaun₂ ŋá'₃ bá₄ dsa₂ 'éi₂ dsi₂néi₂ quió'₅, jaun₂ ca₂jme₃lióg₃ ca₂i₁dsia₂ jë₄ juɨg₂ tén₅ Decápolis ca₂le₃jë́₃ 'e₂ ca₂jmo₃ Jesús o₄quió'₄. Ca₂le₃jɨ́n₃ dsa₂ i₂ca₂nág₂ ca₂i₃gó'₃ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jme₁ca₂dsián'₃ táng₃ Jesús le₃'ŋo'₅₄ jmɨ₁ŋí'₄ quian'₅₄ tsɨ₁mu₅, juɨn₅ lɨn₃ dsa₂ i₂ca₂dsi₃lén₂ táng₃ jme₁dsiáin'₃. Të₁lia'₂ 'ŋɨ₂₃ chei'₅₄ jmɨg₂, ");
INSERT INTO cntNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","jaun₂ ca₂dsióg₃ jan₂ dsa₂ i₂niog₅ gu₂ guá'₅ sinagoga, i₂chen₂ Jairo. Jme₁ca₂jɨ́in₂ Jesús, jaun₂ ca₂chi₃jné₃ ne₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ca₂mɨ₃ ca₂juá'₂: ―Ma₂i₁jón₂ jan₂ chi'₂ quiáng₃. ¿Tsa₁ gog'₅₄ o₁jɨin'₁ o₁quiog'₂ gog'₂ ne₄ quió'₅, jaun₂ 'lióin₂, le₃chain₂? ");
INSERT INTO cntNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jaun₂ në́₃ ca₂ŋó₃ Jesús quiong'₅₄; juɨn₅ lɨn₃ guë́₄ dsa₂ sián'₂ i₃lén₂ ca₂lia'₂ co₂'liain'₂ bá₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jë₄ jaun₂, ŋó₃ jan₂ 'io₅₄ i₂ma₂të́₂ guia₃-tɨ́n₂ ŋi₂ a₂dso'₅₄ a₂tɨin₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","'Lióng₂ a₂ma₂i₃ŋɨ́i₂ o₄gú₃ juɨn₅ të₅mɨ́₅; jme₁ma₂'éin₂ ca₂le₃jë́₃ cu₄ a₂jme₁cha₂ quió'₅. La₁ tsá₃ 'e₂ ta₁ jmo₃, ia₁ të₂le₃ ca₂i₃ja₃ bá₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","La₁ jme₁ca₂nág₂ a₂'ɨn₅ dsa₂ Jesús, jaun₂ ŋó₃ ca₂jme₃quiáin₃ le₃ja₁ŋó₄ 'éi₂, jɨn₄ dsa₂. Jme₁ca₂dsióg₃ cau₅ quió'₅ Jesús në́₃, jaun₂ ca₂nɨ́i'₃ nɨ₁tsɨn'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ia₁ lɨ́in₂: “Tsá₃ a₂nag₅₄ a₂jŋia'₅₄ nɨ́g'₄ ca₂juɨg₄ tsɨn'₅₄, jŋia₃ quió₃.” ");
INSERT INTO cntNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Co₂tan₅₄ dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂'ná₂ tein₂₃ jmɨ₂, ca₂rë₃lí'₄ ca₂'lóin₂ dso₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jaun₂ dsɨ₂juɨ₅ bá₄ ca₂rë₃lí'₄ Jesús a₂o₃'ág₃ bí₂ quió'₅. Jaun₂ ca₂jéin'₃ jɨn₄ dsa₂, ca₂ŋag₃: ―¿'Ein₂ bá₄ në₂nɨ́'₃ tsɨ́n'₅? ");
INSERT INTO cntNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Jua'₂ jág'₂ bá₄ 'ne₂ 'a₂ lia'₂ co₂'liog'₂ dsa₂ ja₂léin₂. ¿'E₂ lë₃ juá'₂ “'ein₂ në₂nɨ́'₃ quió₃?” ");
INSERT INTO cntNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","La₁ qui₂ja₂né₂ Jesús jɨn₄ dsa₂ a₂'nai'₂ 'ein₂ në₂nɨ́'₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","'Io₅₄ 'éi₂ në́₃ ma₂jlein₂₃ bá₄ chéin'₅ gó'₅, ia₁ ŋi₅ bá₄ 'e₂ ma₂i₂ŋɨ́i₂. Ca₂ŋó₃ co₂ŋei'₅₄ ne₄ Jesús, ca₂chi₃jné₃, ca₂juá'₂ ca₂le₃jë́₃ lia'₂ tí₅ jág₁ dsón'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús në́₃ ca₂juá'₂: ―Jón₃, ia₁ 'éng'₂, ca₂'lóng'₂ bá₄. Guan'₂ tei₄ quiáng'₂. Co₂në₅ ca₂jŋia₃ dso₄ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Të₃ dsia₅ bá₄ guë́₄ Jesús jág₁ jaun₂ jme₁ca₂dsi₃lén₂ dsa₂ i₂tion'₅₄ ja₁quió'₄ Jairo i₂lɨ́n₅ ta₁ quió'₅ guá'₅ 'éi₂. Jaun₂ ca₂juá'₂ tsɨ́₅ Jairo: ―Ma₂ca₂jon₃ bá₄ ja₁mɨ́g'₄. ¿'E₂ ta₁ ma₂cuë'₂ o₂me'₅₄ dsɨ₅ të₅? ");
INSERT INTO cntNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","La₁ tsá₃ ca₂tón'₃ Jesús juɨ₅ jág₁ quió'₅ dsa₂ 'éi₂, jaun₂ ca₂tsɨ́'₃ Jairo: ―Tsá₃ lë₁jmo₂ gang'₃; jŋia'₅₄ lia'₂ 'én₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tsá₃ ca₂cuë₃ jmɨg₄ Jesús a₂dsɨ₃lén₂ juɨn₅ dsa₂ quiong'₅₄. Jŋia'₅₄ lia'₂ Pe₄, Jacobo, quian'₅₄ Juan₅₄ rɨin'₅₄ bá₄ i₃lén₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jme₁ca₂dsi₃léin₂ ja₁quió'₄ Jairo, ca₂jág₃ tion'₅₄ dsa₂ go₂'i₃ quɨ'₂-'o₂₃ co₂mɨ'₅₄, 'lia'₂ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ca₂'í₃ Jesús dsi₂néi₂, ca₂juá'₂: ―¿'E₂ lë₃ ŋɨ́₄ lë₃ tó'₂ 'nia'₂ mɨ'₅₄, 'au'₂ 'nia'₂ le₂në₅? Tsá₃ rë₂jon₅₄ guein₂ në₅. Jŋia'₅₄ lia'₂ a₂rë₂güɨ́in₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","La₁ jŋia'₅₄ ca₂ŋɨ́₂ bá₄ dsa₂ Jesús tioin'₅₄. Jaun₂ në́₃ ca₂'uɨ́n'₂ Jesús ca₂le₃jɨ́n₃ dsa₂ 'éi₂ ca₁'né₄. Jaun₂ ca₂jŋiai₃ chog₅₄-jmei₂ 'lag₄, dsa₂ ún₂ i₂jme₁quiain'₅₄ në́₃. Ca₂i₃toin'₅₄ ja₁rë₂quian₅ guein₂ 'lag₄. ");
INSERT INTO cntNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jaun₂ ca₂jŋa'₃ gu₂ i₂bë'₅₄, jaun₂ ca₂juá'₂: ―Talita, cumi ―co₂'nió'₄ a₂juá'₂: 'Io₅₄ bë'₅₄, 'ne₂ juɨ́g₂ jniá₂, nau₂. ");
INSERT INTO cntNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂nau₂, ca₂ŋɨ₃. Jme₁ma₂'ein₅₄ guia₃-tɨ́n₂ ŋi₂. Jaun₂ ca₂i₃gó'₃ dsɨ́₅ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","La₁ Jesús në́₃ ca₂jmo₃ 'éi'₃ a₂tsá₃ 'ein₂ tsɨ́'₃ 'i₁jan₂. Jaun₂ ca₂juá'₂ a₂cuë₃ dsa₂ a₂guë́'₃ i₂bë'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jaun₂ ca₂o₃'ɨ́n₃ bá₄ Jesús ja₁jaun₂. Jaun₂ ca₂dsiáin'₃ táng₃ juɨg₂ go₅₄ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jme₁ca₂të́₂ jmɨg₄ sa₅₄, jaun₂ ca₂jme₃lióg₃ ca₂jme₃tɨin₂₃ dsa₂ dsi₂néi₂ guá'₅ sinagoga. Juɨn₅ bá₄ dsa₂ i₂ca₂nág₂ dsɨ₂gó'₃ dsɨ́₅, jaun₂ ca₂tsɨ́'₃ rɨin'₅₄: ―¿A₂já'₄ ca₂i₁jme₁tɨn₅ i₂në₅ jág₁ ca'₅₄ a₂juá'₂ në₅? ¿I₂'e₂ bá₄ jág₁ a₂ŋɨ́'₂ dsɨ́₅ a₂ma₂ŋɨi₂ në₅, ca₂të₂ léi₄ juë'₂ në́₃ tɨin₂ jmo₃? ");
INSERT INTO cntNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿On₁jua'₅₄ i₂në₅ të₅'má₃ ja₁ŋi'₅₄ María, dsó₂ rɨn'₅₄ Jacobo, quian'₅₄ José, quian'₅₄ Judas, quian'₅₄ Si₂mu₅₄ në́₃? Në₅ bá₄ tián'₅ 'io₅₄ rɨin'₅₄ ja₁lá₃ ján₃. Jaun₂ tsá₃ ca₂rë₃jei₅₄ dsa₂ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jaun₂ ca₂juá'₂ Jesús: ―Ca₂le₂con₂ bá₄ ja₁siá'₂ guen₅ dsa₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄. Jŋia'₅₄ lia'₂ dsa₂ go₅₄ bá₄ tsá₃ guei₅, on₃ guë'₂ o₁rɨin'₅₄, on₃ guë'₂ rɨin'₅₄ dsi₂néi₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jaun₂ tsá₃ 'lióng₂ léi₄ juë'₂ lé₂ le₃jmo₃ juɨg₂ go₅₄. Jŋia'₅₄ lia'₂ i₂lɨn₅₄ bá₄ dsa₂ dso'₅₄ ca₂dsia₃ gu₂, jaun₂ ca₂jme₃'lió₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jaun₂ i₃gó'₃ dsɨ́₅ ia₁ a₂ŋɨ́₄ lë₃ tsá₃ 'e₂ 'én₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jaun₂ ca₂të́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂, jaun₂ ca₂chei₃ jma₃on₃ jma₃on₃. Ca₂cuë₃ bí₂ 'éi'₃ a₂'uɨ́n'₂ 'éi₂ jme₂dsí₂ 'lɨn'₅₄ quió'₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jaun₂ ca₂tsɨ́'₃ 'éi₂ a₂tsá₃ 'e₂ cán₂ 'i₁caun₂ le₁'i₄ juɨ₅, jŋia'₅₄ lia'₂ jma₃cáun₃ 'ma₂'ɨ₅₄ bá₄. 'I₁caun₂ a₂siá'₂ tsá₃ cán₂, on₃ guë'₂ të₂'mɨ'₂, on₃ guë'₂ i₁ŋí'₄, on₃ guë'₂ cu₄ 'ŋió'₃ nɨ₁lau₂ le₁jén'₅ tú'₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jŋia'₅₄ lia'₂ jma₃co₂dsán'₃ nɨ₁lau₂ con'₂ a₂ma₂le₁ton₅ tag₅₄ bá₄ cán₂, ton'₂ tsá₃ cán₂ tɨn₃ dsán'₃ tsɨn'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jaun₂ ca₂juá'₂ në́₃: ―Jë₁ma₂të́₂ rë₁tón'₄ 'nia'₂ lia'₂ caun₂ dsi₂néi₂ quió'₅ dsa₂ ja₁o₁nóg'₅, ja₁jaun₂ jŋia₄ 'nia'₂ ca₂lia'₂ ca₂të́₂ jmɨg₄ i₁'uɨ́n'₃ 'nia'₂ táng₃ juɨg₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Në₁jua'₂ cha₂ ja₁lɨn₅₄ tsá₃ guei₅ dsa₂, on₃ guë'₂ 'nio₃ dsa₂ nag₃ jág₁ quián'₂ 'nia'₂, 'uɨn'₂ 'nia'₂ ja₁jaun₂, séi'₄ 'nia'₂ 'liog₂ tag'₅₄ co₂'nió'₄ jmó'₂ 'nia'₂ léi₄ co₂jaun₂ ma₂le₁cán'₄ dsa₂ 'éi₂ guioin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jaun₂ ca₂'uɨn₂ bá₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ në́₃, ca₂i₃léin₂ ca₂i₁'ë́₄ jág₁ a₂dsɨ₃quén'₅ dsɨ́₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jaun₂ qui₂ca₂'uɨ́in'₂ juɨn₅ je₂na'₅₄, qui₂ca₂tsɨ́in₂ no'₅₄ juɨn₅ dsa₂ dso'₅₄, qui₂ca₂jme₃'lóin₂ dsa₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ca₂rë₃ŋi₅ Rag₅₄ Herodes jág₁ a₂'ei₅ quió'₅ Jesús, ia₁ ca₂le₂con₂ bá₄ ma₂le₁ŋi₅ dsa₂ 'e₂ a₂jmo₅ Jesús ŋɨ₂₃. Jaun₂ juá'₂ Rag₅₄ Herodes: ―Ma₂ca₂jen'₅₄ Juan₅₄, dsa₂ i₂jme₁chon₅ dsa₂ jmɨg₂; 'uɨg₅₄ jaun₂ quɨ'₅₄ jmɨg₄ jmo₂₃ 'e₂ a₂jmo₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","I₂lɨn₅₄ guë'₂ dsia₅ táng₃: ―Elías bá₄ 'éi₂ ŋɨ₅. La₁ i₂sián'₂ guë'₂ juá'₂: ―Jan₂ i₂chen₄ quián₅ Diú₄ bá₄ 'éi₂, juɨ₁lia'₂ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jme₁ca₂nág₂ Rag₅₄ Herodes, jaun₂ ca₂juá'₂: ―Juan₅₄ bá₄ në₅ ŋɨ₅, i₂ca₂'nia₃ dsa₂ dsɨ₂lag₄, 'éi'₃ quió₃ jniá₂. Ma₂ca₂jein'₅₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ia₁ 'ŋiog₅ bá₄ Herodes ma₂jmo₅ 'éi'₃ le₂jŋiá₅ a₂ca₂i₁chan'₅₄ dsa₂ Juan₅₄ ca₂i₁tio'₂ né'₃ 'má₃ rë₂'ŋei'₅₄ 'uɨg₅₄ quió'₅ 'io₅₄ Herodías i₂lɨ́n₅ dsɨ₂i₂gu₂ Fe₂li₄ rɨin'₅₄. La₁ Herodes në́₃ ma₂jmo₂₃ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ia₁ jme₁ma₂qui₂ma₂juá'₂ Juan₅₄ tsɨ́'₅ Herodes: ―Tsá₃ 'i₄ 'éi'₃ jmó'₂ quiáng'₂, 'io₅₄ quián₅ dsó₂ rɨ́ng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","'Uɨg₅₄ jaun₂ jme₁'i₄ 'nei₂ dsɨ́₅ 'io₅₄ Herodías jɨ́in₂ Juan₅₄. Jaun₂ jme₁'nio₃ jŋag'₃, la₁ tsá₃ ca₂dsó'₂ juɨ₅ 'a₂ lia'₂ jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ia₁ jme₁ŋi₅ bá₄ Rag₅₄ Herodes a₂lɨ́n₅ Juan₅₄ dsa₂ dsen₃, jaun₂ jme₁jme₂go₃ bá₄; jaun₂ jme₁jmo₂₃ 'í₁. Lia'₂ con'₂ jme₁nag₂₃ jág₁ quió'₅ Juan₅₄, jme₁të₂tsɨin'₅₄ tsá₃ 'e₂ ŋi₅ jmo₃, la₁ 'ŋio₂ bá₄ dsɨ́₅ jme₁nag₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","La₁ ca₂cuɨn₃ jmɨg₄ në́₃ jme₁ca₂jmo₃ Herodes jmɨg₄ a₂ca₂dsɨ́'₃ ŋi₂: ca₂jmo₃ má₃, ca₂të́'₃ dsa₂ can'₅₄ con'₂ dsa₂ i₂jmo₅ 'éi'₃ juɨg₂, i₂lɨ́n₅ juɨg₅₄ 'lióg₂ quiáin₅ në́₃, ca₂le₃jɨ́n₃ guë́₄ con'₂ dsa₂ dsen₅₄ quián₅ juɨg₂ ja₁tén₄ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jaun₂ ca₂guan₃ ja₁mɨ́g₄ Herodías ja₁niog₅ jmɨg₄, jaun₂ ca₂dsáin₂. A₂jaun₂ ca₂të́₂ dsɨ́₅ Rag₅₄ Herodes, ca₂le₃jɨ́n₃ dsa₂ i₂té₄ i₂tion'₅₄ guë́'₅ quiain'₅₄ në́₃. Jaun₂ ca₂juá'₂ rag₅₄ ca₂tsɨ́'₃ 'io₅₄ bë'₅₄ 'éi₂: ―Mɨ₄ ca₂le₃jë́₃ 'e₂ 'niog'₂, jaun₂ cuë₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jaun₂ ca₂cuë₃ jág₁ quió'₅ ca₂le₃jë́₃ ca₂'ɨin₃ Diú₄, ca₂juá'₂: ―Chi₂jua'₂ 'e₂ caun₂ a₂mɨ́'₁ 'ne₂, cuë₅₄ bá₄ jniá₂, jŋia'₅₄ ca₂dsio₄ 'uë₃ ja₁gong₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jaun₂ ca₂o₃'ɨ́n₃ 'io₅₄ bë'₅₄ 'éi₂ ca₂i₁ŋag₁₂ chog₅₄, ca₂i₁jua'₄: ―¿'E₂ mɨ₅₄ jniá₂, mag₅₄? Jaun₂ ca₂juá'₂ chog₅₄: ―Mɨ₄ mɨ₂dsi₄ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jaun₂ ca₂'í₃ táng₃ 'éi₂ dsɨ₂juɨ₅ ja₁guá₄ rag₅₄, jaun₂ ca₂juá'₂: ―'Nio₃ cuë́'₁ të₂në₃ mɨ₂dsi₄ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂, a₂'i₄ 'ŋió'₃ uɨng₅. ");
INSERT INTO cntNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jme₁ca₂nág₂ rag₅₄ jág₁ në₅, ca₂jén₂ dsɨ́₅. La₁ tsá₃ a₂ŋi₅ jmo₃, ia₁ ma₂në₂cuë₃ jág₁ quió'₅ le₂jŋiá₅ a₂cuë₃ chi₂jua'₂ 'e₂ 'nio₃ 'io₅₄ 'éi₂, ton'₂ ia₁ ma₂në₂néi₂ a₂mei₅₄ quiáin₅ i₂tián'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jaun₂ dsɨ₂juɨ₅ jaun₂ ca₂chein₃ jan₂ 'lióg₂ a₂dsɨ₃quián₂ mɨ₂dsi₄ Juan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jaun₂ ca₂ŋó₃ 'lióg₂ juɨ₅ 'ŋió'₃ 'né₅ 'má₃, jaun₂ ca₂i₁qui'₂ dsɨ₂lag₄ Juan₅₄, jaun₂ quian₅ rë₂'i₄ 'ŋió'₃ uɨng₅, ca₂cuë́'₃ 'io₅₄ 'éi₂. Jaun₂ 'io₅₄ në́₃ ca₂gue₃, jaun₂ ca₂i₁cuë'₂ táng₃ chog₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jme₁ca₂rë₃ŋi₅ dsa₂ i₂jme₁quian'₅₄ Juan₅₄, jaun₂ ca₂o₃léin₂, ca₂tág₃ 'lag₄, jaun₂ ca₂i₁'ó₄. ");
INSERT INTO cntNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Cang₂ jaun₂ ca₂o₃len₃ dsa₂ i₂chen₄ 'éi₂, ca₂ŋɨi'₂ táng₃ quiain'₅₄ Jesús, jaun₂ ca₂dsia₃ 'e₂ niog₅ ca₂jmo₃ ja₁i₁lein₅₄, 'a₂ lia'₂ i₂ca₂jme₁tɨin₂₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jaun₂ ca₂juá'₂ Jesús: ―I₂nó'₅ 'nia'₂ con'₂ guiong'₅₄ caun₂ ja₁co₂'ŋiog₅, i₂jŋia₄ ca₂tiá₂. Ia₁ juɨn₅ lɨn₃ dsa₂ i₂o₂lén₂, lia'₂ i₂dsɨ₂len₃ në́₃, ca₂lia'₂ jŋia'₅₄ tsá₃ cuɨn₅ jmɨg₄ guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jaun₂ në́₃ ca₂tóin'₂ tsɨ₁mu₅ ca₂i₃léin₂ caun₂ ja₁lë́₄ co₂'ŋiog₅ con'₂ guioin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Jaun₂ qui₂ca₂'uɨn₂ dsa₂ le₂caun₂ le₂caun₂ juɨg₂, i₃léin₂ co₂chi'₅₄ juɨ₅ tag₅₄ a₂'ein₂₃ Jesús. Jaun₂ jŋiái₅ bá₄ dsi₃léin₂ lia'₂ con'₂ guë́₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jme₁ca₂sión₃ Jesús 'ŋió'₃ tsɨ₁mu₅, ca₂jɨ́in₂ juɨn₅ lɨn₃ dsa₂, ma₂tion'₅₄ le₁jŋiog₅, ca₂tá'₂ ŋéi₂ dsɨ́₅ dsa₂ 'éi₂, ia₁ i₂nio₄ dsa₂ lia'₂ jë₁i₂nio₄ já'₂ cha'₂ i₂tsá₃ juɨg₅₄ chan₂, jiog₃, jmo₃ 'í₁. Jaun₂ ca₂jme₃lióg₃ ca₂jme₃tɨin₂₃ dsa₂ 'lióng₂ lɨn₃ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jme₁ca₂'láu₂ jaun₂ ca₂o₃lén₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂juá'₂: ―Caun₂ ja₁co₂'ŋiog₅ bá₄ la₂, ton'₂ ca₂'láu₂ guë́₄ má'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'Ei'₂ jág₁ dsa₂, ia₁jaun₂ dsɨ₃lein₅ dsɨ₃'nióg₂ a₂guë́'₃ lia'₂ con'₂ juɨg₂ ja₁nau₂ ma₂quián₅ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jaun₂ ca₂ŋag₃ Jesús: ―Cuë'₅₄ 'nia'₂ dsa₂ a₂guë́'₃. Jaun₂ ca₂ŋag₃ táng₃ 'éi₂: ―¿Lé₂ le₃dsɨ₁liá₄ tɨn₃ 'ŋiá₂-láu₂ 'éi'₃ denario i₁ŋí'₄ ia₁jaun₂ dsio'₂ a₂guë́'₃ dsa₂? ");
INSERT INTO cntNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jaun₂ ca₂juá'₂ táng₃ Jesús: ―O₂jag₄ 'nia'₂ je₂liá'₂ i₁ŋí'₄ 'i₄ quián'₂ 'nia'₂. Jaun₂ ca₂i₁jag₅₄ 'éi₂ jaun₂ në́₃, jaun₂ ca₂o₃léin₂ táng₃, ca₂juá'₂: ―'Ŋiá₂ i₁ŋí'₄ bá₄ 'i₄, on₃ guë'₂ i₁ju₁. ");
INSERT INTO cntNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jaun₂ ca₂chein₃ jág₁ a₂tian'₃ dsa₂ jma₃co₂niói'₃ ne₄ ŋi₂ma'₂ rë'₂, ");
INSERT INTO cntNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","jaun₂ ca₂tián'₂ dsa₂ jma₃co₂niói'₃ ja₁lë́₂ caun₂ 'ŋiá₂-lón₂, i₂ca₂tián'₂ jma₃co₂nió'₃ jma₃të₂lón₃-guián₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jaun₂ në́₃ ca₂jŋa'₃ Jesús le₃'ŋiá₂ i₁ŋí'₄, le₃on₃ guë'₂ i₁ju₁ në́₃, ca₂jág₃ guei'₅₄ i₂juɨ́g₃, ca₂cuë́'₃ ti₁'mag'₄ Diú₄. Jaun₂ ca₂jmo₃ le₁'nau₅₄ i₁ŋí'₄, jaun₂ guë́₄ ca₂cuë́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, ia₁jaun₂ dsia₃ 'éi₂ ne₄ dsa₂. Ján₃ guë'₂ ca₂jmo₃ dsióg₁ quió'₅ i₁ju₁ on₃ 'éi₂, ca₂cuë́'₃ ca₂le₃jɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jaun₂ le₃jɨ́n₃ dsa₂ ca₂guë́'₃ ca₂lia'₂ ca₂rë₃tain₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jaun₂ ca₂cág'₃ bá₄ guë́₄ dsa₂ guia₃-tɨ́n₂ tsɨ₁mɨ'₂ 'nau₅₄ i₁ŋí'₄, a₂ca₂chóng₃ quió'₅ i₁ju₁ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","'Ŋiá₂ mei₅ jme₁lë́₂ ca₂le₃jɨ́n₃ dsa₂ ŋe'₂ i₂ca₂guë́'₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jaun₂ dsɨ₂juɨ₅ le₂jaun₂ ca₂jmo₃ Jesús 'éi'₃ a₂i₃ton'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ 'ŋió'₃ tsɨ₁mu₅, jaun₂ jŋiá₅ de'₂ 'éi₂ ŋɨ́₃ jmɨg₂ con'₂ guë́₄ 'ŋiog₅, a₂dsi₁léin₂ Betsaida, të₁lia'₂ 'í₁ guë́₄ 'ŋiog₅ 'ág'₃ jág₁ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jme₁ma₂ca₂lë₃ 'ág'₅ jág₁ dsa₂, ca₂ŋó₃ jaun₂ në́₃ juɨ₅ má'₂ i₁chi₂i₁lein'₁ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jaun₂ con'₂ ca₂tó'₂ nei₂ dé₄, ma₂ŋó₅ tsɨ₁mu₅ dsi₂jo₂ jmɨ₁ŋí'₄, 'ŋiog₅ guë'₂ Jesús jaun₂ bá₄ 'ein₅₄ 'uë₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jaun₂ ca₂jág₃ Jesús 'ŋio₅ cán₂ ta₁ tioin'₅₄ a₂jein₂₃ nɨ₁'ma₂ a₂gag₂ jmɨg₂, ia₁ 'liog'₂ dsí₂ le₂ca'₃. Jaun₂ con'₂ le₁né₃ të₂le₃ ca₂jnia₃, ca₂jme₃quián₃ Jesús ŋɨ₂₃ ne₄ jmɨg₂ ja₁ŋó₄ tsɨ₁mu₅. Jaun₂ ca₂jmo₃ në₂jag₄ bá₄ i₂jme₁ma₂ŋɨ́₃ co₂dsau₅ ja₁tion'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jme₁ca₂jág₂ jóin'₅ ŋɨ₂₃ ne₄ jmɨ₁ŋí'₄, dsa₂ 'lɨn'₅₄ bá₄ 'éi₂ lɨ́in₂, jaun₂ ca₂tóin'₂ co₂mɨ'₅₄ ca₂guió'₃, ");
INSERT INTO cntNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ia₁ ca₂le₃jɨ́in₃ bá₄ ca₂rë₃gó'₅ 'ŋio₅ lɨn₃ jme₁ca₂jág₂. La₁ dsɨ₂juɨ₅ bá₄ ca₂juá'₂ Jesús: ―¡Tiá₂ dsia₄ 'nia'₂ 'au'₂; jniá₂ bá₄ la₂, tsá₃ lë₁jmo₂ 'nia'₂ gang'₃! ");
INSERT INTO cntNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jaun₂ ca₂uɨ́g₂ 'ŋió'₃ tsɨ₁mu₅ ja₁tion'₅₄ 'éi₂. Jaun₂ ca₂'ág₂ táng₃ tei₄ ca₂jŋia'₃ dsí₂, jaun₂ i₃gó'₃ dsɨ́₅ 'éi₂ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ia₁ tsá₃ 'e₂ ca₂ŋɨ́'₂ dsɨ́₅ dsa₂ 'éi₂ juɨ₁lia'₂ léi₄ juë'₂ a₂ma₂në₂jág₃ jmo₅ Jesús quian'₅₄ i₁ŋí'₄, në₂jag₄ bá₄ cha₂ a₂jmo₅ jnág₅ a₂tsá₃ rë₂ŋɨ́i'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jme₁ca₂'ain₂ jmɨg₂, ca₂dsi₃léin₂ 'uë₃ Genesaret. Ja₁jaun₂ ca₂'néi₂ tsɨ₁mu₅ chei'₅₄ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Dsɨ₂juɨ₅ jme₁ca₂'uɨin₂ tsɨ₁mu₅, co₂tan₅₄ lia'₂ ca₂rë₃cuɨn₅ bá₄ dsa₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jaun₂ ca₂i₁nioi₁₂ co₂chi'₅₄ le₂tan₅₄ juɨg₂ te₁'i₁ ma₂quián₅ jaun₂. Jaun₂ ca₂i₁quian₅₄ dsa₂ dsa₂ i₂le₁dso'₅₄ quian'₅₄ tsɨ₁jein₁ 'a₂ guë́₃ já'₄ 'en₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ca₂le₂con₂ ja₁jme₁ŋɨ₅ Jesús, jë₁ma₂'í₅ jë₄ juɨg₂, jë₄ ciudad, o₃ le₂'i₄ juɨ₅ ja₁ŋó₄ 'e₂, jme₁qui₂dsɨ₂jŋia₃ dsa₂ dsa₂ dso'₅₄, qui₂ca₂dsiog₃ ja₁niog₅ 'ma'₅₄. Qui₂ca₂mɨ₃ dsa₂ tsá₃ a₂nag₅₄ o₁jŋia'₅₄ a₃tag₄ tsɨn'₅₄ bá₄ cuë₃ jmɨg₄ a₂nɨ́i'₃. Jaun₂ ca₂le₃jɨ́n₃ dsa₂ dso'₅₄ i₂qui₂ca₂nɨ́'₃ tsɨn'₅₄ Jesús, qui₂ca₂'lóin₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jaun₂ në́₃ dsa₂ fariseos quian'₅₄ i₂lɨn₅₄ të₅juá'₅ i₂ja₂lén₂ Jerusalén, ca₂o₃léin₂ ca₂ŋɨi'₂ ja₁'en₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ca₂jág₃ dsa₂ 'éi₂ ca₂jɨ́in₂ i₂lɨn₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ a₂guë́'₅ të₃ tsá₃ “le₁jë́₃” gu₂, tsá₃ jme₂ti₃ jua'₅₄ a₂rang₂₃ lia'₂ con'₂ lë́₅ 'éi'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ia₁ ca₂le₃jɨ́n₃ dsa₂ fariseos, quian'₅₄ ca₂le₃jɨ́n₃ dsa₂ chan₂ Judea në́₃, jme₂ti₃ lia'₂ con'₂ lë́₅ tag₄ chí'₅ quió'₅ dsa₂ can'₅₄, a₂tsá₃ guë́'₃ në₁jua'₂ tsá₃ ma₂në₂rang₃ 'lióng₂ ráun₂ gu₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jë₁ma₂o₃lein₃ 'ma'₅₄, tsá₃ guë́'₃ në₁jua'₂ tsá₃ ma₂në₂jme₃ti₃ con'₂ tag₄ chí'₅ a₂rang₃ quió'₅. Jaun₂ 'lióng₂ bá₄ guë́₄ tag₄ siá'₂ a₂jme₂ti₃ dsa₂ juɨ₁lia'₂ a₂rang₅ dsa₂ nɨ₁vaso, juɨ₁lia'₂ a₂rang₅ dsa₂ nɨ₁taza, nɨ₁dsɨg₁, tsɨ₁cama në́₃.) ");
INSERT INTO cntNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jaun₂ në́₃ ca₂ŋag₃ dsa₂ fariseos quian'₅₄ të₅juá'₅, ca₂ŋɨ́i'₃ Jesús: ―¿'E₂ lë₃ tsá₃ jme₂ti₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáng'₂ tag₄ chí'₅ quió'₅ dsa₂ can'₅₄? Guë́'₅ bá₄ të₃ tsá₃ ma₂në₂rang₃ gu₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jaun₂ ca₂ŋag₃ 'éi₂: ―Dsón'₂ bá₄ dsau₅ ca₂juá'₂ Isaías ca₂'ɨin₃ 'nia'₂ dsa₂ i₂lë₁jmo₅-dsáu₅ o₁ne₁, juɨ₁lia'₂ tio'₅₄ ne₄ Si₂: Dsa₂ juɨg₂ la₂ jme₂juag'₂ jniá₂ jmá'₃ lia'₂ quian'₅₄ mɨ₂'o₅₄ bá₄, la₁ia₁ uɨ́ng₂ bá₄ 'i₄ dsɨ́₅ ja₁con₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","La₁ tsá₃ 'e₂ ta₁ tí₄ a₂jme₂juag'₂, ia₁ jág₁ a₂jme₂tag₂₃, 'éi'₃ a₂lë₁lë́₅ quió'₅ dsa₂ mɨ₂güɨ́g₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ia₁ co₂dsia₅ ma₂ca₂tí'₃ bá₄ 'nia'₂ 'éi'₃ quió'₅ Diú₄, a₂ma₂ja₂nóg'₅ chan'₅₄ tiá₂ 'éi'₃ tag₄ quió'₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ca₂juá'₂ ján₃: ―'Ŋio₅ tɨn'₂ 'nia'₂ jmo'₂ cau₅ 'éi'₃ quió'₅ Diú₄, a₂jme₂tí'₁ 'nia'₂ tag₄ quián'₂ 'nia'₂ guiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ia₁ ca₂juá'₂ Moisés a₂jme₃gan₃ dsa₂ chog₅₄-jmei₂. Jaun₂ juá'₂, chi₂jua'₂ 'ein₂ ca₂juá'₂ uɨg₅ ne₄ chog₅₄-jmei₂, juɨ₁join₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","La₁ 'nia'₂ në́₃ juá'₂ a₂lé₂ le₃juá'₂ dsa₂ tsɨ́'₃ chog₅₄-jmei₂: “Tsá₃ 'nia'₂ lé₂ le₃jme₁'ong₁₂, ia₁ ca₂le₃jë́₃ a₂cha₂ quió₃ a₂lë́₅ Corbán”, (co₂'nió'₄ a₂juá'₂, a₂ma₂lë́₅ quió'₅ Diú₄ bá₄). ");
INSERT INTO cntNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Në₁jua'₂ le₂në₅ jaun₂ tsá₃ ma₃cuë'₂ 'nia'₂ jmɨg₄ a₂jme₃'on₅₄ guë́₄ dsa₂ chog₅₄-jmei₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jaun₂ le₂në₅ bá₄ tsá₃ ma₃'e₂ quen₅ jág₁ quió'₅ Diú₄, jmo'₂ 'nia'₂, të₂le₃ quian'₅₄ tag₄ a₂chí'₅, a₂ca₂ŋag₃ dsa₂ can'₅₄ quiáng'₂. 'Lióng₂ bá₄ guë́₄ a₂siá'₂ jmo'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jaun₂ ca₂të́'₃ Jesús dsa₂, ca₂juá'₂: ―Nei₂ 'nia'₂ dse₃ ca₂le₃jɨ́ng'₃ a₂juá'₄ jniá₂ la₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","'I₁caun₂ a₂dsɨ₂to'₅₄ quió'₅ dsa₂, on₃jua'₅₄ a₂jaun₂ jmo₅ a₂rë₂'iog₅ jme₂dsí₂ quió'₅. Cosa a₂'uë₂ dsɨ́₅ dsa₂ guioin₅₄, a₂jaun₂ bá₄ jmo₅ a₂rë₂'iog₅ jme₂dsí₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jme₁o₂'ɨ́in₃ jɨn₄ dsa₂, ŋái'₃ dsi₂néi₂, jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ 'e₂ jág₁ dsau₅ jáng'₅ jág₁ ca₂cuë́'₃ dsa₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jaun₂ ca₂juá'₂: ―¿Ján₃ bá₄ tsá₃ ŋɨ́'₂ 'nia'₂ a₂juá'₅ jniá₂? Ca₂le₃jë́₃ 'e₂ a₂guë́'₅ dsa₂, on₃jua'₅₄ a₂jaun₂ jmo₅ a₂rë₂'iog₅ jme₂dsí₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ia₁ on₃jua'₅₄ dsɨ́₅ dsa₂ dsɨ₂to'₅₄ a₂guë́'₅. Rë₂tú'₅ bá₄ dsa₂ dsɨ₂to'₅₄ a₂jaun₂. Cang₂ jaun₂ dsɨ₂'uë'₅₄ táng₃ dsa₂ ca₁'né₄. (Ca₂'ë₃ co₂'nió'₄ a₂le₁jë́₃ ca₂le₃jë́₃ bá₄ má₃, jme₁ca₂juá'₂ le₂në₅). ");
INSERT INTO cntNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ca₂juá'₂ ján₃: ―Ca₂le₃jë́₃ a₂'uë₂ dsɨ́₅ dsa₂, a₂jaun₂ bá₄ a₂jmo₅ a₂rë₂'iog₅ jme₂dsí₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Të₂dsɨ́₅ bá₄ dsa₂ 'uë₂ ca₂le₃jë́₃ ne₅₄ a₂'lɨg'₅₄: juɨ₁lia'₂ a₂lë́₅ dsɨ́₅ dsa₂ niói'₃ jág₁ quian'₅₄ dsa₂ i₂tsá₃ lɨ́n₅ dsɨ₂i₂gu₂; a₂'ang₅ dsa₂; a₂jme₂dsian₅ dsa₂ rɨin'₅₄; ");
INSERT INTO cntNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","a₂'ɨ́n₅ dsɨ́₅ dsa₂ jmo₃ quió'₅ a₂cha₂ quió'₅ rɨin'₅₄; 'e₂ caun₂ a₂tsá₃ dsi₂ten₅₄ jmái'₂ rɨin'₅₄; a₂qui₂jme₂gain₂₃ rɨin'₅₄; a₂jmo₂₃ o₂guí'₃ 'lɨg'₅₄, a₂jmo₂₃ uɨg₅ dsɨ́₅, a₂qui₂chi₂'ɨn₅ dsa₂ rɨin'₅₄; a₂jme₂róin₂ jmái'₂ dsa₂; ca₂le₃jë́₃ guë́₄ 'e₂ a₂tsá₃ 'en₅₄ dsɨ́₅ dsa₂ lɨ́in₅. ");
INSERT INTO cntNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ca₂le₃jë́₃ a₂në₅, të₂dsɨ́₅ bá₄ dsa₂ lë́₂, a₂në₅ bá₄ a₂jmo₅ a₂rë₂'iog₅ jme₂dsí₂ quió'₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","A₂'ein₅₄ ja₁jaun₂, ca₂o₃'ɨ́in₃ ŋó₃ 'uë₃ ma₂quián₅ juɨg₂ Tiro. Jaun₂ ca₂'í₃ con'₂ të₃co'₅₄ bá₄ dsi₂néi₂ quió'₅ dsa₂ ja₁jaun₂. La₁ tion₅₄ bá₄ ca₂rë₃lí'₄ dsa₂, tsá₃ ma₃ca₂cuɨn₃ jmɨg₄ a₂'mai₃. ");
INSERT INTO cntNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Dsɨ₂juɨ₅ jaun₂ ca₂nág₂ chog₅₄ jan₂ 'io₅₄ bë'₅₄ i₂'en₅₄ jme₂dsí₂ 'lɨn'₅₄. Ca₂dsióg₃, jaun₂ ca₂chi₃jné₃ ne₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","'Éi₂ jme₁lɨ́n₄ jan₂ 'io₅₄ griega, i₂chan₂ Sirofenicia. Jaun₂ ca₂mɨ₃ ca₂tsɨ́'₃ 'éi₂ a₂dsɨ₃dsein₂₃ je₂na'₅₄ quió'₅ chi'₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jaun₂ ca₂ŋag₃ Jesús: ―Juɨ₁le₂tan₅₄ de'₂ jŋiá₅ chi'₂ quiáng₃; ia₁ tsá₃ dsi₂ten₅₄ jua'₅₄ a₂jŋiá'₄ jniá₂ i₁ŋí'₄ quió'₅ chi'₂, a₂ton₅₄ ne₄ dsɨ₂jɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jaun₂ ca₂ŋag₃ táng₃ 'io₅₄ 'éi₂: ―Dsón'₂ bá₄ dsau₅, Te₁gui'₅₄, la₁ia₁ le₂jiog₅ dsɨ₂jɨ'₅₄ bá₄ guë́'₅ né'₃ nɨ₁mesa 'nau₅₄ a₂tsɨ₂séi'₂ guein₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jaun₂ ca₂ŋag₃ táng₃: ―Dse₃ në₂ŋag'₅₄. Ma₂lé₂ guang'₅₄. Ma₂o₂'ɨ́n₃ bá₄ je₂na'₅₄ i₂jme₁'en₅₄ të₂dsɨ́₅ chi'₂ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jaun₂ ca₂ŋái'₃ bá₄; jme₁dsiáin'₃, ca₂jɨ́in₂ ja₁mɨ́g₄ roin₂₃ tei₄ ne₄ tsɨ₁cama, ma₂o₂'ɨ́n₃ bá₄ je₂na'₅₄ të₂dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ca₂o₃'ɨ́n₃ táng₃ Jesús juɨg₂ Tiro, ca₂ŋɨ́i₃ juɨ₅ juɨg₂ Sidón, jaun₂ ca₂dsióg₃ chei'₅₄ jmɨ₁ŋí'₄ Galilea, jaun₂ ca₂'í₃ 'uë₃ Decápolis. ");
INSERT INTO cntNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ja₁jaun₂ ca₂o₃jŋia₃ dsa₂ jan₂ dsa₂ i₂tsá₃ lɨn₄ lé₂ dsia₃ jág₁. Jaun₂ ca₂mɨ₃ dsa₂ a₂quióg₃ Jesús gu₂ ne₄ quió'₅ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jaun₂ ca₂jiog₃ Jesús ca₂jŋiai₃ dsa₂ 'éi₂ caun₂ ja₁co₂'ŋiog₅, jaun₂ ja₁jaun₂ ca₂tiá₂ chi₁gú₃ rë₂gua₄ dsa₂ 'éi₂, jaun₂ ca₂'ŋéi₃ chi₁gú₃, jaun₂ ca₂nɨ́i'₂ le₁tsɨ'₂ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jaun₂ ca₂chóg'₃ ne₅₄ guei'₅₄ i₂juɨ́g₃, ca₂choin₃ dsɨ́₅, jaun₂ ca₂juá'₂: ―¡Efata! ―co₂'nió'₄ a₂juá'₂: ¡Nia₄! ");
INSERT INTO cntNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jme₁ma₂në₂juá'₂ le₂në₅, ca₂niá₃ rë₂gua₄ mɨ₂'o₄ dsa₂ 'éi₂ në́₃, ca₂'lóin₂, ca₂dsia₃ dse₃ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ ca₂le₃jɨ́n₃ dsa₂ i₂jme₁tion'₅₄ a₂tsá₃ 'ein₂ tsɨ́'₃. La₁ të₂le₃ i₂juɨ'₂ guë́₄ ca₂dsia₃ bá₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jaun₂ 'ŋio₅ lɨn₃ ca₂i₃gó'₃ dsɨ́₅ dsa₂ jme₁ca₂rë₃ŋi₅. Jaun₂ qui₂ca₂dsia₃ dsa₂: ―Dse₃ bá₄ ca₂le₃jë́₃ a₂jmo₂₃. Jmo₂₃ a₂nag₅ dsa₂ i₂güɨn₄, lia'₂ dsa₂ i₂con₄ në́₃, lé₂ le₃dsia₃ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jmɨg₄ jaun₂ ca₂ŋɨ'₂ juɨn₅ lɨn₃ dsa₂. Ia₁ tsá₃ ma₃'e₂ cha₂ guë́'₃, jaun₂ ca₂të́'₃ Jesús chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ŋéi₂ dsɨ₃ jɨng₅₄ dsa₂ në₅, ia₁ ma₂'nɨ₅ jmɨg₄ tioin'₅₄ ja₁lá₃ quiong'₅₄, tsá₃ ma₃'e₂ cha₂ guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Në₁jua'₂ dsiain'₅₄ guë'₂ jniá₂ quió'₅ të₃ tsá₃ ma₂në₂guë́'₃, 'uáin₂ bá₄ le₂'i₄ juɨ₅, ia₁ uɨ́ng₂ bá₄ ja₂lén₂ i₂lɨn₅₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―¿A₂já'₄ bá₄ lé₂ le₃dsɨ₁'nióg₂ ca₂le₃jë́₃ i₁ŋí'₄ a₂'nió'₅ le₂tan₅₄ dsa₂ në₅ ja₁co₂'ŋiog₅ la₂? ");
INSERT INTO cntNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―¿Je₂liá'₂ i₁ŋí'₄ 'i₄ quián'₂ 'nia'₂? ―Guio₃ bá₄ ―ca₂ŋag₃. ");
INSERT INTO cntNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jaun₂ ca₂jmo₃ Jesús 'éi'₃ a₂tian'₃ dsa₂ ca₂le₃jɨ́in₃ 'uë₃. Jme₁ma₂chan'₂ le₂guio₃ i₁ŋí'₄, ca₂cuë́'₃ ti₁'mag'₄ Diú₄, jaun₂ ca₂jmo₃ le₁'nau₅₄, jaun₂ guë́₄ ca₂cuë́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, ia₁jaun₂ 'éi₂ dsia₃ ne₄ dsa₂. Jaun₂ le₂jaun₂ bá₄ ca₂jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jme₁tion'₅₄ on₃-ún₂ i₁ju₁ pí'₁, jaun₂ ca₂jme₃jŋiói₃ quió'₅ 'éi₂ ján₃, jaun₂ ca₂jmo₃ 'éi'₃ a₂dsión'₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jaun₂ qui₂ca₂guë́'₃ ca₂le₃jɨ́n₃ dsa₂ ca₂lia'₂ ca₂rë₃tain₅₄. Jme₁ca₂lë₃ jaun₂, ca₂cág'₃ dsa₂ guio₃ tsɨ₁mɨ'₂ 'nau₅₄ a₂ca₂chóng₃. ");
INSERT INTO cntNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ca₂le₃jɨ́n₃ dsa₂ 'éi₂ jme₁lë́₂ con'₂ quén₂ mei₅. Jaun₂ guë́₄ qui₂ca₂'ág'₃ jág₁ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dsɨ₂juɨ₅ le₂jaun₂ ca₂'í₃ táng₃ 'ŋió'₃ tsɨ₁mu₅ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, ca₂dsi₃léin₂ 'uë₃ Dalmanuta. ");
INSERT INTO cntNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jaun₂ ca₂o₃lén₂ dsa₂ fariseos ca₂jme₃lióg₃ ca₂tsɨ́in₂ quiong'₅₄, a₂mɨ₂₃ jmo₃ 'éi₂ caun₂ léi₄ juë'₂ a₂já₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jaun₂ ca₂chon₃ Jesús dsɨ́₅ 'ŋio₅ lɨn₃, jaun₂ ca₂juá'₂: ―¿'E₂ bá₄ lë₃ 'nio₃ dsa₂ chan₂ jmɨg₄ në₃ a₂jmo₅₄ jniá₂ léi₄? A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, tsá₃ léi₄ jaun₂ le₃guéi'₁ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tión₂ jaun₂ bá₄ dsa₂ 'éi₂, ca₂'í₃ táng₃ 'ŋió'₃ tsɨ₁mu₅ ca₂ŋó₃ le₃'ŋo'₅₄ jmɨ₁ŋí'₄ le₃ó₃. ");
INSERT INTO cntNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ca₂'en₃ dsɨ́₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ cán₂ a₂guë́'₃, jŋia'₅₄ lia'₂ caun₂ i₁ŋí'₄ bá₄ quian₅ i₃léin₂ 'ŋió'₃ tsɨ₁mu₅. ");
INSERT INTO cntNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jaun₂ ti₁ca₂néi'₂ Jesús jág₁, ca₂juá'₂: ―Të₃ŋi'₅₄ quián'₂ 'nia'₂ quian'₅₄ juá'₅ quió'₅ dsa₂ fariseos, quian'₅₄ jág₁ quió'₅ Herodes në́₃. Ia₁ lë́₅ lia'₂ lë́₅ juɨ₁ levadura. ");
INSERT INTO cntNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jaun₂ ca₂dsia₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quian'₅₄ rɨin'₅₄: ―'An₁ juá'₂ le₂në₅ ia₁ tsá₃ i₁ŋí'₄ cha₂ quián₂ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ca₂rë₃lí'₄ bá₄ Jesús jág₁ a₂dsia₅ 'éi₂ i₃léin₂, jaun₂ ca₂juá'₂: ―¿'E₂ lë₃ juá'₂ 'nia'₂ a₂tsá₃ i₁ŋí'₄ cha₂ quián'₂ 'nia'₂? ¿'E₂ lë₃ ŋɨ́₄ tsá₃ rë₂ŋɨ́'₂ 'nia'₂? ¿O₃ a₂tsá₃ len'₅₄ 'e₂ 'nia'₂, o₃ a₂cang₄ dsei'₂ 'e₂ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿O₃ bá₄ a₂lë₁tio'₅₄ mɨ₂ne'₅₄ 'e₂ 'nia'₂, la₁ tsá₃ jniag'₃? ¿O₃ bá₄ a₂lë₁le₁dsɨ₅₄ bá₄ rë₂guá'₂ 'nia'₂, la₁ tsá₃ nag'₂ guë'₂ 'nia'₂? ¿O₃ bá₄ tsá₃ ma₃dsá₂ 'e₂ 'au'₂ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Lia'₂ con'₂ jme₁ca₂dsio'₄ jniá₂ quian'₅₄ 'ŋiá₂ i₁ŋí'₄ bá₄ ca₂lɨn₅ ca₂guë́'₃ con'₂ 'ŋiá₂ mei₅ dsa₂, ¿je₂liá'₂ mɨ'₂ ca₂lë₃ nɨ₁'nau₅₄ a₂ca₂chóng₃ guë́₄ ca₂cag'₅₄ 'nia'₂? Jaun₂ ca₂ŋag₃ 'éi₂: ―Guia₃-tɨ́n₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Con'₂ siá'₂ táng₃, lia'₂ con'₂ jme₁ca₂dsio'₄ jniá₂ guio₃ i₁ŋí'₄ ca₂lɨn₅ ca₂guë́'₃ quén₂ mei₅ dsa₂, ¿je₂liá'₂ mɨ'₂ 'nau₅₄ a₂ca₂chóng₃ ca₂cag'₅₄ guë́₄ táng₃ 'nia'₂? Jaun₂ ca₂ŋag₃ táng₃ 'éi₂: ―Guio₃. ");
INSERT INTO cntNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jaun₂ ca₂juá'₂ táng₃: ―¿Tsa₁ rë₂len'₅₄ bá₄ guë́₄ 'nia'₂ jaun₂? ");
INSERT INTO cntNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jaun₂ dsi₃léin₂ juɨg₂ Betsaida. Jaun₂ ca₂o₃jŋia₃ dsa₂ jan₂ dsa₂ ten₄, jaun₂ ca₂mɨ₃ dsa₂ a₂téi₂ gu₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jaun₂ në́₃ ca₂jŋa'₃ gu₂ dsa₂ ten₄ 'éi₂, ca₂jiog₃ juɨ₅ 'nɨ'₂ juɨg₂. Jaun₂ ja₁jaun₂ ca₂tsáng₂ jmɨ₁'ë́'₅ quió'₅, jme₁ne₁ dsa₂ 'éi₂, ca₂téi₂ gu₂, jaun₂ ca₂ŋag₃ chi₂jua'₂ ma₂lé₂ jág₃. ");
INSERT INTO cntNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jaun₂ ca₂chóg'₃ ne₅₄ ca₂jág₃, jaun₂ ca₂juá'₂: ―Jɨn₄ jniá₂ dsa₂ i₂nio₄, i₂jniá₂ lia'₂ jniá₂ nɨ₁'ma₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Con'₂ siá'₂ ca₂tí₂ táng₃ Jesús gu₂ jme₁ne₁ dsa₂ 'éi₂, jaun₂ guë́₄ ca₂jág₃ i₁ca'₅₄ mɨ₂ne₅₄, jaun₂ guë́₄ ca₂rë₃jniá₂ dse₃ jme₁ne₁₂, ca₂'lóin₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jaun₂ ca₂dsióg'₂ Jesús co₂dsau₅ ja₁quió'₄, ca₂juá'₂: ―Tsá₃ 'ú₅ jë₄ juɨg₂ të₃ jág₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Cang₂ jaun₂ ca₂ŋó₃ Jesús quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ le₂tan₅₄ juɨg₂ Cesarea ja₁tén₄ Filipo. Jaun₂ le₂'i₄ juɨ₅ ja₁i₃léin₂, ca₂ŋag₃ Jesús ca₂ŋɨ́i'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―¿'Ein₂ lɨ́n₅ jniá₂, juá'₂ dsa₂? ");
INSERT INTO cntNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―I₂lɨn₅₄ dsa₂ juá'₂ a₂lɨ́ng'₅ Juan₅₄ i₂jme₁chon₅ dsa₂ jmɨg₂. I₂lɨn₅₄ guë'₂ juá'₂ a₂lɨ́ng'₅ Elías. I₂lɨn₅₄ guë'₂ juá'₂ táng₃ a₂lɨ́ng'₅ jan₂ i₂sián'₂ i₂chen₄ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jaun₂ ca₂ŋag₃ táng₃: ―¿'Nia'₂ guë'₂ në́₃? ¿'E₂ juá'₂ 'nia'₂ 'ein₂ lɨ́n₅ jniá₂? Jaun₂ ca₂ŋag₃ Pe₄: ―'Ne₂ lɨ́ng'₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jaun₂ ca₂jmo₃ Jesús 'éi'₃ a₂tsá₃ dsia₃ tsɨ́'₃ 'i₁jan₂ jua'₅₄ a₂'ag₃. ");
INSERT INTO cntNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jaun₂ në́₃ ca₂jme₃lióg₃ Jesús ca₂'ë́₂ jág₁ ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂, a₂ca₂tɨ́n₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ dsɨ₃ŋɨ́i₂ 'lióng₂ uɨg₅, a₂tsá₃ le₃jei₅₄ dsa₂ can'₅₄ quián₅ guá'₅, juɨg₅₄ jme₂dsa₂, të₅juá'₅ në́₃. Ca₂le₃jɨ́n₃ quɨin'₃ jág₁ a₂jŋag'₃. La₁ jein'₅₄ bá₄ táng₃ a₂'nɨ₅ jmɨg₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ca₂juá'₂ lia'₂ rë₂jiá₃ jág₁. Jaun₂ Pe₄ në́₃ ca₂jiog₃ le₂cau₅, jaun₂ ca₂jme₃lióg₃ ca₂ti₂ca₂néi'₂ a₂jme₁jnéi₂ juɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jaun₂ ca₂jén'₃ Jesús ca₂jɨ́in₂ ca₂le₃jɨ́n₃ chi'₂ dsɨ₂guia₃-tɨ́n₂, jaun₂ ca₂jéin₂ Pe₄ ca₂juá'₂: ―¡Jŋiag'₃ cau₅ quió₃, 'ne₂ Satanás! Ia₁ tsá₃ dsɨ₂jiog₅ 'au'₂ juɨ₁lia'₂ dsɨ₂jiog₅ dsɨ́₅ Diú₄; lia'₂ dsɨ₂jiog₅ dsɨ́₅ dsa₂ mɨ₂güɨ́g₃ bá₄ dsɨ₂jiog₅ 'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jaun₂ ca₂të́'₃ Jesús chi'₂ dsɨ₂guia₃-tɨ́n₂, ca₂le₃jɨ́n₃ guë́₄ dsa₂ i₂jme₁tion'₅₄ në́₃. Jaun₂ ca₂juá'₂: ―Chi₂jua'₂ 'ein₂ 'nio₃ 'ein₃ jniá₂, co₂dsia₅ juɨ₁dsi₂'én₂ dsɨ́₅ guioin₅₄, juɨ₁jmo₁₂ co₂jŋiai₅₄ a₂jóin₂, juɨ₁'ein₁₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ia₁ juɨ₁'ein₂ guë́₃ i₂tsá₃ 'nio₃ jón₂ ia₁ 'ɨ́n₅ dsɨ́₅ le₃chain₂ dse₃ mɨ₂güɨ́g₃ la₂, dsɨ₃'én₂ quió'₅. La₁ juɨ₁'ein₂ guë́₄ i₂tén'₂ dsɨ́₅ gue₃ 'mú₃ 'uɨg₅₄ quió₃ jniá₂, 'uɨg₅₄ quió'₄ jág₁ dse₃ në́₃, tɨ́in'₄, le₃chain₂ dse₃ mɨ₂güɨ́g₃ caun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿'E₂ bá₄ ta₁ jmo₃ a₂lí'₂ dsa₂ 'ŋio₅ lɨn₃ ne₄ gua'₅₄ 'uë₃ la₂, në₁jua'₂ dsɨ₃'én₂ bá₄ guë'₂ jme₂dsí₂ quió'₅ mɨ₂güɨ́g₃ caun₂? ");
INSERT INTO cntNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿O₃ je₂liá'₂ lé₂ le₃quí₃ dsa₂ 'lia'₅₄ ia₁jaun₂ tɨ́n'₄ jme₂dsí₂ quió'₅? ");
INSERT INTO cntNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ia₁ juɨ₁'ein₂ guë́₃ i₂gui'₅₄ jmóg'₂ jniá₂, quian'₅₄ jág₁ dse₃ quió₃, të₃jɨn₄ dsa₂ i₂qui₂rë₂cán'₄ dso₄ i₂tsá₃ ne'₅₄ chan₂ jmɨg₄ në₃, ján₃ bá₄ le₂jaun₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ gui'₅₄ jmóg'₂ jë₁ma₂të́₂ rë₁guain'₂ quian'₅₄ ángeles jŋió₅ quian'₅₄ ca₂le₃jë́₃ bí₂ jlá'₁ quió'₅ jmei₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jaun₂ ca₂tsɨ́'₃ dsa₂ le₂la₂ ján₃: ―A₂dsɨ₂jó'₃ juá'₅ jniá₂, ia₁ chan₂ i₂lɨn₅₄ 'nia'₂ i₂tión₂ ja₁lá₃ i₂tsá₃ tɨn₅₄ dsián₃ né'₃ a₂të₅₄ ne₅₄ a₂guá₂ jmɨg₄ a₂jme₃gón₃ Diú₄ quian'₅₄ juɨ₅bí₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jŋéi₂ jmɨg₄ cang₂ jaun₂ ca₂jŋia₃ Jesús Pe₄, Jacobo, Juan₅₄ në́₃, jaun₂ ca₂i₃léin₂ con'₂ guioin₅₄ juɨ₅ caun₂ má'₂ ŋei₅. Ja₁jaun₂ ca₂jme₃tsɨ́n₃ Jesús lia'₂ jniái₂ të₃ jág₅ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jaun₂ nɨ₁tsɨn'₅₄ ca₂jnia₃ tág₅ co₂'né'₅ tiog₂ jau₂ ca₂lia'₂ 'i₁jan₂ dsa₂ chan₂ mɨ₂güɨ́g₃ tsá₃ tɨin₂ rang₃ 'mɨ'₂ a₂jnia₅₄ tiog₂ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jaun₂ ca₂jág₃ ca₂jnia₃ coin₂, Elías quian'₅₄ Moisés, tióin₂ dsia₂₃ jág₁ quiain'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jaun₂ në́₃ ca₂juá'₂ Pe₄ ca₂tsɨ́'₃ Jesús: ―Të₅, ¡'e₂ guë́₄ dse₃ lia'₂ tio'₅₄ jniog₄ ja₁lá₃! Në₃ o₁jmog'₅₄ 'nɨ₅ tsɨ₁'io₅ láu₃: caun₂ quiáng'₂, caun₂ quió'₅ Moisés, caun₂ guë'₂ quió'₅ Elías në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(On₃jua'₅₄ jaun₂ ca₂rë₃lí'₄ rë'₂ Pe₄ 'e₂ a₂ca₂'ŋiai₂, të₂'ɨ₂₃ le₂jaun₂, ia₁ a₂gó'₅ 'ŋio₅ lɨn₃ tioin'₅₄). ");
INSERT INTO cntNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Të₃jë₄ jaun₂ në́₃ ca₂'ág₂ jnei₅ ja₁tioin'₅₄, ca₂lioin₂. Jaun₂ jë₄ jnei₅ jaun₂ ca₂né'₂ jág₁ a₂ca₂juá'₂: ―I₂la₂ bá₄ jón₃ quiáng₃, i₂'nióg₃ guë́₄ lɨn₃. Nei₂ 'nia'₂ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dsɨ₂juɨ₅ le₂jaun₂ jme₁ca₂jág₃ táng₃, tsá₃ ma₃'ein₂ chan₂, jŋia'₅₄ lia'₂ jan₂ 'ŋiog₅ bá₄ Jesús quiong'₅₄ guë́₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jme₁ma₂tioin'₅₄ juɨ₅ ja₂lein₃ sióin₅ má'₂, jaun₂ ca₂jmo₃ Jesús 'éi'₃ a₂tsá₃ 'ein₂ tsɨ́'₃ 'i₁jan₂ 'e₂ a₂ca₂jág₃ jaun₂, a₂jmo₃ tei₄ ca₂lia'₂ ca₂jen'₅₄ táng₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ ne₄ 'mú₃. ");
INSERT INTO cntNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jaun₂ në́₃ tei₄ bá₄ ca₂jmo₃, tsá₃ 'ein₂ ca₂tsɨ́'₃, jŋia'₅₄ lia'₂ qui₂ca₂ŋɨ́i'₃ rɨin'₅₄ 'e₂ jein₅ jág₁ jaun₂ a₂jein'₅₄ ne₄ 'mú₃. ");
INSERT INTO cntNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jaun₂ ca₂ŋɨ́i'₃ Jesús: ―¿'E₂ lë₃ juá'₂ të₅juá'₅, Elías bá₄ i₂ca₂tɨ́n₂ jiá₃ le₂'uɨg₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jaun₂ ca₂ŋag₃: ―Dsón'₂ bá₄ jaun₂ Elías bá₄ i₂jiá₃ le₂'uɨg₅₄, a₂jmóg'₃ ca₂le₃jë́₃. ¿'E₂ guë'₂ lë₃ jaun₂ chi₁ton₅ ne₄ Si₂ a₂ca₂tɨ́n₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ a₂tsá₃ caun₂ dsɨ₃ŋɨ́i₂, tsá₃ guei₃ dsa₂, 'liog'₃ dsa₂ 'uë₃ co₂ŋɨ́₂? ");
INSERT INTO cntNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","La₁ jniá₂ juá'₅, i₂ma₂guan₅ bá₄ Elías, qui₂ca₂jmóg'₂ dsa₂ ca₂lia'₂ lë́₂ dsɨ́₅, lia'₂ con'₂ lë́₅ chi₁ton₅ ne₄ Si₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jme₁co₂lág₂ jaun₂, ca₂dsi₃lein₃ ja₁tion'₅₄ rɨin'₅₄. Jaun₂ ca₂jɨ́in₂ juɨn₅ dsa₂ sián'₂ tion'₅₄ le₃lág'₃ jaun₂. Tion'₅₄ të₅juá'₅ në́₃, tsɨin₂₃ quian'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jaun₂ dsɨ₂juɨ₅ jme₁ca₂jág₃ dsa₂ ca₂le₃jɨ́in₃ ca₂jɨ́in₂ Jesús, ca₂i₃gó'₃ dsɨ́₅ 'ŋio₅ lɨn₃, jaun₂ i₃léin₂ i₁cuag₃ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jaun₂ ca₂ŋag₃ Jesús: ―¿'E₂ jág₁ tsɨ₂jɨ́n'₂ 'nia'₂ quian'₅₄ dsa₂ në₅? ");
INSERT INTO cntNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jaun₂ ca₂ŋag₃ jan₂ dsa₂ i₂'en₅₄ jë₄ jaun₂: ―Të₅, la₂ jŋiag₅₄ chi'₂ quiáng₃ a₂'ein₅₄ jme₂dsí₂ 'lɨn'₅₄ i₂tsá₃ cuë₅ jmɨg₄ dsia₃ chi'₂ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chi₂jua'₂ 'a₂ guë'₂ já'₄ jmóg'₂, jmo₂₃ tón₂ 'uë₃. Qui₂'uë́'₅ chi'₂ jan₅ mɨ₂'o₅₄, qui₂quɨg'₂ mɨ₂jan₅₄ në́₃. Jmo₂₃ a₂rë₂'uá'₃ rë₂juɨ́₂ quió'₅ në́₃. Jaun₂ jme₁ma₂në₂juɨ́g₂ jniá₂ dsa₂ i₂quiang'₅₄ a₂jme₁dsein₂₃ i₂'lɨn'₅₄, la₁ tsá₃ tió'₅, juá'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jaun₂ ca₂ŋag₃ Jesús: ―¡'En₁ jmá'₃ tsá₃ 'e₂ 'én'₂ 'nia'₂ dsa₂ chan₂ jmɨg₄ në₃! ¿Je₂liá'₂ jmɨg₄ jmá'₃ 'nió'₅ jmo₅₄ jniá₂ tió₅ dsɨ₃ ŋɨ₅₄ quian'₅₄ 'nia'₂? O₂quiain₅ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jaun₂ ca₂i₁quian₅₄ dsa₂ chi'₂ ca₂o₃jiog₃ ne₅₄. Jaun₂ dsɨ₂juɨ₅ jme₁ca₂jág₃ i₂'lɨn'₅₄ ca₂jɨ́in₂ Jesús, ca₂jmo₃ táng₃ i₃'ɨ́n₃ i₂bë'₅₄ qui₂ca₂ba₂ca₂lɨ́in'₂ 'uë₃, 'uë́'₅ jan₅ mɨ₂'o₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jaun₂ ca₂ŋɨ́i'₃ jmei₂ chi'₂: ―¿Jma₂je₂liá'₂ jmɨg₄ jén'₅ le₂në₅? Jaun₂ ca₂ŋag₃: ―Lia'₂ con'₂ bɨn'₅₄ bá₄ i₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","'Lióng₂ ráun₂ ma₂jmo₃ a₂'nio₃ 'í₂ né'₃ si₂, 'nio₃ 'í₂ né'₃ jmɨ́g₃ në́₃, a₂jmóg'₂ i₂'lɨn'₅₄ a₂'nio₃ jŋag'₃. La₁ në₁jua'₂ cha₂ a₂lé₂ le₃jmó'₂, dsia₄ ŋéi₂ 'au'₂ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jaun₂ ca₂juá'₂ Jesús: ―¿'A₂ bá₄ lia'₂ jaun₂ “chi₂jua'₂ cha₂ a₂lé₂?” Lé₂ bá₄, quió'₅ ca₂le₃jɨ́n₃ i₂'én₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dsɨ₂juɨ₅ le₂jaun₂ ca₂ŋag₃ jmei₂ i₂bë'₅₄ ca₂juá'₂ tiá₂: ―¡'Én₂ bá₄ jniá₂! ¡Jme₁'o₁ jaun₂ le₃'éng₂ guë́₄! ");
INSERT INTO cntNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jme₁ca₂jág₃ Jesús caun₂ qui₂ca₂ŋɨ'₂ juɨn₅ lɨn₃ guë́₄ dsa₂, jaun₂ guë́₄ ca₂jéin₂ i₂'lɨn'₅₄, ca₂juá'₂: ―Jú₅ ja₁në₅, 'ne₂ jme₂dsí₂ i₂jmo'₂ con₄ güɨn₄ chi'₂. Ca₂lia'₂ o₁lɨ́g'₂ jmɨg₄ tsá₃ ma₃'ú'₄ ja₁në₅, ia₁ jniá₂ juá'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jaun₂ jme₁ca₂o₃'ɨ́n₃ i₂'lɨn'₅₄, ca₂jmo₃ guë́₄ cón'₂ ca₂guió'₃ chi'₂ 'éi₂, ca₂i₃'ɨ́in₃, ca₂ba₂ca₂lɨ́in'₂ 'uë₃, ca₂quiog₂ tsá₃ lí'₄. “Ca₂join₃ bá₄”, ca₂juá'₂ mei'₂ tsá₃ ca₂le₃jɨ́n₃ dsa₂ i₂ca₂jág₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jaun₂ ca₂'ɨ́n₃ Jesús mɨ₂gu₂, ca₂chó'₂, jaun₂ ca₂nau₂ chi'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jaun₂ jme₁ma₂'í₅ Jesús caun₂ dsi₂néi₂, ja₁jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ con'₂ guioin₅₄: ―¿'E₂ 'uɨg₅₄ tsá₃ ca₂tián₃ jnia'₅₄ a₂dsén₄ i₂'lɨn'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jaun₂ ca₂ŋag₃ Jesús: ―Jme₂dsí₂ 'lɨn'₅₄ i₂le₂në₅ lé₂ le₃'uɨ́in₃ jmá'₃ lia'₂ quian'₅₄ a₂chi₂lén'₂ dsa₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jme₁ca₂'uɨin₂ juɨg₂ jaun₂, ca₂i₃lein₃ táng₃, ca₂ŋɨi₅ juɨ₅ 'uë₃ Galilea, tsá₃ jme₁'nio₃ Jesús le₃ŋi₅ dsa₂, ");
INSERT INTO cntNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ia₁ jme₁jme₂tɨin₂₃ chi'₂ dsɨ₂guia₃-tɨ́n₂, ca₂juá'₂: ―Ja₂quián₃ jmɨg₄ a₂jáng'₂ dsa₂ jɨ́in'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ o₄gú₃ dsa₂ i₂'iog₅₄ jaun₂ jŋag'₃ dsa₂. La₁ a₂'nɨ₅ jmɨg₄, jein'₅₄ bá₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","La₁ chi'₂ dsɨ₂guia₃-tɨ́n₂ në́₃, tsá₃ ca₂ŋɨ́i'₂ 'e₂ jein₅ jág₁ a₂juá'₂ le₂jaun₂, ton'₂ tsá₃ ma₃ca₂tiá₃ dsɨ́₅ jua'₅₄ a₂ŋag₃ guë́₄ 'e₂ ŋag₃. ");
INSERT INTO cntNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jaun₂ ca₂dsi₃léin₂ juɨg₂ Capernaum. Jme₁ma₂tiáin'₅ dsi₂néi₂, jaun₂ ca₂ŋɨ́'₃ Jesús chi'₂ dsɨ₂guia₃-tɨ́n₂, ca₂juá'₂: ―¿'E₂ jág₁ tsɨ́n'₂ 'nia'₂ ja₂nóg'₅ le₂'i₄ juɨ₅? ");
INSERT INTO cntNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","La₁ tei₄ bá₄ ca₂tiáin'₂, tsá₃ 'e₂ ca₂ŋag₃, ia₁ le₂'i₄ juɨ₅ ja₂lein₃ tsɨin₂₃ 'ein₂ dsón'₂ i₂lén₂ i₂dsen₅₄ guë́₄ jë₄ quió'₅ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jaun₂ ca₂guá₂ Jesús, jaun₂ ca₂të́'₃ ta₁guia₃-tɨ́n₂ 'éi₂, jaun₂ ca₂juá'₂: ―Chi₂jua'₂ 'ein₂ 'nia'₂ 'nio₃ lén₂ i₂le₂'uɨg₅₄, cán₂ ne₄ juɨ₅, 'nió'₅ léin₂ i₂jë₁ca₂tó'₂ quió'₅ ca₂le₃jɨ́n₃, jme₂ti₃ ta₁ ne₄ ca₂le₃jɨ́n₃ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jaun₂ në́₃ ca₂cain₃ jan₂ guein₂ quián₅ dsa₂, jaun₂ ca₂dsiain₃ 'éi₂ jë₄ quió'₅, jaun₂ ca₂jŋau'₃, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Juɨ₁'ein₂ guë́₃ i₂guen₅ jan₂ guein₂ bë'₅₄ le₂la₂ o₄quió₃ jniá₂, jniá₂ bá₄ guei₂₃. I₂guei₅ jniá₂, on₃jua'₅₄ jmá'₃ jniá₂ guei₂₃. Guein₂₃ le₂jiog₅ i₂ca₂chei₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jaun₂ ca₂juá'₂ Juan₅₄: ―Të₅, në₂jɨn₄ jnia'₅₄ jan₂ dsa₂ i₂në₂'uɨ́n'₂ je₂na'₅₄ quian'₅₄ bí₂ 'éi'₃ quiáng'₂. Tsá₃ ma₃në₂cuë́₁ jnia'₅₄ jmɨg₄ jua'₅₄ a₂jmo₃ guë́₄ le₂jaun₂, ia₁ tsá₃ ŋɨ₂₃ guë'₂ quian'₅₄ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jaun₂ ca₂juá'₂ Jesús: ―Tsá₃ jmó'₂ 'nia'₂ le₂jaun₂, jua'₅₄ a₂jnɨg'₅₄. Ia₁ 'i₁jan₂ tsá₃ jmo₅ caun₂ ta₁ juë'₂ lia'₂ con'₂ lë́₅ 'éi'₃ quió₃ jniá₂, jua'₅₄ a₂lé₂ le₃dsia₃ 'ag₃ 'lɨg'₅₄ dsɨ₂juɨ₅ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ia₁ juɨ₁'ein₂ guë́₃ juɨ₁lia'₂ i₂tsá₃ 'iog₅₄ jniog₄, i₂tión₂ të₂le₃ quián₂ jniog₄ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ia₁ në₁jua'₂ 'ein₂ ca₂cuë́'₃ 'nia'₂ tsá₃ a₂léi'₂ o₁jŋia'₅₄ caun₂ vaso jmɨg₂ bá₄, ia₁ a₂tén'₅ 'nia'₂ të₂le₃ quió'₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄, a₂dsɨ₂jó'₃ juá'₅ jniá₂, lí'₂ bá₄ 'liain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Juɨ₁'ein₂ guë́₃ i₂jmo₅ tsɨ₂sén'₂ dso₄ juɨ₁lia'₂ i₂me'₂ le₂la₂ i₂'én₂ të₂le₃ quió₃ jniá₂, ja₂lɨn₃ guë́₄ dse₃ co₂ŋei'₅₄ jua'₅₄ a₂tón₂ dsa₂ ne₄ jmɨ₁ŋí'₄ rë₂quein₅ ca₂mɨ́g₂ nɨ₁to₂ dsɨ₂lag₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Në₁jua'₂ mɨ₂gog'₂ jmo₅ a₂tang'₂ dso₄, co₂ŋei'₅₄ guë́₄ dse₃ 'nia₄, ia₁ ja₂lɨn₃ guë́₄ dse₃ dsiáng'₄ 'nau₅₄ caun₂ gog'₂ ja₁le₃chang'₂ co₂tan₅₄, con'₂ guë́₄ a₂jme₁dsiáng'₄ guio₃-juɨ́g₃ a₂rë₂'ŋia₅ ta₁tɨn₃ gog'₂ ja₁tsá₃ lɨ́g'₂ jmɨg₄ éi₃ si₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Në₁jua'₂ mɨ₂tag'₅₄ jmo₅ a₂tang'₂ dso₄, 'nia₄ ján₃, ia₁ ja₂lɨn₃ guë́₄ dse₃ dsiáng'₄ guiang'₅₄ ja₁le₃chang'₂ co₂tan₅₄, lia'₂ con'₂ guë́₄ a₂jme₁dsiáng'₄ a₂rë₂'ŋia₅ le₃tɨn₃ tag'₅₄ guio₃-juɨ́g₃, ja₁tsá₃ lɨ́g'₂ jmɨg₄ éi₃ si₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Chi₂jua'₂ mɨ₂ne'₅₄ jmo₅ a₂tang'₂ dso₄, co₂ŋei'₅₄ guë́₄ dse₃ dsi₄ ján₃, ia₁ ja₂lɨn₃ guë́₄ dse₃ a₂dsiáng'₄ a₂teng'₅₄ ca₂mɨ́g₂ mɨ₂ne'₅₄ ja₁gon₂ Diú₄, lia'₂ con'₂ guë́₄ a₂jme₁dsiáng'₄ a₂rë₂'ŋia₅ ta₁tɨn₃ mɨ₂ne'₅₄ guio₃-juɨ́g₃: ");
INSERT INTO cntNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ja₁tsá₃ lɨ́g'₂ jmɨg₄ dsián₃ i₁ja'₅₄, on₃ guë'₂ si₂ éi₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ia₁ ca₂le₃jɨ́n₃ bá₄ 'nió'₅ lé₂ 'í₁ të₂le₃ quian'₅₄ uɨg₅ a₂lë́₅ lia'₂ lë́₅ si₂. ");
INSERT INTO cntNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Dse₃ bá₄ tsɨ₁ŋi₁ të₁lia'₂ ŋi'₅₄, la₁ në₁jua'₂ ca₂'en₃ ŋi'₅₄ tsɨ₁ŋi₁ në́₃, ¿'A₂ bá₄ lia'₂ lé₂ le₃lei₂ táng₃? Jaun₂ juɨ₁len'₅₄ bá₄ 'nia'₂ juɨ₁lia'₂ lë́₅ tsɨ₁ŋi₁. Juɨ₁le₂chan'₂ bá₄ 'nia'₂ 'ei₅ tei₄ quian'₅₄ rɨ́ng'₂ le₂jang'₂ le₂jang'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jaun₂ ca₂o₃'ɨ́n₃ Jesús juɨg₂ Capernaum ja₁jme₁'ein₅₄, ca₂ŋó₃ táng₃ ja₁tén₄ Judea quian'₅₄ juɨ₅ 'uë₃ të₂le₃ 'ŋo'₅₄ Cuá₃ Jordán. Ja₁jaun₂ ca₂o₃lén₂ táng₃ dsa₂ juɨn₅ ja₁'ein₅₄. Con'₂ siá'₂ táng₃ ca₂jmo₃ juɨ₁lia'₂ jmo₂₃ tián₂, ca₂jme₃tɨin₂₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jaun₂ ca₂dsi₃lén₂ i₂lɨn₅₄ dsa₂ fariseos, ca₂ŋɨ́i'₃ Jesús a₂jŋia'₅₄ con'₂ 'nio₃ cáun₂ táu₂ chi₂jua'₂ 'i₄ 'éi'₃ a₂tén₂ dsa₂ dsa₂ mɨ́₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jaun₂ ca₂ŋag₃ 'éi₂: ―¿'E₂ 'éi'₃ ca₂cuë₃ Moisés guë'₂? ");
INSERT INTO cntNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jaun₂ ca₂ŋag₃ táng₃ dsa₂ 'éi₂: ―Ca₂cuë₃ Moisés jág₁ a₂lé₂ le₃jmo₃ dsa₂ ŋe'₂ caun₂ si₂ të₃ron₅₄, jaun₂ guë́₄ ma₂lé₂ dsei₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jaun₂ ca₂ŋag₃ Jesús: ―'Uɨg₅₄ ia₁ a₂ŋɨ́₄ tsá₃ nág'₁ 'nia'₂ guiong'₅₄ bá₄ ca₂cuë₃ Moisés 'éi'₃ jaun₂, ");
INSERT INTO cntNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","La₁ le₂'uɨg₅₄ lia'₂ con'₂ jme₁ca₂dsia₃ Diú₄ mɨ₂güɨ́g₃, “ca₂jmói'₂ dsa₂ ŋe'₂, dsa₂ mɨ́₂”. ");
INSERT INTO cntNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“'Uɨg₅₄ jaun₂ në́₃ dsa₂ ŋe'₂, ca₂tɨ́in₂ téin₂ chog₅₄-jmei₂, con'₂ tiain'₃ quiain'₅₄ dsa₂ mɨ́₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jaun₂ jë₁le₃oin₃ léin₂ caun₂ bá₄ nɨ₁ŋɨ́₅.” Jaun₂ dsióg₄ lé₂ co₂'nió'₄ jan₂ dsa₂ bá₄, tsá₃ ma₂lë́₂ oin₃. ");
INSERT INTO cntNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jaun₂ tsá₃ 'i₄ 'éi'₃ jua'₅₄ dsa₂ mɨ₂güɨ́g₃ a₂jmo₃ jma₃quén₅ a₂ma₂dsia₃ Diú₄ rë₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jme₁ma₂tioin'₅₄ táng₃ dsi₂néi₂, ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ ca₂ŋɨ́i'₃ Jesús jág₁ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jaun₂ ca₂juá'₂ Jesús: ―Dsa₂ i₂tén₂ 'io₅₄ quián₅, a₂guá₃ táng₃ quiain'₅₄ i₂sián'₂, 'no₂₃ dso₄ ja₁con₂ 'io₅₄ quiáin₅ i₂le₂'uɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Con'₂ guë'₂ siá'₂ táng₃ në₁jua'₂ tén₂ 'io₅₄ dsɨ₂i₂gu₂ a₂guá₃ táng₃ quiain'₅₄ dsa₂ ŋe'₂ sián'₂, ján₃ bá₄ le₂jaun₂ 'no₂₃ dso₄ ja₁con₂ dsɨ₂i₂gu₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jaun₂ ca₂dsi₃lén₂ dsa₂ le₁jŋiai₂₃ chi'₂ quiáin₅ ja₁guá₄ Jesús, ia₁jaun₂ qui₃téi₂ Jesús gu₂. La₁ chi'₂ dsɨ₂guia₃-tɨ́n₂ në́₃ ca₂jí₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jme₁ca₂jág₃ Jesús, jaun₂ ca₂i₃méi'₂ dsɨ́₅ quian'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, jaun₂ ca₂juá'₂: ―Cuë₄ 'nia'₂ jmɨg₄ juɨ₁ja₂lén₂ chi'₂-guein₂ cong₂. Tsá₃ jmó₁ 'nia'₂ le₂në₅ jua'₅₄ a₂jnɨg'₅₄, ia₁ juɨ₁lia'₂ i₂le₂la₂ bá₄ guë'₂ i₂dsɨ₂len₅ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, ia₁ juɨ₁'ein₂ guë́₃ i₂tsá₃ gue₅ 'éi'₃ quió'₅ Diú₄, juɨ₁lia'₂ gue₅ jan₂ i₂bë'₅₄, o₁lɨ́g'₂ tsá₃ dsi₁lein₅ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jaun₂ qui₂ca₂jŋai'₃ guein₂ 'ein₅₄, ca₂quiog₂ gu₂ ne₄ quió'₅, ca₂jme₃jŋió₃. ");
INSERT INTO cntNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jme₁ma₂'en₅₄ Jesús juɨ₅ ŋó₅ táng₃, jaun₂ já₃ jan₂ dsó₂ co₂chi'₅₄ ca₂jme₃jein'₂ ca₂chi₃jné₃ ne₅₄. Jaun₂ ca₂ŋag₃: ―Të₅ dsen₃, ¿'e₂ 'nió'₅ jmo₅₄ jniá₂ ia₁jaun₂ tɨng₅₄ ja₁le₃chang₂ co₂tan₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jaun₂ ca₂ŋag₃ Jesús: ―¿'E₂ lë₃ quiong'₅₄ jniá₂ a₂dseng₃? 'I₁jan₂ i₂dsen₃ tsá₃ chan₂, jŋia'₅₄ lia'₂ jan₂ Diú₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Cuɨng'₂ bá₄ 'Éi'₃ Juá'₅ quió'₅ Diú₄, ja₁juá'₂ tsá₃ jme₁dsiang'₂ dsa₂ mɨ₂güɨ́g₃ rɨ́ng'₂; on₃ guë'₂ nióg'₄ jág₁ quian'₅₄ dsa₂ i₂tsá₃ lɨ́n₅ dsɨ₂i₂gog'₂; on₃ guë'₂ 'áng'₁. Tsá₃ jmó₁ jua'₅₄ jang'₅₄ jág₁ të₂jág₁; tsá₃ jme₁gan₅ dsa₂ jua'₅₄ a₂jŋiá'₄ a₂cha₂ quió'₅; a₂jme₁gang'₃ chog'₂-ŋéi'₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ca₂ŋag₃ táng₃ dsa₂ 'éi₂: ―Të₅, ca₂le₃jë́₃ a₂në₅, lia'₂ con'₂ bɨn'₅₄ bá₄ jniá₂ jme₂tí₁. ");
INSERT INTO cntNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jaun₂ ca₂jág₂ Jesús ŋéi₂ dsɨ́₅, ca₂juá'₂: ―Caun₂ guë́₄ a₂'nió'₅ quiáng'₂. Guan'₂ o₂'nag₄ ca₂le₃jë́₃ a₂cha₂ quiáng'₂, o₂dsio'₅₄ cu₄ jaun₂ o₂cuë'₅₄ dsa₂ te₂ŋé₂. Jaun₂ guë́₄ le₃cha₂ a₂jlá'₁ quiáng'₂ guei'₅₄ i₂juɨ́g₃. Jaun₂ guë́₄ ŋia₅, 'éin₃. ");
INSERT INTO cntNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jaun₂ ca₂tá'₂ jén₂ dsɨ́₅ dsa₂ 'éi₂ jme₁ca₂nág₂ le₂në₅; ŋái'₅ bá₄ jaun₂ 'lia'₂ dsɨ́₅, ia₁ 'ŋio₅ lɨn₃ jme₁cha₂ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jaun₂ ca₂jén'₃ Jesús qui₂ca₂jɨ́in₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅. Jaun₂ ca₂juá'₂: ―¡'E₂ guë́₄ 'ŋio₅ quian₅ ta₁ quió'₅ dsa₂ cha₂ cu₄ a₂tɨ́in'₄ ja₁gon₂ Diú₄! ");
INSERT INTO cntNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jaun₂ i₃gó'₃ dsɨ́₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ jág₁ jaun₂, la₁ ca₂juá'₂ táng₃ Jesús: ―'Nia'₂ jón₃, ¡'e₂ bá₄ 'ŋio₅ quian₅ ta₁ a₂dsi₁len₅ dsa₂ ja₁gon₂ Diú₄! ");
INSERT INTO cntNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tsá₃ guë́₄ 'e₂ ta₁ quian₅ a₂lé₂ le₃ŋɨ₅ jan₂ já'₂ camello juɨ₅ tau₂ mɨ₂cu₄, con'₂ guë́₄ dsa₂ cha₂ cu₄ a₂'í₂ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jme₁ca₂nág₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ a₂në₅, i₃gó'₃ dsɨ́₅ 'ŋio₅ lɨn₃. Qui₂ca₂ŋɨ́i'₃ rɨin'₅₄: ―¿I₂'ein₂ bá₄ guë'₂ jaun₂ në́₃ i₂lé₂ le₃tɨ́n'₄? ");
INSERT INTO cntNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jaun₂ ca₂jág₂ Jesús, jaun₂ ca₂juá'₂: ―Dsón'₂ bá₄ jaun₂, të₂le₃ quió'₅ dsa₂ mɨ₂güɨ́g₃, o₁lɨ́g'₂ tsá₃ lé₂ le₃lé₂. La₁ të₂le₃ quió'₅ Diú₄, ca₂le₃jë́₃ bá₄ lé₂ le₃lé₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pe₄ në́₃ ca₂jme₃lióg₃ ca₂juá'₂: ―Te₁gui'₅₄, ca₂le₃jë́₃ 'e₂ a₂jme₁cha₂ quián₂ jnia'₅₄, ma₂ca₂tén'₂ dsɨ₅ jnia'₅₄ ma₂qui₂ma₂tí₄, ia₁ a₂'én₅ jnia'₅₄ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jaun₂ ca₂ŋag₃ Jesús: ―A₂dsɨ₂jó'₃ juá'₅ jniá₂ juɨ́g₂ 'nia'₂, ca₂le₃jɨ́n₃ i₂táun₂ 'ne₄, i₂tén₂ rɨn'₅₄, chog₅₄-jmei₂, chi'₂ quiáin₅, i₂tí₂ ja₁nau₂ quió'₅, 'uɨg₅₄ quió₃ jniá₂, quian'₅₄ 'uɨg₅₄ quió'₄ jág₁ dse₃ në́₃, ");
INSERT INTO cntNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","gue₃ mɨ₂güɨ́g₃ la₂ 'lióng₂ guë́₄ 'né₅, juɨn₅ guë́₄ rɨin'₅₄, juɨn₅ guë́₄ chog₅₄, juɨn₅ guë́₄ chi'₂-guein₂ quiáin₅ në́₃ le₃chan₂; ton'₂ 'lióng₂ guë́₄ ja₁nau₂ quió'₅ le₃cha₂, o₁jŋia'₅₄ la₂ chain₂ mɨ'₅₄ co₂'ein₅ dsa₂. La₁ia₁ gue₃ ja₁le₃chain₂ co₂tan₅₄ mɨ₂güɨ́g₃ caun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","La₁ rë₂në́₃, juɨn₅ i₂lɨ́n₅ i₂quen₅, la₁ jmɨg₄ jaun₂ léin₂ dsa₂ të₂le₃ jë₁ca₂tó'₂; le₂jaun₂ bá₄ ján₃, juɨ₁lia'₂ i₂tsá₃ 'e₂ quen₅ rë₂në́₃ lia'₂ con'₂ niog₅ lɨ́n₂ dsa₂ mɨ₂güɨ́g₃, léin₂ i₂le₂'uɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tioin'₅₄ juɨ₅ uɨ́g₂ tso₄ a₂dsi₁léin₂ Jerusalén. Jesús në́₃ ŋó₃ dsɨ₂jŋiái₄ ne₄ juɨ₅. Chi'₂ dsɨ₂guia₃-tɨ́n₂ guë'₂ i₂léin₂ dsɨ₂gó'₃ dsɨ́₅. Ca₂le₃jɨ́n₃ guë́₄ dsa₂ i₂jme₁quiain'₅₄ në́₃ i₂léin₂ gó'₅. Jaun₂ në́₃ ca₂të́'₃ Jesús le₃cau₅ juɨ₅ jmá'₃ dsɨ₂guia₃-tɨ́n₂, jaun₂ ja₁jaun₂ ca₂juá'₂ 'e₂ niog₅ dsɨ₃ŋɨ́i₂, ");
INSERT INTO cntNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ca₂juá'₂: ―Ŋí₂ 'nia'₂ jaun₂, tio'₅₄ jniog₄ juɨ₅ uɨg₂ tso₄ a₂dsi₁náu₅ Jerusalén. Ja₁jaun₂ jɨ́n'₂ dsa₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ o₄gú₃ juɨg₅₄ jme₂dsa₂, ne₄ të₅juá'₅ në́₃. I₂'éi₂ dsí₃ 'éi'₃ a₂jŋag'₃ dsa₂, jaun₂ jáng'₂ dsa₂ o₄gú₃ dsɨ₂nau₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","'Éi₂ në́₃ a₂lë₁qui₃jmóg'₂, qui₃cuë₃, qui₃'ŋéi₂ dsa₂ në́₃. Jaun₂ guë́₄ jŋag'₃. La₁ a₂'nɨ₅ jmɨg₄, jein'₅₄ bá₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jaun₂ në́₃, Jacobo quian'₅₄ Juan₅₄, le₃on₃ ja₁ŋi'₅₄ Zebedeo, ca₂jme₃quiáin₃ ja₁chén'₄ Jesús, jaun₂ ca₂juá'₂: ―Të₅, 'niog₂ jnia'₅₄ jmó'₂ 'ne₂ dse₃ 'au'₂ a₂jmó'₂ juɨ₁'e₂ caun₂ a₂mɨ́₁ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jaun₂ ca₂juá'₂ Jesús: ―¿'E₂ 'niog'₂ 'nia'₂ jmo₅₄ jniá₂ guë'₂? ");
INSERT INTO cntNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jaun₂ ca₂juá'₂ táng₃ 'éi₂: ―Jmó'₂ 'io₄ jnia'₅₄ jma₃jáu₃ lia'₂ ca₂ton₂ cau₅ quiáng'₂ jë₁ma₂të́₂ rë₁ne'₅₄ jláng'₁ ne₄ta₁ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jaun₂ ca₂ŋag₃ Jesús: ―Tsá₃ a₂jaun₂ ŋi'₅₄ 'nia'₂ a₂mɨ'₂. ¿Tián'₃ 'nia'₂ dsɨ₃ŋɨ́g'₂ ca₂le₃jë́₃ juɨ₁lia'₂ a₂dsɨ₃ŋɨ́₂ jniá₂ guë'₂? ¿Tián'₃ 'nia'₂ cán'₁ o₂i₁ dsɨ₅ juɨ₁lia'₂ o₂i₁ dsɨ₅ can₅₄ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jaun₂ ca₂ŋag₃ táng₃ 'éi₂: ―Tián₂ bá₄ jnia'₅₄. Ca₂juá'₂ táng₃ Jesús: ―Dsón'₂ bá₄ jaun₂ dsɨ₃ŋɨ́'₂ 'nia'₂ 'e₂ niog₅ dsɨ₃ŋɨ́₂ jniá₂. Ján₃ bá₄ cán'₁ 'nia'₂ o₂i₁ dsɨ₅ juɨ₁lia'₂ o₂i₁ dsɨ₅ can₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","La₁ juɨ₁lia'₂ a₂juá'₂ 'nia'₂ a₂tiáng'₄ jma₃ca₂ton₂ cau₅ quió₃, on₃jua'₅₄ jniá₂ ca₂tɨ́ng₂ cuë₅₄ a₂jaun₂. Ja₁jaun₂ lë́₅ co₂jŋia₅₄ a₂tian'₃ con'₂ i₂ca₂tɨ́n₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Rɨin'₅₄ i₂guian₃ guë́₄ 'éi₂ në́₃, ca₂rë₃'néi₃ quian'₅₄ Jacobo quian'₅₄ Juan₅₄, jme₁ca₂nág₂ juá'₂ 'éi₂ le₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jaun₂ ca₂të₃ Jesús cau₅ quió'₅ ca₂të́'₃ 'éi₂ ca₂le₃jɨ́n₃. Jaun₂ ca₂juá'₂: ―Ŋi'₅₄ bá₄ 'nia'₂ juɨ₁lia'₂ dsa₂ can'₅₄ i₂tián'₅ gon₂ juɨg₂ go₄ dsɨ₂nau₂, i₂jɨ́n₂ dsa₂ co₂'nió'₄ dsɨ₂tan₅₄ quiáin₅, qui₂toin'₂ dsa₂ 'éi'₃ bén₂. Le₂jaun₂ bá₄, juɨ₁lia'₂ dsɨ₂tan₅₄ i₂sion₅ guë́₄ quiáin₅ në́₃, tiáin'₅ goin₂ jmo₂₃ 'éi'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","La₁ jɨn'₄ 'nia'₂, tsá₃ le₂jaun₂ lé₂. Chi₂jua'₂ 'ein₂ 'nio₃ jmo₃ juɨn'₂, ca₂tɨ́in₂ jme₃ti₃ ta₁ ne₄ rɨin'₅₄; ");
INSERT INTO cntNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","chi₂jua'₂ 'ein₂ 'nia'₂ 'nio₃ cán₂ ne₄ juɨ₅, 'nió'₅ jme₃ti₃ ne₄ ca₂le₃jɨ́n₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ia₁ le₂në₅ bá₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃, tsá₃ ta₁ jaun₂ já₅ jua'₅₄ a₂jme₃ti₃ dsa₂ ne₅₄; a₂jme₃ti₃ ta₁ ne₄ dsa₂ bá₄ já₅, a₂quí₃ quian'₅₄ 'mú₃ 'lia'₅₄ ia₁jaun₂ tɨ́n'₄ juɨn₅. ");
INSERT INTO cntNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Dsi₃léin₂ juɨg₂ Jericó. Jme₁o₂'ɨ́in₃ juɨg₂ jaun₂ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, juɨn₅ guë́₄ dsa₂ sián'₂ në́₃ quiong'₅₄, jaun₂ jan₂ dsa₂ ten₄ i₂chen₂ Bartimeo, (co₂'nió'₄ le₃jua'₅₄ ja₁ŋi'₅₄ Timeo), guá₅ 'éi₂ cau₅ juɨ₅ mɨ₂₃ a₂jme₃'o₅₄ dsa₂ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jme₁ca₂nág₂ juá'₂ dsa₂ ŋó₅ Jesús i₂chan₂ Nazaret cau₅ jaun₂, jaun₂ ca₂'í₃ co₂mɨ'₅₄ të́'₂ Jesús: ―¡Jesús, tsɨ₁jon₂ David, dsia₄ ŋéi₂ 'au'₂ jniá₂! ");
INSERT INTO cntNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jaun₂ ca₂jí₂ bá₄ dsa₂ ia₁jaun₂ dsó₃ tei₄. La₁ të₂le₃ i₂juɨ'₂ guë́₄ co₂mɨ'₅₄ ca₂'í₃ bá₄, ca₂juá'₂: ―¡Tsɨ₁jon₂ David, dsia₄ ŋéi₂ 'au'₂ jniá₂! ");
INSERT INTO cntNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jaun₂ ca₂nau₂ Jesús jme₁ca₂nág₂, jaun₂ ca₂tsɨ́'₃ dsa₂ i₂quiain'₅₄: ―Te'₂ 'nia'₂ o₁jia₂ ja₁lá₃. Jaun₂ ca₂të₃ dsa₂, ca₂juá'₂: ―Jmo₄ 'io'₂. Nau₂, ia₁ ó₃ të́₂. ");
INSERT INTO cntNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jaun₂ ca₂ton₃ cau₅ 'mɨ'₂ dsióg₂ jme₁chi₁bóin'₅, jaun₂ con'₂ ca₂nau₂ jaun₂ bá₄ co₂chi'₅₄, ca₂ŋó₃ ja₁chén'₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jaun₂ ca₂ŋag₃ 'éi₂: ―¿'E₂ 'niog'₂ jmo₅₄ jniá₂ o₄quiáng'₂? Jaun₂ ca₂ŋag₃ táng₃ dsa₂ ten₄: ―Të₅, a₂jnia₅₄ jme₁ne₃ bá₄ jniá₂ 'nio₃. ");
INSERT INTO cntNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jaun₂ ca₂juá'₂ Jesús: ―Ma₂lé₂ guang'₅₄. Ma₂'lóng'₂ ia₁ 'éng'₂ bá₄. Dsɨ₂juɨ₅ jaun₂ bá₄ ca₂jnia₃ mɨ₂ne₄ dsa₂ 'éi₂. Jaun₂ ca₂ŋó₃ quiain'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jme₁ma₂quián₅ dsi₁léin₂ Jerusalén, dsi₃léin₂ quián₅ juɨg₂ Betfagé quian'₅₄ juɨg₂ Betania në́₃, a₂niog₅ cau₅ Má'₂ Olivos. Ja₁jaun₂ ca₂chen₃ Jesús on₃ dsa₂ i₂guia₃-tɨ́n₂ quiáin₅, ");
INSERT INTO cntNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ca₂juá'₂: ―O₂nó'₅ 'nia'₂ juɨg₂ pí'₁ niog₅ të₂le₃ ne₄ juɨ₅ ja₁dsau₅₄ në₅. Jë₁ma₂ca₂dsi₃nó'₅ 'nia'₂ ja₁jaun₂, dsian'₂ 'nia'₂ jan₂ bú'₄ 'mɨ́₂ i₂rë₂'ŋe'₅₄ i₂tsá₃ 'ein₂ ma₂co₁dsag₅₄. O₂chein'₅₄ 'nia'₂ jaun₂ të'₅₄ ja₁lá₃. ");
INSERT INTO cntNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Në₁jua'₂ 'ein₂ ca₂juá'₂: “¿'E₂ lë₃ jmo'₂ 'nia'₂ le₂në₅?” jaun₂ juɨg'₅₄ 'nia'₂: “Te₁gui'₅₄ bá₄ 'nio₃ ca₂tiá₂, la₁ në₃ cón'₅ bá₄ jáng'₂ táng₃.” ");
INSERT INTO cntNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jaun₂ i₃lén₂ dsa₂ 'éi₂. Jme₁ca₂dsi₃léin₂ ja₁chén'₄ bú'₄ rë₂'ŋe'₅₄ jë₄ calle cau₅ o₄'né₄ quió'₅ dsa₂, jaun₂ ca₂chéi'₂ jaun₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jaun₂ ca₂juá'₂ i₂lɨn₅₄ dsa₂ i₂ca₂jág₃, i₂tión₂ cau₅ jaun₂: ―¿'E₂ jmo'₂ 'nia'₂ ja₁në₅? ¿'E₂ lë₃ tsɨng'₅₄ bú'₄? ");
INSERT INTO cntNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jaun₂ ca₂jéin'₃ bá₄ guë'₂ 'éi₂ jág₁ lia'₂ lë́₅ jág₁ ca₂cuë₃ Jesús. Jaun₂ ca₂cuë₃ bá₄ dsa₂ jmɨg₄ të₂ já'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jaun₂ jme₁o₃lein₃ te₂ bú'₄, ca₂i₁jiog₃ ja₁'en₅₄ Jesús, jaun₂ ca₂jmo₃ dse₃ qui₂ca₂jlág₂ 'mɨ'₂ mɨ₂ca'₄ já'₂. Jaun₂ guë́₄ ca₂co₃dsag₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Juɨn₅ dsa₂ qui₂ca₂néi'₃ 'mɨ'₂ le₂'i₄ juɨ₅ ja₁ŋɨ́₃ Jesús. I₂lɨn₅₄ guë'₂ ca₂dsia₃ gu'₂-nei'₅₄ 'ma₂ a₂ca₂i₁'niai₁₂ ja₁nau₂. ");
INSERT INTO cntNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jaun₂ dsa₂ i₂i₂lén₂ le₃ne₄ juɨ₅ quian'₅₄ i₂ja₂lén₂ le₃chi₁co'₅₄ në́₃, qui₂ca₂tóin'₂ co₂mɨ'₅₄, ca₂juá'₂: ―¡Juɨ₁le₂juɨn'₂ bá₄ i₂në₅! ¡Juɨ₁le₂jŋió₃ bá₄ i₂në₅ i₂já₅ o₄quió'₄ Te₁gui'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Juɨ₁le₂jŋió₃ bá₄ 'éi'₃ a₂já₅ quió'₅ jmei₂ jniog₄ David në́₃! ¡Juɨ₁le₂juɨn'₂ bá₄ i₂guá₅ guei'₅₄ i₂juɨ́g₃! ");
INSERT INTO cntNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jme₁ca₂'í₃ Jesús juɨg₂ Jerusalén, jaun₂ ca₂'í₃ i₁dsi₅ guá'₅ templo. Jme₁ma₂në₂jág₃ 'a₂ lia'₂ lë́₅ ja₁jaun₂, ca₂o₃'ɨ́in₃, ca₂ŋái'₃ táng₃ juɨ₅ Betania quiain'₅₄ ca₂le₃jɨ́n₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, ia₁ ma₂ca₂'láu₂. ");
INSERT INTO cntNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jme₁jnia₃ jaun₂, con'₂ ma₂'uɨin₂ táng₃ juɨg₂ Betania, ca₂tá'₂ i₁cón'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jaun₂ ca₂jág₃ të₂ uɨ́ng₂ caun₂ nɨ₁'ma₂ higuera, lia'₂ rë₂can'₂ mog'₅₄ jniá₂ chí'₅. Jaun₂ ŋó₃ 'uɨg₅₄ ja₁dsi₅₄, ia₁ lɨ́in₂ jme₁dsio'₂ mɨ́g₂. La₁ jme₁dsióg₃ në́₃, jmá'₃ mog'₅₄ bá₄ cha₂, ia₁ on₃jua'₅₄ jein₂ a₂'ag₅ mɨ́g₂ higos jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jaun₂ në́₃ ca₂juá'₂ Jesús ca₂tsɨ́'₃ nɨ₁'ma₂: ―Juɨ₁le₅₄ ca₂lia'₂ o₁lɨ́g'₂ jmɨg₄ tsá₃ ma₃'ein₂ guë́'₃ co₂ŋei'₅₄ mɨ́g₂ quiáng'₂. Ca₂nág₂ bá₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ jme₁ca₂juá'₂ le₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jme₁ca₂dsi₃léin₂ táng₃ juɨg₂ Jerusalén, ca₂'í₃ Jesús i₁dsi₅ guá'₅ templo, ca₂jme₃lióg₃ ca₂'uɨ́in'₂ ca₂le₃jɨ́n₃ dsa₂ i₂jme₁tion'₅₄ 'nag₅, i₂lá₅ në́₃. Jaun₂ qui₂ca₂jéin'₃ nɨ₁mesa jme₁jmó'₂ dsa₂ ta₁ ja₁jme₂tsɨ́in₃ cu₄, qui₂ca₂quɨ́'₂ 'ma₂sɨ₅₄ ja₁jme₁tián'₄ dsa₂ i₂'nɨ₅ i₁ju₂; ");
INSERT INTO cntNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","tsá₃ ma₃ca₂cuë₃ jmɨg₄ jua'₅₄ a₂dsɨ₃can₅ guë́₄ dsa₂ lio₄ quió'₅ i₁dsi₅ guá'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jaun₂ ca₂jme₃tɨin₂₃ dsa₂ 'éi₂, ca₂juá'₂: ―Ne₄ Si₂ juá'₂: “'Né₅ quió₃ lë́₅ ca₂ne₅₄ 'né₅ ja₁chi₂lén'₂ dsa₂ Diú₄, dsa₂ chan₂ ca₂le₃jë́₃ juɨg₂.” La₁ 'nia'₂ në́₃ ma₂jmo'₅₄ në₂jag₄ bá₄ të₂'lau₂ quió'₅ dsa₂ 'ang₂. ");
INSERT INTO cntNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jaun₂ juɨg₅₄ jme₂dsa₂ quian'₅₄ të₅juá'₅ në́₃ ca₂nág₂ jág₁ në₅. Jaun₂ ca₂jme₃lióg₃ ca₂'náu'₃ juɨ₅ 'a₂ lia'₂ jŋag'₃, ia₁ gó'₅ con'₂ tsá₃ ŋó₅ në₁jua'₂ 'éi₂ bá₄ jme₃gón₃ lé₂, ia₁ juɨn₅ lɨn₃ dsa₂ nag₅ dsɨ₂gó'₃ dsɨ́₅ jág₁ a₂jme₂tag₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Të₂le₃ ca₂nei₂ jmɨg₄ jaun₂, ca₂'uɨin₂ juɨg₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jme₁jnia₃ jaun₂, ca₂ŋɨi₅ táng₃ juɨ₅ ja₁dsi₅₄ nɨ₁'ma₂ higuera. Jaun₂ ca₂jág₃ co₂dsia₅ ma₂quein₂ ca₂të₂ cho'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jaun₂ ca₂dsáu'₃ dsɨ́₅ Pe₄, jaun₂ ca₂tsɨ́'₃ Jesús: ―Të₅, jag₄ nɨ₁'ma₂ a₂ca₂chei'₅₄ uɨg₅. Co₂dsia₅ ma₂ca₂rë₃quéin₃. ");
INSERT INTO cntNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jaun₂ ca₂ŋag₃ Jesús ca₂tsɨ́'₃ dsa₂: ―'Én₃ 'nia'₂ të₂le₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, juɨ₁'ein₂ guë́₃ juá'₂ tsɨ́'₃ nɨ₁má'₂ në₅: “Jŋiag'₃ ja₁në₅, o₂'ú₅ jmɨ₁ŋí'₄”, le₂jaun₂ dsón'₂ le₃ti₃ bá₄, në₁jua'₂ tsá₃ ca₂'ág₂ caun₂-tɨn₃ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jaun₂ lë₃, juá'₅ jniá₂, juɨ₁'e₂ guë́₃ a₂mɨ'₂ 'nia'₂ jme₁chi₂leng'₅₄ Diú₄, në₁jua'₂ jmo'₂ 'nia'₂ 'au'₂ në₂jag₄ bá₄ a₂ma₂në₂gue'₅₄ 'e₂ a₂mɨ'₂, le₂jaun₂ dsón'₂ le₃ti₃ bá₄ ja₁con'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jë₁ma₂të́₂ rë₁náu'₁ 'nia'₂ chi₁léng'₄ Diú₄, në₁jua'₂ cha₂ 'nei₂ 'au'₂ 'nia'₂ ja₁con₂ rɨ́ng'₂, 'én₃ 'nia'₂ dsáu₁ rɨ́ng'₂, ia₁jaun₂ bá₄ Ŋéi'₅ 'nia'₂ i₂guá₅ guei'₅₄ i₂juɨ́g₃ 'éin₂ dsáu'₂ 'nia'₂ guiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ca₂dsi₃léin₂ táng₃ juɨg₂ Jerusalén. Jaun₂ jme₁ma₂ŋɨ₅ Jesús i₁dsi₅ guá'₅ templo, jaun₂ ca₂jme₃quián₃ juɨg₅₄ jme₂dsa₂, të₅juá'₅, dsɨ₂gui'₅₄ can'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂ ca₂ŋɨ́i'₃ Jesús: ―¿'E₂ ta₁ lɨ́n'₅ 'ne₂ a₂jmo'₂ ca₂le₃jë́₃ 'e₂ a₂jmo'₂ ŋɨ'₂? ¿'Ein₂ cuë₅ bí₂ 'éi'₃ a₂jmo'₂ le₂në₅? ");
INSERT INTO cntNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jaun₂ ca₂ŋag₃ Jesús: ―Ján₃ bá₄ ŋag₄ jniá₂ caun₂ 'nia'₂. Në₁jua'₂ ca₂ŋag'₅₄ 'nia'₂ lia'₂ tí₅, jaun₂ guë́₄ juá'₄ jniá₂ 'ein₂ cuë₅ bí₂ a₂jmo₂₃ ca₂le₃jë́₃ a₂jmo₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Juɨ₁lia'₂ a₂ca₂chon₃ Juan₅₄ jmɨg₂ dsa₂, ¿'ein₂ quió'₅ 'éi'₃ jaun₂? ¿Quió'₅ Diú₄, o₃ quió'₅ dsa₂ mɨ₂güɨ́g₃ 'e₂? Ŋag₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jaun₂ ca₂dsia₃ dsa₂ can'₅₄ jág₁ con'₂ guioin₅₄, ca₂juá'₂: ―Në₁jua'₂ ca₂chei₅₄ jniog₄ 'éi'₃ quió'₅ Diú₄ bá₄, në₃ cón'₅ bá₄ ŋag₃: “¿'E₂ lë₃ tsá₃ ca₂rë₃'én'₂ 'nia'₂ jág₁ quió'₅ 'éi₂?” ");
INSERT INTO cntNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿La₁ në₁jua'₂ ca₂chei₅₄ jniog₄ 'éi'₃ quió'₅ dsa₂ mɨ₂güɨ́g₃ bá₄...? La₁ ca₂rë₃gain₃ ca₂le₃jɨ́n₃ dsa₂ i₂quian'₅₄ Jesús. Ia₁ ca₂le₃jɨ́n₃ dsa₂ jme₁'éin₂ a₂jme₁lɨ́n₄ Juan₅₄ të₃dsón'₂ jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jaun₂ ca₂ŋag₃ dsa₂ can'₅₄ ca₂tsɨ́'₃ Jesús: ―Tsá₃ a₂jaun₂ ne₄ jnia'₅₄. Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―Ján₃ bá₄ tsá₃ juá'₄ jniá₂ 'ein₂ cuë₅ bí₂ 'éi'₃ a₂jmo₂₃ ca₂le₃jë́₃ 'e₂ a₂jmo₂₃ ŋɨ₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jaun₂ ca₂jme₃lióg₃ Jesús ca₂juá'₂ quian'₅₄ jág₁ a₂jáng'₅ léi₄. Ca₂juá'₂: ―Jme₁chan₂ jan₂ dsa₂ ca₂chéin'₃ uɨng₂ a₂'ag₅ mɨ́g₂ uvas ja₁nau₂ quió'₅. Jaun₂ ca₂jmo₃ jnɨ́₁ le₃lág'₃. Jaun₂ ca₂jmo₃ co₂jŋia₅₄ ja₁jlein'₃ mɨ́g₂. Jaun₂ ca₂chi'₃ caun₂ tsɨ₁'né₅ ŋei₅ ja₁guá₃ jmo₃ 'í₁. Jaun₂ ca₂lɨ́'₃ jág₁ quian'₅₄ dsa₂ sián'₂ i₂nio₃ ne₄ ja₁nau₂, Jaun₂ ca₂ŋó₃ bá₄ 'ŋiog₅ i₂ŋɨ́₃ juɨg₂ siá'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jme₁ca₂të́₂ jein₂ a₂ca₂rau₂ mɨ́g₂, jaun₂ ca₂chen₃ dsa₂ juɨg₅₄ ja₁nau₂ jan₂ dsa₂ mozo quiáin₅ a₂jme₁i₂mɨ́₃ a₂jáng'₃ dsa₂ ca₂dsio₄ mɨ́g₂ con'₂ a₂ca₂tɨ́n₂ dsa₂ juɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Dsa₂ jmó'₂ ta₁ ja₁nau₂ në́₃, 'nió'₄ a₂jme₁cuë₃ a₂mɨ₅ dsa₂ 'éi₂, ca₂jŋau'₃, ca₂cuë́'₃ dsa₂ 'éi₂ tioin'₅₄, ca₂dsióg'₂ bá₄, tsá₃ 'e₂ ca₂jáng'₃ a₂jme₁mɨ₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dsa₂ juɨg₅₄ ja₁nau₂ në́₃ ca₂chein₃ táng₃ jan₂ dsa₂ mozo sián'₂. I₂'éi₂ në́₃, ca₂cuɨ́'₂ mɨ₂dsi₅₄, ca₂jmóg'₂ dsa₂ 'éi₂, jë₂ bá₄ ca₂të₂ca₂'o'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jaun₂ dsa₂ juɨg₅₄ ja₁nau₂ në́₃ ca₂chein₃ bá₄ guë́₄ jan₂ dsa₂ sián'₂ táng₃, la₁ i₂'éi₂ guë́₄ në́₃ ca₂jŋɨi'₃. Juɨn₅ guë́₄ i₂sián'₂ ca₂i₁len₅₄ ján₃. I₂lɨn₅₄ 'éi₂ qui₂ca₂cuë́'₃, i₂lɨn₅₄ guë'₂ ca₂jme₃dsiain₂₃ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Dsa₂ juɨg₅₄ ja₁nau₂ në́₃ jme₁chan₂ guë́₄ jan₂ ja₁ŋi'₅₄ i₂jme₁'nioi₃ guë́₄ lɨn₃. Jaun₂ ca₂chein₃ 'éi₂, ia₁ lɨ́in₂: “Jme₃gan₃ dsa₂ chi'₂ quiáng₃.” ");
INSERT INTO cntNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","La₁ dsa₂ tion'₅₄ ja₁nau₂ në́₃, ca₂dsia₃: “I₂në₅ bá₄ tɨn₃ ja₁nau₂ la₂ cang₂; në₃ o₁jŋɨ́i'₄ jniog₄, ia₁jaun₂ jniog₄ bá₄ lé₂ quián₂”. ");
INSERT INTO cntNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jaun₂ le₂jaun₂ bá₄ ca₂jmo₃. Ca₂jŋɨi'₃ bá₄ 'éi₂ tioin'₅₄. Jaun₂ ca₂dsei₂₃ le₃co'₅₄ jnɨ́₁. ");
INSERT INTO cntNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","'Jaun₂, ¿'e₂ jmo₃ dsa₂ juɨg₅₄ ja₁nau₂? Jŋiói'₂ jme₃dsiain₂₃ ca₂le₃jɨ́n₃ dsa₂ i₂tion'₅₄ jmó'₂ ta₁ ja₁nau₂ quió'₅, jaun₂ dsia₃ gu₂ dsa₂ sián'₂ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Tsa₁ ma₂'í'₂ 'nia'₂ Si₂ ja₁juá'₂: Nɨ₁cang₁ a₂tsá₃ ca₂rë₃ji'₅₄ të₅'ia'₂, ca₂dsióg₃ ca₂lë₃ nɨ₁cang₁ a₂dsen₅₄ guë́₄ a₂të₁ron₅₄ qui'₅₄ 'ia'₂; ");
INSERT INTO cntNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","con'₂ në₅ lë́₅ ca₂jmo₃ Te₁gui'₅₄, jaun₂ 'ŋio₅ lɨn₃ bá₄ jlá'₁, lág₂ jniog₄? ");
INSERT INTO cntNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jaun₂ jme₁'no'₂ dsa₂ juɨ₅ a₂jme₁tsáun'₂, ia₁ ca₂rë₃lí'₄ bá₄ guioin₅₄ a₂juá'₂ Jesús jág₁ jáng'₅ léi₄ në₅ a₂'ɨin₂₃ 'éi₂ bá₄. La₁ ca₂rë₃gain₃ bá₄ dsa₂ juɨn₅ i₂quian'₅₄ Jesús. Jaun₂ i₂lein₃ bá₄, tsá₃ ma₃ca₂jŋau'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jaun₂ ca₂chen₃ dsa₂ can'₅₄ i₂lɨn₅₄ dsa₂ fariseos, quian'₅₄ i₂lɨn₅₄ dsa₂ quián₅ Rag₅₄ Herodes a₂dsɨ₃chi'₅₄ 'e₂ dsɨ₃chi'₅₄ Jesús, ia₁jaun₂ cuɨn₅ jmɨg₄ jo₅₄ juɨ₁lia'₂ bá₄ 'ŋiái₃ ca₂jon₄ jág₁ 'lia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jaun₂ ca₂o₃léin₂ ca₂juá'₂: ―Të₅, ne₄ bá₄ jnia'₅₄ a₂dsón'₂ bá₄ juá'₂ 'ne₂ lia'₂ tí₅ jág₁. Jaun₂ tsá₃ can'₂ 'ne₂ jág₁ jua'₅₄ a₂quian'₅₄ o₂i₁ dsɨ₅ 'e₂ 'ag₅ dsa₂, ia₁ tsá₃ gang'₃ jmag'₅₄ juɨ₁lia'₂ dsa₂ dsen₅₄ në́₃. Caun₂ qui₂jme₂tɨ́ng'₁ bá₄ dsa₂ juɨ₅ quió'₅ Diú₄. ¿'I₄ 'éi'₃ qui₅₄ 'lia'₅₄ a₂ca₂tɨ́n₂ dsɨ₂tan₅₄ César? ¿'Nió'₅ qui₅₄ o₃ tsá₃ qui₅₄ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","La₁ ŋi₅ rë₂ bá₄ Jesús a₂lë₁i₂nio₄ juá'₂ o₁ne₁ bá₄ dsa₂ 'éi₂. Jaun₂ ca₂juá'₂: ―¿'E₂ lë₃ cáun'₂ 'nia'₂ táu₂ jniá₂? O₂quian₂ de'₂ 'nia'₂ caun₂ cu₄ denario jaun₂ jág₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jaun₂ ca₂i₁quian₅₄ dsa₂. Jaun₂ jme₁ca₂jág₃ Jesús, jaun₂ ca₂ŋag₃: ―¿'Ein₂ dsɨ₂ne₄ chi₁ton₅ ja₁lá₃? ¿'Ein₂ quió'₅ letra në́₃? Jaun₂ ca₂ŋag₃: ―Quió'₅ gui'₅₄ emperador César bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jaun₂ ca₂juá'₂ táng₃ Jesús: ―Jang'₅₄ 'nia'₂ ne₄ César con'₂ a₂ca₂tɨ́n₂ César; ne₄ Diú₄ në́₃ jang'₅₄ 'nia'₂ con'₂ a₂ca₂tɨ́n₂ Diú₄. Jaun₂ ca₂i₃gó'₃ dsɨ́₅ jɨ́in₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jaun₂ ca₂o₃lén₂ i₂lɨn₅₄ dsa₂ saduceos ca₂o₃jɨin₅₄ Jesús. Ia₁ tsá₃ 'én₂ dsa₂ 'éi₂ a₂jen'₅₄ táng₃ dsa₂ jë₁ma₂dsain₃. Jaun₂ ca₂tsɨ́'₃ Jesús: ");
INSERT INTO cntNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Të₅, ca₂quiog₂ Moisés si₂ a₂juá'₂, në₁jua'₂ ca₂jon₃ jan₂ dsa₂ ŋe'₂ të₃ tsá₃ ca₂can₃ 'io₅₄ quiáin₅ guein₂, tion'₅₄ 'nió'₅ jén'₂ gu₂ dsó₂ rɨn'₅₄ dsa₂ ŋe'₂ i₂ca₂jon₃ quiain'₅₄ 'io₅₄ 'nág₂ 'éi₂, ia₁jaun₂ guein₂ i₂le₃chan₂ quiáin₅, lé₂ co₂'nió'₄ tsɨ₁jon₂ 'lag₄ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","'Ia₁ jme₁chan₂ guion₃ dsa₂ ŋe'₂ i₂lɨ́n₅ jmá'₃ lia'₂ rɨn'₅₄. Ca₂jen'₂ gu₂ i₂le₂'uɨg₅₄, la₁ ca₂join₃ bá₄ të₃ tsá₃ guein₂ ca₂can₃ 'io₅₄ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jaun₂ ca₂jen'₂ táng₃ gu₂ 'io₅₄ 'nág₂ 'éi₂ quiain'₅₄ jë₁ca₂të́₂ on₃. Ján₃ bá₄ le₂jaun₂ ca₂jon₃ táng₃ dsó₂ 'éi₂, tsá₃ guein₂ ca₂can₃ 'io₅₄. Ján₃ bá₄ le₂jaun₂ ca₂lë₃ quian'₅₄ jë₁ca₂të́₂ ún₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Le₂jaun₂ bá₄ ca₂lë₃ quian'₅₄ ta₁guion₃ dsa₂ ŋe'₂ con'₂ i₂jme₁lë́₄ rɨn'₅₄: ca₂dsain₃ bá₄ të₃ tsá₃ guein₂ ca₂can₃ 'io₅₄ 'i₁jan₂ quiain'₅₄ 'i₁jan₂ dsó₂ 'éi₂. Jaun₂ ca₂jon₃ 'io₅₄ jme₁ca₂join₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jaun₂ në́₃, jmɨg₄ jë₁ma₂të́₂ rë₁jen'₅₄ 'lag₄, ¿'ein₂ bá₄ quián₅ lé₂ 'io₅₄ 'éi₂? Ia₁ ta₁guion₃ bá₄ guë'₂ dsa₂ ŋe'₂ ca₂guá₂ quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jaun₂ ca₂ŋag₃ Jesús: ―'E₂ guë́₄ tsá₃ rë₂ ŋɨ́'₂ 'au'₂ 'nia'₂, ia₁ a₂tsá₃ cuɨn'₂ 'nia'₂ 'a₂ lia'₂ juá'₂ Si₂, on₃ guë'₂ cuɨn'₂ 'nia'₂ 'a₂ lia'₂ lë́₅ juɨ₅bí₂ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Jë₁ma₂të́₂ jmɨg₄ a₂jen'₅₄ 'lag₄, on₃jua'₅₄ a₂le₃chain₂ jua'₅₄ a₂qui₃jéin'₂ guë́₄ gu₂, on₃ guë'₂ në₅ tóin'₃ guë́₄ jua'₅₄ a₂qui₃cuɨin₃ chi'₂ quiáin₅ a₂jéin'₂ gu₂, ia₁ i₂lén₂ juɨ₁lia'₂ lɨ́n₅ ángeles i₂tion'₅₄ guei'₅₄ i₂juɨ́g₃ bá₄ 'éi₂ jmɨg₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","La₁ juɨ₁lia'₂ a₂jen'₅₄ táng₃ 'lag₄, ¿tsa₁ ma₂'í'₂ 'nia'₂ Si₂ quió'₅ Moisés juɨ₁lia'₂ ja₁juá'₂ 'ë₂₃ nɨ₁'ma₂ taun₅, ja₁ca₂juá'₂ Diú₄ ca₂tsɨ́'₃ Moisés: “Jniá₂ bá₄ lɨ́ng₅ Diú₄ quián₅ Abraham, quián₅ Isaac, quián₅ Jacob në́₃?” ");
INSERT INTO cntNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A₂lɨ́in₅ Diú₄ quian₅ dsa₂ jén'₃ bá₄, on₃jua'₅₄ rë'₂ Diú₄ quián₅ 'lag₄. Jaun₂ 'ŋio₅ lɨn₃ tsá₃ rë₂ ŋɨ́'₂ 'au'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jaun₂ ca₂guan₃ jan₂ të₅juá'₅, ca₂nág₂ jág₁ a₂tsɨn₅ Jesús quian'₅₄ dsa₂, ca₂rë₃lí'₄ bá₄ a₂ca₂ŋag₃ Jesús lia'₂ tí₅ jág₁. Jaun₂ ca₂ŋag₃: ―¿'E₂ 'Éi'₃ Juá'₅ a₂le₂'uɨg₅₄ a₂lë́₅ a₂dsen₅₄ guë́₄ con'₂ guë́₄ ca₂le₃jë́₃ juá'₅? ");
INSERT INTO cntNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jaun₂ ca₂ŋag₃ Jesús: ―'Éi'₃ Juá'₅ le₂'uɨg₅₄ con'₂ guë́₄ ca₂le₃jë́₃, juá'₂: “Nei₂ 'nia'₂ dsa₂ chan₂ juɨg₂ Israel. Jan₂ Te₁gui'₅₄ bá₄ lɨ́n₅ Diú₄ quián₂ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jme₁'nió₄ 'nia'₂ Te₁gui'₅₄ Diú₄ quiáng'₂ ca₂le₃jë́₃ 'au'₂, ca₂le₃jë́₃ jme₂dsí₂ quiáng'₂, ca₂le₃jë́₃ 'a₂ lia'₂ ŋɨ́'₂ dsei'₂, ca₂le₃jë́₃ bí₂ quiáng'₂.” ");
INSERT INTO cntNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jë₁ca₂të́₂ tɨn₃ juá'₅ në́₃ juá'₂: “A₂jme₁'nióg'₄ dsa₂ mɨ₂güɨ́g₃ rɨ́ng'₂ juɨ₁lia'₂ 'niog'₂ 'ŋiag'₂.” Jŋia'₅₄ lia'₂ a₂tɨn₃ në₅ bá₄ juá'₅ a₂lë́₅ a₂dsen₅₄ guë́₄ con'₂ guë́₄ ca₂le₃jë́₃ 'Éi'₃ Juá'₅ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jaun₂ ca₂ŋag₃ të₅juá'₅ 'éi₂: ―Të₅, 'ŋio₅ dse₃ lia'₂ në₂ŋag'₅₄; a₂dsón'₂ bá₄ dsau₅ jan₂ bá₄ Diú₄ i₂chan₂, tsá₃ ma₃'ein₂ diú₄ sián'₂ chan₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","A₂jaun₂ bá₄ a₂dsen₅₄ guë́₄ a₂jme₃'nio₃ dsa₂ Diú₄ ca₂le₃jë́₃ dsɨ́₅, ca₂le₃jë́₃ jme₂dsí₂, ca₂le₃jë́₃ bí₂ quió'₅; a₂jme₃'nio₃ dsa₂ rɨin'₅₄ juɨ₁lia'₂ 'nioi₃ 'ŋiog₅. A₂jaun₂ bá₄ a₂quen₅ guë́₄ con'₂ guë́₄ ca₂le₃jë́₃ 'e₂ niog₅ jén'₅ dsa₂ ne₄ Diú₄, o₃ 'e₂ a₂qui₂dsɨ́'₂ dsa₂ ne₄chei₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jaun₂ jme₁ca₂nág₂ Jesús ca₂ŋag₃ bá₄ dsa₂ 'éi₂ a₂ŋɨ́'₂ dse₃ dsɨ́₅, jaun₂ ca₂juá'₂: ―Tsá₃ uɨ́ng₂ ŋɨ'₂ ja₁gon₂ Diú₄. Jaun₂ të₂le₃ ne₄ juɨ₅ guë́₄ jaun₂, tsá₃ ma₃'ein₂ ca₂tiá₂ dsɨ́₅ jua'₅₄ a₂ŋág₃ guë́₄ 'e₂ ŋag₃. ");
INSERT INTO cntNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jaun₂ ca₂jéin'₃ Jesús jág₁ jë₄ jme₂tɨin₂₃ dsa₂ i₁dsi₅ guá'₅ templo, jaun₂ ca₂juá'₂: ―¿'A₂ lia'₂ lë́₅ juá'₂ të₅juá'₅ a₂lɨ́n₅ tsɨ₁jon₂ David I₂rë₂'ɨ́n₁ quián₅ Diú₄, ");
INSERT INTO cntNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ton'₂ 'ŋiog₅ bá₄ guë'₂ David ca₂juá'₂ lia'₂ con'₂ jme₁ca₂'í₃ Jme₂dsí₂ Jŋió₅ të₂dsɨ́₅: Ca₂juá'₂ Diú₄ ca₂tsɨ́'₃ Te₁gui'₅₄ quiáng₃: “Né₂ con₂ jniá₂ të₂le₃ gu₃ ne₁, ca₂lia'₂ ca₂të́₂ jmɨg₄ a₂tón'₁ jniá₂ dsa₂ i₂'iog₅₄ o₄tag'₄”? ");
INSERT INTO cntNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿'A₂ bá₄ lia'₂ lë́₅ jaun₂ a₂lɨ́in₅ tsɨ₁jon₂ David, ton'₂ 'ŋiog₅ bá₄ guë'₂ David ca₂të₃ “Te₁gui'₅₄ quiáng₃?” Ca₂le₃jɨ́n₃ dsa₂ juɨn₅ 'éi₂ jme₁nag₂₃ 'ŋio₂ dsɨ́₅ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Të₃jë₄ jme₂tɨin₂₃ dsa₂, ca₂juá'₂: ―Ŋí₂ 'nia'₂, jmo₄ 'nia'₂ 'í₁ tsá₃ i₂can₂ 'nia'₂ juɨ₅ juɨ₁lia'₂ niog₅ lɨ́n₅ të₅juá'₅. Ia₁ të₅ dsɨ́₅ i₂nioi₅₄ le₁qui'₂ 'mɨ'₂ chen'₅₄ jang₄, ton'₂ të₅ dsɨ́₅ qui₂cuag₃ dsa₂ Diú₄ jë₄ 'ma'₅₄, ");
INSERT INTO cntNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ton'₂ jmá'₃ lia'₂ ja₁dsen₅₄ bá₄ qui₂dsɨ₂tiain'₂ juɨ₁lia'₂ dsi₂néi₂ guá'₅ sinagoga, ton'₂ jmá'₃ lia'₂ ja₁dsen₅₄ bá₄ dsɨ₂toin'₅₄ ja₁dsɨ₂guë́'₃ juɨ₁lia'₂ ja₁niog₅ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Qui₂jŋiá'₂ 'ne₄ 'io₅₄ 'nág₂ në́₃, jaun₂ a₂jŋia'₅₄ con'₂ 'ma₂₃ jlë₅ a₂jmo₂₃ jaun₂, chi₂léin'₂ Diú₄ uë́₂ lɨn₃ të₃jɨn₄ dsa₂. La₁ 'e₂ guë́₄ uɨg₅ cuë₃ Diú₄ quió'₅ i₂le₂'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Co₂ráun₂ guá₅ Jesús i₁dsi₅ guá'₅ cau₅ tsɨ₁gu₅ ja₁tó'₅ dsa₂ cu₄ ofrenda. Jaun₂ guá₅ jɨ́in₂ dsa₂ i₂dsɨ₂lén₂ dsɨ₂tio'₂ cu₄ 'ŋió'₃ tsɨ₁gu₅. Jaun₂ në́₃, juɨn₅ dsa₂ cha₂ cu₄ dsɨ₂lén₂ dsɨ₂tio'₂ 'lióng₂ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","La₁ të₃jë₄ jaun₂ ca₂dsióg₃ jan₂ 'io₅₄ 'nág₂ te₂ŋé₂. Jaun₂ ca₂tó'₂ tɨn₃ ŋí₁ guéin₂. ");
INSERT INTO cntNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jaun₂ ca₂të́'₃ Jesús chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂juá'₂: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, 'lióng₂ guë́₄ në₂tió'₂ 'io₅₄ 'nág₂ te₂ŋé₂ në₅, lia'₂ con'₂ guë́₄ ca₂le₃jɨ́n₃ i₂ma₂në₂tió'₂ 'ŋió'₃ tsɨ₁gu₅. ");
INSERT INTO cntNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ia₁ 'éi₂ në́₃ cu₄ a₂ma₂qui₂rë₂tsón₂ bá₄ jaun₂ quió'₅ cuë₂₃. 'Io₅₄ 'nág₂ në₅ në́₃, ca₂le₃jë́₃ bá₄ në₂cuë₃, con'₂ a₂jme₁ron₅ quió'₅, 'nió'₄ a₂jme₁lá₃ a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Con'₂ jme₁ma₂'ein₅₄ juɨ₅ o₂'ɨin₅ i₁dsi₅ guá'₅, jaun₂ ca₂juá'₂ jan₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―¡Të₅, jag₄ 'e₂ guë́₄ jlá'₁ nɨ₁cang₁ a₂le₁juɨ́₄ a₂lë́₅ guá'₅! ");
INSERT INTO cntNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jaun₂ ca₂ŋag₃ Jesús: ―¿Jág'₂ 'né₅ ca'₅₄ a₂te₁'i₁ në₅? Já₅ caun₂ jmɨg₄, 'i₁ca₂mɨ́g₂ nɨ₁cang₁ tsá₃ ma₃'e₂ le₁juɨ́₄ lé₂. ");
INSERT INTO cntNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jme₁ca₂dsióg₃ Jesús má'₂ Olivos a₂chí'₅ quióng₄ guá'₅, ja₁jaun₂ ca₂guá₂. Jaun₂ ca₂guan₃ Pe₄, Jacobo, quiain'₅₄ Juan₅₄, Drë́₄ në́₃, ca₂tsɨ́'₃ Jesús con'₂ jë₄ të₃co'₅₄: ");
INSERT INTO cntNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Jua'₅₄ lɨ́g'₂ bá₄ le₃ti₃ a₂juá'₂ 'ne₂ në₅. 'Niog₂ jnia'₅₄ le₃ne₄. ¿'E₂ léi₄ a₂lé₂ né'₃ a₂të₅₄ jmɨg₄ jaun₂? ");
INSERT INTO cntNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jaun₂ ca₂ŋag₃ Jesús: ―Jmo₄ 'nia'₂ 'í₁ ia₁jaun₂ tsá₃ 'ein₂ jme₃gau₅. ");
INSERT INTO cntNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ia₁ juɨn₅ i₂të₁i₃nio₄ a₂juá'₂ i₂nioi₅₄ o₄quió₃ jniá₂, juá'₂: “Jniá₂ bá₄ lɨ́ng₅ 'éi₂,” jaun₂ juɨn₅ dsa₂ i₂qui₂jme₃gain₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Jë₁ma₂nei'₂ 'nia'₂ 'ei₅ jág₁ a₂nio₃ 'nei₂ a₂quɨ́n'₂ dsa₂ ja₁lá₃ ja₁ó₃, la₁ tsá₃ jmó₁ 'nia'₂ gang'₃, ia₁ le₂jaun₂ dsón'₂ lé₂ bá₄. La₁ on₃jua'₅₄ jmɨg₄ jë₁ca₂tó'₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ia₁ nio₃ 'nei₂, qui₃quɨ́n'₂ dsa₂ le₂caun₂ le₂caun₂ juɨg₂ nación; dsɨ₂tan₅₄ guë'₂ në́₃ qui₃tóin'₃ mɨ'₅₄ quɨ́in'₂ quian'₅₄ dsɨ₂tan₅₄ rɨin'₅₄ i₂chan₂ juɨg₂ siá'₂. 'Lióng₂ ja₁qui₂dsɨ₃bi₅₄ 'uë₃ lé₂, ton'₂ le₃cha₂ 'lióng₂ ja₁qui₂i₂nio₄ dsa₂ 'oin₅₄. A₂le₂'uɨg₅₄ jmɨ₁uɨg₅ bá₄ guë́₄ në₅, juɨ₁lia'₂ jan₂ 'io₅₄ i₂rë₂chan₂ guein₂ quián₅. ");
INSERT INTO cntNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Rë₂ján'₁ 'nia'₂ chang'₂, ia₁ qui₃jɨ́n'₂ dsa₂ 'nia'₂ ne₄ dsɨ₂tan₅₄ quián₅ guá'₅ ia₁jaun₂ bóg₂ dsa₂ dsi₂néi₂ guá'₅ sinagogas. Jaun₂ dsi₁nó'₅ 'nia'₂ të₃ne₄ dsi₄má'₂, ne₄ rag₅₄ në́₃, 'uɨg₅₄ quió₃ jniá₂; ja₁jaun₂ o₁jang'₄ 'nia'₂ jág₁ dsau₅. ");
INSERT INTO cntNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Jág₁ quió'₅ Diú₄ de'₂ jŋiá₅ 'nió'₅ dsɨ₃'ag₅ le₂con₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jë₁ma₂të́₂ rë₁qui₃të₂ dsa₂ 'nia'₂ a₂dsi₁jó₂ ne₄ dsɨ₂tan₅₄, tsá₃ jmó'₂ 'nia'₂ 'ɨ₅ 'au'₂ të₃jŋiá₅ 'e₂ ŋag'₅₄. La₁ ŋag₄ bá₄ 'nia'₂ con'₂ jág₁ a₂ma₂ca₂ŋɨ'₂ 'nia'₂ hora jaun₂, ia₁ on₃jua'₅₄ guion'₅₄ 'nia'₂ a₂ŋag'₅₄ jág₁ jaun₂; Jme₂dsí₂ Jŋió₅ bá₄ i₂jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ia₁ tón'₃ dsa₂ qui₃jɨ́in'₂ rɨin'₅₄ jmɨg₄ jaun₂, jaun₂ jŋag'₃ dsa₂; juɨ₁lia'₂ jmei₂ qui₃jɨ́in'₂ chi'₂ quiáin₅. Chi'₂ guë'₂ në́₃, jme₃'ŋiai₅₄ chog₅₄-jmei₂; chan₂ guë'₂ i₂qui₂jme₃dsian₅ chog₅₄-jmei₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ca₂le₃jɨ́n₃ dsa₂ jme₃'ŋia₅₄ 'nia'₂ 'uɨg₅₄ quió₃ jniá₂, la₁ juɨ₁lia'₂ i₂tió'₃ náu₃ tiá₂ të₂ jë₁ca₂tó'₂, tɨ́in'₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Jaun₂ në́₃, já₅ jmɨg₄ a₂të₅₄ ne'₅₄ 'nia'₂ a₂náu₃ jan₂ dsa₂ i₂juɨ₁si 'lɨn'₅₄ ja₁tsá₃ 'i₄ 'éi'₃ náu₃, ―jaun₂ juɨ₁le₂ŋɨ́'₂ bá₄ i₂'ɨ₅ si₂ la₂―; jaun₂ në́₃, dsa₂ i₂tián'₅ le₂tan₅₄ 'uë₃ Judea, juɨ₁cuɨng₁₂ juɨ₅ má'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Juɨ₁lia'₂ i₂'en₅₄ guei'₅₄ 'ne₄, tsá₃ juɨ₁sióin₄ jua'₅₄ a₂'uë́'₃ 'e₂ 'uë́'₃ dsi₂néi₂ quió'₅; ");
INSERT INTO cntNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","juɨ₁lia'₂ i₂'en₅₄ ja₁nau₂ quió'₅ táng₃, tsá₃ ma₃juɨ₁jŋioi'₅₄ jua'₅₄ a₂ja₃quián₂ tsɨ₁'mɨ'₂ dsióg₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Juɨ́g₂ bá₄ juɨ₁lia'₂ dsa₂ mɨ́₂ i₂le₁quian₅ guein₂, juɨ₁lia'₂ i₂chan₂ guein₂ bë'₅₄ i₂'ɨ́n'₂ dsi'₅₄ quió'₅ në́₃, jmɨg₄ jaun₂! ");
INSERT INTO cntNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mɨ₄ 'nia'₂ ne₄ Diú₄ tsá₃ juɨ₁dsi₂ŋɨ́'₂ 'nia'₂ a₂jaun₂ juɨ₁lia'₂ jein₂ güɨ́g₂. ");
INSERT INTO cntNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ia₁ juá'₅ jniá₂, caun₂ o₂i₁ dsɨ₅ lɨn₃ a₂le₃chan₂ dsa₂ jmɨg₄ jaun₂, caun₂ jmɨ₁uɨg₅ a₂tsá₃ ma₂ca₂rë₃chá₃ ca₂le₃ ca₂nio₃ mɨ₂güɨ́g₃, on₃ guë'₂ ma₃niog₅ jmɨg₄ jua'₅₄ a₂le₃cha₂ guë́₄ cang₂. ");
INSERT INTO cntNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jua'₅₄ mei'₂ guë́₃ Te₁gui'₅₄ tsá₃ ma₂ca₂jme₃të́₃ jmɨg₄ jaun₂, 'i₁jan₂ tsá₃ 'ein₂ jme₁lión₂ jua'₅₄ mei'₂ guë́₃ tsá₃ le₂jaun₂. La₁ ma₂ca₂jme₃të́₃ bá₄ jmɨg₄ jaun₂ o₄quió'₄ i₂quion'₅₄ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Në₁jua'₂ chan₂ i₂ca₂juá'₂ tsɨ́'₅ 'nia'₂ jmɨg₄ jaun₂: “¡Jag₄ 'nia'₂! La₂ bá₄ chén'₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄”, o₃ në₁jua'₂ 'ein₂ ca₂juá'₂: “Jó₄ 'ein₅₄”, tsá₃ o₁'en'₅₄ 'nia'₂ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ia₁ juɨn₅ dsa₂ i₂jme₃gau₅ ja₃lén₂ a₂juá'₂ lɨ́in₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄, a₂juá'₂ në́₃ a₂lɨ́in₅ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄; 'lióng₂ léi₄ juë'₂ a₂o₂dsain₂ jmo₃ a₂jme₃gain₂₃ dsa₂. Jua'₅₄ mei'₂ guë́₃ lé₂, ca₂të₂ dsa₂ i₂quion'₅₄ quián₅ Diú₄ jme₃gain₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","La₁ chan'₂ 'nia'₂ rë₂jáng'₁, jaun₂ le₂në₅ ma₂në₂juɨ́g₂ jniá₂ 'nia'₂ ca₂le₃jë́₃ të₃jŋiá₅. ");
INSERT INTO cntNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jë₁ma₂ca₂ŋag₅ jmɨg₄ o₂i₁ dsɨ₅ jaun₂, 'iog₂ në́₃ co₂dsia₅ le₃lia'₂, tsɨ'₂ në́₃ tsá₃ ma₃tág₅ jnia₅₄; ");
INSERT INTO cntNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nei₅ guë'₂ në́₃ qui₂tsɨ₃séi'₂; ca₂le₃jë́₃ guë́₄ 'e₂ bí₂ cha₂ guei'₅₄ mɨ₂güɨ́g₃ qui₃guian'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","’Të₃jë₄ jaun₂ guë́₄ në́₃, jɨ́n₂ dsa₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃, jŋiói'₂ guei'₅₄ jë₄ jnei₅ quian'₅₄ ca₂le₃jë́₃ juɨ₅bí₂ a₂'io₂₃ jláin'₁. ");
INSERT INTO cntNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jaun₂ qui₃chein₃ ángeles quiáin₅, a₂të₂ dsa₂ i₂quion'₅₄ quiáin₅ i₂chan₂ ca₂le₃jë́₃ juɨg₂ te₁'i₁ ca₂taun₂ ca₂taun₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Jme₁tɨn₅ 'nia'₂, juɨ₁le₂ŋɨ́'₂ 'au'₂ jág₁ a₂jáng'₅ léi₄ juɨ₁lia'₂ nɨ₁'ma₂ a₂'ag₅ mɨ́g₂ higos; jme₁chéi'₂ gu'₂-nei'₅₄, qui₂ja₂'iá₃ mog'₅₄ në́₃, ŋi'₅₄ bá₄ 'nia'₂ a₂ma₂ja₂quián₃ jein₂ 'iog₂ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Le₂në₅ bá₄ 'nia'₂ jaun₂ në́₃, jë₁ma₂të₅ ne'₅₄ a₂lë́₂ ca₂le₃jë́₃ a₂në₅, juɨ₁le₂ŋi'₅₄ bá₄ 'nia'₂ a₂ma₂ja₂quiáin₃, në₂jag₄ bá₄ i₂ma₂chén'₅ o₄'né₄ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A₂dsɨ₂jó'₃ juá'₅ jniá₂ juɨ́g₂ 'nia'₂, tsá₃ dsɨ₃ŋɨ́₂ tsɨ₁jon₂ la₂, ca₂lia'₂ ca₂lë₃ ca₂le₃jë́₃ a₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Jaun₂ já₅ jmɨg₄, guei'₅₄ dsi₂güɨg₂ quian'₅₄ mɨ₂güɨ́g₃ la₂ ŋag₅, la₁ jág₁ quió₃, o₁lɨ́g'₂ jmɨg₄ tsá₃ ŋag₅ jua'₅₄ a₂tsá₃ le₃ti₃. ");
INSERT INTO cntNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’La₁ 'i₁jan₂ tsá₃ 'ein₂ ŋi₅ 'e₂ 'ió'₄, 'e₂ hora lé₂ a₂jaun₂, on₃ guë'₂ ángeles i₂tion'₅₄ guei'₅₄ i₂juɨ́g₃, on₃ guë'₂ 'ŋiog₅ Ja₁ŋi'₅₄ Diú₄. Jŋia'₅₄ lia'₂ 'ŋiog₅ bá₄ Diú₄ Jmei₂ ŋi₅. ");
INSERT INTO cntNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Chan'₂ 'nia'₂ rë₂jáng'₁, jme₁jnio₂ 'nia'₂ ne'₅₄, ia₁ tsá₃ ŋi'₅₄ 'nia'₂ 'e₂ jmɨg₄ lé₂. ");
INSERT INTO cntNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lé₂ juɨ₁lia'₂ jan₂ dsa₂ i₂o₂'ɨn₅ dsi₂néi₂ quió'₅, dsó₅ dsɨ₂ŋɨ́₃ uɨ́ng₂; dsia₂₃ gu₂ dsa₂ i₂jme₂ti₃ ne₅₄ dsi₂néi₂ quió'₅, le₂jan₂ le₂jan₂ 'éi₂ jma₃quén₅ ta₁ cuë́'₅ con'₂ ca₂tɨ́in₂, tsɨ́'₅ mozo i₂jmo₅ 'í₁ o₄'né₄ a₂chain₂ rë₂jáin₁. ");
INSERT INTO cntNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jaun₂ le₂në₅ bá₄ 'nia'₂ ján₃, rë₂jáng'₁ 'nia'₂ chang'₂, ia₁ tsá₃ ŋi'₅₄ 'nia'₂ 'e₂ 'ió'₄ guan'₂ dsa₂ i₂quió'₅ dsi₂néi₂, të₂le₃ ca₂nei₂, o₃ dsi₃nei₅, o₃ jë₁ma₂ca₂'o₃ i₁tú₃, o₃ të₂le₃ ca₂jnia₃ 'e₂, ");
INSERT INTO cntNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ ca₂guáin'₃ co₂tiá₂, jo₅₄ rë₂güɨ́n'₃ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jaun₂ jág₁ a₂juɨ́g₂ jniá₂ 'nia'₂ la₂, juɨ́g₂ ca₂le₃jɨ́n₃: “¡Chan'₂ 'nia'₂ rë₂jáng'₁!” ");
INSERT INTO cntNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tɨn₃ jmɨg₄ né'₃ a₂të₅₄ Jmɨg₄ Të₂'ɨn₅₄, a₂guë́'₅ dsa₂ i₁ŋí'₄ 'ua'₂ a₂tsá₃ juɨ₁ levadura quian'₅₄, jaun₂ juɨg₅₄ jme₂dsa₂, të₅juá'₅ në́₃ ca₂'náu'₃ juɨ₅ 'a₂ lia'₂ tsáin'₂ Jesús quian'₅₄ caun₂ mai₅₄, jaun₂ jŋag'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jaun₂ ca₂dsia₃ jág₁, juá'₂: ―La₁ tsá₃ 'nió'₅ jmó₁ jniog₄ të₃ niog₅ jmɨg₄, jme₁né₄, ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ ca₂tó'₂ dsa₂ juɨg₂ mɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Lia'₂ con'₂ 'ein₅₄ guë́₄ juɨg₂ Betania ja₁quió'₄ i₂të́'₂ dsa₂ Si₂mu₅₄ 'Mé'₅ 'Iog₅, jaun₂ ca₂dsióg₃ jan₂ 'io₅₄ quian₅ caun₂ tsɨ́₅ no'₅₄ mɨ₂juɨg₂ a₂'mu'₅₄, a₂lë́₅ jmá'₃ no'₅₄ quió'₅ mɨ₁'au₂ nardo. Jaun₂ ca₂niá₃ nɨ₁tsɨ́₅, jaun₂ ca₂'ág₂ no'₅₄ mɨ₂dsi₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jaun₂ i₂lɨn₅₄ dsa₂ i₂tion'₅₄ ja₁jaun₂, dséin₂ ca₂tɨ́in₂, jaun₂ ca₂dsia₃: ―Tsá₃ ne₄ 'e₂ lë₃ në₂'éin₂ no'₅₄ mɨ₂juɨg₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Jua'₅₄ co₂ŋei'₅₄ bá₄ në₂'nag₃ quian'₅₄ 'nɨ₅ 'ŋiá₂-láu₂ 'éi'₃ cu₄ denario, jaun₂ jme₁jme₂'oin₅₄ dsa₂ te₂ŋé₂. Jaun₂ ca₂dséin₃ quiain'₅₄ 'io₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jaun₂ ca₂juá'₂ Jesús: ―Tsá₃ lë₁lein'₅₄. ¿'E₂ lë₃ cuë'₂ 'nia'₂ o₂me'₅₄ dsɨ₅? A₂në₂jmóg'₂ në₅, caun₂ a₂dse₃ bá₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ca₂le₃jë́₃ jmɨg₄ bá₄ i₂nio₄ dsa₂ te₂ŋé₂ jɨn'₄ 'nia'₂; lé₂ bá₄ jme₁'oin'₁, chi₂jua'₂ lɨ́g'₂ 'niog'₂ 'nia'₂ jme₁'oin'₁. La₁ jniá₂ në́₃ tsá₃ ma₃uë́₂ 'en₅₄ jniá₂ quian'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","'Io₅₄ në₅, në₂jmo₃ 'a₂ con'₂ jŋia'₅₄ le₃quɨ'₅₄ jmɨg₄ jmo₃. Ma₂në₂tsáng₂ të₂jŋiá₅ no'₅₄ mɨ₂juɨg₂ quió₃, ma₂në₂jmóg'₂ co₂jŋia₅₄ jë₁ma₂të́₂ rë₁'ong₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, ca₂le₂con₂ mɨ₂güɨ́g₃ ja₁'ë́₂ dsa₂ jág₁ dse₃ quió₃, ján₃ bá₄ le₂jaun₂ dsiog'₂ dsɨ́₅ dsa₂ 'ɨin₃ 'io₅₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jaun₂ në́₃ Judas Iscariote i₂jme₁lɨ́n₄ jan₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quián₅ Jesús, ŋei₅₄ i₁dsia₂ jág₁ quian'₅₄ juɨg₅₄ jme₂dsa₂ a₂jáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jaun₂ 'io'₂ jmo₅ dsa₂ can'₅₄ jme₁ca₂nág₂, jaun₂ ca₂jén'₃ cu₄. Jaun₂ guë́₄ në́₃ ca₂'náu'₃ Judas dsɨ́₅ 'a₂ lia'₂ cuɨn₅ jmɨg₄ a₂jɨ́in'₂ Jesús, jaun₂ tsáun'₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jmɨg₄ le₂'uɨg₅₄ a₂niog₅ Jmɨg₄ Të₂'ɨn₅₄ a₂guë́'₅ dsa₂ i₁ŋí'₄ a₂tsá₃ quian'₅₄ levadura, jmɨg₄ a₂jme₁jme₂dsian₅ dsa₂ já'₂ cha'₂ quián₅ jmɨg₄, jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ ca₂ŋɨ́i'₃ Jesús: ―¿A₂já'₄ 'niog'₂ dsɨ₁jmó₁ jnia'₅₄ co₂jŋia₅₄ má₃ Jmɨg₄ Të₂'ɨn₅₄ quiáng'₂? ");
INSERT INTO cntNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jaun₂ ca₂chein₃ on₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, ca₂juá'₂: ―O₂nó'₅ 'nia'₂ jë₄ juɨg₂. Ja₁jaun₂ jen'₂ 'nia'₂ jan₂ dsa₂ ŋe'₂ i₂quion₂ jmɨg₂ quian'₅₄ nɨ₁dsɨg₁. Jaun₂ o₁'én'₃ 'nia'₂ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dsi₂néi₂ ja₁'í₂ 'éi₂, juɨg'₅₄ dsa₂ juɨg₅₄ dsi₂néi₂: “Le₂la₂ juá'₂ të₅, ¿Na₂ dsi₂néi₂ ja₁guë'₄ Jmɨg₄ Të₂'ɨn₅₄ co₂lë₅ quian'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáng₃?” ");
INSERT INTO cntNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jaun₂ 'éi₂ në́₃, 'ë₃ caun₂ dsi₂néi₂ juë'₂ ja₁lë́₄ guei'₅₄ a₂ma₂lë́₅ co₂jŋia₅₄. Ja₁jaun₂ o₂jmo₄ 'nia'₂ co₂jŋia₅₄ má₃ que₅₄ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jaun₂ ca₂i₃lén₂ bá₄ dsa₂ on₃ 'éi₂. Jme₁ca₂dsi₃léin₂ jë₄ juɨg₂ në́₃, ca₂dsó'₂ lia'₂ con'₂ lë́₅ jág₁ ca₂juá'₂ Jesús. Jaun₂ ja₁jaun₂ ca₂jmo₃ co₂jŋia₅₄ má₃ a₂guë́'₃ Jmɨg₄ Të₂'ɨn₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jme₁ca₂nei₂ jaun₂, ca₂dsióg₃ Jesús quiain'₅₄ ta₁guia₃-tɨ́n₂ chi'₂ dsɨ₂guia₃-tɨ́n₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jme₁ma₂tiáin'₅ guë́'₅, jaun₂ ca₂juá'₂ Jesús: ―A₂dsɨ₂jó'₃ juá'₅ jniá₂ la₂, jan'₂ 'nia'₂ i₂guë'₅ jniá₂ co₂lë₅ quiang'₅₄ bá₄ i₂jang'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jaun₂ në́₃ ca₂tá'₂ 'lia'₂ dsɨ́₅ 'ŋio₅ lɨn₃ tiáin'₅, jaun₂ ca₂jme₃lióg₃ ca₂ŋɨ́i'₃ Jesús le₂jain₂ le₂jain₂, ca₂juá'₂: ―¿On₁jua'₅₄ jniá₂ 'ág'₅? ");
INSERT INTO cntNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jaun₂ ca₂ŋag₃ Jesús: ―Jan'₂ 'nia'₂ i₂lë́₂ guia₃-tɨ́ng'₂ i₂tiá₂ mɨ₂gu₂ co₂lë₅ 'ŋió'₃ uɨng₅ quian'₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dsón'₂ bá₄ dsau₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃ 'ein₅₄ juɨ₅ dsó₃ lia'₂ con'₂ lë́₅ juá'₂ ne₄ Si₂; la₁ ¡'e₂ guë́₄ juɨ́g₂ dsa₂ i₂jáng'₂! Jme₁dse₃ quió'₅ jua'₅₄ co₂ŋei'₅₄ bá₄ tsá₃ ca₂rë₃cháin₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Të₁lia'₂ tiáin'₅ guë́'₅, ca₂jŋa'₃ Jesús i₁ŋí'₄, ca₂cuë́'₃ ti₁'mag'₄ Diú₄, jaun₂ guë́₄ në́₃ ca₂dsioin₃, ca₂cuë́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅. Jaun₂ ca₂juá'₂: ―Qué'₂ 'nia'₂, ia₁ ŋɨ₃ bá₄ jniá₂ i₁ŋí'₄ la₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jaun₂ ca₂can₃ táng₃ copa 'a₄ vino, ján₃ bá₄ le₂jaun₂ ca₂cuë́'₃ ti₁'mag'₄ Diú₄, jaun₂ guë́₄ ca₂cuë́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂. Jaun₂ ca₂le₃jɨ́in₃ bá₄ ca₂'ɨn'₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ca₂juá'₂ Jesús: ―Jmɨ₃ bá₄ jniá₂ la₂, a₂lɨ'₅₄ jág₁ 'mɨ́₂ a₂të₃ron₅₄, a₂niog₅ dsɨ₃'o₅₄ o₄quió'₄ juɨn₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Dsón'₂ juá'₅ jniá₂, tsá₃ ma₃lɨ́g'₂ jmɨg₄ jua'₅₄ a₂guɨ'₅₄ guë́₄ táng₃ vino ca₂lia'₂ ca₂të́₂ jmɨg₄ i₁guɨ'₄ táng₃ caun₂ vino 'mɨ́₂ co₂lë₅ quiang'₅₄ 'nia'₂ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jme₁ca₂lë₃ 'ë₂₃ jme₂juɨin'₂ Diú₄, jaun₂ guë́₄ i₃léin₂ juɨ₅ Má'₂ Olivos. ");
INSERT INTO cntNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―Ca₂le₃jɨ́n'₃ bá₄ 'nia'₂ tiá'₃ jén₂ 'au'₂, 'ág'₁ 'nia'₂ caun₂-tɨn₃ 'au'₂; ia₁ rë₂ton₅ ne₄ Si₂ ja₁juá'₂: “Jŋɨ́'₄ jniá₂ dsa₂ i₂jŋia₅ já'₂ cha'₂, jaun₂ já'₂ cha'₂ në́₃ dsɨ₃léin₂ tsɨ₁rë₂jain₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","La₁ cang₂ jë₁ma₂ca₂jeng'₅₄ táng₃, nei₅₄ jniá₂ jŋiág₅ juɨ₅ Galilea lia'₂ con'₂ guë́₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jaun₂ në́₃ ca₂ŋag₃ Pe₄: ―O₁jŋia'₅₄ la₂ ca₂'ág₂ caun₂-tɨn₃ dsɨ́₅ ca₂le₃jɨ́n₃ rɨ́ng'₃, la₁ jniá₂, o₁lɨ́g'₂ jmɨg₄ tsá₃ 'ag₅₄ caun₂-tɨn₃ dsɨ₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jaun₂ ca₂juá'₂ Jesús: ―A₂dsɨ₂jó'₃ juá'₅ jniá₂, a₂'uë₂ në₃, né'₃ a₂'ó₃ jë₁ca₂të́₂ tɨn₃ ráun₂ të₁guí₄ dsó₂, hora jaun₂ dé₄ dsón'₂ chéng'₅ tsá₃ tóng'₄ ta₁'nɨ₅ ráun₂ a₂cuɨg'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jaun₂ ca₂ŋag₃ táng₃ Pe₄: ―O₁jŋia'₅₄ la₂ ca₂dsau₃ jniog₄ co₂lë₅, o₁lɨ́g'₂ jmɨg₄ jua'₅₄ a₂tsá₃ 'ɨ́n₄ jniá₂ 'ne₂. Le₂jaun₂ bá₄ ca₂juá'₂ ca₂le₃jɨ́n₃ rɨin'₅₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jaun₂ ca₂dsi₃léin₂ caun₂ ja₁chei₂ Getsemaní. Jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―Ja₁lá₃ tián'₂ 'nia'₂, të₁lia'₂ i₁chi₁leng'₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jaun₂ ca₂jŋiai₃ Pe₄, Jacobo, Juan₅₄ në́₃. Jaun₂ ca₂rë₃lióg₃ ca₂tá'₂ quian₅ o₂i₁ dsɨ₅ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ i₂ún₂ i₂quiain'₅₄: ―'Ŋio₅ lɨn₃ quian₅₄ o₂i₁ dsɨ₅, ca₂lia'₂ jmá'₃ le₃jóng₂ të₂në₃. Ja₁lá₃ tián'₂ 'nia'₂ jme₁jnio₂ 'nia'₂ ne'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ca₂juɨg₄ bá₄ ca₂ŋó₃ guë́₄ ne₄ juɨ₅. Ja₁jaun₂ ca₂tóin₂ të₂ 'uë₃, ca₂mɨ₃ ca₂tsɨ́'₃ Diú₄, jua'₅₄ lé₂ bá₄ le₃lé₂ a₂tsá₃ dsɨ₃ŋɨ́i₂ uɨg₅ 'e₂ niog₅ dsɨ₃ŋɨ́i₂ hora jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Të₃jë₄ chi₂léin'₂ Diú₄, ca₂juá'₂: ―Abba, Tia₅₄ quiáng₃, ca₂le₃jë́₃ bá₄ lé₂ le₃jmó'₂ 'ne₂. Lio₄ jniá₂ 'e₂ a₂dsɨ₃ŋɨ́g₂ në₃. La₁ tsá₃ juɨ₁le₅₄ con'₂ 'nio₃ jniá₂; juɨ₁le₅₄ bá₄ a₂'ŋio₂ 'au'₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jaun₂ ca₂dsiáin'₃ táng₃ ja₁tián'₄ 'éi₂, la₁ le₁güɨ́n₃ bá₄ 'éi₂ tiáin'₅ në́₃. Jaun₂ ca₂të́'₃ Pe₄, ca₂juá'₂: ―¿Rë₁güɨ́n'₃ bá₄ 'ne₂, Si₂mu₅₄? ¿Tsa₁ tiang'₃ jua'₅₄ caun₂ hora bá₄ jme₁jniog'₂ guë́₄ ne'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jme₁jnio₂ 'nia'₂ ne'₅₄, chi₁len'₄ 'nia'₂ Diú₄, ia₁jaun₂ tsá₃ tsɨ₃sén'₂ 'nia'₂ dso₄. Dsón'₂ bá₄ 'ŋio₂ dsɨ́₅ jme₂dsí₂ quián'₂ 'nia'₂, la₁ nɨ₁ŋɨ'₁ guion'₅₄ bá₄ 'nia'₂ 'uan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jaun₂ ŋó₃ bá₄ táng₃ i₁chi₂i₁lein'₄ Diú₄. Ján₃ bá₄ jág₁ le₂jaun₂ ca₂juá'₂ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jaun₂ guáin'₃ táng₃ ja₁tián'₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, la₁ le₁güɨ́n₃ bá₄ táng₃ 'éi₂ tiáin'₅, ia₁ a₂ŋɨ́₄ lë₃ 'ŋio₅ lɨn₃ ma₂i₁güɨ́in₃. Jaun₂ tsá₃ 'e₂ ŋi₅ ŋag₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jaun₂ jme₁dsiáin'₃ táng₃ ja₁tián'₄ 'éi₂ jë₁ca₂të́₂ 'nag'₂ ráun₂, jaun₂ ca₂juá'₂: ―¿'E₂? ¿Lia'₂ ma₂tián'₅ jaun₂ bá₄ 'nia'₂ le₁güɨ́ng'₃? Co₂në₅ bá₄ në́₃. Ca₂të́₂ bá₄ hora në́₃. Ŋí₂ 'nia'₂. Ma₂rë₂jɨn'₅₄ bá₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃ o₄gú₃ dsa₂ i₂le₁cán'₄ dso₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nau₂ 'nia'₂ në́₃, ma₃, ia₁ në₅ ma₂já₅ i₂jáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Dsɨ₂juɨ₅ të₃jë₄ dsia₂₃ jág₁ jaun₂, ca₂dsióg₃ Judas, i₂lɨ́n₅ jan₂ dsa₂ i₂guia₃-tɨ́n₂. Juɨn₅ lɨn₃ dsa₂ i₂ja₂lén₂ quiong'₅₄ qui₂le₁quian₅ ŋi₁tág₂, i₂le₁quian₅ nɨ₁'ma₂ në́₃, i₂chen₄ quián₅ juɨg₅₄ jme₂dsa₂, quian'₅₄ të₅juá'₅, ca₂le₃jɨ́n₃ guë́₄ dsɨ₂gui'₅₄ can'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jaun₂ Judas në́₃, ia₁ ma₂ca₂jmo₃ bá₄ jág₁ le₂jŋiá₅ 'e₂ léi₄ jmo₃ jë₁ma₂të́₂ rë₁jáng'₂, jme₁ma₂juá'₂: “I₂chen'₄ jniá₂ quió'₅, i₂'éi₂ bá₄ jma'₅₄ 'nia'₂, jaun₂ të'₅₄ 'nia'₂, lë́₅ 'í₁.” ");
INSERT INTO cntNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jaun₂ dsɨ₂juɨ₅ jme₁dsióg₃ Judas, ca₂jme₃quiáin₃ con₂ Jesús, jaun₂ ca₂juá'₂: ―¡Të₅! ―Jaun₂ ca₂chen'₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jaun₂ dsɨ₂juɨ₅ le₂jaun₂ ca₂jŋau'₃ dsa₂, ca₂tág₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","La₁ jan₂ i₂jme₁chén'₄ cau₅ në́₃, ca₂dsi₂ ŋi₁tág₂, ca₂ti₃ caun₂ rë₂gua₄ dsa₂ i₂jme₂ti₃ quián₅ jme₂dsa₂ dsen₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂: ―¿Dsa₂ 'ang₂ lɨ́ng₅, 'e₂ ja₂nó'₅ 'nia'₂ le₁quian'₄ ŋi₁tág₂, 'ma₂ në́₃, a₂të'₅₄ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jua'₂ ca₂le₃jë́₃ jmɨg₄ bá₄ 'eng₅₄ jɨn'₄ 'nia'₂, jme₂tɨ́ng₁ dsa₂ i₁dsi₅ guá'₅, tsá₃ ma₂ca₂chong'₂ guë'₂ 'nia'₂ ja₁jaun₂. La₁ lë́₂ le₂në₅, ia₁jaun₂ le₃ti₃ con'₂ lë́₅ juá'₂ ne₄ Si₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jaun₂ qui₂ca₂cuɨng₃ bá₄ ca₂le₃jɨ́n₃ chi'₂ dsɨ₂guia₃-tɨ́n₂, ca₂téin₂ bá₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Të₃jë₄ jaun₂, ŋó₃ jan₂ dsó₂ rë₂bóin'₅ caun₂ tsɨ₁'mɨ'₂ tióg₃, 'ein₂₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jaun₂ jme₁ca₂jŋau'₃ dsa₂, la₁ ca₂lóin₂ bá₄, jmá'₃ tsɨ₁'mɨ'₂ bá₄ ca₂lɨ́'₃ dsa₂. Jaun₂ ŋái'₃ bá₄ të₃ rë₂ŋɨ́i₅. ");
INSERT INTO cntNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jaun₂ ca₂tág₃ dsa₂ Jesús i₁jo₅₄ ne₄ jme₂dsa₂ dsen₅₄, jaun₂ ca₂ŋɨ'₂ ca₂le₃jɨ́n₃ juɨg₅₄ jme₂dsa₂, quian'₅₄ dsɨ₂gui'₅₄ can'₅₄, të₅juá'₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pe₄ në́₃ ca₂ŋó₃ uɨ́ng₂ të₂quɨ́in₃ 'ein₂₃ Jesús ca₂të₂ i₁dsi₅ quió'₅ jme₂dsa₂ dsen₅₄. Ja₁jaun₂ ca₂guá₂ cau₅ si₂ quiain'₅₄ 'lióg₂, ca₂jme₃dsioin'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jaun₂ juɨg₅₄ jme₂dsa₂, quian'₅₄ ca₂le₃jɨ́n₃ dsɨ₂tan₅₄ quián₅ guá'₅ në́₃, qui₂ca₂'náu'₃ juɨ₅ 'a₂ lia'₂ bóin'₂ dso₄ Jesús ia₁jaun₂ jŋag'₃. La₁ tsá₃ dso'₂ guë'₂ juɨ₅ 'e₂ dso₄ jme₃cáu'₂, ");
INSERT INTO cntNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ia₁ juɨn₅ i₂qui₂ca₂jmo₃ jág₁ të₂jág₁ a₂bóin'₂ dso₄ Jesús, la₁ tsá₃ të₃tsɨ'₅₄ guë'₂ jág₁ quió'₅ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jaun₂ i₂lɨn₅₄ në́₃ qui₂ca₂nau₂ ca₂jmo₃ jág₁ të₂jág₁ a₂'nɨi₂₃ Jesús, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ma₂néi₁ jnia'₅₄ juá'₂ i₂në₅: “A₂'éng₄ guá'₅ templo a₂ca₂jmo₃ dsa₂ mɨ₂güɨ́g₃, jaun₂ quian'₅₄ 'nɨ₅ jmɨg₄ jmóg'₄ táng₃ 'ŋió₃ caun₂ guá'₅ siá'₂, on₃jua'₅₄ lia'₂ lë́₅ guá'₅ në₅ a₂ca₂jmo₃ dsa₂ mɨ₂güɨ́g₃.” ");
INSERT INTO cntNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","On₃ guë'₂ quian'₅₄ jág₁ jaun₂ ca₂lɨ́'₃ jág₁ rë₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jaun₂ ca₂nau₂ jme₂dsa₂ dsen₅₄ të₃jë₄ tioin'₅₄ jaun₂, jaun₂ ca₂ŋɨ́i'₃ Jesús ca₂juá'₂: ―¿Tsa₁ 'e₂ ŋag'₅₄ 'i₁caun₂? ¿I₂'e₂ bá₄ jág₁ në₅ jme₂cáu'₂ dsa₂ quiang'₂? ");
INSERT INTO cntNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","La₁ tei₄ bá₄ ca₂nau₂ Jesús, tsá₃ ma₃'e₂ ca₂ŋag₃. Con'₂ siá'₂ ca₂ŋag₃ táng₃ jme₂dsa₂ dsen₅₄, ca₂juá'₂: ―¿Dsón'₂ 'ne₂ lɨ́ng'₅ dsa₂ I₂rë₂'ɨ́n₁, Ja₁ŋi'₅₄ I₂jŋió₅? ");
INSERT INTO cntNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jaun₂ guë́₄ ca₂ŋag₃ Jesús: ―Ján₅, jniá₂ bá₄ lɨ́ng₅. Ján₃ bá₄ të₃ ne'₅₄ 'nia'₂ jë₁ma₂të́₂ rë₁guá₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ të₂le₃ gu₂ ne₁ quió'₅ i₂'uan'₂, jaun₂ ján₃ bá₄ jag'₅₄ 'nia'₂ jë₁ma₂të́₂ rë₁jŋiói'₂ táng₃ jë₄ jnei₅ guei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jaun₂ jme₂dsa₂ dsen₅₄ në́₃, jme₁ca₂nág₂ jág₁ jaun₂, ca₂chein₃ nɨ₁tsɨn'₅₄ 'ŋiog₅, jaun₂ ca₂juá'₂: ―¿'E₂ guë́₄ jmá'₃ jág₁ 'lióng₂ 'niog₂ jniog₄ jua'₅₄ a₂jáng'₃ guë́₄ dsa₂ sián'₂ jág₁ dsau₅? ");
INSERT INTO cntNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ma₂në₂nei'₂ bá₄ 'nia'₂ guiong'₅₄ a₂ma₂në₂juá'₂ i₂në₅ 'ɨin₂₃ Diú₄. ¿'A₂ lia'₂ juá'₂ 'nia'₂? Jaun₂ ca₂le₃jɨ́n₃ dsa₂ ca₂juá'₂ tioin'₅₄, ca₂tɨ́in₂ jóin₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jaun₂ ca₂jme₃lióg₃ i₂lɨn₅₄ qui₂ca₂'ŋéi₃ quió'₅ Jesús, qui₂ca₂lio₃ dsa₂ dsɨ₂ne₅₄, jaun₂ qui₂ca₂jnó₂ në́₃ tioin'₅₄, jaun₂ juá'₂: ―¡Dsi₄ jág₁ jua'₅₄ 'ein₂ në₂quein₃ quiáng'₂! Chi'₂ 'ɨ'₅₄ quián₅ guá'₅ në́₃, ján₃ bá₄ qui₂ca₂cuë₃ ja'₂ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","I₁dsi₅ ca₁'né₄ 'uë₃ bá₄ jme₁guá₄ Pe₄. Jaun₂ ca₂dsióg₃ jan₂ 'io₅₄ i₂jme₂ti₃ ta₁ ne₄ jme₂dsa₂ dsen₅₄, ");
INSERT INTO cntNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","jaun₂ ca₂jɨ́in₂ Pe₄ guá₅ jme₂dsioin'₂, jaun₂ ca₂jág₂ 'io₅₄ tiá₂, ca₂juá'₂: ―¿Ján₃ guë'₂ jme₁quian'₄ 'ne₂ Jesús Nazareno ó₃? ");
INSERT INTO cntNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","La₁ tsá₃ ca₂tion₃ Pe₄. ―Tsá₃ guion₅₄, on₃ guë́₄ ŋɨ́g'₂ 'e₂ a₂juá'₂ 'ne₂. Jaun₂ ca₂nau₂ Pe₄ ca₂o₃'ɨ́in₃ ca₂i₁nau₂ të₂le₃ ca₁'né₄ ja₁lë́₄ corredor. Të₃jë₄ jaun₂ ca₂'o₃ të₁guí₄ dsó₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Con'₂ siá'₂ ca₂jág₃ táng₃ 'io₅₄ ca₂jɨ́in₂ Pe₄, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂: ―Jan₂ rɨn'₅₄ 'éi₂ bá₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","La₁ ján₃ bá₄ le₂jaun₂ tsá₃ ca₂tion₃ Pe₄. Jme₁co₂lág₂ jaun₂, dsa₂ i₂tián'₅ quian'₅₄ Pe₄ ca₂juá'₂: ―Dsón'₂ rɨn'₅₄ 'éi₂ bá₄ lɨ́ng'₅, ia₁ ján₃ bá₄ Galilea chang'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jaun₂ në́₃, Pe₄ ca₂'ɨin₃ Diú₄ ca₂mɨ₃ a₂dsɨ₃ŋɨ́i₂ 'e₂ dsɨ₃ŋɨ́i₂, ca₂juá'₂: ―¡Tsá₃ cuɨ́ng₅ dsa₂ i₂'ɨ́n'₅ 'nia'₂! ");
INSERT INTO cntNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dsɨ₂juɨ₅ jaun₂ ca₂'o₃ táng₃ të₁guí₄ dsó₂ a₂ca₂të́₂ tɨn₃ ráun₂. Jaun₂ guë́₄ në́₃ ca₂dsáu'₃ dsɨ́₅ Pe₄ a₂ca₂juá'₂ Jesús le₂jŋiá₅: “Né'₃ a₂'o₃ jë₁ca₂të́₂ tɨn₃ ráun₂ të₁guí₄ dsó₂, hora jaun₂ dé₄ dsón'₂ chéng'₅ tsá₃ tóng'₄ ta₁'nɨ₅ ráun₂ a₂cuɨg'₂ jniá₂.” Jme₁ca₂dsáu'₃ dsɨ́₅ jág₁ në₅, jaun₂ guë́₄ ca₂'o₃ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dsɨ₂juɨ₅ jme₁jnia₃ táng₃ jaun₂, ca₂ŋɨ'₂ juɨg₅₄ jme₂dsa₂ quian'₅₄ dsɨ₂gui'₅₄ can'₅₄, quian'₅₄ ca₂le₃jɨ́n₃ të₅juá'₅, ca₂le₃jɨ́n₃ guë́₄ i₂lɨ́n₅ dsɨ₂tan₅₄ quián₅ guá'₅ në́₃. Qui₂ca₂ŋɨ́i'₃ rɨin'₅₄ ca₂jmo₃ caun₂ jág₁. Ca₂'néi'₂ Jesús tioin'₅₄, jaun₂ ca₂i₁jiog₃ ne₄ Pilato. ");
INSERT INTO cntNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jaun₂ ca₂ŋag₃ Pilato: ―¿Dsón'₂ lɨ́ng'₅ Rag₅₄ quián₅ dsa₂ judíos? Jaun₂ ca₂ŋag₃ Jesús: ―Le₂në₅ bá₄, juɨ₁lia'₂ juá'₂ 'ne₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jaun₂ caun₂ qui₂ca₂'nag₃ guë́₄ juɨg₅₄ jme₂dsa₂ 'lióng₂ ne₅₄ dso₄ ca₂bóin'₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jaun₂ con'₂ siá'₂ táng₃ ca₂ŋag₃ Pilato ca₂ŋɨ́i'₃ Jesús, ca₂juá'₂: ―¿Tsa₁ a₂ŋag'₅₄? Në₅ bá₄ nag'₂ 'ŋiag'₂ 'lióng₂ dso₄ a₂bóg'₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","La₁ tsá₃ ma₃'e₂ ca₂ŋag₃ Jesús 'i₁caun₂. Jaun₂ jë́₃ ca₂i₃gó'₃ dsɨ́₅ Pilato. ");
INSERT INTO cntNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jmɨg₄ jaun₂ jme₁chí'₄ tag₄ a₂lióin₂ ca₂le₃jë́₃ ŋi₂ jan₂ dsa₂ i₂'en₅₄ né'₃ 'má₃, jme₁të₅ Jmɨg₄ Të₂'ɨn₅₄, 'ein₂ ca₂'ɨn₃ dsa₂ juɨg₂ i₂lión₂. ");
INSERT INTO cntNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jaun₂ jme₁'en₅₄ né'₃ 'má₃ jan₂ dsa₂ i₂chen₂ Barrabás, quian'₅₄ dsa₂ i₂ma₂ca₂jme₃dsian₅ dsa₂ jme₁ca₂nau₂ 'nei₂. ");
INSERT INTO cntNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jaun₂ ca₂mɨ₃ dsa₂ juɨg₂ ca₂tsɨ́'₃ Pilato a₂jmo₃ con'₂ lë́₅ tag₄ chí'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jaun₂ ca₂ŋag₃ Pilato ca₂tsɨ́'₃ dsa₂ juɨg₂: ―¿'Niog'₂ 'nia'₂ lon₄ jniá₂ Rag₅₄ quián₅ dsa₂ judíos? ");
INSERT INTO cntNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ia₁ ca₂rë₃lí'₄ bá₄ Pilato 'ŋiog₅ a₂'iog₅₄ uɨg₅ dsɨ́₅ bá₄ juɨg₅₄ jme₂dsa₂ ca₂jɨ́in'₂ Jesús ne₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","La₁ juɨg₅₄ jme₂dsa₂ në́₃ ca₂toin'₂ jág₁ dsa₂, jaun₂ tóin'₃ co₂mɨ'₅₄ a₂mɨ₃ lión₂ Barrabás bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jaun₂ ca₂ŋag₃ táng₃ Pilato ca₂tsɨ́'₃ dsa₂ juɨg₂: ―¿'E₂ guë'₂ 'niog'₂ 'nia'₂ jmo₅₄ jniá₂ quian'₅₄ i₂të'₂ 'nia'₂ rag₅₄ quiáng'₂? ");
INSERT INTO cntNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jaun₂ ca₂ŋag₃ dsa₂ juɨg₂ co₂mɨ'₅₄ tioin'₅₄, ca₂juá'₂: ―¡Tióin₃ cróg₄! ");
INSERT INTO cntNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Jaun₂ ca₂juá'₂ táng₃ Pilato: ―¿'E₂ 'uɨg₅₄? ¿'E₂ guë'₂ dso₄ ma₂'náu₂? La₁ të₂le₃ i₂juɨ'₂ guë́₄ co₂mɨ'₅₄ ca₂tóin'₂, ca₂juá'₂: ―¡Tióin₃ cróg₄! ");
INSERT INTO cntNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","La₁ Pilato në́₃, ia₁jaun₂ dsɨ₃lén₂ dsa₂ tei₄, ca₂lióin₂ bá₄ Barrabás i₂mɨ₅ dsa₂ lión₂. Jme₁ma₂në₂dsí₃ Pilato 'éi'₃ a₂bán₂ dsa₂ Jesús, jaun₂ ca₂jáng'₂ o₄gú₃ dsa₂ juɨg₂ jaun₂ tion₃ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jaun₂ ca₂tág₃ 'lióg₂ Jesús të₂le₃ i₁dsi₅ ne₄ta₁, (co₂'nió'₄ caun₂ ja₁chei₂ Praetorio), jaun₂ ca₂ŋɨ́'₂ 'lióg₂ ca₂le₃jɨ́n₃ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jaun₂ ca₂quei'₃ dsa₂ caun₂ capa 'uɨ'₃, jaun₂ ca₂jmo₃ caun₂ corona quian'₅₄ chi₁uɨ́ng₃ taun₅, ca₂tó'₂ mɨ₂dsi₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jaun₂ ca₂jme₃lióg₃ qui₂ca₂cuag₃ Diú₄ tioin'₅₄, ca₂juá'₂: ―¡Sian'₃ 'ne₂ Rag₅₄ quián₅ dsa₂ judíos! ");
INSERT INTO cntNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jaun₂ qui₂ca₂bá₂ mɨ₂dsi₄ Jesús quian'₅₄ nɨ₁'ma₂ ta₅, qui₂ca₂'ŋéi₂ në́₃ tioin'₅₄, qui₂ca₂chi₃jné₃ në́₃, a₂jme₂juag'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jme₁ca₂lë₃ a₂lë₁co₂jmóg'₂ jaun₂, ca₂dsein₂₃ táng₃ Jesús tsɨ₁'mɨ'₂ 'uɨ'₃ a₂jme₁ca₂quei'₃. Jaun₂ ca₂quei'₃ táng₃ nɨ₁tsɨn'₅₄ a₂jme₁qui'₂. Jaun₂ guë́₄ ca₂jŋiai₃ Jesús a₂dsɨ₃tion₃ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jaun₂ ca₂chi₃quiáin₂ jmɨg₄ jan₂ dsa₂ i₂'en₅₄ juɨ₅ jón'₅ ja₁nau₂, i₂chen₂ Si₂mu₅₄ i₂chan₂ juɨg₂ Cirene, i₂lɨ́n₅ jmei₂ Alejandro quian'₅₄ Rufo, a₂cán₂ 'éi₂ cróg₄ quió'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jaun₂ ca₂jŋia₃ dsa₂ Jesús caun₂ ja₁chei₂ Gólgota, (co₂'nió'₄ jein₅ jág₁ chei₂ Dsɨ₂con'₂ Nɨ₁mu₅ Mɨ₂dsi₄ 'Lag₄.) ");
INSERT INTO cntNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jaun₂ ca₂jén'₃ ne₄ Jesús vino a₂rë₂cón'₅ quian'₅₄ mirra, la₁ tsá₃ ca₂gue₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jaun₂ guë́₄ ca₂tion₃ cróg₄. Dsɨ₂'lióg₂ guë'₂ në́₃ ca₂jmo₃ dsióg₁ tsɨn'₅₄ Jesús, ca₂co₃ o₁ne₄ 'ein₂ lí'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Con'₂ hora ŋí₁ ŋi₃ të₂ o₃'iog₂, ca₂tion₃ dsa₂ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jaun₂ ca₂tióng₃ letra dsi₄ cróg₄ co₂'nió'₄ a₂juá'₂ 'e₂ dso₄ a₂bóin'₂ Jesús, a₂juá'₂: “RAG₅₄ QUIÁN₅ DSA₂ JUDÍOS.” ");
INSERT INTO cntNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ján₃ bá₄ ca₂tioin₃ guë́₄ on₃ dsa₂ 'ang₂ co₂lë₅ quiong'₅₄, jan₂ të₂le₃ gu₂ ne₁, jan₂ guë'₂ të₂le₃ gu₂ jen₅. ");
INSERT INTO cntNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jaun₂ ca₂le₃jɨ́n₃ dsa₂ i₂qui₂ca₂ŋɨ́₃ juɨ₅ jaun₂ qui₂ca₂jnáu'₂ jág₁ uɨg₅, qui₂bí₂ dsi₅₄, ca₂juá'₂: ―Ia₁, ¿on₁ 'ne₂ i₂juá'₂ a₂'éng'₄ guá'₅ con'₂ siá'₂ tɨng'₂ jmog'₅₄ táng₃ quian'₅₄ 'nɨ₅ jmɨg₄? ");
INSERT INTO cntNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Në₃ në́₃, lion₄ 'ŋiag'₂, ja₁tong'₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ján₃ bá₄ le₂jaun₂ a₂lë₁qui₂co₂jmóg'₂ juɨg₅₄ jme₂dsa₂, quian'₅₄ të₅juá'₅, dsia₂₃ jág₁ qui₂tsɨ́'₅ rɨin'₅₄, juá'₂: ―Ca₂lióin₂ bá₄ i₂sián'₂, la₁ 'ŋiog₅ bá₄ tsá₃ lé₂ le₃lióin₃. ");
INSERT INTO cntNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Juɨ₁sión₄ cróg₄ I₂rë₂'ɨ́n₁ quián₅ Diú₄ në₅, i₂juá'₂ lɨ́n₅ Rag₅₄ quián₅ dsa₂ juɨg₂ Israel, ia₁jaun₂ të₅₄ ne₄ jniog₄, ia₁jaun₂ le₃'éin₂. Le₂jiog₅ dsa₂ i₂le₁ton₅ quian'₅₄ Jesús qui₂ca₂juá'₂ uɨg₅. ");
INSERT INTO cntNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jme₁ca₂të́₂ dsi₃ŋí'₃, ca₂'ág₂ nei₂ le₂con₂ 'uë₃ jaun₂, ca₂lia'₂ ca₂të́₂ hora ŋí₁ 'nɨ₅ të₂le₃ ca₂'láu₂. ");
INSERT INTO cntNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hora jaun₂, ca₂'ŋia₂ guë́₄ Jesús jág₁, ca₂juá'₂ tiá₂: ―Eloi, Eloi, ¿lama sabactani? ―co₂'nió'₄ a₂juá'₂: Diú₄ quiáng₃, Diú₄ quiáng₃, ¿'e₂ lë₃ ma₂në₂téi'₃ jniá₂?. ");
INSERT INTO cntNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","I₂lɨn₅₄ dsa₂ i₂jme₁tión₂ cau₅ jaun₂ ca₂nág₂, jaun₂ ca₂dsia₃ jág₁ tsɨ́'₅ rɨin'₅₄: ―¡Nei₂! Elías i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂ të́'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jaun₂ në́₃ ŋó₃ jan₂ co₂chi'₅₄ i₁quian₅₄ caun₂ nɨ₁jau₂ guion₅ jmɨg₂. Jaun₂ ca₂guioin₃ vino dsi'₃. Jaun₂ ca₂chi₃dsí₂ nei'₅₄ caun₂ nɨ₁'ma₂ ta₅, jaun₂ ca₂jén'₃ ne₄ Jesús ia₁jaun₂ jme₁'ɨ́n'₂. Jaun₂ juá'₂: ―O₁ne₄ chi₂jua'₂ jiá₃ Elías jaun₂ sió₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Cón'₂ bá₄ ca₂'ŋióg₂ guë́₄ Jesús tiá₂ lɨn₃, co₂tan₅₄ ca₂join₃. ");
INSERT INTO cntNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hora jaun₂ dé₄ dsón'₂ co₂dsia₅ ca₂chen₃ ca₂të₂ guei'₅₄ ca₂të₂ 'uë₃ ca₂lë₃ tɨn₃ tsɨ́n'₅ tsɨ₁'mɨ'₂ pa₁ a₂jme₁'ei₅ dsi₂néi₂ guá'₅ templo. ");
INSERT INTO cntNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jaun₂ juɨg₅₄ 'lióg₂ i₂jme₁chén'₄ cau₅ cróg₄, jme₁ca₂jág₃ 'a₂ lia'₂ ca₂jon₃ Jesús, jaun₂ ca₂juá'₂: ―Të₃dsón'₂ bá₄ jme₁lɨ́n₄ dsa₂ në₅ Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jaun₂ bá₄ jme₁tión₂ i₂lɨn₅₄ 'io₅₄, jág₅ uɨ́ng₂ ján₃. Jë₄ jaun₂ jme₁chén'₄ María chan₂ Magdala, quian'₅₄ María chog₅₄ i₂chen₂ José, quian'₅₄ i₂chen₂ Jacobo i₂lɨ́n₅ i₂me'₂ guë́₄, quian'₅₄ guë́₄ jan₂ i₂chen₂ Salomé. ");
INSERT INTO cntNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","'Io₅₄ 'éi₂ ma₂ja₂léin₂ le₂tan₅₄ 'uë₃ Galilea jme₂ti₃ ne₄ Jesús. Juɨn₅ bá₄ guë́₄ 'io₅₄ sián'₂ i₂ma₂ja₂lén₂ 'ein₂₃ Jesús të₂ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jme₁ca₂tó'₂ nei₂ jmɨg₄ jaun₂, tion'₅₄ dsa₂ jmo₂₃ co₂jŋia₅₄ juɨ₁lia'₂ 'ióg₃ jmɨg₄ jŋió₅. ");
INSERT INTO cntNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jaun₂ ca₂dsióg₃ José i₂chan₂ Arimatea, i₂lɨ́n₅ jan₂ dsa₂ dsen₅₄ i₂quian'₅₄ dsɨ₂tan₅₄ quián₅ guá'₅. Ia₁ 'éi₂ ján₃ jme₁chi₁jŋia₂₃ a₂'ɨ́n₂ dsɨ́₅ a₂guá₂ 'éi'₃ quió'₅ Diú₄. Jaun₂ ca₂dsia₃ tiá₂ dsɨ́₅ në́₃, ŋó₃ ja₁con₂ Pilato, ca₂i₁mɨi₁₂ 'lag₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jaun₂ ca₂i₃gó'₃ dsɨ́₅ Pilato jme₁ca₂nág₂ a₂ma₂jon₅ Jesús, jaun₂ ca₂të́'₃ juɨg₅₄ 'lióg₂ ca₂ŋag₃ chi₂jua'₂ dsón'₂ ma₂join₂₃. ");
INSERT INTO cntNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jme₁ca₂rë₃ŋi₅ ca₂juá'₂ 'lióg₂, “Dsón'₂ bá₄ le₂jaun₂ ma₂ca₂lë₃”, jaun₂ ca₂jɨ́in'₂ 'lag₄ o₄gú₃ Së́₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jaun₂ Së́₄ në́₃ ca₂i₁lia₅ 'mɨ'₂ tióg₃; quian'₅₄ a₂jaun₂ ca₂lioin₃ 'lag₄ Jesús jme₁ca₂sió₂ cróg₄. Jaun₂ ca₂to'₂ 'ŋió'₃ tau₂ 'ŋio₅ a₂jme₁ma₂lë́₅ dso'₂ nɨ₁'lau₂. Jaun₂ ca₂mói₂ ca₂mɨ́g₂ nɨ₁cang₁ 'ɨ́₂ pa₁, ca₂jne₃ 'o₄ tau₂ 'ŋio₅. ");
INSERT INTO cntNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jaun₂ María i₂chan₂ Magdala quian'₅₄ María chog₅₄ José, ca₂të́₂ ne₅₄ ja₁ca₂'on₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Le₃ca₂gú'₃ jmɨg₄ jŋió₅, jaun₂ María i₂chan₂ Magdala quian'₅₄ María chog₅₄ Jacobo, quian'₅₄ guë́₄ jan₂ i₂chen₂ Salomé, ca₂i₁lia₅ no'₅₄ mɨ₂juɨg₂ a₂jme₁dsɨ₃tsáng₃ nɨ₁ŋɨ₁ 'lag₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jaun₂ le₁né₃ guë́₄ jme₁jnia₃ jmɨg₄ le₂'uɨg₅₄ semana, ca₂i₃léin₂ ja₁chi₁'on₅ Jesús, ca₂dsi₃léin₂ con'₂ ma₂'en₅ ca₂la₂ 'iog₂. ");
INSERT INTO cntNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Jaun₂ dsia₂₃ jág₁: ―¿'Ein₂ jme₃'o₅₄ jniog₄ mói₂ cau₅ nɨ₁cang₁ a₂chi₁jnɨ₅ 'o₄ tau₂ 'ŋio₅? ");
INSERT INTO cntNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","La₁ jme₁ca₂jág₃ në́₃, jua'₂ ma₂rë₂mu₅, cau₅ bá₄ ma₂chí'₅. Ia₁ a₂jme₁pa₁ lɨn₃ bá₄ nɨ₁cang₁. ");
INSERT INTO cntNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jaun₂ ca₂i₃toin'₅₄ 'ŋió'₃, jaun₂ ca₂jɨ́in₂ jan₂ dsa₂ chi'₂ i₂qui'₂ 'mɨ'₂ chen'₅₄ tiog₂, guá₅ të₂le₃ gu₂ ne₁ ja₁i₃léin₂ jaun₂. Jaun₂ ca₂i₃gó'₃ dsɨ́₅ 'io₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","La₁ ca₂juá'₂ dsa₂ 'éi₂: ―Tsá₃ juɨ₁dsi₂gó'₃ 'au'₂ 'nia'₂. A₂'na'₂ Jesús bá₄ 'nia'₂ i₂niog'₅₄ i₂ca₂jon₃ ca₂tion₃ dsa₂ cróg₄. La₁ ma₂ca₂jein'₅₄ bá₄. Tsá₃ 'éi₂ chan₂ ja₁lá₃. Në₅ jag₄ 'nia'₂ ja₁ca₂quio₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jaun₂ o₂nó'₅ 'nia'₂ o₂chei'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, Pe₄ në́₃, a₂ma₂'ein₅₄ juɨ₅ ŋó₅ jŋiái₅ lia'₂ con'₂ guë́₄ 'nia'₂ juɨ₅ Galilea. Ja₁jaun₂ o₁jɨin'₄ 'nia'₂ con'₂ lë́₅ jág₁ quió'₅ ma₂ca₂juá'₂. ");
INSERT INTO cntNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jaun₂ ca₂'uɨin₂ tau₂ 'ŋio₅ i₃lein₃ cuɨng₂₃, dsɨ₂gó'₃ dsɨ́₅ jlein₂₃. Tsá₃ 'ein₂ ca₂tsɨ́'₃ le₂'i₄ juɨ₅, ia₁ a₂gó'₅ bá₄ i₃lein₃. ");
INSERT INTO cntNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jaun₂ të₂le₃ o₂'iog₂ jmɨg₄ le₂'uɨg₅₄ a₂ca₂rë₃lióg₃ semana a₂ca₂jein'₅₄ jaun₂, ca₂jme₃jniai₂₃ le₂'uɨg₅₄ ne₄ María chan₂ Magdala, i₂ca₂'uɨ́n'₂ Jesús guion₃ je₂na'₅₄ quió'₅ le₂jŋiá₅. ");
INSERT INTO cntNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jaun₂ 'éi₂ në́₃ ca₂i₁chi'₄ dsa₂ i₂jme₁quian'₅₄ Jesús. 'Éi₂ në́₃, tioin'₅₄ 'lia'₂ dsɨ́₅, quɨ'₂-'o₂₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jme₁ca₂nág₂ juá'₂ 'io₅₄ a₂ma₂chan₂ táng₃ Jesús, ia₁ ma₂në₂jág₂ 'io₅₄, la₁ tsá₃ 'ein₂ ca₂rë₃'én₂ guë'₂ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cang₂ jaun₂ táng₃ ca₂jme₃jnia₅ Jesús le₂siá'₂ ne₄ on₃ dsa₂ 'éi₂ quiáin₅, ja₁jme₁i₂nioi₅₄ ja₁nau₂. ");
INSERT INTO cntNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jaun₂ ca₂i₃lein₃ táng₃ ca₂i₁chi'₄ rɨin'₅₄. Ján₃ bá₄ le₂jaun₂ tsá₃ 'ein₂ rɨin'₅₄ ca₂rë₃'én₂ jág₁ a₂dsia₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cang₂ guë́₄ jaun₂ ca₂jme₃jnia₅ Jesús jɨn₄ ta₁guia₃-ján₃ con'₂ i₂jme₁tén₄ guë́'₅. Jaun₂ ca₂jí₂ ia₁ 'e₂ lë₃ ŋɨ́₄ lë₃ cang₄ dsi₅₄, tsá₃ 'éin₂ a₂juá'₂ rɨin'₅₄ i₂ma₂ca₂të́₂ ne₄ a₂ma₂ca₂jein'₅₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂ 'éi₂: ―O₂nó'₅ 'nia'₂ le₂con₂ mɨ₂güɨ́g₃, o₂'ë́₃ jɨn₄ ca₂le₃jɨ́n₃ dsa₂ jág₁ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","I₂'én₂, i₂jŋó₂ jmɨg₂ në́₃, lióin₂, tɨ́in'₄ bá₄. I₂tsá₃ 'én₂ në́₃, le₃chain₂ tioin'₅₄ 'éi'₃ a₂dsɨ₃'éin₂. ");
INSERT INTO cntNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jaun₂ léi₄ la₂ jme₃quian'₅₄ dsa₂ 'én₂. Të₂le₃ quian'₅₄ bí₂ 'éi'₃ quió₃ jniá₂, 'uɨ́in'₂ je₂na'₅₄, ton'₂ dsia₃ dsa₂ jág₁ jmei₅ 'mɨ́₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Në₁jua'₂ 'ein₂ ca₂jŋa'₃ dsɨ₂mɨ'₂, o₃ 'ein₂ ca₂'ɨn'₃ mɨ́₅ 'lɨg'₅₄, la₁ tsá₃ 'e₂ jén'₄. Qui₂quiog₃ gu₂ ne₄ quió'₅ dsa₂ dso'₅₄, jaun₂ 'lión₂ bá₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jme₁ma₂lë₅ juá₂ Te₁gui'₅₄ Jesús le₂në₅, jaun₂ guë́₄ ca₂roin'₂ ŋái'₃ guei'₅₄ i₂juɨ́g₃, jaun₂ ca₂guá₂ të₂le₃ gu₂ ne₁ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Cang₂ jaun₂, dsa₂ i₂jme₁quiain'₅₄ në́₃, ca₂'uɨin₂ i₁lein₅₄ ca₂le₂con₂ juɨg₂ i₁'ë́₄ jág₁. Jaun₂ 'ŋiog₅ bá₄ Te₁gui'₅₄ Jesús ca₂cuë₃ bí₂, ca₂jmo₃ léi₄ a₂dsón'₂ dsau₅ jág₁ quió'₅, të₂le₃ quian'₅₄ ca₂le₃jë́₃ léi₄ juë'₂ a₂qui₂ca₂jmo₃ dsa₂ quiáin₅. Co₂në₅.");
INSERT INTO cntNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Juɨn₅ bá₄ dsa₂ i₂qui₂ca₂nio₃ ne₄ ca₂can₃ ta₁ ca₂tó'₂ ne₄ si₂ ca₂le₃jë́₃ jág₁ 'a₂ lia'₂ dsón'₂ niog₅ ca₂lë₃ jë₄ quián₂ jnia'₅₄, ");
INSERT INTO cntNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","lia'₂ con'₂ lë́₅ ca₂jme₃tag₅ dsa₂ i₂ca₂të́₂ ne₄ lia'₂ con'₂ le₂'uɨg₅₄ jme₁ca₂rë₃lióg₃, ton'₂ ca₂jme₃'o₅₄ ca₂'ë́₂ jág₁ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ján₃ bá₄ le₂jaun₂, jniá₂ në́₃ ma₂cáun₃ 'í₁ dse₃ lɨn₃ 'a₂ lia'₂ ma₂já₅ jë₁le₂'uɨg₅₄, jaun₂ bá₄ lɨ́ng₂ dsi₂ten₅₄ a₂tó'₄ ne₄ si₂ la₂ ca₂le₃jë́₃ lia'₂ con'₂ lë́₅, a₂tsɨ́ng₂ ne'₅₄ 'ne₂, gui'₅₄ Teófilo, ");
INSERT INTO cntNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ia₁jaun₂ ŋi'₅₄ dse₃ a₂dsón'₂ tí₅ jág₁ a₂ma₂ca₂rë₃tɨ́ng'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jmɨg₄ lia'₂ con'₂ jme₁lɨ́n₄ Herodes rag₅₄ 'uë₃ Judea, jme₁chan₂ jan₂ jme₂dsa₂ i₂jme₁chen₂ Zacarías, i₂jme₁tén₄ le₃quió'₅ co₂nió'₃ jme₂dsa₂ quián₅ Abías. Dsa₂ mɨ́₂ quián₅ jme₂dsa₂ 'éi₂ në́₃ jme₁chen₂ Elisabet, i₂jme₁lɨ́n₄ tsɨ₁jon₂ quián₅ jme₂dsa₂ Aarón. ");
INSERT INTO cntNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Le₃oin₃ jme₁lɨ́in₄ dsa₂ dsen₃ le₃ne₄ Diú₄, jme₁jme₂ti₃ 'éi'₃ quió'₅ Te₁gui'₅₄. A₂chain₂ le₂jaun₂ në́₃, tsá₃ 'ein₂ qui₂le₃bóg'₂ dso₄ jua'₅₄ 'e₂ dso₄ le₃bóg'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","La₁ 'i₁jan₂ guein₂ tsá₃ i₂ma₂ca₂rë₃chán₃ quiáin₅, ia₁ jme₁lɨ́n₄ Elisabet jan₂ 'io₅₄ quen₂. Jme₁ma₂cain'₅₄ ma₂guein'₂ 'ŋio₅ lɨn₃ jain₂ jain₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Co₂ráun₂, ca₂lë₃ jme₁ca₂të́₂ jmɨg₄ a₂tɨn₅₄ jme₂dsa₂ i₂quian'₅₄ Zacarías a₂jme₃ti₃ ta₁ a₂tióin₂ ne₄ Diú₄, ");
INSERT INTO cntNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","a₂jmo₃ lia'₂ con'₂ lë́₅ tag₄ chí'₅ quió'₅ jme₂dsa₂. Të₃jë₄ jmɨg₄ jaun₂, ca₂o₃ág₃ jág₁ ca₂tɨ́n₂ Zacarías, a₂'í₂ dsi₂néi₂ ja₁jŋió₅ quió'₅ Te₁gui'₅₄ a₂dsɨ́'₂ chen₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Të₁lia'₂ 'ein₅₄ dsɨ́'₂ chen₂ ne₄chei₂ në́₃, dsa₂ juɨg₂ guë'₂ le₃ca₁'né₄ bá₄ le₁ŋɨi'₂ chi₂léin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Të₃jë₄ jaun₂ ca₂jme₃jnia₅ jan₂ ángel quián₅ Te₁gui'₅₄ ne₄ Zacarías të₂le₃ gu₂ ne₁ ja₁lë́₄ ne₄chei₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jme₁ca₂jág₂ Zacarías, ca₂ja₃gó'₃ dsɨ́₅ 'ŋio₅ lɨn₃, ca₂lia'₂ tsá₃ a₂ŋi₅ jmo₃ ca₂jén'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","La₁ ca₂juá'₂ ángel: ―Zacarías, tsá₃ lë₁jmo₂ gang'₃, ia₁ ma₂nág₂ Diú₄ jág₁ quiáng'₂ a₂chi₁lein'₅₄, jaun₂ le₃chan₂ jan₂ guein₂ dsa₂ ŋe'₂ quián₅ Elisabet dsa₂ mɨ́₂ quiáng'₂. Guein₂ 'éi₂ quiang'₅₄ Juan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jmó'₂ 'io'₂ le₃chang'₂, o₂'ŋió₃ o₂jŋia₃ 'au'₂ në́₃, ján₃ bá₄ juɨn₅ i₂të₃ dsɨ́₅ jë₁ma₂chain₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ia₁ léin₂ dsa₂ juɨn'₂ le₃ne₄ Te₁gui'₅₄. Tsá₃ vino 'ɨ́n'₂, on₃ guë'₂ ti₁jmɨ́g₃ në́₃; Jme₂dsí₂ Jŋió₅ bá₄ ma₂rë₂rɨn₅ të₂dsɨ́₅ né'₃ a₂le₃chain₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Co₃jéin'₂ juɨn₅ lɨn₃ dsa₂ juɨg₂ Israel le₃quió'₅ Te₁gui'₅₄ Diú₄ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","'Éi₂ i₂já₅ ne₄ juɨ₅ quió'₅ Te₁gui'₅₄, 'ein₅₄ jme₂dsí₂, ton'₂ 'io₂₃ juɨ₅bí₂ juɨ₁lia'₂ a₂jme₁'io₅ Elías, a₂jme₃dsiain₁₂ mɨ'₅₄ ja₁con₂ dsa₂, quian'₅₄ chi'₂-guein₂ quiáin₅, a₂co₃jéin'₂ juɨ₁lia'₂ i₂tsá₃ ne'₅₄, jme₃tag₂₃ le₃tɨin₂ le₃ŋɨ́i'₂ a₂dse₃. Le₂në₅ jmo₃ co₂jŋia₅₄ dsa₂ ia₁jaun₂ guein₃ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jaun₂ ca₂ŋag₃ Zacarías ca₂ŋɨ́i'₃ ángel: ―¿'A₂ bá₄ lia'₂ lé₂ le₃guion₅₄ jniá₂ a₂tí₅ dsón'₂ jág₁ në₅? Ia₁ dsa₂ ma₂guen'₂ bá₄ jniá₂, le₂jaun₂ guë'₂ dsa₂ mɨ́₂ quiáng₃ i₂ma₂dsɨ₁juɨn₅₄ ŋi₂ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jaun₂ ca₂ŋag₃ táng₃ ángel: ―Gabriel bá₄ jniá₂, chéng'₅ le₃ne₄ Diú₄. A₂cheng₅₄ bá₄ guio₃ a₂juá'₄ jág₁ dse₃ la₂ ne'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","La₁ të₂në₃, cóng'₂, tsá₃ ma₃jág₁ le₃dsiá'₁ ca₂lia'₂ ca₂lë₃ le₂në₅, 'uɨg₅₄ ia₁ a₂tsá₃ 'éng'₂ jág₁ quió₃ a₂le₃ti₃ jë₁ma₂dsɨn₃ jmɨg₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dsa₂ juɨg₂ në́₃, le₁jŋia₂₃ a₂o₃'ɨn₅ Zacarías, dsɨ₂gó'₃ dsɨ́₅ ia₁ a₂ca₂rë₃'ɨn₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jme₁ca₂o₃'ɨ́in₃ në́₃, la₁ tsá₃ ma₃jág₁ le₂dsia₃, jaun₂ ca₂rë₃lí'₄ bá₄ dsa₂, cha₂ a₂ca₂jág₃ dsi₂néi₂ guá'₅ templo. A₂jŋia'₅₄ qui₂bí₂ gu₂ bá₄ jmo₂₃ léi₄, ia₁ ma₂coin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jme₁ca₂dsɨn₃ jmɨg₄ a₂jme₃ti₃ ta₁ jaun₂, jaun₂ ŋái'₃ bá₄ ja₁quió'₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Cang₂ jaun₂ në́₃, ca₂can₃ Elisabet dsa₂ mɨ́₂ quiáin₅ guein₂. Të₁lia'₂ jaun₂, tei₄ bá₄ ca₂'í₃ dsi₂néi₂ quió'₅ con'₂ 'ŋiá₂ tsɨ'₂. 'Ein₅₄ qui₂dsɨ₂jŋia₅ dsɨ́₅, lɨ́in₂: ");
INSERT INTO cntNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Co₂në₅ ca₂rë₃'ŋió₃ dsɨ́₅ Te₁gui'₅₄ a₂lɨ́ng₅ le₂la₂, ia₁jaun₂ tsá₃ ma₂'ag₃ dsa₂ 'lɨg'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jŋéi₂ tsɨ'₂ ma₂ne₁ŋó₄ a₂quian₅ Elisabet guein₂; Diú₄ në́₃ ca₂chein₃ táng₃ ángel Gabriel caun₂ juɨg₂ ja₁tén₄ Galilea ja₁chei₂ Nazaret, ");
INSERT INTO cntNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","a₂ca₂i₁jme₁jniai₂₃ ne₄ jan₂ dsa₂ mɨ₄ i₂jme₁ma₂lɨ'₅₄ jág₁ a₂jéin'₂ gu₂ quian'₅₄ i₂chen₂ José, jan₂ dsa₂ tsɨ₁jon₂ Rag₅₄ David. Dsa₂ mɨ₄ 'éi₂ jme₁chen₂ María. ");
INSERT INTO cntNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jaun₂ në́₃, ca₂'í₃ ángel dsi₂néi₂ ja₁'en₅₄ María, jaun₂ ca₂juá'₂: ―¡Siang'₃ María! ¡'E₂ guë́₄ dsen'₃ 'ne₂, ia₁ quiong'₅₄ Te₁gui'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","La₁ jme₁ca₂nág₂ María jág₁ në₅, 'ŋio₅ lɨn₃ ca₂i₃gó'₃ dsɨ́₅, jaun₂ ca₂'náu'₃ dsɨ́₅ 'e₂ bá₄ jein₅ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jaun₂ ca₂juá'₂ táng₃ ángel: ―Tsá₃ lë₁jmo₂ gang'₃, María, ia₁ a₂dse₃ dsɨ́₅ Diú₄ jmo₂₃ ja₁cong'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ŋí₂, 'í₂ jan₂ guein₂ të₂'au'₂; le₃chan₂ jan₂ guein₂ dsa₂ ŋe'₂ quiáng'₂, jaun₂ quiain'₅₄ JESÚS. ");
INSERT INTO cntNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","'Ŋio₅ juɨin'₂ léin₂; quiong₃ dsa₂ a₂lɨ́in₅ Ja₁ŋi'₅₄ Diú₄ i₂guá₅ guei'₅₄ lɨn₃. Te₁gui'₅₄ Diú₄ në́₃, dsiog₃ ne₄ta₁ quió'₅ David jme₂gui'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jaun₂ jme₃góin₃ con'₂ tan₅₄ ne₄ chi'₂ dsio₄ Jacob, jaun₂ tsá₃ ma₃lɨ́g'₂ jmɨg₄ dsɨ₃ŋɨ́₂ 'éi'₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jaun₂ ca₂ŋag₃ María ca₂ŋɨ́i'₃ ángel: ―¿'A₂ bá₄ lia'₂ lé₂ a₂në₅? Ia₁ tsá₃ dsa₂ ŋe'₂ cuɨ́ng₅. ");
INSERT INTO cntNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jaun₂ ca₂ŋag₃ ángel: ―Jme₂dsí₂ Jŋió₅ bá₄ jmo₃ a₂lé₂ le₂jaun₂ ja₁cong'₂; juɨ₅bí₂ quió'₅ Te₁gui'₅₄ i₂guá₅ guei'₅₄ bá₄ lio₃ 'én'₁ quió'₅. Jaun₂ lë₃, guein₂ jŋió₅ i₂le₃chan₂ 'éi₂, quiong₃ dsa₂ Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ján₃ bá₄ le₂në₅ Elisabet rɨ́ng'₂, o₁jŋia'₅₄ ma₂guein'₂, ma₂të́₂ jŋéi₂ tsɨ'₂ a₂quiain₂₃ guein₂, jaun₂ le₂në₅ bá₄ le₃chan₂ jan₂ guein₂ quián₅ i₂të́'₂ dsa₂ 'io₅₄ quen₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ia₁ 'i₁caun₂ tsá₃ 'e₂ cha₂ jua'₅₄ a₂tsá₃ quɨ'₅₄ jmɨg₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jaun₂ ca₂juá'₂ María: ―Ŋí₂, dsa₂ i₂jme₂ti₃ ta₁ ne₄ Te₁gui'₅₄ bá₄ jniá₂; juɨ₁le₅₄ ja₁cong₂ con'₂ lë́₅ jág₁ quiáng'₂. Jaun₂ ca₂ŋá'₃ ángel ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Të₃jë₄ jmɨg₄ jaun₂, ca₂ŋó₃ María të₂le₃ dséi₂ juɨ₅ juɨg₂ niog₅ má'₂ ja₁tén₄ Judea. ");
INSERT INTO cntNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jaun₂ jme₁ca₂dsióg₃, ca₂'í₃ dsi₂néi₂ quió'₅ Zacarías, ca₂cuɨin₃ Diú₄ Elisabet. ");
INSERT INTO cntNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jme₁ca₂nág₂ Elisabet a₂cuag₅ María Diú₄, dsɨ₂juɨ₅ jaun₂ bá₄ ca₂jɨ́n'₂ guein₂ të₂dsɨ́₅, jaun₂ ca₂rë₃cain'₂ Jme₂dsí₂ Jŋió₅. ");
INSERT INTO cntNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jaun₂ ca₂'í₃ co₂mɨ'₅₄, juá'₂: ―¡'E₂ guë́₄ 'ŋio₅ jme₂gu'₅₄ Diú₄ 'ne₂, lia'₂ con'₂ guë́₄ 'i₁jan₂ dsa₂ mɨ́₂ sián'₂, le₂jaun₂ guë'₂ guein₂ quiáng'₂ në́₃! ");
INSERT INTO cntNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿I₂'ein₂ bá₄ jniá₂, já₅ chog₅₄ Te₁gui'₅₄ quiáng₃ ja₂jag₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ia₁ dsɨ₂juɨ₅ jme₁në₂cuag'₅₄ Diú₄, ca₂jɨ́n'₂ 'io'₂ jén'₅ guein₂ quiáng₃ të₂dsɨ₃. ");
INSERT INTO cntNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡'E₂ guë́₄ dsen'₃ 'ne₂ a₂ca₂rë₃'éng'₂, ia₁ le₃ti₃ ja₁cong'₂ a₂ma₂juá'₂ Te₁gui'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jaun₂ María në́₃, ca₂juá'₂: Jme₂juɨn'₂ të₂dsɨ₃ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Jme₂dsí₂ quió₃ në́₃, 'io'₂ jén'₅ le₃quió'₅ Diú₄ quiáng₃ i₂lió₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ia₁ Diú₄ ca₂jéin'₃ ne₅₄ ja₁con₂ jniá₂ dsɨ₂ŋég₂ i₂jme₂ti₃ quiáin₅. Jaun₂ në₃, le₂tan₅₄ le₃ne₄ juɨ₅ ja₁ŋó₄, të́₂ dsa₂ lɨ́ng₅ i₂rë₂gon'₅₄ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ia₁ 'e₂ guë́₄ 'uan'₂ Diú₄, ia₁ ca₂jmo₃ caun₂ a₂juë'₂ ja₁cong₂; ¡'e₂ guë́₄ jŋió₅ a₂chein₂! ");
INSERT INTO cntNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Co₂tan₅₄ bá₄ ŋéi₂ dsɨ́₅ le₂tan₅₄ tsɨ₁jon₂ dsa₂ i₂jme₂go₃. ");
INSERT INTO cntNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Quian'₅₄ gu₂ bén₂, ca₂jmo₃ caun₂ a₂juë'₂ a₂tsá₃ 'ein₂ quɨ'₅₄ jmɨg₄. Ia₁ co₂ŋei'₅₄ ca₂guiain'₃ 'uë₃ dsa₂ i₂con'₂ ŋɨ́'₂ dsɨ́₅ guion₅₄ jmo₂₃ táin'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ca₂'liain'₃ cau₅ i₂jme₁tián'₄ can'₅₄, a₂ca₂dsiain₃ táng₃ i₂jmo₅ me'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dsa₂ i₂jme₁chan₂ 'on₄, ca₂jme₃tau₅₄ quian'₅₄ a₂dse₃. I₂ŋɨ́₄ jme₁chan₂ dse₃ guë'₂, ca₂'uág'₂ ca₂chei'₃ lɨ́in₃. ");
INSERT INTO cntNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ca₂jme₃'oin₅₄ dsa₂ juɨg₂ Israel i₂jme₂ti₃ quiáin₅, ca₂dsia₃ ŋéi₂ dsɨ́₅ ca₂dsáu'₃ dsɨ́₅ ");
INSERT INTO cntNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","con'₂ lë́₅ jág₁ quió'₅ ca₂tsɨ́'₃ Abraham jme₂gui'₂ jniog₄ quian'₅₄ ca₂le₃jɨ́n₃ tsɨ₁jon₂ quiáin₅ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Con'₂ 'nɨ₅ tsɨ'₂ ca₂dsɨn₃ ca₂'í₃ María ja₁quió'₄ Elisabet. Cang₂ jaun₂ ŋái'₃ táng₃ ja₁quió'₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cang₂ jaun₂ ca₂dsɨn₃ jmɨg₄ a₂le₃chan₂ guein₂ quián₅ Elisabet, jaun₂ ca₂rë₃chán₃ jan₂ guein₂ dsa₂ ŋe'₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jaun₂ ca₂rë₃ŋi₅ o₁rɨin'₅₄, quian'₅₄ dsa₂ i₂tián'₅ cau₅ quió'₅ në́₃, 'a₂ lia'₂ ca₂jmo₃ Te₁gui'₅₄ dse₃ dsɨ́₅ ja₁con₂ 'éi₂. Jaun₂ ca₂jmo₃ 'io'₂ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jaun₂ ca₂lë₃ në́₃, jme₁ca₂të́₂ jŋia₃ jmɨg₄, ca₂o₃lén₂ dsa₂ ca₂ti₃ lo₄ guein₂, jaun₂ jme₁'nio₃ quiong₃ Zacarías lia'₂ chen₂ jmei₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","La₁ ca₂juá'₂ chog₅₄ guein₂: ―Jan₂'ón₄. Juan₅₄ bá₄ le₃chein₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jaun₂ ca₂ŋag₃ táng₃ dsa₂: ―'I₁jan₂ o₁rɨ́ng'₂ tsá₃ i₂chen₂ le₂në₅, jme₁né₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jaun₂ ca₂jmo₃ dsa₂ léi₄ quian'₅₄ gu₂ a₂ca₂tsɨ́'₃ jmei₂ guein₂ 'a₂ guë'₂ lia'₂ 'nio₃ 'éi₂ le₃chen₂ guein₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jaun₂ ca₂mɨ₃ 'éi₂ ca₂'nau₅₄ jau₅₄ 'ma₂, jaun₂ ne₄ jaun₂ ca₂tióng₃: “Juan₅₄ bá₄ chein₂.” Jaun₂ ca₂i₃gó'₃ dsɨ́₅ ca₂le₃jɨ́in₃ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dsɨ₂juɨ₅ jaun₂ ca₂ján₃ mɨ₂'o₄ Zacarías, ca₂'ág₂ 'ua₁ táng₃ le₁tsɨ'₂, ca₂dsia₃ jág₁, ca₂jme₃juɨin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jaun₂ ca₂i₃gó'₃ dsɨ́₅ ca₂le₃jɨ́n₃ dsa₂ i₂tián'₅ cau₅, jaun₂ le₂tan₅₄ juɨg₂ te₁'i₁ 'uë₃ má'₂ ja₁tén₄ Judea në́₃, ca₂i₃'ag₅₄ jág₁ ca₂le₃jë́₃ a₂ca₂lë₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Dsa₂ i₂qui₂ca₂rë₃ŋi₅ a₂jaun₂ në́₃, jme₁'nio'₂ dsɨ́₅ i₂gú'₃ jág₁ në₅, qui₂ŋɨ́i'₅ le₂jan₂ le₂jan₂ dsia₂₃: “¿'E₂ bá₄ lén₂ guein₂ 'éi₂?” Ia₁ dsón'₂ bá₄ dsau₅ léi₄ jme₁quiong'₅₄ Te₁gui'₅₄ guein₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías jmei₂ guein₂ në́₃, rë₂cain'₂ Jme₂dsí₂ Jŋió₅, qui₂ca₂'ë₃ jág₁ ca₂cuë₃ Diú₄, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Juɨ₁le₂juɨn'₂ Te₁gui'₅₄ Diú₄ quián₅ dsa₂ juɨg₂ Israel, ia₁ ma₂guain₂₃ jë₄ quián₂ jniog₄ dsa₂ juɨg₂ quiáin₅, ma₂ca₂lió₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ma₂ca₂cuag₃ jniog₄ jan₂ i₂'uan'₂ lɨn₃ i₂lɨ́n₅ lia'₂ lë́₅ caun₂ mɨ₁juɨ́₁, jan₂ i₂já₅ jë₄ tsɨ₁jon₂ David i₂ca₂jme₃ti₃ ta₁ ne₅₄, a₂ja₂lioin₅₄ dsa₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Le₂në₅ jág₁ quió'₅ ca₂cuë₃ ca₃ma₂lɨ́g'₂, ca₂juá'₂ të₂le₃ quian'₅₄ dsa₂ i₂jme₁'ë́₂ jág₁, i₂jme₁lë́₄ 'í₁ quiáin₅, ");
INSERT INTO cntNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","jme₁ca₂juá'₂ a₂lió₂ o₄gú₃ dsa₂ i₂'iog₅₄, i₂uɨg₅ dsɨ́₅ jág₂ në́₃, ");
INSERT INTO cntNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ja₁juá'₂ në́₃ a₂tiá'₃ ŋéi₂ dsɨ́₅ ja₁con₂ dsa₂ can'₅₄ quián₂, ja₁juá'₂ në́₃ dsiog'₂ dsɨ́₅ jág₁ jŋió₅ quió'₅ ron₅. ");
INSERT INTO cntNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","A₂në₅ bá₄ jág₁ jaun₂ ca₂quiog₂ jme₁ca₂'ɨin₃ 'ŋiog₅ ca₂tsɨ́'₃ Abraham jme₂gui'₂ jniog₄: ");
INSERT INTO cntNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","a₂ca₂juá'₂ a₂lió₂ o₄gú₃ dsa₂ i₂'iog₅₄, ia₁jaun₂ dsiá₁ tiá₂ dsɨ₅ jme₁ti₁ ne₅₄, ");
INSERT INTO cntNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ia₁jaun₂ le₂chong₂ rë₂ le₃ne₅₄, lë́₅ 'í₁, ca₂le₃jë́₃ jmɨg₄ chong₂. ");
INSERT INTO cntNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jaun₂ të₂le₃ ja₁con'₂ 'ne₂ guë'₂, jón₃, të́₂ dsa₂ a₂lɨ́ng'₅ jan₂ i₂'ë́₂ jág₁ quián₅ Diú₄ i₂guá₅ guei'₅₄ lɨn₃, ia₁ gog'₅₄ ne₄ juɨ₅ quió'₅ Te₁gui'₅₄ a₂jmó'₂ co₂jŋia₅₄ juɨ₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","'Ne₂ bá₄ o₁jmo'₄ a₂le₃cuɨ́'₅ dsa₂ juɨg₂ quiáin₅ 'e₂ jaun₂ a₂lión₂ dsa₂, të₂le₃ quian'₅₄ a₂'én₂ dsáu₁. ");
INSERT INTO cntNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ia₁ ŋéi₂ bá₄ dsɨ́₅ Diú₄ quián₂ jniog₄. Jaun₂ lë₃, të₂ guei'₅₄ i₂juɨ́g₃ bá₄ chein₂₃ caun₂ si₂, në₂jag₄ bá₄ ca₂jnia₃ caun₂ jmɨg₄ 'mɨ́₂ ");
INSERT INTO cntNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ja₁con₂ dsa₂ i₂tián'₅ jë₄ qui₁né'₃, ja₁'ei₅ 'én'₁ 'mú₃ në́₃, a₂jiog₃ jniog₄ caun₂ juɨ₅ ja₁'ag₃ tei₄. ");
INSERT INTO cntNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Caun₂ ca₂i₃cón₃ bá₄ guein₂ 'éi₂, caun₂ rë₂'uain'₂ bá₄ të₂le₃ juɨ₅ jme₂dsí₂ në́₃; ca₂guá₂ caun₂ ja₁lë́₄ 'uë₃ quein₂ co₂'ŋiog₅, ca₂lia'₂ ca₂të́₂ jmɨg₄ a₂ca₂jme₃jniai₂₃ jɨn₄ dsa₂ juɨg₂ Israel. ");
INSERT INTO cntNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jaun₂ ca₂lë₃ në́₃ jmɨg₄ jaun₂ ca₂jmo₃ 'éi'₃ gui'₅₄ Emperador Augusto, a₂cho₃ si₂ tioin₃ ca₂le₃jɨ́n₃ dsa₂ ta₁caun₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Jë₁le₂'uɨg₅₄ si₂ në₅ ca₂cho₃ dsa₂ lia'₂ con'₂ jme₁lɨ́n₄ Cirenio dsi₄má'₂ 'uë₃ Siria.) ");
INSERT INTO cntNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jaun₂ jma₃quén₅ ca₂tɨ́n₂ dsa₂ ca₂le₃jɨ́in₃ dsɨ₃lein₃ juɨg₂ go₅₄, a₂qui₂dsɨ₃tioin₃ si₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jaun₂ ca₂'í₃ José juɨ₅ ca₂o₃'ɨ́in₃ juɨg₂ Nazaret ja₁tén₄ 'uë₃ Galilea, ca₂ŋái'₃ juɨ₅ 'uë₃ Judea a₂dsiáin'₄ Belén, go₄ David, ia₁ dsa₂ tsɨ₁jon₂ David bá₄ jme₁lɨ́n₄ José. ");
INSERT INTO cntNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ca₂i₁tioin₃ si₂ ja₁jaun₂ quian'₅₄ María i₂ma₂lɨ'₅₄ jág₁ jéin'₂ gu₂ quiain'₅₄; ma₂quiain₂₃ bá₄ guein₂ ŋɨ₂₃. ");
INSERT INTO cntNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ca₂lë₃ në́₃, con'₂ ma₂tioin'₅₄ ja₁jaun₂, ca₂dsɨn₃ jmɨg₄ a₂le₃chan₂ guein₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ja₁jaun₂ ca₂rë₃chán₃ guein₂ ne₅₄ 'éi₂ quiáin₅, 'ein₅₄ ca₂lio₃ 'mɨ'₂, ca₂quio₂₃ 'ŋió'₃ tsɨ₁gu₅ ja₁guë́'₅ já'₂, 'uɨg₅₄ ia₁ a₂tsá₃ ma₃ja₁ca₂tɨ́in₂ dsi₂néi₂ ja₁siá'₂ ja₁jŋia₃. ");
INSERT INTO cntNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","'Uë₃ jaun₂ jme₁tion'₅₄ jŋia₅ ja₁nau₂ co₂nió'₃ dsa₂ i₂jmo₅ 'í₁ já'₂ cha'₂ quián₅, a₂'uë₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ca₂jme₃jnia₅ jan₂ ángel quián₅ Te₁gui'₅₄ ne₅₄, ca₂jnia₃ co₂tág₅ co₂'né'₅ quió'₅ Te₁gui'₅₄ le₃lág'₃ ja₁tioin'₅₄, jaun₂ ca₂rë₃gó'₅ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","La₁ ca₂juá'₂ ángel: ―Tsá₃ jmo₂ 'nia'₂ gang'₃. Ŋí₂, a₂i₃'ë́₃ jág₁ dse₃ bá₄ jniá₂ guio₃, caun₂ jág₁ quió'₅ ca₂le₃jɨ́n₃ dsa₂, jiá₃ cán₂ o₂'ŋió₃ dsɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ia₁ jmɨg₄ në₃, ca₂rë₃chan₂ o₄quián'₂ 'nia'₂ juɨg₂ go₄ David, jan₂ i₂lió₂, i₂lɨ́n₅ Te₁gui'₅₄ I₂rë₂'ɨ́n₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Quian'₅₄ léi₄ la₂ o₁quion'₂ 'nia'₂ 'í₁: dsian'₂ 'nia'₂ guein₂ rë₂bón'₅ 'mɨ'₂, rë₂quiain₂₃ 'ŋió'₃ tsɨ₁gu₅ ja₁guë́'₅ já'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dsɨ₂juɨ₅ con'₂ tsá₃ jáin₅, ca₂jɨ́in₂ juɨn₅ lɨn₃ ángeles sián'₂ con₂ ángel 'éi₂, ca₂tóin'₂ jme₂juɨin'₂ Diú₄ ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Juɨ₁le₂juɨn'₂ Diú₄ guei'₅₄ i₂juɨ́g₃! Ne₄ gua'₅₄ 'uë₃ në́₃, juɨ₁'ei₅ tei₄ ja₁con₂ dsa₂ mɨ₂güɨ́g₃ i₂ma₂dsia₅ Diú₄ dse₃ dsɨ́₅ o₄quió'₄. ");
INSERT INTO cntNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ca₂lë₃ në́₃, jme₁ma₂i₃len₃ ángeles guei'₅₄ i₂juɨ́g₃, jaun₂ ca₂jme₃lióg₃ dsa₂ i₂jmo₅ 'í₁ já'₂ cha'₂ 'éi₂ qui₂ca₂tsɨ́'₃ rɨin'₅₄: ―Ma₃ jniog₄ juɨ₅ Belén, ma₃ dsɨ₁jag₅₄ a₂ca₂lë₃ ja₁jaun₂, con'₂ lë́₅ jág₁ ma₂në₂'ë́₂ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ca₂i₃léin₂ jaun₂ në́₃ të₂le₃ dséi₂. Dsón'₂ rë'₂ ja₁jaun₂ ca₂dsáin'₂ María quian'₅₄ José, guein₂ në́₃ rë₂quiain₂₃ 'ŋió'₃ gu₅ ja₁guë́'₅ já'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jme₁ca₂jág₂, jaun₂ guë́₄ ca₂dsia₃ 'a₂ lia'₂ lë́₅ jág₁ a₂ca₂nág₂, a₂ca₂'ë́₂ ángel a₂'ɨin₂₃ guein₂, ");
INSERT INTO cntNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","jaun₂ ca₂i₃gó'₃ dsɨ́₅ ca₂le₃jɨ́n₃ dsa₂ i₂ca₂nág₂ jág₁ a₂dsia₅ dsa₂ i₂quián₅ já'₂ cha'₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","La₁ María në́₃, 'no'₂ bá₄ dsɨ́₅ ca₂le₃jë́₃, 'e₂ jein₅ a₂lë́₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Dsa₂ i₂jmo₅ 'í₁ já'₂ cha'₂ në́₃, ca₂i₃lein₃ bá₄ táng₃ qui₂jme₂juɨin'₂ Diú₄, qui₂cuë₂₃ ti₁'mag'₄ o₄quió'₄ ca₂le₃jë́₃ a₂ca₂të́₂ ne₅₄ quian'₅₄ a₂qui₂ca₂nág₂. Ia₁ ca₂le₃jë́₃ bá₄ ca₂rë₃ti₃ con'₂ lë́₅ ca₂juá'₂ ángel. ");
INSERT INTO cntNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jme₁ca₂dsɨn₃ jŋia₃ jmɨg₄, ca₂ti₃ dsa₂ lo₄ guein₂, jaun₂ ca₂quiong₃ JESÚS lia'₂ con'₂ lë́₅ ca₂juá'₂ ángel ca₂tsɨ́'₃ María né'₃ a₂cáun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jme₁ca₂dsɨn₃ jmɨg₄ a₂'i₄ 'éi'₃ jmo₃ le₁jɨ́in₃ a₂jme₂ti₃ lia'₂ con'₂ lë́₅ 'Éi'₃ quió'₅ Moisés, ca₂i₁lein₅₄ Jerusalén jŋiai₂₃ guein₂ i₁jein'₅₄ ne₄ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ca₂jmo₃ le₂në₅ ia₁ ton₅ ne₄ Si₂ quió'₅ Te₁gui'₅₄: “Ca₂le₃jɨ́n₃ guein₂ dsa₂ ŋe'₂ i₂ne₅₄ i₂le₃chan₂, léin₂ i₂lë́₅ 'í₁ quián₅ Te₁gui'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ja₁jaun₂ ca₂jén'₃ ján₃ con'₂ lë́₅ juá'₂ 'éi'₃ quió'₅ Te₁gui'₅₄: “On₃ i₁ju₂, o₃ co₂dsán'₃ i₁ju₂ bë₂ 'e₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jmɨg₄ jaun₂, jme₁chan₂ jan₂ dsa₂ jë₄ juɨg₂ Jerusalén i₂jme₁chen₂ Simeón. Jme₁lɨ́in₄ jan₂ dsa₂ dsen₃ lɨn₃, i₂jme₁jme₂gan₃ Diú₄; jme₁chain₂ chi₁jŋia₂₃ a₂guán₂ i₂cuë₃ lián'₂ quió'₅ dsa₂ juɨg₂ Israel. Jme₁quiong'₅₄ Jme₂dsí₂ Jŋió₅; ");
INSERT INTO cntNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","'éi₂ bá₄ ma₂ca₂'ë́₂ jág₁ ne₅₄ a₂tsá₃ jóin₂ ca₂lia'₂ ca₂jɨ́in₂ de'₂ I₂rë₂'ɨ́n₁ quián₅ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jmɨg₄ jaun₂ ŋó₃ jiog₅ Jme₂dsí₂ Jŋió₅ juɨ₅ guá'₅ templo. Ja₁jaun₂ jme₁'ein₅₄ në́₃ jme₁ca₂dsi₃lén₂ chog₅₄-jmei₂ guein₂ Jesús, jŋiai₂₃ guein₂ a₂jmo₃ quiong'₅₄ con'₂ lë́₅ tag₄ chí'₅ a₂quí'₅ 'Éi'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jaun₂ ca₂jŋau'₃ Simeón ca₂jŋai'₃ guein₂, ca₂jme₃juɨin'₂ Diú₄, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Në₃ guë́₄ në́₃, 'ne₂ juɨg₃ quiáng₃, ma₂lé₂ dsiang'₅₄ tei₄ dsa₂ i₂jme₂ti₃ ne'₅₄, lia'₂ con'₂ lë́₅ jág₁ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ia₁ la₂ ca₂të́₂ ne₃ i₂ma₂cheng'₂ lió₂, ");
INSERT INTO cntNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","i₂ma₂jmo'₅₄ co₂jŋia₅₄ quián₅ ca₂le₃jë́₃ juɨg₂ nación. ");
INSERT INTO cntNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I₂la₂ bá₄ i₂lɨ́n₅ si₂ i₂jmo₃ tág₅ ja₁con₂ dsɨ₂nau₂; i₂la₂ bá₄ i₂lɨ́n₅ dsa₂ i₂chi'₃ jlá'₁ juɨg₂ Israel quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ca₂i₃gó'₃ dsɨ́₅ bá₄ José quian'₅₄ chog₅₄ guein₂, o₄quió'₄ jág₁ a₂ca₂juá'₂ Simeón jaun₂, 'ɨin₂₃ guein₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jaun₂ ca₂jme₃gu'₅₄ Simeón quió'₅, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ María chog₅₄ guein₂: ―Ŋí₂, 'en₅₄ juɨ₅ guein₂ la₂ já₅, jmo₃ a₂dsɨ₃gan'₅₄ 'uë₃ juɨn₅ dsa₂ juɨg₂ Israel, o₃ të₂le₃ ron'₂ juɨn₅ 'e₂. Já₅ lɨ́in₅ caun₂ léi₄ quió'₅ i₂'ag₃ i₂náu₃ quen₅ i₂le₃'iog₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Le₂në₅ bá₄ jióg'₃ 'í₁ le₃jniá₂ 'a₂ lia'₂ dsɨ₂jiog₅ dsɨ́₅ dsa₂ le₂jan₂ le₂jan₂. La₁ të₂le₃ ja₁cong'₂ në́₃, dsɨ₃ŋɨ́g'₂ në₂jag₄ bá₄ caun₂ ŋi₁tág₂ dsɨ₂tia₃ të₂'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ján₃ bá₄ jaun₂ jme₁'en₅₄ jan₂ guiong'₂ i₂chen₂ Ana, ja₁mɨ́g₄ Fanuel, dsa₂ tsɨ₁jon₂ Aser. 'Éi₂ në́₃ jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄ ján₃. Jme₁ma₂guein'₂. Mei'₂ bá₄ lia'₂ con'₂ ca₂jen'₂ gu₂. Guio₃ ŋi₂ bá₄ ca₂rë₃quiain'₅₄ dsa₂ ŋe'₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Quén'₂ ne₂guióg₂ rë₂dsɨ́₂ quén₂ (84) ŋi₂ a₂ca₂rë₃'nɨ́i₂. Guiong'₂ 'éi₂ në́₃ jme₁'ein₅₄ tián₂ i₁dsi₅ guá'₅. 'Uë₂-jmɨ₂ bá₄ jme₁jme₂ti₃ ne₄ Te₁gui'₅₄ chi₂léin'₂ Diú₄ a₂jme₂'ɨin₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hora jaun₂ dé₄ ca₂dsióg₃ ja₁tión₂ dsa₂, ca₂cuë́'₃ ti₁'mag'₄ Diú₄, ca₂dsia₃ jág₁ 'ɨin₂₃ guein₂ tsɨ́'₅ ca₂le₃jɨ́n₃ dsa₂ i₂tion'₅₄ i₂le₁jŋia₅ a₂lión₂ dsa₂ juɨg₂ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jaun₂ në́₃ jme₁ma₂ca₂lë₃ jmo₂₃ ca₂le₃jë́₃ con'₂ lë́₅ ta₁ quí'₅ 'Éi'₃ quió'₅ Te₁gui'₅₄, jaun₂ ca₂i₃lein₃ juɨ₅ 'uë₃ Galilea, ja₁niog₅ Nazaret, juɨg₂ go₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Guein₂ në́₃, caun₂ ca₂i₃juɨin'₂ bá₄, caun₂ ca₂rë₃'uáin'₃ në́₃, ton'₂ 'ŋio₅ lɨn₃ ŋi₅, Diú₄ bá₄ jme₁jme₂gu'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ca₂le₃jë́₃ ŋi₂ jme₁dsɨ₂lén₂ chog₅₄-jmei₂ Jmɨg₄ Të₂'ɨn₅₄ a₂të₅ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jme₁ca₂dsɨ́'₃ Jesús guia₃-tɨ́n₂ ŋi₂, ca₂i₃léin₂ táng₃ co₂dsia₅ juɨ₅ Jerusalén. Ia₁ le₂jaun₂ tɨn₂ dsa₂ ca₂le₃jë́₃ ŋi₂ dsɨ₃léin₂ jmɨg₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jme₁ca₂gú'₃ jmɨg₄, ca₂i₃lein₃ táng₃. Tsá₃ ca₂rë₃lí'₄ chog₅₄-jmei₂ jŋia'₅₄ jaun₂ bá₄ të₁'ŋia₄ Jesús Jerusalén, ");
INSERT INTO cntNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ia₁ lɨ́in₂ ma₂ŋái'₅ bá₄ quiain'₅₄ dsa₂ sián'₂. Caun₂ jmɨg₄ ma₂ne₁ŋó₄ tioin'₅₄ juɨ₅ i₃lein₃ jme₁ca₂'nau'₂ jɨn₄ o₁rɨin'₅₄, jɨn₄ dsa₂ i₂cuɨin₂₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","La₁ tsá₃ ca₂dsáu'₂. Jaun₂ ca₂jéin'₃ táng₃ juɨ₅ ca₂i₃léin₂ Jerusalén ca₂i₁'niog'₂ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","A₂'nɨ₅ jmɨg₄ jaun₂ jme₁ca₂dsáu'₂ i₁dsi₅ guá'₅, guá₅ jɨn₄ të₅juá'₅, nag₂₃ jág₁, ŋag₂₃ ŋɨ́i'₅ 'éi₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jaun₂ ca₂i₃gó'₃ dsɨ́₅ ca₂le₃jɨ́n₃ i₂tion'₅₄ nag₅ jág₁ quió'₅, ia₁ 'ŋio₅ lɨn₃ ŋi₅ 'a₂ lia'₂ qui₂jéin'₃ jág₁ quió'₅ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jme₁ca₂jág₂ chog₅₄-jmei₂, ca₂i₃gó'₃ dsɨ́₅, jaun₂ ca₂juá'₂ chog₅₄: ―Jón₃, ¿'e₂ lë₃ jmog'₅₄ le₂në₅? Ŋéi'₅, jniá₂ në́₃, ma₂në₂i₁nio₁ 'ɨ₅ dsɨ₅ 'niog'₂ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jaun₂ ca₂ŋag₃ Jesús: ―¿'E₂ lë₃ 'nau'₂ 'nia'₂ jniá₂? ¿Tsa₁ ŋi'₅₄ 'nia'₂ a₂ca₂tɨ́ng₂ 'ú₄ ta₁ quió'₅ Ŋe'₃? ");
INSERT INTO cntNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","La₁ tsá₃ ca₂ŋɨ́'₂ dsɨ́₅ 'éi₂ 'e₂ jein₅ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jaun₂ ca₂jóin'₃ bá₄ quiain'₅₄ chog₅₄-jmei₂ juɨ₅ Nazaret. Caun₂ bá₄ ne'₅₄ ca₂le₃jë́₃ a₂të₂néi'₂ chog₅₄-jmei₂. La₁ tei₄ bá₄ 'ma₅ chog₅₄ dsɨ́₅ ca₂le₃jë́₃ a₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jaun₂ caun₂ ca₂i₃juɨn'₂ bá₄ Jesús, rë₂ niog₅ dsi₅₄, rë₂ chéin'₅ le₃ne₄ Diú₄, lia'₂ le₃ne₄ dsa₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ŋi₂ guia₃-'ŋiá₂ lia'₂ con'₂ jme₁lɨ́n₄ emperador Tiberio, jmɨg₄ lia'₂ con'₂ jme₁lɨ́n₄ táng₃ Poncio Pilato dsi₄má'₂ 'uë₃ Judea; Herodes guë'₂ jme₁lɨ́n₄ rag₅₄ i₂jmo₅ 'éi'₃ 'uë₃ Galilea; Felipe rɨin'₅₄ guë'₂ jme₁lɨ́n₄ dsi₄má'₂ le₂tan₅₄ juɨg₂ Iturea quian'₅₄ Traconite; Lisanias në́₃ jme₁lɨ́n₄ dsi₄má'₂ quián₅ Abilinia. ");
INSERT INTO cntNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ján₃ bá₄ jmɨg₄ jaun₂ jme₁lɨ́n₄ jme₂dsa₂ dsen₅₄ Anás quian'₅₄ Caifás. Con'₂ jmɨg₄ jaun₂ dé₄ në́₃, ca₂të₃ Diú₄ ca₂të́'₃ Juan₅₄, ja₁ŋi'₅₄ Zacarías, 'uë₃ co₂'ŋiog₅ ja₁jme₁guá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan₅₄ në́₃ ca₂ŋɨ₃ le₂tan₅₄ juɨg₂ te₁'i₁ ma₂quián₅ Cuá₃ Jordán, qui₂tsɨ́'₅ dsa₂ a₂'nió'₅ tsóin₃ jmɨg₂, cuë₃ léi₄ a₂ma₂ca₂dsi₃quén'₅ dsɨ́₅ ia₁jaun₂ le₃'én₂ Diú₄ dsáu₁. ");
INSERT INTO cntNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Le₂në₅ bá₄ ca₂lë₃ ca₂rë₃ti₃ con'₂ lë́₅ jág₁ a₂ca₂tó'₂ Isaías ne₄ si₂, i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄, a₂ca₂juá'₂: Nag₃ dsa₂ co₂mɨ'₅₄ jág₁ caun₂ 'uë₃ co₂'ŋiog₅, a₂juá'₂: Jmo₄ 'nia'₂ co₂jŋia₅₄ juɨ₅ quió'₅ Te₁gui'₅₄; Nia₄ 'nia'₂ caun₂ juɨ₅ co₂dsau₅. ");
INSERT INTO cntNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ca₂le₃jë́₃ jɨ'₅₄ siá₅ 'nió'₅ le₃can'₂, ca₂le₃jë́₃ dsɨ₂con'₂, má'₂, 'nió'₅ 'ag₃ co₂rë₂; Ca₂le₃jë́₃ juɨ₅ qui₂rë₂guion'₂, 'nió'₅ lé₂ co₂dsau₅, juɨ₅ a₂qui₂le₁quɨn'₅₄, 'nió'₅ lei₂. ");
INSERT INTO cntNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ca₂le₃jɨ́n₃ dsa₂ mɨ₂güɨ́g₃ bá₄ jág₃ 'a₂ lia'₂ lë́₅ a₂jmo₃ Diú₄ lió₂. ");
INSERT INTO cntNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jaun₂ ca₂'uɨn₂ dsa₂ quió'₅, ca₂o₃léin₂ mɨ₂₃ cho₃ Juan₅₄ jmɨg₂, jaun₂ ca₂juá'₂ 'éi₂: ―¡'Nia'₂ tsɨ₁jon₂ dsɨ₂mɨ'₂! ¿'Ein₂ bá₄ në₂chí'₃ 'nia'₂ a₂cuɨng'₂ long'₅₄ uɨg₅ a₂ja₂quián₃? ");
INSERT INTO cntNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Cuë₄ 'nia'₂ léi₄ jaun₂ a₂të₃dsón'₂ ma₂ca₂dsi₃quén'₅ 'au'₂. 'A₃ lë₁juɨ₁dsi₂jŋia₅ 'au'₂ 'nia'₂ jua'₅₄ a₂jua'₅₄: “Lág₅ jnia'₅₄ tsɨ₁jon₂ Abraham”; ia₁ jniá₂ juá'₅, Diú₄ quɨ'₅₄ jmɨg₄ jmo₃ ca₂të₂ nɨ₁cang₁ tio'₅₄ la₂, lé₂ le₃jmói'₂ chi'₂-guein₂ quián₅ Abraham. ");
INSERT INTO cntNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ia₁ ma₂lë́₅ co₂jŋia₅₄ ŋi₁dsi₁ a₂qui₃uɨ́n'₂ nɨ₁'ma₂. Ca₂le₃jë́₃ 'ma₂ a₂tsá₃ dse₃ mɨ́g₂ 'ag₅, uɨ́n'₂ dsɨ₃to'₅₄ si₂. ");
INSERT INTO cntNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jaun₂ ca₂ŋag₃ dsa₂: ―¿'E₂ bá₄ le₃jmó₁ jnia'₅₄ jaun₂ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jaun₂ ca₂ŋag₃ táng₃: ―I₂cha₂ tɨn₃ dsán'₃ tsɨn'₅₄, juɨ₁cuë́'₄ co₂dsán'₃ i₂tsá₃ cha₂ quió'₅; le₂jaun₂ guë'₂ juɨ₁lia'₂ i₂cha₂ a₂guë́'₃, juɨ₁jme₂'oin₅₄ juɨ₁lia'₂ i₂tsá₃ cha₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ca₂o₃lén₂ i₂lɨn₅₄ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄ në́₃, a₂'nio₃ tsóin₃ jmɨg₂, jaun₂ ca₂tsɨ́'₃ Juan₅₄: ―Të₅, ¿'e₂ bá₄ lé₂ le₃jmó₁ jnia'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jaun₂ ca₂jéin'₃ táng₃ 'éi₂ jág₁: ―Tsá₃ jmó'₂ 'nia'₂ jua'₅₄ a₂cán'₁ ŋag₅₄ guë́₄ 'lia'₅₄ quió'₅ dsa₂, jua'₅₄ a₂dsɨ₁juɨn'₅₄ con'₂ 'éi'₃ quí'₅ si₂. ");
INSERT INTO cntNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ca₂o₃lén₂ i₂lɨn₅₄ 'lióg₂ në́₃, ca₂ŋag₃: ―Jnia'₅₄ guë'₂ në́₃: ¿'E₂ bá₄ ca₂tág₂ jnia'₅₄ jmó₁? Jaun₂ ca₂ŋag₃: ―Tsá₃ qui₁quiang'₄ dsa₂ juë́'₅, jua'₅₄ a₂qui₁jŋiá'₄ 'e₂ qui₁jŋiá'₄ quió'₅, on₃ guë'₂ qui₁'nɨ́g'₄ dsa₂ jua'₅₄ a₂lë₁qui₁'nɨ́i'₄. Juɨ₁le₂'ŋio₂ bá₄ 'au'₂ 'nia'₂ ján₃, con'₂ ma₂tí₅ 'liang'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","La₁ dsa₂ në́₃, tsá₃ tei₄ le₁'ág₄ dsɨ́₅ tioin'₅₄, le₁jŋia₂₃ le₃ŋi₅ chi₂jua'₂ Juan₅₄ 'éi₂ bá₄ lɨ́n₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jaun₂ ca₂juá'₂ Juan₅₄ 'ŋiog₅, ca₂tsɨ́'₃ ca₂le₃jɨ́n₃: ―Jniá₂ në₂tiáng₃ 'nia'₂ jmɨg₂; la₁ i₂já₅ chi₂quɨ́n₃ në₅, tióg₂ Jme₂dsí₂ Jŋió₅, jë₄ si₂ në́₃. 'Éi₂ bá₄ i₂'uan'₂ guë́₄ lia'₂ con'₂ guë́₄ jniá₂, ca₂lia'₂ jŋia'₅₄ lau₂ ton₅ tag₅₄ bá₄ tsá₃ ca₂tɨ́ng₂ tsɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ma₂chi₁chan'₂ si₂jmu₂ a₂jme₂dse₃ mɨ́g₂ trigo. Cág'₃ dse₃ lɨn₃, con'₂ dsia₃ jmá'₃ a₂dse₃, 'ma₃ dsi₂néi₂. Dsɨ́'₂ bá₄ jme₁qui₅ dsi₂si₂ ja₁tsá₃ lɨ́g'₂ jmɨg₄ éi₃. ");
INSERT INTO cntNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jaun₂ le₂në₅ bá₄, 'lióng₂ jág₁ dse₃ siá'₂ ca₂to'₂ Juan₅₄, ca₂jme₃tɨin₂₃ dsa₂ jág₁ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ján₃ bá₄ ca₂jéin₂ Rag₅₄ Herodes, ia₁ a₂jme₁ma₂guá₅ 'éi₂ quian'₅₄ 'io₅₄ Herodías dsa₂ mɨ́₂ quián₅ rɨin'₅₄, ne₄ 'lióng₂ guë́₄ a₂'lɨg'₅₄ siá'₂ a₂jme₁jmo₅-dsáu₅ Herodes; ");
INSERT INTO cntNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","la₁ të₂le₃ ŋag₅₄ guë́₄ ca₂jme₃ja₃: né'₃ 'má₃ bá₄ ca₂tiáin₂ Juan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jme₁ma₂ca₂lë₃ choin₂₃ jmɨg₂ ca₂le₃jɨ́n₃ dsa₂, jme₁ma₂në₂chon₃a Jesús jmɨg₂, a₂ma₂chéin'₅ chi₂léin'₂ Diú₄ në́₃. Të₃jë₄ jaun₂ ca₂niá₃ dsɨ₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ca₂sión₃ Jme₂dsí₂ Jŋió₅ chi₁dsáin₃ jniái₂ lia'₂ jniá₂ jan₂ i₁ju₂, ne₄ quió'₅. Jaun₂ ca₂né'₂ jág₁ a₂já₅ guei'₅₄ i₂juɨ́g₃ a₂juá'₂: ―'Ne₂ bá₄ lɨ́ng'₅ jón₃ quiáng₃ i₂'nióg₃ guë́₄ lɨn₃; 'ŋio₂ bá₄ dsɨ₃ 'ŋio₅ lɨn₃ jɨng₅₄ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Con'₂ guióg₂-guiá₂ ŋi₂ bá₄ jme₁ma₂'en₅₄ Jesús lia'₂ con'₂ jme₁ca₂jme₃lióg₃ ca₂jme₃tɨin₂₃ dsa₂ jág₁ dse₃. Dsa₂ në́₃, jmo₂₃ dsɨ́₅ a₂lɨ́n₅ 'éi₂ ja₁ŋi'₅₄ Së́₄. Jaun₂ Së́₄ 'éi₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Elí. ");
INSERT INTO cntNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí 'éi₂ guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Matat; Matat 'éi₂ guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Leví i₂jme₁lɨ́n₄ ja₁ŋi'₅₄ Melqui; Melqui në́₃ jme₁lɨ́n₄ chi'₂ quián₅ Jana, i₂jme₁lɨ́n₄ chi'₂ quián₅ José; ");
INSERT INTO cntNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José në₅ në́₃ ca₂já₃ ca₂lɨin₃ chi'₂ quián₅ Matatías; Matatías guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Amós; Amós jme₁lɨ́n₄ ja₁ŋi'₅₄ Nahum; Nahum guë'₂ jme₁lɨ́n₄ ja₁ŋi'₅₄ Esli, i₂jme₁lɨ́n₄ chi'₂ quián₅ Nagai ");
INSERT INTO cntNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","i₂jme₁lɨ́n₄ chi'₂ quián₅ Ma'at; Ma'at guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Matatías; Matatías guë'₂ ca₂já₃ ca₂lɨin₃ chi'₂ quián₅ Semei; Semei 'éi₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ i₂chen₂ José; José guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Judá; ");
INSERT INTO cntNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá 'éi₂ guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Joana; Joana 'éi₂ guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ chi'₂ quián₅ i₂jme₁chen₂ Resa; Resa guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ i₂chen₂ Zorobabel; Zorobabel guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ chi'₂ quián₅ i₂jme₁chen₂ Salatiel, i₂jme₁lɨ́n₄ ja₁ŋi'₅₄ Neri, ");
INSERT INTO cntNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","i₂jme₁lɨ́n₄ ja₁ŋi'₅₄ Melqui, i₂jme₁lɨ́n₄ ja₁ŋi'₅₄ Adi, i₂jme₁lɨ́n₄ chi'₂ quián₅ i₂chen₂ Cosam, i₂jme₁lɨ́n₄ chi'₂ quián₅ Elmodam, i₂jme₁lɨ́n₄ chi'₂ quián₅ i₂jme₁chen₂ Er, ");
INSERT INTO cntNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","i₂jme₁lɨ́n₄ chi'₂ quián₅ Josué; Josué në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Eliezer; Eliezer guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Jorim, i₂jme₁lɨ́n₄ ja₁ŋi'₅₄ Matat; ");
INSERT INTO cntNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Leví; Leví guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Simeón; Simeón guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Judá; Judá guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ José; José 'éi₂ guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Jonán; Jonán 'éi₂ guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Eliaquim; ");
INSERT INTO cntNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Melea; Melea guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Mainán; Mainán guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Matata; Matata guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Natán; ");
INSERT INTO cntNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ David; David 'éi₂ guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Isaí; Isaí guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Obed; Obed guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Bo'oz; Bo'oz guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Salmón; Salmón guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Na'asón; ");
INSERT INTO cntNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na'asón guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Aminadab; Aminadab guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Aram; Aram guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Esrom; Esrom guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Fares; Fares guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Judá; ");
INSERT INTO cntNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Jacob; Jacob guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Isaac; Isaac guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Abraham; Abraham guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Taré; Taré guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Nacor; ");
INSERT INTO cntNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Serug; Serug guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Ragau; Ragau guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Peleg; Peleg guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Heber; Heber guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Sala; ");
INSERT INTO cntNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Cainán; Cainán guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Arfaxad; Arfaxad guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Sem; Sem guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Noé; Noé guë'₂ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Lamec; ");
INSERT INTO cntNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Matusalén; Matusalén guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Enoc; Enoc guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Jared; Jared guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Mahalale'el; Mahalale'el guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Cainán; ");
INSERT INTO cntNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Enós; Enós guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Set; Set guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ ja₁ŋi'₅₄ Adán; Adán guë'₂ në́₃ ca₂já₃ ca₂lɨin₃ co₂'nió'₄ ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jaun₂ Jesús në́₃, ma₂rë₂rɨin₅ Jme₂dsí₂ Jŋió₅, ca₂o₃'ɨ́in₃ Cuá₃ Jordán. Ca₂jiog₃ Jme₂dsí₂ caun₂ 'uë₃ quein₂ co₂'ŋiog₅. ");
INSERT INTO cntNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ja₁jaun₂ ca₂i₁'i₅ të₂láu₃ jmɨg₄, ia₁jaun₂ cáun₂ táu₂ i₂së₃dsen₃. Tsá₃ 'e₂ ca₂guë́'₃ 'i₁ca₂juɨg₄ të₁lia'₂ jmɨg₄ jaun₂. Jme₁ca₂dsan₃ jaun₂, jaun₂ guë́₄ ma₂i₁cón'₅ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jaun₂ ca₂juá'₂ i₂së₃dsen₃: ―Chi₂jua'₂ dsón'₂ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄, jmo₄ juɨ₁le₅₄ i₁ŋí'₄ nɨ₁cang₁ në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jaun₂ ca₂ŋag₃ Jesús: ―Chi₁ton₅ ne₄ Si₂: “On₃jua'₅₄ jmá'₃ quian'₅₄ i₁ŋí'₄ le₃tan₅₄ dsa₂ mɨ₂güɨ́g₃ le₃chain₂.” , ");
INSERT INTO cntNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jaun₂ ca₂jiog₃ táng₃ i₂së₃dsen₃ caun₂ má'₂ ja₁ŋei₅. Ja₁jaun₂ ca₂'ë₃ ca₂tiá₂ tei₄ ca₂le₃jë́₃ juɨg₂ te₁'i₁ gua'₅₄ 'uë₃. ");
INSERT INTO cntNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jaun₂ ca₂juá'₂: ―Gog'₂ 'ne₂ bá₄ dsia₅₄ jniá₂ ca₂le₃jë́₃ juɨg₂ në₅; 'ne₂ bá₄ gong'₂ lé₂, 'ó'₄ bí₂, qui₂jme₃juag'₂ dsa₂. Ia₁ a₂niog₅ ne₃ jniá₂ bá₄ në₅, ton'₂ lé₂ le₃cuë́₄ jniá₂ 'ein₂ 'nio₃ cuë́₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jaun₂ a₂lé₂ quiáng'₂ në₁jua'₂ ca₂chi₁jne'₄ ne₃ jme₁juag'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jaun₂ ca₂ŋag₃ Jesús: ―Ne₄ Si₂ quió'₅ Diú₄ chi₁ton₅: “Jme₁gan₃ 'nia'₂ Te₁gui'₅₄ Diú₄ quiáng'₂; ne₄ jan₂ 'éi₂ bá₄ ca₂tɨ́n'₂ 'nia'₂ jme₁ti'₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Cang₂ jaun₂ ca₂jiog₃ táng₃ i₂së₃dsen₃ juɨg₂ Jerusalén, jaun₂ ca₂i₁chei'₂ caun₂ ja₁lë́₄ ja₁ŋei₅ guë́₄ ne₄ nɨ₁'ia'₂ guá'₅ templo, jaun₂ ca₂juá'₂: ―Chi₂jua'₂ 'ne₂ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄, tian'₅₄ ca₂të₂ 'uë₃; ");
INSERT INTO cntNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ia₁ chi₁ton₅ ne₄ Si₂: Dsiog₃ Diú₄ o₄gú₃ ángeles quiáin₅, jaun₂ jmo₃ 'í₁; ");
INSERT INTO cntNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","guéi'₂ quian'₅₄ gu₂ ia₁jaun₂ tsá₃ jéng'₂ uɨg₅ nióg'₃ nɨ₁cang₁. ");
INSERT INTO cntNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jaun₂ ca₂ŋag₃ Jesús: ―Ján₃ bá₄ juá'₂ ne₄ si₂: “Tsá₃ tang'₅₄ Te₁gui'₅₄ Diú₄ quiáng'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jme₁ca₂dsan₃ ca₂le₃jë́₃ a₂niog₅ ca₂juá'₂ i₂së₃dsen₃ a₂cáun₂ táu₂ jaun₂, jaun₂ ca₂i₃uɨ́in₂ co₂'na₂, në₁jua'₂ lɨ́g'₂ ca₂cuɨn₃ táng₃ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ca₂ŋá'₃ táng₃ Jesús juɨ₅ 'uë₃ Galilea rë₂can'₂ Jme₂dsí₂ Jŋió₅ të₂dsɨ́₅. Le₂con₂ juɨg₂ te₁'i₁ ma₂quián₅ jaun₂, ca₂i₃'ag₅₄ jág₁ 'ag₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ca₂i₁jme₁tɨin₂₃ dsa₂ le₂tan₅₄ guá'₅ sinagogas quió'₅ dsa₂, jaun₂ ca₂le₃jɨ́n₃ bá₄ dsa₂ jme₁jme₂juag'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jaun₂ ca₂ŋái'₃ juɨ₅ Nazaret, ja₁ca₂i₃juɨin'₂. Caun₂ jmɨg₄ sa₅₄ ca₂'í₃ dsi₂néi₂ guá'₅ sinagoga, ia₁ le₂jaun₂ tɨin₂. Jaun₂ ca₂nau₂ a₂'ɨ₃ Si₂. ");
INSERT INTO cntNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jaun₂ ca₂cuë₃ dsa₂ si₂ rë₂bɨn₅ quió'₅ Isaías i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄. Jme₁ma₂në₂néi'₃ si₂, jaun₂ ca₂dsó'₂ ja₁chi₁ton₅ le₂la₂: ");
INSERT INTO cntNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Dsɨ́n₂ Jme₂dsí₂ quián₅ Te₁gui'₅₄ ne₄ quió₃, ia₁ ma₂ca₂'ag₃ jniá₂ a₂i₁'ë́₃ jág₁ dse₃ jɨn₄ dsa₂ dsɨ₂ŋé₂. Ca₂chei₃ a₂i₁'ë́₃ jág₁ a₂lión₂ dsa₂ i₂qui₂le₁jnɨ́₅, ton'₂ ján₃ guë'₂ jmo₅₄ jnia₅₄ jme₁ne₁ dsa₂ i₂ten₄; qui₁long₁₂ dsa₂ i₂qui₂dsɨ₂ŋɨ́₂ uɨg₅ qui₂jmóg'₂ dsa₂; ");
INSERT INTO cntNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","a₂'ë́₄ jmɨg₄ dse₃ a₂lió₂ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jaun₂ ca₂bɨ́in₂ táng₃ si₂; ca₂jɨ́in'₃ dsa₂ i₂jme₂'o₅₄, jaun₂ ca₂guá₂ táng₃. Ia₁ jaun₂ bá₄ tion'₅₄ dsa₂ ca₂le₃jɨ́in₃ le₁ŋɨi'₂, jág₂. ");
INSERT INTO cntNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jaun₂ ca₂jme₃lióg₃ Jesús ca₂juá'₂: ―Jmɨg₄ në₃ ca₂të́₂ ne'₅₄ 'nia'₂ ca₂rë₃ti₃ a₂juá'₂ Si₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ca₂le₃jɨ́n₃ bá₄ dsa₂ 'ɨin₂₃ dse₃ Jesús, dsɨ₂gó'₃ dsɨ́₅ ca₂le₃jë́₃ jág₁ jlá'₁ a₂'uë'₂ 'o₅₄. Jaun₂ qui₂ca₂ŋɨ́i'₃ rɨin'₅₄: ―¿On₁jua'₅₄ i₂në₅ 'éi₂ i₂lɨ́n₅ ja₁ŋi'₅₄ Së́₄? ");
INSERT INTO cntNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jaun₂ ca₂juá'₂ Jesús: ―A₂dsɨ₂jó'₃ já₅ jmɨg₄ le₃jua'₅₄ 'nia'₂ juɨg'₅₄ jniá₂ quio₃ la₂: “'Ne₂ të₅mɨ́₅ jma'₅₄ mɨ́₅ 'ŋiag'₂.” Le₃jua'₅₄ 'nia'₂ në́₃: “A₂ca₂rë₃ne₄ jnia'₅₄ a₂ca₂jmo'₅₄ Capernaum, ma₂në₃ jmo₄ ja₁lá₃ go'₅₄ ján₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Caun₂ ca₂juá'₂ bá₄: ―A₂të₃dsón'₂ juá'₅ jniá₂ juɨ́g₂ 'nia'₂, 'i₁jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄, tsá₃ a₁jaun₂ jua'₅₄ a₂guei₃ dsa₂ dse₃ go₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tí₅ bá₄ jág₁ quió₃ a₂juá'₅ la₂, juɨn₅ dsa₂ mɨ́₂ 'nág₂ i₂jme₁chan₂ Israel jmɨg₄ lia'₂ con'₂ jme₁chan₂ Elías i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄, lia'₂ con'₂ ca₂rë₃'ɨ́n₃ 'ŋio₅ lɨn₃ a₂guë́'₃ dsa₂ ta₁caun₂ juɨg₂ nación, ia₁ tsá₃ ma₃jmɨ́₅ ca₂tang₂ 'nɨ₅ ŋi₂ të₂ ca₂dsio₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","La₁ ca₂lia'₂ quió'₅ 'i₁jan₂ 'io₅₄ 'nág₂ i₂jme₁chan₂ Israel, tsá₃ ca₂ŋe₄ Elías, jŋia'₅₄ lia'₂ quió'₅ jan₂ i₁náu₃ i₂jme₁guá₄ Sarepta a₂niog₅ quián₅ ciudad Sidón bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ján₃ bá₄ le₂jaun₂ jme₁chan₂ juɨn₅ dsa₂ i₂jme₁lɨ́n₄ 'mé'₅ 'iog₅ juɨg₂ Israel, lia'₂ con'₂ jmɨg₄ ca₂ŋɨ₃ Eliseo i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄ ján₃. La₁ ca₂lia'₂ 'i₁jan₂ i₂'éi₂ tsá₃ ca₂'lón₂, jŋia'₅₄ lia'₂ jan₂ i₂jme₁chen₂ Na'amán i₂jme₁chan₂ 'uë₃ Siria bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jme₁ca₂nág₂ dsa₂ jág₁ në₅, ca₂le₃jɨ́n₃ con'₂ i₂tion'₅₄ guá'₅ sinagoga ca₂rë₃'néi₃ 'lɨg'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Qui₂ca₂nau₂ tioin'₅₄, ca₂dsei₂₃ juɨg₂, ca₂i₃léin₂ le₁jiog₂₃ ca₂të₂ ne₄ má'₂ ja₁lë́₄ nɨ₁'lau₂ dsio'₅₄ juɨg₂, ia₁ a₂jme₁dsɨ₂jiog₅ dsɨ́₅ jme₁tón₂ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","La₁ con'₂ ca₂ŋɨ₅ bá₄ 'éi₂ jë₄ quió'₅, ca₂lóin₂ ŋái'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jaun₂ ca₂ŋó₃ Jesús juɨg₂ Capernaum, caun₂ juɨg₂ tén₅ 'uë₃ Galilea. Ja₁jaun₂ ca₂jme₃tɨin₂₃ dsa₂ jme₁jmɨg₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","'Ŋio₅ lɨn₃ dsɨ₂gó'₃ dsɨ́₅ dsa₂ quian'₅₄ jág₁ quió'₅, ia₁ a₂'io₂₃ 'éi'₃ dsón'₂ bá₄ a₂jme₂tag₂₃. ");
INSERT INTO cntNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dsi₂néi₂ guá'₅ sinagoga ja₁tioin'₅₄ jaun₂, jme₁'en₅₄ jan₂ dsa₂ i₂'en₅₄ jme₂dsí₂ je₂na'₅₄ të₂dsɨ́₅. Jaun₂ ca₂guió'₃ 'éi₂, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡'Ne₂ në́₃! ¿'E₂ lë₃ tiáng'₅ jë₄ quián₂ jnia'₅₄, 'ne₂ Jesús Nazareno? ¿A₂i₃'éin'₃ jnia'₅₄ bá₄ 'ne₂ ŋe'₃? Guion₄ jniá₂ 'ein₂ lɨ́ng'₅: 'ne₂ lɨ́ng'₅ I₂jŋió₅ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jaun₂ ca₂jí₂ Jesús, ca₂juá'₂: ―¡Tei₄ jmo₄; tén₃ dsa₂ në₅! Jaun₂ je₂na'₅₄ në́₃, ca₂tón₂ 'uë₃ të₃ jág₅ ca₂le₃jɨ́n₃, jaun₂ guë́₄ ca₂o₃'ɨ́in₃, la₁ tsá₃ 'e₂ uɨg₅ ca₂jmóg'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jaun₂ ca₂ja₃gó'₃ dsɨ́₅ ca₂le₃jɨ́n₃, jaun₂ ca₂dsia₃ jág₁ jɨn₄ rɨin'₅₄, ca₂juá'₂: ―¿'E₂ bá₄ jág₁ në₅? I₂në₅ 'io₂₃ bí₂ jmo₂₃ 'éi'₃ lia'₂ ma₂'uɨn₂ bá₄ jme₂dsí₂ 'lɨn'₅₄ jë₁ma₂ca₂juá'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A₂jaun₂ në́₃, ca₂i₃'ag₅₄ jág₁ le₂con₂ juɨg₂ te₁'i₁ ma₂quián₅ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A₂ca₂o₃'ɨ́n₃ Jesús guá'₅ sinagoga jaun₂, ca₂ŋó₃ ja₁quió'₄ Si₂mu₅₄. Ja₁jaun₂ jme₁rë₂quian₅ ma₂chog₅₄ 'éi₂ dso'₅₄ 'i₄ dséi₂ 'ŋio₅ lɨn₃. Jaun₂ ca₂mɨ₃ dsa₂ ne₅₄ o₄quió'₄ dsa₂ dso'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jaun₂ ca₂jme₃quiáin₃ cau₅ quió'₅ dsa₂ dso'₅₄, ca₂jéin₂ dso₄ dséi₂. Jaun₂ ca₂o₃'ág₃ dséi₂. Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂nau₂ dsa₂ i₂jme₁dso'₅₄, ca₂jme₃ti₃ ne₄ dsa₂ i₂tion'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Të₂le₃ ca₂nei₂ jmɨg₄ jaun₂, ca₂le₃jɨ́n₃ dsa₂ i₂chan₂ dsa₂ dso'₅₄ quián₅ juɨ₁'e₂ guë́₃ dso₄ lɨ́in₅, ca₂o₃jiog₃ dsa₂ ne₅₄. Jaun₂ qui₂ca₂téin₂ gu₂ le₂jan₂ le₂jan₂ dsa₂ dso'₅₄, ca₂jme₃'lió₂. ");
INSERT INTO cntNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Juɨn₅ bá₄ jme₂dsí₂ je₂na'₅₄ qui₂ca₂'uɨ́in'₂ quió'₅ dsa₂, qui₂guió'₅ juá'₂: ―¡'Ne₂ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄! La₁ Jesús në́₃, ca₂jí₂ bá₄, tsá₃ ca₂cuë₃ jmɨg₄ jua'₅₄ a₂juá'₂ guë́₄, ia₁ a₂ŋi₅ rë₂ bá₄ je₂na'₅₄ a₂lɨ́n₅ 'éi₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jme₁jnia₃ jaun₂, ca₂o₃'ɨ́n₃ Jesús ŋó₃ caun₂ ja₁lë́₄ co₂'ŋiog₅. La₁ ca₂le₃jɨ́n₃ dsa₂ ca₂i₁nioi₁₂ ca₂'nau'₂. Jaun₂ në́₃ jme₁ca₂dsáu'₂, jme₁jnéi₂ juɨ₅ tsá₃ jme₁cuë₂₃ jmɨg₄ dsáin'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jaun₂ ca₂juá'₂ Jesús: ―Ca₂tɨ́n₂ jniá₂ qui₂i₁'ë́₃ jág₁ juɨ₁lia'₂ ja₁gon₂ Diú₄, le₂tan₅₄ juɨg₂ ja₁siá'₂, ia₁ ta₁ në₅ chen₄ bá₄ jniá₂ guio₃. ");
INSERT INTO cntNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jaun₂ le₂në₅ bá₄ ca₂ŋɨ₃ Jesús ca₂'ë́₂ jág₁ le₂con₂ guá'₅ sinagogas a₂te₁'i₁ ja₁tén₄ Judea. ");
INSERT INTO cntNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ca₂lë₃ co₂ráun₂ jme₁'en₅₄ Jesús chei'₅₄ Jmɨ₁ŋí'₄ Genesaret. Të₃jë₄ jaun₂ ca₂ŋɨ'₂ juɨn₅ lɨn₃ dsa₂, ca₂lia'₂ co₂'liog'₂ bá₄ tioin'₅₄, ia₁ 'nio₃ nag₃ jág₁ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jaun₂ ca₂jág₃ Jesús tɨn₃ tsɨ₁mu₅ a₂le₁jë₁, le₁'ág₄ chei'₅₄ jmɨg₂, ia₁ dsa₂ i₂tsán'₂ ju₄ jme₁ma₂sióin₃ i₂ráng₃ 'má₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jaun₂ ca₂'í₃ Jesús caun₂ tsɨ₁mu₅ jaun₂, a₂lë́₅ quió'₅ Si₂mu₅₄. Jaun₂ ca₂mɨ₃ a₂jiog₃ 'éi₂ ca₂juɨg₄ guë́₄ le₃ne₄ jmɨg₂. Jaun₂ ca₂guá₂ 'ŋió'₃ tsɨ₁mu₅, jaun₂ ja₁jaun₂ ca₂jme₃lióg₃ ca₂jme₃tɨin₂₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jme₁ca₂dsan₃ cuë₂₃ jág₁, ca₂tsɨ́'₃ Si₂mu₅₄: ―Jŋiog'₅₄ mu₅ quiáng'₂ le₃ja₁jɨ'₂ guë́₄. Ja₁në₅ tiong₂ 'má₅ quiáng'₂, jaun₂ lén'₂ 'nia'₂ ju₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jaun₂ ca₂ŋag₃ Si₂mu₅₄: ―Të₅, la₂ tio'₅₄ bá₄ jnia'₅₄ ta₁jma₃ nei₅ ca₂néi₃, tsá₃ 'ein₂ já'₂ ma₂lag₅ jnia'₅₄; la₁ i₁tion₃ caun₂ ia₁ a₂juá'₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jme₁ca₂jmo₃ le₂jaun₂, ca₂lia'₂ juɨn₅ lɨn₃ ju₄ i₃ton'₅₄, jŋia'₅₄ mei'₂ tsá₃ ca₂gag₂ bá₄ 'má₅ quió'₅ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jaun₂ ca₂bí₂ gu₂ ca₂të́'₃ rɨin'₅₄ i₂jme₁tion'₅₄ tsɨ₁mu₅ caun₂, ia₁jaun₂ ja₃léin₂ jme₃'o₅₄. Jme₁o₃lén₂ 'éi₂ në́₃, ca₂jme₃cain'₂ ta₁tɨn₃ tsɨ₁mu₅, jŋia'₅₄ mei'₂ tsá₃ ca₂i₃guein'₅₄ bá₄ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jme₁ca₂jág₃ Si₂mu₅₄ në₅, ca₂ŋó₃ ca₂chi₃jné₃ ne₄ Jesús, ca₂juá'₂: ―Jŋia'₃ cau₅ quió₃, Te₁gui'₅₄, ia₁ dsa₂ cha₂ dsáu₁ bá₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ia₁ dsɨ₂gó'₃ dsɨ́₅ Si₂mu₅₄ quian'₅₄ rɨin'₅₄, ia₁ a₂ŋɨ́₄ lë₃ 'ŋio₅ juɨn₅ ju₄ i₂ca₂join₃. ");
INSERT INTO cntNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ján₃ bá₄ le₂jaun₂ Jacobo quian'₅₄ Juan₅₄ i₂lɨ́n₅ ja₁ŋi'₅₄ Zebedeo, ia₁ co₂dsia₅ jme₁i₂nioi₅₄ quian'₅₄ Si₂mu₅₄ tsáin'₂ ju₄. La₁ Jesús në́₃ ca₂juá'₂ ca₂tsɨ́'₃ Si₂mu₅₄: ―Tsá₃ jmo₂ gang'₃. Ia₁ të₂le₃ ne₄ juɨ₅ ja₁dsau₅₄ në₅, ŋɨ́'₁ jmag'₅₄ dsa₂ mɨ₂güɨ́g₃ juɨ₁lia'₂ jmag'₂ ju₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jme₁ma₂në₂jŋióg'₃ tsɨ₁mu₅ quió'₅ le₃ja₁quein₂ chei'₅₄ jmɨg₂, ja₁jaun₂ ca₂dsia₃ jë₂, ca₂i₃léin₂ bá₄ quian'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Co₂ráun₂ jme₁'en₅₄ Jesús caun₂ juɨg₂, jaun₂ ca₂dsióg₃ jan₂ dsa₂ dso'₅₄ i₂lɨ́n₅ 'mé'₅ 'iog₅, ta₁jain₂. Jme₁ca₂jɨ́in₂ Jesús, ca₂tóin₂ të₂rë₃'éin₂ 'uë₃, ca₂mɨ₃ tion₅₄-jan₃, ca₂juá'₂: ―Te₁gui'₅₄, chi₂jua'₂ 'niog'₂, jŋia'₅₄ lia'₂ 'ne₂ bá₄ quɨ'₅₄ jmɨg₄ chi'₅₄ dso₄ a₂lɨ́ng₅. ");
INSERT INTO cntNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jaun₂ ca₂néi'₃ gu₂, ca₂nɨ́'₃ quió'₅ dsa₂ dso'₅₄, ca₂juá'₂: ―'Nio₃ jniá₂. Jmo₅₄ bá₄ le₁jɨ́ng'₃. Dsɨ₂juɨ₅ jme₁ca₂juá'₂ jaun₂, ca₂jŋia'₃ 'mé'₅ 'iog₅ a₂jme₁lɨ́in₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jaun₂ ca₂jmo₃ Jesús 'éi'₃ a₂tsá₃ 'ein₂ tsɨ́'₃ 'i₁jan₂. Jŋia'₅₄ lia'₂ ca₂juá'₂: ―La₁ gua₂ o₂jme₁jnia₅ ne₄ jme₂dsa₂, o₄quió'₄ a₂ma₂le₁jɨ́ng'₃, o₂jmo₄ o₂jen'₅₄ ne₄ Diú₄ con'₂ lë́₅ 'Éi'₃ quió'₅ Moisés, co₂'nió'₄ a₂jang'₅₄ jág₁ dsau₅ jɨn₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","La₁ të₂le₃ lë́₅ guë́₄ ca₂i₃'ag₅₄ bá₄ jág₁ ca₂le₂con₂ a₂'ɨn₅ dsa₂ Jesús. Jaun₂ i₂juɨn₅ lɨn₃ dsa₂ i₂jme₁të₁ja₂lén₂ ŋɨi'₂ ja₂néi₃ jág₁, i₂'nio₃ 'lión₂ në́₃ 'e₂ caun₂ jmɨ₁uɨg₅ chain₂. ");
INSERT INTO cntNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","La₁ jme₁dsɨ₂uɨ́in₃ bá₄ 'nɨ'₂ juɨg₂ ja₁con'₂ 'ŋiog₅, chi₃léin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ca₂lë₃ co₂ráun₂ jme₁'en₅₄ Jesús jme₂tɨin₂₃ dsa₂. Le₂con₂ jaun₂, jme₁tián'₄ i₂lɨn₅₄ dsa₂ fariseos, të₅juá'₅ në́₃, i₂ja₂lén₂ le₂con₂ 'uë₃ Galilea, Judea, juɨg₂ Jerusalén në́₃. Ia₁ juɨ₅bí₂ quió'₅ Te₁gui'₅₄ bá₄ jme₁'io₅ Jesús, a₂jme₂'lióin₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Të₃jë₄ jaun₂, ca₂dsi₃lén₂ dsa₂ le₁jŋiai₂₃ jan₂ dsa₂ 'lian'₂, dsɨ́n₂ ne₄ tsɨ₁jein₁. Jme₁'no'₂ juɨ₅ dsɨ₃toin'₅₄ dsi₂néi₂, jme₁dsɨ₃quio₂₃ ne₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ia₁ tsá₃ ca₂dsó'₂ 'a₂ lia'₂ dsɨ₃toin'₅₄, ia₁ a₂ŋɨ́₄ lë₃ juɨn₅ dsa₂ tion'₅₄, jaun₂ ca₂uɨ́g₂ le₃co'₅₄ tsɨ₁'né₅. Jaun₂ ca₂niá₃ jë₄ gua'₅₄ lag₁, jaun₂ ca₂sió₂ lia'₂ jma₃quian'₅₄ tsɨ₁jein₁, dsi₂jo₂ jaun₂, ne₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jme₁ca₂jág₃ Jesús a₂'én₂ dsa₂ 'éi₂ 'ŋio₅ lɨn₃, jaun₂ ca₂juá'₂: ―'Ne₂ dsa₂, ma₂rë₂'én₄ bá₄ dsáu'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jaun₂ në́₃ ca₂jme₃lióg₃ të₅juá'₅ quian'₅₄ dsa₂ fariseos në́₃ ca₂i₃jŋia₅ dsɨ́₅: “¿I₂'ein₂ bá₄ në₅ jmái'₂ mɨ'₅₄ Diú₄ a₂juá'₂ le₂në₅? 'I₁jan₂ tsá₃ 'ein₂ lé₂ le₃'én₂ dsáu₁ dsa₂, jŋia'₅₄ lia'₂ Diú₄ bá₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","La₁ a₂lí'₄ rë₂ bá₄ Jesús 'e₂ a₂qui₂dsɨ₂jŋia₅ dsɨ́₅ dsa₂ 'éi₂, jaun₂ ca₂juá'₂: ―¿'E₂ bá₄ lë₃ dsɨ₂jiog₅ 'au'₂ 'nia'₂ le₂në₅? ");
INSERT INTO cntNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿'E₂ a₂'ua₁ guë́₄ ta₁, a₂juá'₄ jniá₂ juɨg₅₄ dsa₂ la₂: “Ma₂rë₂'én₄ dsáu'₂”, o₃ a₂juɨg₅₄ 'e₂ jniá₂: “Nau₂, ŋɨ₄”? ");
INSERT INTO cntNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ia₁ dse₃ jaun₂. La₂ jmo₅₄ jniá₂ ia₁jaun₂ le₃ŋi'₅₄ 'nia'₂ a₂'io₅ bí₂ 'éi'₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ ne₄ gua'₅₄ 'uë₃ a₂qui₃'éin₂ dsáu₁ dsa₂. Jaun₂ guë́₄ ca₂tsɨ́'₃ dsa₂ 'lian'₂: ―'Ne₂ juɨ́g₂ jniá₂, nau₂, quion₂ tsɨ₁jein₁ quiáng'₂, guan'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dsɨ₂juɨ₅ jaun₂ të₃ jág₅ ca₂le₃jɨ́n₃, ca₂nau₂ ca₂cáun₃ tsɨ₁jein₁ quió'₅ ca₂ŋái'₃ jme₂juɨin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jaun₂ ca₂i₃gó'₃ dsɨ́₅ ca₂le₃jɨ́n₃, ca₂jme₃juɨin'₂ Diú₄ në́₃. Jaun₂ të₃jë₄ dsɨ₂gó'₃ dsɨ́₅ jaun₂, qui₂ca₂tsɨ́'₃ rɨin'₅₄: ―Jmɨg₄ në₃ ca₂të́₂ ne₄ jniog₄ a₂dsɨ₂gó'₃ dsɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cang₂ jaun₂ ca₂o₃'ɨ́in₃ táng₃. Ja₁ŋó₄ jaun₂, ca₂jɨ́in₂ jan₂ i₂chen₂ Leví i₂cán₂ 'lia'₅₄ a₂ca₂tɨ́n₂ dsɨ₂tan₅₄, guá₅ ja₁dsɨ₂qui₅ dsa₂ 'lia'₅₄. Jaun₂ ca₂juá'₂ Jesús: ―Ŋia₅ chi₁co'₅₄ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ja₁jaun₂ ca₂dsia₃ jë₂, ca₂nau₂ ŋó₃ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ca₂i₁jmo₅₄ Leví caun₂ má₃ pa₁ dsi₂néi₂ quió'₅ o₄quió'₄ Jesús, jaun₂ ca₂ŋɨ'₂ juɨn₅ dsa₂ i₂cán₂ 'lia'₅₄ rɨin'₅₄. Juɨn₅ bá₄ dsa₂ sián'₂ në́₃ qui₂ca₂guë́'₃ quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","La₁ dsa₂ fariseos quian'₅₄ të₅juá'₅ quiáin₅, chi₂ca₂'ɨin₃ dsa₂ i₂ma₂quian'₅₄ Jesús, ca₂juá'₂: ―¿'E₂ lë₃ qui₂quë́'₂ qui₂'ág'₂ 'nia'₂ co₂dsia₅ quian'₅₄ dsa₂ i₂cán₂ 'lia'₅₄ në₅, dsa₂ i₂le₁cán'₄ dso₄ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jaun₂ ca₂ŋag₃ Jesús: ―Ma₁ tsá₃ të₅mɨ́₅ 'nió'₅ quió'₅ dsa₂ i₂le₁'ág₄ dse₃ dsɨ́₅; dsa₂ i₂le₁dso'₅₄ bá₄ 'nió'₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tsá₃ ta₁ jaun₂ guio₃ jniá₂ a₂të́₄ dsa₂ dsen₃; a₂të́₄ dsa₂ i₂le₁cán'₄ dso₄ bá₄ jniá₂ guio₃, ia₁jaun₂ dsi₁quén'₅ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jaun₂ dsa₂ 'éi₂ në́₃ ca₂tsɨ́'₃ Jesús: ―¿'A₂ guë'₂ lia'₂ i₂gú'₃ jme₂'ɨn₅₄ dsa₂ i₂quian'₅₄ Juan₅₄, jë₂ qui₂tsɨ́'₅ Diú₄, le₂jaun₂ bá₄ dsa₂ quián₅ fariseos në́₃, la₁ dsa₂ quiáng'₂, guë́'₅ 'ɨ́n'₂ bá₄? ");
INSERT INTO cntNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jaun₂ ca₂jéin'₃ Jesús jág₁: ―¿Lé₂ le₃chi₁quian'₄ 'nia'₂ jmɨg₄ jme₃'ɨn₅₄ juɨ₁lia'₂ dsa₂ i₂té₄ ja₁jen'₂ gu₂ dsa₂, chi₂jua'₂ jaun₂ bá₄ guá₅ guë'₂ dsa₂ ŋe'₂ i₂jen'₂ gu₂? ");
INSERT INTO cntNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","La₁ já₅ jmɨg₄ jë₁ma₂jŋia'₃ dsa₂ ŋe'₂ 'éi₂; jmɨg₄ jaun₂ guë́₄ ma₂lé₂ jme₃'ɨin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ján₃ bá₄ ca₂juá'₂ Jesús jág₁ jáng'₅ léi₄ la₂: ―Ma₁ tsá₃ 'ein₂ dsa₂ tióng₅ 'nau₅₄ 'mɨ'₂ 'mɨ́₂ tsɨ₁'mɨ'₂ gui'₅₄. Ia₁ në₁jua'₂ ca₂jmo₃ le₂jaun₂, a₂jŋia'₅₄ guéi₃ bá₄ caun₂ caun₂, ton'₂ tsá₃ ma₃rë₂ quɨn₅ tsɨ₁'mɨ'₂ gui'₅₄ quian'₅₄ 'nau₅₄ 'mɨ́₂. ");
INSERT INTO cntNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ján₃ guë'₂ tsá₃ tia'₂ dsa₂ vino 'mɨ́₂ nɨ₁lau₂ gui'₅₄, ia₁ në₁jua'₂ ca₂jmo₃ dsa₂ le₂jaun₂, a₂ne'₂ bá₄ nɨ₁lau₂ gui'₅₄ quian'₅₄ dsió'₁ vino 'mɨ́₂; téin₃ bá₄ vino, ton'₂ dsɨ₃'én₂ nɨ₁lau₂ gui'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jaun₂ lë₃, lau₂ 'mɨ́₂ bá₄ 'nió'₅ tia'₃ dsa₂ vino 'mɨ́₂, ia₁jaun₂ rë₂ lé₂ 'í₁ le₃tɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ i₂ma₂'ɨn'₅ vino gui'₅₄ a₂ma₂ron₂, tsá₃ jiá₃ dsɨ́₅ 'ɨ́n'₂ vino 'mɨ́₂ a₂të₂ca₂jlen'₃. “Ia₁ tió'₅ a₂gui'₅₄” bá₄ juá'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Caun₂ jmɨg₄ sa₅₄, ca₂ŋɨ₅ Jesús caun₂ ja₁nau₂ ja₁jnia₄ trigo. Jaun₂ ca₂gág₃ dsa₂ i₂quiain'₅₄ mɨ́'₂ trigo, qui₂ca₂guéin₂ ca₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jaun₂ jme₁ca₂jág₂ i₂lɨn₅₄ dsa₂ fariseos, jaun₂ ca₂juá'₂: ―¿'E₂ lë₃ jmo'₂ 'nia'₂ a₂tsá₃ 'i₄ 'éi'₃ jmo₃ dsa₂ jme₁jmɨg₄ sa₅₄? Jaun₂ ca₂ŋag₃ Jesús: ");
INSERT INTO cntNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","―¿Tsa₁ ma₂'í'₂ 'nia'₂ ja₁juá'₂ a₂ca₂jmo₃ David quiain'₅₄ rɨin'₅₄ jme₁ca₂tá'₂ i₁cón'₅? ");
INSERT INTO cntNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ca₂'í₃ dsi₂néi₂ quió'₅ Diú₄ ca₂can₃ i₁ŋí'₄ jŋió₅ a₂'i₄ 'éi'₃ a₂guë́'₃ jmá'₃ jme₂dsa₂. Ca₂guë́'₃, ca₂cuë́'₃ rɨin'₅₄ i₂jme₁quiain'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ca₂juá'₂ Jesús ján₃: ―Jaun₅ dsa₂ mɨ₂güɨ́g₃ bá₄ i₂quian₅ 'éi'₃ ne₄ quió'₅ jmɨg₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Co₂ráun₂ táng₃ caun₂ jmɨg₄ sa₅₄ ca₂lë₃, ca₂'í₃ Jesús guá'₅ sinagoga, ca₂jme₃tɨin₂₃ dsa₂. Jë₄ jaun₂ jme₁'en₅₄ jan₂ dsa₂ i₂rë₂já'₃ gu₂ ne₁. ");
INSERT INTO cntNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ca₂tiog₃ dsa₂ fariseos quian'₅₄ të₅juá'₅ chi₂jua'₂ jme₃'lióin₂ 'éi₂ të₃ jmɨg₄ sa₅₄, ia₁ jme₁'no'₂ juɨ₅ 'a₂ lia'₂ jmo₃ dsáu₁ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","La₁ a₂ŋi₅ rë₂ bá₄ Jesús 'e₂ a₂dsɨ₂jiog₅ dsɨ́₅ dsa₂ 'éi₂ tióin₂, jaun₂ ca₂tsɨ́'₃ dsa₂ i₂rë₂já'₃ gu₂: ―Nau₂, ŋia₅ dsi₂jo₂ la₂. Ca₂nau₂ bá₄ dsa₂ 'éi₂ ca₂ŋó₃. ");
INSERT INTO cntNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jaun₂ ca₂tsɨ́'₃ Jesús dsa₂ i₂tión₂ jág₅: ―La₂ ŋag₄ jniá₂ caun₂ 'nia'₂: ¿'E₂ 'i₄ 'éi'₃ jmo₃ dsa₂ juɨ₁lia'₂ jme₁jmɨg₄ sa₅₄? ¿A₁dse₃, o₃ a₂'lɨg'₅₄ 'e₂? ¿A₂lióin₂ dsa₂ mɨ₂güɨ́g₃ rɨin'₅₄, o₃ a₂jŋag'₃ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jaun₂ ca₂jɨ́in₂ ca₂le₃jɨ́n₃ dsa₂ i₂tión₂ le₃lág'₃ quió'₅, jaun₂ ca₂tsɨ́'₃ dsa₂ dso'₅₄: ―Nei'₅₄ gog'₂. Jaun₂ ca₂néi'₃. Dsɨ₂juɨ₅ jaun₂ bá₄ ca₂lág₃ gu₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","La₁ ca₂rë₃'né₃ bá₄ dsa₂ jain₂ jain₂ tioin'₅₄, ca₂jme₃lióg₃ ca₂tsɨ́'₃ rɨin'₅₄ 'e₂ jmái'₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ca₂lë₃ të₃jë₄ jmɨg₄ jaun₂, ca₂ŋó₃ Jesús juɨ₅ caun₂ má'₂ a₂chi₂i₁lein'₄ Diú₄. Të₁jma₃nei₅ bá₄ ca₂ŋɨi₅ chi₂léin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Jme₁jnia₃ táng₃ jaun₂, ca₂të́'₃ dsa₂ i₂quiain'₅₄, jaun₂ ca₂quióin'₂ guia₃-tɨ́n₂ 'éi₂. I₂'éi₂ në́₃ ca₂quiain₃, i₂chen₄ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Le₂la₂ jme₁chein₂: Si₂mu₅₄ i₂ca₂quiain₃ Pe₄; Drë́₄ rɨn'₅₄ Si₂mu₅₄; Jacobob quian'₅₄ Juan₅₄ në́₃; Fe₂li₄, Bartolomé, ");
INSERT INTO cntNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Të₅₄, To₁má₄, Jacobo i₂lɨ́n₅ ja₁ŋi'₅₄ Alfeo; Si₂mu₅₄ i₂lɨ́n₅ cananista. ");
INSERT INTO cntNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas rɨn'₅₄ Jacobo; quian'₅₄ Judas Iscariote i₂ca₂dsióg₃ ca₂'nɨi₃ Jesús cang₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jme₁ca₂sióin₃ má'₂ jaun₂, quiain'₅₄ 'éi₂, jaun₂ ca₂nau₂ caun₂ ja₁lë́₄ ja₁jo₂. Ja₁jaun₂ në́₃ jme₁ma₂le₁ŋɨ'₂ juɨn₅ lɨn₃ dsa₂ i₂chan₂ ta₁caun₂ 'uë₃ Judea, i₂ja₂lén₂ Jerusalén, ca₂le₃jë́₃ juɨg₂ te₁'i₁ le₂tan₅₄ chei'₅₄ jmɨ₁ŋí'₄ ja₁niog₅ juɨg₂ Tiro quian'₅₄ Sidón në́₃, ");
INSERT INTO cntNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ia₁ 'nio₃ dsa₂ nag₃ jág₁ quió'₅ Jesús, ton'₂ ia₁ 'nio₃ 'lióin₂ 'e₂ caun₂ dso₄ niog₅ lɨ́in₅. Le₂jaun₂ guë'₂ dsa₂ i₂chan₂ uɨg₅ co₂jmóg'₂ jme₂dsí₂ 'lɨn'₅₄, ja₁jaun₂ qui₂ca₂'lóin₂ bá₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Qui₂ca₂'náu'₃ juɨ₅ a₂nɨ́i'₃ quió'₅ Jesús, ia₁ jme₁'io₅ 'éi₂ bí₂ a₂jme₁jme₂'lióin₂ ca₂le₃jɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jaun₂ ca₂jɨ́in₂ ca₂le₃jɨ́n₃ i₂ma₂quiain'₅₄, jaun₂ ca₂juá'₂: ―'E₂ guë́₄ dsen'₃ 'nia'₂ dsa₂ i₂chang'₂ ŋég'₂ le₃ne₄ Diú₄, ia₁ 'nia'₂ bá₄ ca₂tɨ́ng'₂ ja₁goin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’'E₂ guë́₄ dsen'₃ 'nia'₂ i₂chang'₂ 'ong'₅₄ rë₂në́₃, ia₁ 'ág'₄ bá₄ 'au'₂. Dsen'₃ 'nia'₂ i₂quɨ'₂-'o₅ jmɨg₄ në₃, ia₁ ŋág'₄ bá₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’'E₂ guë́₄ dsen'₃ 'nia'₂ jë₁ma₂ca₂jme₃'iog₅₄ dsa₂, a₂'uág'₂, jë₁ma₂të́₂ rë₁të₃'o'₂, quiong₃ dsa₂ a₂'lɨng'₅₄ o₄quió'₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","'Jmo₄ 'nia'₂ 'io'₂ 'ŋio₅ lɨn₃, quian₂ 'nia'₂ o₂'ŋió₃ 'au'₂ jë₁ma₂të́₂ jmɨg₄ jaun₂, ia₁ le₂në₅ bá₄ guéi'₁ 'nia'₂ juë'₂ 'liang'₅₄ guei'₅₄ i₂juɨ́g₃. Ia₁ le₂në₅ bá₄ ma₂jmo₃ dsa₂ can'₅₄ quiáin₅ ca₃ma₂lɨ́g'₂ ma₂jmái'₂ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’La₁ 'e₂ guë́₄ juɨ́g'₂ 'nia'₂ dsa₂ cha₂ cu₄, ia₁ ma₂gue'₅₄ bá₄ 'nia'₂ liang'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’'E₂ guë́₄ juɨ́g'₂ 'nia'₂ i₂chang'₂ qui₂le₁'ág'₃ 'au'₂, ia₁ já₅ jmɨg₄ jë₁le₃chang'₂ 'ong'₅₄. 'E₂ guë́₄ juɨ́g'₂ 'nia'₂ i₂chan₂ co₂ŋág₂ jmɨg₄ në₃, ia₁ já₅ bá₄ jmɨg₄ jë₁tóng'₁ 'lia'₂ 'au'₂ quɨ'₁-'áu'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Juɨ́g'₂ bá₄ 'nia'₂ jë₁ma₂të́₂ rë₁qui₃'ag₃ dsa₂ dse₃, ia₁ le₂në₅ bá₄ ca₂jmo₃ dsa₂ can'₅₄ quiáin₅, ca₂'ɨin₃ dse₃ dsa₂ juɨ₁gan₂ i₂jme₁'ë́₂ jág₁ ma₂lɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’La₁ 'nia'₂ dsa₂ i₂nag₅, juá'₅ jniá₂: Jme₁'nió₄ 'nia'₂ dsa₂ i₂'iog₅₄, jmo₄ a₂dse₃ ja₁con₂ dsa₂ i₂ja₂uɨn₅₄ dsɨ́₅ jág₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Caun₂ dse₃ bá₄ qui₁'ɨ́ng'₄ i₂'ag₅ 'lɨg'₅₄; chi₁len'₅₄ 'nia'₂ Diú₄ o₄quió'₄ i₂lë₁co₂jmóg'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Chi₂jua'₂ 'ein₂ ca₂jnáu₃ ca₂ton₂ rë₂jog'₂, jein'₅₄ le₃ca₂ton₂ táng₃ o₁jnáu₄; chi₂jua'₂ 'ein₂ ca₂jŋiá'₂ 'mɨ'₂ dsiog₂ quiáng'₂, le₂jiog₅ tsɨ́ng'₂ a₂qui'₅₄ cuë'₅₄ ján₃, o₁quion₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Juɨ₁'ein₂ guë́₃ mɨ₅ 'e₂ mɨ₂₃, cuë'₅₄; chi₂jua'₂ 'e₂ caun₂ a₂jŋiá'₂ quiáng'₂, tsá₃ ma₃mag'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Juɨ₁lia'₂ a₂'niog'₂ 'nia'₂ jmo₃ dsa₂ ja₁cong'₂, le₂jaun₂ jmo₄ 'nia'₂ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ia₁ në₁jua'₂ 'nióg'₃ jmá'₃ lia'₂ dsa₂ i₂'nio₃ 'nia'₂ guiong'₅₄, ¿'e₂ ti₁'mag'₄ ca₂tɨ́ng'₂ në₁jua'₂ le₂jaun₂? Ia₁ ján₃ bá₄ le₂në₅ jmo₅ juɨ₁lia'₂ dsa₂ i₂'no₅ dso₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ia₁ chi₂jua'₂ jmo'₂ 'nia'₂ dse₃ jmá'₃ lia'₂ ne₄ dsa₂ i₂jmo₅ dse₃ ja₁cong'₂, ¿'e₂ ti₁'mag'₄ ca₂tɨ́ng'₂ në₁jua'₂ le₂jaun₂? Ia₁ le₂në₅ bá₄ tion'₅₄ dsa₂ i₂'no₅ dso₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Në₁jua'₂ qui₂dsi'₂ 'nia'₂ jmá'₃ lia'₂ le₃quió'₅ i₂lɨ́n'₂ 'nia'₂ le₃quɨ'₅₄ jmɨg₄ jéin'₃ quiáng'₂, ¿'e₂ ti₁'mag'₄ ca₂tɨ́ng'₂ në₁jua'₂ le₂jaun₂? Ia₁ le₂në₅ bá₄ tion'₅₄ guë'₂ dsa₂ i₂'no₅ dso₄ ján₃, qui₂dsi₂ quió'₅ rɨin'₅₄ jain₂ jain₂, ia₁jaun₂ qui₃gue₃ quió'₅ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","La₁ 'nia'₂ në́₃, jme₁'nió₄ i₂'iog₅₄, jmo₄ a₂dse₃ ja₁coin₂; dsi₄ 'nia'₂ quió'₅, tsá₃ jmo₄ 'nia'₂ jua'₅₄ a₂ŋɨ́₄ 'ɨ₅ 'au'₂ a₂jaun₂. Jaun₂ le₂në₅ bá₄ guéi'₁ 'nia'₂ juë'₂ 'liang'₅₄, ton'₂ léng'₂ chi'₂-guein₂ quián₅ Diú₄ i₂guá₅ guei'₅₄. Ia₁ i₂'ua₁ dsɨ́₅ 'éi₂ ján₃ ja₁con₂ dsa₂ 'lɨn'₅₄, i₂jŋia'₅₄ ti₁'mag'₄ tsá₃ cuë₂₃. ");
INSERT INTO cntNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Juɨ₁len'₅₄ 'nia'₂ dsa₂ ŋéi₂ dsɨ́₅, juɨ₁lia'₂ ŋéi₂ dsɨ́₅ Diú₄ Ŋéi'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Tsá₃ lë₁cáun₂ 'nia'₂ 'í₁ ja₁con₂ rɨ́ng'₂, jaun₂ tsá₃ con₂ Diú₄ 'í₁ ja₁con'₂ 'nia'₂ guiong'₅₄. Tsá₃ 'lián'₅ 'nia'₂ rɨ́ng'₂ jaun₂ tsá₃ 'liog'₃ Diú₄ guion'₅₄ 'nia'₂ ján₃. 'Én₃ 'nia'₂ dsáu₁ rɨ́ng'₂, jaun₂ bá₄ 'én₂ Diú₄ dsáu'₂ 'nia'₂ guiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Qui₂jme₁'on₁ 'nia'₂ rɨ́ng'₂, jaun₂ bá₄ jme₃'o₅₄ Diú₄ 'nia'₂, cuë₃ caun₂ 'éi'₃ tí₅, a₂tó'₅ tiá₂, a₂qui₂rë₂'ŋiá'₄ rë₂ lɨn₃, ca₂lia'₂ tsá₃ ma₃to'₂ ja₁'éi'₄ jmo₃, tó'₃ të₂jmu₂ quián'₂ 'nia'₂. Ia₁ 'éi'₃ jaun₂ bá₄ to'₂ Diú₄ juɨ₁lia'₂ lë́₅ 'éi'₃ a₂dsián'₅ 'nia'₂ rɨ́ng'₂ guiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jaun₂ ca₂cuë₃ Jesús jág₁ jáng'₅ léi₄ la₂: ―¿Lé₂ le₃jŋia₃ dsa₂ ten₄ jan₂ dsa₂ ten₄ rɨin'₅₄ a₂'ë₃ juɨ₅? ¿Tsa₁ tsɨ₃séin'₂ jua'₅₄ juɨ₁lia'₂ caun₂ siá₅? ");
INSERT INTO cntNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","'I₁jan₂ juɨ₁lia'₂ i₂'ɨ₅ si₂ tsá₃ lɨ́in₅ jua'₅₄ a₂juɨin'₂ guë́₄ con'₂ guë́₄ të₅ quiáin₅; ca₂lia'₂ ca₂dsó'₃ si₂ quió'₅, jaun₂ guë́₄ lé₂ le₃dsióg₄ léin₂ con'₂ lɨ́n₅ të₅ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿'A₂ bá₄ lia'₂ jŋiá'₄ 'ne₂ jme₁qui₅ pí'₁ a₂'i₄ jme₁ne₁ rɨ́ng'₂, ton'₂ tsá₃ leng'₅₄ a₂'i₄ nɨ₁'ma₂ chá₅ jme₁ne'₄ 'ŋiag'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿'A₂ bá₄ lia'₂ tiá₂ 'au'₂ juɨg'₅₄ rɨ́ng'₂: “Rɨn'₅₄ jniog₄, cuë₄ jmɨg₄ o₁dsi₁₂ jme₁qui₅ pí'₁ a₂'i₄ jme₁ne'₄”? ¡'Ne₂ dsa₂ i₂lë₁jmo₅-dsáu₅ o₁ne₁! Dsi₄ de'₂ jŋiá₅ nɨ₁'ma₂ chá₅ a₂'i₄ jme₁ne'₄ 'ŋiag'₂, jaun₂ guë́₄ le₃jag'₅₄ rë₂ dsí'₁ qui₅ pí'₁ a₂'i₄ jme₁ne₁ rɨ́ng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Tsá₃ cha₂ nɨ₁'ma₂ dse₃ jua'₅₄ a₂lé₂ le₃'ag₃ mɨ́g₂ 'lɨg'₅₄; ján₃ guë'₂ le₂jaun₂ tsá₃ cha₂ nɨ₁'ma₂ 'lɨg'₅₄ jua'₅₄ lé₂ le₃'ag₃ mɨ́g₂ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Le₂caun₂ le₂caun₂ bá₄ nɨ₁'ma₂ jau'₂ 'í₁ të₂le₃ 'a₂ lia'₂ lë́₅ mɨ́g₂ a₂'ag₅: ma₁ tsá₃ quɨn₅ dsa₂ mɨ́g₂ higos juɨ₁lia'₂ nɨ₁'ma₂ taun₅ chei₅₄, on₃ guë'₂ lé₂ le₃cág'₃ dsa₂ mɨ́g₂ uvas juɨ₁lia'₂ chi₁uɨ́ng₃ taun₅. ");
INSERT INTO cntNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ján₃ bá₄ le₂në₅ dsa₂ në́₃. Juɨ₁lia'₂ dsa₂ dsen₃, lia'₂ con'₂ lë́₅ a₂dse₃ a₂ma₂rë₂'ma₄ të₂dsɨ́₅, jmo₂₃ a₂dse₃; dsa₂ i₂'lɨn'₅₄ në́₃, lia'₂ con'₂ lë́₅ a₂'lɨg'₅₄ a₂ma₂rë₂'ma₄ të₂dsɨ́₅, jmo₂₃ a₂'lɨg'₅₄. Ia₁ lia'₂ con'₂ lë́₅ a₂'lióng₂ ŋag₅₄ cha₂ të₂dsɨ́₅ dsa₂, a₂jaun₂ bá₄ 'uë₂ mɨ₂'o₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿'E₂ bá₄ lë₃ të́'₅ 'nia'₂ jniá₂, “Te₁gui'₅₄, Te₁gui'₅₄”, ton'₂ tsá₃ jmo'₂ guë'₂ 'nia'₂ a₂juá'₅? ");
INSERT INTO cntNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Le₂jan₂ le₂jan₂ i₂të₁ja₂lén₂ ne₃, i₂ja₂néi₃ jág₁ quió₃, ton'₂ ne'₅₄ në́₃, la₂ 'ɨ́in₄ 'a₂ lia'₂ lɨ́in₅: ");
INSERT INTO cntNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","lɨ́in₅ juɨ₁lia'₂ jan₂ dsa₂ i₂ca₂jmóg'₃ 'né₅, ca₂guéi₃ 'ei₄ de'₂ jŋiá₅ ca₂lia'₂ ca₂të́₂ ne₄ nɨ₁'lau₂. Ne₄ jaun₂ ca₂jme₃lióg₃ 'uɨg₅₄ 'ia'₂. Jme₁ca₂juë'₂ jmɨg₂, ca₂dság'₃ jmɨg₂ tiá₂ 'ei₅ dso'₂ tsɨ₁'né₅ jaun₂. La₁ ca₂lia'₂ jŋia'₅₄ tsá₃ ca₂'ŋiá'₂, ia₁ rë₂ jme₁lë́₄. ");
INSERT INTO cntNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","La₁ juɨ₁lia'₂ i₂nag₅ jág₁ quió₃, ton'₂ tsá₃ nei'₅₄ guë'₂ në́₃, lɨ́in₅ juɨ₁lia'₂ lɨ́n₅ dsa₂ i₂ca₂chi'₃ 'ne₄ jŋia'₅₄ dsɨ́₂ ne₄ 'uë₃ bá₄, tsá₃ 'uɨg₅₄ 'ia'₂ ca₂jmo₃. Jme₁ca₂dság'₃ tiá₂ 'ei₅ jmɨg₂ dso'₂ tsɨ₁'né₅ jaun₂, ca₂quɨ'₃ bá₄, co₂ŋei'₅₄ ca₂'en₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jme₁ca₂dsan₃ cuë₂₃ jág₁ le₂në₅, ca₂le₃jɨ́n₃ bá₄ dsa₂ qui₂ca₂nág₂, jaun₂ ca₂ŋó₃ juɨ₅ juɨg₂ Capernaum. ");
INSERT INTO cntNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ja₁jaun₂ jme₁guá₄ jan₂ juɨg₅₄ 'lióg₂ romano i₂jme₁'ŋio₅ jan₂ dsa₂ i₂jme₁jme₂ti₃ ne₅₄, i₂jme₁'nioi₃ lɨn₃. 'Éi₂ në́₃ jme₁dso'₅₄ jme₁ma₂rë₂quiain₂₃ jóin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jme₁ca₂rë₃ŋi₅ juɨg₅₄ 'lióg₂ a₂'ɨn₅ dsa₂ Jesús, jaun₂ ca₂chein₃ jan₂-on₃ dsa₂ can'₅₄ quián₅ dsa₂ judíos a₂i₃léin₂ a₂i₁mɨ₂ ne₄ Jesús a₂jiá₃ jme₃'lióin₂ dsa₂ mozo quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jme₁dsi₃léin₂ ja₁'en₅₄ Jesús, ca₂mɨ₃ tion₅₄-jan₃, ca₂juá'₂: ―Ca₂tɨ́n₂ bá₄ gui'₅₄ juɨg₅₄ 'lióg₂ 'éi₂ a₂jme₁'oin'₄, ");
INSERT INTO cntNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ia₁ 'ŋio₅ lɨn₃ bá₄ 'nioi₃ dsa₂ juɨg₂ go₄ jniog₄. Ia₁ 'éi₂ bá₄ ca₂jmo₃ 'éi'₃ a₂ca₂lág₃ guá'₅ sinagoga quián₂ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jaun₂ ca₂ŋó₃ bá₄ guë'₂ Jesús quian'₅₄ 'éi₂. La₁ jme₁ma₂ja₂quián₃ dsi₁léin₂ dsi₂néi₂ jme₁ca₂chen₃ táng₃ gui'₅₄ juɨg₅₄ 'lióg₂ jan₂-on₃ a₂mei₅₄ quiáin₅, a₂quian₅ jág₁ a₂juá'₂: ―Te₁gui'₅₄, tsá₃ cán'₁ ta₁ jua'₅₄ a₂gog'₅₄ të₂ ja₁quió₃, ia₁ tsá₃ ca₂tɨ́ng₂ jua'₅₄ a₂o₁'ú'₃ dsi₂néi₂ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","'Uɨg₅₄ jaun₂ i₂jiog₅ dsɨ₃, ¿i₂'ein₂ bá₄ jniá₂ jua'₅₄ nei₅₄ 'ŋió₃ të₂ ja₁cong'₂? La₁ tió'₅ jua'₅₄ ca₂jon₄ bá₄ jág₁ quiáng'₂ të₂në₅, ia₁jaun₂ jŋia₃ dso'₅₄ mozo quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ia₁ le₂në₅ bá₄ jniá₂ 'ŋió₃ chéng'₅ jme₂ti₅₄ ne₄ juɨg₃, ján₃ bá₄ niog₅ gu₃ 'lióg₂ i₂te₁neg'₄. Në₁jua'₂ ca₂juɨ́g₂ jniá₂, “Gua₂ jó₄”, ja₁jaun₂ dsó₃ bá₄; në₁jua'₂ ca₂juɨ́g₂ “Ŋia₅ ja₁lá₃”, jiá₃ bá₄. Ján₃ guë'₂ le₂jaun₂ në₁ca₂juɨ́g₂ “O₂jmo₄ a₂la₂ a₂ó₃”, a₂jaun₂ dsɨ₃jmó₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jme₁ca₂nág₂ Jesús jág₁ në₅, ca₂i₃gó'₃ dsɨ́₅ o₄quió'₄ dsa₂ 'éi₂, jaun₂ ca₂jéin'₃ ca₂jɨ́in₂ dsa₂ i₂quiain'₅₄, jaun₂ ca₂juá'₂: ―Të₃dsón'₂ bá₄, ca₂lia'₂ 'i₁jan₂ dsa₂ chan₂ Israel tsá₃ ma₂ca₂dsán'₂ jniá₂ i₂'én₂ lia'₂ 'én₂ dsa₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jme₁ca₂dsi₃len₃ dsa₂ i₂chen₄ 'éi₂ dsi₂néi₂, ma₂ca₂'lón₂ bá₄ dsa₂ mozo i₂jme₁dso'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Cang₂ jaun₂ ca₂ŋó₃ táng₃ Jesús caun₂ juɨg₂ ja₁chei₂ Nain, jaun₂ ca₂jme₃quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, i₃léin₂ quian'₅₄ juɨn₅ guë́₄ dsa₂ sián'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jme₁ja₂quián₃ dsióg₄ ja₁dsɨ₂ton'₅₄ dsa₂ o₄'né₄ juɨg₂, ca₂jág₃ ca₂'uɨn₂ dsa₂ i₃'óin₃ jan₂ 'lag₄, i₂jan₂ tan₅₄ 'éi₂ ja₁ŋi'₅₄ jan₂ 'io₅₄ 'nág₂. Juɨn₅ lɨn₃ bá₄ dsa₂ juɨg₂ i₂jme₁quiong'₅₄ i₃'o₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ca₂tá'₂ ŋéi₂ dsɨ́₅ Te₁gui'₅₄ jme₁ca₂jág₂, jaun₂ ca₂juá'₂: ―Tsá₃ 'au₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jaun₂ ca₂jme₃quiáin₃ ca₂nɨ́i'₃ tsɨ₁gu₅. Ca₂jŋia₃ bá₄ guë'₂ dsa₂ i₂jme₁le₁te₂, jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ 'lag₄: ―¡'Ne₂ juɨ́g₂ jniá₂ chi'₂, nau₂! ");
INSERT INTO cntNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jaun₂ në́₃ ca₂guá₂ 'lag₄, ca₂jme₃lióg₃ ca₂dsia₃ jág₁, jaun₂ ca₂jáng'₂ Jesús ne₄ chog₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jme₁ca₂të́₂ ne₄ dsa₂ a₂ca₂lë₃ jaun₂, ca₂i₃gó'₃ dsɨ́₅ ca₂le₃jɨ́in₃, jaun₂ ca₂jme₃juɨin'₂ Diú₄, ca₂juá'₂: ―Ma₂ca₂rë₃jniá₂ jan₂ dsa₂ juɨn'₂ i₂'ë́₂ jág₁ quián₅ Diú₄ jë₄ quián₂ jniog₄. Juá'₂ në́₃: ―Ma₂guan₅ Diú₄ a₂jme₃'oin₅₄ dsa₂ juɨg₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Le₂con₂ ja₁tén₄ 'uë₃ Judea, le₂con₂ ma₂quián₅ jaun₂ në́₃, qui₂ca₂rë₃ŋi₅ dsa₂ a₂ca₂jmo₃ Jesús jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ca₂rë₃ŋi₅ Juan₅₄ ca₂le₃jë́₃ a₂jaun₂, ia₁ ca₂dsia₃ dsa₂ i₂jme₁quiain'₅₄. Jaun₂ ca₂të́'₃ on₃ dsa₂ 'éi₂, ");
INSERT INTO cntNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","jaun₂ ca₂chei₃ ne₄ Te₁gui'₅₄ a₂dsɨ₃ŋag₅₄ chi₂jua'₂ të₃dsón'₂ lɨ́in₅ dsa₂ i₂lë́₅ jág₁ jiá₃, o₃ jŋiai₃ i₂sián'₂ 'e₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jaun₂ dsa₂ 'éi₂ në́₃, ca₂jme₃quiáin₃ con₂ Jesús jaun₂ ca₂juá'₂: ―Juan₅₄ i₂chon₅ dsa₂ jmɨg₂ në₂chei₃ jnia'₅₄ a₂ŋag₄ 'ne₂ chi₂jua'₂ të₃dsón'₂ lɨ́ng'₅ i₂lë́₅ jág₁ jiá₃, ¿o₃ jŋia₄ jnia'₅₄ i₂sián'₂ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Të₃jë₄ jaun₂, ca₂jme₃'lión₂ Jesús juɨn₅ lɨn₃ dsa₂ i₂jme₁le₁dso'₅₄, ca₂le₃jë́₃ ne₅₄ jmɨ₁uɨg₅ a₂jme₁le₁quian₅ dsa₂; lia'₂ jme₂dsí₂ 'lɨn'₅₄ në́₃ qui₂ca₂'uɨ́in'₂; qui₂ca₂jmóg'₃ jme₁ne₁ dsa₂ i₂jme₁ten₄. ");
INSERT INTO cntNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jaun₂ guë́₄ ca₂jéin'₃ jág₁ quió'₅ 'éi₂, ca₂juá'₂: ―O₂nó'₅ 'nia'₂ o₂dsia₄ o₂chei'₅₄ Juan₅₄ 'e₂ ca₂të́₂ ne'₅₄, 'e₂ a₂qui₂në₂nei'₂ në́₃. Qui₂jág₅ juɨ₁lia'₂ dsa₂ ten₄; të₁i₂nio₄ táng₃ dsa₂ i₂tsá₃ lé₂ jme₁i₂nio₄; të₂tsɨn'₅₄ le₁jɨ́n₃ i₂jme₁lɨ́n₄ 'mé'₅ 'iog₅; qui₂nag₅ táng₃ dsa₂ i₂jme₁guɨn₄ në́₃; le₂jaun₂ guë'₂ 'lag₄ në́₃ qui₂jein'₅₄ táng₃; ja₁con₂ dsa₂ dsɨ₂ŋé₂ dsɨ₂'ag₅ jág₁ dse₃ a₂lión₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","'E₂ guë́₄ dsen₃ dsa₂ i₂tsá₃ 'ag₅ caun₂-tɨn₃ dsɨ́₅ o₄quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jme₁ma₂i₂len₃ dsa₂ i₂ca₂chen₃ Juan₅₄ 'éi₂, jaun₂ ca₂jme₃lióg₃ Jesús ca₂tsɨ́'₃ dsa₂ a₂'ɨin₂₃ Juan₅₄, ca₂juá'₂: ―¿'E₂ ca₂i₁jag'₄ 'nia'₂ lia'₂ con'₂ i₁nóg'₄ 'uë₃ quein₂ co₂'ŋiog₅ jaun₂? ¿O₃ bá₄ ca₂jag'₅₄ 'nia'₂ ca₂'nau₂ nɨ₁'ma₂ ta₅ a₂lë₁qui₂bí₂ dsí₂ ja₁jaun₂? ");
INSERT INTO cntNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Chi₂jua'₂ on₃ jaun₂, ¿'e₂ guë'₂ ca₂i₁jag'₄ 'nia'₂? ¿O₃ bá₄ ca₂jɨng'₅₄ jan₂ dsa₂ i₂qui'₂ tsɨn'₅₄ jlá'₁ 'e₂? La₁ on₃ le₂jaun₂. Ia₁ ŋi'₅₄ bá₄ 'nia'₂, ca₂le₃jɨ́n₃ dsa₂ i₂të₁i₂nio₄ jlán'₁ i₂qui₂cuë́'₅ o₂'ŋió₃ o₂jŋia₃ dsɨ₅, i₂tion'₅₄ juɨ₁lia'₂ dsi₂néi₂ quió'₅ rag₅₄ bá₄ i₂le₂'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Jaun₂ në́₃, ¿'e₂ guë'₂ ca₂i₁jag'₄ 'nia'₂? ¿O₃ bá₄ jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄ 'e₂ ca₂jɨn'₅₄ 'nia'₂? Dsón'₂ bá₄ jaun₂. Jan₂ i₂lɨ́n₅ i₂juɨn'₂ guë́₄ lia'₂ con'₂ guë́₄ jan₂ i₂'ë́₂ jág₁ quián₅ Diú₄ bá₄ ca₂i₁jɨn'₄ 'nia'₂, juá'₅ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan₅₄ bá₄ 'éi₂ i₂'ɨn₅ Si₂ quió'₅ Diú₄ ja₁juá'₂: Tsɨng₅₄ jan₂ dsa₂ quiáng₃ ne₄ juɨ₅ quiáng'₂, jón₃, a₂dsɨ₃can₅ jág₁, jmo₃ co₂jŋia₅₄ juɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Juá'₅ jniá₂ juɨ́g₂ 'nia'₂, ca₂lia'₂ 'i₁jan₂ dsa₂ tsá₃ ma₂ca₂rë₃chán₃ i₂juɨn'₂ guë́₄ lia'₂ con'₂ guë́₄ Juan₅₄. La₁, i₂lɨ́n₅ i₂me'₂ guë́₄ ja₁gon₂ Diú₄, i₂'éi₂ lɨ́n₅ i₂juɨn'₂ guë́₄ lia'₂ con'₂ guë́₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Ca₂le₃jɨ́n₃ dsa₂ i₂ca₂nág₂, lia'₂ dsa₂ i₂cán₂ 'lia'₅₄ në́₃, jme₁ca₂jŋói₂ jmɨg₂ ca₂cho₃ Juan₅₄, le₂në₅ bá₄ ca₂jme₃jniai₂₃, Diú₄ bá₄ i₂lɨ́n₅ i₂qui₂dsɨ₅ 'éi'₃ tí₅. ");
INSERT INTO cntNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","La₁ dsa₂ fariseos quian'₅₄ të₅juá'₅ në́₃, tsá₃ ca₂gue₃ cho₃ Juan₅₄ jmɨg₂; le₂në₅ bá₄ a₂ca₂rë₃jniái₂ ján₃ a₂tsá₃ ji'₅₄ a₂jme₁'nio₃ Diú₄ jmo₃ quiong'₅₄.) ");
INSERT INTO cntNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","―¿'A₂ lia'₂ le₃jua'₅₄ lɨ́n₅ dsa₂ i₂chan₂ jmɨg₄ në₃? ¿'E₂ bá₄ quian'₅₄ le₃quɨ́ng₄ lɨ́in₅? ");
INSERT INTO cntNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lɨ́in₅ juɨ₁lia'₂ lɨ́n₅ i₂bë'₅₄ i₂tón'₅ qui₂guió'₅ jmái'₂ rɨin'₅₄ jë₄ 'ma'₅₄, juá'₂: Në₂jéi₄ jnia'₅₄ te₁fi₁ o₄quián'₂ 'nia'₂, la₁ tsá₃ në₂dsián'₃ 'nia'₂; ján₃ guë'₂ në₂jmó₁ jnia'₅₄ son₅₄ quió'₅ 'lag₄ la₁ tsá₃ ca₂tá'₂ guë'₂ 'lia'₂ 'au'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","'Ia₁ ca₂guan₃ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂, i₂tsá₃ jme₁guë́'₅ i₁ŋí'₄, on₃ guë'₂ vino jme₁'ɨ́n'₂ në́₃, ca₂'ɨin'₅₄ 'nia'₂ a₂'ein₅₄ jme₂dsí₂ je₂na'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ca₂guan₃ guë'₂ táng₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ i₂tɨn₂ guë́'₅, 'ɨ́n'₂ në́₃; la₁ 'nia'₂ juá'₂ 'ɨ́in'₅ a₂lɨ́in₅ jlé₂ 'í₅, má₄ jmɨ́g₃ në́₃, a₂lɨ́in₅ a₂mei₅₄ quián₅ dsa₂ cha₂ dsáu₁, quian'₅₄ dsa₂ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Rë₂jniá₂ bá₄ a₂ŋɨ́₄ lë₃ ŋɨ́'₂ dsɨ́₅ Diú₄, a₂tɨin₂, të₂le₃ quian'₅₄ 'a₂ lia'₂ lë́₅ jmo₅ chi'₂-guein₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jaun₂ ca₂të₃ jan₂ dsa₂ fariseo ca₂të́'₃ Jesús a₂i₁guë'₂ dsi₂néi₂ quió'₅. Ca₂'í₃ bá₄ guë'₂ Jesús dsi₂néi₂ quió'₅ dsa₂ fariseo 'éi₂ jme₁dsióg₃, jaun₂ ca₂guá₂ ne₄ mesa. ");
INSERT INTO cntNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Të₃jë₄ jaun₂, ca₂dsióg₃ jan₂ 'io₅₄ i₂'no₅ dso₄ i₂jme₁ŋɨ₅ juɨg₂ jaun₂, ia₁ jme₁ca₂rë₃ŋi₅ a₂'en₅₄ Jesús guë́'₅ dsi₂néi₂ quió'₅ dsa₂ fariseo 'éi₂. Jaun₂ ca₂dsióg₃ quian₅ caun₂ nɨ₁tsɨ́₅ pí'₁ jlá'₁ a₂lë́₅ quian'₅₄ alabastro, a₂'a₄ no'₅₄ mɨ₂juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ca₂guá₂ 'o₂₃ cau₅ ja₁tióng₂ tag₄ Jesús, ca₂jme₃lióg₃ 'ág₂ jmɨg₂ 'ei₅ jme₁ne₁₂ co'₅₄ tag₄ 'éi₂. Jaun₂ ca₂jme₃quéin₃ táng₃ quian'₅₄ jŋi₂ dsi₅₄, jaun₂ ca₂chen'₃, jaun₂ ca₂tsáng₂ no'₅₄ mɨ₂juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jme₁ca₂jág₃ dsa₂ fariseo i₂quió'₅ dsi₂néi₂, ca₂i₃jiog₅ dsɨ́₅: “Jua'₅₄ mei'₂ guë́₃ të₃dsón'₂ dsa₂ në₅ lɨ́in₅ jan₂ i₂'ë́₂ jág₁ quián₅ Diú₄, jme₁le₃lí'₄ 'a₂ lia'₂ lɨ́n₅ dsa₂ i₂nɨ́'₅ quió'₅. Ia₁ jan₂ 'io₅₄ i₂'no₅ dso₄ bá₄ në₅.” ");
INSERT INTO cntNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ 'éi₂: ―Si₂mu₅₄, cha₂ caun₂ jág₁ a₂'nio₃ juɨg₅₄ 'ne₂. ―Jua'₅₄ 'ne₂, Të₅ ―ca₂ŋag₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jaun₂ ca₂juá'₂: ―On₃ dsa₂ jme₁le₁rɨ́n₃ cu₄ quió'₅ jan₂ dsa₂ i₂tɨn₂ jme₁dsi₂ cu₄. Jan₂ jme₁rɨn₂ ca₂jau₅₄ mei₅ 'éi'₃ cu₄ denarios, jan₂ guë'₂ jme₁rɨn₂ të₂láu₃-guiá₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ca₂'én₂ bá₄ guë'₂ dsa₂ juɨg₅₄ cu₄ dsáu₁ jë₁le₃oin₃ le₂jaun₂, ia₁ tsá₃ guë'₂ quɨ'₅₄ jmɨg₄ jáng'₃. Jaun₂ tsá₃ ma₃tion₅₄ ca₂mág₃ cú₁. Jaun₂ në́₃, ¿'ein₂ i₂on₃ 'éi₂ i₂'nioi₃ guë́₄? ");
INSERT INTO cntNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ca₂ŋag₃ táng₃ Si₂mu₅₄: ―Dsa₂ i₂jme₁rɨn₂ guë́₄ 'lióng₂, lɨ́n₂ jniá₂. ―Dsau₅ bá₄ le₂në₅ ―ca₂ŋag₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jaun₂ ca₂jɨ́in₂ táng₃ 'io₅₄, ca₂tsɨ́'₃ táng₃ Si₂mu₅₄: ―¿Jɨng'₄ dsa₂ mɨ́₂ la₂? Jme₁në₂'ú₃ dsi₂néi₂ quiáng'₂, tsá₃ jmɨg₂ në₂cuë'₅₄ a₂jŋí₃ tag₃; la₁ 'io₅₄ la₂ në́₃ ma₂në₂rang₃ tag₃ quian'₅₄ jmɨg₂ 'ei₅ jme₁ne₁₂, ton'₂ ma₂në₂chí₃ táng₃ quian'₅₄ jŋi₂ dsi₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ján₃ bá₄ le₂jaun₂, tsá₃ në₂chen'₅₄ quió₃ jme₁guang₁₂. 'Io₅₄ la₂ guë'₂ në́₃, ca₂lia'₂ tsá₃ 'na₂ bá₄ caun₂ chen'₂ tag₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tsá₃ no'₅₄ ma₂në₂'ág'₂ jua'₅₄ a₂ma₂në₂tsáng'₃ dsi₃; la₁ 'io₅₄ la₂ guë'₂ në́₃, ma₂në₂'ág₂ no'₅₄ mɨ₂juɨg₂ tag₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","'Uɨg₅₄ në₅ në́₃ juá'₅ jniá₂ ia₁ a₂ŋɨ́₄ lë₃ 'lióng₂ dso₄ jme₁rë₂cáin'₄, la₁ ma₂rë₂'én₄, a₂jaun₂ bá₄ lë₃ ŋɨ́₄ lë₃ cuë₂₃ léi₄ a₂'nio₃. La₁ juɨ₁lia'₂ dsa₂ i₂ca₂juɨg₄ bá₄ dsáu₁ rë₂'én₄, me'₂ bá₄ cuë₂₃ léi₄ a₂'nio₃. ");
INSERT INTO cntNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jaun₂ guë́₄ ca₂juá'₂ ca₂tsɨ́'₃ 'io₅₄: ―Ca₂le₃jë́₃ bá₄ dsáu'₂ ma₂rë₂'én₄. ");
INSERT INTO cntNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ca₂le₃jɨ́n₃ guë́₄ dsa₂ sián'₂ i₂jme₁tián'₄ ne₄ mesa quiain'₅₄, ca₂dsia₃ tsɨ́'₅ rɨin'₅₄: ―¿I₂'ein₂ bá₄ në₅, ca₂të₂ dsáu₁ dsa₂ qui₂'éin₂? ");
INSERT INTO cntNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","La₁ Jesús në́₃, ca₂tsɨ́'₃ dsa₂ mɨ́₂ 'éi₂: ―Ia₁ a₂'éng'₂, ma₂ca₂lóng'₂ në́₃. Guan'₂ tei₄ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Cang₂ jaun₂, ca₂i₁ŋɨ₂ Jesús le₂tan₅₄ juɨg₂ ca'₅₄, le₂tan₅₄ juɨg₂ pí'₁ në́₃, qui₂i₁jme₁tɨin₂₃ dsa₂ jág₁ dse₃ juɨ₁lia'₂ ja₁gon₂ Diú₄. Jme₁quiain'₅₄ bá₄ chi'₂ dsɨ₂guia₃-tɨ́n₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ján₃ guë'₂ jme₁quiain'₅₄ dsa₂ mɨ́₂ i₂ma₂ca₂'uɨ́in'₂ jme₂dsí₂ 'lɨn'₅₄ quió'₅, i₂ma₂ca₂jme₃'lióin₂ dso₄ a₂jme₁lɨ́in₄ në́₃. Jɨn₄ 'éi₂ jme₁ŋɨ₅ jan₂ i₂chen₂ María i₂të́'₂ Magdalena, i₂ma₂'uɨ́n'₂ Jesús guion₃ je₂na'₅₄ të₂dsɨ́₅; ");
INSERT INTO cntNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ján₃ bá₄ jme₁ŋɨ₅ i₂chen₂ Juana i₂lɨ́n₅ dsa₂ mɨ́₂ quián₅ Cuza, dsa₂ i₂niog₅ ne₄ 'e₂ a₂cha₂ quió'₅ Herodes; ján₃ bá₄ jme₁ŋɨ₅ i₂chen₂ Susana; i₂juɨn₅ bá₄ i₂sián'₂ guë́₄ i₂jme₁i₂nio₄ quiong'₅₄, jme₁jme₂'o₅₄ quian'₅₄ 'e₂ a₂cha₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","'Lióng₂ juɨg₂ ja₁jme₁tón'₅ dsa₂ juɨ₅ dsɨ₂léin₂ dsɨ₂jɨin₅₄ Jesús. Jë₁ma₂le₁ŋɨ'₂ dsa₂ juɨin₅ në́₃, jaun₂ ca₂dsia₃ jág₁ jáng'₅ léi₄ la₂, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Jan₂ dsa₂ ca₂ŋe₄ ja₁nau₂ ca₂i₁séi₄ mɨ́g₂ jon₂. Jme₁ma₂'ein₅₄ séi₂ në́₃, a₂lɨn₅₄ mɨ́g₂ i₂ga'₅₄ le₂'i₄ juɨ₅ qui₂ca₂tsó'₃ dsa₂; i₁tan₅ guë'₂ në́₃ ca₂guë́'₃ ca₂dsio₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ca₂dsio₄ guë'₂ në́₃ ca₂i₃to'₅₄ jë₄ nɨ₁cang₁; jme₁ca₂'ia₂, ca₂rë₃quéin₃ bá₄ ia₁ tsá₃ gua'₅₄ cha₂ jua'₅₄ a₂güɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ca₂dsio₄ guë'₂ ca₂séi'₂ jë₄ nɨ₁taun₅. La₁ nɨ₁taun₅ bá₄ tiá₂ ca₂jo₃ jme₁ca₂'ia₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","La₁ ca₂dsio₄ guë'₂ në́₃ ca₂tɨ́n₂ ja₁dse₃ gua'₅₄; a₂jaun₂ ca₂i₃cón₃, ca₂rau₂ dse₃ lɨn₃, caun₂ 'ŋiá₂-láu₂ mɨ́g₂ lia'₂ ca₂mɨ́g₂ jon₂ a₂ca₂séi₂. Jme₁ma₂lë₅ jme₂tag₂₃ le₂në₅, ca₂juá'₂ tiá₂: ―Chi₂jua'₂ 'ein₂ 'nia'₂ dsi₅₄ rë₂gua₄, nei₂ 'nia'₂ rë₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ 'e₂ bá₄ jein₅ jág₁ a₂cuë₂₃ jaun₂. Jaun₂ ca₂juá'₂ Jesús: ");
INSERT INTO cntNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","―Diú₄ bá₄ jmo₅ a₂rë₂ŋɨ́'₂ 'au'₂ 'nia'₂ jág₁ a₂rë₂'ma₄ quió'₅, 'a₂ lia'₂ lë́₅ ja₁goin₂. La₁ dsa₂ sián'₂ në́₃, juɨ́g₂ jniá₂ të₂le₃ quian'₅₄ jág₁ jáng'₅ léi₄, ia₁jaun₂: I₂në₂jág₃, la₁ tsá₃ le₃lí'₄ 'e₂ në₂jág₃; i₂në₂néi₂ në́₃, la₁ tsá₃ le₃lí'₄ 'e₂ në₂néi₂, on₃ guë'₂ le₃ŋɨ́i'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’A₂la₂ bá₄ jein₅ jág₁ a₂jáng'₅ léi₄: A₂lë́₅ co₂'nió'₄ mɨ́g₂ jon₂, jág₁ dse₃ quió'₅ bá₄ Diú₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Juɨ₁lia'₂ ca₂dsio₄ mɨ́g₂ jon₂ a₂i₃ga'₅₄ le₂'i₄ juɨ₅ guë'₂ në́₃, le₂jaun₂ lɨ́n₅ juɨ₁lia'₂ ca₂dsion₄ dsa₂ i₂nag₅ jág₁ dse₃; la₁ i₂së₃dsen₃ guë'₂ në́₃, ja₂jŋiá'₃ jág₁ dse₃ jme₁ma₂'i₄ dsɨ́₅, ia₁jaun₂ tsá₃ ma₃le₃'éin₂ jua'₅₄ a₂lióin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Co₂'nió'₄ mɨ́g₂ jon₂ a₂i₃to'₅₄ jë₄ nɨ₁cang₁ guë'₂ në́₃, co₂'nió'₄ lɨ́n₅ juɨ₁lia'₂ dsa₂ i₂guen₅ 'ŋio₂ dsɨ́₅ jág₁ dse₃ jë₁ma₂ca₂nág₂. La₁ cang₂ jaun₂ tsá₃ tiá₂ tióin₂; lɨ́in₅ në₂jag₄ bá₄ a₂tsá₃ jmú₄ cha₂ juɨ₅ jme₂dsí₂ quió'₅. Co₂'na₂ bá₄ rë₂'éin₂, ia₁ jë₁ma₂ca₂i₃ŋɨ́i₂ 'e₂ caun₂ juɨ₅bí₂ a₂cáun₂ táu₂, dsɨ₂lein₅ táng₃ le₃ca'₃, tí₂ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Co₂'nió'₄ jon₂ a₂ca₂séi'₂ jë₄ nɨ₁taun₅ guë'₂ në́₃, co₂'nió'₄ lɨ́n₅ juɨ₁lia'₂ dsa₂ i₂nag₅ jág₁, la₁ të₂le₃ ne₄ juɨ₅ ja₁i₂léin₂ jaun₂, të₂ ca₂juɨg₄ bá₄ jme₂gain₂₃ dsɨ́₅ a₂jo₅ bí₂ a₂quian₅ o₂me'₅₄ dsɨ₅, a₂ja₂ dsɨ́₅ le₃cha₂ cu₄ 'lióng₂, a₂'nio₃ cuë́'₅ o₂'ŋió₃ o₂jŋia₃ dsɨ₅; i₂në₅ në́₃ lɨ́in₅ co₂'nió'₄ mɨ́g₂ a₂tsá₃ ma₃lé₂ rón₃. ");
INSERT INTO cntNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","La₁ ca₂dsio₄ mɨ́g₂ jon₂ a₂ca₂séi₂ ja₁dse₃ gua'₅₄, co₂'nió'₄ lɨ́n₅ juɨ₁lia'₂ dsa₂ i₂dse₃ dsɨ́₅ i₂caun₂ ne'₅₄, tsán'₂ tiá₂ jág₁ a₂nag₂₃, caun₂ juɨn'₂ bá₄ dsɨ́₅, 'lióng₂ a₂dse₃ rë₂jniá₂ a₂jmo₂₃ chain₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’'I₁jan₂ dsa₂ tsá₃ guí'₅ si₂ caun₂ nɨ₁tsɨ́₅, jua'₅₄ a₂jlë́₂ o₃ a₂chi'₂ né'₃ tsɨ₁cama 'e₂. A₂'ag₅ guei'₅₄ bá₄ dsa₂ si₂, ia₁jaun₂ jniá₂ quió'₅ i₂dsɨ₂ton'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ján₃ bá₄ le₂jaun₂, 'i₁caun₂ a₂rë₂'ma₄ jlë₅ cha₂ jua'₅₄ a₂lɨ́n₂ dsa₂ a₂tsá₃ le₃jniá₂; tion₅₄ bá₄ rë₂jniá₂. Ján₃ guë'₂ le₂jaun₂ 'i₁caun₂ jág₁ tsá₃ cha₂ jua'₅₄ lɨ́n₂ dsa₂ a₂tsá₃ 'ein₂ le₃ŋi₅: tion₅₄ bá₄ rë₂ŋi₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Quion₂ de'₂ 'nia'₂ 'í₁ rë₂ jaun₂, 'a₂ lia'₂ lë́₅ nag'₂, ia₁ juɨ₁lia'₂ i₂ma₂ŋɨ́'₂, Diú₄ bá₄ jmo₃ a₂le₃ŋɨ́i'₂ guë́₄. La₁ juɨ₁lia'₂ i₂tsá₃ 'nio₃ le₃ŋɨ́'₂ guë'₂ në́₃, ca₂të₂ a₂jme₁ma₂ŋɨ́i'₂, lɨ́in₂, jŋia'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jaun₂ ca₂dsi₃lén₂ chi'₂ rɨn'₅₄ Jesús quian'₅₄ chog₅₄, jme₁'nio₃ jme₁ŋɨ́i₃ ca₂të₂ ja₁'en₅₄ 'éi₂, la₁ tsá₃ lé₂, ia₁ juɨn₅ lɨn₃ dsa₂ tion'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jaun₂ jan₂ dsa₂ sián'₂ bá₄ ca₂ŋag₃ jág₁ ca₂juá'₂: ―Chog'₂ quian'₅₄ chi'₂ rɨ́ng'₂ në₅ tióin₂ ca₁'né₄, 'nio₃ jɨ́in₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jaun₂ ca₂ŋag₃: ―Dsa₂ i₂nag₅ jág₁ quió'₅ Diú₄, ton'₂ jme₂ti₃, 'éi₂ bá₄ lɨ́n₅ cha₃, rɨ́ng'₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Co₂ráun₂ ca₂'í₃ Jesús caun₂ tsɨ₁mu₅, jaun₂ ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Ma₃dsau₅₄ quióng₄ le₃ca₂taun₂. Jaun₂ ca₂i₃léin₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Të₁lia'₂ tioin'₅₄ 'ain₂₃ jmɨ₁ŋí'₄, la₁ 'éi₂ në́₃ ca₂güɨin₂ bá₄. Të₃jë₄ jaun₂ ca₂'ág₂ dsí₂ tiá₂ lɨn₃ ne₄ jmɨg₂. Ca₂rë₃lióg₃ i₃'a₄ jmɨg₂ 'ŋió'₃ tsɨ₁mu₅, ca₂lia'₂ ma₂lé₂ dsɨ₃guein'₅₄ bá₄, go'₂ lɨn₃ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jaun₂ ca₂i₁ŋei₂₃ Jesús, ca₂juá'₂: ―¡Të₅! ¡Të₅! ¡Dsɨ₃'éin₂ jniog₄! Jaun₂ ca₂nau₂ bá₄ guë'₂ Jesús ca₂të₂ ca₂jéin₂ dsí₂, a₂jná'₅ jmɨg₂ në́₃. Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂të₁tsɨ'₅₄ táng₃ tei₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jaun₂ tsɨ́'₅ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―¿'A₂ ŋó₅ a₂'én'₂ 'nia'₂? Ca₂lia'₂ lë₁quian₅ juë́'₅ lɨn₃ bá₄ tioin'₅₄ dsɨ₂gó'₃ dsɨ́₅, dsia₂₃ tsɨ́'₅ rɨin'₅₄: ―¿'Ein₂ bá₄ lɨ́n₅ dsa₂ në₅, tɨin₂ jmo₃ 'éi'₃ tsɨ́'₅ të₂ dsí₂, jmɨg₂ në́₃, ne'₅₄ a₂juá'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jaun₂ guë́₄ ca₂dsi₃léin₂ 'uë₃ Gerasa a₂ron₅ le₃'ŋo'₅₄ jmɨg₂ ja₁ron₅ 'uë₃ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jme₁ca₂o₂'ɨ́n₃ Jesús a₂të₁tsɨin'₅₄ 'uë₃, jaun₂ ca₂jme₃quián₃ jan₂ dsa₂ juɨg₂ jaun₂ cau₅ quió'₅. Dsa₂ 'éi₂ në́₃, lɨ́g'₂ bá₄ qui₂ca₂jo₃ jme₂dsí₂ je₂na'₅₄. Lɨ́g'₂ bá₄ ŋɨ₂₃ tsá₃ ma₃tsɨn'₅₄ quɨ́'₅, on₃ guë'₂ ma₃jua'₅₄ a₂guá₅ dsi₂néi₂; tau₂ 'ŋio₅ quió'₅ 'lag₄ bá₄ jme₁ma₂guá₅. ");
INSERT INTO cntNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jme₁ca₂jɨ́in₂ Jesús, jaun₂ ca₂guió'₃ co₂mɨ'₅₄, ca₂chi₃jné₃ ne₄ 'éi₂, ca₂juá'₂ tiá₂ lɨn₃: ―¿'E₂ bá₄ lë₃ ŋe'₃ i₃tiáng'₃ jë₄ quián'₂ jniá₂, 'ne₂ Jesús Ja₁ŋi'₅₄ Diú₄ i₂guá₅ guei'₅₄ lɨn₃? Mɨ₂₃ jniá₂ ne'₅₄, tsá₃ cuë₂ uɨg₅. ");
INSERT INTO cntNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ca₂juá'₂ le₂në₅ ia₁ jme₁ma₂në₂jmo₃ Jesús 'éi'₃ a₂o₃'ɨn₅ jme₂dsí₂ 'lɨn'₅₄ quió'₅. 'Lióng₂ ráun₂ bá₄ le₂jŋiá₅ jme₁ma₂ca₂jŋau'₃ i₂'lɨn'₅₄. Jaun₂ o₁jŋia'₅₄ ma₂qui₂ma₂'néi₂ dsa₂ mɨ₂gu₂ mɨ₂tag₅₄ quian'₅₄ ŋí₁ cadenas ia₁jaun₂ lé₂ 'í₁, la₁ ca₂le₃jë́₃ bá₄ jme₁gág₅. Jme₁'liog'₂ je₂na'₅₄ a₂jme₁dsɨ₂ŋɨ́₃ uɨ́ng₂ gua'₅₄ quein₂ ja₁co₂'ŋiog₅. ");
INSERT INTO cntNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jaun₂ ca₂ŋag₃ Jesús: ―¿'A₂ bá₄ lia'₂ cheng'₂? Jaun₂ ca₂ŋag₃: ―Juɨn₅ bá₄ cheng₂. Le₂në₅ ca₂juá'₂ chein₂ ia₁ a₂juɨn₅ je₂na'₅₄ i₂jme₁tion'₅₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jaun₂ jme₂dsí₂ 'éi₂ në́₃ qui₂ca₂mɨ₃ tion₅₄ ne₄ Jesús ia₁jaun₂ tsá₃ guiog'₃ 'éi₂ ca₂të₂ ja₁ca₂jein₃ chi₁dsio₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jaun₂ jme₁tion'₅₄ juɨn₅ i₁ŋí₅ caun₂ dsɨ₂con'₂. Jaun₂ ca₂mɨ₃ jme₂dsí₂ a₂cuë₃ Jesús jmɨg₄ a₂dsɨ₃toin'₅₄ quió'₅ i₁ŋí₅. Jaun₂ ca₂cuë₃ bá₄ guë'₂ Jesús jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jaun₂ qui₂ca₂'uɨn₂ bá₄ je₂na'₅₄ quió'₅ dsa₂ 'éi₂; ca₂i₃léin₂ i₃toin'₅₄ quió'₅ i₁ŋí₅. Ca₂le₃jɨ́n₃ i₁ŋí₅ 'éi₂ në́₃ ca₂i₁nioi₁₂ co₂'ei₅ 'lɨg'₅₄, qui₂ca₂sein'₃ tsag₂ siá₅ ca₂séin'₂ të₂ dsi₂jmɨg₂. Ja₁jaun₂ ca₂dsain₃ ca₂'ɨn'₃ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jme₁ca₂të́₂ ne₄ dsa₂ i₂jme₁jmo₅ 'í₁ i₁ŋí₅ 'e₂ ca₂lë₃, ca₂i₃lein₃ ca₂cuɨng₃ ca₂i₁dsia₂ jë₄ juɨg₂, ja₁nau₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jaun₂ ca₂i₁len₅₄ dsa₂ juɨg₂ i₁jag₅₄ a₂ca₂lë₃ ja₁jaun₂. Jme₁ca₂dsi₃léin₂ ja₁'en₅₄ Jesús, ca₂jɨ́in₂ dsa₂ i₂ma₂'uɨn₂ je₂na'₅₄ të₂dsɨ́₅. Jaun₂ ma₂guá₅ con₂ Jesús ma₂qui'₂ tsɨn'₅₄, ma₂'en₅₄ bá₄ dsɨ́₅. Jaun₂ ca₂i₃gó'₃ dsɨ́₅ dsa₂ jme₁ca₂jág₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dsa₂ i₂ca₂të́₂ ne₄ a₂ca₂lë₃ jaun₂, ca₂dsia₃ ca₂tsɨ́'₃ táng₃ i₂ca₂dsi₃lén₂ 'éi₂ 'a₂ lia'₂ ca₂'lón₂ dsa₂ i₂jme₁tion'₅₄ je₂na'₅₄ të₂dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jaun₂ në́₃, ca₂le₃jɨ́n₃ bá₄ dsa₂ chan₂ le₃lág'₃ juɨg₂ 'uë₃ Gerasa ca₂tsɨ́'₃ Jesús a₂o₃'ɨin₅ ja₁jaun₂, ia₁ 'ŋio₅ lɨn₃ të₂tsɨ'₅₄ go₂'i₃ tion'₅₄ dsa₂. Jaun₂ ca₂ŋá'₃ bá₄ 'éi₂ ca₂'í₃ táng₃ tsɨ₁mu₅. ");
INSERT INTO cntNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dsa₂ i₂ca₂'uɨn₂ jme₂dsí₂ je₂na'₅₄ quió'₅ në́₃, jme₁mɨ₂₃ ne₄ Jesús a₂jme₁dsó₃ quiong'₅₄. La₁ 'éi₂ në́₃ ca₂jmo₃ 'éi'₃ a₂jŋia₃ bá₄, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Guan'₂ bá₄ quiáng'₂, o₂dsia₄ ca₂le₃jë́₃ 'e₂ në₂jmo₃ Diú₄ ja₁cong'₂. Ca₂ŋá'₃ bá₄ guë'₂ dsa₂ 'éi₂ quió'₅, ca₂i₁dsia₂ le₂tan₅₄ jë₄ juɨg₂ 'e₂ ca₂jmo₃ Jesús quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jme₁ca₂dsián'₃ táng₃ Jesús le₃'ŋo'₅₄ jmɨg₂, qui₂ca₂guei₃ dsa₂ a₂'ŋio₂ dsɨ́₅, ia₁ ca₂le₃jɨ́in₃ bá₄ jme₁ma₂le₁jŋiog₂₃ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Të₃jë₄ jaun₂, ca₂dsióg₃ jan₂ dsa₂ i₂chen₂ Jairo, i₂niog₅ gu₂ guá'₅ sinagoga. Dsa₂ 'éi₂ në́₃ ca₂chi₃jné₃ ne₄ Jesús jme₁dsióg₃, ca₂mɨ₃ tion₅₄-jan₃ ia₁jaun₂ dsó₃ ja₁quió'₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ia₁ jme₁chan₂ jan₂ tan₅₄ ja₁mɨ́g₄, i₂jme₁ma₂'en₅₄ con'₂ guia₃-tɨ́n₂ ŋi₂, i₂jme₁ma₂i₁jón₂. Jme₁ma₂'en₅₄ Jesús juɨ₅ ŋó₃ ja₁quió'₄ 'éi₂, juɨn₅ lɨn₃ dsa₂ i₂i₃lén₂ quiong'₅₄, lia'₂ qui₂rë₂quɨ́n'₅ bá₄ Jesús ŋó₃. ");
INSERT INTO cntNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jë₄ jaun₂, ŋó₃ jan₂ dsa₂ mɨ́₂ i₂dso'₅₄ ma₂guia₃-tɨ́n₂ ŋi₂ a₂tɨin₂, la₁ ca₂lia'₂ 'i₁jan₂ tsá₃ 'ein₂ ma₂ca₂tió'₃ jme₃'lió₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","'Io₅₄ 'éi₂ në́₃ ca₂jme₃quiáin₃ të₂le₃ chi₁co'₅₄ quió'₅ Jesús. Jaun₂ ca₂nɨ́i'₃ chei'₅₄ tsɨn'₅₄ 'éi₂. Co₂tan₅₄ dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂quion₂ jmɨ₂ 'ain₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jaun₂ ca₂juá'₂ Jesús: ―¿'Ein₂ në₂nɨ́'₃ quió₃? Ca₂le₃jɨ́n₃ bá₄ dsa₂ ŋag₂₃ juá'₂ tsá₃ ŋi₅. Jaun₂ ca₂juá'₂ Pe₄: ―Të₅, jág'₂ bá₄ 'ne₂ chi₁quɨ́'₅ co₂'liog'₂ dsa₂ ca₂taun₂ ca₂taun₂ ja₂náu₅. ");
INSERT INTO cntNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","La₁ caun₂ ca₂juá'₂ bá₄ Jesús: ―Chan₂ i₂në₂nɨ́'₃ quió₃, ia₁ ca₂rë₃léi₄ jniá₂ o₂'ág₃ bí₂ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","'Io₅₄ në́₃, jme₁ca₂rë₃lí'₄ a₂tsá₃ ma₃lé₂ jua'₅₄ a₂'mai₃, já₃ jlein₂₃, ca₂chi₃jné₃ ne₄ 'éi₂. Të₃ jág₅ ca₂le₃jɨ́n₃ dsa₂ ca₂juá'₂ lia'₂ tí₅ jág₁ 'e₂ 'uɨg₅₄ ca₂nɨ́i'₃ quió'₅ 'éi₂, ton'₂ ca₂jáng'₃ jág₁ dsau₅ a₂ca₂'lóin₂ dsɨ₂juɨ₅ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jaun₂ ca₂juá'₂ Jesús: ―Jón₃, ne₄ ia₁ a₂'éng'₂, ca₂'lóng'₂ bá₄. Guan'₂ tei₄ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Të₃jë₄ juá'₂ jág₁ jaun₂ jme₁ca₂dsióg₃ jan₂ dsa₂ i₂chen₄ dsi₂néi₂ quió'₅ i₂niog₅ gu₂ guá'₅, ca₂juá'₂: ―Ma₂jon₅ bá₄ chi'₂ quiáng'₂. 'A₃ ma₃cuë'₂ ta₁ Të₅. ");
INSERT INTO cntNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","La₁ ca₂nág₂ bá₄ Jesús, jaun₂ ca₂juá'₂: ―Tsá₃ lë₁jmo₂ 'lia'₂ 'au'₂. Jŋia'₅₄ con'₂ 'én₃ bá₄, jaun₂ në₃ jag'₅₄ i₂'lión₂ bá₄ chi'₂ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jme₁ca₂dsióg₃ dsi₂néi₂, tsá₃ ca₂cuë₃ jmɨg₄ jua'₅₄ dsɨ₃ton'₅₄ 'i₁jan₂ i₂sián'₂, jŋia'₅₄ lia'₂ Pe₄, Juan₅₄, Jacobo në́₃, quian'₅₄ jmá'₃ chog₅₄-jmei₂ chi'₂ 'éi₂ bá₄ i₃ton'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jaun₂ quɨ'₂-'o₅ bá₄ dsa₂ quɨ'₂ dsɨ́₅ lɨn₃ tioin'₅₄, o₄quió'₄ chi'₂. Jaun₂ ca₂juá'₂ Jesús: ―Tsá₃ 'au₂ 'nia'₂; on₃jua'₅₄ i₂rë₂jon₅₄ në₅. Jŋia'₅₄ lia'₂ a₂rë₂güɨ́in₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","La₁ jŋia'₅₄ ca₂ŋɨ́i₂ bá₄ 'éi₂ tioin'₅₄, ia₁ ŋi₅ rë₂ bá₄ a₂jme₁ma₂rë₂jon₅₄ dsón'₂ bá₄ chi'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jaun₂ ca₂tɨ́in₂ gu₂ chi'₂ 'éi₂, ca₂juá'₂ tiá₂: ―¡Jón₃, nau₂! ");
INSERT INTO cntNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ca₂gú'₃ táng₃ jme₂dsí₂ quió'₅; dsɨ₂juɨ₅ jaun₂ bá₄ ca₂nau₂. Jaun₂ ca₂jmo₃ Jesús 'éi'₃ a₂cuë₃ dsa₂ a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jaun₂ dsɨ₂gó'₃ dsɨ́₅ 'ŋio₅ lɨn₃ chog₅₄-jmei₂. La₁ Jesús në́₃ ca₂juá'₂ a₂tsá₃ 'ein₂ tsɨ́'₃ 'i₁jan₂ a₂ca₂lë₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ca₂ŋɨ́'₂ Jesús chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ ca₂cuë₃ juɨ₅bí₂ a₂'io₃ 'éi'₃ ne₄ quió'₅ ca₂le₃jɨ́n₃ jme₂dsí₂ je₂na'₅₄, a₂lé₂ qui₂jme₃'lióin₂ dsa₂ juɨ₁'e₂ guë́₃ dso₄ niog₅ lɨ́in₅. ");
INSERT INTO cntNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ca₂chei₃ a₂dsɨ₃'ë́₃ jág₁ juɨ₁lia'₂ ja₁gon₂ Diú₄, a₂dsɨ₃jme₁'lioin₅₄ dsa₂ i₂le₁dso'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jaun₂ ca₂juá'₂: ―Tsá₃ 'e₂ cán'₁ 'nia'₂ 'i₁caun₂ le₂'i₄ juɨ₅, on₃ guë'₂ 'ma₂'ɨ₅₄, on₃ guë'₂ tsɨ₁na'₅₄ on₃ guë'₂ i₁ŋí'₄, on₃ guë'₂ cu₄, on₃ guë'₂ tsɨ́n'₂ 'nia'₂ siá'₂ cán'₁. ");
INSERT INTO cntNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Le₂caun₂ dsi₂néi₂ ja₁dsi₁nó'₅ 'nia'₂, ja₁jaun₂ jan'₄ 'nia'₂ ca₂lia'₂ ca₂të́₂ jmɨg₄ a₂o₁nog'₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Le₂caun₂ juɨg₂ ja₁tsá₃ guei₅ dsa₂, co₂dsia₅ 'uɨn'₂ 'nia'₂ juɨg₂ jaun₂, séi'₃ 'nia'₂ 'liog₂ tag'₅₄, a₂jmó'₂ léi₄ a₂tsá₃ ma₃'e₂ 'uɨn'₄ 'nia'₂ quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jaun₂ qui₂ca₂'uɨn₂ bá₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, ca₂i₃léin₂ le₂tan₅₄ juɨg₂ i₁'ë́₄ jág₁ dse₃, i₁jme₁'lioin₂₃ dsa₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jaun₂ ca₂rë₃ŋi₅ Rag₅₄ Herodes ca₂le₃jë́₃ 'e₂ niog₅ lë́₂. La₁ tsá₃ caun₂ a₂i₃jiog₅ dsɨ́₅, ia₁ dsia₅ i₂lɨn₅₄, Juan₅₄ bá₄ 'éi₂ ŋɨ₅ a₂ma₂ca₂jein'₅₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","I₂lɨn₅₄ guë'₂ dsia₅ a₂ma₂ca₂jme₃jnia₅ Elías; i₂sián'₂ guë'₂ dsia₅ a₂ma₂ca₂jen'₅₄ táng₃ jan₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","La₁ Rag₅₄ Herodes 'ŋiog₅ guë'₂ në́₃ juá'₂: ―Jua'₂ jniá₂ 'ŋió₃ ca₂jmo₃ 'éi'₃ a₂ca₂quí'₃ dsa₂ dsɨ₂lag₄ 'éi₂. ¿'Ein₂ guë'₂ në₅, tsá₃ caun₂ jág₁ guion₁₂ a₂jmo₂₃? Jaun₂ Herodes në́₃ jme₁'no'₂ juɨ₅ a₂jme₃jein'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jme₁ca₂o₃len₃ dsa₂ i₂chen₄ quiáin₅ 'éi₂, jaun₂ ca₂dsia₃ ca₂tsɨ́'₃ Jesús 'e₂ niog₅ ca₂jmo₃ ja₁i₁lein₅₄. Jaun₂ ca₂jiog₃ Jesús a₂i₃léin₂ con'₂ guioin₅₄ caun₂ juɨg₂ ja₁chei₂ Betsaida. ");
INSERT INTO cntNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","La₁ tion₅₄ bá₄ ca₂i₃lén₂ dsa₂ sián'₂ jme₁ca₂rë₃ŋi₅; ca₂guei₃ bá₄ guë'₂ Jesús qui₂ca₂jme₃tag₂₃ jág₁ juɨ₁lia'₂ ja₁gon₂ Diú₄ ca₂jme₃'lióin₂ dsa₂ i₂jme₁le₁dso'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Të₂le₃ ca₂'láu₂ jmɨg₄ jaun₂, ca₂o₃lén₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ ca₂tsɨ́'₃ Jesús: ―'Ei'₂ jág₁ dsa₂, ia₁jaun₂ dsɨ₃lein₅ dsɨ₃'nióg₂ a₂guë́'₃, juɨ₁dsi₂'nio'₂ ja₁jŋia₃ le₂con₂ juɨg₂ pí'₁ ma₂quián₅ në₅, ia₁ tsá₃ 'e₂ cha₂ ja₁lá₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","La₁ Jesús guë'₂ në́₃ ca₂juá'₂: ―Cuë'₅₄ 'nia'₂ dsa₂ a₂guë́'₃. Jaun₂ ca₂ŋag₃ 'éi₂ táng₃: ―Tsá₃ 'e₂ cha₂ jua'₅₄ a₂le₃cue₅₄ jnia'₅₄ dsa₂, jŋia'₅₄ lia'₂ 'ŋiá₂ i₁ŋí'₄ bá₄ 'i₄; quian'₅₄ on₃ i₁ju₁, jŋia'₅₄ lia'₂ në₁jua'₂ dsɨ₁liá₄ má₃ con'₂ tɨ́n'₂ guë́'₃ ca₂le₃jɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Con'₂ 'ŋiá₂ mei₅ dsa₂ 'éi₂ jme₁lë́₂, jmá'₃ dsa₂ ŋe'₂. Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Chei'₅₄ 'nia'₂ dsa₂ juɨ₁tiain'₄ juɨ₁jmo₁₂ jma₃të₂lón₃-guián₂ lia'₂ co₂niói'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jaun₂ ca₂jmo₃ bá₄ guë'₂ 'éi₂ 'éi'₃ a₂tian'₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jaun₂ ca₂tɨ́n₂ Jesús ta₁'ŋiá₂ i₁ŋí'₄, le₃on₃ i₁ju₁ në́₃. Ca₂chóg'₃ ne₅₄ juɨ₅ guei'₅₄ i₂juɨ́g₃, ca₂jme₃jŋiói₃ a₂jaun₂. Jaun₂ guë́₄ ca₂'niai₃, ca₂cuë́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂. 'Éi₂ guë'₂ në́₃ ca₂dsió'₃ jɨn₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ca₂le₃jɨ́n₃ bá₄ ca₂guë́'₃ ca₂lia'₂ ca₂'ág'₃ dsɨ́₅. Jme₁ca₂lë₃ jaun₂, guia₃-tɨ́n₂ tsɨ₁mɨ'₂ tá₁ ca₂cág'₃ dsa₂ jmá'₃ 'nau₅₄ a₂ca₂chóng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Co₂ráun₂ 'en₅₄ Jesús 'ŋiog₅ chi₂léin'₂ Diú₄, i₂jme₁quiain'₅₄ bá₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, jaun₂ ca₂ŋag₃ Jesús: ―¿'E₂ 'ag₅ dsa₂ jniá₂? ¿'Ein₂ lɨ́n₅ jniá₂, dsia₅ dsa₂? ");
INSERT INTO cntNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―I₂lɨn₅₄ dsa₂ dsia₅ a₂lɨ́ng'₅ Juan₅₄ i₂chon₅ dsa₂ jmɨg₂; i₂lɨn₅₄ guë'₂ dsia₅ a₂lɨ́ng'₅ Elías; i₂lɨn₅₄ guë'₂ dsia₅ táng₃ a₂lɨ́ng'₅ i₂sián'₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, a₂ca₂jein'₅₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jaun₂ ca₂ŋag₃ Jesús: ―¿'Nia'₂ guë'₂ në́₃? ¿'E₂ guë'₂ juá'₂ 'nia'₂ 'ein₂ lɨ́n₅ jniá₂? Jaun₂ ca₂ŋag₃ Pe₄: ―'Ne₂ lɨ́ng'₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jaun₂ ca₂juá'₂ Jesús a₂jmo₃ tei₄, a₂tsá₃ 'ein₂ tsɨ́'₃ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jaun₂ ca₂juá'₂ në́₃: ―Co₂në₅ 'en₅₄ 'éi'₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃ a₂dsɨ₃ŋɨ́i₂ uɨg₅ 'ŋio₅ lɨn₃; jme₃'iog₅₄ dsɨ₂gui'₅₄ can'₅₄, lia'₂ juɨg₅₄ jme₂dsa₂, të₅juá'₅ në́₃. Quɨn'₃ dsa₂ jág₁ a₂jŋag'₃, la₁ jein'₅₄ bá₄ táng₃ a₂'nɨ₅ jmɨg₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jaun₂ ca₂tsɨ́'₃ ca₂le₃jɨ́n₃: ―Në₁jua'₂ chan₂ i₂'nio₃ jiá₃ chi₁co'₅₄ quió₃, co₂dsia₅ juɨ₁dsi₂'én₂ dsɨ́₅ 'ŋiog₅, juɨ₁'ei₅₄ bá₄ caun₂ dsɨ́₅ ca₂le₃jë́₃ jmɨg₄ o₁jŋia'₅₄ ca₂join₃, juɨ₁jia₂ chi₁co'₅₄ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ia₁ juɨ₁lia'₂ dsa₂ i₂'nio₃ le₃chan₂ dse₃ mɨ₂güɨ́g₃ la₂, dsɨ₃'én₂ quió'₅; la₁ juɨ₁lia'₂ dsa₂ i₂quí'₃ dsɨ́₅ juɨ₁dsi₂ŋɨ́i₂ 'e₂ dsɨ₃ŋɨ́i₂ o₄quió₃ jniá₂, lí'₂, tɨ́in'₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ia₁ ¿'e₂ bá₄ ta₁ jmo₃ a₂lí'₄ dsa₂ ca₂le₃jë́₃ a₂cha₂ ne₄ gua'₅₄ 'uë₃ la₂, në₁jua'₂ dsɨ₃'éin₂ bá₄ guë'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ia₁ në₁'ein₂ gui'₅₄ jén'₅ o₄quió₃ jniá₂ quian'₅₄ o₄quió'₄ jág₁ quió₃, ján₃ bá₄ le₂jaun₂ le₃gui'₅₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃ 'ag₃ jë₁ma₂të́₂ rë₁jŋiói'₂ ma₂lɨ́in₅ Rag₅₄ jlán'₁ juɨ₁lia'₂ jlán'₁ Jmei₂, quian'₅₄ ángeles jŋió₅ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, chan₂ bá₄ 'nia'₂ i₂lɨn₅₄ i₂tión₂ jë₄ la₂, i₂tsá₃ dsián₃ ca₂lia'₂ ca₂të́₂ ne₅₄ bí₂ 'éi'₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Con'₂ jŋia₃ jmɨg₄ cang₂ a₂ca₂juá'₂ Jesús le₂në₅, ca₂ŋó₃ juɨ₅ má'₂ i₁chi₂i₁lein'₄ Diú₄, jme₁quiain'₅₄ Pe₄, Jacobo, Juan₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Të₃jë₄ chi₂léin'₂ Diú₄, ca₂rë₃tsɨ́in₃ lia'₂ jniái₂. Tsɨn'₅₄ në́₃ ca₂rë₃tsɨ́n₃ ca₂jnia₃ tiog₂ jau₂, ca₂lia'₂ tág₅ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Të₃jë₄ jaun₂, ca₂jnia₃ on₃ dsa₂, dsia₂₃ jág₁ quian'₅₄ Jesús. Moisés quian'₅₄ Elías bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ca₂lia'₂ co₂tág₅ co₂'né'₅ bá₄ ca₂jniai₃, tióin₂ dsia₂₃ a₂niog₅ lé₂, 'mú₃ a₂gue₃ jë₄ juɨg₂ Jerusalén, a₂le₃ti₃ 'éi'₃ a₂'ein₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Të₃ ma₃i₁güɨ́n₃ 'ŋio₅ lɨn₃ bá₄ Pe₄ quiain'₅₄ rɨin'₅₄, ca₂jme₃jnio₅₄ ne₅₄ ca₂jɨ́in₂ Jesús jniái₂ co₂tág₅ quian'₅₄ dsa₂ on₃ i₂quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jme₁ma₂i₂uɨ́n₃ dsa₂ 'éi₂ cau₅ quió'₅, jaun₂ ca₂juá'₂ Pe₄ ca₂tsɨ́'₃ Jesús: ―Të₅, ¡'e₂ guë́₄ dse₃ lia'₂ tio'₅₄ jniog₄ ja₁lá₃! Në₃ o₁jmó₁ 'nɨ₅ tsɨ₁'io₅ láu₃: caun₂ quiáng'₂, caun₂ quió'₅ Moisés, caun₂ guë'₂ quió'₅ Elías në₃. La₁ a₂lë₁ca₂juá'₂ bá₄ Pe₄, on₃jua'₅₄ jaun₂ lí'₄ a₂të₂'ɨ₂₃ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Të₃ dsia₂₃ jág₁ le₂jaun₂, jme₁gua₃ jnei₅ ca₂jlɨin₃, jaun₂ guë́₄ ca₂ja₃gó'₃ tioin'₅₄ jme₁ca₂i₃'én₂ 'éi₂ jë₄ jnei₅. ");
INSERT INTO cntNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jë₄ jnei₅ jaun₂ ca₂né'₂ jág₁, ca₂juá'₂: ―I₂la₂ bá₄ jón₃ I₂rë₂'ɨ́n₁ quiáng₃. Nei₂ 'nia'₂ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jme₁ma₂në₂néi₂ jág₁ jaun₂, jua'₂ 'ŋiog₅ bá₄ Jesús ma₂chéin'₅ jme₁ca₂jág₃. La₁ jmɨg₄ jaun₂, tei₄ bá₄ ca₂jmo₃ tsá₃ 'ein₂ ca₂tsɨ́'₃ 'i₁jan₂ a₂ca₂të́₂ ne₅₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jme₁jnia₃, ca₂sióin₃ táng₃ má'₂ jaun₂, con'₂ guë'₂ juɨn₅ lɨn₃ dsa₂ ca₂jme₃jein'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Të₃ jɨn₄ dsa₂ jaun₂, ca₂juá'₂ tiá₂ jan₂ dsa₂ ca₂tsɨ́'₃ Jesús: ―Të₅, jmo₄ dse₃ 'au'₂, jɨn₄ co₂nio₄ chi'₂ quiáng₃, i₂jan₂ la₂ bá₄ la₂ quiáng₃ chan₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jme₂dsí₂ 'lɨn'₅₄ bá₄ i₂co₂jmóg'₂ guió'₅ co₂tiá₂ jén'₅ dso₄ 'ei₂, qui₂'uë́'₅ jan₅ mɨ₂'o₅₄. I₂'lɨn'₅₄ në́₃, jmóg'₂, ca₂lia'₂ jaun₂ guë́₄ téi₂ ca₂lia'₂ ma₂jén'₃ uɨg₅ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jme₁ma₂në₂juɨ́g₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáng'₂ a₂jme₁dsei₂₃, la₁ tsá₃ ca₂tió'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jaun₂ ca₂juá'₂ Jesús: ―¡'En₁ jmá'₃ 'nia'₂ dsa₂ chan₂ jmɨg₄ në₃ tsá₃ 'e₂ 'éng'₂! ¿Je₂liá'₂ jmɨg₄ jmá'₃ 'nió'₅ jmo₅₄ tió'₅ dsɨ₃ jɨn'₄ 'nia'₂? Ŋɨ₅₄ chi'₂ quiáng'₂ le₃la₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","La₁ jme₁ma₂ŋó₅ chi'₂ le₃ne₄ Jesús, i₃'ɨ́in₃ táng₃ ca₂tón₂ jme₂dsí₂ je₂na'₅₄ qui₂ca₂ba₂lág'₂. La₁ dsɨ₂juɨ₅ le₂jaun₂ ca₂jí₂ Jesús ca₂jéin₂ i₂'lɨn'₅₄, ca₂jme₃'lióin₂ chi'₂. Jaun₂ ca₂jáng'₂ ne₄ jmei₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A₂jaun₂ në́₃, ca₂i₃gó'₃ dsɨ́₅ ca₂le₃jɨ́n₃ 'a₂ lia'₂ juɨn'₂ Diú₄. Të₃ tion'₅₄ dsa₂ dsɨ₂gó'₃ dsɨ́₅ a₂jmo₅ Jesús, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂ guia₃-tɨ́n₂ quiáin₅: ");
INSERT INTO cntNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Rë₂ nei₂ 'nia'₂ jág₁ quió₃ la₂: ŋi'₅₄ ta₁ ja₁dsau₅₄ në₅, jáng'₂ dsa₂ quió'₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃ o₄gú₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","La₁ jág₁ jaun₂ në́₃, tsá₃ ca₂ŋɨ́'₂ dsɨ́₅ chi'₂ dsɨ₂guia₃-tɨ́n₂, ia₁ tsá₃ jme₁ma₂'i₄ 'éi'₃ a₂le₃ŋɨ́i'₂. Jaun₂ tsá₃ ca₂tiá₂ dsɨ́₅ a₂ŋɨ́i'₃ Jesús 'e₂ 'nio₃ juá'₂ quian'₅₄ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jaun₂ ca₂tsɨ́n₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ con'₂ guioin₅₄, ne₄ juɨ₁lia'₂ 'ein₂ i₂lén₂ i₂dsen₅₄ guë́₄ jë₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","La₁ jme₁ca₂rë₃lí'₄ Jesús 'e₂ a₂dsia₂₃, jaun₂ ca₂cain₃ jan₂ guein₂ ca₂dsiog₃ cau₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jaun₂ ca₂juá'₂: ―Juɨ₁lia'₂ dsa₂ i₂guen₅ guein₂ la₂ o₄quió₃ jniá₂, guei₂₃ jniá₂; juɨ₁lia'₂ dsa₂ i₂guei₅ jniá₂, ján₃ guë'₂ guein₂₃ i₂ca₂chei₃. Ia₁ juɨ₁lia'₂ i₂jmo₅ me'₂ guë́₄ jë₄ ca₂le₃jɨ́n'₃ 'nia'₂, i₂'éi₂ bá₄ i₂lɨ́n₅ i₂dsen₅₄ guë́₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jaun₂ në́₃ ca₂juá'₂ Juan₅₄: ―Të₅, ma₂jɨn₄ jnia'₅₄ jan₂ dsa₂ 'uɨ́in'₂ jme₂dsí₂ je₂na'₅₄ quian'₅₄ bí₂ 'éi'₃ a₂'ó'₅ 'ne₂. Tsá₃ ma₃ca₂cuë₅₄ jnia'₅₄ jmɨg₄, ia₁ tsá₃ guë'₂ ŋɨ₂₃ quian'₅₄ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","La₁ Jesús në́₃ ca₂juá'₂: ―Tsá₃ jmó'₂ 'nia'₂ le₂jaun₂ a₂jnɨg'₅₄. Ia₁ juɨ₁lia'₂ dsa₂ i₂tsá₃ 'iog₅₄, të₂le₃ quián₂ jniog₄ bá₄ tión₂ i₂le₂'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jme₁ma₂ja₂quián₃ të₅₄ jmɨg₄ a₂dsán'₃ táng₃ Jesús guei'₅₄ i₂juɨ́g₃, ca₂'ág₂ caun₂ dsɨ́₅ ca₂'í₃ juɨ₅ a₂dsióg₄ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ca₂chein₃ dsa₂ i₃lén₂ ne₄ juɨ₅ i₃jmó₂ co₂jŋia₅₄ ja₁jŋia₃ caun₂ juɨg₂ pí'₁ niog₅ 'uë₃ Samaria. ");
INSERT INTO cntNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","La₁ tsá₃ ca₂guen₃ dsa₂ Jesús ja₁jaun₂, ia₁ ca₂rë₃lí'₄ a₂'ein₅₄ juɨ₅ ŋó₅ juɨ₅ Jerusalén bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jaun₂ në́₃, jme₁ca₂rë₃ŋi₅ Jacobo quian'₅₄ Juan₅₄ a₂tsá₃ guei₅ dsa₂, jaun₂ ca₂juá'₂: ―Te₁gui'₅₄, ¿tsa₁ dse₃ jmó₁ jniog₄ 'éi'₃ a₂sió₃ si₂ guei'₅₄ i₂juɨ́g₃ ia₁jaun₂ 'én₂ juɨg₂ la₂? ");
INSERT INTO cntNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jaun₂ ca₂jén'₃ Jesús ca₂jí₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Jaun₂ ca₂i₃léin₂ bá₄ táng₃ juɨg₂ siá'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ja₁i₃léin₂ jaun₂, ca₂juá'₂ jan₂ dsa₂: ―Te₁gui'₅₄, 'nio₃ jniá₂ jme₁quion₁ 'ne₂ le₂con₂ ja₁gog'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―Juɨ₁lia'₂ i₁güɨ₅, i₂'io₅ to₄ bá₄ 'éi₂; ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ i₁tan₅ i₂i₂nio₄ guei'₅₄, tio'₅₄ tsag₄ bá₄ 'éi₂ ján₃. La₁ Jaun₅ dsa₂ mɨ₂güɨ́g₃ në́₃ tsá₃ ja₁cha₂ quió'₅, jua'₅₄ ja₁lé₂ le₃jŋia₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jaun₂ ca₂tsɨ́'₃ i₂sián'₂: ―Ŋia₅ quian'₅₄ jniá₂. La₁ ca₂ŋag₃ 'éi₂: ―Te₁gui'₅₄, juɨ₁i₁'óng₃ de'₂ ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―Juɨ₁dsi₂'ón₃ 'lag₄, 'lag₄ rɨin'₅₄. La₁ 'ne₂, juɨ́g₂ jniá₂, gua₂ o₂'ë́₃ jág₁ juɨ₁lia'₂ 'a₂ lia'₂ lë́₅ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jaun₂ ca₂juá'₂ táng₃ jan₂: ―Te₁gui'₅₄, 'nio₃ jniá₂ nei₅₄ quian'₅₄ 'ne₂, la₁ juɨ₁i₁'éi'₃ de'₂ jág₁ i₂chan₂ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","La₁ Jesús në́₃ ca₂juá'₂: ―Dsa₂ i₂ma₂në₂'éi₂ caun₂ dsɨ́₅ a₂jme₃quiong'₅₄, në₁jua'₂ ca₂'ág₂ caun₂-tɨn₃ dsɨ́₅, lɨ́in₅ lia'₂ lɨ́n₅ jan₂ i₂jme₂lióg₃ quiá'₂ 'uë₃, jéin'₅ le₃ca'₃. Tsá₃ ta₁ tén₄ dsa₂ i₂le₂'éi₂ le₃ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cang₂ jaun₂ ca₂quión'₂ Te₁gui'₅₄ 'nag'₂ ne₂guión₂ rë₂dsɨ́₂ guian₃ (70) dsa₂ sián'₂. Jaun₂ qui₂ca₂chein₃ jma₃on₃ jma₃on₃ 'éi₂ i₃léin₂ ne₄ juɨ₅ quió'₅, ca₂le₃jë́₃ juɨg₂ ja₁'ein₅₄ juɨ₅ dsióg₄. ");
INSERT INTO cntNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ca₂tsɨ́'₃ 'éi₂: ―Juɨn₅ lɨn₃ bá₄ dsa₂ 'nio₃ gue₃ jág₁ quió'₅ Diú₄; lë́₅ në₂jag₄ bá₄ 'lióng₂ lɨn₃ a₂ca₂rau₂, la₁ dsa₂ i₂jmo₃ ta₁ bá₄ tsá₃ juɨn₅ chan₂. Jaun₂ lë₃, mɨ₄ 'nia'₂ chei'₅₄ Juɨg₅₄ ja₁nau₂ juɨ₁chein₁₂ dsa₂ i₂jmo₃ ta₁ cág'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jag₄ 'nia'₂ jaun₂, 'nia'₂ tsɨ́n₂ jniá₂ o₁nóg'₅ lɨ́ng'₅ co₂'nió'₄ guein₂ já'₂ cha'₂ jɨn₄ dsɨg₂ náu₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tsá₃ tsɨ₁na'₅₄ cán'₁ 'nia'₂, on₃ guë'₂ lau₂ tó'₅ cu₄, on₃ guë'₂ lau₂ ton₅ tag'₄ 'nia'₂ siá'₂ cán'₁. Tsá₃ jme₁'ag'₄ 'nia'₂ le₂'i₄ juɨ₅ jua'₅₄ a₂dsiá'₁ 'nia'₂ jág₁ uë́₂ quian'₅₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jë₁ma₂të́₂ rë₁tón'₂ 'nia'₂ dsi₂néi₂ quió'₅ dsa₂ ja₁jan'₄, cuɨn₅₄ de'₂ 'nia'₂ dsa₂ Diú₄ juɨg'₅₄ le₂la₂: “Juɨ₁'ei₅ bá₄ tei₄ tion'₄ 'nia'₂ dsi₂néi₂ la₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chi₂jua'₂ dsa₂ i₂quió'₅ dsi₂néi₂ jaun₂ 'ua₁ bá₄ dsɨ́₅, të₃'ŋiá₄ bá₄ jág₁ a₂'ei₅ tei₄ quián'₂ 'nia'₂ ja₁coin₂. La₁ në₁jua'₂ tsá₃ le₂jaun₂, të₃'ŋiá₄ bá₄ táng₃ ja₁con'₂ 'nia'₂ guiong'₅₄ jág₁ a₂'ei₅ tei₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Caun₂ bá₄ ja₁o₁jŋia'₄ 'nia'₂, qué'₂, 'én'₂ 'nia'₂ 'e₂ caun₂ a₂niog₅ cuë₅ dsa₂; ia₁ a₂co₂jaun₂ ca₂tɨ́n₂ bá₄ dsa₂ 'liain'₅₄ ta₁ quió'₅. Jaun₂ tsá₃ i₁nio'₄ 'nia'₂ le₂'í₁ 'né₅. ");
INSERT INTO cntNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jë₁ma₂dsi₃nóg'₅ le₂caun₂ juɨg₂ ja₁guei₅ dsa₂, qué'₂ 'nia'₂ juɨ₁'e₂ guë́₃ a₂cuë₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jme₁'lion₅₄ 'nia'₂ dsa₂ dso'₅₄ i₂chan₂ ja₁jaun₂, chei'₅₄: “Ma₂ja₂quián₃ bí₂ 'éi₂ quió'₅ Diú₄ ja₁con'₂ 'nia'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","La₁ në₁jua'₂ ca₂dsi₃nó'₅ 'nia'₂ caun₂ juɨg₂ ja₁tsá₃ guei₅ dsa₂, 'uɨn'₂ 'nia'₂ jë₄ calles, chei'₅₄: ");
INSERT INTO cntNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Le₂jiog₅ 'liog₂ te₁'i₁ go'₄ 'nia'₂, a₂qui₂ca₂quen'₂ tag₄ jnia'₅₄, la₂ séi'₄ jnia'₅₄, a₂jmó₁ léi₄ tsá₃ ma₃'e₂ 'uag₄ jnia'₅₄ quian'₅₄ 'nia'₂. La₁ dsá₂ 'au'₂ 'nia'₂ jmo₄, ma₂ja₂quián₃ bí₂ 'éi'₃ quió'₅ Diú₄ ja₁cong'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Juá'₅ jniá₂ juɨ́g₂ 'nia'₂, 'ŋio₅ lɨn₃ guë́₄ uɨg₅ a₂'ë́₂ Diú₄ jmɨg₄ jaun₂ ja₁con₂ dsa₂ 'éi₂, lia'₂ con'₂ guë́₄ dsa₂ juɨg₂ Sodoma. ");
INSERT INTO cntNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ dsa₂ juɨg₂ Corazín! ¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ dsa₂ juɨg₂ Betsaida! Ia₁ jua'₅₄ mei'₂ guë́₃ ca₂le₃jɨ́n₃ dsa₂ chan₂ Tiro quian'₅₄ Sidón ca₂të́₂ ne₅₄ juɨ₁lia'₂ juɨ₅bí₂ juë'₂ a₂niog₅ lë́₂ jë₄ quián'₂ 'nia'₂ jmɨg₄ në₃, lɨ́g'₂ bá₄ tsá₃ ma₂quɨ́'₂ 'mɨ'₂ taun₅ jme₁tiain'₃ jë₄ jua₂ në́₃, jme₁jmo₃ léi₄ a₂ca₂dsi₃quén'₅ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","La₁ jë₁ma₂të́₂ rë₁qui₃dsɨ₅ Diú₄ 'éi'₃, 'ŋio₅ lɨn₃ guë́₄ 'ŋio₅ uɨg₅ guéi'₁ 'nia'₂ con'₂ guë́₄ uɨg₅ a₂ca₂gue₃ dsa₂ i₂chan₂ Tiro quian'₅₄ Sidón. ");
INSERT INTO cntNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'Ne₂ guë'₂ juɨg₂ Capernaum, ¿a₁rong'₂ ŋei₅ të₂ guei'₅₄ i₂juɨ́g₃, lɨ́ng'₂? 'En₁ bá₄ 'ne₂ sióng'₃ ca₂të₂ ja₁ca₂tɨ́n₂ 'lag₄. ");
INSERT INTO cntNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Dsa₂ i₂nag₅ jág₁ quián'₂ 'nia'₂, jág₁ quió₃ jniá₂ bá₄ nag₂₃. Dsa₂ i₂tsá₃ guen₅ 'nia'₂, jniá₂ bá₄ a₂tsá₃ guei₂₃. I₂tsá₃ guei₅ jniá₂, ján₃ bá₄ le₂jaun₂ tsá₃ guein₂₃ i₂ca₂chei₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ca₂o₃len₃ táng₃ 'io'₂ jén'₅ ta₁'nag'₂ ne₂guión₂ rë₂dsɨ́₂ guian₃ (70) dsa₂ 'éi₂, jaun₂ dsia₂₃, juá'₂: ―Te₁gui'₅₄, ca₂lia'₂ jiog₅ je₂na'₅₄ bá₄ nag₅ gau₂ jág₁ quián₂ jnia'₅₄ jë₁ma₂ca₂'ɨ́n₂ jnia'₅₄ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jaun₂ ca₂ŋag₃ Jesús: ―Ján₅. Ma₁ jág₅ bá₄ jniá₂ jme₁ca₂tán'₂ Satanás guei'₅₄ i₂juɨ́g₃ lia'₂ ja₁ta'₂ caun₂ si₁ŋí'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","'Éi'₃ jaun₂ bá₄ ma₂cuë́₃ jniá₂ 'nia'₂ a₂'ó'₅ 'nia'₂ bí₂ 'éi'₃ a₂lé₂ le₃qui₁tsong'₅₄ dsɨ₂mɨ'₂, i₁'né₅ në́₃, a₂tiang'₃ ne₄ ca₂le₃jë́₃ juɨ₅bí₂ a₂gu₂dsí₂ i₂'io'₅₄, ca₂lia'₂ jŋia'₅₄ tsá₃ 'e₂ jén'₄ 'nia'₂ guiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","La₁ tsá₃ jmo₂ 'nia'₂ 'io'₂ ia₁ a₂nag₅ gau₂ jme₂dsí₂ 'lɨn'₅₄ jág₁ quián'₂ 'nia'₂. A₂jaun₂ bá₄ jmo₄ 'nia'₂ 'io'₂ ia₁ a₂ma₂le₁tong'₂ ne₄ si₂ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hora jaun₂, ca₂jmo₃ Jme₂dsí₂ Jŋió₅ a₂'io'₂ jén'₅ lɨn₃ Jesús, jaun₂ ca₂juá'₂: ―Jme₂juɨ́n'₁ jniá₂ 'ne₂, Tia₅₄, Juɨg₅₄ guei'₅₄ i₂juɨ́g₃, gua'₅₄ 'uë₃ në́₃, ia₁ ma₂ca₂'ma'₅₄ a₂në₅ ja₁con₂ dsa₂ i₂ŋɨ́₄ tɨn₂ si₂, i₂ŋɨ́'₂ dsɨ́₅ në́₃, a₂ma₂ca₂jme₁jniag'₂ le₃ja₁con₂ dsa₂ i₂lɨ́n₅ lia'₂ lɨ́n₅ guein₂ i₂tsá₃ 'e₂ cuɨ́'₅. Dsón'₂ bá₄ jaun₂, Tia₅₄ quiáng₃, ia₁ le₂në₅ 'ŋio₂ 'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jaun₂ ca₂jén'₃ Jesús, ca₂juá'₂: ―Ŋe'₃ jniá₂ ma₂dsia₃ o₄gu₃ ca₂le₃jë́₃. Jaun₂ 'i₁jan₂ tsá₃ 'ein₂ cuɨn₅ 'ein₂ 'éi₂ i₂lɨ́n₅ Ja₁ŋi'₅₄, jŋia'₅₄ lia'₂ 'ŋiog₅ bá₄ Jmei₂. Ján₃ guë'₂ le₂jaun₂, 'i₁jan₂ tsá₃ 'ein₂ cuɨn₅ 'ein₂ 'éi₂ lɨ́n₅ Jmei₂, jŋia'₅₄ lia'₂ Ja₁ŋi'₅₄ bá₄ i₂cuɨg₅, jaun₂ jme₂jniog₂₃ ne₄ dsa₂ i₂'ŋio₂ dsɨ́₅ Ja₁ŋi'₅₄ jme₂jniog₂₃. ");
INSERT INTO cntNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jaun₂ ca₂jéin'₃, ca₂tsɨ́'₃ jmá'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ guioin₅₄: ―'E₂ guë́₄ dsen₃ dsa₂ i₂të₅ ne₄ juɨ₁lia'₂ a₂niog₅ jág'₂ 'nia'₂, ");
INSERT INTO cntNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ia₁ a₂dsɨ₂jó'₃ juá'₅ jniá₂, juɨn₅ rag₅₄ ma₂lɨ́g'₂, lia'₂ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ në́₃, jme₁'ɨ́n₅ dsɨ́₅ jme₁të₃ ne₅₄ juɨ₁lia'₂ a₂niog₅ të₅ ne'₅₄ 'nia'₂ rë₂në́₃, la₁ tsá₃ ca₂jág₃. Ján₃ bá₄ jme₁'ɨ́n₅ dsɨ́₅ nag₃ juɨ₁lia'₂ a₂niog₅ nag'₂ 'nia'₂ jmɨg₄ në₃, la₁ tsá₃ ca₂nág₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Co₂ráun₂ ca₂nau₂ jan₂ të₅juá'₅, a₂jŋia'₅₄ con'₂ cáun₂ táu₂ bá₄ ca₂ŋag₃: ―Të₅, ¿'e₂ 'nió'₅ jmo₅₄ jniá₂, ia₁jaun₂ tɨng₅₄ ja₁le₃chang₂ co₂tan₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jaun₂ ca₂ŋag₃ Jesús: ―¿'E₂ 'éi'₃ tio'₅₄ ne₄ Si₂ guë'₂? ¿'A₂ lia'₂ ŋɨ́'₂ 'au'₂ a₂'ɨ'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jaun₂ ca₂ŋag₃ táng₃ të₅juá'₅ 'éi₂: ―“Jme₁'nió₄ Te₁gui'₅₄ Diú₄ quiáng'₂ ca₂le₃jë́₃ 'au'₂, ca₂le₃jë́₃ jme₂dsí₂, ca₂le₃jë́₃ juɨ₅bí₂, quian'₅₄ ca₂le₃jë́₃ a₂ŋɨ́'₂ dsei'₂ në́₃; ján₃ guë'₂ le₂jaun₂ jme₁'nióg'₄ dsa₂ mɨ₂güɨ́g₃ rɨ́ng'₂ juɨ₁lia'₂ 'nióg'₃ 'ŋiag'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―Dse₃ lɨn₃ bá₄ në₂ŋag'₅₄. Në₁jua'₂ ca₂jmo'₅₄ le₂në₅, léng'₂ bá₄ ja₁le₃chang'₂ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","La₁ të₅ 'éi₂ jme₁'nio₃ chein'₃ dse₃, jaun₂ ca₂tsɨ́'₃ Jesús: ―¿'Ein₂ 'éi₂ dsa₂ mɨ₂güɨ́g₃ rɨ́ng'₃? ");
INSERT INTO cntNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jaun₂ ca₂ŋag₃ Jesús ma₂të₂chan'₂ jág₁ jaun₂, ca₂juá'₂: ―Jan₂ dsa₂ jme₁'en₅₄ juɨ₅ o₂'ɨ́in₃ Jerusalén ca₂sióin₃ a₂dsióg₄ juɨg₂ Jericó. Dsa₂ 'ang₂ bá₄ ca₂jo₃ ca₂chei'₃ lɨ́in₃, ca₂cuë₃ dsa₂ 'ŋio₅ lɨn₃ jŋia'₅₄ mei'₂ tsá₃ ca₂jŋag'₃. Jaun₂ guë́₄ ca₂i₃lein₅. ");
INSERT INTO cntNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jë₂ lia'₂ juɨ₅ jaun₂ 'en₅₄ juɨ₅ já₅ jan₂ jme₂dsa₂. La₁ con'₂ ca₂quiá₂ cau₅ bá₄ ca₂ŋɨi₅ jme₁ca₂jág₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ján₃ bá₄ ca₂já₃ táng₃ jan₂ dsa₂ i₂lɨ́n₅ tsɨ₁jon₂ Leví, con'₂ ca₂quiá₂ cau₅ bá₄ ján₃, ca₂ŋɨi₅. ");
INSERT INTO cntNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","La₁ jan₂ dsa₂ i₂chan₂ Samaria 'ein₅₄ juɨ₅, ca₂dsióg₃ ja₁ron₅ dsa₂ dso'₅₄, ca₂tá'₂ ŋéi₂ dsɨ́₅ jme₁ca₂jág₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jaun₂ ca₂jme₃quiáin₃ cau₅ quió'₅, ca₂'ág₂ aceite quian'₅₄ vino ja₁rë₂cuɨ́'₃, ca₂lio₃. Jaun₂ ca₂tág₃ co₁lag₁ bú'₄ quiáin₅, ca₂jiog₃ caun₂ 'né₅ ja₁jŋia₅ dsa₂. Ja₁jaun₂ ca₂jmo₃ 'í₁. ");
INSERT INTO cntNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jme₁jnia₃ jaun₂, ca₂dsi₂ tɨn₃ cu₄ 'ua'₂ ca₂cuë́'₃ dsa₂ juɨg₅₄ dsi₂néi₂, ca₂juá'₂: “Jmo₄ co₂nio₄ 'í₁ dsa₂ në₅. Në₁jua'₂ 'e₂ ca₂'éng'₃ guë́₄ quiáng'₂, la₂ bá₄ jáng'₄ jë₁ma₂guióng'₃.” Në₃ në́₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿'Ein₂ dsa₂ i₂ún₂ 'éi₂ lɨ́ng'₂ ca₂jmo₃ dsɨ́₅ a₂lɨ́n₅ dsa₂ mɨ₂güɨ́g₃ rɨn'₅₄ dsa₂ i₂ca₂jmá'₂ dsa₂ 'ang₂? ");
INSERT INTO cntNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jaun₂ ca₂ŋag₃ táng₃ të₅juá'₅: ―I₂ca₂tá'₂ ŋéi₂ dsɨ́₅ dsa₂ 'éi₂. Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―Guan'₂, le₂në₅ jmo₄ 'ne₂ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Con'₂ tioin'₅₄ juɨ₅, ca₂'í₃ Jesús caun₂ juɨg₂ pí'₁. Ja₁jaun₂ ca₂guei₃ jan₂ dsa₂ mɨ́₂ i₂chen₂ Marta dsi₂néi₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","'Éi₂ në́₃ jme₁chan₂ jan₂ rɨin'₅₄ i₂chen₂ María. 'Éi₂ në́₃ tei₄ bá₄ ca₂guá₂ cau₅ mɨ₂tag₄ Te₁gui'₅₄, nag₂₃ jág₁ a₂juá'₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta guë'₂ në́₃ 'ein₅₄ tsá₃ rë₂jɨin₅₄ jmo₂₃ ta₁ a₂cha₂ dsi₂néi₂, jaun₂ guain₃ o₃chi'₅₄ Jesús, ca₂juá'₂: ―Te₁gui'₅₄, ¿tsa₁ dsan₂ 'au'₂ a₂tsá₃ 'e₂ jme₂'o₅₄ 'io₅₄ rɨ́ng'₃? 'Ŋió₃ bá₄ 'eng₅₄ tsá₃ rë₂jɨng₅₄ jme₂ti₅₄. Chei'₅₄ juɨ₁jme₂'o₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jaun₂ ca₂ŋag₃ Te₁gui'₅₄: ―Marta, Marta, jág₅ bá₄ jniá₂ 'ŋio₅ tsá₃ rë₂jɨng'₅₄ 'eng'₅₄ dsan₂ 'au'₂ 'lióng₂ ta₁ a₂jmo'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","La₁ caun₂ bá₄ a₂dsen₅₄ guë́₄ a₂ca₂tɨ́n₂ dsa₂ nag₃. María rɨ́ng'₂ në́₃, në₂quió'₃ a₂dse₃ guë́₄, jaun₂ 'i₁jan₂ tsá₃ 'ein₂ le₃jŋiá'₂ a₂ma₂në₂quió'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Co₂ráun₂ jme₁'en₅₄ Jesús chi₂léin'₂ Diú₄. Jme₁ca₂lë₃ jaun₂, ca₂juá'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Te₁gui'₅₄, jme₁tag₅ 'a₂ lia'₂ chi₂len'₄ jnia'₅₄ Diú₄, juɨ₁lia'₂ ca₂jme₃tag₅ Juan₅₄ ca₂jme₃tɨin₂₃ dsa₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jaun₂ ca₂juá'₂: ―Le₂la₂ jua'₅₄ 'nia'₂ jë₁ma₂të́₂ rë₁chi₁leng'₄ Diú₄: Tia₅₄, 'ne₂ i₂ŋéi'₂ guei'₅₄ i₂juɨ́g₃ juɨ₁jme₂gó'₃ dsa₂ a₂rë₂jŋió₄ a₂cheng'₂. Juɨ₁le₅₄ bá₄ 'éi'₃ quiáng'₂, juɨ₁le₅₄ bá₄ a₂'ŋio₂ 'au'₂ 'ne₂, ne₄ gua'₅₄ 'uë₃, juɨ₁lia'₂ lë́₂ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cuë₄ a₂'nió'₅ que₅₄ jnia'₅₄ jmɨg₄ në₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","'Én₃ dsáu₁ jnia'₅₄, juɨ₁lia'₂ 'én₅ jnia'₅₄ dsáu₁ rɨn'₅₄. 'A₃ cuë₂ jmɨg₄ jiá₃ juɨ₅bí₂ a₂cáun₂ táu₂, të₂le₃ lio₄ bá₄ o₄gú₃ i₂së₃dsen₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ca₂juá'₂ Jesús në́₃: ―Jua'₅₄ mei'₂ guë́₃ le₃jua'₅₄, chan₂ jan₂ 'nia'₂ i₂dsióg₄ a₂'uë₂ quió'₅ a₂mei₅₄ quián₅, të́₂, juá'₂: “Jmo₄ dse₃ 'au'₂ rɨn'₅₄ jniog₄, dsi₄ 'nɨ₅ i₁ŋí'₄. ");
INSERT INTO cntNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ia₁ lia'₂ guan₅ quió₃ jan₂ a₂mei₅₄ quiáng₃ 'ein₅₄ juɨ₅; ia₁ tsá₃ 'e₂ cha₂ 'i₁caun₂ quió₃ a₂le₃cuë́₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dsa₂ dsi₂néi₂ në́₃ lé₂ le₃ŋag₃ të₃ rë₂quiain₂₃: “Tsá₃ cuë₂ o₂me'₅₄ dsɨ₅, ia₁ ma₂chi₁jnág₅ o₄'né₄ quió₃; chi'₂-guein₂ quiáng₃ në́₃ ma₂tiáin'₅ le₁güɨ́in₃. Jaun₂ tsá₃ lé₂ no₅₄ jua'₅₄ cuë₅₄ a₂mɨ'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jaun₂ juá'₅ jniá₂, tion₅₄ bá₄ náu₃ cuë₃ ca₂le₃jë́₃ 'e₂ a₂mɨ₅ 'éi₂, on₃jua'₅₄ jmo₃ ia₁ lë́₅ a₂mei₅₄, të₂le₃ 'uɨg₅₄ ia₁ a₂ŋɨ́₄ lë₃ tion₅₄ mɨ₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jaun₂ le₂në₅ bá₄ juɨ́g₂ jniá₂ 'nia'₂: Mɨ₄ 'nia'₂, jaun₂ ŋeg'₂ bá₄; 'niai'₂ 'nia'₂, jaun₂ dsiain'₂; quein₄ 'nia'₂ o₄'né₄ té₃, jaun₂ niá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ia₁ juɨ₁lia'₂ i₂mɨ₅ 'e₂ mɨ₅, gue₂₃. Le₂jaun₂ juɨ₁lia'₂ i₂'no'₂ 'e₂ 'no'₂, dso'₂ bá₄. Le₂jaun₂ guë'₂ quió'₅ juɨ₁lia'₂ i₂të́₂, niá₂ bá₄ o₄'né₄. ");
INSERT INTO cntNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’O₃ bá₄ chan₂ i₂lɨn₅₄ 'nia'₂ jmo₅, jë₁ma₂ca₂mɨ₃ guein₂ quiáng'₂ i₁ŋí'₄, ¿cuë'₂ 'nia'₂ ca₂mɨ́g₂ nɨ₁cang₁? O₃ në₁jua'₂ ca₂mɨi₃ jan₂ i₁ju₁, ¿cuɨ́in'₅ 'nia'₂ jan₂ dsɨ₂mɨ'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O₃ jë₁ma₂ca₂mɨ₃ ca₂mɨ́g₂ mɨ₂jlag₂, ¿o₃ bá₄ cuɨ́in'₅ jan₂ i₁'né₅ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Chi₂jua'₂ 'nia'₂ dsa₂ mɨ₂güɨ́g₃ i₂'nau'₂ dso₄ chang'₂, tɨng'₂ cuë'₂ bá₄ chi'₂-guein₂ quiáng'₂ a₂dse₃, ¡'ë₂ guë́₄ bá₄ Ŋéi'₅ 'nia'₂ i₂guá₅ guei'₅₄ cuɨin₃ Jme₂dsí₂ Jŋió₅ quiáin₅ quió'₅ ca₂le₃jɨ́n₃ i₂mɨ₅! ");
INSERT INTO cntNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Co₂ráun₂ táng₃ jme₁'en₅₄ Jesús dsein₂₃ jan₂ jme₂dsí₂ je₂na'₅₄ i₂jmo₅ a₂tsá₃ lé₂ dsia₃ dsa₂ jág₁. Jme₁ca₂o₃'ɨ́n₃ je₂na'₅₄ quió'₅ dsa₂, jaun₂ guë́₄ ca₂dsia₃ táng₃ dsa₂ 'éi₂ jág₁. Jaun₂ ca₂i₃gó'₃ dsɨ́₅ dsa₂ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","La₁ i₂lɨn₅₄ guë'₂ ca₂dsia₃ 'ɨin₂₃ Jesús: ―Quɨ'₅₄ i₂në₅ jmɨg₄ 'uɨ́in'₂ je₂na'₅₄ quian'₅₄ juɨ₅bí₂ quió'₅ Be'elzebú, i₂lɨ́n₅ juɨg₅₄ je₂na'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","I₂lɨn₅₄ guë'₂ në́₃, a₂jŋia'₅₄ con'₂ cáun₂ táu₂ bá₄ jme₁mɨ₂₃ a₂jme₁jmo₃ Jesús a₂sió₃ caun₂ léi₄ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","La₁ a₂ŋi₅ rë₂ bá₄ Jesús 'a₂ lia'₂ dsɨ₂jiog₅ dsɨ́₅ dsa₂ 'éi₂. Jaun₂ lë₃ ca₂juá'₂: ―Juɨ₁lia'₂ caun₂ juɨg₂ nación, tioin'₅₄ mɨ'₅₄ guioin₅₄, tioin'₅₄ le₁dsoin'₅₄, dsɨ₃'én₂ bá₄ juɨg₂ jaun₂. Le₂jaun₂ guë'₂ juɨ₁lia'₂ caun₂ dsi₂néi₂ tion'₅₄ dsa₂ le₁dsoin'₅₄ tsá₃ caun₂ jág₁ 'ei₅, ján₃ bá₄ dsɨ₃'én₂ dsi₂néi₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Le₂në₅ bá₄ ján₃, në₁jua'₂ ca₂lë₃ le₁dso'₅₄ juɨ₅bí₂ quió'₅ i₂së₃dsen₃, ¿'a₂ guë'₂ lia'₂ lé₂ le₃quɨ'₅₄ guë́₄ jmɨg₄ jiog₃ ne₄ta₁ quió'₅? Juá'₅ jniá₂ le₂në₅ ia₁ juá'₂ 'nia'₂, quian'₅₄ bí₂ quió'₅ Be'elzebú bá₄ a₂'uɨn'₄ jniá₂ je₂na'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","La₁ chi₂jua'₂ le₂jaun₂ 'uɨin'₄ jniá₂ quian'₅₄ bí₂ quió'₅ Be'elzebú, ¿'ein₂ guë'₂ quió'₅ bí₂ quian₅ i₂quian'₅₄ 'nia'₂ a₂lé₂ le₃'uág'₂ ján₃? Jaun₂ juɨ₁lia'₂ lë́₅ jmo₅ dsa₂ 'éi₂ bá₄ jióg'₂ 'í₁ a₂tsá₃ tí₅ jág₁ quián'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","La₁ chi₂jua'₂ jaun₂ quian'₅₄ juɨ₅bí₂ a₂tɨn₂ Diú₄ lon₄ jniá₂ dsa₂ o₄gú₃ je₂na'₅₄, jaun₂ le₂në₅ bá₄ jau'₂ jág₁ dsau₅ a₂ma₂gua₅ bí₂ 'éi'₃ quió'₅ Diú₄ ja₁con'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Juɨ₁lia'₂ jan₂ dsa₂ 'uan'₂ chain₂ rë₂jáin₁, 'io₂₃ ca₂le₃jë́₃ a₂'nió'₅ quió'₅ jmo₃ 'nei₂, jaun₂ lë́₅ 'í₁ ca₂le₃jë́₃ 'e₂ tio'₅₄ dsi₂néi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","La₁ në₁ca₂já₃ jan₂ i₂'uan'₂ guë́₄ lia'₂ con'₂ guë́₄ 'ŋiog₅ 'éi₂, në₁ca₂jo₃ në́₃, i₂'éi₂ guë'₂ në́₃ jŋiá'₂ ca₂le₃jë́₃ a₂ŋɨ́₄ lë₃ bein'₂ jmo₂₃ a₂'uain'₂. Jaun₂ jmo₂₃ dsióg₂ ca₂le₃jë́₃ a₂ca₂lɨ́'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Juɨ₁lia'₂ dsa₂ i₂tsá₃ chén'₅ le₃quió₃ jniá₂, i₂'iog₅₄ bá₄ 'éi₂. Juɨ₁lia'₂ i₂tsá₃ cág'₅ co₂lë₅ quian'₅₄ jniá₂, jŋia'₅₄ jmo₅ tsɨ₁rë₂ja₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Juɨ₁lia'₂ jan₂ jme₂dsí₂ 'lɨn'₅₄ i₂o₂'ɨn₅ quió'₅ dsa₂, dsɨ₂ŋɨ́₃ le₂tan₅₄ ja₁quein₂ dsɨ₂'nio'₂ ja₁jŋia₃. Në₁jua'₂ tsá₃ dso'₂ ja₁'í₂ në́₃, 'no'₂ dsɨ́₅: “Nég'₄ táng₃ dsi₂néi₂ quió₃ ja₁o₂'ɨ́ng₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jë₁ma₂dsiáin'₃, jein'₂ táng₃ dsa₂ 'éi₂ ma₂lɨ́in₅ co₂'nió'₄ bá₄ caun₂ dsi₂néi₂ a₂chí'₅ rë₂, rë₂'ia'₅₄, rë₂lag₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jaun₂ dsó₅ táng₃ dsɨ₂quiáin₂ guë́₄ guion₃ jme₂dsí₂ i₂'lɨn'₅₄ guë́₄ lia'₂ 'ŋiog₅, jaun₂ dsɨ₂tiain'₂ ca₂le₃jɨ́in₃ të₂dsɨ́₅ dsa₂ 'éi₂. Jaun₂ dsa₂ 'éi₂ në́₃ 'ŋio₅ lɨn₃ guë́₄ le₃'lɨin'₅₄ dsióg₄ lia'₂ con'₂ guë́₄ jme₁lɨ́in₄ le₂jŋiá₅. ");
INSERT INTO cntNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Të₃ 'en₅₄ Jesús dsia₂₃ le₂në₅, ca₂juá'₂ tiá₂ jan₂ dsa₂ mɨ́₂ të₃jɨn₄ dsa₂: ―¡'E₂ guë́₄ dsen₃ dsa₂ mɨ́₂ i₂ca₂caun₃ 'ne₂, i₂ca₂'éin'₃ dsi'₅₄ quió'₅! ");
INSERT INTO cntNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jaun₂ ca₂ŋag₃: ¡Të₂le₃ ja₂lɨn₃ guë́₄ dsen₃ dsa₂ i₂nag₅ 'e₂ juá'₂ Diú₄, ton'₂ jme₂ti₃! ");
INSERT INTO cntNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Caun₂ qui₂ŋɨ'₂ bá₄ dsa₂ ja₁chén'₄ Jesús, jaun₂ 'éi₂ në́₃ ca₂jme₃lióg₃ ca₂juá'₂: ―'Ŋio₅ lɨn₃ ma₂'lɨn'₅₄ dsa₂ rë₂në́₃, mɨ₂₃ a₂jmo₅₄ jniá₂ léi₄ juë'₂. La₁ tsá₃ ma₂'e₂ léi₄ jua'₅₄ a₂jmo₄ guë́₄ jniá₂, jŋia'₅₄ lia'₂ caun₂ léi₄ a₂ca₂lë₃ quian'₅₄ Jonás bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ia₁ le₂në₅ juɨ₁lia'₂ Jonás ca₂lɨin₃ caun₂ léi₄ të₂le₃ ja₁con₂ dsa₂ i₂jme₁chan₂ Nínive jmɨg₄ jaun₂, le₂në₅ bá₄ ján₃, Jaun₅ dsa₂ mɨ₂güɨ́g₃ léin₂ caun₂ léi₄ a₂jáng'₃ jág₁ dsau₅ ja₁con₂ dsa₂ i₂chan₂ jmɨg₄ në₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jë₁ma₂të́₂ rë₁qui₃dsɨ₅ Diú₄ 'éi'₃, náu₃ 'io₅₄ rag₅₄ i₂jme₁chan₂ të₂le₃ sur, jein'₅₄ quian'₅₄ dsa₂ ŋe'₂ i₂chan₂ jmɨg₄ në₃. 'A₂ lia'₂ niog₅ ca₂jmo₃ 'éi₂, jióg'₂ 'í₁ a₂rë₂cán'₄ dsa₂. Ia₁ 'io₅₄ 'éi₂ ca₂'í₃ juɨ₅ ca₂já₃ uɨ́ng₂ lɨn₃ guain₃ ca₂o₃néi₃ jág₁ ca'₅₄, ca₂o₃dso₅₄ dsɨ́₅ 'a₂ lia'₂ niog₅ dsi₄ Salomón. La₁ në₃ në́₃, la₂ chén'₅ jan₂ i₂juɨn'₂ guë́₄ lia'₂ Salomón. ");
INSERT INTO cntNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ján₃ bá₄ náu₃ i₂jme₁chan₂ Nínive, jein'₅₄ quian'₅₄ dsa₂ ŋe'₂ i₂chan₂ jmɨg₄ në₃, jë₁ma₂të́₂ rë₁qui₃dsɨ₅ Diú₄ 'éi'₃. 'A₂ lia'₂ niog₅ ca₂jmo₃ 'éi₂ ma₂lɨ́g'₂ jióg'₂ 'í₁ a₂rë₂cán'₄ dsa₂ jmɨg₄ në₃. Ia₁ 'éi₂ ca₂jme₃tsɨ́in₃ dsɨ́₅ jme₁ca₂'ë́₂ Jonás jág₁ quió'₅ Diú₄. La₁ në₃ në́₃, la₂ chén'₅ jan₂ i₂juɨn'₂ guë́₄ lia'₂ Jonás. ");
INSERT INTO cntNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’'I₁jan₂ dsa₂ tsá₃ guí'₅ caun₂ si₂ nɨ₁tsɨ́₅ jua'₅₄ chi'₃ ja₁chi₁quion'₅₄. A₂'ag₅ guei'₅₄ bá₄ dsa₂ si₂, ia₁jaun₂ jág₃ dsa₂ i₂dsɨ₃ton'₅₄ dsi₂néi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jme₁ne₁ dsa₂ lë́₅ co₂'nió'₄ caun₂ nɨ₁tsɨ́₅ a₂guí'₂ si₂ quió'₅ nɨ₁ŋɨ₁ dsa₂. Chi₂jua'₂ dse₃ jme₁ne'₄, ta₁jang'₂ bá₄ tág₅ si₂ quiáng'₂. La₁ në₁jua'₂ tsá₃ dse₃, ta₁jang'₂ bá₄ chéng'₅ qui₁né'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Të₃ŋi'₅₄ 'nia'₂ jaun₂, ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ si₂ quiáng'₂ tsá₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chi₂jua'₂ ta₁jang'₂ tág₅ bá₄ si₂ quiáng'₂, tsá₃ qui₁né'₃ lë́₅. Jniág'₂ bá₄ lia'₂ ja₁jniá₂ tág₅ caun₂ si₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jme₁ca₂dsan₃ cuë₂₃ jág₁, ca₂tág₃ jan₂ dsa₂ fariseo a₂i₃guë́'₃ quiong'₅₄. Jme₁ca₂dsióg₃ dsi₂néi₂ ca₂guá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Dsa₂ fariseo 'éi₂ në́₃, i₃gó'₃ dsɨ́₅ ia₁ tsá₃ ca₂jme₃ti₃ Jesús con'₂ lë́₅ tag₄ a₂chí'₅, a₂rang₃ gu₂ né'₃ a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","La₁ Te₁gui'₅₄ në́₃, ca₂juá'₂: ―'Nia'₂ dsa₂ fariseos lɨ́ng'₅ lia'₂ lë́₅ nɨ₁vaso, nɨ₁uɨng₅, a₂jŋia'₅₄ le₁jë́₃ jmá'₃ le₃co'₅₄, la₁ të₂le₃ juɨ₅ jme₂dsí₂ quiáng'₂, qui₂rë₂can'₂ ca₂le₃jë́₃ a₂'lɨg'₅₄ a₂jmo'₂: tsá₃ mag'₂ 'au'₂ 'nia'₂ ma₂qui₂ma₂'ang'₂ quió'₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡'E₂ bá₄ tsá₃ ŋɨ́'₂ 'au'₂ 'nia'₂! ¿On₁jua'₅₄ i₂ca₂jmo₃ le₃co'₅₄, ca₂jmo₃ le₃'ŋió'₂ ján₃? ");
INSERT INTO cntNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ja₂lɨn₃ guë́₄ dsióg₅ jen'₅₄ de'₂ 'nia'₂ a₂te₁'i₁ quiáng'₂, jaun₂ guë́₄ lé₂ le₃të₃tsɨn'₅₄ 'nia'₂ le₁jɨ́ng'₃ le₃ja₁con₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ dsa₂ fariseos! Ia₁ a₂jme₂tí'₁ 'nia'₂ jmo'₂, cuë'₂ Diú₄ caun₂ qui'₅₄ a₂guia₃ a₂'i₄ 'éi'₃ cuë'₅₄, ca₂lia'₂ ca₂le₃jë́₃ ne₅₄ ma₁'au₂ a₂lë́₂ ma₂juɨg₂ má₃ bá₄ jáng'₄ 'nia'₂. La₁ con'₂ ma₂ŋɨ'₅₄ bá₄ 'nia'₂ juɨ₅ dse₃ të₃dsón'₂ ja₁'ŋio₂ dsɨ́₅ Diú₄, ja₁jme₁jme₁'nió'₄ 'nia'₂ Diú₄: a₂në₅ bá₄ a₂dsen₅₄ guë́₄ a₂ca₂tɨ́n'₂ 'nia'₂ jmó'₂, la₁ on₃jua'₅₄ a₂tsá₃ ma₃jme₁ti'₄ 'nia'₂ 'éi'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Juɨ́g'₂ 'nia'₂ dsa₂ fariseos! Ia₁ 'ŋio₅ lɨn₃ të₅ 'au'₂ a₂tiáng'₄ jláng'₁ ja₁dsen₅₄ guë́₄ juɨ₁lia'₂ dsi₂néi₂ guá'₅ sinagogas. Ján₃ bá₄ të₅ 'au'₂ 'nia'₂ qui₃cuag₃ dsa₂ Diú₄ juɨ₁lia'₂ jë₄ 'ma'₅₄ a₂jme₂go₃ dsa₂ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂! Ia₁ lɨ́ng'₅ juɨ₁lia'₂ lë́₅ tau₂ 'ŋio₅ a₂tsá₃ léi₄ cha₂. Dsa₂ në́₃ qui₂ŋɨ́i₅ ne₄, të₃ tsá₃ ŋi₅.” ");
INSERT INTO cntNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jaun₂ ca₂ŋag₃ jan₂ të₅juá'₅: ―Të₅, a₂juá'₂ 'ne₂ në₅, a₂të₂'ó'₁ jnia'₅₄ bá₄ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jaun₂ ca₂ŋag₃ Jesús: ―¡Juɨ́g'₂ 'nia'₂ të₅juá'₅! Ia₁ quian'₄ 'nia'₂ lio₅₄ guei₂ i₂sián'₂, la₁ guion'₅₄ 'nia'₂ në́₃, ca₂lia'₂ jŋia'₅₄ gog'₂ tsá₃ 'niog'₂ tí'₄. ");
INSERT INTO cntNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Juɨ́g'₂ 'nia'₂! Ia₁ qui₂chog'₂ 'nia'₂ nɨ₁'ia'₂ jlá'₁ quió'₅ 'lag₄ i₂jme₁'ë́₂ jág₁ quió'₅ Diú₄, ton'₂ dsa₂ can'₅₄ quián'₂ 'nia'₂ guiong'₅₄ qui₂ca₂jme₃dsiog₂₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jaun₂ në́₃, lia'₂ lë́₅ jmo'₂ 'nia'₂, cuë'₂ léi₄ co₂'nió'₄ caun₂ bá₄ 'ei₅ jág₁ 'nia'₂ quian'₅₄ dsa₂ can'₅₄ quiáng'₂. Ia₁ dsa₂ can'₅₄ ca₂jme₃dsiog₂₃; 'nia'₂ guë'₂ ma₂ja₂nióg'₅ chog'₂ nɨ₁'ia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Jaun₂ lë₃ Diú₄, ia₁ a₂tɨin₂ a₂ma₂ŋi₅ bá₄ a₂lé₂, ca₂juá'₂: “Qui₁tsɨng₅₄ dsa₂ i₂dsɨ₃can₅ i₂dsɨ₃'ë́₃ jág₁ quió₃. I₂lɨn₅₄ 'éi₂ jme₃dsian₅ dsa₂; i₂lɨn₅₄ guë'₂ qui₃'ein₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jaun₂ në́₃ ca₂të₂ dsa₂ chan₂ jmɨg₄ në₃ bá₄ rë₂cán'₄ 'mú₃ quió'₅ ca₂le₃jɨ́n₃ dsa₂ i₂'ë́₂ jág₁ i₂ma₂dsan₃ ca₂le₃ ca₂nio₃ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ca₂lia'₂ con'₂ jme₁ca₂jon₃ Abel, ca₂të₂ jmɨg₄ i₁ca₂jon₃ Zacarías i₂ca₂jŋɨ'₃ dsa₂ jë₄ ja₁lë́₄ ne₄chei₂ quian'₅₄ ja₁jŋió₅, dsa₂ chan₂ jmɨg₄ në₃ bá₄, juá'₅ jniá₂, quí₃ 'mú₃ quió'₅ ca₂le₃jɨ́n₃ dsa₂ i₂ma₂dsan₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡'E₂ guë́₄ juɨ́g'₂ 'nia'₂ të₅juá'₅! Ia₁ 'nia'₂ bá₄ ma₂rë₂'móg'₄ jág₁ quió'₅ Diú₄ a₂lë́₅ co₂'nió'₄ ŋí₁ llave quió'₅ o₄'né₄ ja₁jme₁le₃tɨn₂, le₃ŋɨ́'₂ dsa₂. On₃ guë'₂ guion'₅₄ 'nia'₂ tóng'₄, on₃ guë'₂ cuë'₂ 'nia'₂ jmɨg₄ dsɨ₃ton'₅₄ i₂'nio₃ tón'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jme₁ca₂dsan₃ juá'₂ Jesús le₂në₅, ca₂rë₃'né₃ 'lɨg'₅₄ dsa₂ fariseos, të₅juá'₅ në́₃. Jaun₂ ca₂jme₃lióg₃ jmóg'₂ mɨ'₅₄, tsá₃ caun₂ a₂qui₂ca₂ŋag₃, a₂jme₁jmo₂₃ tion₅₄ lia'₂ jme₁jéin'₃ 'éi₂ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ia₁ jme₁'nio₃ jo₅₄ jua'₅₄ ca₂jon₄ bá₄ jág₁ 'lia'₂ jme₁'ŋiá₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Të₃jë₄ jaun₂, të₂le₃ mei₅ bá₄ dsa₂ i₂ca₂ŋɨ'₂, ca₂lia'₂ qui₂co₂'liain'₂ rɨin'₅₄. Jaun₂ Jesús në́₃ jŋiá₅ de'₂ dsa₂ i₂quiain'₅₄ bá₄ ca₂tsɨ́'₃: ―Të₃ŋi'₅₄ 'nia'₂ quian'₅₄ juɨ₅ lia'₂ lë́₅ quian₅ dsa₂ fariseos co₂'nió'₄ i₂lë₁jmo₅-dsáu₅ o₁ne₁. ");
INSERT INTO cntNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ia₁ 'i₁caun₂ a₂rë₂'ma₄ jua'₅₄ lɨ́n₂ dsa₂ a₂tsá₃ le₃jniá₂, tion₅₄ bá₄ rë₂jniá₂; ján₃ bá₄ tsá₃ cha₂ 'i₁caun₂ a₂rë₂jlë₅ jua'₅₄ lɨ́n₂ dsa₂ a₂tsá₃ 'ein₂ le₃ŋi₅, tion₅₄ bá₄ rë₃ŋi₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jaun₂ në́₃, ca₂le₃jë́₃ 'e₂ a₂dsia₅ dsa₂ jë₄ qui₁né'₃, jiá₃ bá₄ le₃ja₁jniá₂ si₂. Le₂jaun₂ juɨ₁lia'₂ jág₁ a₂dsia₅ dsa₂ jë₄ të₃co'₅₄ a₂qui₂le₁jnág₅ 'né₅, a₂dsɨ₃'ag₅ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’'Nia'₂ a₂mei₅₄ quiáng₃, juɨ́g₂ jniá₂ 'nia'₂, tsá₃ jmo₂ 'nia'₂ gang'₃ i₂jme₂dsian₅ nɨ₁ŋɨ́₅, ia₁ tsá₃ ma₃a₂siá'₂ jua'₅₄ a₂'io₂₃ guë́₄ bí₂ jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jaun₂ la₂ juá'₅ jniá₂ 'ein₂ dsón'₂ i₂ca₂tɨ́n'₂ 'nia'₂ jme₁gang'₃: i₂'éi₂ bá₄ jme₁gan'₃ 'nia'₂ jmo₄ i₂'io₅ bí₂, jme₃dsiog₂₃, ton'₂ 'io₂₃ bí₂ 'liog'₃ ja₁'lɨg'₅₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Tsa₁ 'nɨ₅ dsa₂ 'ŋiá₂ i₁tan₅ tei₄ quian'₅₄ tɨn₃ ŋí₁ guéin₂? La₁ 'i₁jan₂ 'éi₂ tsá₃ dsɨ₂'én₂ dsɨ́₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jag₄ 'nia'₂ jaun₂, 'ŋio₅ lɨn₃ guë́₄ dsan₂ dsɨ́₅ Diú₄ 'nia'₂, le₂jiog₅ jŋi₂ dsei'₂ 'nia'₂, ma₂ŋi₅ bá₄ Diú₄ je₂liá'₂ mɨ'₂ tí₅. Jaun₂ tsá₃ jmo₂ 'nia'₂ gang'₃, ia₁ 'ŋio₅ guë́₄ quen'₄ 'nia'₂ lia'₂ con'₂ guë́₄ juɨn₅ i₁tan₅. ");
INSERT INTO cntNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Juá'₅ jniá₂, ca₂le₃jɨ́n₃ i₂jme₂jnia₅ ja₁con₂ dsa₂ mɨ₂güɨ́g₃ a₂cuɨg₂₃ jniá₂, ján₃ bá₄ le₂jaun₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ 'ag₃ jme₃jniog₂₃ a₂cuɨg₂₃ ja₁con₂ ca₂le₃jɨ́n₃ ángeles quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","La₁ juɨ₁lia'₂ i₂tsá₃ 'ag₅ a₂cuɨg₂₃ jniá₂ ja₁con₂ dsa₂ mɨ₂güɨ́g₃, ján₃ bá₄ le₂jaun₂ tsá₃ 'ɨ́in₄ jniá₂ a₂cuɨ́in₅ ja₁con₂ ángeles quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ia₁ juɨ₁'ein₂ guë́₃ i₂'ɨn₅ 'lɨg'₅₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃, cha₂ bá₄ o₂'én₂ dso₄ quió'₅. La₁ juɨ₁lia'₂ i₂juá'₂ 'lɨg'₅₄ 'ɨin₂₃ Jme₂dsí₂ Jŋió₅, tsá₃ ma₃o₂'én₂ dso₄ cha₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Jë₁ma₂ca₂jŋia₃ dsa₂ 'nia'₂ ne₄ dsɨ₂tan₅₄ quián₅ guá'₅, o₃ jë₁ma₂ca₂jiog₃ ne₄ i₂con₂ 'í₁, ne₄ dsa₂ i₂qui₂dsɨ₅ 'éi'₃ në́₃, tsá₃ jmó'₂ 'nia'₂ 'ɨ₅ 'au'₂ jua'₅₄ tsá₃ ŋi'₅₄ 'a₂ lia'₂ ŋag'₅₄, 'o₃ 'e₂ juɨg'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ia₁ 'ŋiog₅ bá₄ Jme₂dsí₂ Jŋió₅ jme₃tag₂₃ 'e₂ a₂ca₂tɨ́n'₂ 'nia'₂ ŋag'₅₄, jë₁ma₂ca₂të́₂ hora jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jan₂ dsa₂ i₂jme₁'en₅₄ jë₄ jaun₂ në́₃, ca₂tsɨ́'₃ Jesús: ―Të₅, chei'₅₄ co₂nio₄ dsó₂ rɨ́ng'₃ juɨ₁cuë₁₂ con'₂ a₂ca₂tɨ́ng₂ a₂cha₂ quió'₅ 'lag₄ ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jaun₂ ca₂ŋag₃ Jesús: ―'Ne₂ dsa₂, ¿'ein₂ ca₂dsiog₃ jniá₂ a₂lɨ́ng₅ jan₂ i₂dsió'₅ 'e₂ a₂ca₂tɨ́n'₂ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ján₃ bá₄ ca₂juá'₂: ―Të₃ŋi'₅₄ 'nia'₂ tsá₃ i₂jmo₂ jua'₅₄ a₂ŋɨ́₄ lë₃ 'ɨ́n₅ 'au'₂ a₂le₃cha₂ quiáng'₂. Ia₁ on₃jua'₅₄ jmá'₃ a₂ŋɨ́₄ cha₂ quió'₅ dsa₂ le₃chain₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jaun₂ ca₂tsɨ́'₃ táng₃ dsa₂ jág₁ jáng'₅ léi₄ la₂: ―Jme₁chan₂ jan₂ dsa₂ i₂jme₁cha₂ cu₄ 'ŋio₅ lɨn₃. 'Lióng₂ lɨn₃ jme₁rau₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jaun₂ ca₂i₃jiog₅ dsɨ́₅: “¿'E₂ bá₄ jmo₅₄ jniá₂ në́₃? Tsá₃ ma₃cha₂ ja₁tó'₄ a₂ca₂rau₂ quió₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jaun₂ ca₂i₃jiog₅ dsɨ́₅: “Le₂la₂ jmo₅₄. Quɨ́'₄ tsɨ₁'io₅ a₂tióng₂ në₅, jaun₂ jmo₅₄ a₂ca'₅₄ guë́₄. Jaun₂ ja₁jaun₂ tó'₄ trigo, quian'₅₄ ca₂le₃jë́₃ guë́₄ a₂cha₂ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jaun₂ guë́₄ 'náu'₄ dsɨ₃: 'Lióng₂ ma₂niog₅ le₁má'₂, ma₂len₅ 'lióng₂ ŋi₂; ma₂lé₂ jan₅₄, gua₅₄ tei₄, guë'₅₄, guɨ'₅₄, cuë́₄ o₂'ŋió₃ o₂jŋia₃ dsɨ₃.” La₁ Diú₄ në́₃ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂ 'éi₂: ");
INSERT INTO cntNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“¡'E₂ guë́₄ con'₅₄ 'ne₂ lɨ́ng'₅! Jua'₂ a₂'uë₂ në₃ mág₄ jniá₂ 'mú₃ quiáng'₂. Ca₂le₃jë́₃ a₂ma₂dsia'₅₄ 'ne₂ rë₂, ¿'ein₂ bá₄ quió'₅ lé₂?” ");
INSERT INTO cntNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Le₂në₅ dsɨ₂ŋɨ́₂ juɨ₁lia'₂ dsa₂ i₂dsia₅ le₁má'₂ jmá'₃ quió'₅ 'ŋiog₅, la₁ të₂tsɨin'₅₄ lɨ́in₃ le₃ja₁con₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jme₁ca₂dsan₃ jaun₂, ca₂tsɨ́'₃ táng₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Juɨ́g₂ jniá₂ 'nia'₂, tsá₃ jmo₂ 'nia'₂ jua'₅₄ a₂ŋɨ́₄ dsan₂ 'au'₂ 'e₂ a₂quë'₅₄ të₁lia'₂ chang'₂, on₃ guë'₂ o₄quió'₄ nɨ₁ŋɨ'₁, jua'₅₄ dsan₂ 'au'₂ 'e₂ quɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ia₁ jme₂dsí₂ bá₄ a₂quen₅ guë́₄ lia'₂ con'₂ guë́₄ má₃. Ján₃ guë'₂ le₂jaun₂ nɨ₁ŋɨ₁ bá₄ dsa₂ a₂quen₅ guë́₄ lia'₂ con'₂ guë́₄ 'mɨ'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ŋí₂ de'₂ 'nia'₂ juɨ₁lia'₂ i₁qui₂lia'₂. Tsá₃ 'e₂ jne₂₃, on₃ guë'₂ 'e₂ cha₂ a₂le₃rau₂ quió'₅, on₃ guë'₂ 'io₅ chí'₅ quió'₅. Diú₄ bá₄ i₂jme₂tau₅₄. ¡Jaun₂ 'ŋio₅ lɨn₃ guë́₄ bá₄ quen'₄ 'nia'₂ lia'₂ con'₂ guë́₄ i₁tan₅ 'éi₂! ");
INSERT INTO cntNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿I₂'ein₂ 'nia'₂ i₂lé₂ le₃jmo₃ le₃chain₂ guë́₄ uë́₂, ne₄ ia₁ a₂ŋɨ́₄ lë₃ 'ɨ₅ 'au'₂ 'nia'₂ chang'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Chi₂jua'₂ tsá₃ quɨn'₅₄ 'nia'₂ jmɨg₄ quian'₅₄ a₂ca₂juɨg₄ në₅, ¿'e₂ guë'₂ lë₃ ŋɨ́₄ dsan₂ 'au'₂ 'nia'₂ quian'₅₄ a₂siá'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ŋí₂ de'₂ 'nia'₂ ján₃ 'a₂ lia'₂ qui₂dsɨ₂cón₃ lí₁. Tsá₃ tsɨ₁ŋi₅ lé₂ tsë́'₃, on₃ guë'₂ lé₂ ta₃. Jaun₂ juɨ́g₂ jniá₂ 'nia'₂, ca₂lia'₂ jŋia'₅₄ Rag₅₄ Salomón, quian'₅₄ ca₂le₃jë́₃ a₂jlá'₁ a₂jme₁cha₂ quió'₅, tsá₃ ca₂rë₃jláin'₁ bá₄ guë́₄ juɨ₁lia'₂ jlá'₁ lí₁. ");
INSERT INTO cntNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Chi₂jua'₂ le₂në₅ chi'₅ Diú₄ jlá'₁ nau₂ a₂cha₂ 'ŋa₁, a₂jŋia'₅₄ jniá₂ jlá'₁ ca₂tiá₂ co₂lág₂, ia₁ juɨ₁la₂ 'ióg₃ dsɨ́'₂ dsa₂, 'ë₂ guë́₄ bá₄ 'nia'₂, dsa₂ i₂'én₂ ca₂juɨg₄, jmo₃ bá₄ Diú₄ 'í₁. ");
INSERT INTO cntNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jaun₂ juá'₅ jniá₂, tsá₃ i₁niog'₄ jua'₅₄ a₂ŋɨ́₄ dsan₂ 'au'₂ 'e₂ quë'₅₄ 'ag'₅₄. Tsá₃ can₂ 'nia'₂ o₂i₁ dsɨ₅ quian'₅₄ a₂jaun₂, ");
INSERT INTO cntNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ia₁ jmá'₃ a₂në₅ bá₄ a₂ŋɨ́₄ lë₃ 'nio'₃ dsɨ₂nau₂. Ia₁ i₂ŋi₅ bá₄ Ŋéi'₅ a₂'nió'₅ ca₂le₃jë́₃ a₂në₅ quián'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","La₁ 'nio'₂ de'₂ jŋiá₅ 'nia'₂ ja₁goin₂, jaun₂ ca₂le₃jë́₃ a₂në₅ të₁ja₃lé₂ a₂ma₂ŋag₅₄ cuë₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Nia'₂ já'₂ cha'₂ quiáng₃, tsá₃ lë₁jmo₂ 'nia'₂ gang'₃, o₁jŋia'₅₄ la₂ tsá₃ juɨn'₅ 'nia'₂, la₁ 'ŋio₂ dsɨ́₅ Ŋéi'₅ cuë₃ ja₁goin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","'Nag₄ 'nia'₂ a₂cha₂ quiáng'₂; jme₂'on₅₄ i₂te₂ŋé₂. Jŋia'₅₄ lia'₂ le₂në₅ bá₄ dsióg₄, të₃ron₅₄ të₂'mɨ'₂ a₂tsá₃ ton₅ jmɨg₄ le₃'áu₂ quián'₂ 'nia'₂; caun₂ a₂quen₅ lɨn₃ 'ó'₄ 'nia'₂ quiáng'₂ guei'₅₄ i₂juɨ́g₃ a₂tsá₃ ton₅ jmɨg₄ dsiá₃, ja₁tsá₃ lɨ́g'₂ jmɨg₄ dsióg₄ 'ang₂, on₃ guë'₂ i₁tsan'₅₄ lé₂ le₃'én₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ia₁ juɨ₁lia'₂ ja₁rë₂'mú'₄ 'nia'₂ quiáng'₂, ja₁jaun₂ bá₄ 'i₄ 'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Rë₂ján'₁ 'nia'₂ chang'₂, le₁lɨng'₄, le₁guí'₂ si₂ tsɨ́₅ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Juɨ₁len'₅₄ 'nia'₂ në₂jag₄ bá₄ dsa₂ i₂chi₁jŋia₅ guan'₂ juɨg₅₄ ŋó₃ ja₁niog₅ jmɨg₄. Rë₂ján'₁ 'nia'₂ chang'₂, ia₁jaun₂ lé₂ le₃na'₅₄ 'nia'₂ dsɨ₂juɨ₅ jë₁ma₂të́₂ rë₁guáin'₃ quein₃ o₄'né₄. ");
INSERT INTO cntNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","'E₂ guë́₄ dsen₃ dsa₂ i₂le₁ne₅₄ jë₁ma₂ca₂guán'₃ juɨg₅₄. A₂dsɨ₂jó'₃ juá'₅ jniá₂, 'ŋiog₅ bá₄ 'éi₂ dsiog₃ ne₄ mesa, ton'₂ quɨ́'₃ 'mɨ'₂ a₂jme₂ti₃ ŋág₃ má₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","'E₂ guë́₄ dsen₃ dsa₂ i₂tion'₅₄ le₁ne₅₄ jë₁ma₂ca₂jo₃ juɨg₅₄ o₁jŋia'₅₄ la₂ ca₂guáin'₃ a₂'uë₂ dsi₃nei₅, o₃ ma₂ca₂ŋɨ́₂ dsi₃nei₅ 'e₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","La₁ juɨ₁le₂ŋi'₅₄ 'nia'₂ a₂la₂ ján₃, jua'₅₄ mei'₂ guë́₃ ŋi₅ dsa₂ quió'₅ dsi₂néi₂ 'e₂ hora jiá₃ dsa₂ 'ang₂, guá₃ rë₂nei₅₄, jmo₂₃ 'í₁, tsá₃ cuë₃ jmɨg₄ 'í₂ dsa₂ 'éi₂, 'ang₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Le₂në₅ bá₄ 'nia'₂ ján₃, rë₂jáng'₁ chang'₂, ia₁ con'₂ tsá₃ 'ein₂ lɨ́n₂ bá₄, të₃tsɨn'₅₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jaun₂ në́₃ ca₂ŋag₃ Pe₄: ―Te₁gui'₅₄, ¿a₁në₂chei'₅₄ jmá'₃ jnia'₅₄ jág₁ jáng'₅ léi₄ në₅, o₃ a₂në₂chei'₅₄ ca₂le₃jɨ́n₃ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jaun₂ ca₂juá'₂ Te₁gui'₅₄: ―¿I₂'ein₂ 'éi₂, lɨ́n'₂ 'nia'₂, lɨ́n₅ dsa₂ dsen₃ i₂rë₂ti'₅₄, niog₅ dsi₄, i₂ca₂dsiog₃ juɨg₅₄ nio₃ ne₅₄ jmo₃ ta₁ dsi₂néi₂, a₂ag'₃ ŋɨi'₃ dsa₂ hora ca₂tɨ́in₂? ");
INSERT INTO cntNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'E₂ guë́₄ dsen₃ dsa₂ i₂niog₅ ne₄, i₂jo₅ juɨg₅₄ jme₂ti₃ bá₄ ta₁ quió'₅, i₁guain'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A₂dsɨ₂jó'₃ juá'₅ jniá₂, dsiog₃ juɨg₅₄ a₂nio₃ ne₅₄ ca₂le₃jë́₃ a₂cha₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","La₁ në₁jua'₂ lɨ́n₂ dsa₂ i₂niog₅ ne₄ 'éi₂, le₃'ag₄ bá₄ guan'₂ juɨg₅₄, chi₂jua'₂ ca₂jme₃lióg₃ ca₂jmái'₂ uɨg₅ dsa₂ ŋe'₂, dsa₂ mɨ́₂ në́₃ i₂jme₂ti₃ ta₁, ton'₂ 'ŋiog₅ guë'₂ ca₂'í₃ guë́'₅, 'ɨ́n'₂, ca₂rë₃'ein₅ bá₄ 'ŋiog₅, ");
INSERT INTO cntNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","la₁ con'₂ tsá₃ jáin₅, con'₂ caun₂ hora a₂tsá₃ ŋi₅ bá₄ guan'₂ juɨg₅₄; uɨg₅ gau₂ 'ŋio₅ lɨn₃ bá₄ cuë₃ 'éi₂, co₂jaun₂ bá₄ uɨg₅ gue₃ con'₂ lë́₅ tɨn₃ dsa₂ i₂tsá₃ 'én₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Juɨ₁lia'₂ dsa₂ i₂ŋi₅ 'e₂ 'nio₃ juɨg₅₄, la₁ tsá₃ 'e₂ co₂jŋia₅₄ jmo₂₃, on₃ guë'₂ jme₂ti₃ a₂juá'₂ 'éi₂, cán₂ uɨg₅ dsɨ₃bain₅₄ ca₂lia'₂ ton₅ 'mɨ₅ 'lióng₂ lɨn₃ nɨ₁ŋɨ₁₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","La₁ juɨ₁lia'₂ i₂tsá₃ 'e₂ ca₂rë₃ŋi₅ ton'₂ jmo₅-dsáu₅ cosa a₂ca₂tɨ́in₂ gue₃ uɨg₅, tsá₃ lɨn₅₄ 'lióng₂ 'mɨ₅ cán₂. Juɨ₁lia'₂ dsa₂ i₂'lióng₂ të₂no₄ gu₂ a₂ca₂tɨ́in₂ jme₃ti₃, ján₃ bá₄ 'lióng₂ a₂mág₃ juɨg₅₄. Ján₃ guë'₂ le₂jaun₂ juɨ₁lia'₂ i₂ma₂dsia₅ dsa₂ 'lióng₂ ne₅₄, 'lióng₂ guë́₄ a₂chi₃quióng₂ dsa₂ jmɨg₄ jáng'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’A₂i₃'ɨng₅₄ si₂ mɨ₂güɨ́g₃ la₂ bá₄ jniá₂ guio₃. ¡'E₂ guë́₄ 'ɨ́n₅ dsɨ₃, jua'₅₄ ma₂cau₂ bá₄ co₂ŋei'₅₄ të₂në₃! ");
INSERT INTO cntNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","La₁ tion₅₄ niog₅ tiáng₄ juɨ₅ ja₁dsɨ₃ŋɨ́g₂ mɨ'₅₄ 'ŋio₅ lɨn₃. Jaun₂, ¡'e₂ guë́₄ 'ŋio₅ o₂i₁ dsɨ₅ chang₂, ca₂lia'₂ ca₂rë₃ti₃ ta₁ a₂guio₃! ");
INSERT INTO cntNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Lɨ́n'₂ 'nia'₂ a₂guio₃ jniá₂ i₃'ei₃ tei₄ mɨ₂güɨ́g₃ la₂? On₃jua'₅₄ le₂jaun₂. A₂i₃jmo₃ le₁dson'₅₄ dsa₂ bá₄ jniá₂ guio₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ia₁ të₂le₃ ne₄ juɨ₅ ja₁dsau₅₄ në₅, juɨ₁lia'₂ caun₂ dsi₂néi₂ ja₁lë́₂ 'ŋiá₂ dsa₂, lé₂ le₁dson'₅₄, ");
INSERT INTO cntNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ún₂ jme₃'ŋiai₅₄ on₃; i₂on₃ jme₃'ŋiai₅₄ i₂ún₂ táng₃; juɨ₁lia'₂ jmei₂ dsa₂ tóin'₃ mɨ'₅₄ quian'₅₄ ja₁ŋi'₅₄, ja₁ŋi'₅₄ guë'₂ 'í₂ mɨ'₅₄ quian'₅₄ jmei₂; juɨ₁lia'₂ chog₅₄ tóin'₃ mɨ'₅₄ quian'₅₄ ja₁mɨ́g₄, ja₁mɨ́g₄ guë'₂ 'í₂ mɨ'₅₄ quian'₅₄ chog₅₄. Juɨ₁lia'₂ i₂lɨ́n₅ ma₂chog₅₄ dsa₂, tóin'₃ mɨ'₅₄ quian'₅₄ lo₅₄, juɨ₁lia'₂ mɨ₂lo₅₄ 'í₂ mɨ'₅₄ quian'₅₄ ma₂chog₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ján₃ bá₄ ca₂tsɨ́'₃ dsa₂: ―Jme₁cáun'₂ 'nia'₂ 'í₁ guei'₅₄ jme₁tsau₂ jnei₅ le₃ja₁rɨn₂ 'iog₂, jag'₄ 'nia'₂, jiá₃ jmɨ́₅, dsón'₂ bá₄ le₂jaun₂ lë́₂. ");
INSERT INTO cntNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jaun₂ jme₁ja₂ dsí₂ të₂le₃ sur, jag'₄ 'nia'₂ dséi₃ 'iog₂ në₃. Jaun₂ dsón'₂ bá₄ le₂jaun₂ lë́₂ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡'Nia'₂ dsa₂ i₂jŋia'₅₄ dse₃ le₁'ág₄ o₁ne₁! Ŋi'₅₄ 'nia'₂ 'a₂ lia'₂ jua'₅₄ 'e₂ niog₅ të₅ ne'₅₄ 'nia'₂ guei'₅₄, quian'₅₄ 'e₂ lë́₂ ne₄ gua'₅₄ 'uë₃. ¿'A₂ bá₄ lia'₂ tsá₃ tɨn'₂ 'nia'₂ caun'₅₄ 'í₁ léi₄ a₂ma₂cha₂ rë₂në́₃? ");
INSERT INTO cntNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿'E₂ lë₃ tsá₃ cáun'₂ 'nia'₂ 'í₁ jë₄ quiáng'₂ guiong'₅₄ a₂dsi₂ten₅₄ jmó'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jë₁ma₂'eng'₅₄ juɨ₅ dsióg'₄ ne₄ dsɨ₂tan₅₄ quian'₅₄ dsa₂ i₂'nag₅, jme₁jen'₂ 'nia'₂ jág₁ le₂'i₄ juɨ₅ jme₁dsian₅ mɨ'₅₄ a₂chang'₂ quiain'₅₄. Ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ ca₂tsag'₂ të₃ne₄ dsɨ₂tan₅₄ i₂qui₂dsɨ₅ 'éi'₃. 'Éi₂ në₃ jáng'₃ ne₄ 'lióg₂; 'lióg₂ guë́₄ në́₃ to'₂ né'₃ 'má₃. ");
INSERT INTO cntNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Juá'₅ jniá₂, o₁lɨ́g'₂ tsá₃ o₃'ɨng'₂ ja₁jaun₂ ca₂lia'₂ ca₂qui'₅₄ jë₁ca₂tó'₂ ŋí₁ guéin₂ a₂rɨng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jmɨg₄ jaun₂ i₂lɨn₅₄ dsa₂ i₂jme₁tion'₅₄ guë́₄ ca₂dsia₃ ca₂tsɨ́'₃ Jesús 'a₂ lia'₂ ca₂jme₃dsian₅ Pilato i₂lɨn₅₄ dsa₂ chan₂ Galilea. Ca₂cóin'₂ jmɨ₄ dsa₂ 'éi₂ quian'₅₄ jmɨ₄ já'₂ i₂ca₂jme₃dsian₅ dsa₂ i₂jéin'₂ ne₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jaun₂ ca₂juá'₂ Jesús në́₃: ―¿Lɨ́n'₂ 'nia'₂ në́₃, dsa₂ chan₂ Galilea 'éi₂ ca₂i₃ŋɨ́i₂ le₂jaun₂ ia₁ 'lióng₂ guë́₄ dso₄ jme₁le₁cáin'₄ lia'₂ con'₂ guë́₄ dsa₂ go₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Juá'₅ jniá₂, on₃jua'₅₄ le₂jaun₂; ia₁ le₂në₅ bá₄ 'nia'₂ ján₃, në₁jua'₂ tsá₃ ca₂dsi₃quén'₅ 'au'₂, dsiáng'₃ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿On₃ bá₄ lɨ́n'₂ 'nia'₂, 'ŋio₅ lɨn₃ guë́₄ jme₁le₁cán'₄ dso₄ dsa₂ i₂guia₃-jŋiá₂ i₂ca₂dsan₃ 'éi₂, lia'₂ con'₂ ca₂quɨ'₃ nɨ₁'ia'₂ ŋei₅ ja₁chei₂ Siloé, lia'₂ con'₂ guë́₄ ca₂le₃jɨ́n₃ i₂tián'₅ Jerusalén? ");
INSERT INTO cntNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Juá'₅ jniá₂, on₃jua'₅₄ le₂jaun₂; ia₁ ján₃ bá₄ le₂në₅ 'nia'₂, në₁jua'₂ tsá₃ ca₂dsi₃quén'₅ 'au'₂, dsiáng'₃ bá₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jaun₂ ca₂juá'₂ táng₃ Jesús jág₁ jáng'₅ léi₄ la₂: ―Jan₂ dsa₂ jme₁jnia₄ caun₂ 'ma₂ a₂'ag₅ mɨ́g₂ higo ja₁nau₂ quió'₅, jaun₂ ca₂i₁jag₅₄ chi₂jua'₂ ma₂le₁'ág₄ mɨ́g₂. Tsá₃ mɨ́g₂ cha₂ guë'₂ në́₃, jme₁dsióg₃. ");
INSERT INTO cntNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jaun₂ ca₂tsɨ́'₃ dsa₂ i₂jmo₅ 'í₁ ja₁nau₂ jaun₂: “Ma₂'nɨ₅ ŋi₂ guio₂₃ i₂jág₃ nɨ₁'ma₂ në₅ chi₂jua'₂ le₁'ág₄ mɨ́g₂, la₁ caun₂ tsá₃ mɨ́g₂ cha₂ bá₄ lia'₂ co₂ráun₂ guio₅₄. Qui'₅₄ co₂ŋei'₅₄. Tsá₃ ta₁ jmo₃ jŋia'₅₄ jme₂dsiá₃ 'o'₅₄ 'uë₃ bá₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","La₁ dsa₂ i₂jmo₅ 'í₁ ja₁nau₂ 'éi₂ në́₃ ca₂ŋag₃: “Te₁gui'₅₄, cuë₄ jmɨg₄ o₁dsi₅₄ guë́₄ caun₂ ŋi₂ la₂; jmo₅₄ dse₃ le₃lág'₃, tó'₄ 'mɨg₄ já'₂ në́₃, ");
INSERT INTO cntNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","o₁ne₄ chi₂jua'₂ 'ag₃ mɨ́g₂ ŋi₂ caun₂. Në₁jua'₂ tsá₃ 'e₂ mɨ́g₂ cha₂ i₁jáun₃, jaun₂ guë́₄ uɨ́n'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Caun₂ sa₅₄, jme₁'en₅₄ Jesús jme₂tɨin₂₃ dsa₂ dsi₂néi₂ guá'₅ sinagoga. ");
INSERT INTO cntNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ja₁jaun₂ jme₁'en₅₄ jan₂ 'io₅₄ i₂ma₂guia₃-jŋiá₂ ŋi₂ dso'₅₄. Ca₂jmóg'₂ jme₂dsí₂ 'lɨn'₅₄ rë₂guen'₂ mɨ₂ca'₅₄, jme₁ŋɨ₂₃ tsá₃ lé₂ néi'₃ rë₂. ");
INSERT INTO cntNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jme₁ca₂jág₂ Jesús, jaun₂ ca₂të₃, jaun₂ ca₂juá'₂: ―'Io₅₄, ma₂ca₂'lóng'₂ bá₄ dso₄ a₂jme₁lɨ́ng'₄. ");
INSERT INTO cntNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jaun₂ ca₂téi₂ gu₂. Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂néi'₃ mɨ₂ca'₅₄ 'io₅₄, jaun₂ ca₂jme₃juɨin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","La₁ dsa₂ i₂niog₅ ne₄ guá'₅ sinagoga, ca₂rë₃'néi₃ quian'₅₄ Jesús ia₁ ca₂jme₃'lióin₂ dsa₂ 'éi₂ të₃ jmɨg₄ sa₅₄. Jaun₂ ca₂tsɨ́'₃ dsa₂ i₂tion'₅₄: ―Jŋéi₂ jmɨg₄ bá₄ ca₂tɨ́n₂ dsa₂ jmo₃ ta₁; juɨ₁ja₂lén₂ 'ein₂ 'nio₃ 'lión₂ jë₄ semana, on₃jua'₅₄ rë'₂ jme₁sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jaun₂ ca₂ŋag₃ Te₁gui'₅₄ ca₂tsɨ́'₃ 'éi₂: ―¡'Nia'₂ dsa₂ i₂jŋia'₅₄ dse₃ le₁'ág₄ o₁ne₁! ¿Tsa₁ 'ein₂ 'nia'₂ chén'₂ ca₁juɨ₅ o₃ bú'₄ quián₅ jua'₅₄ tsá₃ dsɨ₃jiog₃ dsɨ₃'ein'₅₄ jmɨg₂ o₁jŋia'₅₄ lë́₅ sa₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ia₁ dsa₂ mɨ́₂ la₂, i₂lɨ́n₅ jan₂ tsɨ₁jon₂ Abraham; i₂së₃dsen₃ jme₁ma₂'nei'₂ ma₂guia₃-jŋiá₂ ŋi₂. Jaun₂ në́₃, ¿tsa₁ ca₂tɨ́in₂ chein'₂ ján₃ jŋia'₅₄ të₃ jmɨg₄ sa₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jme₁ca₂juá'₂ Jesús le₂në₅, ca₂rë₃gui'₅₄ bá₄, ca₂le₃jɨ́n₃ con'₂ dsa₂ i₂'iog₅₄. La₁ 'io'₂ jén'₅ të₅ dsɨ́₅ bá₄ dsa₂ i₂tion'₅₄, ca₂le₃jë́₃ a₂jlá'₁ jmo₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ca₂juá'₂ në́₃: ―¿'A₂ lia'₂ le₃juá'₄ lë́₅ ja₁gon₂ Diú₄? ¿'E₂ quian'₅₄ lé₂ le₃quɨ́ng₄? ");
INSERT INTO cntNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Lë́₅ juɨ₁lia'₂ mɨ́g₂ jon₂ nɨ₁'ma₂ mostaza a₂ca₂jne₃ jan₂ dsa₂ ja₁nau₂ quió'₅. Jaun₂ ca₂i₃cón₃ ca₂dsióg₃ ca₂lë₃ caun₂ nɨ₁'ma₂ pa₁; i₁tan₅ në́₃ ca₂tó'₂ tsag₅₄ gu₂ nei'₅₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ca₂juá'₂ Jesús le₂la₂ ján₃: ―¿'E₂ quian'₅₄ lé₂ le₃quɨ́ng'₄ lë́₅ ja₁gon₂ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lë́₅ juɨ₁lia'₂ lë́₅ levadura a₂co₂güɨ́n'₂ jan₂ 'io₅₄ jë₄ 'nɨ₅ tio'₅₄ 'ma₂ ti₁can₁ i₁ŋí'₄. Quian'₅₄ co₁séin'₄ levadura bá₄ guion'₂ ca₂le₃jë́₃ ti₁can₁. ");
INSERT INTO cntNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Lia'₂ con'₂ ma₂'ein₅₄ juɨ₅ a₂dsióg₄ Jerusalén, qui₂ca₂i₁jme₁tɨin₂₃ guë́₄ dsa₂ le₂tan₅₄ juɨg₂ te₁'i₁ ja₁ca₂ŋɨi₅. ");
INSERT INTO cntNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jaun₂ ca₂ŋag₃ jan₂ dsa₂: ―Te₁gui'₅₄, ¿me'₂ bá₄ dsa₂ i₂tɨ́n'₅? Jaun₂ ca₂ŋag₃: ");
INSERT INTO cntNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Quen'₂ 'nia'₂ bí₂ tióng'₂ juɨ₅ o₄'né₄ dsag₂; ia₁ juá'₅ jniá₂, juɨn₅ i₂'nio₃ tón'₃, la₁ tsá₃ le₃quɨ'₅₄ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ia₁ con'₂ tsá₃ ŋó₅ jë₁ma₂të́₂ rë₁náu₃ juɨg₅₄ dsi₂néi₂, jnéi₃ o₄'né₄, 'nia'₂ në́₃ i₂të₃tsɨng'₅₄ le₃ca₁'né₄, jme₁lióg'₄ to'₅₄ mɨ'₅₄ të́'₄: “¡Te₁gui'₅₄! Nia₄ o₄'né₄, tió'₄ jnia'₅₄.” 'Éi₂ në́₃ ŋag₃: “Tsá₃ cuɨ́n₅ jniá₂ 'nia'₂; tsá₃ guion₅₄ a₂já'₄ ja₂nó'₅ 'nia'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jaun₂ guë́₄ jme₁lióg'₄ 'nia'₂ jua'₅₄: “Jnia'₅₄ bá₄ la₂ i₂ma₂que₅₄ ma₂'ne'₅₄ co₂lë₅ quian'₅₄ 'ne₂; jua'₂ 'ne₂ bá₄ guë'₂ ca₂jme₁tag'₂ jnia'₅₄ jɨn₄ juɨn₅ dsa₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jaun₂ dsa₂ juɨg₅₄ dsi₂néi₂ në́₃, ŋag₃: “Ma₂në₂juá'₃ jniá₂ tsá₃ guion₅₄ i₂'ein₂ 'nia'₂. Cau₅ jŋia'₃ 'nia'₂ ca₂le₃jɨ́ng'₃ i₂jmo₅ dsó'₅ a₂'lɨg'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ja₁jaun₂ qui₂o₁'o'₄ o₁quɨ́g'₃ 'nia'₂ jan'₅₄, jë₁ma₂të́₂ rë₁jɨng'₅₄ Abraham, Isaac, Jacob, quian'₅₄ ca₂le₃jɨ́n₃ guë́₄ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, tioin'₅₄ ja₁gon₂ Diú₄, la₁ 'nia'₂ guë'₂ në́₃, dsɨ₃gang'₅₄ uɨ́ng₂. ");
INSERT INTO cntNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ia₁ qui₂ja₃len₅ i₂chan₂ ca₂taun₂ ca₂taun₂ mɨ₂güɨ́g₃ ja₃tiain'₂ guë́'₃ co₂dsia₅ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","La₁ lé₂, chan₂ i₂lɨn₅₄ i₂tión₂ le₃jë₁ca₂tó'₂, të₃tsɨin'₅₄ le₃ne₄ juɨ₅; i₂tión₂ le₃ne₄ juɨ₅ rë₂në́₃ guë'₂ në́₃, të₃tsɨin'₅₄ le₃jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hora jaun₂ dé₄ dsi₃lén₂ i₂lɨn₅₄ dsa₂ fariseos, ca₂juá'₂: ―Co₂ŋei'₅₄ dse₃ jú₅ ja₁lá₃, quian₂ juɨ₅ quiáng'₂, ia₁ 'nio₃ Herodes jŋag'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―O₂nó'₅ 'nia'₂, o₂chei'₅₄ dsɨ₂ma₂jág₂ 'éi₂: “Ŋí₂, la₂ bá₄ 'ú₄, në₃, 'ióg₃ në́₃; në₃ bá₄ guë́₄ 'uɨng'₅₄ jme₂dsí₂ je₂na'₅₄ quió'₅ dsa₂, në₃ guë́₄ qui₂jme₁'liong₅₄ dsa₂. 'Ióg₃ caun₂ guë́₄ 'ŋia₅ quió₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","A₂caun₂ jmo₅₄ bá₄ jniá₂ ta₁ a₂ca₂tɨ́ng₂ jmo₅₄ të₁lia'₂ chang₂, ia₁ tsá₃ lé₂ le₃jón₂ jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄ uɨ́ng₂ ja₁lë́₄ juɨg₂ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡'Nia'₂ dsa₂ juɨg₂ Jerusalén! ¡'Nia'₂ dsa₂ juɨg₂ Jerusalén, 'nia'₂ i₂jme₂dsiáng'₁ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄, 'nia'₂ i₂qui₂jnag'₅₄ cang₄ dsa₂ i₂chen₅ Diú₄ jɨn'₄ 'nia'₂! ¡'Lióng₂ ráun₂ jme₁'ɨ́n₅ dsɨ₃ jme₁chi₁liang'₂ chi'₂-guein₂ juɨg₂ la₂ quiáng'₂, juɨ₁lia'₂ jmo₅ i₁tsɨ́n'₃ a₂chi₂lain'₂ guein₂ quiáin₅ to'₂ né'₃ tsɨ₁rë₂cu₅, la₁ guion'₅₄ 'nia'₂ tsá₃ ca₂gue'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ŋí₂ në́₃, të₃tsɨ'₅₄ chi₁güɨ́g'₂ dsi₂néi₂ quiáng'₂. Juá'₅ jniá₂, o₁lɨ́g'₂ tsá₃ ma₃jag'₅₄ jniá₂, ca₂lia'₂ ca₂të́₂ jmɨg₄ ja₁jua'₅₄ 'nia'₂: “Juɨ₁le₂jŋió₃ i₂në₅ i₂já₅ o₄quió'₄ Te₁gui'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Co₂ráun₂ guë'₂ ca₂lë₃ táng₃ caun₂ jmɨg₄ sa₅₄ a₂ca₂ŋó₃ Jesús i₃guë́'₃ ja₁quió'₄ jan₂ dsa₂ dsen₅₄ quián₅ dsa₂ fariseos; i₂lɨn₅₄ guë'₂ dsa₂ fariseos sián'₂ a₂jŋia'₅₄ tiog₂₃ bá₄ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ja₁jaun₂ jme₁'en₅₄ jan₂ dsa₂ dso'₅₄ i₂guion₂. ");
INSERT INTO cntNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jaun₂ ca₂ŋag₃ Jesús ca₂tsɨ́'₃ të₅juá'₅ quian'₅₄ dsa₂ fariseos, ca₂juá'₂: ―¿'I₄ 'éi'₃, o₃ tsá₃ 'i₄ 'éi'₃ jme₃'lión₂ dsa₂ dsa₂ dso'₅₄ jme₁jmɨg₄ sa₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","La₁ tei₄ bá₄ i₃léin₂, tsá₃ 'e₂ ŋi₅ ŋag₃. Jaun₂ ca₂jŋai'₃ dsa₂ dso'₅₄, ca₂jme₃'lió₂. Jaun₂ ca₂dsióg'₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ 'éi₂: ―¿I₂'ein₂ 'nia'₂, tsá₃ dsɨ₃dsen₅ dsɨ₂juɨ₅ chi'₂ quián₅, o₃ jan₂ ca₁juɨ₅ 'e₂ në₁jua'₂ ca₂táin'₂ né'₃ táu₃ jŋia'₅₄ të₃ jmɨg₄ sa₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","La₁ tsá₃ ca₂tió'₃ ŋag₃ jág₁ në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jme₁ca₂të́₂ ne₄ Jesús 'a₂ lia'₂ quió'₅ dsa₂ i₂té₄ jmá'₃ lia'₂ ja₁dsen₅₄ guë́₄ ja₁tiain'₂, jaun₂ ca₂cuë₃ jág₁ a₂jáng'₅ léi₄ la₂: ");
INSERT INTO cntNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Në₁jua'₂ 'ein₂ të́₂ ja₁niog₅ jmɨg₄ jen'₂ gu₂ dsa₂, tsá₃ ne'₅₄ juɨ₁lia'₂ ja₁dsen₅₄, ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ ca₂dsióg₃ jan₂ i₂dsen₅₄ guë́₄ lia'₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ia₁ ¿'e₂ bá₄ lé₂ në₁jua'₂ dsa₂ i₂në₂té₂ le₂on'₃ 'nia'₂ juá'₂: “I₂la₂ cuë'₅₄ ja₁ŋéi'₂”? Jaun₂ të₃ ma₂gueng'₅₄ bá₄ gog'₅₄ o₁né'₂ të₂ jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","La₁ juá'₅ jniá₂, chi₂jua'₂ lɨ́g'₂ në₁'ein₂ ca₂të₃, të₂le₃ jë₁ca₂tó'₂ bá₄ ne'₅₄, ia₁jaun₂ dsa₂ i₂në₂té₂ lé₂ le₃juá'₂: “A₂mei₅₄ quiáng₃, ja₁dsen₅₄ guë́₄ la₂ i₂né₂.” Jaun₂ le₂në₅ bá₄ jme₃juag'₂ dsa₂ i₂quë́'₂ quiang'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ia₁ juɨ₁lia'₂ dsa₂ i₂jme₂can'₅₄ guion₅₄, sióin₃ të₂le₃ jë₁ca₂tó'₂; dsa₂ i₂jmo₅ me'₂ guë'₂ në́₃, roin'₂ guei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jaun₂ ca₂tsɨ́'₃ ján₃, dsa₂ i₂ca₂të₃ 'éi₂: ―Jë₁ma₂të́₂ rë₁'niog'₂ jmó'₂ caun₂ má₃ a₂ŋɨg'₅₄ dsa₂, tsá₃ të'₅₄ juɨ₁lia'₂ dsa₂ a₂mei₅₄ quiáng'₂, on₃ guë'₂ juɨ₁lia'₂ i₂lɨ́n₅ o₁rɨ́ng'₂, on₃ guë'₂ juɨ₁lia'₂ i₂cha₂ cu₄ tián'₅ cau₅ quiáng'₂ në́₃. Ia₁ con'₂ tsá₃ ŋó₅, dsa₂ le₂'éi₂, lé₂ le₃të́₂, a₂jéin'₃ táng₃ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jaun₂ në́₃, në₁jua'₂ 'niog'₂ jmó'₂ caun₂ jmɨg₄, te'₂ jmá'₃ lia'₂ dsa₂ te₂ŋé₂, dsa₂ 'lian'₂, dsa₂ ten₄, dsa₂ guian'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jaun₂ le₂në₅ bá₄ le₃chang'₂ dse₃. Ia₁ dsa₂ 'éi₂ në́₃, tsá₃ quɨ'₅₄ jmɨg₄ le₃jéin'₃ quiáng'₂, la₁ i₁jáun₃ bá₄ tɨ́ng'₄ quiáng'₂, i₁jen'₅₄ ca₂le₃jɨ́n₃ dsa₂ dsen₃. ");
INSERT INTO cntNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jan₂ dsa₂ i₂jme₁guá₄ cau₅ i₂ca₂nág₂ jág₁ në₅, ca₂tsɨ́'₃ Jesús: ―'E₂ guë́₄ dsen₃ i₂tian'₃ guë́'₃ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jaun₂ ca₂juá'₂ Jesús: ―Jme₁chan₂ jan₂ dsa₂ i₂ca₂cuë₃ caun₂ má₃ pa₁, jaun₂ ca₂të́'₃ juɨn₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jme₁ca₂të́₂ hora a₂nio₃ jmɨg₄ në́₃, ca₂chein₃ dsa₂ i₂jme₂ti₃ ta₁ ne₅₄, i₁chi'₄ dsa₂ i₂ma₂lë́₅ jág₁ dsi₁lén₂: “I₂nó'₅ 'nia'₂, ia₁ ma₂lë́₅ co₂jŋia₅₄ ca₂le₃jë́₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","La₁ ca₂le₃jɨ́n₃ bá₄ ca₂juá'₂ tsá₃ jɨin₅₄. I₂le₂'uɨg₅₄ ca₂ŋag₃: “Caun₂ 'uë₃ lia'₂ në₂lá₂; ja₁jaun₂ nei₅₄ i₁jág₃. 'Én₃ dso₄ quió₃ tsá₃ lé₂ nei₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","I₂sián'₂ guë'₂ táng₃ ca₂juá'₂: “'Ŋiá₂ dsán'₃ ca₁juɨ₅ i₂quia'₂ 'uë₃ i₂të₂ca₂láng₂, i₂'éi₂ nei₅₄ i₁quión₃ 'í₁ chi₂jua'₂ ma₂téin₅ jmo₃ ta₁. 'Én₃ dso₄ quió₃ tsá₃ lé₂ nei₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","I₂sián'₂ guë'₂ ca₂juá'₂ táng₃: “Gu₃ lia'₂ në₂jeng'₅₄; jaun₂ lë́₃, tsá₃ lé₂ nei₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jaun₂ jme₁dsián'₃ mozo 'éi₂ ca₂jmóg'₃ jág₁ ne₄ juɨg₅₄, jaun₂ ca₂rë₃'né₃ bá₄ juɨg₅₄. Jaun₂ ca₂juá'₂ tsɨ́'₅ táng₃ mozo 'éi₂: “Co₂chi'₅₄ o₂ŋɨ₄ jë₄ calles, le₂tan₅₄ ja₁le₁ŋɨ'₂ dsa₂ juɨn₅ jë₄ juɨg₂, qui₂o₂quian₅ dsa₂ te₂ŋé₂, dsa₂ 'lian'₂, i₂guian'₅₄, i₂ten₄ në́₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jme₁co₂lág₂ jaun₂, ca₂juá'₂ dsa₂ mozo 'éi₂: “Gui'₅₄, ma₂në₂jmo₃ con'₂ lë́₅ në₂jua'₅₄. Jo₂ bá₄ guë́₄ dsi₂néi₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jaun₂ ca₂juá'₂ táng₃ juɨg₅₄: “Gua₂ táng₃ jë₄ calles le₂tan₅₄ ja₁lë́₄ o₄juɨ₅, o₂quian₅ tion₅₄ dsa₂ i₂jeng'₂, jaun₂ can'₂ dsi₂néi₂ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ia₁ le₂në₅ bá₄ juá'₅ jniá₂, 'i₁jan₂ i₂jme₁lë́₄ jág₁ ca₂të́₃ le₂'uɨg₅₄ 'éi₂, tsá₃ quein'₃ jë₄ jmɨg₄ quió₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Juɨn₅ lɨn₃ dsa₂ i₂jme₁ma₂quian'₅₄ Jesús. Jaun₂ ca₂jéin'₃ ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Chi₂jua'₂ 'ein₂ 'ei₅ dsɨ́₅ jme₃quiong'₅₄ jniá₂, në₁jua'₂ tsá₃ ca₂tén'₃ dsɨ́₅ téin₂ jmei₂, chog₅₄, dsa₂ mɨ́₂ quiáin₅, chi'₂-guein₂ quiáin₅, ca₂le₃jɨ́n₃ guë́₄ o₁rɨin'₅₄ në́₃; në₁jua'₂ tsá₃ ca₂tén'₃ dsɨ́₅ le₂jiog₅ jme₂dsí₂ quió'₅ në́₃, tsá₃ lé₂ le₃léin₂ dsa₂ quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jua'₅₄ 'ein₂ tsá₃ ca₂tén'₃ dsɨ́₅ gue₃ 'mú₃, jiá₃ chi₁co'₅₄ quió'₅, tsá₃ lé₂ le₃léin₂ dsa₂ quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jua'₅₄ mei'₂ guë́₃ chan₂ jan'₂ 'nia'₂ i₂'nio₃ chi'₃ caun₂ nɨ₁'ia'₂ ŋei₅, ¿on₁ jŋiá₅ de'₂ con₂ 'í₁ chi₂jua'₂ ma₂len₅ cu₄ quió'₅ ca₂lia'₂ a₂'ió'₄ a₂jaun₂? ");
INSERT INTO cntNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ia₁ në₁jua'₂ tsá₃ le₂jaun₂, jme₃lióg₃ 'uɨg₅₄ 'ia'₂, tsá₃ tió'₅ guë'₂ jme₃'ió'₃, ca₂le₃jɨ́n₃ dsa₂ i₂jág₃ a₂jaun₂, a₂lë₁co₂jmóg'₂ co₃ŋág₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Dsia₃: “Dsa₂ në₅ con'₂ jŋia'₅₄ ca₂jme₃lióg₃ 'uɨg₅₄, la₁ tsá₃ guë'₂ quɨ'₅₄ jmɨg₄ jme₃'ió'₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O₃ juɨ₁lia'₂ jan₂ rag₅₄ guë'₂, i₂jmo₃ 'nei₂ quian'₅₄ jan₂ rag₅₄ sián'₂, ¿tsa₁ jŋiá₅ de'₂ guá₃ con₂ 'í₁ chi₂jua'₂ tió'₅ quian'₅₄ guian₃ mei₅ 'lióg₂ quiáin₅, dsɨ₃quɨ́in'₂ quian'₅₄ guión₂ mei₅? ");
INSERT INTO cntNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chi₂jua'₂ ma₂lí'₄, tsá₃ tió'₅ në́₃, të₁lia'₂ uɨ́ng₂ guë́₄ já₅ rag₅₄ jan₂, chein₃ dsa₂ i₂quian₅ jág₁ a₂mɨ₂₃ dsian₅ co₂ŋei'₅₄ mɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Le₂në₅ bá₄ chi₂'ein₂ 'nia'₂ i₂tsá₃ ca₂tén'₃ dsɨ́₅ tí₂ ca₂le₃jë́₃ a₂cha₂ quió'₅, tsá₃ lé₂ le₃léin₂ dsa₂ quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’(Juɨ₁lia'₂ dsa₂ i₂quian'₅₄ jniá₂ lɨ́in₅ juɨ₁lia'₂ lë́₅ tsɨ₁ŋi₁.) A₂dse₃ bá₄ tsɨ₁ŋi₁ të₁lia'₂ ŋi'₅₄. La₁ në₁jua'₂ ca₂'en₃ ŋi'₅₄ në́₃, ¿'a₂ bá₄ lia'₂ lé₂ le₃lei₂ táng₃? ");
INSERT INTO cntNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tsá₃ ma₃'e₂ ta₁ tí₄, on₃ guë'₂ lé₂ le₃lé₂ gua'₅₄, on₃ guë'₂ ma₂tí₅ ta₁ jua'₅₄ a₂le₃lé₂ ca₂bë'₅₄ 'o'₅₄. Jŋia'₅₄ lia'₂ a₂dsɨ₃ga'₅₄ uɨ́ng₂ bá₄. I₂dsi₅₄ gua₄, rë₂ juɨ₁nei₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ca₂le₃jɨ́n₃ dsa₂ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄, quian'₅₄ guë́₄ dsa₂ i₂le₁cán'₄ dso₄ sián'₂, ca₂o₃léin₂ ja₁'en₅₄ Jesús, a₂o₃néi₃. ");
INSERT INTO cntNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'Uɨg₅₄ jaun₂, dsa₂ fariseos quian'₅₄ të₅juá'₅ ca₂chi₂ca₂'ɨin₃ Jesús. Ca₂juá'₂: ―Dsa₂ në₅ qui₂guein₂₃ bá₄ dsa₂ i₂le₁cán'₄ dso₄, guë́'₅ co₂lë₅ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jaun₂ lë₃ ca₂juá'₂ Jesús jág₁ jáng'₅ léi₄ la₂: ");
INSERT INTO cntNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―¿I₂'ein₂ 'nia'₂, juɨ₁lia'₂ i₂'ŋio₅ caun₂ 'ŋiá₂-lón₂ já'₂ cha'₂, në₁jua'₂ ca₂i₃cón'₅ jan₂, tsa₁ ja₁co₂'ŋiog₅ jaun₂ toin'₂ i₂quéin'₂ ne₂guión₂ rë₂dsɨ́₂ guia₃-né₂ (99) con'₂ i₂te₂, dsó₃ táng₃ dsɨ₂juɨ₅, dsɨ₂'niai'₂ i₂jan₂ i₂i₃cón'₅ 'éi₂, 'nau'₂ ca₂lia'₂ ca₂dsáu'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jë₁ma₂ca₂dsáu'₂ në́₃, të₂ juɨ₅ co₁dsi₁₂, jóin'₅ táng₃ 'io'₂ jén'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jë₁ma₂dsiáin'₃ dsi₂néi₂ në́₃, ŋɨ́i'₂ ca₂le₃jɨ́n₃ a₂mei₅₄ quiáin₅, quian'₅₄ guë́₄ dsa₂ i₂tián'₅ cau₅ quió'₅. Jaun₂ juá'₂: “Në₃ o₁tió'₄, jmó₁ 'io'₂ quian'₅₄ jniá₂, ia₁ dsán'₅ bá₄ já'₂ cha'₂ i₂jme₁ma₂i₂cón'₅ quiáng₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Juá'₅ jniá₂, 'ŋio₅ lɨn₃ guë́₄ bá₄ cha₂ o₂'ŋió₃ dsɨ₅ guei'₅₄ i₂juɨ́g₃ o₄quió'₄ jan₂ dsa₂ i₂rë₂cán'₄ dso₄, i₂dsɨ₂quén'₅ dsɨ́₅, lia'₂ con'₂ guë́₄ o₄quió'₄ i₂quéin'₂ ne₂guión₂ rë₂dsɨ́₂ guia₃-né₂ (99) dsa₂ “dsen₃” i₂tsá₃ 'e₂ 'nió'₅ jme₃tsɨ́n₃ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’O₃ juɨ₁lia'₂ jan₂ dsa₂ mɨ́₂ i₂'io₅ guia₃ cu₄ 'ua'₂, në₁jua'₂ ca₂i₃có'₅ caun₂, ¿tsa₁ téi₂ si₂, 'iá'₂ dse₃ lɨn₃ dsi₂néi₂, 'no'₂ ca₂lia'₂ ca₂dsó'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jë₁ma₂ca₂dsó'₂ në́₃, jmo₂₃ 'io'₂, ŋɨ́i'₂ 'io₅₄ a₂mei₅₄ quiáin₅, i₂tián'₅ cau₅ quió'₅ në́₃, jaun₂ juá'₂: “Në₃ o₁jmó₁ 'io'₂ quian'₅₄ jniá₂, ia₁ dsó'₅ bá₄ cu₄ a₂jme₁ma₂i₂'ág₃ quió₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jaun₂ le₂në₅ bá₄ juɨ́g₂ jniá₂ 'nia'₂, chan₂ o₂'ŋió₃ o₂jŋia₃ dsɨ₅ ángeles quián₅ Diú₄ o₄quió'₄ jan₂ dsa₂ i₂rë₂cán'₄ dso₄, i₂ma₂ca₂dsi₃quén'₅ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ca₂juá'₂ Jesús ján₃: ―Jan₂ dsa₂ jme₁chan₂ on₃ ja₁ŋi'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","I₂lɨ́n₅ i₂me'₂ guë́₄ ca₂tsɨ́'₃ jmei₂: “Tia₅₄, cuë₄ ca₂dsio₄ cu₄ quiáng'₂ con'₂ ca₂tɨ́ng₂.” Jaun₂ jmei₂ në́₃ ca₂dsió'₃ 'e₂ a₂cha₂ quió'₅, jma₃quén₅ ca₂cuë́'₃ chi'₂ quiáin₅ con'₂ ca₂tɨ́in₂. ");
INSERT INTO cntNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mei'₂ bá₄ cang₂ jaun₂, dsó₂ i₂me'₂ guë́₄ qui₂ca₂'nag₃ a₂jme₁ma₂lë́₅ quió'₅. Quian'₅₄ cu₄ jaun₂ ca₂'í₃ juɨ₅ i₁ŋɨ₂ uɨ́ng₂ caun₂ 'uë₃ siá'₂. Ja₁jaun₂ ca₂i₁'éin₄ jë₂ cu₄ quió'₅, tsá₃ 'en₅₄ dsɨ́₅ ca₂rë₃cháin₃. ");
INSERT INTO cntNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jme₁ma₂dsó'₃ jë₂ cu₄ në́₃, 'ŋio₅ lɨn₃ ca₂rë₃'ɨ́n₃ a₂guë́'₃ dsa₂ juɨg₂ jaun₂. 'Eí₂ në́₃ ma₂ŋɨ₂₃ 'oin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jaun₂ ŋó₃ i₃'nióg₂ ta₁ a₂jmo₃ quió'₅ dsa₂ juɨg₂ jaun₂. Jaun₂ dsa₂ 'éi₂ në́₃ ca₂chei₃ ja₁nau₂ quió'₅ a₂ŋɨi'₃ i₁ŋí₅. ");
INSERT INTO cntNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jë₁ma₂të́₂ rë₁guë́'₃ i₁ŋí₅, ca₂lia'₂ ma₂le₃guë́'₃ 'ŋiog₅ cuá'₁ tsɨ₁rë₂jnei₂ a₂guë́'₅ já'₂, la₁ 'i₁jan₂ tsá₃ 'ein₂ ca₂cuë₃ a₂guë́'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jaun₂ ca₂i₃jŋia₅ dsɨ́₅: “¡Të₁lia'₂ juɨn₅ mozos i₂'ŋio₅ ŋe'₃, cha₂ qui₂rë₂tsón₂ a₂guë́'₅, jniá₂ në́₃ ja₁lá₃ jŋɨ́g'₅ dsɨ₃ 'ong₅₄! ");
INSERT INTO cntNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","'Ag₅₄ caun₂ dsɨ₃, nég'₄ táng₃ dsi₂néi₂ quió'₅ ŋe'₃. Juɨg₅₄ le₂la₂: Tia₅₄ quiáng₃, 'e₂ guë́₄ juë'₂ dso₄ ca₂'no₃ ne₄ Diú₄ quian'₅₄ ja₁cong'₂; ");
INSERT INTO cntNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","jŋia'₅₄ tsá₃ ma₃ca₂tɨ́ng₂ a₂të́'₄ jniá₂ jón₃. La₁ jag₄ jniá₂ lia'₂ ja₁jɨng'₅₄ jan₂ dsa₂ i₂tion₄ quiáng'₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jaun₂ ca₂nau₂ ca₂'í₃ juɨ₅ jóin'₃ táng₃ quió'₅ jmei₂. La₁ uɨ́ng₂ bá₄ guë́₄ jóin'₅, jme₁ca₂jág₂ jmei₂. Ca₂tá'₂ ŋéi₂ dsɨ́₅, ca₂ŋó₃ co₂chi'₅₄, ca₂cág'₃ cu₅ ca₂chen'₃ quió'₅ 'io'₂ jén'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jaun₂ guë́₄ ca₂juá'₂ ja₁ŋi'₅₄: “Tia₅₄ quiáng₃, 'e₂ guë́₄ juë'₂ dso₄ ca₂'no₃ ne₄ Diú₄ quian'₅₄ ja₁cong'₂; jŋia'₅₄ tsá₃ ma₃ca₂tɨ́ng₂ a₂të́'₄ jniá₂ jón₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","La₁ jmei₂ në́₃, ca₂tsɨ́'₃ dsa₂ i₂jme₂ti₃ ta₁ tion'₅₄ quiáin₅: “¡Ma₂në₃ co₂chi'₅₄! O₂dsi₄ 'mɨ'₂ a₂lë́₅ a₂dse₃ guë́₄, queng'₅₄ chi'₂ quiáng₃; caun₂ guë'₂ anillo tio'₂ chi₁gú₃. Co₂dsán'₃ guë'₂ nɨ₁lau₂ to'₅₄ 'nia'₂ tag₅₄; ");
INSERT INTO cntNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jaun₂ o₁te'₄ 'nia'₂ ca₁juɨ₅ i₂ma₂'on'₅₄ chén'₅, jaun₂ jŋɨ́i'₄ 'nia'₂. ¡Jaun₂ que₅₄, tió'₄ jmó₁ 'io'₂! ");
INSERT INTO cntNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ia₁ chi'₂ në₅ quiáng₃, në₂jag₄ i₂jme₁ma₂jon₅ bá₄ në₅, la₁ chain₂ bá₄; jme₁ca₂i₃cóin'₅, la₁ ma₂dsáin'₅ bá₄.” Jaun₂ ca₂jme₃lióg₃ jmɨg₄ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Të₁lia'₂ jaun₂, chi'₂ ja₁ŋi'₅₄ i₂lɨ́n₅ i₂juɨn'₂ guë́₄, jme₁'ein₅₄ ja₁nau₂. Jme₁ma₂ja₂quián₃ guain'₂ dsi₂néi₂, ca₂nág₂ i₁niog₅ son₅₄ i₁dsan₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jaun₂ ca₂të́'₃ jan₂ dsó₂ ca₂ŋag₃ 'e₂ niog₅ lë́₂. ");
INSERT INTO cntNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jaun₂ juá'₂ 'éi₂: “Dsó₂ rɨ́ng'₂ bá₄ guán'₅, jaun₂ ŋéi'₅ në́₃ në₂jmo₃ 'éi'₃ në₂jŋɨ'₃ dsa₂ ca₁juɨ₅ i₂jme₁chén'₄ 'on'₅₄, ia₁ guáin'₅, dsein₃ bá₄, tsá₃ 'e₂ lɨ́in₅.” ");
INSERT INTO cntNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","La₁ ca₂rë₃'né₃ bá₄ rɨin'₅₄ i₂juɨn'₂ 'éi₂. Tsá₃ 'nio₃ 'í₂ dsi₂néi₂; jaun₂ ca₂o₃'ɨ́n₃ jmei₂, ca₂juá'₂ jág₁ 'ua₁. ");
INSERT INTO cntNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","La₁ 'éi₂ në́₃ ca₂ŋag₃ ca₂tsɨ́'₃ jmei₂: “Ca₂le₃jë́₃ ŋi₂ ma₂guio₃ gua₅₄ jme₃tí₂ ta₁ ne'₅₄, tsá₃ lɨ́g'₂ jua'₅₄ ma₂jmo₃ tsá₃ nag₅₄ ja₁cong'₂. Ca₂lia'₂ jŋia'₅₄ jan₂ chein₂ lau₂ bá₄ tsá₃ ma₂cuag'₅₄ jniá₂ jua'₅₄ jmo₅₄ jmɨg₄ quian'₅₄ a₂mei₅₄ quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Në₃ guë́₄ tɨng'₂ jmó'₂ jmɨg₄ ia₁ guán'₅ ja₁ŋí'₄ në₅, i₂lë₁qui₂i₁'én₄ cu₄ quiáng'₂, qui₂i₁ŋɨ₂ lia'₂ lë́₂ dsɨ́₅ quian'₅₄ 'io₅₄ ga₂. Në₃ në́₃, jmɨg₄ jmo'₂ o₄quió'₄, jŋɨ́g'₅ ca₁juɨ₅ i₂'on'₅₄ guë́₄ jme₁chén'₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jaun₂ ca₂ŋag₃ jmei₂: “Jón₃, ma₁ co₂tan₅₄ bá₄ ŋéi'₂ 'ne₂ quian'₅₄ jniá₂; a₂quián'₂ 'ne₂ bá₄ ca₂le₃jë́₃ a₂cha₂ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","La₁ në₃ në́₃ co₂në₅ ca₂tág₂ jmó₁ jmɨg₄, quián₁ o₂'ŋió₃ dsɨ₅, ia₁ guán'₅ rɨ́ng'₂, në₂jag₄ i₂jme₁ma₂jon₅, la₁ në₃ ma₂chain₂ bá₄ táng₃; jme₁ca₂i₃cóin'₅, la₁ ma₂dsáin'₅ bá₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ca₂juá'₂ Jesús ján₃ ca₂tsɨ́'₃ dsa₂ i₂quiain'₅₄: ―Jme₁chan₂ jan₂ dsa₂ cha₂ cu₄ jme₁'ŋioi₂₃ jan₂ dsa₂ i₂niog₅ gu₂ dsi₂néi₂ quió'₅; la₁ ca₂i₁dsia₂ jan₂ dso₄, ia₁ juá'₂ a₂lë₁jme₁qui₂'én₂ 'éi₂ a₂cha₂ quió'₅ juɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jaun₂ ca₂të₃ juɨg₅₄ ca₂juá'₂: “¿I₂'e₂ bá₄ jág₁ në₅ nag₂₃ quián'₂ 'ne₂? Jang'₅₄ cuentas quiáng'₂, ta₁ a₂lɨ́ng'₅, ia₁ ja₁lá₃ jŋia'₃ ta₁ a₂niog₅ gog'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jaun₂ dsa₂ 'éi₂ në́₃ ca₂'náu'₃ dsɨ́₅: “¿'E₂ bá₄ jmo₅₄ jniá₂? Jŋiá'₂ juɨg₃ ta₁ quió₃. Tsá₃ béng₂ jua'₅₄ jmo₅₄ ta₁ ja₁nau₂, ján₃ guë'₂ gui'₄ jniá₂ jua'₅₄ a₂lë₁mɨ₁₂ jme₃'o₅₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ma₂guion₄ 'a₂ lia'₂ jmo₅₄ ia₁jaun₂ guei₃ dsa₂ sián'₂ dsi₂néi₂ quió'₅ jë₁ma₂të₁tsɨng'₅₄ tsá₃ ta₁ cha₂ jmo₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jaun₂ ca₂të́'₃ të₃ qui₂ján₃ dsa₂ i₂jme₁le₁rɨ́n₃ quió'₅ juɨg₅₄. I₂le₂'uɨg₅₄ ca₂tsɨ́'₃: “¿Je₂liá'₂ rɨng'₂ quió'₅ gui'₅₄?” ");
INSERT INTO cntNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jaun₂ ca₂juá'₂ 'éi₂: “Caun₂ 'ŋiá₂-láu₂ ba₂rɨg₅₄ no'₅₄.” Jaun₂ juá'₂: “La₂ ron₅ si₂ ja₁ton₅ con'₂ a₂rɨng'₂. Né₂, ma₂në₃ jmo₄ táng₃ caun₂ a₂siá'₂, tió'₃ jŋia'₅₄ të₂láu₃-guiá₂ bá₄ taun'₅₄ a₂le₃rɨng'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jaun₂ ca₂tsɨ́'₃ táng₃ jan₂ i₂sián'₂: “'Ne₂ guë'₂, ¿je₂liá'₂ rɨng'₂?” Jaun₂ juá'₂: “Caun₂ mei₅ 'ma₂ cuɨg₂.” Jaun₂ ca₂ŋag₃: “Jón'₅ si₂ ja₁ton₅ a₂rɨng'₂; jmo₄ táng₃ caun₂ a₂siá'₂ tió'₃ quéin'₂ co₂ne₂guióg₂ bá₄ taun'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Juɨg₅₄ në́₃, rë₂ bá₄ ca₂'ɨin₃ dsa₂ i₂tsá₃ ca₂rë₃ti'₅₄ 'éi₂, ia₁ 'ŋioi₅₄ ca₂jmo₃. Ia₁ ja₂lɨn₃ guë́₄ bá₄ 'ŋio₅₄ juɨ₁lia'₂ dsa₂ mɨ₂güɨ́g₃ jmɨg₄ në₃, lia'₂ con'₂ guë́₄ chi'₂-guein₂ i₂i₂nio₄ ja₁jniá₂ si₂. ");
INSERT INTO cntNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jaun₂ juɨ́g₂ jniá₂ 'nia'₂, 'nio'₂ 'nia'₂ juɨ₅ 'a₂ lia'₂ léng'₂ a₂mei₅₄ quian'₅₄ cu₄ cha₂ mɨ₂güɨ́g₃ 'lɨg'₅₄ la₂, ia₁jaun₂ jë₁ma₂ca₂dsa₃ cu₄, chan₂ bá₄ i₂le₃guéi'₂ 'nia'₂ ja₁o₁tiáng'₂ dse₃ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Juɨ₁lia'₂ i₂rë₂ti'₅₄ rë₂ quian'₅₄ ca₂juɨg₄ a₂të₂no₄ gu₂, ján₃ bá₄ le₂jaun₂ rë₂ti'₅₄ quian'₅₄ 'lióng₂. Le₂jaun₂ guë'₂ juɨ₁lia'₂ dsa₂ i₂tsá₃ rë₂ti'₅₄ quian'₅₄ ca₂juɨg₄, ján₃ bá₄ le₂jaun₂ tsá₃ rë₂ti'₅₄ quian'₅₄ 'lióng₂. ");
INSERT INTO cntNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jaun₂ në́₃, në₁jua'₂ tsá₃ rë₂ten'₅₄ 'nia'₂ quian'₅₄ cu₄ cha₂ mɨ₂güɨ́g₃ 'lɨg'₅₄ la₂, ¿'ein₂ bá₄ i₂lé₂ le₃'ág₃ caun₂ dsɨ́₅ ja₁con'₂ 'nia'₂ quian'₅₄ a₂lë́₅ a₂quen₅ të₃dsón'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Në₁jua'₂ tsá₃ rë₂ten'₅₄ 'nia'₂ quian'₅₄ a₂lë́₅ quió'₅ dsa₂ sián'₂, ¿'ein₂ bá₄ dsia₃ gog'₂ 'nia'₂ juɨ₁lia'₂ a₂ca₂tɨ́n'₂ 'nia'₂ guiong'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","'I₁jan₂ dsa₂ i₂ma₂'lian'₅₄ tsá₃ lé₂ le₃jme₃ti₃ ta₁ ne₄ on₃ juɨg₅₄. Ia₁ jme₃'ŋiai₅₄ jan₂, jan₂ guë'₂ jme₃'nioi₃; o₃ jme₂gain₃ jan₂, jan₂ guë'₂ tsá₃ juɨ₅ toin'₂. Tsá₃ 'ein₂ 'nia'₂ lé₂ le₃jme₃ti₃ lia'₂ ne₄ Diú₄, lia'₂ ne₄ Cu₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Dsa₂ fariseos në́₃, jme₁tioin'₅₄ 'nag₂₃ jë₂ jág₁ në₅. Jaun₂ jŋia'₅₄ ca₂ŋág₂ 'nei₂ bá₄ jme₁ca₂nág₂, ia₁ lɨ́in₅ dsa₂ i₂ŋɨ́₄ dsɨ₅₄ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jaun₂ ca₂juá'₂ Jesús: ―'Nia'₂ jmo'₂ a₂dseng'₃ të₃ne₄ dsa₂, la₁ cuɨ́'₅ bá₄ Diú₄ dse₃ 'a₂ lia'₂ lë́₅ 'au'₂ 'nia'₂. Ia₁ juɨ₁lia'₂ i₂jmo₅ dsɨ́₅ a₂ŋɨ́₄ lë₃ dsein₅₄ 'ŋio₅ quein₅, a₂jaun₂ 'io'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Jme₁ron₅ 'Éi'₃ Juá'₅, quian'₅₄ Si₂ quió'₅ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, ca₂lia'₂ ca₂të́₂ jmɨg₄ a₂jme₁chan₂ Juan₅₄. Ca₂le₃jaun₂ qui₂dsɨ₂'ag₅ jág₁ juɨ₁lia'₂ ja₁gon₂ Diú₄; ma₂ja₂lén₂ ca₂le₃jɨ́n₃ dsa₂ qui₂quɨ́n'₅ bí₂ a₂tóin'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tsá₃ guë́₄ 'e₂ ta₁ quian₅ a₂dsɨ₃ŋɨ́₂ dsɨ₁ guei'₅₄ quian'₅₄ gua'₅₄ 'uë₃, lia'₂ con'₂ guë́₄ dsɨ₃'én₂ caun₂ léi₄ pí'₁ a₂le₁ton₅ 'Éi'₃, jua'₅₄ a₂tsá₃ le₃ti₃. ");
INSERT INTO cntNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Në₁jua'₂ jan₂ dsa₂ ŋe'₂ ca₂téin₂ dsa₂ mɨ́₂ quiáin₅, a₂jéin'₂ táng₃ gu₂ quian'₅₄ i₂sián'₂, 'no₂₃ dso₄. Ján₃ guë'₂ le₂jaun₂ në₁jua'₂ dsa₂ ŋe'₂ ca₂cain₃ dsa₂ mɨ́₂ i₂ma₂téi₂ dsɨ₂i₂gu₂, ján₃ bá₄ co₂jaun₂ 'no₂₃ dso₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Jme₁chan₂ jan₂ dsa₂ cha₂ cu₄ i₂jme₁quɨ́'₅ jmá'₃ tsɨn'₅₄ jlá'₁, quian'₅₄ 'mɨ'₂ 'uɨ'₃ a₂chein'₅₄ ta₁jain₂, në́₃. Le₂'o₃ jmɨg₄ bá₄ jme₁cuë́'₅ o₂'ŋió₃ o₂jŋia₃ dsɨ₅, jme₁jmo₂₃ jmɨg₄ jlá'₁. ");
INSERT INTO cntNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jme₁chan₂ táng₃ jan₂ dsa₂ te₂ŋé₂ i₂jme₁chen₂ Lázaro, i₂dso'₅₄ jme₁qui₂rë₂can'₂ 'mé'₅ nɨ₁ŋɨ₁₂. Jme₁dsɨ₂dsiog₃ dsa₂ o₄'né₄ quió'₅ dsa₂ cha₂ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Dsa₂ te₂ŋé₂ 'éi₂ në́₃ jme₁'nio₃ jme₃tain'₅₄ quian'₅₄ a₂tsɨ₂séi'₂ ne₄ mesa. Ca₂të₂ dsɨ₂jɨ'₅₄ jme₁ja₂lén₂ ja₂'lí'₃ ne₄ 'mé'₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Cang₂ jaun₂ ca₂jon₃ bá₄ dsa₂ dsɨ₂ŋé₂ 'éi₂, ca₂tág₃ ángeles ja₁con₂ Abraham. Cang₂, ca₂jon₃ bá₄ dsa₂ cha₂ cu₄ 'éi₂ ján₃. Ca₂'ó₂ bá₄ dsa₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jme₁ma₂'ein₅₄ ŋág₅ uɨg₅ ja₁dsɨ₂len₅ 'lag₄, ca₂chóg'₃ ne₅₄ ca₂jɨ́in₂ uɨ́ng₂ Abraham quian'₅₄ Lázaro cau₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jaun₂ ca₂guió'₃ co₂mɨ'₅₄ ca₂juá'₂: “Tia₅₄ Abraham, dsia₄ ŋéi₂ 'au'₂ jniá₂, chen₅ Lázaro në₅ juɨ₁tia₅₄ chi₁gú₃ né'₃ jmɨ́g₃, juɨ₁jia₂ jme₃güɨg'₂ le₁tsɨ'₃. Ia₁ 'ŋio₅ lɨn₃ uɨg₅ ŋag₅₄ 'eng₅₄ jë₄ si₂ la₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Jaun₂ ca₂ŋag₃ Abraham: “Jón₃, dsá₂ 'au'₂ jmo₄, ca₂gue'₅₄ bá₄ 'ne₂ a₂dse₃ të₁lia'₂ ca₂rë₃cháng'₃. Lázaro la₂ në́₃, tsá₃ 'e₂ dse₃ ca₂rë₃cháin₃. Jaun₂ rë₂në́₃ në́₃ gue₂₃ lián'₂ chain₂ dse₃ ja₁lá₃. 'Ne₂ guë'₂ ma₂ŋag'₅₄ uɨg₅ ja₁në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ton'₂ jɨ'₅₄ ŋei₅ lɨn₃ lë́₅ jë₄ quián₂ jniog₄, jaun₂ tsá₃ 'ein₂ lé₂ le₃ŋɨ́₃ të₂le₃ në₅, on₃ guë'₂ i₂tion'₅₄ ja₁në₅ lé₂ ŋɨ́i₃ le₃la₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jaun₂ ca₂ŋag₃ táng₃: “Mɨ₅ jniá₂ ne'₅₄ jaun₂, tia₅₄, a₂dsiang'₅₄ i₂në₅ dsɨ₃con₅₄ jág₁ dsau₅ dsi₂néi₂ quió'₅ ŋe'₃, ");
INSERT INTO cntNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ia₁ 'ŋiá₂ chi'₂ rɨ́ng'₃ i₂chan₂ guë́₄, ia₁jaun₂ tsá₃ ja₃ŋag₅₄ uɨg₅ ja₁lá₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Jaun₂ ca₂ŋag₃ táng₃ Abraham: “I₂ma₂rón'₅ si₂ bá₄ ó₃ ca₂quiog₂ Moisés quian'₅₄ dsa₂ i₂jme₁'ë́₂ jág₁. ¡Juɨ₁tion'₅₄ juɨ₅ a₂juá'₂ 'éi₂!” ");
INSERT INTO cntNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jaun₂ ca₂ŋag₃ táng₃: “Jan₂'ón₄, tia₅₄ Abraham, ia₁ në₁ca₂dsián'₂ jan₂ 'lag₄ dsi₁con₃ jág₁, dsɨ₃quén'₅ bá₄ dsɨ́₅.” ");
INSERT INTO cntNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","La₁ ca₂ŋag₃ táng₃ 'éi₂: “Chi₂jua'₂ tsá₃ nag₅ gau₂ a₂juá'₂ Moisés, quian'₅₄ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ në́₃, ján₃ bá₄ le₂jaun₂ tsá₃ 'e₂ gau₂ nag₃ o₁jŋia'₅₄ la₂ ca₂jen'₅₄ jan₂ 'lag₄ dsi₁con₃ jág₁.” ");
INSERT INTO cntNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂ i₂quiain'₅₄: ―Tion₅₄ niog₅ le₃cha₂ bá₄ a₂jmo₃ a₂qui₃nió₃ dsa₂. ¡La₁ 'e₂ guë́₄ juɨ́g₂ juɨ₁lia'₂ dsa₂ i₂'uɨn₄ a₂dsɨ₂gan'₅₄ rɨin'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ja₂lɨn₃ guë́₄ dse₃ jua'₅₄ tón₂ dsa₂ ne₄ jmɨ₁ŋí'₄ chi₁quein₅ nɨ₁to₂ dsɨ₂lag₅₄, lia'₂ con'₂ guë́₄ jmo₃ tián'₃ dso₄ jan₂ dsa₂ dsɨ₂ŋé₂ la₂. ");
INSERT INTO cntNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Të₃ŋi'₅₄ 'nia'₂ jaun₂. 'Chi₂jua'₂ 'ein₂ rɨ́ng'₂ jmóg'₂ mɨ'₅₄, jéin₃. Në₁jua'₂ ca₂jme₃tsɨ́in₃ dsɨ́₅, 'én₃ dsáu₁. ");
INSERT INTO cntNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","O₁jŋia'₅₄ guio₃ ráun₂ në₂jmóg'₂ mɨ'₅₄ co₂jmɨg₄, në₁jua'₂ guio₃ ráun₂ ca₂já₃ ne'₅₄, juá'₂: “Tsá₃ ma₃jmo₅₄”, 'én₃ dsáu₁. ");
INSERT INTO cntNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ca₂juá'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ ca₂tsɨ́'₃ Te₁gui'₅₄: ―Jmo₄ juɨ₁le₂'éin₂ guë́₄ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jaun₂ ca₂ŋag₃ táng₃ Te₁gui'₅₄: ―Tsá₃ a₂nag₅₄ jŋia'₅₄ con'₂ tí₅ ca₂mɨ́g₂ mɨ₂jon₂ quió'₅ nɨ₁'ma₂ mostaza bá₄ 'én'₂ 'nia'₂, lé₂ le₃juɨg'₅₄ nɨ₁'ma₂ sicómoro chí'₅ në₅, “Jŋiag'₃ ja₁në₅, o₂nau₂ ne₄ jmɨ₁ŋí'₄”, le₂jaun₂ dsón'₂ lé₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Jua'₅₄ mei'₂ guë́₃ jan'₂ 'nia'₂ chan₂ jan₂ dsa₂ i₂jmo₅ ta₁ ja₁nau₂ quió'₅, o₃ jmo₂₃ 'í₂ já'₂ cha'₂ 'e₂, jua'₅₄ mei'₂ guë́₃ ma₂guáin'₅ ja₁nau₂, ¿o₃ bá₄ juɨg'₂ 'nia'₂: “Ŋɨ₅₄ i₂né₂ jaun₂ quë'₅₄”? ");
INSERT INTO cntNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma₁ tsá₃ le₂jaun₂. ¿O₃ juɨg'₂ le₂la₂ 'e₂: “jmo₄ co₂jŋia₅₄ a₂guë'₅₄, jmo₄ co₂jŋia₅₄ quiáng'₂, jaun₂ ŋag'₅₄ dsiá'₁ quió₃. Ca₂lia'₂ jë₁ma₂ca₂lë₃ guë'₂, guɨ'₂ në́₃, jaun₂ guë́₄ quë'₅₄, 'ag'₅₄ 'ne₂”? ");
INSERT INTO cntNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Cuë́'₅ ti₁'mag'₄ dsa₂ 'éi₂ ia₁ jme₃ti₃ con'₂ lë́₅ a₂të₁néi'₂? Jan₂'ón₄. ");
INSERT INTO cntNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Le₂në₅ bá₄ 'nia'₂ ján₃, jë₁ma₂ca₂lë₃ jmo'₂ ca₂le₃jë́₃ a₂juá'₂ Diú₄, ca₂tɨ́n'₂ 'nia'₂ jua'₅₄: “Tsá₃ 'e₂ ta₁ téi₄ jnia'₅₄ ja₁cong'₂, ia₁ tsá₃ 'e₂ ŋag₅₄ jua'₅₄ në₂jmó₁ jnia'₅₄, jŋia'₅₄ con'₂ a₂ca₂tág₂ jnia'₅₄ jmó₁ bá₄ në₂jmó₁.” ");
INSERT INTO cntNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Con'₂ siá'₂, ca₂'í₃ táng₃ Jesús juɨ₅ a₂dsióg₄ Jerusalén, qui₂ca₂ŋɨi₅ le₂tan₅₄ 'uë₃ Samaria quian'₅₄ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jme₁ca₂dsióg₃ caun₂ juɨg₂ bë'₅₄, ca₂jme₃jein'₂ guian₃ dsa₂ i₂le₁dso'₅₄ lɨ́n₅ 'mé'₅ 'iog₅, la₁ uɨ́ng₂ bá₄ ca₂nau₂ ja₁chén'₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ca₂juá'₂ tiá₂: ―¡Jesús, Të₅, dsia₄ ŋéi₂ 'au'₂ jnia'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jme₁ca₂jág₂ Jesús, ca₂juá'₂: ―O₂nó'₅ 'nia'₂ o₂jme₁jnia₅ ne₄ jme₂dsa₂. Jë₄ i₂léin₂ jaun₂ bá₄, ca₂jŋia₃ 'mé'₅ a₂jme₁lɨ́in₄. ");
INSERT INTO cntNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jaun₂ në́₃ jan₂ 'éi₂, jme₁ca₂rë₃lí'₄ ca₂jŋia₃ dso'₅₄, ca₂jéin'₃ táng₃ ne₅₄, jme₂juɨin'₂ Diú₄ co₂mɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ca₂tóin₂ 'uë₃ cau₅ mɨ₂tag₄ Jesús, cuë₂₃ ti₁'mag'₄. Jan₂ dsa₂ chan₂ Samaria bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jaun₂ ca₂juá'₂ Jesús: ―¿On₁jua'₅₄ guian₃ lë́₂ i₂ca₂'lón₂? ¿Na₅ guë'₂ i₂ŋi₃ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Jan₂ dsɨ₂nau₂ la₂ bá₄ i₂jón'₅ jme₂juɨin'₂ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jaun₂ ca₂tsɨ́'₃ dsa₂ 'éi₂: ―Nau₂, guan'₂ quiáng'₂. Ca₂'lóng'₂ ia₁ 'éng'₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jaun₂ ca₂ŋag₃ dsa₂ fariseos ca₂ŋɨ́i'₃ Jesús lɨ́g'₂ guá₂ jmɨg₄ a₂le₃gon₂ Diú₄. Jaun₂ ca₂ŋag₃ 'éi₂: ―On₃jua'₅₄ a₂cha₂ léi₄ a₂rë₂jniá₂ guá₂ 'éi'₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jaun₂ tsá₃ 'ein₂ lé₂ le₃juá'₂, jua'₅₄ “ŋí₂ ja₁lá₃ já₅”, o₃ “jó₄ já₅.” Ia₁ a₂ma₂'i₄ bá₄ 'éi'₃ quió'₅ Diú₄ jɨn'₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jaun₂ ca₂tsɨ́'₃ táng₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―Já₅ jmɨg₄ ja₁lé₂ 'au'₂ 'nia'₂ 'niog'₂ jag'₅₄ jmɨg₄ a₂le₃gon₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃, la₁ tsá₃ jaun₂ të₅₄ ne'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ia₁ já₅ jmɨg₄ i₁tsɨ́'₃ dsa₂ 'nia'₂: “ŋí₂ ja₁lá₃ já₅”, o₃ “jó₄ já₅.” La₁ tsá₃ o₁nó'₅ 'nia'₂, on₃ guë'₂ juɨ₁le₂'én'₂ 'nia'₂ quió'₅ i₂juá'₂ le₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ia₁ juɨ₁lia'₂ të₂tsɨ'₅₄ si₁ŋí'₃ ca₂taun₂ ca₂taun₂ guei'₅₄ mɨ₂güɨ́g₃, le₂jaun₂ bá₄ lé₂ jë₁ma₂të́₂ rë₁të₃tsɨn'₅₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","La₁ jŋiá₅ de'₂ ca₂tɨ́in₂ ŋág₃ uɨg₅ 'ŋio₅ lɨn₃, jme₃'iog₅₄ dsa₂ chan₂ jmɨg₄ në₃. ");
INSERT INTO cntNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ia₁ juɨ₁lia'₂ ca₂lë₃ jmɨg₄ lia'₂ con'₂ jme₁chan₂ Noé, le₂jaun₂ bá₄ lé₂ táng₃ jmɨg₄ quió'₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ia₁ jme₁tion'₅₄ dsa₂ 'éi₂ jmɨg₄ jaun₂ qui₂guë́'₅, qui₂'ɨ́n'₂ në́₃, jme₁qui₂jéin'₂ gu₂, qui₂cuɨin₂₃ chi'₂ quiáin₅ a₂jéin'₂ gu₂, ca₂lia'₂ jme₁ca₂dsióg₃ jmɨg₄ i₁ca₂'í₃ Noé 'ŋió'₃ nɨ₁barco, a₂ca₂can'₂ rë'₂ jmɨg₂ ta₁caun₂ mɨ₂güɨ́g₃, ca₂i₃'én₂ ca₂le₃jɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Le₂në₅ bá₄ ca₂lë₃ ján₃ jmɨg₄ quió'₅ Lot. Jme₁tion'₅₄ dsa₂ qui₂guë́'₅, qui₂'ɨ́n'₂, i₂tion'₅₄ qui₂lá₅, qui₂'nag₂₃, qui₂jne₂₃ 'e₂ qui₂jne₂₃, qui₂jmóg'₅ 'ne₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","La₁ jme₁ca₂dsióg₃ jmɨg₄ a₂o₂'ɨ́n₃ Lot juɨg₂ Sodoma, a₂ca₂tang₂ rë'₂ si₂, ca₂séi'₂ nɨ₁cang₁ azufre le₁guí'₂ si₂ guei'₅₄, ca₂i₃'én₂ táng₃ ca₂le₃jɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Le₂jaun₂ bá₄ lé₂ táng₃ jmɨg₄ i₁jme₃jnia₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Jmɨg₄ jaun₂, chi₂jua'₂ 'ein₂ 'en₅₄ co'₅₄ 'ne₄, juɨ₁te₁'i₁ bá₄ 'e₂ te₁'i₁ dsi₂néi₂ quió'₅, tsá₃ o₁sióin₄ jua'₅₄ a₂'uë́'₃ a₂jaun₂. Ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ i₂'en₅₄ ja₁nau₂, tsá₃ ma₃o₁jŋioi'₅₄ jua'₅₄ a₂ja₃quián₂ 'e₂ ja₃quián₂ a₂cha₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dsá₂ 'au'₂ 'nia'₂ jmo₄ 'e₂ ca₂i₃ŋɨ́₂ 'io₅₄ quián₅ Lot. ");
INSERT INTO cntNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ia₁ juɨ₁lia'₂ dsa₂ i₂'nio₃ le₃chan₂ dse₃, dsɨ₃'én₂ quió'₅; la₁ juɨ₁lia'₂ dsa₂ i₂dsɨ₃'én₂ quió'₅, le₃chain₂ bá₄ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Juá'₅ jniá₂, 'uë₂ jaun₂, on₃ dsa₂ i₂tián'₅ caun₂ tsɨ₁cama; jan₂ i₂dsɨ₃lén₃, jan₂ guë'₂ i₂të₃'ŋiá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ján₃ guë'₂ le₂jaun₂, on₃ dsa₂ mɨ́₂ i₂tion'₅₄ éi'₅ co₂lë₅; jan₂ i₂dsɨ₃lén₃, jan₂ guë'₂ i₂të₃'ŋiá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jaun₂ ca₂ŋag₃ dsa₂: ―¿A₂já'₄ bá₄ lé₂ a₂në₅, Te₁gui'₅₄? Jaun₂ ca₂ŋag₃ táng₃ 'éi₂: ―Juɨ₁lia'₂ ja₁ron₅ nɨ₁ŋɨ₁ 'lag₄, ja₁jaun₂ ŋɨ'₂ i₁tú₃ tsɨn'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ca₂juá'₂ Jesús caun₂ jág₁ a₂jáng'₅ léi₄, a₂ca₂jme₃tɨin₂₃ dsa₂ a₂ca₂tɨ́in₂ chi₃léin'₂ Diú₄ tián₂, tsá₃ o₁'ú'₄ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ca₂juá'₂ le₂la₂: ―Caun₂ juɨg₂ jme₁guá₄ jan₂ juë́₄ i₂tsá₃ Diú₄ gan₃, on₃ guë'₂ dsan₂ dsɨ́₅ dsa₂ mɨ₂güɨ́g₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ján₃ bá₄ juɨg₂ jaun₂ jme₁chan₂ jan₂ 'io₅₄ 'nág₂ i₂jme₁ja₂ i₂gú'₃ ja₃jɨin₅₄ juë́₄ 'éi₂, jme₁ja₂jua'₅₄: “Jme₁rë₂ jág₁ quió₃, qui₂dsɨ₅ 'éi'₃ quió'₅ dsa₂ i₂jmóg'₂ jniá₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Uë́₂ bá₄ tsá₃ juɨ₅ tón'₂ 'éi₂ jua'₅₄ jme₃rë́₃. La₁ cang₂ bá₄ ca₂i₃jŋia₅ dsɨ́₅: “O₁jŋia'₅₄ la₂ tsá₃ Diú₄ gáng₅, on₃ guë'₂ dsa₂ mɨ₂güɨ́g₃ dsan₂ dsɨ₃ në́₃, ");
INSERT INTO cntNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","la₁ia₁ 'uɨg₅₄ a₂ŋɨ́₄ lë₃ cuë₅ o₂me'₅₄ dsɨ₃ 'io₅₄ 'nág₂ në₅, qui₁dsɨ₅ jniá₂ co₂ŋei'₅₄ 'éi'₃ o₄quió'₄, con'₂ tsá₃ ŋó₅ në₁jua'₂ caun₂ le₂në₅ ŋɨ₃, jmo₃ dsɨ₃mé'₂ dsɨ₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jaun₂ ca₂juá'₂ Te₁gui'₅₄: ―Ŋí₂ rë₂ a₂juá'₂ juë́₄ 'lɨn'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Tsa₁ lɨ́n'₂ 'nia'₂, jme₃rë́₃ bá₄ Diú₄ 'e₂ a₂mɨ₅ dsa₂ i₂rë₂quion'₅₄ quiáin₅ i₂quɨ'₂-'áu'₂ ca₂nei₂ ca₂jnia₃? ¿Tsa₁ lɨ́n'₂ 'nia'₂ caun₂ juɨn'₂ dsɨ́₅ bá₄ quiong'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Juɨ́g₂ jniá₂ 'nia'₂, dsɨ₂juɨ₅ bá₄ qui₃dsɨ₅ Diú₄ 'éi'₃ o₄quió'₄ i₂mɨ₅. La₁, jë₁ma₂të́₂ rë₁guan'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃, ¿dsiain'₂ bá₄ guë́₄ dsa₂ 'én₂ ne₄ gua'₅₄ 'uë₃? ");
INSERT INTO cntNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ca₂juá'₂ Jesús caun₂ jág₁ jáng'₅ léi₄ a₂ca₂tɨ́n₂ con'₂ i₂lɨ́n₂ lɨ́in₅ dsa₂ dsen₃, tsá₃ dsáu₅ dsɨ́₅ rɨin'₅₄ sián'₂. Ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―On₃ dsa₂ ca₂i₃lén₂ guá'₅ templo i₁chi₂i₁lein'₄ Diú₄. Jan₂ 'éi₂ jme₁lɨ́n₄ fariseo, jan₂ guë'₂ i₂jme₁lɨ́n₄ ta₁ i₂mɨ₅ 'lia'₅₄ a₂ca₂tɨ́n₂ dsɨ₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Dsa₂ fariseo në́₃, të₃ chéin'₅ bá₄ chi₂lí'₂ con'₂ 'ŋiog₅, ca₂juá'₂ le₂la₂: “Cuë́₅ jniá₂ ti₁'mag'₄, 'ne₂ Diú₄ quiáng₃, ia₁ tsá₃ lɨ́ng₅ juɨ₁lia'₂ lɨ́n₅ i₂lɨn₅₄: i₂qui₂'ang₅, i₂tsá₃ dse₃ jmo₅ ja₁con₂ rɨn'₅₄, i₂nió'₅ jág₁ quian'₅₄ dsa₂ i₂tsá₃ lɨ́n₅ dsɨ₂i₂gu₂, ca₂lia'₂ jŋia'₅₄ lia'₂ lɨ́n₅ dsa₂ i₂mɨ₅ 'lia'₅₄ në₅, tsá₃ lɨ́ng₅. ");
INSERT INTO cntNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jme₂'ɨng₅₄ në́₃ tɨn₃ ráun₂ lia'₂ caun₂ semana, ton'₂ cuë₅ bá₄ jniá₂ caun₂ qui'₅₄ a₂guia₃ quió₃, jë₂ con'₂ a₂lág₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","La₁ dsa₂ i₂mɨ₅ 'lia'₅₄ 'éi₂ guë'₂ në́₃, uɨ́ng₂ bá₄ chéin'₅, ca₂lia'₂ jŋia'₅₄ ne₅₄ bá₄ tsá₃ tiá₂ dsɨ́₅ chóg'₃ guei'₅₄. Jŋia'₅₄ con'₂ qui₂quein₂₃ le₁dsɨ́₅ bá₄ chéin'₅, juá'₂: “Diú₄ quiáng₃, dsia₄ ŋéi₂ 'au'₂ jniá₂ ia₁ rë₂cáng'₄ dso₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jaun₂ juɨ́g₂ jniá₂ 'nia'₂, dsa₂ i₂mɨ₅ 'lia'₅₄, 'éi₂ bá₄ tiá₂ rë₂ të₁tsɨn'₅₄ ne₄ Diú₄ ŋái'₅ quió'₅, lia'₂ con'₂ guë́₄ i₂jan₂. Ia₁ ca₂le₃jɨ́n₃ i₂jme₂can'₅₄ guion₅₄, sióin₃; la₁ i₂jmo₅ me'₂ guë'₂ në́₃, roin'₂ guei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Co₂ráun₂ guë'₂, qui₂ca₂o₃jŋia₃ dsa₂ guein₂ quiáin₅ ne₄ Jesús, ia₁jaun₂ qui₃téi₂ gu₂. La₁ ca₂jí₂ bá₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ jme₁ca₂jág₂. ");
INSERT INTO cntNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jaun₂ ca₂të́'₃ Jesús guein₂, jaun₂ ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―Cuë₄ 'nia'₂ jmɨg₄ ja₃lén₂ chi'₂-guein₂ ja₁cong₂; tsá₃ lë₁jnɨi'₅₄ juɨ₅. Ia₁ juɨ₁lia'₂ i₂le₂në₅ bá₄ guë'₂ i₂tɨn₃ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, dsa₂ i₂tsá₃ gue₅ ja₁gon₂ Diú₄ juɨ₁lia'₂ gue₅ jan₂ i₂bë'₅₄, o₁lɨ́g'₂ jmɨg₄ tsá₃ 'í₂ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jan₂ i₂lɨ́n₅ dsa₂ dsen₅₄ ca₂ŋɨ́i'₃ Jesús: ―Të₅ dsen₃, ¿'e₂ bá₄ 'nió'₅ jmo₅₄ jniá₂ ia₁jaun₂ tɨng₅₄ ja₁le₃chang₂ co₂tan₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jaun₂ ca₂ŋag₃ Jesús: ―¿'E₂ lë₃ quiong'₅₄ jniá₂ a₂dseng₃? 'I₁jan₂ i₂dsen₃ tsá₃ chan₂, jŋia'₅₄ lia'₂ jan₂ Diú₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tɨng'₂ bá₄ 'Éi'₃ Juá'₅: “Tsá₃ nióg'₄ jág₁ quian'₅₄ dsa₂ i₂tsá₃ lɨ́n₅ dsɨ₂i₂gog'₂; tsá₃ jŋɨ́g'₄ dsa₂ mɨ₂güɨ́g₃ rɨ́ng'₂; tsá₃ 'áng'₁; tsá₃ jmó'₂ dsáu₁ rɨ́ng'₂ quian'₅₄ jág₁ të₂jág₁; jme₁gang'₃ chog'₂-ŋéi'₅.” ");
INSERT INTO cntNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ca₂ŋag₃ 'éi₂: ―Lia'₂ con'₂ bɨn'₅₄ bá₄ jniá₂ ma₂guio₃ jme₂tí₁ ca₂le₃jë́₃ 'éi'₃ në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jme₁ca₂nág₂ Jesús a₂në₅, jaun₂ ca₂juá'₂: ―'Nió'₅ bá₄ guë́₄ caun₂ quiáng'₂: 'nag₄ ca₂le₃jë́₃ a₂cha₂ quiáng'₂. Jaun₂ dsio'₅₄ quió'₅ dsa₂ te₂ŋé₂. Jaun₂ guë́₄ le₃cha₂ 'lióng₂ quiáng'₂ guei'₅₄ i₂juɨ́g₃. Jaun₂ ŋia₅ chi₁co'₅₄ quió₃ o₁ló₄. ");
INSERT INTO cntNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","La₁ jme₁ca₂nág₂ dsa₂ 'éi₂ jág₁ në₅, ca₂tá'₂ 'lia'₂ dsɨ́₅ 'ŋio₅ lɨn₃, ia₁ 'ŋio₅ lɨn₃ jme₁cha₂ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jme₁ca₂jág₂ Jesús, ca₂juá'₂: ―¡'E₂ guë́₄ quian₅ ta₁ a₂tón'₃ dsa₂ cha₂ cu₄ ja₁gon₂ Diú₄! ");
INSERT INTO cntNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ja₂lɨn₃ guë́₄ tsá₃ ta₁ quian₅ a₂lé₂ le₃ŋɨ₅ jan₂ camello juɨ₅ tau₂ mɨ₂cu₄, lia'₂ con'₂ guë́₄ jan₂ dsa₂ cha₂ cu₄ ŋɨi₅ 'í₂ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jme₁ca₂nág₂ dsa₂ i₂tión₂ jë₄ jaun₂, ca₂juá'₂: ―¿I₂'ein₂ bá₄ guë'₂ i₂tɨ́n'₄ jaun₂? ");
INSERT INTO cntNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jaun₂ ca₂juá'₂ táng₃: ―Ca₂le₃jë́₃ a₂tsá₃ quɨ'₅₄ jmɨg₄ dsa₂ mɨ₂güɨ́g₃ jmo₃, Diú₄ lé₂ le₃jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jaun₂ ca₂juá'₂ Pe₄: ―Te₁gui'₅₄, ma₁ jnia'₅₄ ma₂ca₂tí₄ ca₂le₃jë́₃ a₂jme₁cha₂ quián₂, a₂ma₂ja₂náu₅ 'én₅ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jaun₂ ca₂ŋag₃ táng₃: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, 'i₁jan₂ tsá₃ jua'₅₄ a₂lë₁táun₂ 'ne₄, téin₂ chog₅₄-jmei₂, o₁rɨin'₅₄, dsa₂ mɨ́₂, chi'₂-guein₂ quiáin₅ në́₃, o₄quió'₄ ja₁gon₂ Diú₄, ");
INSERT INTO cntNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jua'₅₄ tsá₃ gue₃ tson₂ guë́₄ ne₄ gua'₅₄ 'uë₃ la₂, ton'₂ le₃chain₂ dse₃ co₂tan₅₄ mɨ₂güɨ́g₃ caun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jaun₂ ca₂të́'₃ Jesús cau₅ jmá'₃ lia'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂juá'₂: ―Në₃ guë́₄ në́₃ ca₂të́₂ jmɨg₄ a₂dsau₅₄ juɨg₂ Jerusalén, ja₁niog₅ le₃ti₃ ca₂le₃jë́₃ con'₂ lë́₅ ca₂tó'₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄ ne₄ si₂, a₂'ɨin₂₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jáng'₂ dsa₂ o₄gú₃ dsɨ₂nau₂, ja₁lë₁co₃jmóg'₂ dsa₂, qui₃të₃'o'₂ dsa₂, a₂qui₃'ŋéi₂ dsa₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Jaun₂ jë₁ma₂ca₂lë₃ bóg₂, jaun₂ guë́₄ jŋag'₃. La₁ jë₁ma₂ca₂të́₂ 'nɨ₅ jmɨg₄, jein'₅₄ bá₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","La₁ 'éi₂ në́₃, tsá₃ 'e₂ ca₂ŋɨ́i'₂ 'i₁caun₂ jág₁ në₅, ia₁ lë́₅ jág₁ a₂rë₂'ma₄ bá₄ guë́₄ ja₁coin₂, tsá₃ jein₅ dsɨ́₅ 'e₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Con'₂ jme₁ma₂ja₂quián₃ dsióg₄ Jesús juɨg₂ Jericó, jme₁guá₄ jan₂ dsa₂ ten₄ cau₅ juɨ₅, mɨ₂₃ a₂jme₃'o₅₄ dsa₂ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jme₁ca₂nág₂ a₂qui₂ca₂ŋɨ₅ juɨn₅ dsa₂, jaun₂ ca₂ŋag₃ 'e₂ niog₅ lë́₂. ");
INSERT INTO cntNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jaun₂ ca₂juá'₂ dsa₂: ―Jesús chan₂ Nazaret bá₄ në₅ já₅. ");
INSERT INTO cntNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jaun₂ 'éi₂ në́₃ ca₂juá'₂ tiá₂ ca₂tsɨ́'₃ Jesús: ―¡Jesús, tsɨ₁jon₂ David, dsia₄ ŋéi₂ 'au'₂ jniá₂! ");
INSERT INTO cntNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ca₂jí₂ bá₄ dsa₂ i₂ja₂lén₂ ne₄ juɨ₅ ia₁jaun₂ jmo₃ tei₄, la₁ të₂le₃ lë́₅ guë́₄ qui₂ca₂'áu'₂ bá₄ 'ein₅₄, ca₂juá'₂: ―¡'Ne₂ tsɨ₁jon₂ David, dsia₄ ŋéi₂ 'au'₂ jniá₂! ");
INSERT INTO cntNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ca₂nau₂ Jesús, jaun₂ ca₂jmo₃ 'éi'₃ a₂dsɨ₃quión₂ dsa₂. Jme₁ca₂dsióg₃ cau₅ quió'₅, jaun₂ ca₂ŋag₃ Jesús: ");
INSERT INTO cntNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿'E₂ 'niog'₂ jmo₅₄ jniá₂ quiáng'₂? Jaun₂ ca₂juá'₂: ―Te₁gui'₅₄, a₂jnia₅₄ jme₁ne₃ bá₄ jniá₂ 'nio₃. ");
INSERT INTO cntNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jaun₂ ca₂juá'₂ Jesús: ―¡Gue₄, juɨ₁jnia₅₄ quiáng'₂! Ma₂ca₂'lóng'₂ bá₄, ia₁ 'éng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Dsɨ₂juɨ₅ jaun₂ bá₄ ca₂jnia₃ mɨ₂ne₅₄. Jaun₂ ca₂ŋó₃ chi₁co'₅₄ quió'₅, jme₂juɨin'₂ Diú₄. Ca₂le₃jɨ́n₃ bá₄ dsa₂ i₂ca₂të́₂ ne₄ a₂ca₂lë₃ jaun₂ ca₂jme₃juɨin'₂ Diú₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ca₂'í₃ Jesús juɨg₂ Jericó. Jaun₂ jme₁ma₂ŋó₅ jë₄ juɨg₂, ");
INSERT INTO cntNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ja₁jaun₂ jme₁chan₂ jan₂ dsa₂ cha₂ cu₄ i₂chen₂ Zaqueo, i₂lɨ́n₅ dsa₂ juɨn'₂ quián₅ dsa₂ i₂cán₂ 'lia'₅₄ quián₅ dsɨ₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","'Éi₂ në́₃, jme₁'no'₂ juɨ₅ jɨ́in₂ 'ein₂ 'éi₂ Jesús. La₁ tsá₃ lé₂, ia₁ a₂ŋɨ́₄ lë₃ juɨn₅ dsa₂ tion'₅₄. Ia₁ jan₂ dsa₂ 'on'₂ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jaun₂ ca₂ŋó₃ co₂chi'₅₄ le₃ne₄ juɨ₅, ca₂uɨ́g₂ guei'₅₄ caun₂ nɨ₁'ma₂ sicómoro, ia₁ 'nio₃ jɨ́in₂ Jesús, ia₁ juɨ₅ jaun₂ jme₁ŋɨ́i₃. ");
INSERT INTO cntNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jme₁ca₂dsióg₃ Jesús, jaun₂ ca₂jág₃ guei'₅₄, jaun₂ ca₂juá'₂: ―Zaqueo, ma₂në₃ sión₅, ia₁ ja₁quiáng'₂ ca₂tɨ́ng₂ i₁jŋia₁₂ në₃. ");
INSERT INTO cntNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jaun₂ ca₂sióin₃ co₂chi'₅₄, ca₂guei₃ 'io'₂ jén'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jme₁ca₂jág₃ dsa₂, jaun₂ ca₂chi₂ca₂'ag₃ ca₂juá'₂: ―Dsi₂néi₂ quió'₅ jan₂ dsa₂ cha₂ dsáu₁ bá₄ ŋó₅ i₂jŋia₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo në́₃, jme₁ca₂nau₂ ne₅₄ jaun₂ ca₂tsɨ́'₃ Te₁gui'₅₄: ―Te₁gui'₅₄, dsio'₄ jniá₂ ca₂dsio₄ a₂cha₂ quió₃, cuë́₄ dsa₂ te₂ŋé₂. Ján₃ guë'₂ le₂jaun₂ chi₂jua'₂ 'ein₂ quió'₅ ma₂'ang₃ a₂juɨ₁gang₂, jɨin'₅₄ táng₃ jniá₂ quén₂ ráun₂ lë́₅ guë́₄ co₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jaun₂ ca₂juá'₂ Jesús: ―Jmɨg₄ në₃ ca₂lón₂ dsa₂ dsi₂néi₂ la₂. Ia₁ ján₃ bá₄ lɨ́in₅ tsɨ₁jon₂ quián₅ Abraham. ");
INSERT INTO cntNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ta₁ në₅ já₅ bá₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃, a₂ja₂'niai'₂ a₂ja₂lioin₅₄ dsa₂ i₂ma₂i₂cón'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Të₃ tion'₅₄ dsa₂ nag₂₃ jág₁ jaun₂, jaun₂ ca₂juá'₂ táng₃ caun₂ jág₁ jáng'₅ léi₄, ia₁ ma₂quián₅ bá₄ dsióg₄ Jerusalén, ton'₂ ia₁ lɨ́n₂ dsa₂ le₃jniá₂ dsɨ₂juɨ₅ jaun₂ 'éi'₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jaun₂ në́₃ ca₂juá'₂: ―Jme₁chan₂ jan₂ dsa₂ i₂lɨ́n₅ tsɨ₁jon₂ dsa₂ jlán'₁. Ca₂ŋó₃ caun₂ juɨg₂ uɨ́ng₂ ja₁'ag₃ dsa₂ a₂léin₂ rag₅₄, jaun₂ guë́₄ jŋiói'₂ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","La₁ né'₃ a₂o₃'ɨin₅, ca₂të́'₃ guian₃ dsa₂ i₂jme₂ti₃ ta₁ ne₅₄. Jaun₂ le₂jan₂ le₂jan₂ 'éi₂ ca₂cuë́'₃ jma₃cáun₃ cu₄ 'ua'₂ a₂chei₂ mina. Jaun₂ ca₂juá'₂: “Jmo₄ 'nia'₂ ta₁ cu₄ në₅ qui₁dsag'₂ 'nia'₂ ca₂lia'₂ ca₂të́₂ jmɨg₄ i₁guang'₂ táng₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","La₁ dsa₂ go₅₄ në́₃ ca₂rë₃'iog₅₄, ca₂chein₃ co₂nió'₃ dsa₂ ca₂i₁chi'₄ dsa₂ ja₁jaun₂: “Tsá₃ 'niog₂ jnia'₅₄ jme₃gón₃ i₂në₅ jë₄ quián₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","La₁ tion₅₄ bá₄ ca₂lɨn₃ 'éi₂ rag₅₄. Jme₁ca₂guáin'₃ táng₃ go₅₄, jaun₂ ca₂të́'₃ dsa₂ i₂jme₂ti₃ quiáin₅ i₂ca₂cuë́'₃ cu₄ 'éi₂, ia₁ 'nio₃ con₂ 'í₁ jma₃je₂liá'₂ tí₅ a₂ma₂të₁dsɨ₅₄ quió'₅ le₂jain₂ le₂jain₂. ");
INSERT INTO cntNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jaun₂ ca₂dsióg₃ i₂le₂'uɨg₅₄, ca₂juá'₂: “Gui'₅₄, con'₂ guë́₄ guia₃ co₂jaun₂ ma₂të₁dsɨ₅₄ cu₄ mina quiáng'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jaun₂ ca₂tsɨ́'₃ 'éi₂: “'E₂ guë́₄ dse₃, téng'₅ bá₄ ta₁; ca₂jme₁ti'₄ bá₄ dse₃ quian'₅₄ a₂ca₂juɨg₄ a₂ca₂dsia₃ jniá₂ gog'₂. Në₃ në́₃ dsia₄ jniá₂ gog'₂ a₂jmó'₂ 'éi'₃ ne₄ guia₃ juɨg₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jaun₂ ca₂guan₃ táng₃ i₂ca₂të́₂ on₃, ca₂juá'₂: “Gui'₅₄, 'ŋiá₂ guë́₄ co₂jaun₂ ma₂të₁dsɨ₅₄ cu₄ mina jaun₂ quiáng'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Le₂jaun₂ bá₄ ca₂tsɨ́'₃ i₂'éi₂ ján₃: “'Ne₂ guë'₂ jmó'₂ 'éi'₃ ne₄ 'ŋiá₂ juɨg₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jaun₂ ca₂já₃ táng₃ jan₂ ca₂juá'₂: “La₂ bá₄ ron₅ cu₄ quiáng'₂, gui'₅₄. Ca₂'ma₃ bá₄ jniá₂ dsɨ́₅ pe₁guí₄. ");
INSERT INTO cntNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","A₂gán₅ 'ne₂ bá₄ jniá₂, ia₁ guion₅₄ lɨ́ng'₅ dsa₂ tsau₂ dsɨ́₅, të₂le₃ dséi₂ mág'₂ quiáng'₂. Ia₁ cáun'₂ ja₁tsá₃ 'e₂ ca₂qui₁dsag'₂ 'ŋiag'₂, ton'₂ cag'₅₄ ja₁tsá₃ 'e₂ ca₂jŋí'₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jaun₂ ca₂ŋag₃ táng₃ 'éi₂: “¡'E₂ bá₄ tsá₃ ta₁ téng'₄! Lia'₂ con'₂ lë́₅ jág₁ quiáng'₂ qui₁dsɨ₅ jniá₂ 'éi'₃. Chi₂jua'₂ ma₂ŋi'₅₄ lɨ́ng₅ dsa₂ i₂tsau₂ dsɨ́₅, cáun₄ a₂tsá₃ 'e₂ ca₂qui₁dsag'₂ 'ŋió₃, ton'₂ cag'₅₄ ja₁tsá₃ 'e₂ ca₂jan₃, ");
INSERT INTO cntNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿'E₂ 'uɨg₅₄ tsá₃ ca₂i₁tio'₂ banco cu₄ quió₃ jaun₂ në́₃, ia₁jaun₂ jë₁ma₂guáng'₅ la₂, jme₁guéi'₄ lia'₂ jma₃quian'₅₄ a₂të₁dsɨ₅₄?” ");
INSERT INTO cntNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jaun₂ ca₂tsɨ́'₃ i₂jme₁tión₂ cau₅: “Jŋiá'₃ 'nia'₂ cu₄ mina a₂chan'₂ i₂në₅. Cuë'₅₄ i₂'io₅ guia₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jaun₂ ca₂juá'₂ 'éi₂: “Gui'₅₄, ma₁ ma₂'io₅ bá₄ i₂në₅ guia₃ minas.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jaun₂ ca₂ŋag₃ rag₅₄: “A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, ca₂le₃jɨ́n₃ juɨ₁lia'₂ i₂ma₂le₁'io₅, ŋei₂ guë́₄; la₁ i₂tsá₃ 'e₂ qui₁dsag'₂, ca₂të₂ a₂jme₁ma₂niog₅ gu₂, co₂ŋei'₅₄ jŋia'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","La₁, juɨ₁lia'₂ dsa₂ i₂'iog₅₄ i₂tsá₃ 'ŋio₂ dsɨ́₅ gua₅₄ jmo₅₄ 'éi'₃ ja₁coin₂, o₂quiain₅ 'nia'₂ ja₁lá₃, jaun₂ jme₁dsiain'₂ 'nia'₂ ne₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jme₁ca₂dsan₃ tsɨ́'₅ dsa₂ le₂në₅, ca₂'ág₂ táng₃ ne₅₄ juɨ₅, ca₂uɨ́g₂ tso₄ a₂dsióg₄ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jme₁ma₂ja₂quián₃ dsióg₄ juɨg₂ Betfagé quian'₅₄ Betania, a₂te₁'i₁ cau₅ má'₂ chei₂ Olivos, ja₁jaun₂ ca₂chein₃ on₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiain₅. ");
INSERT INTO cntNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ca₂juá'₂: ―O₂nó'₅ 'nia'₂ juɨg₂ niog₅ 'ŋo'₅₄ ó₃. Jë₁ma₂ca₂dsi₃nóg'₅, dsian'₂ 'nia'₂ jan₂ bú'₄ chéin'₅ rë₂'ŋe'₅₄, i₂tsá₃ 'ein₂ ma₂co₁dsag₅₄. Chein'₅₄ 'nia'₂ jaun₂ të'₅₄ ja₁lá₃. ");
INSERT INTO cntNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Në₁jua'₂ 'ein₂ ca₂ŋag₃ 'e₂ lë₃ tsɨin'₅₄, jaun₂ juɨg'₅₄: “Ia₁ 'niói'₅ quió'₅ Te₁gui'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ca₂i₃lén₂ bá₄ guë'₂ i₂chen₄ 'éi₂ në́₃. Ca₂lë₃ rë'₂ lia'₂ con'₂ lë́₅ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jme₁ma₂tioin'₅₄ chéin'₂ bú'₄, ca₂juá'₂ juɨg₅₄ já'₂: ―¿'E₂ 'uɨg₅₄ tsɨn'₅₄ 'nia'₂ bú'₄? ");
INSERT INTO cntNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jaun₂ ca₂ŋag₃: ―Ia₁ 'niói'₅ quió'₅ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jaun₂ ja₂lein₃ bá₄ te₂ ja₁'en₅₄ Jesús. Qui₂ca₂dsia₃ tsɨ₁'mɨ'₂ mɨ₂ca'₄ dsɨ₂bú'₄, jaun₂ guë́₄ ca₂dsiain₃ Jesús guei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Le₃ne₄ juɨ₅ ja₁ŋó₄ Jesús, qui₂ca₂já₃ dsa₂ 'mɨ'₂ le₂'i₄ juɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Con'₂ jme₁ma₂ja₂quián₃ jein₅₄ Má'₂ Olivos, ca₂jme₃lióg₃ ca₂le₃jɨ́n₃ dsa₂ i₂quiain'₅₄ ca₂tóin'₂ co₂mɨ'₅₄ jmo₂₃ 'io'₂ jme₂juɨin'₂ Diú₄ në́₃, o₄quió'₄ ca₂le₃jë́₃ juɨ₅bí₂ a₂ma₂jmo₃ Jesús, a₂qui₂ma₂të́₂ ne₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ca₂juá'₂: ―¡Juɨ₁le₂juɨn'₂ bá₄ Rag₅₄ në₅ i₂já₅ o₄quió'₄ Te₁gui'₅₄! ¡Juɨ₁'ei₅ bá₄ tei₄ guei'₅₄ i₂juɨ́g₃! ¡Juɨ₁le₂juɨn'₂ bá₄ Diú₄ le₂tan₅₄ ja₁ŋei₅ në́₃! ");
INSERT INTO cntNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","I₂lɨn₅₄ dsa₂ fariseos i₂tion'₅₄ jë₄ jaun₂ ca₂juá'₂: ―Të₅, jén₃ dsa₂ i₂quiang'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jaun₂ ca₂ŋag₃ Jesús: ―Juɨ́g₂ jniá₂ 'nia'₂, jua'₅₄ mei'₂ guë́₃ dsɨ₂lén₂ i₂në₅ tei₄, nɨ₁cang₁ guë'₂ tó'₃ mɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jme₁ma₂ja₂quián₃ dsióg₄ 'nɨ'₂ juɨg₂ Jerusalén, ca₂'o₃ o₄quió'₄ dsa₂ juɨg₂, ");
INSERT INTO cntNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ca₂juá'₂: ―¡Juɨ₁lia'₂ bá₄ ŋɨ́'₂ 'au'₂ 'nia'₂ jmɨg₄ në₃ a₂dse₃ já₅ jɨn'₄ 'nia'₂ a₂jme₁le₃chang'₂ 'ag₃ tei₄! La₁ rë₂'ma₄ jlë₅ le₃ja₁cong'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ia₁ jiá₃ jmɨg₄ ja₁tsá₃ ma₃'e₂ ŋi'₅₄ 'nia'₂ jmó'₂. Ia₁ cho₃ dsa₂ i₂'iog₅₄ caun₂ nɨ₁'ia'₂ le₃lág'₃ quián'₂ 'nia'₂, a₂jë₃lɨ'₅₄, qui₃tiog₃ dsa₂ në́₃ le₂tan₅₄ ja₁lë́₄ o₄juɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Jnáu'₂ dsa₂ 'uë₃ 'nia'₂, jme₃dsiog₂₃ lia'₂ jma₃quian'₅₄ chi'₂-guein₂ quiáng'₂. 'I₁ca₂mɨ́g₂ cang₄ tsá₃ ma₃'e₂ le₁juɨ́₄ lé₂ ja₁lá₃. Ia₁ tsá₃ ca₂rë₃len'₄ 'nia'₂ lia'₂ con'₂ jmɨg₄ jme₁'nio₃ Diú₄ jme₃gu'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jaun₂ ca₂'í₃ Jesús i₁dsi₅ guá'₅ templo, ca₂jme₃lióg₃ qui₂ca₂'uɨ́in'₂ dsa₂ i₂jme₁ma₂tion'₅₄ 'nag₅ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ca₂juá'₂: ―Ne₄ Si₂ juá'₂: “'Né₅ quió₃ lé₂ ca₂ne₅₄ 'né₅ ja₁chi₂lén'₂ dsa₂ Diú₄.” La₁ 'nia'₂ në́₃ ma₂jmo'₅₄ në₂jag₄ bá₄ të₂'lau₂ quió'₅ dsa₂ 'ang₂. ");
INSERT INTO cntNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ca₂le₃jë́₃ jmɨg₄ bá₄ jme₁jme₂tɨn₅ Jesús dsa₂ i₁dsi₅ guá'₅. La₁ juɨg₅₄ jme₂dsa₂ quian'₅₄ të₅juá'₅, dsa₂ can'₅₄ quián₅ juɨg₂ në́₃, caun₂ 'no'₂ juɨ₅ 'a₂ lia'₂ jŋag'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","La₁ tsá₃ dso'₂ guë'₂ juɨ₅ 'a₂ lia'₂ jmo₃, ia₁ ca₂le₃jɨ́n₃ bá₄ dsa₂ i₂tion'₅₄, nag₂₃ tei₄ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Co₂ráun₂ jme₁ma₂'en₅₄ Jesús jme₂tɨin₂₃ dsa₂ jág₁ dse₃ i₁dsi₅ guá'₅ templo, jme₁ca₂dsi₃lén₂ juɨg₅₄ jme₂dsa₂, të₅juá'₅, quian'₅₄ gui'₅₄ can'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ca₂juá'₂: ―Jmo₄ jág₁ 'e₂ ta₁ lɨ́ng'₅. ¿'Ein₂ ca₂cuë₃ bí₂ 'éi'₃ a₂jmo'₂ le₂në₅? ");
INSERT INTO cntNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jaun₂ ca₂ŋag₃ Jesús, ca₂juá'₂: ―Ján₃ bá₄ ŋag₄ jniá₂ caun₂ jág₁ 'nia'₂: ");
INSERT INTO cntNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿'Ein₂ ca₂chen₃ Juan₅₄ a₂o₃choin₃ dsa₂ jmɨg₂? ¿Ca₂chei₃ Diú₄, o₃ ca₂chei₃ dsa₂ mɨ₂güɨ́g₃ 'e₂? Ŋag₄ de'₂ 'nia'₂ a₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jaun₂ ca₂dsia₃ jág₁ guioin₅₄, ca₂juá'₂: ―Në₁jua'₂ ca₂chei₅₄ jniog₄ i₂chen₄ quián₅ Diú₄ bá₄ 'éi₂, në₃ cón'₅ bá₄ juá'₂: “¿'E₂ guë'₂ lë₃ tsá₃ ca₂rë₃'én'₂ 'nia'₂ jág₁ quió'₅?” ");
INSERT INTO cntNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Në₁jua'₂ ca₂ŋag₄ guë'₂ jniog₄ dsa₂ bá₄ i₂ca₂chen₃ 'éi₂, në₃ cón'₅ bá₄ ca₂le₃jɨ́n₃ dsa₂ juɨg₂ qui₃dsag₅ cang₄. Ia₁ 'én₂ dsón'₂ bá₄ dsa₂ juɨg₂ a₂jme₁lɨ́n₄ Juan₅₄ jan₂ i₂'ë́₂ jág₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jaun₂ ca₂ŋag₃: ―Tsá₃ a₂jaun₂ ne₄ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jaun₂ ca₂juá'₂ Jesús: ―Ján₃ bá₄ le₂në₅ tsá₃ juá'₄ jniá₂ 'ein₂ cuë₅ bí₂ 'éi'₃ a₂jmo₂₃ ca₂le₃jë́₃ 'e₂ a₂jmo₂₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jaun₂ ca₂jme₃lióg₃ táng₃ Jesús ca₂tsɨ́'₃ dsa₂ juɨg₂ caun₂ jág₁ jáng'₅ léi₄ la₂, ca₂juá'₂: ―Jme₁chan₂ jan₂ dsa₂ i₂ca₂jmo₃ caun₂ ja₁nau₂ ca₂chéin'₃ uɨng₂ mɨ́g₂ uvas. Cang₂ jaun₂ ca₂o₃'ɨ́in₃ bá₄ ca₂ŋó₃ uë́₂ ja₁siá'₂. Gu₂ dsa₂ sián'₂ bá₄ ca₂dsia₃ ja₁nau₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Jme₁ca₂të́₂ jein₂ a₂ca₂rau₂ ja₁nau₂, ca₂chein₃ jan₂ dsa₂ i₂jme₂ti₃ quiáin₅, a₂i₁mag₂₃ con'₂ a₂ca₂tɨ́in₂ ne₄ dsa₂ i₂jmo₅ ta₁ ja₁nau₂ 'éi₂. La₁ jë₂ bá₄ ca₂cuë₃ tioin'₅₄, ca₂dsióg'₂ lɨ́in₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jaun₂ dsa₂ juɨg₅₄ ja₁nau₂, ca₂chein₃ táng₃ jan₂ i₂sián'₂, la₁ le₂jaun₂ bá₄ ca₂jmóg'₂ táng₃: jŋia'₅₄ ca₂të₂ca₂'o'₂ bá₄ ca₂cuë₃ tioin'₅₄, ca₂dsióg'₂ lɨ́in₃ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jë₁ca₂të́₂ 'nag'₂, ca₂chein₃ táng₃ jan₂ i₂sián'₂. La₁ ján₃ bá₄ le₂jaun₂ qui₂ca₂jmóg'₂ uɨg₅, ca₂dsei₂₃ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Jaun₂ ca₂juá'₂ juɨg₅₄ ja₁nau₂: “¿'E₂ jmo₅₄ jniá₂ në́₃? Chi'₂ quiáng₃ i₂'nióg₃ guë́₄ lɨn₃ tsɨng₅₄. 'An₁ jme₃gain₃ bá₄ i₂në₅.” ");
INSERT INTO cntNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","La₁ jme₁ca₂jág₂ i₂tion'₅₄ jmo₅ ta₁, ca₂quɨin'₃ jág₁, ca₂juá'₂: “I₂në₅ bá₄ tɨn₃ a₂la₂ cang₂. Në₃ o₁jŋɨ́i'₄ jniog₄, ia₁jaun₂ jniog₄ bá₄ lé₂ quián₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jaun₂ ca₂dsei₂₃ ca₂i₁jŋag'₂ 'nɨ'₂ ja₁nau₂. ¿'E₂ bá₄ jmo₃ dsa₂ i₂quió'₅ ja₁nau₂ në́₃, quian'₅₄ dsa₂ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Guain'₂ jme₃dsiain₂₃ dsa₂ i₂tion'₅₄ ja₁nau₂. O₄gú₃ i₂sián'₂ bá₄ ŋág₃ ja₁nau₂ quió'₅. Jme₁ca₂nág₂ dsa₂ jág₁ në₅, ca₂juá'₂: ―¡Tsá₃ juɨ₁le₅₄ le₂në₅! ");
INSERT INTO cntNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jaun₂ ca₂jág₂ Jesús, jaun₂ ca₂juá'₂: ―¿'E₂ guë'₂ 'nió'₄ jein₅ jág₁ ja₁juá'₂ ne₄ Si₂? Nɨ₁cang₁ a₂tsá₃ ca₂rë₃ji'₅₄ të₅'ia'₂, ca₂dsióg₃ ca₂lë₃ nɨ₁cang₁ a₂dsen₅₄ guë́₄ të₁ron₅₄ qui'₅₄ 'ia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ca₂le₃jɨ́n₃ i₂tsɨ₃sén'₂ ne₄ nɨ₁cang₁ jaun₂ lé₂ le₁juɨg₁ le₁dsog'₅₄ quió'₅; në₁jua'₂ nɨ₁cang₁ guë'₂ në́₃ ca₂tá'₂ ne₄ quió'₅, lé₂ 'liog₂. ");
INSERT INTO cntNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dsɨ₂juɨ₅ jaun₂ jme₁'nio₃ juɨg₅₄ jme₂dsa₂, të₅juá'₅ në́₃, jme₁tsáun'₂, ia₁ ca₂rë₃lí'₄ a₂'ɨn₅ 'éi₂ bá₄ Jesús, a₂ca₂juá'₂ jág₁ jáng'₅ léi₄ jaun₂. La₁ dsa₂ juɨg₂ bá₄ ca₂rë₃gain₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Cón'₂ ca₂chein₃ dsa₂ i₂jŋia'₅₄ con'₂ tiog₅, tsá₃ jme₂li₅₄, jmo₂₃ a₂lɨ́in₅ dsa₂ dsen₃, jme₁'no'₂ juɨ₅ 'a₂ lia'₂ jme₁jo₁₂ jua'₅₄ ca₂jon₄ bá₄ jág₁ 'lia'₂ jme₁'ŋiá₃ Jesús. Jaun₂ jme₁dsi₁jáng'₂ ne₄ bí₂ 'éi'₃ a₂'io₅ dsi₄má'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jaun₂ ca₂ŋɨ́i'₃ Jesús jág₁ la₂: ―Të₅, ne₄ jnia'₅₄ dsón'₂ bá₄ lia'₂ tí₅ jág₁ jme₂tɨ́ng'₁ dsa₂, tsá₃ jua'₅₄ jma₃quén₅ jɨng'₅₄ dsa₂; jme₂tɨ́ng'₁ dsa₂ con'₂ lë́₅ juɨ₅ tí₅ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jua'₅₄: ¿'I₄ 'éi'₃ qui₅₄ 'lia'₅₄ quió'₅ dsɨ₂tan₅₄ César, o₃ tsá₃ qui₅₄ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","La₁ ca₂rë₃lí'₄ bá₄ Jesús mai₅₄ quió'₅ dsa₂ 'éi₂. Jaun₂ ca₂ŋag₃: ");
INSERT INTO cntNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―'Ë₄ de'₂ 'nia'₂ caun₂ cu₄ 'ua'₂. ¿'Ein₂ quió'₅ nió'₄ chi₁ton₅? ¿'A₂ lia'₂ chein₂ juá'₂ letras tio'₅₄ në₅? ");
INSERT INTO cntNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","―Quió'₅ gui'₅₄ emperador César bá₄ ―juá'₂ jaun₂ në́₃. Jaun₂ guë́₄ ca₂juá'₂ Jesús: ―Jang'₅₄ guë'₂ 'nia'₂ jaun₂ në́₃, ne₄ César con'₂ a₂ca₂tɨ́n₂ César; ne₄ Diú₄ në́₃ jang'₅₄ 'nia'₂ con'₂ a₂ca₂tɨ́n₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jaun₂ tsá₃ ca₂tió'₃ jua'₅₄ a₂jo₅₄ quian'₅₄ jág₁ të₃jë₄ jág₅ dsa₂ jaun₂. Të₂le₃ ca₂i₃gó'₃ dsɨ́₅ bá₄ jág₁ a₂ca₂jéin'₃ Jesús; tei₄ bá₄ co₂ŋei'₅₄ ca₂i₃léin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jaun₂ ca₂jme₃quián₃ i₂lɨn₅₄ dsa₂ saduceos, i₂jme₂tag₅ a₂tsá₃ jen'₅₄ 'lag₄, ca₂o₃ŋag₅₄: ");
INSERT INTO cntNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Të₅, ca₂quiog₂ Moisés si₂ a₂juá'₂, në₁jua'₂ ca₂jon₃ jan₂ dsa₂ ŋe'₂ të₃ tsá₃ ca₂can₃ 'io₅₄ quiáin₅ guein₂, tion₅₄ 'nió'₅ jén'₂ gu₂ dsó₂ rɨn'₅₄ dsa₂ ŋe'₂ i₂ca₂jon₃ quian'₅₄ 'io₅₄ 'nág₂ 'éi₂, ia₁jaun₂ guein₂ i₂le₃chan₂ quiáin₅, lé₂ co₂'nió'₄ tsɨ₁jon₂ 'lag₄ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jaun₂ në́₃, jme₁chan₂ guion₃ dsa₂ ŋe'₂ i₂jme₁lë́₄ rɨn'₅₄. Ca₂jen'₂ gu₂ i₂le₂'uɨg₅₄, la₁ ca₂join₃ bá₄ të₃ tsá₃ guein₂ ca₂can₃ 'io₅₄ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jaun₂ ca₂caun₃ táng₃ i₂ca₂të́₂ on₃, ");
INSERT INTO cntNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","le₂jaun₂ bá₄ i₂ca₂të́₂ ún₂ në́₃, ca₂cain₃ 'io₅₄ 'éi₂. Le₂jaun₂ bá₄ ca₂lë₃ quian'₅₄ ta₁guion₃. Ca₂dsain₃ bá₄; 'i₁jan₂ guein₂ tsá₃ ca₂can₃ 'io₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jë₁ca₂tó'₂, ca₂jon₃ bá₄ 'io₅₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jaun₂ në́₃, jmɨg₄ jë₁ma₂të́₂ rë₁jen'₅₄ 'lag₄, ¿'ein₂ bá₄ quián₅ lé₂ 'io₅₄ 'éi₂? Ia₁ ta₁guion₃ bá₄ guë'₂ dsa₂ ŋe'₂ i₂ca₂guá₂ quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jaun₂ ca₂ŋag₃ Jesús: ―Dsa₂ i₂chan₂ ne₄ gua'₅₄ 'uë₃ jmɨg₄ në₃, tioin'₅₄ qui₂jéin'₂ gu₂, qui₂jéin'₂ gu₂ chi'₂ quiáin₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","La₁ i₂ca₂tɨ́n₂ tɨ́n'₄ ja₁tiain'₃ mɨ₂güɨ́g₃ caun₂, i₂tɨn₅₄ jen'₅₄ ja₁jme₁rë₂'lɨin₅₄, ja₁jaun₂ guë́₄ tsá₃ ma₃'ein₂ jén'₂ gu₂, on₃ guë́₄ qui₃jéin'₂ guë́₄ gu₂ chi'₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ia₁ tsá₃ ma₂'ein₂ lé₂ dsián₃. Ja₁jaun₂ ma₂léin₂ juɨ₁lia'₂ lɨ́n₅ ángeles, léin₂ jaun₅ Diú₄, ia₁ ma₂ca₂rë₃cháin₃ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","La₁ juɨ₁lia'₂ a₂jen'₅₄ 'lag₄, ca₂të₂ Moisés ca₂cuë₃ léi₄ jme₁ca₂tó'₂ ne₄ Si₂ a₂ca₂lë₃ quian'₅₄ nɨ₁'ma₂ taun₅, ja₁juá'₂ 'ɨin₂₃ Te₁gui'₅₄: “Diú₄ quián₅ Abraham, Diú₄ quián₅ Isaac, Diú₄ quián₅ Jacob.” ");
INSERT INTO cntNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jaun₂ në́₃ tsá₃ lɨ́in₅ Diú₄ quián₅ 'lag₄; Diú₄ quián₅ dsa₂ i₂jén'₃ bá₄ lɨ́in₅, ia₁ o₄quió'₄ 'éi₂ bá₄ chan₂ le₃jɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jaun₂ ca₂ŋag₃ i₂lɨn₅₄ të₅juá'₅: ―Të₅, 'ŋio₅ jlá'₁ jág₁ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tsá₃ ma₃ca₂tiá₃ dsɨ́₅ jua'₅₄ a₂ŋag₃ guë́₄ 'e₂ ŋag₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂: ―¿'A₂ lia'₂ lë́₅ në́₃ a₂juá'₂ dsa₂ a₂lɨ́n₅ tsɨ₁jon₂ David I₂rë₂'ɨ́n₁ quián₅ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Jua'₂ 'ŋiog₅ bá₄ guë'₂ David ca₂tióng₃ ne₄ si₂ Salmos, ca₂juá'₂: Ca₂juá'₂ Diú₄ ca₂tsɨ́'₃ Te₁gui'₅₄ quiáng₃: “Né₂ con₂ jniá₂ të₂le₃ gu₃ ne₁, ");
INSERT INTO cntNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ca₂lia'₂ ca₂të́₂ jmɨg₄ a₂tón'₄ jniá₂ dsa₂ i₂'iog₅₄ o₄tag'₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Chi₂jua'₂ le₂në₅ juá'₂ David të́₂ Te₁gui'₅₄, ¿'a₂ bá₄ lia'₂ lë́₅ jaun₂ a₂juá'₂ lɨ́in₅ jaun₅ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Të₃ nag₅ ca₂le₃jɨ́n₃ dsa₂ i₂tion'₅₄, ca₂tsɨ́'₃ dsa₂ i₂quiain'₅₄ le₂la₂: ");
INSERT INTO cntNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Te₃ŋi'₅₄ 'nia'₂ quian'₅₄ të₅juá'₅, ia₁ 'ŋio₅ 'ŋio₂ dsɨ́₅ i₂nioi₅₄ jláin'₁ le₁qui'₂ tsɨ₁'mɨ'₂ chen'₅₄ jang₄; të₅ dsɨ́₅ qui₂cuag₃ dsa₂ Diú₄ juɨ₁lia'₂ jë₄ 'ma'₅₄, jmá'₃ lia'₂ ne₄ 'ma₂sɨ₅₄ dsen₅₄ bá₄ 'no'₂ tiain'₃ juɨ₁lia'₂ dsi₂néi₂ guá'₅ sinagogas; le₂jaun₂ bá₄ 'no'₂ ja₁jme₂juag'₂ dsa₂ juɨ₁lia'₂ ja₁niog₅ jmɨg₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Qui₂jŋiá'₂ 'ne₄ 'io₅₄ 'nág₂; a₂tsá₃ jme₂li₅₄ jmo₂₃ chi₂léin'₂ Diú₄ uë́₂. Tson₂ guë́₄ uɨg₅ 'ë́₂ Diú₄ quió'₅ i₂le₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jaun₂ ca₂chóg'₃ Jesús ne₅₄, ca₂jɨ́in₂ dsa₂ cha₂ cu₄ i₂dsɨ₂lén₂ dsɨ₂tio'₂ cu₄ 'ŋió'₃ tsɨ₁gu₅ ja₁tio'₅₄ ofrendas. ");
INSERT INTO cntNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jaun₂ ca₂jɨ́in₂ táng₃ jan₂ 'io₅₄ 'nág₂ te₂ŋé₂ ca₂tó'₂ tɨn₃ ŋí₁ guéin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jaun₂ ca₂juá'₂ Jesús: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, 'lióng₂ guë́₄ në₂tió'₂ 'io₅₄ 'nág₂ te₂ŋé₂ në₅ lia'₂ con'₂ guë́₄ ca₂le₃jɨ́n₃ i₂ma₂në₂tió'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ia₁ 'éi₂ në́₃, cu₄ a₂ma₂qui₂rë₂tsón₂ bá₄ jaun₂ quió'₅ cuë₂₃; dsa₂ mɨ́₂ në₅ në́₃, në₂cuë₃ ca₂le₃jë́₃ a₂jme₁ron₅ quió'₅ bá₄, 'nió'₄ a₂jme₁lá₃ a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","I₂lɨn₅₄ dsa₂ jme₁tióin₂ dsia₂₃ jág₁ a₂ja₂né₂ guá'₅ templo, ia₁ a₂ŋɨ́₄ lë₃ jlá'₁ nɨ₁cang₁ a₂le₁juɨ́₄, ca₂le₃jë́₃ guë́₄ a₂jlá'₁ tio'₅₄ a₂qui₂ma₂cuë₃ dsa₂ co₂'nió'₄ ofrendas. Jaun₂ ca₂juá'₂ Jesús: ");
INSERT INTO cntNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ca₂le₃jë́₃ a₂jág'₂ 'nia'₂ tióng'₂ në₅, já₅ caun₂ jmɨg₄ jë₁dsɨ₃'én₂, tsá₃ ma₃'e₂ nɨ₁cang₁ te₂'ŋiá₄ jua'₅₄ a₂le₁juɨ́₄ guë́₄ lé₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jaun₂ ca₂ŋag₃ dsa₂ në́₃: ―Të₅, ¿lɨ́g'₂ jaun₂ lé₂ a₂në₅? ¿'E₂ bá₄ léi₄ le₃cha₂ jë₁ma₂ja₂quián₃ lé₂ a₂jaun₂? ");
INSERT INTO cntNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jaun₂ ca₂ŋag₃: ―Jmo₄ 'nia'₄ 'í₁ tsá₃ i₂cuɨ́n₅ 'nia'₂ jua'₅₄ a₂jme₃gau₅ dsa₂. Ia₁ i₂juɨn₅ lɨn₃ i₂të₁i₃nio₄ i₂juá'₂ i₂nioi₅₄ o₄quió₃ jniá₂, a₂juá'₂ në́₃: “Jniá₂ bá₄ 'éi₂”; juá'₂ ján₃: “Ma₂ja₂quián₃ jmɨg₄ jaun₂”. La₁ tsá₃ i₂o₂nó'₅ 'nia'₂ chi₁co'₅₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ia₁ jë₁ma₂ca₂nei'₂ 'nia'₂ 'ei₅ jág₁ a₂nio₃ 'nei₂, tón'₃ dsa₂ mɨ'₅₄ në́₃, tsá₃ tón'₁ 'nia'₂ go₂'i₃, ia₁ le₂jaun₂ de'₂ jŋiá₅ ca₂tɨ́n₂ lé₂ bá₄, la₁ on₃jua'₅₄ a₂ma₂dsian₅ dsɨ₂juɨ₅ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jaun₂ ca₂tsɨ́'₃ táng₃ dsa₂: ―Qui₃nio₃ 'nei₂ juɨ₁lia'₂ caun₂ juɨg₂, qui₂quɨ́in'₂ quian'₅₄ juɨg₂ siá'₂; jme₃'uán'₃ dsa₂ ca₂taun₂ ca₂taun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Qui₂dsɨ₃bi₅₄ 'uë₃ tiá₂, jiá₃ 'on₅₄ dsa₂ ca₂le₂con₂, 'í₂ jmɨ₁uɨg₅ në́₃; jnia₅₄ gau₂ dsɨ₁ guei'₅₄, 'lióng₂ léi₄ ca'₅₄ qui₂le₃jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","La₁ né'₃ a₂lé₂ ca₂le₃jë́₃ a₂në₅, qui₃tsán'₂ dsa₂ 'nia'₂ qui₂co₃'ein₃ dsa₂. Dsi₁jang'₂ dsa₂ o₄gú₃ dsɨ₂tan₅₄ quián₅ guá'₅ sinagoga, jaun₂ guë́₄ to'₂ né'₃ 'má₃. Dsi₁jó₂ ne₄ rag₅₄ ne₄ dsi₄má'₂ në́₃ 'uɨg₅₄ quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ja₁jaun₂ cuɨn₃ jmɨg₄ a₂jang'₅₄ 'nia'₂ jág₁ dsau₅ a₂'ág'₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","'Éi₂ 'nia'₂ caun₂ 'au'₂, tsá₃ 'náu'₂ 'nia'₂ 'au'₂ të₃jŋiá₅ 'a₂ lia'₂ long'₅₄, ");
INSERT INTO cntNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ia₁ 'ŋió₃ bá₄ jniá₂ cuë₅₄ jág₁ a₂tɨng'₂ a₂ŋi'₅₄ 'nia'₂ 'a₂ lia'₂ ŋag'₅₄, ca₂lia'₂ jŋia'₅₄ tsá₃ ma₃'e₂ ŋi₅ ŋag₃ ca₂le₃jɨ́n₃ dsa₂ i₂'iog₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ca₂të₂ chog'₂-ŋéi'₅ 'nia'₂ qui₃jáng'₂, ca₂të₂ chi'₂ rɨ́ng'₂, o₁rɨ́ng'₂, a₂mei₅₄ quiáng'₂ në́₃. I₂lɨn₅₄ 'nia'₂ jme₃dsiog₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ca₂le₂con₂ bá₄ jme₃'ŋia₅₄ dsa₂ 'nia'₂ o₄quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","La₁ tsá₃ can₂ 'nia'₂ o₂i₁ dsɨ₅, ia₁ ca₂lia'₂ jŋia'₅₄ 'i₁ca₂mɨ'₂ jŋi₂ dsei'₂ 'nia'₂ tsá₃ dsɨ₃'én₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Në₁jua'₂ ca₂nau'₂ 'nia'₂ tiá₂, dsi₁no'₃ 'nia'₂ tɨ́n'₄ jme₂dsí₂ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Jë₁ma₂ca₂jag'₅₄ 'nia'₂ ma₂le₁lio₃ 'lióg₂ le₃lág'₃ juɨg₂ Jerusalén, jaun₂ guë́₄ le₃len'₅₄ 'nia'₂ ma₂ja₂quián₃ 'én₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dsa₂ i₂tián'₅ 'uë₃ Judea jmɨg₄ jaun₂, juɨ₁cuɨng₁₂ le₃má'₂; i₂tián'₅ jë₄ juɨg₂ guë'₂ në́₃, juɨ₁'uɨin₂; juɨ₁lia'₂ i₂tion'₅₄ ja₁nau₂ guë'₂, tsá₃ ma₃juɨ₁ja₂lein₅. ");
INSERT INTO cntNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ia₁ lé₂ jmɨg₄ a₂le₃chan₂ dsa₂ gue₃ jmɨ₁uɨg₅ 'ŋio₅ lɨn₃, a₂le₃ti₃ ca₂le₃jë́₃ lia'₂ con'₂ lë́₅ juá'₂ ne₄ Si₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Juɨ́g₂ juɨ₁lia'₂ dsa₂ mɨ́₂ i₂le₁quian₅ guein₂, juɨ₁lia'₂ i₂chan₂ guein₂ bë'₅₄ i₂'ɨ́n'₂ dsi'₅₄ quió'₅ në́₃, jmɨg₄ jaun₂! Ia₁ go₂'i₃ 'ŋio₅ lɨn₃ të₃tsɨ'₅₄ gua'₅₄ 'uë₃, a₂le₃jniá₂ a₂'ne₂ Diú₄ ne₄ quió'₅ dsa₂ juɨg₂ la₂; ");
INSERT INTO cntNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ia₁ dsɨ₃gan'₅₄ i₂dsián₃ quian'₅₄ ŋi₁tág₂; i₂lɨn₅₄ guë'₂ qui₃të₂ dsa₂ le₁'ŋei'₅₄ ca₂le₂con₂ go₄ dsɨ₂nau₂. Co₂dsia₅ qui₃tsó'₃ dsɨ₂nau₂ juɨg₂ Jerusalén, ca₂lia'₂ ca₂dsɨn₃ jmɨg₄ quió'₅ dsɨ₂nau₂ a₂'i₄ 'éi'₃ tóin'₃ goin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Jmɨg₄ jaun₂ lé₂ léi₄ të₂le₃ quian'₅₄ 'iog₂, tsɨ'₂, nei₅ në́₃. Ta₁caun₂ gua'₅₄ 'uë₃ tón'₃ dsa₂ tiá'₃ quɨ'₂ dsɨ́₅, tsá₃ a₂ŋi₅ jmo₃, jmɨ₁ŋí'₄ guë'₂ në́₃ lé₂ gau₂ qui₃jná'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tón'₃ dsa₂ qui₃nei'₂ a₂le₃gó'₃, 'ɨ₅ dsɨ́₅ ne₄ ca₂le₃jë́₃ 'e₂ niog₅ lé₂ mɨ₂güɨ́g₃. Ia₁ ca₂të₂ juɨ₅bí₂ a₂cha₂ guei'₅₄ mɨ₂güɨ́g₃ qui₃guian'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jaun₂ guë́₄ jɨ́n₂ dsa₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ jiá₃ jë₄ jnei₅ a₂'uain'₂ a₂jláin'₁ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jë₁ma₂ca₂rë₃lióg₃ lë́₂ a₂në₅, quen'₂ 'nia'₂ bí₂, 'a₃ jlian₅₄ 'nia'₂, ia₁ ja₃quián₂ jmɨg₄ a₂lión'₂ 'nia'₂ co₂ŋei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jaun₂ ca₂juá'₂ táng₃ caun₂ jág₁ jáng'₅ léi₄ la₂: ―Ŋí₂ 'nia'₂ juɨ₁lia'₂ lë́₂ quian'₅₄ nɨ₁'ma₂ higuera, juɨ₁'e₂ guë́₃ nɨ₁'ma₂ siá'₂ në́₃; ");
INSERT INTO cntNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","jë₁ma₂ca₂ne'₅₄ mog'₅₄, cáun'₂ 'nia'₂ 'í₂ guiong'₅₄ a₂ja₂quián₃ jein₂ 'iog₂ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ján₃ bá₄ le₂në₅, jë₁ma₂të́₂ ne'₅₄ 'nia'₂ lë́₂ ca₂le₃jë́₃ a₂në₅, le₃ŋi'₅₄ 'nia'₂ a₂ma₂ja₂quián₃ le₃gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A₂dsɨ₂jó'₃ juá'₅ jniá₂ juɨ́g₂ 'nia'₂, tsá₃ dsɨ₃ŋɨ́₂ tsɨ₁jon₂ jmɨg₄ në₃, ca₂lia'₂ ca₂lë₃ ca₂le₃jë́₃ a₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dsɨ₃ŋɨ́₂ guei'₅₄ mɨ₂güɨ́g₃ quian'₅₄ gua'₅₄ 'uë₃, la₁ jág₁ quió₃ në́₃, o₁lɨ́g'₂ tsá₃ dsɨ₃ŋɨ́₂ jua'₅₄ tsá₃ le₃ti₃. ");
INSERT INTO cntNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Të₃ŋi'₅₄ 'nia'₂, tsá₃ i₂jme₂cán'₁ táng₃ 'nia'₂ 'au'₂ a₂i₂niog'₅₄ dsɨng'₅₄ le₁'eng'₅, tsá₃ caun₂ a₂'ɨ₅ 'au'₂ a₂chang'₂ mɨ₂güɨ́g₃ la₂, con'₂ tsá₃ ŋó₅ në₁jua'₂ ca₂jo₃ jmɨg₄ jaun₂ 'nia'₂ co₂tiá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Juɨ₁lia'₂ ja₁ta'₂ caun₂ tsɨ₁liá₂ bá₄ lé₂ jmɨg₄ jaun₂ ne₄ quió'₅ ca₂le₃jɨ́n₃ dsa₂ i₂tián'₅ ne₄ gua'₅₄ 'uë₃. ");
INSERT INTO cntNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jaun₂ chan'₂ 'nia'₂ rë₂jáng'₁, chi₁leng'₄ Diú₄ ca₂le₃jë́₃ jmɨg₄, ia₁jaun₂ bá₄ quɨn'₅₄ 'nia'₂ jmɨg₄ lióng'₂ ne₄ ca₂le₃jë́₃ a₂niog₅ lé₂ në₅, ia₁jaun₂ dsi₁nóg'₅ të₃tsɨng'₅₄ ne₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ca₂le₃jë́₃ jmɨg₄ bá₄ jme₁jme₂tag₂₃ i₁dsi₅ guá'₅ templo, jë₁ma₂ca₂nei₂ dsó₅ dsɨ₂jŋia₅₄ má'₂ ja₁chei₂ Olivos. ");
INSERT INTO cntNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ca₂le₃jɨ́n₃ bá₄ dsa₂ jme₁ja₂léin₂ të₂ o₃'iog₂ i₁dsi₅ guá'₅ a₂ja₂néi₃ jág₁ a₂cuë₂₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jme₁ma₂ja₂quián₃ jmɨg₄ quió'₅ i₁ŋí'₄ a₂tsá₃ levadura rë₂jŋia₅, a₂chei₂ Jmɨg₄ Të₂'ɨn₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jaun₂ qui₂ca₂'náu'₃ dsɨ́₅ juɨg₅₄ jme₂dsa₂, të₅juá'₅ në́₃, 'a₂ lia'₂ cuɨn₃ jmɨg₄ jŋag'₃, ia₁ a₂gain₃ dsa₂ juɨg₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jaun₂ ca₂'í₃ Satanás dsɨ́₅ Judas, i₂të́'₂ Iscariote, i₂jme₁lɨ́n₄ jan₂ dsa₂ i₂guia₃-tɨ́n₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas 'éi₂ në́₃ ca₂ŋei₅₄ ca₂i₁jmo₅₄ jág₁ quian'₅₄ juɨg₅₄ jme₂dsa₂, quian'₅₄ i₂lɨ́n₅ 'lióg₂ dsen₅₄ quián₅ guá'₅ templo në́₃, 'a₂ lia'₂ jáng'₂ jɨ́in'₂ Jesús o₄gú₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jaun₂ 'io'₂ jén'₅ bá₄ dsa₂ 'éi₂, ca₂jmo₃ jág₁ a₂cuë₃ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jaun₂ ca₂cuë₃ Judas jág₁ quió'₅. Jaun₂ ca₂'náu'₃ dsɨ́₅ 'a₂ lia'₂ jáu₂ juɨ₅ a₂jáng'₂ con'₂ jme₁tsá₃ juɨn₅ dsa₂ ma₃quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ca₂të́₂ jme₁ca₂të́₂ jmɨg₄ quió'₅ i₁ŋí'₄ a₂tsá₃ levadura rë₂jŋia₅, con'₂ ca₂tɨ́n₂ dsa₂ jme₂dsiain₂₃ guein₂ já'₂ cha'₂ quián₅ Jmɨg₄ Të₂'ɨn₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jaun₂ ca₂chen₃ Jesús Pe₄ quian'₅₄ Juan₅₄, ca₂juá'₂: ―O₂nó'₅ 'nia'₂ o₂jmo₄ co₂jŋia₅₄ má₃ quián₂ jniog₄ a₂que₅₄ Jmɨg₄ Të₂'ɨn₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jaun₂ ca₂ŋag₃ 'éi₂: ―¿A₂já'₄ 'niog'₂ dsɨ₁jmó₁ jnia'₅₄ co₂jŋia₅₄? ");
INSERT INTO cntNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jaun₂ ca₂juá'₂: ―Jë₁ma₂dsi₃nó'₅ 'nia'₂ jë₄ juɨg₂, jme₃jein'₂ jan₂ dsa₂ ŋe'₂ i₂ŋá'₅ quion₂ caun₂ nɨ₁dsɨg₁ 'a₄ jmɨg₂. O₁'éin'₃ 'nia'₂ ca₂të₂ dsi₂néi₂ ja₁'í₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jaun₂ juɨg'₅₄ 'nia'₂ dsa₂ juɨg₅₄ dsi₂néi₂: “Le₂la₂ juá'₂ Të₅ tsɨ́'₅ 'ne₂: ¿Na₂ bá₄ dsi₂néi₂ ja₁guë'₅₄ má₃ quió'₅ Jmɨg₄ Të₂'ɨn₅₄ quiang'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáng₃?” ");
INSERT INTO cntNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jaun₂ 'ë₃ caun₂ ja₁lë́₄ dsi₂néi₂ juë'₂ guei'₅₄ ja₁ma₂lë́₅ co₂jŋia₅₄ quió'₅. Ja₁jaun₂ jmo₄ co₂jŋia₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jaun₂ ca₂i₃lén₂ bá₄ 'éi₂ në́₃. Ca₂lë₃ rë'₂ lia'₂ con'₂ lë́₅ jág₁ jaun₂. Ja₁jaun₂ ca₂jmo₃ má₃ quió'₅ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jme₁ca₂të́₂ hora jaun₂, ca₂guá₂ Jesús ne₄ mesa, quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jaun₂ ca₂tsɨ́'₃ 'éi₂: ―¡Lɨ́g'₂ bá₄ 'ɨ́n₅ dsɨ₃ guë'₅₄ má₃ Jmɨg₄ Të₂'ɨn₅₄ la₂ quian'₅₄ 'nia'₂, né'₃ a₂dsɨ₃ŋɨ́g₂ uɨg₅! ");
INSERT INTO cntNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ia₁ juá'₅ jniá₂ juɨ́g₂ 'nia'₂, tsá₃ ma₃lɨ́g'₂ jmɨg₄ jua'₅₄ guë'₅₄ guë́₄ má₃ le₂la₂ ca₂lia'₂ ca₂të́₂ jmɨg₄ i₁le₃ti₃ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jaun₂ ca₂tɨ́in₂ copa, ca₂cuë́'₃ ti₁'mag'₄ Diú₄, jaun₂ ca₂juá'₂: ―Ján'₅ 'nia'₂ a₂la₂; jmo₄ dsióg₁ jɨn₄ rɨ́ng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ia₁ juá'₅ jniá₂, tsá₃ ma₃lɨ́g'₂ jmɨg₄ jua'₅₄ a₂guɨ'₅₄ guë́₄ jmɨ'₅₄ mɨ́g₂ uvas le₂la₂, ca₂lia'₂ ca₂të́₂ jmɨg₄ i₁le₃ti₃ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jaun₂ ca₂tɨ́in₂ táng₃ caun₂ i₁ŋí'₄, ca₂cuë́'₃ ti₁'mag'₄ Diú₄. Jaun₂ ca₂'niai₃ ca₂cuë́'₃ 'éi₂, ca₂juá'₂: ―Ŋɨ₃ bá₄ jniá₂ i₁ŋí'₄ la₂, a₂ma₂rë₂jang'₅₄ o₄quián'₂ 'nia'₂. Jmo₄ 'nia'₂ a₂la₂ a₂dsiog'₂ 'au'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ján₃ bá₄ le₂në₅, jme₁ma₂ca₂lë₃ guë́'₅ i₁ŋí'₄, ca₂can₃ táng₃ copa, jaun₂ ca₂juá'₂: ―A₂'a₄ copa la₂, lë́₅ jág₁ 'mɨ́₂ a₂të₃ron₅₄, a₂lɨ'₅₄ të₂le₃ quian'₅₄ jmɨ₃ a₂dsɨ₃'o₅₄ o₄quián'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’La₁ në₃ në́₃, ne₄ mesa la₂ guá₅ quian'₅₄ jniá₂ i₂jáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Dsón'₂ bá₄ 'en₅₄ juɨ₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃ dsióg₄ ja₁'ein₅₄ 'éi'₃ dsióg₄, la₁ ¡'e₂ guë́₄ juɨ́g₂ dsa₂ i₂jáng'₂! ");
INSERT INTO cntNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jaun₂ ca₂jme₃lióg₃ tsɨ₂ca₂jɨ́in₂ quiain'₅₄ rɨin'₅₄, 'ein₂ bá₄ 'éi₂ i₂jmo₃ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ján₃ bá₄ ca₂lë₃ mɨ'₅₄ jë₄ quió'₅, ne₄ 'uɨg₅₄ 'ein₂ 'éi₂ i₂lén₂ i₂dsen₅₄ guë́₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jaun₂ ca₂juá'₂ Jesús: ―Ca₂le₃jɨ́n₃ rag₅₄ quián₅ dsɨ₂nau₂, tiain'₂₃ goin₂ jmo₂₃ 'éi'₃ lia'₂ lë́₂ dsɨ́₅. Le₂jaun₂ guë'₂ i₂le₁'io₅ 'éi'₃ i₂le₁'ɨ́n₁ quiáin₅, 'ag₅ dsa₂ a₂lɨ́in₅ dsa₂ i₂jmo₅ a₂dse₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","La₁ tsá₃ le₂jaun₂ lé₂ quian'₅₄ 'nia'₂. Juɨ₁lia'₂ i₂can'₅₄ jë₄ quián'₂ 'nia'₂, juɨ₁jmo₁₂ mei'₂. Le₂jaun₂ guë'₂ i₂cán₂ ne₄ juɨ₅, juɨ₁jmo₁₂ në₂jag₄ bá₄ i₂jme₂ti₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Jaun₂ në́₃, ¿'ein₂ i₂dsen₅₄ guë́₄: i₂guá₅ ne₄ mesa, o₃ i₂dsia₅ má₃ 'e₂? ¿'On₁ i₂guá₅ ne₄ mesa bá₄? La₁ jniá₂ 'eng₅₄ jë₄ quián'₂ 'nia'₂, lɨ́ng₅ jan₂ i₂jme₂ti₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","'Nia'₂ guë'₂ lɨ́ng'₅ i₂ma₂ja₂nóg'₅ quiong'₅₄ jniá₂ jë₄ uɨg₅ a₂qui₂ma₂i₂ŋɨ́g₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","'Uɨg₅₄ në₅ në́₃, dsián₄ jniá₂ 'nia'₂ ja₁o₁tiáng'₂ gong'₂, juɨ₁lia'₂ ma₂dsiog₃ Ŋe'₃ jniá₂, ");
INSERT INTO cntNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ia₁jaun₂ o₁qué'₂ o₁'én'₂ 'nia'₂ ne₄ mesa quió₃ ja₁gong₂, ja₁jaun₂ o₁tián'₂ 'nia'₂ ne₄ta₁ a₂qui₁dsɨ'₂ 'éi'₃ quió'₅ ta₁guia₃-tɨ́n₂ nió'₃ tsɨ₁jon₂ dsa₂ juɨg₂ Israel. ");
INSERT INTO cntNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ján₃ bá₄ ca₂juá'₂ Te₁gui'₅₄: ―Si₂mu₅₄, Si₂mu₅₄ ―ca₂tsɨ́'₃ Pe₄―, i₂së₃dsen₃ ma₂në₂mag₃ 'ŋiái'₂ 'nia'₂ lia'₂ ja₁'ŋiá'₂ dsa₂ trigo, ");
INSERT INTO cntNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","la₁ jniá₂ ma₂në₂mɨ₃ o₄quián'₂ 'ne₂, ia₁jaun₂ tsá₃ dsiá₃ éi₃ a₂'éng'₂. 'Ne₂ në́₃, jë₁ma₂ca₂jéin'₃ táng₃ 'au'₂, cuë'₅₄ bí₂ rɨ́ng'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jaun₂ 'éi₂ në́₃ ca₂ŋag₃: ―Te₁gui'₅₄, caun₂ bá₄ ma₂'ei₅ dsɨ₃ i₁'ú₃ né'₃ 'má₃ co₂lë₅ quian'₅₄ 'ne₂, o₁jŋia'₅₄ 'mú₃ ca₂quɨ́n₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jaun₂ ca₂ŋag₃ Jesús: ―Pe₄, jniá₂ guë'₂ juá'₅, tsá₃ 'o₃ të₁guí₄ dsó₂ në₃, ca₂lia'₂ ma₂në₂jua'₅₄ 'ne₂ 'nɨ₅ ráun₂ a₂tsá₃ tóng'₄ a₂cuɨg'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jaun₂ ca₂juá'₂: ―Lia'₂ con'₂ ca₂tsɨ́ng₂ 'nia'₂, lia'₂ con'₂ tsá₃ tsɨ₁na'₅₄ jme₁le₁quian'₄, on₃ guë'₂ të₂lau₂, on₃ guë'₂ nɨ₁lau₂ ton₅ tag'₅₄ në́₃, ¿cha₁ a₂ca₂rë₃'nió'₅ quián'₂ 'nia'₂? 'Éi₂ në́₃, ca₂ŋag₃: ―'I₁caun₂ tsá₃ ca₂rë₃'nió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jaun₂ ca₂juá'₂ táng₃: ―Në₃ guë́₄ në́₃ i₂'io₅ tsɨ₁na'₅₄, të₂lau₂ në́₃ juɨ₁quian₅₄. I₂tsá₃ 'io₅ ŋi₁tág₂ në́₃, o₁'nag₁₂ mɨ₂dsióg₂ quió'₅ ia₁jaun₂ lá₃ ŋi₁tág₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ia₁ juá'₅ jniá₂, tion₅₄ niog₅ le₃ti₃ ja₁con₂ jniá₂ ja₁juá'₂ ne₄ Si₂ le₂la₂: “Ŋó₃ jë₄ quió'₅ dsa₂ i₂le₁cán'₄ dso₄, ia₁ ca₂jmo₃ dsa₂ dsɨ́₅ në₂jag₄ bá₄ a₂rë₂cáin'₄ dso₄ ján₃.” Ia₁ ca₂le₃jë́₃ a₂niog₅ juá'₂ ne₄ Si₂ a₂'ag₂₃ jniá₂, tion₅₄ niog₅ le₃ti₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jaun₂ ca₂juá'₂ 'éi₂: ―Te₁gui'₅₄, la₂ tiá'₅ tɨn₃ ŋi₁tág₂. Jaun₂ ca₂ŋag₃ táng₃: ―Tió'₅ bá₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jaun₂ guë́₄ në́₃ o₂'ɨ́in₃ ŋó₃ juɨ₅ Má'₂ Olivos, ia₁ le₂jaun₂ tɨin₂ bá₄. Jaun₂ ca₂i₃lén₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jme₁ca₂dsióg₃ ja₁jaun₂, jaun₂ ca₂juá'₂: ―Chi₁len'₅₄ 'nia'₂ Diú₄ ia₁jaun₂ tsá₃ jo₅₄ juɨ₅bí₂ a₂cáun₂ táu₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jaun₂ ca₂ŋó₃ Jesús 'ŋiog₅ uɨ́ng₂ con'₂ ja₁tág'₅ ca₂mɨ́g₂ nɨ₁cang₁ a₂táun₂ dsa₂. Ja₁jaun₂ ca₂chi₃jné₃ ca₂chi₃léin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ca₂juá'₂: ―Tia₅₄, ¿tsa₁ cuɨn₅ jmɨg₄ jŋiá'₄ uɨg₅ dsɨ₃ŋɨ́g₂ la₂? La₁ia₁, juɨ₁le₅₄ bá₄ a₂'ŋio₂ 'au'₂ 'ne₂, on₃jua'₅₄ con'₂ 'nio₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jaun₂ ca₂jme₃jnia₅ jan₂ ángel ne₅₄, i₂ca₂sión₃ juɨ₅ guei'₅₄ i₂juɨ́g₃, a₂ca₂cuë₃ bí₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hora jaun₂ ca₂ŋág₃ uɨg₅ 'ŋio₅ lɨn₃, jaun₂ të₂le₃ lë́₅ guë́₄ ca₂chi₃léin'₂ Diú₄; ca₂tein₃ jme₁dsiog₂ në₂jag₄ bá₄ jmɨ₂ qui₂ca₂dsá₂ të₂ 'uë₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jme₁ca₂nau₂ ja₁chi₂léin'₂ Diú₄ jaun₂, guáin'₃ ja₁tián'₄ chi'₂ dsɨ₂guia₃-tɨ́n₂. La₁ le₁güɨ́n₃ bá₄ 'éi₂ tiáin'₅ ca₂jo₃, 'uɨg₅₄ ia₁ a₂ŋɨ́₄ lë₃ 'lia'₂ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jaun₂ ca₂juá'₂: ―¿'E₂ lë₃ le₁güɨ́n'₃ 'nia'₂ tiáng'₅? Nau₂, chi₁len'₅₄ 'nia'₂ Diú₄ ia₁jaun₂ tsá₃ jo₃ juɨ₅bí₂ a₂cáun₂ táu₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Të₃jë₄ juá'₂ Jesús jaun₂, jme₁ca₂dsi₃lén₂ juɨn₅ dsa₂. Jaun₂ ca₂dsióg₃ i₂të́'₂ dsa₂ Judas, i₂jme₁lɨ́n₄ jan₂ chi'₂ dsɨ₂guia₃-tɨ́n₂, quian₅ ne₄ juɨ₅. Jaun₂ ca₂jme₃quiáin₃ con₂ Jesús a₂jme₁chen'₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","La₁ ca₂juá'₂ Jesús: ―Judas, ¿'e₂? ¿Le₁në₅ bá₄ jɨng'₅₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃, a₂chén'₁ quió'₅? ");
INSERT INTO cntNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jme₁ca₂jág₃ i₂quian'₅₄ Jesús a₂lë́₂ jaun₂, ca₂juá'₂: ―Te₁gui'₅₄, ¿qui'₅₄ jnia'₅₄ quian'₅₄ ŋi₁tág₂? ");
INSERT INTO cntNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jan₂ 'éi₂ në́₃ ca₂quí'₃ quió'₅ i₂jme₂ti₃ ta₁ quián₅ jme₂dsa₂ dsen₅₄, ca₂jŋiá'₂ rë₂gua₅₄ ne₁. ");
INSERT INTO cntNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jaun₂ ca₂juá'₂ Jesús: ―'A₃ ma₃jmai'₅₄. Jaun₂ ca₂chóng'₃ táng₃ rë₂gua₄ 'éi₂, ca₂jme₃'lió₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jaun₂ ca₂tsɨ́'₃ juɨg₅₄ jme₂dsa₂, 'ɨ'₅₄ guá'₅, gui'₅₄ can'₅₄ në́₃ i₂dsi₃lén₂ tsáun'₂: ―¿'E₂? ¿Juɨ₁lia'₂ jë₁tsán'₂ dsa₂ 'ang₂ ja₂nóg'₅ qui₂le₁quian'₄ ŋi₁tág₂, 'ma₂ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Lɨ́g'₂ bá₄ 'eng₅₄ tián₂ quian'₅₄ 'nia'₂ i₁dsi₅ guá'₅, tsá₃ ma₂chong'₂ 'nia'₂ ja₁jaun₂. La₁ në₃ guë́₄, 'au'₂ 'nia'₂ bí₂ tiá₂ 'au'₂ jmó'₂, në₃ lia'₂ chí'₅ qui₁né'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jme₁ma₂në₂chóng'₂, ca₂tág₃ juɨ₅ ja₁quió'₄ jme₂dsa₂ dsen₅₄. La₁ Pe₄ në₃, uɨ́ng₂ bá₄ të₂quɨ́in₃ ŋó₃ 'ein₂₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dsa₂ 'éi₂ në́₃, ca₂dsia₃ si₂ i₁dsi₅, ca₂tiáin'₂ le₃lág'₃ cau₅ si₂; jë₄ jaun₂ ca₂guá₂ Pe₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Të₃jë₄ jaun₂, ca₂rë₃lí'₄ jan₂ 'io₅₄ i₂jme₂ti₃ ta₁ ja₁jaun₂, a₂guá₅ Pe₄ cau₅ si₂. Caun₂ ca₂jág₂ tiá₂, ca₂juá'₂: ―Ján₃ bá₄ jme₁quiain'₅₄ i₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","La₁ 'éi₂ në́₃, tsá₃ ca₂tioin₃, ca₂juá'₂: ―Tsá₃ 'éi₂ cuɨ́n₅ jniá₂, 'ne₂ 'io₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Jme₁co₂lág₂ jaun₂, ca₂guan₃ táng₃ jan₂, ca₂jág₂, jaun₂ ca₂juá'₂: ―Jme₁quiain'₅₄ 'ne₂ ján₃, ¿lia'₅₄? ―Jan₂'ón₄. Tsá₃ dsa₂ 'éi₂ jme₁quian'₄ jniá₂, 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Con'₂ caun₂ hora cang₂ jaun₂, tion₅₄ bá₄ tsá₃ jme₁cán₂ jan₂ jág₁, ca₂juá'₂: ―Të₃dsón'₂ jan₂ i₂jme₁quiain'₅₄ bá₄ në₅, ia₁ Galilea bá₄ ja₁chain₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Jaun₂ ca₂juá'₂ táng₃ Pe₄: ―Të₃dsón'₂ rë'₂ juá'₅ jniá₂ la₂, ca₂lia'₂ jŋia'₅₄ tsá₃ cuɨ́ng₅ 'ein₂ 'éi₂ 'ɨ́n'₅ 'nia'₂. Të₃jë₄ dsia₂₃ jág₁ jaun₂ jme₁ca₂'o₃ të₁guí₄ dsó₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jaun₂ ca₂jén'₃ Te₁gui'₅₄ ca₂jɨ́in₂ Pe₄, ca₂jmo₃ a₂dsiog'₂ dsɨ́₅ 'éi₂ 'e₂ a₂ma₂në₂juá'₂ le₂jŋiá₅: “Tsá₃ 'o₃ të₁guí₄ dsó₂ në₃, ca₂lia'₂ ma₂në₂jua'₅₄ 'ne₂ 'nɨ₅ ráun₂, a₂tsá₃ tóng'₄ a₂cuɨg'₂ jniá₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jaun₂ ca₂o₃'ɨ́in₃ ca₂tá'₂ quɨ'₂ dsɨ́₅, ca₂'o₃ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Dsa₂ i₂niog₅ jmo₅ 'í₁ Jesús në́₃, a₂lë₁qui₂co₂jmóg'₂ tioin'₅₄, ca₂cuë₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ca₂'néi₂ jme₁ne₁ Jesús, qui₂ca₂quein₃ dsɨ₂ne₅₄ jaun₂ ca₂juá'₂: ―¡Dsi₄ jág₁ 'ein₂ në₂quein₃ quiáng'₂! ");
INSERT INTO cntNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","'Lióng₂ lɨn₃ bá₄ ca₂juá'₂ tioin'₅₄, a₂të₂'o'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jme₁jnia₃ jaun₂, qui₂ca₂ŋɨ'₂ ca₂le₃jɨ́n₃ gui'₅₄ can'₅₄ quián₅ dsa₂ judíos, juɨg₅₄ jme₂dsa₂, të₅juá'₅ në́₃. Jme₁ma₂le₁ŋɨi'₂, ca₂dsi₁jŋia₃ dsa₂ Jesús ne₅₄. Jaun₂ ca₂ŋag₃: ");
INSERT INTO cntNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―¿Dsón'₂ 'ne₂ lɨ́ng'₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄? Jaun₂ ca₂ŋag₃: ―O₁jŋia'₅₄ ca₂juá'₃ jniá₂, jniá₂ 'éi₂, a₂dsón'₂ tsá₃ le₃'én'₂ bá₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Në₁jua'₂ ca₂ŋag₄ jniá₂ 'e₂ ca₂ŋag₅₄ ne'₅₄ 'nia'₂, a₂dsón'₂ on₃jua'₅₄ a₂jaun₂ jein'₅₄ 'nia'₂ jág₁ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","La₁ në₃ në́₃, të₂le₃ ne₄ juɨ₅ ja₁ŋó₄ në₅, guá₃ Jaun₅ dsa₂ mɨ₂güɨ́g₃, të₂le₃ gu₂ ne₁ Diú₄ i₂'uan'₂ guë́₄ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jaun₂ ca₂ŋag₃ ca₂le₃jɨ́n₃: ―¿Ia₁ 'ne₂ bá₄ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄, jaun₂? ―Jniá₂ bá₄ lɨ́ng₅, juɨ₁lia'₂ ma₂në₂jua'₅₄ 'nia'₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jaun₂ ca₂juá'₂ tioin'₅₄: ―¿'Ein₂ guë́₄ jmá'₃ dsa₂ 'niog₂ jniog₄ jáng'₃ jág₁ dsau₅? Jua'₂ jniog₄ guio₅₄ ma₂në₂néi₁ jág₁ a₂ma₂në₂'uë́'₃ i₂në₅ 'ŋiog₅ mɨ₂'o₅₄ chéin'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jaun₂ qui₂ca₂nau₂ ca₂le₃jɨ́n₃ ca₂jŋiai₃ Jesús ne₄ Pilato. ");
INSERT INTO cntNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ja₁jaun₂ guë́₄ ca₂'náu'₃ dsáu₁ Jesús, ca₂juá'₂: ―Ca₂jon₃ jnia'₅₄ dsa₂ la₂ jme₁'ein₅₄ dsia₂₃ mɨ'₅₄ jɨn₄ dsa₂ juɨg₂ quián₂ jnia'₅₄. Ŋɨ₂₃ toin'₂ dsa₂ jág₁ a₂tsá₃ ma₂'ein₂ quí₃ 'lia'₅₄ a₂ca₂tɨ́n₂ César; a₂jme₂tɨin₂₃ dsa₂ juá'₂ a₂lɨ́in₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄, co₂'nió'₄ a₂lɨ́in₅ rag₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jaun₂ ca₂ŋag₃ Pilato: ―¿Dsón'₂ lɨ́ng'₅ Rag₅₄ quián₅ dsa₂ judíos? Jaun₂ ca₂ŋag₃ Jesús: ―Le₂në₅ bá₄, juɨ₁lia'₂ juá'₂ 'ne₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jaun₂ ca₂juá'₂ táng₃ Pilato ca₂tsɨ́'₃ juɨg₅₄ jme₂dsa₂, quian'₅₄ dsa₂ juɨg₂: ―Tsá₃ 'e₂ dsáu₁ dsa₂ në₅ dso'₂ jniá₂ 'i₁caun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","La₁ të₂le₃ lë́₅ guë́₄ co₂mɨ'₅₄ ca₂tóin'₂, ca₂juá'₂: ―La₁ 'ŋio₅ lɨn₃ dsia₂₃ mɨ'₅₄ ŋɨ₂₃, jme₂tɨin₂₃ dsa₂ ta₁caun₂ 'uë₃ Judea. Ca₂jme₃lióg₃ Galilea, rë₂në́₃ guë'₂ ma₂ŋɨ₂₃ ja₁lá₃ jmo₂₃ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jme₁ca₂nág₂ Pilato a₂në₅, jaun₂ ca₂ŋag₃ chi₂jua'₂ 'uë₃ Galilea chan₂ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jme₁ca₂rë₃ŋi₅ në́₃, a₂lɨ́n₅ Jesús dsa₂ chan₂ të₂le₃ 'uë₃ ja₁niog₅ gu₂ Herodes, jaun₂ ca₂dsióg'₂ ne₄ 'éi₂. Ia₁ jme₁ŋɨ₂₃ juɨg₂ Jerusalén jmɨg₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","'Io'₂ jén'₅ bá₄ Rag₅₄ Herodes jme₁ca₂jɨ́in₂ Jesús, ia₁ lɨ́g'₂ bá₄ 'ɨ́n₅ dsɨ́₅ jág₂, ia₁ jme₁ma₂nág₂ bá₄ 'ei₅ jág₁ a₂'ɨn₅ dsa₂ 'éi₂. Ia₁ jme₁'ɨ́n₂ dsɨ́₅ jág₃ 'e₂ caun₂ o₂dsain₂ jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","'Lióng₂ a₂qui₂ca₂ŋɨ́i'₃ Jesús, la₁ tsá₃ ma₃'e₂ ca₂ŋag₃ 'éi₂ 'i₁caun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ja₁jaun₂ jme₁tión₂ juɨg₅₄ jme₂dsa₂ quian'₅₄ të₅juá'₅ në́₃, caun₂ qui₂ca₂'náu'₃ tion₅₄ dsáu₁ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jaun₂ Herodes në́₃, quian'₅₄ 'lióg₂ quiáin₅, lë₁qui₂ca₂jmóg'₂ tioin'₅₄, ca₂quei'₃ 'mɨ'₂ jlá'₁, jaun₂ ca₂dsióg'₂ bá₄ táng₃ ne₄ Pilato. ");
INSERT INTO cntNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jmɨg₄ jaun₂ bá₄ ca₂jmo₃ Pilato a₂mei₅₄ quian'₅₄ Herodes, ia₁ jme₁le₁'ŋiai₁₂ rɨin'₅₄ le₂jŋiá₅. ");
INSERT INTO cntNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jaun₂ ca₂ŋɨ́'₂ Pilato juɨg₅₄ jme₂dsa₂, quian'₅₄ i₂lɨ́n₅ ta₁, quian'₅₄ dsa₂ juɨg₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jaun₂ ca₂tsɨ́'₃ dsa₂: ―O₂jon'₅₄ 'nia'₂ ne₃ dsa₂ la₂, ia₁ juá'₂ 'nia'₂ a₂dsia₂₃ mɨ'₅₄ jɨn₄ dsa₂. Të₃ ne'₅₄ 'nia'₂ ma₂qui₂në₂ŋag₄ jniá₂, tsá₃ 'e₂ dsáu₁ dso'₂ jniá₂ 'i₁caun₂, lia'₂ con'₂ lë́₅ dso₄ a₂jme₂cain'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","On₃ guë'₂ Herodes ca₂dsó'₂, jaun₂ la₂ bá₄ ca₂dsióg'₂ táng₃. Jaun₂ 'i₁caun₂ tsá₃ 'e₂ cha₂ jua'₅₄ ca₂tɨ́in₂ gue₃ 'mú₃. ");
INSERT INTO cntNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","La₁ jmo₅₄ 'éi'₃ a₂bóg₂ dsa₂, jaun₂ guë́₄ loin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Jme₁jmɨg₄ të₂'ɨn₅₄, jme₁chí'₄ tag₄ quió'₅ Pilato jme₁lióin₂ jan₂ dsa₂ 'né₅ 'má₃, jme₁chei'₂ le₃jɨn₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","La₁ dsa₂ juɨg₂ në́₃ co₂ŋei'₅₄ ca₂le₃jɨ́in₃ ca₂tóin'₂ co₂mɨ'₅₄ ca₂juá'₂: ―¡Cau₅ jŋiá'₃ i₂në₅! ¡Barrabás bá₄ lion₄ quián₂ jnia'₅₄! ");
INSERT INTO cntNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás 'éi₂ ca₂to'₂ dsa₂ né'₃ 'má₃ 'uɨg₅₄ ia₁ ca₂dsia₃ caun₂ mɨ'₅₄ jë₄ juɨg₂, ton'₂ ia₁ jme₁ma₂jŋɨi'₃ dsa₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jme₁'nio₃ bá₄ Pilato jme₁lióin₂ Jesús, jaun₂ jme₁ca₂tsɨ́'₃ bá₄ guë́₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","La₁ të₂le₃ lë́₅ guë́₄ co₂mɨ'₅₄ ca₂tón'₂ bá₄ dsa₂, guió'₅ juá'₂: ―¡Tióin₃ cróg₄! ¡Tióin₃ cróg₄! ");
INSERT INTO cntNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jë₁ŋó₄ 'nɨ₅ ráun₂ ca₂juá'₂ táng₃ Pilato tsɨ́'₅ dsa₂: ―¿'E₂ guë'₂ 'lɨg'₅₄ ma₂jmo₃? Tsá₃ 'e₂ dsáu₁ i₂në₅ dso'₂ jniá₂ jua'₅₄ a₂ca₂tɨ́in₂ jóin₂. Jmo₅₄ jniá₂ 'éi'₃ a₂bóg₂ dsa₂ jaun₂ guë́₄ loin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","La₁ tion₅₄ ca₂mɨ₃ dsa₂ tioin'₅₄ co₂mɨ'₅₄ a₂tion₃ cróg₄. Ca₂lë₃ rë'₂ con'₂ lë́₅ 'ɨ́n₅ dsɨ́₅ dsa₂ juɨg₂ lé₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jaun₂ co₂ŋei'₅₄ me'₂ ca₂jmo₃ Pilato 'éi'₃ a₂lé₂ con'₂ lë́₅ mɨ₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jaun₂ ca₂lióin₂ bá₄ dsa₂ i₂jme₁'en₅₄ né'₃ 'má₃, i₂jme₁ma₂dsia₃ mɨ'₅₄, i₂ma₂jŋɨ'₃ dsa₂ në́₃. Jaun₂ ca₂jáng'₂ ca₂jɨ́in'₂ Jesús o₄gú₃ dsa₂ juɨg₂ o₁jmo₁₂ quiong'₅₄ con'₂ 'ɨ́n₅ dsɨ́₅ jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Con'₂ ma₂tioin'₅₄ juɨ₅ jŋiai₂₃ Jesús ja₁dsɨ₃tion₃ cróg₄, ca₂chi₃quiáin₂ tion₅₄ jan₂ dsa₂ chan₂ 'uë₃ Cirene, i₂chen₂ Si₂mu₅₄, i₂'en₅₄ juɨ₅ jón'₅ ja₁nau₂, a₂cán₂ cróg₄ dsó₃ le₃chi₁co'₅₄ quió'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Juɨn₅ lɨn₃ bá₄ dsa₂ juɨg₂ i₃lén₂ 'ein₂₃, dsa₂ mɨ́₂ në́₃ i₃lén₂ quɨ'₂-'o₂₃ 'lia'₂ dsɨ́₅ quɨ'₂-'óin'₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jaun₂ ca₂jén'₃ Jesús, ca₂juá'₂: ―'Nia'₂ dsa₂ mɨ́₂ chan₂ Jerusalén, 'a₃ ma₃'au₂ 'nia'₂ o₄quió₃ jniá₂. 'O₄ bá₄ 'nia'₂ o₄quiáng'₂ guiong'₅₄, o₄quió'₄ chi'₂-guein₂ quiáng'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ia₁ já₅ jmɨg₄ jë₁juá'₂ dsa₂: “'E₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ mɨ́₂ i₂tsá₃ lé₂ cán₂ guein₂; 'e₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ i₂tsá₃ guein₂ ca₂'í₃ të₂dsɨ́₅, on₃ guë'₂ dsi'₅₄ quió'₅ ca₂guén'₃ guein₂ në́₃.” ");
INSERT INTO cntNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jmɨg₄ jaun₂ jme₃lióg₃ dsa₂ tsɨ́'₃ nɨ₁má'₂: “Lá'₃ ne₄ quián₂ jnia'₅₄”, juá'₂ në́₃ tsɨ́'₃ dsɨ₂con'₂: “'Mog₅₄ jnia'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ia₁ chi₂jua'₂ le₂la₂ jmo₅ dsa₂ jmái'₂ i₂tsá₃ ca₂tɨ́n₂ gue₃ uɨg₅, ¿'ë₂ guë́₄ bá₄ dsɨ₃nɨ́₂ i₂ca₂tɨ́n₂ dsón'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ján₃ bá₄ jme₁le₁jŋiai₂₃ guë́₄ on₃ dsa₂ i₂le₂cán'₄ dso₄, a₂jme₂dsiog₂₃ co₂lë₅ quian'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jme₁ca₂dsi₃léin₂ ja₁të́'₂ dsa₂ Dsɨ₂con'₂ Nɨ₁mu₅ Mɨ₂dsi₄ 'Lag₄, ja₁jaun₂ ca₂tion₃ cróg₄ quian'₅₄ le₃on₃ dsa₂ 'lɨn'₅₄ 'éi₂, jan₂ të₂le₃ gu₂ ne₁, jan₂ guë'₂ të₂le₃ gu₂ jen₅. ");
INSERT INTO cntNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jaun₂ ca₂juá'₂ Jesús: ―Tia₅₄, 'én₃ dsáu₁, ia₁ tsá₃ ŋi₅ a₂jmo₂₃. Jaun₂ ca₂co₃ dsɨ₂'lióg₂ ca₂tóin'₂ ca₂jmo₃ le₁dso'₅₄ nɨ₁tsɨn'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jaun₂ jme₁tión₂ dsa₂ juɨg₂ cau₅, jág₅. Dsɨ₂tan₅₄ në́₃ jme₁tión₂, qui₂co₂jmóg'₂ burlas, ca₂juá'₂: ―Qui₂ma₂lióin₂ i₂sián'₂; në₃ në́₃, juɨ₁lioin₅₄ 'ŋiog₅ chi₂jua'₂ dsɨ₂jó'₃ lɨ́in₅ I₂rë₂'ɨ́n₁ rë₂quion'₅₄ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Dsɨ₂'lióg₂ në́₃ ca₂jmóg'₂ burlas ca₂jme₃quiáin₃ ca₂jén'₃ vino jen'₂, ");
INSERT INTO cntNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ca₂juá'₂: ―Chi₂jua'₂ lɨ́ng'₅ Rag₅₄ quián₅ dsa₂ judíos, lion₄ 'ŋiag'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jaun₂ ca₂tióng₃ dsa₂ letras dsi₄ cróg₄ tio'₅₄ 'nɨ₅ né₃ jág₁ jmei₅: griego, latín, hebreo në́₃, co₂'nió'₄ a₂juá'₂: “RAG₅₄ QUIÁN₅ DSA₂ JUDÍOS BÁ₄ LA₂.” ");
INSERT INTO cntNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jan₂ i₂rë₂cán'₄ dso₄ i₂jme₁rë₂ton₅ cau₅ quió'₅ ca₂të₂ca₂'o'₂, ca₂juá'₂: ―¿On₁ 'ne₂ lɨ́ng'₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄? Ma₂në₃ lion₄ 'ŋiag'₂, jaun₂ lo'₅₄ jnia'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","La₁ ca₂jí₂ bá₄ rɨin'₅₄ ca₂juá'₂: ―¿'En₁ jmá'₃ tsá₃ gan'₃ 'ne₂ Diú₄? Jua'₂ uɨg₅ le₂në₅ bá₄ guei'₂ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","La₁ jniog₄ a₂ca₂tág₂ dsón'₂ guei₂ uɨg₅ la₂, lia'₂ con'₂ lë́₅ a₂ma₂jmó₁; la₁ dsa₂ la₂ në́₃, 'i₁caun₂ tsá₃ 'e₂ rɨin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jaun₂ ca₂juá'₂: ―Jesús, juɨ₁dsiog'₂ bá₄ 'au'₂ jniá₂, jë₁ma₂dsiáng'₃ ja₁gong'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jaun₂ ca₂ŋag₃ Jesús: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'ne₂, jmɨg₄ në₃ të₃tsɨng'₅₄ quian'₅₄ jniá₂ Ja₁jlá'₁. ");
INSERT INTO cntNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Con'₂ dsi₃ní'₃, të₁tsɨ'₅₄ qui₁né'₃ ta₁caun₂ gua'₅₄ 'uë₃, ca₂lia'₂ ca₂të́₂ hora ŋí₁ 'nɨ₅ le₃ca₂'láu₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","'Iog₂ co₂dsia₅ ca₂rë₃liá'₃; tsɨ₁'mɨ'₂ cortina a₂jme₁'ei₅ dsi₂néi₂ guá'₅ templo, co₂dsia₅ ca₂chen₃ ca₂lë₃ tɨn₃ dso'₅₄ jo₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Hora jaun₂, ca₂guió'₃ Jesús, ca₂juá'₂: ―¡Tia₅₄ quiáng₃, o₄gog'₂ 'ne₂ dsia₅₄ jme₂dsí₂ quió₃! Caun₂ jaun₂ bá₄ a₂ca₂juá'₂ guë́₄, co₂tan₅₄ ca₂join₃. ");
INSERT INTO cntNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jme₁ca₂jág₃ juɨg₅₄ 'lióg₂ a₂ca₂lë₃ jaun₂, ca₂jme₃juɨin'₂ Diú₄, ca₂juá'₂: ―Dsón'₂ bá₄ tsá₃ 'e₂ jme₁rɨn₂ dsa₂ la₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ca₂le₃jɨ́n₃ bá₄ dsa₂ i₂jme₁tion'₅₄ i₂ca₂jág₃ a₂ca₂lë₃ jaun₂, ca₂i₃lein₃ quein₂₃ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ca₂le₃jɨ́n₃ dsa₂ i₂jme₁cuɨn₅ Jesús quian'₅₄ dsa₂ mɨ́₂ i₂jme₁ma₂quiong'₅₄ të₂ Galilea, jme₁tióin₂ uɨ́ng₂ jág₅ ca₂le₃jë́₃ a₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","La₁ ca₂lë₃ në́₃, jan₂ dsa₂ i₂chen₂ José, i₂jme₁quen'₅₄ lɨ́in₅ ta₁ jɨn₄ dsɨ₂tan₅₄ quián₅ guá'₅, jme₁lɨ́in₄ dsa₂ dsen₃ i₂'ua₁ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Së́₄ 'éi₂ në́₃, i₂chan₂ juɨg₂ Arimatea ja₁tén₄ Judea, tsá₃ ca₂rë₃'ŋió₃ dsɨ́₅ lia'₂ niog₅ ca₂jmo₃ dsɨ₂tan₅₄ rɨin'₅₄, ia₁ jme₁chi₁jŋia₂₃ le₃gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jaun₂ ca₂ŋei₅₄ në́₃ i₁mɨ₂ jág₁ ne₄ Pilato a₂dsɨ₃sioin₅₄ 'lag₄ Jesús cróg₄ a₂dsɨ₃'ó₃. ");
INSERT INTO cntNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jme₁ca₂sió₂, ca₂lio₃ caun₂ 'mɨ'₂ tióg₃. Jaun₂ ca₂i₁quio₂₃ 'ŋió'₃ tau₂ 'ŋio₅ a₂jme₁ma₂lë́₅ ca₂jmo₃ dsa₂ dsɨ́₅ nɨ₁'lau₂, ja₁tsá₃ 'ein₂ 'lag₄ ma₂'í₅. ");
INSERT INTO cntNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ia₁ jmɨg₄ jaun₂ tion'₅₄ dsa₂ jmo₂₃ co₂jŋia₅₄ a₂'nió'₅ quió'₅ jmɨg₄ sa₅₄ a₂jë₁ca₂jnia₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","La₁ dsa₂ mɨ́₂ i₂ma₂ja₂lén₂ quian'₅₄ Jesús të₂ Galilea, ca₂o₃léin₂ ca₂jág₃ 'a₂ lia'₂ ca₂quion₅ dsa₂ 'lag₄ né'₃ táu₂. ");
INSERT INTO cntNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jme₁ca₂dsi₃lein₃ quió'₅, ca₂jmo₃ co₂jŋia₅₄ no'₅₄ mɨ₂juɨg₂ quian'₅₄ guë́₄ ma₁'au₂ në́₃, a₂dsɨ₃tsɨin₅₄ Jesús. Jme₁ca₂jnia₃ sa₅₄ jaun₂, ca₂tiáin'₂ ca₂jŋia₃ lia'₂ con'₂ lë́₅ 'Éi'₃. ");
INSERT INTO cntNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jë₁le₂'uɨg₅₄ jmɨg₄ semana, ca₂i₃lén₂ táng₃ dsa₂ mɨ́₂ të₂ o₃'iog₂ lɨn₃, i₁jag₅₄ tau₂ 'ŋio₅ le₁quian₅ no'₅₄ mɨ₂juɨg₂ a₂jme₁ma₂lë́₅ co₂jŋia₅₄ quió'₅; lë́₂ bá₄ guë́₄ dsa₂ mɨ́₂ sián'₂ i₂ca₂jme₃quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jme₁ca₂dsi₃léin₂ ja₁jaun₂, jua'₂ cau₅ bá₄ ma₂i₂mu₃ nɨ₁cang₁ a₂jme₁rë₂jnɨ₅ tau₂ 'ŋio₅. ");
INSERT INTO cntNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jaun₂ ca₂i₃toin'₅₄, la₁ tsá₃ ma₃nɨ₁ŋɨ₁ 'lag₄ Te₁gui'₅₄ Jesús ca₂dsó'₂ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jaun₂ ca₂lë₃, të₃ tióin₂ dsɨ₂gó'₃ dsɨ́₅ jaun₂, tsá₃ a₂ŋi₅ jmo₃, jme₁ca₂jɨ́in₂ on₃ dsa₂ i₂qui'₂ tsɨn'₅₄ tág₅, tión₂ cau₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Të₃ ma₂gó'₅ jaun₂, ca₂'ɨin₃ ne₅₄ të₂ 'uë₃. Jaun₂ ca₂juá'₂ dsa₂ 'éi₂: ―¿'E₂ lë₃ 'na'₂ 'nia'₂ jan₂ i₂jén'₃ jɨn₄ 'lag₄? ");
INSERT INTO cntNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tsá₃ 'éi₂ chan₂ ja₁lá₃. Ma₂ca₂jein'₅₄ bá₄. Juɨ₁dsiog'₂ 'au'₂ 'nia'₂ a₂ca₂juá'₂ lia'₂ con'₂ jme₁ŋɨ₂₃ Galilea, ");
INSERT INTO cntNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","jme₁ca₂juá'₂ a₂ca₂tɨ́n₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ jáng'₂ dsa₂ o₄gú₃ dsa₂ 'lɨn'₅₄, a₂tion₃ dsa₂ cróg₄, la₁ a₂'nɨ₅ jmɨg₄ jaun₂ jein'₅₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jaun₂ guë́₄ ca₂dsáu'₃ dsɨ́₅ 'io₅₄ jág₁ jaun₂ quió'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jme₁dsi₃lein₃ jaun₂, ca₂dsia₃ ca₂tsɨ́'₃ ta₁guia₃-ján₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ i₂jme₁lë́₂ guë́₄, ca₂tsɨ́'₃ ca₂le₃jɨ́n₃ guë́₄ dsa₂ sián'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Dsa₂ mɨ́₂ i₂jme₁quion₂ jág₁ në₅ ne₄ chi'₂ dsɨ₂guia₃-tɨ́n₂: María i₂chan₂ Magdala, Juana, María chog₅₄ Jacobo, quiain'₅₄ guë́₄ dsa₂ mɨ́₂ sián'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","La₁ jme₁ca₂nág₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ jág₁ në₅, a₂lë₁të₂'ɨ₅ bá₄ 'io₅₄ 'éi₂, lɨ́in₂, jaun₂ tsá₃ ca₂rë₃'éin₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","La₁ Pe₄ në́₃, ca₂o₃'ɨ́in₃ ŋó₃ co₂chi'₅₄ ca₂i₁jag₅₄ dsi₂néi₂ tau₂ 'ŋio₅. Jaun₂ jmá'₃ tsɨ₁'mɨ'₂ tióg₃ bá₄ ca₂jág₃ niog₅. Ca₂ŋái'₃ bá₄ táng₃ jaun₂ në́₃, dsɨ₂gó'₃ dsɨ́₅ 'e₂ ca₂lë₃. ");
INSERT INTO cntNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jmɨg₄ jaun₂ dé₄, on₃ dsa₂ 'éi₂ tioin'₅₄ juɨ₅ i₃léin₂ juɨ₅ juɨg₂ ja₁të́'₂ dsa₂ Emaús, a₂niog₅ con'₂ guia₃-cáun₃ kilómetros ja₁niog₅ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jaun₂ dé₄ tsɨ́'₅ rɨin'₅₄ i₃léin₂ ca₂le₃jë́₃ 'e₂ niog₅ ca₂lë₃. ");
INSERT INTO cntNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Të₃ dsia₂₃ i₃léin₂ jaun₂, ca₂jme₃quián₃ Jesús ŋó₃ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","La₁ juɨ₁'a₂ guë́₃ la₂ jág₂ i₃léin₂, cha₂ a₂jmo₅ a₂tsá₃ rë₂cuɨg₂₃ 'ein₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jaun₂ ca₂ŋag₃ Jesús: ―¿'E₂ bá₄ jág₁ dsia'₂ 'nia'₂ ja₂nóg'₅? Jaun₂ ca₂nau₂ ca₂tiá₂ tei₄, le₁'ág₄ 'lia'₂ dsɨ́₅ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jaun₂ ca₂ŋag₃ jan₂ i₂chen₂ Cleofas: ―¿On₁ bá₄ jan'₂ 'ne₂ lɨ́ng'₅ dsa₂ i₂lia'₂ të₁tsɨn'₅₄ guan₅ Jerusalén, jaun₂ tsá₃ ŋi'₅₄ 'e₂ niog₅ ca₂lë₃ dsióg₂-jo₃ në₅? ");
INSERT INTO cntNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jaun₂ ca₂ŋag₃: ―¿'E₂ ca₂lë₃ guë'₂? Jaun₂ ca₂ŋag₃ táng₃: ―A₂ca₂lë₃ quian'₅₄ Jesús i₂chan₂ Nazaret, i₂jme₁lɨ́n₄ jan₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, i₂'uan'₂ të₂le₃ quian'₅₄ ca₂le₃jë́₃ a₂niog₅ ca₂jmo₃, i₂'uan'₂ të₂le₃ quian'₅₄ jág₁ a₂ca₂jme₃tag₂₃, lia'₂ le₃ne₄ Diú₄ lia'₂ le₃ne₄ dsa₂ mɨ₂güɨ́g₃ në́₃; ");
INSERT INTO cntNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","'a₂ lia'₂ ca₂jáng'₂ juɨg₅₄ jme₂dsa₂ quian'₅₄ dsɨ₂tan₅₄ quián₂ jnia'₅₄, ca₂dsi₂ 'éi'₃ ca₂jŋag'₃ tioin'₅₄, ca₂tion₃ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jnia'₅₄ jme₁'ɨ́n₂ dsɨ₅ chong₂, a₂lág₂ jnia'₅₄ 'éi₂ bá₄ lɨ́n₅ i₂jme₁lión₂ juɨg₂ Israel. La₁ në₃ në́₃, ma₂'nɨ₅ jmɨg₄ ca₂lë₃ le₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","I₂lɨn₅₄ dsa₂ mɨ́₂ i₂tion'₅₄ jë₄ quián₂ jnia'₅₄ ma₂në₂quiong₃ jnia'₅₄ juë́'₅, ia₁ ma₃i₁jag₅₄ të₂ o₃'iog₂ ma₂'mɨ́g₂ tau₂ 'ŋio₅, juá'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tsá₃ nɨ₁ŋɨ₁ 'lag₄ dsó'₅. A₂jaun₂ bá₄ dsia₂₃ o₃lein₃ a₂në₂jme₃jnia₅ ángeles ne₅₄, a₂në₂juá'₂ i₂chan₂ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jaun₂ në́₃, ma₂i₁len₅₄ i₂lɨn₅₄ rɨn'₅₄ jnia'₅₄ ma₂i₁jag₅₄ tau₂ 'ŋio₅. Jua'₂ dsón'₂ bá₄ dsau₅ con'₂ lë́₅ jág₁ jmóg'₅ dsa₂ mɨ́₂ 'éi₂, la₁ 'éi₂ guë'₂ në́₃ tsá₃ në₂jɨ́in₂, juá'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jaun₂ ca₂ŋag₃ Jesús ca₂tsɨ́'₃ 'éi₂: ―¡'En₁ jmá'₃ tsá₃ 'e₂ ca₂ŋɨ́'₂ 'au'₂ 'nia'₂! ¿Lɨ́g'₂ bá₄ le₃'én'₂ 'nia'₂ ca₂le₃jë́₃ a₂niog₅ ca₂juá'₂ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ia₁ ¿on₁ le₂jaun₂ 'i₄ 'éi'₃ ca₂tɨ́n₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄, dsɨ₃ŋɨ́i₂ ca₂le₃jë́₃ a₂në₅ de'₂ jŋiá₅, jaun₂ guë́₄ dsiáin'₄ ja₁le₃juɨin'₂ táng₃? ");
INSERT INTO cntNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jaun₂ qui₂ca₂juá'₂ 'a₂ lia'₂ niog₅ juá'₂ ne₄ Si₂ quió'₅ Diú₄; ca₂jme₃lióg₃ de'₂ jŋiá₅ ja₁juá'₂ ne₄ si₂ quió'₅ Moisés, ŋó₃ ca₂'ë₃ le₂tan₅₄ si₂ quió'₅ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, ja₁juá'₂ 'ɨin₂₃ 'éi₂ 'ŋiog₅. ");
INSERT INTO cntNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jaun₂ ja₂quián₃ dsi₁léin₂ juɨg₂ pí'₁ ja₁tioin'₅₄ juɨ₅ dsi₁léin₂. La₁ dsa₂ 'éi₂ con'₂ jme₁ma₂ŋó₅ co₂dsau₅ bá₄ ca₂jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","La₁ i₂on₃ 'éi₂ në́₃ ca₂chi₃quióng₂ jmɨg₄ a₂jŋia₃, ca₂juá'₂: ―Në₃ o₁jŋia₁ quian'₅₄ jnia'₅₄, ia₁ ca₂rɨn₂ bá₄ 'iog₂, ca₂'láu₂ ca₂nei₂ bá₄ la₂. Jaun₂ ca₂'í₃ dsi₂néi₂ ja₁jŋia₃ quian'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jaun₂ ca₂lë₃, jme₁ma₂guá₅ ne₄ mesa quian'₅₄ 'éi₂, ca₂can₃ i₁ŋí'₄, ca₂jme₃jŋiói₃, jaun₂ guë́₄ ca₂'niai₃ ca₂cuë́'₃ le₃on₃ i₂quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Të₃jë₄ jaun₂ në₂jag₄ a₂jaun₂ guë́₄ ca₂niá₃ jme₁ne₁₂ lɨ́in₂, jaun₂ guë́₄ ca₂rë₃cuɨg₂₃. La₁ dsɨ₂juɨ₅ jaun₂ ca₂i₃cóin'₅ të₃ ne₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jaun₂ guë́₄ ca₂dsia₃ jág₁ guioin₅₄: ―Dsón'₂ bá₄ lia'₂ tio'₅₄ juɨ₅ ja₂náu₅, ca₂lë₃ dsɨ₅ néi₁ ca₂le₃jë́₃ 'e₂ niog₅ në₂juá'₂ në₂jme₃ŋɨ́i'₂ dsɨ₅ jniog₄ a₂juá'₂ Si₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂tóin'₂ táng₃ juɨ₅ ja₂lein₃ Jerusalén. Jme₁o₃lein₃ jaun₂, tion'₅₄ ta₁guia₃-ján₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ i₂lë́₂ guë́₄, le₁ŋɨi'₂ quian'₅₄ guë́₄ dsa₂ sián'₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jaun₂ juá'₂ 'éi₂ tioin'₅₄: ―Të₃dsón'₂ bá₄ ma₂ca₂jen'₅₄ Te₁gui'₅₄. Ia₁ ma₂në₂jme₃jniai₂₃ ne₄ Si₂mu₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jaun₂ guë́₄ ca₂jmóg'₃ táng₃ i₂on₃ 'éi₂ jág₁ 'a₂ lia'₂ ca₂lë₃ le₂'i₄ juɨ₅, 'a₂ lia'₂ ca₂rë₃cuɨg₂₃ con'₂ jme₁ca₂'niai₃ i₁ŋí'₄. ");
INSERT INTO cntNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Të₃ tioin'₅₄ dsia₂₃ jág₁ jaun₂, jme₁ca₂jme₃jnia₅ Jesús ca₂nau₂ jë₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ca₂i₃gó'₃ dsɨ́₅ tioin'₅₄, lɨ́in₂ jan₂ jme₂dsí₂ bá₄ 'éi₂ ŋɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jaun₂ ca₂juá'₂: ―¿'E₂ lë₃ ŋɨ́₄ lë₃ tion'₅₄ 'nia'₂ chí'₅ go₂'i₃? ¿'E₂ lë₃ ŋɨ́₄ 'lióng₂ a₂'náu'₂ 'nia'₂ 'au'₂? ");
INSERT INTO cntNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","La₂ jag₄ 'nia'₂ o₄gu₃ o₄tag₃. Jniá₂ bá₄ la₂. I₂nó'₅ 'nia'₂ i₂nɨ́g'₃ quió₃ i₂jag₄ 'nia'₂. Jan₂ jme₂dsí₂, on₃jua'₅₄ i₂ton₅ ŋɨ́₅ on₃ i₂'en₅₄ mu₅, juɨ₁lia'₂ jág'₂ 'nia'₂ lɨ́n₅ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Të₃ juá'₂ le₂në₅, qui₂ca₂'ë₃ o₄gú₃ o₄tag₁₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Të₃ tioin'₅₄ jaun₂ dsɨ₂gó'₃ dsɨ́₅ tsá₃ 'éin₂ o₄quió'₄ a₂ŋɨ́₄ lë₃ 'io'₂ jén'₅, jme₁ca₂juá'₂ Jesús: ―¿Cha₁ a₂le₃que₅₄ ca₂la₂ ja₁lá₃? ");
INSERT INTO cntNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jaun₂ ca₂o₃can₅ ca₂'nau₅₄ quió'₅ i₁ju₁ cuɨ₂ ne₄ si₂, quian'₅₄ guë'₂ ca₂jne₄ nɨ₁tá'₅ cuɨng₅. ");
INSERT INTO cntNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jaun₂ ca₂gue₃ ca₂guë́'₃ guá₅ të₃ne₄ ca₂le₃jɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jaun₂ ca₂juá'₂ në́₃: ―Ma₁ ca₂juá'₃ jniá₂ le₂jŋiá₅ lia'₂ con'₂ jme₁ŋɨ₂₃ jɨn'₄ 'nia'₂, a₂tion₅₄ le₃ti₃ ca₂le₃jë́₃ lia'₂ con'₂ lë́₅ tio'₅₄ ne₄ Si₂ 'Éi'₃ quió'₅ Moisés, ne₄ Si₂ quió'₅ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, ne₄ Salmos në́₃, ja₁'ag₂₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jaun₂ guë́₄ ca₂jme₃ŋɨ́i'₂ dsɨ́₅ 'éi₂ a₂juá'₂ Si₂, ");
INSERT INTO cntNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","jaun₂ ca₂juá'₂: ―Le₂në₅ bá₄ tio'₅₄ ne₄ Si₂: a₂tion₅₄ bá₄ dsɨ₃ŋɨ́₂ uɨg₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄, la₁ jein'₅₄ bá₄ táng₃ a₂'nɨ₅ jmɨg₄; ");
INSERT INTO cntNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","a₂tion₅₄ dsɨ₃'ag₅ jág₁ në́₃, a₂'nió'₅ qui₂dsɨ₃quén'₅ dsɨ́₅ dsa₂ ia₁jaun₂ bá₄ lé₂ le₃'én₂ dsáu₁. Jág₁ në₅ dsó₃ qui₂rë₂'ë́₂ o₄quió₃, ne₄ ca₂le₃jɨ́n₃ i₂chan₂ gua'₅₄ 'uë₃, la₁ Jerusalén de'₂ jŋiá₅ ja₁le₃lióg₃. ");
INSERT INTO cntNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","'Nia'₂ në́₃ i₂qui₂ca₂të́₂ ne'₅₄ ca₂le₃jë́₃ a₂niog₅ ca₂lë₃, qui₂o₁jang'₄ 'nia'₂ jág₁ dsau₅. ");
INSERT INTO cntNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jaun₂ në́₃, tsɨn₅₄ jniá₂ i₂ma₂lë́₅ jág₁ chen₃ Ŋe'₃. La₁ jŋia₄ guë́₄ 'nia'₂ juɨg₂ la₂, ca₂lia'₂ ca₂lë₃ le₁lɨn'₄ 'nia'₂ quian'₅₄ juɨ₅bí₂ a₂sió₃ guei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jaun₂ ca₂jŋiai₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ të₂ juɨg₂ Betania, jaun₂ ca₂cho₃ gu₂ ne₄ quió'₅ ca₂le₃jɨ́n₃, ca₂jme₃gu'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ca₂lë₃ në́₃, të₃jë₄ jme₂gu'₅₄ jaun₂, ca₂i₃uɨ́in₂. ");
INSERT INTO cntNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","'Éi₂ në́₃, ja₂lein₃ bá₄ táng₃ Jerusalén, jmo₂₃ 'io'₂ 'ŋio₅ lɨn₃, ");
INSERT INTO cntNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","le₃ó₃ jmɨg₄ bá₄ jme₁ŋɨi'₂ i₁dsi₅ guá'₅ jme₂juɨin'₂ Diú₄. Co₂në₅.");
INSERT INTO cntNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Lia'₂ con'₂ le₂'uɨg₅₄ jme₁ca₂rë₃lióg₃, jme₁ma₂chan₂ i₂të́'₂ Jág₁; jaun₂ i₂'éi₂ i₂lɨ́n₅ Jág₁ në́₃, jme₁'ein₅₄ quian'₅₄ Diú₄; Diú₄ bá₄ jme₁lɨ́in₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jaun₂ lia'₂ con'₂ le₂'uɨg₅₄, 'éi₂ në́₃, jme₁'ein₅₄ quian'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Të₂le₃ quian'₅₄ 'éi₂ bá₄, ca₂lë₃ ca₂le₃jë́₃ 'e₂ a₂cha₂; ca₂lia'₂ 'i₁caun₂ tsá₃ ca₂rë₃chá₃ jua'₅₄ tsá₃ ca₂jmo₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ja₁con₂ 'éi₂ bá₄ já₅ bí₂ a₂le₃chan₂ dsa₂; bí₂ jaun₂ në́₃, lë́₅ Si₂ a₂tág₅ ja₁con₂ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tág₅ Si₂ jaun₂ jë₄ qui₁né'₃, la₁ qui₁né'₃ në́₃, tsá₃ ma₂ca₂tió'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ca₂rë₃chán₃ jan₂ dsa₂ i₂chen₄ quián₅ Diú₄, i₂chen₂ Juan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ca₂guain₃ ca₂jáng'₃ jág₁ dsau₅ të₂le₃ quió'₅ 'éi₂ i₂lɨ́n₅ Si₂, ia₁jaun₂ të₂le₃ quian'₅₄ jág₁ dsau₅ a₂jáng'₅ në₅, le₃'én₂ ca₂le₃jɨ́n₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","On₃jua'₅₄ Juan₅₄ 'éi₂ i₂jme₁lɨ́n₄ Si₂; jŋia'₅₄ con'₂ i₂jáng'₅ jág₁ dsau₅ bá₄ jme₁lɨ́in₄, juɨ₁lia'₂ le₃quió'₅ Si₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jme₁ma₂guán₂ i₂lɨ́n₅ Si₂ të₃dsón'₂, a₂tág₃ ja₁con₂ le₂jan₂ le₂jan₂ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I₂'éi₂ i₂lɨ́n₅ Jág₁ jme₁'ein₅₄ mɨ₂güɨ́g₃; jaun₂, o₁jŋia'₅₄ ca₂lë₃ mɨ₂güɨ́g₃ të₂le₃ quian'₅₄ 'éi₂, tsá₃ ca₂rë₃cuɨg₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Guain₃ jɨn₄ dsa₂ go₅₄, la₁ dsa₂ go₅₄ në́₃, tsá₃ ca₂guei₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","La₁ia₁ i₂con'₂ ca₂guei₃, i₂ca₂rë₃'én₂ të₂le₃ quió'₅, dsa₂ 'éi₂ në́₃ ca₂cuë́'₃ bí₂ a₂léin₂ chi'₂-guein₂ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Juɨ₁lia'₂ chi'₂-guein₂ 'éi₂, on₃jua'₅₄ ca₂rë₃cháin₃ lia'₂ con'₂ lë́₅ jmɨ₄ dsa₂ mɨ₂güɨ́g₃, on₃ guë'₂ lia'₂ con'₂ lë́₅ dsɨ́₅ dsa₂ mɨ₂güɨ́g₃, on₃ guë'₂ lia'₂ con'₂ lë́₅ dsɨ́₅ jan₂ dsa₂ ŋe'₂, ton'₂ ca₂rë₃cháin₃ le₃quió'₅ Diú₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","I₂'éi₂ në́₃ i₂lɨ́n₅ Jág₁, ca₂can₃ ŋɨ₄ dsa₂ mɨ₂güɨ́g₃, ca₂guá₂ jë₄ quián₂ jniog₄. Jnia'₅₄ në́₃ ma₂ca₂jag₅₄ a₂co₂'né'₅ quió'₅, co₂'nió'₄ a₂co₂'né'₅ quió'₅ jan₂ tan₅₄ Ja₁ŋi'₅₄ Diú₄, i₂já₅ ja₁con₂ Jmei₂, rë₂rɨn₅ a₂dse₃ dsɨ́₅, a₂rë₂ti'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ca₂jáng'₃ Juan₅₄ jág₁ dsau₅ të₂le₃ quió'₅ 'éi₂, ca₂juá'₂ tiá₂: ―I₂la₂ bá₄ 'éi₂ i₂'ɨ́n₅ jniá₂, lia'₂ con'₂ jme₁ca₂juá'₃: “I₂já₅ cang₂ guë́₄ con'₂ guë́₄ jniá₂, dsein₅₄ guë́₄ con'₂ guë́₄ jniá₂, ia₁ jme₁ma₂chain₂ jŋiá₅ guë́₄ con'₂ guë́₄ jniá₂.” ");
INSERT INTO cntNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ca₂le₃jág₃ bá₄ jniog₄ ma₂qui₂ma₂guéi₂ a₂tson₂ a₂dse₃ dsɨ́₅ 'éi₂, caun₂ qui₂jme₂gu'₅₄ bá₄ Diú₄ jniog₄ lia'₂ i₂gú'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ca₂ŋag₂ jniog₄ Si₂ 'Éi'₃ të₂le₃ quian'₅₄ Moisés, la₁ia₁ të₂le₃ quian'₅₄ Jesucristo bá₄ ca₂já₃ a₂dse₃ dsɨ́₅ Diú₄, ca₂rë₃ti₃ jág₁ dsau₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Lia'₂ 'i₁jan₂ tsá₃ 'ein₂ ma₂jɨ́n₂ Diú₄ lia'₂ 'i₁cón'₂; la₁ia₁ Ja₁ŋi'₅₄ i₂jan₂ tan₅₄ 'éi₂ quiáin₅, i₂'en₅₄ ja₁con₂ Jmei₂, i₂'éi₂ bá₄ ma₂jmo₃ jág₁ dsau₅ 'a₂ lia'₂ lɨ́n₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jaun₂ le₂la₂ jág₁ a₂ca₂jáng'₃ Juan₅₄ jme₁ca₂chen₃ dsa₂ can'₅₄ quián₅ dsa₂ judíos i₂tion'₅₄ Jerusalén ca₂chein₃ jme₂dsa₂ quiain'₅₄ levitas ne₄ Juan₅₄, a₂i₁ŋag₁₂ i₂'ein₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","'Éi₂ në́₃ ca₂jmo₃ jág₁ lia'₂ rë₂jiá₃, ca₂juá'₂: ―On₃jua'₅₄ jniá₂ lɨ́ng₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jaun₂ ca₂ŋag₃ táng₃ dsa₂: ―¿'Ein₂ 'ne₂ jaun₂? ¿'Ne₂ lɨ́ng'₅ Elías i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄? Jaun₂ ca₂juá'₂ Juan₅₄: ―On₃jua'₅₄ 'éi₂ jniá₂. Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂ŋag₃ táng₃ dsa₂: ―¿On₃ bá₄ 'ne₂ lɨ́ng'₅ i₂'ë́₂ jág₁ 'éi₂, i₂lë́₅ jág₁ jiá₃? Jaun₂ ca₂ŋag₃ Juan₅₄: ―Jan₂'ón₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jaun₂ bá₄ ca₂juá'₂ dsa₂ ca₂tsɨ́'₃ Juan₅₄: ―¿'Ein₂ lɨ́n'₅ 'ne₂, jaun₂ në́₃? Jua'₅₄, ia₁jaun₂ dsɨ₁con₁ jnia'₅₄ jág₁ dsau₅ ne₄ dsa₂ i₂ca₂chei₃. ¿'Ein₂ juá'₂ 'ne₂ lɨ́ng'₅? ");
INSERT INTO cntNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jaun₂ ca₂ŋag₃ Juan₅₄: ―Jniá₂ bá₄ lɨ́ng₅ i₂'éi₂ i₂juá'₂ jág₁ tiá₂ caun₂ 'uë₃ quein₂ co₂'ŋiog₅ i₁juá'₄: “Nia₄ 'nia'₂ caun₂ juɨ₅ co₂dsau₅ quió'₅ Te₁gui'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Dsa₂ i₂i₁len₅₄ i₁dsia₂ jág₁ quian'₅₄ Juan₅₄, dsa₂ i₂chen₄ quián₅ dsa₂ fariseos bá₄ 'éi₂, ");
INSERT INTO cntNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","jaun₂ ca₂ŋag₃ ca₂ŋɨ́i'₃ táng₃ Juan₅₄: ―Chi₂jua'₂ on₃jua'₅₄ 'ne₂ lɨ́ng'₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄, on₃ guë'₂ Elías, on₃ guë'₂ jan₂ i₂'ë́₂ jág₁ o₄quió'₄ Diú₄ në́₃, ¿'e₂ ta₁ 'eng'₅₄ tsóng'₅ dsa₂ jmɨg₂? ");
INSERT INTO cntNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jaun₂ ca₂juá'₂ Juan₅₄: ―Jniá₂ tiáng₅ dsa₂ jmɨg₂; la₁ia₁ jɨn₄ 'nia'₂ chan₂ jan₂ i₂tsá₃ cuɨn'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Já₅ jan₂ cang₂ guë́₄ con'₂ guë́₄ jniá₂, on₃jua'₅₄ 'ein₂ lɨ́n₅ jniá₂ jua'₅₄ ca₂tɨ́ng₂ tsɨ'₅₄ lau₂ ton₅ tag₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ca₂le₃jë́₃ a₂la₂ ca₂lë₃ caun₂ ja₁chei₂ Betania, a₂niog₅ të₂le₃ ja₁'ia₂ 'iog₂ të₂le₃ quióng₄ Cuá₃ Jordán, ja₁jme₁'en₅₄ Juan₅₄ choin₂₃ dsa₂ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jme₁jnia₃ jaun₂, ca₂jɨ́n₂ Juan₅₄ Jesús a₂já₅ ja₂quiáin₃ ja₁chéin'₄, jaun₂ ca₂juá'₂: ―Jag₄ 'nia'₂, i₂në₅ bá₄ Guein₂ Já'₂ Cha'₂ quián₅ Diú₄, i₂jŋiá'₂ dsáu₁ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","I₂në₅ bá₄ 'éi₂ i₂'ɨ́n₅ jniá₂, lia'₂ con'₂ jme₁ca₂juá'₃: “I₂já₅ cang₂ guë́₄ con'₂ guë́₄ jniá₂, dsein₅₄ guë́₄ con'₂ guë́₄ jniá₂, ia₁ jme₁ma₂chain₂ jŋiá₅ guë́₄ con'₂ guë́₄ jniá₂.” ");
INSERT INTO cntNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Lia'₂ jŋia'₅₄ 'ŋió₃, tsá₃ jme₁guion₅₄ 'ein₂ 'éi₂; la₁ia₁ chóng₅ dsa₂ jmɨg₂ ma₂guio₃, ia₁jaun₂ le₃cuɨg₅ dsa₂ juɨg₂ Israel 'ein₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ján₃ bá₄ ca₂jáng'₃ Juan₅₄ jág₁ dsau₅ la₂, ca₂juá'₂: ―Ca₂jɨn₄ jniá₂ Jme₂dsí₂ Jŋió₅ ca₂sióin₃ guei'₅₄ i₂juɨ́g₃ i₂jniá₂ lia'₂ jniá₂ jan₂ i₁ju₂, ca₂të₁gua₁ ne₄ quió'₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tsá₃ jme₁ma₂guion₄ bá₄ guë́₄ jniá₂ i₂'ein₂ 'éi₂; la₁ia₁ i₂ca₂chei₃ jniá₂ a₂chóng₄ dsa₂ jmɨg₂, ca₂tság₃ jniá₂: “Jë₁ma₂ca₂jɨng'₅₄ Jme₂dsí₂ sióin₅ ne₄ quió'₅ jan₂ dsa₂ ŋe'₂, i₂'éi₂ bá₄ qui₃tián₂ dsa₂ Jme₂dsí₂ Jŋió₅.” ");
INSERT INTO cntNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma₂ca₂jɨin₅₄ bá₄ jniá₂, jaun₂ jáng'₅ jniá₂ jág₁ dsau₅, a₂lɨ́n₅ 'éi₂ Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jme₁jnia₃ jaun₂, jme₁'en₅₄ táng₃ Juan₅₄ ja₁jaun₂ quian'₅₄ guë́₄ on₃ dsa₂ i₂i₂nio₄ quiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jaun₂ jme₁ca₂jág₃ Juan₅₄ ca₂ŋɨ₅ Jesús, jaun₂ ca₂juá'₂: ―Jag₄ 'nia'₂, i₂në₅ bá₄ Guein₂ Já'₂ Cha'₂ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jaun₂ ca₂nág₂ le₃on₃ dsa₂ 'éi₂ a₂ca₂juá'₂, jaun₂ i₃léin₂ chi₁co'₅₄ quió'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jaun₂ në́₃ ca₂jén'₃ Jesús të₂le₃ ca'₃, ca₂jɨ́in₂ dsa₂ i₂i₃lén₂ chi₁co'₅₄ quió'₅, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ 'éi₂: ―¿'E₂ 'náu'₂ 'nia'₂? Jaun₂ ca₂juá'₂ dsa₂ 'éi₂ ca₂tsɨ́'₃ Jesús: ―Rabbí ―co₂'nió'₄ le₃jua'₅₄: Të₅―, ¿Já'₄ ŋéi'₂ 'ne₂? ");
INSERT INTO cntNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jaun₂ ca₂ŋag₃ Jesús: ―I₂nó'₅ 'nia'₂ i₂jag₄. Jaun₂ i₃léin₂ i₁jag₅₄ já'₄ guá₅ Jesús, jaun₂ quian'₅₄ 'éi₂ bá₄ ca₂tóin'₂ të₁lia'₂ ca₂'láu₂ jmɨg₄ jaun₂; ia₁ jme₁ma₂ca₂të́₂ con'₂ hora ŋí₁ quén₂ të₂le₃ ca₂'láu₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jan₂ i₂on₃ 'éi₂ i₂ca₂nág₂ a₂ca₂juá'₂ Juan₅₄, i₂i₃lén₂ chi₁co'₅₄ quió'₅ Jesús, jme₁chen₂ Drë́₄ i₂lɨ́n₅ rɨn'₅₄ Si₂mu₅₄ i₂të́'₂ dsa₂ Pe₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dsɨ₂juɨ₅ né'₃ guë́₄ jaun₂ bá₄ ŋe₄ Drë́₄, i₁'nai'₂ Si₂mu₅₄ rɨin'₅₄, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ 'éi₂: ―Ma₂dsán'₅ jnia'₅₄ Mesías, (co₂'nió'₄ le₃jua'₅₄, dsa₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄). ");
INSERT INTO cntNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jaun₂ i₁jŋia₃ Drë́₄, Si₂mu₅₄ rɨin'₅₄ ja₁'en₅₄ Jesús, jaun₂ jme₁ca₂jág₂ Jesús në́₃, ca₂juá'₂: ―'Ne₂ lɨ́ng'₅ Si₂mu₅₄, ja₁ŋi'₅₄ Jonás. La₁ia₁ le₃cheng'₂ Cefas. Lia'₂ chen₂ Cefas në₅, co₂'nió'₄ le₃jua'₅₄ Pe₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jme₁jnia₃ jaun₂, ca₂lë₃ dsɨ́₅ Jesús dsó₃ 'uë₃ Galilea, jaun₂ ca₂dsáin'₂ Felipe, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ 'éi₂: ―Jme₁quiong'₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe 'éi₂ në́₃, jme₁chain₂ juɨg₂ Betsaida, ján₃ bá₄ ja₁jme₁chan₂ Drë́₄ quian'₅₄ Pe₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fe₂li₄ 'éi₂ në́₃, ŋei₅₄ i₁'niai'₂ Natanael, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ 'éi₂: ―Ma₂dsán'₅ jnia'₅₄ dsa₂ 'éi₂ i₂'ɨn₅ Moisés ne₄ Si₂ 'Éi'₃, i₂'ɨn₅ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄ në́₃. Jesús bá₄ 'éi₂, ja₁ŋi'₅₄ José, i₂chan₂ juɨg₂ Nazaret. ");
INSERT INTO cntNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Jaun₂ ca₂juá'₂ Natanael: ―¿Lé₂ le₃o₃'ag₅ caun₂ a₂dse₃ juɨg₂ Nazaret? Jaun₂ ca₂ŋag₃ Fe₂li₄: ―Ŋia₅ de'₂ i₂jag₄. ");
INSERT INTO cntNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jaun₂ jme₁ca₂jág₃ Jesús a₂ma₂ja₂quián₃ Natanael, ca₂juá'₂: ―La₂ dé₄ dsón'₂ já₅ jan₂ dsa₂ israelita të₃dsón'₂, i₂tsá₃ cha₂ mai₅₄ ja₁con₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jaun₂ ca₂ŋag₃ Natanael ca₂ŋɨ́i'₃ Jesús: ―¿'A₂ lia'₂ cuɨg'₂ jniá₂? Jaun₂ ca₂juá'₂ Jesús: ―Jniá₂ në₂jɨng₅₄ 'ne₂ jŋiá₅, né'₃ guë́₄ a₂dsɨ₃té₂ Fe₂li₄, lia'₂ con'₂ jme₁ŋéi'₂ né'₃ nɨ₁'ma₂ higuera. ");
INSERT INTO cntNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jaun₂ në́₃ ca₂juá'₂ Natanael ca₂tsɨ́'₃ Jesús: ―Të₅, 'ne₂ bá₄ lɨ́ng'₅ Ja₁ŋi'₅₄ Diú₄; 'ne₂ bá₄ lɨ́ng'₅ Rag₅₄ quián₅ dsa₂ juɨg₂ Israel. ");
INSERT INTO cntNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jaun₂ ca₂ŋag₃ Jesús ca₂tsɨ́'₃ 'éi₂: ―¿A₁jaun₂ 'éng'₂ ia₁ në₂juá'₃ a₂në₂jɨn₄ jniá₂ 'ne₂, ŋéi'₂ né'₃ nɨ₁'ma₂ higuera? La₁ia₁ në₃ guë́₄ të₃ ne'₅₄ 'lióng₂ léi₄ juë'₂ guë́₄ con'₂ guë́₄ a₂la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ján₃ bá₄ ca₂juá'₂ Jesús: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, jag'₅₄ 'nia'₂ rë₂na₄ guei'₅₄ i₂juɨ́g₃, jɨn'₅₄ 'nia'₂ ángeles quián₅ Diú₄ në́₃, qui₂tsau₂ qui₂tsɨ₂sioin₂ ne₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","'Nɨ₅ jmɨg₄ cang₂ guë́₄ jaun₂, ca₂nio₃ jmɨg₄ ca₂jen'₂ gu₂ dsa₂ jë₄ juɨg₂ Caná, a₂niog₅ 'uë₃ Galilea. Ja₁jaun₂ jme₁'en₅₄ chog₅₄ Jesús në́₃; ");
INSERT INTO cntNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ján₃ bá₄ ca₂të́'₃ dsa₂ Jesús quiain'₅₄ dsa₂ i₂quiain'₅₄, ja₁jen'₂ gu₂ dsa₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jme₁ca₂dsa₃ vino, jaun₂ ca₂juá'₂ chog₅₄ Jesús ca₂tsɨ́'₃ 'éi₂: ―Tsá₃ ma₃cha₂ vino quió'₅ dsa₂ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","La₁ ca₂ŋag₃ Jesús: ―'Io₅₄, ¿'e₂ lë₃ juɨg'₂ jniá₂ a₂në₅? Ia₁ tsá₃ ma₂të́₂ guë́₄ hora quió₃. ");
INSERT INTO cntNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","La₁ ca₂juá'₂ chog₅₄ ca₂tsɨ́'₃ dsa₂ i₂tion'₅₄ tia'₅: ―Jmo₄ 'nia'₂ chi₂'e₂ juá'₂ i₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jme₁tióng₂ ja₁jaun₂ jŋéi₂ tɨ'₂ cang₄, juɨ₁lia'₂ a₂jme₁jmó'₂ dsa₂ judíos ta₁ a₂jme₁qui₂jmo₂₃ le₁jɨ́in₃, con'₂ lë́₅ tag₄ jme₁chí'₄ quió'₅. Lia'₂ caun₂ nɨ₁tɨ'₂ cang₄ jaun₂ 'a₄ con'₂ të₂láu₃-guiá₂, o₃ caun₂ 'ŋiá₂-láu₂ litro jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂ i₂tia'₅: ―Jme₁can'₂ 'nia'₂ nɨ₁tɨ'₂ tióng₂ la₂ quian'₅₄ jmɨg₂. Ca₂jme₃can'₂ bá₄ guë'₂ dsa₂ lia'₂ ca₂rɨn₅ rë₂ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂ 'éi₂: ―Në₃ në́₃, dsen₅₄ ca₂juɨg₄, o₂can₄ ne₄ dsa₂ i₂niog₅ ne₄ jmɨg₄. Jaun₂ i₁can₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Dsa₂ i₂niog₅ ne₄ jmɨg₄ jaun₂, ca₂tí₂ 'o₅₄ jmɨg₂ a₂ca₂lë₃ vino jaun₂, të₃ tsá₃ ŋi₅ a₂já'₄ já₃; jŋia'₅₄ lia'₂ dsa₂ i₂ca₂dsen₅ jmɨg₂ bá₄ jme₁ŋi₅. Jaun₂ në́₃ ca₂të₃ dsa₂ i₂niog₅ ne₄ jmɨg₄, ca₂të́'₃ dsa₂ ŋe'₂ i₂jen'₂ gu₂, ");
INSERT INTO cntNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","jaun₂ ca₂tsɨ́'₃ 'éi₂: ―Ca₂le₃jɨ́n₃ bá₄ dsa₂ tɨin₂₃ tia'₃ le₂'uɨg₅₄ vino dse₃, jaun₂ jë₁ma₂le₁'en₅ dsa₂, jaun₂ guë́₄ tia'₃ vino ga₂. La₁ 'ne₂ në́₃ në₂'ma'₅₄ vino dse₃ ca₂të₂ jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jë₄ juɨg₂ Caná a₂tén₅ 'uë₃ Galilea jaun₂, ca₂jmo₃ Jesús léi₄ juë'₂ le₂'uɨg₅₄. Le₂në₅ ca₂jme₃jniai₂₃ 'ein₂ lɨ́in₅ të₂le₃ quian'₅₄ juɨ₅bí₂ quió'₅, jaun₂ ca₂rë₃'én₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Cang₂ guë́₄ jaun₂ ca₂ŋó₃ jë₄ juɨg₂ Capernaum, lia'₂ jma₃quiain'₅₄ chog₅₄, rɨin'₅₄, chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ në́₃; ja₁jaun₂ ca₂tóin'₂ tɨn₃-'nɨ₅ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jme₁ma₂ja₂quián₃ Jmɨg₄ Të₂'ɨn₅₄ quió'₅ dsa₂ judíos, jaun₂ ca₂uɨ́g₂ Jesús juɨ₅ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ja₁jaun₂ ca₂dsáin'₂ i₁dsi₅ guá'₅ templo dsa₂ i₂'nɨ₅ ca₁juɨ₅, i₂'nɨ₅ já'₂ cha'₂, i₂'nɨ₅ i₁ju₂ në́₃, quian'₅₄ dsa₂ i₂qui₂jme₂tsɨ́n₃ cu₄ quió'₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jme₁ca₂jág₃ Jesús a₂jaun₂, ca₂jmo₃ caun₂ látigo a₂lë́₅ quian'₅₄ tsɨ₁'nei₅₄, jaun₂ ca₂'uɨ́in'₂ ca₁'né₄ ca₂le₃jɨ́n₃ i₂tion'₅₄ i₁dsi₅ lia'₂ jma₃quiain'₅₄ já'₂ cha'₂ quiáin₅, ca₁juɨ₅ në́₃. Ca₂jein₃ 'uë₃ cu₄ quió'₅ dsa₂ i₂jme₂tsɨ́n₃ cu₄, qui₂ca₂jéin'₃ nɨ₁mesa në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jaun₂ ca₂tsɨ́'₃ i₂'nɨ₅ i₁ju₂: ―¡'Uë'₅₄ 'nia'₂ ca₂le₃jë́₃ a₂në₅ ja₁lá₃! ¡Tsá₃ lë₁jmo₂ 'nia'₂ ja₁'ma'₅₄ ja₁quió'₄ Ŋe'₃! ");
INSERT INTO cntNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jaun₂ ca₂dsáu'₃ dsɨ́₅ dsa₂ i₂jme₁quiain'₅₄, a₂chi₁ton₅ ne₄ Si₂ le₂la₂: Në₂jag₄ bá₄ a₂ca₂cóng₂ 'uɨg₅₄ ia₁ a₂ŋɨ́₄ lë₃ dsí'₅ dsɨ₃ o₄quió'₄ dsi₂néi₂ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jaun₂ në́₃ ca₂ŋag₃ dsa₂ judíos ca₂ŋɨ́i'₃ Jesús: ―¿'E₂ léi₄ le₃'ë́'₂ jnia'₅₄ a₂jáng'₅ jág₁ dsau₅ a₂ca₂tɨ́n'₂ 'ne₂ jmó'₂ le₂në₅? ");
INSERT INTO cntNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jaun₂ ca₂ŋag₃ Jesús: ―'Én₂ 'nia'₂ guá'₅ la₂, jaun₂ tsɨ'₅₄ táng₃ jniá₂ quian'₅₄ 'nɨ₅ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jaun₂ në́₃ ca₂juá'₂ dsa₂ judíos ca₂tsɨ́'₃ Jesús: ―Të₂láu₃-jŋéi₂ ŋi₂ ca₂rë₃'ɨ́n₅ dsa₂ jme₁ca₂chi'₃ guá'₅ la₂. ¿'En₁ jmá'₃ jaun₂, lé₂ le₃jmog'₅₄ tsɨ'₅₄ quian'₅₄ 'nɨ₅ jmɨg₄? ");
INSERT INTO cntNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","La₁ia₁ guá'₅ a₂'ë₅ Jesús jaun₂, nɨ₁ŋɨ₄ 'ŋiog₅ bá₄ Jesús 'ë₂₃. ");
INSERT INTO cntNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jaun₂ lë₃, lia'₂ con'₂ jme₁ca₂jen'₅₄ Jesús a₂jme₁rë₂'lɨin₅₄, ca₂dsáu'₃ dsɨ́₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ jág₁ jaun₂. Jaun₂ ca₂rë₃'éin₂ jág₁ a₂juá'₂ ne₄ Si₂ quió'₅ Diú₄, quian'₅₄ jág₁ a₂jme₁ca₂juá'₂ Jesús jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lia'₂ con'₂ jme₁'en₅₄ Jesús Jerusalén Jmɨg₄ Të₂'ɨn₅₄, ca₂rë₃'én₂ juɨn₅ lɨn₃ dsa₂ të₂le₃ quió'₅ Jesús, jme₁ca₂jág₃ léi₄ a₂ma₂qui₂ma₂jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","La₁ tsá₃ jme₁'én₂ Jesús quió'₅ dsa₂ 'éi₂, ia₁ i₂cuɨin₂₃ bá₄ ca₂le₃jɨ́n₃ dsa₂, 'a₂ lia'₂ lë́₅ të₂dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tsá₃ 'e₂ ca₂rë₃'nió'₅ quió'₅, jua'₅₄ a₂jáng'₃ dsa₂ jág₁ dsau₅ juɨ₁lia'₂ quió'₅ 'i₁jan₂, ia₁ ma₂ŋi₅ rë₂ bá₄ Jesús 'e₂ a₂qui₂dsɨ₂jŋia₅ dsɨ́₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jme₁chan₂ jan₂ dsa₂ fariseo i₂jme₁chen₂ Nicodemo, i₂jme₁lɨ́n₄ jan₂ dsa₂ dsen₅₄ quián₅ dsa₂ judíos. ");
INSERT INTO cntNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ŋe₄ 'éi₂ ca₂i₁jɨin₁₂ Jesús të₂le₃ ca₂nei₂, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ Jesús: ―Të₅, ne₄ bá₄ jnia'₅₄ a₂lɨ́n'₅ 'ne₂ jan₂ të₅ i₂chen₄ quián₅ Diú₄, ia₁ ca₂lia'₂ 'i₁jan₂ tsá₃ lé₂ le₃jmo₃ léi₄ juë'₂ le₂në₅, juɨ₁lia'₂ jmo'₂ 'ne₂, jua'₅₄ tsá₃ quiong'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jaun₂ në́₃ ca₂juá'₂ Jesús ca₂tsɨ́'₃ Nicodemo: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'ne₂, në₁jua'₂ tsá₃ rë₂chan₂ táng₃ dsa₂, tsá₃ lé₂ le₃jág₃ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jaun₂ ca₂ŋag₃ Nicodemo: ―¿'A₂ bá₄ lia'₂ lé₂ le₃chan₂ táng₃, jan₂ dsa₂ ma₂juɨn'₂? ¿Lé₂ le₃'í₂ táng₃ né'₃ të₂dsɨ́₅ chog₅₄, jaun₂ le₃chain₂ táng₃? ");
INSERT INTO cntNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jaun₂ ca₂ŋag₃ Jesús: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'ne₂, juɨ₁lia'₂ i₂tsá₃ rë₂chan₂ le₃quió'₅ jmɨg₂, quian'₅₄ le₃quió'₅ Jme₂dsí₂, tsá₃ lé₂ le₃'í₂ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Juɨ₁lia'₂ i₂rë₂chan₂ le₃quió'₅ nɨ₁ŋɨ́₅, jan₂ dsa₂ nɨ₁ŋɨ́₅ bá₄ 'éi₂; juɨ₁lia'₂ i₂rë₂chan₂ le₃quió'₅ Jme₂dsí₂, jan₂ dsa₂ i₂gu₂dsí₂ bá₄ lɨ́n₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tsá₃ juɨ₁dsi₂gó'₃ 'au'₂ 'ne₂ a₂juá'₅ jniá₂: “Tion₅₄ bá₄ le₃chan'₂ 'nia'₂ táng₃.” ");
INSERT INTO cntNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","'Ag₅ dsí₂ juɨ₁'a₂ guë́₃ já'₄ 'nio₃ 'ag₃; nag'₂ bá₄ 'ne₂ mɨ'₅₄ a₂lë́₂, la₁ia₁ tsá₃ ŋi'₅₄ a₂já'₄ já₅, on₃ guë'₂ a₂já'₄ dsó₃. Ján₃ bá₄ le₂në₅ lɨ́n₅ ca₂le₃jɨ́n₃ i₂rë₂chan₂ le₃quió'₅ Jme₂dsí₂. ");
INSERT INTO cntNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jaun₂ në́₃ ca₂ŋag₃ táng₃ Nicodemo: ―¿'A₂ bá₄ lia'₂ lé₂ le₃lé₂ a₂juá'₂ 'ne₂ në₅? ");
INSERT INTO cntNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jaun₂ ca₂ŋag₃ Jesús: ―¿'Ne₂ guë'₂ lɨ́ng'₅ jan₂ të₅ quián₅ dsa₂ juɨg₂ Israel, ton'₂ tsá₃ ŋɨ́'₂ bá₄ guë́₄ 'au'₂ jág₁ në₅? ");
INSERT INTO cntNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'ne₂, juɨ₁lia'₂ a₂ma₂tag₂ bá₄ jnia'₅₄, dsia₂; ján₃ bá₄ jang'₂ jnia'₅₄ jág₁ dsau₅ juɨ₁lia'₂ a₂ma₂të́₂ ne₄ jnia'₅₄. La₁ 'nia'₂ në́₃ tsá₃ gue'₂ jág₁ dsau₅ a₂jang'₂ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Chi₂jua'₂ ma₂në₂juá'₃ jniá₂ a₂'ë₂₃ juɨ₁lia'₂ a₂cha₂ mɨ₂güɨ́g₃ la₂, ton'₂ tsá₃ 'én'₂ bá₄ guë'₂ 'nia'₂, ¿'a₂ bá₄ guë'₂ lia'₂ le₃'én'₂ 'nia'₂ jág₁ quió₃ në₁ca₂juá'₃ jniá₂ ca₂juɨ́g₂ 'nia'₂ a₂'ë₂₃ juɨ₁lia'₂ a₂cha₂ guei'₅₄ i₂juɨ́g₃? ");
INSERT INTO cntNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ca₂lia'₂ 'i₁jan₂ tsá₃ 'ein₂ ma₂uɨ́g₂ guei'₅₄ i₂juɨ́g₃, jŋia'₅₄ lia'₂ 'éi₂ i₂ca₂sión₃ guei'₅₄ i₂juɨ́g₃; co₂'nió'₄ 'ŋiog₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Juɨ₁lia'₂ ca₂chón'₂ Moisés dsɨ₂mɨ'₂ guei'₅₄ ja₁lë́₄ 'uë₃ quein₂ co₂'ŋiog₅ jaun₂, ján₃ bá₄ le₂jaun₂ 'i₄ 'éi'₃ chón'₂ dsa₂ guei'₅₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃, ");
INSERT INTO cntNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ia₁jaun₂ ca₂le₃jɨ́n₃ i₂'én₂ të₂le₃ quió'₅ 'éi₂, le₃chain₂ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Jaun₂, 'uɨg₅₄ ia₁ a₂ŋɨ́₄ lë₃ ca₂rë₃'nio₃ Diú₄ ca₂rë₃'nioi₃ dsa₂ mɨ₂güɨ́g₃, ca₂cuɨin₃ Ja₁ŋi'₅₄ i₂jan₂ tan₅₄ quiáin₅, ia₁jaun₂ ca₂le₃jɨ́n₃ i₂'én₂ të₂le₃ quió'₅ 'éi₂, tsá₃ dsɨ₃'éin₂, ton'₂ le₃chain₂ bá₄ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ia₁ on₃jua'₅₄ jaun₂ ca₂chei₃ Diú₄ ca₂chein₃ Ja₁ŋi'₅₄ mɨ₂güɨ́g₃ a₂qui₃'ë́₂ uɨg₅ ja₁con₂ dsa₂ mɨ₂güɨ́g₃; a₂jaun₂ bá₄ ca₂chei₃ ia₁jaun₂ lión₂ dsa₂ mɨ₂güɨ́g₃ të₂le₃ quian'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Juɨ₁lia'₂ dsa₂ i₂'én₂ të₂le₃ quió'₅ 'éi₂, tsá₃ rë₂'ë́₂ uɨg₅ ja₁coin₂; la₁ia₁ juɨ₁lia'₂ i₂tsá₃ 'én₂ guë'₂ në́₃, ma₂rë₂'ë́₂ uɨg₅ ja₁coin₂, 'uɨg₅₄ ia₁ a₂tsá₃ 'éin₂ të₂le₃ quió'₅ Ja₁ŋi'₅₄ i₂jan₂ tan₅₄ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A₂la₂ bá₄ uɨg₅ a₂rë₂'ë́₂ jaun₂: a₂ma₂gua₅ si₂ ja₁con₂ dsa₂ mɨ₂güɨ́g₃, la₁ ca₂rë₃'nio₃ guë́₄ dsa₂ jë₄ qui₁né'₃ lia'₂ con'₂ guë́₄ ja₁tág₅ si₂, ia₁ a₂'lɨg'₅₄ bá₄ jme₁jmo₂₃-dsáu₅. ");
INSERT INTO cntNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ca₂le₃jɨ́n₃ dsa₂ i₂jmo₅ a₂'lɨg'₅₄, 'io'₅₄ si₂, jaun₂ tsá₃ jme₂quiáin₃ ja₁tág₅ si₂, ia₁jaun₂ tsá₃ le₃jniá₂ a₂'lɨg'₅₄ a₂jmo₂₃-dsáu₅. ");
INSERT INTO cntNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","La₁ia₁ juɨ₁lia'₂ dsa₂ i₂chan₂ caun₂ juɨ₅ co₂dsau₅, jme₂quiáin₃ ja₁tág₅ si₂, ia₁jaun₂ le₃jniá₂, le₃quió'₅ Diú₄ bá₄ já₅ a₂dse₃ a₂jmo₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Cang₂ jaun₂, ŋó₃ Jesús juɨ₅ 'uë₃ Judea quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ja₁jaun₂ ca₂'í₃ ca₂la₂ uë́₂ quiain'₅₄ 'éi₂, qui₂choin₂₃ jmɨg₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ján₃ bá₄ le₂jaun₂ jme₁'en₅₄ Juan₅₄ në́₃, choin₂₃ jmɨg₂ dsa₂, caun₂ ja₁chei₂ Enón, ma₂quián₅ Salim, ia₁ ja₁jaun₂ jme₁cha₂ 'lióng₂ jmɨg₂; jaun₂ jme₁ja₂lén₂ dsa₂ ia₁jaun₂ qui₃cho₃ Juan₅₄ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(A₂la₂ ca₂lë₃ né'₃ guë́₄ a₂ton'₂ dsa₂ Juan₅₄ né'₃ 'má₃.) ");
INSERT INTO cntNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jaun₂ në́₃, i₂lɨn₅₄ dsa₂ i₂quian'₅₄ Juan₅₄ ca₂tsɨ́in₂ quian'₅₄ jan₂ dsa₂ judío ne₄ jág₁ juɨ₁lia'₂ a₂jmo₅ dsa₂ le₁jɨ́in₃. ");
INSERT INTO cntNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jaun₂ i₃léin₂ i₁chi'₄ Juan₅₄: ―Të₅, dsa₂ i₂jme₁'en₅₄ quian'₅₄ 'ne₂ të₂le₃ ja₁'ia₂ 'iog₂ të₂le₃ quióng₄ Cuá₃ Jordán, dsa₂ i₂'ɨ́n'₅ 'ne₂ 'éi₂, jë₂ bá₄ choin₂₃ jmɨg₂ dsa₂, jaun₂ ca₂le₃jɨ́n₃ bá₄ dsa₂ dsɨ₂léin₂ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jaun₂ ca₂ŋag₃ Juan₅₄: ―Ca₂lia'₂ 'i₁caun₂ tsá₃ 'e₂ lé₂ le₃cha₂ quió'₅ dsa₂ jua'₅₄ tsá₃ ŋei₂ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ca₂nei'₂ bá₄ 'nia'₂ guiong'₅₄ jme₁ca₂juá'₃: “On₃jua'₅₄ jniá₂ lɨ́ng₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄; jan₂ dsa₂ i₂chen₄ ne₄ juɨ₅ quió'₅ 'éi₂ bá₄ lɨ́ng₅.” ");
INSERT INTO cntNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","I₂ca₂tɨ́n₂ dsa₂ ŋe'₂ i₂jen'₂ gu₂ bá₄, dsa₂ mɨ́₂ i₂jen'₂ gu₂ quiain'₅₄. Jaun₂ dsa₂ a₂mei₅₄ quián₅ dsa₂ ŋe'₂ në́₃, chi₁jŋia₁ nag₂₃. Jaun₂ 'io'₂ jén'₅ jë₁ma₂nág₂ jág₁ quió'₅ 'éi₂. Ján₃ bá₄ le₂jaun₂ jniá₂ në́₃, rë₂'ŋia₅ a₂'io'₂ jén'₅ dsɨ₃. ");
INSERT INTO cntNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","’'Éi₂ ca₂tɨ́n₂ le₃dsein₅₄ guë́₄; jniá₂ guë'₂ ca₂tɨ́ng₂ le₃meg'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Juɨ₁lia'₂ i₂já₅ juɨ₅ guei'₅₄ i₂juɨ́g₃, dsen₅₄ guë́₄ ne₄ quió'₅ ca₂le₃jɨ́n₃. Juɨ₁lia'₂ i₂já₅ gua'₅₄ 'uë₃, jan₂ i₂chan₂ gua'₅₄ 'uë₃ bá₄ 'éi₂. Jaun₂ dsia₂₃ juɨ₁lia'₂ a₂quió'₅ gua'₅₄ 'uë₃. La₁ia₁ juɨ₁lia'₂ i₂já₅ guei'₅₄ i₂juɨ́g₃, dsen₅₄ guë́₄ ne₄ quió'₅ ca₂le₃jɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jáng'₅ 'éi₂ jág₁ dsau₅ juɨ₁lia'₂ a₂ma₂të́₂ ne₅₄, juɨ₁lia'₂ a₂ma₂nág₂ në́₃; la₁ 'i₁jan₂ tsá₃ 'ein₂ tón'₂ juɨ₅ jág₁ dsau₅ a₂jáng'₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","La₁ia₁ juɨ₁lia'₂ i₂tón'₂ juɨ₅, ma₂cáun₅ 'í₁ a₂dsón'₂ bá₄ tí₅ jág₁ a₂juá'₂ Diú₄; ");
INSERT INTO cntNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ia₁ i₂ca₂chen₃ Diú₄ në́₃, dsia₂₃ jág₁ quió'₅ Diú₄, ia₁ cuɨn₅ Diú₄ Jme₂dsí₂ quiáin₅ ca₂lia'₂ tsá₃ niog₅ 'éi'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","A₂'nio₃ Diú₄ Jmei₂ 'nioi₃ Ja₁ŋi'₅₄, jaun₂ o₄gú₃ 'éi₂ ma₂dsia₃ ca₂le₃jë́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Juɨ₁lia'₂ i₂'én₂ të₂le₃ quió'₅ Ja₁ŋi'₅₄ Diú₄, le₃chain₂ bá₄ co₂tan₅₄; la₁ juɨ₁lia'₂ i₂tsá₃ ne'₅₄ le₃quió'₅ Ja₁ŋi'₅₄ Diú₄, tsá₃ të₃ ne₅₄ a₂le₃chain₂ rë₂'ŋiai₂₃, ton'₂ të₂le₃ të₃gua₄ 'nei₂ dsɨ́₅ Diú₄ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jme₁ca₂rë₃ŋi₅ Te₁gui'₅₄ a₂ma₂nág₂ dsa₂ fariseos jág₁, 'ŋio₅ lɨn₃ guë́₄ juɨn₅ dsa₂ i₂ma₂quian'₅₄ Jesús, qui₂ma₂cho₃ jmɨg₂ lia'₂ con'₂ guë́₄ Juan₅₄; ");
INSERT INTO cntNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(o₁jŋia'₅₄ on₃jua'₅₄ 'ŋiog₅ Jesús choin₂₃ jmɨg₂ dsa₂, jŋia'₅₄ lia'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ bá₄), ");
INSERT INTO cntNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","jaun₂ ca₂o₃'ɨ́in₃ 'uë₃ Judea, a₂ŋái'₃ táng₃ juɨ₅ 'uë₃ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ja₁tioin'₅₄ juɨ₅ jaun₂, ca₂tɨ́in₂ ŋɨ́i₃ 'uë₃ Samaria. ");
INSERT INTO cntNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jaun₂ në́₃ ca₂dsi₃léin₂ caun₂ juɨg₂ ja₁tén₄ Samaria a₂chei₂ Sicar, ma₂quián₅ ca₂jne₄ 'uë₃ a₂jme₁ca₂cuë₃ Jacob ma₂lɨ́g'₂ ca₂cuë́'₃ ja₁ŋi'₅₄ i₂chen₂ Së́₄. ");
INSERT INTO cntNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ja₁jaun₂ jme₁dsi₅₄ caun₂ tau₂ pozo a₂të́'₂ dsa₂ a₂quió'₅ Jacob. Jaun₂ ca₂guá₂ Jesús cau₅, ia₁ a₂ca₂'ú'₃ 'ein₅₄ juɨ₅. Jme₁ma₂ca₂të́₂ con'₂ dsi₂ŋí'₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Të₃ guá₅ jaun₂ ca₂dsióg₃ jan₂ 'io₅₄ i₂chan₂ Samaria a₂i₃dsein₂₃ jmɨg₂ pozo jaun₂. Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ 'io₅₄ 'éi₂: ―Cuë₄ ca₂juɨg₄ jmɨg₂ guɨ'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Të₁lia'₂ jaun₂, i₁len₅₄ jë₄ juɨg₂ chi'₂ dsɨ₂guia₃-tɨ́n₂, i₁lia₅ má₃ a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jaun₂ në́₃ ca₂juá'₂ 'io₅₄ chan₂ Samaria 'éi₂ ca₂tsɨ́'₃ Jesús: ―¿'A₂ lia'₂ lë́₅ jaun₂, 'ne₂ jan₂ dsa₂ i₂lɨ́n₅ judío, mɨ'₂ jmɨg₂ ne₃ jniá₂, jan₂ 'io₅₄ chan₂ Samaria? (Ia₁ tsá₃ jág₁ 'ei₅ dsa₂ judíos quian'₅₄ dsa₂ chan₂ Samaria.) ");
INSERT INTO cntNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jaun₂ në́₃ ca₂ŋag₃ Jesús: ―Jua'₅₄ mei'₂ guë́₃ ŋi'₅₄ 'ne₂ 'e₂ jaun₂ a₂cuë₅ Diú₄, quian'₅₄ 'ein₂ i₂mɨ₅ jmɨg₂ ne'₅₄, jme₁mɨ́'₂ ne₃ jniá₂, jaun₂ jniá₂ në́₃ cuë₅₄ jmɨg₂ jén'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jaun₂ ca₂juá'₂ 'io₅₄ ca₂tsɨ́'₃ Jesús: ―Gui'₅₄, tsá₃ ŋí₁ cubeta cha₂ quiáng'₂ a₂dséng'₄ jmɨg₂, ton'₂ a₂jɨ'₂ bá₄ tau₂ pozo. ¿'A₂ guë'₂ já'₄ cán'₁ jmɨg₂ jén'₃ a₂cuë́'₂ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿'E₂, 'ne₂ lɨ́ng'₅ i₂juɨn'₂ guë́₄ con'₂ guë́₄ 'lag₄ jmei₂ jniog₄ Jacob, i₂ca₂cuë₃ pozo la₂? Jme₁cán₂ 'éi₂ jmɨg₂ a₂'ɨ́n'₂ 'ŋiog₅ quian'₅₄ chi'₂ quiáin₅, quian'₅₄ já'₂ quiáin₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jaun₂ ca₂ŋag₃ Jesús: ―Ca₂le₃jɨ́n₃ juɨ₁lia'₂ dsa₂ i₂'ɨ́n'₂ jmɨg₂ la₂, lé₂ táng₃ dsɨ́₅ i₁'ɨ́n'₂ jmɨg₂; ");
INSERT INTO cntNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","la₁ia₁ juɨ₁lia'₂ i₂'ɨ́n'₂ jmɨg₂ a₂cuë́₄ jniá₂, lia'₂ o₁lɨ́g'₂ jmɨg₄ tsá₃ ma₃lé₂ dsɨ́₅ i₁'ɨ́n'₂ jmɨg₂. Ia₁ juɨ₁lia'₂ jmɨg₂ a₂cuë́₄ jniá₂, lé₂ në₂jag₄ bá₄ caun₂ o₄tu₁ jmɨg₂ të₂le₃ quió'₅, a₂qui₃'iá₃ jmɨg₂ a₂gu₂dsí₂ a₂jmo₃ a₂le₃chain₂ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jaun₂ në́₃ ca₂juá'₂ 'io₅₄ ca₂tsɨ́'₃ Jesús: ―Gui'₅₄, cuë₄ jmɨg₂ a₂'ë'₂ në₅, ia₁jaun₂ tsá₃ ma₃le₃quein₂ dsɨ₃, on₃ guë'₂ caun₂ guio₅₄ guë́₄ ca₂të₂ la₂ i₁dséng₃ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jaun₂ ca₂juá'₂ Jesús: ―Guan'₂ o₂te'₂ dsɨ₂i₂gog'₂, jaun₂ ŋe'₅₄ táng₃ ja₁lá₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jaun₂ ca₂ŋag₃ 'io₅₄ 'éi₂: ―Tsá₃ dsɨ₂i₂gu₃ jniá₂ chan₂. Jaun₂ në́₃ ca₂juá'₂ Jesús: ―Tí₅ bá₄ jág₁ quiáng'₂ a₂në₂jua'₅₄, a₂tsá₃ chan₂ dsɨ₂i₂gog'₂; ");
INSERT INTO cntNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ia₁ 'ŋiá₂ dsɨ₂i₂gog'₂ i₂ma₂ca₂né'₂ quiang'₅₄, jaun₂ i₂ŋéi'₂ quiang'₅₄ rë₂në́₃ ján₃, on₃jua'₅₄ dsɨ₂i₂gog'₂ 'éi₂. Dsón'₂ bá₄ tí₅ jág₁ quiáng'₂ a₂në₂jua'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jme₁ca₂nág₂ 'io₅₄ jág₁ në₅, ca₂juá'₂ ca₂tsɨ́'₃ Jesús: ―Te₁gui'₅₄, dsón'₂ bá₄ lɨ́n'₅ 'ne₂ jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄, lɨ́n₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ja₁chí'₄ má'₂ la₂ ca₂jme₃juɨn'₂ dsa₂ can'₅₄ quián₂ jnia'₅₄ ca₂jme₃juɨin'₂ Diú₄ ma₂lɨ́g'₂, la₁ia₁ 'nia'₂ i₂lɨ́ng'₅ dsa₂ judíos në́₃, juá'₂ Jerusalén bá₄ ja₁ca₂tɨ́n₂ dsa₂ jme₃juɨin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jaun₂ ca₂ŋag₃ Jesús: ―Juɨ₁le₂'éng'₂ bá₄ a₂juá'₅ jniá₂: já₅ caun₂ jmɨg₄ a₂jme₁juɨn'₂ 'nia'₂ Diú₄, on₃jua'₅₄ i₁nóg'₅ má'₂ la₂, on₃ guë'₂ o₁nó'₅ 'nia'₂ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'Nia'₂ jme₂juɨ́ng'₁ të₃ tsá₃ ŋi'₅₄ 'ein₂ jme₂juɨ́ng'₁; a₂dsau₅ bá₄ jnia'₅₄, ne₄ jnia'₅₄ 'éin₂ i₂jme₂juɨ́n'₂; ia₁ të₂le₃ quió'₅ dsa₂ judíos bá₄ já₅ jág₁ a₂lión₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","La₁ já₅ hora, ton'₂ ma₂të́₂ dsón'₂, a₂jme₃juɨn'₂ dsa₂ Jmei₂, juɨ₁lia'₂ dsa₂ i₂jme₂juag'₂ të₃dsón'₂, jme₃juag'₂ të₂le₃ gu₂dsí₂ ton'₂ të₂le₃ quian'₅₄ jág₁ dsau₅. Ia₁ i₂le₂'éi₂ bá₄ 'na'₂ Jmei₂ jme₃juag'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","A₂lɨ́n₅ Diú₄ jme₂dsí₂; jaun₂ juɨ₁lia'₂ i₂jme₂juag'₂, ca₂tɨ́in₂ jme₃juag'₂ të₂le₃ gu₂dsí₂ ton'₂ të₂le₃ quian'₅₄ jág₁ dsau₅. ");
INSERT INTO cntNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jaun₂ ca₂juá'₂ 'io₅₄: ―Guion₄ jniá₂ a₂jiá₃ Mesías, (i₂të́'₂ dsa₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄). Jë₁ma₂guain₂₃, jaun₂ guë́₄ juá'₂ ca₂le₃jë́₃ lia'₂ rë₂jiá₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jaun₂ ca₂juá'₂ Jesús: ―Jniá₂ bá₄ 'éi₂, i₂dsia₅ jág₁ quian'₅₄ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Të₁lia'₂ jaun₂, ca₂o₃len₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂i₃gó'₃ dsɨ́₅ jme₁ca₂jág₃ a₂dsia₅ Jesús jág₁ quian'₅₄ jan₂ 'io₅₄. La₁ia₁ lia'₂ 'i₁jan₂ tsá₃ ca₂tiá₂ dsɨ́₅ ŋag₃ 'e₂ 'no'₂, 'e₂ jág₁ dsia₂₃ quiain'₅₄ 'io₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jaun₂, ja₁jaun₂ ca₂chi'₃ 'io₅₄ nɨ₁dsɨg₁ quió'₅, jaun₂ ŋái'₃ jë₄ juɨg₂, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂: ");
INSERT INTO cntNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―I₂nó'₅ 'nia'₂ i₂jɨn₄ jan₂ dsa₂ ŋe'₂ i₂ma₂në₂juá'₂ ca₂le₃jë́₃ 'e₂ a₂ma₂jmo₃ jniá₂. ¿On₁jua'₅₄ mei'₂ tsá₃ 'éi₂ lɨ́n₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jaun₂ në́₃ ca₂'uɨn₂ dsa₂ jë₄ juɨg₂ ca₂i₃léin₂ ja₁guá₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Të₁lia'₂ jaun₂, ca₂chi₃quióng₂ jmɨg₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ chi₂quiáin₂ jmɨg₄ Jesús a₂guë́'₃, juá'₂: ―Të₅, qué'₂ ca₂la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jaun₂ ca₂juá'₂ Jesús: ―Cha₂ caun₂ má₃ a₂guë'₅₄ jniá₂, a₂tsá₃ cuɨn'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jaun₂ në́₃ qui₂ca₂ŋɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ rɨin'₅₄, jain₂ jain₂: ―¿On₃ bá₄ chan₂ jan₂ i₂ma₂o₃can₅ má₃ a₂guë́'₃? ");
INSERT INTO cntNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","La₁ ca₂juá'₂ Jesús ca₂tsɨ́'₃ 'éi₂: ―A₂jaun₂ bá₄ má₃ quió₃ jniá₂, a₂jmo₅₄ 'éi'₃ a₂'ŋio₂ dsɨ́₅ i₂ca₂chei₃, a₂jme₁'ŋiag₅ ta₁ quió'₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿'On₁ juá'₂ guë'₂ 'nia'₂: “'Ei₅ bá₄ guë́₄ quén₂ tsɨ'₂ a₂ráu₃”? La₁ia₁ jniá₂ juɨ́g₂ 'nia'₂, jag₄ 'a₂ lia'₂ ma₂tion'₅₄ dsa₂ le₁jŋia₂₃, në₂jag₄ bá₄ a₂le₁chein'₂ ja₁nau₂ ca₂ron₂, ma₂lé₂ bá₄ cág'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Juɨ₁lia'₂ dsa₂ i₂jmo₅ ta₁ ja₁nau₂ në́₃ gue₂₃ 'liain'₅₄. Juɨ₁lia'₂ a₂ráu₃, a₂cág'₃ ja₁nau₂ jaun₂, a₂jiog₃ co₂tan₅₄ bá₄ jaun₂, ia₁jaun₂ co₂lë₅ bá₄ jmo₃ 'io'₂, lia'₂ dsa₂ i₂jne₅, lia'₂ dsa₂ i₂cág'₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Le₂në₅ dsón'₂ bá₄ quio₃ a₂dsia₅ dsa₂: “Jan₂ i₂jne₅, i₂sián'₂ i₂cág'₅.” ");
INSERT INTO cntNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jniá₂ ma₂tsɨ́ng₂ 'nia'₂ a₂o₁cag'₄ ja₁tsá₃ ta₁ ma₂jmo'₅₄ 'nia'₂ guiong'₅₄, ta₁ ma₂jmo₃ i₂sián'₂; jaun₂ 'nia'₂ në́₃ ca₂lɨng'₃ ta₁ quió'₅ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Juɨn₅ dsa₂ i₂chan₂ Samaria i₂tián'₅ juɨg₂ jaun₂ ca₂rë₃'éin₂ të₂le₃ quió'₅ Jesús jme₁ca₂nág₂ jág₁ dsau₅ a₂ca₂jáng'₃ 'io₅₄, jme₁ca₂juá'₂: “Në₂juá'₂ 'éi₂ ca₂le₃jë́₃ 'e₂ a₂ma₂jmo₃ jniá₂.” ");
INSERT INTO cntNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","'Uɨg₅₄ jaun₂ në́₃, jme₁ca₂o₃lén₂ dsa₂ chan₂ Samaria, ca₂chi₃quiáin₂ jmɨg₄ Jesús a₂jme₁jŋia₃ 'éi₂ quiong'₅₄. Jaun₂ ca₂jŋia₃ Jesús tɨn₃ jmɨg₄ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jaun₂ të₂le₃ juɨn₅ guë́₄ dsa₂ ca₂rë₃'én₂ jme₁ca₂nág₂ jág₁ a₂juá'₂ 'ŋiog₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jaun₂ ca₂juá'₂ dsa₂ ca₂tsɨ́'₃ 'io₅₄: ―Në₃ guë́₄ në́₃ 'éin₂ jnia'₅₄, on₃jua'₅₄ 'uɨg₅₄ jág₁ a₂ca₂jua'₅₄ 'ne₂, ia₁ a₂ma₂në₂néi₁ jnia'₅₄ guio₅₄ jág₁ quió'₅, jaun₂ ne₄ jnia'₅₄, të₃dsón'₂ bá₄ 'éi₂ lɨ́n₅ dsa₂ i₂lión₂ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jme₁ca₂dsan₃ tɨn₃ jmɨg₄ jaun₂, ca₂o₃'ɨ́in₃ ja₁jaun₂, ca₂'í₃ juɨ₅ ŋái'₃ juɨ₅ 'uë₃ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ia₁ juɨ₁lia'₂ ca₂juá'₂ 'ŋiog₅ Jesús, juɨ₁lia'₂ jan₂ dsa₂ i₂'ë́₂ jág₁ o₄quió'₄ Diú₄, tsá₃ jme₂go₃ dsa₂ juɨg₂ go₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jme₁ca₂dsiáin'₃ 'uë₃ Galilea në́₃, ca₂guei₃ bá₄ dsa₂ dse₃ ja₁jaun₂, ia₁ jme₁ma₂ca₂jág₃ bá₄ ca₂le₃jë́₃ 'e₂ a₂ca₂jmo₃ Jesús juɨg₂ Jerusalén jme₁ca₂të́₂ Jmɨg₄ Të₂'ɨn₅₄, ia₁ ján₃ bá₄ jme₁i₁len₅₄ 'éi₂ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jaun₂ në́₃, ca₂dsióg₃ táng₃ juɨg₂ Caná a₂tén₅ 'uë₃ Galilea ja₁ca₂jme₃tsɨ́in₃ jmɨg₂ ca₂jmo₃ vino. Ja₁jaun₂ jme₁'en₅₄ jan₂ dsa₂ i₂jme₂ti₃ ta₁ ne₄ rag₅₄, i₂chan₂ jan₂ chi'₂ dso'₅₄ quiáin₅, jë₄ juɨg₂ Capernaum. ");
INSERT INTO cntNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jme₁ca₂rë₃ŋi₅ dsa₂ 'éi₂ a₂ma₂ŋɨ₅ Jesús 'uë₃ Galilea, 'ein₅₄ juɨ₅ a₂o₂'ɨ́in₃ 'uë₃ Judea, jaun₂ ŋei₅₄ ca₂i₁jɨin₁₂ Jesús, jaun₂ ca₂chi₃quióng₂ jmɨg₄ tion₅₄-jan₃ a₂dsó₃ 'éi₂ ja₁quió'₄ a₂jme₃'lióin₂ ja₁ŋi'₅₄ i₂ron₅ ma₂i₁jón₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jaun₂ në́₃ ca₂juá'₂ Jesús: ―Tsá₃ 'én'₂ 'nia'₂ në₁jua'₂ tsá₃ ca₂jag'₅₄ léi₄ juë'₂ a₂dsɨ₂gó'₃ 'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jaun₂ ca₂juá'₂ dsa₂ i₂jme₂ti₃ ta₁ ne₄ rag₅₄ 'éi₂: ―Te₁gui'₅₄, i₂ŋáu'₂ uë́₃ ŋia₅, né'₃ guë́₄ a₂jón₂ chi'₂ quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jaun₂ në́₃ ca₂juá'₂ Jesús: ―Guan'₂ bá₄ quiáng'₂; ia₁ i₂chan₂ bá₄ chi'₂ quiáng'₂. Ca₂rë₃'én₂ bá₄ dsa₂ jág₁ a₂ca₂juá'₂ Jesús, jaun₂ ca₂ŋái'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jaun₂ jme₁ma₂'ein₅₄ juɨ₅ dsiáin'₂, jaun₂ ca₂jme₃jein'₂ dsa₂ i₂jme₂ti₃ ta₁ ne₅₄, jaun₂ ca₂juá'₂ 'éi₂: ―I₂chan₂ bá₄ chi'₂ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jaun₂ ca₂ŋag₃ 'e₂ hora ca₂tág'₃ dsɨ́₅. Jaun₂ ca₂juá'₂ dsa₂ 'éi₂: ―Dsióg₂ con'₂ hora ŋí₁ caun₂ të₂le₃ ca₂'láu₂, ca₂jŋia₃ dséi₂ a₂jme₁'i₁. ");
INSERT INTO cntNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jaun₂ ca₂rë₃lí'₄ jmei₂ chi'₂ 'éi₂, hora jaun₂ dé₄ ca₂juá'₂ Jesús: “I₂chan₂ bá₄ chi'₂ quiáng'₂.” Jaun₂ ca₂rë₃'én₂ dsa₂ 'éi₂, quiain'₅₄ ta₁jɨn₂ dsa₂ dsi₂néi₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","A₂në₅ jë₁ca₂të́₂ táng₃ léi₄ juë'₂ a₂ca₂jmo₃ Jesús, jme₁ca₂o₃'ɨ́in₃ Judea, jme₁guáin'₃ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Cang₂ jaun₂ ca₂jmo₃ dsa₂ judíos caun₂ jmɨg₄, jaun₂ ca₂uɨ́g₂ táng₃ Jesús juɨ₅ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jë₄ juɨg₂ Jerusalén jaun₂, cau₅ ja₁lë́₄ caun₂ o₄'né₄ a₂chei₂ quió'₅ Já'₂ Cha'₂, niog₅ caun₂ dsiog₅ a₂chei₂ Betesda quian'₅₄ jág₁ arameo, ja₁lë́₄ 'ŋiá₂ corredor. ");
INSERT INTO cntNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ja₁jaun₂ jme₁tián'₄ 'uë₃ juɨn₅ dsa₂ i₂qui₂le₁dso'₅₄, jë́₃ dsa₂ ten₄, dsa₂ guian'₅₄ quian'₅₄ dsa₂ 'lian'₂ në́₃, a₂chi₁jŋia₂₃ a₂qui₃jë́'₂ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ia₁ jme₁lɨn₅₄, sión₅ jan₂ ángel quián₅ Te₁gui'₅₄ ja₁niog₅ dsiog₅ jaun₂, jaun₂ jmo₂₃ qui₂jë́'₂ jmɨg₂. Jaun₂ juɨ₁lia'₂ dsa₂ dso'₅₄ i₂'í₂ le₂'uɨg₅₄ jmɨg₂ jë₁ma₂i₂bi₅₄, jme₁jŋia₅ quió'₅, chi₂jua'₂ 'e₂ dso₄ jme₁lɨ́in₄. ");
INSERT INTO cntNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ja₁jaun₂ jme₁ron₅ jan₂ dsa₂ dso'₅₄, jme₁ma₂të́₂ guióg₂-guiá₂-jŋiá₂ ŋi₂ roin₂₃ dso'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jme₁ca₂jág₃ Jesús ron₅ dsa₂ dso'₅₄ ja₁jaun₂, jaun₂ jme₁ca₂rë₃lí'₄ ma₂lɨ́g'₂ bá₄ lɨ́in₅ le₂jaun₂, ca₂ŋag₃: ―¿'Niog'₂ 'lióng'₂? ");
INSERT INTO cntNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jaun₂ ca₂ŋag₃ dsa₂ dso'₅₄: ―Gui'₅₄, tsá₃ 'ein₂ chan₂ to'₂ jniá₂ 'ŋió'₃ dsiog₅ jë₁ma₂të́₂ rë₁qui₃jë́'₂ jmɨg₂. Lia'₂ co₂ráun₂ 'nio₃ 'ú₄, i₂sián'₂ bá₄ sión₅ le₂'uɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jaun₂ ca₂juá'₂ Jesús: ―Nau₂, chog'₅₄ tsɨ₁jein₁ quiáng'₂, ŋɨ₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂jŋia₃ quió'₅ dsa₂ 'éi₂. Ca₂chóg'₃ tsɨ₁jein₁ quió'₅, jaun₂ ca₂jme₃lióg₃ ca₂ŋɨ₃. A₂jaun₂ ca₂lë₃ caun₂ jmɨg₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jaun₂ ca₂juá'₂ dsa₂ judíos ca₂tsɨ́'₃ dsa₂ i₂ca₂'lón₂ 'éi₂: ―Jmɨg₄ sa₅₄ bá₄ në₃; tsá₃ 'i₄ 'éi'₃ caun'₅₄ tsɨ₁jein₁ quiáng'₂ jmɨg₄ në₃. ");
INSERT INTO cntNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂: ―I₂në₂jme₃'lió₂ jniá₂, në₂juá'₂: “Chog'₅₄ tsɨ₁jein₁ quiáng'₂, ŋɨ₄ në́₃.” ");
INSERT INTO cntNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jaun₂ në́₃ ca₂ŋag₃ táng₃ dsa₂ 'éi₂: ―¿'Ein₂ 'éi₂ në₂juá'₂ a₂caun'₅₄ tsɨ₁jein₁ quiáng'₂, a₂ŋɨ́'₂ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","La₁ tsá₃ ŋi₅ 'ein₂ 'éi₂ i₂në₂jme₃'lió₂ quió'₅, ia₁ jme₁ma₂i₂cón'₅ Jesús jɨn₄ dsa₂ juɨn₅ i₂jme₁tion'₅₄ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Cang₂ jaun₂ ca₂jen'₂ Jesús ca₂jein'₂ dsa₂ 'éi₂ i₁dsi₅ guá'₅ templo, jaun₂ ca₂juá'₂: ―Jag₄ de'₂, në₃ lia'₂ ma₂'lóng'₂, tsá₃ ma₃lë₁'nau₂ dso₄, ia₁jaun₂ tsá₃ dsɨ₃ŋɨ́g'₂ caun₂ jmɨ₁uɨg₅ 'ŋio₅ guë́₄ con'₂ guë́₄ a₂jme₁lɨ́ng'₄ le₂jŋiá₅. ");
INSERT INTO cntNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jaun₂ ŋá'₃ bá₄ dsa₂ 'éi₂, jaun₂ ca₂i₁chi'₄ dsa₂ judíos, Jesús bá₄ 'éi₂ i₂ca₂jme₃'lió₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","'Uɨg₅₄ jaun₂ qui₂ca₂co₃'ein₃ dsa₂ judíos quió'₅ Jesús, ia₁ jme₁tɨn₂ Jesús jme₁jmo₂₃ le₂në₅ jmɨg₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","La₁ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂ judíos: ―Lia'₂ jmo₅ jaun₂ Ŋe'₃ ta₁ jŋia'₅₄ jmɨg₄ në₃; ján₃ bá₄ le₂jaun₂ jmo₅ jniá₂ ta₁. ");
INSERT INTO cntNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'Uɨg₅₄ jaun₂, të₂le₃ i₂juɨ'₂ guë́₄ jme₁'nio₃ jŋag'₃ dsa₂ judíos, ia₁ on₃jua'₅₄ jmá'₃ 'éi'₃ jmɨg₄ sa₅₄ jmo₂₃ cau₅, ján₃ bá₄ ca₂të₂ jmo₂₃ a₂lɨ́in₅ co₂rɨin₂ quian'₅₄ Diú₄, ia₁ a₂juá'₂ Diú₄ bá₄ lɨ́n₅ Jmei₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jaun₂ në́₃ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂ judíos: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, tsá₃ 'e₂ lé₂ le₃jmo₃ Ja₁ŋi'₅₄ 'i₁caun₂ 'ŋiog₅; a₂jaun₂ bá₄ jmo₂₃ juɨ₁lia'₂ a₂jág₅ jmo₅ Jmei₂. Juɨ₁lia'₂ 'e₂ ta₁ a₂jmo₅ Jmei₂, a₂jaun₂ bá₄ jmo₅ Ja₁ŋi'₅₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ia₁ 'nio₃ Jmei₂ 'nioi₃ Ja₁ŋi'₅₄, jaun₂ 'ë₂₃ 'ë́'₅ Ja₁ŋi'₅₄ ca₂le₃jë́₃ 'e₂ a₂jmo₂₃. Të₂le₃ lë́₅ guë́₄ juë'₂ ta₁ qui₃'ë₃, con'₂ guë́₄ a₂le₂la₂, ia₁jaun₂ qui₂dsɨ₃gó'₃ 'au'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ia₁, juɨ₁lia'₂ jme₂jen'₅₄ Jmei₂ jme₂jein'₅₄ 'lag₄, cuë₂₃ jme₂dsí₂ a₂le₃chain₂, ján₃ bá₄ le₂jaun₂ cuë₅ Ja₁ŋi'₅₄ jme₂dsí₂ cuë́'₅ juɨ₁lia'₂ i₂'nio₃ cuë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ján₃ guë'₂, tsá₃ con₂ Jmei₂ 'í₁ quió'₅ 'i₁jan₂; o₄gú₃ Ja₁ŋi'₅₄ bá₄ ma₂dsia₃ ca₂le₃jë́₃ 'éi'₃ a₂con₂ 'í₁, ");
INSERT INTO cntNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ia₁jaun₂ jme₃go₃ ca₂le₃jɨ́n₃ dsa₂ jme₃gain₃ Ja₁ŋi'₅₄, juɨ₁lia'₂ jme₂gain₃ Jmei₂. Juɨ₁lia'₂ i₂tsá₃ jme₂gan₃ Ja₁ŋi'₅₄, tsá₃ jme₂gain₃ Jmei₂ i₂ca₂chei₃. ");
INSERT INTO cntNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂: juɨ₁lia'₂ i₂nag₅ i₂tón'₂ juɨ₅ jág₁ quió₃, ton'₂ 'éin₂ të₂le₃ quió'₅ i₂ca₂chei₃, le₃chain₂ bá₄ co₂tan₅₄. Tsá₃ 'í₁ jióg'₂ ja₁coin₂, ia₁ ma₂ca₂ŋɨi₅ ne₄ 'mú₃, ma₂ca₂dsióg₃ ja₁le₃chain₂ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, já₅ jmɨg₄ ton'₂ ma₂të́₂ dsón'₂, jë₁ma₂të́₂ rë₁nag₃ 'lag₄ jág₁ quió'₅ Ja₁ŋi'₅₄ Diú₄. Juɨ₁lia'₂ i₂ne'₅₄ në́₃, le₃chain₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ia₁ juɨ₁lia'₂ 'io₅ bí₂ Jmei₂ a₂le₃chain₂ 'ŋiog₅, ján₃ bá₄ le₂në₅ ma₂cuë́'₃ Ja₁ŋi'₅₄ juɨ₅bí₂ a₂le₃chain₂ 'ŋiog₅. ");
INSERT INTO cntNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ján₃ bá₄ ma₂cuë₃ juɨ₅bí₂ a₂con₂ 'í₁ qui₃dsɨ₂₃ 'éi'₃, ia₁ lɨ́in₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tsá₃ lë₁juɨ₁dsi₂gó'₃ 'au'₂ 'nia'₂ jág₁ a₂në₂juá'₃ jniá₂ la₂, ia₁ já₅ hora a₂nag₃ ca₂le₃jɨ́n₃ dsa₂ i₂le₁'on₅ tau₂ 'ŋio₅, jág₁ quió'₅, ");
INSERT INTO cntNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","jaun₂ 'uɨ́in₃ ja₁jaun₂. Juɨ₁lia'₂ i₂ca₂jmo₃ a₂dsi₂ten₅₄, jein'₅₄ a₂dsi₁lein₅ ja₁le₃chain₂ co₂tan₅₄; la₁ia₁ juɨ₁lia'₂ i₂ca₂jmo₃ a₂'lɨg'₅₄, jein'₅₄ a₂të₃dsɨ₅₄ 'éi'₃ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Tsá₃ 'e₂ lé₂ le₃jmo₅₄ jniá₂ jua'₅₄ a₂jmo₅₄ con'₂ tɨng₂ 'ŋió₃. Qui₂dsɨ́₂ jniá₂ 'éi'₃ lia'₂ con'₂ lë́₅ jág₁ a₂nég'₄ ja₁con₂ Ŋe'₃, jaun₂ dsi₂ten₅₄ bá₄ 'éi'₃ a₂qui₂dsɨ́₂ jniá₂, ia₁ tsá₃ a₂jaun₂ jmo₅ jniá₂ lia'₂ con'₂ lë́₅ a₂'ŋio₂ dsɨ₃ 'ŋió₃; a₂jaun₂ bá₄ jmo₅ jniá₂ lia'₂ con'₂ lë́₅ a₂'ŋio₂ dsɨ́₅ 'éi₂ i₂ca₂chei₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Në₁jua'₂ jáng'₅ jniá₂ jág₁ dsau₅ ja₁cong₂ 'ŋió₃, jág₁ jaun₂ a₂jáng'₅, tsá₃ quen₅. ");
INSERT INTO cntNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","La₁ia₁ chan₂ guë́₄ jan₂ i₂sián'₂ i₂jáng'₅ jág₁ dsau₅ të₂le₃ quió₃ jniá₂, jaun₂ guion₄ jniá₂ juɨ₁lia'₂ a₂juá'₂ 'éi₂ 'ag₂₃ jniá₂, tí₅ bá₄ jág₁ a₂jáng'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ca₂chen'₂ 'nia'₂ dsa₂ a₂ca₂i₁ŋag₁₂ ne₄ Juan₅₄, jaun₂ dsón'₂ tí₅ bá₄ jág₁ dsau₅ a₂ca₂jáng'₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","La₁ia₁ on₃jua'₅₄ jaun₂ chén'₅ jniá₂ rë₂ ia₁ a₂jáng'₅ dsa₂ mɨ₂güɨ́g₃ jág₁ dsau₅ të₂le₃ quió₃ jniá₂; a₂jaun₂ bá₄ juɨ́g₂ jniá₂ 'nia'₂ jág₁ la₂ ia₁jaun₂ lé₂ le₃lión'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jme₁lɨ́n₄ Juan₅₄ në₂jag₄ caun₂ si₂ nɨ₁tsɨ́₅ a₂cau₂ a₂tág₅. Jaun₂ 'nia'₂ në́₃, jme₁ma₂'éi'₂ caun₂ 'au'₂ a₂jmó'₂ co₂'na₂ 'io'₂ ja₁tág₅ si₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","La₁ia₁ jniá₂ në́₃, 'ŋio₅₄ jan₂ i₂jáng'₅ jág₁ dsau₅ i₂juɨn'₂ guë́₄ lia'₂ con'₂ guë́₄ Juan₅₄. Ia₁ juɨ₁lia'₂ léi₄ a₂jmo₅ jniá₂, a₂jaun₂ ca₂cuë₃ Ŋe'₃ a₂jmo₅₄. A₂jaun₂ bá₄ jáng'₅ jág₁ dsau₅ a₂dsón'₂ bá₄ ca₂chei₃ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ján₃ bá₄ le₂jaun₂, 'ŋiog₅ bá₄ Ŋe'₃ jniá₂ i₂ca₂chei₃, jáng'₅ 'éi₂ jág₁ dsau₅ të₂le₃ quió₃ jniá₂. 'Nia'₂ në́₃, lia'₂ 'i₁cón'₂ tsá₃ ma₂nei'₂ 'nia'₂ jág₁ quió'₅, on₃ guë'₂ ma₂jɨin'₅₄ 'nia'₂ 'a₂ lia'₂ lɨ́in₅, ");
INSERT INTO cntNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","on₃ guë'₂ ma₂të₁gua₁ jág₁ quió'₅ të₂'au'₂, ia₁ tsá₃ 'én'₂ 'nia'₂ të₂le₃ quió'₅ 'ŋiog₅ i₂ca₂chein₃. ");
INSERT INTO cntNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","A₂'ɨ'₂ 'nia'₂ Si₂ quió'₅ Diú₄ ca₂lia'₂ dsen₅₄ 'au'₂, ia₁ lɨ́n'₂ 'nia'₂ a₂le₃chan₂ 'nia'₂ co₂tan₅₄ të₂le₃ quian'₅₄ Si₂ jaun₂. Si₂ jaun₂ bá₄ jáng'₅ jág₁ dsau₅ 'ag₂₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jaun₂ 'nia'₂ në́₃, tsá₃ 'niog'₂ i₁nóg'₅ ne₃ jniá₂ ia₁jaun₂ le₃chan'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Tsá₃ gue₅ jniá₂ a₂jme₂juag'₂ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","La₁ cuɨ́n₅ jniá₂ 'nia'₂, jaun₂ guion₄ jniá₂ a₂tsá₃ jaun₂ le₁'i₁ të₂'au'₂ 'nia'₂ a₂niog₅ dsɨ́₅ Diú₄ a₂'nioi₃ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","O₄quió'₄ Ŋe'₃ bá₄ jniá₂ guio₃, 'nia'₂ guë'₂ tsá₃ guéi'₅ jniá₂; la₁ia₁ në₁jua'₂ ca₂já₃ jan₂ o₄quió'₄ 'ŋiog₅, i₂'éi₂ bá₄ guén'₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿'A₂ lia'₂ lé₂ le₃'én'₂ 'nia'₂, chi₂jua'₂ jaun₂ 'náu'₂ a₂tióng'₂ rë₂ quiang'₅₄ rɨ́ng'₂, tsá₃ guë'₂ 'náu'₂ 'nia'₂ a₂qui₁náu'₂ rë₂ quiang'₅₄ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tsá₃ o₁len'₂ 'nia'₂ jua'₅₄ a₂'nág₄ jniá₂ ne₄ Ŋe'₃; chan₂ jan₂ i₂'nag₅: Moisés bá₄ 'éi₂. Le₃quió'₅ 'éi₂ bá₄ 'ɨ́n₂ 'au'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ia₁ jua'₅₄ mei'₂ guë́₃ ca₂rë₃'éng'₂ jág₁ quió'₅ Moisés, ján₃ bá₄ le₂jaun₂ jme₁le₃'éng'₂ jág₁ quió₃, ia₁ jniá₂ bá₄ ca₂'ag₃ Moisés ne₄ Si₂. ");
INSERT INTO cntNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","La₁ chi₂jua'₂ tsá₃ 'én'₂ guë'₂ 'nia'₂ jág₁ a₂ca₂tó'₂ 'éi₂ ne₄ Si₂, ¿'a₂ guë'₂ lia'₂ lé₂ le₃'én'₂ 'nia'₂ jág₁ a₂juá'₅ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cang₂ jaun₂ ca₂ŋó₃ Jesús të₂le₃ quióng₄ ca₂taun₂ jmɨ₁ŋí'₄ Galilea, (a₂chei₂ jmɨ₁ŋí'₄ Tiberias). ");
INSERT INTO cntNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jaun₂ ca₂i₃lén₂ juɨn₅ lɨn₃ dsa₂ chi₁co'₅₄ quió'₅, ia₁ ma₂jág₃ léi₄ juë'₂ a₂ma₂jmo₃, a₂qui₂ma₂ca₂jme₂'lióin₂ dsa₂ i₂jme₁le₁dso'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jaun₂ në́₃ ca₂uɨ́g₂ Jesús caun₂ má'₂, jaun₂ ca₂guá₂ ja₁jaun₂ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jmɨg₄ jaun₂, jme₁ma₂ja₂quián₃ Jmɨg₄ Të₂'ɨn₅₄, co₂'nió'₄ jmɨg₄ quió'₅ dsa₂ judíos. ");
INSERT INTO cntNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jme₁ca₂jág₃ Jesús ca₂jɨ́in₂ juɨn₅ lɨn₃ dsa₂ i₂ja₂lén₂, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ Felipe: ―¿A₂já'₄ dsɨ₁liá₄ má₃ a₂guë́'₃ ca₂le₃jɨ́n₃ dsa₂ në₅? ");
INSERT INTO cntNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A₂jaun₂ bá₄ ca₂juá'₂ Jesús le₂në₅ o₁ne₄ 'e₂ jme₁ŋag₃ Fe₂li₄, ia₁ jme₁ma₂ŋi₅ rë₂ bá₄ Jesús 'ŋiog₅ 'e₂ a₂jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jaun₂ në́₃ ca₂ŋag₃ Fe₂li₄: ―Tɨn₃ 'ŋiá₂-láu₂ denario i₁ŋí'₄ tsá₃ len₅ bá₄ guë́₄ a₂ŋe₂ jma₃ca₂juɨg₄ le₂jan₂ le₂jan₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jaun₂ në́₃ ca₂ŋag₃ guë́₄ jan₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quián₅ Jesús, i₂jme₁chen₂ Drë́₄ rɨn'₅₄ Si₂mu₅₄ Pe₄: ");
INSERT INTO cntNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Jë₄ la₂ 'en₅₄ jan₂ i₂bë'₅₄ i₂quian₅ 'ŋiá₂ i₁ŋí'₄ cebada, quian'₅₄ guë'₂ on₃ ju₄; la₁ia₁, ¿'e₂ bá₄ cha₂ 'e₂ jaun₂, ja₁con₂ dsa₂ juɨn₅ le₂në₅? ");
INSERT INTO cntNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jaun₂ në́₃ ca₂juá'₂ Jesús: ―Chei'₅₄ dsa₂ ca₂le₃jɨ́in₃ juɨ₁tiain'₂₃. 'Lióng₂ ŋi₂ma'₂ jme₁cha₂ ja₁jaun₂, jaun₂ ca₂tián'₂ dsa₂ ŋe'₂, i₂jme₁lë́₂ con'₂ 'ŋiá₂ mei₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jaun₂ në́₃ ca₂can₃ Jesús i₁ŋí'₄, jaun₂ jme₁ma₂në₂cuë́'₃ ti₁'mag'₄ Diú₄, qui₂ca₂dsió'₃ ca₂cuë́'₃ ca₂le₃jɨ́n₃ dsa₂ i₂jme₁tián'₄ ja₁jaun₂. Ján₃ bá₄ le₂jaun₂ ca₂jmo₃ quian'₅₄ dsɨ₂ju₄ 'éi₂, ca₂cuë́'₃ ca₂le₃jɨ́n₃ dsa₂ 'a₂ con'₂ jŋia'₅₄ 'nio₃. ");
INSERT INTO cntNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jaun₂ jme₁ma₂lɨ́'₃ dsa₂ guë́'₅, ca₂juá'₂ Jesús ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―Cag'₅₄ 'nia'₂ nɨ₁jne₁ i₁ŋí'₄ a₂ca₂chóng₃, ia₁jaun₂ tsá₃ 'e₂ dsɨ₃'én₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jaun₂ ca₂cág'₃, jaun₂ ca₂jme₃cain'₂ guia₃-tɨ́n₂ tsɨ₁mɨ'₂ tá₂, quian'₅₄ nɨ₁jne₁ a₂ca₂chóng₃ a₂'ŋiá₂ i₁ŋí'₄ cebada jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jaun₂ në́₃, jme₁ca₂jág₃ dsa₂ léi₄ a₂ca₂jmo₃ Jesús, ca₂juá'₂: ―Dsón'₂ bá₄ lɨ́n₅ dsa₂ në₅ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄, i₂lë́₅ jág₁ jiá₃ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","La₁ ca₂rë₃lí'₄ bá₄ Jesús a₂'nio₃ dsa₂ jme₁të₂ tion₅₄, a₂jme₁jmói'₂ 'éi₂ rag₅₄, jaun₂ ca₂ŋái'₃ bá₄ táng₃ ca₂'í₃ má'₂ con'₂ 'ŋiog₅. ");
INSERT INTO cntNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jme₁ca₂nei₂ jaun₂, ca₂sión₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ ca₂të₂ jmɨ₁ŋí'₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jaun₂ ca₂tóin'₂ 'ŋió'₃ caun₂ tsɨ₁mu₅, jaun₂ ca₂jme₃lióg₃ ca₂'ain₃ jmɨ₁ŋí'₄ a₂dsɨ₃léin₂ Capernaum. Jme₁ma₂tó'₂ nei₂ bá₄ jaun₂, tsá₃ jme₁ma₂quiong'₅₄ bá₄ guë́₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jaun₂ ca₂rë₃lióg₃ ca₂'ág₂ dsí₂ tiá₂ lɨn₃, jaun₂ qui₂ca₂ron'₂ jmɨ₁ŋí'₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jme₁ma₂'ain₂ con'₂ 'ŋiá₂-jŋéi₂ kilómetros, jaun₂ ca₂jág₃ a₂ja₂quián₃ Jesús cau₅ tsɨ₁mu₅, a₂ŋɨ₂₃ ne₄ jmɨg₂; jaun₂ ca₂rë₃gó'₅ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","La₁ia₁ ca₂juá'₂ Jesús: ―¡Jniá₂ bá₄ la₂; tsá₃ lë₁jmo₂ 'nia'₂ gang'₃! ");
INSERT INTO cntNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jaun₂ në́₃ ca₂lia'₂ 'io'₂ jén'₅ bá₄ ca₂guein₃ Jesús 'ŋió'₃ tsɨ₁mu₅, jaun₂ quian'₅₄ ca₂tiá₂ co₂lág₂ bá₄ ca₂dsi₃léin₂ chei'₅₄ 'uë₃ ja₁jme₁tioin'₅₄ juɨ₅ i₃léin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jme₁ca₂jnia₃ jaun₂, ca₂rë₃lí'₄ dsa₂ i₂të₁'ŋiá₄ të₂le₃ quióng₄ ca₂taun₂ jmɨ₁ŋí'₄, a₂jme₁chí'₄ caun₂ tan₅₄ tsɨ₁mu₅ ja₁jaun₂, ton'₂ tsá₃ ca₂'í₃ Jesús 'ŋió'₃ jaun₂ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂; guion₅₄ bá₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ i₃léin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","La₁ të₁lia'₂ jaun₂, o₃lé₂ tsɨ₁mu₅ siá'₂ a₂ja₂lei₃ juɨg₂ Tiberias, ca₂o₃lé₂ quián₅ ja₁ca₂guë́'₃ i₁ŋí'₄ le₂jŋiá₅ jme₁ca₂lë₃ cuë́'₅ Te₁gui'₅₄ ti₁'mag'₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jaun₂ në́₃, jme₁ca₂rë₃lí'₄ dsa₂ a₂tsá₃ Jesús chan₂ ja₁jaun₂, on₃ guë'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, ca₂i₃toin'₅₄ 'ŋió'₃ tsɨ₁mu₅, ca₂i₃léin₂ juɨ₅ Capernaum ca₂i₁'niog'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jme₁ca₂dsi₃lén₂ dsa₂ të₂le₃ quióng₄ ca₂taun₂ jmɨ₁ŋí'₄, ca₂dsáin'₂ Jesús, jaun₂ ca₂ŋag₃: ―Të₅, ¿lɨ́g'₂ guang'₃ ja₁lá₃? ");
INSERT INTO cntNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","La₁ia₁ ca₂ŋag₃ Jesús ca₂tsɨ́'₃ dsa₂ 'éi₂: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, a₂'nau'₂ jniá₂ i₂niog'₅₄, ia₁ ca₂qué'₂ 'nia'₂ lia'₂ 'ág'₃ 'au'₂ i₁ŋí'₄, on₃jua'₅₄ rë'₂ ia₁ a₂ca₂rë₃ŋɨ́'₂ 'nia'₂ léi₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tsá₃ lë₁jmo₂ 'nia'₂ ta₁ o₄quió'₄ má₃ a₂jŋia'₅₄ con'₂ dsɨ₃'én₂, të₂le₃ o₄quió'₄ má₃ a₂jiog₅ co₂tan₅₄ bá₄ jmo₄ 'nia'₂ ta₁, a₂cuë₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃. Ia₁ ne₄ 'éi₂ ma₂tióng₃ 'ŋiog₅ bá₄ Diú₄ Jmei₂ léi₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jaun₂ në́₃ ca₂ŋag₃ dsa₂: ―¿'E₂ 'nió'₅ jmó₁ jnia'₅₄ ia₁jaun₂ lé₂ le₃jmó₁ jnia'₅₄ ta₁ a₂'nio₃ Diú₄ jmó₁? ");
INSERT INTO cntNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jaun₂ ca₂ŋag₃ Jesús: ―A₂la₂ bá₄ ta₁ quió'₅ Diú₄: a₂le₃'én'₂ 'nia'₂ të₂le₃ quió'₅ i₂chen₄ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jaun₂ në́₃ ca₂ŋag₃ dsa₂: ―¿'E₂ léi₄ lé₂ le₃'ë́'₂ jnia'₅₄, ia₁jaun₂ jag₅₄ jnia'₅₄ jaun₂ le₃'éin₂ jnia'₅₄ quiáng'₂? ¿'E₂ léi₄ jmó'₂? ");
INSERT INTO cntNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Dsa₂ can'₅₄ quián₂ jnia'₅₄ ma₂lɨ́g'₂, ca₂guë́'₃ i₁ŋí'₄ maná, lia'₂ con'₂ jme₁tioin'₅₄ 'uë₃ quein₂ co₂'ŋiog₅ jaun₂, juɨ₁lia'₂ juá'₂ ne₄ Si₂ quió'₅ Diú₄: “Ca₂cuë₃ Moisés ca₂guë́'₃ 'éi₂ i₁ŋí'₄ a₂ca₂já₃ guei'₅₄ i₂juɨ́g₃.” ");
INSERT INTO cntNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jaun₂ ca₂ŋag₃ Jesús: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂: on₃jua'₅₄ Moisés i₂ca₂cuë₃ i₁ŋí'₄ a₂já₅ guei'₅₄ i₂juɨ́g₃; Ŋe'₃ bá₄ jniá₂ i₂cuë́'₅ 'nia'₂ i₁ŋí'₄ të₃dsón'₂ a₂já₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ia₁ juɨ₁lia'₂ i₁ŋí'₄ a₂já₅ ja₁con₂ Diú₄, i₂'éi₂ bá₄ lɨ́n₅, i₂ca₂sión₃ guei'₅₄ i₂juɨ́g₃, i₂jmo₅ a₂le₃chan₂ dsa₂ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jaun₂ në́₃ ca₂juá'₂ dsa₂ ca₂tsɨ́'₃ Jesús: ―Te₁gui'₅₄, cuë₄ lia'₂ o₂jmɨg₄ i₁ŋí'₄ a₂'ë'₂ 'ne₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jaun₂ ca₂juá'₂ Jesús: ―Jniá₂ bá₄ lɨ́ng₅ i₁ŋí'₄ a₂jmo₅ a₂le₃chan₂ dsa₂. Juɨ₁lia'₂ i₂ja₂ ja₁con₂ jniá₂, lia'₂ o₁lɨ́g'₂ jmɨg₄ tsá₃ ma₃lé₂ i₁cón'₅; ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ i₂'én₂ të₂le₃ quió₃ jniá₂, lia'₂ o₁lɨ́g'₂ jmɨg₄ tsá₃ ma₃le₃quein₂ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","La₁ juɨ₁lia'₂ ma₂në₂juɨ́g₂ jniá₂ 'nia'₂, tsá₃ 'én'₂ 'nia'₂ o₁jŋia'₅₄ ma₂në₂jag'₅₄ 'nia'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ca₂le₃jɨ́n₃ juɨ₁lia'₂ dsa₂ i₂cuɨn₅ Ŋe'₃ cuɨg₂₃ jniá₂, ja₃léin₂ ja₁con₂ jniá₂; jaun₂ juɨ₁lia'₂ i₂ja₂ ja₁con₂ jniá₂, lia'₂ o₁'e₂ guë́₃ tsá₃ dséin₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ia₁ on₃jua'₅₄ jaun₂ guio₃ jniá₂ ca₂sióng₃ guei'₅₄ i₂juɨ́g₃ jua'₅₄ a₂jmo₅₄ a₂'ŋio₂ dsɨ₃ 'ŋió₃; a₂jaun₂ bá₄ guio₃ a₂jmo₅₄ a₂'ŋio₂ dsɨ́₅ i₂ca₂chei₃. ");
INSERT INTO cntNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A₂la₂ bá₄ a₂'ŋio₂ dsɨ́₅ i₂ca₂chei₃: a₂tsá₃ qui₂dsɨ₃cón'₅ 'i₁jan₂ i₂ma₂cuɨn₃ 'éi₂ jniá₂, të₂le₃ a₂jme₁jein'₅₄ bá₄ jniá₂ jmɨg₄ jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","A₂la₂ bá₄ a₂'ŋio₂ dsɨ́₅ Ŋe'₃: juɨ₁lia'₂ ca₂le₃jɨ́n₃ i₂jɨ́n₂ Ja₁ŋi'₅₄ ton'₂ 'éin₂ të₂le₃ quió'₅, juɨ₁le₂chain₂ co₂tan₅₄, jaun₂ jniá₂ në́₃ jme₁jein'₅₄ jmɨg₄ jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Quian'₅₄ jág₁ në₅ ca₂jme₃lióg₃ dsa₂ judíos qui₂ca₂dsia₃ guioin₅₄, ca₂chi₃'ɨin₃ Jesús ia₁ jme₁ma₂në₂juá'₂: “Jniá₂ bá₄ lɨ́ng₅ i₁ŋí'₄ i₂ca₂sión₃ guei'₅₄ i₂juɨ́g₃.” ");
INSERT INTO cntNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jaun₂ ca₂juá'₂: ―¿On₃jua'₅₄ i₂në₅ Jesús ja₁ŋi'₅₄ Së́₄? I₂cuɨn₅ bá₄ jniog₄ chog₅₄-jmei₂ i₂në₅. ¿'A₂ guë'₂ lia'₂ juá'₂ a₂ca₂sióin₃ guei'₅₄ i₂juɨ́g₃? ");
INSERT INTO cntNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jaun₂ në́₃ ca₂juá'₂ Jesús: ―Tsá₃ lë₁ma₃chi₂'ág₅ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Lia'₂ 'i₁jan₂ tsá₃ lé₂ jiá₃ ja₁con₂ jniá₂, jua'₅₄ tsá₃ o₂jiog₃ Ŋe'₃ i₂ca₂chei₃; jaun₂ jniá₂ jme₁jein'₅₄ jmɨg₄ jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Le₂la₂ ca₂tó'₂ ne₄ Si₂ dsa₂ i₂jme₁'ë́₂ jág₁ o₄quió'₄ Diú₄: “Diú₄ bá₄ jme₃tag₅ jme₃tɨin₂₃ ca₂le₃jɨ́n₃ dsa₂.” Jaun₂ ca₂le₃jɨ́n₃ juɨ₁lia'₂ i₂nag₅ jág₁ quió'₅ Ŋe'₃, ton'₂ qui₂rë₂tɨin₂ 'e₂ a₂jmo₅ 'éi₂, ja₃léin₂ bá₄ ja₁con₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","On₃jua'₅₄ rë'₂ ia₁ 'ein₂ ma₂jɨ́n₂ Jmei₂. Jŋia'₅₄ lia'₂ i₂ca₂já₃ ja₁con₂ Diú₄; i₂'éi₂ bá₄ ma₂jɨ́n₂ Jmei₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A₂dsón'₂ juɨ́g₂ jniá₂ 'nia'₂, juɨ₁lia'₂ i₂'én₂, le₃chain₂ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jniá₂ bá₄ lɨ́ng₅ i₁ŋí'₄ a₂jmo₅ a₂le₃chan₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Qui₂ca₂guë́'₃ dsa₂ can'₅₄ quián'₂ 'nia'₂ i₁ŋí'₄ maná, lia'₂ con'₂ jme₁tioin'₅₄ 'uë₃ quein₂ co₂'ŋiog₅ jaun₂, la₁ ca₂dsain₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","A₂la₂ bá₄ lë́₅ i₁ŋí'₄ a₂ca₂sió₃ guei'₅₄ i₂juɨ́g₃ ia₁jaun₂ në₁jua'₂ 'ein₂ ca₂guë́'₃, tsá₃ dsiáin₃. ");
INSERT INTO cntNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jniá₂ bá₄ lɨ́ng₅ i₁ŋí'₄ jén'₃ i₂ca₂sión₃ guei'₅₄ i₂juɨ́g₃ jaun₂; juɨ₁lia'₂ i₂guë́'₅ i₁ŋí'₄ la₂, le₃chain₂ co₂tan₅₄. I₁ŋí'₄ juɨ₁lia'₂ a₂juá'₅ jniá₂ cuë₅₄, nɨ₁ŋɨ₃ 'ŋió₃ bá₄ jniá₂ 'ë₂₃, a₂jáng'₄ jniá₂ ia₁jaun₂ le₃chan₂ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jaun₂ në́₃ qui₂ca₂chen₃ dsa₂ judíos guioin₅₄, a₂juá'₂: ―¿'A₂ lia'₂ lé₂ le₃cuë₃ i₂në₅ ŋɨ₅₄ 'ŋiog₅ a₂que₅₄ jniog₄? ");
INSERT INTO cntNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jaun₂ ca₂juá'₂ Jesús: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, në₁jua'₂ tsá₃ ca₂qué'₂ 'nia'₂ ŋɨ₄ Jaun₅ dsa₂ mɨ₂güɨ́g₃, në₁jua'₂ tsá₃ ca₂'én'₂ 'nia'₂ jmɨ₂ 'ain₅₄ në́₃, tsá₃ jén'₃ 'nia'₂ të₁lia'₂ chang'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Juɨ₁lia'₂ i₂guë́'₅ ŋɨ₃ jniá₂, ton'₂ 'ɨ́n'₂ jmɨ₃ jniá₂ në́₃, le₃chain₂ bá₄ co₂tan₅₄; jaun₂ jniá₂ jme₁jein'₅₄ jmɨg₄ jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ia₁ nɨ₁ŋɨ₃ jniá₂ bá₄ lë́₅ má₃ a₂tí₅ dsón'₂; ján₃ bá₄ le₂jaun₂ jmɨ₃ jniá₂ lë́₅ jmɨg₂ a₂'ág'₃ dsɨ́₅ të₃dsón'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Juɨ₁lia'₂ i₂guë́'₅ ŋɨ₃ jniá₂, ton'₂ 'ɨ́n'₂ jmɨ₃ jniá₂ në́₃, të₂'ŋiai₅₄ le₃quió₃ jniá₂; jniá₂ guë'₂ le₃quió'₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Juɨ₁lia'₂ ca₂chei₃ Ŋe'₃ jén'₃ ca₂chei₃ jniá₂, jaun₂ chan₂ jniá₂ 'uɨg₅₄ quió'₅ 'éi₂, ján₃ bá₄ le₂jaun₂, juɨ₁lia'₂ i₂guë́'₅ quió₃ jniá₂, le₃chain₂ 'uɨg₅₄ quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","A₂la₂ bá₄ 'ë₂₃ i₁ŋí'₄ i₂ca₂sión₃ guei'₅₄ i₂juɨ́g₃. Qui₂ca₂guë́'₃ dsa₂ can'₅₄ quián'₂ 'nia'₂ i₁ŋí'₄ maná, la₁ ca₂dsain₃; la₁ juɨ₁lia'₂ i₂guë́'₅ i₁ŋí'₄ la₂, le₃chain₂ bá₄ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jág₁ në₅ ca₂juá'₂ Jesús të₁lia'₂ ca₂jme₃tag₂₃ dsi₂néi₂ guá'₅ sinagoga jë₄ juɨg₂ Capernaum. ");
INSERT INTO cntNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jme₁ca₂nág₂ dsa₂ jág₁ jaun₂ a₂jme₂tag₅ Jesús, juɨn₅ dsa₂ i₂quian'₅₄ Jesús ca₂juá'₂: ―Jág₁ a₂juá'₂ në₅ 'ŋio₅ lɨn₃ juɨ́'₅, quian₅ ta₁ guéi₁. ¿'Ein₂ bá₄ lé₂ le₃tón'₂ juɨ₅ quió'₅? ");
INSERT INTO cntNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jaun₂ në́₃ ca₂rë₃lí'₄ Jesús 'e₂ jág₁ chen₅ dsa₂ tioin'₅₄, o₄quió'₄ jág₁ jaun₂, jaun₂ ca₂juá'₂: ―¿O₃ bá₄ tsá₃ dse₃ ca₂tɨ́n'₂ 'nia'₂ jág₁ në₅? ");
INSERT INTO cntNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿'E₂ bá₄ lé₂ jaun₂ në₁jua'₂ ca₂jɨng'₅₄ 'nia'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ a₂uɨ́g₂ táng₃ ja₁jme₁'ein₅₄ le₂jŋiá₅? ");
INSERT INTO cntNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jme₂dsí₂ bá₄ i₂jmo₅ a₂chan₂ dsa₂; juɨ₁lia'₂ nɨ₁ŋɨ₁ dsa₂ në́₃, tsá₃ ta₁ tí₄. La₁ jág₁ a₂ma₂në₂juɨ́g₂ jniá₂ 'nia'₂, a₂gu₂dsí₂ bá₄ jaun₂, ton'₂ jmo₅ a₂chan₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","La₁ tion'₅₄ bá₄ guë́₄ i₂lɨn₅₄ 'nia'₂ i₂tsá₃ 'én₂. Ia₁ jme₁ma₂ŋi₅ bá₄ Jesús lia'₂ con'₂ le₂'uɨg₅₄ i₂'ein₂ 'éi₂ tsá₃ 'én₂, i₂'ein₂ guë'₂ i₂jáng'₂ cang₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jaun₂ ca₂juá'₂: ―'Uɨg₅₄ jaun₂ ma₂në₂juɨ́g₂ jniá₂ 'nia'₂, lia'₂ 'i₁jan₂ tsá₃ lé₂ jiá₃ ja₁con₂ jniá₂ jua'₅₄ tsá₃ o₂jiog₃ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ca₂le₃jaun₂, juɨn₅ dsa₂ i₂jme₁i₂nio₄ quiain'₅₄ Jesús ca₂i₃uɨ́in₂ cau₅, tsá₃ ma₃jme₁i₂nioi₅₄ quiain'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jaun₂ në́₃ ca₂ŋag₃ Jesús ca₂ŋɨ́i'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―¿O₃ bá₄ 'niog'₂ 'nia'₂ o₁nog'₁ ján₃? ");
INSERT INTO cntNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","La₁ ca₂ŋag₃ Si₂mu₅₄ Pe₄: ―Te₁gui'₅₄, ¿ne₄ 'ein₂ lé₂ dsɨ₁náu₄ jnia'₅₄? Ia₁ 'ne₂ bá₄ 'au'₂ jág₁ a₂le₃chong₂ jnia'₅₄ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ma₂ca₂rë₃'éin₂ bá₄ jnia'₅₄, jaun₂ ne₄ jnia'₅₄, 'ne₂ bá₄ lɨ́ng'₅ I₂jŋió₅ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jaun₂ ca₂ŋag₃ Jesús: ―¿On₁jua'₅₄ jniá₂ ca₂quiong'₅₄ 'nia'₂ ta₁guia₃-tɨ́n'₂? La₁ia₁, jan₂ i₂'en₅₄ jë₄ quián'₂ 'nia'₂ lɨ́n₅ i₂'lɨn'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(A₂ca₂juá'₂ Jesús le₂në₅ a₂'ɨin₂₃ Judas bá₄, ja₁ŋi'₅₄ Si₂mu₅₄ Iscariote, ia₁ Judas bá₄ i₂jáng'₂ quió'₅, o₁jŋia'₅₄ lɨ́in₅ jan₂ dsa₂ guia₃-tɨ́n₂.) ");
INSERT INTO cntNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Cang₂ jaun₂, ca₂ŋɨ₃ Jesús 'uë₃ Galilea; a₂tsá₃ 'nio₃ dsɨ₃ŋɨ́₃ jë₄ 'uë₃ Judea, ia₁ ja₁jaun₂ jme₁'nio₃ dsa₂ judíos jŋag'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","La₁ia₁ jme₁ma₂ja₂quián₃ Jmɨg₄ quió'₅ Tsɨ₁'io₅ Láu₃, jmɨg₄ quió'₅ dsa₂ judíos, ");
INSERT INTO cntNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","jaun₂ ca₂juá'₂ rɨn'₅₄ Jesús: ―Tsá₃ lë₁jan₁ ja₁lá₃; gua₂ juɨ₅ Judea, ia₁jaun₂ jág₃ dsa₂ i₂quiang'₅₄ léi₄ a₂jmo'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ia₁ juɨ₁lia'₂ i₂'nio₃ a₂le₃cuɨg₅ dsa₂ quió'₅, tsá₃ jmo₂₃ juɨ₁lia'₂ a₂tɨin₂₃ jë₄ chi₁'ma₁. Chi₂jua'₂ dsón'₂ jmo'₂ léi₄ le₂në₅, jmo₄ të₃ jág₅ dsa₂ juɨn₅. ");
INSERT INTO cntNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ia₁ ca₂lia'₂ jŋia'₅₄ rɨn'₅₄ bá₄ Jesús tsá₃ jme₁'éin₂ le₃quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jaun₂ në́₃, ca₂juá'₂ Jesús ca₂tsɨ́'₃ rɨin'₅₄: ―Tsá₃ ma₂të́₂ bá₄ guë́₄ hora quió₃ jniá₂, la₁ia₁ të₂le₃ quián'₂ 'nia'₂, jua'₅₄ 'e₂ guë́₃ hora bá₄ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tsá₃ lé₂ le₃jme₃'iog₅₄ dsa₂ mɨ₂güɨ́g₃ jme₃'ŋiai₅₄ 'nia'₂; la₁ia₁ 'iog₅₄ bá₄ jniá₂, 'uɨg₅₄ ia₁ a₂jáng'₅ jniá₂ jág₁ dsau₅ ja₁con₂ 'éi₂, a₂'lɨg'₅₄ bá₄ a₂jmo₂₃-dsáu₅. ");
INSERT INTO cntNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","O₂nó'₅ 'nia'₂ guiong'₅₄ jmɨg₄; tsá₃ nei₅₄ jniá₂, ia₁ tsá₃ ma₂dsɨn₃ guë́₄ hora quió₃. ");
INSERT INTO cntNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jme₁ma₂në₂chí'₃ rɨin'₅₄ le₂në₅, ca₂jŋia₃ jë₄ 'uë₃ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","La₁ cang₂ guë́₄ jaun₂, jme₁ma₂i₂lén₂ rɨn'₅₄ Jesús, ján₃ bá₄ ca₂ŋó₃ 'éi₂ jmɨg₄ jaun₂, o₁jŋia'₅₄ ca₂ŋó₃ të₃ tsá₃ jme₂li₅₄ jɨn₄ dsa₂ juɨn₅. Mei'₂ tsá₃ con'₂ të₃co'₅₄ bá₄ ŋó₃. ");
INSERT INTO cntNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jaun₂ lë₃, ca₂i₁nio₁ dsa₂ judíos 'nai'₂ Jesús ja₁niog₅ jmɨg₄, jaun₂ juá'₂: ―¿A₂já'₄ 'en₅₄ dsa₂ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jɨn₄ dsa₂ guë'₂, juɨn₅ i₂dsia₅ të₂'ua₁ jɨn₄ rɨin'₅₄ a₂'ɨin₂₃ 'éi₂. I₂lɨn₅₄ juá'₂: “Dsa₂ dsen₃ bá₄ 'éi₂”, la₁ i₂sián'₂ guë'₂ juá'₂: “On₃jua'₅₄ dsa₂ dsen₃ 'éi₂, ia₁ jme₂gain₂₃ dsa₂.” ");
INSERT INTO cntNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","La₁ia₁ lia'₂ 'i₁jan₂ tsá₃ ca₂dsia₃ lia'₂ rë₂jiá₃ jág₁ a₂'ɨin₂₃ 'éi₂, ia₁ a₂gain₃ dsa₂ judíos. ");
INSERT INTO cntNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Con'₂ tɨn₃ dso'₅₄ jmɨg₄ jme₁ma₂të́₂, jaun₂ ca₂'í₃ Jesús i₁dsi₅ guá'₅ templo, jaun₂ ca₂jme₃lióg₃ ca₂jme₃tɨin₂₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jaun₂ ca₂i₃gó'₃ dsɨ́₅ dsa₂ judíos jaun₂ ca₂juá'₂: ―¿'A₂ lia'₂ ŋɨ́₄ lë₃ ma₂tɨn₂ si₂ i₂në₅ të₃ tsá₃ si₂ ca₂'ɨ́₂? ");
INSERT INTO cntNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jaun₂ ca₂ŋag₃ Jesús: ―Juɨ₁lia'₂ a₂jme₂tág₂ jniá₂ la₂, on₃jua'₅₄ jág₁ quió₃ 'ŋió₃ juá'₅; jág₁ quió'₅ i₂ca₂chei₃ bá₄ la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Chi₂jua'₂ 'ein₂ jan₂ ma₂'ei₅ dsɨ́₅ jmo₃ a₂'ŋio₂ dsɨ́₅ Diú₄, le₃ŋi₅ bá₄ 'éi₂ 'a₂ lia'₂ lë́₅ jág₁ a₂jme₂tág₂ jniá₂, chi₂jua'₂ já₅ ja₁con₂ Diú₄, o₃ chi₂jua'₂ dsia₂₃ 'a₂ con'₂ tɨng₂ 'ŋió₃. ");
INSERT INTO cntNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Juɨ₁lia'₂ i₂dsia₅ o₄quió'₄ 'ŋiog₅, jmo₂₃ le₂jaun₂ ia₁jaun₂ jme₃juag'₂ dsa₂. La₁ juɨ₁lia'₂ i₂'no'₂ a₂le₃juɨn'₂ i₂ca₂chei₃, i₂të₃dsón'₂ bá₄ 'éi₂; 'i₁caun₂ a₂'lɨg'₅₄ tsá₃ cha₂ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿On₁jua'₅₄ Moisés ca₂cuë₃ 'Éi'₃ ca₂cuë́'₃ 'nia'₂? La₁ia₁, ca₂lia'₂ 'i₁jan'₂ 'nia'₂ tsá₃ jme₂tí'₁ Si₂ 'Éi'₃. ¿'E₂ lë₃ 'niog'₂ 'nia'₂ jŋág'₄ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jaun₂ ca₂ŋag₃ dsa₂: ―'En₅₄ je₂na'₅₄ të₂'au'₂; ¿'ein₂ 'nio₃ jŋɨ'₃ 'ne₂? ");
INSERT INTO cntNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jaun₂ ca₂juá'₂ Jesús: ―Caun₂ léi₄ ca₂jmo₃ jniá₂ jmɨg₄ sa₅₄, jaun₂ ca₂i₃gó'₃ 'au'₂ 'nia'₂ ca₂le₃jɨ́ng'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Jaun₂ në́₃, ca₂jmo₃ Moisés 'éi'₃ a₂ti₃ dsa₂ nɨ₁lo₁, (la₁ia₁ on₃jua'₅₄ Moisés i₂ca₂jme₃lióg₃; dsa₂ can'₅₄ bá₄ ca₂jme₃lióg₃ ma₂lɨ́g'₂). 'Uɨg₅₄ jaun₂ ti'₂ 'nia'₂ nɨ₁lo₄ guein₂, o₁jŋia'₅₄ të₃ lë́₅ jmɨg₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Dse₃ bá₄ jaun₂, chi₂jua'₂ jaun₂ ti'₂ 'nia'₂ nɨ₁lo₄ guein₂ jmɨg₄ sa₅₄ ia₁jaun₂ tsá₃ dsó₃ 'uë₃ 'Éi'₃ quió'₅ Moisés, ¿'e₂ lë₃ 'ne'₂ 'nia'₂ quian'₅₄ jniá₂, ia₁ ca₂jme₁'liong₁₂ jan₂ dsa₂ ta₁jain₂, të₃ jmɨg₄ sa₅₄? ");
INSERT INTO cntNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tsá₃ lë₁cáun₂ 'nia'₂ 'í₁ a₂jŋia'₅₄ con'₂ jniá₂ le₃co'₅₄. Quion₂ bá₄ 'nia'₂ 'í₁ con'₂ dsi₂ten₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jaun₂ në́₃ ca₂jme₃lióg₃ qui₂ca₂ŋag₃ i₂lɨn₅₄ dsa₂ chan₂ Jerusalén qui₂ca₂ŋɨ́i'₃ rɨin'₅₄: ―¿On₁jua'₅₄ i₂në₅ 'na'₂ dsa₂ a₂jŋag'₃ i₂nioi₅₄? ");
INSERT INTO cntNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ó₃ bá₄ guë'₂ 'ein₅₄ dsia₂₃ lia'₂ rë₂jiá₃ jág₁ jɨn₄ dsa₂ juɨn₅, tsá₃ 'ein₂ juá'₂ 'i₁caun₂ quió'₅. ¿O₃ bá₄ dsón'₂ ma₂ca₂rë₃ŋi₅ dsɨ₂tan₅₄, a₂lɨ́n₅ dsa₂ në₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","La₁ ne₄ bá₄ jniog₄ a₂já'₄ já₅ i₂në₅; a₂dsau₅, jë₁ma₂të́₂ rë₁jiá₃ I₂rë₂'ɨ́n₁ quián₅ Diú₄, lia'₂ 'i₁jan₂ tsá₃ le₃ŋi₅ a₂já'₄ já₅. ");
INSERT INTO cntNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jaun₂ lë₃, të₁lia'₂ 'en₅₄ Jesús jme₂tɨin₂₃ dsa₂ i₁dsi₅ guá'₅ templo, jaun₂ ca₂juá'₂ tiá₂: ―¡Cuɨg'₂ bá₄ 'nia'₂ jniá₂, jaun₂ ŋi'₅₄ bá₄ 'nia'₂ 'a₂ guë'₂ guio₃ jniá₂! La₁ on₃jua'₅₄ o₄quió₃ 'ŋió₃ guio₃; të₂le₃ o₄quió'₄ i₂ca₂chei₃ i₂të₃dsón'₂ bá₄ guang₃. I₂'éi₂ guë'₂, tsá₃ cuɨn'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","La₁ia₁ jniá₂ cuɨ́in₅, ia₁ ja₁con₂ 'éi₂ bá₄ guio₃, jaun₂ 'éi₂ bá₄ ca₂chei₃. ");
INSERT INTO cntNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jaun₂ në́₃, jme₁'nio₃ dsa₂ jme₁tsáun'₂; la₁ lia'₂ 'i₁jan₂ tsá₃ ca₂téi₂ gu₂, ia₁ tsá₃ jme₁ma₂të́₂ bá₄ guë́₄ hora quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","La₁ia₁ juɨn₅ dsa₂ 'éi₂ ca₂rë₃'én₂ jág₁ quió'₅, jaun₂ juá'₂: ―Jë₁ma₂të́₂ rë₁jiá₃ I₂rë₂'ɨ́n₁ quián₅ Diú₄, ¿O₃ bá₄ le₃quɨ'₅₄ jmɨg₄ jmo₃ léi₄ a₂juë'₂ guë́₄ lia'₂ con'₂ guë́₄ a₂jmo₅ i₂në₅? ");
INSERT INTO cntNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ca₂nág₂ bá₄ dsa₂ fariseos jág₁ a₂ca₂juá'₂ dsa₂ a₂'ɨin₂₃ Jesús; jaun₂ dsa₂ fariseos 'éi₂ quiain'₅₄ juɨg₅₄ jme₂dsa₂, ca₂chein₃ chi'₂ 'ɨ'₅₄ quián₅ guá'₅ a₂tsáin'₂ Jesús jaun₂ të₂. ");
INSERT INTO cntNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jaun₂ në́₃ ca₂juá'₂ Jesús: ―Me'₂ bá₄ jmɨg₄ 'ú₄ jniá₂ jɨn'₂ 'nia'₂, jaun₂ guë́₄ nég'₄ táng₃ ja₁con₂ i₂ca₂chei₃. ");
INSERT INTO cntNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","'Nau'₅₄ 'nia'₂ jniá₂ i₁niog'₄, la₁ia₁ tsá₃ dsiog'₂ 'nia'₂; ia₁ tsá₃ lé₂ o₁nó'₅ 'nia'₂ ja₁nég'₄. ");
INSERT INTO cntNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jaun₂ në́₃, ca₂jme₃lióg₃ dsa₂ judíos qui₂ca₂ŋɨ́i'₃ rɨin'₅₄: ―¿A₂já'₄ dsɨ₂jiog₅ dsɨ́₅ i₂në₅ dsó₃, a₂tsá₃ dsiain'₂ jniog₄? ¿On₃ bá₄ dsó₃ jɨn₄ dsa₂ go₄ jniog₄ i₂tián'₅ tsɨ₁rë₂jan₅₄ jɨn₄ dsa₂ griegos, ia₁jaun₂ jme₃tɨin₂₃ dsa₂ griegos? ");
INSERT INTO cntNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿'E₂ jein₅ jág₁ a₂në₂juá'₂ në₅: “'Nau'₅₄ 'nia'₂ jniá₂ i₁niog'₄, la₁ia₁ tsá₃ dsiog'₂ 'nia'₂, ia₁ tsá₃ lé₂ o₁nó'₅ 'nia'₂ ja₁nég'₄”? ");
INSERT INTO cntNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jmɨg₄ juë'₂ dé₄ dsón'₂ jë₁ca₂tó'₂ quió'₅ jmɨg₄, ca₂nau₂ Jesús, jaun₂ ca₂juá'₂ tiá₂: ―Në₁jua'₂ 'ein₂ rë₂quein₂ dsɨ́₅, juɨ₁jia₂ ja₁con₂ jniá₂, juɨ₁'en'₅₄ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Juɨ₁lia'₂ juá'₂ Si₂, juɨ₁lia'₂ dsa₂ i₂'én₂ të₂le₃ quió₃ jniá₂, 'iá₃ të₂tsɨ́₅ në₂jag₄ bá₄ jmɨg₂ cuá₃ a₂jén'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","La₁ a₂juá'₂ le₂në₅ a₂'ɨin₂₃ Jme₂dsí₂ Jŋió₅ i₂jme₁ma₂'i₄ 'éi'₃ guen₃ dsa₂ i₂'én₂ të₂le₃ quió'₅; ia₁ tsá₃ jme₁ma₂guan₅ bá₄ guë́₄ Jme₂dsí₂, ia₁ tsá₃ guë́₄ jme₁ma₂ca₂rë₃juɨn'₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","I₂lɨn₅₄ dsa₂ i₂jme₁tion'₅₄ ja₁jaun₂, jme₁ca₂nág₂ a₂juá'₂ Jesús, ca₂juá'₂: ―Dsón'₂ bá₄ i₂në₅ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄ i₂lë́₅ jág₁ jiá₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","I₂lɨn₅₄ guë'₂ juá'₂: ―I₂rë₂'ɨ́n₁ quián₅ Diú₄ bá₄ në₅. La₁ia₁ i₂sián'₂ guë'₂ ca₂juá'₂: ―¿'A₂ bá₄ lia'₂ lé₂ le₃chan₂ Galilea I₂rë₂'ɨ́n₁ quián₅ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Tsa₁ juá'₂ Si₂, tsɨ₁jon₂ Rag₅₄ David bá₄ tion₅₄ lén₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄, jaun₂ jë₄ juɨg₂ Belén bá₄ le₃chain₂, juɨg₂ go₄ David 'ŋiog₅? ");
INSERT INTO cntNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jaun₂ në́₃, le₁dson'₅₄ bá₄ dsa₂ ca₂lë₃ o₄quió'₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jme₁'nio₃ i₂lɨn₅₄ tsáun'₂, la₁ ca₂lia'₂ 'i₁jan₂ tsá₃ 'ein₂ ca₂téi₂ gu₂. ");
INSERT INTO cntNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jaun₂ ca₂dsi₃len₃ táng₃ chi'₂ 'ɨ'₅₄ quián₅ guá'₅ ja₁jme₁tion'₅₄ juɨg₅₄ jme₂dsa₂ quian'₅₄ dsa₂ fariseos, jaun₂ ca₂ŋag₃ 'éi₂ ca₂ŋɨ́i'₃ chi'₂ 'ɨ'₅₄: ―¿'E₂ 'uɨg₅₄ tsá₃ në₂te'₅₄ 'nia'₂ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jaun₂ ca₂ŋag₃ chi'₂ 'ɨ'₅₄: ―¡Lia'₂ 'i₁cón'₂ tsá₃ 'ein₂ dsa₂ ma₂juá'₂ jág₁ juɨ₁lia'₂ juá'₂ dsa₂ 'éi₂! ");
INSERT INTO cntNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jaun₂ në́₃ ca₂juá'₂ dsa₂ fariseos: ―¿O₃ bá₄ ma₂jme₃gau₅ dsa₂ 'éi₂ quián'₂ 'nia'₂ ján₃? ");
INSERT INTO cntNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","'I₁jan₂ dsa₂ can'₅₄ juɨg₅₄ jniog₄, on₃ guë'₂ dsa₂ fariseos, tsá₃ ma₂ca₂rë₃'én₂ le₃quió'₅ 'éi₂, jme₁né₄. ");
INSERT INTO cntNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","La₁ dsa₂ lë₁dsa₂ i₂tion'₅₄ në₅, tsá₃ cuɨ́'₅ Si₂ 'Éi'₃. Ma₂tioin'₅₄ ne₄ jmɨ₁uɨg₅ a₂ma₂rë₂'ë́₂ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jɨn₄ dsa₂ fariseos 'éi₂ jme₁'en₅₄ Nicodemo, i₂jme₁ma₂ŋe₄ i₁jɨin₅₄ Jesús le₂jŋiá₅. 'Éi₂ në́₃ ca₂ŋag₃: ");
INSERT INTO cntNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Juɨ₁lia'₂ con'₂ lë́₅ juá'₂ Si₂ 'Éi'₃ quián₂, ¿lé₂ le₃qui₁dsɨ₅ 'éi'₃ ja₁con₂ jan₂ dsa₂, të₃ tsá₃ ma₂në₂néi₂ jág₁ quió'₅, a₂juá'₂ 'e₂ a₂ma₂jmo₃? ");
INSERT INTO cntNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jaun₂ në́₃ ca₂ŋag₃ rɨin'₅₄: ―¿Ján₃ bá₄ lɨ́n'₅ 'ne₂ jan₂ dsa₂ i₂chan₂ Galilea? 'Í₂ dse₃ ne₄ Si₂, jaun₂ jag'₅₄, lia'₂ 'i₁jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄ tsá₃ já₅ 'uë₃ Galilea. ");
INSERT INTO cntNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jaun₂ guë́₄ i₃len₃ le₂jan₂ le₂jan₂ dsa₂ ja₁quió'₄. ");
INSERT INTO cntNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","La₁ ca₂ŋó₃ bá₄ Jesús juɨ₅ Má'₂ Olivos. ");
INSERT INTO cntNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jme₁jnia₃ jaun₂ táng₃, ca₂guáin'₃ i₁dsi₅ guá'₅ templo. Ja₁jaun₂ ca₂jme₃quián₃ ca₂le₃jɨ́n₃ dsa₂. Jaun₂ ca₂guá₂ Jesús, jaun₂ ca₂jme₃lióg₃ jme₂tɨin₂₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jaun₂ në́₃, ca₂o₃jŋia₃ të₅juá'₅ quian'₅₄ dsa₂ fairseos ca₂o₃jŋiai₃ jan₂ 'io₅₄ i₂ca₂join₃ jme₁'ein₅₄ quian'₅₄ dsa₂ ŋe'₂. Jaun₂ ca₂chei'₃ dsi₂jo₂ jë₄ quió'₅ dsa₂ i₂tion'₅₄ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ Jesús: ―Të₅, ca₂jón₂ 'io₅₄ la₂ nió'₅ jág₁ quian'₅₄ dsa₂ ŋe'₂ on₃jua'₅₄ dsɨ₂i₂gu₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Në₃ në́₃, ne₄ Si₂ 'Éi'₃, juá'₂ Moisés a₂jŋɨ́'₄ jnia'₅₄ jan₂ 'io₅₄ le₂la₂, a₂qui₁dsɨin₅ jnia'₅₄ cang₄. ¿'Ne₂ guë'₂, 'a₂ lia'₂ juá'₂? ");
INSERT INTO cntNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ca₂juá'₂ dsa₂ le₂në₅ ia₁ a₂cáin₂ táu₂ Jesús, ia₁jaun₂ cuɨn₃ jmɨg₄ bóg'₂ dso₄. La₁ ca₂guá₂ Jesús i₁sióg'₅ 'uë₃, jaun₂ ca₂jme₃lióg₃ ca₂jmóg'₃ letras ne₄ 'uë₃ quian'₅₄ nei'₅₄ chi₁gú₃. ");
INSERT INTO cntNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","La₁ caun₂ tioin'₅₄ qui₂ŋag₂₃ qui₂ŋɨ́i'₂ Jesús, jaun₂ ca₂nau₂, ca₂juá'₂ ca₂tsɨ́'₃ dsa₂: ―Chi₂jua'₂ 'ein₂ jan₂ 'nia'₂ i₂tsá₃ dso₄ rë₂cán'₄, o₁tiong₅₄ le₂'uɨg₅₄ ca₂mɨ́g₂ nɨ₁cang₁ juɨ₁qui'₅₄ quió'₅ 'io₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jaun₂ ca₂guá₂ táng₃ i₁sióg'₅ 'uë₃, jmóg'₅ letras a₂tsáng₂ 'uë₃. ");
INSERT INTO cntNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","La₁ jme₁ca₂nág₂ dsa₂ jág₁ a₂ca₂juá'₂ Jesús, jaun₂ ca₂jme₃lióg₃ qui₂ca₂'uɨin₂ bá₄ le₂jain₂ le₂jain₂, jŋiá₅ de'₂ dsa₂ i₂ma₂guen'₂ ca₂'uɨin₂ ne₄ juɨ₅. Jaun₂ jme₁ma₂ca₂'uɨn₂ ca₂le₃jɨ́n₃ dsa₂, 'ŋiog₅ bá₄ Jesús të₁tsɨin'₅₄ quiain'₅₄ 'io₅₄ 'éi₂, i₂chén'₅ dsi₂jo₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jaun₂ në́₃ ca₂nau₂ Jesús, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ 'io₅₄: ―'Io₅₄, ¿na₅ dsa₂? ¿Tsa₁ 'ein₂ në₂'ë́₂ uɨg₅? ");
INSERT INTO cntNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jaun₂ ca₂juá'₂ 'io₅₄: ―Jan₂'ón₄. Lia'₂ 'i₁jan₂ dsa₂, Te₁gui'₅₄. Jaun₂ në́₃ ca₂juá'₂ Jesús: ―On₃ guë'₂ jniá₂ 'ë́₄ uɨg₅ quiáng'₂; guan'₂ në́₃, la₁ tsá₃ ma₃lë₁'nau₂ dso₄. ");
INSERT INTO cntNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ca₂juá'₂ táng₃ Jesús tsɨ́'₅ dsa₂, a₂juá'₂: ―Jniá₂ lɨ́ng₅ si₂ i₂jmo₅ tág₅ juɨ₅ quió'₅ dsa₂ mɨ₂güɨ́g₃; juɨ₁lia'₂ i₂'ein₅ jniá₂, lia'₂ o₁lɨ́g'₂ tsá₃ ma₃ŋɨ₃ jë₄ qui₁né'₃, ton'₂ qui₃'io₃ si₂ a₂jmo₅ a₂chain₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jaun₂ në́₃ ca₂juá'₂ dsa₂ fariseos ca₂tsɨ́'₃ Jesús: ―'Ne₂ jáng'₂ jág₁ dsau₅ të₂le₃ quián'₂ 'ŋiag'₂; 'uɨg₅₄ jaun₂ tsá₃ quen₅ jág₁ quiáng'₂ a₂jáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jaun₂ ca₂ŋag₃ Jesús ca₂tsɨ́'₃ dsa₂: ―Juɨ₁lia'₂ a₂juá'₅ jniá₂, quen₅ bá₄, o₁jŋia'₅₄ 'ŋió₃ jniá₂ jáng'₅ jág₁ dsau₅ të₂le₃ quió₃ 'ŋió₃. Ia₁ guion₄ bá₄ jniá₂ a₂já'₄ guio₃, a₂já'₄ nég'₄ në́₃; la₁ia₁ 'nia'₂ në́₃, tsá₃ ŋi'₅₄ 'nia'₂ a₂já'₄ guio₃, on₃ guë'₂ a₂já'₄ nég'₄. ");
INSERT INTO cntNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'Nia'₂ guë'₂ cáun'₂ 'í₁ lia'₂ con'₂ lë́₅ 'éi'₃ quió'₅ dsa₂ mɨ₂güɨ́g₃. Jniá₂ në́₃ tsá₃ 'í₁ cáun₅ jniá₂ jua'₅₄ a₂qui₂dsɨ́₂ 'éi'₃ ja₁con₂ 'i₁jan₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","La₁ia₁ chi₂jua'₂ cáun₅ jniá₂ 'í₁, dse₃ dsi₂ten₅₄ bá₄ 'éi'₃ a₂qui₂dsɨ́₂ jniá₂, ia₁ on₃jua'₅₄ jniá₂ 'ŋió₃ cáun₅ 'í₁; qui₂dsɨ́₂ jniá₂ 'éi'₃ co₂lë₅ quiang'₅₄ i₂ca₂chei₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ján₃ bá₄ ca₂të₂ ne₄ Si₂ 'Éi'₃ quián'₂ 'nia'₂, rë₂ton₅ juá'₂, në₁jua'₂ on₃ dsa₂ lë́₂ i₂jáng'₅ jág₁ dsau₅, a₂quen₅ bá₄ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jniá₂ lɨ́ng₅ i₂jáng'₅ jág₁ dsau₅ të₂le₃ quió₃ 'ŋió₃; Ŋe'₃ jniá₂ i₂ca₂chei₃ guë'₂, lɨ́n₅ táng₃ jan₂ i₂jáng'₅ jág₁ dsau₅. ");
INSERT INTO cntNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jaun₂ në́₃ ca₂ŋag₃ dsa₂ fariseos ca₂ŋɨ́i'₃ Jesús: ―¿Na₅ ŋéi'₅ 'ne₂? Jaun₂ ca₂ŋag₃ Jesús: ―Tsá₃ cuɨg'₂ 'nia'₂ jniá₂, on₃ guë'₂ Ŋe'₃ jniá₂ cuɨn'₂ 'nia'₂; jua'₅₄ mei'₂ guë́₃ cuɨg'₂ 'nia'₂ jniá₂, ján₃ bá₄ jme₁le₃cuɨn'₂ 'nia'₂ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ca₂juá'₂ Jesús le₂në₅ të₁lia'₂ jme₁'ein₅₄ jme₂tɨin₂₃ dsa₂ i₁dsi₅ guá'₅ templo, cau₅ ja₁jme₁tióng₂ tsɨ₁gu₅ quió'₅ cu₄ guá'₅. La₁ia₁, lia'₂ 'i₁jan₂ tsá₃ 'ein₂ ca₂jŋau'₃, ia₁ tsá₃ jme₁ma₂të́₂ bá₄ guë́₄ hora quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Con'₂ siá'₂ táng₃ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂: ―Né'₄ jniá₂; jaun₂ 'nia'₂ guë'₂, 'náu'₂ jniá₂ i₁niog'₄, la₁ia₁ dsián'₃ 'nia'₂ të₃ rë₂cán'₄ 'nia'₂ dsáu'₂; ja₁né'₄ jniá₂, tsá₃ lé₂ o₁nó'₅ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jaun₂ në́₃ ca₂juá'₂ dsa₂ judíos: ―¿O₃ bá₄ a₂jŋɨi'₃ 'e₂ 'ŋiog₅, jaun₂ guë'₂ juá'₂ tsá₃ lé₂ dsɨ₁náu₄ jniog₄ ja₁dsáin'₃? ");
INSERT INTO cntNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jaun₂ ca₂juá'₂ Jesús: ―Dsa₂ chan₂ gua'₅₄ 'uë₃ la₂ bá₄ lɨ́n'₅ 'nia'₂; jniá₂ në́₃, lɨ́ng₅ i₂chan₂ guei'₅₄. Dsa₂ i₂tén₅ mɨ₂güɨ́g₃ la₂ bá₄ lɨ́n'₅ 'nia'₂; jniá₂ në́₃ tsá₃ téng₅ mɨ₂güɨ́g₃ la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","'Uɨg₅₄ jaun₂ bá₄ në₂juɨ́g₂ jniá₂ 'nia'₂ a₂dsiáng'₃ të₃ rë₂cáng'₄ jaun₂ dsáu'₂. Ia₁ chi₂jua'₂ tsá₃ 'én'₂ 'nia'₂, jniá₂ bá₄ lɨ́ng₅ 'éi₂, dsiáng'₃ 'nia'₂ qui₂rë₂cáng'₄ dsáu'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jaun₂ në́₃ ca₂ŋag₃ dsa₂ judíos ca₂ŋɨ́i'₃ Jesús: ―¿'Ein₂ bá₄ lɨ́n'₅ 'ne₂? Jaun₂ ca₂ŋag₃ Jesús: ―Le₂jaun₂ juɨ₁lia'₂ ma₂qui₂ma₂juɨ́g₂ jniá₂ 'nia'₂ ca₃le₂'uɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'Lióng₂ bá₄ 'uɨg₅₄ cha₂ a₂le₃juá'₄ jniá₂ a₂qui₁dsɨ₅ jniá₂ 'éi'₃ ja₁con'₂ 'nia'₂. La₁ tí₅ bá₄ jág₁ quió'₅ i₂ca₂chei₃. Jaun₂ jniá₂ në́₃, jág₁ a₂ma₂nag₃ ja₁coin₂, a₂jaun₂ bá₄ juɨ́g₂ jniá₂ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","La₁ tsá₃ ca₂rë₃ŋɨ́'₂ dsa₂, a₂jme₁juá'₂ Jesús tsɨ́'₅ dsa₂ 'éi₂, a₂'ɨin₂₃ Jmei₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","'Uɨg₅₄ jaun₂ ca₂juá'₂ Jesús: ―Jë₁ma₂të́₂ rë₁chóng'₄ 'nia'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃, jaun₂ guë́₄ le₃ŋi'₅₄ 'nia'₂ a₂lɨ́n₅ jniá₂ 'éi₂; le₃ŋi'₅₄ 'nia'₂, a₂tsá₃ jmo₅ jniá₂ 'i₁caun₂ të₂le₃ o₄quió₃ 'ŋio₃, jŋia'₅₄ lia'₂ a₂jaun₂ bá₄ juá'₅ jniá₂ juɨ₁lia'₂ a₂ma₂ca₂jme₃tag₅ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ia₁ i₂ca₂chei₃ 'ein₅₄ quian'₅₄ jniá₂, tsá₃ jua'₅₄ ma₂téin₂ jniá₂ 'ŋió₃, ia₁ lia'₂ co₂tan₅₄ bá₄ jmo₅ jniá₂ a₂'ŋio₂ dsɨ́₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Lia'₂ jme₁juá'₂ Jesús jág₁ në₅, juɨn₅ lɨn₃ dsa₂ ca₂rë₃'én₂ le₃quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jaun₂ në́₃ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂ judíos i₂ca₂rë₃'én₂ le₃quió'₅: ―Në₁jua'₂ të₁'ŋiá'₄ 'nia'₂ le₃quió'₅ jág₁ quió₃, dsón'₂ bá₄ lɨ́n'₅ 'nia'₂ dsa₂ i₂quian'₅₄ jniá₂; ");
INSERT INTO cntNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","jaun₂ le₃cuɨn'₂ 'nia'₂ jág₁ dsau₅, jaun₂ jág₁ dsau₅ në́₃, jmo₃ qui₃chen'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂ ca₂tsɨ́'₃ Jesús: ―Lág₅ jnia'₅₄ dsa₂ tsɨ₁jon₂ Abraham, jaun₂ lia'₂ 'i₁cón'₂ tsá₃ ma₂lag₃ jnia'₅₄ dsa₂ i₂le₁'ŋe'₅₄ ne₄ 'i₁jan₂. ¿'A₂ guë'₂ lia'₂ juá'₂ 'ne₂ jaun₂ a₂qui₃chei'₂ jnia'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jaun₂ ca₂juá'₂ Jesús: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, juɨ₁lia'₂ ca₂le₃jɨ́n₃ dsa₂ i₂'no₅ dso₄, qui₂le₁'ŋei'₅₄ ne₄ dsáu₁. ");
INSERT INTO cntNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Juɨ₁lia'₂ jan₂ dsa₂ i₂chi₁'ŋe'₅₄ në́₃, tsá₃ jua'₅₄ të₃'ŋiái₄ co₂tan₅₄ dsi₂néi₂ quió'₅ juɨg₅₄; la₁ia₁ chi'₂ ja₁ŋi'₅₄ në́₃, co₂tan₅₄ bá₄ téin₅ dsi₂néi₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jaun₂ në́₃, chi₂jua'₂ ca₂chéi'₂ Ja₁ŋi'₅₄ ca₂chéin'₂ 'nia'₂, jaun₂ bá₄ lén'₂ 'nia'₂ dsa₂ i₂le₁tsɨn'₁ të₃dsón'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ma₂guion₄ bá₄ jniá₂ jaun₂ a₂lɨ́n'₅ 'nia'₂ tsɨ₁jon₂ Abraham; la₁ia₁ 'niog'₂ 'nia'₂ jŋág'₄ jniá₂, ia₁ a₂tsá₃ guei'₂ 'nia'₂ 'e₂ a₂juá'₅ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Jniá₂ në́₃ juá'₅ juɨ́g₂ 'nia'₂ juɨ₁lia'₂ 'e₂ a₂ma₂jág₃ ja₁con₂ Ŋe'₃; 'nia'₂ në́₃, jmo'₂ 'e₂ a₂ma₂nei'₂ 'nia'₂ ja₁con₂ ŋéi'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂ ca₂tsɨ́'₃ Jesús: ―Abraham bá₄ jme₁lɨ́n₄ jmei₂ jnia'₅₄ ma₂lɨ́g'₂. La₁ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂ 'éi₂: ―Jua'₅₄ mei'₂ guë́₃ lɨ́n'₅ 'nia'₂ chi'₂-guein₂ quián₅ Abraham, jaun₂ jme₁jmó'₂ 'nia'₂ juɨ₁lia'₂ a₂ca₂jmo₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","La₁ia₁ 'nia'₂ në́₃ 'niog'₂ jŋág'₄ jniá₂, o₁jŋia'₅₄ ma₂në₂juɨ́g₂ jniá₂ 'nia'₂ jág₁ tí₅ të₃dsón'₂ a₂ma₂ca₂jme₃tag₅ Diú₄ jniá₂. Tsá₃ le₂në₅ ca₂jmo₃ Abraham. ");
INSERT INTO cntNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","'Nia'₂ në́₃, le₂jaun₂ bá₄ jmo'₂ juɨ₁lia'₂ jmo₅ ŋéi'₅. Jaun₂ në́₃ ca₂juá'₂ dsa₂ 'éi₂: ―La₁ on₃jua'₅₄ jnia'₅₄ lág₅ guein₂ i₂lë₁chan₂; jan₂ bá₄ jmei₂ jnia'₅₄ chan₂: i₂'éi₂ lɨ́n₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jaun₂ në́₃ ca₂juá'₂ Jesús: ―Jua'₅₄ mei'₂ guë́₃ të₃dsón'₂ Diú₄ lɨ́n₅ ŋéi'₅ 'nia'₂, jme₁jme₁'nió'₄ bá₄ 'nia'₂ jniá₂, ia₁ ja₁con₂ Diú₄ bá₄ 'uɨ́n₂ jniá₂; jaun₂ la₂ ma₂guio₃. On₃jua'₅₄ o₄quió₃ 'ŋió₃ guio₃; o₄quió'₄ i₂ca₂chei₃ bá₄ jniá₂ guio₃. ");
INSERT INTO cntNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿'E₂ lë₃ tsá₃ lé₂ le₃ŋɨ́'₂ 'nia'₂ jág₁ a₂juá'₅ jniá₂? 'Uɨg₅₄ ia₁ a₂tsá₃ tian'₃ 'nia'₂ nág'₁ jág₁ a₂'ë́₅ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","'Nia'₂ bá₄ rë'₂ téng'₅ le₃quió'₅ i₂së₃dsen₃ ŋéi'₅ 'nia'₂. Jaun₂ 'ɨ́n₅ 'au'₂ jmó'₂ 'e₂ a₂'ŋio₂ dsɨ́₅ 'éi₂. Lia'₂ con'₂ le₂'uɨg₅₄ bá₄ jaun₂ lɨ́in₅ jan₂ i₂jme₂dsian₅ dsa₂. Tsá₃ le₃quió'₅ jág₁ dsau₅ chéin'₅, ia₁ 'i₁ca₂mɨ́g₂ jág₁ dsau₅ tsá₃ cha₂ ja₁coin₂. Jë₁ma₂ca₂juá'₂ jág₁ të₂jág₁, juá'₂ bá₄ juɨ₁lia'₂ tɨin₂ 'ŋiog₅, ia₁ i₂të₂jɨ́n₁ bá₄ 'éi₂, jaun₂ lɨ́in₅ jmei₂ dsa₂ të₂jɨ́n₁. ");
INSERT INTO cntNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","La₁ia₁, 'uɨg₅₄ ia₁ a₂juá'₅ jniá₂ jág₁ dsau₅ në́₃, tsá₃ 'éng'₂ jág₁ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿I₂'ein₂ 'nia'₂ quɨ'₅₄ jmɨg₄ cáun₂ 'í₁ a₂rɨn₂ jniá₂ dso₄? Chi₂jua'₂ juá'₅ jniá₂ jág₁ dsau₅, ¿'E₂ lë₃ tsá₃ 'én'₂ 'nia'₂ jág₁ quió₃? ");
INSERT INTO cntNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Juɨ₁lia'₂ i₂tén₅ le₃quió'₅ Diú₄, nag₂₃ jág₁ quió'₅ Diú₄. 'Uɨg₅₄ jaun₂ bá₄ tsá₃ nag'₂ 'nia'₂ jág₁: ia₁ tsá₃ tén'₅ 'nia'₂ le₃quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jaun₂ në́₃ ca₂ŋag₃ dsa₂ judíos ca₂ŋɨ́i'₃ Jesús: ―¿Tsa₁ dsau₅ jág₁ a₂jua'₂ jnia'₅₄, dsa₂ chan₂ Samaria bá₄ lɨ́n'₅ 'ne₂; a₂'en₅₄ jan₂ je₂na'₅₄ të₂'au'₂ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jaun₂ ca₂ŋag₃ Jesús: ―Lia'₂ 'i₁jan₂ je₂na'₅₄ tsá₃ 'en₅₄ të₂dsɨ₃. A₂jaun₂ bá₄ jmo₅ jniá₂ a₂jme₂juɨ́n'₁ jniá₂ Ŋe'₃; 'nia'₂ guë'₂, tsá₃ jme₂go'₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tsá₃ a₂jaun₂ 'náu'₅ jniá₂ a₂jme₃juag'₂ dsa₂, la₁ chan₂ jan₂ i₂'no'₂ a₂jme₃juag'₂ dsa₂ jniá₂, ton'₂ 'éi₂ bá₄ con₂ jág₁ dsau₅. ");
INSERT INTO cntNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, chi₂jua'₂ 'ein₂ dsa₂ i₂tón'₂ juɨ₅ jág₁ quió₃, lia'₂ o₁lɨ́g'₂ jmɨg₄ tsá₃ dsɨ₃ŋɨi₅₄ 'mú₃. ");
INSERT INTO cntNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jaun₂ në́₃ ca₂ŋag₃ dsa₂ judíos: ―Në₃ guë́₄ dsón'₂ jag₂ jnia'₅₄ a₂'en₅₄ jan₂ je₂na'₅₄ të₂'au'₂. Ia₁ ma₂ca₂jon₃ Abraham lia'₂ jma₃quian'₅₄ dsa₂ i₂qui₂ca₂'ë́₂ jág₁ quián₅ Diú₄; 'ne₂ guë'₂ juá'₂: “Juɨ₁lia'₂ i₂tón'₂ juɨ₅ jág₁ quió₃, tsá₃ lɨ́g'₂ dsɨ₃ŋɨi₅₄ 'mú₃.” ");
INSERT INTO cntNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿O₃ bá₄ 'ŋio₅ lɨn₃ guë́₄ juɨn'₂ 'ne₂ lia'₂ con'₂ guë́₄ Abraham 'lag₄ jmei₂ jnia'₅₄? Ca₂jon₃ bá₄ 'éi₂, ján₃ bá₄ le₂jaun₂ qui₂ca₂dsan₃ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄. ¿'Ein₂ lɨ́n'₂ 'ne₂ lɨ́ng'₅? ");
INSERT INTO cntNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jaun₂ ca₂ŋag₃ Jesús: ―Chi₂jua'₂ 'ŋió₃ jniá₂ jme₂juɨ́ng'₂, tsá₃ 'e₂ quen₅ a₂jaun₂. La₁ia₁ juɨ₁lia'₂ i₂jme₂juag'₂ jniá₂, Ŋe'₃ bá₄ jniá₂ 'éi₂, i₂'ɨ́n'₅ 'nia'₂ lɨ́n₅ Diú₄ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","O₁jŋia'₅₄ tsá₃ cuɨn'₂ 'nia'₂ 'éi₂, la₁ cuɨ́n₅ bá₄ jniá₂ 'éi₂. Jua'₅₄ mei'₂ guë́₃ juá'₅ jniá₂ a₂tsá₃ cuɨ́in₅, jme₁lén₂ jniá₂ jan₂ i₂të₂jɨ́n₁ juɨ₁lia'₂ lɨ́n'₅ 'nia'₂. La₁ia₁ dsón'₂ bá₄ cuɨ́n₅ jniá₂ 'éi₂, jaun₂ tón'₅ bá₄ jniá₂ juɨ₅ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ca₂jmo₃ 'io'₂ Abraham, 'lag₄ ŋéi'₅ 'nia'₂, ia₁ jme₁'ɨ́n₂ dsɨ́₅ jág₃ jmɨg₄ i₁guan₃ jniá₂; jaun₂ ca₂jág₃, jaun₂ 'ŋio₅ lɨn₃ 'io'₂ ca₂jén'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jaun₂ në́₃ ca₂juá'₂ dsa₂ judíos ca₂tsɨ́'₃ Jesús: ―Tsá₃ ma₂'eng'₅₄ bá₄ guë́₄ të₂láu₃-guiá₂ ŋi₂. ¿'A₂ guë'₂ lia'₂ juá'₂ 'ne₂ a₂ma₂jɨng'₅₄ 'lag₄ Abraham? ");
INSERT INTO cntNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jaun₂ ca₂ŋag₃ Jesús: ―A₂dsɨ₂jó'₃ juɨg₂ jniá₂ 'nia'₂, né'₃ guë́₄ a₂le₃chan₂ Abraham, jniá₂ lɨ́ng₅. ");
INSERT INTO cntNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jaun₂ në́₃ qui₂ca₂jŋa'₃ cang₄ a₂jme₁qui'₃ quió'₅. La₁ ca₂'ma₃ bá₄ Jesús, jaun₂ o₂'ɨ́in₃ i₁dsi₅ guá'₅ templo. ");
INSERT INTO cntNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jme₁ca₂ŋɨi₅ jaun₂, ca₂jɨ́in₂ jan₂ dsa₂ i₂ten₄ ca₂rë₃chán₃. ");
INSERT INTO cntNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jaun₂ ca₂ŋag₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Të₅, ¿'ein₂ bá₄ ca₂'náu₂ dso₄? ¿Dsa₂ la₂, o₃ chog₅₄-jmei₂ 'e₂, a₂ca₂rë₃cháin₃ tein₅₄? ");
INSERT INTO cntNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jaun₂ ca₂juá'₂ Jesús: ―On₃jua'₅₄ 'uɨg₅₄ dsáu₂ 'ŋiog₅, on₃ guë'₂ 'uɨg₅₄ dsáu₁ chog₅₄-jmei₂; a₂jaun₂ bá₄ ca₂lë₃ ia₁jaun₂ le₃jniá₂ juɨ₅bí₂ quió'₅ Diú₄ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ca₂tág₂ jniog₄ jmó₁ ta₁ quió'₅ i₂ca₂chei₃ jniá₂ të₁lia'₂ jniá₂ guë́₄; ia₁ ma₂ja₂quián₃ néi₃, jë₁tsá₃ ma₃'ein₂ lé₂ le₃jmo₃ ta₁. ");
INSERT INTO cntNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Të₁lia'₂ 'en₅₄ jniá₂ mɨ₂güɨ́g₃ la₂, lɨ́ng₅ si₂ a₂tág₅ ja₁con₂ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jme₁ca₂dsan₃ juá'₂ le₂në₅, jaun₂ ca₂'ŋéi₃ 'uë₃, ca₂jmo₃ ca₂juɨg₄ jein₂ quian'₅₄ jmɨ₁'ë́'₅ quió'₅, jaun₂ ca₂tsáng₂ jme₁ne₁ dsa₂ ten₄. ");
INSERT INTO cntNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂ 'éi₂: ―Gua₂ o₂rang₂ quiáng'₂ Dsiog₅ Siloé ―co₂'nió'₄ le₃jua'₅₄ jág₁, I₂chen₄, a₂chei₂ dsiog₅ jaun₂. Jaun₂ ca₂ŋó₃ i₁rang₂ quió'₅, jaun₂ jme₁guáin'₃ táng₃ jaun₂, ma₂jág₅ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jaun₂ qui₂ca₂ŋag₃ dsa₂ i₂tián'₅ cau₅ quió'₅, quian'₅₄ dsa₂ i₂jme₁ma₂ca₂jág₂ mɨ₅ 'éi₂ cu₄ le₂jŋiá₅, ca₂juá'₂: ―¿On₁jua'₅₄ dsa₂ në₅ 'éi₂ i₂jme₁gua₂ mɨ₅ a₂jme₃'o₅₄ dsa₂ cu₄? ");
INSERT INTO cntNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","I₂lɨn₅₄ juá'₂: ―'Éi₂ bá₄ në₅. I₂sián'₂ guë'₂ juá'₂: ―On₃jua'₅₄ 'éi₂ në₅, la₁ia₁ mei'₂ tsá₃ le₂jaun₂ jniái₂. La₁ ca₂juá'₂ dsa₂ 'éi₂ 'ŋiog₅: ―Jniá₂ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jaun₂ në́₃ ca₂ŋag₃ dsa₂ ca₂ŋɨ́i'₃ 'éi₂: ―¿'A₂ guë'₂ lia'₂ lë₃ ca₂jnióg₃ jme₁ne'₄ 'ne₂? ");
INSERT INTO cntNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂: ―Dsa₂ i₂të́'₂ dsa₂ Jesús në₂jmo₃ ti₁jéin₃, jaun₂ në₂tsáng₂ jme₁ne₃ jniá₂, jaun₂ në₂juá'₂ tság₅ jniá₂: “Gua₂ Dsiog₅ Siloé, o₂rang₂ quiáng'₂.” Jaun₂ ŋe₄ jniá₂, jaun₂ jme₁ca₂lë₃ rang₂₃ quió₃, co₂tan₅₄ lia'₂ në₂jág₃. ");
INSERT INTO cntNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jaun₂ ca₂ŋag₃ dsa₂ ca₂ŋɨ́i'₃ dsa₂ i₂jme₁ten₄ 'éi₂: ―¿Na₅ dsa₂ 'éi₂? Jaun₂ ca₂juá'₂: ―Tsá₃ guion₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jaun₂ në́₃ ca₂i₁jŋia₃ dsa₂ ne₄ dsa₂ fariseos dsa₂ i₂jme₁ten₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","La₁ jmɨg₄ lia'₂ con'₂ jme₁ca₂jmo₃ Jesús ti₁jéin₃ a₂ca₂tsáng₂ mɨ₂ne₄ dsa₂ i₂jme₁ten₄ 'éi₂, jaun₂ dé₄ jmɨg₄ sa₅₄ bá₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jaun₂ ca₂ŋag₃ táng₃ dsa₂ fariseos ca₂ŋɨ́i'₃ dsa₂ 'éi₂, 'a₂ bá₄ lia'₂ jaun₂ ma₂lé₂ jág₃. Jaun₂ ca₂juá'₂ dsa₂ i₂jme₁ten₄ 'éi₂: ―Në₂tsáng₂ ti₁jéin₃ jme₁ne₃ jniá₂, jaun₂ në₂rang₃ jniá₂ quió₃, jaun₂ lë₃ ma₂jág₅ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jaun₂ në́₃ ca₂juá'₂ i₂lɨn₅₄ dsa₂ fariseos: ―Dsa₂ i₂në₂jmo₃ a₂në₅, on₃jua'₅₄ dsa₂ quián₅ Diú₄ 'éi₂, ia₁ tsá₃ jme₂gó'₃ jmɨg₄ sa₅₄. La₁ i₂lɨn₅₄ guë'₂ juá'₂: ―¿'A₂ lia'₂ lé₂ le₃jmo₃ jan₂ dsa₂ i₂cha₂ dsáu₁ léi₄ juë'₂ le₂në₅? Jaun₂ lë₃ ca₂lë₃ le₁dson'₅₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jaun₂ ca₂ŋag₃ táng₃ dsa₂ ca₂ŋɨ́i'₃ dsa₂ i₂jme₁ten₄ 'éi₂: ―¿'E₂ guë'₂ juá'₂ 'ne₂ lɨ́in₅, ia₁ jme₁ne'₄ 'ne₂ bá₄ në₂niá₃? Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂: ―A₂lɨ́in₅ jan₂ dsa₂ i₂'ë́₂ jág₁ quián₅ Diú₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","La₁ dsa₂ judíos në́₃, tsá₃ jme₁'éin₂ bá₄ guë́₄ a₂dsón'₂ jme₁ten₄ dsa₂ 'éi₂, ton'₂ ca₂tɨ́in'₃ jme₁ne₁₂, ca₂lia'₂ ca₂të́'₃ chog₅₄-jmei₂ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jaun₂ ca₂ŋag₃ dsa₂ fariseos ca₂ŋɨ́i'₃ chog₅₄-jmei₂ 'éi₂: ―¿Chi'₂ ja₂ŋí'₂ 'nia'₂ la₂, i₂juá'₂ 'nia'₂ i₂ten₄ ca₂rë₃chán₃? ¿'A₂ guë'₂ lia'₂ ma₂jág₅ në₃? ");
INSERT INTO cntNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jaun₂ ca₂ŋag₃ chog₅₄-jmei₂: ―Ne₄ bá₄ jnia'₅₄, chi'₂ quián₂ bá₄ jnia'₅₄ në₅, i₂ca₂rë₃chán₃ ten₄; ");
INSERT INTO cntNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","la₁ tsá₃ ne₄ jnia'₅₄ 'a₂ guë'₂ lia'₂ në₃ ma₂lé₂ jág₃, on₃ guë'₂ ne₄ jnia'₅₄ 'ein₂ ca₂jmo₃ ca₂jŋia₃ mɨ₂ne₅₄. Ŋag₄ caun₂ 'nia'₂ guiong'₅₄; i₂ma₂juɨn'₂ bá₄ në₅, jaun₂ lé₂ bá₄ juá'₂ 'ŋiog₅ 'a₂ lia'₂ ca₂lë₃. ");
INSERT INTO cntNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ca₂juá'₂ chog₅₄-jmei₂ le₂në₅ 'uɨg₅₄ ia₁ a₂gó'₅ gain₃ dsa₂ judíos, ia₁ jme₁ma₂ca₂jmo₃ 'éi₂ caun₂ jág₁ a₂'uág'₂ 'uɨ́in'₂ dsa₂ ja₁le₁toin₂₃ ne₄ si₂ guá'₅ sinagoga juɨ₁'ein₂ guë́₃ i₂juá'₂, Jesús bá₄ lɨ́n₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","'Uɨg₅₄ jaun₂ bá₄ ca₂juá'₂ chog₅₄-jmei₂: “Ŋag₄ caun₂ 'nia'₂ guiong'₅₄, i₂ma₂juɨn'₂ bá₄ në₅.” ");
INSERT INTO cntNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jaun₂ bá₄ ca₂të₃ táng₃ dsa₂ judíos ca₂të́'₃ dsa₂ i₂jme₁ten₄ 'éi₂, jë₁ca₂të́₂ táng₃ ráun₂, jaun₂ ca₂juá'₂: ―Jua'₅₄ jág₁ dsau₅ të₃dsón'₂ ne₄ Diú₄; ne₄ bá₄ jnia'₅₄ jan₂ dsa₂ i₂cha₂ dsáu₁ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jaun₂ në́₃ ca₂ŋag₃ dsa₂ 'éi₂: ―Tsá₃ a₂jaun₂ guion₄ jniá₂ jua'₅₄ jan₂ dsa₂ cha₂ dsáu₁ 'éi₂, o₃ tsá₃ dsáu₁ cha₂ 'e₂. Jŋia'₅₄ lia'₂ a₂jaun₂ bá₄ guion₅₄, a₂jme₁ten₄ bá₄ jniá₂, la₁ në₃ ma₂lé₂ bá₄ jág₄. ");
INSERT INTO cntNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jaun₂ ca₂ŋag₃ táng₃ dsa₂ fariseos: ―¿'E₂ ca₂jmo₃ quiáng'₂? ¿'A₂ lia'₂ ca₂jmo₃ dsa₂ 'éi₂ a₂ca₂jnia₃ mɨ₂ne'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂: ―Ma₂në₂juá'₃ guë'₂ jniá₂. Tsá₃ tón'₂ guë'₂ 'nia'₂ juɨ₅ 'e₂ juá'₅ jniá₂. ¿'E₂ lë₃ 'niog'₂ 'nia'₂ nág'₂ táng₃? ¿O₃ bá₄ ján₃ guë'₂ 'niog'₂ 'nia'₂ le₃'éng'₂ le₃quió'₅ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jaun₂ qui₂ca₂jnáu'₂ dsa₂ jág₁ uɨg₅, jaun₂ ca₂juá'₂: ―'Ne₂ 'éng'₂ le₃quió'₅ dsa₂ 'éi₂, la₁ia₁ jnia'₅₄ guë'₂ 'éin₂ le₃quió'₅ Moisés. ");
INSERT INTO cntNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ne₄ jnia'₅₄, a₂ca₂dsia₃ Diú₄ jág₁ quian'₅₄ Moisés, la₁ dsa₂ 'éi₂ guë'₂ në́₃, tsá₃ ne₄ a₂já'₄ já₅. ");
INSERT INTO cntNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂ në́₃ ca₂juá'₂: ―¡Dsón'₂ bá₄ jaun₂ dsɨ₂gó'₃ dsɨ₅ a₂jaun₂: a₂tsá₃ ŋi'₅₄ 'nia'₂ a₂já'₄ já₅, ton'₂ ca₂jme₃jnio₅₄ jme₁ne₃! ");
INSERT INTO cntNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ma₂ne₄ rë₂ bá₄ jniog₄ jaun₂, a₂tsá₃ nag₅ Diú₄ jág₁ quió'₅ dsa₂ i₂cha₂ dsáu₁; jmá'₃ lia'₂ jág₁ quió'₅ dsa₂ i₂jme₂gan₃ Diú₄, i₂qui₂jmo₅ a₂'ŋio₂ dsɨ́₅ 'éi₂: quió'₅ 'éi₂ bá₄ nag₂₃. ");
INSERT INTO cntNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Lia'₂ 'i₁cón'₂ tsá₃ 'ein₂ ma₂nág₂ ca₂le₂jŋiá₅ jua'₅₄ chan₂ dsa₂ i₂lé₂ le₃jme₃'lión₂ jan₂ dsa₂ i₂ten₄ ca₂rë₃chán₃. ");
INSERT INTO cntNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Jua'₅₄ mei'₂ guë́₃ tsá₃ já₅ dsa₂ 'éi₂ ja₁con₂ Diú₄, tsá₃ 'e₂ lé₂ jme₁jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jaun₂ në́₃ ca₂ŋag₃ dsa₂ fariseos: ―Co₂ŋei'₅₄ bá₄ ne₄ dsáu'₂ ca₂rë₃cháng'₃. ¿I₂'ein₂ bá₄ lɨ́n'₅ 'ne₂ jaun₂ jme₁tag'₅ jnia'₅₄? Jaun₂ ca₂dsei₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jaun₂ ca₂rë₃ŋi₅ Jesús jág₁ a₂ca₂dsen₅ dsa₂ ca₂dsein₂₃ dsa₂ i₂jme₁ten₄ 'éi₂. Jaun₂ jme₁ca₂jein'₂, ca₂juá'₂: ―¿'Én'₂ 'ne₂ të₂le₃ quió'₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃? ");
INSERT INTO cntNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jaun₂ ca₂juá'₂ dsa₂ 'éi₂: ―Gui'₅₄, ¿i₂'ein₂ bá₄ 'éi₂, ia₁jaun₂ lé₂ le₃'én₂ jniá₂ le₃quió'₅? ");
INSERT INTO cntNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jaun₂ ca₂ŋag₃ Jesús: ―Ma₂në₂jɨin'₅₄ bá₄, jaun₂ jniá₂ bá₄ 'éi₂ i₂dsia'₂ jág₁ quiang'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jaun₂ bá₄ ca₂chi₃jné₃ dsa₂ 'éi₂ ne₄ Jesús, jaun₂ ca₂juá'₂: ―'Én₂ bá₄ jniá₂, Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jaun₂ ca₂juá'₂ Jesús: ―A₂qui₁dsɨ₅ 'éi'₃ bá₄ jniá₂ guio₃ mɨ₂güɨ́g₃ la₂, ia₁jaun₂ jág₃ juɨ₁lia'₂ dsa₂ ten₄, ton'₂ ia₁jaun₂ le₃ten₄ juɨ₁lia'₂ dsa₂ i₂jág₅. ");
INSERT INTO cntNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jaun₂ qui₂ca₂nág₂ jág₁ jaun₂ i₂lɨn₅₄ dsa₂ fariseos i₂jme₁tion'₅₄ quian'₅₄ Jesús, jaun₂ ca₂ŋag₃: ―¿O₃ bá₄ dsa₂ ten₄ lág₅ jnia'₅₄ ján₃? ");
INSERT INTO cntNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jaun₂ ca₂ŋag₃ Jesús: ―Jua'₅₄ mei'₂ guë́₃ lɨ́n'₅ 'nia'₂ dsa₂ ten₄, tsá₃ dso₄ jme₁qui₂le₃cán'₂ 'nia'₂. La₁ia₁, 'uɨg₅₄ ia₁ a₂juá'₂ 'nia'₂, “ne₄ jnia'₅₄”, jaun₂ të₂'ŋiá₄ dsáu'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","'A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, juɨ₁lia'₂ i₂tsá₃ tón'₅ të₂le₃ juɨ₅ o₄'né₄ tsɨ₁jnɨ́₂ ja₁tion'₅₄ já'₂ cha'₂, a₂uɨ́g₂ juɨ₅ siá'₂, dsa₂ 'ang₂ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","La₁ia₁ juɨ₁lia'₂ i₂'í₂ të₂le₃ o₄'né₄, dsa₂ i₂jmo₅ 'í₁ já'₂ cha'₂ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","O₄quió'₄ 'éi₂ bá₄ niá₅ dsa₂ i₂jmo₅ 'í₁ o₄'né₄, jaun₂ já'₂ cha'₂ në́₃, rë₂cuɨ́'₅ jág₁ quió'₅ 'éi₂. Jaun₂ të́'₂ já'₂ cha'₂ quiáin₅ 'ŋiog₅ lia'₂ chein₂, jaun₂ 'uág'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jë₁ma₂ca₂lë₃ 'uɨ́in'₂ ca₂le₃jɨ́n₃ con'₂ i₂quiáin₅ 'ŋiog₅, jaun₂ cán₂ ne₄ juɨ₅, dsó₅ ne₄ já'₂ cha'₂. Já'₂ cha'₂ në́₃ dsɨ₂léin₂ chi₁co'₅₄ quió'₅, ia₁ rë₂cuɨ́'₅ bá₄ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","La₁ tsá₃ 'ein₂₃ juɨ₁lia'₂ dsa₂ i₂tsá₃ cuɨin₂₃; të₂le₃ cuɨng₂₃ bá₄ ja₁con₂ 'éi₂, ia₁ tsá₃ cuɨ́'₅ jág₁ quió'₅ dsa₂ sián'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ca₂juá'₂ Jesús jág₁ a₂jáng'₅ léi₄ në₅, la₁ tsá₃ ca₂rë₃ŋɨ́'₂ dsa₂, 'e₂ jein₅ jág₁ jaun₂ a₂juá'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jaun₂ në́₃ ca₂juá'₂ táng₃ Jesús ca₂tsɨ́'₃ dsa₂: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, jniá₂ bá₄ lɨ́ng₅ o₄'né₄ juɨ₅ ja₁dsɨ₂ton'₅₄ já'₂ cha'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ca₂le₃jɨ́n₃ i₂ma₂o₃lén₂ jŋiá₅ guë́₄ con'₂ guë́₄ jniá₂, dsa₂ 'ang₂ bá₄ 'éi₂; la₁ já'₂ cha'₂ në́₃, tsá₃ juɨ₅ ca₂ton'₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jniá₂ lɨ́ng₅ o₄'né₄; juɨ₁lia'₂ i₂tón'₅ juɨ₅ le₃quió₃, tɨ́in'₄ bá₄. Jaun₂ qui₃dsɨ₃toin'₅₄, qui₃'uɨ́in₃, jaun₂ dsio'₂ bá₄ ŋi₂ma'₂ a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Dsa₂ 'ang₂ në́₃, jmá'₃ ta₁ jaun₂ bá₄ ja₂: a₂'ang₃, a₂jme₃dsiog₂₃, a₂qui₃'éin₂ në́₃; jniá₂ në́₃ guio₃ ia₁jaun₂ le₃chain₂, a₂le₃chain₂ qui₂rë₂tsón₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jniá₂ bá₄ lɨ́ng₅ juɨg₅₄ dsen₃ i₂jmo₅ 'í₁ já'₂ cha'₂. Guen₅ 'mú₃ juɨg₅₄ dsen₃ o₄quió'₄ já'₂ cha'₂; ");
INSERT INTO cntNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","la₁ juɨ₁lia'₂ dsa₂ i₂jmo₅ ta₁ a₂'liain'₅₄, jë₁ma₂ca₂jág₃ já₅ dsɨ₂jɨ'₅₄ náu₂, téin₂ bá₄ já'₂ cha'₂ jaun₂ cuɨng₂₃ bá₄ 'ŋiog₅, ia₁ on₃jua'₅₄ juɨg₅₄ i₂quián₅ já'₂ cha'₂ 'éi₂. Jaun₂ dsɨ₂jɨ'₅₄ náu₂ në́₃, tsáin'₂ já'₂ cha'₂, jaun₂ jmo₂₃ le₁jan₅₄ já'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Dsa₂ 'éi₂ në́₃, cuɨng₂₃ ia₁ a₂'liain'₅₄ bá₄ jmo₂₃ 'í₁; tsá₃ dsan₂ dsɨ́₅ já'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Jniá₂ bá₄ lɨ́ng₅ juɨg₅₄ dsen₃; i₂cuɨ́n₅ bá₄ jniá₂ já'₂ cha'₂ quiáng₃; 'éi₂ në́₃ cuɨg₂₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Le₂jaun₂ juɨ₁lia'₂ cuɨg₅ Ŋe'₃ jniá₂, ján₃ bá₄ cuɨ́n₅ jniá₂ 'éi₂ në́₃. Guén₅ jniá₂ 'mú₃ o₄quió'₄ já'₂ cha'₂ quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ján₃ bá₄ tion'₅₄ já'₂ cha'₂ sián'₂ quiáng₃ i₂tsá₃ tion'₅₄ 'ŋió'₃ jnɨ́₁ la₂; ján₃ bá₄ ca₂tɨ́n₂ jniá₂ i₁te₁ 'éi₂. Ján₃ bá₄ le₃ne'₅₄ 'éi₂ jág₁ quió₃, jaun₂ co₂nió'₃ bá₄ lé₂, jan₂ guë'₂ juɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’'Uɨg₅₄ jaun₂ bá₄ 'nio₃ Ŋe'₃ jniá₂: ia₁ jáng'₅ jme₂dsí₂ quió₃, ia₁jaun₂ tɨ́ng'₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lia'₂ 'i₁jan₂ tsá₃ jŋiá'₂ jme₂dsí₂ a₂chan₂ jniá₂, ia₁ jáng'₅ bá₄ jniá₂ jme₂dsí₂ a₂chang₂ a₂'ŋio₂ dsɨ₃ 'ŋió₃. Jniá₂ bá₄ 'o₂₃ bí₂ jáng'₅, jaun₂ 'o₂₃ bí₂ tɨ́ng'₄ táng₃. 'Éi'₃ në₅ ca₂ŋɨg₂ ja₁con₂ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jaun₂ ca₂lë₃ le₁dson'₅₄ táng₃ dsa₂ judíos, jme₁ca₂nág₂ jág₁ në₅. ");
INSERT INTO cntNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Juɨn₅ i₂'éi₂ juá'₂: ―I₂'en₅₄ jan₂ jme₂dsí₂ je₂na'₅₄ të₂dsɨ́₅ bá₄ në₅, të₂'ɨ₂₃ a₂ŋái₅ në́₃. ¿'E₂ lë₃ tón'₂ 'nia'₂ juɨ₅ jág₁ quió'₅? ");
INSERT INTO cntNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","La₁ i₂lɨn₅₄ guë'₂ juá'₂: ―On₃jua'₅₄ jág₁ quió'₅ jan₂ i₂'en₅₄ je₂na'₅₄ të₂dsɨ́₅ në₅. ¿Lé₂ le₃jmo₃ je₂na'₅₄ a₂jág₃ juɨ₁lia'₂ dsa₂ ten₄? ");
INSERT INTO cntNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jmɨg₄ jaun₂, jme₁tion'₅₄ dsa₂ juɨg₂ Jerusalén jmo₂₃ Jmɨg₄ quió'₅ Si₂. Jein₂ güɨ́g₂ jme₁lë́₄, ");
INSERT INTO cntNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","jaun₂ jme₁i₂ŋɨ₅₄ Jesús i₁dsi₅ guá'₅ templo ja₁lë́₄ corredor a₂chei₂ Quió'₅ Salomón, ");
INSERT INTO cntNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","jaun₂ qui₂ca₂o₃lio₃ dsa₂ judíos quió'₅, jaun₂ ca₂juá'₂: ―¿'A₂ con'₂ jmó'₂ 'ne₂ 'ag₃ guë́₄ caun₂-tɨn₃ dsɨ₅ jnia'₅₄? Chi₂jua'₂ dsón'₂ lɨ́n'₅ 'ne₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄, co₂ŋei'₅₄ jua'₅₄ rë₂jiá₃ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jaun₂ ca₂ŋag₃ Jesús: ―Ma₂në₂juá'₃ bá₄ jniá₂, la₁ tsá₃ ca₂rë₃'én'₂ guë'₂ 'nia'₂. Qui₂jáng'₅ bá₄ jág₁ dsau₅ o₄quió₃, léi₄ a₂jmo₅ jniá₂; ");
INSERT INTO cntNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","la₁ tsá₃ 'én'₂ 'nia'₂, ia₁ tsá₃ lɨ́n'₅ 'nia'₂ já'₂ cha'₂ quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ne'₅₄ bá₄ já'₂ cha'₂ quiáng₃ jág₁ quió₃; i₂cuɨg₅ bá₄ 'éi₂ jniá₂, jaun₂ ja₂'ein₂₃ chi₁co'₅₄ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Cuë́₅ jniá₂ jme₂dsí₂ a₂le₃chain₂ co₂tan₅₄, jaun₂ lia'₂ o₁lɨ́g'₂ jmɨg₄ tsá₃ dsiáin₃, on₃ guë́₄ lia'₂ 'i₁jan₂ tsá₃ lé₂ le₃jŋiái'₂ 'éi₂ o₄gu₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ŋe'₃ jniá₂, i₂ma₂cuag₃ 'éi₂, lɨ́n₅ i₂juɨn'₂ guë́₄ lia'₂ con'₂ guë́₄ ca₂le₃jɨ́n₃; jaun₂ lia'₂ 'i₁jan₂ tsá₃ lé₂ jŋióg'₂ o₄gú₃ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jniá₂ quian'₅₄ Ŋe'₃, ca₂ne₅₄ bá₄ lág₅ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jaun₂ në́₃ ca₂jŋa'₃ táng₃ dsa₂ judíos nɨ₁cang₁ a₂qui'₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jaun₂ ca₂juá'₂ Jesús: ―'Lióng₂ lɨn₃ léi₄ dse₃ ma₂'ë́₃ jniá₂ 'nia'₂ të₂le₃ quian'₅₄ juɨ₅bí₂ quió'₅ Ŋe'₃; ¿o₄quió'₄ 'e₂ caun₂ a₂ma₂jmo₃ jniá₂ jaun₂, a₂qui₁jnau'₅₄ 'nia'₂ jniá₂ nɨ₁cang₁? ");
INSERT INTO cntNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jaun₂ ca₂ŋag₃ dsa₂ judíos: ―Tsá₃ o₄quió'₄ léi₄ dse₃ qui₁jna'₅₄ jnia'₅₄ 'ne₂ nɨ₁cang₁; a₂jaun₂ bá₄ ia₁ a₂'ɨ́ng'₅ 'lɨg'₅₄ Diú₄, a₂jmo'₂ 'ne₂ a₂lɨ́ng'₅ Diú₄, ton'₂ jan₂ dsa₂ mɨ₂güɨ́g₃ bá₄ lɨ́ng'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jaun₂ në́₃ ca₂juá'₂ Jesús tsɨ́'₅ dsa₂ judíos: ―¿Tsa₁ chi₁ton₅ ne₄ Si₂ 'Éi'₂ quián'₂ 'nia'₂: “A₂ma₂juá'₃ jniá₂, a₂lɨ́n'₅ 'nia'₂ diú₄”? ");
INSERT INTO cntNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chi₂jua'₂ ca₂të́'₃ “diú₄” dsa₂ i₂ca₂ŋɨ₂ jág₁ quió'₅ Diú₄, (jaun₂ tsá₃ lé₂ jua'₅₄ tsá₃ le₃ti₃ Si₂); ");
INSERT INTO cntNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","'ë₂ guë́₄ bá₄ 'éi₂ i₂ca₂jmo₃ Diú₄ rë₂tson₄, i₂ca₂chein₃ mɨ₂güɨ́g₃. ¿'Nia'₂ juɨg'₂ 'ɨ́ng'₅ 'lɨg'₅₄ Diú₄ ia₁ jniá₂ në₂juá'₃ a₂lɨ́ng₅ Ja₁ŋi'₅₄ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Chi₂jua'₂ tsá₃ jmo₅ jniá₂ ta₁ quió'₅ Ŋe'₃, tsá₃ juɨ₁le₂'én'₂ 'nia'₂ le₃quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","La₁ chi₂jua'₂ jmo₅ guë'₂ jniá₂, juɨ₁'a₂ guë́₃ la₂ tsá₃ 'én'₂ 'nia'₂ të₂le₃ quió₃ jniá₂, juɨ₁le₂'én'₂ bá₄ 'nia'₂ të₂le₃ quió'₅ ta₁ a₂jmo₅ jniá₂, ia₁jaun₂ le₃ŋi'₅₄ bá₄, ia₁jaun₂ le₃ŋɨ́'₂ 'au'₂ 'nia'₂, a₂'en₅₄ Ŋe'₃ ja₁cong₂, le₂jaun₂ guë'₂ táng₃, a₂'en₅₄ jniá₂ ja₁con₂ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jaun₂ jme₁'nio₃ táng₃ dsa₂ jme₁tsáun'₂, la₁ ca₂lóin₂ bá₄ o₄gú₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jaun₂ në́₃, ŋó₃ táng₃ Jesús të₂le₃ quióng₄ Cuá₃ Jordán, jaun₂ ca₂jŋia₃ ja₁jaun₂ ja₁jme₁'en₅₄ Juan₅₄ le₂jŋiá₅ choin₂₃ jmɨg₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Juɨn₅ lɨn₃ dsa₂ ca₂i₁len₅₄ i₁jag₅₄, qui₂ca₂juá'₂: ―Të₃dsón'₂ bá₄, o₁jŋia'₅₄ tsá₃ 'e₂ léi₄ juë'₂ ca₂jmo₃ Juan₅₄, la₁ ca₂le₃jë́₃ 'e₂ a₂ca₂juá'₂ a₂'ɨin₂₃ dsa₂ në₅, dsau₅ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ja₁jaun₂ ca₂rë₃'én₂ juɨn₅ dsa₂ le₃quió'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jme₁chan₂ jan₂ dsa₂ dso'₅₄ i₂jme₁chen₂ Lázaro, i₂jme₁chan₂ juɨg₂ Betania, juɨg₂ ja₁guá₄ María quian'₅₄ 'io₅₄ rɨin'₅₄ i₂chen₂ Marta. ");
INSERT INTO cntNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María në₅ në́₃ i₂rɨn'₅₄ Si₁Lia₁ dsa₂ dso'₅₄, 'éi₂ bá₄ i₂ca₂'ág₂ no'₅₄ mɨ₂juɨg₂ mɨ₂tag₄ Te₁gui'₅₄ jaun₂ ca₂chí₃, ca₂jme₃quéin₃ quian'₅₄ jŋi₂ dsi₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jaun₂ në́₃, ca₂chen₃ le₃on₃ 'io₅₄ jág₁ ne₄ Jesús: ―Te₁gui'₅₄, a₂ron₅ dso'₅₄ dsa₂ i₂'nio₄ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jaun₂ jme₁ca₂nág₂ Jesús, ca₂juá'₂: ―On₃jua'₅₄ dso₄ a₂jiog₅ juɨ₅ 'mú₃ jaun₂; të₂le₃ ia₁jaun₂ le₃juɨn'₂ Diú₄ bá₄, le₂jaun₂ guë'₂ Ja₁ŋi'₅₄ Diú₄ ján₃ le₃juɨin'₂ të₂le₃ quian'₅₄ dso₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús në́₃, jme₁'nioi₃ 'ŋio₅ lɨn₃ Marta quian'₅₄ 'io₅₄ rɨin'₅₄, quian'₅₄ Si₁Lia₁. ");
INSERT INTO cntNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jaun₂ lë₃, jme₁ca₂juá'₂ dsa₂ a₂dso'₅₄ Si₁Lia₁, ca₂jŋia₃ guë́₄ tɨn₃ jmɨg₄ ja₁jme₁'ein₅₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Cang₂ jaun₂, ca₂juá'₂ ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Ma₃dsau₅₄ táng₃ juɨ₅ Judea. ");
INSERT INTO cntNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jaun₂ në́₃ ca₂juá'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―Të₅, i₁jáun₃ në₅ cón'₅ jme₁'nio₃ dsa₂ judíos jme₁qui₃jnáu'₂ cang₄; ¿con'₂ guë'₂ lia'₂ 'niog'₂ gog'₅₄ táng₃ ja₁jaun₂? ");
INSERT INTO cntNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jaun₂ ca₂ŋag₃ Jesús: ―¿On₁ dsón'₂ quian₅ guia₃-tɨ́n₂ horas caun₂ jmɨg₄? Në₁jua'₂ i₂nio₄ dsa₂ a₂jmɨ₂, tsá₃ qui₂niói₅, ia₁ jág₅ si₂ a₂tág₅ ja₁con₂ dsa₂ mɨ₂güɨ́g₃; ");
INSERT INTO cntNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","la₁ në₁jua'₂ i₂nio₄ dsa₂ jë₄ qui₁né'₃ qui₂niói₅ ia₁ tsá₃ si₂ cha₂ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Cang₂ jme₁ma₂në₂juá'₂ le₂në₅, jaun₂ ca₂juá'₂: ―Ma₂ca₂güɨn₂ bá₄ Si₁Lia₁ a₂mei₅₄ quián₂ jniog₄; la₁ nei₅₄ jniá₂ i₁ŋei₁₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jaun₂ në́₃ ca₂juá'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―Te₁gui'₅₄, chi₂jua'₂ ma₂ca₂güɨin₂, co₂'nió'₄ jŋia₃ bá₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","La₁ a₂jaun₂ bá₄ jme₁'nio₃ Jesús juá'₂ a₂jme₁ma₂jon₅ bá₄ 'éi₂; la₁ jaun₂ bá₄ lɨ́n₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ a₂'ë₅ Jesús juɨ₁lia'₂ a₂güɨn₂ dsa₂ jë₁ma₂ca₂nei₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jaun₂ në́₃ ca₂juá'₂ Jesús lia'₂ rë₂jiá₃ jág₁: ―Ma₂ca₂jon₃ bá₄ Si₁Lia₁. ");
INSERT INTO cntNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Jéin₅ jniá₂ 'io'₂ o₄quián'₂ 'nia'₂, a₂tsá₃ jme₁'eng₅₄ ja₁jaun₂, ia₁jaun₂ le₃'én'₂ 'nia'₂. La₁ ma₃dsau₅₄ ma₃dsɨ₁jɨin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jaun₂ në́₃ ca₂juá'₂ To₁má₄ i₂të́'₂ dsa₂ Dsa₂ Tsɨn'₅₄, ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ rɨin'₅₄: ―Ján₃ guë'₂ dsau₅₄ jniog₄, ia₁jaun₂ dsióg₃ co₂lë₅ quian'₅₄ i₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jme₁ma₂të́₂ quén₂ jmɨg₄ 'en₅₄ Si₁Lia₁ tau₂ 'ŋio₅, jme₁dsióg₃. ");
INSERT INTO cntNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Juɨg₂ Betania jaun₂, jme₁niog₅ cau₅ ma₂quián₅ Jerusalén con'₂ tɨn₃ kilómetros të₂ ca₂jau₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jaun₂ ca₂i₁len₅₄ juɨn₅ dsa₂ judíos ca₂i₁jɨin₁₂ Marta quian'₅₄ María rɨin'₅₄, ca₂i₁jmo₅₄ lián'₂ dsɨ́₅ 'éi₂, ia₁ ca₂jon₃ Si₁Lia₁ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jaun₂ Marta në́₃, jme₂ca₂rë₃ŋi₅ a₂ma₂já₅ Jesús, jaun₂ ca₂o₃'ɨ́in₃ ca₂i₁jme₁jein'₂. La₁ María në́₃ ca₂jŋia₃ bá₄ dsi₂néi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jaun₂ ca₂juá'₂ Marta ca₂tsɨ́'₃ Jesús: ―Te₁gui'₅₄, jua'₅₄ mei'₂ bá₄ jme₁'eng'₅₄ ja₁lá₃, tsá₃ jme₁jón₂ dsó₂ rɨ́ng'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","La₁ia₁ guion₄ jniá₂, o₁jŋia'₅₄ con'₂ lë́₅ la₂, chi₂jua'₂ 'e₂ a₂mɨ'₂ 'ne₂ ja₁con₂ Diú₄, cuë₃ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jaun₂ ca₂juá'₂ Jesús: ―Le₃chan₂ bá₄ táng₃ rɨ́ng'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Jaun₂ ca₂juá'₂ Marta: ―Guion₄ bá₄ jniá₂ a₂le₃chain₂ táng₃ jë₁ma₂të́₂ rë₁jein'₅₄ jɨn₄ 'lag₄, jmɨg₄ jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jaun₂ në́₃ ca₂juá'₂ Jesús: ―Jniá₂ bá₄ lɨ́ng₅ i₂jmo₅ a₂jen'₅₄ dsa₂, i₂cuë₅ jme₂dsí₂ a₂le₃chan₂ dsa₂ në́₃. Juɨ₁lia'₂ i₂'én₂ të₂le₃ quió₃ jniá₂, o₁jŋia'₅₄ ma₂join₂₃, le₃chain₂ bá₄; ");
INSERT INTO cntNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","jaun₂ chi₂jua'₂ 'ein₂ i₂chan₂ guë́₄, në₁jua'₂ ca₂rë₃'éin₂ të₂le₃ quió₃ jniá₂, lia'₂ o₁lɨ́g'₂ jmɨg₄ tsá₃ jóin₂. ¿'Éng'₂ jág₁ në₅? ");
INSERT INTO cntNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jaun₂ ca₂juá'₂ Marta: ―Ján₅, Te₁gui'₅₄. Ma₂ca₂rë₃'én₂ bá₄ jniá₂ a₂lɨ́n'₅ 'ne₂ Ja₁ŋi'₅₄ Diú₄ I₂rë₂'ɨ́n₁ quiáin₅, i₂lë́₅ jág₁ jiá₃ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jme₁ca₂lë₃ juá'₂ Marta jág₁ në₅, ŋái'₃ i₁te'₂ María rɨin'₅₄; jaun₂ ca₂juá'₂ jág₁ con'₂ të₃co'₅₄: ―La₂ ma₂'en₅₄ të₅, jaun₂ 'ne₂ të́'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Dsɨ₂juɨ₅ jme₁ca₂nág₂ María jág₁ në₅, ca₂nau₂, jaun₂ ŋó₃ i₁jɨin₂₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tsá₃ jme₁ma₂dsióg₃ guë́₄ Jesús të₃jë₄ juɨg₂; jaun₂ bá₄ jme₁'ein₅₄ ja₁ca₂jein'₂ Marta. ");
INSERT INTO cntNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Dsa₂ judíos i₂tion'₅₄ dsi₂néi₂ i₂cuë₅ lián'₂ dsɨ₅ në́₃, jme₁ca₂jág₃ ca₂nau₂ María ca₂o₃'ɨ́in₃ co₂chi'₅₄, ca₂i₃léin₂ chi₁co'₅₄ quió'₅, ia₁ a₂lɨ́in₂ ŋó₅ 'éi₂ tau₂ 'ŋio₅ a₂i₂'áu₂ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jaun₂ në́₃, jme₁ca₂dsióg₃ María ja₁jme₁'en₅₄ Jesús, ca₂chi₃jné₃ ne₄ 'éi₂, jaun₂ ca₂juá'₂: ―Te₁gui'₅₄, jua'₅₄ mei'₂ bá₄ jme₁'eng'₅₄ ja₁lá₃, tsá₃ jme₁jón₂ dsó₂ rɨ́ng'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jme₁ca₂jág₃ Jesús 'a₂ lia'₂ jme₁'o₅ María, 'a₂ lia'₂ jme₁tion'₅₄ guë'₂ dsa₂ judíos 'o₂₃ në́₃, i₂ja₂lén₂ quiain'₅₄, jaun₂ ca₂'ŋia₃ i₃mé'₂ dsɨ́₅, ca₂'í₃ quɨ'₂ dsɨ́₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jaun₂ ca₂ŋag₃: ―¿A₂já'₄ ca₂i₁'óin'₄ 'nia'₂? Jaun₂ ca₂juá'₂ dsa₂: ―Te₁gui'₅₄, ŋia₅ i₂jag₄. ");
INSERT INTO cntNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jaun₂ ca₂'o₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jaun₂ në́₃ ca₂juá'₂ dsa₂ judíos: ―Jag₄ de'₂ 'a₂ lia'₂ jme₁'nioi₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","La₁ ca₂juá'₂ i₂lɨn₅₄: ―¿Tsa₁ cha₂ lé₂ le₃jme₁jmo₃ i₂në₅ i₂ca₂jme₃'lión₂ dsa₂ ten₄ 'éi₂, ia₁jaun₂ tsá₃ jme₁jón₂ guë'₂ dsó₂ rɨn'₅₄ 'io₅₄ në₅? ");
INSERT INTO cntNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Con'₂ siá'₂ táng₃ ca₂'ŋia₃ Jesús a₂i₃mé'₂ dsɨ́₅ lia'₂ con'₂ ca₂dsióg₃ ja₁dsi₅₄ tau₂ 'ŋio₅. Caun₂ tsɨ₁të₂'lau₂ bá₄ jme₁lë́₄ a₂jaun₂, jme₁chí'₄ ca₂mɨ́g₂ nɨ₁cang₁ a₂rë₂jlë₅ o₄'né₄. ");
INSERT INTO cntNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jaun₂ ca₂juá'₂ Jesús: ―Jŋiá'₃ nɨ₁cang₁ në₅. Jaun₂ ca₂juá'₂ Marta rɨn'₅₄ 'lag₄ ca₂tsɨ́'₃ Jesús: ―Te₁gui'₅₄, mei'₂ tsá₃ ma₂ja₂ ma₂'lɨg'₅₄ quió'₅, ia₁ ma₂të́₂ quén₂ jmɨg₄ ca₂join₃. ");
INSERT INTO cntNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","La₁ ca₂juá'₂ Jesús: ―¿Tsa₁ në₂juá'₃ jniá₂, në₁jua'₂ 'éng'₂, jag'₅₄ juɨ₅bí₂ jlá'₁ quió'₅ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jaun₂ në́₃ ca₂jŋiá'₂ dsa₂ nɨ₁cang₁. Jaun₂ ca₂chóg'₃ Jesús ne₅₄, ca₂juá'₂: ―Tia₅₄, cuë́₅ jniá₂ ti₁'mag'₄ 'ne₂ ia₁ ma₂nei'₂ bá₄ jág₁ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","A₂guion₄ bá₄ jniá₂, a₂nag'₂ co₂tan₅₄. La₁ në₂juá'₃ le₂në₅ o₄quió'₄ dsa₂ i₂tion'₅₄ ja₁lá₃, ia₁jaun₂ le₃'éin₂ a₂ca₂chei'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jme₁ca₂lë₃ juá'₂ le₂në₅, ca₂juá'₂ tiá₂: ―¡Lázaro! ¡Jú₅ ja₁në₅! ");
INSERT INTO cntNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jaun₂ o₂'ɨ́n₃ 'lag₄ ja₁jaun₂ qui₂rë₂quein₅ gu₂-tag₅₄ quian'₅₄ 'nau₅₄ tsɨ́n'₅ tsɨ₁'mɨ'₂ jang₄. Dsɨ₂ne₅₄ në́₃ jme₁chi₁quein₅ quian'₅₄ tsɨ₁'mɨ'₂ tióg₃. Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂: ―Chi'₅₄ quió'₅, cuë₄ jmɨg₄ juɨ₁dsiain'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jaun₂ në́₃, juɨn₅ dsa₂ judíos 'éi₂, i₂ca₂i₁len₅₄ quiain'₅₄ María, i₂qui₂ca₂të́₂ ne₄ 'e₂ a₂ca₂jmo₃ Jesús jaun₂, ca₂rë₃'éin₂ të₂le₃ quió'₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","La₁ i₂lɨn₅₄ guë'₂ në́₃ ca₂i₁lein₅₄ ja₁con₂ dsa₂ fariseos, ca₂i₁jua'₄ 'e₂ a₂ca₂jmo₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jaun₂ në́₃, ca₂ŋɨ'₂ dsa₂ fariseos quiain'₅₄ juɨg₅₄ jme₂dsa₂, quiain'₅₄ dsɨ₂tan₅₄ quián₅ guá'₅, jaun₂ ca₂juá'₂: ―¿'E₂ bá₄ jmó₁ jniog₄? Ia₁ në₅ bá₄ ŋɨ₅ dsa₂ 'éi₂ jmo₂₃ 'lióng₂ léi₄ juë'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Chi₂jua'₂ caun₂ cuë₂ jniog₄ jmɨg₄ jmo₃ lia'₂ ma₂jmo₂₃ në₅, le₃'én₂ bá₄ ca₂le₃jɨ́n₃ dsa₂ të₂le₃ quió'₅; jaun₂ qui₂ja₃lén₂ dsa₂ romanos qui₃'éin₂ ja₁jŋió₅ quián₂ jniog₄ la₂, lia'₂ jma₃quian'₅₄ juɨg₂ nación quián₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","La₁ jan₂ dsa₂ 'éi₂, i₂chen₂ Caifás, i₂jme₁lɨ́n₄ jme₂dsa₂ dsen₅₄ ŋi₂ jaun₂, ca₂juá'₂: ―Tsá₃ 'e₂ cuɨn'₂ 'nia'₂ 'i₁caun₂, ");
INSERT INTO cntNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","on₃ guë'₂ len'₅₄ 'nia'₂, a₂jmo₅ bá₄ quián₂ jniog₄, a₂jón₂ jan₂ dsa₂ o₄quió'₄ ca₂le₃jɨ́n₃, ia₁jaun₂ tsá₃ dsɨ₃'én₂ ta₁caun₂ juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","La₁ on₃jua'₅₄ con'₂ tɨn₂ 'ŋiog₅ Caifás ca₂juá'₂ le₂në₅; a₂jaun₂ bá₄ ca₂juá'₂ le₂në₅ ia₁ a₂jme₁lɨ́in₄ jme₂dsa₂ dsen₅₄ ŋi₂ jaun₂: ca₂'ë́₂ jág₁ o₄quió'₄ Diú₄, a₂'i₄ 'éi'₃ jón₂ Jesús o₄quió'₄ dsa₂ juɨg₂ judíos. ");
INSERT INTO cntNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","La₁ on₃jua'₅₄ rë'₂ jmá'₃ o₄quió'₄ dsa₂ juɨg₂ judíos, ján₃ bá₄ ia₁jaun₂ chi₃loin'₃ jmói'₂ ca₂ne₅₄ ca₂le₃jɨ́n₃ chi'₂-guein₂ quián₅ Diú₄ i₂qui₂i₂nio₄ tsɨ₁rë₂jan₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jaun₂ në́₃, ca₂le₃ jmɨg₄ jaun₂, ca₂jmo₃ jág₁ dsɨ₂tan₅₄ quián₅ dsa₂ judíos a₂jŋɨi'₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","'Uɨg₅₄ jaun₂ tsá₃ ma₃jme₁ŋɨ₅ Jesús dsi₁ne₁ jɨn₄ dsa₂ judíos, të₂le₃ ca₂o₃'ɨ́in₃ bá₄ ja₁jaun₂. Jaun₂ ŋó₃ caun₂ 'uë₃ ma₂quián₅ ja₁lë́₄ 'uë₃ quein₂ co₂'ŋiog₅, caun₂ juɨg₂ a₂chei₂ Efraín. Ja₁jaun₂ ca₂jŋia₃ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂. ");
INSERT INTO cntNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jme₁ma₂ja₂quián₃ Jmɨg₄ Të₂'ɨn₅₄ quió'₅ dsa₂ judíos. Jaun₂ juɨn₅ bá₄ dsa₂ ca₂'uɨin₂ juɨg₂ gu'₂, qui₂ca₂uɨ́g₂ juɨ₅ Jerusalén né'₃ a₂të₅₄ Jmɨg₄ Të₂'ɨn₅₄, ia₁jaun₂ qui₃jmo₃ le₁jɨ́in₃. ");
INSERT INTO cntNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jaun₂ jme₁i₂nio₄ dsa₂ 'nai'₂ Jesús, jaun₂ qui₂ŋɨ́i'₂ rɨin'₅₄ tióin₂ i₁dsi₅ guá'₅ templo: ―¿'A₂ lia'₂ lɨ́n'₂ 'nia'₂? ¿Jiá₃ jmɨg₄, o₃ bá₄ tsá₃ jiá₃ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jme₁ma₂ca₂cuë₃ 'éi'₃ dsa₂ fariseos quiain'₅₄ juɨg₅₄ jme₂dsa₂ në́₃, jme₁ma₂juá'₂, në₁jua'₂ 'ein₂ ca₂rë₃ŋi₅ a₂já'₄ 'en₅₄ Jesús, juɨ₁jmo₁₂ jág₁ ia₁jaun₂ cuɨn₃ jmɨg₄ tsáun'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jŋéi₂ jmɨg₄ né'₃ a₂të₅₄ Jmɨg₄ Të₂'ɨn₅₄, ŋó₃ Jesús juɨ₅ Betania ja₁jme₁chan₂ Lázaro, dsa₂ i₂ca₂jme₃jen'₅₄ Jesús jme₁rë₂'lɨn₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ja₁jaun₂ ca₂jmo₃ dsa₂ caun₂ má₃ o₄quió'₄ Jesús, a₂jme₂juag'₂. Ca₂tia'₃ Marta má₃; Si₁Lia₁ guë'₂ jme₁lɨ́n₄ jan₂ dsa₂ i₂tián'₅ ne₄ mesa guë́'₅ co₂lë₅ quiain'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jaun₂ në́₃ ca₂can₃ María con'₂ mei'₂ tsá₃ ca₂'nau₅₄ litro no'₅₄ mɨ₂juɨg₂ nardo, a₂quen₅ 'mu'₅₄ 'ŋio₅ lɨn₃, jaun₂ ca₂tsáng₂ mɨ₂tag₄ Jesús, jaun₂ ca₂chí₃ quian'₅₄ jŋi₂ dsi₅₄. Ta₁caun₂ dsi₂néi₂ qui₂ca₂can'₂ dsió'₁ mɨ₂juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jaun₂ në́₃, ca₂juá'₂ Judas Iscariote, i₂jme₁lɨ́n₄ jan₂ dsa₂ guia₃-tɨ́n₂ quián₅ Jesús, i₂'éi₂ dé₄ i₂jáng'₂ quió'₅ Jesús, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿'E₂ 'uɨg₅₄ tsá₃ ca₂i₃'nag₄ co₂ŋei'₅₄ no'₅₄ mɨ₂juɨg₂ në₅ quian'₅₄ 'nɨ₅ 'ŋiá₂-láu₂ 'éi'₃ cu₄ denario, a₂jme₁jme₁'on₁ dsa₂ te₂ŋé₂? ");
INSERT INTO cntNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","La₁ on₃jua'₅₄ jaun₂ ca₂juá'₂ Judas le₂në₅ jua'₅₄ a₂dsón'₂ dsan₂ dsɨ́₅ ja₁con₂ dsa₂ te₂ŋé₂; a₂jaun₂ bá₄ ca₂juá'₂ le₂në₅ ia₁ a₂jme₁lɨ́in₄ jan₂ dsa₂ 'ang₂ bá₄, ton'₂ jme₁niog₅ gu₂ tsɨ₁të₂lau₂ ja₁jme₁tó'₅ cu₄, jaun₂ jme₁cán₂ a₂jme₁tio'₅₄ 'ŋió'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jaun₂ në́₃ ca₂juá'₂ Jesús ca₂tsɨ́'₃ Judas: ―Tsá₃ lë₁lein'₅₄; ta₁ jaun₂ bá₄ ca₂'ma₃ a₂në₅, jaun₂ ma₂lë́₅ co₂jŋia₅₄ jmɨg₄ jë₁ma₂të́₂ rë₁'on₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ca₂le₃jë́₃ jmɨg₄ bá₄ i₂nio₄ dsa₂ te₂ŋé₂ jɨn'₄ 'nia'₂, la₁ jniá₂ në́₃ tsá₃ ma₃uë́₂ 'en₅₄ jniá₂ quian'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jaun₂ në́₃, ca₂rë₃ŋi₅ juɨn₅ dsa₂ judíos a₂'en₅₄ Jesús jë₄ juɨg₂ Betania, jaun₂ i₁lein₅₄ ja₁jaun₂, on₃jua'₅₄ jmá'₃ ca₂ne₅₄ a₂i₁jɨin₁₂ Jesús, ján₃ bá₄ ca₂i₁jɨin₁₂ Si₁Lia₁ i₂ca₂jme₃jen'₅₄ Jesús jme₁rë₂'lɨin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jaun₂ në́₃, ca₂jmo₃ juɨg₅₄ jme₂dsa₂ caun₂ jág₁ a₂jŋɨi'₃ Si₁Lia₁ ján₃, ");
INSERT INTO cntNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ia₁ o₄quió'₄ 'éi₂ bá₄ juɨn₅ dsa₂ ma₂i₂uɨ́in₂ ja₁con₂ dsa₂ judíos, a₂rë₂'éin₂ të₂le₃ quió'₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jme₁jnia₃ jaun₂, ca₂dsi₃lén₂ juɨn₅ lɨn₃ dsa₂ Jerusalén, ja₁niog₃ jmɨg₄. Jaun₂ jme₁ca₂rë₃ŋi₅ a₂dsióg₄ Jesús jë₄ juɨg₄ Jerusalén, ");
INSERT INTO cntNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ca₂can₃ mog'₅₄ 'ma₂tsɨ́n₅, jaun₂ ca₂'uɨin₂ ca₂i₁jŋiai₅₄ Jesús, jaun₂ qui₂ca₂juá'₂ tiá₂: ―¡Juɨ₁le₂juɨn'₂ bá₄ i₂në₅! ¡Juɨ₁le₂jŋió₃ i₂já₅ o₄quió'₄ Te₁gui'₅₄! ¡Juɨ₁le₂jŋió₃ Rag₅₄ quián₅ Israel! ");
INSERT INTO cntNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ca₂dsán'₂ Jesús jan₂ i₂bú'₄ 'mɨ́₂, jaun₂ ca₂co₃dsɨin₅₄ já'₂, juɨ₁lia'₂ chi₁ton₅ ne₄ Si₂: ");
INSERT INTO cntNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Tsá₃ lë₁jmo₂ gang'₃, 'nia'₂ dsa₂ chan₂ ciudad Sión: jag₄, já₅ Rag₅₄ quiáng'₂, co₂dsɨin₅₄ jan₂ bú'₄. ");
INSERT INTO cntNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tsá₃ a₂jaun₂ ca₂rë₃ŋɨ́'₂ dsɨ́₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ le₂'uɨg₅₄; la₁ia₁ cang₂ jaun₂, jme₁ma₂ca₂lë₃ rë₂juɨn'₂ Jesús, jaun₂ bá₄ ca₂dsáu'₃ dsɨ́₅ guioin₅₄ jág₁ në₅ a₂tio'₅₄ ne₄ Si₂ a₂'ɨin₂₃ 'éi₂. Ca₂dsáu'₃ dsɨ́₅ ján₃, dsau₅ bá₄ le₂jaun₂ ca₂jmo₃ dsa₂ juɨg₂ ja₁con₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Qui₂ca₂jáng'₃ jág₁ dsau₅ dsa₂ juɨn₅ i₂jme₁quian'₅₄ Jesús lia'₂ con'₂ jme₁ca₂të́'₃ Si₁Lia₁ né'₃ tau₂ 'ŋio₅, jme₁ca₂jme₃jein'₅₄ 'éi₂ jme₁rë₂'lɨin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","'Uɨg₅₄ jaun₂ bá₄ ca₂'uɨn₂ dsa₂ juɨn₅, a₂ca₂i₁jŋiai₁₂ Jesús, ia₁ ca₂rë₃ŋi₅ a₂ca₂jmo₃ 'éi₂ léi₄ juë'₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jaun₂ në́₃ ca₂juá'₂ dsa₂ fariseos qui₂ca₂tsɨ́'₃ rɨin'₅₄: ―Në₅ bá₄ jág'₂ 'nia'₂, tsá₃ 'e₂ quɨ'₅₄ 'nia'₂ jmɨg₄ jmó'₂ 'i₁caun₂. Jag₄ de'₂ 'nia'₂, ma₂i₂lén₂ ta₁caun₂ mɨ₂güɨ́g₃ le₃quió'₅ i₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jɨn₄ dsa₂ i₂i₁len₅₄ Jerusalén i₂jme₂juɨn'₂ Diú₄ ja₁niog₅ jmɨg₄, jme₁tion'₅₄ i₂lɨn₅₄ dsa₂ griegos. ");
INSERT INTO cntNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Dsa₂ 'éi₂ në́₃, ca₂jme₃quiáin₃ ja₁con₂ Felipe i₂chan₂ juɨg₂ Betsaida, ja₁niog₅ 'uë₃ Galilea, jaun₂ ca₂mɨ₃ ne₄ 'éi₂, ca₂juá'₂: ―Gui'₅₄, 'niog₂ jnia'₅₄ né₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jaun₂ ŋe₄ Fe₂li₄ ca₂i₁chi'₄ Drë́₄; jaun₂ le₂oin₃ ca₂i₁dsia₂ a₂ca₂i₁chi'₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jaun₂ në́₃ ca₂ŋag₃ Jesús: ―Ma₂ca₂të́₂ hora a₂le₃juɨn'₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, në₁jua'₂ tsá₃ tiá'₃ né'₃ 'uë₃ juɨ₁lia'₂ ca₂mɨ́g₂ mɨ₂cuɨg₂, a₂dsɨ₃'én₂ në́₃, a₂lë₁të₂ron₅₄ 'ŋiog₅; la₁ia₁ në₁jua'₂ ca₂jon₃ në́₃, 'lióng₂ rau₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Juɨ₁lia'₂ i₂ŋɨ́₄ lë₃ 'nio₃ jme₂dsí₂ a₂chain₂, dsɨ₂'én₂ bá₄ jme₂dsí₂ jaun₂; la₁ia₁ juɨ₁lia'₂ i₂tén'₂ dsɨ́₅ jme₂dsí₂ quió'₅ a₂chain₂ mɨ₂güɨ́g₃ la₂, a₂lé₂ quió'₅ bá₄ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Juɨ₁lia'₂ i₂jme₂ti₃ ta₁ ne₃ jniá₂, 'nió'₅ jiá₃ chi₁co'₅₄ quió₃ jniá₂, jaun₂ juɨ₁lia'₂ ja₁'en₅₄ jniá₂, ján₃ bá₄ ja₁jaun₂ 'en₅₄ guë'₂ i₂jme₂ti₃ ta₁ ne₃. Jaun₂ juɨ₁lia'₂ i₂jme₂ti₃ ta₁ ne₃, guéi'₂ bá₄ Ŋe'₃ rë₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’'Ŋio₅ lɨn₃ quian₄ jniá₂ o₂i₁ dsɨ₅. ¿'E₂ bá₄ juá'₄ jniá₂? ¿Juá'₄ 'e₂: “Tia₅₄, lio₄ jniá₂ 'e₂ niog₅ a₂qui₂dsɨ₃ŋɨ́₂ jniá₂ hora la₂”? La₁ on₃jua'₅₄ le₂jaun₂, ia₁ ta₁ jaun₂ guio₃ guë'₂ jniá₂ hora la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tia₅₄ jme₁jnia₅ 'a₂ lia'₂ jláng'₁. Jaun₂ në́₃ ca₂né'₂ caun₂ jág₁ guei'₅₄ mɨ₂güɨ́g₃ a₂ca₂juá'₂: ―Ma₂ca₂jme₁jnia₅ bá₄ jniá₂, jaun₂ con'₂ siá'₂ jme₁jnia₅ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jme₁ca₂nág₂ dsa₂ juɨn₅ i₂jme₁tión₂ cau₅ jaun₂, ca₂juá'₂: ―Ŋí'₃ bá₄ në₂quiá'₃. La₁ i₂sián'₂ guë'₂ juá'₂: ―Jan₂ ángel bá₄ në₂juá'₂ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jaun₂ në́₃ ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂: ―On₃jua'₅₄ o₄quió₃ jniá₂ a₂ca₂né'₂ jág₁ në₅; o₄quián'₂ 'nia'₂ bá₄ a₂ca₂né'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Në₃ guë́₄ në́₃ ca₂të́₂ jmɨg₄ a₂të₃dsɨ₅₄ 'éi'₃ mɨ₂güɨ́g₃ la₂; në₃ guë́₄ dsein₂₃ i₂gon₂ mɨ₂güɨ́g₃ la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jaun₂ jniá₂ në́₃, jë₁ma₂ca₂chó'₂ dsa₂ guei'₅₄ gua'₅₄ 'uë₃, jme₁quián₄ jniá₂ ca₂le₃jɨ́n₃ ja₁cong₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ca₂juá'₂ le₂në₅ a₂'ë₂₃ 'e₂ ne₅₄ 'mú₃ dsɨ₃ŋɨ́i₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jaun₂ ca₂ŋag₃ dsa₂: ―Ma₂néi₂ jnia'₅₄ a₂'ɨ₅ dsa₂ ne₄ Si₂ 'Éi'₃ a₂juá'₂ a₂le₃chan₂ I₂rë₂'ɨ́n₁ quián₅ Diú₄ co₂tan₅₄. ¿'A₂ guë'₂ lia'₂ juá'₂ 'ne₂ tion₅₄ chón'₂ dsa₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃? ¿'Ein₂ 'éi₂ i₂lɨ́n₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃? ");
INSERT INTO cntNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jaun₂ në́₃ ca₂juá'₂ Jesús: ―Jŋia'₅₄ lia'₂ co₂'na₂ bá₄ tág₅ guë́₄ si₂ jɨn'₄ 'nia'₂. La₁ i₂nio'₄ 'nia'₂ të₁lia'₂ tág₅ si₂, con'₂ tsá₃ ŋó₅ në₁jua'₂ ca₂tó'₂ nei₂. Ia₁ juɨ₁lia'₂ dsa₂ i₂ŋɨ₅ jë₄ qui₁né'₃, tsá₃ ŋi₅ 'a₂ juɨ₅ dsó₃. ");
INSERT INTO cntNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Juɨ₁le₂'én'₂ 'nia'₂ le₃quió'₅ si₂, të₁lia'₂ cha₂ si₂ jɨn'₄ 'nia'₂, ia₁jaun₂ lén'₂ 'nia'₂ dsa₂ quián₅ si₂. Jme₁ca₂dsan₃ juá'₂ Jesús le₂në₅, ŋái'₃, jaun₂ ca₂'mai₃ ja₁con₂ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","La₁ juɨ₁'a₂ guë́₃ la₂ ca₂jmo₃ Jesús 'lióng₂ léi₄ ne₄ dsa₂ 'éi₂, tsá₃ ca₂rë₃'én₂ bá₄ guë́₄ dsa₂ 'éi₂ le₃quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Le₂në₅ ca₂rë₃ti₃ jág₁ a₂ca₂'ë́₂ Isaías o₄quió'₄ Diú₄, jme₁ca₂juá'₂: Te₁gui'₅₄, ¿'ein₂ ma₂ca₂rë₃'én₂ jág₁ a₂'ë́₅ jniog₄? ¿Ja₁con₂ 'ein₂ ma₂ca₂jme₃jnia₅ Te₁gui'₅₄ juɨ₅bí₂ quió'₅? ");
INSERT INTO cntNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","'Uɨg₅₄ jaun₂ tsá₃ lé₂ le₃'én₂ dsa₂ 'éi₂, ia₁ con'₂ siá'₂ ca₂juá'₂ táng₃ Isaías: ");
INSERT INTO cntNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ma₂ca₂jmo₃ Diú₄ a₂tén₂ dsa₂ 'éi₂, a₂ca₂lë₃ cang₄ dsi₅₄ në́₃, ia₁jaun₂ tsá₃ jág₃ quian'₅₄ mɨ₂ne₅₄, on₃ guë'₂ le₂ŋɨ́i'₂ të₂le₃ të₂dsɨ́₅, on₃ guë'₂ qui₃jéin'₃ dsɨ́₅, ia₁jaun₂ jme₁'lioin₁₂ jniá₂.” ");
INSERT INTO cntNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ca₂juá'₂ Isaías le₂në₅ ia₁ ca₂jág₃ le₂jŋiá₅ juɨ₅bí₂ jlá'₁ quió'₅ Jesús, jaun₂ ca₂dsia₃ 'ɨin₂₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","La₁ia₁ tion₅₄ bá₄ ca₂rë₃'én₂ dsa₂, le₂jiog₅ bá₄ i₂lɨn₅₄ dsa₂ can'₅₄. La₁ tsá₃ ca₂jmo₃ jág₁, ia₁ a₂gó'₅ gain₃ dsa₂ fariseos, con'₂ tsá₃ ŋó₅ në₁jua'₂ ca₂'uág'₂ dsa₂ quió'₅, ja₁le₁toin₂₃ ne₄ si₂ guá'₅ sinagoga. ");
INSERT INTO cntNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ia₁ a₂'nio₃ guë́₄ të₃tsɨin'₅₄ dse₃ quian'₅₄ dsa₂ mɨ₂güɨ́g₃, lia'₂ con'₂ guë́₄ a₂jme₁të₃tsɨin'₅₄ dse₃ quian'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ca₂juá'₂ Jesús jág₁ tiá₂: ―Juɨ₁lia'₂ i₂'én₂ të₂le₃ quió₃ jniá₂, on₃jua'₅₄ jmá'₃ le₃quió₃ jniá₂ 'éin₂; ján₃ bá₄ 'éin₂ le₃quió'₅ Ŋe'₃ i₂ca₂chei₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Juɨ₁lia'₂ i₂jág₂ jniá₂, jɨ́in₂ i₂ca₂chei₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ma₂guan₅ jniá₂ mɨ₂güɨ́g₃ la₂, a₂lɨ́ng₅ si₂, ia₁jaun₂ i₂'én₂ të₂le₃ quió₃ jniá₂, tsá₃ të₃'ŋiái₄ jë₄ qui₁né'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jaun₂ chi₂jua'₂ 'ein₂ i₂nag₅ jág₁ quió₃, la₁ tsá₃ guë'₂ tón'₂ juɨ₅, on₃jua'₅₄ jniá₂ qui₁dsɨ₅ 'éi'₃ quió'₅ 'éi₂; ia₁ on₃jua'₅₄ ta₁ jaun₂ guio₃ jniá₂ a₂qui₁dsɨ₅ 'éi'₃ ja₁con₂ dsa₂ mɨ₂güɨ́g₃; të₂le₃ a₂loin₅₄ bá₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Juɨ₁lia'₂ i₂tsá₃ jei₅₄ jniá₂, on₃ guë'₂ tón'₂ juɨ₅ jág₁ quió₃, cha₂ bá₄ caun₂ a₂qui₃dsɨ₅ 'éi'₃ quió'₅. Jág₁ a₂ma₂qui₂ma₂juá'₃ bá₄ jniá₂, a₂jaun₂ bá₄ qui₃dsɨ₅ 'éi'₃ quió'₅, jmɨg₄ jë₁ca₂tó'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ia₁ on₃jua'₅₄ o₄quió₃ 'ŋió₃ ma₂qui₂ma₂juá'₃; Ŋe'₃ jniá₂ i₂ca₂chei₃ bá₄ ma₂ca₂cuë₃ 'éi'₃ juɨ₁'e₂ a₂juá'₅ jniá₂ quian'₅₄ 'e₂ a₂jme₂tɨ́ng₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jaun₂ guion₄ jniá₂, a₂jiog₅ 'éi'₃ quió'₅ Ŋe'₃ juɨ₅ ja₁le₃chan₂ dsa₂ co₂tan₅₄; jaun₂ lë₃, jág₁ a₂juá'₅ jniá₂, juá'₅ lia'₂ con'₂ lë́₅ 'éi'₃ ca₂cuë₃ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ca₂juɨg₄ jme₁'nió'₅ guë́₄ a₂të₅₄ Jmɨg₄ Të₂'ɨn₅₄. Jme₁ma₂ŋi₅ bá₄ Jesús a₂ma₂ca₂të́₂ hora a₂o₃'ɨin₅ mɨ₂güɨ́g₃ la₂ a₂dsáin'₃ táng₃ ja₁con₂ Jmei₂. Lia'₂ co₂tan₅₄ bá₄ ca₂jme₃'nio₃ 'éi₂ dsa₂ quiáin₅ i₂jme₁tion'₅₄ mɨ₂güɨ́g₃; la₁ në₃ në́₃, ca₂jme₃jniai₂₃ 'a₂ con'₂ ca₂dsióg₃ ca₂rë₃'nioi₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jme₁ma₂lë₅ má₃ të₂le₃ ca₂nei₂, jaun₂ jme₁ma₂jmo₃ i₂së₃dsen₃ a₂i₂jiog₅ dsɨ́₅ Judas Iscariote, ja₁ŋi'₅₄ Si₂mu₅₄, a₂jɨ́in'₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jme₁ma₂ŋi₅ bá₄ Jesús a₂ma₂ca₂dsia₃ Jmei₂ ca₂le₃jë́₃ o₄gú₃; jme₁ma₂ŋi₅ bá₄ ján₃ a₂já₅ ja₁con₂ Diú₄, jaun₂ ja₁con₂ Diú₄ bá₄ dsáin'₃ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jaun₂ lë₃, lia'₂ con'₂ jme₁tiáin'₄ guë́'₅, ca₂nau₂ ja₁jme₁guá₄, jaun₂ ca₂dsia₃ cau₅ tsɨn'₅₄ a₂jme₁qui'₂ të₂le₃ co'₅₄, jaun₂ ca₂jén'₃ caun₂ 'mɨ'₂ toalla o₄'ŋei'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jaun₂ në́₃ ca₂tia'₃ jmɨg₂ 'ŋió'₃ caun₂ nɨ₁'ɨ́₅, jaun₂ ca₂jme₃lióg₃ ca₂rang₃ mɨ₂tag₄ chi'₂ dsɨ₂guia₃-tɨ́n₂. Jaun₂ ca₂jme₃quéin'₂ quian'₅₄ tsɨ₁'mɨ'₂ toalla a₂jme₁chi₁jén'₅ o₄'ŋei'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jaun₂ jme₁ca₂dsióg₃ ja₁con₂ Si₂mu₅₄ Pe₄, ca₂juá'₂ 'éi₂ ca₂tsɨ́'₃ Jesús: ―Te₁gui'₅₄, ¿'ne₂ ráng'₂ tag₃ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jaun₂ ca₂ŋag₃ Jesús: ―Tsá₃ ŋɨ́'₂ guë́₄ 'au'₂ 'ne₂ 'e₂ a₂jmo₅ jniá₂ në₃, la₁ cang₂ guë́₄ le₃ŋɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","La₁ ca₂juá'₂ Pe₄: ―Lia'₂ o₁lɨ́g'₂ co₂ŋɨ́₂ tsá₃ ráng'₂ 'ne₂ tag₃ jniá₂. Jaun₂ ca₂juá'₂ Jesús: ―Në₁jua'₂ tsá₃ ca₂rang₃ jniá₂ quiáng'₂, tsá₃ quen'₅₄ 'ne₂ ja₁con₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jaun₂ në́₃ ca₂juá'₂ Si₂mu₅₄ Pe₄: ―Chi₂jua'₂ le₂jaun₂, Te₁gui'₅₄, on₃jua'₅₄ jmá'₃ mɨ₂tag₃ ráng'₂; ján₃ bá₄ rang₄ mɨ₂gu₃ quian'₅₄ mɨ₂dsi₃. ");
INSERT INTO cntNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","La₁ ca₂juá'₂ Jesús: ―Juɨ₁lia'₂ i₂lia'₂ ca₂lë₃ ló'₅, jmá'₃ mɨ₂tag₅₄ bá₄ 'nió'₅ rɨn'₂, ia₁ ma₂le₁jɨ́in₃ bá₄ ta₁jain₂. Ma₂le₁jɨ́n'₃ bá₄ 'nia'₂, la₁ia₁ on₃jua'₅₄ ca₂le₃jɨ́ng'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ca₂juá'₂: “Tsá₃ le₁jɨ́n'₃ 'nia'₂ le₃jɨ́ng'₃”, ia₁ ma₂ŋi₅ bá₄ i₂'ein₂ i₂jáng'₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jme₁ca₂lë₃ rang₅ Jesús mɨ₂tag₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, jaun₂ ca₂quɨ́'₂ táng₃ nɨ₁tsɨn'₅₄ le₃co'₅₄, jaun₂ ca₂guá₂ táng₃ ne₄ mesa. Jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―¿Ŋɨ́'₂ 'nia'₂ 'e₂ a₂në₂jmo₃ jniá₂ quián'₂ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","'Ág'₅ 'nia'₂ jniá₂ Të₅, quian'₅₄ Te₁gui'₅₄. Tí₅ bá₄ jág₁ quián'₂ 'nia'₂, ia₁ dsón'₂ bá₄ le₂jaun₂ lɨ́ng₅. ");
INSERT INTO cntNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jaun₂ në́₃, chi₂jua'₂ le₂në₅ jniá₂ i₂lɨ́ng₅ Të₅ quian'₅₄ Juɨg'₂ 'nia'₂, në₂rang₃ mɨ₂tag'₅₄ 'nia'₂, ján₃ bá₄ le₂jaun₂ 'nió'₅ jmó'₂ 'nia'₂: a₂qui₁ráng'₂ mɨ₂tag₄ rɨ́ng'₂ le₂jang'₂ le₂jang'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ia₁ ma₂në₂can₃ jniá₂ caun₂ juɨ₅, ia₁jaun₂ jmó'₂ 'nia'₂ le₂jaun₂, juɨ₁lia'₂ ma₂në₂jmo₃ jniá₂ ja₁con'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, lia'₂ 'i₁jan₂ dsa₂ i₂jme₂ti₃ ta₁, tsá₃ juɨin'₂ guë́₄ con'₂ guë́₄ juɨg₅₄; ján₃ bá₄ lia'₂ 'i₁jan₂ dsa₂ i₂chen₄, tsá₃ juɨin'₅₄ guë́₄ lia'₂ con'₂ guë́₄ dsa₂ i₂chei₅. ");
INSERT INTO cntNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Chi₂jua'₂ ŋɨ́'₂ 'au'₂ 'nia'₂ a₂në₅, 'e₂ bá₄ dsen'₃ 'nia'₂ chi₂jua'₂ le₂jaun₂ qui₂jmo'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’On₃jua'₅₄ ca₂le₃jɨ́n'₃ 'nia'₂ 'ɨ́n₅ jniá₂; guion₄ bá₄ jniá₂ i₂'ein₂ 'éi₂ i₂ma₂ca₂quiong'₅₄. La₁ia₁, 'nió'₅ le₃ti₃ lia'₂ con'₂ juá'₂ ne₄ Si₂: “Juɨ₁lia'₂ i₂guë́'₅ co₂lë₅ quian'₅₄ jniá₂, ca₂nau₂ quen₅ të₂le₃ ja₁con₂ jniá₂.” ");
INSERT INTO cntNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jaun₂ juɨ́g₂ jniá₂ 'nia'₂ në₃, të₃jŋiá₅, ia₁jaun₂ jë₁ma₂të́₂ rë₁lé₂, le₃'én'₂ 'nia'₂, jniá₂ bá₄ lɨ́ng₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, juɨ₁lia'₂ i₂guen₅ dsa₂ i₂chen₄ quián₃ jniá₂, guei₂₃ jniá₂; jaun₂ juɨ₁lia'₂ i₂guei₅ jniá₂ guein₂₃ i₂ca₂chei₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jme₁ca₂lë₃ juá'₂ jág₁ në₅, ca₂can₃ o₂i₁ dsɨ₅ ca₂të₂ jme₂dsí₂, jaun₂ ca₂jáng'₃ jág₁ dsau₅ lia'₂ rë₂jiá₃ jág₁, ca₂juá'₂: ―A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, jan₂ 'nia'₂ jáng'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jaun₂ në́₃ qui₂ca₂jɨ́n₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ rɨin'₅₄ le₂jain₂ le₂jain₂, i₂gó'₃ dsɨ́₅ 'nio₃ le₃ŋi₅ 'ein₂ bá₄ 'ɨn₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jan₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ i₂ŋɨ́₄ lë₃ jme₁'nio₃ Jesús, jme₁guá₄ le₃jén'₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jaun₂ ca₂jmo₃ Si₂mu₅₄ Pe₄ caun₂ léi₄ ne₄ 'éi₂, ca₂juá'₂: ―Chei'₅₄ 'ein₂ bá₄ 'ɨin₂₃. ");
INSERT INTO cntNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jaun₂ në́₃ ca₂jme₃quián₃ 'éi₂ të₂cau₅ guë́₄ quió'₅ Jesús, jaun₂ ca₂ŋag₃: ―Te₁gui'₅₄, ¿'ein₂ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jaun₂ ca₂ŋag₃ Jesús: ―I₂'éi₂ bá₄ i₂cuë́₄ jniá₂ ca₂jne₄ i₁ŋí'₄ la₂, jë₁ma₂ca₂tiá₃ nɨ₁uɨng₅. Jaun₂ në́₃, jme₁ma₂në₂tiá₂ i₁ŋí'₄, jaun₂ ca₂cuë́'₃ Judas Iscariote, ja₁ŋi'₅₄ Si₂mu₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jaun₂ dsɨ₂juɨ₅ le₂jaun₂ jme₁ca₂gue₃ Judas i₁ŋí'₄ jaun₂, ca₂'í₃ i₂së₃dsen₃ të₂dsɨ́₅. Jaun₂ në́₃ ca₂juá'₂ Jesús: ―A₂jaun₂ a₂niog₅ 'au'₂ jmó'₂, jmo₄ në₃ cón'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","La₁ lia'₂ 'i₁jan₂ i₂tián'₅ guë́'₅ ne₄ mesa tsá₃ ca₂rë₃ŋɨ́'₂ 'e₂ 'uɨg₅₄ ca₂juá'₂ Jesús ca₂tsɨ́'₃ Judas le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ia₁ jme₁niog₅ gu₂ Judas 'éi₂ nɨ₁lau₂ tio'₅₄ cu₄; jaun₂ ca₂lɨn₃ i₂lɨn₅₄, a₂ca₂juá'₂ Jesús tsɨ́'₅ 'éi₂ a₂cha₂ jme₁lá₃ quió'₅ jmɨg₄, o₃ jme₃'oin₅₄ ca₂la₂ cu₄ dsa₂ te₂ŋé₂ 'e₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jaun₂ dsɨ₂juɨ₅ jme₁ma₂në₂gue₃ 'éi₂ i₁ŋí'₄, o₂'ɨ́in₃. Jme₁ma₂ca₂nei₂ bá₄ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jme₁ma₂o₂'ɨ́n₃ Judas jaun₂, ca₂juá'₂ Jesús: ―Në₃ në́₃, jë₁ma₂le₃jniá₂ juɨ₅bí₂ jlá'₁ quió'₅ Jaun₅ dsa₂ mɨ₂güɨ́g₃; ján₃ bá₄ le₃jniá₂ juɨ₅bí₂ quió'₅ Diú₄, ja₁con₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chi₂jua'₂ le₃jnia₅ juɨ₅bí₂ quió'₅ Diú₄ ja₁con₂ 'éi₂, Diú₄ në́₃, jme₃jnia₅ juɨ₅bí₂ jlá'₁ quió'₅ Ja₁ŋi'₅₄ ja₁con₂ 'ŋiog₅, ton'₂ jme₃jniai₂₃ ŋi'₅₄ ta₁. ");
INSERT INTO cntNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","'Nia'₂ chi'₂-guein₂ quiáng₃, tsá₃ ma₂uë́₂ 'en₅₄ jniá₂ jɨn'₄ 'nia'₂. Qui₁'nau'₅₄ 'nia'₂ jniá₂; la₁ juɨ₁lia'₂ ma₂ca₂juɨ́g₂ jniá₂ dsa₂ judíos, ján₃ bá₄ le₂jaun₂ juɨ́g₂ jniá₂ 'nia'₂ në́₃: tsá₃ lé₂ o₁nó'₅ 'nia'₂ ja₁né'₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Caun₂ 'éi'₃ 'mɨ́₂ la₂ cuë́₄ jniá₂ 'nia'₂: a₂jme₁'nió'₄ 'nia'₂ rɨ́ng'₂ le₂jang'₂ le₂jang'₂. Juɨ₁lia'₂ ca₂jme₁'nió₄ jniá₂ 'nia'₂, 'nia'₂ në́₃ 'nió'₅ jme₁'nió'₄ 'nia'₂ rɨ́ng'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Le₂në₅ bá₄ le₃ŋi₅ ca₂le₃jɨ́n₃ dsa₂ a₂lɨ́n'₅ 'nia'₂ dsa₂ i₂ma₂ca₂rë₃tɨ́n₃ quiáng₃: në₁jua'₂ caun₂ qui₂ca₂jme₁'nió'₄ 'nia'₂ rɨ́ng'₂ le₂jang'₂ le₂jang'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jaun₂ ca₂ŋag₃ Si₂mu₅₄ Pe₄ ca₂ŋɨ́i'₃ Jesús: ―Te₁gui'₅₄, ¿a₂já'₄ guang'₅₄? Jaun₂ ca₂ŋag₃ Jesús: ―Ja₁né'₄ jniá₂, tsá₃ lé₂ le₃'éin'₄. La₁ 'éin'₄ bá₄ 'nia'₂ cang₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Jaun₂ në́₃ ca₂juá'₂ Pe₄ ca₂tsɨ́'₃ Jesús: ―Te₁gui'₅₄, ¿'e₂ lë₃ tsá₃ lé₂ le₃'éin₄ jniá₂ të₂në₃? Ma₂chan₂ co₂jŋia₅₄ bá₄ jniá₂ a₂gue₅₄ 'mú₃ o₄quián'₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jaun₂ ca₂ŋag₃ Jesús: ―¿Dsón'₂ ma₂'ei₅ caun₂ 'au'₂ a₂gue'₂ 'mú₃ o₄quió₃ jniá₂? A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'ne₂, né'₃ guë́₄ a₂'o₃ të₁guí₄ dsó₂, hora jaun₂ dé₄ tsá₃ tón'₄ 'ne₂ a₂cuɨg'₂ jniá₂, ta₁'nɨ₅ ráun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Tsá₃ lë₁can₂ 'nia'₂ o₂i₁ 'au'₂. Juɨ₁lia'₂ 'én'₂ 'nia'₂ të₂le₃ quió'₅ Diú₄, ján₃ bá₄ le₂jaun₂ juɨ₁le₂'én'₂ 'nia'₂ të₂le₃ quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ja₁quió'₄ Ŋe'₃, 'lióng₂ dsi₂néi₂ cha₂ a₂jo₂; jua'₅₄ mei'₂ guë́₃ tsá₃ le₂jaun₂ në́₃, ¿lɨ́n'₂ 'nia'₂ a₂jme₁juɨg₅₄ jniá₂ 'nia'₂ a₂nég'₄ i₁jmo₃ co₂jŋia₅₄ dsi₂néi₂ quián'₂ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cang₂ jë₁ma₂dsián'₃ jniá₂, jë₁ma₂ca₂lë₃ jmo₂₃ co₂jŋia₅₄ ja₁o₁tión'₂ 'nia'₂, jaun₂ bá₄ guio₅₄ táng₃ a₂i₁te₁₂ 'nia'₂ ja₁cong₂, ia₁jaun₂ ja₁i₁'ú₃ jniá₂, ján₃ bá₄ lé₂ o₁tión'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ŋi'₅₄ bá₄ 'nia'₂ a₂já'₄ né'₄ jniá₂; cuɨn'₂ bá₄ 'nia'₂ juɨ₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jaun₂ ca₂juá'₂ To₁má₄: ―Te₁gui'₅₄, tsá₃ ne₄ jnia'₅₄ a₂já'₄ guang'₅₄; ¿'a₂ guë'₂ lia'₂ le₃cuag₅ jnia'₅₄ juɨ₅? ");
INSERT INTO cntNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jaun₂ ca₂ŋag₃ Jesús: ―Jniá₂ bá₄ lɨ́ng₅ juɨ₅, ján₃ bá₄ lɨ́ng₅ jág₁ dsau₅, ján₃ bá₄ lɨ́ng₅ i₂jmo₅ a₂le₃chan₂ dsa₂. 'I₁jan₂ tsá₃ dsióg₄ ja₁con₂ Ŋe'₃ jua'₅₄ tsá₃ të₂le₃ quian'₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jua'₅₄ mei'₂ guë́₃ dsón'₂ ŋi'₅₄ 'nia'₂ 'ein₂ lɨ́n₅ jniá₂, ján₃ bá₄ jme₁le₃cuɨn'₂ 'nia'₂ Ŋe'₃ ján₃; jaun₂ në₃ në́₃, të₂le₃ ne₄ juɨ₅, le₃cuɨin'₂ 'nia'₂, ton'₂ ma₂jɨin'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jaun₂ në́₃ ca₂juá'₂ Fe₂li₄ ca₂tsɨ́'₃ Jesús: ―Te₁gui'₅₄, cuë₄ jmɨg₄ a₂jɨn₄ jnia'₅₄ Ŋéi'₅, jaun₂ co₂jaun₂ guë́₄ dsáu₅ dsɨ₅ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jaun₂ ca₂ŋag₃ Jesús: ―¿Tsa₁ cuɨg'₂ 'ne₂ jniá₂ Fe₂li₄, o₁jŋia'₅₄ ma₂ŋó₅ jmɨg₄ 'en₅₄ jniá₂ quian'₅₄ 'nia'₂? Chi₂jua'₂ 'ein₂ dsa₂ ma₂jág₂ jniá₂, ján₃ bá₄ ma₂jɨ́in₂ Ŋe'₃. ¿'A₂ bá₄ lia'₂ juá'₂ 'ne₂: “Cuë₄ jmɨg₄ a₂jɨn₄ jnia'₅₄ Ŋéi'₅”? ");
INSERT INTO cntNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tsa₁ 'én'₂ 'ne₂ a₂'en₅₄ jniá₂ ja₁con₂ Ŋe'₃, ton'₂ 'en₅₄ guë'₂ Ŋe'₃ táng₃ ja₁con₂ jniá₂? Juɨ₁lia'₂ jág₁ a₂juɨ́g₂ jniá₂ 'nia'₂, tsá₃ juá'₅ jniá₂ o₄quió₃ 'ŋió₃. Të₂le₃, Ŋe'₃ jniá₂ i₂të₁'ŋiá₄ ja₁con₂ jniá₂, i₂'éi₂ bá₄ jmo₅ ta₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Juɨ₁le₂'én'₂ bá₄ 'nia'₂ a₂juá'₅ jniá₂, a₂'eng₅₄ ja₁con₂ Ŋe'₃, a₂'en₅₄ guë'₂ Ŋe'₃ ja₁con₂ jniá₂; o₃ në₁jua'₂ tsá₃ le₂jaun₂, jmá'₃ lia'₂ të₂le₃ quian'₅₄ léi₄ a₂jmo₂₃, juɨ₁le₂'én'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, juɨ₁lia'₂ i₂'én₂ le₃quió₃ jniá₂, ján₃ bá₄ jmo₃ juɨ₁lia'₂ a₂jmo₅ jniá₂; jaun₂ të₂le₃ 'ŋio₅ guë́₄ juë'₂ a₂jmo₃, ia₁ nég'₄ ja₁con₂ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Jaun₂ chi₂jua'₂ 'e₂ a₂mɨ'₂ 'nia'₂ lia'₂ con'₂ lë́₅ 'éi'₃ quió₃ jniá₂, jmo₅₄ bá₄ jniá₂, ia₁jaun₂ le₃juɨn'₂ Jmei₂ o₄quió'₄ Ja₁ŋi'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Lé₂ bá₄ mɨ́'₁ 'nia'₂ lia'₂ con'₂ lë́₅ 'éi'₃ quió₃ jniá₂, chi₂jua'₂ 'e₂ caun₂ a₂'niog'₂ 'nia'₂, jaun₂ jmo₅₄ bá₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Chi₂jua'₂ 'nióg'₃ 'nia'₂ jniá₂, nei₂ gau₂ 'éi'₃ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jaun₂ mɨ₅₄ jniá₂ ne₄ Ŋe'₃ a₂cuiɨn₃ jan₂ i₂sián'₂ i₂cuë́'₃ bí₂ 'au'₂ 'nia'₂, ia₁jaun₂ 'í₂ 'éi₂ co₂tan₅₄ quian'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jme₂dsí₂ quió'₅ jág₁ tí₅ bá₄ 'éi₂. Tsá₃ lé₂ le₃guei₃ dsa₂ mɨ₂güɨ́g₃, ia₁ tsá₃ jág₂, on₃ guë'₂ cuɨg₂₃ cuɨin₂₃ 'éi₂. La₁ 'nia'₂ në́₃, ma₂cuɨin'₂ bá₄ 'nia'₂, ia₁ guá₅ ja₁con'₂ 'nia'₂, ton'₂ të₃'ŋiái₄ le₃quián'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","On₃jua'₅₄ a₂tén₄ jniá₂ 'nia'₂ co₂ŋei'₅₄ në₂jag₄ bá₄ chi'₂ 'nág₂. Guio₅₄ bá₄ táng₃ ja₁con'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tsá₃ ma₃uë́₂ jág₂ dsa₂ mɨ₂güɨ́g₃ jniá₂, la₁ia₁ jag'₅₄ bá₄ 'nia'₂. 'Uɨg₅₄ ia₁ a₂chan₂ jniá₂, le₃chang'₂ bá₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jmɨg₄ jaun₂ le₃len'₅₄ 'nia'₂ a₂'en₅₄ jniá₂ ja₁con₂ Ŋe'₃, 'nia'₂ guë'₂ tiong'₅₄ ja₁con₂ jniá₂, jaun₂ jniá₂ guë'₂ në́₃ 'eng₅₄ ja₁con'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Juɨ₁lia'₂ i₂gue₅, i₂né'₂ 'éi'₃ quió₃, 'éi₂ bá₄ i₂të₃dsón'₂ 'nio₃ jniá₂. Juɨ₁lia'₂ i₂'nio₃ jniá₂ në́₃, jme₃'nio₃ Ŋe'₃. Ján₃ bá₄ le₂jaun₂ jniá₂ jme₁'niói₄, jaun₂ jme₁jnia₅ jniá₂ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jaun₂ ca₂juá'₂ Judas, (on₃jua'₅₄ Iscariote): ―Te₁gui'₅₄, ¿'e₂ lë₃ ja₁con₂ jnia'₅₄ jme₁jnag'₅, on₃jua'₅₄ rë'₂ ja₁con₂ dsa₂ mɨ₂güɨ́g₃? ");
INSERT INTO cntNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jaun₂ ca₂ŋag₃ Jesús: ―Juɨ₁lia'₂ i₂'nio₃ jniá₂, tón'₂ bá₄ juɨ₅ jág₁ quió₃; jaun₂ jme₃'nio₃ Ŋe'₃ jme₃'nioi₃ 'éi₂, jaun₂ qui₂ja₁náu₄ jnia'₅₄ ja₁coin₂ ja₁'io₁ quian'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Juɨ₁lia'₂ i₂tsá₃ 'nio₃ jniá₂, tsá₃ tón'₂ juɨ₅ jág₁ quió₃. Jág₁ a₂nag'₂ 'nia'₂ la₂, on₃jua'₅₄ a₂quió₃, a₂quió'₅ Ŋe'₃ i₂ca₂chei₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ca₂le₃jë́₃ a₂la₂ juá'₅ jniá₂ juɨ́g₂ 'nia'₂ të₁lia'₂ 'eng₅₄ guë́₄ quian'₅₄ 'nia'₂; ");
INSERT INTO cntNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","la₁ia₁ i₂cuë₃ bí₂ 'au'₂ 'nia'₂ 'éi₂, i₂lɨ́n₅ Jme₂dsí₂ Jŋió₅, i₂chen₃ Ŋe'₃ o₄quió₃ jniá₂, 'éi₂ bá₄ jme₃tag₅ jme₃tɨin₂₃ 'nia'₂, jaun₂ jmo₃ a₂qui₃dsiog'₂ 'au'₂ 'nia'₂ ca₂le₃jë́₃ 'e₂ a₂ma₂qui₂ma₂juɨ́g₂ jniá₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’'Ág'₅ jniá₂ jág₁ a₂jmo₃ 'ag₃ tei₄ ja₁con'₂ 'nia'₃. A₂tei₄ a₂'ei₅ ja₁con₂ jniá₂, a₂jaun₂ bá₄ cuë́₅ jniá₂ 'nia'₂. La₁ on₃jua'₅₄ lia'₂ cuë₅ dsa₂ mɨ₂güɨ́g₃, cuë́₅ jniá₂ 'nia'₂. Tsá₃ lë₁can₂ 'nia'₂ o₂i₁ dsɨ₅, on₃ guë'₂ jmó'₂ 'nia'₂ gang'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ma₂qui₂ma₂nei'₂ 'nia'₂ a₂juá'₅ jniá₂: a₂nég'₄, jaun₂ guio₅₄ táng₃ ja₁con'₂ 'nia'₂. Në₁jua'₂ të₃dsón'₂ 'nióg'₃ 'nia'₂ jniá₂, jme₁jmó'₂ 'nia'₂ 'io'₂ jme₁ca₂rë₃ŋi'₅₄ 'nia'₂ a₂né'₄ jniá₂ ja₁con₂ Ŋe'₃, ia₁ i₂juɨn'₂ guë́₄ 'éi₂ lia'₂ con'₂ guë́₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jaun₂ ma₂juɨ́g₂ jniá₂ 'nia'₂ a₂la₂ të₃jŋiá₅, ia₁jaun₂ le₃'én'₂ 'nia'₂ jë₁ma₂të́₂ rë₁lé₂ a₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Tsá₃ ma₂'lióng₂ jág₁ dsia₅₄ jniá₂ quian'₅₄ 'nia'₂; ia₁ ma₂já₅ i₂gon₂ mɨ₂güɨ́g₃ la₂, o₁jŋia'₅₄ tsá₃ 'e₂ juɨ₅bí₂ 'io₅ 'éi₂ ja₁con₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","La₁ia₁ 'nió'₅ le₃ŋi₅ dsa₂ mɨ₂güɨ́g₃, a₂'nió₃ jniá₂ Ŋe'₃, jaun₂ lia'₂ con'₂ lë́₅ 'éi'₃ a₂ma₂cuë₃ Ŋe'₃ jniá₂, a₂jaun₂ bá₄ jmo₅ jniá₂. 'Nau₂ 'nia'₂. Ma₃dsau'₅₄ jniog₄ ja₁lá₃. ");
INSERT INTO cntNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Jniá₂ lɨ́ng₅ cho'₅₄ nɨ₁uɨng₂ uvas, ja₁já₅ bí₂ dsón'₂. Ŋe'₃ guë'₂ lɨ́n₅ i₂jmo₅ 'í₁ ja₁nau₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jŋiá'₂ 'éi₂ ca₂le₃jë́₃ nɨ₁gu'₂ quió₃ a₂tsá₃ mɨ́g₂ 'ag₅; la₁ia₁ qui₂jɨ́'₅ qui₂'uɨin₂₃ nɨ₁gu'₂ a₂'ag₅ mɨ́g₂, ia₁jaun₂ ráu₃ guë́₄ 'lióng₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma₂le₁jɨ́n'₃ bá₄ 'nia'₂ të₂le₃ quian'₅₄ jág₁ a₂qui₂ma₂juɨ́g₂ jniá₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Caun₂ juɨ₁të₂'ŋiá'₄ bá₄ 'nia'₂ ja₁con₂ jniá₂, juɨ₁lia'₂ të₂'ŋiá₄ jniá₂ ja₁con'₂ 'nia'₂. 'I₁caun₂ nɨ₁gu'₂ tsá₃ lé₂ le₃'ag₃ mɨ́g₂ con'₂ 'ŋiog₅ le₂jaun₂, në₁jua'₂ tsá₃ rë₂tsán'₂ quian'₅₄ cho'₅₄; ján₃ bá₄ le₂jaun₂ juɨ₁lia'₂ 'nia'₂ në́₃, tsá₃ 'e₂ lé₂ le₃ráu₃ quián'₂ 'nia'₂ në₁jua'₂ tsá₃ të₂'ŋiág'₄ ja₁con₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Jniá₂ lɨ́ng₅ cho'₅₄; 'nia'₂ guë'₂ lɨ́ng'₅ gu'₂ nei'₅₄. Juɨ₁lia'₂ dsa₂ i₂të₂'ŋiá₄ rë₂tsán'₂ quian'₅₄ jniá₂, juɨ₁lia'₂ të₂'ŋiá₄ jniá₂ ja₁con₂ 'éi₂, 'lióng₂ ráu₃ quió'₅. Ia₁ 'i₁caun₂ tsá₃ 'e₂ lé₂ le₃jmó'₂ 'nia'₂ jua'₅₄ tsá₃ quiong'₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Juɨ₁lia'₂ i₂tsá₃ të₂'ŋiá₄ ja₁con₂ jniá₂, lɨ́in₅ në₂jag₄ bá₄ caun₂ nɨ₁gu'₂ a₂dsɨ₂guia'₂ dsa₂ cau₅, jaun₂ rë₂quein₂. Nɨ₁gu'₂ le₂në₅ qui₂cág'₅ dsa₂, qui₂tó'₅ dsa₂ dsi₂si₂, jaun₂ cau₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Chi₂jua'₂ të₂'ŋiá'₄ 'nia'₂ ja₁con₂ jniá₂, ton'₂ të₂'ŋiá₄ jág₁ quió₃ ja₁con'₂ 'nia'₂, jaun₂ mɨ₄ 'nia'₂ chi₂jua'₂ 'e₂ caun₂ 'niog'₂, jaun₂ guéi'₁ bá₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Le₂la₂ bá₄ rë₂juɨn'₂ Ŋe'₃: a₂qui₂ráu₂ 'lióng₂ 'e₂ a₂jmo'₂ 'nia'₂. Le₂në₅ jme₂jniá'₂ 'nia'₂ a₂lɨ́ng'₅ dsa₂ i₂ca₂rë₃tɨ́n₃ quián₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Juɨ₁lia'₂ 'nio₃ Ŋe'₃ jniá₂, ján₃ bá₄ le₂jaun₂ 'nió₃ jniá₂ 'nia'₂; caun₂ juɨ₁i₂nio₄ bá₄ 'nia'₂ juɨ₅ a₂'nió₃ jniá₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Në₁jua'₂ caun₂ né'₂ 'nia'₂ gau₂ 'éi'₃ quió₃, le₂në₅ të₃'ŋiá'₄ 'nia'₂ juɨ₅ a₂'nió₃ jniá₂ 'nia'₂, juɨ₁lia'₂ caun₂ nag₅ jniá₂ gau₂ 'éi'₃ quió'₅ Ŋe'₃, ton'₂ të₂'ŋiá₄ jniá₂ juɨ₅ a₂'nio₃ 'éi₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Jág₁ në₅ ma₂në₂juɨ́g₂ jniá₂ 'nia'₂ ia₁jaun₂ a₂ŋɨ́₄ lë₃ jéin₅ jniá₂ 'io'₂, cuë́₄ jniá₂ 'nia'₂, ia₁jaun₂ le₃'ŋia₅ bá₄ a₂jén'₂ 'nia'₂ 'io'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","A₂la₂ bá₄ 'éi'₃ quió₃: a₂jme₁'nió'₄ 'nia'₂ rɨ́ng'₂ le₂jang'₂ le₂jang'₂, juɨ₁lia'₂ ma₂ca₂jme₁'nió₄ jniá₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","'I₁jan₂ tsá₃ lé₂ le₃'nio₃ guë́₄ lɨn₃ rɨin'₅₄, lia'₂ con'₂ guë́₄ i₂guein₅ 'mú₃ o₄quió'₄ a₂mei₅₄ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","'Nia'₂ bá₄ lɨ́ng'₅ dsa₂ a₂mei₅₄ quiáng₃ chi₂jua'₂ jmo'₂ 'nia'₂ 'e₂ te₂nei'₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tsá₃ ma₃të́₅ jniá₂ 'nia'₂ dsa₂ i₂jme₂ti₃ ne₃, ia₁ tsá₃ ŋi₅ juɨ₁lia'₂ jan₂ dsa₂ i₂jme₂ti₃ ta₁, 'e₂ a₂jmo₅ juɨg₅₄. Të́₅ jniá₂ a₂mei₅₄ quiáng₃ bá₄ 'nia'₂, ia₁ ma₂ca₂jme₁jnia₅ bá₄ jniá₂ ja₁con'₂ 'nia'₂, ca₂le₃jë́₃ 'e₂ a₂ma₂ca₂juá'₂ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","On₃jua'₅₄ 'nia'₂ ca₂quio'₅₄ jniá₂; jniá₂ bá₄ ma₂quion'₄ 'nia'₂, jaun₂ ma₂ca₂dsia₃ jniá₂ gog'₂ 'nia'₂ a₂o₁nó'₅ 'nia'₂ a₂qui₂rau₂ 'lióng₂ quián'₂ 'nia'₂ a₂jiog₃ uë́₂. Jaun₂ le₂në₅ cuë₃ Ŋe'₃ jniá₂ cuë́'₃ 'nia'₂ chi₂'e₂ caun₂ a₂mɨ́'₁ 'nia'₂ lia'₂ con'₂ lë́₅ 'éi'₃ quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","A₂la₂ bá₄ 'éi'₃ quió₃ jaun₂ në́₃: a₂jme₁'nió'₄ 'nia'₂ rɨ́ng'₂ le₂jang'₂ le₂jang'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Chi₂jua'₂ 'iog₅₄ dsa₂ mɨ₂güɨ́g₃ quián'₂ 'nia'₂, juɨ₁le₂ŋi'₅₄ 'nia'₂, jniá₂ bá₄ ca₂rë₃'iog₅₄ dsa₂ le₂'uɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jua'₅₄ mei'₂ guë́₃ lɨ́n'₅ 'nia'₂ dsa₂ i₂tén₅ mɨ₂güɨ́g₃, jme₁jme₃'nio₃ bá₄ dsa₂ mɨ₂güɨ́g₃ juɨ₁lia'₂ 'nioi₃ dsa₂ quiáin₅. La₁ 'uɨg₅₄ ia₁ a₂tsá₃ tén'₅ 'nia'₂ mɨ₂güɨ́g₃, ton'₂ ma₂quion'₄ jniá₂ 'nia'₂ jɨn₄ dsa₂ mɨ₂güɨ́g₃; 'uɨg₅₄ jaun₂ në́₃, 'ŋiai₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Dsá₂ 'au'₂ 'nia'₂ jmo₄, jág₁ a₂ma₂juɨ́g₂ jniá₂ 'nia'₂: “Lia'₂ 'i₁jan₂ dsa₂ i₂jme₂ti₃ ta₁, tsá₃ juɨin'₂ guë́₄ con'₂ guë́₄ juɨg₅₄”. Chi₂jua'₂ ma₂qui₂ca₂co₃'ein₃ dsa₂ jniá₂, ján₃ bá₄ le₂jaun₂ qui₃co₃'en₃ dsa₂ 'nia'₂; chi₂jua'₂ ma₂tón'₂ dsa₂ juɨ₅ jág₁ a₂ma₂ca₂jme₁tɨin₅ jniá₂, ján₃ bá₄ le₂jaun₂ qui₃tón'₂ dsa₂ juɨ₅ jág₁ quián'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","La₁ ca₂le₃jë́₃ a₂në₅ dsɨ₃ŋɨ́'₂ 'nia'₂ qui₃co₃jmóg'₂ dsa₂ 'uɨg₅₄ quió₃ jniá₂, ia₁ tsá₃ cuɨin₂₃ i₂ca₂chei₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tsá₃ jme₁le₃cáin'₄ jua'₅₄ mei'₂ guë́₃ tsá₃ guan₃ jniá₂ a₂o₂juá'₃ ja₁con₂ 'éi₂; la₁ në₃ në́₃, tsá₃ ma₃'e₂ lé₂ le₃juá'₂ jua'₅₄ tsá₃ ŋi₅. ");
INSERT INTO cntNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ia₁ juɨ₁lia'₂ i₂'iog₅₄ jniá₂, ján₃ bá₄ 'ŋiai₅₄ Ŋe'₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tsá₃ jme₁le₃cáin'₄ jua'₅₄ mei'₂ tsá₃ léi₄ jaun₂ ca₂jmo₃ jniá₂ jɨn₄ dsa₂ 'éi₂ a₂tsá₃ 'ein₂ sián'₂ ma₂jmo₃; la₁ia₁ o₁jŋia'₅₄ la₂ ma₂ca₂jág₃ bá₄ léi₄ jaun₂, tion₅₄ bá₄ 'iog₅₄ dsa₂ jniá₂, lia'₂ Ŋe'₃ në́₃, 'ŋiai₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","La₁ia₁ qui₂lë́₂ ia₁jaun₂ le₃ti₃ jág₁ a₂tio'₅₄ ne₄ Si₂ 'Éi'₃ quió'₅ a₂juá'₂: “Ca₂rë₃'iog₅₄ dsa₂ të₃ tsá₃ 'e₂ cha₂ lë₃.” ");
INSERT INTO cntNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’La₁ia₁ jë₁ma₂të́₂ rë₁jiá₃ i₂cuë₃ bí₂ 'au'₂ 'nia'₂, i₂tsɨn₅₄ jniá₂ ja₁con'₂ 'nia'₂ i₂jiá₃ të₂le₃ ja₁guá₄ Ŋe'₃: Jme₂dsí₂ tí₅ dsón'₂ i₂o₂'ɨn₅ ja₁con₂ Ŋe'₃, i₂'éi₂ bá₄ jáng'₃ jág₁ dsau₅ të₂le₃ quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ján₃ bá₄ le₂jaun₂ 'nió'₅ jang'₅₄ 'nia'₂ jág₁ dsau₅, ia₁ ca₂le₃'uɨg₅₄ bá₄ ma₂qui₂ma₂tión'₂ 'nia'₂ quian'₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Le₂në₅ juɨ́g₂ jniá₂ 'nia'₂ ia₁jaun₂ tsá₃ qui₃dsi₃uɨ́n'₂ 'nia'₂ a₂'éng'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Qui₃'uág'₂ dsa₂ 'uɨ́in'₂ 'nia'₂ ja₁lë₁tong'₂ ne₄ si₂ guá'₅ sinagoga, ca₂le₃jë́₃ já₅ caun₂ jmɨg₄, lɨ́n₂ juɨ₁lia'₂ i₂jme₃dsiog₅ 'nia'₂, a₂jén'₃ ta₁ jaun₂ quió'₅ ne₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ca₂le₃jë́₃ a₂në₅ jmo₃ ia₁ tsá₃ ma₂ca₂rë₃cuɨin₂₃ Ŋe'₃, on₃ guë'₂ jniá₂ ma₂ca₂rë₃cuɨg₂₃. ");
INSERT INTO cntNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jaun₂ juɨ́g₂ jniá₂ 'nia'₂ le₂në₅ ia₁jaun₂ jë₁ma₂të́₂ rë₁të₅₄ jmɨg₄ jaun₂, dsiog'₂ 'au'₂ 'nia'₂ a₂ca₂juɨ́g₂ jniá₂ 'nia'₂ jág₁ la₂. ’Tsá₃ ca₂juá'₃ jniá₂ le₂në₅ lia'₂ con'₂ le₂'uɨg₅₄, ia₁ jme₁'en₅₄ bá₄ jniá₂ quian'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","La₁ia₁ në₃ në́₃, ma₂nég'₄ i₁'ú₃ quiang'₅₄ i₂ca₂chei₃; jaun₂ lia'₂ 'i₁jan'₂ 'nia'₂ tsá₃ 'ein₂ ŋag₅: “¿A₂já'₄ guang'₅₄?” ");
INSERT INTO cntNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","La₁ qui₂ca₂tá'₂ quɨ'₂ 'au'₂ 'nia'₂ 'uɨg₅₄ ia₁ a₂në₂juɨ́g₂ jniá₂ 'nia'₂ a₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","La₁ jág₁ dsau₅ bá₄ juɨ́g₂ jniá₂ 'nia'₂: të₂le₃ a₂dse₃ quián'₂ 'nia'₂ bá₄ a₂né'₄ jniá₂. Ia₁ në₁jua'₂ tsá₃ ca₂ŋá'₃ jniá₂, tsá₃ jiá₃ i₂cuë₃ bí₂ 'au'₂ 'nia'₂; la₁ia₁ chi₂jua'₂ né'₄ jniá₂ në́₃, tsɨn₅₄ jniá₂ 'éi₂ ja₁con'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jë₁ma₂të́₂ rë₁jiá₃ 'éi₂, jme₃jniai₂₃ a₂rë₂gan₂ dsa₂ mɨ₂güɨ́g₃ cuente quió'₅ dsáu₁, quió'₅ juɨ₅ dse₃, quió'₅ a₂jáu'₅ 'í₁ ja₁coin₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Cuente quió'₅ dsáu₁, 'uɨg₅₄ ia₁ a₂tsá₃ 'éin₂ le₃quió₃ jniá₂; ");
INSERT INTO cntNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","cuente quió'₅ juɨ₅ dse₃, ia₁ a₂nég'₄ ja₁con₂ Ŋe'₃, jaun₂ tsá₃ ma₃jniá₂ jag'₅₄ 'nia'₂; ");
INSERT INTO cntNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ján₃ bá₄ cuente quió'₅ a₂jáu'₅ 'í₁, ia₁ ma₂jáu'₅ 'í₁ ja₁con₂ i₂'éi₂ i₂gon₂ mɨ₂güɨ́g₃ la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’'Lióng₂ bá₄ jág₁ cha₂ guë́₄ a₂juɨg₅₄ jniá₂ 'nia'₂, la₁ia₁ tsá₃ quɨ'₅₄ 'nia'₂ jmɨg₄ le₃ŋɨ́g'₂ jë₂ në₃. ");
INSERT INTO cntNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","La₁ jë₁ma₂të́₂ rë₁jiá₃ Jme₂dsí₂ tí₅ dsón'₂, i₂'éi₂ bá₄ jiog₃ 'nia'₂ juɨ₅ a₂tí₅ jág₁; ia₁ tsá₃ a₂jaun₂ juá'₂ 'éi₂ o₄quió'₄ 'ŋiog₅; a₂jaun₂ bá₄ juá'₂ ca₂le₃jë́₃ a₂nag₃, ton'₂ 'ë́₂ jág₁ juɨ₁lia'₂ 'e₂ niog₅ lé₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jme₃juag'₂ 'éi₂ jniá₂, ia₁ ŋei₂ juɨ₁lia'₂ a₂lë́₅ quió₃ jniá₂, jaun₂ 'éi₂ në́₃, jmo₃ jág₁ ja₁con'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ca₂le₃jë́₃ a₂cha₂ quió'₅ Ŋe'₃, ján₃ bá₄ lë́₅ quió₃ jniá₂; jaun₂ bá₄ lë₃ në₂juá'₃ jniá₂ a₂ŋe₂ 'éi₂ juɨ₁lia'₂ a₂lë́₅ quió₃ jniá₂, jaun₂ jmo₃ jág₁ ja₁con'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Ŋi'₅₄ ta₁, tsá₃ ma₃jag'₅₄ guë́₄ 'nia'₂ jniá₂; la₁ ŋi'₅₄ ta₁ bá₄, jag'₅₄ táng₃ jniá₂, ia₁ né'₄ jniá₂ ja₁con₂ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jaun₂ në́₃, qui₂ca₂ŋag₃ i₂lɨn₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ ca₂ŋɨ́i'₃ rɨin'₅₄ le₂jain₂ le₂jain₂: ―¿I₂'e₂ 'nio₃ juá'₂ a₂juá'₂ tság₅ jniog₄ le₂në₅: “Ŋi'₅₄ ta₁, tsá₃ ma₃jag'₅₄ guë́₄ 'nia'₂ jniá₂; la₁ ŋi'₅₄ ta₁ bá₄, jag'₅₄ táng₃ jniá₂, ia₁ né'₄ jniá₂ ja₁con₂ Ŋe'₃”? ");
INSERT INTO cntNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿I₂'e₂ 'nio₃ juá'₂: “Ŋi'₅₄ ta₁”? Tsá₃ ne₄ i₂'e₂ jaun₂ 'ë₂₃. ");
INSERT INTO cntNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jaun₂ ca₂rë₃lí'₄ Jesús i₂'e₂ 'nio₃ ŋag₃ tioin'₅₄, jaun₂ ca₂juá'₂: ―¿A₁qui₂ŋɨ'₄ 'nia'₂ rɨ́ng'₂ 'uɨg₅₄ ia₁ a₂në₂juá'₃ jniá₂: “Ŋi'₅₄ ta₁, tsá₃ ma₃jag'₅₄ guë́₄ 'nia'₂ jniá₂; la₁ ŋi'₅₄ ta₁ bá₄, jag'₅₄ táng₃ jniá₂”? ");
INSERT INTO cntNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, a₂tóng'₂ 'nia'₂ qui₁'áu'₂, a₂'lia'₂ 'au'₂ në́₃, të₁lia'₂ jmo₃ dsa₂ mɨ₂güɨ́g₃ 'io'₂. La₁ia₁ le₃tsɨ́n₃ bá₄ a₂'lia'₂ 'au'₂ 'nia'₂ jaun₂ a₂qui₃jmó'₂ táng₃ 'io'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Juɨ₁lia'₂ lɨ́n₅ jan₂ 'io₅₄ jë₁rë₂chan₂ guein₂ quiain₅, 'lia'₂ dsɨ́₅ ia₁ ma₂ca₂të́₂ hora quió'₅; la₁ cang₂ jë₁ma₂ca₂rë₃chán₃ guein₂ quiáin₅, tsá₃ ma₃dsau'₂ dsɨ́₅ a₂ca₂rë₃quɨ́'₃ quió'₅, ia₁ a₂ŋɨ́₄ lë₃ 'io'₂ jén'₅, ia₁ a₂ca₂rë₃chán₃ jan₂ guein₂ mɨ₂güɨ́g₃ la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ján₃ bá₄ le₂jaun₂ 'nia'₂ në́₃; 'lia'₂ 'au'₂ 'nia'₂ rë₂në́₃, la₁ jɨng₅₄ bá₄ táng₃ 'nia'₂, jaun₂ guë́₄ në́₃ jmó'₂ 'nia'₂ 'io'₂ të₂'au'₂, a₂'lio'₂ jén'₂ 'nia'₂ jaun₂ ca₂lia'₂ 'i₁jan₂ tsá₃ 'ein₂ lé₂ le₃jŋiá'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Jmɨg₄ jaun₂ tsá₃ ma₃'e₂ qui₁ŋag'₁ 'nia'₂ jniá₂ 'i₁caun₂. A₂dsɨ₂jó'₃ juɨ́g₂ jniá₂ 'nia'₂, chi₂jua'₂ 'e₂ a₂mɨ'₂ 'nia'₂ lia'₂ con'₂ lë́₅ 'éi'₃ quió₃ jniá₂, cuë₃ bá₄ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ca₂lia'₂ jŋió₄ jmɨg₄ në₃, tsá₃ 'e₂ ma₂mɨ'₅₄ 'nia'₂ 'i₁caun₂ lia'₂ con'₂ lë́₅ 'éi'₃ quió₃. Mɨ₄ 'nia'₂, jaun₂ guéi'₁ 'nia'₂, ia₁jaun₂ le₃'ŋia₅ a₂o₂'ŋió₃ o₂jŋia₃ 'au'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Jág₁ la₂ ma₂në₂juɨ́g₂ jniá₂ 'nia'₂ quian'₅₄ jág₁ a₂jáng'₅ léi₄. La₁ jiá₃ hora a₂tsá₃ ma₃juɨg₅₄ jniá₂ 'nia'₂ quian'₅₄ jág₁ a₂jáng'₅ léi₄; lia'₂ rë₂jiá₃ jág₁ bá₄ juá'₄ jniá₂ juɨg₅₄ 'nia'₂ a₂'ɨ́ng₄ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jmɨg₄ jaun₂ mɨ́'₁ 'nia'₂ ne₄ Ŋe'₃ lia'₂ con'₂ lë́₅ 'éi'₃ quió₃ jniá₂. Tsá₃ ma₃tion₅₄ juá'₄ jniá₂ a₂mɨ₅₄ jniá₂ ne₄ Ŋe'₃ o₄quián'₂ 'nia'₂, ");
INSERT INTO cntNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ia₁ ŋiog₅ bá₄ Ŋe'₃ 'nioi₃ 'nia'₂, ia₁ 'nióg'₃ 'nia'₂ jniá₂, ia₁ ma₂ca₂rë₃'én'₂ 'nia'₂ a₂guio₃ jniá₂ ja₁con₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ca₂o₃'ɨ́n₃ jniá₂ ja₁con₂ Ŋe'₃ a₂ca₂guang₃ mɨ₂güɨ́g₃ la₂; la₁ia₁ në₃ në́₃ o₃'ɨng₅ mɨ₂güɨ́g₃ la₂, jaun₂ nég'₄ táng₃ ja₁con₂ Ŋe'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jaun₂ ca₂juá'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅: ―Në₃ guë́₄ në́₃ juá'₂ 'ne₂ lia'₂ rë₂jiá₃ jág₁; on₃jua'₅₄ quian'₅₄ jág₁ a₂jáng'₅ léi₄. ");
INSERT INTO cntNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Në₃ guë́₄ në́₃ ma₂ne₄ jnia'₅₄ a₂ŋi'₅₄ bá₄ 'ne₂ ca₂le₃jë́₃, jaun₂ tsá₃ 'e₂ 'nió'₅ quiáng'₂ jua'₅₄ tsá₃ ŋi'₅₄ 'e₂ qui₃ŋag₃ dsa₂ qui₃ŋɨ́i'₃ 'ne₂. 'Uɨg₅₄ jaun₂ 'éin₂ jnia'₅₄ a₂ŋe'₃ 'ne₂ ja₁con₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jaun₂ ca₂ŋag₃ Jesús: ―¿Dsón'₂ jua'₅₄, në₃ guë́₄ 'én'₂ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","¡Jag₄ 'nia'₂! Ma₂ja₂quián₃ hora, ton'₂ të₂në₃ dsón'₂ bá₄, a₂cuɨ́ng'₂ 'nia'₂ lé₂, a₂o₁nog'₄ tsɨ₁rë₂jang'₅₄ le₂jang'₂ le₂jang'₂ o₁nog'₄ jma₃quén₅ quiáng'₂; jaun₂ téi'₄ 'nia'₂ jniá₂ të₃tsɨng'₅₄ 'ŋió₃ lé₂. La₁ia₁ tsá₃ 'ŋió₃ jniá₂ të₃tsɨng'₅₄, ia₁ quiong'₅₄ bá₄ Ŋe'₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Juɨ́g₂ jniá₂ 'nia'₂ le₃jë́₃ a₂la₂, ia₁jaun₂ 'ag₃ tei₄ 'au'₂ 'nia'₂ le₃quió₃ jniá₂. Mɨ₂güɨ́g₃ la₂ tion₅₄ rë'₂ qui₁cán'₂ 'nia'₂ quɨ'₂ 'au'₂; la₁ia₁ tiá₂ dsia₄ 'nia'₂ 'au'₂, ia₁ ma₂ca₂tió₃ bá₄ jniá₂ ja₁con₂ mɨ₂güɨ́g₃ la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jme₁ma₂ca₂juá'₂ Jesús le₂në₅, ca₂chóg'₃ ne₅₄ guei'₅₄ i₂juɨ́g₃, jaun₂ ca₂juá'₂: ―Tia₅₄, ma₂të́₂ hora quió₃. Jme₁jnia₅ 'a₂ lia'₂ jlán'₁ ja₂ŋí'₂, ia₁jaun₂ jme₃jnia₅ ja₂ŋí'₂ 'a₂ lia'₂ jlán'₁ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ia₁ ma₂ca₂cuë'₅₄ 'éi₂ 'éi'₃ ne₄ quió'₅ ca₂le₃jɨ́n₃ dsa₂, ia₁jaun₂ jmo₃ a₂le₃chan₂ co₂tan₅₄ ca₂le₃jɨ́n₃ i₂ma₂cuɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A₂la₂ lë́₅ a₂chan₂ dsa₂ co₂tan₅₄: a₂le₃cuɨn₅ dsa₂ 'ne₂ i₂lɨ́ng'₅ i₂jan₂ tan₅₄ Diú₄ të₃dsón'₂, a₂le₃cuɨin₂₃ Jesucristo në́₃ i₂ca₂chen'₂ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ma₂ca₂jme₁jnia₅ jniá₂ ne₄ gua'₅₄ 'uë₃ la₂ 'a₂ lia'₂ jlán'₁ 'ne₂, ia₁ ma₂ca₂jme₁'ŋia₅ jniá₂ ta₁ a₂ca₂cuë'₅₄ jmo₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Në₃ në́₃, jaun₂, Tia₅₄, jmo₄ jlán'₁ jniá₂ ja₁cong'₂, juɨ₁lia'₂ jme₁lɨ́n₄ jniá₂ ja₁cong'₂ lia'₂ con'₂ né'₃ guë́₄ a₂nio₃ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ma₂ca₂jme₁jnia₅ jniá₂ ne₄ dsa₂ i₂ca₂cuag'₅₄ jniá₂ jɨn₄ dsa₂ mɨ₂güɨ́g₃, i₂'ein₂ lɨ́n'₅ 'ne₂. I₂quiáng'₂ bá₄ jme₁lɨ́in₄, jaun₂ ma₂ca₂cuag'₅₄ jniá₂; ma₂qui₂ca₂'í₃ të₂dsɨ́₅ 'éi₂ jág₁ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma₂ca₂rë₃ŋi₅ 'éi₂, ca₂le₃jë́₃ a₂ca₂cuë'₅₄ jniá₂ já₅ ja₁con'₂ 'ne₂; ");
INSERT INTO cntNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ia₁ ma₂ca₂cuë́₃ bá₄ jniá₂ jág₁ jaun₂ a₂ca₂cuë'₅₄ 'ne₂ jniá₂, jaun₂ ca₂gue₃ bá₄ 'éi₂ në́₃. Ma₂ca₂rë₃ŋi₅ lia'₂ con'₂ tí₅ jág₁, ja₁con'₂ 'ne₂ bá₄ o₂'ɨ́n₃ jniá₂, ton'₂ ca₂rë₃'éin₂ a₂ca₂chei'₂ 'ne₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’O₄quió'₄ 'éi₂ bá₄ mɨ₅ jniá₂, on₃jua'₅₄ o₄quió'₄ dsa₂ mɨ₂güɨ́g₃. O₄quió'₄ dsa₂ i₂ca₂cuag'₅₄ bá₄ mɨ₅ jniá₂, ia₁ i₂quiáng'₂ 'ne₂ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ia₁ ca₂le₃jɨ́n₃ dsa₂ quiáng₃, ján₃ bá₄ quiáng'₂ 'éi₂; ton'₂ ca₂le₃jɨ́n₃ dsa₂ quiáng'₂ në́₃, i₂quiáng₃ bá₄ 'éi₂ ján₃, jaun₂ rë₂jniá₂ a₂jlán'₁ jniá₂ të₂le₃ quian'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Tsá₃ ma₃jan₄ jniá₂ mɨ₂güɨ́g₃ la₂; la₁ia₁ 'éi₂ në́₃ të₂'ŋiái₄ mɨ₂güɨ́g₃, jaun₂ nég'₄ ja₁con'₂ 'ne₂. Tia₅₄ Jŋió₅, jmo₄ 'í₁ 'éi₂ i₂ma₂cuag'₅₄ quian'₅₄ juɨ₅bí₂ a₂lɨ́ng'₅, ia₁jaun₂ ca₂ne₅₄ bá₄ léin₂ co₂tan₅₄, juɨ₁lia'₂ lág₅ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lia'₂ con'₂ jme₁'en₅₄ jniá₂ quiang'₅₄ 'éi₂ mɨ₂güɨ́g₃ la₂, ma₂qui₂ma₂jmo₃ jniá₂ 'í₁ i₂ma₂cuag'₅₄ quian'₅₄ juɨ₅bí₂ a₂lɨ́ng'₅. Ma₂qui₂ma₂jmo₃ jniá₂ 'í₁, jaun₂ lia'₂ 'i₁jan₂ 'éi₂ tsá₃ ca₂i₃cón'₅, jŋia'₅₄ lia'₂ jan₂ bá₄ i₂'i₄ 'éi'₃ dsɨ₃'én₂, ia₁jaun₂ le₃ti₃ Si₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Në₃ në́₃, nég'₄ ja₁cong'₂; la₁ia₁ të₁lia'₂ 'eng₅₄ guë́₄ mɨ₂güɨ́g₃, juá'₅ jniá₂ jág₁ la₂ ia₁jaun₂ le₃'ŋia₅ ja₁con₂ 'éi₂ a₂'io'₂ jéin₅ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma₂ca₂cuë́₃ bá₄ jniá₂ jág₁ quiáng'₂, la₁ia₁ dsa₂ mɨ₂güɨ́g₃ në́₃, 'iog₅₄ quió'₅, ia₁ tsá₃ tén₅ 'éi₂ mɨ₂güɨ́g₃, juɨ₁lia'₂ jniá₂ në́₃, tsá₃ téng₅ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","On₃jua'₅₄ rë'₂ mɨ₅ jniá₂ jua'₅₄ a₂'uɨin'₅₄ mɨ₂güɨ́g₃, a₂jaun₂ bá₄ mɨ₅ jniá₂ a₂jmó'₂ 'í₁ ia₁jaun₂ tsá₃ jo₃ i₂së₃dsen₃. ");
INSERT INTO cntNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tsá₃ mɨ₂güɨ́g₃ téin₅, juɨ₁lia'₂ jniá₂ në́₃, tsá₃ téng₅ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Chon₄ dsa₂ 'éi₂ të₂le₃ quian'₅₄ jág₁ tí₅; ia₁ jág₁ quiáng'₂ bá₄ lë́₅ jág₁ tí₅. ");
INSERT INTO cntNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Juɨ₁lia'₂ ca₂chei'₂ 'ne₂ jniá₂ jɨn₄ dsa₂ mɨ₂güɨ́g₃, ján₃ bá₄ le₂jaun₂ tsɨn₅₄ jniá₂ 'éi₂ jɨn₄ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","O₄quió'₄ 'éi₂ bá₄ tsón₄ jniá₂ 'ŋio₃, ia₁jaun₂ ján₃ bá₄ le₂jaun₂ 'éi₂ në₃, lé₂ rë₂tsoin₅₄ le₃quió'₅ jág₁ tí₅. ");
INSERT INTO cntNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’La₁ia₁ on₃jua'₅₄ jmá'₃ o₄quió'₄ 'éi₂ mɨ₅ jniá₂; ján₃ bá₄ le₂jiog₅ o₄quió'₄ i₂le₃'én₂ le₃quió₃, të₂le₃ quian'₅₄ jág₁ quió'₅, ");
INSERT INTO cntNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ia₁jaun₂ léin₂ ca₂ne₅₄ ca₂le₃jɨ́in₃, juɨ₁lia'₂ 'ne₂, Tia₅₄, 'eng'₅₄ ja₁con₂ jniá₂, ton'₂ 'en₅₄ guë'₂ jniá₂ ja₁con'₂ 'ne₂, ia₁jaun₂ 'éi₂ në́₃, dsɨ₃toin'₅₄ ja₁con₂ jniog₄, ia₁jaun₂ qui₃le₃'én₂ dsa₂ mɨ₂güɨ́g₃ a₂ca₂chei'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ma₂ca₂cuë́₃ jniá₂ 'éi₂ a₂jlá'₁ quió₃ a₂ca₂cuë'₅₄ 'ne₂ jniá₂, ia₁jaun₂ lén₂ 'éi₂ ca₂ne₅₄, juɨ₁lia'₂ lág₅ jniog₄ ca₂ne₅₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jniá₂ le₃quió'₅ 'éi₂, 'ne₂ guë'₂ le₃quió₃ jniá₂, ia₁jaun₂ le₃'ŋia₅ 'éi₂ a₂léin₂ ca₂ne₅₄, ia₁jaun₂ le₃ŋi₅ dsa₂ mɨ₂güɨ́g₃ a₂ca₂chei'₂ jniá₂, ton'₂ ca₂jme₁'nióg'₄ 'éi₂ juɨ₁lia'₂ ca₂jme₁'nióg'₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Tia₅₄, 'nio₃ jniá₂ a₂dsɨ₃ton'₅₄ 'éi₂ i₂ca₂cuag'₅₄ ja₁cong₂, ia₁jaun₂ të₃ ne₅₄ a₂jlá'₁ quió₃ a₂ca₂cuë'₅₄ 'ne₂, ia₁ ca₂jme₁'nió'₄ 'ne₂ jniá₂, né'₃ guë́₄ a₂nio₃ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tia₅₄ i₂dsen₃ guë́₄ lɨn₃, tsá₃ cuɨn₅ dsa₂ mɨ₂güɨ́g₃ 'ne₂, la₁ia₁ jniá₂ cuɨ́ng₅ 'ne₂, jaun₂ ma₂ŋi₅ bá₄ dsa₂ la₂ quiáng'₂ a₂ca₂chei'₂ 'ne₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ma₂ca₂jme₁jnia₅ jniá₂ ja₁con₂ 'éi₂ 'ein₂ lɨ́n'₅ 'ne₂, jaun₂ caun₂ jme₁jnia₅ bá₄ jniá₂ 'ne₂, ia₁jaun₂ juɨ₁lia'₂ a₂'nióg'₃ 'ne₂ jniá₂ të₃'ŋiá₄ ja₁con₂ 'éi₂, ton'₂ 'ú₄ jniá₂ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jme₁ma₂ca₂dsan₃ juá'₂ Jesús le₂në₅, ca₂o₃'ɨ́in₃ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂, qui₂ca₂'ain₃ Jɨ'₅₄ Jma₃ Cedrón. Le₂quióng₄ ja₁jaun₂, jme₁cha₂ caun₂ ja₁jme₁cha₂ nɨ₁'ma₂ 'ag₅ mɨ́g₂, ja₁ca₂'í₃ Jesús quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ján₃ bá₄ le₂jaun₂ Judas i₂jme₁ma₂'en₅₄ juɨ₅ jáng'₂ quió'₅, jme₁ma₂cuɨ́'₅ bá₄ ja₁jaun₂, ia₁ 'lióng₂ ráun₂ ca₂ŋɨ'₂ Jesús ja₁jaun₂ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jaun₂ lë₃ ca₂dsióg₃ Judas ja₁jaun₂ quiain'₅₄ co₂nió'₃ 'lióg₂, quiain'₅₄ co₂nió'₃ guë'₂ chi'₂ 'ɨ'₅₄ quián₅ guá'₅, i₂chen₄ quián₅ juɨg₅₄ jme₂dsa₂ quian'₅₄ dsa₂ fariseos në́₃. Ca₂dsi₃lén₂ dsa₂ 'éi₂ qui₂le₁quian₅ ŋi₁tág₂, nɨ₁'ma₂, quian'₅₄ si₂ nɨ₁tsɨ́₅, nɨ₁quɨ₂ a₂le₁guí'₃ si₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","La₁ia₁ Jesús në́₃, jme₁ma₂ŋi₅ bá₄ ca₂le₃jë́₃ 'e₂ a₂dsɨ₃ŋɨ́i₂, jaun₂ o₂'ɨ́in₃ ja₁jaun₂ ca₂i₁jme₁jein'₂ dsa₂, jaun₂ ca₂ŋɨ́i'₃ dsa₂ 'éi₂: ―¿I₂'ein₂ 'nag'₂ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jaun₂ ca₂ŋag₃ dsa₂ 'éi₂: ―Jesús i₂chan₂ Nazaret bá₄ 'nia'₂ jnia'₅₄. Jaun₂ ca₂ŋag₃ Jesús: ―Jniá₂ bá₄ 'éi₂. Jaun₂ bá₄ jme₁chén'₄ Judas i₂jáng'₂ quió'₅, quiain'₅₄ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jaun₂ jme₁ca₂juá'₂ Jesús ca₂tsɨ́'₃ dsa₂: “Jniá₂ bá₄ 'éi₂”, jaun₂ i₃léin₂ le₃ca'₃ i₃gain'₅₄ 'uë₃. ");
INSERT INTO cntNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jaun₂ në́₃ ca₂ŋag₃ táng₃ Jesús ca₂ŋɨ́i'₃ dsa₂ 'éi₂: ―¿I₂'ein₂ 'nag'₂ 'nia'₂? Jaun₂ ca₂ŋag₃ táng₃ dsa₂: ―Jesús i₂chan₂ Nazaret bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jaun₂ ca₂ŋag₃ táng₃ Jesús: ―Ma₂në₂juɨ́g₂ jniá₂ 'nia'₂, jniá₂ bá₄ lɨ́ng₅ 'éi₂. Chi₂jua'₂ jniá₂ 'nau'₂ 'nia'₂, cuë₄ jmɨg₄ juɨ₁dsi₂len₅ bá₄ i₂la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A₂la₂ ca₂lë₃ ia₁jaun₂ le₃ti₃ lia'₂ con'₂ lë́₅ a₂jme₁ca₂juá'₂ Jesús tsɨ́'₅ Jmei₂: “Juɨ₁lia'₂ i₂ca₂cuag'₅₄ 'ne₂ jniá₂, tsá₃ 'ein₂ ca₂i₃cón'₅ 'i₁jan₂.” ");
INSERT INTO cntNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jaun₂ në́₃ jme₁quian₅ Si₂mu₅₄ Pe₄ ŋi₁tág₂, jaun₂ ca₂dsí₃ ca₂quí'₃ rë₂gua₄ ne₁ quió'₅ jan₂ dsa₂ i₂jme₁chen₂ Malco, i₂jme₂ti₃ ta₁ ne₄ jme₂dsa₂ dsen₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","La₁ ca₂juá'₂ Jesús ca₂tsɨ́'₃ Pe₄: ―Tio'₂ táng₃ ŋi₁tág₂ ja₁jme₁'i₄. ¿'E₂ lɨ́n'₂ 'ne₂ a₂tsá₃ ca₂tɨ́n₂ jniá₂ dsɨ₃ŋɨ́g₂ a₂ma₂juá'₂ Ŋe'₃? ");
INSERT INTO cntNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jaun₂ në́₃ ca₂jŋau'₃ co₂nió'₃ 'lióg₂ lia'₂ jma₃quiain'₅₄ juɨg₅₄, quiain'₅₄ chi'₂ 'ɨ'₅₄ quián₅ guá'₅ në́₃, ca₂jŋai'₃ Jesús, jaun₂ qui₂ca₂'nei'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jaun₂ ca₂i₁jiog₃ le₂'uɨg₅₄ ja₁quió'₄ Anás. Anás 'éi₂ në́₃ jme₁lɨ́n₄ dsɨ₂jmei₂ Caifás, i₂jme₁lɨ́n₄ ta₁ jme₂dsa₂ dsen₅₄ ŋi₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás 'éi₂ në́₃ i₂jme₁ca₂juá'₂ ca₂tsɨ́'₃ dsa₂ judíos, a₂jmo₅ jón₂ jan₂ dsa₂ o₄quió'₄ dsa₂ juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jaun₂ ca₂ŋó₃ Si₂mu₅₄ Pe₄ quiain'₅₄ guë́₄ jan₂ dsa₂ i₂guia₃-tɨ́n₂ sián'₂ në́₃, chi₁co'₅₄ quió'₅ Jesús. Dsa₂ guia₃-tɨ́n₂ jan₂ 'éi₂ në́₃ jme₁cuɨg₅ bá₄ jme₂dsa₂ dsen₅₄ quió'₅, jaun₂ bá₄ ca₂'í₃ co₂lë₅ quiain'₅₄ Jesús i₁dsi₅ quió'₅ jme₂dsa₂ dsen₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","La₁ Pe₄ në́₃, jaun₂ bá₄ ca₂nau₂ o₄'né₄ të₂le₃ ca₁'né₄. 'Uɨg₅₄ jaun₂ ca₂o₃'ɨ́n₃ dsa₂ guia₃-tɨ́n₂ i₂ma₂cuɨg₅ jme₂dsa₂ dsen₅₄ quió'₅, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ 'io₅₄ i₂niog₅ ne₄ o₄'né₄, jaun₂ ca₂ŋɨ́i₂ Pe₄ të₂le₃ dsi₂néi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jaun₂ në́₃ ca₂ŋag₃ 'io₅₄ i₂jmo₅ 'í₁ o₄'né₄ ca₂ŋɨ́i'₃ Pe₄: ―On₃jua'₅₄ 'ne₂ lɨ́ng'₅ jan₂ i₂ca₂rë₃tɨ́n₃ quián₅ dsa₂ në₅, ¿lia'₅₄? Jaun₂ ca₂juá'₂: ―Jan₂'ón₄, on₃jua'₅₄ jniá₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ja₁jaun₂ jme₁tión₂ dsa₂ i₂jme₂ti₃ ta₁, quiain'₅₄ chi'₂ 'ɨ'₅₄ quián₅ guá'₅. Jme₁ma₂ca₂dsia₃ ca₂jo'₅₄ si₂, ia₁ a₂jme₁güɨ́g₂, jaun₂ tióin₂ qui₂jme₂dsioin'₂. Ján₃ bá₄ jë₄ jaun₂ jme₁chén'₄ Pe₄ jme₂dsioin'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jaun₂ ca₂ŋag₃ jme₂dsa₂ dsen₅₄ ca₂ŋɨ́i'₃ Jesús cuente quió'₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, cuente quió'₅ juɨ₁lia'₂ jág₁ a₂jme₂tag₂₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jaun₂ ca₂ŋag₃ Jesús: ―Ma₂qui₂ma₂juá'₃ bá₄ jniá₂ lia'₂ rë₂jiá₃ jág₁ të₃ne₄ ca₂le₃jɨ́n₃ dsa₂; jme₁qui₂jme₁tɨ́n₂ jniá₂ tián₂ dsa₂ dsi₂néi₂ guá'₅ sinagoga quian'₅₄ i₁dsi₅ guá'₅ templo në́₃, ja₁qui₂ŋɨ'₂ ca₂le₃jɨ́n₃ dsa₂ judíos. Tsá₃ 'e₂ jág₁ ma₂juá'₃ jniá₂ 'i₁caun₂ të₃ chi₁'ma₁. ");
INSERT INTO cntNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿'E₂ 'uɨg₅₄ ŋag'₅₄ 'ne₂ jniá₂ jaun₂? Ŋɨ'₅₄ juɨ₁lia'₂ dsa₂ i₂qui₂ma₂nág₂ jág₁ quió₃, 'e₂ ma₂juɨ́g₂ jniá₂. Jag₄ de'₂, i₂ŋi₅ bá₄ 'éi₂ juɨ₁lia'₂ i₂'e₂ jág₁ a₂ma₂juá'₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jme₁ca₂juá'₂ Jesús le₂në₅, jan₂ chi'₂ 'ɨ'₅₄ quián₅ guá'₅ i₂jme₁chén'₄ cau₅, ca₂quein₃ dsɨ₂ne₄ Jesús, jaun₂ ca₂juá'₂: ―¿Le₁në₅ bá₄ ŋag'₅₄ 'ne₂ ne₄ jme₂dsa₂ dsen₅₄? ");
INSERT INTO cntNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jaun₂ ca₂ŋag₃ Jesús: ―Chi₂jua'₂ 'lɨg'₅₄ në₂juá'₃ jniá₂, jua'₅₄, jme₁jnia₅ chi₂jua'₂ já'₄ ca₂'lian'₂ jniá₂ jaun₂. La₁ chi₂jua'₂ dsau₅ bá₄ jág₁ a₂në₂juá'₃, ¿'e₂ guë'₂ lë₃ quein'₂ quió₃? ");
INSERT INTO cntNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jaun₂ në́₃ ca₂chei₃ Anás ca₂chein₃ Jesús chi₁'ŋei'₅₄ ne₄ Caifás, i₂lɨ́n₅ jme₂dsa₂ dsen₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Të₁lia'₂ jaun₂ në́₃, jaun₂ bá₄ chén'₅ Pe₄ jme₂dsioin'₂ cau₅ si₂, jaun₂ ca₂ŋag₃ dsa₂ ca₂ŋɨ́i'₃ Pe₄: ―¿On₁jua'₅₄ 'ne₂ lɨ́ng'₅ jan₂ i₂ca₂rë₃tɨ́n₃ quián₅ dsa₂ në₅? Tsá₃ ca₂tion₃ Pe₄ jaun₂, ca₂juá'₂: ―Jan₂'ón₄. On₃jua'₅₄ jniá₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jaun₂ në́₃ ca₂ŋag₃ jan₂ i₂jme₂ti₃ ta₁ ne₄ jme₂dsa₂ dsen₅₄, i₂lɨ́n₅ jan₂ o₁rɨn'₅₄ dsa₂ i₂ca₂quí'₃ Pe₄ rë₂gua₄, ca₂juá'₂: ―¿Tsa₁ në₂jɨn₄ jniá₂ 'ne₂ ja₁cha₂ nɨ₁'ma₂ jaun₂, co₂lë₅ quian'₅₄ 'éi₂? ");
INSERT INTO cntNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Jaun₂ con'₂ siá'₂ táng₃ tsá₃ ca₂tion₃ Pe₄ a₂cuɨin₂₃ Jesús. Jaun₂ lia'₂ ma₂të₂dsi₅₄ jaun₂, ca₂'o₃ të₁guí₄ dsó₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jaun₂ në́₃ ca₂dsen₅ dsa₂ Jesús ja₁quió'₄ Caifás ca₂i₁jiog₃ të₂ ne₄ta₁ quió'₅ dsi₄má'₂. Jme₁ma₂jnia₃ mɨ₂güɨ́g₃, jaun₂ tsá₃ ca₂tón'₂ dsa₂ judíos dsi₂néi₂ ne₄ta₁ quió'₅ dsi₄má'₂, ia₁jaun₂ tsá₃ le₃'iog₅ quió'₅, ia₁ 'nio₃ jme₁guë́'₃ má₃ quió'₅ Jmɨg₄ Të₂'ɨn₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","'Uɨg₅₄ jaun₂ në́₃ ca₂o₃'ɨ́n₃ Pilato 'ŋiog₅ ja₁tion'₅₄ 'éi₂, jaun₂ ca₂juá'₂: ―¿'E₂ dso₄ bon'₄ 'nia'₂ dsa₂ la₂? ");
INSERT INTO cntNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jaun₂ ca₂ŋag₃ dsa₂: ―Jua'₅₄ mei'₂ guë́₃ tsá₃ rɨn₅ dsa₂ në₅ dso₄, tsá₃ o₄gog'₂ 'ne₂ jme₁jɨin'₅₄ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Jaun₂ në́₃ ca₂juá'₂ Pilato ca₂tsɨ́'₃ dsa₂: ―Te₅₄ 'nia'₂ jaun₂, qui₂dsɨ₅ 'nia'₂ 'éi'₃ quió'₅ lia'₂ con'₂ lë́₅ 'Éi'₃ quián'₂ 'nia'₂ guiong'₅₄. Jaun₂ ca₂ŋag₃ dsa₂ judíos: ―La₁ia₁ tsá₃ 'i₄ 'éi'₃ a₂jŋɨ́'₄ jnia'₅₄ jan₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Le₂në₅ ca₂rë₃ti₃ jág₁ a₂ca₂juá'₂ Jesús 'e₂ ne₅₄ 'mú₃ a₂dsɨ₃ŋɨ́i₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jaun₂ ca₂'í₃ táng₃ Pilato të₂le₃ dsi₂néi₂ ne₄ta₁ quió'₅, jaun₂ ca₂të́'₃ Jesús jaun₂ ca₂ŋɨ́i'₃ 'éi₂: ―¿Lɨ́n'₅ 'ne₂ Rag₅₄ quián₅ dsa₂ judíos? ");
INSERT INTO cntNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jaun₂ ca₂ŋag₃ Jesús: ―¿A₂ŋag'₅₄ 'a₂ con'₂ dsɨ₂jiog₅ 'au'₂ 'ŋiag'₂ a₂juá'₂ në₅, o₃ chan₂ i₂sián'₂ a₂ma₂juá'₂ 'ag₂₃ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Jaun₂ ca₂ŋag₃ Pilato: ―¿O₃ bá₄ dsa₂ judío lɨ́n₅ jniá₂? Dsa₂ juɨg₂ quiáng'₂, quian'₅₄ juɨg₅₄ jme₂dsa₂ bá₄ në₂jáng'₂ quiáng'₂ o₄gu₃ jniá₂. ¿'E₂ ma₂jmo'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jaun₂ në́₃ ca₂ŋag₃ Jesús: ―On₃jua'₅₄ mɨ₂güɨ́g₃ la₂ ja₁gon₂ jniá₂. Jua'₅₄ mei'₂ guë́₃ mɨ₂güɨ́g₃ la₂ ja₁gon₂ jniá₂, jme₁náu₃ 'nei₂ bá₄ dsa₂ i₂quiong'₅₄ jniá₂ ia₁jaun₂ tsá₃ jme₁jáng'₂ dsa₂ ne₄ dsa₂ judíos. La₁ on₃jua'₅₄ ja₁lá₃ ja₁gon₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jaun₂ në́₃ ca₂juá'₂ Pilato ca₂tsɨ́'₃ Jesús: ―¿Dsón'₂ bá₄ lɨ́n'₅ 'ne₂ rag₅₄ jaun₂ në́₃? Jaun₂ ca₂ŋag₃ Jesús: ―Dsau₅ bá₄ juá'₂ 'ne₂, a₂lɨ́n₅ jniá₂ rag₅₄. Ta₁ jaun₂ ca₂rë₃cháng₃, ta₁ jaun₂ guang₃ mɨ₂güɨ́g₃, ia₁jaun₂ jáng'₄ jág₁ dsau₅ o₄quió'₄ jág₁ tí₅. Ca₂le₃jɨ́n₃ i₂tión₂ le₃quió'₅ jág₁ tí₅, nag₂₃ jág₁ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jaun₂ ca₂juá'₂ Pilato ca₂tsɨ́'₃ Jesús: ―¿I₂'e₂ jaun₂ jág₁ tí₅? Jme₁ca₂dsan₃ juá'₂ Pilato le₂në₅, ca₂o₃'ɨ́in₃ táng₃, ca₂dsia₃ táng₃ jág₁ quian'₅₄ dsa₂ judíos. Jaun₂ ca₂juá'₂: ―Tsá₃ dso₄ dso'₂ jniá₂ ja₁con₂ dsa₂ la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","La₁ chí'₅ caun₂ tag₄ quián'₂ 'nia'₂ a₂tén₅ jniá₂ jan₂ dsa₂ ja₁con'₂ 'nia'₂ jme₁të₅ Jmɨg₄ Të₂'ɨn₅₄. ¿'Niog'₂ 'nia'₂ jaun₂ a₂tén₄ jniá₂ Rag₅₄ quián₅ dsa₂ judíos? ");
INSERT INTO cntNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jaun₂ në́₃, ca₂tóin'₂ co₂mɨ'₅₄ ca₂juá'₂: ―¡On₃jua'₅₄ i₂në₅! ¡Barrabás bá₄ tén₃! Barrabás 'éi₂ në́₃, jme₁lɨ́in₄ jan₂ dsa₂ 'ang₂ i₂ca₂nau₂ 'nei₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jaun₂ në́₃ ca₂jmo₃ Pilato 'éi'₃ a₂ca₂i₁ban₅ dsa₂ Jesús quian'₅₄ tsɨ₁'nei₅₄ a₂co₂taun₅. ");
INSERT INTO cntNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jaun₂ ca₂jmo₃ 'lióg₂ caun₂ nɨ₁tsag₂ corona a₂lë́₅ jméi₁ nɨ₁uɨng₂ taun₅, jaun₂ ca₂tó'₂ mɨ₂dsi₄ Jesús. Jaun₂ ca₂quen'₃ dsa₂ Jesús caun₂ tsɨ₁'mɨ'₂ chen'₅₄ a₂jniá₂ 'uɨ'₃ guéin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jaun₂ në́₃ qui₂ca₂jme₃quiáin₃ ja₁con₂ 'éi₂, a₂juá'₂: ―¡Sian'₃ 'ne₂, Rag₅₄ quián₅ dsa₂ judíos! Jaun₂ qui₂ca₂quein₃ dsɨ₂ne₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jaun₂ në́₃ o₂'ɨ́n₃ táng₃ Pilato, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂: ―Nei₂ 'nia'₂, dséin₄ jniá₂ ja₁lá₃ le₃ja₁con'₂ 'nia'₂, ia₁jaun₂ le₃len'₅₄ 'nia'₂ ca₂lia'₂ 'i₁caun₂ dso₄ tsá₃ dso'₂ jniá₂ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jaun₂ o₂'ɨ́n₃ Jesús, 'i₄ dsi₅₄ corona lë́₅ nɨ₁uɨng₂ taun₅, ján₃ bá₄ qui'₂ tsɨ₁'mɨ'₂ chen'₅₄ 'uɨ'₃ jaun₂. Jaun₂ në́₃ ca₂juá'₂ Pilato ca₂tsɨ́'₃ dsa₂: ―¡Jɨn₄ 'nia'₂ dsa₂! ");
INSERT INTO cntNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jaun₂ jme₁qui₂ca₂jág₂ juɨg₅₄ jme₂dsa₂ quian'₅₄ chi'₂ 'ɨ'₅₄ quián₅ guá'₅ në́₃, jaun₂ ca₂jme₃lióg₃ qui₂ca₂tóin'₂ co₂mɨ'₅₄, ca₂juá'₂: ―¡Tióin₃ cróg₄! ¡Tióin₃ cróg₄! Jaun₂ ca₂juá'₂ Pilato: ―Te₅₄ 'nia'₂ jaun₂, tióin₃ 'nia'₂ cróg₄ guiong'₅₄, ia₁ jniá₂ në́₃, 'i₁caun₂ dso₄ tsá₃ dso'₂ jniá₂ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","La₁ia₁ ca₂ŋag₃ dsa₂ judíos: ―Ron₅ caun₂ 'éi'₃ quián₂ jnia'₅₄, jaun₂ lia'₂ con'₂ lë́₅ juá'₂ 'éi'₃ jaun₂, a₂'nió'₅ jóin₂ bá₄; ia₁ a₂jmo₂₃ a₂lɨ́in₅ Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jme₁ca₂nág₂ Pilato jág₁ në₅, 'ŋio₅ lɨn₃ guë́₄ ca₂i₃gó'₃ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jaun₂ ca₂'í₃ táng₃ të₂le₃ dsi₂néi₂ ne₄ta₁ quió'₅, jaun₂ ca₂ŋag₃ ca₂ŋɨ́i'₃ Jesús: ―¿A₂já'₄ chan'₂ 'ne₂? La₁ tsá₃ 'e₂ ca₂ŋag₃ Jesús, 'i₁caun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jaun₂ në́₃, ca₂juá'₂ Pilato: ―¿Tsa₁ ŋag'₅₄ 'ne₂ jág₁ quió₃ jniá₂? ¿Tsa₁ ŋi'₅₄ 'ne₂ jaun₂ a₂'o₂ jniá₂ juɨ₅bí₂ a₂jmo₅₄ 'éi'₃ a₂tion₃ dsa₂ cróg₄ 'ne₂, ján₃ bá₄ le₂jaun₂ guë'₂ ján₃, a₂'o₂ jniá₂ juɨ₅bí₂ a₂long₅₄ 'ne₂? ");
INSERT INTO cntNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jaun₂ ca₂ŋag₃ Jesús: ―Ca₂lia'₂ 'i₁caun₂ juɨ₅bí₂ tsá₃ 'au'₂ 'ne₂ ja₁con₂ jniá₂, jua'₅₄ tsá₃ Diú₄ ca₂cuë₃. 'Uɨg₅₄ jaun₂, juɨ₁lia'₂ i₂në₂jáng'₂ jniá₂ ne'₅₄ 'ne₂, 'ŋio₅ lɨn₃ guë́₄ juë'₂ dso₄ rë₂cáin'₄ con'₂ guë́₄ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ca₂le₃ jaun₂ ca₂'náu'₃ dsɨ́₅ Pilato 'a₂ lia'₂ cuɨn₅ jmɨg₄ a₂jme₁lióin₂ Jesús; la₁ dsa₂ judíos në́₃ qui₂ca₂tóin'₂ co₂mɨ'₅₄ ca₂juá'₂: ―¡Në₁jua'₂ ca₂lioin'₅₄, tsá₃ lɨ́ng'₅ a₂mei₅₄ quián₅ dsɨ₂tan₅₄ emperador! ¡Ia₁ në₁jua'₂ 'ein₂ jmo₅ lɨ́in₅ rag₅₄, lɨ́in₅ jan₂ dsa₂ i₂'ŋia₅₄ emperador! ");
INSERT INTO cntNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jaun₂ në́₃ jme₁ca₂nág₂ Pilato jág₁ jaun₂, ca₂dsein₂₃ Jesús. Jaun₂ ca₂guá₂ ne₄ta₁ ja₁qui₂dsɨ₂₃ 'éi'₃; ja₁jaun₂ ja₁chei₂ Gabata quian'₅₄ jág₁ jmei₅ hebreo, co₂'nió'₄ a₂juá'₂, ja₁lë́₄ 'uë₃ cang₄. ");
INSERT INTO cntNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jme₁lë́₄ jmɨg₄ a₂jmo₅ dsa₂ co₂jŋia₅₄ Jmɨg₄ Të₂'ɨn₅₄; jme₁ma₂të́₂ con'₂ dsi₂ŋí'₃; jaun₂ ca₂juá'₂ Pilato ca₂tsɨ́'₃ dsa₂ judíos: ―¡Jɨn₄ 'nia'₂ rag₅₄ quiáng'₂! ");
INSERT INTO cntNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","La₁ ca₂tóin'₂ co₂mɨ'₅₄ ca₂juá'₂: ―¡Cau₅ jŋiai'₃! ¡Cau₅ jŋiai'₃! ¡Tióin₃ cróg₄! Jaun₂ ca₂juá'₂ Pilato: ―¿A₁'niog'₂ 'nia'₂ tóng₄ cróg₄ rag₅₄ quián'₂ 'nia'₂? La₁ qui₂ca₂ŋag₃ juɨg₅₄ jme₂dsa₂ ca₂juá'₂: ―Tsá₃ rag₅₄ sián'₂ chan₂ quián₂ jnia'₅₄, jŋia'₅₄ lia'₂ jan₂ emperador bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jaun₂ bá₄ ca₂jáng'₂ Pilato ca₂jɨ́in'₂ Jesús ia₁jaun₂ tio₃ dsa₂ ne₄ cróg₄. Jaun₂ ca₂tág₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","O₂'ɨ́n₃ Jesús jaun₂, quian₅ cróg₄ quió'₅, a₂ŋó₃ juɨ₅ ja₁të́'₂ dsa₂ Dsɨ₂con'₂ Nɨ₁mu₅ Mɨ₂dsi₄ 'Lag₄. Quian'₅₄ jág₁ jmei₅ arameo guë'₂, chei₂ Gólgota. ");
INSERT INTO cntNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ja₁jaun₂ ca₂tion₃ dsa₂ ne₄ cróg₄, ján₃ bá₄ ca₂tion₃ guë́₄ dsa₂ on₃ dsa₂ sián'₂ co₂lë₅ quian'₅₄ Jesús, jma₃jan₂ lia'₂ ca₂ton₂ quió'₅; 'ŋiog₅ guë'₂ Jesús të₁toin₅₄ dsi₂jo₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jaun₂ ca₂tióng₃ Pilato letras dsi₄ cróg₄ co₂'nió'₄ a₂juá'₂: “JESÚS CHAN₂ NAZARET, RAG₅₄ QUIÁN₅ DSA₂ JUDÍOS.” ");
INSERT INTO cntNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jaun₂ juɨn₅ dsa₂ judíos ca₂'ɨ́₂ letras jaun₂, ia₁ ma₂quián₅ chei'₅₄ juɨg₂ ciudad bá₄ ja₁ca₂tion₃ dsa₂ cróg₄ Jesús jaun₂. Jme₁chi₁ton₅ letras jaun₂ quian'₅₄ jág₁ jmei₅ hebreo, griego, quian'₅₄ jág₁ jmei₅ latín në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","'Uɨg₅₄ jaun₂, ca₂juá'₂ juɨg₅₄ jme₂dsa₂ quian'₅₄ dsa₂ judíos, ca₂tsɨ́'₃ Pilato: ―Tsá₃ lë₁taun₂ “Rag₅₄ quián₅ dsa₂ judíos”; ja₂lɨn₃ guë́₄ dse₃ taun'₅₄“I₂juá'₂ a₂lɨ́n₅ Rag₅₄ quián₅ dsa₂ judíos.” ");
INSERT INTO cntNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","La₁ ca₂ŋag₃ Pilato: ―Juɨ₁lia'₂ a₂ma₂në₂táun₂ jniá₂, co₂në₅ ma₂në₂táun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jme₁ma₂ca₂lë₃ tion₅ 'lióg₂ Jesús ne₄ cróg₄, jaun₂ ca₂can₃ tsɨ₁'mɨ'₂ quió'₅ Jesús, jaun₂ ca₂jmo₃ quén₂ dso'₅₄, jma₃jan₂ 'lióg₂ lia'₂ ca₂dso'₅₄. Ján₃ bá₄ le₂jaun₂ ca₂can₃ nɨ₁tsɨn'₅₄ Jesús. La₁ nɨ₁tsɨn'₅₄ në́₃, tsá₃ jme₁rë₂'me₅; jme₁lë́₄ caun₂ 'mɨ'₂ con'₂ lë́₅ ca₂ta₃ dsa₂, ta₁caun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jaun₂ ca₂juá'₂ 'lióg₂ ca₂tsɨ́'₃ rɨin'₅₄: ―Co₂ŋei'₅₄ tió'₅ tsá₃ guéi₃. Në₃ i₁cáu₂ co₂ŋei'₅₄ dsí₂ suerte, o₁ne₄ 'ein₂ tɨn₅₄. Jaun₂ le₂në₅ ca₂rë₃ti₃ jág₁ a₂rë₂ton₅ ne₄ Si₂ a₂juá'₂: Qui₂ca₂dsión'₂ dsa₂ tsɨ́n'₅ jniá₂ quiain'₅₄ rɨin'₅₄, ca₂co₃ ca₂dsi₂ suerte o₁ne₄ 'ein₂ tɨn₅₄. Le₂në₅ bá₄ ca₂jmo₃ 'lióg₂ 'éi₂ tioin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","La₁ chog₅₄ Jesús në́₃, jaun₂ bá₄ jme₁chéin'₄ cau₅ cróg₄, lia'₂ jma₃quian'₅₄ 'io₅₄ rɨin'₅₄, quiain'₅₄ María quián₅ Cleofas, quian'₅₄ María chan₂ Magdala në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jme₁ca₂jɨ́n₂ Jesús chog₅₄, quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ i₂ŋɨ́₄ lë₃ jme₁'nioi₃ 'éi₂, chéin'₅ cau₅, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ chog₅₄: ―'Io₅₄, në₅ chén'₅ ja₂ŋí'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jaun₂ guë́₄ ca₂juá'₂ ca₂tsɨ́'₃ dsɨ₂guia₃-tɨ́n₂ 'éi₂: ―Në₅ chén'₅ chog'₂. Ca₂le₃ jmɨg₄ jaun₂, ca₂guei₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ 'éi₂ ca₂guein₃ María dsi₂néi₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Cang₂ guë́₄ jaun₂ në́₃, ia₁ jme₁ma₂ŋi₅ bá₄ Jesús a₂ma₂ca₂rë₃'ŋia₅ ca₂le₃jë́₃, ia₁jaun₂ le₃ti₃ jág₁ tio'₅₄ ne₄ Si₂, ca₂juá'₂: ―Jmɨg₂ i₁guɨ'₁ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jë₄ jaun₂ jme₁chí'₄ caun₂ nɨ₁dsɨg₁ a₂'a₄ jmɨg₂ dsi'₃, jaun₂ ca₂tiá₂ dsa₂ caun₂ nɨ₁jau₂ 'ŋió'₃, ca₂guioin₃ quian'₅₄ jmɨg₂ dsi'₃ jaun₂. Jaun₂ ca₂chi₃dsí₂ dsa₂ nei'₅₄ caun₂ nɨ₁'ma₂ hisopo jaun₂ ca₂chóg'₃ dsa₂ të₂ mɨ₂'o₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jme₁ma₂në₂'én'₂ jmɨg₂ dsi'₃ jaun₂, jaun₂ ca₂juá'₂: ―Ma₂ca₂lë₃. Jaun₂ në́₃ ca₂sióg₂ mɨ₂dsi₅₄, ca₂jáng'₃ jme₂dsí₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jme₁lë́₄ jmɨg₄ a₂jmo₅ dsa₂ co₂jŋia₅₄ Jmɨg₄ Të₂'ɨn₅₄, jaun₂ tsá₃ 'nio₃ dsa₂ judíos jua'₅₄ lia'₂ ma₂le₁ton₅ jaun₂ nɨ₁ŋɨ₁₂ dso'₂ cróg₄ jmɨg₄ sa₅₄, ia₁ jmɨg₄ juë'₂ lɨn₃ bá₄ sa₅₄ jaun₂. 'Uɨg₅₄ jaun₂ në́₃ ca₂mɨ₃ ne₄ Pilato a₂chein₃ 'lióg₂ a₂qui₂dsɨ₃jio₅₄ dsɨ₂tag₄ 'éi₂, jaun₂ guë́₄ të₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jaun₂ në́₃ ca₂i₁len₅₄ 'lióg₂ ca₂i₁jio₂ dsɨ₂tag₄ i₂le₂'uɨg₅₄; ján₃ bá₄ le₂jaun₂ ca₂jmo₃ quian'₅₄ i₂jan₂ i₂chi₁ton₅ cróg₄ con₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","La₁ jme₁ca₂jme₃quiáin₃ con₂ Jesús, ca₂jág₃ jme₁ma₂join₂₃ bá₄; 'uɨg₅₄ jaun₂ në́₃ tsá₃ ma₂ca₂jió₃ dsɨ₂tag₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","La₁ ca₂'ág'₂ jan₂ 'lióg₂ mɨ₂dsɨ₁con₂ Jesús quian'₅₄ ŋi₁chen'₂ quió'₅, jaun₂ dsɨ₂juɨ₅ le₂jaun₂ ca₂'io₂ jmɨ₂ quian'₅₄ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jan₂ dsa₂ i₂ca₂të́₂ ne₄ i₂jáng'₅ jág₁ dsau₅ la₂; ton'₂ tí₅ bá₄ jág₁ dsau₅ a₂jáng'₅. Ján₃ bá₄ ŋi₅ dsa₂ 'éi₂ a₂juá'₂ jág₁ tí₅ të₃dsón'₂, ia₁jaun₂ le₃'én'₂ 'nia'₂ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ia₁ a₂ca₂lë₃ la₂, ca₂lë₃ ia₁jaun₂ le₃ti₃ jág₁ a₂rë₂ton₅ ne₄ Si₂ a₂juá'₂: “Lia'₂ 'i₁caun₂ mu₄ 'éi₂ tsá₃ qui₃jio₃ dsa₂.” ");
INSERT INTO cntNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Le₂jaun₂ guë'₂ táng₃ juá'₂ ne₄ Si₂ ja₁siá'₂: “Jág₂ dsa₂ jɨ́in₂ 'éi₂ i₂ca₂'ág'₂ dsa₂ quió'₅.” ");
INSERT INTO cntNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Cang₂ guë́₄ jaun₂ në́₃, ca₂mɨ₃ jan₂ dsa₂ i₂chen₂ José, i₂chan₂ juɨg₂ Arimatea, i₂jme₁lɨ́n₄ jan₂ dsa₂ i₂quián₅ Jesús, la₁ia₁ jme₁'éin₂ con'₂ të₃co'₅₄ bá₄, ia₁ a₂gain₃ dsa₂ judíos; ca₂mɨ₃ Së́₄ 'éi₂ ne₄ Dsi₄má'₂ Pilato a₂con₂ nɨ₁ŋɨ₁ 'lag₄ Jesús. Ca₂cuë₃ bá₄ Pilato jmɨg₄, jaun₂ ŋe₄ Së́₄ ca₂i₁sioin₅ 'lag₄, jaun₂ ca₂tág₃. ");
INSERT INTO cntNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ján₃ bá₄ ca₂dsióg₃ Nicodemo i₂jme₁ca₂i₁dsia₂ jág₁ le₂jŋiá₅ quian'₅₄ Jesús a₂'uë₂. Jme₁quian₅ 'éi₂ con'₂ guióg₂-guiá₂ kilos mirra quian'₅₄ áloes a₂ma₂rë₂güɨ́n'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jaun₂ ca₂tág₃ Së́₄ quiain'₅₄ Nicodemo ca₂tág₃ 'lag₄ ca₂lio₃ quian'₅₄ tsɨ₁'mɨ'₂ tióg₃ lia'₂ jma₃quian'₅₄ mɨ₂ro₂ jaun₂, lia'₂ jme₁lë́₄ tag₄ chí'₅ quió'₅ dsa₂ judíos a₂jme₁'óin₂ 'lag₄. ");
INSERT INTO cntNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Cau₅ ja₁ca₂tion₃ dsa₂ cróg₄ Jesús, jme₁lë́₄ caun₂ ja₁cha₂ nɨ₁'ma₂ a₂'ag₅ mɨ́g₂. Jaun₂ jë₄ jaun₂ jme₁dsi₅₄ caun₂ tau₂ 'ŋio₅ 'mɨ́₂ ja₁tsá₃ 'ein₂ jme₁ma₂ton'₂ dsa₂ 'i₁jan₂ 'lag₄. ");
INSERT INTO cntNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jaun₂ 'uɨg₅₄ ia₁ a₂jme₁lë́₄ jmɨg₄ a₂jmo₃ dsa₂ judíos co₂jŋia₅₄ quió'₅, ton'₂ 'uɨg₅₄ ia₁ a₂jme₁lë́₄ ma₂quián₅ jaun₂ tau₂ 'ŋio₅, jaun₂ ja₁jaun₂ ca₂quio₅ Së́₄ quian'₅₄ Nicodemo ca₂quioin₂₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jë₁le₂'uɨg₅₄ jmɨg₄ semana, ŋe₄ María chan₂ Magdala ja₁dsi₅₄ tau₂ 'ŋio₅, të₂ o₃'iog₂ të₃ qui₁né'₃ guë́₄ le₂jaun₂. Jaun₂ ca₂jág₃, jme₁ma₂rë₃jŋia'₅₄ bá₄ nɨ₁cang₁ 'o₄ tau₂ 'ŋio₅ jme₁dsióg₃. ");
INSERT INTO cntNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jaun₂ në́₃ ca₂ŋái'₃ co₂chi'₅₄ ja₁jme₁'en₅₄ Si₂mu₅₄ Pe₄ quiain'₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ jan₂ i₂ŋɨ́₄ lë₃ jme₁'nio₃ Jesús 'éi₂, jaun₂ ca₂juá'₂: ―Ma₂në₂dsen₅ dsa₂ Te₁gui'₅₄ dsi₂néi₂ tau₂ 'ŋio₅ ja₁jme₁roin₂₃, jaun₂ tsá₃ ne₄ a₂já'₄ në₂quio₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jaun₂ në́₃ Pe₄ quian'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ jan₂ 'éi₂ ca₂'uɨin₂ jaun₂ i₃léin₂ ja₁dsi₅₄ tau₂ 'ŋio₅. ");
INSERT INTO cntNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Le₃oin₃ bá₄ i₃léin₂ co₂lë₅ co₂'ei₅; la₁ i₂jan₂ 'éi₂ ca₂ŋɨ₃ guë́₄ co₂chi'₅₄ con'₂ guë́₄ Pe₄, jaun₂ jŋiái₅ bá₄ ca₂dsióg₃ ja₁dsi₅₄ tau₂ 'ŋio₅. ");
INSERT INTO cntNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jaun₂ ca₂jmo₃ i₁jɨ́in₂ ca₂ŋéi₃ ne₅₄, jaun₂ ca₂jág₃, jaun₂ bá₄ jme₁niog₅ tsɨ₁'mɨ'₂ tióg₃, la₁ia₁ tsá₃ ca₂'í₃ dsi₂néi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Jaun₂ guë́₄ ca₂dsióg₃ Si₂mu₅₄ Pe₄ chi₁co'₅₄ quió'₅, jaun₂ ca₂'í₃ dsi₂néi₂ tau₂ 'ŋio₅. Jaun₂ ca₂jág₃ 'éi₂ tsɨ₁'mɨ'₂ tióg₃: jaun₂ bá₄ jme₁niog₅ ja₁jaun₂; ");
INSERT INTO cntNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ján₃ bá₄ ca₂jág₃ pe₁guí₄ a₂ca₂lio₃ mɨ₂dsi₄ Jesús. La₁ tsá₃ jme₁ron₅ co₂lë₅ quian'₅₄ tsɨ₁'mɨ'₂ tióg₃ jaun₂; cau₅ bá₄ jme₁ron₅ jme₁rë₂jon'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jaun₂ bá₄ ca₂'í₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ jan₂ 'éi₂, i₂dsióg₃ le₂'uɨg₅₄; ca₂të́₂ ne₅₄, jaun₂ ca₂rë₃'éin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ia₁ tsá₃ jme₁ma₂ŋɨ́'₂ guë́₄ dsɨ́₅ jág₁ a₂chi₁ton₅ ne₄ Si₂, a₂tion₅₄ niog₅ jen'₅₄ Jesús jɨn₄ 'lag₄.) ");
INSERT INTO cntNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jaun₂ në́₃, i₂len₃ bá₄ táng₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ 'éi₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","La₁ jaun₂ bá₄ jme₁chén'₄ María ca₁'né₄ tau₂ 'ŋio₅, 'o₂₃. Të₁lia'₂ 'o₂₃ jaun₂, ca₂jmo₃ i₁jɨ́in₂ a₂ca₂jág₃ të₂le₃ 'ŋió'₃ tau₂ 'ŋio₅, ");
INSERT INTO cntNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","jaun₂ ca₂jɨ́in₂ on₃ ángeles i₂le₁qui'₂ 'mɨ'₂ tiog₂, tiáin'₅ jë₄ jme₁ron₅ nɨ₁ŋɨ₁ Jesús; jan₂ jme₁guá₄ të₂le₃ ja₁lë́₄ chi₁gui'₂, i₂jan₂ guë'₂ ja₁jme₁lë́₄ a₃tag₅. ");
INSERT INTO cntNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jaun₂ ca₂ŋag₃ ángeles ca₂ŋɨ́i'₃ María: ―'Io₅₄, ¿'e₂ lë₃ 'au'₂? Jaun₂ ca₂ŋag₃: ―Ia₁ ma₂në₂te₃ bá₄ dsa₂ Te₁gui'₅₄ quiáng₃, jaun₂ tsá₃ guion₄ jniá₂ a₂já'₄ në₂quio₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Jë₂ bá₄ ca₂'ŋiai₂ jág₁ në₅, jme₁ca₂jéin'₃, jaun₂ ca₂jɨ́in₂ Jesús jme₁chéin'₄; la₁ tsá₃ jaun₂ jme₁ŋi₅, Jesús bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jaun₂ në́₃ ca₂ŋag₃ Jesús: ―'Io₅₄, ¿'e₂ lë₃ 'au'₂ 'ne₂? ¿I₂'ein₂ 'nag'₂? Jaun₂, ia₁ a₂lɨ́n₂ María a₂lɨ́n₅ 'éi₂ dsa₂ i₂jmo₅ 'í₁ 'uë₃ jaun₂, jaun₂ ca₂juá'₂: ―Gui'₅₄, chi₂jua'₂ 'ne₂ ne₂te'₅₄, jua'₅₄ a₂já'₄ në₂quioin'₂, ia₁jaun₂ të₅₄ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jaun₂ ca₂juá'₂ Jesús: ―¡María! Jaun₂ ca₂jén'₃ María jaun₂ ca₂juá'₂ quian'₅₄ jág₁ jmei₅ hebreo: ―¡Raboni! ―co₂'nió'₄ a₂juá'₂: Të₅ quiáng₃. ");
INSERT INTO cntNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jaun₂ ca₂juá'₂ Jesús: ―Tsá₃ lë₁jmá'₂ quió₃, ia₁ tsá₃ ma₂uɨ́g₂ guë́₄ jniá₂ ja₁con₂ Ŋe'₃. La₁ guan'₂ o₂chei'₅₄ rɨ́n'₃ jniá₂, a₂uɨ́g₂ jniá₂ ja₁con₂ Ŋe'₃, ja₁con₂ Ŋéi'₅ 'nia'₂ në́₃, ja₁con₂ Diú₄ quiáng₃, ja₁con₂ Diú₄ quián'₂ 'nia'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jaun₂ bá₄ ŋó₃ María chan₂ Magdala 'éi₂ ca₂i₁chi'₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ a₂jme₁ma₂në₂jɨ́in₂ Te₁gui'₅₄, a₂jme₁ma₂në₂juá'₂ 'éi₂ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jme₁ca₂nei₂ jë₁le₂'uɨg₅₄ jmɨg₄ semana jaun₂ në́₃, jme₁tion'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ le₁ŋɨi'₂, qui₂le₁jnág₅ 'né₅ ja₁tioin'₅₄, ia₁ a₂gain₃ dsa₂ judíos. Jaun₂ ca₂'í₃ Jesús, jaun₂ ca₂nau₂ dsi₂jo₂ quió'₅ 'éi₂, jaun₂ ca₂juá'₂: ―Juɨ₁'ei₅ tei₄ 'au'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jme₁ma₂ca₂juá'₂ le₂në₅, ca₂'ë₃ mɨ₂gu₂ quian'₅₄ mɨ₂dsɨ₁coin₂. Jaun₂ ca₂jmo₃ 'io'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ jme₁ca₂jɨ́in₂ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jaun₂ ca₂juá'₂ táng₃ Jesús: ―Juɨ₁'ei₅ tei₄ 'au'₂ 'nia'₂. Juɨ₁lia'₂ ca₂chei₃ Ŋe'₃ jniá₂, ján₃ bá₄ le₂jaun₂ tsɨn₅₄ jniá₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jaun₂ në́₃ ca₂jéi₂ dsí₂ ne₄ quió'₅ dsa₂ 'éi₂, jaun₂ ca₂juá'₂: ―Guen'₅₄ 'nia'₂ Jme₂dsí₂ Jŋió₅. ");
INSERT INTO cntNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Chi₂jua'₂ 'ein₂ i₂ca₂'én'₃ 'nia'₂ dsáu₁, ma₂qui₂ca₂i₃'én₂ bá₄ dsáu₁ 'éi₂; chi₂jua'₂ 'ein₂ tsá₃ ca₂'én'₃ 'nia'₂ dsáu₁, të₃'ŋiá₄ dsáu₁ ja₁coin₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","La₁ To₁má₄ në́₃, jan₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ i₂të́'₂ dsa₂ Dsa₂ Tsɨn'₅₄, tsá₃ jme₁'ein₅₄ jë₄ quió'₅ rɨin'₅₄ lia'₂ con'₂ jme₁dsióg₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jaun₂ lë₃, jme₁ca₂juá'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ rɨin'₅₄: ―Ma₂në₂jɨn₄ jnia'₅₄ Te₁gui'₅₄. La₁ To₁má₄ në́₃ ca₂juá'₂: ―Në₁jua'₂ tsá₃ ca₂jág₃ jniá₂ léi₄ mɨ₂gu₂ ja₁ca₂i₃ba₅₄ mɨ₂ŋí₁, ca₂lia'₂ ca₂tiá₃ chi₁gu₃ tau₂ a₂ca₂lë₃ quian'₅₄ mɨ₂ŋí₁, ca₂lia'₂ ca₂tiá₃ mɨ₂gu₃ mɨ₂dsɨ₁coin₂, tsá₃ le₃'éng₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jŋia₃ jmɨg₄ cang₂ guë́₄ jaun₂, jme₁le₁ŋɨ'₂ táng₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ caun₂ dsi₂néi₂, le₂jaun₂ guë́₄ në́₃ jme₁'en₅₄ To₁má₄ jë₄ quió'₅ 'éi₂. Jaun₂ në́₃, o₁jŋia'₅₄ qui₂le₁jnág₅ 'né₅ ja₁tioin'₅₄, ca₂'í₃ Jesús, ca₂nau₂ dsi₂jo₂ quió'₅ 'éi₂, jaun₂ ca₂juá'₂: ―Juɨ₁'ei₅ tei₄ 'au'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jaun₂ në́₃ ca₂juá'₂ ca₂tsɨ́'₃ To₁má₄: ―'Ŋia₅ i₂tio'₂ chi₁gog'₂ ja₁lá₃, jag₄ mɨ₂gu₃; i₂tio'₂ gog'₂ mɨ₂dsɨ₁cong₂. Tsá₃ lë₁jmo₂ a₂tsá₃ 'éng'₂, juɨ₁le₂'éng'₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Jaun₂ në́₃ ca₂ŋag₃ To₁má₄: ―¡Te₁gui'₅₄ quiáng₃, Diú₄ quiáng₃ në́₃! ");
INSERT INTO cntNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jaun₂ ca₂juá'₂ Jesús: ―Në₃ guë́₄ 'éng'₂ 'uɨg₅₄ ia₁ a₂në₂jag'₅₄ jniá₂. 'E₂ guë́₄ dsen₃ juɨ₁lia'₂ dsa₂ i₂tsá₃ ca₂jág₂, la₁ 'éin₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jaun₂ në́₃, 'lióng₂ bá₄ léi₄ juë'₂ siá'₂ ca₂jmo₃ Jesús ne₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ a₂tsá₃ tio'₅₄ ne₄ si₂ la₂. ");
INSERT INTO cntNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","La₁ia₁ qui₂rë₂ton₅ a₂la₂, ia₁jaun₂ le₃'én'₂ 'nia'₂ a₂lɨ́n₅ Jesús I₂rë₂'ɨ́n₁ quián₅ Diú₄, ton'₂ lɨ́in₅ Ja₁ŋi'₅₄ Diú₄, ia₁jaun₂ jë₁ma₂qui₂ca₂rë₃'én'₂ 'nia'₂, le₃chan'₂ bá₄ 'nia'₂ co₂tan₅₄ le₃quió'₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Cang₂ guë́₄ jaun₂, ca₂jme₃jnia₅ táng₃ Jesús ne₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ chei'₅₄ Jmɨ₁ŋí'₄ Tiberias. Le₂la₂ bá₄ ca₂lë₃: ");
INSERT INTO cntNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jme₁tion'₅₄ co₂lë₅ Si₂mu₅₄ Pe₄; To₁má₄, i₂të́'₂ dsa₂ Dsa₂ Tsɨn'₅₄; Natanael i₂chan₂ juɨg₂ Caná ja₁tén₄ 'uë₃ Galilea; le₃on₃ ja₁ŋi'₅₄ Zebedeo në́₃; quiain'₅₄ on₃ guë́₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ sián'₂ quián₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Jaun₂ ca₂juá'₂ Si₂mu₅₄ Pe₄: ―Nei₅₄ i₁cháng'₃ ju₄. Jaun₂ ca₂ŋag₃ 'éi₂: ―Ján₃ bá₄ dsau₅₄ jnia'₅₄ quian'₅₄ 'ne₂. Jaun₂ i₃léin₂, ca₂uɨ́g₂ 'ŋió'₃ caun₂ tsɨ₁mu₅, la₁ a₂'uë₂ jaun₂ tsá₃ ju₄ ca₂join₃ 'i₁jan₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jme₁ca₂jnia₃ táng₃ jaun₂, jaun₂ jme₁chén'₄ Jesús chei'₅₄ jmɨ₁ŋí'₄, la₁ tsá₃ jaun₂ ŋi₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ jŋia'₅₄ Jesús bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jaun₂ në́₃ ca₂juá'₂ Jesús: ―'Nia'₂ chi'₂, ¿tsa₁ ju₄ chan₂ quián'₂ 'nia'₂? Jaun₂ ca₂ŋag₃ 'éi₂: ―Lia'₂ 'i₁jan₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jaun₂ në́₃ ca₂juá'₂ Jesús: ―Tiong₂ 'nia'₂ 'má₅ quiáng'₂ të₂le₃ gu₂ ne₁ tsɨ₁mu₅, jaun₂ join'₅₄ 'nia'₂. Jaun₂ le₂jaun₂ bá₄ ca₂jmo₃. Jme₁co₂lág₂ jaun₂ tioin'₅₄ tsá₃ lé₂ dsí₃ tsɨ₁'má₅ dsi₂jmɨg₂, ia₁ a₂ŋɨ́₄ lë₃ juɨn₅ i₁ju₁ jme₁tion'₅₄ 'ŋió'₃. ");
INSERT INTO cntNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jaun₂ në́₃ ca₂juá'₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ i₂jme₁'nio₃ Jesús guë́₄ lɨn₃, ca₂tsɨ́'₃ Pe₄: ―¡Te₁gui'₅₄ bá₄ ó₃! Jë₂ bá₄ con'₂ ca₂nág₂ Si₂mu₅₄ Pe₄, Te₁gui'₅₄ bá₄ 'éi₂, ca₂quɨ́'₂ tsɨn'₅₄ jang₄ le₃co'₅₄ (ia₁ jme₁ma₂në₂jŋiá'₂ a₂jme₁jmo₃ ta₁) jaun₂ ca₂tiáin₂ dsi₂jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Chi'₂ dsɨ₂guia₃-tɨ́n₂ rɨin'₅₄ guë'₂ në́₃, ca₂dsi₃lein₃ bá₄ të₂ chei'₅₄ jmɨ₁ŋí'₄ quian'₅₄ tsɨ₁mu₅ qui₂tsɨ₂cuɨ́n'₅ tsɨ₁'má₅, ca₂lia'₂ rë₂can'₂ ju₄. Ia₁ tsá₃ uɨ́ng₂ jme₁tioin'₅₄ ja₁lë́₄ chei'₅₄ jmɨ₁ŋí'₄: con'₂ caun₂ 'ŋiá₂-láu₂ metros bá₄ jme₁tí₄. ");
INSERT INTO cntNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jme₁ca₂sióin₃ 'uë₃ në́₃, ca₂jág₃ a₂ma₂niog₅ si₂ tá'₃, ján₃ bá₄ jme₁ma₂dsɨ́n₂ jan₂ ju₄ ne₄ si₂; ján₃ bá₄ jme₁te₁'i₁ i₁ŋí'₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jaun₂ ca₂juá'₂ Jesús: ―Jŋia₅ jan₂-on₃ ju₄ i₂lia'₂ në₂chan'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jaun₂ ca₂uɨ́g₂ Si₂mu₅₄ Pe₄ guei'₅₄ tsɨ₁mu₅. Jaun₂ ca₂tsë́'₃ tsɨ₁'má₅ ca₂të₂ chei'₅₄ jmɨg₂ lia'₂ rë₂can'₂ tion'₅₄ ju₄ ca₁can'₅₄. Con'₂ caun₂ 'ŋiá₂-lón₂ rë₂dsɨ́₂ të₂láu₃-guia₃-ún₂ (153) ju₄ jme₁tion'₅₄. La₁ o₁jŋia'₅₄ la₂ juɨn₅ ju₄ jme₁tion'₅₄, tsá₃ ca₂gag₂ bá₄ guë́₄ tsɨ₁'má₅. ");
INSERT INTO cntNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jaun₂ ca₂juá'₂ Jesús ca₂tsɨ́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂: ―I₂nó'₅ 'nia'₂ i₂qué'₂ má₃ të₂ o₃'iog₂. Jaun₂ lia'₂ 'i₁jan₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ tsá₃ tiá₂ dsɨ́₅ ŋag₃ i₂'ein₂ 'éi₂, ia₁ ŋi₅ bá₄ jaun₂ Te₁gui'₅₄ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jaun₂ në́₃ ca₂jme₃quián₃ Jesús, ca₂can₃ i₁ŋí'₄, jaun₂ ca₂cuë́'₃ chi'₂ dsɨ₂guia₃-tɨ́n₂. Ján₃ bá₄ le₂jaun₂ ca₂jmo₃ quian'₅₄ ju₄. ");
INSERT INTO cntNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A₂në₅ jë₁ca₂të́₂ 'nag'₂ ráun₂ a₂ca₂jme₃jnia₅ Jesús ne₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅ cang₂ jme₁ca₂jein'₅₄ ja₁jme₁rë₂'lɨin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cang₂ jme₁ca₂lë₃ guë́'₅ má₃ të₂ o₃'iog₂, ca₂ŋag₃ Jesús ca₂ŋɨ́i'₃ Si₂mu₅₄ Pe₄: ―Si₂mu₅₄, ja₁ŋi'₅₄ Juan₅₄, ¿dsau₅ 'nióg'₃ jniá₂ lia'₂ con'₂ guë́₄ dsa₂ tión₂ la₂? Jaun₂ ca₂ŋag₃ Pe₄: ―Ján₅, Te₁gui'₅₄. Ŋi'₅₄ bá₄ 'ne₂ jaun₂, a₂'nió₃ jniá₂ 'ne₂. Jaun₂ ca₂juá'₂ Jesús: ―Jme₁tan₅₄ guein₂ já'₂ cha'₂ quiáng₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jaun₂ ca₂ŋag₃ táng₃ Jesús jë₁ca₂të́₂ táng₃ ráun₂: ―Si₂mu₅₄, ja₁ŋi'₅₄ Juan₅₄, ¿'nióg'₃ jniá₂? Jaun₂ ca₂ŋag₃ Pe₄: ―Ján₅, Te₁gui'₅₄. Ŋi'₅₄ bá₄ 'ne₂ jaun₂ a₂'nió₃ jniá₂ 'ne₂. Jaun₂ ca₂juá'₂ Jesús: ―Jmo₄ 'í₁ já'₂ cha'₂ bë'₅₄ quiáng₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jaun₂ ca₂ŋag₃ táng₃ Jesús jë₁ca₂të́₂ 'nag'₂ ráun₂: ―Si₂mu₅₄, ja₁ŋi'₅₄ Juan₅₄, ¿'nióg'₃ jniá₂? Jaun₂ ca₂'í₃ quɨ'₂ dsɨ́₅ Pe₄ ia₁ ca₂ŋag₃ Jesús jë₁ca₂të́₂ 'nag'₂ ráun₂, “¿'nióg'₃ jniá₂?.” Jaun₂ ca₂juá'₂: ―Te₁gui'₅₄, ca₂le₃jë́₃ bá₄ ŋi'₅₄ 'ne₂. Ŋi'₅₄ bá₄ 'ne₂ jaun₂ a₂'nió₃ jniá₂ 'ne₂. Jaun₂ ca₂juá'₂ Jesús: ―Jme₁tan₅₄ já'₂ cha'₂ bë'₅₄ quiáng₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A₂dsɨ₂jó'₃ juá'₅ jniá₂, lia'₂ con'₂ jme₁lɨ́ng'₄ guë́₄ dsa₂ chi'₂, jme₁tɨng'₂ jme₁quɨ́'₂ tsɨ́ng'₂, jaun₂ jme₁góg'₂ a₂já'₄ 'niog'₂ gog'₅₄; la₁ia₁ jë₁ma₂lɨ́ng'₅ jan₂ dsa₂ ma₂guen'₂, jaun₂ nei'₅₄ gog'₂, jaun₂ i₂sián'₂ bá₄ quei'₃ tsɨ́ng'₂, jaun₂ dsɨ₃jiog₃ ja₁tsá₃ 'niog'₂ gog'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jme₁ca₂juá'₂ Jesús le₂në₅, ca₂jmo₃ jág₁ a₂'ë₂₃ 'e₂ ne₅₄ 'mú₃ a₂'i₄ 'éi'₃ dsɨ₃ŋɨ́₂ Pe₄, a₂jme₃jniai₂₃ a₂jlán'₁ Diú₄. Jaun₂ ca₂juá'₂ táng₃ ca₂tsɨ́'₃ Pe₄: ―¡'Éin₃ jniá₂! ");
INSERT INTO cntNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jme₁ca₂jén'₃ Pe₄ le₃ca'₃, ca₂jág₃ já₅ chi₁co'₅₄ quió'₅, chi'₂ dsɨ₂guia₃-tɨ́n₂ i₂'nio₃ Jesús guë́₄ lɨn₃; chi'₂ dsɨ₂guia₃-tɨ́n₂ 'éi₂ i₂jme₁guá₄ cau₅ le₃jén'₃ quió'₅ Jesús ja₁ca₂guë́'₃ má₃ të₂le₃ ca₂nei₂, ján₃ bá₄ 'éi₂ i₂ca₂ŋag₃ ca₂ŋɨ́i'₃ Jesús, jme₁ca₂juá'₂: “Te₁gui'₅₄, ¿i₂'ein₂ 'éi₂ i₂jáng'₂ quiáng'₂?” ");
INSERT INTO cntNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jaun₂ jme₁ca₂jág₃ Pe₄ ca₂jɨ́in₂ 'éi₂, ca₂ŋag₃ ca₂ŋɨ́i'₃ Jesús: ―Te₁gui'₅₄, i₂la₂ guë'₂: ¿'e₂ jén'₄? ");
INSERT INTO cntNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jaun₂ ca₂ŋag₃ Jesús: ―Chi₂jua'₂ 'nio₃ jniá₂ a₂chan₂ i₂në₅ ca₂lia'₂ jë₁ma₂guión'₃ táng₃ jniá₂, ¿'e₂ bá₄ 'uɨg₅₄ 'ne₂ 'ɨ₅ 'au'₂? La₁ia₁ 'ne₂ 'éin₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jaun₂ në́₃ ca₂i₃'ag₅₄ jág₁ në₅ jɨn₄ rɨin'₅₄ a₂tsá₃ jón₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ 'éi₂. La₁ia₁ on₃jua'₅₄ jaun₂ ca₂juá'₂ Jesús a₂tsá₃ jón₂ 'éi₂; a₂jaun₂ bá₄ ca₂juá'₂: “Chi₂jua'₂ 'nio₃ jniá₂ a₂chan₂ i₂në₅ ca₂lia'₂ jë₁ma₂guión'₃ jniá₂ táng₃, ¿'e₂ bá₄ 'uɨg₅₄ 'ne₂ 'ɨ́₅ 'au'₂?” ");
INSERT INTO cntNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Chi'₂ dsɨ₂guia₃-tɨ́n₂ 'éi₂ bá₄ la₂, i₂jáng'₅ jág₁ dsau₅ 'a₂ lia'₂ ca₂lë₃, i₂ca₂tó'₂ jág₁ la₂ ne₄ si₂ në́₃. Jaun₂ ne₄ bá₄ jniog₄, a₂tí₅ bá₄ jág₁ dsau₅ a₂jáng'₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ján₃ bá₄ cha₂ 'lióng₂ a₂siá'₂ a₂ca₂jmo₃ Jesús; jua'₅₄ mei'₂ guë́₃ dsɨ₃to'₅₄ ne₄ si₂ le₂caun₂ le₂caun₂, ca₂lia'₂ jŋia'₅₄ ta₁caun₂ mɨ₂güɨ́g₃ bá₄ tsá₃ jme₁'éi'₄ si₂ jua'₅₄ ca₂'uë́'₃ dsa₂, lɨ́n₂ jniá₂. Co₂në₅.");
INSERT INTO cntNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ne₄ si₂ a₂ca₂jmo₃ jniá₂ le₂'uɨg₅₄, gui'₅₄ Teófilo, ca₂juá'₃ jniá₂ ca₂le₃jë́₃ a₂ca₂jmo₃ Jesús ca₂le₃ ca₂jme₃lióg₃ ca₂jme₃tag₂₃, ");
INSERT INTO cntNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ca₂lia'₂ ca₂të́₂ jmɨg₄ a₂ca₂ŋái'₃ guei'₅₄ i₂juɨ́g₃. Né'₃ a₂dsáin'₃ guei'₅₄ i₂juɨ́g₃, ca₂quióin'₂ dsɨ₂guia₃-tɨ́n₂ i₂chen₄ quiáin₅, ca₂chei₃ dsɨ₂'ë́₂ jág₁. Jaun₂ ca₂cuë₃ jág₁ të₂le₃ quian'₅₄ Jme₂dsí₂ Jŋió₅, ca₂le₃jë́₃ 'e₂ 'nió'₅ jmo₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Cang₂ jme₁ca₂join₃, jme₁ma₂jein'₅₄ táng₃, ca₂ŋɨ₃ të₂láu₃ jmɨg₄ qui₂jme₂jniai₂₃ qui₂cuë́'₅ jág₁ dsau₅ chi'₂ dsɨ₂guia₃-tɨ́n₂ a₂të₃dsón'₂ bá₄ chain₂ ma₂jein'₅₄ táng₃; jaun₂ qui₂ca₂dsia₃ jág₁ quiain'₅₄ 'éi₂ juɨ₁lia'₂ 'a₂ lia'₂ lë́₅ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jme₁'en₅₄ guë́₄ Jesús quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáin₅, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ 'éi₂ a₂tsá₃ dsɨ₃lein₃ dsɨ₂juɨ₅ juɨg₂ Jerusalén. Jaun₂ ca₂juá'₂: ―Jŋia₄ 'nia'₂, juɨ₁le₂ti₃ de'₂ jág₁ quió'₅ Ŋe'₃ a₂ma₂juɨ́g₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Dsau₅ bá₄ ca₂tióg₃ Juan₅₄ ca₂tiáin₂ jmɨg₂ dsa₂, la₁ 'nia'₂ guë'₂ në́₃ tióg₂ Diú₄ Jme₂dsí₂ Jŋió₅, të₃jë₄ la₂. ");
INSERT INTO cntNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Co₂ráun₂ tion'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ le₁ŋɨi'₂ ja₁'en₅₄ Jesús, jaun₂ ca₂ŋɨ́i'₃ Jesús: ―Te₁gui'₅₄, ¿ma₂të́₂ ja₁jmó'₂ 'ne₂ a₂lión₂ dsa₂ juɨg₂ Israel? ");
INSERT INTO cntNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jaun₂ ca₂ŋag₃ Jesús: ―Tsá₃ ca₂tɨ́n'₂ 'nia'₂ le₃ŋi'₅₄ 'a₂ lia'₂ jmo₃ Diú₄ Jmei₂ 'éi'₃ ca₂le₃jë́₃ 'e₂ 'ió'₄, 'e₂ jmɨg₄ në́₃. 'Ŋiog₅ bá₄ Diú₄ Jmei₂ ŋi₅ a₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jë₁ma₂ca₂guen'₅₄ 'nia'₂ Jme₂dsí₂ quián₅ Diú₄, guéi'₁ 'nia'₂ juɨ₅bí₂, jaun₂ qui₂o₁nóg'₅ qui₂o₁'ë́'₃ jág₁ dsau₅ quió₃ juɨg₂ Jerusalén, le₂tan₅₄ juɨg₂ 'uë₃ Judea, 'uë₃ Samaria, ca₂le₃jë́₃ juɨg₂ ta₁caun₂ mɨ₂güɨ́g₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jme₁ma₂dsan₃ juá'₂ Jesús le₂në₅, ca₂uɨ́g₂ juɨ₅ guei'₅₄ i₂juɨ́g₃, ca₂ŋái'₃ ca₂lioin₂ jnei₅. ");
INSERT INTO cntNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Të₃tión₂ jaun₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ jág₅ guei'₅₄ jme₁ŋá'₃ Jesús, con'₂ tsá₃ jáin₅ jme₁ca₂jɨ́in₂ on₃ dsa₂ le₁qui'₂ 'mɨ'₂ tiog₂ jau₂, tión₂ cau₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Jaun₂ ca₂juá'₂ dsa₂ on₃ 'éi₂: ―'Nia'₂ dsa₂ chan₂ Galilea, tsá₃ ma₃ta₁ jmo₃ tión'₂ guë́₄ 'nia'₂ uë́₂ jág'₂ guei'₅₄. 'Ŋiog₅ Jesús në₅ i₂ŋá'₅ guei'₅₄ i₂juɨ́g₃ të₃jɨn'₄ 'nia'₂, le₂në₅ bá₄ jiá₃ táng₃ jë₁ma₂të́₂ rë₁jiá₃, juɨ₁lia'₂ në₂jɨin'₅₄ 'nia'₂ ŋái'₅ në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jaun₂ në́₃ ca₂'uɨin₂ má'₂ ja₁chei₂ Olivos, ca₂o₃lein₃ táng₃ juɨg₂ Jerusalén, a₂niog₅ uɨ́ng₂ con'₂ ja₁'i₄ 'éi'₃ i₃nio₄ dsa₂ jme₁jmɨg₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jme₁ca₂o₃lein₃ Jerusalén jaun₂, ca₂uɨ́g₂ cuarto guei'₅₄ ja₁ca₂jŋia₃. Dsa₂ 'éi₂ jme₁chein₂ Pe₄, Jacobo, Juan₅₄, Drë́₄, Fe₂li₄, To₁má₄, Bartolomé, Të₅₄, Jacobo ja₁ŋi'₅₄ Alfeo, Si₂mu₅₄ i₂lɨ́n₅ cananista, quian'₅₄ Judas rɨn'₅₄ Jacobo. ");
INSERT INTO cntNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ca₂le₃jɨ́in₃ le₂jaun₂ jme₁ŋɨi'₂ i₂gú'₃ co₂lë₅ quiain'₅₄ o₁rɨn'₅₄ Jesús, María chog₅₄ Jesús, ca₂le₃jɨ́n₃ guë́₄ 'io₅₄ sián'₂ në́₃, a₂jme₁tsɨ́'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Co₂ráun₂ jme₁lë́₂ con'₂ caun₂ 'ŋiá₂-lón₂ rë₂dsɨ́₂ guión₂ (120) dsa₂ 'én₂ i₂jme₁le₁ŋɨ'₂. Jaun₂ ca₂nau₂ Pe₄ të₃jë₄ jaun₂, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂: ");
INSERT INTO cntNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Rɨn'₅₄ jniog₄, co₂në₅ lë́₅ Si₂, tion₅₄ ca₂rë₃ti₃ jág₁ a₂ma₂'ë́₂ Jme₂dsí₂ quián₅ Diú₄ të₂le₃ quian'₅₄ 'lag₄ David, a₂ca₂'ɨin₃ Judas i₂ca₂jŋia₃ dsa₂ i₂ca₂i₁te₂ Jesús chi₁'ŋei'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","I₂jme₁quian'₅₄ bá₄ jniog₄ 'éi₂, jme₁lë́₄ rɨn'₅₄ jniog₄, i₂jme₁jmo₅ ta₁ le₂la₂ bá₄ 'éi₂ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","La₁ quian'₅₄ cu₄ 'lɨg'₅₄ a₂ca₂lɨ́'₃ Judas a₂ca₂'nɨi₃ Jesús, ca₂lá₃ 'uë₃. 'Uë₃ jaun₂ ca₂jmo₃ ca₂táin'₂ të₃ chi₁jɨ́in₂, qui₂ca₂'uë₂ ca₂le₃jë́₃ a₂jme₁tio'₅₄ tú'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jme₁ca₂rë₃ŋi₅ dsa₂ juɨg₂ Jerusalén, ca₂të́'₃ 'uë₃ jaun₂ Acéldama, co₂'nió'₄ a₂juá'₂: 'Uë₃ Jmɨ₂, quian'₅₄ jág₁ jmei₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ia₁ le₂la₂ juá'₂ ne₄ Si₂ Salmos: Juɨ₁të₂tsɨ'₅₄ 'ŋiog₅ 'né₅ quió'₅, ia₁ 'i₁jan₂ tsá₃ 'ein₂ le₃tian'₃. Ján₃ guë'₂ juá'₂ táng₃: Dsa₂ sián'₂ juɨ₁jmo₅₄ ta₁ a₂jme₁lɨ́in₄. ");
INSERT INTO cntNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Chan₂ bá₄ dsa₂ jë₄ la₂ quián₂ jniog₄ dsa₂ i₂ma₂ca₂jme₃quiong'₅₄ ca₂le₃jë́₃ jmɨg₄ lia'₂ con'₂ jme₁quian'₅₄ jniog₄ Te₁gui'₅₄ Jesús, ");
INSERT INTO cntNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ca₂le₃ ca₂jŋó₂ Jesús jmɨg₂ a₂ca₂cho₃ Juan₅₄, ca₂lia'₂ jme₁ca₂uɨ́g₂ Jesús guei'₅₄ i₂juɨ́g₃. Jaun₂ tion₅₄ 'nió'₅ dsa₂ 'éi₂, jme₃quiong'₅₄ jniog₄, jaun₂ jáng'₃ jág₁ dsau₅ a₂ca₂jen'₅₄ táng₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jaun₂ ca₂jmo₃ jág₁ ca₂'ɨin₃ jan₂ i₂chen₂ José i₂të́'₂ Barsabás i₂të́'₂ Justo në́₃, quian'₅₄ jan₂ i₂chen₂ Matías. ");
INSERT INTO cntNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jaun₂ ca₂tsɨ́'₃ Diú₄ ca₂le₃jɨ́in₃, ca₂juá'₂ le₂la₂: ―Te₁gui'₅₄, 'ne₂ bá₄ i₂cuɨng'₂ të₂dsɨ́₅ ca₂le₃jɨ́n₃ dsa₂, 'ɨn₅₄ jnia'₅₄ 'ein₂ dsa₂ on₃ la₂ i₂ma₂quion'₅₄ 'ne₂, ");
INSERT INTO cntNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ia₁jaun₂ jmo₃ ta₁ léin₂ chi'₂ dsɨ₂guia₃-tɨ́n₂ quiáng'₂ a₂jme₁lɨ́n₄ Judas, 'uɨg₅₄ dsáu₁ ca₂i₃'éin₂, ca₂ŋái'₃ ja₁ca₂tɨ́in₂. ");
INSERT INTO cntNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jaun₂ ca₂tóin'₂ ca₂co₃, ca₂dsi₂ jág₁. Jaun₂ i₂chen₂ Matías bá₄ ca₂tɨ́n₂ ta₁ jaun₂. Dsɨ₂juɨ₅ le₂jaun₂ bá₄ ca₂jme₃quiain'₅₄ dsa₂ guia₃-ján₃ i₂jme₁lë́₂ guë́₄ dsɨ₂guia₃-tɨ́n₂ i₂chen₄ quián₅ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jme₁ca₂të́₂ Jmɨg₄ Të₂láu₃-guiá₂, caun₂ bá₄ ja₁jme₁tion'₅₄ le₁ŋɨ'₂ ca₂le₃jɨ́n₃ dsa₂ i₂'én₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Con'₂ tsá₃ jáin₅ jme₁ca₂nág₂, ca₂lë₃ gau₂ ca₂jan₃ guei'₅₄ lia'₂ lë́₅ jë₁'ei₅ dsí₂ tiá₂ lɨn₃ ca₂lë₃, ca₂né'₂ ta₁caun₂ dsi₂néi₂ ja₁jme₁tion'₅₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jaun₂ co₂tan₅₄ dsɨ₂juɨ₅ le₂jaun₂ qui₂ca₂séi'₂ tsɨ'₄ si₂ qui₂të₁tsɨ'₅₄ ne₄ quió'₅ dsa₂ 'éi₂, le₂jain₂ le₂jain₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jaun₂ ca₂le₃jɨ́in₃ qui₂ca₂cain'₂ quian'₅₄ Jme₂dsí₂ Jŋió₅. Jaun₂ ca₂jme₃lióg₃ dsa₂ qui₂ca₂dsia₃ jág₁ jmei₅ siá'₂, lia'₂ con'₂ lë́₅ ca₂cuë₃ Jme₂dsí₂ a₂juá'₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jmɨg₄ jaun₂ jme₁tion'₅₄ dsa₂ judíos juɨg₂ Jerusalén, i₂ja₂lén₂ ta₁caun₂ mɨ₂güɨ́g₃, a₂jme₂ti₃ con'₂ tag₄ chí'₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jme₁ca₂nág₂ mɨ'₅₄ a₂ca₂lë₃ jaun₂, qui₂ca₂ŋɨ'₂ dsa₂, tsá₃ caun₂ ca₂i₃jiog₅ dsɨ́₅, ia₁ ca₂le₃jɨ́n₃ bá₄ dsa₂ 'éi₂ jma₃quén₅ qui₂ca₂nág₂ jág₁ jmei₅ quió'₅ a₂qui₂ca₂dsia₃ dsa₂ i₂tion'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jaun₂ dsɨ₃gó'₃ dsɨ́₅ 'ŋio₅ lɨn₃, qui₂ca₂dsia₃ jág₁ guioin₅₄ quiain'₅₄ rɨin'₅₄, ca₂juá'₂: ―¿On₁jua'₅₄ dsa₂ chan₂ Galilea ca₂le₃jɨ́n₃ dsa₂ i₂dsia₅ jág₁ në₅? ");
INSERT INTO cntNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿'A₂ bá₄ lia'₂ né'₂ dsia₂₃ jág₁ jmei₅ quió'₅ juɨg₂ go₄ jniog₄ le₂jau₂ le₂jau₂? ");
INSERT INTO cntNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Dsa₂ i₂tion'₅₄ ja₁lá₃ i₂chan₂ juɨg₂ Partia, dsa₂ chan₂ Media, dsa₂ chan₂ Elam, dsa₂ chan₂ Mesopotamia, i₂chan₂ Judea, i₂chan₂ Capadocia, dsa₂ chan₂ Ponto, dsa₂ chan₂ 'uë₃ Asia, ");
INSERT INTO cntNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","dsa₂ chan₂ Frigia quian'₅₄ Panfilia, dsa₂ ja₂lén₂ 'uë₃ Egipto quian'₅₄ juɨg₂ 'uë₃ Africa a₂niog₅ uɨ́ng₂ con'₂ guë́₄ Cirene. Ján₃ bá₄ tion'₅₄ dsa₂ chan₂ Roma i₂ma₂tián'₅ ja₁lá₃. I₂lɨn₅₄ 'éi₂ jme₁ma₂lɨ́n₅ judíos; i₂lɨn₅₄ guë'₂ ma₂gue₃ juá'₅ quió'₅ dsa₂ judíos. ");
INSERT INTO cntNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ján₃ bá₄ tion'₅₄ dsa₂ chan₂ 'uë₃ Creta, dsa₂ chan₂ Arabia në́₃. La₁ ca₂le₃jág₃ bá₄ jniog₄ néi₁ quian'₅₄ jág₁ jmei₅ quián₂ a₂dsia₅ dsa₂ në₅ ca₂le₃jë́₃ a₂jlá'₁ a₂'io'₂ a₂jmo₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jaun₂ 'ŋio₅ dsɨ₂gó'₃ dsɨ́₅ dsa₂, tsá₃ caun₂ qui₂ca₂'ág₂ dsɨ́₅. Jŋia'₅₄ qui₂ŋɨ́i'₅ rɨin'₅₄: ―¿'E₂ 'nió'₄ juá'₂ ca₂le₃jë́₃ a₂në₅? ");
INSERT INTO cntNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","I₂lɨn₅₄ guë'₂ tsá₃ 'éin₂, jŋia'₅₄ qui₂jmóg'₂ burlas, jaun₂ ca₂juá'₂: ―I₂le₁'en₅ bá₄ i₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jaun₂ ca₂nau₂ Pe₄ jë₄ jme₁guá₄ quiain'₅₄ guë́₄ guia₃-ján₃ chi'₂ dsɨ₂guia₃-tɨ́n₂ rɨin'₅₄. Jaun₂ ca₂juá'₂ tiá₂ ca₂tsɨ́'₃ dsa₂: ―'Nia'₂ dsa₂ chan₂ Judea quian'₅₄ ca₂le₃jɨ́ng'₃ i₂tián'₅ Jerusalén në́₃, juɨ₁le₂ŋi'₅₄ 'nia'₂ jág₁ la₂. Nei₂ 'nia'₂ dse₃ a₂juá'₄ jniá₂ la₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tsá₃ le₁'en₅ dsa₂ la₂ juɨ₁lia'₂ lɨ́n'₂ 'nia'₂, ia₁ con'₂ hora ŋí₁ ŋi₃ të₂ o₃'iog₂ bá₄ guë́₄ la₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Të₂le₃ a₂rë₂ti₃ con'₂ lë́₅ jág₁ a₂ca₂'ë́₂ Joel ma₂lɨ́g'₂, lia'₂ con'₂ jme₁ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jë₁ca₂tó'₂ jmɨg₄, juá'₂ Diú₄, tsɨng₅₄ Jme₂dsí₂ quiáng₃ jaun₂ sióin₃ ne₄ quió'₅ ca₂le₃jɨ́n₃ dsa₂ mɨ₂güɨ́g₃. Ja₂ŋí'₂ 'nia'₂, ja₁mɨ́g'₄ në́₃ qui₃dsia₃ o₄quió₃ jniá₂. Dsó₂ chi'₂ quián'₂ 'nia'₂ në́₃ a₂lë₁qui₃jág₃ 'e₂ qui₃jág₃, dsɨ₂gui'₅₄ can'₅₄ guë'₂ qui₃quɨ₃. ");
INSERT INTO cntNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jmɨg₄ jaun₂, qui₁'ɨ́ng₄ Jme₂dsí₂ quiáng₃ ne₄ quió'₅ dsa₂ ŋe'₂, dsa₂ mɨ́₂ në́₃ i₂jme₂ti₃ ta₁ ne₃, jaun₂ guë́₄ qui₃dsia₃ o₄quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Dsɨ₁ guei'₅₄ guë'₂ qui₁'ë́₄ jniá₂ dsa₂ cosas a₂dsɨ₃gó'₃ dsɨ́₅. Ne₄ gua'₅₄ 'uë₃ guë'₂ jmo₅₄ jniá₂ lé₂ léi₄, juɨ₁lia'₂ jmɨ₂, si₂, jnei₅ lë́₅ jme₁ŋi₁ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","'Iog₂ guë'₂ co₂dsia₅ le₃lia'₂. Tsɨ'₂ guë'₂ lé₂ guéin₂ lia'₂ lë́₅ jmɨ₂. Ca₂le₃jë́₃ a₂në₅ lé₂ né'₃ guë́₄ a₂guá₂ jmɨg₄ quió'₅ Te₁gui'₅₄. Jmɨg₄ jaun₂ lé₂ caun₂ jmɨg₄ juë'₂ a₂gau₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jaun₂ ca₂le₃jɨ́n₃ dsa₂ i₂mɨ₅ chi₂lén'₂ Te₁gui'₅₄, lióin₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’'Nia'₂ dsa₂ chan₂ Israel, nei₂ 'nia'₂ ca₂le₃jë́₃ a₂juá'₄ jniá₂ la₂. Jesús chan₂ Nazaret dsa₂ dsen₃ quián₅ Diú₄, i₂ca₂cuë́'₃ 'éi'₃ ca₂chein₃ jɨn'₄ 'nia'₂. Ca₂jmo₃ Diú₄ ca₂le₃jë́₃ léi₄ juë'₂, ca₂le₃jë́₃ 'e₂ dsɨ₂gó'₃ dsɨ́₅ dsa₂, qui₂ca₂jmo₃ të₂le₃ quian'₅₄ Jesús jɨn'₄ 'nia'₂. A₂ŋi'₅₄ rë₂ bá₄ 'nia'₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","La₁ jme₁ca₂jáng'₂ dsa₂ o₄gog'₂ 'nia'₂ con'₂ jme₁ma₂lë́₅ jág₁ quió'₅ Diú₄ a₂ma₂ŋi₅ le₂jŋiá₅, 'nia'₂ në́₃ ca₂chang'₂ i₂'éi₂, ca₂te'₅₄ chi₁'ŋei₂₃, ca₂i₁jɨin'₅₄ 'nia'₂ o₄gú₃ dsa₂ 'lɨn'₅₄ i₂tsá₃ ŋéi₂ dsɨ́₅. Jaun₂ ca₂jŋag'₃ ca₂tion₃ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","La₁ Diú₄ ca₂jme₃jein'₅₄ táng₃, ca₂lió₂ ne₄ 'mú₃. Ia₁ tsá₃ lé₂ jua'₅₄ a₂të₃roin₅₄ a₂rë₃join₅ co₂tan₅₄ jɨn₄ 'lag₄. ");
INSERT INTO cntNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ia₁ ca₂juá'₂ 'lag₄ Rag₅₄ David a₂'ɨin₂₃ Jesús, ca₂juá'₂: Ia₁ jɨn₄ bá₄ jniá₂ tián₂ Te₁gui'₅₄ cau₅ quió₃. 'Éi₂ bá₄ guá₅ të₂le₃ gu₃ ne₁, ia₁jaun₂ 'i₁jan₂ tsá₃ 'ein₂ lé₂ jmóg'₂ jleng₃, 'ɨ₅ dsɨ₃. ");
INSERT INTO cntNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jaun₂ lë₃, 'ŋio₅ lɨn₃ ca₂jmo₃ jniá₂ 'io'₂, jaun₂ ca₂juá'₃ quian'₅₄ le₁tsɨ'₃ jág₁ a₂jéin₅ lián'₂. Jaun₂ lë₃ tsá₃ 'ɨ₅ dsɨ₃ jë₁ma₂ca₂jon₃ nɨ₁ŋɨ₃. ");
INSERT INTO cntNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ia₁ tsá₃ cuë́'₁ jmɨg₄ a₂jŋia₃ jme₂dsí₂ quiáng₃ ja₁tion'₅₄ 'lag₄, on₃ guë'₂ cuë́'₁ jmɨg₄ a₂siá'₃ nɨ₁ŋɨ₃ jniá₂, dsa₂ jŋió₅ quiáng'₂ i₂'nióg'₃. ");
INSERT INTO cntNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ca₂'ë'₅₄ ca₂jme₁tag'₂ juɨ₅ ja₁tɨ́n'₄ jme₂dsí₂ quiáng₃. Jaun₂ jmó'₂ jéin₄ lián'₂ jë₁ma₂'eng₅₄ ja₁cong'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","'Rɨn'₅₄ jniog₄, léi₄ dsón'₂ bá₄ ca₂jon₃ tsɨ₁jon₂ jmei₂ jniog₄ David, jaun₂ ca₂'oin₃. Në₅ bá₄ chí'₅ guë'₂ tau₂ 'ŋio₅ quió'₅ quian'₅₄ jniog₄ rë₂në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","La₁ David 'éi₂ jme₁lɨ́n₄ jan₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, jaun₂ jme₁ŋi₅ rë₂ a₂ca₂cuë₃ Diú₄ jág₁ 'ɨin₂₃ 'ŋiog₅, a₂le₃chan₂ jë₄ quió'₅ ja₁ŋi'₅₄ chi'₂ dsio₅₄, jan₂ i₂lɨ́n₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄. Jaun₂ i₂'éi₂ guá₃ goin₃ ne₄ ne₄ta₁ ja₁jme₁guá₄ 'ŋiog₅ David. ");
INSERT INTO cntNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Co₂'nió'₄ a₂ma₂jág₂ bá₄ David le₂jŋiá₅, ca₂juá'₂ a₂jen'₅₄ I₂rë₂'ɨ́n₁ quián₅ Diú₄. Jaun₂ ca₂juá'₂ ján₃ a₂tsá₃ jŋia₃ jme₂dsí₂ quió'₅ jɨn₄ 'lag₄, on₃ guë'₂ dsɨ₃'én₂ nɨ₁ŋɨ₁₂ jua'₅₄ a₂siá'₃. ");
INSERT INTO cntNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ia₁ Diú₄ bá₄ ca₂jmo₃ ca₂jen'₅₄ táng₃ 'ŋiog₅ Jesús 'éi₂. Ca₂le₃jág₃ bá₄ jnia'₅₄ ca₂të́₂ ne₄, jaun₂ lë₃ cuë₂ jág₁ dsau₅. ");
INSERT INTO cntNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jaun₂ ca₂chó'₂ Diú₄ quian'₅₄ gu₂ ne₁, ca₂jme₃juag'₂. Jaun₂ Diú₄ Jmei₂ ca₂cuɨn₃ Jme₂dsí₂ quiáin₅ ca₂cuɨin₃ Jesús, lia'₂ con'₂ lë́₅ jág₁ quió'₅ ma₂cuë₃. Jaun₂ ca₂le₃jë́₃ a₂në₅ a₂ma₂jag'₅₄ a₂ma₂nei'₂ 'nia'₂, já₅ ne₄ 'éi₂ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ia₁ on₃jua'₅₄ David ca₂uɨ́g₂ guei'₅₄ i₂juɨ́g₃, ia₁ 'ŋiog₅ David ca₂juá'₃: Ca₂juá'₂ Diú₄ ca₂tsɨ́'₃ Te₁gui'₅₄ quiáng₃: “Né₂ con₂ jniá₂ të₂le₃ gu₃ ne₁, ");
INSERT INTO cntNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ca₂lia'₂ ca₂të́₂ jmɨg₄ a₂tón'₁ jniá₂ dsa₂ i₂'iog₅₄ o₄tag'₄”. ");
INSERT INTO cntNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Juɨ₁le₂ŋi₅ rë₂ ca₂le₃jɨ́n₃ dsa₂ chan₂ juɨg₂ Israel, jaun₂ tsá₃ juɨ₁'ei₅₄ caun₂-tɨn₃ dsɨ₅, ia₁ 'ŋiog₅ Jesús 'éi₂ bá₄, i₂ca₂tión'₃ 'nia'₂ cróg₄, Diú₄ në́₃ ma₂jmo₃ ma₂lɨ́in₅ lia'₂ Te₁gui'₅₄ lia'₂ rë'₂ I₂rë₂'ɨ́n₁ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jme₁ca₂nág₂ dsa₂ le₂në₅ tioin'₅₄, qui₂ca₂tá'₂ 'lia'₂ dsɨ́₅ 'ŋio₅ lɨn₃. Jaun₂ ca₂ŋɨ́i'₃ Pe₄ quiain'₅₄ chi'₂ dsɨ₂guia₃-tɨ́n₂ rɨin'₅₄ ca₂juá'₂: ―Rɨn'₅₄ jniog₄, ¿'e₂ 'nió'₅ jmó₁ jnia'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Jaun₂ ca₂ŋag₃ Pe₄: ―Jme₁tsɨ́n₄ 'nia'₂ 'au'₂, jen'₄ 'nia'₂ të₂le₃ quió'₅ Diú₄, chon₅₄ 'nia'₂ jmɨg₂ le₂jang'₂ le₂jang'₂ lia'₂ con'₂ lë́₅ 'éi'₃ quió'₅ Jesús, cuë'₅₄ léi₄ a₂qui₂ma₂'én₂ dsáu'₂ 'nia'₂. Jaun₂ guë́₄ cuɨn₃ Diú₄ Jme₂dsí₂ Jŋió₅ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jág₁ në₅ ca₂cuë₃ Diú₄ quián'₂ 'nia'₂ ca₂le₃jɨ́ng'₃, ca₂le₃jɨ́n₃ chi'₂-guein₂ quián'₂ 'nia'₂ në́₃, quian'₅₄ ca₂le₃jɨ́n₃ guë́₄ dsa₂ i₂chan₂ uɨ́ng₂. Jág₁ në₅ quió'₅ ca₂le₃jɨ́n₃ dsa₂ i₂'nio₃ Te₁gui'₅₄ Diú₄ quián₂ jniog₄ të₂. ");
INSERT INTO cntNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Quian'₅₄ jág₁ la₂, quian'₅₄ 'lióng₂ guë́₄ jág₁ siá'₂, ca₂juá'₂ Pe₄ tion₅₄ ca₂tsɨ́'₃ dsa₂: ―Lion₄ 'nia'₂ jɨn₄ dsa₂ i₂ma₂i₂cón'₅ rë₂në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jaun₂ ca₂le₃jɨ́n₃ i₂ca₂tón'₃ juɨ₅ ca₂nág₂ jág₁ dse₃ ca₂juá'₂ Pe₄, qui₂ca₂jŋói₂ jmɨg₂. Jmɨg₄ jaun₂ con'₂ 'nɨ₅ mei₅ dsa₂ i₃ton'₅₄ të₂le₃ jɨn₄ dsa₂ i₂ma₂'én₂ të₂le₃ quió'₅ Jesucristo. ");
INSERT INTO cntNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ca₂le₃jɨ́n₃ dsa₂ ca₂jŋa'₃ tiá₂ ca₂le₃jë́₃ jág₁ a₂jme₂tag₅ chi'₂ dsɨ₂guia₃-tɨ́n₂. Caun₂ bá₄ jág₁ quió'₅ ca₂jmo₃ ca₂le₃jɨ́in₃, chi₂léin'₂ Diú₄, qui₂tóin'₅ co₂lë₅, jmo₂₃ dsóg₁ i₁ŋí'₄. ");
INSERT INTO cntNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","'Ŋio₅ i₂gó'₃ dsɨ́₅ dsa₂ ca₂le₃jë́₃ léi₄ a₂qui₂ca₂jmo₃ Diú₄ të₂le₃ quian'₅₄ dsɨ₂guia₃-tɨ́n₂ i₂chen₄ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ca₂le₃jɨ́n₃ dsa₂ i₂ma₂'én₂, caun₂ bá₄ jág₁ 'ei₅ quió'₅, jaun₂ ca₂le₃jë́₃ a₂jme₁cha₂ quió'₅, jme₁lë́₄ quió'₅ ca₂le₃jɨ́n₃ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ca₂le₃jë́₃ 'e₂ cosa cha₂ quió'₅, qui₂ca₂'nag₃, jaun₂ jme₁qui₂dsió'₅ cu₄ jaun₂ 'ein₂ rɨin'₅₄ 'nió'₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ca₂le₃jë́₃ jmɨg₄ jme₁ŋɨi'₂ i₁dsi₅ guá'₅ templo. Dsi₂néi₂ quió'₅ në́₃, jme₁dsió'₅ i₁ŋí'₄ jme₁guë́'₅ co₂dsia₅, ca₂le₃jɨ́in₃ jmo₂₃ 'io'₂, caun₂ bá₄ 'ei₅ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ca₂le₃jɨ́in₃ jme₁cuë́'₅ ti₁'mag'₄ Diú₄, jaun₂ ca₂le₃jɨ́n₃ dsa₂ sián'₂ jme₁'nioi₃ dsa₂ 'éi₂. Jaun₂ ca₂le₃jë́₃ jmɨg₄ bá₄ jmo₅ Te₁gui'₅₄ caun₂ dsɨ₂juɨ́n₂ dsa₂ i₂lón₂. ");
INSERT INTO cntNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Co₂ráun₂ dsióg₃ Pe₄ quiain'₅₄ Juan₅₄ guá'₅ templo con'₂ hora ŋí₁ 'nɨ₅ të₂le₃ ca₂'láu₂, ia₁ hora jaun₂ jme₁ŋɨ'₂ dsa₂ tián₂ chi₂léin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ca₂le₃jë́₃ jmɨg₄ jme₁dsɨ₂jŋia₃ dsa₂ jan₂ dsa₂ 'lian'₂ i₂tsá₃ lé₂ ŋɨ₃, le₂jaun₂ jme₁ma₂lɨ́in₅ lia'₂ con'₂ jme₁ca₂rë₃cháin₃, jme₁dsɨ₃jiog₃ dsa₂ o₄'né₄ i₁dsi₅ guá'₅, ja₁të́'₂ dsa₂ O₄'né₄ Jlá'₁. Ja₁jaun₂ jme₁qui₂mɨ₅ dsa₂ 'lian'₂ 'éi₂ cu₄ quió'₅ dsa₂ i₂dsɨ₂lén₂ guá'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Jme₁ca₂jág₃ dsa₂ dso'₅₄ 'éi₂ ca₂ŋó₃ Pe₄ quiain'₅₄ Juan₅₄ a₂dsɨ₃toin'₅₄ i₁dsi₅ guá'₅, jaun₂ ca₂mɨ₃ cu₄ quió'₅ dsa₂ on₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Jaun₂ ca₂nau₂ Pe₄, Juan₅₄ në́₃, ca₂jɨ́in₂ dsa₂ 'éi₂. Jaun₂ ca₂juá'₂ Pe₄: ―Dse₃ jag₄ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jaun₂ guá₅ dsa₂ 'éi₂ qui₂jɨ́in₂ Pe₄ quian'₅₄ Juan₅₄, ia₁ lɨ́in₂ cuë₃ dsa₂ ca₂la₂ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","La₁ jaun₂ ca₂juá'₂ Pe₄: ―Tsá₃ cu₄tiog₂, on₃ guë'₂ cu₄nióg₄ cha₂ quió₃ cuë₅₄. La₁ con'₂ a₂cha₂ quió₃, cuë₅₄. Quian'₅₄ 'éi'₃ quió'₅ Jesucristo chan₂ Nazaret, nau₂, ŋɨ₄. ");
INSERT INTO cntNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jaun₂ ca₂jŋa'₃ Pe₄ mɨ₂gu₂ ne₁ dsa₂ 'éi₂, ca₂jme₃'o₅₄ ca₂chó'₂. Dsɨ₂juɨ₅ le₂jaun₂ ca₂rë₃bén₂ mɨ₂tag₄ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jaun₂ ca₂ráun₂ ca₂nau₂ jaun₂ ca₂jme₃lióg₃ ca₂ŋɨ₃. Jaun₂ ca₂'í₃ i₁dsi₅ guá'₅ quiain'₅₄ dsa₂ on₃ 'éi₂, qui₂ca₂ŋɨ₃ qui₂ca₂ráun₂ qui₂ca₂cuë́'₃ ti₁'mag'₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ca₂le₃jɨ́n₃ dsa₂ i₂tion'₅₄ ja₁jaun₂, ca₂jɨ́in₂ dsa₂ 'éi₂ ŋɨ₂₃ cuë́'₅ ti₁'mag'₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Jaun₂ dsɨ₂gó'₃ dsɨ́₅ 'ŋio₅ lɨn₃, ia₁ ma₂ŋɨ₂₃. Ma₂cuɨin₂₃ bá₄ dsa₂ 'éi₂ i₂gua₂ tián₂ o₄'né₄ chei₂ Jlá'₁ qui₂mɨ₂₃ cu₄. ");
INSERT INTO cntNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Caun₂ 'en₅₄ le₂jaun₂ bá₄ dsa₂ i₂jme₁'lian'₂ 'éi₂ quiain'₅₄, tsá₃ téin₂ Pe₄, Juan₅₄ në́₃. Jaun₂ ca₂i₃lén₂ co₂chi'₅₄ juɨn₅ dsa₂ dsɨ₂gó'₃ dsɨ́₅ ca₂ton₂ guá'₅ ja₁chei₂ Corredor quió'₅ Salomón, ja₁jme₁'en₅₄ Pe₄ quiain'₅₄ Juan₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Jme₁ca₂jág₃ Pe₄ le₁ŋɨ'₂ dsa₂ juɨn₅, jaun₂ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂ 'éi₂: ―'Nia'₂ dsa₂ juɨg₂ chan₂ Israel, ¿'E₂ lë₃ ŋɨ́₄ dsɨ₂gó'₃ 'au'₂ 'nia'₂? ¿'E₂ lë₃ jag'₅₄ 'nia'₂ jnia'₅₄ le₂në₅? On₃jua'₅₄ bí₂ a₂tag₂ jnia'₅₄ guio₅₄ a₂ca₂'lón₂ dsa₂ në₅ a₂ma₂lé₂ ŋɨ₃, jua'₅₄ a₂lág₅ jnia'₅₄ dsa₂ o₂dsan₂. ");
INSERT INTO cntNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","La₁ia₁ Diú₄ quián₅ tsɨ₁jon₂ jmei₂ jniog₄ Abraham, Isaac, Jacob në́₃, Diú₄ 'éi₂ ca₂jme₃juɨin'₂ 'ŋio₅ lɨn₃ Jesús ja₁ŋi'₅₄, i₂ca₂jɨn'₅₄ 'nia'₂ ne₄ dsɨ₂tan₅₄. Jme₁'nio₃ guë́₄ Dsi₄má'₂ Pilato jme₁lió₂, la₁ tsá₃ ca₂gue'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","'Nió'₄ jme₁lon'₄ 'nia'₂ dsa₂ jŋió₅ i₂tsá₃ 'e₂ dso₄ rɨn₂ 'éi₂, jë₂ bá₄ dsa₂ i₂ma₂jŋɨ'₃ dsa₂ ca₂mɨ'₅₄ 'nia'₂ lión₂. ");
INSERT INTO cntNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jaun₂ le₂në₅ ca₂jŋɨ́'₃ 'nia'₂ dsa₂ i₂cuë₅ jme₂dsí₂. La₁ Diú₄ ca₂jme₃jein'₅₄ táng₃ jɨn₄ 'lag₄, jaun₂ ca₂le₃jë́₃ a₂në₅ ca₂të́₂ ne₄ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Quian'₅₄ bí₂ quió'₅ 'ŋiog₅ Jesús 'éi₂ ca₂'lión₂ dsa₂ i₂cuɨn'₂ 'nia'₂ i₂jɨn'₄ 'nia'₂ në₅, ia₁ a₂'éin₂ jnia'₅₄ të₂le₃ quió'₅ Jesús. 'Éi₂ bá₄ në₂cuë₃ bí₂ quió'₅ dsa₂ në₅, jaun₂ ca₂'lóin₂, co₂ŋei'₅₄, juɨ₁lia'₂ jɨin'₅₄ 'nia'₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Guion₄ bá₄ jniá₂ dse₃, rɨn'₅₄ jniog₄, a₂ca₂jmo'₅₄ 'nia'₂ caun₂ jág₁ quian'₅₄ dsa₂ can'₅₄ quián'₂ 'nia'₂, a₂ca₂jŋɨ́'₃ 'nia'₂ Jesús, ca₂jmo'₅₄ 'nia'₂ le₂jaun₂ ia₁ a₂tsá₃ ŋi'₅₄ bá₄ 'nia'₂ 'e₂ jmo'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","La₁ ca₂rë₃ti₃ jág₁ a₂ma₂'ë́₂ Diú₄ le₂jŋiá₅ të₂le₃ quian'₅₄ dsa₂ i₂jme₁'ë́₂ jág₁ quiáin₅, a₂tion₅₄ ŋág₃ uɨg₅ dsa₂ I₂rë₂'ɨ́n₁ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jaun₂ në́₃, jme₁tsɨ́n₄ 'nia'₂ 'au'₂, jen'₅₄ 'nia'₂ të₂le₃ quió'₅ Diú₄, ia₁jaun₂ 'én₂ dsáu'₂ 'nia'₂. Jaun₂ bá₄ jiá₃ jmɨg₄ cuë₃ Te₁gui'₅₄ a₂le₃güɨn'₂ jme₂dsí₂ quián'₂ 'nia'₂, ");
INSERT INTO cntNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","a₂chein₃ táng₃ Jesús i₂lɨ́n₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄, i₂ma₂lë́₅ jág₁ le₂jŋiá₅ jiá₃ quián'₂ 'nia'₂, ");
INSERT INTO cntNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","o₁jŋia'₅₄ la₂ rë₂në́₃ tion₅₄ 'nió'₅ guá₃ Jesús guei'₅₄ i₂juɨ́g₃ ca₂lia'₂ ca₂jmo₃ Diú₄ rë₂ ca₂le₃jë́₃ lia'₂ con'₂ lë́₅ jág₁ ma₂'ë́₂ dsa₂ jŋió₅ quiáin₅ ma₂lɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Le₂la₂ ca₂juá'₂ 'lag₄ Moisés ca₂tsɨ́'₃ dsa₂ quián₂ jniog₄ ma₂dsi₃jo₃: “A₂chen₃ Te₁gui'₅₄ Diú₄ jan₂ dsa₂ i₂'ë́₂ jág₁ quiáin₅, i₂lɨ́n₅ dsa₂ go'₄ 'nia'₂ guiong'₅₄, juɨ₁lia'₂ ca₂chei₃ jniá₂. Jaun₂ tón'₂ 'nia'₂ juɨ₅ jme₁ti'₄ 'nia'₂ ca₂le₃jë́₃ con'₂ 'éi'₃ a₂jmo₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ia₁ ca₂le₃jɨ́n₃ i₂tsá₃ juɨ₅ tón'₂ jág₁ quió'₅ dsa₂ i₂chen₄ quiáin₅ 'éi₂, dsɨ₃'éin₂, 'uɨ́in₃ juɨg₂ Israel.” ");
INSERT INTO cntNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Jaun₂ le₂në₅ ca₂'ë́₂ Samuel jág₁ le₂'uɨg₅₄, ca₂le₃jɨ́n₃ guë́₄ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ i₂ca₂o₃lén₂ cang₂ guë́₄ jaun₂, qui₂ca₂juá'₂ lia'₂ lé₂ jmɨg₄ në₃. ");
INSERT INTO cntNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jág₁ a₂ca₂cuë₃ Diú₄ të₂le₃ quian'₅₄ dsa₂ i₂jme₁'ë́₂ jág₁ quiáin₅, ca₂cuë́'₃ 'nia'₂ bá₄. A₂dse₃ quián'₂ 'nia'₂ bá₄ ca₂jmo₃ Diú₄ caun₂ jág₁ quian'₅₄ dsa₂ can'₅₄ quián₂ jniog₄ ma₂lɨ́g'₂, juɨ₁lia'₂ ca₂tsɨ́'₃ Abraham: “Ca₂le₃jɨ́n₃ chi'₂-guein₂ dsa₂ mɨ₂güɨ́g₃ le₃chain₂ dse₃ të₂le₃ quian'₅₄ chi'₂ dsió'₂.” ");
INSERT INTO cntNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Lia'₂ con'₂ jme₁ca₂chón'₂ Diú₄ Ja₁ŋi'₅₄, ca₂chein₃ le₂'uɨg₅₄ jɨn'₄ 'nia'₂, ia₁jaun₂ jme₃gu'₅₄, ia₁jaun₂ tí'₄ 'nia'₂ le₂jang'₂ le₂jang'₂ ca₂le₃jë́₃ dso₄ qui₂'nau'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pe₄ quian'₅₄ Juan₅₄ tsá₃ ma₂dsan₃ bá₄ guë́₄ tsɨ́'₅ dsa₂ jág₁, jme₁ca₂dsi₃lén₂ jme₂dsa₂ quiain'₅₄ juɨg₅₄ chi'₂ 'ɨ'₅₄ quián₅ guá'₅, dsa₂ saduceos në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Le₁'néi₃ 'ŋio₅ lɨn₃, ia₁ jme₂tɨn₅ 'éi₂ dsa₂ a₂jen'₅₄ dsa₂ jɨn₄ 'lag₄ juɨ₁lia'₂ ca₂lë₃ léi₄ ca₂jen'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jaun₂ ca₂jŋau'₃ chi'₂ 'ɨ'₅₄ ca₂tág₃ ca₂i₁tio'₂ né'₃ 'má₃ ca₂të₂ jme₁jnia₃, ia₁ ca₂'láu₂ bá₄ jmɨg₄ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","La₁ juɨn₅ bá₄ dsa₂ i₂ca₂nág₂ ca₂rë₃'éin₂ jág₁. Con'₂ 'ŋiá₂ mei₅ dsa₂ i₂ca₂rë₃'én₂ 'éi₂, jme₁ca₂cáun₂ dsa₂ 'í₁ jmá'₃ dsa₂ ŋe'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jme₁jnia₃ jaun₂, ca₂ŋɨ'₂ ca₂le₃jɨ́n₃ dsa₂ dsen₅₄ i₂jmo₅ 'éi'₃ quián₅ dsa₂ judíos, dsɨ₂gui'₅₄ can'₅₄, të₅juá'₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ján₃ bá₄ jaun₂ jme₁'en₅₄ Anás i₂lɨ́n₅ jme₂dsa₂ dsen₅₄, Caifás, Juan₅₄, Alejandro në́₃, ca₂le₃jɨ́n₃ guë́₄ i₂lɨ́n₅ o₁rɨn'₅₄ jme₂dsa₂ dsen₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jme₁ma₂le₁ŋɨi'₂ jɨin₂, jaun₂ guë́₄ ca₂i₁dsein₂₃ Pe₄ quian'₅₄ Juan₅₄, jaun₂ ca₂chei'₃ dsi₂jo₂ ja₁le₁ŋɨi'₂ jaun₂. Jaun₂ ca₂ŋag₃: ―¿'Ein₂ ca₂cuë₃ 'éi'₃, o₃ 'ein₂ ca₂cuë₃ jág₁ a₂i₂nio'₄ 'nia'₂ jme₂tɨ́ng'₁ dsa₂, a₂jmo'₂ 'nia'₂ 'e₂ jmo'₂ i₂niog'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jaun₂ ca₂juá'₂ Pe₄, rë₂rɨn₅ Jme₂dsí₂ Jŋió₅ të₂dsɨ́₅, ca₂tsɨ́'₃ dsa₂ i₂le₁ŋɨ'₂ 'éi₂: ―'Nia'₂ dsa₂ dsen₅₄ quián₅ juɨg₂, 'nia'₂ dsa₂ can'₅₄ quián₅ juɨg₂ Israel në́₃: ");
INSERT INTO cntNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Chi₂jua'₂ a₂jaun₂ ŋag'₅₄ 'nia'₂ ia₁ ca₂jmó₁ jnia'₅₄ caun₂ a₂dse₃ quió'₅ jan₂ dsa₂ dso'₅₄ i₂tsá₃ lé₂ jme₁ŋɨ₃, chi₂jua'₂ 'niog'₂ 'nia'₂ le₃ŋi'₅₄ 'a₂ lia'₂ ca₂lë₃ a₂ca₂'lóin₂, ");
INSERT INTO cntNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","juɨ₁le₃ŋi'₅₄ bá₄ 'nia'₂, juɨ₁le₃ŋi₅ bá₄ ca₂le₃jɨ́n₃ dsa₂ juɨg₂ Israel në́₃, a₂chén'₅ dsa₂ në₅ jɨn'₄ 'nia'₂ ca₂'lóin₂ quian'₅₄ bí₂ quió'₅ Jesucristo chan₂ Nazaret i₂ca₂tión'₃ 'nia'₂ cróg₄, i₂ca₂jme₁jen'₅₄ táng₃ Diú₄ jɨn₄ 'lag₄. ");
INSERT INTO cntNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesús 'éi₂: lɨ́n₅ nɨ₁cang₁ a₂tsá₃ jen'₅₄ 'nia'₂, i₂lɨ́ng'₅ të₅ i₂chi'₅ tsɨ₁'né₅, la₁ ca₂dsióg₃ ca₂lë₃ nɨ₁cang₁ a₂dsen₅₄ guë́₄. ");
INSERT INTO cntNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ia₁ 'i₁jan₂ i₂sián'₂ tsá₃ chan₂ i₂le₃lión₂ dsa₂. Ia₁ 'i₁jan₂ i₂sián'₂ tsá₃ ca₂cuɨn₃ Diú₄ ne₄ gua'₅₄ 'uë₃ la₂, a₂lé₂ 'ɨ́in₄ jniog₄ a₂mɨ́₁ ne₄ Diú₄ ia₁jaun₂ tág'₄ guei'₅₄ i₂juɨ́g₃, jŋia'₅₄ lia'₂ jan₂ Jesús bá₄. ");
INSERT INTO cntNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jme₁ca₂jág₃ dsa₂ can'₅₄ dsɨ₂gó'₃ dsɨ́₅ ca₂jɨ́in₂ Pe₄ quian'₅₄ Juan₅₄ 'a₂ lia'₂ tiá₂ dsɨ́₅ 'éi₂ ŋag₂₃ ne₅₄ le₂jaun₂, jaun₂ ca₂rë₃lí'₄ a₂lɨ́n₅ 'éi₂ dsa₂ tsá₃ lɨn₄ quen₅, i₂tsá₃ lɨn₄ si₂ cuɨ́'₅ në́₃, jaun₂ guë́₄ ca₂rë₃cuɨin₂₃ a₂lɨ́n₅ 'éi₂ dsa₂ i₂jme₁i₂nio₄ quian'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ia₁ jaun₂ bá₄ jme₁chén'₄ dsa₂ i₂ca₂'lón₂ 'éi₂ jë₄ jaun₂, jaun₂ lë₃ tsá₃ cuɨn₅ jmɨg₄ jua'₅₄ a₂juá'₂ dsa₂ can'₅₄ a₂tsá₃ dsau₅. ");
INSERT INTO cntNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jaun₂ ca₂'uɨ́in'₂ bá₄ Pe₄ quian'₅₄ Juan₅₄ jë₄ jaun₂, jaun₂ ca₂jmo₃ jág₁ guioin₅₄ 'a₂ lia'₂ jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ca₂dsia₃ jág₁, juá'₂: ―¿'A₂ lia'₂ jmó₁ quian'₅₄ dsa₂ në₅ jaun₂? Ia₁ ca₂le₃jɨ́n₃ bá₄ dsa₂ juɨg₂ Jerusalén ma₂le₁ŋi₅ a₂jmo₅ i₂në₅ léi₄ juë'₂, jaun₂ tsá₃ lé₂ jua'₅₄ a₂jua'₅₄ jniog₄ a₂tsá₃ dsau₅. ");
INSERT INTO cntNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","La₁ ia₁jaun₂ tsá₃ ma₃caun₂ qui₃dsɨ₃'ag₅ jág₁ jɨn₄ dsa₂ juɨg₂, 'nió'₅ quiain₅₄ jniog₄ juë́'₅ ia₁jaun₂ tsá₃ ma₃i₃nioi₅₄ qui₃'ɨin₃ guë́₄ Jesús a₂tsɨ́'₃ dsa₂ le₃ne₄ juɨ₅ ja₁dsau₅₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jaun₂ ca₂të₃ dsa₂ i₂le₁ŋɨ'₂ 'éi₂ ca₂të́'₃ táng₃ Pe₄ quian'₅₄ Juan₅₄, jaun₂ ca₂jmo₃ 'éi'₃ ca₂tsɨ́'₃ dsa₂ on₃ 'éi₂, a₂tsá₃ ma₃dsia₃ co₂ŋei'₅₄ on₃ guë'₂ jme₃tɨin₂₃ dsa₂ a₂'ɨin₂₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","La₁ jaun₂ ca₂ŋag₃ Pe₄ quian'₅₄ Juan₅₄ ca₂juá'₂: ―'Nio'₄ 'nia'₂ 'au'₂ chi₂jua'₂ 'ŋio₅ guë́₄ dse₃ jniá₂ ne₄ Diú₄, a₂néi₁ jnia'₅₄ gau₂ jág₁ quián'₂ 'nia'₂, 'nió'₄ a₂jme₁néi₁ jnia'₅₄ gau₂ jág₁ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","La₁ jnia'₅₄ në́₃ tsá₃ lé₂ tí₄ a₂dsiá₁ ca₂le₃jë́₃ a₂ma₂jag₅₄, a₂ma₂néi₁ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jaun₂ ca₂quiong₃ dsɨ₂tan₅₄ juë́'₅, la₁ ca₂lió₂ bá₄ jaun₂ në́₃. Ia₁ tsá₃ ca₂dsó'₂ 'a₂ lia'₂ 'ë́₂ uɨg₅, ia₁ ca₂le₃jɨ́n₃ bá₄ dsa₂ ma₂qui₂cuë́'₃ ti₁'mag'₄ Diú₄ a₂ca₂të́₂ ne₅₄ a₂ca₂lë₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jaun₂ dsa₂ ŋe'₂ i₂ca₂'lón₂ 'éi₂ quian'₅₄ léi₄ a₂dsɨ₂gó'₃ dsɨ₅, jme₁'ein₅₄ lë́₅ guë́₄ të₂láu₃ ŋi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Jme₁ma₂lón₂ Pe₄ quian'₅₄ Juan₅₄, ca₂i₃léin₂ ja₁tion'₅₄ rɨin'₅₄, jaun₂ ca₂dsia₃ ca₂le₃jë́₃ 'e₂ ca₂juá'₂ juɨg₅₄ jme₂dsa₂ quian'₅₄ dsɨ₂gui'₅₄ can'₅₄ a₂ca₂tsɨ́'₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jme₁ca₂nág₂ jág₁ jaun₂, ca₂le₃jɨ́in₃ ca₂mɨ₃ co₂lë₅ ca₂tsɨ́'₃ Diú₄ ca₂juá'₂: ―Te₁gui'₅₄ quián₂ jniog₄, 'ne₂ bá₄ lɨ́ng'₅ Diú₄ i₂ca₂jmo'₅₄ guei'₅₄ i₂juɨ́g₃, quian'₅₄ gua'₅₄ 'uë₃, jmɨ₁ŋí'₄ në́₃, ca₂le₃jë́₃ guë́₄ 'e₂ a₂cha₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","'Ne₂ bá₄ ca₂jua'₅₄ quian'₅₄ Jme₂dsí₂ Jŋió₅ quiáng'₂, jme₁ca₂juá'₂ 'lag₄ David dsa₂ quiáng'₂: ¿'E₂ lë₃ tion'₅₄ dsɨ₂nau₂ co₂mɨ'₅₄? ¿'E₂ lë₃ dsɨ₂jiog₅ dsɨ́₅ dsa₂ chan₂ mɨ₂güɨ́g₃ ca₂le₃jë́₃ ne₅₄ a₂'lɨg'₅₄ a₂tsá₃ ta₁ tí₄? ");
INSERT INTO cntNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ca₂le₃jɨ́n₃ rag₅₄ ne₄ gua'₅₄ 'uë₃ qui₂ca₂quɨin'₂ jág₁; Ca₂le₃jɨ́n₃ dsɨ₂tan₅₄ quián₅ juɨg₂ qui₂ca₂nau₂ 'nei₂ ja₁con₂ Te₁gui'₅₄, ja₁con₂ I₂rë₂'ɨ́n₁ quiáin₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Dsau₅ dsón'₂ bá₄ ca₂jmo₃ caun₂ jág₁ Rag₅₄ Herodes quian'₅₄ Dsi₄má'₂ Poncio Pilato juɨg₂ la₂ quian'₅₄ dsɨ₂nau₂, dsa₂ israelitas në́₃. Ca₂quɨin'₃ jág₁ ca₂jme₃'ŋiai₅₄ Jesús Ja₂ŋí'₂ jŋió₅ i₂rë₂'ɨ́n₁ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Quian'₅₄ a₂në₅, ca₂jme₃ti₃ dsa₂ can'₅₄ 'éi₂ ca₂le₃jë́₃ a₂'i₄ 'éi'₃ niog₅ lé₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Jaun₂ në́₃ Te₁gui'₅₄, jag₄ a₂quiong₅ dsa₂ juë́'₅ jnia'₅₄. Cuë₄ bí₂ jnia'₅₄ dsa₂ quiáng'₂ ia₁jaun₂ tián₂ qui₂jme₁tɨn₅ guë́₄ jnia'₅₄ dsa₂ jág₁ quiáng'₂, tsá₃ juɨ₁le₂go₃. ");
INSERT INTO cntNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Cuë₄ bí₂ quiáng'₂ a₂lé₂ jme₁'lion₅₄ jnia'₅₄ dsa₂ dso'₅₄, a₂lé₂ jmó₁ léi₄ dsɨ₂gó'₃ dsɨ₅ quian'₅₄ bí₂ 'éi'₃ quió'₅ Jesús, dsa₂ jŋió₅ i₂jme₂ti₃ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Jme₁ca₂dsan₃ chi₂léin'₂ Diú₄ le₂në₅, ca₂i₁bi₅₄ ja₁tioin'₅₄, jaun₂ ca₂le₃jɨ́n₃ qui₂ca₂cain'₂ Jme₂dsí₂ Jŋió₅. Jaun₂ tsá₃ ma₃juë́'₅ 'i₄ dsɨ́₅ qui₂ca₂'ë́₂ jág₁ dse₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ca₂le₃jɨ́n₃ dsa₂ i₂ma₂'én₂, caun₂ bá₄ a₂dsɨ₂jiog₅ dsɨ́₅, caun₂ bá₄ 'ei₅ jme₂dsí₂ quió'₅ ca₂le₃jɨ́in₃. 'I₁jan₂ tsá₃ jua'₅₄ a₂jmo₂₃ quió'₅ 'ŋiog₅ 'e₂ caun₂ a₂cha₂ quió'₅. Jmo₂₃ bá₄ dsɨ́₅ a₂quió'₅ co₂dsia₅ quiain'₅₄ rɨin'₅₄ ca₂le₃jë́₃ 'e₂ a₂cha₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Caun₂ ca₂'ág₂ tiá₂ dsɨ́₅ qui₂ca₂cuë₃ jág₁ dsau₅ dsɨ₂guia₃-tɨ́n₂ i₂chen₄ quián₅ Diú₄ 'éi₂, 'a₂ lia'₂ ca₂jen'₅₄ Te₁gui'₅₄ Jesús. Jaun₂ caun₂ qui₂ca₂cuë₃ Diú₄ bí₂ 'ŋio₅ lɨn₃ quió'₅ ca₂le₃jɨ́n₃ dsa₂ i₂'én₂. ");
INSERT INTO cntNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","'I₁jan₂ tsá₃ 'ein₂ jua'₅₄ cha₂ qui₂ca₂rë₃'nió'₅ quió'₅, ia₁ dsa₂ i₂cha₂ 'uë₃, o₃ i₂tióng₂ 'né₅ quió'₅ në́₃, qui₂ca₂'nag₃. ");
INSERT INTO cntNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jaun₂ ca₂o₃can₅ cu₄ jaun₂, ca₂jɨ́in'₃ dsa₂ guia₃-tɨ́n₂ i₂chen₄ quián₅ Jesús 'éi₂, jaun₂ ca₂dsió'₃ ca₂cuë́'₃ le₂jan₂ le₂jan₂ 'a₂ con'₂ 'nió'₅ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jme₁chan₂ jɨn₄ dsa₂ 'éi₂ jan₂ dsa₂ levita i₂jme₁chen₂ José i₂chan₂ Chipre. Dsa₂ i₂chen₄ në́₃ ca₂quiain₃ Së́₄ 'éi₂ Bernabé, co₂'nió'₄ a₂juá'₂ dsa₂ i₂jmo₅ lián'₂, i₂jme₂'o₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bernabé 'éi₂ ca₂'nag₃ caun₂ 'uë₃ quió'₅ a₂jme₁cha₂. Ca₂le₃jë́₃ cu₄ jaun₂ ca₂o₃can₅ ca₂cuë́'₃ dsa₂ guia₃-tɨ́n₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","La₁ jan₂ dsa₂ sián'₂ i₂jme₁chen₂ Ananías quiain'₅₄ Safira 'io₅₄ quiáin₅, ca₂'nag₃ caun₂ 'uë₃ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Dsa₂ ŋe'₂ 'éi₂ ca₂'ma₃ ca₂dsio₄ cu₄ jaun₂ 'ŋiog₅, jaun₂ ca₂dsio₄ bá₄ ca₂i₁cuë'₂ dsa₂ guia₃-tɨ́n₂ i₂chen₄ quián₅ Jesús, lia'₂ jag₄ bá₄ a₂i₁can₅ ta₁jë₂. Ján₃ bá₄ ŋi₅ 'io₅₄ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Jaun₂ ca₂juá'₂ Pe₄ ca₂tsɨ́'₃ Ananías: ―¿'E₂ lë₃ ca₂'í₃ Satanás të₂'au'₂ jaun₂ jmo'₂ jág₁ të₂jág₁ ne₄ Jme₂dsí₂ Jŋió₅, a₂ca₂'ma'₅₄ ca₂dsio₄ cu₄ a₂ca₂quí₃ dsa₂ 'lia'₅₄ 'uë₃ quiáng'₂? ");
INSERT INTO cntNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿On₁jua'₅₄ quiáng'₂ 'uë₃ a₂në₂'nag'₅₄? ¿On₁jua'₅₄ quiáng'₂ cu₄ jaun₂ në́₃? ¿'E₂ lë₃ ca₂i₃jiog₅ 'au'₂ jmó'₂ le₂në₅? Diú₄ bá₄ në₂chei'₅₄ 'ne₂ jág₁ të₂jág₁, on₃jua'₅₄ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Dsɨ₂juɨ₅ jme₁në₂néi₂ Ananías le₂në₅, ca₂quɨin'₃ ca₂join₃. Jaun₂ ca₂le₃jɨ́n₃ dsa₂ i₂ca₂rë₃ŋi₅ a₂ca₂lë₃ le₂jaun₂ ca₂rë₃gó'₅ 'ŋio₅ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jaun₂ ca₂o₃lén₂ on₃-ún₂ chi'₂ dsa₂ ŋe'₂, ca₂lio₃ 'mɨ'₂ nɨ₁ŋɨ₁₂, jaun₂ ca₂i₁'ó₄. ");
INSERT INTO cntNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tsá₃ jaun₂ ŋi₅ 'io₅₄ quián₅ Ananías a₂ca₂lë₃ le₂jaun₂, jaun₂ ca₂dsióg₃ con'₂ 'nɨ₅ hora cang₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jaun₂ ca₂ŋag₃ Pe₄ ca₂ŋɨ́i'₃ 'io₅₄: ―Jua'₅₄ dsón'₂. ¿'Ma'₅₄ jaun₂ në₂'nag'₅₄ 'nia'₂ 'uë₃ con'₂ lë́₅ jág₁ juá'₂ 'nia'₂? Jaun₂ ca₂ŋag₃ 'io₅₄: ―Ján₅. 'Ma'₅₄ jaun₂ dsón'₂ bá₄ i₂'nag₄. ");
INSERT INTO cntNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Jaun₂ ca₂juá'₂ táng₃ Pe₄: ―¿'E₂ lë₃ në₂jmo'₅₄ 'nia'₂ caun₂ jág₁ a₂cáng'₄ táu₂ Jme₂dsí₂ quián₅ Te₁gui'₅₄? Ca₁'né₄ në₅ ma₂ja₂len₃ táng₃ dsa₂ i₂ma₃i₁'ón₄ dsɨ₂i₂gog'₂. Në₃ guë́₄ të₂ táng₃ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Dsɨ₂juɨ₅ le₂jaun₂ ca₂quɨn'₃ 'io₅₄ ca₂join₃ ja₁chén'₄ Pe₄ jaun₂. Jme₁ca₂i₃ton'₅₄ chi'₂ dsa₂ ŋe'₂ 'éi₂, ma₂jon₅ bá₄ 'io₅₄, jaun₂ ca₂tág₃ táng₃ jaun₂ ca₂i₁'ó₄ cau₅ ja₁rë₂'on₅ dsɨ₂i₂gu₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jaun₂ ca₂rë₃gó'₅ 'ŋio₅ lɨn₃ ca₂le₃jɨ́n₃ dsa₂ 'én₂ i₂lɨ́n₅ guá'₅, ca₂le₃jɨ́n₃ guë́₄ dsa₂ sián'₂ i₂ca₂rë₃ŋi₅ a₂ca₂lë₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Quian'₅₄ bí₂ quió'₅ Diú₄ ca₂jmo₃ dsa₂ i₂chen₄ quián₅ Jesús 'lióng₂ léi₄ juë'₂ a₂dsɨ₂gó'₃ dsɨ₅ jɨn₄ dsa₂. Jaun₂ jme₁ŋɨ'₂ dsa₂ i₁dsi₅ guá'₅ templo ja₁lë́₄ corredor ja₁të́'₂ dsa₂ quió'₅ Salomón. ");
INSERT INTO cntNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","'I₁jan₂ tsá₃ ca₂tiá₂ dsɨ́₅ jme₃quiain'₅₄ dsa₂ i₂'én₂ 'éi₂, la₁ jme₁jme₂go₃ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","La₁ juɨn₅ bá₄ dsa₂ ŋe'₂, lia'₂ dsa₂ mɨ́₂ në́₃, ca₂rë₃'én₂ të₂le₃ quió'₅ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ca₂lia'₂ jme₁dsɨ₂jŋiai₃ jë₄ calle dsa₂ dso'₅₄ tián'₅ ne₄ cama, ne₄ tsɨ₁jein₁ në₃, ia₁jaun₂ tsá₃ a₂nag₅₄ jŋia'₅₄ 'én'₁ quió'₅ bá₄ Pe₄ të₅₄ quió'₅ i₂lɨn₅₄ dsa₂ dso'₅₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ján₃ bá₄ ca₂o₃lén₂ juɨn₅ dsa₂ chan₂ juɨg₂ ma₂quián₅ Jerusalén, le₁jŋiai₂₃ dsa₂ le₁dso'₅₄, dsa₂ i₂tion'₅₄ jme₂dsí₂ 'lɨn'₅₄ të₂dsɨ́₅ në́₃, ca₂o₃lén₂. Jaun₂ ca₂le₃jɨ́n₃ dsa₂ 'éi₂ qui₂ca₂'lóin₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jaun₂ ca₂rë₃'iog₅₄ 'ŋio₅ lɨn₃ jme₂dsa₂ dsen₅₄, quiain'₅₄ rɨin'₅₄ i₂jme₁lɨ́n₄ saduceos. ");
INSERT INTO cntNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jaun₂ ca₂jŋai'₃ dsa₂ i₂chen₄ quián₅ Jesús, ca₂i₁tio'₂ 'né₅ 'má₃. ");
INSERT INTO cntNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","La₁ a₂'uë₂ jaun₂, ca₂ŋe₄ jan₂ ángel quián₅ Te₁gui'₅₄ ca₂niá₃ 'né₅ 'má₃, ca₂'uɨ́in'₂ dsa₂ i₂chen₄ 'éi₂, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―O₂nó'₅ 'nia'₂ i₁dsi₅ guá'₅ templo, o₂nau₂ o₂chei'₅₄ 'nia'₂ dsa₂ jág₁ dse₃ quió'₅ Juɨ₅ 'mɨ́₂ la₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jme₁ca₂nág₂ jág₁ në₅, të₃ o₃'iog₂ jme₁jnia₃ jaun₂ ca₂i₁lein₅₄ guá'₅ ca₂i₁jme₁tɨin₂₃ dsa₂. Jmɨg₄ jaun₂ ca₂të₃ jme₂dsa₂ dsen₅₄ ca₂ŋɨ́i'₂ dsɨ₂tan₅₄ quián₅ guá'₅, jaun₂ ca₂jmo₃ 'éi'₃ i₁të₂ dsa₂ i₂chen₄ quián₅ Jesús i₂tion'₅₄ 'né₅ 'má₃ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","La₁ jme₁ca₂dsi₃lén₂ 'lióg₂ 'né₅ 'má₃, tsá₃ ma₃dsa₂ i₂jme₁tion'₅₄ chan₂. Jaun₂ ca₂i₃lein₃ táng₃ i₁con₂ jág₁, ");
INSERT INTO cntNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","juá'₂: ―Jme₁chi₁jnág₅ dse₃ bá₄ o₄'né₄ 'né₅ 'má₃, jme₁tión₂ bá₄ guë'₂ 'lióg₂ jmo₂₃ 'í₁ cau₅ o₄'né₄ në́₃. La₁ jme₁në₂tió'₄ jnia'₅₄ dsi₂néi₂, tsá₃ ma₃dsa₂ i₂jme₁tion'₅₄ chan₂ 'i₁jan₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jme₁ca₂nág₂ juɨg₅₄ jme₂dsa₂, juɨg₅₄ chi'₂ 'ɨ'₅₄ quián₅ guá'₅ në́₃, jaun₂ dsɨ₂gó'₃ dsɨ́₅ qui₂ca₂ŋɨ́i'₃ rɨin'₅₄ 'a₂ dsi₁quén'₅ ca₂le₃jë́₃ a₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Jaun₂ ca₂dsióg₃ jan₂ dsa₂ quian₅ jág₁, jaun₂ ca₂juá'₂: ―Dsa₂ i₂ca₂jne'₅₄ 'nia'₂ 'né₅ 'má₃, ó₃ bá₄ ma₂tióin₂ i₁dsi₅ guá'₅ jme₂tɨin₂₃ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jaun₂ në́₃ ca₂i₃lén₂ chi'₂ 'ɨ'₅₄ quiain'₅₄ juɨg₅₄ quiáin₅, jaun₂ ca₂i₁chong'₅₄ táng₃ lia'₂ 'i₄ rë₂ jág₁. Tsá₃ uɨg₅ ca₂jmóg'₂, ia₁ gó'₅ qui₃jnáu'₂ cang₄ dsa₂ i₂le₁ŋɨ'₂ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Jme₁ca₂dsi₃lein₃ le₁te₂ dsa₂ 'éi₂, jaun₂ ca₂chei'₃ dsi₂jo₂ ja₁le₁ŋɨ'₂ dsɨ₂tan₅₄ quián₅ guá'₅. Jaun₂ ca₂juá'₂ jme₂dsa₂ dsen₅₄ ca₂tsɨ́'₃ dsa₂ 'éi₂: ");
INSERT INTO cntNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Ca₂jne₅₄ jnia'₅₄ co₂ŋei'₅₄ a₂tsá₃ ma₃jme₁tɨn'₅ 'nia'₂ dsa₂, jua'₅₄ a₂'ɨ́n'₄ guë́₄ 'nia'₂ Jesús 'éi₂. ¿'E₂ ma₂jmo'₅₄ guë'₂ 'nia'₂? Caun₂ qui₂jme₂tɨ́n'₁ 'nia'₂ dsa₂, tsá₃ jág₁ cán'₁, ca₂lia'₂ ta₁caun₂ juɨg₂ Jerusalén ma₂rë₂rɨn₅ quian'₅₄ jág₁ a₂jme₂tɨ́in'₁ 'nia'₂. A₂'niog'₂ 'nia'₂ bog'₅₄ jnia'₅₄ dso₄ a₂ca₂jon₃ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Jaun₂ ca₂ŋag₃ Pe₄ quiain'₅₄ dsa₂ i₂chen₄ rɨin'₅₄: ―'Ŋio₅ guë́₄ dsen₅₄ ta₁ jme₁ti₁ jnia'₅₄ 'éi'₃ quió'₅ Diú₄, con'₂ guë́₄ 'éi'₃ quió'₅ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Diú₄ quián₅ dsa₂ can'₅₄ quián₂ jniog₄ ma₂lɨ́g'₂, Diú₄ 'éi₂ bá₄ ca₂jme₃jen'₅₄ Jesús i₂ca₂jŋɨ́'₃ 'nia'₂ ca₂tióin'₃ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Diú₄ në́₃ ma₂ca₂chó'₂ guei'₅₄, jaun₂ ma₂guá₅ cau₅ quió'₅ të₂le₃ gu₂ ne₁, jaun₂ ma₂dsiog₃ a₂léin₂ juɨg₅₄ jniog₄ i₂lió₂, ia₁jaun₂ cuɨn₃ jmɨg₄ jme₃tsɨ́n₃ dsɨ́₅ dsa₂ juɨg₂ Israel ia₁jaun₂ 'én₂ dsáu₁. ");
INSERT INTO cntNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ca₂le₃jág₃ bá₄ jnia'₅₄ ca₂të́₂ ne₄ a₂në₅, ján₃ bá₄ jáng'₅ jág₁ dsau₅ Jme₂dsí₂ Jŋió₅ i₂ma₂cuɨn₃ Diú₄ quió'₅ dsa₂ i₂nag₅ gau₂ jme₂ti₃ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ca₂rë₃'né₃ 'ŋio₅ lɨn₃ dsa₂ can'₅₄ jme₁ca₂nág₂ le₂në₅, a₂'nio₃ jme₁jme₃dsiain₂₃ dsa₂ i₂chen₄ quián₅ Jesús 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","La₁ jë₄ quió'₅ dsɨ₂tan₅₄ jaun₂, jme₁'en₅₄ jan₂ dsa₂ fariseo i₂jme₁chen₂ Gamaliel, dsa₂ i₂lɨ́n₅ të₅juá'₅, jaun₂ jme₁jme₂go₃ dsa₂ 'ŋio₅ lɨn₃. Jaun₂ ca₂nau₂ dsa₂ 'éi₂ jë₄ quió'₅ dsɨ₂tan₅₄, ca₂mɨ₃ a₂'uɨ́in'₂ ca₂tiá₂ dsa₂ i₂chen₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jme₁ca₂'uɨn₂ 'éi₂, jaun₂ ca₂juá'₂ Gamaliel ca₂tsɨ́'₃ dsɨ₂tan₅₄: ―'Nia'₂ dsa₂ chan₂ juɨg₂ Israel, jmo₄ 'nia'₂ 'í₁ a₂jma'₅₄ 'nia'₂ dsa₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dsá₂ 'au'₂ 'nia'₂ jmo₄ a₂ca₂lë₃, ma₂ŋó₃ ca₂la₂ 'lióng₂ ŋi₂, ca₂nau₂ Teudas a₂juá'₂ a₂lɨ́in₅ dsa₂ 'uan'₂ dsa₂ dsen₅₄. Jaun₂ ca₂jme₃quiong'₅₄ con'₂ quén₂ 'ŋiá₂-lón₂ dsa₂ ŋe'₂. La₁ jme₁ca₂jŋag'₃ dsa₂, ca₂le₃jɨ́n₃ dsa₂ i₂jme₁quiain'₅₄ në́₃ ca₂i₃léin₂ jma₃quén₅. ");
INSERT INTO cntNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Cang₂ jaun₂, jmɨg₄ jme₁ca₂tion₃ dsa₂ si₂, ca₂nau₂ Judas i₂chan₂ Galilea. Ján₃ bá₄ le₂jaun₂ juɨn₅ dsa₂ ca₂jme₃quiong'₅₄ quió'₅. La₁ ján₃ bá₄ ca₂jŋag'₃ dsa₂. Ca₂le₃jɨ́n₃ bá₄ dsa₂ i₂jme₁quiain'₅₄ në́₃ ca₂i₃léin₂ tsɨ₁rë₂jain₅₄ táng₃ jme₁ma₂jon₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jaun₂ lë₃, tsá₃ 'e₂ jmag'₅₄ dsa₂ në₅, tsá₃ lë₁tón'₂ 'nia'₂ mɨ'₅₄ quiain'₅₄. Ia₁ në₁jua'₂ jág₁ në₅ lë́₅ cosa quió'₅ dsa₂ mɨ₂güɨ́g₃, a₂lë₁dsɨ₃'én₂ bá₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","La₁ia₁ në₁jua'₂ lë́₅ cosa quió'₅ Diú₄, tsá₃ a₁jaun₂ le₃quɨ'₅₄ 'nia'₂ jmɨg₄ a₂'éng'₄. Jaun₂ 'í₁ jmo₄ ia₁ con'₂ tsá₃ ŋó₅ në₁jua'₂ quian'₅₄ Diú₄ quɨ́n'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jaun₂ ca₂nág₂ jág₁ jaun₂ ca₂le₃jɨ́in₃. Jaun₂ ca₂të́'₃ táng₃ dsa₂ i₂chen₄ quián₅ Jesús 'éi₂. Jaun₂ ca₂jmo₃ dsɨ₂tan₅₄ 'éi'₃ a₂bóg₂ dsa₂. Jaun₂ ca₂jné₃ táng₃ tsá₃ cuë₂₃ jmɨg₄ jua'₅₄ a₂'ë́₂ guë́₄ dsa₂ 'éi₂ jág₁ a₂'ɨin₂₃ Jesús. Jaun₂ ca₂lió₂ bá₄ jaun₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jme₁ca₂'uɨn₂ dsa₂ i₂chen₄ quián₅ Jesús 'éi₂, jɨn₄ dsɨ₂tan₅₄, jmo₂₃ 'io'₂, ia₁ ca₂cuë₃ Diú₄ jmɨg₄ ca₂i₃ŋɨ́i₂ o₂guí'₃ o₄quió'₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jaun₂ caun₂ ca₂i₁nioi₁₂ bá₄ jme₂tɨin₂₃ dsa₂ jág₁ dse₃ quió'₅ Jesucristo ca₂le₃jë́₃ jmɨg₄, lia'₂ i₁dsi₅ guá'₅ templo, lia'₂ dsi₂néi₂ quió'₅ dsa₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jmɨg₄ jaun₂ caun₂ dsɨ₂juɨ́n₂ bá₄ dsa₂ i₂'én₂. Jaun₂ dsa₂ i₂dsia₅ jág₁ jmei₅ griego ca₂jí₂ ca₂tsɨ́'₃ dsa₂ i₂dsia₅ jág₁ jmei₅ arameo. Ca₂juá'₂ 'ɨin₂₃ 'io₅₄ 'nág₂ chan₂ quiáin₅ tsá₃ lɨn₄ dse₃ jme₁cuë́'₅ dsa₂ juɨ₁lia'₂ 'e₂ má₃ dsió'₅ ca₂le₃jë́₃ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jaun₂ ta₁guia₃-tɨ́n₂ dsa₂ i₂chen₄ quián₅ Jesús ca₂ŋɨ́i'₂ ca₂le₃jɨ́n₃ dsa₂ i₂'én₂, jaun₂ ca₂juá'₂: ―Tsá₃ dse₃ jua'₅₄ a₂tí₅ jnia'₅₄ a₂'ë́₄ jnia'₅₄ jág₁ quió'₅ Diú₄ a₂jme₁ti₁ jnia'₅₄ ne₄ mesas a₂dsio'₅₄ jnia'₅₄ má₃. ");
INSERT INTO cntNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jaun₂ lë₃ rɨn'₅₄ jniog₄, 'ɨn₅₄ 'nia'₂ guion₃ dsa₂ të₃jɨn'₄ 'nia'₂, i₂'ei₅ jág₁ a₂'en₅₄ dsɨ́₅, a₂rë₂rɨn₅ Jme₂dsí₂ Jŋió₅ të₂dsɨ́₅, jaun₂ cuë'₅₄ 'nia'₂ ta₁ në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jnia'₅₄ guë'₂ caun₂ qui₁chei₅₄ Diú₄, caun₂ qui₂jme₁tɨn₅ jnia'₅₄ dsa₂ jág₁ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jaun₂ ca₂le₃jɨ́n₃ dsa₂ ca₂të́₂ dsɨ́₅ a₂në₅, jaun₂ ca₂quióin'₂ dsa₂ i₂chen₂ Esteban i₂'én₂ 'ŋio₅ lɨn₃, i₂rë₂rɨn₅ Jme₂dsí₂ Jŋió₅ të₂dsɨ́₅; Fe₂li₄ në́₃, Prócoro, Nicanor, Timón, Parmenas, Nicolás në́₃ i₂lɨ́n₅ jan₂ dsa₂ chan₂ Antioquía i₂jme₁ma₂gue₃ le₂jŋiá₅ 'Éi'₃ Juá'₅ quió'₅ dsa₂ judíos. ");
INSERT INTO cntNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jaun₂ ca₂o₃jŋia₃ dsa₂ dsa₂ guion₃ i₂ca₂'ɨin₃ 'éi₂ ja₁tión₂ dsa₂ guia₃-tɨ́n₂, jaun₂ qui₂ca₂quiog₂ gu₂ ne₄ quió'₅ dsa₂ guion₃ 'éi₂, ca₂chi₃léin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jaun₂ caun₂ ca₂i₃'ág₃ jág₁ quió'₅ Te₁gui'₅₄ jë₄ juɨg₂ Jerusalén, jaun₂ caun₂ ca₂i₃juɨ́n₂ bá₄ dsa₂ i₂ca₂rë₃'én₂, ca₂të₂ i₂jme₁lɨ́n₄ jme₂dsa₂ quián₅ dsa₂ judíos ca₂guein₃ jág₁, ca₂rë₃'én₂ juɨn₅. ");
INSERT INTO cntNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban, dsa₂ i₂'ŋio₅ lɨn₃ ma₂cuë₃ Diú₄ juɨ₅bí₂, ma₂jme₂'o₅₄ në́₃, i₂'éi₂ jme₁jmo₂₃ 'lióng₂ léi₄ dsɨ₂gó'₃ dsɨ₅ jɨn₄ dsa₂ juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jaun₂ i₂lɨn₅₄ dsa₂ quián₅ guá'₅ sinagoga i₂jme₁të́'₂ dsa₂ Libertinos, quiain'₅₄ i₂lɨn₅₄ dsa₂ chan₂ Cirene, i₂lɨn₅₄ i₂chan₂ Alejandría, i₂chan₂ Cilicia, i₂chan₂ juɨg₂ ja₁tén₄ 'uë₃ Asia në́₃, ca₂jme₃lióg₃ ca₂tsɨ́in₂ quian'₅₄ Té₂. ");
INSERT INTO cntNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","La₁ tsá₃ ca₂tio₃, ia₁ a₂niog₅ dsi₄ 'éi₂, tɨin₂ 'a₂ lia'₂ ŋag₃, ia₁ Jme₂dsí₂ Jŋió₅ bá₄ cuë₅ bí₂. ");
INSERT INTO cntNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jaun₂ ca₂láin₂ dsa₂ i₂jáng'₃ jág₁ të₂jág₁, a₂juá'₂ a₂ma₂nág₂ juá'₂ Té₂ 'ɨin₂₃ 'lɨg'₅₄ Moisés, 'ɨin₂₃ 'lɨg'₅₄ Diú₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jaun₂ le₂jaun₂ ca₂tóin'₂ co₂mɨ'₅₄ jɨn₄ dsa₂ juɨg₂ quian'₅₄ dsɨ₂gui'₅₄ can'₅₄, të₅juá'₅ në́₃, ca₂jmái'₂ mɨ'₅₄ Té₂, ca₂jŋau'₃, ca₂i₁jo₅₄ ne₄ dsɨ₂tan₅₄ quián₅ guá'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jaun₂ ca₂'nai'₂ ján₃ dsa₂ i₂jmo₃ jág₁ të₂jág₁ a₂'nɨi₃ Té₂. Jaun₂ ca₂juá'₂: ―Dsa₂ në₅ caun₂ qui₂juá'₂ 'lɨg'₅₄ 'ë₂₃ guá'₅ jŋió₅, 'ë₂₃ 'Éi'₃ Juá'₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ján₃ bá₄ ma₂ca₂néi₁ jnia'₅₄ juá'₂ i₂në₅ a₂'én₂ Jesús chan₂ Nazaret guá'₅ a₂jme₃tsɨ́in₃ tag₄ chí'₅ ca₂quiog₂ Moisés. ");
INSERT INTO cntNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jaun₂ dsɨ₂tan₅₄ quiain'₅₄ ca₂le₃jɨ́n₃ guë́₄ dsa₂ i₂jme₁tion'₅₄ le₁ŋɨ'₂ ja₁jaun₂, ca₂jɨ́in₂ Té₂, a₂ma₂jniá₂ dsɨ₂ne₄ 'éi₂ lia'₂ jniá₂ jan₂ ángel. ");
INSERT INTO cntNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jaun₂ ca₂ŋag₃ jme₂dsa₂ dsen₅₄ ca₂ŋɨ́i'₃ Té₂: ―¿Dsón'₂ dsau₅ ca₂le₃jë́₃ a₂juá'₂ dsa₂ në₅? ");
INSERT INTO cntNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jaun₂ ca₂ŋag₃ 'éi₂: ―Rɨn'₅₄ jniog₄, 'nia'₂ dsa₂ can'₅₄ quián₂ në́₃, nei₂ 'nia'₂ a₂juá'₄ jniá₂ la₂. Diú₄ 'uan'₂ quián₂ jniog₄ ca₂jme₃jniai₂₃ ne₄ jmei₂ jniog₄ Abraham lia'₂ con'₂ jme₁'ein₅₄ 'uë₃ Mesopotamia né'₃ a₂dsɨ₃guá₃ juɨg₂ Harán. ");
INSERT INTO cntNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Jaun₂ ca₂juá'₂ Diú₄: “Tí₃ 'uë₃ quiáng'₂, tén₃ ca₂le₃jɨ́n₃ o₁rɨ́ng'₂, gua₂ juɨ₅ 'uë₃ ja₁i₁'ë₃ jniá₂.” ");
INSERT INTO cntNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","'Jaun₂ ca₂ŋó₃ Abraham ca₂o₃'ɨ́in₃ 'uë₃ Caldea jaun₂, ca₂i₁gua₂ juɨg₂ Harán. Cang₂ jaun₂ ca₂jon₃ bá₄ jmei₂. Jaun₂ Diú₄ bá₄ ca₂o₃jŋia₃ Abraham 'uë₃ la₂ ja₁tián'₄ 'nia'₂ rë₂në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","La₁ tsá₃ jua'₅₄ 'e₂ ca₂cuë₃ Diú₄ 'uë₃ la₂, on₃ guë'₂ ja₁chi'₃ caun₂ tag₅₄ jua'₅₄ ca₂cuë₃. La₁ ca₂cuë₃ bá₄ Diú₄ jág₁ quió'₅ a₂cuë₃ 'uë₃ la₂, a₂jmo₃ le₃cha₂ quió'₅ chi'₂ quián₅ bá₄ Abraham jë₁ma₂join₂₃, o₁jŋia'₅₄ guë'₂ jmɨg₄ jaun₂ tsá₃ chi'₂ quián₅ Abraham jme₁chan₂ 'i₁jan₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jaun₂ ca₂juá'₂ Diú₄ ján₃, ca₂le₃jɨ́n₃ chi'₂ dsio₄ Abraham tiain'₃ juɨ₁lia'₂ ja₁tián'₄ dsɨ₂nau₂ caun₂ 'uë₃ a₂tsá₃ cuɨ́'₅, qui₃ŋág₃ uɨg₅ con'₂ quén₂ 'ŋiá₂-láu₂ ŋi₂ a₂lë₁jmo₃ ta₁ jme₂ti₃ ta₁ ne₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","La₁ ján₃ bá₄ ca₂juá'₂ Diú₄ ca₂tsɨ́'₃ Abraham: “Jniá₂ bá₄ 'ë́₄ uɨg₅ ne₄ juɨg₂ i₂jmá'₂ dsa₂ quiáng₃ i₂tion'₅₄ i₂lë₁jme₂ti₃ ta₁ ne₅₄. Cang₂ jaun₂ guion₅₄ dsa₂ juɨg₂ quiáng₃ 'uɨ́in₃ juɨg₂ jaun₂, jaun₂ ja₃léin₂ jme₃ti₃ ta₁ ne₃ ja₁lá₃.” ");
INSERT INTO cntNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ján₃ bá₄ ca₂jmo₃ Diú₄ caun₂ jág₁ quian'₅₄ Abraham, a₂ti₃ nɨ₁lo₁ ta₁jɨn₂ chi'₂ dsa₂ ŋe'₂ tsɨ₁jon₂ quiáin₅, a₂lɨ'₅₄ jág₁ a₂të₃ron₅₄. 'Uɨg₅₄ jaun₂, jme₁ca₂rë₃chán₃ ja₁ŋi'₅₄ i₂ca₂rë₃chén₃ Isaac, ca₂ti₃ Abraham nɨ₁lo₁ Isaac jme₁ma₂'ein₅₄ jŋia₃ jmɨg₄. Ján₃ bá₄ le₂jaun₂ ca₂jmo₃ Isaac quian'₅₄ Jacob ja₁ŋi'₅₄. Ján₃ bá₄ le₂jaun₂ ca₂jmo₃ Jacob quian'₅₄ ta₁guia₃-tɨ́n₂ ja₁ŋi'₅₄ i₂ca₂lɨn₃ jmei₂ ta₁guia₃-tɨ́n₂ juɨg₂ ja₁tén₄ Israel. ");
INSERT INTO cntNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ca₂le₃jɨ́n₃ chi'₂ ja₁ŋi'₅₄ Jacob i₂jme₁lɨ́n₄ jmei₂ jniog₄ ma₂lɨ́g'₂ 'éi₂, ca₂i₃uɨg₅₄ dsɨ́₅ jɨ́in₂ Së́₄ rɨin'₅₄. Jaun₂ ca₂'nɨi₃ 'éi₂ jaun₂ ca₂tág₃ dsa₂ ca₂të₂ 'uë₃ Egipto. La₁ Diú₄ bá₄ ca₂jmo₃ 'í₁ quió'₅ Së́₄, ");
INSERT INTO cntNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","qui₂ca₂lió₂ ca₂le₃jë́₃ 'e₂ ca₂i₃ŋɨ́i₂ ca₂jmo₃ ca₂rë₃ŋɨ́'₂ dsɨ́₅ 'ŋio₅ lɨn₃. Ján₃ bá₄ ca₂jmo₃ Diú₄ a₂chéin'₅ dse₃ quiain'₅₄ i₂të́'₂ dsa₂ Faraón, i₂lɨ́n₅ rag₅₄ quián₅ 'uë₃ Egipto. Rag₅₄ 'éi₂ ca₂'ɨin₃ Së́₄ a₂léin₂ dsi₄má'₂ 'uë₃ Egipto. Ján₃ bá₄ ca₂jmo₃ a₂nio₃ ne₄ 'éi₂ dsi₂néi₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Cang₂ jaun₂ ca₂gua₃ ŋi₂ a₂ca₂ŋág₃ uɨg₅ 'ŋio₅ lɨn₃ a₂ca₂rë₃'ɨ́n₃ a₂guë́'₃ dsa₂ ta₁caun₂ 'uë₃ Egipto quian'₅₄ 'uë₃ Cana'án. Jaun₂ ca₂le₃jɨ́n₃ jmei₂ jniog₄ ma₂lɨ́g'₂ tsá₃ ma₃'e₂ jnio'₂ a₂guë́'₃. ");
INSERT INTO cntNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jme₁ca₂rë₃ŋi₅ Jacob a₂cha₂ trigo 'uë₃ Egipto, jaun₂ ca₂chein₃ chi'₂ ja₁ŋi'₅₄ ja₁jaun₂, i₂ca₂lɨn₃ jmei₂ jniog₄ ma₂lɨ́g'₂. A₂jaun₂ guë́₄ le₂'uɨg₅₄ ca₂i₁lein₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jme₁ca₂të́₂ tɨn₃ ráun₂ i₁len₅₄ rɨn'₅₄ Së́₄ 'uë₃ Egipto, jaun₂ ca₂jmo₃ Së́₄ a₂ca₂rë₃ŋi₅ a₂lë́₅ rɨin'₅₄ dsa₂ 'éi₂. Jaun₂ guë́₄ ca₂rë₃ŋi₅ rag₅₄ quián₅ Egipto 'e₂ tsɨ₁jon₂ lɨ́n₅ Së́₄. ");
INSERT INTO cntNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jaun₂ guë́₄ ca₂tsɨ́'₃ Së́₄ dsó₂ rɨin'₅₄ a₂dsɨ₃quiáin₂ gui'₅₄ Jacob jmei₂, quian'₅₄ ca₂le₃jɨ́n₃ o₁rɨin'₅₄ i₂jme₁lë́₂ 'nag'₂ ne₂guióg₂ rë₂dsɨ́₂ guia₃-'ŋiá₂ (75) dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Le₂jaun₂ ca₂lë₃ a₂ca₂ŋó₃ Jacob ca₂i₁gua₂ 'uë₃ Egipto. Ja₁jaun₂ ca₂join₃ cang₂ jaun₂. Jaun₂ ja₁jaun₂ bá₄ qui₂ca₂dsan₃ chi'₂ quiáin₅ i₂'nió'₄ jmei₂ jniog₄ ma₂lɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nɨ₁mu₁₂ ca₂o₃con₃ dsa₂ cang₂ jaun₂ ja₁chei₂ Siquem. Ca₂o₃'ó₃ tau₂ 'ŋio₅ a₂ca₂lá₃ Abraham quió'₅ tsɨ₁jon₂ chi'₂ quián₅ Hamor ja₁chei₂ Siquem jaun₂, quian'₅₄ caun₂ 'ma'₅₄ a₂ca₂lɨ́'₃. ");
INSERT INTO cntNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Jme₁ja₂quián₃ jmɨg₄ le₃ti₃ jág₁ ca₂cuë₃ Diú₄ 'ɨin₂₃ 'ŋiog₅ ca₂cuë́'₃ Abraham, ca₂i₃juɨ́n₂ 'ŋio₅ lɨn₃ dsa₂ israelitas 'uë₃ Egipto. ");
INSERT INTO cntNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jaun₂ ca₂guá₂ jan₂ rag₅₄ i₂tsá₃ cuɨn₅ Së́₄, ca₂jme₃lióg₃ jmo₂₃ 'éi'₃ 'uë₃ Egipto. ");
INSERT INTO cntNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rag₅₄ 'éi₂ ca₂jme₃gain₂₃ dsa₂ go₄ jniog₄, ca₂jmái'₂ dsa₂ can'₅₄ quián₂ jniog₄ ca₂jmo₃ 'éi₂ tion₅₄ a₂téin₂ guein₂ dsa₂ ŋe'₂ i₂të₂ca₂rë₃chán₃, ia₁jaun₂ dsiáin₃. ");
INSERT INTO cntNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","'Jmɨg₄ jaun₂ ca₂rë₃chán₃ Moisés. Guein₂ 'éi₂ ca₂të́₂ dsɨ́₅ Diú₄, jaun₂ ca₂jme₃juag'₂ chog₅₄-jmei₂ 'nɨ₅ tsɨ'₂ dsi₂néi₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jme₁ca₂të́₂ jmɨg₄ a₂tóin₂ guein₂ 'éi₂, jaun₂ ja₁mɨ́g₄ 'ŋiog₅ rag₅₄ quián₅ Egipto ca₂tág₃ ca₂jme₃juag'₂ co₂'nió'₄ ja₁ŋi'₅₄ 'ŋiog₅. ");
INSERT INTO cntNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","'Uɨg₅₄ jaun₂, ca₂rë₃tɨ́n₃ Moisés ca₂le₃jë́₃ a₂ŋi₅ dsa₂ chan₂ Egipto, jaun₂ ca₂rë₃'uáin'₃, 'ŋio₅ lɨn₃ ŋi₅ 'e₂ jág₁ dsia₃, ŋi₅ a₂ca₂jmo₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Jme₁ma₂'ein₅₄ të₂láu₃ ŋi₂, jaun₂ ca₂ŋe₄ Moisés ca₂i₁jɨin₁₂ dsa₂ go₅₄ dsa₂ israelitas. ");
INSERT INTO cntNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ja₁jaun₂ ca₂jɨ́in₂ jan₂ dsa₂ chan₂ Egipto jmái'₂ uɨg₅ cuë́'₅ jan₂ dsa₂ go₅₄. Jaun₂ ca₂nau₂ Moisés 'nei₂ quiain'₅₄ i₂cuë́'₅ rɨin'₅₄, ca₂jŋɨi'₃ dsa₂ 'éi₂, ca₂lióin₂ dsa₂ go₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ia₁ ca₂i₃jiog₅ dsɨ́₅ jaun₂ le₃lí'₄ dsa₂ israelitas rɨin'₅₄, a₂jmo₃ Diú₄ lió₂ të₂le₃ quian'₅₄ 'éi₂. La₁ tsá₃ ca₂rë₃lí'₄ guë'₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jme₁jnia₃ jaun₂, ca₂jen'₂ Moisés on₃ dsa₂ israelitas i₁tion'₅₄ quɨ́n'₂. Jaun₂ jme₁'nio₃ Moisés dsioin₃ mɨ'₅₄. Jaun₂ ca₂juá'₂: “Rɨ́n'₂ bá₄ 'nia'₂. ¿'E₂ lë₃ qui₂jma'₅₄ 'nia'₂ uɨg₅ le₂jang'₂ le₂jang'₂?” ");
INSERT INTO cntNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","'Jaun₂ i₂jme₁'en₅₄ cuë́'₅ rɨn'₅₄ ca₂'liain'₃ Moisés cau₅, jaun₂ ca₂juá'₂: “¿'Ein₂ ca₂cuë́'₃ 'ne₂ ta₁ lɨ́ng'₅ dsɨ₂tan₅₄ i₂qui₂dsɨ₅ 'éi'₃ ja₁con₂ jnia'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿'Niog'₂ jŋág'₄ jniá₂ ján₃ juɨ₁lia'₂ ca₂jŋɨ́g'₃ dsióg₂ dsa₂ chan₂ Egipto 'éi₂?” ");
INSERT INTO cntNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Jme₁ca₂nág₂ Moisés le₂në₅, co₂tan₅₄ ca₂cuɨng₃ ca₂ŋó₃ juɨ₅ 'uë₃ ja₁chei₂ Madián. Ja₁jaun₂ ca₂i₁gua₂ co₂'nió'₄ a₂lɨ́in₅ dsɨ₂nau₂. Ja₁jaun₂ ca₂rë₃chán₃ on₃ chi'₂ quiáin₅. ");
INSERT INTO cntNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Të₂láu₃ ŋi₂ cang₂ jaun₂, caun₂ ja₁lë́₄ 'uë₃ quein₂ quián₅ má'₂ ja₁chei₂ Sinaí, ja₁jaun₂ ca₂jme₃jnia₅ jan₂ ángel jë₄ si₂ chi₁guí'₂ caun₂ nɨ₁'ma₂ taun₅ a₂cau₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Jaun₂ ca₂i₃gó'₃ dsɨ́₅ Moisés jme₁ca₂jág₃ a₂në₅, jaun₂ jme₁ca₂jme₃quiáin₃ guë́₄ ia₁ 'nio₃ jme₁jág₃ guë́₄ dse₃. Të₃jë₄ ŋó₃ jaun₂ jme₁ca₂nág₂ jág₁ quió'₅ Te₁gui'₅₄ a₂ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Jniá₂ bá₄ lɨ́ng₅ Diú₄ quián₅ dsa₂ quiáng'₂ ma₂lɨ́g'₂, Diú₄ quián₅ Abraham, quián₅ Isaac, quián₅ Jacob në́₃.” Jaun₂ ca₂jme₃lióg₃ ca₂jlen₃ Moisés ca₂rë₃gó'₅ 'ŋio₅ lɨn₃, tsá₃ ma₃tiá₂ dsɨ́₅ jág₃. ");
INSERT INTO cntNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","'Jaun₂ ca₂juá'₂ táng₃ Te₁gui'₅₄: “Jŋiá'₃ lau₂ ton₅ tag'₅₄, ia₁ 'uë₃ jŋió₅ bá₄ ja₁chéng'₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Jág₅ bá₄ jniá₂ a₂chan₂ uɨg₅ dsa₂ quiáng₃ 'uë₃ Egipto, qui₂nag₅ bá₄ jniá₂ a₂quɨ'₂-'o₂₃. Jaun₂ lë₃ ca₂sióng₃ ia₁ a₂loin₅₄. Ŋia₅, ia₁jaun₂ tsag₅₄ jniá₂ guang'₅₄ juɨ₅ Egipto”. ");
INSERT INTO cntNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’O₁jŋia'₅₄ la₂ tsá₃ jme₁'nio₃ dsa₂ go₄ Moisés le₂jŋiá₅, ia₁ ca₂juá'₂: “¿'Ein₂ ca₂'ɨn₃ 'ne₂ a₂lɨ́ng'₅ dsɨ₂tan₅₄ i₂qui₂dsɨ₅ 'éi'₃ ja₁con₂ jnia'₅₄?” la₁ Diú₄ në́₃ ca₂chein₃ Moisés a₂lɨ́in₅ co₂'nió'₄ dsɨ₂tan₅₄ i₂lió₂, të₂le₃ quian'₅₄ ángel i₂ca₂jme₃jnia₅ jë₄ nɨ₁'ma₂ taun₅ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés bá₄ dsa₂ i₂ca₂'uɨ́n'₂ dsa₂ can'₅₄ quián₂ jniog₄ ma₂lɨ́g'₂ 'uë₃ Egipto i₂qui₂ca₂jmo₃ ján₃ 'lióng₂ léi₄ juë'₂ a₂dsɨ₂gó'₃ dsɨ₅ në́₃. Léi₄ jaun₂ ca₂jmo₃ Moisés 'uë₃ jaun₂, quian'₅₄ ne₄ Jmɨ₁ŋí'₄ Guéin₂, quian'₅₄ 'uë₃ quein₂ co₂'ŋiog₅ ja₁ca₂i₁nioi₁₂ të₂láu₃ ŋi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jaun₂ 'ŋiog₅ Moisés 'éi₂ bá₄ ca₂tsɨ́'₃ dsa₂ israelitas: “A₂chen₃ Diú₄ jan₂ dsa₂ i₂'ë́₂ jág₁ quiáin₅, i₂lɨ́n₅ dsa₂ go'₄ 'nia'₂ guiong'₅₄, juɨ₁lia'₂ ca₂chei₃ jniá₂. Jaun₂ tón'₂ 'nia'₂ juɨ₅ jág₁ quió'₅ 'éi₂.” ");
INSERT INTO cntNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ján₃ bá₄ Moisés 'éi₂ jme₁'en₅₄ quian'₅₄ dsa₂ juɨg₂ 'uë₃ quein₂ co₂'ŋiog₅ jaun₂. Jme₁'ein₅₄ quian'₅₄ ángel i₂ca₂juá'₂ jág₁ má'₂ Sinaí. Ján₃ bá₄ jme₁'ein₅₄ quian'₅₄ 'lag₄ tsɨ₁jon₂ jmei₂ jniog₄. Moisés 'éi₂ bá₄ ján₃ i₂ca₂gue₃ jág₁ ca'₅₄, jaun₂ guë́₄ ca₂ŋág₃ të₂le₃ quián₂ jniog₄ táng₃. ");
INSERT INTO cntNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’La₁ dsa₂ quián₂ jniog₄ ma₂lɨ́g'₂ në́₃, tsá₃ ma₃ca₂jme₃ti₃, tsá₃ ma₃ca₂nág₂ gau₂ jág₁ quió'₅ Moisés. Ca₂chei'₃ cau₅, jme₁'nio₃ jme₁dsɨ₃lein₃ táng₃ juɨ₅ 'uë₃ Egipto. ");
INSERT INTO cntNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jaun₂ në́₃ ca₂tsɨ́'₃ Aarón ca₂juá'₂: “'Niog₂ jnia'₅₄ jmog'₅₄ diú₄ dsa₂ lag₄ i₂dsɨ₃lén₂ ne₄ juɨ₅ quián₂ jniog₄. Ia₁ tsá₃ ne₄ 'e₂ ca₂jén'₃ Moisés 'éi₂ i₂ca₂'uág'₂ jniog₄ 'uë₃ Egipto.” ");
INSERT INTO cntNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jaun₂ ca₂jmói'₂ jan₂ guein₂ ca₁juɨ₅ co₂'nió'₄ i₂lɨ́n₅ diú₄, qui₂ca₂jme₃dsiain₂₃ já'₂ quiáin₅ qui₂ca₂cuɨin₃ diú₄ lag₄ 'éi₂. Jaun₂ ca₂jmo₃ 'io'₂ quian'₅₄ a₂ca₂jmo₃ quian'₅₄ gu₂ guioin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jaun₂ co₂ŋei'₅₄ ca₂jmo₃ Diú₄ cau₅, tsá₃ ma₃ca₂jme₃quiain'₅₄ dsa₂ 'éi₂, juɨ₁jmo₁₂ bá₄ con'₂ tɨin₂ guioin₅₄. Jaun₂ ca₂jme₃lióg₃ dsa₂ 'éi₂ ca₂chi₂ca₂léin'₂ nei₅ a₂le₁'ág₄ guei'₅₄. Ia₁ le₂në₅ rë₂ton₅ ne₄ Si₂ a₂ca₂jmo₃ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ ma₂lɨ́g'₂: 'Nia'₂ dsa₂ chan₂ Israel, ¿'e₂ lɨ́n'₂ 'nia'₂? ¿Ca₂jme₁dsian'₅ 'nia'₂ já'₂ ca₂dsia'₅₄ ca₂jen'₅₄ 'nia'₂ ne₃ jniá₂ lia'₂ con'₂ jme₁quian'₅₄ jniá₂ 'nia'₂ të₂láu₃ ŋi₂ 'uë₃ quein₂ co₂'ŋiog₅ jaun₂? ");
INSERT INTO cntNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","On₃jua'₅₄ le₂jaun₂. Ia₁ guá'₅ chéi₂ quió'₅ diú₄ Moloc bá₄ ca₂quian'₂ 'nia'₂ quian'₅₄ nei₅ diú₄ Renfán, nió'₄ a₂qui₂ca₂jmo'₅₄ 'nia'₂ guiong'₅₄, a₂jaun₂ bá₄ ca₂chi₂ca₂len'₄ 'nia'₂. 'Uɨg₅₄ jaun₂, 'uɨ́n'₄ jniá₂ 'nia'₂ 'uë₃ quiáng'₂, tsag₅₄ jniá₂ të₂le₃ ó₃ guë́₄ ja₁niog₅ 'uë₃ Babilonia. ");
INSERT INTO cntNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’'Uë₃ quein₂ jaun₂, dsa₂ can'₅₄ quián₂ jniog₄ ma₂lɨ́g'₂ jme₁quian₅ guá'₅ tabernáculo ja₁jme₁rë₂'ma₄ nɨ₁cang₁ a₂le₁ton₅ ta₁guia₃ 'Éi'₃ Juá'₅. Guá'₅ tabernáculo jaun₂ ca₂lë₃ con'₂ lë́₅ jág₁ ca₂cuë₃ Diú₄ ca₂cuë́'₃ Moisés, jme₁ca₂'ë₃ Diú₄ nió'₄ le₂jŋiá₅ 'a₂ lia'₂ lé₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Dsa₂ quián₂ jniog₄ ma₂lɨ́g'₂ ca₂gue₃ guá'₅ jaun₂ co₂'nió'₄ ca₂ŋág₃ dsa₂ can'₅₄ quiáin₅. Jaun₂ dsa₂ i₂jme₁quian'₅₄ Josué në́₃ ca₂cáun₃ lia'₂ con'₂ jme₁ca₂lɨ́'₃ 'uë₃ quió'₅ dsa₂ juɨg₂ siá'₂, i₂ca₂'uɨ́n'₂ Diú₄ ia₁jaun₂ cha₂ ja₁tian'₃ 'éi₂. Le₂jaun₂ ca₂lë₃ ca₂lia'₂ ca₂të́₂ jmɨg₄ a₂ca₂rë₃chán₃ David. ");
INSERT INTO cntNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ca₂jmo₃ Diú₄ dse₃ dsɨ́₅ ja₁con₂ Rag₅₄ David, jaun₂ 'éi₂ në́₃ jme₁'nio₃ jmóg'₃ caun₂ ja₁guá₃ Diú₄ quián₅ Jacob. ");
INSERT INTO cntNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","La₁ Salomón bá₄ i₂ca₂chi'₃ 'né₅ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","'La₁ Diú₄ i₂juɨn'₂ guë́₄ lɨn₃ tsá₃ guá₅ dsi₂néi₂ guá'₅ a₂jmóg'₅ dsa₂ mɨ₂güɨ́g₃. Juɨ₁lia'₂ ca₂juá'₂ Diú₄ të₂le₃ quian'₅₄ dsa₂ i₂jme₁'ë́₂ jág₁ quiáin₅ ma₂lɨ́g'₂: ");
INSERT INTO cntNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Guei'₅₄ i₂juɨ́g₃ bá₄ ja₁gua₁₂ ja₁lë́₄ ne₄ta₁ quió₃, gua'₅₄ 'uë₃ në́₃ juɨ₁lia'₂ ja₁tióng₂ tag₃. ¿'E₂ bá₄ 'né₅ jmó'₂ 'nia'₂ quió₃? juá'₂ Te₁gui'₅₄, ¿O₃ já'₄ bá₄ lé₂ le₃jan₄ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿On₁ jniá₂ bá₄ ca₂jmo₃ quian'₅₄ gu₃-tag₃ ca₂le₃jë́₃ 'e₂ a₂cha₂? ");
INSERT INTO cntNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","(Jaun₂ caun₂ ca₂juá'₂ bá₄ Té₂ tsɨ́'₅ dsa₂): ―'Nia'₂ në́₃, lia'₂ ma₂ja₂nó'₅ jaun₂ bá₄ 'nia'₂ cang₄ dsei'₂, jaun₂ lë́₅ rë₂guá'₄ 'nia'₂ quian'₅₄ të₂'au'₂ juɨ₁lia'₂ dsa₂ i₂tsá₃ cuɨn₅ Diú₄. Caun₂ 'ŋia'₅₄ co₂tan₅₄ bá₄ 'nia'₂ Jme₂dsí₂ Jŋió₅. I₂co₂rɨn'₂ bá₄ 'nia'₂ quiang'₅₄ dsa₂ can'₅₄ quiáng'₂ ma₂lɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿'Ein₂ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄ jua'₅₄ i₂tsá₃ ca₂jmá'₂ dsa₂ can'₅₄ quián'₂ 'nia'₂ ma₂lɨ́g'₂? Qui₂ca₂jme₃dsiain₂₃ bá₄ dsa₂ i₂qui₂ca₂'ë́₂ jág₁ le₂jŋiá₅ ca₂'ɨin₃ jan₂ i₂dsen₃ lɨn₃, i₂jiá₃. La₁ jme₁guan₃ i₂'éi₂ në́₃, ca₂jɨin'₅₄ 'nia'₂ jaun₂ ca₂jŋɨ́i'₃. ");
INSERT INTO cntNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","'Nia'₂ guë'₂ i₂ca₂gue'₅₄ 'Éi'₃ Juá'₅ të₂le₃ quian'₅₄ ángeles, tsá₃ jme₂tí'₁ guë'₂ 'nia'₂ 'Éi'₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jme₁ca₂nág₂ jág₁ a₂ca₂juá'₂ Té₂ jaun₂, ca₂rë₃'néi₃ 'ŋio₅ lɨn₃ ca₂lia'₂ qui₂ca₂quɨg'₂ mɨ₂jan₅₄ a₂'ŋiai₅₄ Té₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","La₁ Té₂ në́₃, rë₂rɨn₅ Jme₂dsí₂ Jŋió₅ të₂dsɨ́₅, ca₂chóg'₃ ne₅₄ guei'₅₄ i₂juɨ́g₃ jaun₂ ca₂jág₃ a₂co₂tág₅ co₂'né'₅ quió'₅ Diú₄, jaun₂ ca₂jɨ́in₂ Jesús chéin'₅ të₂le₃ gu₂ ne₁ quió'₅ Diú₄ Jmei₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jaun₂ ca₂juá'₂ táng₃ Té₂: ―¡Jag₄! ―juá'₂―. Jág₅ jniá₂ rë₂na₄ guei'₅₄ i₂juɨ́g₃. Jɨn₄ jniá₂ Jaun₅ dsa₂ mɨ₂güɨ́g₃ 'ein₅₄ të₂le₃ gu₂ ne₁ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","La₁ dsa₂ 'éi₂ qui₂ca₂jne₃ rë₂gua₅₄, tsá₃ 'nio₃ nag₃, qui₂ca₂tóin'₂ co₂mɨ'₅₄ ca₂guió'₃ jmái'₂ Té₂. ");
INSERT INTO cntNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Jaun₂ ca₂dsei₂₃ 'nɨ'₂ juɨg₂. Jaun₂ ja₁jaun₂ ca₂jŋag'₃ quian'₅₄ cang₄. Jaun₂ dsa₂ i₂qui₂ca₂jnáu'₂ cang₄ në́₃ ca₂dsia₃ nɨ₁tsɨn'₅₄ o₄gú₃ jan₂ dsó₂ chi'₂ i₂jme₁chen₂ Saulo. ");
INSERT INTO cntNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Të₁lia'₂ tioin'₅₄ qui₂cuë́'₅ Té₂ cang₄, jaun₂ ca₂mɨ₃ Té₂ ca₂tsɨ́'₃ Diú₄ ca₂juá'₂: ―Te₁gui'₅₄ Jesús, guen'₅₄ jme₂dsí₂ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jaun₂ guë́₄ ca₂chi₃jné₃, jaun₂ ca₂guió'₃ tiá₂ ca₂juá'₂: ―Te₁gui'₅₄, tsá₃ jme₁cain'₅₄ dso₄ la₂. Jme₁ca₂lë₃ juá'₂ le₂në₅, ca₂join₃ jaun₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Jaun₂ caun₂ bá₄ 'ei₅ jág₁ quió'₅ Saulo a₂ca₂jŋɨ'₃ dsa₂ Té₂. Dsɨ₂juɨ₅ jmɨg₄ jaun₂ bá₄, ca₂jme₃lióg₃ dsa₂ qui₂co₂'ein₃ 'ŋio₅ lɨn₃ ta₁caun₂ nió'₃ dsa₂ i₂lɨ́n₅ guá'₅ jë₄ juɨg₂ Jerusalén. Ca₂le₃jɨ́n₃ dsa₂ 'éi₂ ca₂i₃léin₂ tsɨ₁rë₂jain₅₄ le₂tan₅₄ 'uë₃ Judea quian'₅₄ Samaria. Jŋia'₅₄ lia'₂ dsa₂ guia₃-tɨ́n₂ i₂chen₄ quián₅ Jesús bá₄ ca₂jŋia₃ guë́₄ juɨg₂ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","I₂lɨn₅₄ dsa₂ dsen₃ i₂'nio₃ Diú₄ ca₂'óin₂ Té₂, qui₂ca₂'o₃ 'ŋio₅ lɨn₃ o₄quió'₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Të₁lia'₂ jaun₂, i₂ŋɨ₅₄ Saulo quiain'₅₄ rɨin'₅₄ qui₂co₂'ein₂₃ dsa₂ i₂'én₂, qui₂dsɨ₂toin'₅₄ të₂ dsi₂néi₂ qui₂'uɨ́in'₂ dsa₂ tsɨ₁cuɨin'₂, lia'₂ dsa₂ ŋe'₂ lia'₂ dsa₂ mɨ́₂, qui₂të₂ a₂to'₂ 'né₅ 'má₃. ");
INSERT INTO cntNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","La₁ ca₂le₃jɨ́n₃ dsa₂ i₂ca₂'uɨn₂ juɨg₂ Jerusalén, ca₂le₃jë́₃ ja₁ca₂i₁lein₅₄ qui₂ca₂'ë́₂ jág₁ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jan₂ 'éi₂, i₂chen₂ Fe₂li₄, ca₂ŋó₃ caun₂ juɨg₂ ja₁tén₄ 'uë₃ Samaria ca₂dsia₃ jág₁ tsɨ́'₅ dsa₂ ja₁jaun₂, 'ɨin₂₃ Cristo. ");
INSERT INTO cntNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jaun₂ jme₁ŋɨ'₂ dsa₂ jmo₂₃ tei₄ ca₂le₃jɨ́in₃, të₅ dsɨ́₅ nag₂₃ jág₁ a₂juá'₂ Fe₂li₄, ia₁ ján₃ bá₄ ca₂jág₃ dsa₂ léi₄ dsɨ₂gó'₃ dsɨ₅ a₂jme₁jmo₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ia₁ juɨn₅ i₂tion'₅₄ jme₂dsí₂ 'lɨn'₅₄ të₂dsɨ́₅ qui₂ca₂'lóin₂. Ca₂le₃jɨ́n₃ jme₂dsí₂ 'lɨn'₅₄ 'éi₂ qui₂ca₂'uɨin₂ qui₂guió'₅. Ján₃ bá₄ juɨn₅ dsa₂ 'lian'₂, dsa₂ guian'₅₄ në́₃, qui₂ca₂'lóin₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","'Uɨg₅₄ jaun₂ 'ŋio₅ 'io'₂ ca₂jmo₃ dsa₂ juɨg₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Juɨg₂ jaun₂ jme₁chan₂ jan₂ dsa₂ i₂jme₁chen₂ Si₂mu₅₄, i₂jme₁jmo₅ ta₁ a₂chan₂ dsɨ́₅ le₂jŋiá₅, jme₁jme₂gain₂₃ dsa₂ juɨg₂ Samaria, a₂juá'₂ a₂lɨ́in₅ dsa₂ dsen₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ca₂le₃jɨ́n₃ dsa₂, lia'₂ dsa₂ can'₅₄ lia'₂ chi'₂ në́₃, jme₁nag₂₃ të₅ dsɨ́₅ jág₁ quió'₅, qui₂dsia₂₃: ―Dsa₂ në₅ tɨin₂ quian'₅₄ juɨ₅bí₂ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jme₁tón'₂ dsa₂ juɨ₅ jág₁ quió'₅ gui'₅₄ 'éi₂, ia₁ ma₂lɨ́g'₂ bá₄ ma₂já₅ qui₂jme₂gain₂₃ dsa₂ quian'₅₄ bí₂ a₂chan₂ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","La₁ dsɨ₂juɨ₅ jme₁ca₂rë₃'én₂ dsa₂ jág₁ dse₃ quió'₅ Jesucristo a₂ca₂'ë́₂ Fe₂li₄ juɨ₁lia'₂ ja₁gon₂ Diú₄, jaun₂ qui₂ca₂jŋó₂ dsa₂ jmɨg₂ lia'₂ dsa₂ ŋe'₂ lia'₂ dsa₂ mɨ́₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ján₃ bá₄ ca₂rë₃'én₂ 'ŋiog₅ Si₂mu₅₄ 'éi₂, ca₂jŋói₂ jmɨg₂ ján₃. Jaun₂ guë́₄ ca₂jme₃lióg₃ ca₂jme₃quiain'₅₄ Fe₂li₄, qui₂jág₅ dsɨ₂gó'₃ dsɨ́₅ léi₄ juë'₂ a₂jmo₅ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jme₁ca₂rë₃ŋi₅ dsa₂ i₂chen₄ quián₅ Jesús i₂tion'₅₄ Jerusalén, a₂ma₂'én₂ dsa₂ chan₂ 'uë₃ Samaria jág₁ quió'₅ Diú₄, jaun₂ ca₂chein₃ ja₁jaun₂ Pe₄ quian'₅₄ Juan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Jme₁ca₂dsi₃lén₂ 'éi₂ 'uë₃ Samaria, jaun₂ ca₂mɨ₃ ca₂tsɨ́'₃ Diú₄ o₄quió'₄ dsa₂ i₂ma₂'én₂ ja₁jaun₂, ia₁jaun₂ guen₃ dsa₂ 'éi₂ Jme₂dsí₂ Jŋió₅ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ia₁ 'i₁jan₂ dsa₂ 'éi₂ tsá₃ Jme₂dsí₂ Jŋió₅ ma₂guan₅ guë́₄ ne₄ quió'₅. Jŋia'₅₄ con'₂ ma₂jŋói₂ jmɨg₂ bá₄ lia'₂ con'₂ lë́₅ 'éi'₃ quió'₅ Te₁gui'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jaun₂ në́₃ Pe₄ quiain'₅₄ Juan₅₄ qui₂ca₂quiog₂ gu₂ ne₄ quió'₅ dsa₂ 'éi₂, jaun₂ guë́₄ ca₂guein₃ Jme₂dsí₂ Jŋió₅. ");
INSERT INTO cntNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jme₁ca₂jág₃ Si₂mu₅₄ a₂ca₂sión₃ Jme₂dsí₂ Jŋió₅ jme₁ca₂quiog₂ dsa₂ i₂chen₄ 'éi₂ gu₂ ne₄ quió'₅ dsa₂, jaun₂ ca₂jen'₂ cu₄, ");
INSERT INTO cntNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ca₂juá'₂: ―Cuë₄ jniá₂ ján₃ juɨ₁lia'₂ bí₂ a₂tɨn'₂ 'nia'₂ në₅, ia₁jaun₂ lé₂ le₃jmo₅₄ jniá₂ ján₃ a₂guen₃ dsa₂ Jme₂dsí₂ Jŋió₅ jë₁ma₂ca₂co₃ gu₃ ne₄ quió'₅ chi₂jua'₂ 'ein₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Jaun₂ ca₂ŋag₃ Pe₄ ca₂tsɨ́'₃ dsa₂ 'éi₂: ―Juɨ₁dsi₂'éng'₂ co₂dsia₅ quian'₅₄ cú'₂ ia₁ 'e₂ lë₃ dsɨ₂jiog₅ 'au'₂ le₂në₅, a₂lɨ́ng'₂ a₂lé₂ lá₃ dsa₂ quian'₅₄ cu₄ bí₂ a₂cuë₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tsá₃ ca₂tɨ́n'₂ 'ne₂ a₂në₅, ia₁ tsá₃ dse₃ 'ei₅ 'au'₂ ne₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Co₂dsia₅ tí₃ ca₂le₃jë́₃ a₂'lɨg'₅₄ a₂dsɨ₂jiog₅ 'au'₂ në₅. Mɨ₄ ne₄ Te₁gui'₅₄ chi₂jua'₂ 'éin₂ dsáu'₂ 'e₂ lë₃ dsɨ₂jiog₅ 'au'₂ le₂në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ia₁ léi₄ jniá₂ rë₂rɨn₅ cosa 'lɨg'₅₄ të₂'au'₂; quian'₅₄ dsáu'₂ në₅ jmo₅ chi₁'ŋeg'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jaun₂ në́₃, ca₂ŋag₃ Si₂mu₅₄: ―Mɨ₄ 'nia'₂ chei'₅₄ Te₁gui'₅₄ o₄quió₃, ia₁jaun₂ tsá₃ juɨ₁dsi₂ŋɨ́g₂ a₂ma₂në₂jua'₅₄ 'nia'₂ në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jme₁ca₂dsan₃ jáng'₅ Pe₄ quian'₅₄ Juan₅₄ jág₁ dsau₅ a₂dsia₂₃ jág₁ quió'₅ Diú₄, jaun₂ guë́₄ ca₂i₃lein₃ juɨ₅ Jerusalén. Le₂'i₄ juɨ₅ ja₁i₃lein₃ jaun₂, qui₂ca₂'ë́₂ guë́₄ jág₁ dse₃ a₂lión₂ dsa₂ le₂tan₅₄ juɨg₂ ja₁tén₄ 'uë₃ Samaria. ");
INSERT INTO cntNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Cang₂ jaun₂, ca₂juá'₂ jan₂ ángel quián₅ Te₁gui'₅₄ ca₂tsɨ́'₃ Fe₂li₄: ―Nau₂, gua₂ juɨ₅ ja₁'uɨn₂ dsa₂ Jerusalén a₂dsióg₄ 'uë₃ Gaza. Juɨ₅ jaun₂ dsó₅ jë₄ 'uë₃ quein₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jaun₂ ca₂nau₂ Fe₂li₄ ca₂ŋó₃. Le₂'i₄ juɨ₅ ja₁ŋó₃ jaun₂, ca₂jein'₂ jan₂ dsa₂ chan₂ Etiopía, i₂jme₁lɨ́n₄ jan₂ dsa₂ eunuco, dsa₂ dsen₅₄ i₂niog₅ gu₂ cu₄ quió'₅ 'io₅₄ Candace i₂gon₂ 'uë₃ Etiopía. Dsa₂ 'éi₂ ŋei₅₄ i₁chi₂i₁lein'₄ Diú₄ juɨg₂ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ma₂'ein₅₄ juɨ₅ ŋái'₄ juɨg₂ go₅₄ guá₅ ne₄ carroza quió'₅, 'ɨ₂₃ Si₂ quió'₅ Isaías i₂jme₁'ë́₂ jág₁ quió'₅ Diú₄ ma₂lɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jaun₂ ca₂juá'₂ Jme₂dsí₂ quián₅ Diú₄ ca₂tsɨ́'₃ Fe₂li₄: ―Gua₂ le₃jén'₃ cau₅ carro në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ca₂dsióg₃ Fe₂li₄ cau₅, jaun₂ ca₂nág₂ i₁'ɨ₅ dsa₂ 'éi₂ Si₂ quió'₅ Isaías. Jaun₂ ca₂ŋag₃ Fe₂li₄: ―¿'Ŋɨ́g'₂ 'e₂ juá'₂ si₂ a₂'ɨ'₂? ");
INSERT INTO cntNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jaun₂ ca₂ŋag₃ táng₃ dsa₂ 'éi₂: ―¿'A₂ bá₄ lia'₂ le₃ŋɨ́'₂ jniá₂? Tsá₃ guë'₂ 'ein₂ chan₂ i₂juá'₂ 'e₂ jein₅ jág₁ a₂juá'₂ si₂ la₂. Jaun₂ ca₂tsɨ́'₃ Fe₂li₄ a₂uɨ́g₂ 'éi₂ guei'₅₄ a₂guá₃ co₂lë₅ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jme₁'ɨ₅ dsa₂ 'éi₂ Si₂ quió'₅ Diú₄ ja₁juá'₂ le₂la₂: Ca₂jiog₃ dsa₂ i₁jŋag'₂ juɨ₁lia'₂ jŋɨ'₅ dsa₂ já'₂ cha'₂. Ján₃ guë'₂ juɨ₁lia'₂ tsá₃ guió'₅ guein₂ já'₂ cha'₂ të₁lia'₂ chéi₅ dsa₂ jŋí₁, ján₃ bá₄ le₂jaun₂ tsá₃ 'e₂ ca₂juá'₂ i₂'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ca₂cuë₃ dsa₂ o₂guí'₃, tsá₃ 'éi'₃ rë₂ ca₂të₁dsɨ₅₄ quió'₅; chi'₂ tsɨ₁jon₂ quiáin₅ guë'₂ në́₃, ¿'ein₂ bá₄ lé₂ le₃dsia₃ 'ɨin₃ chi'₂ dsio₅₄? ton'₂ ca₂jŋióg'₂ bá₄ guë'₂ dsa₂ ne₄ gua'₅₄ 'uë₃ la₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jaun₂ ca₂juá'₂ dsa₂ dsen₅₄ 'éi₂ ca₂tsɨ́'₃ Fe₂li₄: ―Jmo₄ dse₃ 'au'₂, jua'₅₄ 'e₂ jein₅ jág₁ a₂juá'₂ si₂ la₂. ¿'Ein₂ 'ɨn₅ dsa₂ quián₅ Diú₄ i₂ca₂jmo₃ si₂ la₂? ¿A₂'ɨin₂₃ 'ŋiog₅, o₃ a₂'ɨin₂₃ i₂sián'₂ 'e₂? ");
INSERT INTO cntNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jaun₂ ca₂jme₃lióg₃ Fe₂li₄ ca₂juá'₂ 'e₂ juá'₂ ne₄ Si₂ ja₁jme₁'ɨ₅ dsa₂ dsen₅₄ 'éi₂, qui₂ca₂cuë₃ jág₁ dse₃ 'ɨin₂₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Jme₁ca₂dsi₃léin₂ caun₂ ja₁cha₂ jmɨg₂, jaun₂ ca₂juá'₂ dsa₂ dsen₅₄ 'éi₂ ca₂tsɨ́'₃ Fe₂li₄: ―Cha₂ jmɨg₂ ja₁lá₃. ¿Cha₁ 'e₂ lë₃ jua'₅₄ tsá₃ lé₂ tsón₄ jniá₂ jmɨg₂? ");
INSERT INTO cntNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Jaun₂ ca₂juá'₂ Fe₂li₄: ―Chi₂jua'₂ 'éng'₂ dsón'₂ ca₂le₃jë́₃ 'au'₂, lé₂ bá₄. Jaun₂ ca₂ŋag₃ táng₃ dsa₂: ―'Én₂ bá₄ jniá₂ a₂lɨ́n₅ Jesucristo Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jaun₂ ca₂jmo₃ 'éi'₃ ca₂jŋia₃ carroza quió'₅. Jaun₂ ca₂sióin₃ le₂oin₃ chei'₅₄ jmɨg₂, jaun₂ ca₂cho₃ Fe₂li₄ jmɨg₂ quió'₅ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jme₁ca₂'uɨin₂ jmɨg₂, jaun₂ Jme₂dsí₂ quián₅ Te₁gui'₅₄ ca₂tág₃ Fe₂li₄, jaun₂ dsɨ₂tan₅₄ 'éi₂ tsá₃ ma₃ca₂jág₂ mei'₂. La₁ 'io'₂ bá₄ jmo₂₃ le₂'i₄ juɨ₅ ja₁ŋái'₄. ");
INSERT INTO cntNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Fe₂li₄ në́₃ ma₂'ein₅₄ caun₂ juɨg₂ ja₁chei₂ Azoto, jaun₂ le₂tan₅₄ guë́₄ juɨg₂ te₁'i₁ ja₁jaun₂ ca₂ŋei₅₄ qui₂ca₂'ë́₂ jág₁ dse₃ a₂lión₂ dsa₂, ca₂lia'₂ ca₂dsióg₃ ca₂të₂ juɨg₂ Cesarea. ");
INSERT INTO cntNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Të₁lia'₂ jaun₂, dsa₂ i₂chen₂ Saulo caun₂ qui₂quiain₂₃ juë́'₅ a₂'nio₃ jme₃dsiáin₃ dsa₂ i₂'én₂ jág₁ quió'₅ Te₁gui'₅₄. Jaun₂ lë₃, ca₂ŋei₅₄ i₁jɨin₂₃ jme₂dsa₂ dsen₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ca₂mɨ₃ ne₄ 'éi₂ caun₂ si₂ a₂cuë₃ bí₂ a₂dsó₃ guá'₅ sinagogas quió'₅ dsa₂ juɨg₂ Damasco a₂dsɨ₃'niai'₂ dsa₂ i₂tion'₅₄ të₂le₃ quió'₅ Juɨ₅ quió'₅ Te₁gui'₅₄. Jme₁'nio₃ Saulo dsɨ₃te₅₄ dsa₂ chi₁'ŋei'₂ ca₂të₂ Jerusalén, lia'₂ dsa₂ ŋe'₂ lia'₂ dsa₂ mɨ́₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","La₁ jme₁ja₂quián₃ dsióg₄ juɨg₂ Damasco, con'₂ tsá₃ jáin₅ jme₁ca₂tág₃ caun₂ si₂ tág₅ jmá'₅ ne₄ quió'₅. Si₂ jaun₂ a₂já₃ juɨ₅ guei'₅₄ i₂juɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Co₂tan₅₄ ca₂quɨn'₃ Saulo, jaun₂ ca₂nág₂ juá'₂ jág₁ jë₄ si₂ jaun₂: ―Saulo, Saulo, ¿'e₂ lë₃ co₂'éin'₅ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jaun₂ ca₂ŋag₃ Saulo: ―¿'Ein₂ 'ne₂, gui'₅₄? Jaun₂ ca₂ŋag₃ táng₃ jág₁ né'₂ jë₄ si₂: ―Jesús bá₄ jniá₂ i₂co₂'én'₅ 'ne₂ ŋɨ'₂. Jŋia'₅₄ jmag'₅₄ uɨg₅ 'ŋiag'₂ bá₄ jmo'₂ juɨ₁lia'₂ jmo₅ ca₁juɨ₅ jë₁ma₂jnáu₃ nɨ₁'ma₂ chen'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Jaun₂ ca₂jlen₃ Saulo, ca₂rë₃gó'₅, ca₂juá'₂: ―Te₁gui'₅₄, ¿'e₂ 'niog'₂ 'ne₂ jmo₅₄ jniá₂? Jaun₂ ca₂ŋag₃ táng₃ Te₁gui'₅₄: ―Nau₂, 'ú₅ juɨg₂ Damasco. Jë₁ma₂dsióg'₃, ja₁jaun₂ bá₄ juá'₂ dsa₂ 'e₂ jmó'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Dsa₂ i₂jme₁quian'₅₄ Saulo në́₃, 'ŋio₅ lɨn₃ ca₂rë₃gó'₅, ia₁ ca₂nág₂ jág₁ a₂juá'₂ jë₄ si₂ jaun₂, ton'₂ 'i₁jan₂ guë'₂ tsá₃ 'ein₂ ca₂jɨ́in₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jaun₂ ca₂nau₂ Saulo, la₁ jme₁ca₂nau₂ jaun₂, tsá₃ ma₃lé₂ jág₃, tsá₃ ma₃jniá₂ mɨ₂ne₅₄. Dsa₂ i₂jme₁quiain'₅₄ bá₄ ca₂tág₃ le₁chan'₂ gu₂, ca₂jiog₃ të₂ juɨg₂ Damasco. ");
INSERT INTO cntNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ja₁jaun₂ ca₂'í₃ tein₅₄ 'nɨ₅ jmɨg₄, tsá₃ 'e₂ ca₂guë́'₃, on₃ guë'₂ 'e₂ ca₂'ɨn'₃ 'i₁caun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Juɨg₂ Damasco jaun₂, jme₁guá₄ jan₂ dsa₂ i₂'én₂ i₂jme₁chen₂ Ananías. I₂'éi₂ ca₂jén'₃ ca₂jɨ́in₂ Te₁gui'₅₄ i₂ca₂juá'₂: ―¡Ananías! Jaun₂ ca₂ŋag₃ 'éi₂: ―Ja₁lá₃ bá₄ 'eng₅₄, Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jaun₂ ca₂juá'₂ táng₃ Te₁gui'₅₄: ―Nau₂, gua₂ calle chei₂ Co₂dsau₅ ja₁quió'₄ dsa₂ chen₂ Judas. Ja₁jaun₂ o₂'nia'₂ jan₂ dsa₂ chan₂ Tarso i₂chen₂ Saulo, i₂'en₅₄ chi₂lén'₂ Diú₄ con'₂ lë́₅ la₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ia₁ ma₂quɨ₃ a₂ma₂jɨ́in₂ jan₂ dsa₂ i₂chen₂ Ananías ca₂'í₃ ca₂quiog₂ gu₂ ne₄ quió'₅ ia₁jaun₂ jnia₃ táng₃ mɨ₂ne₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jme₁ca₂nág₂ Ananías le₂në₅, jaun₂ ca₂juá'₂: ―Te₁gui'₅₄, juɨn₅ dsa₂ ma₂tság₃ jniá₂ ca₂le₃jë́₃ 'e₂ 'lɨg'₅₄ a₂jmo₅ dsa₂ 'éi₂ a₂jmái'₂ dsa₂ chan₂ Jerusalén i₂'én₂ jág₁ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ta₁ jaun₂ já₅ 'éi₂ ja₁lá₃ quian'₅₄ 'éi'₃ quió'₅ juɨg₅₄ jme₂dsa₂ ia₁jaun₂ të₂ le₁'ŋe₅ ca₂le₃jɨ́n₃ dsa₂ quiáng'₂ i₂'ɨn₅ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","La₁ jaun₂ ca₂juá'₂ táng₃ Te₁gui'₅₄: ―La₁ gua₂, ia₁ i₂ma₂quion'₄ jniá₂ 'éi₂ ia₁ 'nio₃ jniá₂ dsó₃ qui₂dsɨ₃'ag₃ jniá₂ lia'₂ jɨn₄ dsɨ₂nau₂ lia'₂ ne₄ rag₅₄ quiáin₅, jɨn₄ dsa₂ israelitas në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ia₁ jniá₂ bá₄ 'ë́₄ 'a₂ lia'₂ tion₅₄ niog₅ ŋág₃ uɨg₅ 'ŋio₅ lɨn₃ o₄quió₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Jaun₂ guë́₄ ŋó₃ Ananías ja₁chí'₄ tsɨ₁'né₅ ja₁jme₁'en₅₄ Saulo. Ca₂'í₃ dsi₂néi₂, ca₂quiog₂ gu₂ ne₄ quió'₅ Saulo, jaun₂ ca₂juá'₂: ―Saulo rɨn'₅₄ jniog₄, Te₁gui'₅₄ Jesús i₂ca₂jeng'₂ le₂'i₄ juɨ₅ lia'₂ con'₂ ŋe'₃, në₂chei₃ jniá₂ ia₁jaun₂ jnia₅₄ táng₃ mɨ₂ne'₅₄, jaun₂ guéng'₄ Jme₂dsí₂ Jŋió₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Co₂tan₅₄ dsɨ₂juɨ₅ jaun₂ qui₂ca₂séi'₂ juɨ₁lia'₂ tsɨ₁ mɨ₂ne₄ Saulo, co₂tan₅₄ ca₂jág₃ táng₃. Jaun₂ guë́₄ ca₂nau₂ Saulo, ca₂i₁choin₃ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jaun₂ ca₂guë́'₃, ca₂tɨ́in'₃ táng₃ bí₂. Jaun₂ ca₂'í₃ bá₄ guë́₄ tɨn₃-'nɨ₅ jmɨg₄ quiain'₅₄ dsa₂ 'én₂ i₂jme₁tián'₄ juɨg₂ Damasco jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dsɨ₂juɨ₅ bá₄ ca₂jme₃lióg₃ Saulo ca₂ŋei₅₄ guá'₅ sinagogas ca₂i₁jme₁tɨin₂₃ dsa₂ a₂juá'₂ a₂lɨ́n₅ Jesús Ja₁ŋi'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ca₂le₃jɨ́n₃ dsa₂ i₂ca₂nág₂ ca₂i₃gó'₃ dsɨ́₅, qui₂ca₂dsia₃: ―¿On₃jua'₅₄ dsa₂ në₅ i₂ŋɨ́₄ lë₃ jme₁ŋɨ₅ juɨg₂ Jerusalén qui₂co₂'ein₂₃ dsa₂ i₂'én₂ le₃quió'₅ Jesús? ¿On₃jua'₅₄ i₂në₅ 'ŋiog₅ i₂ma₂guan₅ ja₁lá₃ a₂qui₂të₂ le₁'ŋe₅ dsa₂ jaun₂ qui₂dsɨ₂jang'₅₄ o₄gú₃ juɨg₅₄ jme₂dsa₂? ");
INSERT INTO cntNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","La₁ të₂le₃ lë́₅ guë́₄ ca₂'ág₂ tiá₂ dsɨ́₅ Saulo, qui₂ca₂'ë́₂ jág₁ a₂lɨ́n₅ dsón'₂ Jesús I₂rë₂'ɨ́n₁ quián₅ Diú₄. Ca₂lia'₂ ca₂i₃cón'₅ dsɨ́₅ dsa₂ judíos i₂jme₁tián'₄ juɨg₂ Damasco ia₁ ca₂'ë́₂ Saulo jág₁ le₂jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","'Lióng₂ jmɨg₄ cang₂ jaun₂, ca₂jmo₃ dsa₂ judíos caun₂ jág₁ a₂jme₁jŋɨi'₃ Saulo. ");
INSERT INTO cntNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","A₂jmɨ₂ a₂'uë₂ qui₂ca₂jŋiai₃ Saulo o₄'né₄ o₄juɨ₅ juɨg₂ jaun₂, ia₁jaun₂ jŋag'₃. La₁ ca₂rë₃ŋi₅ bá₄ Saulo. ");
INSERT INTO cntNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jaun₂ dsa₂ 'én₂ rɨin'₅₄ në́₃, ca₂to'₂ 'ŋió'₃ caun₂ tsɨ₁mɨ'₂ pa₁, jaun₂ a₂'uë₂ ca₂sióin₂ 'éi₂ juɨ₅ ne₄ nɨ₁'ia'₂ a₂jme₁lë́₄ le₃lág'₃ juɨg₂. Jaun₂ le₂në₅ ca₂lóin₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jme₁dsián'₃ Saulo Jerusalén, jme₁'nio₃ jme₃quiain'₅₄ dsɨ₂juɨ₅ dsa₂ 'én₂ ja₁jaun₂. La₁ ca₂le₃jɨ́n₃ dsa₂ 'éi₂ në́₃ ca₂rë₃gain₃ 'éi₂, ia₁ tsá₃ jaun₂ lɨ́in₂ a₂ma₂'én₂ Saulo jág₁ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","La₁ia₁ dsa₂ i₂chen₂ Bernabé ca₂jiog₃ ne₄ dsa₂ guia₃-tɨ́n₂ i₂chen₄ 'éi₂. Jaun₂ ca₂dsia₃ 'a₂ lia'₂ ca₂lë₃ a₂ca₂jme₃jein'₂ Te₁gui'₅₄ le₂'i₄ juɨ₅, 'e₂ jág₁ a₂ca₂juá'₂ në́₃, 'a₂ lia'₂ ca₂dsia₃ Saulo ján₃ tiá₂ dsɨ́₅ juɨg₂ Damasco ca₂'ë́₂ jág₁ 'ɨin₂₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jaun₂ bá₄ ca₂'í₃ Saulo juɨg₂ Jerusalén ca₂jme₃quiain'₅₄ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Caun₂ ca₂dsia₃ tiá₂ dsɨ́₅ bá₄ qui₂ca₂'ë́₂ jág₁ 'ɨin₂₃ Te₁gui'₅₄ qui₂ca₂dsia₃ jág₁ qui₂ca₂tsɨ́in₂ quian'₅₄ dsa₂ judíos i₂dsia₅ jág₁ jmei₅ griego. La₁ dsa₂ 'éi₂ në́₃ caun₂ 'nio₃ jme₁jŋɨi'₃ bá₄ Saulo. ");
INSERT INTO cntNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jme₁ca₂rë₃lí'₄ rɨn'₅₄ Saulo a₂jaun₂, jaun₂ ca₂jiog₃ juɨ₅ juɨg₂ Cesarea. A₂'ein₅₄ guë́₄ ja₁jaun₂ ca₂dsióg'₂ rɨin'₅₄ juɨg₂ go₅₄ ja₁chei₂ Tarso. ");
INSERT INTO cntNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jaun₂ ca₂le₃jɨ́n₃ guá'₅, dsa₂ i₂'én₂, le₂tan₅₄ ja₁tén₄ 'uë₃ Judea, Galilea, Samaria në́₃, tei₄ bá₄ 'ei₅ tion'₅₄ dsa₂, caun₂ ca₂rë₃béin₂ ján₃. Jme₁jme₂gain₃ bá₄ Te₁gui'₅₄ tioin'₅₄. Quian'₅₄ bí₂ quió'₅ Jme₂dsí₂ Jŋió₅, caun₂ qui₂ca₂juɨ́n₂ bá₄ dsa₂ i₂'én₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Lia'₂ con'₂ ŋɨ₅ Pe₄ qui₂dsɨ₂jɨin₅₄ rɨin'₅₄, ca₂i₁jɨin₁₂ ján₃ dsa₂ i₂ma₂'én₂ jág₁ dse₃ i₂jme₁tián'₄ juɨg₂ ja₁chei₂ Lida. ");
INSERT INTO cntNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ja₁jaun₂ ca₂jɨ́in₂ jan₂ dsa₂ 'lian'₂ i₂jme₁chen₂ Eneas i₂ma₂të́₂ jŋia₃ ŋi₂ ron₅, ia₁ tsá₃ lé₂ ŋɨ₃. ");
INSERT INTO cntNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Jaun₂ ca₂juá'₂ Pe₄ ca₂tsɨ́'₃ dsa₂ 'éi₂: ―Eneas, Jesucristo jme₂'lió₂. Nau₂, jmo₄ dse₃ tsɨ₁cama quiáng'₂. Jaun₂ dsɨ₂juɨ₅ le₂jaun₂ ca₂nau₂ Eneas. ");
INSERT INTO cntNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jaun₂ ca₂le₃jɨ́n₃ dsa₂ i₂tián'₅ Lida quian'₅₄ juɨg₂ Sarón ca₂jág₃ a₂ca₂'lón₂ 'éi₂, jaun₂ ca₂jéin'₃ le₃quió'₅ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jmɨg₄ jaun₂ jme₁chan₂ jan₂ 'io₅₄ i₂'én₂ jë₄ juɨg₂ Jope i₂jme₁chen₂ Tabita. Quian'₅₄ jág₁ jmei₅ griego jme₁të́'₂ dsa₂ Dorcas. 'Io₅₄ 'éi₂ lia'₂ con'₂ chain₂ jme₁jmo₂₃ dse₃ jme₂'oin₅₄ dsa₂ te₂ŋé₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Të₃jë₄ jmɨg₄ jaun₂, ca₂rë₃dso'₅₄ Dorcas, ca₂join₃ bá₄ jaun₂ në́₃. Cang₂ jme₁ca₂lë₃ sei₅ dsa₂, jaun₂ ca₂i₁quio₂₃ caun₂ dsi₂néi₂ jë₁ca₂të́₂ tɨn₃ juɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Juɨg₂ Jope ma₂quián₅ bá₄ ja₁niog₅ juɨg₂ Lida ja₁'en₅₄ Pe₄. Jaun₂ jme₁ca₂rë₃ŋi₅ dsa₂ 'én₂ a₂'en₅₄ Pe₄ ja₁jaun₂, jaun₂ ca₂chein₃ on₃ rɨin'₅₄ ca₂i₁te'₂ 'éi₂: ―Ŋia₅ të₂në₃ cón'₅ juɨ₅ Jope. ");
INSERT INTO cntNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jaun₂ ŋó₃ Pe₄ co₂lë₅ quiain'₅₄ dsa₂ 'éi₂. Jme₁ca₂dsióg₃, ca₂i₁jiog₃ dsa₂ ja₁rë₂quian₅ 'lag₄. Ja₁jaun₂ tion'₅₄ le₁ŋɨ'₂ ca₂le₃jɨ́n₃ 'io₅₄ 'nág₂ quɨ'₂-'o₂₃, qui₂ca₂'ë́'₃ Pe₄ 'mɨ'₂ tsɨn'₅₄ dsa₂, ta₁ a₂jme₁jmo₅ Dorcas lia'₂ con'₂ chain₂. ");
INSERT INTO cntNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Jaun₂ ca₂jmo₃ Pe₄ 'éi'₃ ca₂'uɨn₂ dsa₂ dsi₂néi₂ ja₁rë₂quian₅ 'lag₄. Jaun₂ ca₂chi₃jné₃ ca₂chi₃léin'₂ Diú₄. Jaun₂ guë́₄ ca₂jɨ́in₂ 'lag₄, ca₂juá'₂: ―Tabita, nau₂. Dsɨ₂juɨ₅ jaun₂ ca₂ján₃ 'io₅₄ jme₁ne₁₂. Jme₁ca₂jɨ́in₂ Pe₄, ca₂guá₂ 'io₅₄ jaun₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jaun₂ ca₂jŋa'₃ Pe₄ mɨ₂gu₂ 'io₅₄, ca₂chó'₂. Jaun₂ ca₂të́'₃ táng₃ Pe₄ rɨin'₅₄, 'io₅₄ 'nág₂ në́₃, jaun₂ ca₂jɨ́in'₂ 'io₅₄ 'éi₂, la₁ ma₂jein'₅₄ bá₄. ");
INSERT INTO cntNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ta₁caun₂ juɨg₂ Jope ca₂i₃'ág₃ jág₁ a₂ca₂lë₃ le₂jaun₂. Jaun₂ juɨn₅ lɨn₃ dsa₂ ca₂rë₃'én₂ jág₁ quió'₅ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ca₂'í₃ bá₄ guë́₄ Pe₄ 'lióng₂ jmɨg₄ jaun₂ ja₁quió'₄ jan₂ dsa₂ i₂chen₂ Si₂mu₅₄ i₂jme₂dse₃ lo₄ já'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Juɨg₂ Cesarea jme₁chan₂ jan₂ dsa₂ i₂jme₁chen₂ Cornelio, i₂jme₁lɨ́n₄ juɨg₅₄ co₂nió'₃ 'lióg₂ i₂të́'₂ dsa₂ i₂chan₂ Italia. ");
INSERT INTO cntNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Juɨg₅₄ 'lióg₂ 'éi₂ jme₁jme₂gain₃ Diú₄ co₂lë₅ quiain'₅₄ dsa₂ dsi₂néi₂ quió'₅. Ján₃ bá₄ jme₁dsió'₅ cu₄ jme₁jme₂'oin₅₄ dsa₂ judíos. Ca₂le₃jë́₃ jmɨg₄ në́₃, jme₁chi₁léin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Co₂ráun₂ con'₂ hora ŋí₁ 'nɨ₅ le₃ca₂'láu₂, a₂lë₁ca₂jén'₃ ca₂jág₃ ca₂jɨ́in₂ jan₂ ángel quián₅ Diú₄ ca₂'í₃ dsi₂néi₂ ja₁'ein₅₄. Jaun₂ ca₂juá'₂ ángel: ―¡Cornelio! ");
INSERT INTO cntNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jaun₂ ca₂jág₃ Cornelio gó'₅ 'ŋio₅ lɨn₃ ca₂jɨ́in₂ ángel. Jaun₂ ca₂ŋag₃ ca₂juá'₂: ―¿'E₂ lë́₅, gui'₅₄? Jaun₂ guë́₄ ca₂juá'₂ ángel: ―A₂nag₅ bá₄ Diú₄ a₂juɨg'₂ a₂chi₂lein'₅₄. Jág₅ bá₄ a₂jmo'₂ dse₃ 'au'₂ jme₂'ong'₅₄ dsa₂ te₂ŋé₂. ");
INSERT INTO cntNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jaun₂ lë₃ chen₅ dsa₂ juɨg₂ Jope dsɨ₃quiáin₂ dsa₂ i₂chen₂ Si₂mu₅₄ i₂të́'₂ dsa₂ Pe₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","I₂'en₅₄ ja₁quió'₄ Si₂mu₅₄ sián'₂ i₂jmo₅ dse₃ lo₄ já'₂, i₂chí'₅ 'ne₄ chei'₅₄ jmɨ₁ŋí'₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Jme₁ma₂ŋá'₅ ángel, jaun₂ ca₂të́'₃ Cornelio on₃ dsa₂ mozo quiáin₅, jan₂ guë'₂ 'lióg₂, dsa₂ jme₂ti₃ i₂jme₂gan₃ Diú₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jaun₂ ca₂dsia₃ Cornelio ca₂tsɨ́'₃ dsa₂ a₂ca₂jén'₃, jaun₂ ca₂chein₃ dsa₂ juɨ₅ juɨg₂ Jope. ");
INSERT INTO cntNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Jme₁jnia₃ jaun₂, ca₂i₃lén₂ dsa₂ 'éi₂. Pe₄ në́₃ ca₂uɨ́g₂ le₃co'₅₄ tsɨ₁'né₅ con'₂ dsi₃ŋí'₃ a₂chi₃léin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","I₁cón'₅ 'ŋio₅ lɨn₃. Të₁lia'₂ jmo₅ dsa₂ má₃ në́₃, jaun₂ a₂lë₁ca₂jén'₃ ca₂jág₃ Pe₄ ");
INSERT INTO cntNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ca₂niá₃ guei'₅₄ i₂juɨ́g₃. Jaun₂ ca₂sió₃ juɨ₁lia'₂ caun₂ tsɨ₁'mɨ'₂ pa₁ a₂rë₂quein₅ ta₁quén₂ qui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","'Ŋió'₃ jaun₂, jme₁tion'₅₄ ca₂le₃jɨ́n₃ ne₅₄ já'₂: já'₂ cha₂ quén₂ mɨ₂tag₄, já'₂ i₂tsë́'₅ quió'₅, já'₂ i₂'ɨn₅ guei'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jaun₂ ca₂nág₂ Pe₄ jág₁ ca₂juá'₂: ―Nau₂ Pe₄, jme₁dsian₅ já'₂, quɨ́ng'₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Jaun₂ ca₂ŋag₃ Pe₄: ―Jan₂'ón₄, Te₁gui'₅₄. Ia₁ 'i₁co₂ráun₂ tsá₃ ma₂ca₂guë́'₃ jniá₂ nɨ₁ŋɨ₁ já'₂ a₂jmo₅ a₂rë₂'ŋio₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Jaun₂ ca₂ŋag₃ táng₃ jág₁ a₂juá'₂: ―Tsá₃ lë₁juá'₂ 'ne₂ 'lɨg'₅₄ cosa a₂ma₂jmo₃ Diú₄ le₁jë́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","'Nɨ₅ ráun₂ ca₂lë₃ le₂jaun₂, jaun₂ guë́₄ ca₂ŋáu'₃ táng₃ tsɨ₁'mɨ'₂ juɨ₅ guei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Të₁lia'₂ guá₅ Pe₄ 'no'₂ dsɨ́₅ 'e₂ léi₄ jáng'₅ a₂ca₂jág₃ jaun₂, jme₁ca₂dsi₃lén₂ dsa₂ i₂chen₄ quián₅ Cornelio o₄'né₄ quió'₅ Si₂mu₅₄, a₂ŋag₂₃ a₂já'₄ chí'₅ 'ne₄ Si₂mu₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Jme₁ca₂dsi₃lén₂ dsa₂ 'éi₂, ca₂ŋag₃ juá'₂ tiá₂ chi₂jua'₂ 'en₅₄ ja₁jaun₂ jan₂ dsa₂ i₂chen₂ Si₂mu₅₄ i₂të́'₂ dsa₂ Pe₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Të₁lia'₂ jaun₂ caun₂ qui₂'no'₂ dsɨ́₅ Pe₄ a₂ca₂jág₃, jaun₂ ca₂juá'₂ Jme₂dsí₂ Jŋió₅: ―Jag₄; ún₂ dsa₂ o₂lén₂ 'nau'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nau₂, sión₅, gua₂ quiain'₅₄, tsá₃ lë₁jmo₂ 'ɨ₅ 'au'₂ jua'₅₄ lɨ́ng'₂ a₂tsá₃ tí₅ jág₁, ia₁ jniá₂ bá₄ në₂tsɨ́in₂. ");
INSERT INTO cntNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jaun₂ ca₂sión₃ Pe₄ ca₂i₁jɨin₁₂ dsa₂ i₂chen₄ quián₅ Cornelio, jaun₂ ca₂juá'₂ Pe₄: ―Jniá₂ bá₄ 'éi₂ i₂'na'₂ 'nia'₂. ¿Cha₁ ta₁ ja₂nó'₅ 'nia'₂? ");
INSERT INTO cntNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Jaun₂ ca₂ŋag₃ táng₃ dsa₂: ―Gui'₅₄ juɨg₅₄ 'lióg₂ Cornelio bá₄ ca₂chei₃ jnia'₅₄ ja₂náu₅. Dsa₂ dsen₃ bá₄ 'éi₂, i₂jme₂gan₃ Diú₄; 'nio₃ dsa₂ judíos 'ŋio₅ lɨn₃, jme₂go₃ në́₃. Jan₂ ángel i₂chen₄ quián₅ Diú₄ ca₂juá'₂ a₂të́'₂ 'ne₂ ja₁quió'₄ jaun₂ nag₃ 'e₂ jág₁ cuë'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Jaun₂ ca₂juá'₂ Pe₄ tón'₃ dsa₂ 'éi₂ dsi₂néi₂, jaun₂ ja₁jaun₂ ca₂jŋia₃ dsa₂ 'éi₂ quiain'₅₄ Pe₄ a₂'uë₂ jaun₂. Jme₁jnia₃ jaun₂ guë́₄ ca₂ŋó₃ Pe₄ quiain'₅₄ dsa₂ 'éi₂. Ca₂jme₃quiong'₅₄ guë́₄ i₂lɨn₅₄ dsa₂ rɨin'₅₄ i₂jme₁'én₂ i₂jme₁tián'₄ juɨg₂ Jope. ");
INSERT INTO cntNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jme₁jnia₃ jaun₂ guë́₄ táng₃, ca₂dsi₃léin₂ juɨg₂ Cesarea ja₁guá₄ Cornelio. 'Éi₂ guë'₂ në́₃ jme₁ma₂chi₁jŋiog₂₃ quiain'₅₄ co₂nió'₃ o₁rɨin'₅₄ a₂mei₅₄ quiáin₅ i₂jein'₂ 'ŋio₅ lɨn₃ quiain'₅₄ në́₃, i₂ca₂të́'₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Jme₁ca₂dsióg₃ Pe₄ o₄'né₄, co₂tan₅₄ ca₂o₃'ɨ́n₃ Cornelio ca₂guei₃, ca₂chi₃jné₃ ne₄ 'éi₂, ca₂jme₃juag'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","La₁ Pe₄ në́₃ ca₂chó'₂, ca₂juá'₂: ―Nau₂, ia₁ dsa₂ mɨ₂güɨ́g₃ bá₄ jniá₂, juɨ₁lia'₂ 'ne₂ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Të₃ dsia₅ jág₁ Pe₄ quiong'₅₄, ca₂'í₃ dsi₂néi₂, jaun₂ ca₂jág₃ juɨn₅ bá₄ dsa₂ ma₂le₁ŋɨ'₂ dsi₂néi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Jaun₂ ca₂juá'₂ Pe₄ ca₂tsɨ́'₃ dsa₂: ―Ŋi'₅₄ bá₄ 'nia'₂ jaun₂ tsá₃ cuë₅ jmɨg₄ 'Éi'₃ Juá'₅ quió'₅ dsa₂ judíos jua'₅₄ a₂ŋɨi'₂ quian'₅₄ dsɨ₂nau₂, on₃ guë'₂ lé₂ ŋɨ́i₃ dsi₂néi₂ quió'₅. La₁ Diú₄ ma₂'ë₃ a₂tsá₃ të́₄ jniá₂ 'i₁jan₂ dsa₂ tsá₃ le₁jɨ́in₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jaun₂ lë₃ dsɨ₂juɨ₅ bá₄ guio₃ jme₁ca₂dsi₃lén₂ dsa₂ quiáng'₂, të́₂. Tsá₃ në₂jan₅₄ uë́₂. Jaun₂ jme₁'nio₃ le₃guion₅₄ 'e₂ lë₃, 'e₂ ta₁ në₂të'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Jaun₂ ca₂ŋag₃ Cornelio: ―Ma₂quén₂ jmɨg₄, con'₂ hora la₂ jme₁'eng₅₄ dsi₂néi₂ la₂ quió₃, jme₁jme₂'ɨng₅₄, tsá₃ ca₂guë́'₃. Jme₁'eng₅₄ chi₁leng'₄ Diú₄ të₂le₃ ca₂'láu₂. Jaun₂ a₂lë₁ca₂jéin₃ ca₂jɨng₅₄ jan₂ dsa₂ qui'₂ 'mɨ'₂ tiog₂ jau₂. ");
INSERT INTO cntNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jaun₂ ca₂juá'₂ ca₂tság₃ jniá₂: “Cornelio, a₂nág₅ bá₄ Diú₄ a₂juɨg'₂. Jág₅ bá₄ a₂jmo'₂ dse₃ 'au'₂ jme₂'ong'₅₄ dsa₂ te₂ŋé₂. ");
INSERT INTO cntNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jaun₂ lë₃, chen₅ dsa₂ juɨg₂ Jope dsɨ₃quiáin₂ dsa₂ i₂chen₂ Si₂mu₅₄ i₂të́'₂ dsa₂ Pe₄ ján₃. I₂'en₅₄ ja₁quió'₄ Si₂mu₅₄ sián'₂ i₂jmo₅ dse₃ lo₄ já'₂, i₂chí'₅ 'ne₄ chei'₅₄ jmɨ₁ŋí'₄. Jë₁ma₂guain₂₃, dsia₃ jág₁ quian'₅₄ 'ne₂.” ");
INSERT INTO cntNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jaun₂ bá₄ lë₃ ca₂tsɨ́ng₂ dsa₂ dsɨ₂juɨ₅ a₂i₁'niai'₂ 'ne₂ në́₃. Dse₃ bá₄ lia'₂ në₂jmo'₅₄ ŋe'₃. Jaun₂ lë₃ tio'₅₄ jnia'₅₄ ca₂le₃jág₃ le₁ŋag'₂ ne₄ Diú₄ ia₁ 'niog₂ jnia'₅₄ néi₁ jág₁ a₂ma₂cuë₃ Te₁gui'₅₄ a₂juɨg'₅₄ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Jaun₂ ca₂jme₃lióg₃ Pe₄ ca₂juá'₂ ca₂tsɨ́'₃ dsa₂: ―Në₃ guë́₄ dsón'₂ ma₂ŋɨ́'₂ jniá₂, tsá₃ jma₃quén₅ jɨ́n₂ Diú₄ dsa₂ mɨ₂güɨ́g₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ia₁ ca₂le₃jë́₃ juɨg₂ ja₁jme₂gan₃ dsa₂ Diú₄, nag₅ dsa₂ gau₂ jág₁ quió'₅, jmo₂₃ dse₃ në́₃, dsa₂ le₂'éi₂ bá₄ guén'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ca₂juá'₂ Diú₄ ca₂tsɨ́'₃ tsɨ₁jon₂ quián₅ Israel, ca₂'ë́₂ jág₁ a₂tian'₃ dsa₂ tei₄ të₂le₃ quian'₅₄ Jesucristo i₂lɨ́n₅ Te₁gui'₅₄ quián₅ ca₂le₃jɨ́n₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ŋi'₅₄ rë₂ bá₄ 'nia'₂ 'e₂ ca₂lë₃ ta₁caun₂ juɨg₂ go₄ dsa₂ judíos, a₂ca₂jme₃lióg₃ 'uë₃ Galilea, cang₂ jme₁ma₂'ë́₂ Juan₅₄ jág₁, ca₂choin₃ dsa₂ jmɨg₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ŋi'₅₄ bá₄ 'nia'₂ 'a₂ lia'₂ ca₂cuë₃ Diú₄ ca₂cuë́'₃ Jesús chan₂ Nazaret juɨ₅bí₂ quió'₅ Jme₂dsí₂ Jŋió₅; 'a₂ lia'₂ ca₂ŋɨ₃ jmo₂₃ dse₃, jme₂'lióin₂ ca₂le₃jɨ́n₃ dsa₂ i₂jme₁chan₂ jmɨ₁uɨg₅ jmóg'₂ i₂së₃dsen₃. Ca₂le₃jë́₃ a₂në₅ ca₂jmo₃ ia₁ jme₁quiain'₅₄ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ca₂të́₂ ne₄ jnia'₅₄ ca₂le₃jë́₃ a₂në₅ a₂ca₂jmo₃ Jesús, lia'₂ jë₄ juɨg₂ Jerusalén, lia'₂ le₂tan₅₄ ja₁tián'₄ dsa₂ chan₂ Judea. Cang₂ jaun₂ ca₂jŋag'₃ dsa₂ ca₂tion₃ cróg₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","La₁ jë₁ca₂të́₂ 'nɨ₅ jmɨg₄, ca₂jme₃jein'₅₄ táng₃ Diú₄ Jmei₂, ca₂jmo₃ ca₂jme₃jnia₅ 'éi₂ jɨn₄ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tsá₃ ca₂jme₃jniai₂₃ jɨn₄ ca₂le₃jɨ́n₃ dsa₂. Jmá'₃ lia'₂ jë₄ quián₂ jnia'₅₄ bá₄ con'₂ dsa₂ i₂ca₂quióin'₂ le₂jŋiá₅ i₁të₃ ne₄. Ca₂que₅₄ guë́₄ jnia'₅₄ co₂lë₅ quiain'₅₄ jme₁ma₂jein'₅₄ táng₃ jɨn₄ 'lag₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jaun₂ ca₂jmo₃ 'éi'₃ a₂qui₂dsɨ₁'ë́₄ jnia'₅₄ jág₁, a₂dsɨ₁jang'₅₄ jág₁ dsau₅ jɨn₄ dsa₂: Diú₄ ma₂dsiain₃ Jesús a₂qui₃dsɨ₅ 'éi'₃ quió'₅ dsa₂ i₂chan₂, quió'₅ i₂ma₂dsan₃ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ján₃ bá₄ le₂në₅ jáng'₅ jág₁ dsau₅ ca₂le₃jɨ́n₃ dsa₂ i₂jme₁'ë́₂ jág₁ quiáin₅, a₂qui₃'én₂ Diú₄ dsáu₁ ca₂le₃jɨ́n₃ dsa₂ i₂'én₂ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Të₃jë₄ 'ë́₂ guë́₄ Pe₄ jág₁, jme₁ca₂sión₃ Jme₂dsí₂ Jŋió₅ ne₄ quió'₅ ca₂le₃jɨ́n₃ dsa₂ i₂tion'₅₄ nag₅ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Dsa₂ judíos i₂jme₁'én₂ i₂ca₂o₃lén₂ quian'₅₄ Pe₄, tióin₂ jág₅ dsɨ₂gó'₃ dsɨ́₅, ia₁ ján₃ guë'₂ ca₂guen₃ dsɨ₂nau₂ Jme₂dsí₂ Jŋió₅. ");
INSERT INTO cntNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ia₁ nag₂₃ dsia₅ dsa₂ jág₁ jmei₅ siá'₂, jme₂juɨin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Jaun₂ ca₂juá'₂ Pe₄: ―¿Lé₂ le₃jua'₅₄ tsá₃ jmɨg₂ lé₂ tsón₃ dsa₂ në₅, ton'₂ ma₂në₂guein₃ bá₄ guë'₂ Jme₂dsí₂ Jŋió₅, co₂rë₂ bá₄ juɨ₁lia'₂ jniog₄? ");
INSERT INTO cntNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jaun₂ ca₂jmo₃ 'éi'₃ a₂tsón₃ dsa₂ 'éi₂ jmɨg₂, lia'₂ con'₂ lë́₅ 'éi'₃ quió'₅ Jesucristo. Jme₁co₂lág₂ jaun₂, ca₂mɨ₃ dsa₂ ca₂tsɨ́'₃ Pe₄ a₂jŋia₃ guë́₄ tɨn₃-'nɨ₅ jmɨg₄ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ca₂rë₃ŋi₅ jág₁ dsa₂ i₂chen₄ quián₅ Jesús, quiain'₅₄ rɨin'₅₄ i₂tion'₅₄ Judea, a₂ma₂ca₂rë₃'én₂ dsɨ₂nau₂ jág₁ quió'₅ Diú₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jme₁ca₂dsián'₃ táng₃ Pe₄ juɨg₂ Jerusalén, jaun₂ ca₂le₃jɨ́n₃ dsa₂ judíos i₂'én₂ ca₂jí₂ quió'₅ ");
INSERT INTO cntNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ca₂juá'₂: ―¿'E₂ lë₃ ŋeg'₅₄ ja₁con₂ dsɨ₂nau₂ i₁que'₅₄ quiain'₅₄ në́₃? ");
INSERT INTO cntNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jaun₂ ca₂juá'₂ Pe₄ ca₂tsɨ́'₃ dsa₂ ca₂le₃jë́₃ 'a₂ lia'₂ ca₂lë₃, ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Juɨg₂ Jope bá₄ jme₁'eng₅₄, chi₁leng'₄ Diú₄. Të₃jë₄ jaun₂, ca₂jéin₃ ca₂jág₃ juɨ₁lia'₂ caun₂ tsɨ₁'mɨ'₂ tióg₃ pa₁ a₂rë₂quein₅ le₃quén₂ qui'₅₄, ca₂sió₃ juɨ₅ guei'₅₄, ca₂të₂ cau₅ quió₃. ");
INSERT INTO cntNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Jme₁ca₂jág₃ jniá₂ dse₃ 'e₂ tio'₅₄ 'ŋió'₃, jua'₂ ca₂le₃jɨ́n₃ ne₄ já'₂ bá₄ tion'₅₄: já'₂ cha₂ quén₂ mɨ₂tag₄, já'₂ tsáu₂ dsɨ́₅, já'₂ i₂tsë́'₅ quió'₅, já'₂ i₂'ɨn₅ guei'₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jaun₂ ca₂nag₃ jág₁ a₂ca₂juá'₂ ca₂tság₃ jniá₂: “Nau₂ Pe₄, jme₁dsian₅ já'₂, quɨ́ng'₄.” ");
INSERT INTO cntNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Jaun₂ ca₂ŋag₄ jniá₂: “Jan₂'ón₄, Te₁gui'₅₄. Ia₁ 'i₁co₂ráun₂ tsá₃ ma₂'í₅ 'o₃ 'i₁caun₂ a₂'lɨg'₅₄ a₂jmo₅ a₂rë₂'ŋio₅ dsa₂.” ");
INSERT INTO cntNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jaun₂ ca₂ŋag₃ táng₃ jág₁ a₂já₅ guei'₅₄, ca₂juá'₂: “Juɨ₁lia'₂ a₂ma₂jmo₃ Diú₄ le₁jë́₃, tsá₃ lë₁juá'₂ 'ne₂ 'lɨg'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","'Nɨ₅ ráun₂ ca₂lë₃ le₂jaun₂, jaun₂ guë́₄ ca₂ŋáu'₃ táng₃ ca₂le₃jë́₃ juɨ₅ guei'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Të₃jë₄ jaun₂ ca₂dsi₃lén₂ ún₂ dsa₂ 'né₅ ja₁jme₁'eng₅₄, i₂chen₄ quián₅ dsa₂ chan₂ Cesarea a₂'nau'₂ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jaun₂ Jme₂dsí₂ quián₅ bá₄ Diú₄ ca₂chei₃ ca₂ŋó₃ quiang'₅₄ dsa₂ 'éi₂, caun₂ bá₄ 'ei₅ dsɨ₃ ŋó₃. Ján₃ bá₄ i₁len₅₄ jŋé₂ rɨn'₅₄ jniog₄ la₂ quiong'₅₄ jniá₂. Jaun₂ ca₂tió'₄ jnia'₅₄ ca₂le₃jág₃ dsi₂néi₂ quió'₅ dsa₂ chan₂ Cesarea 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Dsa₂ 'éi₂ ca₂dsia₃ ca₂tság₃ jnia'₅₄ 'a₂ lia'₂ ca₂jɨ́in₂ jan₂ ángel jme₁chén'₄ dsi₂néi₂ quió'₅ i₂ca₂juá'₂: “Chen₅ dsa₂ juɨg₂ Jope a₂dsɨ₃quiáin₂ Si₂mu₅₄ i₂të́'₂ dsa₂ Pe₄ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Dsa₂ 'éi₂ juá'₂ 'a₂ lia'₂ jmó'₂, ia₁jaun₂ lióng'₂, quiang'₅₄ dsa₂ dsi₂néi₂ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Jme₁ca₂jme₁lióg₄ jniá₂ juɨ́g₂ jág₁, jaun₂ ca₂sión₃ Jme₂dsí₂ Jŋió₅ ne₄ quió'₅ dsa₂ 'éi₂, juɨ₁lia'₂ ca₂guain₃ ne₄ quián₂ jniog₄ le₂'uɨg₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jaun₂ guë́₄ ca₂dsáu'₃ dsɨ₃ a₂ma₂ca₂juá'₂ Te₁gui'₅₄ le₂jŋiá₅: “Dsau₅ bá₄ ca₂tióg₃ Juan₅₄ ca₂tiáin₂ jmɨg₂ dsa₂, la₁ 'nia'₂ guë'₂ në́₃ tióg₂ Diú₄ Jme₂dsí₂ Jŋió₅.” ");
INSERT INTO cntNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jaun₂ chi₂jua'₂ co₂rë₂ bá₄ ca₂cuë₃ Diú₄ ca₂cuë́'₃ dsa₂ 'éi₂ juɨ₁lia'₂ a₂ma₂cuë₃ jniog₄ i₂ma₂'én₂ të₂le₃ quió'₅ Te₁gui'₅₄ Jesucristo, ¿i₂'ein₂ bá₄ jniá₂ jua'₅₄ jniá₂ jnɨg₅₄ 'éi'₃ quió'₅ Diú₄? ");
INSERT INTO cntNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jme₁ca₂nág₂ dsa₂ jág₁ në₅, tei₄ bá₄ ca₂jmo₃. Jaun₂ ca₂jme₃juɨin'₂ Diú₄, ca₂tsɨ́'₃ rɨin'₅₄: ―¡Ján₃ guë́₄ ma₂cuë₃ Diú₄ jmɨg₄ quió'₅ dsɨ₂nau₂, a₂jme₂tsɨ́in₃ dsɨ́₅ ia₁jaun₂ tɨ́in'₄ le₃chain₂ co₂tan₅₄! ");
INSERT INTO cntNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Lia'₂ con'₂ jme₁ca₂jŋɨ'₃ dsa₂ Esteban, caun₂ qui₂ca₂co₃'ein₃ bá₄ dsa₂ quió'₅ ca₂le₃jɨ́n₃ dsa₂ i₂'én₂. Jaun₂ tion₅₄ bá₄ ca₂cuɨng₃ ca₂i₃léin₂ ca₂të₂ Fenicia, Chipre, Antioquía në́₃. La₁ jmá'₃ dsa₂ judíos bá₄ ca₂cuë́'₃ jág₁ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","La₁ i₂lɨn₅₄ dsa₂ 'én₂ i₂chan₂ Chipre quian'₅₄ Cirene ca₂dsi₃léin₂ juɨg₂ Antioquía ca₂dsia₃ jág₁ quian'₅₄ dsa₂ chan₂ Grecia, ca₂'ë́₂ jág₁ dse₃ ca₂'ɨin₃ Te₁gui'₅₄ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ca₂jme₃'on₅₄ Te₁gui'₅₄ dsa₂ 'éi₂ ja₁jaun₂ quian'₅₄ bí₂ quió'₅, jaun₂ lë₃ juɨn₅ lɨn₃ dsa₂ ca₂jéin'₃ le₃quió'₅ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jme₁ca₂rë₃ŋi₅ dsa₂ 'én₂ i₂tion'₅₄ Jerusalén, jaun₂ ca₂chein₃ Bernabé ca₂të₂ Antioquía. ");
INSERT INTO cntNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Jme₁ca₂dsióg₃ Bernabé ja₁jaun₂, jaun₂ ca₂jág₃ a₂dse₃ dsɨ́₅ Diú₄ a₂ca₂jmo₃ ja₁con₂ dsa₂ 'éi₂, jaun₂ lë₃ ca₂jmo₃ 'io'₂. Jaun₂ ca₂toin'₂ dsa₂ jág₁ dsia₃ tiá₂ dsɨ́₅, tsán'₂ tiá₂ jág₁ 'ein₃ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ia₁ dsa₂ dsen₃ bá₄ jme₁lɨ́n₄ Bernabé, jme₁rë₂rɨn₅ Jme₂dsí₂ Jŋió₅ të₂dsɨ́₅, jme₁'éin₂ 'ŋio₅ lɨn₃. Jaun₂ le₂në₅ juɨn₅ dsa₂ ca₂jén'₃ të₂le₃ ja₁con₂ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Cang₂ jaun₂ ca₂ŋó₃ Bernabé juɨg₂ Tarso a₂ca₂i₁'niai'₂ Saulo. Jme₁ca₂dsáin'₂ 'éi₂, jaun₂ ca₂tág₃ juɨg₂ Antioquía. ");
INSERT INTO cntNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ja₁jaun₂ ca₂tóin'₂ caun₂ ŋi₂ quiain'₅₄ dsa₂ i₂'én₂ ja₁jaun₂, qui₂ca₂jme₃tɨin₂₃ juɨn₅ lɨn₃ dsa₂. Juɨg₂ Antioquía jaun₂ bá₄ ja₁le₂'uɨg₅₄ ca₂quiong₃ dsa₂ ca₂quiain₃ dsa₂ i₂'én₂ “cristianos”. ");
INSERT INTO cntNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jmɨg₄ jaun₂, i₂lɨn₅₄ dsa₂ i₂jme₁cuë₅ jág₁ dse₃ a₂ma₂gue₃ quió'₅ Diú₄ ca₂'uɨin₂ juɨg₂ Jerusalén ca₂i₁lein₅₄ Antioquía. ");
INSERT INTO cntNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jan₂ i₂chen₂ Agabo ca₂nau₂ jɨn₄ rɨin'₅₄. Jaun₂ quian'₅₄ bí₂ quió'₅ Jme₂dsí₂ Jŋió₅, ca₂'ë́₂ jág₁ a₂le₃'ɨn₂ a₂guë́'₃ dsa₂ ta₁caun₂ mɨ₂güɨ́g₃. Jaun₂ le₂jaun₂ ca₂rë₃ti₃ në́₃ jmɨg₄ lia'₂ con'₂ jme₁guá₄ gui'₅₄ emperador Claudio. ");
INSERT INTO cntNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jaun₂ ca₂le₃jɨ́n₃ dsa₂ 'én₂ i₂chan₂ Antioquía ca₂jmo₃ caun₂ jág₁ ca₂jme₃'oin₅₄ rɨin'₅₄ i₂jme₁tián'₄ Judea, 'a₂ con'₂ jŋia'₅₄ quɨ'₅₄ jmɨg₄ cuë₃ le₂jain₂ le₂jain₂. ");
INSERT INTO cntNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jaun₂ le₂në₅ ca₂jmo₃. Ca₂chein₃ cu₄ ne₄ dsa₂ can'₅₄ quián₅ dsa₂ 'én₂, ca₂i₁can₅ Bernabé quian'₅₄ Saulo. ");
INSERT INTO cntNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jmɨg₄ jaun₂ ca₂jme₃lióg₃ Rag₅₄ Herodes qui₂ca₂jmái'₂ dsa₂ i₂'én₂. ");
INSERT INTO cntNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ca₂jmo₃ 'éi'₃ ca₂jŋɨ'₃ dsa₂ Jacobo rɨn'₅₄ Juan₅₄, quian'₅₄ ŋi₁tág₂. ");
INSERT INTO cntNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jme₁ca₂jág₃ Herodes a₂ca₂të́₂ dsɨ́₅ dsa₂ judíos, jaun₂ ca₂jmo₃ táng₃ 'éi'₃ ca₂jŋa'₃ dsa₂ Pe₄ ján₃. Ca₂le₃jë́₃ a₂në₅ ca₂lë₃ lia'₂ con'₂ jmo₅ dsa₂ jmɨg₄ a₂guë́'₅ dsa₂ i₁ŋí'₄ 'ua'₂ a₂tsá₃ levadura quian'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Jme₁ma₂në₂chán'₂ dsa₂ Pe₄, jaun₂ ca₂jmo₃ Herodes 'éi'₃ ca₂to'₂ 'né₅ 'má₃, jaun₂ ca₂tón'₂ quén₂ nió'₃ 'lióg₂ i₂lë́₂ jma₃quén₂ le₂caun₂ nió'₃, qui₂ca₂jmo₃ 'í₁ Pe₄. Jme₁dsɨ₂jiog₅ dsɨ́₅ Herodes jme₁dsei₂₃ të₃jɨn₄ dsa₂ juɨg₂ jë₁ma₂ca₂ŋɨ́₂ Jmɨg₄ Të₂'ɨn₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jaun₂ le₂në₅ 'en₅₄ Pe₄ né'₃ 'má₃, lë́₅ 'í₁ dse₃ lɨn₃. La₁ dsa₂ rɨin'₅₄ në́₃ caun₂ chi₂léin'₂ Diú₄ bá₄ tioin'₅₄ mɨ₂₃ 'ŋio₅ lɨn₃ o₄quió'₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Caun₂ 'uë₂, juɨ₁lia'₂ 'ióg₃ jme₁ma₂lë́₅ jág₁ jme₁dsei₅ Herodes jɨn₄ dsa₂ juɨg₂, a₂'uë₂ jaun₂ jme₁rë₂quian₅ Pe₄ rë₂güɨ́in₃ rë₂'ŋei₂₃ dse₃ lɨn₃ quian'₅₄ tɨn₃ cadenas jë₄ quió'₅ on₃ 'lióg₂. 'Lióg₂ sián'₂ guë'₂ jme₁tion'₅₄ o₄'né₄ jmo₂₃ 'í₁ 'né₅ 'má₃. ");
INSERT INTO cntNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Të₃jë₄ jaun₂, ca₂jme₃jnia₅ jan₂ ángel quián₅ Te₁gui'₅₄, jaun₂ ca₂tág₃ si₂ ta₁caun₂ dsi₂néi₂ 'né₅ 'má₃. Jaun₂ ca₂quén'₃ ángel dsɨ₂con₂ Pe₄ a₂ca₂ŋei₃. Jaun₂ ca₂juá'₂: ―Nau₂ të₂në₃ cón'₅. Jaun₂ ca₂séi'₂ 'uë₃ nɨ₁ŋí₁ cadenas a₂jme₁tio'₅₄ gu₂ Pe₄. ");
INSERT INTO cntNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jaun₂ ca₂juá'₂ táng₃ ángel: ―Dse₃ 'ŋéi₂ tog'₂, tio'₂ lau₂ tag'₅₄. Jme₁ca₂lë₃ jmo₅ Pe₄ a₂jaun₂, jaun₂ ca₂juá'₂ táng₃ ángel: ―Qui'₂ 'mɨ'₂ dsiog₂ quiáng'₂, 'éin₃ jniá₂. ");
INSERT INTO cntNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Jaun₂ ca₂o₃'ɨ́n₃ Pe₄ chi₁co'₅₄ quió'₅ ángel. Tsá₃ jaun₂ ŋi₅ chi₂jua'₂ dsón'₂ dsɨ₂jó'₃ a₂ca₂jmo₃ ángel le₂jaun₂, ia₁ a₂lë₁ca₂jág₃ bá₄ lɨ́in₂. ");
INSERT INTO cntNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Jaun₂ ca₂ŋɨi₅ ja₁le₂'uɨg₅₄ tion'₅₄ 'lióg₂, ja₁ca₂të́₂ táng₃ në́₃. Jme₁ca₂dsi₃léin₂ o₄'né₄ a₂lë́₅ quian'₅₄ nɨ₁ŋí₁, ja₁'uɨn₂ dsa₂ jë₄ calle, a₂lë₁ca₂niá₃ 'ŋiog₅ bá₄ o₄'né₄. Ca₂'uɨin₂ bá₄ jaun₂ në́₃. Jme₁ma₂i₂nioi₅₄ caun₂ calle, jaun₂ ca₂ŋá'₃ ángel 'éi₂, ca₂téin₂ Pe₄. ");
INSERT INTO cntNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jaun₂ guë́₄ ca₂rë₃lí'₄ Pe₄, ca₂juá'₂: ―Në₃ guë́₄ dsón'₂ guion₄ jniá₂ a₂në₂chen₃ Te₁gui'₅₄ ángel quiáin₅ a₂në₂lió₂ ja₁con₂ Herodes, ca₂le₃jë́₃ guë́₄ 'e₂ jme₁'nio₃ dsa₂ judíos jmóg'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Të₃ dsɨ₂jiog₅ dsɨ́₅ le₂jaun₂ Pe₄, ca₂ŋó₃ juɨ₅ ja₁quió'₄ María chog₅₄ Juan₅₄ i₂chen₂ Marcos ján₃. Ja₁jaun₂ jme₁tion'₅₄ dsa₂ le₁ŋɨi'₂ chi₂léin'₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Jme₁ca₂quein₃ Pe₄ o₄'né₄ i₁dsi₅, jaun₂ ca₂o₃'ɨ́n₃ jan₂ 'io₅₄ bë'₅₄ i₂chen₂ Rode i₃jág₂ 'ein₂ të́₂. ");
INSERT INTO cntNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","La₁ jme₁ca₂nág₂, ca₂rë₃cuɨ́'₅ jág₁ quió'₅ Pe₄ në́₃, jaun₂ tsá₃ ca₂niá₃ dsɨ₂juɨ₅, ia₁ ŋɨ́₄ lë₃ ca₂jmo₃ 'io'₂. Jaun₂ ca₂ŋái'₃ bá₄ táng₃ dsi₂néi₂ i₁con₂ jág₁, Pe₄ bá₄ 'éi₂ ca₂dsióg₃. ");
INSERT INTO cntNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Jaun₂ ca₂juá'₂ dsa₂ ca₂tsɨ́'₃ 'io₅₄ bë'₅₄ 'éi₂: ―¡A₂lë₁të₂'ɨ'₂ bá₄ 'ne₂! La₁ caun₂ ca₂juá'₂ bá₄ 'io₅₄, a₂dsón'₂ bá₄ 'éi₂. Jaun₂ ca₂ŋag₃ táng₃ dsa₂, ca₂juá'₂: ―¿'A₂ bá₄ lia'₂ jaun₂? On₃jua'₅₄ 'éi₂ në₅. 'Ɨn₁ ángel quiáin₅ bá₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Të₁lia'₂ jaun₂, caun₂ i₁të₅₄ bá₄ Pe₄ o₄'né₄ i₁chéin'₄. Jme₁ca₂niá₃, ca₂jɨ́in₂ Pe₄, jaun₂ ca₂i₃gó'₃ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","La₁ jaun₂ ca₂jmo₃ 'éi₂ léi₄ quian'₅₄ mɨ₂gu₂ a₂ca₂juá'₂ a₂jmo₃ dsa₂ tei₄. Jaun₂ ca₂dsia₃ 'a₂ lia'₂ ca₂lë₃ ca₂jmo₃ Te₁gui'₅₄ a₂ca₂i₁dsei₂₃ 'né₅ 'má₃. Jaun₂ ca₂juá'₂: ―O₂dsia₄ 'nia'₂ o₂chei'₅₄ Jacobo, ca₂le₃jɨ́n₃ guë́₄ rɨn'₅₄ jniog₄. Jaun₂ ca₂o₃'ɨ́in₃ táng₃, ca₂ŋó₃ ja₁siá'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Jme₁jnia₃ jaun₂, ca₂tón'₂ 'lióg₂ go₂'i₃, ia₁ tsá₃ ŋi₅ 'e₂ ca₂lë₃ quian'₅₄ Pe₄. ");
INSERT INTO cntNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jaun₂ Herodes ca₂chein₃ dsa₂ dsɨ₃'niog'₂. La₁ia₁ tsá₃ ma₃ca₂dsáu'₂. Jaun₂ jme₁ca₂cáun₂ jág₁ dsau₅ quió'₅ 'lióg₂ i₂jme₁jmo₅ 'í₁ 'éi₂, ca₂jmo₃ 'éi'₃ ca₂jme₃dsiog₅ dsa₂. Cang₂ jaun₂, ca₂o₃'ɨ́n₃ Herodes 'uë₃ Judea, jaun₂ ca₂ŋó₃ ca₂i₁gua₂ Cesarea. ");
INSERT INTO cntNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Jme₁'ne₂ Herodes quian'₅₄ dsa₂ i₂jme₁tián'₄ Tiro quian'₅₄ Sidón. La₁ dsa₂ 'éi₂ në́₃ ca₂jmo₃ caun₂ jág₁ ca₂i₁lein₅₄ ca₂jme₁jniai₂₃ ne₅₄. Ca₂jme₃'uáin₂ dsɨ́₅ jan₂ i₂chen₂ Blasto a₂jmo₃ dse₃ dsɨ́₅. Jme₁lɨ́n₄ Blasto jan₂ dsɨ₂tan₅₄ juɨn'₂ quián₅ Rag₅₄ Herodes. Ca₂nau₂ ne₄ jág₁, ca₂mɨ₃ dsian₅ mɨ'₅₄. Ia₁ juɨg₂ go₄ rag₅₄ bá₄ jme₁rau₂ a₂guë́'₅ dsa₂ chan₂ Tiro quian'₅₄ Sidón. ");
INSERT INTO cntNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes në́₃ ca₂të₃, ca₂tióng₃ caun₂ jmɨg₄ a₂chi₁jŋiog₂₃ dsi₁lén₂ dsa₂. Jme₁ca₂të́₂ jmɨg₄ jaun₂, ca₂quɨ́'₂ Herodes tsɨn'₅₄ a₂rë₂lɨin₅₄ a₂lɨ́in₅ rag₅₄, jaun₂ ca₂i₁gua₂ ne₄ ne₄ta₁ quió'₅, jaun₂ ca₂ton₃ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Jaun₂ ca₂jme₃lióg₃ dsa₂ juɨg₂ qui₂ca₂guió'₃ ca₂juá'₂: ―¡I₂juá'₂ në₅, on₃jua'₅₄ dsa₂ mɨ₂güɨ́g₃! Jan₂ diú₄ bá₄ në₅. ");
INSERT INTO cntNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Co₂tan₅₄ dsɨ₂juɨ₅ le₂jaun₂ ca₂jmo₃ ángel i₂chen₄ quián₅ Te₁gui'₅₄ a₂ca₂rë₃dso'₅₄ Herodes, ia₁ ca₂cuë₃ jmɨg₄ a₂jme₃juag'₂ dsa₂ 'ŋiog₅, 'nió'₄ a₂jme₁jme₃juɨin'₂ Diú₄. Ca₂join₃ bá₄ jaun₂ në́₃, ca₂dsó'₃ i₁ja'₅₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","La₁ jág₁ dse₃ quió'₅ Te₁gui'₅₄ në́₃ caun₂ ca₂i₃'ág₃ bá₄, qui₂ca₂'ë́₂ dsa₂ 'lióng₂ juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jme₁ca₂lë₃ ta₁ jaun₂ quió'₅ Bernabé quian'₅₄ Saulo, jaun₂ ca₂'uɨin₂ Jerusalén ca₂i₃lein₃ jŋiai₂₃ i₂jme₁chen₂ Juan₅₄ i₂jme₁të́'₂ dsa₂ Marcos ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Co₂nió'₃ dsa₂ i₂'én₂ jág₁ quió'₅ Jesús, i₂jme₁tián'₄ juɨg₂ Antioquía, jme₁chan₂ dsa₂ i₂jme₁'ë́₂ jág₁ quiáin₅, të₅ në́₃, juɨ₁lia'₂ Bernabé quian'₅₄ Si₂mu₅₄ (i₂të́'₂ dsa₂ dsa₂ lia'₂); Lucio i₂chan₂ Cirene; Manaén në́₃ (i₂co₂lë₅ ca₂can'₅₄ quian'₅₄ Herodes i₂lɨ́n₅ dsi₄má'₂ 'uë₃ Galilea); quian'₅₄ Saulo në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Co₂ráun₂ tioin'₅₄ le₁ŋɨi'₂ jme₂juɨin'₂ Te₁gui'₅₄, a₂jme₂'ɨin₅₄, jaun₂ ca₂juá'₂ Jme₂dsí₂ Jŋió₅: ―Con'₂ chén'₂ 'nia'₂ Bernabé quian'₅₄ Saulo, ia₁jaun₂ dsɨ₃jmó₂ ta₁ a₂ma₂të́₃ jniá₂ jmo₃. ");
INSERT INTO cntNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jaun₂ jme₁ca₂lë₃ chi₂léin'₂ Diú₄, a₂jme₂'ɨin₅₄ në́₃, qui₂ca₂quiog₂ gu₂ ne₄ quió'₅ dsa₂ 'éi₂, jaun₂ guë́₄ qui₂ca₂'ág'₃ jág₁ rɨin'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jaun₂ ca₂chei₃ Jme₂dsí₂ Jŋió₅ ca₂chein₃ Bernabé quian'₅₄ Saulo a₂ca₂i₃léin₂ juɨ₅ Seleucia. Ja₁jaun₂ ca₂tóin'₂ nɨ₁barco a₂ca₂i₃léin₂ caun₂ 'uë₃ a₂niog₅ jë₄ jmɨ₁ŋí'₄, ja₁chei₂ Chipre. ");
INSERT INTO cntNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Jme₁ca₂dsi₃léin₂ ja₁jaun₂, caun₂ juɨg₂ a₂niog₅ chei'₅₄ jmɨ₁ŋí'₄ ja₁të́'₂ dsa₂ Salamina, ja₁jaun₂ ca₂jme₃lióg₃ qui₂ca₂'ë́'₃ dsa₂ jág₁ dse₃ quió'₅ Te₁gui'₅₄ dsi₂néi₂ guá'₅ sinagogas quió'₅ dsa₂ judíos. Jme₁quiain'₅₄ bá₄ Juan₅₄ ján₃ i₂lɨ́n₅ dsa₂ i₂jme₂'o₅₄ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ca₂i₁nioi₂ ta₁caun₂ 'uë₃ jaun₂, ca₂dsi₃léin₂ caun₂ juɨg₂ ja₁të́'₂ dsa₂ Pafos. Ja₁jaun₂ ca₂jein'₂ jan₂ dsa₂ judío, jan₂ dsa₂ i₂chan₂ dsɨ́₅, i₂tɨn₂ jág₁ të₂jág₁, a₂jme₁jme₂gain₂₃ dsa₂ a₂juá'₂ a₂lɨ́in₅ jan₂ i₂'ë́₂ jág₁ quián₅ Diú₄. Dsa₂ 'éi₂ jme₁të́'₂ dsa₂ Barjesús. ");
INSERT INTO cntNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jme₁ quiain'₅₄ dsi₄má'₂ i₂chen₂ Sergio Paulo. Dsi₄má'₂ 'éi₂ jme₁lɨ́n₄ jan₂ dsa₂ i₂niog₅ dsi₄ 'ŋio₅ lɨn₃. Co₂ráun₂ ca₂të́'₃ Bernabé quian'₅₄ Saulo, ia₁ a₂'nio₃ nag₃ jág₁ dse₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","La₁ Barjesús 'éi₂ në́₃, i₂të́'₂ dsa₂ Elimas ján₃, tsá₃ jme₁'nio₃ a₂le₃'én₂ dsi₄má'₂. Jaun₂ jme₁jné₅ juɨ₅. ");
INSERT INTO cntNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Jaun₂ Saulo, i₂të́'₂ dsa₂ Pablo ján₃, rë₂rɨn₅ Jme₂dsí₂ Jŋió₅ të₂dsɨ́₅, ca₂jɨ́in₂ tiá₂ dsa₂ 'éi₂, ");
INSERT INTO cntNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","jaun₂ ca₂juá'₂: ―¡'Ne₂ dsa₂ të₂jág₁, dsa₂ quián₅ i₂së₃dsen₃, i₂'io'₅₄ ca₂le₃jë́₃ cosa dse₃! ¿'E₂ lë₃ qui₁jnɨg'₄ juɨ₅ co₂dsau₅ quió'₅ Te₁gui'₅₄? ");
INSERT INTO cntNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Të₂në₃ cón'₅ 'ë́₂ Te₁gui'₅₄ jmɨ₁uɨg₅ quiáng'₂, co₂dsia₅ téng'₂, co₂'na₂ tsá₃ ma₃lé₂ jag'₅₄ si₂ quió'₅ 'iog₂. Dsɨ₂juɨ₅ jaun₂ ca₂téin₂ co₂dsia₅, qui₁né'₃ ca₂jén'₃. Jaun₂ jme₁'nai'₂ jan₂ i₂të₂ tsán'₂ gu₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jme₁ca₂jág₃ gui'₅₄ dsi₄má'₂ a₂ca₂lë₃ jaun₂, ca₂rë₃'éin₂ ca₂nág₂ dsɨ₂gó'₃ dsɨ́₅ jág₁ dse₃ quió'₅ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ca₂'í₃ Pablo quian'₅₄ rɨin'₅₄ 'ŋió'₃ nɨ₁barco juɨg₂ Pafos, ca₂i₃léin₂ juɨ₅ Perge, juɨg₂ tén₅ 'uë₃ Panfilia. Ca₂tén₂ Juan₅₄ rɨin'₅₄ ja₁jaun₂, jaun₂ ca₂ŋái'₃ juɨ₅ Jerusalén. ");
INSERT INTO cntNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ca₂'uɨn₂ rɨin'₅₄ Perge ca₂dsi₃léin₂ táng₃ Antioquía, juɨg₂ tén₅ 'uë₃ Pisidia. Jaun₂ ca₂i₃toin'₅₄ guá'₅ sinagoga caun₂ jmɨg₄ sa₅₄, jaun₂ ca₂tiáin'₂ dsi₂néi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jme₁ma₂ca₂lë₃ 'ɨ₅ dsa₂ Si₂ 'Éi'₃ quió'₅ Diú₄ quian'₅₄ Si₂ a₂ca₂jmo₃ dsa₂ i₂jme₁'ë́₂ jág₁ ma₂lɨ́g'₂ në́₃, jaun₂ ca₂chen₃ jág₁ dsa₂ can'₅₄ quián₅ guá'₅ sinagoga, ca₂juá'₂: ―Rɨn'₅₄ jniog₄, chi₂jua'₂ cha₂ jág₁ dse₃ quián'₂ 'nia'₂ a₂cuë'₅₄ dsa₂, lé₂ bá₄ jua'₅₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Jaun₂ ca₂nau₂ Pa₄ ca₂jmo₃ léi₄ quian'₅₄ gu₂ a₂mɨ₂₃ a₂jmo₃ dsa₂ tei₄, jaun₂ ca₂juá'₂: ―Nei₂ 'nia'₂ dsa₂ israelitas, 'nia'₂ guë́₄ dsa₂ sián'₂ i₂gan₃ Diú₄: ");
INSERT INTO cntNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Diú₄ quián₂ jniog₄ dsa₂ lág₅ juɨg₂ Israel ca₂quióin'₂ dsa₂ can'₅₄ quián₂ jniog₄ ma₂lɨ́g'₂. Ca₂jmo₃ Diú₄ ca₂i₃juɨ́n₂ dsa₂ 'éi₂ lia'₂ con'₂ jme₁tiáin'₄ 'uë₃ Egipto a₂lɨ́in₅ dsɨ₂nau₂. Cang₂ jaun₂ ca₂lë₃ caun₂ juɨg₂ pa₁. Diú₄ në́₃ ca₂lió₂ quian'₅₄ bí₂ quió'₅, ca₂'uág'₂ 'uë₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ca₂jme₃juɨn'₂ Diú₄ dsɨ́₅ quiong'₅₄ të₂láu₃ ŋi₂ të₁lia'₂ jme₁i₂nioi₅₄ gua'₅₄ quein₂, ");
INSERT INTO cntNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ca₂'éin₂ guio₃ juɨg₂ go₄ dsa₂ i₂jme₁tián'₄ 'uë₃ Cana'án, 'uë₃ jaun₂ në́₃ ca₂cuë́'₃ dsa₂ can'₅₄ quián₂ jniog₄ i₂jme₁chan₂ ma₂lɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","'Cang₂ jaun₂ ca₂dsɨn₃ con'₂ quén₂ 'ŋiá₂-láu₂ rë₂dsɨ́₂ të₂láu₃-guiá₂ (450) ŋi₂, ca₂qui₃dsɨ₅ Diú₄ 'éi'₃ jɨn₄ dsa₂ 'éi₂ të₂le₃ quian'₅₄ juë́₄ ca₂lia'₂ ca₂të́₂ jmɨg₄ a₂ca₂rë₃chán₃ Samuel i₂qui₂ca₂'ë́₂ jág₁ quió'₅ Diú₄ cang₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Jaun₂ ca₂mɨi₃ jan₂ rag₅₄. Jaun₂ Diú₄ në́₃ ca₂cuɨin₃ Saúl ja₁ŋi'₅₄ Cis, tsɨ₁jon₂ Benjamín; ca₂jmo₃ 'éi'₃ con'₂ të₂láu₃ ŋi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Cang₂ jaun₂ ca₂jŋiá'₂ Diú₄ ta₁ quió'₅ Saúl a₂jme₁lɨ́in₄. Jaun₂ David bá₄ ca₂chein'₃ ca₂lɨin₃ rag₅₄. Jaun₂ ca₂juá'₂ Diú₄ 'ɨin₂₃ Rag₅₄ David: “Ca₂dsó'₂ jniá₂ ja₁con₂ David ja₁ŋi'₅₄ Isaí, a₂lɨ́in₅ jan₂ dsa₂ i₂lë́₅ dsɨ́₅ lia'₂ lë́₅ dsɨ₃ jniá₂, jan₂ dsa₂ i₂jmo₃ a₂'ŋio₂ dsɨ₃.” ");
INSERT INTO cntNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","'Jaun₂ në́₃ rɨn'₅₄ jniog₄, jan₂ chi'₂ dsio₄ David 'éi₂ bá₄ lɨ́n₅ Jesús i₂ca₂chen₃ Diú₄ a₂lióin₂ dsa₂ juɨg₂ Israel lia'₂ con'₂ lë́₅ jág₁ quió'₅ ma₂cuë₃ le₂jŋiá₅. ");
INSERT INTO cntNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Né'₃ a₂guán₂ Jesús, ca₂'ë́₂ Juan₅₄ jág₁ ca₂tsɨ́'₃ ca₂le₃jɨ́n₃ dsa₂ Israel a₂'nió'₅ qui₃choin₃ jmɨg₂, dsɨ₃quén'₅ dsɨ́₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jaun₂ ca₂juá'₂ Juan₅₄ jme₁ja₂quián₃ jóin₂: “On₃jua'₅₄ 'éi₂ jniá₂ juɨ₁lia'₂ dsɨ₂jiog₅ 'au'₂ 'nia'₂ lɨ́n₅ jniá₂. La₁ i₂já₅ chi₁co'₅₄ quió₃ në́₃, 'éi₂ bá₄ i₂'uan'₂ guë́₄ lia'₂ con'₂ guë́₄ jniá₂, ca₂lia'₂ jŋia'₅₄ lau₂ ton₅ tag₅₄ bá₄ tsá₃ ca₂tɨ́ng₂ tsɨ'₅₄ quió'₅.” ");
INSERT INTO cntNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Rɨn'₅₄ jniog₄, ca₂le₃jɨ́n'₃ guë́₄ 'nia'₂ i₂lɨ́n₅ chi'₂ dsio₄ Abraham, quian'₅₄ ca₂le₃jɨ́n₃ guë́₄ 'ein₂ chan₂ quián'₂ 'nia'₂ i₂jme₂gan₃ Diú₄: a₂quián'₂ 'nia'₂ bá₄ jág₁ dse₃ la₂ a₂ca₂'ë́₂ Diú₄ a₂lión₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Dsa₂ i₂jme₁tián'₄ Jerusalén quian'₅₄ dsa₂ can'₅₄ quiáin₅, tsá₃ ca₂rë₃ŋi₅ 'ein₂ 'éi₂ jme₁chen₂ Jesús, on₃ guë́₄ ca₂rë₃ŋɨ́i'₂ jág₁ a₂qui₂ca₂'ë́₂ dsa₂ i₂chen₄ quián₅ Diú₄ le₂jŋiá₅. Jaun₂ lë₃, jág₁ jaun₂ a₂'ɨ₂₃ ne₄ Si₂ ca₂le₃jë́₃ jmɨg₄ sa₅₄ ca₂jme₃ti₃ guioin₅₄ jme₁ca₂jmo₃ 'éi'₃ a₂jŋɨi'₃ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","'I₁caun₂ dsáu₁ Jesús tsá₃ 'e₂ ca₂dsó'₂ dsa₂ jua'₅₄ a₂'i₄ 'éi'₃ a₂jŋag'₃, la₁ tion₅₄ bá₄ ca₂mɨ₃ dsa₂ jág₁ ne₄ Pilato a₂jmo₃ 'éi₂ 'éi'₃ a₂jŋag'₃. ");
INSERT INTO cntNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jaun₂ në́₃ jme₁ma₂lë₅ 'a₂ con'₂ lë́₅ juá'₂ ne₄ Si₂ quió'₅ Diú₄ a₂'ɨin₂₃ Jesús, jaun₂ ca₂sió₂ dsa₂ ne₄ cróg₄, jaun₂ ca₂i₁'ó₄. ");
INSERT INTO cntNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","La₁ Diú₄ në́₃, ca₂jme₃jein'₅₄ táng₃ jɨn₄ 'lag₄. ");
INSERT INTO cntNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","'Lióng₂ jmɨg₄ bá₄ qui₂ca₂jme₃jnia₅ Jesús ne₄ dsa₂ i₂jme₁quiain'₅₄ lia'₂ con'₂ jme₁ca₂ŋó₃ të₂ Galilea ca₂dsióg₃ të₂ Jerusalén. Jaun₂ në́₃ dsa₂ 'éi₂ bá₄ i₂jáng'₅ jág₁ dsau₅ tsɨ́'₅ dsa₂ rë₂në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Jaun₂ le₂në₅ bá₄ a₂cuë₂ jnia'₅₄ jág₁ dse₃ 'nia'₂, jág₁ a₂ca₂cuë₃ Diú₄ ca₂cuë́'₃ dsa₂ quián₂ jniog₄ ma₂lɨ́g'₂ jaun₂, ");
INSERT INTO cntNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ma₂ca₂rë₃ti'₅₄ Diú₄ ja₁con₂ jniog₄ i₂lág₅ chi'₂-guein₂ quián₅ dsa₂ 'éi₂, jme₁ca₂jme₃jein'₅₄ Jesús con'₂ lë́₅ jág₁ tio'₅₄ jë₁ca₂të́₂ tɨn₃ Salmo, a₂juá'₂: 'Ne₂ lɨ́ng'₅ jón₃ quiáng₃; jmɨg₄ në₃, ca₂lɨn₃ jniá₂ ŋéi'₅ 'ne₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","'Ca₂juá'₂ Diú₄ le₂jŋiá₅ a₂jme₃jein'₅₄ jɨn₄ 'lag₄ ia₁jaun₂ tsá₃ dsɨ₃'én₂ quió'₅. Juɨ₁lia'₂ juá'₂ ne₄ Si₂ quió'₅ Diú₄: Ján₃ bá₄ cuë́₄ jniá₂ 'nia'₂ ca₂le₃jë́₃ 'e₂ cosa dse₃ a₂jme₁ti₁ jág₁ quió₃ a₂ca₂cuë́₃ David. ");
INSERT INTO cntNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","'Jaun₂ lë₃, ján₃ guë'₂ juá'₂ ne₄ Si₂ Salmos ja₁siá'₂ táng₃: Tsá₃ cuë́'₁ jmɨg₄ a₂dsɨ₃guɨ́'₂ quió'₅ dsa₂ jŋió₅ 'éi₂ quiáng'₂ i₂jme₂ti₃ ta₁ ne'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","'David në́₃ ca₂jme₃ti₃ bá₄ jág₁ ne₄ dsa₂ quiáin₅ të₁lia'₂ ca₂rë₃cháin₃ jmɨg₄ jaun₂, juɨ₁lia'₂ 'éi'₃ ca₂juá'₂ Diú₄. La₁ ca₂jon₃ bá₄ David në́₃, jaun₂ ca₂i₁'ó₄ dsa₂ ja₁le₁'on₅ dsa₂ can'₅₄ quiáin₅, ca₂siá'₃ bá₄ nɨ₁ŋɨ₁ 'éi₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","La₁ nɨ₁ŋɨ₁ Jesús në́₃, i₂ca₂jme₃jen'₅₄ Diú₄, tsá₃ 'e₂ ca₂'en₃. ");
INSERT INTO cntNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","'Jaun₂ në́₃ rɨn'₅₄ jniog₄, tion₅₄ 'nió'₅ le₃ŋi'₅₄ 'nia'₂ jág₁ a₂'ë́₅ jniá₂: të₂le₃ quian'₅₄ Jesús bá₄ dsón'₂ 'én₂ dsáu'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Të₂le₃ quian'₅₄ 'éi₂, ca₂le₃jɨ́n₃ i₂'én₂ të₂le₃ quió'₅, rë₂'én₄ ca₂le₃jë́₃ dsáu₁ a₂tsá₃ o₂'én₂ dso₄ cha₂ quián'₂ 'nia'₂ të₂le₃ quian'₅₄ 'Éi'₃ quió'₅ Moisés. ");
INSERT INTO cntNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","'Í₁ jmo₄ 'nia'₂, ia₁jaun₂ tsá₃ dsɨ₃ŋɨ́'₂ 'nia'₂ juɨ₁lia'₂ juá'₂ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, jme₁ca₂juá'₂ ne₄ Si₂: ");
INSERT INTO cntNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Jag₄ 'nia'₂ dsa₂ i₂táun₂ 'lɨg'₅₄, juɨ₁dsi₂gó'₃ 'au'₂, juɨ₁dsian'₂ 'nia'₂. Ia₁ jniá₂ i₂lɨ́ng₅ Diú₄ jmo₅₄ léi₄ juë'₂ jmɨg₄ të₁lia'₂ chan'₂ 'nia'₂. La₁ léi₄ jaun₂, 'i₁jan'₂ 'nia'₂ tsá₃ le₃'én₂, o₁jŋia'₅₄ 'a₂ guë'₂ lia'₂ chan₂ i₂dsia₃. ");
INSERT INTO cntNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Jme₁ca₂o₃'ɨ́n₃ Pa₄ quiain'₅₄ rɨin'₅₄ guá'₅ sinagoga quió'₅ dsa₂ judíos, jaun₂ ca₂mɨ₃ dsa₂ a₂ja₃lén₂ táng₃ 'éi₂ jmɨg₄ sa₅₄ caun₂ a₂ja₃'ë́₂ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jme₁ca₂dsan₃ le₁ŋɨ'₂ dsa₂ dsi₂néi₂ guá'₅, jaun₂ juɨn₅ lɨn₃ dsa₂ judíos quian'₅₄ dsa₂ i₂ma₂gue₃ i₂ma₂tión₂ tiá₂ juá'₅ quió'₅ dsa₂ judíos, ca₂'ein₃ Pa₄ quiain'₅₄ Bernabé, ca₂jme₃quiong'₅₄. Jaun₂ ca₂juá'₂ dsa₂ i₂chen₄ quián₅ Jesús 'éi₂ ca₂tsɨ́'₃ dsa₂ ca₂cuë́'₃ bí₂ a₂tion₅₄ 'nió'₅ tsán'₂ tiá₂ jág₁ dse₃ quió'₅ Diú₄ i₂'ua₁ dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Caun₂ semana cang₂ jaun₂, jme₁ca₂të́₂ táng₃ jmɨg₄ sa₅₄, jaun₂ qui₂ca₂ŋɨ'₂ mei'₂ tsá₃ ca₂le₃jɨ́n₃ dsa₂ juɨg₂ a₂ca₂o₃néi₃ jág₁ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","La₁ jme₁ca₂jág₃ dsa₂ judíos juɨn₅ lɨn₃ dsa₂ tion'₅₄, jaun₂ ca₂rë₃'néi₃ a₂dsí'₅ 'ŋio₅ lɨn₃, të₂le₃ jen₅ bá₄ qui₂ca₂ŋag₃ jág₁ a₂juá'₂ Pa₄, qui₂ca₂jnáu'₂ jág₁ uɨg₅ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Jaun₂ ca₂juá'₂ Pa₄ quian'₅₄ Bernabé, ca₂dsia₃ tiá₂ dsɨ́₅ ca₂tsɨ́'₃ dsa₂: ―Tion₅₄ 'nió'₅ jŋiá₅ de'₂ jɨn'₄ 'nia'₂ con'₂ dsa₂ i₂lɨ́n₅ judíos, ca₂tág₂ jnia'₅₄ 'ë́₄ jág₁ dse₃ quió'₅ Diú₄. La₁ tsá₃ guë'₂ 'niog'₂ 'nia'₂ guéi'₁, jaun₂ ma₂léi₄ bá₄ a₂tsá₃ lé₂ tɨ́n'₄ 'nia'₂ guei'₅₄ i₂juɨ́g₃. Jaun₂ lë₃, dsɨ₁náu₄ jnia'₅₄ ja₁con₂ dsɨ₂nau₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ia₁ le₂në₅ bá₄ 'éi'₃ ca₂cuë₃ Te₁gui'₅₄ jme₁ca₂juá'₂: Juɨ₁lia'₂ si₂ bá₄ lɨ́n'₅ 'ne₂ i₂ca₂dsiáng₃ quió'₅ dsɨ₂nau₂, ia₁jaun₂ 'ë'₅₄ dsa₂ chan₂ ta₁caun₂ mɨ₂güɨ́g₃ juɨ₅ ja₁tɨ́n'₄ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jme₁ca₂nág₂ dsɨ₂nau₂ jág₁ në₅, qui₂ca₂jmo₃ 'io'₂, qui₂ca₂dsia₃, dsón'₂ bá₄ dse₃ jág₁ quió'₅ Te₁gui'₅₄. Jaun₂ ca₂rë₃'én₂ ca₂le₃jɨ́n₃ i₂con'₂ 'i₄ 'éi'₃ tɨ́n'₄ ja₁le₃chain₂ co₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jaun₂ le₂në₅ ca₂i₃'ág₃ jág₁ dse₃ quió'₅ Te₁gui'₅₄ ta₁caun₂ 'uë₃ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","La₁ dsa₂ judíos në́₃ ca₂jmo₃ jág₁ quian'₅₄ i₂lɨn₅₄ 'io₅₄ dsen₃ i₂jme₂go₃ dsa₂ juɨg₂, quian'₅₄ i₂lɨn₅₄ dsa₂ can'₅₄ në́₃, ia₁jaun₂ jme₃'iog₅₄ jme₃'ŋiai₅₄ Pa₄ quiain'₅₄ Bernabé. Jaun₂ le₂në₅ bá₄ ca₂jme₃lióg₃ ca₂jmo₃ jág₁ a₂qui₂ca₂co₃'ein₃ Pa₄ quiain'₅₄ Bernabé ca₂lia'₂ ca₂'uɨn₂ 'éi₂ juɨg₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Jaun₂ 'éi₂ në́₃ qui₂ca₂séi'₂ 'liog₂ mɨ₂tag₅₄. Ca₂'uɨin₂ bá₄ jaun₂, ca₂i₃léin₂ juɨ₅ Iconio. ");
INSERT INTO cntNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","La₁ ca₂le₃jɨ́n₃ dsa₂ i₂ca₂rë₃'én₂ në́₃, 'io'₂ jmo₂₃, rë₂rɨn₅ Jme₂dsí₂ Jŋió₅ të₂dsɨ́₅. ");
INSERT INTO cntNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ca₂'í₃ Pablo co₂lë₅ quian'₅₄ Bernabé dsi₂néi₂ guá'₅ sinagoga quió'₅ dsa₂ judíos juɨg₂ Iconio. Ja₁jaun₂ ca₂jme₃tɨin₂₃ táng₃ dsa₂ jág₁ dse₃ quió'₅ Diú₄. Juɨn₅ bá₄ dsa₂ ca₂rë₃'én₂, lia'₂ dsa₂ judíos lia'₂ dsɨ₂nau₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","La₁ dsa₂ judíos i₂tsá₃ 'én₂ në́₃, ca₂tsɨ́'₃ dsɨ₂nau₂ a₂chi₃'ɨin₃ 'lɨg'₅₄ dsa₂ i₂'én₂. ");
INSERT INTO cntNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Jaun₂ lë₃, uë́₂ bá₄ ca₂'í₃ Pa₄ quiain'₅₄ Bernabé. Ca₂dsia₃ tiá₂ dsɨ́₅ quian'₅₄ bí₂ quió'₅ Te₁gui'₅₄, qui₂ca₂'ë́₂ jág₁; jaun₂ Diú₄ në́₃ ca₂cuë₃ bí₂ ca₂jmo₃ 'éi₂ léi₄ juë'₂ a₂dsɨ₃gó'₃ dsɨ₅, ia₁jaun₂ le₃lí'₄ dsa₂, jág₁ dsau₅ a₂dse₃ dsɨ́₅ Diú₄ bá₄ 'ë́₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","La₁ dsa₂ juɨg₂ 'éi₂ jme₁lë́₄ le₁dson'₅₄ i₂jme₁tión₂ le₃quió'₅ dsa₂ judíos, i₂jme₁tión₂ le₃quió'₅ dsa₂ i₂chen₄ quián₅ Jesús 'éi₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jaun₂ ca₂jmo₃ caun₂ jág₁ dsa₂ judíos quiain'₅₄ dsɨ₂nau₂, quian'₅₄ dsɨ₂tan₅₄, a₂tsɨ́'₃ jág₁ uɨg₅ dsa₂ 'éi₂, a₂qui₃jnáu'₂ cang₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","La₁ jme₁ca₂rë₃ŋi₅ Pa₄ quian'₅₄ Bernabé, ca₂cuɨng₃ juɨ₅ Listra, juɨ₅ Derbe në́₃, tɨn₃ juɨg₂ ja₁tén₄ Licaonia, ca₂i₁nioi₁₂ le₂tan₅₄ 'uë₃ jaun₂, ");
INSERT INTO cntNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","qui₂jme₂tɨin₂₃ dsa₂ jág₁ dse₃ a₂lión₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Juɨg₂ Listra jme₁chan₂ jan₂ dsa₂ i₂tsá₃ lé₂ ŋɨ₃. Lia'₂ jaun₂ lɨ́in₅, lia'₂ con'₂ jme₁ca₂rë₃cháin₃, guá₅ ja₁jaun₂, 'i₁cón'₂ tsá₃ ma₂ca₂ŋɨ₃ ca₂le₃jë́₃ jmɨg₄ a₂chain₂. ");
INSERT INTO cntNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ca₂nág₂ dsa₂ 'éi₂ jág₁ a₂ca₂dsia₃ Pa₄. Jaun₂ Pa₄ në́₃ ca₂jág₃ tiá₂ ca₂jɨ́in₂ dsa₂ 'éi₂, jaun₂ ca₂rë₃lí'₄ Pa₄ a₂'én₂ dsa₂ 'éi₂ a₂lé₂ 'lióin₂. ");
INSERT INTO cntNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Jaun₂ ca₂juá'₂ tiá₂ ca₂tsɨ́'₃ dsa₂ 'éi₂: ―Rë₂ nau₂. Co₂dsau₅ chí'₂ mɨ₂tag'₅₄. Jaun₂ dsɨ₂juɨ₅ ca₂ráun₂ ca₂nau₂ dsa₂ 'éi₂, ca₂jme₃lióg₃ ca₂ŋɨ₃. ");
INSERT INTO cntNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Jme₁ca₂jág₃ dsa₂ a₂ca₂jmo₃ Pa₄ jaun₂, ca₂tóin'₂ co₂mɨ'₅₄, ca₂guió'₃ quian'₅₄ jág₁ jmei₅ quió'₅ dsa₂ chan₂ Licaonia, ca₂juá'₂: ―¡Diú₄ i₂lɨ́n₅ dsa₂ ca₂sión₃ jë₄ quián₂ jniog₄! ");
INSERT INTO cntNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Juá'₂ dsa₂ a₂lɨ́n₅ Bernabé diú₄ Júpiter, Pa₄ guë'₂ lɨ́n₅ diú₄ Mercurio ia₁ 'éi₂ bá₄ i₂juá'₂ guë́₄ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jaun₂ jme₁chí'₄ guá'₅ quió'₅ diú₄ Júpiter ja₁dsi₁lén₂ dsa₂ juɨg₂ jaun₂. Dsa₂ i₂lɨ́n₅ jme₂dsa₂ quián₅ Júpiter ca₂dsióg₃ quiain'₅₄ juɨn₅ dsa₂ le₁jŋiai₂₃ ca₁juɨ₅ le₁quian₅ lí₁ në́₃, a₂jme₁'nio₃ jme₃dsiain₂₃ ca₁juɨ₅ a₂jme₁jéin'₂ ne₄ Pa₄ quian'₅₄ Bernabé. ");
INSERT INTO cntNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","La₁ jme₁ca₂rë₃lí'₄ Pa₄ quian'₅₄ Bernabé i₂chen₄ quián₅ Jesús, a₂ma₂tion'₅₄ dsa₂ jmo₂₃ le₂jaun₂, jaun₂ ca₂jme₃lióg₃ ca₂gág₃ tsɨn'₅₄. Jaun₂ ca₂tóin'₂ jɨn₄ dsa₂ ca₂guió'₃ ca₂juá'₂: ");
INSERT INTO cntNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Nei₂ 'nia'₂! ¿'E₂ lë₃ jmo'₂ 'nia'₂ le₂në₅? Dsa₂ mɨ₂güɨ́g₃ bá₄ jnia'₅₄, juɨ₁lia'₂ 'nia'₂. A₂le₁quian₁ jág₁ dse₃ bá₄ jnia'₅₄ ja₂náu₅, a₂chei₅₄ 'nia'₂ a₂jŋiá'₄ 'nia'₂ ca₂le₃jë́₃ a₂në₅ a₂tsá₃ 'e₂ ta₁ tí₄, a₂jen'₅₄ 'nia'₂ të₂le₃ quió'₅ Diú₄ jén'₃ i₂ca₂jmo₃ guei'₅₄ i₂juɨ́g₃, gua'₅₄ 'uë₃, jmɨ₁ŋi'₄ në́₃, ca₂le₃jë́₃ guë́₄ 'e₂ a₂cha₂ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","'Ŋiog₅ Diú₄ ca₂cuë₃ jmɨg₄ ma₂lɨ́g'₂ ca₂cuë́'₃ ca₂le₃jɨ́n₃ dsa₂ chan₂ gua'₅₄ 'uë₃ a₂jmo₃ con'₂ lë́₂ dsɨ́₅ guioin₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","La₁ Diú₄ ca₂'ë́'₃ dsa₂ 'ein₂ lɨ́in₅, ca₂jmo₃ bá₄ léi₄ të₂le₃ quian'₅₄ ca₂le₃jë́₃ a₂dse₃ a₂qui₂ca₂jmo₃. 'Éi₂ bá₄ jmo₅ a₂tang₂ jmɨ́₅ ia₁jaun₂ qui₃ráu₃ ca₂le₃jë́₃ a₂qui₂guë́'₃ dsa₂. 'Éi₂ bá₄ jmo₅ a₂le₁'ág₄ dse₃ dsɨ́₅ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ja₂lag₃ le₂jaun₂ bá₄ ca₂tió'₃ ca₂jme₃'uáin₂ dsɨ́₅ dsa₂, a₂tsá₃ ma₃qui₃jéin'₂ já'₂ ne₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jaun₂ ca₂dsi₃lén₂ i₂lɨn₅₄ dsa₂ judíos i₂chan₂ Antioquía, quian'₅₄ i₂chan₂ Iconio, qui₂ca₂toin'₂ jág₁ dsa₂, ca₂jmo₃ jág₁. Jaun₂ ca₂cuë́'₃ cang₄ Pa₄, ca₂tsɨ₂cuang'₂ të₂'nɨ'₂ juɨg₂, a₂ma₂në₂jŋag'₃ bá₄ lɨ́in₂. ");
INSERT INTO cntNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","La₁ jme₁ca₂ŋɨ'₂ dsa₂ i₂'én₂ rɨin'₅₄ ja₁rë₂quiain₂₃, ca₂nau₂ Pa₄, ca₂ŋó₃ táng₃ juɨ₅ jë₄ juɨg₂. Jme₁jnia₃ jaun₂ guë́₄, ca₂o₃'ɨ́in₃ juɨg₂ jaun₂ quiain'₅₄ Bernabé, ca₂i₃léin₂ juɨ₅ Derbe. ");
INSERT INTO cntNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Juɨn₅ dsa₂ chan₂ juɨg₂ Derbe ca₂rë₃'éin₂ jme₁ca₂nág₂ ca₂'ë́₂ dsa₂ 'éi₂ jág₁ dse₃ a₂tɨ́n'₄ dsa₂. Jaun₂ ca₂'uɨin₂ ja₁jaun₂, ca₂i₃léin₂ táng₃ juɨ₅ Listra, juɨ₅ Iconio në́₃, a₂ca₂dsi₃léin₂ táng₃ Antioquía. ");
INSERT INTO cntNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Le₂tan₅₄ juɨg₂ ja₁jaun₂ qui₂ca₂cuë́'₃ bí₂ dsa₂ i₂'én₂. Qui₂ca₂toin'₂ jág₁ dsa₂ a₂'nió'₅ tsán'₂ dsa₂ tiá₂ jág₁ dse₃. Ca₂juá'₂: ―Tion₅₄ 'nió'₅ ŋag'₅₄ de'₂ 'nia'₂ jmɨ₁uɨg₅ mɨ₂güɨ́g₃ la₂, né'₃ guë́₄ a₂dsi₁no'₃ 'nia'₂ ja₁gon₂ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ján₃ bá₄ ca₂'ɨn₃ dsa₂ dsa₂ can'₅₄ lia'₂ caun₂ guá'₅. Jaun₂ cang₂ jme₁ca₂lë₃ chi₂lén'₂ dsa₂ Diú₄, a₂jme₂'ɨin₅₄ në́₃, ca₂dsiain₃ rɨin'₅₄ i₂'én₂ 'éi₂ o₄gú₃ Te₁gui'₅₄, ia₁ të₂le₃ quió'₅ Te₁gui'₅₄ bá₄ ma₂'én₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Cang₂ jaun₂ ca₂ŋɨ́i₃ juɨ₅ 'uë₃ Pisidia, jaun₂ ca₂dsi₃léin₂ 'uë₃ Panfilia. ");
INSERT INTO cntNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Qui₂ca₂'ë́₂ jág₁ juɨg₂ Perge, jaun₂ ca₂i₃léin₂ juɨg₂ Atalia. ");
INSERT INTO cntNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ja₁jaun₂ ca₂tóin'₂ nɨ₁barco a₂ca₂i₃lein₃ táng₃ Antioquía, juɨg₂ ja₁ca₂jáng'₂ dsa₂ rɨin'₅₄ o₄gú₃ Diú₄ le₂jŋiá₅, a₂jmo₃ ta₁, co₂'nió'₄ ta₁ a₂ma₂ca₂lë₃ jmo₂₃. ");
INSERT INTO cntNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Jme₁ca₂dsi₃lein₃ Antioquía, ca₂ŋɨ́i'₂ ca₂le₃jɨ́n₃ rɨin'₅₄. Jaun₂ ca₂dsia₃ ca₂le₃jë́₃ 'e₂ ca₂jmo₃ Diú₄ quiong'₅₄, 'a₂ lia'₂ ca₂niá₃ Diú₄ juɨ₅ quió'₅ dsɨ₂nau₂, ia₁jaun₂ le₃'én₂ 'éi₂ ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jaun₂ uë́₂ bá₄ ca₂'í₃ Pa₄ ja₁jaun₂, Bernabé në́₃ quiain'₅₄ dsa₂ i₂'én₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Jmɨg₄ jaun₂ i₂lɨn₅₄ dsa₂ chan₂ Judea ca₂dsi₃léin₂ juɨg₂ Antioquía, ca₂jme₃lióg₃ ca₂jme₃tɨin₂₃ rɨin'₅₄ ja₁jaun₂, në₁jua'₂ tsá₃ ti₅ dsa₂ nɨ₁lo₁ dsa₂ ŋe'₂ lia'₂ con'₂ lë́₅ Si₂ 'Éi'₃ quió'₅ Moisés, tsá₃ lé₂ tɨ́in'₄. ");
INSERT INTO cntNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo quian'₅₄ Bernabé ca₂tsɨ́in₂ 'ŋio₅ lɨn₃ quian'₅₄ dsa₂ 'éi₂. Jaun₂ ca₂'ɨn₃ dsa₂ Pa₄ quian'₅₄ Bernabé, quiain'₅₄ i₂lɨn₅₄ guë́₄ dsa₂ sián'₂ në́₃, a₂dsɨ₃léin₂ Jerusalén a₂jme₃rë́₃ jág₁ jaun₂ quiain'₅₄ dsa₂ rɨin'₅₄ i₂chen₄ quián₅ Jesús quian'₅₄ dsa₂ can'₅₄ quián₅ dsa₂ 'én₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Co₂nió'₃ dsa₂ i₂'én₂ juɨg₂ Antioquía ca₂'ág'₃ jág₁ rɨin'₅₄ i₂ca₂'ɨin₃ 'éi₂, jaun₂ 'éi₂ në́₃ ca₂i₁nioi₁₂ 'uë₃ Fenicia quian'₅₄ 'uë₃ Samaria. Ja₁jaun₂ ca₂dsia₃ 'a₂ lia'₂ ca₂rë₃'én₂ dsɨ₂nau₂. Jaun₂ lë₃, 'ŋio₅ lɨn₃ 'io'₂ ca₂jmo₃ dsa₂ rɨin'₅₄ jme₁ca₂rë₃ŋi₅. ");
INSERT INTO cntNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jme₁ca₂dsióg₃ Pa₄ quiain'₅₄ Bernabé juɨg₂ Jerusalén, ca₂guei₃ ca₂le₃jɨ́n₃ dsa₂ 'én₂ ja₁jaun₂, dsa₂ rɨin'₅₄ i₂chen₄ quián₅ Jesús, dsa₂ can'₅₄ quián₅ dsa₂ 'én₂ në́₃. Jaun₂ ca₂dsia₃ Pa₄ quian'₅₄ Bernabé ca₂tsɨ́'₃ rɨin'₅₄ 'a₂ lia'₂ ma₂jmo₃ Diú₄ quiong'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","La₁ qui₂ca₂nau₂ i₂lɨn₅₄ dsa₂ fariseos i₂ma₂'én₂, jaun₂ ca₂juá'₂: ―Ca₂tɨ́n₂ dsɨ₂nau₂ ti₃ dsa₂ nɨ₁lo₁₂, jaun₂ 'nió'₅ nag₃ a₂jme₃ti₃ Si₂ 'Éi'₃ quió'₅ Moisés. ");
INSERT INTO cntNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Jaun₂ ca₂ŋɨ'₂ dsa₂ i₂chen₄ quián₅ Jesús, quian'₅₄ dsa₂ can'₅₄ në́₃, ia₁jaun₂ 'no'₂ dsɨ́₅ 'a₂ lia'₂ jmo₃ juɨ₁lia'₂ jág₁ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Jme₁ma₂në₂dsia₃ jág₁ 'ŋio₅ lɨn₃, ca₂nau₂ Pedro jaun₂ ca₂juá'₂: ―Rɨn'₅₄ jniog₄, ŋi'₅₄ bá₄ 'nia'₂ jaun₂, jniá₂ dsa₂ i₂ca₂quión'₂ Diú₄ jɨn'₄ 'nia'₂ ma₂i₁jáun₃, ia₁jaun₂ cuë́₄ jniá₂ jág₁ dse₃ dsɨ₂nau₂, ia₁jaun₂ le₃'éin₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Jaun₂ Diú₄ në́₃, i₂cuɨ́'₅ dsɨ́₅ dsa₂, ca₂jmo₃ léi₄ a₂guei₃ bá₄, ca₂cuɨin₃ Jme₂dsí₂ Jŋió₅ quiáin₅, ca₂cuɨin₃ dsa₂ 'éi₂ juɨ₁lia'₂ ma₂cuag₃ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tsá₃ jma₃quén₅ 'nio₃ Diú₄ jniog₄ quian'₅₄ dsa₂ 'éi₂, ia₁ ján₃ bá₄ ca₂rang₃ jme₂dsí₂ quió'₅ dsa₂ 'éi₂ ia₁ ca₂rë₃'éin₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jaun₂ në́₃, ¿'e₂ lë₃ dsɨ₂jiog₅ 'au'₂ 'nia'₂ a₂tsá₃ dsau₅ a₂ma₂jmo₃ Diú₄? ¿'E₂ lë₃ lɨ́n'₂ 'nia'₂ a₂tion₅₄ 'nió'₅ jme₃ti₃ dsa₂ i₂'én₂ 'éi₂ Si₂ 'Éi'₃, ton'₂ ca₂lia'₂ jŋia'₅₄ dsa₂ can'₅₄ quián₂ jniog₄ tsá₃ ca₂tió'₃ jme₃ti₃, on₃ guë'₂ jniog₄ tián₂ jme₁ti₁? ");
INSERT INTO cntNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","La₁ ne₄ jniog₄, a₂dse₃ dsɨ́₅ Te₁gui'₅₄ Jesús bá₄ a₂tág'₄, co₂rë₂ quian'₅₄ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Jaun₂ ca₂jmo₃ dsa₂ tei₄, jaun₂ ca₂nág₂ të₁lia'₂ ca₂juá'₂ Bernabé quian'₅₄ Pablo ca₂le₃jë́₃ léi₄ juë'₂ a₂ma₂jmo₃ Diú₄ të₂le₃ quiong'₅₄, jɨn₄ dsɨ₂nau₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Jme₁ca₂dsan₃ juá'₂ 'éi₂, jaun₂ ca₂juá'₂ táng₃ Jacobo: ―Rɨn'₅₄ jniog₄, nei₂ 'nia'₂ a₂juá'₄ jniá₂: ");
INSERT INTO cntNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ma₂në₂dsia₃ Si₂mu₅₄ Pe₄ 'a₂ lia'₂ ca₂jmo₃ Diú₄ dse₃ dsɨ́₅ jë₁le₂'uɨg₅₄ të₂le₃ quió'₅ dsɨ₂nau₂, 'a₂ lia'₂ ca₂quióin'₂ ján₃ jɨn₄ dsa₂ 'éi₂, co₂nió'₃ dsa₂ i₂lén₂ dsa₂ quiáin₅ 'ŋiog₅. ");
INSERT INTO cntNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Le₂në₅ bá₄ lë́₅ jág₁ quió'₅ dsa₂ i₂jme₁'ë́₂ jág₁ quián₅ Diú₄, juɨ₁lia'₂ ca₂tióng₃ ne₄ Si₂: ");
INSERT INTO cntNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Guio₅₄ táng₃ cang₂, jaun₂ jmóg'₄ táng₃ ne₄ta₁ quió'₅ Rag₅₄ David a₂ma₂quɨ'₃; tsɨ'₅₄ táng₃ nɨ₁cang₁ a₂ma₂gon₃ quió'₅, ");
INSERT INTO cntNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ia₁jaun₂ ca₂le₃jɨ́n₃ dsɨ₂nau₂ 'nai'₂ Te₁gui'₅₄, ca₂le₃jë́₃ juɨg₂ në́₃, dsa₂ i₂chen₂ dsa₂ quián₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Le₂në₅ bá₄ juá'₂ Te₁gui'₅₄ i₂jmo₅ ca₂le₃jë́₃ a₂në₅, a₂ma₂cuɨ́'₅ dsa₂ ca₃ma₂lɨ́g'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Jaun₂ në́₃ lɨ́n₂ jniá₂ ―juá'₂ Jacobo―, tsá₃ dse₃ cue₅₄ jniog₄ o₂me'₅₄ dsɨ₅ dsɨ₂nau₂ i₂ma₂jén'₂ të₂le₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tió'₅ me'₂ a₂jŋia'₅₄ jmó₁ jniog₄ caun₂ si₂ a₂chei₅₄ jniog₄ a₂tsá₃ ma₃guë́'₃ má₃ a₂tsá₃ dsi₂ten₅₄ guë́'₃ juɨ₁lia'₂ a₂dsia₅ dsa₂ ne₄ ne₄chei₂ quió'₅ diú₄ lag₄. Dse₃ chei₅₄ jniog₄ a₂tsá₃ nió'₃ jág₁ quian'₅₄ dsa₂ i₂tsá₃ lɨ́n₅ dsɨ₂i₂gu₂, on₃ guë'₂ guë́'₃ má₃ a₂tsá₃ dsi₃ten₅₄ guë́'₃ dsa₂ judíos, juɨ₁lia'₂ já'₂ i₂güɨ́'₅ dsa₂ dsɨ₂lag₄, on₃ guë'₂ jmɨ₄ já'₂ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ia₁ ma₂lɨ́g'₂ bá₄ ma₂tu₁ja₂lén₂ dsa₂ qui₂'ë́₂ 'Éi'₃ Juá'₅ quió'₅ Moisés le₂caun₂ le₂caun₂ juɨg₂, qui₂'ɨ₂₃ dsi₂néi₂ guá'₅ sinagogas ca₂le₃jë́₃ jmɨg₄ sa₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jaun₂ në₃, ca₂të₁gua₁ jág₁ quió'₅ dsa₂ i₂chen₄ quián₅ Jesús, quian'₅₄ dsa₂ can'₅₄, ca₂le₃jɨ́n₃ guë́₄ dsa₂ i₂lɨ́n₅ guá'₅ a₂'ɨin₃ i₂lɨn₅₄ jë₄ quió'₅ rɨin'₅₄, i₂chein₃ quian'₅₄ Pablo, Bernabé në́₃, juɨ₅ Antioquía. Jaun₂ ca₂'ɨn₃ dsa₂ Judas i₂chen₂ Barsabás ján₃, quian'₅₄ i₂chen₂ Silas i₂lɨ́n₅ dsa₂ i₂quian₅ ne₄ juɨ₅ jë₄ quió'₅ dsa₂ i₂'én₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Jaun₂ quian'₅₄ 'éi₂ ca₂chein₃ si₂ carta a₂juá'₂ le₂la₂: Jnia'₅₄ con'₂ lág₅ dsa₂ chen₄ quián₅ Jesús, quian'₅₄ dsa₂ can'₅₄ quián₂ jnia'₅₄, ca₂le₃jɨ́n₃ guë́₄ rɨn'₅₄ jnia'₅₄ i₂'én₂, chen₄ jnia'₅₄ si₂ la₂ ne'₅₄ 'nia'₂ dsɨ₂nau₂ rɨn'₅₄ jniog₄ i₂tián'₅ juɨg₂ Antioquía, quian'₅₄ i₂tián'₅ 'uë₃ Siria, quian'₅₄ i₂tián'₅ 'uë₃ Cilicia në́₃. Cuɨ́n₅ jnia'₅₄ Diú₄ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ma₂ca₂rë₃ne₄ jnia'₅₄ jág₁ a₂i₁len₅₄ i₂lɨn₅₄ dsa₂ chan₂ ja₁lá₃, on₃jua'₅₄ i₂chen₄ quián₂ jnia'₅₄. Ma₂dsi₃léin₂ cuë́'₅ o₂me'₅₄ dsɨ₅ 'nia'₂ quian'₅₄ jág₁ quió'₅ a₂tsɨ́'₅ 'nia'₂ a₂tion₅₄ 'nió'₅ ti₃ dsa₂ nɨ₁lo₁ dsa₂ ŋe'₂, a₂jme₁ti'₄ 'nia'₂ 'Éi'₃ quió'₅ Moisés në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","'Uɨg₅₄ jaun₂, ca₂jmó₁ jnia'₅₄ caun₂ jág₁, ca₂'ɨ́n₄ jnia'₅₄ rɨn'₅₄ jë₄ quián₂ jnia'₅₄ a₂dsɨ₃léin₂ co₂lë₅ quiain'₅₄ Bernabé quian'₅₄ Pa₄ i₂'nio₄ lɨn₃ quián₂ jnia'₅₄, a₂dsɨ₃jɨin₅₄ 'nia'₂. Ia₁ le₂jaun₂ bá₄ dse₃, lág₂ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ma₂le₁'ág₄ caun₂ dsɨ́₅ gue₃ 'mú₃ o₁quió'₄ Te₁gui'₅₄ Jesucristo quián₂ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jaun₂ chen₄ jnia'₅₄ Judas quian'₅₄ Silas në́₃, jaun₂ i₂në₅ bá₄ juá'₂ quian'₅₄ jág₁ tio'₅₄ 'o₅₄ ca₂le₃jë́₃ a₂jua'₂ jnia'₅₄ la₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Jaun₂ në́₃, Jme₂dsí₂ Jŋió₅ bá₄ ca₂jme₃'o₅₄ a₂'niog'₅₄ jnia'₅₄ dsɨ₅, jaun₂ dse₃ bá₄ lág₂ jnia'₅₄ a₂tsá₃ cuë₅₄ jnia'₅₄ 'nia'₂ 'éi'₃ guei₂, jŋia'₅₄ lia'₂ jmá'₃ lia'₂ a₂léi₄ 'nió'₅ quián'₂ 'nia'₂ la₂: ");
INSERT INTO cntNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","A₂tsá₃ quë'₅₄ 'nia'₂ nɨ₁ŋɨ́₅ a₂ma₂dsia₃ dsa₂ ne₄ ne₄chei₂ quió'₅ diú₄ lag₄; ján₃ bá₄ tsá₃ quë'₅₄ 'nia'₂ jmɨ₄ já'₂, on₃ guë'₂ nɨ₁ŋɨ₁ já'₂ i₂dsan₂ i₂güɨ́'₅ dsa₂ dsɨ₂lag₄. Tsá₃ nió'₄ 'nia'₂ jág₁ quian'₅₄ dsa₂ i₂tsá₃ lɨ́n₅ dsɨ₂i₂gog'₂. Në₁jua'₂ ca₂jme₁ti'₄ 'nia'₂ jág₁ la₂, dse₃ bá₄ le₃chan'₂ 'nia'₂. Co₂në₅ bá₄ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Jaun₂ në́₃, le₂në₅ bá₄ ca₂tón'₂ 'éi₂ juɨ₅, ca₂i₃léin₂ juɨ₅ Antioquía. Jaun₂ ca₂ŋɨ́i'₂ dsa₂ i₂'én₂ ja₁jaun₂. Jaun₂ ca₂jɨ́in'₃ dsa₂ si₂ carta a₂jme₁quian₅. ");
INSERT INTO cntNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Jme₁ca₂'ɨ́₂ rɨin'₅₄ si₂, qui₂ca₂jmo₃ 'io'₂ o₁quió'₄ jág₁ a₂cuë₅ lián'₂ dsɨ́₅ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ia₁ Judas quian'₅₄ Silas, i₂jme₁'ë́₂ jág₁ a₂cuë₅ Diú₄ ján₃, ca₂cuë₃ 'lióng₂ jág₁ dse₃ a₂ca₂jmo₃ ca₂'ág₂ dse₃ dsɨ́₅ rɨin'₅₄, 'ŋio₅ lɨn₃ ca₂cuë₃ bí₂ në́₃, quian'₅₄ jág₁ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Jme₁ma₂të́₂ 'lióng₂ jmɨg₄ tioin'₅₄ ja₁jaun₂, ca₂dsióg'₂ táng₃ dsa₂ caun₂ tei₄ ja₁con₂ rɨin'₅₄ i₂ca₂chei₃. ");
INSERT INTO cntNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","La₁ ca₂jŋia₃ Pa₄ quian'₅₄ Bernabé juɨg₂ Antioquía, qui₂jme₂tɨin₂₃ dsa₂, quiain'₅₄ juɨn₅ guë́₄ i₂sián'₂, qui₂'ë́'₅ dsa₂ jág₁ dse₃ quió'₅ Te₁gui'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Cang₂ jaun₂, ca₂juá'₂ Pa₄ ca₂tsɨ́'₃ Bernabé: ―Dsau₅₄ táng₃ dsɨ₁jɨn₁ rɨn'₅₄ ca₂le₃jë́₃ juɨg₂ ja₁ma₂ca₂i₁'ë'₅₄ dsa₂ jág₁ dse₃ quió'₅ Te₁gui'₅₄, dsɨ₁jag₅₄ në₁jua'₂ 'a₂ lia'₂ chain₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé në́₃ jme₁'nio₃ jŋiai₃ Juan₅₄, i₂chen₂ Marcos ján₃. ");
INSERT INTO cntNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","La₁ Pa₄ guë'₂ në́₃ tsá₃ ca₂gue₃ jiog₃, ia₁ ca₂téi₂ bá₄ 'éi₂ lia'₂ con'₂ jme₁i₁nioi₁₂ 'uë₃ Panfilia, tsá₃ ma₃ca₂jme₃quiong'₅₄ jua'₅₄ a₂jme₃'o₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Jaun₂ ca₂tsɨ́in₂ 'ŋio₅ lɨn₃, ca₂lia'₂ ca₂i₃léin₂ jma₃quén₅. Jaun₂ Bernabé bá₄ ca₂jŋia₃ Marcos, ca₂tóin'₂ nɨ₁barco, ca₂i₃léin₂ juɨ₅ Chipre. ");
INSERT INTO cntNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pa₄ guë'₂ ca₂quióin'₂ Silas. Jme₁ma₂në₂jáng'₂ rɨin'₅₄ o₄gú₃ Te₁gui'₅₄ i₂'nio₃, jaun₂ qui₂ca₂'ág'₃ jág₁ rɨin'₅₄, ca₂i₃léin₂. ");
INSERT INTO cntNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Jaun₂ ca₂i₁ŋɨi₁₂ le₂tan₅₄ 'uë₃ Siria quian'₅₄ Cilicia, qui₂i₁cuë'₂ bí₂ rɨin'₅₄ i₂tián'₅ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ca₂dsióg₃ Pa₄ quian'₅₄ Silas juɨg₂ Derbe, juɨg₂ Listra në́₃. Ja₁jaun₂ ca₂jein'₂ jan₂ dsa₂ 'én₂ i₂chen₂ Timoteo. Chog₅₄ Timoteo 'éi₂ jme₁lɨ́n₄ 'io₅₄ judía i₂ma₂'én₂ jág₁ dse₃. Jmei₂ guë'₂ jme₁lɨ́n₄ jan₂ griego. ");
INSERT INTO cntNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jaun₂ dsa₂ i₂'én₂ i₂jme₁tián'₄ Listra quian'₅₄ Iconio, dse₃ bá₄ jme₁'ag₂₃. ");
INSERT INTO cntNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Jaun₂ 'nio₃ Pa₄ jiog₃ quiong'₅₄, jaun₂ ca₂ti₃ nɨ₁lo₁ 'éi₂, ia₁jaun₂ tsá₃ jén'₄ 'lɨg'₅₄ dsa₂ judíos i₂tián'₅ ja₁jaun₂. Ia₁ ma₂ŋi₅ bá₄ ca₂le₃jɨ́n₃ dsa₂, a₂lɨ́n₅ griego jmei₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ca₂le₃jë́₃ juɨg₂ ja₁ca₂ŋɨ́i₃, qui₂ca₂jme₃jein'₂ rɨin'₅₄ ca₂cuë₃ 'éi'₃ con'₂ lë́₅ jág₁ quió'₅ dsa₂ i₂chen₄ quián₅ Jesús, jág₁ quió'₅ dsa₂ can'₅₄ i₂tián'₅ Jerusalén në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jaun₂ në́₃, ca₂le₃jɨ́n₃ dsa₂ i₂lɨ́n₅ guá'₅, ca₂jŋa'₃ tiá₂ jág₁ dse₃ a₂'éin₂, jaun₂ le₂o₃ jmɨg₄ bá₄ ca₂i₃juɨ́in₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tsá₃ ca₂cuë₃ Jme₂dsí₂ Jŋió₅ jmɨg₄ a₂'ë́₂ dsa₂ jág₁ dse₃ 'uë₃ Asia. Jaun₂ lë₃ ca₂i₁lein₅₄ ca₂i₁ŋɨi₁₂ le₂tan₅₄ 'uë₃ Frigia quian'₅₄ 'uë₃ Galacia. ");
INSERT INTO cntNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Jaun₂ ca₂dsi₃léin₂ ja₁jén₂ 'uë₃ Misia. Ja₁jaun₂ jme₁'nio₃ jme₁dsɨ₃léin₂ 'uë₃ Bitinia. La₁ tsá₃ ca₂cuë₃ jmɨg₄ Jme₂dsí₂ quián₅ Jesús dsɨ₃léin₂ ja₁jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Jaun₂ con'₂ ca₂ŋɨ́i₃ bá₄ 'uë₃ Misia, ca₂dsi₃léin₂ 'o₄ jmɨ₁ŋí'₄ ja₁chei₂ Troas. ");
INSERT INTO cntNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ja₁jaun₂ ca₂quɨ₃ Pa₄ a₂'uë₂ jaun₂ a₂ca₂jɨ́in₂ jan₂ dsa₂ chan₂ 'uë₃ Macedonia, a₂chéin'₅ mɨ₂₃, a₂juá'₂: “Ŋɨ₅₄ juɨ₅ 'uë₃ Macedonia i₂jme₁'o₁ jnia'₅₄.” ");
INSERT INTO cntNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Dsɨ₂juɨ₅ jme₁ca₂quɨ₃ Pa₄ le₂në₅, jaun₂ ca₂jmó₁ jnia'₅₄ co₂jŋia₅₄ a₂dsɨ₁náu₄ juɨ₅ Macedonia. Ia₁ dsón'₂ lág₂ jnia'₅₄ a₂të́₂ Diú₄ ja₁jaun₂ a₂dsɨ₁'ë́₄ jnia'₅₄ jág₁ dse₃. ");
INSERT INTO cntNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ca₂tió'₄ jnia'₅₄ 'ŋió'₃ nɨ₁barco juɨg₂ Troas. Ca₂i₃náu₅ jnia'₅₄ co₂dsau₅ juɨ₅ 'uë₃ Samotracia a₂niog₅ jë₄ jmɨ₁ŋí'₄. Jme₁jnia₃ jaun₂, ca₂dsi₃náu₅ jnia'₅₄ Neápolis. ");
INSERT INTO cntNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tio'₅₄ jnia'₅₄ ja₁jaun₂, i₂náu₅ táng₃ ja₁chei₂ Filipos. Ja₁jaun₂ lë́₅ caun₂ colonia romana ja₁lë́₄ juɨg₂ dsen₅₄ guë́₄ quió'₅ dsa₂ chan₂ 'uë₃ Macedonia. Ja₁jaun₂ ca₂tió'₄ jnia'₅₄ tɨn₃-'nɨ₅ jmɨg₄. ");
INSERT INTO cntNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Caun₂ jmɨg₄ sa₅₄ ca₂i₁náu₄ juɨ₅ 'nɨ'₂ juɨg₂, cau₅ chei'₅₄ cuá₃, caun₂ ja₁jme₁lë́₄ ja₁dsɨ₂lén₂ dsa₂ a₂chi₂léin'₂ Diú₄. Ja₁jaun₂ ca₂'io₄ jnia'₅₄, ca₂jme₁tɨn₅ jnia'₅₄ 'io₅₄ i₂ca₂ŋɨ'₂, jág₁ dse₃ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Jan₂ 'io₅₄ i₂jme₁'en₅₄ jë₄ jaun₂ i₂chen₂ Lidia i₂chan₂ juɨg₂ Tiatira, jme₁lɨ́n₄ dsa₂ i₂'nag₅ 'mɨ'₂ 'uɨ'₃ jlá'₁. 'Io₅₄ 'éi₂, jme₁jme₂juɨn'₂ Diú₄. Jaun₂ ca₂jmo₃ Te₁gui'₅₄ ca₂lë₃ dsɨ́₅ 'io₅₄ 'éi₂ a₂nag₃ a₂tón'₂ juɨ₅ a₂juá'₂ Pa₄. ");
INSERT INTO cntNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jaun₂ ca₂jŋói₂ jmɨg₂ co₂dsia₅ quian'₅₄ ca₂le₃jɨ́n₃ dsa₂ dsi₂néi₂ quió'₅. Jme₁co₂lág₂ jaun₂, ca₂mɨ₃ tság₅ jnia'₅₄: ―Chi₂jua'₂ jmo'₂ 'nia'₂ 'au'₂ a₂lɨ́n₅ jniá₂ të₃dsón'₂ dsa₂ i₂'én₂ jág₁ quió'₅ Te₁gui'₅₄, i₂nó'₅ 'nia'₂ ja₁quió₃ i₁jŋia'₄. Jaun₂ ca₂juá'₂ tion₅₄ a₂ca₂jŋia₄ jnia'₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Co₂ráun₂ ca₂lë₃, lia'₂ con'₂ jme₁i₃náu₅ jnia'₅₄ ja₁chi₂lén'₂ dsa₂ Diú₄, ca₂jen'₂ jnia'₅₄ jan₂ 'io₅₄ chi'₂ i₂jme₁'en₅₄ jme₂dsí₂ 'lɨn'₅₄ të₂dsɨ́₅, i₂dsi₂ jág₁. 'Io₅₄ 'éi₂ a₂lë₁jmo₂₃ bá₄ ta₁, ia₁ juɨg₅₄ bá₄ jme₁cán₂ cu₄ a₂jme₁lɨ́'₂ a₂dsi₂ jág₁. ");
INSERT INTO cntNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","'Io₅₄ chi'₂ 'éi₂ ca₂'ein₃ Pa₄, ca₂'ein₃ jnia'₅₄ në́₃, ca₂guió'₃ ca₂tsɨ́'₃ dsa₂ i₂jme₁tion'₅₄: ―Dsa₂ në₅ i₂jme₂ti₃ ta₁ ne₄ Diú₄ juɨn'₂ guë́₄. Jaun₂ 'ë́₂ jág₁ tsɨ́'₅ 'nia'₂ 'a₂ lia'₂ lé₂ lión'₂ 'nia'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","'Lióng₂ jmɨg₄ ca₂jmo₃ le₂jaun₂. Ca₂lë₃ jme₁ca₂lë₃ ca₂i₃mé'₂ dsɨ́₅ Pa₄. Jaun₂ ca₂jí₂, ca₂juá'₂ ca₂tsɨ́'₃ jme₂dsí₂ 'lɨn'₅₄ i₂jme₁'en₅₄ quió'₅ 'io₅₄ 'éi₂: ―Quian'₅₄ bí₂ 'éi'₃ quió'₅ Jesucristo, jmo₅₄ jniá₂ 'éi'₃, jú₅ quió'₅ 'io₅₄ në₅. Jaun₂ co₂tan₅₄ dsɨ₂juɨ₅ jaun₂, ca₂o₃'ɨ́n₃ jme₂dsí₂ 'lɨn'₅₄ ca₂téin₂ 'io₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Jme₁ca₂rë₃lí'₄ dsa₂ juɨg₅₄ 'io₅₄ 'éi₂, a₂tsá₃ ma₃cuɨn₅ jmɨg₄ a₂lí'₂ guë́₄ cu₄ quiain'₅₄ 'éi₂, jaun₂ ca₂jŋai'₃ Pa₄ quian'₅₄ Silas, ca₂tág₃ juɨ₅ 'ma'₅₄ ne₄ dsɨ₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Jaun₂ ca₂i₁jo₅₄ ja₁tián'₄ juë́₄, jaun₂ ca₂juá'₂: ―Dsa₂ la₂, i₂lɨ́n₅ judíos, i₂nioi₅₄ tsɨ₂jɨin₂₃ dsa₂ juɨg₂ go₄ jniog₄. ");
INSERT INTO cntNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Qui₂'ë́'₅ jme₂tɨin₂₃ dsa₂ tag₄ a₂tsá₃ dsi₂ten₅₄ guéi₁ jniog₄, on₃ guë'₂ dsi₂ten₅₄ jua'₅₄ a₂jmó₁, ia₁ dsa₂ romanos bá₄ lág₅. ");
INSERT INTO cntNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jaun₂ ca₂nau₂ dsa₂ juɨg₂ 'nei₂ ca₂jmái'₂ Pa₄ quian'₅₄ Silas. Jaun₂ ca₂dsi₂ dsɨ₂tan₅₄ a₂dsi₂uɨg₅ nɨ₁tsɨn'₅₄, jaun₂ ca₂jmo₃ 'éi'₃ a₂bóg₂ në́₃ quian'₅₄ nɨ₁'ma₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Jme₁ma₂dsan₃ bóg₂ 'ŋio₅ lɨn₃, jaun₂ guë́₄ ca₂to'₂ né'₃ 'má₃. Ca₂jmo₃ 'éi'₃ a₂jmo₃ dsa₂ i₂niog₅ gu₂ 'né₅ 'má₃ 'í₁ dse₃ lɨn₃. ");
INSERT INTO cntNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Dsa₂ 'éi₂ në́₃, jme₁ca₂ŋɨi₂ 'éi'₃ jaun₂, ca₂i₁tio'₂ ca₂të₂ quióng₄ tsɨ₁'né₅ 'má₃, le₁tia₃ mɨ₂tag₅₄ 'ŋió'₃ tau₂ nɨ₁'ma₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","La₁ con'₂ dsi₃nei₅ jme₁ca₂'ë₃ Pa₄ alabanzas quiain'₅₄ Silas qui₂ca₂tsɨ́'₃ Diú₄, qui₂ca₂nág₂ bá₄ dsa₂ sián'₂ i₂tion'₅₄ 'né₅ 'má₃. ");
INSERT INTO cntNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Të₃jë₄ jaun₂, con'₂ tsá₃ ján₅ dsa₂, ca₂i₁bi₅₄ 'uë₃ tiá₂ lɨn₃, ca₂lia'₂ qui₂ca₂jë́'₂ 'uɨg₅₄ nɨ₁'ia'₂ tsɨ₁'né₅ 'má₃, qui₂ca₂niá₃ ca₂le₃jë́₃ o₄'né₄, qui₂ca₂gag₂ ŋí₁ cadenas a₂jme₁le₁'ŋe'₅₄ ca₂le₃jɨ́n₃ dsa₂ i₂jme₁tion'₅₄ 'ŋió'₃. ");
INSERT INTO cntNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Jme₁ca₂ŋé₃ dsa₂ i₂jmo₅ 'í₁, ca₂jág₃ ma₂le₁na₁ jë₂ o₄'né₄ 'né₅ 'má₃, jaun₂ ca₂dsi₂ ŋi₁tág₂ quió'₅ a₂jme₁jŋɨi'₃ 'ŋiog₅. Ia₁ lɨ́in₂ ma₂ca₂lón₂ jɨn₂ bá₄ i₂le₁jnɨ́₅ né'₃ 'má₃. ");
INSERT INTO cntNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","La₁ dsɨ₂juɨ₅ ca₂guió'₃ Pa₄ ca₂juá'₂: ―Tsá₃ lë₁jmag'₅₄ uɨg₅ 'ŋiag'₂, ia₁ la₂ bá₄ tio'₅₄ jnia'₅₄ ca₂le₃jág₃. ");
INSERT INTO cntNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Jaun₂ ca₂mɨ₃ dsa₂ 'éi₂ si₂, jaun₂ ca₂'í₃ co₂chi'₅₄ dsi₂néi₂ të₃ gó'₅ jlein₂₃ ŋó₃ ca₂chi₃jné₃ ne₄ Pa₄ quian'₅₄ Silas. ");
INSERT INTO cntNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Jaun₂ ca₂'uág'₂ të₂ca₁'né₄, jaun₂ ca₂ŋag₃: ―'Nia'₂ dsa₂, ¿'e₂ 'nió'₅ jmo₅₄ jniá₂ ia₁jaun₂ lión₂ jniá₂? ");
INSERT INTO cntNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Jaun₂ ca₂juá'₂ 'éi₂: ―'Én₃ të₂le₃ quió'₅ Te₁gui'₅₄ Jesucristo, jaun₂ bá₄ tɨ́ng'₄, quiang'₅₄ ca₂le₃jɨ́n₃ dsa₂ dsi₂néi₂ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Jaun₂ ca₂cuë₃ Pa₄ quian'₅₄ Silas jág₁ dse₃ quió'₅ Te₁gui'₅₄ ca₂cuë́'₃ dsa₂ 'éi₂ quian'₅₄ ca₂le₃jɨ́n₃ dsa₂ i₂tián'₅ dsi₂néi₂ quió'₅. ");
INSERT INTO cntNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Hora jaun₂ a₂'uë₂, dsa₂ i₂niog₅ gu₂ 'né₅ 'má₃ 'éi₂ qui₂ca₂rɨ́n'₃ ja₁qui₂le₁cuɨ́'₃ quió'₅ Pa₄ quiain'₅₄ Silas. Jaun₂ 'éi₂ quiain'₅₄ ca₂le₃jɨ́n₃ dsa₂ dsi₂néi₂ quió'₅, ca₂jŋói₂ jmɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Jme₁co₂lág₂ jaun₂, ca₂tág₃ ja₁quió'₄, ca₂i₁cuë₂ a₂guë́'₃. Jaun₂ 'io'₂ jmo₂₃ ca₂le₃jɨ́in₃, ia₁ ca₂rë₃'éin₂ jág₁ quió'₅ Diú₄. ");
INSERT INTO cntNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Jme₁jnia₃ jaun₂, ca₂chen₃ juë́₄ chi'₂ 'ɨ'₅₄ a₂ca₂i₁chi'₄ dsa₂ i₂niog₅ gu₂ 'né₅ 'má₃, a₂lióin₂ dsa₂ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Jaun₂ ca₂juá'₂ dsa₂ i₂niog₅ gu₂ 'né₅ 'má₃ ca₂tsɨ́'₃ Pa₄: ―Ma₂ŋɨg₂ 'éi'₃ quió'₅ juë́₄ a₂long₅₄ 'nia'₂. Jaun₂ ma₂lé₂ o₁no'₄ 'nia'₂ tei₄ quiáng'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Jaun₂ ca₂juá'₂ Pa₄ ca₂tsɨ́'₃ chi'₂ 'ɨ'₅₄: ―Ca₂chóng'₂ dsa₂ jnia'₅₄, qui₂ca₂bóg₂ të₃jɨn₄ dsa₂ juɨn₅ të₃ tsá₃ ca₂cáun₃ de'₂ jág₁ dsau₅ quián₂ jnia'₅₄ i₂lág₅ dsa₂ tén₅ juɨg₂ Roma. Jaun₂ guë́₄ ca₂to'₂ né'₃ 'má₃. ¿Në₃ në́₃ 'nio₃ lió₂ jnia'₅₄ con'₂ të₃co'₅₄? Tsá₃ le₂jaun₂. Juɨ₁ja₂léin₂ guioin₅₄ juɨ₁ja₂'uag'₅₄, juɨ₁lia'₂ ca₂to'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Jaun₂ guë́₄ ca₂i₁con₂ chi'₂ 'ɨ'₅₄ jág₁ jaun₂ ne₄ juë́₄, jaun₂ ca₂rë₃gó'₅ jme₁ca₂rë₃ŋi₅ a₂lɨ́n₅ Pa₄ quian'₅₄ Silas dsa₂ tén₅ Roma. ");
INSERT INTO cntNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Jaun₂ ca₂i₁len₅₄ dsɨ₂tan₅₄ ca₂i₁mɨ₂ o₂'én₂ dso₄ ne₄ Pa₄ quian'₅₄ Silas. Ca₂'uág'₂ bá₄ jaun₂ në́₃, jaun₂ ca₂juá'₂ a₂'uɨ́n₃ 'éi₂ juɨg₂ jaun₂. ");
INSERT INTO cntNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Jme₁ma₂'uɨn₂ 'éi₂ 'né₅ 'má₃, ca₂i₃lein₃ ja₁quió'₄ 'io₅₄ Lidia. Jme₁ca₂ŋɨi'₂ quiain'₅₄ rɨin'₅₄, qui₂ca₂cuë₃ bí₂ në́₃, jaun₂ guë́₄ ca₂'uɨin₂ ja₁jaun₂, ca₂i₁lein₅₄ guë́₄ juɨg₂ siá'₂. ");
INSERT INTO cntNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Juɨ₅ ja₁ca₂ŋe₄ Pa₄ quiain'₅₄ Silas jaun₂, ca₂i₁ŋɨi₁₂ juɨg₂ Anfípolis quian'₅₄ juɨg₂ Apolonia në́₃. Jaun₂ ca₂dsi₃léin₂ juɨg₂ chei₂ Tesalónica. Ja₁jaun₂ jme₁chí'₄ guá'₅ sinagoga quió'₅ dsa₂ judíos. ");
INSERT INTO cntNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pa₄ në́₃, ia₁ le₂jaun₂ tɨn₂ quió'₅, ca₂ŋei₅₄ guá'₅. Të₁lia'₂ ca₂'í₃ tɨn₃-'nɨ₅ semana ja₁jaun₂, qui₂ca₂dsia₃ jág₁ quian'₅₄ dsa₂ ca₂le₃jë́₃ jmɨg₄ sa₅₄, juɨ₁lia'₂ jág₁ a₂juá'₂ ne₄ Si₂. ");
INSERT INTO cntNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Qui₂ca₂cuë₃ jág₁ dsau₅ 'a₂ lia'₂ dsón'₂ 'i₄ 'éi'₃ ne₄ Si₂ quió'₅ Diú₄ a₂juá'₂ a₂tion₅₄ ŋág₃ uɨg₅ I₂rë₂'ɨ́n₁ quián₅ Diú₄, jaun₂ cang₂ jë₁ma₂join₂₃, a₂tion₅₄ niog₅ jein'₅₄ táng₃. Jaun₂ caun₂ ca₂juá'₂ bá₄: ―Jesús i₂'ɨ́n₅ jniá₂, jág₁ a₂'ë́₅ juɨ́g₂ 'nia'₂, I₂rë₂'ɨ́n₁ quián₅ Diú₄ bá₄ 'éi₂. ");
INSERT INTO cntNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jaun₂ ca₂rë₃'én₂ i₂lɨn₅₄ dsa₂ judíos, ca₂jme₃quiain'₅₄ Pa₄ quian'₅₄ Silas. Ján₃ bá₄ ca₂rë₃'én₂ juɨn₅ dsa₂ griegos i₂jme₁jme₂juɨn'₂ Diú₄, ca₂rë₃'én₂ juɨn₅ 'io₅₄ dsen₅₄ në́₃. ");
INSERT INTO cntNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","La₁ dsa₂ judíos i₂tsá₃ 'én₂ në́₃, ca₂rë₃'néi₃ a₂dsí'₅. Jaun₂ ca₂jme₃quiain'₅₄ co₂nió'₃ dsa₂ juɨ́'₅ i₂lë₁jme₁i₂nio₄ tsɨ₁jɨn₁ jë₄ calle. Ca₂quɨin'₃ jág₁ quió'₅, ca₂i₁nioi₁₂ ca₂tó'₂ mɨ'₅₄, tsɨ₂jɨin₂₃ dsa₂ juɨg₂. Jaun₂ ca₂i₁toin'₁ tion₅₄-jan₃ ja₁quió'₄ Jasón, a₂jme₁'nio₃ dsein₂₃ Pa₄ quiain'₅₄ Silas, a₂jme₁të₂ 'éi₂ jɨn₄ dsa₂ juɨg₂. ");
INSERT INTO cntNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ia₁ tsá₃ ca₂dsáin'₂ 'éi₂ ja₁jaun₂, Jasón bá₄ qui₂ca₂tsɨ₃cuɨin'₂ quiain'₅₄ guë́₄ rɨin'₅₄ i₂'én₂, jaun₂ ca₂tág₃ juɨ₅ ne₄ta₁, ca₂i₁jang'₂ ne₄ dsɨ₂tan₅₄, jaun₂ ca₂juá'₂ ca₂lia'₂ guió'₅ tioin'₅₄: ―I₂la₂ bá₄ dsa₂ i₂ŋɨ́₄ lë₃ ma₂jmo₃ tsá₃ ma₃caun₂ 'ei₅ jág₁, qui₂ma₂jéin'₂ dsa₂ ta₁caun₂ mɨ₂güɨ́g₃. Le₂jaun₂ bá₄ 'nio₃ jmo₃ ja₁lá₃ ján₃, ta₁ jaun₂ bá₄ ja₂léin₂. ");
INSERT INTO cntNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasón la₂ në₂cuë₃ jmɨg₄ në₂jŋia₃ dsa₂ 'éi₂ ja₁quió'₄. Ca₂le₃jɨ́n₃ 'éi₂ jmo₂₃ a₂tsá₃ dsi₂ten₅₄ jmo₃ lia'₂ con'₂ lë́₅ 'éi'₃ quió'₅ gui'₅₄ emperador. Ia₁ i₂nioi₅₄ tsɨ́'₅ dsa₂ a₂chan₂ guë́₄ jan₂ rag₅₄ sián'₂, jan₂ i₂chen₂ Jesús. ");
INSERT INTO cntNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Jme₁ca₂nág₂ dsa₂ le₂në₅, ca₂tóin'₂ go₂'i₃ quian'₅₄ dsɨ₂tan₅₄. ");
INSERT INTO cntNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","La₁ Jasón quian'₅₄ rɨin'₅₄ ca₂quí₃ cu₄ ne₄ dsɨ₂tan₅₄, jaun₂ guë́₄ ca₂lió₂ dsa₂. ");
INSERT INTO cntNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Dsɨ₂juɨ₅ le₂jaun₂ ca₂jmo₃ rɨin'₅₄ a₂ŋó₃ Pa₄ quiain'₅₄ Silas të₃ a₂'uë₂ juɨ₅ Berea. Jme₁ca₂dsi₃léin₂ ja₁jaun₂, i₁lein₅₄ dsɨ₂juɨ₅ dsi₂néi₂ guá'₅ sinagoga quió'₅ dsa₂ judíos. ");
INSERT INTO cntNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Dsa₂ judíos i₂jme₁tián'₄ ja₁jaun₂ jme₁dsein₃ con'₂ guë́₄ dsa₂ juɨg₂ Tesalónica. Lia'₂ 'i₄ rë₂ jág₁ bá₄ ca₂gue₃ jág₁ dse₃ quió'₅ Diú₄. Jaun₂ ca₂le₃jë́₃ jmɨg₄ bá₄ jme₁'no'₂ ne₄ Si₂ quió'₅ Diú₄, ia₁ 'nio₃ le₃ŋi₅ chi₂jua'₂ dsón'₂ bá₄ le₂jaun₂ lë́₅ jág₁ a₂cuë₅ Pa₄ quian'₅₄ Silas. ");
INSERT INTO cntNT_vpl VALUES ("