﻿USE sofia;
DROP TABLE IF EXISTS sofia.cnlNT_vpl;
CREATE TABLE cnlNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cnlNT_vpl WRITE;
INSERT INTO cnlNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","La²³la³ cu³lø³¹ xi̱i̱n³ te'²³ yi²³uu'² jaa²³² 'ñée² Jesucristo, 'i³ rɨ³løn³¹ dsa³ ju̱u̱n²³ David quia̱'² Abraham. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham xi̱i̱n³ jmii³ Isaac. 'E³ quie'²³ Isaac xi̱i̱n³ jmii³ Jacob. Jacob xi̱i̱n³ jmii³ Judá quia̱'² cɨ² te'²³ jó̱o̱² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá xi̱i̱n³ jmii³ Fares quia̱'² Zara. 'E³ quie'²³ Tamar xi̱i̱n³ xóo²te'²³. Fares xi̱i̱n³ jmii³ Esrom. 'E³ quie'²³ Esrom xi̱i̱n³ jmii³ Aram. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","'E³ quie'²³ Aram xi̱i̱n³ jmii³ Aminadab. 'E³ quie'²³ Aminadab xi̱i̱n³ jmii³ Naasón. 'E³ quie'²³ Naasón xi̱i̱n³ jmii³ Salmón. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","'E³ quie'²³ Salmón xi̱i̱n³ jmii³ Booz. 'E³ quie'²³ Rahab xi̱i̱n³ xóo² Booz. 'E³ quie'²³ Booz xi̱i̱n³ jmii³ Obed. 'E³ quie'²³ Rut xi̱i̱n³ xóo² Obed. 'E³ quie'²³ Obed xi̱i̱n³ jmii³ Isaí. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","'E³ quie'²³ Isaí xi̱i̱n³ jmii³ rey David. Rey David quia̱'² mɨ́³ 'i³ ca²³lǿn²³ mɨ²³quie'² Urías xe̱'n² rɨ³løn³¹ xóo² jmii³ Salomón. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","'E³ quie'²³ Salomón xi̱i̱n³ jmii³ Roboam. 'E³ quie'²³ Roboam xi̱i̱n³ jmii³ Abías. 'E³ quie'²³ Abías xi̱i̱n³ jmii³ Asa. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","'E³ quie'²³ Asa xi̱i̱n³ jmii³ Josafat. 'E³ quie'²³ Josafat xi̱i̱n³ jmii³ Joram. 'E³ quie'²³ Joram xi̱i̱n³ jmii³ Uzías. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","'E³ quie'²³ Uzías xi̱i̱n³ jmii³ Jotam. 'E³ quie'²³ Jotam xi̱i̱n³ jmii³ Acaz. 'E³ quie'²³ Acaz xi̱i̱n³ jmii³ Ezequías. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","'E³ quie'²³ Ezequías xi̱i̱n³ jmii³ Manasés. 'E³ quie'²³ Manasés xi̱i̱n³ jmii³ Amón. 'E³ quie'²³ Amón xi̱i̱n³ jmii³ Josías. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","'E³ quie'²³ Josías xi̱i̱n³ jmii³ Jeconías quia̱'² cɨ² te'²³ jó̱o̱² 'i³ xen³ ma² i²xe̱'n³ te'²³ dsa³ Israel dsa³ juɨɨ³ Babilonia 'e³ ca²³tøø³te'²³ juɨɨ³ quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ma²ca¹líi¹ la'³, ca²³la²³xen³ jo̱o̱³¹ Jeconías 'i³ xi̱i̱n³ Salatiel. 'E³ quie'²³ Salatiel xi̱i̱n³ jmii³ Zorobabel. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","'E³ quie'²³ Zorobabel xi̱i̱n³ jmii³ Abiud. 'E³ quie'²³ Abiud xi̱i̱n³ jmii³ Eliaquim. 'E³ quie'²³ Eliaquim xi̱i̱n³ jmii³ Azor. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","'E³ quie'²³ Azor xi̱i̱n³ jmii³ Sadoc. 'E³ quie'²³ Sadoc xi̱i̱n³ jmii³ Aquim. 'E³ quie'²³ Aquim xi̱i̱n³ jmii³ Eliud. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","'E³ quie'²³ Eliud xi̱i̱n³ jmii³ Eleazar. 'E³ quie'²³ Eleazar xi̱i̱n³ jmii³ Matán. 'E³ quie'²³ Matán xi̱i̱n³ jmii³ Jacob. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","'E³ quie'²³ Jacob xi̱i̱n³ jmii³ Søø³² 'i³ ca²³lǿn²³ dsóo²³ quien³² Ma³rii³¹, xóo² Jesús 'i³ sɨ'²³te'²³ Cristo. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham ca²³dxá³ ju̱u̱n²³ mɨ²xe̱'n³¹ cɨ². Je² ca²³tɨ́³ gui²³quiʉ̱́³ taa'² 'e³ ja³'láa²³ ju̱u̱n²³ Abraham 'e³ ca²³la²³xen³ David. 'E³ quie'²³ la'³ je² ca²³tɨ́³ gui²³quiʉ̱́³ taa'² 'e³ ja³'láa²³ ju̱u̱n²³ 'ñée² David 'e³ ca²³tɨ́³ 'e³ i²xe̱'n³te'²³ dsa³ Israel 'e³ ca²³tøø³te'²³ juɨɨ³ Babilonia. 'E³ quie'²³ la'³ ma²ca¹tɨ́³ co̱'³ gui²³quiʉ̱́³ taa'² 'e³ ja³'láa²³ ju̱u̱n²³ David, jo̱³ ca²³tɨ́³ 'e³ ca²³la²³xen³ Cristo. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","La²³la³ cu³lø³¹ 'e³ la²³ ca²³la²³xen³ Jesucristo: Rɨ³'ién² júu² quie'² Søø³² 'e³ rɨ²³tǿø²³ Ma³rii³¹ 'i³ rɨ²³lín³ xóo² Jesús. 'Íi² cɨ² 'e³ li²³quia̱'² uu'n² ca²³la²³quii²³ 'ñée² Ma³rii³¹ 'e³ huǿøn³ xi³yu̱u̱n³ quie'². Júu² 'uee'n³ quiee'³² Espíritu Gáan³ 'e³ ca²³la²³huǿøn³ xi³yu̱u̱n³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jmee²³ 'e³ ca³dsaan³² Søø³², 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³lín³ dsóo²³ quien³² Ma³rii³¹. 'E³ jo̱³ 'a²³jia'³ 'née²³ Søø³² 'e³ rɨ²³sóo²³ rɨ²³jó²³ júu² 'e³ jmii'³¹ cu³lø³¹ quie'² Ma³rii³¹. Qui² rɨ²³ji̱'²³ u²³'i'²³ 'u² cu²ru'³ rɨ²³jmée²³ la'³. 'E³ jo̱³ ca²³lǿn³ 'e³ rɨ²³yáan² júu² je² ñi³² 'nɨɨ'n³¹ miin²³, 'e³ 'a²³jia'³ ma²³ rɨ²³tǿø²³ Ma³rii³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","'E³ la²³ xin³ 'ín³ la'³, ca²³mi²³jnen³ 'ñée² jø̱n³ ángel quien³² Juii³ra² je² cɨ²³ Søø³². Ca²³jua'³ ángel 'í³: ―Rɨ²juøøn³¹na¹ 'nʉ³, Søø³², dsa³ ju̱u̱n²³ David: 'A²³jia'³ 'ne'² 'e³ rɨ²juø'n¹nu³ 'uǿøn²nu³. Rɨ²tøøn³¹ quién²nu³ Ma³rii³¹ 'e³ rɨ²³lín³ mɨ²³quién²nu³. Qui² júu² 'uee'n³ quiee'³² Espíritu Gáan³ 'e³ ca²³la²³huǿøn³ xi³yu̱u̱n³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","'E³ cɨ² li²³xen³ xi³yu̱u̱n³ dsóo²³ quien³². Jesús li²³xi̱i̱n³ rɨ²jméen². Qui² rɨ²³láan² dsa³ quien³² 'e³ jua'³ xa³ dsoo² quiee'³²te'²³. 'E³ jo̱³ hua² 'e³ li²³xi̱i̱n³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","La'³ cu³lø³¹ ca²³lǿ²³. Qui² 'ne'² rɨ²³lí³ 'e³ la²³ lǿ² ca²³jua'³ Juii³ra² Dios 'e³ rɨ²³lí³. 'E³ 'iin³¹ Dios ca²³lʉ́³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² ma²ca¹jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Li²³huǿøn³ xi³yu̱u̱n³ quie'² jø̱n³ xi²³mɨɨ²³². Li²³xen³ xi³yu̱u̱n³ 'i³ dsóo²³ quie'². Emanuel rɨ²³sɨ'²³te'²³ xi³yu̱u̱n³ 'í³. Qui² Emanuel jua'³te'²³ ju²³jmii²³² quiee'³²te'²³ 'e³ jua'³te'²³ 'e³ jen³¹ Dios quia̱'² jne². ");
INSERT INTO cnlNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ñín² Søø³² je² rɨ³guɨɨn³. 'E³ quie'²³ jo̱³ ca²³jmée³ 'e³ la²³ ca²³dxi³ 'i'²³ ángel quien³² Juii³ra² quie'². Tǿø² quie'²³ Ma³rii³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","'E³ quie'²³ ca²³'áan² 'ñée² Søø³² quia̱'² mɨ²³quie'² la²³huøø'n³¹ 'e³ 'íi² li²³xen³ xi³yu̱u̱n³, juø'n³ quie'²³ nee'n²³²te'¹ ca³ti³². Ca²³jmée³ 'e³ Jesús xi̱i̱n³ xi³yu̱u̱n³ ma²mɨ³'áa³ 'i'²³ 'e³ xen³. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Juɨɨ³ Belén estado Judea ca²³la²³xen³ Jesús. Herodes rɨ³løn³¹ rey mɨ²jo̱³. La²³ca̱a̱n³ mɨ²jo̱³ ca²³dxi²³guín²³ juɨɨ³ Jerusalén te'²³ dsa³ 'i³ cuiin²³ li²³'áan², te'²³ dsa³ 'i³ xen³ joo³¹ je² sɨ³'ién²³ ñi'². ");
INSERT INTO cnlNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ca²³jua'³ dsa³ 'í³: ―¿Neen³¹ rey quien³² dsa³ Israel 'i³ mɨ³la³xen³? Qui² mɨ³nen²³²na'³¹ li²³'áan² 'i³ ta̱a̱n²³ mɨ³¹güii³ joo³¹ je² sɨ³'ién²³ ñi'², 'i³ jmee²³ lii²³ 'e³ mɨ³la³xen³. 'E³ jo̱³ hua² mɨ³guaa²³ra'³¹ la³ 'e³ rɨ²mi³gáan²na'³¹. ―La'³ ca²³jua'³ te'²³ dsa³ 'i³ cuiin²³ li²³'áan². ");
INSERT INTO cnlNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bi²³ ca²³ŋɨ́³ dsɨ́² rey Herodes ma²ca¹núu³ júu² quiee'³²te'²³. 'E³ quie'²³ la'³ la²³jɨn³ dsa³ juɨɨ³ Jerusalén co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ca²³dxi³ 'i'²³ Herodes 'e³ ca²³ŋɨɨ'n²³ la²³jɨn³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley quien³² dsa³ Israel. Ca²³sɨ'²³ te'²³ dsa³ 'í³ 'e³ jiaa'³¹ rɨ³lø³¹ 'i'²³ 'e³ li²³xen³ Cristo 'i³ rɨ²³xíin²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","'E³ jo̱³ ca²³sɨ'²³te'²³ Herodes: ―Juɨɨ³ Belén estado Judea rɨ³lø³¹ 'i'²³ 'e³ li²³xen³. Qui² la'³ cu³lø³¹ to̱o̱²³ ji³ 'e³ ca²³jmée³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² je² jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Juɨɨ³ Belén estado Judea rɨ²³mi²³quí̱i̱n²³cɨ²te'¹ ca³juɨ² la²³ cɨ'²³ la²³jɨ³ juɨɨ³ estado Judea. Qui² núu²³ rɨ²³bǿn³ jø̱n³ dsa³ 'i³ rɨ²³dxi³ 'i'²³. Rɨ²³lín³ dxi² juɨɨ³ quien³² dsa³ Israel, 'i³ rɨ³løn³¹ dsa³ quién²³na²³. La'³ cu³lø³¹ to̱o̱²³ ji³ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","'E³ jo̱³ tǿ²³ Herodes. Ca²³jén²³ ca³jné³ dsa³ 'i³ cuiin²³ li²³'áan². Ca²³tín²³ júu² quie'²te'²³ 'e³ mɨ²lɨɨ'³¹ ca²³'ién²³ li²³'áan² 'i³ 'en³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","'E³ jo̱³ ca²³xíin²³ te'²³ dsa³ 'í³ juɨɨ³ Belén. Ca²³jua'³: ―Guo³ra'³. Dxʉ́²³ la²³ rɨ²'naa'n²³na'³ xi³yu̱u̱n³. Mɨ³rɨ³dxe'n²³na'³ xi³yu̱u̱n³, rɨ²ñe³xi'²ra'³ jné² co̱'³. Qui² 'náan²³ ñiin²³ jné² co̱'³ 'e³ rɨ²mi³gáan²na²³ xi³yu̱u̱n³ ―ca²³jua'³ Herodes. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ma²ca¹núu³te'²³ júu² quiee'³² rey Herodes, ca²³ta'n²³te'²³ jui³¹ co̱'³. Có̱²³ jui³¹ jén²³ li²³'áan² 'i³ ŋǿn²te'²³ 'uǿ²³ quiee'³²te'²³ je² sɨ³'ién²³ ñi'². 'E³ quie'²³ jo̱³ ca²³noo³ yʉʉ'³¹ la²³ je² rɨ³caa'n³² xi³yu̱u̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bi²³ ma²³'nee³ jɨn³ dsɨ́²te'²³ ma²ŋó¹te'²³ 'e³ ca²³noo³ li²³'áan². ");
INSERT INTO cnlNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ca²³ta'n²³te'²³ xi²ñʉ'¹. Ŋǿn²te'²³ xi³yu̱u̱n³ quia̱'² Ma³rii³¹ xóo² xi³yu̱u̱n³. Ca²³xii'³ jñi²te'¹ 'e³ ca²³mi²³gáan³te'²³ xi³yu̱u̱n³. Ca²³je'²³te'²³ láa² quiee'³²te'²³. Ca²³cuǿø²³te'²³ cu²nee³¹ quia̱'² xʉ̱³ quia̱'² jia'³ cɨ'²³ 'iin³² xʉ̱³ 'e³ xi̱i̱n³ mirra. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","'E³ quie'²³ ca²³lʉ́³ Dios quia̱'² te'²³ dsa³ 'í³ je² cɨ²³te'²³. Ca²³jua'³ 'e³ 'a²³jia'³ ma²³ 'ne'² rɨ²³sɨ²³joon³te'²³ co̱'³ Herodes. 'E³ jo̱³ jia'³ cɨ'²³ jui³¹ ca²³guiin³²te'²³ co̱'³ juɨɨ³ quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ma²ca¹guiin³² co̱'³ te'²³ dsa³ 'í³, ca²³mi²³jnen³ 'ñée² jø̱n³ ángel quien³² Juii³ra² je² cɨ²³ Søø³². Ca²³jua'³: ―Naa'n²³ 'nʉ³. Rɨ²cui̱i̱n³¹ jo̱o̱²³na²³. Cu³jøn²³nu³ xi³yu̱u̱n³ quia̱'² xóo² 'uǿ²³ Egipto. Je² núu²³ cu³ñí³ra'³ la²³huø'n²³ 'e³ rɨ²³tɨ́²³ 'e³ rɨ²juøøn³¹na¹ 'nʉ³ 'e³ 'ne'² rɨ²³güe'n²³nu³ co̱'³. Qui² mɨ³ rɨ²³'naa'n³ xi³yu̱u̱n³ Herodes 'e³ jua'³ 'née²³ rɨ²³jŋɨ'n²³. ―La'³ ca²³jua'³ ángel. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","'Uøø²³ quie'²³ la'³ ca²³naa'n²³ Søø³². Ca²³jén²³ xi³yu̱u̱n³ quia̱'² xóo². Ŋóo² 'uǿ²³ Egipto. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Je² núu²³ ca²³gua³ la²³huø'n²³ 'e³ ca²³tɨ́³ 'e³ jú̱n²³ Herodes. La'³ cu³lø³¹ ca²³lǿ²³ 'e³ la²³ rɨ²³lí³ juø'² rɨ²³lí³ 'e³ la²³ ca²³jua'³ Juii³ra² Dios 'e³ rɨ²³lí³. Qui² júu² quiee'³² Juii³ra² Dios ca²³lʉ́³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² ma²ca¹jua'³: “Ca²³tǿøn²na²³ ja̱a̱n²³ 'e³ ca²³bǿn³ 'uǿ²³ Egipto”. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bi²³ ma²³'nee³ ca²³ti̱'n³ Herodes ma²ca¹la¹quii²³ 'e³ 'a²³jia'³ ca²³mi²³quí̱i̱n²³ te'²³ dsa³ 'i³ cuiin²³ li²³'áan² júu² 'e³ ca²³lʉ́³. Ca²³xíin²³ dsa³ 'e³ cu²dxi³jŋɨ'n²³te'²³ la²³jɨn³ xi³yu̱u̱n³ 'i³ dsóo²³ 'i³ xen³ juɨɨ³ Belén quia̱'² la²³ca̱a̱n³ juɨɨ³ je² mɨ³lén². 'E³ jo̱³ i²jŋɨ'n¹te'²³ la²³jɨn³ xi³yu̱u̱n³ 'i³ mɨ³tɨ́³ tú̱²³ ji̱i̱'n²³ quia̱'² 'i³ pi'n² cɨ². Qui² ca²³jua'³ te'²³ dsa³ 'i³ cuiin²³ li²³'áan² 'e³ mɨ²lɨɨ'³¹ ca²³'ién²³ li²³'áan². ");
INSERT INTO cnlNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","La'³ cu³lø³¹ ca²³lǿ²³ 'e³ la²³ ca²³jua'³ Jeremías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², ma²ca¹jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Xen³ 'i³ 'oo'³² juɨɨ³ Ramá 'e³ jua'³ ŋɨ́³ dsɨ́². Raquel hua² 'í³. 'Oo'³² 'e³ jua'³ 'a²³'i̱³ ma²³ xen³ xi³yu̱u̱n³ quien³². 'A²³jia'³ jmɨ́ɨ² ma²³ rɨ²³liin²³ dsɨ́² 'e³ la²³'nɨɨ'n³¹ 'e³ ŋɨ́³ dsɨ́² juø'n³ quie'²³ xen³ dsa³ 'i³ jmee'n³² dsɨ́². Qui² 'a²³'i̱³ ma²³ xen³ te'²³ xi³yu̱u̱n³ quien³². La'³ ca²³jua'³ Jeremías mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jen³¹ quie'²³ 'uǿ²³ Egipto Søø³² ma²ju̱n²³ Herodes. Jo̱³ ca²³mi²³jnen³ 'ñée² co̱'³ cɨ'²³ jø̱n³ ángel quien³² Juii³ra² je² cɨ²³ Søø³². Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Naa'n²³ 'nʉ³. Guø'n³²nu³ co̱'³ 'uǿ²³ quiee'³² dsa³ Israel quia̱'n²nu³ xi³yu̱u̱n³ quia̱'² xóo². Qui² jú̱n²³ 'i³ ca²³la²³'née²³ rɨ²³jŋɨ'n²³ xi³yu̱u̱n³. ―La'³ ca²³jua'³ ángel. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","'E³ jo̱³ ca²³naa'n²³ Søø³². Ŋø'n² co̱'³ 'uǿ²³ quiee'³² dsa³ Israel quia̱'² xi³yu̱u̱n³ quia̱'² xóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","'E³ quie'²³ ca²³núu³ 'e³ rɨ³løn³¹ rey estado Judea Arquelao je² ca²³lǿn²³ rey Herodes jmii³ 'ñée² Arquelao mɨ²xe̱'n³¹. 'E³ jo̱³ 'a²³jia'³ ca²³la²³bii²³ dsɨ́² Søø³² 'e³ rɨ²³dsóo² co̱'³ estado Judea. 'E³ quie'²³ ca²³lʉ́³ Dios je² cɨ²³ Søø³². Ca²³jua'³ 'e³ bi²³ juø'². 'E³ jo̱³ ŋø'n² co̱'³ estado Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ca²³guó³ co̱o̱³ juɨɨ³ je² xi̱i̱n³ Nazaret. La'³ cu³lø³¹ ca²³lǿ²³ 'e³ la²³ rɨ²³lí³ juø'² rɨ²³lí³ 'e³ la²³ ca²³jua'³ te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² 'e³ rɨ²³lí³ ma²ca¹jua'³te'²³: “Dsa³ nazareno rɨ²³sɨ'²³te'²³”. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","La²³ca̱a̱n³ mɨ²jo̱³ ca²³dxóo² Juan 'i³ ca²³xáan² dsa³ jmɨɨ³. Ca²³dxóo² 'uǿ²³ je² røøn³ estado Judea je² 'a²³jia'³ nee'n²³² dsa³. Ca²³'ɨ́ɨ³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ca²³jua'³: ―Rɨ²tu³¹ra'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ dxʉ́²³. Qui² mɨ³lǿ²³ mɨ³lén² 'e³ rɨ²³lín³ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan hua² 'i³ ca²³'én² Isaías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², ma²ca¹jua'³: Xen³ 'i³ xi'n²³ je² 'a²³jia'³ nee'n²³² dsa³. Lʉ²³ quiʉ̱ʉ̱³ dsa³ 'í³ 'e³ la²³ jua'³: “Rɨ²jmée²ra'³ dxʉ́²³ jui³¹ je² rɨ²³ŋɨ́n³ Juii³ra². Rɨ²jmée²ra'³ jui³¹ 'e³ ca³dsaan³² je² rɨ²³ŋɨ́n³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jñʉ³ jó̱² camello rɨ³lø³¹ 'mɨɨ'³ 'e³ quii'³ Juan. Rɨ³'ñu'n² loo³. Cu'n³ quii². 'Ɨ̱ɨ̱'³² jmɨɨ'³¹ quiee'³² to'² 'i³ xen³ je² nuu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","I²guín¹ dsa³ Jerusalén 'e³ jua'³ rɨ²³núu²³te'²³ júu² quiee'³². 'E³ quie'²³ la'³ dsa³ 'i³ xen³ la²³ca̱a̱n³ je² røøn³ estado Judea quia̱'² dsa³ 'i³ xen³ la²³ca̱a̱n³ coo³¹ jmɨɨ³ juee'³ Jordán. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ca²³jme'n²te'²³ júu² 'e³ jmii'³¹ cu³lø³¹ dsoo² 'e³ xa³ quie'²te'²³. 'E³ jo̱³ ca²³xáan² jmɨɨ³ te'²³ dsa³ 'í³ Juan 'e̱'³ jmɨɨ³ juee'³ Jordán. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ŋó²³ Juan 'e³ ja³guín²³ juɨ́ɨn²³ dsa³ fariseo quia̱'² dsa³ saduceo 'e³ jua'³ 'née²³te'²³ 'e³ rɨ²³sáan²³te'²³ jmɨɨ³. 'E³ jo̱³ ca²³lʉ́³ ca²³sɨ'²³ te'²³ dsa³ 'í³: ―Bi²³ sǿn²³na'³. La²³ xen³ ju̱u̱n²³ 'luu³ xen³na'³. ¿Jmii'³¹ lǿ² 'e³ lǿn³na'³ 'e³ rɨ²³lí³ juø'² rɨ²³láan³na'³ mɨ³rɨ³jmee³ Dios jñiin²³ dsa³ 'i³ 'a²³jia'³ dxʉ́²³ jmoo³²? ");
INSERT INTO cnlNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","'Ne'² rɨ²jmée²ra'³ 'e³ dxʉ́²³ 'e³ la²³ li²³lii²³ 'e³ 'e̱'n³ quie'²³ dsɨ́² mɨ³tʉ́²ra'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","'A²³jia'³ ma²³ 'ne'² rɨ²juɨɨ'³¹ra'³ uu'n²na'³: “Abraham rɨ³løn³¹ yi²³uu'²ra² jaa²³², ¿mɨ³naa'³¹? 'E³ jo̱³ 'a²³'e³ xa³ rɨ²³jí̱i̱³ra².” Qui² 'a²³jia'³ rɨ²³líi² 'nɨɨ'n³¹ la'³. 'E³ jo̱³ rɨ²juøøn³¹na¹ 'nee'²³: 'A²³jia'³ jmɨ́ɨ² rɨ²³cuaa'n²³ gøn³ Dios. Cu³xi³ cú̱u̱² la³ rɨ²³lí³ juø'² rɨ²³jmén² dsa³ ju̱u̱n²³ Abraham Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mɨ³tɨ́³ 'e³ rɨ²³jmée²³ ta² ñí² laa'³. Qui² rɨ²³hui̱'³ la²³jɨ³ 'mo³ 'e³ 'a²³jia'³ 'ɨɨ³ mɨɨ³¹ 'e³ dxʉ́²³. Rɨ²³to'²³te'²³ dxi³¹ji³ 'e³ cu²coo³. ―La'³ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Jmɨɨ³ hua² caa'n³² jné² 'e³ la²³ xaan²³na²³ 'nee'²³ jmɨɨ³ 'e³ la²³ li²³lii²³ 'e³ mɨ³tʉ́²ra'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ dxʉ́²³. 'E³ quie'²³ 'uee'n³ cɨ² júu² quiee'³² 'ñée² 'i³ cɨ² rɨ²³güén³ cɨ̱ɨ̱n³ cɨ² la²³ jné². 'A²³jia'³ li²³bii²³ dsɨn²³ cu³xi³ 'e³ rɨ²jmø'n³¹ loo³ 'e³ taa'² tɨɨ² la²³'nɨɨ'n³¹ 'uee'n³ júu² quiee'³². Rɨ²³jmée²³ 'ñée² 'e³ rɨ²cø̱n²³na'³ Espíritu Gáan³. Rɨ²³jmée²³ 'e³ rɨ²³dxi²³quié̱n²na'³ la²³ dxi³quié̱n² dsa³ 'i³ sɨ³cáan²³ dxi³¹ji³. La'³ cu³lø³¹ 'e³ rɨ²³xáan² 'nee'²³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","'É̱e̱² 'e³ mɨ³so̱o̱'²³ cuaa'² quiee'³² 'e³ jua'³ rɨ²³juá² mɨ³¹cuɨɨ³ trigo 'e³ cu²ŋɨ́ɨ³ sɨ́². Mɨ³rɨ³cuaa'n²³ 'ñén²³ mɨɨ³¹, rɨ²³to'²³ saco, rɨ²³dxá²³ dxʉ́²³. 'E³ quie'²³ rɨ²³to'²³ sɨ́² dxi³¹ji³ je² 'a²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³ ji³. ―La'³ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mɨ²jo̱³ ca²³bǿn³ Jesús estado Galilea. Ŋóo² co̱³² jmɨɨ³ juee'³ Jordán je² jen³¹ Juan 'e³ jua'³ 'née²³ 'e³ rɨ²³xóo² jmɨɨ³ Juan quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","'E³ quie'²³ ca²³lǿn³ Juan 'e³ 'a²³jia'³ rɨ²³'íi²³ júu². Ca²³jua'³: ―¿Jmii'³¹ lǿ² 'e³ mɨ³güén²³nu³ 'e³ juø'n³ rɨ²xáan¹na²³ 'nʉ³ jmɨɨ³? Qui² dxi³ji̱i̱n³¹ 'e³ 'uǿøn²ma²nu³ rɨ²xáan¹nu³ jné² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","'E³ quie'²³ ca²³jua'³ 'ñée² Jesús. Ca²³sɨ'²³ Juan: ―'Ne'² rɨ²³lí³ la'³ rɨ³nɨ²³. Qui² dxi³ji̱i̱n³¹ 'e³ rɨ²jmee²ra² la²³jɨ³ 'e³ dxi³ 'i'²³ Dios. ―La'³ ca²³jua'³ Jesús. 'E³ jo̱³ ca²³'íi³ quie'²³ júu² Juan 'e³ ca²³xáan² quie'²³ jmɨɨ³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Xe̱'n² ma²ca¹jŋáan³ jmɨɨ³ Jesús, ca²³bǿn³ 'e̱'³ jmɨɨ³. Xe̱'n² quie'²³ jo̱³ ca²³nó³ yʉʉ'³¹ güii³. Ŋǿn² Espíritu Gáan³ quien³² Dios 'e³ la²³ sɨ³jiaan³². La²³ lǿn²³ to̱³ju̱³¹ lǿn²³. Jŋáan² ñi'² quiee'³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Xen³ 'i³ ca²³lʉ́³ yʉʉ'³¹ güii³. Ca²³jua'³: ―'I³ la³ ja̱a̱n²³ 'i³ bi²³ 'náan²³na²³. Bi²³ jmee²³ 'e³ jɨn³ dsɨn²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","'E³ jo̱³ ca²³jmée³ Espíritu Gáan³ 'e³ ŋóo² Jesús je² 'a²³jia'³ nee'n²³² dsa³ 'e³ la²³ rɨ²³jmée²³ lá³ mɨ²³sɨ²³quiʉ'² 'e³ jua'³ 'née²³ 'e³ rɨ²³jáan²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ca²³jmée³ mɨ²³jmɨɨ²³ Jesús tú̱²³ lóo² jmɨ́ɨ² tú̱²³ lóo² 'uøø²³. Ma²ca¹líi¹ la'³, bi²³ ca²³la²³cue̱'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ca²³dxóo² 'ñée² 'i³ jmee²³ lá³. Ca²³jua'³ ca²³sɨ'²³ Jesús: ―Xi³nu³ 'e̱'n³ quie'²³ dsɨ́² Jo̱o̱³¹ Dios 'nʉ³, rɨ²dxín² 'i'²³ 'e³ cu²lí³ 'ɨ²³juɨ² cú̱u̱² la³. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","'E³ quie'²³ ca²³jua'³ 'ñée² Jesús: ―To̱o̱²³ ji³ júu² quiee'³² Dios: “'A²³la³ 'nɨɨ'n³¹ 'e³ ee'³² dsa³ 'e³ jmee²³ 'e³ rɨ³ji̱'²³ dsa³. 'E³ quie'²³ la²³jɨ³ júu² 'e³ lʉ²³ Dios hua² jmee²³ 'e³ rɨ³ji̱'²³ dsa³ ca³quie̱e̱².” ");
INSERT INTO cnlNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","'E³ quie'²³ ca²³jáa²³ mɨ²³sɨ²³quiʉ'² quie'² Jesús. I²jøn²³ juɨɨ³ je² rɨ³jɨ́², juɨɨ³ Jerusalén. I²jøn²³ je² jɨ̱ɨ̱n²³² cɨ² bíi²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios te'²³ dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","'E³ jo̱³ ca²³sɨ'²³ Jesús: ―Xi³nu³ 'e̱'n³ quie'²³ dsɨ́² Jo̱o̱³¹ Dios 'nʉ³, rɨ²tø'n¹nu³ 'uǿøn²nu³ 'uǿ²³. Qui² to̱o̱²³ ji³ júu² quiee'³² Dios: Rɨ²³cuǿn² Dios ángeles quien³² 'e³ rɨ²³mi²³quin³te'²³ 'nʉ³. Guoo³te'²³ xe̱e̱'n³te'²³ 'nʉ³ tén³ la²³ 'e³ la²³ 'a²³jia'³ rɨ²³ti²³quie̱³¹ cú̱u̱² tɨɨn³¹. ―La'³ ca²³jua'³ mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","'E³ quie'²³ jo̱³ ca²³jua'³ 'ñée² Jesús: ―Co̱'³ cɨ'²³ xa³ je² to̱o̱²³ ji³ júu² quiee'³² Dios: “'A²³ rɨ³jmee³ra'³ lá³ 'e³ juo'³ra'³ 'noo³ra'³ 'e³ rɨ²³jáan²³na'³ Dios Juii³ra'³”. ―La'³ ca²³sɨ'²³ mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Co̱'³ cɨ'²³ i²jøn²³ Jesús yʉʉ'³¹ mo'³ jɨ̱ɨ̱n²³². Ca²³'ée²³ la²³jɨ³ juɨɨ³ 'e³ xa³ la²³bee'n³¹ mɨ³¹güii³. Ca²³'ée²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ca²³jua'³ ca²³sɨ'²³ Jesús: ―Rɨ²cuǿøn¹na²³ 'nʉ³ la²³jɨ³ xi³nu³ rɨ²sɨ'n² jñín² xi²ñin²³ 'e³ rɨ²mi³gáan²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","'E³ quie'²³ jo̱³ ca²³jua'³ 'ñée² Jesús. Ca²³sɨ'²³ mɨ²³sɨ²³quiʉ'²: ―Je̱'n² nɨ³, Satanás. Qui² to̱o̱²³ ji³ júu² quiee'³² Dios: “'Ne'² rɨ²mi³gáan²na'³ Dios Juii³ra'³. Jø̱n³ 'ñée² hua² 'i³ 'ne'² rɨ²jmée²ra'³ ta² quiee'³².” La'³ cu³lø³¹ to̱o̱²³ ji³. ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jo̱³ hua² ca²³tʉ́ʉ² mɨ²³sɨ²³quiʉ'². Jo̱³ tu³ ca²³dxi²³guín²³ ángeles 'i³ ca²³mi²³quin³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ca²³núu³ Jesús 'e³ mɨ³ta̱a̱'n³te'²³ i²³ñí² Juan 'i³ ca²³xáan² dsa³ jmɨɨ³. 'E³ jo̱³ ŋø'n² estado Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","'E³ quie'²³ 'a²³la³ ma²³ jo̱³ juɨɨ³ Nazaret ŋø'n². Qui² ca²³bǿn³ juɨɨ³ Nazaret. Ŋóo² i²gua³ juɨɨ³ Capernaum 'e³ nee'²³² co̱³² jmɨ²³ñii'³¹ Galilea. La²³ca̱a̱n³ je² núu²³ nee'n²³²te'¹ mɨ²jaa²³² te'²³ dsa³ Israel 'i³ rɨ³løn³¹ dsa³ ju̱u̱n²³ te'²³ dsa³ xoo'³¹ jmóo² 'i³ xi̱i̱n³ Zabulón quia̱'² Neftalí. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","La'³ ca²³jmée³ Jesús 'e³ la²³ rɨ²³lí³ 'e³ la²³ ca²³jua'³ Isaías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², 'e³ rɨ²³lí³. Qui² je² núu²³ ca²³'é³ Isaías ma²ca¹jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","'Uǿ²³ je² røøn³ Zabulón quia̱'² Neftalí, la²³ca̱a̱n³ coo³¹ jui³¹ 'e³ dsoo³²ra² jmɨ²³ñii'³¹ Galilea, la²³ca̱a̱n³ 'ŋóo² jmɨɨ³ juee'³ Jordán, 'uǿ²³ Galilea je² nee'n²³² dsa³ jia'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","La²³ca̱a̱n³ je² núu²³ nee'n²³² dsa³ je² li³'o̱o̱³ xe̱'n². 'E³ quie'²³ 'é̱e̱² 'e³ mɨ³ŋó²³te'²³ ji³ bee'² 'e³ li²³jné³ jui³¹ quiee'³²te'²³. Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jú̱n³te'²³ 'e³ xe̱'n². 'E³ quie'²³ 'é̱e̱² 'e³ mɨ³la³jné²³ quie'²te'²³ rɨ³nɨ²³. La'³ ca²³jua'³ Isaías mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mɨ²jo̱³ ca²³la²³láa²³ 'e³ ca²³'ɨ́ɨ³ júu² Jesús. Ca²³jua'³: ―Rɨ²tu³¹ra'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ dxʉ́²³. Qui² mɨ³lǿ²³ mɨ³lén² 'e³ rɨ²³lín³ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","'E³ la²³ ca²³ŋɨ́n³ Jesús co̱³² jmɨ²³ñii'³¹ Galilea, ŋǿn² áan²³ dsa³ 'i³ la²³ ca³já̱a̱n². Muun³² sɨ'²³te'²³ jø̱n³. 'E³ quie'²³ sɨ'²³te'²³ Peen²³² co̱'³. Drøø³¹ xi̱i̱n³ jó̱o̱². Ta'n² jua³²te'²³ 'mó² 'e̱'³ jmɨ²³ñii'³¹. Qui² rɨ³løn³¹te'¹ dsa³ 'i³ cø̱n³² 'moo'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ 'í³: ―Ñe³ra'³ quia̱'n²na'³ jné². Qui² rɨ²cuǿøn¹na²³ 'nee'²³ jia'³ cɨ'²³ 'iin³² ta². Ta² 'e³ rɨ²tøø³¹ra'³ dsa³ rɨ²cuǿøn¹na²³ 'nee'²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Xe̱'n² jmɨ́ɨ² ca²³cuaa'n³te'²³ 'mó² quiee'³²te'²³. Ca²³guín²³te'²³ quia̱'²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","'E³ quie'²³ ŋóo² cɨ² ca³juɨ² Jesús. 'E³ jo̱³ ŋǿn² cɨ² áan²³ dsa³ 'i³ la²³ ca³já̱a̱n² co̱'³. Jacobo quia̱'² Juan te'²³ jo̱²³ñʉʉ'³¹ Zebedeo. Ta'n²te'²³ 'e̱'³ móo² quia̱'²te'²³ jmii³te'²³. Ta'² 'mii³te'²³ 'mó² quiee'³²te'²³. 'E³ jo̱³ tǿ²³ Jesús. Ca²³tøø³ te'²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Xe̱'n² jmɨ́ɨ² ca²³cuaa'n³te'²³ 'nɨɨ'n³¹ 'ñée² cɨ² jmii³te'²³ quia̱'² móo² quiee'³²te'²³. Ca²³guín²³te'²³ quia̱'²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ca²³ŋɨ́³ Jesús la²³ca̱a̱n³ estado Galilea. 'Ee²³ dsa³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios te'²³ dsa³ Israel. 'Ɨɨ³ júu² 'e³ 'née²³ rɨ²³lín³ Dios juii² dsa³. Ca²³mi²³'láan³ dsa³ 'i³ dsoo'²³² te³ jmii'³¹ quie'²³ lǿ² dsóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ca²³núu³ dsa³ la²³ca̱a̱n³ 'uǿ²³ Siria 'e³ jmii'³¹ jmee²³ Jesús. 'E³ jo̱³ i²jøn²³te'²³ caan²³ Jesús la²³jɨn³ dsa³ 'i³ dsoo'²³², dsa³ 'i³ lǿn²³ dsóo² 'e³ ñúun³ 'iin³², dsa³ 'i³ cuu'²³ quie'², dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'², dsa³ 'i³ ta̱a̱n²³ 'i̱'², dsa³ 'i³ tu̱u̱n²³². Ca²³mi²³'láan³ la²³jɨn³. ");
INSERT INTO cnlNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ca²³qui̱'³te'²³ Jesús juɨ́ɨn²³ dsa³ 'i³ xen³ estado Galilea quia̱'² 'i³ xen³ je² xi̱i̱n³ Guiá²³ Juɨɨ³ quia̱'² 'i³ xen³ juɨɨ³ Jerusalén quia̱'² 'i³ xen³ estado Judea quia̱'² 'i³ xen³ 'ŋóo² jmɨɨ³ juee'³ Jordán. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ŋó²³ Jesús 'e³ bi²³ juɨ́ɨn²³ dsa³ 'i³ ca²³ŋɨɨ'n²³. 'E³ jo̱³ ca²³huɨ́ɨ³ yʉʉ'³¹ mo'³. 'E³ la²³ ca²³guó³ núu²³ Jesús, ca²³lǿn²³ mɨ³lén² te'²³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ca²³la²³láa²³ 'e³ ca²³'ée²³ dsa³ quien³². Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Bi²³ dxʉ́²³ quie'² dsa³ 'i³ sɨ³li³quii²³ 'e³ xa³ 'e³ 'ne'² quie'² dsɨ́². Qui² Dios 'i³ jen³¹ yʉʉ'³¹ güii³ rɨ³løn³¹ juii²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Bi²³ dxʉ́²³ quie'² dsa³ 'i³ 'oo'³² ñʉ'²³ dsɨ́². Qui² Dios rɨ²³jme'n² dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Bi²³ dxʉ́²³ quie'² dsa³ 'i³ mi³'uǿn²³ 'ñée². Qui² rɨ²³'ióo²³te'²³ mɨ³¹güii³ la³ 'e³ la²³ ca²³jua'³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Bi²³ dxʉ́²³ quie'² dsa³ 'i³ 'é̱e̱² 'e³ cue̱'²³, 'é̱e̱² 'e³ dxíin³ dsɨ́² jmɨɨ³ la²³'nɨɨ'n³¹ 'e³ 'née²³ rɨ²³jmóo² ca³dsaan³². Qui² rɨ²³jmée²³ Dios 'e³ rɨ²³lí³ juø'² rɨ²³jmóo² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Bi²³ dxʉ́²³ quie'² dsa³ 'i³ cuu'²³ dsɨ́² quia̱'² uu'n². Qui² li²³cuu'²³ dsɨ́² Dios quia̱'² miin²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Bi²³ dxʉ́²³ quie'² dsa³ 'i³ rɨ³jɨ́² dsɨ́². Qui² rɨ²³ñín²te'²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Bi²³ dxʉ́²³ quie'² dsa³ 'i³ dxaan³² qui³. Qui² 'e³ cɨ² rɨ²³sɨ'²³te'²³ jo̱o̱³¹ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Bi²³ dxʉ́²³ quie'² dsa³ 'i³ jme'²³te'²³ dsoo² 'e³ jmoo³²te'²³ ca³dsaan³². Qui² Dios 'i³ jen³¹ yʉʉ'³¹ güii³ rɨ³løn³¹ juii²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Bi²³ dxʉ́²³ quién²na'³ 'nee'²³ xi³nu³ maa'n³² lii'n³²te'²³ 'nee'²³, xi³nu³ cuøø²³te'²³ 'nee'²³ u²³ŋɨ́³ dsɨ́ɨ², xi³nu³ bi²³ ñúun³ la²³jɨ³ 'e³ 'ñe'² lʉ²³te'²³ 'en³²te'²³ 'nee'²³, 'e³ quie'²³ te³ juu³²te'²³. Bi²³ dxʉ́²³ quién²na'³ 'nee'²³ xi³nu³ sɨ³jí̱i̱n²na'³ la'³ dsoo² 'e³ rɨ³løn³¹na'³ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","'Ne'² rɨ²jmée²ra'³ 'e³ jɨn³ 'óo²ra'³. 'Ne'² li²³dxʉ́²³ 'óo²ra'³. Qui² bi²³ ñúun³ jñiin²³na'³ xa³ yʉʉ'³¹ güii³. 'E³ quie'²³ la'³ cu³lø³¹ ca²³jme'²³te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’La²³ xen³ juɨ² ñi² xen³na'³ 'nee'²³. 'Ne'² rɨ²jmée²ra'³ co̱²juø'¹ quie'² dsa³ mɨ³¹güii³. 'E³ quie'²³ xi³nu³ 'a²³jia'³ ma²³ ñii²³² juɨ² ñi², 'a²³jia'³ ma²³ jmɨ́ɨ² rɨ²³lí³ juø'² rɨ²³jmóo²te'²³ 'e³ li²³ñii²³² co̱'³, ¿mɨ³naa'³¹? Qui² 'a²³jia'³ ma²³ 'nee'³¹. Bi²³ cɨ² dxʉ́²³ 'e³ rɨ²³tó̱o̱²te'²³, 'e³ rɨ²³'ee²³ dsa³ ñi'². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’La²³ xen³ ji³ xen³na'³ 'nee'²³. 'Ne'² rɨ²guii'³¹ra'³ ji³ quie'² dsa³ mɨ³¹güii³. Qui² 'a²³jia'³ rɨ³'mo² la²³ cu²ru'³ co̱o̱³ juɨɨ³ 'e³ nee'²³² yʉʉ'³¹ mo'³. Bi²³ huɨ̱́ɨ̱³ jné³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","'E³ quie'²³ la'³ 'a²³jia'³ dxa²³ dsa³ ñʉ'²³ mɨɨ'³ dsuu² ji³ mɨ³rɨ³xe̱'n³²te'²³. 'E³ quie'²³ dxa²³te'²³ ñi'² joo³¹ 'mo³ jɨ̱ɨ̱n²³². 'E³ jo̱³ cuø²³ jmɨ́ɨ²³ 'e³ la²³ li²³jné³ quie'² la²³jɨn³ dsa³ 'i³ nee'n²³² xi²ñʉ'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","'Ne'² rɨ²³cuǿ²³ jmɨ́ɨ²³ ji³ quien³²na'³ 'e³ la²³ li²³jné³ quie'² jia'³ cɨ'²³ dsa³. Jo̱³ hua² rɨ²³ñí²te'²³ la²³jɨ³ 'e³ dxʉ́²³ 'e³ jmee³ra'³. Rɨ²³jua'³te'²³ 'e³ bi²³ gáan³ Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’'A²³ rɨ³lǿn³na'³ 'e³ mɨ³güén²³na²³ 'e³ juø'n²³ rɨ²mi³gua'n²³ ley, 'e³ juø'n²³ rɨ²mi³gua'n²³ júu² 'e³ ca²³té̱e̱² ji³ te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². Qui² 'a²³la³ jo̱³ la'³ 'e³ mɨ³güén²³na²³. Mɨ³güén²³na²³ 'e³ juø'n²³ rɨ²jmeen²³² lii²³ 'e³ jmii'³¹ jua'³ ca³quie̱e̱². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","'E³ jo̱³ rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: La²³huø'n²³ 'e³ 'iʉ² quie'²³ jui³¹ mɨ³¹güii³ quia̱'² 'uǿ²³, 'a²³jia'³ rɨ²³lí³ 'e³ te³ li²³ŋɨ́n³ 'e³ to̱o̱²³ ley cu³xi³ co̱o̱³ mɨɨ³¹ mɨ²'uø'¹ pii'². 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² rɨ²³lí³ la'³ la²³huø'n²³ 'e³ 'íi² rɨ²³lí³ la²³jɨ³ 'e³ to̱o̱²³ 'e³ rɨ²³lí³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","¿Jmii'³¹ xi³nu³ xen³ dsa³ 'i³ rɨ²³ta'²³ cɨ² co̱o̱³ jo̱o̱²³² júu² 'e³ to̱o̱²³ ley? ¿Jmii'³¹ xi³nu³ rɨ²³'ée²³ uu'n² 'e³ rɨ²³jmée²³ 'e³ lø³² la'³? Jo̱³ li²³xi̱i̱n³ 'ñée² 'i³ pii'² cɨ² jee²³² quiee'³² la²³jɨn³ dsa³ 'i³ rɨ³løn³¹ Dios juii². ¿Jmii'³¹ xi³nu³ xen³ dsa³ 'i³ jmee²³ quie'² 'e³ la²³ lǿ² to̱o̱²³ ley, 'i³ 'ee²³ uu'n² 'e³ cu²jmóo¹ la²³jɨ³ 'e³ to̱o̱²³? Jo̱³ li²³xi̱i̱n³ 'i³ gáan³ jee²³² quiee'³² la²³jɨn³ dsa³ 'i³ rɨ³løn³¹ Dios juii². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","'E³ jo̱³ rɨ²juøøn³¹na¹ 'nee'²³: 'A²³jia'³ jmɨ́ɨ² rɨ²³lí³ juø'² rɨ²taa'n³²na'³ je² røøn³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³ xi³nu³ 'a²³jia'³ jmee³ra'³ ca³dsaan³² 'e³ dsɨ³² cɨ² 'e³ la²³ jmoo³² dsa³ 'e²³ ley quia̱'² dsa³ fariseo. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Nuu³ra'³ 'e³ la²³la³ cu³lø³¹ ca²³sɨ'²³te'²³ dsa³ mɨ²jaa²³²: “'A²³ rɨ³jmee³ra'³ 'móo². Qui² rɨ³lø³¹ 'i'²³ 'e³ rɨ²³dxá²³te'²³ ta² quiee'³² dsa³ 'i³ jmee²³ 'móo².” ");
INSERT INTO cnlNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","'E³ quie'²³ jné² rɨ²juøøn³¹na¹ 'nee'²³: Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³dxá²³te'²³ ta² quiee'³² dsa³ 'i³ ti̱'n³ ñin³² uu'n². Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³ji̱'²³ jñiin²³ dsa³ 'i³ bi²³ 'ñe'² sɨ'²³ uu'n². Te'²³ dsa³ 'i³ dxa²³ ta² mɨ³¹güii³ la³ hua² rɨ²³jmóo² jñiin²³. 'E³ quie'²³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³dsóo² guiáa²³ juɨ́ɨ² je² rɨ³jøn³¹ ji³ dsa³ 'i³ maa'n³² lii'n³² uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Xi³nu³ xen³na'³ 'nee'²³ 'i³ mɨ³tɨn³na'³ có̱o̱²³ 'e³ juo'³ra'³ xa³ 'e³ lǿn³na'³ 'e³ rɨ²cuøø³¹ra'³ Dios 'u², 'e³ quie'²³ mɨ³la³liin³²na'³ co̱o̱³ júu² 'e³ 'a²³jia'³ dxʉ́²³ dsɨ́² uu'n²na'³ ñin³² 'nee'²³, ");
INSERT INTO cnlNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'e³ jo̱³ 'ne'² rɨ²cuaa'n²³²na'³ coo³¹ có̱o̱²³ 'e³ lǿn³na'³ 'e³ rɨ²cuøø³¹ra'³ Dios. 'Ne'² cu³jóon²³na'³ uu'n²na'³. Xe̱'n² cɨ² 'ne'² rɨ²lʉ́²ra'³ co̱o̱³ júu² quia̱'n²na'³ uu'n²na'³. Jo̱³ tu³ cu³guín²³na'³ co̱'³ có̱o̱²³, cu³cuøø²ra'³ Dios 'e³ lǿn³na'³ rɨ²cuøø³¹ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Xi³nu³ xen³ dsa³ 'i³ dsoo³² sɨ³cuǿ³ dsoo² quien³²na'³ xi²ñi² juez, 'ne'² rɨ²'no'²ra'³ 'e³ jmii'³¹ li²³dxʉ́²³ lʉ́²ra'³ quia̱'n²na'³ 'e³ la²³ ta'n²na'³ jui³¹ ca³ti³². Qui² bi²³ juø'² rɨ²³dxén² 'nee'²³ guoo³ juez. 'E³ quie'²³ juez rɨ²³dxén² 'nee'²³ guoo³ dsa³ 'láa³. Rɨ²³ta̱a̱'n³te'²³ 'nee'²³ i²³ñí². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³jia'³ jmɨ́ɨ² rɨ²³'uøøn³te'²³ 'nee'²³ i²³ñí² la²³huø'n²³ 'e³ 'íi² rɨ²³dxa²³cɨ́³ra'³ la²³jɨ³ sú̱n² 'e³ ya̱'n³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Nuu³ra'³ 'e³ la²³la³ cu³lø³¹ ca²³jua'³te'²³ mɨ²jaa²³²: “'A²³ rɨ³jmee³ra'³ ñi³ dxa³”. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","'E³ quie'²³ jné² rɨ²juøøn³¹na¹ 'nee'²³: Mɨ³jmée³ ñi³ dxa³ ñʉ'²³ dsɨ́² dsa³ 'i³ joon³² mɨ́³ 'e³ jua'³ 'née²³ rɨ²³jmée²³ ñi³ dxa³ quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Xi³nu³ jmee²³ mɨ²ñí²ra'³ jaan²³na'³ 'e³ dxʉ́²³ 'e³ la²³ rɨ²³'lǿn²³na'³, bi²³ cɨ² dxʉ́²³ quién²na'³ 'e³ rɨ²dxí²ra'³ mɨ²ñí²ra'³. Rɨ²tó̱o̱²ra'³. Qui² bi²³ juø'² rɨ²³juén²te'²³ 'nee'²³ guiáa²³ juɨ́ɨ² rɨ³ca̱'n²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Xi³nu³ jmee²³ guoo³²ra'³ jaan²³na'³ 'e³ dxʉ́²³ 'e³ la²³ rɨ²³'lǿn²³na'³, rɨ²tʉn²³²na'³ guoo³²ra'³. Bi²³ cɨ² dxʉ́²³ quién²na'³ 'e³ rɨ²tó̱o̱²ra'³ guoo³²ra'³. Qui² bi²³ juø'² cu³guín²³na'³ guiáa²³ juɨ́ɨ² rɨ³ca̱'n²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Co̱'³ cɨ'²³ ca²³jua'³te'²³ mɨ²jaa²³²: “Xi³nu³ xen³ dsóo²³ 'i³ tʉn³² mɨ²³quie'², 'ne'² rɨ²³jmée²³ co̱o̱³ ji³ 'e³ rɨ²³cuǿø²³ mɨ²³quie'² 'e³ jua'³ mɨ³tʉ́n²”. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","'E³ quie'²³ jné² rɨ²juøøn³¹na¹ 'nee'²³: Xi³nu³ xen³ dsóo²³ 'i³ tʉn³² mɨ²³quie'², 'e³ quie'²³ 'a²³la³ jo̱³ 'e³ mɨ³ta̱a̱'n³ 'ñée² mɨ²³quie'² quia̱'² jia'³ cɨ'²³ dsóo²³, dsɨn³² dsoo² dsa³ 'í³ 'e³ jmee²³ ñi³ dxa³ mɨ²³quie'² xi³nu³ rɨ²³tǿø²³ jia'³ cɨ'²³ dsóo²³ mɨ́³ 'i³ ca²³tʉ́n². 'E³ quie'²³ jmee²³ ñi³ dxa³ dsóo²³ 'i³ tøø²³ mɨ́³ 'i³ ca²³tʉ́n² dsóo²³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Co̱'³ cɨ'²³ nuu³ra'³ 'e³ la²³la³ cu³lø³¹ ca²³sɨ'²³te'²³ dsa³ mɨ²jaa²³²: “'A²³ rɨ³júu²ra'³ 'e³ la²³ 'ǿn²³na'³ la²³jɨn³ 'i³ quí̱i̱n²³ 'e³ juo'³ra'³ 'e³ jmii'³¹ rɨ²jmée²ra'³. 'E³ quie'²³ rɨ²jmée²ra'³ 'e³ la²³ juɨɨ'³²ra'³ Juii³ra² Dios 'e³ rɨ²jmée²ra'³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","'E³ quie'²³ jné² rɨ²juøøn³¹na¹ 'nee'²³: 'A²³'e³ xa³ 'e³ 'ne'² rɨ²'ó²ra'³ 'e³ la²³ juo'³ra'³ 'e³ jmii'³¹ rɨ²jmée²ra'³. 'A²³ rɨ³'o³ra'³ yʉʉ'³¹ güii³. Qui² núu²³ jen³¹ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","'A²³ rɨ³'o³ra'³ mɨ³¹güii³ la³ co̱'³. Qui² xen³ la²³ xen³ ñi'²³ jlɨ² je² rɨ³coo'²³ tɨɨ². 'A²³ rɨ³'o³ra'³ juɨɨ³ Jerusalén. Qui² rɨ³lø³¹ juɨɨ³ quiee'³² 'ñée² rey 'i³ gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","'A²³ rɨ³'o³ra'³ mɨ²dxí²ra'³. Qui² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ 'e³ taa³ cu³xi³ co̱o̱³ mɨɨ'n²³ jñʉ³ dxí²ra'³. 'E³ quie'²³ la'³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ 'e³ laa'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Líi² te³ rɨ²juo'²ra'³ “jɨ̱ɨ̱²”, rɨ²juo'²ra'³ “'a²³jia'³”. Qui² mɨ²³sɨ²³quiʉ'² hua² 'i³ 'née²³ 'e³ xa³ 'e³ rɨ²'ó²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Nuu³ra'³ 'e³ la²³la³ cu³lø³¹ ca²³jua'³te'²³ mɨ²jaa²³²: “Dsa³ 'i³ rɨ²³yáan² mɨ²ñi² uu'n², 'e³ quie'²³ la'³ 'ne'² rɨ²³jme'²³te'²³ 'ñée² co̱'³. Co̱'³ cɨ'²³ la'³ dsa³ 'i³ rɨ²³ta'²³ jo̱² uu'n², 'e³ quie'²³ la'³ 'ne'² rɨ²³jme'²³te'²³ 'ñée² co̱'³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","'E³ quie'²³ jné² rɨ²juøøn³¹na¹ 'nee'²³: 'A²³ rɨ³jníin²na'³ 'e³ la²³ jme'²³ 'nee'²³ dsa³ 'i³ jmee²³ 'e³ 'a²³jia'³ dxʉ́²³. Xi³nu³ jnoo³² dsa³ juu'³ra'³ jaan²³na'³ 'e³ dxʉ́²³, 'e³ quie'²³ jo̱³ cuøø²ra'³ jia'³ cɨ'²³ joo³¹ juu'³ra'³ 'e³ cu²jnóo¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Xi³nu³ xen³ dsa³ 'i³ sɨ³jǿn²³ 'nee'²³ xi²ñi² juez 'e³ jua'³ 'née²³ rɨ²³co̱o̱²³ 'mɨɨ'³ 'iún²na'³, 'ii²quie¹ra'³ júu² 'e³ rɨ²³co̱o̱²³ 'mɨɨ'³ dxóo³ quien³²na'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Xi³nu³ xen³ dsa³ 'i³ rɨ²³dxi³ 'i'²³ 'e³ cu³guín²³na'³ quia̱'n²na'³ co̱o̱³ hora, 'e³ quie'²³ 'ne'² cu³guín²³na'³ quia̱'n²na'³ tú̱²³ horas 'e³ la²³ dxʉ́²³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Cuøø²ra'³ dsa³ 'i³ xa³ 'e³ ŋɨ'²³ 'nee'²³. 'E³ quie'²³ cuøø²ra'³ dsa³ 'i³ ŋɨɨ²³ 'e³ jua'³ rɨ²³dxaan³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Nuu³ra'³ 'e³ la²³la³ cu³lø³¹ ca²³jua'³te'²³ mɨ²jaa²³²: “'Ne'² li²³'náan²³na'³ uu'n²na'³. 'E³ quie'²³ 'ne'² 'e³ rɨ²jmée²ra'³ 'e³ hui²³dsɨ́ɨn²na'³ mǿn²³na'³ dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² 'nee'²³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","'E³ quie'²³ jné² rɨ²juøøn³¹na¹ 'nee'²³: 'Ne'² li²³'náan²³na'³ dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² 'nee'²³. Rɨ²juɨɨ'³¹ra'³ Dios 'e³ rɨ²³mi²³jé̱e̱n² dsa³ 'i³ bi²³ 'ñe'² sɨ'²³ 'nee'²³. 'Ne'² rɨ²jmee'³¹ra'³ 'e³ dxʉ́²³ dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² 'nee'²³. 'Ne'² rɨ²lʉ́²ra'³ quia̱'n²na'³ Dios 'e³ rɨ²ŋɨ́ɨ²ra'³ 'e³ dxʉ́²³ quie'² dsa³ 'i³ cuøø²³ 'nee'²³ u²³ŋɨ́³ dsɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","La²³nɨ³ hua² rɨ²jmée²ra'³ 'e³ la²³ jmee²³ Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³. Qui² jmee²³ 'ñée² 'e³ sɨ³'ién²³ ñi'² quien³² 'e³ cuø²³ jmɨ́ɨ²³ 'e³ 'ne'² quie'² dsa³, juø'n³ quie'²³ dsa³ 'i³ jmoo³² 'e³ dxʉ́²³, juø'n³ quie'²³ dsa³ 'i³ 'a²³jia'³ jmoo³² 'e³ dxʉ́²³. Jmee²³ 'e³ sɨ³'ló²³ jmɨ́² 'e³ 'ne'² quie'² dsa³, juø'n³ quie'²³ dsa³ 'i³ jmoo³² 'e³ ca³dsaan³², juø'n³ quie'²³ dsa³ 'i³ 'a²³jia'³ jmoo³² 'e³ ca³dsaan³². ");
INSERT INTO cnlNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Xi³nu³ 'nɨɨ'n³¹ dsa³ 'i³ 'néen² 'nee'²³ 'i³ 'náan²³na'³, 'a²³'e³ xa³ 'e³ dxʉ́²³ quién²na'³, ¿mɨ³naa'³¹? Qui² cu³xi³ 'io'² 'néen² uu'n², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Xi³nu³ 'nɨɨ'n³¹ uu'n²na'³ 'i³ cuø³ra'³ u²³juee'n³¹ quia̱'n²na'³, 'a²³jia'³ jmee³ra'³ dsɨ³² cɨ² la²³ jmoo³² jia'³ cɨ'²³ dsa³. Qui² la'³ jmoo³² la²³jɨn³ dsa³, juø'n³ quie'²³ dsa³ jia'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","'E³ quie'²³ 'ne'² rɨ²jmée²ra'³ jmø'n² 'e³ dxʉ́²³ 'e³ la²³ jmee²³ jmø'n² 'e³ dxʉ́²³ Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Rɨ²jmée²ra'³ quién²na'³ 'e³ 'a²³la³ jo̱³ je² joo³² dsa³ je² rɨ³ca̱'n²³ gáan³ 'e³ rɨ²jmée²ra'³ la²³jɨ³ 'e³ 'uǿn²na'³ 'e³ jmee³ra'³. Qui² 'a²³jia'³ rɨ²³quí² jñiin²³na'³ Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³ xi³nu³ jmee³ra'³ je² joo³² dsa³ je² rɨ³ca̱'n²³ gáan³ la²³jɨ³ 'e³ 'uǿn²na'³ 'e³ jmee³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","'E³ jo̱³ 'a²³jia'³ rɨ²cu'n²³² rɨ²ñii'n²³na'³ dsa³ 'e³ cu²jóo¹ 'e³ jmii'³¹ cu³lø³¹ 'e³ cuøø³²ra'³ dsa³ taan³. Qui² la'³ cu³lø³¹ jmoo³² dsa³ 'i³ te³ jmoo³² guóo². Bi²³ bee'² jmoo³² ñʉ'²³ 'ñʉ́² je² mi³gáan³te'²³ Dios. 'E³ quie'²³ la'³ jmoo³² jee²³² calles co̱'³. Qui² 'née²³te'²³ 'e³ bi²³ dxʉ́²³ rɨ²³lʉ́²³ dsa³ 'e³ rɨ²³'én²te'²³. Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Mɨ³líi² mɨ³'ioo³² jñiin²³ dsa³ 'í³. 'A²³'e³ ma²³ xa³ 'e³ cɨ² 'íi² 'e³ rɨ²³'ióo²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","'E³ quie'²³ 'a²³la³ je² joo³² dsa³ rɨ²cuøø³¹ra'³ dsa³ taan³. 'É̱e̱² 'e³ 'a²³jia'³ joo³² guoo³²ra'³ jaan²³na'³ 'i²³jia'³ 'e³ jmii'³¹ jmee²³ guoo³²ra'³ jaan²³na'³ 'e³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Je² rɨ³'mo² rɨ²cuøø³¹ra'³ dsa³ taan³. Jo̱³ hua² rɨ²³cuǿ²³ jñiin²³na'³ Ñʉ'²ra'³ 'i³ joo³² la²³jɨ³ 'e³ sɨ³lí³ je² rɨ³'mo². ");
INSERT INTO cnlNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’'E³ la²³ lʉ́²ra'³ quia̱'n²na'³ Dios, 'a²³ rɨ³jmee³ra'³ 'e³ la²³ jmoo³² dsa³ 'i³ te³ jmoo³² guóo². Qui² bi²³ la²³noo³te'²³ 'e³ lʉ²³te'²³ quia̱'²te'²³ Dios ñʉ'²³ 'ñʉ́² je² mi³gáan³ dsa³ Dios. 'E³ quie'²³ la'³ jmoo³² je² sɨ³cu'n²³ jui³¹ co̱'³. Qui² 'née²³te'²³ 'e³ rɨ²³jóo² dsa³. Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Mɨ³líi² mɨ³'ioo³² jñiin²³ dsa³ 'í³. 'A²³'e³ ma²³ xa³ cɨ² 'e³ 'íi² rɨ²³'ióo²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","'E³ quie'²³ 'nee'²³, 'e³ la²³ lʉ́²ra'³ quia̱'n²na'³ Dios, rɨ²taa'n³²na'³ co̱²³ju'²³. Rɨ²jnɨ́²ra'³ 'oo'². Rɨ²lʉ́²ra'³ quia̱'n²na'³ Ñʉ'²ra'³ 'i³ 'iún² quia̱'² 'nee'²³ je² rɨ³'mo². Jo̱³ hua² rɨ²³quí² jñiin²³na'³ Ñʉ'²ra'³ 'i³ joo³² la²³jɨ³ 'e³ sɨ³lí³ je² rɨ³'mo². ");
INSERT INTO cnlNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’'E³ la²³ lʉ́²ra'³ quia̱'n²na'³ Dios, 'a²³ rɨ³lʉ́²ra'³ ñúun³ júu² 'e³ cu³xi³ 'a²³jia'³ ma²³ jmee³ra'³ 'i'²³, 'e³ te³ mɨ³la³ta̱a̱n³²na'³ 'e³ lʉ́²ra'³. Qui² la'³ jmoo³² dsa³ jia'³. Qui² lǿn³te'²³ 'e³ te³ bi²³ ñúun³ lʉ²³te'²³ 'e³ rɨ²³núu²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","'A²³ rɨ³jmee³ra'³ 'e³ la²³ jmoo³² te'²³ dsa³ 'í³. Qui² 'íi² cɨ² rɨ²juɨɨ'³¹ra'³ Ñʉ'²ra'³, ñi³² 'ñée² 'e³ jmii'³¹ 'ne'² quién²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","La²³la³ cu³lø³¹ rɨ²lʉ́²ra'³ quia̱'n²na'³ Dios jo̱o̱²³na²³: Dios Ñʉ'²ra'³¹ 'i³ jen³¹ yʉʉ'³¹ güii³. Cu²li³quii²³ dsa³ 'e³ jmii'³¹ 'nɨɨ'n³¹ rɨ³jɨ́n²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Cu²lín³nu³ juii² la²³jɨn³ dsa³. Cu²lí³ mɨ³¹güii³ la³ 'e³ la²³ 'naan³ 'uǿøn²nu³ 'e³ rɨ²³lí³ 'e³ la²³ sɨ³lí³ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cuøø² jnee'³¹ 'ɨ́² 'e³ 'ne'² rɨ²quie²ra'³¹ cɨ'³ la²³ co̱o̱³ jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Rɨ²jméen² u²³juee'³ dsɨɨ³² rɨ²mǿn¹nu³ jnee'³¹. Qui² jnee'³¹ jmee³ra'³¹ u²³juee'³ dsɨɨ³² nen²³²na'³¹ dsa³ 'i³ jme'²³ jnee'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","'A²³ rɨ³jmeen³ 'e³ rɨ²ŋɨ²ra'³¹ je² juø'² rɨ²³jáan²³ dsɨ³ra'³¹ mɨ²³sɨ²³quiʉ'². 'A²³ rɨ³cuøn³ júu² 'e³ rɨ²jmee²ra'³¹ 'e³ 'a²³jia'³ dxʉ́²³. Qui² rɨ³løn³¹nu³ juii² dsa³ quien³²nu³. 'Uǿøn²nu³ 'i³ bi²³ 'uee'n³. 'Uǿøn²nu³ 'i³ bi²³ gáan³ ca³cuaa³. Amén. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Xi³nu³ jmee³ra'³ u²³juee'³ dsɨɨ³² mǿn²³na'³ dsa³ 'i³ jme'²³ 'nee'²³, rɨ²³jmée²³ u²³juee'³ dsɨɨ³² Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³ rɨ²³ñín² 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","'E³ quie'²³ xi³nu³ 'a²³jia'³ jmee³ra'³ u²³juee'³ dsɨɨ³² mǿn²³na'³ dsa³ 'i³ jme'²³ 'nee'²³, 'e³ quie'²³ la'³ 'a²³jia'³ rɨ²³jmée²³ u²³juee'³ dsɨɨ³² Ñʉ'²ra'³ rɨ²³ñín² 'nee'²³ 'e³ la²³ jmee³ra'³ 'e³ xa³ dsoo² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’'E³ la²³ jmee³ra'³ mɨ²³jmɨɨ²³, 'a²³ rɨ³jmee³ra'³ lii²³ ñí²ra'³ 'e³ cu²lǿn³ dsa³ 'e³ bi²³ la³dsɨɨ³² dsa³ nɨ³. Qui² la'³ jmoo³² dsa³ 'i³ te³ jmoo³² guóo². Jmoo³² 'e³ 'ñe'² cu³lø³¹ ñi²te'¹ 'e³ la²³ rɨ²³dsóo²³ dsɨ́² dsa³ 'e³ jmoo³² mɨ²³jmɨɨ²³. Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Mɨ³líi² mɨ³'ioo³² jñiin²³te'²³. 'A²³'e³ ma²³ xa³ 'e³ cɨ² 'íi² 'e³ rɨ²³'ióo²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","'E³ quie'²³ 'e³ la²³ jmee³ra'³ mɨ²³jmɨɨ²³, rɨ²too'³¹ra'³ noo²³² mɨ²dxí²ra'³, rɨ²u̱u̱'³¹ra'³ ñí²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","La'³ rɨ²jmée²ra'³ 'e³ la²³ 'a²³jia'³ rɨ²³dsóo²³ dsɨ́² dsa³. Qui² dsoo²³ dsɨ́² Ñʉ'²ra'³ 'i³ 'iún² quia̱'² 'nee'²³ je² rɨ³'mo². 'E³ jo̱³ rɨ²³cuǿ²³ jñiin²³na'³ Ñʉ'²ra'³ 'i³ joo³² la²³jɨ³ 'e³ sɨ³lí³ je² rɨ³'mo². ");
INSERT INTO cnlNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’'A²³ rɨ³mi³quie̱e̱'²³²ra'³ quién²na'³ la²³jɨ³ 'e³ quí̱i̱n²³ mɨ³¹güii³ la³. Qui² cuu'³ jo'³. Sɨ³quie̱e̱²³ juii'²³. Sɨ³ta'n²³ dsa³ 'i³ jmoo³² 'i̱i̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","'E³ quie'²³ rɨ²mi³quie̱e̱'²³²ra'³ quién²na'³ la²³jɨ³ 'e³ quí̱i̱n²³ yʉʉ'³¹ güii³. Qui² núu²³ 'a²³jia'³ rɨ²³cuu'³ jo'³. 'A²³jia'³ sɨ³quie̱e̱²³ juii'²³. 'A²³jia'³ sɨ³ta'n²³ dsa³ 'i³ jmoo³² 'i̱i̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Qui² nee² 'óo²ra'³ je² xa³ la²³jɨ³ 'e³ quí̱i̱n²³ 'e³ 'oo³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Mɨ²ñí²ra² jmee²³ ta² 'e³ jné³ ji³. Xi³nu³ dxʉ́²³ quie'²³ mɨ²ñí²ra'³, bi²³ jné³ quién²na'³. La'³ xen³na'³ xi³nu³ 'a²³jia'³ 'iin²³ 'óo²ra'³ la²³jɨ³ 'e³ xa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","'E³ quie'²³ xi³nu³ 'a²³jia'³ ma²³ dxʉ́²³ mɨ²ñí²ra'³, bi²³ sɨ³lí³ li³'o̱o̱³ quién²na'³. Xi³nu³ li³'o̱o̱³ je² ya̱'n³ rɨ²³cuǿ²³ jmɨ́ɨ²³ quién²na'³, bi²³ ma²³'nee³ li³'o̱o̱³. La'³ xen³na'³ xi³nu³ 'iin²³ 'óo²ra'³ la²³jɨ³ 'e³ xa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’'A²³jia'³ rɨ²³lí³ juø'² rɨ²³jmée²³ dsa³ ta² quia̱'² áan²³ juii². Qui² rɨ²³lí³ 'e³ hui²³dsɨ́ɨn² ñin³² jø̱n³. 'E³ quie'²³ li²³'néen² jia'³ cɨ'²³. Rɨ²³jmée²³ 'e³ la²³ jua'³ jø̱n³. 'A²³jia'³ rɨ²³mi²³quí̱i̱n²³ 'e³ la²³ jua'³ jia'³ cɨ'²³. 'A²³jia'³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ ta² 'e³ dxi³ 'i'²³ Dios ca³ti³² quia̱'² ta² 'e³ dxi³ 'i'²³ cuu². ");
INSERT INTO cnlNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’'E³ jo̱³ rɨ²juøøn³¹na¹ 'nee'²³: 'A²³ rɨ³mi³ñúun²na'³ 'óo²ra'³ 'e³ jmii'³¹ li²³xa³ la²³jɨ³ 'e³ 'ne'² quién²na'³ 'e³ rɨ²'u'² rɨ²cø'²ra'³ quia̱'² 'e³ rɨ²cɨ'²ra'³. 'Ne'² rɨ²mi³jue'n²na'³ 'e³ rɨ³ji̱'n²quien²³na'³. Bi²³ cɨ² 'ne'² la'³ la²³ cɨ'²³ la²³jɨ³ 'e³ rɨ²cø'²ra'³. 'Ne'² rɨ²mi³jue'n²na'³ 'e³ xa³ jmɨ² ŋú²ra'³. Bi²³ cɨ² 'ne'² la'³ la²³ cɨ'²³ la²³jɨ³ 'e³ rɨ²cɨ'²ra'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jmee²ra'³ 'i'²³ 'e³ jmii'³¹ sɨ³ji̱'²³ jo̱o̱³¹ to̱³. 'A²³jia'³ jmoo³²te'²³ jmo². 'A²³ cɨ'²³ 'e³ jmoo³²te'²³ 'ó̱o̱²³. 'A²³ cɨ'²³ ca²quie̱e̱²³te'²³ láa² 'ui²dsoo²³². 'E³ quie'²³ cuø²³ Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³ 'e³ ee'³²te'²³. Cu³xi³ jo̱o̱³¹ to̱³ mi'³ ee'n³², ¿mɨ³naa'³¹? 'E³ quie'²³ bi²³ cɨ² ma²³'nee³ quí̱i̱n²³ 'nee'²³ la²³ cɨ'²³ jo̱o̱³¹ to̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","'A²³'i̱³ xen³ 'nee'²³ 'i³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ 'e³ cuaan²³cɨ²na'³ co̱o̱³ joo³¹ metro, juø'n³ jmi'³ 'nɨɨ'n³¹ 'e³ mi³ñúun²na'³ 'óo²ra'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿'Ee² lǿ² mi³ñúun²na'³ 'óo²ra'³ 'e³ jmii'³¹ li²³xa³ 'e³ rɨ²cɨ'²ra'³? Jmee²ra'³ 'i'²³ 'e³ jmii'³¹ lǿ² 'e³ sɨ³cua̱a̱n²³ mɨ²lí² 'e³ xa³ je² nuu³. 'A²³jia'³ jmoo³² ta². 'A²³ cɨ'²³ 'e³ ben³² mɨ³¹ñi³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","'E³ jo̱³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ bi²³ cɨ² lii'² cu³lø³¹ mɨ²lí² la²³ cɨ'²³ cuo̱o̱³ rey Salomón, juø'n³ quie'²³ bi²³ lii'², juø'n³ quie'²³ bi²³ ñúun³ la²³jɨ³ 'e³ xa³ quie'² mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jmee²³ ji̱i̱³ Dios 'e³ sɨ³li³xa³ mɨ²lii³¹ xoo'³¹ nuu³, juø'n³ quie'²³ ca²³ji̱i̱³ hua² xa³. 'É̱e̱² 'e³ jmee²³ ji̱i̱³ mɨ³¹cuo̱o̱³ 'e³ lii'². Jmee²³ quie'²³ ji̱i̱³, juø'n³ quie'²³ co̱o̱³ jmɨ́ɨ² rɨ³nɨ²³ cɨ² xa³. 'E³ quie'²³ mi²'aa³ rɨ²³jɨ̱́²³te'²³ too³ 'uɨ̱́ɨ̱². Rɨ²³jmée²³ cɨ² ji̱i̱³ 'e³ rɨ²cɨ'²ra'³ 'nee'²³ 'i³ bi²³ ca³pii'² sɨ³táan³na'³ quia̱'n²na'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","'E³ jo̱³ 'a²³ rɨ³mi³ñúun²na'³ 'óo²ra'³. 'A²³ rɨ³juo'³ra'³: “¿'Ee² mi'³ 'noo³¹ rɨ²'ni'² rɨ²quie²ra²? ¿'Ee² 'noo³¹ rɨ²quii'²ra²?” ");
INSERT INTO cnlNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Qui² la²³jɨ³ 'e³ jo̱³ hua² mi³quí̱i̱n²³ dsa³ jia'³. 'E³ quie'²³ ñi³² Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³ 'e³ 'ne'² quién²na'³ la²³jɨ³ 'e³ lø³² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","'E³ quie'²³ rɨ²mi³quí̱i̱n²³na'³ ca³quie̱e̱² 'e³ jmii'³¹ rɨ²³lín³ Dios juii³ra'³, 'e³ jmii'³¹ rɨ²jmée²ra'³ ca³dsaan³² 'e³ la²³ 'née²³ 'ñée². Jo̱³ hua² rɨ²³cuǿø²³ 'nee'²³ la²³jɨ³ 'e³ 'ne'² quie'² jmɨ² ŋú²ra'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","'A²³ rɨ³mi³ñúun²na'³ 'óo²ra'³ jén²³ cɨ² 'e³ jmii'³¹ cu³lø³¹ u²³ŋɨ́³ dsɨ́ɨ² 'e³ li²³xa³ cɨ̱ɨ̱n³ cɨ². Qui² jia'³ cɨ'²³ cu³lø³¹ u²³ŋɨ́³ dsɨ́ɨ² 'e³ sɨ³li³xa³ cɨ'³ la²³ co̱o̱³ jmɨ́ɨ². Líi² 'nɨɨ'n³¹ u²³ŋɨ́³ dsɨ́ɨ² 'e³ sɨ³li³xa³ cɨ'³ la²³ co̱o̱³ jmɨ́ɨ² 'e³ rɨ²jmée²ra'³ 'i'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’'A²³ rɨ³juo'³ra'³ 'e³ 'nɨɨ'n³¹ uu'n²na'³ xa³ dsoo² quiee'³². Jo̱³ hua² 'a²³jia'³ rɨ²³jme'²³ 'nee'²³ la'³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Qui² la²³'nɨɨ'n³¹ 'e³ juo'³ra'³ 'e³ xa³ dsoo² quiee'³² uu'n²na'³, 'e³ quie'²³ la'³ 'nɨɨ'n³¹ 'e³ rɨ²³jua'³ Dios 'e³ xa³ dsoo² quien³²na'³. La²³'nɨɨ'n³¹ ñuu'n³¹ jmee³ra'³ 'nee'²³ quia̱'n²na'³ uu'n²na'³, 'e³ quie'²³ la'³ 'nɨɨ'n³¹ ñu'n² rɨ²³jmée²³ 'ñée² quia̱'² 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jmii'³¹ lǿ² 'e³ sɨ³li³bii²³ 'óo²ra'³ 'e³ joo³²ra'³ mɨ³¹'laa³ pii'² 'e³ 'iʉ² mɨ²ñi² uu'n²na'³? 'E³ quie'²³ 'a²³jia'³ mi³quí²ra'³ 'noo³¹ 'mo³ 'e³ 'iʉ² mɨ²ñí²ra'³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Jmii'³¹ lǿ² 'e³ sɨ³li³bii²³ 'óo²ra'³ 'e³ juɨɨ'³²ra'³ uu'n²na'³: “Maan²³² rɨ²dxin²³² mɨ³¹'laa³ pii'² 'e³ 'iʉ² mɨ²ñín²”, 'e³ quie'²³ 'iʉ² xi³ 'noo³¹ 'mo³ mɨ²ñí²ra'³ miin²³na'³? ");
INSERT INTO cnlNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Bi²³ te³ jmee³ra'³ guóo². Xe̱'n² cɨ² 'ne'² rɨ²dxí²ra'³ 'noo³¹ 'mo³ 'e³ 'iʉ² mɨ²ñí²ra'³ miin²³na'³. Jo̱³ hua² li²³jné²³ quién²na'³ 'e³ la²³ rɨ²³lí³ juø'² rɨ²dxí²ra'³ mɨ³¹'laa³ pii'² 'e³ 'iʉ² mɨ²ñi² uu'n²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’'A²³ rɨ³cuø³ra'³ la²³jɨ³ 'e³ rɨ³jɨ́² quie'² Dios 'e³ rɨ²cuøø³¹ra'³ dsa³ 'i³ 'a²³jia'³ ta³dsɨ³², 'i³ xen³ la²³ xen³ dsɨɨ³. 'E³ quie'²³ xi³nu³ jmee³ra'³ la'³, 'é̱e̱² 'e³ jua³²ra'³ xi²ñi² cu²xi³¹ mɨ³¹huii'³ 'e³ bi²³ quí̱i̱n²³. Qui² bi²³ juø'² rɨ²³'ee²³ cu²xi³¹ ñi'² mɨ³¹huii'³ jo̱³. Jo̱³ tu³ rɨ²³ji̱i̱n²³, 'e³ rɨ²³cu'n³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Rɨ²ŋɨɨ'³¹ra'³ Dios. Jo̱³ hua² rɨ²³cuǿø²³ 'nee'²³. Rɨ²'no'²ra'³. Jo̱³ hua² rɨ²³dxe'n³na'³. Rɨ²tǿ²ra'³ 'oo'². Jo̱³ hua² rɨ²³né²te'²³ quién²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Qui² sɨ³'ióo²³ la²³jɨn³ dsa³ 'i³ ŋɨɨ²³. Sɨ³dxoo'²³ dsa³ 'i³ 'no'²³. 'E³ quie'²³ rɨ²³né²te'²³ 'oo'² je² tø³² dsa³ 'i³ tø³². ");
INSERT INTO cnlNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’'A²³'i̱³ xen³ 'nee'²³ 'i³ rɨ²cuøø³¹ra'³ jo̱o̱³ra'³ cú̱u̱² xi³nu³ ŋɨɨ²³ 'ɨ²³juɨ², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","'E³ quie'²³ la'³ 'a²³jia'³ rɨ²cuǿøn¹na'³ 'luu³ xi³nu³ ŋɨɨn³² 'moo'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Móo³ra'³ 'nee'²³ 'i³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³ 'e³ jmii'³¹ rɨ²cuøø³¹ra'³ jo̱o̱³ra'³ la²³jɨ³ 'e³ dxʉ́²³. 'E³ jo̱³ bi²³ cɨ² ma²³'nee³ rɨ²³cuǿ²³ 'e³ dxʉ́²³ Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³, rɨ²³cuǿø²³ dsa³ 'i³ ŋɨɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Rɨ²jmee'³¹ra'³ dsa³ 'e³ la²³ 'noo³ra'³ miin²³na'³ 'e³ rɨ²³jme'²³te'²³ 'nee'²³. Qui² la'³ jua'³ ley 'e³ ca²³ŋɨ́n² Moisés. 'E³ quie'²³ la'³ júu² 'e³ ca²³té̱e̱² ji³ te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Rɨ²taa'n³²na'³ 'oo'² 'e³ bi²³ dsuu³. Qui² xa³ 'oo'² 'e³ bi²³ jlo² co̱'³. 'A²³jia'³ gáan³ dxíi³ jui³¹ je² dsoo³² dsa³ mɨ³rɨ³ŋɨ́n³ 'oo'² 'e³ bi²³ jlo². Qui² jui³¹ juee'³ hua² jo̱³. 'E³ quie'²³ rɨ²³gua'²³ dsa³ 'i³ ŋɨ́³ jui³¹ jo̱³. Bi²³ juɨ́ɨn²³ dsa³ sɨ³'ín³ 'oo'² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","'E³ quie'²³ 'a²³jia'³ lø³² la'³ 'oo'² 'e³ bi²³ dsuu³. Bi²³ gáan³ dxíi³ jui³¹ je² dsoo³² dsa³ mɨ³rɨ³ŋɨ́n³ 'oo'² jo̱³. 'E³ quie'²³ rɨ²³ji̱i̱'²³ dsa³ 'i³ ŋɨ́³ jui³¹ jo̱³. 'A²³jia'³ juɨ́ɨn²³ 'i³ sɨ³dxoo'²³. Te³ 'i̱i̱² hua². ");
INSERT INTO cnlNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Rɨ³móo³ra'³. Qui² xen³ dsa³ 'i³ te³ juu³² 'i³ jua'³ 'e³ rɨ³løn³¹te'¹ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. 'É̱e̱² 'e³ quii'³ jñʉ³ jó̱² dsɨɨ³ joo³. 'E³ quie'²³ ñʉ'²³ dsɨ́² rɨ³løn³¹ dsɨɨ³ nuu³ 'i³ cu'n³ dsɨɨ³ joo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Li²³quin³na'³ 'e³ jmii'³¹ cu³løn³¹ dsa³ mɨ³rɨ³joo³²ra'³ 'e³ jmii'³¹ jmoo³². 'A²³la³ jo̱³ xoo'³¹ tó̱o̱² 'e³ 'ɨɨ³ mɨ²jø'², ¿mɨ³naa'³¹? 'A²³la³ jo̱³ noo² 'e³ 'ɨɨ³ mɨ²higo, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","La²³jɨ³ 'mo³ 'e³ dxʉ́²³ 'ɨɨ³ mɨɨ³¹ 'e³ dxʉ́²³. 'E³ quie'²³ 'a²³jia'³ 'nee'³¹ mɨɨ³¹ 'e³ 'ɨɨ³ 'mo³ 'e³ 'a²³jia'³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'A²³jia'³ rɨ²³lí³ juø'² rɨ²³'ɨ́ɨ²³ mɨɨ³¹ 'e³ 'a²³jia'³ 'nee'³¹ 'mo³ 'e³ dxʉ́²³. 'E³ quie'²³ la'³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³'ɨ́ɨ²³ mɨɨ³¹ 'e³ dxʉ́²³ 'mo³ 'e³ 'a²³jia'³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Quiʉʉ'³²te'²³ la²³jɨ³ 'mo³ 'e³ 'a²³jia'³ 'ɨɨ³ mɨɨ³¹ 'e³ dxʉ́²³. Too'²³te'²³ dxi³¹ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'E³ jo̱³ li²³quin³na'³ 'e³ jmii'³¹ cu³løn³¹ dsa³ mɨ³rɨ³joo³²ra'³ 'e³ jmii'³¹ jmoo³². ");
INSERT INTO cnlNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’'A²³la³ la²³jɨn³ dsa³ 'i³ sɨ'²³ jné²: “Juii³ra'³¹, Juii³ra'³¹”, 'i³ rɨ²³ta'n²³ yʉʉ'³¹ güii³ je² røøn³ Dios. Qui² la²³'nɨɨ'n³¹ dsa³ 'i³ jmee²³ 'e³ la²³ 'née²³ Ñu'n²³ 'i³ jen³¹ yʉʉ'³¹ güii³ hua² 'i³ rɨ²³ta'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³, juɨ́ɨn²³ 'i³ rɨ²³jua'³ rɨ²³sɨ'²³ jné²: “Juii³ra'³¹, Juii³ra'³¹, ca²³'ii²ra'³¹ júu² quiee'³² Dios 'e³ juaa'³ra'³¹ rɨ³løn³¹na'³¹ dsa³ quien³²nu³, ¿mɨ³naa'³¹? Ca²³'uøøn²³²na'³¹ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'e³ juaa'³ra'³¹ rɨ³løn³¹na'³¹ dsa³ quien³²nu³, ¿mɨ³naa'³¹? Bi²³ gáan³ la²³jɨ³ 'e³ ca²³jmee²ra'³¹ 'e³ juaa'³ra'³¹ rɨ³løn³¹na'³¹ dsa³ quien³²nu³, ¿mɨ³naa'³¹?” La'³ rɨ²³sɨ'²³te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jo̱³ hua² rɨ²juøøn³¹na¹te'¹: “'A²³jia'³ lɨ'³ ca³la³cuiin²³na²³ 'nee'²³. Je̱'n²na'³, 'nee'²³, te'²³ dsa³ 'i³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’La²³la³ cu³løn³¹ la²³jɨn³ dsa³ 'i³ nuu³ júu² quián²³, 'i³ jmoo³² 'e³ la²³ lǿ²: Xen³ la²³ xen³ jø̱n³ dsa³ 'i³ bi²³ ta³jmee²³ 'i'²³. Ca²³jmée³ 'ñʉ́² ñi'² 'loo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ca²³tɨ́³ 'e³ ca²³'ló²³ jmɨ́². Ca²³la²³bee'² jmɨɨ³. Bi²³ ca²³ró̱o̱²³ dxí³. Ca²³cuǿ³ dxí³ 'ñʉ́² jo̱³. 'E³ quie'²³ 'a²³jia'³ ca²³'ló²³ 'ñʉ́². Qui² ñi'² 'loo³ ja³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","La²³la³ cu³løn³¹ la²³jɨn³ jia'³ cɨ'²³ dsa³ 'i³ nuu³ júu² quián²³, 'e³ quie'²³ 'a²³jia'³ jmoo³² 'e³ la²³ lǿ²: Xen³ la²³ xen³ jø̱n³ dsa³ 'i³ 'a²³jia'³ ta³jmee²³ 'i'²³. Ca²³jmée³ 'ñʉ́² je² bi²³ xa³ sɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ca²³tɨ́³ 'e³ ca²³'ló²³ jmɨ́². Ca²³la²³bee'² jmɨɨ³. Bi²³ ca²³ró̱o̱²³ dxí³. Ca²³cuǿ³ dxí³ 'ñʉ́² jo̱³. 'E³ quie'²³ ca²³'ló²³ 'ñʉ́². Bi²³ bee'² 'e³ ca²³lǿ²³ ma²mɨ³'ló²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ma²ca¹líi¹ ca²³'ɨ́ɨ³ júu² Jesús, bi²³ juø'²³ ca²³ti²³cø̱n³¹ dsa³ 'i³ ca²³núu³ júu² 'e³ ca²³'é³. ");
INSERT INTO cnlNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Qui² ca²³'é³ Jesús 'e³ la²³ 'e²³ jø̱n³ dsa³ 'i³ 'uee'n³ júu² quiee'³². 'A²³la³ 'e³ la²³ 'e²³ dsa³ 'e²³ ley quien³²te'²³ ca²³'é³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ma²ca¹jiaan³² Jesús 'e³ ñíin² yʉʉ'³¹ mo'³, juɨ́ɨn²³ dsa³ 'i³ ca²³qui̱'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jo̱³ ca²³dxóo² caan²³ Jesús jø̱n³ dsa³ 'i³ ta̱a̱n²³ goo³. Ca²³xii'³ jñi² xi²ñi² Jesús. Ca²³jua'³: ―Juiin²³, rɨ²³lí³ juø'² rɨ²jméen² 'e³ rɨ²³jñíin³ la³'en²³ xi³nu³ 'naan³ rɨ²jméen² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","'E³ jo̱³ ca²³'ɨ́ɨ³ guoo³ Jesús. Ca²³quiu̱u̱'n³ dsa³ 'í³. Ca²³jua'³: ―'Náan²³ xú̱n³. Cu²jñíin³ la³'én². Xe̱'n² quie'²³ jmɨ́ɨ² jo̱³ ca²³je̱'n²³ goo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Sú̱n² quie'²³ 'a²³ rɨ³juɨɨ'n³² jia'³ cɨ'²³ dsa³ 'e³ la²³ mɨ³lǿ²³. Guo³ cu³'én² 'uǿøn²nu³ jmii³ dsa³. Rɨ²cuøøn³¹nu³ Dios la²³jɨn³ 'i³ cuøn³² dsa³ 'i³ mɨ³jŋɨn³ la³'e². Qui² la'³ cu³lø³¹ ca²³dxi³ 'i'²³ Moisés. Jo̱³ hua² rɨ²³dsóo²³ dsɨ́² dsa³ 'e³ mɨ³jŋɨn³ la³'én². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ma²'i³¹ Jesús jee²³² juɨɨ³ Capernaum, ca²³lǿn²³ mɨ³lén² jø̱n³ dsa³ jia'³ 'i³ rɨ³løn³¹ juii² co̱o̱³ i³láan³ dsa³ 'láa³. Bi²³ ca²³ŋɨ́ɨ³ mɨ²'áa². ");
INSERT INTO cnlNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ca²³jua'³: ―Juii³ra'³¹, rɨ³caa'n³² xi²ñʉ'¹ jø̱n³ mozo 'i³ jmee²³ ta² quián²³. Mɨ³la³tu̱u̱n²³². Bi²³ ma²³'nee³ dxi³quié̱n². ");
INSERT INTO cnlNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ juii² dsa³ 'láa³: ―Ñiin²³ i³mi³'láan²na²³ mozo quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","'E³ quie'²³ ca²³jua'³ juii² dsa³ 'láa³: ―Juiin²³, bi²³ 'a²³jia'³ dxún²³na²³. 'A²³jia'³ dxi³ji̱i̱n³¹ 'e³ rɨ²'ín³nu³ xi²ñʉ'¹ quián²³. Líi² te³ rɨ²dxín² 'i'²³. Jo̱³ rɨ²³'láan³ mozo quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Xen³ dsa³ 'i³ dxi³ 'i'²³ quián²³. 'E³ quie'²³ la'³, xen³ dsa³ 'láa³ 'i³ dxin²³ 'i'²³ quie'². Líi² te³ rɨ²juøøn³¹na¹ jø̱n³: “Guo³”. 'E³ quie'²³ jo̱³ dsoo³². 'E³ quie'²³ rɨ²juøøn³¹na¹ jia'³ cɨ'²³: “Ñe³ la³”. 'E³ quie'²³ jo̱³ rɨ²³ja³. Juøøn³² mozo quién²³na²³: “La²³la³ cu³lø³¹ rɨ²jméen²”. 'E³ quie'²³ jo̱³ rɨ²³jmée²³ la'³. ―La'³ ca²³jua'³ juii² dsa³ 'láa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bi²³ juø'²³ ca²³núu³ Jesús júu² quiee'³². Ca²³sɨ'²³ te'²³ dsa³ 'i³ quia̱'²: ―Jné² rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Cu³xi³ la²³ca̱a̱n³ juɨɨ³ quiee'³² dsa³ Israel 'a²³jia'³ lɨ'³ ca³jí̱i̱n³na²³ dsa³ 'i³ sɨ³táan³ quia̱'² jné² 'e³ la²³'nɨɨ'n³¹ 'e³ sɨ³táan³ dsa³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jné² rɨ²juøøn³¹na¹ 'nee'²³: Juɨ́ɨn²³ dsa³ jia'³ 'i³ rɨ²³ja²³guín²³ je² huɨ̱́ɨ̱³ i²³la³ i²³nɨ³ 'e³ rɨ²³gua³te'²³ coo³¹ mesa quia̱'²te'²³ Abraham quia̱'² Isaac quia̱'² Jacob yʉʉ'³¹ güii³ je² rɨ³løn³¹ Dios juii². ");
INSERT INTO cnlNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","'E³ quie'²³ 'a²³jia'³ rɨ²³ta'n²³ la²³jɨn³ dsa³ Israel 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³ta'n²³ je² rɨ³løn³¹ Dios juii². Rɨ²³juén²te'²³ je² li³'o̱o̱³ te'²³ 'i³ 'í³. Je² núu²³ rɨ²³'o'² dsa³. Rɨ²³cuu'³ la²³ cɨ² jo̱²te'¹ 'e³ la²³'nɨɨ'n³¹ 'e³ rɨ²³ŋɨ́³ dsɨ́²te'²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","'E³ jo̱³ ca²³sɨ'²³ juii² dsa³ 'láa³: ―Guø'n³. Cu²lí³ 'e³ la²³ mɨ³ŋɨ'n²nu³ jné². Qui² sɨ³táan³nu³ quia̱'n²nu³ jné². Xe̱'n² quie'²³ 'e³ la²³ ca²³jua'³ la'³ Jesús, ca²³'láan³ mozo quien³² juii² dsa³ 'láa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ma²'i³¹ Jesús xi²ñʉ'¹ quiee'³² Peen²³², ŋó²³ 'e³ dsoo'²³² xóo² mɨ²³quie'² Peen²³². Rɨ³caa'n³². Qui² jmee²³ dsóo² dxíi³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","'E³ quie'²³ jo̱³ ca²³'ɨ́ɨ³ guoo³ Jesús 'e³ ca²³quiu̱u̱'n³ guoo³ mɨ́³. 'E³ jo̱³ ca²³je̱'n²³ dsóo² dxíi³. 'E³ quie'²³ jo̱³ ca²³naa'n²³ mɨ́³. Ca²³jí̱² ca²³tí³ ca²³mi²³quin³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ma²ca¹nʉʉ³ jmɨ́ɨ² jo̱³, i²jøn²³te'²³ caan²³ Jesús juɨ́ɨn²³ dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². 'E³ jo̱³ ca²³lʉ́³ Jesús. 'E³ quie'²³ jo̱³ ca²³'uǿøn² espíritus. Co̱'³ cɨ'²³ ca²³mi²³'láan³ la²³jɨn³ 'i³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","La'³ ca²³jmée³ 'e³ la²³ rɨ²³lí³ 'e³ la²³ ca²³jua'³ Isaías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², 'e³ rɨ²³lí³. Qui² ca²³jua'³ Isaías: “Ca²³je̱'n² 'ñée² 'e³ jmee²³ 'e³ 'a²³jia'³ 'uee'n³ jmɨ² ŋú²ra². 'E³ quie'²³ ca²³je̱'n² dsóo² 'e³ jme'²³ jne².” La'³ ca²³jua'³ Isaías mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ŋó²³ Jesús 'e³ juɨ́ɨn²³ dsa³ 'i³ té̱e̱n³ la²³cu'². 'E³ jo̱³ ca²³dxi³ 'i'²³ 'e³ sɨ³guín²³te'²³ 'ŋóo² la²³ jmɨ²³ñii'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","'E³ quie'²³ jo̱³ ca²³lǿn²³ mɨ³lén² jø̱n³ dsa³ 'e²³ ley. Ca²³jua'³ ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³, 'náan²³ ñiin²³ quia̱'n²³²na¹ 'nʉ³ te³ jiaa'³¹ quie'²³ guaan³². ");
INSERT INTO cnlNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","'E³ jo̱³ ca²³jua'³ Jesús: ―Xa³ tóo² 'ioo'³. Xa³ mɨ²sɨɨ² jo̱o̱³¹ to̱³. 'E³ quie'²³ 'a²³'e³ xa³ quián²³ jné² Jo̱o̱³¹ Dsa³ je² guɨɨn²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Xen³ jia'³ cɨ'²³ dsa³ quien³² 'i³ ca²³jua'³: ―Juiin²³, cuø² júu² 'e³ i³'aan²³²cu²ru'³na²³ 'lɨ² ñu'n²³. Jo̱³ tu³ ñiin²³ quia̱'n²³²na¹ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Ñe³ quia̱'n²nu³ jné². Cu²'áan¹ quie'²³ 'lɨ́ɨ³ te'²³ dsa³ 'i³ 'é̱e̱² 'e³ rɨ³jú̱n². ");
INSERT INTO cnlNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","'Í² Jesús 'e̱'³ móo². 'E³ quie'²³ jo̱³ ca²³guín²³ dsa³ quien³² quia̱'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","'E³ quie'²³ jo̱³ bi²³ bee'² dxí³ ca²³ró̱o̱²³ ñi'² jmɨ²³ñii'³¹. Bi²³ 'uaa'³ bɨ³² jmɨɨ³. Sɨ³'o² jmɨɨ³ 'e̱'³ móo². 'E³ quie'²³ rɨ³guɨɨn³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","'E³ jo̱³ ca²³ñín²te'²³ Jesús. Ca²³jua'³te'²³: ―Laan²³² jne², Juii³ra'³¹. Qui² mɨ³ sɨ³gua'²³ jne² rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","'E³ quie'²³ ca²³jua'³ 'ñée² Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―¿'Ee² lǿ² bi²³ juøø'n²³na'³, 'nee'²³ 'i³ bi²³ ca³pii'² sɨ³táan³ quia̱'² jné²? 'E³ jo̱³ ca²³naa'n²³. Ca²³jín² dxí³ quia̱'² jmɨ²³ñii'³¹. 'E³ jo̱³ 'a²³jia'³ ma²³ ca²³xáan² 'ñée² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bi²³ juø'²³ ca²³jóo² dsa³. Ca²³jua'³te'²³: ―¿'I̱i̱² mi'³ dsa³ nɨ³ cu²ne²ra²? Dxí³ bee'² quia̱'² jmɨɨ³ mi'³ mɨ³guaan²³ 'e³ la²³ mɨ³dxi³ 'i'²³, ¿na'²? ");
INSERT INTO cnlNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ca²³dxóo² Jesús 'ŋóo² la²³ jmɨ²³ñii'³¹ je² nee'n²³² dsa³ Gadara. 'E³ quie'²³ jo̱³ ca²³mi²³jí̱i̱n³ Jesús áan²³ dsa³ 'i³ ca²³'uǿøn² too³ 'loo³ je² 'aan³²te'²³ 'lɨ́ɨ³. Quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'² te'²³ dsa³ 'í³. 'A²³jia'³ ma²³ rɨ²³lí³ juø'² rɨ²³ŋɨ́n³ dsa³ jui³¹ je² nee'n²³²te'¹ 'e³ la²³'nɨɨ'n³¹ la³jmøn³¹te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Quiʉ̱ʉ̱³ ca²³lʉ́³ te'²³ dsa³ 'í³. Ca²³jua'³: ―Rɨ²xii'³¹ra'³¹ 'nʉ³, Jo̱o̱³¹ Dios: ¿'Ee² lǿ² dxaan²³nu³ 'uǿøn²nu³ quia̱'n²nu³ jnee'³¹? ¿'A² mɨ³güén²³nu³ la³ 'e³ juø'n³ rɨ²jmee'n³¹nu³ jnee'³¹ 'e³ 'íi² quie'²³ rɨ²³tɨ́²³ jmɨ́ɨ² la'³? ");
INSERT INTO cnlNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Xen³ juɨ́ɨn²³ cu²xi³¹ 'i³ ta'n² ee'³² je² huɨ̱́ɨ̱³ ca³juɨ² la²³ nee'n²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bi²³ ca²³ŋɨ́ɨ³ la²³bii²³ miin²³ te'²³ espíritus quien³² mɨ²³sɨ²³quiʉ'². Ca²³sɨ'²³te'²³ Jesús: ―Xi³nu³ rɨ²'uøøn²³²nu³ jnee'³¹, cuø² júu² 'e³ rɨ²ta'n²na'³¹ cu²xi³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","'E³ jo̱³ ca²³jua'³ Jesús: ―Cu³guín²³na'³ je² 'o³ra'³ nɨ³. 'E³ jo̱³ ca²³'uǿøn²te'²³ 'e³ ta'n²te'²³ dsa³. Ca²³taa'n³te'²³ miin²³te'²³ cu²xi³¹. 'E³ quie'²³ jo̱³ ca²³cuɨ̱́ɨ̱² la²³jɨn³ sú̱n² cu²xi³¹. Ca²³guín²³te'²³ je² juɨɨ'²³². Ca²³jiu'n² cu²xi³¹ 'e̱'³ jmɨ²³ñii'³¹. 'E³ jo̱³ ca²³'a'n²te'²³ 'e̱'³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","'E³ jo̱³ ca²³cuɨ̱́ɨ̱² dsa³ 'i³ 'aan³² cu²xi³¹. Ca²³ta'n²³ jee²³² juɨɨ³. Ca²³sɨ'²³ dsa³ la²³jɨ³ 'e³ ca²³lǿ²³. Ca²³jme'n² júu² 'e³ jmii'³¹ ca²³ji̱'²³ te'²³ dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'² xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","'E³ jo̱³ ca²³'uǿøn² la²³jɨn³ dsa³ juɨɨ³ 'e³ ca²³mi²³jí̱i̱n³te'²³ Jesús. Ma²ŋǿn¹te'²³ Jesús, ca²³sɨ'²³te'²³ 'e³ cu²bǿn³ la²³ca̱a̱n³ je² nee'n²³²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","'Í² co̱'³ 'e̱'³ móo² Jesús. Ca²³'øn³ co̱'³ jmɨ²³ñii'³¹. Ca²³dxe'n² co̱'³ juɨɨ³ quiee'³² joo³¹ i²³'ŋóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'E³ jo̱³ i²jøn²³te'²³ caan²³ Jesús jø̱n³ dsa³ 'i³ tu̱u̱n²³². 'Iún² jmoo³. Ca²³la²³quii²³ Jesús 'e³ jmii'³¹ 'nɨɨ'n³¹ sɨ³táan³te'²³ quia̱'²te'²³ 'ñée². 'E³ jo̱³ ca²³sɨ'²³ dsa³ 'i³ tu̱u̱n²³²: ―Ja̱a̱n²³ quién²³na²³, dxa² co̱o̱³ 'áan². Mɨ³uu³ dsoo² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","'E³ quie'²³ xen³ dsa³ 'e²³ ley 'i³ ca²³lǿn³: “Bi²³ 'ñe'² lʉ²³ dsa³ nɨ³. Jua'³ 'ñée² 'e³ jmee²³ 'e³ la²³ jmee²³ Dios.” ");
INSERT INTO cnlNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ñi³² Jesús 'e³ jmii'³¹ cu³lø³¹ 'i'²³ 'e³ jmoo³² dsa³ 'e²³ ley. 'E³ jo̱³ ca²³jua'³: ―¿'Ee² lǿ² jmee³ra'³ 'i'²³ 'e³ 'a²³jia'³ dxʉ́²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Jmii'³¹ cu³lø³¹ 'e³ tu³sɨ'²³ cɨ², lǿn³na'³? ¿'A² tu³sɨ'²³ cɨ² 'e³ rɨ²juøøn³¹na¹: “Mɨ³uu³ dsoo² quien³²nu³”? ¿'A² tu³sɨ'²³ cɨ² 'e³ rɨ²juøøn³¹na¹: “Naa'n²³ 'nʉ³. Ŋɨ² jo̱o̱²³na²³”? ");
INSERT INTO cnlNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Qui² 'náan²³ 'e³ rɨ²móo²ra'³ 'e³ xa³ ca³dsaan³² quián²³ jné² Jo̱o̱³¹ Dsa³ 'e³ yuun²³²na¹ dsoo² quiee'³² dsa³. 'E³ quie'²³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ tu̱u̱n²³²: ―Naa'n²³ 'nʉ³. Ben²³² jmoo³ quien³²nu³. Guø'n³ quién²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","'E³ jo̱³ ca²³naa'n²³ dsa³ 'i³ tu̱u̱n²³² xe̱'n². Ŋø'n² quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ŋó²³ la²³jɨn³ dsa³. Bi²³ juø'²³ ca²³jóo²te'²³. 'E³ jo̱³ ca²³mi²³gáan³te'²³ Dios. Qui² 'i³ 'í³ hua² 'i³ ca²³cuǿø²³ dsa³ júu² 'uee'n³ 'e³ lø³² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","'E³ quie'²³ jo̱³ ŋóo² co̱'³ Jesús. Ca²³jí̱i̱n³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Tee³¹. Jen³¹ co̱³² cuu² 'e³ rɨ³løn³¹ 'io'². 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Tee³¹: ―Ñe³ quia̱'n²nu³ jné². 'E³ jo̱³ ca²³naa'n²³ Tee³¹. Ŋóo² quia̱'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","'E³ la²³ jen³¹ Jesús xi²ñʉ'¹ coo³¹ mesa, ca²³dxi²³guín²³ juɨ́ɨn²³ 'io'² quia̱'² dsa³ tu³cua̱a̱n²tu². Ca²³guó³te'²³ quia̱'²te'²³ Jesús quia̱'² dsa³ quien³² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ŋó²³ te'²³ dsa³ fariseo 'e³ nee'n²³² te'²³ dsa³ 'í³ quia̱'² Jesús. 'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ dsa³ quien³² Jesús: ―¿'Ee² lǿ² ee'³² dsa³ 'e²³ quien³²na'³ quia̱'² 'io'² quia̱'² dsa³ tu³cua̱a̱n²tu²? ");
INSERT INTO cnlNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","'E³ quie'²³ ca²³núu³ Jesús 'e³ jmii'³¹ ca²³jua'³ te'²³ dsa³ fariseo. 'E³ jo̱³ ca²³jua'³ 'ñée²: ―'A²³'e³ xa³ je² 'ne'² tɨ³² 'oo³ quie'² te'²³ dsa³ 'i³ 'a²³jia'³ dsoo'²³². 'E³ quie'²³ dsa³ 'i³ dsoo'²³² hua² 'i³ 'ne'² tɨ³² 'oo³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","'Ne'² cu³mi³tɨn²³na'³ 'e³ 'ee² lǿ² to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: “'A²³la³ jo̱³ 'e³ te³ bi²³ xen³ 'i³ jŋɨ'n²³te'²³ 'e³ jua'³ cuøn²³te'²³ jné² 'e³ 'náan²³ jné². 'E³ quie'²³ 'náan²³ 'e³ li²³cuu'²³ dsɨ́² dsa³ ñin³² uu'n².” La'³ cu³lø³¹ to̱o̱²³ ji³. 'A²³la³ dsa³ 'i³ lǿn³ miin²³ 'e³ jmoo³² ca³dsaan³² 'i³ rɨ²tøøn³¹na¹ 'e³ güén²³na²³. 'E³ quie'²³ güén²³na²³ 'e³ rɨ²tøøn³¹na¹ dsa³ 'i³ mɨ³la³quii²³ miin²³ 'e³ rɨ³løn³¹te'¹ tu³cua̱a̱n²tu². 'Náan²³ 'e³ rɨ²³tʉ́²te'²³ 'e³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","'E³ quie'²³ jo̱³ ca²³dxi²³guín²³ te'²³ dsa³ quien³² Juan. Ca²³sɨ'²³te'²³ Jesús: ―Jmee³ra'³¹ mɨ²³jmɨɨ²³. 'E³ quie'²³ la'³ jmoo³² te'²³ dsa³ fariseo co̱'³. ¿'Ee² lǿ² 'a²³jia'³ jmoo³² mɨ²³jmɨɨ²³ te'²³ dsa³ quien³²nu³? ");
INSERT INTO cnlNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ quien³² Juan: ―'A²³jia'³ 'aa³ u²³ŋɨ́³ dsɨ́ɨ² dsa³ 'i³ nee'n²³² mɨ²juee'³ je² mɨ³tøø³² dsa³ mɨ́³ xi³nu³ jen³¹ quie'²³ mɨ²juee'³ dsa³ 'i³ mɨ³tøø³² mɨ́³, ¿mɨ³naa'³¹? 'E³ quie'²³ 'e³ cɨ² rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ 'a²³jia'³ ma²³ quia̱'²te'²³ dsa³ 'i³ mɨ³tøø³² mɨ́³. Jmɨ́ɨ² jo̱³ hua² 'e³ rɨ²³jmóo²te'²³ mɨ²³jmɨɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’'A²³jia'³ rɨ²³ti²³guo² xi³nu³ rɨ²³te̱e̱³ dsa³ 'mɨɨ'³ 'e³ 'a²³jia'³ ca²³jo'² je² rɨ³gɨ́ɨ² cuo̱o̱³ 'e³ jaa²³². Qui² rɨ²³jo'² 'mɨɨ'³ 'e³ mɨ³te̱e̱³. 'E³ jo̱³ rɨ²³je̱'n²³ je² mɨ³te̱e̱³ cuo̱o̱³. Jo̱³ bi²³ cɨ² rɨ²³guii³ cuo̱o̱³ 'e³ jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","'E³ quie'²³ la'³ cu³lø³¹ quie'² jmɨɨ'³¹ mɨ²jø'² vino co̱'³. 'A²³jia'³ rɨ²³ti²³guo² xi³nu³ rɨ²³xi'²³ dsa³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'mɨɨn³² 'e̱'³ tuu'³ loo³ 'e³ jaa²³². Xi³nu³ rɨ²³jmée²³ dsa³ la'³, rɨ²³mo'² tuu'³ loo³ 'e³ jaa²³². Rɨ²³tʉ̱ʉ̱³ jmɨɨ'³¹ mɨ²jø'² vino. 'E³ quie'²³ rɨ²³yáan²³ tuu'³ loo³ co̱'³. Qui² xii'²³ dsa³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'mɨɨn³² 'e̱'³ tuu'³ loo³ 'e³ 'mɨɨn³². La'³ hua² 'a²³'e³ xa³ rɨ²³lí³ ca³ti³². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lʉ²³ quie'²³ la'³ Jesús ma²ca¹dxóo¹ jø̱n³ dsa³ 'i³ dxi³ 'i'²³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Ca²³xii'³ jñi² xi²ñi² Jesús. Ca²³jua'³: ―'E³ cɨ² lá²³ mɨ³jú̱n²³ xii'³ mɨ́³ quién²³na²³. 'E³ quie'²³ 'náan²³ 'e³ sɨ³gui²³²ra². Cu³dxén² guaan³² ñi'² quiee'³². Jo̱³ hua² rɨ²³ji̱i̱'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","'E³ jo̱³ ca²³naa'n²³ Jesús. Ŋóo² quia̱'² dsa³ 'í³ quia̱'² te'²³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ca²³lǿn²³ mɨ³lén² rɨ²³coo'² Jesús jø̱n³ mɨ́³. Mɨ³tɨ́³ gui²³tʉ̱́³ ji̱i̱³ ñi³ 'e³ sɨ³ŋɨ́n³ jmɨ²³'ǿn². Ca²³quiʉ̱'² mɨ²xi¹guoo³ xʉʉ'²³² cuo̱o̱³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Qui² ca²³lǿn³ 'ñée²: Líi² te³ rɨ²quiu̱'n¹ xi²guaan²³ cuo̱o̱³. Jo̱³ rɨ²³liin²³na²³ 'u². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","'E³ quie'²³ ca²³ji̱i̱n²³ Jesús. Ca²³jóo² rɨ²³coo'². Ŋǿn² mɨ́³ 'í³ jo̱o̱²³na²³. 'E³ jo̱³ ca²³jua'³: ―Ja̱a̱n²³ quién²³na²³, dxa² co̱o̱³ 'áan². Mɨ³lɨɨn³²nu³. Qui² sɨ³táan³nu³ quia̱'n²nu³ jné². Xe̱'n² quie'²³ jmɨ́ɨ² jo̱³ lɨ́ɨn² mɨ́³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ca²³dxóo² Jesús xi²ñʉ'¹ quiee'³² dsa³ 'i³ dxi³ 'i'²³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Ŋó²³ 'e³ ta'n² te'²³ dsa³ 'i³ jiʉʉ³² 'mo³ ta³. Nee'n²³² dsa³ 'i³ ta'n² cɨɨ²³ 'oo'³². Yoo'²³ tø³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","'E³ jo̱³ ca²³jua'³: ―'Uøøn³²na'³. Qui² 'a²³jia'³ rɨ³jú̱n² xii'³. Te³ rɨ³guɨɨn³ hua². Bi²³ ca²³jáa² ca²³ŋɨ́ɨn²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","'E³ quie'²³ ca²³'uøøn³te'²³ dsa³ 'í³. 'E³ jo̱³ 'í² Jesús je² rɨ³caa'n³² xii'³. So̱'²³ guoo³ xii'³. 'E³ jo̱³ ca²³naa'n²³ xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ca²³núu³ dsa³ la²³ca̱a̱n³ je² mɨ³lén² 'e³ jmii'³¹ ca²³lǿ²³ je² núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","'E³ la²³ ca²³bǿn³ je² núu²³ Jesús, ŋóo² co̱'³. Xen³ áan²³ dsa³ tuu² mɨ²ñi² 'i³ ca²³guín²³ tu³cɨ̱ɨ̱n³. Quiʉ̱ʉ̱³ ca²³lʉ́³te'²³. Ca²³jua'³te'²³: ―Dsa³ ju̱u̱n²³ David, cu²li³cuu'²³ 'áan² quia̱'n²nu³ jnee'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","'Í² xi²ñʉ'¹ Jesús. 'E³ jo̱³ ca²³lǿn²³ mɨ³lén² te'²³ dsa³ tuu². Ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ 'í³: ―¿'A² sɨ³táan³na'³ 'e³ rɨ²³lí³ juø'² rɨ²mi³'láan²na²³ 'nee'²³? 'E³ jo̱³ ca²³jua'³te'²³: ―Sɨ³táan³na'³¹ xú̱n³, Juii³ra'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","'E³ jo̱³ ca²³quiʉ̱'² Jesús mɨ²xi¹guoo³ mɨ²ñi²te'¹. Ca²³jua'³: ―Cu²lí³ quién²na'³ 'e³ la²³'nɨɨ'n³¹ lǿ² 'e³ sɨ³táan³na'³ 'e³ rɨ²³lí³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'E³ jo̱³ ca²³la²³jné³ mɨ²ñi²te'¹. Ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ 'í³: ―Cu³xi³ jø̱n³ dsa³ 'a²³ rɨ³juɨɨ'³²ra'³ 'e³ jmii'³¹ mɨ³nó³ mɨ²ñí²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","'E³ quie'²³ ca²³guín²³quie'²³te'²³. Ca²³jme'n²te'²³ júu² la²³ca̱a̱n³ je² mɨ³lén² 'e³ jmii'³¹ 'nɨɨ'n³¹ dxʉ́²³ ca²³jmée³ Jesús quie'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","'E³ la²³ sɨ³'uǿøn² dsa³ 'i³ ca²³nó³ mɨ²ñi², i²jøn²³te'²³ caan²³ Jesús jø̱n³ dsa³ coo²³² 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ca²³dxin³ Jesús espíritu quien³² mɨ²³sɨ²³quiʉ'². 'E³ quie'²³ jo̱³ ca²³lʉ́³ dsa³ 'i³ caan²³² xe̱'n². Bi²³ juø'²³ ca²³ti²³cø̱n³¹ la²³jɨn³ dsa³. Ca²³jua'³te'²³: ―'A²³jia'³ lɨ'³ ca³ne²ra² 'e³ lø³² la²³nɨ³ la²³ca̱a̱n³ juɨɨ³ quiee³² jne² dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","'E³ quie'²³ ca²³jua'³ te'²³ dsa³ fariseo: ―Juii² espíritus quien³² mɨ²³sɨ²³quiʉ'² 'i³ cuø²³ ju²³bíi²³ quie'² Jesús 'e³ sɨ³lí³ juø'² 'uøøn³ espíritus quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ca²³ŋɨ́³ Jesús la²³ca̱a̱n³ juɨɨ³ bee'² quia̱'² ranchos. Ca²³'ée²³ dsa³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios te'²³ dsa³ Israel. Ca²³'ɨ́ɨ³ júu² dxʉ́²³ 'e³ Dios hua² 'i³ rɨ³løn³¹ juii² dsa³. Ca²³mi²³'láan³ te'²³ dsa³ 'i³ dsoo'²³² quia̱'² te'²³ dsa³ 'i³ cuu'²³ 'i³ lø³² quie'², juø'n³ jmi'³ lǿ² dsóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","'E³ la²³ ca²³jóon² la²³jɨn³ dsa³ Jesús, bi²³ ca²³la²³cuu'²³ dsɨ́² quia̱'² dsa³. Qui² mɨ³'uaa'n²³ dsɨ́²te'²³. Mɨ³'lǿn²³te'²³. Xen³ la²³ xen³ dsɨɨ³ joo³ 'i³ 'a²³'i̱³ xen³ 'i³ mi³qui³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―Bi²³ ñúun³ xa³ je² 'ne'² rɨ²³lí³ 'ó̱o̱²³. 'E³ quie'²³ 'a²³jia'³ juɨ́ɨn²³ xen³ 'i³ rɨ²³jmóo² 'ó̱o̱²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","'E³ jo̱³ 'ne'² rɨ²lʉ́²ra'³ quia̱'n²na'³ juii² ta², 'e³ rɨ²juɨɨ'³¹ra'³ 'e³ cu²xíin¹ cɨ² mozo 'i³ sɨ³jmóo² 'ó̱o̱²³ quiee'³². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ca²³tøø³ Jesús gui²³tʉ̱́n³ dsa³ xiin²³ quien³². Ca²³cuǿ³ júu² 'uee'n³ quie'²te'²³ 'e³ rɨ²³lí³ juø'² rɨ²³'uøøn³te'²³ espíritus quien³² mɨ²³sɨ²³quiʉ'², 'e³ rɨ²³lí³ juø'² rɨ²³mi²³'láan³te'²³ dsa³ 'i³ dsoo'²³² quia̱'² dsa³ 'i³ cuu'²³ 'i³ lø³² quie'², juø'n³ jmi'³ lǿ² dsóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","La²³la³ cu³lø³¹ xi̱i̱n³ la²³jɨn³ gui²³tʉ̱́n³ dsa³ xiin²³ quien³²: Muun³² 'i³ sɨ'²³te'²³ Peen²³² quia̱'² jó̱o̱² 'i³ xi̱i̱n³ Drøø³¹; Jacobo jo̱²³ñʉʉ'³¹ Zebedeo quia̱'² jó̱o̱² 'i³ xi̱i̱n³ Juan; ");
INSERT INTO cnlNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Bi³lii² quia̱'² Bar³too²; Tu³moo³² quia̱'² Tee³¹ 'i³ rɨ³løn³¹ 'io'²; Jacobo jo̱²³ñʉʉ'³¹ Alfeo quia̱'² Tadeo; ");
INSERT INTO cnlNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Muun³² 'i³ rɨ³løn³¹ dsa³ cananista quia̱'² Judas Iscariote 'i³ ca²³'nɨ́ɨn²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","'E³ quie'²³ jo̱³ ca²³xíin²³ te'²³ dsa³ gui²³tʉ̱́n³ 'í³ Jesús. Ca²³jua'³: ―'A²³ rɨ³cu³guín²³na'³ je² nee'n²³² dsa³ jia'³. 'E³ quie'²³ la'³ juɨɨ³ quiee'³² dsa³ Samaria. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","'E³ quie'²³ cu³guín²³na'³ la²³ca̱a̱n³ je² nee'n²³² dsa³ Israel 'i³ mɨ³ca³caa'n³², 'i³ xen³ la²³ xen³ dsɨɨ³ joo³ 'i³ mɨ³ca³guín²³ jia'³ cɨ'²³ jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","'E³ la²³ cu³guín²³na'³, rɨ²'ɨ́ɨ²ra'³ júu². Rɨ²juɨɨ'³¹ra'³ dsa³: “Mɨ³lǿ²³ mɨ³lén² 'e³ rɨ²³lín³ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³”. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Rɨ²mi³'láan²na'³ dsa³ 'i³ dsoo'²³². Rɨ²jmée²ra'³ 'e³ rɨ²³ji̱i̱'²³ co̱'³ dsa³ 'i³ sɨ³jú̱n³. Rɨ²jmée²ra'³ 'e³ rɨ²³jñíin³ la³'e² dsa³ 'i³ ta̱a̱n²³ goo³. Rɨ²'uøøn²³²na'³ espíritus quien³² mɨ²³sɨ²³quiʉ'². 'A²³jia'³ ca²³la²³'ne'² 'e³ rɨ²cɨ́²ra'³ ma²'ieen³¹na'³ ju²³bíi²³. 'E³ jo̱³ 'a²³jia'³ 'ne'² 'e³ rɨ²có̱²ra'³ jñiin²³na'³ 'e³ la²³ jmee²³ ta² ju²³bíi²³ jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’'A²³ rɨ³jmee³ra'³ ji̱i̱³ cu²nee³¹ 'e³ rɨ²pe'¹ra'³ paa²i² 'e³ la²³ cu³guín²³na'³. 'A²³ cɨ'²³ cu²taa³. 'A²³ cɨ'²³ cu²laa'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","'A²³ rɨ³jmee³ra'³ ji̱i̱³ morral 'e³ quié̱²ra'³ cu³guín²³na'³. Líi² co̱³dsa'n² cuo̱o̱³²ra'³. 'A²³ cɨ'²³ loo³ taa'² tɨɨ³¹ra'³. 'A²³ cɨ'²³ 'mo³ mɨ³'uu²³². Qui² joo'²³ 'e³ rɨ²³'ióo²³ 'e³ rɨ²³e'² dsa³ 'i³ jmee²³ ta². ");
INSERT INTO cnlNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Mɨ³rɨ³taa'n³²na'³ juɨɨ³, mɨ³rɨ³taa'n³²na'³ rancho, rɨ²'naa'n²³na'³ dsa³ 'i³ jmee²³ 'e³ la²³ dxi³ji̱i̱n³¹. 'E³ jo̱³ rɨ²cuaa'n²³na'³ xi²ñʉ'¹ quiee'³² dsa³ 'í³ la²³huø'n²³ 'e³ rɨ²³tɨ́²³ 'e³ rɨ²'uøøn³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'E³ la²³ rɨ²taa'n³²na'³ xi²ñʉ'¹, rɨ²cuǿ²ra'³ u²³juee'n³¹ 'e³ rɨ²juɨɨ'³¹ra'³ Dios 'e³ cu²gua³ ca²³tó̱o̱²³ dsɨ́² dsa³ 'i³ nee'n²³² xi²ñʉ'¹ jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","'E³ jo̱³ cu²lí³ 'e³ rɨ²³gua³ ca²³tó̱o̱²³ dsɨ́² dsa³ 'i³ nee'n²³² xi²ñʉ'¹ xi³nu³ dxi³ji̱i̱n³¹ la'³. 'E³ quie'²³ 'a²³ cu²lí³ la'³ xi³nu³ 'a²³jia'³ dxi³ji̱i̱n³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Xi³nu³ xen³ dsa³ 'i³ 'a²³jia'³ rɨ²³'i'n² 'nee'²³, 'i³ 'a²³jia'³ rɨ²³núu²³ júu² quien³²na'³, jo̱³ hua² rɨ²quia'²ra'³ 'laa³ tɨɨ³¹ra'³ 'e³ la²³ rɨ²'uøøn³²na'³ xi²ñʉ'¹, 'e³ la²³ rɨ²'uøøn³²na'³ juɨɨ³ jo̱³. Qui² cu²li³lii²³ 'e³ 'a²³jia'³ dxʉ́²³ jmoo³² dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jné² rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Bi²³ cɨ² gáan³ dxíi³ quie'² dsa³ 'í³ mɨ³rɨ³dxa³ Dios ta² quiee'³² dsa³ la²³ cɨ'²³ quie'² dsa³ juɨɨ³ Sodoma quia̱'² dsa³ juɨɨ³ Gomorra. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’La²³ xen³ dsɨɨ³ joo³ 'i³ sɨ³guín²³ jee²³² quiee'³² 'ioo'³ xen³ 'nee'²³ 'e³ la²³ sɨɨn³²na²³ 'nee'²³. 'E³ jo̱³ 'ne'² rɨ²jmée²ra'³ xi²dsɨ́n³na'³ la²³ xi²dsɨ́n³ 'luu³. 'E³ quie'²³ 'ne'² rɨ²³'uǿn³na'³ 'e³ la²³ 'uǿn² to̱³ju̱³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Xi²dsɨ́n³na'³. Qui² xa³ 'e³ rɨ²³jmóo² dsa³. Qui² 'e³ cɨ² rɨ²³sø̱'n²te'²³ 'nee'²³. Rɨ²³jɨ̱ɨ̱'n³te'²³ 'nee'²³ dsa³ 'i³ dxa²³ ta². Rɨ²³jmín²te'²³ 'nee'²³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Rɨ²³sɨ²³jøn²³te'²³ 'nee'²³ xi²ñi² dxi² juɨɨ³ pii'², xi²ñi² reyes 'e³ jua'³te'²³ rɨ³løn³¹na'³ dsa³ quién²³na²³. La'³ rɨ²³lí³ 'e³ la²³ li²³xa³ 'é̱e̱² 'e³ rɨ²lʉ́²ra'³ júu² quián²³ xi²ñi² dsa³ 'i³ xa³ ta² quiee'³², xi²ñi² dsa³ jia'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mɨ³rɨ³jɨ̱ɨ̱'n³²te'²³ 'nee'²³, 'a²³ rɨ³mi³ñúun²na'³ 'óo²ra'³ 'e³ jmii'³¹ rɨ²jmee'n²³na'³ júu², 'e³ jmii'³¹ rɨ²juo'²ra'³. Qui² rɨ²³cuǿø²³ 'nee'²³ Dios la²³jɨ³ júu² 'e³ li²³'ne'² rɨ²lʉ́²ra'³ mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Qui² 'a²³la³ 'nee'²³ ca³quie̱e̱² 'i³ rɨ²lʉ́²ra'³. 'E³ quie'²³ Espíritu quien³² Ñʉ'²ra'³ 'i³ rɨ²³lʉ́²³. Te³ rɨ²³jmée²³ ta² 'oo³¹hua²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Rɨ²³jɨ̱'n² dsa³ jó̱o̱² 'e³ cu²jú̱n³. 'E³ quie'²³ rɨ²³jɨ̱'n² dsa³ jo̱o̱³¹ co̱'³. 'E³ quie'²³ la'³ rɨ²³roo'²³ xii'³ ñin³² xóo² jmii³. Rɨ²³dxi³ 'i'²³ 'e³ cu²jú̱n³ xóo² jmii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Rɨ²³lí³ 'e³ hui²³dsɨ́ɨn² la²³jɨn³ dsa³ ñin³² 'nee'²³ dsoo² 'e³ rɨ³løn³¹na'³ dsa³ quién²³na²³. 'E³ quie'²³ rɨ²³láan³ dsa³ 'i³ rɨ²³táa²³ la²³huø'n²³ 'e³ rɨ²³tɨ́²³ 'e³ rɨ²³líi². ");
INSERT INTO cnlNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mɨ³rɨ³cuøø²³te'²³ 'nee'²³ u²³ŋɨ́³ dsɨ́ɨ² co̱o̱³ juɨɨ³, rɨ²'uøøn³²na'³ cu³guín²³na'³ jia'³ cɨ'²³. Qui² rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'E³ 'íi² rɨ²dxi³cuu'n²³na'³ la²³jɨ³ juɨɨ³ quiee'³² dsa³ Israel 'e³ rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’'A²³jia'³ gáan³ cɨ² dsa³ 'i³ cɨ² sɨ³li³tɨn³ la²³ cɨ'²³ dsa³ 'e²³ quien³². 'E³ quie'²³ la'³ 'a²³jia'³ gáan³ cɨ² mozo la²³ cɨ'²³ juii². ");
INSERT INTO cnlNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³ji̱'²³ dsa³ 'e³ la²³ sɨ³ji̱'²³ dsa³ 'e²³ quien³². Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³ji̱'²³ mozo 'e³ la²³ sɨ³ji̱'²³ juii². Beelzebú jua'³te'²³ 'en³²te'²³ jné² 'i³ xen²³na²³ la²³ xen³ juii² xi²ñʉ'¹. 'E³ jo̱³ bi²³ cɨ² 'ñe'² rɨ²³lʉ́²³te'²³ rɨ²³'én²te'²³ 'nee'²³ 'i³ xen³na'³ la²³ xen³ dsa³ 'i³ te³ nee'n²³² xi²ñʉ'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’'E³ jo̱³ 'a²³jia'³ 'ne'² li²³'ñaa'n²³na'³ dsa³. Qui² 'e³ cɨ² rɨ²³dsóo²³ dsɨ́²te'²³ la²³jɨ³ 'e³ 'a²³jia'³ dsoo²³ dsɨ́²te'²³ rɨ³nɨ²³. 'E³ cɨ² rɨ²³ñí² dsa³ la²³jɨ³ 'e³ rɨ³'mo² rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","La²³jɨ³ 'e³ juøøn³²na²³ 'nee'²³ je² li³'o̱o̱³ 'ne'² rɨ²jmee'n²³na'³ júu² je² jné³. 'E³ quie'²³ la'³, la²³jɨ³ 'e³ nuu³ra'³ 'e³ lʉn²³ u²³láa² 'ne'² rɨ²lʉ́²ra'³ quiʉ̱ʉ̱³ 'e³ la²³ té̱e̱n³na'³ yʉʉ'³¹ je² bi²³ nʉ'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","'A²³jia'³ 'ne'² li²³'ñaa'n²³na'³ dsa³, 'i³ te³ sɨ³lí³ juø'² jŋɨ'n²³ 'nɨɨ'n³¹ jmɨ² ŋu² dsa³. 'E³ quie'²³ 'a²³jia'³ rɨ²³li'²³ juø'² rɨ²³jŋɨ'n²³te'²³ dsɨ́² dsa³. 'E³ quie'²³ 'ne'² li²³'ñaa'n²³na'³ Dios. Qui² 'i³ 'í³ hua² 'i³ rɨ²³li'²³ juø'² rɨ²³juén² dsa³ guiáa²³ juɨ́ɨ² 'e³ rɨ²³mi²³gua'²³ jmɨ² ŋu² dsa³ ca³ti³² quia̱'² dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿'A² 'a²³jia'³ sɨ³'nɨ́ɨn² áan²³ jo̱o̱³¹ to̱³ 'e³ co̱o̱³ cu²laa'³ pii'²? Juø'n³ quie'²³ 'a²³jia'³ quí̱i̱n²³, 'a²³jia'³ jmɨ́ɨ² rɨ²³te'n²³ 'uǿ²³ cu³xi³ jø̱n³ jo̱o̱³¹ to̱³ 'u² cu²ru'³ 'a²³jia'³ 'née²³ Ñʉ'²ra'³ 'e³ rɨ²³lí³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ñi³² 'ñée² 'e³ jo'² mɨɨ'n²³ jñʉ³ dxí²ra'³ xa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","'E³ jo̱³ 'a²³jia'³ 'ne'² rɨ²juø'n¹na'³ miin²³na'³. Qui² bi²³ cɨ² quí̱i̱n²³na'³ quie'² Dios la²³ cɨ'²³ 'e³ juɨ́ɨn²³ jo̱o̱³¹ to̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’La²³ cu²ru'³ 'e³ rɨ²³jme'n² júu² dsa³, rɨ²³sɨ'²³ uu'n² 'e³ cuiin²³ jné². 'E³ quie'²³ rɨ²jmee'n³¹na¹ júu² rɨ²juøøn³¹ Ñu'n²³ 'i³ jen³¹ yʉʉ'³¹ güii³ 'e³ cuiin²³na²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","'E³ quie'²³ la²³ cu²ru'³ rɨ²³jme'n² dsa³ júu², rɨ²³sɨ'²³ uu'n² 'e³ 'a²³jia'³ cuiin²³ jné². 'E³ quie'²³ rɨ²jmee'n³¹na¹ júu² rɨ²juøøn³¹ Ñu'n²³ 'i³ jen³¹ yʉʉ'³¹ güii³ 'e³ 'a²³jia'³ cuiin²³na²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’'A²³jia'³ 'ne'² rɨ²lǿn³na'³ 'e³ güén²³na²³ 'e³ juø'n²³ rɨ²jmeen²³² 'e³ rɨ²³lʉ́²³ co̱o̱³ júu² dsa³ mɨ³¹güii³. 'A²³la³ 'e³ jo̱³ 'e³ güén²³na²³ mɨ³¹güii³. 'E³ quie'²³ güén²³na²³ 'e³ la²³ rɨ²³lí³ qui³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Güén²³na²³ 'e³ la²³ rɨ²jmeen²³² 'e³ rɨ²³níin³ quia̱'² jmii³ jo̱o̱³¹ 'i³ dsóo²³. 'E³ quie'²³ la'³ mɨ́³ quia̱'² xóo². 'E³ quie'²³ la'³ mɨ́³ ñin³² xóo² dsóo²³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dsa³ 'i³ nee'n²³² co̱o̱³ xi²ñʉ'¹ rɨ²³lí³ 'e³ hui²³dsɨ́ɨn² ñin³² uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’'A²³jia'³ dxi³ji̱i̱n³¹ 'e³ rɨ²³lín³ dsa³ quién²³na²³ dsa³ 'i³ bi²³ cɨ² 'néen² xóo² jmii³ la²³ cɨ'²³ jné². 'E³ quie'²³ la'³ dsa³ 'i³ bi²³ cɨ² 'néen² jo̱o̱³¹ la²³ cɨ'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","'A²³jia'³ dxi³ji̱i̱n³¹ 'e³ rɨ²³lín³ dsa³ quién²³na²³ dsa³ 'i³ 'a²³jia'³ rɨ²³cuǿn²³ 'ñée² 'e³ rɨ²³dxi²³quié̱n² la²³ dxi³quié̱n² dsa³ 'i³ ta̱a̱n²³ cruz, dsa³ 'i³ 'a²³jia'³ rɨ²³ŋɨ́²³ quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Rɨ²³gua'²³ dsa³ 'i³ 'née²³ ca³quie̱e̱² 'e³ xen³ mɨ³¹güii³ la³. 'E³ quie'²³ rɨ²³ji̱i̱'²³ ca³quie̱e̱² dsa³ 'i³ rɨ²³cuǿn²³ 'ñée² 'e³ rɨ²³jú̱n³ 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’'Ii'n³² jné² dsa³ 'i³ 'ii'n³² 'nee'²³. 'E³ quie'²³ 'ii'n³² Ñu'n²³ 'i³ ca²³xíin²³ jné² dsa³ 'i³ 'ii'n³² jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Røø³ lǿ² jñiin²³ 'e³ rɨ²³'ióo²³ quia̱'² dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios la²³jɨn³ dsa³ 'i³ 'ii'n³² uu'n² 'e³ jua'³ 'ɨɨ³ júu² quiee'³² Dios. 'E³ quie'²³ la'³, røø³ lǿ² jñiin²³ 'e³ rɨ²³'ióo²³ quia̱'² dsa³ 'i³ rɨ³løn³¹ ca³dsaan³² la²³jɨn³ dsa³ 'i³ 'ii'n³² uu'n² 'e³ jua'³ rɨ³løn³¹ ca³dsaan³². ");
INSERT INTO cnlNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: La²³ cu²ru'³ xen³ dsa³ 'i³ rɨ²³cuǿø²³ jø̱n³ 'i³ pii'² quién²³na²³ juø'n³ quie'²³ co̱o̱³ vaso jmɨɨ³ güi'³. 'E³ quie'²³ jmee²³ la'³ 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³. Rɨ²³'ióo²³ jñiin²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ma²ca¹líi¹ ca²³'é³ Jesús 'e³ ca²³'ée²³ la²³jɨn³ gui²³tʉ̱́n³ dsa³ quien³², ŋóo² co̱'³. 'Í² jee²³² juɨɨ³ la²³ca̱a̱n³ je² mɨ³lén². Ca²³'ée²³ dsa³. Ca²³'ɨ́ɨ³ júu² jia'³ cɨ'²³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","La²³ca̱a̱n³ mɨ²jo̱³ 'iún² i²³ñí² Juan. Ca²³núu³ 'e³ jmii'³¹ jmee²³ Jesús. 'E³ jo̱³ ca²³xíin²³ áan²³ dsa³ quien³² 'e³ jua'³ 'née²³ 'e³ rɨ²³ŋɨ́n²te'²³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―¿'A² 'nʉ³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios? ¿'A² jia'³ cɨ'²³ 'i³ 'ne'² rɨ²je̱n²³²na²? ");
INSERT INTO cnlNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","'E³ jo̱³ ca²³jua'³ Jesús: ―Cu³xii'²ra'³ Juan la²³jɨ³ 'e³ nuu³ra'³, la²³jɨ³ 'e³ joo³²ra'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Sɨ³li³jnee²³ dsa³ tuu² mɨ²ñi². Ŋɨ́³ dsa³ 'i³ 'uaa'³ tɨɨ². Sɨ³jñin³ la³'e² dsa³ 'i³ ta̱a̱n²³ goo³. Sɨ³né³ lo³guo² dsa³ guɨɨ²³². Sɨ³ji̱i̱'²³ co̱'³ 'lɨ́ɨ³. 'Ɨɨ³te'²³ júu² dxʉ́²³ quie'² dsa³ taan³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bi²³ dxʉ́²³ quie'² dsa³ 'i³ 'a²³jia'³ rɨ²³yáan²³ dsɨ́² quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ca²³guiin³² co̱'³ dsa³ quien³² Juan. 'E³ quie'²³ jo̱³ ca²³lʉ́³ Jesús. Ca²³sɨ'²³ la²³jɨn³ dsa³. Ca²³'én² Juan. Ca²³jua'³: ―¿'Ee² 'noo³¹ ca²³lǿn³na'³ 'e³ cu³jóo²ra'³ 'e³ la²³ i²guín¹na'³ je² 'a²³jia'³ nee'n²³² dsa³? 'A²³la³ jo̱³ 'mo³ ta³ 'e³ bɨ³² je² ro̱o̱²³ dxí³, ¿mɨ³naa'³¹? Qui² 'a²³la³ la'³ cu³løn³¹ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿'Ee² lǿ² i²guín¹na'³ jo̱o̱²³na²³? 'A²³la³ jo̱³ 'e³ i²joon²³na'³ dsa³ 'i³ quii'³ 'mɨɨ'³ 'e³ bi²³ dxʉ́²³, ¿mɨ³naa'³¹? Qui² 'ñʉ² rey nee'n²³² dsa³ 'i³ quii'³ 'mɨɨ'³ 'e³ bi²³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿'Ee² 'noo³¹ ca²³lǿn³na'³ 'e³ cu³jóo²ra'³ jo̱o̱²³na²³? ¿'A² ca²³lǿn³na'³ 'e³ cu³jóon²³na'³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios? 'I³ 'í³ xú̱n³. 'E³ quie'²³ 'a²³la³ 'nɨɨ'n³¹ 'e³ te³ rɨ³løn³¹ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. Qui² gáan³ cɨ² Juan la²³ cɨ'²³ la²³jɨn³ jia'³ cɨ'²³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Qui² 'i³ 'í³ hua² 'i³ 'en³² júu² quiee'³² Dios je² to̱o̱²³ ji³ je² jua'³: Rɨ²sɨɨn³¹na¹ dsa³ xiin²³ quién²³na²³ 'i³ rɨ²³ŋɨ́n³ jén²³ cɨ² la²³ 'nʉ³. Rɨ²³jmée²³ dxʉ́²³ jui³¹ je² rɨ²³ŋɨ́n³nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³'i̱³ xen³ dsa³ 'i³ lɨ'³ ca³la³xen³ 'i³ gáan³ cɨ² la²³ Juan 'i³ xaan³² dsa³ jmɨɨ³. 'E³ quie'²³ gáan³ cɨ² la²³ Juan dsa³ 'i³ mɨ³lǿn²³ Dios juii², juø'n³ quie'²³ 'i³ pii'² cɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Cɨ'²³ la²³ 'e³ ca²³la²³láa²³ 'e³ 'ɨɨ³ júu² Juan 'i³ xaan³² dsa³ jmɨɨ³ xi³'lɨ² mɨ³tɨ́³ la²³'nɨɨ'n³¹ la³, ja³guín²³ dsa³ sɨ³baa'n²³ sɨ³jnaa'n²³ la²³ cɨ² la²³'nɨɨ'n³¹ 'e³ 'née²³ 'e³ rɨ²³lín³ Dios juii²te'¹. 'E³ quie'²³ bi²³ ca²³la²³'née²³ quie'² dsa³ la²³jɨ³ ju²³bíi²³ 'e³ rɨ²³lín³ Dios juii². ");
INSERT INTO cnlNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","'Íi² quie'²³ rɨ²³güén³ Juan, ca²³lʉ́³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² quia̱'² ley 'e³ ca²³ŋɨ́n² Moisés. Ca²³jmée³ júu² 'e³ jmii'³¹ rɨ²³lí³ cɨ̱ɨ̱n³ cɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³güén³ dsa³ 'i³ xen³ la²³ xen³ Elías. 'E³ quie'²³ Juan hua² 'í³. 'Ne'² rɨ²³sɨ²³táan³na'³ la'³ jo̱o̱²³na²³ xi³nu³ dxʉ́²³ 'óo²ra'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","'Ne'² rɨ²³núu²³ dsa³ 'i³ 'née²³ rɨ²³cuǿn²³ miin²³ 'e³ rɨ²³núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Jmii'³¹ cu³lø³¹ rɨ²juø'n³¹ 'e³ la²³ lǿn²³ dsa³ 'i³ xen³ rɨ³nɨ²³? Xen³te'²³ la²³ xen³ xii'³ pii'² 'i³ nee'n²³² je² dxa²³ dsa³ 'moo'². Yoo'²³ tø³²te'²³. Sɨ'²³ uu'n²te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mɨ³jiʉʉ²³²ra'³¹ 'mo³ ta³. 'E³ quie'²³ 'a²³jia'³ ca³dxén²na'³. Mɨ³'e²ra'³¹ 'e³ la²³ 'e²³ dsa³ je² xen³ 'lɨ́ɨ³. 'E³ quie'²³ 'a²³jia'³ ca³'o'²ra'³. 'E³ quie'²³ 'a²³'e³ xa³ 'noo³ra'³ sú̱n².” ");
INSERT INTO cnlNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","La'³ xen³ dsa³ 'i³ xen³ rɨ³nɨ²³. Qui² 'a²³jia'³ 'ɨ̱ɨ̱'³² ee'³² Juan. 'E³ jo̱³ ca²³jua'³ dsa³: “Quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'²”. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jné² Jo̱o̱³¹ Dsa³ uu'n²³ ee'n²³. 'E³ jo̱³ jua'³ dsa³: “Jóo². Jmii'³¹ 'nɨɨ'n³¹ 'ɨ̱ɨ̱'³² ee'³². Bi²³ dxʉ́²³ lʉ²³ quia̱'² 'io'² quia̱'² dsa³ tu³cua̱a̱n²tu².” 'E³ quie'²³ xen³ dsa³ 'i³ nuu³ júu² quiee'³² Dios 'e³ jmii'³¹ 'ne'² rɨ²³jmóo². 'E³ la²³ jmoo³²te'²³ 'e³ dxʉ́²³, sɨ³li³lii²³ 'e³ dxʉ́²³ júu² 'e³ nuu³te'²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","'E³ jo̱³ ca²³lʉ́³ Jesús. Ca²³'én² dsa³ 'i³ nee'n²³² la²³jɨ³ juɨɨ³ je² bi²³ ñúun³ u²³juø'²³ ca²³jmée³. Ca²³jua'³ 'e³ 'a²³jia'³ dxʉ́²³ jmoo³². Qui² 'a²³jia'³ ca²³tʉ́² 'e³ jmoo³² la²³jɨ³ 'e³ 'a²³jia'³ dxʉ́²³, juø'n³ quie'²³ ca²³jóo²te'²³ u²³juø'²³. Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Bi²³ juɨɨ³² 'nee'²³, dsa³ juɨɨ³ Corazín. Bi²³ juɨɨ³² 'nee'²³, dsa³ juɨɨ³ Betsaida. Qui² 'a²³jia'³ mi³quí̱i̱n²³na'³ la²³jɨ³ u²³juø'²³ 'e³ jmeen²³. Ca²³tʉ́² 'e³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³ dsa³ juɨɨ³ Tiro quia̱'² dsa³ juɨɨ³ Sidón 'u² cu²ru'³ ca²³lǿ²³ u²³juø'²³ juɨɨ³ quiee'³²te'²³ 'e³ la²³ lǿ² ca²³jméen²³ juɨɨ³ quien³²na'³. Cɨ'²³te'²³ 'mɨɨ'³ 'e³ quii'³ dsa³ 'i³ 'aa³ u²³ŋɨ́³ dsɨ́ɨ² 'u² cu²ru'³ la'³. Ca²³'li'²³te'²³ juo³ mɨ²dxi²te'¹ 'e³ jua'³ jmoo³² lii²³ 'e³ ŋɨ́³ dsɨ́²te'²³ 'u² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","'E³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³: Bi²³ cɨ² gáan³ dxíi³ rɨ²³jí̱i̱n² 'nee'²³ mɨ³rɨ³dxa³ Dios ta² quiee'³² dsa³ la²³ cɨ'²³ dsa³ juɨɨ³ Tiro quia̱'² dsa³ juɨɨ³ Sidón. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Rɨ²juøøn³¹na¹ 'nee'²³, dsa³ juɨɨ³ Capernaum: ¿'A² lǿn³na'³ 'e³ rɨ²³tøø³te'²³ 'nee'²³ yʉʉ'³¹ güii³? 'A²³jia'³ jmɨ́ɨ², ¿mɨ³naa'³¹? 'E³ quie'²³ rɨ²³cu²³dxe'n³te'²³ 'nee'²³ je² nee'²³² dsɨ́² dsa³ 'i³ 'a²³jia'³ ca³jmóo² ca³dsaan³². Née² quie'²³ juɨɨ³ Sodoma xi³'lɨ² jmɨ́ɨ² rɨ³nɨ²³ 'u² cu²ru'³ ca²³lǿ²³ je² núu²³ u²³juø'²³ 'e³ la²³ lǿ² 'e³ jmeen²³ jee²³² quien³²na'³. Qui² ca²³tʉ́²te'²³ 'e³ ca²³jmóo²te'²³ 'e³ 'a²³jia'³ dxʉ́²³ 'u² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","'E³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³: Bi²³ cɨ² gáan³ dxíi³ rɨ²³jí̱i̱n² 'nee'²³ la²³ cɨ'²³ dsa³ juɨɨ³ Sodoma mɨ³rɨ³dxa³ Dios ta² quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mɨ²jo̱³ ca²³jua'³ Jesús: ―Mɨ²'áan²nu³, Ñu'n², juii² yʉʉ'³¹ güii³ quia̱'² juii² mɨ³¹güii³ la³. Qui² 'a²³jia'³ ca²³cuǿn² júu² 'e³ li²³ta²³jmoo³² 'i'²³ 'e³ jmii'³¹ lǿ² u²³juø'²³ 'e³ jmeen²³ dsa³ 'i³ bi²³ dsoo²³ dsɨ́² quia̱'² dsa³ 'i³ bi²³ tɨn³. 'E³ quie'²³ ca²³cuǿn² júu² 'e³ ta³jmoo³² 'i'²³ dsa³ 'i³ xen³ la²³ xen³ xi³yu̱u̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Qui² la'³ cu³lø³¹ 'e³ 'naan³ 'uǿøn²nu³ 'e³ rɨ²³lí³, Ñu'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Ñu'n²³ ca²³dxá³ guaan²³ 'e³ rɨ²jmeen²³² cua̱a̱n²tu² la²³jɨ³. Jø̱n³ Ñu'n²³ 'i³ cuiin²³ Jo̱o̱³¹. 'A²³'i̱³ xen³ jia'³ cɨ'²³. 'E³ quie'²³ la'³, cuiin²³na²³ Ñu'n²³ jø̱n³ jné² 'i³ rɨ³løn³¹na¹ Jo̱o̱³¹ quia̱'n²³²na¹ te³ 'i̱i̱² sɨɨ'³¹ 'i³ 'náan²³ rɨ²jmeen²³² 'e³ li²³cuiin²³ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ñe³ra'³ quia̱'n²na'³ jné², la²³jɨn³ 'nee'²³ 'i³ dxi³quié̱n²na'³ la²³'nɨɨ'n³¹ 'e³ jmee³ra'³ ta². 'E³ quie'²³ ñe³ra'³ quia̱'n²na'³ jné², la²³jɨn³ 'nee'²³ 'i³ quie̱³ láa² 'e³ bi²³ 'ii³ 'e³ quie̱e̱n³²te'²³ 'nee'²³. Jo̱³ hua² rɨ²jmeen²³² 'e³ rɨ²tøø³¹ra'³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Rɨ²³lín³na'³ dsa³ quién²³na²³. Rɨ²jmée²ra'³ ta² quia̱'n²na'³ jné² 'e³ la²³ jmee²³ cua² 'ioo'³ 'i³ 'uøn³² 'uǿ²³. Jo̱³ hua² li²³tɨn³na'³ 'e³ la²³ 'een²³na²³ 'nee'²³. Qui² bi²³ 'uøn²³²na¹ jme'n²³na²³ dsa³. Mi³'uǿn²³na²³ 'ñáan²³. Qui² 'náan²³ 'e³ rɨ²³liin²³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","'A²³jia'³ jmɨ́ɨ² jmeen²³ 'e³ gáan³ dxíi³ quie'² dsa³ quién²³na²³. 'A²³jia'³ 'ii³ láa² 'e³ quié̱e̱n²³na²³ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mɨ²jo̱³ ca²³ŋɨ́n³ Jesús je² rɨ³dsɨ³² trigo jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. Ca²³la²³cue̱'²³ te'²³ dsa³ quien³². 'E³ jo̱³ su̱'²te'²³ mɨ³¹maa'n³ trigo. Ca²³cuu'³te'²³ mɨɨ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ŋó²³ te'²³ dsa³ fariseo 'e³ jmii'³¹ jmoo³². 'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Jóo² jmii'³¹ jmoo³² dsa³ quien³²nu³. 'A²³jia'³ joo'²³ rɨ²jmee²ra² la²³nɨ³. Qui² jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ fariseo: ―¿'A² 'a²³jia'³ lɨ'³ ca³jóo²ra'³ ji³ je² to̱o̱²³ 'e³ jmii'³¹ ca²³jmée³ David mɨ²jaa²³² ma²ca¹la¹cue̱'¹ ca³ti³² quia̱'² te'²³ dsa³ 'i³ quia̱'²? ");
INSERT INTO cnlNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","'Í² ñʉ'²³ 'ñʉ́² je² mi³gáan³te'²³ Dios. 'E³ quie'²³ jo̱³ ca²³e'² 'ɨ²³juɨ² 'mɨ'n²³ 'e³ ca²³cuǿø²³te'²³ Dios, juø'n³ quie'²³ 'a²³jia'³ joo'²³ 'e³ rɨ²³e'². Cu³xi³ dsa³ 'i³ quia̱'² 'a²³jia'³ joo'²³ 'e³ rɨ²³e'². 'Nɨɨ'n³¹ te'²³ jmii³ dsa³ 'i³ joo'²³ rɨ²³e'² 'ɨ²³juɨ² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿'A² 'a²³jia'³ lɨ'³ ca³jóo²ra'³ ji³ je² to̱o̱²³ ley 'e³ ca²³ŋɨ́n² Moisés 'e³ la²³ lǿ² 'e³ jmoo³² jmii³ dsa³? Jmoo³²te'²³ ta² quiee'³²te'²³ ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³te'²³ Dios, juø'n³ quie'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. Jmoo³²te'²³ la²³jɨ³ ta² 'e³ 'a²³jia'³ joo'²³ rɨ²³jmóo² dsa³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. 'E³ quie'²³ 'a²³jia'³ sɨ³li³xa³ dsoo² quiee'³²te'²³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Rɨ²juøøn³¹na¹ 'nee'²³ 'e³ gáan³ cɨ² la²³ 'ñʉ́² gáan³ 'e³ xa³ jee²³² quien³²na'³ rɨ³nɨ²³ 'e³ la²³ jen³¹na¹ quia̱'n²³²na¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","To̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: “'A²³la³ jo̱³ 'e³ te³ bi²³ xen³ 'i³ jŋɨ'n²³te'²³ 'e³ jua'³ cuøn²³te'²³ jné² 'e³ 'náan²³ jné². 'E³ quie'²³ 'náan²³ 'e³ li²³cuu'²³ dsɨ́² dsa³ ñin³² uu'n².” 'U² cu²ru'³ ca²³jmée²ra'³ 'i'²³ 'e³ jua'³ Dios 'e³ 'née²³ 'e³ li²³cuu'²³ dsɨ́² dsa³ ñin³² uu'n², 'a²³jia'³ cuø³ra'³ dsoo² quiee'³² dsa³ 'i³ 'a²³'e³ xa³ 'e³ ca²³jmóo² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Qui² jné² Jo̱o̱³¹ Dsa³ rɨ³løn³¹na¹ juii² jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ŋóo² co̱'³ Jesús. 'Í² ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","'Iún² je² núu²³ jø̱n³ dsa³ 'i³ 'uaa'³ co̱o̱³ guoo³. 'E³ jo̱³ ca²³tín²³te'²³ júu². Ca²³sɨ'²³te'²³ Jesús: ―¿'A² joo'²³ rɨ²mi³'láan²na² dsa³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³, lǿn³nu³? Ca²³jua'³te'²³ la'³ 'e³ jua'³ 'née²³te'²³ 'e³ rɨ²³cuǿ²³te'²³ dsoo² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³: ―¿Jmii'³¹ cu²ru'³ xen³ jø̱n³ 'nee'²³ 'i³ jø̱n³ qui³ dsɨɨ³ joo³ xen³ quie'²? 'E³ quie'²³ rɨ²³te'n²³ dsɨɨ³ joo³ 'í³ 'e̱'³ too³ bee'² jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. Rɨ²jmø'n¹na'³ dsɨɨ³ joo³. Rɨ²dxin²³na'³ 'e̱'³ too³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Bi²³ cɨ² ma²³'nee³ quí̱i̱n²³ dsa³ la²³ cɨ'²³ jø̱n³ dsɨɨ³ joo³, ¿mɨ³naa'³¹? 'E³ jo̱³ joo'²³ rɨ²jmee²ra² 'e³ dxʉ́²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ 'uaa'³ guoo³: ―'Íi³ guaan³². 'E³ jo̱³ ca²³'ɨ́ɨ³ guoo³ dsa³ 'í³. 'E³ quie'²³ jo̱³ lɨ́ɨn² guoo³. Ca²³la²³røø³ lǿ² ca³ti³² guoo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","'E³ jo̱³ ca²³'uǿøn² te'²³ dsa³ fariseo. Ca²³sɨ́n²³te'²³ júu² 'e³ jmii'³¹ li²³tɨ́ɨ²³ rɨ²³jŋɨ'n²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ñi³² Jesús 'e³ jmii'³¹ cu³lø³¹ júu² 'e³ sɨn²³ te'²³ dsa³ fariseo. 'E³ jo̱³ ŋóo² jia'³ cɨ'²³ to̱o̱²³. Juɨ́ɨn²³ dsa³ 'i³ ca²³qui̱i̱³ Jesús. 'E³ jo̱³ ca²³mi²³'láan³ la²³jɨn³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","'E³ quie'²³ ca²³dxi³ 'i'²³ 'e³ 'a²³jia'³ 'ne'² rɨ²³sɨ'²³ uu'n²te'²³ 'e³ 'i̱i̱² sɨɨ'³¹ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ŋóo² co̱'³ Jesús 'e³ la²³ rɨ²³lí³ 'e³ la²³ ca²³jua'³ Isaías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² ma²ca¹jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","'I³ la³ mozo quién²³na²³ 'i³ ca²³'náan²³na²³. Bi²³ 'náan²³na²³ 'ñée². Bi²³ jmee²³ 'e³ jɨn³ dsɨn²³. Rɨ²jmeen²³² 'e³ rɨ²³cǿ̱n² Espíritu Gáan³ quién²³na²³. Rɨ²³ji̱i̱n³ júu² jee²³² quiee'³² dsa³ jia'³ 'e³ cɨ² rɨ²³tɨ́²³ rɨ²dxen²³² ta² quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","'A²³jia'³ rɨ²³'nóo²³ júu². 'A²³jia'³ rɨ²³yo'²³ rɨ²³tǿ². 'A²³'i̱³ xen³ 'i³ rɨ²³núu²³ 'e³ la²³ lʉ²³ jee²³² calles. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Rɨ²³jmée²³ 'e³ 'uǿn². Rɨ²³jmée²³ co̱²juø'¹ quie'² dsa³ 'i³ mɨ³'uaa'n²³ dsɨ́², dsa³ 'i³ xen³ la²³ xen³ 'mo³ ta³ 'e³ mɨ³ rɨ²³cɨ'²³, dsa³ 'i³ xen³ la²³ xen³ ji³ 'e³ mɨ³ rɨ²³yʉʉ³. Rɨ²³jmée²³ quie'²³ ta² la²³huøø'n³¹ la²³ 'e³ 'íi² rɨ²³jmóo² dsa³ ca³dsaan³². ");
INSERT INTO cnlNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","'I³ 'í³ hua² 'i³ li²³xa̱a̱'n³ dsɨ́² dsa³ jia'³. La'³ cu³lø³¹ ca²³jua'³ Isaías mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","'E³ jo̱³ i²jøn²³te'²³ caan²³ Jesús jø̱n³ dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². Tuu² mɨ²ñi² dsa³ 'í³. Co̱'³ cɨ'²³ caan²³². 'E³ jo̱³ ca²³mi²³'láan³ dsa³ 'í³ Jesús. 'E³ quie'²³ jo̱³ ca²³lʉ́³ dsa³ 'í³. Ca²³la²³jnée²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bi²³ juø'²³ ca²³ti²³cø̱n³¹ la²³jɨn³ dsa³. Ca²³jua'³te'²³: ―¿'A² juø'² dsa³ ju̱u̱n²³ David 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios dsa³ la³ cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","'E³ quie'²³ ma²ca¹núu³ te'²³ dsa³ fariseo 'e³ la'³ ca²³jua'³ dsa³, jo̱³ ca²³jua'³ miin²³: ―Ju²³bíi²³ quiee'³² Beelzebú, juii² espíritus quien³² mɨ²³sɨ²³quiʉ'² quie̱³ dsa³ nɨ³. 'E³ jo̱³ hua² sɨ³lí³ juø'² 'uøøn³ espíritus quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","'E³ quie'²³ ñi³² Jesús 'e³ jmii'³¹ cu³lø³¹ lǿn³te'²³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ te'²³ dsa³ fariseo: ―Rɨ²³yáan²³ la²³'nɨɨ'n³¹ je² røøn³ jø̱n³ rey xi³nu³ rɨ²³juín² dsa³ júu² quiee'³²te'²³, ¿mɨ³naa'³¹? 'E³ quie'²³ la'³ 'a²³jia'³ rɨ²³táa²³ co̱o̱³ juɨɨ³ xi³nu³ rɨ²³juín² júu² quiee'³² dsa³ co̱'³. 'E³ quie'²³ la'³ 'a²³jia'³ rɨ²³táa²³ co̱o̱³ sɨ́ɨn² dsa³ xi³nu³ rɨ²³juín² dsa³ júu² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","'E³ quie'²³ la'³ cu³lø³¹ quie'² Satanás co̱'³. Mɨ³juín² júu² quiee'³² 'u² cu²ru'³ júu² quiee'³² 'ñée² 'e³ sɨ³'uǿøn² espíritus quien³². 'E³ jo̱³ rɨ²³gua'²³ júu² 'uee'n³ quiee'³² 'u² cu²ru'³ la'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Juo'³ra'³ 'e³ cuø²³ ju²³bíi²³ Beelzebú 'e³ sɨ³lí³ juø'² 'uøøn²³²na¹ espíritus quien³² mɨ²³sɨ²³quiʉ'². ¿'E³ quie'²³ 'i̱i̱² sɨɨ'³¹ 'i³ cuø²³ ju²³bíi²³ 'e³ 'uøøn³ espíritus quien³² mɨ²³sɨ²³quiʉ'² te'²³ dsa³ uu'n²na'³ jo̱o̱²³? 'E³ jo̱³ miin²³ dsa³ uu'n²na'³ jmoo³² lii²³ 'e³ 'a²³jia'³ 'e̱'n³ júu² 'e³ lʉ́²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Espíritu Gáan³ quien³² Dios 'i³ cuøø²³ jné² ju²³bíi²³ 'e³ 'uøøn²³²na¹ espíritus quien³² mɨ²³sɨ²³quiʉ'². 'E³ jo̱³ mɨ³la³lii²³ 'e³ mɨ³tɨ́³ 'e³ rɨ³løn³¹ Dios juii² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Jmii'³¹ rɨ²³lí³ juø'² rɨ²³'í³ tu³cua̱a̱n²tu² jø̱n³ dsa³ xi²ñʉ'¹ je² jen³¹ jø̱n³ dsa³ 'i³ bi²³ 'uee'n³ 'e³ jua'³ rɨ²³'í̱i̱²³ la²³jɨ³ 'e³ xa³ quie'²? Xe̱'n² cɨ² 'ne'² rɨ²³'ñúun²³ dsa³ 'i³ 'uee'n³, ¿mɨ³naa'³¹? Jo̱³ hua² rɨ²³lí³ juø'² rɨ²³'í̱i̱²³ la²³jɨ³ 'e³ taa'² xi²ñʉ'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Hui²³dsɨ́ɨn² quia̱'² jné² dsa³ 'i³ 'a²³jia'³ rɨ³løn³¹ co̱o̱³ júu² quia̱'² jné². Dsa³ 'i³ 'a²³jia'³ jmee²³ ta² 'e³ sɨ³cu'n²³ dsa³ quia̱'² jné² jmee²³ 'e³ sɨ³sáan²³ sɨ³jǿn²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’'E³ jo̱³ rɨ²juøøn³¹na¹ 'nee'²³: Sɨ³lí³ juø'² sɨ³yʉʉ³ dsoo² quiee'³² dsa³ te³ jmii'³¹ lǿ². Sɨ³lí³ juø'² sɨ³yʉʉ³ dsoo² 'e³ bi²³ 'ñe'² lʉ²³ dsa³. 'E³ quie'²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³yʉʉ³ dsoo² 'e³ bi²³ 'ñe'² lʉ²³ dsa³ 'en³² Espíritu Gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sɨ³lí³ juø'² sɨ³yʉʉ³ dsoo² 'e³ lʉ²³ dsa³ 'e³ 'a²³jia'³ dxʉ́²³ 'en³² jné² Jo̱o̱³¹ Dsa³. 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³ dsoo² 'e³ lʉ²³ dsa³ 'e³ 'a²³jia'³ dxʉ́²³ 'e³ 'en³²te'²³ Espíritu Gáan³. 'A²³jia'³ rɨ²³yʉʉ³ dsoo², juø'n³ quie'²³ rɨ³nɨ²³, juø'n³ quie'²³ jmɨ́ɨ² 'e³ ja³guín²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Xi³nu³ dxʉ́²³ 'mo³, 'e³ jo̱³ dxʉ́²³ mɨɨ³¹ 'e³ 'ɨɨ³, ¿mɨ³naa'³¹? Xi³nu³ 'a²³jia'³ dxʉ́²³ 'mo³, 'e³ jo̱³ 'a²³jia'³ dxʉ́²³ mɨɨ³¹ 'e³ 'ɨɨ³, ¿mɨ³naa'³¹? Qui² mɨɨ³¹ 'e³ 'ɨɨ³ jmee²³ lii²³ 'e³ 'ee² 'mo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ca²³jua'³ co̱'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ fariseo: ―'É̱e̱² ju̱u̱n²³ 'luu³ 'nee'²³. Bi²³ 'a²³jia'³ dxún²³na'³. 'E³ jo̱³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²lʉ́²ra'³ 'e³ dxʉ́²³. Qui² la²³jɨ³ 'e³ née² dsɨ́² dsa³ sɨ³li³lii²³ mɨ³rɨ³lʉ³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dxʉ́²³ lʉ²³ dsa³ 'i³ dxún²³. Qui² ñúun³ la²³jɨ³ 'e³ dxʉ́²³ 'e³ nee'²³² dsɨ́². 'E³ quie'²³ 'a²³jia'³ dxʉ́²³ lʉ²³ dsa³ 'i³ 'a²³jia'³ dxún²³. Qui² ñúun³ la²³jɨ³ 'e³ 'a²³jia'³ dxʉ́²³ 'e³ nee'²³² dsɨ́². ");
INSERT INTO cnlNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jné² rɨ²juøøn³¹na¹ 'nee'²³: 'Ne'² 'e³ rɨ²³bǿn³ cua̱a̱n²tu² mɨ³rɨ³ti³ 'e³ rɨ²³dxá²³ Dios ta² quiee'³² dsa³. 'Ne'² rɨ²³jmée²³ dsa³ júu² 'e³ 'ee² lǿ² ca²³lʉ́³ la²³jɨ³ júu² 'e³ 'a²³jia'³ 'nee'³¹ 'e³ ca²³lʉ́³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mɨ³rɨ³ti³ 'e³ rɨ²³jmée²³ 'i'²³ Dios xi² xa³ dsoo² quiee'³² dsa³, rɨ²³jmée²³ 'i'²³ 'e³ jmii'³¹ lǿ² júu² 'e³ ca²³lʉ́³ dsa³, juø'n³ quie'²³ rɨ²³'ien³ júu² 'e³ xa³ dsoo², juø'n³ quie'²³ rɨ²³'ien³ júu² 'e³ 'a²³'e³ dsoo² xa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","'E³ quie'²³ xen³ dsa³ 'e²³ ley quia̱'² dsa³ fariseo 'i³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³. 'Nee³ra'³¹ 'e³ rɨ²jméen² u²³juø'²³ 'e³ rɨ²joo²³²ra'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","'E³ quie'²³ ca²³jua'³ Jesús: ―'Née²³ rɨ²³jóo² u²³juø'²³ dsa³ 'i³ 'a²³jia'³ dxún²³, dsa³ 'i³ 'a²³la³ 'e³ co̱o̱³ dsɨ́² 'e³ 'néen² Dios. 'E³ quie'²³ co̱o̱³ qui³ u²³juø'²³ rɨ²joo³¹ra'³. Rɨ²joo³¹ra'³ u²³juø'²³ uu'n² 'e³ la²³ ca²³ji̱'²³ Jonás 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Qui² 'nɨ³ jmɨ́ɨ² 'nɨ³ 'uøø²³ ñíin² Jonás ñʉ'²³ tu'² roo'³² 'i³ xen³ 'e̱'³ jmɨ²³ñii'³¹ mɨ²jo̱³. 'E³ quie'²³ la'³, 'nɨ³ jmɨ́ɨ² 'nɨ³ 'uøø²³ ñiin²³ ñʉ'²³ 'uǿ²³ jné² Jo̱o̱³¹ Dsa³ mɨ³rɨ³ti³ jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","'E³ cɨ² rɨ²³naa'n²³ te'²³ dsa³ 'i³ xen³ juɨɨ³ Nínive mɨ²jaa²³² mɨ³rɨ³dxa³ Dios ta² quiee'³² dsa³. Rɨ²³jmóo² lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ xa³ dsoo² quiee'³² dsa³ 'i³ xen³ rɨ³nɨ²³. Qui² ca²³tʉ́² miin²³ 'e³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³ ma²ca¹'ɨ́ɨ³ júu² Jonás. 'E³ quie'²³ gáan³ cɨ² la²³ Jonás 'e³ xa³ jee²³² quien³²na'³ rɨ³nɨ²³ 'e³ la²³ jen³¹na¹ quia̱'n²³²na¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","'E³ quie'²³ la'³, rɨ²³naa'n²³ mɨ́³ dxi² juɨɨ³ 'i³ røøn³ mɨ²jo̱³ juɨɨ³ 'e³ sɨ³cuaa'n²³ la²³ i²'uøø³² mɨ³rɨ³dxa³ Dios ta² quiee'³² dsa³. Rɨ²³jmée²³ lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ xa³ dsoo² quiee'³² dsa³ 'i³ xen³ rɨ³nɨ²³. Qui² naan³ 'ñée² mɨ́³ je² huɨ̱́ɨ̱³. Ca²³dxóo² je² jen³¹ rey Salomón 'e³ jua'³ 'née²³ rɨ²³núu²³ júu² 'e³ lʉ²³. Qui² bi²³ ta³jmee²³ 'i'²³ Salomón. 'E³ quie'²³ gáan³ cɨ² la²³ Salomón 'e³ xa³ jee²³² quien³²na'³ rɨ³nɨ²³ 'e³ la²³ jen³¹na¹ quia̱'n²³²na¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Mɨ³rɨ³bǿn³ jø̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'² 'i³ 'iún² dsɨ́² dsa³, ŋɨ́³ la²³ca̱a̱n³ je² bi²³ 'a²³'e³ xa³ jmɨɨ³. 'No'²³ je² rɨ²³gua³. 'E³ quie'²³ 'a²³jia'³ rɨ²³dxoo'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","'E³ jo̱³ jua'³ 'ñée²: “Ñe'n³²na²³ co̱'³ je² ca²³bǿn³na²³ ca³dxa³”. 'E³ quie'²³ jo̱³ dsø'n³² co̱'³. Qui² rɨ³güii²³ dsɨ́² dsa³ je² rɨ³lø³¹ 'é̱e̱² xi²ñʉ'¹ je² ca²³bǿn³. Ca²³'io'³te'²³. Bi²³ dxʉ́²³ ta'² née² la²³jɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","'E³ jo̱³ dsoo³² sɨ³tee³ guiáan²³ cɨ² uu'n² 'i³ bi²³ cɨ² 'a²³jia'³ dxún²³ la²³ cɨ'²³ 'ñée². 'E³ jo̱³ sɨ³ta'n²³ dsɨ́² dsa³ 'í³ la²³jɨn³te'²³. Núu²³ rɨ²³gua³te'²³. 'E³ jo̱³ bi²³ cɨ² la³dsɨɨ³² dsa³ 'í³ mɨ³rɨ³ta'n²³ 'i³ juɨ́ɨn²³ cɨ² la²³ cɨ'²³ ma²'ii³¹ rɨ²³bǿn³ jø̱n³ 'i³ 'iún² xe̱'n². 'E³ quie'²³ la²³nɨ³ cu³lø³¹ rɨ²³ji̱'²³ dsa³ 'i³ xen³ rɨ³nɨ²³, 'i³ 'é̱e̱² 'e³ rɨ³güii²³ xi²ñʉ'¹ quiee'³². Qui² 'a²³jia'³ rɨ²³cuǿ²³ júu² 'e³ rɨ²'ín³na²³ xi²ñʉ'¹ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","'E³ la²³ lʉ²³ quie'²³ la'³ Jesús, ca²³dxóo² xóo² quia̱'² te'²³ jó̱o̱². Ca²³noo³te'²³ xi²dxi³². Ca²³jua'³te'²³ 'e³ 'née²³te'²³ rɨ²³lʉ́²³te'²³ quia̱'²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","'E³ jo̱³ xen³ dsa³ 'i³ ca²³sɨ'²³ Jesús: ―Xi'n²³ xi²dxi³² xaan³ quia̱'² já̱a̱n², ¿mɨ³naa'³¹? Jua'³te'²³ 'e³ 'née²³te'²³ rɨ²³lʉ́²³te'²³ quia̱'²te'²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'i³ ca²³jua'³ la'³: ―¿'I̱i̱² sɨɨ'³¹ xen²³? ¿'I̱i̱² sɨɨ'³¹ ja̱a̱n³²? ");
INSERT INTO cnlNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","'E³ jo̱³ ca²³'ɨ́ɨ³ guoo³, ca²³'én² dsa³ quien³². Ca²³jua'³: ―'I³ la³ xen²³. 'I³ la³ ja̱a̱n³². ");
INSERT INTO cnlNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Qui² rɨ³løn³¹ ja̱a̱n³², rɨ³løn³¹ xen²³ dsa³ 'i³ jmoo³² 'e³ la²³ 'née²³ Ñu'n²³ 'i³ jen³¹ yʉʉ'³¹ güii³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","'E³ quie'²³ jmɨ́ɨ² jo̱³ ca²³bǿn³ Jesús xi²ñʉ'¹. 'E³ jo̱³ ŋóo² i²gua³ co̱³² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³ŋɨɨ'n²³ caan²³ Jesús. 'E³ jo̱³ 'í² Jesús 'e̱'³ móo². Ca²³gua³ jo̱o̱²³na²³. 'E³ quie'²³ té̱e̱n³ quie'²³ dsa³ co̱³² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ñúun³ la²³jɨ³ 'e³ ca²³lʉ́³ Jesús, ca²³sɨ'²³ dsa³. Ca²³lʉ́³ júu² rɨ³jnɨ³. Ca²³jua'³: ―La²³la³ cu³lø³¹ ca²³jmée³ jø̱n³ dsa³ 'i³ ca²³juá² mɨ³¹ju̱³. Ŋóo² ca²³juá² mɨ³¹ju̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","'E³ la²³ ca²³juá² mɨ³¹ju̱³, xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² coo³¹ jui³¹. 'E³ quie'²³ ca²³dxi²³guín²³ to̱³ 'i³ ca²³e'² mɨ³¹ju̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² jee²³² guoo'² 'e³ rɨ³jó³ ñi'² cú̱u̱², je² bi²³ tii³ 'uǿ²³. Xe̱'n² ca²³jǿn²³ mɨ³¹ju̱³. Qui² bi²³ tii³ 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ca²³la²³jui̱i̱n³¹ ma²mɨ³'áa³ 'i'²³ 'e³ jmee²³ 'ioo³. Qui² 'a²³jia'³ ca²³la²³cuaa²³ jmó². 'E³ jo̱³ hua² ca²³la²³quiʉ̱ʉ̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² jee²³² tó̱o̱². 'E³ quie'²³ ca²³cua̱a̱n²³ xoo'³¹ tó̱o̱² 'e³ ca²³jlɨ́²³ mɨ³¹ju̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² 'uǿ²³ ŋún²³. 'E³ jo̱³ ca²³'ɨ́ɨ³ mɨɨ³¹. Xa³ mɨ³¹ju̱³ 'e³ ca²³'ɨ́ɨ³ ma²³ co̱o̱³ i³lóo³ mɨɨ³¹. Xa³ 'e³ ca²³'ɨ́ɨ³ ma²³ tú̱²³ lu²³guiá³ dsɨ³² guiá²³ mɨɨ³¹. Xa³ 'e³ ca²³'ɨ́ɨ³ ma²³ gui²³guiá³ mɨɨ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","'Ne'² rɨ²³núu²³ dsa³ 'i³ 'née²³ rɨ²³cuǿn²³ miin²³ 'e³ rɨ²³núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","'E³ quie'²³ jo̱³ ca²³ŋɨɨ'n²³ dsa³ quien³² caan²³ Jesús. Ca²³sɨ'²³te'²³: ―¿'Ee² lǿ² lʉ́n² júu² rɨ³jnɨ³ 'e³ la²³ lʉ́n² quia̱'n²nu³ dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","'E³ jo̱³ ca²³jmée³ júu² Jesús. Ca²³jua'³: ―'Iéen²na'³ júu² miin²³na'³ 'e³ ta³jmee³ra'³ 'i'²³ 'e³ jmii'³¹ lǿ² 'e³ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. Ta³jmee³ra'³ 'i'²³ júu² jo̱³, juø'n³ quie'²³ rɨ³'mo² xe̱'n². 'E³ quie'²³ 'a²³jia'³ 'ióo² júu² te'²³ dsa³ 'í³ 'e³ li²³ta²³jmoo³²te'²³ 'i'²³ júu² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ñúun³ cɨ² rɨ²³'ióo²³ dsa³ 'i³ xa³ ca³juɨ² 'e³ ta³nʉ́ʉ²³. Bi²³ ñúun³ li²³xa³ quie'². 'E³ quie'²³ 'a²³jia'³ lǿ² la'³ quie'² dsa³ 'i³ 'a²³'e³ xa³ 'e³ ta³nʉ́ʉ²³. Qui² rɨ²³je̱'n²te'²³ la²³'nɨɨ'n³¹ qui³ 'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'E³ jo̱³ hua² 'e³ lʉn²³ júu² rɨ³jnɨ³ 'e³ la²³ lʉn²³ quia̱'n²³²na¹ te'²³ dsa³ 'í³. Qui² joo³²te'²³. 'E³ quie'²³ 'a²³jia'³ jné³ quie'²te'²³. Nuu³te'²³. 'E³ quie'²³ 'a²³jia'³ ta³nʉ́ʉ²³te'²³. 'A²³jia'³ ta³jmoo³²te'²³ 'i'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sɨ³lí³ quie'²te'²³ 'e³ la²³ ca²³jua'³ Isaías mɨ²jaa²³² 'e³ rɨ²³lí³ ma²ca¹jua'³: Rɨ²núu²ra'³ xú̱n³. 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² rɨ²jmée²ra'³ 'i'²³. Rɨ²joo³¹ra'³ xú̱n³. 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² rɨ²móo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Qui² bi²³ mɨ³loo³ dsɨ́² dsa³ la³. 'É̱e̱² 'e³ 'a²³jia'³ ma²³ nuu³te'²³. 'É̱e̱² 'e³ mɨ³jní³te'²³ mɨ²ñi²te'¹. La²³nɨ³ hua² mɨ³lǿ²³ 'e³ la²³ 'a²³jia'³ ma²³ rɨ²³lí³ juø'² li²³jné²³ mɨ²ñi²te'¹, 'e³ la²³ 'a²³jia'³ ma²³ rɨ²³lí³ juø'² rɨ²³núu²³ lo³guo²te'¹, 'e³ la²³ 'a²³jia'³ ma²³ rɨ²³lí³ juø'² rɨ²³jmée²³ 'i'²³ dsɨ́²te'²³, 'e³ la²³ 'a²³jia'³ rɨ²³ja²³guín²³te'²³ caan²³na²³ 'e³ rɨ²mi³'láan²na²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’'E³ quie'²³ bi²³ dxʉ́²³ quién²na'³ 'nee'²³. Qui² jné³ mɨ²ñí²ra'³. Nʉ'³ la³guó³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Juɨ́ɨn²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² quia̱'² te'²³ dsa³ 'i³ ca²³jmóo² 'e³ ca³dsaan³² 'i³ ca²³la²³'née²³ 'e³ rɨ²³jóo²te'²³ la²³jɨ³ 'e³ joo³²ra'³ rɨ³nɨ²³ 'u². 'E³ quie'²³ 'a²³jia'³ ŋó²³te'²³. Ca²³la²³'née²³te'²³ 'e³ rɨ²³núu²³te'²³ la²³jɨ³ 'e³ nuu³ra'³ 'u². 'E³ quie'²³ 'a²³jia'³ ca²³núu³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’'E³ jo̱³ 'ne'² rɨ²núu²ra'³ 'e³ jmii'³¹ 'née²³ rɨ²³jua'³ júu² quiee'³² dsa³ 'i³ ca²³juá² mɨ³¹ju̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","La²³la³ cu³lø³¹ sɨ³ji̱'²³ dsa³ 'i³ nuu³ 'e³ jmii'³¹ lǿ² 'e³ rɨ³løn³¹ Dios juii² dsa³, 'e³ quie'²³ 'a²³jia'³ ta³jmoo³² 'i'²³ ca³quie̱e̱² jmii'³¹ lǿ² júu² jo̱³: Xe̱'n² sɨ³dxóo² 'i³ 'a²³jia'³ dxún²³ 'e³ je̱'n³² júu² 'e³ rɨ³jne² dsɨ́² dsa³ 'í³. La²³nɨ³ cu³lø³¹ 'née²³ rɨ²³jua'³ júu² quiee'³² mɨ³¹ju̱³ 'e³ ca²³juá² dsa³ coo³¹ jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","La²³ xen³ mɨ³¹ju̱³ 'e³ ca²³juá² dsa³ jee²³² guoo'² 'e³ rɨ³jó³ ñi'² cú̱u̱² xen³ ca³dxáan² dsa³ 'i³ nuu³ júu² quiee'³² Dios 'e³ quie'²³ xe̱'n² jmɨ́ɨ² jmoo³² quie'²te'²³ 'e³ jɨn³ dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","'E³ quie'²³ 'a²³jia'³ sɨ³li³'uee'n³ dsɨ́²te'²³. 'É̱e̱² 'e³ 'a²³jia'³ sɨ³'ia³ jmó². Ca²³ji̱i̱³ hua² sɨ³táa²³te'²³. Tʉ³²te'²³ xe̱'n² mɨ³li³xa³ u²³ŋɨ́³ dsɨ́ɨ² quie'²te'²³, mɨ³rɨ³'nee³ júu² dsa³ 'e³ mɨ³ca³táan³te'²³ júu² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","La²³ xen³ mɨ³¹ju̱³ 'e³ ca²³juá² dsa³ jee²³² tó̱o̱² xen³ ca³dxáan² dsa³ 'i³ nuu³ júu² quiee'³² Dios, 'e³ quie'²³ sɨ³li³ñúun³ dsɨ́² 'e³ jua'³ jmii'³¹ rɨ²³lí³ la²³jɨ³ ta² quiee'³². Sɨ³caa'n³² jui³¹ 'e³ jua'³ 'iin²³ dsɨ́² cuu². 'E³ jo̱³ sɨ³jlɨ́²³ júu² jo̱³. 'E³ jo̱³ 'a²³ xa³ mɨɨ³¹ 'e³ rɨ²³'ɨ́ɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","La²³ xen³ mɨ³¹ju̱³ 'e³ ca²³juá² dsa³ 'uǿ²³ ŋún²³ xen³ ca³dxáan² dsa³ 'i³ nuu³ júu² quiee'³² Dios. Qui² ta³jmoo³² 'i'²³ 'e³ jmii'³¹ lǿ². 'E³ jo̱³ 'é̱e̱² 'e³ rɨ³'ɨɨ³¹ mɨɨ³¹ la²³ xen³ mɨ³¹ju̱³ 'e³ 'ɨɨ³ ma²³ co̱o̱³ i³lóo³ mɨɨ³¹, la²³ xen³ mɨ³¹ju̱³ 'e³ 'ɨɨ³ ma²³ tú̱²³ lu²³guiá³ dsɨ³² guiá²³ mɨɨ³¹, la²³ xen³ mɨ³¹ju̱³ 'e³ 'ɨɨ³ ma²³ gui²³guiá³ mɨɨ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Xa³ jia'³ cɨ'²³ júu² rɨ³jnɨ³ 'e³ ca²³lʉ́³ Jesús, ca²³sɨ'²³ dsa³. Ca²³jua'³: ―La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³: Xen³ la²³ xen³ jø̱n³ dsa³ 'i³ ca²³juá² mɨ³¹ju̱³ 'e³ dxʉ́²³ 'uǿ²³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","'E³ quie'²³ ca²³dxóo² jø̱n³ dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² dsa³ 'í³ 'e³ la²³ rɨ³guɨɨn³ la²³jɨn³ dsa³. Ca²³juá² mɨ³¹ju̱³ nuu³ 'e³ 'a²³jia'³ 'nee'³¹ je² rɨ³jne² trigo. 'E³ jo̱³ ŋø'n² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ca²³jǿn²³ mɨ³¹ju̱³. Ca²³'ɨ́ɨ³ mɨɨ³¹. Ca²³la²³lii²³ 'e³ rɨ³coo'n³² nuu³ 'e³ 'a²³jia'³ 'nee'³¹ jee²³² trigo. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","'E³ jo̱³ i²guín¹ mozo i²joon³te'²³ juii² 'uǿ²³. Ca²³jua'³te'²³: “Jmø'n² mɨ³¹ju̱³ dxʉ́²³ hua² ca²³jñín³ 'uǿ²³ quien³²nu³. ¿'Ee² lǿ² 'e³ mɨ³jǿn²³ nuu³ 'e³ 'a²³jia'³ 'nee'³¹?” ");
INSERT INTO cnlNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","'E³ jo̱³ ca²³jua'³ juii². Ca²³sɨ'²³ mozos: “Xen³ dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² jné² 'i³ ca²³jmée³ tu³cua̱a̱n²tu²”. 'E³ jo̱³ ca²³jua'³ mozos: “¿'A² dsoo³²ra'³¹ sɨ³xee'n²³²na'³¹ nuu³ jo̱o̱²³na²³?” ");
INSERT INTO cnlNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","'E³ quie'²³ ca²³jua'³ juii²: “'A²³la³ la'³ xú̱n³. Qui² bi²³ juø'² rɨ²juø'n²³na'³ ca³ti³² quia̱'² trigo je² juø'n²³na'³ nuu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Cu²cuá̱a̱n¹ quie'²³ ca³ti³² la²³huø'n²³ 'e³ rɨ²³tɨ́²³ 'e³ rɨ²³lí³ 'ó̱o̱²³. Mɨ³rɨ³ti³ 'e³ rɨ²³lí³ 'ó̱o̱²³, rɨ²juøøn³¹na¹ te'²³ dsa³ 'i³ rɨ²³jmóo² 'ó̱o̱²³ 'e³ rɨ²³sø'n² nuu³ xe̱'n². Rɨ²³'ñʉ́ʉ³te'²³ xoo'³¹ nuu³. Rɨ²³jɨ̱́²³te'²³. 'E³ quie'²³ rɨ²juøøn³¹na¹te'¹ 'e³ rɨ²³to'²³te'²³ trigo 'e̱'³ dsoo²³² quián²³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Xa³ jia'³ cɨ'²³ júu² rɨ³jnɨ³ 'e³ ca²³lʉ́³ Jesús. Ca²³sɨ'²³ dsa³. Ca²³jua'³: ―La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. Xen³ la²³ xen³ co̱o̱³ mɨɨ³¹ mɨ³¹ju̱³ mostaza 'e³ ca²³jñi³ jø̱n³ dsa³ 'uǿ²³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pii'² cɨ² mɨ³¹ju̱³ mostaza la²³ cɨ'²³ la²³jɨ³ jia'³ cɨ'²³ mɨ³¹ju̱³. 'E³ quie'²³ bee'² cɨ² xoo'³¹ la²³ cɨ'²³ la²³jɨ³ jia'³ cɨ'²³ xoo'³¹ nuu³. Sɨ³li³xa³ 'mɨ'n³. Cu³i³guín²³ jo̱o̱³¹ to̱³. Dxa²³ mɨ²sɨɨ² jee²³² mɨ³¹guoo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ca²³lʉ́³ Jesús jia'³ cɨ'²³ júu² rɨ³jnɨ³. Ca²³jua'³: ―La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. Xen³ la²³ xen³ xoo'³¹ 'ɨ²³juɨ² 'e³ có̱²³ jø̱n³ mɨ́³. 'Nɨ³ kilos tʉʉ² harina 'e³ ca²³coo'n³ xoo'³¹ 'ɨ²³juɨ². Ca²³jmée³ xoo'³¹ 'ɨ²³juɨ² 'e³ ca²³yʉ̱́ʉ̱²³ la²³jɨ³ sú̱n². La'³ cu³lø³¹ xen³ 'e³ sɨ³ya'n² dsa³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jmø'n² júu² rɨ³jnɨ³ hua² ca²³lʉ́³ Jesús ma²ca¹lʉ́³ la²³jɨ³ júu² 'e³ lø³² la²³nɨ³. 'A²³'e³ xa³ jia'³ cɨ'²³ 'iin³² júu² 'e³ ca²³lʉ́³ quia̱'² la²³jɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","La'³ hua² ca²³lǿ²³ 'e³ la²³ ca²³jua'³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² 'e³ rɨ²³lí³. Qui² to̱o̱²³ ji³ 'e³ jua'³: Júu² rɨ³jnɨ³ hua² rɨ²lʉn²³². Rɨ²juøøn³¹na¹ dsa³ júu² 'e³ rɨ³'mo² cɨ'²³ la²³ 'e³ ca²³jmée³ Dios mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","'E³ quie'²³ jo̱³ ca²³cuaa'n³ dsa³ Jesús. 'Í² xi²ñʉ'¹. 'E³ jo̱³ ca²³guín²³ dsa³ quien³² caan²³ Jesús. Ca²³jua'³te'²³: ―Rɨ²jméen² jɨn³ júu² quiee'³² nuu³ 'e³ 'a²³jia'³ 'nee'³¹ 'e³ rɨ³jne² 'uǿ²³ quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","'E³ jo̱³ ca²³jua'³ Jesús: ―La²³ xen³ dsa³ 'i³ ca²³juá² mɨ³¹ju̱³ 'e³ dxʉ́²³ xen²³na²³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","La²³ xen³ 'uǿ²³ quiee'³² xen³ mɨ³¹güii³ la³. La²³ xen³ mɨ³¹ju̱³ 'e³ dxʉ́²³ xen³ dsa³ 'i³ rɨ³løn³¹ Dios juii². La²³ xen³ nuu³ 'e³ 'a²³jia'³ 'nee'³¹ xen³ dsa³ 'i³ rɨ³løn³¹ juii²te'¹ 'ñée² 'i³ 'a²³jia'³ dxún²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","La²³ xen³ dsa³ 'i³ ca²³juá² mɨ³¹ju̱³ 'e³ 'a²³jia'³ 'nee'³¹ 'i³ hui²³dsɨ́ɨn² ñin³² juii² 'uǿ²³ xen³ mɨ²³sɨ²³quiʉ'². La²³ xen³ 'e³ mɨ³jmóo² dsa³ 'ó̱o̱²³ xen³ mɨ³rɨ³dxa³ jmɨ́ɨ². La²³ xen³ dsa³ 'i³ jmoo³² 'ó̱o̱²³ xen³ ángeles. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Rɨ²³dxi²³cua̱a̱'n³te'²³ nuu³ 'e³ 'a²³jia'³ 'nee'³¹. Rɨ²³jɨ̱́³te'²³ dxi³¹ji³. 'E³ quie'²³ la'³ cu³lø³¹ 'e³ rɨ²³lí³ mɨ³rɨ³dxa³ jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jné² Jo̱o̱³¹ Dsa³ rɨ²sɨɨn³¹na¹ ángeles quién²³na²³. Rɨ²³'uøø³te'²³ la²³jɨ³ 'e³ dsɨn³² 'e³ sɨ³li³xa³ dsoo² quiee'³² dsa³ la²³ca̱a̱n³ je² rɨ³løn³¹na¹ juii². Rɨ²³'uøøn³te'²³ la²³jɨn³ 'i³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Rɨ²³juén²te'²³ dxi³¹ji³. Je² núu²³ rɨ²³'o'² dsa³. Rɨ²³cuu'³ la²³ cɨ² jo̱²te'¹ la²³'nɨɨ'n³¹ 'e³ rɨ²³ŋɨ́³ dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mɨ³rɨ³li³ la'³, rɨ²³lín³ rɨ³ji'n³¹ dsa³ 'i³ rɨ³løn³¹ ca³dsaan³², la²³'nɨɨ'n³¹ 'e³ li²³gáan³te'²³. Rɨ²³lín³te'²³ 'e³ la²³ lǿn²³ ñi'² je² rɨ³løn³¹ juii² Jmii³te'²³. 'E³ quie'²³ 'ne'² rɨ²³núu²³ dsa³ 'i³ 'née²³ rɨ²³cuǿn²³ miin²³ 'e³ rɨ²³núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³: Xen³ la²³ xen³ co̱o̱³ 'e³ bi²³ quí̱i̱n²³ 'e³ rɨ³'oo³ 'uǿ²³. Xen³ jø̱n³ dsa³ 'i³ ca²³dso'²³. Jo̱³ tu³ ca²³'óo² co̱'³. Bi²³ ma²³'nee³ jɨn³ dsɨ́² dsa³ 'í³. 'E³ jo̱³ ŋóo² ca²³'nɨ́ɨ³ la²³jɨ³ 'e³ xa³ quie'². Ló² 'uǿ²³ je² rɨ³'oo³ co̱o̱³ 'e³ bi²³ quí̱i̱n²³ jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³: Xen³ la²³ xen³ jø̱n³ dsa³ 'i³ lo³² mɨ³¹huii'³ 'e³ bi²³ dxʉ́²³ 'e³ jua'³ rɨ²³'nɨ́ɨ²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ca²³dso'²³ je² xa³ co̱o̱³ mɨɨ³¹ mɨ³¹huii'³ 'e³ bi²³ quí̱i̱n²³. 'E³ jo̱³ ŋóo² ca²³'nɨ́ɨ³ la²³jɨ³ 'e³ xa³ quie'². 'E³ jo̱³ ló² mɨ³¹huii'³ jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³: Xen³ la²³ xen³ co̱o̱³ 'mó² 'e³ ca²³juá²te'²³ 'e̱'³ jmɨ²³ñii'³¹. Ca²³ta'n²³ la²³jɨ³ 'iin³² roo'³² 'i³ xen³ 'e̱'³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ma²ca¹cø̱'n¹ 'mó², sø'²te'²³ ñi'² dsoo² je² rɨ³quiʉ̱ʉ̱³. 'E³ quie'²³ jo̱³ ca²³gua³ dsa³. Ca²³xíin² ca²³ŋɨ́ɨn²te'²³ la²³jɨn³ roo'³² 'i³ dxún²³. Ca²³taa'n³te'²³ mɨɨ'³. Ca²³tá̱a̱n²te'²³ la²³jɨn³ 'i³ 'a²³jia'³ 'nee'n³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'E³ quie'²³ la'³ cu³lø³¹ rɨ²³lí³ mɨ³rɨ³dxa³ jmɨ́ɨ². Rɨ²³sɨ²³guín²³ te'²³ ángeles. Rɨ²³'uøøn³ la²³jɨn³ 'i³ 'a²³jia'³ dxún²³ jee²³² quiee'³² la²³jɨn³ 'i³ jmoo³² ca³dsaan³². ");
INSERT INTO cnlNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Rɨ²³juén²te'²³ dxi³¹ji³. Je² núu²³ rɨ²³'o'² dsa³. Rɨ²³cuu'³ la²³ cɨ² jo̱²te'¹ la²³'nɨɨ'n³¹ 'e³ rɨ²³ŋɨ́³ dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―¿'A² mɨ³jmée²ra'³ 'i'²³ la²³jɨ³ 'e³ mɨ³juǿøn²na²³ 'nee'²³? 'E³ jo̱³ ca²³jua'³te'²³: ―Ma² mɨ³jmee²ra'³¹ 'i'²³ xú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","'E³ jo̱³ ca²³jua'³ Jesús: ―La²³ xen³ juii² xi²ñʉ'¹ xen³ 'nee'²³ 'i³ rɨ³løn³¹na'³ 'é̱e̱² dsa³ 'e²³ ley 'i³ sɨ³li³tɨn³ 'e³ jmii'³¹ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. Ñúun³ la²³jɨ³ 'e³ taa'² guóo² 'e³ 'aa³ juii² xi²ñʉ'¹. Xa³ ma² sɨ³li³'ne'² rɨ²³dxi³ júu² 'e³ 'mɨɨn³². Xa³ ma² sɨ³li³'ne'² rɨ²³dxi³ júu² 'e³ mɨ³xa³ cɨ² ca³juɨ² xa³. 'E³ jo̱³ hua² xa³ cɨ'²³ la²³ sɨ³li³'ne'², te³ jmii'³¹ lǿ² júu² 'e³ xa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","La'³ cu³lø³¹ júu² rɨ³jnɨ³ 'e³ ca²³lʉ́³ Jesús. 'E³ quie'²³ jo̱³ ca²³bǿn³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ŋø'n² juɨɨ³ quiee'³². Núu²³ ca²³'ée²³ dsa³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Bi²³ juø'²³ ca²³núu³te'²³. Ca²³jua'³te'²³: ―¿Jiaa'³¹ ca²³mi²³tɨn²³ dsa³ nɨ³ la²³jɨ³ 'e³ dsoo²³ dsɨ́² cu²ne²ra²? ¿Jmii'³¹ lǿ² 'e³ jmee²³ la²³jɨ³ u²³juø'²³ 'e³ jmee²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿'A² 'a²³la³ 'í³ jo̱²³ñʉʉ'³¹ tɨ³² 'mo³? Ma³rii³¹ xi̱i̱n³ xóo². La²³ ca³já̱a̱n² quia̱'² Jacobo quia̱'² Søø³² quia̱'² Muun³² quia̱'² Judas. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nee'n²³² jee²³² quiee³²ra² la²³jɨn³ te'²³ jó̱o̱² 'i³ mɨ́³, ¿mɨ³naa'³¹? ¿Jiaa'³¹ mɨ³la³tɨn³ 'ñée² la²³jɨ³ jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","'E³ jo̱³ 'a²³jia'³ ma²³ ca²³táan³te'²³ quia̱'²te'²³. 'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ 'í³: ―'A²³ ma²³ la²³jɨn³ dsa³ mi³juø'²³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. 'E³ quie'²³ 'nɨɨ'n³¹ dsa³ 'i³ xen³ juɨɨ³ quiee'³², quia̱'² la²³jɨn³ 'i³ xen³ quie'², 'nɨɨ'n³¹ 'i³ 'í³ hua² 'i³ 'a²³jia'³ 'née²³ rɨ²³mi²³juø'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","'A²³jia'³ ñúun³ u²³juø'²³ 'e³ ca²³jmée³ je² núu²³. Qui² 'a²³jia'³ sɨ³táan³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mɨ²jo̱³ ca²³núu³ dxi² juɨɨ³ pii'² 'i³ xi̱i̱n³ Herodes 'e³ jmii'³¹ cu³lø³¹ lʉ²³ dsa³ 'en³²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","'E³ jo̱³ ca²³jua'³ 'ñée². Ca²³sɨ'²³ mozos quien³²: ―Mɨ³ji̱i̱'²³ co̱'³ Juan 'i³ ca²³xáan² dsa³ jmɨɨ³. 'E³ jo̱³ hua² 'e³ quie̱³ ju²³bíi²³ 'e³ sɨ³lí³ juø'² jmee²³ u²³juø'²³. ―La'³ ca²³jua'³ Herodes. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Qui² mɨ³xa³ ca³juɨ² sø̱'n² Juan. Ca²³'ñúun²³. Ca²³ta̱a̱'n³ i²³ñí². Qui² la'³ ca²³la²³'née²³ Herodías, mɨ́³ 'i³ ca²³lǿn²³ mɨ²³quie'² Bi³lii² 'i³ la²³ ca³já̱a̱n² quia̱'² Herodes. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Qui² ca²³jua'³ Juan. Ca²³sɨ'²³ Herodes: ―'A²³jia'³ joo'²³ 'e³ quia̱'n²nu³ Herodías. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","'Née²³ Herodes 'e³ rɨ²³jŋɨ'n²³ Juan. 'E³ quie'²³ 'ñaa'n²³ dsa³ juɨɨ³. Qui² lǿn³ dsa³ 'e³ 'ɨɨ³ júu² quiee'³² Dios Juan. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ma²ca¹tɨ́³ jmɨ́ɨ² 'e³ la²³ ca²³la²³xen³ Herodes, ca²³jmée³ mɨ²juee'³. Ca²³dsǿn²³ jo̱²³mɨɨ³¹ Herodías xi²ñi² te'²³ dsa³ 'i³ nee'n²³² mɨ²juee'³. Bi²³ 'née²³ 'ñée² Herodes. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","'E³ jo̱³ ca²³jua'³ 'e³ ca³quie̱e̱² rɨ²³cuǿø²³ xii'³ mɨ́³ te³ 'ee² 'noo³¹ 'e³ rɨ²³ŋɨ́ɨ²³. Ca²³'én² Dios ma²ca¹jua'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","'E³ jo̱³ ca²³lʉ́³ xóo² quia̱'² jo̱²³mɨɨ³¹. Ca²³quié̱n² júu² xii'³ mɨ́³ 'e³ jmii'³¹ cu³lø³¹ rɨ²³jua'³. 'E³ jo̱³ ca²³jua'³ xii'³ mɨ́³: ―Te̱'² 'e̱'³ huɨ̱́ɨ̱²³ mɨ²dxi² Juan 'i³ xaan³² dsa³ jmɨɨ³. Cuøø² jné² je² la³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bi²³ ca²³ŋɨ́³ dsɨ́² rey. Qui² ca²³'én² Dios ma²ca¹jua'³ 'e³ rɨ²³cuǿ²³ te³ 'ee² 'noo³¹ 'e³ rɨ²³ŋɨ́ɨ²³ xii'³ mɨ́³. Co̱'³ cɨ'²³ bi²³ joo³² la²³jɨn³ dsa³ 'i³ ca²³ñii'n³ mɨ²juee'³ quiee'³². 'E³ jo̱³ ca²³dxi³ 'i'²³ 'e³ rɨ²³cuǿø²³te'²³ xii'³ mɨ́³ mɨ²dxi² Juan. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","'E³ jo̱³ ca²³xíin²³ dsa³ 'e³ i²tʉ́n²te'²³ mɨ²dxi² Juan je² 'iún² i²³ñí². ");
INSERT INTO cnlNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","'E³ jo̱³ to̱'²te'²³ 'e̱'³ huɨ̱́ɨ̱²³ mɨ²dxi². Quie̱³te'²³ 'e³ ca²³ja²³guiin³² co̱'³. Ca²³cuǿø²³te'²³ xii'³ mɨ́³. 'I³ 'í³ ca²³jɨ̱'²³ xóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ca²³dxi²³guín²³ dsa³ quien³² Juan. Ca²³tøø³te'²³ 'lɨ́ɨ³. Ca²³'áan²te'²³ jo̱o̱²³na²³. 'E³ quie'²³ jo̱³ i²guín¹te'²³ i²xii'²³²te'¹ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ma²ca¹núu³ la'³ Jesús, ca²³bǿn³ je² núu²³. Ŋóo² jui³¹ móo² je² 'a²³'i̱³ xen³ nee'n²³² dsa³. 'E³ quie'²³ ca²³núu³ dsa³ 'e³ ŋóo². 'E³ jo̱³ ca²³'uǿøn²te'²³ juɨɨ³ quiee'³²te'²³. Ca²³guín²³te'²³ jui³¹ tɨɨ²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bi²³ juɨ́ɨn²³ dsa³ ŋǿn² Jesús 'e³ la²³ ca²³bǿn³ 'e̱'³ móo². Bi²³ ca²³la²³cuu'²³ dsɨ́² quia̱'² dsa³. 'E³ jo̱³ ca²³mi²³'láan³ dsa³ 'i³ dsoo'²³² 'i³ quia̱'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma²mɨ³cu³'lóo³ jmɨ́ɨ² jo̱³ ca²³cu²³cáan² Jesús te'²³ dsa³ quien³². Ca²³jua'³te'²³: ―'A²³'i̱³ mi'³ xen³ dsa³ 'i³ nee'n²³² je² la³, ¿mɨ³naa'³¹? Mɨ³ rɨ²³nʉʉ³. Tʉn²³ júu² quia̱'n²nu³te'²³ 'e³ cu²dxi³guín²³te'²³ la²³ca̱a̱n³ ranchos 'e³ sɨ³lá³te'²³ 'e³ rɨ²³e'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","'E³ jo̱³ ca²³jua'³ Jesús: ―'A²³jia'³ 'ne'² sɨ³guín²³te'²³. 'Nee'²³ rɨ²cuøø³¹ra'³ 'e³ rɨ²³e'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Xa³ la³ 'nɨɨ'n³¹ 'ñé³ 'ɨ²³juɨ² quiée²ra'³¹ quia̱'² áan²³ 'moo'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","'E³ quie'²³ ca²³jua'³ Jesús: ―Cu³quie̱³ra'³ je² la³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","'E³ jo̱³ ca²³sɨ'²³ dsa³ 'e³ rɨ²³gua³te'²³ ñi'² mɨ³¹ñii³. So̱'²³ la²³jɨ³ 'ñé³ 'ɨ²³juɨ² quia̱'² áan²³ 'moo'³. Ca²³jóo² yʉʉ'³¹. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. Ca²³xíin² 'ɨ²³juɨ². Ca²³cuǿø²³ te'²³ dsa³ quien³². Te'²³ 'i³ 'í³ hua² 'i³ ca²³to'²³ dxóo² ca²³cuǿø²³ te'²³ dsa³ 'i³ nee'n²³² 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ca²³e'² la²³jɨn³ sú̱n² dsa³ xi³'lɨ² ca²³cø̱'n²³te'²³. Ca²³dxi²³cua̱a̱'n³te'²³ juɨɨ²³² 'e³ ca²³tø'n². Gui²³tʉ̱́³ mɨɨ'³ dsuu² 'nɨɨ'n³¹ ca²³cø̱'n²³ la²³jɨ³ juɨɨ²³² 'e³ ca²³tø'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Xen³ co̱o̱³ 'ñé³ mil 'nɨɨ'n³¹ dsóo²³ 'i³ ca²³e'². Co̱³quie'² hua² te'²³ mɨ́³ quia̱'² cɨ² te'²³ xii'³ pii'². ");
INSERT INTO cnlNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ca²³sɨ'²³ dsa³ quien³² 'e³ cu²ta'n¹te'²³ móo², 'e³ sɨ³guiin³²te'²³ joo³¹ i²³'ŋóo² jén²³ cɨ² la²³ 'ñée². Qui² 'e³ cɨ² tʉʉ'n³ júu² quia̱'² dsa³ 'i³ rɨ³ŋɨɨn³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ma²mɨ³líi² mɨ³tʉʉ'n³ júu² quia̱'² te'²³ dsa³ 'i³ rɨ³ŋɨɨn³¹ je² núu²³, ŋóo² yʉʉ'³¹ mo'³ 'e³ jua'³ rɨ²³lʉ́²³ quia̱'² Dios je² jø̱n³ 'ñée². 'E³ la²³ ca²³nʉʉ³, jen³¹ yʉʉ'³¹ mo'³ jø̱n³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","'E³ quie'²³ bi²³ huɨ̱́ɨ̱³ la²³ ji̱i̱'² jmɨ²³ñii'³¹ ji̱i̱²³² móo² 'e³ ta'n² dsa³ quien³². Bi²³ bee'² dxí³ ro̱o̱²³ tu³'o³ la²³ xi²ñi²te'¹. 'E³ jo̱³ bi²³ ca²³cuǿ³ jmɨɨ³ móo². ");
INSERT INTO cnlNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","'E³ la²³ 'a²³jia'³ ma²³ huǿø³ 'e³ li²³jné²³, ca²³dxóo² Jesús ñi'² jmɨ²³ñii'³¹. 'Iún² jui³¹ ñi'² jmɨ²³ñii'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","'E³ la²³ ŋó²³ te'²³ dsa³ quien³² 'e³ ja³'ɨ́ɨn²³ ñi'² jmɨ²³ñii'³¹, bi²³ ca²³jue'n² miin²³. Ca²³jua'³te'²³: ―'Lɨ́ɨ³, ¿mɨ³naa'³¹? Bi²³ ca²³yo'³ ca²³tǿ²³te'²³ la²³'nɨɨ'n³¹ ca²³jue'n² miin²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Xe̱'n² jmɨ́ɨ² ca²³lʉ́³ 'ñée² Jesús. Ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―Dxa²ra'³ co̱o̱³ 'óo²ra'³. Qui² jné² hua² la³. 'A²³ rɨ³juø'n²³na'³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","'E³ jo̱³ ca²³jua'³ Peen²³². Ca²³sɨ'²³ Jesús: ―Juiin²³, xi³nu³ 'nʉ³ hua² nɨ³, rɨ²juɨɨ'n³¹nu³ jné² 'e³ ñiin²³ je² xi'n²³nu³, 'e³ i³'ɨɨn²³na²³ ñi'² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","'E³ jo̱³ ca²³jua'³ Jesús: ―Ñe³ jo̱o̱²³na²³. Ca²³bǿn³ Peen²³² 'e̱'³ móo². Ŋóo² ñi'² jmɨɨ³. Ŋóo² caan²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","'E³ quie'²³ ŋó²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ ro̱o̱²³ dxí³. 'E³ jo̱³ ca²³jue'n² 'ñée². Láa²³ ca²³'a'n² 'e̱'³ jmɨɨ³. 'E³ jo̱³ ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³jua'³: ―Laan²³² jné², Juiin²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Xe̱'n² jmɨ́ɨ² ca²³'ɨ́ɨ³ guoo³ Jesús. Sø̱'n² Peen²³². Ca²³jua'³: ―Bi²³ ca³pii'² sɨ³táan³nu³. ¿'Ee² lǿ² mɨ³la³tú̱²³ 'áan²? ");
INSERT INTO cnlNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Xe̱'n² ma²ca¹ta'n¹te'²³ móo², ca²³cɨ́³ dxí³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ca²³mi²³gáan³ Jesús te'²³ dsa³ 'i³ ta'n² 'e̱'³ móo². Ca²³jua'³te'²³: ―Ju²dsoo³¹ 'e³ Jo̱o̱³¹ Dios hua² 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ma²mɨ³líi² mɨ³'øn³te'²³ jmɨɨ³, ca²³tɨ́n³te'²³ 'uǿ²³ je² xi̱i̱n³ Genesaret. ");
INSERT INTO cnlNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ca²³la²³cuiin²³ Jesús te'²³ dsa³ 'i³ xen³ je² núu²³. Ca²³ji̱i̱n³te'²³ júu² la²³ca̱a̱n³ je² mɨ³lén². 'E³ jo̱³ i²jøn²³te'²³ caan²³ Jesús la²³jɨn³ dsa³ 'i³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ca²³ŋɨ́ɨ³te'²³ mɨ²'áa² quie'² Jesús 'e³ rɨ²³cuǿ²³ júu² 'e³ rɨ²³quiʉ̱'² guoo³te'²³ juø'n³ quie'²³ 'nɨɨ'n³¹ xʉʉ'²³² cuo̱o̱³. Ca²³'láan³ la²³jɨn³ dsa³ 'i³ ca²³quiʉ̱'² guoo³ xʉʉ'²³² cuo̱o̱³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Naan³ juɨɨ³ Jerusalén te'²³ dsa³ fariseo quia̱'² te'²³ dsa³ 'e²³ ley. I²joon³te'²³ Jesús. Ca²³jua'³te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿'Ee² lǿ² 'a²³jia'³ jmoo³² dsa³ quien³²nu³ 'e³ la²³ lǿ² tɨ³² 'i'²³ quiee'³² dsa³ jaa²³²? Qui² 'a²³jia'³ u̱u̱'³²te'²³ guoo³te'²³ 'e³ la²³ 'íi² rɨ²³'ɨ̱'² rɨ²³e'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'Ee² lǿ² 'a²³jia'³ jmee³ra'³ 'e³ la²³ lǿ² 'e³ ca²³dxi³ 'i'²³ Dios 'e³ juo'³ra'³ 'noo³ra'³ 'e³ rɨ²jmée²ra'³ 'e³ la²³ lǿ² tɨ³² 'i'²³ quien³²na'³? ");
INSERT INTO cnlNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Qui² ca²³dxi³ 'i'²³ Dios: “Rɨ²'óo²ra'³ u²³go³ u²³'iʉʉ²³ quia̱'n²na'³ xoo³ra'³ ñʉ'²ra'³”. Co̱'³ cɨ'²³ ca²³dxi³ 'i'²³: “Cu²jú̱n³ quie'²³ dsa³ 'i³ 'ñe'² lʉ²³ 'en³² xóo² jmii³”. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","'E³ quie'²³ juo'³ra'³ 'nee'²³ 'e³ líi² te³ rɨ²³jua'³ dsa³ rɨ²³sɨ'²³ xóo² jmii³: “Nee'²³² guoo³ Dios la²³jɨ³ 'e³ xa³ quián²³ 'e³ rɨ²³lí³ juø'² rɨ²jmeen²³² co̱²juø'¹ quién²na'³ 'u²”. Líi² te³ rɨ²³jua'³ dsa³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","'E³ jo̱³ juo'³ra'³ 'e³ 'a²³jia'³ ma²³ 'ne'² 'e³ rɨ²³jmée²³ co̱²juø'¹ dsa³ 'í³ quie'² xóo² jmii³. Jmee³ra'³ 'e³ bi²³ quí̱i̱n²³ tɨ³² 'i'²³ quien³²na'³. La²³nɨ³ hua² jmee³ra'³ 'e³ 'a²³jia'³ ma²³ quí̱i̱n²³ quién²na'³ júu² 'e³ ca²³dxi³ 'i'²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bi²³ jmee³ra'³ guóo². 'Nee'²³ hua² ca²³'én² Isaías mɨ²jaa²³² ma²ca¹jua'³ 'e³ jmii'³¹ rɨ²jmée²ra'³. Ca²³jua'³ 'ñée²: ");
INSERT INTO cnlNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bi²³ jmoo³² 'e³ mi³gáan³ jné² te'²³ dsa³ la³ 'e³ la²³ lʉ²³te'²³ 'nɨɨ'n³¹ júu² 'oo²te'¹. 'E³ quie'²³ bi²³ mɨ³la³huɨ̱'n³ dsɨ́²te'²³ quia̱'²te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Te³ li²³ŋɨ́n³ 'e³ mi³gáan³te'²³ jné². Qui² 'nɨɨ'n³¹ júu² 'e³ ca²³dxi³ 'i'²³ dsa³ hua² 'e²³te'²³. La'³ ca²³jua'³ Isaías mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","'E³ quie'²³ ca²³tøø³ dsa³ Jesús. Ca²³jua'³: ―'Ne'² rɨ²núu²ra'³ jo̱o̱²³na²³. 'Ne'² rɨ²jmée²ra'³ 'i'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","'A²³la³ la²³jɨ³ 'e³ sɨ³too'³ 'oo² dsa³ 'e³ jmee²³ 'e³ sɨ³li³'lʉ'n² dsa³. Qui² la²³jɨ³ 'e³ sɨ³'uøø³ 'oo² dsa³, 'e³ jo̱³ hua² jmee²³ 'e³ sɨ³li³'lʉ'n² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","'E³ jo̱³ i²guín¹ te'²³ dsa³ quien³² caan²³ Jesús. Ca²³jua'³te'²³: ―¿'A² máan³ 'e³ mɨ³ŋɨ́³ dsɨ́² te'²³ dsa³ fariseo ma²mɨ³núu³te'²³ júu² 'e³ mɨ³lʉ́n²? ");
INSERT INTO cnlNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ quien³²: ―'E³ cɨ² rɨ²³sø'n²te'²³ la²³jɨ³ sú̱n² xoo'³¹ 'e³ 'a²³jia'³ ca²³jñi³ Ñu'n²³ 'i³ jen³¹ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Cu²jmóo¹ quie'²³ dsa³ 'í³ 'e³ la²³ jmoo³². Cuøø²³te'²³ dsa³ jui³¹, juø'n³ quie'²³ tuu² mɨ²ñi² miin²³. Xi³nu³ rɨ²³cuǿø²³ jui³¹ uu'n² dsa³ 'i³ la²³ røø³ túun², 'e³ jo̱³ rɨ²³te'n²³te'²³ 'e̱'³ too³ jɨ̱ɨ̱n²³² la²³ ca³ti³². ");
INSERT INTO cnlNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","'E³ jo̱³ ca²³jua'³ Peen²³². Ca²³sɨ'²³ Jesús: ―Rɨ²jméen² jɨn³ quiée²ra'³¹ júu² rɨ³jnɨ³ 'e³ mɨ³lʉ́n². ");
INSERT INTO cnlNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","'E³ quie'²³ ca²³jua'³ Jesús: ―¿'A² jmee²³ quie'²³ 'e³ 'a²³jia'³ ta³jmee³ra'³ 'i'²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿'A² 'a²³jia'³ sɨ³dsaan³²na'³ jo̱o̱²³na²³? Tu'² hua² dsa³ sɨ³too'³ la²³jɨ³ 'e³ ee'³² dsa³. Jo̱³ tu³ sɨ³ŋɨ́n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","'E³ quie'²³ dsɨ́² dsa³ sɨ³bǿn³ 'e³ lʉ²³ dsa³ júu² 'e³ 'a²³jia'³ dxʉ́²³. 'E³ jo̱³ hua² 'e³ jmee²³ 'e³ sɨ³li³'lʉ'n² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Qui² dsɨ́² dsa³ sɨ³bǿn³ la²³jɨ³ 'i'²³ 'e³ 'a²³jia'³ dxʉ́²³. Dsɨ́² dsa³ sɨ³bǿn³ 'e³ jmoo³² dsa³ 'móo², 'e³ ta̱a̱'n³ dsa³ miin²³ quia̱'² jia'³ cɨ'²³ mɨ́³, 'e³ jmoo³² dsa³ ñi³ dxa³, 'e³ jmoo³² dsa³ 'i̱i̱³, 'e³ juu³² dsa³ 'e³ la²³ rɨ³løn³¹ dsa³ ñi³, 'e³ 'ñe'² lʉ²³ dsa³ 'en³² uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","La²³jɨ³ 'e³ lø³² la²³nɨ³ hua² 'e³ jmee²³ 'e³ sɨ³li³'lʉ'n² dsa³. 'A²³la³ jo̱³ 'e³ ee'³² dsa³ 'e³ 'a²³jia'³ ca³u̱'² guoo³ 'e³ jmee²³ 'e³ sɨ³li³'lʉ'n² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","'E³ quie'²³ ca²³bǿn³ Jesús. Ŋóo² la²³ca̱a̱n³ je² røøn³ juɨɨ³ Tiro quia̱'² juɨɨ³ Sidón. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ca²³dxóo² jø̱n³ mɨ́³ cananea 'i³ xen³ je² núu²³. Quiʉ̱ʉ̱³ ca²³lʉ́³. Ca²³jua'³: ―Juiin²³, dsa³ ju̱u̱n²³ David, cu²li³cuu'²³ 'áan² quia̱'n²nu³ jné². Qui² bi²³ dxi³quié̱n² xii'³ mɨ́³ quién²³na²³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","'E³ quie'²³ 'a²³jia'³ ca²³'í̱n² Jesús. 'E³ jo̱³ ca²³dxi²³guín²³ dsa³ quien³². Ca²³ŋɨ'²³te'²³ la²³bii²³. Ca²³jua'³te'²³: ―Rɨ²juɨɨ'n³¹ mɨ́³ nɨ³ 'e³ cu²dxe'n³. Qui² bi²³ yoo'²³ tø³² rɨ³co'²ra². ");
INSERT INTO cnlNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","'E³ jo̱³ ca²³jua'³ Jesús: ―Mɨ³xíin²³ jné² Dios 'e³ la²³ rɨ²tøøn³¹na¹ 'nɨɨ'n³¹ dsa³ Israel 'i³ xen³ la²³ xen³ dsɨɨ³ joo³ 'i³ mɨ³ca³caa'n³² jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","'E³ quie'²³ ca²³dxóo² mɨ́³ 'í³. Ca²³xii'³ jñi² xi²ñi² Jesús. Ca²³jua'³: ―Juiin²³, rɨ²jméen² co̱²juø'¹ quián²³ xú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","'E³ jo̱³ ca²³jua'³ 'ñée²: ―'A²³jia'³ dxi³ji̱i̱n³¹ 'e³ rɨ²juén¹ 'ɨ²³juɨ² 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³e'² te'²³ xii'³ pii'² 'e³ cu²e'¹ dsɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","'E³ jo̱³ ca²³jua'³ mɨ́³ 'í³: ―Ma² la'³ xú̱n³, Juiin²³. 'E³ quie'²³ ee'³² mi'³ dsɨɨ³ juɨɨ²³² 'e³ sɨ³jiʉ'² ñʉ'²³ mesa je² ee'³² juii²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nʉ³, mɨ́³: Bi²³ ma²³'nee³ sɨ³táan³nu³ quia̱'n²nu³ jné². 'E³ jo̱³ cu²lí³ 'e³ la²³ 'naan³ 'e³ rɨ²³lí³. 'E³ jo̱³ xe̱'n² jmɨ́ɨ² ca²³'láan³ jo̱o̱³¹ mɨ́³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","'E³ la²³ ŋóo² co̱'³ Jesús, jo̱³ ca²³ŋɨ́n³ co̱³² jmɨ²³ñii'³¹ Galilea. Naan³ núu²³ ŋóo² ca²³gua³ yʉʉ'³¹ mo'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³dxi²³guín²³. I²jøn²³te'²³ caan²³ Jesús te'²³ dsa³ 'i³ 'uaa'³ tɨɨ². 'E³ quie'²³ la'³ dsa³ tuu² mɨ²ñi² quia̱'² dsa³ coo²³² quia̱'² dsa³ 'i³ xa³ je² rɨ³yaan²³ quie'². 'E³ quie'²³ xen³ cɨ² juɨ́ɨn²³ dsa³ 'i³ i²jøn²³te'²³. Ca²³dxén²te'²³ 'ui² tɨɨ² Jesús. Ca²³mi²³'láan³ te'²³ dsa³ 'í³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","'E³ jo̱³ bi²³ juø'²³ ca²³ti²³cø̱n³¹ dsa³ 'e³ la²³ ŋó²³te'²³ 'e³ lʉ²³ dsa³ coo²³², 'e³ ca²³'láan³ dsa³ 'i³ xa³ je² rɨ³yaan²³ quie'², 'e³ ŋɨ́³ dsa³ 'i³ 'uaa'³ tɨɨ², 'e³ ca²³la²³jnée²³ dsa³ tuu² mɨ²ñi². 'E³ jo̱³ ca²³mi²³gáan³te'²³ Dios Juii² dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","'E³ quie'²³ jo̱³ ca²³tøø³ dsa³ quien³². Ca²³jua'³: ―Bi²³ cuu'²³ dsɨn²³ quia̱'n²³²na¹ dsa³ 'i³ nee'n²³² la³. Qui² rɨ³nɨ²³ mɨ³tɨ́³ 'nɨ³ jmɨ́ɨ² 'e³ nee'n²³²te'¹ la³ quia̱'²te'²³ jné². 'A²³'e³ xa³ 'e³ rɨ²³e'²te'²³. 'E³ quie'²³ 'a²³jia'³ 'náan²³ rɨ²juøøn³¹na¹ 'e³ sɨ³guiin³² 'e³ cue̱'²³quie'²³te'²³. Qui² bi²³ juø'² rɨ²³'uaa'n²³te'²³ 'e³ la²³ rɨ²³ta'n²³te'²³ jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","'E³ jo̱³ ca²³jua'³ te'²³ dsa³ quien³²: ―¿Jiaa'³¹ mi'³ rɨ²jmee²ra² ji̱i̱³ 'ɨ²³juɨ² 'e³ rɨ²³e'² te'²³ dsa³ nɨ³ 'e³ la²³'nɨɨ'n³¹ juɨ́ɨn²³te'²³? Qui² 'a²³'i̱³ xen³ dsa³ 'i³ nee'n²³² la²³ca̱a̱n³ je² la³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","'E³ jo̱³ ca²³jua'³ Jesús: ―¿Jo'² 'ɨ²³juɨ² xa³ quién²na'³ ru'³? 'E³ jo̱³ ca²³jua'³te'²³: ―'Nɨɨ'n³¹ guiáa²³ hua² xa³ quia̱'² jø̱n³ áan²³ jo̱o̱³¹ 'moo'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ 'í³ 'e³ rɨ²³gua³te'²³ 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","So̱'²³ la²³jɨ³ guiáa²³ 'ɨ²³juɨ² quia̱'² 'moo'³. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. Ca²³xíin². Ca²³cuǿø²³ dsa³ quien³². Te'²³ 'i³ 'í³ hua² 'i³ ca²³to'²³ dxóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ca²³e'² la²³jɨn³ sú̱n² dsa³ xi³'lɨ² 'e³ ca²³cø̱'n²³te'²³. 'E³ jo̱³ ca²³dxi²³cua̱a̱'n³te'²³ juɨɨ²³² 'e³ ca²³tø'n². Guiáa²³ mɨɨ'³ dsuu² 'nɨɨ'n³¹ ca²³cø̱'n²³ la²³jɨ³ juɨɨ²³² 'e³ ca²³tø'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Xen³ quiʉ̱́³ mil 'nɨɨ'n³¹ dsóo²³ 'i³ ca²³e'². Co̱³quie'² hua² te'²³ mɨ́³ quia̱'² cɨ² te'²³ xii'³ pii'². ");
INSERT INTO cnlNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","'E³ jo̱³ ca²³tʉ́n² júu² quia̱'² la²³jɨn³ te'²³ dsa³ 'í³. 'E³ jo̱³ 'í² co̱'³ 'e̱'³ móo² 'ñée². Ŋóo² la²³ca̱a̱n³ je² røøn³ Magadán. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","'E³ quie'²³ ca²³dxi²³guín²³ te'²³ dsa³ fariseo quia̱'² te'²³ dsa³ saduceo 'e³ jua'³ 'née²³te'²³ 'e³ rɨ²³jmóo²te'²³ xí³ lá³ quia̱'²te'²³ Jesús. 'E³ jo̱³ ca²³ŋɨ'²³te'²³ Jesús 'e³ rɨ²³jmée²³ u²³juø'²³ 'e³ rɨ²³jmée²³ lii²³ 'e³ xi² 'í³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³ 'i³ cuø²³ ju²³bíi²³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ca²³jua'³ Jesús: ―'E³ la²³ sɨ³nʉʉ³ juo'³ra'³: “Dxʉ́²³ mɨ³¹güii³ mi²'aa³. Qui² 'e³ yʉ̱́ʉ̱³ jníi² je² sɨ³dxen³ ñi'².” ");
INSERT INTO cnlNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","'E³ quie'²³ xa³ ma² juo'³ra'³ i²³'áa³: “Rɨ²³jmée²³ jmɨ́² rɨ³nɨ²³. Qui² bi²³ juø'²³ cu³lø³¹ jníi² 'e³ sɨ³soo³. Bi²³ yʉ̱́ʉ̱³.” Bi²³ te³ jmee³ra'³ guóo². Móo³ra'³ 'e³ jmii'³¹ rɨ²³jmée²³ mɨ³¹güii³ 'e³ la²³ joo³²ra'³ 'e³ jmii'³¹ cu³lø³¹ jníi². 'E³ quie'²³ 'a²³jia'³ ta³jmee³ra'³ 'i'²³ 'e³ 'ee² 'noo³¹ 'née²³ rɨ²³jua'³ la²³jɨ³ 'e³ sɨ³lí³ rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","'A²³jia'³ dxʉ́²³ jmoo³² dsa³ 'i³ xen³ rɨ³nɨ²³. 'A²³la³ 'í³ Dios 'i³ mi³gáan³te'²³ ca³quie̱e̱². 'E³ jo̱³ 'née²³ rɨ²³jóo²te'²³ u²³juø'²³. 'E³ quie'²³ co̱o̱³ qui³ u²³juø'²³ rɨ²³jóo²te'²³. Rɨ²³jóo²te'²³ uu'n² 'e³ la²³ ca²³ji̱'²³ Jonás mɨ²jaa²³². 'E³ jo̱³ ca²³tʉ́n² te'²³ dsa³ 'í³. Ŋóo² co̱'³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ca²³guín²³te'²³ joo³¹ i²³'ŋóo². 'E³ quie'²³ 'a²³jia'³ ca²³la²³líi²³ dsa³ quien³² 'e³ rɨ²³có̱²te'²³ 'ɨ²³juɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―Rɨ³móo³ra'³. 'A²³ rɨ³co'³ra'³ xoo'³¹ 'ɨ²³juɨ² quiee'³² te'²³ dsa³ fariseo quia̱'² te'²³ dsa³ saduceo. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","'E³ jo̱³ ca²³sɨ́n²³ júu² la²³ co̱³quie'² miin²³ dsa³ quien³². Ca²³jua'³te'²³: ―'A²³'e³ xa³ 'ɨ²³juɨ² 'e³ mɨ³quie̱²ra². 'E³ jo̱³ hua² 'e³ jua'³ la'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Quii²³ Jesús 'e³ jmii'³¹ lǿ² júu² 'e³ sɨn²³te'²³. 'E³ jo̱³ ca²³jua'³ 'ñée²: ―Bi²³ ca³juɨ² sɨ³táan³na'³ quia̱'n²na'³ jné². ¿'Ee² lǿ² sɨ́n³na'³ júu² la²³ co̱³quién²na'³ 'e³ 'a²³'e³ xa³ 'ɨ²³juɨ² 'e³ mɨ³quie̱³ra'³? ");
INSERT INTO cnlNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿'A² 'e̱'n³ quie'²³ 'a²³jia'³ sɨ³dsaan³²na'³? ¿'A² 'a²³jia'³ ma²³ liin³²na'³ 'e³ jmii'³¹ ca²³e'² 'ñé³ mil dsóo²³ ma²ca¹ta'n¹ dxóo² 'ñé³ 'ɨ²³juɨ²? ¿Jo'² mɨɨ'³ dsuu² ca²³cø̱'n²³ ma²ca¹dxi¹cua̱a̱'n³²na'³ juɨɨ²³² 'e³ ca²³tø'n²? ");
INSERT INTO cnlNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿'A² 'a²³jia'³ liin³²na'³ 'e³ jmii'³¹ ca²³e'² quiʉ̱́³ mil dsóo²³ ma²ca¹ta'n¹ dxóo² guiáa²³ 'ɨ²³juɨ²? ¿Jo'² mɨɨ'³ dsuu² ca²³cø̱'n²³ ma²ca¹dxi¹cua̱a̱'n³²na'³ juɨɨ²³² 'e³ ca²³tø'n²? ");
INSERT INTO cnlNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jmii'³¹ lǿ² 'e³ 'a²³jia'³ ta³jmee³ra'³ 'i'²³ 'e³ 'a²³la³ jo̱³ 'ɨ²³juɨ² 'e³ mɨ³'ǿn²³ 'e³ la²³ mɨ³juø'n²: “'A²³ rɨ³co'³ra'³ xoo'³¹ 'ɨ²³juɨ² quiee'³² te'²³ dsa³ fariseo quia̱'² te'²³ dsa³ saduceo”? ");
INSERT INTO cnlNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","'E³ jo̱³ ca²³jmóo²te'²³ 'i'²³ 'e³ 'a²³la³ jo̱³ xoo'³¹ 'ɨ²³juɨ² ca³quie̱e̱² 'e³ ca²³'é³. 'E³ quie'²³ júu² 'e³ 'e²³ te'²³ dsa³ fariseo quia̱'² te'²³ dsa³ saduceo 'e³ ca²³'é³ ma²ca¹jua'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ca²³dxóo² Jesús la²³ca̱a̱n³ je² røøn³ juɨɨ³ 'e³ xi̱i̱n³ Cesarea de Filipo. 'E³ quie'²³ jo̱³ ca²³tín²³ júu² quie'² te'²³ dsa³ quien³². Ca²³jua'³: ―¿'I̱i̱² sɨɨ'³¹ jné² jua'³ dsa³, 'e³ 'en³²te'²³ jné² Jo̱o̱³¹ Dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","'E³ jo̱³ ca²³jua'³ te'²³ dsa³ quien³²: ―Xen³ 'i³ jua'³ 'e³ Juan 'i³ ca²³xáan² dsa³ jmɨɨ³ hua² 'nʉ³. 'E³ quie'²³ xen³ 'i³ jua'³ 'e³ Elías 'nʉ³. Xen³ 'i³ jua'³ Jeremías. Xen³ 'i³ jua'³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","'E³ jo̱³ ca²³jua'³ 'ñée² Jesús: ―'E³ quie'²³, ¿'i̱i̱² sɨɨ'³¹ jné² juo'³ 'nee'²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","'E³ jo̱³ ca²³jua'³ Muun³² Peen²³²: ―Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios hua² 'nʉ³. Jo̱o̱³¹ Dios 'i³ rɨ³ji̱'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","'E³ jo̱³ ca²³jua'³ Jesús: ―Bi²³ dxʉ́²³ quién² 'nʉ³, Muun³² jo̱²³ñʉʉ'³¹ Jonás. Qui² 'a²³la³ 'í³ dsa³ mɨ³¹güii³ 'i³ ca²³jmée³ 'e³ dsoo²³ 'áan² la'³. 'E³ quie'²³ Ñu'n²³ 'i³ jen³¹ yʉʉ'³¹ güii³ 'i³ ca²³jmée³ 'e³ dsoo²³ 'áan². ");
INSERT INTO cnlNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","'E³ jo̱³ rɨ²juøøn³¹na¹ 'nʉ³: Cú̱u̱² xi̱i̱n³nu³. Qui² la'³ cu³lø³¹ 'née²³ rɨ²³jua'³ júu² 'e³ jua'³te'²³ Peen²³². La²³ xen³ cú̱u̱² xen³ júu² 'e³ cɨ² lá²³ mɨ³lʉ́n². Ñi'² cú̱u̱² jo̱³ rɨ²jmeen²³² 'e³ rɨ²³noo³ la²³jɨn³ dsa³ quién²³na²³ 'e³ la²³ xen³ 'e³ dxa²³te'²³ 'ñʉ́² 'ioo'³ ñi'² cú̱u̱² bee'². 'A²³jia'³ jmɨ́ɨ² rɨ²³dxen³ dsa³ quién²³na²³, juø'n³ quie'²³ rɨ²³jú̱n³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Rɨ²cuǿøn¹na²³ 'nʉ³ ju²³bíi²³ 'e³ rɨ²nǿn² 'oo'² 'e³ la²³ rɨ²³lí³ juø'² rɨ²³ta'n²³ dsa³ je² rɨ³løn³¹ Dios juii² dsa³. La²³jɨ³ 'e³ 'a²³jia'³ rɨ²mi³'ien²³nu³ júu² mɨ³¹güii³ la³, rɨ²³cuaa'n²³ 'e³ 'a²³jia'³ rɨ²³'ien³ júu² yʉʉ'³¹ güii³. 'E³ quie'²³ la²³jɨ³ 'e³ rɨ²mi³'ien²³nu³ júu² mɨ³¹güii³ la³, rɨ²³cuaa'n²³ 'e³ mɨ³'ien³ júu² yʉʉ'³¹ güii³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","'E³ quie'²³ jo̱³ ca²³dxin³ 'i'²³ dsa³ quien³² 'e³ 'a²³jia'³ 'ne'² rɨ²³sɨ'²³te'²³ dsa³ 'e³ Cristo 'i³ rɨ²³xíin²³ Dios 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Cɨ'²³ mɨ²jo̱³ ca²³la²³láa²³ 'e³ sɨ'²³ dsa³ quien³² 'e³ li²³'ne'² rɨ²³dsóo² juɨɨ³ Jerusalén je² rɨ²³dxi³ 'i'²³ te'²³ dsa³ mɨ³dxún²³ quia̱'² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley 'e³ ñúun³ la²³jɨ³ 'e³ rɨ²³jme'²³te'²³. Qui² rɨ²³jŋɨ'n²³te'²³. 'E³ quie'²³ je² rɨ²³tɨ́²³ 'nɨ³ jmɨ́ɨ² 'e³ la²³ jú̱n²³ rɨ²³ji̱i̱'²³ co̱'³, ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","'E³ jo̱³ ca²³jén²³ ca³jné³ Jesús Peen²³². Ca²³jín² Jesús. Ca²³jua'³: ―'A²³ cu²cuǿ³ júu² Dios 'e³ rɨ²³lí³ la'³, Juiin²³. 'A²³jia'³ jmɨ́ɨ² 'ne'² rɨ²³jí̱i̱n²nu³ la'³ 'u². ");
INSERT INTO cnlNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","'E³ quie'²³ ca²³ji̱i̱n²³ Jesús. Ca²³sɨ'²³ Peen²³²: ―Je̱'n² nɨ³. Qui² lʉ́n² 'e³ la²³ 'née²³ Satanás. 'Naan³ rɨ²jméen² 'e³ rɨ²³'lǿn²³na²³. 'A²³jia'³ rɨ³løn³¹nu³ co̱o̱³ júu² quia̱'n²nu³ Dios. 'E³ quie'²³ rɨ³løn³¹nu³ co̱o̱³ júu² quia̱'n²nu³ dsa³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ca²³jua'³ co̱'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'A²³jia'³ ma²³ joo'²³ rɨ²³jmée²³ 'e³ la²³ 'née²³ 'ñée² dsa³ 'i³ 'née²³ rɨ²³qui̱'³ jné². 'Ne'² rɨ²³cuǿn²³ 'ñée² 'e³ rɨ²³dxi²³quié̱n² 'e³ la²³ dxi³quié̱n² dsa³ 'i³ ta̱a̱n²³ cruz. 'Ne'² rɨ²³ŋɨ́²³ quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Qui² rɨ²³gua'²³ dsa³ 'i³ bi²³ cɨ² mi³quí̱i̱n²³ 'e³ xen³ mɨ³¹güii³ la³. 'E³ quie'²³ rɨ²³ji̱i̱'²³ ca³quie̱e̱² dsa³ 'i³ rɨ²³cuǿn²³ 'ñée² 'e³ rɨ²³jú̱n³ 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Qui² 'a²³'e³ cua̱a̱n²tu² xa³ quie'² dsa³ 'i³ rɨ²³'ióo²³ la²³jɨ³ sú̱n² 'e³ xa³ mɨ³¹güii³ la³ xi³nu³ rɨ²³gua'²³ dsɨ́². 'A²³'e³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²³quí² dsa³ 'e³ jua'³ rɨ²³ti'n²³ co̱'³ dsɨ́² 'e³ mɨ³guoo'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³ quia̱'n²³²na¹ ángeles quién²³na²³. La²³ gáan³ Ñu'n²³ li²³gáan³na²³ mɨ³rɨ³güe'n²³na²³ co̱'³. Jo̱³ hua² rɨ²cuǿøn¹ jñiin²³ la²³jɨn³ dsa³ te³ jmii'³¹ lǿ² 'e³ mɨ³jmóo²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xen³ dsa³ 'i³ té̱e̱n³ la³ rɨ³nɨ²³ 'i³ rɨ²³jóo² jén²³ cɨ² 'e³ la²³ 'íi² rɨ²³jú̱n³ 'e³ rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³ 'e³ rɨ³løn³¹na¹ juii² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ma²ca¹ŋɨ́n³ jñʉ́ʉ³ jmɨ́ɨ², ŋóo² Jesús yʉʉ'³¹ mo'³ jɨ̱ɨ̱n²³². Ŋóo² 'ñée² quia̱'² Peen²³² quia̱'² Jacobo quia̱'² Juan la²³ ca³já̱a̱n² quia̱'² Jacobo. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Je² joo³² dsa³ quien³² ca²³guø'n³ 'e³ la²³ lǿn²³. Ca²³lǿ²³ rɨ³jii'³¹ ñi² la²³'nɨɨ'n³¹ rɨ³ji'n³¹ ñi'². Ca²³la²³taa³ cuo̱o̱³ la²³'nɨɨ'n³¹ taa³ je² cuø²³ jmɨ́ɨ²³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Co̱'³ la²³ ca²³lǿ²³ 'e³ ca²³la²³jnén³ caan²³te'²³ Moisés quia̱'² Elías. Ca²³mi²³róo³te'²³ quia̱'²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","'E³ jo̱³ ca²³jua'³ Peen²³². Ca²³sɨ'²³ Jesús: ―Juii³ra'³¹, bi²³ dxʉ́²³ 'e³ nee'²³²ra'³¹ je² la³. Xi³nu³ 'naan³, rɨ²jmee²ra'³¹ 'nɨ³ mɨɨ³¹ mɨ²'ñʉ́¹ pii'² je² la³. Rɨ²jmee²ra'³¹ co̱o̱³ 'e³ quien³²nu³, co̱o̱³ 'e³ quiee'³² Moisés, co̱o̱³ 'e³ quiee'³² Elías co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lʉ²³ quie'²³ la'³ Peen²³² 'e³ jó² co̱o̱³ jníi² 'e³ rɨ³jii'³¹ cu³lø³¹ 'e³ ca²³éen³te'²³. Xen³ 'i³ ca²³lʉ́³ jee²³² jníi². Ca²³jua'³: ―'I³ la³ ja̱a̱n²³ 'i³ bi²³ 'náan²³na²³. Bi²³ jmee²³ 'e³ jɨn³ dsɨn²³. 'Ne'² rɨ²núu²ra'³ la²³jɨ³ júu² 'e³ lʉ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ma²ca¹núu³ la'³ dsa³ quien³² Jesús, ca²³quiaa³te'²³ rɨ³'in³²te'²³. Bi²³ ma²³'nee³ ca²³jue'n² miin²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","'E³ quie'²³ ca²³lǿn²³ mɨ³lén² Jesús. Ca²³quiu̱u̱'n³ dsa³ quien³² xi²guoo³. Ca²³jua'³: ―Naa'n²³na'³. 'A²³ rɨ³juø'n²³na'³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ma²ca¹jóo¹te'²³ co̱'³, 'a²³'i̱³ ma²³ xen³ 'i³ té̱e̱n³ quia̱'² Jesús. 'Nɨɨ'n³¹ jø̱n³ 'ñée² Jesús cɨ² ŋǿn²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","'E³ la²³ sɨ³jiaan³²te'²³ co̱'³ yʉʉ'³¹ mo'³, ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'A²³ rɨ³juɨɨ'³²ra'³ dsa³ 'e³ la²³ lǿ² 'e³ mɨ³jóo²ra'³ nɨ³ xi³'lɨ² rɨ²³tɨ́²³ 'e³ rɨ²³ji̱i̱'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","'E³ quie'²³ jo̱³ ca²³jua'³ dsa³ quien³²: ―¿Jmii'³¹ lǿ² 'e³ jua'³ te'²³ dsa³ 'e²³ ley 'e³ 'ne'² rɨ²³güe'n²³ co̱'³ Elías 'e³ 'íi² cɨ² rɨ²³güén³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³güén³? ");
INSERT INTO cnlNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³güe'n²³ co̱'³ Elías xú̱n³. Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jmée²³ dxʉ́²³ co̱'³ la²³jɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","'E³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ güe'n² co̱'³ 'i³ rɨ³løn³¹ 'é̱e̱² Elías. 'E³ quie'²³ 'a²³jia'³ ca²³la²³cuiin²³te'²³. 'E³ quie'²³ ca²³jme'²³te'²³ 'e³ la²³'nɨɨ'n³¹ 'née²³te'²³. 'E³ quie'²³ la'³ rɨ²³jmóo²te'²³ 'e³ rɨ²³dxi²³quié̱n²na²³ jné² Jo̱o̱³¹ Dsa³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","'E³ jo̱³ ca²³la²³quii²³ dsa³ quien³² 'e³ Juan 'i³ ca²³xáan² dsa³ jmɨɨ³ hua² 'en³². ");
INSERT INTO cnlNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","'E³ quie'²³ jo̱³ ca²³dxi²³guín²³te'²³ je² ta'n² juɨ́ɨn²³ dsa³. Xen³ jø̱n³ dsa³ 'i³ ca²³dxóo² caan²³ Jesús. Ca²³xii'³ jñi² xi²ñi² Jesús. Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Rɨ²juøøn³¹na¹ 'nʉ³, Juiin²³: Cu²li³cuu'²³ 'áan² quia̱'n²nu³ ja̱a̱n²³. Qui² bi²³ ta̱a̱n²³ 'i̱'². Bi²³ ma²³'nee³ dxi³quié̱n². Tén³ la²³ sɨ³cɨ'n²³ dxi³¹ji³. Sɨ³cɨ'n²³ 'e̱'³ jmɨɨ³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","'E³ jo̱³ mɨ³i²jøn²³na²³ xii'³ 'í³ 'e³ cu²jóon¹ dsa³ quien³²nu³. 'E³ quie'²³ 'a²³jia'³ ca³lǿ²³ juø'² ca³mi³'láan³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","'E³ jo̱³ ca²³jua'³ Jesús: ―Bi²³ 'a²³jia'³ sɨ³táan³na'³ quia̱'n²na'³ jné². Bi²³ jia'³ cu³lø³¹ 'i'²³ 'e³ jmee³ra'³. ¿Lɨɨ'³¹ cɨ² huø'n²³ 'ne'² 'e³ quia̱'n²³²na¹ 'nee'²³? ¿Lɨɨ'³¹ cɨ² huø'n²³ 'ne'² rɨ²³táan²³ 'e³ la²³'nɨɨ'n³¹ 'e³ jmee³ra'³? Cu³jén²³na'³ la³ xii'³ rɨ²ne²ra². ");
INSERT INTO cnlNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","'E³ quie'²³ jo̱³ ca²³jíi² Jesús, ca²³jín² espíritu quien³² mɨ²³sɨ²³quiʉ'². 'E³ jo̱³ ca²³bǿøn²³ xii'³. Xe̱'n² jmɨ́ɨ² ca²³'láan³ xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cɨ̱ɨ̱n³ cɨ² ca²³lʉ́³ dsa³ quien³² quia̱'² Jesús je² co̱³quie'². Ca²³jua'³te'²³: ―¿'Ee² lǿ² 'e³ 'a²³jia'³ ca³lǿ²³ juø'² 'e³ mɨ³dxin²³²na'³¹ espíritu cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","'E³ jo̱³ ca²³jua'³ Jesús: ―'A²³jia'³ ca³lǿ²³ juø'². Qui² bi²³ ca³pii'² sɨ³táan³na'³. Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xi³nu³ sɨ³táan³na'³, juø'n³ quie'²³ ca³pii'², la²³'nɨɨ'n³¹ pi'n² co̱o̱³ mɨɨ³¹ mɨ³¹ju̱³ mostaza, rɨ²³lí³ juø'² rɨ²³je̱'n²³ mo'³ la³ mɨ³rɨ³juo'³ra'³: “Je̱'n² nɨ³. Je² núu²³ guaan³².” 'A²³'e³ xa³ 'e³ 'a²³jia'³ rɨ²³li'n²na'³ xi³nu³ sɨ³táan³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","'E³ quie'²³ 'ne'² rɨ²lʉ²ra² quia̱'n²na² Dios. 'Ne'² rɨ²jmee²ra² mɨ²³jmɨɨ²³. 'Nɨɨ'n³¹ la'³ hua² sɨ³'uǿøn² espíritus quien³² mɨ²³sɨ²³quiʉ'² 'i³ lǿn²³ la²³nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","'E³ la²³ ca²³ŋɨ́³te'²³ la²³ca̱a̱n³ estado Galilea, ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'E³ cɨ² rɨ²³dxén²te'²³ guoo³ dsa³ mɨ³¹güii³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Rɨ²³jŋɨ'n²³te'²³ jné². 'E³ quie'²³ je² rɨ²³tɨ́²³ 'nɨ³ jmɨ́ɨ² 'e³ la²³ jú̱n²³na²³ rɨ²³ji̱i̱'n²³na²³ co̱'³. Bi²³ ca²³ŋɨ́³ dsɨ́² dsa³ quien³² ma²ca¹jua'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ma²ca¹dxi¹guiin³²te'²³ co̱'³ juɨɨ³ Capernaum, i²guín¹ 'io'² 'i³ cu'n³² cuu² 'e³ 'ne'² ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Ca²³lǿn²³ mɨ³lén² caan²³ Peen²³². Ca²³jua'³: ―¿'A² 'a²³jia'³ qui³² dsa³ 'e²³ quien³²na'³ cuu² 'e³ cu'n³²te'²³ 'e³ 'ne'² ñʉ'²³ 'ñʉ́² gáan³? ");
INSERT INTO cnlNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","'E³ jo̱³ ca²³jua'³ Peen²³²: ―Qui³² xú̱n³. Ma²'i³¹ xi²ñʉ'¹ Peen²³², ca²³lʉ́³ xe̱'n² Jesús. Ca²³sɨ'²³ Peen²³²: ―¿Jmii'³¹ lǿn³nu³, Muun³²? ¿'I̱i̱² sɨɨ'³¹ 'i³ 'ne'² rɨ²³quí² cuu² quie'² 'io'² 'e³ ŋɨɨ²³ dxi² juɨɨ³ reyes quien³² dsa³ mɨ³¹güii³? ¿'A² dsa³ 'i³ xen³ quie'² reyes hua² 'i³ qui³²? ¿'A² jia'³ cɨ'²³ dsa³ hua² 'i³ qui³²? ");
INSERT INTO cnlNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","'E³ jo̱³ ca²³jua'³ Peen²³²: ―Ma² jia'³ cɨ'²³ dsa³ hua² 'i³ qui³². 'E³ jo̱³ ca²³jua'³ Jesús: ―'E³ jo̱³ 'a²³jia'³ 'ne'² rɨ²³quí² dsa³ 'i³ xen³ quie'², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","'E³ quie'²³ 'a²³jia'³ 'nee³ra² 'e³ rɨ²cuø²ra² u²³ŋɨ́³ dsɨ́ɨ² quie'² dsa³. 'E³ jo̱³ guo³ co̱³² jmɨ²³ñii'³¹. Cu³jua² 'e̱'³ jmɨ²³ñii'³¹ 'ñii²³² 'e³ nee² me²³cuu². Rɨ²jøn²³²nu³ 'oo² 'moo'³ 'i³ rɨ²³jáan³nu³ xe̱'n². Rɨ²máan² co̱o̱³ cuu² 'e³ 'iʉ² ta³'oo². Rɨ²ca̱a̱n²³ cuu² jo̱³. Rɨ²cuøøn³¹ 'io'². 'E³ quie'²³ rɨ²³dxi²³quie̱'n²³ cuu² quiée²ra² ca³ti³². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mɨ²jo̱³ ca²³ŋɨɨ'n²³ dsa³ quien³² caan²³ Jesús. Ca²³sɨ'²³te'²³: ―¿'I̱i̱² sɨɨ'³¹ 'i³ gáan³ cɨ² jee²³² quiee'³² la²³jɨn³ dsa³ 'i³ rɨ³løn³¹ Dios juii²te'¹ 'i³ jen³¹ yʉʉ'³¹ güii³? ");
INSERT INTO cnlNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","'E³ jo̱³ ca²³tøø³ Jesús jø̱n³ xii'³ pii'². Ca²³dxén² dxoo'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ca²³jua'³. Ca²³sɨ'²³ dsa³ quien³²: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xi³nu³ 'a²³jia'³ rɨ²guø'n²³²na'³ 'e³ la²³ jmee³ra'³, xi³nu³ 'a²³jia'³ li²³xen³na'³ la²³ xen³ xii'³ pii'², 'a²³jia'³ jmɨ́ɨ² rɨ²³lín³ juii² 'nee'²³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bi²³ dxʉ́²³ jmee²³ dsa³ 'i³ mi³'uǿn²³ 'ñée² 'e³ rɨ²³cuaa'n²³ 'e³ røø³ lǿn²³ quia̱'² xii'³ pii'² la³. 'E³ quie'²³ dsa³ 'i³ mi³'uǿn²³ 'ñée² rɨ³løn³¹ 'ñée² 'i³ gáan³ cɨ² jee²³² quiee'³² la²³jɨn³ dsa³ 'i³ rɨ³løn³¹ Dios juii²te'¹ 'i³ jen³¹ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'E³ quie'²³ 'e³ 'ii'n³² jné² dsa³ 'i³ 'ii'n³² jø̱n³ xii'³ pii'² 'i³ lǿn²³ la²³ lǿn²³ 'i³ la³ 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’'E³ quie'²³ 'a²³jia'³ dxʉ́²³ quie'² dsa³ 'i³ rɨ²³jmée²³ 'e³ rɨ²³'lǿn²³ jø̱n³ 'i³ pii'² 'i³ sɨ³táan³ quia̱'² jné². Bi²³ cɨ² dxʉ́²³ quie'² 'e³ rɨ²³dxóo²te'²³ lúu² co̱o̱³ too²³ bee'², 'e³ la²³ rɨ²³'a'n² je² jɨ̱ɨ̱n²³² 'e̱'³ jmɨ²³ñii'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bi²³ juɨɨ³² dsa³ 'i³ nee'n²³² mɨ³¹güii³ la³. Qui² bi²³ xa³ 'e³ jmee²³ 'e³ sɨ³'lǿn²³ dsa³. Sɨ³li³xa³ quie'²³ la²³bii²³. 'E³ quie'²³ bi²³ juɨɨ³² dsa³ 'i³ jmee²³ 'e³ sɨ³'lǿn²³ uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Xi³nu³ jmee²³ guoo³² tɨɨ³¹ra'³ 'e³ la²³ rɨ²³'lǿn²³na'³, rɨ²tʉn²³²na'³. Rɨ²tó̱o̱²ra'³ jo̱o̱²³na²³. Qui² bi²³ cɨ² dxʉ́²³ quién²na'³ 'e³ 'a²³jia'³ ma²³ dxi²³² guoo³² tɨɨ³¹ra'³ co̱o̱³ joo³¹ 'e³ la²³ cu³guiin³²na'³ je² rɨ³ji̱'n²na'³ ca³quie̱e̱² la²³ cɨ'²³ 'e³ dxi²³² quie'²³ la²³ ca³ti³² guoo³² tɨɨ³¹ra'³ 'e³ rɨ²³juén²te'²³ 'nee'²³ dxi³¹ji³ je² rɨ³jøn³¹ ji³ ca³cuaa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","'E³ quie'²³ la'³ xi³nu³ xa³ 'e³ jmee²³ mɨ²ñí²ra'³ 'e³ la²³ rɨ²³'lǿn²³na'³, rɨ²dxí²ra'³. Rɨ²tó̱o̱²ra'³ jo̱o̱²³na²³. Qui² bi²³ cɨ² dxʉ́²³ quién²na'³ 'e³ dxi²³² co̱o̱³ mɨɨ³¹ mɨ²ñí²ra'³ 'e³ la²³ cu³guiin³²na'³ je² rɨ³ji̱'n²na'³ ca³quie̱e̱² la²³ cɨ'²³ 'e³ dxi²³² quie'²³ tú̱²³ mɨɨ³¹ 'e³ rɨ²³juén²te'²³ 'nee'²³ guiáa²³ juɨ́ɨ² je² rɨ³jøn³¹ ji³ ca³cuaa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’'A²³ rɨ³jmee³ra'³ 'e³ 'a²³jia'³ mi³quí̱i̱n²³na'³ te'²³ 'i³ pii'² 'i³ lǿn²³ la²³ lǿn²³ 'i³ la³. Qui² rɨ²juøøn³¹na¹ 'nee'²³ 'e³ yʉʉ'³¹ güii³ xen³ ángeles 'i³ mi³quin³. Tén³ nee'n²³²te'¹ xi²ñi² Ñu'n²³ 'i³ jen³¹ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Qui² güén²³na²³ jné² Jo̱o̱³¹ Dsa³ 'e³ rɨ²láan¹na²³ dsa³ 'i³ mɨ³ca³caa'n³². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Jmii'³¹ lǿn³na'³ jo̱o̱²³na²³? La²³ cu²ru'³ xen³ jø̱n³ dsa³ 'i³ xen³ co̱o̱³ i³láan³ dsɨɨ³ joo³ quien³², 'e³ quie'²³ mɨ³ca³caa'n³² jø̱n³. Rɨ²³cuaa'n³ 'e³ jø̱n³ 'a²³ ti³² co̱o̱³ i³láan³ je² ta'n² mo'³. Rɨ²³dsóo² rɨ²³sɨ²³'nee'n³ jø̱n³ dsɨɨ³ joo³ 'i³ mɨ³ca³caa'n³², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xi³nu³ rɨ²³dxee'n²³ dsɨɨ³ joo³ quien³², bi²³ cɨ² rɨ²³jmée²³ 'e³ jɨn³ dsɨ́² 'e³ xen³ dsɨɨ³ joo³ 'í³ la²³ cɨ'²³ 'e³ xen³ la²³jɨn³ 'e³ jø̱n³ 'a²³ ti³² co̱o̱³ i³láan³ 'i³ 'a²³jia'³ lɨ'³ ca³caa'n³². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","'E³ quie'²³ la'³, 'a²³jia'³ 'née²³ Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³ 'e³ rɨ²³gua'²³ cu³xi³ jø̱n³ 'i³ pii'² 'i³ lǿn²³ la²³ lǿn²³ 'i³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Xi³nu³ jmee²³ jø̱n³ uu'n²na'³ 'e³ xa³ dsoo² 'e³ jme'²³ 'nee'²³, guaan³² cu³lʉ́n² quia̱'n²nu³ la²³ co̱³quién²na'³. Rɨ²juɨɨ'n³¹ 'e³ la²³ lǿ² dsoo² 'e³ mɨ³jme'²³ 'nʉ³. Xi³nu³ rɨ²³núu²³ 'ñée² 'e³ la²³ juɨɨ'n³², jo̱³ mɨ³tɨ'n²³nu³ co̱'³ uu'n²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","'E³ quie'²³ xi³nu³ 'a²³jia'³ rɨ²³núu²³, guaan³² co̱'³ quia̱'n²nu³ jø̱n³ áan²³ cɨ² dsa³ 'e³ la²³ li²³xen³ áan²³ aan³ dsa³ ñi³ 'i³ ñi³² 'e³ jmii'³¹ lǿ² la²³jɨ³ 'e³ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","'E³ quie'²³ xi³nu³ 'a²³jia'³ rɨ²³núu²³ 'e³ la²³ jua'³ dsa³ 'í³, rɨ²juɨɨ'n³¹ la²³jɨn³ dsa³ quien³² Dios. 'E³ quie'²³ xi³nu³ jmee²³ quie'²³ 'e³ 'a²³jia'³ rɨ²³núu²³, juø'n³ quie'²³ 'e³ la²³ jua'³ la²³jɨn³ dsa³ quien³² Dios, rɨ²jmee'³¹ra'³ 'e³ la²³ jmee'³²ra'³ dsa³ jia'³, 'e³ la²³ jmee'³²ra'³ 'io'². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: La²³jɨ³ 'e³ 'a²³jia'³ rɨ²mi³'ien²³na'³ júu² mɨ³¹güii³ la³, rɨ²³cuaa'n²³ 'e³ 'a²³jia'³ rɨ²³'ien³ júu² yʉʉ'³¹ güii³. 'E³ quie'²³ la²³jɨ³ 'e³ rɨ²mi³'ien²³na'³ júu² mɨ³¹güii³ la³, rɨ²³cuaa'n²³ 'e³ mɨ³'ien³ júu² yʉʉ'³¹ güii³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Co̱'³ cɨ'²³ rɨ²juøøn³¹na¹ 'nee'²³: Xi³nu³ xen³ áan²³na'³ 'e³ jmee³ra'³ co̱o̱³ júu² mɨ³¹güii³ la³ 'e³ jmii'³¹ rɨ²ŋɨɨ'³¹ra'³ Dios, 'e³ jo̱³ rɨ²³jmée²³ Ñu'n²³ 'i³ jen³¹ yʉʉ'³¹ güii³ 'e³ la²³ ŋɨɨ³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Qui² je² xen³ áan²³ aan³ dsa³ 'i³ mɨ³ŋɨɨ'n²³ 'e³ jua'³te'²³ rɨ³løn³¹te'¹ dsa³ quién²³na²³, núu²³ jen³¹na¹ quia̱'n²³²na¹te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","'E³ quie'²³ ca²³lǿn²³ mɨ³lén² Peen²³² caan²³ Jesús. Ca²³jua'³: ―Juiin²³. ¿Jo'² dxa³ líi² rɨ²³jme'²³ jnee'³¹ uu'n²na'³¹ 'e³ quie'²³ 'ne'² rɨ²jmee²quie¹ra'³¹ u²³juee'³ dsɨɨ³² rɨ²nen²³²na'³¹? ¿'A² 'ne'² rɨ²jmee²ra'³¹ u²³juee'³ dsɨɨ³² guiáa²³ dxa³? ");
INSERT INTO cnlNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","'E³ quie'²³ ca²³jua'³ Jesús: ―'A²³jia'³ rɨ²³líi² guiáa²³ dxa³ xú̱n³. 'E³ quie'²³ ñúun³ cɨ² ma²³'nee³ la²³ cɨ'²³ la'³ 'e³ 'ne'². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³: Xen³ la²³ xen³ jø̱n³ rey 'i³ ca²³la²³'née²³ 'e³ rɨ²³jmée²³ cua̱a̱n²tu² quie'² te'²³ mozos quien³² 'i³ ya̱'n³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","'E³ la²³ láa²³ ca²³jmée³ cua̱a̱n²tu², i²jøn²³te'²³ xi²ñi² 'ñée² jø̱n³ dsa³ 'i³ ñúun³ millones pesos ya̱'n³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","'E³ quie'²³ 'a²³jia'³ ca²³lǿ²³ juø'² ca²³quí² dsa³ 'í³. 'E³ jo̱³ ca²³dxi³ 'i'²³ juii² 'e³ rɨ²³'nɨ́ɨn²³te'²³ dsa³ 'í³ ca³ti³² quia̱'² mɨ²³quie'² quia̱'² jo̱o̱³¹ quia̱'² la²³jɨ³ 'e³ xa³ quie'² 'e³ la²³ rɨ²³quí² dsoo². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","'E³ jo̱³ ca²³xii'³ jñi² mozo 'í³. Ca²³ŋɨ́ɨ³ mɨ²'áa² quie'² juii². Ca²³jua'³: “Juiin²³. Rɨ²jméen² co̱o̱³ mɨ²'áa² rɨ²cǿ̱n² u²³juee'³ dsɨɨ³² rɨ²mǿn¹nu³ jné². Qui² rɨ²cɨn³¹ la²³jɨ³ sú̱n² 'e³ ya̱'n³na²³ quién²nu³ 'u².” ");
INSERT INTO cnlNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","'E³ jo̱³ ca²³la²³cuu'²³ dsɨ́² juii² mozo 'í³. Ca²³láan² mozo. Ca²³yúun² la²³jɨ³ dsoo² 'e³ ya̱'n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","'E³ la²³ ca²³bǿn³ mozo 'í³, ca²³jí̱i̱n³ jia'³ cɨ'²³ mozo 'e³ la²³ co̱o̱³ uu'n². Ya̱'n³ dsa³ 'í³ ca³tú̱²³ pesos quie'². So̱'²³ lúu² uu'n² 'i³ ya̱'n³ quie'². Ca²³jua'³: “Qui² la²³jɨ³ 'e³ ya̱'n³nu³ quián²³”. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","'E³ quie'²³ ca²³quiaa³ rɨ³'in³² dsa³ 'i³ ya̱'n³ ca³tú̱²³ pesos. Ca²³ŋɨ́ɨ³ mɨ²'áa² quie'². Ca²³jua'³: “Rɨ²jméen² co̱o̱³ mɨ²'áa² rɨ²cǿ̱n² u²³juee'³ dsɨɨ³² rɨ²mǿn¹nu³ jné². Qui² rɨ²cɨn³¹ la²³jɨ³ sú̱n² 'e³ ya̱'n³na²³ quién²nu³ 'u².” ");
INSERT INTO cnlNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","'E³ quie'²³ 'a²³jia'³ có̱²³ u²³juee'³ dsɨɨ³² dsa³ 'i³ 'íi² quie'². Ca²³dxi³ 'i'²³ 'e³ rɨ²³ta̱a̱'n³te'²³ i²³ñí² uu'n². 'Í² i²³ñí² la²³huø'n²³ 'e³ 'íi² rɨ²³quí² dsoo². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ŋó²³ te'²³ jia'³ cɨ'²³ mozos la²³ co̱o̱³ uu'n² 'e³ jmii'³¹ ca²³jmée³. 'E³ jo̱³ ca²³ŋɨ́³ dsɨ́²te'²³. I²guín¹ i²xii'²³²te'¹ juii²te'¹ la²³jɨ³ 'e³ ca²³jmée³. ");
INSERT INTO cnlNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","'E³ jo̱³ tǿ²³ co̱'³ juii². Ca²³tøø³ mozo 'i³ 'a²³jia'³ rɨ²³có̱² u²³juee'³ dsɨɨ³². Ca²³jua'³: “Mozo quién²³na²³. Bi²³ tu³cua̱a̱n²tu² mɨ³jméen². Mɨ³yuun²³²na¹ la²³jɨ³ sú̱n² dsoo² 'e³ ca²³ya̱'n³nu³ quián²³ 'e³ la²³ mɨ³ŋɨ'n²nu³ jné² mɨ²'áa² 'u². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","'Ne'² 'e³ li²³cuu'²³ 'áan² quia̱'n²nu³ mozo la²³ co̱o̱³ uu'n²nu³ co̱'³ 'u², 'e³ la²³'nɨɨ'n³¹ 'e³ mɨ³la³cuu'²³ dsɨn²³ quia̱'n²³²na¹ 'nʉ³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bi²³ ca²³ti̱'n³ juii² mozo. Ca²³dxi³ 'i'²³ 'e³ rɨ²³jme'²³te'²³ mozo 'í³ 'e³ la²³ 'iún² i²³ñí² la²³huø'n²³ 'e³ 'íi² rɨ²³quí² la²³jɨ³ sú̱n² dsoo² 'e³ ya̱'n³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","'E³ jo̱³ ca²³jua'³ Jesús: ―'E³ quie'²³ la'³ rɨ²³jmée²³ Ñu'n²³ 'i³ jen³¹ yʉʉ'³¹ güii³ xi³nu³ 'a²³jia'³ rɨ²jmée²ra'³ u²³juee'³ dsɨɨ³² rɨ²mǿn¹na'³ uu'n²na'³ 'e³ dxaa'n³¹ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ma²ca¹líi¹ ca²³lʉ́³ la'³ Jesús, ca²³bǿn³ co̱'³ estado Galilea. Ŋóo² la²³ca̱a̱n³ je² røøn³ estado Judea 'ŋóo² la²³ jmɨɨ³ juee'³ Jordán. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³qui̱'³. Ca²³mi²³'láan³ te'²³ dsa³ 'í³ je² núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Xen³ dsa³ fariseo 'i³ ca²³lǿn²³ mɨ³lén². 'Née²³te'²³ rɨ²³jáan²³te'²³ júu² quiee'³². 'E³ jo̱³ ca²³jua'³te'²³: ―¿Jmii'³¹ juø'n³ 'nʉ³? ¿'A² joo'²³ 'e³ rɨ²³tʉ́n² dsa³ mɨ²³quie'² xi³nu³ te³ jmii'³¹ lǿ² sɨ³lí³ quie'²te'²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'A² 'a²³jia'³ lɨ'³ ca³jóo²ra'³ ji³ je² jua'³ 'e³ mɨ²xe̱'n³¹ ca²³jmén² dsa³ Dios dsóo²³ quia̱'² mɨ́³? ");
INSERT INTO cnlNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Co̱'³ cɨ'²³ ca²³jua'³: “Tʉn³² dsa³ xóo² jmii³. Sɨ³lí³ 'e³ rɨ³sø̱'n² quia̱'² mɨ²³quie'². Áan²³ dsa³ sɨ³lín³ 'é̱e̱² 'e³ jø̱n³ dsa³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","'E³ jo̱³ 'a²³jia'³ ma²³ rɨ³løn³¹ áan²³te'²³. 'E³ quie'²³ rɨ³løn³¹te'¹ 'é̱e̱² 'e³ jø̱n³ dsa³. Dios 'i³ ca²³jmée³ 'e³ rɨ³sø̱'n²te'²³. 'E³ jo̱³ 'a²³jia'³ joo'²³ 'e³ rɨ²³dxáan² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Ca²³dxi³ 'i'²³ Moisés, ¿mɨ³naa'³¹?, 'e³ rɨ²³jmée²³ dsa³ co̱o̱³ ji³ 'e³ rɨ²³cuǿø²³ mɨ²³quie'² 'e³ jua'³ tʉn³². La'³ cu³lø³¹ rɨ²³jmée²³ 'e³ cu²bǿn³ mɨ́³. ¿'Ee² lǿ² ca²³dxi³ 'i'²³ la'³ Moisés jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","'E³ jo̱³ ca²³jua'³ Jesús: ―Bi²³ rɨ³laa³ 'óo²ra'³. 'E³ jo̱³ hua² 'e³ ca²³cuǿ³ júu² Moisés 'e³ rɨ²tún¹na'³ mɨ²³quién²na'³. 'E³ quie'²³ 'a²³jia'³ lǿ² la'³ mɨ²xe̱'n³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Rɨ²juøøn³¹na¹ 'nee'²³: Jmee²³ ñi³ dxa³ dsóo²³ 'i³ tʉn³² mɨ²³quie'² 'i³ rɨ²³tǿø²³ jia'³ cɨ'²³ mɨ́³ xi³nu³ 'a²³la³ jo̱³ 'e³ mɨ³ta̱a̱'n³ 'ñée² mɨ²³quie'² quia̱'² jia'³ cɨ'²³ dsóo²³. 'E³ quie'²³ la'³, jmee²³ ñi³ dxa³ dsóo²³ 'i³ rɨ²³tǿø²³ mɨ́³ 'i³ ca²³tʉ́n²te'²³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","'E³ jo̱³ ca²³jua'³ dsa³ quien³²: ―Xi³nu³ la'³ cu³lø³¹ quie'² dsa³ quia̱'² mɨ²³quie'², bi²³ cɨ² dxʉ́²³ 'e³ 'a²³jia'³ rɨ²³tǿø²³ dsa³ mɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ quien³²: ―'A²³la³ la²³jɨn³ dsa³ 'i³ rɨ²³lí³ juø'² rɨ²³jmóo² 'e³ la²³ mɨ³jua'²ra'³. 'Nɨɨ'n³¹ dsa³ 'i³ mɨ³'ioo³² ju²³bíi²³ 'e³ lø³² la'³ 'i³ rɨ²³lí³ juø'² rɨ²³jmóo² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Qui² xen³ dsa³ 'i³ lǿn²³ quie'²³ ca²³la²³xen³ 'e³ 'é̱e̱² 'e³ te'n²³. 'E³ quie'²³ xen³ dsa³ 'i³ ca²³mi²³te'n²³te'²³. 'E³ quie'²³ xen³ dsa³ 'i³ 'née²³ 'e³ 'a²³jia'³ li²³quia̱'² mɨ́³ 'e³ jua'³ rɨ³løn³¹ juii²te'¹ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. 'E³ quie'²³ cu²jmóo¹ la'³ dsa³ 'i³ xa³ ju²³bíi²³ quie'² 'e³ rɨ²³lí³ juø'² rɨ²³jmóo² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Xen³ dsa³ 'i³ i²jøn²³te'²³ xii'³ pii'² caan²³ Jesús 'e³ jua'³ 'née²³te'²³ 'e³ rɨ²³dxá²³ guoo³ ñi'² quiee'³²te'²³, 'e³ jua'³ 'née²³te'²³ 'e³ rɨ²³lʉ́²³ quia̱'² Dios. 'E³ quie'²³ ca²³jíi² te'²³ dsa³ quien³², ca²³jín² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","'E³ quie'²³ ca²³jua'³ Jesús: ―Cu²ja³guín²³ caan²³na²³ te'²³ xii'³ pii'². 'A²³ rɨ³jníin²na'³ quie'²te'²³. Qui² Dios 'i³ jen³¹ yʉʉ'³¹ güii³ rɨ³løn³¹ juii² dsa³ 'i³ xen³ la²³ xen³ xii'³ pii'². ");
INSERT INTO cnlNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","'E³ quie'²³ jo̱³ ca²³dxá³ guoo³ ñi'² quiee'³²te'²³. Jo̱³ tu³ ŋóo² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Xen³ jø̱n³ dsa³ 'i³ ca²³lǿn²³ mɨ³lén². Ca²³jua'³: ―Dsa³ 'e²³ 'i³ dxún²³. ¿'Ee² 'noo³¹ 'e³ dxʉ́²³ 'e³ 'ne'² rɨ²jmeen²³² 'e³ la²³ rɨ³ji̱'n²³na²³ ca³cuaa³? ");
INSERT INTO cnlNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'Ee² lǿ² juɨɨ'n³²nu³ jné² 'i³ dxún²³? Jø̱n³ hua² xen³ 'i³ dxún²³. Dios hua² 'í³. 'E³ quie'²³ xi³nu³ 'naan³ 'e³ rɨ³ji̱i̱'n²³nu³ ca³quie̱e̱², 'ne'² rɨ²jméen² 'e³ la²³ dxi³ 'i'²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","'E³ jo̱³ ca²³jua'³ dsa³ 'í³: ―¿'Ee² júu² 'e³ dxi³ 'i'²³ Dios 'e³ 'ne'² rɨ²jmeen²³² jo̱o̱²³na²³? 'E³ jo̱³ ca²³jua'³ Jesús: ―'A²³ rɨ³jmee³ra'³ 'móo². 'A²³ rɨ³jmee³ra'³ ñi³ dxa³. 'A²³ rɨ³jmee³ra'³ 'i̱i̱³. 'A²³ rɨ³júu²ra'³ mɨ³rɨ³lin³na'³ dsa³ ñi³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Rɨ²'óo²ra'³ u²³go³ u²³'iʉʉ²³ quia̱'n²na'³ xoo³ra'³ ñʉ'²ra'³. 'Ne'² li²³'náan²³na'³ uu'n²na'³ 'e³ la²³'nɨɨ'n³¹ 'e³ 'náan²³na'³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","'E³ jo̱³ ca²³jua'³ xii'³ 'í³: ―Jmeen²³ la²³jɨ³ 'e³ lø³² la²³nɨ³ cɨ'²³ la²³ pi'n²³²na¹. ¿'Ee² cɨ² 'noo³¹ 'e³ 'ne'² 'e³ rɨ²jmeen²³² jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","'E³ jo̱³ ca²³jua'³ Jesús: ―Xi³nu³ 'naan³ 'e³ 'a²³jia'³ ma²³ li²³xa³ cɨ² 'e³ jmee²³ jloo'² quién²nu³, guaan³² cu³'nɨ́ɨn² 'e³ xa³ quién²nu³. Rɨ²cuøøn³¹ dsa³ taan³ jñii³¹. Jo̱³ hua² ñúun³ la²³jɨ³ 'e³ quí̱i̱n²³ 'e³ li²³xa³ quién²nu³ yʉʉ'³¹ güii³. 'E³ quie'²³ jo̱³ ñe³ rɨ²ŋɨ́n² quia̱'n²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma²ca¹núu³ xii'³ 'e³ la²³ ca²³jua'³ Jesús, bi²³ ŋɨ́³ dsɨ́² 'e³ ŋø'n² quie'². Qui² bi²³ ñúun³ la²³jɨ³ 'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ quien³²: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Bi²³ gáan³ dxíi³ 'e³ rɨ²³lín³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³ juii² dsa³ xoo³². ");
INSERT INTO cnlNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Rɨ²juøøn³¹na¹ 'nee'²³ co̱'³: 'A²³jia'³ juo²³ rɨ²³ŋɨ́n³ guo² me²³cuu² roo'³² camello. 'E³ quie'²³ bi²³ cɨ² 'a²³jia'³ juo²³ rɨ²³lín³ Dios juii² te'²³ dsa³ xoo³². ");
INSERT INTO cnlNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bi²³ juø'²³ ca²³núu³ dsa³ quien³² 'e³ la²³ lǿ² ca²³lʉ́³ Jesús. 'E³ jo̱³ ca²³jua'³te'²³: ―¿'I̱i̱² sɨɨ'³¹ 'i³ rɨ²³lí³ juø'² rɨ²³láan³ jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","'E³ jo̱³ ca²³jóon² dsa³ quien³². Ca²³jua'³: ―'A²³jia'³ jmɨ́ɨ² rɨ²³li'²³ juø'² dsa³. 'E³ quie'²³ sɨ³li'²³ juø'² Dios la²³jɨ³ quie'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","'E³ jo̱³ ca²³jua'³ Peen²³²: ―Mɨ³cuaa'n²³²na'³¹ jnee'³¹ la²³jɨ³ 'e³ xa³ quiée²ra'³¹ 'e³ ŋɨ²ra'³¹ quia̱'n²na'³¹ 'nʉ³. ¿'Ee² 'noo³¹ li²³xa³ quiée²ra'³¹ jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'E³ cɨ² rɨ²ñin²³² sii³¹ 'e³ gáan³ ma²³'nee³ mɨ³rɨ³'ioo³ra² je² 'mɨ́ɨn² la²³jɨ³. 'E³ la²³ jen³¹na¹ la'³ jné² Jo̱o̱³¹ Dsa³, 'e³ jo̱³ rɨ²ñí²ra'³ gui²³tʉ̱́³ sii³¹ gáan³ 'nee'²³ 'i³ ŋɨ́²ra'³ quia̱'n²na'³ jné². Rɨ²jmée²ra'³ 'i'²³ xi² xa³ dsoo² quiee'³² la²³jɨ³ gui²³tʉ̱́³ ta'n² dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bi²³ ñúun³ li²³xa³ quie'² dsa³ 'i³ mɨ³cuaa'n³ 'ñʉ́², 'i³ mɨ³cuaa'n³ jó̱o̱², 'i³ mɨ³cuaa'n³ xóo² jmii³, 'i³ mɨ³cuaa'n³ mɨ²³quie'², 'i³ mɨ³cuaa'n³ jo̱o̱³¹, 'i³ mɨ³cuaa'n³ 'uǿ²³ quiee'³² 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³. Bi²³ cɨ² ñúun³ li²³xa³ la²³ cɨ'²³ 'e³ mɨ³cuaa'n³. Co̱'³ cɨ'²³, rɨ³ji̱'²³ ca³cuaa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","'E³ quie'²³ 'e³ cɨ² rɨ²³lín³ 'i³ pii'² cɨ² juɨ́ɨn²³ dsa³ 'i³ rɨ³løn³¹ 'i³ gáan³ cɨ² rɨ³nɨ²³. 'E³ quie'²³ la'³ 'e³ cɨ² rɨ²³lín³ 'i³ gáan³ cɨ² juɨ́ɨn²³ dsa³ 'i³ rɨ³løn³¹ 'i³ pii'² cɨ² rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. Xen³ la²³ xen³ jø̱n³ juii² 'uǿ²³ 'i³ ŋóo² xe̱'n² tá³ 'e³ jua'³ rɨ²³'náan²³ mozos 'i³ rɨ²³jmóo² ta² je² rɨ³jne² xoo'³¹ jø'² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","'E³ quie'²³ ca²³mi²³'ien³ júu² quia̱'² mozos 'e³ rɨ²³cuǿ²³ la²³'nɨɨ'n³¹ 'e³ cuø²³ dsa³ 'e³ co̱o̱³ jmɨ́ɨ². 'E³ jo̱³ ca²³xíin²³ mozos 'e³ sɨ³jmóo²te'²³ ta² je² rɨ³jne² xoo'³¹ jø'² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","'E³ quie'²³ ŋóo² co̱'³ la²³ca̱a̱n³ hora 'e³ ñʉ́²³ i²³'áa³. Ca²³ti²³cø̱n³¹ jia'³ cɨ'²³ dsa³ 'i³ té̱e̱n³ je² dxa²³ dsa³ 'moo'². 'A²³'e³ ta² xa³ jmoo³² dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: “Cu³guín²³na'³ 'nee'²³ co̱'³ je² rɨ³jne² xoo'³¹ jø'² quián²³. Rɨ²cɨn³¹ jñiin²³na'³ 'e³ la²³'nɨɨ'n³¹ 'e³ dxi³ji̱i̱n³¹.” 'E³ jo̱³ ca²³guín²³ te'²³ dsa³ 'í³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Xen³ jia'³ cɨ'²³ co̱'³ 'i³ ca²³'náan²³ la²³ca̱a̱n³ dxaan²³ ñi'². 'E³ quie'²³ la'³, xen³ cɨ² co̱'³ 'i³ ca²³'náan²³ hora 'e³ 'nɨ³ mɨ³cu³'lóo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ŋóo² co̱'³ cɨ'²³ la²³ca̱a̱n³ hora 'e³ 'ñé³ mɨ³cu³'lóo³. Ca²³ti²³cø̱n³¹ cɨ² jia'³ cɨ'²³ dsa³ 'i³ té̱e̱n³ jee²³². 'A²³'e³ ta² xa³ jmoo³². 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: “¿'Ee² lǿ² 'e³ té̱e̱n³na'³ je² la³ 'e³ sɨ³'láa³ jmɨ́ɨ² mi'³ 'e³ 'a²³jia'³ jmee³ra'³ ta²?” ");
INSERT INTO cnlNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","'E³ jo̱³ ca²³jua'³ dsa³ 'í³: “'A²³'i̱³ xen³ dsa³ 'i³ ca²³'náan²³ jnee'³¹”. 'E³ jo̱³ ca²³jua'³ juii² 'uǿ²³: “Cu³guín²³na'³ 'nee'²³ co̱'³ je² rɨ³jne² xoo'³¹ jø'² quián²³. Rɨ²cɨn³¹ jñiin²³na'³ 'e³ la²³'nɨɨ'n³¹ 'e³ dxi³ji̱i̱n³¹.” ");
INSERT INTO cnlNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ma²ca¹nʉʉ³, ca²³jua'³ juii² 'uǿ²³, ca²³sɨ'²³ mozo 'i³ rɨ³løn³¹ juii² ta² 'i³ 'iún² jee²³²: “Rɨ²juɨɨ'n³¹ te'²³ mozos 'e³ rɨ²³ja²³guiin³². Rɨ²cɨ́n² jñiin²³te'²³ jo̱o̱²³na²³. 'I³ mɨ³dxi³guín²³ cɨ̱ɨ̱n³ cɨ² 'i³ rɨ²cɨ́n² jñiin²³ xe̱'n². 'E³ quie'²³ rɨ²cɨ́n²quien²³nu³ la'³ jñiin²³te'²³ 'i³ mɨ³dxi³guín²³ jén²³ cɨ² co̱'³. Je² dsøn³ rɨ²cɨ́n² jñiin²³ 'i³ mɨ³dxi³guín²³ xe̱'n² tá³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ma²ca¹dxi¹guiin³² te'²³ mozos 'i³ ca²³'náan²³ hora 'e³ 'ñé³ mɨ³cu³'lóo³, 'ióo²te'²³ 'e³ la²³'nɨɨ'n³¹ 'e³ cuø²³ dsa³ 'e³ co̱o̱³ jmɨ́ɨ² cɨ'³ la²³ jø̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ca²³dxi²³guiin³² mozos 'i³ ca²³guín²³ xe̱'n² tá³ co̱'³. Lǿn³ miin²³ 'e³ dsɨ³² cɨ² rɨ²³'ióo²³te'²³. 'E³ quie'²³ 'ióo²te'²³ 'e³ la²³'nɨɨ'n³¹ 'e³ cuø²³ dsa³ 'e³ co̱o̱³ jmɨ́ɨ² cɨ'³ la²³ jø̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ma²'ioo³¹te'¹ la'³, bi²³ ca²³mɨ'n³te'²³ ca²³lʉ́³te'²³ ca²³sɨ'²³te'²³ juii² 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ca²³jua'³te'²³: “Co̱o̱³ hora qui³ mɨ³jmóo² ta² dsa³ la³ 'i³ mɨ³dxi³guín²³ cɨ̱ɨ̱n³ cɨ². 'E³ quie'²³ røø³ mɨ³quín² quiée²ra'³¹, juø'n³ quie'²³ rɨ³ca̱'n²³ jmɨ́ɨ² la²³ cɨ² mɨ³dxi³quié̱n²na'³¹ je² dxíi³ 'ioo³ 'e³ mɨ³jmee²ra'³¹ ta².” ");
INSERT INTO cnlNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","'E³ quie'²³ ca²³jua'³ juii² 'uǿ²³. Ca²³sɨ'²³ jø̱n³ dsa³ 'i³ ca²³lʉ́³ la'³: “Amigo. 'A²³'e³ xa³ 'e³ mɨ³jme'n²³na²³ 'nʉ³. Qui² mɨ³mi³'ien²³na²³ júu² quia̱'n²³²na¹ 'nʉ³ xe̱'n² 'e³ rɨ²cuǿøn¹na²³ 'nʉ³ 'e³ la²³'nɨɨ'n³¹ 'e³ cuø²³ dsa³ 'e³ co̱o̱³ jmɨ́ɨ², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Quie̱³ quién²nu³ 'e³ ya̱'n³nu³ 'e³ rɨ²cǿ̱n², 'e³ la²³'nɨɨ'n³¹ 'e³ co̱o̱³ jmɨ́ɨ² ta². Guø'n³ quién²nu³. 'Náan²³ 'e³ rɨ²cɨn³¹ quie'² 'i³ la³ 'i³ mɨ³dxóo² cɨ̱ɨ̱n³ cɨ² 'e³ la²³'nɨɨ'n³¹ 'e³ mɨ³cɨ́n² quién²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿'A² 'a²³jia'³ joo'²³ rɨ²cuøn²³² 'e³ xa³ quián²³ 'e³ la²³ 'náan²³? ¿'A² juø'² mɨ'n³nu³ 'e³ juø'n³ bi²³ 'uøn²³²na¹?” ");
INSERT INTO cnlNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","La²³nɨ³ cu³lø³¹ 'e³ rɨ²³lín³ 'i³ pii'² cɨ² dsa³ 'i³ rɨ³løn³¹ 'i³ gáan³ cɨ² rɨ³nɨ²³. 'E³ quie'²³ la'³, rɨ²³lín³ 'i³ gáan³ cɨ² dsa³ 'i³ rɨ³løn³¹ 'i³ pii'² cɨ² rɨ³nɨ²³. Qui² juɨ́ɨn²³ 'i³ ca²³tøø³ Dios 'u². 'E³ quie'²³ 'a²³jia'³ juɨ́ɨn²³ 'i³ ca²³'náan²³ 'e³ rɨ²³lín³ 'i³ gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","'E³ la²³ 'iún² jui³¹ Jesús 'e³ dsoo³² juɨɨ³ Jerusalén, ca²³jén²³ ca³jné³ dsa³ gui²³tʉ̱́n³ quien³². Ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ");
INSERT INTO cnlNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Sɨ³gui²³²ra² juɨɨ³ Jerusalén, ¿mɨ³naa'³¹? 'E³ quie'²³ je² núu²³ rɨ²³jɨ̱'n²te'²³ jné² Jo̱o̱³¹ Dsa³ quie'² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley. Te'²³ 'i³ 'í³ hua² 'i³ rɨ²³dxi³ 'i'²³ 'e³ cu²jú̱n³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Rɨ²³jɨ̱'n²te'²³ jné² quie'² dsa³ jia'³ 'e³ cu²jáa¹ cu²ŋɨ́ɨn¹te'²³ jné², 'e³ cu²jmín¹te'²³ jné², 'e³ cu²te̱e̱n³te'²³ jné² cruz. 'E³ quie'²³ je² rɨ²³tɨ́²³ 'nɨ³ jmɨ́ɨ² 'e³ la²³ jú̱n²³na²³ rɨ²³ji̱i̱'n²³na²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ca²³lǿn²³ mɨ³lén² caan²³ Jesús xóo² Jacobo quia̱'² Juan, te'²³ jo̱²³ñʉʉ'³¹ Zebedeo, ca³ti³² quia̱'² jo̱o̱³¹. Ca²³xii'³ jñi² xi²ñi² Jesús. Ca²³ŋɨ́ɨ³ mɨ²'áa². ");
INSERT INTO cnlNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³ 'í³: ―¿'Ee² 'noo³¹ 'naan³ jo̱o̱²³na²³? 'E³ jo̱³ ca²³jua'³ mɨ́³: ―Rɨ²jméen² co̱o̱³ mɨ²'áa² 'e³ rɨ²dxín² 'i'²³ 'e³ rɨ²³gua³ te'²³ ja̱a̱n²³ la³ jaan²³nu³ i²³la³ i²³nɨ³ je² jen³¹nu³ 'uǿøn² mɨ³rɨ³ti³ 'e³ rɨ²³lín³nu³ rey. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","'E³ quie'²³ ca²³jua'³ Jesús: ―'A²³jia'³ ta³jmee³ra'³ 'i'²³ 'e³ jmii'³¹ cu³lø³¹ 'e³ ŋɨɨ³ra'³. ¿'A² rɨ²³lí³ juø'² rɨ²³tén²na'³ xi³nu³ rɨ²³dxi²³quié̱n²na'³ 'e³ la²³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³dxi²³quié̱n²na²³ 'ñáan²³? 'E³ jo̱³ ca²³jua'³te'²³: ―Rɨ²³lí³ juø'² xú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ²³dxi²³quié̱n²na'³ 'e³ la²³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³dxi²³quié̱n²na²³ 'ñáan²³ xú̱n³. 'E³ quie'²³ 'a²³jia'³ née² guaan²³ jné² 'e³ rɨ²dxin²³² 'i'²³ 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³gua³ jaan²³na²³ i²³la³ i²³nɨ³ je² jen³¹na¹. 'E³ quie'²³ rɨ²³gua³ dsa³ 'i³ mɨ³'náan²³ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","'E³ quie'²³ jo̱³ bi²³ ca²³mɨ'n³ te'²³ dsa³ quien³² 'i³ guién²³ ñin³² Jacobo quia̱'² Juan la²³ ca³já̱a̱n² ma²ca¹núu³te'²³ 'e³ jmii'³¹ cu³lø³¹ ca²³ŋɨ́ɨ³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","'E³ jo̱³ tǿ²³ Jesús. Ca²³tøø³ dsa³ quien³². Ca²³jua'³: ―Móo³ra'³ 'e³ bi²³ la²³dxi³ 'i'²³ dsa³ 'i³ ta'n² ta² jee²³² quiee'³² dsa³ jia'³. Bi²³ 'uee'n³ jmoo³² dsa³ 'i³ gáan³ jee²³² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","'A²³jia'³ 'ne'² 'e³ rɨ²³lí³ la'³ jee²³² quien³²na'³. Qui² 'ne'² rɨ²³lín³na'³ mozos 'i³ mi³quin³ uu'n² 'nee'²³ 'i³ 'née²³ rɨ²³lín³ 'i³ gáan³ jee²³² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","'E³ quie'²³ la'³, 'ne'² rɨ²³lín³na'³ mozos 'i³ 'uǿn²³ cɨ² 'i³ rɨ²³mi²³quin³ uu'n² 'nee'²³ 'i³ 'née²³ rɨ²³lín³ 'i³ gáan³ cɨ² jee²³² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Qui² la'³ jmeen²³ jné² Jo̱o̱³¹ Dsa³. 'A²³la³ jo̱³ 'e³ juø'n²³ 'náan²³ 'e³ li²³xen³ 'i³ rɨ²³mi²³quin³ jné² 'e³ güén²³na²³ mɨ³¹güii³. 'E³ quie'²³ güén²³na²³ 'e³ rɨ²mi³quin²³na²³ dsa³. Güén²³na²³ 'e³ rɨ²³jú̱n³na²³ 'e³ rɨ²løn³¹na¹ juɨ́ɨn²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","'E³ la²³ ca²³bǿn³ Jesús quia̱'² dsa³ quien³² juɨɨ³ Jericó, bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³qui̱'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Xen³ áan²³ dsa³ tuu² 'i³ nee'n²³² coo³¹ jui³¹. Ca²³núu³te'²³ 'e³ sɨ³ŋɨ́n³ Jesús. 'E³ jo̱³ quiʉ̱ʉ̱³ ca²³lʉ́³te'²³. Ca²³jua'³te'²³: ―Juii³ra'³¹, dsa³ ju̱u̱n²³ David, cu²li³cuu'²³ 'áan² quia̱'n²nu³ jnee'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'E³ jo̱³ ca²³jíi² dsa³, ca²³jín²te'²³ dsa³ tuu². Ca²³sɨ'²³te'²³ 'e³ cu²quín³. 'E³ quie'²³ dsɨ³² cɨ² ca²³lʉ́³ miin²³. Ca²³jua'³te'²³: ―Juii³ra'³¹, dsa³ ju̱u̱n²³ David. Cu²li³cuu'²³ 'áan² quia̱'n²nu³ jnee'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","'E³ jo̱³ ca²³noo³ Jesús. Ca²³tøø³ dsa³ tuu². Ca²³jua'³: ―¿Jmii'³¹ cu³lø³¹ 'e³ 'noo³ra'³ 'e³ rɨ²jmeen²³² quién²na'³? ");
INSERT INTO cnlNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","'E³ jo̱³ ca²³jua'³te'²³: ―Juii³ra'³¹, 'nee³ra'³¹ 'e³ li²³jné²³ mɨ²ñí²ra'³¹ 'u². ");
INSERT INTO cnlNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ca²³la²³cuu'²³ dsɨ́² Jesús. 'E³ jo̱³ ca²³quiʉ̱'² mɨ²xi¹guoo³ mɨ²ñi² dsa³ tuu². Xe̱'n² jmɨ́ɨ² ca²³la²³jné³ mɨ²ñi²te'¹. 'E³ jo̱³ ca²³qui̱i̱³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ca²³lǿn²³te'²³ mɨ³lén² juɨɨ³ Jerusalén. Ca²³dxi²³guín²³te'²³ juɨɨ³ Betfagé coo³¹ mo'³ Olivos. Ca²³xíin²³ Jesús áan²³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ca²³sɨ'²³ dsa³ 'í³: ―Cu³guín²³na'³ jee²³² juɨɨ³, tu³'o³ la²³ xi²ñí²ra'³. Xe̱'n² mɨ³rɨ³taa'n³²na'³ jee²³² juɨɨ³ rɨ²møn²³na'³ jø̱n³ burra 'i³ rɨ³'ñu'n² ca³ti³² quia̱'² jø̱n³ jo̱o̱³¹. Rɨ²ji̱i̱n²³na'³ te'²³ burro. Rɨ²jøn²³na'³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Xi³nu³ xen³ dsa³ 'i³ rɨ²³lʉ́²³ quia̱'² 'nee'²³, rɨ²juɨɨ'³¹ra'³ dsa³ 'í³: “'Ne'² quie'² Juii³ra², ¿mɨ³naa'³¹? 'E³ quie'²³ ca³'ee²³² cɨ² rɨ²³xíin²³ mozos 'i³ rɨ²³gui²³jáan³ co̱'³.” La'³ rɨ²juɨɨ'³¹ra'³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","La'³ cu³lø³¹ ca²³lǿ²³ 'e³ la²³ rɨ²³lí³ 'e³ la²³ ca²³jua'³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² 'e³ rɨ²³lí³. Qui² ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Rɨ²juɨɨ'³¹ra'³ dsa³ 'i³ nee'n²³² juɨɨ³ Sión: “Ja³'ɨ́ɨn²³ rey quien³²na'³. Bi²³ mi³'uǿn²³ 'ñée². Cu³dsɨn³¹ burro. Cu³dsɨn³¹ jo̱o̱³¹ roo'³² 'i³ jnɨ³² láa².” La'³ cu³lø³¹ ca²³jua'³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ca²³guín²³ dsa³ quien³² Jesús. Ca²³jmóo²te'²³ 'e³ la²³ ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ca²³gui²³guiin³² co̱'³ quia̱'²te'²³ burra 'i³ quia̱'² jo̱o̱³¹. Ca²³dxá³te'²³ 'mɨɨ'³ quiee'³²te'²³ ñi'² quiee'³². 'E³ quie'²³ jo̱³ ca²³gua³ Jesús ñi'² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bi²³ juɨ́ɨn²³ dsa³ 'i³ ca²³ti²³jó³ 'mɨɨ'³ quiee'³²te'²³ jui³¹ je² rɨ²³ŋɨ́n³. 'E³ quie'²³ xen³ 'i³ ca²³quiʉ'² guoo³ 'mo³ 'e³ ca²³ti²³jó³te'²³ dxi²jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bi²³ juɨ́ɨn²³ dsa³ 'i³ sɨ³jén². 'E³ quie'²³ la'³ 'i³ tu³cɨ̱ɨ̱n³ co̱'³. Quiʉ̱ʉ̱³ ca²³lʉ́³te'²³. Ca²³jua'³te'²³: ―¡Que viva dsa³ ju̱u̱n²³ David! ¡Mɨ³cuǿ³ Dios u²³li²³jé̱e̱³ quie'² dsa³ la³ 'i³ ja³'ɨ́ɨn²³ 'e³ 'iin³¹ Dios Juii³ra²! ¡Que viva Dios 'i³ jen³¹ yʉʉ'³¹ güii³! ");
INSERT INTO cnlNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bi²³ tin²³te'²³ ta² júu² i²³la³ i²³nɨ³ 'e³ la²³ 'í² Jesús jee²³² juɨɨ³ Jerusalén. Ca²³jua'³te'²³: ―¿'I̱i̱² hua² sɨɨ'³¹ nɨ³ cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","'E³ jo̱³ ca²³jua'³ la²³jɨn³ dsa³: ―Jesús, dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios hua² nɨ³, ¿mɨ³naa'³¹? dsa³ 'i³ xen³ juɨɨ³ Nazaret estado Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","'E³ quie'²³ jo̱³ 'í² Jesús ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Ca²³'uøøn³ la²³jɨn³ dsa³ 'i³ lo³² dsa³ 'i³ 'nɨɨ²³ 'i³ ta'n² xi²ñʉ'¹. Ca²³cɨ'² mesas je² guø'n³²te'²³ cuu² quiee'³² jia'³ cɨ'²³ dxi² juɨɨ³. Ca²³cɨ'² sii³¹ je² nee'n²³² dsa³ 'i³ 'nɨɨn²³ to̱³ju̱³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ―La²³la³ cu³lø³¹ to̱o̱²³ ji³ júu² quiee'³² Dios: “'Ñʉ́² je² lʉ²³ dsa³ quia̱'² Dios rɨ²³jua'³te'²³ 'ñʉ́² je² mi³gáan³te'²³ jné²”. La'³ jua'³ júu² quiee'³² Dios 'e³ to̱o̱²³ je² 'e²³ 'ñʉ́² la³. 'E³ quie'²³ mɨ³jmée²ra'³ 'é̱e̱² 'ñʉ́² je² nee'n²³² dsa³ 'i̱i̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ca²³dxi²³guín²³ te'²³ dsa³ tuu² quia̱'² te'²³ dsa³ 'i³ 'uaa'³ tɨɨ² caan²³ Jesús 'e³ la²³ jen³¹ ñʉ'²³ 'ñʉ́² gáan³. Jo̱³ ca²³mi²³'láan² te'²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ŋó²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley 'e³ bi²³ juø'²³ cu³lø³¹ la²³jɨ³ 'e³ jmee²³ Jesús. Co̱'³ cɨ'²³ ŋó²³te'²³ 'e³ yoo'²³ tø³² xii'³ pii'² ñʉ'²³ 'ñʉ́² gáan³ 'e³ jua'³te'²³: “¡Que viva dsa³ ju̱u̱n²³ David!”. Bi²³ ca²³mɨ'n³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―¿'A² 'a²³jia'³ nuun³ 'e³ jmii'³¹ cu³lø³¹ lʉ²³ te'²³ xii'³ pii'² la³? 'E³ jo̱³ ca²³jua'³ Jesús: ―Nuun²³ xú̱n³. ¿'A² 'a²³jia'³ lɨ'³ ca³jóo²ra'³ ji³ je² to̱o̱²³ 'e³ la²³ ca²³jua'³ dsa³, ca²³sɨ'²³ Dios? Qui² jua'³: Mɨ³jméen² 'e³ bi²³ cɨ² jɨn³ mi³gáan³ 'nʉ³ te'²³ xii'³ pii'² quia̱'² te'²³ xi³yu̱u̱n³ 'i³ tʉ'³ quie'²³. La'³ cu³lø³¹ to̱o̱²³ ji³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ca²³tʉ́n² dsa³ 'í³ Jesús. Ca²³bǿn³ juɨɨ³ Jerusalén. Ŋóo² ca²³guɨɨn³ juɨɨ³ Betania. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ma²ca¹la¹jné¹ 'e³ la²³ 'iún² jui³¹ dsoo³² co̱'³ juɨɨ³ Jerusalén, ca²³la²³cue̱'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ŋó²³ co̱o̱³ 'mo³ higo 'e³ ja³¹ coo³¹ jui³¹. 'E³ jo̱³ ŋóo² i²joo³. 'A²³'e³ xa³ mɨɨ³¹ 'e³ rɨ³'ɨɨ³¹. 'Nɨɨ'n³¹ mee³¹ hua² xa³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ 'mo³: ―'A²³ ma²³ rɨ³'ɨɨn³ 'nʉ³ mɨɨ³¹. 'E³ jo̱³ xe̱'n² jmɨ́ɨ² ca²³la²³quiʉ̱ʉ̱³ 'mo³ higo. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bi²³ juø'²³ ca²³jóo² dsa³ quien³² 'e³ la²³ lǿ² ca²³lǿ²³. Ca²³jua'³te'²³: ―¿Jmii'³¹ lǿ² 'e³ mɨ³la³quiʉ̱ʉ̱³ xe̱'n² 'mo³ higo 'e³ mɨ³juɨɨn²³²nu³? ");
INSERT INTO cnlNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'Ne'² rɨ²³sɨ²³táan³na'³. 'A²³ rɨ³jmee³ra'³ 'e³ tú̱²³ 'óo²ra'³. Jo̱³ hua² 'a²³la³ la²³'nɨɨ'n³¹ 'e³ la²³ mɨ³jme'n²³ 'mo³ higo 'e³ rɨ²jmée²ra'³. Xi³nu³ rɨ²juɨɨ'³¹ra'³ mo'³ la³: “Je̱'n² nɨ³. Cu²te'n¹nu³ 'e̱'³ jmɨ²³ñii'³¹”, rɨ²³lí³ la'³ quién²na'³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Rɨ²³lí³ quién²na'³ la²³jɨ³ 'e³ ŋɨɨ³ra'³ 'e³ la²³ lʉ́²ra'³ quia̱'n²na'³ Dios xi³nu³ sɨ³táan³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","'Í² Jesús ñʉ'²³ 'ñʉ́² gáan³. 'E³ quie'²³ jo̱³ ca²³lǿn²³ mɨ³lén² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ mɨ³dxún²³ quien³² dsa³ juɨɨ³. Ca²³lǿn²³te'²³ mɨ³lén² je² 'iún² Jesús 'e³ 'ee²³ dsa³. Ca²³jua'³te'²³: ―¿'Ee² ta² quié̱n² 'e³ jmeen³ la²³jɨ³ 'e³ jmeen³? ¿'I̱i̱² sɨɨ'³¹ 'i³ ca²³cuǿ³ ta² 'e³ quié̱n²? ");
INSERT INTO cnlNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","'E³ jo̱³ ca²³jua'³ Jesús: ―Jné² rɨ²ŋɨ'n¹na²³ 'nee'²³ co̱o̱³ júu². Xi³nu³ rɨ²juɨɨ'³¹ra'³ jné² 'e³ la²³ lǿ² júu² 'e³ rɨ²ŋɨ'n¹na²³ 'nee'²³, jo̱³ hua² rɨ²juøøn³¹na¹ 'nee'²³ 'e³ 'ee² ta² 'e³ quie̱e̱n²³² 'e³ jmeen²³ 'e³ la²³ jmeen²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Rɨ²juɨɨ'³¹ra'³ jné² jo̱o̱²³na²³: ¿'I̱i̱² sɨɨ'³¹ 'i³ ca²³cuǿ³ ta² 'e³ quie̱³ Juan 'e³ xaan³² dsa³ jmɨɨ³? ¿'A² Dios 'i³ jen³¹ yʉʉ'³¹ güii³ ca²³cuǿ³ ta² 'e³ quie̱³? ¿'A² dsa³ hua² ca²³cuǿ³ ta² 'e³ quie̱³? 'E³ jo̱³ ca²³sɨ́n²³te'²³ júu² la²³ co̱³quie'² miin²³. Ca²³jua'³te'²³: ―¿Jmii'³¹ xi³nu³ rɨ²xii'³¹ra² 'e³ Dios 'i³ ca²³cuǿ³ ta² 'e³ quie̱³? 'E³ jo̱³ rɨ²³sɨ'²³ jne²: “¿'Ee² lǿ² 'a²³jia'³ ca²³táan³na'³ 'e³ la²³ ca²³jua'³ jo̱o̱²³?” ");
INSERT INTO cnlNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","'A²³jia'³ li²³bii²³ dsɨ³ra² rɨ²xii'³¹ra² 'e³ dsa³ hua² 'i³ ca²³cuǿ³ ta² 'e³ quie̱³. Qui² 'ñaa'n²³na² dsa³ juɨɨ³. Qui² lǿn³ la²³jɨn³ dsa³ 'e³ ca²³'ɨ́ɨ³ Juan júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―'A²³jia'³ ne³ra'³¹. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'E³ quie'²³ la'³, 'a²³jia'³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ 'ee² ta² 'e³ quie̱e̱n²³² 'e³ jmeen²³ 'e³ la²³ jmeen²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―¿Jmii'³¹ lǿn³na'³ jo̱o̱²³na²³? Xen³ jø̱n³ dsa³ 'i³ xen³ áan²³ jo̱o̱³¹. I²lʉ² quia̱'² jø̱n³. Ca²³jua'³: “Ja̱a̱n²³. Cu³jmee² ta² rɨ³nɨ²³ je² rɨ³jne² xoo'³¹ jø'².” ");
INSERT INTO cnlNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","'E³ quie'²³ ca²³jua'³ jo̱o̱³¹: “'A²³jia'³ 'náan²³ ñiin²³”. 'E³ quie'²³ cɨ̱ɨ̱n³ cɨ² ca²³lǿn³ 'e³ 'a²³jia'³ dxʉ́²³ mɨ³jméen²³. 'E³ jo̱³ ŋóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","'E³ quie'²³ ŋóo² co̱'³ jmii³ i²lʉ² quia̱'² jia'³ cɨ'²³ jo̱o̱³¹. 'E³ quie'²³ ca²³jua'³ co̱'³ 'e³ la²³ lǿ² ca²³sɨ'²³ jo̱o̱³¹ 'i³ ca²³lʉ́³ quia̱'² xe̱'n². 'E³ jo̱³ ca²³jua'³ jo̱o̱³¹: “Dxʉ́²³ la'³. Ñiin²³.” 'E³ quie'²³ 'a²³jia'³ ŋóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿'I̱i̱² sɨɨ'³¹ 'i³ ca²³jmée³ 'e³ la²³ 'née²³ jmii³te'²³, lǿn³na'³ jo̱o̱²³na²³? 'E³ jo̱³ ca²³jua'³te'²³: ―Jo̱o̱³¹ 'i³ ca²³lʉ́³ quia̱'² xe̱'n². 'E³ jo̱³ ca²³jua'³ Jesús: ―La²³ xen³ xii'³ 'i³ ca²³jmée³ 'i'²³ cɨ̱ɨ̱n³ cɨ² 'e³ 'a²³jia'³ dxʉ́²³ jmee²³ xen³ 'io'² quia̱'² mɨ́³ 'i³ jmoo³² ñi³ dxa³. Bi²³ cɨ² xa³ jui³¹ 'e³ rɨ²³lín³ Dios juii²te'¹ la²³ cɨ'²³ 'e³ rɨ²³lín³ juii² 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Qui² güén²³ Juan 'e³ jua'³ rɨ²³'ée²³ 'nee'²³ 'e³ jmii'³¹ rɨ²jmée²ra'³ ca³dsaan³². 'E³ quie'²³ 'a²³jia'³ ca²³táan³na'³ 'e³ la²³ ca²³jua'³. 'E³ quie'²³ ca²³táan³ 'io'² quia̱'² mɨ́³ 'i³ jmoo³² ñi³ dxa³ 'e³ la²³ ca²³jua'³ Juan. Ca²³ñíi³ra'³ 'e³ ca²³táan³ te'²³ dsa³ 'í³ 'u². 'E³ quie'²³ 'a²³jia'³ ca²³tʉ́²ra'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ dxʉ́²³. 'A²³jia'³ ca²³táan³na'³ 'e³ la²³ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Rɨ²núu²ra'³ jia'³ cɨ'²³ júu² rɨ³jnɨ³ 'e³ rɨ²juøøn³¹na¹ 'nee'²³: Xen³ jø̱n³ juii² 'uǿ²³ 'i³ ca²³jñi³ xoo'³¹ jø'². Ca²³jmée³ 'iá³ la²³cu'². Ca²³jmée³ too³ je² rɨ²³pi'n²te'²³ mɨ²jø'² 'e³ jua'³ rɨ²³co̱o̱²³te'²³ jmɨɨ'³¹. Ca²³jmée³ co̱o̱³ 'ñʉ́² jɨ̱ɨ̱n²³² je² rɨ²³gua³ dsa³ 'i³ rɨ²³'áa²³ je² rɨ³jne² xoo'³¹ jø'². ’Ca²³'náan²³ mozos 'i³ rɨ²³gua³ 'uǿ²³ quiee'³² 'e³ jua'³ 'née²³ 'e³ rɨ²³jmóo²te'²³ ta² quiee'³² xoo'³¹ jø'². 'E³ jo̱³ ŋóo² 'ñée² co̱o̱³ juɨɨ³ je² bi²³ huɨ̱́ɨ̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma²ca¹tɨ́³ ji̱i̱³ 'e³ jioo³² dsa³ mɨɨ³¹, ca²³xíin²³ mozos quien³² 'e³ jua'³ rɨ²³co̱o̱²³ mɨ²jø'² jñii³¹ 'uǿ²³ 'e³ rɨ²³jɨ̱'² te'²³ mozos 'i³ jmoo³² ta² quiee'³² xoo'³¹ jø'². ");
INSERT INTO cnlNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","'E³ quie'²³ bi²³ sǿn²³ ca²³jmóo² dsa³ 'i³ jmoo³² ta² quiee'³² xoo'³¹ jø'². Ca²³jme'²³ te'²³ mozos. Ca²³jmín²te'²³ jø̱n³. Ca²³jŋɨ'n²³te'²³ jia'³. Ca²³cuǿ³te'²³ cú̱u̱² quie'² jia'³ cɨ'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","'E³ quie'²³ co̱'³ cɨ'²³ ca²³xíin²³ mozos juii² 'uǿ²³. 'E³ quie'²³ juɨ́ɨn²³ cɨ² 'i³ ca²³xíin²³ co̱'³. 'E³ quie'²³ la'³ ca²³jme'²³te'²³ 'i³ 'í³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’'E³ quie'²³ je² dsøn³ ca²³xíin²³ jo̱o̱³¹ 'ñée². Ca²³jua'³: “Rɨ²³'áa²³te'²³ u²³go³ u²³'iʉʉ²³ quia̱'²te'²³ ja̱a̱n²³”. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","'E³ quie'²³ ma²ŋøn³¹te'¹ jo̱o̱³¹ juii² 'uǿ²³, ca²³lʉ́³te'²³ la²³ co̱³quie'²te'²³. Ca²³jua'³te'²³: “'I³ la³ dsa³ 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³'ióo²³ 'uǿ²³ mɨ³rɨ³jú̱n³ jmii³. Mɨ²³gui²³²ra². Mɨ²³jŋɨ'n²³na². 'E³ jo̱³ rɨ²³'ióo²³ra² miin²³na² 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³'ióo²³ 'ñée².” ");
INSERT INTO cnlNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","'E³ jo̱³ sø̱'n²te'²³. Ca²³juén²te'²³ rɨ²³co'²³ 'iá³. 'E³ quie'²³ jo̱³ ca²³jŋɨ'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","'E³ jo̱³ ca²³jua'³ Jesús: ―Mɨ³rɨ³dxoo³² juii² xoo'³¹ jø'², ¿jmii'³¹ rɨ²³jme'²³ mozos 'i³ jmoo³² ta² quiee'³² xoo'³¹ jø'², lǿn³na'³? ");
INSERT INTO cnlNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Rɨ²³mi²³gua'²³ dsa³ 'í³ xú̱n³. Qui² bi²³ tu³cua̱a̱n²tu² jmoo³². 'E³ quie'²³ jo̱³ rɨ²³'náan²³ jia'³ cɨ'²³ dsa³ 'i³ rɨ²³jmóo² ta² quiee'³² xoo'³¹ jø'² quiee'³², 'i³ rɨ²³jɨ̱'² mɨɨ³¹ jñii³¹ 'uǿ²³ cɨ'²³ la²³ sɨ³tɨ́²³ ji̱i̱³ 'e³ sɨ³roo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'A² 'a²³jia'³ lɨ'³ ca³jóo²ra'³ ji³ je² to̱o̱²³ júu² quiee'³² Dios je² jua'³: 'Ñée² cú̱u̱² 'e³ tó̱o̱²³ tɨ³² 'e³ jua'³ 'a²³jia'³ 'nee'³¹ mɨ³lǿ²³ cú̱u̱² 'e³ quie̱³ biin²³. Dios Juii³ra² 'i³ ca²³jmée³ la'³. Bi²³ juø'²³ joo²³²ra² 'e³ la²³ ca²³jmée³? La'³ cu³lø³¹ to̱o̱²³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Rɨ²juøøn³¹na¹ 'nee'²³ jo̱o̱²³na²³: Rɨ²³tʉ́ʉ² Dios 'e³ rɨ³løn³¹ juii² 'nee'²³. 'E³ quie'²³ rɨ²³lín³ juii² dsa³ 'i³ rɨ²³jmóo² 'e³ la²³ 'née²³ 'ñée², dsa³ 'i³ 'é̱e̱² 'e³ rɨ²³jɨ̱'² mɨ²jø'² jñii³¹ 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tʉʉ² la²³ cɨ² rɨ²³'níin³ dsa³ 'i³ rɨ²³'lǿn²³ ñi'² cú̱u̱² 'e³ 'øn²³. 'E³ quie'²³ juɨ² 'laa³ la²³ cɨ² rɨ²³lín³ dsa³ 'i³ rɨ³taa'³ cú̱u̱² jo̱³ ñi'² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ma²ca¹núu³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ fariseo la²³jɨ³ júu² 'e³ ca²³lʉ́³, ca²³la²³quii²³te'²³ 'e³ miin²³ hua² 'en³². ");
INSERT INTO cnlNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","'Née²³te'²³ 'e³ rɨ²³sø̱'n²te'²³. 'E³ quie'²³ 'ñaa'n²³te'²³ dsa³ juɨɨ³. Qui² lǿn³ dsa³ juɨɨ³ 'e³ 'ɨɨ³ Jesús júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Co̱'³ cɨ'²³ ca²³lʉ́³ Jesús júu² rɨ³jnɨ³. Ca²³jua'³ ca²³sɨ'²³ dsa³: ");
INSERT INTO cnlNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. Xen³ la²³ xen³ jø̱n³ rey 'i³ ca²³dxá³ mɨ²juee'³ 'e³ la²³ tǿø² mɨ́³ jo̱o̱³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ca²³xíin²³ mozos quien³² 'e³ rɨ²³ñii'n³te'²³ dsa³ 'i³ ca²³ji̱i̱n³te'²³ júu² quie'² 'e³ rɨ²³sɨ²³guín²³ mɨ²juee'³. 'E³ quie'²³ 'a²³jia'³ 'née²³ dsa³ 'í³ 'e³ sɨ³guín²³ mɨ²juee'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","'E³ jo̱³ ca²³xíin²³ cɨ² jia'³ cɨ'²³ mozos co̱'³. Ca²³jua'³: “Cu³xii'²ra'³ dsa³ 'i³ ca²³ji̱i̱n³te'²³ júu² quie'² 'e³ mɨ³líi² la²³jɨ³ 'e³ rɨ²³e'²te'²³. Qui² mɨ³jŋɨ'n²na²³ cua² 'ioo'³. Mɨ³jŋɨ'n²na²³ la²³jɨn³ 'i³ bi²³ dxʉ́²³ mɨ³e'n²te'²³ 'e³ jua'³ cu²li³cø'n². Mɨ³líi² la²³jɨ³. 'E³ jo̱³ rɨ²juɨɨ'³¹ra'³ 'e³ cu²ja³guín²³te'²³ mɨ²juee'³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","'E³ quie'²³ 'a²³jia'³ ca²³mi²³quí̱i̱n²³ dsa³. Te³ ca²³je̱'n²³ ca²³guín²³te'²³ jia'³ cɨ'²³. Ŋóo² jø̱n³ dsa³ je² nu'² quiee'³². Ŋóo² jia'³ je² 'aa³ tienda. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","'E³ quie'²³ sø̱'n² te'²³ mozos te'²³ jia'³ cɨ'²³ dsa³. Bi²³ u²³'i'²³ ca²³jme'²³te'²³. 'E³ quie'²³ jo̱³ ca²³jŋɨ'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","'E³ jo̱³ bi²³ ca²³ti̱'n³ rey. Ca²³xíin²³ 'láa³ quien³². Ca²³jŋɨ'n²³te'²³ dsa³ 'i³ ca²³jmóo² 'móo². 'E³ quie'²³ ca²³jɨ̱́³te'²³ juɨɨ³ quiee'³² dsa³ 'í³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","'E³ jo̱³ ca²³jua'³ rey. Ca²³sɨ'²³ mozos quien³²: “Mɨ³dsá²³ ñii'n²³ la²³jɨ³ 'e³ 'ne'². Mɨ³tɨ́³ 'e³ rɨ²jmee²ra² mɨ²juee'³. 'E³ quie'²³ 'a²³jia'³ 'nee'n³¹ te'²³ dsa³ 'i³ ca²³tǿøn² xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","'E³ jo̱³ cu³guín²³na'³ je² rɨ³ŋɨɨn³¹ dsa³ jee²³² calles. Rɨ²juɨɨ'³¹ra'³ dsa³ 'e³ cu²ja³guín²³ mɨ²juee'³ 'e³ la²³'nɨɨ'n³¹ juɨɨ'n³¹ dsa³ 'i³ rɨ²³jí̱i̱n³na'³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","'E³ quie'²³ jo̱³ i²guín¹ te'²³ mozos jee²³² calles. Ca²³ñii'n³te'²³ 'e³ la²³'nɨɨ'n³¹ juɨɨ'n³¹ dsa³ 'i³ ca²³jí̱i̱n³te'²³, juø'n³ quie'²³ dsa³ 'i³ 'a²³jia'³ dxún²³, juø'n³ quie'²³ dsa³ 'i³ dxún²³. 'E³ jo̱³ ca²³cø̱'n²³ dsa³ 'ñʉ́² je² sɨ³lí³ mɨ²juee'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’'E³ quie'²³ jo̱³ 'í² rey xi²ñʉ'¹ je² sɨ³lí³ mɨ²juee'³. Ca²³jóon² dsa³ 'i³ ca²³ñii'n³te'²³. 'E³ jo̱³ ŋǿn² jø̱n³ dsa³ 'i³ 'a²³jia'³ ca³cɨɨ'²³ 'mɨɨ'³ 'e³ quii'³ uu'n² 'e³ la²³ dxi³ji̱i̱n³¹ 'e³ quii'³ dsa³ 'i³ nee'n²³² mɨ²juee'³ je² jen²³ dsa³ mɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","'E³ jo̱³ ca²³jua'³ rey. Ca²³sɨ'²³ dsa³ 'í³: “Amigo. ¿Jmii'³¹ lǿ² 'e³ mɨ³'iin³²nu³ xi²ñʉ'¹ la³ 'e³ 'a²³jia'³ ca³quii'n³ 'mɨɨ'³ 'e³ la²³ dxi³ji̱i̱n³¹?” 'A²³'e³ ma²³ xa³ sɨ³quie̱³ rɨ²³lʉ́²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","'E³ jo̱³ ca²³jua'³ rey. Ca²³sɨ'²³ mozos: “Rɨ²'ñʉ́ʉ²ra'³ guoo³ tɨɨ² dsa³ la³. Rɨ²juen²³na'³ xi²dxi³² je² li³'o̱o̱³. Qui² núu²³ rɨ²³'o'² dsa³ nɨ³. Rɨ²³cuu'³ la²³ cɨ² jo̱² la²³'nɨɨ'n³¹ 'e³ rɨ²³ŋɨ́³ dsɨ́².” ");
INSERT INTO cnlNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Qui² juɨ́ɨn²³ dsa³ 'i³ ca²³ji̱i̱n³te'²³ júu² quie'² 'u². 'E³ quie'²³ 'a²³jia'³ juɨ́ɨn²³ 'i³ ca²³'náan²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","'E³ quie'²³ ca²³sɨ́n²³ júu² dsa³ fariseo 'e³ jmii'³¹ rɨ²³jáan²³te'²³ júu² quiee'³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","'E³ jo̱³ ca²³xíin²³te'²³ dsa³ quien³² miin²³ quia̱'² dsa³ 'i³ noo³ quia̱'² Herodes 'e³ jua'³ cu²lʉ́³te'²³ quia̱'²te'²³ Jesús. Ca²³jua'³te'²³: ―Dsa³ 'e²³, ne³ra'³¹ 'e³ jmeen³ 'nʉ³ 'e³ la²³ lǿ² ju²dsoo³¹. Ne³ra'³¹ 'e³ lʉ́n² ju²dsoo³¹ 'e³ la²³ 'een³² dsa³ jui³¹ 'e³ cuø²³ Dios. 'A²³jia'³ jmeen³ quí̱i̱n²³ te³ jmii'³¹ lʉ²³ dsa³ 'en³² 'nʉ³. 'A²³jia'³ jmeen³ 'i'²³ xi² gáan³ dsa³, xi² 'a²³jia'³ gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Rɨ²jméen² co̱o̱³ mɨ²'áa² rɨ²juɨɨ'n³¹nu³ jnee'³¹ 'e³ jmii'³¹ lǿn³nu³ 'uǿøn²nu³. ¿'A² joo'²³ 'e³ rɨ²qui²³²ra² cuu² 'e³ cu'n³² 'io'² 'i³ xiin²³ dxi² juɨɨ³ César? ");
INSERT INTO cnlNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","'E³ quie'²³ ñi³² Jesús 'e³ 'a²³jia'³ dxʉ́²³ 'e³ 'née²³ rɨ²³jmóo² dsa³ 'í³. 'E³ jo̱³ ca²³jua'³: ―Bi²³ jmee³ra'³ guóo². ¿'Ee² lǿ² 'e³ 'noo³ra'³ 'e³ rɨ²jmée²ra'³ lá³ quia̱'n²na'³ jné²? ");
INSERT INTO cnlNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ja³ maan²³² la³ cuu² 'e³ qui³² dsa³ quie'² 'io'². 'E³ jo̱³ i²quié̱³te'²³ co̱o̱³ cuu². ");
INSERT INTO cnlNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'I̱i̱² sɨɨ'³¹ quie'² ne'n² 'e³ to̱o̱²³ la³? ¿'I̱i̱² sɨɨ'³¹ quie'² nombre 'e³ to̱o̱²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","'E³ jo̱³ ca²³jua'³te'²³: ―'E³ quiee'³² dxi² juɨɨ³ César. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ―Rɨ²cuøø³¹ra'³ dxi² juɨɨ³ la²³jɨ³ 'e³ quiee'³² dxi² juɨɨ³. 'E³ quie'²³ rɨ²cuøø³¹ra'³ Dios la²³jɨ³ 'e³ quiee'³² 'ñée² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bi²³ juø'²³ ca²³núu³te'²³ júu² 'e³ ca²³lʉ́³. 'E³ quie'²³ jo̱³ ca²³tʉ́n²te'²³ Jesús. Ca²³guiin³²te'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","'E³ quie'²³ jmɨ́ɨ² jo̱³ xen³ dsa³ saduceo 'i³ i²guín¹ i²lʉ²te'¹ quia̱'²te'²³ Jesús. Jua'³ dsa³ saduceo 'e³ 'a²³jia'³ sɨ³ji̱i̱'²³ dsa³ co̱'³. Xa³ júu² 'e³ ca²³ŋɨ'²³te'²³ Jesús. Ca²³jua'³te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Dsa³ 'e²³, la²³la³ cu³lø³¹ ca²³jua'³ Moisés, ¿mɨ³naa'³¹?: “Xi³nu³ rɨ²³jú̱n³ dsa³ 'i³ xen³ mɨ²³quie'², 'e³ quie'²³ 'a²³'i̱³ xen³ jo̱o̱³¹, 'ne'² 'e³ rɨ²³tǿø²³ mɨ́³ 'nɨ́ɨ³ jó̱o̱² dsa³ 'i³ jú̱n²³ 'e³ jua'³ cu²li³xen³ 'é̱e̱² jo̱o̱³¹ 'lɨ² jó̱o̱²”. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Xen³ guiáan²³ dsa³ la²³ ca³já̱a̱n² 'i³ nee'n²³² la²³ca̱a̱n³ la³. Tǿø² mɨ́³ jó̱o̱² 'i³ cua̱a̱n²³. 'E³ quie'²³ jú̱n²³. 'A²³'i̱³ jo̱o̱³¹ ca²³la²³xen³. 'E³ jo̱³ ca²³cuaa'n³ guoo³ jó̱o̱² mɨ́³ 'nɨ́ɨ³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","'E³ quie'²³ la'³ ca²³ji̱'²³ jó̱o̱² 'i³ sɨ³tɨ́²³ áan²³ quia̱'² jó̱o̱² 'i³ sɨ³tɨ́²³ aan³. Ca²³lǿ²³ quie'²³ la'³ xi³'lɨ² ca²³tɨ́³ 'e³ jú̱n²³ jó̱o̱² 'i³ je² dsøn³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Je² dsøn³ cɨ² jú̱n²³ mɨ́³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿'I̱i̱² sɨɨ'³¹ li²³quién² mɨ́³ 'í³ jo̱o̱²³na²³ mɨ³rɨ³ji̱i̱'²³ dsa³ co̱'³? Qui² ca²³la²³quia̱'² la²³jɨn³ guiáan²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ saduceo: ―Bi²³ mɨ³ca³caa'n³²na'³. Qui² 'a²³jia'³ cuiin³na'³ júu² quiee'³² Dios. 'A²³ cɨ'²³ móo³ra'³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'uee'n³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","'A²³jia'³ ma²³ rɨ²³tǿø²³ dsa³ mɨ́³ mɨ³rɨ³ji̱i̱'²³ dsa³ co̱'³. 'E³ quie'²³ 'a²³ cɨ'²³ ma²³ rɨ²³cuǿn² dsa³ jo̱²³mɨɨ³¹ quie'² dsóo²³. La²³ xen³ ángeles quien³² Dios 'i³ nee'n²³² yʉʉ'³¹ güii³ li²³xen³ dsa³ mɨ³rɨ³ji̱i̱'²³te'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Rɨ²juøøn³¹na¹ 'nee'²³ 'e³ sɨ³ji̱i̱'²³ dsa³ co̱'³. Lɨ'³ ca³jóo²ra'³ ji³ je² to̱o̱²³ 'e³ la²³ ca²³jua'³ Dios, ca²³sɨ'²³ 'nee'²³, ¿mɨ³naa'³¹? Qui² ca²³jua'³ Dios: ");
INSERT INTO cnlNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Dios juii² Abraham hua² jné². Dios juii² Isaac. Dios juii² Jacob co̱'³” ca²³jua'³. 'A²³jia'³ rɨ³løn³¹ Dios juii² dsa³ 'i³ rɨ³jú̱n². 'E³ quie'²³ rɨ³løn³¹ juii² dsa³ 'i³ rɨ³ji̱'²³. 'E³ jo̱³ hua² lii²³ 'e³ rɨ³ji̱'²³ Abraham quia̱'² Isaac quia̱'² Jacob, juø'n³ quie'²³ jú̱n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bi²³ juø'²³ ca²³núu³ dsa³ júu² 'e³ ca²³'é³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ca²³núu³ dsa³ fariseo 'e³ ca²³jmée³ Jesús 'e³ ca²³cɨ́n³ dsa³ saduceo. 'E³ jo̱³ ca²³ŋɨɨ'n²³ dsa³ fariseo. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Xen³ jø̱n³ 'i³ rɨ³løn³¹ dsa³ 'e²³ ley 'i³ ca²³ŋɨ́ɨ³ júu² quie'² Jesús 'e³ jua'³ jmee²³ lá³. Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Dsa³ 'e²³. ¿'Ee² júu² 'e³ gáan³ cɨ² 'e³ ca²³dxi³ 'i'²³ Dios? ");
INSERT INTO cnlNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","'E³ jo̱³ ca²³jua'³ Jesús: ―“'Ne'² li²³'náan²³na'³ Dios Juii³ra'³ 'e³ dxaa'n³¹ 'óo²ra'³. Jø̱n³ Dios 'nɨɨ'n³¹ 'ne'² 'e³ nee² 'óo²ra'³. 'Ne'² li²³'náan²³na'³ la²³jɨ³ sú̱n² 'i'²³ 'e³ jmee³ra'³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","La²³nɨ³ cu³lø³¹ júu² 'e³ gáan³ cɨ², 'e³ dsoo³² xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","'E³ quie'²³ 'a²³ ma²³ røø³ lǿ² quia̱'² júu² je² sɨ³tɨ́²³ tú̱²³. La²³la³ cu³lø³¹ júu² jo̱³: “'Ne'² li²³'náan²³na'³ uu'n²na'³ 'e³ la²³'nɨɨ'n³¹ 'e³ 'náan²³na'³ miin²³na'³”. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ca³ti³² tú̱²³ júu² nɨ³ quie̱³ la²³jɨ³ sú̱n² júu² 'e³ to̱o̱²³ ley quia̱'² la²³jɨ³ sú̱n² júu² 'e³ to̱o̱²³ ji³ 'e³ ca²³jmóo² dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Rɨ³ŋɨɨn³¹ quie'²³ dsa³ fariseo. 'E³ jo̱³ ca²³ŋɨ́ɨ³ júu² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ca²³jua'³: ―¿Jmii'³¹ cu³lø³¹ quie'² Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios, lǿn³na'³? ¿'I̱i̱² dsa³ ju̱u̱n²³ 'i³ 'í³, lǿn³na'³? 'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Dsa³ ju̱u̱n²³ David hua² 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","'E³ jo̱³ ca²³jua'³ Jesús: ―¿Jmii'³¹ lǿ² 'e³ ca²³jua'³ David Juiin²³ ca²³'én² Cristo jo̱o̱²³na²³? Espíritu Gáan³ ca²³cuǿ³ jui³¹ quie'² David ma²ca¹jua'³ la'³, ¿mɨ³naa'³¹? Qui² la²³la³ cu³lø³¹ ca²³jua'³ David 'e³ la²³ to̱o̱²³ ji³: ");
INSERT INTO cnlNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ca²³jua'³ Dios Juii³ra². Ca²³sɨ'²³ Juiin²³: “Ñí³ jaan²³na²³ 'e³ dxʉ́²³ la²³huø'n²³ 'e³ rɨ²jmeen²³² 'e³ rɨ²³lín³nu³ juii² dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² 'nʉ³”. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Juiin²³ ca²³jua'³ David, ca²³'én² Cristo. ¿Jmii'³¹ lǿ² 'e³ rɨ³løn³¹ Cristo ju̱u̱n²³ David xi³nu³ la'³ cu³lø³¹ ca²³jua'³? Qui² rɨ³løn³¹ juii² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","'E³ quie'²³ 'a²³'i̱³ xen³ 'i³ ca²³lǿ²³ juø'² ca²³jme'n² júu². Cɨ'²³ mɨ²jo̱³ ca²³la²³láa²³ 'e³ 'a²³'i̱³ ma²³ xen³ dsa³ 'i³ li²³bii²³ dsɨ́² 'e³ rɨ²³ŋɨ'²³ júu² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ la²³jɨn³ dsa³ 'i³ rɨ³ŋɨɨn³¹ ca³ti³² quia̱'² dsa³ quien³²: ");
INSERT INTO cnlNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Xa³ ca³dsaan³² quie'² dsa³ fariseo quia̱'² dsa³ 'e²³ ley 'e³ jmoo³²te'²³ jɨn³ ley 'e³ ca²³ŋɨ́n² Moisés. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","'E³ jo̱³ 'ne'² rɨ²jmée²ra'³ 'e³ la²³ jua'³te'²³. 'Ne'² rɨ²jmée²ra'³ quién²na'³ júu² quiee'³²te'²³. 'E³ quie'²³ 'a²³ rɨ³jmee³ra'³ 'e³ la²³ jmoo³². Qui² 'a²³jia'³ jmoo³² miin²³ 'e³ la²³ jua'³te'²³ 'e³ 'ne'² rɨ²³jmóo² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ñúun³ la²³jɨ³ 'e³ dxi³te'²³ 'i'²³. 'É̱e̱² 'e³ jmoo³²te'²³ ji̱i̱³ láa² 'e³ 'ii³ 'e³ 'a²³jia'³ rɨ²³o̱o̱'²³ dsa³. 'E³ jo̱³ quie̱e̱n³²te'²³ dsa³ láa². 'E³ quie'²³ 'a²³jia'³ rɨ²³jmóo² co̱²juø'¹ quie'² dsa³ 'i³ quie̱³ láa², cu³xi³ 'e³ rɨ²³quiʉ̱'² co̱o̱³ mɨɨ³¹ mɨ²xi¹guoo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jmoo³² la²³jɨ³ 'e³ jmoo³² 'e³ jua'³ 'née²³ 'e³ rɨ²³jóo² dsa³. Jmoo³²te'²³ mɨ³¹tuu'³ je² to̱o̱'³²te'²³ me³¹ji³ 'e³ to̱o̱²³ cɨ'³ la²³ co̱o̱³ jo̱o̱²³² júu² quiee'³² Dios. Te̱e̱³²te'²³ quí²te'²³ quia̱'² cuáa²te'²³. 'A²³la³ ma²³ la²³née² 'e³ jmoo³²te'²³. Bi²³ coo'² bee'² mɨ³¹tuu'³ 'e³ jmoo³²te'²³ 'e³ jua'³ cu²jóo¹ dsa³. Co̱'³ cɨ'²³ jmoo³² 'e³ bi²³ cuaa³ loo'³¹ cuo̱o̱³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bi²³ 'née²³te'²³ 'e³ rɨ²³gua³te'²³ sii³¹ je² gua³ dsa³ gáan³ 'e³ la²³ tøø³te'²³ 'e³ rɨ²³e'². 'E³ quie'²³ la'³, 'née²³te'²³ rɨ²³gua³te'²³ je² dxʉ́²³ cɨ² ñʉ'²³ 'ñʉ́² je² mi³gáan³te'²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bi²³ 'née²³te'²³ 'e³ rɨ²³mi²³jue'²³ dsa³ 'e³ la²³ cuø²³te'²³ u²³juee'n³¹ quia̱'²te'²³ je² dxa²³ dsa³ 'moo'². Bi²³ 'née²³te'²³ 'e³ rɨ²³sɨ'²³te'²³ dsa³ 'e²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’'E³ quie'²³ 'a²³jia'³ dxi³ji̱i̱n³¹ 'e³ rɨ²³sɨ'²³te'²³ 'nee'²³ dsa³ 'e²³. Qui² jø̱n³ dsa³ 'e²³ quien³²na'³ xen³. 'E³ quie'²³ rɨ³løn³¹na'³ la²³ ca³já̱a̱n²na'³ la²³jɨn³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","'E³ quie'²³ la'³ 'a²³jia'³ dxi³ji̱i̱n³¹ rɨ²juo'²ra'³ ñu'n² rɨ²juɨɨ'³¹ra'³ dsa³ mɨ³¹güii³. Qui² jø̱n³ ñʉ'²ra'³ xen³ 'i³ jen³¹ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","'E³ quie'²³ la'³ 'a²³jia'³ dxi³ji̱i̱n³¹ 'e³ rɨ²³sɨ'²³te'²³ 'nee'²³ juiin²³. Qui² jø̱n³ juii³ra'³ xen³. Cristo hua² 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","'Nee'²³ 'i³ rɨ³løn³¹ mozos 'i³ mi³quin³ uu'n², 'i³ 'í³ hua² 'i³ gáan³ cɨ² jee²³² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","'E³ cɨ² li²³'uǿn²³ dsa³ 'i³ mi³gáan³ 'ñée². 'E³ quie'²³ 'e³ cɨ² li²³gáan³ dsa³ 'i³ mi³'uǿn²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Bi²³ juɨɨ³² 'nee'²³, dsa³ 'e²³ ley quia̱'² dsa³ fariseo. Qui² bi²³ te³ jmee³ra'³ guóo². Jníin²na'³ jui³¹ 'e³ rɨ²³lín³ juii² dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. 'A²³ cɨ'²³ 'e³ 'noo³ra'³ miin²³na'³. 'A²³ cɨ'²³ 'e³ rɨ²cuǿ²ra'³ júu² quie'² dsa³ 'i³ 'née²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Bi²³ juɨɨ³² 'nee'²³, dsa³ 'e²³ ley quia̱'² dsa³ fariseo. Qui² bi²³ te³ jmee³ra'³ guóo². Je̱'n²³²na'³ 'ñʉ² mɨ́³ 'nɨ́ɨ³. 'A²³jia'³ juɨɨ³² ji̱i̱n³²na'³. 'E³ quie'²³ huǿø³ la²³ lʉ́²ra'³ quia̱'n²na'³ Dios jmee³ra'³ 'e³ juo'³ra'³ cu²jóo¹ dsa³. 'E³ jo̱³ bi²³ cɨ² rɨ²³jmée²³ Dios jñiin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Bi²³ juɨɨ³² 'nee'²³, dsa³ 'e²³ ley quia̱'² dsa³ fariseo. Qui² bi²³ te³ jmee³ra'³ guóo². Sɨ³'øn³na'³ jmɨ²³ñii'³¹, ŋɨ́²ra'³ 'uǿ²³ rɨ³quiʉ̱ʉ̱³, 'e³ la²³'nɨɨ'n³¹ 'e³ dxaa'n³¹ 'óo²ra'³ 'noo³ra'³ 'e³ li²³tɨn³ dsa³, juø'n³ quie'²³ jø̱n³, júu² 'e³ tɨn³na'³ miin²³na'³. Mɨ³rɨ³'aa³ 'i'²³ 'e³ mɨ³la³tɨn³ dsa³ júu² quien³²na'³, cuø³ra'³ jui³¹ quie'²te'²³ 'e³ bi²³ cɨ² dxi³ji̱i̱n³¹ 'e³ rɨ²³dsóo² guiáa²³ juɨ́ɨ² la²³ cɨ'²³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Bi²³ juɨɨ³² 'nee'²³. Cuøø³²ra'³ dsa³ jui³¹, juø'n³ quie'²³ tuu² mɨ²ñí²ra'³ miin²³na'³. Xen³ dsa³ 'i³ 'e²³ 'ñʉ́² gáan³ 'e³ jua'³ cu²sɨ³táan³ dsa³ 'e³ ca³quie̱e̱² rɨ²³jmóo²te'²³ 'e³ la²³ mɨ³jua'³te'²³. 'E³ quie'²³ xen³ dsa³ 'i³ 'e²³ cu²nee³¹ 'e³ xa³ ñʉ'²³ 'ñʉ́² gáan³. Juo'³ra'³ 'e³ 'a²³jia'³ quí̱i̱n²³ júu² quiee'³² dsa³ 'i³ 'e²³ 'ñʉ́² gáan³. 'E³ quie'²³ juo'³ra'³ 'e³ quí̱i̱n²³ júu² quiee'³² dsa³ 'i³ 'e²³ 'nɨɨ'n³¹ cu²nee³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tuu² mɨ²ñí²ra'³. Bi²³ gøn³na'³. Gáan³ cɨ² 'ñʉ́² gáan³ la²³ cɨ'²³ cu²nee³¹, ¿mɨ³naa'³¹? Qui² 'ñʉ́² gáan³ hua² jmee²³ 'e³ 'mɨ'n²³ cu²nee³¹ 'e³ xa³ ñʉ'²³ 'ñʉ́². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Xen³ dsa³ 'i³ 'e²³ có̱o̱²³ je² dxa²³ dsa³ la²³jɨ³ 'e³ cuøø²³te'²³ Dios. 'E²³te'²³ có̱o̱²³ 'e³ jua'³ cu²sɨ³táan³ dsa³ 'e³ ca³quie̱e̱² rɨ²³jmóo²te'²³ 'e³ la²³ mɨ³jua'³te'²³. 'E³ quie'²³ xen³ dsa³ 'i³ 'e²³ la²³jɨ³ 'e³ mɨ³dxá³ dsa³ ñi'² có̱o̱²³ jo̱³. Juo'³ra'³ 'e³ 'a²³jia'³ quí̱i̱n²³ júu² quiee'³² dsa³ 'i³ 'e²³ có̱o̱²³. 'E³ quie'²³ juo'³ra'³ 'e³ quí̱i̱n²³ júu² quiee'³² dsa³ 'i³ 'e²³ la²³jɨ³ 'e³ nee'²³² ñi'². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bi²³ tuu² mɨ²ñí²ra'³. Bi²³ gøn³na'³. Gáan³ cɨ² 'ñée² có̱o̱²³ la²³ cɨ'²³ la²³jɨ³ 'e³ nee'²³² ñi'². Qui² có̱o̱²³ jmee²³ 'e³ 'mɨ'n²³ la²³jɨ³ 'e³ nee'²³² ñi'². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","'E³ jo̱³ 'a²³la³ 'nɨɨ'n³¹ có̱o̱²³ je² dxa²³ dsa³ la²³jɨ³ 'e³ cuøø²³te'²³ Dios 'e³ jmee²³ quí̱i̱n²³ júu² quiee'³² dsa³ 'i³ 'e²³ có̱o̱²³. 'E³ quie'²³ có̱o̱²³ ca³ti³² quia̱'² la²³jɨ³ 'e³ nee'²³² ñi'² jmee²³ 'e³ quí̱i̱n²³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","'E³ quie'²³ la'³ 'a²³la³ 'nɨɨ'n³¹ 'ñʉ́² gáan³ 'e³ jmee²³ quí̱i̱n²³ júu² quiee'³² dsa³ 'i³ 'e²³ 'ñʉ́² gáan³. 'E³ quie'²³ 'ñʉ́² gáan³ ca³ti³² quia̱'² Dios 'i³ jen³¹ ñʉ'²³ jmee²³ 'e³ quí̱i̱n²³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","'E³ quie'²³ la'³ 'a²³la³ 'nɨɨ'n³¹ yʉʉ'³¹ güii³ 'e³ jmee²³ quí̱i̱n²³ júu² quiee'³² dsa³ 'i³ 'e²³ yʉʉ'³¹ güii³. 'E³ quie'²³ sii³¹ gáan³ je² jen³¹ Dios ca³ti³² quia̱'² Dios 'i³ jen³¹ sii³¹ gáan³ jmee²³ 'e³ quí̱i̱n²³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Bi²³ juɨɨ³² 'nee'²³, dsa³ 'e²³ ley quia̱'² dsa³ fariseo. Qui² bi²³ te³ jmee³ra'³ guóo². Jmee³ra'³ guiá²³ taa'² la²³jɨ³ 'oo³ quiee'³² mó² 'e³ xa³ quién²na'³ 'e³ xi̱i̱n³ me²³ji̱i̱'²³² quiee'³² ñi'² quia̱'² anís quia̱'² comino. 'E³ jo̱³ cuøø³²ra'³ Dios co̱o̱³ taa'². Tø'n²³na'³ la²³jɨ³ 'e³ quí̱i̱n²³ cɨ² 'e³ dxi³ 'i'²³ ley: 'A²³jia'³ mi³quí̱i̱n²³na'³ xi² jmee³ra'³ ca³dsaan³². 'A²³ cɨ'²³ mi³quí̱i̱n²³na'³ xi² cuu'²³ 'óo²ra'³ quia̱'n²na'³ dsa³. 'A²³ cɨ'²³ mi³quí̱i̱n²³na'³ xi² jmee³ra'³ 'e³ la²³ mɨ³jua'²ra'³ 'e³ rɨ²jmée²ra'³. 'E³ jo̱³ hua² 'e³ 'ne'² rɨ²mi³quí̱i̱n²³na'³ 'u² 'e³ la²³ jmee³quie²³ra'³ 'e³ mɨ³'ǿn²³ xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Cuø³ra'³ jui³¹ quie'² dsa³. 'E³ quie'²³ tuu² mɨ²ñí²ra'³. 'A²³jia'³ li²³bii²³ 'óo²ra'³ 'e³ rɨ²cuaa'n²³²na'³ la²³jɨ³ 'e³ quí̱i̱n²³ ca³juɨ² qui³. Dxʉ́²³ quie'²³ 'óo²ra'³ 'e³ rɨ²cuaa'n²³²na'³ la²³jɨ³ 'e³ bi²³ cɨ² quí̱i̱n²³. 'É̱e̱² 'e³ ŋɨɨn²³na'³ la²³jɨ³ 'e³ 'u'²ra'³. Qui² juø'² xi³nu³ 'iún² jø̱n³ lu³. 'E³ quie'²³ dxʉ́²³ quie'²³ 'óo²ra'³ 'e³ i̱i̱'n²³na'³ roo'³² camello. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Bi²³ juɨɨ³² 'nee'²³, dsa³ 'e²³ ley quia̱'² dsa³ fariseo. Qui² bi²³ te³ jmee³ra'³ guóo². U̱u̱'³²ra'³ 'no² tazas quia̱'² 'no² huɨ̱́ɨ̱²³. 'E³ quie'²³ 'e̱'³ taa'² la²³jɨ³ 'e³ mɨ³jmée²ra'³ 'i̱i̱³ quia̱'² la²³jɨ³ 'e³ 'iin²³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Rɨ²juøøn³¹na¹ 'nee'²³, dsa³ fariseo 'i³ tuu² mɨ²ñi²: Xe̱'n² rɨ²u̱u̱'³¹ra'³ 'e̱'³ vasos quia̱'² 'e̱'³ huɨ̱́ɨ̱²³. Jo̱³ hua² rɨ²³lí³ rɨ³jɨ́² 'no² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Bi²³ juɨɨ³² 'nee'²³, dsa³ 'e²³ ley quia̱'² dsa³ fariseo. Qui² bi²³ te³ jmee³ra'³ guóo². Xen³na'³ la²³ xen³ 'e̱e̱³ 'e³ ca²³jñʉ́ʉ²³te'²³ juɨ² loo²³² ñi'². Bi²³ lii'² líi³ra² 'e³ ñi'². 'E³ quie'²³ ñʉ'²³ hua² taa'² mee²³² 'lɨ́ɨ³ quia̱'² la²³jɨ³ 'e³ mɨ³juu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","'E³ quie'²³ la'³ xen³ 'nee'²³. Qui² lǿn³ dsa³ 'e³ jmee³ra'³ ca³dsaan³². Ti²cø̱'n²³ 'óo²ra'³ la²³jɨ³ 'e³ 'a²³jia'³ dxʉ́²³: Bi²³ jmee³ra'³ guóo². Bi²³ jmee³ra'³ 'e³ 'a²³jia'³ joo'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Bi²³ juɨɨ³² 'nee'²³, dsa³ 'e²³ ley quia̱'² dsa³ fariseo. Qui² jmee³ra'³ 'e̱e̱³ 'e³ rɨ³lø³¹ 'ioo'³ je² rɨ³'aan²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². Jmee³ra'³ lii'² 'e̱e̱³ je² rɨ³'aan²³ dsa³ 'i³ ca²³jmóo² ca³dsaan³². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Juo'³ra'³: “'U² cu²ru'³ xen³na² mɨ²jo̱³ ma²xen³ yi²³uu'²ra² jaa²³², 'a²³jia'³ jmɨ́ɨ² ca²³jmee²ra² co̱o̱³ júu² quia̱'n²na²te'¹ ma²ca¹jŋɨ'n¹te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios cu²ru'³ la'³”. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","'E³ la²³ lʉ́²ra'³ la'³, te³ jmee³ra'³ lii²³ 'e³ xen³na'³ la²³ xen³ yi²³uu'²ra'³ jaa²³² 'i³ ca²³jŋɨ'n²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","'E³ quie'²³ 'nee'²³ rɨ²mi³'ien²³na'³ la²³jɨ³ 'e³ ca²³cuaa'n²³, 'e³ 'a²³jia'³ ca²³jmóo² yi²³uu'²ra'³ jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’La²³ xen³ loo³ xen³na'³. La²³ xen³ ju̱u̱n²³ 'luu³ xen³na'³. 'A²³'e³ ma²³ xa³ u²³laan³¹ quién²na'³. Qui² rɨ²³dxi³ 'i'²³ Dios 'e³ 'ne'² cu³guín²³na'³ guiáa²³ juɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","'E³ jo̱³ rɨ²sɨɨn³¹na¹ quién²na'³ dsa³ 'i³ rɨ²³'ɨ́ɨ²³ júu² quiee'³² Dios quia̱'² dsa³ 'i³ bi²³ dsoo²³ dsɨ́² quia̱'² dsa³ 'e²³. Xen³ 'i³ rɨ²jŋɨ'n²³na'³, 'i³ rɨ²te̱e̱n²³²na'³ 'mo³ cruz. 'E³ quie'²³ xen³ 'i³ rɨ²jmin²³na'³ ñʉ'²³ 'ñʉ́² je² mi³gáan³te'²³ Dios. 'E³ quie'²³ rɨ²'uøøn²³²na'³ cɨ'³ la²³ co̱o̱³ juɨɨ³ je² rɨ²³dxóo²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","La'³ rɨ²³lí³ 'e³ la²³ rɨ²³jí̱i̱n²na'³ jñiin²³na'³ dsoo² quiee'³² la²³jɨn³ dsa³ 'i³ ca²³jŋɨ'n²³ uu'n² 'i³ jmoo³² ca³dsaan³². Ca²³la²³láa²³ ma²ca¹jŋɨ'n¹te'²³ Abel, juø'n³ quie'²³ 'a²³'e³ xa³ 'e³ ca²³jmée³. Je² dsøn³ ca²³jŋɨ'n²³te'²³ Zacarías jo̱o̱³¹ Berequías coo³¹ có̱o̱²³ je² co³jee²³² la²³ quia̱'² je² bi²³ 'mɨ'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Dsa³ 'i³ xen³ rɨ³nɨ²³ hua² rɨ²³ji̱'²³ jñiin²³ la²³jɨ³ dsoo² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Ay. Bi²³ juɨɨ³² 'nee'²³, dsa³ Jerusalén. Qui² jŋɨ'n²³na'³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. Cuø³ra'³ cú̱u̱² quie'² dsa³ 'i³ xiin²³ Dios quién²na'³. Ñúun³ taa'² mɨ³la³'náan²³ 'e³ rɨ²tøøn³¹na¹ 'nee'²³ 'e³ la²³ ta̱a̱'n³ cuáa² jo̱o̱³¹ xóo² 'nɨɨ'² 'u². 'E³ quie'²³ 'a²³jia'³ 'noo³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","'A²³jia'³ ma²³ née² guoo³ Dios xi²ñʉ'¹ quien³²na'³. Qui² mɨ³ rɨ²bǿn³na²³ je² la³. ");
INSERT INTO cnlNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rɨ²juøøn³¹na¹ 'nee'²³: 'A²³jia'³ ma²³ rɨ²mǿn¹na'³ jné² co̱'³ la²³huø'n²³ 'e³ rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ rɨ²juo'²ra'³ rɨ²'ǿn¹na'³ jné²: “Mɨ³cuǿ³ Dios u²³li²³jé̱e̱³ quie'² dsa³ la³ 'i³ ja³'ɨ́ɨn²³ 'e³ 'iin³¹ Dios Juii³ra²”. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","'E³ quie'²³ jo̱³ ca²³bǿn³ Jesús 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. 'Iún² jui³¹ 'e³ dsoo³² jia'³ cɨ'²³ tó̱o̱²³ ma²ca¹lǿn¹ mɨ³lén² te'²³ dsa³ quien³². Ca²³'ée²³te'²³ 'ñʉ́² gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","'E³ quie'²³ ca²³jua'³ Jesús: ―Joo³²ra'³ 'ñʉ́² la³, ¿mɨ³naa'³¹? Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'E³ cɨ² rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ cu³xi³ co̱o̱³ cú̱u̱² 'a²³jia'³ ma²³ rɨ²³te'n²te'²³ mɨ³rɨ³jee'n³te'²³ 'ioo'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","'E³ quie'²³ jo̱³ ŋóo² Jesús yʉʉ'³¹ mo'³ Olivos. Je² núu²³ ca²³guó³ jo̱o̱²³na²³. 'E³ jo̱³ ca²³guín²³ dsa³ quien³² je² jen³¹ Jesús 'e³ jua'³ 'née²³te'²³ 'e³ rɨ²³lʉ́²³te'²³ quia̱'²te'²³ je² 'a²³jia'³ nuu³ dsa³. Ca²³jua'³te'²³: ―Rɨ²jméen² co̱o̱³ mɨ²'áa² 'e³ rɨ²juɨɨ'n³¹nu³ jnee'³¹ 'e³ lɨɨ'³¹ rɨ²³lí³ 'e³ la²³ mɨ³jue'n² ca³dxa³. ¿Jmii'³¹ rɨ²³li²³lii²³ mɨ³rɨ³ti³ 'e³ rɨ²³güe'n²³nu³ co̱'³? ¿Jmii'³¹ rɨ²³li²³lii²³ mɨ³rɨ³ti³ 'e³ rɨ²³dxá³ jmɨ́ɨ²? ");
INSERT INTO cnlNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ³móo³ra'³. Qui² bi²³ juø'² rɨ²³jmóo² dsa³ 'e³ rɨ²³sɨ²³caa'n³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Juɨ́ɨn²³ dsa³ 'i³ rɨ²³ja²³guín²³ 'i³ rɨ²³jua'³ 'e³ rɨ³løn³¹te'¹ jné². Rɨ²³jua'³te'²³: “Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios hua² jné²”. 'E³ jo̱³ rɨ²³jmóo² 'e³ rɨ²³sɨ²³caa'n³² juɨ́ɨn²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","'E³ cɨ² rɨ²núu²ra'³ 'e³ sɨ³lí³ qui³. Rɨ²³jua'³ dsa³ 'e³ mɨ³ rɨ²³lí³ qui³. Rɨ²jmée²ra'³ quién²na'³ 'e³ 'a²³jia'³ rɨ²juø'n¹na'³ miin²³na'³. Qui² 'ne'² rɨ²³lí³ la'³. 'E³ quie'²³ 'a²³jia'³ ca²³dsá²³ jmɨ́ɨ² mɨ³rɨ³ti³ 'e³ rɨ²³lí³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Qui² 'e³ cɨ² rɨ²³níin³ co̱o̱³ ta'n² dsa³ quia̱'² jia'³ cɨ'²³. Rɨ²³níin³ jø̱n³ dxi² juɨɨ³ quia̱'² jia'³ cɨ'²³. Ñúun³ juɨɨ³ je² li²³'oon²³ 'e³ rɨ²³e'² dsa³. Ñúun³ juɨɨ³ je² rɨ²³sɨ²³too'² dsóo². Ñúun³ juɨɨ³ je² rɨ²³bɨ́² 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","'E³ quie'²³ te³ sɨ³li³láa²³ 'e³ rɨ²³dxi²³quié̱n² dsa³ mɨ³rɨ³li³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’'E³ quie'²³ rɨ²³jɨ̱ɨ̱'n³te'²³ 'nee'²³ quie'² dsa³ 'i³ ta'n² ta² 'e³ cu²cuǿø¹te'²³ 'nee'²³ u²³ŋɨ́³ dsɨ́ɨ². Rɨ²³jŋɨ'n²³te'²³ 'nee'²³. Rɨ²³lí³ 'e³ hui²³dsɨ́ɨn² la²³jɨn³ dsa³ ñin³² 'nee'²³ 'e³ jua'³ rɨ³løn³¹na'³ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","'E³ jo̱³ juɨ́ɨn²³ 'i³ rɨ²³'lǿn²³, 'e³ rɨ²³'nɨ́ɨn²³ uu'n². Rɨ²³lí³ 'e³ hui²³dsɨ́ɨn² ñin³² uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Juɨ́ɨn²³ dsa³ 'i³ te³ rɨ²³júu² 'i³ jua'³ 'e³ 'ɨɨ³ júu² quiee'³² Dios. Rɨ²³jmóo² 'e³ juɨ́ɨn²³ dsa³ 'i³ rɨ²³sɨ²³caa'n³² jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bi²³ cɨ² rɨ²³jmóo² dsa³ 'e³ 'a²³jia'³ dxʉ́²³. 'E³ jo̱³ 'a²³la³ jø'n³ hua² cɨ² 'i³ 'néen² quie'²³ uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","'E³ quie'²³ rɨ²³láan³ dsa³ 'i³ rɨ²³táa²³ la²³huø'n²³ rɨ²³líi². ");
INSERT INTO cnlNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Rɨ²³'ɨ́ɨ²³ dsa³ júu² dxʉ́²³ 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³. La²³ca̱a̱n³ mɨ³¹güii³ rɨ²³'ɨ́ɨ²³te'²³ júu² dxʉ́²³ 'e³ la²³ rɨ²³dsóo²³ dsɨ́² la²³jɨn³ dsa³. Jo̱³ hua² rɨ²³dxá³ jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ca²³lʉ́³ Daniel, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². Ca²³jua'³ 'e³ 'e³ cɨ² li²³xa³ 'e³ 'a²³jia'³ ta³dsɨ³ra², 'e³ rɨ²³mi²³gua'²³ la²³jɨ³. 'E³ cɨ² rɨ²³née² 'e³ jo̱³ je² bi²³ 'mɨ'n²³ ñʉ'²³ 'ñʉ́² gáan³. 'Ne'² rɨ²³jmóo² 'i'²³ dsa³ 'i³ rɨ²³jóo² ji³ la³. Mɨ³rɨ³móo³ra'³ 'e³ née² 'e³ jo̱³ je² bi²³ 'mɨ'n²³, ");
INSERT INTO cnlNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","li²³'ne'² rɨ²³cuɨ̱́ɨ̱² sɨ³guín²³ je² bi²³ xa³ mo'³ dsa³ 'i³ nee'n²³² estado Judea. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","'A²³jia'³ 'ne'² 'e³ rɨ²³dsø'n² xi²ñʉ'¹ dsa³ 'i³ 'iún² coo'² 'ñʉ́² 'e³ jua'³ sɨ³quié̱³ 'e³ xa³ quie'² 'e³ nee'²³² xi²ñʉ'¹. 'Ne'² rɨ²³cuí̱i̱²³ xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","'E³ quie'²³ la'³ 'a²³jia'³ 'ne'² rɨ²³dsø'n² co̱'³ dsa³ 'i³ jmee²³ ta² je² nuu³ 'e³ jua'³ sɨ³quié̱³ 'mɨɨ'³ dxóo³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bi²³ juɨɨ³² mɨ́³ 'i³ huǿøn³ xi³yu̱u̱n³ quie'² mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³. Bi²³ juɨɨ³² mɨ́³ 'i³ tʉ'n³² xi³yu̱u̱n³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Rɨ²juɨɨ'³¹ra'³ Dios 'e³ 'a²³la³ jo̱³ ji̱i̱³ 'e³ güi'³ mɨ³rɨ³ti³ 'e³ rɨ²cui̱i̱³¹ra'³, 'e³ 'a²³la³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³, bi²³ li²³xa³ u²³ŋɨ́³ dsɨ́ɨ². Cɨ'²³ la²³ ca²³jmée³ Dios mɨ³¹güii³, 'a²³jia'³ lɨ'³ ca³la³xa³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ la²³'nɨɨ'n³¹ li²³xa³ u²³ŋɨ́³ dsɨ́ɨ². 'E³ quie'²³ 'a²³jia'³ ma²³ li²³xa³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ca²³jmée³ Dios 'e³ li²³mi'n³ cɨ² jmɨ́ɨ² 'e³ li²³xa³ u²³ŋɨ́³ dsɨ́ɨ² la'³. Qui² 'u² cu²ru'³ 'a²³jia'³ ca²³jmée³ la'³ Dios, 'a²³'i̱³ xen³ dsa³ mɨ³¹güii³ 'i³ 'a²³jia'³ rɨ²³dxi²³jú̱n³ 'u² cu²ru'³ la'³. Ca²³jmée³ 'e³ li²³mi'n³ cɨ² jmɨ́ɨ² 'e³ li²³xa³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ jua'³ bi²³ 'néen² dsa³ 'i³ ca²³'náan²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’'E³ jo̱³ 'a²³jia'³ 'ne'² rɨ²³sɨ²³táan³na'³ xi³nu³ rɨ²³jua'³ dsa³, rɨ²³sɨ'²³ 'nee'²³: “'I³ la³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios, ¿mɨ³naa'³¹?”, xi³nu³ rɨ²³jua'³te'²³: “'I³ núu²³, ¿mɨ³naa'³¹?” ");
INSERT INTO cnlNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Qui² 'e³ cɨ² li²³xen³ dsa³ 'i³ te³ juu³² 'e³ rɨ²³jmóo² 'e³ jua'³ 'e³ rɨ³løn³¹te'¹ Cristo, 'e³ rɨ²³jmóo² 'e³ jua'³ 'e³ 'ɨɨ³te'²³ júu² quiee'³² Dios. Rɨ²³jmóo²te'²³ u²³juø'²³. Qui² 'née²³ rɨ²³júun² dsa³ 'i³ ca²³'náan²³ Dios 'u² cu²ru'³ rɨ²³lí³ juø'² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mɨ³juǿøn²na²³ 'nee'²³ 'e³ la²³ 'íi² cɨ² rɨ²³lí³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","'E³ jo̱³ 'a²³jia'³ 'ne'² cu³guín²³na'³ xi³nu³ rɨ²³sɨ'²³te'²³ 'nee'²³: “'Iún² Cristo je² 'a²³jia'³ nee'n²³² dsa³, ¿mɨ³naa'³¹?” 'E³ quie'²³ la'³ 'a²³jia'³ 'ne'² rɨ²³sɨ²³táan³na'³ xi³nu³ rɨ²³sɨ'²³te'²³ 'nee'²³: “Rɨ³'mǿn² xi²ñʉ'¹, ¿mɨ³naa'³¹?” ");
INSERT INTO cnlNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Lii²³ 'e³ la²³ 'mii'²³ i²³'ñeen³¹ rɨ³ca̱'n²³ mɨ³¹güii³. 'E³ quie'²³ la'³ li²³lii²³ mɨ³rɨ³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Te³ jiaa'³¹ ra̱a̱n²³ 'lɨ́ɨ³, 'e³ quie'²³ núu²³ rɨ²³ñii'n²³ tu³ sɨ̱ɨ̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Xe̱'n² mɨ³rɨ³dxi³ŋɨ́n³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ li²³xa³, rɨ²³yʉʉ³ ji³ quiee'³² ñi'². 'A²³jia'³ ma²³ li²³xa³ jmɨ́ɨ²³ quiee'³² sɨɨ'³ co̱'³. Rɨ²³jiu'n² li²³'áan² 'i³ rɨ³pee'n³² mɨ³¹güii³. Rɨ²³bɨ́n² 'i³ 'uee'n³ 'i³ rɨ³pee'n³² mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","'E³ quie'²³ jo̱³ li²³jné²³ mɨ³¹güii³ 'e³ jmee²³ lii²³ 'e³ mɨ³ aa'n³²na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. 'E³ jo̱³ bi²³ rɨ²³'o'² la²³jɨ³ ta'n² dsa³ mɨ³¹güii³. Rɨ²³ñín²te'²³ jné² Jo̱o̱³¹ Dsa³ 'e³ la²³ aa'n³²na²³ co̱'³ jee²³² jníi². Bi²³ 'uee'n²³na²³ mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³. Bi²³ gáan³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","'E³ quie'²³ jo̱³ mɨ³rɨ³'i̱i̱² cuoo'³, rɨ²sɨɨn³¹na¹ ángeles quién²³na²³. La²³ca̱a̱n³ la²³ mɨ³¹güii³ rɨ²³ñii'n³te'²³ dsa³ 'i³ ca²³'náan²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’'Ne'² rɨ²jmée²ra'³ 'i'²³ 'e³ jmii'³¹ jmee²³ 'mo³ higo. Jo̱³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ 'i'²³ 'e³ jmii'³¹ lǿ² 'e³ rɨ²³güe'n²³na²³ co̱'³: Mɨ³rɨ³'aa³ 'i'²³ 'e³ sɨ³li³xi'²³ guoo³ 'mo³ higo, 'e³ sɨ³'ia³ mee³¹, jo̱³ sɨ³li³lii²³ 'e³ mɨ³ rɨ²³gua³ ji̱²³'ioo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","'E³ quie'²³ la'³ mɨ³rɨ³móo³ra'³ 'e³ sɨ³lí³ la²³jɨ³ 'e³ mɨ³juǿøn²na²³ 'nee'²³, 'e³ jo̱³ rɨ²móo²ra'³ 'e³ mɨ³lǿ²³ mɨ³lén², 'e³ mɨ³ rɨ²³tɨ́²³ 'e³ rɨ²³güe'n²³na²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xa³ quie'²³ ju̱u̱n²³ dsa³ 'i³ xen³ rɨ³nɨ²³ mɨ³rɨ³li³ la²³jɨ³ 'e³ mɨ³juǿøn²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","'E³ cɨ² rɨ²³lí³ 'e³ 'a²³'e³ ma²³ xa³ mɨ³¹güii³ quia̱'² 'uǿ²³ la³. 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² te³ rɨ²³gua'²³ júu² quián²³. Ca³quie̱e̱² rɨ²³lí³ 'e³ la²³ lǿ². ");
INSERT INTO cnlNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Jø̱n³ Ñu'n²³ hua² 'i³ ñi³² 'e³ 'ee² jmɨ́ɨ², 'e³ 'ee² hora 'e³ rɨ²³lí³ la'³. 'A²³'i̱³ xen³ cɨ² 'i³ ñi³². 'A²³ cɨ'²³ te'²³ ángeles 'i³ nee'n²³² yʉʉ'³¹ güii³. 'A²³ cɨ'²³ jné² Jo̱o̱³¹ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’La²³ lǿ² jmɨ́ɨ² ma²jen³¹ mɨ³¹güii³ Noé mɨ²jaa²³², 'e³ quie'²³ la'³ cu³lø³¹ 'e³ rɨ²³lí³ mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","La²³ca̱a̱n³ mɨ²jo̱³ 'e³ 'íi² rɨ²³quie̱e̱'n²³ jmɨɨ³ mɨ³¹güii³, 'ɨ̱ɨ̱'³² ee'³² quie'²³ dsa³. Tøø²³ quie'²³ dsa³ mɨ́³. Cuøn³² quie'²³ jo̱²³mɨɨ³¹te'¹ 'e³ rɨ²³jén²³ dsa³. Sɨ³lí³ quie'²³ la'³ la²³huøø'n³¹ la²³ 'e³ ca²³tɨ́³ 'e³ 'í² Noé 'e̱'³ móo². ");
INSERT INTO cnlNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","'A²³jia'³ ca²³la²³quii²³ dsa³ la²³huø'n²³ 'e³ ca²³tɨ́³ 'e³ ca²³cø̱'n²³ jmɨɨ³ mɨ³¹güii³, 'e³ ca²³éen³ la²³jɨn³ dsa³. 'E³ quie'²³ la'³ cu³lø³¹ rɨ²³lí³ mɨ³rɨ³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Juø'n³ quie'²³ xen³ áan²³ dsa³ 'i³ ta'n² ca³ti³² je² nuu³ jmɨ́ɨ² jo̱³, rɨ²³tøø³ Dios jø̱n³, 'e³ quie'²³ rɨ²³cuaa'n²³ jø̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Juø'n³ quie'²³ xen³ áan²³ mɨ́³ 'i³ dsɨ³ ca³ti³², rɨ²³tøø³ Dios jø̱n³, 'e³ quie'²³ rɨ²³cuaa'n²³ jø̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’'Ne'² rɨ²mi³quii²³²ra'³ jo̱o̱²³na²³. Qui² 'a²³jia'³ móo³ra'³ 'e³ 'ee² jmɨ́ɨ² rɨ²³güe'n²³na²³ co̱'³ jné² Juii³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'Ne'² rɨ²jmée²ra'³ 'i'²³ jo̱o̱²³na²³: La²³ cu²ru'³ xen³ jø̱n³ dsa³ 'i̱i̱³ 'i³ 'née²³ rɨ²³'í³ xi²ñʉ'¹ quiee'³² dsa³. 'U² cu²ru'³ ñi³² juii² xi²ñʉ'¹ 'e³ 'ee² hora 'e³ 'uøø²³ 'e³ rɨ²³güén³ dsa³ 'i̱i̱³, rɨ²³mi²³quii²³² cu²ru'³ la'³. Jo̱³ hua² 'a²³jia'³ rɨ²³cuǿ²³ júu² 'e³ rɨ²³'í³ dsa³ 'i̱i̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","'E³ jo̱³ 'ne'² rɨ²mi³tɨ́ɨ²³ra'³ 'nee'²³ co̱'³. Qui² rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³ hora je² 'a²³jia'³ xi²dsɨ́n³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿'I̱i̱² sɨɨ'³¹ 'nee'²³ 'i³ li²³xen³na'³ la²³ xen³ jø̱n³ mozo 'i³ bi²³ ta³jmee²³ 'i'²³, 'i³ jmee²³ 'e³ la²³ ca²³jua'³ juii² 'e³ 'ne'² rɨ²³jmée²³? Ca²³dxi³ 'i'²³ juii² 'e³ rɨ²³jmée²³ cua̱a̱n²tu² xi²ñʉ'¹ quiee'³², 'e³ rɨ²³jmée²³ ji̱i̱³ 'e³ rɨ²³e'² te'²³ jia'³ cɨ'²³ mozos mɨ³rɨ³ti³ hora 'e³ la²³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³e'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bi²³ dxʉ́²³ quie'² mozo 'í³ mɨ³rɨ³güe'n²³ co̱'³ juii², mɨ³rɨ³ñí³ juii² 'e³ jmee²³ mozo 'e³ la²³ ca²³dxi³ 'i'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Rɨ²³cuǿø²³ mozo quien³² la²³jɨ³ sú̱n² 'e³ xa³ quie'² 'ñée² 'e³ cu²lín³ cua̱a̱n²tu² mozo. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","'E³ quie'²³ 'a²³jia'³ dxʉ́²³ quie'² mozo 'i³ 'a²³jia'³ jmee²³ 'e³ dxʉ́²³, 'i³ lǿn³ 'e³ sɨ³li³'ɨɨn²³² juii². ");
INSERT INTO cnlNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'E³ jo̱³ rɨ²³cuǿ²³ quie'² uu'n². Rɨ²³'ɨ̱'² rɨ²³e'² quia̱'² dsa³ ŋoo'². ");
INSERT INTO cnlNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Rɨ²³güe'n²³ co̱'³ juii² mozo 'í³ jmɨ́ɨ² je² 'a²³jia'³ xi²dsɨ́n³, hora 'e³ 'a²³jia'³ ñi³² mozo. ");
INSERT INTO cnlNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bi²³ juø'²³ cu³lø³¹ rɨ²³jmée²³ mɨ³rɨ³jmee³ jñiin²³ mozo. Qui² rɨ²³ji̱'²³ 'e³ la²³ sɨ³ji̱'²³ dsa³ 'i³ te³ jmoo³² guóo². Je² núu²³ rɨ²³'o'² dsa³. Rɨ²³cuu'³ la²³ cɨ² jo̱²te'¹ la²³'nɨɨ'n³¹ 'e³ rɨ²³ŋɨ́³ dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’La²³la³ cu³lø³¹ rɨ²³lí³ quie'² dsa³ 'i³ 'née²³ 'e³ rɨ²³lín³ juii²te'¹ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. Li²³xen³te'²³ la²³ xen³ guién²³ xii'³ mɨ́³ 'i³ có̱²³ 'é̱e̱² jmɨɨ³ quiee'³² 'e³ i²guín¹te'²³ 'e³ jua'³ rɨ²³jé̱n²te'²³ dxi²jui³¹ xii'³ 'i³ rɨ²³tǿø²³ mɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Xen³ 'ñén³ 'i³ 'a²³jia'³ jmoo³² 'i'²³. 'E³ quie'²³ xen³ 'ñén³ 'i³ jmoo³² 'i'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","'Ñén³ 'i³ 'a²³jia'³ jmoo³² 'i'²³ 'i³ quie̱³ 'é̱e̱² jmɨɨ³, 'e³ quie'²³ 'a²³jia'³ quie̱³ noo²³² 'e³ rɨ²³xi'²³te'²³ 'e³ la²³ rɨ²³so̱'³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'Ñén³ 'i³ jmoo³² 'i'²³ 'i³ quie̱³ mɨ²sɨ́¹ 'e³ 'o² noo²³² ca³ti³² quia̱'² 'é̱e̱² jmɨɨ³ quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","'E³ quie'²³ ca²³la²³'ɨɨn²³² xii'³ 'i³ rɨ²³tǿø²³ mɨ́³. 'E³ jo̱³ ca²³too'²³ la²³guɨɨn³ la²³jɨn³. 'E³ jo̱³ ca²³guɨɨn³te'²³ ca³quie̱e̱². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ma²ca¹tɨ́³ dxoo'³¹ 'uøø²³, tǿ²³ dsa³. Ca²³jua'³: “Mɨ³ ja³ xii'³ dsóo²³ 'i³ rɨ²³tǿø²³ mɨ́³. Cu³guín²³na'³ 'e³ rɨ²mi³jí̱i̱n²na'³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","'E³ quie'²³ jo̱³ ca²³naa'n²³ la²³jɨn³ xii'³ mɨ́³. Ca²³xe̱'n²te'²³ ji³ quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ca²³jua'³ te'²³ xii'³ mɨ́³ 'i³ 'a²³jia'³ rɨ³tɨ́ɨ²³ quie'². Ca²³sɨ'²³ uu'n² 'i³ rɨ³tɨ́ɨ²³ quie'²: “Rɨ²jmée²ra'³ co̱o̱³ mɨ²'áa² 'e³ rɨ²cuøø³¹ra'³ jnee'³¹ ca³juɨ² noo²³². Qui² bi²³ sɨ³yʉʉ³ ji³ quiee³²ra'³¹.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'E³ quie'²³ ca²³jua'³ miin²³ te'²³ xii'³ mɨ́³ 'i³ rɨ³tɨ́ɨ²³ quie'²: “'A²³jia'³ rɨ²³lí³ juø'². Qui² 'a²³jia'³ rɨ²³dxi²³quie̱'n²³ noo²³² quiée²ra² ca³ti³². Bi²³ cɨ² dxʉ́²³ cu³guín²³na'³ je² sɨ³'nɨɨ² 'e³ rɨ²có̱²ra'³ 'e³ 'ne'² quién²na'³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","'E³ la²³ jiaan³quie'²³te'²³ co̱³²te'²³ noo²³², ca²³dxóo² xii'³ dsóo²³ 'i³ rɨ²³tǿø²³ mɨ́³. Ca²³ta'n²³ xi²ñʉ'¹ ca³ti³² quia̱'² xii'³ dsóo²³ la²³jɨn³ 'i³ rɨ³tɨ́ɨ²³ quie'². Ca²³ta'n²³te'²³ xi²ñʉ'¹ je² rɨ²³lí³ mɨ²juee'³. 'E³ quie'²³ jo̱³ ca²³jní³ dsa³ 'oo'² 'ñʉ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Cɨ̱ɨ̱n³ cɨ² ca²³dxi²³guiin³² co̱'³ te'²³ xii'³ mɨ́³ 'i³ i²guín¹ i²quié̱³ noo²³². Ca²³jua'³te'²³: “Juii³ra'³¹. Juii³ra'³¹. Rɨ²nǿn² quiée²ra'³¹ xú̱n³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","'E³ quie'²³ ca²³jua'³ 'ñée²: “Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹ 'e³ 'a²³jia'³ cuiin²³na²³ 'nee'²³”. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","'E³ jo̱³ ca²³jua'³ Jesús: ―'Ne'² rɨ²mi³quii²³²ra'³ jo̱o̱²³na²³. Qui² 'a²³jia'³ móo³ra'³ 'e³ 'ee² jmɨ́ɨ², 'e³ 'ee² hora 'e³ rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ Dios juii² dsa³: La²³ cu²ru'³ xen³ jø̱n³ dsa³ 'i³ lǿn³ 'e³ rɨ²³dsóo² je² huɨ̱́ɨ̱³. Ca²³tøø³ mozos quien³². Ca²³to'²³ dxóo² cuu² quiee'³² 'e³ bi²³ quí̱i̱n²³. Ca²³cuǿø²³ mozos 'e³ cu²jmóo¹te'²³ ta². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Ca²³cuǿø²³ 'ñé³ cuu² jø̱n³. Ca²³cuǿø²³ jia'³ cɨ'²³ tú̱²³ cuu². Ca²³cuǿø²³ jia'³ cɨ'²³ co̱o̱³ cuu². Ca²³cuǿø²³ cɨ'³ la²³ jø̱n³ la²³'nɨɨ'n³¹ 'e³ tɨn³ ta³jmoo³² ta² quia̱'² cuu². Ŋóo² je² huɨ̱́ɨ̱³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jo̱³ tu³ ŋóo² dsa³ 'i³ 'ióo² 'ñé³ cuu². 'E³ quie'²³ jo̱³ ca²³ló². 'E³ quie'²³ jo̱³ ca²³'nɨ́ɨ³. La'³ hua² 'e³ ca²³xén² cɨ² 'ñé³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","'E³ quie'²³ la'³ ca²³jmée³ dsa³ 'i³ 'ióo² tú̱²³ cuu² co̱'³. 'E³ jo̱³ xén² cɨ² tú̱²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","'E³ quie'²³ ŋóo² dsa³ 'i³ 'ióo² co̱o̱³ cuu². Ca²³yʉ́ʉ² too³ 'uǿ²³. Ca²³'mé³ cuu² quiee'³² juii². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Ma²ca¹la¹huǿø³ 'e³ jiaan³ juii² mozos, ca²³dxe'n² co̱'³. Ca²³jmée³ cua̱a̱n²tu² quia̱'² mozos quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ca²³dxóo² mozo 'i³ 'ióo² 'ñé³ cuu². Quie̱³ cɨ² 'ñé³. Ca²³jua'³: “Rɨ²juøøn³¹na¹ 'nʉ³, Juiin²³. Ca²³cuǿøn²nu³ jné² 'ñé³ cuu² quien³²nu³. 'E³ la³ cɨ² 'ñé³ 'e³ mɨ³xén³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'E³ jo̱³ ca²³jua'³ juii². Ca²³sɨ'²³ mozo: “Bi²³ dxʉ́²³ mɨ³jméen² 'nʉ³, mozo quién²³na²³. Bi²³ dxún²³nu³. Ca²³jméen² 'e³ la²³ ya̱'n³nu³ rɨ²jméen². Bi²³ dxʉ́²³ ca²³jméen² ta² quia̱'n²nu³ cuu², juø'n³ quie'²³ ca³juɨ². 'E³ jo̱³ rɨ²cuǿøn¹na²³ 'nʉ³ ñúun³ cɨ². 'Náan²³ 'e³ rɨ²jméen² 'e³ jɨn³ 'áan² quia̱'n²nu³ jné².” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","'E³ quie'²³ la'³, ca²³dxóo² mozo 'i³ 'ióo² tú̱²³ cuu². Ca²³jua'³: “Rɨ²juøøn³¹na¹ 'nʉ³, Juiin²³: Ca²³cuǿøn²nu³ jné² tú̱²³ cuu² quien³²nu³. 'E³ la³ cɨ² tú̱²³ 'e³ mɨ³xén³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","'E³ jo̱³ ca²³jua'³ juii². Ca²³sɨ'²³ mozo 'í³: “Bi²³ dxʉ́²³ mɨ³jméen² 'nʉ³, mozo quién²³na²³. Bi²³ dxún²³nu³. Ca²³jméen² 'e³ la²³ ya̱'n³nu³ rɨ²jméen². Bi²³ dxʉ́²³ ca²³jméen² ta² quia̱'n²nu³ cuu², juø'n³ quie'²³ ca³juɨ². 'E³ jo̱³ rɨ²cuǿøn¹na²³ 'nʉ³ ñúun³ cɨ². 'Náan²³ 'e³ rɨ²jméen² 'e³ jɨn³ 'áan² quia̱'n²nu³ jné².” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","'E³ quie'²³ la'³, ca²³dxóo² mozo 'i³ 'ióo² co̱o̱³ cuu². Ca²³jua'³: “Rɨ²juøøn³¹na¹ 'nʉ³, Juiin²³: Maan²³ 'e³ bi²³ juø'²³ cu³løn³¹nu³. Qui² dxen³ guaan³² ta² je² 'a²³jia'³ ca²³jméen² jmo². Ca̱a̱n²³ 'nʉ³ la²³jɨ³ láa², juø'n³ quie'²³ 'a²³jia'³ néen²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","'E³ jo̱³ hua² 'e³ 'ñaa'n²³na²³ 'nʉ³. 'E³ jo̱³ i²'mén¹ too³ 'uǿ²³ cuu² quien³²nu³. 'E³ la³ cuu² quien³²nu³ jo̱o̱²³na²³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","'E³ quie'²³ ca²³jua'³ juii² mozo: “Bi²³ 'a²³jia'³ dxʉ́²³ jmeen³ 'nʉ³, mozo quién²³na²³. Bi²³ juɨ'n²³nu³. Qui² máan³ 'nʉ³ 'e³ dxen²³ guaan²³ ta² je² 'a²³jia'³ ca²³jméen²³ jmo². 'E³ quie'²³ máan³ 'nʉ³ 'e³ ca̱a̱n³² la²³jɨ³, juø'n³ quie'²³ 'a²³la³ jné² ca²³jñin²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿'Ee² lǿ² 'a²³jia'³ ca²³jɨ̱'n² cuu² quián²³ dsa³ 'i³ sɨ³li'²³ juø'² xen³² cuu²? Lǿ²³ juø'² ca²³cá̱a̱n² co̱'³ ca³ti³² quia̱'² jo̱o̱³¹ cuu² ma²mɨ³güe'n³²na²³ co̱'³ 'u² cu²ru'³ ca²³jméen² la'³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'E³ jo̱³ ca²³sɨ'²³ dsa³ 'i³ té̱e̱n³ caan²³: “Rɨ²co̱o̱²³ra'³ cuu² 'e³ xe̱e̱'³ dsa³ la³. Rɨ²cuøø³¹ra'³ mozo 'i³ xa³ guiá²³ 'nɨɨ'n³¹ cuu² quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Qui² ñúun³ cɨ² rɨ²³'ióo²³ dsa³ 'i³ xa³ ca³juɨ² quie'² xe̱'n². 'E³ jo̱³ bi²³ li²³ñúun³ xa³ quie'². 'E³ quie'²³ rɨ²³je̱'n²te'²³ la²³'nɨɨ'n³¹ qui³ 'e³ xa³ quie'² dsa³ 'i³ 'a²³'e³ xa³ quie'² xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Rɨ²juen²³na'³ xi²dxi³² je² li³'o̱o̱³ mozo 'i³ 'a²³jia'³ 'nee'n³¹. Je² núu²³ rɨ²³'o'² dsa³. Rɨ²³cuu'³ la²³ cɨ² jo̱²te'¹ la²³'nɨɨ'n³¹ 'e³ rɨ²³ŋɨ́³ dsɨ́²te'²³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Rɨ²ñin²³² sii³¹ quián²³ 'e³ bi²³ gáan³ mɨ³rɨ³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. Bi²³ gáan³na²³ mɨ³rɨ³güe'n²³na²³ quia̱'n²³²na¹ la²³jɨn³ ángeles quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Rɨ²³ñii'n²³ xi²ñin²³ la²³jɨn³ dsa³ mɨ³¹güii³. 'E³ jo̱³ rɨ²xiin³¹ rɨ²ŋɨɨn³¹na¹ i²³la³ i²³nɨ³ 'e³ la²³ jmee²³ juii² 'i³ xiin³² ŋɨɨn³² dsɨɨ³ joo³ quia̱'² xʉ̱́ʉ̱² lóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Rɨ²sɨ'n³¹na¹ jaan²³na²³ 'e³ dxʉ́²³ 'i³ xen³ la²³ xen³ dsɨɨ³ joo³. 'E³ quie'²³ rɨ²sɨ'n³¹na¹ jaan²³na²³ 'i²³jia'³ 'i³ xen³ la²³ xen³ xʉ̱́ʉ̱² lóo². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","'E³ jo̱³ jné² 'i³ rɨ³løn³¹na¹ rey rɨ²juøøn³¹na¹ dsa³ 'i³ té̱e̱n³ jaan²³na²³ 'e³ dxʉ́²³: “Rɨ²juøøn³¹na¹ 'nee'²³ 'i³ mɨ³mi³jé̱e̱n² Ñu'n²³: Ñe³ra'³ rɨ²taa'n³²na'³ je² rɨ³løn³¹ juii² Dios. Røøn³na'³ 'e³ rɨ²taa'n³²na'³ cɨ'²³ la²³ ma²ca¹lǿ¹ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Qui² ca²³cuǿ²ra'³ 'e³ ca²³ee'n²³ ma²ca¹la¹cué̱e̱n¹. Ca²³cuǿ²ra'³ 'e³ ca²³uu'n²³ ma²ca¹la¹dxíin³ dsɨn²³. Ca²³tée²ra'³ jné² xi²ñʉ'¹ quien³²na'³ ma² 'a²³'i̱³ xen³ 'i³ cuiin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ca²³cuǿø²ra'³ jné² cua̱a̱n²³ ma² 'a²³'e³ xa³ quián²³. I²³jóon²³na'³ jné² ma²ca¹la¹dsaan²³². I²³guín²³na'³ je² 'iun²³²na¹ i²³ñí².” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","'E³ jo̱³ rɨ²³jua'³ dsa³ 'i³ rɨ³løn³¹ ca³dsaan³²: “Juii³ra'³¹. ¿Mɨ²lɨɨ'³¹ 'e³ ca²³cuøø³¹ra'³¹ 'nʉ³ 'e³ ca²³quie'n³ ma²ca¹la¹cué̱e̱n¹nu³? ¿Mɨ²lɨɨ'³¹ 'e³ ca²³cuøø³¹ra'³¹ 'nʉ³ 'e³ ca²³'i̱i̱'n³ ma²ca¹la¹dxíin³ 'áan²? ");
INSERT INTO cnlNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Mɨ²lɨɨ'³¹ 'e³ ca²³tee³¹ra'³¹ 'nʉ³ xi²ñʉ'¹ quiee³²ra'³¹ ma² 'a²³'i̱³ xen³ 'i³ cuiin²³ 'nʉ³? ¿Mɨ²lɨɨ'³¹ 'e³ ca²³cuøø³¹ra'³¹ 'nʉ³ cua̱a̱n³² ma² 'a²³'e³ xa³ quién²nu³? ");
INSERT INTO cnlNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Mɨ²lɨɨ'³¹ 'e³ i²joon²³²na'³¹ 'nʉ³ ma²ca¹la¹dsáan²nu³, ma²'iun³¹nu³ i²³ñí²?” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","'E³ jo̱³ jné² 'i³ rɨ³løn³¹ rey rɨ²juøøn³¹ dsa³ 'í³: “Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'É̱e̱² 'e³ la'³ cu³lø³¹ ca²³jme'²ra'³ jné² ma²ca¹jme'²ra'³ la'³ jø̱n³ ja̱a̱n³², juø'n³ quie'²³ jø̱n³ 'i³ 'a²³jia'³ gáan³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’'E³ quie'²³ jo̱³ rɨ²juøøn³¹na¹ dsa³ 'i³ té̱e̱n³ jaan²³na²³ 'i²³jia'³: “Je̱'n²na'³ 'nee'²³ 'i³ ta'n² juɨ́ɨn³. Cu³guín²³na'³ dxi³¹ji³ je² rɨ³jøn³¹ ji³ ca³cuaa³. Qui² núu²³ røøn³ 'e³ rɨ²³'í³ mɨ²³sɨ²³quiʉ'² ca³ti³² quia̱'² ángeles quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Qui² 'a²³'e³ xa³ 'e³ ca²³cuǿø²ra'³ jné² 'e³ rɨ²ee'n²³² ma²ca¹la¹cué̱e̱n¹. 'A²³'e³ xa³ 'e³ ca²³cuǿø²ra'³ jné² 'e³ rɨ²uu'n²³² ma²ca¹la¹dxíin³ dsɨn²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","'A²³jia'³ ca²³tée²ra'³ jné² xi²ñʉ'¹ quien³²na'³ ma² 'a²³'i̱³ xen³ 'i³ cuiin²³ jné². 'A²³jia'³ ca²³cuǿø²ra'³ jné² cua̱a̱n²³ ma² 'a²³'e³ xa³ quián²³. 'A²³jia'³ ca²³gui²³jóon²³na'³ jné² ma²ca¹la¹dsaan²³², ma²'iun²³²na¹ i²³ñí².” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","'E³ jo̱³ rɨ²³jua'³ dsa³ 'í³: “Juii³ra'³¹. ¿Mɨ²lɨɨ'³¹ 'e³ ca²³jí̱i̱n³na'³¹ 'nʉ³ 'e³ cué̱e̱n²nu³, 'e³ dxíin³ 'áan², 'e³ 'a²³'i̱³ xen³ 'i³ cuiin²³ 'nʉ³, 'e³ 'a²³'e³ xa³ cua̱a̱n³², 'e³ dsáan²nu³, 'e³ 'iún²nu³ i²³ñí², 'e³ 'a²³jia'³ ca²³mi²³quin²³na'³¹ 'nʉ³?” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","'E³ jo̱³ rɨ²juøøn³¹ dsa³ 'í³: “Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'É̱e̱² 'e³ 'a²³jia'³ ca²³mi²³quin²³na'³ jné² 'e³ 'a²³jia'³ ca²³mi²³quin²³na'³ jø̱n³ dsa³ quién²³na²³, juø'n³ quie'²³ 'a²³jia'³ gáan³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","'E³ jo̱³ rɨ²³sɨ²³guiin³² je² rɨ²³ji̱'²³ jñiin²³te'²³ ca³cuaa³. 'E³ quie'²³ rɨ²³sɨ²³guiin³² dsa³ 'i³ rɨ³løn³¹ ca³dsaan³² je² rɨ³ji̱'²³te'²³ ca³cuaa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ma²mɨ³líi² mɨ³lʉ́³ la'³ Jesús, jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ");
INSERT INTO cnlNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Móo³ra'³ 'e³ 'áa²³ 'ióo² rɨ²³tɨ́²³ mɨ²juee'³ pascua. Rɨ²³jɨ̱'n²te'²³ jné² Jo̱o̱³¹ Dsa³ quie'² dsa³ 'i³ rɨ²³te̱e̱n³ jné² cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","'E³ quie'²³ jo̱³ ca²³ŋɨɨ'n²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley quia̱'² te'²³ dsa³ mɨ³dxún²³ quien³² dsa³ juɨɨ³. Ca²³ŋɨɨ'n²³te'²³ ñʉ'²³ 'ñʉ́² gáan³ je² jen³¹ juii² jmii³ dsa³ 'i³ xi̱i̱n³ Caifás. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ca²³sɨ́n²³te'²³ júu² 'e³ jua'³ 'née²³te'²³ 'e³ rɨ²³sø̱'n²te'²³ Jesús je² 'mo² je² ñi², 'e³ jua'³ 'née²³te'²³ 'e³ rɨ²³jŋɨ'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ca²³jua'³te'²³: ―'A²³jia'³ rɨ²³lí³ juø'² 'e³ rɨ²³lí³ la'³ jee²³² je² sɨ³lí³ mɨ²juee'³. Qui² bi²³ juø'² rɨ²³sɨ²³lí³ rɨ²³sɨ²³dxóo³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jen³¹ Jesús juɨɨ³ Betania xi²ñʉ'¹ quiee'³² jø̱n³ dsa³ 'i³ xi̱i̱n³ Muun³² 'i³ ca²³ji̱'²³ goo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Güén²³ jø̱n³ mɨ́³ 'i³ quie̱³ mɨ²sɨ́¹ 'e³ rɨ³lø³¹ cú̱u̱² 'e³ xi̱i̱n³ alabastro. 'O² noo²³² mɨ³róo³ 'e³ bi²³ quí̱i̱n²³. Ca²³'uu²³ noo²³² mɨ²dxi² Jesús je² jen³¹ 'ñée² coo³¹ mesa. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","'E³ quie'²³ ca²³ti̱'n³ dsa³ quien³² ma²ŋó¹te'²³. Ca²³jua'³te'²³: ―¿'Ee² lǿ² mɨ³mi³gua'²³ noo²³² mɨ́³ nɨ³ cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bi²³ dxʉ́²³ 'u² cu²ru'³ 'e³ ca²³'nɨ́ɨ³ hua² 'u². Ñúun³ cuu² ca²³tɨ́n³ cu²ru'³ la'³. 'E³ jo̱³ ca²³la²³xa³ 'e³ rɨ²³cuǿø²³ dsa³ taan³ 'u² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Quii²³ Jesús 'e³ la'³ jua'³ dsa³ quien³². 'E³ jo̱³ ca²³jua'³: ―¿'Ee² lǿ² cuøø³²ra'³ u²³ŋɨ́³ dsɨ́ɨ² mɨ́³? Qui² bi²³ dxʉ́²³ 'e³ mɨ³jme'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tén³ xen³ dsa³ taan³ jee²³² quien³²na'³ 'e³ la²³ rɨ²jmée²ra'³ co̱²juø'¹ quie'². 'E³ quie'²³ 'a²³la³ tén³ jen³¹na¹ quia̱'n²³²na¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mɨ³'uun³ jné² noo²³² mɨ³róo³ 'e³ jua'³ mɨ³mi³tɨ́ɨ²³ quie'² jmɨn²³ ŋun²³ 'e³ la²³ rɨ²³'áan²te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Te³ jiaa'³¹ rɨ²³'ɨ́ɨ²³ dsa³ júu² dxʉ́²³ la²³ca̱a̱n³ mɨ³¹güii³, rɨ²³jua'³te'²³ 'e³ jmii'³¹ mɨ³jme'²³ jné² mɨ́³ la³ 'e³ la²³ li²³líi²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","'E³ quie'²³ jo̱³ ŋóo² jø̱n³ dsa³ gui²³tʉ̱́n³, 'i³ xi̱i̱n³ Judas Iscariote. I²lʉ² quia̱'² te'²³ juii² jmii³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ca²³jua'³: ―¿Lɨɨ'³¹ 'nɨɨ'n³¹ 'e³ rɨ²cuøø³¹ra'³ jné² xi³nu³ rɨ²jɨ̱ɨ̱'n²³²na¹ Jesús quién²na'³? 'E³ jo̱³ ca²³quí² te'²³ juii² jmii³ dsa³ gui²³guiá³ cuu² 'e³ rɨ³lø³¹ cu²taa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Cɨ'²³ mɨ²jo̱³ ca²³la²³láa²³ 'no'²³ Judas 'e³ jmii'³¹ li²³tɨ́ɨ²³ rɨ²³jɨ̱'n² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ca²³tɨ́³ co̱'³ jmɨ́ɨ² 'e³ sɨ³li³láa²³ mɨ²juee'³ 'e³ ee'³² dsa³ 'ɨ²³juɨ² 'e³ 'a²³'e³ xa³ xoo'³¹. 'E³ jo̱³ ca²³ŋɨɨ'n²³ caan²³ Jesús dsa³ quien³². Ca²³jua'³te'²³: ―¿Jiaa'³¹ 'naan³ 'e³ sɨ³mi³tɨ́ɨ²³ra'³¹ 'e³ rɨ²quiu'n²na² dsɨɨ³ joo³ 'i³ cu'n³ dsa³ mɨ²juee'³ pascua? ");
INSERT INTO cnlNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","'E³ jo̱³ ca²³jua'³ Jesús: ―Cu³guín²³na'³ jee²³² juɨɨ³ 'e³ cu³lʉ́²ra'³ quia̱'n²na'³ jø̱n³ dsa³. Rɨ²juɨɨ'³¹ra'³ dsa³ 'í³: “La²³la³ cu³lø³¹ jua'³ dsa³ 'e²³: Mɨ³lǿ²³ mɨ³lén² 'e³ rɨ²³tɨ́²³ jmɨ́ɨ² quián²³. 'E³ jo̱³ rɨ²jmeen²³² mɨ²juee'³ pascua quia̱'n²³²na¹ dsa³ quién²³na²³ xi²ñʉ'¹ quien³²nu³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","'E³ jo̱³ ca²³jmóo² dsa³ quien³² 'e³ la²³ ca²³dxi³ 'i'²³ Jesús. Ca²³mi²³tɨ́ɨ²³te'²³ la²³jɨ³ 'e³ li²³'ne'² mɨ³rɨ³ti³ mɨ²juee'³ pascua. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","'E³ la²³ sɨ³nʉʉ³ jen³¹ Jesús coo³¹ mesa quia̱'² dsa³ gui²³tʉ̱́n³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","'E³ la²³ nee'n²³² ee'³²te'²³, ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xen³ jø̱n³ 'nee'²³ 'i³ rɨ²'nɨɨn²³na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bi²³ ca²³ŋɨ́³ dsɨ́²te'²³. Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús cɨ'³ jø̱n³, cɨ'³ jø̱n³: ―¿'A² juø'² jné², Juiin²³? ");
INSERT INTO cnlNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","'E³ jo̱³ ca²³jua'³ 'ñée²: ―Rɨ²³'nɨ́ɨn²³ jné² jø̱n³ 'i³ ee'n²³ quia̱'n²³²na¹, jø̱n³ 'i³ mɨ³'a'²³ 'ɨ²³juɨ² quiee'³² 'e̱'³ huɨ̱́ɨ̱²³ je² ee'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sɨ³jí̱i̱n²³ jné² Jo̱o̱³¹ Dsa³ 'e³ la²³ lǿ² 'e³ to̱o̱²³ ji³ 'e³ rɨ²³jí̱i̱n²³. 'E³ quie'²³ bi²³ juɨɨ³² dsa³ 'i³ 'nɨɨn²³ jné² Jo̱o̱³¹ Dsa³. Bi²³ cɨ² dxʉ́²³ quie'² dsa³ 'í³ 'u² cu²ru'³ 'a²³jia'³ ca²³la²³xen³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","'E³ jo̱³ ca²³jua'³ Judas 'i³ ca²³'nɨ́ɨn²³ Jesús: ―¿'A² juø'² jné², dsa³ 'e²³? 'E³ jo̱³ ca²³jua'³ Jesús: ―La'³ cu³lø³¹ 'e³ la²³ mɨ³jue'n² 'uǿøn²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","'E³ la²³ nee'n²³² ee'³²te'²³, so̱'²³ 'ɨ²³juɨ² Jesús. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. Ca²³xíin² 'ɨ²³juɨ². Ca²³cuǿø²³ dsa³ quien³². Ca²³jua'³: ―Quie̱³ra'³ 'ɨ²³juɨ² la³ 'e³ rɨ³lø³¹ jmɨn²³ ŋun²³. Rɨ²cø'²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","'E³ quie'²³ jo̱³ so̱'²³ co̱o̱³ taza 'e³ 'o² jmɨɨ'³¹ mɨ²jø'² vino co̱'³. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. Ca²³cuǿø²³ dsa³ quien³². Ca²³jua'³: ―Rɨ²'u'²ra'³ la²³jɨn³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","'E³ la³ jmɨ²³'øn²³²na¹ 'e³ rɨ²³jmée²³ 'e³ quí̱i̱n²³ júu² 'mɨɨn³² quiee'³² Dios. Rɨ²³tʉ̱ʉ̱³ jmɨ²³'øn²³²na¹ 'e³ la²³ rɨ²³yʉʉ³ dsoo² quiee'³² juɨ́ɨn²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","'E³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ 'a²³jia'³ ma²³ rɨ²uu'n²³² co̱'³ jmɨɨ'³¹ mɨ²jø'² vino la²³huø'n²³ 'e³ rɨ²³tɨ́²³ 'e³ rɨ²uu'n²³² jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'mɨɨn³² quia̱'n²³²na¹ 'nee'²³ je² rɨ³løn³¹ juii² Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ca²³'é³te'²³ co̱o̱³ su̱u̱n³² 'e³ 'en³² Dios. 'E³ quie'²³ jo̱³ ca²³guín²³te'²³ mo'³ Olivos. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'Uøø²³ 'e³ rɨ³nɨ²³ rɨ²³'lǿn²³na'³ la²³jɨn³na'³ mɨ³rɨ³móo³ra'³ la²³jɨ³ 'e³ rɨ²³jí̱i̱n²³. Qui² to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: “Rɨ²jŋɨ'n³¹na¹ dsa³ 'i³ mi³quin³ dsɨɨ³ joo³. 'E³ jo̱³ rɨ²³sáan²³ rɨ²³jǿn²³ dsɨɨ³ joo³ quien³².” ");
INSERT INTO cnlNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","'E³ quie'²³ ma²mɨ³'áa³ 'i'²³ 'e³ mɨ³ji̱i̱'n²³na²³ co̱'³, ñiin²³ co̱'³ estado Galilea jén²³cɨ²na¹ la²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","'E³ jo̱³ ca²³jua'³ Peen²³²: ―Juø'n³ quie'²³ rɨ²³'lǿn²³ la²³jɨn³ mɨ³rɨ³joo³²te'²³ la²³jɨ³ 'e³ rɨ²³jí̱i̱n²nu³, 'a²³jia'³ jmɨ́ɨ² rɨ²³'lǿn²³na²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³²: ―Rɨ²juøøn³¹na¹ 'nʉ³ ju²dsoo³¹: 'Uøø²³ 'e³ rɨ³nɨ²³, 'e³ 'íi² rɨ²³tǿ² 'nɨɨ'², rɨ²juɨɨ'n³¹ dsa³ 'nɨ³ taa'² 'e³ 'a²³jia'³ cuiin²³nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","'E³ jo̱³ ca²³jua'³ Peen²³²: ―Juø'n³ quie'²³ li²³'ne'² 'e³ rɨ²³jú̱n³na²³ quia̱'n²³²na¹ 'nʉ³, 'a²³jia'³ jmɨ́ɨ² rɨ²juøøn³¹na¹ dsa³ 'e³ 'a²³jia'³ cuiin²³na²³ 'nʉ³. 'E³ quie'²³ la'³ ca²³jua'³ la²³jɨn³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","'E³ quie'²³ ca²³dxóo² Jesús quia̱'² dsa³ quien³² je² xi̱i̱n³ Getsemaní. Ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―Ñí³ra'³ je² la³ la²³huøø'n³¹ la²³ 'e³ ñiin²³ je² núu²³ 'e³ rɨ²lʉn²³² quia̱'n²³²na¹ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ŋóo² quia̱'² 'nɨɨ'n³¹ Peen²³² quia̱'² te'²³ jo̱²³ñʉʉ'³¹ Zebedeo. 'E³ quie'²³ jo̱³ láa²³ ca²³ŋɨ́³ dsɨ́². Ca²³la²³ñúun³ dsɨ́². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ quia̱'²: ―Rɨ²³jú̱n³la²³cɨ²na¹ la²³'nɨɨ'n³¹ 'e³ ŋɨ́³ dsɨn²³. 'E³ jo̱³ rɨ²cuaa'n²³na'³ je² la³. 'E³ quie'²³ rɨ²mi³quii²³²ra'³ quia̱'n²na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ŋóo² cɨ² ca³juɨ² 'ñée². 'E³ quie'²³ jo̱³ ca²³quiaa³ rɨ³'in³². Ca²³lʉ́³ quia̱'² Dios. Ca²³jua'³: ―Ñu'n², 'a²³jia'³ 'náan²³ 'e³ rɨ²³jí̱i̱n²³ 'e³ la²³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jí̱i̱n²³ xi³nu³ rɨ²³lí³ juø'² la'³. 'E³ quie'²³ 'a²³ cu²lí³ 'e³ la²³ 'náan²³ 'ñáan²³. Cu²lí³ 'e³ la²³ 'naan³ 'uǿøn²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","'E³ quie'²³ jo̱³ ca²³dxe'n² co̱'³ je² nee'n²³² dsa³ quien³². Bi²³ rɨ³guɨɨn³te'²³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ Peen²³²: ―¿'A² 'a²³jia'³ ca³lǿ²³ juø'² ca³mi³quii²³²ra'³ quia̱'n²na'³ jné² cu³xi³ co̱o̱³ hora? ");
INSERT INTO cnlNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","'Ne'² rɨ²mi³quii²³²ra'³ xú̱n³. 'Ne'² rɨ²lʉ́²ra'³ quia̱'n²na'³ Dios 'e³ la²³ 'a²³jia'³ rɨ²³te'n²³na'³ 'e̱'³ lá³ je² juø'² rɨ²jmée²ra'³ 'e³ xa³ dsoo² quien³²na'³. Maan²³ 'e³ dxʉ́²³ 'óo²ra'³ 'e³ rɨ²jmée²ra'³ 'e³ dxʉ́²³ 'u². 'E³ quie'²³ 'a²³jia'³ 'uee'n³ jmɨ² ŋú²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","'E³ quie'²³ jo̱³ ŋóo² co̱'³ Jesús. I²lʉ́³ quia̱'² Dios. Ca²³jua'³: ―Ñu'n², xi³nu³ 'ne'² ca³quie̱e̱² 'e³ rɨ²³jí̱i̱n²³ 'e³ la²³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jí̱i̱n²³, cu²lí³ 'e³ la²³ 'naan³ 'uǿøn²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ca²³dxe'n² co̱'³ je² nee'n²³² dsa³ quien³². Bi²³ rɨ³guɨɨn³te'²³ co̱'³. Qui² sɨ³'mí²³ la²³ cɨ² mɨ²ñi²te'¹ la²³'nɨɨ'n³¹ 'e³ la²³guɨɨn³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","'E³ quie'²³ jo̱³ ca²³cuaa'n³ dsa³ quien³². Ŋóo² co̱'³. Je² ca²³tɨ́³ 'nɨ³ taa'², ca²³lʉ́³ quia̱'² Dios. 'E³ quie'²³ røø³ lǿ² júu² 'e³ ca²³lʉ́³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'E³ jo̱³ ca²³dxe'n² co̱'³ je² nee'n²³² dsa³ quien³². Ca²³jua'³: ―¿'A² rɨ³guɨɨn³quien²³na'³? ¿'A² tøø³²quie²³ra'³ 'óo²ra'³? 'E³ quie'²³ mɨ³tɨ́³ hora. Qui² mɨ³'nɨ́ɨn²³te'²³ jné² Jo̱o̱³¹ Dsa³ quie'² dsa³ 'i³ 'a²³jia'³ dxʉ́²³ jmoo³². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Naa'n²³na'³. Sɨ³gui²³²ra² jo̱o̱²³na²³. Qui² mɨ³ ja³'ɨ́ɨn²³ dsa³ 'i³ mɨ³'nɨ́ɨn²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lʉ²³ quie'²³ la'³ Jesús 'e³ la²³ ca²³dxóo² Judas, jø̱n³ dsa³ gui²³tʉ̱́n³. Ca²³dxóo² quia̱'² juɨ́ɨn²³ dsa³ 'i³ xe̱e̱'³ boo'³¹ quia̱'² 'mo³. Ca²³xíin²³ dsa³ 'í³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ mɨ³dxún²³ quien³² dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ca²³jua'³ dsa³ 'i³ ca²³'nɨ́ɨn²³ Jesús 'e³ jmii'³¹ rɨ²³jmée²³ lii²³ 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³sø̱'n²te'²³. Ca²³jua'³: ―Dsa³ 'i³ rɨ²cu'n²³² ñi² hua² 'í³. 'I³ 'í³ hua² 'i³ rɨ²jmø'n²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jo̱³ ca²³dxóo² caan²³ Jesús. Ca²³jua'³: ―¿'A² 'nʉ³ nɨ³, dsa³ 'e²³? 'E³ quie'²³ jo̱³ ca²³cuu'³ ñi² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―Amigo. ¿'Ee² lǿ² 'e³ mɨ³güén²³nu³? 'E³ quie'²³ jo̱³ ca²³guín²³ dsa³. Sø̱'n²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","'E³ quie'²³ sø'n² boo'³¹ jø̱n³ dsa³ 'i³ quia̱'² Jesús. Ca²³quiu'n² mozo quien³² juii² jmii³ dsa³. Ca²³quiʉ'² lo³guo². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","'E³ jo̱³ ca²³jua'³ 'ñée² Jesús: ―'Me² co̱'³ boo'³¹ quien³²nu³. Qui² boo'³¹ sɨ³jú̱n³ 'ñée² dsa³ 'i³ jmee²³ qui³ quia̱'² boo'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿'A² juø'² lǿn³nu³ 'e³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²ŋɨɨn²³² mɨ²'áa² quie'² Ñu'n²³? Juɨ́ɨn²³ ma²³'nee³ ángeles 'i³ rɨ²³xíin²³ quián²³ 'u² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","'A²³jia'³ rɨ²³lí³ 'e³ la²³ to̱o̱²³ ji³ júu² quiee'³² Dios 'e³ rɨ²³lí³ 'u² cu²ru'³ rɨ²jmeen²³² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","'E³ jo̱³ ca²³sɨ'²³ dsa³ 'i³ ca²³dxi²³guín²³: ―¿'A² juø'² lǿn³na'³ 'e³ dsa³ 'i̱i̱³ hua² jné²? Qui² 'e³ xe̱'²ra'³ boo'³¹, xe̱'²ra'³ 'mo³ 'e³ juo'³ra'³ rɨ²jmø'n¹na'³ jné². Cɨ'³ la²³ co̱o̱³ jmɨ́ɨ² ca²³ñín²³ ñʉ'²³ 'ñʉ́² gáan³ 'e³ 'een²³na²³ dsa³. 'A²³jia'³ ca²³xe̱'n²³na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","'E³ quie'²³ mɨ³lǿ²³ la²³jɨ³ 'e³ 'ne'² rɨ²³lí³ 'e³ la²³ lǿ² ca²³té̱e̱² ji³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². 'E³ quie'²³ jo̱³ ca²³tʉ́n² Jesús la²³jɨn³ dsa³ quien³². Ca²³cuɨ̱́ɨ̱²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ca²³guín²³ te'²³ dsa³ 'i³ so̱'² quie'² Jesús 'e³ i²jøn²³te'²³ quie'² Caifás 'i³ rɨ³løn³¹ juii² jmii³ dsa³. Je² núu²³ rɨ³ŋɨɨn³¹ te'²³ dsa³ 'e²³ ley quia̱'² te'²³ dsa³ mɨ³dxún²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","'E³ quie'²³ bi²³ huɨ̱́ɨ̱³ tu³cɨ̱ɨ̱n³ Peen²³² je² ŋóo² Jesús. Tu³cɨ̱ɨ̱n³ quie'²³ la'³ xi³'lɨ² ca²³dxóo² je² rɨ³jnɨ³ xi²dxi³² quie'² juii² jmii³ dsa³. 'Í² je² rɨ³jnɨ³. Ca²³gua³ quia̱'² dsa³ 'láa³ 'e³ jua'³ 'née²³ 'e³ rɨ²³jóo² 'e³ jmii'³¹ cu³lø³¹ júu² 'e³ rɨ²³'ien³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","'Naa'n³ dsa³ ñi³ 'i³ rɨ²³júu² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ mɨ³dxún²³ quia̱'² la²³jɨn³ dsa³ 'i³ dxa²³ ta². 'Naa'n³te'²³ dsa³ 'i³ rɨ²³júu² xi²ñi² dsa³ 'i³ dxa²³ ta² 'e³ jua'³ 'no'²te'²³ dsoo² quiee'³² Jesús 'e³ la²³ rɨ²³lí³ juø'² rɨ²³jŋɨ'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","'E³ quie'²³ 'a²³'i̱³ xen³ 'i³ ca²³cuǿ³ dsoo² 'e³ dxi³ji̱i̱n³¹ 'e³ rɨ²³jŋɨ'n²³te'²³, juø'n³ quie'²³ juɨ́ɨn²³ xen³ 'i³ ca²³júu² 'e³ la²³ ca²³lǿn²³te'²³ dsa³ ñi³. Je² dsøn³ ca²³la²³xen³ áan²³ cɨ² 'i³ ca²³lʉ́³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ca²³jua'³te'²³ ca²³'én²te'²³ Jesús: ―Ca²³jua'³ dsa³ la³: “Rɨ²³lí³ juø'² rɨ²yaan²³²na¹ 'ñʉ́² gáan³ je² mi³gáan³te'²³ Dios. Je² 'nɨ³ jmɨ́ɨ² rɨ²jmeen²³² co̱'³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ca²³naa'n²³ juii² jmii³ dsa³. Ca²³jua'³: ―¿'A² 'a²³'e³ xa³ rɨ²juø'n² 'uǿøn²nu³ 'e³ la²³ lǿ² dsoo² 'e³ cuø²³ quién²nu³ te'²³ dsa³ ñi³? ");
INSERT INTO cnlNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","'E³ quie'²³ 'a²³jia'³ ca²³'í̱n² Jesús. 'E³ jo̱³ ca²³jua'³ juii² jmii³ dsa³: ―Ñi³² Dios 'i³ rɨ³ji̱'²³ 'e³ rɨ²juøøn³¹na¹ 'nʉ³: Xii'² jnee'³¹ xi² 'í³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios 'nʉ³, xi² 'í³ Jo̱o̱³¹ Dios 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","'E³ jo̱³ ca²³jua'³ Jesús: ―La'³ cu³lø³¹ 'e³ la²³ mɨ³jue'n² 'uǿøn²nu³. 'E³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³: 'E³ cɨ² rɨ²mǿn¹na'³ jné² Jo̱o̱³¹ Dsa³ 'e³ la²³ jen³¹na¹ jaan²³ 'e³ dxʉ́²³ Dios 'i³ bi²³ 'uee'n³. 'E³ cɨ² rɨ²móo²ra'³ 'e³ la²³ aa'n³²na²³ co̱'³ jee²³² jníi². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","'E³ jo̱³ ca²³xíin² ca³juɨ² cuo̱o̱³ 'ñée² juii² jmii³ dsa³. Ca²³jua'³: ―Bi²³ 'ñe'² mɨ³lʉ́³ dsa³ la³. Jua'³ 'ñée² 'e³ jmee²³ 'e³ la²³ jmee²³ Dios. 'A²³jia'³ ma²³ 'ne'² cɨ² dsa³ ñi³, ¿mɨ³naa'³¹? Mɨ³nʉʉ³ra'³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'ñe'² mɨ³lʉ́³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jmii'³¹ lǿn³na'³ jo̱o̱²³na²³? 'E³ jo̱³ ca²³jua'³te'²³: ―Ya̱'n³ rɨ²³jú̱n³ dsa³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","'E³ quie'²³ jo̱³ ca²³'ø'²te'²³ ñi² Jesús. Ca²³cuǿ³te'²³ pe'³ quie'². Xen³ 'i³ ca²³jnóo² ñi² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ca²³jua'³te'²³: ―Juø'n³ 'nʉ³ 'e³ rɨ³løn³¹nu³ Cristo. Jmee² júu² jo̱o̱²³na²³ 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ mɨ³cuǿ³ quién²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jen³¹ Peen²³² xi²dxi³² je² rɨ³jnɨ³. 'E³ quie'²³ jo̱³ ca²³dxóo² jø̱n³ xii'³ mɨ́³ 'i³ rɨ³løn³¹ moza. Ca²³jua'³ ca²³sɨ'²³ Peen²³²: ―Mɨ³ŋɨ́n² quia̱'n²nu³ Jesús dsa³ Galilea 'nʉ³ co̱'³, ¿na'²? ");
INSERT INTO cnlNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","'E³ quie'²³ ca²³jua'³ Peen²³² je² nuu³ la²³jɨn³ dsa³: ―'A²³jia'³ jmɨ́ɨ² maan²³ 'ee² júu² lʉ́n². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ca²³bǿn³ Peen²³². Ŋóo² 'oo'² 'iá³ je² rɨ³jnɨ³. 'E³ jo̱³ xen³ jia'³ cɨ'²³ xii'³ mɨ́³ 'i³ rɨ³løn³¹ moza 'i³ ŋǿn² Peen²³². 'E³ jo̱³ ca²³sɨ'²³ dsa³ 'i³ té̱e̱n³ coo³¹: ―Mɨ³ŋɨ́³ dsa³ la³ quia̱'² Jesús dsa³ Nazaret, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Co̱'³ cɨ'²³ ca²³jua'³ Peen²³²: ―Ñi³² Dios 'e³ 'a²³jia'³ jmɨ́ɨ² cuiin²³na²³ dsa³ 'i³ 'ǿn²³na'³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Cɨ̱ɨ̱n³ cɨ² co̱'³ ca²³lǿn²³ mɨ³lén² dsa³ 'i³ té̱e̱n³ coo³¹. Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Peen²³²: ―Rɨ³løn³¹nu³ ca³quie̱e̱² jø̱n³ dsa³ 'í³ xú̱n³. Lii²³ 'e³ la²³ lʉ́n². Qui² lʉ́n² 'e³ la²³ lʉ²³ dsa³ Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","'E³ jo̱³ ca²³jua'³ 'ñée²: ―Cu²jmée³ jñiin²³na²³ Dios xi³nu³ te³ juun²³². 'A²³jia'³ jmɨ́ɨ² cuiin²³na²³ dsa³ 'i³ 'ǿn²³na'³ nɨ³. Xe̱'n² quie'²³ jo̱³ tǿ²³ 'nɨɨ'². ");
INSERT INTO cnlNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'E³ jo̱³ ca²³la²³líi²³ Peen²³² 'e³ la²³ lǿ² 'e³ cɨ² mɨ³jua'³ Jesús: “'E³ 'íi² rɨ²³tǿ² 'nɨɨ'², rɨ²juɨɨ'n³¹ dsa³ 'nɨ³ taa'² 'e³ 'a²³jia'³ cuiin²³nu³ jné²”. 'E³ quie'²³ jo̱³ ca²³bǿn³ Peen²³² je² núu²³. Bi²³ la³dsɨɨ³² ca²³'o'². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ma²ca¹la¹jné¹, ca²³ŋɨɨ'n²³ la²³jɨn³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ mɨ³dxún²³ quien³² dsa³ juɨɨ³. Ca²³mi²³'ien³te'²³ júu² 'e³ jmii'³¹ rɨ²³jŋɨ'n²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","'E³ quie'²³ jo̱³ ca²³'ñúun²³te'²³ Jesús. I²jøn²³te'²³ caan²³ dxi² juɨɨ³ 'i³ xi̱i̱n³ Poncio Pilato 'e³ ca²³cuaa'n³te'²³ guoo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ŋó²³ Judas, dsa³ 'i³ ca²³'nɨ́ɨn²³ Jesús, 'e³ ca²³'ien³ júu² 'e³ rɨ²³jŋɨ'n²³te'²³ Jesús. 'E³ jo̱³ bi²³ ca²³ŋɨ́³ dsɨ́² 'e³ la²³ lǿ² 'e³ ca²³jmée³. I²có̱o̱³ co̱'³ la²³jɨ³ gui²³guiá³ cuu² 'e³ rɨ³lø³¹ cu²taa³. 'Née²³ 'e³ rɨ²³jɨ̱'²³ co̱'³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ mɨ³dxún²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ca²³jua'³: ―Mɨ³jméen²³ 'e³ xa³ dsoo² quián²³. Qui² mɨ³'nɨ́ɨn²na²³ dsa³ 'i³ 'a²³'e³ dsoo² xa³ quie'². 'E³ jo̱³ ca²³jua'³te'²³: ―'A²³'e³ cua̱a̱n²tu² quiée²ra'³¹. 'Uǿøn²nu³ máan³ 'e³ jmii'³¹ rɨ²jméen². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tó̱o̱²³ cu²taa³ Judas ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. 'E³ quie'²³ jo̱³ ca²³bǿn³. Ŋóo². Ca²³noo³ je² jɨ̱ɨ̱n²³². Ca²³'ñʉ́ʉ³ 'ñii²³² lúu². Ca²³juén² 'ñée². 'E³ jo̱³ jú̱n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ca²³co̱o̱²³ co̱'³ cuu² juii² jmii³ dsa³. 'E³ quie'²³ ca²³jua'³te'²³: ―'A²³jia'³ joo'²³ 'e³ rɨ²te̱e̱'³¹ra² 'e̱'³ guóo² je² too'²³ dsa³ cuu² 'e³ cuøø²³te'²³ Dios. Qui² jñiin²³ dsa³ 'i³ mɨ³'nɨ́ɨn²³ uu'n² hua² nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","'E³ jo̱³ ca²³mi²³'ien³te'²³ júu² 'e³ jmii'³¹ rɨ²³jmóo²te'²³ cuu² jo̱³. 'E³ quie'²³ jo̱³ có̱²³te'²³ 'uǿ²³ je² xi̱i̱n³ 'uǿ²³ quiee'³² dsa³ 'i³ jmee²³ mɨ³¹'ia³. 'Uǿ²³ jo̱³ rɨ²³'áan²te'²³ te³ 'i̱i̱² dsa³ 'i³ xen³ jia'³ cɨ'²³ 'i³ rɨ²³jú̱n³ juɨɨ³ Jerusalén, jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","'E³ jo̱³ jua'³ dsa³ 'uǿ²³ jñii³¹ jmɨ²³'ǿn² dsa³, 'e²³te'²³ 'uǿ²³ jo̱³, xi³'lɨ² jmɨ́ɨ² rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","La'³ hua² ca²³lǿ²³ 'e³ la²³ ca²³jua'³ Jeremías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², 'e³ rɨ²³lí³. Ca²³jua'³ Jeremías: “Có̱²³te'²³ gui²³guiá³ cuu² 'e³ rɨ³lø³¹ cu²taa³. Qui² xen³ dsa³ Israel 'i³ ca²³jua'³ 'e³ la'³ 'nɨɨ'n³¹ rɨ²³quí²te'²³ quie'² dsa³ 'i³ rɨ²³'nɨ́ɨn²³ uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'E³ quie'²³ jo̱³ ca²³quí²te'²³ cuu² jo̱³ quie'² dsa³ 'i³ ca²³'nɨ́ɨ³ 'uǿ²³ je² xi̱i̱n³ 'uǿ²³ quiee'³² dsa³ 'i³ jmee²³ mɨ³¹'ia³. Qui² la'³ cu³lø³¹ ca²³dxi³ 'i'²³ quián²³ Dios Juii³ra².” La'³ cu³lø³¹ ca²³jua'³ Jeremías mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ca²³noo³ Jesús xi²ñi² dxi² juɨɨ³. 'E³ jo̱³ ca²³jua'³ dxi² juɨɨ³: ―¿'A² rey quien³² dsa³ Israel 'nʉ³? 'E³ jo̱³ ca²³jua'³ Jesús: ―La'³ cu³lø³¹ 'e³ la²³ mɨ³jue'n² 'uǿøn²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","'E³ quie'²³ 'a²³jia'³ ca²³'í̱n² Jesús ma²ca¹cuǿ³ dsoo² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ mɨ³dxún²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","'E³ jo̱³ ca²³jua'³ Pilato: ―¿'A² 'a²³jia'³ nuun³ 'e³ jmii'³¹ lǿ² la²³jɨ³ dsoo² 'e³ cuø²³te'²³ quién²nu³? ");
INSERT INTO cnlNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","'E³ quie'²³ 'a²³jia'³ ca²³'í̱n² Jesús, cu³xi³ co̱o̱³ jo̱o̱²³² júu². 'E³ jo̱³ bi²³ juø'²³ ca²³ti²³cø̱n³¹ dxi² juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Xa³ tɨ³² 'i'²³ quiee'³² Pilato 'e³ jmee²³ cɨ'³ la²³ co̱o̱³ ji̱i̱³ ñi³ 'e³ la²³ sɨ³tɨ́²³ mɨ²juee'³ pascua: To̱'²³ laan³² jø̱n³ dsa³ 'i³ 'iún² i²³ñí². Laan³² te³ 'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³dxi³ 'i'²³ dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mɨ²jo̱³ xen³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Barrabás 'i³ 'iún² i²³ñí². Bi²³ ca²³sóo²³ ca²³jó²³ júu² 'e³ jmii'³¹ cu³lø³¹ ca²³jmée³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ma²ca¹ŋɨɨ'n²³ dsa³, jo̱³ ca²³jua'³ Pilato: ―¿Jmii'³¹ 'noo³ra'³? ¿'I̱i̱² sɨɨ'³¹ rɨ²láan¹na²³ quién²na'³? ¿'A² rɨ²láan¹na²³ Barrabás? ¿'A² rɨ²láan¹na²³ Jesús 'i³ sɨ'²³te'²³ Cristo? ");
INSERT INTO cnlNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","La'³ ca²³jua'³ Pilato. Qui² ñi³² 'e³ hui²³dsɨ́ɨn²te'²³ ñin³²te'²³ Jesús 'e³ jua'³te'²³ bi²³ nuu³ dsa³ júu² quiee'³². 'E³ jo̱³ hua² 'e³ ca²³jɨ̱'n²te'²³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","'E³ la²³ jen³¹ Pilato sii³¹ je² dxa²³ ta², ca²³ŋɨ́n² júu² mɨ²³quie'². Ca²³jua'³: “'A²³ rɨ³caa'n²³nu³ dsa³ nɨ³. Qui² rɨ³løn³¹ ca³dsaan³². Bi²³ mɨ³cɨ́n²³ mɨ³'ñʉʉ². Bi²³ mɨ³cuǿø²³ jné² u²³ŋɨ́³ dsɨ́ɨ² 'e³ la²³ lǿ² mɨ³cɨ́n²³.” ");
INSERT INTO cnlNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","'E³ quie'²³ bi²³ ca²³too'n³ júu² dsa³ juɨɨ³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ mɨ³dxún²³. 'E³ jo̱³ ca²³la²³dxʉ́²³ dsɨ́² dsa³ juɨɨ³ 'e³ rɨ²³ŋɨ'²³te'²³ Pilato 'e³ rɨ²³láan² Barrabás, 'e³ rɨ²³jŋɨ'n²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Co̱'³ cɨ'²³ ca²³lʉ́³ dxi² juɨɨ³. Ca²³sɨ'²³ dsa³ juɨɨ³: ―Xen³ áan²³. ¿'I̱i̱² sɨɨ'³¹ rɨ²láan¹na²³ quién²na'³? 'E³ jo̱³ ca²³jua'³te'²³: ―Barrabás rɨ²láan¹nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","'E³ quie'²³ jo̱³ ca²³jua'³ Pilato: ―¿Jmii'³¹ rɨ²jme'n¹na²³ Jesús 'i³ sɨ'²³te'²³ Cristo? 'E³ jo̱³ ca²³jua'³ la²³jɨn³: ―¡Te̱e̱n²³² cruz! ");
INSERT INTO cnlNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","'E³ quie'²³ ca²³jua'³ Pilato: ―¿'Ee² lǿ²? ¿'Ee² dsoo² ca²³jmée³? 'E³ quie'²³ bi²³ cɨ² 'uaa'³ ca²³jua'³te'²³: ―¡Te̱e̱n²³² cruz! ");
INSERT INTO cnlNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ca²³la²³quii²³ Pilato 'e³ 'a²³jia'³ ma²³ xa³ cua̱a̱n²tu² 'e³ rɨ²³lʉ́²³ quia̱'² dsa³. Qui² sɨ³li³láa²³ 'e³ sɨ³lí³ sɨ³dxóo³ dsa³. 'E³ jo̱³ ca²³ŋɨ́ɨ³ jmɨɨ³. Ca²³u̱'² guoo³ je² joo³² la²³jɨn³ dsa³. Ca²³jua'³: ―'A²³jia'³ dsɨn³²na²³ 'e³ rɨ²³jú̱n³ dsa³ la³. Qui² rɨ³løn³¹ ca³dsaan³². Miin²³na'³ móo³ra'³ 'e³ jmii'³¹ rɨ²jmée²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","'E³ jo̱³ ca²³jua'³ la²³jɨn³ dsa³: ―¡Ma² dsɨn³² jnee'³¹ quia̱'n²na'³¹ jó̱o̱³ dxóo³ra'³¹! ");
INSERT INTO cnlNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","'E³ jo̱³ ca²³láan² quie'²³ Barrabás. Ca²³dxi³ 'i'²³ 'e³ rɨ²³jmín²te'²³ Jesús. Jo̱³ tu³ ca²³jɨ̱ɨ̱'n³ dsa³ 'i³ rɨ²³te̱e̱n³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","'E³ quie'²³ jo̱³ ca²³tøø³ Jesús dsa³ 'láa³ quien³² dxi² juɨɨ³. I²jøn²³te'²³ 'é̱² ta² quiee'³² dxi² juɨɨ³. Ca²³ñii'n³te'²³ caan²³ Jesús co̱o̱³ ta'n² dsa³ 'láa³ 'i³ bi²³ juɨ́ɨn²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","'E³ quie'²³ jo̱³ ca²³dxin³te'²³ cuo̱o̱³. Ca²³qui'n²te'²³ 'mɨɨ'³ 'e³ yʉ̱́ʉ̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ca²³jmóo²te'²³ co̱o̱³ jmíi² guoo³ tó̱o̱² 'e³ ca²³jmóo²te'²³ lɨɨ'² sɨɨ³. To̱'²te'²³ mɨ²dxi² Jesús. 'E³ quie'²³ jo̱³ ca²³cu²³xe̱'n²te'²³ co̱o̱³ sɨɨ². Ca²³jáa² ca²³ŋɨ́ɨn²te'²³. Ca²³xii'³ jñi²te'¹ xi²ñi² Jesús. Ca²³jua'³te'²³: ―¡Que viva rey quien³² dsa³ Israel! ");
INSERT INTO cnlNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","'E³ quie'²³ jo̱³ ca²³'ø'n²te'²³ Jesús. Ca²³co̱o̱²³te'²³ co̱'³ sɨɨ² 'e³ xe̱e̱'³ 'ñée². Ca²³jmí²te'²³ mɨ²dxi². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ma²ca¹líi¹ ca²³jáa² ca²³ŋɨ́ɨn²te'²³, ca²³dxin³te'²³ 'mɨɨ'³ 'e³ yʉ̱́ʉ̱³. Ca²³qui'n²te'²³ co̱'³ cuo̱o̱³ 'ñée². Ca²³jøn²³te'²³ je² rɨ²³te̱e̱n³te'²³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","'E³ la²³ ta'n²te'²³ jui³¹ sɨ³guín²³te'²³ 'ioo³¹ juɨɨ³, ca²³jí̱i̱n³te'²³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Muun³² 'i³ xen³ juɨɨ³ Cirene. Ca²³dxin³te'²³ 'i'²³ 'e³ rɨ²³có̱² cruz 'e³ rɨ²³te̱e̱n³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","'E³ quie'²³ jo̱³ ca²³dxi²³guín²³te'²³ je² xi̱i̱n³ Gólgota. Qui² la²³ lǿ² mee²³ cua'² mɨ²dxi² dsa³ lǿ² je² núu²³. La'³ cu³lø³¹ 'née²³ rɨ²³jua'³ Gólgota ju²³jmii²³² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ca²³ji̱i̱'n³te'²³ Jesús jmɨɨ'³¹ mɨ²jø'² vino 'e³ rɨ³coo'n³² 'e³ dxi'²³. Ca²³xʉ̱'³ ca³pii'² 'ñée². 'E³ jo̱³ 'a²³jia'³ ma²³ ca²³la²³'née²³ rɨ²³'ɨ̱'². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ma²mɨ³'áa³ 'i'²³ 'e³ mɨ³te̱e̱n³te'²³ cruz, ca²³to'²³te'²³ dxóo² 'mɨɨ'³ quiee'³². Xa³ mɨɨ³¹ 'e³ ca²³co'²te'²³ 'e³ la²³ rɨ²³'aa²³ 'i'²³ 'e³ 'i̱i̱² sɨɨ'³¹ li²³røøn³ 'e³ rɨ²³co̱o̱²³ cɨ'³ la²³ co̱o̱³ 'noo³¹. La'³ ca²³lǿ²³ 'e³ la²³ rɨ²³lí³ 'e³ la²³ ca²³jua'³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² 'e³ rɨ²³lí³. Ca²³jua'³: “Ca²³to'²³te'²³ dxóo² 'mɨɨ'³ quián²³. Xa³ mɨɨ³¹ 'e³ ca²³co'²te'²³ 'e³ la²³ rɨ²³'aa²³ 'i'²³ 'e³ 'i̱i̱² sɨɨ'³¹ li²³røøn³ 'e³ rɨ²³co̱o̱²³ cɨ'³ la²³ co̱o̱³ 'noo³¹.” ");
INSERT INTO cnlNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'E³ jo̱³ ca²³gua³te'²³. Ca²³'áan²te'²³ je² ta̱a̱n²³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Dsoo'²³ cruz coo'² mɨ²dxi² ca²³té̱e̱²te'²³ 'uø'² 'e³ jua'³te'²³ 'ee² dsoo² 'e³ jŋɨ'n²³te'²³. La²³la³ cu³lø³¹ 'uø'² 'e³ to̱o̱²³: “'I³ la³ Jesús 'i³ rɨ³løn³¹ rey quien³² dsa³ Israel”. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Xen³ áan²³ dsa³ 'i̱i̱³ 'i³ ca²³te̱e̱n³te'²³ cruz jaan²³ i²³la³ i²³nɨ³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bi²³ 'ñe'² ca²³lʉ́³ dsa³ 'i³ ca²³ŋɨ́n³ je² ta̱a̱n²³ cruz. Ca²³bí² mɨ²dxi²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―'Naan³ rɨ²yaan²³²nu³ 'ñʉ́² gáan³ je² mi³gáan³ dsa³ Dios. Juø'n³ 'e³ je² 'nɨ³ jmɨ́ɨ² rɨ²jméen² co̱'³. Rɨ²láan¹nu³ 'uǿøn²nu³. Xi³nu³ 'e̱'n³ quie'²³ dsɨ́² rɨ³løn³¹nu³ Jo̱o̱³¹ Dios, rɨ²jiaan³²nu³ je² ta̱a̱n²³nu³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","'E³ quie'²³ la'³ ca²³jáa² ca²³ŋɨ́ɨ² te'²³ juii² jmii³ dsa³ ca³ti³² quia̱'² te'²³ dsa³ 'e²³ ley quia̱'² te'²³ dsa³ mɨ³dxún²³. Ca²³jua'³te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ca²³láan² dsa³, jua'³. 'E³ quie'²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³láan² 'ñée². Rɨ³løn³¹ rey quien³² dsa³ Israel, jua'³. Cu²jiaan³² xe̱'n² rɨ³nɨ²³ je² ta̱a̱n²³ cruz. Jo̱³ rɨ²³sɨ²³táan³na² quia̱'n²na². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xa̱a̱'n³ dsɨ́² Dios, jua'³. Cu²láa¹ Dios quie'² xi³nu³ 'e̱'n³ quie'²³ bi²³ 'néen²te'²³. Qui² jua'³ 'ñée² 'e³ rɨ³løn³¹ Jo̱o̱³¹ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","'E³ quie'²³ la'³ cu³lø³¹ ca²³jáa² ca²³ŋɨ́ɨ² dsa³ 'i̱i̱³ 'i³ ta̱a̱n²³ cruz ca³ti³² quia̱'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dxaan²³ ñi'² ca²³lǿ²³ li³'o̱o̱³ mɨ³¹güii³. Lǿ² quie'²³ la'³ la²³huø'n²³ 'e³ ca²³tɨ́³ hora 'nɨ³ 'e³ mɨ³cu³'lóo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","La²³ca̱a̱n³ hora 'nɨ³ ca²³lʉ́³ quiʉ̱ʉ̱³ Jesús. Ca²³jua'³: ―Elí. Elí. ¿Lama sabactani? ―La'³ cu³lø³¹ ca²³jua'³ ju²³jmii²³² quiee'³²te'²³: Dios quién²³na²³. Dios quién²³na²³. ¿'Ee² lǿ² 'e³ mɨ³tʉ́n²nu³ jné²? ");
INSERT INTO cnlNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Xen³ dsa³ 'i³ té̱e̱n³ coo³¹ 'i³ ca²³núu³ 'e³ la²³ lǿ² ca²³lʉ́³ Jesús. 'E³ jo̱³ ca²³jua'³te'²³: ―Tøø³ Elías dsa³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'E³ quie'²³ jo̱³ ŋóo² xe̱'n² jø̱n³ dsa³ 'í³. I²quié̱³ joo³ 'e³ ca²³'a'²³ 'e̱'³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ ji̱i̱'³. Ca²³ti²³dxí² sɨɨ² joo³ jo̱³. Ca²³cuǿø²³ Jesús 'e³ rɨ²³'ɨ̱'². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","'E³ quie'²³ ca²³jua'³ uu'n²: ―Je̱²ru'³. Rɨ²ne²ra² xi² rɨ²³ja³ Elías 'e³ rɨ²³láan² dsa³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Co̱'³ cɨ'²³ ca²³lʉ́³ quiʉ̱ʉ̱³ Jesús. 'E³ quie'²³ jo̱³ ca²³dsá²³ dxí³ ta'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","'E³ quie'²³ jo̱³ ca²³xíin²³ 'mɨɨ'³ 'e³ ji̱i̱²³² ñʉ'²³ 'ñʉ́² gáan³. Ca²³lǿ²³ tú̱²³ juɨɨ²³². Yʉʉ'³¹ ca²³la²³láa²³ 'e³ ca²³xíin²³. Bi²³ ca²³bɨ́² 'uǿ²³. Ca²³'níi³ la²³ cɨ² cú̱u̱². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ca²³nó³ je² rɨ³'aan²³ 'lɨ́ɨ³. Juɨ́ɨn²³ dsa³ 'i³ rɨ³jɨ́n² quien³² Dios 'i³ rɨ³jú̱n² ca²³ji̱i̱'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma²mɨ³'áa³ 'i'²³ 'e³ ca²³ji̱i̱'²³ co̱'³ Jesús, ca²³'uǿøn² dsa³ 'i³ rɨ³jɨ́n² quien³² Dios je² rɨ³'aan²³. I²guín¹te'²³ juɨɨ³ Jerusalén je² bi²³ 'mɨ'n²³. Juɨ́ɨn²³ dsa³ 'i³ ŋó²³ 'e³ la²³ ca²³ŋɨ́³te'²³ jee²³² juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ŋó²³ juii² dsa³ 'láa³ quia̱'² dsa³ 'i³ quia̱'² 'i³ ca²³'áan² Jesús je² ta̱a̱n²³ cruz 'e³ jmii'³¹ 'nɨɨ'n³¹ ca²³bɨ́² 'uǿ²³. Ŋó²³te'²³ la²³jɨ³ 'e³ ca²³lǿ²³. 'E³ jo̱³ bi²³ juø'²³ ca²³ti²³cø̱n³¹te'¹. Ca²³jua'³te'²³: ―'E̱'n³ quie'²³ dsɨ́² 'e³ ca³quie̱e̱² Jo̱o̱³¹ Dios dsa³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Xen³ juɨ́ɨn²³ mɨ́³ 'i³ té̱e̱n³ huɨ̱́ɨ̱³ ca³juɨ². Ta'n² joo³². Jí̱i̱n² estado Galilea ca²³qui̱i̱³te'²³ Jesús 'e³ jua'³ ca²³mi²³quin³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Quia̱'²te'²³ I²³lee². Quia̱'²te'²³ Ma³rii³¹ xóo² Jacobo la²³ ca³já̱a̱n² quia̱'² Søø³². Quia̱'²te'²³ xóo² te'²³ jo̱²³ñʉʉ'³¹ Zebedeo. 'E³ quie'²³ xen³ cɨ² mɨ́³ 'i³ quia̱'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ma²mɨ³cu³'lóo³ jmɨ́ɨ² jo̱³, ca²³dxóo² jø̱n³ dsa³ xoo³² 'i³ xen³ juɨɨ³ Arimatea 'i³ xi̱i̱n³ Søø³². Rɨ³løn³¹ dsa³ quien³² Jesús 'ñée² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ŋóo² i²joon³ Pilato. Ca²³ŋɨ'n² 'lɨ́ɨ³ Jesús. 'E³ jo̱³ ca²³dxi³ 'i'²³ Pilato 'e³ rɨ²³jɨ̱ɨ̱'n³te'²³ 'lɨ́ɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ca²³tøø³ 'lɨ́ɨ³ Søø³² jo̱o̱²³na²³. Ca²³pee'n³ 'mɨɨ'³ sɨɨ³² 'e³ rɨ³jɨ́². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ca²³quiaan³ ñʉ'²³ too³ 'loo³ quiee'³² 'e³ ca²³yʉ́ʉ²te'²³ ñʉ'²³ 'loo³ mɨ³tu³la³ nɨ³. 'E³ quie'²³ jo̱³ ca²³lɨ'² co̱o̱³ cú̱u̱² bee'² 'e³ ca²³jní³ 'oo'² too³. 'E³ quie'²³ jo̱³ ŋø'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jen³¹ quie'²³ je² núu²³ I²³lee² quia̱'² jia'³ cɨ'²³ mɨ́³ 'i³ xi̱i̱n³ Ma³rii³¹. Nee'n²³²te'¹ tu³'o³ la²³ 'oo'² too³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","La²³ mɨ³dxóo³ la'³, 'e³ quie'²³ ma²ca¹ŋɨ́n³ jmɨ́ɨ² 'e³ mi³tɨ́ɨ²³ dsa³ Israel la²³jɨ³ 'e³ 'ne'² jmɨ́ɨ² je² tøø³ dsɨ́² dsa³, ca²³ŋɨɨ'n²³ caan²³ Pilato te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ fariseo. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ca²³jua'³te'²³: ―Líi²³ra'³¹ 'e³ jmii'³¹ 'nɨɨ'n³¹ juu³² dsa³ 'í³ ma²jen³¹ quie'²³ mɨ³¹güii³: “Je² 'nɨ³ jmɨ́ɨ² rɨ²³ji̱i̱'n²³na²³ co̱'³”. La'³ ca²³jua'³ mɨ²jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","'E³ jo̱³ rɨ²dxín² 'i'²³ 'e³ rɨ²³jmóo²te'²³ ji̱i̱³ 'e³ rɨ²³'áa²³te'²³ dxʉ́²³ too³ 'loo³ la²³huø'n²³ 'e³ rɨ²³tɨ́²³ 'nɨ³ jmɨ́ɨ². Qui² bi²³ juø'² rɨ²³sɨ²³guín²³ dsa³ quien³² 'uøø²³ 'e³ rɨ²³tøø³te'²³ 'lɨ́ɨ³. Jo̱³ rɨ²³jua'³te'²³ rɨ²³sɨ'²³te'²³ dsa³: “Mɨ³ji̱i̱'²³ co̱'³”. 'E³ jo̱³ bi²³ cɨ² bee'² u²³sɨ²³júu² rɨ²³lʉ́²³te'²³ je² dsøn³ la²³ cɨ'²³ 'e³ ca²³lʉ́³te'²³ xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","'E³ jo̱³ ca²³jua'³ Pilato: ―Xen³ dsa³ 'láa³ 'i³ rɨ²³'áa²³ quién²na'³. Cu³guín²³na'³ jo̱o̱²³na²³. Cu³'aa²ra'³ too³ 'loo³ la²³'nɨɨ'n³¹ 'e³ rɨ²³lí³ juø'². ");
INSERT INTO cnlNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","'E³ jo̱³ i²guín¹te'²³ ca²³jmóo²te'²³ ji̱i̱³ 'e³ rɨ²³'áa²³te'²³ dxʉ́²³ too³ 'loo³. Xa³ 'e³ ca²³dso'²te'²³ cú̱u̱² bee'² 'e³ la²³ li²³lii²³ xi² xen³ 'i³ rɨ²³né² 'oo'² too³. 'E³ quie'²³ ca²³sɨ'²³te'²³ dsa³ 'láa³ 'e³ rɨ²³'áa²³te'²³ dxʉ́²³ too³ 'loo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ca²³ŋɨ́n³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. 'A²³jia'³ ma²³ huǿø³ 'e³ li²³jné²³ jmɨ́ɨ² domingo, jo̱³ ŋóo² I²³lee² quia̱'² jia'³ cɨ'²³ mɨ́³ 'i³ xi̱i̱n³ Ma³rii³¹. I²guín¹te'²³ i²joo³te'²³ too³ 'loo³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Co̱'³ la²³ ca²³bɨ́² 'uǿ²³. Bi²³ 'uaa'³ ca²³bɨ́². Qui² jŋáan² jø̱n³ ángel quien³² Juii³ra² jí̱i̱n² yʉʉ'³¹ güii³. Ca²³dxóo² ángel. Ca²³lɨ'² cú̱u̱² bee'² 'e³ rɨ³jnɨ³ 'oo'² too³. 'E³ quie'²³ jo̱³ ca²³guó³ ñi'² cú̱u̱². ");
INSERT INTO cnlNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","La²³'nɨɨ'n³¹ 'e³ rɨ³ji'n³¹ i²³'ñeen³¹ 'e³ la²³ 'mii'²³, la'³ 'nɨɨ'n³¹ rɨ³ji'n³¹ ángel. La²³'nɨɨ'n³¹ taa³ je² rɨ³'lo³ dsɨ́² güi'³, la'³ 'nɨɨ'n³¹ taa³ cuo̱o̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bi²³ ca²³jleen²³ dsa³ 'láa³ la²³'nɨɨ'n³¹ 'ñaa'n²³te'²³ ángel. Rɨ³jú̱n²la²³cɨ²te'¹ ca²³ji̱'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","'E³ quie'²³ ca²³jua'³ ángel. Ca²³sɨ'²³ te'²³ mɨ́³: ―'A²³ rɨ³juø'n²³na'³ miin²³na'³. Qui² maan²³ 'e³ 'naa'n²³na'³ Jesús 'i³ ca²³te̱e̱n³te'²³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","'A²³'i̱³ ma²³ xen³ la³. Qui² mɨ³ji̱i̱'²³ co̱'³ 'e³ la²³ ca²³jua'³ 'ñée² mɨ²jo̱³ 'e³ rɨ²³lí³. Ñe³ra'³ 'e³ rɨ²joo³¹ra'³ je² ca²³quiaan³te'²³ 'lɨ́ɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jo̱³ tu³ cu³guiin³²na'³ ca²³la²³dxí² jee²³² juɨɨ³. Cu³xii'²ra'³ dsa³ quien³² 'e³ mɨ³ji̱i̱'²³ co̱'³. Jén²³ cɨ² la²³ 'nee'²³ dsoo³² co̱'³ estado Galilea. Je² núu²³ rɨ²³jí̱i̱n³na'³ 'ñée². La²³'nɨɨ'n³¹ nɨ³ hua² rɨ²juøøn³¹na¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ca²³la²³dxí² la²³ ca²³'uǿøn²te'²³ too³ 'loo³. Ca²³ta'n²³te'²³ jui³¹. Bi²³ juøø'n²³te'²³. 'E³ quie'²³ bi²³ jɨn³ dsɨ́²te'²³ co̱'³. I²guín¹te'²³ ca²³la²³dxí² 'e³ jua'³ sɨ³xii'²³²te'¹ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","'E³ la²³ ta'n²te'²³ jui³¹, co̱'³ la²³ ca²³ti²³cø̱n³¹te'¹ Jesús. Ca²³cuǿ³ u²³juee'n³¹ Jesús quia̱'² mɨ́³. Ca²³guín²³te'²³ caan²³. So̱'²³te'²³ tɨɨ². Ca²³mi²³gáan³te'²³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―'A²³ rɨ³juø'n²³na'³ miin²³na'³. Cu³xii'²ra'³ la²³jɨn³ ja̱a̱n³² 'e³ sɨ³guín²³te'²³ co̱'³ estado Galilea. Je² núu²³ rɨ²³ñín²te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ca²³ta'n²³ jui³¹ te'²³ mɨ́³ 'e³ sɨ³xii'²³² te'²³ dsa³ quien³² Jesús. Co̱'³ cɨ'²³ xen³ dsa³ 'láa³ 'i³ ca²³'áa³ too³ 'loo³ 'i³ i²guín¹ jee²³² juɨɨ³ Jerusalén. I²xii'²³²te'¹ juii² jmii³ dsa³ la²³jɨ³ 'e³ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","'E³ quie'²³ jo̱³ ca²³ŋɨɨ'n²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ mɨ³dxún²³. Ca²³mi²³'ien²³te'²³ júu² 'e³ rɨ²³cuǿø²³te'²³ ñúun³ cuu² dsa³ 'láa³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ca²³jua'³te'²³: ―La²³la³ cu³lø³¹ rɨ²juɨɨ'³¹ra'³ dsa³: “'Uøø²³ i²guín¹ dsa³ quien³². Ca²³tøø³te'²³ 'lɨ́ɨ³ je² rɨ³guɨɨn³na'³¹.” ");
INSERT INTO cnlNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","'E³ quie'²³ xi³nu³ rɨ²³núu²³ dxi² juɨɨ³ 'e³ mɨ³guɨɨn³na'³ je² mɨ³'áa²ra'³, rɨ²jmee²ra'³¹ jnee'³¹ 'e³ 'a²³'e³ xa³ rɨ²³jmée²³. Rɨ²jmee²ra'³¹ 'e³ 'a²³'e³ xa³ rɨ²³jí̱i̱n²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","'E³ jo̱³ có̱²³ cuu² dsa³ 'láa³. Ca²³jmóo² 'e³ la²³ ca²³sɨ'²³te'²³. 'E³ quie'²³ xi³'lɨ² jmɨ́ɨ² rɨ³nɨ²³ bi²³ rɨ³soo³ rɨ³jó³ júu² jo̱³ jee²³² quiee'³² dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","I²guín¹ estado Galilea dsa³ quien³² Jesús 'i³ gui²³quie̱e̱n³. I²guín¹te'²³ mo'³ je² ca²³jua'³ Jesús 'e³ sɨ³guín²³te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ma²ŋǿn¹te'²³ Jesús, 'e³ quie'²³ jo̱³ ca²³mi²³gáan³te'²³. 'E³ quie'²³ xen³ 'i³ 'a²³jia'³ sɨ³táan³ 'e³ 'e̱'n³ quie'²³ 'i³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","'E³ jo̱³ ca²³lǿn²³ mɨ³lén² Jesús. Ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―Mɨ³'iaan³² júu² 'uee'n³ 'e³ røøn²³na²³ la²³ca̱a̱n³ yʉʉ'³¹ güii³ quia̱'² mɨ³¹güii³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","'E³ jo̱³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ cu³guín²³na'³ la²³ca̱a̱n³ mɨ³¹güii³ jo̱o̱²³na²³. Rɨ²jmée²ra'³ 'e³ rɨ²³lín³ dsa³ quién²³na²³ dsa³ 'i³ xen³ la²³ca̱a̱n³ mɨ³¹güii³. Rɨ²xáan¹na'³ jmɨɨ³ dsa³ 'í³ 'e³ jua'³te'²³ mɨ³lǿn²³te'²³ dsa³ quien³² Dios Jmii³, dsa³ quien³² Dios Jo̱o̱³¹, dsa³ quien³² Espíritu Gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Rɨ²'ee³¹ra'³ dsa³ 'í³ 'e³ la²³ rɨ²³jmóo² la²³jɨ³ 'e³ ca²³dxin²³ 'i'²³ quién²na'³. 'Ne'² li²³liin³²quien²³na'³ 'e³ tén³ la²³ quia̱'n²³²na¹ 'nee'²³. Quia̱'n²³²na¹ 'nee'²³ la²³huø'n²³ 'e³ rɨ²³tɨ́²³ 'e³ rɨ²³dxá³ jmɨ́ɨ². Nɨ³ mɨ³líi².");
INSERT INTO cnlNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","La²³la³ cu³lø³¹ ca²³la²³láa²³ júu² dxʉ́²³ 'e³ la²³ lǿ² ca²³jmée³ Jesucristo 'i³ rɨ³løn³¹ Jo̱o̱³¹ Dios: ");
INSERT INTO cnlNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ca²³la²³láa²³ ma²ca¹lǿ¹ 'e³ la²³ ca²³jua'³ Isaías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², 'e³ rɨ²³lí³. Qui² ca²³té̱e̱² ji³ Isaías 'e³ la²³ lǿ² ca²³lʉ́³ Dios, ca²³sɨ'²³ Jo̱o̱³¹: Rɨ²sɨɨn³¹na¹ dsa³ xiin²³ quién²³na²³ 'i³ rɨ²³ŋɨ́n³ jén²³ cɨ² la²³ 'nʉ³. Rɨ²³jmée²³ dxʉ́²³ jui³¹ je² rɨ²³ŋɨ́n³nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Xen³ 'i³ 'iún² tø³² je² 'a²³jia'³ nee'n²³² dsa³. Jua'³: “Rɨ²jmée²ra'³ dxʉ́²³ jui³¹ je² rɨ²³ŋɨ́n³ Juii³ra². Rɨ²jmée²ra'³ jui³¹ 'e³ ca³dsaan³² je² rɨ²³ŋɨ́n³.” La'³ cu³lø³¹ ca²³jua'³ Isaías mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","'E³ jo̱³ jen³¹ je² 'a²³jia'³ nee'n²³² dsa³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Juan. Xaan³² dsa³ jmɨɨ³. 'Ɨɨ³ júu², sɨ'²³ dsa³ 'e³ 'ne'² rɨ²³tʉ́²te'²³ 'e³ jmoo³²te'²³ 'e³ 'a²³jia'³ dxʉ́²³ 'e³ la²³ rɨ²³yʉʉ³ dsoo² quiee'³²te'²³. 'E³ quie'²³ 'ne'² rɨ²³sáan²³te'²³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","'E³ quie'²³ jo̱³ i²guín¹ je² jen³¹ Juan la²³jɨn³ dsa³ 'i³ nee'n²³² estado Judea. 'E³ quie'²³ la'³ dsa³ juɨɨ³ Jerusalén co̱'³. Ca²³xáan² jmɨɨ³ dsa³ 'í³ Juan. Ca²³jŋáan³te'²³ jmɨɨ³ 'e̱'³ jmɨɨ³ juee'³ Jordán. Ca²³jmóo² júu² miin²³ 'e³ jmii'³¹ cu³lø³¹ dsoo² 'e³ xa³ quie'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Quii'³ Juan 'mɨɨ'³ 'e³ rɨ³lø³¹ jñʉ³ jó̱² camello. Rɨ³'ñu'n² loo³. Cu'n³ quii². 'Ɨ̱ɨ̱'³² jmɨɨ'³¹ quiee'³² to'² 'i³ xen³ je² nuu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","'Ɨɨ³ júu². Jua'³. Sɨ'²³ dsa³: ―Xen³ 'i³ ja³'ɨ́ɨn²³ cɨ̱ɨ̱n³ cɨ² la²³ jné². Bi²³ cɨ² 'uee'n³ júu² quiee'³² 'ñée² la²³ cɨ'²³ jné². 'A²³jia'³ li²³bii²³ dsɨn²³ 'e³ rɨ²ñin²³² rɨ³jiuu'n²³na²³ 'e³ rɨ²'uøøn²³² loo³ 'e³ taa'² tɨɨ² 'ñée² la²³'nɨɨ'n³¹ 'e³ 'uee'n³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jmɨɨ³ hua² ca'n³² jné² 'e³ la²³ xaan²³na²³ jmɨɨ³ 'nee'²³. 'E³ quie'²³ rɨ²³jmée²³ 'ñée² 'e³ rɨ²cø̱n²³na'³ Espíritu Gáan³. La'³ cu³lø³¹ 'e³ rɨ²³xáan² jmɨɨ³ 'nee'²³. ―La'³ cu³lø³¹ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","La²³ca̱a̱n³ mɨ²jo̱³ ca²³dxóo² Jesús je² jen³¹ Juan naan³ juɨɨ³ Nazaret estado Galilea. Ca²³jŋáan³ jmɨɨ³ 'e̱'³ jmɨɨ³ juee'³ Jordán. Juan ca²³xóo² jmɨɨ³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Xe̱'n² 'e³ la²³ ca²³bǿn³ Jesús 'e̱'³ jmɨɨ³, ŋó²³ 'e³ ca²³nó³ yʉʉ'³¹ güii³. Ŋó²³ 'e³ sɨ³jiaan³² Espíritu Gáan³ ñi'² quiee'³² 'ñée². La²³ lǿn²³ to̱³ju̱³¹ lǿn²³ Espíritu Gáan³ 'e³ la²³ sɨ³jiaan³². ");
INSERT INTO cnlNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","'E³ quie'²³ jo̱³ xen³ 'i³ ca²³lʉ́³ yʉʉ'³¹ güii³. Ca²³jua'³: ―Rɨ³løn³¹nu³ ja̱a̱n²³ 'i³ bi²³ 'náan²³na²³. Jmeen³ 'nʉ³ 'e³ bi²³ jɨn³ dsɨn²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Xe̱'n² quie'²³ jo̱³ ca²³jmée³ Espíritu Gáan³ 'e³ ŋóo² Jesús je² 'a²³jia'³ nee'n²³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tú̱²³ lóo² jmɨ́ɨ² i²gua³ núu²³. 'E³ quie'²³ núu²³ ca²³jmée³ lá³ Satanás 'e³ jua'³ 'née²³ 'e³ rɨ²³jáan²³ Jesús. Jen³¹ Jesús quia̱'² u²³núu² 'i³ xen³ je² nuu³. Te'²³ ángeles ca²³mi²³quin³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ca²³ta̱a̱'n³te'²³ i²³ñí² Juan. 'E³ quie'²³ mɨ²jo̱³ ca²³dxe'n² Jesús estado Galilea. Núu²³ ca²³'ɨ́ɨ³ júu² dxʉ́²³ 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ca²³jua'³: ―Rɨ³nɨ²³ mɨ³tɨ́³ jmɨ́ɨ². Mɨ³lǿ²³ mɨ³lén² 'e³ rɨ²³lín³ Dios juii² dsa³. 'E³ jo̱³ 'ne'² rɨ²tu³¹ra'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ dxʉ́²³. 'Ne'² rɨ²³sɨ²³táan³na'³ júu² dxʉ́²³ quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ca²³ŋɨ́³ Jesús co̱³² jmɨ²³ñii'³¹ Galilea. Ca²³tɨ́³ 'e³ ŋǿn² Muun³² ca³ti³² quia̱'² Drøø³¹ la²³ ca³já̱a̱n². Jua³²te'²³ 'mó² 'e̱'³ jmɨ²³ñii'³¹. Qui² rɨ³løn³¹te'¹ dsa³ 'i³ cø̱n³² 'moo'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Ñe³ra'³ quia̱'n²na'³ jné². Qui² rɨ²cuǿøn¹na²³ 'nee'²³ jia'³ cɨ'²³ 'iin³² ta². Ta² 'e³ rɨ²tøø³¹ra'³ dsa³ rɨ²cuǿøn¹na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Xe̱'n² jmɨ́ɨ² ca²³cuaa'n³te'²³ 'mó² quiee'³²te'²³. Ca²³guín²³te'²³ quia̱'²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ŋóo² cɨ² ca³juɨ² Jesús. 'E³ quie'²³ jo̱³ ŋǿn² Jacobo jo̱²³ñʉʉ'³¹ Zebedeo quia̱'² jó̱o̱² 'i³ xi̱i̱n³ Juan. Ta'n²te'²³ 'e̱'³ móo². 'Mii³te'²³ 'mó² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Xe̱'n² jmɨ́ɨ² ca²³tøø³ dsa³ 'í³ Jesús. 'E³ jo̱³ ca²³cuaa'n³te'²³ jmii³te'²³. Ca²³cuaa'n³te'²³ 'e̱'³ móo² quia̱'² mozoss quien³². Ca²³guín²³ miin²³ quia̱'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","'E³ quie'²³ jo̱³ ca²³ta'n²³te'²³ juɨɨ³ Capernaum. Ma²ca¹tɨ́³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³, 'í² Jesús ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Ca²³'ée²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bi²³ juø'²³ ca²³núu³te'²³ júu² 'e³ ca²³'é³. Qui² ca²³'é³ 'e³ la²³ 'e²³ jø̱n³ dsa³ 'i³ 'uee'n³ júu² quiee'³². 'A²³la³ 'e³ la²³ 'e²³ dsa³ 'e²³ ley 'e³ ca²³'é³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","'Iún² 'ñʉ́² quiee'³²te'²³ jø̱n³ dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². Ca²³lʉ́³ quiʉ̱ʉ̱³ dsa³ 'í³. Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿'Ee² lǿ² ta̱a̱'n²³nu³ 'uǿøn²nu³ quia̱'n²nu³ jnee'³¹, Jesús dsa³ Nazaret? ¿'A² mɨ³güen²³nu³ la³ 'e³ juø'n³ 'naan³ rɨ²jŋɨ'n²³nu³ jnee'³¹? Cuiin²³na²³ 'nʉ³. 'E³ quie'²³ maan²³ 'e³ rɨ³løn³¹nu³ dsa³ 'i³ rɨ³jɨ́n² quien³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","'E³ quie'²³ ca²³jín² espíritu 'í³ Jesús. Ca²³jua'³: ―Tu³cɨ² 'nʉ³. Cu³bøøn²³nu³ dsa³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ca²³jmée³ espíritu quien³² mɨ²³sɨ²³quiʉ'² 'e³ ca²³juín² dsa³ 'í³. Bi²³ quiʉ̱ʉ̱³ ca²³yo'³. 'E³ quie'²³ jo̱³ ca²³bǿøn²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bi²³ juø'²³ ca²³ti²³cø̱n³¹ dsa³. 'E³ jo̱³ ca²³lʉ́³ la²³ co̱³quie'² miin²³. Ca²³jua'³te'²³: ―¿'Ee² hua² 'noo³¹ nɨ³ cu²ne²ra²? Júu² 'mɨɨn³² mi'³ 'e²³ dsa³ nɨ³. Bi²³ 'uee'n³ júu² quiee'³² 'e³ la²³ jin³² espíritus quien³² mɨ²³sɨ²³quiʉ'². 'E³ quie'²³ jmoo³² quie'²te'²³ 'e³ la²³ dxi³ 'i'²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bi²³ xe̱'n² ca²³sóo²³ ca²³jó²³ júu² la²³ca̱a̱n³ estado Galilea 'e³ la²³ lǿ² 'e³ ca²³jmée³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","'E³ quie'²³ jo̱³ ca²³'uǿøn²te'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. 'Í² Jesús xi²ñʉ'¹ quiee'³² Muun³² quia̱'² Drøø³¹. 'Í² quia̱'² Jacobo quia̱'² Juan. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Rɨ³caa'n³² xóo² mɨ²³quie'² Muun³². Jmee²³ dsóo² dxíi³ quie'². Xe̱'n² ca²³sɨ'²³te'²³ Jesús 'e³ dsoo'²³² mɨ́³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","'E³ jo̱³ ca²³dxóo² Jesús caan²³ mɨ́³ 'í³. 'Ɨ́ɨn² guoo³ mɨ́³. Ca²³xa'n². Xe̱'n² quie'²³ jo̱³ ca²³je̱'n²³ dsóo² dxíi³ 'e³ lǿn²³ mɨ́³ 'í³. 'E³ quie'²³ jo̱³ ca²³jí̱² ca²³tí³ ca²³mi²³quin³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma²ca¹nʉʉ³ jmɨ́ɨ² jo̱³, i²jøn²³te'²³ caan²³ Jesús la²³jɨn³ dsa³ 'i³ dsoo'²³² quia̱'² la²³jɨn³ dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","'E³ quie'²³ ca²³cø̱'n²³ la²³ cɨ² dsa³ juɨɨ³ 'oo'² 'ñʉ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Juɨ́ɨn²³ dsa³ 'i³ dsoo'²³², te³ jmii'³¹ quie'²³ lǿ² dsóo² 'e³ lǿn²³, 'i³ ca²³mi²³'láan³ Jesús. Juɨ́ɨn²³ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'i³ ca²³'uøøn³. 'E³ quie'²³ 'a²³jia'³ ca²³cuǿ³ júu² 'e³ rɨ²³lʉ́²³te'²³. Qui² cuiin²³te'²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","La²³ mɨ³dxóo³ la'³, 'e³ quie'²³ jmee²³ cɨ² bíi²³ 'e³ li²³jné²³, ca²³naa'n²³ Jesús. Ŋóo² je² 'a²³'i̱³ xen³ dsa³. Núu²³ ca²³lʉ́³ quia̱'² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","'E³ quie'²³ ŋóo² Peen²³² quia̱'² uu'n² 'e³ jua'³ rɨ²³'naa'n³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma²ca¹dsø'n¹te'²³, ca²³jua'³te'²³: ―'Naa'n³ 'nʉ³ la²³jɨn³ dsa³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","'E³ jo̱³ ca²³jua'³ Jesús: ―Mɨ²³gui²³²ra² jia'³ cɨ'²³ juɨɨ³ je² mɨ³lén². Qui² 'náan²³ 'e³ rɨ²'ɨɨn²³² júu² je² núu²³ co̱'³. 'E³ jo̱³ hua² 'e³ güén²³na²³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","'E³ jo̱³ ca²³ŋɨ́³ la²³ca̱a̱n³ estado Galilea. Ca²³'ɨ́ɨ³ júu² ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Ca²³'uøøn³ espíritus quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ca²³dxóo² caan²³ Jesús jø̱n³ dsa³ 'i³ ta̱a̱n²³ goo³. Ca²³ŋɨ́ɨ³ mɨ²'áa² quie'². Ca²³xii'³ jñi². Ca²³jua'³: ―Rɨ²³lí³ juø'² rɨ²jméen² 'e³ rɨ²³jñíin³ la³'en²³ xi³nu³ 'naan³ rɨ²jméen² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bi²³ ca²³la²³cuu'²³ dsɨ́² Jesús. Ca²³'ɨ́ɨ³ guoo³. Ca²³quiu̱u̱'n³ dsa³ 'í³. Ca²³jua'³: ―'Náan²³ xú̱n³. Cu²jñíin³ la³'én². ");
INSERT INTO cnlNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Xe̱'n² quie'²³ jmɨ́ɨ² jo̱³ ca²³je̱'n²³ goo³. Ca²³jŋɨn³ la³'e² dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","'E³ jo̱³ ca²³sɨ'²³ dsa³ 'í³ 'e³ rɨ²³dsø'n². 'E³ quie'²³ ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Sú̱n² quie'²³ 'a²³ rɨ³juɨɨ'n³² dsa³ 'e³ la²³ mɨ³lǿ²³. Guo³ cu³'én² 'uǿøn²nu³ 'nɨɨ'n³¹ jmii³ dsa³. Rɨ²cuøøn³¹nu³ Dios la²³jɨn³ 'i³ cuøn³² dsa³ 'i³ mɨ³jŋɨn³ la³'e² 'e³ juø'n³ rɨ²jméen² lii²³ 'e³ mɨ³jŋɨn³ la³'én². Qui² la'³ cu³lø³¹ ca²³dxi³ 'i'²³ Moisés. Jo̱³ hua² rɨ²³dsóo²³ dsɨ́² dsa³ 'e³ mɨ³jŋɨn³ la³'én². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","'E³ quie'²³ ŋóo² dsa³ 'í³. Ca²³sɨ'²³ dsa³ la²³ca̱a̱n³ je² ca²³ŋɨ́n³ 'e³ la²³ lǿ² 'e³ ca²³jmée³ Jesús. Bi²³ ca²³sóo²³ ca²³jó²³ júu². 'E³ jo̱³ 'a²³jia'³ ma²³ ca²³lǿ²³ juø'² 'í² Jesús jee²³² juɨɨ³ i²³ñín² la²³nɨ³. Ca²³ŋɨ́³ je² 'a²³'i̱³ xen³ dsa³. 'E³ quie'²³ ca²³'uǿøn² dsa³ la²³ca̱a̱n³. I²guín¹ je² jen³¹ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma²ca¹la¹ñúun³ jmɨ́ɨ² 'e³ ŋɨ́³ Jesús je² 'a²³'i̱³ xen³ dsa³, ca²³dxe'n² co̱'³ juɨɨ³ Capernaum. 'E³ quie'²³ ca²³núu³ dsa³ 'e³ jen³¹ co̱'³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'E³ jo̱³ bi²³ juɨ́ɨn²³ dsa³ 'i³ ca²³ŋɨɨ'n²³. Cu³xi³ 'a²³jia'³ ma²³ joo'²³ je² rɨ²³noo³ dsa³. 'A²³ cɨ'²³ xi²dxi³² la²³cu'² 'oo'² 'ñʉ³¹ 'a²³jia'³ ma²³ joo'²³. 'Ɨɨ³ júu² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","'E³ quie'²³ ca²³dxi²³guín²³ quiú̱n³ dsa³ 'i³ quie̱n³ uu'n² 'i³ tu̱u̱n²³². 'Née²³te'²³ 'e³ rɨ²³sɨ²³jøn²³te'²³ caan²³ Jesús 'u². ");
INSERT INTO cnlNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","'E³ quie'²³ 'a²³jia'³ lǿ²³ juø'² ca²³tɨ́n³te'²³ caan²³ la²³'nɨɨ'n³¹ juɨɨ'n³¹ dsa³ 'i³ té̱e̱n³ caan²³. 'E³ jo̱³ ca²³né²te'²³ yʉʉ'³¹ 'ñʉ́² coo'² dxi² Jesús. Ca²³jióo²te'²³ jmoo³ 'e³ 'iún² dsa³ 'i³ tu̱u̱n²³². ");
INSERT INTO cnlNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ca²³la²³quii²³ Jesús 'e³ jmii'³¹ 'nɨɨ'n³¹ sɨ³táan³te'²³ quia̱'²te'²³ 'ñée². 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ tu̱u̱n²³²: ―Ja̱a̱n²³ quién²³na²³, mɨ³uu³ dsoo² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","'E³ quie'²³ xen³ dsa³ 'e²³ ley 'i³ nee'n²³² je² núu²³. Xín³ 'ín³te'²³. Lǿn³te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿'Ee² lǿ² lʉ²³ la'³ dsa³ nɨ³ cu²ne²ra²? Bi²³ 'ñe'² lʉ²³. Jua'³ 'ñée² 'e³ jmee²³ 'e³ la²³ jmee²³ Dios. Jø̱n³ Dios hua² 'i³ sɨ³lí³ juø'² yuun³² dsoo² quiee'³² dsa³.” ");
INSERT INTO cnlNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Xe̱'n² jmɨ́ɨ² ca²³la²³quii²³ Jesús 'e³ la'³ cu³lø³¹ xín³ 'ín³te'²³. 'E³ jo̱³ ca²³jua'³: ―¿'Ee² lǿ² xín³ 'ín³na'³ la'³? ");
INSERT INTO cnlNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jmii'³¹ cu³lø³¹ 'e³ tu³sɨ'²³ cɨ², lǿn³na'³? ¿'A² tu³sɨ'²³ cɨ² 'e³ rɨ²juøøn³¹na¹ dsa³ 'i³ tu̱u̱n²³²: “Mɨ³uu³ dsoo² quien³²nu³”? ¿'A² tu³sɨ'²³ cɨ² 'e³ rɨ²juøøn³¹na¹: “Naa'n²³ 'nʉ³. Ben²³² jmoo³ quien³²nu³. Ŋɨ² jo̱o̱²³na²³”? ");
INSERT INTO cnlNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","'E³ quie'²³ 'náan²³ 'e³ rɨ²móo²ra'³ 'e³ mɨ³¹güii³ la³ xa³ ca³dsaan³² quián²³ jné² Jo̱o̱³¹ Dsa³ 'e³ yuun²³²na¹ dsoo² quiee'³² dsa³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ tu̱u̱n²³²: ");
INSERT INTO cnlNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Rɨ²juøøn³¹na¹ 'nʉ³: Naa'n²³ 'nʉ³. Ben²³² jmoo³ quien³²nu³. Guø'n³ quién²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Xe̱'n² quie'²³ jo̱³ ca²³naa'n²³ dsa³ 'i³ tu̱u̱n²³². Ca²³bén² jmoo³. 'E³ quie'²³ jo̱³ ca²³bǿn³ je² joo³² la²³jɨn³ dsa³. Bi²³ juø'²³ ca²³jóo² dsa³. Ca²³mi²³gáan³te'²³ Dios. Ca²³jua'³te'²³: ―'A²³jia'³ lɨ'³ ca³ne²ra² 'e³ lø³² la²³nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ŋóo² co̱'³ Jesús co̱³² jmɨ²³ñii'³¹. 'E³ quie'²³ ca²³ŋɨɨ'n²³ co̱'³ juɨ́ɨn²³ dsa³ caan²³ Jesús. 'E³ jo̱³ ca²³'ée²³ dsa³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","'E³ la²³ 'í² jui³¹ co̱'³, ca²³jí̱i̱n³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Leví jo̱²³ñʉʉ'³¹ Alfeo. Jen³¹ 'e³ rɨ³løn³¹ 'io'² 'e³ co̱³² cuu². 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Leví: ―Ñe³ quia̱'n²nu³ jné². 'E³ jo̱³ ca²³naa'n²³ Leví. Ŋóo² quia̱'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","'E³ la²³ jen³¹ Jesús coo³¹ mesa xi²ñʉ'¹ quiee'³² Leví, xen³ juɨ́ɨn²³ 'io'² quia̱'² dsa³ tu³cua̱a̱n²tu² 'i³ nee'n²³² quia̱'² Jesús quia̱'² dsa³ quien³². Qui² juɨ́ɨn²³ dsa³ 'i³ lǿn²³ la'³ 'i³ ca²³qui̱'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ŋó²³ dsa³ 'e²³ ley quia̱'² dsa³ fariseo 'e³ ee'³² Jesús quia̱'² 'io'² quia̱'² dsa³ tu³cua̱a̱n²tu². 'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ dsa³ quien³²: ―¿'Ee² lǿ² 'ɨ̱ɨ̱'³² ee'³² 'ñée² quia̱'² 'io'² quia̱'² dsa³ tu³cua̱a̱n²tu²? ");
INSERT INTO cnlNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ca²³núu³ Jesús 'e³ la²³ lǿ² ca²³lʉ́³te'²³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ―'A²³'e³ xa³ je² 'ne'² tɨ³² 'oo³ quie'² te'²³ dsa³ 'i³ 'a²³jia'³ dsoo'²³². 'E³ quie'²³ dsa³ 'i³ dsoo'²³² hua² 'i³ 'ne'² tɨ³² 'oo³ quie'². 'A²³la³ dsa³ 'i³ lǿn³ miin²³ 'e³ jmoo³² ca³dsaan³² 'i³ rɨ²tøøn³¹na¹ 'e³ güén²³na²³. 'E³ quie'²³ güén²³na²³ 'e³ rɨ²tøøn³¹na¹ dsa³ 'i³ mɨ³la³quii²³ 'e³ bi²³ xa³ dsoo² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ca²³tɨ́³ 'e³ jmoo³² mɨ²³jmɨɨ²³ dsa³ quien³² Juan. 'E³ quie'²³ la'³ dsa³ quien³² dsa³ fariseo co̱'³. 'E³ jo̱³ i²guín¹ dsa³ i²xii'²³² Jesús: ―Jmoo³² mɨ²³jmɨɨ²³ dsa³ quien³² Juan, ¿mɨ³naa'³¹? 'E³ quie'²³ la'³ dsa³ quien³² dsa³ fariseo co̱'³. ¿Jmii'³¹ lǿ² 'e³ 'a²³jia'³ jmoo³² mɨ²³jmɨɨ²³ dsa³ quien³²nu³? ");
INSERT INTO cnlNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'A²³jia'³ jmoo³² mɨ²³jmɨɨ²³ dsa³ 'i³ nee'n²³² mɨ²juee'³ je² mɨ³tøø³² dsa³ mɨ́³ xi³nu³ jen³¹ quie'²³ mɨ²juee'³ dsa³ 'i³ mɨ³tøø³² mɨ́³, ¿mɨ³naa'³¹? Xi³nu³ jen³¹ quie'²³ dsa³ 'i³ mɨ³tøø³² mɨ́³, 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³jmóo²te'²³ mɨ²³jmɨɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","'E³ quie'²³ 'e³ cɨ² rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ 'a²³jia'³ ma²³ quia̱'²te'²³ dsa³ 'i³ mɨ³tøø³² mɨ́³. Jmɨ́ɨ² jo̱³ hua² 'e³ rɨ²³jmóo²te'²³ mɨ²³jmɨɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’'A²³jia'³ rɨ²³ti²³guo² xi³nu³ rɨ²³te̱e̱³ dsa³ 'mɨɨ'³ 'e³ 'a²³jia'³ ca²³jo'² je² rɨ³gɨ́ɨ² cuo̱o̱³ 'e³ jaa²³². Qui² rɨ²³jo'² 'mɨɨ'³ 'e³ mɨ³te̱e̱³. 'E³ jo̱² rɨ²³je̱'n²³ 'mɨɨ'³ 'mɨɨn³² je² mɨ³te̱e̱³ cuo̱o̱³ 'e³ jaa²³². Jo̱³ bi²³ cɨ² rɨ²³guii³ cuo̱o̱³ 'e³ jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","'E³ quie'²³ la'³ cu³lø³¹ quie'² jmɨɨ'³¹ mɨ²jø'² vino co̱'³. 'A²³jia'³ rɨ²³ti²³guo² xi³nu³ rɨ²³xi'²³ dsa³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'mɨɨn³² 'e̱'³ tuu'³ loo³ 'e³ jaa²³². Qui² rɨ²³juii³ jmɨɨ'³¹ mɨ²jø'² vino. 'E³ jo̱³ rɨ²³mo'² tuu'³ loo³ 'e³ jaa²³². Rɨ²³gua'²³ jmɨɨ'³¹ mɨ²jø'² vino. 'E³ quie'²³ la'³ tuu'³ loo³ co̱'³. Dxi³ji̱i̱n³¹ 'e³ rɨ²³xi'²³ dsa³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'mɨɨn³² 'e̱'³ tuu'³ loo³ 'e³ 'mɨɨn³². ");
INSERT INTO cnlNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ca²³tɨ́³ 'e³ ca²³ŋɨ́n³ Jesús je² rɨ³dsɨ³² cuɨɨ³ trigo co̱o̱³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. 'E³ la²³ ta'n² jui³¹ dsa³ quien³², su̱'²te'²³ mɨ³¹maa'n³ mɨ³¹cuɨɨ³ trigo. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","'E³ jo̱³ ca²³jua'³ dsa³ fariseo. Ca²³sɨ'²³te'²³ Jesús: ―Jóo² jmii'³¹ jmoo³² dsa³ quien³²nu³. ¿'Ee² lǿ² jmoo³²te'²³ 'e³ 'a²³jia'³ joo'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","'E³ jo̱³ ca²³jua'³ 'ñée²: ―¿'A² 'a²³jia'³ lɨ'³ ca³jóo²ra'³ ji³ je² to̱o̱²³ 'e³ jmii'³¹ ca²³jmée³ David mɨ²jaa²³² ma²ca¹ji̱'¹ la³dsɨɨ³²? Ca²³la²³cue̱'²³ 'ñée² quia̱'² dsa³ 'i³ quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","'E³ jo̱³ 'í² ñʉ'²³ 'ñʉ́² je² mi³gáan³ dsa³ Dios. 'E³ quie'²³ Abiatar rɨ³løn³¹ juii² jmii³ dsa³ mɨ²jo̱³. Ca²³e'² David 'ɨ²³juɨ² 'mɨ'n²³ 'e³ ca²³cuǿø²³te'²³ Dios. Ca²³e'² quie'²³ 'e³ jo̱³, juø'n³ quie'²³ 'nɨɨ'n³¹ jmii³ dsa³ hua² joo'²³ rɨ²³e'². 'E³ quie'²³ ca²³cuǿø²³ dsa³ 'i³ quia̱'² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ca²³jua'³ co̱'³ Jesús. Ca²³sɨ'²³ dsa³ fariseo: ―Ca²³dxi³ 'i'²³ Dios 'e³ xa³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ 'e³ jua'³ 'ne'² quie'² dsa³. 'A²³la³ jo̱³ 'e³ ca²³jmén² dsa³ 'e³ jua'³ 'ne'² li²³xen³ 'i³ rɨ²³mi²³gáan³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jné² Jo̱o̱³¹ Dsa³ rɨ³løn³¹na¹ juii² la²³jɨ³, juø'n³ quie'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","'Í² co̱'³ Jesús ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. 'Iún² jø̱n³ dsa³ 'i³ 'uaa'³ guoo³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ca²³tén²te'²³ Jesús. Qui² 'née²³te'²³ rɨ²³jóo²te'²³ xi² rɨ²³mi²³'láan³ dsa³ 'í³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. Qui² 'née²³te'²³ rɨ²³cuǿ²³te'²³ dsoo² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'i³ 'uaa'³ guoo³: ―Naa'n²³ 'nʉ³. Noo³ dxoo'³¹ la³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³: ―¿Jmii'³¹ dxʉ́²³ rɨ²jmee²ra² jmɨ́ɨ² je² tøø³ dsɨ́² dsa³, lǿn³na'³? ¿'A² joo'²³ rɨ²jmee²ra² 'e³ dxʉ́²³? ¿'A² joo'²³ rɨ²jmee²ra² 'e³ 'a²³jia'³ dxʉ́²³? ¿'A² joo'²³ rɨ²laan²³²na² dsa³ 'e³ 'a²³ cu²jú̱n³? ¿'A² joo'²³ rɨ²jŋɨ'n²³²na² dsa³? 'E³ quie'²³ 'a²³jia'³ ca²³'í̱n² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","'E³ jo̱³ ti̱'n³ Jesús ca²³jóon² dsa³. Ŋɨ́³ dsɨ́² 'e³ jua'³ rɨ³laa³ dsɨ́²te'²³. 'E³ quie'²³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ 'uaa'³ guoo³: ―'Íi³ guaan³². 'E³ jo̱³ ca²³'ɨ́ɨ³ guoo³ dsa³ 'í³. Lɨ́ɨn² guoo³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ca²³'uǿøn² dsa³ fariseo. Xe̱'n² jmɨ́ɨ² ca²³sɨ́n²³ ca²³ŋɨ'n³te'²³ júu² quia̱'²te'²³ dsa³ 'i³ noo³ quia̱'² Herodes 'e³ jmii'³¹ rɨ²³lí³ juø'² rɨ²³jŋɨ'n²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","'E³ quie'²³ ca²³bǿn³ Jesús quia̱'² dsa³ quien³². Ŋóo² co̱³² jmɨ²³ñii'³¹. Bi²³ juɨ́ɨn²³ dsa³ 'i³ xen³ estado Galilea 'i³ ca²³qui̱'³ Jesús. 'E³ quie'²³ la'³ dsa³ 'i³ xen³ estado Judea co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","'E³ quie'²³ la'³ dsa³ 'i³ xen³ juɨɨ³ Jerusalén quia̱'² 'i³ xen³ Idumea quia̱'² 'i³ xen³ 'ŋóo² la²³ jmɨɨ³ juee'³ Jordán. 'E³ quie'²³ la'³ dsa³ 'i³ xen³ la²³ca̱a̱n³ juɨɨ³ Tiro quia̱'² juɨɨ³ Sidón co̱'³. Juɨ́ɨn²³ dsa³ 'i³ i²guín¹ ma²ca¹núu³te'²³ 'e³ jmii'³¹ jmee²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","'E³ jo̱³ ca²³sɨ'²³ dsa³ quien³² 'e³ rɨ²³jmóo²te'²³ ji̱i̱³ co̱o̱³ móo² 'e³ rɨ²³'í³. Qui² bi²³ juɨ́ɨn²³ dsa³ rɨ³ŋɨɨn³¹. Bi²³ juø'² rɨ²³cu'n² jee²³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Juɨ́ɨn²³ dsa³ 'i³ ca²³mi²³'láan³. 'E³ jo̱³ 'lee'n³² la²³ cɨ² uu'n² la²³jɨn³ dsa³ 'i³ dsoo'²³² 'e³ jua'³ 'née²³te'²³ 'e³ rɨ²³quiu̱u̱'n³te'²³ Jesús guoo³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Xe̱'n² 'e³ la²³ ŋǿn² Jesús te'²³ espíritus quien³² mɨ²³sɨ²³quiʉ'², ca²³quiaa³ rɨ³'in³²te'²³ xi²ñi² Jesús. Ca²³lʉ́³te'²³ quiʉ̱ʉ̱³. Ca²³jua'³te'²³: ―Jo̱o̱³¹ Dios hua² 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'E³ quie'²³ ca²³dxi³ 'i'²³ Jesús 'e³ 'a²³jia'³ ma²³ rɨ²³jmóo²te'²³ júu² 'e³ 'i̱i̱² sɨɨ'³¹ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ŋóo² Jesús yʉʉ'³¹ mo'³. Ca²³jén²³ la²³'nɨɨ'n³¹ dsa³ 'i³ ca²³'náan²³. 'E³ jo̱³ ca²³guín²³te'²³ quia̱'²te'²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ca²³'uøøn³ gui²³tʉ̱́n³ dsa³ 'i³ rɨ²³ŋɨ́²³ quia̱'², 'i³ rɨ²³xíin²³ 'e³ jua'³ rɨ²³'ɨ́ɨ²³te'²³ júu² quiee'³², ");
INSERT INTO cnlNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","'i³ li²³xa³ ju²³bíi²³ quie'²te'²³ 'e³ rɨ²³'uøøn³ espíritus quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","'I³ la³ te'²³ dsa³ 'i³ gui²³tʉ̱́n³ 'i³ ca²³'náan²³: Muun³² 'i³ ca²³sɨ'²³ Peen²³²; ");
INSERT INTO cnlNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo jo̱²³ñʉʉ'³¹ Zebedeo ca³ti³² quia̱'² jó̱o̱² 'i³ xi̱i̱n³ Juan (Ca²³sɨ'²³ dsa³ 'í³ Boanerges. Qui² la'³ cu³lø³¹ jua'³te'²³ ju²³jmii²³² quiee'³²te'²³: La²³ xen³ i²³'ñeen³¹ xen³); ");
INSERT INTO cnlNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Drøø³¹ quia̱'² Bi³lii² quia̱'² Bar³too² quia̱'² Tee³¹ quia̱'² Tu³moo³² quia̱'² Jacobo jo̱²³ñʉʉ'³¹ Alfeo quia̱'² Tadeo quia̱'² Muun³² dsa³ cananista ");
INSERT INTO cnlNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","quia̱'² Judas Iscariote 'i³ ca²³'nɨ́ɨn²³ Jesús. 'E³ quie'²³ jo̱³ 'í² Jesús co̱o̱³ xi²ñʉ'¹ quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bi²³ juɨ́ɨn²³ dsa³ ca²³ŋɨɨ'n²³ caan²³ Jesús. 'E³ jo̱³ 'a²³jia'³ ma²³ ca²³lǿ²³ juø'² ca²³e'² Jesús quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma²ca¹núu³ la'³ dsa³ 'i³ xen³ quie'² Jesús, i²guín¹ 'e³ jua'³ sɨ³tee³te'²³. Qui² ca²³jua'³te'²³: ―Mɨ³ŋøn³ mɨ²dxi² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","'E³ quie'²³ jo̱³ ca²³jua'³ te'²³ dsa³ 'e²³ ley 'i³ i²guín¹ naan³ juɨɨ³ Jerusalén: ―Quie̱n³ juii² espíritus quien³² mɨ²³sɨ²³quiʉ'², 'i³ xi̱i̱n³ Beelzebú, ¿mɨ³naa'³¹? Ju²³bíi²³ quiee'³² 'i³ 'í³ hua² 'e³ sɨ³lí³ juø'² 'uøøn³ espíritus quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ca²³tøø³ te'²³ dsa³ 'í³ Jesús. Ca²³lʉ́³ júu² rɨ³jnɨ³. Ca²³jua'³: ―¿Jmii'³¹ lǿ² 'e³ rɨ²³lí³ juø'² rɨ²³jmée²³ ju²³bíi²³ quiee'³² Satanás 'e³ rɨ²³'uøøn³ espíritus quien³² 'ñée², lǿn³na'³? ");
INSERT INTO cnlNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Rɨ²³gua'²³ juɨɨ³ je² røøn³ jø̱n³ rey xi³nu³ rɨ²³juín² júu² quiee'³² dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","'E³ quie'²³ la'³, rɨ²³gua'²³ co̱o̱³ sɨ́ɨn² dsa³ xi³nu³ rɨ²³juín²te'²³ júu² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","'E³ quie'²³ la'³, rɨ²³gua'²³ Satanás xi³nu³ mɨ³roo'²³ ñin³² 'ñée², xi³nu³ mɨ³juín² júu² quiee'³². Mɨ³líi² quie'² 'ñée² xi³nu³ la'³ mɨ³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’'E³ quie'²³ 'a²³jia'³ rɨ²³lí³ juø'² 'e³ tu³cua̱a̱n²tu² rɨ²³'í³ dsa³ xi²ñʉ'¹ je² jen³¹ dsa³ 'i³ bi²³ 'uee'n³. 'A²³jia'³ rɨ²³lí³ juø'² rɨ²³'í̱i̱²³ la²³jɨ³ 'e³ xa³ quie'². 'E³ quie'²³ xe̱'n² cɨ² 'ne'² rɨ²³'ñuu'n³te'²³ dsa³ 'i³ 'uee'n³. Jo̱³ hua² rɨ²³lí³ juø'² rɨ²³'í̱i̱²³te'²³ la²³jɨ³ 'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Sɨ³lí³ juø'² sɨ³yʉʉ³ la²³jɨ³ jia'³ cɨ'²³ 'iin³² dsoo² quia̱'² dsoo² 'e³ bi²³ 'ñe'² lʉ²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³ dsoo² 'e³ 'ñe'² lʉ²³ dsa³ 'en³² Espíritu Gáan³. Xa³ dsoo² quiee'³² dsa³ 'í³ 'e³ 'a²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","La'³ ca²³jua'³ Jesús ma²ca¹jua'³te'²³ 'e³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ca²³dxóo² xóo² quia̱'² te'²³ jó̱o̱² Jesús. Ca²³noo³te'²³ xi²dxi³². Ca²³xíin²³te'²³ dsa³ 'i³ ca²³tøø³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","'E³ quie'²³ bi²³ juɨ́ɨn²³ dsa³ 'i³ nee'n²³² caan²³ Jesús. 'E³ jo̱³ xen³ 'i³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―Xi'n²³ xi²dxi³² xaan³ quia̱'² já̱a̱n², ¿mɨ³naa'³¹? Ŋɨɨ'n³²te'²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'I̱i̱² sɨɨ'³¹ xen²³? ¿'I̱i̱² sɨɨ'³¹ ja̱a̱n³²? ");
INSERT INTO cnlNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","'E³ jo̱³ ca²³jóon² dsa³ 'i³ nee'n²³² caan²³. Ca²³jua'³ ca²³'én² dsa³ 'í³: ―'I³ la³ xen²³. 'I³ la³ ja̱a̱n³². ");
INSERT INTO cnlNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Qui² rɨ³løn³¹ ja̱a̱n³², rɨ³løn³¹ xen²³ dsa³ 'i³ jmoo³² 'e³ la²³ 'née²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Co̱'³ cɨ'²³ ca²³tín²³ ca²³'ɨ́ɨ³ júu² Jesús co̱³² jmɨ²³ñii'³¹. Bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³ŋɨɨ'n²³ caan²³. 'E³ jo̱³ 'í² 'e̱'³ móo² 'e³ ji̱i̱²³² 'e̱'³ jmɨɨ³. Ca²³gua³ 'e̱'³ móo². Té̱e̱n³ la²³jɨn³ dsa³ co̱³² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ñúun³ la²³jɨ³ 'e³ ca²³'ée²³ dsa³ Jesús. Ca²³lʉ́³ júu² rɨ³jnɨ³. La²³la³ cu³lø³¹ ca²³jua'³ ca²³sɨ'²³ dsa³: ");
INSERT INTO cnlNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―'Ne'² rɨ²núu²ra'³ júu² la³. Ŋóo² jø̱n³ dsa³ 'i³ ca²³juá² mɨ³¹ju̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","'E³ la²³ ca²³juá² mɨ³¹ju̱³, xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² coo³¹ jui³¹. 'E³ quie'²³ jo̱³ ca²³dxi²³guín²³ jo̱o̱³¹ to̱³ 'i³ ca²³la'n² mɨ³¹ju̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","'E³ quie'²³ xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² jee²³² guoo'² 'e³ rɨ³jó³ ñi'² cú̱u̱² je² bi²³ tii³ 'uǿ²³. Bi²³ xe̱'n² ca²³jǿn²³ mɨ³¹ju̱³. Qui² bi²³ tii³ 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","'E³ jo̱³ ca²³la²³jui̱i̱n³¹ ma²mɨ³'áa³ 'i'²³ 'e³ jmee²³ 'ioo³. Qui² 'a²³jia'³ ca²³la²³cuaa²³ jmó². 'E³ jo̱³ hua² 'e³ ca²³la²³quiʉ̱ʉ̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","'E³ quie'²³ xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² jee²³² tó̱o̱². Ca²³cua̱a̱n²³ xoo'³¹ tó̱o̱². Ca²³jlɨ́²³ mɨ³¹ju̱³. 'E³ jo̱³ 'a²³'e³ xa³ mɨɨ³¹ 'e³ ca²³'ɨ́ɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","'E³ quie'²³ xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² 'uǿ²³ ŋún²³. 'E³ jo̱³ ca²³jǿn²³ mɨ³¹ju̱³. Ca²³cua̱a̱n²³. 'E³ quie'²³ jo̱³ ca²³'ɨ́ɨ³ mɨɨ³¹. Xa³ mɨ³¹ju̱³ 'e³ ca²³'ɨ́ɨ³ ma²³ gui²³guiá³ mɨɨ³¹. Xa³ 'e³ ca²³'ɨ́ɨ³ ma²³ tú̱²³ lu²³guiá³ dsɨ³² guiá²³ mɨɨ³¹. 'E³ quie'²³ xa³ 'e³ ca²³'ɨ́ɨ³ ma²³ co̱o̱³ i³lóo³ mɨɨ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","'E³ jo̱³ ca²³jua'³ Jesús: ―'Ne'² rɨ²³núu²³ dsa³ 'i³ 'née²³ rɨ²³cuǿn²³ miin²³ 'e³ rɨ²³núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cɨ̱ɨ̱n³ cɨ² ca²³cuaa'n²³ 'ñée² Jesús quia̱'² dsa³ gui²³tʉ̱́n³ quien³² quia̱'² cɨ² dsa³ 'i³ quia̱'². 'E³ quie'²³ jo̱³ ca²³ŋɨ'²³te'²³ júu² 'e³ jmii'³¹ 'née²³ rɨ²³jua'³ júu² rɨ³jnɨ³ 'e³ mɨ³lʉ́³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","'E³ jo̱³ ca²³jua'³ 'ñée²: ―'Iéen²na'³ júu² miin²³na'³ 'e³ ta³jmee³ra'³ 'i'²³ 'e³ jmii'³¹ lǿ² 'e³ rɨ³løn³¹ Dios juii² dsa³, juø'n³ quie'²³ rɨ³'mo² júu² jo̱³ xe̱'n². 'E³ quie'²³ 'a²³jia'³ 'ióo² júu² 'e³ li²³ta²³jmoo³² 'i'²³ jia'³ cɨ'²³ te'²³ dsa³. Jmø'n² júu² rɨ³jnɨ³ rɨ²³núu²³ te'²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","La'³ cu³lø³¹ jmee²³ Dios 'e³ la²³ 'a²³jia'³ rɨ²³ñí²te'²³, juø'n³ jmi'³ 'nɨɨ'n³¹ rɨ²³jóo²te'²³, 'e³ la²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³jmóo² 'i'²³, juø'n³ jmi'³ 'nɨɨ'n³¹ rɨ²³núu²³te'²³. La²³nɨ³ hua² 'a²³jia'³ jmɨ́ɨ² rɨ²³có̱²te'²³ jui³¹ ca³dsaan³². 'A²³jia'³ rɨ²³yʉʉ³ dsoo² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―¿'A² 'a²³jia'³ ta³jmee³ra'³ 'i'²³ 'e³ jmii'³¹ 'née²³ rɨ²³jua'³ júu² rɨ³jnɨ³ 'e³ mɨ³lʉ́n²³? ¿Jmii'³¹ mi'³ cu³lø³¹ 'e³ rɨ²jmée²ra'³ 'i'²³ 'e³ jmii'³¹ 'née²³ rɨ²³jua'³ la²³jɨ³ sú̱n² júu² rɨ³jnɨ³ jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","La²³ xen³ dsa³ 'i³ jua³² mɨ³¹ju̱³ xen³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Xen³ ca³dxáan² dsa³ 'i³ xen³ la²³ xen³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² coo³¹ jui³¹. 'Ɨɨ³ dsa³ júu² je² nee'n²³²te'¹. Xe̱'n² mɨ³rɨ³nʉʉ³te'²³, jo̱³ sɨ³dxóo² Satanás. Je̱'n³² júu² 'e³ rɨ³jne² dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","'E³ quie'²³ la'³, xen³ ca³dxáan² dsa³ 'i³ xen³ la²³ xen³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² jee²³² guoo'² 'e³ rɨ³jó³ ñi'² cú̱u̱². Xe̱'n² mɨ³rɨ³nʉʉ³te'²³ júu² quiee'³² Dios, bi²³ jɨn³ dsɨ́²te'²³ co̱³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","'E³ quie'²³ 'a²³jia'³ sɨ³li³'uee'n³ dsɨ́²te'²³. 'É̱e̱² 'e³ 'a²³jia'³ sɨ³li³xa³ jmó². Ca²³ji̱i̱³ hua² sɨ³táa²³te'²³. 'E³ quie'²³ xe̱'n² tʉ³²te'²³ mɨ³rɨ³ji̱'²³te'²³ u²³ŋɨ́³ dsɨ́ɨ², mɨ³rɨ³'nee³ júu² dsa³ 'e³ jua'³ coo'³²te'²³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","'E³ quie'²³ xen³ ca³dxáan² dsa³ 'i³ xen³ la²³ xen³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² jee²³² tó̱o̱². Nuu³te'²³ júu² quiee'³² Dios 'u². ");
INSERT INTO cnlNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","'E³ quie'²³ sɨ³li³ñúun³ dsɨ́² 'e³ jmii'³¹ rɨ²³lí³ la²³jɨ³ ta² quiee'³². Sɨ³caa'n³² jui³¹ 'e³ jua'³ 'iin²³ dsɨ́² cuu². 'E³ quie'²³ ñúun³ la²³jɨ³ 'e³ 'née²³ 'e³ li²³xa³ quie'². La²³jɨ³ 'e³ jo̱³ hua² sɨ³quie̱e̱'n²³ dsɨ́²te'²³. 'E³ jo̱³ hua² sɨ³jlɨ́²³ júu² quiee'³² Dios. 'A²³'e³ mɨɨ³¹ xa³ 'e³ rɨ²³'ɨ́ɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","'E³ quie'²³ xen³ ca³dxáan² dsa³ 'i³ xen³ la²³ xen³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² 'uǿ²³ ŋún²³. 'I³ 'í³ hua² 'i³ nuu³ júu² quiee'³² Dios. Jmoo³² quie'²te'²³. 'É̱e̱² 'e³ 'ɨɨ³ mɨɨ³¹. Xen³ 'i³ xen³ la²³ xen³ mɨ³¹ju̱³ 'e³ 'ɨɨ³ ma²³ gui²³guiá³ mɨɨ³¹. Xen³ 'i³ xen³ la²³ xen³ mɨ³¹ju̱³ 'e³ 'ɨɨ³ ma²³ tú̱²³ lu²³guiá³ dsɨ³² guiá²³ mɨɨ³¹. 'E³ quie'²³ xen³ 'i³ xen³ la²³ xen³ mɨ³¹ju̱³ 'e³ 'ɨɨ³ ma²³ co̱o̱³ i³lóo³ mɨɨ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³: ―¿'Ee² lǿ² sɨ³quie̱³ dsa³ 'é̱e̱² jmɨɨ³, lǿn³na'³? 'A²³la³ jo̱³ 'e³ sɨ³quie̱³ 'e³ rɨ²³dxá²³ ñʉ'²³ mɨɨ'³ dsuu², ¿mɨ³naa'³¹? 'A²³la³ jo̱³ 'e³ rɨ²³dxá²³ ñʉ'²³ ji̱i̱², ¿mɨ³naa'³¹? 'E³ quie'²³ sɨ³quie̱³ 'e³ rɨ²³dxá²³ ñi'² joo³¹ 'mo³ jɨ̱ɨ̱n²³² 'e³ jua'³ cu²li³jné³ xi²ñʉ'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","'E³ cɨ² li²³lii²³ la²³jɨ³ 'e³ rɨ³'mo² xe̱'n². 'E³ cɨ² rɨ²³dsóo²³ dsɨ́² dsa³ la²³jɨ³ 'e³ 'a²³jia'³ ñi³²te'²³ xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","'Ne'² rɨ²³núu²³ dsa³ 'i³ 'née²³ rɨ²³cuǿn²³ miin²³ 'e³ rɨ²³núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Co̱'³ cɨ'²³ ca²³lʉ́³. Ca²³jua'³: ―'Ne'² rɨ²jmée²ra'³ 'i'²³ la²³jɨ³ 'e³ nuu³ra'³. Qui² la²³'nɨɨ'n³¹ ñu'n² 'e³ juɨɨ'³²ra'³ dsa³, 'e³ quie'²³ la'³ 'nɨɨ'n³¹ ñu'n² 'e³ rɨ²³sɨ'²³ 'nee'²³ Dios co̱'³. 'E³ quie'²³ dsɨ³² cɨ² la'³ rɨ²³sɨ'²³ 'nee'²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Qui² ñúun³ cɨ² rɨ²³'ióo²³ dsa³ 'i³ xa³ ca³juɨ² quie'² xe̱'n². 'E³ quie'²³ rɨ²³je̱'n²te'²³ la²³'nɨɨ'n³¹ qui³ 'e³ xa³ quie'² dsa³ 'i³ 'a²³'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―La²³la³ cu³lø³¹ 'e³ rɨ³løn³¹ Dios juii² dsa³: Xen³ la²³ xen³ jø̱n³ dsa³ 'i³ jua³² mɨ³¹ju̱³ 'uǿ²³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","'Uøø²³ guɨɨn³ dsa³ 'í³. 'E³ quie'²³ sɨ³naa'n²³ co̱'³ mɨ³li³jné²³. Sɨ³jǿn²³ mɨ³¹ju̱³ quiee'³². Sɨ³cua̱a̱n²³. 'E³ quie'²³ 'a²³jia'³ ñi³² 'ñée² 'e³ jmii'³¹ hua² lǿ² 'e³ sɨ³lí³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","'Ñée² 'uǿ²³ hua² jmee²³ ta² 'e³ sɨ³li³xa³ 'mɨ'n³. Cɨ̱ɨ̱n³ cɨ² sɨ³li³xa³ mɨɨ³¹. Cɨ̱ɨ̱n³ cɨ² co̱'³ sɨ³roo³ mɨɨ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mɨ³rɨ³roo³ mɨɨ³¹, xiin²³ dsa³ 'i³ sɨ³jmóo² 'ó̱o̱²³. Qui² mɨ³tɨ́³ ji̱i̱³ 'e³ jmoo³²te'²³ 'ó̱o̱²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―¿Jmii'³¹ cu³lø³¹ rɨ²juaa'²ra² 'e³ la²³ lǿ² 'e³ rɨ³løn³¹ Dios juii² dsa³? ¿'Ee² júu² rɨ³jnɨ³ 'e³ rɨ²jmeen²³² jɨn³ 'u²? ");
INSERT INTO cnlNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xen³ la²³ xen³ co̱o̱³ mɨɨ³¹ mɨ³¹ju̱³ mostaza. Pii'² cɨ² la²³ cɨ'²³ la²³jɨ³ jia'³ cɨ'²³ mɨ³¹ju̱³ 'e³ jñi³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","'E³ quie'²³ ma²mɨ³'áa³ 'i'²³ 'e³ rɨ³jne² 'uǿ²³, bi²³ sɨ³cua̱a̱n²³. Sɨ³lí³ co̱o̱³ xoo'³¹ nuu³ 'e³ bee'² cɨ² la²³ cɨ'²³ la²³jɨ³ jia'³ cɨ'²³ xoo'³¹ nuu³. Bi²³ bee'² guoo³ sɨ³lí³. Sɨ³lí³ juø'² dxa²³ mɨ²sɨɨ² jo̱o̱³¹ to̱³ jee²³² mɨ³¹guoo³ je² bi²³ xa³ 'i̱'². ");
INSERT INTO cnlNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ñúun³ la²³jɨ³ júu² rɨ³jnɨ³ 'e³ lø³² la²³nɨ³ 'e³ ca²³lʉ́³ Jesús quia̱'² dsa³. Ca²³sɨ'²³ dsa³ la²³'nɨɨ'n³¹ qui³ 'e³ lǿ²³ juø'² ca²³jmóo²te'²³ 'i'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jmø'n² júu² rɨ³jnɨ³ 'e³ ca²³lʉ́³ quia̱'² dsa³. 'E³ quie'²³ co̱³quie'² ca²³lʉ́³ quia̱'² dsa³ quien³². Ca²³jmée³ jɨn³ la²³jɨ³ júu² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ma²ca¹nʉʉ³ jmɨ́ɨ² jo̱³, ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Mɨ²³gui²³²ra² joo³¹ i²³'ŋóo². ");
INSERT INTO cnlNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","'E³ jo̱³ ca²³cuaa'n³te'²³ dsa³. Ca²³guín²³te'²³ quia̱'²te'²³ Jesús 'e³ la²³ 'iún² quie'²³ 'e̱'³ móo². Xa³ cɨ² móo² 'e³ ca²³guín²³ quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","'E³ quie'²³ jo̱³ bi²³ bee'² dxí³ ca²³ró̱o̱²³. Sɨ³'o² la²³ cɨ² jmɨɨ³ móo² la²³'nɨɨ'n³¹ 'e³ xaan³² 'ñée² jmɨ²³ñii'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","'E³ quie'²³ rɨ³guɨɨn³ Jesús tu³'mɨɨ³ móo² ra̱a̱n²³ ñi'² jlɨ² dxi². 'E³ jo̱³ ca²³ñín²te'²³. Ca²³sɨ'²³te'²³: ―Dsa³ 'e²³, mɨ³ sɨ³'a'² móo². ¿'A² dxʉ́²³ 'e³ cu²gua'¹ quie'²³ jne², lǿn³nu³? ");
INSERT INTO cnlNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","'E³ jo̱³ ca²³naa'n²³ Jesús. Ca²³jín² dxí³. Ca²³jua'³ ca²³sɨ'²³ jmɨ²³ñii'³¹: ―Tu³cɨ² 'nʉ³. 'A²³ ma²³ rɨ³bɨn³²nu³ 'uaa'³. 'E³ jo̱³ ca²³cu²³tá² dxí³. 'A²³jia'³ ma²³ ca²³xáan² 'ñée² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―¿'Ee² lǿ² bi²³ mɨ³juee'n²³²na'³ miin²³na'³? ¿'A² 'a²³jia'³ sɨ³táan³na'³ quia̱'n²na'³ jné² ru'³? ");
INSERT INTO cnlNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","'E³ jo̱³ bi²³ juø'²³ ca²³ti²³cø̱n³¹te'¹. Ca²³lʉ́³ la²³ co̱³quie'² miin²³. Ca²³jua'³te'²³: ―¿'I̱i̱² mi'³ sɨɨ'³¹ nɨ³ cu²ne²ra²? Dxí³ bee'² quia̱'² jmɨɨ³ mi'³ mɨ³guaan²³ 'e³ la²³ mɨ³dxi³ 'i'²³, ¿na'²? ");
INSERT INTO cnlNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ca²³dxi²³guín²³te'²³ je² nee'n²³² dsa³ Gadara joo³¹ i²³'ŋóo² la²³ jmɨ²³ñii'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Ca²³bǿn³ 'e̱'³ móo² Jesús. Núu²³ xen³ jø̱n³ dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'² 'i³ jen³¹ too³ 'loo³ je² 'aan³²te'²³ 'lɨ́ɨ³. Ca²³bǿn³ dsa³ 'í³ jo̱o̱²³na²³. Ca²³mi²³jí̱i̱n³ Jesús. Qui² 'a²³jia'³ ma²³ ca²³lǿ²³ juø'² ca²³'ñúun²³te'²³ dsa³ 'í³, juø'n³ quie'²³ ñí² cadenas. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ñúun³ taa'² ca²³'ñʉ́ʉ³te'²³ guoo³ tɨɨ² ñí² cadenas 'u². 'E³ quie'²³ ca²³tun³ cadenas 'e³ rɨ³'ñʉʉ³¹ guoo³. Ca²³'níi³ cadenas 'e³ rɨ³'ñʉʉ³¹ tɨɨ². 'A²³'i̱³ xen³ 'i³ lǿ²³ juø'² ca²³téen²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jmɨ́ɨ²³ 'uøø²³ 'iún² too³ 'loo³ je² rɨ³'aan²³ 'lɨ́ɨ³. Ŋɨ́³ mo'³. Bi²³ yoo'²³ tø³². Bi²³ tʉʉ'n³ 'ñée² juɨɨ²³² cú̱u̱². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","'E³ quie'²³ huɨ̱́ɨ̱³ ŋǿn² Jesús. 'E³ jo̱³ 'í² jui³¹ ca²³la²³dxí². Ca²³quiaa³ rɨ³'in³² xi²ñi² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Quiʉ̱ʉ̱³ ca²³lʉ́³. Ca²³jua'³: ―¿'Ee² lǿ² dxaan²³nu³ 'uǿøn²nu³ quia̱'n²nu³ jné², Jesús Jo̱o̱³¹ Dios 'i³ jen³¹ yʉʉ'³¹ güii³? Ñi³² Dios 'e³ juøøn³²na²³ 'nʉ³ 'e³ 'a²³ rɨ³jmee'n³²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","La'³ cu³lø³¹ ca²³jua'³ dsa³ 'í³. Qui² ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nʉ³, espíritu quien³² mɨ²³sɨ²³quiʉ'²: Cu³bøøn²³nu³ dsa³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","'E³ jo̱³ ca²³jua'³ co̱'³ Jesús: ―¿Jmii'³¹ xi̱i̱n³nu³? 'E³ jo̱³ ca²³jua'³ dsa³ 'í³: ―'I³ juɨ́ɨn²³ xi̱i̱n³na'³¹. Qui² bi²³ juɨ́ɨn²³na'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","'E³ jo̱³ bi²³ ca²³ŋɨ́ɨ³ mɨ²'áa² quie'² Jesús 'e³ 'a²³jia'³ rɨ²³xíin²³ espíritus 'í³ je² huɨ̱́ɨ̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bi²³ ma²³'nee³ juɨ́ɨn²³ cu²xi³¹ 'i³ ta'n² ee'³² coo³¹ mo'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","'E³ jo̱³ ca²³ŋɨ́ɨ³ la²³bii²³ miin²³ espíritus quien³² mɨ²³sɨ²³quiʉ'². Ca²³jua'³te'²³. Ca²³sɨ'²³te'²³ Jesús: ―Xiin²³ jnee'³¹ je² ta'n² cu²xi³¹ 'e³ la²³ rɨ²taa'n²³na'³¹ miin²³na'³¹ cu²xi³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","'E³ jo̱³ ca²³cuǿ³ júu² la'³ Jesús. Ca²³'uǿøn²³ espíritus quien³² mɨ²³sɨ²³quiʉ'². Ca²³taa'n³ miin²³ cu²xi³¹. 'E³ quie'²³ xen³ co̱o̱³ tú̱²³ mil 'nɨɨ'n³¹ cu²xi³¹. 'E³ jo̱³ ca²³ta'n²³te'²³ jui³¹ je² juɨɨ'²³². Ca²³jiu'n² 'e̱'³ jmɨ²³ñii'³¹. 'E³ jo̱³ ca²³'a'n²te'²³ 'e̱'³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","'E³ quie'²³ jo̱³ ca²³cuɨ̱́ɨ̱² dsa³ 'i³ 'aan³² cu²xi³¹. I²jmóo¹ júu² jee²³² juɨɨ³ quia̱'² ranchos pii'². 'E³ jo̱³ i²guín¹ dsa³ i²joo³ 'e³ jmii'³¹ cu³lø³¹ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ca²³dxi²³guín²³te'²³ caan²³ Jesús jo̱o̱²³na²³. 'E³ quie'²³ jo̱³ ŋǿn²te'²³ dsa³ 'i³ quie̱n³ juɨ́ɨn²³ espíritus quien³² mɨ²³sɨ²³quiʉ'² xe̱'n². Te³ jen³¹ dsa³ 'í³. Quii'³ cuo̱o̱³. Dxʉ́²³ mɨ²dxi². 'E³ jo̱³ bi²³ ca²³jue'n² miin²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","'E³ quie'²³ jo̱³ ca²³jme'n² júu² dsa³ 'i³ ŋó²³ 'e³ jmii'³¹ ca²³ji̱'²³ dsa³ 'í³, 'e³ jmii'³¹ ca²³ji̱'²³ cu²xi³¹ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","'E³ jo̱³ ca²³sɨ'²³te'²³ Jesús 'e³ cu²bǿn³ la²³ca̱a̱n³ je² nee'n²³²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","'E³ la²³ 'í² Jesús 'e̱'³ móo², ca²³lʉ́³ dsa³ 'i³ quie̱n³ espíritus quien³² mɨ²³sɨ²³quiʉ'² xe̱'n². Ca²³ŋɨ́ɨ³ la²³bii²³ ca²³sɨ'²³ Jesús 'e³ rɨ²³cuǿ²³ júu² 'e³ rɨ²³dsóo² quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","'E³ quie'²³ 'a²³jia'³ ca²³cuǿ³ júu² la'³ Jesús. Ca²³jua'³: ―Guø'n³ co̱'³ quién²nu³. Rɨ²juɨɨ'n³¹ 'i³ xen³ quién²nu³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'e³ mɨ³jméen²³ quién²nu³ jné² Juiin³, 'e³ jmii'³¹ 'nɨɨ'n³¹ 'e³ mɨ³la³cuu'²³ dsɨn²³ quia̱'n²³²na¹ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","'E³ quie'²³ jo̱³ ŋóo² dsa³ 'í³. Ca²³'ɨ́ɨ³ júu² la²³ca̱a̱n³ je² xi̱i̱n³ Guiá²³ Juɨɨ³ 'e³ jmii'³¹ 'nɨɨ'n³¹ ca²³jmée³ Jesús quie'². 'E³ jo̱³ bi²³ juø'²³ ca²³núu³ la²³jɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jui³¹ móo² ŋóo² co̱'³ Jesús joo³¹ i²³'ŋóo². Bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³ŋɨɨ'n²³ caan²³ 'ñée² 'e³ la²³ 'iún² quie'²³ co̱³² jmɨ²³ñii'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","'E³ quie'²³ ca²³dxóo² jø̱n³ dsa³ 'i³ xi̱i̱n³ Jairo 'i³ dxi³ 'i'²³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Ma²ŋøn³¹ Jesús, ca²³quiaa³ rɨ³'in³². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Bi²³ ca²³ŋɨ́ɨ³ mɨ²'áa² quie'² Jesús. Ca²³jua'³: ―Mɨ³ rɨ²³jú̱n³ xii'³ mɨ́³ quién²³na²³. Rɨ²jméen² co̱o̱³ mɨ²'áa² dsoo³²ra² cu³dxén² guaan³² ñi'² quiee'³² 'e³ cu²'láan³, 'e³ la²³ 'a²³jia'³ rɨ²³jú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","'E³ jo̱³ ŋóo² Jesús quia̱'² dsa³ 'í³. 'E³ quie'²³ bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³guín²³ tu³cɨ̱ɨ̱n³. Bi²³ rɨ³cuu'n³² jee²³² dsa³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Xen³ jø̱n³ mɨ́³ 'i³ mɨ³tɨ́³ gui²³tʉ̱́³ ji̱i̱³ ñi³ 'e³ sɨ³ŋɨ́n³ jmɨ²³'ǿn². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bi²³ dxi³quié̱n², juø'n³ quie'²³ juɨ́ɨn²³ tɨ³² 'oo³ 'i³ ca²³jmóo² 'oo³ quie'². Ca²³dsá²³ la²³jɨ³ 'e³ xa³ quie'² 'e³ ca²³quí² jñii³¹ 'oo³. 'E³ quie'²³ bi²³ cɨ² ca²³jó³ dsóo² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ca²³núu³ 'e³ la²³ lǿ² 'e³ ca²³jua'³ dsa³ ca²³'én² Jesús. 'E³ jo̱³ ca²³ŋɨ́n³ jee²³² quiee'³² dsa³. Ca²³lǿn²³ mɨ³lén² rɨ²³coo'² Jesús. Ca²³quiʉ̱'² mɨ²xi¹guoo³ cuo̱o̱³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Qui² lǿn³ 'ñée²: Líi² te³ rɨ²quiu̱'n¹ guaan²³ cuo̱o̱³ jo̱³ rɨ²³liin²³na²³ 'u². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Xe̱'n² jmɨ́ɨ² ca²³'ɨ́ɨ³ 'e³ sɨ³ŋɨ́n³ jmɨ²³'ǿn². Ca²³la²³quii²³ 'ñée² 'e³ ca²³'láan³ 'e³ la²³ lǿ² 'e³ sɨ³ji̱'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","'E³ quie'²³ ca²³la²³quii²³ 'ñée² Jesús 'e³ ca²³bǿn³ ca³juɨ² ju²³bíi²³ quiee'³². 'E³ jo̱³ ca²³ji̱i̱n²³ je² xi'n²³ jee²³² quiee'³² dsa³. Ca²³jua'³: ―¿'I̱i̱² sɨɨ'³¹ 'i³ mɨ³quiʉ̱'² guoo³ cua̱a̱n²³? ");
INSERT INTO cnlNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","'E³ jo̱³ ca²³jua'³ dsa³ quien³²: ―Máan³ 'e³ bi²³ rɨ³cuu'n³²nu³ jee²³² dsa³. ¿Jmii'³¹ lǿ² 'e³ juø'n³ 'nʉ³: “¿'I̱i̱² sɨɨ'³¹ 'i³ mɨ³quiu̱u̱'n³ jné² guoo³”? ");
INSERT INTO cnlNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","'E³ quie'²³ ca²³jóo² Jesús la²³cu'². Joo³² 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ mɨ³quiu̱u̱'n³ guoo³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","'E³ quie'²³ ñi³² mɨ́³ 'e³ jmii'³¹ lǿ² 'e³ ca²³ji̱'²³. 'E³ jo̱³ bi²³ jleen²³ la²³'nɨɨ'n³¹ 'e³ juøø'n²³. Ca²³quiaa³ rɨ³'in³² xi²ñi² Jesús. Ca²³jmée³ júu² 'e³ la²³ lǿ² ca²³lǿ²³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","'E³ jo̱³ ca²³jua'³ Jesús: ―Ja̱a̱n²³ quién²³na²³, mɨ³lɨɨn³²nu³ 'e³ juø'n³ sɨ³táan³nu³ quia̱'n²nu³ jné². Dxa² co̱o̱³ 'áan² 'e³ guø'n³²nu³. Ma²³ cu²jí̱i̱n¹nu³ 'e³ la²³ sɨ³jí̱i̱n²nu³ xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lʉ²³ quie'²³ la'³ Jesús ma²ca¹dxi¹guín¹ dsa³ 'i³ naan³ xi²ñʉ'¹ quiee'³² Jairo. Xen³ 'i³ ca²³jua'³: ―Mɨ³jú̱n²³ ja̱a̱n³, ¿mɨ³naa'³¹? 'A²³jia'³ ma²³ 'ne'² rɨ²cuǿn² cɨ² u²³ŋɨ́³ dsɨ́ɨ² quie'² dsa³ 'e²³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","'E³ quie'²³ 'a²³jia'³ ca²³jmée³ quie'² Jesús 'e³ la²³ lǿ² 'e³ ca²³jua'³te'²³. Ca²³jua'³ ca²³sɨ'²³ Jairo: ―'A²³ rɨ³juø'n²³nu³ 'uǿøn²nu³. 'Nɨɨ'n³¹ 'e³ rɨ²³sɨ²³táan³nu³ 'ne'². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ca²³cuǿ³ júu² 'e³ dsoo³² 'nɨɨ'n³¹ Peen²³² quia̱'² Jacobo quia̱'² Juan la²³ ca³já̱a̱n². 'A²³jia'³ ca²³cuǿ³ júu² 'e³ rɨ²³dsóo² jia'³ cɨ'²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","'E³ quie'²³ jo̱³ ca²³dxi²³guín²³te'²³ quie'² Jairo. Ŋó²³te'²³ 'e³ bi²³ yoo'²³ tø³² dsa³. 'Oo'³² dsa³. Quiʉ̱ʉ̱³ yoo'²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","'E³ quie'²³ ma²'i³¹ xi²ñʉ'¹ Jesús, ca²³jua'³: ―¿'Ee² lǿ² 'e³ yoo'³ tø³ra'³? ¿'Ee² lǿ² 'e³ 'o'²ra'³? 'A²³jia'³ rɨ³jú̱n² xii'³. Te³ rɨ³guɨɨn³ hua². ");
INSERT INTO cnlNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","'E³ jo̱³ bi²³ ca²³jáa² ca²³ŋɨ́ɨn²te'²³ Jesús. 'E³ quie'²³ jo̱³ ca²³dxi³ 'i'²³ Jesús 'e³ rɨ²³'uǿøn²³ xi²dxi³² la²³jɨn³. 'E³ jo̱³ ŋóo² quia̱'² xóo² jmii³ xii'³ quia̱'² dsa³ 'i³ quia̱'² 'ñée². 'Í² je² rɨ³caa'n³² xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","So̱'²³ guoo³ xii'³. Ca²³jua'³ ca²³sɨ'²³ xii'³: ―Talita, cum ―ca²³jua'³. Qui² la'³ cu³lø³¹ jua'³te'²³ ju²³jmii²³² quiee'³²te'²³: Xii'³ mɨ́³, naa'n²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Xe̱'n² jmɨ́ɨ² ca²³naa'n²³ xii'³. Ca²³ŋɨ́³. Qui² mɨ³tɨ́³ co̱o̱³ gui²³tʉ̱́³ ji̱i̱'n²³ xii'³ mɨ́³ 'í³. 'E³ jo̱³ bi²³ ma²³'nee³ juø'²³ ca²³ti²³cø̱n³¹te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","'E³ quie'²³ ca²³dxi³ 'i'²³ Jesús 'e³ cu³xi³ 'í̱³ dsa³ 'a²³jia'³ rɨ²³sɨ'²³te'²³ 'e³ la²³ lǿ² mɨ³lǿ²³. Ca²³dxi³ 'i'²³ 'e³ rɨ²³cuǿø²³te'²³ xii'³ 'e³ rɨ²³e'². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","'E³ quie'²³ ca²³bǿn³ Jesús je² núu²³. Ŋø'n² co̱'³ juɨɨ³ quiee'³² ca³ti³² quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma²ca¹tɨ́³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³, ca²³'ée²³ dsa³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Bi²³ juø'²³ ca²³ti²³cø̱n³¹ juɨ́ɨn²³ dsa³ 'i³ ca²³núu³ júu² quiee'³². Ca²³jua'³te'²³: ―¿Jiaa'³¹ ca²³mi²³tɨn²³ dsa³ nɨ³ la²³jɨ³ júu² 'e³ 'e²³? Qui² bi²³ ta³jmee²³ 'i'²³. Bi²³ bee'² u²³juø'²³ 'e³ jmee²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿'A² 'a²³la³ 'í³ tɨ³² 'mo³ dsa³ nɨ³ cu²ne²ra²? Jo̱o̱³¹ Ma³rii³¹. La²³ ca³já̱a̱n² quia̱'² Jacobo quia̱'² Søø³² quia̱'² Judas quia̱'² Muun³². Nee'n²³² jee²³² quiee³²ra² jó̱o̱² 'i³ mɨ́³. 'E³ jo̱³ 'a²³jia'³ ma²³ ca²³táan³te'²³ quia̱'²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","'E³ jo̱³ ca²³jua'³ Jesús: ―'A²³ ma²³ la²³jɨn³ dsa³ mi³juø'²³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. 'Nɨɨ'n³¹ dsa³ 'i³ xen³ juɨɨ³ quiee'³², 'nɨɨ'n³¹ 'i³ xen³ quie'² quia̱'² 'i³ nee'n²³² xi²ñʉ'¹ quiee'³² hua² 'i³ 'a²³jia'³ 'née²³ rɨ²³mi²³juø'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","'E³ jo̱³ 'a²³jia'³ ca²³lǿ²³ juø'² ca²³jmée³ u²³juø'²³ 'e³ bi²³ bee'² je² núu²³. Te³ 'a²³ jø'n³ ma² dsa³ 'i³ dsoo'²³² 'i³ ca²³mi²³'láan³ ma²ca¹dxá³ guoo³ ñi'² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Bi²³ juø'²³ ca²³ti²³cø̱n³¹ 'ñée² 'e³ 'a²³jia'³ jmɨ́ɨ² sɨ³táan³ dsa³ juɨɨ³ quiee'³². 'E³ jo̱³ ñíin² la²³ca̱a̱n³ ranchos 'e³ jua'³ 'ee²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ca²³tøø³ dsa³ gui²³tʉ̱́n³ quien³² 'e³ jua'³ rɨ²³xíin²³ la²³ca̱a̱n³. Ca²³xíin²³ cɨ'³ áan²³ cɨ'³ la²³ co̱o̱³ to̱o̱²³. Ca²³cuǿ³ júu² 'uee'n³ quie'²te'²³ 'e³ la²³ rɨ²³lí³ juø'² rɨ²³'uøøn³te'²³ espíritus quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ca²³dxi³ 'i'²³ 'e³ co̱o̱³ 'mo³ mɨ³'uu²³² hua² rɨ²³có̱²te'²³ 'e³ la²³ rɨ²³ta'n²³te'²³ jui³¹. 'A²³jia'³ 'ne'² rɨ²³jmóo²te'²³ ji̱i̱³ morral, 'a²³ cɨ'²³ 'ɨ²³juɨ², 'a²³ cɨ'²³ cuu² 'e³ rɨ³pee'²³ paa²i². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Líi² rɨ²³'ee²³te'²³ loo³. 'E³ quie'²³ 'a²³jia'³ 'ne'² 'e³ rɨ²³cɨ'²te'²³ dxi²³juɨn³¹ cuo̱o̱³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","'E³ jo̱³ ca²³jua'³: ―Je² rɨ²³cuǿø²³te'²³ 'nee'²³ xi²ñʉ'¹, núu²³ rɨ²cuaa'n²³na'³ la²³huø'n²³ 'e³ rɨ²³tɨ́²³ 'e³ rɨ²'uøøn³²na'³ juɨɨ³ jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'E³ quie'²³ xi³nu³ xen³ 'i³ 'a²³jia'³ rɨ²³'i'n² 'nee'²³, xi³nu³ xen³ 'i³ 'a²³jia'³ rɨ²³núu²³ júu² quien³²na'³, jo̱³ rɨ²quia'¹ra'³ tɨɨ³¹ra'³. Cu²'ló¹ 'laa³ 'e³ rɨ³'ɨ̱'n² tɨɨ³¹ra'³ mɨ³rɨ³'uøøn³²na'³ 'e³ cu²li³lii²³ 'e³ 'a²³jia'³ dxʉ́²³ 'e³ la²³ jmoo³² te'²³ dsa³ 'í³. Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Bi²³ cɨ² gáan³ dxíi³ quie'² dsa³ juɨɨ³ je² 'a²³jia'³ rɨ²³'i'n²te'²³ 'nee'²³ la²³ cɨ'²³ quie'² dsa³ juɨɨ³ Sodoma quia̱'² dsa³ juɨɨ³ Gomorra mɨ³rɨ³ti³ 'e³ rɨ²³dxá²³ Dios ta² quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","'E³ jo̱³ i²guín¹te'²³ la²³ca̱a̱n³. I²'ii³te'²³ júu² 'e³ 'ne'² rɨ²³tʉ́² dsa³ 'e³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bi²³ juɨ́ɨn²³ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'i³ ca²³'uøøn³te'²³. Bi²³ juɨ́ɨn²³ dsa³ 'i³ dsoo'²³² 'i³ ca²³mi²³'láan³te'²³ ma²ca¹jñúun³te'²³ noo²³². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ca²³núu³ rey Herodes 'e³ jmii'³¹ jmoo³²te'²³. Qui² bi²³ ca²³sóo²³ ca²³jó²³ júu² 'e³ jmii'³¹ jmee²³ Jesús. 'E³ jo̱³ ca²³jua'³ Herodes. Ca²³'én² Jesús: ―Mɨ³ji̱i̱'²³ co̱'³ Juan 'i³ ca²³xáan² dsa³ jmɨɨ³. 'E³ jo̱³ hua² quie̱³ ju²³bíi²³ 'e³ sɨ³lí³ juø'² jmee²³ u²³juø'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","'E³ quie'²³ xen³ dsa³ 'i³ ca²³jua'³: ―Mɨ³güee'n³² co̱'³ Elías. 'E³ quie'²³ xen³ cɨ² 'i³ ca²³jua'³: ―Rɨ³løn³¹ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios 'e³ la²³ xen³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","'E³ quie'²³ ma²ca¹núu³ Herodes, ca²³jua'³: ―Juan 'i³ ca²³dxin²³ 'i'²³ 'e³ ca²³tʉ́n²te'²³ mɨ²dxi² hua² 'í³. Mɨ³ji̱i̱'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Qui² la²³ca̱a̱n³ mɨ³xa³ cɨ² ca³juɨ² ca²³xíin²³ dsa³ Herodes 'i³ sø̱'n² Juan. Ca²³'ñúun²³te'²³ ñí² cadenas. Ca²³ta̱a̱'n³te'²³ i²³ñí². La'³ ca²³jmée³ Herodes. Qui² la'³ ca²³la²³'née²³ mɨ́³ 'i³ xi̱i̱n³ Herodías, mɨ́³ 'i³ ca²³lǿn²³ mɨ²³quie'² Bi³lii² 'i³ la²³ ca³já̱a̱n² quia̱'² Herodes. 'E³ quie'²³ ca²³tøø³ mɨ²³quie'² jó̱o̱² 'ñée² Herodes. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","'E³ jo̱³ ca²³jua'³ Juan. Ca²³sɨ'²³ Herodes: ―'A²³jia'³ joo'²³ 'e³ quia̱'n²nu³ mɨ²³quie'² já̱a̱n². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","'E³ jo̱³ hua² 'e³ bi²³ hui²³dsɨ́ɨn² Herodías ñin³² Juan. 'Née²³ rɨ²³jŋɨ'n²³ Juan 'u². 'E³ quie'²³ 'a²³jia'³ lɨ'² juø'² xe̱'n² mɨ́³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Qui² 'ñaa'n²³ Juan Herodes. Ñi³² 'e³ rɨ³løn³¹ ca³dsaan³², 'e³ rɨ³løn³¹ rɨ³jɨ́n². 'E³ jo̱³ ca²³'áan² dxʉ́²³ Juan 'e³ 'a²³ cu²li³xa³ 'e³ rɨ²³ji̱'²³. Bi²³ la²³núu²³ 'e³ la²³ lǿ² júu² 'e³ lʉ²³ Juan. 'E³ quie'²³ bi²³ sɨ³li³ñúun³ dsɨ́² 'e³ la²³ nuu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","'E³ quie'²³ ca²³tɨ́³ jmɨ́ɨ² 'e³ lɨ'² juø'² Herodías. Qui² ca²³dxá³ mɨ²juee'³ Herodes jmɨ́ɨ² 'e³ la²³ ca²³la²³xen³. Ca²³ñii'n³ dsa³ 'i³ ta'n² ta² quia̱'² te'²³ juii² dsa³ 'láa³ quia̱'² te'²³ dsa³ gáan³ 'i³ xen³ estado Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","'Í² jo̱²³mɨɨ³¹ Herodías je² jmoo³²te'²³ mɨ²juee'³. Ca²³dsǿn²³. 'E³ jo̱³ bi²³ ca²³la²³'née²³ 'ñée² Herodes quia̱'² dsa³ 'i³ nee'n²³² mɨ²juee'³. 'E³ jo̱³ ca²³jua'³ Herodes. Ca²³sɨ'²³ xii'³ mɨ́³: ―Rɨ²ŋɨɨ'n³¹nu³ jné² te³ 'ee² 'noo³¹ 'naan³. Qui² rɨ²cuǿøn¹na²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ca²³'én² Dios Herodes ma²ca¹jua'³: ―Líi² rɨ²ŋɨ́ɨn² te³ 'ee² 'noo³¹ 'naan³. Rɨ²cuǿøn¹na²³ 'nʉ³, juø'n³ quie'²³ rɨ²ŋɨ́ɨn² tu³dso'² la²³'nɨɨ'n³¹ je² røøn²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","'E³ jo̱³ ca²³bǿn³ xii'³. Ca²³sɨ'²³ xóo²: ―¿'Ee² 'noo³¹ rɨ²ŋɨɨn²³² cu²ne²ra²? 'E³ jo̱³ ca²³jua'³ xóo²: ―Rɨ²ŋɨ́ɨn² mɨ²dxi² Juan 'i³ xaan³² dsa³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Xe̱'n² jmɨ́ɨ² ŋóo² co̱'³ ca²³la²³dxí² xii'³ je² jen³¹ rey. Ca²³jua'³: ―'Náan²³ 'e³ rɨ²cuøøn³¹nu³ jné² xe̱'n² rɨ³nɨ²³ mɨ²dxi² Juan 'i³ xaan³² dsa³ jmɨɨ³. 'Náan²³ 'e³ rɨ²ta̱'n² 'e̱'³ huɨ̱́ɨ̱²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","'E³ jo̱³ bi²³ ca²³ŋɨ́³ dsɨ́² rey. Qui² ca²³'én² Dios ma²ca¹jua'³ 'e³ rɨ²³cuǿ²³ te³ 'ee² 'noo³¹ rɨ²³ŋɨ́ɨ²³ xii'³. Co̱'³ cɨ'²³ joo³² dsa³ 'i³ ca²³ñii'n³ mɨ²juee'³ quiee'³². 'E³ jo̱³ 'a²³jia'³ ca²³lǿ²³ juø'² ca²³jua'³ 'e³ 'a²³jia'³ ma²³ rɨ²³jmée²³ 'e³ la²³ ca²³ŋɨ́ɨ³ xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","'E³ jo̱³ ca²³xíin²³ xe̱'n² jmɨ́ɨ² jø̱n³ dsa³ 'láa³ 'i³ sɨ³tʉ́n² mɨ²dxi² Juan. Ŋóo² dsa³ 'láa³. 'Í² i²³ñí². Ca²³tʉ́n² mɨ²dxi² Juan. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","To̱'² 'e̱'³ huɨ̱́ɨ̱²³. I²jɨ̱ɨ̱'²³² xii'³ mɨ́³. 'E³ quie'²³ 'ñée² xii'³ mɨ́³ 'í³ ca²³jɨ̱'²³ xóo². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma²ca¹núu³ dsa³ quien³² Juan, i²guín¹te'²³ i²tee³te'²³ 'lɨ́ɨ³. Ca²³'áan²te'²³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","'E³ quie'²³ jo̱³ i²³guiin³² co̱'³ te'²³ dsa³ xiin²³ quien³² Jesús. Ca²³jme'n²te'²³ júu². Ca²³sɨ'²³te'²³ Jesús 'e³ la²³ lǿ² la²³jɨ³ 'e³ ca²³jmóo²te'²³, la²³jɨ³ 'e³ ca²³'é³te'²³ je² i²guín¹te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Ñe³ra'³ la²³'nɨɨ'n³¹ 'nee'²³. Mɨ²³gui²³²ra² je² 'a²³'i̱³ xen³ dsa³ 'e³ la²³ rɨ²tøø³¹ra'³ ca³juɨ² 'óo²ra'³. La'³ ca²³jua'³ Jesús. Qui² 'a²³jia'³ jmɨ́ɨ² rɨ²³güii³ dsa³. 'E³ jo̱³ cu³xi³ 'e³ rɨ²³e'²te'²³ 'a²³'e³ xa³ 'é̱e̱² quie'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","'E³ jo̱³ i²guín¹ miin²³ je² 'a²³'i̱³ xen³ dsa³ 'i³ nee'n²³². I²guín¹te'²³ jui³¹ móo². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","'E³ quie'²³ juɨ́ɨn²³ 'i³ joo³² 'e³ la²³ ca²³guín²³te'²³. Ca²³la²³cuiin²³te'²³. 'E³ jo̱³ ca²³'uǿøn²te'²³ la²³ca̱a̱n³ juɨɨ³ quiee'³²te'²³. Ca²³guín²³te'²³ ca²³la²³dxí² jui³¹ tɨɨ²te'¹. 'E³ jo̱³ jén²³ cɨ² ca²³dxi²³guín²³te'²³. 'Íi² rɨ²³dxóo² Jesús quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","'E³ la²³ ca²³bǿn³ 'e̱'³ móo² Jesús, ŋó²³ 'e³ bi²³ juɨ́ɨn²³ dsa³ 'i³ ca²³dxi²³guín²³. Ca²³la²³cuu'²³ dsɨ́² quia̱'² dsa³ 'í³. Qui² la²³ xen³ dsɨɨ³ joo³ 'i³ 'a²³'i̱³ xen³ 'i³ mi³qui³ quie'² xen³te'²³. 'E³ jo̱³ ñúun³ la²³jɨ³ 'e³ ca²³'ée²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mɨ³cu³'lóo³ jmɨ́ɨ² jo̱³ ca²³guín²³ dsa³ quien³² caan²³ Jesús. Ca²³jua'³te'²³: ―'A²³'i̱³ mi'³ xen³ dsa³ 'i³ nee'n²³² la²³ca̱a̱n³ la³, ¿mɨ³naa'³¹? Bi²³ mɨ³cu³'lóo³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'E³ jo̱³ rɨ²juɨɨ'n³¹ dsa³ 'e³ sɨ³guín²³ la²³ca̱a̱n³ ranchos je² la³ 'e³ sɨ³lá³te'²³ 'e³ rɨ²³e'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","'E³ quie'²³ ca²³jua'³ Jesús: ―'Nee'²³ rɨ²cuøø³¹ra'³ 'e³ rɨ²³e'²te'²³. 'E³ jo̱³ ca²³jua'³te'²³: ―¿'A² sɨ³gui²³ra'³¹ sɨ³la²³²ra'³¹ 'ɨ²³juɨ² 'e³ rɨ²³e'² dsa³ 'e³ la²³'nɨɨ'n³¹ ñu'n² jñiin²³ dsa³ 'e³ tú̱²³ i³lóo³ jmɨ́ɨ² ta²? ");
INSERT INTO cnlNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","'E³ jo̱³ ca²³jua'³ Jesús: ―¿Jo'² 'ɨ²³juɨ² xa³ quién²na'³ ru'³? Cu³jóo²ra'³ rɨ²ne²ra². 'E³ jo̱³ i²joo³te'²³ 'e³ jo'² 'ɨ²³juɨ² xa³. 'E³ quie'²³ jo̱³ ca²³jua'³te'²³: ―'Ñé³ hua² 'nɨɨ'n³¹ xa³. 'E³ quie'²³ xen³ áan²³ 'moo'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","'E³ quie'²³ jo̱³ ca²³dxi³ 'i'²³ Jesús 'e³ rɨ²³gua³ dsa³ ñi'² mɨ³¹ñii³ cɨ'³ ca³'lo³ i²³la³ i²³nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","'E³ jo̱³ ca²³gua³te'²³. Xa³ je² ca²³guó³ cɨ'³ co̱o̱³ i³láan³ dsa³. Xa³ je² ca²³guó³ cɨ'³ tú̱²³ lu²³guién³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","So̱'²³ Jesús la²³jɨ³ 'ñé³ 'ɨ²³juɨ² quia̱'² áan²³ 'moo'³. Ca²³jóo² yʉʉ'³¹. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. 'E³ quie'²³ jo̱³ ca²³xíin² 'ɨ²³juɨ². Ca²³cuǿø²³ dsa³ quien³² 'e³ rɨ²³to'²³te'²³ dxóo². 'E³ quie'²³ la'³, ca²³to'²³te'²³ dxóo² 'noo³¹ quie'² 'moo'³. Ca²³cuǿø²³te'²³ la²³jɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","'E³ jo̱³ ca²³e'² la²³'nɨɨ'n³¹ 'née²³la²³cɨ²te'¹. Ca²³cø̱'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ca²³dxi²³cua̱a̱'n³te'²³ juɨɨ²³² 'ɨ²³juɨ² quia̱'² 'noo³¹ quie'² 'moo'³ 'e³ ca²³tø'n². Ca²³cø̱'n²³ gui²³tʉ̱́³ mɨɨ'³ dsuu² jmø'n² juɨɨ²³² 'e³ ca²³tø'n². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Xen³ 'ñé³ mil 'nɨɨ'n³¹ dsóo²³ 'i³ ca²³e'² 'ɨ²³juɨ² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Xe̱'n² jmɨ́ɨ² ca²³dxi³ 'i'²³ Jesús 'e³ rɨ²³ta'n²³ 'e̱'³ móo² dsa³ quien³², 'e³ sɨ³guín²³te'²³ juɨɨ³ Betsaida joo³¹ i²³'ŋóo². Ca²³dxi³ 'i'²³ 'e³ sɨ³guín²³te'²³ jén²³ cɨ² la²³ 'ñée². Qui² 'e³ cɨ² tʉʉ'n³ júu² quia̱'² dsa³ 'i³ rɨ³ŋɨɨn³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma²mɨ³'áa³ 'i'²³ 'e³ mɨ³líi² mɨ³tʉʉ'n³ júu² quia̱'² dsa³, 'e³ quie'²³ jo̱³ ŋóo² 'ñée² yʉʉ'³¹ mo'³ 'e³ i²lʉ́³ quia̱'² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","'E³ la²³ ca²³nʉʉ³, ji̱i̱²³² ñi'² jmɨ²³ñii'³¹ móo² 'e³ ta'n² dsa³ quien³². 'E³ quie'²³ jen³¹ quie'²³ 'ñée² ñi'² 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ŋó²³ 'ñée² 'e³ dxi³quié̱n² dsa³ quien³² 'e³ la²³'nɨɨ'n³¹ 'e³ gáan³ dxíi³ 'e³ 'uu²³te'²³ móo². Qui² ro̱o̱²³ dxí³ tu³'o³ la²³ xi²ñi²te'¹. 'E³ la²³ 'a²³jia'³ ma²³ huǿø³ 'e³ li²³jné²³, 'í² jui³¹ Jesús 'e³ jua'³ dsoo³² je² ta'n² dsa³ quien³². Ŋóo² ñi'² jmɨɨ³. Lǿn³ 'ñée² 'e³ rɨ²³ŋɨ́n³ tu³'o³ 'u². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","'E³ quie'²³ ŋǿn²te'²³ Jesús 'e³ la²³ 'iún² jui³¹ ñi'² jmɨɨ³. 'Lɨ́ɨ³ ca²³lǿn³te'²³. 'E³ jo̱³ bi²³ ca²³yo'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Qui² ŋǿn²te'²³ la²³jɨn³te'²³. 'E³ jo̱³ bi²³ ca²³jue'n² miin²³. 'E³ quie'²³ xe̱'n² jmɨ́ɨ² ca²³lʉ́³ Jesús. Ca²³jua'³: ―Dxa²ra'³ co̱o̱³ 'óo²ra'³. Jné² hua² la³. 'A²³ rɨ³juø'n²³na'³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'E³ quie'²³ jo̱³ 'í² 'e̱'³ móo² je² ta'n² dsa³ quien³². 'E³ jo̱³ ca²³cu²³tá² dxí³. Bi²³ ma²³'nee³ juø'²³ ca²³ti²³cø̱n³¹ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Qui² 'a²³jia'³ ca²³lǿ²³ juø'² ca²³jmóo²te'²³ 'i'²³ 'e³ jmii'³¹ lǿ² 'e³ ca²³jmée³ Jesús 'e³ ca²³la²³ñúun³ 'ɨ²³juɨ². Bi²³ rɨ³laa³ dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ca²³'øn³te'²³ jmɨ²³ñii'³¹. Ca²³dxi²³guín²³te'²³ 'uǿ²³ je² xi̱i̱n³ Genesaret. Ca²³'ñʉ'²te'²³ móo² ji̱i̱'² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Xe̱'n² 'e³ la²³ ca²³'uǿøn²³te'²³ móo², ca²³la²³cuiin²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","I²guín¹te'²³ ca²³la²³dxí² dsa³ 'i³ xen³ la²³ca̱a̱n³. I²jøn²³te'²³ dsa³ 'i³ dsoo'²³² 'i³ 'iún² 'e̱'³ jmoo³. I²jøn²³te'²³ te³ jiaa'³¹ ca²³núu³te'²³ 'e³ ca²³dxóo² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Te³ jiaa'³¹ ca²³dxóo² Jesús, juø'n³ quie'²³ jee²³² juɨɨ³, juø'n³ quie'²³ ranchos, ca²³quiaan³te'²³ dsa³ 'i³ dsoo'²³² jee²³² calles. Ca²³ŋɨ́ɨ³te'²³ mɨ²'áa² quie'² Jesús 'e³ rɨ²³cuǿ²³ júu² 'e³ rɨ²³quiʉ̱'² guoo³te'²³, juø'n³ quie'²³ 'nɨɨ'n³¹ xʉʉ'²³² cuo̱o̱³. 'E³ quie'²³ ca²³'láan³ la²³jɨn³ dsa³ 'i³ dsoo'²³² 'i³ ca²³quiʉ̱'² guoo³ xʉʉ'²³² cuo̱o̱³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","'E³ quie'²³ ca²³ŋɨɨ'n²³ caan²³ Jesús te'²³ dsa³ fariseo quia̱'² ca³dxáan² dsa³ 'e²³ ley 'i³ ca²³dxi²³guín²³ naan³ juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ŋó²³te'²³ 'e³ xen³ dsa³ quien³² Jesús 'i³ ee'³² 'e³ 'lʉʉ'² guoo³. Qui² jua'³ dsa³ 'e³ 'lʉʉ'² guoo³ xi³nu³ 'a²³jia'³ ca³u̱'²te'²³ 'e³ la²³ lǿ² tɨ³² 'i'²³ quiee'³² dsa³ Israel. 'E³ jo̱³ ca²³jua'³ dsa³ fariseo 'e³ 'a²³jia'³ dxʉ́²³ jmoo³² dsa³ quien³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Qui² jmoo³² dsa³ fariseo quia̱'² la²³jɨn³ dsa³ Israel 'e³ la²³ lǿ² tɨ³² 'i'²³ quiee'³² dsa³ jaa²³²: U̱u̱'³²te'²³ guoo³te'²³ ñúun³ taa'² xi³nu³ mɨ³ rɨ²³e'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","'E³ quie'²³ mɨ³rɨ³dxi³guiin³² co̱'³ 'e³ mɨ³i²guín¹te'²³ je² dxa²³ dsa³ 'moo'², lo'²³te'²³ xe̱'n². Jo̱³ tu³ rɨ²³e'²te'²³. 'E³ quie'²³ ñúun³ cɨ² la²³jɨ³ tɨ³² 'i'²³ quiee'³² dsa³ jaa²³² 'e³ jmoo³²te'²³ quí̱i̱n²³. U̱u̱'³²te'²³ tazas. U̱u̱'³²te'²³ mɨ²dsuu². U̱u̱'³²te'²³ mɨ³¹'ia³ ñí². U̱u̱'³²te'²³ ji̱i̱² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","'E³ jo̱³ ca²³jua'³ dsa³ fariseo quia̱'² dsa³ 'e²³ ley. Ca²³sɨ'²³ Jesús: ―¿'Ee² lǿ² 'a²³jia'³ jmoo³² dsa³ quien³²nu³ 'e³ la²³ lǿ² tɨ³² 'i'²³ quiee'³² dsa³ jaa²³²? ¿'Ee² lǿ² ee'³²te'²³ 'e³ 'lʉʉ'² guoo³te'²³? ");
INSERT INTO cnlNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","'E³ jo̱³ ca²³jua'³ Jesús: ―Bi²³ te³ jmee³ra'³ guóo². 'Nee'²³ hua² ca²³'én² Isaías mɨ²jaa²³². La²³la³ cu³lø³¹ ca²³jua'³ 'e³ rɨ²³lí³: Bi²³ jmoo³² 'e³ mi³gáan³ jné² dsa³ la³ 'nɨɨ'n³¹ júu² 'oo²te'¹. 'E³ quie'²³ bi²³ mɨ³la³huɨ̱'n³ dsɨ́²te'²³ quia̱'²te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Te³ li²³ŋɨ́n³ 'e³ mi³gáan³te'²³ jné². Qui² 'nɨɨ'n³¹ júu² 'e³ ca²³dxi³ 'i'²³ dsa³ hua² 'e²³te'²³. La'³ cu³lø³¹ júu² 'e³ ca²³lʉ́³ Isaías. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","'E³ quie'²³ tu³²ra'³ júu² 'e³ ca²³dxi³ 'i'²³ Dios 'e³ la²³'nɨɨ'n³¹ 'e³ bi²³ xe̱'²ra'³ tɨ³² 'i'²³ quiee'³² dsa³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","'E³ quie'²³ jo̱³ ca²³jua'³: ―¿'A² lǿn³na'³ 'e³ bi²³ dxʉ́²³ jmee³ra'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ ma²³ quí̱i̱n²³ júu² 'e³ ca²³dxi³ 'i'²³ Dios 'e³ juo'³ra'³ mi³quí̱i̱n²³na'³ tɨ³² 'i'²³ quien³²na'³? ");
INSERT INTO cnlNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Qui² ca²³jua'³ Moisés: “Rɨ²'óo²ra'³ u²³go³ u²³'iʉʉ²³ quia̱'n²na'³ xoo³ra'³ ñʉ'²ra'³”. Co̱'³ cɨ'²³ ca²³jua'³: “Cu²jú̱n³ quie'²³ dsa³ 'i³ 'ñe'² lʉ²³ 'en³² xóo² jmii³”. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","'E³ quie'²³ juo'³ra'³ 'nee'²³ 'e³ líi² te³ rɨ²³jua'³ dsa³ rɨ²³sɨ'²³ xóo² jmii³: “Nee'²³² guoo³ Dios la²³jɨ³ 'e³ xa³ quián²³ 'e³ rɨ²³lí³ juø'² rɨ²jmeen²³² co̱²juø'¹ quién²na'³ 'u². Qui² rɨ³lø³¹ corbán.” La'³ cu³lø³¹ jua'³te'²³ xi³nu³ xa³ 'e³ nee'²³² guoo³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","La²³nɨ³ cu³lø³¹ 'e³ 'a²³jia'³ cuø³ra'³ júu² 'e³ rɨ²³jmée²³ dsa³ co̱²juø'¹ quie'² xóo² jmii³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jmee³ra'³ 'e³ 'a²³jia'³ ma²³ quí̱i̱n²³ quién²na'³ júu² quiee'³² Dios. Qui² jmee³ra'³ 'e³ bi²³ cɨ² quí̱i̱n²³ tɨ³² 'i'²³ 'e³ 'ee²³ dsa³ jo̱o̱³¹ dxoo²³². Ñúun³ la²³jɨ³ 'e³ lø³² la²³nɨ³ 'e³ jmee³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Co̱'³ cɨ'²³ ca²³tøø³ dsa³ Jesús. Ca²³jua'³: ―'Ne'² rɨ²núu²ra'³ la²³jɨn³na'³. 'Ne'² rɨ²jmée²ra'³ 'i'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","'A²³'e³ xa³ 'e³ ee'³² dsa³ 'e³ rɨ²³lí³ juø'² rɨ²³jmée²³ 'e³ li²³'lʉ'n² dsa³. 'E³ quie'²³ la²³jɨ³ 'e³ sɨ³bǿn³ dsɨ́² dsa³, 'e³ jo̱³ hua² 'e³ jmee²³ 'e³ sɨ³li³'lʉ'n² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","'Ne'² rɨ²³núu²³ dsa³ 'i³ 'née²³ rɨ²³cuǿn²³ miin²³ 'e³ rɨ²³núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ca²³cuaa'n³ dsa³ Jesús. 'Í² xi²ñʉ'¹. 'E³ quie'²³ jo̱³ ca²³ŋɨ́ɨ³ júu² dsa³ quien³² 'e³ jmii'³¹ lǿ² júu² rɨ³jnɨ³ 'e³ ca²³lʉ́³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'A² cu³xi³ 'nee'²³ 'a²³jia'³ ta³jmee³ra'³ 'i'²³? ¿'A² 'a²³jia'³ sɨ³dsaan³²na'³? 'A²³jia'³ rɨ²³lí³ juø'² rɨ²³jmée²³ 'e³ li²³'lʉ'n² dsa³ la²³jɨ³ 'e³ ee'³² dsa³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Qui² 'a²³la³ dsɨ́² dsa³ sɨ³too'³. 'E³ quie'²³ tu'² hua² sɨ³too'³. 'E³ jo̱³ sɨ³ŋɨ́n³. La'³ hua² ca²³jmée³ lii²³ Jesús 'e³ joo'²³ rɨ²quie²ra² la²³jɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","'E³ jo̱³ ca²³jua'³: ―La²³jɨ³ 'e³ sɨ³bǿn³ dsɨ́² dsa³, 'e³ jo̱³ hua² jmee²³ 'e³ sɨ³li³'lʉ'n² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Qui² ñʉ'²³ dsɨ́² dsa³ hua² sɨ³bǿn³ 'e³ jmoo³² dsa³ 'i'²³ 'e³ 'a²³jia'³ dxʉ́²³, 'e³ ta̱a̱'n³ dsa³ miin²³ quia̱'² jia'³ cɨ'²³ mɨ́³, 'e³ jmoo³² dsa³ ñi³ dxa³, 'e³ jmoo³² dsa³ 'móo², ");
INSERT INTO cnlNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","'e³ jmoo³² dsa³ 'i̱i̱³, 'e³ 'iin²³ dsɨ́² dsa³ 'e³ xa³ quie'² uu'n², 'e³ jmoo³² dsa³ 'e³ 'a²³jia'³ dxʉ́²³, 'e³ juun³² dsa³ uu'n², 'e³ jmoo³² dsa³ 'e³ la²³ ŋɨɨ²³ jmɨ² ŋu², 'e³ mɨ'n³ dsa³ 'e³ sɨ³li'²³ uu'n², 'e³ 'ñe'² lʉ²³ dsa³ 'en³² uu'n², 'e³ bi²³ mi³gáan³ miin²³ dsa³, 'e³ 'a²³jia'³ jmoo³² dsa³ 'i'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","La²³nɨ³ cu³lø³¹ la²³jɨ³ 'e³ 'a²³jia'³ dxʉ́²³ 'e³ sɨ³bǿn³ dsɨ́² dsa³. 'E³ jo̱³ hua² jmee²³ 'e³ sɨ³li³'lʉ'n² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","'E³ quie'²³ jo̱³ ca²³bǿn³ Jesús. Ŋóo² 'uǿ²³ je² røøn³ juɨɨ³ Tiro quia̱'² juɨɨ³ Sidón. Núu²³ 'í² xi²ñʉ'¹ quiee'³² dsa³. 'A²³jia'³ 'née²³ 'e³ rɨ²³ñí² dsa³. 'E³ quie'²³ 'a²³jia'³ lǿ²³ juø'² ca²³'mǿn²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Xe̱'n² jmɨ́ɨ² ca²³núu³ jø̱n³ mɨ́³ 'i³ xen³ xii'³ mɨ́³ quien³² 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². Ca²³dxóo² mɨ́³ 'í³. Ca²³quiaa³ rɨ³'in³² xi²ñi² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dsa³ jia'³ hua² mɨ́³ 'í³. Sirofenicia xen³. Ca²³ŋɨ́ɨ³ mɨ²'áa² quie'² Jesús 'e³ rɨ²³dxin³ espíritu quien³² mɨ²³sɨ²³quiʉ'² 'i³ quie̱n³ jo̱o̱³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³ 'í³: ―Xe̱'n² cɨ² 'ne'² rɨ²³e'² te'²³ xii'³ pii'². Qui² 'a²³jia'³ joo'²³ 'e³ rɨ²juén¹ 'ɨ²³juɨ² 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³e'² te'²³ xii'³ pii'² 'e³ cu²e'¹ dsɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","'E³ quie'²³ ca²³jua'³ mɨ́³ 'í³: ―Ma² la'³ xú̱n³, Juiin²³. 'E³ quie'²³ ee'³² mi'³ dsɨɨ³ juɨɨ²³² 'e³ sɨ³jiʉ'² ñʉ'²³ mesa je² ee'³² xii'³ pii'². ");
INSERT INTO cnlNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","'E³ jo̱³ ca²³jua'³ Jesús: ―Bi²³ dxʉ́²³ mɨ³lʉ́n². 'E³ jo̱³ líi² 'e³ guø'n³²nu³. Mɨ³bǿøn²³ ja̱a̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","'E³ jo̱³ ŋø'n² co̱'³ mɨ́³ 'í³. Bi²³ lii'² rɨ³caa'n³² ñi'² ji̱i̱² xii'³ 'e³ la²³ ca²³dxe'n². 'A²³jia'³ ma²³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","'E³ jo̱³ ca²³bǿn³ Jesús 'uǿ²³ je² røøn³ juɨɨ³ Tiro. Ca²³ŋɨ́n³ juɨɨ³ Sidón quia̱'² 'uǿ²³ je² xi̱i̱n³ Guiá²³ Juɨɨ³. Ca²³dxóo² mɨ³lén² la²³ jmɨ²³ñii'³¹ Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","I²jøn²³te'²³ caan²³ 'ñée² Jesús jø̱n³ dsa³ 'i³ guɨɨn²³², 'i³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³lʉ́²³ jɨn³. Ca²³ŋɨ́ɨ³te'²³ mɨ²'áa² quie'² Jesús 'e³ rɨ²³dxá²³ guoo³ ñi'² quiee'³² dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","'E³ jo̱³ ca²³jén²³ dsa³ 'í³ ca³juɨ² ca³jné³ je² co̱³quie'². To̱'² mɨ²xi¹guoo³ too³ lo³guo² dsa³ 'í³. Ca²³'ø'² mɨ²xi¹guoo³. 'E³ quie'²³ jo̱³ ca²³quiʉ̱'² sɨɨ'² dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ca²³jóo² yʉʉ'³¹. Ca²³xáan²³ dsɨ́². 'E³ quie'²³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ guɨɨn²³²: ―Efatá ―ca²³jua'³. Qui² la'³ cu³lø³¹ jua'³te'²³ ju²³jmii²³² quiee'³²te'²³: Cu²né³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","'E³ jo̱³ ca²³nó³ lo³guo² dsa³ 'í³. Ca²³jee'²³ sɨɨ'². Ca²³lʉ́³ jɨn³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","'E³ quie'²³ jo̱³ ca²³dxi³ 'i'²³ Jesús 'e³ 'a²³jia'³ rɨ²³jme'n²te'²³ júu² 'e³ jmii'³¹ mɨ³lǿ²³. 'E³ quie'²³ bi²³ cɨ² ca²³lʉ́³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Qui² bi²³ ma²³'nee³ juø'²³ ca²³ti²³cø̱n³¹te'¹. Ca²³jua'³te'²³: ―Bi²³ dxʉ́²³ la²³jɨ³ 'e³ jmee²³. Sɨ³lí³ mi'³ juø'² jmee²³ 'e³ nuu³ dsa³ guɨɨ²³². Sɨ³lí³ mi'³ juø'² jmee²³ 'e³ lʉ²³ dsa³ coo²³². ");
INSERT INTO cnlNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","La²³ca̱a̱n³ mɨ²jo̱³ bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³ŋɨɨ'n²³ co̱'³ caan²³ Jesús. 'E³ quie'²³ 'a²³'e³ xa³ 'e³ rɨ²³e'²te'²³. 'E³ jo̱³ ca²³tøø³ dsa³ quien³². Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Bi²³ cuu'²³ dsɨn²³ quia̱'n²³²na¹ te'²³ dsa³ 'i³ nee'n²³² la³. Qui² mɨ³tɨ́³ 'nɨ³ jmɨ́ɨ² 'e³ nee'n²³²te'¹ la³ quia̱'²te'²³ jné². 'A²³'e³ ma²³ xa³ 'e³ rɨ²³e'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","'A²³jia'³ li²³bii²³ dsɨn²³ 'e³ rɨ²juøøn³¹ 'e³ rɨ²³sɨ²³guiin³² 'e³ cue̱'²³quie'²³te'²³. Qui² bi²³ juø'² rɨ²³je'n² 'i̱'² quie'²te'²³ 'e³ la²³ ta'n²te'²³ jui³¹. Xen³ 'i³ bi²³ huɨ̱́ɨ̱³ ca²³ja²³guín²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","'E³ quie'²³ jo̱³ ca²³jua'³ dsa³ quien³²: ―¿Jmii'³¹ cu³lø³¹ rɨ²³lí³ juø'² rɨ²jmee²ra² ji̱i̱³ 'ɨ²³juɨ² 'e³ rɨ²³e'² te'²³ dsa³ la³ cu²ne²ra²? Qui² 'a²³'i̱³ xen³ dsa³ 'i³ nee'n²³² mɨ³lén². ");
INSERT INTO cnlNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","'E³ quie'²³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―¿Jo'² 'ɨ²³juɨ² xa³ quién²na'³ ru'³? 'E³ jo̱³ ca²³jua'³te'²³: ―'Nɨɨ'n³¹ guiáa²³ hua² xa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","'E³ quie'²³ jo̱³ ca²³dxi³ 'i'²³ 'e³ rɨ²³gua³ dsa³ 'uǿ²³. So̱'²³ la²³jɨ³ guiáa²³ 'ɨ²³juɨ². Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. 'E³ quie'²³ jo̱³ ca²³xíin². Ca²³cuǿø²³ dsa³ quien³² 'e³ rɨ²³to'²³te'²³ dxóo². 'E³ quie'²³ jo̱³ ca²³to'²³ dxóo² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Co̱'³ cɨ'²³ xen³ jø̱n³ áan²³ jo̱o̱³¹ 'moo'³. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios Jesús. 'E³ quie'²³ jo̱³ ca²³dxi³ 'i'²³ 'e³ rɨ²³to'²³te'²³ dxóo² 'noo³¹ quie'² 'moo'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ca²³e'² sú̱n² dsa³ jo̱o̱²³na²³. Ca²³e'² xi³'lɨ² ca²³cø̱'n²³te'²³. Ca²³dxi²³cua̱a̱'n³te'²³ juɨɨ²³² 'e³ ca²³tø'n². Guiáa²³ mɨɨ'³ dsuu² 'nɨɨ'n³¹ ca²³cø̱'n²³ jmø'n² juɨɨ²³² 'e³ ca²³tø'n². ");
INSERT INTO cnlNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","'E³ quie'²³ xen³ co̱o̱³ quiʉ̱́³ mil dsa³ 'i³ ca²³e'². 'E³ quie'²³ jo̱³ ca²³sɨ'²³ dsa³ 'e³ rɨ²³sɨ²³guiin³² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Xe̱'n² quie'²³ jo̱³ 'í² Jesús 'e̱'³ móo² quia̱'² dsa³ quien³². I²guín¹te'²³ la²³ca̱a̱n³ je² xi̱i̱n³ Dalmanuta. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","'E³ quie'²³ jo̱³ ca²³dxi²³guín²³ dsa³ fariseo. Ca²³sɨ́n²³te'²³ júu² quia̱'²te'²³ Jesús. Ŋɨɨ²³te'²³ 'e³ rɨ²³jmée²³ u²³juø'²³ Jesús 'e³ rɨ²³jmée²³ lii²³ 'e³ xi² 'í³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³ 'i³ cuø²³ ju²³bíi²³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bi²³ ca²³xáan²³ dsɨ́² Jesús. 'E³ jo̱³ ca²³jua'³: ―¿'Ee² lǿ² bi²³ 'née²³ rɨ²³jóo² u²³juø'²³ dsa³ 'i³ xen³ rɨ³nɨ²³? Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³'e³ xa³ u²³juø'²³ 'e³ rɨ²jmeen²³² 'e³ te³ 'née²³ dsa³ 'e³ rɨ²³jóo². ");
INSERT INTO cnlNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","'E³ quie'²³ jo̱³ ca²³cuaa'n³ dsa³ 'í³. 'Í² co̱'³ 'e̱'³ móo². Ŋø'n² co̱'³ joo³¹ i²³'ŋóo² jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","'E³ quie'²³ 'a²³jia'³ ca²³la²³líi²³ dsa³ quien³² 'e³ có̱²³ 'ɨ²³juɨ². Co̱o̱³ qui³ 'ɨ²³juɨ² xa³ 'e³ quie̱³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Rɨ³móo³ra'³ jo̱o̱²³na²³. 'A²³ rɨ³co'³ra'³ xoo'³¹ 'ɨ²³juɨ² quiee'³² dsa³ fariseo. 'E³ quie'²³ la'³ xoo'³¹ 'ɨ²³juɨ² quiee'³² Herodes co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","'E³ jo̱³ ca²³sɨ́n²³ júu² la²³ co̱³quie'² miin²³ dsa³ quien³². Ca²³jua'³te'²³: ―'A²³'e³ xa³ 'ɨ²³juɨ² 'e³ mɨ³quie̱²ra². 'E³ jo̱³ hua² mɨ³jua'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Quii²³ Jesús 'e³ jmii'³¹ cu³lø³¹ júu² 'e³ sɨn²³te'²³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―¿'Ee² lǿ² sɨ́n³na'³ júu² 'e³ 'a²³'e³ xa³ 'ɨ²³juɨ² 'e³ mɨ³quie̱³ra'³? ¿'A² 'a²³jia'³ móo³ra'³? ¿'A² 'a²³jia'³ jmee³ra'³ 'i'²³? ¿'A² bi²³ rɨ³laa³ 'óo²ra'³? ");
INSERT INTO cnlNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Xa³ mɨ²ñí²ra'³. ¿'A² 'a²³jia'³ joo³²ra'³? Xa³ la³guó³ra'³. ¿'A² 'a²³jia'³ nuu³ra'³? ¿'A² 'a²³jia'³ ma²³ liin³²na'³? ");
INSERT INTO cnlNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Qui² ca²³xiin²³²na¹ 'ñé³ 'ɨ²³juɨ². 'E³ jo̱³ ca²³e'² 'ñé³ mil dsóo²³. ¿Jo'² mɨɨ'³ dsuu² ca²³cø̱'n²³ juɨɨ²³² 'e³ ca²³tø'n² 'e³ la²³ ca²³dxi²³cua̱a̱'n²³na'³? 'E³ jo̱³ ca²³jua'³te'²³: ―Gui²³tʉ̱́³ 'nɨɨ'n³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―'E³ quie'²³ la'³, ca²³xiin²³²na¹ guiáa²³ 'ɨ²³juɨ² co̱'³ 'e³ ca²³e'² quiʉ̱́³ mil dsa³. ¿Jo'² mɨɨ'³ dsuu² ca²³cø̱'n²³ juɨɨ²³² 'e³ ca²³tø'n² 'e³ la²³ ca²³dxi²³cua̱a̱'n²³na'³? 'E³ jo̱³ ca²³jua'³te'²³: ―Guiáa²³ 'nɨɨ'n³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―¿'A² 'a²³jia'³ ta³jmee³ra'³ 'i'²³ 'e³ juøøn³²na²³ 'nee'²³ 'e³ 'a²³ rɨ³co'³ra'³ júu² quiee'³² te'²³ dsa³ 'í³? ");
INSERT INTO cnlNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","'E³ quie'²³ jo̱³ ca²³dxi²³guín²³te'²³ juɨɨ³ Betsaida. Xen³ dsa³ 'i³ i²jøn²³ jø̱n³ dsa³ tuu² mɨ²ñi² caan²³ Jesús. Ca²³ŋɨ́ɨ³te'²³ mɨ²'áa² quie'² 'e³ rɨ²³quiu̱u̱'n³ guoo³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","'E³ jo̱³ so̱'²³ guoo³ dsa³ tuu² Jesús. Ca²³jén²³ 'ioo³¹ juɨɨ³. 'E³ quie'²³ jo̱³ ca²³'ø'² mɨ²ñi² dsa³ tuu². Ca²³dxá³ guoo³ ñi'² quiee'³². 'E³ quie'²³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ tuu²: ―¿'A² xa³ 'e³ mɨ³láa²³ jné³ quién²nu³? ");
INSERT INTO cnlNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","'E³ jo̱³ ca²³jóo² dsa³ tuu². Ca²³jua'³: ―Jnén³ dsa³. 'Mo³ hua² lǿn³na²³. 'E³ quie'²³ ŋɨ́³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","'E³ jo̱³ co̱'³ cɨ'²³ ca²³dxá³ guoo³ Jesús ñi'² mɨ²ñi² dsa³ tuu². 'E³ quie'²³ jo̱³ ca²³la²³jnée²³ dxʉ́²³ dsa³ 'í³. 'E³ jo̱³ lɨ́ɨn² dsa³ 'í³. Bi²³ jɨn³ ca²³la²³jné³ la²³jɨ³ quie'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ca²³sɨ'²³ dsa³ 'í³ 'e³ cu²dxe'n³. ―'A²³ rɨ³guáan³ jee²³² juɨɨ³. 'A²³ cɨ'²³ 'e³ rɨ²juɨɨ'n³¹ dsa³ 'i³ xen³ núu²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","'E³ quie'²³ jo̱³ ca²³bǿn³ Jesús quia̱'² dsa³ quien³². Ŋóo² la²³ca̱a̱n³ juɨɨ³ je² røøn³ Cesarea de Filipo. 'E³ la²³ ta'n²te'²³ jui³¹, ca²³ŋɨ'²³ júu² dsa³ quien³². Ca²³jua'³: ―¿'I̱i̱² sɨɨ'³¹ jné², jua'³ dsa³ 'en³²te'²³ jné²? ");
INSERT INTO cnlNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","'E³ jo̱³ ca²³jua'³te'²³: ―Xen³ 'i³ jua'³ 'e³ Juan 'i³ ca²³xáan² dsa³ jmɨɨ³ hua² 'nʉ³. 'E³ quie'²³ xen³ 'i³ jua'³ Elías co̱'³. 'E³ quie'²³ xen³ 'i³ jua'³ 'e³ rɨ³løn³¹nu³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―¿'E³ quie'²³ 'i̱i̱² sɨɨ'³¹ jné², juo'³ra'³ 'nee'²³? 'E³ jo̱³ ca²³jua'³ Peen²³²: ―Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios hua² 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","'E³ quie'²³ ca²³dxi³ 'i'²³ 'e³ 'a²³jia'³ 'ne'² rɨ²³sɨ'²³te'²³ dsa³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mɨ²jo̱³ ca²³tín²³ ca²³'ée²³ dsa³ quien³² 'e³ ñúun³ la²³jɨ³ 'e³ li²³'ne'² rɨ²³ji̱'²³ 'ñée² Jo̱o̱³¹ Dsa³. Rɨ²³tʉ́ʉ² te'²³ dsa³ mɨ³dxún²³ quie'² 'ñée² quia̱'² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley. Rɨ²³jŋɨ'n²³te'²³. 'E³ quie'²³ rɨ²³ji̱i̱'²³ co̱'³ je² rɨ²³tɨ́²³ 'nɨ³ jmɨ́ɨ² 'e³ la²³ jú̱n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jɨn³ ca²³jmée³ júu² 'e³ jmii'³¹ rɨ²³ji̱'²³. 'E³ jo̱³ ca²³jáa²³ Peen²³² 'e³ ca²³jén²³ ca³juɨ² ca³jné³. Ca²³jín² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","'E³ quie'²³ jo̱³ ca²³ji̱i̱n²³ Jesús. Ca²³jóon² dsa³ quien³². 'E³ jo̱³ ca²³jín² Peen²³². Ca²³jua'³: ―Je̱'n². Qui² lʉ́n² 'e³ la²³ 'née²³ Satanás. 'A²³jia'³ rɨ³løn³¹nu³ co̱o̱³ júu² quia̱'n²nu³ Dios. 'E³ quie'²³ rɨ³løn³¹nu³ co̱o̱³ júu² quia̱'n²nu³ dsa³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","'E³ jo̱³ ca²³tøø³ la²³jɨn³ dsa³ ca³ti³² quia̱'² dsa³ quien³². Ca²³jua'³: ―'A²³jia'³ ma²³ joo'²³ rɨ²³jmée²³ 'e³ la²³ 'née²³ 'ñée² dsa³ 'i³ 'née²³ rɨ²³qui̱'³ jné². 'Ne'² rɨ²³cuǿn²³ 'ñée² 'e³ rɨ²³dxi²³quié̱n² 'e³ la²³ dxi³quié̱n² dsa³ 'i³ ta̱a̱n²³ cruz. 'Ne'² rɨ²³ŋɨ́²³ quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Qui² rɨ²³gua'²³ dsa³ 'i³ bi²³ cɨ² mi³quí̱i̱n²³ 'e³ xen³ mɨ³¹güii³ la³. 'E³ quie'²³ rɨ²³láan³ dsa³ 'i³ rɨ²³cuǿn²³ 'ñée² 'e³ rɨ²³jú̱n³ 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³, 'e³ jua'³ sɨ³táan³ júu² dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","'A²³'e³ cua̱a̱n²tu² xa³ quie'² dsa³ 'i³ rɨ²³'ióo²³ la²³jɨ³ sú̱n² 'e³ xa³ mɨ³¹güii³ la³ xi³nu³ rɨ²³gua'²³ dsɨ́². ");
INSERT INTO cnlNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Qui² 'a²³'e³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²³cuǿ²³ dsa³ 'e³ jua'³ rɨ²³ti'n²³ co̱'³ dsɨ́² 'e³ mɨ³guoo'³². ");
INSERT INTO cnlNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jné² Jo̱o̱³¹ Dsa³ li²³'ii'n²³na²³ dsa³ 'i³ 'ii'n²³ jné², 'i³ 'ii'²³ quia̱'² júu² quián²³ 'e³ la²³ nee'n²³²te'¹ jee²³² quiee'³² dsa³ 'i³ xen³ rɨ³nɨ²³ 'i³ bi²³ jmoo³² tu³cua̱a̱n²tu², 'i³ jmoo³² 'e³ xa³ dsoo² quiee'³². Li²³'ii'n²³na²³ dsa³ 'í³ mɨ³rɨ³güe'n²³na²³ co̱'³ quia̱'n²³²na¹ te'²³ ángeles 'i³ bi²³ rɨ³jɨ́n², mɨ³li³gáan³na²³ la²³ gáan³ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Co̱'³ cɨ'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xen³ dsa³ 'i³ té̱e̱n³ je² la³ rɨ³nɨ²³ 'i³ rɨ²³jóo² jén²³ cɨ² 'e³ la²³ rɨ²³jú̱n³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'uee'n³ Dios 'e³ la²³ rɨ³løn³¹ juii² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ma²ca¹ŋɨ́n³ jñʉ́ʉ³ jmɨ́ɨ², ŋóo² yʉʉ'³¹ mo'³ jɨ̱ɨ̱n²³² Jesús. Ca²³jén²³ Peen²³² quia̱'² Jacobo quia̱'² Juan. Ŋóo² quia̱'² te'²³ dsa³ 'í³. Je² núu²³ ca²³guø'n³ 'e³ la²³ lǿn²³ 'ñée² je² joo³² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ca²³lǿ²³ rɨ³jii'³¹ cuo̱o̱³. Ca²³lǿ²³ taa³ la²³ taa³ dsɨ́² güi'³. 'A²³'i̱³ xen³ dsa³ mɨ³¹güii³ 'i³ u̱u̱'³² 'mɨɨ'³ 'i³ rɨ²³lí³ juø'² rɨ²³jmée²³ 'e³ li²³taa³ 'mɨɨ'³ la²³'nɨɨ'n³¹ taa³ ca²³lǿ²³ cuo̱o̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ŋǿn²te'²³ Elías quia̱'² Moisés. Ta'n² mi³róo³te'²³ quia̱'²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","'E³ jo̱³ ca²³jua'³ Peen²³². Ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³, bi²³ dxʉ́²³ 'e³ nee'²³²ra'³¹ je² la³. Dxʉ́²³ 'e³ rɨ²jmee²ra'³¹ 'nɨ³ mɨɨ³¹ mɨ²'ñʉ́¹ pii'². Rɨ²jmee²ra'³¹ co̱o̱³ 'e³ quien³²nu³, co̱o̱³ 'e³ quiee'³² Moisés, co̱o̱³ 'e³ quiee'³² Elías co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Bi²³ ma²³'nee³ juøø'n²³ dsa³ quien³². 'A²³jia'³ ñi³² Peen²³² 'e³ jmii'³¹ cu³lø³¹ júu² 'e³ dxi³ji̱i̱n³¹ rɨ²³lʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","'E³ quie'²³ jo̱³ jó² co̱o̱³ jníi² 'e³ ca²³éen³te'²³. Xen³ 'i³ ca²³lʉ́³ jí̱i̱n² jee²³² jníi². Ca²³jua'³: ―'I³ la³ ja̱a̱n²³ 'i³ bi²³ 'náan²³na²³. Rɨ²núu²ra'³ la²³jɨ³ júu² 'e³ lʉ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","'E³ la²³ joo³²te'²³ la²³cu'² je² nee'n²³²te'¹, co̱'³ la²³ ŋó²³te'²³ 'e³ 'a²³'i̱³ ma²³ xen³ cɨ² 'i³ quia̱'²te'²³. Jø̱n³ Jesús cɨ² té̱e̱n³te'²³ quia̱'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","'E³ quie'²³ jo̱³ ca²³jiaan³²te'²³ yʉʉ'³¹ mo'³. 'E³ la²³ ta'n²te'²³ jui³¹ 'e³ sɨ³jiaan³²te'²³, ca²³lʉ́³ Jesús. Ca²³dxi³ 'i'²³ 'e³ 'a²³jia'³ 'ne'² 'e³ rɨ²³sɨ'²³te'²³ dsa³ 'e³ jmii'³¹ cu³lø³¹ 'e³ ŋó²³te'²³. Ca²³dxi³ 'i'²³ 'e³ 'a²³jia'³ rɨ²³jmóo²te'²³ júu² la²³huø'n²³ 'e³ 'íi² rɨ²³ji̱i̱'²³ co̱'³ 'ñée² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","'E³ jo̱³ 'a²³jia'³ ca²³jmóo²te'²³ júu². 'E³ quie'²³ ca²³xín³ ca²³'ín³te'²³ 'e³ 'ee² lǿ² ca²³jua'³ 'e³ rɨ²³ji̱i̱'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―¿'Ee² lǿ² jua'³ te'²³ dsa³ 'e²³ ley 'e³ 'ne'² 'e³ rɨ²³güe'n²³ co̱'³ Elías 'e³ 'íi² cɨ² rɨ²³güén³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³güén³? ");
INSERT INTO cnlNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","'E³ jo̱³ ca²³jua'³ Jesús: ―'E̱'n³ quie'²³ dsɨ́² rɨ³lø³¹ 'i'²³ 'e³ jén²³ cɨ² rɨ²³güe'n²³ Elías 'e³ rɨ²³jmée²³ dxʉ́²³ co̱'³ la²³jɨ³. 'E³ quie'²³, ¿jmii'³¹ jua'³ júu² quiee'³² Dios 'en³² jné² Jo̱o̱³¹ Dsa³? Jua'³ 'e³ 'e³ cɨ² rɨ²³dxi²³quié̱n²na²³, ¿mɨ³naa'³¹? Jua'³ 'e³ 'a²³jia'³ rɨ²³mi²³quí̱i̱n²³te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","'E³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ güe'n² co̱'³ Elías. Ca²³jme'²³te'²³ 'e³ la²³'nɨɨ'n³¹ 'née²³te'²³, 'e³ la²³ lǿ² jua'³ júu² quiee'³² Dios 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³ji̱'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Cɨ̱ɨ̱n³ cɨ² ca²³dxi²³guín²³te'²³ je² ta'n²cɨ²te'¹ dsa³ quien³² Jesús. Ŋó²³te'²³ 'e³ bi²³ juɨ́ɨn²³ dsa³ 'i³ té̱e̱n³ la²³cu'². Co̱'³ cɨ'²³ xen³ dsa³ 'e²³ ley 'i³ sɨn²³ júu² quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Juø'²³ ca²³ti²³cø̱n³¹ la²³jɨn³ dsa³ 'e³ la²³ ŋǿn²te'²³ 'ñée² Jesús. Ca²³ta'n²³te'²³ jui³¹ ca²³la²³dxí² 'e³ jua'³ rɨ²³cuǿ²³te'²³ u²³juee'n³¹ quia̱'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","'E³ quie'²³ jo̱³ ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ 'e²³ ley: ―¿'Ee² júu² sɨ́n³na'³ quia̱'n²na'³ dsa³ quién²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'E³ jo̱³ ca²³jua'³ jø̱n³ dsa³ 'i³ xi'n²³ je² núu²³: ―Dsa³ 'e²³, mɨ³gui³jøn²³na²³ ja̱a̱n²³ caan²³nu³. Qui² quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². Jmee²³ espíritu 'í³ 'e³ caan²³² xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Te³ jiaa'³¹ 'iún² xii'³, sø̱'n³². Juen³² 'uǿ²³. Sɨ³'uøø³ jo̱³ 'oo², cuu'³ jo̱². 'E³ jo̱³ bi²³ sɨ³'uaa'n²³ xii'³. Mɨ³juǿøn² dsa³ quien³²nu³ 'e³ rɨ²³dxin³te'²³ espíritu 'í³ 'u². 'E³ quie'²³ 'a²³jia'³ ca³lǿ²³ juø'². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","'E³ jo̱³ ca²³jua'³ Jesús: ―Bi²³ 'a²³jia'³ sɨ³táan³na'³ quia̱'n²na'³ jné². ¿Lɨɨ'³¹ cɨ² huø'n²³ 'e³ 'ne'² 'e³ quia̱'n²³²na¹ 'nee'²³? ¿Lɨɨ'³¹ cɨ² huø'n²³ 'e³ 'ne'² rɨ²³táan²³ 'e³ la²³'nɨɨ'n³¹ jmee³ra'³? Cu³jén²³na'³ la³ xii'³ rɨ²ne²ra². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","'E³ quie'²³ jo̱³ i²jen³te'²³ xii'³. Ma²ŋøn³¹ Jesús espíritu quien³² mɨ²³sɨ²³quiʉ'², ca²³jmée³ 'e³ ca²³je'n² quie'² xii'³. Ca²³'lǿn²³ 'uǿ²³. Ca²³ba'n²³ ca²³jna'n²³. Ca²³'ia³ jo̱³ 'oo². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ jmii³ xii'³: ―¿Mɨ²lɨɨ'³¹ 'e³ sɨ³ji̱'²³ la'³ nɨ³? 'E³ jo̱³ ca²³jua'³ jmii³: ―Cɨ'²³ pi'n². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mɨ³la³ñúun³ taa'² 'e³ jmee²³ 'e³ sɨ³'lǿn²³ dxi³¹ji³. Xa³ ma²sɨ³'lǿn²³ 'e̱'³ jmɨɨ³. Qui² 'née²³ 'e³ rɨ²³jŋɨ'n²³ xii'³. Cu²li³cuu'²³ 'áan² quia̱'n²nu³ jnee'³¹ xi³nu³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²jméen². Rɨ²jméen² co̱²juø'¹ quiée²ra'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―¿Jmii'³¹ lǿ² 'e³ juø'n³: “Xi³nu³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²jméen²”? La²³jɨ³ quie'²³ sɨ³lí³ juø'² quie'² dsa³ 'i³ sɨ³táan³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","'E³ jo̱³ quiʉ̱ʉ̱³ ca²³lʉ́³ jmii³ xii'³. Ca²³jua'³: ―Sɨ³táan³na²³ 'u². Rɨ²jméen² co̱²juø'¹ quián²³ 'e³ bi²³ cɨ² rɨ²³sɨ²³táan³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ŋó²³ Jesús 'e³ juɨ́ɨn²³ dsa³ 'i³ sɨ³ñii'n²³. 'E³ jo̱³ ca²³jín² espíritu quien³² mɨ²³sɨ²³quiʉ'². Ca²³jua'³: ―Espíritu 'i³ jmee²³ 'e³ caan²³², 'e³ guɨɨn²³², dxin²³ 'i'²³ 'e³ cu²bǿn³nu³. Tʉn²³ xii'³ nɨ³. 'A²³ ma²³ rɨ³'íin³nu³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","'E³ quie'²³ jo̱³ ca²³yo'³ espíritu quien³² mɨ²³sɨ²³quiʉ'². Ca²³jmée³ 'e³ ca²³je'n² co̱'³ quie'² xii'³. 'E³ quie'²³ jo̱³ ca²³bǿn³. 'Lɨ́ɨ³ la²³ cɨ² xii'³ ma²mɨ³tʉ́n². 'E³ jo̱³ juɨ́ɨn²³ dsa³ 'i³ ca²³jua'³ 'e³ mɨ³jú̱n²³ xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","'E³ quie'²³ so̱'²³ Jesús guoo³ xii'³. Ca²³xa'n². 'E³ jo̱³ ca²³naa'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","'Í² Jesús xi²ñʉ'¹. Ca³jné³ ca²³tín²³ júu² dsa³ quien³². Ca²³jua'³te'²³: ―¿'Ee² lǿ² 'a²³jia'³ ca³lǿ²³ juø'² mɨ³dxin²³²na'³¹ espíritu 'í³ cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'Ne'² rɨ²lʉ²ra² quia̱'n²na² Dios. 'Ne'² rɨ²jmee²ra² mɨ²³jmɨɨ²³. 'Nɨɨ'n³¹ la'³ hua² 'e³ rɨ²³lí³ juø'² rɨ²'uøøn²³²na² espíritus quien³² mɨ²³sɨ²³quiʉ'² 'i³ lǿn²³ la²³nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ma²ca¹'uǿøn¹te'²³ je² núu²³, ca²³ŋɨ́n³te'²³ estado Galilea. 'E³ quie'²³ 'a²³jia'³ 'née²³ Jesús 'e³ rɨ²³dsóo²³ dsɨ́² dsa³ 'e³ sɨ³ŋɨ́n³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Qui² 'ee²³ dsa³ quien³². Jua'³ 'e³ cɨ² rɨ²³dxén²te'²³ guoo³ dsa³ mɨ³¹güii³ 'ñée² Jo̱o̱³¹ Dsa³. Jua'³ 'e³ cɨ² rɨ²³jŋɨ'n²³te'²³. Jua'³ 'e³ rɨ²³ji̱i̱'²³ co̱'³ je² rɨ²³tɨ́²³ 'nɨ³ jmɨ́ɨ² 'e³ la²³ rɨ²³jú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","'E³ quie'²³ 'a²³jia'³ ca²³dsaan³²te'²³ júu² 'e³ ca²³lʉ́³. 'A²³ cɨ'²³ 'e³ ca²³la²³bii²³ dsɨ́²te'²³ 'e³ rɨ²³ŋɨ'²³te'²³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","'E³ quie'²³ jo̱³ ca²³dxi²³guiin³²te'²³ co̱'³ juɨɨ³ Capernaum. Ma²ca¹dxe'n¹ co̱'³ xi²ñʉ'¹ Jesús, ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―¿'Ee² júu² 'e³ mɨ³xín³na'³ 'e³ la²³ ta'²ra² jui³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","'E³ quie'²³ 'a²³jia'³ ca²³'í̱n²te'²³. Qui² ca²³sɨ́n²³te'²³ júu² 'e³ la²³ ta'n²te'²³ jui³¹ 'e³ 'i̱i̱² sɨɨ'³¹ miin²³ 'i³ gáan³ cɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","'E³ jo̱³ ca²³gua³ Jesús. Ca²³tøø³ dsa³ gui²³tʉ̱́n³ quien³². Ca²³jua'³: ―Xi³nu³ xen³ 'i³ 'née²³ rɨ²³lín³ 'i³ gáan³ cɨ², 'ne'² rɨ²³lín³ 'i³ pii'² cɨ² jee²³² quiee'³² la²³jɨn³ uu'n². 'Ne'² rɨ²³lín³ mozo 'i³ rɨ²³mi²³quin³ la²³jɨn³ uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","'E³ quie'²³ jo̱³ ca²³jén²³ jø̱n³ xii'³ pii'². Ca²³dxén² jee²³² je² nee'n²³²te'¹. Ca²³ta̱a̱'n³ cuáa². Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―'Ii'n³² jné² dsa³ 'i³ 'ii'n³² jø̱n³ xii'³ pii'² 'i³ lǿn²³ la²³ lǿn²³ 'i³ la³ 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³. 'E³ quie'²³ 'a²³la³ 'nɨɨ'n³¹ jné² 'i³ 'ii'n³². 'Ii'n³² 'ñée² 'i³ ca²³xíin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","'E³ quie'²³ ca²³jua'³ Juan. Ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³, ca²³nen²³²na'³¹ jø̱n³ dsa³ 'i³ 'uøøn³ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'e³ jua'³ 'ñée² 'e³ rɨ³løn³¹ dsa³ quien³²nu³. 'E³ quie'²³ ca²³xii'³¹ra'³¹ 'e³ 'a²³jia'³ ma²³ rɨ²³jmée²³ la'³. Qui² 'a²³jia'³ ŋɨ́³ quia̱'² jne². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","'E³ quie'²³ ca²³jua'³ Jesús: ―'A²³ ma²³ rɨ³juɨɨ'³²ra'³ dsa³ 'í³ 'e³ 'a²³jia'³ ma²³ rɨ²³jmée²³ la'³. Qui² 'a²³jia'³ jmɨ́ɨ² rɨ²³lí³ juø'² rɨ²³lʉ́²³ 'ñe'² rɨ²³'én² jné² dsa³ 'i³ jmee²³ u²³juø'²³ 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Rɨ³løn³¹ co̱o̱³ júu² quia̱'² jne² dsa³ 'i³ 'a²³jia'³ nɨ́ɨn³ quia̱'² jne². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ca³quie̱e̱² rɨ²³'ióo²³ jñiin²³ la²³jɨn³ dsa³ 'i³ xa³ 'e³ rɨ²³cuǿø²³ 'nee'²³, juø'n³ quie'²³ co̱o̱³ vaso jmɨɨ³, 'e³ jua'³ rɨ³løn³¹ 'ñée² dsa³ quién²³na²³, 'e³ jua'³ rɨ³løn³¹na'³ dsa³ quién²³na²³ jné² Cristo. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’'A²³jia'³ dxʉ́²³ quie'² dsa³ 'i³ jmee²³ 'e³ la²³ rɨ²³'lǿn²³ jø̱n³ 'i³ pii'² 'i³ sɨ³táan³ quia̱'² jné² 'i³ xen³ la²³ xen³ xii'³ pii'² la³. Bi²³ cɨ² dxʉ́²³ quie'² 'ñée² 'u² cu²ru'³ rɨ²³dxóo²te'²³ lúu² co̱o̱³ too²³ bee'², 'e³ rɨ²³juén²te'²³ 'e̱'³ jmɨ²³ñii'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Xi³nu³ jmee²³ guoo³²ra'³ 'e³ la²³ rɨ²³'lǿn²³na'³, bi²³ cɨ² dxʉ́²³ tʉn²³²na'³ guoo³²ra'³. Qui² bi²³ cɨ² dxʉ́²³ 'e³ cu³guiin³²na'³ je² rɨ³ji̱'²³ dsa³ ca³quie̱e̱² 'e³ tʉ̱ʉ̱'² co̱o̱³ guoo³²ra'³ la²³ cɨ'²³ 'e³ dxi²³² quie'²³ tú̱²³ guoo³²ra'³ 'e³ cu³guín²³na'³ guiáa²³ juɨ́ɨ² je² 'a²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Je² núu²³ 'a²³jia'³ jmɨ́ɨ² rɨ²³jú̱n³ joo'² 'i³ ta'n² je² sɨ³jiee'n³ dsa³. 'A²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","'E³ quie'²³ la'³ xi³nu³ jmee²³ tɨɨ³¹ra'³ 'e³ la²³ rɨ²³'lǿn²³na'³, bi²³ cɨ² dxʉ́²³ tʉn²³²na'³ tɨɨ³¹ra'³. Qui² bi²³ cɨ² dxʉ́²³ 'e³ cu³guiin³²na'³ je² rɨ³ji̱'²³ dsa³ ca³quie̱e̱² 'e³ tʉ̱ʉ̱'² co̱o̱³ tɨɨ³¹ra'³ la²³ cɨ'²³ 'e³ dxi²³² quie'²³ tú̱²³ tɨɨ³¹ra'³ 'e³ rɨ²³juén²te'²³ 'nee'²³ guiáa²³ juɨ́ɨ² je² 'a²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Je² núu²³ 'a²³jia'³ jmɨ́ɨ² rɨ²³jú̱n³ joo'² 'i³ ta'n² je² sɨ³jiee'n³ dsa³. 'A²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","'E³ quie'²³ la'³ xi³nu³ jmee²³ mɨ²ñí²ra'³ 'e³ la²³ rɨ²³'lǿn²³na'³, bi²³ cɨ² dxʉ́²³ dxi²ra'³ jo̱o̱²³na²³. Qui² bi²³ cɨ² dxʉ́²³ 'e³ cu³guiin³²na'³ je² rɨ³løn³¹ Dios juii² 'e³ dxi²³² co̱o̱³ mɨɨ³¹ mɨ²ñí²ra'³ la²³ cɨ'²³ 'e³ dxi²³² quie'²³ tú̱²³ mɨɨ³¹ 'e³ rɨ²³juén²te'²³ 'nee'²³ guiáa²³ juɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Je² núu²³ 'a²³jia'³ jmɨ́ɨ² rɨ²³jú̱n³ joo'² 'i³ ta'n² je² sɨ³jiee'n³ dsa³. 'A²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’'E³ cɨ² rɨ²³dxi²³quié̱n² la²³jɨn³ dsa³ 'e³ la²³ dxi³quié̱n² dsa³ 'i³ sɨ³cáan²³ dxi³¹ji³. 'E³ jo̱³ hua² 'e³ li²³dxʉ́²³ cɨ² dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Bi²³ dxʉ́²³ juɨ² ñi². 'E³ quie'²³ 'a²³jia'³ ma²³ rɨ²³lí³ juø'² rɨ²³jmée²³ dsa³ 'e³ li²³ñii²³² co̱'³ xi³nu³ mɨ³lǿ²³ 'e³ 'a²³jia'³ ma²³ ñii²³², ¿mɨ³naa'³¹? 'Ne'² li²³dxʉ́²³ 'óo²ra'³ 'e³ la²³ sɨ³li³dxʉ́²³ mó² mɨ³rɨ³to'²³ dsa³ juɨ² ñi². 'Ne'² rɨ²lʉ́²ra'³ co̱o̱³ júu² quia̱'n²na'³ uu'n²na'³ i²³la³ i²³nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ca²³bǿn³ Jesús juɨɨ³ Capernaum. Ŋóo² la²³ca̱a̱n³ estado Judea quia̱'² joo³¹ i²³'ŋóo² la²³ jmɨɨ³ juee'³ Jordán. Je² núu²³ ca²³ŋɨɨ'n²³ dsa³ co̱'³ caan²³ Jesús. Ca²³'ée²³ dsa³ co̱'³ 'e³ la²³ to̱'²³ jmee²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","'E³ quie'²³ jo̱³ ca²³lǿn²³ mɨ³lén² dsa³ fariseo. 'Née²³te'²³ rɨ²³jáan²³te'²³ júu² quiee'³² Jesús. 'E³ jo̱³ ca²³ŋɨ́ɨ³te'²³ júu². Ca²³jua'³te'²³: ―¿Jmii'³¹ juø'n³ 'nʉ³? ¿'A² joo'²³ rɨ²³tʉ́n² dsa³ mɨ²³quie'²? ");
INSERT INTO cnlNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ fariseo: ―¿Jmii'³¹ cu³lø³¹ 'e³ ca²³dxi³ 'i'²³ quién²na'³ Moisés? ");
INSERT INTO cnlNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","'E³ jo̱³ ca²³jua'³ dsa³ fariseo: ―Ca²³cuǿ³ júu² Moisés, ¿mɨ³naa'³¹?, 'e³ rɨ²³xa'n² dsa³ ji³ 'e³ jua'³ tʉn³² mɨ²³quie'². La'³ cu³lø³¹ rɨ²³jmée²³ 'e³ cu²bǿn³ mɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ fariseo: ―Bi²³ rɨ³laa³ 'óo²ra'³. 'E³ jo̱³ hua² 'e³ ca²³té̱e̱² ji³ júu² jo̱³ Moisés. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","'E³ quie'²³ “ca²³jmén² dsa³ Dios, dsóo²³ quia̱'² mɨ́³”. La'³ cu³lø³¹ ca²³jmée³ ma²ca¹jmée³ mɨ³¹güii³ mɨ²xe̱'n³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“'E³ jo̱³ hua² cuaa'n³ dsa³ xóo² jmii³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Sɨ³lí³ 'e³ rɨ³sø̱'n² quia̱'² mɨ²³quie'². Áan²³ dsa³ sɨ³lín³ 'é̱e̱² 'e³ jø̱n³ dsa³.” 'E³ jo̱³ 'a²³jia'³ ma²³ rɨ³løn³¹te'¹ áan²³. 'E³ quie'²³ rɨ³løn³¹ 'é̱e̱² 'e³ jø̱n³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Dios 'i³ ca²³jmée³ 'e³ rɨ³sø̱'n²te'²³. 'E³ jo̱³ 'a²³jia'³ joo'²³ 'e³ rɨ²³dxáan² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ma²ca¹ta'n¹te'²³ xi²ñʉ'¹, ca²³ŋɨ́ɨ³ júu² jo̱³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","'E³ jo̱³ ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ quien³²: ―Jmee²³ ñi³ dxa³ dsóo²³ 'i³ tʉn³² mɨ²³quie'² xi³nu³ rɨ²³tǿø²³ jia'³ cɨ'²³ mɨ́³. Jaa³² ŋɨɨn³² mɨ́³ 'i³ tǿø² xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","'E³ quie'²³ la'³, jmee²³ ñi³ dxa³ mɨ́³ 'i³ tʉn³² dsóo²³ quien³² xi³nu³ rɨ²³tǿø²³ jia'³ cɨ'²³ dsóo²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","'E³ quie'²³ i²jøn²³te'²³ xii'³ pii'² caan²³ Jesús. Qui² 'née²³te'²³ 'e³ rɨ²³quiu̱u̱'n³ guoo³. 'E³ quie'²³ ca²³jíi² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","'E³ jo̱³ ca²³ti̱'n³ Jesús ma²ŋo²³² 'e³ jii³² dsa³ quien³². 'E³ jo̱³ ca²³jua'³: ―Cu²ja³guín²³ caan²³na²³ te'²³ xii'³ pii'². 'A²³ rɨ³jníin²na'³ jui³¹ quie'²te'²³. Qui² rɨ³løn³¹ Dios juii² dsa³ 'i³ xen³ la²³ xen³ xii'³ pii'². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³jia'³ rɨ²³lín³ Dios juii² dsa³ 'i³ 'a²³jia'³ sɨ³táan³ quia̱'² Dios 'e³ la²³ sɨ³táan³ xii'³ pii'² quia̱'² xóo² jmii³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","'E³ quie'²³ jo̱³ ca²³ta̱a̱'n³ cuáa² xii'³ pii'². Ca²³dxá³ guoo³ ñi'² quiee'³²te'²³. Ca²³mi²³jé̱e̱n². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","'E³ la²³ 'í² jui³¹ co̱'³ Jesús, ŋóo² ca²³la²³dxí² caan²³ Jesús jø̱n³ dsa³. Ca²³xii'³ jñi² xi²ñi² Jesús. Ca²³jua'³: ―Dsa³ 'e²³ 'i³ dxún²³, ¿jmii'³¹ 'ne'² rɨ²jmeen²³² 'e³ la²³ rɨ³ji̱'n²³na²³ ca³cuaa³? ");
INSERT INTO cnlNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'Ee² lǿ² juɨɨ'n³²nu³ jné² 'i³ dxún²³? Jø̱n³ Dios hua² 'i³ dxún²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Máan³ 'nʉ³ 'e³ jmii'³¹ cu³lø³¹ júu² 'e³ dxi³ 'i'²³ Dios, ¿mɨ³naa'³¹?: “'A²³ rɨ³jmee³ra'³ ñi³ dxa³. 'A²³ rɨ³jmee³ra'³ 'móo². 'A²³ rɨ³jmee³ra'³ 'i̱i̱³. 'A²³ rɨ³júu²ra'³ mɨ³rɨ³lin³na'³ dsa³ ñi³. 'A²³ rɨ³juun²³²na'³ uu'n²na'³. 'Aa²ra'³ u²³go³ u²³'iʉʉ²³ quia̱'n²na'³ xoo³ra'³ ñʉ'²ra'³.” ");
INSERT INTO cnlNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","'E³ jo̱³ ca²³jua'³ dsa³ 'í³: ―Dsa³ 'e²³, jmeen²³ la²³jɨ³ 'e³ lø³² la²³nɨ³ cɨ'²³ la²³ pi'n²³²na¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ca²³jóon² dsa³ 'í³ Jesús. 'E³ jo̱³ bi²³ ca²³la²³'néen². Ca²³jua'³: ―Co̱o̱³ cɨ² xa³ 'e³ 'íi² quién²nu³. Guaan³². Cu³'nɨ́ɨn² la²³jɨ³ 'e³ xa³ quién²nu³. Jñii³¹ 'e³ jo̱³ rɨ²cuøøn³¹ dsa³ taan³. 'E³ jo̱³ hua² ñúun³ 'e³ quí̱i̱n²³ ca³quie̱e̱² li²³xa³ quién²nu³ yʉʉ'³¹ güii³. Ñe³ quia̱'n²nu³ jné². 'Ne'² rɨ²cuǿn¹nu³ 'uǿøn²nu³ 'e³ rɨ²³dxi²³quié̱n²nu³ 'e³ la²³ dxi³quié̱n² dsa³ 'i³ ta̱a̱n²³ cruz. Rɨ²ŋɨ́n² quia̱'n²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ma²ca¹núu³ dsa³ 'í³ 'e³ la²³ ca²³jua'³ Jesús, bi²³ ca²³la²³dxuun³ ñi². Bi²³ ŋɨ́³ dsɨ́² 'e³ ŋø'n² quie'². Qui² bi²³ ñúun³ la²³jɨ³ 'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","'E³ quie'²³ jo̱³ ca²³jóo² Jesús la²³cu'². Ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―Bi²³ gáan³ dxíi³ 'e³ rɨ²³lín³ Dios juii² dsa³ xoo³². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bi²³ juø'²³ ca²³núu³ dsa³ quien³² júu² quiee'³². 'E³ quie'²³ ca²³lʉ́³ co̱'³ Jesús. Ca²³jua'³: ―Te'²³ xii'³, bi²³ gáan³ dxíi³ 'e³ rɨ²³lín³ Dios juii² dsa³ 'i³ xa̱a̱'n³ dsɨ́² la²³jɨ³ 'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","'A²³jia'³ juo²³ rɨ²³ŋɨ́n³ roo'³² camello guo² me²³cuu². 'E³ quie'²³ bi²³ cɨ² 'a²³jia'³ juo²³ rɨ²³lín³ Dios juii² dsa³ xoo³². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bi²³ ma²³'nee³ juø'²³ ca²³núu³te'²³ jo̱o̱²³na²³. 'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ uu'n²te'²³: ―¿'I̱i̱² sɨɨ'³¹ 'i³ rɨ²³lí³ juø'² rɨ²³láan³ jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ca²³jóon² dsa³ quien³² Jesús. Ca²³jua'³: ―'A²³jia'³ jmɨ́ɨ² rɨ²³lí³ juø'² rɨ²³jmée²³ la'³ dsa³. 'E³ quie'²³ 'a²³jia'³ lǿ² la'³ quie'² Dios. Sɨ³li'²³ Dios la²³jɨ³ quie'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","'E³ jo̱³ ca²³lʉ́³ Peen²³². Ca²³sɨ'²³ Jesús: ―Mɨ³cuaa'n²³²na'³¹ la²³jɨ³ 'e³ xa³ quiée²ra'³¹ 'e³ ŋɨ²ra'³¹ quia̱'n²na'³¹ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xen³ dsa³ 'i³ mɨ³cuaa'n³ 'ñʉ́², 'i³ mɨ³cuaa'n³ jó̱o̱², 'i³ mɨ³cuaa'n³ xóo² jmii³, 'i³ mɨ³cuaa'n³ mɨ²³quie'², 'i³ mɨ³cuaa'n³ jo̱o̱³¹, 'i³ mɨ³cuaa'n³ 'uǿ²³ quiee'³² 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³, 'e³ jua'³ sɨ³táan³ júu² dxʉ́²³ quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","'E³ quie'²³ bi²³ cɨ² ma²³'nee³ ñúun³ li²³xa³ quie'² dsa³ 'í³ mɨ³¹güii³ la³. Li²³xa³ 'ñʉ́². Li²³xen³ jó̱o̱². Li²³xen³ xóo² jmii³. Li²³xen³ jo̱o̱³¹. Li²³xa³ 'uǿ²³. Co̱'³ cɨ'²³ li²³xa³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ rɨ²³cuǿ²³ dsa³. 'E³ quie'²³ rɨ³ji̱'²³ ca³cuaa³ jmɨ́ɨ² 'e³ ja³guín²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","'E³ quie'²³ 'e³ cɨ² rɨ²³lín³ 'i³ pii'² cɨ² juɨ́ɨn²³ dsa³ 'i³ rɨ³løn³¹ 'i³ gáan³ cɨ² rɨ³nɨ²³. 'E³ quie'²³ la'³, 'e³ cɨ² rɨ²³lín³ 'i³ gáan³ cɨ² juɨ́ɨn²³ dsa³ 'i³ rɨ³løn³¹ 'i³ pii'² cɨ² rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ta'n²te'²³ jui³¹ sɨ³guín²³te'²³ juɨɨ³ Jerusalén. 'Iún² jui³¹ jén²³ Jesús. Bi²³ juø'²³ ca²³ti²³cø̱n³¹ dsa³ quien³². 'E³ quie'²³ bi²³ juøø'n²³ dsa³ 'i³ tu³cɨ̱ɨ̱n³. Ca²³tøø³ co̱'³ te'²³ dsa³ gui²³tʉ̱́n³ quien³². Ca²³jua'³ co̱'³ 'e³ jmii'³¹ lǿ² 'e³ cɨ² rɨ²³ji̱'²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ca²³jua'³: ―Sɨ³gui²³²ra² juɨɨ³ Jerusalén. 'E³ quie'²³ je² núu²³ rɨ²³jɨ̱'n²te'²³ jné² Jo̱o̱³¹ Dsa³ quie'² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley. Te'²³ 'i³ 'í³ hua² 'i³ rɨ²³dxi³ 'i'²³ 'e³ cu²jú̱n³na²³. Rɨ²³jɨ̱'n²te'²³ jné² quie'² dsa³ jia'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Rɨ²³jáa² rɨ²³ŋɨ́ɨn²te'²³ jné². Rɨ²³jmín²te'²³ jné². Rɨ²³'ø'n²te'²³ jné². Rɨ²³jŋɨ'n²³te'²³ jné². 'E³ quie'²³ je² 'nɨ³ jmɨ́ɨ² 'e³ la²³ rɨ²³jú̱n³na²³ rɨ²³ji̱i̱'n²³na²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ca²³lǿn²³ mɨ³lén² Jacobo quia̱'² Juan, te'²³ jo̱²³ñʉʉ'³¹ Zebedeo. Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Dsa³ 'e²³, 'nee³ra'³¹ 'e³ rɨ²jméen² co̱o̱³ mɨ²'áa² 'e³ rɨ²jméen² te³ jmii'³¹ lǿ² 'e³ rɨ²ŋɨɨ'³¹ra'³¹ 'nʉ³ 'u². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","'E³ jo̱³ ca²³jua'³ Jesús: ―¿Jmii'³¹ cu³lø³¹ 'e³ 'noo³ra'³ 'e³ rɨ²jmeen²³² quién²na'³? ");
INSERT INTO cnlNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","'E³ jo̱³ ca²³jua'³te'²³: ―Rɨ²cuǿn² júu² 'e³ rɨ²'ioo²ra'³¹ jaan²³nu³ i²³la³ i²³nɨ³ mɨ³rɨ³'aa³ 'i'²³ 'e³ mɨ³la³gáan³nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","'E³ quie'²³ ca²³jua'³ Jesús: ―'A²³jia'³ ta³jmee³ra'³ 'i'²³ 'e³ jmii'³¹ cu³lø³¹ 'e³ ŋɨɨ³ra'³. ¿'A² rɨ²³lí³ juø'² rɨ²³tén²na'³ xi³nu³ rɨ²³jí̱i̱n²na'³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ la²³ lǿ² u²³ŋɨ́³ dsɨ́ɨ² 'e³ rɨ²³jí̱i̱n²³ jné²? ¿'A² rɨ²³lí³ juø'² rɨ²³tén²na'³ xi³nu³ rɨ²³dxi²³quié̱n²na'³ 'e³ la²³ lǿ² 'e³ rɨ²³dxi²³quié̱n²na²³ 'ñáan²³? ");
INSERT INTO cnlNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Rɨ²³lí³ juø'² xú̱n³. 'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ²³jí̱i̱n²na'³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ la²³ lǿ² u²³ŋɨ́³ dsɨ́ɨ² 'e³ rɨ²³jí̱i̱n²³ 'ñáan²³ xú̱n³. 'E³ quie'²³ la'³, rɨ²³dxi²³quié̱n²na'³ 'e³ la²³ lǿ² 'e³ rɨ²³dxi²³quié̱n²na²³ 'ñáan²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","'E³ quie'²³ 'a²³jia'³ née² guaan²³ jné² 'e³ rɨ²dxin²³² 'i'²³ 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³gua³ jaan²³na²³ i²³la³ i²³nɨ³. Qui² rɨ²³gua³ jaan²³na²³ i²³la³ i²³nɨ³ dsa³ 'i³ rɨ³lø³¹ 'i'²³ la'³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","'E³ quie'²³ bi²³ ca²³mɨ'n³ te'²³ dsa³ quien³² 'i³ guién²³ ñin³² Jacobo quia̱'² Juan ma²ca¹núu³te'²³ 'e³ jmii'³¹ cu³lø³¹ ca²³ŋɨ́ɨ³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","'E³ jo̱³ ca²³tøø³ Jesús dsa³ quien³². Ca²³jua'³: ―Móo³ra'³ 'e³ bi²³ la²³dxi³ 'i'²³ dsa³ jia'³ 'i³ mɨ³'uøøn³te'²³ 'e³ rɨ²³lín³ dxi² juɨɨ³ quien³²te'²³. Bi²³ 'uee'n³ jmoo³² dsa³ 'i³ gáan³ jee²³² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","'E³ quie'²³ 'a²³jia'³ 'ne'² 'e³ rɨ²³lí³ la'³ jee²³² quien³²na'³. Qui² 'ne'² rɨ²³lín³na'³ mozos 'i³ mi³quin³ uu'n² 'nee'²³ 'i³ 'née²³ rɨ²³lín³ 'i³ gáan³ jee²³² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","'E³ quie'²³ la'³, 'ne'² rɨ²³lín³na'³ mozos 'i³ 'uǿn²³ cɨ² 'i³ rɨ²³mi²³quin³ la²³jɨn³ uu'n² 'nee'²³ 'i³ 'née²³ rɨ²³lín³ 'i³ gáan³ cɨ² jee²³² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Qui² la'³ cu³lø³¹ ca²³jméen²³ jné² Jo̱o̱³¹ Dsa³. 'A²³la³ jo̱³ 'e³ juø'n²³ 'náan²³ 'e³ li²³xen³ 'i³ rɨ²³mi²³quin³ jné² 'e³ güén²³na²³. 'E³ quie'²³ güén²³na²³ 'e³ juø'n²³ 'náan²³ 'e³ rɨ²mi³quin²³na²³ dsa³. Güén²³na²³ 'e³ rɨ²³jú̱n³na²³ 'e³ juø'n²³ 'náan²³ rɨ²løn³¹na¹ juɨ́ɨn²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","'E³ quie'²³ ca²³dxi²³guín²³te'²³ juɨɨ³ Jericó. 'E³ la²³ sɨ³bǿn³ juɨɨ³ Jericó Jesús quia̱'² dsa³ quien³² quia̱'² cɨ² juɨ́ɨn²³ dsa³, jen³¹ coo³¹ jui³¹ jø̱n³ dsa³ tuu² mɨ²ñi² 'i³ ŋɨɨ²³ cuu². Bartimeo xi̱i̱n³ dsa³ 'í³, jo̱²³ñʉʉ'³¹ Timeo. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma²ca¹núu³ Bartimeo 'e³ sɨ³ŋɨ́n³ Jesús dsa³ Nazaret, ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³jua'³: ―Jesús, dsa³ ju̱u̱n²³ David, cu²li³cuu'²³ 'áan² quia̱'n²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Juɨ́ɨn²³ xen³ 'i³ ca²³jíi². Ca²³sɨ'²³te'²³ Bartimeo 'e³ cu²quín³. 'E³ quie'²³ dsɨ³² cɨ² ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³jua'³: ―Dsa³ ju̱u̱n²³ David, cu²li³cuu'²³ 'áan² quia̱'n²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","'E³ jo̱³ ca²³noo³ Jesús. Ca²³jua'³: ―Tée²ra'³ dsa³ nɨ³. 'E³ jo̱³ ca²³tøø³te'²³ dsa³ tuu². Ca²³jua'³te'²³: ―Dxa² co̱o̱³ 'áan². Naa'n²³. Qui² tøø³ 'nʉ³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","'E³ jo̱³ ca²³dxin³ 'mɨɨ'³ dxóo³ quiee'³². La²³røøn³ ca²³naa'n²³. Ca²³lǿn²³ mɨ³lén² caan²³ Jesús jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Bartimeo: ―¿Jmii'³¹ cu³lø³¹ 'naan³ 'e³ rɨ²jmeen²³² quién²nu³? 'E³ jo̱³ ca²³jua'³ dsa³ tuu²: ―Dsa³ 'e²³, 'náan²³ 'e³ li²³jnéen²³ 'u². ");
INSERT INTO cnlNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","'E³ jo̱³ ca²³jua'³ Jesús: ―Guø'n³ jo̱o̱²³na²³. Sɨ³táan³nu³. 'E³ jo̱³ mɨ³'láan³nu³. Xe̱'n² quie'²³ jo̱³ ca²³la²³jnée²³ dsa³ tuu². 'E³ quie'²³ jo̱³ 'í² jui³¹ tu³cɨ̱ɨ̱n³ quia̱'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ca²³lǿn²³te'²³ mɨ³lén² juɨɨ³ Jerusalén. Ca²³dxi²³guín²³te'²³ juɨɨ³ Betfagé quia̱'² juɨɨ³ Betania 'e³ nee'²³² coo³¹ mo'³ Olivos. 'E³ jo̱³ ca²³xíin²³ Jesús áan²³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ca²³jua'³: ―Cu³guín²³na'³ jee²³² juɨɨ³ tu³'o³ la²³ xi²ñí²ra'³. Xe̱'n² la²³ rɨ²³dxi²³guín²³na'³ 'oo'² juɨɨ³, rɨ²³jí̱i̱n³na'³ jø̱n³ jo̱o̱³¹ burro 'i³ rɨ³'ñu'n² 'i³ 'a²³jia'³ lɨ'³ ca³cu³dsɨn³¹te'¹. Rɨ²ji̱i̱n²³na'³ jo̱o̱²³na²³. Rɨ²jøn²³na'³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","'E³ quie'²³ xi³nu³ xen³ 'i³ rɨ²³jua'³ rɨ²³sɨ'²³ 'nee'²³: “¿'Ee² lǿ² jmee³ra'³ la²³nɨ³?” Rɨ²juɨɨ'³¹ra'³ dsa³ 'í³: “'Ne'² quie'² Juii³ra². 'E³ cɨ² rɨ²³xíin²³ mozos 'i³ rɨ²³gui²³jáan³ co̱'³.” La'³ rɨ²juɨɨ'³¹ra'³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","I²guín¹te'²³ jo̱o̱²³na²³. Ca²³dsø'n²³te'²³ jø̱n³ jo̱o̱³¹ burro 'i³ rɨ³'ñu'n² 'oo'² 'ñʉ³¹ quie'² dsa³ xʉʉ'²³² calles. 'E³ quie'²³ jo̱³ ca²³jí̱i̱n²te'²³ burro. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ca²³jua'³ dsa³ 'i³ té̱e̱n³ coo³¹. Ca²³sɨ'²³ dsa³ quien³² Jesús: ―¿'Ee² 'noo³¹ jmee³ra'³? ¿'Ee² lǿ² ji̱i̱n²³na'³ burro nɨ³? ");
INSERT INTO cnlNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","'E³ jo̱³ ca²³sɨ'²³te'²³ dsa³ 'í³ 'e³ la²³ ca²³jua'³ Jesús. 'E³ jo̱³ 'a²³'e³ xa³ ca²³jmóo²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","'E³ quie'²³ jo̱³ i²jøn²³te'²³ burro caan²³ Jesús. Ca²³dxá³te'²³ 'mɨɨ'³ quiee'³²te'²³ ñi'² quiee'³² burro. 'E³ quie'²³ jo̱³ ca²³cu²³dsɨn³¹ burro Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Juɨ́ɨn²³ dsa³ 'i³ ca²³ti²³jó³ 'mɨɨ'³ quiee'³² dxi²jui³¹. 'E³ quie'²³ xen³ cɨ² 'i³ ca²³tʉ'² guoo³ mee³ 'e³ ca²³ti²³jó³ dxi²jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ca²³lʉ́³ quiʉ̱ʉ̱³ dsa³ 'i³ ta'n² jui³¹ jén²³ quia̱'² dsa³ 'i³ tu³cɨ̱ɨ̱n³. Ca²³jua'³te'²³: ―¡Que viva! ¡Mɨ³cuǿ³ Dios u²³li²³jé̱e̱³ quie'² dsa³ la³ 'i³ ja³'ɨ́ɨn²³ 'e³ 'iin³¹ Dios Juii³ra²! ");
INSERT INTO cnlNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Mɨ³cuǿ³ Dios u²³li²³jé̱e̱³ quie'² rey 'i³ ja³'ɨ́ɨn²³ 'i³ li²³gáan³ la²³ gáan³ David yi²³uu'²ra² jaa²³²! ¡Que viva Dios 'i³ jen³¹ yʉʉ'³¹ güii³! ―La'³ ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","'Í² Jesús jee²³² juɨɨ³ Jerusalén. 'Í² ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Ca²³jóo² rɨ³ca̱'n²³. 'E³ quie'²³ mɨ³cu³'lóo³. 'E³ jo̱³ ŋóo² co̱'³ juɨɨ³ Betania quia̱'² dsa³ gui²³tʉ̱́n³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","La²³ mɨ³dxóo³ la'³ ca²³'uǿøn²³te'²³ co̱'³ juɨɨ³ Betania. 'E³ quie'²³ cue̱'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Huɨ̱́ɨ̱³ ŋó²³ je² ja³¹ co̱o̱³ 'mo³ higo 'e³ bi²³ xa³ mee³¹. 'E³ jo̱³ ŋóo² i²joo³ xi² rɨ³'ɨɨ³¹ mɨɨ³¹. 'E³ quie'²³ ma²ca¹dxóo¹, 'a²³'e³ mɨɨ³¹ xa³ 'e³ rɨ³'ɨɨ³¹. 'Nɨɨ'n³¹ mee³¹ hua² xa³. Qui² 'a²³jia'³ ca²³tɨ́³ ji̱i̱³ 'e³ rɨ²³'ɨ́ɨ²³ mɨɨ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","'E³ jo̱³ ca²³lʉ́³ Jesús. Ca²³sɨ'²³ 'mo³ higo: ―'A²³ ma²³ rɨ³'ɨɨn³ 'nʉ³ mɨɨ³¹ 'e³ rɨ²³e'² dsa³. 'E³ quie'²³ ca²³núu³ dsa³ quien³² 'e³ la²³ ca²³lʉ́³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","'E³ quie'²³ jo̱³ ca²³dxi²³guín²³te'²³ co̱'³ juɨɨ³ Jerusalén. 'Í² Jesús ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Ca²³'uøøn³ dsa³ 'i³ 'nɨɨ²³, dsa³ 'i³ lo³² ñʉ'²³ 'ñʉ́² gáan³. Ca²³cɨ'² mesas je² guø'n³²te'²³ cuu² quiee'³² jia'³ cɨ'²³ dxi² juɨɨ³. Ca²³cɨ'² sii³¹ quiee'³² dsa³ 'i³ 'nɨɨn²³ to̱³ju̱³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","'E³ quie'²³ 'a²³jia'³ ma²³ ca²³cuǿ³ júu² 'e³ rɨ²³ŋɨ́n³ ñʉ'²³ 'ñʉ́² gáan³ dsa³ 'i³ quie̱³ te³ 'ee² quie'²³ 'noo³¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","'E³ quie'²³ jo̱³ ca²³'ée²³ dsa³. Ca²³jua'³: ―La²³la³ cu³lø³¹ to̱o̱²³ ji³ júu² quiee'³² Dios: “'Ñʉ́² je² lʉ²³ quia̱'² Dios la²³jɨn³ dsa³ mɨ³¹güii³ rɨ²³sɨ'²³te'²³ 'ñʉ́² je² mi³gáan³te'²³ jné²”. La'³ cu³lø³¹ to̱o̱²³ ji³, ¿mɨ³naa'³¹? 'E³ quie'²³ mɨ³jmée²ra'³ 'é̱e̱² 'ñʉ́² je² nee'n²³² dsa³ 'i̱i̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ca²³núu³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley 'e³ la²³ lǿ² 'e³ ca²³jua'³ Jesús. 'E³ jo̱³ 'no'²te'²³ 'e³ jmii'³¹ li²³tɨ́ɨ²³ rɨ²³jŋɨ'n²³te'²³. Qui² bi²³ juøø'n²³te'²³ 'e³ jua'³ bi²³ juø'²³ nuu³ la²³jɨn³ dsa³ juɨɨ³ júu² 'e³ 'e²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ma²mɨ³nʉʉ³, ca²³bǿn³ co̱'³ Jesús juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","La²³ mɨ³dxóo³ la'³ ca²³ŋɨ́n³te'²³ co̱o̱³ i²³'áa³ je² ja³¹ 'mo³ higo. Ŋó²³te'²³ 'e³ mɨ³la³quiʉ̱ʉ̱³ xoo'³¹ ca³ti³² quia̱'² jmó². ");
INSERT INTO cnlNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","'E³ quie'²³ ca²³la²³líi²³ Peen²³² 'e³ jmii'³¹ cu³lø³¹ ca²³jua'³ Jesús. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³, jóo² rɨ²máan². Mɨ³la³quiʉ̱ʉ̱³ 'mo³ higo 'e³ ca²³juɨɨn²³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'Ne'² rɨ²³sɨ²³táan³na'³ quia̱'n²na'³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Rɨ²³jmée²³ Dios 'e³ la²³ ŋɨɨ²³ dsa³ 'i³ jua'³ sɨ'²³ mo'³ la³: “Je̱'n² nɨ³. Cu²te'n¹nu³ 'e̱'³ jmɨ²³ñii'³¹.” Rɨ²³lí³ 'e³ la²³ jua'³ dsa³ 'í³ xi³nu³ 'a²³la³ 'e³ tú̱²³ dsɨ́² 'e³ xi² rɨ²³lí³, xi³nu³ sɨ³táan³ ca³quie̱e̱² 'e³ rɨ²³lí³ 'e³ la²³ jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","'E³ jo̱³ rɨ²juøøn³¹na¹ 'nee'²³: 'Ne'² rɨ²³sɨ²³táan³na'³ 'e³ rɨ²³'ién²na'³ la²³jɨ³ 'e³ ŋɨɨ³ra'³ 'e³ la²³ lʉ́²ra'³ quia̱'n²na'³ Dios. Jo̱³ hua² rɨ²³'ién²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","'E³ la²³ té̱e̱n³na'³ lʉ́²ra'³ quia̱'n²na'³ Dios, xi³nu³ xen³ dsa³ 'i³ 'iún² 'óo²ra'³ 'e³ mɨ'n³na'³ mǿn²³na'³, rɨ²jmée²ra'³ u²³juee'³ dsɨɨ³² rɨ²mǿn¹na'³ dsa³ 'í³. Jo̱³ hua² rɨ²³jmée²³ u²³juee'³ dsɨɨ³² Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³ rɨ²³ñín² 'nee'²³ mɨ³rɨ³jmee³ra'³ 'e³ xa³ dsoo² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","'E³ quie'²³ xi³nu³ 'a²³jia'³ jmee³ra'³ u²³juee'³ dsɨɨ³² mǿn²³na'³ dsa³, 'e³ quie'²³ la'³ 'a²³jia'³ rɨ²³jmée²³ u²³juee'³ dsɨɨ³² Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³ rɨ²³ñín² 'nee'²³ mɨ³rɨ³jmee³ra'³ 'e³ xa³ dsoo² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","'E³ la²³ ca²³dxi²³guiin³²te'²³ co̱'³ juɨɨ³ Jerusalén, ca²³ŋɨ́³ Jesús ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. 'E³ quie'²³ jo̱³ ca²³lǿn²³ mɨ³lén² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley quia̱'² te'²³ dsa³ mɨ³dxún²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―¿'Ee² ta² quié̱n² 'e³ jmeen³ la²³jɨ³ 'e³ jmeen³? ¿'I̱i̱² sɨɨ'³¹ 'i³ ca²³cuǿø²³ 'nʉ³ ta² 'e³ jmeen³ 'e³ la²³ jmeen³? ");
INSERT INTO cnlNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Xa³ co̱o̱³ júu² 'e³ rɨ²ŋɨ'n¹na²³ 'nee'²³. Xi³nu³ rɨ²juɨɨ'³¹ra'³ jné², 'e³ jo̱³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ 'ee² ta² rɨ³løn³¹na¹ 'e³ jmeen²³ 'e³ la²³ jmeen²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Rɨ²juɨɨ'³¹ra'³ jné² jo̱o̱²³na²³: ¿'I̱i̱² sɨɨ'³¹ ca²³cuǿ³ ta² quie'² Juan 'e³ ca²³xáan² dsa³ jmɨɨ³? ¿'A² Dios 'i³ jen³¹ yʉʉ'³¹ güii³ 'i³ ca²³cuǿ³ ta² quie'²? ¿'A² dsa³ hua² 'i³ ca²³cuǿ³ ta² quie'²? ");
INSERT INTO cnlNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","'E³ quie'²³ jo̱³ ca²³sɨ́n²³te'²³ júu² la²³ co̱³quie'²te'²³. Ca²³jua'³te'²³: ―Xi³nu³ rɨ²juaa'²ra²: “Dios ca²³cuǿ³ ta² quie'² Juan”, 'e³ jo̱³ rɨ²³jua'³ 'ñée², rɨ²³sɨ'²³ jné²: “¿'Ee² lǿ² 'a²³jia'³ ca²³táan³na'³ júu² 'e³ ca²³lʉ́³ jo̱o̱²³na²³?” ");
INSERT INTO cnlNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","'E³ quie'²³, ¿jmii'³¹ xi³nu³ rɨ²juaa'²ra² 'e³ dsa³ hua² ca²³cuǿ³ ta² quie'²? 'E³ quie'²³ bi²³ 'ñaa'n²³te'²³ dsa³ juɨɨ³. Qui² lǿn³ la²³jɨn³ dsa³ juɨɨ³ 'e³ ca³quie̱e̱² ca²³'ɨ́ɨ³ Juan júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―'A²³jia'³ ne³ra'³¹. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'E³ quie'²³ la'³, 'a²³jia'³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ 'i̱i̱² sɨɨ'³¹ ca²³cuǿø²³ jné² ta² 'e³ jmeen²³ 'e³ la²³ jmeen²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Co̱'³ cɨ'²³ ca²³lʉ́³ Jesús júu² rɨ³jnɨ³. Ca²³jua'³: ―Xen³ jø̱n³ dsa³ 'i³ ca²³jñi³ xoo'³¹ jø'². Ca²³xii'³ 'iá³ la²³cu'². Ca²³yʉ́ʉ² too³ je² rɨ²³pi'n²te'²³ mɨ²jø'² 'e³ jua'³ rɨ²³co̱o̱²³te'²³ jmɨɨ'³¹. Ca²³jmée³ co̱o̱³ 'ñʉ́² jɨ̱ɨ̱n²³² je² rɨ²³gua³ dsa³ 'i³ rɨ²³'áa²³ je² rɨ³jne² xoo'³¹ jø'². ’Ca²³'náan²³ mozos 'i³ rɨ²³gua³ 'uǿ²³ quiee'³² 'e³ jua'³ 'née²³ 'e³ rɨ²³jmóo² ta² quiee'³² xoo'³¹ jø'². 'E³ jo̱³ ŋóo² 'ñée² co̱o̱³ juɨɨ³ je² bi²³ huɨ̱́ɨ̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ma²ca¹tɨ́³ ji̱i̱³ 'e³ jioo³² dsa³ mɨ²jø'², ca²³xíin²³ jø̱n³ mozo quien³² 'e³ jua'³ rɨ²³co̱o̱²³ mɨ²jø'² jñii³¹ 'uǿ²³ 'e³ rɨ²³jɨ̱'² te'²³ mozos 'i³ jmoo³² ta² quiee'³² xoo'³¹ jø'². ");
INSERT INTO cnlNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","'E³ quie'²³ 'a²³jia'³ dxʉ́²³ ca²³jmóo² te'²³ mozos 'í³. Sø̱'n²te'²³ mozo 'i³ ca²³xíin²³ juii²te'¹. Ca²³jmín²te'²³. 'A²³'e³ xa³ 'e³ quie̱³ 'e³ la²³ ca²³cu²³dxe'n³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","'E³ quie'²³ ca²³xíin²³ juii² jia'³ cɨ'²³ mozo quien³² co̱'³. 'E³ quie'²³ ca²³cuǿ³te'²³ cú̱u̱² quie'² 'i³ 'í³. Ca²³mo'² mɨ²dxi². Bi²³ u²³'i'²³ ca²³jme'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","'E³ jo̱³ ca²³xíin²³ juii² jia'³ cɨ'²³ mozo. 'E³ quie'²³ ca²³jŋɨ'n²³te'²³ 'i³ 'í³ co̱'³. 'E³ quie'²³ la'³, bi²³ juɨ́ɨn²³ mozos 'i³ ca²³jme'²³te'²³ la'³. Xen³ 'i³ ca²³jmín²te'²³. Xen³ 'i³ ca²³jŋɨ'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Jø̱n³ cɨ² xen³ 'i³ ca²³cuaa'n²³ quie'² juii² 'uǿ²³. Jo̱o̱³¹ 'i³ bi²³ 'néen² hua² 'í³. Je² dsøn³ ca²³xíin²³ 'i³ 'í³. Qui² lǿn³: Rɨ²³'áa²³te'²³ u²³go³ u²³'iʉʉ²³ quia̱'²te'²³ ja̱a̱n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","'E³ quie'²³ ca²³lʉ́³ la²³ co̱³quie'² mozos. Ca²³jua'³te'²³: “'I³ la³ dsa³ 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³'ióo²³ 'uǿ²³ mɨ³rɨ³jú̱n³ jmii³. Mɨ²³gui²³²ra². Mɨ²³jŋɨ'n²³na². Jo̱³ hua² rɨ²³'ióo²³ra² miin²³na² 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³'ióo²³ 'ñée².” ");
INSERT INTO cnlNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","'E³ jo̱³ sø̱'n²te'²³ jo̱o̱³¹ juii² 'uǿ²³. Ca²³jŋɨ'n²³te'²³. Ca²³juén²te'²³ rɨ²³co'²³ 'iá³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿Jmii'³¹ cu³lø³¹ rɨ²³jmée²³ juii² 'uǿ²³, lǿn³na'³? Rɨ²³dsóo² rɨ²³sɨ²³jŋɨ'n³ mozos 'i³ jmoo³² ta² quiee'³² xoo'³¹ jø'². Rɨ²³cuǿø²³ jia'³ cɨ'²³ dsa³ 'uǿ²³ quiee'³² 'e³ cu²jmóo¹te'²³ ta² quiee'³² xoo'³¹ jø'². ");
INSERT INTO cnlNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿'A² 'a²³jia'³ lɨ'³ ca³jóo²ra'³ ji³ je² to̱o̱²³ júu² quiee'³² Dios je² jua'³: 'Ñée² cú̱u̱² 'e³ tó̱o̱²³ tɨ³² 'e³ jua'³ 'a²³jia'³ 'nee'³¹ mɨ³lǿ²³ cú̱u̱² 'e³ quie̱³ biin²³; ");
INSERT INTO cnlNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dios Juii³ra² 'i³ ca²³jmée³ la'³; bi²³ juø'²³ joo²³²ra² 'e³ la²³ ca²³jmée³? ");
INSERT INTO cnlNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","'Née²³te'²³ rɨ²³sø̱'n²te'²³ Jesús. Qui² ca²³la²³quii²³te'²³ 'e³ miin²³ hua² 'en³² Jesús ma²ca¹lʉ́³ júu² rɨ³jnɨ³ quiee'³² mozos 'i³ jmoo³² ta² quiee'³² xoo'³¹ jø'². 'E³ quie'²³ bi²³ 'ñaa'n²³te'²³ dsa³ juɨɨ³. 'E³ jo̱³ ca²³cuaa'n³te'²³ Jesús. Ca²³guín²³ jia'³ cɨ'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","'E³ quie'²³ jo̱³ xen³ dsa³ fariseo quia̱'² dsa³ 'i³ noo³ quia̱'² Herodes 'i³ ca²³xíin²³te'²³ caan²³ Jesús co̱'³. Qui² 'née²³te'²³ rɨ²³jáan²³te'²³ júu² quiee'³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","I²guín¹ te'²³ dsa³ 'í³ jo̱o̱²³na²³. Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Dsa³ 'e²³, ne³ra'³¹ 'e³ jmeen³ 'e³ la²³ lǿ² ju²dsoo³¹, 'e³ 'a²³jia'³ jmeen³ quí̱i̱n²³ te³ jmii'³¹ lʉ²³ dsa³ 'en³² 'nʉ³. 'A²³jia'³ jmeen³ quí̱i̱n²³ xi² gáan³ dsa³, xi² 'a²³jia'³ gáan³ dsa³. 'E³ quie'²³ lʉ́n² ju²dsoo³¹ 'e³ la²³ 'een³² dsa³ jui³¹ 'e³ cuø²³ Dios. ¿'A² rɨ²jméen² co̱o̱³ mɨ²'áa² rɨ²juɨɨ'n³¹nu³ jnee'³¹ xi² joo'²³ 'e³ rɨ²qui²³²ra² cuu² 'e³ cu'n³² 'io'² 'i³ xiin²³ dxi² juɨɨ³ César? ¿'A² rɨ²qui²³²ra² jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ñi³² Jesús 'e³ te³ cø̱n³²te'²³ tóo³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ―¿'Ee² lǿ² 'e³ 'noo³ra'³ rɨ²jmée²ra'³ lá³ quia̱'n²na'³ jné²? Ja³ maan²³² la³ co̱o̱³ cuu² jo̱³ rɨ²ne²ra². ");
INSERT INTO cnlNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","'E³ jo̱³ i²quié̱³te'²³ co̱o̱³ cuu². 'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―¿'I̱i̱² sɨɨ'³¹ quie'² ne'n² 'e³ to̱o̱²³ la³? ¿'I̱i̱² sɨɨ'³¹ quie'² nombre 'e³ to̱o̱²³? 'E³ jo̱³ ca²³jua'³te'²³: ―'E³ quiee'³² dxi² juɨɨ³ César. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Rɨ²cuøø³¹ra'³ dxi² juɨɨ³ la²³jɨ³ 'e³ quiee'³² dxi² juɨɨ³. 'E³ quie'²³ rɨ²cuøø³¹ra'³ Dios la²³jɨ³ 'e³ quiee'³² 'ñée² Dios. Bi²³ juø'²³ ca²³núu³te'²³ júu² 'e³ ca²³lʉ́³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Xen³ dsa³ saduceo 'i³ ca²³guín²³ caan²³ Jesús. 'E³ quie'²³ jua'³ dsa³ saduceo 'e³ 'a²³jia'³ sɨ³ji̱i̱'²³ dsa³ co̱'³. Xa³ co̱o̱³ júu² 'e³ ca²³ŋɨ'²³te'²³ Jesús. Ca²³jua'³te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Dsa³ 'e²³, la²³la³ cu³lø³¹ jua'³ ji³ 'e³ ca²³jmée³ Moisés 'e³ xa³ quiée²ra²: Xi³nu³ rɨ²³jú̱n³ jø̱n³ dsa³ 'i³ rɨ³ji̱'²³ quie'²³ mɨ²³quie'² 'e³ quie'²³ 'a²³'i̱³ xen³ jo̱o̱³¹, 'ne'² 'e³ rɨ²³tǿø²³ mɨ́³ 'nɨ́ɨ³ jó̱o̱² dsa³ 'i³ jú̱n²³ 'e³ jua'³ cu²li³xen³ 'é̱e̱² jo̱o̱³¹ 'lɨ² jó̱o̱². La'³ cu³lø³¹ jua'³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Xen³ guiáan²³ dsa³ la²³ ca³já̱a̱n². Tǿø² mɨ́³ jó̱o̱² 'i³ cua̱a̱n²³. 'E³ quie'²³ jú̱n²³. 'A²³'i̱³ jo̱o̱³¹ ca²³la²³xen³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'E³ jo̱³ tǿø² mɨ́³ 'nɨ́ɨ³ jó̱o̱² 'i³ sɨ³tɨ́²³ áan²³. 'E³ quie'²³ jo̱³ jú̱n²³ 'i³ 'í³ co̱'³. 'E³ quie'²³ 'a²³'i̱³ jo̱o̱³¹ ca²³la²³xen³. 'E³ quie'²³ la'³ ca²³ji̱'²³ jó̱o̱² 'i³ sɨ³tɨ́²³ aan³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ca²³la²³quia̱'² mɨ́³ 'í³ la²³jɨn³ guiáan²³. 'E³ quie'²³ 'a²³jia'³ ca²³la²³xen³ jo̱o̱³¹. Je² dsøn³ cɨ² jú̱n²³ 'ñée² mɨ́³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿'I̱i̱² quién² mɨ́³ 'í³ mɨ³rɨ³ji̱i̱'²³ dsa³ co̱'³ cu²ne²ra²? Qui² ca²³la²³quia̱'² la²³jɨn³ guiáan²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ saduceo: ―Mɨ³ca³caa'n³²na'³ xú̱n³. Qui² 'a²³jia'³ cuiin³na'³ júu² quiee'³² Dios 'e³ to̱o̱²³ ji³. 'A²³ cɨ'²³ móo³ra'³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'uee'n³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Qui² 'a²³jia'³ ma²³ rɨ²³tǿø²³ dsa³ mɨ́³ mɨ³rɨ³ji̱i̱'²³ dsa³ co̱'³. 'E³ quie'²³ 'a²³jia'³ ma²³ rɨ²³cuǿn² dsa³ mɨ́³ 'e³ rɨ²³tǿø²³ dsa³. Mɨ³rɨ³ji̱i̱'²³ dsa³ co̱'³, li²³xen³te'²³ la²³ xen³ ángeles 'i³ nee'n²³² yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Rɨ²juøøn³¹na¹ 'nee'²³ 'e³ sɨ³ji̱i̱'²³ dsa³ co̱'³. ¿'A² 'a²³jia'³ lɨ'³ ca³jóo²ra'³ je² to̱o̱²³ ji³ 'e³ ca²³jmée³ Moisés 'e³ la²³ lǿ² 'e³ 'iún² Dios xoo'³¹ nuu³ ma²ca¹lʉ́³ quia̱'² Moisés? Ca²³jua'³: “Dios juii² Abraham hua² jné². Dios juii² Isaac. Dios juii² Jacob co̱'³”, ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","'A²³jia'³ rɨ³løn³¹ Dios juii² dsa³ 'i³ rɨ³jú̱n². 'E³ quie'²³ rɨ³løn³¹ juii² dsa³ 'i³ rɨ³ji̱'²³. 'E³ jo̱³ hua² lii²³ 'e³ rɨ³ji̱'²³ Abraham quia̱'² Isaac quia̱'² Jacob, juø'n³ quie'²³ jú̱n²³te'²³. Bi²³ mɨ³ca³caa'n³²na'³ xú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ca²³dxóo² jø̱n³ dsa³ 'e²³ ley. Ca²³núu³ 'e³ jmii'³¹ lǿ² sɨn²³te'²³ júu². Ca²³núu³ 'e³ bi²³ dxʉ́²³ ca²³jme'n² júu² Jesús. 'E³ jo̱³ ca²³ŋɨ́ɨ³ júu². Ca²³jua'³: ―¿'Ee² júu² 'e³ gáan³ cɨ² 'e³ ca²³dxi³ 'i'²³ Dios cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","'E³ jo̱³ ca²³jua'³ Jesús: ―La²³la³ cu³lø³¹ júu² 'e³ ca²³dxi³ 'i'²³ Dios 'e³ gáan³ cɨ²: “'Ne'² rɨ²núu²ra'³, 'nee'²³ dsa³ Israel: Jø̱n³ Dios Juii³ra² rɨ³løn³¹ juii² jne². ");
INSERT INTO cnlNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","'Ne'² li²³'náan²³na'³ Dios Juii³ra'³ 'e³ dxaa'n³¹ 'óo²ra'³. Jø̱n³ Dios 'nɨɨ'n³¹ 'ne'² 'e³ nee² 'óo²ra'³. 'Ne'² li²³'náan²³na'³ la²³jɨ³ sú̱n² 'i'²³ 'e³ jmee³ra'³. 'Ne'² li²³'náan²³na'³ la²³jɨ³ ju²³bíi²³ 'e³ xa³ quién²na'³.” La²³nɨ³ cu³lø³¹ júu² 'e³ ca²³dxi³ 'i'²³ Dios 'e³ gáan³ cɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","'E³ quie'²³ 'e³ ma²³ røø³ lǿ² quia̱'² júu² je² sɨ³tɨ́²³ tú̱²³: “'Ne'² li²³'náan²³na'³ uu'n²na'³ 'e³ la²³'nɨɨ'n³¹ 'e³ 'náan²³na'³ miin²³na'³”. 'A²³'e³ ma²³ xa³ jia'³ cɨ'²³ júu² 'e³ ca²³dxi³ 'i'²³ Dios 'e³ gáan³ cɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","'E³ jo̱³ ca²³jua'³ dsa³ 'e²³ ley. Ca²³sɨ'²³ Jesús: ―'E̱'n³ quie'²³ la'³, dsa³ 'e²³. Ju²dsoo³¹ mɨ³lʉ́n² 'e³ la²³ mɨ³jue'n² 'e³ jø̱n³ 'ñée² hua² xen³, 'e³ 'a²³'i̱³ xen³ jia'³ cɨ'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","'Ne'² li²³'neen²³²na² 'e³ dxaa'n³¹ dsɨ³ra². 'Ne'² li²³'neen²³²na² la²³jɨ³ 'i'²³ 'e³ jmee³ra². 'Ne'² li²³'neen²³²na² la²³jɨ³ ju²³bíi²³ 'e³ xa³ quiée²ra². 'Ne'² li²³'neen²³²na² uu'n²na² 'e³ la²³'nɨɨ'n³¹ 'e³ 'neen²³²na² miin²³na². Quí̱i̱n²³ cɨ² bíi²³ 'e³ rɨ²jmee²ra² la'³ la²³ cɨ'²³ 'e³ rɨ²cuøn²³²na² la²³jɨn³ 'i³ cuøn²³²na² Dios 'e³ juaa'³ra² cu²jɨ̱́n¹te'²³ rɨ³ca̱'n²³, la²³ cɨ'²³ 'e³ rɨ²cuøn²³²na² la²³jɨn³ 'i³ cuøn²³²na² Dios 'e³ juaa'³ra² cu²jŋɨ'n¹te'²³. ―La'³ ca²³jua'³ dsa³ 'e²³ ley. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ca²³dsóo²³ dsɨ́² Jesús 'e³ bi²³ ca²³jmée³ 'i'²³ dsa³ 'í³ 'e³ la²³ ca²³jmée³ júu². 'E³ jo̱³ ca²³jua'³: ―Ca³juɨ² cɨ² 'ne'² 'e³ rɨ²³lín³ Dios juiin³ 'u². Ma²mɨ³líi² la'³, 'a²³'i̱³ ma²³ xen³ dsa³ 'i³ ca²³la²³bii²³ dsɨ́² ca²³ŋɨ'²³ júu² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ca²³'é³ Jesús ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Ca²³jua'³: ―¿Jmii'³¹ lǿ² 'e³ jua'³ dsa³ 'e²³ ley 'e³ dsa³ ju̱u̱n²³ David rɨ³løn³¹ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios? ");
INSERT INTO cnlNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Qui² Espíritu Gáan³ ca²³cuǿ³ jui³¹ quie'² 'ñée² David ma²ca¹jua'³ 'e³ la²³ to̱o̱²³ ji³ je² jua'³: Ca²³jua'³ Dios Juii³ra². Ca²³sɨ'²³ Juiin²³: “Ñí³ jaan²³na²³ 'e³ dxʉ́²³ la²³huø'n²³ 'e³ rɨ²jmeen²³² 'e³ rɨ²³lín³nu³ juii² dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² 'nʉ³”. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Juiin²³ ca²³jua'³ 'ñée² David ca²³'én² Cristo. ¿Jmii'³¹ lǿ² 'e³ rɨ³løn³¹ Cristo ju̱u̱n²³ David xi³nu³ la'³ cu³lø³¹ ca²³jua'³? Qui² rɨ³løn³¹ juii² co̱'³. ―La'³ ca²³jua'³ Jesús. Bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³núu³ júu² 'e³ ca²³lʉ́³ Jesús. 'E³ quie'²³ bi²³ 'née²³ quie'²te'²³ 'e³ la²³ ca²³núu³te'²³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ca²³'ée²³ dsa³ Jesús. Ca²³jua'³: ―'A²³ rɨ³co̱³ra'³ tɨ³² 'i'²³ quiee'³² dsa³ 'e²³ ley. Qui² bi²³ mi³gáan³ miin²³. Bi²³ la²³ŋɨ́²³te'²³ la²³ca̱a̱n³ 'e³ quii'³te'²³ cuo̱o̱³ cuaa³. 'Née²³te'²³ 'e³ rɨ²³cuǿ²³ dsa³ u²³juee'n³¹ quia̱'²te'²³ je² dxa²³ dsa³ 'moo'². ");
INSERT INTO cnlNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","'Née²³te'²³ 'e³ rɨ²³gua³te'²³ je² dxʉ́²³ cɨ² ñʉ'²³ 'ñʉ́² je² mi³gáan³ dsa³ Dios. 'Née²³te'²³ rɨ²³gua³te'²³ sii³¹ je² gua³ dsa³ gáan³ 'e³ la²³ tøø³te'²³ 'e³ rɨ²³e'². ");
INSERT INTO cnlNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","'E³ quie'²³ je̱'n³²te'²³ 'ñʉ² mɨ́³ 'nɨ́ɨ³. 'A²³jia'³ juɨɨ³² ji̱'²³te'²³. Bi²³ huǿø³ lʉ²³te'²³ quia̱'²te'²³ Dios 'e³ jua'³ cu²jóo¹ dsa³. 'E³ jo̱³ bi²³ cɨ² rɨ²³jmée²³ Dios jñiin²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","'E³ quie'²³ jo̱³ ca²³gua³ Jesús ji³ñín³ je² nee'²³² guóo² je² too'²³ dsa³ cuu² ñʉ'²³ 'ñʉ́² gáan³. Ca²³jóo² 'e³ la²³ ca²³to'²³ cuu². Juɨ́ɨn²³ dsa³ xoo³² 'i³ ñúun³ cuu² ca²³to'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","'E³ quie'²³ jo̱³ ca²³dxóo² jø̱n³ mɨ́³ 'nɨ́ɨ³ 'i³ bi²³ taan³. Ca²³to'²³ tú̱²³ cu²laa'³ pii'² 'e³ ca³juɨ² hua² quí̱i̱n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","'E³ jo̱³ ca²³tøø³ Jesús dsa³ quien³². Ca²³jua'³: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Ñúun³ cɨ² mɨ³to'²³ mɨ́³ 'nɨ́ɨ³ 'i³ taan³ la³ la²³ cɨ'²³ la²³jɨn³ jia'³ cɨ'²³ dsa³ 'i³ too'²³ cuu². ");
INSERT INTO cnlNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Qui² bi²³ ñúun³ mɨ³tø'n² quie'²te'²³ 'e³ la²³ mɨ³to'²³te'²³. 'E³ quie'²³ bi²³ 'a²³'e³ xa³ quie'² 'ñée² mɨ́³ 'nɨ́ɨ³. Mɨ³to'²³ quie'²³ 'ñée² la²³'nɨɨ'n³¹ qui³ 'e³ xa³ quie'². 'A²³'e³ xa³ ca²³tø'n² quie'² 'e³ rɨ²³lí³ juø'² rɨ²³tɨ́n²³ 'e³ rɨ²³e'². ");
INSERT INTO cnlNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ca²³bǿn³ Jesús 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Xen³ jø̱n³ dsa³ quien³² 'i³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³, jóo² jmii'³¹ 'nɨɨ'n³¹ juø'²³ cu³lø³¹ cú̱u̱² 'e³ rɨ³lø³¹ 'ioo'³. Bi²³ juø'²³ cu³lø³¹ 'ñʉ́². ");
INSERT INTO cnlNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Joo³²ra'³ 'e³ bi²³ juø'²³ cu³lø³¹ 'ñʉ́² gáan³ la³, ¿mɨ³naa'³¹? 'E³ cɨ² rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ cu³xi³ co̱o̱³ cú̱u̱² 'a²³jia'³ ma²³ rɨ²³te'n²te'²³ mɨ³rɨ³jee'n³te'²³ 'ioo'³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","'E³ quie'²³ jo̱³ ŋóo² Jesús yʉʉ'³¹ mo'³ Olivos. Ca²³gua³ ji³ñín³ 'ñʉ́² gáan³. Ca³jné³ ca²³ŋɨ́ɨ³ júu² Peen²³² quia̱'² Jacobo quia̱'² Juan quia̱'² Drøø³¹. Ca²³jua'³te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Rɨ²jméen² co̱o̱³ mɨ²'áa² rɨ²juɨɨ'n³¹nu³ jnee'³¹: ¿Lɨɨ'³¹ rɨ²³lí³ 'e³ la²³ mɨ³jue'n² ca³dxa³? ¿Jmii'³¹ rɨ²³li²³lii²³ 'e³ mɨ³ rɨ²³tɨ́²³ 'e³ rɨ²³lí³ la²³jɨ³ 'e³ mɨ³'én²? ");
INSERT INTO cnlNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","'E³ jo̱³ ca²³lʉ́³ co̱'³ Jesús. Ca²³jua'³: ―Rɨ³móo³ra'³. Qui² bi²³ juø'² rɨ²³jmóo² dsa³ 'e³ rɨ²³sɨ²³caa'n³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Juɨ́ɨn²³ dsa³ 'i³ rɨ²³ja²³guín²³ 'i³ rɨ²³jua'³ 'e³ rɨ³løn³¹te'¹ jné². Rɨ²³jua'³te'²³: “Cristo jné²”. 'E³ jo̱³ rɨ²³jmóo² 'e³ rɨ²³sɨ²³caa'n³² juɨ́ɨn²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’'E³ cɨ² rɨ²núu²ra'³ 'e³ sɨ³lí³ qui³. Rɨ²³jua'³ dsa³ 'e³ mɨ³ rɨ²³lí³ qui³. 'E³ quie'²³ 'a²³jia'³ 'ne'² rɨ²juø'n¹na'³ miin²³na'³. Qui² 'ne'² rɨ²³lí³ la'³. 'E³ quie'²³ 'a²³jia'³ ca²³dsá²³ jmɨ́ɨ² mɨ³rɨ³ti³ 'e³ rɨ²³lí³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Qui² 'e³ cɨ² rɨ²³níin³ co̱o̱³ ta'n² dsa³ quia̱'² jia'³ cɨ'²³. Rɨ²³níin³ jø̱n³ dxi² juɨɨ³ quia̱'² jia'³ cɨ'²³. Ñúun³ juɨɨ³ je² rɨ²³bɨ́² 'uǿ²³. Xa³ juɨɨ³ je² li²³'oon²³ 'e³ rɨ²³e'² dsa³. 'E³ cɨ² rɨ²³roo'²³ dsa³. 'E³ quie'²³ te³ sɨ³li³láa²³ 'e³ dxi³quié̱n² dsa³ mɨ³rɨ³li³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’'E³ quie'²³ 'ne'² rɨ²jmée²ra'³ 'i'²³ 'e³ jmii'³¹ jmee³ra'³. Qui² 'e³ cɨ² rɨ²³jɨ̱'n²te'²³ 'nee'²³ quie'² dsa³ 'i³ dxa²³ ta². 'E³ cɨ² rɨ²³jmín²te'²³ 'nee'²³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. 'E³ cɨ² rɨ²nóo²ra'³ xi²ñi² dxi² juɨɨ³ pii'² quia̱'² reyes dsoo² 'e³ rɨ³løn³¹na'³ dsa³ quién²³na²³. La'³ hua² li²³xa³ 'é̱e̱² 'e³ rɨ²lʉ́²ra'³ júu² quián²³ xi²ñi²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","'Ne'² li²³'íi² júu² dxʉ́²³ 'e³ la²³ rɨ²³núu²³ la²³jɨ³ ta'n² dsa³ mɨ³¹güii³ 'e³ 'íi² rɨ²³dxá³ jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","'E³ cɨ² rɨ²³sɨ²³jøn²³te'²³ 'nee'²³ xi²ñi² dsa³ 'i³ dxa²³ ta². 'E³ cɨ² rɨ²³jɨ̱'n²te'²³ 'nee'²³. 'E³ quie'²³ 'a²³jia'³ 'ne'² rɨ²mi³ñúun²na'³ 'óo²ra'³ jén²³ cɨ² 'e³ jmii'³¹ cu³lø³¹ júu² 'e³ rɨ²lʉ́²ra'³. 'E³ quie'²³ 'a²³jia'³ 'ne'² rɨ²jmée²ra'³ 'i'²³ 'e³ jmii'³¹ cu³lø³¹ rɨ²juo'²ra'³. 'E³ quie'²³ rɨ²lʉ́²ra'³ júu² 'e³ rɨ²³'ién²na'³ mɨ³rɨ³ti³ jmɨ́ɨ². Qui² 'a²³la³ 'nee'²³ 'i³ rɨ²lʉ́²ra'³ ca³quie̱e̱². 'E³ quie'²³ Espíritu Gáan³ hua² 'i³ rɨ²³lʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","'E³ cɨ² rɨ²³jɨ̱'n² dsa³ jó̱o̱² 'e³ cu²jŋɨ'n¹te'²³. 'E³ quie'²³ la'³, rɨ²³jɨ̱'n² dsa³ jo̱o̱³¹ co̱'³. 'E³ cɨ² rɨ²³roo'²³ xii'³ ñin³² xóo² jmii³. Rɨ²³dxi³ 'i'²³ 'e³ cu²jŋɨ'n¹te'²³ xóo² jmii³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Rɨ²³lí³ 'e³ hui²³dsɨ́ɨn² ñin³² 'nee'²³ la²³jɨn³ dsa³ 'e³ jua'³te'²³ rɨ³løn³¹na'³ dsa³ quién²³na²³. 'E³ quie'²³ rɨ²³láan³ dsa³ 'i³ rɨ²³táa²³ la²³huø'n²³ rɨ²³líi². ");
INSERT INTO cnlNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’'E³ cɨ² li²³xa³ 'e³ 'a²³jia'³ ta³dsɨ³ra², 'e³ rɨ²³mi²³gua'²³ la²³jɨ³. 'E³ cɨ² rɨ²móo²ra'³ 'e³ nee'²³² je² 'a²³jia'³ joo'²³. 'E³ quie'²³ 'ne'² rɨ²³jmée²³ 'i'²³ dsa³ 'i³ rɨ²³jóo² ji³ la³. Mɨ³rɨ³ti³ 'e³ rɨ²³lí³ la'³, 'ne'² rɨ²³cuɨ̱́ɨ̱² sɨ³guín²³ je² bi²³ xa³ mo'³ dsa³ 'i³ nee'n²³² estado Judea. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","'A²³jia'³ 'ne'² rɨ²³dsø'n² xi²ñʉ'¹ dsa³ 'i³ 'iún² coo'² 'ñʉ́² 'e³ jua'³ sɨ³quie̱³ 'e³ xa³ quie'² 'e³ nee'²³² xi²ñʉ'¹. Qui² 'ne'² rɨ²³cuí̱i̱²³ xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'E³ quie'²³ la'³ 'a²³jia'³ 'ne'² rɨ²³dsø'n² co̱'³ dsa³ 'i³ jmee²³ ta² je² nuu³ 'e³ jua'³ sɨ³quié̱³ 'mɨɨ'³ dxóo³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bi²³ juɨɨ³² mɨ́³ 'i³ huǿøn³ xi³yu̱u̱n³ quie'² mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³. Bi²³ juɨɨ³² mɨ́³ 'i³ tʉ'n³² xi³yu̱u̱n³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Rɨ²juɨɨ'³¹ra'³ Dios 'e³ 'a²³la³ jo̱³ ji̱i̱³ 'e³ güi'³ mɨ³rɨ³ti³ 'e³ rɨ²cui̱i̱³¹ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bi²³ li²³xa³ u²³ŋɨ́³ dsɨ́ɨ² jmɨ́ɨ² jo̱³. Cɨ'²³ la²³ ca²³jmée³ Dios mɨ³¹güii³, 'a²³jia'³ lɨ'³ ca³la³xa³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ la²³'nɨɨ'n³¹ li²³xa³ u²³ŋɨ́³ dsɨ́ɨ² jmɨ́ɨ² jo̱³. 'E³ quie'²³ 'a²³jia'³ ma²³ li²³xa³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ca²³jmée³ Juii³ra² 'e³ li²³mi'n³ cɨ² jmɨ́ɨ² 'e³ li²³xa³ u²³ŋɨ́³ dsɨ́ɨ² la'³. Qui² 'u² cu²ru'³ 'a²³jia'³ ca²³jmée³ la'³, 'a²³'i̱³ xen³ dsa³ mɨ³¹güii³ 'i³ 'a²³jia'³ rɨ²³dxi²³jú̱n³ 'u² cu²ru'³ la'³. Ca²³jmée³ 'e³ li²³mi'n³ cɨ² jmɨ́ɨ² 'e³ li²³xa³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ jua'³ bi²³ 'néen² dsa³ 'i³ ca²³'náan²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’'E³ jo̱³ 'a²³jia'³ 'ne'² rɨ²³sɨ²³táan³na'³ xi³nu³ rɨ²³jua'³ dsa³, rɨ²³sɨ'²³ 'nee'²³: “'I³ la³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios, ¿mɨ³naa'³¹?”, xi³nu³ rɨ²³jua'³te'²³: “'I³ núu²³, ¿mɨ³naa'³¹?” ");
INSERT INTO cnlNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Qui² 'e³ cɨ² li²³xen³ dsa³ 'i³ te³ juu³² 'e³ rɨ²³jmóo² 'e³ rɨ³løn³¹te'¹ Cristo, 'e³ rɨ²³jmóo² 'e³ 'ɨɨ³te'²³ júu² quiee'³² Dios. Rɨ²³jmóo²te'²³ u²³juø'²³. Qui² 'née²³ rɨ²³júun²te'²³ dsa³ 'i³ ca²³'náan²³ Dios 'u² cu²ru'³ rɨ²³lí³ juø'² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","'E³ quie'²³ rɨ³móo³ra'³. Qui² mɨ³juǿøn²na²³ 'nee'²³ la²³jɨ³ 'e³ 'íi² rɨ²³lí³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³, mɨ³rɨ³dxi³ŋɨ́n³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ li²³xa³, rɨ²³yʉʉ³ ji³ quiee'³² ñi'². 'A²³jia'³ ma²³ li²³xa³ jmɨ́ɨ²³ quiee'³² sɨɨ'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Rɨ²³jiu'n² li²³'áan² 'i³ rɨ³pee'n³² mɨ³¹güii³. Rɨ²³bɨ́n² 'i³ 'uee'n³ 'i³ rɨ³pee'n³² mɨ³¹güii³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","'E³ quie'²³ jo̱³ rɨ²³ñín²te'²³ jné² Jo̱o̱³¹ Dsa³ 'e³ la²³ aa'n³²na²³ co̱'³ jee²³² jníi². Bi²³ 'uee'n²³na²³ mɨ³rɨ³güe'n²³na²³ co̱'³. Bi²³ gáan³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","'E³ quie'²³ jo̱³ rɨ²sɨɨn³¹na¹ ángeles quién²³na²³. La²³ca̱a̱n³ la²³ mɨ³¹güii³ la³ quia̱'² yʉʉ'³¹ güii³ rɨ²³ñii'n³te'²³ dsa³ 'i³ ca²³'náan²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’'Ne'² rɨ²jmée²ra'³ 'i'²³ 'e³ jmii'³¹ jmee²³ 'mo³ higo jo̱o̱²³na²³. Jo̱³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ 'i'²³ 'e³ jmii'³¹ cu³lø³¹ 'e³ rɨ²³güe'n²³na²³ co̱'³. Mɨ³rɨ³'aa³ 'i'²³ 'e³ sɨ³li³xi'²³ guoo³ 'mo³ higo, 'e³ sɨ³'ia³ mee³¹, jo̱³ sɨ³li³lii²³ 'e³ mɨ³ rɨ²³gua³ ji̱²³'ioo³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","'E³ quie'²³ la'³, mɨ³rɨ³móo³ra'³ 'e³ sɨ³lí³ la²³jɨ³ 'e³ mɨ³juǿøn²na²³ 'nee'²³, 'e³ jo̱³ rɨ²móo²ra'³ 'e³ mɨ³lǿ²³ mɨ³lén², 'e³ mɨ³ rɨ²³tɨ́²³ 'e³ rɨ²³güe'n²³na²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xen³ quie'²³ dsa³ 'i³ xen³ rɨ³nɨ²³ mɨ³rɨ³li³ la²³jɨ³ 'e³ mɨ³juǿøn²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","'E³ cɨ² rɨ²³lí³ 'e³ 'a²³'e³ ma²³ xa³ mɨ³¹güii³ quia̱'² 'uǿ²³ la³. 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² te³ rɨ²³gua'²³ júu² quián²³. Ca³quie̱e̱² rɨ²³lí³ 'e³ la²³ lǿ². ");
INSERT INTO cnlNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Jø̱n³ Ñu'n²³ hua² 'i³ ñi³² 'e³ 'ee² jmɨ́ɨ², 'e³ 'ee² hora 'e³ rɨ²³lí³ la'³. 'A²³'i̱³ xen³ cɨ² 'i³ ñi³², 'a²³ cɨ'²³ te'²³ ángeles 'i³ nee'n²³² yʉʉ'³¹ güii³, 'a²³ cɨ'²³ jné² Jo̱o̱³¹ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Rɨ²jmée²ra'³ 'i'²³ jo̱o̱²³na²³. Rɨ²mi³quii²³²ra'³. Rɨ²lʉ́²ra'³ quia̱'n²na'³ Dios. Qui² 'a²³jia'³ móo³ra'³ 'e³ lɨɨ'³¹ rɨ²³tɨ́²³ jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Xen³ la²³ xen³ jø̱n³ dsa³ 'i³ ŋóo² je² huɨ̱́ɨ̱³. 'E³ la²³ ca²³bǿn³ xi²ñʉ'¹ quiee'³², ca²³cuǿ³ cua̱a̱n²tu² quie'² mozos quien³². Xa³ ta² 'e³ rɨ²³jmée²³ cɨ'³ la²³ jø̱n³. Ca²³dxi³ 'i'²³ 'e³ rɨ²³mi²³quii²³² dxʉ́²³ mozo 'i³ 'aa³ 'oo'². ");
INSERT INTO cnlNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","'Ne'² rɨ²mi³quii²³²ra'³ jo̱o̱²³na²³. Qui² 'a²³jia'³ móo³ra'³ 'e³ lɨɨ'³¹ rɨ²³ja'³ co̱'³ juii² xi²ñʉ'¹, xi² rɨ²³ja'³ mɨ³rɨ³nʉʉ³, xi² rɨ²³ja'³ mɨ³rɨ³ti³ dxoo'³¹ 'uøø²³, xi² rɨ²³ja'³ mɨ³rɨ³té³ 'nɨɨ'², xi² rɨ²³ja'³ mɨ³li³jné²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bi²³ juø'² rɨ²³lí³ 'e³ co̱'³ la²³ rɨ²³güe'n²³, rɨ²³cɨ̱'n² 'e³ rɨ³guɨɨn³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","'E³ la²³ juøøn³²na²³ 'nee'²³, juøøn³² la²³jɨn³ dsa³: Rɨ²mi³quii²³²ra'³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","La²³ tú̱²³ jmɨ́ɨ² cɨ² jmee²³ 'e³ rɨ²³tɨ́²³ mɨ²juee'³ pascua quia̱'² mɨ²juee'³ je² ee'³² dsa³ 'ɨ²³juɨ² 'e³ 'a²³'e³ xa³ xoo'³¹, 'no'²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley 'e³ jmii'³¹ rɨ²³sø̱'n²te'²³ Jesús je² 'mo² je² ñi², 'e³ jmii'³¹ rɨ²³jŋɨ'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Qui² jua'³te'²³: ―'A²³jia'³ rɨ²³lí³ juø'² 'e³ rɨ²³lí³ la'³ jee²³² je² sɨ³lí³ mɨ²juee'³. Qui² bi²³ juø'² rɨ²³sɨ²³lí³ rɨ²³sɨ²³dxóo³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jen³¹ Jesús juɨɨ³ Betania xi²ñʉ'¹ quiee'³² jø̱n³ dsa³ 'i³ xi̱i̱n³ Muun³² 'i³ ca²³ji̱'²³ goo³. Jen³¹ coo³¹ mesa 'e³ la²³ ca²³dxóo² jø̱n³ mɨ́³ 'i³ quie̱³ mɨ²sɨ́¹ 'e³ rɨ³lø³¹ cú̱u̱² 'e³ xi̱i̱n³ alabastro 'e³ 'o² noo²³² mɨ³róo³. Jmø'n² la²³ noo²³² 'e³ xi̱i̱n³ nardo rɨ³lø³¹. Bi²³ quí̱i̱n²³ 'e³ jo̱³. 'E³ quie'²³ jo̱³ su̱'² mɨ²sɨ́¹ mɨ́³ 'í³. Ca²³'uu²³ noo²³² mɨ²dxi² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","'E³ quie'²³ xen³ 'i³ nee'n²³² núu²³ 'i³ ca²³ti̱'n³. Ca²³sɨ'²³ uu'n² la²³ co̱³quie'²: ―¿'Ee² lǿ² mɨ³mi³gua'²³ noo²³² mɨ́³ la³ cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bi²³ dxʉ́²³ 'u² cu²ru'³ ca²³'nɨ́ɨ³ 'u². Bǿn³ cɨ² la²³'nɨɨ'n³¹ jñiin²³ dsa³ 'e³ 'nɨ³ i³lóo³ jmɨ́ɨ² ta² ca²³tɨ́n³ 'u² cu²ru'³ 'e³ ca²³'nɨ́ɨ³ hua² 'u². 'E³ jo̱³ ca²³lǿ²³ juø'² ca²³cuǿø²³ dsa³ taan³ 'u² cu²ru'³ la'³. 'E³ jo̱³ ca²³jín²te'²³ mɨ́³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","'E³ quie'²³ ca²³jua'³ Jesús: ―'A²³ jin²³na'³ mɨ́³. ¿'Ee² lǿ² cuøø³²ra'³ u²³ŋɨ́³ dsɨ́ɨ²? Qui² bi²³ dxʉ́²³ 'e³ mɨ³jme'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tén³ xen³ dsa³ taan³ jee²³² quien³²na'³. Xa³ 'é̱e̱² 'e³ rɨ²jmée²ra'³ co̱²juø'¹ quie'²te'²³ te³ lɨɨ'³¹ 'noo³ra'³ 'e³ rɨ²jmée²ra'³ la'³. 'E³ quie'²³ 'a²³jia'³ tén³ jen³¹na¹ jné² quia̱'n²³²na¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Qui² mɨ³jmée³ mɨ́³ la³ 'e³ la²³'nɨɨ'n³¹ 'e³ mɨ³lǿ²³ juø'² quie'². Mɨ³'uun³ jné² noo²³² mɨ³róo³. Mɨ³mi³tɨ́ɨ²³ quie'² jmɨn²³ ŋun²³ jén²³ cɨ² 'e³ la²³ rɨ²³'áan²te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Te³ jiaa'³¹ rɨ²³'ɨ́ɨ²³ dsa³ júu² dxʉ́²³ la²³ca̱a̱n³ mɨ³¹güii³, rɨ²³jua'³te'²³ 'e³ jmii'³¹ mɨ³jmée³ mɨ́³ la³ 'e³ la²³ li²³líi²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","'E³ jo̱³ ŋóo² Judas Iscariote, jø̱n³ dsa³ gui²³tʉ̱́n³. I²lʉ² quia̱'² te'²³ juii² jmii³ dsa³ 'e³ jua'³ rɨ²³'nɨ́ɨn²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","'E³ quie'²³ jo̱³ bi²³ 'née²³ te'²³ jmii³ dsa³ ma²ca¹núu³te'²³ júu² quiee'³² Judas. Ca²³jua'³te'²³ 'e³ rɨ²³quí²te'²³ jñiin²³. 'E³ jo̱³ 'no'² Judas 'e³ jmii'³¹ li²³tɨ́ɨ²³ rɨ²³jɨ̱'n² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ca²³tɨ́³ jmɨ́ɨ² 'e³ ca²³la²³láa²³ mɨ²juee'³ 'e³ ee'³² dsa³ 'ɨ²³juɨ² 'e³ 'a²³'e³ xa³ xoo'³¹, 'e³ quie'²³ jmɨ́ɨ² 'e³ jŋɨ'n²³te'²³ dsɨɨ³ joo³ 'i³ rɨ²³cu'n³te'²³ mɨ²juee'³ pascua. 'E³ jo̱³ ca²³jua'³ dsa³ quien³². Ca²³sɨ'²³ Jesús: ―¿Jiaa'³¹ 'naan³ 'e³ sɨ³gui²³ra'³¹ 'e³ sɨ³mi³tɨ́ɨ²³ra'³¹ 'e³ rɨ²quiu'n²na² dsɨɨ³ joo³ 'i³ cu'n³ dsa³ mɨ²juee'³ pascua? ");
INSERT INTO cnlNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","'E³ jo̱³ ca²³xíin²³ áan²³ dsa³ quien³². Ca²³jua'³: ―Cu³guín²³na'³ jee²³² juɨɨ³. Núu²³ rɨ²³mi²³jí̱i̱n³ 'nee'²³ jø̱n³ dsa³ 'i³ quie̱³ mɨ²dsuu² 'e³ 'o² jmɨɨ³. Guoo³²ra'³ quia̱'n²na'³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","'E³ quie'²³ jo̱³ rɨ²juɨɨ'³¹ra'³ juii² xi²ñʉ'¹ je² rɨ²³'í³ dsa³ 'í³: “Jua'³ dsa³ 'e²³ 'e³ 'ee² co̱²³ju'²³ je² rɨ²³e'² mɨ²³'láa²³ pascua quia̱'² dsa³ quien³²”. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jo̱³ rɨ²³'ée²³ 'nee'²³ co̱o̱³ co̱²³ju'²³ bee'² yʉʉ'³¹ je² dxi²³juɨn³¹ je² mɨ³jmóo²te'²³ dxʉ́²³, je² mɨ³mi³tɨ́ɨ²³te'²³. Núu²³ rɨ²jmée²ra'³ ji̱i̱³ la²³jɨ³ 'e³ li²³'ne'² quiée²ra². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","'E³ quie'²³ jo̱³ ca²³ta'n²³ jui³¹ dsa³ quien³². I²guín¹te'²³ jee²³² juɨɨ³. Ca²³lǿ²³ 'e³ la²³ ca²³jua'³ Jesús 'e³ rɨ²³lí³. Ca²³mi²³tɨ́ɨ²³te'²³ la²³jɨ³ 'e³ li²³'ne'² mɨ³rɨ³ti³ mɨ²juee'³ pascua. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ma²mɨ³la³'uøø²³, ca²³dxóo² Jesús quia̱'² dsa³ gui²³tʉ̱́n³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","'E³ la²³ nee'n²³²te'¹ ee'³²te'²³ coo³¹ mesa, ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xen³ jø̱n³ 'nee'²³ 'i³ ee'n²³ quia̱'n²³²na¹ 'i³ rɨ²³'nɨ́ɨn²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","'E³ jo̱³ ca²³ŋɨ́³ dsɨ́²te'²³. Ca²³sɨ'²³te'²³ Jesús cɨ'³ jø̱n³, cɨ'³ jø̱n³: ―¿'A² juø'² jné²? Jia'³ cɨ'²³ ca²³jua'³ co̱'³: ―¿'A² juø'² jné²? ");
INSERT INTO cnlNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","'E³ jo̱³ ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ quien³²: ―Jø̱n³ 'nee'²³ dsa³ gui²³tʉ̱́n³ hua² 'í³, jø̱n³ 'i³ ee'n²³ quia̱'n²³²na¹ 'i³ 'a'²³ 'ɨ²³juɨ² quiee'³² 'e̱'³ huɨ̱́ɨ̱²³ je² ee'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sɨ³jí̱i̱n²³ jné² Jo̱o̱³¹ Dsa³ 'e³ la²³ lǿ² 'e³ to̱o̱²³ ji³ 'e³ rɨ²³jí̱i̱n²³. 'E³ quie'²³ bi²³ juɨɨ³² dsa³ 'i³ 'nɨɨn²³ jné² Jo̱o̱³¹ Dsa³. Bi²³ cɨ² dxʉ́²³ quie'² dsa³ 'í³ 'u² cu²ru'³ 'a²³jia'³ ca²³la²³xen³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","'E³ la²³ ee'³²te'²³, so̱'²³ 'ɨ²³juɨ² Jesús. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. Ca²³xíin² 'ɨ²³juɨ². Ca²³cuǿø²³ dsa³ quien³². Ca²³jua'³: ―Quie̱³ra'³ 'ɨ²³juɨ² la³ 'e³ rɨ³lø³¹ jmɨn²³ ŋun²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","'E³ quie'²³ jo̱³ so̱'²³ co̱o̱³ taza 'e³ 'o² jmɨɨ'³¹ mɨ²jø'² vino co̱'³. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. 'E³ jo̱³ ca²³cuǿø²³ dsa³ quien³². 'Ɨ̱'²³ la²³jɨn³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","'E³ quie'²³ jo̱³ ca²³jua'³: ―'E³ la³ jmɨ²³'øn²³²na¹ 'e³ rɨ²³jmée²³ quí̱i̱n²³ júu² 'mɨɨn³² quiee'³² Dios. Qui² rɨ²³tʉ̱ʉ̱³ jmɨ²³'øn²³²na¹ 'e³ la²³ rɨ²³yʉʉ³ dsoo² quiee'³² juɨ́ɨn²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³jia'³ ma²³ rɨ²uu'n²³² co̱'³ jmɨɨ'³¹ mɨ²jø'² vino la²³huø'n²³ 'e³ rɨ²³tɨ́²³ 'e³ rɨ²uu'n²³² jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'mɨɨn³² je² rɨ³løn³¹ Dios juii². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ca²³'é³te'²³ co̱o̱³ su̱u̱n³² 'e³ 'en³² Dios. 'E³ jo̱³ ca²³guín²³te'²³ mo'³ Olivos. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'Uøø²³ 'e³ rɨ³nɨ²³ rɨ²³'lǿn²³na'³ la²³jɨn³na'³. Qui² to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: “Rɨ²jŋɨ'n³¹na¹ dsa³ 'i³ mi³quin³ dsɨɨ³ joo³. 'E³ jo̱³ rɨ²³sáan²³ rɨ²³jǿn²³ dsɨɨ³ joo³ quien³².” ");
INSERT INTO cnlNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","'E³ quie'²³ ma²mɨ³'áa³ 'i'²³ 'e³ mɨ³ji̱i̱'n²³na²³ co̱'³, ñiin²³ estado Galilea jén²³cɨ²na¹ la²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","'E³ quie'²³ ca²³jua'³ Peen²³². Ca²³sɨ'²³ Jesús: ―Juø'n³ quie'²³ rɨ²³'lǿn²³ la²³jɨn³, 'a²³jia'³ jmɨ́ɨ² rɨ²³'lǿn²³na²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³²: ―Rɨ²juøøn³¹na¹ 'nʉ³ ju²dsoo³¹: 'Uøø²³ 'e³ rɨ³nɨ²³, 'e³ 'íi² rɨ²³tɨ́²³ tú̱²³ taa'² 'e³ tø³² 'nɨɨ'², rɨ²juɨɨ'n³¹ dsa³ 'nɨ³ taa'² 'e³ 'a²³jia'³ cuiin²³nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","'E³ quie'²³ 'e³ dxaa'n³¹ dsɨ́² Peen²³² ca²³jua'³: ―Juø'n³ quie'²³ 'ne'² 'e³ rɨ²³jú̱n³na²³ quia̱'n²³²na¹ 'nʉ³, 'a²³jia'³ jmɨ́ɨ² rɨ²juøøn³¹ dsa³ 'e³ 'a²³jia'³ cuiin²³na²³ 'nʉ³. 'E³ quie'²³ la'³ ca²³jua'³ la²³jɨn³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","'E³ quie'²³ jo̱³ ca²³dxi²³guín²³te'²³ je² xi̱i̱n³ Getsemaní. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Ñí³ra'³ je² la³ la²³huø'n²³ i³lʉn²³ quia̱'n²³²na¹ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","'E³ quie'²³ jo̱³ ŋóo² quia̱'² Peen²³² quia̱'² Jacobo quia̱'² Juan. 'E³ jo̱³ láa²³ ca²³ŋɨ́³ dsɨ́². Ca²³la²³cuu'²³ dsɨ́². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","'E³ quie'²³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ quia̱'²: ―Rɨ²³jú̱n³la²³cɨ²na¹ la²³'nɨɨ'n³¹ 'e³ ŋɨ́³ dsɨn²³. Rɨ²cuaa'n²³na'³ je² la³. Rɨ²mi³quii²³²ra'³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ŋóo² cɨ² ca³juɨ² 'ñée². 'E³ jo̱³ ca²³quiaa³ 'uǿ²³. Ca²³lʉ́³ quia̱'² Dios. Ca²³ŋɨ́ɨ³ 'e³ 'a²³jia'³ rɨ²³ji̱'²³ 'e³ la²³ mɨ³tɨ́³ 'e³ rɨ²³ji̱'²³ xi³nu³ rɨ²³lí³ juø'² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","―Ñu'n² ―ca²³jua'³ ca²³sɨ'²³ Jmii³―, sɨ³lí³ juø'² jmeen³ la²³jɨ³. Cuø² júu² 'e³ 'a²³jia'³ rɨ²³jí̱i̱n²³ 'e³ la²³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jí̱i̱n²³. 'E³ quie'²³ 'a²³ cu²lí³ 'e³ la²³ 'náan²³ 'ñáan²³. 'E³ quie'²³ cu²lí³ 'e³ la²³ 'naan³ 'uǿøn²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","'E³ quie'²³ jo̱³ ca²³dxe'n² co̱'³ je² nee'n²³² dsa³ quien³². 'E³ quie'²³ rɨ³guɨɨn³te'²³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ Peen²³²: ―Muun³², ¿'a² mɨ³guɨɨn³nu³? ¿'A² 'a²³jia'³ ca³lǿ²³ juø'² ca³mi³quiin²³² cu³xi³ co̱o̱³ hora? ");
INSERT INTO cnlNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","'Ne'² rɨ²mi³quii²³²ra'³ xú̱n³. 'Ne'² rɨ²lʉ́²ra'³ quia̱'n²na'³ Dios 'e³ la²³ 'a²³jia'³ rɨ²³te'n²³na'³ 'e̱'³ lá³ je² juø'² rɨ²jmée²ra'³ 'e³ xa³ dsoo² quien³²na'³. Dxʉ́²³ 'óo²ra'³ 'e³ rɨ²jmée²ra'³ 'e³ dxʉ́²³ 'u². 'E³ quie'²³ 'a²³jia'³ 'uee'n³ jmɨ² ŋú²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","'E³ jo̱³ ŋóo² co̱'³ Jesús. I²lʉ² quia̱'² Dios. 'E³ la²³ lǿ² júu² 'e³ ca²³lʉ́³ xe̱'n², 'e³ quie'²³ la'³ cu³lø³¹ júu² ca²³lʉ́³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Co̱'³ cɨ'²³ ca²³dxe'n² je² nee'n²³² dsa³ quien³². 'E³ quie'²³ rɨ³guɨɨn³te'²³. Qui² sɨ³'mí²³ la²³ cɨ² mɨ²ñi²te'¹ la²³'nɨɨ'n³¹ 'e³ la²³guɨɨn³te'²³. 'E³ jo̱³ 'a²³jia'³ ñi³²te'²³ 'e³ jmii'³¹ cu³lø³¹ rɨ²³sɨ'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","'E³ quie'²³ jo̱³ ca²³dxe'n² co̱'³ je² ca²³tɨ́³ 'nɨ³ taa'². Ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―¿'A² rɨ³guɨɨn³quien²³na'³? ¿'A² tøø³²quie²³ra'³ 'óo²ra'³? Mɨ³líi² la²³'nɨɨ'n³¹ nɨ³. Qui² mɨ³tɨ́³ hora. Mɨ³'nɨ́ɨn²³te'²³ jné² Jo̱o̱³¹ Dsa³ quie'² dsa³ 'i³ 'a²³jia'³ dxʉ́²³ jmoo³². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Naa'n²³na'³. Sɨ³gui²³²ra². Qui² mɨ³ ja³'ɨ́ɨn²³ dsa³ 'i³ mɨ³'nɨ́ɨn²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Lʉ²³ quie'²³ Jesús 'e³ la²³ ca²³dxóo² Judas, jø̱n³ dsa³ gui²³tʉ̱́n³. Ca²³dxóo² quia̱'² juɨ́ɨn²³ dsa³ 'i³ xe̱e̱'³ boo'³¹ quia̱'² 'i³ xe̱e̱'³ 'mo³ 'i³ ca²³xíin²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley quia̱'² te'²³ dsa³ mɨ³dxún²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ca²³jua'³ dsa³ 'i³ ca²³'nɨ́ɨn²³ Jesús 'e³ jmii'³¹ rɨ²³jmée²³ lii²³ 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³sø̱'n²te'²³. Ca²³jua'³: ―Dsa³ 'i³ rɨ²cu'n²³² ñi² hua² 'í³. 'I³ 'í³ hua² rɨ²jmø'n¹na'³. Rɨ²'áan¹na'³ dxʉ́²³ mɨ³rɨ³tøø³²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","'E³ quie'²³ jo̱³ ma²ca¹dxóo¹ Judas, xe̱'n² jmɨ́ɨ² ŋóo² caan²³ Jesús. Ca²³jua'³: ―Dsa³ 'e²³. 'E³ jo̱³ ca²³cuu'³ ñi² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ca²³dxi²³guín²³ dsa³. Sø̱'n²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","'E³ quie'²³ sø'n² boo'³¹ jø̱n³ dsa³ 'i³ xi'n²³ coo³¹. Ca²³quiu'n² mozo quien³² juii² jmii³ dsa³. Ca²³quiʉ'² lo³guo². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³: ―¿'A² juø'² lǿn³na'³ 'e³ dsa³ 'i̱i̱³ hua² jné²? Qui² 'e³ xe̱'²ra'³ boo'³¹, xe̱'²ra'³ 'mo³ 'e³ juo'³ra'³ rɨ²jmø'n¹na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","La²³jɨ³ jmɨ́ɨ² jen³¹na¹ quia̱'n²³²na¹ 'nee'²³ ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ dsa³ Dios 'e³ 'een²³na²³ dsa³. 'E³ quie'²³ 'a²³jia'³ ca²³xe̱'n²³na'³ jné². 'E³ quie'²³ cu²lí³ 'e³ la²³ to̱o̱²³ ji³ júu² quiee'³² Dios 'e³ rɨ²³lí³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","'E³ jo̱³ ca²³tʉ́n² Jesús la²³jɨn³ dsa³ quien³². Ca²³cuɨ̱́ɨ̱²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","'E³ quie'²³ jo̱³ ca²³qui̱'³ Jesús jø̱n³ xii'³. 'Nɨɨ'n³¹ 'mɨɨ'³ sɨɨ³² rɨ³pee'n³² xii'³. 'E³ quie'²³ sø̱'n²te'²³ xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","'E³ jo̱³ ca²³tʉ́² quie'²³ 'mɨɨ'³ sɨɨ³². Cu³laan³ ca²³cuí̱i̱²³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","'E³ quie'²³ jo̱³ i²jøn²³te'²³ Jesús xi²ñi² juii² jmii³ dsa³. 'E³ quie'²³ rɨ³ŋɨɨn³¹ la²³jɨn³ juii² jmii³ dsa³ quia̱'² dsa³ mɨ³dxún²³ quia̱'² dsa³ 'e²³ ley. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","'E³ quie'²³ bi²³ huɨ̱́ɨ̱³ tu³cɨ̱ɨ̱n³ Peen²³². Tu³cɨ̱ɨ̱n³ quie'²³ la'³ xi³'lɨ² 'í² je² rɨ³jnɨ³ xi²dxi³² quie'² juii² jmii³ dsa³. Ca²³gua³ quia̱'² dsa³ 'láa³. Ca²³dxo'²³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mi³tɨ́ɨ²³ dsa³ 'i³ rɨ²³cuǿ²³ dsoo² quiee'³² Jesús te'²³ juii² jmii³ dsa³ quia̱'² la²³jɨn³ dsa³ 'i³ dxa²³ ta². Qui² 'née²³te'²³ rɨ²³jŋɨ'n²³te'²³. 'E³ quie'²³ 'a²³jia'³ ca²³lǿ²³ juø'², juø'n³ quie'²³ juɨ́ɨn²³ xen³ 'i³ ca²³júu² 'e³ la²³ ca²³lǿn²³te'²³ dsa³ ñi³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Qui² 'a²³jia'³ jmɨ́ɨ² ca²³lʉ́³te'²³ co̱o̱³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Xen³ 'i³ ca²³noo³ 'i³ ca²³júu² 'e³ la²³ ca²³lǿn²³te'²³ dsa³ ñi³. Ca²³jua'³te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ca²³nʉʉ²ra'³¹ ma²ca¹jua'³: “Rɨ²yaan²³²na¹ 'ñʉ́² gáan³ 'e³ ca²³jmée³ guoo³ dsa³. Je² 'nɨ³ jmɨ́ɨ² rɨ²jmeen²³² jia'³ cɨ'²³ 'e³ 'a²³la³ ma²³ guoo³ dsa³ rɨ²³jmée²³.” ");
INSERT INTO cnlNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","'E³ quie'²³ juø'n³ quie'²³ 'e³ jo̱³, 'a²³jia'³ ca²³lʉ́³te'²³ co̱o̱³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","'E³ quie'²³ jee²³² jo̱³ ca²³naa'n²³ juii² jmii³ dsa³. Ca²³ŋɨ'²³ júu² Jesús. Ca²³jua'³: ―¿'A² 'a²³jia'³ rɨ²jme'n²³nu³ júu² 'e³ jmii'³¹ lǿ² dsoo² 'e³ mɨ³cuǿ³ quién²nu³ dsa³ ñi³? ");
INSERT INTO cnlNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","'E³ quie'²³ 'a²³'e³ xa³ 'e³ ca²³jua'³ Jesús. Co̱'³ cɨ'²³ ca²³ŋɨ́ɨ³ júu² juii² jmii³ dsa³. Ca²³jua'³: ―¿'A² rɨ³løn³¹nu³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios? ¿'A² rɨ³løn³¹nu³ Jo̱o̱³¹ Dios 'i³ bi²³ mi³gáan³te'²³? ");
INSERT INTO cnlNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","'E³ jo̱³ ca²³jua'³ Jesús: ―'I³ 'í³ jné². 'E³ cɨ² rɨ²mǿn¹na'³ jné² Jo̱o̱³¹ Dsa³ 'e³ jen³¹na¹ jaan²³ 'e³ dxʉ́²³ Dios 'i³ bi²³ 'uee'n³. 'E³ cɨ² rɨ²mǿn¹na'³ jné² 'e³ la²³ aa'n³²na²³ co̱'³ jee²³² jníi² 'e³ taa'² mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","'E³ quie'²³ jo̱³ ca²³xíin² ca³juɨ² cuo̱o̱³ juii² jmii³ dsa³. Ca²³jua'³: ―'A²³jia'³ ma²³ 'ne'² cɨ² dsa³ ñi³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mɨ³nʉʉ³ra'³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'ñe'² mɨ³lʉ́³ dsa³ la³. Jua'³ 'ñée² 'e³ jmee²³ 'e³ la²³ jmee²³ Dios. ¿Jmii'³¹ lǿn³na'³ jo̱o̱²³na²³? 'E³ jo̱³ ca²³jua'³ la²³jɨn³te'²³ 'e³ xa³ dsoo² quiee'³² 'e³ ya̱'n³ rɨ²³jú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Xen³ 'i³ ca²³'ø'n² Jesús. Ca²³'mée²te'²³ mɨ²ñi². Ca²³cuǿ³te'²³ quie'². Ca²³jua'³te'²³: ―Jmee² júu² 'e³ 'i̱i̱² sɨɨ'³¹ mɨ³cuǿ³ quién²nu³. 'E³ quie'²³ la'³ ca²³cuǿ³ quie'² Jesús dsa³ 'láa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","'Iin²³ quie'²³ Peen²³² je² 'uǿn²³ je² rɨ³jnɨ³ xi²dxi³². Ca²³dxóo² jø̱n³ moza quien³² juii² jmii³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ŋǿn² Peen²³² 'e³ la²³ dxo'²³ ji³. Ca²³jóon² dxʉ́²³ Peen²³². Ca²³jua'³: ―Mɨ³ŋɨ́n² quia̱'n²nu³ Jesús dsa³ Nazaret 'uǿøn²nu³ co̱'³, ¿na'²? ");
INSERT INTO cnlNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","'E³ quie'²³ ca²³jua'³ Peen²³² 'a²³jia'³ 'e̱'n³: ―'A²³jia'³ cuiin²³na²³ dsa³ 'í³. 'A²³jia'³ ta³jmeen²³ 'i'²³ 'e³ 'ee² lǿ² juø'n³ la'³. 'E³ quie'²³ jo̱³ ŋóo² 'oo'² je² rɨ³jnɨ³. Tǿ²³ 'nɨɨ'² jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","'E³ quie'²³ co̱'³ cɨ'²³ ŋǿn² Peen²³² moza. Ca²³lʉ́³ co̱'³. Ca²³sɨ'²³ dsa³ 'i³ té̱e̱n³ coo³¹: ―Rɨ³løn³¹ dsa³ la³ jø̱n³ dsa³ quien³² Jesús, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","'E³ quie'²³ co̱'³ cɨ'²³ ca²³jua'³ Peen²³² 'e³ 'a²³jia'³ 'e̱'n³. 'E³ quie'²³ cɨ̱ɨ̱n³ cɨ² ca³juɨ² co̱'³ ca²³jua'³ dsa³ 'i³ té̱e̱n³ coo³¹. Ca²³sɨ'²³ Peen²³²: ―'E̱'n³ ca³quie̱e̱² 'e³ rɨ³løn³¹nu³ dsa³ quien³². Qui² rɨ³løn³¹nu³ dsa³ Galilea. Lii²³ 'e³ la²³ lʉ́n². ");
INSERT INTO cnlNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","'E³ quie'²³ ca²³jua'³ Peen²³²: ―Cu²jmée³ jñiin²³na²³ Dios xi³nu³ te³ juun²³². Qui² 'a²³jia'³ jmɨ́ɨ² cuiin²³na²³ dsa³ 'i³ 'ǿn²³na'³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Xe̱'n² quie'²³ jo̱³ tǿ²³ 'nɨɨ'² je² ca²³tɨ́³ tú̱²³ taa'². 'E³ jo̱³ ca²³la²³líi²³ Peen²³² 'e³ la²³ lǿ² 'e³ ca²³jua'³ Jesús: “'E³ 'íi² rɨ²³tɨ́²³ tú̱²³ taa'² 'e³ tø³² 'nɨɨ'², rɨ²juɨɨ'n³¹ dsa³ 'nɨ³ taa'² 'e³ 'a²³jia'³ cuiin²³nu³ jné²”. 'E³ quie'²³ ma²ca¹la¹líi¹ Peen²³² júu² jo̱³, bi²³ ca²³'o'². ");
INSERT INTO cnlNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Xe̱'n² 'e³ la²³ ca²³la²³jné²³, ca²³ŋɨɨ'n²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ mɨ³dxún²³ quia̱'² te'²³ dsa³ 'e²³ ley quia̱'² la²³jɨn³ dsa³ 'i³ dxa²³ ta². Ca²³sɨ́n²³te'²³ júu² 'e³ jmii'³¹ rɨ²³jmóo²te'²³. 'E³ jo̱³ ca²³'ñúun²³te'²³ Jesús. I²jøn²³te'²³ caan²³ Pilato. Ca²³cuaa'n³te'²³ guoo³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","'E³ quie'²³ jo̱³ ca²³jua'³ Pilato. Ca²³sɨ'²³ Jesús: ―¿'A² rey quien³² dsa³ Israel hua² 'nʉ³? 'E³ jo̱³ ca²³jua'³ Jesús: ―La'³ cu³lø³¹ 'e³ la²³ mɨ³jue'n² 'uǿøn²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","'E³ quie'²³ jo̱³ bi²³ ñúun³ 'iin³² dsoo² 'e³ ca²³cuǿ³ quie'² Jesús te'²³ juii² jmii³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","'E³ jo̱³ co̱'³ cɨ'²³ ca²³tín²³ júu² Pilato. Ca²³jua'³: ―¿'A² 'a²³jia'³ rɨ²jméen² júu²? Qui² bi²³ ñúun³ la²³jɨ³ dsoo² 'e³ cuø²³te'²³ quién²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","'E³ quie'²³ 'a²³jia'³ ma²³ ca²³'í̱n² Jesús. 'E³ jo̱³ bi²³ juø'²³ ca²³ti²³cø̱n³¹ Pilato. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Xa³ tɨ³² 'i'²³ quiee'³² Pilato 'e³ jmee²³ cɨ'³ la²³ co̱o̱³ ji̱i̱³ ñi³ 'e³ la²³ sɨ³tɨ́²³ mɨ²juee'³ pascua: To̱'²³ laan³² jø̱n³ dsa³ 'i³ 'iún² i²³ñí². Laan³² te³ 'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³'én² dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mɨ²jo̱³ xen³ dsa³ 'i³ ta'n² i²³ñí² 'i³ ca²³roo'²³ ñin³² dxi² juɨɨ³, 'i³ ca²³jmóo² 'móo². Barrabás xi̱i̱n³ jø̱n³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","'E³ quie'²³ jo̱³ ca²³lǿn²³ mɨ³lén² dsa³ juɨɨ³. Ca²³ŋɨ'²³te'²³ Pilato 'e³ rɨ²³jmée²³ 'e³ la²³ to̱'²³ jmee²³ 'e³ dxin³ jø̱n³ dsa³ quie'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","'E³ jo̱³ ca²³jua'³ Pilato: ―¿'A² 'noo³ra'³ 'e³ rɨ²láan¹na²³ quién²na'³ 'i³ sɨ'²³te'²³ rey quien³² dsa³ Israel? ");
INSERT INTO cnlNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","La'³ ca²³jua'³ Pilato. Qui² ñi³² 'e³ hui²³dsɨ́ɨn²te'²³ ñin³²te'²³ Jesús 'e³ jua'³te'²³ bi²³ nuu³ dsa³ júu² quiee'³². 'E³ jo̱³ hua² 'e³ ca²³jɨ̱'n² Jesús te'²³ juii² jmii³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bi²³ ca²³too'n³ júu² dsa³ juɨɨ³ te'²³ juii² jmii³ dsa³. 'E³ jo̱³ ca²³ŋɨ'²³te'²³ Pilato 'e³ 'a²³jia'³ rɨ²³dxin³ Jesús, 'e³ Barrabás hua² rɨ²³dxin³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","'E³ jo̱³ ca²³jua'³ co̱'³ Pilato. Ca²³sɨ'²³ dsa³: ―¿Jmii'³¹ 'noo³ra'³ 'e³ rɨ²jme'n¹na²³ dsa³ 'i³ juɨɨ'³²ra'³ rey quien³² dsa³ Israel jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","'E³ jo̱³ ca²³lʉ́³te'²³ quiʉ̱ʉ̱³. Ca²³jua'³te'²³: ―¡Te̱e̱n²³² cruz! ");
INSERT INTO cnlNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","'E³ jo̱³ ca²³jua'³ Pilato. Ca²³sɨ'²³ dsa³: ―¿'Ee² lǿ²? ¿'Ee² dsoo² 'e³ mɨ³jmée³? 'E³ quie'²³ dsɨ³² cɨ² 'uaa'³ ca²³jua'³te'²³: ―¡Te̱e̱n²³² cruz! ");
INSERT INTO cnlNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","'Née²³ Pilato rɨ²³jmée²³ 'e³ la²³ ŋɨɨ²³ dsa³ juɨɨ³. 'E³ jo̱³ ca²³dxin³ Barrabás. Ca²³dxi³ 'i'²³ 'e³ rɨ²³jmín²te'²³ Jesús. 'E³ jo̱³ ca²³jɨ̱ɨ̱'n³ dsa³ 'i³ rɨ²³te̱e̱n³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","'E³ jo̱³ ca²³tøø³ Jesús dsa³ 'láa³. I²jøn²³te'²³ 'é̱² ta² quiee'³² dxi² juɨɨ³ je² xi̱i̱n³ pretorio. Ca²³ñii'n³te'²³ caan²³ Jesús co̱o̱³ ta'n² dsa³ 'láa³ 'i³ bi²³ juɨ́ɨn²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ca²³qui'n²te'²³ Jesús 'mɨɨ'³ 'e³ yʉ̱́ʉ̱³ laa'³. Ca²³jmóo²te'²³ co̱o̱³ jmíi² guoo³ tó̱o̱² 'e³ ca²³jmóo²te'²³ lɨɨ'² sɨɨ³. To̱'²te'²³ mɨ²dxi² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","'E³ quie'²³ jo̱³ ca²³cuǿ³te'²³ u²³juee'n³¹ quia̱'²te'²³. Ca²³jua'³te'²³: ―¡Que viva rey quien³² dsa³ Israel! ");
INSERT INTO cnlNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Có̱²³te'²³ co̱o̱³ sɨɨ². Ca²³jmí²te'²³ mɨ²dxi². Ca²³'ø'n²te'²³. Ca²³xii'³te'²³ jñi²te'¹ xi²ñi². ");
INSERT INTO cnlNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","'E³ quie'²³ ma²mɨ³líi² mɨ³jáa² mɨ³ŋɨ́ɨn²te'²³, ca²³dxin³te'²³ 'mɨɨ'³ 'e³ yʉ̱́ʉ̱³ laa'³. Ca²³qui'n²te'²³ co̱'³ cuo̱o̱³ 'ñée². Ca²³jøn²³te'²³ 'e³ jua'³ rɨ²³te̱e̱n³te'²³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Xen³ jø̱n³ dsa³ 'i³ xen³ juɨɨ³ Cirene 'i³ xi̱i̱n³ Muun³² 'i³ sɨ³ŋɨ́n³ 'e³ jua'³ ñíin² je² nuu³, 'e³ quie'²³ jmii³ te'²³ dsa³ 'i³ xi̱i̱n³ Jaan² quia̱'² Rufo. 'E³ quie'²³ jo̱³ ca²³dxi³te'²³ 'i'²³ 'e³ rɨ²³có̱² cruz 'e³ rɨ²³te̱e̱n³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","'E³ jo̱³ i²jøn²³te'²³ Jesús je² xi̱i̱n³ Gólgota. Qui² la²³ lǿ² mee²³ cua'² mɨ²dxi² dsa³ lǿ² je² núu²³. La'³ cu³lø³¹ 'née²³ rɨ²³jua'³ Gólgota ju²³jmii²³² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ca²³ji̱i̱'n³te'²³ Jesús jmɨɨ'³¹ mɨ²jø'² vino 'e³ rɨ³coo'n³² xʉ̱³ 'e³ xi̱i̱n³ mirra. 'E³ quie'²³ 'a²³jia'³ 'ɨ̱'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","'E³ quie'²³ jo̱³ ca²³te̱e̱n³te'²³ cruz. Ca²³to'²³te'²³ dxóo² 'mɨɨ'³ quiee'³². Xa³ mɨɨ³¹ 'e³ ca²³co'²te'²³ 'e³ la²³ rɨ²³'aa²³ 'i'²³ 'e³ 'i̱i̱² sɨɨ'³¹ li²³røøn³ 'e³ rɨ²³co̱o̱²³ cɨ'³ la²³ co̱o̱³ 'noo³¹ 'mɨɨ'³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mɨ³tɨ́³ hora 'e³ ñʉ́²³ ma²ca¹te̱e̱n³te'²³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ca²³té̱e̱²te'²³ 'uø'² 'e³ jmee²³ júu² 'ee² dsoo² 'e³ jŋɨ'n²³te'²³. To̱o̱²³ 'uø'² 'e³ jua'³: “Rey quien³² dsa³ Israel”. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Xen³ áan²³ dsa³ 'i̱i̱³ 'i³ ca²³te̱e̱n³te'²³ cruz jaan²³ i²³la³ i²³nɨ³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","'E³ jo̱³ ca²³lǿ²³ 'e³ la²³ to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: “Dsa³ 'i³ jmee²³ tu³cua̱a̱n²tu², lǿn³te'²³”. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bi²³ 'ñe'² ca²³lʉ́³ dsa³ 'i³ ca²³ŋɨ́n³ je² ta̱a̱n²³ cruz. Ca²³bí² mɨ²dxi²te'¹. Ca²³jua'³te'²³: ―Bi²³ dxʉ́²³, ¿na'²? 'Naan³ rɨ²yaan²³²nu³ 'ñʉ́² gáan³ je² mi³gáan³ dsa³ Dios. Juø'n³ 'e³ je² 'nɨ³ jmɨ́ɨ² rɨ²jméen² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Rɨ²láan¹nu³ 'uǿøn²nu³. Rɨ²jiaan³²nu³ je² ta̱a̱n²³nu³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","'E³ quie'²³ la'³ ca²³jáa² ca²³ŋɨ́ɨ² te'²³ juii² jmii³ dsa³ i²³la³ i²³nɨ³ ca³ti³² quia̱'² te'²³ dsa³ 'e²³ ley. Ca²³jua'³te'²³: ―Ca²³láan² dsa³, jua'³. 'E³ quie'²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³láan² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cu²jiaan³² xe̱'n² rɨ³nɨ²³ je² ta̱a̱n²³ cruz Cristo, rey quien³² dsa³ Israel. 'Nee³ra² rɨ²joo²³²ra² 'u². Jo̱³ rɨ²³sɨ²³táan³na² quia̱'n²na². 'E³ quie'²³ la'³ ca²³jáa² ca²³ŋɨ́ɨ² dsa³ 'i³ ta̱a̱n²³ cruz ca³ti³² quia̱'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ma²ca¹tɨ́³ dxaan²³ ñi'², ca²³lǿ²³ li³'o̱o̱³ mɨ³¹güii³. Lǿ² quie'²³ la'³ la²³huø'n²³ 'e³ ca²³tɨ́³ hora 'nɨ³ 'e³ mɨ³cu³'lóo³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma²ca¹tɨ́³ hora 'nɨ³, ca²³lʉ́³ quiʉ̱ʉ̱³ Jesús. Ca²³jua'³: ―Eloi, Eloi, ¿lama sabactani? ―La'³ cu³lø³¹ ca²³jua'³ ju²³jmii²³² quiee'³²te'²³: Dios quién²³na²³, Dios quién²³na²³, ¿'ee² lǿ² 'e³ mɨ³tʉ́n²nu³ jné²? ");
INSERT INTO cnlNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Xen³ dsa³ 'i³ té̱e̱n³ coo³¹ 'i³ ca²³núu³ 'e³ ca²³lʉ́³ Jesús. 'E³ jo̱³ ca²³jua'³te'²³: ―Jóo². Tøø³ Elías. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'E³ jo̱³ xen³ jø̱n³ dsa³ 'i³ ŋóo² ca²³la²³dxí². I²quié̱³ joo³ 'e³ ca²³'a'²³ 'e̱'³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ ji̱i̱'³. Ca²³ti²³dxí² sɨɨ². Ca²³ji̱i̱'n³ Jesús 'e³ rɨ²³'ɨ̱'². Ca²³jua'³: ―Je̱²ru'³. Rɨ²ne²ra² xi² rɨ²³ja³ Elías 'e³ rɨ²³jiáan² dsa³ nɨ³ je² ta̱a̱n²³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","'E³ quie'²³ jo̱³ ca²³lʉ́³ quiʉ̱ʉ̱³ Jesús. Jo̱³ ca²³dsá²³ dxí³ ta'n². ");
INSERT INTO cnlNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","'E³ quie'²³ jo̱³ ca²³xíin²³ 'mɨɨ'³ cuaa³ 'e³ ji̱i̱²³² ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Yʉʉ'³¹ ca²³la²³láa²³ 'e³ ca²³xíin²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ŋó²³ juii² dsa³ 'láa³ 'i³ xi'n²³ xi²ñi² Jesús 'e³ jmii'³¹ lǿ² 'e³ ca²³lʉ́³ quiʉ̱ʉ̱³, 'e³ ca²³dsá²³ dxí³ ta'n². 'E³ jo̱³ ca²³jua'³: ―'E̱'n³ quie'²³ dsɨ́² ca³quie̱e̱² Jo̱o̱³¹ Dios dsa³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Xen³ mɨ́³ 'i³ té̱e̱n³ huɨ̱́ɨ̱³ ca³juɨ² la²³ je² ja³¹ cruz. Ta'n² joo³²te'²³. Quia̱'²te'²³ I²³lee². Quia̱'²te'²³ Ma³rii³¹ xóo² Jacobo 'i³ pi'n² cɨ² la²³ ca³já̱a̱n² quia̱'² Søø³². Quia̱'²te'²³ Salomé. 'E³ quie'²³ xen³ cɨ² mɨ́³ 'i³ quia̱'²te'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Qui² ca²³qui̱i̱³te'²³ Jesús ma²jen³¹ quie'²³ estado Galilea. Ca²³mi²³quin³te'²³. 'E³ quie'²³ quia̱'²te'²³ juɨ́ɨn²³ cɨ² mɨ́³ 'i³ ca²³dxi²³guín²³ juɨɨ³ Jerusalén quia̱'²te'²³ Jesús mɨ²jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ma²mɨ³nʉʉ³ jmɨ́ɨ² 'e³ mi³tɨ́ɨ²³ dsa³ Israel la²³jɨ³ 'e³ li²³'ne'² jmɨ́ɨ² je² tøø³ dsɨ́² dsa³, 'e³ quie'²³ la²³ 'áa²³ rɨ²³tøø³ dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Xen³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Søø³² 'i³ xen³ juɨɨ³ Arimatea. Rɨ³løn³¹ dsa³ 'i³ dxa²³ ta². Bi²³ dxʉ́²³ lʉ²³ dsa³ 'en³² Søø³². 'E³ quie'²³ je̱²³ 'ñée² 'e³ rɨ²³lín³ Dios juii² dsa³. 'E³ quie'²³ ca²³la²³bii²³ dsɨ́² Søø³² ŋóo² i²joon³ Pilato. Ca²³ŋɨ'n² 'lɨ́ɨ³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bi²³ juø'²³ ca²³núu³ Pilato 'e³ mɨ³jú̱n²³ Jesús. 'E³ quie'²³ jo̱³ ca²³tøø³ juii² dsa³ 'láa³. Ca²³ŋɨ́ɨ³ júu² xi² 'e̱'n³ 'e³ mɨ³jú̱n²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma²ca¹jua'³ juii² dsa³ 'láa³ 'e³ mɨ³jú̱n²³, ca²³cuaa'n³te'²³ guoo³ Søø³² 'lɨ́ɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ló² Søø³² co̱o̱³ 'mɨɨ'³ sɨɨ³² 'e³ rɨ²³pee'n³ 'lɨ́ɨ³. Ca²³jiáan² je² ta̱a̱n²³ cruz. Ca²³pee'n³ 'mɨɨ'³ sɨɨ³². Ca²³quiaan³ ñʉ'²³ too³ 'loo³ 'e³ ca²³yʉ́ʉ²te'²³ dsoo'²³ 'loo³. 'E³ quie'²³ jo̱³ ca²³lɨ'² co̱o̱³ cú̱u̱² bee'² 'e³ ca²³jní³ 'oo'² too³. ");
INSERT INTO cnlNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ŋó²³ I²³lee² quia̱'² Ma³rii³¹ xóo² Søø³² 'e³ jiaa'³¹ ca²³quiaan³te'²³ 'lɨ́ɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ma²ca¹ŋɨ́n³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³, ló² 'oo³ mɨ³róo³ I²³lee² quia̱'² Ma³rii³¹ xóo² Jacobo quia̱'² Salomé. Qui² 'née²³te'²³ sɨ³guín²³te'²³ sɨ³'uun³te'²³ 'lɨ́ɨ³ 'oo³ jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","I²³'áa³ tá³ jmɨ́ɨ² domingo, 'e³ cɨ² mɨ³sɨ³'ién²³ ñi'², i²guín¹te'²³ too³ 'loo³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ uu'n²te'²³: ―¿'I̱i̱² sɨɨ'³¹ rɨ²³lɨ'² quiée²ra² cú̱u̱² 'e³ rɨ³jnɨ³ 'oo'² too³ cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma²ca¹jóo¹te'²³ dxʉ́²³, ŋó²³te'²³ 'e³ ca²³lɨ'²³ co̱'³ cú̱u̱², juø'n³ quie'²³ bi²³ bee'². ");
INSERT INTO cnlNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","'E³ quie'²³ jo̱³ ca²³ta'n²³te'²³ too³ 'loo³. Ŋǿn²te'²³ jø̱n³ xii'³ 'i³ quii'³ 'mɨɨ'³ taa³ 'i³ jen³¹ jaan²³na² 'e³ dxʉ́²³. Bi²³ ca²³jue'n² miin²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","'E³ jo̱³ ca²³jua'³ xii'³. Ca²³sɨ'²³ mɨ́³: ―'A²³ rɨ³juø'n²³na'³ miin²³na'³. 'Naa'n²³na'³ Jesús dsa³ Nazaret 'i³ ca²³te̱e̱n³te'²³ cruz, ¿na'²? Mɨ³ji̱i̱'²³ co̱'³ 'ñée². 'A²³'i̱³ ma²³ xen³ la³. Jóo²ra'³ je² ca²³quiaan³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","'E³ quie'²³ cu³guín²³na'³ cu³xii'²ra'³ dsa³ quien³² ca³ti³² quia̱'² Peen²³² 'e³ dsoo³² co̱'³ 'ñée² estado Galilea jén²³ cɨ² la²³ 'nee'²³. Núu²³ rɨ²³jí̱i̱n³na'³ 'e³ la²³ lǿ² ca²³sɨ'²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","'E³ quie'²³ jo̱³ ca²³'uǿøn²³te'²³ co̱'³ too³ 'loo³. Ca²³cuɨ̱́ɨ̱²te'²³. Qui² bi²³ jleen²³te'²³ la²³'nɨɨ'n³¹ 'e³ ca²³jue'n² miin²³. 'E³ quie'²³ 'a²³'e³ xa³ 'e³ ca²³sɨ'²³te'²³ dsa³. Qui² bi²³ ma²³'nee³ juøø'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","'E³ la²³ sɨ³li³jné³ jmɨ́ɨ² domingo 'e³ la²³ ca²³líi² ca²³ji̱i̱'²³ co̱'³ Jesús, ca²³mi²³jnen³ 'ñée² caan²³ I²³lee². 'E³ quie'²³ 'i³ 'í³ hua² 'i³ cǿ̱n² guiáan²³ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'i³ ca²³'uøøn³ Jesús mɨ³xa³ cɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","'E³ quie'²³ jo̱³ ŋóo² I²³lee² i²xii'²³² dsa³ 'i³ ca²³ŋɨ́³ quia̱'² Jesús je² nee'n²³² 'oo'³²te'²³ 'e³ 'aa³te'²³ u²³ŋɨ́³ dsɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","'E³ quie'²³ ma²ca¹núu³te'²³ 'e³ mɨ³ji̱i̱'²³ co̱'³ Jesús, 'e³ mɨ³ŋøn³² Jesús I²³lee², 'a²³jia'³ ca²³táan³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cɨ̱ɨ̱n³ cɨ² ca²³lǿ²³ 'e³ jia'³ hua² cu³løn³¹ Jesús ma²ca¹mi¹jnén³ 'ñée² caan²³ áan²³ dsa³ quien³², 'e³ la²³ ta'n²te'²³ jui³¹ sɨ³guín²³te'²³ je² nuu³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","'E³ quie'²³ jo̱³ ca²³guiin³² co̱'³ te'²³ dsa³ 'í³. I²xii'²³² jia'³ cɨ'²³ te'²³ dsa³ quien³². 'E³ quie'²³ 'a²³jia'³ ca²³táan³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cɨ̱ɨ̱n³ cɨ² co̱'³ ca²³mi²³jnen³ 'ñée² caan²³ dsa³ quien³² 'i³ gui²³quie̱e̱n³ je² nee'n²³²te'¹ coo³¹ mesa. Ca²³jíi² 'e³ jua'³ 'a²³jia'³ sɨ³táan³te'²³, 'e³ jua'³ bi²³ rɨ³laa³ dsɨ́²te'²³. Qui² 'a²³jia'³ ca²³táan³te'²³ júu² 'e³ ca²³lʉ́³ dsa³ 'i³ ŋǿn² Jesús 'e³ ca²³ji̱i̱'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ quien³²: ―Guo³ra'³ la²³ca̱a̱n³ la²³ mɨ³¹güii³. Cu³'íi³ra'³ júu² dxʉ́²³, rɨ²juɨɨ'³¹ra'³ la²³jɨn³ sú̱n² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Rɨ²³láan³ dsa³ 'i³ rɨ²³sɨ²³táan³, 'i³ rɨ²³sáan²³ jmɨɨ³. 'E³ quie'²³ rɨ²³ji̱'²³ jñiin²³ dsa³ 'i³ 'a²³jia'³ rɨ²³sɨ²³táan³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","La²³la³ cu³lø³¹ u²³juø'²³ 'e³ rɨ²³lí³ je² xen³ dsa³ 'i³ sɨ³táan³: Rɨ²³'uøøn³te'²³ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'e³ jua'³te'²³ rɨ³løn³¹te'¹ dsa³ quién²³na²³. Rɨ²³lʉ́²³te'²³ júu² 'e³ 'a²³jia'³ lɨ'³ ca³lʉ́³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Rɨ²³ca'n²te'²³ 'luu³. 'E³ quie'²³ xi³nu³ rɨ²³'ɨ̱'²te'²³ 'oo³ 'e³ sɨ³jú̱n³ dsa³, 'a²³'e³ xa³ rɨ²³ji̱'²³te'²³. Rɨ²³dxá²³te'²³ guoo³te'²³ ñi'² quiee'³² dsa³ 'i³ dsoo'²³². 'E³ quie'²³ jo̱³ rɨ²³'láan³ dsa³ 'i³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ma²mɨ³líi² 'e³ ca²³lʉ́³ Juii³ra² Jesús quia̱'² dsa³ quien³², ca²³jmée³ Dios 'e³ ca²³huɨ́ɨ³ yʉʉ'³¹ güii³. Ca²³gua³ jaan²³ 'e³ dxʉ́²³ Dios: ");
INSERT INTO cnlNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","'E³ quie'²³ jo̱³ i²guín¹ la²³ca̱a̱n³ dsa³ quien³². Ca²³'ɨ́ɨ³te'²³ júu². 'E³ quie'²³ ca²³jmée³ ta² Juii³ra² quia̱'² dsa³ quien³². Ca²³jmée³ u²³juø'²³ je² ca²³'ɨ́ɨ³te'²³ júu². La'³ hua² ca²³jmée³ lii²³ 'e³ rɨ³lø³¹ ju²dsoo³¹ júu² 'e³ 'ɨɨ³te'²³. Nɨ³ mɨ³líi².");
INSERT INTO cnlNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Jné² rɨ²juøøn³¹na¹ 'nʉ³, Teófilo: Juɨ́ɨn²³ dsa³ 'i³ ca²³jua'³ 'e³ rɨ²³té̱e̱² ji³ la²³jɨ³ 'e³ ca²³lǿ²³ jee²³² quiee³²ra². Ca²³jmóo²te'²³ júu² 'e³ la²³ taa'² jui³¹ 'e³ jmii'³¹ lǿ² 'e³ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ca²³jmóo² júu² dsa³ 'i³ ŋó²³ 'e³ jmii'³¹ ca²³lǿ²³ cɨ'²³ ma²ca¹la¹láa¹. Ca²³'ɨ́ɨ³te'²³ júu² 'e³ jmii'³¹ ca²³lǿ²³. Ca²³sɨ'²³ jnee'³¹. Juɨ́ɨn²³ dsa³ 'i³ ca²³té̱e̱² ji³ júu² 'e³ ca²³jmóo² dsa³ 'i³ ŋó²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","'E³ quie'²³ la'³ lǿn³na²³ rɨ²té̱e̱n¹ ji³ jné² co̱'³. Mɨ³xa³ ca³juɨ² jmeen²³ quián²³ 'e³ tin²³²na¹ júu² 'e³ jmii'³¹ lǿ² la²³jɨ³ 'e³ ca²³lǿ²³ cɨ'²³ ma²ca¹la¹láa¹. 'E³ jo̱³ lǿn³na²³ 'e³ rɨ²té̱e̱n¹ ji³ jné² co̱'³ 'e³ rɨ²juøøn³¹na¹ 'nʉ³, Teófilo, 'e³ jmii'³¹ ca²³lǿ²³ cɨ'²³ ma²ca¹la¹láa¹ la²³huøø'n³¹ la²³ ca²³líi². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Qui² 'náan²³ 'e³ rɨ²³dsóo²³ 'áan² ca³quie̱e̱² 'e³ jmii'³¹ lǿ² júu² 'e³ ca²³'ée²³te'²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mɨ²jo̱³ xen³ jø̱n³ jmii³ dsa³ 'i³ xi̱i̱n³ Zacarías. Rey Herodes røøn³ la²³ca̱a̱n³ estado Judea mɨ²jo̱³. Jmii³ dsa³ Abías sɨ'²³te'²³ Zacarías. Qui² la'³ xi̱i̱n³ co̱o̱³ ta'n² jmii³ dsa³ mɨ²jo̱³. Xen³ mɨ²³quie'² Zacarías 'i³ xi̱i̱n³ Elisabet. Rɨ³løn³¹ dsa³ ju̱u̱n²³ jmii³ dsa³ 'ñée² mɨ́³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jmee²³ ca³dsaan³² Zacarías ca³ti³² quia̱'² mɨ²³quie'², lǿn³ Dios. Ca²³jmóo²te'²³ jmø'n² 'e³ la²³ lǿ² ley quiee'³² Dios. 'A²³'e³ xa³ 'e³ ca²³mi²³gua'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","'E³ quie'²³ 'a²³'i̱³ xen³ jo̱o̱³¹. Qui² 'a²³jia'³ lɨ'³ ca³la³huǿøn³ xi³yu̱u̱n³ quie'² Elisabet. Co̱'³ cɨ'²³ bi²³ mɨ³jaan²³²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ca²³tɨ́³ jmɨ́ɨ² 'e³ røøn³ ta² te'²³ jmii³ dsa³ Abías. 'E³ jo̱³ 'iún² Zacarías 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Jmee²³ ta² quiee'³² jmii³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Xa³ mɨɨ³¹ 'e³ ca²³co'²te'²³ 'e³ jua'³ 'née²³te'²³ rɨ²³'aa²³ 'i'²³ 'e³ 'i̱i̱² sɨɨ'³¹ li²³røøn³ 'e³ rɨ²³'í³ je² bi²³ 'mɨ'n²³ ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³te'²³ Dios Juii³ra² 'e³ rɨ²³jɨ̱́³ xʉ̱³. Qui² la'³ cu³lø³¹ tɨ³² 'i'²³ quiee'³² te'²³ jmii³ dsa³ quien³² dsa³ Israel mɨ²jo̱³. Zacarías ca²³la²³røøn³ jmɨ́ɨ² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma²ca¹tɨ́³ hora 'e³ jɨ̱³te'²³ xʉ̱³, juɨ́ɨn²³ dsa³ 'i³ ta'n² té̱e̱n³ xi²dxi³² lʉ²³te'²³ quia̱'²te'²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Güén²³ caan²³ Zacarías jø̱n³ ángel quien³² Dios Juii³ra². Ca²³noo³ jaan²³na² 'e³ dxʉ́²³ coo³¹ có̱o̱²³ je² jɨ̱³te'²³ xʉ̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ca²³xín³ ca²³'ín³ Zacarías ma²ŋøn³¹ ángel. Bi²³ ca²³jue'n² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","'E³ quie'²³ ca²³jua'³ ángel. Ca²³sɨ'²³ Zacarías: ―Zacarías, 'a²³jia'³ 'ne'² rɨ²juø'n¹nu³ 'uǿøn²nu³. Qui² mɨ³núu³ Dios 'e³ lʉ́n² quia̱'n²nu³. 'E³ cɨ² li²³huǿøn³ xi³yu̱u̱n³ quie'² mɨ²³quién²nu³, ¿mɨ³naa'³¹? 'E³ cɨ² li²³xen³ ja̱a̱n³ 'i³ dsóo²³. Juan li²³xi̱i̱n³ xi³yu̱u̱n³ rɨ²jméen² ―ca²³jua'³ ángel―. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Bi²³ li²³jɨn³ 'áan² mɨ³li³xen³. Bi²³ juɨ́ɨn²³ 'i³ li²³jɨn³ dsɨ́². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Rɨ²³jua'³ Dios 'e³ bi²³ gáan³ 'ñée². 'A²³jia'³ rɨ²³'ɨ̱'² jmɨɨ'³¹ mɨ²jø'² vino. 'E³ quie'²³ la'³ mée² co̱'³ ―ca²³jua'³ ángel―. Jmø'n² 'e³ la²³ cuø²³ jui³¹ Espíritu Gáan³ rɨ²³jmée²³ xe̱'n² la²³ li²³xen³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Rɨ²³jmée²³ 'ñée² 'e³ juɨ́ɨn²³ dsa³ Israel 'i³ rɨ²³mi²³liin²³² co̱'³ Dios juii²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Rɨ²³ŋɨ́n³ jén²³ cɨ² la²³ Juii³ra². La²³ lǿ² dsɨ́² Elías 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², la'³ rɨ²³lí³ dsɨ́² 'ñée² co̱'³. La²³ 'uee'n³ júu² quiee'³² Elías, la'³ li²³'uee'n³ júu² quiee'³² 'ñée² co̱'³. Qui² rɨ²³jmée²³ 'e³ li²³co̱o̱³ dsɨ́² dsa³ quia̱'² jo̱o̱³¹. Rɨ²³jmée²³ 'e³ rɨ²³núu²³ dsa³ 'i³ 'a²³jia'³ ta³nʉ́ʉ²³. Rɨ²³núu²³te'²³ júu² dxʉ́²³ 'e³ la²³ nuu³ dsa³ 'i³ jmoo³² ca³dsaan³². Rɨ²³mi²³tɨ́ɨ²³ dsa³ 'i³ joo'²³ rɨ²³lín³ dsa³ quien³² Juii³ra². ―La'³ cu³lø³¹ ca²³jua'³ ángel quien³² Dios Juii³ra², ca²³'én² Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ca²³jua'³ Zacarías. Ca²³sɨ'²³ ángel: ―¿Jmii'³¹ li²³lii²³ 'e³ ju²dsoo³¹ júu² 'e³ lʉ́n²? Qui² bi²³ mɨ³jaan²³²na¹. 'E³ quie'²³ la'³ mɨ²³quián²³ co̱'³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","'E³ jo̱³ ca²³jua'³ ángel: ―Gabriel hua² jné². Jné² hua² 'i³ xi'n²³na²³ caan²³ Dios tén³ la²³ 'e³ jmeen²³ ta² quiee'³². Dios mɨ³xíin²³ jné². Qui² 'née²³ 'ñée² 'e³ rɨ²lʉn²³² quia̱'n²³²na¹ 'nʉ³, 'e³ rɨ²juøøn³¹na¹ 'nʉ³ júu² dxʉ́²³ 'e³ mɨ³juǿøn²na²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Rɨ²³lí³ 'e³ la²³ mɨ³juǿøn²na²³ 'nʉ³ mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²³lí³ la'³ ―ca²³jua'³ ángel―. 'E³ quie'²³ 'a²³jia'³ sɨ³táan³nu³. 'E³ jo̱³ li²³caan²³²nu³. 'A²³jia'³ ma²³ rɨ²³lí³ juø'² rɨ²lʉ́n² la²³huøø'n³¹ 'e³ rɨ²³lí³ 'e³ la²³ mɨ³juǿøn²na²³ 'nʉ³. ―La'³ ca²³jua'³ ángel. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","'E³ quie'²³ je̱n³²quie'²³te'²³ Zacarías. ¿'Ee² lǿ² bi²³ mɨ³la³'ɨɨn²³² Zacarías 'e³ 'iún² je² bi²³ 'mɨ'n²³ ñʉ'²³ 'ñʉ́² gáan³?, lǿn³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ma²ca¹bǿn³ Zacarías, 'a²³jia'³ ma²³ rɨ²³lí³ juø'² rɨ²³lʉ́²³ quia̱'² dsa³. 'E³ jo̱³ ca²³la²³quii²³te'²³ 'e³ 'é̱e̱² 'e³ ca²³cɨ́³ ca²³ji̱'²³ ñʉ'²³ 'ñʉ́² gáan³. 'Nɨɨ'n³¹ guoo³ hua² ca²³jmée³ lii²³ 'e³ jua'³ 'é̱e̱² 'e³ lʉ²³ quia̱'² dsa³. 'E³ quie'²³ caan²³² quie'²³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma²ca¹líi¹ ta² 'e³ jmee²³ Zacarías ñʉ'²³ 'ñʉ́² gáan³, ŋø'n² co̱'³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Cɨ̱ɨ̱n³ cɨ² jo̱³ ca²³la²³huǿøn³ xi³yu̱u̱n³ quie'² Elisabet. Co̱o̱³ 'ñén³ sɨɨ'³ 'nɨɨ'n³¹ ca²³'mǿn²³ 'ñée² 'e³ lǿn²³ la'³. Ca²³jua'³ 'ñée²: ");
INSERT INTO cnlNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","―Bi²³ dxʉ́²³ mɨ³jme'²³ jné² Juii³ra². Mɨ³la³dxʉ́²³ dsɨ́² 'ñée² rɨ²³jmée²³ 'e³ 'a²³jia'³ ma²³ lǿn³ dsa³ 'e³ 'a²³jia'³ 'nee'n³¹na¹ 'e³ 'a²³'i̱³ xen³ ja̱a̱n²³. ―La'³ ca²³jua'³ Elisabet. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ma²ca¹tɨ́³ jñúun³ sɨɨ'³ 'e³ huǿøn³ xi³yu̱u̱n³ quie'² Elisabet, co̱'³ cɨ'²³ ca²³xíin²³ Dios ángel 'i³ xi̱i̱n³ Gabriel. Ca²³xíin²³ ángel co̱o̱³ juɨɨ³ estado Galilea je² xi̱i̱n³ Nazaret. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Qui² núu²³ xen³ jø̱n³ xi²³mɨɨ²³² 'i³ xi̱i̱n³ Ma³rii³¹. Rɨ³'ién² júu² 'e³ rɨ²³tǿø²³ Ma³rii³¹ jø̱n³ dsa³ 'i³ xi̱i̱n³ Søø³². Dsa³ ju̱u̱n²³ David Søø³². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","'Í² ángel je² jen³¹ Ma³rii³¹. Ca²³jua'³: ―Jné² rɨ²juøøn³¹na¹ 'nʉ³, mɨ́³ 'i³ mi³jé̱e̱n² Dios. Bi²³ mi³quin³ 'nʉ³ Dios Juii³ra². Bi²³ cɨ² mɨ³mi³jé̱e̱n² 'nʉ³ Dios la²³ cɨ'²³ la²³jɨn³ jia'³ cɨ'²³ mɨ́³. ―La'³ ca²³jua'³ ángel. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Bi²³ ca²³xín³ ca²³'ín³ Ma³rii³¹ ma²ca¹núu³ júu² quiee'³² ángel. “¿'Ee² lǿ² mɨ³sɨ'²³ jné² la'³ ángel cu²ne²ra²?”, lǿn³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","'E³ quie'²³ jo̱³ ca²³lʉ́³ co̱'³ ángel. Ca²³sɨ'²³ Ma³rii³¹: ―Ma³rii³¹, 'a²³ rɨ³juø'n²nu³ 'uǿøn²nu³. Qui² bi²³ 'uǿn² rɨ²³jmée²³ Dios quia̱'² 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","'E³ cɨ² li²³huǿøn³ xi³yu̱u̱n³ quién²nu³. 'E³ cɨ² li²³xen³ ja̱a̱n³ 'i³ dsóo²³. Jesús li²³xi̱i̱n³ rɨ²jméen². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bi²³ li²³gáan³ 'ñée². Jo̱o̱³¹ Dios 'i³ jen³¹ yʉʉ'³¹ güii³ rɨ²³sɨ'²³te'²³. Rɨ²³jmée²³ Juii³ra² Dios 'e³ rɨ²³lín³ rey, 'e³ rɨ²³có̱² ta² 'e³ ca²³jmée³ David yi²³uu'² jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Rɨ²³dxi³ 'i'²³ quie'² dsa³ Israel ca³cuaa³. 'A²³jia'³ jmɨ́ɨ² rɨ²³dxen³ 'e³ rɨ³løn³¹ rey. ―La'³ ca²³jua'³ ángel. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","'E³ jo̱³ ca²³jua'³ Ma³rii³¹. Ca²³sɨ'²³ ángel: ―¿Jmii'³¹ cu³lø³¹ rɨ²³lí³ 'e³ la²³ mɨ³xi'n²nu³ jné²? Qui² 'a²³jia'³ quia̱'n²³²na¹ dsóo²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","'E³ jo̱³ ca²³jua'³ ángel. Ca²³sɨ'²³ Ma³rii³¹: ―'E³ cɨ² rɨ²ya'n¹nu³ Espíritu Gáan³ quien³² Dios. Rɨ²³jlɨn²³nu³ júu² 'uee'n³ quiee'³² Dios 'i³ jen³¹ yʉʉ'³¹ güii³ 'e³ la²³ xen³ dsa³ 'i³ sɨ³too'² jníi² je² xi'n²³. 'E³ jo̱³ li²³huǿøn³ xi³yu̱u̱n³ quién²nu³. Jmø'n² ta² quiee'³² Dios rɨ²³jmée²³ xi³yu̱u̱n³ 'i³ cɨ² li²³xen³ quién²nu³. Jo̱o̱³¹ Dios rɨ²³sɨ'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'E³ quie'²³ rɨ²jmeen²³² júu² 'e³ huǿøn³ xi³yu̱u̱n³ 'i³ dsóo²³ quie'² jø̱n³ mɨ́³ 'i³ xen³ quién²nu³ 'i³ xi̱i̱n³ Elisabet. Huǿøn³ xi³yu̱u̱n³ quie'², juø'n³ quie'²³ mɨ³jaan²³². “'A²³jia'³ jmɨ́ɨ² rɨ²³cǿ̱n² jo̱o̱³¹” jua'³ dsa³, 'en³²te'²³ Elisabet. 'E³ quie'²³ mɨ³tɨ́³ jñúun³ sɨɨ'³ rɨ³nɨ²³ 'e³ huǿøn³ xi³yu̱u̱n³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Qui² 'a²³'e³ xa³ 'e³ 'a²³jia'³ rɨ²³li'²³ juø'² rɨ²³jmée²³ Dios. ―La'³ ca²³jua'³ ángel. Ca²³sɨ'²³ Ma³rii³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","'E³ jo̱³ ca²³jua'³ Ma³rii³¹: ―Jné² rɨ³løn³¹na¹ moza quien³² Juii³ra². Cu²lí³ quián²³ 'e³ la²³ mɨ³jue'n² ―ca²³jua'³. 'E³ jo̱³ ca²³bǿn³ ángel je² jen³¹ Ma³rii³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","La²³ca̱a̱n³ mɨ²jo̱³ ca²³jmée³ ji̱i̱³ Ma³rii³¹. Ŋóo² ca²³la²³dxí² co̱o̱³ juɨɨ³ estado Judea 'e³ nee'²³² jee²³² mo'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","'Í² xi²ñʉ'¹ quiee'³² Zacarías. Ca²³cuǿ³ u²³juee'n³¹ quia̱'² Elisabet. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma²ca¹núu³ Elisabet 'e³ ca²³lʉ́³ Ma³rii³¹ 'e³ cuø²³ u²³juee'n³¹, xe̱'n² quie'²³ jo̱³ ca²³bɨ́n² xi³yu̱u̱n³ quien³². 'Í² dsɨ́² Elisabet Espíritu Gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³jua'³ ca²³sɨ'²³ Ma³rii³¹: ―Bi²³ cɨ² mɨ³mi³jé̱e̱n² 'nʉ³ Dios la²³ cɨ'²³ la²³jɨn³ jia'³ cɨ'²³ mɨ́³. Bi²³ mɨ³mi³jé̱e̱n² xi³yu̱u̱n³ 'i³ huǿøn³ quién²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","'A²³jia'³ gáan³na²³ 'ñáan²³, ¿mɨ³naa'³¹? ¿Jmii'³¹ lǿ² 'e³ jné² hua² 'i³ mi³gáan²nu³? ¿Jmii'³¹ lǿ² mɨ³gui³joon²³nu³ jné²? Qui² rɨ³løn³¹ 'nʉ³ xóo² Juiin²³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ma²mɨ³nuun²³ 'e³ mɨ³lʉ́n² 'e³ cuøn³ u²³juee'n³¹ quia̱'n²nu³ jné², xe̱'n² quie'²³ jo̱³ mɨ³bɨ́n² xi³yu̱u̱n³ quién²³na²³ la²³'nɨɨ'n³¹ jɨn³ dsɨ́² xi³yu̱u̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bi²³ dxʉ́²³ quién² 'nʉ³ 'i³ sɨ³táan³. Qui² 'e³ cɨ² rɨ²³lí³ 'e³ la²³ ca²³sɨ'²³ 'nʉ³ Dios Juii³ra². ―La'³ ca²³jua'³ Elisabet. Ca²³sɨ'²³ Ma³rii³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","'E³ jo̱³ ca²³jua'³ Ma³rii³¹: Bi²³ 'náan²³ 'e³ rɨ²mi³gáan²na²³ Dios Juii³ra². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Bi²³ ma²³'nee³ jɨn³ dsɨn²³ jmee²³ Dios 'i³ laan³² jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Qui² líi²³ jné² Dios 'e³ rɨ³løn³¹na¹ moza quien³². Ca²³la²³juɨɨ³² jné² ji̱'²³. 'E³ jo̱³ hua² ca²³jmée³ la'³. 'E³ cɨ² rɨ²³jua'³ la²³jɨn³ dsa³, juø'n³ quie'²³ dsa³ 'i³ 'íi² li²³xen³, 'e³ bi²³ mɨ³mi³jé̱e̱n² jné² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bi²³ ma²³'nee³ dxʉ́²³ ca²³jme'²³ jné² Dios 'i³ bi²³ gáan³, 'i³ bi²³ rɨ³jɨ́n². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bi²³ cuu'²³ dsɨ́² 'ñée² quia̱'² jne² xi³nu³ 'aa³ra² u²³go³ u²³'iʉʉ²³ quia̱'n²na², juø'n³ quie'²³ xen³na² mɨ²jaa²³², juø'n³ quie'²³ xen³na² rɨ³nɨ²³, juø'n³ quie'²³ 'e³ cɨ² 'íi² li²³xen³na². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ca²³jmée³ lii²³ Dios 'e³ jmii'³¹ 'nɨɨ'n³¹ 'uee'n³ júu² quiee'³². Ca²³jmée³ Dios 'e³ ca²³sáan²³ ca²³jǿn²³ ca²³cuɨ̱́ɨ̱² dsa³ 'i³ lǿn³ miin²³ 'e³ bi²³ gáan³, dsa³ 'i³ sɨn²³ júu² 'e³ jua'³ 'née²³ rɨ²³li'²³ miin²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ca²³jmée³ Dios 'e³ 'a²³jia'³ ma²³ rɨ³løn³¹ cua̱a̱n²tu² la²³jɨn³ 'i³ gáan³. Ca²³jmée³ Dios 'e³ gáan³ dsa³ 'i³ bi²³ 'a²³jia'³ gáan³ xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ca²³jmée³ 'e³ ee'³² dxʉ́²³ dsa³ 'i³ cue̱'²³ xe̱'n². 'E³ quie'²³ 'a²³'e³ xa³ 'e³ ca²³cuǿ³ Dios quie'² dsa³ xoo³². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Rɨ³nɨ²³ jmee²³ co̱²juø'¹ Dios quiée²ra² jne² dsa³ Israel 'i³ rɨ³løn³¹ mozos quien³². Mɨ³la³líi²³ 'e³ jmee²³ co̱²juø'¹ quiée²ra². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jmee²³ 'e³ la²³ ca²³sɨ'²³ te'²³ yi²³uu'²ra² jaa²³² mɨ²jo̱³ 'e³ rɨ²³jmée²³, 'e³ la²³ ca²³sɨ'²³ Abraham quia̱'² te'²³ dsa³ ju̱u̱n²³. Qui² ca²³jua'³ 'e³ li²³cuu'²³ dsɨ́² quia̱'² Abraham. Ca²³jua'³ 'e³ li²³cuu'²³ dsɨ́² ca³cuaa³ quia̱'² jne² dsa³ ju̱u̱n²³ Abraham. ―La'³ ca²³jua'³ Ma³rii³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Co̱o̱³ aan³ sɨɨ'³ 'nɨɨ'n³¹ ca²³guó³ Ma³rii³¹ quie'² Elisabet. Jo̱³ tu³ ŋø'n² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ca²³tɨ́³ jmɨ́ɨ² 'e³ li²³xen³ xi³yu̱u̱n³ quien³² Elisabet. 'E³ jo̱³ ca²³la²³xen³ xi³yu̱u̱n³ dsóo²³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ca²³núu³ dsa³ 'i³ nee'n²³² ji̱i̱'² coo³¹ quia̱'² dsa³ 'i³ xen³ quie'² Elisabet 'e³ jmii'³¹ 'nɨɨ'n³¹ dxʉ́²³ ca²³jmée³ Dios ca²³jme'²³ Elisabet. Bi²³ ca²³la²³jɨn³ dsɨ́²te'²³ quia̱'²te'²³ Elisabet. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ma²ca¹tɨ́³ co̱o̱³ mɨ²guiaa³ 'e³ xen³ xi³yu̱u̱n³, ca²³jme'²³te'²³ xi³yu̱u̱n³ 'e³ la²³ lǿ² tɨ³² 'i'²³ quiee'³²te'²³ 'e³ xi̱i̱n³ circuncisión. Lǿn³te'²³ 'e³ rɨ²³jmóo²te'²³ 'e³ Zacarías xi̱i̱n³ xi³yu̱u̱n³. Rɨ²³jmóo²te'²³ 'e³ li²³xi̱i̱n³ la²³ xi̱i̱n³ jmii³, lǿn³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","'E³ quie'²³ ca²³jua'³ xóo²: ―'A²³la³ la'³ 'ne'² li²³xi̱i̱n³. Juan hua² li²³xi̱i̱n³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","'E³ jo̱³ ca²³sɨ'²³te'²³ xóo²: ―¿'Ee² lǿ²? 'A²³'i̱³ xen³ dsa³ 'i³ xen³ quién²na'³ 'i³ xi̱i̱n³ la'³. Qui² mɨ³la³tó̱o̱³ra² 'e³ jmee³ra² 'e³ xi̱i̱n³ jo̱o̱³ra² 'e³ la²³ xi̱i̱n³ 'i³ xen³ quiée²ra², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'E³ jo̱³ ca²³bí²te'²³ guoo³te'²³ 'e³ jua'³ tin²³te'²³ júu² quie'² jmii³ xi³yu̱u̱n³ 'e³ jmii'³¹ lǿn³ 'ñée² 'e³ dxʉ́²³ li²³xi̱i̱n³ xi³yu̱u̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","'E³ jo̱³ ca²³ŋɨ́ɨ³ joo³¹ 'mo³. Ca²³jmée³ 'uø'². “Juan xi̱i̱n³” ca²³té̱e̱². Bi²³ juø'²³ ca²³jóo² la²³jɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Xe̱'n² quie'²³ jo̱³ lǿ²³ juø'² ca²³lʉ́³ co̱'³ Zacarías. Ca²³lʉ́³. Ca²³mi²³gáan³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bi²³ juø'²³ ca²³núu³ la²³jɨn³ dsa³ 'i³ nee'n²³² ji̱i̱'² coo³¹. Bi²³ ca²³lʉ́³ dsa³ la²³ca̱a̱n³ mo'³ quiee'³² dsa³ estado Judea. Ca²³sɨ'²³te'²³ uu'n²te'²³ 'e³ jmii'³¹ lǿ² la²³jɨ³ 'e³ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bi²³ ca²³jmóo² 'i'²³ la²³jɨn³ dsa³ 'i³ ca²³núu³ júu² quiee'³²te'²³. Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ uu'n²te'²³: ―¿Jmii'³¹ rɨ²³jmée²³ xi³yu̱u̱n³ 'í³ cu²ne²ra²? La'³ ca²³jua'³te'²³. Qui² lii²³ 'e³ 'e̱'n³ quie'²³ dsɨ́² jmee²³ Dios Juii³ra² co̱²juø'¹ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","'Í² dsɨ́² Zacarías, jmii³ xi³yu̱u̱n³, Espíritu Gáan³. 'E³ jo̱³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios. Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","'Ne'² rɨ²mi³gáan²na² Dios juii² jne² dsa³ Israel. Qui² güén²³ 'e³ rɨ²³jmée²³ co̱²juø'¹ quiée² jne² dsa³ quien³². Laan³² jne² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Qui² mɨ³cuǿn² dsa³ 'i³ 'uee'n³ 'i³ rɨ²³láan² jne². Rɨ³løn³¹ dsa³ ju̱u̱n²³ David, 'i³ ca²³lǿn²³ mozo quien³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Qui² la'³ cu³lø³¹ júu² quiee'³² Dios 'e³ ca²³lʉ́³ dsa³ 'i³ rɨ³jɨ́n² quien³² 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² mɨ²jaa²³². Cɨ'²³ mɨ²jaa²³² 'ɨɨ³te'²³ júu² quiee'³² Dios 'e³ lø³² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Qui² ca²³jua'³ Dios 'e³ rɨ²³láan² jne², 'e³ 'a²³jia'³ rɨ²³jí̱i̱³ra² la²³jɨ³ 'e³ 'née²³ rɨ²³jmóo² dsa³ 'i³ bi²³ hui²³dsɨ́ɨn² ñin³² jne². 'A²³'e³ xa³ rɨ²³li'²³ dsa³ 'i³ 'a²³jia'³ ta³dsɨ³² ñin³² jne², ca²³jua'³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ca²³sɨ'²³ yi²³uu'²ra² jaa²³² 'e³ rɨ²³jmée²³ co̱²juø'¹ quiée² jne² dsa³ quien³². 'A²³jia'³ mi³gua'²³ júu² 'e³ la²³ lǿ² ca²³sɨ'²³ yi²³uu'²ra² jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","La²³la³ cu³lø³¹ ju²dsoo³¹ 'e³ ca²³lʉ́³ Dios, ca²³sɨ'²³ Abraham yi²³uu'²ra² jaa²³² 'e³ rɨ²³jmée²³: ");
INSERT INTO cnlNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ca²³jua'³ 'e³ rɨ²³láan² jne², 'e³ 'a²³jia'³ rɨ²³jí̱i̱³ra² la²³jɨ³ 'e³ 'née²³ rɨ²³jmóo² dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² jne². Ca²³jua'³ 'e³ rɨ²³cuǿ²³ júu² 'e³ 'a²³jia'³ juøø'n²³na² rɨ²mi³gáan²na² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ca²³jua'³ 'e³ rɨ²³cuǿ²³ júu² 'e³ rɨ²³lín³na² rɨ³jɨ́n²na², 'e³ rɨ²jmee²ra² ca³dsaan³² 'e³ la²³ 'née²³ 'ñée² la²³huøø'n³¹ la²³ nee'²³²ra² mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Co̱'³ cɨ'²³ ca²³lʉ́³ Zacarías. Ca²³sɨ'²³ jo̱o̱³¹: Rɨ²juøøn³¹na¹ 'nʉ³, xi³yu̱u̱n³ quién²³na²³: Rɨ²³sɨ'²³te'²³ 'nʉ³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios 'i³ jen³¹ yʉʉ'³¹ güii³. Qui² guaan³² 'nʉ³ jén²³ cɨ² la²³ Juii³ra². Rɨ²jméen² dxʉ́²³ jui³¹ je² rɨ²³ŋɨ́n³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Rɨ²juɨɨ'n³¹ dsa³ Israel 'e³ jmii'³¹ lǿ² 'e³ rɨ²³je̱'n²³ dsoo² quiee'³²te'²³. 'E³ jo̱³ hua² rɨ²³láan³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Qui² 'néen² jne² Dios. Bi²³ cuu'²³ dsɨ́² ñin³² jne². Rɨ²³jmée²³ 'ñée² 'e³ li²³jné³ jui³¹ je² ŋɨ²ra² la²³ jmee²³ ñi'² 'i³ ta̱a̱n²³ mɨ³¹güii³ mɨ³li³jné²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Rɨ²³jmée²³ 'e³ li²³jné³ jui³¹ je² ŋɨ́³ dsa³ 'i³ nee'n²³² je² li³'o̱o̱³, dsa³ 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jú̱n³. Rɨ²³cuǿ²³ jui³¹ quiée²ra² 'e³ rɨ²³gua³ ca²³tó̱o̱²³ dsɨ³ra². ―La'³ cu³lø³¹ júu² 'e³ ca²³lʉ́³ Zacarías. ");
INSERT INTO cnlNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ca²³tɨ́³ 'e³ ca²³'ien³ Juan. Ca²³la²³'uee'n³ dsɨ́². Ca²³gua³ je² 'a²³jia'³ nee'n²³² dsa³. Núu²³ jen³¹ la²³huøø'n³¹ ca²³tɨ́³ jmɨ́ɨ² 'e³ ca²³la²³cuiin²³ Juan dsa³ Israel je² 'ɨɨ³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ma²ca¹la²³xen³ xi³yu̱u̱n³ Juan, ca²³dxi³ 'i'²³ dxi² juɨɨ³ gáan³ 'i³ xi̱i̱n³ César Augusto 'e³ 'ne'² rɨ²³ta̱a̱n²³ ji³ la²³jɨn³ dsa³ 'i³ nee'n²³² je² røøn³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mɨ²jo̱³ ca²³la²³láa²³ 'e³ jmoo³²te'²³ la'³. Cirenio rɨ³løn³¹ dxi² juɨɨ³ estado Siria mɨ²jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","'E³ jo̱³ ca²³guiin³² la²³jɨn³ dsa³, juɨɨ³ je² ca²³la²³xen³ dsa³ góo²³ quien³²te'²³. Qui² rɨ³lø³¹ 'i'²³ 'e³ núu²³ rɨ²³te̱e̱n³te'²³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","'E³ jo̱³ ŋø'n² Søø³², naan³ juɨɨ³ Nazaret estado Galilea. Ŋø'n² juɨɨ³ je² xi̱i̱n³ Belén je² ca²³la²³xen³ David mɨ²jaa²³². Qui² dsa³ ju̱u̱n²³ David Søø³². ");
INSERT INTO cnlNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ŋø'n² Belén Søø³² 'e³ jua'³ núu²³ rɨ²³te̱e̱n³te'²³ ji³. Ca³ti³² ŋø'n² quia̱'² Ma³rii³¹, mɨ́³ 'i³ rɨ³'ién² júu² 'e³ rɨ²³tǿø²³. Huǿøn³ xi³yu̱u̱n³ quie'² Ma³rii³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","'E³ la²³ nee'n²³²te'¹ juɨɨ³ Belén, ca²³tɨ́³ jmɨ́ɨ² 'e³ li²³xen³ xi³yu̱u̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","'E³ quie'²³ jo̱³ ca²³la²³xen³ xi³yu̱u̱n³ 'i³ cua̱a̱n²³ quie'² Ma³rii³¹. Ca²³pee'n³ 'mɨɨ'³ xi³yu̱u̱n³. Ca²³quiaan³ 'e̱'³ joo³¹ guóo² je² ee'³² roo'³². Qui² 'a²³'e³ xa³ je² joo'²³ ñʉ'²³ 'ñʉ́² bee'² je² cuøø²³te'²³ 'e³ rɨ²³guɨɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","'Ioo³¹ juɨɨ³ mɨ³lén² la²³ juɨɨ³ Belén xen³ dsa³ 'i³ mi³quin³ dsɨɨ³ joo³. Qui² 'uøø²³ jo̱³ ca²³mi²³quin³te'²³ dsɨɨ³ joo³ quien³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","'E³ quie'²³ co̱'³ la²³ ca²³mi²³jnen³ 'ñée² jø̱n³ ángel quien³² Dios Juii³ra² caan²³ te'²³ dsa³ 'i³ mi³quin³ dsɨɨ³ joo³. Ji³ 'e³ bi²³ ma²³'nee³ rɨ³jii'³¹ 'e³ jmee²³ lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³ Dios ca²³'ioo²³ la²³cu'² je² nee'n²³²te'¹. 'E³ jo̱³ bi²³ ma²³'nee³ ca²³juøø'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","'E³ quie'²³ ca²³jua'³ ángel. Ca²³sɨ'²³ dsa³ 'i³ mi³quin³ dsɨɨ³ joo³: ―'A²³ rɨ³juø'n²na'³ miin²³na'³. Nʉʉ³ra'³. Qui² rɨ²juøøn³¹na¹ 'nee'²³ co̱o̱³ júu² dxʉ́²³ 'e³ rɨ²³jmée²³ 'e³ jɨn³ 'óo²ra'³. Rɨ²³jmée²³ 'e³ jɨn³ dsɨ́² la²³jɨn³ dsa³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Qui² rɨ³nɨ²³ mɨ³la³xen³ quién²na'³ jø̱n³ dsa³ 'i³ rɨ²³láan² 'nee'²³. Cristo Juii³ra² 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios hua² 'í³. Juɨɨ³ Belén mɨ³la³xen³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","La²³la³ cu³lø³¹ rɨ²móo²ra'³ 'e³ 'i̱i̱² xi³yu̱u̱n³ 'í³: Rɨ²móo²ra'³ 'e³ rɨ³pee'n³² 'mɨɨ'³ xi³yu̱u̱n³. Rɨ³caa'n³² 'e̱'³ joo³¹ guóo² je² ee'³² roo'³². ―La'³ cu³lø³¹ ca²³jua'³ ángel. Ca²³sɨ'²³ dsa³ 'i³ mi³quin³ dsɨɨ³ joo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Co̱'³ la²³ ca²³i²³guín²³ juɨ́ɨn²³ cɨ² ángeles. Ca²³mi²³gáan³te'²³ Dios. Ca²³jua'³te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Bi²³ gáan³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³! ¡Cu²li³co̱o̱³ dsɨ́² dsa³ mɨ³¹güii³ 'i³ bi²³ 'née² Dios quie'²! ―La'³ ca²³jua'³ te'²³ ángeles. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ma²ca¹guiin³² co̱'³ ángeles yʉʉ'³¹ güii³, ca²³jua'³ dsa³ 'i³ mi³quin³ dsɨɨ³ joo³. Ca²³sɨ'²³ uu'n²: ―Mɨ²³gui²³²ra² jee²³² juɨɨ³. Mɨ²³joo²³²ra² jmii'³¹ cu³lø³¹ 'e³ mɨ³lǿ²³ 'e³ la²³ lǿ² mɨ³sɨ'²³ jne² ángel quien³² Dios Juii³ra². ―La'³ ca²³jua'³ dsa³ 'i³ mi³quin³ dsɨɨ³ joo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ca²³guín²³te'²³ ca²³la²³dxí². Ca²³dsø'n²³te'²³ Ma³rii³¹ quia̱'² Søø³² quia̱'² xi³yu̱u̱n³ 'i³ rɨ³caa'n³² 'e̱'³ joo³¹ guóo² je² ee'³² roo'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ma²ŋó¹te'²³ la²³jɨ³ 'e³ sɨ³lí³, ca²³jmóo² júu² dsa³ 'i³ mi³quin³ dsɨɨ³ joo³ 'e³ jmii'³¹ lǿ² 'e³ ca²³lʉ́³ ángeles ca²³'én² xi³yu̱u̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bi²³ juø'²³ ca²³núu³ la²³jɨn³ dsa³ 'i³ ca²³núu³ júu² 'e³ ca²³jmóo² dsa³ 'i³ mi³quin³ dsɨɨ³ joo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","'E³ quie'²³ ca²³mi²³lii²³² Ma³rii³¹ la²³jɨ³ júu² 'e³ ca²³jmóo² dsa³ 'i³ mi³quin³ dsɨɨ³ joo³. Bi²³ ca²³jmée³ 'i'²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","'E³ quie'²³ ca²³guiin³² co̱'³ dsa³ 'i³ mi³quin³ dsɨɨ³ joo³. Bi²³ ca²³mi²³gáan³te'²³ Dios. ―Bi²³ dxʉ́²³ jmee²³ Dios ―ca²³jua'³te'²³. Bi²³ 'née²³te'²³ ca²³jmée³ la²³jɨ³ 'e³ ca²³núu³te'²³, la²³jɨ³ 'e³ ca²³jóo²te'²³. Qui² ca²³lǿ²³ la²³jɨ³ 'e³ la²³ ca²³núu³te'²³ 'e³ rɨ²³lí³. 'E³ jo̱³ hua² ca²³mi²³gáan³te'²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ma²ca¹tɨ́³ co̱o̱³ mɨ²guiaa³ 'e³ xen³ xi³yu̱u̱n³, ca²³jme'²³te'²³ 'e³ la²³ lǿ² tɨ³² 'i'²³ quiee'³²te'²³ 'e³ xi̱i̱n³ circuncisión. Ca²³jmóo²te'²³ 'e³ Jesús xi̱i̱n³. Qui² la'³ cu³lø³¹ li²³xi̱i̱n³ ca²³jua'³ ángel ma²'ii³¹ li²³huǿøn³ xi³yu̱u̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ca²³líi² jmɨ́ɨ² 'e³ jii³ u̱u̱'n³ miin²³ 'e³ la²³ lǿ² ley 'e³ ca²³ŋɨ́n² Moisés. 'E³ jo̱³ ca²³jøn²³te'²³ xi³yu̱u̱n³ juɨɨ³ Jerusalén 'e³ jua'³ rɨ²³dxén²te'²³ guoo³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Qui² la²³la³ cu³lø³¹ to̱o̱²³ ley quiee'³² Dios Juii³ra²: “'Ne'² rɨ²³dxén²te'²³ guoo³ Dios la²³jɨn³ 'i³ cua̱a̱n²³ 'i³ dsóo²³ quien³²te'²³”. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","'E³ jo̱³ i²guín¹te'²³ 'e³ jua'³ rɨ²³jŋɨ'n²³te'²³ to̱³ 'i³ rɨ²³cuǿn²³te'²³ Dios. Ca²³jmóo²te'²³ 'e³ la²³ to̱o̱²³ ley quiee'³² Dios Juii³ra² je² jua'³: “Líi² rɨ²³cuǿn²te'²³ co̱o̱³ güee'n³¹ bø³. Líi² rɨ²³cuǿn²te'²³ áan²³ jo̱o̱³¹ to̱³ju̱³¹.” La'³ cu³lø³¹ to̱o̱²³ ley 'e³ ca²³ŋɨ́n² Moisés. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Xen³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Simeón juɨɨ³ Jerusalén mɨ²jo̱³. Bi²³ ca³dsaan³² jmee²³ dsa³ 'í³. 'Aa³ u²³go³ u²³'iʉʉ²³ quia̱'² Dios. Je̱²³ 'ñée² 'e³ rɨ²³láan³ dsa³ Israel. 'Iún² dsɨ́² Simeón Espíritu Gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ca²³jmée³ Espíritu Gáan³ 'e³ ca²³dsóo²³ dsɨ́² Simeón 'e³ 'íi² rɨ²³jú̱n³ 'ñée² rɨ²³jóon² Cristo 'i³ rɨ²³xíin²³ Dios Juii³ra². ");
INSERT INTO cnlNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Cuø²³ jui³¹ Espíritu Gáan³ quie'² ma²'i³¹ ñʉ'²³ 'ñʉ́² gáan³ jmɨ́ɨ² jo̱³. 'E³ quie'²³ jo̱³ ca²³jøn²³ xi³yu̱u̱n³ Jesús xóo² jmii³. Ca²³jøn²³te'²³ ñʉ'²³ 'ñʉ́² gáan³ 'e³ jua'³ rɨ²³jmóo²te'²³ quie'² xi³yu̱u̱n³ 'e³ la²³ lǿ² tɨ³² 'i'²³ 'e³ to̱o̱²³ ley quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'E³ jo̱³ ca²³i̱i̱n²³ xi³yu̱u̱n³ Simeón. Ca²³mi²³gáan³ Dios. Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dios Juiin²³, jmɨ́ɨ² 'e³ rɨ³nɨ²³ líi² rɨ²cuǿn² júu² 'e³ ñe'n³²na²³ quién²nu³ jné² 'i³ rɨ³løn³¹ mozo quien³²nu³. Née² ca²³tó̱o̱²³ dsɨn²³ 'e³ ñe'n³²na²³. Qui² mɨ³jméen² 'e³ la²³ ca²³xi'n²nu³ jné² 'e³ rɨ²jméen². ");
INSERT INTO cnlNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","'E³ jo̱³ mɨ³mǿn²na²³ 'ñée² xi³yu̱u̱n³ la³ 'i³ rɨ²³láan² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Qui² mɨ³jméen² ji̱i̱³ 'e³ rɨ²láan¹nu³ dsa³ je² rɨ²³lí³ juø'² rɨ²³jóo² la²³jɨn³ dsa³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Rɨ²³jmée²³ 'ñée² xi³yu̱u̱n³ la³ 'e³ li²³jné³ jui³¹ je² ŋɨ́³ dsa³ jia'³. Rɨ²³jmée²³ 'ñée² 'e³ li²³gáan³ dsa³ Israel, dsa³ quien³²nu³. ―La'³ ca²³jua'³ Simeón. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bi²³ juø'²³ ca²³núu³ xóo² jmii³ xi³yu̱u̱n³ ma²ca¹núu³te'²³ jmii'³¹ ca²³lʉ́³ Simeón, ca²³'én² xi³yu̱u̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","'E³ quie'²³ jo̱³ ca²³cuǿ³ u²³li²³jé̱e̱³ Simeón. Ca²³mi²³jé̱e̱n² xóo² jmii³ xi³yu̱u̱n³. Ca²³sɨ'²³ Ma³rii³¹, xóo² xi³yu̱u̱n³: ―Rɨ³lø³¹ 'i'²³ 'e³ juɨ́ɨn²³ dsa³ Israel 'i³ rɨ²³'lǿn²³ mɨ³rɨ³jí̱i̱n³te'²³ xi³yu̱u̱n³ la³. 'E³ quie'²³ juɨ́ɨn²³ dsa³ Israel 'i³ rɨ²³naa'n²³ mɨ³rɨ³jí̱i̱n³te'²³. Rɨ²³jmée²³ lii²³ 'e³ jmii'³¹ lǿn²³ Dios. 'E³ quie'²³ juɨ́ɨn²³ dsa³ 'i³ rɨ²³jua'³ 'e³ 'a²³jia'³ 'nee'n³¹ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jo̱³ hua² li²³lii²³ 'e³ jmii'³¹ lǿ² dsɨ́² dsa³. Bi²³ li²³xa³ u²³ŋɨ́³ dsɨ́ɨ² quién²nu³. ―La'³ ca²³jua'³ Simeón. Ca²³sɨ'²³ xóo² xi³yu̱u̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mɨ²jo̱³ xen³ jø̱n³ mɨ́³ raan³ 'i³ xi̱i̱n³ I²³'a̱a̱n² 'i³ 'ɨɨ³ júu² quiee'³² Dios. Jo̱o̱³¹ Penuel mɨ́³ raan³ 'í³. Rɨ³løn³¹ ju̱u̱n²³ dsa³ xoo'³¹ jmóo² 'i³ xi̱i̱n³ Aser. Bi²³ mɨ³jaan²³² 'ñée² I²³'a̱a̱n². Guiáa²³ ji̱i̱³ ñi³ hua² 'nɨɨ'n³¹ 'e³ ca²³la²³quia̱'² dsóo²³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Jo̱³ tu³ jú̱n²³ dsóo²³ quien³². Ca²³la²³'nɨ́ɨn³ 'ñée² I²³'a̱a̱n². Mɨ³tɨ́³ tú̱²³ lu²³guiá³ dsɨ³² gui²³guiá³ dsɨ³² quiʉ̱́³ ji̱i̱'n²³ mɨ́³ raan³ 'nɨ́ɨ³ 'í³ ma²ca¹la¹xen³ xi³yu̱u̱n³ Jesús. Tén³ 'iún² 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Jmɨ́ɨ²³ 'uøø²³ ca²³mi²³gáan³ Dios. Ca²³jmée³ mɨ²³jmɨɨ²³. Ca²³lʉ́³ quia̱'² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Xe̱'n² ma²ca¹dxóo¹ xóo² jmii³ xi³yu̱u̱n³ 'ñʉ́² gáan³, ŋóo² I²³'a̱a̱n² i²joon³ xi³yu̱u̱n³. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. Ca²³lʉ́³ quia̱'² la²³jɨn³ dsa³ Jerusalén 'i³ je̱²³ 'e³ rɨ²³láa² Dios quie'²te'²³. ―'I³ la³ xi³yu̱u̱n³ 'i³ rɨ²³láan² jne² dsa³ Jerusalén ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ma²mɨ³'áa³ 'i'²³ 'e³ ca²³jmóo² xóo² jmii³ xi³yu̱u̱n³ la²³jɨ³ 'e³ la²³ lǿ² ley quiee'³² Dios Juii³ra², ca²³guiin³² co̱'³ estado Galilea. Ca²³guiin³² co̱'³ juɨɨ³ quiee'³²te'²³ je² xi̱i̱n³ Nazaret. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","'E³ quie'²³ jo̱³ ca²³la²³be'n² xi³yu̱u̱n³. Ca²³la²³'uee'n³. Bi²³ dxʉ́²³ ca²³la²³ta²³jmee²³ 'i'²³ 'ñée². Bi²³ ca²³mi²³jé̱e̱n² xi³yu̱u̱n³ 'í³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cɨ'³ la²³ co̱o̱³ ji̱i̱³ ñi³ 'e³ sɨ³tɨ́²³ mɨ²juee'³ pascua, ŋɨ́³ juɨɨ³ Jerusalén xóo² jmii³ xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma²ca¹tɨ́³ gui²³tʉ̱́³ ji̱i̱'n²³ Jesús, ca²³guín²³te'²³ co̱'³ juɨɨ³ Jerusalén 'e³ la²³ lǿ² tɨ³² 'i'²³ quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ma²ca¹líi¹ mɨ²juee'³ pascua, ca²³ta'n²³ jui³¹ co̱'³ 'e³ sɨ³guiin³². 'E³ quie'²³ ca²³cuaa'n²³ xii'³ Jesús juɨɨ³ Jerusalén. 'A²³jia'³ ñi³² xóo² jmii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Lǿn³te'²³ 'e³ xa³ je² 'iún² jee²³² quiee'³² dsa³ 'i³ ta'n² jui³¹ quia̱'². Ma²ca¹tɨ́³ co̱o̱³ jmɨ́ɨ² 'e³ ta'n²te'²³ jui³¹, ca²³'naa'n³te'²³ xii'³ Jesús jee²³² quiee'³² 'i³ xen³ quie'² quia̱'² dsa³ 'i³ cuiin²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","'E³ quie'²³ 'a²³'i̱³ xen³. 'E³ jo̱³ ca²³guín²³te'²³ co̱'³ juɨɨ³ Jerusalén 'e³ jua'³ rɨ²³'naa'n³te'²³ co̱'³ núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Je² ca²³tɨ́³ 'nɨ³ jmɨ́ɨ², ca²³dsø'n²³te'²³ xii'³ 'e³ 'iún² ñʉ'²³ 'ñʉ́² gáan³. Jen³¹ jee²³² quiee'³² dsa³ 'e²³ ley. Nuu³ jmii'³¹ lʉ²³ dsa³ 'e²³ ley. Ŋɨɨ²³ júu² 'ñée² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bi²³ juø'²³ ca²³núu³ la²³jɨn³ dsa³ 'i³ ca²³núu³ júu² quiee'³². Bi²³ ta³jmee²³ 'i'²³ 'ñée². Bi²³ ta³jmee'n³² júu² mɨ³rɨ³ŋɨ́ɨ³te'²³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bi²³ juø'²³ ca²³jóon² Jesús xóo² jmii³. Ca²³jua'³ xóo². Ca²³sɨ'²³ xii'³: ―Yu̱u̱n³, ¿'ee² lǿ² jmee'n³²nu³ jnee'³¹ la²³nɨ³? Qui² bi²³ ŋɨ́³ dsɨ³ra'³¹ quia̱'n²³²na¹ ñu'n² 'e³ la²³ mɨ³'nee'n²³²na'³¹ 'nʉ³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","'E³ jo̱³ ca²³jua'³ xii'³. Ca²³sɨ'²³ xóo² jmii³: ―¿'Ee² lǿ² 'e³ 'naa'n²³na'³ jné² ru'³? ¿'A² 'a²³jia'³ móo³ra'³ 'e³ jmee²³ rɨ³dxíin³ 'e³ jen³¹na¹ 'ñʉ² Ñu'n²³? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'E³ quie'²³ 'a²³jia'³ lǿ²³ juø'² ca²³jmóo²te'²³ 'i'²³ 'e³ jmii'³¹ lǿ² 'e³ ca²³jua'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","'E³ quie'²³ ŋø'n² co̱'³ juɨɨ³ Nazaret quia̱'² xóo² jmii³. Ca²³núu³ 'ñée² 'e³ jmii'³¹ ca²³sɨ'²³te'²³. Ca²³mi²³lii²³² xóo² 'e³ jmii'³¹ lǿ² la²³jɨ³ 'e³ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","'E³ quie'²³ bi²³ cɨ² ca²³la²³ta²³jmee²³ 'i'²³ 'ñée² Jesús. Ca²³'ien³ dsa³. Bi²³ dxʉ́²³ jmee²³ ji̱'²³ Dios quia̱'² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ca²³tɨ́³ gui²³'ñé³ ji̱i̱³ ñi³ 'e³ rɨ³løn³¹ dxi² juɨɨ³ gáan³ Tiberio César. Poncio Pilato rɨ³løn³¹ dxi² juɨɨ³ estado Judea mɨ²jo̱³. Herodes rɨ³løn³¹ dxi² juɨɨ³ estado Galilea. Bi³lii² la²³ ca³já̱a̱n² quia̱'² Herodes rɨ³løn³¹ dxi² juɨɨ³ estado Iturea quia̱'² estado Traconite co̱'³. Lisanias rɨ³løn³¹ dxi² juɨɨ³ estado Abilinia. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás quia̱'² Caifás rɨ³løn³¹ juii² jmii³ dsa³ quien³² dsa³ Israel. La²³ca̱a̱n³ mɨ²jo̱³ xa³ co̱o̱³ júu² 'e³ ca²³jmée³ Dios 'e³ ca²³dsóo²³ dsɨ́² Juan jo̱²³ñʉʉ'³¹ Zacarías 'e³ la²³ jen³¹ je² 'a²³jia'³ nee'n²³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","'E³ jo̱³ ca²³ŋɨ́n³ Juan la²³ca̱a̱n³ je² mɨ³lén² jmɨɨ³ juee'³ Jordán. Ca²³'ɨ́ɨ³ júu². Ca²³sɨ'²³ dsa³ 'e³ 'ne'² rɨ²³tʉ́²te'²³ 'e³ jmoo³²te'²³ 'e³ 'a²³jia'³ dxʉ́²³, 'e³ 'ne'² rɨ²³sáan²³te'²³ jmɨɨ³. La'³ 'ne'² rɨ²³jmóo²te'²³ 'e³ jua'³te'²³ 'née²³te'²³ 'e³ rɨ²³yʉʉ³ dsoo² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jo̱³ ca²³lǿ²³ 'e³ la²³ to̱o̱²³ ji³ 'e³ ca²³jmée³ Isaías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³²: Xen³ 'i³ lʉ²³ quiʉ̱ʉ̱³ je² 'a²³jia'³ nee'n²³² dsa³. Jua'³ 'ñée²: “Rɨ²jmée²ra'³ dxʉ́²³ jui³¹ je² rɨ²³ŋɨ́n³ Juii³ra². Rɨ²jmée²ra'³ jui³¹ 'e³ ca³dsaan³² je² rɨ²³ŋɨ́n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","'E³ cɨ² rɨ²³'ɨ'² la²³ca̱a̱n³ je² juu'³. 'E³ quie'²³ la'³ la²³jɨ³ mo'³ quia̱'² la²³jɨ³ cuo̱o̱'³. 'E³ cɨ² rɨ²³'ɨ'² la²³jɨ³ jui³¹ jlʉ³. 'E³ cɨ² li²³sú̱n² jui³¹ 'áa². ");
INSERT INTO cnlNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","'E³ cɨ² rɨ²³ñí² la²³jɨn³ dsa³ mɨ³¹güii³ 'e³ jmii'³¹ rɨ²³láan² dsa³ Dios.” La'³ cu³lø³¹ júu² 'e³ to̱o̱²³ ji³ 'e³ ca²³jmée³ Isaías. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juɨ́ɨn²³ dsa³ 'i³ i²guín¹ je² 'ɨɨ³ júu² Juan 'e³ jua'³ 'née²³te'²³ 'e³ rɨ²³xóo² jmɨɨ³ Juan quie'²te'²³. 'E³ jo̱³ ca²³jua'³ Juan. Ca²³sɨ'²³ te'²³ dsa³ 'í³: ―'É̱e̱² ju̱u̱n²³ 'luu³ 'nee'²³. ¿Jmii'³¹ lǿ² lǿn³na'³ 'e³ rɨ²³lí³ juø'² rɨ²³láan³na'³ mɨ³rɨ³jmee³ Dios jñiin²³ dsa³ 'i³ 'a²³jia'³ dxʉ́²³ jmoo³²? ");
INSERT INTO cnlNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","'Ne'² rɨ²jmée²ra'³ lii²³ 'e³ 'e̱'n³ quie'²³ dsɨ́² mɨ³tʉ́²ra'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ dxʉ́²³. 'A²³jia'³ ma²³ 'ne'² 'e³ rɨ²juɨɨ'³¹ra'³ uu'n²na'³: “Abraham rɨ³løn³¹ yi²³uu'²ra² jaa²³²”. Qui² 'a²³jia'³ quí̱i̱n²³ 'e³ la²³'nɨɨ'n³¹ la'³. Qui² rɨ²juøøn³¹na¹ 'nee'²³: 'A²³jia'³ jmɨ́ɨ² rɨ²³cuaa'n²³ gøn³ Dios. Cu³xi³ cú̱u̱² la³ rɨ²³lí³ juø'² rɨ²³jmén² dsa³ ju̱u̱n²³ Abraham Dios, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mɨ³tɨ́³ 'e³ rɨ²³jmée²³ ta² ñí² laa'³. Qui² rɨ²³hui̱'³ la²³jɨ³ 'mo³ 'e³ 'a²³jia'³ 'ɨɨ³ mɨɨ³¹ 'e³ dxʉ́²³. Rɨ²³to'²³te'²³ dxi³¹ji³ 'e³ cu²coo³. ―La'³ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Juɨ́ɨn²³ dsa³ 'i³ ca²³ŋɨ́ɨ³ júu². Ca²³sɨ'²³te'²³ Juan: ―¿Jmii'³¹ 'ne'² rɨ²jmee²ra'³¹ jo̱o̱²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","'E³ jo̱³ ca²³jua'³ Juan: ―Dsa³ 'i³ xa³ tú̱²³ 'mɨɨ'³ 'iún² 'ne'² rɨ²³cuǿø²³ uu'n² co̱o̱³ 'noo³¹ 'i³ 'a²³'e³ xa³ quie'². 'E³ quie'²³ la'³ dsa³ 'i³ xa³ 'e³ rɨ²³e'². 'Ne'² rɨ²³cuǿø²³ uu'n² 'i³ 'a²³'e³ xa³ 'e³ rɨ²³e'². ―La'³ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","I²guín¹ 'io'² co̱'³ 'e³ jua'³ 'née²³ rɨ²³sáan²³te'²³ jmɨɨ³. I²xii'²³²te'¹ Juan: ―Dsa³ 'e²³, ¿jmii'³¹ 'ne'² rɨ²jmee²ra'³¹ jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","'E³ jo̱³ ca²³jua'³ Juan. Ca²³sɨ'²³ dsa³ 'í³: ―'Ne'² rɨ²có̱²ra'³ la²³'nɨɨ'n³¹ 'e³ rɨ³lø³¹ 'i'²³ mɨ³rɨ³co̱³ra'³ cuu² quie'² dsa³. 'A²³ ma²³ rɨ³co̱³ra'³ dsɨ³² cɨ² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Xen³ te'²³ dsa³ 'láa³ co̱'³ 'i³ ca²³ŋɨ́ɨ³ júu². Ca²³sɨ'²³ Juan: ―¿Jmii'³¹ 'ne'² rɨ²jmee² jnee'³¹? ―ca²³jua'³te'²³. 'E³ jo̱³ ca²³jua'³ Juan: ―'A²³ ma²³ rɨ³jmee³ra'³ la³jmøn³¹na'³ 'e³ 'noo³ra'³ rɨ²jmee'³¹ra'³ 'i̱i̱³ dsa³. 'E³ quie'²³ la'³ 'a²³ ma²³ rɨ³mi³sá²ra'³ dsoo² quiee'³² dsa³ jmø'n² u²³sɨ²³júu² 'e³ 'noo³ra'³ rɨ²jmee'³¹ra'³ 'i̱i̱³ dsa³. Rɨ²jmée²ra'³ 'e³ líi² 'nɨɨ'n³¹ jñiin²³na'³. ―La'³ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bi²³ ca²³jóo² dsa³ 'e³ jmii'³¹ rɨ²³jmée²³ Juan. Ca²³jmóo² 'i'²³ la²³jɨn³ dsa³ 'e³ 'i̱i̱² sɨɨ'³¹ Juan. Ma³ xi² Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios nɨ³, lǿn³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","'E³ jo̱³ ca²³jua'³ Juan. Ca²³sɨ'²³ dsa³: ―Jmɨɨ³ hua² ca'n³² jné² 'e³ la²³ xaan²³na²³ jmɨɨ³ 'nee'²³. Qui² xen³ jia'³ cɨ'²³ 'i³ cɨ² rɨ²³güén³. Rɨ²³jmée²³ 'ñée² 'e³ rɨ²cø̱n²³na'³ Espíritu Gáan³. Rɨ²³jmée²³ 'e³ rɨ²³dxi²³quié̱n²na'³ la²³ dxi³quié̱n² dsa³ 'i³ sɨ³cáan²³ dxi³¹ji³. La'³ cu³lø³¹ rɨ²³xáan² jmɨɨ³ 'nee'²³. 'Uee'n³ cɨ² júu² quiee'³² 'ñée² la²³ cɨ'²³ jné². 'A²³jia'³ li²³bii²³ dsɨn²³ cu³xi³ 'e³ rɨ²'uøøn²³² loo³ 'e³ taa'² tɨɨ² dsa³ 'í³ la²³'nɨɨ'n³¹ 'uee'n³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","'É̱e̱² 'e³ mɨ³so̱o̱'²³ cuaa'² quiee'³² 'e³ jua'³ rɨ²³juá² mɨ³¹cuɨɨ³ trigo 'e³ cu²ŋɨ́ɨ³ sɨ́². Mɨ³rɨ³cuaa'n²³ 'ñén²³ mɨɨ³¹ rɨ²³to'²³ saco, rɨ²³dxá²³ dxʉ́²³. 'E³ quie'²³ rɨ²³to'²³ sɨ́² dxi³¹ji³ je² 'a²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³ ji³. ―La'³ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Bi²³ cɨ² ñúun³ la²³jɨ³ 'e³ ca²³sɨ'²³ dsa³ 'e³ rɨ²³jmóo² 'e³ la²³ ca²³'ɨ́ɨ³ júu² dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Co̱'³ cɨ'²³ ca²³lʉ́³ Juan. Ca²³sɨ'²³ dxi² juɨɨ³ 'i³ xi̱i̱n³ Herodes 'e³ 'a²³jia'³ dxʉ́²³ jmee²³. Qui² tǿø² Herodes mɨ²³quie'² jó̱o̱², mɨ́³ 'i³ xi̱i̱n³ Herodías. Ñúun³ la²³jɨ³ 'e³ 'a²³jia'³ dxʉ́²³ 'e³ ca²³jmée³ Herodes. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","'E³ quie'²³ xa³ cɨ² 'e³ bi²³ 'a²³jia'³ dxʉ́²³ ca²³jmée³: Ca²³ta̱a̱'n³ i²³ñí² Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","'Íi² rɨ²³lí³ la'³, ma²ca¹jŋáan³ jmɨɨ³ la²³jɨn³ dsa³, ca²³jŋáan³ jmɨɨ³ Jesús co̱'³. 'E³ la²³ ca²³lʉ́³ Jesús quia̱'² Dios, ca²³nó³ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jŋáan² Espíritu Gáan³ ñi'² quiee'³² Jesús. Jnén³ Espíritu Gáan³ 'e³ la²³ jŋáan². La²³ lǿn²³ to̱³ju̱³¹ lǿn²³. Xen³ 'i³ ca²³lʉ́³ yʉʉ'³¹ güii³. Ca²³jua'³ ca²³sɨ'²³ Jesús: ―Rɨ³løn³¹nu³ ja̱a̱n²³ 'i³ bi²³ 'náan²³na²³. Jmeen³ 'nʉ³ 'e³ bi²³ jɨn³ dsɨn²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","La²³ca̱a̱n³ ma²ca¹tɨ́³ gui²³guiá³ ji̱i̱'n²³ Jesús, ca²³tín²³ ca²³jmée³ ta² quiee'³². Jo̱o̱³¹ Søø³² Jesús, lǿn³ dsa³. Jo̱o̱³¹ Elí 'ñée² Søø³². ");
INSERT INTO cnlNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Jo̱o̱³¹ Matat Elí. Jo̱o̱³¹ Leví Matat. Jo̱o̱³¹ Melqui Leví. Jo̱o̱³¹ Jana Melqui. Jo̱o̱³¹ Søø³² Jana. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jo̱o̱³¹ Matatías Søø³². Jo̱o̱³¹ Amós Matatías. Jo̱o̱³¹ Nahum Amós. Jo̱o̱³¹ Esli Nahum. Jo̱o̱³¹ Nagai Esli. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Jo̱o̱³¹ Maat Nagai. Jo̱o̱³¹ Matatías Maat. Jo̱o̱³¹ Semei Matatías. Jo̱o̱³¹ Søø³² Semei. Jo̱o̱³¹ Judá Søø³². ");
INSERT INTO cnlNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jo̱o̱³¹ Joana Judá. Jo̱o̱³¹ Resa Joana. Jo̱o̱³¹ Zorobabel Resa. Jo̱o̱³¹ Salatiel Zorobabel. Jo̱o̱³¹ Neri Salatiel. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Jo̱o̱³¹ Melqui Neri. Jo̱o̱³¹ Adi Melqui. Jo̱o̱³¹ Cosam Adi. Jo̱o̱³¹ Elmodam Cosam. Jo̱o̱³¹ Er Elmodam. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jo̱o̱³¹ Josué Er. Jo̱o̱³¹ Eliezer Josué. Jo̱o̱³¹ Jorim Eliezer. Jo̱o̱³¹ Matat Jorim. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Jo̱o̱³¹ Leví Matat. Jo̱o̱³¹ Simeón Leví. Jo̱o̱³¹ Judá Simeón. Jo̱o̱³¹ Søø³² Judá. Jo̱o̱³¹ Jonán Søø³². Jo̱o̱³¹ Eliaquim Jonán. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Jo̱o̱³¹ Melea Eliaquim. Jo̱o̱³¹ Mainán Melea. Jo̱o̱³¹ Matata Mainán. Jo̱o̱³¹ Natán Matata. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jo̱o̱³¹ David Natán. Jo̱o̱³¹ Isaí David. Jo̱o̱³¹ Obed Isaí. Jo̱o̱³¹ Booz Obed. Jo̱o̱³¹ Salmón Booz. Jo̱o̱³¹ Naasón Salmón. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Jo̱o̱³¹ Aminadab Naasón. Jo̱o̱³¹ Aram Aminadab. Jo̱o̱³¹ Esrom Aram. Jo̱o̱³¹ Fares Esrom. Jo̱o̱³¹ Judá Fares. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jo̱o̱³¹ Jacob Judá. Jo̱o̱³¹ Isaac Jacob. Jo̱o̱³¹ Abraham Isaac. Jo̱o̱³¹ Térah Abraham. Jo̱o̱³¹ Nacor Térah. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Jo̱o̱³¹ Serug Nacor. Jo̱o̱³¹ Ragau Serug. Jo̱o̱³¹ Peleg Ragau. Jo̱o̱³¹ Heber Peleg. Jo̱o̱³¹ Sala Heber. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Jo̱o̱³¹ Cainán Sala. Jo̱o̱³¹ Arfaxad Cainán. Jo̱o̱³¹ Sem Arfaxad. Jo̱o̱³¹ Noé Sem. Jo̱o̱³¹ Lamec Noé. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Jo̱o̱³¹ Matusalén Lamec. Jo̱o̱³¹ Enoc Matusalén. Jo̱o̱³¹ Jared Enoc. Jo̱o̱³¹ Mahalaleel Jared. Jo̱o̱³¹ Cainán Mahalaleel. ");
INSERT INTO cnlNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Jo̱o̱³¹ Enós Cainán. Jo̱o̱³¹ Set Enós. Jo̱o̱³¹ Adán Set. Jo̱o̱³¹ Dios Adán. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Cuø²³ jui³¹ Espíritu Gáan³ quie'² Jesús ma²ca¹bǿn³ la²³ca̱a̱n³ coo³¹ je² ro̱o̱³ jmɨɨ³ juee'³ Jordán. Espíritu Gáan³ ca²³xíin²³ Jesús je² 'a²³jia'³ nee'n²³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Núu²³ i²gua³ tú̱²³ lóo² jmɨ́ɨ². Núu²³ ca²³jmée³ lá³ mɨ²³sɨ²³quiʉ'² 'e³ jua'³ 'née²³ 'e³ rɨ²³jáan²³ Jesús. 'A²³'e³ xa³ 'e³ ca²³e'² Jesús la²³huøø'n³¹ la²³ ca²³guó³ je² 'a²³jia'³ nee'n²³² dsa³. Ma²mɨ³líi² la'³, bi²³ ca²³la²³cue̱'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ca²³jua'³ mɨ²³sɨ²³quiʉ'². Ca²³sɨ'²³ Jesús: ―Xi³nu³ 'e̱'n³ quie'²³ dsɨ́² Jo̱o̱³¹ Dios 'nʉ³, rɨ²dxín² 'i'²³ 'e³ cu²lí³ 'ɨ²³juɨ² cú̱u̱² la³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ²³sɨ²³quiʉ'²: ―To̱o̱²³ ji³ júu² quiee'³² Dios: “'A²³la³ 'nɨɨ'n³¹ 'e³ ee'³² dsa³ 'e³ jmee²³ 'e³ rɨ³ji̱'²³ dsa³. 'E³ quie'²³ la²³jɨ³ júu² 'e³ lʉ²³ Dios jmee²³ 'e³ rɨ³ji̱'²³ dsa³ ca³quie̱e̱².” ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ca²³jáa²³ mɨ²³sɨ²³quiʉ'² quie'² Jesús yʉʉ'³¹ mo'³ jɨ̱ɨ̱n²³². Ca²³'ée²³ Jesús la²³jɨ³ juɨɨ³ 'e³ xa³ la²³bee'n³¹ mɨ³¹güii³. Ca³dsɨ³² la²³ ca²³'ée²³ la²³jɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","'E³ quie'²³ jo̱³ ca²³jua'³ mɨ²³sɨ²³quiʉ'²: ―Rɨ²cuaa'n²³²na¹ guaan³² la²³ca̱a̱n³ mɨ³¹güii³. Rɨ²jmeen²³² 'e³ gáan³nu³ 'e³ la²³ dxi³ji̱i̱n³¹ li²³gáan³ jø̱n³ dsa³ 'i³ rɨ³løn³¹ juii² la²³ca̱a̱n³. Qui² née² guaan²³ la²³jɨ³ ta² 'e³ lø³² la'³. Joo'²³ líi² rɨ²cuǿøn¹ te³ 'i̱i̱² sɨɨ'³¹ 'i³ 'náan²³ rɨ²cuǿøn¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Rɨ²cuǿøn¹na²³ 'nʉ³ la²³jɨ³ xi³nu³ rɨ²mi³gáan²nu³ jné². ―La'³ ca²³jua'³ mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","'E³ quie'²³ ca²³jua'³ Jesús: ―Je̱'n² nɨ³, Satanás. Qui² to̱o̱²³ ji³ júu² quiee'³² Dios: “'Ne'² rɨ²mi³gáan²na'³ Dios Juii³ra'³. Jø̱n³ 'ñée² hua² 'i³ 'ne'² rɨ²jmée²ra'³ ta² quiee'³².” La'³ cu³lø³¹ to̱o̱²³ ji³. ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Co̱'³ cɨ'²³ ca²³jáa²³ mɨ²³sɨ²³quiʉ'². Ca²³jén²³ Jesús juɨɨ³ Jerusalén. I²jøn²³ je² jɨ̱ɨ̱n²³² cɨ² bíi²³ yʉʉ'³¹ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Ca²³jua'³ ca²³sɨ'²³ Jesús: ―Xi³nu³ 'e̱'n³ quie'²³ dsɨ́² Jo̱o̱³¹ Dios 'nʉ³, rɨ²tø'n¹nu³ 'uǿøn²nu³ 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Qui² to̱o̱²³ ji³ júu² quiee'³² Dios: Rɨ²³cuǿn² Dios ángeles quien³² 'e³ rɨ²³mi²³quin³te'²³ 'nʉ³. La'³ cu³lø³¹ to̱o̱²³ ji³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Xa³ jia'³ cɨ'²³ je² to̱o̱²³ je² 'en³² ángeles: Guoo³te'²³ xe̱e̱'n³te'²³ 'nʉ³ tén³ la²³ 'e³ la²³ 'a²³jia'³ rɨ²³ti²³quie̱³¹ cú̱u̱² tɨɨn³¹. ―La'³ ca²³jua'³ mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ²³sɨ²³quiʉ'²: ―Co̱'³ cɨ'²³ to̱o̱²³ ji³ júu² quiee'³² Dios: “'A²³ rɨ³jmee³ra'³ lá³ 'e³ juo'³ra'³ 'noo³ra'³ rɨ²³jáan²³na'³ Dios Juii³ra'³”. ―La'³ ca²³sɨ'²³ mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ma²mɨ³líi² mɨ³jmée³ mɨ²³sɨ²³quiʉ'² la²³jɨ³ lá³ 'e³ jua'³ 'née²³ rɨ²³jáan²³ Jesús, jo̱³ tu³ ca²³tʉ́ʉ². 'E³ quie'²³ nee² quie'²³ dsɨ́² mɨ²³sɨ²³quiʉ'². Lǿn³ 'ñée² 'e³ co̱'³ xi² rɨ²³li'²³ jia'³ cɨ'²³ jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Quie̱³ Jesús ju²³bíi²³ quiee'³² Espíritu Gáan³ ma²ca¹dxe'n¹ co̱'³ estado Galilea. Ca²³sóo²³ ca²³jó²³ júu² la²³ca̱a̱n³ 'e³ jmii'³¹ lǿ² jmee²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ca²³'ée²³ dsa³ la²³ca̱a̱n³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Ca²³mi²³gáan³ Jesús la²³jɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ca²³dxe'n² juɨɨ³ Nazaret, juɨɨ³ je² ca²³la²³gáan³ 'ñée². Jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ ñíin² 'ñʉ́² je² mi³gáan³ Dios dsa³ Nazaret 'e³ la²³ to̱'²³ ŋɨ́³. Ca²³noo³ 'e³ jua'³ rɨ²³'ɨ́²³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'E³ jo̱³ ca²³cuǿø²³te'²³ ji³ 'e³ taa'² júu² quiee'³² Dios 'e³ ca²³sɨ́ɨ³ Isaías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². Ca²³jǿn² ji³ Jesús. Ca²³dso'²³ je² to̱o̱²³ júu² la³: ");
INSERT INTO cnlNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","'Iún² dsɨn²³ Espíritu Gáan³ quien³² Dios Juii³ra². Qui² mɨ³dxin³ jné² 'e³ rɨ²'ɨɨn²³² júu² dxʉ́²³, 'e³ rɨ²juøøn³¹ dsa³ taan³. Mɨ³xíin²³ jné² 'e³ rɨ²jmeen²³² 'e³ jɨn³ dsɨ́² co̱'³ dsa³ 'i³ 'aa³ u²³ŋɨ́³ dsɨ́ɨ². Mɨ³xíin²³ jné² 'e³ rɨ²juøøn³¹na¹ dsa³ 'i³ rɨ³jnɨn²³ 'e³ rɨ²³láan³te'²³, 'e³ rɨ²juøøn³¹na¹ dsa³ tuu² mɨ²ñi² 'e³ li²³jnée²³te'²³. Mɨ³xíin²³ jné² 'e³ rɨ²láan¹na²³ dsa³ 'i³ bi²³ mɨ³jme'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mɨ³xíin²³ jné² 'e³ rɨ²'ɨɨn²³² júu² 'e³ mɨ³tɨ́³ jmɨ́ɨ² 'e³ rɨ²³mi²³jé̱e̱n² dsa³ Dios Juii³ra². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ca²³cu̱u̱n³ ji³ Jesús. Ca²³jɨ̱'²³ co̱'³ dsa³ 'i³ 'aa³ ji³. Ca²³gua³. Bi²³ juø'²³ ca²³jóon² Jesús la²³jɨn³ dsa³ 'i³ ta'n² xi²ñʉ'¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ca²³jua'³ 'ñée² Jesús. Ca²³sɨ'²³ dsa³: ―Jmɨ́ɨ² 'e³ rɨ³nɨ²³ je² nuu³ra'³ la²³jɨn³na'³ mɨ³lǿ²³ 'e³ la²³ to̱o̱²³ ji³ la³ 'e³ rɨ²³lí³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bi²³ juø'²³ ca²³núu³ la²³jɨn³ dsa³ júu² 'e³ ca²³'é³ Jesús. ―Bi²³ dxʉ́²³ júu² 'e³ lʉ²³ ―ca²³jua'³te'²³―. Jo̱o̱³¹ Søø³² dsa³ la³, ¿mɨ³naa'³¹? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³: ―Maan²³ 'e³ ca³quie̱e̱² rɨ²juɨɨ'³¹ra'³ jné² júu² 'e³ jua'³ dsa³: “Tɨ³² 'oo³, mi³'láan² 'uǿøn²nu³.” Rɨ²juɨɨ'³¹ra'³ jné² co̱'³: “Rɨ²jméen² u²³juø'²³ je² la³ juɨɨ³ quien³²nu³ 'e³ la²³ mɨ³nʉʉ²ra'³¹ 'e³ mɨ³jméen² juɨɨ³ Capernaum”. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Co̱'³ cɨ'²³ ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³'i̱³ xen³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios 'i³ mi³juø'²³te'²³ juɨɨ³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Rɨ²juøøn³¹na¹ 'nee'²³ 'e³ ca³quie̱e̱² bi²³ juɨ́ɨn²³ mɨ́³ 'nɨ́ɨ³ xen³ juɨɨ³ quiee'³² dsa³ Israel mɨ²jo̱³ ma²güen²³² mɨ³¹güii³ Elías. Qui² 'nɨ³ ji̱i̱³ ñi³ dsɨ³² ca³dxoo² 'a²³jia'³ ca²³jmée³ jmɨ́² mɨ²jo̱³. Bi²³ 'a²³'e³ xa³ 'e³ rɨ²³e'² dsa³ la²³ca̱a̱n³ ca²³lǿ²³ mɨ²jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","'E³ quie'²³ 'a²³jia'³ ca²³dxi³ 'i'²³ Dios 'e³ rɨ²³jmée²³ Elías co̱²juø'¹ quie'² mɨ́³ 'nɨ́ɨ³ 'i³ xen³ quie'² dsa³ Israel. Dios ca²³xíin²³ Elías co̱o̱³ juɨɨ³ quiee'³² dsa³ jia'³ je² xi̱i̱n³ Sarepta je² røøn³ Sidón. Ca²³dxi³ 'i'²³ 'e³ rɨ²³jmée²³ co̱²juø'¹ quie'² jø̱n³ mɨ́³ 'nɨ́ɨ³ 'i³ xen³ núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","'E³ quie'²³ la'³ Eliseo co̱'³. 'A²³la³ juɨɨ³ quiee'³² je² ca²³jmée³ u²³juø'²³ mɨ²jo̱³. Bi²³ juɨ́ɨn²³ dsa³ 'i³ ta̱a̱n²³ goo³ xen³ juɨɨ³ quiee'³² dsa³ Israel mɨ²jo̱³ ma²ca¹'ɨ́ɨ³ Eliseo júu² quiee'³² Dios. 'E³ quie'²³ 'a²³la³ dsa³ Israel 'i³ ta̱a̱n²³ goo³ 'i³ ca²³'láan³. Jø̱n³ dsa³ jia'³ 'i³ xi̱i̱n³ Naamán 'i³ xen³ juɨɨ³ Siria ca²³mi²³'láan³ Eliseo. ―La'³ cu³lø³¹ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bi²³ ca²³ti̱'n³ la²³jɨn³ dsa³ 'i³ ta'n² xi²ñʉ'¹ ma²ca¹núu³te'²³ júu² 'e³ ca²³lʉ́³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ca²³naa'n²³te'²³. Ca²³dxin³te'²³ Jesús 'ioo³¹ juɨɨ³. Ca²³jøn²³te'²³ je² dsøn³ cuo̱o̱'³ je² née² juɨɨ³ quiee'³²te'²³. Qui² 'née²³te'²³ rɨ²³'le'n²te'²³ Jesús je² juɨɨ'²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","'E³ quie'²³ ca²³ŋɨ́n³ Jesús jee²³² la²³ cɨ² dsa³. Ŋóo² jia'³ cɨ'²³ to̱o̱²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ca²³dxóo² Jesús juɨɨ³ Capernaum estado Galilea. Núu²³ ca²³'ée²³ dsa³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bi²³ juø'²³ ca²³núu³ dsa³ 'e³ jmii'³¹ ca²³'é³ Jesús. Qui² ca²³lʉ́³ la²³ lʉ²³ jø̱n³ dsa³ 'i³ xa³ ta² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Capernaum 'iún² jø̱n³ dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². Bi²³ quiʉ̱ʉ̱³ ca²³yo'³. Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Ay! ¿'Ee² lǿ² ta̱a̱'n²³nu³ 'uǿøn²nu³ quia̱'n²nu³ jnee'³¹, Jesús dsa³ Nazaret? ¿'A² mɨ³güen²³nu³ la³ 'e³ juø'n³ 'naan³ rɨ²jŋɨ'n²³nu³ jnee'³¹? Cuiin²³na'³¹ 'nʉ³ 'e³ 'i̱i̱² sɨɨ'³¹ 'nʉ³. Qui² rɨ³løn³¹nu³ dsa³ 'i³ rɨ³jɨ́n² quien³² Dios. ―La'³ ca²³jua'³ dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ca²³jín² espíritu quien³² mɨ²³sɨ²³quiʉ'² Jesús. Ca²³jua'³: ―Tu³cɨ² 'nʉ³. Cu³bøøn²³nu³ dsa³ nɨ³. La²³røøn³ ca²³'lǿn²³ 'uǿ²³ dsa³ 'í³ xi²ñi² la²³jɨn³ dsa³. La'³ cu³lø³¹ ca²³jmée³ espíritu 'i³ quie̱n³ dsa³ 'í³. Jo̱³ tu³ ca²³bǿn³. 'A²³'e³ xa³ ca²³ji̱'²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bi²³ juø'²³ ca²³jóo² la²³jɨn³ dsa³. Ca²³jua'³te'²³ i²³la³ i²³nɨ³. Ca²³'én²te'²³ Jesús: ―¿'Ee² júu² tɨn³ dsa³ nɨ³? La²³ 'uee'n³ júu² quiee'³² dsa³ 'i³ xa³ ta² quiee'³² 'uee'n³ júu² quiee'³² 'e³ la²³ jin³² espíritus quien³² mɨ²³sɨ²³quiʉ'². Bi²³ xa³ ju²³bíi²³ quie'². Qui² sɨ³'uǿøn²³ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'e³ la²³ dxi³ 'i'²³ 'ñée² ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ca²³sóo²³ ca²³jó²³ júu² la²³ca̱a̱n³ je² mɨ³lén² la²³ juɨɨ³ Capernaum 'e³ jmii'³¹ jmee²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ca²³bǿn³ Jesús 'ñʉ́² je² mi³gáan³ Dios dsa³ Capernaum. 'Í² xi²ñʉ'¹ quiee'³² Muun³². Dsoo'²³² xóo² mɨ²³quie'² Muun³². Bi²³ 'uee'n³ dsóo² dxíi³ lǿn²³. 'E³ jo̱³ ca²³sɨ'²³te'²³ Jesús 'e³ rɨ²³jmée²³ co̱²juø'¹ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'E³ jo̱³ ca²³noo³ Jesús mɨ³lén² caan²³ mɨ́³. Ca²³jín² dsóo² dxíi³ 'e³ lǿn²³ mɨ́³ 'í³. 'E³ jo̱³ ca²³je̱'n²³ dsóo² dxíi³. Xe̱'n² jmɨ́ɨ² ca²³naa'n²³ mɨ́³. Ca²³jí̱² ca²³tí³ ca²³mi²³quin³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","La²³ca̱a̱n³ ma²ca¹nʉʉ³, i²jøn²³te'²³ dsa³ 'i³ dsoo'²³² caan²³ Jesús. La'³ ca²³jmóo² la²³jɨn³ dsa³ 'i³ xen³ dsa³ 'i³ dsoo'²³² quie'². Ñúun³ 'iin³² dsóo² lǿn²³te'²³. Jesús ca²³dxá³ guoo³ ñi'² quiee'³² cɨ'³ la²³ jø̱n³te'²³. 'E³ jo̱³ ca²³mi²³'láan³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bi²³ juɨ́ɨn²³ dsa³ 'i³ lɨ́ɨn² ma²ca¹'uǿøn¹ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'i³ quie̱n³te'²³. Ca²³yo'³ espíritus. ―Jo̱o̱³¹ Dios 'nʉ³ ―ca²³jua'³te'²³. 'E³ quie'²³ ca²³jín² espíritus Jesús. 'A²³jia'³ ca²³cuǿ³ júu² 'e³ rɨ²³lʉ́²³te'²³. Qui² cuiin²³te'²³ 'ñée². Ñi³²te'²³ 'e³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ma²mɨ³la³jné²³, ca²³bǿn³ jee²³² juɨɨ³ Jesús. Ŋóo² je² 'a²³'i̱³ xen³ dsa³. 'E³ quie'²³ ca²³'naa'n³te'²³ Jesús. Ca²³guín²³te'²³ je² ŋóo² 'ñée². Qui² 'a²³jia'³ ma²³ 'née²³te'²³ 'e³ rɨ²³dsóo² jia'³ cɨ'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³: ―'Ne'² ñiin²³ la²³ca̱a̱n³ jia'³ cɨ'²³ juɨɨ³. 'Ne'² i³xii'n²³² dsa³ núu²³ co̱'³ júu² dxʉ́²³ 'e³ rɨ³løn³¹ Dios juii² dsa³. 'E³ jo̱³ hua² ca²³xíin²³ jné² Dios ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ca²³ŋɨ́³ Jesús la²³ca̱a̱n³ estado Galilea jo̱o̱²³. Ca²³'ɨ́ɨ³ júu² quiee'³² Dios ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ca²³tɨ́³ jmɨ́ɨ² 'e³ xi'n²³ Jesús co̱³² jmɨ²³ñii'³¹ Genesaret. Bi²³ ca²³cu'n² dsa³ la²³'nɨɨ'n³¹ 'née²³ rɨ²³núu²³te'²³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ŋó²³ Jesús 'e³ xa³ tú̱²³ móo² 'e³ ji̱i̱²³² ji̱i̱'² jmɨɨ³. Qui² mɨ³'uǿøn²³ móo² dsa³ 'i³ cø̱n³² 'moo'³. Ta'n² u̱u̱'³²te'²³ 'mó² quiee'³²te'²³ ji̱i̱'² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","'Í² Jesús co̱o̱³ móo² quiee'³² dsa³ 'i³ xi̱i̱n³ Muun³². Ca²³jua'³ Jesús, ca²³sɨ'²³ Muun³² 'e³ rɨ²³guín² ca³juɨ² móo² jo̱³ ma²mɨ³guó³ 'e̱'³. 'E̱'³ móo² jen³¹ 'ñée² ca²³'ée²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma²mɨ³líi² mɨ³'ɨ́ɨ³ júu² Jesús, ca²³jua'³ ca²³sɨ'²³ Muun³²: ―Guo³ je² jɨ̱ɨ̱n²³². Jioo²³²ra'³ 'mó² quien³²na'³ 'e³ rɨ²cø̱n²³na'³ 'moo'³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","'E³ jo̱³ ca²³jua'³ Muun³²: ―Dsa³ 'e²³, jia'²³ 'uøø²³ mɨ³jmee²ra'³¹ ta². 'E³ quie'²³ 'a²³'i̱³ xen³ mɨ³jáan³na'³¹. 'E³ quie'²³ rɨ²jiaan³¹ co̱'³ 'mó² xi³nu³ la'³ juø'n³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma²ca¹jióo¹te'²³ co̱'³ 'mó², bi²³ ma²³'nee³ juɨ́ɨn²³ 'moo'³ ca²³ta'n²³. 'E³ jo̱³ ca²³gɨɨ³ ca³juɨ² 'mó² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ca²³juá² guoo³te'²³. Ca²³jén²³ uu'n²te'²³ 'i³ ta'n² jia'³ cɨ'²³ móo² 'e³ cu²ja³guín²³ rɨ²³jmóo² co̱²juø'¹. I²³guín²³ uu'n². Ca²³mi²³quie̱e̱'n²³²te'¹ 'moo'³ ca³ti³² la²³ tú̱²³ móo². 'E³ jo̱³ rɨ²³ten²³ rɨ²³'a'² móo². ");
INSERT INTO cnlNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ma²ŋo²³² Muun³² Peen²³² 'e³ jmii'³¹ ca²³lǿ²³, ca²³quiaa³ rɨ³'in³² xi²ñi² Jesús. Ca²³jua'³: ―Je̱'n² cɨ² ca³juɨ², Juiin²³. Qui² bi²³ xa³ dsoo² quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","La'³ ca²³jmée³ Muun³². Qui² bi²³ juø'²³ ca²³jóo² ca³ti³² quia̱'² la²³jɨn³ uu'n² 'e³ jmii'³¹ 'nɨɨ'n³¹ juɨ́ɨn²³ 'moo'³ ca²³jáan³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","'E³ quie'²³ la'³ Jacobo quia̱'² Juan, te'²³ jo̱²³ñʉʉ'³¹ Zebedeo, 'i³ rɨ³løn³¹ uu'n² Muun³². 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Muun³²: ―'A²³ rɨ³juø'n²nu³ 'uǿøn²nu³. Qui² rɨ³nɨ²³ rɨ²³li²³láa²³ 'e³ rɨ²tøøn³¹ dsa³ 'e³ la²³ lǿ² 'e³ mɨ³quie̱n²³nu³ 'moo'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","'E³ jo̱³ ca²³ta̱a̱'n²³te'²³ co̱'³ jui³¹ móo². Ca²³dxi²³guiin³²te'²³ 'uǿ²³ rɨ³quiʉ̱ʉ̱³. 'E³ quie'²³ jo̱³ ca²³cuaa'n³te'²³ la²³jɨ³ 'e³ xa³ quie'²te'²³. Ca²³guín²³te'²³ quia̱'²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","'E³ la²³ jen³¹ Jesús co̱o̱³ juɨɨ³, ca²³dxóo² caan²³ Jesús jø̱n³ dsa³ 'i³ bi²³ ma²³'nee³ ta̱a̱n²³ goo³. Ma²ŋøn³¹ Jesús dsa³ 'í³, ca²³quiaa³ rɨ³'in³². Ca²³jua'³: ―Juiin²³, rɨ²³lí³ juø'² rɨ²jméen² 'e³ rɨ²³jñíin³ la³'en²³ xi³nu³ 'naan³ rɨ²jméen² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","'E³ jo̱³ ca²³'ɨ́ɨ³ guoo³ Jesús. Ca²³quiu̱u̱'n³ dsa³ 'í³. Ca²³jua'³: ―'Náan²³ xú̱n³. Cu²jñíin³ la³'én². Xe̱'n² quie'²³ jo̱³ ca²³je̱'n²³ goo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'A²³ rɨ³juɨɨ'n³² dsa³ 'e³ la²³ mɨ³lǿ²³. 'E³ quie'²³ guaan³² cu³'én² 'uǿøn²nu³ jmii³ dsa³. Rɨ²cuøøn³¹nu³ Dios la²³jɨn³ 'i³ cuøn³² dsa³ 'i³ mɨ³jŋɨn³ la³'e². Qui² la'³ cu³lø³¹ ca²³dxi³ 'i'²³ Moisés. Jo̱³ hua² rɨ²³dsóo²³ dsɨ́² dsa³ 'e³ mɨ³jŋɨn³ la³'én². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","'E³ quie'²³ bi²³ cɨ² ca²³sóo²³ ca²³jó²³ júu² 'e³ jmii'³¹ jmee²³ Jesús. Bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ i²guín¹ caan²³ Jesús. Qui² 'née²³ rɨ²³núu²³te'²³ júu² quiee'³². 'Née²³ rɨ²³'láan³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","'E³ quie'²³ xa³ ma² ŋɨ́³ Jesús je² 'a²³jia'³ nee'n²³² dsa³ 'e³ lʉ²³ quia̱'² Dios Jmii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ca²³tɨ́³ co̱o̱³ jmɨ́ɨ² 'e³ jen³¹ Jesús 'ee²³ dsa³: Xen³ dsa³ fariseo quia̱'² dsa³ 'e²³ ley 'i³ nee'n²³² núu²³. Ca²³'uǿøn²³te'²³ la²³jɨ³ juɨɨ³ estado Galilea quia̱'² estado Judea quia̱'² juɨɨ³ Jerusalén. I²guín¹te'²³ caan²³ Jesús 'e³ jua'³ rɨ²³tén²te'²³. Quie̱³ Jesús ju²³bíi²³ quiee'³² Dios Juii³ra² 'e³ la²³ rɨ²³lí³ juø'² rɨ²³mi²³'láan³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","'E³ quie'²³ jo̱³ ca²³dxi²³guín²³ dsa³ 'i³ quie̱n³ jø̱n³ dsa³ 'i³ tu̱u̱n²³². 'Iún² jmoo³ 'e³ quie̱n³te'²³. 'Née²³ rɨ²³ta'n²³te'²³ xi²ñʉ'¹ quia̱'²te'²³ dsa³ 'i³ tu̱u̱n²³². 'Née²³ rɨ²³quiaan³te'²³ xi²ñi² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","'E³ quie'²³ 'a²³'e³ xa³ rɨ²³lí³ juø'² rɨ²³jmóo² 'e³ rɨ²³ta'n²³te'²³ xi²ñʉ'¹ quia̱'²te'²³ dsa³ 'i³ tu̱u̱n²³². Qui² bi²³ juɨ́ɨn²³ dsa³ ta'n². 'E³ jo̱³ ca²³huɨ́ɨ³te'²³ coo'² 'ñʉ́². Ca²³je̱'n²te'²³ joo³¹ 'ia³. Ca²³jióo²te'²³ jmoo³ 'e³ 'iún² dsa³ 'i³ tu̱u̱n²³². Ca²³jióo²te'²³ jee²³² dsa³ xi²ñi² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ma²ca¹la¹quii²³ Jesús 'e³ jmii'³¹ 'nɨɨ'n³¹ sɨ³táan³te'²³ quia̱'²te'²³ 'ñée², ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ tu̱u̱n²³²: ―Mɨ³uu³ dsoo² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","'E³ jo̱³ ca²³xín³ ca²³'ín³ dsa³ 'e²³ ley quia̱'² dsa³ fariseo. Qui² lǿn³te'²³: “¿'I̱i̱² hua² dsa³ nɨ³? Bi²³ 'ñe'² júu² 'e³ mɨ³lʉ́³. Jua'³ 'ñée² 'e³ jmee²³ 'e³ la²³ jmee²³ Dios. Jø̱n³ Dios hua² 'i³ sɨ³li'²³ juø'² yʉʉ²³ dsoo² quiee'³² dsa³, ¿mɨ³naa'³¹?” ");
INSERT INTO cnlNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ma²ca¹la¹quii²³ Jesús 'e³ jmii'³¹ xín³ 'ín³te'²³, ca²³jua'³ ca²³sɨ'²³ dsa³ 'e²³ ley quia̱'² dsa³ fariseo: ―¿'Ee² lǿ² xín³ 'ín³na'³ la'³? ");
INSERT INTO cnlNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jmii'³¹ cu³lø³¹ 'e³ tu³sɨ'²³ cɨ², lǿn³na'³? ¿'A² tu³sɨ'²³ cɨ² 'e³ rɨ²juøøn³¹na¹: “Mɨ³uu³ dsoo² quien³²nu³”? ¿'A² tu³sɨ'²³ cɨ² 'e³ rɨ²juøøn³¹na¹: “Naa'n²³ 'nʉ³. Ŋɨ² 'nʉ³”? ");
INSERT INTO cnlNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","'E³ quie'²³ 'náan²³ 'e³ rɨ²móo²ra'³ 'e³ xa³ ca³dsaan³² quián²³ jné² Jo̱o̱³¹ Dsa³ mɨ³¹güii³ la³ 'e³ yuun²³²na¹ dsoo² quiee'³² dsa³. 'E³ jo̱³ ca²³sɨ'²³ dsa³ 'i³ tu̱u̱n²³²: ―Rɨ²juøøn³¹na¹ 'nʉ³: Naa'n²³ 'nʉ³. Ben²³² jmoo³ quien³²nu³. Guø'n³ quién²nu³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Xe̱'n² jmɨ́ɨ² ca²³naa'n²³ dsa³ 'i³ tu̱u̱n²³² xi²ñi² dsa³. Ca²³bén² jmoo³ 'e³ 'iún² xe̱'n². Ca²³mi²³gáan³ Dios 'e³ la²³ ŋø'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","'E³ jo̱³ bi²³ juø'²³ ca²³ti²³cø̱n³¹ la²³jɨn³ dsa³. Ca²³mi²³gáan³te'²³ Dios. Bi²³ juøø'n²³te'²³. 'E³ jo̱³ ca²³jua'³te'²³: ―Bi²³ juø'²³ cu³lø³¹ la²³jɨ³ 'e³ mɨ³joo²³²ra² rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ma²mɨ³líi² la'³ jo̱o̱²³na²³, ca²³bǿn³ co̱'³ Jesús. Ca²³ti²³cø̱n³¹ jø̱n³ 'io'² 'i³ xi̱i̱n³ Leví. Jen³¹ je² co̱³² cuu². 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Leví: ―Ñe³ quia̱'n²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","'E³ jo̱³ ca²³naa'n²³ Leví. Ca²³cuaa'n³ la²³jɨ³ 'e³ xa³ quie'². Ŋóo² quia̱'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ca²³tɨ́³ 'e³ ca²³jmée³ ji̱i̱³ mó² Leví 'e³ rɨ²³tøø³ Jesús 'e³ rɨ²³e'² xi²ñʉ'¹ quiee'³². Bi²³ juɨ́ɨn²³ 'io'² quia̱'² jia'³ cɨ'²³ dsa³ 'i³ ta'n² ee'³² coo³¹ mesa. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","'E³ jo̱³ ca²³lʉ́³ dsa³ fariseo quia̱'² dsa³ 'e²³ ley. Ca²³jín²te'²³ dsa³ quien³² Jesús. Ca²³jua'³te'²³: ―¿'Ee² lǿ² 'u'³ cø'³ra'³ quia̱'n²na'³ 'io'² quia̱'n²na'³ dsa³ tu³cua̱a̱n²tu²? ");
INSERT INTO cnlNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ fariseo quia̱'² dsa³ 'e²³ ley: ―'A²³'e³ xa³ je² 'ne'² tɨ³² 'oo³ quie'² te'²³ dsa³ 'i³ 'a²³jia'³ dsoo'²³². 'E³ quie'²³ dsa³ 'i³ dsoo'²³² hua² 'i³ 'ne'² tɨ³² 'oo³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","'A²³la³ dsa³ 'i³ lǿn³ miin²³ 'e³ jmoo³² ca³dsaan³² 'i³ rɨ²tøøn³¹na¹ 'e³ mɨ³güén²³na²³. 'E³ quie'²³ mɨ³güén²³na²³ 'e³ rɨ²tøøn³¹na¹ dsa³ 'i³ mɨ³la³quii²³ miin²³ 'e³ 'a²³jia'³ dxʉ́²³ jmoo³². 'Náan²³ 'e³ rɨ²³tʉ́²te'²³ 'e³ jmoo³²te'²³ 'e³ 'a²³jia'³ dxʉ́²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Cɨ'² ji̱'² jmoo³² mɨ²³jmɨɨ²³ dsa³ quien³² Juan. Cɨ'² ji̱'² lʉ²³te'²³ quia̱'²te'²³ Dios. 'E³ quie'²³ la'³ dsa³ quien³² dsa³ fariseo co̱'³. Tén³ 'ɨ̱ɨ̱'³² ee'³² dsa³ quien³²nu³. ¿'Ee² lǿ² jmoo³²te'²³ la'³? ");
INSERT INTO cnlNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'A²³jia'³ joo'²³ rɨ²juɨɨ'³¹ra'³ dsa³ 'i³ nee'n²³² mɨ²juee'³ je² mɨ³tøø³² dsa³ mɨ́³ 'e³ cu²jmóo¹ mɨ²³jmɨɨ²³ xi³nu³ jen³¹ quie'²³ dsa³ 'i³ mɨ³tøø³² mɨ́³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","'E³ quie'²³ 'e³ cɨ² rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ 'a²³jia'³ ma²³ quia̱'²te'²³ dsa³ 'i³ mɨ³tøø³² mɨ́³. Jmɨ́ɨ² jo̱³ hua² 'e³ rɨ²³jmóo²te'²³ mɨ²³jmɨɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Co̱'³ cɨ'²³ ca²³lʉ́³ Jesús co̱o̱³ júu² 'e³ 'e²³ jmii'³¹ lǿ² júu² 'mɨɨn³² quiee'³². Ca²³jua'³: ―'A²³jia'³ rɨ²³ti²³guo² xi³nu³ rɨ²³xíin² dsa³ co̱o̱³ 'noo³¹ cuo̱o̱³ 'e³ 'mɨɨn³² 'e³ jua'³ rɨ²³te̱e̱³ cuo̱o̱³ 'e³ jaa²³². Xi³nu³ rɨ²³jmée²³ la'³, rɨ²³yáan²³ cuo̱o̱³ 'e³ 'mɨɨn³² 'e³ mɨ³xíin². Co̱'³ cɨ'²³ 'a²³jia'³ dxi³ji̱i̱n³¹ 'noo³¹ cuo̱o̱³ 'e³ 'mɨɨn³² quia̱'² cuo̱o̱³ 'e³ jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","'E³ quie'²³ la'³ cu³lø³¹ quie'² jmɨɨ'³¹ mɨ²jø'² vino co̱'³. 'A²³jia'³ rɨ²³ti²³guo² xi³nu³ rɨ²³xi'²³ dsa³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'mɨɨn³² 'e̱'³ tuu'³ loo³ jaa²³². Xi³nu³ rɨ²³jmée²³ la'³, rɨ²³mo'² tuu'³ loo³ mɨ³rɨ³juii³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'mɨɨn³². Rɨ²³tʉ̱ʉ̱³ jmɨɨ'³¹ mɨ²jø'² vino. Rɨ²³yáan²³ tuu'³ loo³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","'Ne'² rɨ²³xi'²³ dsa³ jmɨɨ'³¹ mɨ²jø'² vino 'mɨɨn³² 'e̱'³ tuu'³ loo³ 'e³ 'mɨɨn³². La'³ hua² 'a²³'e³ xa³ rɨ²³lí³ ca³ti³². ");
INSERT INTO cnlNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","'A²³jia'³ 'née²³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'mɨɨn³² dsa³ 'i³ 'ɨ̱ɨ̱'³² jmɨɨ'³¹ mɨ²jø'² vino 'e³ jaa²³². Qui² jua'³ 'ñée²: “Bi²³ cɨ² dxʉ́²³ 'e³ jaa²³²”. ―La'³ cu³lø³¹ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ca²³tɨ́³ 'e³ ca²³ŋɨ́n³ Jesús je² rɨ³dsɨ³² cuɨɨ³ trigo co̱o̱³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. Su̱'² mɨ³¹maa'n³ mɨ³¹cuɨɨ³ trigo dsa³ quien³² 'e³ la²³ ta'n²te'²³ jui³¹. Ca²³jñu'n²te'²³ joo³¹ guoo³te'²³ mɨ³¹cuɨɨ³ trigo. 'E³ jo̱³ ca²³cuu'³te'²³ mɨɨ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Xen³ dsa³ fariseo 'i³ ca²³jua'³: ―¿'Ee² lǿ² jmee³ra'³ 'e³ 'a²³jia'³ joo'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'A² 'a²³jia'³ lɨ'³ ca³jóo²ra'³ ji³ je² to̱o̱²³ 'e³ jmii'³¹ ca²³jmée³ David ma²ca¹la¹cue̱'¹ mɨ²jo̱³ ca³ti³² quia̱'² dsa³ 'i³ quia̱'²? ");
INSERT INTO cnlNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Qui² 'í² ñʉ'²³ 'ñʉ́² je² mi³gáan³ dsa³ Dios. Có̱²³ 'ɨ²³juɨ² 'mɨ'n²³ 'e³ ca²³cuǿø²³te'²³ Dios. Ca²³e'² 'e³ jo̱³, juø'n³ quie'²³ 'nɨɨ'n³¹ jmii³ dsa³ hua² joo'²³ rɨ²³e'². ");
INSERT INTO cnlNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ fariseo: ―Jné² Jo̱o̱³¹ Dsa³ rɨ³løn³¹na¹ juii² jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jia'³ cɨ'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ 'í² Jesús ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Ca²³'ée²³ dsa³. Núu²³ 'iún² jø̱n³ dsa³ 'i³ 'uaa'³ guoo³ jaan²³ 'e³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ca²³tén² Jesús dsa³ 'e²³ ley quia̱'² dsa³ fariseo. Qui² 'née²³ rɨ²³jóo²te'²³ xi² rɨ²³mi²³'láan³ dsa³ 'í³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. Qui² 'née²³te'²³ 'e³ li²³xa³ jui³¹ 'e³ rɨ²³mi²³sa³te'²³ dsoo² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","'E³ quie'²³ ñi³² Jesús 'e³ jmii'³¹ lǿn³te'²³. Ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ 'i³ 'uaa'³ guoo³: ―Naa'n²³ 'nʉ³. Noo³ dxoo'³¹ la³. 'E³ jo̱³ ca²³naa'n²³ dsa³ 'í³. Ca²³noo³ dxoo'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'e²³ ley quia̱'² dsa³ fariseo: ―Jné² rɨ²juøøn³¹na¹ 'nee'²³: ¿Jmii'³¹ dxʉ́²³ rɨ²jmee²ra² jmɨ́ɨ² je² tøø³ dsɨ́² dsa³, lǿn³na'³? ¿'A² joo'²³ rɨ²jmee²ra² 'e³ dxʉ́²³? ¿'A² joo'²³ rɨ²jmee²ra² 'e³ 'a²³jia'³ dxʉ́²³? ¿'A² joo'²³ rɨ²laan²³²na² dsa³ 'e³ 'a²³ cu²jú̱n³? ¿'A² joo'²³ rɨ²jŋɨ'n²³²na² dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","'E³ quie'²³ jo̱³ ca²³jóo² la²³cu'² Jesús. Ca²³jóon² la²³jɨn³ dsa³. Ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ 'uaa'³ guoo³: ―'Íi³ guaan³². 'E³ jo̱³ ca²³'ɨ́ɨ³ guoo³ dsa³ 'í³. 'E³ quie'²³ jo̱³ lɨ́ɨn² guoo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bi²³ ca²³mɨ'n³te'²³ ñin³²te'²³ Jesús. 'E³ jo̱³ ca²³sɨ́n²³te'²³ júu² 'e³ jmii'³¹ rɨ²³jme'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","La²³ca̱a̱n³ mɨ²jo̱³ ŋóo² yʉʉ'³¹ mo'³ Jesús 'e³ jua'³ rɨ²³lʉ́²³ quia̱'² Dios. Jia'²³ 'uøø²³ ca²³lʉ́³ quia̱'² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","'E³ la²³ ca²³la²³jné²³, ca²³tøø³ dsa³ quien³². Ca²³'uøøn³ gui²³tʉ̱́n³ dsa³ quien³² 'i³ rɨ²³sɨ'²³ dsa³ xiin²³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","'I³ la³ dsa³ 'i³ ca²³'uøøn³: Muun³² 'i³ ca²³sɨ'²³ Peen²³² quia̱'² jó̱o̱² 'i³ xi̱i̱n³ Drøø³¹, Jacobo, Juan, Bi³lii², Bar³too², ");
INSERT INTO cnlNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Tee³¹, Tu³moo³², Jacobo jo̱o̱³¹ Alfeo, Muun³² dsa³ cananista, ");
INSERT INTO cnlNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas jo̱o̱³¹ Jacobo quia̱'² Judas Iscariote 'i³ ca²³'nɨ́ɨn²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ca²³jiaan³² yʉʉ'³¹ mo'³ Jesús ca³ti³² quia̱'² dsa³ quien³². Ca²³noo³ je² jóo² je² rɨ³ŋɨɨn³¹ juɨ́ɨn²³ dsa³ quien³². Quia̱'²te'²³ juɨ́ɨn²³ dsa³ 'i³ ca²³ja²³guín²³ la²³ca̱a̱n³ estado Judea quia̱'² dsa³ 'i³ xen³ juɨɨ³ Jerusalén quia̱'² dsa³ 'i³ xen³ 'uǿ²³ co̱³² jmɨ²³ñii'³¹ je² røøn³ juɨɨ³ Tiro quia̱'² juɨɨ³ Sidón. Ca²³ja²³guín²³ dsa³ 'í³ 'e³ jua'³ 'née²³ rɨ²³núu²³te'²³ júu² 'e³ lʉ²³ Jesús, 'e³ jua'³ 'née²³ 'e³ rɨ²³mi²³'láa³ Jesús quie'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ca²³mi²³'láan³ Jesús dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","La²³jɨn³ sú̱n² dsa³ 'née²³ rɨ²³jñúun³ miin²³ Jesús. Qui² bi²³ ca²³jmée³ ta² ju²³bíi²³ quiee'³². Ca²³mi²³'láan³ la²³jɨn³ dsa³ 'i³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ca²³jóo² Jesús. Ca²³jóon² dsa³ quien³². Ca²³jua'³: ―Bi²³ dxʉ́²³ quién²na'³ 'nee'²³ dsa³ taan³. Qui² Dios rɨ³løn³¹ juii³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Bi²³ dxʉ́²³ quién²na'³ 'nee'²³ 'i³ cue̱'²³ rɨ³nɨ²³. Qui² 'e³ cɨ² li²³xa³ la²³jɨ³ 'e³ rɨ²cø'²ra'³. 'A²³'e³ ma²³ xa³ 'e³ li²³'ne'² quién²na'³. ’Bi²³ dxʉ́²³ quién²na'³ 'nee'²³ 'i³ 'oo'³² rɨ³nɨ²³. Qui² 'e³ cɨ² rɨ²ŋɨ́ɨ²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Bi²³ dxʉ́²³ quién²na'³ 'nee'²³ xi³nu³ hui²³dsɨ́ɨn²te'²³ ñin³²te'²³ 'nee'²³, xi³nu³ 'a²³jia'³ ma²³ 'née²³te'²³ rɨ²³jóon²te'²³ 'nee'²³, xi³nu³ maa'n³² lii'n³²te'²³ 'nee'²³, xi³nu³ jua'³te'²³ 'e³ 'a²³jia'³ dxún²³na'³. Bi²³ dxʉ́²³ quién²na'³ 'nee'²³ xi³nu³ rɨ²³jí̱i̱n²na'³ la'³ dsoo² 'e³ rɨ³løn³¹na'³ dsa³ quién²³na²³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","'Ne'² li²³jɨn³ 'óo²ra'³ mɨ³rɨ³li³ la'³. 'Ne'² rɨ²ŋɨ́ɨ²ra'³ la²³'nɨɨ'n³¹ 'e³ jɨn³ 'óo²ra'³. Qui² bi²³ dxʉ́²³ la²³jɨ³ jñiin²³na'³ 'e³ rɨ²³cuǿø²³ 'nee'²³ Dios yʉʉ'³¹ güii³. La²³ jmoo³² dsa³ rɨ³nɨ²³ 'e³ jme'²³te'²³ 'nee'²³, la'³ ca²³jmóo² dsa³ xoo'³¹ jmóo² quien³²te'²³, ca²³jme'²³te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’'E³ quie'²³ bi²³ juɨɨ³² 'nee'²³ dsa³ xoo³². Qui² mɨ³líi² la²³'nɨɨ'n³¹ 'e³ xa³ quién²ma²na'³ 'e³ mɨ³la³jɨn³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Bi²³ juɨɨ³² 'nee'²³ 'i³ xa³ la²³jɨ³ 'e³ rɨ²cø'²ra'³ rɨ³nɨ²³. Qui² 'e³ cɨ² li²³cué̱e̱n²na'³ xii'n²³ dsɨ́ɨ². ’Bi²³ juɨɨ³² la²³jɨn³ 'nee'²³ 'i³ ŋɨɨ³² rɨ³nɨ²³. Qui² 'e³ cɨ² rɨ²'o'²ra'³ la²³'nɨɨ'n³¹ 'e³ rɨ²³ŋɨ́³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Bi²³ juɨɨ³² 'nee'²³ xi³nu³ bi²³ dxʉ́²³ rɨ²³lʉ́²³ la²³jɨn³ sú̱n² dsa³ rɨ²³'én² 'nee'²³. Qui² la'³ ca²³lʉ́³ yi²³uu'² jaa²³² dsa³ 'i³ xen³ rɨ³nɨ²³, ca²³'én² dsa³ 'i³ ca²³júu² mɨ²jaa²³² 'i³ ca²³jua'³ 'e³ 'ɨɨ³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Jné² rɨ²juøøn³¹na¹ 'nee'²³ 'i³ nuu³ júu² quián²³: Bi²³ 'ne'² li²³'náan²³na'³ dsa³ 'i³ 'a²³jia'³ ta³dsɨ³² ñin³² 'nee'²³. 'Ne'² rɨ²jmee'³¹ra'³ dxʉ́²³ dsa³ 'i³ bi²³ hui²³dsɨ́ɨn² ñin³² 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Rɨ²juɨɨ'³¹ra'³ Dios 'e³ rɨ²³mi²³jé̱e̱n² dsa³ 'i³ bi²³ 'ñe'² sɨ'²³ 'nee'²³. Rɨ²lʉ́²ra'³ quia̱'n²na'³ Dios rɨ²ŋɨ́ɨ²ra'³ 'e³ dxʉ́²³ quie'² dsa³ 'i³ jme'²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Xi³nu³ xen³ dsa³ 'i³ mɨ³jnóo² co̱o̱³ joo³¹ juu'³ra'³, cuøn²³²na'³ miin²³na'³ 'e³ cu²jnóo¹ jia'³ cɨ'²³ joo³¹ co̱'³. Xi³nu³ xen³ dsa³ 'i³ mɨ³co̱o̱²³ 'mɨɨ'³ dxóo³ quien³²na'³, cuø²ra'³ júu² 'e³ rɨ²³co̱o̱²³ 'mɨɨ'³ 'iún²na'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Cuøø²ra'³ dsa³ 'i³ ŋɨɨ²³ te³ 'ee² 'noo³¹ 'e³ xa³ quién²na'³. 'A²³ rɨ³juɨɨ'³²ra'³ dsa³ 'i³ mɨ³co̱o̱²³ 'e³ xa³ quién²na'³ 'e³ rɨ²³jɨ̱'² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jmee'²ra'³ dsa³ 'e³ la²³ 'noo³ra'³ miin²³na'³ 'e³ rɨ²³jme'²³te'²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’'A²³la³ jo̱³ 'e³ bi²³ dxʉ́²³ jmee³ra'³ xi³nu³ 'náan²³na'³ 'nɨɨ'n³¹ dsa³ 'i³ 'néen² 'nee'²³. 'E³ quie'²³ la'³ cu²ru'³ jmoo³² la²³jɨn³ dsa³, juø'n³ quie'²³ dsa³ 'i³ xa³ dsoo² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","'A²³la³ jo̱³ 'e³ bi²³ dxʉ́²³ jmee³ra'³ xi³nu³ dxʉ́²³ jmee'³²ra'³ 'nɨɨ'n³¹ dsa³ 'i³ dxʉ́²³ jme'²³ 'nee'²³. Qui² la'³ jmoo³² la²³jɨn³ dsa³, juø'n³ quie'²³ dsa³ tu³cua̱a̱n²tu². ");
INSERT INTO cnlNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","'A²³la³ jo̱³ 'e³ bi²³ dxʉ́²³ jmee³ra'³ xi³nu³ cuøø³²ra'³ 'nɨɨ'n³¹ dsa³ 'i³ lǿn³na'³ 'e³ rɨ²³dxaan³ co̱'³. Qui² cuø²³ la²³jɨn³ dsa³, juø'n³ quie'²³ dsa³ tu³cua̱a̱n²tu², xi³nu³ lǿn³ 'e³ rɨ²³dxaan³te'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","'E³ quie'²³ 'nee'²³, 'ne'² li²³'náan²³na'³ dsa³ 'i³ 'a²³jia'³ ta³dsɨ³² ñin³² 'nee'²³. Dxʉ́²³ rɨ²jmee'³¹ra'³ dsa³. Rɨ²cuøø³¹ra'³, juø'n³ quie'²³ lǿn³na'³ 'e³ 'a²³jia'³ ma²³ rɨ²³dxaan³te'²³ co̱'³. Jo̱³ hua² bi²³ dxʉ́²³ la²³jɨ³ jñiin²³na'³ 'e³ rɨ²³ti'n²³na'³. Jo̱³ hua² jmee³ra'³ la²³ jmee²³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³. Qui² bi²³ 'uǿn² jmee²³ Dios quie'² dsa³ 'i³ 'a²³jia'³ ji̱i̱n³ mɨ²'áa². 'E³ quie'²³ la'³ jmee²³ quie'² dsa³ 'i³ 'a²³jia'³ dxún²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","'Ne'² li²³cuu'²³ 'óo²ra'³ mǿn²³na'³ dsa³ 'e³ la²³ cuu'²³ dsɨ́² Ñʉ'²ra² ñin³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’'A²³ rɨ³juo'³ra'³ 'e³ xa³ dsoo² quiee'³² uu'n²na'³. Jo̱³ hua² 'a²³jia'³ rɨ²³jme'²³ 'nee'²³ la'³ Dios. 'A²³ rɨ³dxa³ra'³ ta² quiee'³² uu'n²na'³. Jo̱³ hua² 'a²³jia'³ rɨ²³dxá²³ Dios ta² quien³²na'³. Jmee²ra'³ 'e³ juee'³ 'óo²ra'³. Jo̱³ hua² rɨ²³jmée²³ Dios 'e³ juee'³ dsɨ́² ñin³² 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cuøø²ra'³ dsa³. Jo̱³ hua² rɨ²³cuǿø²³ 'nee'²³ Dios. Ñúun³ cuø²³ Dios 'e³ la²³ cuø²³ 'i'²³. Quiaa'²³ la²³ cɨ² 'e³ cu²dxi³too'² røø³. 'Mee³² la²³ cɨ² 'e³ cu²'me'¹. Sɨ³'ló²³ la²³ cɨ² 'e³ la²³'nɨɨ'n³¹ 'e³ dxʉ́²³ dsɨ́² Dios 'e³ rɨ²³cuǿø²³ 'nee'²³. La²³'nɨɨ'n³¹ 'e³ cuø³ra'³ 'i'²³ miin²³na'³ 'e³ la²³ cuøø³²ra'³ dsa³, la'³ 'nɨɨ'n³¹ rɨ²³cuǿ²³ 'i'²³ Dios 'e³ rɨ²³cuǿø²³ 'nee'²³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ca²³lʉ́³ Jesús. Ca²³sɨ'²³ dsa³ co̱o̱³ júu² rɨ³jnɨ³ 'e³ jmee²³ lii²³ 'e³ jmii'³¹ lǿn²³ dsa³ 'i³ 'a²³jia'³ sɨ³dsaan³² júu² quiee'³². Ca²³jua'³: ―'A²³jia'³ rɨ²³lí³ juø'² rɨ²³cuǿø²³ jui³¹ uu'n² dsa³ 'i³ la²³ røø³ túun², ¿mɨ³naa'³¹? Qui² rɨ²³jiu'n² 'e̱'³ too³ jɨ̱ɨ̱n²³² la²³ ca³ti³² cu²ru'³ la'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","'A²³jia'³ rɨ²juaa'²ra² 'e³ gáan³ cɨ² dsa³ 'i³ cɨ² sɨ³li³tɨn³ la²³ cɨ'²³ dsa³ 'e²³ quien³². 'E³ quie'²³ rɨ²³lín³ 'ñée² 'e³ la²³ lǿn²³ dsa³ 'e²³ quien³² mɨ³rɨ³lii³² 'e³ sɨ³li³tɨn³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Jmii'³¹ lǿ² 'e³ sɨ³li³bii²³ 'óo²ra'³ 'e³ joo³²ra'³ mɨ³¹'laa³ pii'² 'e³ 'iʉ² mɨ²ñi² uu'n²na'³? 'E³ quie'²³ 'a²³jia'³ mi³quí²ra'³ 'noo³¹ 'mo³ 'e³ 'iʉ² mɨ²ñí²ra'³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Jmii'³¹ lǿ² 'e³ sɨ³li³bii²³ 'óo²ra'³ 'e³ juɨɨ'³²ra'³ uu'n²na'³: “Maan²³² rɨ²dxin²³² mɨ³¹'laa³ pii'² 'e³ 'iʉ² mɨ²ñín²”? 'E³ quie'²³ 'a²³jia'³ mi³quí²ra'³ 'noo³¹ 'mo³ 'e³ 'iʉ² mɨ²ñí²ra'³ miin²³na'³. ¡Bi²³ te³ jmee³ra'³ guóo²! Xe̱'n² cɨ² 'ne'² rɨ²dxí²ra'³ 'noo³¹ 'mo³ 'e³ 'iʉ² mɨ²ñí²ra'³ miin²³na'³. Jo̱³ hua² li²³jné³ quién²na'³ 'e³ la²³ rɨ²³lí³ juø'² rɨ²dxí²ra'³ mɨ³¹'laa³ pii'² 'e³ 'iʉ² mɨ²ñi² uu'n²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’'A²³'e³ xa³ 'mo³ dxʉ́²³ 'e³ 'ɨɨ³ mɨɨ³¹ 'e³ 'a²³jia'³ dxʉ́²³. 'E³ quie'²³ la'³ 'a²³'e³ xa³ 'mo³ 'e³ 'a²³jia'³ dxʉ́²³ 'e³ 'ɨɨ³ mɨɨ³¹ 'e³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Qui² la²³ lǿ² mɨɨ³¹ 'e³ 'ɨɨ³ jmee²³ lii²³ 'e³ 'ee² 'mo³. 'A²³la³ jo̱³ xoo'³¹ tó̱o̱² 'e³ 'ɨɨ³ mɨ²higo. 'A²³la³ jo̱³ 'mɨ'n³ cuoo³ 'e³ 'ɨɨ³ mɨ²jø'². ");
INSERT INTO cnlNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","'E³ quie'²³ la'³, dxʉ́²³ la²³jɨ³ 'e³ née² dsɨ́² dsa³ dxún²³. Jo̱³ hua² lʉ²³ jmø'n² 'e³ dxʉ́²³. 'E³ quie'²³ sǿn²³ la²³jɨ³ 'e³ née² dsɨ́² dsa³ sǿn²³. Jo̱³ hua² lʉ²³ 'e³ sǿn²³. Qui² la²³jɨ³ 'e³ née² dsɨ́² dsa³ sɨ³li³lii²³ mɨ³rɨ³lʉ³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Jmii'³¹ lǿ² 'e³ juɨɨ'³²ra'³ jné²: “Juii³ra'³¹, Juii³ra'³¹”? 'E³ quie'²³ 'a²³jia'³ jmee³ra'³ 'e³ la²³ juøøn³²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Rɨ²juøøn³¹na¹ 'nee'²³ 'e³ jmii'³¹ lǿn²³ la²³jɨn³ dsa³ 'i³ 'née²³ rɨ²³lín³ dsa³ quién²³na²³, 'i³ nuu³ júu² quián²³, 'i³ jmoo³² 'e³ la²³ lǿ²: ");
INSERT INTO cnlNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Xen³ la²³ xen³ jø̱n³ dsa³ 'i³ ca²³jmée³ 'ñʉ́² 'ioo'³. Bi²³ jɨ̱ɨ̱n²³² ca²³yʉ́ʉ² je² ca²³noo³ 'ioo'³. Ñi'² 'loo³ ca²³dxá³ 'ioo'³. Ma²ca¹la¹bee'² jmɨɨ³, bi²³ ca²³'la'³ jmɨɨ³ 'ñʉ́². 'E³ quie'²³ cu³xi³ ca³juɨ² 'a²³jia'³ ca²³bí² 'ñʉ́². Qui² ñi'² 'loo³ ja³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","'E³ quie'²³ la²³la³ cu³løn³¹ dsa³ 'i³ lɨ'³ ca³núu³ júu² quián²³, 'e³ quie'²³ 'a²³jia'³ jmee²³ 'e³ la²³ lǿ²: Xen³ la²³ xen³ jø̱n³ dsa³ 'i³ ca²³jmée³ 'ñʉ́² 'ioo'³. Te³ rɨ³dsɨ³² ñi'² 'uǿ²³. 'A²³jia'³ ca²³yʉ́ʉ² je² ca²³noo³ 'ioo'³. Ma²ca¹'la'³ jmɨɨ³ 'ñʉ́² jo̱³, xe̱'n² jmɨ́ɨ² ca²³'ló²³ 'ñʉ́². Bi²³ bee'² 'e³ ca²³lǿ²³. Guo'² 'ñʉ́² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ma²mɨ³líi² mɨ³'ɨ́ɨ³ júu² Jesús je² nuu³ dsa³, jo̱³ tu³ 'í² jee²³² juɨɨ³ Capernaum. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Núu²³ jen³¹ jø̱n³ dsa³ jia'³ 'i³ rɨ³løn³¹ juii² co̱o̱³ i³láan³ dsa³ 'láa³. Xen³ mozo quien³² 'i³ bi²³ 'néen². 'E³ quie'²³ bi²³ dsoo'²³² mozo. Mɨ³ rɨ²³jú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ca²³núu³ 'ñée² juii² dsa³ 'láa³ 'e³ jmii'³¹ lʉ²³ dsa³ 'en³²te'²³ Jesús. 'E³ jo̱³ ca²³xíin²³ dsa³ mɨ³dxún²³ quien³² dsa³ Israel 'i³ rɨ³løn³¹ tɨ³² juø'² quien³². Qui² 'née²³ 'e³ sɨ³xii'²³²te'¹ Jesús 'e³ rɨ²³dsóo² rɨ²³mi²³'láan³ mozo quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ma²ca¹dxi¹guín¹ te'²³ dsa³ mɨ³dxún²³ je² jen³¹ Jesús, bi²³ ca²³ŋɨ́ɨ³te'²³ mɨ²'áa² quie'². Ca²³jua'³te'²³: ―Dxi³ji̱i̱n³¹ 'e³ rɨ²jméen² co̱²juø'¹ quie'² dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Qui² bi²³ 'néen² jne² dsa³ Israel. Ca²³jmée³ quiée²ra² co̱o̱³ 'ñʉ́² je² mi³gáan²na² Dios. ―La'³ ca²³sɨ'²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","'E³ jo̱³ ŋóo² Jesús quia̱'² dsa³ mɨ³dxún²³. Mɨ³ rɨ²³tɨ́n²³te'²³ je² jen³¹ juii² dsa³ 'láa³. 'E³ jo̱³ ca²³xíin²³ juii² dsa³ 'láa³ te'²³ dsa³ 'i³ dxʉ́²³ lʉ²³ quia̱'² 'e³ rɨ²³lʉ́²³te'²³ quia̱'²te'²³ Jesús. Ca²³ŋɨ́n²te'²³ júu² quiee'³² juii² dsa³ 'láa³ 'e³ 'iin³¹ 'ñée²: ―Juiin²³, 'a²³jia'³ 'ne'² ñeen³² jí̱i̱n² quián²³. Qui² bi²³ 'a²³jia'³ dxún²³na²³. Cu³xi³ 'a²³jia'³ dxi³ji̱i̱n³¹ 'e³ rɨ²'ín³nu³ xi²ñʉ'¹ quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","'E³ jo̱³ 'a²³jia'³ ca²³la²³bii²³ dsɨn²³ 'e³ i²joon²³na²³ 'nʉ³ 'ñáan²³. Líi² te³ rɨ²dxín² 'i'²³. Jo̱³ rɨ²³'láan³ mozo quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Maan²³ 'e³ 'uee'n³ júu² quien³²nu³. Qui² xen³ dsa³ 'i³ dxi³ 'i'²³ quián²³. 'E³ quie'²³ la'³, xen³ dsa³ 'láa³ 'i³ dxin²³ 'i'²³ quie'². Líi² te³ rɨ²juøøn³¹ jø̱n³: “Guo³”. 'E³ quie'²³ jo̱³ dsoo³². 'E³ quie'²³ rɨ²juøøn³¹ jia'³ cɨ'²³: “Ñe³ la³”. 'E³ quie'²³ jo̱³ rɨ²³ja³. Juøøn³² mozo quién²³na²³: “La²³la³ cu³lø³¹ rɨ²jméen²”. 'E³ quie'²³ jo̱³ rɨ²³jmée²³ la'³. ―La'³ ca²³jua'³ juii² dsa³ 'láa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bi²³ juø'²³ ca²³núu³ Jesús júu² quiee'³² juii² dsa³ 'láa³. Ca²³ji̱i̱n²³. Ca²³jóon² la²³jɨn³ dsa³ 'i³ quia̱'² 'ñée². Ca²³jua'³: ―Rɨ²juøøn³¹na¹ 'nee'²³: Cu³xi³ la²³ca̱a̱n³ juɨɨ³ quiee'³² dsa³ Israel 'a²³jia'³ lɨ'³ ca³jí̱i̱n³na²³ dsa³ 'i³ sɨ³táan³ quia̱'² jné² 'e³ la²³'nɨɨ'n³¹ 'e³ sɨ³táan³ dsa³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","'E³ quie'²³ jo̱³ ca²³guiin³² co̱'³ dsa³ 'i³ ca²³xíin²³te'²³. Ma²ca¹dxi¹guiin³²te'²³ co̱'³, ŋó²³te'²³ 'e³ mɨ³lɨɨn³² mozo. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma²mɨ³líi² la'³, ŋóo² Jesús co̱o̱³ juɨɨ³ je² xi̱i̱n³ Naín. Ŋóo² quia̱'² dsa³ quien³² quia̱'² cɨ² juɨ́ɨn²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ma²mɨ³tɨ́n³ mɨ³lén² 'oo'² 'ioo'³ 'ioo³¹ juɨɨ³, ca²³jí̱i̱n³ dsa³ 'i³ quie̱n³ 'lɨ́ɨ³. Jo̱o̱³¹ mɨ́³ 'nɨ́ɨ³ 'lɨ́ɨ³ 'í³. 'E³ quie'²³ jø̱n³ la'³ qui²³jo̱o̱³¹ xen³ quie'². Bi²³ juɨ́ɨn²³ dsa³ 'i³ xen³ juɨɨ³ quiee'³² 'i³ quia̱'² mɨ́³ 'nɨ́ɨ³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ma²ŋøn³¹ mɨ́³ 'nɨ́ɨ³ 'í³ Juii³ra², bi²³ ca²³la²³cuu'²³ dsɨ́². 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ mɨ́³ 'nɨ́ɨ³: ―'A²³ rɨ³'a'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ca²³lǿn²³ mɨ³lén² Jesús. Ca²³quiʉ̱'² guoo³ guóo² 'e³ 'iún² 'lɨ́ɨ³. 'E³ quie'²³ jo̱³ ca²³noo³ dsa³ 'i³ quie̱n³ 'lɨ́ɨ³. Ca²³jua'³ Jesús. Ca²³sɨ'²³ 'lɨ́ɨ³: ―Rɨ²juøøn³¹na¹ 'nʉ³, xii'³: Naa'n²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","'E³ quie'²³ jo̱³ ca²³gua³ 'lɨ́ɨ³ 'e̱'³ guóo². 'E³ jo̱³ ca²³lʉ́³. Jesús ca²³sɨ'²³ xóo² xii'³ 'e³ rɨ²³tøø³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","'E³ jo̱³ bi²³ ca²³jue'n² miin²³ la²³jɨn³ dsa³ 'i³ joo³². Ca²³mi²³gáan³te'²³ Dios. Ca²³jua'³te'²³: ―Mɨ³güén²³ quiée²ra² jø̱n³ dsa³ gáan³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. Mɨ³tɨ́³ jmɨ́ɨ² 'e³ jmee²³ Dios co̱²juø'¹ quiée² jne² dsa³ quien³² ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","'E³ jo̱³ ca²³sóo²³ ca²³jó²³ júu² 'e³ jmii'³¹ ca²³jmée³ Jesús. Qui² ca²³núu³te'²³ la²³ca̱a̱n³ estado Judea quia̱'² la²³ca̱a̱n³ jia'³ cɨ'²³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ca²³núu³ Juan 'i³ ca²³xáan² dsa³ jmɨɨ³ la²³jɨ³ 'e³ ca²³lǿ²³. Qui² ca²³jmóo² júu² dsa³ quien³². 'E³ jo̱³ ca²³tøø³ áan²³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ca²³xíin²³ te'²³ dsa³ 'í³ je² jen³¹ Jesús 'e³ la²³ rɨ²³ŋɨ́ɨ²³te'²³ júu² quie'² 'e³ rɨ²³jua'³te'²³: “¿'A² 'nʉ³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios? ¿'A² jia'³ cɨ'²³ 'i³ 'ne'² rɨ²je̱n²³²na²?” ");
INSERT INTO cnlNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ma²ca¹dxi¹guín¹ dsa³ quien³² Juan, ca²³jua'³te'²³: ―Mɨ³xíin²³ jnee'³¹ Juan 'i³ xaan³² dsa³ jmɨɨ³. Qui² jua'³ 'ñée²: “¿'A² 'nʉ³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios? ¿'A² jia'³ cɨ'²³ 'i³ 'ne'² rɨ²je̱n²³²na²?” ");
INSERT INTO cnlNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mɨ²jo̱³ mi³'láan³ juɨ́ɨn²³ dsa³ 'i³ dsoo'²³² Jesús. Mi³'láan³ dsa³ 'i³ lǿn²³ dsóo² cuaa³. Mi³'láan³ dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'² co̱'³. Jmee²³ 'e³ sɨ³li³jnee²³ co̱'³ juɨ́ɨn²³ dsa³ tuu². ");
INSERT INTO cnlNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³² Juan: ―Cu³xii'²ra'³ Juan la²³jɨ³ 'e³ mɨ³ñíi³ra'³, la²³jɨ³ 'e³ mɨ³nʉʉ³ra'³. Qui² sɨ³li³jnee²³ dsa³ tuu². Ŋɨ́³ dsa³ 'i³ 'uaa'³ tɨɨ². Sɨ³jñin³ la³'e² dsa³ 'i³ ta̱a̱n²³ goo³. Nuu³ dsa³ guɨɨ²³². Sɨ³ji̱i̱'²³ co̱'³ dsa³ 'i³ sɨ³jú̱n³. 'Ɨɨ³te'²³ júu² dxʉ́²³ quie'² dsa³ taan³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bi²³ dxʉ́²³ quie'² dsa³ 'i³ 'a²³jia'³ rɨ²³yáan²³ dsɨ́² 'e³ sɨ³táan³ quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","'E³ quie'²³ jo̱³ ca²³guiin³² co̱'³ dsa³ 'i³ ca²³xíin²³ Juan. Jo̱³ tu³ ca²³lʉ́³ co̱'³ Jesús quia̱'² dsa³. Ca²³'én² Juan. Ca²³jua'³: ―¿'Ee² 'noo³¹ ca²³lǿn³na'³ 'e³ cu³jóo²ra'³ 'e³ la²³ i²guín¹na'³ je² 'a²³jia'³ nee'n²³² dsa³? 'A²³la³ 'mo³ ta³ 'e³ bɨ³² je² ro̱o̱²³ dxí³, ¿mɨ³naa'³¹? Qui² 'a²³la³ la'³ cu³løn³¹ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿'Ee² lǿ² i²guín¹na'³ jo̱o̱²³na²³? 'A²³la³ jo̱³ 'e³ i²joon²³na'³ dsa³ 'i³ quii'³ 'mɨɨ'³ 'e³ bi²³ dxʉ́²³, ¿mɨ³naa'³¹? Qui² 'ñʉ² rey nee'n²³² dsa³ 'i³ quii'³ 'mɨɨ'³ 'e³ bi²³ dxʉ́²³, dsa³ 'i³ xa³ la²³jɨ³ 'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿'Ee² lǿ² i²guín¹na'³ jo̱o̱²³na²³? ¿'A² i²guín¹na'³ 'e³ rɨ²joon²³na'³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios? 'I³ 'í³ ca³quie̱e̱² i²joon²³na'³ xú̱n³. 'E³ quie'²³ 'a²³la³ 'nɨɨ'n³¹ 'e³ te³ rɨ³løn³¹ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. Qui² gáan³ cɨ² Juan la²³ cɨ'²³ la²³jɨn³ jia'³ cɨ'²³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Qui² 'i³ 'í³ hua² 'i³ 'en³² júu² quiee'³² Dios je² to̱o̱²³ ji³ je² jua'³: Rɨ²sɨɨn³¹na¹ dsa³ xiin²³ quién²³na²³ 'i³ rɨ²³ŋɨ́n³ jén²³ cɨ² la²³ 'nʉ³. Rɨ²³jmée²³ dxʉ́²³ jui³¹ je² rɨ²³ŋɨ́n³nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Rɨ²juøøn³¹na¹ 'nee'²³: 'A²³'i̱³ xen³ dsa³ 'i³ lɨ'³ ca³la³xen³ 'i³ gáan³ cɨ² la²³ Juan. 'E³ quie'²³ gáan³ cɨ² la²³ Juan dsa³ 'i³ mɨ³lǿn²³ Dios juii² rɨ³nɨ²³, juø'n³ quie'²³ 'i³ pii'² cɨ². ");
INSERT INTO cnlNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ma²ca¹núu³te'²³ júu² 'e³ ca²³lʉ́³ Jesús, ca²³jua'³ la²³jɨn³ dsa³ juɨɨ³ quia̱'² 'io'² 'e³ ju²dsoo³¹ lʉ²³ Dios 'e³ jua'³ 'ne'² rɨ²³tʉ́² dsa³ 'e³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³. 'E³ jo̱³ hua² 'e³ ca²³jŋáan³te'²³ jmɨɨ³ mɨ²jo̱³ ma²ca¹xáan¹ dsa³ jmɨɨ³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","'E³ quie'²³ ca²³jníin²³ dsa³ fariseo quia̱'² dsa³ 'e²³ ley la²³jɨ³ 'e³ 'née²³ Dios rɨ²³jmée²³ quie'²te'²³. 'E³ jo̱³ hua² 'a²³jia'³ ca²³jŋáan³te'²³ jmɨɨ³ mɨ²jo̱³ ma²ca¹xáan¹ dsa³ jmɨɨ³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ca²³jua'³ Juii³ra²: ―¿Jmii'³¹ cu³lø³¹ rɨ²juø'n³¹ 'e³ la²³ lǿn²³ dsa³ 'i³ xen³ rɨ³nɨ²³ 'u²? ¿Jmii'³¹ cu³løn³¹te'¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Xen³te'²³ la²³ xen³ xii'³ pii'² 'i³ nee'n²³² je² dxa²³ dsa³ 'moo'². Yoo'²³ tø³². Sɨ'²³ uu'n². Jua'³te'²³: “Mɨ³jiʉʉ²³²ra'³¹ 'mo³ ta³. 'E³ quie'²³ 'a²³jia'³ ca³dxén²na'³. Mɨ³'e²ra'³¹ 'e³ la²³ 'e²³ dsa³ je² xen³ 'lɨ́ɨ³. 'E³ quie'²³ 'a²³jia'³ ca³'o'²ra'³. 'E³ quie'²³ 'a²³'e³ xa³ 'noo³ra'³ sú̱n².” ");
INSERT INTO cnlNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","La'³ xen³ dsa³ 'i³ xen³ rɨ³nɨ²³. Qui² 'a²³jia'³ ee'³² 'ɨ²³juɨ² Juan 'i³ xaan³² dsa³ jmɨɨ³. 'A²³jia'³ 'ɨ̱ɨ̱'³² jmɨɨ'³¹ mɨ²jø'² vino. 'E³ jo̱³ juo'³ 'nee'²³: “Quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'²”. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jné² Jo̱o̱³¹ Dsa³ uu'n²³ ee'n²³. 'E³ jo̱³ juo'³ 'nee'²³: “Jóo². Jmii'³¹ 'nɨɨ'n³¹ 'ɨ̱ɨ̱'³² ee'³². Bi²³ dxʉ́²³ lʉ²³ quia̱'² 'io'² quia̱'² dsa³ 'i³ xa³ dsoo² quiee'³².” ");
INSERT INTO cnlNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","'E³ quie'²³ xen³ dsa³ 'i³ nuu³ júu² quiee'³² Dios 'e³ jmii'³¹ 'ne'² rɨ²³jmóo². 'E³ la²³ jmoo³²te'²³ 'e³ dxʉ́²³, sɨ³li³lii²³ 'e³ dxʉ́²³ júu² 'e³ nuu³te'²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Xen³ jø̱n³ dsa³ fariseo 'i³ ca²³tøø³ Jesús 'e³ rɨ²³e'² quia̱'². 'E³ jo̱³ 'í² Jesús xi²ñʉ'¹ quiee'³² dsa³ 'í³. Ca²³gua³ coo³¹ mesa. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","'E³ quie'²³ jo̱³ 'í² jø̱n³ mɨ́³ 'i³ jen³¹ juɨɨ³ jo̱³ 'i³ bi²³ tu³cua̱a̱n²tu² jmee²³. Qui² ca²³núu³ mɨ́³ 'í³ 'e³ jen³¹ Jesús ee'³² xi²ñʉ'¹ quiee'³² dsa³ fariseo. 'E³ jo̱³ ñíin² je² núu²³. Quie̱³ co̱o̱³ mɨɨ³¹ mɨ²sɨ́¹ 'e³ rɨ³lø³¹ cú̱u̱² 'e³ xi̱i̱n³ alabastro. 'O² noo²³² 'e³ bi²³ mɨ³róo³ jme'². ");
INSERT INTO cnlNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'E³ la²³ jen³¹ rɨ³tɨɨn²³ Jesús, ca²³noo³ mɨ́³ coo³¹ tɨɨ². 'Oo'³². Ca²³'uu²³ tɨɨ² jmɨɨ'³¹ mɨ²ñi². Ca²³xí³ jñʉ³ dxi² 'ñée² mɨ́³. Ca²³cuu'³ tɨɨ² Jesús. Ca²³'uu²³ tɨɨ² noo²³² mɨ³róo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ŋó²³ dsa³ fariseo 'i³ ca²³tøø³ Jesús 'e³ jmii'³¹ sɨ³lí³. 'E³ jo̱³ ca²³lǿn³ 'ñée²: 'U² cu²ru'³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios ca³quie̱e̱² dsa³ la³, ñi³² 'ñée² 'e³ jmii'³¹ lǿn²³ mɨ́³ 'i³ jñuun³ 'ñée² cu²ru'³ la'³. Ñi³² 'e³ jmii'³¹ jmee²³. 'A²³jia'³ rɨ²³cuǿn²³ 'ñée² 'u² cu²ru'³ dsoo²³ dsɨ́². Qui² bi²³ tu³cua̱a̱n²tu² jmee²³ mɨ́³ nɨ³. La'³ lǿn³ dsa³ fariseo. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ fariseo: ―Muun³², xa³ co̱o̱³ júu² 'e³ rɨ²juøøn³¹na¹ 'nʉ³. 'E³ jo̱³ ca²³jua'³ dsa³ fariseo. Ca²³sɨ'²³ Jesús: ―¿Jmii'³¹ cu³lø³¹ rɨ²juɨɨ'n³¹nu³ jné², dsa³ 'e²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ca²³jua'³ Jesús: ―La²³la³ cu³lø³¹ ca²³jmée³ jø̱n³ dsa³ co̱o̱³ taa'². Xen³ áan²³ dsa³ 'i³ ca²³'uǿø³ cuu² quie'². 'Ñé³ i³lóo³ ca²³dxi³ jø̱n³. Tú̱²³ lu²³guiá³ ca²³dxi³ jia'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ca²³tɨ́³ jmɨ́ɨ² 'e³ rɨ²³quí²te'²³ dsoo². 'E³ quie'²³ 'a²³jia'³ lǿ²³ juø'² ca²³quí²te'²³ ca³ti³². 'E³ jo̱³ ca²³yúun² quie'²³ juii² dsoo² quiee'³²te'²³. ¿Jmii'³¹ lǿn³nu³ jo̱o̱²³? ¿'I̱i̱² sɨɨ'³¹ 'i³ bi²³ cɨ² 'néen² dsa³ 'i³ ca²³yúun² dsoo² quiee'³²te'²³, lǿn³nu³? ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","'E³ jo̱³ ca²³jua'³ Muun³²: ―Dsa³ 'i³ bi²³ ñúun³ ya̱'n³ juø'². ―'I³ 'í³ ca³quie̱e̱² ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","'E³ quie'²³ jo̱³ ca²³ji̱i̱n²³ Jesús xi²ñi² mɨ́³. Ca²³jua'³ ca²³sɨ'²³ Muun³²: ―Joon²³ dxʉ́²³ mɨ́³ la³. Qui² mɨ³'iin³²na²³ xi²ñʉ'¹ quien³²nu³. 'E³ quie'²³ 'uǿøn²nu³ 'a²³jia'³ ca³cuǿøn²nu³ jné² cu³xi³ jmɨɨ³ 'e³ rɨ²u̱'n¹ tɨɨn²³. 'E³ quie'²³ mɨ³'uu²³ jmɨɨ'³¹ mɨ²ñi² tɨɨn²³ mɨ́³ la³. Mɨ³xí³ tɨɨn²³ jñʉ³ dxi². ");
INSERT INTO cnlNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","'E³ quie'²³ 'uǿøn²nu³ 'a²³jia'³ ca³cu'n² ñin²³ 'e³ la²³ mɨ³cuǿn² u²³juee'n³¹ quia̱'n²nu³ jné². 'E³ quie'²³ cɨ'²³ la²³ mɨ³'iin³²na²³ xi²ñʉ'¹ quien³²nu³, 'a²³jia'³ ca³tʉ́ʉ² cuu'³ tɨɨn²³ mɨ́³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","'A²³jia'³ ca³'uun²³ 'uǿøn²nu³ noo²³² mɨ²dxin²³. 'E³ quie'²³ mɨ³'uu²³ mɨ́³ noo²³² mɨ³róo³ tɨɨn²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","'E³ jo̱³ rɨ²juøøn³¹na¹ 'nʉ³: Bi²³ 'néen² jné² mɨ́³ la³. Qui² bi²³ ñúun³ dsoo² quiee'³² 'e³ mɨ³uu³. 'E³ jo̱³ hua² jmee²³ lii²³ 'e³ bi²³ 'néen² jné². 'E³ quie'²³ ca³juɨ² hua² 'néen² jné² dsa³ 'i³ ca³juɨ² dsoo² mɨ³uu³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³: ―Mɨ³uu³ dsoo² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","'E³ jo̱³ ca²³lʉ́³ dsa³ 'i³ nee'n²³² coo³¹ mesa quia̱'² Jesús. Ca²³jua'³ ca²³sɨ'²³ uu'n²te'²³: ―¿'I̱i̱² sɨɨ'³¹ 'i³ la³ cu²ne²ra²? 'A²³jia'³ líi² 'nɨɨ'n³¹ u²³juø'²³ 'e³ jmee²³. 'E³ quie'²³ ta³yuun³² dsoo² quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Co̱'³ cɨ'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³: ―Sɨ³táan³nu³. 'E³ jo̱³ mɨ³láan³nu³. Dxa² co̱o̱³ 'áan² 'e³ guø'n³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","'A²³jia'³ ca³la³huǿø³ la'³ 'e³ ŋóo² co̱'³ Jesús. Bi²³ ñúun³ juɨɨ³ quia̱'² ranchos je² ca²³ŋɨ́n³. Ca²³'ɨ́ɨ³ júu² la²³ca̱a̱n³ je² ca²³ŋɨ́n³. Ca²³sɨ'²³ dsa³ júu² dxʉ́²³ 'e³ rɨ³løn³¹ Dios juii² dsa³. Dsa³ gui²³tʉ̱́n³ quien³² ca²³ŋɨ́³ quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Xen³ mɨ́³ 'i³ ca²³ŋɨ́³ quia̱'² co̱'³. Ca²³qui̱i̱³te'²³. Qui² ca²³jmée³ co̱²juø'¹ Jesús quie'²te'²³. Qui² ca²³'uøøn³ Jesús espíritus quien³² mɨ²³sɨ²³quiʉ'² 'i³ quie̱n³ ca³dxáan². Ca²³mi²³'láan³ ca³dxáan². Quia̱'²te'²³ Ma³rii³¹ 'i³ sɨ'²³te'²³ I²³lee² 'i³ cǿ̱n² guiáan²³ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'i³ ca²³'uøøn³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Quia̱'²te'²³ I²³huoo² mɨ²³quie'² Cuza, dsa³ 'i³ jmee²³ cua̱a̱n²tu² la²³jɨ³ ta² quiee'³² Herodes. Quia̱'²te'²³ Susana quia̱'²te'²³ juɨ́ɨn²³ cɨ² mɨ́³. Có̱²³te'²³ 'e³ xa³ quie'²te'²³ 'e³ jua'³te'²³ rɨ²³mi²³quin³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Juɨ́ɨn²³ dsa³ 'i³ ca²³ŋɨɨ'n²³. Bi²³ ñúun³ juɨɨ³ je² ca²³'uǿøn²³te'²³. Ca²³guín²³te'²³ caan²³ Jesús. 'E³ jo̱³ ca²³lʉ́³ Jesús co̱o̱³ júu² 'e³ jmee²³ lii²³ 'e³ jmii'³¹ lǿn²³ dsa³ 'i³ nuu³ júu² quiee'³². Ca²³jua'³ 'ñée²: ");
INSERT INTO cnlNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Ŋóo² jø̱n³ dsa³ 'i³ ca²³juá² mɨ³¹ju̱³. Xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² coo³¹ jui³¹. Jo̱³ tu³ ca²³'ée³ dsa³ mɨ³¹ju̱³ jo̱³. 'E³ quie'²³ ca²³la'n² to̱³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² jee²³² guoo'² 'e³ rɨ³jó³ ñi'² cú̱u̱². Ca²³jǿn²³ mɨ³¹ju̱³. 'E³ quie'²³ ca²³la²³quiʉ̱ʉ̱³ xe̱'n². Qui² 'a²³jia'³ güi'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² jee²³² tó̱o̱². Ca²³jǿn²³ tó̱o̱² ca³ti³² quia̱'² mɨ³¹ju̱³. Ca²³jlɨ́²³ mɨ³¹ju̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Xa³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² 'uǿ²³ ŋún²³. Ca²³jǿn²³ mɨ³¹ju̱³. Ca²³'ɨ́ɨ³ ma²³ co̱o̱³ i³lóo³ mɨɨ³¹. Ma²ca¹líi¹ ca²³jua'³ la'³ Jesús, ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³jua'³: ―'Ne'² rɨ²³núu²³ dsa³ 'i³ 'née²³ rɨ²³cuǿn²³ miin²³ 'e³ rɨ²³núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","'E³ jo̱³ ca²³ŋɨ́ɨ³ júu² dsa³ quien³² 'e³ jmii'³¹ 'née²³ rɨ²³jua'³ júu² 'e³ ca²³lʉ́³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","'E³ jo̱³ ca²³jua'³ Jesús: ―Mɨ³'ieen³²na'³ júu² 'e³ ta³jmee³ra'³ 'i'²³ 'e³ jmii'³¹ lǿ² 'e³ rɨ³løn³¹ Dios juii² dsa³, juø'n³ quie'²³ rɨ³'mo² júu² jo̱³ xe̱'n². 'E³ quie'²³ 'a²³jia'³ ca³'ioo³² júu² 'e³ ta³jmoo³² 'i'²³ jia'³ cɨ'²³ te'²³ dsa³. Jmø'n² júu² rɨ³jnɨ³ rɨ²³núu²³ te'²³ dsa³ 'í³. La'³ cu³lø³¹ jmee²³ Dios 'e³ la²³ 'a²³jia'³ rɨ²³ñí²te'²³, juø'n³ quie'²³ rɨ²³jóo²te'²³. 'A²³jia'³ rɨ²³lí³ juø'² rɨ²³jmóo²te'²³ 'i'²³, juø'n³ quie'²³ rɨ²³núu²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’La²³la³ cu³lø³¹ 'née²³ rɨ²³jua'³ júu² 'e³ mɨ³lʉ́n²³: La²³ xen³ mɨ³¹ju̱³ xen³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","La²³ xen³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² coo³¹ jui³¹ xen³ ca³dxáan² dsa³ 'i³ mɨ³núu³ júu² quiee'³² Dios. 'E³ quie'²³ sɨ³dxóo² mɨ²³sɨ²³quiʉ'². Je̱'n³² júu² quiee'³² Dios 'e³ née² dsɨ́²te'²³. Qui² 'a²³jia'³ 'née²³ 'ñée² 'e³ rɨ²³sɨ²³táan³ dsa³. 'A²³jia'³ 'née²³ 'e³ rɨ²³láan³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","La²³ xen³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² jee²³² guoo'² 'e³ rɨ³jó³ ñi'² cú̱u̱² xen³ ca³dxáan² dsa³ 'i³ nuu³ júu² quiee'³² Dios. Bi²³ jɨn³ dsɨ́² mɨ³rɨ³nʉʉ³te'²³. 'E³ quie'²³ 'a²³jia'³ née² 'uaa'³ dsɨ́²te'²³. Ca²³ji̱i̱³ hua² sɨ³táan³te'²³. Sɨ³yáan²³ dsɨ́²te'²³ mɨ³rɨ³ji̱'²³te'²³ 'e³ gáan³ dxíi³ 'e³ jmee²³ lii²³ xi² ca³quie̱e̱² née² 'uaa'³ dsɨ́²te'²³ júu² 'e³ nuu³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","La²³ xen³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² jee²³² tó̱o̱² xen³ ca³dxáan² dsa³ 'i³ nuu³ júu² quiee'³² Dios. 'E³ quie'²³ 'e³ la²³ ta'n²te'²³ jui³¹ mɨ³¹güii³ quiee'³²te'²³, sɨ³jlɨ́²³ júu² quiee'³² Dios 'e³ nuu³te'²³. La'³ jmee²³ la²³jɨ³ ta² 'e³ jmoo³²te'²³. La'³ jmee²³ cuu² 'e³ 'aa³te'²³. La'³ jmee²³ la²³jɨ³ 'e³ lǿn³te'²³ 'e³ lii'². 'E³ jo̱³ jmee²³ 'e³ te³ li²³ŋɨ́n³ 'e³ mɨ³núu³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","'E³ quie'²³ la²³ xen³ mɨ³¹ju̱³ 'e³ ca²³ti²³ro̱o̱² 'uǿ²³ ŋún²³ xen³ ca³dxáan² dsa³ 'i³ nuu³ júu² quiee'³² Dios. Dxʉ́²³ xe̱e̱'³te'²³ júu² quiee'³² Dios. 'A²³jia'³ te³ jmoo³²te'²³ guóo². Bi²³ dxʉ́²³ dsɨ́²te'²³. 'A²³jia'³ tʉ³²te'²³. Jo̱³ hua² jmee²³ ta² ñʉ'²³ dsɨ́²te'²³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Co̱'³ cɨ'²³ ca²³jua'³ Jesús: ―’'A²³jia'³ xe̱'n³² dsa³ ji³ 'é̱e̱² jmɨɨ³ 'e³ te³ rɨ²³'mé²³te'²³. 'A²³jia'³ rɨ²³'mé²³te'²³ ñʉ'²³ ji̱i̱². 'E³ quie'²³ dxa²³te'²³ ñi'² joo³¹ 'mo³ jɨ̱ɨ̱n²³². Qui² 'née²³te'²³ 'e³ jné³ ji³ mɨ³rɨ³ta'n²³ dsa³ xi²ñʉ'¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","'E³ cɨ² li²³lii²³ la²³jɨ³ 'e³ rɨ³'mo² xe̱'n². 'E³ cɨ² rɨ²³ñí² dsa³ la²³jɨ³ 'e³ 'a²³jia'³ ñi³²te'²³ xe̱'n². 'E³ cɨ² rɨ²³dsóo²³ dsɨ́²te'²³ jɨn³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Jmee²ra'³ 'i'²³ jo̱o̱²³na²³ 'e³ jmii'³¹ cu³lø³¹ nuu³ra'³. Qui² ñúun³ cɨ² rɨ²³'ióo²³ dsa³ 'i³ xa³ ca³juɨ² quie'² xe̱'n². 'E³ quie'²³ dsa³ 'i³ 'a²³'e³ xa³ quie'² xe̱'n², rɨ²³je̱'n²te'²³ la²³'nɨɨ'n³¹ qui³ 'e³ lǿn³ 'ñée² 'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'E³ jo̱³ ca²³dxóo² xóo² quia̱'² te'²³ jó̱o̱² Jesús. 'E³ quie'²³ 'a²³jia'³ ca²³lǿ²³ juø'² ca²³tɨ́n³te'²³ je² jen³¹. Qui² bi²³ juɨ́ɨn²³ dsa³ 'i³ rɨ³ŋɨɨn³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Xen³ dsa³ 'i³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―Xi'n²³ xi²dxi³² xaan³ quia̱'² já̱a̱n², ¿mɨ³naa'³¹? 'Née²³te'²³ 'e³ rɨ²³lʉ́²³te'²³ quia̱'²te'²³ 'nʉ³ 'u². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Dsa³ 'i³ nuu³ júu² quiee'³² Dios, 'i³ jmoo³² 'e³ la²³ lǿ², 'i³ 'í³ xen²³, 'i³ 'í³ ja̱a̱n³². ―La'³ ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ca²³tɨ́³ jmɨ́ɨ² 'e³ 'í² 'e̱'³ móo² Jesús quia̱'² dsa³ quien³². Ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―Mɨ²³gui²³²ra² joo³¹ i²³'ŋóo² ―ca²³jua'³. 'E³ jo̱³ ca²³ta'n²³te'²³ jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","'E³ la²³ sɨ³'øn³te'²³ jmɨɨ³, ca²³too'²³ la²³guɨɨn³ Jesús. 'E³ jo̱³ ca²³guɨɨn³ ca³quie̱e̱². Co̱'³ la²³ ca²³ró̱o̱²³ dxí³ bee'² ñi'² jmɨ²³ñii'³¹. 'E³ jo̱³ ca²³'o² jmɨɨ³ 'e̱'³ móo². Mɨ³ rɨ²³gua'²³ móo². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'E³ jo̱³ ca²³ñín²te'²³ Jesús. Ca²³jua'³te'²³: ―¡Dsa³ 'e²³! ¡Dsa³ 'e²³! ¡Mɨ³ sɨ³gua'²³ jne²! 'E³ quie'²³ jo̱³ ca²³naa'n²³ Jesús. Ca²³jín² dxí³ quia̱'² jmɨɨ³ 'e³ bi²³ bɨ³². 'E³ quie'²³ jo̱³ ca²³cɨ́³. 'A²³jia'³ ma²³ ca²³xáan² 'ñée² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―¿'Ee² lǿ² 'a²³jia'³ sɨ³táan³na'³ quia̱'n²na'³ jné²? 'E³ quie'²³ bi²³ ca²³jue'n² miin²³. Bi²³ juø'²³ ca²³ti²³cø̱n³¹te'¹. 'E³ jo̱³ ca²³lʉ́³ la²³ co̱³quie'² miin²³. Ca²³jua'³te'²³: ―¿'I̱i̱² mi'³ sɨɨ'³¹ nɨ³ cu²ne²ra²? Dxí³ bee'² quia̱'² jmɨɨ³ mi'³ mɨ³guaan²³ 'e³ la²³ mɨ³dxi³ 'i'²³, ¿na'²? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","'E³ quie'²³ ca²³dxi²³guín²³te'²³ juɨɨ³ quiee'³² dsa³ Gadara, joo³¹ i²³'ŋóo² la²³ estado Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","'E³ la²³ ca²³bǿn³ 'e̱'³ móo² Jesús, ca²³jí̱i̱n³ jø̱n³ dsa³ 'i³ xen³ núu²³. Quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'² dsa³ 'í³. Mɨ³xa³ jmɨ́ɨ² cu³laan³. 'A²³jia'³ jen³¹ xi²ñʉ'¹. Ñʉ'²³ too³ 'loo³ je² 'aan³²te'²³ 'lɨ́ɨ³ jen³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ma²ŋøn³¹ Jesús dsa³ 'í³, bi²³ ca²³yo'³. Ca²³quiaa³ rɨ³'in³² xi²ñi² Jesús. Ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³jua'³: ―¿'Ee² lǿ² dxaan²³nu³ 'uǿøn²nu³ quia̱'n²nu³ jné², Jesús Jo̱o̱³¹ Dios 'i³ jen³¹ yʉʉ'³¹ güii³? Rɨ²juøøn³¹na¹ 'nʉ³: Jmee² co̱o̱³ mɨ²'áa² 'a²³ rɨ³jmee'n³²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","La'³ ca²³jua'³ dsa³ 'í³. Qui² ca²³dxi³ 'i'²³ Jesús. Ca²³sɨ'²³ espíritu quien³² mɨ²³sɨ²³quiʉ'² 'e³ cu²bøøn²³ dsa³. Ñúun³ taa'² so̱'²³ espíritu quie'² dsa³ 'í³. 'E³ jo̱³ ca²³'ñʉ́ʉ³te'²³ ñí² cadenas guoo³ tɨɨ². 'E³ quie'²³ lǿ²³ juø'² ca²³tʉ̱́n² ñí² cadenas. Ca²³jmée³ espíritu quien³² mɨ²³sɨ²³quiʉ'² 'e³ ca²³cuí̱i̱²³ je² 'a²³jia'³ nee'n²³² dsa³. La'³ cu³lø³¹ ca²³ji̱'²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―¿Jmii'³¹ xi̱i̱n³nu³? ―'I³ juɨ́ɨn²³ xi̱i̱n³na'³¹ ―ca²³jua'³ dsa³ 'í³. Qui² bi²³ juɨ́ɨn²³ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'i³ quie̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bi²³ ca²³ŋɨ'²³te'²³ Jesús 'e³ 'a²³jia'³ rɨ²³xíi²³ quie'²te'²³ too³ jɨ̱ɨ̱n²³² je² 'aan³²te'²³ espíritus quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bi²³ ma²³'nee³ juɨ́ɨn²³ cu²xi³¹ 'i³ ta'n² ee'³² coo³¹ mo'³. Bi²³ ca²³ŋɨ́ɨ³ miin²³ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'e³ rɨ²³cuǿ²³ júu² Jesús 'e³ rɨ²³taa'n³ miin²³ cu²xi³¹. 'E³ jo̱³ ca²³cuǿ³ júu² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ca²³'uǿøn²³ espíritus 'i³ quie̱n³ dsa³ 'í³. Ca²³taa'n³ miin²³ cu²xi³¹. 'E³ quie'²³ jo̱³ ca²³ta'n²³ jui³¹ ca²³la²³dxí² cu²xi³¹ je² juɨɨ'²³². Ca²³jiu'n²te'²³ 'e̱'³ jmɨ²³ñii'³¹. Ca²³'a'n² cu²xi³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","'E³ jo̱³ ca²³cuɨ̱́ɨ̱² dsa³ 'i³ 'aan³² cu²xi³¹ ma²ŋó¹te'²³ 'e³ jmii'³¹ mɨ³lǿ²³. I²jmóo¹ júu² jee²³² juɨɨ³ quia̱'² ranchos pii'². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","'E³ jo̱³ ca²³guín²³ dsa³ 'e³ jua'³ sɨ³joo³ 'e³ jmii'³¹ mɨ³lǿ²³. Ca²³guín²³te'²³ caan²³ Jesús. Ca²³jí̱i̱n³te'²³ dsa³ 'i³ cǿ̱n² espíritus quien³² mɨ²³sɨ²³quiʉ'² xe̱'n². Jen³¹ 'ui² tɨɨ² Jesús. Quii'³ cuo̱o̱³. Dxʉ́²³ mɨ²dxi². 'E³ jo̱³ bi²³ ca²³jue'n² miin²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","'E³ jo̱³ ca²³jmóo² júu² dsa³ 'i³ ŋó²³ 'e³ jmii'³¹ ca²³'láan³ dsa³ 'i³ cǿ̱n² espíritus quien³² mɨ²³sɨ²³quiʉ'² xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jo̱³ ca²³jua'³ la²³jɨn³ dsa³ 'i³ xen³ je² røøn³ Gadara. Ca²³sɨ'²³te'²³ Jesús 'e³ cu²bǿn³ juɨɨ³ quiee'³²te'²³. Qui² bi²³ juøø'n²³te'²³. 'E³ jo̱³ 'í² co̱'³ móo² Jesús. Ŋø'n² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","'E³ quie'²³ ca²³lʉ́³ dsa³ 'i³ cǿ̱n² espíritus quien³² mɨ²³sɨ²³quiʉ'² xe̱'n². Ca²³ŋɨ́ɨ³ mɨ²'áa² quie'² Jesús 'e³ rɨ²³cuǿ²³ júu² Jesús 'e³ rɨ²³dsóo² quia̱'². 'E³ quie'²³ ca²³tʉ́n² júu² quia̱'² dsa³ 'í³. Ca²³sɨ'²³: ");
INSERT INTO cnlNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Guø'n³ quién²nu³. Núu²³ rɨ²juɨɨ'n³¹ dsa³ 'e³ jmii'³¹ mɨ³jmée³ Dios quién²nu³. 'E³ jo̱³ ŋø'n² dsa³ 'í³. Ca²³jme'n² júu² la²³ca̱a̱n³ juɨɨ³ quiee'³² 'e³ jmii'³¹ 'nɨɨ'n³¹ ca²³jmée³ Jesús quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ma²ca¹dxe'n² co̱'³ Jesús juɨɨ³ quiee'³², juɨ́ɨn²³ dsa³ 'i³ ca²³mi²³juø'²³. Qui² je̱n³²te'²³ Jesús la²³jɨn³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ca²³dxóo² caan²³ Jesús jø̱n³ dsa³ 'i³ xi̱i̱n³ Jairo 'i³ rɨ³løn³¹ dsa³ 'i³ dxi³ 'i'²³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Ca²³quiaa³ rɨ³'in³² xi²ñi² Jesús. Ca²³ŋɨ́ɨ³ mɨ²'áa². Qui² 'née²³ 'e³ rɨ²³dsóo² Jesús quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Qui² mɨ³ rɨ²³jú̱n³ jo̱o̱³¹. 'E³ quie'²³ jø̱n³ la'³ qui²³jo̱o̱³¹ xen³ quie'² 'i³ mɨ³tɨ́³ co̱o̱³ gui²³tʉ̱́³ ji̱i̱'n²³. 'E³ la²³ ca²³'ɨ́ɨn²³ Jesús, bi²³ rɨ³cuu'n³² jee²³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Quia̱'²te'²³ jø̱n³ mɨ́³ 'i³ mɨ³tɨ́³ gui²³tʉ̱́³ ji̱i̱³ ñi³ 'e³ sɨ³ŋɨ́n³ jmɨ²³'ǿn². Ca²³dsá²³ la²³jɨ³ 'e³ xa³ quie'² 'e³ ca²³quí² jñiin²³ tɨ³² 'oo³. 'A²³'i̱³ xen³ 'i³ lǿ²³ juø'² ca²³mi²³'láan³ mɨ́³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ca²³lǿn²³ mɨ³lén² rɨ²³coo'² Jesús. Ca²³quiʉ̱'² xi²guoo³ xʉʉ'²³² cuo̱o̱³ Jesús. Xe̱'n² jmɨ́ɨ² ca²³'ɨ́ɨ³ 'e³ sɨ³ŋɨ́n³ jmɨ²³'ǿn² mɨ́³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'I̱i̱² sɨɨ'³¹ 'i³ mɨ³quiu̱u̱'n³ jné² guoo³? ―'A²³la³ jné² ―ca²³jua'³ la²³jɨn³ dsa³. 'E³ jo̱³ ca²³jua'³ Peen²³² quia̱'² dsa³ 'i³ quia̱'²: ―Dsa³ 'e²³, juɨ́ɨn²³ dsa³ 'i³ té̱e̱n³ la²³cu'² je² xi'n²³nu³. Rɨ³cuu'n³²nu³ jee²³² dsa³. ¿'Ee² lǿ² juø'n³: “¿'I̱i̱² sɨɨ'³¹ 'i³ mɨ³quiu̱u̱'n³ jné² guoo³?” ");
INSERT INTO cnlNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","'E³ quie'²³ ca²³jua'³ 'ñée² Jesús: ―Xen³ 'i³ mɨ³quiu̱u̱'n³ jné² xi²guoo³ xú̱n³. Qui² mɨ³la³quiin²³ 'e³ xa³ ju²³bíi²³ 'e³ mɨ³ŋoo³² quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","'E³ jo̱³ ca²³dsóo²³ dsɨ́² mɨ́³ 'e³ 'a²³jia'³ rɨ²³li'²³ juø'² rɨ²³'mén² 'ñée². 'E³ jo̱³ jleen²³ mɨ́³ 'í³ ja'n² co̱'³ caan²³ Jesús. Ca²³quiaa³ rɨ³'in³² xi²ñi² Jesús. Ca²³jmée³ júu² xi²ñi² la²³jɨn³ dsa³ 'e³ 'ee² lǿ² 'e³ mɨ³quiu̱u̱'n³ guoo³ Jesús, 'e³ jmii'³¹ mɨ³'ɨ́ɨ³ dsóo² quiee'³² xe̱'n² jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³: ―Ja̱a̱n²³ quién²³na²³, mɨ³lɨɨn³²nu³. Qui² sɨ³táan³nu³ quia̱'n²nu³ jné². Dxa² co̱o̱³ 'áan² 'e³ guø'n³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lʉ²³ quie'²³ Jesús ca²³dxóo² jø̱n³ dsa³ 'i³ naan³ xi²ñʉ'¹ quiee'³² Jairo. Ca²³jua'³: ―Mɨ³jú̱n²³ ja̱a̱n³, ¿mɨ³naa'³¹? 'A²³jia'³ ma²³ 'ne'² rɨ²cuǿn² cɨ² u²³ŋɨ́³ dsɨ́ɨ² quie'² dsa³ 'e²³ 'e³ dsoo³² quién²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ca²³núu³ Jesús 'e³ jmii'³¹ ca²³jua'³. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Jairo: ―'A²³ rɨ³juø'n²³nu³ 'uǿøn²nu³. 'Nɨɨ'n³¹ 'e³ rɨ²³sɨ²³táan³ma²nu³ 'ne'². Jo̱³ hua² rɨ²³líin²³ xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ma²ca¹dxóo¹ Jesús quie'² Jairo, 'í² xi²ñʉ'¹ quia̱'² Peen²³² quia̱'² Juan quia̱'² Jacobo quia̱'² xóo² jmii³ xii'³. 'A²³jia'³ ca²³cuǿ³ júu² 'e³ rɨ²³'í³ jia'³ cɨ'²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ta'² 'oo'³² la²³jɨn³ dsa³ 'i³ nee'n²³² xi²ñʉ'¹. Ŋɨ́³ dsɨ́²te'²³ 'e³ jua'³ mɨ³jú̱n²³ xii'³. 'E³ jo̱³ ca²³jua'³ Jesús: ―'A²³ 'oo'²ra'³. Qui² 'a²³jia'³ rɨ³jú̱n² xii'³. Te³ 'e³ rɨ³guɨɨn³ hua². ");
INSERT INTO cnlNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bi²³ ca²³jáa² ca²³ŋɨ́ɨn²te'²³ Jesús. Qui² ñi³²te'²³ 'e³ rɨ³jú̱n² xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","'E³ quie'²³ jo̱³ so̱'²³ guoo³ xii'³ Jesús. Ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³jua'³: ―Naa'n²³ 'nʉ³, xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Gua'² co̱'³ dxí³ ta'n² xii'³. Ca²³naa'n²³ xe̱'n² jmɨ́ɨ². 'E³ quie'²³ jo̱³ ca²³dxi³ 'i'²³ Jesús 'e³ rɨ²³cuǿø²³te'²³ 'e³ rɨ²³e'² xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bi²³ juø'²³ ca²³ti²³cø̱n³¹ xóo² jmii³. 'E³ quie'²³ ca²³dxi³ 'i'²³ Jesús 'e³ cu³xi³ jø̱n³ dsa³ 'a²³jia'³ rɨ²³sɨ'²³te'²³ 'e³ la²³ lǿ² mɨ³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús ca²³ñii'n³ dsa³ gui²³tʉ̱́n³ quien³². Ca²³cuǿ³ ju²³bíi²³ quie'²te'²³. Ca²³cuǿ³ júu² 'uee'n³ quie'²te'²³ 'e³ rɨ²³'uøøn³te'²³ espíritus quien³² mɨ²³sɨ²³quiʉ'², 'e³ rɨ²³mi²³'láan³te'²³ dsa³ 'i³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","'E³ quie'²³ jo̱³ ca²³xíin²³ dsa³ quien³² 'e³ sɨ³'íi³te'²³ júu² 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³, 'e³ sɨ³mi³'láan³te'²³ dsa³ 'i³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ca²³jua'³ 'ñée² Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'A²³'e³ xa³ 'ne'² rɨ²có̱²ra'³ 'e³ la²³ rɨ²taa'n³²na'³ jui³¹. 'A²³ rɨ³co̱³ra'³ 'mo³ mɨ³'uu²³². 'A²³ rɨ³co̱³ra'³ morral. 'A²³ rɨ³co̱³ra'³ 'ɨ²³juɨ². 'A²³ rɨ³co̱³ra'³ cuu² quién²na'³. Líi² co̱³dsa'n² cuo̱o̱³²ra'³ 'e³ qui'²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Te³ jiaa'³¹ je² rɨ²³cuǿø²³te'²³ 'nee'²³ xi²ñʉ'¹, 'e³ quie'²³ núu²³ rɨ²cuaa'n²³na'³ la²³huø'n²³ 'e³ rɨ²³tɨ́²³ 'e³ rɨ²'uøøn³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te³ jiaa'³¹ je² 'a²³jia'³ rɨ²³'i'n²te'²³ 'nee'²³, rɨ²quia'¹ra'³ 'laa³ tɨɨ³¹ra'³ mɨ³rɨ³'uøøn³²na'³ juɨɨ³ jo̱³. Cu²li³lii²³ 'e³ 'a²³jia'³ dxʉ́²³ jmoo³²te'²³. ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ gui²³tʉ̱́n³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","'E³ jo̱³ ca²³'uǿøn²³ dsa³ quien³². Ca²³guín²³te'²³ la²³ca̱a̱n³ jia'³ cɨ'²³ juɨɨ³. Ca²³'ɨ́ɨ³te'²³ júu² dxʉ́²³ la²³ca̱a̱n³. Ca²³mi²³'láan³te'²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ca²³núu³ dxi² juɨɨ³ pii'² 'i³ xi̱i̱n³ Herodes 'e³ jmii'³¹ lǿ² la²³jɨ³ 'e³ sɨ³lí³. 'E³ jo̱³ bi²³ ca²³ŋɨ́³ dsɨ́² 'ñée². Qui² xen³ dsa³ 'i³ jua'³ 'e³ mɨ³ji̱i̱'²³ co̱'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Xen³ dsa³ 'i³ jua'³ 'e³ mɨ³güee'n³² co̱'³ Elías. Xen³ jia'³ cɨ'²³ dsa³ 'i³ jua'³ 'e³ mɨ³ji̱i̱'²³ co̱'³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","'E³ quie'²³ ca²³jua'³ Herodes: ―Ca²³dxin²³ 'i'²³ 'e³ ca²³tu̱n³ mɨ²dxi² Juan, ¿mɨ³naa'³¹? 'E³ quie'²³, ¿'i̱i̱² hua² dsa³ 'en³²te'²³ cu²ne²ra²? 'E³ jo̱³ 'née²³ Herodes 'e³ rɨ²³mi²³jí̱i̱n³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma²ca¹i¹guiin³² co̱'³ dsa³ xiin²³, ca²³sɨ'²³te'²³ Jesús la²³jɨ³ 'e³ ca²³jmóo²te'²³. 'E³ quie'²³ Jesús ca²³jén²³ dsa³ quien³². I²guín¹te'²³ juɨɨ³ je² xi̱i̱n³ Betsaida je² ca²³jmóo²te'²³ co̱³quie'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma²ca¹núu³ dsa³ 'e³ ŋóo² Jesús, ca²³guín²³te'²³ tu³cɨ̱ɨ̱n³te'²³. Bi²³ ca²³mi²³jue'³ Jesús ma²mɨ³ŋøn³² dsa³. Ca²³lʉ́³. Ca²³sɨ'²³ dsa³ 'e³ rɨ³løn³¹ Dios juii² dsa³. Ca²³mi²³'láan³ dsa³ 'i³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ma²mɨ³cu³'lóo³, ca²³cu²³cáan² Jesús dsa³ gui²³tʉ̱́n³. Ca²³sɨ'²³te'²³ Jesús: ―Xii'² dsa³ 'e³ cu²dxi³guiin³²te'²³ jee²³² juɨɨ³ quia̱'² ranchos je² mɨ³lén² la³. Núu²³ rɨ²³tøø³ dsɨ́²te'²³. Núu²³ sɨ³lá³te'²³ 'e³ rɨ²³e'²te'²³. Qui² 'a²³'i̱³ xen³ dsa³ 'i³ nee'n²³² je² la³. ―La'³ ca²³jua'³ dsa³ gui²³tʉ̱́n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'Nee'²³ rɨ²cuøø³¹ra'³ 'e³ rɨ²³e'²te'²³. 'E³ jo̱³ ca²³jua'³ dsa³ quien³²: ―Xa³ 'ñé³ 'ɨ²³juɨ² qui³ quiée²ra'³¹ quia̱'² áan²³ 'moo'³. 'Nɨɨ'n³¹ la'³ hua² xa³ xi³nu³ 'a²³jia'³ sɨ³la²³²ra'³¹ 'e³ rɨ²³e'² la²³jɨn³ dsa³ nɨ³. ―La'³ ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Qui² xen³ co̱o̱³ 'ñé³ mil 'nɨɨ'n³¹ dsóo²³. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Rɨ²juɨɨ'³¹ra'³ dsa³ 'e³ rɨ²³gua³te'²³ cɨ'³ tú̱²³ lu²³guién³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","'E³ jo̱³ ca²³sɨ'²³te'²³ dsa³ 'e³ rɨ²³gua³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","'E³ quie'²³ jo̱³ so̱'²³ Jesús la²³jɨ³ 'ñé³ 'ɨ²³juɨ² quia̱'² áan²³ 'moo'³. Ca²³jóo² yʉʉ'³¹. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. Ca²³xíin² 'ɨ²³juɨ². Ca²³cuǿø²³ dsa³ quien³² 'e³ rɨ²³to'²³te'²³ dxóo² 'e³ rɨ²³e'² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ca²³e'² la²³jɨn³ dsa³. Ca²³e'² la²³jɨn³ sú̱n² dsa³ xi³'lɨ² ca²³cø̱'n²³te'²³. Ca²³dxi²³cua̱a̱'n³te'²³ la²³jɨ³ 'e³ ca²³tø'n². Gui²³tʉ̱́³ mɨɨ'³ dsuu² 'nɨɨ'n³¹ ca²³cø̱'n²³ jmø'n² juɨɨ²³² 'e³ ca²³tø'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ca²³tɨ́³ jmɨ́ɨ² 'e³ ca²³lʉ́³ Jesús quia̱'² Dios je² co̱³quie'² quia̱'² dsa³ quien³². 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―¿'I̱i̱² sɨɨ'³¹ jné², jua'³ dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","'E³ jo̱³ ca²³jua'³ dsa³ quien³²: ―Xen³ 'i³ jua'³ 'e³ Juan 'i³ ca²³xáan² dsa³ jmɨɨ³ hua² 'nʉ³. Xen³ 'i³ jua'³ Elías co̱'³. Xen³ 'i³ jua'³ 'e³ mɨ³ji̱i̱'²³ co̱'³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―¿'I̱i̱² sɨɨ'³¹ jné², juo'³ra'³ 'nee'²³? Ca²³jua'³ Peen²³²: ―Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios hua² 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","'E³ jo̱³ ca²³dxi³ 'i'²³ Jesús 'e³ 'a²³jia'³ 'ne'² rɨ²³sɨ'²³te'²³ dsa³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Co̱'³ cɨ'²³ ca²³jua'³: ―Bi²³ ñúun³ la²³jɨ³ 'e³ li²³'ne'² rɨ²³jí̱i̱n²³ jné² Jo̱o̱³¹ Dsa³. Rɨ²³tʉ́n² jné² te'²³ dsa³ mɨ³dxún²³ quia̱'² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley. Rɨ²³jŋɨ'n²³te'²³ jné². 'E³ quie'²³ je² rɨ²³tɨ́²³ 'nɨ³ jmɨ́ɨ² 'e³ la²³ jú̱n²³na²³ rɨ²³ji̱i̱'n²³na²³ co̱'³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ca²³jua'³ Jesús. Ca²³sɨ'²³ la²³jɨn³ dsa³: ―'A²³jia'³ ma²³ joo'²³ rɨ²³jmée²³ 'e³ la²³ 'née²³ 'ñée² dsa³ 'i³ 'née²³ rɨ²³qui̱'³ jné². 'Ne'² rɨ²³cuǿn²³ 'ñée² 'e³ rɨ²³dxi²³quié̱n² cɨ'³ la²³ co̱o̱³ jmɨ́ɨ² 'e³ la²³ dxi³quié̱n² dsa³ 'i³ ta̱a̱n²³ cruz. 'Ne'² rɨ²³ŋɨ́²³ quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Qui² rɨ²³gua'²³ dsa³ 'i³ bi²³ cɨ² mi³quí̱i̱n²³ 'e³ xen³ mɨ³¹güii³ la³. 'E³ quie'²³ rɨ²³láan³ dsa³ 'i³ rɨ²³cuǿn²³ 'ñée² 'e³ rɨ²³jú̱n³ 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Qui² 'a²³'e³ cua̱a̱n²tu² xa³ quie'² dsa³ 'i³ rɨ²³'ióo²³ la²³jɨ³ sú̱n² 'e³ xa³ mɨ³¹güii³ la³ xi³nu³ rɨ²³gua'²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jné² Jo̱o̱³¹ Dsa³ li²³'ii'n²³na²³ dsa³ 'i³ 'ii'n²³ jné², 'i³ 'ii'²³ quia̱'² júu² quián²³. Li²³'ii'n²³na²³ dsa³ 'í³ mɨ³rɨ³güe'n²³na²³ co̱'³. Jmɨ́ɨ² jo̱³ li²³lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³na²³. Qui² li²³gáan³na²³ la²³ gáan³ Ñu'n²³, la²³ gáan³ ángeles 'i³ rɨ³jɨ́n². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xen³ dsa³ 'i³ té̱e̱n³ la³ rɨ³nɨ²³ 'i³ rɨ²³jóo² jén²³ cɨ² 'e³ la²³ rɨ²³jú̱n³ 'e³ rɨ³løn³¹ Dios juii² dsa³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ma²ca¹tɨ́³ co̱o̱³ jñé²³ jmɨ́ɨ² 'e³ la²³ ca²³jua'³ la'³ Jesús, ca²³jén²³ Peen²³² quia̱'² Juan quia̱'² Jacobo. Ŋóo² yʉʉ'³¹ mo'³ 'e³ jua'³ rɨ²³lʉ́²³ quia̱'² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","'E³ la²³ ca²³lʉ́³ quia̱'² Dios, ca²³guø'n³ 'e³ la²³ lǿ² ñi². Taa³ la²³ ca²³lǿ²³ cuo̱o̱³. Bi²³ ma²³'nee³ rɨ³jii'³¹ cuo̱o̱³ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Xen³ áan²³ dsa³ 'i³ ca²³mi²³róo³ quia̱'² Jesús. Moisés quia̱'² Elías hua² 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bi²³ rɨ³ji'n³¹te'¹ 'i³ 'í³ co̱'³. Ca²³lʉ́³te'²³ júu² 'e³ jmii'³¹ lǿ² rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jú̱n³ Jesús juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bi²³ ca²³too'²³ la²³guɨɨn³ ca²³ji̱'²³ Peen²³² quia̱'² te'²³ uu'n². 'E³ quie'²³ quii²³quie'²³te'²³. Ŋó²³te'²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³ 'ñée² Jesús. Ŋǿn² te'²³ áan²³ dsa³ 'i³ té̱e̱n³ quia̱'² Jesús co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mɨ³ rɨ²³sɨ²³guiin³² dsa³ 'i³ té̱e̱n³ quia̱'² Jesús. 'E³ jo̱³ ca²³jua'³ Peen²³². Ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³, ¡bi²³ dxʉ́²³ 'e³ nee'²³²ra'³¹ je² la³! Dxʉ́²³ rɨ²jmee²ra'³¹ 'nɨ³ mɨɨ³¹ mɨ²'ñʉ́¹ pii'². Rɨ²jmee²ra'³¹ co̱o̱³ 'e³ quien³²nu³, co̱o̱³ 'e³ quiee'³² Moisés, co̱o̱³ 'e³ quiee'³² Elías co̱'³. ―La'³ ca²³jua'³ Peen²³². 'A²³jia'³ jmee²³ 'i'²³ 'ñée² jmii'³¹ cu³lø³¹ júu² 'e³ ca²³lʉ́³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","'E³ la²³ ca²³lʉ́³ la'³ Peen²³², jó² co̱o̱³ jníi² 'e³ ca²³een³te'²³. Bi²³ juøø'n²³ Peen²³² quia̱'² dsa³ 'i³ quia̱'² 'e³ la²³ ca²³een³ jníi². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Xen³ 'i³ ca²³lʉ́³ jí̱i̱n² jee²³² jníi². Ca²³jua'³: ―'I³ la³ ja̱a̱n²³ 'i³ bi²³ 'náan²³na²³. Rɨ²núu²ra'³ la²³jɨ³ júu² 'e³ lʉ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ma²mɨ³líi² mɨ³jua'³ la'³, ŋó²³te'²³ 'e³ jø̱n³ 'ñée² cɨ² Jesús 'i³ quia̱'²te'²³. 'A²³jia'³ ca²³jmóo²te'²³ júu² 'e³ jmii'³¹ cu³lø³¹ la²³jɨ³ 'e³ ŋó²³te'²³. 'A²³'i̱³ xen³ 'i³ ca²³sɨ'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","La²³ mɨ²³dxóo³ la'³, ca²³jiaan³²te'²³ co̱'³ yʉʉ'³¹ mo'³. Bi²³ juɨ́ɨn²³ dsa³ 'i³ ca²³mi²³jí̱i̱n³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ca²³lʉ́³ quiʉ̱ʉ̱³ jø̱n³ dsa³ 'i³ xi'n²³ jee²³² quiee'³² dsa³. Ca²³jua'³: ―Dsa³ 'e²³, rɨ²jméen² co̱o̱³ mɨ²'áa² 'e³ rɨ²joon²³nu³ ja̱a̱n²³. Qui² jø̱n³ la'³ qui²³ja̱a̱n²³ xen³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Xen³ espíritu 'i³ sø̱'n³² xii'³. Co̱'³ la²³ yoo'²³ jmee²³ xii'³. Jmee²³ espíritu 'e³ sɨ³je'n² quie'². Jmee²³ 'e³ sɨ³'ia³ jo̱³ 'oo². Bi²³ jme'²³ xii'³. Cu³dsɨɨ³² la²³ tʉʉ³² espíritu cɨ'³ la²³ co̱o̱³ dxa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","'E³ jo̱³ mɨ³juǿøn² dsa³ quien³²nu³ 'e³ ca³quie̱e̱² 'náan²³ 'e³ rɨ²³dxin³te'²³ espíritu. 'E³ quie'²³ 'a²³jia'³ ca³lɨɨ'³²te'²³ juø'². ―La'³ ca²³jua'³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","'E³ jo̱³ ca²³jua'³ Jesús: ―Bi²³ 'a²³jia'³ sɨ³táan³na'³ quia̱'n²na'³ jné². Bi²³ jia'³ cu³lø³¹ 'i'²³ 'e³ jmee³ra'³. ¿Lɨɨ'³¹ cɨ² huø'n²³ 'e³ 'ne'² quia̱'n²³²na¹ 'nee'²³? ¿Lɨɨ'³¹ cɨ² huø'n²³ 'ne'² 'e³ rɨ²³táan²³ 'e³ la²³'nɨɨ'n³¹ 'e³ jmee³ra'³? Co̱'³ cɨ'²³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ quie̱n³ espíritu jo̱o̱³¹: ―Cu³jén²³ la³ ja̱a̱n³ ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","'E³ la²³ ca²³lǿn²³ mɨ³lén² xii'³ caan²³ Jesús, ca²³juén² xii'³ 'uǿ²³ ca²³jmée³ espíritu quien³² mɨ²³sɨ²³quiʉ'². Ca²³jmée³ 'e³ ca²³je'n² quie'². 'E³ jo̱³ ca²³jíi² Jesús. Ca²³jín² espíritu quien³² mɨ²³sɨ²³quiʉ'². Ca²³mi²³'láan³ xii'³. Ca²³jɨ̱ɨ̱'n³ co̱'³ jmii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bi²³ juø'²³ ca²³jóo² la²³jɨn³ dsa³ 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³ Dios. 'E³ la²³ juø'²³ ti³cø̱n³¹ dsa³ la²³jɨ³ 'e³ ca²³jmée³ Jesús, ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ quien³²: ");
INSERT INTO cnlNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―'Ne'² rɨ²núu²ra'³ dxʉ́²³ júu² 'e³ rɨ²juøøn³¹na¹ 'nee'²³: 'E³ cɨ² rɨ²³ta̱a̱'n³te'²³ guoo³ dsa³ mɨ³¹güii³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","'E³ quie'²³ 'a²³jia'³ ca²³dsaan³²te'²³ júu² 'e³ ca²³lʉ́³ 'ñée². Qui² 'a²³jia'³ ca²³cuǿ³ júu² 'e³ rɨ²³sɨ²³dsaan³²te'²³ 'e³ 'ee² lǿ² ca²³jua'³ la'³. 'A²³ cɨ'²³ 'e³ ca²³la²³bii²³ dsɨ́²te'²³ 'e³ rɨ²³ŋɨ́ɨ²³te'²³ júu² 'e³ 'ee² lǿ² ca²³jua'³ la'³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ca²³tɨ́³ 'e³ ca²³sɨ́n²³ júu² la²³ co̱³quie'² dsa³ quien³² Jesús 'e³ 'i̱i̱² sɨɨ'³¹ miin²³ 'i³ gáan³ cɨ². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ca²³la²³quii²³ Jesús 'e³ jmii'³¹ cu³lø³¹ lǿn³te'²³. 'E³ jo̱³ ca²³tøø³ jø̱n³ xii'³ pii'². Ca²³dxén² caan²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―'Ii'n³² jné² dsa³ 'i³ 'ii'n³² xii'³ pii'² la³ 'e³ jua'³ rɨ³løn³¹ dsa³ quién²³na²³. 'E³ quie'²³ la'³ 'ii'n³² Dios 'i³ ca²³xíin²³ jné². Jø̱n³ 'nee'²³ 'i³ rɨ²³lín³ mozo jee²³² quien³²na'³, 'i³ 'í³ hua² 'i³ gáan³ ca³quie̱e̱². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","'E³ jo̱³ ca²³jua'³ Juan: ―Dsa³ 'e²³, ca²³nen²³²na'³¹ jø̱n³ dsa³ 'i³ 'uøøn³ espíritus quien³² mɨ²³sɨ²³quiʉ'² 'e³ jua'³ 'ñée² 'e³ rɨ³løn³¹ dsa³ quien³²nu³. Ca²³xii'³¹ra'³¹ 'e³ 'a²³jia'³ ma²³ rɨ²³jmée²³ la'³. Qui² 'a²³jia'³ ŋɨ́³ quia̱'² jne². ―La'³ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Juan: ―'A²³ ma²³ rɨ³juɨɨ'³²ra'³ dsa³ 'í³ 'e³ 'a²³jia'³ ma²³ rɨ²³jmée²³ la'³. Qui² rɨ³løn³¹ co̱o̱³ júu² quia̱'² jne² dsa³ 'i³ 'a²³jia'³ nɨ́ɨn³ quia̱'² jne². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mɨ³lǿ²³ mɨ³lén² jmɨ́ɨ² 'e³ rɨ²³dsø'n² co̱'³ yʉʉ'³¹ Jesús. Ca²³dxá³ co̱o̱³ dsɨ́² Jesús 'e³ dsoo³² juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ca²³xíin²³ dsa³ 'i³ sɨ³guín²³ jén²³ cɨ². I²guín¹te'²³ co̱o̱³ juɨɨ³ quiee'³² dsa³ Samaria 'e³ jua'³te'²³ rɨ²³mi²³tɨ́ɨ²³te'²³ la²³jɨ³ 'e³ 'ne'² quie'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² ca²³'i'n²te'²³ Jesús. Qui² dsoo²³ dsɨ́²te'²³ 'e³ dsoo³² 'ñée² juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","'E³ jo̱³ ma²ŋo²³² dsa³ quien³² 'i³ xi̱i̱n³ Jacobo quia̱'² Juan 'e³ jmii'³¹ ca²³jmóo² dsa³ Samaria, ca²³jua'³te'²³: ―Juii³ra'³¹, ¿'a² 'naan³ 'e³ rɨ²dxi²³²ra'³¹ 'i'²³ 'e³ rɨ²³'ló²³ ji³ jí̱i̱n² yʉʉ'³¹ güii³ 'e³ rɨ²³mi²³gua'²³ dsa³ la³ 'e³ la²³ ca²³jmée³ Elías mɨ²jo̱³? ");
INSERT INTO cnlNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ca²³ji̱i̱n²³ Jesús. Ca²³jín² Jacobo quia̱'² Juan. Ca²³jua'³: ―'A²³jia'³ ca³la³quin³na'³ 'e³ jmii'³¹ lǿ² 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Qui² 'a²³la³ jo̱³ 'e³ rɨ²jŋɨ'n³¹na¹ dsa³ 'e³ mɨ³güén²³na²³ jné² Jo̱o̱³¹ Dsa³. Mɨ³güén²³na²³ 'e³ rɨ²láan¹na²³ dsa³ hua². ―La'³ ca²³jua'³ Jesús. 'E³ quie'²³ jo̱³ ca²³guín²³te'²³ jia'³ cɨ'²³ juɨɨ³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","'E³ la²³ ta'n²te'²³ jui³¹, ca²³jua'³ jø̱n³ dsa³. Ca²³sɨ'²³ Jesús: ―'Náan²³ ñiin²³ quia̱'n²³²na¹ 'nʉ³ te³ jiaa'³¹ quie'²³ guaan³². ");
INSERT INTO cnlNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'Ne'² rɨ²jméen² 'i'²³ dxʉ́²³. Xa³ tóo² 'ioo'³. Xa³ mɨ²sɨɨ² jo̱o̱³¹ to̱³. 'E³ quie'²³ 'a²³'e³ xa³ quián²³ jné² Jo̱o̱³¹ Dsa³ je² guɨɨn²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Co̱'³ cɨ'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ jia'³ cɨ'²³ dsa³: ―Ñe³ quia̱'n²nu³ jné². 'E³ quie'²³ ca²³jua'³ dsa³ 'í³: ―Juiin²³, cuø² cu²ru'³ júu² 'e³ i³'aan²³²na¹ 'lɨ² ñu'n²³. Jo̱³ tu³ ñiin²³ quia̱'n²³²na¹ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Cu²'áan¹ quie'²³ 'lɨ́ɨ³ te'²³ dsa³ 'i³ 'é̱e̱² 'e³ rɨ³jú̱n². 'E³ quie'²³ 'nʉ³, guo³ cu³'íin³ júu² 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Xen³ jia'³ cɨ'²³ dsa³ 'i³ ca²³jua'³: ―Juiin²³, 'náan²³ ñiin²³ quia̱'n²³²na¹ 'nʉ³. 'E³ quie'²³ cuø² cu²ru'³ júu² 'e³ ñe'n³²cɨ²na¹ xe̱'n² i³lʉn²³ quia̱'n²³²na¹ 'i³ xen³ quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ca²³jua'³ co̱'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'A²³jia'³ 'nee'n³¹ dsa³ 'i³ mi³ñúun³ dsɨ́² 'i³ lǿn³ rɨ²³jmée²³ ta² quiee'³² Dios. Qui² 'a²³jia'³ rɨ²³ti²³guo² 'e³ rɨ²³jmée²³ ta² 'e³ røøn³ Dios dsa³ 'í³ xi³nu³ la'³. Xen³ la²³ xen³ dsa³ 'i³ joo³² rɨ²³coo'² 'e³ la²³ 'uøn³² 'uǿ²³. Sɨ³jlʉ́²³ ta² quiee'³². 'A²³jia'³ jmɨ́ɨ² rɨ²³ti²³guo² ta² quiee'³². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ma²mɨ³líi² la'³, ca²³'uøøn³ tú̱²³ lu²³guién³ dsɨ³² guiáan³ dsa³ quien³² ca²³jmée³ Juii³ra². Ca²³xíin²³ dsa³ 'í³ 'e³ rɨ²³ŋɨ́n³te'²³ jén²³ cɨ² la²³ 'ñée². Cɨ'³ áan²³ cɨ'³ áan²³ ca²³xíin²³ cɨ'³ la²³ co̱o̱³ juɨɨ³. Rɨ²³ŋɨ́²³te'²³ la²³ca̱a̱n³ je² 'e³ cɨ² rɨ²³ŋɨ́n³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Bi²³ ñúun³ xa³ je² 'íi² rɨ²³jmóo²te'²³ 'ó̱o̱²³. 'E³ quie'²³ 'a²³jia'³ juɨ́ɨn²³ xen³ 'i³ rɨ²³jmóo² 'ó̱o̱²³. 'E³ jo̱³ 'ne'² rɨ²lʉ́²ra'³ quia̱'n²na'³ juii² ta², 'e³ rɨ²juɨɨ'³¹ra'³ 'e³ cu²xíin¹ cɨ² mozos 'i³ sɨ³jmóo² 'ó̱o̱²³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Líi² cu³guín²³na'³ jo̱o̱²³na²³. La²³ xen³ dsɨɨ³ joo³ 'i³ sɨ³guín²³ jee²³² 'ioo'³ xen³na'³ 'e³ la²³ sɨɨn³²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","'A²³ rɨ³co̱³ra'³ paa²i² 'e³ rɨ³pee'n²³ cuu². 'A²³ rɨ³co̱³ra'³ morral. Líi² la²³'nɨɨ'n³¹ co̱o̱³ dsa'n² loo³ 'e³ rɨ³'éen³na'³. 'A²³ rɨ³mi³'ɨɨ²³²ra'³ mɨ³rɨ³jí̱i̱n³na'³ dsa³ dxi²jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Te³ jiaa'³¹ rɨ²taa'n³²na'³ xi²ñʉ'¹, 'íi² rɨ²taa'n³²na'³ rɨ²juɨɨ'³¹ra'³ dsa³ 'i³ nee'n²³² 'ñʉ́² jo̱³: “Cu²gua³ ca²³tó̱o̱²³ 'óo²ra'³”. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Xi³nu³ xen³ xi²ñʉ'¹ jo̱³ dsa³ 'i³ 'née²³ 'e³ rɨ²³gua³ ca²³tó̱o̱²³ dsɨ́², 'e³ jo̱³ rɨ²³núu²³ júu² quien³²na'³ la²³jɨn³ dsa³ 'í³. 'E³ quie'²³ xi³nu³ 'a²³'i̱³ xen³ dsa³ 'i³ lǿn²³ la'³, 'a²³jia'³ rɨ²³núu²³te'²³ júu² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Te³ 'ee² 'ñʉ́² je² rɨ²'ín³na'³, núu²³ rɨ²cuaa'n²³na'³. Rɨ²'u'² rɨ²cø'²ra'³ te³ 'ee² 'noo³¹ 'e³ rɨ²³cuǿø²³te'²³ 'nee'²³. Qui² joo'²³ rɨ²³e'² dsa³ 'i³ jmee²³ ta². 'A²³ rɨ³ŋɨ́²ra'³ i²³la³ i²³nɨ³ xi²ñʉ'¹ quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","'E³ quie'²³ la'³ mɨ³rɨ³taa'n³²na'³ co̱o̱³ juɨɨ³. Xi³nu³ rɨ²³'i'n²te'²³ 'nee'²³, rɨ²cø'²ra'³ te³ 'ee² 'noo³¹ 'e³ rɨ²³dxá³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Rɨ²mi³'láan²na'³ dsa³ 'i³ dsoo'²³² 'i³ nee'n²³² juɨɨ³ jo̱³. Rɨ²juɨɨ'³¹ra'³ dsa³: “Mɨ³lǿ²³ mɨ³lén² 'e³ rɨ²núu²ra'³ júu² 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³”. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","'E³ quie'²³ mɨ³rɨ³taa'n³²na'³ juɨɨ³ je² 'a²³jia'³ rɨ²³'i'n²te'²³ 'nee'²³, rɨ²'uøøn³²na'³ jee²³² calles juɨɨ³ quiee'³²te'²³. Rɨ²juɨɨ'³¹ra'³ dsa³: ");
INSERT INTO cnlNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Cu³xi³ 'laa³ 'e³ xa³ juɨɨ³ quien³²na'³ 'e³ rɨ³'ɨ̱'n² tɨɨ³¹ra'³¹ 'a²³jia'³ 'nee³ra'³¹. Rɨ²xi²ra'³¹ tɨɨ³¹ra'³¹ 'laa³ 'e³ xa³ juɨɨ³ quien³²na'³ 'e³ juaa'³ra'³¹ cu²li³lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'a²³jia'³ dxʉ́²³ jmee³ra'³. Qui² 'ne'² rɨ²móo²ra'³ 'e³ mɨ³lǿ²³ mɨ³lén² 'e³ rɨ²núu²ra'³ júu² 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³.” La²³nɨ³ cu³lø³¹ rɨ²juɨɨ'³¹ra'³ dsa³ je² 'a²³jia'³ rɨ²³'i'n²te'²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Rɨ²juøøn³¹na¹ 'nee'²³: Bi²³ cɨ² gáan³ dxíi³ rɨ²³ji̱'²³ dsa³ 'i³ 'a²³jia'³ rɨ²³'i'n² 'nee'²³ mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²³dxá²³ Dios ta² quiee'³² dsa³ la²³ cɨ'²³ dsa³ 'i³ xen³ mɨ²jaa²³² juɨɨ³ Sodoma. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Bi²³ juɨɨ³² 'nee'²³, dsa³ juɨɨ³ Corazín. Bi²³ juɨɨ³² 'nee'²³, dsa³ juɨɨ³ Betsaida. Qui² 'a²³jia'³ mi³quí̱i̱n²³na'³ la²³jɨ³ u²³juø'²³ 'e³ jmeen²³. Ca²³tʉ́² 'e³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³ dsa³ juɨɨ³ Tiro quia̱'² dsa³ juɨɨ³ Sidón 'u² cu²ru'³ ca²³lǿ²³ u²³juø'²³ juɨɨ³ quiee'³²te'²³ 'e³ la²³ lǿ² ca²³jméen²³ juɨɨ³ quien³²na'³. Cɨ'²³te'²³ 'mɨɨ'³ 'e³ quii'³ dsa³ 'i³ 'aa³ u²³ŋɨ́³ dsɨ́ɨ² 'u² cu²ru'³ la'³. Ca²³'li'²³te'²³ juo³ mɨ²dxi²te'¹ 'e³ jua'³ jmoo³² lii²³ 'e³ ŋɨ́³ dsɨ́²te'²³ 'u² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","'E³ quie'²³ bi²³ cɨ² gáan³ dxíi³ rɨ²³jí̱i̱n² 'nee'²³ la²³ cɨ'²³ dsa³ juɨɨ³ Tiro quia̱'² dsa³ juɨɨ³ Sidón mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²³dxá²³ Dios ta² quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Rɨ²juøøn³¹na¹ 'nee'²³, dsa³ juɨɨ³ Capernaum co̱'³: ¿'A² lǿn³na'³ 'e³ rɨ²³tøø³te'²³ 'nee'²³ yʉʉ'³¹ güii³? 'A²³jia'³ jmɨ́ɨ², ¿mɨ³naa'³¹? Rɨ²³cu²³dxe'n³te'²³ 'nee'²³ je² nee'²³² dsɨ́² dsa³ 'i³ 'a²³jia'³ ca³jmóo² ca³dsaan³². ");
INSERT INTO cnlNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Nuu³ júu² quián²³ dsa³ 'i³ nuu³ júu² quien³²na'³. 'E³ quie'²³ tʉn³² jné² dsa³ 'i³ tʉn³² 'nee'²³. Tʉn³² Dios 'i³ ca²³xíin²³ jné² dsa³ 'i³ tʉn³² jné². ―La'³ cu³lø³¹ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³² 'i³ tú̱²³ lu²³guién³ dsɨ³² guiáan³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bi²³ jɨn³ dsɨ́² dsa³ 'i³ tú̱²³ lu²³guién³ dsɨ³² guiáan³ ma²ca¹dxi¹guiin³² co̱'³. 'E³ jo̱³ ca²³jua'³te'²³: ―Juii³ra'³¹, cu³xi³ espíritus quien³² mɨ²³sɨ²³quiʉ'² nuu³ júu² quiee³²ra'³¹ 'e³ juaa'³ra'³¹ rɨ³løn³¹na'³¹ dsa³ quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús ca²³sɨ'²³ dsa³ 'í³: ―Ca²³maan²³ 'e³ ca²³bǿn³ jí̱i̱n² yʉʉ'³¹ güii³, ca²³tø'n³ 'uǿ²³ Satanás 'e³ la²³ ca²³'íi²ra'³ júu², ¿mɨ³naa'³¹? La²³ lǿ² sɨ³te'n³ i²³'ñeen³¹ ca²³tø'n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mɨ³cuǿøn²³na²³ 'nee'²³ júu² 'uee'n³ 'e³ 'a²³'e³ xa³ rɨ²³li'²³ juø'² rɨ²³jme'²³ 'nee'²³ 'i³ sǿn²³, 'i³ xen³ la²³ xen³ 'luu³, 'i³ xen³ la²³ xen³ 'ñʉ́². Mɨ³cuǿøn²³na²³ 'nee'²³ júu² 'uee'n³ 'e³ la²³ 'a²³jia'³ rɨ²³li'²³ juø'² ju²³bíi²³ quiee'³² 'ñée² 'i³ hui²³dsɨ́ɨn² ñin³² jne². ");
INSERT INTO cnlNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","'E³ quie'²³ 'a²³la³ jo̱³ 'e³ nuu³ espíritus quien³² mɨ²³sɨ²³quiʉ'² júu² quien³²na'³ 'e³ 'ne'² rɨ²jmée²ra'³ 'e³ jɨn³ 'óo²ra'³. Rɨ²jmée²ra'³ 'e³ jɨn³ 'óo²ra'³ 'e³ juo'³ra'³ mɨ³ta̱a̱n²³na'³ ji³ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Xe̱'n² jmɨ́ɨ² ca²³jmée³ Espíritu Gáan³ quien³² Dios 'e³ bi²³ ma²³'nee³ ca²³la²³jɨn³ dsɨ́² Jesús. 'E³ jo̱³ ca²³jua'³: ―Mɨ²'áan²nu³, Ñu'n², juii² yʉʉ'³¹ güii³ quia̱'² juii² mɨ³¹güii³ la³. Qui² 'a²³jia'³ ca²³cuǿn² júu² 'e³ ta³jmoo³² 'i'²³ 'e³ jmii'³¹ lǿ² u²³juø'²³ 'e³ jmeen²³ dsa³ 'i³ bi²³ dsoo²³ dsɨ́² quia̱'² dsa³ 'i³ bi²³ tɨn³. 'E³ quie'²³ ca²³cuǿn² júu² 'e³ ta³jmoo³² 'i'²³ dsa³ 'i³ xen³ la²³ xen³ xi³yu̱u̱n³. Qui² la'³ cu³lø³¹ 'e³ 'naan³ 'uǿøn²nu³ 'e³ rɨ²³lí³, Ñu'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Ñu'n²³ ca²³dxá³ guaan²³ 'e³ rɨ²jmeen²³² cua̱a̱n²tu² la²³jɨ³. Jø̱n³ Ñu'n²³ hua² 'i³ ñi³² 'e³ 'i̱i̱² sɨɨ'³¹ jné² Jo̱o̱³¹. 'A²³'i̱³ xen³ jia'³ cɨ'²³ 'i³ ñi³². 'E³ quie'²³ la'³, maan²³ 'e³ 'i̱i̱² sɨɨ'³¹ Ñu'n²³ jø̱n³ jné² 'i³ rɨ³løn³¹na¹ Jo̱o̱³¹ quia̱'n²³²na¹ te³ 'i̱i̱² sɨɨ'³¹ 'i³ 'náan²³ rɨ²mi³dsaan³¹na¹ dsɨ́². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","'E³ quie'²³ jo̱³ ca²³ji̱i̱n²³ Jesús. Ca²³lʉ́³ co̱³quie'² quia̱'² dsa³ quien³². Ca²³jua'³: ―Bi²³ dxʉ́²³ quién²na'³ 'nee'²³ 'e³ joo³²ra'³ la²³jɨ³ 'e³ joo³²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Rɨ²juøøn³¹na¹ 'nee'²³ 'e³ juɨ́ɨn²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² quia̱'² juɨ́ɨn²³ reyes 'i³ 'née²³ rɨ²³ñí² la²³jɨ³ 'e³ joo³²ra'³ 'u² cu²ru'³ ca²³cɨ̱'n²te'²³ 'e³ rɨ²³jóo²te'²³. 'E³ quie'²³ 'a²³jia'³ ca²³cɨ̱'n²te'²³. 'Née²³te'²³ 'e³ rɨ²³núu²³te'²³ la²³jɨ³ 'e³ nuu³ra'³ 'u² cu²ru'³ ca²³cɨ̱'n²te'²³ 'e³ rɨ²³núu²³te'²³. 'E³ quie'²³ 'a²³jia'³ ca²³cɨ̱'n²te'²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","'E³ quie'²³ jo̱³ ca²³naa'n²³ jø̱n³ dsa³ 'e²³ ley. Qui² 'née²³ 'e³ rɨ²³dsóo²³ dsɨ́² xi² ca³dsaan³² rɨ²³jmée²³ júu² Jesús, xi² 'a²³jia'³ ca³dsaan³². 'E³ jo̱³ ca²³jua'³: ―Dsa³ 'e²³, ¿jmii'³¹ 'ne'² rɨ²jmeen²³² 'e³ la²³ li²³røøn²³na²³ 'e³ rɨ²³ji̱i̱'n²³na²³ ca³cuaa³? ");
INSERT INTO cnlNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'e²³ ley: ―¿Jmii'³¹ cu³lø³¹ to̱o̱²³ ley 'e³ joo²³²ra²? ¿Jmii'³¹ cu³lø³¹ to̱o̱²³ ji³ 'e³ 'i³ra², lǿn³nu³? ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","'E³ jo̱³ ca²³jua'³ dsa³ 'e²³ ley: ―“'Ne'² li²³'náan²³na'³ Dios Juii³ra'³ 'e³ dxaa'n³¹ 'óo²ra'³. Jø̱n³ Dios 'nɨɨ'n³¹ 'ne'² 'e³ nee² 'óo²ra'³. 'Ne'² li²³'náan²³na'³ la²³jɨ³ ju²³bíi²³ 'e³ xa³ quién²na'³. 'Ne'² li²³'náan²³na'³ la²³jɨ³ sú̱n² 'i'²³ 'e³ jmee³ra'³. Co̱'³ cɨ'²³ 'ne'² li²³'náan²³na'³ uu'n²na'³ 'e³ la²³'nɨɨ'n³¹ 'e³ 'náan²³na'³ miin²³na'³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'e²³ ley: ―Bi²³ dxʉ́²³ 'e³ la²³ lǿ² mɨ³jméen² júu². La'³ cu³lø³¹ 'ne'² rɨ²jméen² jo̱o̱²³na²³. Jo̱³ hua² rɨ³ji̱'n²nu³ ca³quie̱e̱². ");
INSERT INTO cnlNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","'E³ quie'²³ 'née²³ dsa³ 'e²³ ley 'e³ rɨ²³lǿn³ dsa³ 'e³ bi²³ dxʉ́²³ jmee²³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―¿'I̱i̱² sɨɨ'³¹ 'ǿn²³nu³ 'i³ juø'n³ uu'n²na²? ");
INSERT INTO cnlNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","'E³ jo̱³ ca²³jua'³ Jesús: ―Ŋóo² juɨɨ³ Jericó jø̱n³ dsa³ 'i³ naan³ juɨɨ³ Jerusalén. Ca²³jí̱i̱n³ dsa³ 'i̱i̱³ dxi²jui³¹ dsa³ 'í³. Sø̱'n²te'²³ dsa³ 'í³. Ca²³'í̱i̱²³te'²³ cuo̱o̱³ ca³ti³² quia̱'² la²³jɨ³ 'e³ quie̱³. Bi²³ ca²³cuǿ³te'²³ quie'². 'E³ quie'²³ jo̱³ ca²³cuɨ̱́ɨ̱²te'²³. Ca³juɨ² cɨ² rɨ³ji̱'²³ dsa³ 'í³ ca²³tʉ́n²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ca²³tɨ́³ 'e³ ca²³ŋɨ́n³ jui³¹ jo̱³ jø̱n³ jmii³ dsa³. 'E³ la²³ ŋǿn² dsa³ 'i³ ca²³cuǿ³te'²³ quie'², 'e³ quie'²³ jo̱³ ca²³bøø²³ coo³¹ je² ra̱a̱n²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","La²³ mɨ³'mɨ́ɨ³ la'³ ca²³ŋɨ́n³ jø̱n³ dsa³ 'i³ jmee²³ ta² ñʉ'²³ 'ñʉ́² gáan³. Levita sɨ'²³te'²³ dsa³ 'i³ jmoo³² ta² jo̱³. Ŋǿn² dsa³ 'i³ ca²³cuǿ³te'²³ quie'². 'E³ quie'²³ la'³, ca²³bøø²³ coo³¹ je² ra̱a̱n²³ dsa³ 'i³ ca²³cuǿ³te'²³ quie'² dsa³ 'í³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ca²³tɨ́³ ca²³ŋɨ́n³ jia'³ cɨ'²³ co̱'³, jø̱n³ dsa³ Samaria. Ca²³lǿn²³ mɨ³lén² je² ra̱a̱n²³ dsa³ 'i³ ca²³cuǿ³te'²³ quie'². Ma²ŋøn³¹ dsa³ 'í³, bi²³ ca²³la²³cuu'²³ dsɨ́². ");
INSERT INTO cnlNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ca²³dxóo² caan²³. Ca²³to'²³ noo²³² quia̱'² jmɨɨ'³¹ mɨ²jø'² vino je² lø³² quie'². 'E³ quie'²³ jo̱³ ca²³láa² 'mɨɨ'³ je² lø³². Ca²³xáan² dsa³ 'i³ dsoo'²³² ñi'² quiee'³² roo'³² quien³². Ca²³jøn²³ dsa³ 'í³ 'ñʉ́² je² cuø²³te'²³ 'e³ guɨɨn³ dsa³. Núu²³ ca²³mi²³quin³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","La²³ mɨ³dxóo³ la'³ 'née²³ rɨ²³dsóo² co̱'³ dsa³ Samaria. 'E³ jo̱³ ca²³dxi³ tú̱²³ cuu² quiee'³². Ca²³cuǿø²³ juii² 'ñʉ́². Ca²³jua'³: “¿'A² rɨ²jméen² co̱o̱³ mɨ²'áa² 'e³ rɨ²mi³quin²³cɨ²nu³ dsa³ la³ quiée²ra²? Xi³nu³ ñúun³ cɨ² rɨ²³sɨ²³dsɨn³²nu³, rɨ²dxaan²³na²³ cuu² quien³²nu³ mɨ³rɨ³güe'n²³na²³ co̱'³.” La'³ ca²³jua'³ dsa³ Samaria. Ca²³sɨ'²³ juii² 'ñʉ́² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'e²³ ley: ―¿'I̱i̱² sɨɨ'³¹ uu'n² dsa³ 'i³ sø̱'n²te'²³, lǿn³nu³? ");
INSERT INTO cnlNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","'E³ jo̱³ ca²³jua'³ dsa³ 'e²³ ley: ―Dsa³ 'i³ ca²³la²³cuu'²³ dsɨ́² quia̱'² dsa³ 'i³ sø̱'n²te'²³, 'i³ 'í³ hua² 'i³ rɨ³løn³¹ uu'n². 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'e²³ ley: ―Guø'n³ jo̱o̱²³na²³. Cu³jmee² 'uǿøn²nu³ 'e³ la²³ ca²³jmée³ 'ñée² dsa³ 'i³ ca²³la²³cuu'²³ dsɨ́² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","'E³ quie'²³ jo̱³ ca²³ta'n²³te'²³ jui³¹ co̱'³. Ca²³dxóo² Jesús jia'³ cɨ'²³ juɨɨ³. Núu²³ xen³ jø̱n³ mɨ́³ 'i³ xi̱i̱n³ Marta 'i³ ca²³tøø³ Jesús xi²ñʉ'¹ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Xen³ jó̱o̱² Marta 'i³ xi̱i̱n³ Ma³rii³¹ 'i³ ca²³gua³ 'uǿ²³ xi²ñi² Jesús. Qui² 'née²³ rɨ²³núu²³ júu² 'e³ 'e²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","'E³ quie'²³ bi²³ dxi³quié̱n² dxi³ñúun² Marta la²³'nɨɨ'n³¹ ñu'n² ta² 'e³ xa³ quie'² 'e³ jua'³ mi³tɨ́ɨ²³ la²³jɨ³ 'e³ 'ne'² quie'² Jesús. 'E³ jo̱³ ŋóo² Marta je² jen³¹ Jesús. Ca²³jua'³: ―Juiin²³, ¿'a² lǿn³nu³ 'e³ røø³ 'íi² 'e³ jmeen²³ 'ñáan²³ la²³jɨ³ ta² 'e³ xa³ quiée²ra'³¹? Qui² 'a²³jia'³ jmee²³ ja̱a̱n³². Rɨ²juɨɨ'n³¹ ja̱a̱n³² 'e³ rɨ²³jmée²³ co̱²juø'¹ quián²³. ―La'³ ca²³jua'³ Marta. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Marta: ―Marta, Marta, bi²³ ñúun³ la²³jɨ³ 'e³ cuøøn³² 'uǿøn²nu³ u²³ŋɨ́³ dsɨ́ɨ². 'E³ jo̱³ hua² bi²³ dxi³quié̱n² dxi³ñúun²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","'E³ quie'²³ xa³ co̱o̱³ 'iin³² hua² 'e³ 'ne'² rɨ²jmee²ra² ca³quie̱e̱². Bi²³ dxʉ́²³ 'e³ la²³ lǿn³ Ma³rii³¹ 'e³ rɨ²³jmée²³. 'A²³'i̱³ xen³ 'i³ rɨ²³lí³ juø'² rɨ²³jniin²³ 'e³ la²³ lǿ² jmee²³ Ma³rii³¹. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ca²³tɨ́³ jmɨ́ɨ² 'e³ xa³ je² 'iún² Jesús lʉ²³ quia̱'² Dios Jmii³. Ma²ca¹líi¹ ca²³lʉ́³ quia̱'² Dios, ca²³jua'³ jø̱n³ dsa³ quien³². Ca²³sɨ'²³ Jesús: ―Juii³ra'³¹, ¿'a² rɨ²jméen² co̱o̱³ mɨ²'áa² rɨ²'een³¹nu³ jnee'³¹ 'e³ jmii'³¹ rɨ²lʉ²ra'³¹ quia̱'n²na'³¹ Dios, 'e³ la²³ ca²³jmée³ Juan, 'e³ ca²³'ée²³ dsa³ quien³²? ―La'³ ca²³jua'³ jø̱n³ dsa³ quien³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―La²³la³ cu³lø³¹ rɨ²juo'²ra'³ 'e³ la²³ lʉ́²ra'³ quia̱'n²na'³ Dios: Dios Ñʉ'²ra'³¹ 'i³ jen³¹ yʉʉ'³¹ güii³, cu²li³quii²³ dsa³ 'e³ jmii'³¹ 'nɨɨ'n³¹ rɨ³jɨ́n²nu³. Cu²lín³nu³ juii² la²³jɨn³ dsa³. Cu²lí³ mɨ³¹güii³ la³ 'e³ la²³ 'naan³ 'uǿøn²nu³ 'e³ rɨ²³lí³, 'e³ la²³ sɨ³lí³ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cuøø² jnee'³¹ 'ɨ́² 'e³ 'ne'² rɨ²quie²ra'³¹ cɨ'³ la²³ co̱o̱³ jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Rɨ²jméen² u²³juee'³ dsɨɨ³² rɨ²mǿn¹nu³ jnee'³¹. Rɨ²yuun²³²nu³ dsoo² quiee³²ra'³¹. Qui² jnee'³¹ jmee³ra'³¹ u²³juee'³ dsɨɨ³² nen²³²na'³¹ la²³jɨn³ dsa³ 'i³ jme'²³ jnee'³¹. 'A²³ rɨ³jmeen³ 'e³ rɨ²ŋɨ²ra'³¹ je² juø'² rɨ²³jáan²³ dsɨ³ra'³¹ mɨ²³sɨ²³quiʉ'². 'A²³ rɨ³cuøn³ júu² 'e³ rɨ²jmee²ra'³¹ 'e³ 'a²³jia'³ dxʉ́²³. La²³nɨ³ cu³lø³¹ rɨ²lʉ́²ra'³ quia̱'n²na'³ Dios. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ca²³lʉ́³ co̱'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―La²³ cu²ru'³ xen³ jø̱n³ 'nee'²³ rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ cu³guín²³na'³ quie'² jø̱n³ dsa³ 'i³ bi²³ dxʉ́²³ lʉ́²ra'³ quia̱'n²na'³. La²³ca̱a̱n³ dxoo'³¹ 'uøø²³ 'e³ rɨ²³dxi²³guín²³na'³ quie'². Rɨ²juɨɨ'³¹ra'³ dsa³ 'í³: “¿'A² rɨ²jméen² co̱o̱³ mɨ²'áa² rɨ²cɨ'n²³nu³ tú̱²³ 'nɨ³ 'ɨ²³juɨ² quiée²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Qui² xen³ jø̱n³ dsa³ 'i³ dxʉ́²³ lʉn²³ quia̱'n²³²na¹ 'i³ mɨ³cuaa'n²³ quián²³. 'E³ quie'²³ 'a²³'e³ xa³ quián²³ 'e³ rɨ²cuǿøn¹ 'e³ rɨ²³e'².” ");
INSERT INTO cnlNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿Jmii'³¹ xi³nu³ rɨ²³jua'³ juii² 'ñʉ́²?: “'A²³ cuøø³² jné² u²³ŋɨ́³ dsɨ́ɨ². Mɨ³jnɨn²³ 'oo'² 'ñʉ³¹. Mɨ³a̱a̱n²³ quia̱'n²³²na¹ xi³yu̱u̱n³ quién²³na²³. 'A²³jia'³ rɨ²³lí³ juø'² rɨ²naa'n²³na²³ 'e³ rɨ²cuǿøn¹na²³ 'nʉ³, ¿mɨ³naa'³¹?” ");
INSERT INTO cnlNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nee'²³: 'A²³jia'³ 'née²³ rɨ²³naa'n²³ 'e³ rɨ²³cuǿø²³ 'nee'²³ 'ɨ²³juɨ² dsa³ 'í³, juø'n³ quie'²³ bi²³ dxʉ́²³ lʉ́²ra'³ quia̱'n²na'³. 'E³ quie'²³ rɨ²³naa'n²³ quie'²³ la²³bii²³ xi³nu³ rɨ²tǿ²quie²³ra'³ la'³. Rɨ²³cuǿø²³ 'nee'²³ te³ 'ee² 'noo³¹ 'e³ 'ne'² quién²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Rɨ²juøøn³¹na¹ 'nee'²³: Rɨ²ŋɨɨ'³¹ra'³ Dios. Jo̱³ hua² rɨ²³cuǿø²³ 'nee'²³. Rɨ²'no'²ra'³. Jo̱³ hua² rɨ²³dxe'n³na'³. Rɨ²tǿ²ra'³ 'oo'². Jo̱³ hua² rɨ²³né²te'²³ quién²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Qui² sɨ³'ióo²³ la²³jɨn³ dsa³ 'i³ ŋɨɨ²³. Sɨ³dxoo'²³ dsa³ 'i³ 'no'²³. 'E³ quie'²³ rɨ²³né²te'²³ 'oo'² je² tø³² dsa³ 'i³ tø³². ");
INSERT INTO cnlNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’'A²³'i̱³ xen³ 'nee'²³ 'i³ rɨ³løn³¹ jmii³ xii'³ 'i³ rɨ²³cuǿø²³ cú̱u̱² jo̱o̱³¹ xi³nu³ ŋɨɨ²³ xii'³ 'ɨ²³juɨ², ¿mɨ³naa'³¹? 'A²³'i̱³ xen³ 'i³ rɨ²³cuǿn² 'luu³ xi³nu³ ŋɨɨn³² xii'³ 'moo'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","'A²³'i̱³ xen³ 'i³ rɨ²³cuǿn² 'ñʉ́² xi³nu³ ŋɨɨ²³ xii'³ mɨ³¹jlɨɨ³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Móo³ra'³ 'nee'²³ 'i³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³ 'e³ jmii'³¹ rɨ²cuøø³¹ra'³ jo̱o̱³ra'³ la²³jɨ³ 'e³ dxʉ́²³. 'E³ jo̱³ bi²³ cɨ² ma²³'nee³ dxʉ́²³ rɨ²³jmée²³ quién²na'³ Ñʉ'²ra'³ 'i³ jen³¹ yʉʉ'³¹ güii³. Qui² rɨ²³cuǿn² Espíritu Gáan³, rɨ²³cuǿn²³ dsa³ 'i³ ŋɨɨn³². ");
INSERT INTO cnlNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ca²³tɨ́³ 'e³ ca²³dxin³ Jesús espíritu quien³² mɨ²³sɨ²³quiʉ'² 'i³ jmee²³ 'e³ caan²³² jø̱n³ dsa³. Ma²ca¹bǿn³ espíritu 'í³, lǿ²³ juø'² ca²³lʉ́³ dsa³ 'i³ caan²³² xe̱'n². Bi²³ juø'²³ ca²³ti²³cø̱n³¹ dsa³ 'i³ ŋó²³ 'e³ ca²³lǿ²³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Xen³ dsa³ 'i³ ca²³jua'³: ―Ju²³bíi²³ quiee'³² Beelzebú, juii² espíritus quien³² mɨ²³sɨ²³quiʉ'², 'e³ sɨ³lí³ juø'² 'uøøn³ espíritus quien³² mɨ²³sɨ²³quiʉ'² Jesús. ―La'³ ca²³jua'³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Xen³ cɨ² dsa³ 'i³ 'née²³ rɨ²³dsóo²³ dsɨ́² 'e³ jmii'³¹ cu³løn³¹ Jesús. 'E³ jo̱³ ca²³ŋɨ'²³te'²³ 'e³ rɨ²³sɨ'²³ Dios 'e³ rɨ²³jmée²³ u²³juø'²³ 'e³ jmee²³ lii²³ xi² jmee²³ ta² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","'E³ quie'²³ ñi³² 'ñée² 'e³ jmii'³¹ lǿ² dsɨ́²te'²³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ―Rɨ²³yáan²³ juɨɨ³ je² røøn³ jø̱n³ rey xi³nu³ rɨ²³juín² dsa³ júu² quiee'³²te'²³. Rɨ²³gua'²³ co̱o̱³ sɨ́ɨn² dsa³ xi³nu³ rɨ²³juín²te'²³ júu² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","'E³ quie'²³ la'³ cu³lø³¹ quie'² Satanás co̱'³. 'U² cu²ru'³ mɨ³juín² júu² quiee'³², rɨ²³gua'²³ júu² 'uee'n³ quiee'³² cu²ru'³ la'³, ¿mɨ³naa'³¹? Qui² juo'³ra'³ 'e³ ju²³bíi²³ quiee'³² Beelzebú 'e³ sɨ³lí³ juø'² 'uøøn²³²na¹ espíritus quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","'U² cu²ru'³ la'³ cu³lø³¹ 'e³ 'uøøn²³²na¹ espíritus quien³² mɨ²³sɨ²³quiʉ'², ¿'i̱i̱² sɨɨ'³¹ 'i³ cuø²³ ju²³bíi²³ 'e³ sɨ³lí³ juø'² 'uøøn³ espíritus quien³² mɨ²³sɨ²³quiʉ'² te'²³ dsa³ uu'n²na'³? 'E³ jo̱³ miin²³ dsa³ uu'n²na'³ jmoo³² lii²³ 'e³ 'a²³jia'³ 'e̱'n³ júu² 'e³ lʉ́²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","'E³ quie'²³ ju²³bíi²³ quiee'³² Dios 'e³ sɨ³lí³ juø'² 'uøøn²³²na¹ espíritus quien³² mɨ²³sɨ²³quiʉ'². 'E³ jo̱³ mɨ³la³lii²³ 'e³ mɨ³guá²³ jee²³² quien³²na'³ 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’'A²³'e³ xa³ 'e³ rɨ²³gua'²³ quie'² dsa³ 'i³ 'uee'n³, dsa³ 'i³ ñúun³ la²³jɨ³ 'e³ coo'³² 'e³ jua'³ 'aa³ dxʉ́²³ xi²ñʉ'¹ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","'E³ quie'²³ xen³ jø̱n³ 'i³ 'uee'n³ cɨ² bíi²³. Líi² te³ rɨ²³dxóo² 'ñée². Rɨ²³li'²³ 'ñée² jo̱o̱²³na²³. Rɨ²³je̱'n² la²³jɨ³ 'e³ coo'³² dsa³ 'e³ lǿn³ 'ñée² 'e³ rɨ²³li'²³ juø'² rɨ²³'áa²³ dxʉ́²³ xi²ñʉ'¹ quiee'³². 'E³ quie'²³ jo̱³ rɨ²³co̱o̱²³ la²³jɨ³ 'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Hui²³dsɨ́ɨn² quia̱'² jné² dsa³ 'i³ 'a²³jia'³ rɨ³løn³¹ co̱o̱³ júu² quia̱'² jné². Dsa³ 'i³ 'a²³jia'³ jmee²³ ta² 'e³ sɨ³cu'n²³ dsa³ quia̱'² jné² jmee²³ 'e³ sɨ³sáan²³ sɨ³jǿn²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Mɨ³rɨ³bǿn³ espíritu quien³² mɨ²³sɨ²³quiʉ'² 'i³ quie̱n³ dsa³, ŋɨ́³ 'ñée² espíritu je² bi²³ rɨ³quiʉ̱ʉ̱³. 'No'²³ je² rɨ²³gua³. 'E³ quie'²³ 'a²³jia'³ rɨ²³dxoo'²³. 'E³ jo̱³ jua'³ 'ñée²: “Ñe'n³²na²³ co̱'³ je² ca²³bǿn³na²³ ca³dxa³”. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","'E³ jo̱³ rɨ²³dxe'n² co̱'³. Qui² dsɨ́² dsa³ rɨ³lø³¹ 'é̱e̱² xi²ñʉ'¹ je² ca²³bǿn³. Ca²³'io'³te'²³. Bi²³ dxʉ́²³ ta'² née² la²³jɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","'E³ jo̱³ dsoo³² sɨ³tee³ guiáan²³ cɨ² uu'n² 'i³ bi²³ cɨ² 'a²³jia'³ dxún²³ la²³ cɨ'²³ 'ñée². Rɨ²³ta'n²³te'²³ dsɨ́² dsa³ 'í³. Núu²³ rɨ²³gua³te'²³. 'E³ jo̱³ bi²³ cɨ² la³dsɨɨ³² rɨ²³ji̱'²³ dsa³ 'í³ mɨ³rɨ³ta'n²³ 'i³ juɨ́ɨn²³ cɨ² la²³ cɨ'²³ ma²'ii³¹ rɨ²³bǿn³ 'i³ jø̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","'E³ la²³ ca²³jua'³ la'³ Jesús, ca²³lʉ́³ quiʉ̱ʉ̱³ jø̱n³ mɨ́³ 'i³ xi'n²³ jee²³² quiee'³² dsa³. Ca²³jua'³ ca²³sɨ'²³ Jesús: ―Bi²³ dxʉ́²³ quie'² mɨ́³ 'i³ cǿ̱n² 'nʉ³ ma²ca¹la¹huǿøn³nu³. Bi²³ dxʉ́²³ quie'² 'i³ ca²³tʉ'n² 'nʉ³ ma²pi'n³¹nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","'E³ quie'²³ ca²³jua'³ Jesús: ―Ca³quie̱e̱² bi²³ dxʉ́²³ quie'² dsa³ 'i³ nuu³ júu² quiee'³² Dios, 'i³ jmee²³ 'e³ la²³ lǿ². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","'E³ la²³ sɨ³li³juɨ́ɨn² quie'²³ dsa³ je² xi'n²³ Jesús, ca²³jua'³: ―Bi²³ ma²³'nee³ 'a²³jia'³ dxún²³ dsa³ 'i³ xen³ rɨ³nɨ²³. Qui² bi²³ 'née²³te'²³ rɨ²³jóo²te'²³ u²³juø'²³. 'E³ quie'²³ co̱o̱³ qui³ u²³juø'²³ rɨ²³jóo²te'²³, uu'n² u²³juø'²³ 'e³ ca²³ji̱'²³ Jonás. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","U²³juø'²³ 'e³ ca²³ji̱'²³ Jonás mɨ²jo̱³ ca²³jmée³ lii²³ quie'² dsa³ juɨɨ³ Nínive 'e³ jmii'³¹ 'nɨɨ'n³¹ 'uee'n³ Dios. 'E³ quie'²³ la'³, u²³juø'²³ 'e³ rɨ²³jí̱i̱n²³ jné² Jo̱o̱³¹ Dsa³ rɨ²³jmée²³ lii²³ quie'² dsa³ 'i³ xen³ rɨ³nɨ²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'uee'n³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²³dxá²³ Dios ta² quiee'³² dsa³, rɨ²³naa'n²³ mɨ́³ dxi² juɨɨ³ 'i³ røøn³ mɨ²jo̱³ juɨɨ³ 'e³ sɨ³cuaa'n²³ la²³ i²'uøø³². Rɨ²³jmée²³ lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ xa³ dsoo² quiee'³² dsa³ 'i³ xen³ rɨ³nɨ²³. Qui² naan³ 'ñée² mɨ́³ je² huɨ̱́ɨ̱³ ca²³dxóo² je² jen³¹ rey Salomón 'e³ jua'³ 'née²³ rɨ²³núu²³ júu² 'e³ lʉ²³. Qui² bi²³ ta³jmee²³ 'i'²³ Salomón. 'E³ quie'²³ gáan³ cɨ² la²³ Salomón 'e³ xa³ jee²³² quien³²na'³ rɨ³nɨ²³ 'e³ la²³ jen³¹na¹ quia̱'n²³²na¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²³dxá²³ Dios ta² quiee'³² dsa³, rɨ²³naa'n²³ dsa³ 'i³ xen³ juɨɨ³ Nínive mɨ²jaa²³². Rɨ²³jmóo² lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ xa³ dsoo² quiee'³² dsa³ 'i³ xen³ rɨ³nɨ²³. Qui² ca²³tʉ́² miin²³ mɨ²jaa²³² 'e³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³ ma²ca¹'ɨ́ɨ³ júu² Jonás. 'E³ quie'²³ gáan³ cɨ² la²³ cɨ'²³ júu² 'e³ ca²³lʉ́³ Jonás 'e³ xa³ jee²³² quien³²na'³ rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’'A²³jia'³ xe̱'n³² dsa³ ji³ 'é̱e̱² jmɨɨ³ 'e³ te³ rɨ²³'mé²³te'²³. 'A²³jia'³ rɨ²³'mé²³te'²³ ñʉ'²³ joo³¹ guóo². Dxa²³te'²³ ñi'² joo³¹ 'mo³ jɨ̱ɨ̱n²³². Qui² 'née²³te'²³ 'e³ jné³ ji³ mɨ³rɨ³ta'n²³ dsa³ xi²ñʉ'¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mɨ²ñí²ra² jmee²³ ta² 'e³ jné³ ji³. Xi³nu³ dxʉ́²³ quie'²³ mɨ²ñí²ra'³, bi²³ jné³ quién²na'³. 'E³ quie'²³ xi³nu³ 'a²³jia'³ ma²³ dxʉ́²³ mɨ²ñí²ra'³, bi²³ sɨ³lí³ li³'o̱o̱³ quién²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Rɨ³móo³ra'³. Qui² bi²³ juø'² rɨ²³lí³ 'e³ 'a²³jia'³ li²³jné³ quién²na'³ ji³ quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Xi³nu³ cuø²³ jmɨ́ɨ²³ ji³ quiee'³² Dios rɨ³ca̱'n²³ 'óo²ra'³, xi³nu³ 'a²³'e³ xa³ je² li³'o̱o̱³ quién²na'³, bi²³ jné³ quién²na'³ jo̱o̱²³. Jné³ la²³ jné³ je² cuø²³ jmɨ́ɨ²³ ji³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ma²ca¹líi¹ ca²³lʉ́³ la'³ Jesús, jø̱n³ dsa³ fariseo ca²³tøø³ 'e³ jua'³ 'née²³ 'e³ rɨ²³dsø'n² 'e³ sɨ³ee'³ quia̱'². 'Í² Jesús xi²ñʉ'¹ quiee'³² dsa³ 'í³. Ca²³gua³ coo³¹ mesa. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bi²³ juø'²³ ca²³jóo² dsa³ fariseo 'e³ 'a²³jia'³ ca²³u̱'² guoo³ Jesús 'e³ 'íi² rɨ²³e'². ");
INSERT INTO cnlNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","'E³ jo̱³ ca²³jua'³ Juii³ra². Ca²³sɨ'²³ dsa³ fariseo: ―'Nee'²³ dsa³ fariseo u̱u̱'³²ra'³ 'no² tazas quia̱'² 'no² huɨ̱́ɨ̱²³ 'e³ la²³ lǿ² tɨ³² 'i'²³ quien³²na'³. 'E³ quie'²³ la²³ xen³ tazas 'e³ 'lʉʉ'² 'e̱'³ xen³ ñʉ'²³ 'óo²ra'³. Qui² jmee³ra'³ 'i̱i̱³. Bi²³ ma²³'nee³ 'a²³jia'³ dxʉ́²³ jmee³ra'³. Jmø'n² 'e³ lø³² la'³ née² 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Bi²³ gøn³na'³! ¿'A² 'a²³jia'³ móo³ra'³ 'e³ jø̱n³ hua² 'i³ ca²³jmée³ 'e³ xa³ 'no² quia̱'² ñʉ'²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","'Ne'² rɨ²cuøø³¹ra'³ dsa³ taan³ 'e³ taa'² 'e̱'³ huɨ̱́ɨ̱²³ quien³²na'³. Jo̱³ hua² rɨ²³lí³ rɨ³jɨ́² ca³quie̱e̱² la²³jɨ³ 'e³ xa³ quién²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Bi²³ juɨɨ³² 'nee'²³, dsa³ fariseo! Jmee³ra'³ guiá²³ taa'² la²³jɨ³ 'oo³ quiee'³² mó² 'e³ xa³ quién²na'³ 'e³ xi̱i̱n³ me²³ji̱i̱'²³² quia̱'² ruda quia̱'² la²³jɨ³ me²jo̱'¹ co̱'³. Cuøø³²ra'³ Dios co̱o̱³ taa'² 'e³ jo̱³. 'E³ quie'²³ 'a²³jia'³ jmee³ra'³ quién²na'³ 'e³ rɨ²jmée²ra'³ ca³dsaan³², 'e³ li²³'náan²³na'³ Dios. 'E³ jo̱³ hua² 'ne'² rɨ²mi³quí̱i̱n²³na'³ 'u² 'e³ la²³ jmee³quie²³ra'³ 'e³ mɨ³'øn²³ xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Bi²³ juɨɨ³² 'nee'²³, dsa³ fariseo! Qui² 'noo³ra'³ 'e³ rɨ²ñí²ra'³ je² dxʉ́²³ cɨ² ñʉ'²³ 'ñʉ́² je² mi³gáan³ dsa³ Dios. 'Noo³ra'³ 'e³ rɨ²³cuǿ²³ dsa³ u²³juee'n³¹ quia̱'²te'²³ 'nee'²³ je² dxa²³ dsa³ 'moo'². ");
INSERT INTO cnlNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Bi²³ juɨɨ³² 'nee'²³, dsa³ 'e²³ ley quia̱'² dsa³ fariseo! Qui² te³ jmee³ra'³ guóo². Xen³ 'nee'²³ la²³ xen³ 'e̱e̱³ je² 'a²³jia'³ ca²³jmóo²te'²³ lii²³ je² rɨ³'aan²³ 'lɨ́ɨ³. Ŋɨ́³ dsa³ ñi'². Qui² 'a²³jia'³ ñi³²te'²³ jmii'³¹ lǿ² ñʉ'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","'E³ jo̱³ ca²³lʉ́³ jø̱n³ dsa³ 'e²³ ley. Ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³, bi²³ 'ñe'² mɨ³lʉ́n² mɨ³'en²³²nu³ jnee'³¹ co̱'³, ¿mɨ³naa'³¹? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","'E³ quie'²³ ca²³jua'³ Jesús: ―¡Bi²³ juɨɨ³² 'nee'²³, dsa³ 'e²³ ley co̱'³! Qui² cuøø³²ra'³ dsa³ láa² 'e³ 'a²³jia'³ rɨ²³o̱o̱'²³te'²³. 'E³ quie'²³ 'a²³jia'³ rɨ²jmée²ra'³ co̱²juø'¹ quie'² dsa³ 'i³ quie̱³ láa², cu³xi³ 'e³ rɨ²quiʉ̱ʉ̱'³¹ra'³ co̱o̱³ mɨɨ³¹ mɨ²xi¹guoo³²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Bi²³ juɨɨ³² 'nee'²³! Qui² jmee³ra'³ 'e̱e̱³ 'e³ rɨ³lø³¹ 'ioo'³ je² rɨ³'aan²³ 'lɨ́ɨ³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², juø'n³ quie'²³ yi²³uu'²ra'³ jaa²³² ca²³jŋɨ'n²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jmee³ra'³ lii²³ 'e³ jmee³ra'³ co̱o̱³ júu² quia̱'n²na'³ yi²³uu'²ra'³ jaa²³² 'e³ jmee'n²³na'³ 'e̱e̱³ je² rɨ³'aan²³ 'lɨ́ɨ³ 'í³. Qui² yi²³uu'²ra'³ jaa²³² hua² 'i³ ca²³jŋɨ'n²³te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². 'E³ quie'²³ 'nee'²³ jmee³ra'³ 'e̱e̱³ je² rɨ³'aan²³ 'lɨ́ɨ³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Bi²³ ñi³² Dios. 'E³ jo̱³ hua² ca²³jua'³: “Rɨ²sɨɨn³¹na¹ quie'²te'²³ dsa³ 'i³ rɨ²³'ɨ́ɨ²³ júu² quián²³ quia̱'² dsa³ xiin²³ quién²³na²³. 'E³ quie'²³ xen³ 'i³ rɨ²³jŋɨ'n²³te'²³. Xen³ 'i³ rɨ²³jme'²³te'²³.” La'³ cu³lø³¹ ca²³jua'³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","'E³ jo̱³ rɨ²³jmée²³ Dios jñiin²³ dsa³ 'i³ xen³ rɨ³nɨ²³. Qui² mɨ³cuaa'n²³ guoo³te'²³ la²³jɨ³ dsoo² 'e³ jŋɨ'n²³te'²³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios cɨ'²³ ma²ca¹la¹xa³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ca²³la²³láa²³ ma²ca¹jŋɨ'n¹te'²³ Abel. Je² dsøn³ ca²³jŋɨ'n²³te'²³ Zacarías coo³¹ có̱o̱²³ je² co³jee²³² la²³ quia̱'² je² bi²³ 'mɨ'n²³. Rɨ²juøøn³¹na¹ 'nee'²³: Mɨ³cuaa'n²³ guoo³ miin²³ dsa³ 'i³ xen³ rɨ³nɨ²³ dsoo² 'e³ jŋɨ'n²³te'²³ dsa³ quien³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Bi²³ juɨɨ³² 'nee'²³, dsa³ 'e²³ ley! Qui² mɨ³'mé²ra'³ llave 'e³ sɨ³né³ je² li²³tɨn³ dsa³ ca³quie̱e̱². 'A²³jia'³ rɨ²cuǿ²ra'³ júu² 'e³ rɨ²³ta'n²³ dsa³ 'i³ 'née²³ li²³tɨn³. 'E³ quie'²³ cu³xi³ miin²³na'³ 'a²³jia'³ jmɨ́ɨ² 'noo³ra'³ 'e³ rɨ²taa'n³²na'³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma²ca¹jua'³ la'³, bi²³ ca²³ti̱'n³ dsa³ 'e²³ ley quia̱'² dsa³ fariseo ñin³² Jesús. Bi²³ ñúun³ la²³jɨ³ 'e³ ca²³ŋɨ'²³te'²³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Qui² 'née²³te'²³ 'e³ rɨ²³jáan²³te'²³ júu² quiee'³² 'e³ la²³ li²³xa³ jui³¹ 'e³ rɨ²³mi²³sa³te'²³ dsoo² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","'E³ la²³ ca²³lǿ²³ la'³, bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³ŋɨɨ'n²³. Ca²³'éen² la²³ cɨ² uu'n²te'²³ la²³'nɨɨ'n³¹ juɨ́ɨn²³te'²³ ca²³ŋɨɨ'n²³te'²³. Ca²³lʉ́³ Jesús quia̱'² dsa³ quien³² jee²³² je² rɨ³ŋɨɨn³¹ dsa³. Ca²³jua'³: ―'A²³ rɨ³jmee³ra'³ guóo² la²³ jmoo³² dsa³ fariseo. La²³ xen³ xoo'³¹ 'ɨ²³juɨ² xen³ tɨ³² 'i'²³ quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","'E³ cɨ² rɨ²³dsóo²³ dsɨ́² dsa³ la²³jɨ³ 'e³ 'a²³jia'³ dsoo²³ dsɨ́²te'²³ rɨ³nɨ²³. 'E³ cɨ² rɨ²³ñí² dsa³ la²³jɨ³ 'e³ rɨ³'mo² rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Qui² la²³jɨ³ 'e³ mɨ³lʉ́²ra'³ je² li³'o̱o̱³ rɨ²³núu²³ dsa³ je² jné³. La²³jɨ³ 'e³ mɨ³lʉ́²ra'³ u²³láa² ca³jné³ rɨ²³lʉ́²³ quiʉ̱ʉ̱³ dsa³ je² nuu³ la²³jɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Jné² rɨ²juøøn³¹na¹ 'nee'²³ 'i³ bi²³ dxʉ́²³ lʉn²³ quia̱'n²³²na¹: 'A²³jia'³ 'ne'² li²³'ñaa'n²³na'³ dsa³ 'i³ te³ sɨ³lí³ juø'² jŋɨ'n²³ 'nɨɨ'n³¹ jmɨ² ŋu² dsa³. Qui² mɨ³rɨ³lii³² 'e³ mɨ³jŋɨ'n²³te'²³ jmɨ² ŋu² dsa³, 'a²³'e³ ma²³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²³jmóo²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","'E³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ 'i̱i̱² sɨɨ'³¹ 'ne'² li²³'ñaa'n²³na'³ ca³quie̱e̱²: 'Ne'² li²³'ñaa'n²³na'³ Dios. Qui² 'a²³la³ 'nɨɨ'n³¹ 'e³ te³ rɨ²³li'²³ juø'² rɨ²³jŋɨ'n²³ jmɨ² ŋu² dsa³ 'ñée². Rɨ²³li'²³ juø'² rɨ²³juén² dsa³ guiáa²³ juɨ́ɨ². 'I³ 'í³ hua² 'i³ 'ne'² li²³'ñaa'n²³na'³ ca³quie̱e̱². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Sɨ³'nɨ́ɨn² jo̱o̱³¹ to̱³ pii'², 'ñén³ jo̱o̱³¹ to̱³ 'e³ tú̱²³ cu²laa'³ pii'², ¿mɨ³naa'³¹? Juø'n³ quie'²³ 'a²³jia'³ quí̱i̱n²³, cu³xi³ jø̱n³ 'a²³jia'³ jmɨ́ɨ² sɨ³'i̱'²³ dsɨ́² Dios 'e³ mi³quin³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ñi³² 'ñée² 'e³ jo'² mɨɨ'n²³ jñʉ³ dxí²ra'³ xa³. 'A²³ rɨ³juø'n²na'³ miin²³na'³. Qui² bi²³ cɨ² quí̱i̱n²³na'³ la²³ cɨ'²³ 'e³ juɨ́ɨn²³ jo̱o̱³¹ to̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Jné² rɨ²juøøn³¹na¹ 'nee'²³: Jné² Jo̱o̱³¹ Dsa³ rɨ²jmee'n³¹na¹ júu² je² nuu³ te'²³ ángeles quien³² Dios 'e³ cuiin²³na²³ la²³jɨn³ dsa³ 'i³ jmee'n³² júu² xi²ñi² dsa³ 'i³ jua'³ 'e³ cuiin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","'E³ quie'²³ rɨ²jmee'n³¹na¹ júu² je² nuu³ te'²³ ángeles quien³² Dios 'e³ 'a²³jia'³ cuiin²³na²³ la²³jɨn³ dsa³ 'i³ jmee'n³² júu² xi²ñi² dsa³ 'i³ jua'³ 'e³ 'a²³jia'³ cuiin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Sɨ³lí³ juø'² sɨ³yʉʉ³ dsoo² 'e³ lʉ²³ dsa³ 'e³ 'a²³jia'³ dxʉ́²³ 'en³² jné² Jo̱o̱³¹ Dsa³. 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² rɨ²³yʉʉ³ dsoo² 'e³ lʉ²³ dsa³ 'e³ 'a²³jia'³ dxʉ́²³ 'en³² Espíritu Gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’'E³ cɨ² rɨ²³sɨ²³jøn²³te'²³ 'nee'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. 'E³ cɨ² rɨ²³sɨ²³jøn²³te'²³ 'nee'²³ caan²³ dxi² juɨɨ³, caan²³ dsa³ 'i³ ta'n² ta². 'A²³jia'³ 'ne'² rɨ²xín³ rɨ²'ín³na'³ 'e³ jmii'³¹ cu³lø³¹ rɨ²jmee'n²³na'³ júu², 'e³ jmii'³¹ rɨ²lʉ́²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Qui² rɨ²³'ée²³ 'nee'²³ Espíritu Gáan³ quien³² Dios mɨ³rɨ³ti³ 'e³ 'ne'² quién²na'³. Rɨ²³'é²³ 'e³ jmii'³¹ 'ne'² rɨ²lʉ́²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ca²³jua'³ jø̱n³ dsa³ 'i³ xi'n²³ jee²³² quiee'³² dsa³. Ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³, ¿'a² rɨ²jméen² co̱o̱³ mɨ²'áa² rɨ²juɨɨ'n³¹ ja̱a̱n³² 'e³ rɨ²³cuǿø²³ jné² co̱o̱³ taa'² 'e³ ca²³cuaa'n³ 'lɨ² ñʉ'²ra'³¹ ma²ju̱n²³? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―¿'A² juø'² lǿn³nu³ 'e³ ca²³dxin³te'²³ jné² 'e³ rɨ²dxin²³² 'i'²³ jee²³² quien³²na'³, 'e³ rɨ²³lín³na²³ juez, 'e³ rɨ²juin²³²na¹ la²³jɨ³ 'e³ xa³ quie'² dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ca²³lʉ́³ co̱'³ Jesús. Ca²³jua'³: ―Xi²dsɨ́n³na'³. Qui² bi²³ juø'² li²³'iin²³ 'óo²ra'³ 'e³ xa³ quie'² uu'n²na'³. Qui² 'a²³la³ jo̱³ la²³jɨ³ 'e³ xa³ quie'² dsa³ 'e³ jmee²³ 'e³ bi²³ dxʉ́²³ jen³¹ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'E³ jo̱³ ca²³lʉ́³ Jesús co̱o̱³ júu² 'e³ jmee²³ lii²³ 'e³ jmii'³¹ lǿn²³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ xa³ quie'². Ca²³jua'³: ―La²³la³ cu³lø³¹ ca²³ji̱'²³ jø̱n³ dsa³ xoo³² co̱o̱³ taa'². Bi²³ ma²³'nee³ dxʉ́²³ ca²³'ɨ́ɨ³ la²³jɨ³ mɨɨ³¹ 'e³ rɨ³jne² 'uǿ²³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","'E³ jo̱³ bi²³ ca²³jmée³ 'i'²³ 'ñée². Ca²³lǿn³: “¿Jmii'³¹ rɨ²jmeen²³² cu²ne²ra²? Qui² 'a²³'e³ ma²³ xa³ je² joo'²³ rɨ²ta'n¹ la²³'nɨɨ'n³¹ ñu'n² 'e³ xa³ quián²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","'E³ jo̱³ ca²³lǿn³ 'ñée²: “La²³la³ cu³lø³¹ rɨ²jmeen²³² tu³sɨ'²³: Rɨ²yaan²³²na¹ la²³jɨ³ 'ñʉ́² 'e³ taa'² la²³jɨ³ 'e³ xa³ quián²³ rɨ³nɨ²³. Rɨ²jmeen²³² 'ñʉ́² 'e³ coo'² cɨ². Jo̱³ rɨ²³lí³ juø'² rɨ²ta'n¹ la²³jɨ³ sú̱n² mɨ³¹cuɨɨ³ quián²³ quia̱'² la²³jɨ³ sú̱n² láa² quián²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","La²³la³ cu³lø³¹ 'e³ rɨ²jmeen²³² mɨ³rɨ³'ien³ 'ñʉ́²: Bi²³ ñúun³ la²³jɨ³ 'e³ xa³ quián²³. Bi²³ ñúun³ ji̱i̱³ ñi³ 'e³ rɨ²³ti'n². 'E³ jo̱³ rɨ²tøøn³¹ dsɨn²³. 'E³ quie'²³ jo̱³ te³ rɨ²ñin²³² rɨ²uu'n²³² rɨ²ee'n²³² cɨ². Rɨ²jmeen²³² 'e³ jɨn³ dsɨn²³. La'³ ca²³lǿn³ dsa³ xoo³². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","'E³ quie'²³ ca²³lʉ́³ Dios. Ca²³sɨ'²³ dsa³ 'í³. Ca²³jua'³: “Bi²³ gøn³nu³. Qui² 'uøø²³ 'e³ rɨ³nɨ²³ 'e³ rɨ²³jú̱n³nu³. Ñúun³ la²³jɨ³ 'e³ mɨ³jméen² ji̱i̱³. ¿'I̱i̱² sɨɨ'³¹ li²³quie'² la²³jɨ³ 'e³ jo̱³ mɨ³rɨ³jú̱n³nu³?” La'³ ca²³jua'³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","La²³nɨ³ cu³lø³¹ sɨ³ji̱'²³ dsa³ 'i³ 'aa³ quie'² ñúun³ la²³jɨ³ 'e³ quí̱i̱n²³ 'e³ 'née²³ 'ñée². 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² 'aa³ la²³jɨ³ 'e³ jua'³ Dios 'e³ bi²³ cɨ² quí̱i̱n²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ca²³jua'³ co̱'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Jné² rɨ²juøøn³¹na¹ 'nee'²³: 'A²³ rɨ³cuøø³²ra'³ miin²³na'³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ jmii'³¹ li²³xa³ la²³jɨ³ 'e³ 'ne'² quién²na'³ 'e³ rɨ²cø'²ra'³ quia̱'² cuo̱o̱³²ra'³ 'e³ rɨ²cɨ'²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","'Ne'² rɨ²mi³jue'n²na'³ 'e³ rɨ³ji̱'n²quien²³na'³. Qui² bi²³ cɨ² 'ne'² la'³ la²³ cɨ'²³ la²³jɨ³ 'e³ rɨ²cø'²ra'³. 'Ne'² rɨ²mi³jue'n²na'³ 'e³ xa³ jmɨ² ŋú²ra'³. Qui² bi²³ cɨ² 'ne'² la'³ la²³ cɨ'²³ la²³jɨ³ 'e³ rɨ²cɨ'²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jmee²ra'³ 'i'²³ 'e³ jmii'³¹ sɨ³ji̱'²³ jo̱o̱³¹ bø³. 'A²³jia'³ jmoo³²te'²³ jmo². 'A²³ cɨ'²³ 'e³ jmoo³²te'²³ 'ó̱o̱²³. 'A²³'e³ xa³ 'ñʉ́² je² taa'² la²³jɨ³ 'e³ xa³ quie'²te'²³. 'A²³'e³ xa³ 'ui²dsoo²³² quiee'³²te'²³. 'E³ quie'²³ cuø²³ Dios 'e³ ee'³²te'²³. ¡Bi²³ cɨ² ma²³'nee³ quí̱i̱n²³ 'nee'²³ la²³ cɨ'²³ jo̱o̱³¹ to̱³! ");
INSERT INTO cnlNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","'A²³'i̱³ xen³ 'nee'²³ 'i³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ 'e³ cuaan²³cɨ²na'³ co̱o̱³ joo³¹ metro, juø'n³ jmi'³ 'nɨɨ'n³¹ 'e³ cuøø³²ra'³ miin²³na'³ u²³ŋɨ́³ dsɨ́ɨ², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","'A²³jia'³ jmɨ́ɨ² rɨ²³lí³ juø'² rɨ²jmée²ra'³ 'e³ cuaan²³cɨ²na'³ ca³juɨ². 'E³ jo̱³ bi²³ cɨ² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ 'e³ li²³xa³ la²³jɨ³ 'e³ 'ne'² quién²na'³ xi³nu³ bi²³ cuøø³²ra'³ miin²³na'³ u²³ŋɨ́³ dsɨ́ɨ², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Jmee²ra'³ 'i'²³ 'e³ jmii'³¹ lǿ² 'e³ sɨ³cua̱a̱n²³ mɨ²lí² 'e³ bi²³ lii'² 'e³ xa³ je² nuu³. 'A²³jia'³ jmoo³² ta². 'A²³ cɨ'²³ 'e³ ben³² mɨ³¹ñi³. 'E³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ bi²³ cɨ² lii'² cu³lø³¹ mɨ²lí² la²³ cɨ'²³ cuo̱o̱³ rey Salomón, juø'n³ quie'²³ bi²³ lii'², juø'n³ quie'²³ bi²³ ñúun³ la²³jɨ³ 'e³ xa³ quie'² mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jmee²³ ji̱i̱³ Dios 'e³ sɨ³li³xa³ mɨ²lii³¹ xoo'³¹ nuu³, juø'n³ quie'²³ ca²³ji̱i̱³ hua² xa³. 'É̱e̱² 'e³ jmee²³ ji̱i̱³ mɨ³¹cuo̱o̱³ 'e³ lii'². Jmee²³ quie'²³ ji̱i̱³, juø'n³ quie'²³ co̱o̱³ jmɨ́ɨ² rɨ³nɨ²³ hua² xa³. 'E³ quie'²³ mi²'aa³ rɨ²³jɨ̱́²³te'²³ too³ 'uɨ̱́ɨ̱². 'E³ quie'²³ bi²³ cɨ² rɨ²³jmée²³ ji̱i̱³ 'e³ rɨ²cɨ'²ra'³ 'nee'²³ 'i³ bi²³ ca³pii'² sɨ³táan³na'³ quia̱'n²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","'A²³ rɨ³cuøø³²ra'³ miin²³na'³ u²³ŋɨ́³ dsɨ́ɨ² 'e³ rɨ²'no'²ra'³ la²³jɨ³ 'e³ rɨ²'u'² rɨ²cø'²ra'³ jo̱o̱²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Qui² la'³ jmoo³² dsa³ mɨ³¹güii³: Mi³quí̱i̱n²³te'²³ la²³jɨ³ 'e³ lø³² la'³. 'E³ quie'²³ ñi³² Ñʉ'²ra'³ 'e³ 'ne'² quién²na'³ la²³jɨ³ 'e³ lø³² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bi²³ cɨ² dxʉ́²³ 'e³ rɨ²mi³quí̱i̱n²³na'³ 'e³ jmii'³¹ rɨ²³lín³ Dios juii³ra'³. Jo̱³ hua² rɨ²³cuǿø²³ 'nee'²³ la²³jɨ³ 'e³ 'ne'² quie'² jmɨ² ŋú²ra'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’'A²³ rɨ³juø'n²na'³ miin²³na'³, 'nee'²³ dsɨɨ³ joo³ quién²³na²³. 'A²³jia'³ juɨ́ɨn²³na'³. 'E³ quie'²³ bi²³ 'née²³ Ñʉ'²ra² 'e³ rɨ²³lín³ juii³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Líi² rɨ²'nɨ́ɨ²ra'³ 'e³ xa³ quién²na'³. Rɨ²cuøø³¹ra'³ cuu² dsa³ taan³. 'É̱e̱² 'e³ rɨ²jmée²ra'³ ji̱i̱³ mɨ³¹tuu'³ loo³ 'e³ 'a²³jia'³ li²³jaa²³² 'e³ rɨ²too'³¹ra'³ cuu². La²³nɨ³ cu³lø³¹ rɨ²'me²ra'³ yʉʉ'³¹ güii³ la²³jɨ³ 'e³ quí̱i̱n²³ ca³quie̱e̱² 'e³ 'a²³jia'³ rɨ²³gua'²³, je² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³co'² dsa³ 'i̱i̱³, je² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³yáan² jo'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Qui² nee² 'óo²ra'³ te³ jiaa'³¹ 'me³ra'³ la²³jɨ³ 'e³ quí̱i̱n²³ 'e³ 'oo³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’'Ne'² rɨ²mi³tɨ́ɨ²³ra'³ jo̱o̱²³na²³. Rɨ²jmée²ra'³ ji̱i̱³ 'e³ rɨ³so̱'² ji³ quién²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","'Ne'² rɨ²jmée²ra'³ la²³ jmoo³² mozos 'i³ je̱n³² juii² 'e³ jmii'³¹ rɨ²³ja'³ co̱'³ 'e³ mɨ³i²ñíin² je² mɨ³jén²³ dsa³ mɨ́³. Xi³nu³ rɨ³so̱'² quie'²³ ji³ quie'²te'²³, jo̱³ hua² rɨ²³lí³ juø'² rɨ²³né²te'²³ 'oo'² xe̱'n² mɨ³rɨ³güe'n²³ co̱'³ juii², mɨ³rɨ³té³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bi²³ dxʉ́²³ quie'² mozos 'i³ rɨ³ñín² quie'²³ xe̱'n² mɨ³rɨ³güe'n²³ juii². Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Rɨ²³'ñu'n²³ cuo̱o̱³ juii² 'e³ jua'³ mɨ³ rɨ²³tín²³ ta². Rɨ²³sɨ'²³ mozos 'e³ rɨ²³gua³te'²³ coo³¹ mesa. Rɨ²³dxá²³ 'ñée² 'e³ rɨ²³e'² mozos. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bi²³ dxʉ́²³ quie'² te'²³ mozos xi³nu³ rɨ³ñín² quie'²³ mɨ³rɨ³güe'n²³ juii², juø'n³ quie'²³ la²³ca̱a̱n³ dxoo'³¹ 'uøø²³ rɨ²³güe'n²³, juø'n³ quie'²³ 'a²³jia'³ ma²³ huǿø³ 'e³ li²³jné²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","'E³ quie'²³ la'³, 'ne'² rɨ²móo²ra'³ co̱'³: 'U² cu²ru'³ xi²dsɨ́n³ juii² xi²ñʉ'¹ 'e³ jmii'³¹ hora 'e³ rɨ²³güén³ dsa³ 'i̱i̱³, rɨ²³mi²³quii²³² 'u² cu²ru'³ la'³. 'A²³jia'³ rɨ²³cuǿ²³ júu² 'e³ rɨ²³'í³ xi²ñʉ'¹ dsa³ 'i̱i̱³ 'u² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","'E³ quie'²³ la'³ 'nee'²³ co̱'³: 'Ne'² xi²dsɨ́n³na'³. Qui² rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³ hora 'e³ lǿn³na'³ 'e³ 'a²³jia'³ mɨ³ rɨ²³güe'n²³na²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","'E³ jo̱³ ca²³jua'³ Peen²³²: ―Juii³ra'³¹, ¿'a² mɨ³lʉ́n² júu² nɨ³ 'e³ juø'n³ 'naan³ rɨ²nʉʉ²ra'³¹ 'nɨɨ'n³¹ jnee'³¹? ¿'A² mɨ³lʉ́n² 'e³ juø'n³ 'naan³ rɨ²³núu²³ la²³jɨn³ dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","'E³ jo̱³ ca²³jua'³ Juii³ra²: ―'Ne'² rɨ²núu²ra'³ la²³jɨn³ 'nee'²³ 'i³ xen³na'³ la²³ xen³ jø̱n³ mozo 'i³ bi²³ ta³jmee²³ 'i'²³, 'i³ jmee²³ 'e³ la²³ ca²³jua'³ juii² 'e³ 'ne'² rɨ²³jmée²³. Ca²³dxi³ 'i'²³ juii² 'e³ rɨ²³jmée²³ la²³jɨ³ ta² xi²ñʉ'¹ quiee'³², 'e³ rɨ²³jmée²³ ji̱i̱³ 'e³ rɨ²³e'² uu'n² mɨ³rɨ³ti³ hora 'e³ rɨ³lø³¹ 'i'²³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bi²³ dxʉ́²³ quie'² mozo 'í³ mɨ³rɨ³güe'n²³ co̱'³ juii², mɨ³rɨ³ñí³ juii² 'e³ jmee²³ mozos 'e³ la²³ ca²³dxi³ 'i'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Rɨ²³cuǿø²³ mozo quien³² la²³jɨ³ sú̱n² 'e³ xa³ quie'² 'ñée² 'e³ cu²lín³ cua̱a̱n²tu² mozo. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","'A²³jia'³ dxʉ́²³ quie'² mozo 'i³ lǿn³ 'e³ sɨ³li³'ɨɨn²³² juii², 'e³ co̱'³ xi² 'a²³jia'³ mɨ³ rɨ²³ja'³. 'E³ quie'²³ jo̱³ rɨ²³cuǿ²³ quie'² uu'n², dsóo²³ quia̱'² mɨ́³. Rɨ²³'ɨ̱'² rɨ²³e'²te'²³ ñúun³. Rɨ²³ŋøn³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Rɨ²³güe'n²³ co̱'³ juii² mozo jmɨ́ɨ² je² 'a²³jia'³ xi²dsɨ́n³, hora 'e³ 'a²³jia'³ ñi³² mozo. Bi²³ juø'²³ cu³lø³¹ rɨ²³jmée²³ mɨ³rɨ³jmee³ jñiin²³ mozo. Rɨ²³ji̱'²³ 'ñée² 'e³ la²³ sɨ³ji̱'²³ mozos 'i³ 'a²³jia'³ jmoo³² 'e³ la²³ dxi³ 'i'²³ juii². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Bi²³ ñúun³ taa'² rɨ²³jmín²te'²³ mozo 'i³ mɨ³núu³ 'e³ jmii'³¹ 'née²³ juii² 'e³ rɨ²³jmée²³, 'e³ quie'²³ 'a²³jia'³ mi³tɨ́ɨ²³ 'ñée² 'e³ rɨ²³jmée²³ 'e³ la²³ mɨ³dxi³ 'i'²³ juii². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","'E³ quie'²³ 'uøn³² cɨ² rɨ²³jmín²te'²³ mozo 'i³ dxi³ji̱i̱n³¹ 'e³ rɨ²³jmín²te'²³ 'e³ la²³ lǿ² mɨ³jmée³, 'e³ quie'²³ 'a²³jia'³ ñi³² 'e³ jmii'³¹ 'née²³ juii² 'e³ rɨ²³jmée²³. Ñúun³ ya̱'n³ rɨ²³jmée²³ dsa³ 'i³ mɨ³'ioo³² ñúun³. Bi²³ cɨ² dxʉ́²³ 'ne'² rɨ²³jmée²³ dsa³ 'í³ xi³nu³ ñúun³ 'e³ mɨ³cuǿ³ Dios quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Güén²³na²³ mɨ³¹güii³ 'e³ juø'n²³ rɨ²jmeen²³² 'e³ rɨ²³juín³ dsa³. Li²³bee'² 'e³ sɨ³juín³ dsa³ 'e³ la²³ sɨ³li³bee'² ji³ 'e³ sɨ³coo³ je² nuu³. ¡Bi²³ 'náan²³ 'u² cu²ru'³ mɨ³ rɨ²³dsóo² ji³ i²³la³ i²³nɨ³ xe̱'n² rɨ³nɨ²³! ");
INSERT INTO cnlNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Xa³ u²³ŋɨ́³ dsɨ́ɨ² bee'² 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jí̱i̱n²³. ¡Bi²³ ma²³'nee³ dxi³quié̱n²na²³ la²³huøø'n³¹ rɨ²³líi²! ");
INSERT INTO cnlNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿'A² juø'² lǿn³na'³ 'e³ güén²³na²³ mɨ³¹güii³ 'e³ rɨ²jmeen²³² 'e³ rɨ²³lʉ́²³ co̱o̱³ júu² la²³jɨn³ sú̱n² dsa³? Rɨ²juøøn³¹na¹ 'nee'²³: 'A²³la³ jo̱³, ¿mɨ³naa'³¹? 'E³ quie'²³ güén²³na²³ 'e³ juø'n²³ rɨ²jmeen²³² 'e³ rɨ²³juín³ dsa³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Qui² rɨ³nɨ²³ rɨ²³li²³láa²³ 'e³ rɨ²³juín³ 'ñén³ dsa³ 'i³ rɨ³løn³¹ la²³ co̱o̱³ sɨ́ɨn² dsa³. Aan³ dsa³ 'i³ 'a²³jia'³ rɨ²³jmóo² co̱o̱³ júu² quia̱'² áan²³. 'E³ quie'²³ la'³ áan²³ quia̱'² aan³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Rɨ²³juín³ dsa³ quia̱'² jo̱o̱³¹. Rɨ²³juín³ dsa³ quia̱'² jmii³. 'E³ quie'²³ la'³ mɨ́³ quia̱'² jo̱²³mɨɨ³¹. 'E³ quie'²³ la'³ quia̱'² xóo². 'E³ quie'²³ la'³ quia̱'² gui²³jó̱o̱². 'E³ quie'²³ la'³ quia̱'² xóo² dsóo²³ quien³². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ca²³lʉ́³ co̱'³ Jesús. Ca²³sɨ'²³ la²³jɨn³ dsa³. Ca²³jua'³: ―Mɨ³rɨ³joo³²ra'³ 'e³ sɨ³quie̱e̱'n²³ jníi² je² sɨ³dxen³ ñi'², bi²³ xe̱'n² juo'³ra'³: “Ten²³ rɨ²³jmée²³ jmɨ́²”. 'E³ quie'²³ sɨ³lí³ 'e³ la²³ juo'³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mɨ³rɨ³ro̱o̱²³ dxí³ tu³'o³ la²³ i²'uøø³², 'e³ quie'²³ juo'³ra'³ co̱'³: “Bi²³ rɨ²³jmée²³ 'ioo³”. 'E³ quie'²³ sɨ³lí³ 'e³ la²³ juo'³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Bi²³ jmee³ra'³ guóo²! Líi² te³ rɨ²joo³¹ra'³ 'e³ jmii'³¹ jmee²³ mɨ³¹güii³. 'E³ jo̱³ móo³ra'³ 'e³ jmii'³¹ rɨ²³jmée²³. ¿Jmii'³¹ lǿ² 'e³ 'a²³jia'³ móo³ra'³ jo̱o̱²³na²³ 'e³ jmii'³¹ 'née²³ rɨ²³jua'³ la²³jɨ³ 'e³ sɨ³lí³ rɨ³nɨ²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Jmii'³¹ lǿ² 'e³ 'a²³jia'³ ta³jmee³ra'³ 'i'²³ miin²³na'³ 'e³ jmii'³¹ 'ne'² rɨ²jmée²ra'³ 'e³ ca³dsaan³²? ");
INSERT INTO cnlNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Xi³nu³ cu³guín²³na'³ xi²ñi² dsa³ 'i³ ta'n² ta² quia̱'n²na'³ dsa³ 'i³ mi³sa³ dsoo² quien³²na'³, 'ne'² rɨ²jmée²ra'³ quién²na'³ 'e³ rɨ²mi³'ien²³na'³ júu² la²³ dxʉ́²³ quia̱'n²na'³ dsa³ 'í³ 'e³ la²³ ta'n²quien²³na'³ jui³¹. Qui² bi²³ juø'² rɨ²³sɨ²³jøn²³ 'nee'²³ caan²³ juez 'i³ juø'² rɨ²³ta̱a̱'n³ 'nee'²³ guoo³ 'láa³. 'I³ 'í³ hua² 'i³ rɨ²³ta̱a̱'n³ 'nee'²³ i²³ñí². ");
INSERT INTO cnlNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Rɨ²juøøn³¹na¹ 'nee'²³: 'A²³jia'³ rɨ²³'uøøn³te'²³ 'nee'²³ i²³ñí² la²³huø'n²³ 'e³ 'íi² rɨ²³dxa²³cɨ́³ra'³ la²³jɨ³ sú̱n² 'e³ mɨ³ya̱'n³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mɨ²jo̱³ ca²³dxi²³guín²³ dsa³ 'i³ ca²³lʉ́³ quia̱'² Jesús. Ca²³ji̱i̱n³te'²³ júu² 'e³ jmii'³¹ ca²³jmée³ dxi² juɨɨ³ Pilato. Qui² ca²³jŋɨ'n²³ dsa³ Galilea 'i³ ta'n² jŋɨ'n²³ dsɨɨ³ joo³ 'i³ cuøn²³te'²³ Dios. Ca²³tu̱u̱³ jmɨ²³'ǿn² dsa³ 'í³ je² ca²³tu̱u̱³ jmɨ²³'ǿn² dsɨɨ³ joo³. La'³ ca²³jua'³ te'²³ dsa³ 'i³ ca²³dxi²³guín²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'i³ ca²³ji̱i̱n³ júu²: ―¿'A² juø'² lǿn³na'³ 'e³ bi²³ cɨ² bee'² dsoo² xa³ quie'² dsa³ Galilea 'i³ ca²³jŋɨ'n²³te'²³ la²³ cɨ'²³ la²³jɨn³ uu'n²te'²³? ¿'A² juø'² lǿn³na'³ 'e³ jo̱³ ca²³ji̱'²³te'²³ la'³? ");
INSERT INTO cnlNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Rɨ²juøøn³¹na¹ 'nee'²³: 'A²³la³ la'³. Qui² rɨ²³gua'²³ la²³jɨn³ 'nee'²³ co̱'³ xi³nu³ 'a²³jia'³ rɨ²tu³¹ra'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Co̱'³ cɨ'²³ xen³ gui²³jñén³ dsa³ 'i³ jú̱n²³ ma²ca¹cɨ'¹ 'ñʉ́² dxi²³juɨn³¹ je² xi̱i̱n³ Siloé. Ca²³cɨ'n²³ 'ñʉ́² dxi²³juɨn³¹ ñi'² quiee'³² dsa³ 'í³. ¿'A² juø'² lǿn³na'³ 'e³ bi²³ cɨ² bee'² dsoo² xa³ quie'²te'²³ la²³ cɨ'²³ la²³jɨn³ uu'n²te'²³ 'i³ nee'n²³² juɨɨ³ Jerusalén? ");
INSERT INTO cnlNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Rɨ²juøøn³¹na¹ 'nee'²³: 'A²³la³ la'³. Qui² rɨ²³gua'²³ la²³jɨn³ 'nee'²³ co̱'³ xi³nu³ 'a²³jia'³ rɨ²tu³¹ra'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","'E³ jo̱³ ca²³lʉ́³ Jesús júu² la³ 'e³ jmee²³ lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'ne'² rɨ²³tʉ́² dsa³ 'e³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³: ―Xen³ dsa³ 'i³ xa³ 'mo³ higo quiee'³² jee²³² je² rɨ³jne² xoo'³¹ jø'². Ca²³dxóo² 'ñée² juii² je² ja³¹ 'mo³ higo 'e³ jua'³ 'née²³ mɨ²higo. 'E³ quie'²³ 'a²³'e³ xa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ mozo 'i³ mi³qui³ xoo'³¹ jø'²: “Mɨ³tɨ́³ 'nɨ³ ji̱i̱³ ñi³ 'e³ guøn³na²³ 'e³ juø'n²³ 'náan²³ mɨ²higo. 'E³ quie'²³ 'a²³'e³ xa³ rɨ³'ɨɨ³¹. Rɨ²³júun³ rɨ²quiu'n² quién²nu³ 'mo³ nɨ³ jo̱o̱²³. 'A²³'e³ xa³ je² 'ne'² 'e³ ja³¹. Te³ juø'³ jnɨɨ³².” ");
INSERT INTO cnlNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","'E³ jo̱³ ca²³jua'³ mozo. Ca²³sɨ'²³ juii²: “Cu²ja³¹ cɨ² ru'³ co̱o̱³ ji̱i̱³ ñi³ rɨ²ne²ra². Rɨ²'uøn²³²na¹ 'uǿ²³ la²³cu'² je² ja³¹. Rɨ²ta'n¹ 'mɨ́ɨ² roo'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Bi²³ dxʉ́²³ xi³nu³ rɨ²³'ɨ́ɨ²³ mɨɨ³¹ je² co̱o̱³ ñi³. 'E³ quie'²³ xi³nu³ 'a²³jia'³ rɨ²³'ɨ́ɨ²³, líi² rɨ²quiu'n².” ");
INSERT INTO cnlNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ ca²³'ɨ́ɨ³ júu² Jesús co̱o̱³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","'Iún² jø̱n³ mɨ́³ 'i³ ca²³tɨ́³ gui²³jñé³ ji̱i̱³ ñi³ 'e³ quie̱n³ espíritu 'i³ jmee²³ dsóo² quie'². Bi²³ ca²³jlʉ́n²³ mɨ́³. 'A²³jia'³ rɨ²³lí³ juø'² rɨ²³noo³ ca³dsaan³². ");
INSERT INTO cnlNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ma²ŋøn³¹ mɨ́³ 'í³ Jesús, tǿ²³. Ca²³jua'³ ca²³sɨ'²³ mɨ́³: ―Rɨ²juøøn³¹na¹ 'nʉ³, mɨ́³: Mɨ³dsǿn²³ dsóo² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","'E³ quie'²³ jo̱³ ca²³dxá³ guoo³ ñi'² quiee'³² mɨ́³. Xe̱'n² jmɨ́ɨ² lǿ²³ juø'² ca²³'ɨɨ'n². 'E³ jo̱³ ca²³mi²³gáan³ Dios mɨ́³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bi²³ ca²³ti̱'n³ dsa³ 'i³ dxi³ 'i'²³ ñʉ'²³ 'ñʉ́² je² mi³gáan³te'²³ Dios 'e³ jua'³ ca²³mi²³'láan³ dsa³ Jesús jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³: ―Jñʉ́ʉ³ jmɨ́ɨ² hua² joo'²³ rɨ²³jmóo² dsa³ ta² cɨ'³ la²³ co̱o̱³ mɨ²guiaa³. 'E³ jo̱³ líi² cu³guín²³na'³ jmɨ́ɨ² jo̱³ 'e³ rɨ²³'láan³na'³. Qui² 'a²³jia'³ joo'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","'E³ jo̱³ ca²³jua'³ Juii³ra². Ca²³sɨ'²³ dsa³ 'í³: ―¡Bi²³ te³ jmee³ra'³ guóo²! 'E³ quie'²³ jee'n²³na'³ miin²³na'³ cua² 'ioo'³ dsóo²³ quien³²na'³, jee'n²³na'³ miin²³na'³ burro quien³²na'³ je² rɨ³'ñu'n²te'²³. Ca²guín¹na'³ cɨ'³ la²³ jø̱n³na'³ ca²'i̱'n²³na'³ jmɨɨ³, juø'n³ quie'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³, ¿mɨ³naa'³¹? La'³ cu³lø³¹ jmee³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","'E³ quie'²³ mɨ³tɨ́³ gui²³jñé³ ji̱i̱³ ñi³ 'e³ ca²³'ñuu'n³ mɨ́³ la³ mɨ²³sɨ²³quiʉ'². ¿'A² 'a²³jia'³ lǿn³na'³ 'e³ 'ne'² rɨ²³jee'n²³ mɨ́³, 'i³ rɨ³løn³¹ dsa³ ju̱u̱n²³ Abraham, juø'n³ quie'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ma²ca¹jua'³ la'³ Jesús, ca²³la²³'ii'²³ la²³jɨn³ 'i³ hui²³dsɨ́ɨn² ñin³². Bi²³ jɨn³ dsɨ́² dsa³ juɨɨ³ ma²ŋó¹te'²³ la²³jɨ³ ta² gáan³ 'e³ ca²³jmée³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","'E³ quie'²³ jo̱³ ca²³jua'³ 'ñée²: ―¿Jmii'³¹ cu³lø³¹ 'e³ rɨ²³lí³ juø'² rɨ²núu²ra'³ 'e³ jmii'³¹ cu³lø³¹ 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³ cu²ne²ra²? ¿Jmii'³¹ cu³lø³¹ júu² 'e³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ jmee²³ lii²³ 'e³ jmii'³¹ cu³lø³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Xen³ la²³ xen³ co̱o̱³ mɨɨ³¹ mɨ³¹ju̱³ mostaza 'e³ ca²³jñi³ dsa³ dxoo³ quiee'³². Bi²³ ca²³cua̱a̱n²³. Ca²³la²³xa³ 'mɨ'n³. Ca²³dxá³ jo̱o̱³¹ to̱³ mɨ²sɨɨ² jee²³² mɨ³¹guoo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Co̱'³ cɨ'²³ ca²³jua'³ Jesús: ―¿Jmii'³¹ cu³lø³¹ júu² 'e³ rɨ²juøøn³¹na¹ 'nee'²³ 'e³ jmee²³ lii²³ 'e³ jmii'³¹ cu³lø³¹ 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Xen³ la²³ xen³ xoo'³¹ 'ɨ²³juɨ² 'e³ có̱²³ jø̱n³ mɨ́³. Ca²³coo'n³ 'nɨ³ kilos tʉʉ² harina. Ca²³jmée³ xoo'³¹ 'ɨ²³juɨ² 'e³ ca²³yʉ̱́ʉ̱²³ la²³jɨ³ sú̱n². La'³ cu³lø³¹ xen³ 'e³ sɨ³ya'n² dsa³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","'E³ quie'²³ jo̱³ 'í² co̱'³ Jesús jui³¹ juɨɨ³ Jerusalén. Ca²³ŋɨ́n³ juɨɨ³ bee'² quia̱'² ranchos pii'² co̱'³. Ca²³'ée²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Xen³ jø̱n³ dsa³ 'i³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―Juiin²³, ¿'a² juø'² 'nɨɨ'n³¹ jø̱n³ áan²³ hua² dsa³ 'i³ rɨ²³láan³? ―ca²³sɨ'²³ Jesús. 'E³ jo̱³ ca²³jua'³ Jesús ca²³sɨ'²³ dsa³ 'í³: ");
INSERT INTO cnlNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Jmee²ra'³ quién²na'³ 'e³ rɨ²ŋɨ́n³na'³ 'oo'² 'e³ bi²³ dsuu³. Qui² rɨ²juøøn³¹na¹ 'nee'²³ 'e³ juɨ́ɨn²³ 'i³ cɨ² li²³'née²³ rɨ²³ŋɨ́n³. 'E³ quie'²³ 'a²³jia'³ ma²³ jmɨ́ɨ² rɨ²³lí³ juø'². ");
INSERT INTO cnlNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ma²mɨ³'áa³ 'i'²³ 'e³ mɨ³naa'n²³ juii² xi²ñʉ'¹, 'e³ mɨ³jní³ dxʉ́²³ 'oo'² 'ñʉ³¹, jo̱³ hua² rɨ²tǿ²ra'³ 'oo'² 'nee'²³ 'i³ té̱e̱n³ xi²dxi³². Rɨ²juo'²ra'³: “Juii³ra'³¹, jmee² co̱o̱³ mɨ²'áa² ne² quiée²ra'³¹ 'e³ rɨ²too'³²ra'³¹ xi²ñʉ'¹.” 'E³ jo̱³ rɨ²³jua'³ juii² xi²ñʉ'¹. Rɨ²³sɨ'²³ 'nee'²³: “'A²³jia'³ jmɨ́ɨ² cuiin²³na²³ 'nee'²³ 'e³ jiaa'³¹ xen³na'³”. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","'E³ jo̱³ rɨ²juo'²ra'³: “Ca²³'i̱i̱'² ca²³quie²ra'³¹ quia̱'n²na'³¹ 'nʉ³. I²ñíin²nu³ jee²³² calles juɨɨ³ quiee³²ra'³¹ 'e³ ca²³'én².” ");
INSERT INTO cnlNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","'E³ quie'²³ rɨ²³jua'³ 'ñée²: “Mɨ³juǿøn²na²³ 'nee'²³ 'e³ 'a²³jia'³ jmɨ́ɨ² cuiin²³na²³ 'nee'²³ 'e³ jiaa'³¹ xen³na'³. Je̱'n²na'³ la²³jɨn³ 'nee'²³ 'i³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Qui² núu²³ rɨ²'o'²ra'³. Núu²³ rɨ²cu'²la²³cɨ²ra'³ jó̱²ra'³ la²³'nɨɨ'n³¹ rɨ²³ŋɨ́³ 'óo²ra'³. Rɨ²joon²³na'³ Abraham quia̱'² Isaac quia̱'² Jacob quia̱'² la²³jɨn³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². Rɨ²joo³¹ra'³ 'e³ jmii'³¹ cu³lø³¹ nee'n²³²te'¹ je² rɨ³løn³¹ Dios juii². 'E³ quie'²³ rɨ²cuaa'n²³na'³ 'nee'²³ xi²dxi³². ");
INSERT INTO cnlNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Qui² rɨ²³gui²³guín²³ dsa³ 'i³ xen³ je² sɨ³'ién²³ ñi'² quia̱'² dsa³ 'i³ xen³ je² sɨ³dxen³ ñi'² quia̱'² dsa³ 'i³ xen³ tɨ́ɨ² i²³la³ i²³nɨ³ co̱'³. Rɨ²³gua³te'²³ coo³¹ mesa je² rɨ³løn³¹ Dios juii². ");
INSERT INTO cnlNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Xen³ 'i³ rɨ²³lín³ 'i³ gáan³ cɨ² 'i³ rɨ³løn³¹ 'i³ pii'² cɨ² rɨ³nɨ²³. Xen³ 'i³ rɨ²³lín³ 'i³ pii'² cɨ² 'i³ rɨ³løn³¹ 'i³ gáan³ cɨ² rɨ³nɨ²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Xe̱'n² jmɨ́ɨ² ca²³dxi²³guín²³ ca³dxáan² dsa³ fariseo. Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Cuí̱i̱² 'nʉ³. Qui² 'née²³ Herodes 'e³ rɨ²³jŋɨ'n²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ fariseo: ―Cu³xii'²ra'³ 'ñée² dsa³ sǿn²³ 'i³ xen³ la²³ xen³ 'ioo'³: “Tú̱²³ jmɨ́ɨ² cɨ² 'uøøn²³²na¹ espíritus quien³² mɨ²³sɨ²³quiʉ'², mi³'láan²na²³ dsa³. Jmeen²³ quián²³ ta² rɨ³nɨ²³ quia̱'² 'áa²³. 'E³ quie'²³ 'áa²³ 'ióo² mɨ³líi² ta² quián²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","'E³ quie'²³ 'ne'² 'e³ 'iun²³²na¹ jui³¹ rɨ³nɨ²³ quia̱'² 'áa²³ quia̱'² 'áa²³ 'ióo². Qui² 'nɨɨ'n³¹ juɨɨ³ Jerusalén hua² joo'²³ 'e³ rɨ²³jú̱n³ jø̱n³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Rɨ²juøøn³¹na¹ 'nee'²³ dsa³ Jerusalén: Jŋɨ'n²³na'³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios. Cuø³ra'³ cú̱u̱² quie'² dsa³ 'i³ xiin²³ Dios quién²na'³. Bi²³ ñúun³ taa'² mɨ³la³'náan²³ rɨ²tøøn³¹na¹ 'nee'²³ quia̱'n²na'³ jo̱o̱³ra'³ 'u². Qui² bi²³ mɨ³la³'náan²³ 'e³ rɨ²i̱i̱n³¹na¹ 'nee'²³ 'e³ la²³ i̱i̱n²³ jo̱o̱³¹ xóo² 'nɨɨ'² 'u². 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² 'noo³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","'A²³jia'³ ma²³ née² guoo³ Dios xi²ñʉ'¹ quien³²na'³. Rɨ²juøøn³¹na¹ 'nee'²³: 'A²³jia'³ ma²³ rɨ²joon²³na'³ jné² co̱'³ la²³huøø'n³¹ 'e³ rɨ²³tɨ́²³ 'e³ rɨ²juo'²ra'³ rɨ²'ǿn¹na'³ jné²: “Mɨ³cuǿ³ Dios u²³li²³jé̱e̱³ quie'² dsa³ la³ 'i³ ja³'ɨ́ɨn²³ 'e³ 'iin³¹ Dios Juii³ra²”. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ca²³tɨ́³ 'e³ ñíin² Jesús i²ee'³ quie'² jø̱n³ juii² dsa³ fariseo jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. Bi²³ ten³²te'²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Xi'n²³ xi²ñi² Jesús jø̱n³ dsa³ 'i³ bi²³ mɨ³ya̱a̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","'E³ jo̱³ ca²³lʉ́³ Jesús. Ca²³sɨ'²³ dsa³ 'e²³ ley quia̱'² dsa³ fariseo. Ca²³jua'³: ―¿'A² joo'²³ rɨ²mi³'láan²na² dsa³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³, juo'³ 'nee'²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'E³ quie'²³ 'a²³jia'³ ca²³'í̱n²te'²³. 'E³ jo̱³ ca²³dxá³ guoo³ ñi'² quiee'³². Ca²³mi²³'láan³ dsa³ 'í³. Ca²³sɨ'²³ dsa³ 'í³ 'e³ cu²dxe'n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","'E³ quie'²³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ fariseo: ―La²³ cu²ru'³ xen³ jø̱n³ 'nee'²³ 'i³ mɨ³tø'n³ jø̱n³ jo̱o̱³¹ 'e̱'³ too³ je² sø'n³²te'²³ jmɨɨ³, 'i³ mɨ³tø'n³ jø̱n³ cua² 'ioo'³ dsóo²³ quien³². Rɨ²dxin²³na'³ xe̱'n² jmɨ́ɨ², ¿mɨ³naa'³¹?, juø'n³ quie'²³ rɨ²³lí³ la'³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","'A²³'e³ ma²³ xa³ ca²³lǿ²³ juø'² ca²³sɨ'²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ŋó²³ Jesús 'e³ jmii'³¹ ca²³jmóo² dsa³ 'i³ ca²³tøø³te'²³ 'e³ rɨ²³e'² ca³ti³² quia̱'² 'ñée². Qui² 'née²³ rɨ²³røøn²³te'²³ je² dxʉ́²³ cɨ² rɨ²³gua³te'²³. 'E³ jo̱³ ca²³lʉ́³ júu² la³ 'e³ ca²³cuǿ³ jui³¹ quie'²te'²³. Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―'A²³ rɨ³ñí³ra'³ je² dxʉ́²³ cɨ² mɨ³rɨ³tee³te'²³ 'nee'²³ je² mɨ³jén²³ dsa³ mɨ́³. ¿Jmii'³¹ xi³nu³ xen³ dsa³ 'i³ rɨ²³tøø³te'²³ 'i³ gáan³ cɨ² la²³ 'nee'²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jo̱³ rɨ²³güén³ caan²³na'³ dsa³ 'i³ mɨ³tøø³ 'nee'²³ quia̱'² dsa³ 'i³ gáan³ cɨ². Rɨ²³sɨ'²³ 'nee'²³: “Je̱'n²na'³ nɨ³. Qui² je² nɨ³ rɨ²³gua³ dsa³ la³.” 'E³ jo̱³ bi²³ li²³'íin²na'³ rɨ²ñí²ra'³ je² lǿn³ dsa³ 'e³ bi²³ 'áa² cu³lø³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","'E³ quie'²³ bi²³ cɨ² dxʉ́²³ 'e³ rɨ²ñí²ra'³ xe̱'n² je² lǿn³ dsa³ 'e³ bi²³ 'áa² cu³lø³¹ mɨ³rɨ³tee³te'²³ 'nee'²³. 'E³ jo̱³ mɨ³rɨ³dxee'n³² dsa³ 'i³ mɨ³tøø³ 'nee'²³, jo̱³ rɨ²³sɨ'²³ 'nee'²³: “Ñí³ra'³ je² dxʉ́²³ cɨ² xú̱n³”. 'E³ jo̱³ 'a²³jia'³ li²³'íin²na'³ xi²ñi² la²³jɨn³ dsa³ 'i³ nee'n²³²na'³ quia̱'n²na'³ coo³¹ mesa. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Qui² 'e³ cɨ² li²³'uǿn²³ dsa³ 'i³ mi³gáan³ 'ñée². 'E³ cɨ² rɨ²³mi²³gáan³te'²³ dsa³ 'i³ mi³'uǿn²³ 'ñée². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Cɨ̱ɨ̱n³ cɨ² ca²³lʉ́³ co̱'³ Jesús. Ca²³sɨ'²³ dsa³ 'i³ ca²³tøø³ quie'². Ca²³jua'³: ―Mɨ³rɨ³jmeen³ ji̱i̱³ mó² 'e³ rɨ²³e'² dsa³ dxoo'³¹ jmɨ́ɨ², 'e³ rɨ²³e'² dsa³ mɨ²³'láa²³, 'a²³ rɨ³tøøn³² jmø'n² la²³ dsa³ 'i³ bi²³ dxʉ́²³ lʉ́n² quia̱'n²nu³, jmø'n² la²³ já̱a̱n², jmø'n² la²³ dsa³ 'i³ xen³ quién²nu³, jmø'n² la²³ dsa³ xoo³² 'i³ nee'n²³² caan²³nu³. Co̱'³ xi² rɨ²³tøø³te'²³ 'nʉ³ 'e³ rɨ²cø'n² 'e³ rɨ²³dxaan³te'²³ 'e³ la²³ mɨ³jméen² 'uǿøn²nu³. Jo̱³ mɨ³la³xa³ jñiin²³nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","'E³ quie'²³ mɨ³rɨ³jmeen³ ji̱i̱³ mó² 'e³ rɨ²³e'² dsa³, rɨ²tøøn³¹ dsa³ taan³ quia̱'² dsa³ 'i³ xa³ je² rɨ³yaan²³ quie'² quia̱'² dsa³ 'i³ 'uaa'³ tɨɨ² quia̱'² dsa³ tuu² mɨ²ñi². ");
INSERT INTO cnlNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jo̱³ hua² li²³dxʉ́²³ quién²nu³ ca³quie̱e̱². Qui² te'²³ dsa³ 'í³ hua² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³dxaan³te'²³. Dios rɨ²³cuǿ²³ jñiin²³nu³ mɨ³rɨ³jmee³ 'ñée² 'e³ rɨ²³ji̱i̱'²³ co̱'³ dsa³ 'i³ mɨ³jmóo² 'e³ ca³dsaan³². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ca²³núu³ jø̱n³ dsa³ 'i³ jen³¹ coo³¹ mesa quia̱'² Jesús júu² 'e³ ca²³lʉ́³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―Bi²³ dxʉ́²³ quie'² dsa³ 'i³ rɨ²³e'² je² rɨ³løn³¹ Dios juii². ");
INSERT INTO cnlNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―La²³la³ cu³lø³¹ ca²³jmée³ jø̱n³ dsa³ co̱o̱³ taa'²: Bi²³ ñúun³ 'e³ ca²³jmée³ ji̱i̱³ 'e³ rɨ²³e'² dsa³. Bi²³ juɨ́ɨn²³ dsa³ 'i³ ca²³tøø³ 'e³ rɨ²³e'² quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma²mɨ³tɨ́³ hora 'e³ rɨ²³e'² dsa³, ca²³xíin²³ mozo quien³² 'e³ rɨ²³sɨ²³tee³ dsa³. La²³la³ cu³lø³¹ 'née²³ 'e³ rɨ²³sɨ'²³ dsa³ mozo: “Ñe³ra'³ jo̱o̱²³. Qui² mɨ³la³tɨ́ɨ²³ la²³jɨ³ 'e³ 'ne'².” ");
INSERT INTO cnlNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","'E³ quie'²³ jo̱³ ca²³jua'³ la²³jɨn³te'²³ 'e³ cu²jmée³ u²³juee'³ dsɨɨ³² 'e³ 'a²³jia'³ rɨ²³lí³ juø'² sɨ³guín²³te'²³. 'Ñée² 'i³ ca²³lʉ́³ xe̱'n² ca²³jua'³: “Mɨ³cǿ̱n²³ ca³juɨ² 'uǿ²³. 'Ne'² i³joon²³ ca³quie̱e̱² jmii'³¹ cu³lø³¹. Cu²jmée³ u²³juee'³ dsɨɨ³² 'e³ 'a²³jia'³ rɨ²³lí³ juø'² ñiin²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ca²³jua'³ jia'³ cɨ'²³ co̱'³: “Mɨ³jǿn²na²³ 'ñé³ dsa'n² cua² 'ioo'³ dsóo²³. Ñiin²³ i³joon²³na²³ 'e³ 'ee² cu³løn³¹. Cu²jmée³ u²³juee'³ dsɨɨ³² 'e³ 'a²³jia'³ rɨ²³lí³ juø'² ñiin²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ca²³jua'³ jia'³ cɨ'²³ co̱'³: “'E³ cɨ² lá²³ mɨ³jǿn²na²³ mɨ́³. 'E³ jo̱³ hua² 'a²³jia'³ rɨ²³lí³ juø'² ñiin²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","'E³ jo̱³ ñi'n² co̱'³ mozo, i²xii'²³² juii² 'e³ jmii'³¹ mɨ³jua'³te'²³. 'E³ jo̱³ ca²³ti̱'n³ juii². Ca²³sɨ'²³ mozo quien³²: “Guo³ co̱'³ ca²³la²³dxí² jee²³² calles bee'² quia̱'² calles pii'² 'e³ xa³ jee²³² juɨɨ³. Cu³jén²³nu³ dsa³ taan³ quia̱'² dsa³ 'i³ xa³ je² rɨ³yaan²³ quie'² quia̱'² dsa³ 'i³ 'uaa'³ tɨɨ² quia̱'² dsa³ tuu² mɨ²ñi².” ");
INSERT INTO cnlNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ñíin² co̱'³ mozo. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ juii²: “Mɨ³lǿ²³ 'e³ la²³ mɨ³dxín² 'i'²³. 'E³ quie'²³ xa³ je² joo'²³ 'e³ rɨ²³ta'n²³ cɨ² dsa³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","'E³ jo̱³ ca²³jua'³ juii². Ca²³sɨ'²³ mozo: “Guo³ co̱'³ jui³¹ juee'³ quia̱'² jui³¹ tii³. Rɨ²juɨɨ'n³¹ dsa³ la²³bii²³ 'e³ cu²ta'n¹te'²³ xi³'lɨ² rɨ²³quie̱e̱'n²³te'²³ xi²ñʉ'¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Qui² rɨ²juøøn³¹na¹ 'nee'²³: Cu³xi³ jø̱n³ dsa³ 'i³ ca²³tǿøn² xe̱'n² 'a²³jia'³ jmɨ́ɨ² rɨ²³e'² mó² quián²³”, ca²³jua'³ juii². ―La²³nɨ³ cu³lø³¹ júu² 'e³ ca²³lʉ́³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ quia̱'² Jesús. 'E³ quie'²³ jo̱³ ca²³ji̱i̱n²³ 'ñée². Ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ");
INSERT INTO cnlNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Dsa³ 'i³ 'née²³ 'e³ rɨ²³lín³ dsa³ quién²³na²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³jmée²³ 'e³ bi²³ cɨ² nee² dsɨ́² jmii³ quia̱'² xóo² quia̱'² mɨ²³quie'² quia̱'² jo̱o̱³¹ quia̱'² jó̱o̱². Co̱'³ cɨ'²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³jmée²³ 'e³ bi²³ cɨ² nee² dsɨ́² 'e³ xen³ 'ñée². Xi³nu³ bi²³ li²³nee² dsɨ́² la²³jɨ³ 'e³ xa³, 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³lín³ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","'Ne'² rɨ²³dxi²³quié̱n² dsa³ quién²³na²³ 'e³ la²³ dxi³quié̱n² dsa³ 'i³ ta̱a̱n²³ cruz. 'Ne'² rɨ²³qui̱i̱³ jné². Xi³nu³ 'a²³jia'³ rɨ²³jmée²³ la'³, 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³lín³ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","La²³ cu²ru'³ xen³ jø̱n³ 'nee'²³ 'i³ 'née²³ rɨ²³jmée²³ 'ñʉ́² dxi²³juɨn³¹, jén²³ cɨ² rɨ²³gua³ coo³¹ mesa, rɨ²³jmée²³ 'i'²³ 'e³ lɨɨ'³¹ rɨ²³cɨ̱́ɨ̱n²³ co̱o̱³ 'ñʉ́², ¿mɨ³naa'³¹? Rɨ²³jmée²³ 'i'²³ xi² rɨ²³dxi²³tɨn³² cuu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Xi³nu³ 'a²³jia'³ rɨ²³jmée²³ la'³, te³ dxʉ́²³ rɨ²³lóo²³ ta², te³ dxʉ́²³ li²³xa³ tɨ́ɨ² je² rɨ²³noo³ 'ioo'³. 'E³ quie'² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³mi²³'ien³ ta². 'E³ quie'²³ jo̱³ rɨ²³jáa² rɨ²³ŋɨ́ɨ² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Rɨ²³jua'³te'²³: “Lóo² ca²³jmée³ co̱o̱³ 'ñʉ́² dxi²³juɨn³¹ dsa³ la³, ¿mɨ³naa'³¹? 'E³ quie'²³ 'a²³jia'³ lǿ²³ juø'² ca²³'ien³ ta² quiee'³².” ");
INSERT INTO cnlNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","'E³ quie'²³ la'³ jø̱n³ rey 'i³ dsoo³² sɨ³jmee³ qui³ quia̱'² jia'³ cɨ'²³ rey. Jén²³ cɨ² 'ne'² rɨ²³gua³ rɨ²³jmée²³ 'i'²³ dxʉ́²³ xi² rɨ²³li'²³ juø'² rɨ²³jmée²³ qui³ quia̱'² uu'n². Xen³ guiáa³ mil 'láa³ quie'² jia'³ cɨ'²³ rey. 'E³ quie'²³ 'nɨɨ'n³¹ guiá²³ mil hua² xen³ quie'² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Xi³nu³ mɨ³la³quii²³ 'e³ 'a²³jia'³ rɨ²³li'²³ 'ñée², jén²³ cɨ² 'e³ la²³ rɨ²³güén³ jia'³ cɨ'²³ rey, jo̱³ tu³ rɨ²³xíin²³ mozos 'i³ rɨ²³ŋɨ́ɨ²³ mɨ²'áa² 'e³ 'a²³jia'³ rɨ²³lí³ qui³. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","'E³ jo̱³ xi³nu³ xen³ jø̱n³ 'nee'²³ 'i³ 'a²³jia'³ li²³bii²³ dsɨ́² rɨ²³tʉ́² la²³jɨ³ 'e³ xa³ quie'², 'a²³jia'³ jmɨ́ɨ² rɨ²³lí³ juø'² rɨ²³lín³ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Co̱'³ cɨ'²³ ca²³jua'³ Jesús: ―’Bi²³ dxʉ́²³ juɨ² ñi². La²³ xen³ juɨ² ñi² 'e³ bi²³ dxʉ́²³ ñii²³² xen³ dsa³ quién²³na²³ 'i³ 'a²³jia'³ nee² dsɨ́² la²³jɨ³ 'e³ xa³ quie'². 'E³ quie'²³ 'u² cu²ru'³ xa³ juɨ² ñi² 'e³ 'a²³jia'³ ma²³ ñii²³², 'a²³jia'³ ma²³ rɨ²³lí³ juø'² rɨ²³jmóo²te'²³ 'e³ li²³ñii²³² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Cu³xi³ 'e³ rɨ²³'li'²³te'²³ 'uǿ²³ 'e³ cu²li³dxʉ́²³ 'uǿ²³ 'e³ xa³ mɨɨ³¹ 'e³ rɨ²³jñí³te'²³ 'a²³'e³ xa³ jui³¹ quie'². Cu³xi³ juø'n³ rɨ²³coo'n³te'²³ 'mɨɨ³ 'e³ rɨ²³'li'²³te'²³ 'uǿ²³ 'e³ cu²li³dxʉ́²³ 'uǿ²³ 'a²³'e³ xa³ jui³¹ quie'². 'E³ quie'²³ 'nɨɨ'n³¹ 'e³ to̱o̱³²hua²te'¹. 'Ne'² rɨ²³núu²³ júu² la³ dsa³ 'i³ 'née²³ rɨ²³cuǿn²³ miin²³ 'e³ rɨ²³núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ca²³ja²³guín²³ caan²³ Jesús 'io'² quia̱'² dsa³ tu³cua̱a̱n²tu². Qui² 'née²³te'²³ rɨ²³núu²³te'²³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'E³ jo̱³ bi²³ ca²³lʉ́³ dsa³ fariseo. 'E³ quie'²³ la'³ dsa³ 'e²³ ley co̱'³. Ca²³jua'³te'²³: ―Bi²³ 'néen² dsa³ la³ quia̱'² dsa³ 'i³ bi²³ xa³ dsoo² quiee'³². Ee'³² quia̱'² te'²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","'E³ jo̱³ ca²³lʉ́³ Jesús júu² la³ 'e³ jmee²³ lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'née²³ rɨ²³tøø³ dsa³ Dios. Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―La²³ cu²ru'³ xen³ jø̱n³ 'nee'²³ 'i³ xen³ co̱o̱³ i³láan³ dsɨɨ³ joo³ quie'². Mɨ³ca³caa'n³² jø̱n³. Ta'n² quie'²³ ñii³ quiee'³² 'e³ jø̱n³ 'a²³ ti³² co̱o̱³ i³láan³. 'E³ jo̱³ rɨ²³cuaa'n³ juii² 'e³ jø̱n³ 'a²³ ti³² co̱o̱³ i³láan³. Rɨ²³dsóo² co̱'³ sɨ³'ne'n³ 'ñée² dsɨɨ³ joo³ 'i³ mɨ³ca³caa'n³² xi³'lɨ² rɨ²³dxe'n², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mɨ³rɨ³dxe'n² dsɨɨ³ joo³ quien³², bi²³ jɨn³ dsɨ́² rɨ²³quiaan³ coo'² cuáa². ");
INSERT INTO cnlNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mɨ³rɨ³dxe'n² co̱'³ quie'², rɨ²³tøø³ dsa³ 'i³ bi²³ dxʉ́²³ lʉ²³ quia̱'² quia̱'² dsa³ 'i³ nee'n²³² ji̱i̱'² coo³¹. 'E³ jo̱³ rɨ²³sɨ'²³ dsa³ 'í³: “Ñe³ra'³ rɨ²jmee²ra² 'e³ jɨn³ dsɨ³ra² ca³ti³². Qui² mɨ³dsø'n²³na²³ dsɨɨ³ joo³ quién²³na²³ 'i³ mɨ³ca³caa'n³² ca³dxa³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","'E³ quie'²³ la'³, rɨ²juøøn³¹na¹ 'nee'²³: Bi²³ jɨn³ dsɨ́² rɨ²³jmóo²te'²³ yʉʉ'³¹ güii³ mɨ³rɨ³tʉ³² jø̱n³ dsa³ 'e³ jmee²³ 'e³ 'a²³jia'³ dxʉ́²³. Bi²³ cɨ² jɨn³ dsɨ́²te'²³ jmee²³ la²³ cɨ'²³ 'e³ xen³ 'e³ jø̱n³ 'a²³ ti³² co̱o̱³ i³láan³ 'i³ jmoo³² 'e³ ca³dsaan³², 'i³ 'a²³la³ ma²³ 'e³ cɨ² 'ne'² rɨ²³tʉ́² 'e³ jmoo³² 'e³ 'a²³jia'³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’'E³ quie'²³ la'³, cu²ru'³ xen³ jø̱n³ mɨ́³ 'i³ xa³ guiá²³ cuu² quie'². Mɨ³guoo'³² co̱o̱³ cuu². Rɨ²³xe̱'n² ji³. Rɨ²³'io'³ dxʉ́²³ la²³ xi²ñʉ'¹. Rɨ²³'no'²³ xi³'lɨ² rɨ²³dxoo'²³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma²mɨ³'áa³ 'i'²³ 'e³ mɨ³dso'²³ cuu², rɨ²³tøø³ dsa³ 'i³ dxʉ́²³ lʉ²³ quia̱'² quia̱'² dsa³ 'i³ nee'n²³² ji̱i̱'² coo³¹. Rɨ²³jua'³: “Ñe³ra'³ rɨ²jmee²ra² 'e³ jɨn³ dsɨ³ra² ca³ti³². Qui² mɨ³dsa'n²³ cuu² 'e³ mɨ³guoo'³² ca³dxa³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","'E³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³: Bi²³ jɨn³ dsɨ́² te'²³ ángeles quien³² Dios mɨ³rɨ³tʉ³² 'e³ jmee²³ 'e³ 'a²³jia'³ dxʉ́²³ jø̱n³ dsa³ 'i³ bi²³ tu³cua̱a̱n²tu² jmee²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ca²³lʉ́³ co̱'³ Jesús. Ca²³jua'³: ―La²³ cu²ru'³ xen³ jø̱n³ dsa³ 'i³ xen³ áan²³ jo̱o̱³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ca²³jua'³ xii'³ 'i³ mi'n²³ cɨ². Ca²³sɨ'²³ jmii³: “Ñu'n², rɨ²cuøøn³¹nu³ jné² rɨ³nɨ²³ la²³'nɨɨ'n³¹ 'e³ lǿn³nu³ 'e³ cɨ² rɨ²cuøøn³¹nu³ jné² mɨ³rɨ³taa'n³² dxóo².” 'E³ jo̱³ ca²³to'²³ dxóo² jmii³ la²³jɨ³ 'e³ xa³ quie'². Ca²³cuǿø²³ te'²³ jo̱o̱³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","'A²³jia'³ ca²³la²³huǿø³ la'³ 'e³ ca²³'nɨ́ɨ³ jo̱o̱³¹ 'i³ mi'n²³ cɨ² la²³jɨ³ 'e³ xa³ quie'². 'E³ quie'²³ jo̱³ ŋóo² jia'³ cɨ'²³ juɨɨ³ je² bi²³ huɨ̱́ɨ̱³. Bi²³ jɨɨ'n³ ca²³jmée³ je² núu²³. Bi²³ tu³cua̱a̱n²tu² ca²³yáan² la²³jɨ³ 'e³ xa³ quie'² quia̱'² amigos quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ma²mɨ³'áa³ 'i'²³ 'e³ mɨ³dsá²³ la²³jɨ³ 'e³ xa³ quie'², ca²³tɨ́³ 'e³ bi²³ ca²³la²³'oon²³ cuɨɨ³ juɨɨ³ je² ca²³dxóo². 'E³ quie'²³ jo̱³ ca²³la²³cue̱'²³ 'ñée² xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","'E³ jo̱³ ŋóo². Ca²³jmée³ ta² quiee'³² jø̱n³ dsa³ 'i³ xen³ juɨɨ³ je² jen³¹. Ca²³xíin²³te'²³ xii'³ rancho quiee'³² juii² ta² 'e³ sɨ³e'n² cu²xi³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","'Née²³ xii'³ rɨ²³cuu'³ mɨ²cuo'¹ 'mo³ 'e³ ee'³² cu²xi³¹ 'u² cu²ru'³ xa³ ñúun³. Qui² 'a²³'e³ xa³ 'e³ ca²³cuǿø²³te'²³ 'e³ rɨ²³e'² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","'E³ jo̱³ ca²³lǿn³: “Maan²³ 'e³ bi²³ juɨ́ɨn²³ mozos xen³ quie'² ñu'n²³ 'i³ bi²³ dxʉ́²³ ee'³². Sɨ³tø'n² cɨ² la²³'nɨɨ'n³¹ ñuu'n³¹ 'e³ xa³ quie'²te'²³. 'E³ quie'²³ rɨ²³jú̱n³la²³cɨ²na¹ je² la³ 'e³ la²³'nɨɨ'n³¹ cué̱e̱n²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ñe'n³²na²³ co̱'³ quie'² ñu'n²³ tu³sɨ'²³. Jo̱³ rɨ²juøøn³¹: Ñu'n², mɨ³jméen²³ 'e³ xa³ dsoo² quián²³ 'e³ mɨ³jme'n²³na²³ Dios, 'e³ mɨ³jme'n²³na²³ 'nʉ³ co̱'³, rɨ²juøøn³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'A²³jia'³ ma²³ dxi³ji̱i̱n³¹ 'e³ rɨ²³jua'³ dsa³ 'e³ ja̱a̱n³ jné². Rɨ²jmee'n³¹nu³ jné² 'e³ la²³ jmee'n³² jø̱n³ mozo quien³²nu³. La'³ cu³lø³¹ rɨ²juøøn³¹ ñu'n²³”, ca²³lǿn³ xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","'E³ jo̱³ 'í² jui³¹. Ŋø'n² quie'² jmii³. ’'E³ quie'²³ jmee²³ cɨ² bíi²³ 'e³ rɨ²³dxe'n² xii'³ je² jen³¹ jmii³, 'e³ quie'²³ jo̱³ ŋó²³ jmii³. Bi²³ ca²³la²³cuu'²³ dsɨ́² jmii³ ñin³² jo̱o̱³¹. 'E³ jo̱³ 'í² jui³¹ ca²³la²³dxí². Ca²³ta̱a̱'n³ cuáa² xii'³. Ca²³cuu'³ ñi². ");
INSERT INTO cnlNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","'E³ quie'²³ jo̱³ ca²³jua'³ jo̱o̱³¹. Ca²³sɨ'²³ jmii³: “Ñu'n², mɨ³jméen²³ 'e³ xa³ dsoo² quián²³. Mɨ³jme'n²³na²³ Dios. Mɨ³jme'n²³na²³ 'nʉ³ co̱'³. 'A²³jia'³ ma²³ dxi³ji̱i̱n³¹ 'e³ rɨ²³jua'³ dsa³ 'e³ ja̱a̱n³ jné².” ");
INSERT INTO cnlNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","'E³ quie'²³ ca²³jua'³ jmii³. Ca²³sɨ'²³ mozos quien³²: “Cu³quie̱³ra'³ ca²³la²³dxí² 'mɨɨ'³ 'e³ dxʉ́²³ cɨ² 'e³ rɨ²qui'n¹na'³ xii'³ la³. Rɨ²to̱'²ra'³ mɨ²ñí² mɨ²xi¹guoo³. Rɨ²too'³¹ra'³ 'mɨɨ'³ loo³ tɨɨ². ");
INSERT INTO cnlNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Cu³jén²³na'³ jo̱o̱³¹ cua² 'ioo'³ 'i³ bi²³ dxʉ́²³ mɨ³e'n²te'²³ 'i³ mɨ³la³be'n². Rɨ²jŋɨ'n²³na'³. Rɨ²jmée²ra'³ mó². Jo̱³ rɨ²quie²ra². Rɨ²jmee²ra² mɨ²juee'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Qui² ca²³lǿn³na²³ 'e³ jú̱n²³ ja̱a̱n²³ la³. 'E³ quie'²³ 'é̱e̱² 'e³ mɨ³ji̱i̱'²³ co̱'³. Mɨ³ca³caa'n³² ca³dxa³. 'E³ quie'²³ mɨ³la³jneen³² co̱'³.” La'³ ca²³jua'³ jmii³. 'E³ jo̱³ ca²³la²³jɨn³ dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Jiaan³ je² nuu³ jo̱o̱³¹ 'i³ mɨ³dxún²³ cɨ². 'E³ jo̱³ 'í² jui³¹ 'e³ dsø'n³². Ca²³lǿn²³ mɨ³lén² xi²ñʉ'¹. Ca²³núu³ 'e³ jiʉʉ³² dsa³ jiʉʉ³². Ca²³núu³ 'e³ dsøn²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","'E³ jo̱³ ca²³tøø³ jø̱n³ mozo quien³² jmii³. Ca²³tín²³ júu² 'e³ 'ee² júu² xa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","'E³ jo̱³ ca²³jua'³ mozo. Ca²³sɨ'²³ xii'³: “Mɨ³güee'n³² co̱'³ já̱a̱n². 'E³ jo̱³ mɨ³dxi³ 'i'²³ ñu'n² 'e³ mɨ³jŋɨ'n²³te'²³ jo̱o̱³¹ cua² 'ioo'³ 'i³ mɨ³la³be'n². Mɨ³jmóo²te'²³ mó². Qui² bi²³ 'née²³ ñu'n² 'e³ mɨ³güee'n³² co̱'³ já̱a̱n², 'e³ dxún²³ quie'²³, 'e³ 'a²³'e³ xa³ lǿn²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","'E³ quie'²³ bi²³ ca²³ti̱'n³ jo̱o̱³¹ 'i³ mɨ³dxún²³ cɨ². 'A²³jia'³ dxʉ́²³ dsɨ́² 'e³ rɨ²³'í³ xi²ñʉ'¹. 'E³ jo̱³ ca²³bǿn³ jmii³ xi²ñʉ'¹ 'e³ rɨ²³sɨ'²³ jo̱o̱³¹ 'e³ rɨ²³'í³ xi²ñʉ'¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","'E³ quie'²³ ca²³jua'³ xii'³. Ca²³sɨ'²³ jmii³: “Máan³ 'uǿøn²nu³ 'e³ mɨ³la³ñúun³ ji̱i̱³ ñi³ 'e³ jmeen²³ ta² quia̱'n²³²na¹ 'nʉ³. Cu³xi³ co̱o̱³ taa'² 'a²³jia'³ lɨ'³ ca³mi³gua'n²³ 'e³ la²³ dxin³ 'i'²³. 'E³ quie'²³ 'a²³jia'³ lɨ'³ ca³cuǿn²nu³ jné² cu³xi³ jø̱n³ jo̱o̱³¹ xʉ̱́ʉ̱² lóo² 'e³ rɨ²jmeen²³² mɨ²juee'³ quia̱'n²³²na¹ te'²³ amigos quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","'E³ quie'²³ mɨ³güee'n³² co̱'³ ja̱a̱n³ 'i³ ca²³yáan² cuu² quien³²nu³ quia̱'² mɨ́³ 'i³ jmoo³² ñi³ dxa³. 'E³ quie'²³ mɨ³jŋɨ'n²³nu³ jo̱o̱³¹ cua² 'ioo'³ 'i³ mɨ³la³be'n².” ");
INSERT INTO cnlNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","'E³ jo̱³ ca²³jua'³ jmii³. Ca²³sɨ'²³ jo̱o̱³¹: “Ja̱a̱n²³, tén³ quia̱'n²nu³ jné². 'E³ quien³²nu³ la²³jɨ³ 'e³ xa³ quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","'E³ quie'²³ joo'²³ 'e³ rɨ²jmee²ra² mɨ²juee'³. Joo'²³ 'e³ rɨ²jmee²ra² 'e³ jɨn³ dsɨ³ra². Qui² ca²³lǿn³na²³ 'e³ jú̱n²³ já̱a̱n². 'E³ quie'²³ 'é̱e̱² 'e³ mɨ³ji̱i̱'²³ co̱'³. Mɨ³ca³caa'n³² ca³dxa³. 'E³ quie'²³ mɨ³la³jneen³² co̱'³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ca²³lʉ́³ co̱'³ Jesús. Ca²³sɨ'²³ dsa³ quien³². Ca²³jua'³: ―La²³ cu²ru'³ xen³ dsa³ xoo³² 'i³ ca²³'náan²³ jø̱n³ mozo 'i³ rɨ²³jmée²³ cua̱a̱n²tu² la²³jɨ³ ta² quiee'³². Xen³ dsa³ 'i³ ca²³ji̱i̱n³ júu² quie'² 'i³ rɨ³løn³¹ juii² 'e³ yaan³² mozo la²³jɨ³ 'e³ røøn³ rɨ²³jmée²³ cua̱a̱n²tu². ");
INSERT INTO cnlNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","'E³ jo̱³ ca²³tøø³ mozo dsa³ 'i³ rɨ³løn³¹ juii². Ca²³jua'³ ca²³sɨ'²³ mozo: “¿Jmii'³¹ lǿ² júu² 'e³ sɨ'²³ dsa³ jné² 'e³ 'en³²te'²³ 'nʉ³? Rɨ²jméen² júu² 'e³ jmii'³¹ cu³lø³¹ ta² 'e³ mɨ³jméen². Qui² 'a²³jia'³ ma²³ rɨ²cuøn²³² júu² 'e³ rɨ²jméen² ta² quián²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","'E³ jo̱³ ca²³jmée³ 'i'²³ 'ñée² 'i³ jmee²³ ta². Ca²³lǿn³: “¿Jmii'³¹ rɨ²jmeen²³² cu²ne²ra²? Qui² mɨ³ rɨ²³je̱'n²te'²³ ta² 'e³ jmeen²³. 'A²³jia'³ rɨ²³a̱a̱'n²³ 'e³ rɨ²jmeen²³² ta² je² nuu³. Qui² bi²³ gáan³ dxíi³. 'A²³jia'³ jmɨ́ɨ² li²³bii²³ dsɨn²³ 'e³ rɨ²ñin²³² jee²³² calles 'e³ rɨ²'ɨɨn²³² joo³¹ guaan²³ 'e³ rɨ²ŋɨɨn²³² cuu². ");
INSERT INTO cnlNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mɨ³jméen²³ 'i'²³ 'e³ jmii'³¹ rɨ²jmeen²³² 'e³ la²³ li²³xen³ dsa³ 'i³ dxʉ́²³ lʉn²³ quia̱'n²³²na¹ mɨ³rɨ³'aa³ 'i'²³ 'e³ mɨ³je̱'n²te'²³ ca³quie̱e̱² ta² quián²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","'E³ jo̱³ ca²³tøø³ dsa³ 'i³ ya̱'n³ quie'² juii² cɨ'³ jø̱n³ cɨ'³ jø̱n³. Ca²³sɨ'²³ dsa³ 'i³ xe̱'n²: “¿Lɨɨ'³¹ 'nɨɨ'n³¹ ya̱'n³nu³ quie'² juii² ta² 'e³ jmeen²³?” ");
INSERT INTO cnlNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ca²³jua'³ dsa³ 'í³: “Jné² ya̱'n³na²³ co̱o̱³ i³lóo³ ba³rii³² noo²³² aceite”. 'E³ jo̱³ ca²³jua'³ dsa³ 'i³ mɨ³'ien³ júu² 'e³ rɨ²³je̱'n²te'²³ ta² quiee'³²: “'E³ la³ vale quien³²nu³. Ñí³ xe̱'n² rɨ³nɨ²³. Rɨ²jméen² co̱o̱³ vale 'e³ rɨ²te̱e̱n³¹ 'nɨɨ'n³¹ tú̱²³ lu²³guiá³ cɨ².” ");
INSERT INTO cnlNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ jia'³ cɨ'²³: “¿Lɨɨ'³¹ 'nɨɨ'n³¹ 'e³ ya̱'n³ 'nʉ³ co̱'³?” Ca²³jua'³ dsa³ 'í³: “Ya̱'n³na²³ co̱o̱³ i³lóo³ láa² mɨ³¹cuɨɨ³ trigo”. 'E³ jo̱³ ca²³jua'³ dsa³ 'i³ mɨ³'ien³ júu² 'e³ rɨ²³je̱'n²te'²³ ta² quiee'³². Ca²³sɨ'²³ dsa³ 'í³: “'E³ la³ vale quien³²nu³. Rɨ²jméen² co̱o̱³ vale 'e³ rɨ²te̱e̱n³¹ guiáa³ cɨ² 'a²³ ti³² co̱o̱³ i³lóo³ láa².” ");
INSERT INTO cnlNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","'E³ jo̱³ ca²³jua'³ juii² 'e³ bi²³ ta³jmee²³ 'i'²³ mozo 'i³ sǿn²³ 'e³ jmii'³¹ rɨ²³jmée²³. Qui² bi²³ tɨn³ ta³lʉ²³ quia̱'² dsa³, la²³ cu²ru'³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³ 'e³ la²³ rɨ²³ti²³guo² ta² quiee'³²te'²³. Bi²³ cɨ² tɨn³te'²³ ta³lʉ²³te'²³ quia̱'²te'²³ dsa³ la²³ cɨ'²³ dsa³ 'i³ mɨ³la³jnén³ ji³ quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Rɨ²juøøn³¹na¹ 'nee'²³: Xa³ je² jmee²³ ta² dxʉ́²³ cuu², juø'n³ quie'²³ sɨ³lí³ juø'² jmee²³ 'e³ sǿn²³. Rɨ²cuǿ²ra'³ cuu². Rɨ²jmée²ra'³ co̱²juø'¹ quie'² dsa³. Jo̱³ hua² li²³xen³ dsa³ 'i³ dxʉ́²³ lʉ́²ra'³ quia̱'n²na'³. Jo̱³ hua² rɨ²³'i'n²te'²³ 'nee'²³ yʉʉ'³¹ je² nee'n²³² dsa³ ca³cuaa³ mɨ³rɨ³'aa³ 'i'²³ 'e³ mɨ³dsá²³ cuu². ");
INSERT INTO cnlNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Dsa³ 'i³ dxʉ́²³ jmee²³ cua̱a̱n²tu² je² xa³ ca³juɨ², 'e³ quie'²³ la'³ bi²³ dxʉ́²³ rɨ²³jmée²³ cua̱a̱n²tu² je² xa³ ñúun³ co̱'³. Dsa³ 'i³ jmee²³ 'e³ sǿn²³ je² xa³ ca³juɨ², 'e³ quie'²³ la'³, rɨ²³jmée²³ 'e³ sǿn²³ je² xa³ ñúun³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Xi³nu³ 'a²³jia'³ dxʉ́²³ mɨ³jmée²ra'³ ta² quiee'³² cuu² 'e³ sɨ³lí³ juø'² jmee²³ 'e³ sǿn²³, 'e³ quie'²³ bi²³ cɨ² 'a²³jia'³ jmɨ́ɨ² rɨ²³cuǿø²³te'²³ 'nee'²³ 'e³ rɨ²³lín³na'³ cua̱a̱n²tu² la²³jɨ³ 'e³ bi²³ cɨ² quí̱i̱n²³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Xi³nu³ 'a²³jia'³ dxʉ́²³ mɨ³jmée²ra'³ cua̱a̱n²tu² la²³jɨ³ 'e³ xa³ quie'² jia'³ cɨ'²³, 'a²³'i̱³ xen³ 'i³ li²³bii²³ dsɨ́² 'e³ rɨ²³cuǿø²³ 'nee'²³ 'e³ xa³ quie'² 'e³ cu²lí³ 'e³ quien³²na'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’'A²³'i̱³ xen³ mozo 'i³ rɨ²³lí³ juø'² rɨ²³jmée²³ ta² quia̱'² áan²³ juii². Qui² rɨ²³lí³ 'e³ hui²³dsɨ́ɨn² ñin³² jø̱n³. 'E³ quie'²³ li²³'néen² jia'³ cɨ'²³. Rɨ²³jmée²³ 'e³ la²³ jua'³ jø̱n³. 'E³ quie'²³ 'a²³jia'³ rɨ²³mi²³quí̱i̱n²³ 'e³ la²³ jua'³ jia'³ cɨ'²³. 'A²³jia'³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ ta² 'e³ dxi³ 'i'²³ Dios ca³ti³² quia̱'² ta² 'e³ dxi³ 'i'²³ cuu². ");
INSERT INTO cnlNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ca²³núu³ dsa³ fariseo la²³jɨ³ júu² 'e³ ca²³lʉ́³ Jesús. 'E³ jo̱³ bi²³ ca²³jáa² ca²³ŋɨ́ɨ²te'²³. Qui² bi²³ 'iin²³ dsɨ́²te'²³ cuu². ");
INSERT INTO cnlNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ fariseo: ―Bi²³ jmee³ra'³ guóo² 'e³ 'noo³ra'³ 'e³ rɨ²³lǿn³ dsa³ 'e³ jmee³ra'³ ca³dsaan³². 'E³ quie'²³ cuii³ 'óo²ra'³ Dios. 'A²³jia'³ ta³dsɨ³² Dios quia̱'² la²³jɨ³ 'e³ lǿn³ dsa³ mɨ³¹güii³ 'e³ bi²³ gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Co̱'³ cɨ'²³ ca²³jua'³ Jesús: ―La²³huøø'n³¹ 'e³ 'íi² rɨ²³'ɨ́ɨ²³ júu² Juan ca²³cuǿ³ jui³¹ ley 'e³ ca²³ŋɨ́n² Moisés quia̱'² ji³ 'e³ ca²³sɨ́ɨ³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². Cɨ'²³ la²³ ca²³'ɨ́ɨ³ júu² Juan, nuu³ dsa³ júu² dxʉ́²³ 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³. La²³jɨ³ ju²³bíi²³ mɨ³la³'née²³ dsa³ 'e³ rɨ²³lín³ Dios juii²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’'E³ quie'²³ cu³xi³ co̱o̱³ mɨɨ³¹ mɨ²'uø'¹ 'e³ to̱o̱²³ ley 'a²³jia'³ jmɨ́ɨ² rɨ²³lí³ 'e³ 'a²³jia'³ ma²³ quí̱i̱n²³. Bi²³ cɨ² 'a²³jia'³ jmɨ́ɨ² rɨ²³gua'²³ ley la²³ cɨ'²³ mɨ³¹güii³ quia̱'² 'uǿ²³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Co̱'³ cɨ'²³ ca²³jua'³ Jesús: ―Xi³nu³ xen³ dsóo²³ 'i³ tʉn³² mɨ²³quie'², 'i³ tøø²³ jia'³ cɨ'²³ mɨ́³, jmee²³ ñi³ dxa³ dsa³ 'í³. Xi³nu³ xen³ dsóo²³ 'i³ tøø²³ mɨ́³ 'i³ ca²³tʉ́n² dsóo²³ quien³², jmee²³ ñi³ dxa³ dsa³ 'í³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’La²³la³ cu³lø³¹ ca²³ji̱'²³ jø̱n³ dsa³ xoo³² co̱o̱³ taa'². Xen³ jø̱n³ dsa³ xoo³² 'i³ bi²³ ma²³'nee³ dxʉ́²³ 'mɨɨ'³ 'e³ quii'³. Dxa²³ mɨ²juee'³ la²³jɨ³ jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","'Oo'² 'ñʉ³¹ quiee'³² rɨ³caa'n³² tén³ la²³ jø̱n³ dsa³ taan³ 'i³ xi̱i̱n³ Lázaro 'i³ bi²³ sɨ³juii³ la³'e². ");
INSERT INTO cnlNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","'Née²³ rɨ²³e'² sɨ³taan³ te³ 'ee² 'noo³¹ 'e³ sɨ³jiʉ'² ñʉ'²³ mesa je² ee'³² dsa³ xoo³². Guøn³ dsɨɨ³, xʉ̱ʉ̱'²³ je² sɨ³juii³ la³'e². ");
INSERT INTO cnlNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ca²³tɨ́³ jmɨ́ɨ² 'e³ jú̱n²³ dsa³ taan³. Te'²³ ángeles ca²³jáan³ je² jen³¹ Abraham je² bi²³ jɨn³ dsɨ́² dsa³. Ca²³tɨ́³ jmɨ́ɨ² 'e³ jú̱n²³ dsa³ xoo³² co̱'³. Ca²³'áan²te'²³ jo̱o̱²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ŋø'n² je² nee'²³² dsɨ́² dsa³ 'i³ 'a²³jia'³ ca²³jmóo² ca³dsaan³² je² bi²³ dxi³quié̱n². Ca²³jóo² je² huɨ̱́ɨ̱³ 'ñée². Ŋǿn² Abraham. Jen³¹ Lázaro caan²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³jua'³: “Ñu'n² Abraham, cu²li³cuu'²³ 'áan² quia̱'n²nu³ jné². Rɨ²sɨɨn²³nu³ Lázaro 'e³ rɨ²³'a'²³ jmɨɨ³ ca³juɨ² yʉʉ'³¹ mɨ²xi¹guoo³ 'e³ rɨ²³quiʉ̱'² sɨ'n²³ 'e³ cu²li³güii'²³. Qui² 'a²³jia'³ jmɨ́ɨ² rɨ²³táan²³ la²³'nɨɨ'n³¹ dxi³quié̱n²na²³ dxi³¹ji³ la³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","'E³ quie'²³ ca²³jua'³ Abraham: “Ja̱a̱n²³, 'ne'² li²³liin³²nu³ 'e³ bi²³ dxʉ́²³ ca²³ñín³ ca²³naan³ mɨ³¹güii³ quien³²nu³. 'E³ quie'²³ 'a²³jia'³ dxʉ́²³ ca²³gua³ Lázaro mɨ²jo̱³. 'E³ quie'²³ mɨ³lɨɨn³² dsɨ́² 'ñée² je² la³. 'Nʉ³ hua² 'i³ 'a²³jia'³ rɨ²³tén²nu³ la²³'nɨɨ'n³¹ 'e³ dxi³quié̱n²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","'E³ quie'²³ 'a²³la³ 'nɨɨ'n³¹ la'³. Mɨ³lǿ²³ co̱o̱³ 'e̱'³ guó³ jɨ̱ɨ̱n²³² ma²³'nee³ 'e³ rɨ³jnɨ³ je² nee'²³²ra'³¹ quia̱'² je² jen³¹nu³. 'E³ jo̱³ hua² 'e³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³tɨ́n²³ je² jen³¹nu³ dsa³ 'i³ nee'n²³² la³ 'i³ 'née²³ sɨ³guín²³ je² jen³¹nu³ nɨ³. 'E³ quie'²³ la'³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³ja²³guín²³ je² la³ dsa³ 'i³ nee'n²³² je² jen³¹nu³ nɨ³.” La'³ ca²³jua'³ Abraham. Ca²³sɨ'²³ dsa³ xoo³². ");
INSERT INTO cnlNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","'E³ jo̱³ ca²³jua'³ dsa³ xoo³²: “Ñu'n² Abraham, jné² ŋɨ'n²³na²³ 'nʉ³ 'e³ rɨ²sɨɨn²³nu³ Lázaro quie'² ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Qui² xen³ cɨ² 'ñén³ ja̱a̱n³². 'Náan²³ 'e³ rɨ²³lʉ́²³ Lázaro quia̱'² ja̱a̱n³² 'e³ la²³ 'a²³jia'³ rɨ²³ja²³guín²³te'²³ la³ je² bi²³ dxi³quié̱n²na'³¹.” ");
INSERT INTO cnlNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","'E³ quie'²³ ca²³jua'³ Abraham: “Xa³ quie'²te'²³ júu² 'e³ 'ióo² Moisés mɨ²jaa²³² quia̱'² júu² 'e³ ca²³sɨɨ³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². Røø³ 'íi² 'e³ rɨ²³núu²³te'²³ júu² jo̱³ xi³nu³ 'née²³te'²³ rɨ²³láan³te'²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","'E³ quie'²³ jo̱³ ca²³jua'³ dsa³ xoo³²: “'A²³jia'³ líi² 'nɨɨ'n³¹ la'³, ñu'n²³ Abraham. 'U² cu²ru'³ xen³ jø̱n³ dsa³ 'i³ rɨ²³bǿn³, 'i³ rɨ²³ji̱i̱'²³ co̱'³, 'i³ rɨ²³dsóo² quie'²te'²³, jo̱³ hua² rɨ²³tʉ́²te'²³ 'e³ jmoo³²te'²³ 'e³ 'a²³jia'³ dxʉ́²³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","'E³ quie'²³ jo̱³ ca²³jua'³ Abraham. Ca²³sɨ'²³ dsa³ xoo³²: “Xi³nu³ 'a²³jia'³ rɨ²³núu²³te'²³ júu² quiee'³² Moisés quia̱'² júu² quiee'³² dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², 'e³ quie'²³ la'³ 'a²³jia'³ rɨ²³sɨ²³táan³te'²³, juø'n³ quie'²³ rɨ²³ji̱i̱'²³ co̱'³ jø̱n³ dsa³.” ―La'³ cu³lø³¹ júu² 'e³ ca²³lʉ́³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Rɨ³lø³¹ 'i'²³ 'e³ bi²³ ñúun³ la²³jɨ³ 'e³ dsɨn³² dsoo² 'e³ sɨ³'lǿn²³ dsa³. 'E³ quie'²³ bi²³ juɨɨ³² dsa³ 'i³ 'løn³² uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bi²³ cɨ² dxʉ́²³ quie'² dsa³ 'í³ 'u² cu²ru'³ rɨ²³dxóo²te'²³ lúu² co̱o̱³ too²³, 'e³ rɨ²³juén²te'²³ 'e̱'³ jmɨ²³ñii'³¹ 'e³ la²³ 'íi² cɨ² rɨ²³'lǿn²³ jø̱n³ 'i³ pii'² la³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Xi²dsɨ́n³na'³ jo̱o̱²³na²³. ’Xi³nu³ rɨ²³jme'²³ 'nee'²³ uu'n²na'³ 'e³ xa³ dsoo² quiee'³², rɨ²juɨɨ'³¹ra'³ 'e³ 'a²³jia'³ dxʉ́²³ jmee²³. 'E³ jo̱³ rɨ²jmée²ra'³ u²³juee'³ dsɨɨ³² miin²³na'³ xi³nu³ li²³cuu'²³ dsɨ́² 'e³ 'a²³jia'³ ma²³ 'née²³ rɨ²³jmée²³ la²³jɨ³ 'e³ mɨ³jmée³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'Ne'² rɨ²jmée²ra'³ u²³juee'³ dsɨɨ³², rɨ²mǿn¹na'³ dsa³ 'i³ rɨ²³jme'²³ 'nee'²³ 'e³ xa³ dsoo² quiee'³², 'e³ quie'²³ sɨ³ŋɨ́ɨ³ mɨ²'áa² quién²na'³ 'e³ jua'³ 'a²³jia'³ ma²³ rɨ²³jmée²³ la'³ co̱'³. 'Ne'² rɨ²jmée²ra'³ u²³juee'³ dsɨɨ³², juø'n³ quie'²³ guiáa²³ taa'² 'nɨɨ'n³¹ rɨ²³jmée²³ la'³ co̱o̱³ jmɨ́ɨ². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","'E³ quie'²³ jo̱³ ca²³jua'³ dsa³ xiin²³. Ca²³sɨ'²³ Juii³ra²: ―Rɨ²jméen² 'e³ bi²³ cɨ² rɨ²³sɨ²³táan³na'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","'E³ jo̱³ ca²³jua'³ Juii³ra²: ―'U² cu²ru'³ sɨ³táan³na'³, juø'n³ quie'²³ ca³pii'², la²³'nɨɨ'n³¹ pi'n² co̱o̱³ mɨɨ³¹ mɨ³¹ju̱³ mostaza, rɨ²³lí³ juø'² rɨ²³je̱'n²³ 'mo³ sicómoro la³ mɨ³rɨ³juo'³ra'³: “Je̱'n² nɨ³. Cu²sɨ³dxín³nu³ 'e̱'³ jmɨ²³ñii'³¹.” 'E³ quie'²³ rɨ²³jmée²³ la'³ 'u² cu²ru'³ sɨ³táan³na'³, juø'n³ quie'²³ ca³pii'². ");
INSERT INTO cnlNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’La²³ cu²ru'³ xen³ jø̱n³ 'nee'²³ 'i³ xen³ mozo quien³²na'³ 'i³ 'uøn³² 'uǿ²³, 'i³ mi³quin³ dsɨɨ³ joo³. Mɨ³rɨ³güe'n²³ co̱'³ mozo, 'a²³jia'³ jmɨ́ɨ² rɨ²juɨɨ'³¹ra'³ mozo: “Ŋɨ́n³ xe̱'n² rɨ³nɨ²³ 'e³ rɨ²cø'n²” xi³nu³ 'íi² rɨ²cø'²ra'³ miin²³na'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'E³ quie'²³ rɨ²juɨɨ'³¹ra'³ mozo: “Rɨ²jméen² ji̱i̱³ 'e³ rɨ²ee'n²³². Rɨ²mi³tɨɨn²³ 'e³ rɨ²mi³quin²³nu³ jné² je² rɨ²uu'n²³² rɨ²ee'n²³². Ca³'ee²³² cɨ² rɨ²'u'n² rɨ²cø'n² 'uǿøn²nu³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Co̱'³ cɨ'²³ 'a²³jia'³ ji̱i̱n²³²na'³ mɨ²'áa² quie'² mozo 'e³ juo'³ra'³ mɨ³jmée³ 'e³ la²³ mɨ³dxí²ra'³ 'i'²³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","'E³ quie'²³ la'³ 'nee'²³ co̱'³. Mɨ³rɨ³'aa³ 'i'²³ 'e³ mɨ³jmée²ra'³ la²³jɨ³ 'e³ ca²³dxi³ 'i'²³ Dios, 'ne'² rɨ²lǿn³na'³ 'e³ 'a²³la³ jo̱³ 'e³ bi²³ xa³ cua̱a̱n²tu² quie'² Dios Juii³ra'³ 'e³ jmee³ra'³ la²³jɨ³ ta² 'e³ cuøø²³ 'nee'²³ 'ñée². Qui² mɨ³jmée²ra'³ 'e³ la²³'nɨɨ'n³¹ 'e³ ya̱'n³na'³ rɨ²jmée²ra'³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","'E³ la²³ ŋóo² juɨɨ³ Jerusalén, ca²³ŋɨ́n³ la²³ca̱a̱n³ 'ióo³ 'uǿ²³ estado Samaria quia̱'² estado Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","'E³ la²³ ca²³dxóo² co̱o̱³ juɨɨ³, xen³ guién²³ dsa³ 'i³ ta̱a̱n²³ goo³. Ca²³mi²³jí̱i̱n³te'²³ Jesús. 'E³ quie'²³ ca²³noo³te'²³ huɨ̱́ɨ̱³. Ca²³jóon²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ca²³lʉ́³te'²³ quiʉ̱ʉ̱³. Ca²³jua'³te'²³: ―¡Jesús, Dsa³ 'e²³, cu²li³cuu'²³ 'áan² quia̱'n²nu³ jnee'³¹! ");
INSERT INTO cnlNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ma²ŋøn³¹ dsa³ 'í³ Jesús, ca²³jua'³: ―Cu³'én²na'³ miin²³na'³ te'²³ jmii³ dsa³. 'E³ jo̱³ ca²³'láan³te'²³ dsa³ 'í³ 'e³ la²³ ta'n²te'²³ jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ca²³ji̱i̱n²³ jø̱n³ dsa³ 'í³ ma²mɨ³la³quii²³ 'e³ mɨ³'láan³. Ja'n² co̱'³ je² xi'n²³ Jesús. Ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³mi²³gáan³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ca²³quiaa³ rɨ³'in³² xi²ñi² Jesús. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Jesús. Dsa³ Samaria 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","'E³ jo̱³ ca²³jua'³ Jesús: ―Guién²³ xen³ 'i³ mɨ³'láan³, ¿mɨ³naa'³¹? ¿Neen³¹ cɨ² ñún²³te'²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿'A² juø'² jø̱n³ 'i³ la³ hua² 'i³ xen³ jia'³ cɨ'²³ joo³¹ 'i³ mɨ³güee'n³² co̱'³ 'e³ rɨ²³mi²³gáan³ Dios? ");
INSERT INTO cnlNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ―Naa'n²³ 'nʉ³. Guø'n³ co̱'³. Sɨ³táan³nu³. 'E³ jo̱³ mɨ³'láan³nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ca²³ŋɨ́ɨ³ júu² dsa³ fariseo. Ca²³sɨ'²³te'²³ Jesús 'e³ lɨɨ'³¹ rɨ²³tɨ́²³ 'e³ rɨ²³lín³ Dios juii² dsa³. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ fariseo: ―'A²³'e³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²³jóo² dsa³ 'e³ jmee²³ lii²³ 'e³ sɨ³lín³ Dios juii² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","'A²³jia'³ rɨ²³lí³ juø'² rɨ²³jua'³te'²³: “Je² la³ sɨ³lín³. Je² núu²³ sɨ³lín³.” Qui² jee²³² quien³²na'³ rɨ³løn³¹ Dios juii² dsa³ rɨ³nɨ²³. ―La'³ cu³lø³¹ ca²³sɨ'²³ dsa³ fariseo. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ca²³jua'³ co̱'³ ca²³sɨ'²³ dsa³ quien³²: ―'E³ cɨ² rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ bi²³ li²³'noo³ra'³ 'e³ rɨ²joo³¹ra'³ 'e³ rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. Juø'n³ quie'²³ co̱o̱³ jmɨ́ɨ² 'noo³quie²³ra'³. 'E³ quie'²³ 'a²³jia'³ mɨ³ rɨ²joo³¹ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Rɨ²³sɨ'²³te'²³ 'nee'²³: “Jóo² je² núu²³. Jóo² je² la³.” 'A²³jia'³ 'ne'² cu³guín²³na'³ je² 'e²³te'²³. 'A²³ rɨ³qui̱i̱'³²ra'³ dsa³ 'i³ jua'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Qui² sɨ³li³jné²³ rɨ³ca̱'n²³ mɨ³¹güii³ mɨ³rɨ³'mii'³ i²³'ñeen³¹. 'E³ quie'²³ la'³ cu³lø³¹ rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³ mɨ³rɨ³ti³ jmɨ́ɨ² quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","'E³ quie'²³ jén²³ cɨ² 'e³ la²³ rɨ²³lí³ la'³, ñúun³ cɨ² 'ne'² rɨ²³jí̱i̱n²³. Rɨ²³tʉ́n² jné² dsa³ 'i³ xen³ rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","'E³ la²³ lǿ² jmɨ́ɨ² ma²jen³¹ mɨ³¹güii³ Noé mɨ²jaa²³², 'e³ quie'²³ la'³ cu³lø³¹ rɨ²³lí³ mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","'Ɨ̱ɨ̱'³² ee'³² quie'²³ dsa³ mɨ²jo̱³. Tøø²³ quie'²³ dsa³ mɨ́³. Cuøn³²quie'²³te'²³ mɨ́³ 'e³ rɨ²³jén²³ dsa³. Sɨ³lí³ quie'²³ la'³ la²³huøø'n³¹ la²³ 'e³ ca²³tɨ́³ 'e³ 'í² Noé 'e̱'³ móo². 'E³ quie'²³ jo̱³ ca²³cø̱'n²³ jmɨɨ³ mɨ³¹güii³. Guo'² la²³jɨn³ dsa³ 'i³ xen³ mɨ²jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","'E³ quie'²³ la'³ cu³lø³¹ mɨ²jaa²³² ma²jen³¹ mɨ³¹güii³ Lot. 'Ɨ̱ɨ̱'³² ee'³² quie'²³ dsa³. 'Noo³ lo³² quie'²³ dsa³. 'Nɨɨ²³ jmee²³ quie'²³ dsa³. Jñi³ 'oo³² quie'²³ dsa³ la²³jɨ³ 'e³ jñi³ dsa³. Jmoo³² quie'²³ dsa³ 'ñʉ́². ");
INSERT INTO cnlNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","'E³ quie'²³ ma²ca¹tɨ́³ 'e³ ca²³bǿn³ Lot juɨɨ³ Sodoma, ca²³'ló²³ ji³ quia̱'² guo² jí² jí̱i̱n² yʉʉ'³¹ güii³. Guo'² la²³jɨn³ dsa³ juɨɨ³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","La'³ cu³lø³¹ rɨ²³lí³ mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ li²³jnén³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³ xi³nu³ xen³ dsa³ 'i³ iún² coo'² 'ñʉ́², 'e³ quie'²³ nee'²³² xi²ñʉ'¹ la²³jɨ³ 'e³ xa³ quie'², 'a²³jia'³ 'ne'² rɨ²³dsø'n² xi²ñʉ'¹ 'e³ rɨ²³sɨ²³quié̱³ la²³jɨ³ 'e³ xa³ quie'². 'Ne'² rɨ²³cuí̱i̱²³ xe̱'n². 'E³ quie'²³ la'³ xi³nu³ xen³ dsa³ 'i³ jmee²³ ta² je² nuu³, 'a²³jia'³ 'ne'² rɨ²³dsø'n² quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","'Ne'² li²³liin³²na'³ 'e³ jmii'³¹ guo'² mɨ²³quie'² Lot 'e³ jua'³ nee² dsɨ́² la²³jɨ³ 'e³ ca²³cuaa'n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Qui² rɨ²³gua'²³ dsa³ 'i³ bi²³ mi³quí̱i̱n²³ 'e³ xen³ mɨ³¹güii³ la³. 'E³ quie'²³ rɨ²³láan³ dsa³ 'i³ rɨ²³cuǿn²³ 'ñée² 'e³ rɨ²³jú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Jné² rɨ²juøøn³¹na¹ 'nee'²³: Mɨ³rɨ³ti³ 'uøø²³ jo̱³ juø'n³ quie'²³ xen³ áan²³ dsa³ 'i³ rɨ³saan³ co̱o̱³ ji̱i̱², jø̱n³ rɨ²³tøø³ Dios, jø̱n³ rɨ²³cuaa'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Juø'n³ quie'²³ xen³ áan²³ mɨ́³ 'i³ dsɨ³ ca³ti³², jø̱n³ rɨ²³tøø³ Dios, jø̱n³ rɨ²³cuaa'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Juø'n³ quie'²³ xen³ áan²³ dsa³ 'i³ ta'n² je² nuu³ ca³ti³², jø̱n³ rɨ²³tøø³ Dios, jø̱n³ rɨ²³cuaa'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","'E³ jo̱³ ca²³jua'³ dsa³ quien³². Ca²³sɨ'²³te'²³ Jesús: ―¿Jiaa'³¹ rɨ²³lí³ la'³ cu²ne²ra², Juii³ra'³¹? 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Te³ jiaa'³¹ ra̱a̱n²³ 'lɨ́ɨ³, 'e³ quie'²³ núu²³ rɨ²³ñii'n²³ tu³ sɨ̱ɨ̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ca²³lʉ́³ Jesús co̱o̱³ júu² 'e³ jmee²³ lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'ne'² rɨ²³lʉ́²³ dsa³ tén³ la²³ quia̱'²te'²³ Dios, 'e³ 'a²³jia'³ 'ne'² 'e³ li²³juɨ'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ca²³jua'³ ca²³sɨ'²³ dsa³: ―La²³ cu²ru'³ xa³ co̱o̱³ juɨɨ³ je² xen³ jø̱n³ juez 'i³ 'a²³jia'³ 'ñaa'n²³ Dios. 'E³ quie'²³ 'a²³jia'³ 'ñaa'n²³ dsa³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Juɨɨ³ jo̱³ xen³ jø̱n³ mɨ́³ 'nɨ́ɨ³ 'i³ ŋɨ́³ sú̱n² jmɨ́ɨ² la²³ quie'² juez. Jua'³ mɨ́³ 'nɨ́ɨ³: “Rɨ²jméen² co̱²juø'¹ quián²³. Qui² xen³ jø̱n³ dsa³ 'i³ 'née²³ rɨ²³níin³ quia̱'² jné².” ");
INSERT INTO cnlNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ca²³la²³huǿø³ ca³juɨ² 'e³ 'a²³jia'³ dxʉ́²³ dsɨ́² juez 'e³ rɨ²³jmée²³ quie'². 'E³ quie'²³ cɨ̱ɨ̱n³ cɨ² ca²³jmée³ 'i'²³. Lǿn³ 'ñée²: “'A²³jia'³ 'ñaa'n²³na²³ Dios. 'E³ quie'²³ 'a²³jia'³ 'ñaa'n²³na²³ dsa³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","'E³ quie'²³ rɨ²jmeen²³² quián²³ co̱²juø'¹ quie'² mɨ́³ 'nɨ́ɨ³. Qui² bi²³ cuøø²³ jné² u²³ŋɨ́³ dsɨ́ɨ². Bi²³ juø'² rɨ²³'uaa'n²³na²³ 'e³ la²³'nɨɨ'n³¹ tén³ guøn³ quián²³, cuøø²³ jné² u²³ŋɨ́³ dsɨ́ɨ².” ");
INSERT INTO cnlNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ca²³jua'³ Juii³ra²: ―Rɨ²núu²ra'³ jo̱o̱²³na²³ 'e³ jmii'³¹ ca²³jmée³ jø̱n³ juez 'i³ 'a²³jia'³ jmee²³ 'e³ ca³dsaan³². ");
INSERT INTO cnlNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Rɨ²³jmée²³ Dios co̱²juø'¹ quie'² dsa³ quien³² 'i³ ca²³'náan²³ 'i³ ŋɨɨ²³ mɨ²'áa² jmɨ́ɨ²³ 'uøø²³, ¿mɨ³naa'³¹? Bi²³ cɨ² xe̱'n² rɨ²³jmée²³ co̱²juø'¹ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Rɨ²juøøn³¹na¹ 'nee'²³: Co̱'³ la²³ rɨ²³jmée²³ co̱²juø'¹ quie'² dsa³ quien³². 'E³ quie'²³, ¿jmii'³¹ cu³løn³¹ dsa³ mɨ³rɨ³ti³ 'e³ rɨ²³güe'n²³na²³ co̱'³ jné² Jo̱o̱³¹ Dsa³? ¿'A² juø'² xen³ quie'²³ dsa³ 'i³ sɨ³táan³ jmɨ́ɨ² jo̱³ cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Co̱'³ cɨ'²³ ca²³lʉ́³ Jesús. Ca²³sɨ'²³ dsa³ 'i³ lǿn³ miin²³ 'e³ bi²³ ca³dsaan³² jmoo³², 'e³ quie'²³ 'i³ lǿn³ 'e³ 'a²³jia'³ 'nee'n³¹ jia'³ cɨ'²³ dsa³. Ca²³lʉ́³ Jesús júu² 'e³ jmee²³ lii²³ 'e³ jmii'³¹ cu³løn³¹te'¹: ");
INSERT INTO cnlNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―La²³ cu²ru'³ xen³ áan²³ dsa³ 'i³ ca²³guín²³ 'ñʉ́² gáan³ je² mi³gáan³ dsa³ Dios. I²guín¹ 'e³ rɨ²³lʉ́²³te'²³ quia̱'²te'²³ Dios. Dsa³ fariseo jø̱n³. 'Io'² jø̱n³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","'E³ quie'²³ jo̱³ ca²³noo³ ca³jné³ dsa³ fariseo. Ca²³lʉ́³ quia̱'² Dios. Ca²³jua'³: “Bi²³ mɨ²'áan²nu³, Dios, 'e³ bi²³ dxún²³na²³. Qui² 'a²³jia'³ lǿn²³na²³ la²³ lǿn²³ jia'³ cɨ'²³ dsa³. Rɨ³løn³¹te'¹ dsa³ 'i̱i̱³. 'A²³jia'³ jmoo³² 'e³ ca³dsaan³². Ta̱a̱'n³ miin²³ quia̱'² jia'³ cɨ'²³ mɨ́³. 'E³ quie'²³ 'a²³jia'³ lǿn²³na²³ 'ñáan²³ la²³ lǿn²³ 'io'² nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Qui² jmeen²³ mɨ²³jmɨɨ²³ tú̱²³ taa'² la²³ co̱o̱³ mɨ²guiaa³. Jmeen²³ guiá²³ taa'² la²³jɨ³ 'e³ sɨ³tɨn²³na²³. Cuøøn²³na²³ 'nʉ³ co̱o̱³ taa'² jo̱o̱²³na²³”, ca²³jua'³ dsa³ fariseo. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","'E³ quie'²³ ca²³noo³ ca³jné³ 'io'². 'A²³jia'³ ma²³ ca²³la²³bii²³ dsɨ́² rɨ²³jóo² yʉʉ'³¹. Ca²³quiʉ̱́ʉ̱³ 'uǿ² 'e³ jua'³ ŋɨ́³ dsɨ́². Ca²³jua'³: “Dios, cu²li³cuu'²³ 'áan² quia̱'n²nu³ jné². Qui² bi²³ bee'² dsoo² xa³ quián²³.” La'³ ca²³jua'³ 'io'². ");
INSERT INTO cnlNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Rɨ²juøøn³¹na¹ 'nee'²³: Lǿn³ Dios 'e³ jmee²³ 'e³ ca³dsaan³² 'io'². 'E³ quie'²³ 'a²³jia'³ lǿn³ 'e³ jmee²³ 'e³ ca³dsaan³² dsa³ fariseo. Qui² 'e³ cɨ² li²³'uǿn²³ dsa³ 'i³ mi³gáan³ 'ñée². 'E³ cɨ² rɨ²³mi²³gáan³te'²³ dsa³ 'i³ mi³'uǿn²³ 'ñée². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Co̱'³ cɨ'²³ ca²³jøn²³ dsa³ xi³yu̱u̱n³ quien³² caan²³ Jesús. 'Née²³ dsa³ 'í³ 'e³ rɨ²³dxá²³ guoo³ Jesús ñi'² quiee'³² xi³yu̱u̱n³ quien³². 'E³ jo̱³ ca²³jíi² dsa³ quien³² Jesús ma²ŋó¹te'²³ 'e³ i²jøn²³te'²³ xii'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","'E³ quie'²³ tǿ²³ Jesús. Ca²³tøø³ dsa³ quien³². Ca²³jua'³: ―Cu²ja³guín²³ caan²³na²³ te'²³ xii'³ pii'². 'A²³ rɨ³jníin²na'³ jui³¹ quie'²te'²³. Qui² rɨ³løn³¹ Dios juii² dsa³ 'i³ xen³ la²³ xen³ xii'³ pii'². ");
INSERT INTO cnlNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³jia'³ rɨ²³lín³ Dios juii² dsa³ 'i³ 'a²³jia'³ sɨ³táan³ quia̱'² Dios la²³ sɨ³táan³ xii'³ pii'² quia̱'² xóo² jmii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Xen³ jø̱n³ dsa³ 'i³ 'iún² ta² jee²³² quiee'³² dsa³ Israel 'i³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³ 'i³ dxún²³, ¿jmii'³¹ 'ne'² rɨ²jmeen²³² 'e³ la²³ rɨ³ji̱'n²³na²³ ca³cuaa³? ");
INSERT INTO cnlNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―¿'Ee² lǿ² juɨɨ'n³²nu³ jné² 'i³ dxún²³? Jø̱n³ Dios hua² 'i³ dxún²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Máan³ 'nʉ³ jmii'³¹ lǿ² júu² 'e³ dxi³ 'i'²³ Dios, ¿mɨ³naa'³¹?: “'A²³ rɨ³jmee³ra'³ ñi³ dxa³. 'A²³ rɨ³jmee³ra'³ 'móo². 'A²³ rɨ³jmee³ra'³ 'i̱i̱³. 'A²³ rɨ³júu²ra'³ mɨ³rɨ³lin³na'³ dsa³ ñi³. Rɨ²'óo²ra'³ u²³go³ u²³'iʉʉ²³ quia̱'n²na'³ xoo³ra'³ ñʉ'²ra'³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","'E³ jo̱³ ca²³jua'³ dsa³ 'í³: ―Jmeen²³ quián²³ cɨ'²³ la²³ pi'n²³²na¹ 'e³ lø³² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma²ca¹núu³ Jesús júu² 'e³ ca²³lʉ́³, ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ―Xa³ cɨ² co̱o̱³ 'e³ 'íi² quién²nu³. Rɨ²'nɨ́ɨn² la²³jɨ³ 'e³ xa³ quién²nu³. Jñii³¹ 'e³ jo̱³ rɨ²cuøøn³¹ dsa³ taan³. Jo̱³ hua² ñúun³ 'e³ quí̱i̱n²³ ca³quie̱e̱² 'e³ li²³xa³ quién²nu³ yʉʉ'³¹ güii³. Ñe³ jo̱o̱²³na²³. Rɨ²ŋɨ́n² quia̱'n²nu³ jné². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","'E³ quie'²³ ma²ca¹núu³ júu² 'e³ ca²³lʉ́³ Jesús, bi²³ ca²³ŋɨ́³ dsɨ́². Qui² bi²³ ma²³'nee³ ñúun³ la²³jɨ³ 'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ma²ŋó¹ Jesús 'e³ bi²³ ŋɨ́³ dsɨ́² dsa³ 'í³, ca²³jua'³: ―¡Bi²³ gáan³ dxíi³ 'e³ rɨ²³lín³ Dios juii² dsa³ xoo³²! ");
INSERT INTO cnlNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Rɨ²³lí³ cɨ² juø'² rɨ²³ŋɨ́n³ roo'³² camello guo² me²³cuu². 'E³ quie'²³ bi²³ gáan³ dxíi³ 'e³ rɨ²³lín³ Dios juii² dsa³ xoo³². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","'E³ jo̱³ ca²³jua'³ dsa³ 'i³ ca²³núu³ júu² 'e³ ca²³lʉ́³: ―¿'I̱i̱² dsa³ 'i³ rɨ²³lí³ juø'² rɨ²³láan³ jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","'E³ quie'²³ ca²³jua'³ Jesús: ―Sɨ³lí³ juø'² jmee²³ Dios la²³jɨ³ 'e³ 'a²³jia'³ jmɨ́ɨ² rɨ²³li'²³ juø'² rɨ²³jmóo² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","'E³ quie'²³ jo̱³ ca²³jua'³ Peen²³². Ca²³sɨ'²³ Jesús: ―Ca²³cuaa'n²³²na'³¹ la²³jɨ³ 'e³ xa³ quiée²ra'³¹ 'e³ ŋɨ²ra'³¹ quia̱'n²na'³¹ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: La²³jɨn³ dsa³ 'i³ mɨ³cuaa'n³ 'ñʉ́², 'i³ mɨ³cuaa'n³ xóo² jmii³, 'i³ mɨ³cuaa'n³ jó̱o̱², 'i³ mɨ³cuaa'n³ mɨ²³quie'², 'i³ mɨ³cuaa'n³ jo̱o̱³¹ 'e³ jua'³ rɨ³løn³¹ Dios juii², ");
INSERT INTO cnlNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ñúun³ cɨ² li²³xa³ quie'² mɨ³¹güii³ la³. Co̱'³ cɨ'²³ rɨ³ji̱'²³ ca³cuaa³ jmɨ́ɨ² 'e³ ja³guín²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","'E³ quie'²³ jo̱³ ca²³jén²³ ca³jné³ dsa³ gui²³tʉ̱́n³. Ca²³jua'³: ―Sɨ³gui²³²ra² juɨɨ³ Jerusalén, ¿mɨ³naa'³¹? Je² núu²³ rɨ²³jí̱i̱n²³ la²³jɨ³ 'e³ ca²³té̱e̱² ji³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² 'e³ rɨ²³jí̱i̱n²³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Qui² rɨ²³jɨ̱'n²te'²³ jné² quie'² dsa³ jia'³. Rɨ²³jáa² rɨ²³ŋɨ́ɨn²te'²³ jné². Bi²³ u²³'i'²³ rɨ²³jme'²³te'²³ jné². Rɨ²³'ø'n²te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Rɨ²³jmín²te'²³ jné². Rɨ²³jŋɨ'n²³te'²³ jné². 'E³ quie'²³ je² rɨ²³tɨ́²³ 'nɨ³ jmɨ́ɨ² 'e³ la²³ jú̱n²³na²³ rɨ²³ji̱i̱'n²³na²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² sɨ³dsaan³² te'²³ dsa³ quien³² júu² 'e³ ca²³lʉ́³. Qui² bi²³ ma²³'nee³ rɨ³jnɨ³, lǿn³te'²³. 'A²³jia'³ ta³nʉ́ʉ²³te'²³ 'e³ la²³ ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","'E³ la²³ ca²³lǿn²³ mɨ³lén² juɨɨ³ Jericó Jesús, jen³¹ coo³¹ jui³¹ jø̱n³ dsa³ tuu² 'i³ ŋɨɨ²³ cuu². ");
INSERT INTO cnlNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ca²³núu³ 'e³ 'i̱i̱² sɨ³ŋɨ́n³ juɨ́ɨn²³ dsa³. 'E³ jo̱³ ca²³ŋɨ́ɨ³ júu² 'e³ 'ee² júu² xa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","'E³ jo̱³ ca²³sɨ'²³te'²³ dsa³ tuu²: ―Sɨ³ŋɨ́n³ Jesús dsa³ Nazaret. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","'E³ quie'²³ jo̱³ ca²³lʉ́³ quiʉ̱ʉ̱³ dsa³ tuu². Ca²³jua'³: ―Jesús, dsa³ ju̱u̱n²³ David, cu²li³cuu'²³ 'áan² quia̱'n²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","'E³ quie'²³ ca²³jíi² dsa³ 'i³ sɨ³jén². Ca²³sɨ'²³te'²³ 'e³ cu²quín³. 'E³ quie'²³ dsɨ³² cɨ² ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³jua'³: ―Dsa³ ju̱u̱n²³ David, cu²li³cuu'²³ 'áan² quia̱'n²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","'E³ jo̱³ ca²³noo³ Jesús. Ca²³dxi³ 'i'²³ 'e³ sɨ³jen³te'²³ dsa³ tuu². Ma²ca¹lǿn¹ mɨ³lén² dsa³ tuu², ca²³jua'³ Jesús: ");
INSERT INTO cnlNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Jmii'³¹ cu³lø³¹ 'e³ 'naan³ 'e³ rɨ²jmeen²³² quién²nu³? 'E³ jo̱³ ca²³jua'³ dsa³ tuu²: ―Juiin²³, 'náan²³ 'e³ li²³jnéen²³ 'u². ");
INSERT INTO cnlNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ tuu²: ―Cu²li³jnen³²nu³ jo̱o̱²³na²³. Sɨ³táan³nu³. 'E³ jo̱³ mɨ³'láan³nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Xe̱'n² quie'²³ jo̱³ ca²³la²³jnée²³. 'E³ jo̱³ ca²³qui̱i̱³ Jesús. Ca²³mi²³gáan³ Dios. 'E³ quie'²³ la'³, ca²³mi²³gáan³ Dios la²³jɨn³ dsa³ 'i³ ŋó²³ 'e³ jmii'³¹ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","'Í² jee²³² juɨɨ³ Jericó Jesús. Ca²³ŋɨ́n³ jee²³² juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Núu²³ xen³ jø̱n³ dsa³ xoo³² 'i³ xi̱i̱n³ Zaqueo 'i³ rɨ³løn³¹ juii² 'io'². ");
INSERT INTO cnlNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","'Née²³ Zaqueo rɨ²³jóon² Jesús. 'E³ quie'²³ 'a²³jia'³ ca²³lǿ²³ juø'² xe̱'n². Qui² jø̱n³ dsa³ pi'n² 'uǿn²³ cu³løn³¹. Bi²³ juɨ́ɨn²³ dsa³ 'i³ té̱e̱n³ quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","'E³ jo̱³ ca²³jén² ca²³la²³dxí². Ca²³huɨ́ɨ³ yʉʉ'³¹ 'mo³ sicómoro 'e³ jua'³ 'née²³ rɨ²³jóon² ca³quie̱e̱² Jesús. Qui² ca³quie̱e̱² rɨ²³ŋɨ́n³ jui³¹ núu²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ma²ca¹dxóo¹ Jesús je² rɨ³dsɨn³² Zaqueo yʉʉ'³¹ 'mo³, ca²³jóo² yʉʉ'³¹. Ca²³jua'³ ca²³sɨ'²³ Zaqueo: ―Zaqueo, jiaan³² ca²³la²³dxí². Qui² quién²nu³ rɨ²cuaa'n²³na²³ jmɨ́ɨ² 'e³ rɨ³nɨ²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","'E³ jo̱³ ca²³jiaan³² ca²³la²³dxí² Zaqueo. Bi²³ jɨn³ dsɨ́² ca²³'i'n² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ma²ŋó¹ dsa³, bi²³ ca²³lʉ́³te'²³ i²³la³ i²³nɨ³. Ca²³jua'³te'²³: ―Jóo². Mɨ³'i³² quie'² dsa³ 'i³ bi²³ xa³ dsoo² quiee'³² je² mɨ³tøø³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","'E³ quie'²³ jo̱³ ca²³naa'n²³ 'ñée² Zaqueo. Ca²³jua'³ ca²³sɨ'²³ Juii³ra²: ―Juiin²³, rɨ²cuǿøn¹ dsa³ taan³ tu²³dso'² la²³'nɨɨ'n³¹ 'e³ xa³ quián²³. Co̱'³ cɨ'²³ te³ 'i̱i̱² sɨɨ'³¹ 'i³ mɨ³cǿ̱n²³ cuu² quiee'³² 'e³ mɨ³jme'n²³ sǿn²³, rɨ²jɨ̱'n¹ co̱'³ quiʉ̱́³ taa'² 'e³ la²³'nɨɨ'n³¹ 'e³ mɨ³cǿ̱n²³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Zaqueo: ―Jmɨ́ɨ² 'e³ rɨ³nɨ²³ mɨ³láan³ dsa³ 'i³ nee'n²³² xi²ñʉ'¹ la³. Qui² dsa³ ju̱u̱n²³ Abraham dsa³ la³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Qui² güén²³na²³ jné² Jo̱o̱³¹ Dsa³ 'e³ juø'n²³ rɨ²'naa'n³¹na¹ la²³jɨn³ dsa³ 'i³ mɨ³ca³caa'n³², 'e³ juø'n²³ rɨ²láan¹na²³ la²³jɨn³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ma²ca¹núu³ dsa³ 'e³ la²³ ca²³jua'³ Jesús, ca²³lʉ́³ 'ñée² co̱o̱³ júu² rɨ³jnɨ³. Qui² sɨ³lín³ mɨ³lén² juɨɨ³ Jerusalén. 'E³ jo̱³ lǿn³ dsa³ 'e³ xe̱'n² jmɨ́ɨ² rɨ²³jóo²te'²³ 'e³ jmii'³¹ lǿ² 'e³ rɨ³løn³¹ Dios juii² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","'E³ jo̱³ ca²³jua'³ Jesús: ―La²³ cu²ru'³ xen³ jø̱n³ dsa³ gáan³ 'i³ 'ne'² rɨ²³dsóo² je² huɨ̱́ɨ̱³ 'e³ sɨ³quié̱³ ta² 'e³ rɨ²³lín³ rey juɨɨ³ quiee'³². Jo̱³ hua² rɨ²³dsø'n² juɨɨ³ quiee'³² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","'E³ jo̱³ ca²³tøø³ guién²³ mozos quien³². Ca²³cuǿ³ guiá²³ cuu² 'e³ bi²³ quí̱i̱n²³. Ca²³cuǿø²³ co̱o̱³ cuu² cɨ'³ la²³ jø̱n³. Ca²³jua'³ ca²³sɨ'²³ mozos: “'Ne'² rɨ²jmée²ra'³ ta² quia̱'n²na'³ cuu² la³ 'e³ cu²xén³ la²³huøø'n³¹ 'e³ rɨ²³güe'n²³na²³ co̱'³”. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","'E³ quie'²³ bi²³ 'a²³jia'³ ta³dsɨ³² dsa³ juɨɨ³ quien³² quia̱'² dsa³ 'í³. 'E³ jo̱³ ca²³xíin²³te'²³ dsa³ je² ŋóo² 'ñée². Ca²³jua'³te'²³: “'A²³jia'³ 'nee³ra'³¹ 'e³ rɨ²³lín³ dsa³ 'í³ rey quien³²na'³¹”. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","'E³ quie'²³ 'ióo² quie'²³ júu² 'e³ rɨ²³lín³ rey juɨɨ³ quiee'³². Ma²ca¹dxe'n¹ co̱'³ quie'², ca²³dxi³ 'i'²³ 'e³ rɨ²³tøø³te'²³ co̱'³ mozos 'i³ ca²³cuǿø²³ cuu². Qui² 'née²³ rɨ²³dsóo²³ dsɨ́² 'e³ jmii'³¹ 'nɨɨ'n³¹ cuu² 'e³ mɨ³xen³² 'e³ mɨ³jmóo²te'²³ ta². ");
INSERT INTO cnlNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ca²³dxóo² mozo 'i³ xe̱'n². Ca²³jua'³: “Mɨ³xen³² cɨ² guiá²³ cuu² ma²ca¹lǿn¹ ma²ca¹'nɨ́ɨn¹ quia̱'n²³²na¹ cuu² quien³²nu³, ¿mɨ³naa'³¹?” ");
INSERT INTO cnlNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","'E³ jo̱³ ca²³jua'³ rey. Ca²³sɨ'²³ mozo 'í³: “Bi²³ dxʉ́²³ mɨ³jméen² 'nʉ³, mozo quién²³na²³. Bi²³ dxún²³nu³. Bi²³ dxʉ́²³ mɨ³jméen² ta² 'e³ ca²³cuǿøn²³na²³ 'nʉ³, juø'n³ quie'²³ ca³juɨ². 'E³ jo̱³ rɨ²cuǿøn¹na²³ 'nʉ³ ca³dsaan³² 'e³ rɨ²³lín³nu³ dxi² juɨɨ³ guiá²³ juɨɨ³ 'nɨɨ'n³¹.” ");
INSERT INTO cnlNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","'E³ jo̱³ ca²³dxóo² mozo 'i³ sɨ³tɨ́²³ áan²³. Ca²³jua'³: “Mɨ³xen³² 'ñé³ cuu² ma²ca¹lǿn¹ ma²ca¹'nɨ́ɨn¹ quia̱'n²³²na¹ cuu² quien³²nu³, ¿mɨ³naa'³¹?” ");
INSERT INTO cnlNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","'E³ jo̱³ ca²³jua'³ rey. Ca²³sɨ'²³ mozo 'í³: “Rɨ²cuǿøn¹na²³ 'nʉ³ ca³dsaan³² 'e³ rɨ²³lín³nu³ dxi² juɨɨ³ 'ñé³ juɨɨ³ 'nɨɨ'n³¹”. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","'E³ jo̱³ ca²³dxóo² jia'³ cɨ'²³ mozo. Ca²³jua'³: “'E³ la³ cuu² quien³²nu³. Te³ ca²³pe'n²³ paa²i². Ca²³'mén²³ dxʉ́²³ hua² cuu² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bi²³ 'ñaa'n²³na²³ 'nʉ³. Qui² maan²³ 'e³ jmii'³¹ jmeen³. Maan²³ 'e³ 'a²³jia'³ jmɨ́ɨ² caan³. Ca̱a̱n²³ 'nʉ³ la²³jɨ³ 'e³ 'a²³jia'³ née² guaan³² xe̱'n². Dxen³ guaan³² ta² je² 'a²³jia'³ ca²³jméen² jmo².” ");
INSERT INTO cnlNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","'E³ jo̱³ ca²³jua'³ rey. Ca²³sɨ'²³ mozo quien³²: “'A²³jia'³ dxʉ́²³ jmeen³ 'nʉ³, mozo quién²³na²³. Júu² 'aan³¹ mɨ³jmée³ lii²³ 'e³ joo'²³ rɨ²dxen²³² ta² quien³²nu³. Qui² máan³ 'nʉ³ 'e³ jmii'³¹ jmeen²³. Máan³ 'e³ 'a²³jia'³ jmɨ́ɨ² caan²³. Ca̱a̱n³² la²³jɨ³ 'e³ 'a²³jia'³ née² guaan²³. Dxen²³ guaan²³ ta² je² 'a²³jia'³ ca²³jméen²³ jmo². ");
INSERT INTO cnlNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿'Ee² lǿ² 'a²³jia'³ ca²³jɨ̱'n² cuu² quián²³ dsa³ 'i³ sɨ³li'²³ juø'² xen³² cuu²? Lǿ²³ juø'² ca²³cá̱a̱n² co̱'³ ca³ti³² quia̱'² jo̱o̱³¹ cuu² ma²mɨ³güe'n³²na²³ co̱'³ 'u² cu²ru'³ ca²³jméen² la'³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","'E³ jo̱³ ca²³sɨ'²³ dsa³ 'i³ té̱e̱n³ caan²³. Ca²³jua'³: “Rɨ²co̱o̱²³ra'³ cuu² 'e³ xe̱e̱'³ 'i³ la³ jo̱o̱²³na²³. Rɨ²cuøø³¹ra'³ mozo 'i³ xa³ guiá²³ 'nɨɨ'n³¹ cuu² quie'².” ");
INSERT INTO cnlNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","'E³ jo̱³ ca²³jua'³ dsa³ 'i³ té̱e̱n³ caan²³. Ca²³sɨ'²³te'²³ rey: “¿'Ee² lǿ² 'e³ juø'n³ 'e³ 'ne'² rɨ²³co̱o̱²³ cɨ² co̱'³? 'E³ quie'²³ xa³ guiá²³ cuu² quie'² 'i³ nɨ³ xú̱n³.” ");
INSERT INTO cnlNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'E³ quie'²³ ca²³jua'³ rey: “Rɨ²juøøn³¹na¹ 'nee'²³: Ñúun³ cɨ² rɨ²³'ióo²³ dsa³ 'i³ xa³ ca³juɨ² quie'² xe̱'n². 'E³ quie'²³ dsa³ 'i³ 'a²³'e³ xa³ quie'² xe̱'n², rɨ²³je̱'n²te'²³ la²³'nɨɨ'n³¹ qui³ 'e³ xa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Co̱'³ cɨ'²³, cu³jén²³na'³ la³ te'²³ dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² jné², dsa³ 'i³ 'a²³jia'³ 'née²³ 'e³ rɨ³løn³¹na¹ rey quien³²te'²³. 'E³ jo̱³ rɨ²jŋɨ'n²³na'³ dsa³ 'í³ xi²ñin²³ jné²”, ca²³jua'³ rey. ―La'³ cu³lø³¹ júu² 'e³ ca²³dxá³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ma²ca¹jua'³ la'³ Jesús, 'í² jui³¹ co̱'³. Ŋóo² co̱'³ juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ca²³lǿn²³ mɨ³lén² juɨɨ³ Betfagé quia̱'² juɨɨ³ Betania, coo³¹ mo'³ je² xi̱i̱n³ mo'³ Olivos. 'E³ jo̱³ ca²³xíin²³ áan²³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ca²³jua'³: ―Cu³guín²³na'³ jee²³² juɨɨ³ tu³'o³ la²³ xi²ñí²ra'³. Mɨ³rɨ³dxi³guín²³na'³ 'oo'² juɨɨ³, rɨ²³jí̱i̱n³na'³ jø̱n³ jo̱o̱³¹ burro 'i³ rɨ³'ñu'n² 'i³ 'a²³jia'³ lɨ'³ ca³cu³dsɨn³¹te'¹. 'E³ jo̱³ rɨ²ji̱i̱n²³na'³ burro. Rɨ²jøn²³na'³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Xi³nu³ xen³ 'i³ rɨ²³sɨ'²³ 'nee'²³: “¿'Ee² lǿ² ji̱i̱n²³na'³ burro nɨ³?” 'e³ jo̱³ rɨ²juɨɨ'³¹ra'³: “'Ne'² quie'² Juii³ra², ¿mɨ³naa'³¹?” ");
INSERT INTO cnlNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","'E³ quie'²³ jo̱³ ca²³guín²³ te'²³ dsa³ 'i³ ca²³xíin²³. Ca²³lǿ²³ 'e³ la²³ ca²³jua'³ 'ñée² 'e³ rɨ²³lí³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","'E³ la²³ ta'n² ji̱i̱n³²te'²³ burro, ca²³jua'³ te'²³ juii² burro. Ca²³sɨ'²³ dsa³ 'i³ ji̱i̱n³² burro: ―¿'Ee² lǿ² ji̱i̱n²³na'³ burro nɨ³? ");
INSERT INTO cnlNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","'E³ jo̱³ ca²³jua'³te'²³: ―'Ne'² quie'² Juii³ra², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","'E³ jo̱³ i²jøn²³te'²³ burro caan²³ Jesús. Ca²³dxá³te'²³ 'mɨɨ'³ quiee'³²te'²³ ñi'² quiee'³² burro. Jo̱³ tu³ ca²³xáan²te'²³ Jesús ñi'² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","'E³ la²³ 'iún² jui³¹ Jesús 'e³ cu³dsɨn³¹ burro, ca²³ti²³jó³ dsa³ 'mɨɨ'³ dxi²jui³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","'E³ la²³ sɨ³jiaan³² mo'³ Olivos, 'e³ la²³ sɨ³lín³ mɨ³lén² juɨɨ³ Jerusalén, ca²³lʉ́³ quiʉ̱ʉ̱³ la²³jɨn³ dsa³ quien³² 'e³ la²³'nɨɨ'n³¹ jɨn³ dsɨ́²te'²³. Ca²³mi²³gáan³te'²³ Dios 'e³ jua'³te'²³ bi²³ ñúun³ la²³jɨ³ u²³juø'²³ 'e³ ŋó²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ca²³jua'³te'²³: ―Mɨ³cuǿ³ Dios Juii³ra² u²³li²³jé̱e̱³ quie'² rey la³ 'i³ mɨ³ja³'ɨ́ɨn²³ 'e³ 'iin³¹ 'ñée². Mɨ³güén²³ 'e³ rɨ²³jmée²³ 'e³ rɨ²³lʉ́²³ dsa³ co̱o̱³ júu² quia̱'² Dios 'i³ jen³¹ yʉʉ'³¹ güii³. ¡Cu²mi³gáan³ dsa³ Dios 'i³ jen³¹ yʉʉ'³¹ güii³! ");
INSERT INTO cnlNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Xen³ dsa³ fariseo 'i³ ta'n² jee²³² quiee'³²te'²³. Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Dsa³ 'e²³, rɨ²jin²³nu³ dsa³ quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","'E³ quie'²³ ca²³jua'³ 'ñée²: ―Rɨ²juøøn³¹na¹ 'nee'²³: 'U² cu²ru'³ rɨ²³quín³ lʉ²³ dsa³ la³, cú̱u̱² la³ cɨ'²³ rɨ²³yo'²³ quiʉ̱ʉ̱³. Rɨ²³jmóo² júu² cú̱u̱² 'u² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ca²³lǿn²³ mɨ³lén² juɨɨ³ Jerusalén Jesús. Ca²³jóo² jee²³² juɨɨ³. Jo̱³ ca²³'o'². ");
INSERT INTO cnlNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","'E³ jo̱³ ca²³jua'³. 'É̱e̱² 'e³ ca²³lʉ́³ quia̱'² dsa³ Jerusalén: ―Bi²³ dxʉ́²³ cu²ru'³ ta³jmee³ra'³ 'i'²³ jmɨ́ɨ² 'e³ rɨ³nɨ²³ 'e³ jmii'³¹ lǿ² la²³jɨ³ 'e³ 'ne'² rɨ²jmée²ra'³ 'e³ la²³ li²³co̱o̱³ 'óo²ra'³ 'u². 'E³ quie'²³ 'a²³jia'³ ma²³ jmɨ́ɨ² rɨ²³lí³ juø'² rɨ²jmée²ra'³ 'i'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","'E³ cɨ² rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ rɨ²³jmóo² 'ioo'³ la²³cu'² juɨɨ³ quien³²na'³ dsa³ 'i³ nɨ́ɨn³ quia̱'² 'nee'²³. Rɨ²³gua³te'²³ la²³cu'² juɨɨ³. Rɨ²³jniin²³te'²³ joo³¹ i²³la³ i²³nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Rɨ²³'ló²te'²³ juɨɨ³. Rɨ²³mi²³gua'²³te'²³ la²³jɨn³ sú̱n² dsa³ juɨɨ³. Cu³xi³ co̱o̱³ cú̱u̱² 'a²³jia'³ ma²³ jmɨ́ɨ² rɨ²³te'n²te'²³ mɨ³rɨ³jee'n³te'²³ 'ñʉ́². La'³ cu³lø³¹ rɨ²³lí³. Qui² 'a²³jia'³ jmɨ́ɨ² ca³la³quin³na'³ 'e³ güén²³ Dios quién²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","'E³ jo̱³ 'í² Jesús ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Ca²³'uøøn³ dsa³ 'i³ 'nɨɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ―To̱o̱²³ ji³ júu² quiee'³² Dios: “Rɨ²³jua'³te'²³ 'ñʉ́² je² lʉ²³ dsa³ quia̱'² Dios rɨ²³'e²³te'²³ 'ñʉ́² je² mi³gáan³te'²³ jné²”. 'E³ quie'²³ mɨ³jmée²ra'³ 'é̱e̱² 'ñʉ́² je² nee'n²³² dsa³ 'i̱i̱³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Cɨ'³ la²³ co̱o̱³ jmɨ́ɨ² 'e²³ Jesús ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. 'Née²³ rɨ²³jŋɨ'n²³ Jesús te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley quia̱'² te'²³ juii² dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","'E³ quie'²³ 'a²³jia'³ ca²³dso'²³te'²³ 'e³ jmii'³¹ rɨ²³lí³ juø'² rɨ²³jŋɨ'n²³te'²³. Qui² bi²³ 'née²³ la²³jɨn³ dsa³ júu² 'e³ lʉ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ca²³tɨ́³ jmɨ́ɨ² 'e³ ca²³'ée²³ dsa³ Jesús ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Ca²³'ɨ́ɨ³ júu² dxʉ́²³ quiee'³² Dios. Ca²³lǿn²³ mɨ³lén² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley quia̱'² te'²³ dsa³ mɨ³dxún²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Rɨ²juɨɨ'n³¹nu³ jnee'³¹ 'e³ 'ee² ta² quié̱n² 'e³ jmeen³ la²³jɨ³ 'e³ jmeen³. ¿'I̱i̱² sɨɨ'³¹ 'i³ ca²³cuǿø²³ 'nʉ³ ta² 'e³ quié̱n²? ");
INSERT INTO cnlNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Xa³ co̱o̱³ júu² 'e³ rɨ²ŋɨ'n¹na²³ 'nee'²³ jné² co̱'³. Rɨ²juɨɨ'³¹ra'³ jné² jo̱o̱²³na²³: ");
INSERT INTO cnlNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿'I̱i̱² sɨɨ'³¹ 'i³ ca²³cuǿ³ ta² 'e³ có̱²³ Juan 'e³ ca²³xáan² dsa³ jmɨɨ³? ¿'A² Dios 'i³ jen³¹ yʉʉ'³¹ güii³ ca²³cuǿ³ ta² 'e³ có̱²³? ¿'A² dsa³ hua² ca²³cuǿ³ ta² 'e³ có̱²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","'E³ jo̱³ ca²³sɨ́n²³ júu² la²³ co̱³quie'² miin²³. Ca²³jua'³te'²³: ―¿Jmii'³¹ cu³lø³¹ rɨ²juaa'²ra² cu²ne²ra²? Qui² xi³nu³ rɨ²juaa'²ra²: “Dios ca²³cuǿ³ ta² 'e³ ca²³jmée³ Juan”, 'e³ jo̱³ rɨ²³jua'³ 'ñée²: “¿'Ee² lǿ² 'a²³jia'³ ca²³táan³na'³ júu² 'e³ ca²³lʉ́³ jo̱o̱²³na²³?” ");
INSERT INTO cnlNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'E³ quie'²³ xi³nu³ rɨ²juaa'²ra²: “Dsa³ hua² ca²³cuǿ³ ta² 'e³ có̱²³”, bi²³ rɨ²³cuǿ²³ cú̱u̱² quiée²ra² la²³jɨn³ dsa³. Qui² sɨ³táan³te'²³ 'e³ ca³quie̱e̱² ca²³'ɨ́ɨ³ Juan júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","'E³ jo̱³ ca²³jua'³te'²³: ―'A²³jia'³ ne³ra'³¹ 'e³ 'i̱i̱² sɨɨ'³¹ ca²³cuǿ³ ta² 'e³ có̱²³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'E³ quie'²³ la'³, 'a²³jia'³ jmɨ́ɨ² rɨ²juøøn³¹na¹ 'nee'²³ 'e³ 'i̱i̱² sɨɨ'³¹ ca²³cuǿ³ ta² 'e³ quie̱e̱n²³² 'e³ jmeen²³ 'e³ la²³ jmeen²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","'E³ quie'²³ jo̱³ ca²³tín²³ ca²³lʉ́³ Jesús júu² la³ 'e³ jmee²³ lii²³ 'e³ jmii'³¹ lǿ² rɨ²³jme'²³te'²³ 'ñée². Ca²³jua'³: ―La²³ cu²ru'³ xen³ jø̱n³ dsa³ 'i³ ca²³jñi³ xoo'³¹ jø'² 'uǿ²³ quiee'³². Jo̱³ tu³ ca²³cuǿø²³ dsa³ 'uǿ²³ quiee'³² 'e³ rɨ²³jmóo²te'²³ ta² quiee'³² xoo'³¹ jø'². 'E³ quie'²³ jo̱³ bi²³ huǿø³ ŋóo² 'ñée² co̱o̱³ juɨɨ³ je² bi²³ huɨ̱́ɨ̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ma²ca¹tɨ́³ ji̱i̱³ 'e³ jioo³² dsa³ mɨ²jø'², ca²³xíin²³ jø̱n³ mozo quien³². 'E³ jo̱³ ŋóo² mozo i²joon³ dsa³ 'i³ mi³qui³ xoo'³¹ jø'². Ca²³ŋɨ'²³ ca³juɨ² mɨ²jø'² jñii³¹ 'uǿ²³. 'E³ quie'²³ 'a²³jia'³ ca²³la²³dxʉ́²³ dsɨ́²te'²³ 'e³ rɨ²³jɨ̱'²te'²³. Te³ ca²³cuǿ³te'²³ quie'² mozo 'i³ ca²³xíin²³ juii² 'uǿ²³. 'A²³'e³ xa³ jñii³¹ 'uǿ²³ 'e³ quie̱³ mozo 'e³ la²³ ca²³cu²³dxe'n³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","'E³ quie'²³ jo̱³ ca²³xíin²³ juii² jia'³ cɨ'²³ mozo co̱'³. 'E³ jo̱³ ca²³cuǿ³te'²³ quie'² mozo 'í³ co̱'³. Bi²³ u²³'i'²³ ca²³jme'²³te'²³ mozo 'í³. 'A²³'e³ xa³ jñii³¹ 'uǿ²³ 'e³ quie̱³ mozo 'í³ 'e³ la²³ ca²³cu²³dxe'n³te'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","'E³ quie'²³ jo̱³ ca²³xíin²³ juii² jia'³ cɨ'²³ mozo je² sɨ³tɨ́²³ aan³. Ca²³jme'²³te'²³ mozo 'í³ co̱'³. Bi²³ xa³ je² ca²³lǿ²³ quie'². Jo̱³ tu³ ca²³dxin³te'²³ mozo. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’'E³ jo̱³ ca²³lǿn³ juii² xoo'³¹ jø'²: “¿Jmii'³¹ rɨ²jmeen²³² cu²ne²ra²? Ja̱a̱n²³ 'i³ bi²³ 'náan²³na²³ cɨ'²³ rɨ²sɨɨn³¹na¹ co̱'³. Co̱'³ xi² rɨ²³'áa²³te'²³ u²³go³ u²³'iʉʉ²³ quia̱'²te'²³ ja̱a̱n²³”, lǿn³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ma²ŋo²³² dsa³ 'i³ jmoo³² ta² quiee'³² xoo'³¹ jø'² 'e³ mɨ³dxóo² jo̱o̱³¹, ca²³sɨ́n²³ miin²³ la²³ co̱³quie'²: “'I³ la³ dsa³ 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³'ióo²³ 'uǿ²³ mɨ³rɨ³jú̱n³ jmii³. Mɨ²³gui²³²ra². Mɨ²³jŋɨ'n²³na² jo̱o̱²³na²³. Qui² jo̱³ hua² rɨ²³'ióo²³ra² miin²³na² 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³'ióo²³ 'ñée².” ");
INSERT INTO cnlNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'E³ quie'²³ jo̱³ ca²³juén²te'²³ rɨ²³co'²³ 'iá³. Jo̱³ tu³ ca²³jŋɨ'n²³te'²³. ’¿Jmii'³¹ rɨ²³jmée²³ juii² 'uǿ²³ rɨ²³jme'²³ dsa³ 'í³, lǿn³na'³? ");
INSERT INTO cnlNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Rɨ²³güe'n²³ co̱'³. Rɨ²³jŋɨ'n²³ dsa³ 'i³ jmoo³² ta² quiee'³² xoo'³¹ jø'², ¿mɨ³naa'³¹? Rɨ²³cuǿø²³ jia'³ cɨ'²³ dsa³ 'uǿ²³ quiee'³² 'e³ cu²jmóo¹te'²³ ta² quiee'³² xoo'³¹ jø'². ―La'³ ca²³jua'³ Jesús. Ma²ca¹núu³te'²³ júu² 'e³ ca²³lʉ́³, ca²³jua'³te'²³: ―¡'A²³jia'³ 'ne'² rɨ²³lí³ la'³! ");
INSERT INTO cnlNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","'E³ quie'²³ Jesús ca²³jóon² dsa³. Ca²³jua'³: ―¿Jmii'³¹ cu³lø³¹ 'née²³ rɨ²³jua'³ júu² quiee'³² Dios 'e³ to̱o̱²³ ji³, lǿn³na'³? Qui² to̱o̱²³ ji³ je² jua'³: 'Ñée² cú̱u̱² 'e³ tó̱o̱²³ tɨ³² 'e³ jua'³ 'a²³jia'³ 'nee'³¹ mɨ³lǿ²³ cú̱u̱² 'e³ quie̱³ biin²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tʉʉ² la²³ cɨ² rɨ²³'níin³ dsa³ 'i³ rɨ²³'lǿn²³ ñi'² cú̱u̱² 'e³ 'øn²³. Juɨ² 'laa³ la²³ cɨ² rɨ²³lín³ dsa³ 'i³ rɨ³taa'³ cú̱u̱² jo̱³ ñi'² quiee'³². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","'Née²³ juii² jmii³ dsa³ quia̱'² dsa³ 'e²³ ley 'e³ xe̱'n² quie'²³ jo̱³ rɨ²³sø̱'n²te'²³ Jesús. Qui² ca²³la²³quii²³te'²³ 'e³ miin²³ hua² ca²³'én² Jesús ma²ca¹lʉ́³ júu² quiee'³² xoo'³¹ jø'². 'E³ quie'²³ bi²³ 'ñaa'n²³te'²³ dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ca²³jmóo² 'i'²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley 'e³ jmii'³¹ rɨ²³li²³tɨ́ɨ²³ quie'²te'²³. 'E³ jo̱³ ca²³xíin²³te'²³ dsa³ 'i³ ca²³tén² Jesús. Ca²³jmóo²te'²³ 'e³ bi²³ 'née²³te'²³ 'e³ rɨ²³núu²³te'²³ júu² quiee'³² Jesús. 'E³ quie'²³ te³ ca²³jmóo²te'²³ guóo². Qui² 'née²³te'²³ rɨ²³jáan²³te'²³ júu² quiee'³² 'e³ la²³ rɨ²³lí³ juø'² rɨ²³ta̱a̱'n³te'²³ guoo³ dxi² juɨɨ³ pii'². ");
INSERT INTO cnlNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Dsa³ 'e²³, ne³ra'³¹ 'e³ lʉ́n² 'e³ ca³dsaan³², 'e³ 'en³ ca³dsaan³². 'A²³jia'³ jmeen³ 'i'²³ xi³ gáan³ dsa³, xi² la³dsɨɨ³² dsa³. Lʉ́n² ju²dsoo³¹ 'e³ la²³ 'en³ jui³¹ quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿'A² rɨ²jméen² co̱o̱³ mɨ²'áa² rɨ²juɨɨ'n³¹nu³ jnee'³¹ xi² joo'²³ 'e³ rɨ²qui²³²ra² cuu² 'e³ cu'n³² 'io'² 'i³ xiin²³ dxi² juɨɨ³ César? ");
INSERT INTO cnlNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","'E³ quie'²³ ñi³² Jesús 'e³ jmii'³¹ 'nɨɨ'n³¹ jmoo³²te'²³ lá³. 'E³ jo̱³ ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ 'i³ co̱³² tóo³: ―¿'Ee² lǿ² 'e³ 'noo³ra'³ rɨ²jmée²ra'³ lá³ quia̱'n²na'³ jné²? ");
INSERT INTO cnlNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ja³ maan²³² la³ co̱o̱³ cuu². ¿'I̱i̱² sɨɨ'³¹ quie'² ne'n² 'e³ to̱o̱²³ la³? ¿'I̱i̱² sɨɨ'³¹ quie'² nombre 'e³ to̱o̱²³? ―'E³ quiee'³² dxi² juɨɨ³ César ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Rɨ²cuøø³¹ra'³ dxi² juɨɨ³ la²³jɨ³ 'e³ quiee'³² dxi² juɨɨ³. 'E³ quie'²³ rɨ²cuøø³¹ra'³ Dios la²³jɨ³ 'e³ quiee'³² 'ñée² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","'E³ jo̱³ 'a²³jia'³ ca²³lǿ²³ juø'² ca²³jáan³te'²³ júu² quiee'³² xi²ñi² dsa³. 'E³ quie'²³ te³ ca²³cɨ́n³ ca²³gǿn³te'²³. Qui² bi²³ juø'²³ ca²³núu³te'²³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Xen³ dsa³ saduceo 'i³ ca²³dxi²³guín²³ caan²³ Jesús. Jua'³ dsa³ saduceo 'e³ 'a²³jia'³ sɨ³ji̱i̱'²³ dsa³ co̱'³. Xa³ co̱o̱³ júu² 'e³ ca²³ŋɨ'²³te'²³ Jesús. Ca²³jua'³te'²³: ");
INSERT INTO cnlNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Dsa³ 'e²³, la²³la³ cu³lø³¹ jua'³ ji³ 'e³ ca²³jmée³ Moisés 'e³ xa³ quiée²ra², ¿mɨ³naa'³¹?: Xi³nu³ rɨ²³jú̱n³ jø̱n³ dsa³ 'i³ xen³ mɨ²³quie'², 'e³ quie'²³ 'a²³'i̱³ xen³ jo̱o̱³¹, 'ne'² rɨ²³tǿø²³ mɨ́³ 'nɨ́ɨ³ jó̱o̱² dsa³ 'i³ jú̱n²³ 'e³ jua'³ cu²li³xen³ 'é̱e̱² jo̱o̱³¹ 'lɨ² jó̱o̱². La'³ cu³lø³¹ jua'³ ji³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Xen³ guiáan²³ dsa³ la²³ ca³já̱a̱n². Tǿø² mɨ́³ jó̱o̱² 'i³ cua̱a̱n²³. 'E³ quie'²³ 'íi² li²³xen³ jo̱o̱³¹ 'e³ jú̱n²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tǿø² mɨ́³ 'nɨ́ɨ³ 'í³ jó̱o̱² 'i³ sɨ³tɨ́²³ áan²³. 'E³ quie'²³ 'íi² li²³xen³ jo̱o̱³¹ 'e³ jú̱n²³ 'i³ 'í³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","'E³ jo̱³ tǿø² mɨ́³ 'nɨ́ɨ³ 'í³ jó̱o̱² 'i³ sɨ³tɨ́²³ aan³. 'E³ quie'²³ la'³ la²³jɨn³. 'E³ quie'²³ 'a²³'i̱³ jo̱o̱³¹ ca²³la²³xen³ cɨ'³ la²³ jø̱n³ 'e³ jú̱n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Je² dsøn³ cɨ² jú̱n²³ 'ñée² mɨ́³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿'I̱i̱² quién² mɨ́³ 'í³ mɨ³rɨ³ji̱i̱'²³ dsa³ co̱'³ cu²ne²ra²? Qui² ca²³la²³quia̱'² la²³jɨn³ guiáan²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ saduceo: ―Tøø²³ mɨ́³ dsa³ 'i³ xen³ mɨ³¹güii³ la³. Cuøn³² dsa³ mɨ́³ 'e³ tøø²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","'E³ quie'²³ 'a²³la³ ma²³ la'³ rɨ²³jmóo² dsa³ 'i³ jua'³ Dios 'e³ joo'²³ rɨ²³ji̱i̱'²³ co̱'³ yʉʉ'³¹ güii³. Núu²³ 'a²³jia'³ ma²³ rɨ²³tǿø²³ dsa³ mɨ́³. 'E³ quie'²³ 'a²³ cɨ'²³ ma²³ rɨ²³cuǿn² jo̱²³mɨɨ³¹ quie'² dsóo²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Qui² 'a²³jia'³ ma²³ rɨ²³lí³ juø'² rɨ²³jú̱n³ dsa³ núu²³. Núu²³ xen³te'²³ la²³ xen³ ángeles. Rɨ³løn³¹ jo̱o̱³¹ Dios la²³jɨn³. Qui² mɨ³ji̱i̱'n²³te'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ca²³jmée³ lii²³ 'ñée² Moisés 'e³ sɨ³ji̱i̱'²³ dsa³ co̱'³. Jmee²³ lii²³ júu² quiee'³² Dios je² to̱o̱²³ 'e³ jmii'³¹ lǿ² 'e³ 'iún² Dios xoo'³¹ nuu³ ma²ca¹lʉ́³ quia̱'² Moisés. La²³la³ cu³lø³¹ ca²³jua'³: “Dios juii² Abraham hua² jné². Dios juii² Isaac. Dios juii² Jacob co̱'³.” La'³ cu³lø³¹ to̱o̱²³ ji³ je² 'en³² Dios Juii³ra². ");
INSERT INTO cnlNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Qui² 'a²³jia'³ rɨ³løn³¹ Dios juii² dsa³ 'i³ rɨ³jú̱n². 'E³ quie'²³ rɨ³løn³¹ juii² dsa³ 'i³ rɨ³ji̱'²³. Rɨ³ji̱'²³ quie'²³ dsɨ́² la²³jɨn³ dsa³ ji̱'²³ Dios, juø'n³ quie'²³ mɨ³xa³ jmɨ́ɨ² jú̱n²³ jmɨ² ŋu². ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ saduceo. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","'E³ jo̱³ ca²³jua'³ ca³dxáan² dsa³ 'e²³ ley: ―Dsa³ 'e²³, bi²³ dxʉ́²³ mɨ³lʉ́n². ");
INSERT INTO cnlNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","'A²³jia'³ ma²³ ca²³la²³bii²³ dsɨ́²te'²³ 'e³ ca²³ŋɨ'²³te'²³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Co̱'³ cɨ'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ saduceo: ―¿Jmii'³¹ lǿ² 'e³ jua'³te'²³ 'e³ dsa³ ju̱u̱n²³ David rɨ³løn³¹ Cristo 'i³ rɨ²³xíin²³ Dios? ");
INSERT INTO cnlNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Qui² 'ñée² David ca²³jua'³ 'e³ la²³ to̱o̱²³ ji³ 'e³ xi̱i̱n³ Salmos je² 'en³² Cristo. La²³la³ cu³lø³¹ ca²³jua'³: Ca²³jua'³ Dios Juii³ra². Ca²³sɨ'²³ Juiin²³: “Ñí³ jaan²³na²³ 'e³ dxʉ́²³ ");
INSERT INTO cnlNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","la²³huø'n²³ rɨ²jmeen²³² 'e³ rɨ²³lín³nu³ juii² dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² 'nʉ³”. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Juiin²³ ca²³jua'³ David, ca²³'én² Cristo. ¿Jmii'³¹ lǿ² 'e³ rɨ³løn³¹ Cristo ju̱u̱n²³ David xi³nu³ la'³ cu³lø³¹ ca²³jua'³? Qui² rɨ³løn³¹ juii² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Je² nuu³ la²³jɨn³ dsa³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ");
INSERT INTO cnlNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―'A²³ rɨ³co̱³ra'³ tɨ³² 'i'²³ quiee'³² dsa³ 'e²³ ley. Qui² bi²³ mi³gáan³ miin²³. Bi²³ la²³ŋɨ́²³te'²³ la²³ca̱a̱n³ 'e³ quii'³te'²³ cuo̱o̱³ cuaa³. 'Née²³te'²³ 'e³ rɨ²³cuǿ²³ dsa³ u²³juee'n³¹ quia̱'²te'²³ je² dxa²³ dsa³ 'moo'². 'Née²³te'²³ 'e³ rɨ²³gua³te'²³ je² dxʉ́²³ cɨ² ñʉ'²³ 'ñʉ́² je² mi³gáan³ dsa³ Dios. 'Née²³te'²³ rɨ²³gua³te'²³ sii³¹ je² gua³ dsa³ gáan³ 'e³ la²³ tøø³te'²³ 'e³ rɨ²³e'². ");
INSERT INTO cnlNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Je̱'n³²te'²³ 'ñʉ² mɨ́³ 'nɨ́ɨ³. Bi²³ huǿø³ lʉ²³te'²³ quia̱'²te'²³ Dios 'e³ jua'³ cu²jóo¹ dsa³. 'E³ jo̱³ bi²³ cɨ² rɨ²³jmée²³ Dios jñiin²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ŋó²³ Jesús 'e³ la²³ ca²³to'²³ cuu² te'²³ dsa³ xoo³² 'e̱'³ guóo² je² too'²³te'²³ cuu² ñʉ'²³ 'ñʉ́² gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ŋó²³ 'e³ la²³ ca²³to'²³ tú̱²³ cu²laa'³ pii'² jø̱n³ mɨ́³ 'nɨ́ɨ³ 'i³ bi²³ taan³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","'E³ jo̱³ ca²³jua'³: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Ñúun³ cɨ² mɨ³to'²³ mɨ́³ 'nɨ́ɨ³ 'i³ taan³ la³ la²³ cɨ'²³ la²³jɨn³ jia'³ cɨ'²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Qui² bi²³ ñúun³ mɨ³tø'n² quie'²te'²³ 'e³ la²³ mɨ³to'²³te'²³ cuu². 'E³ quie'²³ bi²³ 'a²³'e³ xa³ quie'² 'ñée² mɨ́³ 'nɨ́ɨ³. Mɨ³to'²³ quie'²³ 'ñée² la²³'nɨɨ'n³¹ qui³ jue'² 'e³ xa³ quie'² 'e³ rɨ²³lí³ juø'² rɨ²³tɨ́n²³ 'e³ rɨ²³e'² 'u². ");
INSERT INTO cnlNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Xen³ dsa³ 'i³ ca²³lʉ́³ ca²³'é³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Ca²³jua'³te'²³ 'e³ bi²³ ma²³'nee³ lii'² cu³lø³¹. Qui² bi²³ xa³ cú̱u̱² lii'². Xa³ la²³jɨ³ 'e³ dxʉ́²³ 'e³ ca²³cuǿ³ dsa³. 'E³ jo̱³ ca²³jua'³ Jesús: ");
INSERT INTO cnlNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―'E³ cɨ² rɨ²³gua'²³ la²³jɨ³ 'e³ joo³²ra'³ nɨ³. 'E³ cɨ² rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ cu³xi³ co̱o̱³ cú̱u̱² 'a²³jia'³ ma²³ rɨ²³te'n²te'²³ mɨ³rɨ³jee'n³te'²³ 'ioo'³ la³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Dsa³ 'e²³, ¿lɨɨ'³¹ rɨ²³lí³ 'e³ la²³ mɨ³jue'n² ca³dxa³? ¿Jmii'³¹ rɨ²³li²³lii²³ 'e³ mɨ³ rɨ²³tɨ́²³ 'e³ rɨ²³lí³ la'³? ");
INSERT INTO cnlNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","'E³ jo̱³ ca²³jua'³ 'ñée²: ―Rɨ³móo³ra'³. Qui² bi²³ juø'² rɨ²³jmóo² dsa³ 'e³ rɨ²³sɨ²³caa'n³²na'³. Juɨ́ɨn²³ dsa³ 'i³ rɨ²³ja²³guín²³ 'i³ rɨ²³jua'³ 'e³ rɨ³løn³¹te'¹ jné²: “Cristo jné²”, rɨ²³jua'³te'²³. “Rɨ³nɨ²³ mɨ³tɨ́³ jmɨ́ɨ²”, rɨ²³jua'³te'²³. 'A²³ rɨ³qui̱i̱'³²ra'³ dsa³ 'i³ rɨ²³jua'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Co̱'³ cɨ'²³ rɨ²núu²ra'³ 'e³ sɨ³lí³ qui³, 'e³ sɨ³lí³ sɨ³dxóo³ dsa³. 'E³ quie'²³ 'a²³jia'³ 'ne'² rɨ²juø'n¹na'³ miin²³na'³ mɨ³rɨ³nuu³ra'³ la'³. Qui² 'ne'² rɨ²³lí³ la'³ jén²³ cɨ² 'e³ la²³ rɨ²³dxá³ jmɨ́ɨ². 'A²³jia'³ ca²³tɨ́³ 'e³ rɨ²³dxá³ jmɨ́ɨ² mɨ³rɨ³li³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ca²³jua'³ co̱'³ Jesús: ―Rɨ²³níin³ co̱o̱³ ta'n² dsa³ quia̱'² jia'³ cɨ'²³. Rɨ²³níin³ jø̱n³ dxi² juɨɨ³ quia̱'² jia'³ cɨ'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bi²³ 'uaa'³ rɨ²³bɨ́² 'uǿ²³. Ñúun³ juɨɨ³ je² li²³'oon²³ 'e³ rɨ²³e'² dsa³. Bi²³ rɨ²³sɨ²³too'² dsóo². Bi²³ juø'²³ cu³lø³¹ la²³jɨ³ 'e³ rɨ²³lí³ yʉʉ'³¹, la²³jɨ³ 'e³ rɨ²³mi²³sɨ́ɨn²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’'E³ quie'²³ 'íi² rɨ²³lí³ la'³ rɨ²³sø̱'n²te'²³ 'nee'²³. Bi²³ rɨ²³cuǿø²³te'²³ 'nee'²³ u²³ŋɨ́³ dsɨ́ɨ². Rɨ²³jɨ̱'n²te'²³ 'nee'²³ 'e³ cu²née¹ ta² quien³²na'³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. Rɨ²³ta̱a̱'n³te'²³ 'nee'²³ i²³ñí². Rɨ²³sɨ²³jøn²³te'²³ 'nee'²³ xi²ñi² reyes quia̱'² dxi² juɨɨ³ pii'² 'e³ jua'³ rɨ³løn³¹na'³ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","'E³ jo̱³ hua² li²³xa³ 'é̱e̱² 'e³ rɨ²lʉ́²ra'³ júu² quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","'Ne'² xi²dsɨ́n³na'³ jén²³ cɨ² 'e³ 'a²³jia'³ rɨ²mi³su̱³¹ra'³ júu² 'e³ rɨ²lʉ́²ra'³ mɨ³rɨ³jme'²³te'²³ 'nee'²³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Qui² jné² rɨ²jmeen²³² 'e³ rɨ²³lí³ juø'² rɨ²lʉ́²ra'³. Jné² rɨ²jmeen²³² 'e³ rɨ²³ti²³guo² júu² 'e³ rɨ²lʉ́²ra'³ 'e³ la²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³ji̱i̱n³ júu² dsa³ 'i³ 'noo³ júu². 'A²³jia'³ rɨ²³lí³ juø'² rɨ²³jua'³te'²³ 'e³ 'a²³jia'³ 'e̱'n³ júu² 'e³ rɨ²lʉ́²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Rɨ²³jɨ̱'n² dsa³ 'nee'²³, juø'n³ quie'²³ xoo³ra'³, juø'n³ quie'²³ ñʉ'²ra'³, juø'n³ quie'²³ jó̱o̱²ra'³, juø'n³ quie'²³ 'i̱i̱² sɨɨ'³¹ 'i³ xen³ quién²na'³, juø'n³ quie'²³ dsa³ 'i³ bi²³ dxʉ́²³ lʉ́²ra'³ quia̱'n²na'³. Xen³ 'nee'²³ 'i³ rɨ²³jŋɨ'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Rɨ²³lí³ 'e³ hui²³dsɨ́ɨn² ñin³² 'nee'²³ la²³jɨn³ dsa³ 'e³ jua'³te'²³ rɨ³løn³¹na'³ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","'E³ quie'²³ cu³xi³ co̱o̱³ mɨɨ'n²³ jñʉ³ dxí²ra'³ 'a²³jia'³ rɨ²³gua'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Rɨ³ji̱'²³ 'óo²ra'³ xi³nu³ rɨ²³tén²na'³ la²³jɨ³ 'e³ rɨ²³jí̱i̱n²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Mɨ³'áa³ 'i'²³ 'e³ mɨ³ rɨ²³gua'²³ juɨɨ³ Jerusalén mɨ³rɨ³joo³²ra'³ 'e³ láa²³ jni²³ la²³cu'² juɨɨ³ dsa³ 'láa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","'E³ jo̱³ 'ne'² rɨ²³cuɨ̱́ɨ̱² sɨ³guín²³ je² bi²³ xa³ mo'³ dsa³ 'i³ nee'n²³² estado Judea. 'Ne'² rɨ²³'uǿøn²³ dsa³ 'i³ nee'n²³² jee²³² juɨɨ³ Jerusalén. 'A²³jia'³ 'ne'² sɨ³guín²³ jee²³² juɨɨ³ dsa³ 'i³ nee'n²³² 'ioo³¹ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Qui² sɨ³tɨ́²³ jmɨ́ɨ² 'e³ lǿn³ Dios 'e³ rɨ²³jmée²³ jñiin²³ dsa³ 'i³ xa³ dsoo² quiee'³². Sɨ³tɨ́²³ jmɨ́ɨ² 'e³ rɨ²³lí³ la²³jɨ³ 'e³ to̱o̱²³ ji³ 'e³ rɨ²³lí³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Bi²³ juɨɨ³² mɨ́³ 'i³ huǿøn³ xi³yu̱u̱n³ quie'² mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³! ¡Bi²³ juɨɨ³² mɨ́³ 'i³ tʉ'n³² xi³yu̱u̱n³ co̱'³! Qui² bi²³ ma²³'nee³ rɨ²³dxi²³quié̱n² dsa³ 'i³ nee'n²³² 'uǿ²³ la³. Rɨ²³dxá²³ Dios ta² quiee'³² dsa³ 'i³ xen³ je² la³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Boo'³¹ rɨ²³jŋɨ'n²³te'²³ ca³dxáan² mɨ³rɨ³li³ qui³. Rɨ²³sø̱'n²te'²³ ca³dxáan² 'e³ rɨ²³sɨ²³jøn²³te'²³ la²³ca̱a̱n³ juɨɨ³ quiee'³² jia'³ cɨ'²³ dsa³. Qui² 'a²³jia'³ ma²³ rɨ²³'ióo²³te'²³ júu² 'e³ rɨ²³gua³te'²³ juɨɨ³ quiee'³²te'²³. Rɨ²³yáan²te'²³ tén³ la²³ cɨ² juɨɨ³ Jerusalén. Rɨ²³yáan² dsa³ jia'³ xi³'lɨ² rɨ²³dxá³ jmɨ́ɨ² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Co̱'³ cɨ'²³ xa³ 'e³ rɨ²³ji̱'²³ ñi'² quia̱'² sɨɨ'³ quia̱'² li²³'áan² 'e³ rɨ²³mi²³sɨ́ɨn²³. 'E³ quie'²³ ñi'² 'uǿ²³ la³ bi²³ rɨ²³ŋɨ́³ dsɨ́² dsa³. 'A²³jia'³ ñi³²te'²³ 'e³ jmii'³¹ rɨ²³jmóo²te'²³ la²³'nɨɨ'n³¹ 'e³ rɨ²³'i̱i̱² jmɨ²³ñii'³¹, 'e³ la²³'nɨɨ'n³¹ 'e³ rɨ²³xáan² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Rɨ²³lí³ 'e³ 'a²³jia'³ ma²³ quii²³ dsa³ 'e³ la²³'nɨɨ'n³¹ 'e³ rɨ²³jue'n² miin²³. Bi²³ rɨ²³jmóo²te'²³ 'i'²³ 'e³ jmii'³¹ rɨ²³lí³ mɨ³¹güii³ la³. Qui² bi²³ rɨ²³bɨ́n² 'i³ 'uee'n³ 'i³ rɨ³pee'n³² mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jmɨ́ɨ² jo̱³ rɨ²³ñín²te'²³ jné² Jo̱o̱³¹ Dsa³ 'e³ la²³ aa'n³²na²³ co̱'³ jee²³² jníi². Bi²³ 'uee'n²³na²³ mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³. Bi²³ gáan³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mɨ³rɨ³li³láa²³ 'e³ rɨ²³lí³ 'e³ la²³ mɨ³juǿøn²na²³ 'nee'²³, 'ne'² rɨ²jmée²ra'³ 'e³ jɨn³ 'óo²ra'³. Rɨ²joo³¹ra'³ yʉʉ'³¹. Qui² sɨ³lí³ mɨ³lén² 'e³ rɨ²³láan³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Co̱'³ cɨ'²³ ca²³lʉ́³ Jesús co̱o̱³ júu² rɨ³jnɨ³. Ca²³jua'³: ―'Ne'² rɨ²jmée²ra'³ 'i'²³ 'e³ jmii'³¹ jmee²³ 'mo³ higo, 'e³ jmii'³¹ jmee²³ la²³jɨ³ 'mo³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Xe̱'n² mɨ³rɨ³'ia³ mee³¹, 'e³ jo̱³ móo³ra'³ 'e³ mɨ³ rɨ²³tɨ́²³ ji̱²³'ioo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","'E³ quie'²³ la'³ mɨ³rɨ³móo³ra'³ 'e³ sɨ³lí³ 'e³ la²³ mɨ³juǿøn²na²³ 'nee'²³. Jo̱³ rɨ²móo²ra'³ 'e³ mɨ³lǿ²³ mɨ³lén² 'e³ rɨ²³lín³ Dios juii² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xen³ quie'²³ dsa³ 'i³ xen³ rɨ³nɨ²³ mɨ³rɨ³li³ la²³jɨ³ 'e³ mɨ³juǿøn²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","'E³ cɨ² rɨ²³lí³ 'e³ 'a²³'e³ ma²³ xa³ mɨ³¹güii³ quia̱'² 'uǿ²³ la³. 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² rɨ²³gua'²³ júu² quián²³. Ca³quie̱e̱² rɨ²³lí³ 'e³ la²³ lǿ². ");
INSERT INTO cnlNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Xi²dsɨ́n³na'³ jo̱o̱²³na²³. 'A²³ rɨ³cuøn²³na'³ miin²³na'³ 'e³ rɨ²jmée²ra'³ ji̱i̱³ la²³jɨ³ 'e³ 'iin²³ 'óo²ra'³. 'A²³ rɨ³ŋøn³na'³. 'A²³ rɨ³mi³ñúun²na'³ 'óo²ra'³ la²³jɨ³ ta² 'e³ xa³ quién²na'³. Qui² bi²³ juø'² rɨ²³quín³ rɨ²³gǿn³na'³. Qui² 'e³ jo̱³ hua² rɨ²³jmée²³ 'e³ 'a²³jia'³ ma²³ xi²dsɨ́n³na'³ mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²aa'n³²na²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Co̱'³ la²³ rɨ²³tɨ́²³ jmɨ́ɨ² je² 'a²³jia'³ xi²dsɨ́n³na'³ la²³ sɨ³tɨ́²³ 'e³ sɨ³'ló²³ lá³ je² 'a²³jia'³ xi²dsɨ́n³te'²³. Rɨ³lø³¹ 'i'²³ 'e³ jmɨ́ɨ² jo̱³ rɨ²³jí̱i̱n³ jné² la²³jɨn³ sú̱n² dsa³ 'i³ xen³ la²³ca̱a̱n³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Rɨ²mi³quii²³²ra'³ jo̱o̱²³na²³. Tén³ la²³ rɨ²juɨɨ'³¹ra'³ Dios 'e³ la²³ rɨ²³lí³ juø'² rɨ²³láan³na'³ la²³jɨ³ 'e³ rɨ²³lí³, 'e³ la²³ rɨ²³lí³ juø'² rɨ²nóo²ra'³ xi²ñin²³ jné² Jo̱o̱³¹ Dsa³. ―La'³ cu³lø³¹ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","La²³jɨ³ jmɨ́ɨ² ca²³'ée²³ dsa³ Jesús ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. 'E³ quie'²³ 'uøø²³ i²gua³ mo'³ Jesús je² xi̱i̱n³ mo'³ Olivo. ");
INSERT INTO cnlNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","'E³ quie'²³ tá³ cɨ² sɨ³ñii'n²³ co̱'³ la²³jɨn³ dsa³ ñʉ'²³ 'ñʉ́² gáan³ 'e³ jua'³ 'née²³te'²³ rɨ²³núu²³te'²³ co̱'³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ca²³lǿ²³ mɨ³lén² mɨ²juee'³ je² ee'³² dsa³ 'ɨ²³juɨ² 'e³ 'a²³'e³ xa³ xoo'³¹, mɨ²juee'³ 'e³ xi̱i̱n³ pascua. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bi²³ 'ñaa'n²³ dsa³ juɨɨ³ te'²³ jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley. 'E³ jo̱³ 'no'²te'²³ 'e³ jmii'³¹ rɨ²³jŋɨ'n²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","'E³ quie'²³ jo̱³ 'í² Satanás dsɨ́² Judas 'i³ sɨ'²³te'²³ Iscariote, jø̱n³ dsa³ gui²³tʉ̱́n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ŋóo² Judas i²joon³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ juii² dsa³ 'láa³ 'i³ 'aa³ 'ñʉ́² gáan³. Ca²³lʉ́³ quia̱'² dsa³ 'í³ 'e³ jua'³ rɨ²³'nɨ́ɨn²³ Jesús quie'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bi²³ 'née²³te'²³ jo̱o̱²³na²³. 'E³ jo̱³ ca²³mi²³'ien³te'²³ júu² 'e³ rɨ²³quí²te'²³ jñiin²³ Judas. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ca²³'íi³ júu² 'ñée² Judas. 'No'² 'e³ jmii'³¹ li²³tɨ́ɨ²³ rɨ²³jɨ̱'n² Jesús quie'² te'²³ dsa³ 'í³ je² 'a²³jia'³ rɨ³ŋɨɨn³¹ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ca²³tɨ́³ jmɨ́ɨ² 'e³ ee'³² dsa³ 'ɨ²³juɨ² 'e³ 'a²³'e³ xa³ xoo'³¹. 'E³ quie'²³ jmɨ́ɨ² jo̱³ rɨ³lø³¹ 'i'²³ 'e³ jŋɨ'n²³ dsɨɨ³ joo³ te'²³ dsa³ Israel. La²³ mɨ³dxóo³ la'³ cuu'³te'²³ quiée²³ quiee'³² dsɨɨ³ joo³ mɨ²juee'³ pascua. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús ca²³xíin²³ Peen²³² quia̱'² Juan. Ca²³sɨ'²³: ―Cu³guín²³na'³ jo̱o̱²³na²³. Cu³mi³tɨ́ɨ²³ra'³ quiée²ra² la²³jɨ³ 'e³ rɨ²quie²ra² mɨ²³'láa²³ pascua. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―¿Jiaa'³¹ 'naan³ sɨ³mi³tɨ́ɨ²³ra'³¹ je² rɨ²quie²ra² mɨ²³'láa²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ 'í³: ―Rɨ²³mi²³jí̱i̱n³ 'nee'²³ jø̱n³ dsa³ 'i³ quie̱³ mɨ²dsuu² 'e³ 'o² jmɨɨ³ mɨ³rɨ³dxi³guín²³na'³ jee²³² juɨɨ³. Guoo³²ra'³ quia̱'n²na'³ dsa³ 'í³ jo̱o̱²³na²³. Rɨ²taa'n³²na'³ xi²ñʉ'¹ je² rɨ²³'í³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jo̱³ tu³ rɨ²juɨɨ'³¹ra'³ juii² xi²ñʉ'¹: “Jua'³ dsa³ 'e²³ 'e³ 'ee² co̱²³ju'²³ je² rɨ²³e'² mɨ²³'láa²³ pascua quia̱'² dsa³ quien³²”. La'³ rɨ²juɨɨ'³¹ra'³ juii² xi²ñʉ'¹ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jo̱³ rɨ²³'ée²³ 'nee'²³ co̱o̱³ co̱²³ju'²³ bee'² yʉʉ'³¹ je² dxi²³juɨn³¹ je² mɨ³jmóo²te'²³ dxʉ́²³. Núu²³ cu³mi³tɨ́ɨ²³ra'³ 'e³ rɨ²quie²ra². ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³² quia̱'² Juan. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ca²³guín²³te'²³ jo̱o̱²³na²³. Ca²³lǿ²³ 'e³ la²³ ca²³jua'³ Jesús 'e³ rɨ²³lí³. 'E³ jo̱³ ca²³mi²³tɨ́ɨ²³te'²³ mɨ²³'láa²³ pascua. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ma²mɨ³tɨ́³ hora jo̱³, ca²³gua³ coo³¹ mesa Jesús quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―¡Bi²³ ma²³'nee³ mɨ³la³'náan²³ rɨ²ee'n²³² mɨ²³'láa²³ pascua quia̱'n²³²na¹ 'nee'²³ jén²³ cɨ² 'e³ la²³ rɨ²³jú̱n³na²³! ");
INSERT INTO cnlNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Qui² rɨ²juøøn³¹na¹ 'nee'²³: 'A²³jia'³ ma²³ rɨ²ee'n²³² mɨ²³'láa²³ pascua la²³huø'n²³ rɨ²ee'n²³² je² rɨ³løn³¹ Dios juii². 'E³ la²³ quie³ra² mɨ²³'láa²³ pascua cɨ'³ la²³ co̱o̱³ ji̱i̱³ ñi³, jmee³ra² lii²³ 'e³ jmii'³¹ rɨ²³láan² dsa³ Dios. La²³jɨ³ 'e³ jmee³ra² lii²³ 'e³ rɨ²³lí³, 'e³ quie'²³ lii²³ 'e³ mɨ³lǿ²³ ma²mɨ³'áa³ 'i'²³ 'e³ rɨ²ee'n²³² co̱'³ je² rɨ³løn³¹ Dios juii² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","'E³ quie'²³ jo̱³ so̱'²³ Jesús co̱o̱³ taza 'e³ 'o² jmɨɨ'³¹ mɨ²jø'² vino. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―Quie̱³ra'³ taza la³. Rɨ²too'³¹ra'³ dxóo² ma²³ ca³juɨ² i²³la³ i²³nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Qui² rɨ²juøøn³¹na¹ 'nee'²³: 'A²³jia'³ ma²³ rɨ²uu'n²³² co̱'³ jmɨɨ'³¹ mɨ²jø'² vino la²³huø'n²³ rɨ²³tɨ́²³ 'e³ rɨ²³lín³ Dios juii² dsa³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","'E³ quie'²³ jo̱³ so̱'²³ 'ɨ²³juɨ² Jesús. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. Ca²³xíin² 'ɨ²³juɨ². Ca²³cuǿø²³ dsa³ quien³². Ca²³jua'³: ―'E³ la³ jmɨn²³ ŋun²³ 'e³ rɨ²cuøn²³² 'e³ rɨ²láan¹na²³ 'nee'²³. La²³nɨ³ cu³lø³¹ rɨ²jmée²quie²³ra'³ 'e³ juo'³ra'³ liin³²na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ca²³lʉ́³ co̱'³ 'e³ la²³ so̱'²³ taza 'e³ 'o² jmɨɨ'³¹ mɨ²jø'² vino ma²mɨ³líi² mɨ³e'²te'²³ mɨ²³'láa²³. Ca²³jua'³: ―Jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'o² taza la³ jmee²³ lii²³ 'e³ mɨ³'ien³ júu² 'mɨɨn³² quiee'³² Dios. Jmɨ²³'øn²³²na¹ 'e³ rɨ²³tʉ̱ʉ̱³ 'e³ rɨ²láan¹na²³ 'nee'²³ rɨ²³jmée²³ quí̱i̱n²³ júu² 'mɨɨn³² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’'E³ quie'²³ jen³¹na¹ coo³¹ mesa la³ quia̱'n²³²na¹ dsa³ 'i³ rɨ²³'nɨ́ɨn²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Rɨ²³jú̱n³na²³ jné² Jo̱o̱³¹ Dsa³ 'e³ la²³ rɨ³lø³¹ 'i'²³. 'E³ quie'²³, ¡bi²³ juɨɨ³² dsa³ 'i³ rɨ²³'nɨ́ɨn²³ jné²! ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","'E³ jo̱³ ca²³lʉ́³ la²³ co̱³quie'² dsa³ quien³². ―¿'I̱i̱² sɨɨ'³¹ rɨ²³jmée²³ la'³ cu²ne²ra²? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ca²³sɨ́n²³ júu² miin²³ la²³ co̱³quie'² dsa³ quien³² 'e³ 'i̱i̱² sɨɨ'³¹ miin²³ 'i³ joo'²³ rɨ²³jua'³te'²³ 'i³ gáan³ cɨ². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Bi²³ la²³dxi³ 'i'²³ reyes quien³² dsa³ jia'³. 'E³ quie'²³ 'née²³ dsa³ 'i³ ta'n² ta² 'e³ rɨ²³sɨ'²³te'²³: Dsa³ 'i³ bi²³ dxʉ́²³ jmoo³². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","'E³ quie'²³ 'a²³jia'³ dxʉ́²³ 'e³ rɨ²³lí³ la'³ jee²³² quien³²na'³. Cu²jmóo¹ 'i³ gáan³ cɨ² jee²³² quien³²na'³ 'é̱e̱² 'i³ mi'n²³ cɨ². Cu²jmóo¹ 'i³ dxi³ 'i'²³ la²³ jmoo³² mozos 'i³ mi³quin³ uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿'I̱i̱² sɨɨ'³¹ 'i³ gáan³ cɨ², lǿn³ dsa³? ¿'A² lǿn³te'²³ 'e³ gáan³ cɨ² dsa³ 'i³ jen³¹ coo³¹ mesa? ¿'A² lǿn³te'²³ 'e³ gáan³ cɨ² dsa³ 'i³ mi³quin³ uu'n²? Dsa³ 'i³ jen³¹ coo³¹ mesa 'i³ gáan³ cɨ², lǿn³te'²³, ¿mɨ³naa'³¹? 'E³ quie'²³ jmeen²³ jné² jee²³² quien³²na'³ la²³ jmee²³ mozo 'i³ mi³quin³ uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Miin²³na'³ mɨ³ŋɨ́²ra'³ quia̱'n²na'³ jné² la²³huøø'n³¹ la²³ mɨ³dxi³quié̱n²na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","'E³ jo̱³ cuøn²³ ju²³bíi²³ quién²na'³ 'e³ la²³ mɨ³cuǿ³ ju²³bíi²³ quián²³ Ñu'n²³ 'e³ dxin²³ 'i'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Rɨ²'u'² rɨ²cø'²ra'³ coo³¹ mesa je² rɨ²uu'n²³² rɨ²ee'n²³² je² rɨ²³lín³na²³ juii². Rɨ²ñí²ra'³ sii³¹ gáan³. Rɨ²jmée²ra'³ 'i'²³ xi² xa³ dsoo² quiee'³² la²³jɨ³ gui²³tʉ̱́³ ta'n² dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","'E³ quie'²³ jo̱³ ca²³lʉ́³ co̱'³ Juii³ra². Ca²³jua'³ ca²³sɨ'²³ Peen²³²: ―Muun³², Muun³², mɨ³'ioo³² júu² Satanás 'e³ rɨ²³xíi² rɨ²³ŋɨ́ɨn² 'nee'²³. 'Née²³ 'ñée² 'e³ rɨ²³gua'²³ 'óo²ra'³ la²³ sɨ³gua'²³ la²³jɨ³ 'e³ 'lʉʉ'² 'e³ taa'² jee²³² mɨ³¹cuɨɨ³ trigo. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","'E³ quie'²³ mɨ³lʉ́n²³ quia̱'n²³²na¹ Dios mɨ³'øn²³na²³ 'nʉ³. Mɨ³juǿøn² 'e³ 'a²³ cu²yáan¹ 'áan² 'e³ sɨ³táan³nu³. 'E³ jo̱³ mɨ³rɨ³liin²³ co̱'³ 'áan² 'e³ la²³ mɨ³yáan²³ ca³dxa³, rɨ²jméen² 'e³ 'uee'n³ cɨ² dsɨ́² te'²³ já̱a̱n². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","'E³ jo̱³ ca²³jua'³ Muun³². Ca²³sɨ'²³ Jesús: ―Juiin²³, dxʉ́²³ dsɨn²³ 'e³ ñiin²³ i²³ñí² quia̱'n²³²na¹ 'nʉ³. Dxʉ́²³ dsɨn²³, juø'n³ quie'²³ rɨ²³jú̱n³na²³ quia̱'n²³²na¹ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nʉ³, Peen²³²: 'Uøø²³ 'e³ rɨ³nɨ²³, 'e³ 'íi² rɨ²³tǿ² 'nɨɨ'², rɨ²juɨɨ'n³¹ dsa³ 'nɨ³ taa'² 'e³ 'a²³jia'³ cuiin²³nu³ jné². ―La'³ cu³lø³¹ ca²³sɨ'²³ Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Co̱'³ cɨ'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ quien³²: ―Mɨ²jo̱³ ma²ca¹sɨ́ɨn¹na²³ 'nee'²³, ca²³juǿøn²na²³ 'nee'²³ 'e³ 'a²³jia'³ rɨ²có̱²ra'³ paa²i² 'e³ rɨ³pee'²³ cuu², 'e³ 'a²³jia'³ rɨ²có̱²ra'³ morral, 'e³ líi² la²³'nɨɨ'n³¹ co̱o̱³ dsa'n² loo³ 'e³ rɨ³'éen³na'³. ¿'A² juø'² xa³ 'e³ ca²³jmée³ jloo'² quién²na'³ mɨ²jo̱³? ―'A²³'e³ xa³ sú̱n² 'e³ ca²³jmée³ jloo'² ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'A²³jia'³ ma²³ lǿ² la'³ rɨ³nɨ²³. 'Ne'² rɨ²có̱²ra'³ paa²i² 'e³ rɨ³pee'²³ cuu² xi³nu³ xa³ quién²na'³. 'E³ quie'²³ la'³ morral co̱'³. 'Ne'² rɨ²'nɨ́ɨ²ra'³ 'mɨɨ'³ dxóo³ quien³²na'³ xi³nu³ 'a²³'e³ boo'³¹ xa³ quién²na'³. Jo̱³ rɨ²³lí³ juø'² rɨ²có̱²ra'³ boo'³¹ 'e³ rɨ²³la'n²³na'³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Qui² rɨ²juøøn³¹na¹ 'nee'²³: 'Ne'² rɨ²³jí̱i̱n²³ 'e³ la²³ to̱o̱²³ ji³ 'e³ rɨ²³lí³. La²³la³ cu³lø³¹ to̱o̱²³ ji³ 'e³ 'øn²³: “Dsa³ 'i³ 'a²³jia'³ jmee²³ ca³dsaan³², lǿn³te'²³”. 'E³ jo̱³ 'ne'² rɨ²³jí̱i̱n²³ la²³jɨ³ 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jí̱i̱n²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","'E³ jo̱³ ca²³jua'³te'²³: ―Juii³ra'³¹, jóo². Xa³ la³ tú̱²³ boo'³¹. ―Mɨ³líi² la²³'nɨɨ'n³¹ nɨ³ ―ca²³jua'³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","'E³ quie'²³ jo̱³ ca²³bǿn³ Jesús. Ŋóo² mo'³ Olivos je² to̱'²³ ŋɨ́³. Ca²³guín²³ tu³cɨ̱ɨ̱n³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ma²ca¹dxóo¹ núu²³, ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―'Ne'² rɨ²lʉ́²ra'³ quia̱'n²na'³ Dios 'e³ la²³ 'a²³jia'³ rɨ²³te'n²³na'³ 'e̱'³ lá³ je² juø'² rɨ²jmée²ra'³ 'e³ xa³ dsoo² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","'E³ quie'²³ jo̱³ ca²³la²³huɨ̱'n³ Jesús la²³'nɨɨ'n³¹ co̱'³ tɨ́² cú̱u̱². Ca²³xii'³ jñi². Ca²³lʉ́³ quia̱'² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ca²³jua'³: ―Ñu'n², xi³nu³ dxʉ́²³ 'áan², rɨ²cuǿn² júu² 'e³ 'a²³jia'³ rɨ²³jí̱i̱n²³ 'e³ la²³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jí̱i̱n²³. 'E³ quie'²³ 'a²³ cu²lí³ 'e³ la²³ 'náan²³ 'ñáan²³. Cu²lí³ 'e³ la²³ 'naan³ 'uǿøn²nu³. ―La'³ cu³lø³¹ ca²³lʉ́³ quia̱'² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","'E³ quie'²³ jo̱³ ca²³mi²³jnen³ 'ñée² jø̱n³ ángel 'i³ naan³ jí̱i̱n² yʉʉ'³¹ güii³ caan²³ Jesús. Ca²³cuǿ³ ju²³bíi²³ quie'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Je² bi²³ dxi³quié̱n² 'ñée², bi²³ cɨ² dxaa'n³¹ dsɨ́² ca²³lʉ́³ quia̱'² Dios. 'E³ jo̱³ bi²³ ca²³'ien³ jmɨ²³dxoo²³². La²³ lǿ² jmɨ³ lǿ² jmɨ²³dxoo²³² 'e³ ca²³'ni'³ 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ma²mɨ³líi² mɨ³lʉ́³ quia̱'² Dios, ca²³naa'n²³ co̱'³ Jesús. Ca²³dxe'n² co̱'³ je² nee'n²³² dsa³ quien³². 'E³ quie'²³ rɨ³guɨɨn³te'²³ la²³'nɨɨ'n³¹ 'e³ ŋɨ́³ dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―¿'Ee² lǿ² mɨ³guɨɨn³na'³? Naa'n²³na'³. Rɨ²lʉ́²ra'³ quia̱'n²na'³ Dios 'e³ la²³ 'a²³jia'³ rɨ²³te'n²³na'³ 'e̱'³ lá³ je² juø'² rɨ²jmée²ra'³ 'e³ xa³ dsoo² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lʉ²³ quie'²³ la'³ Jesús ma²ca¹dxi¹guín¹ juɨ́ɨn²³ dsa³. Jø̱n³ dsa³ gui²³tʉ̱́n³ 'i³ xi̱i̱n³ Judas, 'i³ cuø²³ jui³¹ quie'²te'²³. Ca²³lǿn²³ mɨ³lén² Judas 'e³ jua'³ rɨ²³cuu'³ ñi² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Judas: ―Judas, ¿'a² te³ rɨ²cu'n² ñin²³? ¿'A² la'³ cu³lø³¹ rɨ²jméen² lii²³ 'e³ 'nɨ́ɨn²³nu³ jné² Jo̱o̱³¹ Dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ca²³la²³quii²³ dsa³ 'i³ quia̱'² Jesús 'e³ jmii'³¹ rɨ²³lí³. 'E³ jo̱³ ca²³jua'³te'²³: ―Juii³ra'³¹, ¿'a² rɨ²cuø²ra'³¹ boo'³¹ quie'²te'²³? ");
INSERT INTO cnlNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Xen³ jø̱n³ dsa³ 'i³ quia̱'² Jesús 'i³ ca²³quiu'n² mozo quien³² juii² jmii³ dsa³. Ca²³quiʉ'² lo³guo² jaan²³ 'e³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","'E³ quie'²³ ca²³jua'³ Jesús: ―Rɨ²cuǿ²ra'³ júu² 'e³ cu²jmóo¹ quie'²³ 'e³ la²³ jmoo³². 'E³ jo̱³ ca²³co̱o̱²³ Jesús mɨ²lo³guo² dsa³. Ca²³dso'² co̱'³. Ca²³mi²³'láan³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","'E³ jo̱³ ca²³lʉ́³ Jesús. Ca²³sɨ'²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ juii² dsa³ 'láa³ 'i³ 'aa³ 'ñʉ́² gáan³ quia̱'² te'²³ dsa³ mɨ³dxún²³. Qui² i²guín¹te'²³ 'e³ jua'³ rɨ²³sø̱'n²te'²³ 'ñée². Ca²³jua'³: ―¿'A² juø'² lǿn³na'³ 'e³ dsa³ 'i̱i̱³ hua² jné²? Qui² 'e³ xe̱'²ra'³ boo'³¹, xe̱'²ra'³ 'mo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Qui² la²³jɨ³ jmɨ́ɨ² jen³¹na¹ ñʉ'²³ 'ñʉ́² gáan³ quia̱'n²³²na¹ 'nee'², ¿mɨ³naa'³¹? 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² ca²³xe̱'n²³na'³ jné². 'E³ quie'²³ mɨ³tɨ́³ hora 'e³ rɨ²jmée²ra'³ 'e³ la²³ 'noo³ra'³. Qui² jmee³ra'³ ta² ca³ti³² quia̱'n²na'³ 'i³ 'uee'n³ 'i³ jmee²³ ta² je² li³'o̱o̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","'E³ jo̱³ sø̱'n²te'²³ Jesús. Ca²³jøn²³te'²³ quie'² juii² jmii³ dsa³. Huɨ̱́ɨ̱³ tu³cɨ̱ɨ̱n³ Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ca²³ji̱i̱'n³ dsa³ ji³ dxoo'³¹ xi²dxi³² je² rɨ³jnɨ³ quie'² juii² jmii³ dsa³. Ca²³gua³te'²³ coo³¹ ji³. Ca²³gua³ Peen²³² jee²³² quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Xen³ jø̱n³ xii'³ mɨ́³ 'i³ rɨ³løn³¹ moza 'i³ ŋǿn² Peen²³² 'e³ la²³ jen³¹ je² cuø²³ jmɨ́ɨ²³ ji³. Ca²³jóon² dxʉ́²³. 'E³ jo̱³ ca²³jua'³ ca²³'én² Peen²³²: ―Mɨ³ŋɨ́³ dsa³ la³ quia̱'² Jesús, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","'E³ quie'²³ ca²³jua'³ Peen²³²: ―Mɨ́³, 'a²³jia'³ jmɨ́ɨ² cuiin²³na²³ dsa³ 'i³ 'ǿn²³nu³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","'Mɨ́ɨ³ ca²³ji̱i̱³ la'³, xen³ jia'³ cɨ'²³ 'i³ ŋǿn² Peen²³² co̱'³. 'E³ jo̱³ ca²³jua'³: ―Rɨ³løn³¹nu³ jø̱n³ dsa³ quien³² Jesús, ¿mɨ³naa'³¹? 'E³ quie'²³ ca²³jua'³ Peen²³²: ―'A²³la³ 'í³ jné² xú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma²ca¹ŋɨ́n³ cɨ² co̱o̱³ hora, xen³ jia'³ cɨ'²³ co̱'³ 'i³ ca²³jua'³: ―'E̱'n³ ca³quie̱e̱² mɨ³ŋɨ́³ dsa³ la³ quia̱'² dsa³ 'í³, ¿mɨ³naa'³¹? Qui² rɨ³løn³¹ dsa³ Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","'E³ quie'²³ ca²³jua'³ Peen²³²: ―Cu³xi³ 'a²³jia'³ maan²³ jmii'³¹ cu³lø³¹ júu² 'e³ lʉ́n². Je² lʉ²³ quie'²³ la'³ Peen²³², tǿ²³ 'nɨɨ'². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","'E³ jo̱³ ca²³ji̱i̱n²³ Juii³ra². Ca²³jóon² Peen²³². Ca²³la²³líi²³ Peen²³² júu² 'e³ ca²³lʉ́³ Juii³ra² ma²ca¹jua'³: “'E³ la²³ 'íi² rɨ²³tǿ² 'nɨɨ'² rɨ³nɨ²³ rɨ²juɨɨ'n³¹ dsa³ 'nɨ³ taa'² 'e³ 'a²³jia'³ cuiin²³nu³ jné²”. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","'E³ jo̱³ ca²³bǿn³ Peen²³². Bi²³ juɨɨ³² ca²³'o'². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ca²³jáa² ca²³ŋɨ́ɨn²te'²³ Jesús te'²³ dsa³ 'i³ 'aa³² quie'². Ca²³cuǿ³te'²³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ca²³'mée²te'²³ mɨ²ñi². 'E³ jo̱³ ca²³sɨ'²³te'²³: ―Jmee² júu² 'e³ 'i̱i̱² sɨɨ'³¹ mɨ³cuǿ³ quién²nu³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ñúun³ cɨ² júu² 'e³ ca²³sɨ'²³te'²³ 'e³ jua'³ 'née²³te'²³ rɨ²³lʉ́n²te'²³ 'ñe'². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ma²ca¹la¹jné¹, ca²³ŋɨɨ'n²³ te'²³ dsa³ mɨ³dxún²³ quien³² dsa³ juɨɨ³, te'²³ juii² jmii³ dsa³ ca³ti³² quia̱'² te'²³ dsa³ 'e²³ ley. 'E³ quie'²³ jo̱³ ca²³jøn²³te'²³ Jesús caan²³ te'²³ dsa³ 'í³ 'e³ jua'³ rɨ²³dxá²³te'²³ ta² quiee'³². 'E³ jo̱³ ca²³jua'³ dsa³ 'í³: ");
INSERT INTO cnlNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Rɨ²juɨɨ'n³¹nu³ jnee'³¹: ¿'A² Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios 'nʉ³? 'E³ quie'²³ ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ 'í³: ―'A²³jia'³ rɨ²³sɨ²³táan³na'³, juø'n³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Juø'n³ quie'²³ xa³ júu² 'e³ rɨ²ŋɨ'n¹na²³ 'nee'²³, 'a²³jia'³ jmɨ́ɨ² rɨ²jmée²ra'³ júu². 'A²³jia'³ jmɨ́ɨ² rɨ²tún¹na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","'E³ quie'²³ rɨ³nɨ²³ sɨ³li³láa²³ 'e³ jen³¹na¹ jné² Jo̱o̱³¹ Dsa³ jaan²³ 'e³ dxʉ́²³ Dios 'i³ bi²³ 'uee'n³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","'E³ jo̱³ ca²³jua'³ la²³jɨn³te'²³: ―¿'A² Jo̱o̱³¹ Dios 'nʉ³ jo̱o̱²³na²³? 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'I³ 'í³ jné². Miin²³na'³ mɨ³jua'²ra'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","'E³ jo̱³ ca²³jua'³te'²³: ―'A²³jia'³ ma²³ 'ne'² cɨ² dsa³ ñi³, ¿mɨ³naa'³¹? Mɨ³nʉʉ²ra² miin²³na² júu² 'oo² 'ñée² 'e³ bi²³ 'ñe'² lʉ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","'E³ quie'²³ jo̱³ ca²³naa'n²³ la²³jɨn³ dsa³ 'i³ rɨ³ŋɨɨn³¹. I²jøn²³te'²³ Jesús caan²³ Pilato. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ca²³cuǿ³te'²³ dsoo² quiee'³². Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Pilato: ―Xa³ dsoo² quiee'³² dsa³ la³ 'e³ jmee²³ 'e³ sɨ³caa'n³² jui³¹ dsa³ uu'n²na'³¹. Jua'³ 'ñée² 'e³ 'a²³jia'³ joo'²³ 'e³ rɨ²³quí² dsa³ cuu² 'e³ cu'n³² 'io'² 'i³ xiin²³ dxi² juɨɨ³ 'i³ xi̱i̱n³ César. Jua'³ 'e³ 'ñée² rɨ³løn³¹ rey 'i³ xi̱i̱n³ Cristo. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","'E³ quie'²³ jo̱³ ca²³jua'³ Pilato. Ca²³sɨ'²³ Jesús: ―¿'A² rey quien³² dsa³ Israel hua² 'nʉ³? 'E³ jo̱³ ca²³jua'³ Jesús: ―La'³ cu³lø³¹ 'e³ la²³ mɨ³jue'n² 'uǿøn²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","'E³ jo̱³ ca²³jua'³ Pilato. Ca²³sɨ'²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ juɨɨ³: ―'A²³'e³ dsoo² xa³ quie'² dsa³ la³, lǿn³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","'E³ quie'²³ dxaa'n³¹ dsɨ́²te'²³ ca²³lʉ́³te'²³. Ca²³jua'³te'²³: ―Bi²³ jmee²³ 'e³ sɨ³lí³ sɨ³dxóo³ dsa³ 'e³ la²³ ŋɨ́³ 'ee²³ dsa³ la²³ca̱a̱n³ estado Judea. Qui² estado Galilea ca²³tín²³ ca²³'ée²³ dsa³. Jmee²³ quie'²³ la'³ xi³'lɨ² mɨ³güén²³ je² la³. ―La'³ ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ma²ca¹núu³ Pilato júu² 'e³ ca²³lʉ́³te'²³, ca²³ŋɨ́ɨ³ júu² xi² 'í³ dsa³ Galilea Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma²ca¹dsóo¹ dsɨ́² 'e³ je² røøn³ Herodes xen³ Jesús, ca²³xíin²³ Jesús quie'² Herodes. Qui² jen³¹ Herodes juɨɨ³ Jerusalén mɨ²jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bi²³ 'née²³ Herodes ma²ŋøn³¹ Jesús. Qui² mɨ³xa³ la²³ 'née²³ rɨ²³jóon² Jesús. Ca²³núu³ 'e³ jmii'³¹ lʉ²³ dsa³ 'en³²te'²³. 'Née²³ rɨ²³jóo² 'e³ rɨ²³jmée²³ u²³juø'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ñúun³ la²³jɨ³ 'e³ ca²³ŋɨ́ɨ³ júu² Herodes. 'E³ quie'²³ 'a²³jia'³ ca²³'í̱n² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Té̱e̱n³ coo³¹ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'e²³ ley. Bi²³ ma²³'nee³ bee'² dsoo² 'e³ cuø²³te'²³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","'E³ quie'²³ jo̱³ 'a²³jia'³ ca²³mi²³quí̱i̱n²³ Jesús Herodes quia̱'² dsa³ 'láa³ quien³². Ca²³jáa² ca²³ŋɨ́ɨn²te'²³. Ca²³qui'n²te'²³ cuo̱o̱³ 'e³ dxʉ́²³ la²³ 'e³ la²³ cɨɨ'³² reyes. 'E³ jo̱³ Herodes ca²³xíin²³ co̱'³ Jesús quie'² Pilato. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jmɨ́ɨ² jo̱³ ca²³la²³dxʉ́²³ lʉ²³ Herodes quia̱'² Pilato. Qui² mɨ²xe̱'n³¹ cɨ² bi²³ nɨ́ɨn³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","'E³ quie'²³ jo̱³ ca²³dxi³ 'i'²³ Pilato 'e³ rɨ²³ñii'n²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'i³ ta'n² ta² jee²³² quiee'³² dsa³ Israel quia̱'² la²³jɨn³ dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ca²³sɨ'²³ dsa³ 'í³: ―Mɨ³gui³jøn²³na'³ dsa³ la³ xi²ñin²³ jné² 'e³ juo'³ra'³ jmee²³ 'e³ sɨ³caa'n³² dsa³ jui³¹. 'E³ quie'²³ ñúun³ 'e³ mɨ³ŋɨ́ɨn²³ júu² xi²ñí²ra'³. 'E³ quie'²³ 'a²³'e³ dsoo² xa³ quie'² 'e³ juo'³ra'³ xa³ dsoo² quiee'³², lǿn³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","'E³ quie'²³ la'³ lǿn³ Herodes co̱'³. Qui² mɨ³gui³jáan³te'²³ co̱'³ quián²³. Jóo²ra'³ ma². 'A²³'e³ dsoo² xa³ quie'² 'e³ dxi³ji̱i̱n³¹ 'e³ rɨ²³jú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Te³ rɨ²dxin²³² 'i'²³ 'e³ rɨ²³jmín²te'²³. Jo̱³ tu³ rɨ²láan¹na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","'E³ quie'²³ xa³ tɨ³² 'i'²³ quiee'³²te'²³ 'e³ 'ne'² rɨ²³dxin³ Pilato jø̱n³ dsa³ 'i³ 'iún² i²³ñí² cɨ'³ la²³ co̱o̱³ ji̱i̱³ ñi³ 'e³ la²³ sɨ³tɨ́²³ mɨ²juee'³ pascua. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","'E³ quie'²³ sɨ³jó̱²³ la²³ cɨ² ca²³lʉ́³ la²³jɨn³ sú̱n² dsa³. Ca²³jua'³te'²³: ―¡Cu²jú̱n³ dsa³ nɨ³! ¡Rɨ²láan¹nu³ quiée²ra'³¹ Barrabás! ");
INSERT INTO cnlNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Qui² 'iún² i²³ñí² jø̱n³ dsa³ 'i³ xi̱i̱n³ Barrabás dsoo² 'e³ ca²³jmée³ 'e³ ca²³roo'²³ dsa³ juɨɨ³ Jerusalén ñin³² dxi² juɨɨ³, 'e³ ca²³jmée³ 'móo² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","'E³ quie'²³ 'née²³ Pilato 'e³ rɨ²³láan² Jesús. 'E³ jo̱³ co̱'³ cɨ'²³ ca²³lʉ́³ quia̱'² dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","'E³ quie'²³ quiʉ̱ʉ̱³ ca²³lʉ́³te'²³ co̱'³. Ca²³jua'³te'²³: ―¡Te̱e̱n²³² cruz! ¡Te̱e̱n²³² cruz! ");
INSERT INTO cnlNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Je² ca²³tɨ́³ 'nɨ³ taa'², ca²³lʉ́³ co̱'³ Pilato. Ca²³sɨ'²³ dsa³ juɨɨ³: ―¿'Ee² lǿ²? ¿'Ee² dsoo² 'e³ mɨ³jmée³? 'A²³'e³ xa³ dsoo² quiee'³² 'e³ dxi³ji̱i̱n³¹ 'e³ rɨ²³jú̱n³, lǿn³ jné². Te³ rɨ²dxin²³² 'i'²³ 'e³ rɨ²³jmín²te'²³. Jo̱³ tu³ rɨ²láan¹na²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'E³ quie'²³ dxaa'n³¹ dsɨ́²te'²³ ca²³lʉ́³te'²³ co̱'³. Quiʉ̱ʉ̱³ ca²³lʉ́³te'²³. La²³bii²³ ca²³sɨ'²³te'²³ 'e³ 'ne'² rɨ²³te̱e̱n³te'²³ cruz. Sɨ³lí³ sɨ³dxóo³ la²³ cɨ² ca²³jmóo²te'²³ quia̱'² te'²³ juii² jmii³ dsa³. 'E³ quie'²³ jo̱³ 'ióo²quie'²³te'²³ júu² jo̱o̱²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","'E³ jo̱³ ca²³dxi³ 'i'²³ Pilato 'e³ rɨ²³lí³ 'e³ la²³ ŋɨɨ²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ca²³láan² dsa³ 'i³ ca²³ŋɨ'n² dsa³ juɨɨ³, dsa³ 'i³ 'iún² i²³ñí², dsoo² 'e³ ca²³jmée³ 'e³ ca²³roo'²³ dsa³ juɨɨ³ ñin³² dxi² juɨɨ³, 'e³ ca²³jmée³ 'móo² co̱'³. 'E³ quie'²³ ca²³jɨ̱'n² Jesús 'e³ rɨ²³jme'²³te'²³ 'e³ la²³'nɨɨ'n³¹ 'née²³te'²³ rɨ²³jme'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","'E³ quie'²³ jo̱³ ca²³ta'n²³te'²³ jui³¹ 'e³ ca²³jøn²³te'²³ Jesús je² rɨ²³te̱e̱n³te'²³ cruz. 'E³ jo̱³ sø̱'n²te'²³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Muun³² 'i³ xen³ juɨɨ³ Cirene 'i³ sɨ³ŋɨ́n³ 'e³ jua'³ ñíin² je² nuu³. Ca²³dxá³te'²³ cruz coo'² 'no² Muun³². Ca²³sɨ'²³te'²³ 'e³ rɨ²³dsóo² tu³cɨ̱ɨ̱n³ 'e³ quie̱³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ ca²³guín²³ tu³cɨ̱ɨ̱n³. Juɨ́ɨn²³ mɨ́³ 'i³ ca²³guín²³ 'i³ 'oo'³², 'i³ ŋɨ́³ dsɨ́² 'e³ mɨ³'ien³ júu² 'e³ rɨ²³jŋɨ'n²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","'E³ quie'²³ ca²³ji̱i̱n²³ Jesús. Ca²³jua'³ ca²³sɨ'²³ mɨ́³ 'í³: ―Rɨ²juøøn³¹na¹ 'nee'²³, mɨ́³ 'i³ xen³ juɨɨ³ Jerusalén: 'A²³ rɨ³'o'²ra'³ 'e³ juo'³ra'³ cuu'²³ 'óo²ra'³ quia̱'n²na'³ jné². 'E³ quie'²³ 'ne'² 'e³ rɨ²'o'²ra'³ 'e³ cuu'²³ 'óo²ra'³ quia̱'n²na'³ miin²³na'³, quia̱'n²na'³ jo̱o̱³ra'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Qui² mɨ³ ja³guín²³ jmɨ́ɨ² 'e³ rɨ²³jua'³ dsa³: “Bi²³ dxʉ́²³ quie'² mɨ́³ 'i³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³cǿ̱n² jo̱o̱³¹, 'i³ 'a²³jia'³ lɨ'³ ca³la³huǿøn³ xi³yu̱u̱n³ quie'². Bi²³ dxʉ́²³ quie'² mɨ́³ 'i³ 'a²³jia'³ lɨ'³ ca³tʉ'n² xi³yu̱u̱n³.” La'³ rɨ²³jua'³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jmɨ́ɨ² jo̱³ li²³láa²³ rɨ²³sɨ'²³te'²³ mo'³ 'e³ cu²'ló¹ ñi'² quiee'³²te'²³, 'e³ rɨ²³sɨ'²³te'²³ cuo̱o̱'³ 'e³ cu²jlɨ́n¹te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Xi³nu³ la²³la³ cu³lø³¹ jme'²³te'²³ 'mo³ 'e³ røø'³ 'e³ la²³ jmoo³²te'²³ rɨ³nɨ²³, ¿jmii'³¹ cɨ² 'nɨɨ'n³¹ rɨ²³jme'²³te'²³ 'mo³ 'e³ mɨ³la³quiʉ̱ʉ̱³ ca³quie̱e̱²? La'³ xen³na'³ 'nee'²³ dsa³ juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Xen³ cɨ² áan²³ dsa³ 'i³ ca²³jøn²³te'²³ ca³ti³² quia̱'² Jesús 'e³ rɨ²³jŋɨ'n²³te'²³. Dsa³ 'i³ ca²³la²³jnée²³ dsoo² quiee'³² hua² 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ca²³dxi²³guín²³te'²³ je² xi̱i̱n³ mee²³ cua'² mɨ²dxi² dsa³. Núu²³ ca²³te̱e̱n³te'²³ cruz Jesús ca³ti³² quia̱'² dsa³ 'i³ ca²³la²³jnée²³ dsoo² quiee'³². Joo³¹ i²³la³ i²³nɨ³ ca²³te̱e̱n³te'²³ cɨ'³ la²³ jø̱n³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―Ñu'n², rɨ²jméen² u²³juee'³ dsɨɨ³² rɨ²mǿn¹nu³ dsa³ 'i³ jme'²³ jné². Qui² 'a²³jia'³ ñi³²te'²³ 'e³ la²³ lǿ² jmoo³²te'²³. ―La'³ ca²³jua'³ Jesús. Xa³ mɨɨ³¹ 'e³ ca²³co'² dsa³ 'láa³ 'e³ la²³ rɨ²³'aa²³ 'i'²³ 'e³ 'i̱i̱² sɨɨ'³¹ li²³røøn³ 'e³ rɨ²³co̱o̱²³ cɨ'³ la²³ co̱o̱³ 'noo³¹ 'mɨɨ'³ quiee'³² Jesús 'e³ la²³ ca²³to'²³te'²³ dxóo². ");
INSERT INTO cnlNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Té̱e̱n³ joo³² dsa³. Ca²³jáa² ca²³ŋɨ́ɨn² Jesús te'²³ dsa³ 'i³ ta'n² ta² jee²³² quiee'³² dsa³ Israel. Ca²³jua'³te'²³: ―Ca²³láan² dsa³, jua'³. Cu²láan¹ 'ñée² jo̱o̱²³na²³ xi³nu³ 'e̱'n³ quie'²³ dsɨ́² Cristo 'i³ ca²³'náan²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ca²³jáa² ca²³ŋɨ́ɨ² te'²³ dsa³ 'láa³ co̱'³. Ca²³guín²³cɨ²te'¹ mɨ³lén². Ca²³ji̱i̱'n³te'²³ Jesús jmɨɨ'³¹ mɨ²jø'² vino 'e³ ji̱i̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ca²³jua'³te'²³: ―Laan²³² 'uǿøn²nu³ xi³nu³ 'e̱'n³ quie'²³ dsɨ́² rɨ³løn³¹nu³ rey quien³² dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Co̱'³ cɨ'²³ to̱o̱²³ 'uø'² coo'² dxi² Jesús 'e³ jua'³: “'I³ la³ rey quien³² dsa³ Israel”. Ca²³té̱e̱²te'²³ 'uø'² júu² griego quia̱'² júu² latín quia̱'² júu² hebreo. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bi²³ 'ñe'² ca²³lʉ́³ jø̱n³ dsa³ 'i³ ca²³la²³jnée²³ dsoo² quiee'³² 'i³ ta̱a̱n²³ cruz quia̱'² Jesús. Ca²³sɨ'²³ Jesús: ―Rɨ³løn³¹nu³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios, ¿mɨ³naa'³¹? Laan²³² 'uǿøn²nu³ ca³ti³² quia̱'n²nu³ jnee'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","'E³ quie'²³ ca²³jíi² uu'n². Ca²³jua'³: ―¿'A² 'a²³jia'³ 'ñaa'n²³nu³ Dios? Qui² mɨ³dxi³te'²³ 'i'²³ 'e³ røø³ rɨ²³jú̱n³na², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dxi³ji̱i̱n³¹ 'e³ rɨ²³jú̱n³na² miin²³na². Qui² jmoo³²te'²³ jñiin²³na² 'e³ mɨ³jmee²ra² 'e³ 'a²³jia'³ dxʉ́²³. 'E³ quie'²³ 'a²³jia'³ dxi³ji̱i̱n³¹ 'e³ rɨ²³jú̱n³ dsa³ la³. Qui² 'a²³'e³ xa³ 'e³ mɨ³jmée³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―Jesús, rɨ²jméen² co̱o̱³ mɨ²'áa² 'e³ li²³liin³²nu³ jné² mɨ³li³gáan³nu³ la²³ gáan³ rey. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Rɨ²juøøn³¹na¹ 'nʉ³ ju²dsoo³¹: Jmɨ́ɨ² 'e³ rɨ³nɨ²³ li²³quia̱'n²nu³ jné² 'e³ jen³¹nu³ paraíso, je² jɨn³ dsɨ́² tén³ dsa³ 'i³ ca²³jmóo² ca³dsaan³². ");
INSERT INTO cnlNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","La²³ca̱a̱n³ dxaan²³ ñi'² ca²³lǿ²³ li³'o̱o̱³ mɨ³¹güii³. Lǿ² quie'²³ la'³ ca²³tɨ́³ hora 'nɨ³ 'e³ mɨ³cu³'lóo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ca²³uu³ ji³ quiee'³² ñi'². Ca²³xíin²³ 'mɨɨ'³ 'e³ ji̱i̱²³² ñʉ'²³ 'ñʉ́² gáan³. Ca²³lǿ²³ tú̱²³ juɨɨ²³². ");
INSERT INTO cnlNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","'E³ quie'²³ jo̱³ ca²³lʉ́³ quiʉ̱ʉ̱³ Jesús. Ca²³jua'³: ―Ñu'n², jné² dxen²³ guaan³² dsɨn²³. Ma²ca¹jua'³ la'³ Jesús, 'e³ quie'²³ jo̱³ ca²³dsá²³ dxí³ ta'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ma²ŋó¹ juii² dsa³ 'láa³ 'e³ jmii'³¹ cu³lø³¹ ca²³lǿ²³, 'e³ jo̱³ ca²³mi²³gáan³ Dios 'ñée². Ca²³jua'³: ―Ca³quie̱e̱² 'a²³'e³ dsoo² xa³ quie'² dsa³ la³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Juɨ́ɨn²³ dsa³ 'i³ ca²³ŋɨɨ'n²³ 'e³ jua'³ 'née²³ rɨ²³jóo² la²³jɨ³ 'e³ sɨ³lí³. 'E³ la²³ ca²³guiin³²te'²³ co̱'³, ca²³quiʉ̱́ʉ̱³te'²³ 'uǿ²te'²³ 'e³ jua'³te'²³ bi²³ ŋɨ́³ dsɨ́²te'²³ la²³jɨ³ 'e³ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","'E³ quie'²³ huɨ̱́ɨ̱³ té̱e̱n³ joo³² la²³jɨn³ dsa³ 'i³ cuiin²³ Jesús quia̱'² te'²³ mɨ́³ 'i³ ca²³qui̱i̱³ Jesús jí̱i̱n² estado Galilea. Joo³²te'²³ la²³jɨ³ 'e³ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Xen³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Søø³² 'i³ xen³ juɨɨ³ quiee'³² dsa³ Israel je² xi̱i̱n³ Arimatea. Bi²³ dxún²³ dsa³ 'í³. Bi²³ ca³dsaan³² jmee²³. Rɨ³løn³¹ dsa³ 'i³ dxa²³ ta² jee²³² quiee'³² dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","'E³ quie'²³ 'a²³jia'³ rɨ³løn³¹ co̱o̱³ júu² quia̱'² uu'n² ma²ca¹mi¹'ien³te'²³ júu² 'e³ rɨ²³jŋɨ'n²³te'²³ Jesús. Qui² 'née²³ 'ñée² 'e³ rɨ²³lín³ Dios juii² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","'E³ quie'²³ jo̱³ ŋóo² i²joon³ Pilato. Ca²³ŋɨ'n² 'lɨ́ɨ³. 'E³ jo̱³ 'ióo² júu² 'e³ rɨ²³tøø³ 'lɨ́ɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","'E³ jo̱³ ca²³jiáan² 'lɨ́ɨ³ je² ta̱a̱n²³ cruz. Ca²³pee'n³ 'mɨɨ'³ sɨɨ³². Ca²³'áan² ñʉ'²³ too³ 'loo³ 'e³ ca²³yʉ́ʉ²te'²³ ñʉ'²³ cú̱u̱² je² 'a²³jia'³ lɨ'³ ca³'áan²te'²³ 'lɨ́ɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ca²³jmée³ la'³ Søø³² jmɨ́ɨ² 'e³ mi³tɨ́ɨ²³ dsa³ Israel la²³ 'áa²³ rɨ²³tɨ́²³ jmɨ́ɨ² je² tøø³ dsɨ́²te'²³. Qui² mɨ³ rɨ²³tɨ́²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","I²guín¹ tu³cɨ̱ɨ̱n³ te'²³ mɨ́³ 'i³ ca²³ja²³guín²³ quia̱'² Jesús jí̱i̱n² estado Galilea. Ca²³jóo²te'²³ ñʉ'²³ too³ 'loo³. Ca²³jóo²te'²³ 'e³ jmii'³¹ ca²³'áan²te'²³ 'lɨ́ɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","'E³ quie'²³ jo̱³ ca²³guiin³²te'²³ co̱'³. Ca²³jmóo²te'²³ ji̱i̱³ 'oo³ mɨ³róo³ quia̱'² noo²³² mɨ³róo³ 'e³ 'uun³ dsa³ 'lɨ́ɨ³. Ca²³tøø³ dsɨ́²te'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ 'e³ la²³ dxi³ 'i'²³ ley quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","'E³ quie'²³ xe̱'n² tá³ jmɨ́ɨ² domingo i²guín¹ te'²³ mɨ́³ too³ 'loo³ co̱'³. Quie̱³te'²³ 'oo³ mɨ³róo³ 'e³ ca²³jmóo²te'²³ ji̱i̱³. Xen³ cɨ² mɨ́³ 'i³ ca²³guín²³ quia̱'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ŋó²³te'²³ 'e³ ca²³je̱'n²³ cú̱u̱² 'e³ ca²³jní³ 'oo'² too³ 'loo³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","'E³ jo̱³ ca²³ta'n²³te'²³ too³ 'loo³. 'E³ quie'²³ 'a²³'i̱³ ma²³ xen³ 'lɨ́ɨ³ Jesús Juii³ra². ");
INSERT INTO cnlNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","'E³ la²³ xín³ 'ín³te'²³ 'e³ jmii'³¹ lǿ² 'e³ ca²³lǿ²³ la'³, ŋǿn²te'²³ áan²³ dsa³ 'i³ té̱e̱n³ caan²³te'²³. Quii'³ 'mɨɨ'³ 'e³ bi²³ rɨ³jii'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","'E³ jo̱³ bi²³ ca²³jue'n² miin²³ mɨ́³. Ca²³quiaa³te'²³ xi³'lɨ² ca²³jñʉ́ʉ²³ 'uǿ²³ quí²te'²³. 'E³ quie'²³ jo̱³ ca²³jua'³ dsa³ 'í³. Ca²³sɨ'²³ mɨ́³: ―¿'Ee² lǿ² 'naa'n²³na'³ dsa³ 'i³ rɨ³ji̱'²³ je² 'aan³²te'²³ 'lɨ́ɨ³? ");
INSERT INTO cnlNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'A²³'i̱³ xen³ la³ xú̱n³. Qui² mɨ³ji̱i̱'²³ co̱'³. 'Ne'² li²³liin³²na'³ 'e³ jmii'³¹ ca²³jua'³ 'ñée² ma²nee'n²³²cɨ²na'³ quia̱'n²na'³ estado Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","'E³ la²³ rɨ³lø³¹ 'i'²³ hua² 'e³ ca²³jɨ̱'n²te'²³ 'ñée² Jo̱o̱³¹ Dsa³ quie'² dsa³ 'i³ bi²³ xa³ dsoo² quiee'³². Qui² ca²³jua'³ la'³ 'ñée² mɨ²jo̱³. 'E³ la²³ rɨ³lø³¹ 'i'²³ hua² 'e³ ca²³te̱e̱n³te'²³ cruz. 'E³ la²³ rɨ³lø³¹ 'i'²³ hua² 'e³ mɨ³ji̱i̱'²³ co̱'³ je² 'nɨ³ jmɨ́ɨ² 'e³ la²³ jú̱n²³. Qui² ca²³jua'³ la'³ 'ñée². ―La'³ ca²³jua'³ dsa³ 'i³ rɨ³jii'³¹ 'mɨɨ'³ 'e³ quii'³. Ca²³sɨ'²³ mɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","'E³ jo̱³ ca²³la²³líi²³te'²³ júu² 'e³ ca²³lʉ́³ Jesús mɨ²jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ma²ca¹dxi¹guiin³²te'²³ 'e³ la²³ i²guín¹te'²³ too³ 'loo³, ca²³jmóo²te'²³ júu² 'e³ jmii'³¹ ca²³lǿ²³. Ca²³sɨ'²³te'²³ dsa³ 'i³ gui²³quie̱e̱n³ quia̱'² la²³jɨn³ jia'³ cɨ'²³ dsa³ quien³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","I²³lee² quia̱'² I²³huoo² quia̱'² Ma³rii³¹ xóo² Jacobo quia̱'² mɨ́³ 'i³ quia̱'²te'²³, 'i³ 'í³ hua² 'i³ i²jmóo¹ júu², i²xii'²³² dsa³ xiin²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bi²³ ŋoo'² júu² 'e³ lʉ²³ te'²³ mɨ́³, lǿn³te'²³ dsa³ xiin²³. 'E³ jo̱³ 'a²³jia'³ ca²³táan³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","'E³ quie'²³ ŋóo² Peen²³² ca²³la²³dxí². Ca²³dxóo² too³ 'loo³. Tó̱o̱²³ rɨ³'in³². Ca²³jóo² ñʉ'²³. Ŋó²³ 'mɨɨ'³ sɨɨ³² 'e³ ro̱o̱³ ca³jné³. 'E³ jo̱³ bi²³ xín³ 'ín³ la²³jɨ³ 'e³ ca²³lǿ²³ 'e³ la²³ ŋø'n². ");
INSERT INTO cnlNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","'E³ quie'²³ jmɨ́ɨ² jo̱³ xen³ áan²³ dsa³ quien³² Jesús 'i³ ta'n² jui³¹ 'e³ sɨ³guiin³² juɨɨ³ je² xi̱i̱n³ Emaús. Xa³ co̱o̱³ gui²³quie̱e̱³ kilómetros 'e³ dsoo³²ra² Emaús naan³na² juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","'E³ la²³ ta'n²te'²³ jui³¹, lʉ²³te'²³ 'e³ jmii'³¹ lǿ² la²³jɨ³ 'e³ ca²³lǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","'E³ la²³ ta'n² lʉ²³te'²³, 'e³ sɨn²³te'²³, ca²³lǿn²³ mɨ³lén² 'ñée² Jesús. Ŋóo² quia̱'² te'²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² ca²³lǿ²³ juø'² ca²³la²³cuiin²³te'²³ Jesús xe̱'n², juø'n³ quie'²³ ŋǿn²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―¿'Ee² júu² 'e³ mi³róo²ra'³ 'e³ la²³ ta'n²na'³ jui³¹? ¿'Ee² lǿ² bi²³ ŋɨ́³ 'óo²ra'³? ");
INSERT INTO cnlNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","'E³ jo̱³ ca²³jua'³ jø̱n³ dsa³ 'í³ 'i³ xi̱i̱n³ Cleofas. Ca²³sɨ'²³ Jesús: ―Ñi³² la²³jɨn³ dsa³, juø'n³ quie'²³ dsa³ 'i³ i²guín¹ ca²³ji̱i̱³ juɨɨ³ Jerusalén, 'e³ jmii'³¹ cu³lø³¹ ca²³lǿ²³ núu²³ mɨ³tu³la³ nɨ³. ¿'A² jø̱n³ 'nʉ³ cɨ² 'íi² rɨ²máan² 'e³ jo̱³ ru'³? ");
INSERT INTO cnlNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","'E³ jo̱³ ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ 'í³: ―¿Jmii'³¹ cu³lø³¹ ca²³lǿ²³ jo̱o̱²³na²³? 'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―'En²³²na'³¹ Jesús dsa³ Nazaret. Dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios hua² 'í³ 'u². Lǿn³ Dios quia̱'² la²³jɨn³ dsa³ 'e³ bi²³ gáan³ la²³jɨ³ ta² 'e³ ca²³jmée³, la²³jɨ³ júu² 'e³ ca²³'ɨ́ɨ³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","'E³ quie'²³ ca²³jɨ̱'n² dsa³ 'í³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'i³ ta'n² ta² quiée²ra'³¹ 'e³ rɨ²³mi²³'ien³te'²³ júu² 'e³ rɨ²³jŋɨ'n²³te'²³. 'E³ jo̱³ ca²³te̱e̱n³te'²³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Líi³ra'³¹ xe̱'n² 'e³ 'i³ 'í³ hua² 'i³ rɨ²³láan² dsa³ Israel 'u². 'E³ quie'²³ 'a²³la³ 'nɨɨ'n³¹ la'³. Rɨ³nɨ²³ mɨ³tɨ́³ 'nɨ³ jmɨ́ɨ² 'e³ ca²³jŋɨ'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Xen³ ca³dxáan² uu'n²na'³¹ 'i³ mɨ́³ 'i³ mɨ³jmóo² 'e³ juø'²³ mɨ³ti³cø̱n³¹na'³¹. Mɨ³'ñʉʉ² tá³ mɨ³i²guín¹te'²³ too³ 'loo³ je² ca²³'áan²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","'E³ quie'²³ 'a²³'i̱³ xen³ 'lɨ́ɨ³. 'E³ jo̱³ mɨ³ja³guiin³²te'²³ co̱'³. 'É̱e̱² 'e³ mɨ³cɨ́³te'²³ mɨ³ji̱'²³te'²³, mɨ³jua'³te'²³, 'e³ mɨ³ŋøn³² te'²³ ángeles 'i³ mɨ³jua'³ 'e³ rɨ³ji̱'²³ co̱'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mɨ³i²guín¹ too³ 'loo³ ca³dxáan² dsa³ 'i³ quia̱'n²na'³¹. Lǿ² ca³quie̱e̱² too³ 'loo³ 'e³ la²³ lǿ² mɨ³jua'³ te'²³ mɨ́³. 'E³ quie'²³ 'a²³jia'³ ca³ŋøn³²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―¡Bi²³ 'uaa'³ mɨ²dxí²ra'³! ¡Bi²³ rɨ³laa³ 'óo²ra'³ 'e³ 'a²³jia'³ sɨ³táan³na'³ la²³jɨ³ 'e³ ca²³jua'³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³²! ");
INSERT INTO cnlNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³dxi²³quié̱n² la'³ Cristo 'i³ rɨ²³xíin²³ Dios, ¿mɨ³naa'³¹? Jo̱³ hua² li²³gáan³ 'ñée². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ca²³tín²³ lʉ²³ je² lʉ²³ ji³ 'e³ ca²³jmée³ Moisés quia̱'² je² lʉ²³ la²³jɨ³ ji³ 'e³ ca²³jmóo² dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². Ca²³jmée³ jɨn³. Ca²³sɨ'²³ dsa³ 'í³ 'e³ jmii'³¹ lǿ² la²³jɨ³ júu² quiee'³² Dios je² 'en³² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","'E³ quie'²³ jo̱³ ca²³lǿn²³te'²³ mɨ³lén² juɨɨ³ je² sɨ³guiin³²te'²³. Ca²³ŋɨ́n³ ca³dsaan³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","'E³ quie'²³ ca²³sɨ'²³te'²³ 'e³ cu²cuaa'n²³ ca³quie̱e̱². Ca²³jua'³te'²³: ―Rɨ²cuaa'n²³nu³ quiée²ra'³¹ xú̱n³. Qui² mɨ³ rɨ²³nʉʉ³. Ca³juɨ² cɨ² jné³. 'E³ jo̱³ 'í² xi²ñʉ'¹ Jesús. Ca²³cuaa'n²³ quie'² dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","'E³ la²³ jen³¹ coo³¹ mesa quia̱'² te'²³ dsa³ 'í³, 'e³ quie'²³ jo̱³ so̱'²³ 'ɨ²³juɨ². Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. Ca²³xíin² 'ɨ²³juɨ². Ca²³cuǿø²³ te'²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","'E³ quie'²³ jo̱³ ca²³lǿ²³ 'é̱e̱² 'e³ ca²³mo'² mɨ²ñi²te'¹. Ca²³la²³cuiin²³te'²³ Jesús. 'E³ quie'²³ jo̱³ co̱'³ la²³ ca²³lǿ²³ 'e³ 'a²³'i̱³ ma²³ xen³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ca²³lʉ́³te'²³ i²³la³ i²³nɨ³. Ca²³jua'³te'²³: ―Bi²³ 'née²³ dsɨ³ra² 'e³ la²³ mɨ³lʉ́³ quia̱'² jne² dxi²jui³¹, 'e³ la²³ mɨ³jmée³ jɨn³ júu² quiee'³² Dios 'e³ to̱o̱²³ ji³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","'E³ jo̱³ ca²³'uǿøn²³te'²³ xe̱'n² jmɨ́ɨ². Ca²³guín²³te'²³ co̱'³ juɨɨ³ Jerusalén. I²joon³te'²³ dsa³ 'i³ gui²³quie̱e̱n³ quia̱'² dsa³ 'i³ rɨ³ŋɨɨn³¹ quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ca²³jua'³ dsa³ 'i³ rɨ³ŋɨɨn³¹. Ca²³sɨ'²³ dsa³ 'i³ ca²³dxi²³guín²³ co̱'³: ―Ca³quie̱e̱² mɨ³ji̱i̱'²³ co̱'³ Juii³ra². Mɨ³mi³jnen³ 'ñée² caan²³ Muun³² ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","'E³ quie'²³ jo̱³ ca²³jmóo² júu² miin²³ dsa³ 'i³ ca²³dxi²³guín²³ co̱'³ 'e³ jmii'³¹ lǿ² 'e³ ca²³lǿ²³ dxi²jui³¹, 'e³ jmii'³¹ lǿ² 'e³ ca²³la²³cuiin²³te'²³ Jesús 'e³ la²³ ca²³xíin² 'ɨ²³juɨ². ");
INSERT INTO cnlNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","'E³ la²³ lʉ²³te'²³ la'³, co̱'³ cɨ'²³ ca²³jmée³ Jesús 'e³ mɨ³xi'n²³ ja² jee²³² quiee'³²te'²³. Ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―Cu²li³co̱o̱³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","'E³ jo̱³ juø'²³ ca²³jóon²te'²³. Bi²³ ca²³jue'n² miin²³. Lǿn³te'²³ 'e³ 'lɨ́ɨ³ hua² joon³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","'E³ quie'²³ ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ 'í³: ―¿'Ee² lǿ² bi²³ ñúun³ 'óo²ra'³? ¿'Ee² lǿ² 'a²³jia'³ sɨ³táan³na'³? ");
INSERT INTO cnlNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jóo²ra'³ guaan²³. Jóo²ra'³ tɨɨn²³. Jné² hua² la³. Xe̱e̱'³ra'³ jmɨn²³ ŋun²³. 'E³ jo̱³ rɨ²móo²ra'³ jo̱o̱²³na²³ 'e³ xa³ jmɨn²³ ŋun²³ jné². Qui² 'a²³'e³ xa³ jmɨ² ŋu² 'lɨ́ɨ³, ¿mɨ³naa'³¹? 'E³ quie'²³ joo³²ra'³ 'e³ xa³ jmɨn²³ ŋun²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ma²ca¹jua'³ la'³ Jesús, ca²³'ée²³ dsa³ guoo³ tɨɨ². ");
INSERT INTO cnlNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Rɨ²³jú̱n³la²³cɨ²te'¹ 'e³ la²³'nɨɨ'n³¹ 'née²³te'²³ 'u² cu²ru'³ 'e̱'n³, lǿn³te'²³. 'E³ quie'²³ 'a²³jia'³ 'e̱'n³ la²³ cɨ² lǿn³te'²³. Bi²³ juø'²³ ca²³ti²³cø̱n³¹te'¹. 'E³ quie'²³ jo̱³ ca²³jua'³ 'ñée². Ca²³sɨ'²³ dsa³ quien³²: ―¿'A² juø'² xa³ la³ 'e³ rɨ²ee'n²³²? ");
INSERT INTO cnlNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'E³ jo̱³ ca²³cuǿø²³te'²³ co̱o̱³ 'noo³¹ quie'² 'moo'³ 'e³ ca²³too³te'²³ dxi³¹ji³ quia̱'² ca³juɨ² cuɨɨ'² to'² 'e³ 'o² jmɨɨ'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Có̱²³ 'ñée² 'e³ jo̱³. Ca²³e'² 'ñée² quia̱'² 'noo³¹ quie'² 'moo'³ xi²ñi² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","'E³ quie'²³ jo̱³ ca²³jua'³: ―Mɨ³lǿ²³ 'e³ la²³ ca²³juǿøn²na²³ 'nee'²³ mɨ²jo̱³ ma²ca¹ŋɨ́n¹ quia̱'n²³²na¹ 'nee'²³. Ca²³juǿøn²na²³ 'nee'²³ 'e³ 'ne'² rɨ²³lí³ la²³jɨ³ 'e³ to̱o̱²³ ji³ 'e³ rɨ²³lí³ 'e³ 'en³² jné². 'Ne'² rɨ²³lí³ 'e³ la²³ to̱o̱²³ ley 'e³ ca²³ŋɨ́n² Moisés quia̱'² ji³ 'e³ ca²³jmóo² dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³² quia̱'² ji³ 'e³ xi̱i̱n³ Salmos. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","'E³ jo̱³ ca²³jmée³ Jesús 'e³ ca²³tɨ́³ dsɨ́²te'²³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ca²³jua'³: ―La²³la³ cu³lø³¹ to̱o̱²³ ji³: 'Ne'² rɨ²³dxi²³quié̱n² Cristo 'i³ rɨ²³xíin²³ Dios. Je² 'nɨ³ jmɨ́ɨ² 'e³ la²³ jú̱n²³ 'ne'² rɨ²³ji̱i̱'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","'E³ cɨ² rɨ²³'ɨ́ɨ²³ dsa³ júu² quiee'³² jee²³² quiee'³² la²³jɨn³ dsa³ 'e³ jua'³ rɨ³løn³¹te'¹ dsa³ quien³² Cristo. Juɨɨ³ Jerusalén rɨ²³tín²³te'²³ xe̱'n². Rɨ²³sɨ'²³te'²³ dsa³ 'e³ 'ne'² rɨ²³tʉ́²te'²³ 'e³ jmoo³²te'²³ 'e³ 'a²³jia'³ dxʉ́²³ 'e³ la²³ rɨ²³yʉʉ³ dsoo² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","'Nee'²³ rɨ³løn³¹na'³ dsa³ ñi³ quién²³na²³. Qui² mɨ³ñíi³ra'³ la²³jɨ³ 'e³ mɨ³jí̱i̱n²³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jné² rɨ²sɨɨn³¹na¹ Espíritu Gáan³ quién² 'nee'²³ 'e³ rɨ²cø̱n²³na'³ 'e³ la²³ ca²³jua'³ Ñu'n²³ 'e³ rɨ²³lí³. 'E³ quie'²³ rɨ²cuaa'n²³na'³ juɨɨ³ la³ la²³huø'n²³ rɨ²³tɨ́²³ 'e³ rɨ²³'ién²na'³ ju²³bíi²³ 'e³ rɨ²³jióo²³ jí̱i̱n² yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","'E³ jo̱³ ca²³jøn²³ dsa³ quien³² 'ioo³¹ juɨɨ³ Betania. Ca²³xóo² yʉʉ'³¹ guoo³: Ca²³mi²³jé̱e̱n² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","'E³ la²³ mi³jé̱e̱n² dsa³ quien³², ca²³bǿn³ jee²³² quiee'³²te'²³. Ca²³huɨ́ɨ³ yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","'E³ jo̱³ ca²³mi²³gáan³te'²³ Jesús. 'E³ quie'²³ jo̱³ bi²³ jɨn³ dsɨ́²te'²³ ca²³guiin³²te'²³ co̱'³ juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bi²³ ca³xe̱e̱'n³ ca²³ta'n²³te'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Núu²³ ca²³mi²³gáan³te'²³ Dios. Nɨ³ mɨ³líi².");
INSERT INTO cnlNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mɨ²xe̱'n³¹ xen³ 'i³ xi̱i̱n³ Júu² quiee'³² Dios. Quia̱'² Dios jen³¹ 'ñée² mɨ²jo̱³. Qui² Dios rɨ³løn³¹ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jen³¹ quia̱'² Dios cɨ'²³ mɨ²xe̱'n³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ta² quiee'³² 'ñée² hua² 'e³ ca²³lǿ²³ la²³jɨ³ 'e³ xa³. 'U² cu²ru'³ 'a²³jia'³ xen³ 'ñée², sú̱n² quie'²³ 'a²³jia'³ ca²³la²³xa³ la²³jɨ³ 'e³ xa³ cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","'I³ 'í³ hua² 'i³ ca²³jmée³ 'e³ rɨ³ji̱'²³ dsa³. La²³ xen³ ji³ xen³ 'ñée². Qui² jmee²³ 'e³ jné³ jui³¹ je² ŋɨ́³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Je² li³'o̱o̱³ cuø²³ jmɨ́ɨ²³ ji³ jo̱³. 'A²³jia'³ jmɨ́ɨ² ca²³lǿ²³ juø'² ca²³yʉ́ʉ³te'²³, juø'n³ jmi'³ 'nɨɨ'n³¹ li³'o̱o̱³ je² ca²³cuǿ³ jmɨ́ɨ²³ ji³ jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios ca²³xíin²³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Güén²³ mɨ³¹güii³ 'e³ jua'³ rɨ²³lín³ dsa³ ñi³, 'e³ jua'³ rɨ²³sɨ'²³ dsa³ 'e³ mɨ³la³jné³ ji³ quiee'³² Dios, 'e³ jua'³ 'née²³ 'e³ rɨ²³sɨ²³táan³ la²³jɨn³ dsa³ mɨ³rɨ³nʉʉ³te'²³ júu² 'e³ lʉ²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","'A²³la³ 'ñée² Juan 'i³ rɨ³løn³¹ ji³. 'E³ quie'²³ güén²³ 'e³ jua'³ rɨ²³sɨ'²³ dsa³ 'e³ mɨ³la³jné³ ji³ quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mɨ³láa²³ sɨ³bó² jmɨ́ɨ²³ quiee'³² 'ñée² 'i³ rɨ³løn³¹ ji³ ca³quie̱e̱² 'i³ jmee²³ 'e³ jné³ jui³¹ je² ŋɨ́³ la²³jɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jen³¹ mɨ³¹güii³ 'ñée². 'E³ quie'²³ dsa³ mɨ³¹güii³ 'a²³jia'³ jmɨ́ɨ² ca²³la²³cuiin²³te'²³ 'ñée², juø'n³ quie'²³ 'ñée² ca²³jmée³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Güe'n² 'ñée² je² rɨ³lø³¹ quie'². 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² ca²³'i'n²te'²³ 'ñée², juø'n³ quie'²³ rɨ³løn³¹ juii²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","'E³ quie'²³ xen³ dsa³ 'i³ ca²³'i'n², 'i³ ca²³táan³ quia̱'². 'I³ 'í³ hua² 'i³ 'ióo² júu² 'e³ rɨ²³lín³te'²³ jo̱o̱³¹ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","'A²³la³ jo̱³ 'e³ la²³ lǿ² 'e³ sɨ³li³xen³ jo̱o̱³¹ dsa³ mɨ³¹güii³ 'e³ sɨ³li³xen³ jo̱o̱³¹ Dios. 'A²³la³ jo̱³ 'e³ xen³ dsóo²³ 'i³ 'née²³ la'³ 'e³ sɨ³li³xen³. 'E³ quie'²³ 'ñée² Dios jmee²³ 'e³ sɨ³li³xen³ jo̱o̱³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ca²³la²³xa³ jmɨ² ŋu² 'ñée² 'i³ xi̱i̱n³ Júu² quiee'³² Dios jo̱o̱²³na²³. Ca²³gua³ jee²³² quiee³²ra². Bi²³ ma²³'nee³ 'uǿn² 'ñée². Jmø'n² la²³ ju²dsoo³¹ lʉ²³. Ca²³ne²ra'³¹ 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³ 'ñée². Qui² Jo̱o̱³¹ Dios 'i³ jø̱n³ qui³ xen³ hua² 'í³. 'E³ jo̱³ hua² 'e³ gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","'I³ 'í³ hua² 'i³ ca²³'én² Juan ma²ca¹lʉ́³. Ca²³jua'³: ―'I³ la³ dsa³ 'i³ ca²³'ǿn²³na²³ mɨ²jo̱³ ma²ca¹juø'n¹: “'E³ cɨ² rɨ²³güén³ jø̱n³ dsa³ 'i³ cɨ̱ɨ̱n³ cɨ² la²³ jné². Bi²³ cɨ² gáan³ 'ñée² la²³ cɨ'²³ jné². Qui² xen³ 'ñée² ma²ca¹la¹xen²³na²³.” ―La'³ ca²³jua'³ Juan mɨ²jo̱³ ma²ca¹'én¹ 'i³ xi̱i̱n³ Júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bi²³ ma²³'nee³ 'uǿn² 'ñée². Tén³ la²³ jmee²³ co̱²juø'¹ quiée²ra² la²³jɨn³na². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés ca²³ŋɨ́n² ley. 'E³ quie'²³ Jesucristo ca²³jmée³ lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'uǿn² Dios. Ca²³lʉ́³ ju²dsoo³¹ quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","'A²³'i̱³ xen³ dsa³ 'i³ lɨ'³ ca³ŋøn³² Dios. 'E³ quie'²³ mɨ³jmée³ Jo̱o̱³¹ 'e³ mɨ³la³cuiin²³na². La'³ mɨ³jmée³ Jo̱o̱³¹ 'i³ jø̱n³ qui³ xen³, 'i³ bi²³ ma²³'nee³ 'néen². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","La²³la³ cu³lø³¹ júu² 'e³ ca²³jmée³ Juan 'i³ rɨ³løn³¹ dsa³ ñi³: Te'²³ juii² dsa³ Israel ca²³xíin²³ jmii³ dsa³ quia̱'² dsa³ levita jí̱i̱n² juɨɨ³ Jerusalén 'e³ jua'³ sɨ³ŋɨ́ɨ³te'²³ júu² quie'² Juan. 'E³ jo̱³ ca²³jua'³te'²³: ―¿'I̱i̱² sɨɨ'³¹ 'nʉ³? ―ca²³sɨ'²³te'²³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jɨn³ ca²³jmée³ júu² Juan. Ca²³jua'³: ―'A²³la³ 'í³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios jné² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Co̱'³ cɨ'²³ ca²³sɨ'²³te'²³ Juan: ―¿'I̱i̱² sɨɨ'³¹ 'nʉ³ jo̱o̱²³na²³? ¿'A² Elías hua² 'nʉ³? 'E³ quie'²³ ca²³jua'³ Juan: ―'A²³la³ 'í³ jné² xú̱n³. Co̱'³ cɨ'²³ ca²³ŋɨ'²³te'²³ júu² Juan: ―¿'A² 'nʉ³ dsa³ 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³güén³ 'i³ rɨ²³'ɨ́ɨ²³ júu² quiee'³² Dios? ―ca²³sɨ'²³te'²³. ―'A²³la³ 'í³ jné² xú̱n³ ―ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","'E³ jo̱³ ca²³sɨ'²³te'²³ co̱'³ cɨ'²³: ―¿'I̱i̱² sɨɨ'³¹ 'nʉ³ jo̱o̱²³na²³? Jmee² júu². Qui² 'nee³ra'³¹ rɨ²quie̱e̱²³²ra'³¹ júu² 'e³ rɨ²xii'³¹ra'³¹ dsa³ 'i³ mɨ³xíin²³ jnee'³¹. ¿Jmii'³¹ juø'n³ 'nʉ³ 'e³ 'ǿn²³nu³ 'uǿøn²nu³? ");
INSERT INTO cnlNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","'E³ jo̱³ ca²³jua'³ Juan: ―Jné² hua² 'i³ lʉn²³ quiʉ̱ʉ̱³ je² 'a²³jia'³ nee'n²³² dsa³. Juøøn³²na²³ dsa³ 'e³ la²³ lǿ² ca²³jua'³ Isaías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², 'e³ rɨ²³lí³. Ca²³jua'³ Isaías: “Rɨ²jmée²ra'³ jui³¹ 'e³ ca³dsaan³² je² rɨ²³ŋɨ́n³ Juii³ra²”. La'³ cu³lø³¹ júu² 'e³ juøøn³²na²³ dsa³. ―La'³ ca²³jua'³ Juan. Ca²³sɨ'²³ dsa³ 'i³ ca²³ŋɨ́ɨ³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Dsa³ fariseo hua² 'i³ ca²³xíi²³ quie'² te'²³ dsa³ 'í³ 'e³ jua'³ rɨ²³sɨ²³ŋɨ́ɨ³te'²³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","'E³ quie'²³ jo̱³ ca²³lʉ́³ co̱'³ dsa³ 'í³. Ca²³sɨ'²³te'²³ Juan: ―¿'Ee² lǿ² xaan²³nu³ dsa³ jmɨɨ³ jo̱o̱²³na²³?, xi³nu³ 'a²³la³ 'í³ Cristo, xi³nu³ 'a²³la³ 'í³ Elías, xi³nu³ 'a²³la³ 'í³ dsa³ 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³güén³ 'i³ rɨ²³'ɨ́ɨ²³ júu² quiee'³² Dios hua² 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","'E³ jo̱³ ca²³jua'³ Juan. Ca²³sɨ'²³ dsa³ 'í³: ―Jmɨɨ³ hua² caa'n³² jné² 'e³ la²³ xaan²³na²³ jmɨɨ³ dsa³. 'E³ quie'²³ xen³ 'i³ xi'n²³ jee²³² quien³²na'³ 'i³ 'a²³jia'³ cuiin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","'I³ 'í³ hua² 'i³ ca²³juø'n² 'i³ cɨ̱ɨ̱n³ cɨ² la²³ jné². 'A²³jia'³ li²³bii²³ dsɨn²³ cu³xi³ 'e³ rɨ²'uøøn²³² loo³ 'e³ taa'² tɨɨ² 'e³ la²³'nɨɨ'n³¹ gáan³ 'ñée². ―La'³ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Je² xi̱i̱n³ Betania ca²³lǿ²³ la'³, 'ŋóo² la²³ jmɨɨ³ juee'³ Jordán. Qui² núu²³ jen³¹ Juan 'e³ jua'³ xaan³² dsa³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","La²³ mɨ³dxóo³ la'³ ŋó²³ Juan 'e³ ja³'ɨ́ɨn²³ Jesús. 'E³ jo̱³ ca²³jua'³: ―Jóo²ra'³. 'I³ la³ 'i³ mɨ³cuǿn² Dios, 'i³ je̱'n³² dsoo² quiee'³² dsa³ mɨ³¹güii³. Qui² xen³ 'ñée² la²³ xen³ dsɨɨ³ joo³ 'i³ jŋɨ'n²³te'²³ 'e³ jua'³ rɨ²³co̱o̱²³ dsoo² quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","'I³ la³ dsa³ 'i³ ca²³'ǿn²³na²³ mɨ²jo̱³ ma²ca¹juø'n¹: “'E³ cɨ² rɨ²³güén³ jø̱n³ dsa³ 'i³ cɨ̱ɨ̱n³ cɨ² la²³ jné². Bi²³ cɨ² gáan³ 'ñée² la²³ cɨ'²³ jné². Qui² xen³ 'ñée² ma²ca¹la¹xen²³na²³.” ");
INSERT INTO cnlNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","'A²³jia'³ ca²³maan²³ xe̱'n² 'e³ 'i̱i̱² hua² sɨɨ'³¹ 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios. 'E³ quie'²³ ca²³la²³'náan²³ 'e³ rɨ²ne²ra² jne² dsa³ Israel 'e³ 'i̱i̱² sɨɨ'³¹. 'E³ jo̱³ hua² 'e³ güén²³na²³ xaan²³na²³ jmɨɨ³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","'E³ jo̱³ ca²³lǿn²³ dsa³ ñi³ Juan. Ca²³jmée³ júu². Ca²³jua'³: ―Ca²³mǿn²na²³ Espíritu Gáan³ 'e³ la²³ jŋáan² jí̱i̱n² yʉʉ'³¹ güii³. La²³ lǿn²³ to̱³ju̱³¹ lǿn²³. Ca²³cuaa'n²³ ñi'² quiee'³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","'A²³jia'³ ca²³maan²³ xe̱'n² 'e³ 'i̱i̱² hua² sɨɨ'³¹ 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios. 'E³ quie'²³ ca²³jua'³ Dios 'i³ ca²³xíin²³ jné² 'e³ rɨ²xaan²³na²³ jmɨɨ³ dsa³. Ca²³sɨ'²³ jné²: “'E³ cɨ² rɨ²máan² 'e³ rɨ²³jiaan³² Espíritu Gáan³ ñi'² quiee'³² jø̱n³ dsa³. 'E³ quie'²³ rɨ²³cuaa'n²³ Espíritu Gáan³ ñi'² quiee'³². Dsa³ 'í³ hua² 'i³ rɨ²³jmée²³ 'e³ rɨ²³'íin³ dsɨ́² dsa³ Espíritu Gáan³ quién²³na²³. La'³ cu³lø³¹ 'e³ rɨ²³xáan² dsa³ jmɨɨ³ 'ñée².” La'³ cu³lø³¹ ca²³sɨ'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'E³ quie'²³ ca²³maan²³ 'e³ ca²³lǿ²³ 'e³ la²³ ca²³sɨ'²³ jné². 'E³ jo̱³ hua² 'e³ rɨ³løn³¹na¹ dsa³ ñi³ 'e³ jmeen²³ júu² 'e³ Jo̱o̱³¹ Dios dsa³ la³. ―La'³ ca²³jua'³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","La²³ mɨ³dxóo³ la'³ xi'n²³ Juan quia̱'² áan²³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ŋǿn² Jesús 'e³ la²³ ca²³ŋɨ́n³. 'E³ jo̱³ ca²³jua'³. Ca²³sɨ'²³ dsa³ quien³²: ―Jóo²ra'³. 'I³ la³ 'i³ mɨ³cuǿn² Dios. La²³ xen³ dsɨɨ³ joo³ xen³. ―La'³ ca²³jua'³ ca²³'én² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ca²³núu³ te'²³ dsa³ quien³² 'e³ jmii'³¹ ca²³jua'³ Juan. 'E³ jo̱³ ca²³guín²³te'²³ tu³cɨ̱ɨ̱n³te'²³ 'e³ la²³ ŋóo² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","'E³ quie'²³ jo̱³ ca²³ji̱i̱n²³ Jesús. Ŋó²³ 'e³ ja³guín²³ dsa³ tu³cɨ̱ɨ̱n³. Ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ―¿'Ee² 'noo³¹ 'noo³ra'³? 'E³ jo̱³ ca²³jua'³te'²³: ―Rabí ―ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús. Qui² la'³ cu³lø³¹ jua'³te'²³ dsa³ 'e²³ ju²³jmii²³² quiee'³²te'²³―. ¿Jiaa'³¹ jen³¹nu³? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Mɨ²³gui²³²ra². Jo̱³ hua² rɨ²móo²ra'³ ―ca²³jua'³. 'E³ jo̱³ i²joo³te'²³ 'e³ jiaa'³¹ jen³¹. Ca²³cuaa'n²³te'²³ quia̱'²te'²³ jmɨ́ɨ² jo̱³. Qui² mɨ³tɨ́³ la²³ca̱a̱n³ hora 'e³ quiʉ̱́³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Drøø³¹ xi̱i̱n³ jø̱n³ dsa³ 'í³ 'i³ ca²³núu³ 'e³ jmii'³¹ ca²³jua'³ Juan, 'i³ ŋóo² quia̱'² Jesús. La²³ ca³já̱a̱n² quia̱'² Muun³² Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Xe̱'n² jmɨ́ɨ² ŋóo² Drøø³¹ 'e³ jua'³ sɨ³jen³ jó̱o̱² 'i³ xi̱i̱n³ Muun³². Ca²³jua'³ Drøø³¹. Ca²³sɨ'²³ Muun³²: ―Mɨ³jí̱i̱n³na'³¹ Mesías, ¿mɨ³naa'³¹? ―ca²³jua'³. Qui² Mesías sɨ'²³te'²³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios ju²³jmii²³² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","'E³ quie'²³ jo̱³ i²jøn²³ jó̱o̱² caan²³ Jesús. Ca²³jóon² Muun³² Jesús. Ca²³jua'³: ―Muun³² jo̱²³ñʉʉ'³¹ Jonás xi̱i̱n³nu³ rɨ³nɨ²³. 'E³ quie'²³ 'e³ cɨ² rɨ²³sɨ'²³te'²³ 'nʉ³ Cefas. ―La'³ ca²³jua'³ Jesús. 'E³ quie'²³ Peen²³² jua'³te'²³ júu² griego, la'³ sɨ'²³te'²³ dsa³ 'i³ xi̱i̱n³ Cefas. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","La²³ mɨ³dxóo³ la'³ ca²³la²³'née²³ Jesús 'e³ rɨ²³dsø'n² estado Galilea. 'E³ quie'²³ jo̱³ ca²³mi²³jí̱i̱n³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Bi³lii². 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ Bi³lii²: ―Ñe³ quia̱'n²nu³ jné² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Juɨɨ³ Betsaida xen³ Bi³lii². Co̱o̱³ juɨɨ³ xen³ quia̱'² Drøø³¹ quia̱'² Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","'E³ quie'²³ jo̱³ ŋóo² Bi³lii² 'e³ jua'³ sɨ³jen³ dsa³ 'i³ xi̱i̱n³ Natanael. Ca²³jua'³ Bi³lii². Ca²³sɨ'²³ Natanael: ―Mɨ³jí̱i̱n³na'³¹ dsa³ 'i³ ca²³'én² Moisés ma²ca¹té̱e̱¹ ji³ ley, 'e³ quie'²³ dsa³ 'i³ ca²³'én² te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². Jesús jo̱o̱³¹ Søø³² hua² 'í³. Juɨɨ³ Nazaret xen³. ―La'³ ca²³jua'³ Bi³lii². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","'E³ jo̱³ ca²³jua'³ Natanael. Ca²³sɨ'²³ Bi³lii²: ―¿'A² juø'² xa³ 'e³ dxʉ́²³ juɨɨ³ Nazaret cu²ne²ra²? 'E³ quie'²³ ca²³jua'³ Bi³lii². Ca²³sɨ'²³ Natanael: ―Mɨ²³gui²³²ra². Rɨ²máan². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","'E³ quie'²³ ŋó²³ Jesús 'e³ ca²³ja²³'ɨ́ɨn²³ Natanael. 'E³ jo̱³ ca²³jua'³ ca²³'én² Natanael: ―Jóo². Mɨ³ ja³'ɨ́ɨn²³ jø̱n³ dsa³ 'i³ rɨ³løn³¹ dsa³ Israel ca³quie̱e̱². Qui² 'a²³jia'³ te³ jmee²³ guóo². ");
INSERT INTO cnlNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","'E³ jo̱³ ca²³jua'³ Natanael. Ca²³sɨ'²³ Jesús: ―¿Jmii'³¹ lǿ² 'e³ cuiin²³nu³ jné²? 'E³ jo̱³ ca²³jua'³ Jesús: ―'E³ la²³ 'iún²nu³ ñʉ'²³ 'mo³ higo 'e³ 'íi² rɨ²³tøø³ 'nʉ³ Bi³lii² mɨ³mǿn²na²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","'E³ jo̱³ ca²³jua'³ Natanael. Ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³, Jo̱o̱³¹ Dios hua² 'nʉ³. Rey quien³² dsa³ Israel hua² 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Natanael: ―Mɨ³juǿøn²na²³ 'nʉ³ 'e³ mɨ³mǿn²na²³ 'nʉ³ 'e³ la²³ 'iún²nu³ ñʉ'²³ 'mo³ higo. ¿'A² juø'² 'e³ jo̱³ hua² 'e³ sɨ³táan³nu³ quia̱'n²nu³ jné²? Bee'² cɨ² bíi²³ la²³jɨ³ 'e³ cɨ² rɨ²máan². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Co̱'³ cɨ'²³ ca²³jua'³ ca²³sɨ'²³ Natanael: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'E³ cɨ² rɨ²móo²ra'³ 'e³ rɨ³nó³ yʉʉ'³¹ güii³. Rɨ²móo²ra'³ 'e³ sɨ³huɨ́ɨ³, 'e³ sɨ³jiaan³² ángeles quien³² Dios caan²³ jné² Jo̱o̱³¹ Dsa³. ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Natanael. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ma² ca²³ŋɨ́n³ 'nɨ³ jmɨ́ɨ² la'³, tǿø² mɨ́³ jø̱n³ dsa³ 'i³ xen³ juɨɨ³ Caná estado Galilea. Núu²³ jen³¹ mɨ²juee'³ xóo² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","'E³ quie'²³ ca²³tøø³te'²³ Jesús quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","'E³ quie'²³ ca²³dsá²³ jmɨɨ'³¹ mɨ²jø'² vino quie'²te'²³. 'E³ jo̱³ ca²³jua'³ xóo² Jesús. Ca²³sɨ'²³ jo̱o̱³¹: ―'A²³'e³ ma²³ xa³ jmɨɨ'³¹ mɨ²jø'² vino quie'²te'²³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ xóo²: ―'A²³jia'³ røø³ lǿ² ta² quiée²ra², nii²³². 'A²³jia'³ ca³tɨ́³ jmɨ́ɨ² quián²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","'E³ quie'²³ ca²³jua'³ xóo². Ca²³sɨ'²³ te'²³ mozos: ―Rɨ²jmée²ra'³ 'e³ la²³ rɨ²³jua'³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Núu²³ née² jñʉ́ʉ³ mɨɨ³¹ mɨ²dsuu² coo'² 'e³ rɨ³lø³¹ cú̱u̱² 'e³ to̱'²³ xii'²³ jmɨɨ³ dsa³ Israel. Sɨ³tɨ́²³ 'e³ coo'³²te'²³ mɨ²dsuu² jo̱³ mɨ³rɨ³jii³ rɨ³u̱u̱'n³ miin²³ quia̱'² la²³jɨ³ 'e³ coo'³²te'²³ 'e³ lǿn³ miin²³ 'e³ mɨ³la³'lʉʉ'². Sɨ³'í³ co̱o̱³ i³lóo³ litros, sɨ³'í³ guiáa³ 'a²³ ti³² co̱o̱³ i³lóo³ litros cɨ'³ la²³ co̱o̱³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ca²³jua'³ Jesús. Ca²³sɨ'²³ mozos: ―Cu³mi³quie̱e̱'n²³na'³ jmɨɨ³ mɨ²dsuu² jo̱o̱²³na²³. 'E³ jo̱³ ca²³xi'²³te'²³ jmɨɨ³ mɨ²dsuu². Ca²³mi²³quie̱e̱'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mozos: ―Li² ca³juɨ² jo̱o̱²³na²³. Cu³cuøø² dsa³ 'i³ jmee²³ cua̱a̱n²tu² mɨ²juee'³ ―ca²³jua'³. 'E³ jo̱³ i²co̱³te'²³ quie'² dsa³ 'i³ jmee²³ cua̱a̱n²tu² mɨ²juee'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","'E³ quie'²³ jo̱³ 'ɨ̱'²³ ca³juɨ² dsa³ 'í³. Jmɨɨ³ hua² rɨ³lø³¹ xe̱'n². 'E³ quie'²³ ca²³lǿ²³ jmɨɨ'³¹ mɨ²jø'² vino. 'E³ quie'²³ 'a²³jia'³ ñi³² 'ñée² 'e³ jiaa'³¹ xa³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'ɨ̱'²³, juø'n³ quie'²³ ñi³² te'²³ mozos 'i³ ca²³lí². 'E³ jo̱³ ca²³tøø³ dsa³ 'i³ ca²³jén²³ mɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ca²³jua'³: ―La²³jɨn³ dsa³ 'i³ jmee²³ mɨ²juee'³ xe̱'n² cɨ² cuø²³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ dxʉ́²³ cɨ². Ma²mɨ³'áa³ 'i'²³ 'e³ mɨ³la³ñúun³ 'ɨ̱ɨ̱'³²te'²³, jo̱³ tu³ cuø²³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ 'a²³jia'³ jo̱o̱²³ dxʉ́²³. 'E³ quie'²³ mɨ³cuaa'n²³²nu³ jmɨɨ'³¹ mɨ²jø'² vino 'e³ dxʉ́²³ cɨ². 'E³ cɨ² cuøn³ rɨ³nɨ²³. ―La'³ ca²³jua'³ dsa³ 'i³ jmee²³ ta² mɨ²juee'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","La'³ cu³lø³¹ ca²³jmée³ Jesús juɨɨ³ Caná estado Galilea. Mɨ²jo̱³ ca²³la²³láa²³ 'e³ jmee²³ u²³juø'²³ 'e³ jmee²³ lii²³ 'e³ bi²³ gáan³ 'ñée². 'E³ jo̱³ ca²³táan³ quia̱'² Jesús te'²³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Cɨ̱ɨ̱n³ cɨ² ŋóo² Jesús juɨɨ³ Capernaum quia̱'² xóo² quia̱'² jó̱o̱² quia̱'² te'²³ dsa³ quien³². Núu²³ ca²³gua³ 'nɨ³, quiʉ̱́³ jmɨ́ɨ². ");
INSERT INTO cnlNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","'A²³jia'³ ma²³ huǿø³ 'e³ rɨ²³tɨ́²³ mɨ²juee'³ pascua. 'E³ jo̱³ ñíin² Jesús juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","'Í² ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios te'²³ dsa³ Israel. Ŋó²³ 'e³ nee'n²³² dsa³ 'i³ 'nɨɨn²³ cua² 'ioo'³ dsóo²³ quia̱'² dsɨɨ³ joo³ quia̱'² to̱³ju̱³¹. Nee'n²³² dsa³ 'i³ guø'n³² cuu² quiee'³² jia'³ cɨ'²³ dxi² juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","'E³ jo̱³ ca²³bén² 'ñii²³². Ca²³'uøøn³ xi²dxi³² la²³jɨn³ dsa³ 'i³ jmoo³² la'³ ca³ti³² quia̱'² dsɨɨ³ joo³ quia̱'² cua² 'ioo'³ dsóo²³ quien³²te'²³. Co̱'³ cɨ'²³ tó̱o̱²³ cu²laa'³ quiee'³² dsa³ 'i³ guø'n³² cuu². Ca²³cɨ'² mesas quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jo̱³ tu³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'i³ 'nɨɨn²³ to̱³ju̱³¹: ―¡Je̱'n²³²na'³ la²³jɨ³ 'e³ nee'²³² je² la³! ¡'A²³ ma²³ rɨ³dxa³ra'³ 'moo'² ñʉ'²³ 'ñʉ́² je² mi³gáan³te'²³ Ñu'n²³! ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","'E³ jo̱³ ca²³la²³líi²³ dsa³ quien³² 'e³ xa³ je² to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: “'A²³jia'³ rɨ²³táan²³ la²³'nɨɨ'n³¹ 'e³ mi³quí̱i̱n²³na²³ 'ñʉ́² je² mi³gáan³te'²³ 'nʉ³”. La'³ cu³lø³¹ jua'³ júu² 'e³ ca²³la²³líi²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","'E³ quie'²³ jo̱³ ca²³jua'³ te'²³ juii² dsa³ Israel. Ca²³sɨ'²³te'²³ Jesús: ―¿'Ee² u²³juø'²³ rɨ²jméen² 'e³ rɨ²³jmée²³ lii²³ 'e³ xa³ ca³dsaan³² 'e³ jmeen³ 'e³ la²³ jmeen³? ");
INSERT INTO cnlNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","'E³ jo̱³ ca²³lʉ́³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Juø'n³ quie'²³ rɨ²yaan²³²na'³ 'ñʉ́² gáan³ la³, je² 'nɨ³ jmɨ́ɨ² rɨ²sɨ'n³¹ co̱'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","'E³ quie'²³ jo̱³ ca²³jua'³ te'²³ juii² dsa³ Israel: ―Ca²³tɨ́³ tú̱²³ lóo² dsɨ³² jñʉ́ʉ³ ji̱i̱³ ñi³ 'e³ ca²³jmóo²te'²³ 'ñʉ́² gáan³ la³. ¿'A² juø'² lǿn³nu³ 'e³ rɨ²³líi² 'nɨɨ'n³¹ 'nɨ³ jmɨ́ɨ² 'e³ rɨ²sɨ'n² co̱'³ 'uǿøn²nu³? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","'E³ quie'²³ jmɨ² ŋu² 'ñée² hua² 'e²³ ma²ca¹jua'³ 'ñʉ́² gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ma²mɨ³'áa³ 'i'²³ 'e³ ca²³ji̱i̱'²³ co̱'³ Jesús, ca²³la²³líi²³ te'²³ dsa³ quien³² 'e³ jmii'³¹ cu³lø³¹ júu² 'e³ ca²³lʉ́³. 'E³ jo̱³ ca²³táan³te'²³ 'e³ la²³ lǿ² júu² quiee'³² Dios 'e³ to̱o̱²³ ji³ je² 'en³² Jesús. Ca²³táan³te'²³ 'e³ la²³ lǿ² júu² 'e³ ca²³lʉ́³ 'ñée² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","'E³ la²³ ñíin² Jesús juɨɨ³ Jerusalén ma²ca¹tɨ́³ mɨ²juee'³ pascua, juɨ́ɨn²³ dsa³ 'i³ ca²³táan³ quia̱'². Ca²³táan³te'²³ ma²ŋó¹te'²³ u²³juø'²³ 'e³ ca²³jmée³ lii²³ 'e³ bi²³ gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","'E³ quie'²³ 'a²³jia'³ ca²³jmée³ quie'² Jesús 'e³ jua'³ sɨ³táan³ dsa³. Qui² cuiin²³ la²³jɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","'A²³jia'³ 'ne'² 'e³ li²³xen³ dsa³ 'i³ rɨ²³jmée²³ júu² 'e³ jmii'³¹ lǿn²³ dsa³ mɨ³¹güii³. Ñi³² 'ñée² 'e³ jmii'³¹ lǿ² dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Xen³ jø̱n³ dsa³ fariseo 'i³ xi̱i̱n³ Nicodemo. Rɨ³løn³¹ dsa³ 'i³ dxi³ 'i'²³ jee²³² quiee'³² dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ca²³tɨ́³ 'e³ ñíin² i²joon³ Jesús. 'Uøø²³ hua² i²ñíin². Ca²³jua'³ Nicodemo. Ca²³sɨ'²³ Jesús: ―Dsa³ 'e²³, ne³ra'³¹ 'e³ mɨ³xíin²³ 'nʉ³ Dios 'e³ rɨ²'een³¹ dsa³. Qui² 'a²³'i̱³ xen³ 'i³ rɨ²³lí³ juø'² rɨ²³jmée²³ u²³juø'²³ 'e³ la²³ jmeen³ 'uǿøn²nu³ xi³nu³ 'a²³jia'³ jmee²³ ta² quia̱'² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","'E³ quie'²³ jo̱³ ca²³lʉ́³ Jesús. Ca²³sɨ'²³ Nicodemo: ―Rɨ²juøøn³¹na¹ 'nʉ³ ju²dsoo³¹: 'A²³jia'³ rɨ²³lí³ juø'² rɨ²³'íin³ je² røøn³ Dios dsa³ 'i³ 'a²³jia'³ ca³la³xen³ co̱'³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","'E³ jo̱³ ca²³jua'³ Nicodemo: ―¿Jmii'³¹ rɨ²³lí³ juø'² li²³xen³ co̱'³ dsa³ 'i³ mɨ³la³jaan²³²? ¿'A² juø'² rɨ²³lí³ juø'² li²³huǿøn³ co̱'³ quie'² xóo² 'e³ jua'³ li²³xen³ co̱'³? ");
INSERT INTO cnlNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","'E³ quie'²³ ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nʉ³ ju²dsoo³¹: 'É̱e̱² 'e³ mɨ³la³xen³ co̱'³ dsa³ 'i³ mɨ³jŋáan³ jmɨɨ³ 'e³ jua'³ sɨ³táan³. 'É̱e̱² 'e³ mɨ³la³xen³ co̱'³ dsa³ 'i³ mɨ³'iin³² dsɨ́² Espíritu Gáan³. 'E³ quie'²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³'íin³ je² røøn³ Dios dsa³ 'i³ 'a²³jia'³ sɨ³táan³, dsa³ 'i³ 'a²³jia'³ ca²³'iin³² dsɨ́² Espíritu Gáan³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jmɨ² ŋu² xóo² jmii³ jmee²³ 'e³ rɨ³ji̱'²³ jmɨ² ŋu² dsa³ 'e³ la²³ sɨ³li³xen³. 'E³ quie'²³ Espíritu Gáan³ jmee²³ 'e³ rɨ³ji̱'²³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","'A²³jia'³ 'ne'² 'e³ juø'²³ rɨ²núun² 'e³ la²³ lǿ² mɨ³juǿøn²na²³ 'nʉ³ 'e³ 'ne'² li²³xen³na'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Qui² ro̱o̱²³ dxí³ te³ jiaa'³¹ 'née²³. Nuun³ 'e³ la²³ 'i̱i̱². 'E³ quie'²³ 'a²³jia'³ máan³ 'e³ jiaa'³¹ ja³. 'A²³jia'³ máan³ 'e³ jiaa'³¹ dsoo³². 'E³ quie'²³ la'³ cu³lø³¹ quie'² dsa³ 'i³ mɨ³jmée³ Espíritu Gáan³ 'e³ rɨ³ji̱'²³. Lii²³ 'e³ rɨ³ji̱'²³ dsa³ 'í³, juø'n³ quie'²³ 'a²³jia'³ ñi³² dsa³ 'e³ jmii'³¹ lǿ² 'e³ mɨ³lǿ²³ la'³. ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Nicodemo. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","'E³ jo̱³ ca²³jua'³ Nicodemo. Ca²³sɨ'²³ Jesús: ―¿Jmii'³¹ lǿ² 'e³ sɨ³lí³ la'³ cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","'E³ quie'²³ jo̱³ ca²³jmée³ júu² co̱'³ Jesús. Ca²³sɨ'²³ Nicodemo: ―Rɨ³løn³¹nu³ dsa³ 'e²³. 'Een³² dsa³ Israel, ¿mɨ³naa'³¹? ¿Jmii'³¹ lǿ² 'e³ 'a²³jia'³ ta³jmeen³ 'i'²³ 'e³ la²³ lǿ² júu² 'e³ mɨ³juǿøn²na²³ 'nʉ³? ");
INSERT INTO cnlNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Rɨ²juøøn³¹na¹ 'nʉ³ ju²dsoo³¹: Lʉ²ra'³¹ 'e³ la²³ ne³ra'³¹. Qui² rɨ³løn³¹na'³¹ dsa³ ñi³. Xii'³²ra'³¹ dsa³ 'e³ la²³ ca²³ne²ra'³¹. 'E³ quie'²³ 'a²³jia'³ jmee³ra'³ quién²na'³ júu² 'e³ xii'³²ra'³¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Qui² mɨ³'øn²³ 'e³ la²³ lǿ² 'e³ jmee²³ mɨ³¹güii³ la³ 'e³ la²³ mɨ³lʉ́n²³ quia̱'n²³²na¹ 'nʉ³. 'E³ quie'²³ 'a²³jia'³ ca³táan³nu³. ¿Jmii'³¹ rɨ²³lí³ juø'² rɨ²³sɨ²³táan³nu³ xi³nu³ rɨ²'øn²³² 'e³ la²³ lǿ² yʉʉ'³¹ güii³ jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’'A²³'i̱³ xen³ dsa³ 'i³ lɨ'³ ca³ñíin² yʉʉ'³¹ güii³ 'i³ rɨ²³lí³ juø'² rɨ²³jmée²³ júu². 'Nɨɨ'n³¹ jø̱n³ jné² Jo̱o̱³¹ Dsa³ hua² 'i³ jŋáan²na²³ jí̱i̱n² yʉʉ'³¹ güii³ 'i³ sɨ³lí³ juø'² jmeen²³ júu². Qui² yʉʉ'³¹ güii³ jen³¹na¹ xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moisés ca²³xo'² ne'n² 'e³ rɨ³løn³¹ 'luu³ ma²ca¹guó³ te'²³ dsa³ Israel je² 'a²³jia'³ nee'n²³² dsa³ mɨ²jo̱³. 'E³ la²³ ca²³xo'² Moisés ne'n² jo̱³, 'e³ quie'²³ la'³ 'ne'² rɨ²³xa'n²te'²³ jné² Jo̱o̱³¹ Dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Jo̱³ hua² rɨ²³lí³ juø'² rɨ³ji̱'²³ ca³cuaa³ dsa³ 'i³ sɨ³táan³ quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Bi²³ 'néen² dsa³ mɨ³¹güii³ Dios. 'E³ jo̱³ ca²³cuǿn² Jo̱o̱³¹, juø'n³ quie'²³ jø̱n³ qui³ xen³. 'E³ jo̱³ 'a²³jia'³ rɨ²³gua'²³ la²³jɨn³ dsa³ 'i³ sɨ³táan³ quia̱'² Jo̱o̱³¹. 'E³ quie'²³ rɨ³ji̱'²³ ca³cuaa³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","'E³ quie'²³ 'a²³la³ jo̱³ 'e³ 'née²³ Dios 'e³ rɨ²³dxá²³ ta² quiee'³² dsa³ mɨ³¹güii³ 'e³ ca²³xíin²³ Jo̱o̱³¹ mɨ³¹güii³ la³. Ca²³xíin²³ Jo̱o̱³¹ 'e³ jua'³ 'née²³ 'e³ rɨ²³láan³ dsa³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’'A²³jia'³ ca²³'ien³ júu² 'e³ xa³ dsoo² quiee'³² dsa³ 'i³ sɨ³táan³ quia̱'² Jo̱o̱³¹. 'E³ quie'²³ mɨ³líi² mɨ³'ien³ júu² 'e³ xa³ dsoo² quiee'³² dsa³ 'i³ 'a²³jia'³ sɨ³táan³. Qui² 'a²³jia'³ ca²³táan³te'²³ quia̱'²te'²³ Jo̱o̱³¹ Dios 'i³ jø̱n³ qui³ xen³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mɨ³'ioo²³ jmɨ́ɨ²³ quiee'³² ji³ mɨ³¹güii³ la³. 'E³ quie'²³ bi²³ cɨ² 'née²³ dsa³ je² li³'o̱o̱³ la²³ cɨ'²³ je² cuø²³ jmɨ́ɨ²³ ji³. Qui² 'a²³jia'³ dxʉ́²³ 'e³ la²³ jmoo³². 'E³ jo̱³ hua² 'e³ mɨ³'ien³ júu² 'e³ xa³ dsoo² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","'A²³jia'³ ta³dsɨ³² je² cuø²³ jmɨ́ɨ²³ ji³ la²³jɨn³ dsa³ 'i³ 'a²³jia'³ dxʉ́²³ jmoo³². 'E³ quie'²³ la'³ 'a²³jia'³ 'née²³ rɨ²³ŋɨ́n³ je² cuø²³ jmɨ́ɨ²³. Qui² bi²³ juø'² rɨ²³li²³jné³ ta² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","'E³ quie'²³ 'née²³ rɨ²³ŋɨ́²³ je² cuø²³ jmɨ́ɨ²³ ji³ dsa³ 'i³ jmee²³ 'e³ la²³ lǿ² ju²dsoo³¹. Qui² 'née²³ 'e³ li²³lii²³ 'e³ jmee²³ ta² Dios quia̱'² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma²mɨ³líi² la'³, ŋóo² Jesús quia̱'² dsa³ quien³² la²³ca̱a̱n³ je² røøn³ estado Judea. Núu²³ ca²³guó³ quia̱'² dsa³ quien³². Ca²³xáan² dsa³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","'E³ quie'²³ la'³ Juan co̱'³. 'Iún² xaan³² dsa³ jmɨɨ³ je² xi̱i̱n³ Enón, mɨ³lén² la²³ je² xi̱i̱n³ Salim. Qui² bi²³ xa³ jmɨɨ³ je² núu²³. Xen³ dsa³ 'i³ i²guín¹ 'e³ ca²³jŋáan³te'²³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Qui² 'íi² rɨ²³ta̱a̱'n³te'²³ i²³ñí² Juan mɨ²jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","'E³ quie'²³ ca²³sɨ́n²³ júu² ca³dxáan² dsa³ quien³² Juan quia̱'² te'²³ juii² dsa³ Israel. Ca²³sɨ́n²³te'²³ júu² 'e³ jmii'³¹ lǿ² 'e³ 'ne'² rɨ²³jiin³ rɨ²³u̱u̱'n³ miin²³ quia̱'² la²³jɨ³ 'e³ coo'³²te'²³ 'e³ lǿn³ miin²³ 'e³ mɨ³la³'lʉ'n². ");
INSERT INTO cnlNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","'E³ jo̱³ i²guín¹te'²³ caan²³ Juan. Ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Juan: ―Dsa³ 'e²³, xaan³² dsa³ jmɨɨ³ dsa³ 'i³ quia̱'n²nu³ mɨ²jo̱³, ¿mɨ³naa'³¹?, dsa³ 'i³ quia̱'n²nu³ ma²jen³¹nu³ 'ŋóo² la²³ jmɨɨ³ juee'³ Jordán, dsa³ 'i³ ca²³jméen² júu² 'e³ 'i̱i̱² sɨɨ'³¹. Sɨ³guín²³ la²³jɨn³ dsa³ caan²³ 'ñée², ¿mɨ³naa'³¹? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","'E³ quie'²³ ca²³jmée³ júu² Juan. Ca²³jua'³: ―Jmø'n² 'e³ cuø²³ Dios 'e³ sɨ³lí³ quiée²ra², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","'E³ quie'²³ ca²³nʉʉ³ra'³ miin²³na'³ 'e³ la²³ ca²³juø'n² mɨ²jo̱³. Qui² ca²³juø'n²: “'A²³la³ 'í³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios jné²”. 'E³ quie'²³ mɨ³xíin²³ jné² Dios 'e³ rɨ²ŋɨ́n³na²³ jén²³ cɨ² la²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","La²³ xen³ dsa³ 'i³ tøø²³ mɨ́³ xen³ Cristo. Qui² tøø³ dsa³ quien³². La²³ xen³ dsa³ 'i³ dxin²³² júu² xen²³ jné². Bi²³ 'née²³ dsa³ 'i³ dxin²³² júu² 'e³ la²³ nuu³ 'e³ lʉ²³ dsa³ 'i³ tøø²³ mɨ́³. 'E³ jo̱³ hua² 'e³ bi²³ jɨn³ dsɨn²³ jné² 'e³ sɨ³li³xen³ dsa³ quien³² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Qui² 'ne'² 'e³ rɨ²³li²³gáan³ cɨ² 'ñée². 'E³ quie'²³ 'ne'² 'e³ rɨ²³li²³'uǿn²³ cɨ² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Gáan³ cɨ² 'ñée² 'i³ ja³ jí̱i̱n² yʉʉ'³¹ la²³ cɨ'²³ la²³jɨn³ dsa³. 'Nɨɨ'n³¹ mɨ³¹güii³ la³ hua² joo³² te'²³ dsa³ 'i³ xen³ mɨ³¹güii³ la³. Qui² la²³'nɨɨ'n³¹ 'e³ la²³ lǿ² mɨ³¹güii³ la³ hua² lʉ²³te'²³. 'E³ quie'²³ gáan³ cɨ² 'ñée² 'i³ ja³ jí̱i̱n² yʉʉ'³¹ güii³ la²³ cɨ'²³ la²³jɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jmee²³ júu² 'ñée² 'e³ jmii'³¹ cu³lø³¹ 'e³ ŋó²³, 'e³ jmii'³¹ cu³lø³¹ 'e³ ca²³núu³. 'E³ quie'²³ 'a²³'i̱³ xen³ 'i³ co̱³² júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","'E³ quie'²³ jmee²³ lii²³ 'e³ sɨ³táan³ 'e³ rɨ³løn³¹ ju²dsoo³¹ Dios dsa³ 'i³ co̱³² júu² quiee'³² 'ñée² 'i³ ja³ jí̱i̱n² yʉʉ'³¹ güii³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Qui² 'ɨɨ³ júu² quiee'³² Dios 'ñée² 'i³ mɨ³xíi²³ Dios quie'². Qui² 'a²³la³ ca³pii'² cuøn³² Dios Espíritu Gáan³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bi²³ 'néen² Jo̱o̱³¹ Dios Jmii³. 'E³ jo̱³ mɨ³dxa³ guoo³ Jo̱o̱³¹ la²³jɨ³ 'e³ xa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Rɨ³ji̱'²³ ca³cuaa³ dsa³ 'i³ sɨ³táan³ quia̱'² Dios Jo̱o̱³¹. 'E³ quie'²³ 'a²³jia'³ rɨ²³ñí² 'e³ jmii'³¹ lǿ² 'e³ rɨ³ji̱'²³ dsa³ ca³cuaa³ dsa³ 'i³ 'a²³jia'³ rɨ²³núu²³ 'e³ jmii'³¹ jua'³ Dios Jo̱o̱³¹. 'E³ quie'²³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jmée²³ Dios jñiin²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ca²³núu³ dsa³ fariseo 'e³ juɨ́ɨn²³ cɨ² dsa³ 'i³ sɨ³lín³ dsa³ quien³² Jesús la²³ cɨ'²³ dsa³ quien³² Juan. Ca²³núu³te'²³ 'e³ juɨ́ɨn²³ cɨ² dsa³ 'i³ ca²³xáan² jmɨɨ³ Jesús la²³ cɨ'²³ dsa³ 'i³ ca²³xáan² jmɨɨ³ Juan. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","'E³ quie'²³ 'a²³la³ 'í³ Jesús ca³quie̱e̱² 'i³ ca²³xáan² dsa³ jmɨɨ³. Dsa³ quien³² hua² 'i³ ca²³xáan² dsa³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ma²ca¹dsóo¹ dsɨ́² Juii³ra² 'e³ la'³ cu³lø³¹ júu² 'e³ ca²³núu³ dsa³ fariseo, ca²³bǿn³ estado Judea. Ŋø'n² co̱'³ estado Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","'E³ quie'²³ ca²³la²³'ne'² 'e³ rɨ²³ŋɨ́n³ estado Samaria. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ca²³dxóo² co̱o̱³ juɨɨ³ je² røøn³ estado Samaria je² xi̱i̱n³ Sicar, mɨ³lén² la²³ 'uǿ²³ je² røøn³ Jacob mɨ²jaa²³², 'uǿ²³ 'e³ ca²³cuǿø²³ jo̱o̱³¹ 'i³ xi̱i̱n³ Søø³². ");
INSERT INTO cnlNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Núu²³ xa³ too³ je² sø'n³²te'²³ jmɨɨ³ 'e³ ca²³yʉ́ʉ² Jacob mɨ²jaa²³². Bi²³ ca²³'uaa'n²³ Jesús 'e³ la²³ 'iún² jui³¹. 'E³ jo̱³ ca²³guó³ coo³¹ je² cu³'oo'²³ too³ jmɨɨ³. Mɨ³tɨ́³ la²³ca̱a̱n³ dxaan²³ ñi'² 'nɨɨ'n³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","'E³ quie'²³ jo̱³ ca²³dxóo² jø̱n³ mɨ́³ Samaria 'e³ jua'³ 'née²³ rɨ²³có̱² jmɨɨ³. Ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³ 'í³: ―Rɨ²jméen² co̱o̱³ mɨ²'áa² 'e³ rɨ²cuǿn² ca³juɨ² jmɨɨ³ 'e³ rɨ²uu'n²³² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Qui² mɨ³ca³guín²³ dsa³ quien³² jee²³² juɨɨ³ 'e³ jua'³ sɨ³quie̱³te'²³ 'e³ rɨ²³e'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","'E³ jo̱³ ca²³jua'³ mɨ́³ Samaria. Ca²³sɨ'²³ Jesús: ―¿'Ee² lǿ² mɨ³xi'n²nu³ jné² 'e³ rɨ²cuǿøn¹na²³ 'nʉ³ jmɨɨ³ 'e³ rɨ²'u'n²? Qui² dsa³ Israel hua² 'nʉ³. 'E³ quie'²³ dsa³ Samaria hua² jné². La'³ ca²³jua'³ mɨ́³ Samaria. Qui² 'a²³jia'³ dxʉ́²³ lʉ²³ dsa³ Israel quia̱'² dsa³ Samaria. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³ 'í³: ―'A²³jia'³ máan³ 'e³ jmii'³¹ 'nɨɨ'n³¹ dxʉ́²³ 'e³ 'née²³ rɨ²³jmée²³ Dios quién²nu³. 'E³ quie'²³ 'a²³jia'³ máan³ 'e³ 'i̱i̱² sɨɨ'³¹ jné² 'i³ mɨ³juǿøn²na²³ 'nʉ³: “Rɨ²cuǿn² ca³juɨ² jmɨɨ³ 'e³ rɨ²uu'n²³²”. 'U² cu²ru'³ máan³ 'e³ 'i̱i̱² sɨɨ'³¹ jné², jné² hua² mɨ³ŋɨ'n²nu³ jmɨɨ³ cu²ru'³ la'³. Mɨ³cuǿøn²³na²³ 'nʉ³ jmɨɨ³ 'e³ jmee²³ 'e³ rɨ³ji̱'²³ dsa³ cu²ru'³ la'³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","'E³ quie'²³ ca²³jua'³ mɨ́³: ―'A²³'e³ xa³ quié̱n² 'e³ rɨ²juø'n²³nu³ jmɨɨ³ xú̱n³. Co̱'³ cɨ'²³ bi²³ jɨ̱ɨ̱n²³² too³, ¿mɨ³naa'³¹? ¿Jiaa'³¹ cu³quie̱n³ jmɨɨ³ 'e³ jmee²³ 'e³ rɨ³ji̱'²³ dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿'A² bi²³ cɨ² gáan³nu³ la²³ cɨ'²³ yi²³uu'²ra² jaa²³² 'i³ xi̱i̱n³ Jacob, 'i³ ca²³jmée³ quiée²ra² too³ la³? 'E³ quie'²³ la³ hua² 'ɨ̱'²³ jmɨɨ³ 'ñée² quia̱'² jo̱o̱³¹ quia̱'² roo'³² quien³². ―La'³ ca²³jua'³ mɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³: ―'E³ cɨ² li²³dxíin³ dsɨ́² co̱'³ la²³jɨn³ dsa³ 'i³ 'ɨ̱ɨ̱'³² jmɨɨ³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","'E³ quie'²³ 'a²³jia'³ ma²³ li²³dxíin³ dsɨ́² co̱'³ dsa³ 'i³ 'ɨ̱ɨ̱'³² jmɨɨ³ 'e³ rɨ²cuøn²³² jné². Qui² rɨ²³'iá³ 'ñée² jmɨɨ³ ñʉ'²³ dsɨ́² dsa³ 'i³ rɨ²cuǿøn¹ jmɨɨ³ jo̱³. 'E³ jo̱³ rɨ³ji̱'²³ ca³cuaa³ dsa³ 'í³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","'E³ jo̱³ ca²³jua'³ mɨ́³. Ca²³sɨ'²³ Jesús: ―Cuøø² jné² jmɨɨ³ 'e³ mɨ³'én² nɨ³ jo̱o̱²³na²³. Qui² jo̱³ hua² 'a²³jia'³ ma²³ li²³dxíin³ dsɨn²³ co̱'³. 'A²³jia'³ ma²³ li²³'ne'² 'e³ rɨ²³güén³na²³ je² la³ rɨ²³gui²³quie̱n²³ jmɨɨ³. ―La'³ ca²³jua'³ mɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³: ―Cu³jén²³ dsóo²³ quien³²nu³. Ñeen³² co̱'³ quia̱'n²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","'E³ quie'²³ ca²³jua'³ mɨ́³. Ca²³sɨ'²³ Jesús: ―'A²³'i̱³ xen³ dsóo²³ quién²³na²³ xú̱n³. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³: ―'E̱'n³ quie'²³ dsɨ́² 'e³ la²³ mɨ³jue'n². 'A²³'i̱³ xen³ dsóo²³ quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Qui² mɨ³tɨ́³ 'ñén³ dsóo²³ 'i³ mɨ³la³quia̱'n²nu³. 'E³ quie'²³ 'a²³la³ ma²³ 'í³ dsóo²³ quien³²nu³ ca³quie̱e̱² 'i³ quia̱'n²nu³ rɨ³nɨ²³. Mɨ³lʉ́n² ju²dsoo³¹. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","'E³ jo̱³ ca²³jua'³ mɨ́³. Ca²³sɨ'²³ Jesús: ―Mɨ³la³quiin²³ 'e³ dsoo²³ 'áan² la²³ dsoo²³ dsɨ́² te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yʉʉ'³¹ mo'³ la³ ca²³mi²³gáan³ Dios yi²³uu'²ra'³¹ jaa²³². 'E³ quie'²³ 'nee'²³ juo'³ra'³ 'e³ juɨɨ³ Jerusalén 'ne'² rɨ²³mi²³gáan³ dsa³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³: ―'Ne'² rɨ²³sɨ²³táan³nu³ júu² 'e³ rɨ²juøøn³¹na¹ 'nʉ³: Mɨ³lǿ²³ mɨ³lén² jmɨ́ɨ² 'e³ 'a²³la³ ma²³ yʉʉ'³¹ mo'³ la³, 'a²³la³ ma²³ juɨɨ³ Jerusalén je² rɨ²mi³gáan²na'³ Dios Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'A²³jia'³ móo³ra'³ 'e³ 'i̱i̱² sɨɨ'³¹ mi³gáan²na'³. 'E³ quie'²³ ne³ra'³¹ jnee'³¹ 'e³ 'i̱i̱² sɨɨ'³¹ mi³gáan²na'³¹. Qui² Dios ca²³cuǿø²³ jnee'³¹ dsa³ Israel júu² quiee'³² 'e³ jmee²³ 'e³ rɨ²³láan³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","'E³ quie'²³ mɨ³lǿ²³ mɨ³lén² jmɨ́ɨ², 'e³ quie'²³ mɨ³tɨ́³ rɨ³nɨ²³, 'e³ ñʉ'²³ dsɨ́² dsa³ 'ne'² rɨ²³mi²³gáan³ dsa³ Dios Ñu'n²³. Jø̱n³ Dios Ñu'n²³ hua² 'ne'² rɨ²³mi²³gáan³ dsa³ 'i³ 'née²³ rɨ²³mi²³gáan³ Dios ca³quie̱e̱². Qui² 'née²³ Dios Ñu'n²³ 'e³ li²³xen³ dsa³ 'i³ jmoo³² la'³ 'e³ rɨ²³mi²³gáan³te'²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Espíritu rɨ³løn³¹ Dios. 'E³ jo̱³ hua² 'e³ ñʉ'²³ dsɨ́² dsa³ 'ne'² rɨ²³mi²³gáan³ dsa³ Dios. Jø̱n³ 'ñée² Dios 'ne'² rɨ²³mi²³gáan³ dsa³ 'i³ 'née²³ rɨ²³mi²³gáan³ Dios ca³quie̱e̱². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","'E³ quie'²³ ca²³jua'³ mɨ́³. Ca²³sɨ'²³ Jesús: ―Maan²³ 'e³ cɨ² rɨ²³güén³ Mesías 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios, 'i³ sɨ'²³te'²³ Cristo. Mɨ³rɨ³güén³ 'ñée², jo̱³ rɨ²³'ée²³ jne² la²³jɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ mɨ́³: ―'I³ 'í³ jné² 'i³ lʉn²³ quia̱'n²³²na¹ 'nʉ³. Jné² hua² 'i³ 'ǿn²³nu³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","'E³ quie'²³ ca²³i²³guiin³² dsa³ quien³² Jesús. Bi²³ juø'²³ ca²³jóo²te'²³ 'e³ mi³róo³ Jesús quia̱'² jø̱n³ mɨ́³. 'E³ quie'²³ 'a²³'i̱³ xen³ 'i³ ca²³la²³bii²³ dsɨ́² ca²³sɨ'²³ Jesús: “¿'Ee² 'noo³¹ 'naan³?” 'E³ quie'²³ 'a²³'i̱³ xen³ 'i³ ca²³jua'³: “¿'Ee² lǿ² mi³ráan² quia̱'n²nu³ mɨ́³ nɨ³?” ");
INSERT INTO cnlNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","'E³ quie'²³ jo̱³ ca²³cuaa'n³ mɨ́³ mɨ²dsuu² quiee'³². Ŋø'n² co̱'³ jee²³² juɨɨ³. Ca²³jua'³ ca²³sɨ'²³ dsa³ juɨɨ³: ");
INSERT INTO cnlNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Mɨ²³gui²³²ra². Mɨ²³joon²³²na² jø̱n³ dsa³ 'i³ mɨ³sɨ'²³ jné² la²³jɨ³ 'e³ lɨ'³ ca³jméen²³. ¿'A² juø'² 'a²³la³ 'í³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios cu²ne²ra²? ―ca²³jua'³ mɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","'E³ quie'²³ jo̱³ ca²³'uǿøn²³ dsa³ juɨɨ³. Ca²³guín²³te'²³ i²joon³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","La²³huø'n²³ la²³ jiaan³ mɨ́³ jee²³² juɨɨ³, ca²³lʉ́³ dsa³ quien³² quia̱'² Jesús. Ca²³sɨ'²³te'²³: ―Dsa³ 'e²³, quie'² ca³juɨ² xú̱n³ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","'E³ quie'²³ ca²³jua'³ 'ñée²: ―Xa³ 'e³ ee'n²³ 'e³ 'a²³jia'³ móo³ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","'E³ jo̱³ ca²³lʉ́³ la²³ co̱³quie'² miin²³ dsa³ quien³². Ca²³jua'³te'²³: ―¿'A² juø'² xen³ 'i³ mɨ³gui³co̱³ 'e³ rɨ²³e'² cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―La²³ xen³ 'e³ sɨ³liin²³ dsɨn²³ mɨ³rɨ³ee'n²³ xen³ 'e³ jmeen²³ 'e³ la²³ 'née²³ 'ñée² 'i³ ca²³xíin²³ jné². La'³ xen³ 'e³ jmeen²³ ta² quiee'³² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","'Nee'²³ juo'³ra'³ 'e³ jmee²³ cɨ² quiú̱n³ sɨɨ'³ 'e³ rɨ²³jmóo² dsa³ 'ó̱o̱²³. 'E³ quie'²³ jné² rɨ²juøøn³¹na¹ 'nee'²³: Jóo²ra'³ dxʉ́²³. Qui² mɨ³roo³ cuɨɨ³. Mɨ³tɨ́³ 'e³ rɨ²³lí³ 'ó̱o̱²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","'E³ quie'²³ xa³ jñiin²³ dsa³ 'i³ jmee²³ 'ó̱o̱²³. Qui² la²³ xen³ mɨɨ³¹ 'e³ sɨ³li³xa³ mɨ³rɨ³jmoo³² dsa³ 'ó̱o̱²³ xen³ dsa³ 'i³ rɨ²³ji̱i̱'²³ ca³cuaa³ mɨ³rɨ³sɨ'²³te'²³ 'e³ 'ne'² rɨ²³sɨ²³táan³. Jo̱³ hua² li²³jɨn³ dsɨ́² ca³ti³² dsa³ 'i³ jmee²³ jmo² quia̱'² dsa³ 'i³ jmee²³ 'ó̱o̱²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Qui² ca³quie̱e̱² sɨ³lí³ 'e³ la²³ to̱'²³ lʉ²³ dsa³ 'e³ jua'³te'²³: “Jø̱n³ dsa³ 'i³ jmee²³ jmo². Jia'³ hua² 'i³ jmee²³ 'ó̱o̱²³.” ");
INSERT INTO cnlNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jné² sɨɨn³²na²³ 'nee'²³ 'e³ rɨ²jmée²ra'³ 'ó̱o̱²³ je² 'a²³la³ 'nee'²³ ca²³jmée²ra'³ jmo². Jia'³ cɨ'²³ dsa³ ca²³jmóo² ta². 'E³ quie'²³ 'nee'²³ cu³mi³quie̱e̱'²³²ra'³ la²³jɨ³ 'e³ mɨ³la³xa³ je² ca²³jmóo²te'²³ ta². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Juɨ́ɨn²³ dsa³ Samaria 'i³ nee'n²³² juɨɨ³ jo̱³ 'i³ ca²³táan³ quia̱'² Jesús. Qui² ca²³jua'³ mɨ́³. Ca²³'én² Jesús: “Mɨ³sɨ'²³ jné² la²³jɨ³ 'e³ lɨ'³ ca³jméen²³”. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","'E³ quie'²³ ma²ca¹dxi¹guín¹ dsa³ Samaria, ca²³sɨ'²³te'²³ Jesús 'e³ rɨ²³cuaa'n²³ cɨ² quia̱'²te'²³. 'E³ jo̱³ ca²³cuaa'n²³ Jesús tú̱²³ jmɨ́ɨ² juɨɨ³ quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bi²³ cɨ² juɨ́ɨn²³ dsa³ 'i³ ca²³táan³ quia̱'² Jesús ma²ca¹núu³te'²³ júu² quiee'³² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","'E³ jo̱³ ca²³sɨ'²³te'²³ mɨ́³: ―'A²³la³ ma²³ jo̱³ 'e³ mɨ³nʉʉ²ra'³¹ júu² quien³²nu³ 'e³ sɨ³táan³na'³¹. Qui² mɨ³nʉʉ²ra'³¹ miin²³na'³¹ júu² quiee'³² 'ñée². Ne³ra'³¹ 'e³ 'e̱'n³ quie'²³ dsɨ́² Cristo 'i³ rɨ²³láan² dsa³ mɨ³¹güii³ hua² 'í³. ―La'³ ca²³jua'³ dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ma²ca¹ŋɨ́n³ tú̱²³ jmɨ́ɨ² la'³, ca²³bǿn³ Jesús. Ŋø'n² estado Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","'E³ quie'²³ 'ñée² Jesús ca²³jua'³ 'e³ 'a²³jia'³ mi³juø'²³te'²³ dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios juɨɨ³ quiee'³² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","'E³ quie'²³ ma²ca¹dxe'n¹ co̱'³ estado Galilea, bi²³ ca²³mi²³juø'²³ dsa³ Galilea quia̱'² Jesús. Qui² ŋó²³te'²³ la²³jɨ³ 'e³ ca²³jmée³ juɨɨ³ Jerusalén ma²ca¹tɨ́³ mɨ²juee'³ pascua. Qui² i²guín¹ miin²³ mɨ²juee'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","'E³ quie'²³ jo̱³ ca²³dxóo² co̱'³ Jesús juɨɨ³ Caná estado Galilea, juɨɨ³ je² ca²³jmée³ 'e³ ca²³guø'n³ jmɨɨ³, 'e³ ca²³lǿ²³ jmɨɨ'³¹ mɨ²jø'² vino. 'E³ quie'²³ xen³ jø̱n³ dsa³ 'i³ rɨ³løn³¹ dxi² juɨɨ³ 'i³ dsoo'²³² jo̱o̱³¹ juɨɨ³ Capernaum. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ca²³núu³ dsa³ 'í³ 'e³ mɨ³güee'n³² co̱'³ Jesús estado Galilea naan³ estado Judea. 'E³ jo̱³ i²joon³ Jesús. Ca²³sɨ'²³ 'e³ rɨ²³jmée²³ co̱o̱³ mɨ²'áa² 'e³ rɨ²³dsóo² sɨ³mi³'láan³ jo̱o̱³¹. Qui² mɨ³ rɨ²³jú̱n³, jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'A²³jia'³ rɨ²³sɨ²³táan³na'³ xi³nu³ 'a²³jia'³ li²³xa³ 'e³ jmee²³ lii²³ 'e³ bi²³ gáan³na²³, xi³nu³ 'a²³'e³ xa³ u²³juø'²³ 'e³ rɨ²joo³¹ra'³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","'E³ quie'²³ ca²³jua'³ dsa³ 'i³ rɨ³løn³¹ dxi² juɨɨ³: ―Dsoo³²ra² xú̱n³. Qui² bi²³ juø'² rɨ²³jú̱n³ ja̱a̱n²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","'E³ quie'²³ ca²³jua'³ Jesús: ―Guø'n³ 'nʉ³. Qui² 'a²³jia'³ rɨ²³jú̱n³ ja̱a̱n³. Ca²³táan³ dsa³ 'i³ rɨ³løn³¹ dxi² juɨɨ³ júu² 'e³ ca²³lʉ́³ Jesús. 'E³ jo̱³ ŋø'n² quie'². ");
INSERT INTO cnlNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","'E³ la²³ 'iún² quie'²³ jui³¹ 'e³ dsø'n³², ca²³jí̱i̱n³ mozos quien³². Ca²³sɨ'²³te'²³ 'e³ rɨ³ji̱'²³ quie'²³ jo̱o̱³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","'E³ quie'²³ jo̱³ ca²³ŋɨ́ɨ³ júu² 'ñée² 'e³ 'ee² hora 'e³ láa²³ ca²³'ɨ́ɨ³ ca³juɨ² dsóo² quiee'³² xii'³. 'E³ jo̱³ ca²³jua'³ mozos: ―Dxóo³ la²³ca̱a̱n³ hora 'e³ co̱o̱³ 'e³ mɨ³cu³'lóo³ ca²³dsǿn²³ dsóo² dxíi³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ñi³² jmii³ xii'³ 'e³ hora jo̱³ 'e³ ca²³jua'³ Jesús: “'A²³jia'³ rɨ²³jú̱n³ ja̱a̱n³”. 'E³ jo̱³ ca²³táan³ 'ñée² ca³ti³² quia̱'² la²³jɨn³ 'i³ nee'n²³² xi²ñʉ'¹ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","La'³ cu³lø³¹ ca²³jmée³ Jesús je² ca²³tɨ́³ tú̱²³ taa'² 'e³ jmee²³ u²³juø'²³ 'e³ jmee²³ lii²³ 'e³ bi²³ gáan³. La'³ ca²³jmée³ ma²güe'n³¹ co̱'³ estado Galilea naan³ estado Judea. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ma²mɨ³líi² la'³ jo̱o̱²³na²³, ca²³tɨ́³ mɨ²juee'³ quiee'³² dsa³ Israel. 'E³ jo̱³ i²ñíin² co̱'³ Jesús juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","'E³ quie'²³ juɨɨ³ Jerusalén xa³ co̱o̱³ too³ bee'² je² 'o² jmɨɨ³ je² lo'²³ dsa³. Mɨ³lén² la²³ 'oo'² 'ioo'³ 'e³ rɨ³jnɨ³ la²³cu'² 'ioo³¹ juɨɨ³ je² xi̱i̱n³ 'oo'² quiee'³² dsɨɨ³ joo³. Betesda xi̱i̱n³ too³ je² 'o² jmɨɨ³ júu² hebreo. Xa³ 'ñé³ 'oo'² i²ro̱o̱³² coo³¹ too³ jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bi²³ ma²³'nee³ juɨ́ɨn²³ dsa³ 'i³ dsoo'²³² 'i³ rɨ³saan³ 'oo'² i²ro̱o̱³². Xen³ dsa³ tuu² mɨ²ñi². Xen³ dsa³ 'i³ 'uaa'³ tɨɨ². Xen³ dsa³ 'i³ tu̱u̱n²³². Je̱²³te'²³ 'e³ rɨ²³bɨ́² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Qui² xa³ ma² guøn³ ángel too³ je² lo'²³te'²³. 'E³ bi³² jmɨɨ³. 'E³ jo̱³ sɨ³'láan³ cɨ'³ jø̱n³ dsa³ 'i³ sɨ³'í³ 'e̱'³ jmɨɨ³ xe̱'n² mɨ³rɨ³bɨ³² jmɨɨ³. Sɨ³je̱'n²³ dsóo² quiee'³² dsa³, juø'n³ quie'²³ 'ee² dsóo². ");
INSERT INTO cnlNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Coo³¹ too³ jo̱³ rɨ³caa'n³² dsa³ 'i³ mɨ³tɨ́³ gui²³guiá³ dsɨ³² jñé²³ ji̱i̱³ ñi³ 'e³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ŋǿn² dsa³ 'í³ Jesús. Ñi³² 'e³ mɨ³xa³ jmɨ́ɨ² rɨ³caa'n³² coo³¹ too³ jo̱³. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―¿'A² 'naan³ 'e³ rɨ²³'láan³nu³? ");
INSERT INTO cnlNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","'E³ quie'²³ ca²³jua'³ dsa³ 'i³ dsoo'²³²: ―'A²³'i̱³ xen³ 'i³ rɨ²³ta̱a̱'n³ jné² 'e̱'³ jmɨɨ³ xe̱'n² mɨ³rɨ³bɨ³² jmɨɨ³. 'E³ la²³ 'iun²³²quien¹na²³ jui³¹, xen³ 'i³ sɨ³'í³ 'e̱'³ jmɨɨ³ jén²³ cɨ² la²³ jné². ―La'³ ca²³jua'³ dsa³ 'i³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Naa'n²³ 'nʉ³. Ben²³² jmoo³ quien³²nu³. Ŋɨ² 'nʉ³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Xe̱'n² quie'²³ jo̱³ ca²³'láan³ dsa³ 'í³. Ca²³bén² jmoo³ quiee'³². Ca²³ŋɨ́³. 'E³ quie'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ ca²³jmée³ la'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","'E³ jo̱³ ca²³lʉ́³ te'²³ juii² dsa³ Israel. Ca²³sɨ'²³te'²³ dsa³ 'i³ ca²³'láan³: ―Jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ 'e³ rɨ³nɨ²³, ¿mɨ³naa'³¹? 'A²³jia'³ joo'²³ 'e³ quié̱n² jmoo³ quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","'E³ quie'²³ ca²³jua'³ dsa³ 'i³ ca²³'láan³. Ca²³sɨ'²³ te'²³ juii² dsa³ Israel: ―Mɨ³sɨ'²³ jné² dsa³ 'i³ mɨ³mi³'láan³ jné²: “Ben²³² jmoo³ quien³²nu³. Ŋɨ² 'nʉ³”, mɨ³sɨ'²³ jné², ¿mɨ³naa'³¹? ―La'³ ca²³jua'³ dsa³ 'i³ ca²³'láan³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","'E³ quie'²³ jo̱³ ca²³sɨ'²³te'²³ dsa³ 'i³ ca²³'láan³: ―¿'I̱i̱² hua² sɨɨ'³¹ 'í³ 'i³ mɨ³sɨ'²³ 'nʉ³: “Ben²³² jmoo³ quien³²nu³. Ŋɨ² 'nʉ³”? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","'E³ quie'²³ 'a²³jia'³ ñi³² 'ñée² dsa³ 'i³ ca²³'láan³ 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ ca²³mi²³'láa³ quie'². Qui² ca²³bǿn³ Jesús je² núu²³. Qui² bi²³ juɨ́ɨn²³ dsa³ ta'n² 'oo'² i²ro̱o̱³². ");
INSERT INTO cnlNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Cɨ̱ɨ̱n³ cɨ² la'³ ca²³mi²³jí̱i̱n³ dsa³ 'í³ Jesús 'e³ la²³ 'iún² ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Jóo² ma². Mɨ³'láan³nu³. 'A²³ ma²³ rɨ³jmeen³ 'e³ xa³ dsoo² quien³²nu³. Qui² bi²³ juø'² rɨ²³jí̱i̱n²nu³ 'e³ bi²³ cɨ² 'a²³jia'³ dxʉ́²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","'E³ quie'²³ jo̱³ ŋóo² co̱'³ dsa³ 'í³. I²xii'²³² te'²³ juii² dsa³ Israel 'e³ Jesús hua² 'i³ ca²³mi²³'láa³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","'E³ jo̱³ hua² 'e³ ca²³jme'²³te'²³ Jesús, ca²³jmóo² te'²³ juii² dsa³ Israel. Qui² 'e³ ca²³jmée³ ta² 'e³ lǿ² la'³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ juii² dsa³ Israel: ―Jmee²³ quie'²³ ta² Ñu'n²³. 'E³ quie'²³ la'³, jmeen²³ ta² jné² co̱'³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'E³ jo̱³ bi²³ cɨ² ca²³la²³'née²³ te'²³ juii² dsa³ Israel 'e³ rɨ²³jŋɨ'n²³te'²³ Jesús. Qui² 'a²³la³ 'nɨɨ'n³¹ 'e³ ca²³jmée³ 'e³ lǿn³te'²³ 'e³ 'a²³jia'³ joo'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. 'E³ quie'²³ Ñu'n²³ ca²³jua'³ ca²³'én² Dios. Ca²³jmée³ 'e³ røø³ lǿn²³ quia̱'² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ Israel: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³'e³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²jmeen²³² jné² Jo̱o̱³¹ Dios cua̱a̱n²tu² quián²³ 'ñáan²³. Jmø'n² 'e³ la²³ maan²³ 'e³ jmee²³ Ñu'n²³, 'e³ quie'²³ la'³ jmeen²³ jné². Qui² 'e³ la²³ jmee²³ Ñu'n²³, la'³ jmeen²³ jné² Jo̱o̱³¹ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Qui² bi²³ 'néen² jné² Ñu'n²³. 'Ee²³ jné² la²³jɨ³ 'e³ jmee²³ 'ñée². 'E³ quie'²³ 'e³ cɨ² rɨ²³'ée²³ jné² ta² 'e³ gáan³ cɨ² la²³ cɨ'²³ 'e³ mɨ³ñíi³ra'³ 'e³ jua'³ 'née²³ 'e³ juø'²³ rɨ²joo³¹ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Qui² jmee²³ Ñu'n²³ 'e³ sɨ³ji̱i̱'²³ co̱'³ dsa³ 'i³ sɨ³jú̱n³. 'E³ quie'²³ la'³ jné² Jo̱o̱³¹ co̱'³. Jmeen²³ 'e³ sɨ³ji̱i̱'²³ co̱'³ te³ 'i̱i̱² sɨɨ'³¹ 'i³ 'náan²³ rɨ²jme'n¹ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","'A²³la³ 'ñée² Ñu'n²³ 'i³ jmee²³ 'i'²³ 'e³ xi² xa³ dsoo² quiee'³² dsa³. 'E³ quie'²³ mɨ³cuǿ³ ju²³bíi²³ quián²³ jné² Jo̱o̱³¹ 'e³ rɨ²jmeen²³² 'i'²³ 'e³ xi² xa³ dsoo² quiee'³² la²³jɨn³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Qui² 'née²³ Ñu'n²³ 'e³ rɨ²³mi²³gáan³ jné² Jo̱o̱³¹ la²³jɨn³ dsa³ 'e³ la²³ mi³gáan³te'²³ 'ñée². 'E³ quie'²³ 'a²³jia'³ dxʉ́²³ lʉ²³ 'en³² Ñu'n²³ 'i³ ca²³xíin²³ jné² dsa³ 'i³ 'a²³jia'³ dxʉ́²³ lʉ²³ 'en³² jné² Jo̱o̱³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Rɨ³ji̱'²³ ca³cuaa³ dsa³ 'i³ nuu³ júu² quián²³, dsa³ 'i³ sɨ³táan³ quia̱'² Ñu'n²³ 'i³ ca²³xíin²³ jné². 'A²³jia'³ rɨ²³dxá²³te'²³ ta² quiee'³². 'A²³jia'³ ma²³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jú̱n³. Qui² rɨ³lø³¹ 'i'²³ 'e³ rɨ³ji̱'²³ ca³cuaa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Mɨ³ rɨ²³tɨ́²³ jmɨ́ɨ², 'e³ quie'²³ mɨ³tɨ́³ rɨ³nɨ²³, 'e³ rɨ²³núu²³ dsa³ 'i³ rɨ³jú̱n² dsɨ́² júu² 'e³ lʉn²³ jné² Jo̱o̱³¹ Dios. 'E³ jo̱³ rɨ²³lí³ 'e³ rɨ³ji̱'²³ dsa³ 'i³ rɨ²³núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ñu'n²³ rɨ³løn³¹ juii² 'e³ sɨ³ji̱i̱'²³ dsa³. 'E³ jo̱³ ca²³jmée³ 'ñée² 'e³ rɨ³løn³¹na¹ jné² juii² 'e³ sɨ³ji̱i̱'²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mɨ³cuǿø²³ jné² júu² 'e³ rɨ²jmeen²³² 'i'²³ 'e³ xi² xa³ dsoo² quiee'³² dsa³. Qui² Jo̱o̱³¹ Dsa³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","'A²³jia'³ 'ne'² 'e³ juø'²³ rɨ²³ti²³cø̱n³¹na'³ 'e³ jmeen²³ 'e³ sɨ³ji̱i̱'²³ dsa³. Qui² 'e³ cɨ² rɨ²³tɨ́²³ 'e³ rɨ²³núu²³ la²³jɨn³ dsa³ 'i³ rɨ³'aan²³ 'e³ la²³ lʉn²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","'E³ jo̱³ rɨ²³'uǿøn²³te'²³ 'e̱e̱³ je² rɨ³'aan²³te'²³. Rɨ²³ji̱i̱'²³ co̱'³ dsa³ 'i³ mɨ³jmóo² 'e³ dxʉ́²³ 'e³ la²³ rɨ³ji̱'²³te'²³ ca³cuaa³. 'E³ quie'²³ rɨ²³ji̱i̱'²³ co̱'³ 'e³ la²³ rɨ²³dxá²³te'²³ ta² quiee'³², dsa³ 'i³ mɨ³jmóo² 'e³ 'a²³jia'³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’'A²³'e³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²jmeen²³² 'e³ la²³ 'náan²³ 'ñáan²³. Qui² jmeen²³ 'i'²³ 'e³ xi² xa³ dsoo² quiee'³² dsa³ 'e³ la²³ cuø²³ jui³¹ quián²³ Ñu'n²³. 'E³ quie'²³ jmeen²³ 'i'²³ ca³dsaan³². Qui² 'a²³la³ 'e³ la²³ 'náan²³ 'ñáan²³ 'e³ jmeen²³. Jmeen²³ 'e³ la²³ 'née²³ Ñu'n²³ 'i³ ca²³xíin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","'U² cu²ru'³ jø̱n³na²³ 'ñáan²³ hua² rɨ³løn³¹na¹ dsa³ ñi³ 'e³ jmeen²³ júu² 'e³ jmii'³¹ jmeen²³, 'a²³jia'³ lǿn³te'²³ 'e³ lʉn²³ ju²dsoo³¹ cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","'E³ quie'²³ xen³ cɨ² 'i³ rɨ³løn³¹ dsa³ ñi³, 'i³ jmee²³ júu² 'e³ jmii'³¹ jmeen²³. 'E³ quie'²³ maan²³ 'e³ lʉ²³ ju²dsoo³¹ 'ñée² 'e³ la²³ 'en³² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ca²³xíin²³na'³ 'nee'²³ dsa³ 'i³ ca²³tín²³ júu² quie'² Juan. Ca²³lǿn²³ dsa³ ñi³ 'ñée². Ca²³lʉ́³ ju²dsoo³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","'E³ quie'²³ 'a²³la³ jo̱³ 'e³ juø'n²³ 'e³ jmeen²³ quí̱i̱n²³ júu² quiee'³² dsa³ 'e³ juø'n²³ la'³. Te³ 'øn²³ júu² 'e³ ca²³sɨ'²³ 'nee'²³ Juan 'e³ juø'n²³ 'náan²³ 'e³ rɨ²³láan³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","La²³ xen³ ji³ 'e³ rɨ³so̱'², 'e³ bi²³ cuø²³ jmɨ́ɨ²³, xen³ 'ñée² Juan. Dxʉ́²³ 'óo²ra'³ mɨ²jo̱³ 'e³ rɨ²jmée²ra'³ 'e³ jɨn³ 'óo²ra'³ ca³juɨ² ca²³ji̱i̱³ je² cuø²³ jmɨ́ɨ²³ ji³ quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","'E³ quie'²³ gáan³ cɨ² la²³ júu² quiee'³² Juan 'e³ xa³ quián²³ 'e³ jmee²³ lii²³ 'e³ 'i̱i̱² sɨɨ'³¹ jné². Qui² mɨ³cuǿ³ júu² Ñu'n²³ 'e³ jmeen²³ u²³juø'²³. Ta² jo̱³ jmee²³ lii²³ 'e³ 'i³ 'í³ hua² 'i³ ca²³xíin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'E³ quie'²³ 'ñée² Ñu'n²³ ca²³jmée³ lii²³ 'e³ 'i̱i̱² sɨɨ'³¹ jné². 'A²³jia'³ lɨ'³ ca³nʉʉ³ra'³ 'e³ lʉ²³. 'A²³jia'³ lɨ'³ ca³ñín²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","'E³ quie'²³ 'a²³jia'³ nee'²³² 'óo²ra'³ júu² quiee'³². Qui² 'a²³jia'³ sɨ³táan³na'³ quia̱'n²na'³ jné² 'i³ ca²³xíin²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Joo³²ra'³ ji³ je² to̱o̱²³ júu² quiee'³² Dios. Qui² lǿn³na'³ 'e³ rɨ²³ji̱i̱'n²³na'³ ca³cuaa³ 'e³ juo'³ra'³ 'e³ xa³ júu² quiee'³² Dios quién²na'³. 'E³ quie'²³ jné² hua² 'en³² júu² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Juø'n³ quie'²³ 'en³² jné² júu² quiee'³² Dios, 'a²³jia'³ dxʉ́²³ 'óo²ra'³ 'e³ rɨ²³lín³na'³ dsa³ quién²³na²³. 'U² cu²ru'³ rɨ²³lín³na'³ dsa³ quién²³na²³, rɨ²³ji̱i̱'n²³na'³ 'u² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’'A²³jia'³ jmeen²³ quí̱i̱n²³ 'e³ xi² mi³gáan³ jné² dsa³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","'E³ quie'²³ maan²³ 'e³ jmii'³¹ lǿ² 'óo²ra'³. Maan²³ 'e³ 'a²³jia'³ 'náan²³na'³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","'E³ 'iin³¹ Ñu'n²³ 'e³ güén²³na²³. 'E³ quie'²³ 'a²³jia'³ 'noo³ra'³ 'e³ rɨ²'ii'n³¹na'³ jné². Xi³nu³ rɨ²³güén³ jia'³ cɨ'²³ 'i³ rɨ²³jmée²³ 'e³ la²³ 'née²³ 'ñée², 'i³ 'í³ hua² 'i³ rɨ²'ii'n³¹na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","'A²³jia'³ jmɨ́ɨ² rɨ²³lí³ juø'² rɨ²³sɨ²³táan³na'³, ¿mɨ²naa'³¹? Qui² 'noo³ra'³ 'e³ rɨ²³jua'³ uu'n²na'³ 'e³ bi²³ dxʉ́²³ jmee³ra'³. 'E³ quie'²³ 'a²³jia'³ mi³quí̱i̱n²³na'³ 'e³ jmii'³¹ rɨ²³jua'³ Dios 'i³ jø̱n³ 'ñée² hua² xen³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","'A²³jia'³ 'ne'² 'e³ rɨ²lǿn³na'³ 'e³ jné² hua² 'i³ rɨ²cuøn²³² dsoo² quién²na'³ xi²ñi² Ñu'n²³. Qui² 'a²³la³ jné² 'i³ cuøn²³ dsoo². Ley 'e³ ca²³ŋɨ́n² Moisés hua² 'e³ cuø²³ dsoo² quién²na'³, juø'n³ quie'²³ lǿn³na'³ 'e³ rɨ²³láan² 'nee'²³ ley jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","'U² cu²ru'³ sɨ³táan³na'³ quia̱'n²na'³ ley 'e³ ca²³ŋɨ́n² Moisés, sɨ³táan³na'³ quia̱'n²na'³ jné² co̱'³ 'u² cu²ru'³ la'³. Qui² jné² hua² 'i³ ca²³'én² Moisés ma²ca¹té̱e̱¹ ji³ ley. ");
INSERT INTO cnlNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","'E³ quie'²³ ¿jmii'³¹ rɨ²³sɨ²³táan³na'³ júu² quián²³ xi³nu³ 'a²³jia'³ sɨ³táan³na'³ 'e³ la²³ lǿ² 'e³ ca²³té̱e̱² ji³ Moisés? ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma²mɨ³líi² la'³, ca²³'øn³ Jesús jmɨ²³ñii'³¹ Galilea, 'e³ jua'³te'²³ jmɨ²³ñii'³¹ Tiberias. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Juɨ́ɨn²³ dsa³ 'i³ ca²³guín²³ tu³cɨ̱ɨ̱n³. Qui² ŋó²³te'²³ u²³juø'²³ 'e³ jmee²³ lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³. Qui² mi³'láan³ dsa³ 'i³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","'E³ quie'²³ jo̱³ ca²³huɨ́ɨ³ yʉʉ'³¹ cuo̱o̱'³ Jesús. Núu²³ ca²³gua³ quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","La²³ca̱a̱n³ mɨ²jo̱³ ca²³lǿ²³ mɨ³lén² mɨ²juee'³ pascua quiee'³² dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ca²³jóo² Jesús. Ŋó²³ 'e³ juɨ́ɨn²³ dsa³ 'i³ ja³guín²³ caan²³. 'E³ jo̱³ ca²³jua'³. Ca²³sɨ'²³ Bi³lii²: ―¿Jiaa'³¹ sɨ³la²³²ra² 'ɨ²³juɨ² 'e³ rɨ²³e'² dsa³ la³? ");
INSERT INTO cnlNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","La'³ ca²³jua'³ Jesús 'e³ jua'³ 'née²³ rɨ²³jóo² 'e³ jmii'³¹ rɨ²³jua'³ Bi³lii². Qui² ñi³² 'ñée² Jesús 'e³ jmii'³¹ rɨ²³jmée²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","'E³ jo̱³ ca²³jua'³ Bi³lii²: ―'A²³jia'³ rɨ²³líi² la²³'nɨɨ'n³¹ ñu'n² jñiin²³ dsa³ 'e³ tú̱²³ i³lóo³ jmɨ́ɨ² ta² 'e³ rɨ²la²³²ra² 'ɨ²³juɨ², juø'n³ quie'²³ ca³juɨ² rɨ²³e'² cɨ'³ la²³ jø̱n³ dsa³. ―La'³ ca²³jua'³ Bi³lii². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","'E³ quie'²³ ca²³lʉ́³ jø̱n³ dsa³ quien³² 'i³ xi̱i̱n³ Drøø³¹, la²³ ca³já̱a̱n² quia̱'² Muun³² Peen²³². Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Xen³ la³ jø̱n³ xii'³ pii'² 'i³ quie̱³ 'ɨ²³juɨ² quia̱'² 'moo'³, ¿mɨ³naa'³¹? Quie̱³ 'ñé³ 'ɨ²³juɨ² tʉʉ² mɨ³¹cuɨɨ³ cebada quia̱'² áan²³ 'moo'³ 'u². 'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² rɨ²³líi². Qui² bi²³ juɨ́ɨn²³ dsa³. ―La'³ ca²³jua'³ Drøø³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Xii'²ra'³ dsa³ 'e³ rɨ²³gua³te'²³ ―ca²³jua'³. Bi²³ xa³ mɨ³¹ñii³ pii'² je² núu²³. 'E³ quie'²³ jo̱³ ca²³guó³te'²³. Xen³ co̱o̱³ 'ñé³ mil 'nɨɨ'n³¹ jmø'n² dsóo²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","So̱'²³ 'ɨ²³juɨ² Jesús. Ca²³ji̱i̱n³ mɨ²'áa² quie'² Dios. Jo̱³ tu³ ca²³cuǿø²³ dsa³ quien³². 'I³ 'í³ hua² 'i³ ca²³to'²³ dxóo² 'e³ rɨ²³e'² dsa³ 'i³ nee'n²³² 'uǿ²³. 'E³ quie'²³ la'³ 'moo'³ co̱'³. Ca²³cuǿø²³ dsa³ la²³'nɨɨ'n³¹ 'e³ 'née²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","'E³ quie'²³ bi²³ dxʉ́²³ ca²³e'² dsa³. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Dxi³cua̱a̱'n³²na'³ juɨɨ²³² 'ɨ²³juɨ² 'e³ mɨ³tø'n² quia̱'² 'noo³¹ quie'² 'moo'³. Qui² bi²³ juø'² rɨ²³gua'²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","'E³ quie'²³ jo̱³ ca²³dxi²³cua̱a̱'n³te'²³. Ca²³cø̱'n²³ gui²³tʉ̱́³ mɨɨ'³ dsuu² 'nɨɨ'n³¹ jmø'n² juɨɨ²³² 'ɨ²³juɨ² 'e³ ca²³tø'n² je² ca²³e'² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ŋó²³ dsa³ u²³juø'²³ 'e³ ca²³jmée³ Jesús 'e³ ca²³jmée³ lii²³ 'e³ bi²³ gáan³. 'E³ jo̱³ ca²³jua'³te'²³: ―Rɨ³lø³¹ 'i'²³ 'e³ rɨ²³güén³ mɨ³¹güii³ dsa³ 'i³ rɨ²³'ɨ́ɨ²³ júu² quiee'³² Dios. 'I³ la³ hua² 'i³ 'í³ ca³quie̱e̱² ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","'E³ quie'²³ ca²³la²³quii²³ Jesús 'e³ lǿn³ dsa³ 'e³ la²³bii²³ rɨ²³dxin³te'²³ 'e³ rɨ²³lín³ rey. 'E³ jo̱³ ca²³bǿn³. Ŋóo² yʉʉ'³¹ mo'³ jø̱n³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma²mɨ³nʉʉ³, ca²³guín²³ dsa³ quien³² co̱³² jmɨ²³ñii'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ca²³ta'n²³te'²³ 'e̱'³ móo² 'e³ jua'³ sɨ³guiin³²te'²³ juɨɨ³ Capernaum. 'Íi² quie'²³ 'e³ rɨ²³dxóo² Jesús 'e³ ca²³nʉʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bi²³ ca²³ró̱o̱²³ dxí³. 'E³ jo̱³ bi²³ ca²³'lø'n³² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ta'n² 'uu²³te'²³ móo². Mɨ³ŋɨ́n³te'²³ co̱o̱³ 'ñé³ jñʉ́ʉ³ kilómetros 'nɨɨ'n³¹ 'e³ ŋó²³te'²³ 'e³ ja³'ɨ́ɨn²³ Jesús ñi'² jmɨ²³ñii'³¹. Ja³'ɨ́ɨn²³ je² 'iʉ² jui³¹ móo². 'E³ jo̱³ bi²³ ca²³jue'n² miin²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","'E³ quie'²³ ca²³jua'³ 'ñée²: ―Jné² hua² la³. 'A²³ rɨ³juø'n²na'³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","'E³ jo̱³ bi²³ 'née²³te'²³ ca²³ta̱a̱'n³te'²³ 'e̱'³ móo². Xe̱'n² jmɨ́ɨ² ca²³dxi²³guiin³²te'²³ 'uǿ²³ je² 'née²³ sɨ³guiin³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","La²³ mɨ³dxóo³ la'³ ca²³jmóo² 'i'²³ dsa³ 'i³ ca²³cuaa'n²³ joo³¹ i²³'ŋóo². Qui² ñi³²te'²³ 'e³ co̱o̱³ hua² móo² xa³ dxóo³. 'E³ quie'²³ ñi³²te'²³ 'e³ 'a²³jia'³ 'í² Jesús 'e̱'³ móo² quia̱'² dsa³ quien³². Ñi³²te'²³ 'e³ miin²³ dsa³ quien³² ca²³guiin³². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","'E³ quie'²³ jmɨ́ɨ² jo̱³ xa³ jia'³ cɨ'²³ móo² 'e³ ca²³dxi²³guín²³ mɨ³lén² je² ca²³e'²te'²³ 'ɨ²³juɨ² ma²ca¹ji̱i̱n³ mɨ²'áa² Juii³ra². Ca²³dxi²³guín²³ móo² 'e³ naan³ jí̱i̱n² juɨɨ³ Tiberias. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","'E³ quie'²³ jo̱³ ca²³ta'n²³ miin²³ dsa³ 'e̱'³ móo² ma²ŋó¹te'²³ 'e³ 'a²³'i̱³ ma²³ xen³ Jesús quia̱'² dsa³ quien³². Ca²³guín²³te'²³ juɨɨ³ Capernaum 'e³ jua'³ ca²³'nee'n³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ca²³dsø'n²³te'²³ Jesús je² ca²³dxi²³guín²³te'²³. 'E³ jo̱³ ca²³sɨ'²³te'²³: ―Dsa³ 'e²³, ¿mɨ²lɨɨ'³¹ güén²³nu³ je² la³? ");
INSERT INTO cnlNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³la³ jo̱³ 'e³ ca²³ñíi³ra'³ 'e³ ca²³jméen²³ u²³juø'²³ 'e³ 'naa'n²³na'³ jné². 'E³ juo'³ra'³ bi²³ dxʉ́²³ ca²³quie'³ra'³, 'e³ 'naa'n²³na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","'A²³ rɨ³jmee³ra'³ quí̱i̱n²³ la²³jɨ³ 'e³ cø'³ra'³. Qui² ca²³ji̱i̱³ sɨ³ŋɨ́n³. 'E³ quie'²³ rɨ²jmée²ra'³ quí̱i̱n²³ la²³jɨ³ 'e³ rɨ²cø'²ra'³ 'e³ rɨ²cuǿøn¹na²³ 'nee'²³ jné² Jo̱o̱³¹ Dsa³. Rɨ²jmée²ra'³ quí̱i̱n²³ la²³jɨ³ 'e³ rɨ²cø'²ra'³ 'e³ huǿø³ tii'n³¹, 'e³ jmee²³ 'e³ rɨ³ji̱'²³ dsa³ ca³cuaa³. Qui² mɨ³jmée³ lii²³ Dios Ñu'n²³ 'e³ jmeen²³ ta² quiee'³². La²³ jmee²³ dsa³ 'i³ te̱e̱n³ mɨɨ³ ji³ quiee'³² jmee²³ 'ñée². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","'E³ quie'²³ jo̱³ ca²³jua'³ dsa³. Ca²³sɨ'²³te'²³ Jesús: ―¿Jmii'³¹ cu³lø³¹ 'ne'² rɨ²jmee²ra'³¹ 'e³ la²³ rɨ²jmee²ra'³¹ ta² quiee'³² Dios? ");
INSERT INTO cnlNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","'E³ jo̱³ ca²³jua'³ Jesús: ―La²³la³ cu³lø³¹ ta² quiee'³² Dios: 'Ne'² rɨ²³sɨ²³táan³na'³ quia̱'n²na'³ jné² 'i³ ca²³xíin²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","'E³ quie'²³ jo̱³ ca²³jua'³te'²³: ―¿'Ee² u²³juø'²³ rɨ²jméen² 'e³ rɨ²³jmée²³ lii²³ 'e³ bi²³ gáan³nu³? ¿'Ee² u²³juø'²³ rɨ²jméen² 'e³ rɨ²joo²³²ra'³¹, 'e³ la²³ rɨ²³sɨ²³táan³na'³¹? ¿'Ee² ta² rɨ²jméen² jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ca²³e'² xi²'ioo² yi²³uu'²ra² jaa²³² 'ɨ́² 'e³ xi̱i̱n³ maná ma²ca¹guó³te'²³ je² 'a²³jia'³ nee'n²³² dsa³. Ca²³lǿ²³ 'e³ la²³ to̱o̱²³ ji³: “Jí̱i̱n² yʉʉ'³¹ güii³ ca²³cuǿø²³ dsa³ 'ɨ́² 'e³ rɨ²³e'²te'²³”. ―La'³ ca²³sɨ'²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","'E³ quie'²³ ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³la³ 'í³ Moisés 'i³ ca²³cuǿø²³ 'nee'²³ 'ɨ́² 'e³ jó² jí̱i̱n² yʉʉ'³¹ güii³ 'e³ ca²³e'² xi²'ioo² yi²³uu'²ra² jaa²³². Ñu'n²³ hua² 'i³ ca²³cuǿ³ 'ɨ́² jo̱³. 'I³ 'í³ hua² 'i³ cuøø²³ 'nee'²³ 'ɨ́² 'e³ rɨ²cø'²ra'³ 'e³ xa³ yʉʉ'³¹ güii³ 'e³ jmee²³ ta² ca³quie̱e̱². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Qui² jŋóo²³ jí̱i̱n² yʉʉ'³¹ güii³ 'ɨ́² 'e³ cuøø²³ 'nee'²³ Dios. Jmee²³ 'e³ rɨ³ji̱'²³ dsa³ mɨ³¹güii³ 'ɨ́² jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","'E³ jo̱³ ca²³jua'³ dsa³. Ca²³sɨ'²³te'²³ Jesús: ―Juii³ra'³¹, cuø² quiée²ra'³¹ ca³cuaa³ 'ɨ́² 'e³ 'øn³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","'E³ jo̱³ ca²³jua'³ Jesús: ―Jné² hua² 'i³ rɨ³løn³¹na¹ 'ɨ́² 'e³ jmee²³ 'e³ rɨ³ji̱'²³ dsa³. 'A²³'e³ ma²³ xa³ 'ne'² quie'² dsɨ́² dsa³ 'i³ 'née²³ rɨ²³lín³ dsa³ quién²³na²³, dsa³ 'i³ sɨ³táan³ quia̱'² jné². 'É̱e̱² 'e³ 'a²³jia'³ ma²³ li²³cue̱'²³. 'É̱e̱² 'e³ 'a²³jia'³ ma²³ li²³dxíin³ dsɨ́² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","'E³ quie'²³ mɨ³juǿøn²na²³ 'nee'²³: 'A²³jia'³ sɨ³táan³na'³, juø'n³ quie'²³ mɨ³ñíi³ra'³ 'e³ jmii'³¹ jmeen²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Li²³quién²³na²³ la²³jɨn³ 'i³ cuøn²³ jné² Ñu'n²³. 'E³ quie'²³ rɨ²'ii'n³¹na¹ dsa³ 'i³ 'née²³ rɨ²³lín³ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jmeen²³ 'e³ la²³ 'née²³ 'i³ ca²³xíin²³ jné². 'E³ jo̱³ hua² 'e³ jŋáan²na²³ jí̱i̱n² yʉʉ'³¹ güii³. 'A²³la³ jo̱³ 'e³ juø'n²³ 'náan²³ rɨ²jmeen²³² 'e³ la²³ 'náan²³ 'ñáan²³ 'e³ jŋáan²na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","'E³ quie'²³ la²³la³ cu³lø³¹ 'née²³ Ñu'n²³ 'i³ ca²³xíin²³ jné². 'Née²³ 'e³ 'a²³jia'³ rɨ²³gua'²³ quián²³ la²³jɨn³ 'i³ mɨ³cuǿn²³ jné². Cu³xi³ jø̱n³ 'a²³jia'³ 'née²³ 'e³ rɨ²³gua'²³. 'Née²³ 'e³ rɨ²jmeen²³² 'e³ rɨ²³ji̱i̱'²³te'²³ co̱'³ mɨ³rɨ³ti³ jmɨ́ɨ² je² dsøn³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","La²³la³ cu³lø³¹ 'née²³ Ñu'n²³ co̱'³: 'Née²³ 'e³ rɨ³ji̱'²³ ca³cuaa³ la²³jɨn³ dsa³ 'i³ sɨ³li³cuiin²³ jné² Jo̱o̱³¹, 'i³ sɨ³táan³ quia̱'² jné². 'E³ quie'²³ rɨ²jmeen²³² 'e³ rɨ²³ji̱i̱'²³te'²³ co̱'³ mɨ³rɨ³ti³ jmɨ́ɨ² je² dsøn³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","'E³ jo̱³ bi²³ ca²³lʉ́³ te'²³ juii² dsa³ Israel 'e³ jua'³ mɨ'n³te'²³ ñin³²te'²³ Jesús. Qui² ca²³jua'³ 'ñée²: “Jné² hua² 'i³ rɨ³løn³¹na¹ 'ɨ́² 'e³ jŋóo²³ jí̱i̱n² yʉʉ'³¹ güii³”. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","'E³ jo̱³ ca²³jua'³te'²³: ―¿'A² 'a²³la³ 'í³ Jesús jo̱o̱³¹ Søø³² dsa³ la³? Cuiin²³na² xóo² jmii³. ¿Jmii'³¹ lǿ² 'e³ jua'³ 'ñée²: “Jŋáan²na²³ jí̱i̱n² yʉʉ'³¹ güii³”? ");
INSERT INTO cnlNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'A²³ ma²³ rɨ³lʉ́²ra'³ co̱³quién²na'³ 'e³ juo'³ra'³ mɨ'n³na'³ mǿn²³na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","'A²³'i̱³ xen³ 'i³ rɨ²³lí³ juø'² rɨ²³lín³ dsa³ quién²³na²³ xi³nu³ 'a²³jia'³ rɨ²³tøø³ dsa³ 'í³ Ñu'n²³ 'i³ ca²³xíin²³ jné². 'E³ quie'²³ jné² rɨ²jmeen²³² 'e³ rɨ²³ji̱i̱'²³ co̱'³ dsa³ quién²³na²³ mɨ³rɨ³ti³ jmɨ́ɨ² je² dsøn³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Qui² la²³la³ cu³lø³¹ ca²³té̱e̱² ji³ jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³²: “Dios rɨ²³'ée²³ la²³jɨn³ dsa³ 'í³”. 'E³ jo̱³ rɨ²³lín³ dsa³ quién²³na²³ la²³jɨn³ dsa³ 'i³ nuu³ 'e³ jmii'³¹ jua'³ Ñu'n²³, 'i³ mɨ³'é³ Ñu'n²³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’'E³ quie'²³ 'a²³la³ jo̱³ 'e³ xen³ dsa³ 'i³ lɨ'³ ca³ŋøn³² Ñu'n²³. Jø̱n³ jné² hua² 'i³ ca²³áan²³ jí̱i̱n² je² jen³¹ Dios Ñu'n²³. Jø̱n³ jné² hua² 'i³ lɨ'³ ca³mǿn²na²³ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Rɨ³ji̱'²³ ca³cuaa³ dsa³ 'i³ sɨ³táan³ quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jné² hua² 'i³ rɨ³løn³¹na¹ 'ɨ́² 'e³ jmee²³ 'e³ rɨ³ji̱'²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ca²³e'² xi²'ioo² yi²³uu'²ra² jaa²³² 'ɨ́² 'e³ xi̱i̱n³ maná ma²ca¹guó³te'²³ je² 'a²³jia'³ nee'n²³² dsa³. 'E³ quie'²³ jú̱n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","'E³ quie'²³ 'e³ la³ hua² 'ɨ́² 'e³ jŋóo²³ jí̱i̱n² yʉʉ'³¹ güii³. 'A²³jia'³ rɨ²³jú̱n³ dsa³ 'i³ rɨ²³e'² 'ɨ́² la³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jné² hua² 'i³ rɨ³løn³¹na¹ 'ɨ́² 'e³ rɨ³ji̱'²³ 'e³ jŋóo²³ jí̱i̱n² yʉʉ'³¹ güii³. 'E³ jo̱³ rɨ³ji̱'²³ ca³cuaa³ dsa³ 'i³ ee'³² 'ɨ́² la³. Xa³ 'e³ rɨ²cuøn²³² 'e³ rɨ²³e'² dsa³ 'e³ juø'n²³ 'náan²³ 'e³ rɨ²³ji̱i̱'²³ dsa³ mɨ³¹güii³. Jmɨn²³ ŋun²³ hua² 'øn²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","'E³ jo̱³ ca²³sɨ́n²³ júu² la²³ co̱³quie'² te'²³ juii² dsa³ Israel 'i³ ca²³núu³ 'e³ jmii'³¹ ca²³jua'³. Ca²³jua'³te'²³: ―¿Jmii'³¹ rɨ²³jmée²³ dsa³ la³ 'e³ rɨ²³cuǿø²³ jne² jmɨ² ŋu² 'e³ rɨ²quie²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³jia'³ rɨ³ji̱'n²na'³ xi³nu³ 'a²³jia'³ cø'³ra'³ ŋun²³ jné² Jo̱o̱³¹ Dsa³, xi³nu³ 'a²³jia'³ 'u'³ra'³ jmɨ²³'øn²³²na¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Rɨ³ji̱'²³ ca³cuaa³ dsa³ 'i³ ee'³² ŋun²³ jné², 'i³ 'ɨ̱ɨ̱'³² jmɨ²³'øn²³²na¹. 'E³ jo̱³ rɨ²jmeen²³² 'e³ rɨ²³ji̱i̱'²³ co̱'³ dsa³ 'í³ mɨ³rɨ³ti³ jmɨ́ɨ² je² dsøn³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Qui² 'e̱'n³ quie'²³ dsɨ́² cuø²³ ju²³bíi²³ jmɨn²³ ŋun²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","'E³ quie'²³ dxin²³² quia̱'² jné² dsa³ 'i³ ee'³² ŋun²³, 'i³ 'ɨ̱ɨ̱'³² jmɨ²³'øn²³²na¹. 'E³ quie'²³ la'³, dxin²³²na¹ 'ñáan²³ quia̱'n²³²na¹ dsa³ 'í³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ca²³xíin²³ jné² Ñu'n²³ 'i³ rɨ³ji̱'²³. 'E³ quie'²³ jmee²³ Ñu'n²³ 'e³ rɨ³ji̱'n²³na²³ 'ñáan²³. 'E³ quie'²³ la'³, jné² jmeen²³ 'e³ rɨ³ji̱'²³ dsa³ 'i³ ee'³² jmɨn²³ ŋun²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","'E³ la³ 'ɨ́² 'e³ jŋóo²³ jí̱i̱n² yʉʉ'³¹ güii³. 'E³ quie'²³ 'a²³jia'³ lǿ² la²³ lǿ² maná 'e³ ca²³e'² xi²'ioo² yi²³uu'²ra² jaa²³² mɨ²jo̱³. Qui² jú̱n²³te'²³. 'E³ quie'²³ rɨ³ji̱'²³ ca³cuaa³ dsa³ 'i³ ee'³² 'ɨ́² la³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","La'³ cu³lø³¹ ca²³jua'³ Jesús 'e³ la²³ ca²³'ée²³ dsa³ ñʉ'²³ 'ñʉ́² je² mi³gáan³te'²³ Dios juɨɨ³ Capernaum. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ma²ca¹núu³ dsa³ quien³² 'e³ jmii'³¹ ca²³jua'³, juɨ́ɨn²³ xen³ 'i³ ca²³jua'³: ―Bi²³ gáan³ dxíi³ júu² nɨ³. ¿'I̱i̱² sɨɨ'³¹ 'i³ rɨ²³lí³ juø'² rɨ²³jmée²³ quie'² júu² 'e³ lø³² la²³nɨ³? ");
INSERT INTO cnlNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","'E³ quie'²³ dsoo²³ dsɨ́² Jesús 'e³ la'³ cu³lø³¹ lʉ²³ dsa³ quien³² 'e²³te'²³ júu² 'e³ ca²³lʉ́³ 'ñée². 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―¿'A² mɨ³jmée³ 'e³ mɨ³'lǿn²³na'³ júu² 'e³ cɨ² mɨ³lʉn²³? ");
INSERT INTO cnlNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Jmii'³¹ rɨ²lǿn³na'³ jo̱o̱²³na²³ xi³nu³ rɨ²móo²ra'³ 'e³ i³huɨ́ɨn³ co̱'³ jné² Jo̱o̱³¹ Dsa³ 'e³ ñe'n³²na²³ je² jen³¹na¹ xe̱'n²? ");
INSERT INTO cnlNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dsɨ́² dsa³ hua² 'e³ jmee²³ 'e³ rɨ³ji̱'²³ dsa³. 'A²³'e³ xa³ rɨ²³lí³ juø'² rɨ²³jmée²³ jmɨ² ŋu² dsa³. 'Ne'² quie'² dsɨ́² dsa³ júu² 'e³ mɨ³juǿøn²na²³ 'nee'²³. Jmee²³ 'e³ rɨ³ji̱'²³ dsa³ ca³quie̱e̱². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","'E³ quie'²³ xen³na'³ ca³dxáan²na'³ 'i³ 'a²³jia'³ sɨ³táan³na'³. La'³ ca²³jua'³ Jesús. Qui² ñi³² 'ñée² cɨ'²³ mɨ²xe̱'n³¹ 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ 'a²³jia'³ sɨ³táan³. Ñi³² 'ñée² 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³'nɨ́ɨn²³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Co̱'³ cɨ'²³ ca²³jua'³ 'ñée²: ―'E³ jo̱³ hua² 'e³ mɨ³juǿøn²na²³ 'nee'²³: “'A²³'i̱³ xen³ 'i³ rɨ²³lí³ juø'² rɨ²³lín³ dsa³ quién²³na²³ xi³nu³ 'a²³jia'³ ca³tøø³ Ñu'n²³ quie'²”. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma²ca¹jua'³ la'³, juɨ́ɨn²³ dsa³ quien³² 'i³ ca²³tʉ́ʉ². 'A²³jia'³ ma²³ ca²³ŋɨ́³te'²³ quia̱'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ gui²³tʉ̱́n³: ―¿'A² rɨ²tún¹na'³ jné² 'nee'²³ co̱'³? ");
INSERT INTO cnlNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","'E³ quie'²³ ca²³lʉ́³ Muun³² Peen²³². Ca²³sɨ'²³ Jesús: ―Juii³ra'³¹, ¿'i̱i̱² sɨɨ'³¹ rɨ²qui̱i̱'³¹ra'³¹ xi³nu³ rɨ²tʉn²³²na'³¹ 'nʉ³? Qui² 'nʉ³ hua² 'i³ lʉ́n² júu² 'e³ jmee²³ 'e³ rɨ³ji̱'²³ra'³¹ ca³cuaa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mɨ³ca³táan³na'³¹ quia̱'n²na'³¹ 'nʉ³. Mɨ³dsóo²³ dsɨ³ra'³¹ 'e³ 'nʉ³ hua² 'i³ rɨ³løn³¹nu³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios, 'e³ rɨ³løn³¹nu³ Jo̱o̱³¹ Dios 'i³ rɨ³ji̱'²³. ―La'³ ca²³jua'³ Muun³² Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ca²³lʉ́³ co̱'³ Jesús. Ca²³sɨ'²³ te'²³ dsa³ gui²³tʉ̱́n³: ―Ca²³'náan²³na²³ 'nee'²³ dsa³ gui²³tʉ̱́n³, ¿mɨ²naa'³¹? 'E³ quie'²³ xen³na'³ jø̱n³na'³ 'i³ xen³na'³ la²³ xen³ mɨ²³sɨ²³quiʉ'² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas Iscariote, jo̱o̱³¹ Muun³², 'en³² Jesús. Dsa³ gui²³tʉ̱́n³ hua² 'í³. 'I³ 'í³ hua² 'i³ rɨ²³'nɨ́ɨn²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma²mɨ³líi² la'³, ca²³ŋɨ́³ Jesús la²³ca̱a̱n³ estado Galilea. Qui² 'a²³jia'³ 'née²³ 'e³ rɨ²³ŋɨ́²³ la²³ca̱a̱n³ estado Judea. Qui² jmoo³² 'i'²³ te'²³ juii² dsa³ Israel 'e³ jmii'³¹ rɨ²³lí³ juø'² rɨ²³jŋɨ'n²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ca²³lǿ²³ mɨ³lén² mɨ²juee'³ 'e³ mi³lii²³² dsa³ Israel 'e³ ca²³guó³te'²³ 'ñʉ́² loo³ mɨ²jo̱³ je² 'a²³jia'³ nee'n²³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","'E³ jo̱³ ca²³jua'³ te'²³ jó̱o̱² Jesús. Ca²³sɨ'²³te'²³ 'ñée²: ―Guaan³² co̱'³ estado Judea. Qui² jo̱³ hua² rɨ²³ñí² dsa³ quien³²nu³ 'i³ nee'n²³² núu²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³ ta² 'e³ jmeen³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Qui² 'a²³jia'³ jmee²³ dsa³ ta² je² 'mó² je² ñi² xi³nu³ 'née²³ 'e³ rɨ²³ñí² dsa³ 'e³ 'ee² ta² jmee²³. Xi³nu³ 'e̱'n³ quie'²³ dsɨ́² jmeen³ ta² 'e³ gáan³, 'ne'² rɨ²jméen² ta² i²³ñín² la²³nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","La'³ ca²³jua'³ te'²³ jó̱o̱² Jesús. Qui² cu³xi³ jó̱o̱² 'a²³jia'³ sɨ³táan³ quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ jó̱o̱²: ―'A²³jia'³ ca³tɨ́³ jmɨ́ɨ² 'e³ la²³ rɨ³lø³¹ 'i'²³ 'e³ ñiin²³. 'E³ quie'²³ 'a²³jia'³ xen³ la'³ quién² 'nee'²³. Røø³ 'íi² te³ 'ee² jmɨ́ɨ² 'e³ cu³guín²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Qui² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³jmóo² dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³ 'e³ 'a²³jia'³ ta³dsɨ³² ñin³² 'nee'²³. 'E³ quie'²³ 'a²³jia'³ ta³dsɨ³² ñin³² jné² dsa³ 'í³. Qui² jmeen²³ lii²³ jné² 'e³ jmii'³¹ 'nɨɨ'n³¹ 'e³ 'a²³jia'³ dxʉ́²³ jmoo³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cu³guín²³na'³ miin²³na'³ mɨ²juee'³. 'E³ quie'²³ 'a²³jia'³ mɨ³ ñiin²³ jné². Qui² 'a²³jia'³ ca³tɨ́³ jmɨ́ɨ² quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","La'³ ca²³jua'³ Jesús. 'E³ jo̱³ ca²³cuaa'n²³ estado Galilea. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","'E³ quie'²³ ŋóo² 'ñée² ma²mɨ³ca³guín²³ te'²³ jó̱o̱². 'E³ quie'²³ 'a²³jia'³ ŋóo² i²³ñín² la²³nɨ³. Ŋóo² 'mó² ñi². ");
INSERT INTO cnlNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","'E³ quie'²³ 'naa'n³ Jesús te'²³ juii² dsa³ Israel la²³ca̱a̱n³ je² nee'n²³² dsa³ mɨ²juee'³. Ca²³tín²³te'²³ júu². Ca²³jua'³te'²³: ―¿Jiaa'³¹ 'iún² Jesús cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bi²³ lʉ²³ dsa³ 'en³²te'²³ Jesús. “Dsa³ dxún²³ hua² 'í³”, jua'³ ca³dxáan². “'A²³jia'³ jmɨ́ɨ² 'í³. Qui² jmee²³ 'e³ sɨ³caa'n³² dsa³”, jua'³ ca³dxáan². ");
INSERT INTO cnlNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","'E³ quie'²³ 'ñaa'n²³te'²³ juii² dsa³ Israel. 'E³ jo̱³ 'a²³jia'³ li²³bii²³ dsɨ́²te'²³ 'e³ rɨ²³lʉ́²³te'²³ i²³ñín² la²³nɨ³ 'e³ rɨ²³'én²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ma²ca¹tɨ́³ quiʉ̱́³ jmɨ́ɨ² 'e³ nee'n²³²te'¹ mɨ²juee'³, 'í² Jesús ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Ca²³'ée²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bi²³ juø'²³ ca²³núu³ te'²³ juii² dsa³ Israel. Ca²³jua'³te'²³: ―¿Jmii'³¹ hua² lǿ² 'e³ bi²³ tɨn³ dsa³ nɨ³? 'A²³jia'³ jmɨ́ɨ² ñíin² escuela, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'A²³la³ júu² quián²³ 'ñáan²³ 'e³ 'een²³na²³ dsa³. 'En²³ júu² quiee'³² 'ñée² 'i³ ca²³xíin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","'E³ quie'²³ rɨ²³ñí² dsa³ 'i³ 'née²³ 'e³ rɨ²³jmée²³ 'e³ la²³ 'née²³ Dios xi² jo̱³ júu² quiee'³² Dios 'e³ 'en²³. Rɨ²³ñí² xi² cua̱a̱n²tu² quián²³ 'ñáan²³ 'e³ lʉn²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Qui² 'née²³ rɨ²³mi²³gáan³ 'ñée² dsa³ 'i³ lʉ²³ 'e³ la²³ 'née²³ 'ñée². 'E³ quie'²³ lʉ²³ ju²dsoo³¹ dsa³ 'i³ 'née²³ 'e³ rɨ²³mi²³gáan³ 'i³ ca²³xíi²³ quie'². 'A²³la³ te³ juu³² dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés ca²³ŋɨ́n² quién²na'³ ley, ¿mɨ³naa'³¹? 'E³ quie'²³ cu³xi³ jø̱n³ 'nee'²³ 'a²³jia'³ jmee³ra'³ 'e³ la²³ lǿ² ley. ¿'Ee² lǿ² 'noo³ra'³ 'e³ rɨ²jŋɨ'n²³na'³ jné²? ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","'E³ quie'²³ ca²³jua'³ dsa³ 'í³: ―¿'A² bi²³ xi³ quie̱n²³²nu³ espíritu quien³² mɨ²³sɨ²³quiʉ'²? ¿'I̱i̱² sɨɨ'³¹ 'i³ 'née²³ 'e³ rɨ²³jŋɨ'n²³ 'nʉ³? ―ca²³sɨ'²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","'E³ jo̱³ ca²³jua'³ Jesús: ―Xa³ co̱o̱³ u²³juø'²³ 'e³ ca²³jméen²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. 'E³ jo̱³ bi²³ juø'²³ ca²³jóo²ra'³ la²³jɨn³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ca²³jmée³ Moisés tɨ³² 'i'²³ 'e³ xi̱i̱n³ circuncisión. 'E³ quie'²³ 'a²³la³ 'í³ Moisés 'i³ ca²³jmée³ la'³ xe̱'n². Te'²³ dsa³ xoo'³¹ jmóo² hua² 'i³ ca²³jmée³ la'³ xe̱'n². 'E³ quie'²³ jmee'³²quie²³ra'³ xi³yu̱u̱n³ circuncisión, juø'n³ quie'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jmee'³²ra'³ xi³yu̱u̱n³ circuncisión, juø'n³ quie'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. Qui² 'noo³ra'³ 'e³ rɨ²³lí³ 'e³ la²³ lǿ² ley 'e³ ca²³ŋɨ́n² Moisés. ¿Jmii'³¹ lǿ² 'e³ ti̱'n³na'³ mǿn²³na'³ jné² 'e³ ca²³jméen²³ 'e³ ca²³'lóo³ rɨ³ca̱'n²³ jmɨ² ŋu² jø̱n³ dsa³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","'A²³ rɨ³juo'³ra'³ 'e³ xa³ dsoo² quiee'³² dsa³ xi³nu³ 'a²³jia'³ ca³jmée²ra'³ 'i'²³ dsoo'² la²³. 'Ne'² rɨ²cø̱n²³na'³ 'i'²³ dxʉ́²³ la²³ xi³ jo̱³ quie'²³ xa³ dsoo² 'e³ la²³ jmee²³ dsa³ 'i³ 'ǿn²³na'³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","'E³ quie'²³ jo̱³ ca²³jua'³ ca³dxáan² dsa³ juɨɨ³ Jerusalén: ―¿'A² 'a²³la³ dsa³ la³ 'i³ 'née²³te'²³ 'e³ rɨ²³jŋɨ'n²³te'²³? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Xi'n²³ la³ lʉ²³ i²³ñín² la²³nɨ³. 'E³ quie'²³ 'a²³'e³ xa³ sɨ'²³te'²³. ¿'A² juø'² mɨ³dsóo²³ dsɨ́² dsa³ 'i³ ta'n² ta² 'e³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios hua² 'i³ la³? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","'E³ quie'²³ ne³ra² 'e³ jiaa'³¹ xen³ dsa³ la³. Mɨ³rɨ³güén³ Cristo 'i³ rɨ²³xíin²³ Dios, 'a²³'i̱³ xen³ 'i³ rɨ²³ñí² 'e³ jiaa'³¹ xen³. ―La'³ ca²³jua'³ ca³dxáan² dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","'E³ jo̱³ ca²³lʉ́³ quiʉ̱ʉ̱³ Jesús 'e³ la²³ 'ee²³ dsa³ ñʉ'²³ 'ñʉ́² gáan³. Ca²³jua'³: ―Cuiin²³na'³ jné² xú̱n³. Móo³ra'³ 'e³ jiaa'³¹ xen²³na²³. 'E³ quie'²³ 'a²³la³ cua̱a̱n²tu² quián²³ 'e³ güén²³na²³. Lʉ²³ ju²dsoo³¹ 'i³ ca²³xíin²³ jné². 'E³ quie'²³ 'a²³jia'³ cuiin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Jné² hua² cuiin²³na²³. Qui² ca²³áan²³ jí̱i̱n² je² jen³¹. 'I³ 'í³ hua² 'i³ ca²³xíin²³ jné². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","'E³ jo̱³ ca²³la²³'née²³te'²³ 'e³ rɨ²³sø̱'n²te'²³ Jesús. 'E³ quie'²³ 'a²³'i̱³ xen³ 'i³ sø̱'n². Qui² 'a²³jia'³ ca³tɨ́³ jmɨ́ɨ² 'e³ rɨ²³jmóo²te'²³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","'E³ quie'²³ juɨ́ɨn²³ dsa³ 'i³ ca²³táan³ quia̱'² Jesús. Ca²³jua'³te'²³: ―'I³ la³ hua² Cristo, ¿mɨ³naa'³¹? Qui² bi²³ ñúun³ u²³juø'²³ jmee²³ 'e³ jmee²³ lii²³ 'e³ bi²³ gáan³. 'A²³'e³ ma²³ xa³ cɨ² 'e³ 'a²³jia'³ jmee²³ dsa³ la³ 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jmée²³ Cristo mɨ³rɨ³güén³, ¿mɨ³naa'³¹? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ca²³núu³ dsa³ fariseo 'e³ jmii'³¹ cu³lø³¹ ca²³lʉ́³ dsa³ ca²³'én² Jesús. 'E³ jo̱³ ca²³xíin²³ 'láa³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ fariseo 'e³ jua'³ sɨ³xe̱'n³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―Ca³juɨ² ca³ŋɨ́n³ cɨ² 'e³ jen³¹na¹ quia̱'n²³²na¹ 'nee'²³. Jo̱³ tu³ ñe'n³²na²³ je² jen³¹ 'i³ ca²³xíin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Rɨ²'naa'n²³na'³ jné². 'E³ quie'²³ 'a²³jia'³ rɨ²³dxe'n²³na'³ jné². Qui² 'a²³jia'³ rɨ²³lí³ juø'² cu³guiin³²na'³ je² ñe'n³²na²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","'E³ jo̱³ ca²³lʉ́³ quia̱'² uu'n² te'²³ juii² dsa³ Israel. Ca²³jua'³te'²³: ―¿Jiaa'³¹ lǿn³ 'e³ rɨ²³dsø'n² dsa³ nɨ³ je² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³dxe'n²³na² cu²ne²ra²? ¿'A² juø'² lǿn³ 'ñée² 'e³ rɨ²³sɨ²³gua³ jee²³² quiee'³² dsa³ Israel 'i³ nee'n²³² 'uǿ²³ quiee'³² dsa³ Grecia 'e³ jua'³ rɨ²³'ée²³ dsa³ Grecia? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿'Ee² lǿ² jua'³: “Rɨ²'naa'n²³na'³ jné², 'e³ quie'²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³dxe'n²³na'³ jné²”? ¿'Ee² lǿ² jua'³: “'A²³jia'³ rɨ²³lí³ juø'² cu³guín²³na'³ je² ñe'n³²na²³”? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jmɨ́ɨ² 'e³ bee'² cɨ² mɨ²juee'³, la²³ 'áa²³ sɨ³guiin³² dsa³, ca²³naa'n²³ Jesús. Ca²³lʉ́³ quiʉ̱ʉ̱³. Ca²³jua'³: ―Cu²qui̱'³ jné² dsa³ 'i³ dxíin³ dsɨ́² 'e³ la²³ rɨ²³lí³ juø'² rɨ²³'ɨ̱'² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Rɨ²³'iá³ jmɨɨ³ 'e³ rɨ³ji̱'²³ ñʉ'²³ dsɨ́² dsa³ 'i³ sɨ³táan³ quia̱'² jné². Qui² la'³ cu³lø³¹ to̱o̱²³ ji³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","La'³ ca²³jua'³ Jesús. Ca²³'én² Espíritu Gáan³. Qui² Espíritu Gáan³ sɨ³'í³ dsɨ́² dsa³ 'i³ sɨ³táan³ quia̱'² Jesús. 'E³ quie'²³ 'íi² rɨ²³güén³ mɨ³¹güii³ Espíritu Gáan³ ma²ca¹jua'³ la'³. Qui² 'íi² li²³gáan³ 'ñée² 'e³ la²³ rɨ²³jú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ma²ca¹núu³ dsa³ júu² 'e³ ca²³lʉ́³ Jesús, ca²³jua'³ ca³dxáan²: ―Ca²³jua'³ Dios 'e³ rɨ²³xíin²³ jø̱n³ dsa³ 'i³ rɨ²³'ɨ́ɨ²³ júu² quiee'³². 'I³ la³ hua² 'i³ 'í³ ca³quie̱e̱², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","'E³ quie'²³ xen³ jia'³ cɨ'²³ dsa³ 'i³ ca²³jua'³: ―'E̱'n³ quie'²³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios hua² nɨ³. 'E³ quie'²³ xen³ jia'³ cɨ'²³ co̱'³ 'i³ ca²³jua'³: ―'A²³la³ estado Galilea li²³xen³ Cristo, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Qui² lʉ²³ je² to̱o̱²³ ji³ júu² quiee'³² Dios. Jua'³ 'e³ ju̱u̱n²³ David Cristo, 'e³ dsa³ 'i³ xen³ juɨɨ³ Belén, juɨɨ³ je² xen³ David mɨ²jaa²³². ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","'E³ quie'²³ 'a²³la³ co̱o̱³ júu² ca²³lʉ́³ dsa³ ma²ca¹'én¹te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Xen³ ca³dxáan² 'i³ 'née²³ rɨ²³sø̱'n² Jesús. 'E³ quie'²³ 'a²³'i̱³ xen³ 'i³ sø̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","'E³ quie'²³ jo̱³ ca²³guiin³² co̱'³ 'láa³ je² nee'n²³² juii² jmii³ dsa³ quia̱'² dsa³ fariseo. 'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ 'láa³: ―¿'Ee² lǿ² 'a²³jia'³ ca²³tée²ra'³ la³ Jesús? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","'E³ jo̱³ ca²³jua'³ 'láa³: ―'A²³'i̱³ xen³ 'i³ lɨ'³ ca³lʉ́³ la²³ lʉ²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","'E³ jo̱³ ca²³jua'³ dsa³ fariseo. Ca²³sɨ'²³ 'láa³: ―¿'A² mɨ³jmée³ 'e³ mɨ³ca³caa'n³²na'³ 'nee'²³ co̱'³? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿'A² juø'² xen³ dsa³ 'i³ ta'n² ta² 'i³ mɨ³ca³táan³ quia̱'², lǿn³na'³? ¿'A² juø'² lǿn³na'³ 'e³ xen³ dsa³ fariseo 'i³ sɨ³táan³ quia̱'²? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² cuii³ ley te'²³ dsa³ juɨɨ³. 'E³ jo̱³ hua² 'e³ sɨ³táan³te'²³ quia̱'²te'²³. Dios rɨ²³dxá²³ ta² quiee'³²te'²³ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","'E³ quie'²³ jo̱³ ca²³lʉ́³ jø̱n³ uu'n²te'²³ 'i³ xi̱i̱n³ Nicodemo. 'I³ 'í³ hua² 'i³ i²joon³ Jesús 'e³ 'uøø²³ mɨ³xa³ cɨ². Ca²³sɨ'²³ uu'n²: ");
INSERT INTO cnlNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―'A²³jia'³ joo'²³ 'e³ rɨ²dxa²ra² ta² quiee'³² dsa³ 'e³ 'íi² rɨ²nʉʉ²ra² júu² quiee'³², 'e³ 'íi² rɨ²³dsóo²³ dsɨ³ra² 'e³ jmii'³¹ jmee²³. 'A²³jia'³ jua'³ la'³ ley quiee³²ra², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","'E³ jo̱³ ca²³jua'³ uu'n² jo̱o̱²³na²³: ―¿'A² dsa³ Galilea 'nʉ³ co̱'³? Jóo² ji³ 'uǿøn²nu³. Rɨ²máan² xi² to̱o̱²³ ji³ 'e³ jua'³ estado Galilea li²³xen³ dsa³ 'i³ rɨ²³'ɨ́ɨ²³ júu² quiee'³² Dios. ―La'³ ca²³sɨ'²³te'²³ Nicodemo. ");
INSERT INTO cnlNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","'E³ quie'²³ jo̱³ ca²³guiin³² quie'² cɨ'³ la²³ jø̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","'E³ quie'²³ ŋóo² Jesús mo'³ Olivos. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","I²³'áa³ tá³ 'e³ la²³ mɨ³dxóo³ la'³ güe'n² co̱'³ ñʉ'²³ 'ñʉ́² gáan³ je² mi³gáan³ Dios dsa³ Israel. Juɨ́ɨn²³ dsa³ ca²³ŋɨɨ'n²³ caan²³. 'E³ jo̱³ ca²³gua³. Ca²³'ée²³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","'E³ quie'²³ xen³ jø̱n³ mɨ́³ 'i³ i²jøn²³ caan²³ Jesús te'²³ dsa³ 'e²³ ley quia̱'² te'²³ dsa³ fariseo. Qui² ŋó²³ dsa³ 'e³ mɨ³jmée³ ñi³ dxa³ mɨ́³ 'í³. Ca²³xi'n³te'²³ dxoo'³¹ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ca²³jua'³te'²³. Ca²³sɨ'²³te'²³ Jesús: ―Dsa³ 'e²³, mɨ³ŋó²³ dsa³ 'e³ mɨ³jmée³ ñi³ dxa³ mɨ́³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","'Ne'² rɨ²cuø²ra² cú̱u̱² quie'² dsa³ 'i³ jmoo³² la'³, jua'³ ley 'e³ ca²³ŋɨ́n² Moisés, ¿mɨ³naa'³¹? ¿Jmii'³¹ cu³lø³¹ juø'n³ 'nʉ³ jo̱o̱²³na²³? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ca²³jua'³te'²³ la'³. Qui² 'née²³te'²³ rɨ²³jáan²³te'²³ júu² quiee'³² 'e³ jua'³ 'née²³te'²³ rɨ²³cuǿ²³te'²³ dsoo² quiee'³². 'E³ quie'²³ jo̱³ ca²³cu²³'i³¹ Jesús. Ca²³sɨ́ɨ³ 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","'E³ quie'²³ co̱'³ cɨ'²³ ca²³sɨ'²³te'²³ la'³. 'E³ quie'²³ jo̱³ ca²³naa'n²³ 'ñée². Ca²³sɨ'²³ dsa³: ―Cu³cuø²ra'³ cú̱u̱² quie'² xi³nu³ xen³ jø̱n³ 'nee'²³ 'i³ 'a²³'e³ dsoo² xa³ quie'². 'I³ 'í³ hua² 'i³ joo'²³ rɨ²³cuǿ²³ cú̱u̱² xe̱'n². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","'E³ quie'²³ co̱'³ cɨ'²³ ca²³cu²³'i³¹. Ca²³sɨ́ɨ³ 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","'E³ quie'²³ ma²ca¹núu³ dsa³ júu² 'e³ ca²³lʉ́³ Jesús, ca²³jmóo² 'i'²³ miin²³ 'e³ xa³ dsoo² quiee'³²te'²³. 'E³ jo̱³ ca²³'uǿøn²te'²³ cɨ'³ jø̱n³, cɨ'³ jø̱n³. 'I³ mɨ³dxún²³ cɨ² ca²³'uǿøn² xe̱'n². Jø̱n³ Jesús cɨ² ca²³cuaa'n²³ quia̱'² mɨ́³ 'i³ ca²³xi'n³te'²³ caan²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","'E³ quie'²³ jo̱³ ca²³naa'n²³ co̱'³ Jesús. Ca²³sɨ'²³ mɨ́³: ―Mɨ́³, ¿neen³¹ dsa³ 'i³ cuø²³ dsoo² quien³²nu³? ¿'A² 'a²³'i̱³ ma²³ xen³ dsa³ 'i³ jua'³ 'e³ xa³ ca³dsaan³² 'e³ rɨ²³jú̱n³nu³? ");
INSERT INTO cnlNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","'E³ jo̱³ ca²³jua'³ mɨ́³: ―'A²³'i̱³ ma²³ xen³, Juiin²³. 'E³ jo̱³ ca²³jua'³ Jesús: ―'E³ quie'²³ la'³ jné² co̱'³. 'A²³jia'³ juø'n²³ 'e³ xa³ ca³dsaan³² 'e³ rɨ²³jú̱n³nu³. Guø'n³ jo̱o̱²³na²³. 'A²³ ma²³ rɨ³jmeen³ 'e³ xa³ dsoo² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Co̱'³ cɨ'²³ ca²³lʉ́³ Jesús quia̱'² dsa³. Ca²³jua'³: ―La²³ xen³ ji³ 'e³ cuø²³ jmɨ́ɨ²³ rɨ³ca̱'n²³ mɨ³¹güii³ xen²³na²³ jné². 'A²³jia'³ rɨ²³ŋɨ́²³ je² li³'o̱o̱³ dsa³ 'i³ ŋɨ́³ quia̱'² jné². Qui² rɨ²³ŋɨ́²³ je² cuø²³ jmɨ́ɨ²³ ji³ 'e³ jmee²³ 'e³ rɨ³ji̱'²³ dsa³ ca³cuaa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","'E³ jo̱³ ca²³jua'³ dsa³ fariseo. Ca²³sɨ'²³ Jesús: ―'Uǿøn²ma²nu³ rɨ³løn³¹nu³ dsa³ ñi³ 'e³ jmeen³ júu² 'e³ 'i̱i̱² sɨɨ'³¹ 'nʉ³. 'E³ jo̱³ hua² 'a²³jia'³ quí̱i̱n²³ júu² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","'E³ quie'²³ ca²³jua'³ Jesús: ―Quí̱i̱n²³ júu² quián²³, juø'n³ quie'²³ 'ñáan²³ jmeen²³ júu² 'e³ 'i̱i̱² sɨɨ'³¹ jné². Qui² maan²³ 'ñáan²³ 'e³ jiaa'³¹ naan²³na²³. Maan²³ 'ñáan²³ 'e³ jiaa'³¹ ñe'n³²na²³ co̱'³. 'E³ quie'²³ 'nee'²³ 'a²³jia'³ móo³ra'³ 'e³ jiaa'³¹ ca²³áan²³. 'E³ quie'²³ la'³ 'a²³jia'³ móo³ra'³ 'e³ jiaa'³¹ ñe'n³²na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","La²³'nɨɨ'n³¹ 'e³ jné³ hua² joo³²ra'³ 'e³ la²³ juo'³ra'³ 'e³ xa³ dsoo² quiee'³² dsa³. 'E³ quie'²³ jné² 'a²³jia'³ dxen²³ ta² quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","'E³ quie'²³ 'u² cu²ru'³ dxen²³ ta² quiee'³² dsa³, dxen²³ ta² la²³ dxʉ́²³. Qui² 'a²³la³ jø̱n³ jné² 'i³ dxen²³ ta² quiee'³² dsa³ 'u² cu²ru'³ la'³. Jné² quia̱'n²³²na¹ Ñu'n²³ 'i³ ca²³xíin²³ jné² dxa³ra'³¹ ta² ca³ti³² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Co̱'³ cɨ'²³ to̱o̱²³ ley quien³²na'³ 'e³ 'ne'² áan²³ dsa³ ñi³ 'e³ la²³ li²³quí̱i̱n²³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","'Ñáan²³ rɨ³løn³¹na¹ dsa³ ñi³ 'e³ jmeen²³ júu² 'e³ 'i̱i̱² sɨɨ'³¹ jné². 'E³ quie'²³ la'³ Ñu'n²³ 'i³ ca²³xíin²³ jné². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","'E³ quie'²³ jo̱³ ca²³sɨ'²³te'²³: ―¿Neen³¹ Ñu'n² jo̱o̱²³na²³? Ca²³jua'³ 'ñée²: ―'A²³jia'³ cuiin²³na'³ jnee'³¹ xú̱n³, juø'n³ quie'²³ jné², juø'n³ quie'²³ Ñu'n²³. 'U² cu²ru'³ cuiin²³na'³ jné², cuiin²³na'³ Ñu'n²³ co̱'³ 'u² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","La'³ cu³lø³¹ júu² 'e³ ca²³lʉ́³ Jesús 'e³ la²³ ca²³'ée²³ dsa³ je² too'²³te'²³ cuu² ñʉ'²³ 'ñʉ́² gáan³. 'E³ quie'²³ 'a²³'i̱³ xen³ 'i³ sø̱'n² Jesús. Qui² 'a²³jia'³ ca²³tɨ́³ jmɨ́ɨ² 'e³ rɨ²³jmóo²te'²³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Co̱'³ cɨ'²³ ca²³lʉ́³ Jesús. Ca²³jua'³: ―'E³ cɨ² ñe'n³²na²³ quián²³. 'E³ jo̱³ rɨ²'naa'n²³na'³ jné². 'E³ quie'²³ rɨ²³jú̱n³na'³ 'e³ quié̱²quie²³ra'³ dsoo² quien³²na'³. Qui² 'a²³jia'³ rɨ²³lí³ juø'² cu³guiin³²na'³ je² ñe'n³²na²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","'E³ jo̱³ ca²³jua'³ te'²³ juii² dsa³ Israel: ―¿'A² juø'² rɨ²³jŋɨ'n²³ 'ñée²? Qui² 'e³ jua'³: “'A²³jia'³ rɨ²³lí³ juø'² cu³guiin³²na'³ je² ñe'n³²na²³”. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ juii² dsa³ Israel: ―Dsa³ 'i³ xen³ 'e̱'³ hua² 'nee'²³. 'E³ quie'²³ dsa³ 'i³ xen³ yʉʉ'³¹ hua² jné². Mi³quí̱i̱n²³na'³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³. 'E³ quie'²³ 'a²³jia'³ jmeen²³ la'³ 'ñáan²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","'E³ jo̱³ mɨ³juǿøn²na²³ 'nee'²³ 'e³ rɨ²³jú̱n³na'³ 'e³ quié̱²quie²³ra'³ dsoo² quien³²na'³. Qui² la'³ rɨ²³lí³ xi³nu³ 'a²³jia'³ sɨ³táan³na'³ 'e³ jné² hua² 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","'E³ quie'²³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―¿'I̱i̱² sɨɨ'³¹ 'nʉ³ jo̱o̱²³na²³? 'E³ jo̱³ ca²³jua'³ 'ñée²: ―Cɨ'²³ mɨ²xe̱'n³¹ juøøn³²na²³ 'nee'²³ 'e³ 'i̱i̱² sɨɨ'³¹ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'E³ quie'²³ ñúun³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²jmeen²³² júu² 'e³ jmii'³¹ cu³løn³¹na'³. Ñúun³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²lʉn²³² 'e³ rɨ²dxen²³² ta² quien³²na'³. 'E³ quie'²³ jmø'n² 'e³ la²³ ca²³sɨ'²³ jné² 'i³ ca²³xíin²³ jné², 'e³ jo̱³ hua² juøøn³² dsa³ mɨ³¹güii³. Qui² lʉ²³ ju²dsoo³¹ 'ñée². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","'E³ quie'²³ 'a²³jia'³ ta³jmoo³²te'²³ 'i'²³ 'e³ Dios Jmii³ hua² 'en³². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―Mɨ³rɨ³xaa'n²³na'³ jné² Jo̱o̱³¹ Dsa³, jo̱³ hua² rɨ²móo²ra'³ 'e³ jné² hua² 'í³ 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios. Rɨ²móo²ra'³ 'e³ 'a²³'e³ xa³ 'e³ jmeen²³ 'e³ la²³ 'náan²³ 'ñáan²³. 'E³ quie'²³ lʉn²³ 'e³ la²³ ca²³'ée²³ jné² Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Quia̱'² jné² 'ñée² 'i³ ca²³xíin²³ jné². 'A²³jia'³ ca³cuaa'n³ jné² 'e³ jø̱n³na²³ 'ñáan²³. Qui² tén³ jmeen²³ 'e³ la²³ 'née²³ 'ñée². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","'E³ la²³ ca²³lʉ́³ la'³, juɨ́ɨn²³ 'i³ ca²³táan³ quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ Israel 'i³ ca²³táan³ quia̱'²: ―Dsa³ quién²³na²³ 'nee'²³ ca³quie̱e̱² xi³nu³ rɨ²jmée²ra'³ 'e³ la²³ mɨ³juǿøn²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","'E³ jo̱³ rɨ²móo²ra'³ ju²dsoo³¹ quián²³. Júu² la³ hua² rɨ²³láan² 'nee'²³. Rɨ²³lín³na'³ dsa³ 'i³ rɨ³nǿn². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","'E³ quie'²³ ca²³jua'³ miin²³ te'²³ dsa³ 'í³. Ca²³sɨ'²³te'²³ Jesús: ―Ju̱u̱n²³ Abraham hua² jne², ¿mɨ³naa'³¹? 'A²³jia'³ lɨ'³ ca³la³xen³ dsa³ 'i³ rɨ³løn³¹ juii² jne². ¿Jmii'³¹ lǿ² 'e³ mɨ³xi'n²nu³ jnee'³¹ 'e³ rɨ²³lín³na'³¹ dsa³ 'i³ rɨ³nǿn²? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Dsoo² hua² rɨ³løn³¹ juii² la²³jɨn³ dsa³ 'i³ jmoo³² 'e³ xa³ dsoo². La²³ xen³ mozos 'i³ jmoo³² 'e³ la²³ dxi³ 'i'²³ juii² xen³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","'A²³'e³ xa³ ca³dsaan³² quie'² mozos 'e³ rɨ²³cuaa'n²³ tén³ xi²ñʉ'¹ quiee'³² juii². 'E³ quie'²³ xa³ ca³dsaan³² quie'² jo̱o̱³¹ 'ñée² juii² 'e³ rɨ²³cuaa'n²³ quie'²³ tén³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","'E³ jo̱³ hua² xi³nu³ rɨ²³láan² 'nee'²³ Jo̱o̱³¹, rɨ²³láan³na'³ ca³quie̱e̱². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Maan²³ 'e³ rɨ³løn³¹na'³ ju̱u̱n²³ Abraham xú̱n³. 'E³ quie'²³ juø'n³ quie'²³ la'³, 'noo³ra'³ 'e³ rɨ²jŋɨ'n²³na'³ jné². Qui² 'a²³jia'³ rɨ²³'í³ 'óo²ra'³ júu² quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Jné² juøøn³²na²³ 'nee'²³ 'e³ jmii'³¹ lǿ² 'e³ ca²³maan²³ ma²jen³¹na¹ quia̱'n²³²na¹ Ñu'n²³. 'E³ quie'²³ jmee³ra'³ 'e³ la²³ sɨ'²³ 'nee'²³ ñʉ'²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Abraham hua² 'i³ rɨ³løn³¹ ñʉ'²ra'³¹ xú̱n³. 'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―'U² cu²ru'³ ju̱u̱n²³ Abraham 'nee'²³, jmee³ra'³ 'e³ la²³ ca²³jmée³ 'ñée² Abraham cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","'E³ quie'²³ 'noo³ra'³ 'e³ rɨ²jŋɨ'n²³na'³ jné² dsoo² 'e³ mɨ³juǿøn²na²³ 'nee'²³ ju²dsoo³¹ 'e³ ca²³sɨ'²³ jné² Dios. ¡'A²³la³ la'³ ca²³jmée³ Abraham mɨ²jo̱³! ");
INSERT INTO cnlNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","'E³ quie'²³ jmee³ra'³ ta² quiee'³² ñʉ'²ra'³ ―ca²³jua'³ Jesús. 'E³ quie'²³ ca²³jua'³te'²³: ―'A²³la³ dsa³ i²³ŋɨ́² jnee'³¹ xú̱n³. Jø̱n³ hua² ñʉ'²ra'³¹ xen³. Dios hua² 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","'E³ jo̱³ ca²³jua'³ Jesús: ―'U² cu²ru'³ Dios rɨ³løn³¹ ñʉ'²ra'³, 'náan²³na'³ jné² 'u² cu²ru'³ la'³. Qui² ca²³bǿn³na²³, ca²³áan²³ jí̱i̱n² je² jen³¹ Dios. 'A²³la³ 'e³ la²³ 'náan²³ 'ñáan²³ 'e³ güén²³na²³. Qui² Dios ca²³xíin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿'Ee² lǿ² 'e³ 'a²³jia'³ nuu³ra'³ júu² quián²³? 'A²³jia'³ nuu³ra'³. Qui² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²núu²ra'³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Qui² mɨ²³sɨ²³quiʉ'² rɨ³løn³¹ ñʉ'²ra'³. 'E³ jo̱³ 'noo³ra'³ 'e³ rɨ²jmée²ra'³ 'e³ la²³ 'née²³ 'ñée². Cɨ'²³ mɨ²xe̱'n³¹ jŋɨ'n²³ dsa³ mɨ²³sɨ²³quiʉ'². 'A²³jia'³ ta³dsɨ³² quia̱'² ju²dsoo³¹. Cu³xi³ 'e³ 'a²³jia'³ 'iʉ² dsɨ́² ju²dsoo³¹. Qui² lǿn²³ quie'²³ 'e³ lʉ²³ u²³sɨ²³júu². To̱'²³ juu³². Rɨ³løn³¹ juii² u²³sɨ²³júu² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² sɨ³táan³na'³ júu² quián²³. Qui² jné² lʉn²³ ju²dsoo³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Cu³xi³ jø̱n³na'³ 'a²³'e³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ 'e³ rɨ²cuǿ²ra'³ dsoo² quián²³. Qui² 'a²³'e³ xa³ sú̱n². ¿'Ee² lǿ² 'a²³jia'³ sɨ³táan³na'³ júu² quián²³ jo̱o̱²³na²³? Qui² lʉn²³ ju²dsoo³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nuu³ júu² quiee'³² Dios dsa³ 'i³ rɨ³løn³¹ jo̱o̱³¹ Dios. 'E³ quie'²³ 'a²³jia'³ nuu³ra'³ júu² quiee'³² Dios. Qui² 'a²³la³ 'í³ jo̱o̱³¹ Dios 'nee'²³. ―La'³ cu³lø³¹ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","'E³ quie'²³ jo̱³ ca²³jua'³ te'²³ juii² dsa³ Israel. Ca²³sɨ'²³ Jesús: ―Ju²dsoo³¹ lʉ²ra'³¹ 'e³ juaa'³ra'³¹ 'e³ dsa³ Samaria hua² 'nʉ³, ¿mɨ³naa'³¹?, 'e³ quie̱n²³²nu³ espíritu quien³² mɨ²³sɨ²³quiʉ'². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","'E³ jo̱³ ca²³jua'³ Jesús: ―'A²³jia'³ jmɨ́ɨ² quie̱n²³²na¹ espíritu quien³² mɨ²³sɨ²³quiʉ'². Qui² mi³gáan²na²³ Ñu'n²³. 'E³ quie'²³ 'nee'²³ maa'n²³² lii'n²³²na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'A²³jia'³ jø̱n²³ 'e³ rɨ²³mi²³gáan³ dsa³ jné². 'E³ quie'²³ xen³ 'i³ 'née²³ 'e³ rɨ²³mi²³gáan³te'²³ jné². 'I³ 'í³ hua² 'i³ rɨ²³dxá²³ ta² quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³jia'³ jmɨ́ɨ² rɨ²³jú̱n³ dsa³ 'i³ jmee²³ 'e³ la²³ lǿ² júu² quián²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","'E³ quie'²³ jo̱³ ca²³jua'³ te'²³ juii² dsa³ Israel. Ca²³sɨ'²³te'²³ Jesús: ―'E³ jo̱³ hua² 'e³ ne³ra'³¹ 'e³ quie̱n²³²nu³ espíritu quien³² mɨ²³sɨ²³quiʉ'². Qui² jú̱n²³ Abraham. 'E³ quie'²³ la'³ te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². 'E³ quie'²³ juø'n³ 'nʉ³ 'e³ 'a²³jia'³ jmɨ́ɨ² rɨ²³jú̱n³ dsa³ 'i³ jmee²³ 'e³ la²³ lǿ² júu² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿'A² juø'² gáan³ cɨ² 'nʉ³ la²³ cɨ'²³ Abraham yi²³uu'²ra² jaa²³²? Jú̱n²³ 'ñée² xú̱n³. Jú̱n²³ te'²³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². ¿'I̱i̱² sɨɨ'³¹ 'nʉ³, lǿn³nu³? ―La'³ ca²³sɨ'²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","'E³ quie'²³ ca²³jua'³ Jesús: ―'U² cu²ru'³ mi³gáan²na²³ 'ñáan²³, 'a²³jia'³ quí̱i̱n²³ júu² 'e³ lʉn²³ 'u² cu²ru'³ la'³. 'E³ quie'²³ Ñu'n²³ hua² 'i³ mi³gáan³ jné². 'I³ 'í³ hua² 'i³ juo'³ra'³ 'e³ rɨ³løn³¹ juii² 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","'E³ quie'²³ 'a²³jia'³ cuiin²³na'³ Dios. Jné² hua² cuiin²³na²³. 'U² cu²ru'³ juø'n²³ 'e³ 'a²³jia'³ cuiin²³na²³ Dios, te³ juun²³² 'e³ la²³ júu²ra'³ 'nee'²³ 'u² cu²ru'³ la'³. 'E³ quie'²³ cuiin²³na²³ Dios xú̱n³. Jmeen²³ 'e³ la²³ lǿ² júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bi²³ ca²³la²³'née²³ Abraham yi²³uu'²ra² jaa²³² 'e³ rɨ²³jóo² 'e³ jmii'³¹ rɨ²³güén³na²³ mɨ³¹güii³. 'E³ quie'²³ ca²³jóo² 'e³ la²³ ca²³áan²³. 'E³ jo̱³ bi²³ ca²³la²³jɨn³ dsɨ́². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","'E³ jo̱³ ca²³jua'³ te'²³ juii² dsa³ Israel: ―'A²³jia'³ ca³tɨ́³ tú̱²³ lu²³guiá³ ji̱i̱'n²³nu³. ¿Jmii'³¹ lǿ² 'e³ juø'n³ cuiin²³nu³ Abraham? ");
INSERT INTO cnlNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'Íi² li²³xen³ Abraham 'e³ xen²³na²³ ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","'E³ jo̱³ so̱'²³te'²³ cú̱u̱² 'e³ jua'³ rɨ²³cuǿ²³te'²³ quie'². 'E³ quie'²³ ca²³'mǿn²³ Jesús. Ca²³bǿn³ ñʉ'²³ 'ñʉ́² gáan³. Ca²³ŋɨ́n³ jee²³² quiee'³²te'²³. 'E³ jo̱³ ca²³bǿn³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","'E³ la²³ 'iún² jui³¹ Jesús, ŋǿn² jø̱n³ dsa³ tuu². 'E³ lǿn²³ quie'²³ ca²³la²³xen³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","'E³ jo̱³ ca²³jua'³ dsa³ quien³². Ca²³sɨ'²³te'²³ Jesús: ―Dsa³ 'e²³, ¿'ee² lǿ² tuu² mɨ²ñi² dsa³ la³ cu²ne²ra²? ¿'A² juø'² 'e³ xa³ dsoo² quiee'³² 'ñée²? ¿'A² juø'² dsoo² quiee'³² xóo² jmii³ 'e³ lǿn²³ la²³nɨ³ 'e³ ca²³la²³xen³? ―La'³ ca²³sɨ'²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―'A²³la³ jo̱³ 'e³ mɨ³jmée³ dsa³ la³ 'e³ xa³ dsoo² quiee'³² 'e³ tuu² mɨ²ñi² 'e³ ca²³la²³xen³. 'E³ quie'²³ 'a²³la³ 'e³ mɨ³jmée³ xóo² jmii³ 'e³ xa³ dsoo² quiee'³²te'²³. 'E³ quie'²³ 'née²³ Dios 'e³ rɨ²³jmée²³ co̱²juø'¹ quie'² 'e³ la²³ li²³lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'uee'n³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","'Ne'² rɨ²jmeen²³² ta² quiee'³² 'ñée² 'i³ ca²³xíin²³ jné² la²³ cɨ² jné³. Qui² 'a²³jia'³ ma²³ huǿø³ 'e³ rɨ²³nʉʉ³. Qui² mɨ³rɨ³nʉʉ³, 'a²³'i̱³ xen³ 'i³ rɨ²³lí³ juø'² rɨ²³jmée²³ ta². ");
INSERT INTO cnlNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","La²³ xen³ ji³ 'e³ cuø²³ jmɨ́ɨ²³ rɨ³ca̱'n²³ mɨ³¹güii³ xen²³na²³ jné² la²³huøø'n³¹ la²³ jen³¹na¹ mɨ³¹güii³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ma²mɨ³líi² mɨ³jua'³ la'³ Jesús, ca²³'ø'² 'uǿ²³. Ca²³jmée³ ñʉʉ³ quia̱'² jmɨ²³'e'². Ca²³jñʉ́ʉ²³ ñʉʉ³ mɨ²ñi² dsa³ tuu². ");
INSERT INTO cnlNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","'E³ quie'²³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ 'í³: ―Cu³u̱'² mɨ²ñín² too³ bee'² je² 'o² jmɨɨ³ je² xi̱i̱n³ Siloé ―ca²³jua'³. Siloé jua'³te'²³ dsa³ 'i³ mɨ³xíin²³te'²³ ju²³jmii²³² quiee'³²te'²³. 'E³ quie'²³ jo̱³ ŋóo² dsa³ tuu². Ca²³u̱'² mɨ²ñi² 'e̱'³ too³. Mɨ³la³jné³ mɨ²ñi² 'e³ la²³ ja'n² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","'E³ jo̱³ ca²³jua'³ te'²³ dsa³ 'i³ nee'n²³² ji̱i̱'² coo³¹ quie'² dsa³ 'í³ quia̱'² te'²³ dsa³ 'i³ ca²³la²³cuii²³ quie'² ma²ca¹guó³ ca²³ŋɨ́ɨ³ cuu²: ―¿'A² juø'² 'a²³la³ 'í³ dsa³ la³ 'i³ ca²³guó³ ca²³ŋɨ́ɨ³ cuu² mɨ²jo̱³? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ca²³jua'³ ca³dxáan²: ―'I³ 'í³ hua² nɨ³. 'E³ quie'²³ xen³ cɨ² 'i³ ca²³jua'³: ―'A²³la³ 'í³. 'E³ quie'²³ la²³nɨ³ cu³løn³¹ dsa³ 'í³. 'E³ quie'²³ ca²³jua'³ 'ñée² dsa³ 'i³ tuu² mɨ²ñi² xe̱'n²: ―'I³ 'í³ jné² xú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","'E³ quie'²³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ dsa³ 'í³: ―¿Jmii'³¹ lǿ² 'e³ mɨ³la³jnen³²nu³ jo̱o̱²³na²³? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","'E³ jo̱³ ca²³jua'³ 'ñée²: ―Ñʉʉ³ mɨ³jmée³ jø̱n³ dsa³ 'i³ xi̱i̱n³ Jesús. Mɨ³jñʉ́ʉ²³ mɨ²ñin²³. Mɨ³sɨ'²³ jné²: “Guo³ too³ bee'² je² 'o² jmɨɨ³ je² xi̱i̱n³ Siloé. Cu³u̱'² mɨ²ñín²”, mɨ³sɨ'²³ jné². 'E³ quie'²³ jo̱³ mɨ³ñiin²³²na¹ mɨ³i²u̱'n¹ mɨ²ñin²³. Mɨ³la³jnéen²³ jo̱o̱²³na²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","'E³ jo̱³ ca²³jua'³te'²³: ―¿Neen³¹ dsa³ 'í³? ―ca²³sɨ'²³te'²³. 'E³ quie'²³ ca²³jua'³ 'ñée²: ―'A²³jia'³ maan²³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","'E³ quie'²³ jo̱³ i²jøn²³te'²³ caan²³ dsa³ fariseo dsa³ 'i³ tuu² mɨ²ñi² xe̱'n². ");
INSERT INTO cnlNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Qui² jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ ma²ca¹jmée³ ñʉʉ³ Jesús, ca²³jmée³ 'e³ ca²³nó³ mɨ²ñi² dsa³ tuu². ");
INSERT INTO cnlNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ca²³ŋɨ́ɨ³ júu² dsa³ fariseo co̱'³ 'e³ jmii'³¹ lǿ² 'e³ ca²³la²³jnée²³ dsa³ tuu². 'E³ jo̱³ ca²³jua'³ dsa³ 'i³ tuu² mɨ²ñi² xe̱'n²: ―Ñʉʉ³ mɨ³jñʉ́ʉ²³ mɨ²ñin²³. Mɨ³u̱'n²³ mɨ²ñin²³. Mɨ³la³jnéen²³ jo̱o̱²³na²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","'E³ jo̱³ ca²³jua'³ ca³dxáan² dsa³ fariseo ca²³'én² Jesús: ―'A²³jia'³ jmɨ́ɨ² 'í³ Dios 'i³ ca²³xíin²³ dsa³ 'i³ jmee²³ la²³nɨ³. Qui² jmee²³ ta² 'e³ 'a²³jia'³ joo'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³ ―ca²³jua'³te'²³. 'E³ quie'²³ xen³ cɨ² 'i³ ca²³jua'³: ―¿Jmii'³¹ rɨ²³lí³ juø'² rɨ²³jmée²³ u²³juø'²³ 'e³ lø³² la²³nɨ³ jø̱n³ dsa³ mɨ³¹güii³ 'i³ xa³ dsoo² quiee'³²? ―ca²³jua'³te'²³. 'E³ jo̱³ 'a²³jia'³ ma²³ ca²³lʉ́³te'²³ co̱o̱³ júu². ");
INSERT INTO cnlNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","'E³ quie'²³ jo̱³ co̱'³ cɨ'²³ ca²³sɨ'²³te'²³ dsa³ 'i³ tuu² mɨ²ñi² xe̱'n². Ca²³jua'³te'²³: ―¿Jmii'³¹ juø'n³ 'nʉ³ jo̱o̱²³na²³? ¿'I̱i̱² sɨɨ'³¹ dsa³ 'i³ mɨ³jmée³ 'e³ mɨ³nó³ mɨ²ñín²? 'E³ jo̱³ ca²³jua'³ dsa³ 'í³: ―Dsa³ 'i³ 'ɨɨ³ júu² quiee'³² Dios hua² 'í³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","'E³ quie'²³ 'a²³jia'³ sɨ³táan³ te'²³ juii² dsa³ Israel 'e³ 'e̱'n³ 'e³ tuu² mɨ²ñi² xe̱'n², 'e³ cɨ² ca²³la²³jnée²³. 'E³ jo̱³ ca²³jén²³te'²³ xóo² jmii³ dsa³ 'i³ ca²³la²³jnée²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ca²³sɨ'²³te'²³ xóo² jmii³: ―¿'A² jo̱o̱³ra'³ 'i³ la³? ¿'A² 'e̱'n³ quie'²³ tuu² mɨ²ñi² 'e³ ca²³la²³xen³? ¿Jmii'³¹ lǿ² 'e³ jnée²³ rɨ³nɨ²³? ―ca²³sɨ'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","'E³ jo̱³ ca²³jua'³ xóo² jmii³: ―Ne³ra'³¹ 'e³ jo̱o̱³ra'³¹ 'i³ la³. Ne³ra'³¹ 'e³ tuu² mɨ²ñi² 'e³ ca²³la²³xen³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","'E³ quie'²³ 'a²³jia'³ jmɨ́ɨ² ne³ra'³¹ 'e³ jmii'³¹ lǿ² 'e³ jnée²³ rɨ³nɨ²³. 'A²³jia'³ ne³ra'³¹ 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ mɨ³jmée³ 'e³ mɨ³nó³ mɨ²ñi². Xii'²ra'³ 'ñée² jmii'³¹ lǿ² 'e³ mɨ³la³jnée²³. Qui² mɨ³'ien³ dsa³. Rɨ²³jmée²³ júu² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","La'³ ca²³jua'³ xóo² jmii³. Qui² 'ñaa'n²³te'²³ juii² dsa³ Israel. Qui² ca²³mi²³'ien³ júu² te'²³ juii² dsa³ Israel 'e³ 'a²³jia'³ ma²³ rɨ²³cuǿ²³te'²³ júu² 'e³ rɨ²³'í³ la²³jɨ³ 'ñʉ́² je² mi³gáan³te'²³ Dios la²³jɨn³ dsa³ 'i³ rɨ²³jua'³ 'e³ Jesús rɨ³løn³¹ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","'E³ jo̱³ hua² 'e³ ca²³jua'³ xóo² jmii³: “Mɨ³'ien³ dsa³. Xii'²ra'³ 'ñée².” ");
INSERT INTO cnlNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","'E³ quie'²³ jo̱³ co̱'³ cɨ'²³ ca²³jén²³te'²³ dsa³ 'i³ tuu² mɨ²ñi² xe̱'n². Ca²³sɨ'²³te'²³: ―Rɨ²mi³gáan²nu³ Dios. 'A²³ rɨ³mi³gáan²nu³ dsa³ 'i³ 'ǿn²³nu³ nɨ³. Qui² ne³ra'³¹ 'e³ dsa³ mɨ³¹güii³ 'i³ xa³ dsoo² quiee'³² hua² 'í³ ―ca²³sɨ'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","'E³ quie'²³ ca²³jua'³ dsa³ 'i³ ca²³nó³ mɨ²ñi²: ―'A²³jia'³ jmɨ́ɨ² maan²³ xi² xa³ dsoo² quiee'³², ¿mɨ³naa'³¹? 'E³ quie'²³ maan²³ 'e³ tuu² mɨ²ñin²³ xe̱'n², 'e³ quie'²³ jnéen²³ rɨ³nɨ²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","'E³ quie'²³ jo̱³ ca²³jua'³te'²³ co̱'³ cɨ'²³: ―¿Jmii'³¹ mɨ³jme'²³ 'nʉ³ dsa³ 'í³? ¿Jmii'³¹ mɨ³jmée³ 'e³ mɨ³nó³ mɨ²ñín²? ");
INSERT INTO cnlNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","'E³ jo̱³ ca²³jua'³ dsa³ 'í³. Ca²³sɨ'²³ dsa³: ―'Mɨ́ɨ³ juøøn³²na²³ 'nee'²³, ¿mɨ³naa'³¹? 'E³ quie'²³ 'a²³jia'³ ta³nuu³ra'³. ¿'Ee² lǿ² 'noo³ra'³ rɨ²núu²ra'³ co̱'³ cɨ'²³? ¿'A² juø'² 'noo³ra'³ 'e³ rɨ²³lín³na'³ dsa³ quien³²? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","'E³ quie'²³ jo̱³ bi²³ 'ñe'² ca²³sɨ'²³te'²³ ca²³jua'³te'²³: ―'Uǿøn²nu³ mɨ³lǿn²³nu³ dsa³ quien³². 'E³ quie'²³ dsa³ quien³² Moisés hua² jnee'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Qui² ne³ra'³¹ 'e³ ca²³lʉ́³ Dios quia̱'² Moisés. 'E³ quie'²³ 'a²³jia'³ ne³ra'³¹ sú̱n² la²³ 'e³ jiaa'³¹ xen³ dsa³ 'i³ 'ǿn²³nu³ nɨ³ ―ca²³sɨ'²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Bi²³ ca²³mi²³juø'²³ 'ñée² dsa³ 'í³. Ca²³jua'³: ―¿'Ee² la²³ cɨ² 'noo³¹ sɨ³lí³ rɨ³nɨ²³ cu²ne²ra²? Xen³ dsa³ 'i³ mɨ³jmée³ 'e³ mɨ³nó³ mɨ²ñin²³. 'E³ quie'²³ 'a²³jia'³ móo³ra'³ 'e³ jiaa'³¹ xen³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ne³ra² 'e³ 'a²³jia'³ nuu³ Dios júu² 'e³ lʉ²³ dsa³ mɨ³¹güii³ 'i³ xa³ dsoo² quiee'³², ¿mɨ³naa'³¹? 'E³ quie'²³ nuu³ Dios júu² 'e³ lʉ²³ dsa³ 'i³ mi³gáan³ Dios, 'i³ jmee²³ 'e³ la²³ 'née²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Cɨ'²³ la²³ ca²³lǿ²³ mɨ³¹güii³, 'a²³jia'³ lɨ'³ ca³nʉʉ²ra² 'e³ xen³ 'i³ ca²³jmée³ 'e³ ca²³nó³ mɨ²ñi² dsa³ 'i³ tuu² mɨ²ñi² ca²³la²³xen³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","'A²³'e³ xa³ 'e³ mɨ³lǿ²³ juø'² mɨ³jmée³ dsa³ 'í³ 'u² cu²ru'³ 'a²³la³ 'í³ Dios ca²³xíi²³ quie'². ―La'³ ca²³jua'³ 'ñée² dsa³ 'i³ ca²³nó³ mɨ²ñi². ");
INSERT INTO cnlNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","'E³ jo̱³ ca²³jua'³te'²³: ―Ca³quie̱e̱² dsa³ 'i³ xa³ dsoo² quiee'³² hua² 'nʉ³. ¿'A² juø'² lǿn³nu³ 'e³ rɨ²'een³¹nu³ jnee'³¹? ―ca²³jua'³te'²³. 'E³ quie'²³ jo̱³ ca²³dxin³te'²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ca²³núu³ Jesús 'e³ ca²³dxin³te'²³ dsa³ 'i³ tuu² mɨ²ñi² xe̱'n². 'E³ jo̱³ ca²³mi²³jí̱i̱n³ dsa³ 'í³. Ca²³jua'³: ―¿'A² sɨ³táan³nu³ quia̱'n²nu³ Jo̱o̱³¹ Dios? ");
INSERT INTO cnlNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","'E³ jo̱³ ca²³jua'³ dsa³ 'í³: ―¿'I̱i̱² sɨɨ'³¹ 'í³? Qui² 'náan²³ 'e³ rɨ²³sɨ²³táan³na²³ quia̱'n²³²na¹ 'u² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ca²³jua'³ Jesús: ―Ma² mɨ³ñin²³nu³ Jo̱o̱³¹ Dios xú̱n³. 'I³ 'í³ hua² jné² 'i³ lʉn²³ quia̱'n²³²na¹ 'nʉ³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","'E³ jo̱³ ca²³jua'³ dsa³ 'í³: ―Sɨ³táan³na²³, Juiin²³. 'E³ quie'²³ jo̱³ ca²³mi²³gáan³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ca²³jua'³ Jesús: ―Güén²³na²³ mɨ³¹güii³ 'e³ juø'n²³ 'náan²³ 'e³ rɨ²mi³jnéen²³ dsoo² quiee'³² dsa³. Qui² 'náan²³ 'e³ rɨ²³lí³ juø'² 'e³ rɨ²³jmóo² 'i'²³ dxʉ́²³ dsɨ́² dsa³ 'i³ mɨ³la³quii²³ 'e³ 'a²³jia'³ jmee²³ 'e³ dxʉ́²³. Li²³xen³te'²³ la²³ xen³ dsa³ 'i³ mɨ³nó³ mɨ²ñi². 'E³ quie'²³ la'³, 'náan²³ 'e³ bi²³ cɨ² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³jmée²³ 'i'²³ dxʉ́²³ dsɨ́² dsa³ 'i³ te³ lǿn³ 'ñée² 'e³ bi²³ dxʉ́²³ jmee²³. Li²³xen³te'²³ la²³ xen³ dsa³ 'i³ tuu² mɨ²ñi². ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Xen³ dsa³ fariseo 'i³ té̱e̱n³ mɨ³lén². Ca²³núu³te'²³ 'e³ jmii'³¹ ca²³jua'³. 'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―¿'A² tuu² mɨ²ñí²ra'³¹ jnee'³¹, lǿn³nu³? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","'E³ jo̱³ ca²³jua'³ Jesús: ―'A²³jia'³ tuu² mɨ²ñí²ra'³ ca³quie̱e̱². 'E³ quie'²³ jmee²³ ca³juɨ² 'i'²³ 'óo²ra'³. 'E³ jo̱³ hua² xa³ dsoo² quien³²na'³. 'A²³'e³ dsoo² xa³ quién²na'³ 'u² cu²ru'³ sú̱n² quie'²³ 'a²³jia'³ dsoo²³ 'óo²ra'³. 'E³ quie'²³ juo'³ra'³ 'e³ bi²³ jné³ mɨ²ñí²ra'³. 'E³ jo̱³ hua² 'e³ quié̱²quie²³ra'³ dsoo² quien³²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Co̱'³ cɨ'²³ ca²³jua'³ Jesús: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Dxi³ji̱i̱n³¹ 'e³ 'oo'² 'iá³ hua² rɨ²³'í³ dsa³ 'i³ 'née²³ rɨ²³'í³ je² ta'n² dsɨɨ³ joo³. Dsa³ 'i³ 'a²³jia'³ 'née²³ rɨ²³'í³ 'oo'² 'iá³, 'e³ quie'²³ 'née²³ rɨ²³dsɨ́n³ dxi² 'iá³, dsa³ 'i̱i̱³ hua² 'i³ jmee²³ la'³, dsa³ 'i³ 'i̱i̱²³ 'e³ xa³ quie'² jia'³ cɨ'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","'E³ quie'²³ dsa³ 'i³ sɨ³'í³ 'oo'² 'iá³, juii² dsɨɨ³ joo³ hua² 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","'E³ jo̱³ ne³² 'oo'² dsa³ 'i³ 'aa³ 'oo'² mɨ³rɨ³güe'n²³ 'ñée² juii² dsɨɨ³ joo³. 'E³ quie'²³ ta³nʉ́ʉ²³ dsɨɨ³ joo³ juoo'² juii². Qui² 'en³² 'e³ la²³ xi̱i̱n³ cɨ'³ la²³ jø̱n³ dsɨɨ³ joo³ 'e³ la²³ tø³². Cuø²³ jui³¹ quiee'³² dsɨɨ³ joo³ mɨ³rɨ³'uøøn³². ");
INSERT INTO cnlNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mɨ³rɨ³lii³² mɨ³'uøøn³ la²³jɨn³ dsɨɨ³ joo³ quien³², jo̱³ sɨ³'í³ jui³¹ jén²³ 'ñée². 'E³ jo̱³ qui̱i̱³ dsɨɨ³ joo³ quien³². Qui² ta³nʉ́ʉ²³te'²³ juoo'² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","'E³ quie'²³ 'a²³jia'³ rɨ²³qui̱i̱³te'²³ dsa³ 'i³ 'a²³jia'³ cuiin²³te'²³. Rɨ²³cui̱'²³te'²³ dsa³ 'í³. Qui² 'a²³jia'³ ta³nʉ́ʉ²³te'²³ juoo'². ");
INSERT INTO cnlNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","La'³ cu³lø³¹ júu² rɨ³jnɨ³ 'e³ ca²³lʉ́³ Jesús 'e³ la²³ ca²³lʉ́³ quia̱'² dsa³. 'E³ quie'²³ 'a²³jia'³ ta³jmoo³²te'²³ 'i'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","'E³ jo̱³ ca²³lʉ́³ co̱'³ Jesús. Ca²³sɨ'²³ dsa³: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: La²³ xen³ 'oo'² 'iá³ je² sɨ³ta'n²³ dsɨɨ³ joo³ xen²³na²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","La²³jɨn³ 'i³ i²³guín²³ jén²³ cɨ² la²³ jné², dsa³ 'i̱i̱³ hua² 'í³. 'Née²³ 'e³ rɨ²³'í̱i̱²³te'²³ 'e³ xa³ quie'² jia'³ cɨ'²³. 'E³ quie'²³ 'a²³jia'³ ca²³núu³ dsɨɨ³ joo³ juoo'²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","La²³ xen³ 'oo'² 'iá³ xen²³na²³ jné². 'E³ quie'²³ rɨ²³láan³ dsa³ 'i³ rɨ²³ta'n²³ 'oo'² 'iá³ je² mi³quin²³. Li²³'uee'n³ dsɨ́² la²³ sɨ³li³'uee'n³ dsɨɨ³ joo³ mɨ³rɨ³ee'³² nuu³ 'e³ la²³ sɨ³bǿn³ ŋɨ́³ i²³la³ i²³nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Guøn³ dsa³ 'i̱i̱³ 'e³ jua'³ 'née²³ 'e³ rɨ²³jmée²³ 'i̱i̱³, 'e³ jua'³ 'née²³ rɨ²³jŋɨ'n²³ dsɨɨ³ joo³, 'e³ jua'³ 'née²³ rɨ²³mi²³gua'²³ dsɨɨ³ joo³. 'E³ quie'²³ güén²³na²³ 'ñáan²³ 'e³ juø'n²³ rɨ²jmeen²³² 'e³ rɨ³ji̱'²³ dsɨɨ³ joo³, 'e³ la²³ rɨ²³ji̱i̱'²³te'²³ ca³quie̱e̱². ");
INSERT INTO cnlNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Juii² 'i³ bi²³ dxʉ́²³ mi³quin³ dsɨɨ³ joo³ hua² jné². 'E³ quie'²³ dxʉ́²³ dsɨn²³ jné² juii² dsɨɨ³ joo³ 'e³ rɨ²³jú̱n³na²³ 'e³ 'iin³¹ dsɨɨ³ joo³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","'E³ quie'²³ 'a²³jia'³ jmee²³ la'³ mozo 'i³ mi³quin³ dsɨɨ³ joo³ 'e³ jua'³ xa³ jñiin²³, 'i³ 'a²³la³ 'í³ juii² ca³quie̱e̱². Qui² 'a²³la³ 'í³ dsɨɨ³ joo³ quien³². 'E³ quie'²³ tʉn³² dsɨɨ³ joo³ mɨ³rɨ³ñí³ 'e³ mɨ³ ja³'ɨ́ɨn²³ 'ioo'³. Cui̱i̱²³ mozo. 'E³ quie'²³ jo̱³ sø̱'n³² dsɨɨ³ joo³ 'ioo'³. Jmee²³ 'e³ sɨ³sáan²³ sɨ³jǿn²³ dsɨɨ³ joo³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cui̱i̱²³ mozo. Qui² te³ xa³ jñiin²³. 'A²³'e³ cua̱a̱n²tu² quie'² 'ñée² 'e³ jmii'³¹ sɨ³ji̱'²³ dsɨɨ³ joo³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Juii² 'i³ bi²³ dxʉ́²³ mi³quin³ dsɨɨ³ joo³ hua² jné². 'E³ jo̱³ cuiin²³na²³ dsɨɨ³ joo³ quién²³na²³. 'E³ quie'²³ la'³, cuiin²³ jné² miin²³ dsɨɨ³ joo³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Cuiin²³ jné² Ñu'n²³. 'E³ quie'²³ la'³, cuiin²³na²³ Ñu'n²³ co̱'³. Dxʉ́²³ dsɨn²³ 'e³ rɨ²³jú̱n³na²³ 'e³ 'iin³¹ dsa³ quién²³na²³ la²³ sɨ³jú̱n³ juii² dsɨɨ³ joo³ 'e³ 'iin³¹ dsɨɨ³ joo³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Xen³ cɨ² dsɨɨ³ joo³ quién²³na²³. 'E³ quie'²³ 'a²³la³ 'iá³ la³ je² ta'n²te'²³. 'E³ quie'²³ 'ne'² 'e³ rɨ²tøøn³¹na¹ dsɨɨ³ joo³ 'í³ co̱'³. 'E³ jo̱³ rɨ²³núu²³te'²³ júu² quián²³. 'E³ jo̱³ rɨ²³lín³ co̱o̱³ ta'n² dsɨɨ³ joo³ quién²³na²³. Rɨ²³lín³na²³ jø̱n³ jné² juii²te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Dxʉ́²³ dsɨn²³ 'e³ rɨ²³jú̱n³na²³. 'E³ quie'²³ rɨ²³ji̱i̱'n²³na²³ co̱'³. 'E³ jo̱³ hua² 'e³ 'néen² jné² Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","'A²³'i̱³ xen³ 'i³ rɨ²³lí³ juø'² rɨ²³jŋɨ'n²³ jné² 'u² cu²ru'³ 'a²³la³ jo̱³ 'e³ dxʉ́²³ dsɨn²³ 'ñáan²³ hua² 'e³ rɨ²³jú̱n³na²³. 'E³ quie'²³ 'e³ dxʉ́²³ dsɨn²³ 'ñáan²³ hua² 'e³ rɨ²³jú̱n³na²³. Qui² xa³ ca³dsaan³² quián²³ 'e³ rɨ²³jú̱n³na²³. Xa³ ca³dsaan³² quián²³ 'e³ rɨ²³ji̱i̱'n²³na²³ co̱'³. Qui² la'³ cu³lø³¹ ca²³dxi³ 'i'²³ Ñu'n²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","'E³ quie'²³ co̱'³ cɨ'²³ ca²³lǿ²³ 'e³ 'a²³jia'³ ma²³ lʉ²³ co̱o̱³ júu² te'²³ juii² dsa³ Israel ma²ca¹núu³te'²³ júu² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Juɨ́ɨn²³ 'i³ ca²³jua'³: ―Quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'², ¿mɨ³naa'³¹? Bi²³ mɨ³ŋøn³ mɨ²dxi². ¿'Ee² lǿ² nuu³ra'³ júu² quiee'³²? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","'E³ quie'²³ xen³ cɨ² 'i³ ca²³jua'³: ―'A²³jia'³ lʉ²³ la²³nɨ³ dsa³ 'i³ quie̱n³ espíritu quien³² mɨ²³sɨ²³quiʉ'², ¿mɨ³naa'³¹? 'E³ quie'²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³né² mɨ²ñi² dsa³ tuu² espíritu quien³² mɨ²³sɨ²³quiʉ'², ¿mɨ³naa'³¹? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ca²³tɨ́³ mɨ²juee'³ 'e³ mi³lii²³² dsa³ Israel 'e³ jmii'³¹ ca²³dxá³te'²³ guoo³ Dios 'ñʉ́² gáan³ mɨ²jaa²³². Ji̱i̱³ 'e³ güi'³ ma²ca¹jmóo¹te'²³ mɨ²juee'³ juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ŋɨ́³ Jesús ñʉ'²³ 'ñʉ́² gáan³, ñʉ'²³ 'oo'² i²ro̱o̱³² 'e³ xi̱i̱n³ 'oo'² i²ro̱o̱³² quiee'³² Salomón. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","'E³ quie'²³ jo̱³ ca²³ŋɨɨ'n²³ te'²³ juii² dsa³ Israel caan²³ Jesús. Ca²³sɨ'²³te'²³: ―¿Lɨɨ'³¹ cɨ² huø'n²³ 'e³ 'ne'² rɨ²je̱²ra'³¹ 'e³ rɨ²³dsóo²³ dsɨ³ra'³¹ xi² Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios 'nʉ³? Jɨn³ rɨ²juɨɨ'n³¹nu³ jnee'³¹ jo̱o̱²³na²³ ―ca²³sɨ'²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","'E³ jo̱³ ca²³jua'³ Jesús: ―Mɨ³juǿøn²na²³ 'nee'²³. 'E³ quie'²³ 'a²³jia'³ sɨ³táan³na'³. Jmee²³ lii²³ 'e³ 'i̱i̱² sɨɨ'³¹ jné² u²³juø'²³ 'e³ jmeen²³ 'e³ 'iin³¹ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","'E³ quie'²³ 'a²³jia'³ sɨ³táan³na'³. Qui² 'a²³la³ dsɨɨ³ joo³ quién²³na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ta³nʉ́ʉ²³ juø'n²³ dsɨɨ³ joo³ quién²³na²³. 'E³ quie'²³ cuiin²³na²³ miin²³ co̱'³. Qui̱i̱³te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jmeen²³ 'e³ rɨ³ji̱'²³te'²³ ca³cuaa³. 'A²³jia'³ jmɨ́ɨ² rɨ²³gua'²³te'²³. 'A²³'i̱³ xen³ 'i³ rɨ²³lí³ juø'² rɨ²³'uøøn³te'²³ guaan²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ñu'n²³ mɨ³cuǿn²³ jné² dsɨɨ³ joo³ 'í³. 'A²³'i̱³ xen³ 'i³ gáan³ la²³ gáan³ 'ñée². 'E³ jo̱³ 'a²³'i̱³ xen³ 'i³ rɨ²³li'²³ juø'² rɨ²³'uøøn³ dsɨɨ³ joo³ guoo³ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Lʉn²³ co̱o̱³ júu² jné² quia̱'n²³²na¹ Ñu'n²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Co̱'³ cɨ'²³ so̱'²³ cú̱u̱² te'²³ juii² dsa³ Israel 'e³ jua'³ rɨ²³cuǿ²³te'²³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'í³: ―Ñúun³ u²³juø'²³ mɨ³jméen²³ 'e³ mɨ³jméen²³ co̱²juø'¹ quie'² dsa³ 'e³ la²³ mɨ³dxi³ 'i'²³ Ñu'n²³. ¿'Ee² u²³juø'²³ mɨ³jméen²³ 'e³ lǿn³na'³ 'e³ dxi³ji̱i̱n³¹ 'e³ rɨ²jŋɨ'n²³na'³ jné²? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","'E³ jo̱³ ca²³jua'³ te'²³ juii² dsa³ Israel: ―'A²³la³ jo̱³ 'e³ mɨ³jméen² u²³juø'²³ 'e³ rɨ²jŋɨ'n²³²na'³¹ 'nʉ³. 'E³ bi²³ 'ñe'² lʉ́n² hua² 'e³ rɨ²jŋɨ'n²³²na'³¹ 'nʉ³. Qui² juø'n³ 'e³ Dios hua² 'nʉ³, juø'n³ quie'²³ te³ dsa³ hua² 'nʉ³ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ te'²³ juii² dsa³ Israel: ―To̱o̱²³ ley quien³²na'³, ¿mɨ³naa'³¹? 'e³ jua'³: “Juii² rɨ³løn³¹na'³ 'nee'²³, mɨ³juø'n²”. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","'E³ quie'²³ 'a²³jia'³ juu³² júu² quiee'³² Dios. “Juii²” ca²³sɨ'²³te'²³ dsa³ 'i³ ca²³núu³ júu² quiee'³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Jmii'³¹ lǿ² 'e³ mɨ³xi'²ra'³ jné²: “Bi²³ 'ñe'² lʉ́n²”, 'e³ juo'³ra'³ mɨ³juǿøn²na²³ 'nee'²³: “Jo̱o̱³¹ Dios hua² jné²”? Ca²³'náan²³ jné² Dios. Ca²³xíin²³ jné² mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Xi³nu³ 'a²³jia'³ jmeen²³ ta² quiee'³² Ñu'n²³, 'a²³ rɨ³sɨ³táan³na'³ júu² quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","'E³ quie'²³ xi³nu³ jmeen²³ ta² quiee'³² Ñu'n²³, 'ne'² rɨ²³sɨ²³táan³na'³ ta² 'e³ jmeen²³, juø'n³ quie'²³ 'a²³jia'³ sɨ³táan³na'³ júu² 'e³ lʉn²³. Jo̱³ hua² rɨ²³dsóo²³ 'óo²ra'³, rɨ²jmée²ra'³ 'i'²³ 'e³ quia̱'² jné² Ñu'n²³, 'e³ quia̱'n²³²na¹ 'ñée² co̱'³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Co̱'³ cɨ'²³ ca²³la²³'née²³te'²³ 'e³ rɨ²³sø̱'n²te'²³ Jesús. 'E³ quie'²³ ca²³láan³ 'ñée². 'A²³jia'³ lǿ²³ juø'² sø̱'n²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","'E³ quie'²³ jo̱³ ŋóo² co̱'³ joo³¹ i²³'ŋóo² jmɨɨ³ juee'³ Jordán je² ca²³xáan² dsa³ jmɨɨ³ Juan mɨ²xe̱'n³¹. Núu²³ i²gua³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Juɨ́ɨn²³ dsa³ 'i³ i²guín¹ caan²³. Ca²³jua'³te'²³: ―'A²³jia'³ ca²³jmée³ u²³juø'²³ Juan. 'E³ quie'²³ ju²dsoo³¹ la²³jɨ³ 'e³ ca²³lʉ́³ 'e³ la²³ ca²³'én² dsa³ la³ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Juɨ́ɨn²³ dsa³ 'i³ ca²³táan³ quia̱'² Jesús je² núu²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ca²³la²³dsoo'²³² jø̱n³ dsa³ 'i³ xi̱i̱n³ Lázaro. Dsa³ juɨɨ³ Betania hua² 'í³, juɨɨ³ je² jen³¹ Ma³rii³¹ quia̱'² Marta jó̱o̱². ");
INSERT INTO cnlNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ma³rii³¹ 'í³ hua² 'i³ ca²³'uu²³ tɨɨ² Jesús noo²³² mɨ³róo³, 'i³ ca²³xí³ tɨɨ² Jesús jñʉ³ dxi² 'ñée². Jó̱o̱² mɨ́³ 'í³ 'i³ xi̱i̱n³ Lázaro 'i³ dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","'E³ jo̱³ ca²³jmóo² co̱o̱³ júu² te'²³ mɨ́³ 'í³ 'e³ ca²³xíin²³te'²³ dsa³ 'i³ ca²³xii'²³² Jesús. Ca²³jua'³: ―Bi²³ dsoo'²³² dsa³ 'i³ bi²³ 'náan²³nu³, ¿mɨ³naa'³¹? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","'E³ quie'²³ ma²ca¹núu³ la'³ Jesús, ca²³jua'³: ―'A²³la³ jo̱³ 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jú̱n³ 'e³ mɨ³la³dsoo'²³². 'E³ quie'²³ 'e³ 'ne'² li²³lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³ Dios 'e³ mɨ³la³dsoo'²³². Rɨ²³jmée²³ lii²³ dsóo² quiee'³² 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³na²³ jné² Jo̱o̱³¹ Dios. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Bi²³ 'néen² Marta Jesús. 'E³ quie'²³ la'³ Ma³rii³¹ jó̱o̱² co̱'³. Bi²³ 'néen² Lázaro co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","'E³ quie'²³ ca²³cuaa'n²³ cɨ² tú̱²³ jmɨ́ɨ² je² jen³¹ ma²ca¹núu³ 'e³ dsoo'²³² Lázaro. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ma²mɨ³líi² la'³, ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Mɨ²³gui²³²ra² co̱'³ estado Judea je² jen³¹ Lázaro. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","'E³ quie'²³ ca²³jua'³ dsa³ quien³²: ―Dsa³ 'e²³, mɨ³tu³la³ nɨ³ ca²³la²³'née²³ te'²³ juii² dsa³ Israel 'e³ rɨ²³cuǿ²³ cú̱u̱² quién²nu³. ¿'A² juø'² lǿn³nu³ 'e³ guaan³² co̱'³? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","'E³ jo̱³ ca²³jua'³ Jesús: ―Xa³ cɨ² 'é̱e̱² 'e³ rɨ²jmeen²³² ta², ¿mɨ³naa'³¹? Qui² xa³ gui²³tʉ̱́³ horas la²³ co̱o̱³ jmɨ́ɨ²³ 'e³ jmoo³² dsa³ ta². 'A²³jia'³ ca²³tɨ́³ hora 'e³ rɨ²ti³cø̱n³¹na¹. Qui² 'a²³jia'³ ti³cø̱n³¹ dsa³ 'i³ ŋɨ́³ jmɨ́ɨ²³. Qui² cuø²³ jmɨ́ɨ²³ ji³ 'e³ xa³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","'E³ quie'²³ ti³cø̱n³¹ dsa³ 'i³ ŋɨ́³ 'uøø²³. Qui² 'a²³jia'³ ma²³ jné³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","'E³ quie'²³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―Mɨ³guɨɨn³ Lázaro 'i³ dxʉ́²³ lʉ²ra² quia̱'n²na², ¿mɨ³naa'³¹? 'E³ quie'²³ ñiin²³ i³ñin²³²na¹ je² rɨ³guɨɨn³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","'E³ jo̱³ ca²³jua'³ dsa³ quien³². Ca²³sɨ'²³ Jesús: ―Juii³ra'³¹, rɨ²³'láan³ xi³nu³ mɨ³guɨɨn³ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","'E³ jú̱n²³ Lázaro hua² 'e²³ Jesús. 'E³ quie'²³ te³ mɨ³guɨɨn³ hua², lǿn³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","'E³ jo̱³ ca²³lʉ́³ jɨn³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―Jú̱n²³ Lázaro, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","'E³ quie'²³ bi²³ cɨ² dxʉ́²³ quién² 'nee'²³ 'e³ 'a²³jia'³ jen³¹na¹ ma²ju̱n²³. Qui² xa³ 'e³ rɨ²³lí³ 'e³ rɨ²³jmée²³ 'e³ bi²³ cɨ² rɨ²³sɨ²³táan³na'³. Mɨ²³gui²³²ra² je² rɨ³'aan²³ jo̱o̱²³na²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ca²³jua'³ Tu³moo³² 'i³ sɨ'²³te'²³ Dsa³ Su̱u̱n²³². Ca²³sɨ'²³ uu'n² la²³ co̱³quie'² dsa³ quien³² Jesús: ―Mɨ²³gui²³²ra² jne² co̱'³. Jo̱³ hua² rɨ²³jú̱n³na² quia̱'n²na² Jesús ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ma²ca¹dxóo¹ Jesús juɨɨ³ Betania, ca²³núu³ 'e³ mɨ³tɨ́³ quiʉ̱́³ jmɨ́ɨ² 'e³ rɨ³'aan²³ 'lɨ² Lázaro. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","'A²³jia'³ huɨ̱́ɨ̱³ juɨɨ³ Betania la²³ juɨɨ³ Jerusalén, co̱o̱³ 'nɨ³ kilómetros 'nɨɨ'n³¹ xa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","'E³ jo̱³ juɨ́ɨn²³ dsa³ Israel 'i³ i²guín¹ quie'² Marta quia̱'² Ma³rii³¹. 'Née²³te'²³ rɨ²³lʉ́²³te'²³ quia̱'²te'²³ 'e³ cu²liin²³ dsɨ́²te'²³ 'e³ la²³ jú̱n²³ jó̱o̱²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ma²ca¹núu³ Marta 'e³ mɨ³ ja³'ɨ́ɨn²³ Jesús, ŋóo² ca²³mi²³jí̱i̱n³ Jesús. 'E³ quie'²³ ca²³cuaa'n²³ Ma³rii³¹ xi²ñʉ'¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","'E³ quie'²³ jo̱³ ca²³jua'³ Marta. Ca²³sɨ'²³ Jesús: ―Juiin²³, 'a²³jia'³ jú̱n²³ ja̱a̱n³² 'u² cu²ru'³ jen³¹nu³ la³ ma²dsoo'²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Juø'n³ quie'²³ rɨ³nɨ²³, rɨ²³cuǿø²³ 'nʉ³ Dios te³ 'ee² 'noo³¹ 'e³ rɨ²ŋɨ́ɨn² quie'², maan²³. ―La'³ ca²³jua'³ Marta. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Marta: ―Rɨ²³ji̱i̱'²³ co̱'³ já̱a̱n². ");
INSERT INTO cnlNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","'E³ quie'²³ ca²³jua'³ Marta: ―Maan²³ 'e³ rɨ²³ji̱i̱'²³ co̱'³ mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²³ji̱i̱'²³ co̱'³ la²³jɨn³ dsa³ 'i³ jú̱n²³, mɨ³rɨ³ti³ jmɨ́ɨ² je² dsøn³. ―La'³ ca²³jua'³ Marta. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Marta: ―Jné² hua² 'i³ jmeen²³ 'e³ sɨ³ji̱i̱'²³ co̱'³ dsa³, 'e³ rɨ³ji̱'²³te'²³ ca³quie̱e̱². Rɨ²³ji̱i̱'²³ co̱'³ dsa³ 'i³ sɨ³táan³ quia̱'² jné², juø'n³ quie'²³ rɨ²³jú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","'A²³jia'³ jmɨ́ɨ² rɨ²³gua'²³ dsa³ 'i³ mɨ³ji̱i̱'n²³ ca³quie̱e̱², 'i³ sɨ³táan³ quia̱'² jné². ¿'A² sɨ³táan³nu³ júu² la³? ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","'E³ jo̱³ ca²³jua'³ Marta. Ca²³sɨ'²³ Jesús: ―Sɨ³táan³na²³ xú̱n³, Juiin²³. Sɨ³táan³na²³ 'e³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios mɨ³¹güii³ la³ hua² 'nʉ³. Sɨ³táan³na²³ 'e³ Jo̱o̱³¹ Dios hua² 'nʉ³. ―La'³ ca²³jua'³ Marta. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ma²ca¹jua'³ la'³ Marta, ŋø'n² i²jen³ Ma³rii³¹ jó̱o̱². Ca²³lʉ́³ u²³láa². Ca²³jua'³: ―Mɨ³güén²³ dsa³ 'e²³, ¿mɨ³naa'³¹? Ŋɨɨ'n³² 'nʉ³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ma²ca¹núu³ la'³ Ma³rii³¹, ca²³naa'n²³ ca²³la²³dxí². Ŋóo² ca²³mi²³jí̱i̱n³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","'Íi² rɨ²³dxóo² Jesús jee²³² juɨɨ³. Qui² ca²³cuaa'n²³ je² ca²³jí̱i̱n³ Marta. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nee'n²³² quie'²³ xi²ñʉ'¹ dsa³ Israel quia̱'² Ma³rii³¹. Lʉ²³te'²³ quia̱'²te'²³ 'e³ jua'³ cu²liin²³ dsɨ́² 'e³ la²³ jú̱n²³ jó̱o̱². 'E³ quie'²³ ŋó²³te'²³ 'e³ ca²³naa'n²³ ca²³la²³dxí² Ma³rii³¹, 'e³ ca²³bǿn³ xi²dxi³². 'E³ jo̱³ ca²³guín²³ tu³cɨ̱ɨ̱n³ 'e³ la²³ ŋóo². Qui² mɨ³ŋoo³² je² rɨ³'aan²³ jó̱o̱² 'e³ jua'³ rɨ²³'o'², lǿn³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","'E³ quie'²³ jo̱³ ca²³dxóo² Ma³rii³¹ je² xi'n²³ Jesús. Xe̱'n² 'e³ la²³ ŋǿn² Jesús, ca²³quiaa³ rɨ³'in³² xi²ñi² Jesús. Ca²³jua'³: ―Juiin²³, 'a²³jia'³ jú̱n²³ ja̱a̱n³² 'u² cu²ru'³ jen³¹nu³ la³ ma²dsoo'²³² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ŋó²³ Jesús 'e³ bi²³ 'oo'³² Ma³rii³¹ quia̱'² te'²³ dsa³ Israel 'i³ mɨ³gui³guín²³ quia̱'². 'E³ jo̱³ bi²³ 'ii³ 'i'²³ 'e³ ca²³jmée³. Ca²³ŋɨ́³ dsɨ́². ");
INSERT INTO cnlNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ca²³jua'³: ―¿Jiaa'³¹ ca²³'aan²³²na'³ 'lɨ́ɨ³? 'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Juii³ra'³¹, mɨ²³gui²³²ra². Rɨ²máan² ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jo̱³ ca²³'o'² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","'E³ jo̱³ ca²³jua'³ dsa³ Israel: ―Jóo² ma². Jmii'³¹ 'nɨɨ'n³¹ 'néen² 'lɨ² Lázaro. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","'E³ quie'²³ ca²³jua'³ ca³dxáan²: ―Lǿ²³ juø'² ca²³jmée³ 'e³ 'a²³jia'³ jú̱n²³ Lázaro 'u² cu²ru'³ 'née²³ la'³, ¿mɨ³naa'³¹? Qui² ca²³né² mɨ²ñi² dsa³ tuu² ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","'E³ quie'²³ jo̱³ co̱'³ cɨ'²³ bi²³ 'ii³ 'i'²³ 'e³ ca²³jmée³ Jesús. Ca²³dxóo² je² rɨ³'aan²³ 'lɨ́ɨ³. Rɨ³lø³¹ too³ ñʉ'²³ 'loo³. Rɨ³jnɨ³ cú̱u̱² 'oo'² too³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―Je̱'n²³²na'³ cú̱u̱². 'E³ jo̱³ ca²³jua'³ Marta jó̱o̱² 'lɨ́ɨ³. Ca²³sɨ'²³ Jesús: ―Juiin²³, mɨ³la³jme'² mɨ³júun³, ¿mɨ³naa'³¹? Qui² mɨ³tɨ́³ quiʉ̱́³ jmɨ́ɨ² 'e³ jú̱n²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Marta: ―Mɨ³juǿøn²na²³ 'nʉ³ 'e³ rɨ²máan² 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³ Dios xi³nu³ sɨ³táan³nu³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","'E³ jo̱³ ca²³je̱'n²te'²³ cú̱u̱². Ca²³jóo² yʉʉ'³¹ Jesús. Ca²³lʉ́³ quia̱'² Dios Jmii³. Ca²³jua'³: ―Mɨ²'áan²nu³, Ñu'n², 'e³ mɨ³nʉʉn³ 'e³ la²³ lǿ² mɨ³juǿøn²na²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Maan²³ 'e³ tén³ nuun³ 'e³ la²³ lǿ² juøøn³²na²³ 'nʉ³. 'E³ quie'²³ mɨ³juø'n² la'³ 'e³ juø'n²³ 'náan²³ 'e³ rɨ²³núu²³ dsa³ 'i³ té̱e̱n³ la³. 'Náan²³ 'e³ rɨ²³sɨ²³táan³te'²³ 'e³ 'nʉ³ hua² 'i³ ca²³xíin²³nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","La'³ ca²³jua'³ Jesús. Jo̱³ tu³ tǿ²³ quiʉ̱ʉ̱³. Ca²³jua'³: ―Lázaro, ¡bǿn³! ");
INSERT INTO cnlNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","'E³ quie'²³ jo̱³ ca²³bǿn³ 'lɨ́ɨ³. 'E³ rɨ³pee'n³² rɨ³guiuu'n³² 'mɨɨ'³ quia̱'² guoo³ tɨɨ². Rɨ³laa³ paa²i² ñi². 'E³ jo̱³ ca²³jua'³ Jesús: ―Jee'n²³na'³ 'mɨɨ'³ 'e³ rɨ³laan³ Lázaro. Qui² cu²ŋɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","'E³ jo̱³ juɨ́ɨn²³ dsa³ Israel 'i³ ca²³táan³ quia̱'² Jesús. Qui² i²guín¹te'²³ quia̱'²te'²³ Ma³rii³¹. Ŋó²³te'²³ 'e³ jmii'³¹ ca²³jmée³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","'E³ quie'²³ xen³ 'i³ i²joon³ dsa³ fariseo. I²xii'²³²te'¹ 'e³ jmii'³¹ ca²³jmée³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","'E³ jo̱³ ca²³ñii'n³ dsa³ 'i³ ta'n² ta² jee²³² quiee'³² dsa³ Israel te'²³ dsa³ fariseo quia̱'² te'²³ juii² jmii³ dsa³. Ca²³jua'³te'²³: ―¿Jmii'³¹ rɨ²jmee²ra² cu²ne²ra²? Qui² ñúun³ u²³juø'²³ 'e³ jmee²³ dsa³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","La²³jɨn³ dsa³ rɨ²³sɨ²³táan³ quia̱'² xi³nu³ rɨ²cuø²quie¹ra² júu² 'e³ rɨ²³jmée²³ quie'²³ ta² quiee'³². Jo̱³ rɨ²³gui²³guín²³ dsa³ Roma. Rɨ²³yáan²te'²³ 'ñʉ́² gáan³ quiee³²ra². Rɨ²³mi²³gua'²³te'²³ juɨɨ³ quiee³²ra². ―La'³ ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","'E³ quie'²³ ca²³lʉ́³ jø̱n³ dsa³ 'í³ 'i³ xi̱i̱n³ Caifás 'i³ rɨ³løn³¹ juii² jmii³ dsa³ ji̱i̱³ ñi³ jo̱³. Ca²³sɨ'²³ uu'n²: ―Bi²³ gøn³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Qui² 'a²³jia'³ ta³jmee³ra'³ 'i'²³ 'e³ bi²³ cɨ² dxʉ́²³ quiée²ra² xi³nu³ rɨ²³jú̱n³ jø̱n³ dsa³ 'e³ 'iin³¹ la²³jɨn³ dsa³ juɨɨ³. La²³nɨ³ hua² 'a²³jia'³ li²³'ne'² 'e³ rɨ²³gua'²³ juɨɨ³ quiee³²ra². ―La'³ ca²³jua'³ Caifás. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","'E³ quie'²³ 'a²³la³ jo̱³ júu² 'e³ taa'² mɨ²dxi² 'ñée² ca²³lʉ́³. Rɨ³løn³¹ juii² jmii³ dsa³ ji̱i̱³ ñi³ jo̱³. 'E³ jo̱³ ca²³jmée³ Dios 'e³ ca²³lʉ́³ la'³, 'e³ ca²³jmée³ júu² jén²³ 'e³ rɨ²³jú̱n³ Jesús 'e³ 'iin³¹ dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","'E³ quie'²³ 'a²³la³ 'nɨɨ'n³¹ dsa³ juɨɨ³ Israel. Qui² 'née²³ 'e³ rɨ²³lín³ co̱o̱³ ta'n² dsa³ 'i³ rɨ³løn³¹ jo̱o̱³¹ Dios 'i³ rɨ³sáan³ rɨ³jǿn³ la²³ca̱a̱n³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","'E³ quie'²³ mɨ²jo̱³ ca²³la²³láa²³ 'e³ ca²³sɨ́n²³te'²³ júu² 'e³ jmii'³¹ rɨ²³jŋɨ'n²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","'E³ jo̱³ 'a²³jia'³ ma²³ ca²³ŋɨ́³ Jesús i²³ñín² la²³nɨ³ jee²³² quiee'³² dsa³ Israel. Ca²³bǿn³ ŋóo² mɨ³lén² la²³ 'uǿ²³ je² 'a²³jia'³ nee'n²³² dsa³. Ŋóo² juɨɨ³ je² xi̱i̱n³ Efraín. Núu²³ i²gua³ quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ca²³lǿ²³ mɨ³lén² mɨ²juee'³ pascua. Juɨ́ɨn²³ dsa³ 'i³ nee'n²³² la²³ca̱a̱n³ ranchos 'i³ ca²³guín²³ juɨɨ³ Jerusalén. Qui² 'née²³te'²³ rɨ²³mi²³jɨn³ miin²³ 'e³ la²³ lǿ² tɨ³² 'i'²³ quiee'³²te'²³ 'e³ 'íi² rɨ²³tɨ́²³ mɨ²juee'³ pascua. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ca²³'naa'n³te'²³ Jesús. Ca²³jua'³te'²³ i²³la³ i²³nɨ³ 'e³ la²³ té̱e̱n³te'²³ ñʉ'²³ 'ñʉ́² gáan³: ―¿Jmii'³¹ rɨ²³jmée²³ Jesús cu²ne²ra²? ¿'A² lǿn³na'³ 'e³ rɨ²³güén³ mɨ²juee'³? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ca²³dxi³ 'i'²³ te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ fariseo 'e³ cu²jmée³ júu² dsa³ 'i³ ñi³² 'e³ jiaa'³¹ jen³¹ Jesús. Qui² 'née²³te'²³ rɨ²³sø̱'n²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jmee²³ cɨ² jñʉ́ʉ³ jmɨ́ɨ² 'e³ rɨ²³tɨ́²³ mɨ²juee'³ pascua, ca²³dxóo² Jesús juɨɨ³ Betania je² jen³¹ Lázaro 'i³ ca²³mi²³ji̱i̱'²³ co̱'³ 'e³ la²³ jú̱n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Núu²³ ca²³jmóo²te'²³ mó² dxʉ́²³ 'e³ rɨ²³e'² Jesús mɨ³rɨ³'láa³. Ca²³dxá³ mó² Marta. Jen³¹ Lázaro coo³¹ mesa quia̱'² dsa³ 'i³ ee'³² quia̱'². ");
INSERT INTO cnlNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","'E³ quie'²³ jo̱³ có̱²³ Ma³rii³¹ co̱o̱³ 'noo³¹ litro noo²³² mɨ³róo³ 'e³ bi²³ quí̱i̱n²³ 'e³ xi̱i̱n³ nardo. Ca²³'uu²³ tɨɨ² Jesús. Jo̱³ tu³ ca²³xí³ jñʉ³ dxi² 'ñée². Rɨ³ca̱'n²³ xi²ñʉ'¹ ca²³la²³jme'² mɨ³róo³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","'E³ quie'²³ ca²³lʉ́³ Judas Iscariote, jo̱o̱³¹ Muun³², jø̱n³ dsa³ quien³² Jesús. 'I³ 'í³ hua² 'i³ ca²³'nɨ́ɨn²³ Jesús cɨ̱ɨ̱n³ cɨ². Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿'Ee² lǿ² 'a²³jia'³ ca³'nɨ́ɨ³te'²³ noo²³² la³? Lǿ²³ juø'² ca²³cuǿø²³te'²³ dsa³ taan³ jñii³¹ 'u² cu²ru'³ la'³. Qui² la²³'nɨɨ'n³¹ ñu'n² jñiin²³ dsa³ 'e³ 'nɨ³ i³lóo³ jmɨ́ɨ² ta², la'³ mi'³ 'nɨɨ'n³¹ quí̱i̱n²³ 'u². ");
INSERT INTO cnlNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","'E³ quie'²³ 'a²³la³ jo̱³ 'e³ bi²³ juɨɨ³² dsa³ taan³ ji̱'²³ Judas 'e³ ca²³jua'³ la'³. Ca²³jua'³ la'³ 'e³ jua'³ rɨ³løn³¹ dsa³ 'i̱i̱³. Qui² 'me²³ 'ñée² cuu² quiee'³² dsa³ quien³² Jesús 'e³ ca²³sɨ'²³te'²³ 'e³ rɨ²³'áa²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","'E³ jo̱³ ca²³jua'³ Jesús: ―'A²³ rɨ³mɨ'n²³²nu³ mɨ́³. Qui² ca²³'áa³ noo²³² mɨ³róo³ 'e³ jua'³ 'e³ cɨ² li²³'ne'² mɨ³rɨ³ti³ rɨ²³'áan²te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tén³ la²³ xen³ dsa³ taan³ jee²³² quien³²na'³. 'E³ quie'²³ 'a²³la³ tén³ jen³¹na¹ quia̱'n²³²na¹ 'nee'²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Juɨ́ɨn²³ dsa³ Israel 'i³ ca²³dsóo²³ dsɨ́² 'e³ jen³¹ juɨɨ³ Betania Jesús. 'E³ jo̱³ i²guín¹te'²³ núu²³. Qui² 'née²³ rɨ²³jóon²te'²³ Jesús. 'Née²³ rɨ²³jóon²te'²³ Lázaro 'i³ ca²³mi²³ji̱i̱'²³ co̱'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","'E³ jo̱³ ca²³mi²³'ien³ júu² te'²³ juii² jmii³ dsa³ 'e³ rɨ²³jŋɨ'n²³te'²³ Lázaro co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Qui² juɨ́ɨn²³ dsa³ Israel 'i³ 'a²³jia'³ ma²³ nuu³ júu² quiee'³²te'²³ cɨ'²³ ma²ŋó¹te'²³ 'e³ ca²³ji̱i̱'²³ co̱'³ Lázaro. Sɨ³táan³te'²³ quia̱'²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","La²³ mɨ³dxóo³ 'e³ ca²³'uu²³te'²³ noo²³² mɨ³róo³ tɨɨ² Jesús, juɨ́ɨn²³ dsa³ 'i³ nee'n²³² mɨ²juee'³ ca²³núu³ 'e³ mɨ³ja³'ɨ́ɨn²³ Jesús juɨɨ³ Jerusalén. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","'E³ jo̱³ ca²³guín²³te'²³ 'e³ rɨ²³mi²³jí̱i̱n³te'²³ Jesús. Xe̱e̱'³te'²³ guoo³ sú̱². Yoo'²³ tø³²te'²³. Ca²³jua'³te'²³: ―¡Que viva! ¡Mɨ³cuǿ³ Dios u²³li²³jé̱e̱³ quie'² dsa³ la³ 'i³ ja³'ɨ́ɨn²³ 'e³ 'iin³¹ Dios Juii³ra²! ¡Mɨ³cuǿ³ u²³li²³jé̱e̱³ quie'² rey quien³² dsa³ Israel! ―La'³ ca²³jua'³te'²³ ca²³'én²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ca²³jmée³ ji̱i̱³ jø̱n³ jo̱o̱³¹ burro Jesús. Ca²³cu²³dsɨn³¹. Qui² xa³ je² to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","'A²³ rɨ³juø'n²³na'³ miin²³na'³, 'nee'²³ 'i³ nee'n²³² juɨɨ³ Sión. Jóo²ra'³. Ja³'ɨ́ɨn²³ rey quien³²na'³ 'i³ cu³dsɨn³¹ jo̱o̱³¹ burro. La'³ cu³lø³¹ to̱o̱²³ ji³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","'A²³jia'³ ca²³jmóo² 'i'²³ xe̱'n² dsa³ quien³² Jesús 'e³ sɨ³lí³ 'e³ la²³ to̱o̱²³ ji³ 'e³ rɨ²³lí³. 'E³ quie'²³ cɨ̱ɨ̱n³ cɨ² ma²mɨ³líi² 'e³ mɨ³la³gáan³ 'ñée² 'e³ la²³ jú̱n²³, ca²³jmóo²te'²³ 'i'²³. Ca²³la²³líi²³te'²³ 'e³ jmii'³¹ cu³lø³¹ to̱o̱²³ ji³ 'e³ 'en³² Jesús. Ca²³jmóo²te'²³ 'i'²³ 'e³ ca²³ji̱'²³ Jesús 'e³ la²³ to̱o̱²³ ji³ 'e³ rɨ²³ji̱'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ca²³jmóo² júu² dsa³ 'i³ quia̱'² Jesús ma²ca¹sɨ'¹ Lázaro 'e³ rɨ²³bǿn³ je² rɨ³'aan²³, 'i³ quia̱'² Jesús ma²ca¹mi¹ji̱i̱'²³ co̱'³ Lázaro. Ca²³jmóo² júu² dsa³ 'í³ 'e³ jmii'³¹ lǿ² 'e³ ŋó²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","'E³ jo̱³ ca²³guín²³ dsa³ Jerusalén 'e³ jua'³ rɨ²³mi²³jí̱i̱n³te'²³ Jesús. Qui² ca²³núu³te'²³ 'e³ ca²³jmée³ u²³juø'²³ jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","'E³ jo̱³ ca²³lʉ́³ quia̱'² uu'n² te'²³ dsa³ fariseo. Ca²³jua'³: ―'A²³'e³ ma²³ xa³ 'e³ rɨ²jmee²ra² rɨ³nɨ²³. Qui² la²³jɨn³ sú̱n² dsa³ mɨ³qui̱i̱³ dsa³ nɨ³. ―La'³ ca²³jua'³ dsa³ fariseo. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Xen³ dsa³ griego 'i³ i²guín¹ juɨɨ³ Jerusalén 'e³ jua'³ rɨ²³mi²³gáan³te'²³ Dios je² sɨ³lí³ mɨ²juee'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","'E³ quie'²³ jo̱³ i²guín¹ dsa³ 'í³ caan²³ Bi³lii², dsa³ 'i³ xen³ juɨɨ³ Betsaida estado Galilea. Ca²³sɨ'²³te'²³: ―'Nee³ra'³¹ 'e³ li²³cuiin²³na'³¹ Jesús 'u² ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","'E³ jo̱³ ŋóo² Bi³lii² i²xii'²³² Drøø³¹. 'E³ quie'²³ jo̱³ ŋóo² Drøø³¹ quia̱'² Bi³lii² i²xii'²³²te'¹ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Bi³lii² quia̱'² Drøø³¹: ―Mɨ³tɨ́³ 'e³ li²³gáan³na²³ jné² Jo̱o̱³¹ Dsa³ 'e³ la²³ rɨ²³jú̱n³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xi³nu³ 'a²³jia'³ li²³jne² 'uǿ²³ mɨ³¹cuɨɨ³, xi³nu³ 'a²³jia'³ rɨ²³jú̱n³ mɨ²ŋu², rɨ²³cuaa'n²³ 'ñée² co̱o̱³ mɨɨ³¹. 'E³ quie'²³ xi³nu³ rɨ²³jú̱n³ mɨ²ŋu², bi²³ ñúun³ mɨɨ³¹ rɨ²³'ɨ́ɨ²³ xi³nu³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Rɨ²³gua'²³ dsa³ 'i³ bi²³ mi³quí̱i̱n²³ 'e³ xen³ mɨ³¹güii³ la³. 'E³ quie'²³ rɨ³ji̱'²³ ca³cuaa³ dsa³ 'i³ 'a²³jia'³ mi³quí̱i̱n²³ 'ñée² 'e³ xen³ mɨ³¹güii³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","'Ne'² rɨ²³ŋɨ́²³ quia̱'² jné² dsa³ 'i³ 'née²³ rɨ²³lín³ mozo quién²³na²³. Jen³¹ mozo quién²³na²³ je² jen³¹na¹. 'E³ quie'²³ Ñu'n²³ rɨ²³mi²³gáan³ dsa³ 'í³, 'i³ rɨ³løn³¹ mozo quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Co̱'³ cɨ'²³ ca²³jua'³ Jesús: ―'E³ quie'²³ mɨ³ŋɨ́³ dsɨn²³. ¿Jmii'³¹ rɨ²juøøn³¹na¹ Ñu'n²³ jo̱o̱²³na²³? ¿'A² rɨ²juøøn³¹na¹: “Ñu'n², 'a²³ cu²lí³ 'e³ la²³ mɨ³tɨ́³ 'e³ rɨ²³lí³”? 'A²³jia'³ xú̱n³. Qui² 'e³ jo̱³ hua² 'e³ güén²³na²³ mɨ³¹güii³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ñu'n², jmee² 'e³ la²³ rɨ²³mi²³gáan³ dsa³ 'nʉ³. ―La'³ ca²³jua'³ Jesús. 'E³ quie'²³ jo̱³ xen³ 'i³ ca²³lʉ́³ jí̱i̱n² yʉʉ'³¹ güii³. Ca²³jua'³: ―Mɨ³jméen²³ 'e³ la²³ rɨ²³mi²³gáan³ dsa³ jné². 'E³ quie'²³ 'e³ cɨ² rɨ²jmeen²³² la'³ co̱'³ cɨ'²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ca²³núu³ dsa³ 'i³ té̱e̱n³ je² núu²³. ―Mɨ³'í̱n² i²³'ñeen³¹ ―ca²³jua'³te'²³. Jia'³ cɨ'²³ dsa³ ca²³jua'³: ―Mɨ³lʉ́³ ángel quia̱'² dsa³ nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","'E³ jo̱³ ca²³jua'³ Jesús: ―Xen³ 'i³ mɨ³lʉ́³ 'e³ jua'³ 'née²³ 'e³ rɨ²núu²ra'³. 'A²³la³ jo̱³ 'e³ 'née²³ 'e³ rɨ²nuun²³² jné² 'e³ mɨ³lʉ́³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mɨ³tɨ́³ 'e³ li²³lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'a²³jia'³ dxʉ́²³ jmoo³² dsa³ mɨ³¹güii³. Mɨ³tɨ́³ 'e³ rɨ²³taa'³ ta² quiee'³² mɨ²³sɨ²³quiʉ'², 'i³ rɨ³løn³¹ juii² mɨ³¹güii³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Rɨ²tøøn³¹na¹ la²³jɨn³ dsa³ mɨ³rɨ³xaa'n³²te'²³ jné² yʉʉ'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","La'³ ca²³jua'³ Jesús 'e³ jua'³ ca²³jmée³ lii²³ 'e³ jmii'³¹ cu³lø³¹ rɨ²³jú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","'E³ jo̱³ ca²³jua'³ dsa³. Ca²³sɨ'²³te'²³ Jesús: ―Nʉʉ³ra'³¹ 'e³ xen³ ca³cuaa³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios. Qui² la'³ cu³lø³¹ to̱o̱²³ ley. ¿Jmii'³¹ lǿ² 'e³ juø'n³ 'nʉ³ 'e³ 'ne'² rɨ²³xa'n²te'²³ yʉʉ'³¹ Jo̱o̱³¹ Dsa³? ¿'I̱i̱² sɨɨ'³¹ 'í³ Jo̱o̱³¹ Dsa³ 'i³ 'ǿn²³nu³ nɨ³? ¿'A² 'a²³la³ 'í³ Cristo? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³: ―Ca³juɨ² ca³ŋɨ́n³ cɨ² cuø²³ jmɨ́ɨ²³ ji³ 'e³ jné³ quién²na'³. 'Ne'² rɨ²ŋɨ́²ra'³ la²³ cɨ² jné³. Qui² mɨ³ rɨ²³lí³ li³'o̱o̱³. 'A²³jia'³ ma²³ ñi³² dsa³ 'i³ ŋɨ́³ je² li³'o̱o̱³ 'e³ jiaa'³¹ dsoo³². ");
INSERT INTO cnlNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","La²³ xen³ ji³ xen²³na²³ jné². 'Ne'² rɨ²³sɨ²³táan³na'³ quia̱'n²na'³ jné² la²³huø'n²³ cɨ² 'e³ jen³¹na¹ quia̱'n²³²na¹ 'nee'²³. Qui² jo̱³ hua² rɨ²³lín³na'³ dsa³ quién²³na²³. Ma²mɨ³líi² mɨ³jua'³ la'³ Jesús, ca²³bǿn³ co̱'³. Ca²³'mǿn²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Juø'n³ quie'²³ bi²³ ñúun³ u²³juø'²³ ca²³jmée³ Jesús 'e³ ca²³jóo² dsa³, 'a²³jia'³ jmɨ́ɨ² ca²³táan³te'²³ quia̱'²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","La'³ cu³lø³¹ ca²³lǿ²³. Qui² 'ne'² rɨ²³lí³ 'e³ la²³ ca²³jua'³ Isaías, jø̱n³ dsa³ 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³², ma²ca¹jua'³: Juii³ra'³¹, te³ 'i̱i̱² qui³ sɨɨ'³¹ 'i³ mɨ³ca³táan³ júu² 'e³ mɨ³'ii²ra'³¹ quie'²te'²³. 'A²³'i̱³ xen³ 'i³ mɨ³dsóo²³ dsɨ́² 'e³ jmii'³¹ 'nɨɨ'n³¹ 'uee'n³nu³ 'uǿøn²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","'E³ jo̱³ 'a²³jia'³ ca³lǿ²³ juø'² ca²³táan³te'²³. Qui² ca²³lǿ²³ 'e³ la²³ to̱o̱²³ jia'³ cɨ'²³ to̱o̱²³ je² ca²³jua'³ Isaías mɨ²jo̱³: ");
INSERT INTO cnlNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Mɨ³jmée³ Dios 'e³ tuu² mɨ²ñi²te'¹. Mɨ³jmée³ 'e³ rɨ³laa³ dsɨ́²te'²³. 'E³ jo̱³ hua² 'a²³jia'³ li²³jné³ mɨ²ñi²te'¹. 'E³ jo̱³ hua² 'a²³jia'³ rɨ²³jmée²³ 'i'²³ dsɨ́²te'²³. 'E³ jo̱³ hua² 'a²³jia'³ rɨ²³ja²³guín²³te'²³ caan²³na²³ 'e³ rɨ²mi³'láan²na²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","La'³ ca²³jua'³ Isaías 'e³ ca²³'én² Jesús. Qui² ca²³dsóo²³ dsɨ́² Isaías 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³ Cristo ma²ca¹ji̱'¹ 'é̱e̱² 'e³ ca²³cɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Juø'n³ quie'²³ la'³, juɨ́ɨn²³ dsa³ 'i³ ta'n² ta² 'i³ ca²³táan³ quia̱'² Jesús. 'E³ quie'²³ 'a²³jia'³ ca²³jmóo²te'²³ júu². Qui² bi²³ 'ñaa'n²³te'²³ dsa³ fariseo. Qui² ñi³²te'²³ 'e³ 'a²³jia'³ ma²³ rɨ²³cuǿ²³ júu² dsa³ fariseo 'e³ rɨ²³ta'n²³te'²³ la²³jɨ³ 'ñʉ́² je² mi³gáan³ Dios dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Qui² bi²³ cɨ² ca²³mi²³quí̱i̱n²³te'²³ 'e³ rɨ²³mi²³jue'²³ dsa³ la²³ cɨ'²³ 'e³ rɨ²³mi²³jue'²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","'E³ quie'²³ jo̱³ ca²³lʉ́³ quiʉ̱ʉ̱³ Jesús. Ca²³jua'³: ―'A²³la³ 'nɨɨ'n³¹ jné² 'i³ sɨ³táan³ quia̱'² dsa³ 'i³ sɨ³táan³. Sɨ³táan³ quia̱'² Dios 'i³ ca²³xíin²³ jné² dsa³ 'i³ sɨ³táan³ quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Dsa³ 'i³ cuiin²³ jné² cuiin²³ Dios 'i³ ca²³xíin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","La²³ xen³ ji³ 'e³ sɨ³'ioo²³ je² li³'o̱o̱³ xen²³na²³ jné². Güén²³na²³ mɨ³¹güii³ 'e³ juø'n²³ 'náan²³ 'e³ 'a²³jia'³ ma²³ nee'n²³² je² li³'o̱o̱³ la²³jɨn³ dsa³ 'i³ rɨ²³sɨ²³táan³ quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","'E³ quie'²³ 'a²³la³ jné² 'i³ dxen²³ ta² quiee'³² dsa³ 'i³ 'a²³jia'³ jmee²³ quie'² 'e³ rɨ²³núu²³ júu² quián²³. 'A²³la³ jo̱³ 'e³ 'náan²³ rɨ²dxen²³² ta² quiee'³² dsa³ mɨ³¹güii³ 'e³ güén²³na²³. Güén²³na²³ 'e³ juø'n²³ 'náan²³ rɨ²láan¹na²³ dsa³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","'E³ quie'²³ xen³ 'i³ rɨ²³dxá²³ ta² quiee'³² dsa³ 'i³ 'a²³jia'³ jmi'n²³ jné², dsa³ 'i³ 'a²³jia'³ rɨ²³núu²³ júu² quián²³. Júu² 'e³ mɨ³lʉn²³ rɨ²³jmée²³ lii²³ 'e³ joo'²³ rɨ²³dxá²³te'²³ ta² quiee'³² dsa³ 'í³ mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²³güe'n²³na²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Qui² 'a²³la³ 'e³ la²³ 'náan²³ 'ñáan²³ 'e³ mɨ³lʉn²³. Ca²³dxi³ 'i'²³ Ñu'n²³ 'i³ ca²³xíin²³ jné² 'e³ jmii'³¹ rɨ²juø'n³¹, 'e³ jmii'³¹ rɨ²lʉn²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Maan²³ 'e³ jmee²³ 'e³ rɨ³ji̱'²³ dsa³ ca³cuaa³ júu² 'e³ ca²³dxi³ 'i'²³ Ñu'n²³ 'e³ rɨ²lʉn²³². 'E³ jo̱³ lʉn²³ la²³jɨ³ júu² 'e³ ca²³sɨ'²³ jné² Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","'Íi² rɨ²³tɨ́²³ mɨ²juee'³ pascua. Ñi³² Jesús 'e³ mɨ³ rɨ²³tɨ́²³ 'e³ rɨ²³bǿn³ mɨ³¹güii³ la³, 'e³ dsø'n³² je² jen³¹ Jmii³. 'E³ quie'²³ bi²³ 'néen² dsa³ quien³² 'i³ nee'n²³² mɨ³¹güii³. Bi²³ ma²³'nee³ ca²³jmée³ lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ 'néen². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ta'n² ee'³²te'²³ mɨ²³'láa²³. 'E³ quie'²³ ca²³jmée³ mɨ²³sɨ²³quiʉ'² 'e³ ca²³jmée³ 'i'²³ Judas Iscariote, jo̱o̱³¹ Muun³², 'e³ rɨ²³'nɨ́ɨn²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ñi³² Jesús 'e³ ca²³jmée³ Dios 'e³ née² guoo³ 'ñée² la²³jɨ³. Ñi³² 'e³ jó² jí̱i̱n² je² jen³¹ Dios. 'E³ quie'²³ ñi³² 'e³ rɨ²³dsø'n² jí̱i̱n² núu²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","'E³ quie'²³ jo̱³ ca²³naa'n²³ 'ñée² je² ta'n² ee'³²te'²³. Ca²³dxin³ cuo̱o̱³ 'e³ dxi²³juɨn³¹. Ca²³'ñu'n²³ 'mɨɨ'³ toalla. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ca²³xi'²³ jmɨɨ³ 'ú³ ñí² taa³. Ca²³u̱'² tɨɨ² dsa³ quien³². Ca²³xí³ tɨɨ² dsa³ quien³² 'mɨɨ'³ 'e³ rɨ³'ñu'n² 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ca²³tɨ́³ 'e³ rɨ²³u̱'² tɨɨ² Muun³² Peen²³². 'E³ jo̱³ ca²³jua'³ Peen²³²: ―Juiin²³, ¿'a² lǿn³nu³ 'e³ rɨ²u̱u̱'n³¹ tɨɨn²³? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³²: ―'A²³jia'³ ta³jmeen³ 'i'²³ rɨ³nɨ²³ 'e³ 'ee² lǿ² 'e³ jmeen²³ 'e³ la²³ jmeen²³. 'E³ quie'²³ 'e³ cɨ² rɨ²jméen² 'i'²³ cɨ̱ɨ̱n³ cɨ² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","'E³ jo̱³ ca²³jua'³ Peen²³². Ca²³sɨ'²³ Jesús: ―'A²³jia'³ jmɨ́ɨ² 'náan²³ 'e³ rɨ²u̱u̱'n³¹ tɨɨn²³ xú̱n³. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³²: ―Xi³nu³ 'a²³jia'³ rɨ²u̱'n¹ tɨɨn³¹, 'a²³jia'³ rɨ³løn³¹nu³ dsa³ quién²³na²³ ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","'E³ quie'²³ jo̱³ ca²³jua'³ Muun³² Peen²³²: ―Juiin²³, u̱'² guaan²³. U̱'² mɨ²dxin²³ co̱'³. Qui² 'a²³jia'³ líi² 'nɨɨ'n³¹ tɨɨn²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","'E³ quie'²³ ca²³jua'³ Jesús: ―Líi² 'nɨɨ'n³¹ tɨɨ² cɨ² rɨ²³jñi³ dsa³ 'i³ mɨ³loo'³² ca³dxa³. Qui² mɨ³jŋɨn³ rɨ³ca̱'n²³ 'e³ la²³ mɨ³loo'³². Mɨ³jŋɨn³na'³ jo̱o̱²³na²³. 'E³ quie'²³ 'a²³la³ la²³jɨn³na'³ mɨ³jŋɨn³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","La'³ ca²³jua'³ Jesús. Qui² ñi³² 'ñée² 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³'nɨ́ɨ²³ quie'². 'E³ jo̱³ hua² ca²³jua'³: “'A²³la³ la²³jɨn³na'³ mɨ³jŋɨn³na'³”. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ma²mɨ³líi² mɨ³u̱'² tɨɨ²te'¹, cɨ'²³ co̱'³ cuo̱o̱³. Ca²³gua³ co̱'³. Ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―¿'A² mɨ³ca³dsaan³²na'³ 'e³ la²³ lǿ² mɨ³jme'n²³na²³ 'nee'²³? ");
INSERT INTO cnlNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Juɨɨ'³²ra'³ jné² Dsa³ 'e²³. 'E³ quie'²³ juɨɨ'³²ra'³ jné² Juii³ra'³¹ co̱'³. Dxʉ́²³ lʉ́²ra'³ jo̱o̱²³na²³. Qui² 'i³ 'í³ hua² jné² xú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Juii³ra'³ jné². Dsa³ 'e²³ quien³²na'³ jné². Mɨ³u̱'n²³ tɨɨ³¹ra'³. 'E³ quie'²³ la'³ 'ne'² rɨ²u̱u̱'³¹ra'³ tɨɨ² uu'n²na'³ i²³la³ i²³nɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Qui² mɨ³cuǿøn²³na²³ 'nee'²³ jui³¹ 'e³ jmii'³¹ rɨ²jmée²ra'³. 'Ne'² rɨ²jmée²ra'³ 'e³ la²³ mɨ³jme'n²³na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'A²³jia'³ gáan³ cɨ² mozo la²³ cɨ'²³ juii². 'E³ quie'²³ la'³ 'a²³jia'³ gáan³ cɨ² dsa³ xiin²³ la²³ cɨ'²³ dsa³ 'i³ ca²³xíi²³ quie'². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Móo³ra'³ júu² 'e³ cɨ² mɨ³juǿøn²na²³ 'nee'²³. 'E³ jo̱³ bi²³ dxʉ́²³ quién²na'³ xi³nu³ rɨ²jmée²ra'³ 'e³ la²³ mɨ³juǿøn²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’'E³ quie'²³ 'a²³la³ la²³jɨn³ 'nee'²³ 'i³ 'ǿn²³na²³ 'e³ juø'n²³ bi²³ dxʉ́²³ quién²na'³. Maan²³ 'e³ 'i̱i̱² dsa³ 'i³ ca²³'náan²³na²³. 'E³ quie'²³ 'ne'² rɨ²³lí³ 'e³ la²³ to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: “Ca²³jmée³ la³jmøn³¹ dsa³ 'i³ ee'n²³ quia̱'n²³²na¹”. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mɨ³juǿøn²na²³ 'nee'²³ júu² nɨ³ 'e³ 'íi² rɨ²³lí³ la'³. Qui² 'náan²³ 'e³ bi²³ cɨ² rɨ²³sɨ²³táan³na'³ 'e³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios jné² mɨ³rɨ³'aa³ 'i'²³ 'e³ sɨ³lí³ la²³jɨ³ 'e³ mɨ³juǿøn²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: 'É̱e̱² 'e³ 'ii'n³²te'²³ jné² xi³nu³ 'ii'n³²te'²³ la²³jɨn³ dsa³ 'i³ sɨɨn³²na²³. 'É̱e̱² 'e³ 'ii'n³²te'²³ Ñu'n²³ 'i³ ca²³xíin²³ jné² xi³nu³ 'ii'n³²te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ma²mɨ³líi² mɨ³jua'³ la'³ Jesús, bi²³ ca²³ŋɨ́³ dsɨ́². 'E³ jo̱³ ca²³jua'³: ―Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Xen³ jø̱n³ 'nee'²³ 'i³ rɨ²'nɨɨn²³na'³ jné² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","'E³ jo̱³ ca²³jóon² uu'n² i²³la³ i²³nɨ³ te'²³ dsa³ quien³². Qui² 'a²³jia'³ ñi³²te'²³ 'e³ 'i̱i̱² sɨɨ'³¹ 'en³². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","'E³ quie'²³ jen³¹na¹ rɨ³quie̱e̱n²³²na¹ caan²³ Jesús jné² dsa³ quien³² 'i³ bi²³ 'néen². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","'E³ quie'²³ jo̱³ ca²³jmée³ lii²³ Muun³² Peen²³² 'e³ jua'³ 'née²³ rɨ²³tín²³ júu². Ca²³jua'³: ―Xii'² 'i̱i̱² sɨɨ'³¹ 'en³². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jen³¹quien¹na²³ rɨ³quie̱e̱n²³²na¹ caan²³ Jesús. 'E³ jo̱³ ca²³juǿøn²: ―Juiin²³, ¿'i̱i̱² sɨɨ'³¹ 'ǿn²³nu³ nɨ³? ");
INSERT INTO cnlNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","'E³ jo̱³ ca²³jua'³ 'ñée²: ―'I³ 'í³ hua² 'i³ rɨ²cuǿøn¹ co̱o̱³ juɨɨ²³² 'ɨ²³juɨ² 'e³ rɨ²'a'n¹ 'e̱'³ jmɨɨ'³¹. 'E³ quie'²³ jo̱³ ca²³'a'²³ 'e̱'³ jmɨɨ'³¹ co̱o̱³ juɨɨ²³² 'ɨ²³juɨ². Jo̱³ tu³ ca²³cuǿø²³ Judas Iscariote, jo̱o̱³¹ Muun³². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ma²mɨ³líi² mɨ³cuǿ³ 'ɨ²³juɨ² Jesús, 'í² mɨ²³sɨ²³quiʉ'² dsɨ́² Judas. 'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Judas: ―Ca²³la²³dxí² rɨ²jméen² 'e³ la²³ rɨ²jméen². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","'E³ quie'²³ cu³xi³ jø̱n³ dsa³ 'i³ nee'n²³² coo³¹ mesa 'a²³jia'³ ñi³² 'e³ 'ee² lǿ² ca²³sɨ'²³ la'³ Judas. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Qui² 'aa³ cuu² quiee'³²te'²³ Judas. 'E³ jo̱³ xen³ 'i³ lǿn³ 'e³ ca²³jua'³ Jesús 'e³ 'ne'² rɨ²³sɨ²³quié̱³ Judas 'e³ rɨ²³e'²te'²³ 'e³ jua'³ jmoo³²te'²³ mɨ²juee'³. Xen³ 'i³ lǿn³ 'e³ xa³ 'e³ rɨ²³cuǿø²³te'²³ dsa³ taan³ 'e³ ca²³jua'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","'E³ quie'²³ jo̱³ ma²mɨ³líi² mɨ³'ioo³² juɨɨ²³² 'ɨ²³juɨ² Judas, ca²³bǿn³ xe̱'n² jmɨ́ɨ². Mɨ³la³'uøø²³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ma²mɨ³líi² mɨ³bǿn³ Judas, ca²³jua'³ Jesús: ―Mɨ³tɨ́³ 'e³ li²³gáan³na²³ jné² Jo̱o̱³¹ Dsa³. 'E³ quie'²³ la²³jɨ³ 'e³ rɨ²³jí̱i̱n²³ rɨ²³jmée²³ lii²³ 'e³ bi²³ gáan³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","'E³ jo̱³ rɨ²³mi²³gáan³ jné² Dios 'e³ jua'³ jmee²³ lii²³ 'e³ bi²³ gáan³ 'ñée² la²³jɨ³ 'e³ rɨ²³jí̱i̱n²³. Xe̱'n² rɨ³nɨ²³ rɨ²³mi²³gáan³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Te'²³ xii'³ quién²³na²³, ca²³ji̱i̱³ cɨ² jen³¹na¹ quia̱'n²³²na¹ 'nee'²³. 'E³ cɨ² rɨ²'naa'n²³na'³ jné². Rɨ²juøøn³¹na¹ 'nee'²³ 'e³ la²³ lǿ² ca²³juǿøn²na²³ te'²³ juii² dsa³ Israel: 'A²³jia'³ rɨ²³lí³ juø'² cu³guiin³²na'³ je² ñe'n³²na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","'E³ quie'²³ xa³ co̱o̱³ júu² 'mɨɨn³² 'e³ rɨ²dxin²³² 'i'²³ quién²na'³: 'Ne'² li²³'náan²³na'³ uu'n²na'³. 'E³ la²³ 'náan²³na²³ 'nee'²³ 'ne'² li²³'náan²³na'³ uu'n²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","'E³ jo̱³ rɨ²³ñí² la²³jɨn³ dsa³ 'e³ dsa³ quién²³na²³ 'nee'²³ xi³nu³ li²³'náan²³na'³ uu'n²na'³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","'E³ quie'²³ jo̱³ ca²³jua'³ Muun³² Peen²³². Ca²³sɨ'²³ Jesús: ―Juiin²³, ¿jiaa'³¹ guø'n³²nu³ ru'³? 'E³ jo̱³ ca²³jua'³ Jesús: ―'A²³jia'³ mɨ³ rɨ²³lí³ juø'² rɨ²qui̱i̱'n³¹nu³ jné². 'E³ quie'²³ cɨ̱ɨ̱n³ cɨ² rɨ²³lí³ juø'² rɨ²qui̱i̱'n³¹nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","'E³ quie'²³ jo̱³ ca²³jua'³ Peen²³²: ―Juiin²³, ¿'ee² lǿ² 'a²³jia'³ mɨ³ rɨ²³lí³ juø'² rɨ²qui̱'n¹na²³ 'nʉ³? Qui² dxʉ́²³ dsɨn²³ 'e³ rɨ²³jú̱n³na²³ 'e³ 'iin³¹nu³ xú̱n³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'A² 'e̱'n³ quie'²³ dsɨ́² dxʉ́²³ 'áan² 'e³ rɨ²³jú̱n³nu³ 'e³ 'iin³¹na¹? Rɨ²juøøn³¹na¹ 'nʉ³ ju²dsoo³¹: 'E³ 'íi² cɨ² rɨ²³tǿ² 'nɨɨ'², rɨ²juɨɨ'n³¹ dsa³ 'nɨ³ taa'² 'e³ 'a²³jia'³ cuiin²³nu³ jné². ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ca²³jua'³ Jesús: ―'A²³jia'³ 'ne'² ŋɨ́³ 'óo²ra'³. 'Ne'² 'e³ rɨ²³sɨ²³táan³cɨ²na'³ quia̱'n²na'³ Dios quia̱'n²na'³ jné² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bi²³ ñúun³ to̱o̱²³ xa³ je² joo'²³ rɨ²³gua³ dsa³ yʉʉ'³¹ je² jen³¹ Ñu'n²³. 'U² cu²ru'³ 'a²³ xa³, 'a²³jia'³ jmɨ́ɨ² ca³juǿøn²na²³ 'nee'²³ 'e³ xa³ 'u² cu²ru'³ la'³. 'E³ jo̱³ ñe'n³²na²³ 'e³ juø'n²³ i³mi³tɨɨn²³ dxʉ́²³ je² rɨ²ñí²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","'E³ quie'²³ ma²mɨ³líi² mɨ³ñii'n²³²na¹ mɨ³i²jméen¹ dxʉ́²³ je² rɨ²ñí²ra'³, jo̱³ rɨ²³güe'n²³na²³ co̱'³. Rɨ²tøøn³¹na¹ 'nee'²³ quián²³. Qui² 'náan²³ 'e³ rɨ²ñí²ra'³ je² jen³¹na¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Móo³ra'³ jui³¹ je² ñe'n³²na²³ ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","'E³ jo̱³ ca²³jua'³ Tu³moo³². Ca²³sɨ'²³ Jesús: ―Juiin²³, 'a²³jia'³ ne³ra'³¹ 'e³ jiaa'³¹ guø'n³²nu³. ¿Jmii'³¹ lǿ² 'e³ juø'n³ 'nʉ³ 'e³ ne³ra'³¹ jui³¹ je² guø'n³²nu³? ");
INSERT INTO cnlNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Tu³moo³²: ―Jné² hua² 'i³ rɨ³løn³¹na¹ jui³¹. Jné² hua² 'i³ lʉn²³ ju²dsoo³¹. Jné² hua² 'i³ jmeen²³ 'e³ rɨ³ji̱'²³ dsa³ ca³cuaa³. 'A²³jia'³ rɨ²³tɨn²³ je² jen³¹ Ñu'n²³ dsa³ 'i³ 'a²³jia'³ sɨ³táan³ quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","'U² cu²ru'³ cuiin²³na'³ jné² ca³quie̱e̱², cuiin²³na'³ Ñu'n²³ 'u² cu²ru'³ la'³. 'E³ quie'²³ mɨ³la³cuiin²³na'³ Ñu'n²³. Qui² mɨ³ñiin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","'E³ jo̱³ ca²³jua'³ Bi³lii²: ―Juiin²³, rɨ²'en³¹nu³ jnee'³¹ Ñu'n². Líi² 'nɨɨ'n³¹ la'³. 'A²³'e³ ma²³ xa³ 'nee³ra'³¹ ―ca²³jua'³ Bi³lii². ");
INSERT INTO cnlNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Bi³lii²: ―Bi³lii², mɨ³la³huǿø³ 'e³ jen³¹na¹ quia̱'n²³²na¹ 'nee'²³. ¿'A² juø'² 'a²³jia'³ cuiin²³nu³ jné²? Qui² mɨ³ŋøn³² Ñu'n²³ dsa³ 'i³ mɨ³ŋøn³² jné². ¿Jmii'³¹ lǿ² 'e³ juø'n³ 'nʉ³: “Rɨ²'en³¹nu³ jnee'³¹ Ñu'n²”? ");
INSERT INTO cnlNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","'A²³jia'³ sɨ³táan³nu³ 'e³ ŋɨn²³ quia̱'n²³²na¹ Ñu'n²³, ¿mɨ³naa'³¹? 'e³ ŋɨ́³ quia̱'² jné² 'ñée² Ñu'n²³ co̱'³. 'E³ quie'²³ 'a²³la³ 'e³ la²³ 'náan²³ 'ñáan²³ lʉn²³ júu² 'e³ juøøn³²na²³ 'nee'²³. 'E³ quie'²³ la'³ ta² 'e³ jmeen²³. Ñu'n²³ 'i³ ŋɨ́³ quia̱'² jné² hua² 'i³ jmee²³ ta². ");
INSERT INTO cnlNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","'Ne'² rɨ²³sɨ²³táan³na'³ 'e³ ŋɨn²³ quia̱'n²³²na¹ Ñu'n²³, 'e³ ŋɨ́³ 'ñée² Ñu'n²³ quia̱'² jné² co̱'³. 'E³ quie'²³ xi³nu³ 'a²³jia'³ sɨ³táan³na'³ 'nɨɨ'n³¹ la'³, xa³ cɨ² 'e³ jmee²³ lii²³. Mɨ³jóo²ra'³ u²³juø'²³ 'e³ mɨ³jméen²³, ¿mɨ³naa'³¹? 'E³ jo̱³ hua² 'ne'² rɨ²³sɨ²³táan³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Rɨ²³jmée²³ ta² 'e³ jmeen²³ jné² dsa³ 'i³ sɨ³táan³ quia̱'² jné². 'E³ quie'²³ bi²³ cɨ² rɨ²³jmée²³ ta². Qui² ñe'n³²na²³ je² jen³¹ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","'E³ jo̱³ rɨ²jmeen²³² la²³jɨ³ 'e³ rɨ²ŋɨ́ɨ²ra'³ 'e³ juo'³ra'³ rɨ³løn³¹na'³ dsa³ quién²³na²³. Qui² 'náan²³ 'e³ rɨ²³mi²³gáan³ dsa³ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Xi³nu³ xa³ 'e³ rɨ²ŋɨ́ɨ²ra'³ 'e³ juo'³ra'³ rɨ³løn³¹na'³ dsa³ quién²³na²³, 'e³ jo̱³ rɨ²jmeen²³² la²³jɨ³ 'e³ rɨ²ŋɨ́ɨ²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Rɨ²jmée²ra'³ 'e³ la²³ mɨ³dxin²³ 'i'²³ quién²na'³ xi³nu³ 'náan²³na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","'E³ quie'²³ rɨ²juøøn³¹na¹ Ñu'n²³ 'e³ rɨ²³xíin²³ jia'³ cɨ'²³ 'i³ rɨ²³jmée²³ co̱²juø'¹ quién²na'³ 'i³ rɨ²³ŋɨ́²³ quia̱'² 'nee'²³ ca³cuaa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Espíritu Gáan³ quien³² Dios hua² 'í³. 'Ee²³ dsa³ ju²dsoo³¹ 'ñée². 'E³ quie'²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³cǿ̱n² Espíritu Gáan³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³. Qui² 'a²³jia'³ ñi³²te'²³ jmii'³¹ lǿn²³. 'A²³jia'³ cuiin²³te'²³. 'E³ quie'²³ cuiin²³na'³ 'nee'²³. Qui² jen³¹ quia̱'² 'nee'²³ rɨ³nɨ²³. 'E³ quie'²³ 'e³ cɨ² rɨ²³'íin³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","'A²³jia'³ rɨ²³cuaa'n²³na'³ 'nɨ́ɨn³na'³. Qui² rɨ²³güe'n²³na²³ co̱'³ 'e³ rɨ²gui³joon²³na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ca³juɨ² cɨ² jmee²³ 'e³ 'a²³jia'³ ma²³ rɨ²³ñín² jné² dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³. 'E³ quie'²³ rɨ²mǿn¹na'³ jné² 'nee'²³. Qui² rɨ²³ji̱i̱'n²³na²³ co̱'³. 'E³ jo̱³ rɨ²³ji̱i̱'n²³na'³ 'nee'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mɨ³rɨ³ti³ 'e³ rɨ²³ji̱i̱'n²³na²³ co̱'³, rɨ²móo²ra'³ 'e³ ŋɨn²³ quia̱'n²³²na¹ Ñu'n²³, 'e³ ŋɨ́²ra'³ quia̱'n²na'³ jné², 'e³ ŋɨn²³ 'ñáan²³ quia̱'n²³²na¹ 'nee'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Dsa³ 'i³ nuu³ júu² 'e³ mɨ³dxin²³ 'i'²³, 'i³ jmee²³ 'e³ la²³ lǿ², 'i³ 'í³ hua² 'i³ 'néen² jné². Li²³'néen² dsa³ 'í³ Ñu'n²³. 'E³ quie'²³ 'náan²³na²³ dsa³ 'í³ jné² co̱'³. Rɨ²jmeen²³² 'e³ li²³cuiin²³ jné² ca³quie̱e̱² dsa³ 'í³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","'E³ quie'²³ jo̱³ ca²³jua'³ Judas. 'A²³la³ 'í³ Judas Iscariote. Jia'³ cɨ'²³ dsa³ quien³² Jesús 'i³ xi̱i̱n³ Judas hua² 'í³. Ca²³sɨ'²³ Jesús: ―Juiin²³, ¿jmii'³¹ lǿ² 'e³ rɨ²jméen² 'e³ li²³cuiin²³na'³¹ 'nʉ³, 'e³ quie'²³ 'a²³jia'³ rɨ²jméen² 'e³ li²³cuiin²³ 'nʉ³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Judas: ―Rɨ²³jmée²³ 'e³ la²³ lǿ² júu² quián²³ dsa³ 'i³ 'néen² jné². Li²³'néen² dsa³ 'í³ Ñu'n²³. Rɨ²³li²³quia̱'n²na'³¹ dsa³ 'í³. Rɨ²ŋɨ²ra'³¹ quia̱'n²na'³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","'E³ quie'²³ 'a²³jia'³ jmee²³ 'e³ la²³ lǿ² júu² quián²³ dsa³ 'i³ 'a²³jia'³ 'néen² jné². 'E³ quie'²³ 'a²³la³ júu² quián²³ ca³quie̱e̱² 'e³ nuu³ra'³. Qui² nuu³ra'³ júu² quiee'³² Ñu'n²³ 'i³ ca²³xíin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Mɨ³juǿøn²na²³ 'nee'²³ júu² nɨ³ 'e³ la²³ jen³¹quien¹na¹ quia̱'n²³²na¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","'E³ quie'²³ rɨ²³güén³ Espíritu Gáan³ quien³² Dios 'i³ rɨ²³jmée²³ co̱²juø'¹ quién²na'³. Ñu'n²³ hua² rɨ²³xíin²³ 'i³ 'í³ 'e³ 'iin³¹na¹. Rɨ²³'ée²³ 'nee'²³ la²³jɨ³. Rɨ²³jmée²³ 'e³ li²³liin³²na'³ la²³jɨ³ 'e³ mɨ³juǿøn²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Jmeen²³ 'e³ rɨ²³gua³ ca²³tó̱o̱²³ 'óo²ra'³ 'e³ la²³ cuaa'n²³²na¹ 'nee'²³. Jmeen²³ 'e³ née² ca²³tó̱o̱²³ 'óo²ra'³ la²³ née² ca²³tó̱o̱²³ dsɨn²³ 'ñáan²³. 'E³ quie'²³ 'a²³jia'³ jmeen²³ 'e³ la²³ jmee²³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³. 'A²³jia'³ 'ne'² ŋɨ́³ 'óo²ra'³. 'A²³ rɨ³juø'n²³na'³ miin²³na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mɨ³nʉʉ³ra'³ 'e³ mɨ³juǿøn²na²³ 'nee'²³ 'e³ ñe'n³²na²³. 'E³ quie'²³ rɨ²³güe'n²³na²³ 'e³ rɨ²³gui²³joon²³na²³ 'nee'²³ co̱'³. 'U² cu²ru'³ 'náan²³na'³ jné² ca³quie̱e̱², bi²³ jɨn³ 'óo²ra'³ ma²mɨ³nʉʉ³ra'³ 'e³ ñe'n³²na²³ je² jen³¹ Ñu'n²³ 'u² cu²ru'³ la'³. Qui² gáan³ cɨ² Ñu'n²³ la²³ cɨ'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mɨ³juǿøn²na²³ 'nee'²³ 'e³ la²³ 'íi² rɨ²³lí³ la'³. Qui² 'náan²³ 'e³ rɨ²³sɨ²³táan³cɨ²na'³ mɨ³rɨ³li³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’'A²³jia'³ ma²³ ñúun³ 'e³ rɨ²lʉn²³² quia̱'n²³²na¹ 'nee'²³. Qui² mɨ³ ja³'ɨ́ɨn²³ mɨ²³sɨ²³quiʉ'² 'i³ rɨ³løn³¹ juii² mɨ³¹güii³ la³. 'E³ quie'²³ 'a²³'e³ xa³ 'e³ rɨ²³li'²³ 'ñée² quia̱'² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","'E³ quie'²³ jmeen²³ 'e³ la²³ ca²³dxi³ 'i'²³ Ñu'n²³ 'e³ juø'n²³ 'náan²³ 'e³ rɨ²³dsóo²³ dsɨ́² dsa³ mɨ³¹güii³ 'e³ 'náan²³na²³ 'ñée². Naa'n²³na'³ jo̱o̱²³na²³. Qui² mɨ³ dsoo³²ra². ");
INSERT INTO cnlNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’La²³ xen³ xoo'³¹ jø'² xen²³na²³ jné². La²³ xen³ juii² xoo'³¹ jø'² xen³ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","La²³ xen³ guoo³ jø'² xen³ dsa³ quién²³na²³. Quiʉʉ'³² juii² la²³jɨ³ mɨ³¹guoo³ 'e³ 'a²³jia'³ 'ɨɨ³ mɨɨ³¹. 'E³ quie'²³ te³ xii³² ca³juɨ² mɨ³¹guoo³ 'e³ 'ɨɨ³ mɨɨ³¹ 'e³ jua'³ cu²'ɨɨ³ cɨ² mɨɨ³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mɨ³je̱'n² la²³jɨ³ 'e³ 'lʉʉ'² quién²na'³ júu² 'e³ mɨ³juǿøn²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","'Ne'² 'e³ dxin²³²quien¹na'³ quia̱'n²na'³ jné² 'e³ la²³ dxin²³²na¹ 'ñáan²³ quia̱'n²³²na¹ 'nee'²³. Qui² 'a²³jia'³ rɨ²³lí³ juø'² rɨ²³'ɨ́ɨ²³ mɨɨ³¹ 'ñée² mɨ³¹guoo³ 'e³ 'a²³jia'³ ma²³ dxi²³² quia̱'² xoo'³¹. 'E³ quie'²³ la'³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ ta² quiee'³² Dios xi³nu³ 'a²³jia'³ dxin²³²na'³ quia̱'n²na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’La²³ xen³ xoo'³¹ jø'² xen²³na²³ jné². La²³ xen³ mɨ³¹guoo³ xen³na'³ 'nee'²³. Bi²³ jmee²³ ta² quiee'³² Dios dsa³ 'i³ dxin²³² quia̱'² jné², dsa³ 'i³ dxin²³²na¹ quia̱'n²³²na¹. Qui² 'a²³'e³ xa³ 'e³ rɨ²³lí³ juø'² rɨ²jmée²ra'³ xi³nu³ 'a²³jia'³ dxin²³²na'³ quia̱'n²na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Rɨ²³tá̱a̱n²te'²³ dsa³ 'i³ 'a²³jia'³ ma²³ dxin²³² quia̱'² jné². La²³ xen³ mɨ³¹guoo³ 'e³ to̱o̱³²te'²³ xen³. Li²³quiʉ̱ʉ̱³ mɨ³¹guoo³ jo̱o̱²³na²³. 'E³ quie'²³ jo̱³ dxi³cua̱a̱'n³te'²³ mɨ³¹guoo³ rɨ³quiʉ̱ʉ̱³. Too'²³te'²³ dxi³¹ji³ 'e³ cu²coo³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’'Ne'² 'e³ dxin²³²quien¹na'³ quia̱'n²na'³ jné². 'Ne'² li²³nee² quie'²³ 'óo²ra'³ júu² quián²³. Xi³nu³ rɨ²jmée²ra'³ la'³, rɨ²³'ién²na'³ te³ 'ee² 'noo³¹ 'e³ rɨ²ŋɨ́ɨ²ra'³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mi³gáan²na'³ Ñu'n²³ xi³nu³ jmee³ra'³ ta² quiee'³². La'³ hua² jmee³ra'³ lii²³ 'e³ dsa³ quién²³na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","'Néen² jné² Ñu'n²³. 'E³ quie'²³ la'³ jné² 'náan²³na²³ 'nee'²³ co̱'³. 'Náan²³ 'e³ rɨ²jmée²quie²³ra'³ 'e³ la²³ li²³'náan²³quien²³na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","'Náan²³na²³ 'nee'²³ xi³nu³ rɨ²jmée²quie²³ra'³ 'e³ la²³ mɨ³dxin²³ 'i'²³. 'E³ quie'²³ la'³, 'néen² jné² Ñu'n²³ 'e³ jua'³ mɨ³jméen²³ 'e³ la²³ ca²³dxi³ 'i'²³ quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Mɨ³juǿøn²na²³ 'nee'²³ la'³ 'e³ juø'n²³ 'náan²³ 'e³ rɨ²jmeen²³² 'e³ li²³jɨn³ 'óo²ra'³ la²³ jɨn³ dsɨn²³ 'ñáan²³. 'Náan²³ 'e³ ti²cø̱'n²³ li²³jɨn³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","'E³ la³ júu² 'e³ dxin²³ 'i'²³ quién²na'³: 'Ne'² li²³'náan²³na'³ uu'n²na'³ 'e³ la²³ 'náan²³na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Dsa³ 'i³ rɨ²³jú̱n³ 'e³ 'iin³¹ dsa³ 'i³ bi²³ dxʉ́²³ lʉ²³ quia̱'² bi²³ 'néen² dsa³ 'i³ bi²³ dxʉ́²³ lʉ²³ quia̱'². 'E³ quie'²³ 'a²³'i̱³ xen³ 'i³ bi²³ cɨ² 'néen² dsa³ 'i³ bi²³ dxʉ́²³ lʉ²³ quia̱'² la²³ cɨ'²³ dsa³ 'i³ rɨ²³jú̱n³ 'e³ 'iin³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","'E³ quie'²³ rɨ³løn³¹na'³ dsa³ 'i³ bi²³ dxʉ́²³ lʉn²³ quia̱'n²³²na¹ xi³nu³ rɨ²jmée²ra'³ 'e³ la²³ dxin²³ 'i'²³ quién²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","'A²³jia'³ ma²³ juøøn³²na²³ 'nee'²³ mozos. Qui² 'a²³jia'³ ñi³² mozo 'e³ jmii'³¹ jmee²³ juii². Dsa³ 'i³ bi²³ dxʉ́²³ lʉn²³ quia̱'n²³²na¹ mɨ³juǿøn²na²³ 'nee'²³. Qui² mɨ³juǿøn²na²³ 'nee'²³ la²³jɨ³ 'e³ ca²³sɨ'²³ jné² Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","'A²³la³ 'nee'²³ 'i³ ca²³'néen²³na'³ jné². Jné² hua² 'i³ ca²³'náan²³na²³ 'nee'²³. Ca²³'uøøn²³²na¹ 'nee'²³ 'e³ juø'n²³ 'náan²³ 'e³ cu³jmée²ra'³ ta² quiee'³² Dios. 'Náan²³ 'e³ 'a²³jia'³ te³ rɨ²³gua'²³ ta² 'e³ cu³jmée²ra'³. Xi³nu³ rɨ²jmée²ra'³ la'³, rɨ²³cuǿø²³ 'nee'²³ Ñu'n²³ te³ 'ee² 'noo³¹ 'e³ rɨ²ŋɨ'³¹ra'³ 'e³ juo'³ra'³ rɨ³løn³¹na'³ dsa³ quién²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","'E³ jo̱³ dxin²³ 'i'²³ quién²na'³ 'e³ li²³'náan²³na'³ uu'n²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’'A²³jia'³ ta³dsɨ³² ñin³² 'nee'²³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³. 'E³ quie'²³ 'ne'² li²³liin³²na'³ 'e³ xe̱'n² cɨ² 'a²³jia'³ ta³dsɨ³²te'²³ ñin³²te'²³ jné², cɨ̱ɨ̱n³ cɨ² 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","'Néen² 'nee'²³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³ 'u² cu²ru'³ røø³ jmee³ra'³ quia̱'n²na'³. Qui² 'néen² uu'n² la²³ co̱³quie'² dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³. 'E³ quie'²³ 'a²³jia'³ ta³dsɨ³² ñin³² 'nee'²³ dsa³ 'í³ 'e³ jua'³ 'a²³jia'³ røø³ jmee³ra'³ quia̱'n²na'³. Qui² mɨ³'náan²³na²³ 'nee'²³ 'e³ rɨ²'uøøn³²na'³ jee²³² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","'Ne'² li²³liin³²na'³ júu² 'e³ mɨ³juǿøn²na²³ 'nee'²³: “'A²³jia'³ gáan³ cɨ² mozo la²³ cɨ'²³ juii².” Mɨ³jme'²³te'²³ jné². 'E³ quie'²³ la'³ rɨ²³jme'²³te'²³ 'nee'²³ co̱'³. Xi³nu³ rɨ²³jmóo²te'²³ 'e³ la²³ mɨ³juø'n², 'e³ quie'²³ la'³ rɨ²³jmóo²te'²³ 'e³ la²³ rɨ²juo'² 'nee'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Rɨ²³jme'²³te'²³ 'nee'²³ la²³jɨ³ 'e³ lø³² la'³ 'e³ jua'³ rɨ³løn³¹na'³ dsa³ quién²³na²³. Qui² 'a²³jia'³ cuiin²³te'²³ 'ñée² 'i³ ca²³xíin²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’'A²³'e³ dsoo² xa³ quie'²te'²³ 'u² cu²ru'³ 'a²³jia'³ güén²³na²³ 'e³ ca²³lʉ́n²³ quia̱'n²³²na¹te'¹. 'E³ quie'²³ 'a²³'e³ ma²³ xa³ sɨ³quié̱³ rɨ²³jua'³te'²³ 'e³ 'a²³jia'³ dsɨn³²te'²³ dsoo². ");
INSERT INTO cnlNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","'A²³jia'³ ta³dsɨ³² ñin³² Ñu'n²³ dsa³ 'i³ 'a²³jia'³ ta³dsɨ³² ñin³² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","'A²³'e³ dsoo² xa³ quie'²te'²³ 'u² cu²ru'³ 'a²³jia'³ ca²³jméen²³ u²³juø'²³ jee²³² quiee'³²te'²³. 'A²³'i̱³ xen³ 'i³ lɨ'³ ca³jmée³ u²³juø'²³ 'e³ la²³ lǿ² 'e³ ca²³jméen²³. 'E³ quie'²³ mɨ³ŋó²³te'²³ la²³jɨ³ 'e³ mɨ³jméen²³. Juø'n³ quie'²³ la'³, 'a²³jia'³ ta³dsɨ³²te'²³ ñin³²te'²³ jné². 'A²³jia'³ ta³dsɨ³²te'²³ ñin³²te'²³ Ñu'n²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","'E³ quie'²³ sɨ³lí³ la'³. Qui² 'ne'² rɨ²³lí³ 'e³ la²³ to̱o̱²³ ley quiee'³²te'²³: “'A²³jia'³ ta³dsɨ³²te'²³ ñin³²te'²³ jné², juø'n³ quie'²³ 'a²³'e³ dsoo² xa³ 'e³ la²³ jmeen²³.” ");
INSERT INTO cnlNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’'E³ quie'²³ rɨ²³güén³ mɨ³¹güii³ Espíritu Gáan³ 'i³ rɨ²³jmée²³ co̱²juø'¹ quién²na'³. Rɨ²sɨɨn³¹na¹ 'i³ 'í³ 'e³ rɨ²³ja²³'ɨ́ɨn²³ naan³ jí̱i̱n² je² jen³¹ Ñu'n²³. Lʉ²³ ju²dsoo³¹ 'ñée². Rɨ²³lín³ dsa³ ñi³. Rɨ²³jmée²³ júu² 'e³ 'i̱i̱² sɨɨ'³¹ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","'E³ quie'²³ la'³ 'nee'²³. 'Ne'² rɨ²³lín³na'³ dsa³ ñi³. Qui² ŋɨ́²ra'³ quia̱'n²na'³ jné² cɨ'²³ mɨ²xe̱'n³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Mɨ³juǿøn²na²³ 'nee'²³ la'³ 'e³ juø'n²³ 'a²³jia'³ 'náan²³ 'e³ rɨ²tu³¹ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Rɨ²³'uøøn³te'²³ 'nee'²³ ñʉ'²³ 'ñʉ́² je² mi³gáan³ dsa³ Dios. Rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ rɨ²³jua'³te'²³ 'e³ jmoo³²te'²³ ta² quiee'³² Dios 'e³ rɨ²³jŋɨ'n²³te'²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","La'³ rɨ²³jmóo²te'²³. Qui² 'a²³jia'³ lɨ'³ ca³la³cuiin²³te'²³ Ñu'n²³. 'E³ quie'²³ la'³ 'a²³jia'³ lɨ'³ ca³la³cuiin²³te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mɨ³juǿøn²na²³ 'nee'²³ la'³. 'Ne'² li²³liin³²na'³ 'e³ jmii'³¹ mɨ³juǿøn²na²³ 'nee'²³ mɨ³rɨ³ti³ jmɨ́ɨ² 'e³ rɨ²³jí̱i̱n²na'³ la'³. ’'A²³jia'³ ca²³juǿøn²na²³ 'nee'²³ mɨ²xe̱'n³¹ cɨ² júu² nɨ³. Qui² jen³¹quien¹na²³ quia̱'n²³²na¹ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","'E³ quie'²³ mɨ³tɨ́³ 'e³ ñe'n³²na²³ je² jen³¹ Ñu'n²³ 'i³ ca²³xíin²³ jné². Juø'n³ quie'²³ la'³, 'a²³'i̱³ xen³na'³ 'i³ ŋɨɨ'³²ra'³ jné² júu²: “¿Jiaa'³¹ guø'n³²nu³?” ");
INSERT INTO cnlNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'E³ quie'²³ mɨ³juǿøn²na²³ 'nee'²³ 'e³ ñe'n³²na²³. 'E³ jo̱³ hua² 'e³ bi²³ mɨ³ŋɨ́³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","'E³ quie'²³ rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Bi²³ cɨ² dxʉ́²³ quién² 'nee'²³ 'e³ ñe'n³²na²³. Qui² 'a²³jia'³ rɨ²³güén³ 'i³ rɨ²³jmée²³ co̱²juø'¹ quién²na'³ 'u² cu²ru'³ 'a²³jia'³ ñe'n³²na²³. 'E³ quie'²³ rɨ²sɨɨn³¹na¹ 'i³ rɨ²³jmée²³ co̱²juø'¹ quién²na'³ mɨ³rɨ³dxe'n³²na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Rɨ²³'ée²³ dsa³ 'ñée² mɨ³rɨ³güén³. Rɨ²³'é²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ xa³ dsoo² quiee'³²te'²³. Rɨ²³'é²³ 'e³ jmii'³¹ cu³lø³¹ jui³¹ 'e³ rɨ³lø³¹ ca³dsaan³². Rɨ²³'é²³ 'e³ dxa²³ ta² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Xa³ dsoo² quiee'³²te'²³. Qui² 'a²³jia'³ sɨ³táan³te'²³ quia̱'²te'²³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Xa³ jui³¹ 'e³ rɨ³lø³¹ ca³dsaan³². Qui² ñe'n³²na²³ je² jen³¹ Ñu'n²³. 'E³ jo̱³ 'a²³jia'³ ma²³ rɨ²møn²³na'³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Dxa²³ ta² Dios. Qui² sɨ³née²³ ta² quiee'³² mɨ²³sɨ²³quiʉ'² 'i³ rɨ³løn³¹ juii² mɨ³¹güii³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ñúun³ cɨ² xa³ 'e³ 'náan²³ rɨ²juøøn³¹na¹ 'nee'²³ 'u². 'E³ quie'²³ 'a²³jia'³ rɨ²³lí³ juø'² rɨ²núu²ra'³ xe̱'n² rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","'E³ quie'²³ rɨ²³cuǿ²³ jui³¹ quién²na'³ Espíritu Gáan³ 'i³ 'e²³ ju²dsoo³¹ mɨ³rɨ³güén³. Rɨ²³'ée²³ 'nee'²³ la²³jɨ³ ju²dsoo³¹. Qui² 'a²³la³ 'e³ la²³ 'née²³ 'ñée² 'e³ rɨ²³lʉ́²³. 'E³ quie'²³ rɨ²³lʉ́²³ 'e³ la²³ rɨ²³núu²³ 'ñée². Rɨ²³'ée²³ 'nee'²³ 'e³ jmii'³¹ cu³lø³¹ rɨ²³lí³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Rɨ²³mi²³gáan³ jné². Qui² rɨ²³sɨ'²³ 'nee'²³ júu² quián²³ 'e³ rɨ²³núu²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","'E³ quián²³ la²³jɨ³ 'e³ xa³ quie'² Ñu'n²³. 'E³ jo̱³ mɨ³juǿøn²na²³ 'nee'²³ 'e³ rɨ²³sɨ'²³ 'nee'²³ júu² quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Mɨ³ rɨ²³tɨ́²³ 'e³ 'a²³jia'³ ma²³ rɨ²mǿn¹na'³ jné² ca³juɨ² ca³ŋɨ́n³. 'E³ quie'²³ 'e³ cɨ² rɨ²³tɨ́²³ 'e³ rɨ²mǿn¹na'³ jné² co̱'³ cɨ'²³. Qui² ñe'n³²na²³ je² jen³¹ Ñu'n²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","'E³ quie'²³ jo̱³ xen³ dsa³ quien³² 'i³ ca²³sɨ'²³ uu'n² i²³la³ i²³nɨ³: ―¿Jmii'³¹ lǿ² 'e³ mɨ³sɨ'²³ jne²: “Mɨ³ rɨ²³tɨ́²³ 'e³ 'a²³jia'³ ma²³ rɨ²mǿn¹na'³ jné² ca³juɨ² ca³ŋɨ́n³, 'e³ quie'²³ 'e³ cɨ² rɨ²³tɨ́²³ 'e³ rɨ²mǿn¹na'³ jné² co̱'³ cɨ'²³”? ¿'Ee² lǿ² mɨ³jua'³ la'³ cu²ne²ra²? Mɨ³jua'³ 'ñée²: “Qui² ñe'n³²na²³ je² jen³¹ Ñu'n²³”. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿'Ee² lǿ² mɨ³jua'³: “Mɨ³ rɨ²³tɨ́²³”? 'A²³jia'³ ta³jmee³ra² 'i'²³ xú̱n³ ―ca²³jua'³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ñi³² Jesús 'e³ 'née²³te'²³ rɨ²³ŋɨ'²³te'²³ júu² 'ñée². 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²: ―¿'A² xín³ 'ín³na'³ 'e³ 'a²³jia'³ ta³jmee³ra'³ 'i'²³ 'e³ 'ee² lǿ² mɨ³juø'n²: “Mɨ³ rɨ²³tɨ́²³ 'e³ 'a²³jia'³ ma²³ rɨ²mǿn¹na'³ jné² ca³juɨ² ca³ŋɨ́n³, 'e³ quie'²³ 'e³ cɨ² rɨ²³tɨ́²³ 'e³ rɨ²mǿn¹na'³ jné² co̱'³ cɨ'²³”? ");
INSERT INTO cnlNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Rɨ²'o'²ra'³ 'e³ juo'³ra'³ ŋɨ́³ 'óo²ra'³. 'E³ quie'²³ bi²³ li²³'née²³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³. 'E³ cɨ² li²³xa³ u²³ŋɨ́³ dsɨ́ɨ² quién²na'³. 'E³ quie'²³ rɨ²³dxen³ co̱'³. Qui² 'e³ cɨ² li²³jɨn³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sɨ³li³xa³ u²³ŋɨ́³ dsɨ́ɨ² quie'² mɨ́³ 'i³ sɨ³lɨ'n²³. Qui² mɨ³tɨ́³ jmɨ́ɨ² la'³ quie'². 'E³ quie'²³ 'a²³jia'³ ma²³ líi²³ 'e³ jmii'³¹ ca²³la²³cuu'²³ quie'² ma²mɨ³'áa³ 'i'²³ 'e³ xen³ xi³yu̱u̱n³ quien³². Qui² bi²³ 'née²³ 'e³ xen³ xi³yu̱u̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","'E³ quie'²³ la'³ quién² 'nee'²³ rɨ³nɨ²³. Xa³ u²³ŋɨ́³ dsɨ́ɨ² quién²na'³. 'E³ quie'²³ 'e³ cɨ² rɨ²møn³¹na¹ 'nee'²³ co̱'³. 'E³ jo̱³ li²³jɨn³ 'óo²ra'³. 'A²³'i̱³ ma²³ xen³ 'i³ rɨ²³jmée²³ 'e³ rɨ²³ŋɨ́²³ 'óo²ra'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Mɨ³rɨ³ti³ jmɨ́ɨ² jo̱³, 'a²³'e³ xa³ 'e³ rɨ²ŋɨ'³¹ra'³ jné². Rɨ²juøøn³¹na¹ 'nee'²³ ju²dsoo³¹: Rɨ²³cuǿø²³ 'nee'²³ Ñu'n²³ te³ 'ee² 'noo³¹ 'e³ rɨ²ŋɨ'³¹ra'³ 'e³ la²³ xi̱i̱n²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Xi³'lɨ² jmɨ́ɨ² rɨ³nɨ²³ 'a²³'e³ xa³ 'e³ mɨ³ŋɨ́ɨ²ra'³ 'e³ la²³ xi̱i̱n²³na²³. Ŋɨɨ²ra'³ jo̱o̱²³na²³. Jo̱³ hua² rɨ²³'ién²na'³. 'E³ jo̱³ ti²cø̱'n²³ li²³jɨn³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Júu² rɨ³jnɨ³ hua² mɨ³lʉn²³ quia̱'n²³²na¹ 'nee'²³. 'E³ quie'²³ mɨ³ rɨ²³tɨ́²³ 'e³ rɨ²lʉn²³² jɨn³ quia̱'n²³²na¹ 'nee'²³. Qui² rɨ²juøøn³¹na¹ 'nee'²³ jɨn³ 'e³ jmii'³¹ lǿn²³ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jmɨ́ɨ² jo̱³ hua² rɨ²ŋɨɨ'³¹ra'³ Ñu'n²³ 'e³ la²³ xi̱i̱n²³na²³. 'A²³jia'³ ma²³ li²³'ne'² 'e³ jné² hua² rɨ²ŋɨn²³²na¹ júu² 'e³ ŋɨɨ³ra'³, 'e³ rɨ²juøøn³¹na¹ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Qui² 'néen² 'nee'²³ 'ñée² Ñu'n²³ 'e³ jua'³ 'náan²³na'³ jné², 'e³ jua'³ sɨ³táan³na'³ 'e³ güén²³na²³ naan²³na²³ jí̱i̱n² je² jen³¹ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Naan²³na²³ je² jen³¹ Ñu'n²³ 'e³ güén²³na²³ mɨ³¹güii³. 'E³ quie'²³ mɨ³tɨ́³ 'e³ rɨ²bǿn³na²³ mɨ³¹güii³. Mɨ³tɨ́³ 'e³ ñe'n³²na²³ je² jen³¹ Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","'E³ quie'²³ jo̱³ ca²³jua'³ te'²³ dsa³ quien³²: ―Mɨ³la³jɨn³ lʉ́n². 'A²³jia'³ ma²³ lʉ́n² júu² rɨ³jnɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mɨ³dsóo²³ dsɨ³ra'³¹ 'e³ máan³ la²³jɨ³. 'A²³jia'³ ma²³ 'ne'² 'e³ rɨ²³ŋɨ́ɨ²³ dsa³ júu² 'e³ jmii'³¹ lǿ² júu² 'e³ lʉ́n². 'E³ jo̱³ hua² sɨ³táan³na'³¹ 'e³ güén²³nu³ naan³nu³ jí̱i̱n² je² jen³¹ Dios ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―¿'A² sɨ³táan³na'³ rɨ³nɨ²³? ");
INSERT INTO cnlNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mɨ³ rɨ²³tɨ́²³, 'e³ quie'²³ mɨ³tɨ́³ rɨ³nɨ²³, 'e³ rɨ²sáa² rɨ²jǿn²na'³. 'E³ cɨ² cu³guiin³²na'³ quién²na'³ cɨ'³ la²³ jø̱n³na'³. Rɨ²cuaa'n²³²na'³ jné² jø̱n³na²³ 'ñáan²³. 'E³ quie'²³ 'a²³jia'³ li²³'ñáan²³ ca³quie̱e̱². Qui² quia̱'² jné² Ñu'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mɨ³juǿøn²na²³ 'nee'²³ la'³. Qui² 'náan²³ rɨ²jmeen²³² 'e³ rɨ²³gua³ ca²³tó̱o̱²³ 'óo²ra'³. Rɨ²³jmóo² 'e³ xa³ u²³ŋɨ́³ dsɨ́ɨ² quién²na'³ te'²³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³. 'E³ quie'²³ 'ne'² li²³jɨn³ 'óo²ra'³. Qui² lɨ'n²na²³ ma²ca¹jméen¹ qui³ quia̱'n²³²na¹ la²³jɨ³ 'e³ guaa² mɨ³¹güii³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ma²ca¹jua'³ la'³ Jesús, ca²³jóo² yʉʉ'³¹. 'E³ quie'²³ jo̱³ ca²³jua'³: ―Ñu'n², mɨ³tɨ́³ jmɨ́ɨ². 'Ne'² rɨ²mi³gáan²nu³ jné² ja̱a̱n³ 'e³ la²³ rɨ²³lí³ juø'² rɨ²mi³gáan²na²³ 'nʉ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Qui² mɨ³dxen²³²nu³ guaan²³ la²³jɨn³ dsa³ 'e³ juø'n³ 'naan³ rɨ²jmeen²³² 'e³ rɨ²³ji̱i̱'²³te'²³ ca³cuaa³ la²³jɨn³ 'i³ ca²³cuǿn²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Qui² rɨ³ji̱'²³ ca³cuaa³ dsa³ 'i³ cuiin²³ 'nʉ³ quia̱'² jné². Qui² jø̱n³ 'nʉ³ hua² 'i³ xen³ 'i³ rɨ³løn³¹nu³ Dios ca³quie̱e̱². Jesucristo jné² 'i³ ca²³xíin²³nu³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Mɨ³mi³gáan²na²³ 'nʉ³ mɨ³¹güii³ la³. Mɨ³mi³'ien²³na²³ ta² 'e³ ca²³cuǿøn²nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","'E³ jo̱³, Ñu'n², rɨ²jméen² 'e³ li²³gáan³na²³ mɨ³rɨ³'aa³ 'i'²³ 'e³ jen³¹na¹ quia̱'n²³²na¹ 'nʉ³. Rɨ²jméen² 'e³ li²³gáan³na²³ co̱'³ la²³ gáan³na²³ quia̱'n²³²na¹ 'nʉ³ ma²'ii³¹ rɨ²³lí³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ca²³'néen²³nu³ dsa³ 'i³ ca²³'uǿøn² jee²³² quiee'³² dsa³ mɨ³¹güii³. Ca²³cuǿn²nu³ jné² dsa³ 'í³. 'E³ jo̱³ mɨ³juǿøn²na²³te'²³ jmii'³¹ lǿn²³nu³. Te'²³ dsa³ quien³²hua²nu³ te'²³ dsa³ 'i³ ca²³cuǿn²nu³ jné². Jmoo³²te'²³ 'e³ la²³ lǿ² júu² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mɨ³dsóo²³ dsɨ́²te'²³ 'e³ 'nʉ³ hua² ca²³cuǿøn²nu³ jné² la²³jɨ³ 'e³ xa³ quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Qui² mɨ³juǿøn²na²³te'²³ júu² 'e³ ca²³xi'n²nu³ jné². Mɨ³jmóo²te'²³ quie'²te'²³ júu² jo̱³. Ñi³²te'²³ ca³quie̱e̱² 'e³ ca²³áan²³ jí̱i̱n² je² jen³¹nu³. Mɨ³ca³táan³te'²³ 'e³ 'uǿøn²nu³ ca²³xíin²³nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’'E³ jo̱³ 'ǿn²³na²³ te'²³ dsa³ 'í³ 'e³ la²³ lʉn²³ quia̱'n²³²na¹ 'nʉ³. 'A²³la³ 'í³ te'²³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³ 'i³ 'ǿn²³na²³. 'E³ quie'²³ 'ǿn²³na²³ te'²³ dsa³ 'i³ ca²³cuǿn²nu³ jné². Qui² te'²³ 'i³ quien³²hua²nu³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","'I³ quien³²nu³ 'uǿøn²nu³ la²³jɨn³ dsa³ quién²³na²³. 'E³ quie'²³ la'³ 'i³ quién²³na²³ 'ñáan²³ la²³jɨn³ dsa³ quien³²nu³. 'I³ 'í³ hua² 'i³ mi³gáan³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’'A²³jia'³ ma²³ rɨ²cuaa'n²³na²³ mɨ³¹güii³ la³. Qui² ñe'n³²na²³ je² jen³¹nu³. 'E³ quie'²³ rɨ²³cuaa'n²³cɨ²te'¹ mɨ³¹güii³ la³ miin²³. Rɨ²juøøn³¹na¹ 'nʉ³, Ñu'n² 'i³ bi²³ rɨ³jɨ́n²: Cu²jmée³ ta² ju²³bíi²³ quien³²nu³ 'e³ rɨ²mi³quin²³nu³ te'²³ dsa³ 'i³ ca²³cuǿn²nu³ jné². La'³ hua² rɨ²³lín³te'²³ co̱o̱³ júu² 'e³ la²³ rɨ³løn³¹na² co̱o̱³ júu² miin²³na². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ju²³bíi²³ quien³²nu³ mɨ³jmée³ ta² 'e³ mɨ³mi³quin²³na²³ dsa³ 'i³ ca²³cuǿn²nu³ jné² la²³huøø'n³¹ la²³ mɨ³ñin²³ quia̱'n²³²na¹te'¹. Mɨ³'áan²³na²³te'²³. 'E³ quie'²³ mɨ³guoo'³² jø̱n³ 'i³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³gua'²³. Qui² 'ne'² rɨ²³lí³ 'e³ la²³ to̱o̱²³ ji³ quien³²nu³ 'e³ rɨ²³lí³. 'E³ quie'²³ 'a²³'i̱³ xen³ cɨ² 'i³ mɨ³guoo'³². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’'E³ jo̱³ ñe'n³²na²³ je² jen³¹nu³. Lʉn²³ júu² la³ 'e³ la²³ jen³¹cɨ²na¹ mɨ³¹güii³. Qui² 'náan²³ 'e³ rɨ²jmeen²³² 'e³ bi²³ li²³jɨn³ dsɨ́²te'²³ 'e³ la²³ jɨn³ dsɨn²³ 'ñáan²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mɨ³juǿøn²na²³te'²³ júu² quien³²nu³. 'E³ quie'²³ 'a²³jia'³ ta³dsɨ³² dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³ ñin³² te'²³ dsa³ 'í³. Qui² 'a²³jia'³ rɨ³løn³¹ uu'n²te'²³. 'E³ quie'²³ la'³ jné² co̱'³. 'A²³jia'³ rɨ³løn³¹na¹ uu'n²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","'A²³jia'³ juøøn³²na²³ 'nʉ³ 'e³ rɨ²tøøn³¹ te'²³ dsa³ 'í³ xe̱'n² rɨ³nɨ²³ 'e³ rɨ²³'uǿøn²te'²³ mɨ³¹güii³. 'E³ quie'²³ ŋɨ'n²³na²³ 'nʉ³ 'e³ rɨ²'áan¹nu³te'²³ 'e³ la²³ 'a²³'e³ xa³ rɨ²³li'²³ juø'² 'i³ 'a²³jia'³ dxún²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","'A²³jia'³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³ te'²³ dsa³ 'í³. 'E³ quie'²³ la'³ jné² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Cu²jmée³ ju²dsoo³¹ quien³²nu³ 'e³ rɨ²³'íin³ guaan³² te'²³ dsa³ 'i³ 'ǿn²³na²³. Qui² rɨ³lø³¹ ju²dsoo³¹ júu² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mɨ³sɨ́ɨn²na²³te'²³ jee²³² quiee'³² dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³ 'e³ la²³ ca²³xíin²³nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Jné² dxen²³na²³ 'ñáan²³ guaan³² 'e³ juø'n²³ rɨ²jmeen²³² co̱²juø'¹ quie'²te'²³. Qui² 'náan²³ 'e³ rɨ²³jmée²³ ju²dsoo³¹ quien³²nu³ 'e³ rɨ²³'íin³ guaan³² te'²³ dsa³ 'i³ 'ǿn²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’'E³ quie'²³ 'a²³la³ 'nɨɨ'n³¹ te'²³ dsa³ la³ hua² 'i³ 'ǿn²³na²³ 'e³ la²³ lʉn²³ quia̱'n²³²na¹ 'nʉ³. 'Ǿn²³na²³ la²³jɨn³ dsa³ 'i³ cɨ² rɨ²³sɨ²³táan³ quia̱'² jné² mɨ³rɨ³nʉʉ³te'²³ júu² 'e³ rɨ²³'ɨ́ɨ²³ te'²³ dsa³ la³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Qui² 'náan²³ 'e³ rɨ²³lín³te'²³ co̱o̱³ júu² la²³jɨn³te'²³. Rɨ²juøøn³¹na¹ 'nʉ³, Ñu'n²: Jmeen³ ta² quia̱'n²nu³ jné². 'E³ quie'²³ la'³ jmeen²³ ta² quia̱'n²³²na¹ 'nʉ³ co̱'³. 'E³ quie'²³ 'náan²³ 'e³ rɨ²³jmóo²te'²³ ta² quia̱'²te'²³ jné². Jo̱³ hua² rɨ²³sɨ²³táan³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³ 'e³ ca²³xíin²³nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mɨ³jméen²³ 'e³ gáan³ dsa³ 'í³ 'e³ la²³ lǿ² ca²³jméen² 'uǿøn²nu³ 'e³ gáan³na²³ jné². Qui² 'náan²³ 'e³ rɨ²³lín³te'²³ co̱o̱³ júu² 'e³ la²³ rɨ³løn³¹na² co̱o̱³ júu² miin²³na². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jné² jmeen²³ ta² quia̱'n²³²na¹te'¹. Jmeen³ 'nʉ³ ta² quia̱'n²nu³ jné² co̱'³. Qui² 'náan²³ 'e³ rɨ²³lín³te'²³ co̱o̱³ júu² ca³quie̱e̱². Jo̱³ hua² rɨ²³dsóo²³ dsɨ́² dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³ 'e³ ca²³xíin²³nu³ jné². Jo̱³ hua² rɨ²³dsóo²³ dsɨ́²te'²³ 'e³ 'náan²³nu³ te'²³ dsa³ 'í³ 'e³ la²³ 'náan²³nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Rɨ²juøøn³¹na¹ 'nʉ³, Ñu'n²: 'Náan²³ 'e³ li²³quia̱'² jné² je² ñe'n³²na²³ te'²³ dsa³ 'i³ ca²³cuǿn²nu³ jné². Qui² 'náan²³ 'e³ rɨ²³jóo²te'²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ mɨ³jméen² 'e³ gáan³na²³ 'e³ juø'n³ 'náan²³nu³ jné² cɨ'²³ ma²'ii³¹ rɨ²³lí³ mɨ³¹güii³. ");
INSERT INTO cnlNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Rɨ²juøøn³¹na¹ 'nʉ³, Ñu'n² 'i³ bi²³ jmee²³ ca³dsaan³²: 'A²³jia'³ cuiin²³ 'nʉ³ te'²³ dsa³ 'i³ mi³quí̱i̱n²³ la²³jɨ³ 'e³ guaa² mɨ³¹güii³. 'E³ quie'²³ jné² cuiin²³na²³ 'nʉ³. Ñi³² te'²³ dsa³ la³ 'e³ ca²³xíin²³nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mɨ³juǿøn²na²³te'²³ 'e³ jmii'³¹ lǿn²³nu³. 'E³ quie'²³ rɨ²juøøn³¹cɨ²te'¹ co̱'³. Qui² bi²³ 'náan²³nu³ jné². 'Náan²³ 'e³ li²³'néen²te'²³ dsa³ 'e³ la²³ 'náan²³nu³ jné². 'Náan²³ 'e³ rɨ²ŋɨn²³² quia̱'n²³²na¹te'¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ma²mɨ³líi² mɨ³lʉ́³ Jesús júu² jo̱³, ŋóo² quia̱'² dsa³ quien³². Ca²³'øn³ guo³ Cedrón. 'Ŋóo² guo³ jo̱³ xa³ co̱o̱³ jee²³² 'mo³ je² 'í² Jesús quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","'E³ quie'²³ ñi³² je² núu²³ Judas 'i³ ca²³'nɨ́ɨn²³ Jesús. Qui² to̱'²³ ŋɨ́³ núu²³ Jesús quia̱'² dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","'E³ quie'²³ jo̱³ ca²³dxóo² Judas quia̱'² co̱o̱³ ta'n² dsa³ 'láa³ quien³² dxi² juɨɨ³. 'E³ quie'²³ ca²³dxóo² quia̱'² ca³dxáan² dsa³ 'láa³ quien³² te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ fariseo. Xe̱e̱'³te'²³ mɨ³¹'u³ linternas. Xe̱e̱'³te'²³ joo³¹ loo³ 'e³ rɨ³so̱'² ji³. Xe̱e̱'³te'²³ boo'³¹ 'e³ la²³ ca²³guín²³te'²³ ca²³xe̱'n³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","'E³ quie'²³ ñi³² 'ñée² Jesús la²³jɨ³ 'e³ rɨ²³ji̱'²³. 'E³ jo̱³ ŋóo² caan²³ te'²³ dsa³ 'i³ rɨ²³so̱'² quie'². Ca²³sɨ'²³ te'²³ dsa³ 'í³: ―¿'I̱i̱² sɨɨ'³¹ 'naa'n²³na'³? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Jesús: ―Jesús dsa³ Nazaret 'nee'n²³²na'³¹. ―'I³ 'í³ jné² ―ca²³jua'³ Jesús. 'E³ quie'²³ xi'n²³ quia̱'² dsa³ 'láa³ Judas 'i³ ca²³'nɨ́ɨn²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ma²ca¹jua'³ Jesús “'i³ 'í³ jné²”, ca²³ji̱i̱'n³² i²³co'³ te'²³ dsa³ 'láa³. Ca²³'lǿn²³te'²³ 'uǿ²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","'E³ quie'²³ co̱'³ cɨ'²³ ca²³jua'³ Jesús: ―¿'I̱i̱² sɨɨ'³¹ 'naa'n²³na'³ ru'³? ―Jesús dsa³ Nazaret 'nee'n²³²na'³¹ ―ca²³jua'³te'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","'E³ jo̱³ ca²³jua'³ Jesús: ―Mɨ³juǿøn²na²³ 'nee'²³ 'e³ 'i³ 'í³ jné². Xi³nu³ jné² hua² 'naa'n²³na'³, rɨ²cuǿ²ra'³ júu² 'e³ rɨ²³sɨ²³guiin³² dsa³ 'i³ quia̱'n²³²na¹ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jo̱³ hua² ca²³lǿ²³ 'e³ la²³ lǿ² 'e³ cɨ² mɨ³lʉ́³ Jesús 'e³ rɨ²³lí³ 'e³ la²³ ca²³jua'³: “'A²³'i̱³ xen³, cu³xi³ jø̱n³, 'i³ mɨ³guoo'³² 'i³ ca²³cuǿn²nu³ jné²”. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Quie̱³ boo'³¹ Muun³² Peen²³². 'E³ quie'²³ jo̱³ sø'n² boo'³¹. Ca²³quiu'n² dsa³ 'i³ xi̱i̱n³ Malco 'i³ rɨ³løn³¹ mozo quien³² juii² jmii³ dsa³. Ca²³quiʉ'² lo³guo² jaan²³ 'e³ dxʉ́²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","'E³ quie'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³²: ―'Me² co̱'³ boo'³¹ quien³²nu³. Qui² 'ne'² rɨ²³jí̱i̱n²³ 'e³ la²³ ca²³jua'³ Ñu'n²³ 'e³ rɨ²³jí̱i̱n²³, ¿mɨ³naa'³¹? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","'E³ quie'²³ jo̱³ sø̱'n²te'²³ Jesús te'²³ dsa³ 'láa³ quien³² dxi² juɨɨ³ quia̱'² juii²te'¹ quia̱'² te'²³ dsa³ 'láa³ quien³² te'²³ juii² dsa³ Israel. Ca²³'ñúun²³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Quie'² Anás, jmii³ mɨ²³quie'² Caifás, i²jøn²³te'²³ xe̱'n². Qui² Caifás rɨ³løn³¹ juii² jmii³ dsa³ ji̱i̱³ ñi³ jo̱³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","'I³ 'í³ Caifás 'i³ ca²³jua'³ ca²³sɨ'²³ jia'³ cɨ'²³ te'²³ juii² dsa³ Israel 'e³ bi²³ cɨ² dxʉ́²³ xi³nu³ rɨ²³jú̱n³ jø̱n³ dsa³ 'e³ 'iin³¹ la²³jɨn³ dsa³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ca²³qui̱'³ Jesús Muun³² Peen²³². 'E³ quie'²³ la'³, ŋáan² jné² tu³cɨ̱ɨ̱n²³na²³ co̱'³. 'E³ quie'²³ jo̱³ 'ín²na²³ quie'² juii² jmii³ dsa³ quia̱'n²³²na¹ Jesús. Qui² cuiin²³na²³ juii² jmii³ dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","'E³ quie'²³ ca²³noo³ 'oo'² je² rɨ³jnɨ³ xi²dxi³² Muun³² Peen²³². 'E³ jo̱³ ca²³bǿn³na²³ co̱'³ jné² 'i³ cuiin²³ juii² jmii³ dsa³. I²lʉ́n¹ quia̱'n²³²na¹ xii'³ mɨ́³ 'i³ 'aa³ 'oo'². Ca²³ŋɨn²³²na¹ Peen²³² je² rɨ³jnɨ³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","'E³ quie'²³ jo̱³ ca²³jua'³ xii'³ mɨ́³ 'i³ 'aa³ 'oo'² 'e³ ca²³sɨ'²³ Peen²³²: ―Dsa³ quien³² Jesús hua² 'nʉ³, ¿mɨ³naa'³¹? ―ca²³jua'³. ―'A²³la³ 'í³ jné² xú̱n³ ―ca²³jua'³ Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Rɨ³so̱'² ji³ too'³ je² ca²³ji̱i̱'n³ ji³ mozos quia̱'² dsa³ 'láa³. Qui² bi²³ güi'³. Té̱e̱n³te'²³ coo³¹ ji³. Dxo'²³te'²³ ji³. Xi'n²³ quia̱'² te'²³ dsa³ 'í³ Peen²³². Dxo'²³ ji³ 'ñée² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","'E³ quie'²³ jo̱³ ca²³ŋɨ́ɨ³ júu² juii² jmii³ dsa³. Ca²³sɨ'²³ Jesús 'e³ 'i̱i̱² sɨɨ'³¹ dsa³ quien³², 'e³ jmii'³¹ cu³lø³¹ júu² 'e³ 'e²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ juii² jmii³ dsa³: ―Mɨ³lʉ́n²³ i²³ñín² la²³nɨ³ je² nuu³ la²³jɨn³ dsa³. Tén³ la²³ mɨ³'éen²³na²³ dsa³, juø'n³ quie'²³ ñʉ'²³ 'ñʉ́² 'e³ té̱e̱³ la²³jɨ³ juɨɨ³ quiee'³² dsa³ Israel je² mi³gáan³te'²³ Dios, juø'n³ quie'²³ ñʉ'²³ 'ñʉ́² gáan³ je² sɨ³ñii'n²³ la²³jɨn³ dsa³ Israel. 'A²³'e³ xa³ 'e³ ca²³lʉ́n²³ je² rɨ³'mo². ");
INSERT INTO cnlNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿'Ee² lǿ² ŋɨɨ'n³²nu³ jné² júu²? Rɨ²³juun³ rɨ²ŋɨɨ'n³¹ júu² dsa³ 'i³ ca²³núu³ 'e³ jmii'³¹ ca²³lʉ́n²³. Qui² ñi³² miin²³ 'e³ jmii'³¹ ca²³lʉ́n²³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ma²mɨ³líi² mɨ³jua'³ la'³ Jesús, ca²³jnóo² 'oo² Jesús jø̱n³ dsa³ 'láa³ quien³² te'²³ juii² jmii³ dsa³ 'i³ xi'n²³ mɨ³lén² caan²³. Ca²³jua'³: ―¿'A² lǿn³nu³ 'e³ dxi³ji̱i̱n³¹ rɨ²juɨɨ'n³¹ la'³ juii² jmii³ dsa³? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ 'láa³: ―Xi³nu³ 'a²³jia'³ dxi³ji̱i̱n³¹ 'e³ la²³ mɨ³lʉ́n²³, rɨ²jméen² júu² 'e³ 'ee² júu² 'e³ mɨ³lʉ́n²³ 'e³ 'a²³jia'³ dxi³ji̱i̱n³¹. 'E³ quie'²³ xi³nu³ mɨ³lʉ́n²³ ju²dsoo³¹, ¿'ee² lǿ² mɨ³jnaan²³² 'aan²³? ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","'E³ jo̱³ ca²³dxi³ 'i'²³ Anás 'e³ sɨ³jǿn²³te'²³ Jesús quie'² Caifás, 'i³ rɨ³løn³¹ juii² jmii³ dsa³. Rɨ³'ñuun³¹ Jesús ca²³jøn²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Xi'n²³ quie'²³ coo³¹ ji³ Muun³² Peen²³² 'e³ jua'³ dxo'²³ ji³. 'E³ quie'²³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Peen²³²: ―Dsa³ quien³² hua² 'nʉ³, ¿mɨ³naa'³¹? ―ca²³sɨ'²³te'²³. Co̱'³ cɨ'²³ ca²³jua'³ Peen²³²: ―'A²³la³ 'í³ jné² xú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","'E³ quie'²³ ca²³lʉ́³ jø̱n³ mozo quien³² juii² jmii³ dsa³, dsa³ 'i³ xen³ quie'² dsa³ 'i³ ca²³quiʉ'² Peen²³² lo³guo². Ca²³jua'³: ―Mɨ³mǿn²na²³ 'nʉ³ jee²³² 'mo³ quia̱'n²nu³ Jesús, ¿mɨ³naa'³¹? ―ca²³sɨ'²³ Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","'E³ quie'²³ co̱'³ cɨ'²³ ca²³jua'³ Peen²³²: ―'A²³jia'³ jmɨ́ɨ² xú̱n³. 'E³ quie'²³ jo̱³ tǿ²³ 'nɨɨ'². ");
INSERT INTO cnlNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","'E³ quie'²³ jo̱³ xe̱'n² tá³ ca²³'uǿøn²te'²³ quie'² Caifás. Ca²³i²jøn²³te'²³ Jesús 'ñʉ² dxi² juɨɨ³. 'E³ quie'²³ 'a²³jia'³ ca²³ta'n²³ miin²³ xi²ñʉ'¹. Qui² lǿn³ miin²³ 'e³ bi²³ li²³'lʉ'n²te'²³ cu²ru'³ rɨ²³ta'n²³te'²³ xi²ñʉ'¹. 'A²³jia'³ ca²³lǿ²³ juø'² ca²³e'²te'²³ ma²ca¹jmóo¹te'²³ mɨ²juee'³ pascua 'u² cu²ru'³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","'E³ jo̱³ ca²³bǿn³ xi²dxi³² Pilato 'e³ jua'³ rɨ²³lʉ́²³ quia̱'² te'²³ dsa³ Israel. Ca²³jua'³: ―¿'Ee² dsoo² cuø³ra'³ quie'² dsa³ la³? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Pilato: ―'A²³jia'³ ca³jɨ̱ɨ̱'n²³²na'³¹ dsa³ la³ 'u² cu²ru'³ jmee²³ 'e³ dxʉ́²³ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","'E³ quie'²³ ca²³jua'³ Pilato: ―Tée²ra'³ miin²³na'³. Cu³jmée²ra'³ 'i'²³ xi² xa³ dsoo² quiee'³² 'e³ la²³ lǿ² ley quien³²na'³ ―ca²³jua'³. 'E³ jo̱³ ca²³jua'³ te'²³ juii² dsa³ Israel. Ca²³sɨ'²³te'²³ Pilato: ―'A²³'e³ xa³ ca³dsaan³² quiée²ra'³¹ 'e³ rɨ²jŋɨ'n²³²na'³¹ dsa³ miin²³na'³¹ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","La'³ cu³lø³¹ ca²³lǿ²³ 'e³ la²³ rɨ²³lí³ 'e³ la²³ ca²³jua'³ Jesús ma²ca¹jua'³ 'e³ jmii'³¹ cu³lø³¹ rɨ²³jú̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","'E³ quie'²³ jo̱³ 'í² co̱'³ xi²ñʉ'¹ Pilato. Ca²³tøø³ Jesús. Ca²³jua'³: ―¿'A² rey quien³² dsa³ Israel hua² 'nʉ³? ");
INSERT INTO cnlNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","'E³ jo̱³ ca²³jua'³ Jesús: ―¿'A² 'i'²³ quien³²nu³ 'uǿøn²nu³ 'e³ juø'n³ la'³? ¿'A² xen³ dsa³ 'i³ mɨ³sɨ'²³ 'nʉ³ 'e³ la'³ rɨ³løn³¹na¹? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","'E³ jo̱³ ca²³jua'³ Pilato: ―¿'A² lǿn³nu³ 'e³ dsa³ Israel jné²? Te'²³ dsa³ uu'n²hua²nu³, te'²³ juii² jmii³ dsa³, te'²³ 'i³ 'í³ hua² 'i³ mɨ³jɨ̱'n² 'nʉ³ quián²³. ¿'Ee² 'noo³¹ mɨ³jméen² 'e³ jua'³te'²³ 'e³ xa³ dsoo² quien³²nu³? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","'E³ jo̱³ ca²³jua'³ Jesús: ―'E³ quie'²³ 'a²³la³ mɨ³¹güii³ la³ rɨ³løn³¹na¹ rey. 'U² cu²ru'³ mɨ³¹güii³ la³ rɨ³løn³¹na¹ rey, mɨ³dxá³ qui³ dsa³ quién²³na²³ 'e³ la²³ 'a²³jia'³ rɨ²³sø̱'n² jné² te'²³ juii² dsa³ Israel 'u² cu²ru'³ la'³. 'E³ quie'²³ 'a²³la³ dsa³ mɨ³¹güii³ 'i³ ca²³cuǿ³ cua̱a̱n²tu² quián²³ ―ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","'E³ jo̱³ ca²³jua'³ Pilato. Ca²³sɨ'²³ Jesús: ―'E³ quie'²³ rey hua² rɨ³løn³¹nu³ sɨ³júu². 'E³ jo̱³ ca²³jua'³ Jesús: ―Rɨ³løn³¹na¹ rey xú̱n³. Mɨ³jue'n² la'³ 'uǿøn²nu³. Ca²³la²³xen²³na²³, 'e³ quie'²³ güén²³na²³ mɨ³¹güii³, 'e³ juø'n²³ rɨ²juøøn³¹na¹ dsa³ ju²dsoo³¹. Nuu³ júu² quián²³ la²³jɨn³ dsa³ 'i³ 'née²³ rɨ²³núu²³ ju²dsoo³¹. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","'E³ jo̱³ ca²³jua'³ Pilato. Ca²³sɨ'²³ Jesús: ―¿'Ee² 'noo³¹ 'øn³ 'e³ juø'n³ ju²dsoo³¹? ―ca²³jua'³. Ma²mɨ³líi² mɨ³jua'³ la'³ Pilato, ŋóo² co̱'³ je² té̱e̱n³ dsa³ Israel. Ca²³jua'³: ―'A²³'e³ dsoo² xa³ quie'² dsa³ la³, lǿn³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","'E³ quie'²³ xa³ tɨ³² 'i'²³ quien³²na'³ 'e³ laan²³na²³ jø̱n³ dsa³ 'i³ 'iún² i²³ñí² cɨ'³ la²³ co̱o̱³ ji̱i̱³ ñi³ 'e³ la²³ sɨ³tɨ́²³ mɨ²juee'³ pascua. ¿'A² juø'² 'noo³ra'³ 'e³ rɨ²láan¹na²³ quién²na'³ 'i³ sɨ'²³te'²³ rey quien³² dsa³ Israel? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","'E³ quie'²³ co̱'³ cɨ'²³ ca²³yo'³ ca²³tǿ²³ dsa³ Israel. Ca²³jua'³te'²³: ―'¡A²³la³ 'i³ 'ǿn²³nu³ nɨ³ rɨ²láan¹nu³! ¡Rɨ²láan¹nu³ Barrabás! ―ca²³jua'³te'²³. Qui² Barrabás xi̱i̱n³ jø̱n³ dsa³ 'i̱i̱³ 'i³ 'iún² i²³ñí². ");
INSERT INTO cnlNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","'E³ quie'²³ jo̱³ ca²³dxi³ 'i'²³ Pilato 'e³ rɨ²³jmín²te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ca²³jmóo² dsa³ 'láa³ co̱o̱³ jmíi² guoo³ tó̱o̱² 'e³ ca²³jmóo²te'²³ lɨɨ'² sɨɨ³. To̱'²te'²³ mɨ²dxi² Jesús. Ca²³qui'n²te'²³ cuo̱o̱³ cuaa³ 'e³ yʉ̱́ʉ̱³ laa'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ca²³guín²³te'²³ caan²³ Jesús. Ca²³jua'³te'²³: ―¡Que viva rey quien³² dsa³ Israel! 'E³ quie'²³ jo̱³ ca²³jnóo²te'²³ ñi². ");
INSERT INTO cnlNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Co̱'³ cɨ'²³ ca²³bǿn³ Pilato. Ca²³sɨ'²³ dsa³: ―Jóo²ra'³. Qui² rɨ²juøøn³¹te'¹ 'e³ rɨ²³jén²³te'²³ xi²dxi³² caan²³na'³. Qui² 'náan²³ 'e³ rɨ²móo²ra'³ 'e³ lǿn³na²³ 'ñáan²³ 'e³ 'a²³'e³ dsoo² xa³ quie'². ―La'³ ca²³jua'³ Pilato. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","'E³ quie'²³ jo̱³ ca²³bǿn³ Jesús. 'Iʉ² lɨɨ'² sɨɨ³ tó̱o̱² mɨ²dxi². Quii'³ cuo̱o̱³ cuaa³ 'e³ yʉ̱́ʉ̱³ laa'³. 'E³ jo̱³ ca²³jua'³ Pilato: ―¡'I³ la³ dsa³ 'í³! ");
INSERT INTO cnlNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","'E³ quie'²³ ma²ŋøn³¹ Jesús te'²³ juii² jmii³ dsa³ quia̱'² te'²³ dsa³ 'láa³ quien³², ca²³yo'³ ca²³tǿ²³te'²³. Ca²³jua'³te'²³: ―¡Te̱e̱n²³² cruz! ¡Te̱e̱n²³² cruz! ―ca²³jua'³te'²³. 'E³ jo̱³ ca²³jua'³ Pilato. Ca²³sɨ'²³ dsa³: ―Tée²ra'³ miin²³na'³ jo̱o̱²³na²³. Te̱e̱n²³²na'³ cruz miin²³na'³. Qui² lǿn³na²³ 'ñáan²³ 'e³ 'a²³'e³ dsoo² xa³ quie'² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","'E³ jo̱³ ca²³jua'³ te'²³ juii² dsa³ Israel. Ca²³sɨ'²³ Pilato: ―Xa³ ley quiée²ra'³¹, ¿mɨ³naa'³¹? 'E³ jo̱³ 'ne'² rɨ²³jú̱n³ dsa³ nɨ³. Qui² jua'³ 'ñée² 'e³ rɨ³løn³¹ Jo̱o̱³¹ Dios. La'³ cu³lø³¹ dsoo² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","'E³ quie'²³ bi²³ cɨ² ca²³jue'n² 'ñée² Pilato ma²ca¹núu³ júu² quiee'³² te'²³ juii² dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Co̱'³ cɨ'²³ 'í² xi²ñʉ'¹. Ca²³sɨ'²³ Jesús: ―¿Jiaa'³¹ xen³nu³? ―ca²³jua'³. 'E³ quie'²³ 'a²³jia'³ ca²³'í̱n² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","'E³ jo̱³ ca²³jua'³ Pilato. Ca²³sɨ'²³ Jesús: ―¿'A² 'a²³jia'³ rɨ²lʉ́n² quia̱'n²nu³ jné²? Máan³, ¿mɨ³naa'³¹?, 'e³ xa³ ca³dsaan³² quián²³ 'e³ rɨ²láan¹na²³ 'nʉ³, 'e³ xa³ ca³dsaan³² quián²³ 'e³ rɨ²te̱e̱n²³²na¹ 'nʉ³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Pilato: ―'A²³'e³ xa³ ca³dsaan³² quién²nu³ 'e³ rɨ²jmee'n³¹nu³ jné² 'u² cu²ru'³ 'a²³jia'³ ca²³cuǿø²³ 'nʉ³ ta² Dios. 'E³ quie'²³ bee'² cɨ² dsoo² xa³ quie'² dsa³ 'i³ mɨ³jɨ̱ɨ̱'n³² jné² quién²nu³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","'E³ quie'²³ jo̱³ 'née²³ Pilato 'e³ rɨ²³láan² Jesús. 'E³ quie'²³ co̱'³ cɨ'²³ bi²³ ca²³yo'³ ca²³tǿ²³ dsa³ Israel. Ca²³jua'³te'²³: ―¡'A²³jia'³ dxʉ́²³ lʉ́n² quia̱'n²nu³ dxi² juɨɨ³ gáan³ César xi³nu³ rɨ²láan¹nu³ dsa³ nɨ³! ¡Qui² nɨ́ɨn³ quia̱'² dxi² juɨɨ³ César dsa³ 'i³ jua'³ 'e³ rɨ³løn³¹ rey 'ñée²! ―La'³ ca²³jua'³ dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ma²ca¹núu³ Pilato júu² 'e³ ca²³lʉ́³te'²³, ca²³jøn²³ Jesús xi²dxi³² je² rɨ³jó³ cú̱u̱². Gabatá xi̱i̱n³ je² núu²³ júu² hebreo. 'E³ quie'²³ jo̱³ ca²³guó³ Pilato sii³¹ je² to̱'²³ jmee²³ 'i'²³ xi² xa³ dsoo² quiee'³² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ca²³tɨ́³ jmɨ́ɨ² 'e³ mi³tɨ́ɨ²³te'²³ la²³jɨ³ 'e³ 'ne'², 'e³ quie'²³ la²³ 'áa²³ mɨ²juee'³ pascua. La²³ca̱a̱n³ dxaan²³ ñi'² ca²³lʉ́³ Pilato. Ca²³sɨ'²³ dsa³ Israel: ―¡'I³ la³ rey quien³²na'³! ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","'E³ quie'²³ bi²³ ca²³yo'³ ca²³tǿ²³ te'²³ dsa³ Israel. Ca²³jua'³te'²³: ―¡Tée² dsa³ nɨ³! ¡Tée² dsa³ nɨ³! ¡Te̱e̱n²³² cruz! ―ca²³jua'³te'²³. 'E³ jo̱³ ca²³jua'³ Pilato. Ca²³sɨ'²³ dsa³: ―¿'A² 'noo³ra'³ 'e³ rɨ²te̱e̱n²³²na¹ cruz rey quien³²na'³? ―ca²³jua'³. 'E³ quie'²³ ca²³jua'³ te'²³ juii² jmii³ dsa³: ―Jø̱n³ César hua² 'i³ rɨ³løn³¹ rey quien³²na². 'A²³'i̱³ xen³ jia'³ cɨ'²³ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","'E³ jo̱³ Pilato ca²³jɨ̱'n² Jesús quie'² te'²³ dsa³ 'i³ rɨ²³te̱e̱n³ cruz. Ca²³tøø³te'²³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","'Ñée² Jesús quie̱³ cruz 'e³ la²³ ŋóo² je² xi̱i̱n³ cuo̱o̱'³ mee²³ cua'² mɨ²dxi² dsa³. Gólgota xi̱i̱n³ je² núu²³ júu² hebreo. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Núu²³ ca²³te̱e̱n³te'²³ cruz Jesús quia̱'² cɨ² áan²³ dsa³ 'i³ ca²³te̱e̱n³te'²³ cruz joo³¹ i²³la³ i²³nɨ³. Dxoo'³¹ ca²³te̱e̱n³te'²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ca²³jmée³ Pilato 'uø'² 'e³ ca²³té̱e̱²te'²³ cruz: “Jesús dsa³ Nazaret, Rey quien³² dsa³ Israel”. La'³ jua'³ 'uø'² 'e³ ca²³té̱e̱²te'²³ cruz. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Juɨ́ɨn²³ dsa³ Israel 'i³ ca²³jóo² 'uø'². Qui² mɨ³lén² la²³ jee²³² juɨɨ³ Jerusalén je² ca²³te̱e̱n³te'²³ cruz Jesús. To̱o̱²³ 'uø'² 'nɨ³ 'iin³² júu², júu² hebreo quia̱'² júu² latín quia̱'² júu² griego. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","'E³ quie'²³ jo̱³ ca²³jua'³ te'²³ juii² jmii³ dsa³ quien³² dsa³ Israel. Ca²³sɨ'²³te'²³ Pilato: ―'A²³ rɨ³te̱e̱n³² 'e³ “Rey quien³² dsa³ Israel”. Bi²³ cɨ² dxʉ́²³ rɨ²te̱e̱n³¹ “Jné² rɨ³løn³¹na¹ Rey quien³² dsa³ Israel, jua'³ dsa³ la³”. La'³ cu³lø³¹ rɨ²te̱e̱n³¹ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","'E³ jo̱³ ca²³jua'³ Pilato: ―Cu²tó̱o̱¹ quie'²³ 'e³ la²³ mɨ³té̱e̱n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ma²mɨ³líi² mɨ³te̱e̱n³te'²³ cruz Jesús, ca²³jmóo²te'²³ quiʉ̱́³ taa'² 'mɨɨ'³ quiee'³². Co̱o̱³ taa'² ca²³co̱o̱²³ cɨ'³ la²³ jø̱n³ dsa³ 'láa³. 'E³ quie'²³ co̱³quie'² hua² cuo̱o̱³ cuaa³ 'e³ 'a²³'e³ xa³ je² rɨ³ji̱i̱'n³² sú̱n² 'e³ rɨ³lø³¹ co̱³xi³jmen²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ uu'n²te'²³: ―'A²³jia'³ 'ne'² rɨ²guii²ra² cuo̱o̱³ cuaa³. 'E³ quie'²³ rɨ²coo²ra² 'e³ la²³ rɨ²³'aa²³ 'i'²³ 'e³ 'i̱i̱² sɨɨ'³¹ li²³røøn³ 'e³ rɨ²³co̱o̱²³ cuo̱o̱³ 'e³ cuaa³ ―ca²³jua'³te'²³. La'³ hua² ca²³jmóo²te'²³. Qui² 'ne'² rɨ²³lí³ 'e³ la²³ to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: “Ca²³to'²³te'²³ dxóo² 'mɨɨ'³ quián²³. Xa³ mɨɨ³¹ 'e³ ca²³co'²te'²³ 'e³ la²³ rɨ²³'aa²³ 'i'²³ 'e³ 'i̱i̱² sɨɨ'³¹ li²³røøn³ 'e³ rɨ²³co̱o̱²³ cɨ'³ la²³ co̱o̱³ 'noo³¹.” 'E³ quie'²³ jo̱³ ca²³jmóo² la'³ dsa³ 'láa³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","'E³ quie'²³ xi'n²³ coo³¹ cruz je² ta̱a̱n²³ Jesús xóo² 'ñée² Jesús quia̱'² tǿ² 'i³ xi̱i̱n³ la²³ xi̱i̱n³ xóo², 'i³ rɨ³løn³¹ mɨ²³quie'² Cleofas, quia̱'² I²³lee² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ŋǿn² xóo² Jesús. Ŋǿn² jné² dsa³ quien³² 'i³ bi²³ 'néen² co̱'³ 'e³ xi'n²³na²³ mɨ³lén². 'E³ jo̱³ ca²³jua'³. Ca²³sɨ'²³ xóo²: ―Nii²³², 'i³ la³ 'é̱e̱² ja̱a̱n³ ―ca²³jua'³ ca²³'én² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","'E³ quie'²³ jo̱³ ca²³jua'³ ca²³sɨ'²³ jné²: ―'I³ la³ 'é̱e̱² xaan³ ―ca²³jua'³ ca²³'én² xóo². 'E³ quie'²³ jo̱³ ca²³tǿøn²na²³ xóo² Jesús xi²ñʉ'¹ quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ñi³² Jesús 'e³ mɨ³líi² ta² quiee'³². 'E³ jo̱³ ca²³jua'³: ―Dxíin³ dsɨn²³ jmɨɨ³. ―La'³ ca²³jua'³ 'e³ la²³ rɨ²³lí³ 'e³ la²³ to̱o̱²³ ji³ júu² quiee'³² Dios 'e³ rɨ²³lí³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Née² mɨ³lén² co̱o̱³ huɨ̱́ɨ̱²³ 'e³ 'o² jmɨɨ'³¹ mɨ²jø'² vino 'e³ ji̱i̱'³. 'E³ quie'²³ jo̱³ ca²³'a'²³te'²³ joo³ 'e̱'³ jmɨɨ'³¹ mɨ²jø'². Ca²³ti²³dxí²te'²³ joo³ co̱o̱³ sɨɨ² 'e³ xi̱i̱n³ hisopo. Ca²³jñʉ́ʉ²³te'²³ 'oo² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ca²³i̱'³ Jesús jmɨɨ'³¹ mɨ²jø'² vino 'e³ ji̱i̱'³. Jo̱³ tu³ ca²³jua'³: ―Mɨ³líi². 'E³ quie'²³ jo̱³ ŋóo² rɨ³'in³² mɨ²dxi². Ca²³tʉ́² dxí³ ta'n². 'E³ quie'²³ jo̱³ jú̱n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ca²³tɨ́³ jmɨ́ɨ² 'e³ mi³tɨ́ɨ²³te'²³ la²³jɨ³ 'e³ 'ne'². 'E³ quie'²³ la²³ 'áa²³ mɨ²juee'³ pascua. 'E³ jo̱³ 'a²³jia'³ 'née²³ te'²³ juii² dsa³ Israel 'e³ ta̱a̱n²³ quie'²³ cruz dsa³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. 'E³ quie'²³ bi²³ cɨ² gáan³ jmɨ́ɨ² jo̱³. Qui² rɨ³lø³¹ mɨ²juee'³ pascua. 'E³ jo̱³ ca²³lʉ́³ te'²³ juii² dsa³ Israel quia̱'² Pilato. Ca²³sɨ'²³te'²³ 'e³ cu²dxi³ 'i'²³ 'e³ cu²'níi¹te'²³ mee²³ tɨɨ² dsa³ 'i³ ta̱a̱n²³ cruz. Jo̱³ hua² rɨ²³lí³ juø'² rɨ²³jiáan²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","'E³ jo̱³ i²guín¹ dsa³ 'láa³ i²'nii³te'²³ mee²³ tɨɨ² dsa³ 'i³ ta̱a̱n²³ cruz 'e³ ja³¹ xe̱'n² 'e³ la²³ ca²³dxi²³guín²³te'²³. 'E³ quie'²³ la'³, i²'nii³te'²³ mee²³ tɨɨ² dsa³ 'i³ ta̱a̱n²³ jia'³ cɨ'²³ jaan²³ Jesús co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","'E³ quie'²³ jo̱³ i²guín¹te'²³ je² ta̱a̱n²³ Jesús. Ŋó²³te'²³ 'e³ mɨ³jú̱n²³. 'E³ jo̱³ 'a²³jia'³ ca²³'níi²te'²³ mee²³ tɨɨ². ");
INSERT INTO cnlNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","'E³ quie'²³ 'ɨ'² 'mo³ xʉ̱ʉ̱'³ tɨɨn²³ Jesús jø̱n³ dsa³ 'láa³. Xe̱'n² quie'²³ jo̱³ ca²³tu̱u̱³ jmɨ²³'ǿn² quia̱'² jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ca²³maan²³ 'e³ jmii'³¹ ca²³lǿ²³. 'E³ jo̱³ rɨ³løn³¹na¹ dsa³ ñi³. Maan²³ 'e³ lʉn²³ ju²dsoo³¹. Qui² 'náan²³ 'e³ rɨ²³sɨ²³táan³na'³ 'nee'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","La'³ ca²³lǿ²³ 'e³ la²³ rɨ²³lí³ 'e³ la²³ to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: “Cu³xi³ co̱o̱³ mee²³ 'a²³jia'³ rɨ²³'níi²te'²³”. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Xa³ jia'³ cɨ'²³ to̱o̱²³ co̱'³ je² to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³: “'E³ cɨ² rɨ²³jóon²te'²³ dsa³ 'i³ 'ɨ'n²te'²³”. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Rɨ³løn³¹ dsa³ quien³² Jesús jø̱n³ dsa³ 'i³ xen³ juɨɨ³ Arimatea 'i³ xi̱i̱n³ Søø³². 'E³ quie'²³ 'a²³jia'³ ca²³jmée³ júu² la'³ 'e³ jua'³ 'ñaa'n²³ te'²³ juii² dsa³ Israel. 'E³ quie'²³ jo̱³ i²joon³ Pilato Søø³². Ca²³sɨ'²³ Pilato 'e³ 'née²³ rɨ²³jiáan² 'lɨ́ɨ³ Jesús 'e³ rɨ²³tøø³. Ca²³cuǿ³ júu² la'³ Pilato. 'E³ jo̱³ ŋóo² Søø³². Ca²³tee³ 'lɨ́ɨ³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","'E³ quie'²³ la'³ ca²³dxóo² Nicodemo co̱'³. 'I³ 'í³ hua² 'i³ i²joon³ Jesús 'e³ 'uøø²³ mɨ²xe̱'n³¹. Quie̱³ co̱o̱³ gui²³guiá³ kilos tʉʉ² juɨ² mɨ³róo³ 'e³ xi̱i̱n³ mirra 'e³ rɨ³coo'n³² quia̱'² jia'³ cɨ'²³ 'e³ xi̱i̱n³ áloes. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","'E³ quie'²³ jo̱³ ca²³pee'n³te'²³ 'lɨ́ɨ³ Jesús sɨɨ'n³² 'mɨɨ'³ taa³. Ca²³'li'²³te'²³ tʉʉ² juɨ² mɨ³róo³ jee²³² sɨɨ'n³² 'mɨɨ'³ jo̱³ 'e³ la²³ ca²³pee'n³te'²³ 'lɨ́ɨ³ Jesús. Qui² la'³ cu³lø³¹ tɨ³² 'i'²³ quiee'³² dsa³ Israel je² xen³ 'lɨ́ɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Xa³ je² té̱e̱³ ca³juɨ² 'mo³ coo³¹ je² ca²³te̱e̱n³te'²³ cruz Jesús. Jee²³² 'mo³ xa³ co̱o̱³ too³ 'loo³ je² 'e³ cɨ² ca²³jmóo²te'²³ je² 'a²³jia'³ lɨ'³ ca³'áan²te'²³ 'lɨ́ɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mɨ³lén² la²³ too³ 'loo³ jo̱³ je² ca²³te̱e̱n³te'²³ cruz Jesús. 'E³ jo̱³ ca²³'áan²te'²³ Jesús too³ 'loo³ jo̱³. Qui² ca²³tɨ́³ jmɨ́ɨ² 'e³ mi³tɨ́ɨ²³ dsa³ Israel, la²³ 'áa²³ rɨ²³tɨ́²³ jmɨ́ɨ² je² tøø³ dsɨ́²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","I²³løn³¹ cɨ² jmɨ́ɨ² domingo ŋóo² I²³lee² too³ 'loo³. Li³'o̱o̱³ quie'²³ ca²³dxóo². 'E³ quie'²³ ŋó²³ 'e³ 'a²³jia'³ ma²³ née² cú̱u̱² 'e³ rɨ³jnɨ³ 'oo'² too³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","'E³ jo̱³ ŋóo² ca²³la²³dxí² i²joon³ Muun³² Peen²³² quia̱'² jné² dsa³ quien³² Jesús 'i³ bi²³ 'néen². Ca²³jua'³ I²³lee². Ca²³sɨ'²³ jnee'³¹: ―Mɨ³dxin³te'²³ 'lɨ́ɨ³ Juii³ra² too³ 'loo³, ¿mɨ³naa'³¹? 'A²³jia'³ ne³ra² 'e³ jiaa'³¹ mɨ³quiaan³te'²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","'E³ jo̱³ ca²³bǿn³ Peen²³². Ŋóo² quia̱'² jné². I²gui²³ra'³¹ too³ 'loo³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","I²gui²³ra'³¹ ca³ti³². 'E³ quie'²³ 'uaa'³ cɨ² ŋáan² jné² la²³ cɨ'²³ Peen²³². Jén²³ cɨ² ca²³tɨn³na²³ too³ 'loo³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ca²³ta̱a̱n²³ rɨ³'in³²na²³ 'e³ juø'n²³ rɨ²jóon¹ ñʉ'²³ too³ 'loo³. Ca²³maan²³ 'e³ ro̱o̱³ 'mɨɨ'³ 'e³ ca²³pee'n³te'²³ ñʉ'²³ too³ 'loo³. 'E³ quie'²³ 'a²³jia'³ 'ín²na²³ ca³quie̱e̱². ");
INSERT INTO cnlNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","'E³ quie'²³ jo̱³ ca²³dxóo² Muun³² Peen²³². 'Í² 'ñée² ñʉ'²³ too³ 'loo³. Ŋó²³ 'e³ ro̱o̱³ 'mɨɨ'³ 'e³ ca²³pee'n³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ŋó²³ paa²i² 'e³ ca²³láa²te'²³ mɨ²dxi². 'E³ quie'²³ 'a²³la³ ca³ti³² ro̱o̱³ quia̱'² 'mɨɨ'³ 'e³ ca²³pee'n³te'²³. Co̱³quie'² ro̱o̱³ rɨ³ben²³ paa²i². ");
INSERT INTO cnlNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","'E³ quie'²³ jo̱³ hua² 'ín²na²³ too³ 'loo³ jné² co̱'³. Ca²³maan²³ dxʉ́²³ 'e³ jmii'³¹ cu³lø³¹. 'E³ jo̱³ ca²³táan³na²³ 'e³ ca²³ji̱i̱'²³ co̱'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Qui² 'íi² rɨ²jmee²ra'³¹ 'i'²³ mɨ²jo̱³ 'e³ jmii'³¹ lǿ² 'e³ to̱o̱²³ ji³ júu² quiee'³² Dios je² jua'³ 'e³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³ji̱i̱'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","'E³ quie'²³ jo̱³ ŋo'²ra'³¹ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","'E³ quie'²³ ca²³noo³ 'oo'³² I²³lee² 'oo'² too³. 'Oo'³² quie'²³ la'³ tó̱o̱²³ rɨ³'in³². Ca²³jóo² ñʉ'²³ too³ 'loo³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","'E³ quie'²³ jo̱³ ŋǿn² áan²³ ángeles 'i³ quii'³ 'mɨɨ'³ taa³. Nee'n²³²te'¹ je² ca²³quiaan³te'²³ 'lɨ́ɨ³ Jesús xe̱'n². Jen³¹ jø̱n³ je² ca²³ro̱o̱²³ mɨ²dxi². Jen³¹ jø̱n³ je² ca²³ro̱o̱²³ tɨɨ². ");
INSERT INTO cnlNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ca²³jua'³ ángeles. Ca²³sɨ'²³ I²³lee²: ―Mɨ́³, ¿'ee² lǿ² 'a'n²? ―'Aa'n²³². Qui² mɨ³dxin³te'²³ 'lɨ́ɨ³ Juiin²³ ―ca²³jua'³ I²³lee²―. 'A²³jia'³ maan²³ 'e³ jiaa'³¹ mɨ³quiaan³te'²³ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ma²mɨ³líi² mɨ³jua'³ la'³ I²³lee², ca²³ji̱i̱n²³. 'A²³jia'³ xi²dsɨ́n³ ŋǿn² Jesús 'e³ xi'n²³ rɨ²³coo'². 'E³ quie'²³ 'a²³jia'³ ca²³la²³cuiin²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ I²³lee²: ―Mɨ́³, ¿'ee² lǿ² 'a'n²? ¿'I̱i̱² sɨɨ'³¹ 'naa'n²³nu³? 'E³ quie'²³ lǿn³ I²³lee² 'e³ dsa³ 'i³ mi³qui³ 'mo³ hua² 'í³. 'E³ jo̱³ ca²³jua'³ ca²³sɨ'²³ Jesús: ―Xi³nu³ 'nʉ³ mɨ³dxin²³nu³ 'lɨ́ɨ³, rɨ²juɨɨ'n³¹nu³ jné² 'e³ jiaa'³¹ mɨ³quiaan²³nu³. Qui² 'náan²³ rɨ²tøøn³¹ ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","―¡Ma³rii³¹! ―ca²³jua'³ Jesús. 'E³ jo̱³ ca²³ji̱i̱n²³ co̱'³ I²³lee². Ca²³sɨ'²³ Jesús: ―¡Raboni! ―ca²³jua'³. Qui² la'³ cu³lø³¹ jua'³te'²³ dsa³ 'e²³ ju²³jmii²³² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","'E³ quie'²³ ca²³jua'³ Jesús: ―'A²³ rɨ³jmø'n²³nu³ jné². Qui² 'a²³jia'³ mɨ³ joo'²³. Jmee²³ cɨ² 'e³ ñe'n³²na²³ yʉʉ'³¹ je² jen³¹ Ñu'n²³. 'E³ quie'²³ guo³. Cu³xii'² te'²³ ja̱a̱n³² 'e³ ñe'n³²na²³ yʉʉ'³¹ je² jen³¹ Ñu'n²³, 'e³ quie'²³ rɨ³løn³¹ Ñʉ'²ra² ca³ti³². Ñe'n³²na²³ je² jen³¹ Dios Juiin²³, 'e³ quie'²³ rɨ³løn³¹ Dios Juii³ra² ca³ti³². La'³ cu³xii'² te'²³ ja̱a̱n³². ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ I²³lee². ");
INSERT INTO cnlNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ŋóo² I²³lee². Ca²³xii'²³² dsa³ quien³² Jesús: ―Mɨ³mǿn²na²³ Juii³ra², ¿mɨ³naa'³¹? ―ca²³jua'³. 'E³ jo̱³ ca²³ji̱i̱n³ júu² 'e³ la²³ lǿ² 'e³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ma²mɨ³cu³'lóo³ jmɨ́ɨ² jo̱³, 'e³ quie'²³ jmɨ́ɨ² domingo, nee'n²³² ca³ti³² te'²³ dsa³ quien³² Jesús. Rɨ³jnɨ³ 'oo'² 'ñʉ³¹ je² nee'n²³²: Qui² bi²³ 'ñaa'n²³te'²³ te'²³ juii² dsa³ Israel. 'E³ quie'²³ jo̱³ ca²³dxóo² Jesús. 'Í² jee²³² quiee'³² dsa³ quien³². Ca²³jua'³. Ca²³sɨ'²³ dsa³ quien³²: ―Cu²née¹ ca²³tó̱o̱²³ 'óo²ra'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ma²mɨ³líi² mɨ³jua'³ la'³, ca²³'ée²³ dsa³ quien³² guoo³ quia̱'² tɨɨn²³. Bi²³ 'née²³ dsa³ quien³² ma²mɨ³ŋøn³²te'²³ Juii³ra². ");
INSERT INTO cnlNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―Cu²née¹ ca²³tó̱o̱²³ 'óo²ra'³. Qui² ca²³xíin²³ jné² Ñu'n²³. 'E³ quie'²³ la'³ sɨɨn³²na²³ 'nee'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ma²mɨ³líi² mɨ³jua'³ la'³, ca²³jiúun² dsa³ dxí³ to²³'i'². ―Cu²'íin³ 'óo²ra'³ Espíritu Gáan³ ―ca²³jua'³ ca²³sɨ'²³ dsa³ quien³²―. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Rɨ²³dxen³ dsoo² quiee'³² dsa³ 'i³ rɨ²mi³dxen²³na'³ dsoo² quiee'³². 'E³ quie'²³ 'a²³jia'³ rɨ²³dxen³ dsoo² quiee'³² dsa³ 'i³ 'a²³jia'³ rɨ²mi³dxen²³na'³ dsoo² quiee'³² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","'E³ quie'²³ 'a²³jia'³ jen³¹ Tu³moo³², jø̱n³ dsa³ gui²³tʉ̱́n³ 'i³ sɨ'²³te'²³ Dsa³ Su̱u̱n²³², ma²ca¹dxóo¹ Jesús je² nee'n²³² te'²³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","'E³ jo̱³ ca²³sɨ'²³te'²³ Tu³moo³²: ―Mɨ³nen²³²na'³¹ Juii³ra², ¿mɨ³naa'³¹? ―ca²³jua'³ te'²³ jia'³ cɨ'²³ dsa³ quien³² Jesús. Ca²³sɨ'²³ uu'n². 'E³ quie'²³ ca²³jua'³ Tu³moo³²: ―'A²³jia'³ rɨ²³sɨ²³táan³na²³ 'e³ mɨ³ji̱i̱'²³ co̱'³ xi³nu³ 'a²³jia'³ rɨ²maan²³² je² lii²³ je² ca²³cuǿ³te'²³ i²to̱o̱³² guoo³, xi³nu³ 'a²³jia'³ rɨ²ta̱a̱'n³¹ xi²guaan²³ je² ca²³cuǿ³te'²³ i²to̱o̱³², xi³nu³ 'a²³jia'³ rɨ²ta̱a̱'n³¹ guaan²³ je² 'ɨ'²te'²³ tɨɨn²³. ―La'³ ca²³sɨ'²³ uu'n². ");
INSERT INTO cnlNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Je² ca²³tɨ́³ co̱o̱³ mɨ²guiaa³ la'³, ta'n² nee'n²³² xi²ñʉ'¹ co̱'³ dsa³ quien³² Jesús. Quia̱'²te'²³ Tu³moo³². Rɨ³jnɨ³ 'oo'² 'ñʉ³¹ co̱'³. 'E³ quie'²³ co̱'³ cɨ'²³ ca²³dxóo² Jesús. 'Í² jee²³² quiee'³² dsa³ quien³². ―Cu²née¹ ca²³tó̱o̱²³ 'óo²ra'³ ―ca²³jua'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","'E³ quie'²³ jo̱³ ca²³jua'³ ca²³sɨ'²³ Tu³moo³²: ―'E³ la³ guaan²³. La³ te̱'² xi²guaan³² jo̱o̱²³na²³. 'E³ la³ tɨɨn²³na²³ co̱'³. 'Íi³ guaan³². Te̱'² tɨɨn²³na²³ jo̱o̱²³na²³. 'A²³ ma²³ rɨ³jmeen³ 'e³ 'a²³jia'³ sɨ³táan³nu³. 'Ne'² rɨ²³sɨ²³táan³nu³ 'e³ mɨ³ji̱i̱'n²³na²³ co̱'³ ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","'E³ jo̱³ ca²³jua'³ Tu³moo³². Ca²³sɨ'²³ Jesús: ―¡Juiin²³, Dios quién²³na²³! ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Tu³moo³²: ―Mɨ³ñin²³nu³ jné². 'E³ jo̱³ sɨ³táan³nu³. Bi²³ cɨ² dxʉ́²³ quie'² dsa³ 'i³ sɨ³táan³ juø'n³ quie'²³ 'a²³jia'³ lɨ'³ ca³ŋøn³² jné² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","'E³ quie'²³ ñúun³ cɨ² u²³juø'²³ ca²³jmée³ Jesús 'e³ ca²³jóo² dsa³ quien³². 'E³ quie'²³ 'a²³jia'³ to̱o̱²³ ji³ la³ la²³jɨ³ 'e³ ca²³jmée³. ");
INSERT INTO cnlNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","'E³ quie'²³ mɨ³té̱e̱n²³ ji³ júu² la³ 'e³ juø'n²³ 'náan²³ 'e³ rɨ²³sɨ²³táan³na'³ 'e³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ Dios hua² Jesús. 'Náan²³ 'e³ rɨ²³sɨ²³táan³na'³ 'e³ Jo̱o̱³¹ Dios 'í³. Qui² rɨ³ji̱'n²na'³ ca³cuaa³ 'e³ juo'³ra'³ rɨ³løn³¹na'³ dsa³ quien³² xi³nu³ sɨ³táan³na'³ quia̱'n²na'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ma²mɨ³líi² la'³ jo̱o̱²³na²³, co̱'³ cɨ'²³ ca²³mi²³jnen³ 'ñée² Jesús caan²³ dsa³ quien³². Ca²³mi²³jnen³ 'ñée² co̱³² jmɨ²³ñii'³¹ Tiberias. La²³la³ cu³lø³¹ ca²³lǿ²³: ");
INSERT INTO cnlNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jen³¹ Muun³² Peen²³² quia̱'² Tu³moo³², 'i³ sɨ'²³te'²³ Dsa³ Su̱u̱n²³², quia̱'² Natanael, dsa³ juɨɨ³ Caná estado Galilea. Nee'n²³² te'²³ jo̱o̱³¹ Zebedeo co̱'³ quia̱'² cɨ² áan²³ dsa³ quien³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","'E³ quie'²³ jo̱³ ca²³jua'³ Muun³² Peen²³². Ca²³sɨ'²³ uu'n²: ―Ñiin²³ i³quié̱n²na²³ 'moo'³, ¿mɨ³naa'³¹? ―Dsoo³²ra'³¹ quia̱'n²na'³¹ 'nʉ³ ―ca²³sɨ'²³te'²³ Peen²³². 'E³ quie'²³ jo̱³ ca²³guín²³te'²³. Ca²³ta'n²³te'²³ móo². 'E³ quie'²³ jia'²³ 'uøø²³ 'a²³'i̱³ xen³ 'i³ ca²³jáan³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mɨ³ li²³jné²³ ŋǿn²te'²³ Jesús. Xi'n²³ ñi'² dsoo² sɨ́ɨ² co̱³² jmɨɨ³. 'E³ quie'²³ 'a²³jia'³ ca²³la²³cuiin²³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","'E³ quie'²³ jo̱³ ca²³jua'³ Jesús: ―Te'²³ xii'³, ¿'a² mɨ³jáan³na'³ 'moo'³? ―ca²³jua'³ ca²³sɨ'²³ dsa³ quien³². ―'A²³'i̱³ xen³ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","―Jaan²³na'³ 'e³ dxʉ́²³ xe̱e̱'³ra'³ 'mó². Jo̱³ hua² rɨ²jáan¹na'³ ―ca²³jua'³ 'ñée². 'E³ jo̱³ ca²³jmóo²te'²³ 'e³ la²³ ca²³jua'³. 'E³ quie'²³ ca²³lǿ²³ 'e³ 'a²³jia'³ ma²³ rɨ²³o̱o̱'²³te'²³ 'mó² la²³'nɨɨ'n³¹ juɨɨ'n³¹ 'i³ ca²³ta'n²³ 'mó². ");
INSERT INTO cnlNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","'E³ jo̱³ ca²³juø'n² jné² 'i³ bi²³ 'néen² Jesús. Ca²³juǿøn² Peen²³²: ―Juii³ra² 'i³ mɨ³lʉ́³, ¿mɨ³naa'³¹? Ma²ca¹núu³ Muun³² Peen²³² 'e³ Juii³ra² 'i³ ca²³lʉ́³, cɨ'²³ co̱'³ cuo̱o̱³. Qui² ca²³dxin³ cuo̱o̱³ 'e³ jua'³ jmee²³ ta². Ca²³juén² 'ñée² 'e̱'³ jmɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","'E³ quie'²³ ta'n² quie'²³ 'e̱'³ móo² 'e³ ca²³dxi²³guiin³² ji̱i̱'² jmɨɨ³ jia'³ cɨ'²³ te'²³ dsa³ quien³² Jesús. Sø'²te'²³ 'mó² 'e³ ta'n² 'moo'³. Qui² 'a²³jia'³ huɨ̱́ɨ̱³ la²³ ji̱i̱'² jmɨɨ³. Co̱'³ xi² xa³ co̱o̱³ i³lóo³ metros 'nɨɨ'n³¹ juø'². ");
INSERT INTO cnlNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ma²ca¹'uǿøn¹te'²³ móo², ŋó²³te'²³ 'e³ rɨ³'lo³ ji³ too'³ 'e³ rɨ³so̱'² ji³. Sɨ³quiáan³ 'moo'³. Xa³ 'ɨ²³juɨ² co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","―Jen³²cɨ²na'³ 'moo'³ 'i³ mɨ³jáan³na'³ ―ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","'E³ jo̱³ 'í² co̱'³ móo² Muun³² Peen²³². Sø'² 'mó² jí̱i̱n² je² rɨ³quiʉ̱ʉ̱³. Ti²cø̱'n²³ 'moo'³ 'mó². Bi²³ cø'n² be'n² 'moo'³ 'í³. Xen³ co̱o̱³ i³láan³ dsɨ³² tú̱²³ lu²³guién³ dsɨ³² aan³ 'nɨɨ'n³¹. 'E³ quie'²³ 'a²³jia'³ ca²³gɨɨ³ 'mó², juø'n³ quie'²³ bi²³ juɨ́ɨn²³ ca²³ta'n²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","―Ñe³ra'³ rɨ²cø'²ra'³ ―ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³². 'E³ quie'²³ 'a²³'i̱³ xen³ 'i³ ca²³la²³bii²³ dsɨ́² 'e³ rɨ²³sɨ'²³ Jesús: “¿'I̱i̱² sɨɨ'³¹ 'nʉ³?” Qui² ñi³²te'²³ 'e³ Juii³ra² 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","'E³ quie'²³ jo̱³ ca²³lǿn²³ mɨ³lén² Jesús. Ca²³to'²³ dxóo² 'ɨ²³juɨ². 'E³ quie'²³ la'³ 'moo'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jo̱³ hua² ca²³tɨ́³ 'nɨ³ taa'² 'e³ ca²³mi²³jnen³ 'ñée² caan²³ dsa³ quien³² 'e³ la²³ ca²³ji̱i̱'²³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ma²mɨ³líi² mɨ³e'²te'²³, ca²³jua'³ Jesús. Ca²³sɨ'²³ Muun³² Peen²³²: ―Muun³² jo̱o̱³¹ Jonás, ¿'a² bi²³ cɨ² 'náan²³nu³ jné² la²³ cɨ'²³ la²³jɨn³ te'²³ 'i³ la³? ―ca²³jua'³. ―Máan³ 'nʉ³, Juiin²³, 'e³ bi²³ 'náan²³na²³ 'nʉ³ ―ca²³jua'³ Peen²³². ―Rɨ²e'n¹nu³ jo̱o̱³¹ dsɨɨ³ joo³ quién²³na²³ jo̱o̱²³na²³ ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","'E³ quie'²³ co̱'³ cɨ'²³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³²: ―Muun³² jo̱o̱³¹ Jonás, ¿'a² 'náan²³nu³ jné²? ―ca²³jua'³. ―Máan³ 'nʉ³, Juiin²³, 'e³ bi²³ 'náan²³na²³ 'nʉ³ ―ca²³jua'³ Peen²³². ―'Ne'² rɨ²mi³quin²³nu³ dsɨɨ³ joo³ quién²³na²³ jo̱o̱²³na²³ ―ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","'E³ quie'²³ je² ca²³tɨ́³ 'nɨ³ taa'², ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³²: ―Muun³² jo̱o̱³¹ Jonás, ¿'a² 'náan²³nu³ jné²? ―ca²³jua'³. 'E³ jo̱³ bi²³ ca²³ŋɨ́³ dsɨ́² Peen²³² 'e³ mɨ³tɨ́³ 'nɨ³ taa'² 'e³ tin²³ júu² Jesús xi² jo̱³ quie'²³ 'née² Peen²³² quie'². ―Juiin²³ ―ca²³jua'³―. Máan³ 'nʉ³ la²³jɨ³ xú̱n³. Máan³ 'nʉ³ 'e³ 'náan²³na²³ 'nʉ³ ―ca²³jua'³. 'E³ jo̱³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³²: ―Rɨ²e'n¹nu³ dsɨɨ³ joo³ quién²³na²³ jo̱o̱²³na²³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Rɨ²juøøn³¹na¹ 'nʉ³ ju²dsoo³¹: Ma²rɨ³løn³¹nu³ xii'³ mɨ²jo̱³, ca²³qui'n³ 'uǿøn²nu³ cua̱a̱n³². Ca²³ŋɨ́n³ te³ jiaa'³¹ 'naan³ mɨ²jo̱³. 'E³ quie'²³ 'e³ cɨ² rɨ²'ɨ́ɨn² 'nʉ³ guaan³² mɨ³li³jaan²³²nu³. Jia'³ cɨ'²³ dsa³ li²³'ne'² 'e³ rɨ²³qui'n² 'nʉ³ cua̱a̱n³² co̱'³. 'E³ cɨ² rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ rɨ²³sɨ²³jøn²³te'²³ 'nʉ³ je² 'a²³jia'³ 'naan³ guaan³². ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Qui² la'³ cu³lø³¹ ca²³jua'³ 'e³ jmii'³¹ rɨ²³jú̱n³ Peen²³², 'e³ jmii'³¹ rɨ²³mi²³gáan³ Dios. 'E³ quie'²³ jo̱³ ca²³sɨ'²³ Peen²³²: ―Ñe³ quia̱'n²nu³ jné² ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","'E³ quie'²³ jo̱³ ca²³ji̱i̱n²³ Peen²³². Ca²³jóo² rɨ²³coo'². Ŋó²³ 'e³ ca²³áan²³ tu³cɨ̱ɨ̱n²³na²³ jné² dsa³ 'i³ bi²³ 'née² Jesús quie'², jné² 'i³ ca²³ñin²³ rɨ³quie̱e̱n²³²na¹ caan²³ Jesús je² ca²³quie²ra'³¹ la²³ 'áa²³ rɨ²³jú̱n³. Jné² hua² 'i³ ca²³juǿøn² Jesús: “Juiin²³, ¿'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³'nɨ́ɨn²³ 'nʉ³?” ");
INSERT INTO cnlNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","'E³ quie'²³ ma²ŋøn³¹ jné² Peen²³², ca²³jua'³ ca²³sɨ'²³ Jesús: ―Juiin²³, ¿jmii'³¹ rɨ²³ji̱'²³ 'i³ mɨ³ ja³'ɨ́ɨn²³ la³? ―ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","―'A²³'e³ cua̱a̱n²tu² quién²nu³ xi³nu³ 'náan²³ 'e³ rɨ³ji̱'²³ quie'²³ la²³huø'n²³ rɨ²³tɨ́²³ 'e³ rɨ²³güe'n²³na²³ co̱'³. Ñe³ 'uǿøn²nu³ quia̱'n²nu³ jné². ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","'E³ jo̱³ hua² 'e³ mɨ³sóo²³ mɨ³jó²³ júu² jee²³² quiee'³² te'²³ jó̱o̱²ra². Jua'³te'²³ 'e³ 'a²³jia'³ rɨ³lø³¹ 'i'²³ 'e³ rɨ²³jú̱n³na²³ jné². 'E³ quie'²³ 'a²³la³ la'³ ca²³jua'³ Jesús. Te³ ca²³jua'³: “'A²³'e³ cua̱a̱n²tu² quién²nu³ xi³nu³ 'náan²³ 'e³ rɨ³ji̱'²³ quie'²³ la²³huø'n²³ rɨ²³tɨ́²³ 'e³ rɨ²³güe'n²³na²³ co̱'³”. 'Nɨɨ'n³¹ la'³ hua² ca²³jua'³ Jesús. Ca²³'én² jné². ");
INSERT INTO cnlNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","'E³ quie'²³ jné² hua² 'i³ rɨ³løn³¹na¹ dsa³ ñi³. Jmeen²³ júu² 'e³ jmii'³¹ ca²³maan²³. 'E³ jo̱³ hua² 'e³ mɨ³té̱e̱n²³ ji³ la³. 'E³ quie'²³ ne³ra² 'e³ lʉn²³ ju²dsoo³¹. ");
INSERT INTO cnlNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ñúun³ cɨ² bíi²³ xa³ la²³jɨ³ 'e³ ca²³jmée³ Jesús 'u². 'U² cu²ru'³ rɨ²³té̱e̱²te'²³ ji³ la²³jɨ³ 'e³ ca²³jmée³, 'e³ quie'²³ bi²³ ma²³'nee³ ñúun³ ji³ li²³'ne'² cu²ru'³ la'³. Nɨ³ mɨ³líi².");
INSERT INTO cnlNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","La³ rɨ²juøøn³¹na¹ 'nʉ³, Teófilo, 'e³ la²³ lǿ² ji³ 'e³ ca²³jméen²³ xe̱'n². Ji³ jo̱³ to̱o̱²³ la²³jɨ³ 'e³ ca²³jmée³ Jesús quia̱'² la²³jɨ³ 'e³ ca²³'ée²³ dsa³ cɨ'²³ la²³ 'e³ ca²³la²³láa²³ ");
INSERT INTO cnlNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","xi³'lɨ² ca²³tɨ́³ 'e³ ca²³huɨ́ɨ³ yʉʉ'³¹ güii³. Ca²³dxi³ 'i'²³ quie'² te'²³ dsa³ xiin²³ quien³² 'i³ ca²³'náan²³ 'ñée² 'e³ jmii'³¹ rɨ²³jmóo². Espíritu Gáan³ ca²³jmée³ ta² quia̱'² Jesús 'e³ la²³ ca²³dxi³ 'i'²³ quie'² dsa³ quien³² 'e³ jmii'³¹ rɨ²³jmóo². ");
INSERT INTO cnlNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ma²mɨ³líi² mɨ³jŋɨ'n²³te'²³, jo̱³ ca²³ji̱i̱'²³ co̱'³ 'ñée². Ca²³mi²³jnen³ 'ñée² caan²³ dsa³ xiin²³ quien³². Bi²³ ñúun³ la²³jɨ³ 'e³ ca²³jmée³ 'ñée² 'e³ ca²³jmée³ lii²³ 'e³ ca²³ji̱i̱'²³ co̱'³. 'E³ jo̱³ ca²³dsóo²³ dsɨ́²te'²³ 'e³ ca²³ji̱i̱'²³ co̱'³. Qui² ŋǿn²te'²³. Tú̱²³ lóo² jmɨ́ɨ² cɨ² ca²³ŋɨ́³ mɨ³¹güii³ la³ 'e³ la²³ ca²³ji̱i̱'²³ co̱'³. Te³ 'ee² jmɨ́ɨ² ca²³mi²³jnen³ 'ñée² caan²³ dsa³ xiin²³ quien³². Ca²³lʉ́³ júu² 'e³ la²³ rɨ³løn³¹ Dios juii² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ma²jen³¹ cɨ² quia̱'² te'²³ dsa³ xiin²³ quien³², ca²³jua'³: ―'A²³ rɨ³'uøøn³²na'³ juɨɨ³ Jerusalén. Rɨ²ñí²ra'³ ca²³tó̱o̱²³. Qui² 'ne'² rɨ²jǿ̱n¹na'³ Espíritu Gáan³ 'i³ rɨ²³xíin²³ Ñu'n²³ 'e³ la²³ ca²³juǿøn²na²³ 'nee'²³. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jmɨɨ³ ca³quie̱e̱² hua² ca²³co'² Juan ma²ca¹xáan¹ dsa³ jmɨɨ³ mɨ²jo̱³. 'E³ quie'²³ 'a²³jia'³ ma²³ huǿø³ 'e³ rɨ²³güén³ Espíritu Gáan³ 'i³ rɨ²³'íin³ 'óo²ra'³. 'É̱e̱² 'e³ rɨ²³saan²³na'³ jmɨɨ³. ―La'³ ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ xiin²³ quien³². ");
INSERT INTO cnlNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","'E³ la²³ rɨ³ŋɨɨn³¹ dsa³ xiin²³ quien³² Jesús, ca²³ŋɨ'²³te'²³ júu² 'ñée². Ca²³jua'³te'²³: ―Juii³ra'³¹, ¿'a² mɨ³tɨ́³ 'e³ rɨ²jméen² gáan³ co̱'³ dxi² juɨɨ³ quien³² dsa³ Israel? ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ca²³jua'³ Jesús. Ca²³sɨ'²³ dsa³ quien³²: ―'A²³jia'³ 'ne'² 'e³ née² ru²³ñí²ra'³ 'e³ rɨ²³dsóo²³ 'óo²ra'³ 'ee² ji̱i̱³, 'ee² jmɨ́ɨ² rɨ²³lí³ la²³jɨ³ 'e³ ca²³dxi³ 'i'²³ Ñu'n²³. Qui² jø̱n³ 'ñée² hua² 'i³ dxi³ 'i'²³ la²³jɨ³ 'e³ lø³² la'³. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","'E³ quie'²³ 'e³ cɨ² rɨ²³'íin³ 'óo²ra'³ Espíritu Gáan³. Jo̱³ rɨ²³'ién²na'³ ju²³bíi²³. Rɨ²juɨɨ'³¹ra'³ dsa³ 'e³ jmii'³¹ ca²³jméen²³ la²³huøø'n³¹ la²³ ca²³ŋɨ́n²³ quia̱'n²³²na¹ 'nee'²³. Rɨ²³lín³na'³ dsa³ ñi³ quién²³na²³. Rɨ²juɨɨ'³¹ra'³ dsa³ Jerusalén. Rɨ²juɨɨ'³¹ra'³ dsa³ la²³ca̱a̱n³ estado Judea quia̱'² estado Samaria. Rɨ²juɨɨ'³¹ra'³ dsa³ la²³bee'n³¹ mɨ³¹güii³. ―La'³ ca²³jua'³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ma²mɨ³líi² mɨ³jua'³ la'³, té̱e̱n³ quie'²³ joo³² dsa³ quien³², ca²³huɨ́ɨ³ yʉʉ'³¹ güii³ 'ñée². Qui² tǿ²³ Dios quie'². Ca²³een³ jníi². 'A²³jia'³ ma²³ jnén³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","'Iún² quie'²³ jui³¹ sɨ³huɨ́ɨ³ yʉʉ'³¹. Joo³² quie'²³ la'³ dsa³ quien³². Co̱'³ la²³ mɨ³té̱e̱n³ ja² caan²³te'²³ ca²³jmóo² áan²³ ángeles 'i³ quii'³ 'mɨɨ'³ taa³. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","'E³ quie'²³ jo̱³ ca²³lʉ́³ ángeles. Ca²³sɨ'²³ te'²³ dsa³ xiin²³: ―Rɨ²xii'³¹ra'³¹ 'nee'²³, dsa³ Galilea: ¿'Ee² lǿ² té̱e̱n³na'³ la³ joo³²ra'³ yʉʉ'³¹? Qui² Dios hua² mɨ³tøø³ Jesús 'e³ mɨ³huɨ́ɨ³ yʉʉ'³¹ güii³. 'E³ quie'²³ la²³ lǿ² 'e³ mɨ³jóo²ra'³ nɨ³ 'e³ la²³ mɨ³ŋø'n³² yʉʉ'³¹ güii³, 'e³ quie'²³ la²³nɨ³ lǿ² 'e³ rɨ²³güe'n²³ co̱'³. ―La'³ ca²³jua'³ ángeles. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Naan³te'²³ mo'³ Olivos. Ca²³guiin³²te'²³ co̱'³ jee²³² juɨɨ³ Jerusalén. Qui² mɨ³lén² la²³ juɨɨ³ Jerusalén mo'³ Olivos. Xa³ la²³'nɨɨ'n³¹ je² lǿn³ dsa³ 'e³ joo'²³ 'e³ rɨ²³ŋɨ́²³te'²³ jmɨ́ɨ² je² tøø³ dsɨ́² dsa³. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ca²³dxi²³guiin³²te'²³ jee²³² juɨɨ³ jo̱o̱²³na²³. Ca²³ta'n²³te'²³ co̱²³ju'²³ yʉʉ'³¹ je² dxi²³juɨn³¹ je² nee'n²³²te'¹. Jen³¹ Peen²³² quia̱'² Jacobo quia̱'² Juan quia̱'² Drøø³¹ quia̱'² Bi³lii² quia̱'² Tu³moo³² quia̱'² Bar³too² quia̱'² Tee³¹ quia̱'² Jacobo jo̱o̱³¹ Alfeo quia̱'² Muun³² dsa³ cananista quia̱'² Judas jó̱o̱² Jacobo. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","La²³jɨn³te'²³ rɨ³løn³¹te'¹ co̱o̱³ júu² 'e³ la²³ lʉ²³te'²³ quia̱'²te'²³ Dios. Tén³ lʉ²³ quia̱'² Dios te'²³ dsa³ xiin²³ quia̱'² te'²³ jó̱o̱² Jesús quia̱'² Ma³rii³¹ xóo² Jesús quia̱'² cɨ² mɨ́³. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mɨ²jo̱³ ca²³naa'n²³ Peen²³² jee²³² je² rɨ³ŋɨɨn³¹ te'²³ jó̱o̱²ra². Xen³ co̱o̱³ i³láan³ dsɨ³² guiáan³ 'nɨɨ'n³¹ juø'² 'i³ rɨ³ŋɨɨn³¹. 'E³ quie'²³ jo̱³ ca²³lʉ́³ Peen²³². Ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Rɨ²juøøn³¹na¹ 'nee'²³, te'²³ ja̱a̱n³²: 'E³ la²³ rɨ³lø³¹ 'i'²³ hua² 'e³ la²³ lǿ² 'e³ ca²³jmée³ Judas 'i³ ca²³cuǿ³ jui³¹ quie'² dsa³ 'i³ sø̱'n² Jesús. Qui² mɨ³xa³ jmɨ́ɨ² to̱o̱²³ ji³ 'e³ jmii'³¹ rɨ²³jmée²³. Espíritu Gáan³ 'iún² dsɨ́² David ma²ca¹jmée³ júu² jén²³ 'e³ jmii'³¹ rɨ²³jmée²³ Judas. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Rɨ³løn³¹ uu'n²na'³¹ mɨ²jo̱³ 'u². Qui² ca³ti³² ca²³'uøøn³ jnee'³¹ Jesús 'e³ jua'³ 'née²³ 'e³ rɨ²jmee²ra'³¹ ta² quiee'³². ");
INSERT INTO cnlNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","'E³ quie'²³ ca²³jmée³ 'e³ sǿn²³ Judas 'e³ ca²³'nɨ́ɨn²³ Jesús. 'E³ jo̱³ ca²³quí²te'²³ jñiin²³. 'E³ quie'²³ ca²³ŋɨ́³ dsɨ́² 'ñée². I²có̱o̱³ co̱'³ cuu² 'e³ có̱²³. Cuu² jo̱³ ló²te'²³ 'uǿ²³. 'E³ quie'²³ jo̱³ ca²³jŋɨ'n²³ 'ñée². Ca²³tø'n³ rɨ³'in³². Ca²³gɨɨ³ tu'². Ca²³'uøø³ la²³jɨ³ 'e³ taa'². ");
INSERT INTO cnlNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ca²³núu³ la²³jɨn³ dsa³ Jerusalén 'e³ jmii'³¹ ca²³jme'²³ 'ñée² Judas. 'E³ jo̱³ hua² jua'³te'²³ 'uǿ²³ jñii³¹ jmɨ²³'ǿn² dsa³ 'uǿ²³ 'e³ ló²te'²³. Acéldama jua'³te'²³ ju²³jmii²³² quiee'³²te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Qui² Judas 'en³² je² to̱o̱²³ ji³ júu² quiee'³² Dios 'e³ xi̱i̱n³ Salmos je² jua'³: Cu²gua'¹ ta² quiee'³² la²³ sɨ³gua'²³ co̱o̱³ 'ñʉ́² jaa²³². 'A²³jia'³ 'née²³ Dios 'e³ li²³xen³ cɨ² dsa³ 'i³ rɨ²³jmóo² 'e³ la²³ ca²³jmée³ 'ñée². Co̱'³ cɨ'²³ xa³ je² to̱o̱²³ ji³ je² jua'³: 'Ne'² rɨ²³néen² dsa³ 'i³ rɨ²³jmée²³ ta² 'e³ ca²³tʉ́² 'ñée². La'³ cu³lø³¹ to̱o̱²³ ji³ júu² quiee'³² Dios 'e³ xi̱i̱n³ Salmos. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Co̱'³ cɨ'²³ ca²³lʉ́³ Peen²³². Ca²³jua'³: ―Xen³ cɨ² dsa³ 'i³ ca²³ŋɨ́³ quia̱'² jnee'³¹ la²³huøø'n³¹ la²³ ca²³gua³ Juii³ra² Jesús quia̱'² jne², ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Quia̱'²te'²³ jnee'³¹ cɨ'²³ la²³ 'e³ ca²³xáan² jmɨɨ³ Jesús Juan. Quia̱'²quie'²³te'²³ jnee'³¹ la²³huø'n²³ 'e³ ca²³tɨ́³ 'e³ ŋø'n² yʉʉ'³¹. 'E³ jo̱³ 'ne'² rɨ²³lín³ uu'n²na'³¹ jø̱n³ dsa³ 'í³ 'e³ la²³ rɨ²³lín³na'³¹ dsa³ ñi³ quia̱'n²na'³¹. Ca³ti³² rɨ²jmee²ra'³¹ júu² 'e³ jmii'³¹ cu³lø³¹ 'e³ ca²³ji̱i̱'²³ co̱'³ Jesús. ―La'³ ca²³jua'³ Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","'E³ jo̱³ ca²³'uøøn³te'²³ áan²³ dsa³. Ca²³dxin³te'²³ Matías quia̱'² Søø³² 'i³ sɨ'²³te'²³ Barsabás. Justo jmɨ³ñi³ quiee'³² Søø³². ");
INSERT INTO cnlNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ca²³lʉ́³te'²³ quia̱'²te'²³ Dios. Ca²³jua'³te'²³: ―Juii³ra'³¹, máan³ 'nʉ³ jmii'³¹ lǿ² dsɨ́² la²³jɨn³ dsa³ mɨ³¹güii³. Jmee² lii²³ 'i̱i̱² sɨɨ'³¹ 'i³ mɨ³'néen²³nu³ 'uǿøn²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Jmee² lii²³ 'i̱i̱² sɨɨ'³¹ rɨ²³jmée²³ ta² quia̱'² jnee'³¹, 'i³ rɨ²³lín³ dsa³ xiin²³ quien³²nu³. Jmee² lii²³ 'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³co̱o̱²³ ta² 'e³ ca²³tʉ́² Judas ma²ca¹jmée³ 'e³ xa³ dsoo² quiee'³². Qui² ŋø'n² 'ñée² je² dxi³ji̱i̱n³¹ 'e³ dsø'n³². ―La'³ ca²³jua'³te'²³ 'e³ la²³ ca²³lʉ́³te'²³ quia̱'²te'²³ Dios. ");
INSERT INTO cnlNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","'E³ quie'²³ jo̱³ xa³ mɨɨ³¹ 'e³ ca²³co'²te'²³ 'e³ la²³ li²³lii²³ 'e³ 'i̱i̱² sɨɨ'³¹ 'i³ rɨ²³lín³ dsa³ xiin²³. Matías ca²³la²³røøn³. 'E³ jo̱³ Matías ca²³dxin³te'²³ dsa³ xiin²³. Ca²³la²³quia̱'² te'²³ dsa³ 'i³ gui²³quie̱e̱n³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ca²³tɨ́³ mɨ²juee'³ 'e³ xi̱i̱n³ Pentecostés. Jmɨ́ɨ² jo̱³ rɨ³ŋɨɨn³¹ la²³jɨn³ dsa³ quien³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Co̱'³ la²³ ca²³'i̱i̱² jí̱i̱n² yʉʉ'³¹ güii³. La²³ 'i̱i̱² 'e³ sɨ³ŋɨ́n³ dxí³ bee'² 'i̱i̱² jó². Rɨ³ca̱'n²³ 'ñʉ́² je² nee'n²³²te'¹ ca²³'i̱i̱². ");
INSERT INTO cnlNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ŋó²³te'²³ 'e³ la²³ lǿ² sɨɨ'² ji³. Ca²³too'²³ coo'² dxi² cɨ'³ la²³ jø̱n³ dsa³ quien³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","'E³ quie'²³ jo̱³ 'íin² dsɨ́²te'²³ la²³jɨn³te'²³ Espíritu Gáan³. Xe̱'n² quie'²³ jo̱³ ca²³lʉ́³te'²³ ju²³jmii²³² quiee'³² jia'³ cɨ'²³ dsa³ 'e³ 'a²³jia'³ lɨ'³ ca³la³tɨn³te'²³. Espíritu Gáan³ ca²³jmée³ 'e³ lǿ²³ juø'² 'e³ ca²³lʉ́³te'²³ la'³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ta'n² juɨɨ³ Jerusalén mɨ²jo̱³ dsa³ Israel 'i³ 'aa³ u²³go³ u²³'iʉʉ²³ quia̱'² Dios 'i³ ca²³ja²³guín²³ la²³ca̱a̱n³ jia'³ cɨ'²³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","'E³ quie'²³ jo̱³ ca²³ŋɨɨ'n²³ dsa³ ma²ca¹núu³te'²³ 'e³ 'i̱i̱² 'e³ sɨ³ŋɨ́n³ dxí³ bee'². Bi²³ juø'²³ ca²³núu³te'²³ júu² 'e³ ca²³lʉ́³ dsa³ quien³² Jesús. Qui² ca²³núu³te'²³ 'e³ lʉ²³ dsa³ quien³² Jesús la²³jɨ³ 'iin³² ju²³jmii²³² 'e³ lʉ²³ miin²³ cɨ'³ la²³ jø̱n³ dsa³ 'i³ xen³ jia'³ cɨ'²³ juɨɨ³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","'E³ jo̱³ bi²³ juø'²³ ca²³ti²³cø̱n³¹te'¹. Ca²³jua'³te'²³: ―Jmø'n² dsa³ Galilea 'i³ lʉ²³ la³, ¿mɨ³naa'³¹? ");
INSERT INTO cnlNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Jmii'³¹ lǿ² 'e³ nʉʉ³ra² 'e³ lʉ²³te'²³ ju²³jmii²³² quiee³²ra² cɨ'³ la²³ jø̱n³na², ju²³jmii²³² 'e³ lʉ²ra² cɨ'²³ la²³ pi'n²na²? ");
INSERT INTO cnlNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Qui² dsa³ Partia jne² ca³dxáan²na², dsa³ Media co̱'³, dsa³ Elam, dsa³ Mesopotamia quia̱'² dsa³ Judea quia̱'² dsa³ Capadocia quia̱'² dsa³ Ponto quia̱'² dsa³ Asia ");
INSERT INTO cnlNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","quia̱'² dsa³ Frigia quia̱'² dsa³ Panfilia quia̱'² dsa³ Egipto quia̱'² dsa³ Libia 'i³ nee'n²³² coo³¹ Cirene quia̱'² dsa³ 'i³ xen³ juɨɨ³ Roma 'i³ i²³guín²³ la³ ca²³ji̱i̱³. Qui² xen³ dsa³ góo²³ juɨɨ³ Roma 'i³ mi³gáan³ Dios 'e³ la²³ jmoo³² dsa³ Israel. 'E³ quie'²³ xen³ dsa³ Israel 'i³ nee'n²³² juɨɨ³ Roma co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Quia̱'² dsa³ Creta quia̱'² dsa³ Arabia. Nʉʉ³ra² 'e³ lʉ²³te'²³ ju²³jmii²³² quiee³²ra² cɨ'³ la²³ jø̱n³na². Nʉʉ³ra² 'e³ jua'³te'²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ dxʉ́²³ jmee²³ Dios. ―La'³ ca²³jua'³ dsa³ 'i³ ca²³núu³ júu² 'e³ ca²³lʉ́³ dsa³ quien³² Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bi²³ juø'²³ ca²³ti²³cø̱n³¹ la²³jɨn³ dsa³ 'i³ ca²³núu³ júu² 'e³ ca²³lʉ́³ dsa³ quien³² Jesús. Bi²³ ca²³xín³ ca²³'ín³te'²³. Ca²³jua'³te'²³: ―¿'Ee² 'noo³¹ sɨ³lí³ rɨ³nɨ²³ cu²ne²ra²? ");
INSERT INTO cnlNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","'E³ quie'²³ xen³ jia'³ cɨ'²³ dsa³ 'i³ ca²³jáa² ca²³ŋɨ́ɨ². Ca²³jua'³te'²³: ―Bi²³ mɨ³ŋøn³te'²³, ¿mɨ³naa'³¹? Mɨ³'ɨ̱ɨ̱'²³te'²³ vino 'e³ cɨ² sɨ³juii³ ―ca²³jua'³te'²³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","'E³ jo̱³ ca²³naa'n²³ Peen²³² quia̱'² te'²³ jia'³ cɨ'²³ dsa³ xiin²³ quien³² Jesús. Ca²³jmée³ júu². Ca²³jua'³: ―Rɨ²juøøn³¹na¹ 'nee'²³, dsa³ uu'n²na²³ quia̱'² la²³jɨn³ 'nee'²³ 'i³ nee'n²³² juɨɨ³ Jerusalén: Xa³ 'e³ 'náan²³ 'e³ rɨ²³dsóo²³ 'óo²ra'³. 'Náan²³ 'e³ rɨ²núu²ra'³ júu² 'e³ rɨ²lʉn²³². ");
INSERT INTO cnlNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Lǿn³na'³ 'e³ mɨ³ŋøn³na'³¹. 'E³ quie'²³ 'a²³jia'³ ŋa'n²na'³¹ xú̱n³. Qui² 'e³ cɨ² mɨ³tɨ́³ hora 'e³ ñʉ́²³ hua². ");
INSERT INTO cnlNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","'E³ cɨ² sɨ³lí³ rɨ³nɨ²³ 'e³ la²³ ca²³jua'³ dsa³ 'i³ xi̱i̱n³ Joel 'i³ ca²³'ɨ́ɨ³ júu² quiee'³² Dios mɨ²jaa²³². La²³la³ cu³lø³¹ ca²³jua'³: ");
INSERT INTO cnlNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Mɨ³rɨ³ti³ jmɨ́ɨ² je² dsøn³, jua'³ Dios Juii³ra², rɨ²sɨɨn³¹na¹ Espíritu quién²³na²³ 'e³ rɨ²³'íin³ dsɨ́² dsa³ 'i³ xen³ la²³ca̱a̱n³ mɨ³¹güii³. 'E³ jo̱³ rɨ²³'ɨ́ɨ²³ júu² quián²³ jo̱²³ñʉ'²ra'³ quia̱'² jo̱²³mɨ́ɨ³ra'³. Rɨ²³ji̱'²³ xii'³ quien³²na'³ 'é̱e̱² 'e³ rɨ²³cɨ́²³te'²³. 'E³ jo̱³ rɨ²³dsóo²³ dsɨ́²te'²³ 'e³ jmii'³¹ rɨ²³lí³. 'E³ quie'²³ la'³ dsa³ mɨ³dxún²³ quien³²na'³ co̱'³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Rɨ²sɨɨn³¹na¹ Espíritu quién²³na²³ 'e³ rɨ²³'íin³ dsɨ́² la²³jɨn³ 'i³ rɨ³løn³¹ mozos quién²³na²³, juø'n³ quie'²³ dsóo²³, juø'n³ quie'²³ mɨ́³. 'E³ jo̱³ rɨ²³'ɨ́ɨ²³te'²³ júu² quián²³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mɨ³¹güii³ hua² rɨ²jmeen²³² u²³juø'²³. 'Uǿ²³ hua² rɨ²jmeen²³² u²³juø'²³ 'e³ jmee²³ lii²³ 'e³ jmii'³¹ 'nɨɨ'n³¹ gáan³na²³. Rɨ²jmeen²³² 'e³ li²³xa³ jmɨ³ quia̱'² ji³ quia̱'² ñi². ");
INSERT INTO cnlNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Rɨ²³yʉʉ³ ji³ quiee'³² ñi'². Li²³yú̱u̱n³ sɨɨ'³ 'e³ la²³ yʉ̱́ʉ̱³ jmɨ³. La²³nɨ³ cu³lø³¹ rɨ²³lí³ jén²³ cɨ² 'e³ la²³ rɨ²³tɨ́²³ jmɨ́ɨ² 'e³ rɨ²³dxá²³ ta² Juii³ra². Bi²³ gáan³ la²³jɨ³ 'e³ rɨ²³lí³ jmɨ́ɨ² jo̱³. Bi²³ juø'²³ cu³lø³¹ la²³jɨ³ 'e³ rɨ²³lí³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","'E³ quie'²³ rɨ²³láan³ la²³jɨn³ dsa³ 'i³ rɨ²³ŋɨ́ɨ²³ co̱²juø'¹ quie'² Juii³ra². La'³ cu³lø³¹ júu² 'e³ ca²³té̱e̱² ji³ Joel mɨ²jaa²³². ");
INSERT INTO cnlNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Co̱'³ cɨ'²³ ca²³jua'³ Peen²³²: ―Rɨ²juøøn³¹na¹ 'nee'²³, dsa³ Israel. 'Ne'² rɨ²núu²ra'³ júu² 'e³ rɨ²lʉn²³²: Lii²³ 'e³ ca²³jmée³ ta² quiee'³² Dios Jesús dsa³ Nazaret. Qui² Dios ca²³jmée³ 'e³ 'uee'n³ júu² quiee'³². 'E³ jo̱³ lǿ²³ juø'² ca²³jmée³ u²³juø'²³ jee²³² quien³²na'³. Móo³ra'³ 'e³ jmii'³¹ ca²³jmée³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jén²³ cɨ² ca²³dxi³ 'i'²³ Dios 'e³ jmii'³¹ rɨ²³ji̱'²³ Jesús. Jén²³ cɨ² ñi³² 'ñée² 'e³ rɨ²³'nɨ́ɨn²³te'²³ Jesús. 'E³ quie'²³ 'nee'²³ ca²³jŋɨ'n²³na'³. Ca²³te̱e̱n²³²na'³ 'mo³ cruz. Te'²³ dsa³ jia'³, dsa³ 'i³ 'a²³jia'³ cuiin²³ Dios, ca²³lǿn²³ mozos quien³²na'³ 'i³ ca²³jŋɨ'n²³ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","'E³ quie'²³ ca²³jmée³ Dios 'e³ ca²³ji̱i̱'²³ co̱'³ Jesús. Ca²³jmée³ 'e³ 'a²³jia'³ ma²³ rɨ²³jú̱n³. Qui² 'a²³jia'³ ca²³lǿ²³ juø'² ca³cuaa'n³te'²³ Jesús je² nee'n²³² 'lɨ́ɨ³. ―La'³ ca²³jua'³ Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Co̱'³ cɨ'²³ ca²³jua'³: ―'E³ 'iin³¹ Jesús ca²³lʉ́³ David mɨ²jaa²³². 'É̱e̱² 'e³ ca²³lʉ́³ Jesús quia̱'² Dios Jmii³ ma²ca¹jua'³: Tén³ jen³¹na¹ quia̱'n²³²na¹ 'nʉ³. 'Nʉ³ hua² jmeen³ co̱²juø'¹ quián²³ 'e³ bii²³ dsɨn²³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","'E³ jo̱³ bi²³ jɨn³ dsɨn²³. Ca²³lʉn²³ júu² 'e³ jmeen²³ lii²³ 'e³ jɨn³ dsɨn²³. Co̱'³ cɨ'²³ co̱o̱³ dsɨn²³. Qui² mi³quin²³nu³ jné². ");
INSERT INTO cnlNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Maan²³ 'e³ 'a²³jia'³ rɨ²cuaa'n²³²nu³ dsɨn²³ je² nee'n²³² 'lɨ́ɨ³. 'A²³jia'³ rɨ²cuǿn² 'nʉ³ júu² 'e³ rɨ²³jioo'³ jmɨn²³ ŋun²³ jné² dsa³ 'i³ rɨ³jɨ́n² quien³²nu³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ca²³cuǿøn²nu³ jné² jui³¹ 'e³ rɨ³ji̱'n²³na²³ ca³quie̱e̱². Rɨ²jméen² 'e³ ti²cø̱'n²³ jɨn³ dsɨn²³ 'e³ juø'n²³ jen³¹na¹ quia̱'n²³²na¹ 'nʉ³. La'³ ca²³jua'³ David mɨ²jo̱³ 'e³ 'iin³¹ Jesús. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Co̱'³ cɨ'²³ ca²³jua'³ Peen²³²: ―Rɨ²juøøn³¹na¹ 'nee'²³, te'²³ dsa³ uu'n²na²³: Jɨn³ rɨ²lʉn²³² quia̱'n²³²na¹ 'nee'²³. Mɨ³xa³ jú̱n²³ David, dsa³ góo²³ quien³²na². Ca²³'áan²te'²³ 'lɨ́ɨ³. Xi³'lɨ² jmɨ́ɨ² rɨ³nɨ²³ xa³ quie'²³ too³ 'loo³ je² rɨ³'aan²³ 'lɨ́ɨ³ 'í³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ca²³'ɨ́ɨ³ David júu² quiee'³² Dios. 'E³ jo̱³ ñi³² 'ñée² 'e³ jmii'³¹ ca²³jua'³ Dios 'e³ rɨ²³jmée²³. Qui² ca²³jua'³ Dios 'e³ rɨ²³jmée²³ 'e³ li²³xen³ jø̱n³ dsa³ ju̱u̱n²³ David 'i³ rɨ²³lín³ Cristo, 'i³ rɨ²³lín³ rey la²³ lǿn²³ 'ñée². ");
INSERT INTO cnlNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ma²'ii³¹ cɨ² rɨ²³güén³ mɨ³¹güii³ Cristo, ñi³² David 'e³ rɨ²³ji̱i̱'²³ co̱'³. 'E³ jo̱³ ca²³jua'³: “'A²³jia'³ rɨ²³cuaa'n²³ dsɨ́² je² nee'n²³² 'lɨ́ɨ³. 'A²³jia'³ rɨ²³jioo'³ jmɨ² ŋu²”, ca²³jua'³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesús hua² 'en³² ma²ca¹jua'³ la'³. Ne³ra'³¹ la²³jɨn³na'³¹ 'e³ 'e̱'n³ quie'²³ dsɨ́² ca²³jmée³ Dios 'e³ ca²³ji̱i̱'²³ co̱'³. Rɨ³løn³¹na'³¹ dsa³ ñi³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","'E³ jo̱³ ca²³tøø³ Dios yʉʉ'³¹ je² jen³¹ 'ñée². Jen³¹ jaan²³ 'e³ dxʉ́²³ Dios. Dios Jmii³ ca²³cuǿn²³ Jesús Espíritu Gáan³ 'e³ la²³ ca²³jua'³ 'ñée². 'E³ quie'²³ Jesús mɨ³xíin²³ Espíritu Gáan³ mɨ³¹güii³ la³. Qui² jmee²³ Jesús la²³jɨ³ 'e³ joo³²ra'³, la²³jɨ³ 'e³ nuu³ra'³ rɨ³nɨ²³. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","'A²³la³ 'ñée² 'en³² David. Qui² 'a²³jia'³ ca²³huɨ́ɨ³ yʉʉ'³¹ güii³ jmɨ² ŋu² 'ñée². 'E³ quie'²³ ca²³jua'³: Ca²³jua'³ Dios Juii³ra². Ca²³sɨ'²³ Juiin²³: “Ñí³ jaan²³na²³ 'e³ dxʉ́²³ ");
INSERT INTO cnlNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","la²³huø'n²³ 'e³ rɨ²jmeen²³² 'e³ rɨ²³lín³nu³ juii² dsa³ 'i³ hui²³dsɨ́ɨn² ñin³² 'nʉ³”. La'³ ca²³jua'³ David. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’'E³ jo̱³ 'ne'² rɨ²³núu²³ ca³quie̱e̱² la²³jɨn³ dsa³ Israel 'e³ ca²³jmée³ Dios 'e³ bi²³ gáan³ Jesús, juø'n³ quie'²³ ca²³te̱e̱n²³²na'³ cruz 'nee'²³. Dios ca²³dxin³ Jesús 'e³ rɨ²³lín³ Juii³ra². Ca²³dxin³ 'e³ rɨ²³lín³ Cristo 'i³ rɨ³lø³¹ 'i'²³ 'i³ rɨ²³xíin²³ 'ñée². ―La'³ cu³lø³¹ júu² 'e³ ca²³'ɨ́ɨ³ Peen²³². ");
INSERT INTO cnlNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ma²ca¹núu³ te'²³ dsa³ Israel júu² 'e³ ca²³lʉ́³ Peen²³², bi²³ ca²³ŋɨ́³ dsɨ́²te'²³. 'E³ jo̱³ ca²³jua'³te'²³ ca²³sɨ'²³te'²³ Peen²³² quia̱'² la²³jɨn³ jia'³ cɨ'²³ dsa³ xiin²³: ―Rɨ²xii'³¹ra'³¹ 'nee'²³, te'²³ dsa³ uu'n²na'³¹: ¿Jmii'³¹ 'ne'² rɨ²jmee²ra'³¹ jo̱o̱²³na²³? ");
INSERT INTO cnlNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","'E³ jo̱³ ca²³jua'³ Peen²³²: ―'Ne'² rɨ²tu³¹ra'³ la²³jɨn³na'³ 'e³ jmee³ra'³ 'e³ 'a²³jia'³ dxʉ́²³. 'Ne'² rɨ²³saan²³na'³ jmɨɨ³ 'e³ juo'³ra'³ rɨ³løn³¹na'³ dsa³ quien³² Jesucristo. Jo̱³ hua² rɨ²³je̱'n² dsoo² quien³²na'³. Rɨ²³'íin³ 'óo²ra'³ Espíritu Gáan³ 'i³ cuøn³² Dios. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Qui² ca²³jua'³ Dios Juii³ra² 'e³ dxʉ́²³ dsɨ́² 'e³ rɨ²³cuǿn² quién²na'³ Espíritu Gáan³ quien³². Rɨ²³cuǿn² quie'² jo̱o̱³ra'³ co̱'³. Rɨ²³cuǿn² quie'² dsa³ 'i³ nee'n²³² la²³ca̱a̱n³ je² huɨ̱́ɨ̱³. Rɨ²³cuǿn² quie'² la²³jɨn³ dsa³ 'i³ rɨ²³'náan²³ 'ñée². ―La'³ ca²³jua'³ Peen²³². Ca²³sɨ'²³ dsa³ Israel. ");
INSERT INTO cnlNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bi²³ cɨ² ñúun³ la²³jɨ³ 'e³ ca²³lʉ́³ Peen²³². Ca²³jmée³ júu² 'e³ jmii'³¹ 'ne'² rɨ²³jmóo² dsa³. C