﻿USE sofia;
DROP TABLE IF EXISTS sofia.cniNT_vpl;
CREATE TABLE cniNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cniNT_vpl WRITE;
INSERT INTO cniNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Meeca nosanquenajeitempiro ivajiropee icharinepeeni Jesoquirishito. Tempa irio ishanincani Iravirini aisati Avaramani. ");
INSERT INTO cniNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ari itimini Avarama. Iri itomi iriori: Isaca. Iri itomi iriori Isaca: Jacovo. Iri itomipee iriori Jacovo: Jora aisati irirentipee. ");
INSERT INTO cniNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iri itomipee Jora: Jareshi aisati Sara. Iro irinironi Jareshi opajitani Tamara. Iri itomi Jareshi: Eshiromo. Iri itomi Eshiromo: Arama. ");
INSERT INTO cniNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Iri itomi Arama: Aminarava. Iri itomi Aminarava: Naso. Iri itomi Naso: Saramo. ");
INSERT INTO cniNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Iri itomi Saramo: Voso. Iro irinironi Voso opajitani Arava. Iri itomi Voso: Overe. Iro irinironi Overe opajitani Oroto. Iri itomi Overe: Jese. ");
INSERT INTO cniNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","(6,17a) Iri itomi Jese: Iraviri, yora pincatsaritatsiri. Ari icarajeitaque iriori 14 shirampari. Impoiji itimi itomi Iraviri: Saromo. Iro iriniro Saromo ora yaaveitaniri Oriashi. ");
INSERT INTO cniNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Iri itomi Saromo: Orovoama. Iri itomi Orovoama: Aviashi. Iri itomi Aviashi: Asa. ");
INSERT INTO cniNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Iri itomi Asa: Josavata. Iri itomi Josavata: Jorama. Iri itomi Jorama: Oshiashi. ");
INSERT INTO cniNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Iri itomi Oshiashi: Joatama. Iri itomi Joatama: Acasa. Iri itomi Acasa: Eshequiashi. ");
INSERT INTO cniNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Iri itomi Eshequiashi: Manasheshi. Iri itomi Manasheshi: Amo. Iri itomi Amo: Joshiashi. ");
INSERT INTO cniNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","(11,17b) Iri itomi Joshiashi: Jeconiashi, aisati irirentipee. Ari icarajeiti iriori aisati 14 shirampari. Itimantari Jeconiashi, yora soraropee poneachari Vavironiaqui yaajeitanaqueri maaroni joriopee anta inampiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Impoiji itimi itomi Jeconiashi: Saratiyeri. Iri itomi Saratiyeri: Sorovaveri. ");
INSERT INTO cniNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Iri itomi Sorovaveri: Aviori. Iri itomi Aviori: Eriaquimi. Iri itomi Eriaquimi: Asoro. ");
INSERT INTO cniNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Iri itomi Asoro: Saroco. Iri itomi Saroco: Aquimi. Iri itomi Aquimi: Erioro. ");
INSERT INTO cniNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Iri itomi Erioro: Erisara. Iri itomi Erisara: Mata. Iri itomi Mata: Jacovo. ");
INSERT INTO cniNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","17","(16,17c) Iri itomi Jacovo: Jose. Iri Jose ojimetsori Maria, ora iriniro Jesoshi. Ipajitiri aisati Quirishito. Ari icarajeiti maaroni iriori shirampari 14. ");
INSERT INTO cniNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Meeca noncamantempi jaoca ocantari itimantacari peerani Jesoshi. Ainiro yora Jose ijinatsori, opajita Maria. Isareacaro irayero, iro cantaincha tequera irineero. Iro cantaincha otsomontetaque: iro otsomontetantacari otasoncaquero Ishire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iro iotantacari Jose otsomontetaque, iquenqueshireaca iriori: “Te oncameetsateji tsinane. Timatsiata oneayetiri. Eiro nairotsi”. Iro cantaincha icameetsataque, icoaque incavintsayero Maria, te irininteji iroashiventayero; iquenqueshiretanaca: “Eiro nocamantajeitiritsi oshanincapee, ishirontimentarocari. Apaniro noncantero irointi: ‘Eiro meeca naimpitsi’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Irootaque iquenqueshiretanaqueri, irosati imapocantacari inampire Tasorentsi, ineamainetaqueri. Icantapaaqueri: —Jose, tempa aviro ishanincani Iravirini, eiro piquenqueshireatsi. Tecatsi onee shirampari pijinatsori. Iro otsomontetantacari otasoncaquero Ishire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Coajica ontimeri otomi, pimpajiteri iriori Jesoshi. Iro pimpajitanteariri Jesoshi iroavisacojeiteri antayetirori caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Iro intimanteari iriori omoncaratanteari isanquenatiniri peerani camantantatsiniri Isayashini. Irio Avincatsarite sanquenatacaaqueriri. Jero oca icantiniri: ");
INSERT INTO cniNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Coajica ontsomontetashitanaquea caari neiri shirampari, ontimeri otomi. Impajiyeeteri Emanoere”. Iro Emanoere ocanti aneanequi arori: “Itsipajeitaquee Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ari itinaanaca Jose, iquemisantaquero icantaqueriri. Ijatashitaquero Maria, icantaquero: —Ari coajica naasanotempi. ");
INSERT INTO cniNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Iro cantaincha tequera irineeroji: iro caariquera ineantaro, tequera intimeji otomi. Itimantacari, ipajitaqueri Jesoshi. Impoijiquea yaasanotaquero. ");
INSERT INTO cniNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ari itimapaaque Jesoshi anta Verequi. Otimi Vere anta Joreaqui. Itimantacari Jesoshi, irio pincatsariventantatsiri Eroreshi. Ari yareetapaaca Jerosarequi poneajeitachari pashiniqui quipatsi, anta arejiqui. Iquenapaaque anta iquenapainta catsirincaiteri. Ishiavetari saserotepee, ioyevetari impoquiropee, paitaricapee. ");
INSERT INTO cniNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Isampitapaaqueri jerosaresati: —¿Jaoca yora ivincatsarite joriopee, yora iroaquera timaintsiri? Noneaqueri anta nonampiqui impoquiro iotacaanari itimaque. Meeca nopoqui nompincatsateri. ");
INSERT INTO cniNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Iquemantacariri yora pincatsari Eroreshi, iquenqueshireanaca, aisati iquempejeitaca maaroni jerosaresati. ");
INSERT INTO cniNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Impoiji yora Eroreshi icajemacantajeitaqueri maaroni jivatacaajeitaqueriri saserotepee aisati maaroni yora oametantajeitirori sanquenarentsi. Isampijeitaqueri: —¿Paita ocantiri Sanquenarentsi? ¿Jaoca intimapeeri yora Quirishitotatsiri? ");
INSERT INTO cniNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yacajeitanaqueri: —Ocanti Sanquenarentsi intimapaaque Verequi, aca Joreaqui. Irootaque isanquenatacotitacariniri peerani yora quenquetsatacantantatsiniri pajitachaniri Miqueashi: ");
INSERT INTO cniNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Otimi Vere anta Joreaqui. Eiro itseencajeitirotsi ora nampitsi. Tempa imponeaquea anta Pincatsarisanori. Impincatsariventajeiteri maaroni joriopee”. ");
INSERT INTO cniNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Impoiji imanaquero Eroreshi icajemacantaqueri yora coatsiri irineeri Jesoshi. Isampijeitaqueri: —¿Jaoca ocaratiri pineantacariri impoquiro piotantacari itimapaaque pincatsari? Pincamantasanotena niotasanotantearori itimantacari. ");
INSERT INTO cniNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ari icamantaqueri. Impoiji icantaqueri aisati: —Cameetsa pijajeite meeca Verequi, pamenaiteri jaocarica isavicasanotaqueri yora jananequi. Ariorica pineapaaqueri, pimpocaje aisati aca, pincamantapeena. Nocoaque noneeri narori, nompincatsatanteariri. ");
INSERT INTO cniNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ari ijajeitanaque. Nianqui ineajiri aisati impoquiro ineaqueri chapinqui anta iponeacanta. Ijivatanaqueri impoquiro anta itimaquenta jananequi, impoiji yaratincapaaque anta, iojeitantapaacarori ivanco. ");
INSERT INTO cniNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Iquimoshireimentasanotacari impoquiro iotacaajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Impoiji ijatanaque pancotsiquinta, iqueapaaque. Ineapaaqueri Jesoshi, aisati iriniro. Itiyeroashitapaacari Jesoshi, ipincatsatapaaqueri. Impoiji itatareapaajiro itsivoote, yaajiro ashirotatsiri pajitachari oro. Opinatasanotaca. Aisati yaajiro casancayetatsiri, ipajeitapaaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Impoiji imaajeitanaque irioripee. Ineamainetaqueri Tasorentsi, icantaqueri: —Eiro pipianajatsi anta Eroreshiqui; ariorica pimpianaje piipatsitequi, pinquenanaje pashiniqui avotsi. ");
INSERT INTO cniNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ari ipiajeitanaja yora iovetariri impoquiropee. Impoiji aisati yora Jose ineamainetaqueri inampire Avincatsarite. Icantapaaqueri: —Meeca pijajeite: avirori, yora jananequi, aisati iriniro. Pishiajeitanaque Ejipitoqui. Pisavicajeitapaaque anta irosati noncantantempiri. Irotaintsi incoayeteri Eroreshi yora jananequi. Icoaque iroyeri. ");
INSERT INTO cniNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Irosati ijajeitantanaca, nianquiiteni tsiteniri. Yaanaqueri jananequi anta Ejipitoqui, itsipatanacaro iriniro. ");
INSERT INTO cniNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ari osamanitanaque isavicajeitapaaque anta. Impoiji icamaque Eroreshi. Iquemacotaqueri icamaque, irosati ipiajeitantaja anta iipatsitequi. Irootaque peerani isanquenatacotaqueniri oca yora quenquetsatacaantatsiniri pajitachari Oseashi. Iriotaque Avincatsarite sanquenatacairiri. Isanquenatini: “Icanti Tasorentsi: ‘Intimavetea notomi anta Ejipitoqui, noncajemajeri impiaje aisati’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Impoiji ionirotanaque Eroreshi yamatavitaqueri yora iovetariri impoquiropee: te impiajeji aisati. Ari iquisasanotanaca, itiancaqueri soraropee, icantiri: —Pijajeite anta Verequi, poajeiteri maaroni jananequipee, pintsoncajeiteri maaroni shirampari: iroaquera timayetatsiri, maaroni; aisati poajeiteri moncaratainchari apite irosarintsite, maaroni. Ja, icantaqueri chapinqui yoranqui tequera irimoncarateroji Jesoshi apite irosarintsite. ");
INSERT INTO cniNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aisati isanquenatacotaqueroni oca yora quenquetsatacaantatsiniri pajitachaniri Jeremiashi: ");
INSERT INTO cniNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Oncajemacotasanoteri aramasato otomipee, oshequi iraacojeiteri. Ompajitea Araquere iraacoterineri otomipee. Iro oashiretanteari iroiteetero otomipee, maaroni”. ");
INSERT INTO cniNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ari impoiji icamaque Eroreshi, ainiroquera isaviqui Jose iriori anta Ejipitoqui. Impoiji ineamainetajiri aisati inampire Avincatsarite, icantaqueri: ");
INSERT INTO cniNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Tsame pimpianaje anta piipatsitequi, paanajeri jananequica aisati iriniro. Camaque meeca coavetachari iroyerime. Ari ipajijeitirori iipatsite Jose iipatsiteni Ishiraerini. ");
INSERT INTO cniNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ari ijatanaji, yaajeitanajiri anta iipatsitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Iro cantaincha yareetantajari Jose, icamanteetiri: —Irio pincatsariventajeitiriri meeca joreasati yora Arequerao. Ipoyeetajari iririni: yora Eroreshini. Ari aisati itsaroacaapaacari Jose yora pincatsaritajantsiri, aisati ineamainetaqueri Tasorentsi, icantiri: —Paamayeariyea yora Arequerao. Irosati yovaantanaja Jose anta Carireaqui. ");
INSERT INTO cniNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yareetapaaca, isavicapaaque nampitsiqui pajitachari Nasarete. Irootaque omoncaratantacari isanquenatacotiteetacariniri Jesoshi: “Imponeaquea Quirishito Nasaretequi”. ");
INSERT INTO cniNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ari impoiji ijataque Joa, yora vaotisatantatsiri ora caaraiteriqui: ora carireaquiniri. Iquenquetsatacaapinitiri ishaninca, ");
INSERT INTO cniNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","icantapinitiri: —Pinquenqueshirejeitanaquea, eiro piquempejeitajatsi peerani: paventajeiteari meeca Tasorentsi, irotaintsi impincatsariventajeitee. ");
INSERT INTO cniNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ari peerani iquenquetsatacotaquerini Joa yora quenquetsatacaantatsiniri pajiveitachaniri Isayashi. Jero oca isanquenatacotaqueriniri Joa: “Coajica inquenquetsatacaajeiteri ishaninca anta caaraiteriqui, incanteri: ‘Paamayeariyea Avincatsarite, pincameetsatanaque paacameetsatavacaajeitanteari’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Irio iquitsaatari Joa tijachari iviti cameyo. Irio ishiticatsaquitari meshinantsitsa. Yoapinitari quentori aisati irapinitiri ija pitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ijatashijeitaqueri maaroni jerosaresati iquemisantajeitavaqueri, aisati maaroni joreasati aisati maaroni savicajeitatsiri Joriraniqui. ");
INSERT INTO cniNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Icantajeitapaaqueri: —Ainiro nantayetiri caari cameetsatatsi. Nocoaque incavintsayena Tasorentsi, iroavisacotajena. Impoiji ivaotisajeitavaqueri Joa Joriraniqui. ");
INSERT INTO cniNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aisati ipocajeivetaca variseopee aisati saroseopee, icoajeivetaca irivaotisajeiteame, iro cantaincha iquisatsatavaqueri Joa. Icantavaqueri: —Te pincameetsajeitejive, quempejeitaquempi maranque. ¿Pijitashijeivetampa eiro yoasanquejeitimpitsi Tasorentsi? ");
INSERT INTO cniNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Picoajeitaquerica novaotisajeitempi, ari cameetsa pisavicajeite niotanteari pojocasanotaquero caari cameetsatatsi pantapinijeitiri. ");
INSERT INTO cniNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Picantajeivetaca: “Narojeitaque ishanincani Avaramani, aitaque irineacameetsataquena Tasorentsi”. Pamatavitaja avisati. Incoaquericame Tasorentsi, impeajerome oca mapi ishanincani Avaramani, iro cantaincha eiro ojatitsi inquitequi. Aisati piquempejeitaca avirori: patsipetashijeitacaro pishanincavetacari Avaramani. ");
INSERT INTO cniNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tempa achaquitapinitiro inchatopee caari timatsi oitsoqui, impoiji ataajeitajiro. Aisati inquempetea Tasorentsi, irotaintsi iroasanquejeiteri maaroni caari antiniri icoacaajeivetariri. ");
INSERT INTO cniNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ariorica niotaque yojocajeitiro atiripee caari cameetsatatsi yantajeitaqueri, novaotisajeitaqueri nijaqui. Iro cantaincha timatsi impoitapeenaneri: intiancajeiteneri iriori quemisantajeiterineri Ishire Tasorentsi, irinti tseencantatsiri iroasanquejeiteri. Oshequi ipincatsaritaque irinti impoitenaneri. Oshequi nopincatsataqueri; notseencaja narori catsini. ");
INSERT INTO cniNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ariorica aviitero aroso, impoiji antincaiquitero. Otaqui antayero, irointi oitsoqui anquempoyeajero onantariqui. Aisati inquempetea Avincatsarite, irinashitacaajeitajeari atiripee: incavintsayeri quemisantajeiterineri, irintiquea caari cameetsatatsine irojocajeri paamariqui, ora caari tsivacanetatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Impoiji ijataque Jesoshi Joriraniqui, iponeanaca Carireaqui. Ijatashitaqueri Joa, irivaotisatantavaqueariri. ");
INSERT INTO cniNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Te incoaveteaji Joa irivaotisateri, icantavaqueri: —Eiro novaotisatimpitsi avinti. Aviroquea vaotisatapeenane avinti. ¿Paita picoantari novaotisatavaquempi avirori? Oshequi pipincatsaritaque. ");
INSERT INTO cniNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yacanaqueri Jesoshi: —Nocoasanotaque pivaotisatavaquena. Irootaque icoacaaquenari Tasorentsi. Icantaqueri: —Ari, novaotisataquempi. ");
INSERT INTO cniNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ari ivaotisataqueri, impoiji yaatanaji. Impoiji iriori Jesoshi, ineavaquero Ishire Tasorentsi, oponeaca inquitequi, aniireashitapaaqueri, oshiavetapaacari sampaquiti. Aatapaaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Impoiji iquemajeitaqueri Tasorentsi anta inquitequi, icanti: —Iriotaque yoca notomi nonintasanotaqueri. Oshequi noveshireimentacari. ");
INSERT INTO cniNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Impoiji Ishire Tasorentsi aanaqueri Jesoshi anta ocaraiteapai. Aitaque ocoaqueri irineantaveteari camaari. Icoavetaca camaari irantacayerime Jesoshi caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ari itimaque Jesoshi anta ocarataque 40 quitaiteri, te iroyeaji catsini. Aasanotaqueri itashe. ");
INSERT INTO cniNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Impoiji yora camaari ijatashitaqueri Jesoshi, irineantapeempariri. Icantavetapaacari: —Avirosanotaquerica Itomi Tasorentsi, jentsite, pimpeero mapica pitantane, poantearori. ");
INSERT INTO cniNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yacanaqueri Jesoshi: —Te apaniro oncoiteimotee atantane, irointi acoaque anquemisantero maaroni icantaqueeri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Impoiji yaanaqueri camaari anta Jerosarequi: anta ochoviinaquiitapaaque ivanco Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Icantavetacari: —Avirorica Itomi Tasorentsi, pisapocanaque oshaavijinta quipatsiqui. Pinquenqueshireero ocantiri Sanquenarentsi: “Intianquempiri Tasorentsi inampire inquempoyempi. Irancatsatavajempi eiro pipariantatsi mapiqui”. ");
INSERT INTO cniNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yacanaqueri: —Aisati ocanti Sanquenarentsi: “Eiro pineantaritsi Pivincatsarite, tempa irio Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aisati yapiivetajari camaari, yaanajiri antearoqui toncaari. Ijicotapainiri maaroni quipatsi, icantavetari: —Pineajeitaqueri maaroni savicajeitatsiri, aisati tempa ocameetsajeitaque maaroni imajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ariorica pimpincatsatena narori, noncamantajeiteri maaroni impincatsajeitempi avirori. ");
INSERT INTO cniNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yacanaqueri aisati: —Pijanirotaje. Avironiro Satanashi. Tempa ocanti Sanquenarentsi: “Pimpincatsatasanoteri Avincatsarite, tempa iriotaque Tasorentsi. Apaniro irinti catsini pinquemisanteri”. ");
INSERT INTO cniNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Irosati ijatantanaja camaari. Impoiji ipocaque inampirepee Tasorentsi, intacojeitacari. ");
INSERT INTO cniNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Impoiji iquemaque Jesoshi yoyeetaqueri Joa caravosoqui, irosati ipiantanaja Carireaqui. ");
INSERT INTO cniNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Iro cantaincha te irisavicapeeji Nasaretequi, ainti ijataque Caperenaoqui, isavicapaaque anta. Otimi Caperenao anta otsapijaqui antearoja incajare. Otimi quempeji Savorono aisati Nejatari. ");
INSERT INTO cniNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Aisati isanquenatacotaqueroni oca yora Isayashini peerani: ");
INSERT INTO cniNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Otimi Savorono aisati Nejatari otsapijaqui incajare, anta Joriraniqui intatiquero, anta Carireaqui. Anta itiminta oshequi itsipapee atiri, caari inajeiti jorio. ");
INSERT INTO cniNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Oquempetimojeivetacari itimini tsiteniriqui, te iriojeiveitearini Tasorentsi. Irijajeiteme Sharincaveniqui, iro cantaincha meeca oquempetaca itimi quitaitetacojeitiriri, iotacaajeitiriri”. ");
INSERT INTO cniNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ari intanacarori Jesoshi iquenquetsatacaajeitaqueri atiri anta, icantajeitaqueri: —Pinquenqueshirejeitanaquea, eiro piquempetajatsi peerani. Irotaintsi impincatsariventajeitempi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ari ishiteatanaca Jesoshi anta otsapijaqui incajare: ora timatsiri Carireaqui. Ineapaaqueri apite shirampari, yora Shimo Petero, jeri aisati irirenti, yora Antirishi. Irio quitsatapinitiriri shima. Ineapaaqueri Jesoshi, iquitsajeiti, ");
INSERT INTO cniNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","icantapaaqueri: —Tsame poijatanaquena. Nocoaque pinquemisantacaapiniteri atiri. ");
INSERT INTO cniNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Irosati yojocajeitantanacaro iitsarite, yoijajeitanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ari yavishimatanaque irosati ineantapaacari Santiaco aisati Joa. Iriojeitaque itomipee Severeo. Isavicajeiti ivitoqui, ishiticajeitiro iitsarite. Icajemapaaqueri Jesoshi, ");
INSERT INTO cniNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","irosati yoijajeitantanacari. Yojocajeitanaqueri iriri apaniro anta ivitoqui. ");
INSERT INTO cniNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iquenaquenayetanaque Jesoshi anta Carireaqui. Maaroni nampitsiqui iquenquetsatacaajeitaqueri atiri anta pancotsiqui yapatotapinijeitantari. Icantiri atiri jaoca icanta Tasorentsi ipincatsariventajeitaquee. Yoavisaacojeitaqueri oshequi mantsiaripee: onashiyetaca aayetiriri imantsiare. ");
INSERT INTO cniNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iquemacojeitaqueri Jesoshi yora savicajeitatsiri anta arejiqui: iotacotaqueri maaroni shiriasati. Yaajeitanaqueneri Jesoshi oshequi ishaninca mantsiayetatsiri iroavisacojeiteri. Yojoquiiyetaca, icatsiyetaque, icamanatapiniyetaque, iquisoporoquiyetaque. Aisati yaanaqueneri neayetiriri camaari. Ari yoavisacojeitavaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yoijajeitaqueri oshequi carireasati, tecaporishisati, jerosaresati, joreasati, poneayetachari Joriraniqui intatiquero. ");
INSERT INTO cniNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ineajeitaqueri Jesoshi icarajeitaque oshequi apatotimentajeitariri, ari ijataque toncaariqui, isavicapaaque anta. Yora iroamerepee yapatojeitaqueri atiri, maaroni. Icantajeitaqueri ishoncajeitapaacari. ");
INSERT INTO cniNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Impoiji yoamejeitaqueri, icantajeitaqueri: ");
INSERT INTO cniNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Inquimoshiretacaajeiteri Tasorentsi maaroni caari shemetatsi, impincatsariventajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Inquimoshiretacaajeiteri Tasorentsi maaroni oashirejeivetainchari, iroimoshirencajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Inquimoshiretacaajeiteri Tasorentsi maaroni ashinoncaincari, incavintsaajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Inquimoshiretacaajeiteri Tasorentsi maaroni coasanotatsiri intime cameetsa, iramitacojeiteri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Inquimoshiretacaajeiteri Tasorentsi maaroni cavintsaajeitiriri ishaninca, incavintsaasanojeiteri iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Inquimoshiretacaajeiteri Tasorentsi maaroni cameetsashirejeitatsiri, irineajeitajeri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Inquimoshiretacaajeiteri Tasorentsi maaroni oimajerentajeitaqueriri quisachari, intomintajeiteari. ");
INSERT INTO cniNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ariorica pincameetsatanaque, irootaque inquisantempiri, ari pinquimoshiretanaque: aviro savicasanotatsineri anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Iriotempirica atiri piquemisantajeitaquena, incantimatempi, inquisaquempi, intseeyacotaquempi. Ari pinquimoshirejeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pinquimoshirejeitanaque, piveshireajeitanaquea: impinatasanojeitempi Tasorentsi anta inquitequi. Eiro pipeacotarotsi: tempa peerani iquisheetirini iriori yora camantantatsiniri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Aisati icantajeitaqueri Jesoshi: —Tempa ativitapinitiri ivatsa eiro ishititantatsi. Irompa terica ompoteate, ontimaite: tempa ari ajocajero, tecatsi coyeroneri. Piquempejeivetacaro tivi: avirojeitaque oameetsajeiterineri atiri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ariorica otimi nampitsi anta toncaariqui, otsiota maaroni pancotsipee tsiteniriqui. Tecatsi ancantero nampitsi amanero, tempa oconijatasanoti. Aisati piquempejeitacaro, aviro oamejeiterineri maaroni atiri: eiro pimanirotsi piojeitiri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aisati, ariorica pintsiotero pitsiomento, te pimanapiniteroji otapinaqui cantiri. Tempa poapinitiro anta onantariqui yamenajeitantari maaroni savicajeitatsiri pancotsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aisati aviroripee, cameetsa pisavicajeitanaque irineajeitantempiri maaroni pishanincapee ocameetsataque maaroni pantajeitaqueri. Impoiji irineacameetsajeitanteariri Apa savicatsiri inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Aisati icantajeitaqueri: —Eiro pijitashijeitatsi nocoaque nojocacaajempiro piquemisantiro isanquenare Moishishi aisati icantajeitiniri yora quenquetsatacaantatsiniri. Iro cantaincha nocoaque noamejeitempiro icantasanojeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Queariotaque oca noncamantempiri: ontsoncajearica quipatsi aisati inquite, iro cantaincha eiro otsonquimatatsi catsini isanquenajeitaqueri. Omoncarataquea maaroni icantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eirorica piquemisantasanotiro isanquenatiniri, aisati ariorica poameteri pishaninca eiro iquemisantasanotiro, eiro ineacameetsatasanotimpitsi Tasorentsi anta ipincatsaritinta. Iro cantaincha ariorica pinquemisantasanotaquero maaroni isanquenajeitiniri, aisati ariorica poamejeiteri pishaninca inquemisantasanojeitero, ari pimpincatsariventasanotantapaaje anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","¿Pijitashijeitacarimpa icameetsajeitaque yora oametantirori sanquenarentsi aisati yora variseopee? Meeca noncamantempi: te irimoncarajeiteroji icoacaajeivetariri Tasorentsi. Eirorica panaacojeitiritsi pincameetsatasanote, eiro pijatitsi anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Aisati icantajeitaqueri: —Piojeitaquero icantiniri yora intacaroniri: “Eiro poanti. Ariorica poante, iroasanquetayempi Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Iro cantaincha noncamantempi: eiro piquishiritsi pishaninca: yoasanquetaimpicari Tasorentsi. Eiro picantiritsi: “Te pioteji”: iquishimpicari yora oametavacainchari. Eiro picantimatiritsi pishaninca: pitaacari anta Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Pamene, ariorica pijate anta ivancoqui Tasorentsi poaqueneri pivira pimpanteariri; iro cantaincha otimirica iquishimentaquempiri pishaninca, ");
INSERT INTO cniNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","aritsita icantavacatsita pivira, pijatashiteri yora quisaquempiri. Pincamanteri: “Eiro napiitajirotsi caari cameetsatatsi. Pincavintsayena aacameetsatavacaajeitantajeari”. Ariorica cameetsa paacameetsatavacaajea, ari pimpianaje ivancoqui Tasorentsi, irosati pimpantapeempariri pivira. ");
INSERT INTO cniNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ariorica intime quishempineri aanaquempineri anta joeshiqui. Ari pishintsite pincantajeri: “Eiro piquisajanatsi, tsame aacameetsatavacaajea aisati”. Ariorica irareetacaapaaquempi joeshiqui, incanteri variria: “Paanaqueri yoca”, impoiji iroiminqueaquempi anta caravosoqui. ");
INSERT INTO cniNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Impoiji eirorica pipinatasanotiri maaroni pirevitiriri, eiro yoimisoquijacantajimpitsi aisati. ");
INSERT INTO cniNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Aisati icantajeitaqueri: —Piojeitaquero icantaqueri intacaroniri: “Eiro paimentarotsi pijina, eiro paimentaritsi pijime”. ");
INSERT INTO cniNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Noncamantempi nainti: ariorica pinevetearo tsinane aisati pinquenqueshiretero pantero, ainiro pantane; aitaque pinquenqueshiretaquea paimentearo pijina. ");
INSERT INTO cniNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Noshiacantempiro: ariorica antacayempi poquisanori caari cameetsatatsi, pinquitsoreero, pojocajero. Te pininteji catsini ojatacayempi Sharincaveniqui. Tempa ocameetsati pijanaroquitashitea anta inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ariorica antacayempiro pacosanori caari cameetsatatsi, pimpesajero, pojocajero. Te pininteji catsini ojatacayempi Sharincaveniqui. Tempa ocameetsati pijacaraquitanaje anta inquitequi. Pineaquero, te oncameetsateji catsini pampiitapinitero caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Aisati icantaqueni yora intacarori: “Ariorica pincoaque pojocajero pijina, pisanquenatenero paperi pojocantajearori, ari moncarataca”. ");
INSERT INTO cniNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Iro cantaincha noncantempi nainti: eiro catsini pojocajirotsi pijina. Ariorica pojocajero pijina, aisati paaje pashini, aitaque paimentaquearo pijinasanori: paavioncaque pijina. Aajerica aisati pijina ontime antane: aimenteari ojimesanori. Aisati yora aajeroneri, ontime irantane. Irointiquea apatiro ocameetsaveta pojocajero ariorica aimentaquempi, tecatsi pashini. ");
INSERT INTO cniNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Aisati icantaqueri Jesoshi: —Piojeitaque ocantini Sanquenarentsi. Oametaquerini ashanincani: “Pintseeyarica, eiro picantashitatsi: ‘Ioti Avincatsarite nomoncaratempiro maaroni nocantaquempiri. Ariorica namatavitimpi, iroyenata’. Ariorica pincante: ‘Ioti Avincatsarite nomoncaratero maaroni nocantaqueri’, ari pimoncaratero, maaroni”. ");
INSERT INTO cniNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Irootaque isanquenatiniri peerani. Iro cantaincha nocantimpi nainti: ¿paita pincoanteari pincante: “Ioti Avincatsarite queario oca nocantaqueri”? Ocameetsataque pimoncaratasanotaquero maaroni picantaqueri. Eiro aisati picantitsi: “Tempa ocantani otimi inquite, aisati noquempeta narori, nocantani tampatica noneanati”. Noncantempi nainti: iro inquite isavicantari Tasorentsi; iotimpi, ioti queariorica picantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aisati eiro picantitsi: “Tempa ocantani otimi quipatsi, aisati narori nocantani tampatica noneanati”. Noncantempi narori: itsoteiro Tasorentsi quipatsi, iotimpi; ioti queariorica picantaqueri. Eiro picantitsi: “Tempa ocantani otimi Jerosare, aisati narori nocantani tampatica noneanati”. Noncantempi: ipincatsariventajeitiri Tasorentsi jerosaresati, iriotaque pincatsarisanori. Ioti queariorica picantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Eiro picantitsi: “Eiro notseeyatsi, irosati noncamantaquea, noncanteani tampatica noneanate”. Tempa irio Tasorentsi cantatsine jaocarica oncarate ancame. Pimpincatsateri irinti, irio iotimpiri pitseeyanirica. ");
INSERT INTO cniNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Eiro pitseeyatsi, eiro pamatavitantitsi. Queariorica pantero paitapeerica, pincante: “Je, nantero”. Eirorica pantirotsi, pincante: “Eiro nantirotsi”. Moncarataca. Te oncameetsateji pishequiyero pineane pamatavitanteariri itsipapee. ");
INSERT INTO cniNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jero aisati icantajeitaqueriri Jesoshi: —Aisati icantaqueniri iriori yora intacaroniri: “Ariorica pinquitsoreero iroqui itsipa, ocameetsati impiatacoventajeari inquitsoreitempiro poqui avirori. Ariorica pijireiteri pishaninca iraji, ocameetsati impiatacoventajeari, irijireitempiro paji avirori”. ");
INSERT INTO cniNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Iro cantaincha noncantempi nainti: eiro pipiataritsi quisajeitaquempiri, irointi ariorica impasavorotempi acaqueroca, pishineteri aisati otsipa pivoro impasatero aisati. ");
INSERT INTO cniNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ariorica incoaque atiri iraitempiro piitsaare, pimpavaqueri aisati poicoro. ");
INSERT INTO cniNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ariorica imperanatempi paanajeneri irovaararo aparoni quirometero, poavisayeneri apite quirometero. ");
INSERT INTO cniNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ariorica incantapeempi pishaninca: “Pimpenaro”, ari pimpavaqueri. Aisati, ariorica incantempi: “Pimpashitavaquenarota oca”, ari pimpashitavaqueari, eiro pitsaneapitsataritsi. ");
INSERT INTO cniNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Aisati icantajeitaqueri: —Aisati icantaqueni yora intacaroniri: “Pininteri pishanincasanori, pincavintsayeri. Irintiquea quisaquempiri, pinquisavaqueri iriori”. ");
INSERT INTO cniNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Iro cantaincha noncantajeitempi nainti: pinintajeiteri maaroni quisajeitaquempiri, pincavintsayeri, pincanteri Tasorentsi incavintsayeri, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Irootaque icoacaajeitaqueriri Tasorentsi maaroni quemisantajeitiriri itomintajeitacari. Tempa iriotaque vetsiquiriri catsirincaiteri: yovoreacojeitaqueri maaroni atiri, cameetsajeitatsiri aisati caari cameetsajeitatsi. Aisati incani, yoariajeitaqueneri maaroni atiri: yora quemisantatsiri aisati caari quemisantatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ariorica pincavintsayeri apaniro yora cavintsaimpiri, ¿pijitimpa irineacameetsatempi Tasorentsi? Tempa ioti tseencantatsiri icavintsaavacaajeita iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ariorica pincavintsayeri apaniro yora shanincatasanojeitimpiri, ¿paita pishemetanteari? Aitaque iojeiti maaroni caari ioterine Tasorentsi icavintsaavacaajeita iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pincameetsatasanotanaque catsini, pinquempejeitanaqueari Apa Tasorentsi: tempa icameetsatasanotaque irinti catsini. ");
INSERT INTO cniNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Aisati icantajeitaqueri Jesoshi: —Eiro pishiacantanirotatsi piquemisanti, eiro piquemisantamempeatsi pamatavitantearirime atiripee. Ariorica irineaquempi Apa Tasorentsi pishiacantaca, eiro ineacameetsatimpitsi iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ariorica pimpashiteari ashinoncaincari coiteimojeitacariri, eiro picamantajeitiritsi itsipapee. Irootaque yamenirojeitari yora shiacantavetachari iquemisanti. Ariorica ipiri ashinoncaincari paitarica, icamantajeitaqueri quemisantajeitatsiri, aisati savicajeitatsiri anta nampitsiqui. Icoanirojeitaque iriori irineacameetsajeiteri ishaninca. Ariorica irineacameetsaveteari ishaninca, iro cantaincha moncarataca: eiro ineacameetsatiritsi iriori Tasorentsi, tecatsi impinateri. ");
INSERT INTO cniNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ariorica pincavintsayeri ashinoncaincari, pimanaquero: eiro piotacaajeitiritsi itsipapee. ");
INSERT INTO cniNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ari iriotaque Tasorentsi irinti, impinatempi irinti. ");
INSERT INTO cniNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Aisati icantajeitaqueri: —Ariorica pinquenquetsatacayeri Tasorentsi, eiro piquempetaritsi shiacantavetachari: icoaque iriori incatiye anta yapatojeitanta atiripee, aisati anta nampitsiqui nianqui, irineantanirojeitavaqueariri ishanincapee. Queario oca noncamantempiri: moncarataca. Ariorica irineacameetsajeiteri ishaninca, iro cantaincha eiro ineacameetsatiritsi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ariorica pinquenquetsatacayeri, pijate apaniro pivancoqui, pashitacotanaquea tsompoina, impoiji pinquenquetsatacayeri Apa. Irineaquempi apaniro irinti, irineacameetsatempi, impinatempi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ariorica pinquenquetsatacayeri, eiro pineanatashiveeta, vero, vero, vero. Aitaque yametaro caari iotiri Tasorentsi, ineaveetashita. Ijitashijeiveta ariorica irineanatashiveetea, ari inquemisantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Queariyea, piquempejeitaricari avirori. Iotasanotiro Tasorentsi maaroni coiteimojeitaquempiri. Tequerata pincanteri, iotitacaro coiteimotaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ariorica pinquenquetsatacayeri Tasorentsi, ari pinquempetaquerori avirori oca: Apa, savicatsiri inquitequi, oshequi nopincatsatasanojeitaquempi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pimpincatsariventajeitena narori. Nocoajeitaque aca quipatsiqui nomajeitempiro maaroni pincoacaajeitenari, nonquempeteari pinampirepee anta jenoqui: tempa imajeitaquempiro iriori maaroni picoacaajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pimpapinijeitena noyeari coiteimotaquenari. ");
INSERT INTO cniNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ainiro nantajeitiri caari cameetsayetatsi, iro cantaincha eiro poasanquetimentanarotsi, irointi nocoajeitaque pincavintsaajeitena. Aisati narori noncavintsaajeiteri noshaninca antanajeitenaneri paitapeerica, eiro noquishiritsi iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Eiro pishinetiritsi yora camaari irineantajeitena, eiro pishinetiritsi irantacaajeitena caari cameetsatatsi. Pincantaitatiyempani pimpincatsariventajeitena. Pincantaitatiyempani pintasoncaventajeitena. Aisati narori, noncanteani nompincatsajeitempi, maaroni. Irootaque nocantaquempiri, ari. ");
INSERT INTO cniNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Aisati icantajeitiri: —Ariorica pincavintsayeri quisajeitaquempiri, incavintsaajeitempi avirori Apa savicatsiri inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Iro cantaincha eirorica picavintsairitsi pishanincapee, eiro icavintsaajeitimpitsi Apa. ");
INSERT INTO cniNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Aisati icantajeitiri: —Aisati, ariorica pintitea pinquenqueshiretanteariri Tasorentsi, eiro piotacaajeitiritsi itsipapee. Eiro piquempetaritsi yora shiacantachari iquemisanti: ariorica ititapinita, yoashirevorotashitaca iriojeitanteari ishaninca itita. Yatsipetashitacaro, te inquenqueshireteriji Tasorentsi, irointiquea icoaque incavintsaajeiteri ishaninca. Eiro ipinatiritsi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ariorica pintitimenteari Tasorentsi pinquenqueshiretanteariri, cameetsa pinquishitea, pinquivavorotea aisati, ");
INSERT INTO cniNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","oncanteata eiro iotanta pishaninca pitita. Apaniro iriotempi irinti Piri jenoquiniri, impinatempi irinti. ");
INSERT INTO cniNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Aisati icantajeitiri Jesoshi: —Eiro pipiotirotsi pivaararo aca quipatsiquica: opatsaaranticari, aisati icoshiyeetimpicari. ");
INSERT INTO cniNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aintiquea pimpiotero pivaararo anta inquitequi: eiro ainti opatsaitsi, aisati eiro ainti icoshiyeetajimpitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ariorica ontime pivaararo aca quipatsiqui, pinquenqueshiretapinitero timajeitatsiri aca quipatsiqui; iro cantaincha ontimerica pivaararo inquitequi, pinquenqueshiretapiniteri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Otimi poqui pamenantari, otimantari piotantari. Oshiaquero tsiomentotsi pitsiotapinitantari tsiteniriqui pineantari. Ariorica ocameetsataque, piojeitanaque, ");
INSERT INTO cniNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","iro cantaincha eirorica ocameetsati, eiro pamenitsi, eiro piotitsi, pintime tsiteniriqui. Aisati oquempetaca, ariorica pinquenqueshiretapinitero caari cameetsatatsi, eiro piotiritsi Tasorentsi, ainti pintime tsiteniriqui. ");
INSERT INTO cniNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Pashini aisati icantiriri Jesoshi: —Tecatsi pincantea pintsameeteneri apite pivatorote, aisati oquempetaca: ariorica panteneri Tasorentsi icoacaaquempiri, irompa ariorica pantaveetanontea avisati paantearori pivaararo. Tecatsi pincantero apite. Pineaquero, ariorica pinintasanoteri Tasorentsi, eiro picoitsi pivionquero pivaararo. Aisati, ariorica pincoaque pivionquero pivaararo, eiro picoitsi pinquemisanteri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Aisati icantajeitiri Jesoshi: —Meeca noncamantajeitempi: eiro piquenqueshiretapinitirotsi paitapeerica poayeteari, pirayeteri, pinquitsaatapiniteari, paitapeerica. ¿Irompa pitimantari poapinitearo poari? Te iro pintimantea, tempa iro pitimantari pinquenqueshireteri vetsicanaquempiri. ¿Irompa otimantari pivatsa pinquitsaatero, poaneenquero? Te iro ontimantea. Irointi pitimajeitanta piojeiteri Tasorentsi, aisati panteneri icoacaajeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pamenajeiteri yora tsimeripee: te impanquitanonteaji, aisati te irantanonteaji ivanco irivioncantearori ivanquire. Iro cantaincha ipapinitiri Apa Tasorentsi yoari maaroni quitaiteriqui. Ari icavintsairi maaroni quitaiteriqui; tempa avinti icavintsaasanotaquempi, eiro yoashinoncaimpitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ariorica pinquenqueshirete, ¿arimpa pimatero pishequiajero pisarintsite? Eiro. Patsipetashita piquenqueshiretashita. ");
INSERT INTO cniNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Paita piquenqueshiretantarori piitsaare, paitarica pinquitsaateari? Pamenajeitero oteapee tojari, te onquenqueshireteaji irointi: “¿Paita nonquitsaateari?” Te onquiriqueji, aisati te ontijeji, ");
INSERT INTO cniNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","iro cantaincha, oshequi oaneencaca. Pamene, peerani oshequi yoaneencaveitani yora pincatsariveitachaniri Saromoni, iro cantaincha te inquempetasanotearoji oteaquipee: oshequi oaneencasanota irointi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tempa irio Tasorentsi oaneenquirori oteaquipee tojari, iro cantaincha eiro osamanititsi ontime, impoiji tempa itaapiniyeetiro, pomei. Irompa avinti, pintimajeiteni peerani: tempa iroaneencasanotempi avinti. Pishireteari, eiro pitseenquiritsi. ");
INSERT INTO cniNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eiro picantashiretitsi, eiro picantitsi: “¿Paita ayeari? ¿Paita ireri? ¿Paita anquitsaateari?” ");
INSERT INTO cniNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Icoajeitiro ocapee yora tseencajeitantatsiri. Iro cantaincha iojeitimpi Piri jenoquiniri, iojeitiro coiteimojeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Irioquea pijivate pimpincatsateri, aisati pincanteri iroameetsashiretempi, impoijiquea impapinijeitempiro coiteimojeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ari eiro piquenqueshiretirotsi osaitequera, paitarica panteri. Irintacotempi osaitequera, aisati maaroni quitaiteriqui. Timatsi aquenqueshiretaqueri meeca quitaiteriqui, te oncameetsateji anquenqueshiretero aisati osaitequera. ");
INSERT INTO cniNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Aisati icantajeitiri Jesoshi: —Eiro picantimatiritsi pishaninca. Ariorica pincantimateri itsipapee, icantimpicari Tasorentsi: “Ainiro pantane avirori”. ");
INSERT INTO cniNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ariorica anquisaqueri itsipapee, ari inquisavaquee arori; aisati oquempetaca, ariorica ancavintsayeri itsipapee, incavintsayee arori. ");
INSERT INTO cniNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Otimirica pantayetiri avirori, te oncameetsateji pincanteri pishaninca avirori: “Ainiro pantane”. Jero oca noshiacaventempiri: ariorica pitijaquitaca quimota avinti, ¿arimpa pineaquero itijaquiro pishaninca ovane quipatsi capichaji? ");
INSERT INTO cniNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Ocameetsatimpa pincanteri: “Jentsite, naajempiro pitijaquiro”? Eiro pineirotsi. ");
INSERT INTO cniNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Oshequi picantashitaca. Pijivate pojoquero inchatora jocaaquempirira avirori, impoiji pamenaje paantajeanariri itijaquiro pishaninca. Aisati pincoaquerica pincanteri pishaninca irojocajero yantayetiri, pijivate pojocajero caari cameetsatatsi pantayetiri avirori. ");
INSERT INTO cniNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Te pimpapiniteriji otsiti cameetsatasanotatsiri ivatsa. Aisati te pimpapiniteriji chancho marereatatsiri mapi iroyearo, eiro icoitsi iroyearo. Tempa ari iraticavaquerome, irovitsintavaquerome, impoiji inquisacotaquearo iroyeari, irantsiquimentaquempiro. Aisati oquempetaca, ocameetsati irineane Tasorentsi. Ocameetsati pinquenquetsatacayeri itsipapee ashaninca, iro cantaincha ariorica inquishimentempiro, incanteata. ");
INSERT INTO cniNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Aisati icantiri Jesoshi: —Ariorica pincanteri Tasorentsi, irimatempiro paitarica pincanteriri. Pincoayetajero paitarica, impoiji pineajero. Ariorica pareetea pancotsiqui, pincantapaaqueri savicatsiri: “Pashitareenaro”, ari irashitareaquempiro. ");
INSERT INTO cniNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aitaque ipapinijeitiri Tasorentsi maaroni coacotiriri. Aisati ariorica pincoayetanaque, iramenacayempiro. Ariorica pincanteri: “Pashitareenaro”, ari irashitareaquempiro. ");
INSERT INTO cniNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ariorica incantempi pitomi: “Apa, pimpena noyeari”, ¿arimpa pimpaqueri mapi? ");
INSERT INTO cniNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ariorica incantempi: “Pimpena shima noyea”, ¿arimpa pimperi maranque iroyeari? ");
INSERT INTO cniNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pineaquero, te pincameetsatasanojeiteji, iro cantaincha piojeiti picavintsaapinitiri pitomipee. Irinti Apa savicatsiri inquitequi icameetsatasanotaque, ioti irinti catsini icavintsaajeitaqueri maaroni quenquetsatacaajeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Aisati icantajeitiri: —Ariorica pincoaque incavintsaajeitempi pishanincapee, ari pincavintsaajeiteri avirori. Pincoaquericame iroashinoncaajeitempime, ari poashinoncaajeiterime avirori. Irootaque isanquenatiniri yora Moishishini aisati maaroni camantantatsiniri. ");
INSERT INTO cniNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jero aisati ishiacantiniri Jesoshi: —Pincoaquerica pinqueapaaquero ivanco Tasorentsi, pinqueapaaquero orijani omoro. Ainiro pashini avotsi, antearo irointi, te ompomerentsiteaji anquenantearo, aisati anta ocaratapainta otimi omoro antearo. Iro cantaincha maaroni quenayetanaintsine anta irashinoncaajeitea anta Sharincaveniqui. Icarajeiti iriori oshequi. ");
INSERT INTO cniNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Iro cantaincha timatsi ora orijani avotsi, aisati orijani omoro. Oshequi opomerentsitaca irointi, itimi aparopee quenantarori. Iro cantaincha irareetea irinti Tasorentsiqui, incantaitatiyempani intime irioriqui. ");
INSERT INTO cniNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Aisati icantajeitiri Jesoshi: —Queariompia, yamatavijeitimpicari shiavetariri quenquetsatacotiriri Tasorentsi. Pishiacantiricari ovisha, pijiticari tecatsi incantempi; iro cantaincha noquempetacantaqueri nainti maniti: oshequi icovencati. ");
INSERT INTO cniNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pamenasanoteri yantayetiri, piotanteariri icameetsatirica. ¿Otimantarompa tojari ova? Teve, te ontimantearoji. ¿Otimantarompa iyera? Aisati te omateroji. Aisati iquempejeita yora amatavitantatsiri: tecatsi incantero irimatero cameetsayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Inchato cameetsari otimi oitsoqui cameetsari, ari avaquearo. Iro cantaincha terica oncameetsateji inchato, te ontimeji oitsoqui cameetsari. ");
INSERT INTO cniNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ora inchato cameetsari, tecatsi oncantero ontimero oitsoqui caari cameetsatatsi. Aisati caari cameetsatatsi inchato, tecatsi oncantero ontimero cameetsatatsiri oitsoqui. ");
INSERT INTO cniNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tempa achaquitapinitiro inchato caari oitsoquitatsi, ataapinitiro. ");
INSERT INTO cniNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aisati piojeiteri maaroni coatsiri iroamejeitempi. Piotaque ocameetsatirica yantayetiri, ari cameetsa aisati yoametantiro irineane Tasorentsi. Irompa terica oncameetsateji yantayetiri, te oncameetsateji aisati yoametanti. ");
INSERT INTO cniNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Pashini aisati icantiriri Jesoshi: —Ainiro inaveta oshequi cantashitanari: “Aviro novincatsarite, oshequi nopincatsatimpi”. Iro cantaincha eiro ijajeititsi iriori anta nompincatsaritenta. Irinti jatasanotatsineri anta inquitequi maaroni yora antasanotiniriri Apa icoacaajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ariorica nompincatsaritasanotanaque nampatojeiteri maaroni atiri noncantacoventajeitanteariri. Intime oshequi cantashitenaneri: “Novincatsarite, oshequi noquenquetsatacotaquempi. Nocantaqueri neiriri camaari: ‘Paventeari Jesoshi pavisacotantajeari’. Aisati nocantaqueri noshaninca: ‘Irio Jesoshi matacaanarori notasoncantayeti’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Iro cantaincha noncanteri narori: “Te niotempiji, te noshanincatempiji. Tsame pijate arejiqui, oshequi pantayetiro caari cameetsatatsi”. ");
INSERT INTO cniNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Pamene, ariorica pinquenqueshiretero maaroni nocantaquempiri, aisati ariorica pantenaro maaroni nocoacaaquempiri, ocameetsati. Ontime piotanteari, pinquempeteari vetsiquirori ivanco mapiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Opariaque incani, ooncanaca. Aisati otimi antearo tampea otatsincavetanacaro, iro cantaincha te aaveeroji. Iro caari aaveantaro, yovetsiquiro mapiqui, oquisotasanotaque. ");
INSERT INTO cniNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aisati oquempetaca avirori, eirorica piquenqueshiretiro maaroni nocantaquempiri, aisati eirorica pantanaro maaroni nocoacaavetimpiri, te oncameetsateji. Eiro otimitsi piotanteari. Pinquempeteari vetsiquirori ivanco anta impanequiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Opariaque incani, ooncanaca. Aisati otimi antearo tampea, otatsincanaquero. Ojaraaquero, jaran; otsoncanaquero, aanaquero, poyere. Tempa yatsipetashitacaro yora vetsicavetarori. Eiro patsipetashitarotsi avirorijei piquemajeitaquena, irointi pantasanotero nocoacaajeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Irootaque icantajeitaqueriri apatotimentajeitariri anta toncaariqui, ari yoajeitanaqueri cavaco maaroni. Icantajeiti: ");
INSERT INTO cniNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","—Oshequi ioti irinti, oshequi ipincatsariti, cameetsa yoamejeitaquee; te inquempeteariji yora oametantavetarori Sanquenarentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ari iquenquetsatacanti Jesoshi anta toncaariqui, impoiji yoirincapaaja, yoijajeitaqueri oshequi atiri. ");
INSERT INTO cniNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ari ijatashitaqueri aparoni shirampari patsaatsiri, itonquiotavacari, icantavaqueri: —Novincatsarite, pincoaquerica poavisacotajena, niotaque aitaque pimatajenaro. ");
INSERT INTO cniNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ari yacotanaque, ipamitaqueri, icantiri: —Aitaque nocoaque. Aitaque pavisacotanaje meeca. Irosati yavisacotantanaja. ");
INSERT INTO cniNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ari icantaqueri Jesoshi: —Eiroya picamantitsi, irointiquea pantero icantiniri peerani Moishishi: pijatashiteri saserote, pincamanteri irinti: “Nopatsaaveitani, iro cantaincha pamenajenate, avisacotajana: te aneajeroji meeca novatsaaro”. Ari iramenavaquempi, impoiji iroyeri pivira, intayeneri Tasorentsi, iriojeitanteari ashanincapee pavisacotaji. Ari ijatanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ari yovaanaja Jesoshi, aisati yora oijajeitiriri, impoiji yareejeitapaaca Caperenaoqui. Itonquiotavacari aparoni capitano, yora ivincatsarite oshequi soraro. Caari ini jorio yora capitano. ");
INSERT INTO cniNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Icantavaqueri: —Novincatsarite, ainiro nonampire anta novancoqui, te irimatajeaji irishevatajea, aisati oshequi icatsitaque. Catsiqueti oanaqueri. Nocoaque poavisacoteri. ");
INSERT INTO cniNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ari yacanaqueri: —Aitaque nojataque noavisacotajeri. ");
INSERT INTO cniNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Iro cantaincha icantiri: —Oshequi nopincatsataquempi: te noncameetsateji, eiro pintsipatapaanatsi anta novancoqui. Ariorica pincante iravisacotanaje, niotaque ari iravisacotanaje: patsipetarocari pijate novancoqui. Oshequi pipincatsariti. ");
INSERT INTO cniNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Timatsi peranatanari, aisati itimi soraro noperanajeitacari narori. Ariorica noncanteri soraro: “Pijate”, ari irijataque. Ariorica noncanteri itsipa: “Pimpoque”, ari impoque. Ariorica noncanteri nonampire: “Jeroca panteri”, ari irimataquero. Aisati onquempetaquea avirori, aitaque omoncarataquea paitarica pincanteri. ");
INSERT INTO cniNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ari yoanaqueri Jesoshi cavaco, icantajeitiri oijajeitiriri: —Queario oca noncamantempiri: oshequi catsini iquemisantasanotaque yoca, yanaacojeitaqueri maaroni jorio iquemisanti. ");
INSERT INTO cniNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Coajica anta ipincatsaritinta Tasorentsi intime oshequi itsipapee atiri poneayetachaneri otsipapeequi quipatsi. Incarajeiteri Avarama, Isaca, Jacovo, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Iro cantaincha eiro itimitsi oshequi jorio anta. Icoacaavetacari Tasorentsi intsipajeitearime anta ipincatsaritinta, iro cantaincha oshequi itseencajeitaqueri, irootaque intiancajeitanteariri anta otsitenitasanotinta. Oshequi anta iroashinoncaajeitea, oshequi inquematsicatearo. ");
INSERT INTO cniNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ari icantiri yora capitano: —Meeca pijataje pivancoqui. Piquemisanti, irootaque iravisacotantajeari pinampire. Irosati yavisacotantanaja inampire. ");
INSERT INTO cniNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ari ijatanaque Jesoshi ivancoqui Petero. Ineapaaquero irairo, ojoquiitaca, aaquero catsiirentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ipamitapairo acoqui, irosati avisacotantaja. Otinaanaja, irosati opantavacariri iroapeempari. ");
INSERT INTO cniNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ari ishaavijiitanaque catsirincaiteri, irosati yamantajeitapaacari oshequi neiriri camaari. Ari iquenquetsatacaavaqueri, irosati yavisacojeitantajari. Aisati yoavisacojeitaqueri oshequi joquiijeitachari. ");
INSERT INTO cniNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aitaque itsataaquero Jesoshi maaroni iquenquetsatacotiniri peerani Isayashini: “Coajica iroavisacojeiteri Quirishito oshequi mantsiayetatsiri, oshequi incavintsaajeiteri”. ");
INSERT INTO cniNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ari ineajeitavaqueri Jesoshi oshequi catsini apatotimentajeitacariri, irosati icantantariri iroamerepee: —Tsame ajajeite intatiquero incajare. ");
INSERT INTO cniNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ari icantiri oametantirori Sanquenarentsi: —Oametanari, jaocarica pijateri, nocoaque noijatanaquempi. ");
INSERT INTO cniNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yacanaqueri: —Yorari parari ainiro imoro imaantari, aisati yora tsimeripee ainiro yaatantari imaantari. Noponeaca narori anta inquitequi, natiritapaaque, iro cantaincha te aneroji novanco nainti nomaanteari. Patsipetashitacari poijatanaquena, pashinoncaacari. ");
INSERT INTO cniNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Icantiri pashini iroamere: —Novincatsarite, nocoavetaca noijatempime, iro cantaincha incamaquetsita apa: impoijiquea quiso noanaquempi. ");
INSERT INTO cniNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Iro cantaincha icantaqueri: —Poijatenata, impoiji ariorica incame piri, ainiro tijerineri itseencaririnte: yora caari iotiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ari itetanaca Jesoshi pitotsiqui, icarajeitaqueri iroamerepee. ");
INSERT INTO cniNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ari imaanaque Jesoshi. Nianquijaqui omapocashijeitacari iroamerepee antearo tampea, otejatapaaca omotoncane. ");
INSERT INTO cniNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ari ijatashitaqueri, yoisaaquireaqueri, icantaqueri: —Novincatsarite, jentsinocanti ampiinquenive: poavisacojeitena, aisati poavisacotajea avirori. ");
INSERT INTO cniNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ari itinaanaca, yacanaqueri: —¿Paita pitsaroantacari? ¿Paita caari piquenqueshiretasanotantana? Impoiji ipeajiro tampea, aisati ipeajiro omotoncane. Opeasanotanaja tampea, opeasanotaja omotoncane. ");
INSERT INTO cniNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ari yoajeitanaqueri cavaco, icantavacaanaca: —¿Jaoca icantari yoca? Pineaquero ipeajiro tampea, aisati ipeajiro omotoncane, maa. ");
INSERT INTO cniNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ari yareejeitanaca intatiquero, yaatacotapaaque. Opajita nampitsi Carara. Ari iponeaca tijaariqui apite neiriri camaari, itonquiotavacari Jesoshi. Yora camaari, oshequi iquisacaacari neiriri, irootaque itsaroacaajeitantacariri ishaninca, te inquenantajearo tijaariqui. ");
INSERT INTO cniNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Icantavaqueri camaari: —¿Aviro? Niotaquempi, aviro Itomi Tasorentsi. ¿Paita pipocashitantanari? ¿Irompa pipocashitantanari meeca poashinoncayena? Tequera omoncarateaji nonquematsicatantearori anta ishaaviji. ");
INSERT INTO cniNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ari itimi anta oshequi chancho, yoajeitanta. ");
INSERT INTO cniNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Icantiri camaari: —Ariorica poavisacoteri neanarica, pintianquena anta chanchoqui, nonijapeempari iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ari icantiri: —Pijate, pinijapeempari iriori. Ari ijatanaque, ineavaqueri iriori chancho, irosati ishiajeitantanaca imperitaqui, ipiincajeitanaque incajarequi, tsapo, tsapo, tsapo, tsapo. Itsitiajeitanaque, pomiririri, poyere. ");
INSERT INTO cniNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ari ineavaqueri shentajeivetariri, ishiajeitanaca. Ijatanaque nampitsiqui, icamantapaaqueri ishaninca maaroni oca ineaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ari ijatashijeitaqueri maaroni savicajeitatsiri, icantapaaqueri Jesoshi: —Tsame pijataje: eiro pipocajitsi aca nonampiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ari itetanaja aisati Jesoshi pitotsiqui, icarajeitiri iroamerepee. Ipiajeitanaja inampisanoriqui. ");
INSERT INTO cniNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ari yameetaqueneri caari shevatacha, yamacotaqueri shitashintsiqui. Iotaque Jesoshi oshequi iquemisantaque, irootaque icantantavacariri: —Piveshireanaquea, noshaninca, meeca noavisacotempi; eiro noquishimentimpirotsi caari cameetsatatsi pantayetiri. ");
INSERT INTO cniNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ari iquemajeitaqueri oametantirori Sanquenarentsi, icantavacaajeitanaca: —Ijitasorentsitacateemi Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ari iotaque iriori iquenqueshirejeitiri, icantajeitiri: —¿Paita piquisashirejeitantanari? ¿Paita pitseencajeitantanari? ");
INSERT INTO cniNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ariorica noncantaqueri yoca: “Meeca noavisacotempi, paniitanaje”, tempa ari pamenajeitavaqueri, sorerere. Eirorica nomatirotsi, ari pishirontimentena. Iro cantaincha pijitashijeitaca nocantashitari: “Noavisacotempi, eiro noquishimentimpirotsi caari cameetsatatsi pantayetaqueri”. ");
INSERT INTO cniNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nocoaque piojeite te noncantashiteaji. Noponeaca narori inquitequi, natiritapaaque. Icantaquena Apa: “Poavisacotenari antirori caari cameetsatatsi, impoiji eiro aquishimentajiritsi aisati yantayetiri”. Nocoaque piojeite ainiro notasorenca. Ari icantiri caari shevatacha: —Pincatianaje, paanajero pishitashi, pijataje pivancoqui. ");
INSERT INTO cniNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ari icatianaja, cati; ijatanaji ivancoqui. ");
INSERT INTO cniNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ineajeitavaqueri maaroni apatojeitainchari, yamenajeitavaqueri sorerere. Itsaroajeitanaque, aisati icantajeiti: —Tempa icameetsati Tasorentsi, imatacaaqueri yoca yoavisacotajiri mantsiaripee. ");
INSERT INTO cniNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ari yovaanaja Jesoshi anta nosaviquinta narori. Ineapaaquena naitayetiri noshaninca iirequite nompanteariri oromasati. Icantapaaquena: —Tsame, poijatanaquena avirori. Ari nocatianaca, noijatanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Impoiji naanaqueri anta novancoqui, noacaapaacari. Ari nocajemiri Jesoshi, itsipa iroamerepee, yora notsipajeitari napatojeitiniri oromasati iirequite, itsipapee caari quemisantatsi, maaroni. Ari noajeitaca. ");
INSERT INTO cniNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ari ipocashitaquena yora variseopee, icajemiri itsipapee iroamere Jesoshi, isampijeitiri: —¿Paita yantiri yora oamejeitimpiri? Jeri yoacaajeitacari apatotiniriri oromasati quirequi, aisati icarajeitiri caari cameetsajeitatsi. Te oncameetsateji. ");
INSERT INTO cniNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ari iquemaque iroamere, impoiji ijatashitaqueri Jesoshi, icamantapaaqueri; impoiji icantanaque iriori: —Yora caari mantsiatatsi te incoyeji iravintea, irintiquea mantsiayetatsiri coatsiri iravintea. ");
INSERT INTO cniNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tsame pijajeite pinquenqueshirejeitero icantiri Tasorentsi: “Te noncoyeji poapinitenari pivira, pintaapinitenari; irointiquea nocoasanotaque pincavintsaajeiteri pishaninca”. Te iro nompocantea nonquemisantacaajeiteri cameetsayetatsiri, irintiquea caari cameetsajeitatsi. Irootaque icantiriri Jesoshi variseopee. ");
INSERT INTO cniNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Impoiji ipocaarantaque iroamerepee Joa, isampitapaaqueri Jesoshi: —Pamene, notitapinita noquenqueshiretantariri Tasorentsi, aisati iquempetaca yora variseopee; irintiquea poamerepee avirori, te intitimateaji. ¿Paitaquea? ");
INSERT INTO cniNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ari yacanaqueri: —Piojeitaque yamejeitari yora iroaquera aatsi ijina: icajemajeitaqueri ishaninca, yoacaajeitacari, iveshireimentajeitacari iriori. ¿Paita iroashiretacanteariri icajemacantiri? Iro cantaincha, ariorica irijatanaque arejiqui, impoijiquea iroashirejeitanaquea, intijeitanaquea. Aisati narori, coajica nojataje, impoijiquea iroashirejeitanaquea, intijeitanaquea noamerepee. ");
INSERT INTO cniNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aisati, otimirica piitsaare iroaquerari, te pintsereeroji pimpataquero peesatotaintsiri pimaatsara. Ariorica poavitajero, eiro omoncaratavacaatsi. Aisati ariorica pinquivajero oshirincamaotanaque iroaquerari, antsivianaquea peesatotaintsiri, ontsereanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tempa apeantantaro iroaquerajari pearentsi imeshinaqui iroaquerari, impoiji antsitacotaquero eiro aparajatanta. Ariorica oshimoretanaque, aravoncanaque, ontapiaqueri imeshina. Iroaquerarica ini, eiro ipesacotitsi, aisati eiro aparajatatsi: tempa iroaquera ini. Irooricame ampeantantajearome pearentsi iroaquerajari peesatitatsiri imeshina, tempa ari iraravoncanaqueme, intoncanaqueme, ton. Aitaque intsereanaqueme, aisati amparajatanaqueame iroaquerajari, chararara. Iroaquera oni oca noamejeitimpiri, te oncameetsateji onconoyearo peeraniniri poamejeitiriri avirori. Irootaque icantaqueriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Irosati ipocashitantacari pincatsaritatsiri, itiyeroashitapaacari Jesoshi, ipincatsatapaaqueri; icantapaaqueri: —Camaque nishintio, iro cantaincha nocoaque pijate novancoqui pimpamitapeero aneantajeari. ");
INSERT INTO cniNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ari yoijatanaqueri Jesoshi, nocarajeitanaqueri narori, maaroni iroamerepee. ");
INSERT INTO cniNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ari anta nianqui avotsi oneavaquena tsinane, ocarataque 12 osarintsi ashinoncaaca: ocantani irajataquenive. Oquenqueshiretaca: “Ariorica nantitaqueri iitsaare Jesoshi, ari navisacotanaje”. Ari oquenapaaque itapiiqui, antitaqueri ovarashiqui iitsaare. ");
INSERT INTO cniNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ari ipitsocanaca, ineaquero, icantaquero: —Piveshireanaquea, noshaninca, piquemisantaque, irootaque pavisacotantajari. Ari avisacotaji. ");
INSERT INTO cniNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ari novaajeitanaja, nareejeitapaaca ivancoqui pincatsari, noneapaaqueri shiovitacoventirori camaintsiri, aisati oshequi ashaninca, icajemajeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ari icantajeitiri Jesoshi: —Pijajeitanaque. Te oncameji oca piraacojeitiri, irointi omai. Ari ishirontimentajeitacari, iji, iji, iji. ");
INSERT INTO cniNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ari isoquijajeitanaque, irosati iqueantapaaca Jesoshi. Yajiricavacotapaaquero, irosati otinaantanaja. ");
INSERT INTO cniNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Irosati iquenquetsatacojeitantacari maaroni savicajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ari novaajeitanaja aisati, itimi anta apite caari amenatsi. Yoijatanaqueri Jesoshi, icantajeitiri: —Tempa aviro ishanincani Iravirini. Pincavintsaajena. ");
INSERT INTO cniNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ari noqueajeitapaaque pancotsiqui, aisati iriori yora caari amenatsi. Ipocashijeitaqueri Jesoshi, impoiji icantavaqueri: —¿Paamaacampa ari nomatero namenacaajeitajempi? Icantiri: —Je, novincatsarite; nioti ari pimatajena. ");
INSERT INTO cniNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Irosati ipamijaquitantacari, icantaqueri: —Pishiretaquena, irootaque noavisacotantempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Irosati yamenajeitantanaja, iro cantaincha icantasanotaqueri: —Eiroyea picamantiritsi itsipapee: “Yamenacaajana Jesoshi”. ");
INSERT INTO cniNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Iro cantaincha ijajeitanaque, icamantajeitaqueri maaroni ineajeitaqueri: —Yamenacaajana Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ari impoiji, jeri ipocapaaque neiriri camaari, te irimateroji irineanate. ");
INSERT INTO cniNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ari itianquiri Jesoshi yora masontitacaaveitariniri, ineanatacaajiri. Ari yoajeitanaqueri cavaco maaroni amenajeitaqueriri, icantajeiti: —Peerani, te aneapiniteriji quempetearine yoca. ");
INSERT INTO cniNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Iro cantaincha icantanirojeiti yora variseo: —Yamitacotiri ivincatsarite camaari, irootaque imatantacariri iamaaririnte itianquiri. ");
INSERT INTO cniNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ari oshequi iquenaquenayetanaque Jesoshi maaroni nampitsipeequi, yoametapinijeitiri noshaninca anta yapatotapinijeitanta. Iquenquetsatacotapinitiri Tasorentsi, jaoca icanta ipincatsariventanti. Yoavisacojeitiri maaroni: tecatsi ompomerentsitimoteari, imataquero maaroni mantsiarentsipee. ");
INSERT INTO cniNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ari ineaqueri oshequi catsini atiri yapatotimentajeitacari, oshequi icavintsaajeitaqueri. Icanti: —Oshequi yashinoncaajeitaca, tecatsi intacotearine. Iquempejeivetacari ovisha yora caari ishenteeti. ");
INSERT INTO cniNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Impoiji icantajeitana: —Oquempetaca otimi oshequi oitsoqui panquirentsi, iro cantaincha te intimeji oshequi aviiteroneri. ");
INSERT INTO cniNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pincantajeiteri Pivincatsarite intiancajeitanteariri oshequi quenquetsatacaajeiterineri ashaninca, quemisantacaajeiterineri. ");
INSERT INTO cniNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ari icajemajeitaquena Jesoshi, maaroni itsipapee iroamerepee, nocarajeiti 12. Imatacaajeitaquena noavisacojeitaqueri neiriri camaari, nojocacoventajeitaqueri iamaarite. Aisati imatacaaquena noavisacojeitaqueri maaroni mantsiayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ari itiancajeitaquena nomayetero imatacaajeitaquenari. Ari nocarajeitiri Shimo, irosati ivajiro aisati Petero; jeri Antirishi, irirenti Petero; Santiaco, yora itomi Severeo; Joa, yora irirenti Santiaco; ");
INSERT INTO cniNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Jeripi; Varitorome; Tomashi; aisati narori: narotaque apatoveitanariniri oromasati iirequite; Santiaco itomi Arejeo; Tareo; ");
INSERT INTO cniNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Shimo, icantiri aisati Sheraroro; jeri aisati yora Jorashi Ishicariote, yora aacaanterineri coajicani Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ari itiancajeitaquena Jesoshi, icantavaquena: —Eiro pijatashitiritsi yora itsipapee atiri, aisati eiro pijatitsi anta itiminta samariasati. ");
INSERT INTO cniNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Irintiquea pijatashijeite maaroni ajorioririnte. Noshiacantajeitaqueri ovisha yora caari ishenteeti. ");
INSERT INTO cniNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jaocarica pinquenayetanaqueri, pinquenquetsatacaajeiteri atiripee. Pincamantajeiteri: “Irotaintsi impincatsariventajeitee Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Poavisacojeiteri mantsiaripee, pointinaajeitajeri camayetatsiri, poavisacojeiteri patsaayetatsiri aisati neayetiriri camaari. Oshequi nocavintsaajeitaquempi, iro cantaincha tecatsi noncoacojeitempi. Meeca pincavintsaajeiteri itsipapee, iro cantaincha tecatsi pincoacojeiteri avirori. ");
INSERT INTO cniNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Eiro paanaqueritsi piirequite, ");
INSERT INTO cniNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","pitsarate, otsipa piitsaare, pisapatote, piotiquiro, tecatsi catsini. Tempa ocameetsati incavintsaajeitempi maaroni yora pincavintsaajeiteri avirori: ocameetsati impashijeitempi maaroni coiteimojeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ariorica pareetea nampitsiqui, pincoapeeri quemisantasanotatsiri; pisaviquimoteri iriori irosati povaantanajeari otsipapeequi nampitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ariorica pareetapaaquea, pineacameetsajeitapeeri savicajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ariorica irineacameetsajeitavaquempi iriori, pincanteri Tasorentsi incavintsaasanoteri. Iro cantaincha terica irineacameetsatempi, eiro picantiritsi incavintsayeri. ");
INSERT INTO cniNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eirorica ineacameetsatavaquempi, aisati eirorica iquemisantavaquempi, ari povaanajea. Pincantanaqueri: “Te pinquemisantavaquena, ari coajica iroasanquejeitempi Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Queariotaque oca noncantempiri: coajica, ariorica incantacoventajeiteri Tasorentsi maaroni atiri, iroasanquetaajeiteri maaroni soromasatini aisati maaroni comorasatini. Iro cantaincha iroasanquetaasanojeiteri catsini maaroni caari neacameetsajeitempine, oshequi irashinoncaajeitanaquea. ");
INSERT INTO cniNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Meeca nontiancajeitempi, iro cantaincha oquempetaca notianquiri ovisha anta itiminta covencari: oshequi iroashinoncaajeitempi tseencantatsiri. Pinquenqueshirejeitanaquea, eiro catsini poashinoncairitsi pishaninca. Irootaque icantajeitavaquenari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aisati icantajeitaquena Jesoshi: —Queariompia, yoashinoncaimpicari ashaninca. Iraajeitanaquempi anta yoametavacaajeitanta pincatsaripee iroasanquetaacantantempiri. Aisati iraajeitanaquempi ashanincapee anta yapatojeitantari, impasanatapinitempi. ");
INSERT INTO cniNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Iriojeitempirica piquemisantajeitaquena, iraanajempi anta itiminta ivincatsaritepee itsipapee ashaninca, impoiji pinquenquetsatacaajeiteri iriojeitantenari itsipapee ashaninca. ");
INSERT INTO cniNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ariorica iraajeitanaquempi, eiro piquenqueshireatsi, eiro picantitsi: “¿Paitampa noncanteriri?” Narotsitaquea nainti oamejeitempineri paitarica pincanteriri. ");
INSERT INTO cniNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eiro piotashitatsi avirori pinquenquetsatacayeri, irointi Ishire Tasorentsi oametasanotempineri pinquenquetsatacayeri. ");
INSERT INTO cniNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Coajica oshequi inquisavacaimentajeitaquena atiripee. Aparo iroacanteri irirenti, pashini iroacanteri itomi, aisati itsipapee iroacantayeteri ashiyetariri. ");
INSERT INTO cniNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Piquemisantajeitaquena, irootaque inquisajeitantempiri pishanincapee, iro cantaincha eiro poipacairotsi piquemisanti. Ariorica pincanteani pinquemisantena, noavisacojeitempi, cameetsa pisaviquimojeitena anta inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ariorica inquisajeitempi savicajeitatsiri aparoni nampitsiqui, ari pishianaque, povaanajea otsipaqui nampitsi. Queario oca noncamantempiri: eirotsitarica pitsoteiro maaroni nampitsi isavicantari ajorioririntepee, aisati nompiapaaje narori. Tempa noponeaca narori inquitequi, natiritapaaque. ");
INSERT INTO cniNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Ariorica irimoncaraveteari iroamere oametiriri iriote, iro cantaincha eiro yanaacotiritsi. Aisati ariorica irimoncaraveteari nampirentsi yora nampitariri ipincatsariti, iro cantaincha eiro yanaacotiritsi. Ari meeca oshequi iquisajeitaquena ashaninca, ijitashijeitaquena naro ivincatsarite camaari. Piquemisantajeitaquena, tempa irootaque inquisajeitantempiri avirori, ");
INSERT INTO cniNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","iro cantaincha, eiro pitsaroacaajeitaritsi. Meeca te iriojeiteji maaroni nopincatsaritaque, iro cantaincha coajica iriotasanojeitanaque maaroni; irineajeitaquena nompincatsaritasanotanaque, aisati pincarajeitena avirori. ");
INSERT INTO cniNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Meeca apaniro nocamantajeitaquempi, te iriojeiteji yora tseencantatsiri, iro cantaincha coajica niotacaajeiteri. Meeca nomanavetacaro, iro cantaincha coajica noncamantasanojeiteri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Irimajeivetearo iriori iroajeitaquempi, iro cantaincha eiro pitsaroacaaritsi: tecatsi incantempi intianquempi Sharincaveniqui. Irinti pimpincatsatasanoteri Tasorentsi: incoaquerica iriori irimatajero iroajempi aisati intianquempi Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pamene, te impinateaji tsimeripee, iro cantaincha terica incoacayeri Apa incame, eiro icamitsi aparoni, catsini. ");
INSERT INTO cniNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Iotiro jaoca ocaratiri piishi, iotasanotimpi catsini. ");
INSERT INTO cniNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pineaquero, oshequi panaacojeitiri tsimeripee, oshequi iquenqueshiretaquempi. Meeca eiro pitsaroitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ariorica pincanteri ashaninca: “Nopincatsataqueri Jesoshi”, aitaque anta inquitequi noncanteri Apa: “Ipincatsataquena iriori, noshanincatacari”. ");
INSERT INTO cniNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Iro cantaincha pincanteririca ashaninca: “Te nompincatsateriji Jesoshi”, ari anta inquitequi noncanteri Apa: “Te impincatsatenaji yora, te nioteriji narori”. ");
INSERT INTO cniNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Aisati icantana Jesoshi: —Eiro pijitashitanatsi nopoqui iraacameetsatavacaajeitanteari maaroni savicajeitatsiri. Te iro nompocantea iraacameetsatavacaajeitanteari, irointi inquisavacaajeitanteari. ");
INSERT INTO cniNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Irointi nopocanta inquisanteariri shirampari iriri, onquisantearori tsinane iniro, onquisantearori tsinane airo, ");
INSERT INTO cniNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","inquisanteariri shirampari ishanincasanori. ");
INSERT INTO cniNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Tempa ocameetsati pinintajeiteri piri aisati piniro, iro cantaincha ocameetsatasanoti pinintasanojeitena narori. Eirorica pinintasanotanatsi narori, eiro noneacameetsatimpitsi avirori. Aisati, ocameetsati pinintajeiteri pitomi aisati pishinto, iro cantaincha ocameetsatasanoti pinintasanotena narori. Eirorica pinintasanotanatsi narori, eiro noneacameetsatimpitsi avirori. ");
INSERT INTO cniNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nocoaque pinquearioventenaro maaroni nocoacaaquempiri. Ariorica inquishimenteetempiro, iro cantaincha nocoaque pimpomerentsiventenaro. Eirorica pipomerentsiventanarotsi, eiro noneacameetsatimpitsi narori. ");
INSERT INTO cniNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ariorica pincavintsaasanotajea avisati meeca, pashinoncaasanotanaquea coajica. Iro cantaincha pinquemisantasanotenarica meeca, ariorica iroashinoncaajeivetempi pishaninca, iro cantaincha eiro patsipetarotsi: coajica paneajeitanaje anta ocameetsaitetasanotinta catsini. ");
INSERT INTO cniNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Maaroni aacameetsajeitempineri, yaacameetsajeitaquena narori. Aisati maaroni aacameetsajeitanari, yaacameetsajeitaqueri Apa iriori: yora tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ariorica irioyeetempi aviro quenquetsatacotiriri Tasorentsi, irootaque iraacameetsatantempiri, ari pimoncaratavacaajeitea impinajeitempi Tasorentsi: avirori, aisati yora aacameetsajeitempineri. Aisati oquempetaca, irioyeetempirica picameetsati avirori, irootaque iraacameetsatantempiri, ari pimoncaratavacaajeitea impinajeitempi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ariorica irioyeetempi piquemisantana, irootaque impacotantempirori pireri, iriotero Tasorentsi, impinatasanoteri yora cavintsaimpiri. Irootaque icantajeitanari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ari ivecarataquero yoamejeitaquena Jesoshi, yovaanaja anta otsipapeequi nampitsipee, yoamejeitaqueri savicajeitatsiri, iquenquetsatacaajeitaqueri. Noijatanajiri narori, aisati nocarajeitaqueri itsipapee iroamerepee, nocarajeiti 12. ");
INSERT INTO cniNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Chapinqui yoiminqueetaqueri Joa, yora vaotisatantatsiri. Meeca ari inaqueri caravosoqui, iro cantaincha iquemacotaqueri yantayetaqueri Quirishito, irosati itiancantacariri iroamerepee iriori: ");
INSERT INTO cniNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—Pijatashijeiteri Jesoshi, pisampitaiteri: “¿Avirompa Quirishito naamaajeitari? Terica aviro, ari naamayea pashini”. ");
INSERT INTO cniNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ari yareejeitapaacari Jesoshi, isampitapairi. Ari yacavaqueri: —Pimpiajeitanaje, pincamantapeeri Joa maaroni piquemaquenari aisati maaroni pineacotaquenari. ");
INSERT INTO cniNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Namenacaajeitajiri caari amenajeivetacha, naniitacaajeitajiri caari shevajeivetacha, noavisacojeitaqueri maaroni patsaajeivetachari, noquemacaajeitajiri caari quemaveitachani, noitinaajiri aisati camavetainchari, niotacaajeitaqueri ashinoncaajeivetachari jaoca incanteari iravisacotantajeari. ");
INSERT INTO cniNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Inquimoshirejeitanaque maaroni caari tseencana. Irootaque pincamantapaaqueriri Joa. ");
INSERT INTO cniNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ari ipiajeitanaja iroamerepee Joa, impoiji iquenquetsatacaajeitaqueri Jesoshi yora apatotimentajeitacariri: —Ari peerani pijatapinijeiti anta caaraiteriqui, piquemisantapinijeitiri Joa. ¿Paita pijatashijeitantariri? Tempa piojeitiri iotiri iriori Tasorentsi, irootaque pijatashitantariri. ");
INSERT INTO cniNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Pineaquerimpa iquitsaata cameetsa? Teve. Yora quitsaatarori iitsaare cameetsari isavicajeiti anta ivancoqui pincatsari. ");
INSERT INTO cniNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tempa piojeitaqueri iriotaque quenquetsatirori irineane Tasorentsi. Queariotaque, iro cantaincha yanaacotasanotiri itsipapee quenquetsatacotiriri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iquenquetsatacotaquerini peerani Tasorentsi, icantitanani: “Notiomi, nontianqueri coajica jivatempineri, inquenquetsatacaapaaqueri ishaninca, incanteri: ‘Pinquenqueshirejeitea, paamaajeiteari Avincatsarite’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Meeca noncamantempi, queariotaque: tempa itimi oshequi catsini atiri, iro cantaincha yanaacojeitaqueri Joa, yora vaotisatantatsiri. Yanaacotasanojeitaqueri itsipapee, iotasanotaqueri Tasorentsi. Iro cantaincha maaroni neajeitaquerineri Tasorentsi impincatsaritapaaje, iranaacotasanoteri Joa, iriotasanojeitanaque irinti. ");
INSERT INTO cniNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Peerani iquenquetsatacaitaquempini Joa, meeca noquenquetsatacaajeitaquempi narori, piojeitantacariri Tasorentsi. Ari impincatsariventajeiteri maaroni coasanojeitatsiri iriojeiteri. ");
INSERT INTO cniNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Peerani maaroni yora camantantatsiniri iquenquetsatacotiri Quirishito, aisati iquempetani Moishishini. Aisati icantajeiti: “Irotaintsirica impoque Quirishito, irijivatapaaqueri Iriashi”. Impoiniji meeca ipocaque iriori Joa, ");
INSERT INTO cniNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ariorica noncantempi: iriotaque Joa iquenquetsatacotiri, ¿arimpa pijitaque namatavitaquempi? ");
INSERT INTO cniNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Otimirica piyempita piquemantari, pinquemaquena. Irootaque icantajeitiriri maaroni apatotimentajeitariri. ");
INSERT INTO cniNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jero oca aisati icantajeitaqueriri Jesoshi: —Piquempejeitacari jananequipee, savicajeitatsiri saiteriqui, cantiriri itsipapee: ");
INSERT INTO cniNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Notamporovetaca, iro cantaincha te poijatanaquenaji; nosoncavetaca, iro cantaincha aisati te poijatanaquenaji. Nomaninquevetaca, te poijatanaquenaji”. ");
INSERT INTO cniNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pineaquero, picoajeiveta irantajeiterome pishaninca paitarica picoacaajeivetacariri. Pineavetari Joa, itivetaca aisati te irireroji cachojari, ari picantashijeitari: “Oo, ineaqueri Joa camaari, ititantacari”. ");
INSERT INTO cniNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ari noponeaca narori inquitequi, natiritapaaque; te nontiveteaji nainti, aisati niriro cachojari nainti. Ari picantimajeitaquena: “Jeri yonta oashenti, shinquinarinti. Ishanincatacari aitaqueeriri airequite aisati itsipapee caari cameetsayetatsi”. Iro cantaincha ioti Tasorentsi, ocameetsataque maaroni icoacaaquenari; aisati maaroni quemisantanari, iojeitaque ocameetsataque icoacaaquenari Apa. Irootaque icantajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Impoiji iquenquetsatacojeitaqueri Jesoshi yora neajeivetacariri itasoncanti, iro cantaincha itseencajeitaqueri. Icanti: ");
INSERT INTO cniNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Irashinoncaajeitanaquea maaroni coraseisati, aisati vetsairasati. Oshequi ineajeivetaquena notasoncantayeti, iro cantaincha te inquenqueshireteaji, te inquemisanteji. Irineaquename notasoncantayeti yora tirosatini peerani, aisati yora shirosatini, inquenqueshirejeitanaqueame irinti, irojocajeitaquerome caari cameetsatatsi yantajeitiniri, inquemisantajeiteme. ");
INSERT INTO cniNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Coajica, ariorica incantacoventajeiteri Apa, iroashinoncaajeiteri yora tirosatini aisati yora shirosatini: oshequi te incameetsajeiteni. Iro cantaincha iroashinoncaasanojeitaqueri catsini yora coraseisati aisati vetsairasati: tempa ineacojeivetaquena notasoncantayeti, iro cantaincha te inquemisantenaji. ");
INSERT INTO cniNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aisati iriori caperenaosati, ijitashijeiveta irijate inquitequi, iro cantaincha itseencantajeiti: irootaque irijajeitanteari iriori ishaaviji. Irineaquerome yora soromasatini maaroni ineajeitaqueri caperenaosati, inquenqueshirejeitanaqueame, eiro itsoncajeitirime peerani Tasorentsi, ontimeme meeca inampi. ");
INSERT INTO cniNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Coajica iroashinoncaajeitajeri aisati Tasorentsi soromasatini, iro cantaincha iroashinocaasanojeiteri catsini yora caperenaosati. Irootaque icantaqueriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Impoiji iquenquetsatacairi Jesoshi Tasorentsi, icantiri: —Apa, aviro pincatsariventajeitiriri maaroni inquitesati aisati maaroni quipatsisati, oshequi nopasonquitimpi. Ainiro cantashitachari: “Niotasanoti nainti”, iro cantaincha pimanapitsajeitaqueri piotiri. Irintiquea piotacaajeitiri itsipapee, yora itseenqueetiri. ");
INSERT INTO cniNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pineshinoncajeitaqueri irinti, picoacaajeitaqueri iriote. ");
INSERT INTO cniNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Irootaque icantaqueriri iriri, impoiji icantajeitaqueri ashaninca: —Irio Apa iotacaanari maaroni. Apaniro iotasanotaque irinti naro itomi, te iriotacotenaji itsipapee. Apaniro niotiri narori, tempa narotaque itomi; yorari itsipapee, te iriotasanojeiteriji Apa. Irintiquea iotasanojeitaqueri yora noamejeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ariorica pashinoncayea, ariorica ompomerentsitimotempi paitapeerica, pimpocashitena pincamantena; ari noncavintsayempi, nintacotempi eiro opomerentsitimotantajimpitsi aisati. ");
INSERT INTO cniNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pinquemisantena narori, pincoajeite noamejeitempi; oshequi nocavintsanti, oshequi noneshinoncatanti. Ariorica pinquemisantena, noveshireacaajeitempi. ");
INSERT INTO cniNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pamene, eiro noperanatimpitsi, eiro noashinoncaimpitsi, irointi namitacotapinijeitempi. ");
INSERT INTO cniNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ari pashini saavaro noijajeitanaqueri Jesoshi, ijivajeitanaquena anta oantsipeequi. Narotaque iroamerepee. Ari aajeitaquena notashe, irootaque naviitantanacarori oitsoqui tirico, noajeitacaro. ");
INSERT INTO cniNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ari ineajeitaquena variseopee, irosati icantantacari Jesoshi: —Pamenerite poamerepee. Meeca saavaro, te oncameetsateji meeca iraviitantearo. ");
INSERT INTO cniNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ari yacanaqueri: —Tempa pineanatapinivetaro Sanquenarentsi quenquetsatacotiriri Iravirini. Aajeivetacarini peerani itashe, aisati aajeivetacarini maaroni oijajeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ari iqueapaaque ivancoqui Tasorentsi, icantapaaqueri yora saserote: “Aajeitaquena notashe”. Ari otimaveta anta tanta yoashiyeetanariri Tasorentsi. Te oshinetanteaji iroajeitearo ashanincapee, apaniro irinti yoaro saserote. Iro cantaincha icavintsaajeitavaqueri, te incoyeji iroashinoncayeri, irootaque ipajeitantacariri Iravirini, aisati itsipajeitari. Yoajeitaca. Meeca te pincanteji: “Te oncameetsateji yantiniri Iravirini”, ari ¿paita picantantari meeca: “Te oncameetsateji yantiri yoca”? ");
INSERT INTO cniNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Aisati isanquenatini Moishishi: “Eiro pantaveetantarotsi saavaro”. Iro cantaincha maaroni saavaro ijatapiniti saserote ivancoqui Tasorentsi, yantaveetapiniti. Te pinquishimenterini, tempa pineacameetsataquero yantayetiri. ");
INSERT INTO cniNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tempa atiri yanaacojeitaquero ivanco Tasorentsi, ocameetsati ancavintsaajeiteri irinti, eiro avashinoncairitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pineaquero, isanquenatini peerani: “Icanti Tasorentsi: ‘Te noncoyeji poapinitenari ovisha, pintaapinitenari; irointiquea nocoasanotaque pincavintsaajeiteri pishaninca’ ”. Pinquemasanoterome oca icantiri Tasorentsi, eiro picantimentirime yoca aviitirori tirico, te aneeroji irantane. ");
INSERT INTO cniNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Noponeaca narori inquitequi, natiritapaaque. Narotaque nainti cantatsine paitarica antayeteri saavaroqui. ");
INSERT INTO cniNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ari novaajeitanaja, noqueajeitapaaquero pancotsi yapatojeitantari. ");
INSERT INTO cniNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Itimi anta tsiricoipacori. Ari yora variseopee isampijeitavaqueri Jesoshi: —¿Ocameetsatimpa poavisacoteri saavaroqui tsiricoipacori? Icoajeitaque iroavisacoteri saavaroqui, irootaque incantajeitanteari: “Yantaveeniroti Jesoshi saavaroqui, te incameetsateji”. ");
INSERT INTO cniNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ari yacanaqueri: —Pamene, ariorica saavaroqui impariaque omoroqui povishate, tempa paajeri, poisoquijajeri. Ocameetsati picavintsairi. ");
INSERT INTO cniNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tempa atiri yanaacotiri ovisha icameetsatasanotaque. Ocameetsataque ancavintsayeri saavaroqui. ");
INSERT INTO cniNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Impoiji icantiri yora tsiricoipacori: —Pancotaje. Ari yacotanaji, cameetsatanaji iraco, omoncarajaro otsipa iraco. ");
INSERT INTO cniNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Iro cantaincha iquisajeitanaca variseopee. Ijajeitanaji, yoametavacaajeitanaca, icantajeiti: —¿Jaoca ancanteriri Jesoshi, avacantanteariri? ");
INSERT INTO cniNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iotaque Jesoshi icoajeitaque iroyeri, irootaque yovaantanajari. Ari noijajeitanaqueri, nocarajeitiri oshequi itsipapee atiri. Itimi oshequi mantsiayetatsiri, iro cantaincha yoavisacojeitaqueri maaroni, ");
INSERT INTO cniNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","impoiji icantajeitaqueri: —Eiroyea picamantitsi: “Yoavisacojeitaquena Jesoshi”. ");
INSERT INTO cniNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ari itsoteajiro Jesoshi maaroni iquenquetsatacotaqueriniri peerani Isayashi. Jero oca irineane Apa Tasorentsi isanquenatiniri: ");
INSERT INTO cniNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Jeri yoca Quirishito nocoacaaqueri irantenaro maaroni nocoacaaqueriri. Oshequi nonintaqueri, oshequi noneacameetsataqueri. Nontianqueneri noshire, quiso oanaqueri, amitacotapiniteri. Incamantajeiteri itsipapee atiri jaoca noncanteari noameetsatanteariri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eiro icantavacaimentarotsi paitapeerica, eiro iquenquejairitsi itsipapee. Eiro icajemacotapinitiritsi itsipapee. ");
INSERT INTO cniNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Eiro yoashinoncairitsi oashiretachari. Eiro yamatavitiritsi coatsiri iriotena. Aitaque, incanteani incavintsante, aisati impincatsariventantasanote. ");
INSERT INTO cniNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iriotaque oavisacojeiterineri itsipapee atiri, te intimeji pashini oavisacojeiterine”. Irootaque icantiri Tasorentsi peerani. ");
INSERT INTO cniNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Impoiji yameetaqueneri Jesoshi neiriri camaari: te irameneji, aisati te irineanateji. Ari yoavisacotajiri: yamenacaajiri aisati ineanatacaajiri. ");
INSERT INTO cniNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ari yoajeitanaqueri cavaco maaroni neacojeitaqueriri. Isampitavacaajeitaca: —¿Iriompa yoca Quirishito aamaajeitacari? ");
INSERT INTO cniNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Iro cantaincha icantajeiti variseopee: —Irio Satanashi, yora ivincatsarite camaari, amitacotiriri itiancajiri iyamaaririnte. ");
INSERT INTO cniNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ari iotaque Jesoshi iquenqueshirejeitiri, icantajeitiri: —Ariorica irimanatavacaajeiteame savicajeitatsiri quipatsiqui, tempa ari impoyereavacaajeiteame. Aisati iquempetaca yora savicajeitatsiri nampitsiqui, ariorica inquisavacaajeiteame, tempa ari inteentareavacaajeiteame. Aisati iquempejeita maaroni atiri, ariorica inquisaqueri ishanincasanori, eiro quiso yoajiritsi. ");
INSERT INTO cniNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pamene: irioricame Satanashi amitacotenaneme notianquiri noyamaaririnte, tempa nompoyereavacaajeiteame. ");
INSERT INTO cniNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aisati irioricame amitacotenaneme notianquiri camaari, ¿irisatimpa camaari amitacojeitiriri pishanincapee iriori yojocantariri camaari? ");
INSERT INTO cniNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Iro cantaincha irootaque Ishire Tasorentsi amitacotanari notiancantajariri camaari. Tempa irootaque piotanteameri ainiro icarajeitaquempi Tasorentsi, icoaveta impincatsariventajeitempime. ");
INSERT INTO cniNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Intimerica coatsiri incoshiteri shintsitatsiri, tempa irijivateri irayeri, shepi; iroisoteri, oiso, oiso. Impoiji incoshiteri ivaararo, eiro imatirotsi impiateari yora ashivetarori ivaararo. ");
INSERT INTO cniNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yora caari quemisantana, iriotaque quisaquenari. Aisati, iquisaquena maaroni caari amitacotana. ");
INSERT INTO cniNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aisati icantiri Jesoshi variseopee: —Yora Tasorentsi icavintsaajeitiri maaroni caari cameetsajeitatsi aisati maaroni cantimajeivetariri, eiro iquishimentajeitiritsi yantayetiri. Iro cantaincha eiro icavintsaajeitiritsi yora cantimajeitirori Ishire. ");
INSERT INTO cniNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Noncamantempi: noponeaca nainti inquitequi, natiritapaaque, iro cantaincha incavintsaajeiteri Apa maaroni cantimajeivetanari. Eiro icavintsaajeitiritsi irinti cantimatirori Ishire. Eiro icavintsairitsi meeca, aisati coajica eiro icavintsairitsi, irointi iroasanquetaasanojeiteri. ");
INSERT INTO cniNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ariorica ocameetsati inchato, ocameetsati oitsoqui iroori; terica oncameetsateji inchato, aisati iroori oitsoqui, te ocameetsateji. Ariorica pineero oitsoqui, tempa piotaque ocameetsatirica inchato. ");
INSERT INTO cniNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pishiajeitaqueri camaari, te pincameetsajeiteji: tecatsi pincantea poametante cameetsa. Te oncameetsateji piquenqueshirejeitiri, irootaque caari ocameetsatanta picantajeitiri. ");
INSERT INTO cniNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Irinti cameetsatatsiri shirampari iquenqueshiretapinitiro cameetsayetatsiri, irootaque ocameetsatantari yantayetiri. Yora caari cameetsayetatsi iquenqueshiretapinitiro caari cameetsatatsi, irootaque caari ocameetsatanta yantayetiri. ");
INSERT INTO cniNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Coajica incantacoventajeitaquempi Tasorentsi: inquenqueshiretacaajempiro maaroni picantajeitiri meeca. ");
INSERT INTO cniNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ocameetsajeitirica picantajeitiri, ari irineacameetsatempi, iro cantaincha terica oncameetsayeteji, incantempi: “Ainiro pantayetiri, oshequi pinquematsicatimentearo”. Irootaque icantiriri Jesoshi variseopee. ");
INSERT INTO cniNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Impoiji icantajeivetari variseopee aisati oametantayetirori Sanquenarentsi: —Oametanari, nocoaque namenempi pintasonquero paitapeerica, niotantempiri avirotaquerica Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yacanaqueri Jesoshi: —Te pincameetsajeiteji, oshequi pitseencaqueri Tasorentsi, irootaque picantantanari. Eiro notasonquimojeitimpitsi piotantenarime. Otimi yantayetiniri Jonashi: pishiretearome ishiacantaquenari, ari pinquemisantaquename. ");
INSERT INTO cniNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Peerani iniaquerini anteari omani, ocarataque mava quitaiteri inaqueri isheitoqui. Aisati narori, noncamaque, oncarataque mava quitaiteri nonaque narori omoroqui tsompoina. ");
INSERT INTO cniNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Coajica incantacoventajeitempi Tasorentsi, incantajeitempi: “Ainiro pantanejei avirorijei. Peerani yora ninivesati iquemisantajeitaquerini yora Jonashi, iquenqueshirejeitantacari. Avintijei, pineajeivetacari Quirishito, oshequi yanaacotasanotiri Jonashi, ipincatsaritasanoti irinti, iro cantaincha te pinquemisantajeiteriji”. ");
INSERT INTO cniNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aisati incantajeitempi: “Ainiro pantayetiri avirorijei. Peerani ora ivincatsaroteni savasatini oquemaque oshequi iotaque Saromo, irootaque ojatantacari arejiqui oquemisantantacariri. Jeri isaviquimojeivetimpi avinti anaacotiriri Saromo, iro cantaincha te pimpincatsateriji”. ");
INSERT INTO cniNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Noshiacantempiro aisati: oquempevetaca yora camaari itimantacari ishirequi shirampari, ipeaquero ishire ivanco. Ari yojoqueetiri camaari, yavisacovetaja yora itimantari. Ijataque camaari anta caaraiteriqui, anta opirijaiteaque. Icoaveta irimaoreeme, iro cantaincha te irimateroji. ");
INSERT INTO cniNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Impoiji icantaniroti: “Nompianajeta novancoqui noponeacanta”. Ari ipianaja, ineapaaquero opishitaca, ocareniiteanaque, ovetsicayetaca isavicamentopee, imaamento, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ari ijatashitanaqueri pashini iamaaririnte, icarati 7. Oshequi yanaacojeitiri icamaaritasanojeiti. Icantiri: “Tsame pisavicajeite novancoqui”. Ari, peerani yashinoncaavetaca capichaji yora itimantari camaari; meeca irampiitajea irashinoncaasanotanajea catsini. Aisati pinquempejeitea avirorijei. Pashinoncaajeivetaca, te piojeiteniji. Meeca pineajeivetaquena, iro cantaincha te pimpincatsajeitenaji, irootaque pampiitajea, pashinoncaasanojeitajea. Irootaque icantajeitaqueriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ari iquenquetsatacaajeitaquena Jesoshi, aisati yora apatojeitachari anta pancotsiqui. Irosati opocantapaacari iriniro Jesoshi, jeri irirentipee, ocatiapaaca saiteriqui, ocajemacantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Icamanteetaqueri: —Areetapaaca piniro, jeri pirentipee, ocoapaaquempi. Ocoaque onquenquetsatacayempi. ");
INSERT INTO cniNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yacanaqueri: —¿Janicampa ina? ¿Janicampa iyepee? ");
INSERT INTO cniNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ari ijicojeitaquena, icantiri: —Jeri yoca noamerepee, iriojeitaque iyepee, aisati iroojeitaque ina. ");
INSERT INTO cniNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iriotaque noshanincatasanojeitacari maaroni antiniriri Apa Jenoquiniri icoacaajeitaqueriri: nocantajeitaqueri iye, tsio, jero ina. ");
INSERT INTO cniNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Irosati isoquijantanaja Jesoshi, ijatanaque otsapijaqui incajare. Noijajeitanaqueri, ");
INSERT INTO cniNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","aisati yapatotimentajeitacari oshequi atiri. Ineaquero pitotsi, otsatacotaca; ari itetapaacaro, isavicapaaque. Ari nocatiajeitaca narori otsapijaqui. ");
INSERT INTO cniNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Impoiji, oshequi iquenquetsatacaajeitaquena, ishiacantiri panquiveetatsiri, icanti: —Ijati panquiveetatsiri yojocaitiro oitsoqui tirico iroanequi. ");
INSERT INTO cniNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Opariaarantapaaque aparopee oitsoqui avotsiqui, impoiji ipocapaaque contsaro, yoitapaacari oitsoqui. ");
INSERT INTO cniNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Otsipapee oitsoqui opariaarantapaaque mapiqui. Te anta ontimasanoteji quipatsi, ari jentsipaite oshiocavetanaca, aisati jentsipaite otsoancavetapaaca. ");
INSERT INTO cniNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Iro cantaincha te ontimasanoteji ovaritsa. Ijenoquitapaaque catsirincaiteri, oshimpetanaque, impoiji ocamanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pashini pariapaintsi quitotsequishiqui: anaanaquero irointi, oshiocaque, ajaanaquero panquirentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Orari pashinipee oitsoqui opariapaaque quipatsisanoriqui cameetsari. Oquimotanaque, oitsoquitanaque. Aparopee timanaintsi oitsoqui ocarataque 100, iro otsipapee ocarataque oitsoqui 60, iro otsipapee ocarataque oitsoqui 30. ");
INSERT INTO cniNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Otimirica piyempita piquemantari, pinquemavaquero oca nocantajeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Impoiji notsipajeitanacari pashinipee iroamere, nocantajeitaqueri Jesoshi: —¿Paita pishiacantantanariri yora itsipapee? Te inquemajeiteroji picantaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ari yacanaquena: —Nocoacaajeitaquempi piojeitanaquero caari iojeiti itsipapee. Nocoaque piojeite jaoca icanta Tasorentsi ipincatsariventajeitimpi, iro cantaincha te noncoacayeriji yora itsipapee iriojeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Itimirica iovetachari, ari niotacaasanoteri. Iro cantaincha itsipapee, te incoyeji iriote, irootaque caari iotanta irinti; eiro noametiritsi irinti, aisati nompeapitsataqueri iotantavetari. ");
INSERT INTO cniNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Irootaque noshiacantantanariri irioripee, te incoyeji iriojeite. Yamenajeiveta, iro cantaincha tecatsi irinee. Iquemajeivetavacaro iro cantaincha te inquemavaqueroji, te iriotavaqueroji nocantavetacariri. ");
INSERT INTO cniNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aitaque iquenquetsatacotitarini peerani Isayashi, icantini: “Pinquemajeivetea, iro cantaincha eiro piojeitavaquerotsi. Pamenajeivetea, iro cantaincha eiro pineasanojeitirotsi. ");
INSERT INTO cniNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Te pincoajeiteji piojeitanaque, irootaque caari piquenqueshireajeitanta. Te pincoyeji pinquemajeite, irootaque povitantacarori piyempita. Te pincoajeiteji pamenasanojeite, irootaque pimatsiocantacari. Te pincoyeji catsini noavisacojeitempi”. Irootaque iquenquetsatacotiriniri peerani Isayashini. ");
INSERT INTO cniNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Iro cantaincha pamenajeitanaji avinti, piquemisantajeitajana, irootaque pinquimoshiretasanojeitanteari. ");
INSERT INTO cniNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Queario oca noncamantempiri: icoajeiveitani peerani yora quenquetsatacantantatsiniri aisati cameetsajeitatsiniri irineerome oca pineajeitaqueri avirori. Icoajeiveitani inquemerome oca piquemajeitaqueri meeca. Iro cantaincha te irineajeitenaji, te inquemajeitenaji. Irootaque icantaquenari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ari icantajeitaquena Jesoshi: —Meeca noamejeitempiro oca noshiacantajeitaqueneriri incaranqui. ");
INSERT INTO cniNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ari nocamantapinitiri itsipapee jaoca icanta Tasorentsi ipincatsariventanti, iro cantaincha terica inquemero, iquempetacaro oitsoqui pariaintsiri avotsiqui. Ipoqui camaari, yojocacaaqueri iquenqueshirevetacaro noneane. ");
INSERT INTO cniNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Aisati itsipapee iquemavetavacaro nocantavetacariri, iveshireimentavetacaro, irootaque iquisantacariri ishaninca. Iro cantaincha te iriotasanoteji, te inquemisantasanoteji, irootaque yojocantajarori iquemisantaveta. Ari ishiaquero iriori oitsoqui pariapaintsiri mapiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Iojeiveta itsipapee noamejeivetari, iquemavetaro noneane, iro cantaincha oshequi iquenqueshireyetiro paitapeerica, aisati oshequi iveshireimentaro irovaararo, irootaque caari iquenqueshiretantaro noneane. Te inquemisanteji. Ishiaquero iriori oitsoqui pariapaintsiri quitotseequishiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Iro cantaincha ainiro itsipapee quemisantasanotirori noneane, quemasanotirori. Oshequi iquemisantaquena, iquearioventaquero maaroni nocoacaaqueriri. Ishiaquero oitsoqui pariapaintsiri quipatsiqui cameetsari, ora shequianaintsiri oitsoqui: aparopee timayetanaintsiri oitsoqui 100, iro otsipapee otimaque oitsoqui 60, iro otsipapee aisati otimaque oitsoqui 30. Irootaque icantaquenari. ");
INSERT INTO cniNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Pashini aisati ishiacantaquenari Jesoshi, icantaquena: —Aitaque icanta ipincatsariventanti Tasorentsi, iquempetacari yora panquitirori oitsoqui tirico. Ocameetsataque oitsoqui ipanquitiri. ");
INSERT INTO cniNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Impoiji tsiteniriqui imai, aisati imaajeiti iratiritepee. Ipocaque tsiteniriqui quisaqueriri, yamaquero oitsoqui tiriconiro. Oshiavetaro tirico, iro cantaincha oquepiati. Ipanquitiro anta ivanquirequi ashitarori iroane, iconoaitiniri tirico. Impoiji ijatanaji. ");
INSERT INTO cniNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ari impoiji aisati oshiocanaque tirico, oitsoquitanaque. Aisati oshiocanaque tiriconiro, oconoanacaro. ");
INSERT INTO cniNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ineaquero iratiritepee, ijatashitaqueri, icantaqueri: “Tempa ocameetsati oitsoquipee apanquijeitiri anta poanequi. ¿Paita oshiocantacari tiriconiro?” ");
INSERT INTO cniNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yacanaqueri: “Irioyeata quisaquenari panquitaitirori”. Ari isampijeitiri: “¿Picoaquempa nojajeite nontsocayetajero tiriconiro?” ");
INSERT INTO cniNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Icantiri: “Aitanaque. Pitsocacotirocari tiricosanori. ");
INSERT INTO cniNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ocantavacata. Oshiocacoterota meeca. Coajicaquea amenavaquero oitsoquitanaquetsita tirico. Impoijiquea, noncantajeitempi: ‘Pimpesajeitero tiriconiro, paajeitero, pintayero. Impoijiquea paviitero tiricosanori, poajero anta pancotsiqui noquempoyeantaroriqui’ ”. Irootaque ishiacantajeitaquenari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jero oca pashini ishiacantajeitanari Jesoshi, icanti: —Aitaque icanta ipincatsariventanti Tasorentsi, ishiacantiro oitsoqui moshitasa ipanquiyeetiri oantsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Orijaniqui onaveta oitsoquijaniqui, iro cantaincha oshiocanaquerica, antearotanaque, anayetanaquero otsipapee panquiyetachari, aitaque irimencotantaquearo tsimeripee ojempequiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jero pashini ishiacantaquenari: —Aitaque icanta ipincatsariventanti Tasorentsi, iquempevetaro tsinane ovetsiquiro tanta. Aaquero ovane tirico oshequi, aisati oconoiro tapiacaarori capichaji. Oconoasanotiro, impoiji otapiaquero maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aitaque icanta Jesoshi, ishiacaaventapinijeitiniri apatotimentajeitariri, iotaca ishiacantiniri. ");
INSERT INTO cniNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Imoncarataquero isanquenatiniri peerani yora quenquetsatacantatsiniri: “Icanti Tasorentsi: ‘Oshequi noshiacanteneri atiripee; noncamanteri caari iojeitini peerani’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Impoiji ijatanaque Jesoshi, yojocajeitanajiri yora apatotimentajeitariri, ijatanaque pancotsiqui. Narotaque iroamerepee, noijajeitanaqueri. Nocantaqueri: —Poametasanotenaro oca pishiacantajeitiniriri yora apatotimentajeitimpiri. ¿Paita oshiacantiri tiriconiro ipanquiyeetiri tiricomashiqui? ");
INSERT INTO cniNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ari yacanaquena: —Noponeaca narori inquitequi, natiritapaaque. Naro shiaqueriri panquitirori tirico cameetsari. ");
INSERT INTO cniNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ora oantsi oshiacantaquero quipatsi asavicajeitantari. Ora oitsoqui cameetsari oshiacantaqueri pincatsatiriri Tasorentsi. Irointi tiriconiro oshiacantaqueri pincatsatiriri camaari. ");
INSERT INTO cniNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yora quisantatsiri, panquitirori tiriconiro, ishiacantaqueri camaari. Ora yaviitaqueri oitsoqui oshiacantaquero ontsoncanteari quipatsi. Yora iratiritepee ishiacantaqueri inampirepee Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pineaquero, yapatotacantaquero tiriconiro, itaasanotaquero, pomein. Oca oshiacantaquero nanteri coajica nontsoncantajearori quipatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nontiancajeiteri oshequi nonampirepee, nampatotacantajeiteri maaroni caari cameetsajeitatsi; te nonintacayeriji incarajeiteri maaroni pincatsajeitanari. ");
INSERT INTO cniNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nojocacantajeiteri anta paamariqui: oshequi irashinoncaajeitaquea anta, oshequi inquematsicatearo. ");
INSERT INTO cniNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Impoiji irishipaquireajeitanaque maaroni cameetsajeitatsiri, inquempejeiteari catsirincaiteri. Incarajeiteri Apa anta ipincatsaritinta. Otimirica iyempita atiripee, ocameetsati inquemisantajeitena. ");
INSERT INTO cniNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Aisati icantaquena Jesoshi: —Aitaque icanta Tasorentsi ipincatsariventanti, ishiaqueri oshequi quirequi imaneetiri quipatsiqui. Ari ineashitacari quirequi pashini shirampari. Imanaqueri iriori, te incamanteji. Iquenqueshiretaca: “Namananterota quipatsi, nashitanteariri timatsiri quipatsiqui”. Impoiji ijataque ipimantajeitaquero maaroni yashijeitari iraanteariri quirequi. Irootaque yamanantantacarori quipatsi itimantari oshequi quirequi. Impoiji iquimoshireventaqueri oshequi quirequi, yoca yamanantacotaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Aisati iquempetacari coatsiri iramanantero marereatatsiri mapi, cameetsatasanotatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ineaquero aparoni, ocameetsatasanotaque, opinatasanotaca. Icoasanotaquero, irootaque ipimantantarori maaroni timimojeitiriri yaantariri quirequi. Impoiji itsoncaqueri iirequite yamanantantarori aparoni mapi cameetsari. ");
INSERT INTO cniNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Aisati icantajeitaquena Jesoshi: —Pashini aisati noshiacantempiro jaoca icantari Tasorentsi ipincatsariventanti. Oquempetaca iquitsati shirampari incajarequi. Yojocaquero iitsarite nijaqui, impoiji inoshicacotaqueri shimayetatsiri; icaantanacave, monquire, monquire. Inashiyetaca. ");
INSERT INTO cniNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ijaacaro quitsariqui, inoshicacotaqueri otsapijaqui. Impoiji isavicaque, icoyeayetaqueri cameetsayetatsiri. Irintiquea yora caari cameetsayetatsi yojocaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aisati onquempetajea ariorica nompocaje. Nontianqueri nonampirepee irinashitacaajeiteari cameetsajeitatsiri aisati caari cameetsajeitatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Irojocajeiteri caari cameetsajeitatsi anta paamariqui. Oshequi irashinoncaajeitanaquea, inquematsicatasanojeitearo paamari. ");
INSERT INTO cniNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","¿Piquemajeitaquerompa oca nocamantajeitaquempiri? Nacajeitanaqueri: —Je, noquemajeitaque. ");
INSERT INTO cniNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ari icantaquena: —Ariorica inquemisantena yora oametantirori Sanquenarentsi, iriojeitanaquero oshequi: tempa meeca iotiro maaroni isanquenayeetiniri peerani: aisati, inquemisantenarica, iriotero iroaqueratatsiri noamejeitiriri meeca. Iriotanaquero jaoca icantari Tasorentsi ipincatsariventanti. ");
INSERT INTO cniNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ari ivecarataquero Jesoshi ishiacantajeitaquenaro, impoiji ijatanaque, ");
INSERT INTO cniNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ipianaja anta iipatsitequi iponeacanta. Noijajeitanaqueri narori. Ari yoametantapaaque anta yapatojeitanta ashanincapee. Yoajeitanaqueri cavaco maaroni quemajeitavaqueriri, icantajeiti: —¿Janica oametiriri yoca otimantacari iotantari? ¿Paitaquea matacaaqueriri itasoncantayeti? ");
INSERT INTO cniNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tempa iriotaque itomi vetsiquirori inchato. Tempa irootaque iriniro Maria. Tempa iriotaque irirentipee yora Santiaco, Jose, Shimo, jeri Jorashi. ");
INSERT INTO cniNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tempa aisati acarajeitaquero iritsiropee. ¿Paita ipincatsanirotantacari? ");
INSERT INTO cniNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ari iquisajeitaqueri, itseencajeitaqueri, irootaque icantantariri: —Timatsi pincatsatiriri quenquetsatirori irineane Tasorentsi, iro cantaincha itseencajeitiri ishanincasanori. ");
INSERT INTO cniNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ari oshequi itseencajeitaqueri ishanincasanori, irootaque caari itasoncantayetanta oshequi anta inampisanoriqui. ");
INSERT INTO cniNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Irosati yora Eroreshi iquemacotaqueri Jesoshi. Yora Eroreshi ipincatsariventajeitiri maaroni carireasati. ");
INSERT INTO cniNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Icantajeitiri ishanincapee: —Irioyeata Joa Jesoshitajantsiri. Noacantavetacari, iro cantaincha aamaashiteari tinaanajaitatsi ini, irootaque imatantarori itasoncantayeti. ");
INSERT INTO cniNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ari chapinqui yora Eroreshi yaapitsataqueri irirenti Jeripe ijina, opajita Eroriashi. Yora Joa icantavetacari: “Te oncameetsateji paapitsateri pirenti ijina”. Irosati yaacantantacari, yoiminqueacantaqueri. Yoisoyeetaqueri carenatsaqui. ");
INSERT INTO cniNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ari icoavetaca iroacantitearime, iro cantaincha oshequi ipincatsajeitaqueri atiri Joa, iojeitiri iquenquetsatacotiri Tasorentsi. Ijivetaca Eroreshi: “Ariorica noacanteri, inquisacojeitanaqueari atiripee”. ");
INSERT INTO cniNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Impoiji omoncarataca quitaiteri itimantacari peerani Eroreshi. Yapatojeitaqueri oshequi ishaninca, iquimoshireimentajeitacari. Aisati omaninquetacotimentaqueri oshinto Eroriashi. Oshequi ineacameetsataquero, ");
INSERT INTO cniNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","irootaque icantantarori: —Paitarica pincoacotaquenari, aitaque nompaquempiro. Ioti Tasorentsi eiro namatavitimpitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ocantiro iniro: —Pincanteri iroacanteri Joa. Irosati ocantantariri: —Nocoaque poacanteri Joa, impoiji pimpacotenaro matitaqui iitoni, iotanteari ina queario icamasanotaque. ");
INSERT INTO cniNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ari yoashiretanaca Eroreshi. Te incoaveteaji, iro cantaincha iquemajeitaqueri maaroni ishaninca icantaquerori irishintotsori. ");
INSERT INTO cniNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Irootaque ipesacantantacariri Joa. ");
INSERT INTO cniNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Impoiji yameetaquenero matitaqui iito Joani. Aavaquero, aanaquenero iniro. ");
INSERT INTO cniNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Irinti iroamereni yaajeitanaqueri, itijaitiri. Impoiji ijajeitanaque, icamantapaaqueri Jesoshi: —Yoyeetaqueriyea Joa. ");
INSERT INTO cniNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iquemantacari Jesoshi icamaque Joa, ijatanaque apaniro anta tenta intimeji atiri. Itentajeitanaquena, iro noquenajeitantanacari pitotsi. Iro cantaincha iquemacojeitaqueri atiripee, iponeayetanaca nampitsipeequi, ishiteajeitanaca, yoijajeitanaquena. ");
INSERT INTO cniNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ari naatacojeitapaaque, noneajeitapaaqueri oshequi apatojeitainchari. Oshequi icavintsaajeitapaaqueri, yoavisacojeitaqueri mantsiaripee. ");
INSERT INTO cniNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ari ishaavijitanaque catsirincaiteri. Nocarajeitaqueri pashini iroamere, nocantajeivetacari: —Pamene, caraiteitaque aca, aisati ishaavijiteanaque catsirincaiteri. Pintiancajeiteri yocapee irijajeite nampitsipeequi iramanantajeite iroyeari. ");
INSERT INTO cniNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yacanaquena: —¿Paita irantsipetashitanteari irijate? Jentsite, pimpajeiteri avirori iroajeiteari. ");
INSERT INTO cniNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nocantajeitaqueri: —Te ontimeji nompajeiteriri. Jero oca ocarataque tanta apapacoroni. Jerica aisati apite shima. ");
INSERT INTO cniNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Icantaquena: —Pamaquenaro. Ari nopaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Impoiji icantajeitaqueri: —Pisavicajeite saveshishiqui. Ari isavicajeitanaque. Impoiji yaavaquero tanta aisati shima. Ari yamenanaque jenoqui, icantiri iriri: —Irove, Apa, pipaquenaro oca noyearica. Impoiji icarajaquero, ipaquenaro. Novaajeitaqueneri yora apatojeitainchari. ");
INSERT INTO cniNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yoajeitacaro maaroni, iquemajeitanaca. Impoiji napatojeitajiro timaarantapaajantsiri, nojaayetajiro cantiriqui, ocarataque 12. ");
INSERT INTO cniNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Naamaaca ari icarajeiti yora oajeitacarori 5,000 shirampari, aisati tsinanepee, jeri aisati jananequipee. ");
INSERT INTO cniNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Impoiji icantajeitaquena: —Noamerepee, pintejeitanajea pitotsiqui, pijivajeitanajena intatiquero. Impoiji aisati icantajeitaqueri apatojeitainchari: —Pijajeitanaje pivancopeequi. ");
INSERT INTO cniNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Impoiji ijatanaque apaniro toncaariqui, iquenquetsatacairi iriri. Ari otsitenitanaque, itimi apaniro iriori anta. ");
INSERT INTO cniNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Narojeiquea nainti, noquenacojeitanaque nianquijaqui. Antearo omotoncane, aisati oipiacotajana tampea. ");
INSERT INTO cniNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Irotajantsi onquitaitetaje noneajeitavaqueri, yaniijatapaaquero incajare, te intsitiaquiteji. Te niojeitavajeriji, ");
INSERT INTO cniNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","irootaque notsaroacaajeitantacariri, nocajemajeitanaque: —Jeee. Coraqueve camaarira. Oshequi notsaroacaajeitacari. ");
INSERT INTO cniNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iro cantaincha icantajeitapaajana: —Narotaque pocajantsi, piveshireimentajeitavajena, eiro pitsaroacaajeitanatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ari icantiri Petero: —Avirorica novincatsarite, pincajemena naniijatashitanajempi nijaqui. ");
INSERT INTO cniNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ari icantiri: —Caatequeti. Irosati imitajantanaca, yaniijatanaque anta Jesoshiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Iro cantaincha impoiji iquenqueshiretaquero tampea, aisati itsaroanaque. Ineavaitia itsitianaque, icajemanaque: —Novincatsarite, paavajena. ");
INSERT INTO cniNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Irosati yacotashitantavajari, yaavajiri. Icantiri: —Capichaji pishiretaquena, ¿paita pitseencantanari? ");
INSERT INTO cniNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ari itetanajaro pitotsi, irosati opeantanaja tampea. ");
INSERT INTO cniNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Oshequi nopincatsajeitaqueri, nocantajeitaqueri: —Queariotaqueteemi, aviro Itomi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ari nomonteajeitanaja, nareejeitapaaja Jenesaretequi. ");
INSERT INTO cniNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yora savicajeitatsiri iojeitavaqueri Jesoshi, itiancajeitaqueri ishaninca, yamacantajeitaqueri mantsiayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ari yantitapaaqueri iitsaare ocaratapai. Yavisacojeitanaji maaroni antitajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Impoiji ipocashijeitiri Jesoshi variseopee aisati oametantirori Sanquenarentsi. Iponeajeitaca iriorijei Jerosarequi. Isampitapaaqueri: ");
INSERT INTO cniNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Tempa arojeitaque jorio. Amejeivetacaro tequeratsitarica avajeitea, ajivati aquivacotasanota. Irootaque yoamejeitaqueeri yora peeraniniri. ¿Paita caari iquempejeitanta poamerepee? Yoashinirotaca, te inquivacoteaji. ");
INSERT INTO cniNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yacanaqueri: —Oshequi pimoncaratashiyetacaro icantashiyetacaniri peeraniniri, irootaque caari pimatantaro yoamejeivetimpiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tempa icanti irinti: “Pimpincatsateri piri aisati piniro”. Aisati icanti: “Incameta yora cantimatiriri iriri aisati iriniro”. ");
INSERT INTO cniNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Iro cantaincha aviroripee, picantajeitiri pishaninca: “Pincanteri ashitimpiri ‘Nompempime quirequi, noncavintsayempime, iro cantaincha nojivataque nocantaqueri Tasorentsi nomperiri iriori’ ”. Poamenirojeitiri eiro icavintsairitsi ashitariri, eiro ipincatsatiritsi. ");
INSERT INTO cniNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pineaquero, poametashinirojeitacari icantashiyetacari pishaninca, te poamejeiteriji irineane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pishiacantavetaca piquemisantiri Tasorentsi, iro cantaincha te pinquemisanteriji. Queario oca iquenquetsatacotimpiri peerani Isayashini: ");
INSERT INTO cniNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Icanti Tasorentsi: ‘Icantashijeitaca ipincatsataquena, iro cantaincha te irishirejeitenaji. ");
INSERT INTO cniNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yatsipetashitacaro yapatotimentashitana, te iroametanteroji noneane, irointi yoametantiro irineane iriori’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Impoiji icajemajeitiri yora apatotimentajeitariri, icantajeitiri: —Pinquemajeitena, piojeitavaquero oca noncamantempiri: ");
INSERT INTO cniNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ora ayeari, tecatsi oncantero ashire ompeacayearo. Irointiquea oca aneaveetashiyetari, irootaque matirori ashire ompeacayearo. ");
INSERT INTO cniNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Impoiji nojatashitiri Jesoshi, nocarajeitiri itsipapee iroamerepee, nocantajeitiri: —¿Tempa piote iquishimentajeitimpiro variseopee oca picantiriri? ");
INSERT INTO cniNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yacanaquena: —Coajica intsocajero Apa jenoquiniri maaroni caari ipanquiti iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ari inaji yora variseopee: te irioteji, iquempejeitacari caari amenatsi. Oquempetaca icoaque irijate jaocarica, icoaque irancatsatanajeri itsipapee caari amenajeitatsi iriori. Aitaque impariajeitaque omoroqui maaroni, terocn. ");
INSERT INTO cniNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Icantiri Petero: —Te nonquemempiji, poametenaro oca pishiacantiri. ");
INSERT INTO cniNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Icantiri: —¿Tequerampa ontime piotantari? ");
INSERT INTO cniNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tempa piote paitarica ayeari ojataque asheitoqui, impoiji ashitajero? Tecatsi oncantero ashire. ");
INSERT INTO cniNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Iro cantaincha pineanatantaro paitarica piquenqueshiretiri: terica oncameetsateji, eiro picameetsashiretitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tempa piojeitiro piquenqueshiretiro caari cameetsatatsi, poanti, paimentaro pijina, pantiro caari pai, picoshiti, pitseeya, picantimatiri pishaninca. ");
INSERT INTO cniNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Irootaque caari picameetsajeitanta. Iro cantaincha terica pinquivacoteaji, tecatsi oncantero pishire. ");
INSERT INTO cniNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Irosati ijatantanacari Jesoshi Tiroqui aisati Shiroqui. Itentajeitanaquena maaroni iroamerepee. ");
INSERT INTO cniNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ojatashitaqueri cananasato, caari oni jorio. Ocantiri: —Novincatsarite, tempa aviro ishanincani pincatsari Iravirini. Nocoaque pincavintsayena, aisati noshinto. Yataanaquero iroori camaari, catsiqueti yoanaquero. ");
INSERT INTO cniNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Iro cantaincha imajeretanaque, te iranqueroji. Nocantajeivetari narori: —Pincantajero ojatajeta, oshequi ashereajeitaquee. ");
INSERT INTO cniNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Icantiro: —Itiancaquena Apa noncavintsayeri joriopee. ");
INSERT INTO cniNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Iro cantaincha opocashitiri, otiyeroashitacari, aiquero ocantatiiri: —Novincatsarite, pincavintsayena. ");
INSERT INTO cniNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Icantiro: —Te oncameetsateji aapitsateri atomi yoari ampanteariri otsiti. Te aviro jorio, ¿paita noncavintsaantempiri? ");
INSERT INTO cniNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Acanaqueri: —Queario, novincatsarite, oca picantiri. Iro cantaincha, tempa yoaro otsiti iroaritsopequi yora ashitariri. ");
INSERT INTO cniNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yacanaquero: —Tsinane, cameetsa pishiretaquena. Aitaque nomataquempiro oca picoacotaquenarica. Irosati avisacotantanaja oshinto. ");
INSERT INTO cniNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ari yovaanaja aisati Jesoshi, iquenanaque otsapijaqui incajare anta Carireaqui. Impoiji itoncaanaque toncaariqui, isavicapaaque. Noijajeitanaqueri narori, aisati iriori maaroni iroamerepee. ");
INSERT INTO cniNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ijatashijeitaqueri oshequi atiripee, yaajeitanaqueneri oshequi mantsiayetatsiri: choritatsiri, caari shevatacha, caari amenatsi, caari neanatatsi, maaroni. Ari yoavisacojeitiri. ");
INSERT INTO cniNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ari yoajeitanaqueri cavaco maaroni neajeitaqueriri. Ineajeitajiri ineanataji caari neanaveitachani, ishevajeitanaja caari shevaveitachani, yaniiyetanaji caari aniiveitachani, yamenanaji caari amenaveitachani. Icantajeiti: —Tempa icameetsataque Tasorentsi, yora pincatsariventajeitiriri maaroni joriopee. ");
INSERT INTO cniNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Impoiji icajemajeitaquena Jesoshi, aisati iriori maaroni iroamerepee. Icantajeitaquena: —Oshequi nocavintsaajeitaqueri maaroni yora apatotimentajeitanari. Ocarataque meeca mava quitaiteri icarajeitaquee: tecatsi meeca iroajeiteari. Oshequi aajeitaqueri itashe meeca. Ariorica nontiancavetajeari meeca, aitaque ajaajeitanaqueri itashe, eiro yaaveajatsi irareejeitajea ivancoqui. ");
INSERT INTO cniNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nocantajeitaqueri: —Pamene, caaraiteitaque aca. ¿Jaoca ayerori tanta avacaajeiteariri? Oshequi icarajeiti catsini. ");
INSERT INTO cniNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Isampitaquena: —¿Jaoca ocaratiri tanta timatsiri? Nacanaqueri: —Ocarataque 7, aisati timatsi shivajaniqui aparopee. ");
INSERT INTO cniNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ari icantajeitiri apatojeitainchari: —Pisavicajeite quipatsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Irosati yaantacaro tanta aisati shivajaniqui. Icantiri iriri: —Ariove apa, pipaquena noyeari. Impoiji icarajaquero, ipajeitaquenaro. Naajeitavaquero, impoiji novaajeitaqueneri iriori apatojeitainchari. ");
INSERT INTO cniNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yoajeitanaca, iquemajeitanaca. Impoiji napatojeitajiro timaarantapaajantsiri, nojaajiro cantiriqui ocarataji 7. ");
INSERT INTO cniNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Icarajeiti oajeitainchari 4,000 shirampari. Aisati oajeitainchari oshequi tsinane aisati jananequipee. ");
INSERT INTO cniNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Impoiji itiancajeitajiri Jesoshi: —Meeca pijajeitanaje pivancopeequi. Irosati notejeitantanaja pitotsiqui, nomonteanaja anta Macataraqui. ");
INSERT INTO cniNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Impoiji ipocashitaqueri variseopee aisati saroseopee: icoajeivetaca irantacayerime Jesoshi caari cameetsatatsi ontimanteameri inquisantearimeri. Icantavetapaacari: —Jentsite, namenempi pintasoncante, niotanteari piponeacarica inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yacanaqueri Jesoshi: —Pamene, ariorica ishaavijiiteanaji, pineaquerorica opotsonaiteanaji, tempa picantajeiti: “Eiro oparii incani”. ");
INSERT INTO cniNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Iro cantaincha, oquitaitetamani, pineamaneririca iquiteriteamaniro catsirincaiteri, aisati otsiteniiteamani, ari picantajeiti: “Ompariye meeca incani”. Piojeitaque jaoca ocanta inquite, pioti ompariaquerica incani. Iro cantaincha te piojeiteroji maaroni pineaqueri meeca quipatsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Te pincameetsajeiteji, oshequi pitseencajeitaqueri Tasorentsi: picoajeiveta pineena nontasoncante, iro cantaincha eiro nonijaimpirotsi. Apatiro pineaquero coajicani oca ishiacantiri Jonashi. Irootaque icantaqueriri Jesoshi, irosati ijatantanaja. ");
INSERT INTO cniNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ari nareejeitanaca intatiquero, nocarajeitiri itsipapee iroamere. Impoiji noquenqueshirejeitaquero tanta: tecatsi namaque. ");
INSERT INTO cniNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Icantajeitaquena Jesoshi: —Paamayearoyea tapiacaarori itantane variseopee aisati saroseopee. ");
INSERT INTO cniNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ari nosampitavacaaca: —¿Paita icantanteeri: “Paamayearoyea tapiacaarori itantane”? Te ameji tanta, iroitatsi icantantaqueeri. ");
INSERT INTO cniNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iotashitaca Jesoshi nocantajeitaqueri, icantajeitana: —Te pishiretasanojeitenaji. ¿Paita picantantari: “Te ameji atantane”? ¿Paita piquenqueshiretantacari? ");
INSERT INTO cniNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tequerampa piojeiteji? Chapinqui otimaveta tanta apapacoroni, iro cantaincha noacaajeitacari 5,000 shirampari. Paajeitajiro timaarantapaajantsiri: ¿jaoca ocaratiri cantiriqui pijaajiri timaarantapaajantsiri? Nocantiri: —Ocarati 12. ");
INSERT INTO cniNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aisati impoiji ocarati tanta 7, noacaajeitacari 4,000 shirampari. ¿Jaoca ocaratiri cantiriqui pijaajiri timaarantapaajantsiri? Nocantiri: —Ocarati 7. ");
INSERT INTO cniNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Icantana: —¿Paita caari piojeitanta meeca? Te nonquenqueshireteroji tanta pipeacotanacari. Queariompia, paamayearoyea tapiacaarori itantane variseopee aisati saroseopee. ");
INSERT INTO cniNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Impoiji niojeitanaque te inquenqueshireteroji tapiacaasanotarori tanta, irointi ishiacaventiro maaroni yoametantayetiri variseopee aisati saroseopee. Te irininteji Jesoshi iramatavijeitee yora variseo aisati saroseo. ");
INSERT INTO cniNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Impoiji nojajeitanaque anta Sesareaqui: ora nampitsi yovetsicacantaqueri Jiripo. Ari icantaquena Jesoshi: —Noponeanaca narori inquitequi, natiritapaaque, iro cantaincha ¿paita yaamaajeitaquenari atiri, janicana? ");
INSERT INTO cniNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nacanaqueri: —Icanti aparopee: “Irioyeata Jesoshi Joani, yora vaotisatantaveitachaniri, itinaanaja”. Icanti itsipapee: “Irioyeata Iriashini, yonijantaja”. Icanti itsipapee: “Irioyeata Jerimiashini, yonijantaja”. Irio itsipa ijijeitimpi aviro quenquetsatacantatsiniri, pitinaanaja. ");
INSERT INTO cniNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ari isampitana: —Avirojei, ¿paita picantajeitiri avirori? ");
INSERT INTO cniNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Yacanaqueri Shimo Petero: —Avirotaque Quirishito naamaajeitari. Aviro Itomi Tasorentsi, yora Aneasanotatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Icantiri: —Queario picantaque, Shimo itomi Jonashi. Te irio oamejeitempirone atiri, irinti Apa jenoquiniri oametimpirori. ");
INSERT INTO cniNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nopajitimpi Petero: ocanti pivajiro “Mapi”. Nocoacaaquempi poamejeiteri atiri noamejeitaquempiri avirori. Eiro imatiritsi camaari iroashinoncaajeiteri quemisantajeiteroneri pincamanteriri. ");
INSERT INTO cniNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Noametempi paitarica irantajeiteri atiri irineanteariri Tasorentsi anta ipincatsaritinta. Eirorica piquemisantacairi atiri aca quipatsiqui, eiro ijatitsi inquitequi; irinti maaroni pinquemisantacaajeiteri irisavicajeite anta inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Impoiji aisati icantajeitana: —Eiroyea picamantiritsi atiri: “Iriotaque Jesoshi Quirishito”. ");
INSERT INTO cniNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Impoiji icamantaquena Jesoshi: —Irotaintsi nojate Jerosarequi. Anta oshequi iroashinoncaajeitena yora savicacantatsiri, yora jivatacaajeitiriri saserotepee, yora oametantirori Sanquenarentsi, maaroni. Aitaque oncanteari iroyeetena, iro cantaincha oncarate mava quitaiteri, ari nontinaanaje aisati. ");
INSERT INTO cniNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Iro cantaincha ipiatsatacari Petero: —Novincatsarite, te oncameetsateji oca picantaqueri. Eiro pashinoncaatsi, eiro picamitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ari ipitsocashitanacari Jesoshi, icantiri: —Pijate, piquempetacari Satanashi. ¿Paita pitseencantaquenari? Te pioteroji icoacaaquenari Tasorentsi, irointi piotaque icoacaaquenari atiri. ");
INSERT INTO cniNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Impoiji icantajeitana: —Picoasanotirica pinquemisantasanotena, eiro pantanontatsi avisati, irointi pimpomerentsiventenaro paitarica noncoacaaquempiri narori. Ariorica iroashinoncaimenteetempiro, iro cantaincha pinquemisantasanotanaquena. ");
INSERT INTO cniNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yora coavetachari incavintsayea irisati irashinoncayea; irintiquea yora caari cavintsaachane irisati irineeri Tasorentsi irinti. ");
INSERT INTO cniNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ariorica intime ashiyetarori maaroni timayetatsiri quipatsiqui, iro cantaincha eirorica ijati inquitequi, tempa yatsipetashitacaro maaroni. Pineaquero, tecatsi pincantea pimpinateri Tasorentsi irisavicacantempiri anta inampiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Noponeaca narori inquitequi, natiritapaaque. Coajica nompiaje aisati aca, nontsipatapaaqueari nonampirepee, nompincatsaritapaaque, nonquempeteari Apa. Nompinajeiteri maaroni quearioventanarori nocoacairiri. Irinti maaroni caari quemisantana, noashinoncaajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Queario oca noncamantempiri: eirotsitarica picamajeititsi avirori, pineajeitavajena nompocaje, nompincatsaritasanotapaaje. ");
INSERT INTO cniNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ari 6 nomaajeiti, impoiji yora Jesoshi yaajeitanaqueri Petero, Santiaco, jeri Joa, yora irirenti Santiaco. Yaajeitanaqueri anta antearoqui toncaari. ");
INSERT INTO cniNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ineajeitavaqueri ipashinitimojeitanacari. Ishipaquireavorotanaque, iquempetanacari catsirincaiteri; aisati iitsaare, oquitamarotasanotanaque catsini. ");
INSERT INTO cniNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Imapocaqueri Moishishini, jeri Iriashini: iquenquetsatacaapaaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yora Petero, icantiri Jesoshi: —Novincatsarite, aitanaquempaquea nopocajeitaque naroripee aca, noneajeitaquempi nainti. Pincoaquerica, novetsiquempiro mava pancotsijaniqui: aparoni pashi, aparoni irashi Moishishi, iro otsipa irashi Iriashi. ");
INSERT INTO cniNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Irosati omapocantapaacari omaaroncapaaca mencori, oshipaquireapaaque iroori. Isavicaque Tasorentsi mencoriqui, icanti: —Iriotaque yoca notomi nonintasanotiri, oshequi noveshireimentasanotacari. Pinquemisantajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iquemajeitantacarori iroamerepee oca, itarecajeitanaca, oshequi yoajeitanaqueri cavaco. ");
INSERT INTO cniNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iro cantaincha ipocashitaqueri Jesoshi, ipamijeitaqueri. Icantiri: —Pincatiajeitanaje, eiro pitsaroajeititsi. ");
INSERT INTO cniNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ari yamenajeitanaji: tecatsi irineaje, apaniro inaji Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Impoiji yoirincajeitanaja, icantajeitiri: —Eirota picamantitatsi oca pineaqueri. Arioricaquea noncamaque aisati nontinaanaje, irosatiquea pincamantantayetaqueari itsipapee atiri. Tempa noponeaca inquitequi, natiritapaaque. ");
INSERT INTO cniNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ari nocantajeitaqueri: —Yora oametantirori Sanquenarentsi icantajeiti: “Irotaintsirica impoque Quirishito, irijivatapaaque ironijantapaajea Iriashini”. ¿Paita icantajeitantarori oca? ");
INSERT INTO cniNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yacanaquena: —Queario icantaqueri: “Ironijantapaajea Iriashini, irovetsicajeitaqueri maaroni”. ");
INSERT INTO cniNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Noncamantempi: nijantaja inaji Iriashini, iro cantaincha te iriojeitavaqueriji atiripee, oshequi yoashinoncaajeitaqueri. Aisati narori, oshequi iroashinoncaajeitena. ");
INSERT INTO cniNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Impoiji niojeitanaque iquenquetsatacotaqueri Joa, yora vaotisatantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ari nareejeitapaaca anta itiminta oshequi atiri yapatojeitaca. Irosati ipocashitantacari Jesoshi shirampari. Itiyeroashitapaacari, icantapaaqueri: ");
INSERT INTO cniNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Novincatsarite, pincavintsayeri notomi: oshequi icamanatapiniti, oshequi yashinoncaapinitaca. Ipariapiniti paamariqui, itaapinita, pomein: aisati ipiincapiniti ojaqui, pocn, pocn. ");
INSERT INTO cniNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Naavetanacanari poamere, nocantavetari: “Poavisacotajenari”, iro cantaincha te irimateriji. ");
INSERT INTO cniNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ari icantajeitana Jesoshi: —Te pinquemisantajeiteji, te pincameetsajeiteji. ¿Jaoca oncarate nontsipajeitempi piotanteari? Oshequi pitseencajeitaquena. Impoiji icantiri ashitariri itomi: —Jentsite, pamaquenari pitomi. ");
INSERT INTO cniNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ari iquisatsataqueri camaari, irosati ijatantanaja. Irosati yavisacotantaja yora evancari. ");
INSERT INTO cniNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Impoiji nomanacaacari nosampijeitiri: —¿Paitaquea caari nomatantaro noavisacojeiteri narori? ");
INSERT INTO cniNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Icantajeitaquena: —Iro caari pimatantaro te pinquemisantimateji capichaji. Queario oca noncamantempiri: pinquemisanterica capichaji ari pincantero oca toncaari: “Povaanajea anta”, ari ovaanajea. Pinquemisantasanoterica, tecatsi pomerentsitimotempine. ");
INSERT INTO cniNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Iro cantaincha pincoaquerica pojoqueri camaari quempetariri yoca, ocameetsati pinquenquetsatacaasanoteri Tasorentsi aisati pintitea. ");
INSERT INTO cniNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ari notsipajeitacari Jesoshi anta Carireaqui: narori aisati maaroni itsipapee iroamere. Icantajeitana: —Noponeaca narori inquitequi, natiritapaaque. Irotaintsi irayeetena, ");
INSERT INTO cniNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","iroyeetena. Oncarate mava quitaiteri nontinaanaje aisati. Noquemajeitantacariri, oshequi noashirejeitanaca. ");
INSERT INTO cniNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Impoiji nojajeitanaque Caperenaoqui. Ainiro anta itimi yora quempoyeiriri quirequi yoameetsatantayetarori ivanco Tasorentsi. Ari ijatashitiri Petero, isampitiri: —¿Ipashitapinitarimpa oametimpiri iirequite, yoameetsatantayetarori ivanco Tasorentsi? ");
INSERT INTO cniNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yacashitanacari: —Je, ipiri. Impoiji ipianaja Petero pancotsiqui. Isampitavaqueri Jesoshi: —Shimo, ¿paita piquenqueshiretiri? Yora pincatsaripee, ¿janica icoacotapinitiri iirequite? ¿Icoacotirimpa ishanincasanori? Terica, ¿irintimpa icoacotiri itsipapee atiri? ");
INSERT INTO cniNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Yacanaqueri: —Tempa icoacotiri itsipapee atiri. Ari icantiri: —Queario, tecatsi incoacoteri ishanincasanori. Aisati oquempetaca narori, tecatsi incoacotena Apa: tempa noshanincatacari. ");
INSERT INTO cniNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Iro cantaincha te noninteji ontime inquishimentenari yora quempoyeiriri quirequi. Meeca pijate incajarequi, pimpitasate. Ariorica paaque shaori, pinquirancaqueri, pineaqueri ivantequi quirequi. Paavaqueri, impoiji paanajeneri yora quempoyeiriri quirequi, pimpapaaqueri. Iriotaque avinarojei, avirori aisati narori. ");
INSERT INTO cniNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Impoiji, nocarajeitaqueri itsipapee iroamere, nojatashijeitaqueri Jesoshi, nosampijeitiri: —Anta ipincatsaritinta Tasorentsi, ¿janica intsipateari impincatsaritasanote? ");
INSERT INTO cniNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ari icajemaqueri jananequi, isatecaqueri nianqui, ");
INSERT INTO cniNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","icantajeitana: —Queariotaque oca noncamantempiri: pinquenqueshirejeitea, paventajeiteari Tasorentsi; nocoaque pinquempejeiteari yoca jananequi, pishiretasanotena. Eirorica pishiretasanotanatsi, eiro pineirotsi ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Te irishemeteji yoca: maaroni quempetearine impincatsaritasanotanaque anta inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ariorica paacameetsateri quempetariri yoca jananequi, paacameetsajeitena narori. ");
INSERT INTO cniNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Iro cantaincha ariorica pantacayeri caari cameetsatatsi, noasanquetasanotempi. Oncameetsateme pijivateme pincameme eiro pantacantarime caari cameetsatatsi. Tecatsi noasanquetimentempimeri. ");
INSERT INTO cniNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Queario intime antayeterone caari cameetsatatsi, iro cantaincha oshequi irashinoncaajeitanaquea yora antacairiri. ");
INSERT INTO cniNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Aisati icanti Jesoshi: —Meeca noshiacantempiro. Ariorica antacayempi paco caari cameetsatatsi, pimpesajero, pojocajero; aisati pinquempetero piiti antacayempirica caari cameetsatatsi. Ocameetsaveta pinqueapontsoquitapaaje anta inquitequi, te oncameetsateji ontime apite paco, irootaque pijatanteari Sharincaveniqui, aisati te oncameetsateji ontime apite piiti, irootaque pijatanteari Sharincaveniqui. Ainiro anta paamari caari tsivacanetatsi: quearioya piquemaatsicatarocari. ");
INSERT INTO cniNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aisati ariorica antacayempiro poqui caari cameetsatatsi, pinquitsoreero, pojoquero. Ocameetsati pinqueanaraquitaje inquitequi; te oncameetsateji ontime apite poqui, irootaque pijatanteari Sharincaveniqui pinquematsicatantearori paamari. Pineaquero, te oncameetsateji catsini pantero caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Aisati icanti Jesoshi: —Aisati eiro catsini pitseenquiritsi jananequipee. Ainiro inampirepee Apa quempoyeaventajeitaqueriri jananequipee, camantacoventapinitiriri. ");
INSERT INTO cniNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Noponeaca narori inquitequi, natiritapaaque. Nopocashitaqueri jatatsinemeri Sharincaveniqui, noavisacotantajeariri. ");
INSERT INTO cniNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Aisati icantajeitana Jesoshi: —Noshiacantempiro aisati. Ariorica intime ashitariri 100 irovishate. Impeaquearica aparoni, tempa irashitacotanaqueri yora 99 irovishate iramenantajeariri yora peainchari. ¿Paita piquenqueshirejeitiri avirori? ");
INSERT INTO cniNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Irineajeririca aisati, ¿iriompa iriveshireimentea yora apatojeitainchari caari peacha? Te, irintiquea iriveshireimentea yora peavetainchari. Tempa queario. ");
INSERT INTO cniNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aisati iquempeta yora Apa jenoquiniri: te incoyeji irijate Sharincaveniqui aparoni jananequi. ");
INSERT INTO cniNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Aisati icantaquena Jesoshi: —Ariorica irantero pishaninca caari cameetsatatsi, irootaque poashiretacotanteariri, ocameetsati pijatashiteri, pincanteri. Apaniro pijatashiteri, eiro picamantiritsi itsipapee. Ariorica inquemisantempi cameetsa irisavicantajeari, ari pinquempetacantajeri pirenti, paacameetsatavacaajea aisati. ");
INSERT INTO cniNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Iro cantaincha eirorica iquemisantimpitsi, pijatashitajeri aisati, paanaqueri itsipa piyemisantaririnte: ariorica aparo, ariorica apite. Intsipajeitempi iriotanteari paitarica pincanteriri, aisati intsarojeitapeeri iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Eirorica iquemisantajeitimpi, ari pincamantajeiteri maaroni piyemisantaririnte, intsarojeiterita iriori. Eirorica iquemisantajeitiri, ari pinquempetacaajeari tseencantatsiri, antirori caari cameetsatatsi; eiro picantajiritsi quemisantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Paitarica pincantajeiteriri incanteri aisati iriori Tasorentsi. Pincantajeiteririca ainiro irantane, aisati incanteri iriori Tasorentsi. Pincantajeiteririca te aneroji irantane, aisati inquempetea iriori Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nampiitajempiro: irosatirica pincantajeiteriri avirori Apa jenoquiniri; ariorica pincarajeite apite, ari inquemisantasanojeitempi. ");
INSERT INTO cniNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jaocarica irampatotimentenari apite quemisantanari, ariorica mava, aisati narori noncarajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Impoiji yora Petero isampitiri Jesoshi: —Novincatsarite, inquishenarica noshaninca, tempa ocameetsati noncavintsayeri, eiro nopiataritsi. Iro cantaincha irampiitapinitenarica inquisaquena, ¿jaoca oncarate noncavintsaapiniteri? ¿Ariompa oncarate 7? ");
INSERT INTO cniNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yacanaqueri: —Irosati pincanteani pincavintsayeri: eiro pipiataritsi catsini. ");
INSERT INTO cniNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Noshiacantempiro jaoca icanta Tasorentsi ipincatsariventanti. Itimi pincatsari coatsiri impinatajeri iratiritepee. ");
INSERT INTO cniNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Icajemaqueri aparoni, irevitiriri oshequi quirequi catsini. Icantavetari: “Pimpinatajena”. ");
INSERT INTO cniNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yacanaqueri: “Tecatsi noncantea nompinatajempi”. Ari icantiri pincatsari itsipapee: “Payeri yoca. Pimpimanteri, pimpimantero ijina, itomipee, irovaararo, maaroni, naantajeari quirequi irevitanari”. ");
INSERT INTO cniNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Iro cantaincha itiyeroanaca quipatsiqui yora irevitiriri, icantiri: “Eirotsita pipimantanatsi. Coajica nompinatajempiro, maaroni”. ");
INSERT INTO cniNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ari oshequi icavintsairi ivatorote, icantiri: “Aitanaji, moncarataca, eiro nocoacotajimpitsi”. ");
INSERT INTO cniNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ari ijatanaque yora irevitantavetachari. Iquenanaque avotsiqui, itonquiotavacari irevitiriri iriori capichaji. Icaticavaqueri itsanoqui, icantiri: “Pishintsite pimpinatajena ora pirevitanari”. ");
INSERT INTO cniNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ari itiyeroavetanaca iriori, icantavetari: “Eirotsita picoacotanatsi, coajica nompinatajempi maaroni”. ");
INSERT INTO cniNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Iro cantaincha te incavintsayeriji irinti. Yoiminqueacantaqueri, icantiri: “Ariorica pimpinatajena maaroni, noncanteri iroimisoquijajempi”. ");
INSERT INTO cniNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ari ineantacariri itsipapee, yoashirejeitanaca. Ijatashitaqueri ivatorote, icamantaqueri: “Noneaqueri yoranqui picavintsairi, te incavintsanteji irinti. Yoiminqueacantaqueri irevivetariri irinti capichaji”. ");
INSERT INTO cniNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ari icajemacantaqueri ivatorote, icantiri: “Picantaquena: ‘Eirota pipimantanatsi’, irootaque nocavintsaasanotantaquempiri, nocantimpi: ‘Aitanaji, eiro pipinatajanatsi’. Iro cantaincha te pincameetsateji avinti. ");
INSERT INTO cniNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tempa oncameetsateme pincavintsayerime avirori yora irevivetimpiri capichaji, pinquempetename narori nocavintsaaquempi”. ");
INSERT INTO cniNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ari iquisaqueri, yoiminqueacantaqueri, icantiri: “Meecaquea aviroriniro, ariorica pimpinatasanotajena maaroni, ari noimisoquijajempi”. ");
INSERT INTO cniNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ari piojeitaquero oca noshiacantimpiri. Eirorica picavintsanti, iroasanquetasanotempi Apa jenoquiniri, pinquempeteari yora noquenquetsatacotiri. ");
INSERT INTO cniNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ari iquenquetsatacaana Jesoshi chapinqui anta Carireaqui. Impoiji yovaanaja Joreaqui, anta Joriraniqui intatiquero. Noijatanaqueri narori, aisati itsipapee iroamere. ");
INSERT INTO cniNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aisati yoijajeitaqueri oshequi itsipapee atiri. Aisati oshequi yoavisacojeitaqueri mantsiayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aisati ijatashitaqueri Jesoshi variseopee. Icoavetaca incomitacayearime, irootaque isampitantavetariri: —¿Ocameetsatimpa irojocajero shirampari ijina? ");
INSERT INTO cniNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yacanaqueri: —Tempa pineanatapinivetaro Sanquenarentsi. Peerani yovetsicaqueri Tasorentsi shirampari aisati tsinane, ");
INSERT INTO cniNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","6","aisati icanti: “Ariorica irayero shirampari ijina, inteentareanaqueri iriri aisati iriniro, iro cantaincha te noncoacayeriji irojocajero ijina. Nocoaque quiso iroanaquero. Peerani inashiveitani shirampari aisati ijinatsori, iro cantaincha ariorica iraaquero, onquempetaquea apaniro irinaque, eiro yojocavacaajatsi”. Tempa aitaque itsipatacaacari Tasorentsi, te oncameetsateji irojocacaajeri atiri. ");
INSERT INTO cniNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ari isampitiri aisati: —¿Arimpa? ¿Paita icantantariri Moishishi peerani: “Pisanquenatenero pijina paperi pojocantearori, impoiji ocameetsati pojocajero”? ");
INSERT INTO cniNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yacanaqueri: —Te pincameetsashireteji, irootaque icantantimpiri Moishishi ocameetsati pojocajero pijina. Iro cantaincha te incoacayempiji Tasorentsi pojocajero. Icoacaaquempi eiro pojocajirotsi catsini. ");
INSERT INTO cniNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nocantimpi narori, ariorica pojocajero pijina impoiji paaje pashini, aitaque paimentaquearo pijinasanori. Apatiroti ariorica ojivate aimentempi, ocameetsaveta pojocajero. ");
INSERT INTO cniNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Impoiji, nocarataqueri pashini iroamere, nocantaqueri Jesoshi: —Ariompa, jaata eirota naitame nojina narori. ");
INSERT INTO cniNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Icantaquena: —Eiro pimajeitirotsi pinquemajeitero oca nocantaquempiri. Apaniro inquemero yora yoametasanotiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Timatsi caari matiro iraye ijina: irosati itimapaaque. Timatsi itsipa yaitsoquiyeetiri, caari yaanta ijina. Timatsi pashini caari coatsi iraye. Icoaque intimashitea inquearioventeneri Tasorentsi paitapeerica iranteneriri. Pimaterorica pinquemero oca, ari pinquenqueshiretero. ");
INSERT INTO cniNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Impoiji yamaqueneri Jesoshi jananequipee, icantajeitiri: —Pimpamiteri notomipee, pincanteri Tasorentsi incavintsaajeitenari. Nocantajeivetari: —Eiro pashereiritsi Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iro cantaincha icantana: —Eiro picantiritsi: nocoaque iramajeitenarita jananequipee. Iojeiti iriori ipincatsajeitaquena. Maaroni quempetariri yoca irisavicajeite anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Irosati ipamijeitantavacari, icantiri Tasorentsi: —Apa, nocoaque pincavintsaajeiteri yoca jananequipeeca. Impoiji ijatanaji. ");
INSERT INTO cniNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Impoiji ijatashitaqueri Jesoshi aparoni evancari, isampitapaaqueri: —Oametantatsiri, picameetsataque. ¿Paita cameetsatatsiri nanteri narori nosavicanteari anta inquitequi, noncantaitatiyempani? ");
INSERT INTO cniNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ari icantiri: —¿Paita picantantanari: “Picameetsataque”? Itimi aparo cameetsatatsiri: yora Tasorentsi. Iro cantaincha pincoaquerica pijate inquitequi, pantajeitero maaroni icantiniri Moishishini. ");
INSERT INTO cniNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Icantiri: —Otimi oshequi icantayetiniri: ¿paita picoaqueri nanteri? Yacanaqueri: —Eiro poantitsi, eiro pantirotsi caari pai, eiro picoshititsi, eiro pitseeyacotaritsi pishaninca, ");
INSERT INTO cniNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","pimpincatsateri piri aisati piniro; oquempetaca pininta avisati, aisati pinintajeiteri itsipapee iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Icantaqueri: —Aitaque nomatitacaro nojananequitapaini, irosati meeca. ¿Paita pashini nanteri? ");
INSERT INTO cniNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yacanaqueri: —Picoaquerica pintsoteaquero maaroni, pijate pimpimantero maaroni timimojeitimpiri, pimperi ashinoncachari maaroni ovinaro; impoiji impinatempi Tasorentsi, ontime pivaararo inquitequi. Ariorica pimpimantero maaroni, tsame poijatanaquena narori. ");
INSERT INTO cniNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Iquemavaitiiro oca, ijatanaque, yoashiretanaca. Otimi oshequi irovaararo, te incoyeji impimantero. ");
INSERT INTO cniNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Impoiji icantajeitana Jesoshi: —Queario oca noncamantempiri: opomerentsitimotari ashitaarantachari irijate anta inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nampiitajempiro: tempa opomerentsitaca inqueero cameyo omorojaniqui quitsapi. Iro cantaincha opomerentsitasanotaca catsini irijate ashitaarantachari anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Noquemajeitantarori oca noajeitanaqueri cavaco. Nosampitiri: —¿Ariompa? ¿Janica meeca materone iravisacotaje? ");
INSERT INTO cniNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yamenaquena, icantaquena: —Eiro imatirotsi atiri, iro cantaincha irinti Tasorentsi irimataquero maaroni. Tecatsi ompomerentsitimoteari irinti. ");
INSERT INTO cniNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Icantaqueri Petero: —Pamene, nocoasanojeitaque noijatanaquempi, irootaque nojocajeitantacarori maaroni timimojeivetanari. ¿Paita naayetajeri coajicani aisati? ");
INSERT INTO cniNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Icantajeitana Jesoshi: —Queario oca noncamantajeitempiri, tempa noponeaca inquitequi, natiritapaaque: coajica ontime quipatsi iroaquerari. Narori, nosavique anta novincatsarimentoqui, nompincatsatasanotaque. Aisati avirorijei, pincarajeitena pimpincatsarijeitanaque, ontime 12 pivincatsarimentopee pisavicajeitanteari aviroripee. Pimpincatsariventajeiteri maaroni joriopee. ");
INSERT INTO cniNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ariorica poijajeitanaquena, tecatsi pantsipejeitea. Ariorica pojocanaquero pivancopee, pirentipee, pitsiropee, piripee, piniropee, pitomipee, piipatsite, paitapeerica. Iro cantaincha ariorica poijatasanotanaquena, te pantsipetashijeitearoji. Ariorica pojocanaquero aparo, impajempi Tasorentsi 100. Aisati iraajeitanaquempi inampiqui pisaviquimojeitanteariri iriori, pincantaitatiyempani. ");
INSERT INTO cniNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Itimajeiti meeca oshequi pincatsarijeitatsiri aca quipatsiqui, iro cantaincha eiro ipincatsarijeitajitsi inquitequi: ariorica aparopee pincatsaritanajantsine. Aisati itimajeiti meeca oshequi ashinoncaajeitachari, iro cantaincha coajica anta inquitequi impincatsaritaarantapaaje. ");
INSERT INTO cniNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Pashini aisati icanti Jesoshi: —Noshiacantempiro aisati jaoca icanta Tasorentsi ipincatsariventanti. Itimi ashitarori irovamashite. Tsiteniquera ijatamani nampitsiqui irameneri tsameetenerine. ");
INSERT INTO cniNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ineapaaqueri coatsiri intsameeteneri, icantiri: “Ariorica pintsameetena meeca, irosati ishaaviniji, nompinajeitempi aparoni quirequi: yora pajitachari tenario”. Icantajeiti: “Ari cameetsa”. Ari icantiri: “Meeca pijajeite, pintsameejeite”. Ijajeitanaque, itsameejeiti. ");
INSERT INTO cniNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Impoiji ijenoquitapaaque catsirincaiteri, ijatanaji aisati nampitsiqui yora ashitarori irovamashite. Ineapaaqueri itsipapee shirampari, icatiashijeitaca anta, tecatsi irantajeite. ");
INSERT INTO cniNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Icantiri: “Ariorica pintsameejeite anta novamashitequi, cameetsa nompinajeitaquempi”. Icantajeitiri: “Ari”. Irosati ijajeitantanaca, itsameejeiti. ");
INSERT INTO cniNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aisati tampatica ijati nampitsiqui, itsameetacaajeitiri itsipapee. Aisati ishaavijini itsameetacaajeitiri itsipapee aisati. ");
INSERT INTO cniNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Impoiji aisati antoo ishaavijiteanaji, ijatanaji nampitsiqui. Ineapaaqueri caari tsameejeitatsi. Icantajeitiri: “¿Paita patsipetashijeitantari picatiashijeitaca? Te pintsameejeiteji”. ");
INSERT INTO cniNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yacajeitanaqueri: “Tecatsi tsameetacaajeitenane”. Icantiri: “Pintsameejeite novamashitequi, pincarajeiteri yora jivajeitanaintsiri incaranqui”. ");
INSERT INTO cniNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ari otsimancaiteanaji, yora ashitarori icantiri quempoyeiniriri iirequite: “Pincajemajeiteri maaroni tsameetacotanarori novamashite, pimpinajeiteri. Pijivateri pimpinajeiteri yora impoitatsiri itsameejeiti. Impoiji pimpinajeiteri jivajeitatsiri itsameejeiti oquitaitetamani”. ");
INSERT INTO cniNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ari ipocajeiti yora impoitatsiri itsameejeiti: capichaji itsameejeiti iriori, iro cantaincha ipinajeitaqueri aparoni tenario. Aisati imoncaratavacaajeitaca ipinajeitaqueri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Impoijiniquea ipocajeiti iriori yora intamanarori itsameejeitamani. Ijitashijeivetaca iranaacojeiteri impinajeiteri. Iro cantaincha ipinajeitaqueri aisati aparoni tenario. ");
INSERT INTO cniNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ineatiiri iirequite, iquisatsataqueri yora tsameetacairiri, ");
INSERT INTO cniNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","icantiri: “Yora impoitatsiri itsameejeiti capichaji, iro cantaincha imoncarataquena pipinataquena. Nainti nojatitamanaca oquitaitamani notsameeti, opomerentsivetaca, oshequi nomasavitaque. Oncameetsateme nanaacoterime nayeri quirequi”. ");
INSERT INTO cniNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ari icantiri: “Noshaninca, te namatavijeitempiji. Tempa nocantimpi oquitaitetamani: ‘Nompinatempi aparoni tenario’; picantajeivetana: ‘Ari, cameetsa’. ");
INSERT INTO cniNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Paanajeri meeca piirequite, pijajeitaje pivancoqui. Nopinatashitacari yora impoitatsiri itsameeti aparo tenario imoncaratantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tempa ocameetsati nopashitacari noirequite. ¿Paita caari picoanta noncavintsayeri?” ");
INSERT INTO cniNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aisati noncamantempi: anta inquitequi impincatsarijeitanaque yora caari pincatsarijeitatsi aca quipatsiqui. Yorari irinti pincatsarijeivetachari aca, eiro ipincatsarijeitajitsi anta inquitequi. Aisati icantajeivetari Tasorentsi oshequi atiri: “Pinquemisantena”, iro cantaincha te inquemisantajeiteji, irootaque caari irijajeitantea iriori inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ari impoiji ijatanaque Jesoshi Jerosarequi, itentajeitanaquena narori, aisati itsipapee iroamere. Apaniro icantajeitaquena: ");
INSERT INTO cniNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Meeca ajajeite Jerosarequi. Ari noponeanaca narori inquitequi, natiritapaaque. Irotaintsi irayena jivatacaajeitiriri saserotepee aisati yora oametantirori Sanquenarentsi, incantena: “Te pincameetsateji”. ");
INSERT INTO cniNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Incanteri oromasati: “Payeri Jesoshi, poyeri”. Irishirontimentajeitena iriori, impasanajeitena, impajacojeitena coroshiqui, noncame. Oncarataque mava quitaiteri irointinaajena aisati Apa. ");
INSERT INTO cniNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Impoiji ojatashitiri Jesoshi ijina Severeo, otsipatari otomipee: yora Santiaco aisati Joa. Otiyeroashitapaacari, ocantapaaqueri: —Nocoaque pincavintsayena. ");
INSERT INTO cniNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Isampitiro: —¿Paita picoiri? Ocantiri: —Coajica, ariorica pimpincatsaritasanotanaque, nocoaque irisaviquimotempi notomipee: aparo irisavique pacosanoriqui, irio itsipa irisavique pampatequi. Pincanteri incarajeitempi impincatsarijeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Icantiro, aisati icantiri otomipee: —Te pioteji paitarica picoacotanari. Oshequi nonquematsicayetearo paitapeerica. ¿Tempa pintsaroacayearo pinquematsicatearo avirori? Yacanaqueri: —Te nontsaroacayearoji, ari nomataquero narori. ");
INSERT INTO cniNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ari icantiri: —Queario pinquematsicajeitearo. Iro cantaincha te naro cantatsine janicarica saviquimotenaneri coajica: irio cantatsine Apa, irinti. ");
INSERT INTO cniNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Noquemajeitantarori oca icantajeitiriri, noquisajeitaqueri yora Santiaco aisati Joa; iro noquisantacariri, icoaveta impincatsariteme. ");
INSERT INTO cniNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iro cantaincha icajemajeitaquena Jesoshi, icantajeitaquena: —Piojeitaque yora ivincatsaritepee itsipapee atiri yamejeitaca iperanajeitacari ishanincapee. ");
INSERT INTO cniNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Iro cantaincha eiro piquempejeitaritsi. Eiro picoajeititsi avirori pimperanajeiteari pishanincapee. Pincoaquerica pimpincatsariventante pintacojeiteari pishaninca, eiroquea piperanayetaritsi. Pantajeiteneri pishaninca paitarica incoacaajeitempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Noponeaca narori inquitequi, natiritapaaque, iro cantaincha te iro nompocantea nomperanajeitempi, irointi nopocanta nintacojeitempi aisati noncamimentajeitempi, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ari noponeajeitanaca Jericoqui, noquenajeitanaque avotsiqui. Yoijajeitanaquena oshequi atiri. ");
INSERT INTO cniNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ari isaviqui otsapiqui avotsi apite caari amenatsi. Icamanteetiri: —Coraque Jesoshi. Ari icajemajeitanaque: —Pincavintsaajeitapeena: tempa aviro ishanincani Iravirini. ");
INSERT INTO cniNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ari iquisatsataqueri yora apatojeitainchari, icantajeitiri: —Pimajerete. Aiquero icajemajeitanaque: —Novincatsarite, pincavintsayena: tempa aviro naamaajeitacari, aviro ishanincani Iravirini. ");
INSERT INTO cniNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Icatiapaaca Jesoshi, icantiri: —¿Paita picoiri nantempiri? ");
INSERT INTO cniNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Icantiri: —Novincatsarite, nocoaque namenaje. ");
INSERT INTO cniNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ari icavintsairi, ipamititaqueri iroqui. Irosati yamenantanaja, aisati yoijajeitanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ari nareejeitapaaca Vetejajequi, oquempejitaro toncaari ipajiyeetiro Orivomashi. Irotapaajantsi Jerosare. Itianquiri Jesoshi apite iroamere, ");
INSERT INTO cniNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","icantiri: —Pijivatanaque anta nampitsiquinta. Pineapaaquero voro, otsatacotaca; otsipatacari orijani. Pintsatacoreapeero, pamaquenaro. ");
INSERT INTO cniNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Irisampitempirica ashaninca: “¿Paita pitsatacoreantarori?” Ari pincanteri: “Irio coirori Avincatsarite”. Ari incantempi: “Paanaqueneri”. ");
INSERT INTO cniNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iro yantantarori oca, imoncaratiro isanquenatacotaqueriniri peerani yora camantantatsiniri pajitachari Sacariashi: ");
INSERT INTO cniNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Pincamantajeiteri jerosaresati: ‘Coraquetaqueni pivincatsarite. Icameetsataque, te irishemeteji. Inquijacotapeempari vorojaniqui’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ari ijatanaque apite, ineapairo voro, yamaqueneri. ");
INSERT INTO cniNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Apite yamaque: tsinane, aisati orijani. Yoanquetaqueneri imititsaqui quitsaarentsi, impoiji iquijacotacari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ari itimi oshequi atiri anta avotsiqui, yoayetaqueneri iroicoropee anta avotsiqui iraaticantanaquearori voro. Aisati yoayetaqueneri ojempequijaniqui inchatoshi avotsiqui, iraaticantanaquearori. Aitaque yametaro yoayetiniri pincatsaripee iroicoropee aisati ojempequijaniqui inchatoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ari ijivajeitanaqueri oshequi atiri anta avotsiqui, aisati impoijeitanaqueri oshequi pashini. Icajemajeitanaque: —Jeriqueti ishanincani Iravirini, tsame ampincatsajeitavaqueri. Itiancaqueri Avincatsarite, tsame aneacameetsajeiteri. Tempa ineacameetsatiri iriori Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ari yareetapaaca Jerosarequi. Isampitavacaajeitaca maaroni jerosaresati: —¿Janicampa yoca? ");
INSERT INTO cniNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yacajeitaqueri itsipapee: —Iriotaque Jesoshi, poneachari Nasaretequi, ora timatsiri Carireaqui. Oshequi iquenquetsatacotiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ari ijataque Jesoshi ivancoqui Tasorentsi, iquisajeitapaaqueri maaroni amanantatsiri aisati pimantatsiri, yojocajeitapaaqueri. Aisati iquempejeitaqueri yora pinaavacaariri iirequite, aisati yora pimantiriri paroma: itatsinquitapaaqueri imesatepee aisati isavicamentopee. ");
INSERT INTO cniNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Icantajeitaqueri: —Ocanti Sanquenarentsi: “Icanti Tasorentsi: ‘Ocameetsati pinquenquetsatacaapinijeitena aca novancoqui’ ”. Iro cantaincha avirojei te pinquenquetsatacaajeiteriji, irointi picoshitapinijeitiri pocajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Impoiji ijatashitaqueri oshequi caari amenatsi aisati choriyetatsiri. Yoavisacojeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ari ineajeitaqueri yora jivatacaajeitiriri saserotepee aisati yora oametantirori Sanquenarentsi, iquisajeitanaca. Ocameetsati yantayetiri, aisati icantajeiti atiripee: —Tsame ampincatsajeiteri ishanincani Iravirini. Irootaque iquisajeitantacariri yoranqui, ");
INSERT INTO cniNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","aisati icantajeitaqueri Jesoshi: —¿Piquemaquerompa oca icantajeitiri atiripee? Te oncameetsateji impincatsajeitempi. Yacanaqueri: —Je, noquemaqueri. Tempa pineanatiro Sanquenarentsi cantatsiri: “Impincatsajeiteri Quirishito yora jananequipee”. ");
INSERT INTO cniNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ari ijatanaji Jesoshi, quiso noanajiri narori, aisati itsipapee iroamere. Nojajeitanaque Vetaniaqui, aitaque nomaajeitapairi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ari oquitaitetamanaji nopiajeitanaja Jerosarequi. Nianqui itasheanaque Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ineapaaquero avotsinampiqui iyera. Icoavetapaacaro oitsoqui, te ontimeji; irointi iotaca oshi. Icanti: —Meeca eiro otimajitsi aisati oitsoqui iroajeitantajearori atiri. Irosati oshimpeshitantanaca, ocamaque iyera. ");
INSERT INTO cniNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Noneantacarori, nosampitiri: —¿Jaoca ocantanacari oshintsitantanacari oshimpeshitanaque? ");
INSERT INTO cniNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yacanaquena: —Queario oca noncamantempiri: ariorica pishiretasanoteari Tasorentsi, pimatero avirori quempetarori pineaqueri meeca. Aisati pincanteririca Apa: “Povaajero oca toncaari, pojoquero anta incajarequi”, aitaque irimatacaaquempiro. Iro cantaincha, eiro pitseenquiritsi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ariorica pishiretasanoteari, irimatacaaquempiro paitapeerica pincoacoteriri. ");
INSERT INTO cniNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ari nareejeitapaaja ivancoqui Tasorentsi, yoametantapaaji Jesoshi. Irosati ijatashitantapaacari yora jivatacaajeitiriri saserotepee aisati yora jivatacantantatsiri, isampijeitiri: —¿Janicampa tianquimpiri pantayetantarori ocapee? ¿Janica nintacaimpiri pipincatsaritantacari? ");
INSERT INTO cniNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yacanaqueri: —Aisati narori, aparo nosampitempi: ariorica pancaquena, noncamantempi janica tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Janicampa tianquiriri Joa ivaotisatantayetariri ashanincapee? ¿Irimpa tianquiriri Tasorentsi? ¿Irimpa tianquiriri atiri? Ari icantavacaajeitanaca: —Ancanteririca: “Irio Tasorentsi tianquiriri”, icanteecari: “¿Paita caari piquemisantantari?” ");
INSERT INTO cniNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iro cantaincha ariorica ancanteri: “Irio tianquiriri atiri”, iquisajeiteecari atiripee. Tempa ijitashijeitari irio Tasorentsi tianquiriri Joa iquenquetsati. ");
INSERT INTO cniNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ari icantajeitiri: —Te nioteji janicarica tianquiriri. Icantiri: —Aisati narori, eiro nocamantimpitsi janicarica tiancaquenari nantantarori ocapee. ");
INSERT INTO cniNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Aisati icantajeitiri Jesoshi: —Meeca noshiacantempiri ashitachari itomi apite: ¿paita piquenqueshiretacotiriri? Icantiri intarori itimi: “Notiomi, pijate meeca pintsameete anta ovamashiqui”. ");
INSERT INTO cniNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yacanaqueri: “Eiro notsameetitsi”, iro cantaincha impoiji ijati itsameeti. ");
INSERT INTO cniNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aisati icantiri itsipa itomi: “Notiomi, pijate meeca pintsameete anta ovamashiqui”. Ari icantiri: “Ari, apa, nojataque”. Iro cantaincha te irijateji. ");
INSERT INTO cniNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Meeca nosampitempi: ¿janica antasanotiniriri iriri icoacairiri? Yacanaqueri: —Yora jivatatsiri itimi, jatatsiri itsameeti. Icantiri aisati: —Queario oca noncamantempiri: irijivajeitempi irijajeitanaque inquitequi yora coshitantatsiri aisati ora antapiniyetiriri shirampari caari ai. ");
INSERT INTO cniNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ipocapaaque Joa icamantavetimpi jaoca pincantajeameri pincameetsatantajeameri, iro cantaincha te pinquemisantavaqueriji. Irinti iquemisantajeitaqueri yora apatotiniriri oromasati iirequite, aisati oquemisantaqueri antapiniyetiriri shirampari caari ai. Pineajeivetacari iquemisantajeiti icameetsatantajari, iro cantaincha te pinquenqueshirejeiteaji avirorijei; te pinquemisantavaqueriji Joa. Irijajeite irinti inquitequi: aviroriquea avinti, eiro pijajeititsi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jero oca pashini icantiriri Jesoshi: —Pashini aisati noshiacantempiro: pinquemajeitavaquero. Itimi shirampari panquitirori ovamashi. Itantacotiro otsapiqui. Aisati yovetsiquiro intsinacaitantearori oitsoqui, aisati onanteari oja. Yovetsiquiro pancotsi jenoquitatsiri yamenacotantarori savicatsiri ora panquirentsi. Impoiji icantiri pashini ishaninca: “Meeca nocoi pamenenaro novamashite, aisati pintsameetacotenaro”. Icantiri: “Ari”. Impoiji ijatanaque yora ashitarori ovamashi pashiniqui quipatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Peeranitanaque omoncarataca otimanaque oitsoqui. Itiancavetacari iratiritepee: “Pijajeite pincanteri yora amenirori novamashite impacantena nashitari narori”. Ari ijajeivetanaca. ");
INSERT INTO cniNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ineajeitavaqueri yora amenirori ovamashi: ipasatavaqueri aparo, tac, tac; pashini yoavaqueri, shemi; irio itsipa ipichavaqueri, pitse, pitse. ");
INSERT INTO cniNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ari yora ashitarori, ari itiancavetaca pashini iratiritepee, icarajeiveta oshequi. Iro cantaincha yoashinoncaajeitavaqueri yora amenirori ovamashi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Impoiji iquenqueshiretaque yora ashitarori: “Meeca nontianqueri notomi. Iriitatsi impincatsatavaque irinti”. Ari itiancavetacari iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Iro cantaincha ineajeitantavacariri, icantanirotavacaaca: “Coraquetaqueni yora itomi ashitarori iroamashite. Ariorica incame iriri, iriotaque ashitajearoneri ovamashi. Tsame avavaqueri, impoiji ashijeitajearo arori ovamashi”. ");
INSERT INTO cniNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ari yaajeitavaqueri, shepi; yaanaqueri anta otsapiqui, yoaqueri, shemi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ariorica impocaque yora ashitarori iroamashite, aamaaca, ¿jaoca incantapeeriri yora amenavetanariri iroamashite? ");
INSERT INTO cniNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Icantajeitiri: —Tempa iraanirojeiteri, iroashinoncaajeiteri, iroajeiteri. Impoiji iramenaje pashinipee cameetsatatsiri, amenajenerine iroamashite, yora paaranterineri irinti oitsoqui irovate. ");
INSERT INTO cniNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ari icantiri Jesoshi: —Tempa pineanatiro ocantiri Sanquenarentsi: “Itseencaquero mapi yora vetsiquirori pancotsi, iro cantaincha ipeaquero Tasorentsi otincamiaro pancotsi. Tempa icameetsataque Avincatsarite, tempa avajeitanaquero cavaco maaroni yantajeitiri”. ");
INSERT INTO cniNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Irootaque nocantajeitantimpiri: eiro pineajeitiritsi Tasorentsi impincatsariventajeitempi. Irintiquea irinti impincatsariventajeiteri pashinipee: yora pincatsatasanojeiterineri, quemisantasanojeiterineri. ");
INSERT INTO cniNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Naro shiacantachari mapi nocantaquempiri: terica piotavaquena, pashinoncayea; terica pinquemisantena, pijate Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ari iquemajeitavaqueri yora jivatacaajeitiriri saserotepee aisati yora variseopee. Iojeitaque irio iquenquetsatacotaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Icoajeivetaca iraacanterime Jesoshi, iro cantaincha itsaroacaajeitacari atiripee. Iotaqueri atiripee queario iquenquetsatacotaqueri Jesoshi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Pashini aisati ishiacantiniri Jesoshi, icantajeitiri: ");
INSERT INTO cniNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Noshiacantempiro jaoca icanta Tasorentsi ipincatsariventanti. Itimi pincatsari itomi aatsineri ijina. Impoiji icoaque pincatsari iriveshireimentajeiteari ishanincapee itomi. Icajemacantajeivetacari iroacaajeitearime. ");
INSERT INTO cniNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Itiancavetacari inampirepee, icajemacantajeivetacari ishaninca, iro cantaincha, te impocajeiteji. ");
INSERT INTO cniNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Itiancavetaja aisati, icantiri: “Pincamanteri yora nocajemacantaqueri: ‘Vetsicayetaca maaroni. Yoayetaqueri vaca aisati vacajaniqui. Caate piveshireimenteari itomi aatsineri ijina’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Iro cantaincha te inquemisantavaqueriji, irointi ijajeitanaque jaocarica. Ijati aparo iroanequi, irio pashini ijati iomparita. ");
INSERT INTO cniNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Irio pashinipee yaajeitavaqueri itiancane, shepi; yoashinoncaavaqueri, impoiji yoajeitavaqueri, shemi. ");
INSERT INTO cniNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ari iquisanaca yora pincatsari. Itiancaqueri soraro, yoapaaqueri yora oaqueriri itiancane aisati itaitaqueri ivancopee. ");
INSERT INTO cniNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Impoiji icantiri itsipapee inampirepee: “Vetsicayetaca maaroni, iro cantaincha te incameetsateji yora nocajemacantajeivetacari”. ");
INSERT INTO cniNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pijajeite meeca anta nampitsiqui, pincantajeiteri maaroni pineajeitaqueri: “Caate avinti avincatsaritequi, piveshireimenteari itomi aatsineri ijina”. ");
INSERT INTO cniNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ari ijajeitanaque, yapatojeitaqueri maaroni ineajeitaqueri: cameetsayetatsiri, caari cameetsayetatsi, maaroni. Ijaajeitapaacaro pancotsi. ");
INSERT INTO cniNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ari ijataque yora pincatsari ivetsajeitavacari pocajeitaintsiri. Ineaqueri aparoni shirampari caari quitsaatacha cameetsa. ");
INSERT INTO cniNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Icantiri: “Noshaninca, nopajeivetaquempi quitsaarentsi cameetsari pinquitsaatimentearimeri notomi. ¿Paita caari piquitsaatantaro?” Te iranqueji. ");
INSERT INTO cniNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ari icantiri inampire: “Poisoteri iracoqui aisati iitiqui. Pojoqueri anta otsitenitaquenta, anta itiminta iraajeitachari aisati cavintsaajeitachari”. ");
INSERT INTO cniNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pineaquero: icajemacantavetacari oshequi, iro cantaincha te irishequiteji yora icoyeasanotaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Impoiji ijajeitanaque variseopee, yoametavacaajeitaca: —¿Jaoca ancanteriri Jesoshi ancomitacanteariri? Ariorica incomitaquea, irosati anquisacantanteariri. ");
INSERT INTO cniNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Impoiji itiancajeitaqueri iroamerepee, itsipajeitacari oijatiriri Eroreshi. Isampijeitapaaqueri Jesoshi: —Oametanari, niojeiti queario poametantaque. Cameetsa poametantiro irineane Tasorentsi, te pintsaroacayeariji itsipapee atiri, aisati te pimpincatsateriji. ");
INSERT INTO cniNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Meeca pincamantena paitarica piquenqueshiretiri: ¿ocameetsatimpa amperi Sesari airequite? ¿Tericampa oncameetsateji? ");
INSERT INTO cniNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iro cantaincha iotaque Jesoshi icoajeivetaca iramatavijeiterime. Isampitiri: —¿Paita picoantacari pamatavitena? Te pincameetsateji. ");
INSERT INTO cniNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pinijayenari quirequi pipapinitiriri oromasati. Ari yamaqueneri apamentaquiro, ipajiyeetiri tenario. ");
INSERT INTO cniNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ari isampitiri: —¿Janicampa ashitarori ishiacantaro oca? ¿Jaoca opajitari ivajiro oca sanquenataincharica? ");
INSERT INTO cniNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yacanaqueri: —Tempa Sesari. Ari icantiri: —Panteneri Sesari icoacaimpiri, aisati panteneri Tasorentsi icoacaimpiri iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iquemajeitavaqueri, irosati yoajeitantanacari cavaco. Ari ijajeitanaji. ");
INSERT INTO cniNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Impoiji yora saroseopee ipocashitaqueri Jesoshi, ijitashijeitaca iriori eiro atinaajeitajatsi, eiro ajajeititsi inquitequi. Ari isampitapaaqueri: ");
INSERT INTO cniNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Oametanari, icantini peerani Moishishi: “Ontimerica shirampari ijina, iro cantaincha te intimacayeroji itomipee. Impoiji incamaquerica, ocameetsati iraajero irirentini ijinani, intimacayero otomi, iro cantaincha irishiacanteri itomini irirentini”. ");
INSERT INTO cniNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ari itimi shirampari aisati irirenti, icarajeiti 6. Yaavetajaro ijina, iro cantaincha te intimacayeroji itomi. Impoiji icamaque iriori, torein. Yaavetajaro aisati irirentini, te intimacayeroji aisati, impoiji icamaque. ");
INSERT INTO cniNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aisati iquempejeitaca irirentipee, maaroni aajeivetajarori: te intimacayeroji itomipee. ");
INSERT INTO cniNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Impoiji ocamaque iroori tsinane, torein. ");
INSERT INTO cniNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ariorica intinaajeitanaje, ¿janicampa aajeroneri? Pamene, ijinantajeiveitaroni maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ari yacanaqueri: —Oshequi picomijeitacaro. Te piojeiteroji Sanquenarentsi, aisati te pioteji itasorentsitasanoti Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ariorica antinaajeitanaje, tecatsi aajantsineri. Maaroni tinaajantsineri inquempejeitajeari inampirepee Tasorentsi: eiro yaajeitapaajitsi ijina. ");
INSERT INTO cniNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Intinaajeitanaje maaroni camajeitatsiri, tempa pineanatiro icantimpiri Tasorentsi: ");
INSERT INTO cniNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Narotaque Tasorentsi: ipincatsataquena Avarama, ipincatsataquena Isaca, ipincatsataquena Jacovo”. Te incanteji: “Ipincatsaveitanani”, pineaquero, aneatsi meeca inajeiti: irootaque ipincatsajeitantacariri. Aisati, aneatsi inajeiti, irootaque ipincatsariventantariri iriori Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Noquemajeitantacarori oca, noajeitanaqueri cavaco, nocantajeiti: —Tempa cameetsa yoametanti Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iquemajeitaque variseopee cameetsa yacanaqueri Jesoshi saroseopee, irootaque itsaroacantajeitanacariri iriori irineanatajeri aisati. Ari ipocashitaqueri iriori variseopee Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Icoajeivetaca incomitacayearime. Icarajeitiri aparoni oametantirori Sanquenarentsi, isampitiri: ");
INSERT INTO cniNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Oametanari, ainiro oshequi oamejeitaquee Sanquenarentsi: ¿paita cameetsatasanotatsiri anquemisantajeiteri? ");
INSERT INTO cniNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yacanaqueri: —Iro cameetsatasanotatsiri oca: “Pinintasanoteri catsini Tasorentsi, yora Avincatsarite: pinquearioventero pinintasanoteri, pincantaitatiyempani”. ");
INSERT INTO cniNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Irootaque anaacotantatsiri isanquenajeitiri. ");
INSERT INTO cniNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Otimi otsipa, quempetarori: “Oquempeta picavintsaaja avisati, pincavintsaajeiteri pishanincapee”. ");
INSERT INTO cniNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ariorica pimajeitaquero oca, ari pimoncarajeitaquero maaroni isanquenatiniri Moishishi, aisati maaroni isanquenatiniri yora quenquetsatacantatsiniri. ");
INSERT INTO cniNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ari Jesoshi isampijeitiri yora variseopee apatotimentajeitariri: —¿Paita piquenqueshiretacotiriri Quirishito? ¿Janica irishanincateari? ");
INSERT INTO cniNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Yacajeitanaqueri: —Irishanincateari Iravirini. ");
INSERT INTO cniNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Icantiri: —Peerani osanquenatacaaqueri Ishire Tasorentsi Iravirini, icantantariri Quirishito: “Novincatsarite”. Tempa piotiro isanquenare: “Yora Tasorentsi icantiri Novincatsarite: ‘Pisavique, notiomi, nacosanoriqui, pincaratena ampincatsariventante. Aitaque pisavique irosati nontsoncajeitanteariri maaroni quisajeitaquempiri’ ”. ¿Paita icantantariri Iravirini: “Novincatsarite”? ");
INSERT INTO cniNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Iriorica Quirishito ivincatsarite Iravirini, ¿paita picantantariri irio ishanincani? Tempa amejeita apincatsajeitiri jivajeiteeri itimi. ");
INSERT INTO cniNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tecatsi incantajeitea irancanaqueri. Aisati itsaroacaajeitacari itsipapee irisampiterime iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Impoiji icantajeitaqueri Jesoshi apatotimentajeitariri, aisati icantaquena narori, aisati icantajeitaqueri iriori itsipapee iroamere: ");
INSERT INTO cniNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Yora oametantirori Sanquenarentsi aisati yora variseopee ijitashijeivetaca iquempetacari Moishishi: oshequi iperanatashijeitaquempi. ");
INSERT INTO cniNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ocameetsaveta pantayetero paitapeerica icantayetimpiri, iro cantaincha eiro pantirotsi yantashiyetari iriori. Icantajeivetimpi: “Cameetsa pintime”, iro cantaincha te intimeji iriori cameetsa. Te irimateroji iriori icantajeivetimpiri. ");
INSERT INTO cniNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Oshequi opomerentsitimojeitaquempi pantajeitaquero icantajeitaquempiri, iro cantaincha te impomerentsiventearoji iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yantashiyetaro paitapeerica pineanteariri, pineacameetsatanteariri. Imavacotacaro irineane Tasorentsi iracoqui aisati yamatseetacotacaro ivancainaqui; antearo oni, pincantajeitanteariri: “Pineaqueri, quemisantincari ini”. Aisati oshequi yoanencashitacaro iitsaare ocaratapai. ");
INSERT INTO cniNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ariorica yoajeita, icoasanotaque intsipatapiniteari pincatsatatsiri. Aisati anta yapatojeitanta icoasanotaque savicamentotsi cameetsari. ");
INSERT INTO cniNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Icoaque cameetsa pivetsajeiteari anta nampitsiqui, icoaque pincantajeiteri: “Oametanari”. ");
INSERT INTO cniNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Iro cantaincha avinti, eiro piquempetaritsi: eiro picoitsi incanteetempi: “Oametanari”. Iriotaque Tasorentsi oamejeitimpiri; avirojei, pimoncaratavacaajeitaca. ");
INSERT INTO cniNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aca quipatsiqui eiro picantashitaritsi itsipapee: “Apa”. Itimi Piri apaniro anta inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aisati eiro pishinetiritsi incanteetempi: “Novincatsarite”. Itimi pivincatsarite apaniro, yora Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pincoaquerica pimpincatsaritanaque, pijivate pintacojeiteari itsipapee. ");
INSERT INTO cniNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ariorica pincantajeiteri: “Nompincatsariventempi”, ari pishemetaque catsini, iro cantaincha iroashinoncayempi Tasorentsi. Impeajeri pincatsaritajantsine maaroni caari shemejeitatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Icantiri Jesoshi yora oametantirori Sanquenarentsi aisati variseopee: —Oshequi pamatavitantajeiti, coajica irootaque oshequi pashinoncaajeitanteari. Eiro pijatitsi anta ipincatsaritinta Tasorentsi, aisati te pincoacayeriji itsipapee irijate iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Oshequi pamatavitantajeiti, coajica irootaque oshequi pashinoncaajeitanteari. Picoshitaquero camajimentaaro ovanco; pishiacantavetaca piquenquetsatacairi Tasorentsi, pisamaninirotashitacaro, vero, vero, vero. Aitaque iroasanquetasanojeitempi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Oshequi pamatavitantajeiti, coajica irootaque oshequi pashinoncaajeitanteari. Oshequi pipomerentsiventacaacari itsipa atiri pipeantacariri jorio. Impoiji poametiri yamatavitanti, inquempetantempiri irijatanteari Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Oshequi pamatavitanti: piquempetacari caari amenatsi yora acatsatiriri iyamarajaquiririnte. Pashinoncaajeitanaquea. Picantashinirota: “Ariorica ancante: ‘Tempa otimi ivanco Tasorentsi, piotanteari eiro namatavitimpitsi’, ari ocameetsati amatavitante. Iro cantaincha ariorica ancante: ‘Tempa otimi oro anta ivancoqui Tasorentsi, piotanteari eiro namatavitimpitsi’, ari eiro amatavitanti”. ");
INSERT INTO cniNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¿Paitasa picantantari? Te pionirojeiteji catsini. Oshequi pineaveetashita. ¿Paita cameetsatasanotatsiri? ¿Irompa oro cameetsatasanotatsiri? ¿Irompa ivanco Tasorentsi cameetsatasanotatsiri? Tempa irootaque ocameetsatantari oro otimi ivancoqui Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aisati picantashinirojeita: “Ariorica ancante: ‘Tempa otimi atantanariri Tasorentsi avira, piotanteari eiro namatavitimpitsi’, ari ocameetsati amatavitante. Iro cantaincha ariorica ancante: ‘Tempa itimi avira avaqueneri Tasorentsi, antaaqueneri, piotanteari eiro namatavitimpitsi’, ari eiro amatavitantitsi catsini”. ");
INSERT INTO cniNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¿Paitasa picantantari? Te pionirojeiteji catsini. ¿Paita cameetsatasanotatsiri? ¿Iriompa pivira? ¿Irompa pitaantanariri Tasorentsi pivira? Tempa irootaque icameetsatantari pivira pitaaqueneri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","22","Pamene, oshequi picanti: “Tempa otimi ataantanariri Tasorentsi”, “Tempa otimi ivanco Tasorentsi”, “Tempa otimi inquite”, paitapeerica. Picantashinirotaro, impoiji pijitashiniroveta ocameetsati pamatavitanti. ¿Pijitimpa te intimeji Tasorentsi? Noncamantempi: itsoteaquero itasorenca maaroni. Iojeitiro pantajeitiri, iroasanquetimentempiro maaroni pamatavitanti. ");
INSERT INTO cniNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Oshequi pamatavitantajeiti, coajica irootaque oshequi pashinoncaajeitanteari. Pamene, timatsi pimayevetacari. Ariorica paaque piirequite 10, pipaqueri Tasorentsi aparoni; ariorica paaque 10 oshi pipanquitiri, jero pipavetacari aparoni oshi. Iro cantaincha te pinquenqueshireteroji icoacaasanovetaquempiri Tasorentsi: icoaveta pintimeme cameetsa, icoaveta pincavintsayerime pishaninca, icoaveta pinquemisanterime. Oncameetsateme pimajeiterome maaroni ocapee, impoiji ariorica paaque paitapeerica oncarate 10, aparoni pimpaqueri Tasorentsi. Yovaajiniri, icantajiri aisati: ");
INSERT INTO cniNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","—Te pioteji catsini, iro cantaincha picoajeiveta poamejeiterime itsipapee. Oshequi piquearioventavetacaro pipomerentsiventasanovetacaro caari icoacaasanotimpi Tasorentsi; iro cantaincha te pinquenqueshiretimateroji capichaji oca icoacaasanovetimpiri. ");
INSERT INTO cniNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Oshequi pamatavitantajeiti, coajica irootaque oshequi pashinoncaajeitanteari. Piquivasanovetaro piramento otapiiqui, iro cantaincha te pinquiveroji osantequi: oshequi oshititaque. Aisati piquempejeita avirori, poameetsantashita ineacameetsajeitantimpiri ashanincapee, iro cantaincha pishirequi te pincameetsateji catsini: oshequi picoshitapiniti aisati oshequi pinevetaro vaararontsi. ");
INSERT INTO cniNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Te piojeiteji catsini. Pijivate pinquivasanotero osantequi, impoiji eiro oquipatsitajitsi aisati otapiiqui. Arioricame pincameetsashiretaqueme, irineacameetsajeitempime ashanincapee. ");
INSERT INTO cniNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Oshequi pamatavitantajeiti, coajica irootaque oshequi pashinoncaajeitanteari. Piquempejeitacaro yoanteetariri camatsiri, ipotsotiro quitamarori. Ocameetsavetaca saiteriquica, iro cantaincha tsompoina oshititaque, ojaacaro itonqui camatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ineacameetsajeivetaro ashanincapee pantayetiri, iro cantaincha te pincameetsashireteji: oshequi pamatavitanti aisati oshequi pantapinitiro caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Oshequi pamatavitantajeiti, coajica irootaque oshequi pashinoncaajeitanteari. Peerani yora pishanincapeeni yoajeitaqueri quenquetsajeitironiri irineane Tasorentsi, yora cameetsatatsiniri. Meeca povetsicajeitiro pancotsipee pinquenqueshirejeitanteariri yora quenquetsatacantatsiniri. Poanencayetaquero cameetsa. Picantanirojeiti: “Nontimitaqueame nainti peerani, eiro noajeitirime, eiro noquempetarime nainti noshanincani oajeitaqueriniri”. ");
INSERT INTO cniNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Picanti avirori: “Noshanincajeitacari yora peeraniniri”. Queario oca picantanirojeitiri. ");
INSERT INTO cniNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aisati piquempejeitacari, avirojeitaque oayeri. Tempa iriojeitaque intacaroniri, meeca aviro vaajeitajirori poantaji. ");
INSERT INTO cniNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Piquempejeitacari maranque, te pincameetsajeiteji catsini. ¿Pijijeitimpa eiro pijajeititsi Sharincaveniqui? ");
INSERT INTO cniNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Aisati icantajeitaqueri Jesoshi: —Nontianquempiri coajica itsipapee quenquetsatacoterineri Tasorentsi, iotasanotiriri, oametanteroneri irineane. Niotaque povaaranteri, pashinipee pimpajacotaaranteri, itsipapee pimpasanataaranteri anta papatojeitanta, itsipapee aisati pinquisaaranteri jaocarica irijayetanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ainiro pantanejei avirori, picoacaajeitaqueri incamajeitaque maaroni cameetsatatsiri: yora Averini, maaroni. Aisati yora Sacariashi, yora itomini Verequiashini: iquemisantacaavetacari ashanincani anta ivancoqui Tasorentsi, iro cantaincha yoajeitaqueri. Pintimitaqueame avirori, pamijeitaquerime poajeitaquerime avirori. Pashi poajeitiro poantajeiti. ");
INSERT INTO cniNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aitaque iroasanquetimentajeitaquempiri Tasorentsi maaroni picoacaajeitaqueri incame. ");
INSERT INTO cniNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jo, aviro jerosaresati. Oshequi poapinitiri quenquetsatacotiriri Tasorentsi, pipichaavaqueri maaroni itiancayevetimpiri. Oquempeta teapa osaramonquitari orijanipee, ocavintsairi, nocoaveta nonquempetearome narori, noncavintsaajeitempime. Iro cantaincha te pincoajeiteji. ");
INSERT INTO cniNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jero ivanco Tasorentsi pineacameetsajeitaqueri: eiro nopiashitajarotsi aisati. Aisati Apa, eiro ipocashitajirotsi iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Eiro pineapinijeitajanatsi aisati. Apanivani pineajeitavajena aisati, pincantajeite: “Icameetsataque Jesoshi, iriotaque Avincatsarite tianquiriri”. ");
INSERT INTO cniNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ari iponeaca Jesoshi ivancoqui Tasorentsi, irotajantsi irijataje. Ari nojatashitaqueri, nocarajeitaqueri itsipapee iroamere, namenacaajeitaqueri ivanco Tasorentsi aisati otsipapee pancotsi. ");
INSERT INTO cniNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ari icantaquena: —Ari pineamempeajeivetacaro meeca oca pancotsipeeca. Queario oca noncamantempiri: coajica intireetajero maaroni, irovarayeetajero maaroni mapipee. ");
INSERT INTO cniNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ari nojajeitanaque toncaariqui ipajiyeetiro Orivomashi. Isavicapaaque Jesoshi, ari nojatashitaqueri, nosampijeitaqueri: —Pincamantajeitena: ¿jaoca oncarate intireetantajearori pancotsipee? ¿Paita iotacayenane jaoca oncarate pimpocantajeari? ¿Jaoca oncarate omoncaratantajeari maaroni picantaquenari? ");
INSERT INTO cniNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yacanaquena: —Queariompiya, yamataviyeetimpicari. ");
INSERT INTO cniNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Intime oshequi pocatsine, cantapaatsine: “Narotaque nainti Quirishito”. Iramataviyetapeeri oshequi atiri. ");
INSERT INTO cniNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pinquemapiniteri incante: “Imanatavacaajeita atiripee anta”. Incante itsipa: “Coajica irimanatavacaajeitea anta”. Iro cantaincha eiro piquenqueshirejeitatsi. Aitaque oncanteari irimanatavacaajeitea, iro cantaincha tequeratsita omoncarateaji maaroni nocantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aitaque oncanteari yora atiri inquisajeitanaqueri itsipapee atiri; intime pashinipee quemajeiterone itashe, iro cantaincha eiro otimanajitsi iroanajeari; aisati onicapinitea quipatsi; ");
INSERT INTO cniNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","iro cantaincha eirotsita iquematsicaatasanotarotsi. ");
INSERT INTO cniNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pashini aisati icantaquena: —Ariorica iriojeitanaque atiri piquemisantajeitaquena, iroashinoncaapinijeitempi, iroaarantempi, inquisajeitempi maaroni atiri. ");
INSERT INTO cniNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Intime oshequi jocayeteroneri iquemisanti, impoiji inquisaqueri quemisantasanotaintsiri, iraacantayeteri, paitapeerica. ");
INSERT INTO cniNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Intime amatavitantatsineri, incantavetea: “Nonquemisantacayempi”, iro cantaincha iramatavijeiteri maaroni quemisantavetavaquearine. ");
INSERT INTO cniNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Oshequi irantajeitero atiri caari cameetsatatsi, oshequi catsini, impoiji irijocajeitajero inintavacaajeitani. ");
INSERT INTO cniNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Iro cantaincha noavisacojeiteri maaroni quearioventanarori nocantaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pijajeitanaque maaroni quipatsiqui, pincamantajeiteri maaroni atiri nocoaque nompincatsariventajeiteri; impoijiquea omoncaratea maaroni nocantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Aisati icamantajeitana Jesoshi: —Peerani isanquenatini yora Iranieri, yora camantantatsiniri, icantini: “Intime coajica anta ivancoqui Tasorentsi caari cameetsatatsine, iramparajeitero maaroni”. Tempa piotiro oca noquenquetsatacotiri. Ariorica pineaqueri yoca nocamantacotiri, ");
INSERT INTO cniNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","aisati pintimerica Joreaqui, pishiajeitanaque toncaariqui. ");
INSERT INTO cniNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ariorica pisavique saiteriqui, eiro pijatapanajantitsi pivancoqui paantapanajantearori pivaararo, irointi pishiasanotanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aisati pintimerica oantsiqui, eiro pipiashitapaintarotsi otsipa piitsaare. ");
INSERT INTO cniNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Oshequi ashinoncaajeitanaquea tsinane tsomontetatsineri aisati antsotayerine ojananequite: eiro omatirotsi oshiasanotanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aitaque coajica pishiajeitanaque, iro cantaincha pincanteri Tasorentsi eiro pishiantatsi incaniniqui aisati quitaiteriqui pimaoreajeitantari. ");
INSERT INTO cniNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aisati icanti: —Aitaque oshequi iroashinoncaajeitempi. Pashinoncaasanojeitanaquea, panaacojeiteri maaroni peeraniniri aisati maaroni timajantsineri coajica. ");
INSERT INTO cniNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Arioricame osamanitanaqueme iroashinoncaajeitempime, pintsoncajeiteame maaroni; iro cantaincha incavintsaajeiteri Tasorentsi maaroni quemisanterineri incoyeajeiteri, irootaque eiro osamanitanta iroashinoncayeetempi. ");
INSERT INTO cniNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ariorica incanteetempi: “Pamene, jeri yoca Quirishito”, eiro pishiretavacarotsi incantempiri. Aisati, incanteetempirica: “Nijaantapaaja anta Quirishito”, eiro pishiretavacarotsi. ");
INSERT INTO cniNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Intime oshequi amatavitantatsineri, incante: “Naro Quirishito”, irio itsipa: “Naro quenquetsatacotiriri Tasorentsi”. Oshequi intasoncantayete, iramatavijeiteri oshequi savicajeitatsineri, iro cantaincha eiro imatiritsi yora quemisantasanotatsineri. ");
INSERT INTO cniNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Piquemaquena nocamantitaquempiro jaoca oncanteari coajicani. ");
INSERT INTO cniNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Incantempirica: “Timatsi Quirishito anta caaraiteriqui”, eiro patsipetashitatsi pijatashitena. Ariorica incantempi: “Ainiro Quirishito anta pancotsiqui tsompoina”, eiro pishiretarotsi. ");
INSERT INTO cniNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ari noponeaca narori inquitequi, natiritapaaque. Tempa imapocapinitimpi iporequi, porec, impoiji otsoteapaintiro inquitequi: aisati nonquempetapaajea narori, ariorica nompocaje. Nomapocajeitapaajempi, iro cantaincha pineajeitavajena, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jaocarica icamapinitiri camatsiri, aitaque ipocashitapinitiri tisoni. Aisati oquempetaca, oshequi itseencanti joriopee, irootaque impocashitanteariri oshequi amatavijeiterineri. ");
INSERT INTO cniNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Aisati icanti Jesoshi: —Ari oshequi ompomerentsitimojeiteri atiri, maaroni: irashinoncaajeitanaquea. Impoiji intsipaite intsivacanaque catsirincaiteri, aisati yora cashiri; impariajeitanaque impoquiropee, irishevajeitanaquea maaroni inquitesati. ");
INSERT INTO cniNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Impoiji nonconijatapaaje anta inquitequi, irosati iroashirejeitantanaqueari maaroni tseencajeitanari. Irineajeitavaquena maaroni atiri nonquenapaaje mencoriqui: nompincatsaritasanotapaaque, noshipaquireasanotapaaque. ");
INSERT INTO cniNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nontiotapaaque iriojeitanteari maaroni nonampire impocajeitantapeempari iramajeitantapeempariri maaroni quemisantajeitanari, maaroni nocoyeajeitaqueri. Intsoncajeitanaqueri savicajeitatsiri pashinipeequi quipatsi, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Pashini icantajeitaquena Jesoshi: —Meeca noshiacantempiro iyera: pinquenqueshiretasanotero. Ariorica oshiocajempequitanaje, aisati oshitanaje, ari piojeitanaque irotimatajantsi onquimojantsitaje. ");
INSERT INTO cniNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aisati oquempetaca: ariorica pineajeitavaquero oca nocantaquempiri, piojeitanaque irotajantsi nompocaje. ");
INSERT INTO cniNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eirotsitarica picamajeiti, ario pineajeitavaquero maaroni oca nocamantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ompeanaquea inquite aisati quipatsi, iro cantaincha eiro opeatsi irointi noneane. Omoncaratajea maaroni nocantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pashini aisati icantajeitaquena Jesoshi: —Iro cantaincha tecatsi iotatsine jaocarica oncarate: te irioteji inampirepee Apa, aisati te nioteji narori. Irinti Apa apaniro ioti. ");
INSERT INTO cniNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Peerani itimaveitani Noeni, yoapinijeita ishaninca, ishinquitapinijeita, yaapinijeitiro ijina, maaroni. Te inquenqueshirejeiteroji icamantavetariri: “Coraquetaque oonquea”. Impoiji itetacaro pitotsi, yashitacotanaca, tarocn. Impoiji aisati omapocajeitaqueri atiri incani, ooncanaca, itsoncajeitanaca, itsitiajeitanaque. Aisati inquempejeitaquea maaroni atiri, ariorica omoncaratapaaquea nompocantajeari narori: eiro iquenqueshirejeitatsi, nomapocajeitapaajeri. Impoiji irashinoncaajeitanaquea maaroni tseencajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Intimerica apite tsameetatsineri anta oantsiqui: naanajeri aparoni nontsipatanaqueari, irio itsipa eiro naanajiritsi. ");
INSERT INTO cniNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ontime apite tsinane tononqueroneri tirico: naanajero aparoni nontsipatanaquearo, iro otsipa eiro naanajirotsi. ");
INSERT INTO cniNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Aisati icantana: —Paamaajeitena, pinquenqueshiretapinijeitena: te piojeiteji jaoca oncarate nompocantajeari. Nomapocapaimpicari. ");
INSERT INTO cniNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Oquempetaca yora ashitarori ivanco icoshiyeetiri: irioteme irotaintsi impoque coshiterineri, irisaaquiteme, eiro ishinetirime incoshiteri, irointi iroimpiavajerime. ");
INSERT INTO cniNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aisati narori, paamaajeitena: nomapoquimpicari. ");
INSERT INTO cniNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pinquempejeiteari nampirentsi cameetsari, yora iotasanotatsiri. Icantiri nampitariri: “Aviro vetsicapiniteroneri iroajeiteari notomi, pimpapiniteri cameetsa”. ");
INSERT INTO cniNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Ariorica irineaqueri cameetsa yovetsicapinitiro yoari, ari incanteri: “Cameetsa pantayetaquero nocoacayetaquempiri. Meeca aviro quempoyeajenarone maaroni timimojeitanari. Cameetsa nompinatempi, nioti eiro pamatavitanatsi”. Tempa ari inquimoshiretanaque inampire. ");
INSERT INTO cniNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Iro cantaincha intimerica itsipa inampire, caari quemisanterine yora nampitariri. Incante irinti: “Meeca jataque ini nampitanari, eirotsita ipiajatsi”. ");
INSERT INTO cniNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Iquisaqueri itsipa nampirentsi, icapojapiniyetiri, ishinquitapinitaca. ");
INSERT INTO cniNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Impoiji imapocapaajiri yora nampitariri: te iraamaajeariji. ");
INSERT INTO cniNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ari yoasanquetapaaqueri, itiancaqueri arejiqui itsipajeitantapeempariri yora amatavitantatsiri. Ari anta yoashiretasanotanaca aisati oshequi icavintsaanaca. Eiro piquempejeitaritsi avinti, irintiquea pinquempejeitea quemisantasanotiriri nampitariri. ");
INSERT INTO cniNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Pashini aisati icamantaquena Jesoshi: —Meeca noshiacantempiro aisati jaoca icanta Tasorentsi ipincatsariventanti. Otimi 10 evancaro, coatsiri amenavaqueri ojimetsori impoque. Otsitenitanaque, irosati aantayetacaro otsioro. ");
INSERT INTO cniNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ari ocarataque evancaro iotasanotaintsiri apapacoroni, aisati ocarataque caari iotatsi iroori apapacoroni. ");
INSERT INTO cniNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aavetacaro iroori otsioro, iro cantaincha te ayeji oja orivo. ");
INSERT INTO cniNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Irointi ora iotatsiri, aacotanaquero oja, ontsiotantearori. ");
INSERT INTO cniNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ari osamanitanaque, tequera impoque. Impoiji aajeitaquero ovochoquine, omaajeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ari nianquiite oquematii icanteetaquero: “Coraquetapaaque pijimetsori, pijate pamenajeitavaqueri”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ari otinaajeitanaca, ovetsicajeivetaro otsioro. ");
INSERT INTO cniNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ocantavetaro caari iotatsi: “Pimpena narori oja, irotaintsi ontsivaque notsioro”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Iro cantaincha acanaquero ora quenqueshiretainchari: “Eiro nopimpirotsi, eiro onarotsi oja. Nompempirica, tecatsi nontsiotanaqueari narori. Pijajeite pamanantanontapaintea avirori”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ari ojatanaque amanantavetapainta. Jentsipaite yareetapaaca ojimetsori, iqueanaque anta yoajeitanta, icarajeitaquero ora vetsicajeitainchari, yashitacojeitanaca. ");
INSERT INTO cniNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Impoiji opiavetaja caari quenqueshireacha, ocantavetapaacari: “Pashitareajenaro narori, noneapaajempi”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Iro cantaincha yacanaquero: “Te niotempiji, janicampirica. Te noncoyeji pimpocashitena aca”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pinquenqueshiretero oca noshiacantimpiri: paamayena, te piojeiteji jaocarica oncarate nompocantajeari. ");
INSERT INTO cniNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Icantaquena aisati: —Pashini noshiacantempiro jaoca icanta Tasorentsi ipincatsariti. Oquempetaca ijatanaque ashitaarantachari pashiniqui nampitsi. Ijivataque icajemajeitaqueri maaroni inampirepee, icantaqueri: “Nocoaque pinquempoyeajeitenari noirequite”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Icantiri aparo: “Jeri S/.200,000, pinquempoyeajenari”. Irio icantiri itsipa: “Jeri S/.80,000, pinquempoyeajenari”. Irio itsipa aisati ipaqueri S/.40,000 inquempoyeanteariri. Irio anaacotantaintsiri ioti yora ipasanotaqueri oshequi. Yora caari ipasanoti, irio caari iotasanotatsi. Ari ipajeitaqueri, impoiji ijatanaque pashiniqui nampitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yora aasanotiriri quirequi oshequi ijatanaque iomparita. Yoshequiasanotaqueneri iirequite ivatorote, icaratiri S/.200,000 aisati. ");
INSERT INTO cniNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aisati iomparita yora airiri S/.80,000. Yoshequiaqueri aisati, yaantacari aisati itsipa S/.80,000. ");
INSERT INTO cniNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Iro cantaincha irinti aavetariri S/.40,000, yaanajiri quirequi, itijiri omoroqui quipatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Impoiji ipiaja yora ivatorote, icantapairi: “Pimpajeitena meeca noirequite”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ari ipocaque yora aaqueriri S/.200,000, yamaqueri aisati itsipapee S/.200,000. Icantiri: “Jeri quirequi pipaquenari. Oshequi niomparitaca, noshequiasanotaqueri. Jeri itsipa quirequi, icarati aisati S/.200,000”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ari icantiri ivatorote: “Cameetsataque, pimatasanotaquero nocoacaaquempiri. Chapinqui piquempoyeajanari capichaji, nocoaque meeca pinquempoyeajenari oshequi aisati. Nocoaque oshequi noveshireacayempi”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Impoiji ipocapaaque yora airiri S/.80,000. Icantiri ivatorote: “Jerica quirequi pipaquenari. Oshequi niomparitaca, noshequiasanotaqueri. Jeri itsipa quirequi, icarati aisati S/.80,000”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Icantiri ivatorote: “Cameetsataque, pimataquenaro nocoacaaquempiri. Chapinqui piquempoyeajanari capichaji, nocoaque meeca pinquempoyeajenari aisati oshequi. Oshequi noveshireacayempi”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","Impoitapaaque yora aavetariri S/.40,000, icantapaaqueri: “Niotaquempi avirori, te pincavintsante, oshequi notsaroacaimpi. Nojiti ariorica noshequiaquerime piirequite, ari paapitsatenarime maaroni, irootaque caari niomparitanta. Notijaqueri piirequite, maaroni. Jerica, noipiajimpiri”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Yacanaqueri: “Te pincameetsateji, oshequi piperataca. Piovetaca nocoavetaca narori irishequianaqueme noirequite. ");
INSERT INTO cniNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Paita caari pipantari yora itsipa quempoyeapinitiriri quirequi? Pimpajerime iriori, impinataquename, naantajeameri aisati. Aisati iroimpiajenarime maaroni nashisanori”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ari icantiri itsipa inampire: “Paapitsatajeri noirequite, pimpajeri yora ashitasanotariri meeca S/.400,000. ");
INSERT INTO cniNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nompasanoteri yora ashitaarantachari. Irintiquea yora caari ashitaarantacha, naapitsatajeri ora capichaji timimovetariri. ");
INSERT INTO cniNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Meeca paanajeri yoca anta otsiteniitetinta: te incameetsateji. Nocoaque incarajeiteri maaroni yora oashirejeitachari aisati ashinoncaajeitachari”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Impoiji icantajeitana Jesoshi: —Noponeaca narori inquitequi, natiritapaaque. Coajica nojatanaje, impoiji nompiaje aisati; oshequi nompincatsaritapaaque, noncarajeitapaaqueri oshequi nonampirepee. Nompincatsaritasanotapaaque, impincatsatasanojeitavaquena maaroni savicajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nampatojeiteri maaroni atiri, jaocarica isavicajeitiri. Nonquempeteari yora ashitariri ivira inashitacaari: irovishate aisati yora iyavarate; aisati narori nonashitacayeari quemisantajeitanari aisati tseencajeitanari. ");
INSERT INTO cniNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Noncantajeiteri maaroni quemisantajeitanari: “Pimpocajeite aca nacosanoriquica”. Irinti tseencajeitanari noncantajeiteri: “Pimpocajeite avirori aca nampatequica”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Impoiji noncamantajeiteri savicajeitatsiri nacosanoriqui: “Caatanaque, maaroni, oshequi iriveshireacaajeitempi Apa maaroni. Peerani, catsini yovetsicajeitaquempiro pisavicajeitanteari anta inampiqui. Meeca pijajeite pincarajeiteri. Cameetsa impincatsariventajeitempi. ");
INSERT INTO cniNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aavetaquenani notashe, pipajeitaquenaro noari. Aavetaquenani nomire, pipajeitaquenaro niraqueri. Te piojeivetenaji, iro cantaincha pineshinoncajeitaquena anta pivancopeequi. ");
INSERT INTO cniNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Te ontimaveiteani noitsaare, ari pipajeitaquenaro. Nojoquiiveitani, ari pijatashijeitana pineajeitana. Yoiminqueetaquenani caravosoqui, ari pijatashijeitana, picavintsaajeitaquena”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Impoiji incantajeitena yora cameetsajeitatsiri: “¿Arimpa novincatsarite? ¿Jaocampa ocaratiri aantavetaquempiri pitashe nopantaquempiri poari? Te nonquenqueshiretajeroji. ¿Jaocampa ocaratiri aantavetaquempiri pimire nopantaquempiri piraqueri? ");
INSERT INTO cniNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jaocampa ocaratiri noneshinoncatantaquempiri novancoqui? ¿Jaocampa ocaratiri nopantaquempirori piitsaare? ");
INSERT INTO cniNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jaocampa ocaratiri nojatashitantimpiri noquivantantimpiri?” ");
INSERT INTO cniNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ari nancanaqueri: “Queario oca noncamantempiri: ariorica picavintsaaqueri aparoni quemisantanari picavintsaaquena narori”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Impoiji noncanteri yora catiajeitainchari nampatequi: “Tsamempi pijajeitanaque anta Sharincaveniqui, pinquematsicajeitearo anta paamariqui yovetsicaqueri Tasorentsi peerani. Yovetsiquiniri camaari aisati maaroni oijajeitiriri. Meeca pincarajeiteri anta, oshequi pashinoncayea. ");
INSERT INTO cniNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Peerani aaquena notashe, iro cantaincha te pimpenaji noyeari. Aaquena nomire, iro cantaincha te pimpenaji nireri. ");
INSERT INTO cniNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nojatashivetimpi noneempime, iro cantaincha te pineshinoncatavaquenaji, te poisavicavaquenaji pivancoqui. Te nonquitsaaveiteani, iro cantaincha te pimpenaji noitsaare. Nojoquiitacani aisati yoiminqueetaquena caravosoqui, iro cantaincha te pijatashitenaji pineena”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Impoiji irancajeitena: “Novincatsarite, ¿jaocampa ocaratiri noneantavetaquempiri pashinoncaaca, iro cantaincha te noncavintsayempiji?” ");
INSERT INTO cniNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ari noncanteri: “Queario oca noncamantempiri: te pincavintsaajeiteriji yora quemisantajeitanari, irootaque caari picavintsantana narori”. ");
INSERT INTO cniNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ari iroashinoncaajeiteri Tasorentsi anta Sharincaveniqui, incantaitatiyempani. Irinti cameetsajeitatsiri irisavicajeitaje inquitequi, incantaitatiyempani. ");
INSERT INTO cniNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Impoiji icamantajeitaquena Jesoshi, narori aisati itsipapee iroamere: ");
INSERT INTO cniNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Piojeiti ocarati apitenivani quitaiteri omoncaratantajeari quitaiteri apajitiri Yavisantaniri. Noponeaca narori inquitequi, natiritapaaque, iro cantaincha coajica impajacotacanteetaquena. ");
INSERT INTO cniNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ari yapatojeitaca yora jivatacaajeitiriri saserotepee aisati yora savicacaajeitantatsiri. Yapatojeitaca anta ivancoqui yora ivincatsarite saserotepee. Ipajita iriori Caijashi. ");
INSERT INTO cniNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yoametavacaajeitaca, icanti: —¿Jaoca ancanteriri Jesoshi aanteariri aisati avacantanteariri? Iro cantaincha te ancoyeji iriojeitanaque atiripee: iquisacoventaricari. ");
INSERT INTO cniNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ari icanti itsipapee: —Irotaintsi quitaiteri Yavisantaniri: inquimoshirejeitanaque atiripee. Eiro amatiritsi ayeri meeca Jesoshi, iquisacoventajeitaricari. ");
INSERT INTO cniNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Impoiji yovaanaja Jesoshi Vetaniaqui, noijajeitanaqueri. Nojajeitanaque maaroni, irosati ivancoqui Shimo, yora patsaaveitachaniri peerani. ");
INSERT INTO cniNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Noajeitapaaca, irosati opocantacari tsinane amacotaquero casancajari. Oshequi ovinaro casancajari. Ari osaitapaaqueri iitoqui. ");
INSERT INTO cniNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Noneajeitantarori oca, noquisajeitanaquero, nocantajeiti: —¿Paitaquea aparajatantarori? ");
INSERT INTO cniNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ompimanterome casancajari, ayeme oshequi quirequi, impoiji oncavintsayerime oshequi ashinoncaajeitachari. ");
INSERT INTO cniNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yacanaquena Jesoshi: —¿Paita picantimentantarori oca tsinaneca? Ocameetsataque oca antaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Incantaitatiyempani incarajeitempi ashinoncaajeitachari, pincantaitatiyempani pincavintsaapinijeiteri irinti. Irompa nainti, eiro nocantani nosavique aca. ");
INSERT INTO cniNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iotaque noncame, irootaque osaitantanari. ");
INSERT INTO cniNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Queario oca noncamantempiri: coajica pinquenquetsatacaajeiteri maaroni savicajeitatsiri quipatsiqui, pintsoteaquero maaroni nampitsi, aisati pincarajeiteri oshequi itsipapee. Jaocarica pijajeiteri pincamantajeiteri atiripee antaquerica oca tsinane, iriojeitanteari ocavintsaquena. ");
INSERT INTO cniNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Impoiji ijatanaque itsipa iroamere, yora pajitachari Jorashi Ishicariote. Ijatashijeitaqueri yora jivatacaajeitiriri saserotepee, ");
INSERT INTO cniNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","icantapaaqueri: —Ariorica noncamantajeitempi jaoca pincanteriri Jesoshi paanteariri, ¿paita pimpinajeitenari? Yacanaqueri: —Nompinatempi quirequi. Ari ipajeitaqueri imentaqui quirequi, icarati 30. Iro yovetsiqueetiri imentaqui perata. ");
INSERT INTO cniNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Irosati ipiantaja Jorashi, yamenasanotiri Jesoshi iriotanteari jaoca iraacanteriri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ari moncarataca noajeitantarori tanta caari tapiacha. Nojatashijeitaqueri Jesoshi, nosampijeitiri: —¿Jaoca picoaqueri nojajeiteri novetsicantempirori poyeari pinquenqueshiretantearori Yavisantaniri? ");
INSERT INTO cniNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Icantaquena: —Pijajeite Jerosarequinta, pincantapaaqueri yora pineapaaqueri: “Icanti oamejeiteeri: ‘Irotaintsi nomoncaratero. Nocoaque noyea anta pivancoqui, noncarajeiteri noamerepee’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ari nojajeitanaque, nocantapaaqueri. Yonijaquenaro ivanco, irosati novetsicantacaro noajeiteari. ");
INSERT INTO cniNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ari tsitenijencaiteanaque ipocapaaque Jesoshi, isaviquimojeitapaaquena, ");
INSERT INTO cniNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","noajeitanaca. Impoiji icantajeitaquena: —Queario oca noncamantajeitempiri: meeca, aca picarajeitica, timatsi aacantenaneri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ari noashirejeitanaca, irosati nosampijeitantariri: —¿Narompa, novincatsarite, aacantempineri? Irio itsipapee aisati icantiri: —¿Narompa, novincatsarite, aacantempineri? ");
INSERT INTO cniNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yacajeitaquena: —Iriotaque yoca quitacotaquenarica meeca nomatitatequi. ");
INSERT INTO cniNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Noponeaca inquitequi, natiritapaaque. Oquenquetsatacotanani Sanquenarentsi peerani, aitaque nomoncaratero maaroni oquequetsatacotanari. Iro cantaincha oshequi irashinoncaasanotanaquea yora aacantenaneri. Oncameetsateme eiro itimime iriori, impoiji eiro yashinoncaame. ");
INSERT INTO cniNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Impoiji isampitiri Jorashi: —¿Narompa, oametanari, aacantempineri? Yacanaqueri: —Je, avirotaque. ");
INSERT INTO cniNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ari tequera nontsoncajeitero noyea, ari yaaquero Jesoshi tanta, yajiricaquero, ipasonquitiri Tasorentsi. Impoiji icarajaquero, ipajeitaquena, icantajeitaquena: —Paajeitavaquero, poajeitearo. Tempa narotaque camimentajeitempineri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Impoiji yaaquero aisati nirajeitantari, ipasonquitajiri Tasorentsi. Ipacojeitaquenaro, icantajeitaquena: —Pirajeitero, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tempa irootaque niraja amparajatimentajeitempineri, incavintsaajeitantempiri Tasorentsi. Ariorica paventajeitena, eiro iquenqueshiretajirotsi Tasorentsi caari cameetsatatsi pantajeitiri. Iroaquera oca nocantajeitaquempiri piojeitanteari jaoca pincantajeari pavisacojeitantajeari: avirorijei, aisati maaroni timajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Eiro meeca nirajirotsi aisati ovaja. Ariorica nirajero aisati, noncarajeitempi irajeitero anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ari nopampoyeaventajeitiri Tasorentsi, impoiji nojajeitanaque anta toncaariqui pajitachari Orivomashi. ");
INSERT INTO cniNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nareejeitantacari, icamantajeitana Jesoshi: —Meeca tsiteniri pojocajeitanaquena. Tempa oquenquetsatacojeitimpini Sanquenarentsi: “Incamaquerica shentajeitiriri irovishate, irishiajeitanaque irovishate, irovaraajeitanaquea”. ");
INSERT INTO cniNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Iro cantaincha ariorica nontinaanaje aisati, nojivajeitanajempi Carireaqui. ");
INSERT INTO cniNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ari icantiri Petero: —Arioricampa irojocajeitanaquempi irinti yocapee, iro cantaincha nainti, eiro nojoquimpitsi. ");
INSERT INTO cniNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yacanaqueri: —Queario oca noncamantempiri: meeca tsiteniri, tequerarica irineaje teapa, ari oncarataque mava pincante: “Te nioteriji Jesoshi”. ");
INSERT INTO cniNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Icantiri: —Ariorica nontsipatempi ancamajeite, iro cantaincha eiro nocantitsi: “Te nioteriji Jesoshi”. Aisati nocantajeivetacari narorijei, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Impoiji ijatanaque Jesoshi Jetsemaniqui, noijajeitanaqueri: narori, aisati maaroni itsipapee iroamere. Icantaquena: —Pisavicajeitavaquetsita aca: nojate anta nonquenquetsatacaavaquerita Apa. ");
INSERT INTO cniNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ari yaanaqueri Petero, jeri itomipee Severeo apite. Oshequi yoashiretanaca, iquenqueshiretanaca. ");
INSERT INTO cniNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Impoiji icantiri: —Oshequi catsini noashiretanaca. Pisavicajeitavaqueta aca, pisaaquiteyea. ");
INSERT INTO cniNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ari yavisaque capichaji, impoiji itarecapaacaro quipatsi, iquenquetsatacaaqueri Iriri: —Apa, te noncoaveteaji nonquemaatsicatearome, iro cantaincha eiro nantirotsi nocoavetari narori, irointi nantempiro picoacaaquenari avinti. ");
INSERT INTO cniNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Impoiji ipiashitacari iroamere, ineajeitapaaqueri imaajeitaque. Icantiri Petero: —Tempa pamavetimatero pivochoquine, te pimateroji pisaaquitimate capichaji. ");
INSERT INTO cniNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pisaaquite, pincanteri Tasorentsi iramitacotantempiri eiro pantantarotsi caari cameetsatatsi. Picoavetaca pimatasanoterome maaroni nocoacaaquempiri, iro cantaincha te pimateroji. ");
INSERT INTO cniNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ari ipianaja, icantajiri aisati: —Apa, picoacaasanotaquenarorica nonquemaatsicatearo, aitaque cameetsa: nomoncaratero maaroni picoacaaquenari. ");
INSERT INTO cniNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ipianaja aisati, ineajeitaqueri iroamerepee, imaajeitaque: oshequi aajeitaqueri ivochoquine. ");
INSERT INTO cniNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ari ipianaja aisati, iquenquetsatacaajiri. Irosati yapiitaque icantaqueriri incaranqui. ");
INSERT INTO cniNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ipiashitajari aisati iroamere, icantiri: —¿Maajimpimpa aisati? Meeca moncarataca. Noponeaca inquitequi, natiritapaaque; meeca icantacoventaquena, meeca irayena caari cameetsajeitatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pintinaajeitanaje, tsame ajataje. Jeri, yocatapaaque aacantenaneri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Irosati ipocashitantapaacari Jorashi, yora yoamevetari Jesoshi: ijivajeitapaaqueri oshequi atiri. Yamayetaque ivesamentopee, ivasamentopee, maaroni. Ipocajeitapaaque aisati yora jivatacaajeitiriri saserotepee aisati itsipapee savicacantajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Icamantanirotitacari Jorashi incaranqui: —Nonintavorotapaaqueri Jesoshi, piojeitanteariri. Impoijiquea pajiricapeeri avirori. ");
INSERT INTO cniNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Irosati ijatashitantacari, icantapaaqueri: —¿Ainirompi, oametanari? Inintavoronirotapaaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Icantavaqueri Jesoshi: —Noshaninca, ¿paita pipocashitiri aca? Irosati ipocashijeitantapaacariri maaroni, yaajeitapaaqueri, tapi. ");
INSERT INTO cniNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Irosati yaantacaro itsipa iroamere ivesamento iriori, ipesavetacari inampire ivincatsarite saserote. Ipeshitaqueri iyempita. ");
INSERT INTO cniNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Icantiri Jesoshi: —Poajero pivesamento, ipiatimpicari. Tempa impesheetajeri iriori pesantapinitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tempa piote noncoaquericame, noncanterime Apa, impoiji intianquenarime oshequi catsini inampire inquisacoventename. ");
INSERT INTO cniNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Iro cantaincha inquisacoventenaricame, iroavisacotenaricame, eiro nomoncaratirome ocamantacotitananiri Sanquenarentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Impoiji icantajeitiri yora pocashijeitaqueriri: —¿Paita pamashitantanari pivesamento aisati pivasamento? ¿Narompa coshinti piquisantanari? Pineapinitana maaroni quitaiteriqui anta ivancoqui Tasorentsi, noametanti; ja, payenaniqueti. ");
INSERT INTO cniNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Iro cantaincha irootaque paajeitantaquenari omoncaratantajeari oquenquetsatacotitananiri Sanquenarentsi. Irosati narori notsaroantanaca, noshianaca. Aisati iquempejeitaca maaroni iroamerepee. ");
INSERT INTO cniNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ari yayeetanaqueri Jesoshi anta ivancoqui Caijashi: yora ivincatsarite saserotepee. Yapatojeitanta yora oametantirori Sanquenarentsi aisati yora savicacantajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ari impoitanaji Petero anta otsapiqui iipatsite saserote. Iqueapaaquero otantacota quipatsi, isaviquimotapaaqueri yora soraropee. Yamenapaaque iriotanteari jaocarica incanteeteriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ari yora oametavacaajeitainchari icoayetanaque tseeyacotearineri Jesoshi, ontimanteari iroacantanteariri. ");
INSERT INTO cniNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ari itimi oshequi tseeyacovetacariri, iro cantaincha tecatsi incanteri iroacanteri. Impoiji ipoqui apite pashini tseeyacotapaariri, ");
INSERT INTO cniNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","icantapaaque iriori: —Icanti yoca: “Nontireajero ivanco Tasorentsi: oncarate mava quitaiteri novetsicajero aisati”. ");
INSERT INTO cniNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ari icatianaca ivincatsarite saserote, icantiri Jesoshi: —¿Tecatsimpa pincanteri avirori? ¿Paita ojita oca icantacojeitaquempiri? ");
INSERT INTO cniNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Imajeretaque Jesoshi, te iranqueriji. Yapiitajiri aisati: —Tempa ineaquempi Tasorentsi, yora aneasanotatsiri. Pincamantasanotena: ¿avirompa Quirishito, Itomi Tasorentsi? ");
INSERT INTO cniNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yacanaqueri: —Narotaque. Noponeaca inquitequi, natiritapaaque. Coajica pineajena nosavique iracosanoriqui Tasorentsisanori, aisati pineavajena nonquenapaaje mencoriqui, nompiaje aca quipatsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Irosati iquisantanacari saserote, irosati itsereantanacaro iitsaare. Icanti: —Pinquemaniroteriqueti: ijitasorentsitacateemi. ¿Paitampa acoantacari intime pashini camantacoterineri? ");
INSERT INTO cniNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Paita piquenqueshirejeitiri avirorijei? ¿Jaoca ancanteriri? Yacajeitanaqueri: —Cameetsa incame. ");
INSERT INTO cniNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Impoiji iquitiojavorojeitaqueri ivoroqui. Impoiji icapojanajeitaqueri, aisati ipasanajeitaqueri, tac, tac, tac; ");
INSERT INTO cniNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","icantaqueri: —Quirishito, pincamantena: ¿janica capojanataquempiri? ");
INSERT INTO cniNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ainiroquera isaviqui Petero anta saiteriqui. Oneaqueri nampirentsi, ocantiri: —Aviro oijatiriri Jesoshi, yora carireasati. ");
INSERT INTO cniNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Icanti Petero: —Te nioteji paitarica picantaquenari. ");
INSERT INTO cniNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ari ijavetanaca anta iqueavetapaaca, otimi pashini nampirentsi, oneavaqueri iroori, ocanti: —Jeri yoca oijatiriri Jesoshi, yora nasaretesati. ");
INSERT INTO cniNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Icantanaquero: —Te nioteriji yoca picantaquenari. Terica ontampaticate oca nocantaquempiri, nocoaque iroasanquetenata Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Impoiji capichaji, jeri pashini cantapairiri: —Queario, avirotaque oijatiriri: noquemaquero pineanataque, avirotaque carireasati. ");
INSERT INTO cniNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yacanaqueri: —Teve, te nioteriji yora shirampari picantaqueri. Ioti Tasorentsi queario nocantaquempiri. Terica ontampaticate nocantaquempiri, nocoaque iroasanquetenata Tasorentsi. Irosati ineantanaca teapa. ");
INSERT INTO cniNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ari iquenqueshiretanaquero icantaqueriri Jesoshi: “Eirotsitarica ineaji teapa, oncarate mava pincante: ‘Te nioteriji Jesoshi’ ”. Ari isoquijanaji, iraapaaca jii, jii. ");
INSERT INTO cniNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ari iroaquera oquitaitetamani, yoametavacaajeitaca yora jivatacaajeitiriri saserotepee aisati savicacaajeitantatsiri: —¿Jaoca ancanteriri meeca Jesoshi avacantanteariri? ");
INSERT INTO cniNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ari yoisoyeetaqueri, yayeetanaqueri anta itiminta pincatsari, yora pajitachari Pirato. ");
INSERT INTO cniNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yora Jorashi, yora aacantiriri Jesoshi, iotaque yoacantashitacari Jesoshi. Oshequi iquenqueshiretanaca, irosati yoipiantajantanari yora 30 imentaqui: yora peratatatsiri. Icantapaaqueri yora jivatacaajeitiriri saserote aisati yora savicacaajeitantatsiri: ");
INSERT INTO cniNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Jeriniro piirequite. Te oncameetsateji oca nantaqueri. Tecatsi irante Jesoshi, naacantashitacari. Yacajeitanaqueri: —Jm, aviroyea. ");
INSERT INTO cniNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ari ipishoncanajiniri quirequi anta ivancoqui Tasorentsi, iquenaitaji, ipianaja. Impoiji ijatanaque, ishiticaja irisati. ");
INSERT INTO cniNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yora jivatacaajeitiriri saserote yaajeitajiri quirequi, icantajeiti: —Te oncameetsateji aca anquempoyeajeri yoca quirequica. Tempa iriotaque apinataqueriri iroacantanteariri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ari yoametavacaajeitaca: —¿Jaoca ancantajeriri quirequica? Icanti: —Tsame amanantero quipatsi antijanteariri camatsiri caari aneapinijeiti. Iro yamanantaqueri quipatsi ora yaapiniyeetiri quipatsi yovetsiqueetiri coviti. ");
INSERT INTO cniNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Meeca ipajiyeetaquero oca quipatsi: “Ivinaro Jesoshi yoacantantacariri”. ");
INSERT INTO cniNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Imoncarataquero isanquenatitacaniri Jeremiashi: “Irayeri 30 imentaqui quirequi, yovetsicanteetariri perata. Iriotaque ivinaro iraacantanteariri Quirishito. Eiro ishequititsi quirequi impinatantaveteariri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Iriotaque iramanantantearori quipatsi anta yaapiniyeetiri quipatsi yovetsiqueetiri coviti. Iriotaque Avincatsarite canterineri iramanantero quipatsi”. Irootaque isanquenataqueniri Jeremiashini. ");
INSERT INTO cniNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ari icatiimotacari Jesoshi yora pincatsari pajitachari Pirato. Isampitiri iriori: —¿Avirompa ivincatsarite joriopee? Yacanaqueri: —Je, narotaque. ");
INSERT INTO cniNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Impoiji iquishimanataqueri yora jivatacaajeitiriri saserotepee aisati yora savicacantantatsiri, iro cantaincha tecatsi incante iriori, imajeretashitaca. ");
INSERT INTO cniNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Isampitiri Pirato: —¿Tempa pinquemeri icantacotaquempiri? ¿Paita caari pineanatanta avirori? ");
INSERT INTO cniNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tecatsi incante, te impiateariji. Ari yoanaqueri cavaco pincatsari, oshequi iquenqueshireanaca. ");
INSERT INTO cniNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ari maaroni osarintsi, ariorica omoncarataca Yavisantaniri, yora Pirato isampitapinijeitaqueri savicajeitatsiri: “Timatsi oshequi pishaninca anta caravosoqui. ¿Picoaquempa noisoquijajempiri aparoni?” Aitaque icantapinita maaroni quitaiteri Yavisantaniri, yoimisoquijapinitiri aparoni, janicarica icoiri joriopee. ");
INSERT INTO cniNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Itimi caravosoqui meeca shirampari iquemacojeitaqueri joriopee, ipajita Varavashi: oshequi yoanti irinti. ");
INSERT INTO cniNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ari meeca yapatojeitaca oshequi atiri, irootaque icantajeitantacariri: —Piojeiti nametaca noimisoquijimpiri aparoni timatsiri caravosoqui. ¿Janicampa picoajeitiri noimisoquijajeitempiri meeca? ¿Iriompa Varavashi? Terica pincoyeriji Varavashi, ¿irioricampa picoajeitaque noimpacajempiri Jesoshica, yoca picantiri Quirishito? ");
INSERT INTO cniNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Iotaque Pirato oshequi iquisashitacari Jesoshi yora jivatacantantatsiri, te incoacaajeiteriji ashanincapee inquemisantajeiteri. Ijivetaca Pirato incantajeiterime ashaninca: “Nocoaque poimpacajenari Jesoshi”. ");
INSERT INTO cniNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aisati incaranqui otianquiniri ijina camantiriri: “Ocanti pijina: ‘Eiro poacantiritsi Jesoshi, icameetsatasanotaque. Nomishitacari incaranqui, oshequi noquenqueshiretacotaqueri’ ”. Irootaque caari icoantaveta iroacanterime. ");
INSERT INTO cniNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Iro cantaincha yora jivatacaajeitiriri ashanincapee icantajeitiri: —Pincantajeiteri: “Poimisoquijajeri Varavashi, irinti Jesoshi, pimpajacotacanteri”. Icantajeitaqueri: —Aviroyeampa, paitarica picoaqueri avirori. ");
INSERT INTO cniNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ari yapiitajiri Pirato, isampijeitiri: —Jeri icarataque apite: ¿janicampa picoaqueri noimpacajempiri? Icantajeitaqueri: —Varavashi. ");
INSERT INTO cniNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Isampijeitiri: —¿Jaoca noncanteriri Jesoshica: yoca ipajiyeetiri Quirishito? Yacajeitanaqueri: —Pimpajacotacanteri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Isampijeivetari: —¿Paitampa yantaqueri nompajacotacantanteariri? Aiquero icajemajeitanaitiiri: —Pimpajacotacanteri. Pimpajacotacanteri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ari iotanaque yatsipetashitaca isampinajeivetacari, aisati oshequi iquisajeitanaca atiripee. Icantiri inampire: —Pamacotenarota nija. Yamacotaqueneri, impoiji iquivacotaca, iriotanteari atiri te incoaveteaji iroacanteri Jesoshi. Ineajeitaqueri atiripee, aisati icantajeitiri: —Te naro coatsine noacanteri. Picoajeitaquerica avinti, aviroyeampa. ");
INSERT INTO cniNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yacajeitanaqueri: —Nocoasanojeitaque, tempa narojeitaque cantaquempiri. Inquishenata nainti Tasorentsi, aisati ocameetsati inquisheri notomipee narori. ");
INSERT INTO cniNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ari yoisoquijajiri Pirato Varavashi. Icantiri soraro: —Paanajeri Jesoshica, pimpasateri, impoiji pimpajacoteri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ari yaanaqueri soraro Jesoshi anta ivancoqui pincatsari, icajemajeitaqueri itsipapee soraro. ");
INSERT INTO cniNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ari isapocaqueri Jesoshi iitsaare, impoiji iquitsaatiri otsipa quitsaarentsi, quiraanirori. ");
INSERT INTO cniNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yovetsicaqueneri iramatseere totsequi, yamatseetaqueri. Aisati ipaqueri chacopi, icantiri: —Pajiriquero opirico chacopi. Yora pincatsari peerani iquitsaatapinitaro quiraanirori, yamatseetaro iramatseere pinatasanotachari, aisati yajiricapinitiro iotiquiro cameetsari. Ari itiyeroashinirojeitacari soraropee Jesoshi, ipincatsatamempeacari, ishirontimentajeitari, icantajeitiri: —Aviro, novincatsarite. ¿Pipincatsariventajeitirimpa maaroni joriopee? Iji, iji, iji, iji. ");
INSERT INTO cniNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Iquitiojajeitaqueri, impoiji yaapitsatajiri chacopi, ipasatantajari iitoqui. ");
INSERT INTO cniNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Oshequi yapiinataqueri ishirontimentanatacari, iji, iji, iji. Impoiji isapocajiri quitioncanirori, iquitsaatajiri aisati iitsaaresanori. Yaajeitanaqueri impajacoteri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ari yaajeitanaqueri Jesoshi impajacotanteariri. Anta avotsiqui itonquiotavacari shirenesati, ipajita Shimo. Iperanatavacari soraro: —Jero oca coroshica, paanaqueneri yoca. Ari yaanaqueneri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yareejeitapaaca Coricotaqui. Iro apajitiro aneanequi: iitontsini. ");
INSERT INTO cniNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ari ipeevetacari Jesoshi ovaja, oconoajata quepishijatatsiri. Ineantavetavacaro, te incoyeji irirero. ");
INSERT INTO cniNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ari ipajacojeitaqueri soraropee coroshiqui, impoiji ineatsajeitaca iriojeitanteari janica aajeroneri iitsaare. ");
INSERT INTO cniNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Impoiji isavicajeitaque, yamenajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Isanquenajeitaquero paperiqui: “Jerica Jesoshi. Iriotaque ivincatsarite joriopee”. Impoiji ipajacotaquero coroshiqui, ivatitotacaro Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Impoiji aisati ipajacojeitaqueri apite coshinti: aparo yoatiacotaqueri iracosanoriqui Jesoshi, irio pashini yoatiacotaqueri irampatequi. ");
INSERT INTO cniNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ari ainiro avisayetatsiri avotsiqui, ishirontimentajeitacari Jesoshi. Itecainajeitaca, ");
INSERT INTO cniNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ishirontajeitaca, iji, iji, iji. Icantajeitiri: —Pintireerome ivanco Tasorentsi, aisati oncarate mava quitaiteri povetsicajerome aisati. Jentsite, poavisacotajea avisati. Avirorica itomi Tasorentsi, jentsite paniireashitajea. ");
INSERT INTO cniNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aisati iquempejeitaca yora jivatacaajeitiriri saserotepee, yora oametantirori Sanquenarentsi, jeri yora savicacantatsiri: ishirontimentajeitacari. Icantajeiti: ");
INSERT INTO cniNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ijitashiniroveitani yoavisacojeitirini ashanincapee, iro cantaincha meeca te irimatajeaji iriori iroavisacotajea irisati. Jentsite, amenavaqueritsita: iriorica avincatsarite, iraniireapaaje. Ariorica iraniireapaaje, ari ampincatsatanaqueri arori. Iji, iji, iji. ");
INSERT INTO cniNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ari ipincatsarivetari Tasorentsi iriori: ariorica iroavisacoteri irinti. Aamayea ari incoaque iroavisacoteri itomi, tempa icanti meeca yoca: “Narotaque Itomi Tasorentsi”. Iji, iji, iji. ");
INSERT INTO cniNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aisati iquempejeitaca yora coshitantatsiri ipajacoyeetaqueri: ishirontajeitaca iriori. ");
INSERT INTO cniNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ari icarataque catsirincaiteri tampatica, omapocanaca otsiteniiteanaque, otsimoirotanaque: irosati ishaaviniji. ");
INSERT INTO cniNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ari ishaaviniji antearojenca icanti Jesoshi: —Eri, Eri, arama savacatani. Iro acantiri aneanequi: “Apa Tasorentsi, ¿paita pojocantanari?” ");
INSERT INTO cniNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iquemantacariri yora savicajeitaintsiri, icanti: —Pinquemerite, icajemaqueri Iriashi. ");
INSERT INTO cniNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ari ishianaca aparoni, yovincaquero pijoncashincanari ovajaqui quepishijari. Isataaquero inchaquiiqui, ijicotacovetacanari Jesoshi, irantsimicantearorime, ");
INSERT INTO cniNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","iro cantaincha icantiri itsipapee: —Eiro pantiritsi: tsame amenavaquerita, impocashiteririca Iriashi iroavisacoteri. Iji, iji, iji. ");
INSERT INTO cniNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ari icajemanaji aisati Jesoshi, impoiji icamanaque, torein. ");
INSERT INTO cniNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Icamantacari Jesoshi, otsereanaque oticaashiro ivanco Tasorentsi: intanaca jenoqui otsereanaque, tsererere, irosati ishaaviji. Aisati onicanaca quipatsi, nica, nica, nica; ocotareanaque antearo mapipee. ");
INSERT INTO cniNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yashitareacotanaca tijaari, itinaajeitanaja oshequi quemisantatsiri, tinare. ");
INSERT INTO cniNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Impoiji, itinaantajari Jesoshi, ijajeitanaque yora itsipapee tinaajeitajanchari Jerosarequi. Ineajeitaqueri oshequi atiri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ari yora capitano aisati yora soraropee ineajeitaquero onicanaca quipatsi, aisati ineajeitaqueri yora tinaajeitajanchari, ineaquero otsiteniitanaque, maaroni. Impoiji yoajeitanaque cavaco, aisati icantajeiti: —Queariotaque: iriotaque Itomi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Otimi anta nijanteaji oshequi tsinanepee, amenajeitaqueri Jesoshi. Iroojeitaque oijaveitariniri, oponeajeitaca Carireaqui. Quiso oapinitirini, opapinitirini yoari. ");
INSERT INTO cniNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ocarajeitaquero Maria maquitarasato; jero otsipa Maria: ora iriniro Santiaco aisati Jose; jero aisati iriniro itsipa Santiaco aisati Joa. Ari oneajeitaqueri Jesoshi, icamanaque. ");
INSERT INTO cniNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ari ishavijiiteanaque. Itimi aparoni iroamereni Jesoshi, ipajita Jose. Iponeaca iriori Arimateaqui; ashitaarantincari ini. ");
INSERT INTO cniNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ijatashitaqueri Pirato, icantapaaqueri: —Camaque Jesoshi. Nocoaque pishinetenari naanajeri noiminquiajeri omoroqui: onta yovetsiqueetiniriri camatsiri. Ari icantiri iriori soraro: —Pishineteri yoca iraanajeri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ari ijataque, yaanaqueri, yampinaicacotaqueri tocoyaqui caari pitsitatsi. ");
INSERT INTO cniNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Impoiji yoaqueri omoroqui mapi iroaquera imoqueetiro. Itivironquiro antearo mapi omoroqui, yashitacotantacariri. Impoiji ijatanaji Jose. ");
INSERT INTO cniNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ainiro osavicaque anta Maria maquitarasato aisati otsipa Maria. Oneacotaqueri yoiminqueaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Iro quitaiteri ipajacotantariri Jesoshi opajita Yavisantaniri. Oquitaitetamanaque ijatashijeitaqueri Pirato yora jivatacaajeitiriri saserote aisati yora variseopee. ");
INSERT INTO cniNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Icantajeitapaaqueri: —Novincatsarite, noquemajeitaqueri icantaqueri chapinqui yora amatavitantatsiri: “Noncamaque, impoiji oncarataque quitaiteri mava, ari nontinaanaje”. ");
INSERT INTO cniNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nocoaque pintianque soraro meeca irishentasanotero omoro anta yoiminqueaquerinta. Iramenasanotero irosati omoncaratanteari mava quitaiteri. Ijatashitiricari iroamereni, yaanajiricari. Impoiji icantajeitiricari ashanincapee: “Tinaanaja inaji Jesoshi”. Peerani oshequi yamatavitantini iriori, iro cantaincha ariorica iraanajeri, yamatavitasanojeitiricari iroamereni ashanincapee, icanticari: “Tinaanaja inaji Jesoshi”. ");
INSERT INTO cniNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Icantiri Pirato: —Jeri yoca soraropee, pijajeite pamenasanojeitero. ");
INSERT INTO cniNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Irosati ijajeitantanaca, yashitacotasanotaqueri, impoiji ishentajeitiro soraro. ");
INSERT INTO cniNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ari avisanaque quitaiteri imaoreajeitantari, meeca otomincotapaaque. Tsiteniquera ojatamanaque Maria maquitarasato, aisati otsipataro omariaroronte. Ojataque amenamanajero omoro yoyeetaquerinta Jesoshini. ");
INSERT INTO cniNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Omapocanaca antearo onicanaca quipatsi aisati. Jeri aisati itimi inampire Avincatsarite: iponeanaca inquitequi, ipocaque itivironcapaaquero mapi, irootaque isavicantapaacari. ");
INSERT INTO cniNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Oshequi ishipaquireapaaque, iquempetacaro iporequi. Oquitamarotasanotaque iitsaare, oquempetacaro sharaca. ");
INSERT INTO cniNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Oshequi catsini itsaroacaajeitavacari soraropee, te irimatajeaji irishevatajea: iquempevetanaca incamaquerica. ");
INSERT INTO cniNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ari icantiro tsinane: —Eiro pitsaroitsi avinti. Niotaque irio pipocashiveta Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Te aneajeriji meeca, tinaanaja ini. Tempa icamantitaquempini. Caatanaque, pamenero aca yoyeevetacarica. ");
INSERT INTO cniNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Impoiji pishintsitanaje pijatanaje pincamantajeitapeeri iroamere: “Tinaanaja Avincatsarite, irijivajeitanaquempi Carireaqui. Aitaque pineajeitapaajeriri anta”. Irootaque nocamantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ari oasanotanaque cavaco, aisati oshequi oquimoshiretanaque. Ojatanaque, oshiashitanacari iroamere, oncamanteri. ");
INSERT INTO cniNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nianqui imapocaquero Jesoshi, ivetsatacaro. Ojatashitaqueri, otiyeroashitacari, ajiricapairi iitiqui. Oshequi opincatsatapaacari. ");
INSERT INTO cniNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Impoiji icantaquero: —Eiro pitsaroitsi. Pijajeite meeca pincamantajeiteri noamereni irijajeiteta anta Carireaqui. Aitaque irineajeitapaajenari anta. ");
INSERT INTO cniNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ari ojatashitaqueri iroamereni tsinane. Irinti yora soraro shentavetarori omoro ijataarantaji nampitsiqui, icamantajeitapairi yora jivatacaajeitiriri saserotepee. ");
INSERT INTO cniNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yapatojeitiri iriori yora savicacantantatsiri. Yoametavacaajeitaca: —¿Jaoca ancanterori meeca amanacotanteariri? Ari icajemajeitaqueri soraro, icantajeitaqueri: —Jeri yoca quirequica, nocoi nompinatempi. ");
INSERT INTO cniNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Pincantashijeiteari atiripee: “Nomaajeitaque nianquiiteni. Ipocaque iroamereni Jesoshi, yaanajiri”. ");
INSERT INTO cniNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ariorica inquemacovetaquempi yora pincatsari, pincantaque: “Nomaaque”, noncamanteri narori: “Eiro piquishiritsi soraropee. Te irimayeji. Narotaque cantaqueriri: ‘Pintseeya’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ari yaajeitaqueri quirequi, icamantajeitaqueri atiri: “Nomaajeitaque, impoiji yaajeitajiri iroamereni Jesoshi”. Ainirotatsi meeca icantajeiti joriopee meeca. ");
INSERT INTO cniNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ari nojatanaque Carireaqui, notsipajeitacari itsipapee iroamere. Aparoni peaincha, yora Jorashi. Nojajeitanaque toncaariqui icantaquenari chapinqui Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Noneajeitapaajiri, nopincatsajeitapaajiri. Iro cantaincha aparopee tseencavetapaincha. ");
INSERT INTO cniNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ari ipocashijeitana Jesoshi, icantaquena: —Icantitaquenani Apa peerani: “Pimpincatsaritasanote meeca aca inquitequi aisati pimpincatsariventasanojeiteri maaroni quipatsisati”. ");
INSERT INTO cniNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Irootaque nocantantimpiri: pijajeite maaroni nampitsipeequi, pinquemisantacaajeiteri maaroni atiripee, pintsoteaqueri maaroni. Ariorica inquemisantajeitaque, pivaotisajeiteri: irootaque icoacaaqueriri Apa, aisati nocoacaajeitaqueriri narori, aisati ocoacaajeitaqueriri Ishire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pincamantajeiteri atiri irimajeitero maaroni nocamantaquempiri. Quiso noajeitanaquempi, noncanteani, irosati nompocantajeari nompincatsaritantapaajeari. Ari ocarati. Narotaque sanquenatirori: Mateo");
INSERT INTO cniNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Meeca noncamantempiro cameetsatatsiri. Noncamantempi yoavisacotanti Jesoquirishito. Tempa iriotaque itomi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Peerani isanquenatini camantantatsiniri pajiveitachaniri Isayashi. Jero oca isanquenatiniri: “Icantiri Tasorentsi itomi: ‘Pinquemena, notiomi. Nontianqueri quenquetsatacotempineri, irijivatanaquempi. Incantajeiteri atiri: Paamaajeiteari Quirishito, pincameetsashirejeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Inquenquetsatacaajeiteri ishaninca caaraiteriqui. Incantajeiteri: Pincameetsashirejeitanaque oncanteata ariorica impoque Avincatsarite, irineacameetsajeitantapeempiri’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ari moncaratapaaca icantiniri peerani Isayashini. Yareetapaaca caaraiteriqui Joa, yora vaotisatantatsiri. Icantajeitaqueri ishaninca: —Pinquenqueshireempa, eiro piquempetajatsi peerani. Ariorica pojocasanojeitajero pantajeiveitaniri, ari novaotisajeitaquempi, impoiji iriojeitanaque atiri icavintsaajeitaquempi Tasorentsi, eiro iquenqueshireacotajimpirotsi pantaveitaniri. ");
INSERT INTO cniNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ari ijatashijeitaqueri maaroni joreasati, aisati maaroni jerosaresati, icamantajeitapairi: —Ainiro nantayetiri caari cameetsatatsi. Nocoaque navisacotaje. Ari ivaotisajeitavaqueri Joa Joriraniqui. ");
INSERT INTO cniNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Irio iquitsaatari tijachari iviti cameyo. Ishiticatsaquitari meshinantsitsa. Yoapinitari quentori aisati ija pitsi. ");
INSERT INTO cniNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ari icamantapinitiri ishaninca: —Coraque impoitapeenaneri, yanaacotaquena, ipincatsaritasanoti irinti. Nopincatsatasanotaqueri catsini, narori notseencaja narosati. ");
INSERT INTO cniNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Novaotisajeitaquempi nijaqui, iro cantaincha intianquempiro irinti Ishire, ontsipajeitantempiri. ");
INSERT INTO cniNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ari pashini quitaiteri yareetapaaca Jesoshi. Iponeaca Nasaretequi, timatsiri Carireaqui. Ivaotisatavaqueri Joa Joriraniqui, ");
INSERT INTO cniNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","impoiji yaatanaji. Yamenanaque jenoqui, irosati ineantavacaro Ishire Tasorentsi. Omapocapaaca aniireashitapaaqueri, oshiaqueri sampaquiti. ");
INSERT INTO cniNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iquematiiri Tasorentsi icantiri: —Avirotaque notomi nonintasanotiri. Oshequi noquimoshireventasanotaquempi. ");
INSERT INTO cniNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Impoiji aanaqueri Ishire Tasorentsi caaraiteriqui. ");
INSERT INTO cniNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Itimaiti anta ocarataque 40 quitaiteri. Yora Satanashi ineantavetacari, irantacayerime caari cameetsatatsi. Aisati tecatsi ishaninca intsipateari, irinti timatsi covencayetatsiri, iro cantaincha intacojeitacari inampirepee Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ari pashini quitaiteri yashitacoyeetaqueri Joa caravosoqui. Impoiji ijatanaji Jesoshi Carireaqui. Icamantajeitaqueri ishaninca jaoca icanta Tasorentsi yoavisacotanti. ");
INSERT INTO cniNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Icantajeitaqueri: —Irotaintsi impincatsariventajeitajee Tasorentsi. Pinquenqueshireempa, eiro piquempetajatsi peerani: te pincameetsaveiteani. Pinquemisantajeite pavisacotantajeari. ");
INSERT INTO cniNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ari pashini quitaiteri ishiteatanacaro Jesoshi incajare timatsiri Carireaqui. Ineapaaqueri Shimo, aisati irirenti, Antirishi. Iquitsati incajarequi: aitaque icantapinita, iquitsatapinitiri shima. ");
INSERT INTO cniNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Icantapaaqueri Jesoshi: —Poijatanaquena, nocoaque pinquemisantacaapiniteri atiri. ");
INSERT INTO cniNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Irosati yojocantanacaro iitsarite, yoijatanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Capichaji yovaavetanaca aisati, ineapaaqueri Santiaco, Joa, apite: iriotaque itomipee Severeo. Isavicajeiti ivitoqui, ishiticayetiro iitsarite. ");
INSERT INTO cniNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Icajemapaaqueri, yoijajeitanaqueri. Yojocanaqueri iriri, isavicaque irinti pitotsiqui, icarajeitaqueri amitacojeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Impoiji yareetapaaja Jesoshi Caperenaoqui, icarajeitiri iroamerepee. Irootaque saavaro, imaoreajeitantari, iqueajeitapaaque pancotsiqui yapatojeitantari. Yoametantapaaque. ");
INSERT INTO cniNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yora atiripee, yoajeitanaque cavaco, icantajeiti: —Pineaqueri, cameetsa yoametantasanotaque, iotasanoti irinti. Te inquempeteariji yora oametapinijeiveteerori sanquenarentsi: te iriotasanoteji irinti. ");
INSERT INTO cniNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aisati itimi anta pancotsiqui aparoni shirampari neiriri camaari. ");
INSERT INTO cniNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Icajemacotavaqueri Jesoshi, icantavaqueri: —Niotaquempi: aviro nasaretesati, aisati aviro itomi cameetsari Tasorentsi. ¿Paita pipocashitantanari? ¿Arimpa pintsoncajeitapaaquena? ");
INSERT INTO cniNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Icantiri Jesoshi camaari: —Pimajereiteteve. Pinijantareanajeri noshaninca. ");
INSERT INTO cniNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ari yampitsiitacaanacari ashaninca, antearojenca icajemanaque, irosati inijantareantanajari camaari. ");
INSERT INTO cniNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aisati yoajeitanaque cavaco ishaninca, maaroni. Isampitavacaanaca: —¿Pineaquerompa imataqueri? Iroaquera aquemaquero oca yoametaqueeri. Aisati imataqueri camaari, itiancaqueri: itsaroacaitacariteemi. ");
INSERT INTO cniNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Irosati iquenquetsatacotantajeitacari maaroni carireasati. ");
INSERT INTO cniNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ari iponeajeitajari pancotsiqui yapatojeitantari, ijajeitanaque ivancoqui Shimo, jeri Antirishi. Yoijajeitanaqueri Santiaco aisati Joa. ");
INSERT INTO cniNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Icamantiri Jesoshi: —Ojoquiitaca irairo Shimo, aaquero catsiirentsi. Jero onta nariainchari. ");
INSERT INTO cniNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ari ijatashitanaquero, yacatsavacotapaaquero, yoisavicapaajiro. Irosati opeantanaja ovatsiire, irosati opajeitantacari iroyeari. ");
INSERT INTO cniNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Iqueanaji catsirincaiteri, irotanaintsi ontsitenijencaiteanaje, yamayetaqueneri Jesoshi maaroni mantsiayetatsiri, aisati maaroni yatajeaoncayetiri camaari. ");
INSERT INTO cniNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Maaroni nampitsiquiniri yapatojeitapaaca omoroqui pancotsi. ");
INSERT INTO cniNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Isavicajeitapaaque maaroni mantsiayetatsiri, onashiyetaca imantsiarepee. Yoavisacojeitajiri. Aisati icantaqueri camaari: —Pinijantareajeitanajeri yora patajeaonquiri, aisati pimajerejeite. Yora camaari, iojeitaqueri Tasorentsi ini Jesoshi, irootaque caari icoanta Jesoshi incamanteri atiri. ");
INSERT INTO cniNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Oquitaitetanaque, tsiteniquera itinaamanaja Jesoshi. Ijatamanaque anta tecatsi timatsine, iquenquetsatacairi iriri. ");
INSERT INTO cniNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Icoacoayetajiri Shimo aisati itsipajeitari. ");
INSERT INTO cniNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ineantapaajariri, icantapaaqueri: —Icoacoajeitaquempi maaroni ashaninca. ");
INSERT INTO cniNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ari icantavaqueri iriori: —Ari inajini. Tsame avaanajea otsipapeequi nampitsi. Aitaque anta nonquenquetsatacaajeiteri itsipapee atiri, irootaque nopocantacari quipatsiquica. ");
INSERT INTO cniNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iquenaquenayetanaque, itsoteajeitaquero nampitsipee anta Carireaqui. Iquenquetsatacaapinitaqueri ishaninca anta yapatotapinijeitanta, yoavisacojeitaqueri maaroni neiriri camaari. ");
INSERT INTO cniNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pashini quitaiteri ijatashitaqueri patsaatsiri, icantapaaqueri: —Tempa aviro pincatsari, pincavintsayena. Ainiro pitasorenca: pinintirica poavisacotajena, ari pimataquero. ");
INSERT INTO cniNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Oshequi icavintsaasanotavaqueri. Ari yacotashitavaqueri, ipamitavaqueri. Icantavaqueri: —Je, noninti: aitaque pavisacotaje. ");
INSERT INTO cniNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Irosati opeantanaja ivatsaaro, yavisacotanaji. ");
INSERT INTO cniNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Itiancajiri, icantasanotiri: ");
INSERT INTO cniNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Noncantempi: eiro picamantayetiritsi itsipapee, irinti pijatashiteri saserote. Pinijaapaajeri pavisacotaji. Pimoncaratero icantiniri Moishishini: poyeneri Tasorentsi pivira iriotanteari pishaninca pavisacotaji. ");
INSERT INTO cniNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ari ijatanaque, iro cantaincha icamantacoyetaquero, yovaraaquero. Iotacojeitaqueri Jesoshi, irootaque caari ijatanta nampitsiqui. Itimaiti anta ocaraiteti. Ijatashijeitaqueri atiri poneayetachari otsipapeequi nampitsi. ");
INSERT INTO cniNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pashini quitaiteri ipianaja Jesoshi Caperenaoqui. Iquemacojeitajiri areetaja ivancoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yapatojeitaca oshequi atiri, ijaapaaca pancotsiqui. Tecatsi inquenapee pashini inquempejitantapeemparori omoro. Iquenquetsatacaajeitaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ari icompitacotapaaqueri choritatsiri. Icarati amiriri itsipasati. ");
INSERT INTO cniNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tecatsi inquempejitantapeempariri Jesoshi, yojocaajeitavaqueri atiripee. Ari yataitacaanaqueri otataroqui pancotsi. Itatareapaaquero, itampaticataquero inaquenta Jesoshi. Imataquero omoro, ari yoaniitacotaqueri inareantariqui. ");
INSERT INTO cniNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iotavaqueri Jesoshi ishirejeitacari, irootaque icantantacariri: —Noshaninca, ainiro pantayetiri, iro cantaincha eiro noasanquetimentimpirotsi, aitaque noavisacotajempi. ");
INSERT INTO cniNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ainiro anta isavicaiti oametantirori sanquenarentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Icantashiretaque iriori: —¿Paita icantashinirotantarori oca? Ijitasorentsinirotacateemi. ¿Jaoca incanteriri iroavisacotanteariri? Tempa apaniro yoavisacotanti irinti Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ioshiretashitaca Jesoshi icantashiretaqueri, icantiri: —¿Paita picantashiretantari? ");
INSERT INTO cniNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Paita pomerentsitasanotachari? ¿Pomerentsinimpa nocantiriri yoca choritatsiri: “Eiro noasanquetimpitsi, irointi noavisacotajempi”? Te ompomerentsiveteaji: eiro piojeititsi nomaterorica. Irointi pomerentsivetacha noncanteri yoca: “Pincatianaje, paajero pinariantavetari, paniitanaje”. Tempa onconijatasanotanaque nomaterorica. ");
INSERT INTO cniNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aca quipatsiquica nocavintsaajeitiri caari cameetsatatsi, aisati noavisacojeitaqueri. Nocoaque piojeite ainiro notasorenca noavisacotanteariri. Ari icantaqueri choritatsiri: ");
INSERT INTO cniNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Nocantimpi, pincatianaje, paanajero pinariantaniri, pijataje pivancoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Irosati icatiantanaja, yaanajiro inariantaniri, isoquijanaji. Ineajeitavajiri ishaninca, yoajeitanaque cavaco. Icantajeitanaque: —Tempa icameetsatasanoti Tasorentsi, te aneapiniteroji peerani quempetarori oca. ");
INSERT INTO cniNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ipianaja Jesoshi aisati otsapijaqui incajare. Yapatotashijeitapaajari aisati atiri, yoametavajiri. ");
INSERT INTO cniNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Impoiji yovaanaja aisati. Ineapaaqueri Irevi, yora itomi Arijeo, isavicaiti pancotsiqui yapatotapinitiri quirequi: yapatotapinijeitiniri oromasati. Icantapaaqueri: —Tsame, poijatanaquena. —Ja, tsamequeti. Ari icatianaca, yoijatanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","16","Ari ijajeitanaque ivancoqui Irevi. Yoacaajeitapaacari oshequi oijajeitiriri Jesoshi, iroamere, apatotapinitiriri quirequi, maaroni. Jeri aisati yoacaacari caari cameetsayetatsi. Yareejeitapaaca oametantirori sanquenarentsi, variseo ini. Ineacotapaaqueri Jesoshi yoimojeitacari caari cameetsayetatsi. Isampitapaaqueri iroamere: —¿Paita itsipajeitantariri yocapee, yoajeita? Te incameetsajeiteji. ");
INSERT INTO cniNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ari iquemavaqueri iriori Jesoshi, icantiri: —Yora caari mantsiatatsine te incoyeji aavinterineri, irintiquea mantsiatatsiri. Te iro nompocantea noncajemeri cameetsatatsiri, irintiquea caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ari itijeita iroamerepee Joa aisati iroamerepee variseo. Yora atiri ipocashitiri Jesoshi, icantapaaqueri: —Jeri meeca itijeita iroamerepee Joa, aisati iquempejeita iroamerepee variseo. ¿Paita caari ititanta poamerepee avirori? ");
INSERT INTO cniNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ari icantavaqueri Jesoshi: —Oquempetaca ariorica iraye shirampari ijina, incajemajeiteri ishaninca inquimoshireventajeiteri. Ariorica irareejeitapeempa, ¿arimpa intijeitapeempa iriori? Eiro. Tempa iriveshireimentapeempari. Pineaquero, meeca nocarajeitiri noamerepee: ¿paita nontitacanteariri? ");
INSERT INTO cniNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aisati, ariorica irojocajeitanajeri ishaninca aatsiri ijina, impoijiniquea intijeitanaquea. Aisati coajica, nojocanajeririca noamerepee, iroashiretacojeitanaquena, irosati intijeitantanaquea. ");
INSERT INTO cniNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Tempa ajacapinitiro quitsaarentsitsara, irootaque oshiricamaotantari. Impoiji, te oncameetsateji impataqueetero nianqui iroaquerari: tequera oshiricamaoteji irointi. Impataqueeterome, impoiji ariorica inquiveetajerome aisati, oshiricamaotanaqueme iroori iroaquerari, antsiviacaaquerome maatsarantsi. Impoiji ontsereacaaquero iroaquerari. ");
INSERT INTO cniNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ariorica ampeantantajearime pearentsi iroaquerajari peesatitatsiri imeshina, tempa ari intapianaqueame, intoncanaqueme. Aitaque intsereanaqueme, aisati amparajatanaqueame iroaquerajari, chararara. Tempa apeantantapinitaro iroaquerajari imeshinaqui iroaquerari. Pineaquero: iroaquerari oca noamejeitimpiri, te oncameetsateji onconoyearo ora yoametapinijeitimpiniri intaroniri. ");
INSERT INTO cniNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ari pashini saavaro iquenanaque Jesoshi panquirentsiqui, itsipajeitari iroamerepee. Ari nianqui yaviitapairo iroamere oitsoqui tirico, itaquireiro otaqui, yoajeitaro oitsoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ari icantiri variseo: —Paitateemi yaviitantarori oitsoqui, itaquireitantacaro quitaiteri amaoreantari. Te oncameetsateji. ¿Paita yantantarori? ");
INSERT INTO cniNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ari yacanaqueri Jesoshi: —¿Tempa pinquenqueshireeroji sanquenarentsi quenquetsatacotiriri peerani Iravirini? Te ontimeji iroyeari, aaqueri itashe, aisati itsipajeitari. ");
INSERT INTO cniNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ainiro onaveitani tanta yovetsiqueetiniriri Tasorentsi: te irishineyeeteriji iroajeitearo atiri, apaniro yoaro saserote, irinti. Iro cantaincha aavetacari itashe Iravirini. Ijatashitiri Aviatara, yora ivincatsarite saserote, icantiri: “Notasheajeitaque. Tecatsi noajeiteari”. Ari ipavaqueri tanta: “Jero oca, poyea”. Ari yoacaro, aisati yoacaajeitacari itsipajeitari. Caari inajeiti saserote, iro cantaincha te irininteji Tasorentsi iroashinoncaajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pamene, yovetsiquiniri Tasorentsi atiri quitaiteri imaoreajeitantari. Te iro irovetsicanteanari atiri irineapincatsatearo quitaiteri. ");
INSERT INTO cniNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Narotaque cantacaantaquerori quitaiteri amaoreantajeitari: tempa noponeaca narori inquitequi, natiritapaaque. ");
INSERT INTO cniNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yora Jesoshi ijatanaji aisati pancotsiqui yapatojeitantari. Aitaque isaviquiri shirampari quisoporoquitatsiri iracoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yamenashijeitavaqueri atiri, sorerere: icoaque iriote ariorica iroavisacotajeri saavaroqui. Icoajeitaque incantajeite: “Te oncameetsateji oca yantiri Jesoshi”. ");
INSERT INTO cniNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yora Jesoshi icantiri quisoporoquitatsiri: —Pincatiaje, caate aca nianqui. ");
INSERT INTO cniNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Impoiji isampijeitaqueri maaroni amenajeitaintsiri: —¿Cameetsampa aneshinoncateri atiri quitaiteri amaoreajeitantari? ¿Ariompa avashinoncayeri? ¿Ocameetsatimpa avavisacoteri? Tericampa, ¿picoaquempa ayeri? Iro cantaincha imajerenirojeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iquisanaca Jesoshi, yamenajeitaqueri, aisati iquenqueshireanaca. Iro iquenqueshireantanacari te incavintsaantajeiteji atiri. Icantiri shirampari: —Pancotaje. Ari yacotanaji, irosati yavisacotantanaja. ");
INSERT INTO cniNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Isoquijajeitanaque variseopee, ijatashijeitanaqueri ishaninca Eroreshi. Yoametavacaajeitaca: —¿Jaocasa ancanteriri Jesoshi, avanteariri? ");
INSERT INTO cniNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yora Jesoshi aisati iroamerepee ijajeitanaji incajarequi, yoijajeitanaqueri oshequi carireasati, aisati joreasati, ");
INSERT INTO cniNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","jerosaresati, iromeasati, intatiquerosati Jorirani, maaroni savicajeitatsiri Tiroqui, Shiroqui, maaroni. Iquemacojeitaqueri itasoncanti, irootaque ijatashijeitantacariri oshequi atiri. ");
INSERT INTO cniNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Icantiri iroamere: —Pamaquenarota pitotsi, nontetearo: ishenacajeitapaanacari ashanincapee. ");
INSERT INTO cniNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ari iquenquetsatacaajeitaqueri, impoiji yaniireapaaji aisati quipatsiqui. Oshequi yoavisacojeitavaqueri. Yora mantsiayetatsiri iteencareayetaqueri ishanincapee, impamitantapeempariri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Yora atiri yatajeaonquiri camaari ipincatsajeitaqueri. Antearojenca ineanatacaaqueri icantajeitaqueri: —Jesoshi, avirotaque itomi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Icantasanotiri Jesoshi: —¿Paita picantantanari? Pimajerete, eiro picamantacotanatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ari impoiji itoncaanaque toncaariqui. Icajemaqueri yora icoyeaqueri, ari ijatashijeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Icoyeasanotaqueri 12 shirampari, intsipatasanojeitanteariri. Impoiji intiancajeiteri inquenquetsatacaajeiteri ishaninca irineane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Aisati imatacaaqueri itasoncantajeitaque irojocanteariri camaari. ");
INSERT INTO cniNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ari icoyeaqueri iroamere 12. Icoyeaqueri Shimo, ipajitajiri aisati Petero. ");
INSERT INTO cniNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Aisati icoyeaqueri Santiaco itomi Severeo. Icoyeaqueri Joa irirenti Santiaco: ipajiyeetajiri aisati Voaneriji, acantiro aneanequi “Shintsiri”. ");
INSERT INTO cniNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Aisati icoyeaqueri Antirishi, Jeripi, Varitorome, Mateo, Tomashi, Santiaco itomi Arijeo, Tareo, Shimo. Iriotaque Shimo shintsiyetirori paitaricapee. ");
INSERT INTO cniNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Aisati icoyeaqueri Jorashi Ishicariote: iriotaque aacanterineri coajica Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Impoiji ipianaja Jesoshi pancotsinentsiqui. Yapatojeitajiri aisati oshequi atiri. Tecatsi incantea iroyea. ");
INSERT INTO cniNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iquemacotaqueri Jesoshi ishanincasanori, ijatashivetajari iraanajerime ivancosanoriqui. Icantavacaanaca: —Te irineacoteaji Jesoshi, tsame aanajeri. ");
INSERT INTO cniNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ario ipocashitiri aisati jerosaresati, oametantirori sanquenarentsi. Icantacotashitapaacari: —Iriotaque Satanashi atajeaonquiriri Jesoshi. Tempa Satanashi iriotaque ivincatsarite camaari: iriotaque amitacotiriri itianquiri iamaaririnte, irootaque imatantacariri. ");
INSERT INTO cniNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Icajemavaqueri Jesoshi, icantavaqueri: —¿Queariompa yatajeaoncaquena camaari? Pamene: ¿jaoca incanteari Satanashi irojocajea irisati? ");
INSERT INTO cniNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Oquempetaca ariorica inquisavacaajeitea savicatsiri nampitsiqui, irojocavacaajeitea, ¿arimpa irisavicajeitanaje cameetsa? ");
INSERT INTO cniNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aisati oquempetaca ariorica inquisavacaajeitea savicatsiri pancotsiqui, ¿arimpa inquisoavacaajeitajea? ");
INSERT INTO cniNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aisati iquempetaca, ariorica Satanashi inquisherime iamaaririnte, irojocavacayeame, eirome itimime: aitaque impoyereavacayeame. ");
INSERT INTO cniNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Aisati iquempeta iriori coshitantatsiri: itsaroacaari shintsitatsiri inqueavancoteri incoshitanteariri irovaararo. Ariorica impocashiteri, irijivatapeeri iraapeeri, iroisotapeeri shintsitatsiri, impoijiquea incoshiteri paitaricapee yoayetiri ivancoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Queariotaque oca noncamantasanotempiri: icavintsaajeitajiri Tasorentsi maaroni antirori caari cameetsatatsi. Aisati, ariorica incantimajeiveteari, incavintsaajeiteri aisati. ");
INSERT INTO cniNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Iro cantaincha, eiro icavintsaajeitiritsi irinti cantimatirori Ishire: incantaitatiyempani intime iriori Sharincaveniqui. Eiro catsini yavisacotajitsi. ");
INSERT INTO cniNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Irootaque icantaqueriri Jesoshi. Pineaquero, icantashinirojeivetaca incaranqui: “Irio camaari amitacotiriri Jesoshi”. Tempa irootaque Ishire Tasorentsi amitacotiriri, caari ini camaari. ");
INSERT INTO cniNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Ari isaviqui Jesoshi pancotsiqui, isaviquimojeitapaaqueri areejeitapaariri. Impoiji areetapaaca iriniro, otsipajeitapaari irirentipee. Ocatiapaaca saiteriqui, ocantiri oneapaaqueri: —Pincantenari notomi. Ari iqueashitanaqueri, icantapaaqueri: —Areetapaaca piniro, pirentipee, aisati pitsiropee. Osavicapaaque saiteriqui, ocoapaaquempi. ");
INSERT INTO cniNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ari yacavaqueri: —¿Jaoca ocantari inatatsiri? ¿Jaoca icantari iyetatsiri? ");
INSERT INTO cniNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Irosati ijicotantanacari saviquimojeitaqueriri. Icantanaque: —Jeroca inatatsiri. Jerica iyetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Janicarica antapinitirori icoacairiri Tasorentsi: iriojeitaque iyetatsiri, tsiotatsiri, inatatsiri. Noshanincajeitacari maaroni quemisantajeitanari. ");
INSERT INTO cniNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yoametantaji aisati Jesoshi anta otsapijaqui incajare. Yapatotimentapaajari oshequi atiri catsini. Irosati itetantaca pitotsiqui, itiancaquero nianquija capichaji, isavicaque. Icatiashijeitapaacari otsapijaqui maaroni ashaninca. ");
INSERT INTO cniNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yoameyetaqueri paitaricapee, aisati ishiacaaventiniri, icantiri: ");
INSERT INTO cniNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Meeca noncamantempi. Ijataque panquiveetatsiri yojocaitiro oitsoqui tirico. ");
INSERT INTO cniNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yojocaitiro, opariaarantapaaque avotsiqui. Ipocapaaque contsaro, yoapaacaro, itsonquitapaaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pashini pariapaintsi oitsoqui mapiqui. Te ontimasanoteji oshequi quipatsi, jentsipaite oshiocavetanaca. ");
INSERT INTO cniNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ari ijenoquitapaaque catsirincaiteri, irosati oshimpeshitantanaca. Te omparitsatasanoteji, irootaque ocamantanacari. ");
INSERT INTO cniNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Opariapaaque pashini oitsoqui quitotseequimashiqui, oquimotanaque quitotseequi. Irootaque ajaanaquerori, caari oitsoquitanta panquirentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pashini pariapaintsi quipatsiqui cameetsari. Oquimotanaque, otimayetanaque oitsoqui. Aparo oitsoquitanaintsi ocarati oitsoqui 30. Pashini otimanaque aisati oitsoqui ocarati 60. Iro otsipa ocarati oitsoqui 100. ");
INSERT INTO cniNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Piquemavaquerorica oca nocantaquempiri, piotavaquero, pinquenqueshiretavaquero. ");
INSERT INTO cniNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Impoiji ijajeitanaji atiripee, itimanaji apaniro Jesoshi, itsipajeitari aparopee oijatiriri, aisati iroamere caratatsiri 12. Isampijeitiri: —¿Jaoca ocantari oca pishiacaaventiniriri? ");
INSERT INTO cniNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Icantanaqueri: —Meeca noncamantempiro caari piojeitini: aitaque piojeitero jaoca icantari Tasorentsi ipincatsariventanti. Irompa irinti yontapee, eiro nocamantasanotiritsi, irointi noshiacantiniri oncanteata ");
INSERT INTO cniNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","iramenavetea, iro cantaincha eiro ineasanotitsi, inquemavetea, iro cantaincha eiro iotasanotitsi. Eiro iquenqueshireatsi, eiro icavintsaajiritsi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aisati icantaqueri: —¿Tempa pinquemavaquero oca noshiacantimpiri? Ariorica noshiacantempiro aisati, ¿jaoca pincanteari piotantearori? ");
INSERT INTO cniNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yora jocaiyetirori oitsoqui ishiaqueri ovaayetirori irineane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aparopee jocaiyetapaincha avotsiqui oshiaqueri quemisantavetavacarori irineane Tasorentsi, iro cantaincha yora Satanashi yojocapitsatajiri iquenqueshireantavetacari: te inquemisantanajeji. ");
INSERT INTO cniNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aisati oca jocaitapainchari mapiqui, oshiaqueri quemavetavacarori irineane Tasorentsi. Intsipaite iquimoshireventavetavacaro. ");
INSERT INTO cniNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ishiaquero panquirentsi caari timatsine ovaritsa. Intsipaite ocamaque. Iquemisantavetaca, irootaque yoashinoncanteetacariri, aisati iquisanentanteetacariri. Intsipaite yojocanajiro iquemisantaveta. ");
INSERT INTO cniNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Oca jocaitainchari quitotseequimashiqui oshiacaaventiri quemavetavacarori irineane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Iro cantaincha iquenqueshiretapinitiro timayetatsiri aca quipatsiqui, iquimoshireventajeitiro yashiyetari. Aiquero icoanaitii irashijeitearo paitaricapee, irootaque yojocantajarori iquemisantavetari. Ishiaquero caari timatsi oitsoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Iroquea oca irointi jocaitapainchari quipatsiqui cameetsari, oshiacaaventiri quemasanotavaquerori irineane Tasorentsi. Aitaque ishiretasanotacaro, iriotaque shiacaaventainchari panquirentsipee timanaintsiri oitsoqui. Aparo oitsoquitanaintsi ocarati oitsoqui 30. Pashini otimanaque aisati oitsoqui ocarati 60. Iro otsipa ocarati oitsoqui 100. Oca oitsoqui oshiaquero amajeitaqueneriri Tasorentsi, aparo iranaacotaqueri itsipapee. ");
INSERT INTO cniNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Aisati icantaqueri: —Ancoaquerica antsiotea, ¿arimpa avajero tsiomentotsi covitiqui tsompoina? ¿Arimpa amanaquero tsiomentotsi? Tempa acoiro antsiojeitearo maaroni amenajeitanteari. ");
INSERT INTO cniNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Coajica onconijatanaque maaroni amanavetari, iriojeitanaquero maaroni antajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Otimirica piquemantari, pinquemavaquero oca nocamantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pashini icantaqueri aisati: —Pinquenqueshiretero oca piquemaqueri. Ariorica capichaji pinquemisantavaquero nocamantimpiri, ari capichaji piotavaquero. Ariorica pinquemisantasanotavaquero, ari oshequi piotavaquero, noametasanotaquempiro catsini. ");
INSERT INTO cniNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yora iotavaquerori noametaqueriri, aiquero noametasanoteri catsini. Yora caari iotavaquero nocamantavetacariri, eiro iotitsi catsini. ");
INSERT INTO cniNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Aisati icanti: —Tempa ipincatsariventajeitaquee Tasorentsi. Ishiaqueri shirampari jatatsiri ipanquitiro oitsoqui quipatsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Imaapiniti tsiteniriqui, isaaquitapiniti quitaiteriqui. Ocontetsoaquitanaque ivanquire, oquimotanaque. Te iriotacoteroji jaoca ocantanacari oshiocantacari. ");
INSERT INTO cniNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Oshiocaque quipatsiqui: ojivati otsoaqui, impoiji ominca, impoiji opa, impoiji antaiquitanaque oitsoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ariorica osampaquitanaque oitsoqui, intotacoyeetero, tempa omoncaratapaaca iraantearori. ");
INSERT INTO cniNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aisati icanti Jesoshi: —¿Jaoca noncantempirori noshiacaaventempiro jaoca icanta Tasorentsi ipincatsariventanti? ¿Jaoca ancanterori anquenquetsatacotantearori? ");
INSERT INTO cniNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Oshiaquero oitsoqui moshitasa. Irointi oitsoqui, te onquempetearoji pashinipee oitsoquiyetatsiri: quiripequiitaque oni catsini. Ariorica ampanquitero, ");
INSERT INTO cniNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","oshiocanaque. Onquimotanaque, anayetanaquero otsipapee panquirentsiyetatsiri. Antearoyetanaque ojempequipee, aitaque iramampeapinitearo vanquiyetachari. ");
INSERT INTO cniNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Aitaque icantapinita Jesoshi, ishiacaaventapinitiniri atiri iroametanteariri irineane Tasorentsi. Ariorica capichaji iquemaquero, ari capichaji yoametaqueri: oshequirica iquemavaquero, ari oshequi yoametaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iotaca ishiacaaventapinitiniriri. Irintiquea iroamere, itsoteajeitaqueneri yoametasanojeitiri. ");
INSERT INTO cniNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Iqueanaji catsirincaiteri. Icantajiri iroamere: —Tsame amonteanaje intatiquero. ");
INSERT INTO cniNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Itiancanajiri apatotimentajeitariri: —Tsamajempi pijajeitanaje pivancopeequi. Irosati inaque iriori pitotsiqui, isavicaque. Itejeitanaja iroamere, yoimonteajiri. Aisati imonteacotanaja yora apatotimentariri otsipapee pitotsi. ");
INSERT INTO cniNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Omapocavaqueri nianquija antearo tampea catsini. Ora omotoncane otejatapaacaro pitotsi, irovetaincha ojaayeame. ");
INSERT INTO cniNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Imaaque Jesoshi anta opataquiqui, itiinataca. Yoisaaquireaqueri iroamere, icantaqueri: —Oametanari, ¿paita caari pinquenqueshireanta? Irotanaintsi ampiincajeite. ");
INSERT INTO cniNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Itinaanaja, icajemacotaquero tampea, aisati icantiro incajare: —Pimajerete, pimajerejate. Opeanaja tampea. Omajerejatasanotanaji incajare. ");
INSERT INTO cniNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Icantiri: —¿Paita pitsaroantari? ¿Paita caari pishirejeitantari Tasorentsi? ");
INSERT INTO cniNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Oshequi catsini itsaroasanojeitanaque. Icantavacaanaca: —¿Janicampa yoca, oquemisantantacariri tampea? Aisati incajare, oquemisantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Yareejeitanaca intatiquero, yamatsecapaaque quipatsiqui: irootaque iipatsite jerasesati. Intsipaite itonquiotavacari neiriri camaari, iponeanaja anta tijaarimashiqui, ");
INSERT INTO cniNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","aitaque isaviquiri. Tecatsi aaveerineri iroimajerenteri. ");
INSERT INTO cniNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yoisotapiniyeevetari iracoqui carenatsa, aisati iitiqui, iro cantaincha ipesayetaquero, peti, peti. Tecatsi anacoterine ishintsiti. ");
INSERT INTO cniNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Icantatiani: tsiteniriqui, quitaiteriqui, iquenayeti tijaariqui aisati toncaariqui. Icajemayeti, itoyetaro mapi. ");
INSERT INTO cniNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yoca shirampari ineitavacari arejiquinta Jesoshi, ishiashitanacari, itiyeroashitapaacari. ");
INSERT INTO cniNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Icantavaqueri Jesoshi camaari: —Pinijantareanajeri yoca shirampari. Antearojenca icajemacotapaaqueri: —¿Paita pashereantanari? Aviro Jesoshi, itomi Tasorentsi inquitequiniri, tempa ineajeitaquee. Nocantasanotimpi catsini, eiro poashinoncaanatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ari isampitiri Jesoshi: —¿Jaoca pipajitari? Yacanaqueri: —Nopajita Oshequianti. Iro nopajitantari, oshiquianti noni catsini. ");
INSERT INTO cniNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Eiro pitiancanatsi pashiniqui nampitsi. Aitaque icantasanotapinivetacari catsini. ");
INSERT INTO cniNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ari anta itimi oshequi chancho, yoajeita tioncaiquiji. ");
INSERT INTO cniNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Yora Oshequianti icantiri: —Ari pintianquenari anta chanchoqui, irineavaquena iriori, quiso noapaajeri. ");
INSERT INTO cniNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ari ishinetaqueri; inijantareanajiri camaari shirampari, yojocanajiri. Ineavaqueri irinti chancho. Icarajeiti chancho 2,000. Ishiajeitanaca imperitaitequi, ipiincajeitanaque incajarequi, pocn, pocn, pocn; itsitiajeitanaque, pomiririri. ");
INSERT INTO cniNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Itsaroajeitanaque shentajeivetariri, ishiajeitanaca, icamantapairi savicajeitatsiri nampitsiqui, aisati oantsipeequi. Otsoteanaca neantsi. Ipocajeitanaque atiri irameneri jaocarica icantacari chancho. ");
INSERT INTO cniNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ijatashijeitiri Jesoshi, ineajeitapairi yora neaveitariniri camaari. Isavicaji, iquitsaataja, timanaji iquenqueshiretantari. Ari ineajeitapaaqueri, itsaroacaajeitapaacari. ");
INSERT INTO cniNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yora neasanotaqueriri incaranqui icamantajeitaqueri: —Pineaqueri, yoavisacotajiri Jesoshi yora neaveitariniri camaari. Aisati yoviincacantaqueri chancho. ");
INSERT INTO cniNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Impoiji icantasanojeitiri: —Pijataje, eiro pipocajitsi aisati nonampiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ari itetanaja Jesoshi pitotsiqui. Icantasanovetari yora yoavisacotiri: —Nocoaque noijatanaquempi. ");
INSERT INTO cniNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iro cantaincha, icantiri Jesoshi: —Eiro poijatanatsi, ainti pijataje pinampiqui, anta pishanincaqui. Pincamantapeeri: “Ineshinoncatajana novincatsarite”. ");
INSERT INTO cniNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ari ijatanaque neaveitariniri camaari Tecaporishiqui. Icamantajeitapairi maaroni atiri: —Yoavisacotajana Jesoshi. Yoajeitavaqueri atiri cavaco. ");
INSERT INTO cniNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ari imonteanaja Jesoshi intatiquero. Yapatojeitavacari oshequi atiri anta otsapijaqui. ");
INSERT INTO cniNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yareetapaaca shirampari pajitachari Jairo, yora jivatacaajeitiriri atiri anta pancotsiqui yapatotantari. Ineapaaqueri, itiyeroashitapaacari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Icantasanotapaaqueri: —Irotaintsi oncame noshinto. Pimpoque pimpamitapeero avisacotantajeari iroori, eiro ocamantatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ari yoijatanaqueri, aisati yoijajeitanaqueri oshequi catsini apatotimentariri, yovetacajeitanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ocarajeitaqueri tsinane irajashetatsiri. Ocaratacotaque osarintsite 12 irajashetantacari. ");
INSERT INTO cniNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Oshequi yaavinteenayevetaro, aiquero yoatsiyeetaquerori. Atsipetashitacaro opinaventayevetacaro maaroni ashiyevetari. Te avisacotimateji, aiquero ojatatii irajatanaque catsini. ");
INSERT INTO cniNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Oquemaque icantacoyeetiriri Jesoshi: “Oshequi yoavisacotanti”. Osatecanacari oijajeitiriri, oquenapaaque itapiiqui. Oquenqueshiretanaca: —Ariorica nantiteri iitsaare, aitaque navisacotanaje. Ari antitaqueri iitsaare, ocaratanaji irajaveitani. ");
INSERT INTO cniNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Oquemavaitia maaririri, avisacotanaji. ");
INSERT INTO cniNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aisati iriori Jesoshi, iquemashitavaitiaro itasorenca. Ari ipitsocashitanacari oijajeitiriri, icantiri: —¿Janicampa antitaquenarori noitsaare? ");
INSERT INTO cniNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yacanaqueri iroamere: —Tempa pineeriji yoshequitaque oijajeitimpiri. Yovetacayetaquempi. Aiquero picanti: “¿Janicampa antitaquenarori noitsaare?” ");
INSERT INTO cniNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yamenamenayetanaque irineero antitaqueriri iitsaare. ");
INSERT INTO cniNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iroori tsinane, oshequi otsaroanaque, opioncanaque, pio, pio. Iotanaque avisacotaji. Otiyeroashitapaacari, opincatsataqueri. Otsoteaquero ocamantasanotaqueri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Icantiro: —Tsinane, pishiretaquena, irootaque pavisacotantajari. Meeca pijataje, pinquimoshiretanaje. Aitaquenea pavisacotajiri. ");
INSERT INTO cniNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tequerata intsonquerome ineanatiro, ipocajeitapaaque inampirepee Jairo. Icantapaaqueri: —Camanaque pishinto. ¿Paita pantsipetacanteariri pashereaqueri yoca oametantatsiri? ");
INSERT INTO cniNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iquemavaquero Jesoshi oca icantapaaqueriri. Icantiri Jairo: —Eiro picantashiretitsi, nainti pishiretea. ");
INSERT INTO cniNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tecatsi irishinete oijatanaquerine. Irinti ishinetaque yora Petero, Santiaco, Joa. Iriotaque Joa irirenti Santiaco. ");
INSERT INTO cniNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yareejeitapaaca ivancoqui Jairo. Ineapaaqueri atiripee: icajemajeitaque, iraashiretacojeitacaro, iraacojeitacaro. ");
INSERT INTO cniNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iqueapaaque, icantapaaqueri: —¿Paita picajemacojeitantarori? ¿Paita piraacojeitantarori? Te oncamasanoteji evancaro, irointi omai. ");
INSERT INTO cniNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ishirontimentajeitavacari, iro cantaincha yoisoquijajeitapairi. Yaanaqueri irini, jero inironi, aisati iroamere, iqueanaque anta onaquenta evancaroni. ");
INSERT INTO cniNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yajiricavacotapaaquero acoqui. Icantiro: —Tarita comi. Acantiro aneanequi arori: “Evancaro, pintinaanaje”. ");
INSERT INTO cniNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Otinaanaja evancaro, tancore, aniitanaji. Ocarataque osarintsite 12, irootaque omatantajari aniiveetaji. Yoasanojeitanaque cavaco oshaninca. ");
INSERT INTO cniNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Icantasanotiri: —Eiroya picamantayetiritsi atiri. Meeca pimpero oyeari. ");
INSERT INTO cniNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ari ijatanaji Jesoshi, yareetapaaja iipatsitequi iriori. Yoijajeitajiri iroamere. ");
INSERT INTO cniNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Impoiji quitaiteri imaoreajeitantari, yoametantapaaji anta yapatotapinijeitacanta joriopee. Yoajeitavaqueri cavaco oshequi quemavaqueriri. Itseencajeitaqueri Jesoshi, icantajeiti: —Tempa iriotaque ashanincasanori arori. ¿Jaoca oponeimotacariri oca yoametantiri? ¿Jaoca icantacari itasoncantayetantacari? ¿Caarimpa yoca vetsicapinitirori inchato? Iriotaque otomi Maria, tempa iriotaque irirentipee Santiaco, Jose, Jorashi, aisati Shimo. Aisati iritsiropee, tempa osaviquimojeitaquee aca. ");
INSERT INTO cniNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Icanti Jesoshi: —Ari ineacameetsajeivetacari atiripee camantantatsiri. Iro cantaincha iriorica camantantatsiri ishanincasanori, ari intseenqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ari itseencajeitaqueri, irootaque caari itasoncantapinitanta anta inampiqui. Aparopee ipamiyetiri mantsiayetatsiri, yoavisacoyetiri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iro cantaincha te inquemisantajeiteriji ishaninca, irootaque yoantanacari cavaco: —¿Paita caari iquemisantajeitantana? Iquenaquenayetanaque Jesoshi nampitsipeequi, yoametantayetanaque. ");
INSERT INTO cniNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aisati icoyeaqueri iroamere 12. Imatacaaqueri iroavisacotanteariri neiriri camaari. Impoiji itiancajeitaqueri; itsipatavacaayetanaca, apitepee ijayetanaque nampitsipeequi. ");
INSERT INTO cniNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Icantasanotavaqueri: —Ariorica pijatanaque, tecatsiyea paanaque. Eiro paanaquetsi poyeari, eiro paanaquerotsi pitsarate. Aisati eiro paanaqueritsi piirequite. Irointiquea paanaque piotiquiro. ");
INSERT INTO cniNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Aisati pisapatotanaquea, iro cantaincha eiro piquitsaatarotsi poicoro. ");
INSERT INTO cniNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aisati icantavaqueri: —Jaocarica pisavicapaaqueri, aitaque pintimaanitapaaqueri, irosati pijatantajeari pashiniqui nampitsi. ");
INSERT INTO cniNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eirorica yaacameetsajeitavaquempi nampitsiquiniri, aisati eirorica iquemisantajeitavaquempi, ari povaanajea, iriotanteari pishemacari, eiro pipiashitaritsi aisati. ");
INSERT INTO cniNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ari ijajeitanaque iroamere. Icamantajeitiri atiripee: —Pinquenqueshirejeitea, eiro pantapinitirotsi aisati caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yoavisacojeitiri oshequi yatajeaoncane camaari. Itiritantayetari quejitsi oshequi mantsiaripee, yoavisacoyetiri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Oshequi quemacojeitiriri Jesoshi, irootaque iquemacotantacariri aisati pincatsari pajitachari Eroreshi. Icantayeti atiripee: —Iriotaque Joa vaotisatantatsiri, camavetainchari: itinaanaja. Iro itinaantajari itasorentsiti. ");
INSERT INTO cniNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Timatsi pashini cantayevetachari: —Irioyeata Iriashini: itinaanaja. Pashini cantayetatsiri aisati: —Iriotaque camantantatsiri. Ishiajiri camantantaveitachaniri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ari iquemacotaqueri Eroreshi, icanti: —Iriotaqueteemi Joa. Nopesacantavetacari itsanoqui iro cantaincha itinaanaja aisati. ");
INSERT INTO cniNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Ari peerani Eroreshi yaapitsataqueri irirenti ijina. Ipajita irirenti Jeripi, iro ijinantaveitaniri, Eroriashi. Yora Joa icantapinivetacari Eroreshi: —Te oncameetsateji paapitsateri pirenti ijina. Oquisanaqueri Eroriashi, ocoasanoveta oacanterime, iro cantaincha te irininteji yora ojimentajari. Oshequi ashereapinitaqueri, irootaque yaacantantacariri Joa, yoiminquiacantaqueri caravosoqui tsompoina. ");
INSERT INTO cniNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ipincatsavetacari iriori Joa, iotiri icameetsatasanoti, iquemisantasanotiri Tasorentsi. Te irishinevetearoji ijina oacanteri. Itsaroacaapinivetari Joa, iquenquetsatacaapinitiri. Ineacameetsatiro icantiriri Joa, iro cantaincha te irioteji jaoca incanteari. ");
INSERT INTO cniNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Omoncarataja iitaiterite itimantacari peerani Eroreshi. Yoacaajeitari ivincatsaririnte, ivincatsarite soraro, aisati ivincatsarite carireasati. Irootaque quitaiteri oacantantacariri Eroriashi Joa. ");
INSERT INTO cniNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Oqueapaaque oshinto Eroriashi anta yoajeitanta omaninquetsaveetapaaque apaniro. Ineacameetsatavaquero Eroreshi aisati itsipajeitari. Icantiro evancaro: —Pincoacotena paitarica picoaqueri. Aitaque nompaquempiro. ");
INSERT INTO cniNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ineaquena Tasorentsi, ioti eiro namatavitimpitsi. Paitaricapee pincoacotaquenari, aitaque nompaquempi. Picoaquerica nompaarantempi noipatsite, aitaque nompaquempi cashetani. ");
INSERT INTO cniNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Osoquijanaji iroori, osampitapaaquero iniro: —¿Paita noncoacoteriri? Acavaquero iroori: —Iro pincoacoteriri iito Joa vaotisatantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Intsipaite opianaja aisati, opiashitanajari pincatsari. Ocoacotapaaqueri, ocantiri: —Nocoi meeca pimpacotenaro matitaqui iito Joa. ");
INSERT INTO cniNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Oshequi yoashiretanaca. Tempa aitaque icantaquero incaranqui: “Eiro namatavitimpitsi”. Aisati iquemajeitavaqueri maaroni itsipajeitacari. Te meeca incoajeji iramatavitero. ");
INSERT INTO cniNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ari itiancaqueri oantatsiri, icantavaqueri: —Pamaquenaro iito Joa. Ari ijatanaque anta yoiminqueaquerinta, ipesapaaqueri itsanoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Yamacotaquero matitaqui iitoni, ipapaaquero evancaro. Iroori, ovaaquenero iniro. ");
INSERT INTO cniNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Iquemacotaqueri iroamereni Joani, ari ijatashijeitaqueri. Yaanajiri, itijajiri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ipiajeitanaja itiancane Jesoshi. Icamantajeitapaajiri maaroni yantayetaqueri. Aisati icamantacoyetapairo maaroni yoametantayetaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Irosati icantani oshequi atiri ipocashitapinitiri Jesoshi, aisati ijajeitanaji. Te irinijantareeriji, tecatsi incantea iroyea. Icantajeitavaqueri itiancane: —Tsame ajate ayojeitanaquea anta tecatsi timatsine. Amaoreajeitavaqueta capichaji. ");
INSERT INTO cniNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ari ijajeitanaque, iquenanaque pitotsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ari ineajeitavaqueri oshequi atiri, iojeitavaqueri. Iponeajeitanaca ivancopeequi, ishianaca, ishitejeitanaca. Ishianaca, yanaacojeitaqueri, yapatotimentajeitavacari. ");
INSERT INTO cniNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Imitajanaque Jesoshi, ineapaatiiri oshequi apatojeitainchari. Irosati ineshinoncajeitantapaacariri ishiacaantapaaqueri ovisha caari timatsine amenerineri. Oshequi yoamejeitapaaqueri paitapeerica. ");
INSERT INTO cniNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ari ishaavijitanaji catsirincaiteri. Ipocashitiri iroamere, icantiri: —Meeca anajeitaque aca caaraiteriqui, tecatsi avajeiteari. Aisati ishaavijitaque catsirincaiteri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pintiancajeiteri atiri irijajeitajeta oantsiqui, nampitsiqui quempejiniri. Iramanantajeitapeeta iroyeari. ");
INSERT INTO cniNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yacanaqueri, icantiri: —Pimperita avinti iroyeari. Icanti iroamere: —¿Picoavetampa nojate namanantaite tanta nompantajeiteariri? Oshequi ompinatea noacantajeiteariri maaroni, eiro imoncaratarotsi airequite. ");
INSERT INTO cniNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yacanajiri: —¿Jaoca ocaratiri pitantane timatsiri? Pijate, pamenaitero. Ari ineaitiro, icantaqueri: —Apapacoroni ocarati tanta, aisati apite shima. ");
INSERT INTO cniNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Icantiri: —Poisaviqueri atiripee ara saveshishiqui. Pampatoyeteri, aisati pinashitacaayeteari. ");
INSERT INTO cniNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ari yapatojeitaqueri, isavicajeitanaque. Aparoni apatojeitainchari icarati 100 atiri. Itimi oshequi itsipapee apatojeitainchari aisati. Inashiyetaca pashinipee apatojeitainchari, icarayetaque 50. ");
INSERT INTO cniNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ari yaaquero Jesoshi tanta aisati shima, yamenanaque jenoqui. Icantiri iriri: —Ariove, Apa, aviro paquenarori oca noyearica. Icarajaquero tanta. Ipaqueri iroamere irovayeteneri apatojeitainchari. Aisati shima, yovayetaqueneri maaroni atiri, ");
INSERT INTO cniNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ari yoajeitanaca. Iquemajeitanaca, te intsonqueroji. ");
INSERT INTO cniNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yaayetajiro timaarantapaajantsiri, ijaayetajiro cantiriqui ocarati 12. ");
INSERT INTO cniNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Icarajeiti oacarori 5,000 shirampari. ");
INSERT INTO cniNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Impoiji itianquiri Jesoshi iroamere, icantiri: —Pintetanajea pitotsiqui. Pijivajeitanaquena intatiqueronta, anta Vetsairaqui: nontiancajeitajerita ivancopeequi yoca apatojeitainchari. ");
INSERT INTO cniNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Impoiji ijatanaque Jesoshi toncaariqui, iquenquetsatacairi iriri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Otsitenijencaiteanaji, inianquijatacotanaque iroamere incajarequi. Itimaiti Jesoshi apaniro quipatsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ineaqueri iroamere, icomacomajeiveta, iotaqueri imaojempequitaque. Aiquero oipiacotajiriri tampea. Ari oquitaitetimataji ijatashitajiri iriori Jesoshi. Yaniijatanajiro incajare, te intsitiyeji. Iro iravisanaquerime, ");
INSERT INTO cniNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","iro cantaincha ineajeitavajiri, yaniijatapaajiro incajare. Ijijeivetavacari irio camaari. Ari icajemajeitanaque: —Eeeee. Coraquenive camaari. ");
INSERT INTO cniNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ari ineajeitavaqueri maaroni. Itsaroajeitanaque. Ineanatapaajiri: —Pinquimoshirejeitaje. Narotaque pocajantsiri. Eiro pitsaroashijeitatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Itetapaaja pitotsiqui, itsipajeitapaajari, opeanaja tampea. Yoajeitanaque cavaco catsini. ");
INSERT INTO cniNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ineajeivetacari incaranqui itasonquiro tanta, iro cantaincha tequera inquenqueshireimateaji. ");
INSERT INTO cniNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ari imonteanacaro, yareejeitapaaca Jenesaretequi. Yaatacojeitapaaque. ");
INSERT INTO cniNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Imitajajeitapaaque, intsipaite iojeitavaqueri atiri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ishiashijeitapaacari. Yamacojeitaqueri mantsiayetatsiri inareantariqui. Jaocarica itimapairi Jesoshi, aitaque anta yaacotanaqueneriri. ");
INSERT INTO cniNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iquenaquenayeti nampitsijaniquiqui, nampitsiqui antearo, aisati oantsiqui. Jaocarica iquenanaqueri Jesoshi yoayetaqueneri mantsiayetatsiri. Yoayetaqueneri nianqui nampitsiqui, icantajeitavaqueri: —Pishinetenaro nompamititavaquempiro ocaratapai piitsaare. Ari yavisacojeitaji maaroni pamititajeitavaqueriri iitsaare. ");
INSERT INTO cniNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ari ipocapaaque variseopee, aisati aparopee oametantirori sanquenarentsi, iponeaca Jerosarequi. Yapatotimentapaacari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ineajeitapairi iroamere, yoajeita iriori: te inquivacoteaji. Icantajeiti intacaroniri: “Ariorica ayea, ajivate anquivacotea ancameetsashiretanteari”. ");
INSERT INTO cniNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yora variseo yamejeitaro tequeratarica iroyeata, iquivacotasanota. Tempa yamejeitaro maaroni joriopee. Irompa eirorica iquivacotita, eiro yoatsi. Aitaque imoncaratajiro yoametantapinitiniri intacaroniri. ");
INSERT INTO cniNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ariorica imponeajea anta nampitsiqui nianqui, eirorica iquivacotasanotapaajatsi, eiro yoapaajatsi. Aisati imoncaratashiyetaro oshequi paitarica yoameyetiriri ishanincani. Iquivajeitapinitiro pajo, onero, oya, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ari isampijeitapaaqueri Jesoshi: —¿Paita caari imoncaratantaro poamere yoametantapinitiniri intacantaqueeniri? Jeri yoca meeca oainchari, te inquivacoteaji: ainiro irantane. ");
INSERT INTO cniNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Icantavaqueri Jesoshi: —Oshequi pamatavitantayeti. Aitaque icamantacotitaquempini peerani Isayashini. Isanquenatini: “Icantashivetana yoca atiri: ‘Picameetsati’, iro cantaincha te inquenqueshiretenaji. ");
INSERT INTO cniNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yatsipetashitaro itiyeroimentavetana; ipincatsatashivetana. Pamatavitashiyetacari pishaninca: picantanirovetari oca poametantavetari irootaque irineane Tasorentsi”. Queario oca icantaqueniri Isayashi. ");
INSERT INTO cniNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aisati icantiri Jesoshi: —Pojocashitacaro icantavetimpiri Tasorentsi, irointi piquemisantashitacaro yoametantapinitiri atiri. ");
INSERT INTO cniNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aitaque pitseencaquero icantiri Tasorentsi, irointi picoaque pimoncaratajero yoametantapinitiri intacantaroniri. ");
INSERT INTO cniNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Icantini Moishishini: “Pimpincatsateri piri, aisati piniro”. Aisati icanti: “Aitaque iroasanqueteri Tasorentsi yora cantimatiriri iriri aisati iriniro”. ");
INSERT INTO cniNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Iro cantaincha picantashinirojeivetari ashaninca: “Ariorica pincashiacayeri Tasorentsi piirequite, ari pimpasanoteri. Irashinoncayearica piri, piniro, pincanteri: ‘Eiro nomatirotsi noncavintsayempi: nocashiacaaqueri Tasorentsi noirequite nomperiri’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Aitaque meeca te pishineteriji pishaninca irintacoteari iriri, iriniro. ");
INSERT INTO cniNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Picoacaaqueri inquemisantero poametapinitiriri, aisati poametaqueri intseenquero icantiri Tasorentsi. Aitaque picantanirotapinitari: pojocacaayetiri ashaninca iquemisanti. ");
INSERT INTO cniNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ari icajemajiri aisati apatojeitainchari, icantajeitiri: —Pinquemajeitavaquena maaroni. Piojeitavaquero oca. ");
INSERT INTO cniNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ocameetsati avajeitearo paitapeerica, eiro otimitsi antane: tecatsi oncantero avari ashire. Piquenqueshiretiro caari cameetsatatsi, irootaque pantapinitantarori. ");
INSERT INTO cniNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Otimirica piyempita piquemantari, pinquemavaque. ");
INSERT INTO cniNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ari ijajeitanaji apatotimentariri, iqueapaaji Jesoshi pancotsiqui. Isampitiri iroamere: —¿Jaoca ocantari pishiacaaventiniriri? ");
INSERT INTO cniNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Icantiri: —Aisatimpa avirori, ¿tempa pinquemavaquena? Paitapeerica iroyeari ashaninca, ocameetsati, eiro otimitsi irantane. Tempa piotavaquero. ");
INSERT INTO cniNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Eiro omatirotsi ishire, ainti ojataque isheitoqui, impoiji ishitajiro. Irootaque yoamejeitiriri ocameetsataque paitarica yoyeeyetari. ");
INSERT INTO cniNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aisati icantiri: —Oca iquenqueshiretiri antacairiri ashaninca caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Te iroyearoji caari cameetsatatsi, irointi iquenqueshiretiro. Irootaque yantajeitantarori maaroni: yantavintsatiro tsinane caari yai, antavintsatiri shirampari caari ai, icoshiti, yoanti. ");
INSERT INTO cniNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Yaimentaro ijina, aimentari ojime. Inevetaro yashiyetari pashini atiri. Icamaaritanti, yamatavitanti, imayempitantapiniti, imashitsati, icantimatanti, ishemeti. Te ontimeji iojeitantari. ");
INSERT INTO cniNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iquenqueshiretiro atiri caari cameetsatatsi, irootaque yantantarori: impoiji otimi irantanepee. ");
INSERT INTO cniNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Impoiji ijatanaji Jesoshi Tiroqui. Isavicapaaque pancotsiqui, te incoaveteaji irioyeeterime. Iro cantaincha tecatsi incantea irimanea. ");
INSERT INTO cniNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Otimi anta tsinane, yatajeaonquiro oshinto camaari. Oquemacotavaqueri tsinane Jesoshi, ojatashitaqueri, otiyeroashitapaacari. ");
INSERT INTO cniNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Caari oni jorio, oponeaca Shirojenishiaqui. Ocantapaaqueri: —Yatajeaoncaquero noshinto camaari, poavisacotajenaro. ");
INSERT INTO cniNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Icantavaquero: —Nojivatavaquerita noshanincasanori nintacoteari. Te oncameetsateji aapitsatajeri yoari ajananequite, amperi otsiti iroyeari. ");
INSERT INTO cniNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Iroori acanaqueri: —Je, queario. Aitaque iniri otsiti nijanteaji. Yoatsopequititayetari atomi. ");
INSERT INTO cniNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Icantajiro: —Je, cameetsa; queario picantaqueri. Cameetsa pijataje meeca, avisacotanaji pishinto. ");
INSERT INTO cniNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Opianaja ovancoqui. Oneapaajiro oshinto, onariaca omaamentoqui, avisacotaji. ");
INSERT INTO cniNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Impoiji yovaanaja aisati Jesoshi, iquenanaji Tiroqui, Shiroqui aisati Tecaporishiqui. Ari yareetapaaja incajarequi Carireaquiniri. ");
INSERT INTO cniNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Yameetapaaqueneri aparo shirampari imayempiti, aisati imasontiti. Icantapaaqueri: —Pimpamitavaqueri, poavisacotajeri. ");
INSERT INTO cniNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yora Jesoshi yojocanajiri apatotimentariri, apaniro itsipatanacari mayempiri. Yoiminquiaqueneri iracotsapaqui iyempitaqui. Iquitiojaquero iracotsapaqui, ipantaqueri inenequi. ");
INSERT INTO cniNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yamenanaque jenoqui, yaneencanaque, icantiri: —Epeta. Acantiri arori aneanequi: “Ovitareanajea”. ");
INSERT INTO cniNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ovitareanaja iquemantari. Opeanaja iniconeneveitani, cameetsajencatanaji ineaveetaji. ");
INSERT INTO cniNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yapiitapinivetari: —Eiroyea picamantacotanatsi. Iro cantaincha te inquemisanteriji, aiquero catsini icamantacotaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Aiquero catsini yoajeitanaqueri cavaco Jesoshi. Icantajeitiri atiripee: —Paitaquea, ocameetsatasanoti yantayetiri. Imatasanotaquero Jesoshi maaroni yantayetiri. Iquemacaayetajiri mayempiveitachaniri, aisati yora masontiveitachaniri, ineaveetacaayetajiri. ");
INSERT INTO cniNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pashini quitaiteri yapatojeitaca aisati oshequi atiri, tecatsi iroajeiteari. Yora Jesoshi icajemiri iroamere, icantavaqueri: ");
INSERT INTO cniNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nocavintsaajeitaqueri yocapee. Iro nocavintsaajeitantacariri mavataque quitaiteri itsipajeitaquena, te iroajeiteaji meeca. ");
INSERT INTO cniNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aajeitaqueri itashe. Timatsi aparopee poneainchari paricoti: ariorica nontiancavetajeari meeca ivancoqui, ari irimaoshirejeitanaque nianqui avotsiqui, irimaotsajeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yacanaqueri iroamere: —¿Jaoca ancanteari anquemacaajeitanteariri tanta? Aca caaraiteriqui. ");
INSERT INTO cniNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Isampitiri: —¿Jaoca ocaratiri pitantane? Icanti: —Ocarati 7. ");
INSERT INTO cniNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Icantajeitiri apatotimentajeitariri: —Pisavicajeite quipatsiqui. Yaaquero tanta, ipasonquitiri iriri. Icarajaquero, ipajeitaqueri iroamere, yovaajeitaqueneri apatojeitainchari. ");
INSERT INTO cniNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Itimaque aisati shivajaniqui aparopee. Ipasonquitacotaqueri aisati. Impoiji icantiri iroamere: —Pimpajeiteri aisati shivajaniqui. ");
INSERT INTO cniNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ari yoajeitaca, iquemajeitanaca. Yaayetajiro timaarantapaintsiri, yoajiro cantiriqui. Ocarati jaajanchari 7. ");
INSERT INTO cniNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Icarajeiti oainchari 4,000. Impoiji itiancajeitajiri: —Pijajeitaje pivancopeequi. ");
INSERT INTO cniNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Itsipajeitanajari iroamere, itejeitanaja pitotsiqui. Ijajeitanaji anta Tarimanotaqui. ");
INSERT INTO cniNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ari ipocapaaque variseo. Iquisatsatiri, icantiri: —Jentsite, pintasoncantayete niotantempiri avirotaque Tasorentsi, impoijiquea ariorica nonquemisantanirotempi. ");
INSERT INTO cniNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Oshequi catsini ocantimoneentacari Jesoshi. Icanti: —¿Paita icoajeitantari maaroni atiri nonijayeri nontasoncante? Queariotaque oca noncamantasanotempiri, eiro ineanatsi nontasoncantayete. ");
INSERT INTO cniNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ari ijatanaji Jesoshi, itetanaja aisati pitotsiqui. Ijatanaji, imonteanaja intatiquero. ");
INSERT INTO cniNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ipeacojeitanacaro iroamere iraanaquerome tanta pitotsiqui, aparo yaanaque. ");
INSERT INTO cniNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Icanti Jesoshi: —Paamaventearo tapiacaarori tanta, yashitari variseo, aisati yashitari Eroreshi. ");
INSERT INTO cniNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ari icantavacaanaca, icantajeiti: —Tecatsi atantane, irootaque icantantaqueeri: “Paamaventearo tapiacaarori tanta”. ");
INSERT INTO cniNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iotacotaqueri Jesoshi, icantiri: —¿Paita picantavacaantari: “Tecatsi atantane”? ¿Paita caari piquemanta? ¿Paita caari piotanta? ¿Paita caari piquenqueshiretanta? ");
INSERT INTO cniNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Otimaveta poqui, ¿paita caari pineanta? Otimaveta piquemantari, ¿paita caari piquemanta? ¿Paita caari pinquenqueshiretantajaro ");
INSERT INTO cniNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","noshequiantacarori tanta? Ocaraveta apapacoroni tanta, icarati oacarori 5,000 shirampari. Ari paajiro timaarantapaajantsiri. ¿Jaocampa ocarati jaajanchari cantiriqui? Yacajeitanajiri: —Ari ocaratiri 12. ");
INSERT INTO cniNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Icanti Jesoshi: —Aisati pashini, ocarati tanta 7, icarati aisati oacarori 4,000. Paajiro aisati timaarantapaajantsiri. ¿Jaoca ocaratiri cantiri pijaajiri? Icantajeitiri: —Ocarati 7. ");
INSERT INTO cniNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Icantiri: —¿Tequerampa meeca piotavaquero? Te iro nonquenquetsatacote tanta incaranqui, irointi noquenquetsatacoti yoametantiri variseo aisati Eroreshi. ");
INSERT INTO cniNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ari ijajeitanaji Vetsairaqui. Yameetapaaqueneri quitapoajaquiri. Icantapaaqueri: —Pimpamitavaqueri iramenantajeari. ");
INSERT INTO cniNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ari yacatsatanaqueri quitapoajaquiri, yaanaqueri otsapitapaaca nampitsi. Iquitiojaqueri iroquiqui, ipamijaquitaqueri. Isampitaqueri: —¿Amenavetajimpimpa? ");
INSERT INTO cniNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yamenanaji, icanti: —Je, namenavetaja, noneavetajari shiramparinta, iro cantaincha te inconijatasanoteji, ishiavetacaro inchato, aniitaintsiri. ");
INSERT INTO cniNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yapiitajiri aisati, ipamijaquitajiri iroquiqui. Impoiji yamenasanotanaji, yavisacotasanotanaji. Yamenanaji, conijaitetasanotanaji maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Icantiri Jesoshi: —Eiroyea piquenanajitsi nampitsiqui, apatiroyea povaanajero pivancoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ari yovaanaja Jesoshi, itsipatanajari iroamere. Ijajeitanaque nampitsipeequi anta Sesareajiripoqui. Inianquitanaque avotsiqui, isampijeitaqueri iroamere: —¿Paita yaamaajeitaquenari atiripee? ");
INSERT INTO cniNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yacanaqueri: —Aparopee aamaayetaincha aviro Joani vaotisatantatsiniri. Irio itsipa yaamaaquempi aviro Iriashini. Itsipapee aisati icanti aviro camantantatsiniri, pitinaanaja. ");
INSERT INTO cniNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Isampijeitaqueri: —Avirojei, ¿paita piquenqueshirejeitiri? Yacanaqueri Petero: —Avirotaque naamaajeitacari peerani: aviro Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Icantasanotiri: —Eiroyea picamantacotanatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ari yoametajiri aisati: —Noponeaca narori inquitequi, natiritapaaque. Coajica oshequi nonquemaatsicatimentajeitempi. Queario, intseencaquena pincatsaripee, aisati jivatacaajeitiriri saserotepee, aisati oametantirori sanquenarentsi: intseencajeitaquena, iroacantajeitaquena. Noncamaque, iro cantaincha oncarataque mava quitaiteri, irosati nontinaantanajeari. ");
INSERT INTO cniNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aitaque icantasanojeivetacari. Yora Petero yaanaqueri quempequetiji ara, icantaqueri: —¿Paita picantantarori oca? Te oncameetsateji poamaimatea. ");
INSERT INTO cniNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ari ipitsocashijeitacari Jesoshi iroamerepee, yamenajeitanaqueri. Irosati ishintsitsatantacariri Petero: —Piquempetacari Satanashi. Pijate, te pincameetsateji. Piquempejeitacari atiri, te pinquenqueshireempa. Te pioteroji icoacaaquenari Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Impoiji icajemiri Jesoshi apatojeitachari aisati iroamere. Icantiri: —Ariorica picoaque poijajeitena, eiro pantirotsi caari cameetsatatsi picoashiyevetari avirori. Poijajeitanaquena, pinquearioventajeitenaro maaroni noncoacaaquempiri: piojeite ariorica pincamimentena. ");
INSERT INTO cniNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Terica pincoyeji pincamimentena, patsipetashita pitimi, ainti pijate Sharincaveniqui. Iro cantaincha ariorica pincamimentena, aisati ariorica pinquemisantacayeteri atiri, eiro patsipetashitarotsi: pincantaitatiyempani panee anta inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ariorica pashijeitearo maaroni timayetatsiri aca quipatsiqui, aintiquea pijate Sharincaveniqui, tempa pantsipetashitearo pashiyetearo. ");
INSERT INTO cniNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ariorica pijate Sharincaveniqui, ¿jaoca pincanteari pijatanteari inquitequi? ");
INSERT INTO cniNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tseencantatsiri inajeiti maaroni timajeitatsiri, aisati yantapinijeitiro caari cameetsatatsi. Noponeaca inquitequi, natiritapaaque. Coajica nojataje inquitequi: meeca, ariorica pipashiventacaana, aisati ariorica pipashiventacaaro noneane, coajica nompiapaajerica, nompashiventacaapeempi avirori. Aisati ariorica nompiaje nompincatsaritasanotapaaque, nonquempetapaaqueari Apa, aisati nontsipajeitapaaqueari inampirepee. ");
INSERT INTO cniNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aisati icantajiri Jesoshi: —Queariotaque oca noncamantasanotempiri. Pamene, acarajeitaque meeca aca. Eirotarica picamajeititsi, ari pineavaqueri Tasorentsi impoque, impincatsaritapaaque, intasorentsitapaaque. ");
INSERT INTO cniNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Avisanaque 6 quitaiteri. Yaanaqueri Jesoshi yora Petero, Santiaco, aisati Joa, ijivatanaqueri anta antearoqui toncaari. Ari itimajeitapaaque apaniro. Ipashinitanaca Jesoshi, ipashinitimotanaqueri oijajeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Oshipaquireanaque iitsaare. Oquitamarotanaque catsini. Aca quipatsiqui te aneeroji catsini quempetearoneri. ");
INSERT INTO cniNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Imapocapaaca, iconijatimotapaaqueri Iriashini aisati Moishishini, iquenquetsatacaapaaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ineaveetashitanaca Petero: —Oametanari, tempa ocameetsatasanoti pamaquena aca, noneantaquempiri. Meeca nocoaque novetsicajeitempi mava pancotsijaniqui: aparoni pashi, aparoni irashi Moishishi, iro otsipa irashi Iriashi iriori. ");
INSERT INTO cniNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Itsaroasanojeitanaque catsini, irootaque caari iotanta Petero paitarica incanterimeri. ");
INSERT INTO cniNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Otsimancajeitapaaqueri mencori. Omapocanaca irineane Tasorentsi mencoriqui, icantajeitaqueri: —Iriotaque notomi nonintasanotiri, pinquemisanteri. ");
INSERT INTO cniNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Intsipaite yamenayevetanaca iroamere, tecatsi irinee, irinti apaniro Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Irosati ipiajeitantanaja, yoirincajeitanaja. Icantasanotiri Jesoshi: —Eiroyea picamantacotirotsi oca pineaqueri. Coajica noncame. Ariorica nontinaanaje, irosati pincamantacotantenari oca pineaqueri meeca. Tempa noponeaca inquitequi, natiritapaaque. ");
INSERT INTO cniNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ari iquemajeivetavacari, irosati isampitavacantanaca paita ojitari oca icantiriri Jesoshi: “Coajica noncame. Nontinaanaje aisati”. ");
INSERT INTO cniNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Isampijeitaqueri: —¿Paita icantantari oametantirori sanquenarentsi: “Tequeratarica impoque Quirishito, irijivatapaaque Iriashini”? ");
INSERT INTO cniNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iriori Jesoshi yacanaqueri: —Queario icanteetiri: “Irijivatapaaque Iriashini, iroameetsajeitapaaque maaroni”. Noponeaca narori inquitequi, natiritapaaque, tempa naro isanquenatacotiniri peerani: “Oshequi inquemaatsicatearo, aisati oshequi intseencajeitavaqueri”. ¿Paita icantantaroniri oca? ");
INSERT INTO cniNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Meeca noncamantempi: aitaque peerani ipocaji aisati Iriashini. Oshequi yantanayetaqueri, imoncarataquero isanquenatacotiteetacariniri. ");
INSERT INTO cniNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ari ipiajeitanaja anta isavicajeitaquenta iroamerepee pashini. Ineajeitapaaqueri itsipajeitapaacari oshequi apatotimentacariri. Itimi oametantirori sanquenarentsi, ineanajeitiri yora iroamerepee Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ari ineajeitavaqueri Jesoshi, ipocaji, yoasanotavaqueri cavaco. Ishiashijeitanacari, ivetsajeitavacari. ");
INSERT INTO cniNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Isampitapaaqueri: —¿Paita pineanatacojeitiri? ");
INSERT INTO cniNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yacanaqueri aparoni shirampari, icanti: —Oametanari, namaquempiri notomi. Yatajeaoncapinitiri camaari. Imasontiaqueri notomi. ");
INSERT INTO cniNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Irajiricapaajeririca, ipishoncajiri quipatsiqui, ishimoretacaanacari, yatsicanajitacaanacari, iquisoporoquitacaanacari. Nocantavetari poamere: “Poavisacotajeri”. Teve, te irimateroji. ");
INSERT INTO cniNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yacanaqueri Jesoshi: —Te pinquemisantimajeiteji. ¿Jaoca oncarate piojeite? Noametapinijeivetaquempi, iro cantaincha te pinquemisantajeitavaque. Jentsite, pamaquenarite pitomi. ");
INSERT INTO cniNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ari yamaqueneri. Yora camaari, ineapaaqueri Jesoshi. Yampitsitacaanacari jananequi, ipariacaanaqueri quipatsiqui, poron. Ipinaironcapinaironcatanaca, ishimoretanaque ivantequi. ");
INSERT INTO cniNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yora Jesoshi isampitaqueri iriri jananequi: —¿Jaoca ocaratiri intantanacari? Yacanaqueri: —Ainiroquerani ijananequitapaini. ");
INSERT INTO cniNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Oshequi yojocacaapinitari paamariqui, aisati nijaqui. Icoaveta iroamayerime. Pitasoncantirica, pineshinoncatajena, poavisacotajenari. ");
INSERT INTO cniNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Icanti Jesoshi: —¿Paita picantantanari: “Pitasoncantirica”? Pinquemisanterica, aitaque irimataquempiro Tasorentsi paitapeerica. ");
INSERT INTO cniNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Antearojenca icanti iriri jananequi: —Noquemisantaveta. Tericampa nonquemisantasanote, pinquemisantacaasanotena avinti. ");
INSERT INTO cniNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iriori Jesoshi ineavaqueri ishiashijeitapaacari oshequi atiri. Iquisatsataqueri camaari, icantiri: —Avironirotaque camaari. Pimasontitacanti, pimayempitacanti. Meeca nocantasanotimpi, poimpacanajeriqueti, eiro patajeaoncajiritsi aisati. ");
INSERT INTO cniNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Icajemanaque camaari, yampitsitacaanacari jananequi, yojocanajiri. Yora jananequi iquempevetanacari camatsiri. Oshequi cantayetanaintsi: —Camanaque inaque. ");
INSERT INTO cniNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Iro cantaincha yacatsavacotajiri Jesoshi, yoitinaajiri, icatianaja iriori. ");
INSERT INTO cniNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Impoiji iqueajeitapaaji pancotsiqui. Iojeitaca iroamere, isampijeitiri: —¿Paitaquea caari nomatantaro narori noavisacoteri? ");
INSERT INTO cniNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yacanaqueri: —Oshequi ishintsiti yora camaari, irootaque caari pimatantari poavisacotajeri yora yatajeaonquiri. Aisati maaroni quempejeitariri, eiro pimajeitiritsi. Iro cantaincha, pincantasanoteririca Tasorentsi, ari iramitacotempi poavisacotajeri yatajeaoncane camaari. ");
INSERT INTO cniNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ari yovaanaja Jesoshi anta, iquenanaji Carireaqui. Ari icoaque iroameteri iroamerepee apaniro, irootaque imanantanajari ijajeitanaji. Icantanaqueri: —Noponeaca narori inquitequi, natiritapaaque: coajica iraacaanteetena. Irayena atiri, iroyena. Ari noncamasanovetaquea, impoiji, omavatapaaque quitaiteri, ari nontinaanaje aisati. ");
INSERT INTO cniNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iro cantaincha te iriojeitavaqueroji iriori oca icamantavetacariri. Itsaroajeitanaque irisampiterime. ");
INSERT INTO cniNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ari yareejeitapaaca Caperenaoqui, isavicajeitapaaque pancotsiqui. Isampitiri Jesoshi iroamere: —¿Paita picantavacaanacari avotsiqui? ");
INSERT INTO cniNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Imajerejeitanaque iriori, ipashiventajeitanaca. Icantavacaajeitanaca anta avotsiqui, icanti: —Meeca acarajeitica, ¿janicampa anacotantatsineri impincatsarite? ");
INSERT INTO cniNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ari isaviqui Jesoshi. Icajemiri iroamere, icantiri: —Ariorica pincoye pimpincatsariventante, pintacojeiteari pishaninca maaroni, aisati pamitacojeiteri, pineshinoncajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yamaqueneri aparoni jananequi. Isatecapaaqueneri nianqui, yavitsanotavaqueri. Icanti: ");
INSERT INTO cniNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pishirejeitena narori, impoiji pincavintsayeri jananequi. Ariorica pincavintsayeri, aisati narori, pincavintsayena. Aisati oquempetaca, ariorica pincavintsayena, te naro pincavintsaasanote, irintiquea Apa tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Impoiji yora Joa icantanaqueri: —Oametanari, noneajeitaqueri shirampari, icanti: “Noquemisantaqueri Jesoshi, irootaque nojocantacariri camaari”. Te meeca ancarajeiteriji iriori aca, irootaque notsaneacotantariri. ");
INSERT INTO cniNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Icanti Jesoshi: —Eiro pitsaneacotaritsi. Tempa nomatacaaqueri itasoncanti, eiro meeca icantimatanatsi irinti. ");
INSERT INTO cniNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Janicarica caari quisanenteene iriotaque acarajeitiri. ");
INSERT INTO cniNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aisati icantiri Jesoshi: —Ariorica iriotavaquempi atiri aviro quemisantanari, irootaque incavintsantavaquempiri, aitaque impinateri Apa. Queariotaque oca nocamantasanotimpiri. ");
INSERT INTO cniNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jeri yoca jananequi, quemisantanari: eiro catsini pantacairitsi caari cameetsatatsi. Pantacayeririca, iroasanquetayempi Tasorentsi, pashinoncaasanotanaquea. Oncameetsateme pincamiteame peerani, eiro pashinoncaitame. ");
INSERT INTO cniNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jero oca noshiacantempiri meeca piotanteari te oncameetsateji catsini pantero caari cameetsatatsi. Ariorica antacayempiro paco caari cameetsatatsi, pimpeshero. Aitaque ocameetsatiri pijapontsoquitanaje inquitequi, oncanteata anta paneantasanotapaajeari. Te oncameetsateji catsini ontime apite paco: eirorica pipeshirotsi, irootaque pijatanteari Sharincaveniqui. Aitaque anta otimiri paamari caari tsivacanetatsi, aisati iriori yora quenitsi caari caamanetatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Eiro anta icamitsi quenitsi, aisati eiro otsivacanetitsi paamari iroori. ");
INSERT INTO cniNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aisati ariorica antacayempiro piiti caari cameetsatatsi, pimpesajero. Aitaque ocameatsatiri pijapontsoquitanaje inquitequi, oncanteata anta paneantasanotantapaajeari. Te oncameetsateji ontime apite piiti: eirorica pipeshirotsi, irootaque pijatanteari Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Eiro anta icamitsi quenitsi. Aisati eiro otsivacanetitsi paamari iroori. ");
INSERT INTO cniNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aisati ariorica antacayempi poqui caari cameetsatatsi, pinquitsoreero. Ari ocameetsatiri pijanaroquitanaje anta ipincatsaritinta Tasorentsi. Te oncameetsate ontime apite poqui: eirorica piquitsoreirotsi, irootaque irojocanteetempiri Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Eiro anta icamitsi quenitsi. Aisati eiro otsivacanetitsi paamari iroori. ");
INSERT INTO cniNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Avirojeitaque quemisantajeitanari, irootaque inquisajeitantempiri caari quemisantajeitatsi. Ariorica pinquemisantajeitena, ompomerentsitimotempi. ");
INSERT INTO cniNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ocameetsati tivi. Irompa ariorica ompeanaquea ovoteare, tecatsi oncantajea ompoteataje aisati. Aisati piquempetaca avirori: ariorica paacameetsatavacaajeitea, tempa ocameetsati: pincanteani paacameetsatavacaajeitea, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ari yovaanaja Jesoshi, iquenanaji Joreaqui. Aisati ijataji intatiquero Joriraniqui. Yapatotimentajari aisati oshequi atiri, yoamejeitapaajiri. Tempa aitaque yametaro yoametantapiniti. ");
INSERT INTO cniNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ipocashitapaaqueri variseo. Icoaveta incomitacayearime Jesoshi, irootaque isampijeitantapaacariri: —¿Oshinetantampa irojocajero shirampari ijina? ");
INSERT INTO cniNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yacavaqueri: —¿Paitampa icantimpiniri Moishishi? ");
INSERT INTO cniNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yacajeitanaqueri iriori: —Icantini Moishishi: “Pisanquenatajenero pijina, pincamantajero: ‘Nojocajempi’. Impoijiquea oshinetantajea irosati pojocantajearori”. ");
INSERT INTO cniNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Icantanaqueri Jesoshi: —Te incoaveteaji Tasorentsi pojocajero pijina, iro cantaincha te ontimeji piquenqueshireantari, irootaque isanquenatantimpironiri Moishishini oca. ");
INSERT INTO cniNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Peerani intantacarori yovetsicantaque Tasorentsi, yovetsicaqueri shirampari. Aisati iroori tsinane yovetsicaquero. ");
INSERT INTO cniNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Irootaque yojocantariri shirampari iriri, aisati iriniro, irantearori ijina. ");
INSERT INTO cniNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ari icarati shirampari, aisati tsinane: apite inavetaca. Iro cantaincha, ariorica irayero ijina, inquempetaquea apaniro irinaque: quiso iroavacaya. ");
INSERT INTO cniNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ari ineaqueri Tasorentsi apaniro inaque, meeca eiro pinijantareacaajiritsi. ");
INSERT INTO cniNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ari itimapaaji anta pancotsiqui. Isampitajiri aisati iroamere: —¿Jaoca ocantari oca picantaqueriri? ");
INSERT INTO cniNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Icantiri: —Janicarica joquerone ijina, ariorica iraaje otsipa tsinane, tempa iraimentearo ijinasanori. ");
INSERT INTO cniNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aisati oquempeta iroori tsinane, ariorica ojocajeri ojime, aajerica pashini shirampari, tempa aimenteari ojimesanori iroori. ");
INSERT INTO cniNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ari yameetapaaqueneri jananequipee, icantapaaqueri Jesoshi: —Pincanteri Tasorentsi cameetsa irisavicacaajeiteri yoca jananequipee. Iro cantaincha icantavaqueri iroamerepee: —Eiro pamiritsi jananequipee, pashereiricari oametanari. ");
INSERT INTO cniNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Te onimoteriji Jesoshi yantiri iroamere. Icantiri: —Pishineteri impocashitenata jananequi. Eiro pitsaneanatsi. Pineaqueri yoca jananequi, ishirejeitaquena: ipincatsariventajeitiri Tasorentsi maaroni quempejeitariri iriori. ");
INSERT INTO cniNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Queariotaque oca nocamantasanotimpiri, irinti jananequi ipincatsatiri Tasorentsi. Irompa irinti yora caari shiiri jananequi, yora caari pincatsatiri Tasorentsi, eiro ijatitsi irinti anta ipincatsaritinta. ");
INSERT INTO cniNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yavitsanojeitavaqueri jananequi, ipamitaqueri iitoqui. Icantajeitiri: —Cameetsa irineshinoncatempi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ari ijataji Jesoshi, iquenanaji avotsiqui. Ishiapaaca aparoni shirampari, itiyeroashitapaacari. Icantiri: —Oametantatsiri, cameetsari pini. ¿Paitampa nanteri naneantajeari, noncantaitatiyempani? ");
INSERT INTO cniNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Icantiri: —¿Paita picantantanari: “Cameetsari pini”? Tecatsi cameetsatatsine, irinti apaniro Tasorentsi icameetsati. ");
INSERT INTO cniNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Piovintsataquero oca icantacantiniri Moishishini: “Eiro poantitsi. Eiro paimentarotsi pijina. Eiro paimentaritsi pijime. Eiro picoshititsi. Eiro pitseeyacotaritsi atiri. Eiro pamatavitantitsi paitanteariri yashiyetari pishaninca. Pimpincatsateri piri, aisati piniro”. ");
INSERT INTO cniNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Icantanaqueri iriori: —Pamene, ainironi nevancaritapaini, aitaque notsoteaquero maaroni ocapee, irosati meeca. ");
INSERT INTO cniNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yora Jesoshi, yamenanaqueri, inintaqueri. Icantaqueri: —Ainiro apanivani caari pimati. Pijate meeca pimpimantayetero maaroni pashiyetari. Pimpashijeiteari caari ashitaarantachane, pashini paapaaje pivaararo inquitequi. Impoiji, tsame, poijatanaquena. ");
INSERT INTO cniNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Iquemavaitiiri icantaqueriri, yoashiretanaca. Iro yoashiretantanacari oshequi timimotiriri irovaararo. Icantavorotanaca, ijatanaji. ");
INSERT INTO cniNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ari ipitsocashitanacari Jesoshi iroamere, icantiri: —Yora ashitaarantachari opomerentsitimotari irijate anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iquemavaitiiri iroamere, yoajeitanaque cavaco. Yapiitajiniri aisati Jesoshi, icantiri: —Evancari, aitaque opomerentsitaca pijate anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tempa opomerentsitaca inqueero cameyo omoroqui quitsapi. Iroquea irointi pomerentsitasanotachari irijate ashitaarantachari anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yoajeitanaqueri cavaco catsini iriori. Icantavacaanaca: —¿Janicampa meeca avisacotajantsine? Opomerentsitasanotaca. ");
INSERT INTO cniNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yamenanaqueri Jesoshi, icanti: —Eiro imatashitarotsi atiri iroavisacotajea irisati, irintiquea Tasorentsi matacayerine iroavisacotajeri. Tecatsi pomerentsitimotearine irinti. ");
INSERT INTO cniNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Impoiji Petero icantanaqueri iriori: —Naroquea nainti, aitaque nojocayetaquero maaroni, paitarica nashijeiveitaniri, noijatanaquempi meeca avirori. ");
INSERT INTO cniNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Icanti Jesoshi: —Queariotaque oca noncantempiri. Ariorica pincoaque poijatanaquena, eiro patsipetashitarotsi pojocayetero pinampi, pirentipee, pitsiropee, piniro, piri, pijananequitepee, poanepee. Aisati ariorica pincoaque pinquemisantacayeri pishaninca, eiro patsipetashitarotsi. ");
INSERT INTO cniNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Queario, inquishimentempiro piquemisantaquena, ompomerentsivetea, iro cantaincha eiro patsipetashitarotsi. Ariorica pojocanaquero aparo, impajempi Tasorentsi 100: pivancopee, pirentipee, pitsiropee, piniropee, pijananequitepee, poanepee, maaroni. Aitaque coajica ontimimojeitempi oshequi anta paneasanojeitapaajenta, pincantaitatiyempani. ");
INSERT INTO cniNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ainiro pincatsarivetachari meeca, iro cantaincha coajica eiro ipincatsaritajitsi; ainiro meeca yora caari pincatsariyetatsi, iro cantaincha coajica impincatsarite irinti. ");
INSERT INTO cniNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","33","Ari iquenajeitanaque avotsiqui, irotaintsi irijajeite Jerosarequi, ijivatanaque Jesoshi. Yoajeitanaqueri cavaco oijajeitiriri, aisati itsaroajeitanaque. Ari yapatotiri aisati yora 12 iroamere, icantiri: —Pinquemena. Tempa noponeaca inquitequi, natiritapaaque. Meeca ajate Jerosarequi. Coajica iraacanteetena anta, iraavaquena jivatacaajeitiriri saserotepee, aisati oametantirori sanquenarentsi, iroacantaquena. Iraacantajena aisati, iraantenari pashinisati atiri. ");
INSERT INTO cniNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Irishirontimentajeitaquena, inquitiojena, impasanatena, iroyena. Omavatapaaque quitaiteri, irosati nontinaantanajeari. ");
INSERT INTO cniNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ipoqui quempeji Santiaco, jeri Joa, yora itomipee Severeo. Icantiri: —Oametantatsiri. Nocoaque pishinetenaro paitarica noncoacotempiri. ");
INSERT INTO cniNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Icantavaqueri Jesoshi: —¿Paita picoiri noshinetempiri? ");
INSERT INTO cniNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Icantiri: —Coajica pimpincatsaritasanote, pishinetena nosaviquimotempi pacosanoriqui. Irio iyeca irisaviquimotempi pampatequi, nonquempejeitempi avirori pipincatsariti. ");
INSERT INTO cniNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Icantiri Jesoshi: —Te pioteji paitarica picantaquenari. Pamene, oshequi nonquematsicatearo narori, ¿arimpa pimatero oshequi pinquematsicatearo avirori? ");
INSERT INTO cniNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Icantanaque iroamere: —Je, ario nomataquero. Icantiri: —Je, aitaque ontime coajica pinquematsicateari. ");
INSERT INTO cniNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Iro cantaincha tecatsi noncantea noshinetempi pisavique nacosanoriqui, aisati nampatequi. Irintiquea cantatsineri Tasorentsi janicarica saviquimotenaneri: iotitacarini peerani yora saviquimotenaneri. ");
INSERT INTO cniNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iquemajeitantacariri yora itsipapee iroamere, iquisanentanaqueri Santiaco aisati Joa. ");
INSERT INTO cniNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Icantajeitiri Jesoshi: —Caate, pimpocajeite. Pioti itimi ivincatsaritepee pashinipee atiri. Iperanayetacari ishaninca iriori. Aisati yora savicacaajeitiriri iriori, iperanajeitacari ishaninca. ");
INSERT INTO cniNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Eiro piquempejeitaritsi avirori. Aintiquea ariorica pincoaque pimpincatsariventajeiteri pishaninca, pintacojeiteari maaroni pitsipajeitari. ");
INSERT INTO cniNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aisati ariorica pincoaque pisavicacante, ari pintacojeiteari maaroni pitsipajeitari. ");
INSERT INTO cniNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Noponeaca narori inquitequi, natiritapaaque. Te iro nompocantea nonampiteari atiri, irointiquea nopocanta nintacojeiteari itsipapee. Aisati noncamimenteri oshequi atiri, noavisacotanteariri. ");
INSERT INTO cniNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ari yareetaca Jesoshi anta nampitsiqui pajitachari Jerico. Yovaanaja aisati, itsipajeitanacari iroamerepee aisati oshequi apatojeitainchari. Ainiro isavicaiti avotsinampiqui shirampari pajitachari Timeojani, iriotaque itomi Timeo. Icamarajati Timeojani, icoacotapinitiri atiri impashiteari quirequi. ");
INSERT INTO cniNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Iquemacotavaqueri impoque Jesoshi, yora nasaretesati. Iroaquera iquemacotavaqueri, icajemavaqueri, icantiri: —Jesoshi, tempa aviro ishanincani Iravirini, pineshinoncatapaajena narori. ");
INSERT INTO cniNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Oshequi atiri ishintsitsajeitaqueri: —Pimajerete. Iro cantaincha aiquero catsini icajemasanotanaji aisati: —Aviro quempetajariri Iravirini. Pineshinoncatena narori. ");
INSERT INTO cniNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Icatiapaaca Jesoshi, icanti: —Pincajemeri. Icajemeetiri camarajari, icanteetiri: —Piveshireanaquea, pincatianaje. Icajemimpi yonta. ");
INSERT INTO cniNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Irosati yojocantanacaro yoicotari, icatianaca, cati. Ijatashitanaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Icantavaqueri Jesoshi: —¿Paita picoacotanari? ¿Jaoca noncantajempiri? Yacanaqueri camarajari: —Apa, nocoaque namenaje. ");
INSERT INTO cniNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Icantiri Jesoshi: —Meeca pijataje. Pishiretaquena, irootaque pavisacotantajeari. Irosati yamenantanaja, yoijatanajiri avotsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Iquempejijeitapaacaro Jerosarequi, Vetejajequi, aisati Vetaniaqui: onaquenta toncaari pajitachari Orivomashi. Yora Jesoshi itiancaqueri iroamere apite, ");
INSERT INTO cniNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","icantavaqueri: —Pijatapainte anta nampitsiqui onta amontetacari. Pareetapaaquearica, pineapaaqueri aparoni voro, tequera irantearitasanote, tequera inquijacoyeeteari. Ainiro itsatacota: pintsatacoreapeeri, pamaquenari. ");
INSERT INTO cniNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ariorica incanteetavaquempi: “¿Paitaquea pitsatacoreantariri voro?” Ari pincantanaqueri: “Irio coiriri Avincatsarite. Coajica iroimpiajempiri aisati”. Ari irishinetempiri. ");
INSERT INTO cniNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ari ijatanaque iroamere. Ineapaaqueri voro anta avotsiqui. Itsatacota ashitacoroqui pancotsi. Itsatacoreapaaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ainiro isaviqui atiri, isampitavaqueri: —¿Paita pantiri? ¿Paita pitsatacoreantariri voro? ");
INSERT INTO cniNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yacanaqueri, icantiri oca icantavaqueriri Jesoshi. Ari ishinetavaqueri yaanaqueri voro. ");
INSERT INTO cniNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ari yacatsatacotanaqueneri Jesoshi. Yoanquetaqueneri imititsaqui iitsaarepee, impoiji iquijacotacari. ");
INSERT INTO cniNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ari yaniitacaanaqueri avotsiqui, ipincatsajeitavaqueri maaroni ishaninca, imaaroncajeitaqueneri quitsaarentsipee avotsiqui. Yora itsipapee ipesaqueneri inchatoshi, aisati yoaqueneri avotsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yora jivajeitaqueriri aisati impoijeitaqueriri, icajemajeitanaque: —Jeritapaaque oavisacojeiteeneri, tsame aacameetsajeitavaqueri. Coraqueni, iriotaque itiancaqueeneri Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Peerani Iravirini ipincatsariventirini ashanincani: meecaquea, impincatsariventaquee yoca aneavaquerica. Iriotaque ishanincani Iravirini. Tsame ampincatsajeiteri Tasorentsi inquitequiniri. ");
INSERT INTO cniNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ari yareejeitapaaca Jerosarequi, iqueapaaque ivancoqui Tasorentsi. Itsoteaquero yamenayetaquero, iro cantaincha ishaavijiiteanaque catsirincaiteri. Isoquijanaji, ijatanaji Vetaniaqui. Itsipajeitanajari iroamerepee. ");
INSERT INTO cniNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ari oquitaitetamanaji aisati, yojocanajiro Vetania, irijate Jerosarequi. Nianqui aavetacari itashe. ");
INSERT INTO cniNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ineaquero paricoti inchato, pajitachari iyera. Otimaveta oshi. Ari ijatashitiro, icoavetapaacaro oitsoqui. Te aneeroji, irointi oshi. Tequeratsita omoncaratajea oitsoquitantajeari. ");
INSERT INTO cniNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Icantanaqueri Jesoshi iroamere: —Tecatsi iroajeitajeari atiri oitsoqui aisati. ");
INSERT INTO cniNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ari yareejeitaja aisati Jerosarequi. Iqueapaaji ivancoqui Tasorentsi. Yojocajeitapaaqueri maaroni pimantajeivetachari aisati maaroni amanantajeivetachari. Itatsinquitayetapaaqueri imesatepee yora pinavacaavetariri iirequite. Aisati itatsinquitayetapaaqueri isavicamentopee pimantajeivetariri sampaquiti. ");
INSERT INTO cniNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Itsaneapitsajeitacari irayetanaqueme vaararontsi anta ivancoqui Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ari yoametantaque, icantajeitiri: —Peerani isanquenatironi irineane Tasorentsi, icantini: “Irootaque oca novanco. Aca inquenquetsatacaajeitantenari maaroni atiri”. Tempa piojeivetaro. Iro cantaincha avirojei pipeaquero ivanco coshinti. ");
INSERT INTO cniNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ari iquemajeitavaqueri maaroni yora apatotimentariri, irootaque yoajeitantanacariri cavaco. Aisati iquemacotaqueri jivatacaajeitiriri saserote, oametantirori sanquenarentsi, maaroni. Icantajeivetaca: —¿Jaoca ancantaniroteriri Jesoshi, avanteariri? Iro cantaincha tecatsi incanteri, itsaroacaajeitacari. Tempa ipincatsajeitiri atiri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Iqueanaji catsirincaiteri, ari yojocanajiro Jesoshi nampitsi. ");
INSERT INTO cniNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Oquitaitetamanaji aisati, ipianaja anta onaquenta iyera. Ineapaaquero, ocamanaque, irosati anta ovaritsaqui. ");
INSERT INTO cniNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Iquenqueshiretaquero Petero icantanaqueri Jesoshi oshaiteji. Icantiri: —Oametanari, pamenero iyeraca poamaimatanaqueri oshaiteji. Camanaque. ");
INSERT INTO cniNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yacanaqueri Jesoshi: —Pishireteari Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Queariotaque oca noncamantajeitempiri. Ariorica pincanteri Tasorentsi: “Povaajero otishinta, poviincajero anta incajarequi”. Eirorica pitseencashiretitsi, aisati ariorica pioshiretasanotaque ovaanaquea, ari irimataquempiro. ");
INSERT INTO cniNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Irootaque noncamantantempirori oca: ariorica pinquenquetsatacayeri Tasorentsi, paitarica pincanteriri, pinquenqueshirete: “Aitaque irimataquenaro nocantaqueriri”. Pishiretearirica, aitaque irimataquempiro. ");
INSERT INTO cniNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ariorica pinquenquetsatacayeri Tasorentsi, pijivate pincavintsayeri pishaninca: eiro piquishimentiritsi paitapeerica iranteri. Impoiji aisati avirori, eiro iquishimentimpirotsi Apa Tasorentsi pantayetiri avirori. ");
INSERT INTO cniNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Eirorica picavintsairitsi pishaninca, eiro icavintsaimpitsi avirori Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ari yareejeitanaja aisati Jerosarequi, yaniitamanaji anta ivancoqui Tasorentsi. Yora jivatacaajeitiriri saserotepee, oametantirori sanquenarentsi, aisati savicacaantatsiri ipocashijeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Icantajeitapaaqueri: —¿Janica oametimpirori pipincatsaritantari pimayetantarori pantayetiri? ¿Janicampa meeca peaquempiri pincatsari, pimayetantacarori pantayetiri? ");
INSERT INTO cniNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Icantavaqueri Jesoshi: —Meeca aparo nosampijeitempi avirori. Ariorica pancaquena avirori, noncamantempiro. ");
INSERT INTO cniNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yora Joa ivaotisatantayeti. ¿Janicampa tianquiriri ivaotisatantayeti? ¿Iriompa Tasorentsi tianquiriri? Tericampa, ¿irintimpa atiri tianquiriri? Panquenaqueti. ");
INSERT INTO cniNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ari icantavacaanaca saserotepee: —Ariorica ancanteri: “Iriotaque Tasorentsi tianquiriri”, icanteecari: “¿Paita caari piquemisantantari Joa?” ");
INSERT INTO cniNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aisati eiro acantiritsi: “Iriotaque atiri tianquiriri”. Iquisheecari. Pineaquero, yora saserote itsaroacaajeitacari atiripee; maaroni atiri ineacameetsajeitaqueri Joa, icantajeiti: “Tempa irio Tasorentsi tianquiriri Joa icamantanti”. ");
INSERT INTO cniNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Irootaque icantantariri saserotepee: —Te nioteji janicarica tianquiriri. Icanti Jesoshi: —Aisati narori, eiro nocantimpitsi janicarica tiancanari nopincatsaritantari nomatantarori oca. ");
INSERT INTO cniNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Impoiji ishiacantiniri oca, icantiri: —Ipanquitiro ovamashi shirampari. Itantotacotaquero otsapiqui, yovetsicashitaquero onanteari ovaja. Impoiji yovetsiquiro shitamencotsi anta jenoqui iramenacoventantearori maaroni. Impoiji aisati icantiri tsameetacantatsiri: “Pishentenaro maaroni: coajica nompinatempi cameetsa”. Impoiniji ijatanaque pashiniqui quipatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Osamanitapainti iraacanaque oitsoqui ova. Ari yora ashitarori itiancavetari inampire aparo, iraaranteme ova. ");
INSERT INTO cniNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Te impavaqueriji, irointi yaanirotavaqueri, tapi; ipasatashitavacari, tac, tac. Yoipiavajiri, tecatsi iraanaque. ");
INSERT INTO cniNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ari itiancavetaca aisati itsipa inampire. Iposainatavaqueri iitoqui, toc, toc, yoashinoncaavaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Itiancavetaca pashini aisati. Yoavaqueri, shemi. Aisati itiancavetacari oshequi itsipapee: aparopee ipasanatavaqueri, irio itsipapee yoavaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Apanivaniquea itimanaque itomi iriori, inintasanotiri. Icantashiretanaque iriori: “Irioricampa irinti notomi irio impincatsatavaqueri”. Itiancavetacari iriori. ");
INSERT INTO cniNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Iro cantaincha icantavacaanaca tsameetacotirori: “Jeritapaaque itomi ashitarori, ariorica incamaque iriri, iriotaque yoca ashitasanotajearoneri. Tsame avavaqueri, impoijiquea ashijeitajearota ainti irovamashite”. ");
INSERT INTO cniNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ari yaavaqueri, yoanirotavaqueri, shemi. Yojocaqueri otsapitapaaca ovamashi. ");
INSERT INTO cniNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Paita piquenqueshirejeitiri? ¿Jaoca incanteriri ashitarori irovamashite? Tempa impoque irinti, impoyereapaaqueri iratiritepee. Pashini iramenaje shentajenerine. ");
INSERT INTO cniNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tempa pineanatiro sanquenarentsi. Ocanti: “Yora vetsiqueronemeri pancotsi itseencajiro mapi intincamitantearomeri ivanco, icanti: ‘Te oncameetsateji’. ");
INSERT INTO cniNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iro cantaincha Avincatsarite ipeajiro mapica otincami ivanco, ocameetsatasanoti. Tempa irootaque avantanacari cavaco”. ");
INSERT INTO cniNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iotacojeitavaquero icantaqueri Jesoshi, iriotaque ishiacaaventaqueri. Icoajeiveta iraajeitanaquerime, iro cantaincha itsaroacaajeitacari yora apatotimentajeitacariri. Ari yojocajeitanajiri, ijajeitanaji. ");
INSERT INTO cniNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Itianqueetiri variseopee aisati oijatiriri Eroreshi. Icoavetaca incomitacayearime irineane Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yareetapaaca, icantapaaqueri: —Oametantatsiri, niojeitaquempi avirotaque cameetsatatsiri. Te oncantimoneentanaquempiji paitarica icantayetiri atiri, te pintsaroacayeariji. Tampatica poametantiro icoacaajeiteeri Tasorentsi. ¿Ocameetsatimpa nomperi ivincatsarite oromasati quirequi? ¿Tericampa oncameetsateji? ¿Nomperimpa? ¿Eirompa nopiritsi? ");
INSERT INTO cniNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Iotacotaqueri Jesoshi, iramataviterime yoca sampitaqueriri. Icantiri: —¿Paita picoantacari pincomitacayename? Pamaquenari quirequi, ponijayenari. ");
INSERT INTO cniNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ari aparo yamaqueneri. Isampijeitiri: —¿Janicampa shiacantachari ivoroqui? ¿Janicampa ashitarori ivajiro? Yacajeitanaqueri iriori, icantiri: —Irio ashitaro Shisari, yora ivincatsarite oromasati. ");
INSERT INTO cniNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Icantiri: —Panteneri pincatsari icoacaimpiri, aisati panteneri Tasorentsi icoacaimpiri iriori. Yoajeitanaqueri cavaco yora sampijeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Icantapiniti saroseo: “Eiro itinaajatsi camatsiri”. Ari ipocashitiri iriori Jesoshi, isampitapaaqueri: ");
INSERT INTO cniNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Oametantatsiri, isanquenajeitanaroni peerani Moishishi, icantini: “Ariorica incame shirampari, irojocanaquero ijinani. Eirorica itimacaanaquerotsi itomi, cameetsa iraitajeri irirentini ijinani. Ariorica intimacayero itomitsori camaintsiri, irishiacantajeitajeri itomisanori iriori”. ");
INSERT INTO cniNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ari. Ainiro shirampari irirenti. Yaaveta ijina, impoiji icamaque, toren. Tequera intimacayeroji itomi. ");
INSERT INTO cniNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yaavetajaro irirentini apitetapaintsiri. Icamaque iriori, aisati te intimacayeroji itomi. Aisati iquempetaja iriori yora mavatapaintsiri. ");
INSERT INTO cniNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aisati iriori iquempejeitaca maaroni irirentini. Tecatsi intimacayero itomi. Impoiji ocamaque iroori tsinane, toren. ");
INSERT INTO cniNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Coajica ariorica intinaajeitanaje camajeitaintsiri, ¿janicampa aajeroneri? Tempa aitaque ijinantajeiveitaroni maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Icantiri Jesoshi: —Te pioteroji sanquenarentsi, aisati te piotacoteriji Tasorentsi, tempa irootaque picomitantacarori oca. ");
INSERT INTO cniNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Icamajeitaque, toren. Coajica intinaajeitanaje aisati. Iro cantaincha eiro yaajitsi aisati ijina. Eiro itimajitsi aacaajerineri aisati. Aitaque irishiapaajeari inampire Tasorentsi savicatsiri jenoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Meeca noncamantempi: aitaque intinaajeitanaje camajeitatsiri. Tempa pineanataquero isanquenare Moishishi. Oquenquetsatacotiro quitotsequishi, otaavetaca iro cantaincha te ontsonqueaji. Anta iquemaquero peerani Moishishi icantiriri Tasorentsi: “Narotaque Tasorentsi, icantani ipincatsajeitaquena Avarama, Isaca, aisati Jacovo”. ");
INSERT INTO cniNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pineaquero, aneatsi ini iriorijei, irosati icantani iquemisantiri Tasorentsi. Te inquemisantajeji camaintsiri, irintiquea aneatsiri. Pineaquero, te ampoyereempaji. Oshequi picomitasanotaca avirori. ");
INSERT INTO cniNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iquempejitapaaque aparoni oametantirori sanquenarentsi. Iquemapaaqueri icantavacaanaca. Iotacotapaaqueri Jesoshi, cameetsa yoametavaqueri saroseo. Ari isampitapaaqueri: —¿Paita icoacaasanoteeri Tasorentsi? ");
INSERT INTO cniNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yacanaqueri Jesoshi: —Tempa isanquenataqueeroni Moishishi peerani icoacaasanoteeri Tasorentsi. Jero oca isanquenatiniri: “Noshaninca, pinquemisantajeitena. Yora Tasorentsi, iriotaque Avincatsarite, apaniro ipincatsariti irinti. ");
INSERT INTO cniNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Oshequi catsini pinintasanoteri, pincanteani. Aisati pinquenqueshiretapiniteri”. ");
INSERT INTO cniNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aisati isanquenatini: “Oquempetaca avisati nintajancha, aisati pinquempejeiteri maaroni picarajeitiri, pinintajeiteri”. Irootaque inintacaasanojeitaqueeri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Icantanaqueri oametantirori sanquenarentsi: —Je, aitaque. Queariotasanotaque oca picantaqueri. Apaniro ini Tasorentsi, tecatsi pashini. ");
INSERT INTO cniNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Cameetsa oshequi catsini anintasanoteri, anquenqueshiretapiniteri. Aisati oquempeta arosati nintajancha, aisati anquempeteri maaroni acarajeitiri, anintajeiteri iriori. Irootaque icoacaasanotaqueeri Tasorentsi. Te iro incoasanote atayeneri poshiniri. ");
INSERT INTO cniNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iquemaqueri Jesoshi, cameetsa icantaqueri, icantiri: —Irotaintsi pimpincatsateri Tasorentsi, impincatsariventantempiri iriori. Impoiji itsaroacaajeitacari atiripee irisampitajerime aisati. ");
INSERT INTO cniNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yoametanti Jesoshi anta ivancoqui Tasorentsi: —Icanti oametantirori sanquenarentsi: “Yora Quirishito, irishanincatasanotajeari Iravirini”. ¿Paita icantantarori? ");
INSERT INTO cniNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tempa iro Ishire Tasorentsi sanquenatacairiniri Iravirini. Isanquenataqueroni oca: “Yora Tasorentsi icantiri novincatsarite: ‘Pisavique aca nacosanoriqui, pincaratena ampincatsarijeite. Aitaque noasanquetaajeiteri maaroni quisajeivetaquempiri’ ”. ");
INSERT INTO cniNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tempa iquenquetsatacotitarini Iravirini Quirishito, icantiri: “Novincatsarite”. ¿Jaoca incanteari Iravirini impincatsatajeri ishaninca impoitajantsiri itimi? Ari iquemajeitavaqueri, iquimoshirejeitanaque oshequi apatotimentacariri. ");
INSERT INTO cniNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ari yoametantaji aisati, icanti: —Paamayeariyea oametantirori sanquenarentsi. Icoashita iroaneencashitea, irishemetacayero iitsaare, inquenaquenatsantsatacaayetero. Icoaque irineacameetsatashiteari ishaninca anta nampitsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aisati ariorica ijatapiniti anta pancotsiqui yapatojeitanta, icoyeapinitiro savicamentotsi cameetsatasanotatsiri. Aisati ariorica irampatojeitea ishaninca iroajeitearica, icoaque iriori irisatecapeempa nianqui incarajeitanteariri pincatsaripee. ");
INSERT INTO cniNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yaapitsanirotaquero maaroni timimovetarori camajimentaaro. Osamani ineanatashimempeavetacari Tasorentsi, vero, vero. Oshequi yamatavitantaveta, iro cantaincha coajicani iroasanquetasanotaqueri catsini Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ari isavicaque Jesoshi, imontetacaro yoapiniyetantariri quirequi. Yamenajeitaqueri oshequi pocajeitatsiri, itetapinitiri iirequite yoantaririqui. Ipoqui oshequi ashitaarantincari, itetapaaque oshequi catsini iirequite. ");
INSERT INTO cniNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Opocapaaque iroori aparoni camajimentaaro ashinoncaincaro. Otetapaaque iroori apimentaquite quirequijaniqui, te impinaveteaji irinti. ");
INSERT INTO cniNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Icajemiri iroamere, icantiri: —Queariotaque oca noncamantempiri: capichaji otevetaca oca ashinoncaincaro, iro cantaincha ineacameetsatasanotaquero Tasorentsi. Tempa opaqueri maaroni timimovetacarori: tecatsi meeca amanantantajeari oyeari. Irintiquea yora ashitaarantincari, oshequi itejeivetaca, iro cantaincha te irineacameetsatasanoteriji Tasorentsi: tempa oshequitatsi iirequite iquempoyeanontari. ");
INSERT INTO cniNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Impoiji isoquijanaji Jesoshi. Icantiri aparoni iroamere: —Oametanari. Pamenero mapica yovetsicantarori ivanco Tasorentsi: antearo oni, aisati ocameetsati pancotsi. ");
INSERT INTO cniNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Icantiri Jesoshi: —Pineaquero jaoca ocantari oca mapipanco. Antearo onaveta, iro cantaincha coajica intireetajero, ojocayetanaquea nijanteaji mapi. Ompoyereajea pancotsi. ");
INSERT INTO cniNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Impoiji isavicanaque Jesoshi toncaariqui, opajita Orivomashi. Imontetapaaro ivanco Tasorentsi. Imananaca Petero, Santiaco, Joa, jeri aisati Antirishi: ijatashijeitaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Isampitapaaqueri: —Pincamantajeitena. ¿Jaoca oncarate ontireantajeari ivanconta Tasorentsi? Ariorica coajica omoncaratapeempa ontireanteari, ¿jaoca noncanteari niotantajeari? ");
INSERT INTO cniNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Icantiri Jesoshi: —Yamataviyeetimpicari. ");
INSERT INTO cniNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Intime oshequi pocayetatsineri, cantatsineri: “Narotaque nainti Quirishito”. Iramatavitapeeri oshequi atiri. ");
INSERT INTO cniNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ariorica pinquemacoteri imanatavacaaca atiri, aisati pinquemeri pashini cantatsine: “Irimanatavacaajeitea atiri”. Iro cantaincha eiro pitsaroanaquetsi. Aitaque oncanteari coajicani, irimanatavacaapinitea, iro cantaincha tequerata omoncarateaji nompincatsaritantapaajeari. ");
INSERT INTO cniNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yora atiri inquisapinitanaqueri itsipapee. Oshequi irimanatavacaajeitea itsipasatipee atiri. Onicapiniyetanaquea quipatsi, aisati intasheapinijeitanaque atiripee. Aiquero ojatatiye, inquematsicajeitearo paitapeerica, irashinoncaasanojeitanaquea. ");
INSERT INTO cniNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Aisati icantaqueri Jesoshi: —Paamaventea. Icantacoventimpicari, yaimpicari yora oametavacainchari. Ariorica pijate anta yapatojeitantari aitaque impasanayeetavaquempiri, tac, tac. Iraanaquempi anta itiminta savicacaantatsiri, aisati anta itiminta pincatsari. Ariorica irayempi, irosati pinquemisantacayeri, iravisacotantajeari. ");
INSERT INTO cniNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Irijivajeite maaroni atiri inquemacojeitena noavisacotanti, impoiji nompocaje, nompincatsaritasanotapaaque. ");
INSERT INTO cniNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ariorica irayeetanaquempi anta, ariorica incantacoventeetempi, eiro picantashiretitsi: “¿Jaoca noncanteriri?” Aitaque oametaquempi Ishire Tasorentsi paitarica pincanteriri. Irootaque neanatacaaquempine, eiro pineanatashitatsi avirori. ");
INSERT INTO cniNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Coajica aparo shirampari iraacanteri irirenti, iroacantanteariri. Pashini iraacanteri itomi. Aisati pashini atiri inquisanaqueri ashitariri, iroacanteri. ");
INSERT INTO cniNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Piquemisantaquena, irootaque inquisanteetempiri maaroni. Queario, ompomerentsitimojeitempi, iro cantaincha ariorica pincanteani pishiretasanotena, aitaque noavisacotajempi. ");
INSERT INTO cniNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aisati icantiri Jesoshi: —Ariorica pineanatero isanquenareni Iranirini, piotavaquero icantiniri: irashinoncaajeitanaquea atiri. Icanti intime ivancoqui Tasorentsi caari cameetsatatsine. Te oncameetsateji intime anta. Ariorica pintime Joreaqui, aisati pineeririca yoranqui, pishintsite pishiajeitanaque anta toncaariqui. ");
INSERT INTO cniNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ariorica pisavique pancotsiqui saiteriqui, eiro piqueapanajantitsi paantapanajantearori paitapeerica, irointi pishianaque. ");
INSERT INTO cniNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aisati pisaviquerica oantsiqui, eiro pipiapanajantatsi paantapanajantearori piitsaare. ");
INSERT INTO cniNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ariorica omoncaratapaaquea maaroni oca, joo, oshequi ashinoncayetanaquea tsomonteyetatsine, aisati ashinoncaaquea antsotayerine ojananequite: ompomerentsitimojeitearo oshianaque. ");
INSERT INTO cniNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pincanteri Tasorentsi, oncanteata ariorica pishianaque, eirotarica oparii incani. Pishiasanojeitanaque, yaimpicari quisajeitempineri. ");
INSERT INTO cniNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Jero aisati icantiri Jesoshi: —Aitaque coajica irashinoncaasanojeitanaquea catsini oshequi atiri. Peerani te irineapiniveitearoni quempetearoneri oca, jeri yora maaroni intacaroniri, te irineeroni. Coajica aisati maaroni impoitajantsineri, eiro ineirotsi aisati quempetearoneri oca. ");
INSERT INTO cniNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Irishintsite iroimajerentajeiteri Tasorentsi: eirorica, impoyereavacaajeiteame. Iro iroimajeretanteariri, incavintsaajeiteri quemisantajeiterineri, tempa irinintajeiteri iriori. ");
INSERT INTO cniNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pamene, ariorica incamanteetempi: “Pineavaqueri: jerica Quirishito”, eiro piquemisantiritsi. Aisati ariorica incanteete: “Pineaqueri: jeri yonta”, eiro piquemisantiritsi catsini, itseeyani. ");
INSERT INTO cniNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Impocapaaque amatavitantatsine, incantapaaque: “Narotaque nainti Quirishito, narotaque camantantatsiri”. Intasorentsimempeavetapaaquea, incoavetaquea pinquemisantavaqueri, irimayetempiro caari pineapiniti. Incoavetea iramataviterime quemisantajeitiriri Tasorentsi, iro cantaincha tecatsi incanteri. ");
INSERT INTO cniNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Paamaventea. Nojivatitaquempiro nocamantasanojeititaquempiro maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Aisati icantiri: —Ariorica irovecaraanaquero iquisavacaajeita, impoijiquea intsitenitanaque catsirincaiteri, eiro iquempetajatsi meeca. Aisati eiro iquitasantetanajitsi cashiri. ");
INSERT INTO cniNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Aisati impariaarantanaque impoquiropee, imponeaquea inquitequi, imporocayetanaque itsipapee. ");
INSERT INTO cniNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Noponeaca inquitequi, natiritapaaque: coajica irineajeitavajena atiri nonquenapaaje mencoriqui. Nontasorentsitasanotapaaque, nompincatsaritapaaque. ");
INSERT INTO cniNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aisati nontiancajeiteri nonampirepee irampatojeiteri maaroni quemisantajeitanari. Imponeanaquea maaroni quipatsipeequi. ");
INSERT INTO cniNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yovaajiniri aisati, icantiri: —Jero oca piotantearori oshiacaaventiri iyera. Iroaquerarica oshiocajempequiyetaje, ariorica ontimanaje oshi, piotaque irotajantsi osarintsitapaaje. ");
INSERT INTO cniNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aisati, ariorica pineajeitavaquero maaroni oca nocamantayetaquempiri, piote quempejitapaajana, irotaintsi nompocashitajantempi. ");
INSERT INTO cniNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Queariotaque oca nocamantimpiri. Tequeratsita pincamajeite avirori, omoncaratapaaquea maaroni oca nocamantimpiri. ");
INSERT INTO cniNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ompeajea inquite aisati quipatsi, irompa irointi noneane, eiro opeajatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jeroca aisati icantiri: —Jaocarica oncarate quitaiteri, jaocarica incarate catsirincaiteri, tecatsi iotatsine. Aisati te irioteji yora inampire Tasorentsi jenoquiniri. Pamene, narotaque itomi Tasorentsi, iro cantaincha te nioteji. Irintiquea iotatsi apaniro Apa. ");
INSERT INTO cniNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Paamaventea, aisati paamaajeitena. Te pioteji jaoca oncarate nompocantajeari. ");
INSERT INTO cniNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nonquempeteari shirampari, jatatsiri paricoti. Ariorica yojocanaquero ivanco, icantajeitanaqueri maaroni inampirepee paitarica irantajeiteneriri. Aisati iriori yora shentiniriri ivanco icantanaqueri iriori: “Paamaajenayea”. ");
INSERT INTO cniNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Irootaque nocantajeitantimpiri: paamaajeitajenayea avirori. Te pioteji jaoca oncarate nompocantajeari: ariorica inqueanaje catsirincaiteri, ariorica nianquiite tsiteniri, ariorica irineaje teapa, ariorica onquitamaroiteamanaje quitaiteri nompocaje. ");
INSERT INTO cniNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Paamaventea, paamaasanojeitena. Ariorica nompocaje, nomapocapaimpicari. Noneapaimpicari, maatsimpi catsini. ");
INSERT INTO cniNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Oca nocantimpiri, irootaque nocantajeitaqueriri maaroni atiri. Paamaventasanojeitea, paamaasanojeitena, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ari apitenivani quitaiteri omoncaratajea quitaiteri yavisantaniri. Iro iquenqueshiretantarori quitaiteri peerani yavisantaniri inampire Tasorentsi, oajeitiriri itomipee ejipitosati. Quitaiteri yavisantaniri te iroapinitearoji tapiachari tanta, irointi caari tapiacha. Ari icoaque jivatacaajeitiriri saserotepee aisati oametantirori sanquenarentsi jaoca incanteriri iramataviteri Jesoshi, iraanteariri. Aitaque icoaveta iroyerime Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Icanti: —Eiro aantaritsi quitaiteri yavisantaniri: iquisacoventajeitaricari atiripee. ");
INSERT INTO cniNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ari isavicaque Jesoshi Vetaniaqui, anta ivancoqui Shimo patsaaveitachaniri. Oshequi oajeitachari anta. Opocapaaque tsinane, amacotapaaquero casancajari. Iojataca oja nararo, oshequi ovinaro. Ocameetsatasanoti onantari, iro yovetsiqueetiri mapi pajitachari aravashitoro. Ocarajacotapaaqueneri, osaitantapaacari iitoqui. ");
INSERT INTO cniNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Itimanaque aparopee quisaneentajeitaquerori. Icantavacaanaca iriori: —¿Paitampa meeca aparajatantacarori oca casancajari? ");
INSERT INTO cniNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Arime ompimanterome, aantaquearome oshequi quirequi, impoijiquea ompayeterime ashinoncayetachari. Impoiji iquisatsajeivetacaro, ");
INSERT INTO cniNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","iro cantaincha icantiri Jesoshi: —Eiro piquishimentirotsi. ¿Paita pashereantarori? Ocameetsatasanoti osaitaquena. ");
INSERT INTO cniNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aitaque incantaitatiyempani ashinoncaincari: pincanteani pincarajeiteri, aisati pineapiniteri. Ariorica pincoaque pintacoteari, aitaque pimataquero, pimpaqueri. Irompa nainti, eiro nocantaitatiani nontsipajeitempi aca. ");
INSERT INTO cniNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Te omayeteroji paitapeerica, irointi omataque osaitaquena. Tempa asaitapinitiri camatsiri, iro cantaincha te iriotacoteaji. Irointi oca tsinane ojivataquena osaitaquena, aneatsiquerana noni. Iotaquena noncamaque. ");
INSERT INTO cniNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Queariotaque oca noncamantempiri: jaocarica incamantantajeitero atiri noneane, incamantacotero antaqueri oca tsinaneca, inquenqueshireajeitantearori. ");
INSERT INTO cniNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ainiro iriori Jorashi Ishicariote icarajeitiri iroamere Jesoshi. Ijatanaque apaniro anta itiminta jivatacaajeitiriri saserotepee, incantacoventanteariri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iquemajeitavaqueri ora icantapaaqueriri, iquimoshirejeitanaque, icantiri: —Cameetsataque: oshequi nompinajeitempi quirequi. Impoiji iquenqueshireti Jorashi: —¿Jaoca noncanteriri naacantanteariri? ¿Jaoca oncarate? ");
INSERT INTO cniNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Moncaratapaaca quitaiteri yoajeitantarori tanta, caari tapiacha. Aisati yoari ovishajaniqui: yametapinijeitaro yoajeitari quitaiteriqui iquenqueshiretapinitiro yavisantaniri oantatsiri peerani. Isampitiri Jesoshi iroamere: —¿Jaoca picoaqueri novetsicajeitero avajeiteari? ");
INSERT INTO cniNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ari itiancaque iroamere apite, icantiri: —Pijate nampitsiquinta. Aitaque pintonquiotavaqueari aparoni shirampari, iraacote chomoqui nija. Poijatanaqueri iriori. ");
INSERT INTO cniNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jaocarica anta inqueapaajeri, aitaque iniri ashitarori ivanco; iriotaque pineanatapeeri. Pincantapaaqueri: “Icanti oametantatsiri: ‘¿Jaocame nosavicantapeempari, noacantapeempariri noamere?’ ” ");
INSERT INTO cniNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Irosati ironijantavaquempirori anta jenoqui oshitamencotanta: antearo oni. Timatsi ovetsicajeitaca maaroni avantayetearori: apanivaniji povetsicajeitapaaquero ayeari. ");
INSERT INTO cniNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ari ijatanaque iroamere nampitsiqui, ineapaaquero oca icantaqueriri, impoiji yovetsicapaaquero yoari. ");
INSERT INTO cniNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ari ishaavijiiteanaque catsirincaiteri. Yareetapaaca iriori Jesoshi, itsipajeitapaacari iroamerepee. ");
INSERT INTO cniNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Isavicajeitapaaque, yoajeitapaaca, icantiri Jesoshi: —Queariotaque oca noncamantempiri. Meeca acarajeitica, timatsi aacantenaneri, oacojeitaqueeri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yoashirejeitanaca, icantiri aparo: —¿Narompa aacantempineri? Aisati itsipa: —¿Narompa? Aisati itsipapee isampijeitanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Icanti Jesoshi: —Tempa iriotaque aacantenaneri chaantacotaquenari meeca nomatitatequi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Noponeaca inquitequi, natiritapaaque. Irotanaintsi noncame: aitaque ontsataaquea isanquenatacotitaquenari. Iro cantaincha irashinoncaitaquea yora aacantenaneri. Eirome itimime iriori, eirome yaacantaname, aisati iriori eirome iquematsicatarome, coajica. ");
INSERT INTO cniNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ainiro yoajeitaca, yaaquero Jesoshi tanta. Ipasonquitiri iriri, icarajaquero, ipajeitaqueri iroamere. Icantiri: —Paajeitero, tempa narotaque camimentajeitempineri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Impoiji yaaquero pajoqui aisati. Ipasonquitaqueri iriri, ipacojeitaqueri, irajeitavaquero. ");
INSERT INTO cniNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Icantajeitaqueri: —Irootaque niraja amparajatimenterineri oshequi atiri. Ariorica noncamimentempi, piojeitaquero queario icantaquempiri Tasorentsi, iroavisacojeitempi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Queariotaque oca nocamantajeitimpiri. Eiro meeca napiitajirotsi aca quipatsiqui nirajero ovaja. Ariorica nosavicapaaje anta ipincatsaritinta Tasorentsi, ari nirapaajero pashinijari. ");
INSERT INTO cniNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ari ipampoyeaventajeitanaqueri Tasorentsi, impoiji ijajeitanaji anta toncaariqui, opajitanta Orivomashi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Icantajeitaqueri Jesoshi: —Coajica pojocajeitanaquena. Aitaque isanquenatacotiteetaquempini: “Noyeri yora shentiriri ovisha, impoiji inquenashiveetanaquea irovishate”. ");
INSERT INTO cniNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Iro cantaincha, coajica nontinaanaje, nojivajeitanaquempi anta Carireaqui. ");
INSERT INTO cniNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Icantiri Petero: —Ariorica irojocajeitempi maaroni irinti yoca, irompa nainti, eiro nojoquimpitsi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Icantiri: —Queariotaque oca noncamantempiri: meeca tsiteniriqui, tequeratsitarica irampiitajerota irineaje teapa, oshequi pintsaroanaque. Oncarate mava pincante: “Te nioteriji Jesoshi”. ");
INSERT INTO cniNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Iro cantaincha icantasanoti Petero: —Eiro nojoquimpitsi. Ariorica ancarajeitavacayea ancamajeite, eiro nocantitsi: “Te nioteriji”. Aisati omoncarataca icantajeitaqueri maaroni itsipapee. ");
INSERT INTO cniNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ari yareejeitapaaca anta Jetsemaniqui. Icantajeitiri iroamere: —Pisavicajeitavaqueta aca, nonquenquetsatacaavaquerita Apa. ");
INSERT INTO cniNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Irintiquea yaanaqueri Petero, Santiaco, jeri Joa. Iquenqueshireanaca, aisati yoashiretanaca. ");
INSERT INTO cniNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Icantiri: —Oshequi catsini noashiretasanotanaca. Pisavicavaqueta aca, pisaaquiteyea. ");
INSERT INTO cniNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Ari yovaanaca capichaji ara. Itiyeroanaca quipatsiqui, iquenquetsatacairi iriri. Icantiri: —Apa, aviro avinti mayetirori maaroni, paitapeerica. Nocoavetaca poavisacotename oca nonquematsicateari, iro cantaincha eiro pantirotsi nocoavetari narori, pantenaro picoacaaquenari avinti. ");
INSERT INTO cniNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Impoiji ipianaja anta isavicaquenta iroamere. Ineapaatiiri, maajeitaque. Icantapaaqueri Petero: —Shimo, ¿maaquempimpa? Tempa pamavetimatero pisaaquitimate capichaji. ");
INSERT INTO cniNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pisaaquite. Pincanteri Tasorentsi oncanteataquea ariorica incoaque camaari irantacayetempiro caari cameetsatatsi, eiroquea pantantarotsi. Queario picoasanovetaca pantenerime Tasorentsi icoacaaquempiri, iro cantaincha te pimateroji. ");
INSERT INTO cniNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ipianaja aisati, iquenquetsatacaajiri aisati iriri. Irosati icantajiri icantaqueriri incaranqui. ");
INSERT INTO cniNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ipiapaaja aisati, ineajeitapaajiri, maajeitaji aisati. Oshequi catsini aajeitaqueri ivochoquine. Oshequi ipashiventajeitaca, te irioteji paitarica incanteriri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ari ipianaja aisati mavatapaintsiri. Impoiji icantapaaqueri: —Meecaquea pimaajeite, pimaoreajeite. Noponeaca inquitequi, natiritapaaque. Moncaratapaaca, aitaque meeca icantacoventaquena: irayena meeca caari quemisantatsi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Meeca pintinaanaje, tsame ajataje. Ja, jeri yocatapaaque aacantenaneri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Irosatiquera ineaveeti Jesoshi, ipocapaaque yora Jorashi, iriotaque tsipaveitariniri yora iroamere Jesoshi. Itsipajeitapaacari meeca oshequi atiri. Yamajeitapaaque isaviritepee, aisati inchaquiipee. Iriojeitaque itiancane jivatacaajeitiriri saserotepee, jeri itiancane oametantirori sanquenarentsi, jeri savicacantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Icantitajeitacari yora Jorashi: —Meeca noncamantasanotempi piotantapeempariri Jesoshi: pineaquena nonintavorotapaaqueri, pajiricapeeri. Paanaqueriyea, pishentasanoteriyea. ");
INSERT INTO cniNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ari ipocapaaque, iquempejitapaacari. Icantapaaqueri: —Oametanari. Inintavoronirotapaaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yajiricajeitapaaqueri, tapi, yaajeitanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aparo iroamere yaaquero isavirite. Ipeshitaqueri iyempita inampire ivincatsarite saserote, peti. ");
INSERT INTO cniNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Icantajeitavaqueri Jesoshi: —¿Narompa coshinti? ¿Paita pamashitantanari pisaviritepee aisati inchaquiipee? Paashitanaquena, eiro noshiapitsatimpitsi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aitaque maaroni quitaiteri notsipajeivetaquempi anta ivancoqui Tasorentsi, noametantini. Ja, payenaniqueti. Meecaquea omoncarataca ocantiri sanquenarentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iriori iroamere, yojocajeitanaqueri, ishiajeitanaca maaroni. ");
INSERT INTO cniNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Aparoquea evancari oijavetanacariri Jesoshi. Te inquitsaatanaqueaji, irointi yampinaicanaca ivashicaro. Yajiriqueevetavacari, ");
INSERT INTO cniNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","itsaneanaca iriori, yojocanaitiiro ivashicaro, ishiatsempequitanaca. ");
INSERT INTO cniNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Impoiji yaajeitanaqueri Jesoshi ivincatsaritequi saserote. Yapatojeitimentapaacari maaroni jivatacaajeitiriri saserotepee, savicacaajeitantatsiri, aisati oametantirori sanquenarentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Iriori Petero yoijatacoventavetanacari Jesoshi, iro cantaincha nijanteaji, irosati yareetantapaaca anta ivancoqui saserote. Isaviquimotapaaqueri yora nampirentsipee, itatapaaquero paamari. ");
INSERT INTO cniNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ainiro aisati anta pancotsiqui ivincatsarite saserote aisati maaroni oametavacaajeitachari. Isampijeitiri atiri: —¿Pineacotaquerimpa yantiro Jesoshi caari cameetsatatsi noacantanteariri? Iro cantaincha, tecatsi irineacoteri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ipocapaaque oshequi tseeyacotacariri, te omoncarateaji icantayetaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aparopee catianaincha, itseeyacotashitacari, icanti: ");
INSERT INTO cniNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Noquemajeitaqueri Jesoshi, icanti: “Coajica noshoveajero ivanco Tasorentsi, oca yovetsicane atiri. Ari oncarate mava quitaiteri novetsicajeneri nainti pashini ivanco, caari yovetsiqui iriori atiri”. ");
INSERT INTO cniNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Iro cantaincha te omocaratavacayeaji icantayevetacari. ");
INSERT INTO cniNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Icatianaca nianqui yora ivincatsarite saserote. Isampitaqueri Jesoshi: —¿Paita caari paquimatanta? ¿Paita ojita oca icantacoyetaquempiri yoca? ");
INSERT INTO cniNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Iriori Jesoshi imajeretaque, te iranqueji. Yapiitaqueri yora ivincatsarite saserote: —¿Avirompa Quirishitotatsiri, itomi Tasorentsi noneacameetsajeitiri? ");
INSERT INTO cniNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yacanaqueri: —Narotaque. Aitaque noponeaca narori inquitequi, natiritapaaque. Coajica pineajena nosavique anta iracosanoriqui Apa, noncarateri nompincatsarijeite. Aisati pineavajena nonquenantapaajearo onta mencorinta, nompiaje aisati quipatsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Yora ivincatsarite saserote yaitanacaro iitsaare, itsereanaquero, tsererere; iquisanaca. Icantanaque: —¿Paitampa meeca acoantari pashini camantacoterineri? ");
INSERT INTO cniNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Piquemajeitavaqueri meeca: ijitasorentsinirotacateemi. ¿Paita picoajeitiri? ¿Jaoca ancanteriri? Icantajeitanaque: —Ainiro irantane, cameetsa incame. ");
INSERT INTO cniNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ainiro aparopee quitiojayetaqueriri. Impoiji ipashicavorotaqueri, aisati ipasanatiri. Icantiri: —Pincamantenate janica pasavorotaquempiri. Aisati iriori nampirentsipee, ipasanajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Isaviqui iriori Petero anta pancotsiqui ishaaviji. Opocapaaque aparoni inampire saserote. ");
INSERT INTO cniNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Oneapaaqueri Petero, itaataque paamari. Amenashetapaaqueri, sorerere, ocantiri: —Aviro tsipatariri yora Jesoshi nasaretesati. ");
INSERT INTO cniNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Itsaroanaque iriori, icantanaque: —Jm, te nioteji paitarica picantiri. Te nonquemempiji aisati. Isoquijanaji saiteriqui, ijatanaque anta otsapiqui. Ineanaque teapa. ");
INSERT INTO cniNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Oneajiri aisati nampirentsi. Ocantajeitiri yora ocarajeitaqueri: —Iriotaque yoca tsipatariri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aisati icantaji Petero. Ari osamanitapainti capichaji. Yapiitajiri yocapee, icantiri: —Queariosanotaque. Aitaque pitsipatarini iriori, avirotaque carireasati. ");
INSERT INTO cniNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Icantasanotiri: —Te nioteriji yora shirampari picantaqueri. Ioti Tasorentsi queario nocantaque: notseeyanirica, nocoaque iroasanquetayenata Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yapiitajiro ineanaji teapa. Iquenqueshiretanajiro Petero icantaqueriri Jesoshi: “Tequeratarica irampiitanajerota irineaje teapa, oncarate mava pincante: ‘Te noneeriji Jesoshi’ ”. Ari yoashiretanaca Petero, irosati iraantanaca, jii, jii. ");
INSERT INTO cniNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ari oquitaitetamani, yapatojeitamanaja yora jivatacaajeitiriri saserotepee, savicacaantajeitatsiri, oametantirori sanquenarentsi, maaroni. Aisati yapatojeitaca maaroni pashini oametavacainchari. Icantavacaimentajeitacari Jesoshi. Ari yoisoyeetanaqueri Jesoshi, yaanaqueri anta, ipapaaqueri Pirato. ");
INSERT INTO cniNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Isampitavaqueri: —¿Avirompa ivincatsarite jorio? Iriori Jesoshi yacanaqueri: —Je, naro. ");
INSERT INTO cniNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Icantajeiti jivatacaajeitiriri saserotepee: —Oshequi yantaniroyetaqueri yoca, te incameetsateji. ");
INSERT INTO cniNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yapiitajiri Pirato, isampitajiri: —¿Paitampa caari pacanta? Piquemavaqueri oshequi icantacotashijeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Te iranqueji Jesoshi. Irosatiquea iriori Pirato yoantanacariri cavaco. ");
INSERT INTO cniNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ari ainiro yametacari: maaroni osarintsi, ariorica omoncaratapaaja yavisantaniri, yoimisoquijapinitiri aparoni yoiminqueetiri. Yoimisoquijajiri janicarica icoajiri atiripee. ");
INSERT INTO cniNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ainiro meeca yashitacotaca anta atiripee coajeivetachari irojoquerime pincatsari: ipajita aparoni Varavashi. Iro irojocantearimeri pincatsari, yoantaque. ");
INSERT INTO cniNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ari ijatashijeitaqueri yora apatojeitainchari, icantajeitapaaqueri: —Meecaquea nocoi pantajeitenaro oca pametari: poimisoquijajenari aparoni poiminquiri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yacavaqueri Pirato: —¿Iriompa picoaqueri noimisoquijajempiri yora pivincatsarite? ");
INSERT INTO cniNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Iotaque Pirato oshequi ipincatsajeitiri atiri Jesoshi, irootaque iquisajeitantacariri saserotepee, yaacantantacariri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ari yora saserote iquenaquenayetanaque, icantajeitaqueri atiripee: —Picantacoventiricari Jesoshi. Pincantajeiteri: “Irinti poimpacaajeri Varavashi”. ");
INSERT INTO cniNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Yapiitajiri aisati Pirato, icantiri: —¿Jaocampa meeca noncanteriri yoca pipincatsajeivetacari? ");
INSERT INTO cniNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Icajemajeitanaji aisati: —Pimpajacotacanteri coroshiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Isampitiri: —¿Paitampa yantaqueri nompajacotacantanteariri? Aiquero yovaapinijeitanaquero icajemajeitanaque: —Pimpajacotacanteri, pimpajacotacanteri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Icoanaque Pirato inquimoshiretacaajeitajeri yora atiripee, irosati yoipacantajariri Varavashi. Ja irintini Jesoshi ipasanatacantaqueri, ari yaacantaqueri impajacotacantanteariri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Iriori soraro yaanaqueri tsompoina ivancoqui Pirato. Ipajitironta pancotsi peretorio. Yora soraro icajemajeitaqueri maaroni itsipapee. ");
INSERT INTO cniNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","18","Itseencajeitanaqueri, ishirontimentajeitacari, icantiri: —¿Avirotaquempa ivincatsarite jorio? Jentsite, narori, nompincatsajeitempi. Tsame pinquitsaatearo quitioncanirori, aisati pamatseetearo amatseerentsi pinquempetanteariri pincatsari, impoiji nompincatsajeitantempiri. Iji, iji, iji. Ari iquitsaataqueri, aisati yantaqueneri totseequi, yamatseetaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ipasanatiri iitoqui, iro ipasatantacariri savoroqui. Iquitiojaqueri. Itiyeroashinirotacari, ineapincatsatamempeacari. ");
INSERT INTO cniNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ari oshequi yantavintsanataqueri, impoiji isapocajiri iitsaare quitioncanirori, iquitsaatajiri iitsaaresanori iriori. Impoiji yaanaqueri anta impajacotanteariri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nianqui avotsi ineaqueri soraro shirampari pajitachari Shimo, iriotaque shirenesati. Irio iriri Arijantero, jeri Irojo. Iponeanaja Shimo oantsiqui, iro iravisanaqueme, iro cantaincha yaavaqueri soraro, iperanatavacari: —Panatanaqueneri Jesoshi coroshi. ");
INSERT INTO cniNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ari yaajeitanaqueri Jesoshi anta opajitanta Coricota. Iro ipajitantarori otishi oshiaquero iitonaroqui atiri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ipavetari ovaja oconoajataca aavintarontsi pajitachari mira. Iro cantaincha te irireeroji. ");
INSERT INTO cniNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Impoiji ipajacojeitaqueri, aisati ineantacaro mapijaniqui, iriojeitanteari janicarica aitajerineri iitsaareni. Ipavacaayetacaro. ");
INSERT INTO cniNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ari ijenoquitapaaque catsirincaiteri, irosati ipajacotantacariri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Isanquenataquero sanquenarentsi, ocanti: “Iriotaque ivincatsarite jorio”. Ipatacaaquero coroshiqui jenioquiji. ");
INSERT INTO cniNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ora pashini coroshi ipajacotaqueri apite coshinti. Aparo yoatiacotaqueri iracosanoriqui Jesoshi, irio itsipa yoatiacotaqueri irampatequi. ");
INSERT INTO cniNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Irootaque omoncaratantajari sanquenarentsi cantatsiniri: “Irishiacanteri caari cameetsatatsine”. ");
INSERT INTO cniNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ainiro anta avisayetatsiri icantimatanaqueri, aisati yavimacanaca, icantajeitiri: —Joo, aviro shoveajeronemeri ivanco Tasorentsi. Oncarateme mava quitaiteri povetsicajerome aisati. ");
INSERT INTO cniNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¿Arimpa pitasoncantashiyeta? Jentsite, pintasoncacoventajea avisati: poavisacotajea avisati, paniireanaje coroshiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Irosati icantaqueriri iriori yora jivatacaajeitiriri saserotepee, aisati oametantirori sanquenarentsi. Ishirontimentajeitacari, icantavacaajeitanaca: —Irintiquea itsipa yoavisacoti. Jaaquea iriori te iroavisacotajeaji. ");
INSERT INTO cniNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jeri Quirishitovetachari, pincatsariventerinemeri ijorioririnte. Jentsite, amenavaquerita ariorica iraniireanaje ara coroshiqui. Noneaqueririca, ari nonquemisantanaqueri. Aisati iriori tsipatacariri Jesoshi ipajacojeitaca, itseencaqueri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ari icaravetapaaca catsirincaiteri tampatica, otsitenitanaque maaroni quipatsiqui. Ari ishavijitanaji, iporeanaji aisati. ");
INSERT INTO cniNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Irosati icajemantanaca antearojenca Jesoshi, icanti: —Eroi, Eroi, irama savatani. Irootaque acantiri aneanequi: “Notasorentsite. Notasorentsite. ¿Paita pojocantaquenari?” ");
INSERT INTO cniNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iquemavetavacari aparopee shirampari, icanti: —Pinquemeri, icajemiri Iriashi. ");
INSERT INTO cniNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ari ishianaca aparo atiri, yoviincapaaqueneri quepishijariqui aajatirori. Yoisotacotaqueneri savoroquiiqui. Ipavetari irantsimicavaquerome. Icanti: —Ari icantavacata: amenavaquerita ariorica impocashitapaaqueri Iriashi iroaniitapaajeri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Antearojenca icajemanaque Jesoshi, icamanaque, toren. ");
INSERT INTO cniNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ainiro anta ivancoqui Tasorentsi antearo tocoya, tontari, opaincaca omoroqui. Intanaca jenoqui otsereamaotanaque, tsererere, irosati ishaaviji. Apitemaotanaji. ");
INSERT INTO cniNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ainiro imontetacari iyapitanote soraro. Ineavaqueri jaoca icantanacari Jesoshi, icamantanacari. Irootaque icantantacari: —Quearioteemi: iriotaque yoca shirampari itomi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Otimaiti paricoti aparopee tsinane, amenajeitiri. Ocarajeitaiti Maria Maquitarasato, jero aisati pashini Maria, irootaque iriniro Santiaco, jeri aisati Jose. Yora Santiaco impoitatsiri itimi. Aisati ocarajeitiri Sarome. ");
INSERT INTO cniNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ainiro itimaveitani Jesoshi anta Carireaqui, oijajeitirini maaroni oca tsinanepee. Intacojeitarini aisati. Otimaque meeca aca oshequi otsipapee tsinane. Itoncaantanacari Jesoshi anta Jerosarequi, irootaque oijajeitiriniri. ");
INSERT INTO cniNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ishavijiiteanaji catsirincaiteri. Iro quitaiteri meeca yovetsicajeitiro iroajeiteari osaitequera, tempa osaitequera quitaiteri imaoreantajeitari. ");
INSERT INTO cniNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ainiro Jose, yora poneachari Arimateaqui. Aitaque icarajeitiri yora oametavacaajeitainchari. Ineacameetsajeitiri atiripee. Yaamaari Tasorentsi, icoaque impincatsariventeri. Ipanacari iriori Pirato, ijatashitaqueri yamanantapaajiri yora Jesoshini. ");
INSERT INTO cniNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yoanaque cavaco Pirato. Iquenqueshiretanaque: “¿Icatimaitacampa icamanaque Jesoshi?” Ari icajemacantaqueri iyapitanote soraro. Isampitavaqueri: —¿Queariompa? ¿Camasanotanaquempa Jesoshi? ");
INSERT INTO cniNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Icantiri: —Je, camasanotaque ini. Irosati itiancantacariri Jose intijeri Jesoshini. ");
INSERT INTO cniNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yamanantaque Jose tocoya. Yoaniitaqueri Jesoshi, yapinaicacotaqueri tocoyaqui. Yoiponaaqueri omoroqui, anta imoqueetironta imperita. Itivironcashitanaqueri antearo mapi omoroqui. ");
INSERT INTO cniNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Oneacotaqueri jaoca yoaqueriri Maria Maquitarasato. Otsipataro Maria, ora iriniro Jose. ");
INSERT INTO cniNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Avisanaque quitaiteri imaoreantajeitari. Amanantanaque tsinane casancajari, ontiritantajearimeri Jesoshini. Ari opajitari iroori tiriterinemeri Maria Maquitarasato. Aisati iroori ocaratiro pashini Maria iriniro Santiaco, jero aisati iroori Sarome. ");
INSERT INTO cniNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ari capichaji quitaiteri ojatamani anta omoroqui yoyeevetacarinta. Iro tominco ojatantacari. Ari ijenoquitapaaque catsirincaiteri, irosati areetantapaaca. ");
INSERT INTO cniNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ocantavacaanaca: —¿Janicampa tivironqueerone ora mapi omoroquinta? Antearo oni, eiro aaveirotsi. ");
INSERT INTO cniNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Amenapaaque, oneapaaquero mapi, tivironcanaca. Antearo catsini onaveta. ");
INSERT INTO cniNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Oqueapaaquero omoroqui anta yoavetacarinta. Te oneapaajeriji ocoavetapaajari, irinti oneapaaque evancari, isavicaque acosanoriqui. Iquitsaataro quitsaarentsi quitamarori catsini. Oapaaque cavaco. ");
INSERT INTO cniNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Icantavaquero: —Eiro poitsi cavaco. Irio picoaveta yora Jesoshi nasaretesati, yora ipajacoyeetaqueri. Itinaanaja, te aneajeriji aca. Pamenerote aca yoyeevetacarica. ");
INSERT INTO cniNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pijataje meeca, pincamantapeeri iroamere. Aisati pincamanteri Petero. Pincantapaaqueri: “Irijivatanaquempi anta Carireaqui, aitaque pineapaajeriri anta. Tempa aitaque icamantitimpini”. ");
INSERT INTO cniNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ari osoquijanaji, oshianaca. Opioncanaque, oanaque cavaco catsini. Otsaroanaque, irootaque caari ocamantacotantari. ");
INSERT INTO cniNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Irootaque itinaantajari Jesoshi tominco. Iro intasanotajari yonijaajaro Maria Maquitarasato. Irootaque peerani yatajeaoncaveitaniri 7 camaari, iro cantaincha yoavisacotaqueroni. ");
INSERT INTO cniNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Irosatiquea ojatantanaca iroori ocamantapaaqueri yora itsipajeiveitaniri Jesoshi. Irosatiquera yoashiretacojeivetari, iraacojeivetari aisati. ");
INSERT INTO cniNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ari ocamantavetapaacari: —Tinaanaja Jesoshi, noneajiri. Te inquemisantavaqueroji. ");
INSERT INTO cniNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Impoiji ipashinivorotanaca Jesoshi, inijapaajari apite iroamereni, yaniijeitanaji anta oantsiqui. ");
INSERT INTO cniNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ari ipianaja yoca neaqueriri, icamantapaaqueri itsipapee. Aisati iquempetavaqueri, te inquemisantavaqueriji. ");
INSERT INTO cniNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Impoiji yoajeitaja iroamerepee, icarajeitaji 11. Irosati inijajeitantapaajariri Jesoshi. Icantajeitaqueri: —Tempa nocamantitimpini nontinaanaje: ¿paita caari piquemisantantana? Tempa ontime piquenqueshireantari. ¿Paita caari piquemisantantari neajanari incaranqui? ");
INSERT INTO cniNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pijajeite pintsoteanaquero maaroni quipatsiqui. Pincamantajeiteri maaroni atiri jaoca incantajeari iroavisacotantajeari iriori. ");
INSERT INTO cniNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Janicarica quemisantavaquerone ora pincamanteriri, aisati ariorica irivaotisatajea, aitaque iroavisacotajea. Irompa yora caari quemisantavaquerone, iroasanquetasanoteri Tasorentsi irinti. ");
INSERT INTO cniNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jaocarica pijajeiteri, intasoncacoventempi Tasorentsi, iriojeitanteari atiri queariotaque oca picantaqueriri. Nomatacayempiro poavisacotanteariri yatajeaoncane camaari. Pioyetero otsipapee neantsi pinquenquetsatacotantenari. ");
INSERT INTO cniNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ariorica pajiricaveteari maranque, ariorica irantsicavetempi, iro cantaincha eiro yoamaimpitsi. Aisati, ariorica pirero piantatsiri, eiro oamaimpitsi. Aisati ariorica pimpamiteri mantsiatatsiri aisati pincantacoventeri, ari iravisacojeitaje. ");
INSERT INTO cniNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Irootaque icantajeitaqueriri Avincatsarite Jesoshi, irosati yoancantanaja inquitequi, isavicapaaji anta iracosanoriqui Tasorentsi, icaratapaajiri ipincatsaritapaaji iriori. ");
INSERT INTO cniNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ari ijajeitanaque iroamerepeeni. Iquenaquenayetanaque, icamantantayetanaque jaocarica iquenanaqueri. Quiso yoiri Avincatsarite, yamitacojeitiri. Aisati itasoncantayetaque, iojeitantacari atiripee queariosanotaque icamantajeitapairiri. Aitaque ocanta. Ari ocarati. Narotaque sanquenatirori: Maricoshi");
INSERT INTO cniNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","¿Ainirompi Tiojiro? ¿Tecatsimpa oyempine? Meeca noninti nonquenquetsatacoteri Jesoquirishito. Icarajeitaque oshequi sanquenatacojeitaqueriri, icamantacoyetaquero yantayetaqueri. Ineajeitaqueri, aisati iquemacojeitaqueri, irootaque isanquenatacotantariri. Noneanataquero narori isanquenare, aisati nosampitacoyetaquero yantayetaqueri niotasanotantacarori, notsoteaquero maaroni. Meeca novaajempiro narori, nocoaque tampatica piotasanotero yantayetaqueri Jesoshi, piojeite te iramatavijeitempiji yora sanquenatirori. ");
INSERT INTO cniNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Peerani, ipincatsaritantari Eroreshi anta Joreaqui, itimini saserote pajitachari Sacariashi. Iriotaque ishanincani Aviashi: ariorica yantaveetiniri Tasorentsi anta ivancoqui, icarajeitiri ishanincasanori iriori. Opajita ijina Sacariashi Isavere, irootaque ishanincani Aaro. ");
INSERT INTO cniNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Quemisantincari ini iriori Sacariashi, aisati ijina. Icantani imayetaquero icantiriri Tasorentsi, iojeitiri atiri icameetsataque. ");
INSERT INTO cniNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Te intimeji itomipee: shiravaro oni ijina, aisati imoncaratavacaajeitaca yanteashipajeitaque. ");
INSERT INTO cniNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ari omoncarataca quitaiteri yantaveejeiti ishaninca. Yamejeitaro itiancapinitiri aparoni saserote itainiri Avincatsarite casancapatsari. ");
INSERT INTO cniNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Icantajeitiri Sacariashi ishaninca: —Meeca aviro queasanotatsine anta, pintayeneri Avincatsarite casancapatsari. ");
INSERT INTO cniNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ari iqueanaque, irinti yora apatojeitainchari isavicajeiti saiteriqui, iquenquetsatacaajeitiri Tasorentsi. Aitaque ariorica itaaquero casancapatsari, iquenquetsatacaajeitiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Anta tsompoina, imapocaqueri inampire Avincatsarite, icatiapaaca quempeji onantariqui casancapatsari, icatiapaaca irampatequi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ineantavacariri yoanaque cavaco, aisati oshequi itsaroanaque. ");
INSERT INTO cniNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Iro cantaincha icantaqueri: —Sacariashi, eiro pitsaroitsi. Timatsi picantaqueriri Tasorentsi; tempa iquemaquempi, irootaque ontimanteariri coajica pijina pitomi. Pimpajiteri Joa. ");
INSERT INTO cniNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Oshequi pinquimoshireventeari, aisati inquimoshireventajeiteari oshequi pishanincapee. ");
INSERT INTO cniNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aisati irineacameetsatasanoteri Tasorentsi iriori. Eiro irirotsi cachojari. Quiso oasanoteri Ishire Tasorentsi, tequeratsita intime, quiso oyeri: oncanteani oameteri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Oshequi inquemisantacaajeiteri pijorioririnte, impincatsajeitanteariri Tasorentsi, tempa irio Avincatsarite maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Inquempeteari Iriashini, oshequi oametiri Ishire Tasorentsi, aisati otasoncacaaqueri. Irijivatanaqueri Avincatsarite, incamantajeiteri ishanincapee iraamaajeiteari, aisati incamanteri inquemisantajeiteri. Iroamejeiteri ishaninca inquemisantanteari, inquempeteari yora peeraniniri iquemisantini intacaroniri. Iroamejeiteri tseencantatsiri cameetsa inquemisanteri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Icantaqueri Sacariashi: —¿Arimpa? ¿Jaoca noncanteari niotasanotanteari queariotaque oca picantaquenari? Anteashipataquena, aisati nojina, anteashipataque iroori. ");
INSERT INTO cniNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yacanaqueri: —Naro Caviriyeri, quiso noiri Tasorentsi. Iriotaque tiancaquenari nocamantantimpirori oca cameetsatatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aitaque omoncarataquea oca nocamantaquempiri, iro cantaincha te pishiretearoji, irointi pitseencaquena. Meeca pimasontite, eiro pineanatajitsi irosati intimanteari pitomi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ainiro anta saiteriqui apatojeitainchari yamenaajeivetacari Sacariashi, icantajeitaque: —Osamanitanaqueteemi ipeaca. ¿Paita caari isoquijantaja? ");
INSERT INTO cniNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Impoiji isoquijanaji, te irimatajeaji irineanataje, irointi ijicojicotashitaca. Impoiji iojeitanaque, icantajeiti: —Timatsi ineaqueri anta tsompoinaqui. Te irineanatasanoteji catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Irosati icanta, oshequi quitaiteri yantaveetaji aisati ivancoqui Tasorentsi. Impoiji ipianaja ivancoqui iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Impoiji oaque ijina, irosati oquempoyeantaca ovancoqui. Icarati 5 cashiri te osoquijajeji. ");
INSERT INTO cniNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ocanti: —Peerani te intimeji notomi, irootaque nopashiventantacari, iro cantaincha eiro nopashiventajatsi aisati. Icavintsaaquena Avincatsarite, tempa icameetsatasanoti. ");
INSERT INTO cniNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Impoiji icarataque 6 cashiri otsomotetantacari Isavere. Ari itiancajiri aisati Tasorentsi Caviriyeri: —Pijate Nasaretequi: ora carireaquiniri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pincoapaaquero Maria, ijinatsori Jose. Iriotaque ishanincani Iravirini. Ocashiacari ayeri, iro cantaincha te oneayeteriji shirampari. ");
INSERT INTO cniNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ari ijatashitaquero. Imapocapaaquero, icantapaaquero: —¿Ainirompi, Maria? Noncamantempi: oshequi inintasanotaquempi Tasorentsi, quiso yoaquempi. Oshequi icavintsaasanotaquempi, panaacotaquero maaroni pitsinaneroronte. ");
INSERT INTO cniNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Iro cantaincha otsaroanaque iroori, oquenqueshiretanaca: “¿Paita ojita oca icantaquenari?” ");
INSERT INTO cniNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Icantaquero: —Eiro pitsaroitsi. Queario, icavintsaasanotaquempi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Irotaintsi poye. Coajica pintimeri pitomi, pimpajiteri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Impincatsaritasanote. Iriojeitanaque atiri irio Itomi Tasorentsi, savicatsiri inquitequi. Tempa iriotaque Avincatsarite. Peerani yora Iravirini ipincatsariventaveitarini pijorioririnte. Iro cantaincha incanteri Tasorentsi: “Notiomi, aviro pincatsariventajeiterineri maaroni, pincantaitatiyempani”. Aitaque incanteari impincatsaritanaque, eiro yoipacaajirotsi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ari ocantiri: —¿Jaoca incanteari intimanteari notomi? Te intimeji nojime. ");
INSERT INTO cniNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yacanaquero: —Iro timacayempine Ishire Tasorentsi. Aisati intasoncaventaquempi Tasorentsi, savicatsiri inquitequi jenoqui. Coajica incantacojeiteri pitomi: “Icameetsatasanoti, te aneeroji irantane. Iriotaque Itomi Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aisati noncamantempi: anteashipatasanovetaca iroori pishaninca Isavere, aisati icanteetiro shiravaro oni, iro cantaincha icarataque meeca 6 cashiri otsomontetantacari. Coajica ontimeri otomi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pineaquero, tecatsi pomerentsitimotearine Tasorentsi, imajeitaquero paitarica icoiri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ocantiri iroori: —Irioyeampa Avincatsarite. Onimotaquena paitarica icoacaaquenari: icoacaaquenarica intimashitea notomi, ari cameetsataque. Irosati ipiantanaja inampire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pashini quitaiteri ojatanaque Maria Joreaqui. Oshintsiti ojatanaque toncaariqui. ");
INSERT INTO cniNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Areetapaaca anta ivancoqui Sacariashi. Oneapaaquero Isavere, ocantapaaquero: —¿Ainirompi? ");
INSERT INTO cniNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Oquemantavacarori Maria ocajemapaaque, oquematiiri ishevatanaca orijani, moyec. Aisati oametasanotaquero Ishire Tasorentsi, ");
INSERT INTO cniNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","irosati ocajemantavacaro. Ocantiro: —Tempa ineshinoncajeitaquee Tasorentsi, aisati iquempejeitiro maaroni tsinane; iro cantaincha avinti, panaacojeitaquena: ineshinoncatasanotaquempi catsini. Tempa aisati ineacameetsatiri pirijani. ");
INSERT INTO cniNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aviro ashitearine Avincatsarite. ¿Paita piquenqueshiretantanari pineana? ");
INSERT INTO cniNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pamene, noquemantavaquempiri pivetsatapaaquena, iquimoshiretanaque norijani, ishevatanaca, moyec. ");
INSERT INTO cniNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pishiretasanotavacaro maaroni icamantaquempiri Avincatsarite, irootaque ineshinoncatantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ocantiro Maria: —Tempa icameetsatasanotaque Avincatsarite, ");
INSERT INTO cniNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","iriotaque Atasorentsite aisati oavisacojeiteeneri coajica. Oshequi noquimoshireventaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","¿Paita icavintsantanari narori? Nashinoncaavetaca, tecatsi niote narori. Iro cantaincha iriojeitanaque maaroni atiri noquimoshireventaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Oshequi itasoncacoventaquena, tempa itasorentsitasanotaque, icameetsatasanotaque. ");
INSERT INTO cniNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Icantatiani icavintsaajeitaqueri maaroni pincatsajeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Oshequi itasoncantayetaque. Intsoncajeitajeri maaroni shemejeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Imajeitaqueri pincatsarivetachari yojocacaaqueri ipincatsariventanti. Irintiquea ashinoncaincari ipeajiri pincatsari. ");
INSERT INTO cniNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iquemacaacari tasheavetachari, aisati yaapitsatajiri ashitaarantincari maaroni timimojeivetariri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Icantani Tasorentsi yamitacojeitaqueri ajorioririnte, te impeacoteeji arori icavintsaajeitaquee. ");
INSERT INTO cniNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aitaque imataquero maaroni icantaqueriri intacaroniri peerani: Avarama aisati maaroni ishanincani, catsini. Irootaque ocantirori Maria. ");
INSERT INTO cniNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ari osavicaiti mava cashiri, impoiji opianaja onampiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ari moncarataca otimiri Isavere otomi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Iquemacojeitaquero oshanincapee, iquimoshireventaquero. Icantajeitaque: —Tempa ineshinoncatasanotaquero Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ari ocarataque imaacotaque 7, moncarataca intoyeantanteariri. Yamejeitaro jorio ipajitavacaa iriori, icantajeiti ishaninca: —Tempa impajitea Sacariashi, inquempetajeari iriri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Iro cantaincha ocanti iriniro: —Eiro ipajitatsi Sacariashi, ainti impajitea Joa. ");
INSERT INTO cniNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Icantajeivetaro: —¿Paitaquea? Te intimeji pishaninca pajitachaneri Joa. ");
INSERT INTO cniNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ari isampijeitiri Sacariashi: —¿Paita picoiri avinti? ");
INSERT INTO cniNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ari ijicotiro paperi, isanquenajeitaqueneriri: “Aitaque, impajitea Joa”. Irosati yoajeitantanaca cavaco. ");
INSERT INTO cniNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Imapocanaja Sacariashi ineanataji aisati, icanti: —Tempa icameetsati Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Impoiji yoajeitanaqueri cavaco maaroni ishaninca. Iquemacojeitaqueri maaroni savicajeitatsiri toncaaripeequi: ora timatsiri Joreaqui. ");
INSERT INTO cniNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iquenqueshirejeitanaca maaroni quemacojeitaqueriri: “¿Jaoca icantari yora jananequi? ¿Paita iranteri coajicani? Tempa ineshinoncatasanotaqueri Avincatsarite”. ");
INSERT INTO cniNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Impoiji Ishire Tasorentsi oametaqueri Sacariashi, icantantarori oca: ");
INSERT INTO cniNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Tempa icameetsatasanoti Avincatsarite, iriotaque tasoncaventajeitaqueeri. Ipocashijeitaquee iroavisacojeitajee. ");
INSERT INTO cniNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Peerani Iravirini yantiniri Tasorentsi icoacairiri. Meeca itiancaqueri Tasorentsi ishanincani Iravirini, itasorentsitaque, yoavisacotantaque. ");
INSERT INTO cniNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tempa peerani icantirini Tasorentsi quenquetsatacotiriniri: ");
INSERT INTO cniNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Nontianquempiri oavisacojeitempineri, intimerica quisajeitempineri, irojocacoventajeitaquempi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Noncavintsaajeitaqueri ishanincani Avarama, maaroni. Eiro nopeacotajarotsi nocantajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Peerani nocantasanotaqueri Avarama: ");
INSERT INTO cniNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Coajica noavisacojeiteri pishanincapee, nompiajeiteari quisajeivetearineri, impoiji eiro itsaroajeititsi inquemisantajeitena. ");
INSERT INTO cniNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Noameetsajeiteri, noncanteani noneacameetsajeiteri’ ”. Irootaque icantaqueriri Tasorentsi peeraniniri. ");
INSERT INTO cniNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Meeca notiomi, noncamantempi: iriojeitempi atiri aviro quenquetsatacoterine Tasorentsi jenoquiniri. Pincamantajeiteri incameetsatanaque, iraamaajeiteari Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Poamejeiteri ashanincapee iriojeitanteari jaoca incanteari iravisacotantajeari. Pincamantajeiteri icavintsaasanojeitaqueri Tasorentsi, eiro iquenqueshiretajirotsi yantayetiri caari cameetsatatsi. Ariorica icontetapaaque catsirincaiteri, te ontsitenitanajeji, irointi oquitaitetanaji. Aisati oquempetaca, ariorica imponeaquea Avincatsarite jenoqui, ayotasanojeitanaque cameetsa asavicajeite. ");
INSERT INTO cniNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Iroavisacojeiteri maaroni caari iovetari Tasorentsi, maaroni tsaroayevetachari incame. Iriotacaajeitapaaqueri jaoca incanteari iraacameetsatanteariri Tasorentsi. Irootaque icantaqueri Sacariashi. ");
INSERT INTO cniNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ari avisanaji oshequi osarintsi, yantearitanaque Joa, oshequi iquemisantaqueri Tasorentsi. Ari itimaqueri apaniro caaraiteriqui, irosati iquenquetsatacantacariri ishanincapee. ");
INSERT INTO cniNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ari ipincatsariventanti Jerosarequi oromasati, ipajita Shisari Acoshito. Ari iroaquera itimapaaque Joa, icanti Shisari: —Nocoaque irisanquenatacojeitea maaroni atiripee, niotanteari jaoca icarajeitiri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iro isanquenajeitantarori ivajiropee, irio Shirino pincatsariventajeitiriri shiriasati. ");
INSERT INTO cniNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ari ijajeiti atiri anta nampitsiqui itimajeitini ishanincani peerani, isanquenatacojeitaca. ");
INSERT INTO cniNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Itimi meeca Jose anta Nasaretequi, ora timatsiri Carireaqui. Iro cantaincha ishanincatacari Iravirini: yora pincatsariveitachaniri. Iro inampini Iravirini Verequi, timatsiri anta Joreaqui. Irootaque ijatantacari Jose Verequi, irisanquenatacotantajeari irisati. ");
INSERT INTO cniNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Itsipatanacaro iroori ijinatsori, irotimataintsi ontimacote. ");
INSERT INTO cniNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ari yareetantapaacari Verequi, irosati oquemantacaro atsicaneentaquero, niii. ");
INSERT INTO cniNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Icoayevetapaaca pancotsi irimaanteari, iro cantaincha ijaajeitacaro pancotsipee irisavicantapeempameri: irointi timatsi ivanco virantsi. Aitaque otimaqueriri otomi, jivatatsiri itimi. Oponataqueri, oaqueri ora iquempoyeanteetanariri virantsi yoari. ");
INSERT INTO cniNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ari otsitenitanaji, ainiro anta queshiiqui isavicajeiti shentajeitiriri irovishate. ");
INSERT INTO cniNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Imapocaqueri Avincatsarite, ishipaquireacojeitaqueri, oquempetaca quitaiteri, aisati ineajeitavaqueri inampire Avincatsarite. Itsaroajeitanaque; icantaita, shiquere. ");
INSERT INTO cniNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Iro cantaincha icantapaaqueri: —Eiro pitsaroajeititsi, timatsi noncamantempiri: ocameetsatasanotaque. Pinquimoshireventajeitearo, aisati inquimoshireventearo maaroni atiri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Iroaquera itimaque Verequi oavisacojeitempineri: iriotaque Avincatsarite Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jeroca noncamantempiri piotanteariri. Pijate ivancoquinta virantsi, pamenaiteri yora iroaquera timaintsiri; pineapaaqueri iponaaca anta ivancoqui virantsi, iponataca. ");
INSERT INTO cniNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Irosati imapocajeitantacariri oshequi jenoquisati, icantajeiti: —Tempa icameetsatasanoti Tasorentsi, ");
INSERT INTO cniNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","nopincatsatasanojeitiri anta inquitequi. Aca quipatsiqui irisavicacaajeiteri cameetsa maaroni ineacameetsajeitiri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ari ipiajeitanaja inquitequi, impoiji icantajeiti shentajeitiriri irovishate: —Icamantaquee Avincatsarite timaque Verequi oavisacojeiteeneri. Tsamete amenaiteri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ari ishiajeitanaca, ineajeitapaaqueri Jose, jero Maria, jeri iriori otomi, iponaaca ara. ");
INSERT INTO cniNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ari icamantajeitapaaqueri maaroni icamantaqueriri inampire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ari yoajeitanaque cavaco maaroni quemajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Iroori Maria oshequi oquenqueshiretaquero oca icantajeitaqueriri, oquenqueshiretapinitaquero. ");
INSERT INTO cniNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ari ipiajeitanaja ashitariri irovishate anta queshiiqui. Icantajeitanaque: —Tempa icameetsataque Tasorentsi. Ocameetsataque maaroni inijaaqueeri aisati maaroni icamantaqueeri. Cameetsa ini Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ari ocarati 7 imaacotaque Jesoshi, irosati itoyeantanteetacari. Aisati ipajitiri Jesoshi: imoncarataquero icantaquerori Maria chapinqui inampire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Ari peerani isanquenatacaaqueri Avincatsarite Moishishini: “Ariorica ontimeri tsinane otomi, onquempoyeempaya ovancoqui oncarate 40 quitaiteri: eiro ojatitsi ampatojeiteari quemisantatsiri. Ariorica omoncarataquea 40 quitaiteri, ocameetsati ojate ivancoqui Tasorentsi onquemisantantajeari aisati. Aanajeneri Tasorentsi apite sampaquiti, ariorica apite paroma. Ompapaaqueri saserote, iroyeri, impoiji intayeneri Tasorentsi. Impoiji onquempetajea aisati peerani, cameetsa ojatapinitaje aisati, onquemisantapinitaje”. Timatsi pashini isanquenatiniri aisati: “Iriorica shirampari yora jivatatsiri otimiri tsinane, icoaque Avincatsarite inquemisantasanoteri, iranaacoteri impoiterineri intime. Ocameetsati iraanajeri ashitariri ivancoqui Tasorentsi, incanteri Tasorentsi: ‘Jerica notomi, jivatatsiri itimi. Paitarica pincoacaaqueriri, nocoaque irantasanotempiro’ ”. Ari ocarataque 40 quitaiteri itimantacari Jesoshi, irosati ijajeitantanaja Jerosarequi: Jose, Maria, jeri Jesoshi. Imoncarajeitaquero maaroni isanquenatiniri Moishishi ojatapinitantajeari Maria onquemisante. Aisati ocamantaqueri Tasorentsi: —Jerica notomi, nocoaque irantasanotempiro paitarica picoacaaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ari itimi anta Jerosarequi shirampari pajitachari Shimeo. Quemisantasanotatsiri ini, cameetsa isaviqui, iquemisantasanotaquero Ishire Tasorentsi. Aisati yaamaari Quirishito: yora veshireacaajeitearineri maaroni joriopee. ");
INSERT INTO cniNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ocamantaqueri Ishire Tasorentsi: “Eirotsitarica picami, pineavaqueri Quirishito: yora intianqueri Avincatsarite”. ");
INSERT INTO cniNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Irosati otiancantacari Shimeo anta ivancoqui Tasorentsi; impoitapaaqueri Jose, Maria, jeri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ineavaqueri Jesoshi, ijatashitaqueri, yatsomaavaqueri; icantiri Tasorentsi: —Novincatsarite, tempa picameetsati, ");
INSERT INTO cniNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","noneaqueri oavisacotenaneri, yora picantaquenari. Meeca moncarataca, tecatsi noncoyeri aisati. Noquimoshiretaque, vetsicaquena noncame. ");
INSERT INTO cniNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Queario, pitiancaqueri iroavisacojeiteri maaroni atiri: ");
INSERT INTO cniNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","irio iotacaajeiterine pashinipee atiri, iriveshireimentajeiteari maaroni joriopee quemisantajeitimpiri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Irosati yamenantanaca Jose, jero Maria, yoanaqueri cavaco; iquenqueshiretasanotiro icantaqueri Shimeo. ");
INSERT INTO cniNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Aisati icantajeitaqueri: —Nocoaque irineshinoncajeitempi Tasorentsi. Aisati icantiro iriniro: —Pamene, coajica oshequi piraacoteari pitomi: ipocaque ayojeitanteari avavisacojeitajea, iro cantaincha incarate oshequi ashaninca tseencajeiterineri: iroashinoncaajeitea iriori. Irintiquea pashini ashanincapee, iroveshireimentasanojeiteari pitomi. Aparo intseencajeiteri, pashini iroveshireimenteari, onconijatanteari iquenqueshirejeitiri. Irootaque icantaquerori Shimeo. ");
INSERT INTO cniNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ari otimi aisati ivancoqui Tasorentsi tsinane pajitachari Aana: oshequi ocamantapinitiri oshaninca irineane Tasorentsi. Ipajitani irini Janoeri: iriotaque ishanincani Asere. Anteashipatasanotaque Aana: ocarataque osarintsite 84. Camajimentaaro oni, ocarataque 7 osarintsi irosati icamantacari ojimeni. Meeca osavicaque ivancoqui Tasorentsi. Ocantani: quitaiteriqui, tsiteniriqui oquenquetsatacaapinitiri Tasorentsi; oshequi opincatsataqueri. Te onquenqueshiretasanoteroji oayetari. ");
INSERT INTO cniNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ari ojatashitaqueri Jesoshi iroori. Ocantaqueri Tasorentsi: —Ariove, noneaqueri narori. Aisati ocantajeitiri oshaninca: —Jerica yoca, iriotaque oavisacojeiterineri ashanincapee: maaroni aamaajeitariri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ari imataquero Jose aisati Maria maaroni isanquenataqueri Moishishi: tempa isanquenatacairi Avincatsarite. Impoiji ipiajeitanaja Nasaretequi: timatsiri Carireaqui. ");
INSERT INTO cniNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ari iqueveanaque Jesoshi, aisati ishintsitanaque, aiquero ijatanaque iotasanotanaque, yanaacotiri ijananequiririnte. Oshequi ineshinoncataqueri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ari ijatapiniti anta Jerosarequi, itsipajeitari Jose aisati Maria. Aitaque ijatapinitiri maaroni osarintsi ariorica omoncaratapaaca quitaiteri Yavisantaniri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ari ocarataque irosarintsite Jesoshi 12, ijajeitanaji aisati, ");
INSERT INTO cniNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","iquimoshireventaqueri Tasorentsi. Pashini quitaiteri ipiajeivetanaja maaroni ishaninca, iro cantaincha isavicanaque Jesoshi Jerosarequi apaniro. Te irioveteari ishaninca, ");
INSERT INTO cniNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","yaamaashivetacari itsipajeitanajari ishanincapee pashini. Ari ishaaviniji icoacoayevetacari ishanincaqui, ");
INSERT INTO cniNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","iro cantaincha te irineajeriji. Irosati ipiantanaja Jerosarequi, icoacoayevetajari, ");
INSERT INTO cniNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ocarataque mava quitaiteri. Impoiji ineapaajiri ivancoqui Tasorentsi: icarajeitiri oametantayetatsiri. Iquemisantayetiri yoametantayetiri, aisati isampijeitiri paitapeerica. ");
INSERT INTO cniNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yoajeitanaqueri cavaco atiripee, icanti: —Pamenerite evancarica: oshequi iotantari, cameetsa yacanaqueri yora oametantatsiri, te incomitearoji. ");
INSERT INTO cniNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aisati yoapaaqueri cavaco Jose, jero Maria. Ocantiri iriniro: —Notiomi, ¿paitaquea pimanapitsatantanari? Pamene, nocaratiri piritsori nocoacoayevetaquempi. Oshequi nocoiteaquempi. ");
INSERT INTO cniNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yacanaquero: —¿Paita picoacoayetantanari? Tempa piote nocoasanotaque nosavique ivancoqui Apa. ");
INSERT INTO cniNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iro cantaincha te inquemajeitavaqueriji icantavetacariri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Impoiji yoijajeitanajiri, ipiajeitanaja Nasaretequi. Icantani iquemisantaqueri, tecatsi incantea impiatsateari. Irointi Maria oshequi oquenqueshiretaquero maaroni oca oneayetaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aiquero ijatatii iotasanotanaque Jesoshi, yantearitanaque. Yora Tasorentsi inintaqueri itomi; aisati ishanincapee iriori, inintajeitaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ocarati meeca 15 osarintsi ipincatsariventajeitiri maaroni oromasati yora Tiverio Shisari. Ipincatsariventiri joreasati Pontsio Pirato. Yora Eroreshi ipincatsariventiri carireasati; irinti irirenti, Jiripo, ipincatsariventiri itoreasati aisati taraconitiresati. Aisati yora Irisania ipincatsariventiri avirenesati. ");
INSERT INTO cniNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aisati meeca ipincatsariventajeitiri saserotepee Anashi aisati Caijashi. Ari itimaqueri Joa, itomi Sacariashi, anta caaraiteriqui. Icantiri Tasorentsi: —Nocoaque meeca pinquenquetsatacayeri pishaninca, timatsi nocoaque pincamantajeiteriri. ");
INSERT INTO cniNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ari iquenaquenayetanaque Joa Joriraniqui, icantajeitiri ishaninca: —Pinquenqueshirejeitea, eiro piquempetajatsi peerani, impoiji incavintsaajeitempi Tasorentsi: eiro iquenqueshireacotajimpirotsi pantajeiveitaniri. Impoijiquea novaotisajeitempi iriotanteari pishaninca pavisacotaji. ");
INSERT INTO cniNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Imoncarataquero Joa icamantacotitariniri peerani Isayashini: “Anta caaraiteriqui intime coajica quenquetsatacayerineri ishaninca. Incamantajeiteri ishaninca: ‘Coraque Avincatsarite, pamenaajeiteri, paamaajeiteari. Pincameetsatanaque irineacameetsatantapeempiri. Ariorica pincameetsatanaque, pinquempetearo avotsi cameetsatatsiri inquenanteari Avincatsarite: poameetsatero irineacameetsatantearori. Pintampaticatero, ");
INSERT INTO cniNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","pijayero otsateni, pinquiaarantajero toncaaripee, pintampaticatajero maaroni tipiyetatsiri, pintijayetajero ovintenipee. ");
INSERT INTO cniNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Impoiji maaroni atiri irineajeitavaqueri oavisacojeiterineri intianqueneri Tasorentsi’ ”. ");
INSERT INTO cniNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ari ijatashijeivetacari Joa oshequi atiri irivaotisajeiterime. Jeroca icantavaqueriri: —Avirojeitaque camaari: oshequi pamatavitantajeiti, te pincameetsajeiteji. Te pincoajeiveteaji pijate Sharincaveniqui, iro cantaincha te pinintasanoteji pinquemisanteri Tasorentsi, irootaque picoantavetacari pivaotisajeiteame. ");
INSERT INTO cniNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ariorica pinquenqueshirejeitea pimpashinitantajeari, pintime cameetsa iriojeitanteari itsipapee queario picantaque. Eiro picantashitatsi: “Noshanincatacari Avaramani, irootaque niotantacari noavisacotajea”. Pamatavitaja avisati. Incoaquericame Tasorentsi, irimatero intasonquerome oca mapica, impeajerome atiri, oshanincatajearime Avaramani, iro cantaincha eiro avisacotitsi iroori. Patsipetashitaca pishanincavetacari Avarama: piquempetarocari mapi. ");
INSERT INTO cniNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Piquempejeitacaro aisati inchato. Iro cantaincha irotaintsi inchaquitero Tasorentsi inchato, imponquitireajero aisati. Terica oncameetsateji oitsoqui, inchaquitero, intaasanotajero, pomein. Piquempetarocari inchato caari cameetsatatsi oitsoqui: yojoquimpicari Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ari isampijeitiri: —¿Paita picoiri nantajeiteri? ");
INSERT INTO cniNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Icantiri: —Otimirica apite piitsaare, pimpaaranteri ashinoncaincari aparo. Otimirica oshequi poari, pimpaaranteri aisati ashinoncaincari. Pincavintsaantapinite. Irootaque icantapinitiriri Joa. ");
INSERT INTO cniNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aisati ijatashitaqueri Joa aayetiriri quirequi: yainiri yora oromasati, oshequi yamatavitiri aisati ishaninca. Ijatashijeitiri, icoaque irivaotisajeitavaqueri, isampitapaaqueri: —¿Paita nanteri piotantenari queario noquemisantaque? ");
INSERT INTO cniNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ari icantavaqueri: —Eiro paashititaritsi iirequite pishaninca, irointi pimoncaratero icantaquempiri oromasati. ");
INSERT INTO cniNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aisati ijatashijeitaqueri soraro, isampitaqueri: —¿Paita nanteri narori? Ari icantavaqueri: —Eiro piquishiritsi atiri paapitsatanteariri iirequite, aisati eiro picantacotashitaritsi paitanteariri iirequite. Moncarataca ipinataquempiri pivincatsarite, eiro picoitsi aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ari yaamaajeitari Quirishito, ijitashijeiveta irotaintsi irareetea. Iquenqueshirejeitiri: “Iriorica Joa Quirishito”. ");
INSERT INTO cniNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Iro cantaincha icantajeitaqueri Joa: —Novaotisajeitaquempi nijaqui: te ompomerentsiteaji. Coajica impoque Avincatsarite irinti, oshequi nopincatsataqueri, notseencaja narori. Intiancajeitaquee irinti Ishire Tasorentsi, quiso oajeitee, oameetsajeitee. ");
INSERT INTO cniNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Coajica irinashitacayeari cameetsatatsiri aisati caari cameetsatatsi. Oquempetaca arori anashitacaaro oitsoqui panquirentsi, aisati anashitacaaro osapentairoqui. Aquempoyeajiro oitsoqui, atairo osapentairoqui. Aisati inquempejeitee Avincatsarite arori: incavintsaajeiteri cameetsajeitatsiri, iroashinoncaajeiteri caari cameetsajeitatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","20","(-) ");
INSERT INTO cniNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Ari ivaotisajeitaqueri Joa oshequi atiri, aisati ivaotisataca Jesoshi, irosati iquenquetsatacaantacari iriri. Omapocanaca aniireashitapaaqueri Ishire Tasorentsi, oponeaca inquitequi. Oshiapaaqueri sampaquiti. Aisati iquemajeitaquero icantaqueriri Tasorentsi: —Avirotaque notomi nonintasanotiri. Oshequi noveshireimentaquempi. (v 18) Aitaque icanta Joa: icamantapinitiri atiri incameetsatanaque, aisati icamantiri jaoca incantajeiteari iroavisacojeitantajeari. (v 19-20) Aisati icantaque: —Te oncameetsateji yantayetiri Eroreshi. Yaavetaro irirenti Eroriashi, iro cantaincha yaitaqueri Eroreshi. Ainiro oshequi pashini caari cameetsatatsi yantayetiri. Ari iquisanaca Eroreshi. Ipincatsariventajeitiri carireasati, irootaque imatantacarori yaacantaqueri Joa, shepi, yoiminqueacantaqueri. Aiquero ijatatii yantanaquero catsini caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Peerani yovetsiquiri Tasorentsi Aran. Iri itomini Aran ipajitani Sete. Iri itomini Sete ipajitani Enoshi. Iri itomini Enoshi ipajitani Cainama. Iri itomini Cainama ipajitani Marereri. Iri itomini Marereri ipajitani Jarete. Iri itomini Jarete ipajitani Enoco. Iri itomini Enoco ipajitani Matosara. Iri itomini Matosara ipajitani Arameca. Iri itomini Arameca ipajitani Noe. Iri itomini Noe ipajitani Seme. Iri itomini Seme ipajitani Aratajara. Iri itomini Aratajara ipajitani Cainama. Iri itomini Cainama ipajitani Sara. Iri itomini Sara ipajitani Evere. Iri itomini Evere ipajitani Jarareque. Iri itomini Jarareque ipajitani Aracao. Iri itomini Aracao ipajitani Seroco. Iri itomini Seroco ipajitani Nacoro. Iri itomini Nacoro ipajitani Tare. Iri itomini Tare ipajitani Avarama. Iri itomini Avarama ipajitani Isaca. Iri itomini Isaca ipajitani Jacovo. Iri itomini Jacovo ipajitani Jora. Iri itomini Jora ipajitani Jareshi. Iri itomini Jareshi ipajitani Eseromi. Iri itomini Eseromi ipajitani Arini. Iri itomini Arini ipajitani Aranini. Iri itomini Aranini ipajitani Aminarava. Iri itomini Aminarava ipajitani Nasono. Iri itomini Nasono ipajitani Sara. Iri itomini Sara ipajitani Voso. Iri itomini Voso ipajitani Jovere. Iri itomini Jovere ipajitani Jese. Iri itomini Jese ipajitani Iraviri. Iri itomini Ivaviri ipajitani Natama. Iri itomini Natama ipajitani Matata. Iri itomini Matata ipajitani Mena. Iri itomini Mena ipajitani Merea. Iri itomini Merea ipajitani Eriaquimi. Iri itomini Eriaquimi ipajitani Jonama. Iri itomini Jonama ipajitani Jose. Iri itomini Jose ipajitani Jora. Iri itomini Jora ipajitani Shimeo. Iri itomini Shimeo ipajitani Irevi. Iri itomini Irevi ipajitani Matata. Iri itomini Matata ipajitani Jorimi. Iri itomini Jorimi ipajitani Eriyesere. Iri itomini Eriyesere ipajitani Jesoshi. Iri itomini Jesoshi ipajitani Ere. Iri itomini Ere ipajitani Eremarama. Iri itomini Eremarama ipajitani Cosama. Iri itomini Cosama ipajitani Ari. Iri itomini Ari ipajitani Merequi. Iri itomini Merequi ipajitani Neri. Iri itomini Neri ipajitani Saratiyeri. Iri itomini Saratiyeri ipajitani Sorovaveri. Iri itomini Sorovaveri ipajitani Eresa. Iri itomini Eresa ipajitani Joanana. Iri itomini Joanana ipajitani Jora. Iri itomini Jora ipajitani Joseca. Iri itomini Joseca ipajitani Semeini. Iri itomini Semeini ipajitani Matatiashi. Iri itomini Matatiashi ipajitani Mata. Iri itomini Mata ipajitani Nacai. Iri itomini Nacai ipajitani Eshiri. Iri itomini Eshiri ipajitani Naomo. Iri itomini Naomo ipajitani Amoshi. Iri itomini Amoshi ipajitani Matatiashi. Iri itomini Matatiashi ipajitani Jose. Iri itomini Jose ipajitani Janai. Iri itomini Janai ipajitani Merequi. Iri itomini Merequi ipajitani Irevi. Iri itomini Irevi ipajitani Mata. Iri itomini Mata ipajitani Eri. Iri itomini Eri ipajita Jose. Iri itomitsori Jose ipajita Jesoshi, iro cantaincha ijijeivetari ishaninca irio itomisanori. Ari ocarataque irosarintsite Jesoshi 30, intantacaroniri iquenquetsatacaajeitiri ishaninca. ");
INSERT INTO cniNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ari ijatanaji Jesoshi, iponeanaja Joriraniqui. Quiso oanaqueri Ishire Tasorentsi, aanaqueri caaraiteriqui. ");
INSERT INTO cniNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ocarati 40 quitaiteri itimaque anta, tecatsi iroyeari: aasanotaqueri itashe. Ari maaroni quitaiteri ijatashitaqueri yora Satanashi, icoaveta irantacayerime caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Icantavetapaacari: —Avirorica itomi Tasorentsi, jentsite: pintasonquero oca mapica, pimpeero tanta, poyearo. ");
INSERT INTO cniNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yacanaqueri Jesoshi: —Isanquenatini peerani Moishishi: “Ocameetsati avajeitearo avanaro eiro acamanta, iro cantaincha ocameetsatasanoti anteneri Tasorentsi maaroni icoacaajeitaqueeri”. ");
INSERT INTO cniNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aisati yaanaqueri antearoqui toncaari, ijicotapaaqueneri maaroni quipatsi, ");
INSERT INTO cniNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","icantiri: —Pincoaquerica noncantajeiteri maaroni savicajeitatsiri impincatsajeitempi, iraacameetsajeitempi. Tempa narotaque pincatsariventajeitiriri maaroni, ");
INSERT INTO cniNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ariorica noncanteri impincatsajeitempi avirori, ari impincatsajeitempi. Apatiroquea nocoaque pintiyeroashitena, pimpincatsatena narori. ");
INSERT INTO cniNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yacanaqueri: —Ocameetsati ampincatsateri Tasorentsi, apaniro ampincatsateri irinti. Irootaque ocantiri irineane. ");
INSERT INTO cniNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Impoiji yaanajiri Jerosarequi, anta otataroqui ivanco Tasorentsi, antoo jenoqui. Icantiri: —Avirorica itomi Tasorentsi, jentsite: pimpariye, eiro picamitsi. ");
INSERT INTO cniNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tempa ocanti Sanquenarentsi: “Irishentempi inampirepee Tasorentsi, inquempoyeaquempi”. ");
INSERT INTO cniNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ainiro aisati pashini isanquenatiniri: “Ari irancatsatavajempi iriori, eiro ishinetimpitsi pimpariye mapiqui”. Pineaquero, ¿paita pitsaroantacari? ");
INSERT INTO cniNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yacanaqueri: —Aisati ocanti Sanquenarentsi: “Eiro pineantaritsi Tasorentsi: yoasanquetaimpicari”. ");
INSERT INTO cniNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ari iotaque camaari tecatsi incanteri Jesoshi, ijatanaji. Iro cantaincha ari irampiitajeri coajica. ");
INSERT INTO cniNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ari impoiji ipianaja Jesoshi Carireaqui, oshequi omatacaaqueri Ishire Tasorentsi. Te osamaniteji iquemacojeitaqueri maaroni savicajeitatsiri anta. ");
INSERT INTO cniNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Icantajeiti: —Tempa icameetsati Jesoshi; ariorica apatojeita, tempa cameetsa yoamejeitaquee. ");
INSERT INTO cniNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Impoiji ijatanaji Jesoshi Nasaretequi, aitaque yantearitaqueri inampisanoriqui. Ari saavaroqui ijatanaque anta yapatotapinijeitantari, icantani ijatapiniti saavaroqui. Tsompoina icatiapaaca, irineanateneri ishanincapee irineane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ipeetavaqueri isanquenareni Isayashini. Yampinaicareavaquero, yamenaquero irineanateneriri. Ocanti: ");
INSERT INTO cniNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Quiso oaquena Ishire Avincatsarite, otiancaquena noncamanteri ashinoncaayetachari jaoca incanteari iroavisacotantajeari. Noncamanteri maaroni iperanatacari camaari noimpacacoventajeitajeri. Namenacaajeri aisati caari amenatsi. Aisati noimpacacoventajeri maaroni yoashinonqueeyetiri. ");
INSERT INTO cniNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aisati noncamantajeiteri atiri irotaintsi nontasoncacoventeri”. ");
INSERT INTO cniNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ari yampinaicajiro sanquenarentsi, yoipiajiniri ipajiri, impoiji isavicanaji. Yamenashejeitanaqueri, sorerere. ");
INSERT INTO cniNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Icantajeitiri: —Queario meeca nomoncarataquero oca noneanataquempiri, oquenquetsatacotana. ");
INSERT INTO cniNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ari ineacameetsajeivetacari Jesoshi, aisati ineacameetsajeitaquero icantaqueriri. Aisati isampitavacaaca: —¿Tempa irio itomi Jose? ");
INSERT INTO cniNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Icantaqueri: —¿Pitseencaquenampa? Naamaaca pincantename: “Jentsite, poavisacotajeriqueti pishanincasanori avirori. Noquemacotaquempi pitasoncantaque anta Caperenaoqui, meecaquea pintasoncantequeti aisati aca anampiquica”. ");
INSERT INTO cniNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iro cantaincha noncamantempi pamejeita pitseenquiri pishanincasanori: te pioteji pimpincatsateri iriori, irintiquea pashini pipincatsati. ");
INSERT INTO cniNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Queario oca noncamantempiri: peerani itimantacari Iriashini, piojeiti te ompariyeji incani. Peerani osarintsitaqueni. Ocarati mava osarintsi aisati 6 cashiri, te ompariimateji incani catsini. Itasheajeitanaque maaroni savicajeitatsiri quipatsiqui. Otimini oshequi camajimentaaro aca, iro cantaincha itianquiri Tasorentsi Iriashini pashiniqui quipatsi opajita Shironi. Itianquiri irijatashitero camajimentaaro savicatsiri anta Sarepetaqui. Itasoncapinitiniro oari, ipapinitiro. Irointi savicatsiri aca inampiqui, te intasonqueneroji. ");
INSERT INTO cniNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aisati, peerani itimantacari Iriseoni, itimini aca oshequi patsaincari, iro cantaincha tecatsi iroavisacote. Apaniro irinti yoavisacotiri shiriasati pajitachari Nama. ");
INSERT INTO cniNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iquemajeitantacarori apatojeitainchari, iquisajeitanaca. ");
INSERT INTO cniNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ari icatiajeitanaca, yaajeitaqueri, shepi. Yaanaqueri anta otsapitapaa nampitsi, otiminta imperita. Impishoncajeiterime, iroariyerime, ");
INSERT INTO cniNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","iro cantaincha ipeimotanajari, ijatanaji. ");
INSERT INTO cniNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ari ipianaja Jesoshi Caperenaoqui, ora carireaquiniri. Saavaroqui yoamejeitajiri aisati atiri. ");
INSERT INTO cniNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yoajeitanaqueri cavaco, icantajeiti: —Tempa ocameetsati oca yoametaqueeri. Ipincatsariti: iotasanotaquero oca yoametaqueeri. ");
INSERT INTO cniNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ari itimi anta yapatotapinijeitanta aparoni shirampari neiriri camaari. Antearojenca icajemacotavaqueri: ");
INSERT INTO cniNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Aviro Jesoshi poneachari Nasaretequi. Niotaquempi: aviro itomi cameetsari Tasorentsi. ¿Paita pipocashitantanari? ¿Picoavetampa pojoquena? ");
INSERT INTO cniNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ishintsitsataqueri Jesoshi, icantiri: —Pimajerete. Pinijantareanajeri yoca shirampari. Ari ipishoncanaqueri shirampari quipatsiqui, tiricn, irosati ijanirotantanajari. Tecatsi oajerine shirampari, tecatsitanaji. ");
INSERT INTO cniNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yoajeitanaqueri cavaco aisati icantajeiti: —Pineaqueri: apatiro ineanataqueri camaari, irosati ijatantanaja. Oshequi ipincatsariti, oshequi itasoncanti. ");
INSERT INTO cniNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ari iquemacojeitaqueri Jesoshi maaroni savicajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Impoiji ijatanaji Jesoshi ivancoqui Shimo. Icantajeitavaqueri: —Ojoquiitaca irairo Shimo, oshequi oyatsiire. Poavisacotajero. ");
INSERT INTO cniNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Icatiapaaca onampinaqui, icantaquero: —Ari ompeanajea piatsiire, pavisacotaje. Irosati opeantanaja oyatsiire, maani; ocatianaja, opajeitajiri yoari. ");
INSERT INTO cniNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ari iqueanaji catsirincaiteri. Yameetaqueneri Jesoshi oshequi mantsiayetatsiri, onashiyeta imantsiare. Ari ipamijeitavaqueri, yoavisacojeitavaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Impoiji ipocajeiti oshequi yoitsavianquiri camaari, icajemajeitapaaque: —Aviro itomi Tasorentsi. Iojeitaque camaari iriotaque Quirishito, irootaque icantantacariri: —Pimajerete, eiro picamantacotanatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ari oquitaitetamanaji ijatamanaque Jesoshi anta ocaraitetapaaque. Icoacoajeitaqueri atiripee. Ineantajariri, icantajeivetapaari: —Eiro pijatajitsi, pisavique aca Caperenaoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Iro cantaincha icanti Jesoshi: —Eiro nosaviquitsi. Nocoaque noncamanteri itsipapee atiri ipincatsariventajeitiri Tasorentsi, tempa cameetsa iriojeitero iriori. Irootaque itiancantanari Apa. ");
INSERT INTO cniNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ari iquenaquenayetanaque Jesoshi anta Joreaqui, iquenquetsatacaajeitiri atiri anta pancotsipeequi yapatojeitantari. ");
INSERT INTO cniNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ari pashini quitaiteri iquenquetsati Jesoshi anta otsapijaqui incajare pajitachari Jenesarete. Itsitacajeitapaacari atiripee, icoajeitaque inquemero irineane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ari ineaquero Jesoshi apite pitotsi anta otsapijaqui. Tecatsi tetearone: yora quitsatatsiri iquiviro iitsarite anta. ");
INSERT INTO cniNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Itetaca Jesoshi ivitoqui Shimo, icantiri: —Shimo, pintianquero capichaji. Ari isavicaque pitotsiqui nianquijamaji, yoamejeitiri apatojeitainchari otsapijaquinta. ");
INSERT INTO cniNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ari osamanitanaque, itsoncanaquero yoamejeitaqueri. Icantiri Shimo: —Pijate anta osaanajataquenta, pinquitsate. ");
INSERT INTO cniNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yacanaqueri: —Oametantatsiri, noquitaitetacotaque noquitsavetaca incaranqui, tecatsi naimate catsini. Meecaquea picantaquena, aitaque nojataque nonquitsajeitajanteta aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ari iquitsataji: yaasanotaque shima, oshequi catsini: monquire, monquire. Jaaca inaca, irotaintsi ompeshe quitsari. ");
INSERT INTO cniNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Icajemaqueri ishaninca savicatsiri pashiniqui pitotsi: —Caateve, pamitacojeitenave. Ari ipocacotaque, itetacotaqueri shima apite pitotsi, tero, tero; irotaintsi ontsitiye. ");
INSERT INTO cniNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Icarati oshequi shima iquitsatiri, irootaque yoantanacari Petero cavaco; aisati iquempejeitaca itsipapee: jeri Santiaco aisati Joa. Iriotaque yoca itomipee Severeo. Iriotaque icaratapinitiri Shimo iquitsatapinitiri shima. Itiyeroashitanacari Shimo Petero, icantiri: —Novincatsarite, cameetsa pijataje. Te noncameetsateji narori catsini, eiro pitsipatanatsi. Yacanaqueri Jesoshi: —Eiro pitsaroacaanatsi. Noncamantempi: oquempetaca peerani piquitsatapinitiri shima, nocoaque meeca pinquemisantacaapinijeiteri atiripee. ");
INSERT INTO cniNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ari yaatacojeitapaaji, irosati yojocajeitantanajaro ivitopee, iitsaritepee, maaroni. Yoijajeitanaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Itimi anta nampitsiqui shirampari patsaasanotatsiri: otsoncaqueri ivatsaaro, opiticashaaqueri maaroni itseempequiqui. Ineantavacariri Jesoshi, itiyeroashitavacari, icantiri: —Novincatsarite, tempa pitasorentsiti: pincoaquerica, poavisacotena. ");
INSERT INTO cniNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ari yacotashitaqueri, ipamitiri. Icantiri: —Nocoaque. Pavisacotaje. Irosati opeantanaja ivatsaaro. ");
INSERT INTO cniNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aisati icantiri: —Eiroyea picamantacotanatsi. Meeca pijate saserotequi, pinijaapeeri iriotanteari pavisacotaji. Pimatero icantiniri Moishishini: paanajeneri saserote pivira intayeneri Tasorentsi iriojeitanteari atiri pavisacotaji. ");
INSERT INTO cniNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iro cantaincha aiquero ijatatii icamantacojeitaqueri Jesoshi. Icarati oshequi catsini jatashijeivetacariri inquemisanterime, aisati pashini icoajeiveta iroavisacoterime. ");
INSERT INTO cniNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ari ijatanaque iriori anta caaraiteriqui, iquenquetsatacairi iriri. ");
INSERT INTO cniNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ari pashini quitaiteri yoametantaji Jesoshi pancotsiqui. Isavicajeiti quempeji variseopee aisati oametantirori sanquenarentsi: iponeayetaca oshequi nampitsipeequi, anta Carireaqui, Joreaqui, aisati iponeayetaca Jerosarequi. Otimasanoti itasorenca Avincatsarite imatantarori yoavisacotantaque. ");
INSERT INTO cniNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jeritapaaque shirampari, icompitacojeitapaaqueri caari shevatacha. Icoajeiveta iraanaquerime anta isavicaquenta Jesoshi, iro cantaincha tecatsi inquenapee, iticajeitaqueri atiripee. ");
INSERT INTO cniNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tecatsi incantea inqueapee, irootaque yataitacantacariri otataroquinta pancotsi. Imorontaquero, impoiji yoaniitacotaqueri anta inaquenta Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iotavaqueri iriori ishirejeitacari, irootaque icantantavacariri: —Noshaninca, ainiro pantane, iro cantaincha eiro noquishimentimpirotsi, irointi noncavintsayempi: eiro noquenqueshiretacotimpirotsi aisati, irointi noavisacotempi. ");
INSERT INTO cniNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ari icantavacaajeitaca variseopee aisati oametantirori sanquenarentsi: —Piquemanirotaqueri: ijitasorentsinirotaca. Apaniro irinti Tasorentsi yoavisacotanti. ");
INSERT INTO cniNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ari iotaquero Jesoshi iquenqueshirejeitiri, irosati icantantanacari: —¿Paita picantantari: “Ijitasorentsinirotaca”? ");
INSERT INTO cniNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Pamene, nocantaqueri: “Eiro noquenqueshireacotajimpirotsi pantane, irointi noavisacotajempi”. Meeca pitseencajeitaquena. Tempa opomerentsivetaca naniitacaajeri yoca. Eirorica yaniitajitsi, ari pintseencasanojeitena, pishirontimentajeitena. ");
INSERT INTO cniNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","25","Noponeaca narori inquitequi, natiritapaaque. Nocoaque piojeite ainiro notasorenca, aisati nomataquero nocavintsairi antirori caari cameetsatatsi, noavisacojeitiri. Ari icantiri caari shevatacha: —Jentsite, pincatianaje, paanajero pinariantari, pijataje pivancoqui. Ari ineajeitavaqueri icatianaja, yaanajiro inariantari, ijatanaji ivancoqui. Icantanaque: —Ariove, icameetsati Tasorentsi. Ari icantiri saserotepee: —Pineaquero, nomataquero caari pineapiniti, irootaque piotanteameri oshequi notasorentsitaque. Aisati ari nomatajeri naanajeri coajica inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ari yoajeitanaqueri atiripee cavaco, icantajeiti: —Tempa icameetsatasanoti Tasorentsi, ipincatsaritasanoti. Te aneapiniteroji oca aneaqueri meeca. ");
INSERT INTO cniNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Impoiji isoquijanaji Jesoshi, irosati ineantapaacariri Irevi, yora aitayetiriri ishaninca iirequite, impoiji ipiri pincatsari. Isaviqui anta isanquenatapiniti. Icantapaaqueri: —Tsame, poijatanaquena. ");
INSERT INTO cniNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ari yoipacanaquero isanquenatacoyetiri quirequi, icatianaca, yoijatanaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Impoiji ijataque Irevi ivancoqui, icajemacantaqueri itsipapee vionquiniriri pincatsari iirequite, pashini ishanincapee, Jesoshi, maaroni. Yoacaajeitacari maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ipocaque saserotepee aisati yora oametantirori sanquenarentsi. Icantapaaqueri iroamere Jesoshi: —Pamenerite Jesoshi: icarajeitaqueri vionquiriri quirequi, yoajeita, irajeiti. Jeri aisati itsipapee caari cameetsayetatsi. Te oncameetsateji incarajeiteri iroajeitea. ");
INSERT INTO cniNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ari icantiri Jesoshi: —Yora joquiitachari iriotaque coatsiri iraavintea. Yorari caari joquiitacha te incoyeji aavinterineri. ");
INSERT INTO cniNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iriotaque nopocashitiri caari cameetsatatsi niotacantajeariri eiro yantapinitajirotsi aisati caari cameetsatatsi. Te nompocashiteriji jivetachari icameetsati. ");
INSERT INTO cniNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ari icantiri saserote Jesoshi: —Pamene ititapinita iroamere Joa, aisati iquenquetsatacaapinitiri Tasorentsi: aisati iquempejeitacari iroamere variseo. Irinti poamerepee, te intiteaji: yoapinijeita, irapinijeiti. ");
INSERT INTO cniNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ari yacanaqueri: —Oquempetaca ariorica iraye shirampari ijina, incajemajeiteri ishanincapee inquimoshireventajeitanteariri. Ariorica irareejeitaquea, ¿arimpa intijeitapeempa? Eiro. Aisati narori, nocarajeitiri meeca noamerepee: ¿paita nontitacanteariri? ");
INSERT INTO cniNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ariorica irojocajeitanajeri ishaninca aatsiri ijina, impoijiquea intijeitanaquea. Aisati nonquempetea narori: ariorica coajica noncame, impoiji iroashiretacojeitanaquena noamere, irosatiquea intijeitantanaqueari iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aisati, otimirica piitsaare iroaquerari, te pintsereeroji pimpataquero peesatotaintsiri pimaatsara. Aisati, ariorica poavitajerome, eiro omoncaratavacaatsi. Aisati pinquivajerorica ontsitiamaotanaque iroaquerari, aisati antsivianaque peesatotaintsiri. Otsereacoticari iroaquerari. ");
INSERT INTO cniNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Tempa apeantantaro iroaquerajari pearentsi imeshinaqui iroaquerari, impoiji antsitacotaquero eiro aparajatantatsi. Ariorica oshimoretanaque, aravoncajatanaque, otapiasanotaqueri imeshina. Iroaquera ini, eiro ipesacotitsi, aisati eiro aparajatatsi oja. Irooricame ampeantantajearome pearentsi iroaquerajari peesatitatsiri imeshina, tempa iraravoncanaque, intoncanaque: ton. Aitaque intsereanaque, aisati amparajatanaquea iroaquerajari. ");
INSERT INTO cniNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tempa ariorica irajeitero peesatojataintsiri pearentsi, eiro acoirotsi irero iroaquerajari. ");
INSERT INTO cniNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ari osaavarotaque, iquenanaque Jesoshi tiricomashiqui, itsipatanacari iroamere. Yora iroamere yaviijeitaquero oitsoquipee, yamirocaitaquero otaqui, yojocaquero. Irointi oitsoqui, yoajeitacaro. ");
INSERT INTO cniNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ineajeitaqueri variseopee, icantiri: —Te oncameetsateji oca pantiri. Tempa irointi oca saavaro, amaoreajeitantari, eiro ataquireaitantarotsi meeca. ¿Paita pantantarori? ");
INSERT INTO cniNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Yacanaqueri Jesoshi: —Tempa pineanatiro isanquenatacotiriniri Iravirini. Aaqueri itasheni aisati itsipajeitari. Otimi anta ivancoqui Tasorentsi tanta yovetsiqueetiniriri Tasorentsi. Apaniro yoajeitaro saserotepee, te irishineteriji itsipapee iroyearo. Iro cantaincha yashinoncaaca Iraviri, irootaque ipantacariri tanta yora ivincatsarite saserote, aisati ipajeitaqueri maaroni oijajeitiriri. Pineaquero, te irininteji iroashinoncayeri. ");
INSERT INTO cniNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Noponeaca narori inquitequi, natiritapaaque: naro cantacantirori paitarica anteri saavaroqui. ");
INSERT INTO cniNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ari pashini saavaro ijatanaji anta yapatotapinijeita, yoametantapaaque. Itimi anta shirampari tsiricoipacori. ");
INSERT INTO cniNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yamenashetavaqueri oametantirori sanquenarentsi aisati variseopee, icoaque irioteri iroavisacotanterica saavaroqui. Icoaque incanteri ivincatsarite: “Noneaqueri Jesoshi yantaquero caari cameetsatatsi”. ");
INSERT INTO cniNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Iro cantaincha iotaqueri Jesoshi iquenqueshirejeitiri. Icantiri tsiricoipacori: —Caate, pincatiapee aca. Ari icatianaca, ijatashitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Icantajeitiri Jesoshi: —Meeca nosampijeitempi. ¿Paita cameetsatatsiri antajeiteri saavaroqui? ¿Cameetsampa ancavintsayeri ashaninca? Terica, ¿picoaquempa avashinoncayeri? ¿Cameetsampa avavisacoteri ashaninca? Terica, ¿picoaquempa ayeri? ");
INSERT INTO cniNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yamenajeitaqueri Jesoshi, imajerenirojeitanaque. Ari icantiri: —Pancote. Ari yacotanaque, cameetsatanaji iraco. ");
INSERT INTO cniNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ari iquisajeitanaca saserotepee. Isampitavacaanaca: —¿Jaoca ancanteriri avacantanteariri? ");
INSERT INTO cniNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pashini quitaiteri ijataque Jesoshi toncaariqui, iquenquetsatacairi iriri, iquitaitetacotapaaque. ");
INSERT INTO cniNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ari oquitaitetamani icoyeajeitaqueri iroamerepee. Icarataque 12 icoyeaqueri. Icoaque coajica intianqueri inquenquetsatacotanteariri. Jero oca ivajiropee: ");
INSERT INTO cniNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Shimo (aisati ipajitiri Jesoshi: Petero), Antirishi (yora irirenti Shimo), Santiaco, Joa, Jeripi, Varitorome, Mateo, Tomashi, Santiaco (yora itomi Arijeo), Shimo (icanteetiri aisati Seraroro), Jorashi (yora itomi Santiaco), aisati Jorashi Ishicariote (yora aacanterineri coajica Jesoshi). Aitaque ipajijeitari iroamere icoyeaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Impoiji yoirincapaaja anta opampaitetinta. Itiminta oshequi iroamerepee, aisati oshequi catsini pashinipee atiri: iponeajeitaca Joreaqui, Jerosarequi, Tiroqui, aisati Shiroqui. Otimi Tiro aisati Shiro arejiqui, anta otsapijaqui antearoja incajare. Ijatashijeitaqueri Jesoshi inquemisantajeitavaqueri, aisati icoajeitaque iroavisacojeiteri mantsiaripee. ");
INSERT INTO cniNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ari yoavisacojeitaqueri yatajeaoncayetiri camaari. ");
INSERT INTO cniNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Icoajeitaque impamijeitapeeri, intasoncacoventanteariri iroavisacojeitanteariri. ");
INSERT INTO cniNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ari yamenanaqueri iroamere, icantiri: —Ariorica pashinoncaavetaca meeca, pinquimoshiretanaque: aitaque impincatsariventajeitempi Tasorentsi, coajica. ");
INSERT INTO cniNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ariorica pitasheavetaca meeca, pinquimoshiretanaque: aitaque inquemacaajempi Tasorentsi, coajica. Ariorica poashirevetaca meeca, pinquimoshiretanaque: aitaque inquimoshiretacaajempi, coajica. ");
INSERT INTO cniNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ariorica inquisajeitempi atiripee, intianquempi, incantimatempi, incante te pincameetsateji. Ariorica inquishimentajeitempiro piquemisantana, iro cantaincha inquimoshiretacayempi Apa. Tempa noponeaca narori inquitequi, natiritapaaque. ");
INSERT INTO cniNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ariorica inquisajeitempi, pinquimoshiretasanotanaque, pincantajeite: “Cameetsave”. Tempa aitaque cameetsa impinatasanotempi Apa inquitequi. Queario yora intacantajeitaqueeri iquisajeitaquerini peerani yora camantacotiriniri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jero pashini aisati icantaqueriri Jesoshi: —Iro cantaincha yora ashitaarantincari, iquimoshireimentaro yashijeitari: moncarataca, iroashinoncayea irinti. ");
INSERT INTO cniNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Aisati iroashinoncayea quemarori yoari meeca: coajica inquemero itashe. Iroashinoncayea shirontajeitachari meeca: coajica incavintsaajeitea aisati iriraajeitea. ");
INSERT INTO cniNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ariorica irineacameetsajeitempi maaroni atiripee, pashinoncayea coajica: tempa yora intacarori ineacameetsajeitashitari yora amatavijeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Aisati icantajeitaqueri: —Pinquemisantajeitavaquena: pininteri avinti quisajeitimpiri, pincavintsayeri. ");
INSERT INTO cniNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pincanteri Tasorentsi iramitacojeiteri maaroni cantimajeitimpiri, aisati maaroni quisajeitimpiri. ");
INSERT INTO cniNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ariorica impasavorotempi pampatevoroqui, pishineteri impasavorotempi acaqueroca aisati. Ariorica iraapitsatempiro poicoro, pimperita pashini piitsaare aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ariorica iramanempiro paitapeerica, ari pimperi. Ariorica iraapitsatempiro pivaararo, eiro picoacotiritsi aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ariorica picoaque incavintsayempi itsipapee, ari pincavintsayeri avirori. ");
INSERT INTO cniNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ariorica pinintajeitiri maaroni nintajeitimpiri, tempa moncarataca: tecatsi incantea impinatempi Tasorentsi. Tempa ioti caari quemisantatsi inintiri nintiriri iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aisati oquempetaca: ariorica picavintsairi cavintsaajeitimpiri avirori, tempa aisati moncarataca. ¿Paita picoiri impinatempiri Tasorentsi? Aisati iriori caari quemisantatsi, icavintsairi cavintsaajeitiriri iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ariorica picoaque iroimpiajempi pipaqueriri pishaninca, tempa moncarataca: ¿Arimpa picoaque impajempi aisati Tasorentsi? Tempa aisati ipavacaa iriori caari quemisantatsi paitapeerica, aisati icoaque irovanayeneri iroimpiajeneri. ");
INSERT INTO cniNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Irootaque nocantantimpiri pincavintsayeri avinti quisajeitaquempiri, pincavintsante, pimpashiyeteari ashinoncaincari: eiro piquenqueshiretirotsi irimaterorica iroimpiajempi. Ariorica pantero oca, cameetsa: impinatasanotempi Tasorentsi, aisati intomintasanojeitempi. Cameetsa ipincatsariventanti anta jenoqui. Queario icavintsairi piatsajeitariri, yora caari cameetsajeitatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Icavintsantasanoti Apa: pinquempejeiteari. ");
INSERT INTO cniNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Eiro paamaashitaritsi pishaninca, aisati eiro picantitsi: “Ainiro irantane”, impoiji eiro icantimpitsi Tasorentsi: “Ainiro pantane avirori”. Eiro piquishimentiritsi pishaninca yantayetiri, irointi pincavintsayeri: impoiji eiro iquishimentimpirotsi Tasorentsi pantayetiri avirori, irointi incavintsayempi. ");
INSERT INTO cniNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ariorica pimpayeteri ashinoncaincari coiteimoyetariri, aisati inquempetajempi iriori Tasorentsi: impayetempiro maaroni coiteimoyetaquempiri avirori. Te irimashitsateji: impasanotempi. Ariorica capichaji pincavintsante, aisati capichaji incavintsayempi avirori. Ariorica oshequi pincavintsantasanote, ari oshequi incavintsaasanotempi avirori. Irootaque icantiriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jeroca ishiacaaventiniriri aisati Jesoshi: —¿Arimpa irimatero camarajaquiri irancatsatanaqueri iamarajaquiririnte? Eiro imatirotsi: tempa ari impariajeitaque omoroqui. ");
INSERT INTO cniNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aisati iquempeta, yora iroamere te iranaacoteriji oametiriri ioti. Iro cantaincha ariorica irishitoriatasanote, ariorica irimoncarateari. ");
INSERT INTO cniNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Paita piquishimentantariri pishaninca yantayetiri? Panaacotasanotiricari avirori. Oquempetaca picantiri pishaninca: “Pitijaquitaca ovane quipatsi”, iro cantaincha ainiro avirori pitijaquitacaro antearo inchato. ");
INSERT INTO cniNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Arimpa pincanteri: “Jentsite, noshaninca, naajempiro pitijaquiro”. Tempa pioti otimi inchato pashicajaquitaquempiri avirori. ¿Jaoca pincanteari paantajeanariri itijaquiro pishaninca? Pamatavitanti, pinquempetearime cameetsatasanotatsiri. Pamene, pijivate pojoquero antearora inchatora pashicajaquitaquempirira, impoiji pamenasanotanaje paantajeanariri itijaquiro pishaninca iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jero oca pashini ishiacantiniriri Jesoshi: —Ariorica ocameetsati inchato, ocameetsati oitsoqui iroori. Aisati terica oncameetsateji inchato, te oncameetsateji oitsoqui iroori. ");
INSERT INTO cniNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ariorica aneero oitsoqui inchato ayoti jaoca ocantari inchato iroori. Ariorica pincoaque chochoqui, ¿arimpa pijatashitero anta manitincanamashiqui? Eiro pijatitsi, tempa piotiro te oitsoquitantearoji chochoqui, iyera, ova, tecatsi catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ariorica anquenqueshiretero cameetsatatsiri, antayetero cameetsayetatsiri. Ariorica anquenqueshiretero caari cameetsatatsi, antayetero caari cameetsatatsi. Queario, aneanatantaro aquenqueshireyetiri. ");
INSERT INTO cniNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Paita picantashitantavetanari: “Novincatsarite”? Te pinquemisantenaji. ");
INSERT INTO cniNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aisati icantiri Jesoshi: —Meeca noshiacantempiri jaoca icantari quemisantanari. Iquemiro noneane, iquemisantasanotaquero: yantajeitaquero maaroni nocantaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ishiaqueri shirampari vetsiquirori ivanco. Iquiashitaquero tsompoina, irosati mapiqui aitaque yovecarataquerori. Ari oniri ominca mapiqui, oquisotantacari. Opariasanotaque incani, ooncanaca eni. Antearo catsini otatsincavetapaacaro, iro cantaincha te aaveeroji: quisotaque onaque mapi. ");
INSERT INTO cniNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Iro cantaincha yora caari quemisantana ishiaqueri shirampari vetsicavetarori ivanco, te intijacotasanoteroji. Impoiji ooncanaca, aanaquero ivanco. Ojaraanaque, aanaquero, te aneajeroji. Irootaque icantajeitiriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Impoiji ipianaja Jesoshi anta Caperenaoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Itimi anta nampitsiqui aparo capitano. Oromasati ini, caari ini jorio. Ijoquiitaca inampire, irotaintsi incame. Inintasanotiri capitano inampire. ");
INSERT INTO cniNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Iquemacotaqueri Jesoshi, itasoncantaque, irosati itiancantacariri jivatacaajeitiriri joriopee: —Pincamantaiteri Jesoshi impocanaqueta iroavisacotenari nonampire. ");
INSERT INTO cniNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ari yareejeitapaacari, icantasanojeitapaaqueri: —Pijatashiteri. Icameetsatasanoti yora capitanonta, oshequi inintajeitaquee arori. Yovetsicacantaqueenero pancotsi apatojeitantari. Cameetsa poavisacoteneri inampire. ");
INSERT INTO cniNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Ari yoijajeitanaqueri. Quempeji inapaaque, ineajeitavaqueri pashini ishanincapee capitano, itianquiri. Icamantapaaqueri: —Jero oca icantaqueri noyapitanote: “Nopincatsatasanotaqueri Jesoshi, iro caari notonquiotantavacari. Notseencaja narosati, irootaque caari nocoanta impoque novancoquica. Niotaque incoaquerica iroavisacoteri nonampire, ari iravisacotaje. ");
INSERT INTO cniNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Timatsi cantanari paitarica nanteri, aisati timatsi soraro notiancapinitiri. Noncanteririca: ‘Pijate’, ari irijataque. Noncanteririca: ‘Pimpoque’, ari impocanaque. Aisati noquempetiri nonampire iriori, ariorica noncanteri: ‘Jero oca panteri’, ari irantaquero”. ");
INSERT INTO cniNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iquemavaitiiri Jesoshi, yoanaque cavaco. Ari ipitsocashijeitacari oijajeitiriri, icantajeitiri: —¿Piquemaquerompa oca icantiri oromasati? Oshequi ishiretaquena, te inquempejeiteariji ashanincapee arori. ");
INSERT INTO cniNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ari impoiji ipiajeitanaja ishanincapee capitano. Ineapaaqueri inampire, avisacotaji. ");
INSERT INTO cniNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pashini quitaiteri ijatanaque Jesoshi anta Naiqui, icarajeitaqueri inampirepee aisati oshequi pashini oijajeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iquempejijeitapaacaro nampitsi, ineavaitiiri icompitacotapaaqueri camatsiri, intijerime. Iro iriniro camaintsiri camajimentaaro, aisati te intimeji pashini otomi. Oijatacoventiri otomini, ocarajeitiri oshequi oshaninca. ");
INSERT INTO cniNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ineantavacarori Avincatsarite, oshequi icavintsairo, icantaquero: —Eiro piraacotiritsi pitomi. ");
INSERT INTO cniNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ari ijatashitaquero cajo yoantacariri, ipamitaquero. Icatiacaapaacari compitacotiriri. Icantiri Jesoshi camaintsiri: —Evancari, pintinaaje. ");
INSERT INTO cniNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Irosati itinaantanaja, isavicaji; ineanatanaji. Impoiji icantiro Jesoshi: —Jerica pitomi, aneanaji. ");
INSERT INTO cniNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yoajeitanaque cavaco catsini neajeitaqueriri, icantajeiti: —Tempa icameetsati Tasorentsi. Itiancaqueeri oamejeiteerori irineane. Queario, itasoncaventaquee Tasorentsi, icavintsaajeitiri quemisantajeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Irosati iquemacojeitantacariri maaroni joreasati, aisati otsoteanaca neantsi pashinipeequi nampitsi. ");
INSERT INTO cniNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ari iquemacotaqueri Jesoshi iroamerepee Joa, yora vaotisatantatsiri. Ijatashijeitaqueri, icamantapaaqueri yantayetaqueri Jesoshi. Yora Joa, icajemiri iroamere apite, ");
INSERT INTO cniNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","itiancaqueri Avincatsaritequi, icantavaqueri: —Pijajeite Jesoshiqui, pisampitapeeri: “¿Avirompa Quirishito namenaajeivetari? ¿Pashinimpa naamaajeitea?” ");
INSERT INTO cniNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ari yareejeitapaacari, icantapaaqueri: —Itiancaquena Joa, icantana: “Pisampitaiteri Jesoshi: ‘¿Avirompa Quirishito naamaajeivetari? ¿Pashinimpa naamaajeitea?’ ” ");
INSERT INTO cniNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tecatsi incantea Jesoshi iranqueri, irointita yanti yoavisacoyetiri oshequi mantsiayetatsiri, aisati yoavisacoyetiri oshequi yatajeaoncayetiri camaari. Aisati yamenacaayetajiri oshequi caari amenayetatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Impoiji icantiri: —Meeca pijajeitaje, pincamantapeeri Joa aitaquenea pineacojeitaquenari aisati piquemacojeitaquenari. Pincamantapaajeri amenanaji yora caari amenaveitachani, aniitanaji yora caari aniiveitachani, avisacojeitanaji patsaayeveitachaniri, iquemayetanaji yora caari quemaveitachani, itinaayetanaja camayevetainchari. Aisati nocamantajeitiri ashinoncaajeivetachari jaoca incanteari irijate inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iquimoshireventajeitaquena maaroni quemisantasanotanari. ");
INSERT INTO cniNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ari ipiajeitanaja itiancane Joa, impoiji iquenquetsatacaajeitiri Jesoshi apatotimentariri. Iquenquetsatacotiri Joa, icantiri: —¿Paita pijatashijeitantariri Joa anta caaraiteriqui? ¿Pijitimpa itsataashita Joa, iquenquetsatashita? Te inquenquetsatashiteaji. ¿Pijivetarimpa icomitapinita, te irioteji paitarica iquenqueshiretiri? Tempa ioti. ");
INSERT INTO cniNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Paita pijatashitasanotantariri? ¿Irompa pijijeitaqueri ashitaarantincari ini, quitsaatarori cameetsamaori? Caari ini. Pamene, yora quitsaatarori cameetsamaori ishanincatacari pincatsari, aisati iquempetaca: iveshireimentaro irovaararo timatsiri ivancoqui pincatsari. Te inquempeteariji irinti Joa. ");
INSERT INTO cniNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Jentsite, pincamantena: ¿paita pijatashitiri? ¿Irimpa pijitiri quenquetsatirori irineane Tasorentsi pijatashitantariri? Tempa queario, iquenquetsatiro, iro cantaincha yanaacojeitiri itsipapee quenquetsatacantantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tempa piojeitiro sanquenarentsi cantatsiri: “Notiomi, nontianqueri jivatempineri, inquenquetsatacotempi. Incamantajeiteri atiri incameetsashirejeitanaque, inquemisantajeitempi”. Queario, oca sanquenarentsi oquenquetsatacotiri Joa Vaotisatantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yanaacojeitaqueri maaroni itsipapee quenquetsatacantantatsiri: imataquero maaroni icoacaaqueriri Tasorentsi, irootaque ineacameetsatantariri. Iro cantaincha ineacameetsatasanotiri catsini Tasorentsi maaroni ipincatsariventasanojeitiri. ");
INSERT INTO cniNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ari iquemajeitaqueri oshequi atiri icantaqueriri Jesoshi. Iquemantacariri, icantajeiti: —Queario, icameetsataque Tasorentsi. Aisati icarajeitaqueri quemajeitaqueriri yora ivaotisayetiri Joa, aisati apatoyetiniriri oromasati quirequi. ");
INSERT INTO cniNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Irintiquea yora variseo aisati yora oametantirori sanquenarentsi te irinintajeiteji iranteneri Tasorentsi icoacaavetariri, aisati te irijatashiteriji Joa irivaotisateri. Te iriveshireimentearo irinti icantiri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Icanti Jesoshi aisati: —¿Paitaquea? ¿Jaoca icantari yocapee? ¿Paitaniquea caari iquemisantantana yoca? Te inquenqueshiretimateaji. ¿Paita noshiacanteri? ");
INSERT INTO cniNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Irio noshiacanteri jananequi, isavicajeiti nampitsiqui nianqui, icanti aparo: “Apaniro nosoncavetaca, iro cantaincha te poijatacotenaji, te pimaninqueteji. Noashiretacovetari camaintsiniri, iro cantaincha te poashireteaji avirori”. ");
INSERT INTO cniNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pamene, yora Joa ititapinita, te iririmateroji cachojari, jero picantajeiti: “Irio camaari pincacairiri, caari yoasanotanta, aisati caari irantaro cachojari”. ");
INSERT INTO cniNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iro cantaincha noponeaca nainti inquitequi, natiritapaaque: noapinita aisati nirapiniti. Aiquero picantajeiti: “Jerinta oashenti, shinquinarinti. Ishanincatacari apatotapinitiniriri oromasati quirequi, icarajeitapinitiri caari cameetsajeitatsi”. ");
INSERT INTO cniNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ontimimotaquempiricame piotantari, piotaqueme te ontampaticateji picantajeitiri. ");
INSERT INTO cniNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ari aparoni variseo icantiri Jesoshi: —Caate novancoqui, avajeitea. Yacanaqueri: —Jaa, ari. Ari ijajeitanaque, yoajeitaca. ");
INSERT INTO cniNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Otimi anta nampitsiqui tsinane antapinivetarori caari cameetsatatsi. Oquemacotaqueri Jesoshi, yoa anta ivancoquinta variseo, ojatashitiri oneeri. Aacotanaqueneri casancajari. Iro aacotantanacanariri mapi quitamarori imoqueetiri. ");
INSERT INTO cniNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ocatiapaaca itapiiqui Jesoshi, quempeji. Iraasanotapaaca, ovitejantacari ojaqui iitiqui, iro oshetantajanariri oishi. Impoiji onintiri iitiqui, aisati osaitantacari iitiqui casancajari. ");
INSERT INTO cniNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ineantavacarori yora variseo, iquenqueshiretanaca: “Iriome itiancane Tasorentsi, iriotavaquerome oca tsinane. Oshequi antapinitiro caari cameetsatatsi, eirome ishinetarome antiterime iiti”. Ipajita variseo Shimo. ");
INSERT INTO cniNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iotaqueri Jesoshi iquenqueshiretiri, icantiri: —Shimo, timatsi noncamantempiri. Yacanaqueri: —¿Paita pincamantenari oametanari? ");
INSERT INTO cniNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—Noshiacantempiro. Itimi shirampari irevitiriri 5,000 soles, itimi pashini irevitiriri 500 soles. ");
INSERT INTO cniNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iro cantaincha te irimateroji yora apitetatsiri iroimpiajeneri iirequite, irootaque icantantariri: “Aitanaji, eiro pipinatanatsi. Nopashitimpiri”. Tempa icavintsairi apite. Aparo irevivetacari capichaji, irinti itsipa irevitasanovetacari. Pincamantena: ¿janica neacameetsatasanoterineri? ");
INSERT INTO cniNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yacanaqueri: —Naamaaca yora irevitasanovetariri, tempa iriotaque icavintsaasanotiri catsini. Icantiri: —Queario picantaque. ");
INSERT INTO cniNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Impoiji yamenaquero Jesoshi tsinane, icantiri Shimo: —Pamene, incaranqui noqueapaaque aca pivancoquica, iro cantaincha te paacameetsatavaquenaji: te pimpavaquenaji nija nonquivantapeemparomeri noiti. Pineaquero irointi oca tsinaneca. Oquivantapaaquenaro ojaqui noiti, aisati oshetantaquenaro oishi. ");
INSERT INTO cniNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Te pinintavorotenaji, irointi oca, onintapinitaquero noiti. ");
INSERT INTO cniNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Te pisaitantenaro noitoqui quejitsi, irointi oca, osaitantaquenaro noiti casancajari. ");
INSERT INTO cniNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pamene, ainiro antayevetari oshequi, iro cantaincha nocavintsaaquero, eiro noquenqueshireacotajirotsi antayetiri: tempa oshequi onintasanotaquena. Ariorica noncavintsayeri antayevetarori capichaji, capichaji irinintavaquena iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","(v 48, 50) Ari icantiro tsinane: —Ainiro onaveta pantayevetari, iro cantaincha eiro noquishimentimpirotsi, eiro noquenqueshireacotimpirotsi aisati. Pishiretaquena, irootaque pavisacotantajari. Cameetsaya pijataje, piveshireasanotanaquea. ");
INSERT INTO cniNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ainiro inaveta oacojeitacariri, isampinatavacaaca: —¿Paitampa ijita yoca, icavintsantarori antirori caari cameetsatatsi? ");
INSERT INTO cniNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","(-) ");
INSERT INTO cniNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pashini quitaiteri iquenaquenayetanaque nampitsipeequi Jesoshi. Iquenquetsatacaajeitiri atiri, icamantajeitiri: —Irotaintsi impincatsariventajeitempi Tasorentsi. Quiso yoanajiri iroamerepee, yora carajeitatsiri 12, ");
INSERT INTO cniNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","aisati oijajeitiri tsinanepee. Peerani yoitsaviantaveitaroni camaari, aisati ojoquiiveitani, iro cantaincha yoavisacojeitajiro Jesoshi. Opajita aparoni tsinane Maria Maquitarasato. Icaraveitani camaari oitsaviantaveitaroniri 7. ");
INSERT INTO cniNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Iro oijatiriri pashini, opajita Joana, ijina Cosa. Yora Cosa, iriotaque amitacotiriri pincatsari Eroreshi. Aisati iroori oijatiri Sosana, aisati otsipapee tsinanepee. Oca tsinanepee amitacotapinijeitiri Jesoshi, opapinijeitiri coiteimotacariri. ");
INSERT INTO cniNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yapatotimentajeitacari Jesoshi oshequi atiri, ari ishiacantajeitiniri, icantiri: ");
INSERT INTO cniNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Ari ijataque shirampari yojocaitiro oitsoqui tirico oaantsiqui. Aparopee pariitapaintsi avotsiqui: yaaticayetaquero aniiyetatsiri, impoiji yoajeitacaro contsaropee, itsoncaquero. ");
INSERT INTO cniNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pashinipee pariitapaintsi mapiqui. Oparitsavetanaca capichaji, iro cantaincha te oncajavatsatimateji, irootaque oshimpetantanacari, ocamajeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pashini pariitapaintsi quitotseequimashiqui: oshiocavetanaca, iro cantaincha anaanaquero quitotseequi, irootaque ocamantacari. ");
INSERT INTO cniNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Iro pashini pariitapaintsiri cameetsariqui quipatsi: oshiocanaque, otimasanotanaque oitsoqui oshequi. Irootaque ishiacantajeitiniriri, impoiji antearojenca icantajeitiri: —Otimirica piquemantari, pinquemasanotavaquero. ");
INSERT INTO cniNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Isampijeitiri iroamerepee: —¿Paita pishiacantiri incaranqui? ");
INSERT INTO cniNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yacanaqueri: —Icoacaaquempi Apa Tasorentsi piojeitero caari iojeiti itsipapee atiri. Avintiquea niotacaaquempi jaoca icanta Apa ipincatsariventajeitaquempi. Irio noshiacantajeitiniri yoranqui: iramenajeivetea, iro cantaincha eiro ineasanotitsi; inquemajeivetea, iro cantaincha eiro iojeitavaquerotsi. ");
INSERT INTO cniNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jero oca noshiacaaventimpiri: oca oitsoqui oshiacaaventiro irineane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oca avotsi opariantavetapaacari oitsoqui oshiacaaventiri quemajeivetavacarori irineane Tasorentsi: ipocapaaque camaari, yojocacaajiri iquenqueshirevetacaro irineane. Te irinintacayeriji inquemisante aisati iroavisacotea. ");
INSERT INTO cniNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Orari mapitaintsiri opariantavetapaacari oitsoqui, oshiacaaventiri veshireimentavetarori irineane Tasorentsi, ineacameetsavetacaro. Iquemisantaveta, iro cantaincha te inquearioventeroji: ariorica opomerentsitimotacari iquemisantaveta, ari yojocanajiro. ");
INSERT INTO cniNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aisati oquempetaca quitotseequimashi opariantavetapaacari: oshiacaaventiri quemajeivetacarori irineane Tasorentsi, iro cantaincha iquenqueshiretasanotiro yantapinitiri, iveshireimentaro yashiyetari, aisati icoaque inquimoshiretashitea. Yatsipetashitaro iquemavetaro irineane Tasorentsi: te inquemisantasanoteroji, te iranteneriji Tasorentsi icoacaavetacariri. ");
INSERT INTO cniNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ocari cameetsataintsiri quipatsi oshiacaaventiri quemasanotavaquerori irineane Tasorentsi. Iquearioventaquero iquemisantasanotaque, icameetsashiretanaque. Iriotaque matasanotirori maaroni icoacaaqueriri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jero aisati yoamejeitiriri Jesoshi iroamere: —Ariorica antsiotero tsiomentotsi amenajeitanteari, ¿arimpa antatacotero cantiriqui? ¿Arimpa amanaquero jaocarica ara? Tempa ocameetsati avanqueteri jenioquiji onconijajeitanteari paitapeerica. Irootaque noamejeitantaquempiri: nocoaque piotasanojeite. ");
INSERT INTO cniNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tequera piojeite jaoca icantari Tasorentsi ipincatsariventajeitaquempi, iro cantaincha coajica piotasanojeitajero. ");
INSERT INTO cniNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pinquemasanojeitavaquena piojeitantajeari. Capichaji piotaque meeca, iro cantaincha ariorica pinquemisantasanotena, nontsoteajeitempiro, niotacaasanojeitempi. Ariorica pijiveta pioti, eiro piquemisantanatsi, impoiji icomitacaasanotimpicari Tasorentsi: tecatsi piotimataje. ");
INSERT INTO cniNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Impoiji ojatashitiri Jesoshi iriniro, otsipajeitari irirentipee. Yareejeitapaaca pancotsiqui anta isaviquinta, iro cantaincha tecatsi incantajeitea intsipajeitapeempari: yojocaajeitavaqueri oshequi atiripee. ");
INSERT INTO cniNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Icamanteetiri: —Ocoapaaquempi piniro, jeri pirentipee. Osavicapaaque anta saiteriqui. ");
INSERT INTO cniNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Iro cantaincha yacanaqueri: —Nonirontacaro maaroni quemisantasanojeitiriri Tasorentsi, maaroni antasanotiniriri icoacaaquerori. Aisati nirentijeitacari maaroni quemisantiriri. ");
INSERT INTO cniNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pashini quitaiteri itetajaro Jesoshi pitotsi, icarajeitaqueri iroamerepee. Icantiri: —Tsame amonteajeitanaje intatiquero incajare. ");
INSERT INTO cniNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ari ijatacojeivetanaca, aacotanaqueri tampea. Ari ijatacotaque nianquijaqui, imaanaque Jesoshi. Impoiji omapocajeitaqueri antearo tampea, otejatapaacaro nija pitotsiqui, irotaintsi intsitiacojeite. ");
INSERT INTO cniNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Icaocaqueri iroamerepee: —Pintinaye, oametanari, irotaintsive antsitiacojeite. Ari itinaanaca, impoiji ipeajiro tampea, ipeajiro omotoncane: opeasanotanaja. ");
INSERT INTO cniNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Icantiri: —¿Paita caari pishirejeitantana? Itsaroacaajeitanacari, aisati yoajeitanaqueri cavaco. Icantavacaajeitanaca: —¿Janicampa yoca? Imataquero tampea, aisati omotoncane: ipeajiro. Te aneapiniteroji oca. ");
INSERT INTO cniNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ari iponeanajari Jesoshi Carireaqui, meeca yareetapaaca intatiquero: anta Jerasequi. ");
INSERT INTO cniNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yaatacotapaaque, yamatsecajeitanaque quipatsiqui. Ineapaaqueri neiriri camaari: peerani, te inquitsaateaji. Te irisaviqueji pancotsiqui, irointi iquenaquenatsempequiyeti anta tijaariqui. ");
INSERT INTO cniNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ineantavacariri Jesoshi, itiyeroashitavacari, icajemanaque: —¿Jaoca pincantenari? Niotavaquempi: avirotaque itomi Tasorentsisanori savicatsiri inquitequi. Eiro piquematsitacaanatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iro icajemantacari, itsaroacaavacari Jesoshi, iotaque camaari intianqueri. Yora shirampari ineapinitiri camaari, iquenacaapinitiri. Yoisotapiniyeevetari iracoqui aisati iitiqui carenatsa, iro cantaincha ishintsitacairi camaari, ipesantarori carenatsa yoisotanteevetacariri. Ariorica ipesanaquero, ishiacaanacari camaari caaraiteriqui. ");
INSERT INTO cniNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Icantiri Jesoshi: —¿Jaoca pipajitari? Yacanaqueri: —Nopajita Oshequianti. Iro ipajitantacari Oshequianti ineaqueri oshequi camaari. ");
INSERT INTO cniNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Ari itimi anta tioncaiquiji oshequi chancho yoajeita. Yora camaari icantiri Jesoshi: —Eiro pitiancajeitanatsi Sharincaveniqui, ainti pintiancajeitena anta chanchoqui, nonijaapeemparita iriori. Ari icantiri: —Pijajeite. ");
INSERT INTO cniNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ari yojocajeitanajiri shirampari, inijaajeitapaacari chanchopee, irosati ishiajeitantanaca, ipariajeitanaque imperitaqui, ipiincajeitanaque incajarequi, pocn, pocn, pocn, itsitiajeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ari ineantavacariri, ishiajeitanaca shentajeivetariri chancho, icamantajeitaqueri ishaninca anta nampitsiqui aisati oantsiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ari ipocajeitaque irameneri yora neaveitariniri camaari, jaocarica icantajari. Ineapaaqueri, tecatsitaji inaji; tecatsi oajerine, isavicaji Jesoshiqui. Iquitsaataja, otimanaji iquenqueshiretantari. Itsaroacaajeitapaacari. ");
INSERT INTO cniNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yora neasanotaqueriri icamantajeitavaqueri maaroni ishaninca yantiri Jesoshi, itsoteaqueneri. ");
INSERT INTO cniNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ari itsaroajeitanaque catsini maaroni timajeitatsiri ara. Itiancajeitajiri Jesoshi: —Pijataje, eiro pipocajitsi aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Irintiquea yora neaveitariniri camaari icantavetari: —Nocoaque noijatanaquempi. Iro cantaincha icantiri: ");
INSERT INTO cniNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Eiro poijatanatsi, ainti pijataje pivacoqui. Pincamantajeitapeeri pishaninca oshequi icavintsaaquempi Tasorentsi. Ari ijatanaque, iquenaquenayetanaque nampitsiqui, icamantajeitiri ishaninca: —Pineaquena: oshequi icavintsaajana Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Impoiji ipianaja Jesoshi, imonteanajaro incajare. Yoyeajeitaqueri oshequi atiri, yaacameetsajeitavaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Itonquiotavacari shirampari pajitachari Jairo: iriotaque jivatacaantatsiri anta pancotsiqui yapatojeitantari. Itiyeroashitapaacari iitiqui Jesoshi, icantapaaqueri: —Tsame novancoqui, irotaintsi oncame nishintio. Apaniro oni irishinto, ocarataque osarintsite 12. Ari yoijatanaqueri, itsitacajeitanacari oijajeitanaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Oijatanaqueri aisati tsinane irajashetatsiri: ocarataque 12 osarintsi intantanacari irajashetanaque. Tecatsi materoneri iroavisacotajero. ");
INSERT INTO cniNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Oquenapaaque itapiiqui antitaqueri iitsaare ocaratapaaque, irosati opeantanajaro iraja. ");
INSERT INTO cniNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ari icanti Jesoshi: —¿Janica antitaquenarori noitsaare? Icantajeitanaque: —Te nantitempiro piitsaare. Impoiji icanti Petero: —Oametanari, icarajeiti atiri oshequi ishoncajeitaquempi, itsitacajeitaquempi. Aiquero picantanaitii: “¿Janica antitaquenarori noitsaare?” ");
INSERT INTO cniNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Iro cantaincha yacanaqueri iriori: —Ainiro antitaquenarori. Ocamantaquena notasorenca: timatsi notasoncacoventajiri. ");
INSERT INTO cniNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Iotaque tsinane tecatsi oncantea omanapitsateri antitaqueri iitsaare. Opioncanaque, ojatashitiri, otiyeroashitacari, ocantiri: —Narotaque antitaquempirori piitsaare, irootaque navisacotantajari nirajaveitani. Iquemajeitavaquero maaroni atiripee. ");
INSERT INTO cniNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aisati icantaquero Jesoshi: —Noshaninca, pishiretaquena, irootaque pavisacotantajari. Cameetsa pijataje pivancoqui, pinquimoshiretanaje. ");
INSERT INTO cniNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ari pashini pocapaintsi ishaninca Jairo camantapairiri: —Camanaque pishinto. Eiro picantiritsi meeca oametantatsiri irijate avancoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iquemavaqueri Jesoshi, icantiri: —Eiro picantashiretitsi. Ariorica pishiretena, ari avisacotanaje pishinto. ");
INSERT INTO cniNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ari yareejeitapaaca pancotsiqui. Icanti Jesoshi: —Eiro avinti piqueajeitapaitsi: irintiquea queapaintsine Petero, Joa, Santiaco, iri, aisati iniro, aitapaaji. ");
INSERT INTO cniNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ainiro iraacojeitacaro oshanincani, yoashiretacojeitacaro. Icantajeitaqueri Jesoshi: —Eiro piraacojeitarotsi: te oncamasanoteji, irointi omai. ");
INSERT INTO cniNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ishirontimentajeitacari, iojeitaque ocamasanotaque. ");
INSERT INTO cniNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ari yajiricavacotaquero, antearojenca icanti: —Evancaro, pintinaanaje. ");
INSERT INTO cniNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Irosati otinaantanaja. Icanti: —Pimpero oyeari. ");
INSERT INTO cniNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ari yoajeitanaque cavaco maaroni oshaninca, iro cantaincha icanti Jesoshi: —Eiro meeca picamantitsi. ");
INSERT INTO cniNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Impoiji yapatojeitiri Jesoshi iroamere, imatacaajeitaqueri itasoncacaaqueri itsipapee, icantajeitiri: —Nocoaque pojocacoventajeiteri atiripee camaari, pimateri maaroni camaaripee, aisati poavisacojeiteri maaroni mantsiayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Meeca pijajeite. Pinquenaquenayetanaque, pincamantajeiteri atiri: “Irotaintsi impincatsariventajeitempi Tasorentsi”. Aisati poavisacoyeteri mantsiayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Noncantempi, tecatsiya paanaque: eiro paanaquerotsi piotiquiro, pitsarate, poyeari, piirequite, poicoro, tecatsi catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jaocarica pareetapaaqueari, ari pisavicapaaque. ");
INSERT INTO cniNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eirorica iquemisantajeitavaquempitsi savicajeitatsiri, povaanajea. Ariorica povaanajea pincantajeitanaqueri: “Meeca te pinquemisantenaji, ari iroasanquetempi Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ari ijajeitanaque, iquenayetanaque nampitsipeequi. Icamantajeitaqueri atiri jaoca incantajeiteari iravisacotantajeari. Aisati yoavisacoyetajiri mantsiayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ari yora pincatsari Eroreshi iquemacotaqueri yantayetaqueri Jesoshi, itasoncantayetaque. Te irioteji paitarica inquenqueshireteri. Icantayeti: “Irio Jesoshitajantsiri Joani: itinaanaja”. ");
INSERT INTO cniNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Icantayeti itsipapee: “Yonijaantaja aisati Iriashi”. Pashini cantayetatsi: “Itinaanaja camantantatsiniri”. ");
INSERT INTO cniNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Iro cantaincha icanti Eroreshi: —Nopesacantaqueri Joani: camaque inaque. Iro cantaincha, ¿janica yoca aquemacojeitaqueri itasoncacoventajeitaqueri atiripee? Nocoaque noneeri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ari ipiajeitanaja itiancajeitaqueri Jesoshi, icamantajeitapaaqueri imayetaqueri. Impoiji itsataajeitanajiri yaajeitanajiri iroamere anta Vetsairaqui. ");
INSERT INTO cniNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Iro cantaincha iojeitaqueri atiri ijatanaque, yoijajeitanaqueri oshequi. Ari yovetsajeitavacari Jesoshi, yoamejeitavaqueri jaoca icanta Tasorentsi ipincatsariventajeitaqueri. Aisati yoavisacojeitaqueri mantsiaripee. ");
INSERT INTO cniNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ari ishaavijiiteanaque, ipocashitiri iroamerepee, icantajeitiri: —Pamenerote, caaraiteitaque aca. Pintiancajeiteri meeca nampitsipeequi: otiminta irimaajeitanteari aisati iroajeitanteari. ");
INSERT INTO cniNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Iro cantaincha icantavaqueri: —Pimpajeiteri avinti iroajeiteari. Icanti: —Tecatsi nompajeiteriri. Pamene, ocarataque tantajaniqui apapacoroni. Jeri apite shima. ¿Picoaquempa nojajeite namananteneri iroajeiteari maaroni yocapee? Oshequi ini catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aamaaca icarajeiti shirampari 5,000 yapatojeitaca. Icantiri Jesoshi: —Poisavicajeiteri maaroni: pimoncarajeiteri incarayetaque yora 50 irampatojeitaquea, aisati iriori yonta 50. Aisati inquempejeitaqueari maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ari imajeitaqueri, yapatojeitaqueri. Yoisavicajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Impoiji yajiricaquero Jesoshi tanta, jeri aisati shima. Yamenanaque inquitequi, icantiri iriri: “Ariove, Apa, pipaquenaro noyeari”. Impoiji ipaqueri iroamere, icantaqueri: —Jeri, povaajeiteneri yora apatojeitaincharira. ");
INSERT INTO cniNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ari yoajeitaca maaroni, iquemajeitaca. Impoiji yaajeitajiro timaarantapaajantsiri, yapatotajiro. Ocarataque cantiriqui ijaajiri 12. ");
INSERT INTO cniNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pashini quitaiteri ijatanaque apaniro Jesoshi iquenquetsatacairi iriri. Iotanajiri yaanajiri iroameresanori. Impoiji isampitiri: —¿Janica ijitaquenari ashaninca? ¿Paita icantajeitiri? ");
INSERT INTO cniNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yacanaqueri: —Icantayeti aparopee: “Irioitatsi Joani vaotisatantaveitachaniri, itinaanaja”. Irio pashini icanti: “Irioitatsi Iriashi, yonijaantaja aisati”. Irio pashini icanti: “Irioitatsi camantantatsiniri, itinaanaja”. ");
INSERT INTO cniNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Isampitiri: —Avintiquea, ¿paita picantajeitiri? Yacanaqueri Petero: —Avirotaque Quirishito naamaajeitacari. Itiancaquempi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iro cantaincha icantasanojeitiri: —Eiroyea picamantitsi. ");
INSERT INTO cniNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Queario, noponeaca inquitequi, natiritapaaque, iro cantaincha oshequi nonquematsicateari. Intseencajeitena savicacantajeitatsiri, jivatacaajeitiriri saserotepee, oametantirori sanquenarentsi, maaroni. Incantajeite: “Caari ini Quirishito”. Iroyeetena, oncarataque quitaiteri mava, nontinaanaje. ");
INSERT INTO cniNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Impoiji icantajeitiri Jesoshi: —¿Picoajeitaquempa poijatasanojeitaquena? Ari eiro picavintsaajatsi avisati, eiro pantanontatsi avisati. Maaroni quitaiteri pimpomerentsiventenaro nocoacaaquempiri: ariorica iroimenteetempiro, ariorica inquishimenteetempiro. Iro cantaincha quiso poyena, poijatasanojeitanaquena. ");
INSERT INTO cniNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ariorica pantanontea pincavintsayea avisati meeca, eiro piotasanotiritsi meeca Tasorentsi, aisati eiro pisaviquimotiritsi coajica. Ariorica pinintena narori, aisati pimpomerentsiventayetenaro meeca nocoacaajeitimpiri, eiro patsipetarotsi, irointi piveshireimenteari meeca Tasorentsi, aisati pisaviquimoteri coajica. ");
INSERT INTO cniNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ariorica pimpiotasanojeitero vaararontsi catsini, iro cantaincha pintseenqueri Tasorentsi; impoiji pijate Sharincaveniqui. Tempa pantsipetashijeitearo maaroni pashijeiveteari. ");
INSERT INTO cniNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Eiro pipashiventacaanatsi; aisati noneane, eiro pipashiventacaarotsi. Tempa naro poneachari inquitequi, natiritapaaque. Coajica nojatanaje jenoqui. Impoiji nompiapaaje aisati aca quipatsiqui, nompincatsaritasanotapaaque, nontasorentsitasanotapaaque: nonquempeteari Apa aisati maaroni inampirepee. Iro cantaincha pinquenqueshirejeitea: ariorica pimpashiventacayena meeca, nompashiventacaaquempi coajica avirori. ");
INSERT INTO cniNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iro cantaincha queario oca noncamantempiri, eiro namatavitimpitsi: eirotsitarica picamajeiti, pineajeitavaquero jaoca icanta Tasorentsi ipincatsariventanti. ");
INSERT INTO cniNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ari ocarataque quitaiteri 8, ijataque Jesoshi toncaariqui, inquenquetsatacayeri iriri. Yaanajiri aisati Petero, Santiaco, jeri Joa. ");
INSERT INTO cniNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ari iquenquetsatacaapaaqueri iriri, imapocanaca ipashinivorotanaque, aisati oshipaquireasanotaque iitsaare, atsioquintaqueri yora amenajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Imapocapaaqueri aisati apite shirampari, iquenquetsatacaapaaqueri Jesoshi. Irio pocaintsiri Moishishini aisati Iriashini; ");
INSERT INTO cniNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","te inquempeteeji aquempejeita arori, icameetsatasanotaque: iquempejeitacari inquitesati. Ari iquenquetsatavacaajeitaca mava: iquenquetsatacotiro incame coajica Jesoshi anta Jerosarequi. ");
INSERT INTO cniNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Oshequi ipochoquivetanaca Petero aisati itsipajeitari, iro cantaincha te irimayeji. Yamenashejeitaqueri Jesoshi, ishipaquireaque, iquempetacaro quitaiteri. Aisati yamenashejeitaqueri yora itsipajeitari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Irotaintsi impianaje yora apitetaintsiri, icantiri Petero Jesoshi: —Oametanari, aitaquempa nopocaque narori aca, noneajeitaquempi. Nocoaque novetsiquempiro mava pancotsijaniqui: aparo pashi, aparo irashi Moishishi, aparo irashi Iriashi. Ari ineaveetashitaca Petero, te inquenqueshireteaji. ");
INSERT INTO cniNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ari omapocanaca mencori, omaaroncajeitapaacari, irosati itsaroajeitantanaca. ");
INSERT INTO cniNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Impoiji iquemajeitaqueri Tasorentsi, inaque mencoriqui: —Iriotaque yoca notomi nonintasanotiri: pinquemisantajeitavaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Impoiji yamenajeivetanaca: tecatsi irinee, apaniro irinti Jesoshi. Ari imanajeitaquero: peerani, tecatsi incamantajeite. Impoiji, icamantaquee. ");
INSERT INTO cniNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Oquitaitetamanaji, yoirincajeitamanaja, itonquiojeitavacari oshequi atiri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Icantavaqueri aparoni: —Oametanari, pincavintsayeri notomi, te intimeji pashini. ");
INSERT INTO cniNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yatajeaoncaqueri camaari, icajemacaapinitiri. Yampitsiitacaapinitari, ishimoretacaapinitari. Yoashinoncaapinitaqueri: te irinijantareempariji. ");
INSERT INTO cniNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nocantavetacari poamerepee iroavisacoteri, iro cantaincha te irimateriji. ");
INSERT INTO cniNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yacanaqueri Jesoshi: —Eiro imatiritsi: tempa irinti pitseencaririnte, irootaque caari imatantari camaari; te pinquenqueshirejeitempa. ¿Arimpa noshinetempi pintseencantapinite? Jentsite pamaquenari. ");
INSERT INTO cniNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jeri inianquitacaavetapaacari itomi, imapocanaca camaari ipishoncaqueri quipatsiqui, yampitsiitacaanajari aisati. Ari itiancajiri Jesoshi camaari, yoavisacotajiri jananequi. Icantiri iriri: —Jerica pitomi: avisacotaji inaji. ");
INSERT INTO cniNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yoajeitanaqueri cavaco maaroni atiripee icantavacaajeitanaca: —Tempa itasorentsitasanoti catsini Tasorentsi. Ainiroquera icantavacaajeitaca, icantiri Jesoshi iroamere: ");
INSERT INTO cniNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Pinquenqueshiretasanotero oca noncamantempiri. Eiro pipeacotarotsi. Noponeaca inquitequi, natiritapaaque, iro cantaincha irayeetena. ");
INSERT INTO cniNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iro cantaincha te inquemajeitavaqueroji icantavetacariri. Te irishineteriji Tasorentsi inquemajeitavaquero. Itsaroacaajeitacari irisampiterime: “¿Paita picantaqueri?” ");
INSERT INTO cniNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Impoiji icantavacaajeitanaca iroamerepee Jesoshi, yaamaajeitaca: —Aca acarajeitica: coajica, ¿janica anaacotantajantsine impincatsaritaje? ¿Narompa pimpincatsajeite? ");
INSERT INTO cniNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iotashitacari Jesoshi iquenqueshirejeitiri. Icajemiri jananequi: —Caatanaque aca nonampinaqui. ");
INSERT INTO cniNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Impoiji icantajeitiri iroamerepee: —Pameneri jananequica, quemisantanari. Ariorica pincavintsayeri yoca, pincavintsayena narori. Ariorica pincavintsayena, aisati pincavintsayeri tiancaquenari. Ariorica pincavintsayeri itsipapee, ari pimpincatsaritanaque. ");
INSERT INTO cniNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Impoiji icantiri Joa: —Oametanari, chapinqui noneaqueri shirampari oavisacoyetiriri neiriri camaari. Icamantavetana iquemisantimpi, irootaque imatantariri yoavisacotiri. Iro cantaincha te quiso iroajeitee, irootaque notsaneacotantacariri iroavisacoteri neiriri camaari. ");
INSERT INTO cniNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yacanaqueri Jesoshi: —Eiro pitsaneapitsataritsi. Te inquisajeiteeji, irootaque ayotantacari iquempejeitaquee. ");
INSERT INTO cniNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Te osamaniteji meeca: irotaintsi irijataje Jesoshi inquitequi. Ari iquenqueshiretaca irijate Jerosarequi. ");
INSERT INTO cniNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Itiancaqueri iroamere: —Pijivatanaque anta Samariaqui, pamenapeero asavicantajeitapeempari. ");
INSERT INTO cniNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ari ijavetanaca, iro cantaincha iojeitaque samariasati irijate Jesoshi Jerosarequi, irootaque itsaneapitsatantavacariri irisavicantapeempameri inampiqui. Ari ipianaja, icamantapaajiri Jesoshi: —Eiro ishineteetsi amaye inampiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ari iquemantacariri Santiaco aisati Joa, icantiri: —¿Novincatsarite, picoaquempa noncanteri Tasorentsi intaajeiteri maaroni samariasati? Nonquempeteari Iriashini peerani: itaacantaqueri soraro quisajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yamenashetaqueri Jesoshi, icantiri: —Te oncameetsateji anquisheri. Te piojeiteji jaoca picantacari: te pincameetsashireteji. ");
INSERT INTO cniNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Noponeaca narori inquitequi, natiritapaaque. Te iro nompocantea noayeteri atiri, irointi nopocantaca noavisacojeiteri. Impoiji yovaajeitanaja pashini nampitsiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ari iquenajeitanaque avotsiqui, itonquiotavacari shirampari, icantavaqueri Jesoshi: —Novincatsarite, nocoaque noijatasanotanaquempi, jaocarica pijateri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Icantiri: —Natiritapaaque noavisacotanteariri atiri. Pinquemisantavaquero oca noncamantempiri: yora otsitiniro timatsi imoro imaapinitantari, yora tsimeripee timatsi itsitiyetari; iro cantaincha nainti, tecatsi nomaanteari. ");
INSERT INTO cniNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Impoiji icantiri pashini: —Poijatanaquena avinti. Yacanaqueri iriori: —Novincatsarite, nocoaveta, iro cantaincha incamavaquetsita apa. Ariorica nontijeri, impoiji noijatanaquempi. ");
INSERT INTO cniNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ipiatacari Jesoshi: —Ainiro itseencaririnte, iriotaque tijerine ariorica incamaque. Aviroquea avinti, pincamantajeiteri atiri jaoca icanta Tasorentsi ipincatsariventajeitiri. ");
INSERT INTO cniNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Icantiri pashini shirampari: —Aitaque, novincatsarite, noijatasanotanaquempi: iro cantaincha nojivajeitapainterita novetsajeitapainteari noshanincapee. ");
INSERT INTO cniNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iro cantaincha icantiri Jesoshi: —Ariorica pitsapatiro piquiiro quipatsi pimpanquitantearori pivanquire, te pamenamenayetero paitapeerica, caari otipitantayeta piquiaqueri. Aisati oquempetaca: pincoaquerica impincatsariventempi Tasorentsi, poijatasanotena, eiro piquenqueshiretirotsi pantajero aisati pantapiniveitaniri. ");
INSERT INTO cniNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Impoiji itiancajeitaqueri oshequi iroamere irijivajeitanaqueri, icarajeiti 70. Icantavaqueri: —Pijajeite, apitepee pincantayetanaquea. Pijivajeite nampitsipeequi nocamantajeitaquempiri, nimpoitanaje narori. ");
INSERT INTO cniNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Oquempetaca ocarataque oshequi oitsoqui panquirentsi, aparaitanaca: te iroshequiteji aviiteroneri. Pincanteri Avincatsarite intiancajeitanteariri oshequi amitacotempineri pinquenquetsatacaajeiteri atiri, irijajeitanteari iriori inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pamene, oshequi ompomerentsitimojeitempi, oshequi irantanatempi tseencantatsiri: pinquempeteari ovisha, itsoncaqueri maniti. Meecaquea, pijajeite pinquenquetsajeite. ");
INSERT INTO cniNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Eiro paanaquerotsi pitsarate, piirequite, pisapatote. Ariorica pintonquiotavaqueari atiri nianqui, eiro piquenquetsatacaavaqueritsi, irointi pavisanaqueri: apatiro povaanaquero onta nocantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jaocarica pisavicapaaqueri, pincanteri Tasorentsi iramitacoteri ashitarori ivanco inquemisantanteari. ");
INSERT INTO cniNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ariorica inquemisantaque, iravisacotaje. Irompa eirorica iquemisanti, iro cantaincha eiro patsipetarotsi pinquenquetsatacayeri Tasorentsi: tempa pimataqueneri oca nocantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jaocarica anta pisavicapeeri, aitaque pisavicavaquetsita. Eiro piquenaquenayetitsi pancotsipeequi. Poyearo paitarica impavaquempiri, aisati pirero, maaroni. Ocameetsati impavaquempi paitapeerica coiteimotaquempiri: tempa ocameetsati impinateri shirampari antaveetiniriri. ");
INSERT INTO cniNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jaocarica pijateri, ariorica iraacameetsatavaquempi, poapaaquearo paitarica impavaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Intimerica mantsiaripee, poavisacojeiteri. Pincamantajeiteri maaroni: “Irotaintsi impincatsariventajeitempi Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Iro cantaincha terica iraacameetsatempi itsipapee ashaninca, pincamantajeiteri: ");
INSERT INTO cniNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Pinquemajeitavaquena: icoaveta Tasorentsi impincatsariventempime, iro cantaincha te pincoyeji. Te paacameetsajeitavaquenaji, aisati oquempetaca, te paacameetsatavaqueriji Tasorentsi. Meeca pashinoncaitatiyempani”. ");
INSERT INTO cniNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Irootaque nocoaqueri pincamanteriri. Pineaquero, peerani itseencajeitaqueri Tasorentsi soromasatini, irootaque ipoyereajeitantacariri. Iro cantaincha eirorica inquemisantajeitavaquempi ashaninca meeca, iranaacoteri soromasatini, irashinoncaasanojeitanaquea catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aisati icanti Jesoshi: —Irashinoncaasanojeitanaquea corasesati aisati vetsairasati: oshequi ineacojeivetaquena notasoncantapiniti, iro cantaincha te inquemisantajeitavaquenaji catsini. Irineajeitaquenaricame tirosatini aisati shirosatini, inquenqueshirejeitanajeame, irojocajeitajerome caari cameetsatatsi yantajeitiniri. ");
INSERT INTO cniNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Queariotaque iroasanquejeiteri Tasorentsi coajica tirosatini aisati shirosatini, iroashinoncaajeiteri, iro cantaincha iroashinoncaasanojeiteri catsini corasesati aisati vetsairasati. ");
INSERT INTO cniNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aisati icoajeiveta caperenaosati irijajeiteme anta inquitequi, iro cantaincha ainti irijajeite Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Noamere, pinquemajeitena. Ariorica inquemisantajeitavaquempi atiripee, aisati narori inquemisantajeitena. Ariorica intseencajeitavaquempi, intseencajeitavaquena narori. Aisati oquempetaca, ariorica intseencajeitena, intseencajeiteri aisati yora tiancaquenari. Meecaquea, pijatasanojeite. ");
INSERT INTO cniNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ari ipiajeitapaaja itiancane Jesoshi, iquimoshirejeitapaaque. Icamantajeitapaaqueri: —Novincatsarite, iotantacari camaari noquemisantaquempi, iquemisantaquena narori. Nomataqueriquea notiancajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yacanaqueri: —Queario yora Satanashi ipincatsariventavetacari iamaaririnte, iro cantaincha noneajeitaquempi pimajeitaqueri pitiancaqueri camaari avirori: meeca niotaque eiro ipincatsaritasanotiritsi meeca Satanashi, tempa yanaacotaqueri Tasorentsi irinti. ");
INSERT INTO cniNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Meeca oshequi notasoncaventaquempi: oquempevetaca ariorica paatiqueri maranque, eiro yoamaimpitsi; aisati yora quitoniro, tecatsi incantempi. Aisati inquisavetempi yora camaari, iro cantaincha tecatsi incantempi, tempa notasoncacoventimpi. ");
INSERT INTO cniNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Queario pitiancaqueri camaari, iro cantaincha eiro piveshireimentarotsi. Irointiquea pinquimoshireventasanojeitanaque pijajeite inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Impoiji oquimoshiretacaasanotaqueri Ishire Tasorentsi, icantiri iriri: —Oshequi, apa, picameetsati. Pipincatsariventajeitiri maaroni inquitesati aisati maaroni quipatsisati. Itimaveta atiri iovetachari, ioyevetaro paitapeerica, iro cantaincha pimanapitsataqueri pineane: te iriojeiteroji jaoca incanteari iravisacotantajeari. Irintiquea poametasanojeitaqueri caari iotasanovetacha: itseencajeivetacari ishaninca, iro cantaincha picoacaaqueri iriote iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Impoiniji icantajeitaqueri apatotimentajeitacariri: —Iriotaque Apa matacaaquenarori maaroni catsini. Apaniro iotasanotana Apa, tecatsi pashini iotasanotenane. Aisati noquempeta narori, apaniro niotasanotiri, te intimeji pashini iotasanoterineri: irintiquea yora noamejeitiri, iojeitiri iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ari ipitsocashitanacari iriori iroamere, apaniro yoamejeitaqueri: —Pineajeitaquena avinti nomataquero caari ineapinijeiti itsipapee atiri. Ocameetsati pinquimoshireventena, aisati inquimoshireventena pashini neenaneri. ");
INSERT INTO cniNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Icoajeiveitani peerani yora quenquetsatacantaveitachaniri irineename nontasoncantayete, iro cantaincha te irineenaji notasoncantayeti. Aisati icoajeiveitani irineename yora pincatsariyeveitachaniri. Aisati icoajeiveitani inquemajeitename, iro cantaincha, te. Avirojei avinti, pineajeitaquena, piquemajeitaquena. ");
INSERT INTO cniNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pashini quitaiteri ijatashitaqueri iotasanotirori isanquenareni Moishishi. Icoavetaca incomitacayearime Jesoshi; icantapaaqueri: —Oametanari, ¿paita nanteri nosavicanteari inquitequi, noncantaitatiyempani? ");
INSERT INTO cniNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yacanaqueri: —¿Paita ocantiri isanquenare Moishishi? ");
INSERT INTO cniNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Icantiri: —Ocanti isanquenare: “Ocameetsati anintasanoteri Tasorentsi: tempa iriotaque Avincatsarite. Cameetsa anintasanojeiteri catsini. Aisati oquempetaca arosati nintajancha, anintasanojeiteri itsipapee ashanincapee, impoiji antime inquitequi”. ");
INSERT INTO cniNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Icantiri: —Queario picantaque: ariorica pimatero avinti, ari pincantaitatiyempani pintime inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Iotaque iriori te irinintasanoteriji maaroni ishaninca, iro cantaincha icoaveta irimanerome. Irootaque isampitantariri: —¿Jaoca itimiri noshaninca noninteri? ");
INSERT INTO cniNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yacanaqueri Jesoshi: —Noshiacantempiro. Iquenanaque jorio avotsiqui. Iponeaca Jerosarequi, irijateme nampitsiqui pajitachari Jerico. Nianqui avotsiqui imapocaqueri coshitantatsiri, yaavajiri, tapi. Isapocajiri, yaitaqueri iitsaare, oshequi ipasanataqueri, tac, tac, tac. Impoiji yojoquitsempequitaqueri avotsiqui, irotaintsi incame. ");
INSERT INTO cniNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ari impoiji iquenanaque avotsiqui saserote; jorio ini aisati. Ineavetapaacari ishaninca yoashinonqueetaqueri, iro cantaincha yanampitanaqueri, te irineshinoncateriji. ");
INSERT INTO cniNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aisati iquempetaca aparoni Irevita, iquenapaaque avotsiqui. Ineavetapaacari ishaninca, iro cantaincha aisati yanampitanaqueri, te irineshinoncatimateriji. ");
INSERT INTO cniNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Impoiji, ari iquenapaaque iriori aparoni samariasati. Inashita irinti, te irishanincateariji jorio. Iro cantaincha ineantapaacariri yora ashinoncaincari, ineshinoncatapaaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ijatashitaqueri, yaavintapaaqueri, aisati ipashicaqueri ora itoyeetaqueri. Ainiro yamaqueri aisati samariasati imorane. Ari yaajiri ashinoncaincari, yoanquetaqueri imoranequi, yaanajiri anta otiminta pancotsi. Anta cameetsa ineshinoncatapaajiri aisati, yaavintapaajiri. ");
INSERT INTO cniNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ari oquitaitetamanaque icoaque samariasati irovaanajea. Icantiri ashitarori ivanco: “Jerica quirequi. Nocoaque pincavintsayeri yoca shirampari. Terica irimoncarateaji quirequi, ari nompajempi coajica pashini”. ");
INSERT INTO cniNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ari itimi mava neaqueriri ashinoncaincari avotsiqui. ¿Jaoca itimiri ishaninca nintasanotiriri? ");
INSERT INTO cniNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yacanaqueri: —Tempa yora neshinoncatiriri. Icantiri Jesoshi: —Aisati pinquempeteri, pineshinoncajeiteri pishaninca, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Impoiji iquenanaque avotsiqui Jesoshi, icarajeitiri iroamerepee. Yareejeitapaaca nampitsiqui. Oneavajiri tsinane pajitachari Marita, ocantavaqueri: —Tsame, pijajeite novancoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Otimi anta ovancoqui ireento, opajita Maria. Osaviquimotaqueri Avincatsarite iitiqui, oquemisantavaqueri icamantaquerori. ");
INSERT INTO cniNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Iroori Marita, oshintsishintsiyetaque, ovetsicayetiniri paitaricapee. Impoiji ojatashitaqueri, ocantaqueri: —Novincatsarite, pamene apaniro novetsicayetimpiro poyeari. Orari eentio, te amitacotenaji. Pincantero amitacotenata. ");
INSERT INTO cniNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yacanaquero: —Oshequi piquenqueshiretaquero povetsicaquero ayeari, poameetsayetaquero paitapeerica. Oshequi piquenqueshireyetaquero. Ocameetsayeveta, iro cantaincha timatsi aparoni cameetsasanotatsiri: ");
INSERT INTO cniNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","irootaque ocoaqueri pireento, tecatsi cantimenterone. ");
INSERT INTO cniNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pashini quitaiteri iquenquetsatacairi Jesoshi iriri. Ari ivecaratantacarori, icantiri iroamere: —Novincatsarite, yora Joani yoamejeitaqueri iroamereni iquenquetsatacaajeitaqueri Tasorentsi. Nocoaque meeca pinquempetajeari avirori: poamejeitena nonquenquetsatacayeri narori. ");
INSERT INTO cniNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Icantaqueri: —Ariorica pinquenquetsatacayeri, jero oca, pinquempeterori: Apa jenoquisati, oshequi picameetsati catsini, nocoajeitaque pimpincatsariventajeitena, maaroni. Ocameetsati nomajeitempiro maaroni picoacaajeitaquenari, nonquempeteari iriori inquitesati yantajeitimpiro iriori maaroni picoacaajeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pimpapinitenaro maaroni quitaiteri noyeari coiteimotanari. ");
INSERT INTO cniNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Eiro piquishimentanarotsi caari cameetsatatsi nantiri, irointi picavintsayena: tempa nocavintsaajeitiri noshanincapee. Eiro pishinetiritsi camaari irantacayena caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aisati icantaqueri Jesoshi: —Pamene, noshiacantempiro aisati. Oquempetaca ariorica pijatashiteri pishaninca nianquiite pamanapeeri itantane. Pincantapaaqueri: ");
INSERT INTO cniNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Nocoi pimpena mava pitantane noacaajeiteariri noshaninca. Iroaquera yareetapaaca, tecatsi nompavaqueriri”. ");
INSERT INTO cniNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aamaaca ari incantavaquempime: “Eiro pashereanatsi, novochoquineni. Maajeivetaquena: narori, notomipee, maaroni. Yavitaca oni ashitacorontsi. Tecatsi noncantea nontinaye aca nompantempirori notantane”. ");
INSERT INTO cniNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pishaninca inaveta, iro cantaincha eirorica icoitsi intinaye impantempiri itantane. Iro cantaincha te incoyeji aisati pampiitapiniteri, irootaque intinaantajeari, tinare, impaquempiro picoacotaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Aisati oquempetaca: ariorica pamanapiniteri Tasorentsi, impapinitempiro pincoacoteriri. Ariorica pincoapiniyetero paitarica, ari paajero. Ariorica pinquenquetsatacaapiniteri Tasorentsi, ari inquemisantempi. ");
INSERT INTO cniNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Queario, ipasanotee Tasorentsi maaroni coiteimojeitaqueeri: te irimashitsateji, intacojeitaquee. ");
INSERT INTO cniNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Pamene, incoacotempirica pitomi tanta iroyeari, ¿arimpa pimpaqueri mapi? Incoacotempirica shima iroyeari, ¿arimpa pimpaqueri maranque? ");
INSERT INTO cniNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ariorica incoacotempi iitsoqui teapa, ¿arimpa pimpaqueri quitoniro? Eiro pipiritsi, irointi pimpasanoteri yoyeeyetari. ");
INSERT INTO cniNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pineaquero, te pincameetsajeiveteaji, iro cantaincha piojeiti picavintsaajeitiri pitomipee. Tempa aisati iotasanoti irinti Apa jenoquiniri icavintsaajeitaquee arori. Ariorica pincoacojeiteri, intiancajeitempiro Ishire iriori amitacojeitempine. ");
INSERT INTO cniNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pashini quitaiteri ineaqueri Jesoshi shirampari imasontitacairi camaari. Itasoncacoventajiri Jesoshi, yoavisacotajiri, irosati ineaveetantanaja aisati. Yoajeitanaque cavaco maaroni neajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Iro cantaincha icantayeti aparopee: —Ishanincatacari Jesoshi Satanashi: yora ivincatsarite camaari, irootaque imatantarori yoavisacotiri neiriri camaari. ");
INSERT INTO cniNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Itimi pashini tseenquiriri Jesoshi, icantiri: —Intsite, pintasoncante, niotantempiri queariorica piponeaca inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Iro cantaincha iotaque iriori iquenqueshirejeitiri. Icantiri: —Ariorica irimanatavacaajeitea atiri, tempa aitaque impoyereavacaajeitaquea. Aisati ariorica inquisavacaajeitea ashaninca, tempa ari irinijantareajeitanajeri. ");
INSERT INTO cniNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aisati oquempetaca, ariorica inquisajeiterime Satanashi iamaaririnte, ¿jaoca incanteari impincatsajeitantearirime? ");
INSERT INTO cniNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aisati picantayeti: “Irio Satanashi amitacotiriri Jesoshi yoavisacotiri neiriri camaari”. Iriome amitacotenaneme noavisacotantariri, ¿janica amitacotiriri pishanicajei yoavisacotantariri neiriri camaari? ¿Irisatimpa camaari pishaninca? ");
INSERT INTO cniNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Iro cantaincha itasoncacaaquena Tasorentsi noavisacotantariri neayetiriri camaari, piojeitanteari meeca quiso yoajeitaquempi Tasorentsi, icoaque impincatsariventajeitempi. Jero aisati ishiacantiniriri Jesoshi: ");
INSERT INTO cniNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Pamene, oquempetaca oca: ontimerica shintsitatsiri shirampari ivesamento, ichacopite, maaroni, tempa irishentasanotero ivanco. Eiro ishinetiritsi incoshiyeeteri irovaararo. ");
INSERT INTO cniNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Iro cantaincha impoquerica anaacotiriri ishintsitasanoti, iranaacotapaaqueri irinti irantapaaqueri, impoiji iraapitsatapaaqueri yoantamento. Impoiji incoshiteri irovaararo, impajeiteri ishanincapee iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Iquisajeitaquena maaroni caari oijajeitana, itseencajeitaquena maaroni caari amitacotana. ");
INSERT INTO cniNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ariorica iroavisacotajea neavetariri camaari, ocameetsati iraamaventajeari: yapiitajiricari aisati. Ishiaquero oca: iquenayeti camaari caaraiteriqui, icoayevetaro pancotsi irisavicanteameri. Tecatsi irinee, irootaque iquenqueshiretantacari: “Nompianajeta anta pancotsiqui noponeacanta”. ");
INSERT INTO cniNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ariorica impiaje, irineapaajero pancotsi, opishitaca. Vetsicayetaca irisavicantapeempari aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Impoiji irijataque incajemeri itsipapee iyamaaririnte, incarate oshequi. Eiro icameetsatitsi camaari catsini, yora incajemeri. Pineaquero, oca pancotsi oshiaqueri neiriri camaari. Ariorica iravisacotaje, ocameetsati iraamaventajeari camaari: yapiitajiricari irineajeri aisati. Ariorica irampiitajeri irineajeri, catsiqueti iroasanoteri. ");
INSERT INTO cniNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ari itimi oshequi quemajeitaqueriri Jesoshi. Antearojenca ocanti aparoni tsinane: —Tempa ocameetsati oquimoshireventiri Jesoshi iriniro. ");
INSERT INTO cniNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iro cantaincha icanti: —Je, queario, iro cantaincha iquimoshiretasanojeitaque maaroni quemajeitirori irineane Tasorentsi, aisati maaroni quemisantajeitiriri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ari yapatotimentajeitari Jesoshi itsipapee atiri aisati. Impoiji yoamejeitajiri: —Te pincameetsajeiteji. Picoajeiveta pineajeitename nontasoncantajeme aisati, iro cantaincha eiro pineajirotsi aisati. Pinquenqueshireteri Jonashini piotanteari: ");
INSERT INTO cniNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","peerani iniaqueri anteari omani. Ocarati mava imaacotaque tsompoina, impoiji isoquijanaji ivantequi, iotantacari ninivesati itiancaqueri Tasorentsi. Nonquempetajea coajica piojeitanteari itiancaquena Tasorentsi: tempa natiritapaaque nainti, noponeaca inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aisati ora ivincatsaroteni savasati, oponeaca arejiqui catsini, pashiniqui quipatsi. Oponeaca paricoti oquemisantantariri Saromoni, peerani. Ocoaque iriotacaasanotero. Pamene, nanaacotiri Saromoni nioti, iro cantaincha pitseencajeitaquena. Coajica, ariorica irampatojeiteri Tasorentsi maaroni camajeitatsiri, incantajeitempi: “Ainiro pantane: pitseencaqueri notiancane. Irompa irointi oca ivincatsarote savasati te aneeroji antane: tempa oquemisantiri Saromoni”. ");
INSERT INTO cniNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aisati iquempeta yora ninivesatini: iquemisantirini Jonashini. Iquenqueshirejeitanaca, yoipacaajeitajiro caari cameetsatatsi yantajeitiri. Nanaacotiri nainti Jonashini, iro cantaincha te pinquemisantajeitenaji. Coajica incantempi Tasorentsi: “Iquemisantirini ninivesatini Jonashini: avintiquea, ¿paita caari piquemisantantari notiancane?” ");
INSERT INTO cniNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aisati icantajeitiri Jesoshi: —Ariorica pitsiotiro tsiomentotsi, ¿arimpa pimanaquero jaocarica? ¿Pitetirompa cantiriqui? Tempa poapinitiro onantariqui, pitsiojeitantari. ");
INSERT INTO cniNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oca aqui oquempevetaro tsiomentotsi. Ocameetsatirica aqui, amenajeitanaque paitapeerica. Iro cantaincha terica oncameetsateji aqui, tecatsi amenanteari, oquempetaca aqueni tsiteniriqui, te ayojeiteji jaocarica aqueniri. ");
INSERT INTO cniNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","36","Ocameetsati piotacotea avisati piquemisantasanotaquerica. Ariorica piquemisantasanoti, ari piotasanotanaque, eiro pitseenquimatantajitsi. Impoiji pinquempetearo tsiomentotsi tsiotasanotachari. Irootaque icantajeitaqueriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Impoiji icantaqueri variseo Jesoshi: —Tsame ajate novancoqui, noacayempi. Ari yoijatanaqueri, yoacaapaacari. ");
INSERT INTO cniNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Te inquivacoteaji Jesoshi, irootaque yoantanacariri cavaco variseo. ");
INSERT INTO cniNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Icantiri Avincatsarite: —Queario, pamejeitacaro piquivapinitiro pajo aisati piveratote: iro cantaincha apatiro otapiiqui. Te pojoqueroji caari cameetsayetatsi timatsiri osantequi. Piquempetacaro avirori: piquenqueshiretapinitiro picoshiyeti aisati pantapiniyetiro caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Te pinquenqueshireniroteaji. ¿Apatirotimpa yovetsiquiro Tasorentsi paco? Tempa aisati yovetsiquiro piquenqueshireantari. ");
INSERT INTO cniNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pipashiyevetari ashinoncaincari coiteimovetariri, iro cantaincha te pincavintsaasanoteriji. Ariorica pincavintsaasanoteri itsipapee pishaninca, ari pincameetsataque. ");
INSERT INTO cniNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pashinoncaajeitea avirojei. Queario pipaarantapinivetari Tasorentsi piirequite capichaji, iro cantaincha tequera omoncarateaji. Timatsi pineacameetsatiri avirori aisati caari pineacameetsati. Iro cantaincha te omoncaratearoji icoacaaquempiri Tasorentsi. Te pininteriji Tasorentsi aisati te pininteriji pishanincapee. Ocameetsati pimperi Tasorentsi quirequi, iro cantaincha eiro pipeacotirotsi pininteri aisati panteneri icoacaaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Pashinoncaajeitea avirojei. Ariorica irampatojeitea ashaninca inquemisantanteariri Tasorentsi, picoanirojeiti impincatsajeitempi avinti. Ariorica pinquenayetanaque nampitsiqui, picoaque cameetsa iraacameetsajeitempi atiripee. ");
INSERT INTO cniNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Queario, iroashinoncaajeitempi Tasorentsi. Piquempetacari camatsiri tijachari quipatsiqui, imanaca; iro cantaincha yavisajeitanaque atiripee, te iriojeiteji irotaintsi iratiquerime camayetatsiri patsaatsiri. Aisati avirori, pimanayevetaro caari cameetsayetatsi pantayetiri. Irootaque icantaqueriri Jesoshi variseopee. ");
INSERT INTO cniNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ari icantiri oamentantirori isanquenareni Moishishini: —Oametantatsiri, aisati narorijei piquisaquena. ");
INSERT INTO cniNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Icantiri Jesoshi: —Je, aisati avirori iroashinoncaajeitempi Tasorentsi. Oshequi piperanayetacari ashanincapee, iro cantaincha te pintacoteariji. ");
INSERT INTO cniNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Queario, pashinoncaajeitea. Pimoncarajeitacari pishanincani oajeitiriniri camantantatsiniri. ");
INSERT INTO cniNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Avirojei oayeri. Pintimitaquearicame peerani avirori, poajeitaquerime aisati yora camantantatsiniri. ");
INSERT INTO cniNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Iotacojeitaquempi Tasorentsi, icanti: “Nontianqueneri atiri quenquetsatacayerineri, iro cantaincha iroayetavaqueri aparopee, irio itsipapee inquisavaqueri, intiancaarantajeri”. ");
INSERT INTO cniNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ainiro pantajeitiri maaroni: pashi poajeitiro poanti. Yora peeraniniri poajeiterime, irosati picanta meeca poajeitiri quemisantajeitiriri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Pishanincajeitacari oaqueriniri Averini. Aisati pishanincajeitacari oaqueriniri yora Sacariashini: yoyeetaqueri iriori anta ivancoqui Tasorentsi. Ainiro pantajeitiri maaroni, irootaque iroashinoncaimentempiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Poametantavetaro isanquenareni Moishishini, iro cantaincha pashinoncaajeitea: tempa pamatavijeitiri ashanincapee. Te pincoajeiteji pioteri Tasorentsi, aisati te pincoacaajeiteriji iriojeitajeri iriori ashanincapee. ");
INSERT INTO cniNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Irootaque icantajeitaqueriri maaroni, impoiji isoquijanaji. Iquisajeitaqueri yora variseopee aisati yora oametantirori sanquenarentsi, aisati iquenquejaajeitaqueri. Aisati isampiyevetacari paitapeerica, ");
INSERT INTO cniNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","icoajeiveta incomitacayearime. Icoaveta incomitacayearime iraacantantearimeri. ");
INSERT INTO cniNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ari yapatotimentajeitari Jesoshi oshequi catsini atiri, itsitacaavacaajeitanaca. Irosati icantantari iroamerepee: —Paamayeariyea variseopee, yamatavijeitimpicari. Oshequi yamatavitanti. ");
INSERT INTO cniNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ijijeivetaca tecatsi iotatsine yamatavijeivetacari, iro cantaincha coajica iriotacojeitanaqueri maaroni atiri yashi yoiro yamatavitanti. ");
INSERT INTO cniNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aisati aviroripee, paitarica pimanavetacari picantiri meeca, inquemajeitero coajica. Paitarica pincanteri apaniro anta pivancoqui, irovaayetajero anta yapatojeitanta atiripee. ");
INSERT INTO cniNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Meeca, noshaninca, noncamantempi: eiro pitsaroacaaritsi yora atiri coatsiri iroyempi. Ariorica iroyempi, iro cantaincha irointi iroyeete pivatsa. Tecatsi incantero pishire. ");
INSERT INTO cniNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Irinti Tasorentsi pimpincatsate: incoaquerica, iroyempi. Iro cantaincha aisati icoaquerica, irimatero intianquempi Sharincaveniqui. Irooquea pintsaroacayeari irointi pijate Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Ivinaronimpa tsimeripee? Te impinatasanoteaji, iro cantaincha iojeitiri Tasorentsi: te impeacojeiteariji. ");
INSERT INTO cniNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aisati oquempetaca, iotasanojeitaquempi: ioti jaoca ocaratiri piishipee. Iquempoyeajeitaqueri tsimeripee, iro cantaincha avirojei iquempoyeasanojeitaquempi. Eiro picantashiretitsi, irointi piveshireimenteari Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Aisati piojeitavaquero oca noncantempiri: eiro pipashiventacaanatsi, ariorica pincamantajeiteri itsipapee atiri piquemisantaquena, aitaque noncamanteri Apa anta inquitequi pishanincataquena. Tempa noponeaca inquitequi, natiritapaaque. ");
INSERT INTO cniNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Iro cantaincha ariorica pimpashiventacayena aca quipatsiqui, aisati avirori nompashiventacayempi anta inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ariorica incantimatena atiri, ariorica incavintsayeri Tasorentsi, eiro iquenqueshiretajirotsi yantajeitiri. Iro cantaincha ariorica incantimajeitero Ishire Tasorentsi, eiro icavintsairitsi Tasorentsi catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ariorica irayeetempi anta yapatotapinijeitanta, aisati anta joeshiqui, aisati anta pincatsariqui, eiro pitsaroacaajeitaritsi. Eiro piquenqueshiretitsi: “¿Paita noncanteriri?” ");
INSERT INTO cniNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ariorica irayeetempi, oametempi Ishire Tasorentsi paitarica pincanteriri. ");
INSERT INTO cniNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Impoiji icantiri aparoni shirampari: —Oametanari, ipanaquerini apani iyeca maaroni timimojeiveitariniri. Tecatsi impena nainti. Pincanteri iye impaarantajena narori irovaararo. ");
INSERT INTO cniNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yacanaqueri: —Eiro nocantiritsi. ¿Narompa joeshi, noncantanteariri? ");
INSERT INTO cniNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Icantajeitiri maaroni apatotimentajeitariri: —Queariompia: pinevetarocari yashiyetari itsipapee, eiro oveshireacaasanotimpitsi. ");
INSERT INTO cniNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Impoiji ishiacaventiniri oca: —Otimi iipatsite ashitaarantincari. Oshequi onintiro panquirentsi quipatsi, cameetsa oshiocayetanaque ivanquirepee. ");
INSERT INTO cniNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yaayetajiro oitsoquipee, inquempoyeantearori ovancopeequi iroori, iro cantaincha opiojeitaca pancotsiqui. Te onajeitearoji maaroni. Iquenqueshiretaca: ");
INSERT INTO cniNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“¿Jaocasa noncanterori? Tecatsi noantearori maaroni. Jaa, niotaque meeca: noshoveajero pancotsijaniqui, nantacantajero antearo pancotsi noantearori maaroni novanquirepee, aisati maaroni novaararo. ");
INSERT INTO cniNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Oshequitaque meeca maaroni, tecatsi coiteimotajenaneri. Peerani catsini, eirota otsonquitatsi; meeca nomaoree oshequi osarintsi. Cameetsa noapinitea, noshinquitapinitea, noveshireimentearo maaroni timimotanari”. ");
INSERT INTO cniNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Iro cantaincha icantiri Tasorentsi: “Te piotacoteaji. Meeca tsiteniri noyempi; impoiji, ¿janica ashitajearoneri maaroni timimojeivetimpiri?” ");
INSERT INTO cniNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pineaquero, te irioteji maaroni coatsiri iroshequiyero irovaararo. Oncameetsateme irovetsiquerome irisavicantearime inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aisati icantiri Jesoshi iroamere: —Eiro piquenqueshiretatsi jaoca payerori poyeari aisati pinquitsaateari. ");
INSERT INTO cniNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tempa Tasorentsi oaneaquempiri. ¿Opomerentsitimotarimpa meeca impaquempi poyeari aisati piitsaare? ");
INSERT INTO cniNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pinquenqueshireteri jaoca icantari tsimerepee: te impanquitanonteaji aisati te inquempoyeanonteaji iroyeari pancotsiqui, iro cantaincha ipapinitiri Tasorentsi yoari. Pamene, iquempoyeaventajeitiri Tasorentsi tsimeripee iriori, tempa aisati avirori iquempoyeaventasanojeitimpi. ");
INSERT INTO cniNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Paita patsipetashitantarori picantashireti? ¿Pijitimpa ariorica pincantashirete aiquero pijatatiye pantearitasanotanaque? ");
INSERT INTO cniNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pineaquero, patsipetashitacaro picantashireti. Tecatsi paye. ");
INSERT INTO cniNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pinquenqueshiretero jaoca ocantari oteaquipee tojari. Te ontsameetanonteaji, aisati te ontijanonteaji oitsaare, iro cantaincha ocameetsatasanotaque. Peerani oshequi yoaneencani Saromoni, iro cantaincha te inquempetearoji oteaquipee: ocameetsatasanotaque irointi. ");
INSERT INTO cniNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pineaquero, yoaneencaquero Tasorentsi oteaquipee. Otimaveta, impoiji oshintsiti oshimpetanaji. Peerani pintime avirojei: tempa pijiti iquenqueshiretaquempi avirori. ¿Paitasa pitseencantacariri? ");
INSERT INTO cniNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Eiro piquenqueshiretirotsi paitarica poyeari, aisati paitarica pireri: inquemacayempi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tempa icoajeitaque atiri iroapinijeitea. Iro cantaincha iotaque Tasorentsi maaroni coiteimotaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ariorica pimpincatsatasanoteri, impaquempi maaroni coiteimotaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Noamere, oshequi inintaquempi Apa Tasorentsi: icoasanotaque impincatsariventajeitempi, incavintsaasanojeitempi. ");
INSERT INTO cniNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pimpimantero pashiyetari, pimpayeteri ashinoncaincari ovinaro. Impoiji impinatempi Tasorentsi anta inquitequi. Ontimasanote pivaararo anta: eiro opatsaajitsi, eiro opitsititsi, eiro icoshiyeetajimpitsi, eiro yapeajirotsi cajiro. ");
INSERT INTO cniNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ariorica otimi pivaararo aca quipatsiqui, oshequi piquenqueshiretaquero timayetatsiri quipatsiqui. Ariorica otimi pivaararo inquitequi, ari piquenqueshiretapinitiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Jeroca icantaqueriri Jesoshi iroamere: —Paamaajeiteari pivincatsarite, pivetsicasanojeitea. Pinquempeteari yora inampire ashitarori ivanco. Ijataque yora ashitarori irineeri ishaninca irayero ijina. Yaamaajeitari inampire anta ivancoqui. Ariorica irareetapaajea incoapaaje irashitareavajeneri, aisati incoapaaje irineapaajero ovetsicayetaca ivanco. Ariorica ontsitenitanaje, icoaque ontsiotea ivanco. Aisati icoaque intinaye inampirepee, inquitsaajeitea. ");
INSERT INTO cniNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ariorica irineapaajeri yovetsicajeitaca, inquimoshirejeitaque maaroni. Yora ashitarori ivanco irisavicacaajeiteri maaroni inampirepee, iroacaajeiteari. ");
INSERT INTO cniNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Iro cantaincha te iriojeiteji jaocarica oncarate impocantajeari: ariorica iroaquera imaajeiti, ariorica nianquiite. Iro cantaincha ariorica irineapaaqueri inampire yovetsicajeitaca, ari inquimoshirejeitanaque, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Piojeitavaquero oca noncamantempiri: arioricame pioteme impoque tsiteniriqui coshitantatsiri, tempa pisaaquiteme poimpiantavajearimeri, eiro pishinetirime incoshitempime. Iro cantaincha te pioteji jaocarica oncarate impocanteari. ");
INSERT INTO cniNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aisati noquempevetari coshinti, te noncamantempiji jaocarica oncarate nompocantajeari. Peerani noponeaca inquitequi, natiritapaaque. Coajica nompiaje. Pinquenqueshirejeitena, paamaajeitajena: nomapocapaimpicari. ");
INSERT INTO cniNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ari isampitiri Petero: —Novincatsarite, ¿apanirompa poamejeitena naroripee? Irompa tericampa, ¿picoaquempa iriojeitanaque maaroni atiri? ");
INSERT INTO cniNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yacanaqueri: —Noquenquetsatacaajeitiri maaroni quearioventirori nocoacaajeitiriri. Iquempetaca ivatorote atiripee, icoacaaqueri aparoni iratirite iroacaapiniteari itsipapee. Impoiji ijataque ivatorote jaocarica. ");
INSERT INTO cniNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ariorica iroacaapiniteari cameetsa, ariorica impocaje ivatorote, iroveshireimentapaajeari. ");
INSERT INTO cniNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Incantapaajeri: “Cameetsa piquemisantaquena. Meeca aviro amenajeitenarone maaroni timimojeitanari”. ");
INSERT INTO cniNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Iro cantaincha, incanterica yora iratirite: “Eirotsita ipoqui novatorote”. Icoacaavetari ivatorote incavintsayerime itsipapee, iro cantaincha imapocaqueri iquisajeitaqueri, ipasajeitaqueri: shirampari, tsinane, maaroni. Oshequi iperataca, oshequi ishinquitaca. ");
INSERT INTO cniNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ari pashini quitaiteri impocaje ivatorote, irimapocapaajeri. Iroasanquetapaaqueri, inquempetacaanteri itsipapee caari quemisantiri. ");
INSERT INTO cniNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pineaquero, iovetacaro icoacaavetacariri ivatorote, iro cantaincha te incoyeji irimatero. Irootaque impasatacantanteariri, aiquero catsini impasatacantasanoteri. ");
INSERT INTO cniNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Iro cantaincha eiro yoasanquetasanotiritsi caari iotatsi. Eiro icoacotasanotiritsi oshequi yora caari iotatsi. Irintiquea iotasanotatsiri, incoacotasanoteri irinti. ");
INSERT INTO cniNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Aisati icanti Jesoshi: —Nopocaque quipatsiquica inquisavacaimentantenari atiripee, nocoasanotaque nomamajeitero maaroni nopocashitiri. ");
INSERT INTO cniNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Oshequi noquenqueshireaca: irotaintsi oshequi nonquematsicatearo. ");
INSERT INTO cniNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Pijitashijeivetampa nopocashijeitiri atiri noimajerentajeiteri, cameetsa iraacameetsatavacanteari? Teve, irointi inquisavacaimentajeitena. ");
INSERT INTO cniNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ariorica incarate apapacoroni savicatsineri pancotsiqui, inquisavacaajeitea. Incarate mava quisherineri yora apite ishaninca. ");
INSERT INTO cniNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ariorica yora ashitariri inquisheri itomi, aisati itomi iquisheri iriri. Ariorica onquishero airo evatayero, onquishero iroori airo. ");
INSERT INTO cniNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Impoiji icantajeitiri apatotimentajeitariri: —Ariorica pineaquero antearo tampea amaquero mencori otsitenishaanaque, picantajeiti: “Coraqueve incani”. Tempa piojeitaque ompoquerica incani. ");
INSERT INTO cniNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ariorica oquitamaroitetanaji, picantajeiti: “Eiro oparii incani, ari osarianaje”. Tempa aisati piojeiti, ");
INSERT INTO cniNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","irointi pimanaquero piojeitiri. Piojeitaque ompariaquerica incani. Iro cantaincha te pincoajeiteji piojeite oshequi ompomerentsitimojeitempi coajica. ");
INSERT INTO cniNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Paita caari picoanta piojeitero queariosanotatsiri? ");
INSERT INTO cniNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ariorica inquishimentempiri pishaninca quirequi pireviteriri, incoaquerica iraanajempi joeshiqui. Ari tequeratsitarica irareetacayempi, pincantanaqueri: “Eiro piquisanatsi, coajica nompinatajempi”. Yoiminqueimpicari caravosoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ariorica iroiminqueaquempi, incoacotasanotempi maaroni quirequi pirevitiriri. Eirorica pipiritsi, eiro yoimisoquijajimpitsi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Impoiji ipoqui pashini atiri, icamantapaaqueri Jesoshi: —Ijajeivetaca carireasatipee anta Jerosarequi iroajeitenerime Tasorentsi ivira. Jeriniro yora Piratoniro yoacantanirojeitaqueri carireasatipee anta ivancoqui Tasorentsi. Oconoajatacaro irirajani ashanincani irirajani ivira yoajeitiniriri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yacanaqueri Jesoshi: —¿Pijitirimpa yora carireasati antasanojeitironiri caari cameetsatatsi ishinetantariri Tasorentsi yoacantaqueri Pirato? ");
INSERT INTO cniNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Noncamantempi: te iro incamantea. Iro cantaincha queariompiyea: eirorica piquenqueshiretajatsi, aisati eirorica pojocajirotsi caari cameetsatatsi pantapinitiri, pinquempejeiteari yora yoyeetiri. Yoajeitimpicari, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aisati peerani otireanaji antearo mapipanco anta Shiroequi, otsinacapaaqueri 18 shirampari, icamajeitaque. ¿Paita icamajeitantacari? ¿Iriompa antasanotirori caari cameetsatatsi icamantacari? Te. Iquempejeitacari maaroni ishiramparirinte. ");
INSERT INTO cniNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pinquenqueshireajeitea avirori, pojocajero caari cameetsatatsi pantapinijeitiri. Eirorica piquenqueshirejeitatsi, aisati pincamajeite avirorijei. ");
INSERT INTO cniNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Impoiji ishiacaventajeitiniri oca: —Ipanquitaquero shirampari iyera anta irovamashitequi. Ocarataque peerani oshiocaque, impoiji yamenapinivetaro oitsoqui, irayerome: iro cantaincha te oitsoquiteji. ");
INSERT INTO cniNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Impoiji aisati icantiri yora tsameetiniriri iipatsite: “Pamene, ocarataque mava osarintsi nopocapiniveta nayerome oitsoquipee. Te ontimeji catsini. Atsipetashitaca otimi. Pimpesajero nompanquitantearori paitapeerica cameetsatatsiri”. ");
INSERT INTO cniNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yacanaqueri tsameetiniriri ivatorote: “Ari onavaquetsita meeca osarintsiquica. Nonquiayetero quipatsi ometsoitetanteari, aisati noapinitenero itia pivira, cameetsa ontimanteari oitsoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Impoiji ariorica ontimanaque oitsoqui pashini osarintsi, tempa cameetsa, eiro apeshirotsi. Iro cantaincha eirorica otimitsi oitsoqui, nompesajero”. ");
INSERT INTO cniNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pashiniqui saavaro yoametanti Jesoshi anta yapatotapinijeitanta joriopee. ");
INSERT INTO cniNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Otimi anta pancotsiqui aparoni tsinane yatajeaonquiri peerani camaari. Ocarataque meeca 18 osarintsi omitiaque, irosati ocanta omitiaque: tecatsi oncantajea oncatiaje. ");
INSERT INTO cniNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ineantacarori Jesoshi, icajemaquero: —Caatanaque, meeca noavisacotajempi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ipamitaquero, irosati avisacotantanaja. Cameetsatanaji, ocatianaja. Ocantanaque: —Yoavisacotajana Tasorentsi, tempa icameetsati. ");
INSERT INTO cniNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yora jivatacantantatsiri anta ivancoqui Tasorentsi iquisaqueri Jesoshi. Icantajeitiri apatojeitainchari: —Ocameetsati antaveejeite 6 quitaiteri, iro cantaincha ariorica omoncaratapaaquea quitaiteri 7 ocameetsati amaoreasanojeitanaque. Eiro antaveetitsi catsini. Ariorica picoaque pavisacojeitaje, pimpoque pashiniqui quitaiteri, eiroquea pipoquitsi saavaroqui. ");
INSERT INTO cniNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ipiatanacari Avincatsarite, icantanaqueri: —Oshequi pamatavinirotanti. Pantaveejeiti avirori saavaroqui. Pamene, ariorica airi pivacate imire saavaroqui, tempa pitsatacoreiri paantanacariri anta otiminta nija. Aisati piquempetiri pimorane, maaroni. Queario, picavintsaajeitiri pivirapee saavaroqui. ");
INSERT INTO cniNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iro cantaincha caari oni pivira oca tsinane, irointi pishaninca. Peerani omantsiataque: tempa ocameetsataque ancavintsayero saavaroqui. ");
INSERT INTO cniNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iquemantarori oca, ipashiventajeitanaca maaroni quisajeitaqueriri Jesoshi. Irinti itsipapee atiri iveshireimentajeitacari Jesoshi, icantajeiti: —Ocameetsajeitaque yantayetiri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Impoiji icanti Jesoshi: —¿Piojeitimpa jaoca icanta Tasorentsi ipincatsariventanti? ¿Jaoca noncanterori noshiacaaventantempirori? ");
INSERT INTO cniNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Oshiaquero oitsoqui moshitasa ipanquitiri shirampari iroanequi. Oshiocanaque, oquimotanaque, oshiavetacaro inchato. Ipocapiniti tsimeri, yaatapinitiro ojempequi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yapiitajiro, icanti: —¿Jaoca noncanterori noshiacaaventantempirori? ");
INSERT INTO cniNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oquempetacaro tsinane, airo tapiacairori tanta capichaji. Oconoiro oshequi tiricopane otapiantanacari. Otapiaquero maaroni, ometsotantacari. Aisati iquempetaca ashaninca. Intimerica aparoni antirori caari cameetsatatsi, irantacaajeiteri ishaninca, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ari iquenaquenayeti Jesoshi nampitsipeequi, yoametantayeti. Icoaque irijate Jerosarequi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Isampiyeetiri: —¿Jaoca incarajeiteri oavisacojeitajanchane? ¿Arimpa incarate aparopee? Yacanaqueri: ");
INSERT INTO cniNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Noshiacantempiro. Oquempetaca orijaniqui omorojaniqui anqueanteari inquitequi. Intime oshequi coavetachane irijateme inquitequi, iro cantaincha eiro imatirotsi irareetearo. Pimpomerentsiventearo pareetanteari inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aisati oquempetacaro yantiri ashitarori ivanco. Itimi tsompoina iriori, yashitacotaca, iyavitiro ashitacorontsi. Impoiji pimpocajeivetea avirorijei, pincantavetapaaqueari: “Novincatsarite, pashitareenaro, nonqueanaque”. Iro cantaincha incantavaquempi: “Te niojeitempiji jaocarica piponeari”. ");
INSERT INTO cniNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Impoiji pincantajeiveteari: “Peerani aitaque pitsipajeitaquena nonampiqui avajeitaca, aisati poamejeitaquena”. ");
INSERT INTO cniNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ari incantempi: “Te niotempiji. Pijataje, pimpianaje. Oshequi pantayetiro caari cameetsatatsi. Te pincameetsateji”. ");
INSERT INTO cniNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Impoiji oshequi poashiretasanotanaquea catsini, piraasanotanaquea aisati. Pineaqueri Avarama, Isaca, Jacovo, maaroni yora quenquetsatacantatsiniri itimi jenoqui, iro cantaincha avirojei, eiro pimajeitirotsi pijate: iroimpiavajempi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Imponeajeitaquea quemisantatsiri intatiquero, acaqueroca, catonco, quirinca, maaroni quipatsipeequi. Irisavicajeitapaaque anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Irareetasanotaquea yora pitseencajeitaqueri. Eiro yareetatsi irinti pipincatsajeitiri. ");
INSERT INTO cniNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Irosati ipocantaca aparopee variseo. Icantapaaqueri Jesoshi: —Pijate pashiniqui quipatsi. Icoaque Eroreshi iroacantempi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yacanaqueri: —Pincamantanirotaiteri yora amatavitantatsiri: “Icanti Jesoshi: ‘Eiro noshiatsi. Noncanteani noavisacojeiteri neiriri camaari aisati mantsiaripee: meeca, osaitequera, aisati otsipa quitaiteri. Impoiji nomoncarataquero maaroni’ ”. Irootaque pincanteriri. ");
INSERT INTO cniNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aitaque nonquenaquenayete meeca, osaitequera, aisati otsipaniqui quitaiteri. Aisati ocameetsati noncame Jerosarequi: tempa anta icamapiniti quenquetsatapinitirori irineane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aisati icantiri Jesoshi: —Yora jerosaresati oshequi yoayetaqueri quenquetsatirori irineane Tasorentsi. Ipichaapinitaqueri itiancane Tasorentsi. Oquempetaca teapa osaramonquitiri orijanipee, oshequi nocoaveta nampatojeiterime jerosaresati: nonquemisantacayerime, iro cantaincha te incoajeiteji. ");
INSERT INTO cniNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pamene, tecatsi amitacoterineri meeca, yojocajeitiri Tasorentsi, icantiri: “Incanteata”. Eiro ineapinitajanatsi meeca. Jaocarica intimeri pincatsatenaneri, ari irineajena aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pashiniqui saavaro itimi Jesoshi anta ivancoqui jivatacaajeitiriri variseo. Yamenasanojeitiri Jesoshi, icoaque irantero paitarica inquishimentanteariri. ");
INSERT INTO cniNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Itimi anta aparoni mantsiari, yeereyetanaque, yenoncayetanaque maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Isampitiri Jesoshi variseopee: —¿Ocameetsatimpa avavisacoteri mantsiaripee quitaiterica amaoreajeitantari? ");
INSERT INTO cniNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Iro cantaincha imajerejeitanaque, te irancaniroteji. Ari yacatsavacotaqueri Jesoshi mantsiari, yoavisacotiri, impoiji itiancajiri ivancoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ari icantaqueri yora amenashejeitaqueriri: —Tempa pantaveejeiti avirojei saavaroqui. Ariorica impariaque pivacate omoroqui, tempa ari paavajeri aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aisati, imajerenirojeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Impoiji yamenajeitaqueri Jesoshi yora oajeitainchari yoacaajeitacari yora jivatacaajeitiriri. Icoajeiveta irisaviqueme quempeji yora pincatsari irineacameetsatantearimeri. Ari icantajeitaqueri Jesoshi: ");
INSERT INTO cniNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ariorica iroacayempi pishaninca, eiro pisavicashitatsi quempeji yora pincatsaritatsiri. Pamene, ipoquicari pashini ivincatsaririnte, ");
INSERT INTO cniNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","impoiji ipoquicari yora cajemacantimpiri, icantimpicari: “Eiro pisaviquimotiritsi pincatsarica. Irisaviqueta aca irinti ivincatsaririnte”. Isavicacaimpicari anta nijantiaji, impoiji pimpashiventanaquea. ");
INSERT INTO cniNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Irointiquea ocameetsati pisavicapaaque anta nijantiaji. Impoiji ariorica irineajempi yora cajemacantimpiri, incantempi: “Caatanaque, noshaninca, pisaviquimoteri aca pincatsari”. Irineajeitempi maaroni oajeitainchari ishanincataquempi pincatsari. ");
INSERT INTO cniNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ariorica pincoaque irineapincatsajeitempi itsipapee, pishemeticari; impoiji ipashiventacaimpicari Tasorentsi: tecatsi neapincatsatempineri. Iro cantaincha yora caari shemetatsi incarajeiteri Tasorentsi impicatsariventante. ");
INSERT INTO cniNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aisati icantiri Jesoshi yora cajemacantiriri: —Ariorica pincajemacanteri atiri poacantajeiteariri, eiro picajemapinijeitiritsi pishanincasanori aisati yora ashitaarantincari. Ariorica poacaaqueari, ari iriori impiatempi, iroacaajempi. ");
INSERT INTO cniNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Iro cantaincha ocameetsatasanoti pincajemacanteri irinti yora caari ashitaarantayetacha, yora choriyetatsiri, jempayetatsiri, caari amenayetatsi, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tecatsi incantajeitea irinti impiajeitajempi iroacaajeitempi. Iro cantaincha coajica irointinaajeitajeri Tasorentsi maaroni quemisantajeitiriri. Impoiji impinatempi irinti. Te pantsipetashiteaji picavintsanti. ");
INSERT INTO cniNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iquemantacariri aparoni oainchari, icanti: —Tempa oncameetsatasanotaque antime anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Icantaqueri Jesoshi: —Oquempetaca aparoni shirampari. Yovetsicacantaquero oshequi yoari, impoiji icajemacantaqueri ishaninca iriori iroyea. ");
INSERT INTO cniNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ovetsicajeitaca maaroni. Itiancaqueri inampire: “Pijate, pincamantaiteri: ‘Moncarataca, vetsicajeitaca maaroni, pimpoque meeca’ ”. ");
INSERT INTO cniNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Iro cantaincha te incoajeiteji irijajeite. Icanti aparoni: “Iroaquera namanantaquero noipatsite. Nojate meeca namenaiterota, ocameetsataquerica. Pincamantajeri: ‘Eiro ipoquitsi’ ”. ");
INSERT INTO cniNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Icanti pashini icajemacantiri: “Iroaquera namanantaqueri 10 vaca. Nocoaque namenaiteri icameetsataquerica. Pincamantapaajeri: ‘Eiro ipoquitsi iroyea’ ”. ");
INSERT INTO cniNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Icantiri pashini: “Iroaquera naaque nojina. Tecatsi noncantea nojate”. ");
INSERT INTO cniNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ari ipianaja yora inampire camantavetariri ishaninca. Icamantapaajiri: “Icantajeiti: ‘Eiro nojatitsi noyea’ ”. Ari iquisanaca yora ivatorote, icantiri inampire: “Incanteata noshaninca. Meeca pijate anta nampitsiqui, pinquenayetanaque pincoacoayeteri yora caari ashitaarantayetachane, choriyetatsiri, jempayetatsiri, caari amenayetatsi, maaroni”. Ari ijataque, icajemajeitaqueri, ipocajeitaque. ");
INSERT INTO cniNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ari ipiajaro aisati, icantapaajiri ivatorote: “Nojaiti, nocamantajeitaqueri. Ipocajeitaque, iro cantaincha tequerata omoncarateaji”. ");
INSERT INTO cniNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ari icantiri aisati: “Ari pijate anta aisati, pinquenayetanaque avotsipeequi, pincantajeiteri itsipapee impoque, nocoaque irijaasanojeitapeemparo novanco. ");
INSERT INTO cniNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Irinti yora noshaninca nojivavetacari nocajemacantavetacari, eiro catsini yoimatarotsi oca novetsicavetanariri”. Irootaque iquenquetsatacaajeitiriri Jesoshi anta ivancoqui variseo. ");
INSERT INTO cniNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ari iquenanaque Jesoshi avotsiqui aisati, yoijajeitanaqueri oshequi atiri. Ipitsocashijeitanacari, icantajeitiri: ");
INSERT INTO cniNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Niotaque pinintajeitiri piripee, piniropee, pijinapee, pitomipee, pirentipee, pitsiropee, maaroni. Aisati avisati nintajeitacha avirori. Iro cantaincha pincoajeiterica poijajeitena, ocametsati nainti pinintasanojeitena catsini. Eirorica pinintasanotanatsi, tecatsi pincantea pimpeajea noamere. ");
INSERT INTO cniNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aisati eirorica pipomerentsiventasanotanarotsi nocoacaajeitaquempiri, aisati eirorica poijatasanotanatsi, tecatsi pincantea pimpeajea noamere. Pinquenqueshirejeitea jaocarica oncanteari. ");
INSERT INTO cniNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Oquempetaca ariorica icoaque irantacantero shirampari ivanco, irijivataque irisampiteri yora vetsiquenerine jaoca oncarate ompinatea. Impoiji irimoncarateri iirequite iriotanteari moncaratacarica. ");
INSERT INTO cniNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eirorica ijivati iriote irimoncaratearica, icomitarocari. Ariorica irimoncaratearo ominca, ari ocarati. Impoiji tecatsi pashini iranteneri yora vetsicavetanariri. Impoiji irishirontimenteari ishaninca. ");
INSERT INTO cniNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Incantajeite: “Pineaqueri, irovetsicacanterome pancotsi, iro cantaincha te intsoncacanteroji. Te intimeji iirequite, iji, iji, iji”. ");
INSERT INTO cniNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Aisati yora pincatsari, ariorica inquemacoteri itsipapee atiri itiancaqueri 20,000 soraro inquisanteariri. Ariorica intime isorarote pincatsari 10,000. Te irioteji ocameetsatirica irimanatavaqueri yora pocatsineri. Tempa irijivate incajemajeiteri ishanincapee iroametatavacanteari: impoiji iriote ocameetsatirica irimanatea iroimpianteariri yora pocashiterineri. ");
INSERT INTO cniNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ariorica incantajeite ishaninca: “Yanaacojeitaquee, ishequitasanotaque. Tecatsi ancantea aimpiavajeri”. Ari incanteri: “Tequera irareejeitea, tsame antianqueri aparopee ashaninca irisampiteri paitarica incoacojeitaqueeri eiroquea imanatantapeetsi”. ");
INSERT INTO cniNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Aisati pinquempetea avirorijei: ariorica pincoaque poijatena, pijivate pinquenqueshirete jaoca ocantajeitari maaroni timimojeitimpiri. Piotasanojeitero: impoiji pojocajeitajero, poijatasanojeitanaquena. ");
INSERT INTO cniNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Nocoaque yora quemisantanari iroameteri itsipapee atiri intime cameetsa, irompa eirorica yoametiritsi, te irimateroji nocoacaavetacariri, yatsipetashitaca itimi. Iquempetacaro tivi caari poteatatsine: tempa ajocajero. Pinquenqueshiretasanotero oca nocantajeitaquempiri piotasanotantearori. Irootaque icantajeitaqueriri Jesoshi oijajeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Itimi anta oshequi jorio aitiriri iirequite ishaninca impanteariri yora oromasati, aisati icoshitaqueri ishaninca. Iro cantaincha yamejeitaca iriori yapatotimentapinitari Jesoshi, icarajeitaqueri itsipapee antapinitirori caari cameetsatatsi. Iquemisantapinijeitaqueri Jesoshi iquenquetsati. ");
INSERT INTO cniNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ari icantajeiti yora variseopee aisati yora oametantirori Sanquenarentsi: —Te oncameetsateji oca yantapinitiri Jesoshi: icarajeitapinitiri caari cameetsayetatsi, itsipajeitacari yoajeita. ");
INSERT INTO cniNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Impoiji, jero oca ishiacantiniriri Jesoshi: ");
INSERT INTO cniNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Aamaaca intimerica povishate 100. Impeaquearica aparoni, tempa ari poanaqueri yora 99 anta queshiiqui, impoiji pijatanaque anta caaraiteriqui, pincoacoanteariri peainchari. Pincoacoayetajeri irosati pineantajeariri. ");
INSERT INTO cniNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ariorica pineapaajeri, tempa oshequi pinquimoshireventajeari. Tempa pinquijajeri, paanajeri, poajateri anta itimajeitinta ishaninca. ");
INSERT INTO cniNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aisati, ariorica pareetea pinampiqui, tempa pincajemajeiteri pishaninca, pincantajeiteri: “Tsame anquimoshirejeite: ipeavetaca novishate, naajiri aisati”. ");
INSERT INTO cniNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aisati iquempeta Tasorentsi. Ariorica inquenqueshiretajea aparoni antirori caari cameetsatatsi irojocantearori, incanteri maaroni savicajeitatsiri inquitequi: “Tsame anquimoshireventajeiteri”. Te irio incantacote yora itsipapee cameetsajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jero pashini icantiriri Jesoshi: —Pashini aisati noshiacaventempiro: otimi tsinane oirequite, icarati iitsoqui 10. Ariorica impeaquea aparoni, oncoacoayetajeri. Ariorica ontsitenitanaque, ontsiotero otsiomento, oneanteariri, aisati ompishitasanotero pancotsi amenayetajeri otijaqueririca quipatsi. Ari oncoacoayetajeri irosati oneantajeariri. ");
INSERT INTO cniNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ariorica oneajeri, oncajemeri oshanincajei, oncanteri: “Tsame pintsipajeitena, anquimoshirejeitanaque. Noneajiri aisati noirequite peavetainchari”. ");
INSERT INTO cniNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Aisati noncamantajeitempi: aisati iquempetaca Tasorentsi. Ariorica inquenqueshiretajea aparoni antirori caari cameetsatatsi irojocantajearori yantayetiri, inquimoshiretanaque Tasorentsi, irineajeiteri inampirepee. ");
INSERT INTO cniNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Pashini aisati ishiacantiniri Jesoshi: —Itimi shirampari itomi apite. ");
INSERT INTO cniNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yora impoitatsiri itimi icantiri iriri: “Apa, nocoaque pishinetenaro nayerota maaroni novaararo aisati maaroni noirequite. Pimpenaro meeca maaroni”. Ari ipajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pashini quitaiteri yapatojeitaquero irovaararo, maaroni. Ijataque arejiqui, pashiniqui nampitsi, yaanaquero maaroni timimojeitiriri. Anta te irisavique cameetsa, irootaque yaparatantacarori maaroni irovaararo aisati iirequite. ");
INSERT INTO cniNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ari tecatsi timimotajerine, aisati te ontimasanoteji iroajeiteari atiri. Oshequi yashinoncaaca evancari, iquemasanotaquero itashe. ");
INSERT INTO cniNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Impoiji iquenaquenayetanaque iramenayeteri tsameetacayerineri. Ineapaaqueri aparoni ashitariri ichanchote, icantapaaqueri: “¿Picoaquempa nontsameetempi?” Icantiri: “Je, nocoaque pamenenari nochanchote”. ");
INSERT INTO cniNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ari yamenavetacanari ichanchote, ipapinitiri yoari: ora shiavetarori otaqui intsipa. Iro cantaincha tecatsi oacayearine yora evancari, icoavetanaca iroacotearime yoari chancho. ");
INSERT INTO cniNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Impoiji iquenqueshiretanaja: “Icarajeitaque iratirite apa oshequi. Timatsi yoajeitari maaroni, iquemapinijeitaca, timatsi timaarantapaintsiri aisati. Naintiquea, aasanotaquena notashe. ");
INSERT INTO cniNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Meeca nompianaje anta apaqui, noncantapaajeri: ‘Apa, te nonquemisantempiji, aisati te nonquemisanteriji Tasorentsi. Ainiro nantane oshequi. ");
INSERT INTO cniNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Eiro meeca pitomintajanatsi, ainti pinampitajena. Nontsameetempiro piipatsite’ ”. ");
INSERT INTO cniNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Impoiji ipianaja, iquenanaji avotsiqui. Icaantanaja, irotapaajantsi ivanco iriri. Ari iniitavajari iriri anta paricoti, iquenapaaji. Oshequi iquimoshiretanaque, icavintsaasanotavajiri. Ishiashitavajari iquempejitavajari, yavitsanotavajiri, inintavorotavajiri. ");
INSERT INTO cniNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ari icantapaaqueri itomi: “Apa, te nonquemisanteriji Tasorentsi, aisati te nonquemisantempiji avirori. Ainiro nantaneve. Te oncameetsateji pintomintajena”. ");
INSERT INTO cniNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Iro cantaincha icajemiri iriri inampirepee, icantajeitiri: “Pishintsijeite, paitero quitsaarentsi cameetsari, pinquitsaateri notomi. Aisati paiteneri aniyo, pisatevacoteneri iracotsapaquiqui. Paiteneri aisati sapato, irisapatotapaajeari. ");
INSERT INTO cniNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aisati paiteneri vacajaniqui, timasanotatsiri ireji, poyeneri. Tsame maaroni anquimoshireventavajeri notomi, avacaajeitavajeari, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nojivetaca eiro noneajiritsi, oquempetimotaquena icamaque. Iro cantaincha meeca oquempetaca yaneanaji aisati, meeca noneajiri. Ipeavetaca, meeca ipocaji, aneajeitajiri aisati”. Ari iquimoshirejeitanaque, yoacaajeitajari. ");
INSERT INTO cniNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ari itsameeti itomi pashini anta oantsiqui: te irineavajeriji irirenti. Impoiji yareetapaaja iriori, iquempejitapaaji iquemapaaquero moshica, aisati ivairajeitaque. ");
INSERT INTO cniNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Icajemapaaqueri aparoni nampirentsi, isampitiri: “¿Paita pivairajeitantari?” ");
INSERT INTO cniNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yacanaqueri: “Areetapaaja pirenti. Yoacantaqueri piri vacajaniqui, yoacaajeitacari maaroni. Oshequi iquimoshireventavajiri pirenti ipocaji, cameetsa yareetaja, tecatsi oyerine”. ");
INSERT INTO cniNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Irosati iquisantanaca irirenti, te incoyeji inqueapaaje pancotsiqui. Isoquijanaque iriri, icantavetavajari: “Caate, notiomi, pinqueapee. Piveshireimentavajeari pirenti”. ");
INSERT INTO cniNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Iro cantaincha yacanaqueri: “Peerani nantaveetaquempiro paitapeerica picantaquenari, te nompiatsatimatempiji. Iro cantaincha tecatsi pimpena nainti catsini noacayearimeri noshanincapee. Te pimpenariji chivo, tecatsi catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Jeri iyeniro, ijatanaque arejiqui itsonquitaquempiri piirequite: ipinajeitaquero tsinanepee ineavintsajeitaquero. Meeca ipianirotaja, ari poaqueneri cameetsari vaca”. ");
INSERT INTO cniNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ari icantiri: “Notiomi, acantani quiso avavacaaca. Avirotaque ashitearoneri maaroni vaararontsi oca avancoquinirica. ");
INSERT INTO cniNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Iro cantaincha ocameetsati aveshireimenteari pirenti. Oquempevetaca icamaque, ajijeivetaca eiro aneajiritsi aisati. Meeca oquempetaca yaneanaji aisati, aneajeitajiri. Ipeavetaca, meeca aneajeitajiri aisati. Tsame aveshireimentajeiteari”. ");
INSERT INTO cniNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aisati icantiri Jesoshi iroamere: —Itimi ashitaarantincari quempoyeajiniriri iirequite, maaroni. Impoiji icanteetiri: “Icoshitaquempi yora quempoyeavetimpiriri piirequite”. ");
INSERT INTO cniNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Impoiji icajemaqueri, isampitiri: “¿Paita ojita oca icanteetaquenari? ¿Paita picoshinirotantanari? Meeca poimpiajenari maaroni noirequite, pisanquenatenaro ivajiropee maaroni irevitanari. Meeca eiro noshinetajimpiritsi aisati noirequite”. ");
INSERT INTO cniNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ari iquenqueshiretanaca iriori: “Eiro meeca ishinetajanatsi novatorote nonquempoyeajeneri iirequite. ¿Paita nanteri meeca? Te noshintsiteji nontsameetanteari. Aisati nopashiventaca noncanterime atiri impashitename quirequi. ");
INSERT INTO cniNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ja, je niotaque meeca. Noncavintsaajeiteri maaroni irevijeitiriri novatorote. Impoiji, iraacameetsajeitena anta ivancoqui: eiro ishinetantana nashinoncaaveetea”. ");
INSERT INTO cniNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ari icajemajeitaqueri maaroni irevijeitiriri ivatorote. Isampitiri yora jivatatsiri yareetapaaja: “¿Jaoca icaratiri pirevitiri novatorote?” ");
INSERT INTO cniNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yacanaqueri: “Nirevitiri oshequi oja orivo. Ocarati nirevitiri jaachari virojaniqui 100”. Icanti: “Je, queario. Jeroca paperi osanquenataca pirevitiriri. Payero paperica, pisanquenateneri otsipa, pincante: ‘Nirevitimpi 50 virojaniqui jachari oja orivo’. Amataviterita novatorote”. Icantiri: “Je, ari”. ");
INSERT INTO cniNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ari ijataque jivatatsiri, ipocaque itsipa. Isampitiri: “¿Jaoca ocaratiri pirevitiri novatorote?” Yacanaqueri: “Oshequi nirevitiri tirico, ocarati jainchari coshitariqui 100”. Ari icantiri: “Jeroca paperica pisanquenatiniri peerani novatorote. Queario, ocarati pirevitiri 100. Tsame amataviterita. Payero oca paperica, pojocajero; pisanquenateneri otsipa, pincanteri: ‘Nirevitimpi 80 coshitari, jainchari tirico’ ”. Ari isanquenataquero. ");
INSERT INTO cniNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Impoiji iotanaque yora ivatorote yamatavitaqueri. Icantaque: “Te oncameetsateji yamatavitaquena, iro cantaincha otimi ionirotantari irayero coiteimotacariri”. Queario yora tseencantatsiri ioniroti iomparitavacaajeita. Irintiquea yora quemisantatsiri te iriotasanoteji. ");
INSERT INTO cniNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Meeca noncamantajeitempi: intimerica piirequite, pincavintsaajeiteri pishaninca, pimpajeiteri coiteimotariri iriori. Eiro ipeacotarotsi. Impoiji pincamajeitanaque, pojocajeitero timimojeitimpiri, iro cantaincha iraacameetsajeitempi anta inquitequi yora picavintsaajeitaqueri. Tempa anta otimi pisavicanteari caari tsoncanetachane. ");
INSERT INTO cniNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Eirorica picoshititsi capichaji, eiro picoshititsi aisati antearoite. Iro cantaincha pincoshiterica capichaji, picoshiticari aisati antearoite. ");
INSERT INTO cniNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ariorica pincoshiyete quirequi, iriotanaque Tasorentsi te pinquenqueshireteriji iriori: impoiji eiro ishanincatimpitsi, eiro pineirotsi inampi. ");
INSERT INTO cniNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ariorica pincoshiteri iirequite itsipapee, ¿paitaquea impashitantempiri Tasorentsi piirequite avirori? ");
INSERT INTO cniNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tecatsi pincantea pantaveeteneri apite pivatorote. Ariorica pinintasanoteri aparoni, eiro piquempetaritsi itsipa. Piveshireimenteari aparoni, irinti itsipa, eiro. Aisati ariorica pishintsiventeri quirequi, eiro pimatirotsi pishintsiventeri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ari iquemajeitaqueri variseopee icantaqueriri Jesoshi, irosati ishirontimentajeitantacari. Icoaque irashitaarantea oshequi, irootaque ishirontimentantariri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ari icantiri: —Picoajeitaque irijijeitempi atiri picameetsajeitaque, iro cantaincha iojeitaquempi Tasorentsi. Ineacameetsavetimpi atiri, iro cantaincha iotaque Tasorentsi te pincameetsajeiteji. ");
INSERT INTO cniNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Peerani ocameetsatini piquemisantironi isanquenareni Moishishini aisati yora camantantatsiniri pavisacotantajari. Iro cantaincha areetapaaca meeca Joa, yora vaotisatantatsiri. Onashita meeca icoacaajeitaquempiri Tasorentsi. Yora Joa intanacaro icamantajeitaquempi cameetsatatsiri: irotaintsi impincatsariventajeitempi Tasorentsi. Icoasanojeiveta atiri irineeri. ");
INSERT INTO cniNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Coajica ompeanajea quipatsi aisati inquite, iro cantaincha eiro opeatsi irointi isanquenare Moishishi: icoi Tasorentsi pincanteani pinquemisantero piotanteari cameetsa pisavique. ");
INSERT INTO cniNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tempa ocanti: “Eiro paimentarotsi pijina”. Ariorica pojoquero pijinasanori paantearori otsipa tsinane, paimentearo pijina. Aisati te oncameetsateji payero tsinane joquiriri ojime. ");
INSERT INTO cniNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ari icantajeitiri Jesoshi: —Itimi aparoni shirampari ashitaarantincari, oshequi iitsaare cameetsamaotatsiri, oshequi yoaneencaca. Maaroni quitaiteriqui yoacaajeitacari ishaninca yoari pinatasanotachari. ");
INSERT INTO cniNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Itimi aisati ashinoncaasanotachari pajitachari Irasaro. Osoncayetanaque isompopee opatsaayetanaqueri. Ari isavicapiniveta anta iqueapinitinta ashitaarantincari ivancoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Oshequi yashinoncaaca, aasanotaqueri itashe. Icoaveta iroajearome yoari yoariayetaqueri ashitaarantincari quipatsiqui. Aisati yora otsitipee yatsoyetapaaqueri ivatsaaropeequi. ");
INSERT INTO cniNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Impoiji icamaque iriori. Ijatashitaqueri inampirepee Tasorentsi, yaavajiri, impoiji yaanajiri anta itiminta Avaramani. Ocameetsaitetinta catsini. Aisati icamaque yora ashitaarantincari. ");
INSERT INTO cniNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Oshequi yashinoncaaca meeca yora ashitaarantaveitachaniri anta Sharincaveniqui, oshequi ineacatsitacaro. Yamenanaque anta osamani itiminta Avarama. Ineaqueri Avarama, jeri aisati yora Irasaro. ");
INSERT INTO cniNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Icajemacotaqueri: “Apa Avarama, pineshinoncatajena. Pincanteri yora Irasaro irovinquerota iracotsapaqui nijaqui, impoqueta aca nantsotantearori nija. Oshequi catsini nashinoncaaca aca paamariqui”. ");
INSERT INTO cniNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Iro cantaincha icantaqueri Avarama: “Notiomi, pinquenqueshiretea jaoca ocantani peerani pitimaveitani quipatsiqui. Cameetsa pisaviquini catsini, irintiquea Irasaroca oshequi yashinoncaaveitani. Meeca cameetsa isavicapaaque irinti, irompa avinti oshequi pashinoncaaca. ");
INSERT INTO cniNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aisati pineaquero nijantaitetacotaquempi, tecatsi inquenashitantempiri Irasaro. Aisati avirori, tecatsi pinquenashitantenari”. ");
INSERT INTO cniNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ari icantiri: “Eirorica pimatirotsi pincavintsayena. Iro cantaincha pintianqueri Irasaro quipatsiqui: anta ivanconiqui apani. ");
INSERT INTO cniNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Aneatsiquera anta iyepee, icarati apapacoroni. Nocoaque inquemisantacaapaajeri, ipoquicari aca. Pamene meeca narori, oshequi noquematsicatacaro catsini”. ");
INSERT INTO cniNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Iro cantaincha icantiri Avarama: “Otimi isanquenare Moishishi aisati isanquenare itsipapee quenquetsatacantantatsiniri. Irootaque inquemisantajeiteri irointi”. ");
INSERT INTO cniNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ari yacanaqueri: “Je, ainiro onaveta. Iro cantaincha ariorica irineajeri camaintsiri intinaanaje, aitaque inquenqueshirejeitanajea, irojocajero caari cameetsatatsi yantajeitiri”. ");
INSERT INTO cniNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Icantiri Avarama: “Terica inquemisantero sanquenarentsi, eiro aisati iquemisantiritsi tinaajantsineri”. ");
INSERT INTO cniNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Icantajeitiri Jesoshi iroamerepee: —Noncamantempi: incanteani intime atiri antacaajeiterineri ishaninca caari cameetsatatsi. Iro cantaincha iroashinoncaajeiteri Tasorentsi yora antacairiri ishaninca caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aitaque iroashinoncaasanoteri antacaajeitiriri jananequipee caari cameetsatatsi. Oncameetsateme irijivataqueme iroisoyeeterime mapiqui antearo, irovincanteetearirime. Irovinqueeterime, eiro yantacairime jananequi caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Queariompia, pantacairicari pishaninca caari cameetsatatsi. Aisati icantiri: —Ariorica pineacotaqueri pishaninca yantiro caari cameetsatatsi, pinquenqueshiretacayeari. Ariorica irojocajero yantiri, pincavintsayeri, paacameetsatajeri. ");
INSERT INTO cniNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ariorica inquishempi pishaninca, incoshitempi, incantimatempi, paitarica. Iro cantaincha ariorica incantempi: “Te oncameetsateji nantitaquempiri, pincavintsayena”, ari nocoaque pincavintsayeri. Ariorica oshequi irampiitajero irantitajempiro, aisati oshequi incantempi: “Pincavintsayena”. Ari nocoaque oshequi pincavintsayeri aisati, eiro piquishimentiritsi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yora iroamerepee icantaqueri Avincatsarite: —Noquemisantaveta. Nocoaque poametena nonquemisantasanotantajeari. ");
INSERT INTO cniNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ari yacanaqueri: —Pinquemisanteme capichaji, pincoaquericame, pincanterime Tasorentsi imponquitireajero inchatora, iroviincaitero anta incajarequi. Ari inquemisantempime, iroviincaiterome. ");
INSERT INTO cniNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aisati icantajeitiri Jesoshi: —Oquempetaca itimi shirampari iratirite. Itsameetapinitiniri aisati yamenapinitiniri ivira. Ariorica impocaje iratirite pancotsiqui, ¿paita incantavaqueriri ivatorote? ¿Incanterimpa: “Caate, pisavicapee, poapeempa”? Eiro icantiritsi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tempa incanteri ivatorote: “Meeca povetsiquenarota noyeari, aisati nireri. Pamaquenaro. Ariorica nonquemanaquea, ari poyea avirori, aisati pire”. ");
INSERT INTO cniNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aisati eiro icantavetaritsi: “Ariove, pimataquenaro”; tempa yametacaro yantaveetapinitiniri ivatorote. ");
INSERT INTO cniNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aisati avirorijei, ocameetsati pimatapinijeiteneri maaroni icoacaaquempiri Tasorentsi. Impoiji oncameetsate pincante: “Apatiro nomataqueneri icoacaaquenari. ¿Paita noshemetanteari? Te noncoyeji noncoacoteri Tasorentsi impinatena”. ");
INSERT INTO cniNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ari yovaanaja Jesoshi, iquenayetanaque Samariaqui aisati Carireaqui. Ishiretaca irareetea Jerosarequi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ari yareetapaaca pashiniqui nampitsi, ineajeitavaqueri patsaajeitatsiri, icarajeiti 10. Icatiajeitaca aiquetiji ara. ");
INSERT INTO cniNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Icajemacojeitaqueri: —Jesoshi, aviro nopincatsajeitiri, pincavintsaajeitena, poavisacojeitena. ");
INSERT INTO cniNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ari ineantacariri Jesoshi, icantajeitiri: —Pijajeite anta itiminta saserote, pinijapeempari. Ari iquemisantajeitaqueri, ijajeitanaque. Anta nianqui avotsi yavisacojeitanaji. ");
INSERT INTO cniNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ari iojeitaque yavisacojeitaji, iro cantaincha ipianaja aparoni anta Jesoshiqui. Antearojenca icantaque: —Tempa icameetsataque Tasorentsi, yoavisacotaquena. ");
INSERT INTO cniNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Itiyeroashitapaacari Jesoshi, yoivotasanotashitacari, ipincatsatasanotaqueri, ipasonquitasanotaqueri. Iponeaca yoca shirampari Samariaqui. ");
INSERT INTO cniNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ari icanti Jesoshi: —Tempa icarajeiti noavisacojeitiri 10. ¿Jaoca itsipapee noavisacojeitiri? ");
INSERT INTO cniNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ipiashitajana yoca pashinisati atiri, ipasonquitaquena, aisati ineacameetsatiri Tasorentsi. Irintipee ashanincasanoripee, ¿paita caari ipiantaja impasonquitanteariri Tasorentsi? ");
INSERT INTO cniNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Impoiji icantiri tiyeroashitacariri: —Meeca pincatiaje, ocameetsati pijataje. Pishiretacari Tasorentsi, irootaque pavisacotantajari. ");
INSERT INTO cniNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ari yora variseopee isampijeitiri Jesoshi: —¿Jaoca oncarate impoque Tasorentsi impincatsariventajeitajee? Ari yacanaqueri: —Ariorica impincatsariventante Tasorentsi, iro cantaincha eiro pineasanotiritsi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Eiro pimatirotsi pincante: “Jeri yoca”, aisati: “Jeri yonta”. Queario, eiro iconijatasanotitsi: ocameetsataque pimpincatsashireajeiteri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aisati icantajeitiri iroamerepee: —Tempa noponeaca inquitequi, natiritapaaque, iro cantaincha eiro nocantani quiso noajempi. Coajica pincoajeivetanaquea pineajename aisati, iro cantaincha eiro pineajanatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Impoiji incanteetempi: “Ipiaja Jesoshi, itimi anta”, pashini incanteete: “Jeri yora”. Iro cantaincha caarina. Eiro patsipetashitatsi pijatashitena. ");
INSERT INTO cniNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ariorica omoncaratasanotaquea nompocanteari, ari piotasanotavaquena. Iquempetaca te irimaneaji itirei, aisati iporequi; aisati nonquempetajea narori, nompocajerica. Eiro nomanapaatsi, eiro picomitavaquena. ");
INSERT INTO cniNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nojivatavaqueta nonquematsicatavaquearota oshequi, aisati intseencajeitavaquenata savicajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Oquempetaca peerani itimantacari Noeni itseencajeitaqueri Tasorentsi, aisati inquempejeitea ariorica nompiaje narori, intseencajeite atiri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yoapinijeita peerani, irapinijeiti, yaapinijeitiro ijinapee, yaacaayetiro irishintopee, paitapeerica. Icantajeitani, irosati itetantanaca Noe ivitoqui. Impoiji opoqui antearo incani, incajaretanaque maaroni. Icamajeitanaque maaroni tseencajeitantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Aisati iquempejeitacani ishaninca Oroti, savicajeitatsiniri Soromaqui: yoapinijeita, irapinijeiti, iquenayetanaque iyompariyetanaca, ipanquiyetiro yoari, yovetsicanontayeta ivancopee. ");
INSERT INTO cniNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Iro cantaincha ijatantanacari Oroti, itiancaquero Tasorentsi oshequi paamari, itaajeitaqueri maaroni soromasatini. Itseencajeitini, irootaque ipoyereajeitantacariri Tasorentsi maaroni, poyere. ");
INSERT INTO cniNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aitaque oncanteari ariorica nompiaje. Intime oshequi tseencantatsineri, eiro iquenqueshiretiritsi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pamene, ariorica omoncarataquea nompocantajeari, pintimerica saiteriqui, eiro piqueapanajantitsi pancotsiqui paantapanajantearori pivaararo. Aisati, pintimerica oantsiqui, eiro pipiapanajantatsi nampitsiqui paantapanajantearori pivaararo. ");
INSERT INTO cniNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Piquempetarocari ijinani Oroti, pipitsoquicari. ");
INSERT INTO cniNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Picoicari poavisacotajea avisati, impoiji pijaticari Sharincaveniqui. Iro cantaincha ariorica pincamimentena narori, pincantaitatiyempani pisaviquimotena inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ariorica nompocaje, intime apite maatsineri imaamentoqui. Aparo naanajeri nontsipatanaqueari, irinti itsipa, eiro naanajiritsi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ontime apite tsinane ontsipatavacaaquea ontononquero tirico. Aparo naanajero nontsipatanaquearo, irointi otsipa, eiro naanajirotsi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Intime apite shirampari anta oantsiqui, intsipatavacayea intsameete. Aparo naanajeri nontsipatanaqueari, irinti itsipa, eiro naanajiritsi. ");
INSERT INTO cniNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ari iquemajeitantacariri iroamerepee, isampitiri: —Novincatsarite, ¿jaocampa pinijantajeari oca picantaquenari? Yacanaqueri: —Jaocarica anta intimeri tseencantatsiri, yora iroashinoncayeri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pashiniqui quitaiteri iquenquetsatacaajeitiri aisati Jesoshi iroamere. Icoaque iroameteri inquenquetsatacaapiniteri Tasorentsi, inquearioventajeitero, eiro yoipacaajirotsi. ");
INSERT INTO cniNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Icantajeitiri: —Itimini anta nampitsiqui yora joeshitatsiri, caari pincatsatiri Tasorentsi. Aisati te irioteniji incavintsayeri ishanincapee. ");
INSERT INTO cniNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Otimi anta inampiqui aparoni tsinane, camajimentaaro. Ojatashitapinivetari yora joeshi, ocantapinivetari: “Pamitacotena, te oncameetsateji iquisapinitana yora itsipa shirampari”. ");
INSERT INTO cniNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Te incoaveteaji yoranqui iramitacotero, iro cantaincha iquenqueshiretanaca: “Te nompincatsateriji Tasorentsi, aisati te noninteji noncavintsayeri itsipapee noshaninca. ");
INSERT INTO cniNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Iro cantaincha oshequi ashereaquena oca tsinane. Namitacoterota, impoiji eiro opocashitapinitajanatsi, eiro ashereapinitajanatsi aisati”. ");
INSERT INTO cniNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ari icanti Avincatsarite: —Pamene, te incameetsateji yora joeshi noquenquetsatacotiri, iro cantaincha yamitacotaquero oca tsinane cantapinitiriri. ");
INSERT INTO cniNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Irintiquea Tasorentsi, icameetsataque. Ariorica incanteani incantapiniteri quemisantatsiri, tempa iramitacoteri. ");
INSERT INTO cniNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Queariotaque oca noncamantempiri: intsipaite iramitacojeiteri Tasorentsi maaroni quenquetsatacaajeiterineri. Iro cantaincha ariorica nompiaje aca quipatsiquica ¿arimpa noneapeempi piquemisantajeiti, piquenquetsatacaajeitiri Tasorentsi? ");
INSERT INTO cniNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pashini aisati iquenquetsati Jesoshi. Iquenquetsatacotiri yora shemetatsiri, yora tseencajeitiriri itsipapee ishaninca. Icantiri: ");
INSERT INTO cniNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ijataque apite shirampari ivancoqui Tasorentsi, inquenquetsatacayeri Tasorentsi. Variseo ini aparo, irinti itsipa yapatotiniri oromasati iirequite joriopee. ");
INSERT INTO cniNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ari icatiapaaca yora variseo, icantavetapaacari: “Tasorentsi, ariove, oshequi nocameetsataque nainti. Tecatsi nante, te nonquempeteariji yora coshitantatsiri, yora amatavitantatsiri, aavioncatsiri ijina. Aisati te nonquempeteariji yora aitiriri noshaninca iirequite. ");
INSERT INTO cniNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nametacaro maaroni tominco notitapinita apite quitaiteri, aisati nopaarantapiniyetimpiro maaroni naayetiri. Naaquerica 10, aparoni nopaquempi”. ");
INSERT INTO cniNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Irinti yora apatotapinitiniriri oromasati iirequite ishaninca, icatiapaaca irinti nijanteaji. Te irishemeteji irinti, irointi oshequi ipashiventacaacaro yantayetiri, irootaque caari yamenanta jenoqui, irointi iposanejitaca. Icanti: “Tasorentsi, pincavintsaajena narori, te noncameetsateji catsini, ainiro oshequi nantane”. ");
INSERT INTO cniNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ari noncamantempi, oshequi onaveta irantane yora shirampari, iro cantaincha icavintsairi Tasorentsi. Ariorica impiaje ivancoqui iriotanaque ineacameetsatiri Tasorentsi. Irintiquea yora variseo, te inquempeteariji. Eiro ineacameetsatiritsi Tasorentsi shemetatsiri. Irinti yora caari shemetatsi impeajeri pincatsaritajantsine. ");
INSERT INTO cniNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Impoiji tsinanepee amajeitiniri Jesoshi otomipee, ocoaque impamijeiteri aisati incanteri Tasorentsi iramitacoteri. Iro cantaincha ineantacarori iroamere, itsaneacovetacari impocashiteri. ");
INSERT INTO cniNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Iro cantaincha icajemiri Jesoshi jananequipee, icantiri iroamere: —Eiro pitsaneacotanaritsi, aitaque nocoaque impocashijeitena. Pineajeitaqueri iriorijei: te intseencajeitenaji, irointi ishirejeitaquena. Maaroni quempejeitacariri irineajeiteri Tasorentsi impincatsariventajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Aisati, queariotaque oca noncamantempiri: maaroni caari quempetari jananequi iriori, eiro ineiritsi Tasorentsi impincatsariventajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pashini quitaiteri ijatashitaqueri Jesoshi aparoni ivincatsarite jorio. Icantapaaqueri: —Oametanari, oshequi picameetsati. Pincamantena: ¿paita nanteri nojatanteari anta inquitequi, noncantaitatiyempani? ");
INSERT INTO cniNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Icantiri Jesoshi: —¿Paita picantantanari: “Picameetsati”? Itimi aparo cameetsatatsiri, yora Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Piojeitiro maaroni icantiri Tasorentsi: “Eiro paimentarotsi pijina, eiro paimentaritsi pijime, eiro picoshititsi, eiro pitseeyacotaritsi pishaninca, pimpincatsateri piri, aisati pimpincatsatero piniro”. ");
INSERT INTO cniNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yacanaqueri: —Aitaque nocantani nomoncarataqueroni: nevancaritapaini, irosati meeca. ");
INSERT INTO cniNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iquemantacarori oca, icantiri Jesoshi: —Apanivaniji pimatero aisati: pimpimantajeitero maaroni timimojeitimpiri, pimpajeiteri ashinoncaincari ovinaro. Ariorica pimatero oca ontime oshequi timimojeitajempineri anta inquitequi. Ariorica pimpimantero pivaararo, pimpoque, poijatasanotanaquena. ");
INSERT INTO cniNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Iquemantacarori oca, oshequi yoashiretanaca. Ashitaarantincari ini, te incoyeji impimantero irovaararo, irointi yompetanacaro. ");
INSERT INTO cniNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ineaqueri Jesoshi yoashiretanaca, impoiji icanti: —Opomerentsitimotacari ashitaarantincari irijate anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tempa opomerentsitimotari cameyo inqueero omoro quitsapi, iravisantanajeari. Irioquea ompomerentsitimotasanoteari catsini irijate ashitaarantincari anta Tasorentsiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ari isampitiri yora quemavaqueriri: —¿Ariompa? Pomerentsitaca. ¿Janicampa meeca avisacotajantsineri? ");
INSERT INTO cniNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yacanaqueri Jesoshi: —Oca caari imatapiniti atiri, imataquero Tasorentsi irinti. ");
INSERT INTO cniNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ari icantiri Petero: —Oametanari, nojocajeitaquero maaroni noijajeitantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yacanaqueri: —Queariotaque oca noncamantempiri: te pantsipetashitearoji. Ariorica pojocajeitajero pivancopee, pijinapee, pirentipee, pitsiropee, piripee, piniropee, pitomipee, pishintopee: iro cantaincha irootaque pojocajeitanteariri picoasanotaque impincatsariventempi Tasorentsi, eiro patsipetashitarotsi. ");
INSERT INTO cniNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Aitaque impinataquempi Tasorentsi meeca aca quipatsiquica, aisati impinataquempi anta inquitequi: paneantasanotajeari anta, pincantaitatiyempani. ");
INSERT INTO cniNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Impoiji icajemaqueri Jesoshi iroamerepee, icantaqueri: —Tsame ajajeite meeca Jerosarequi. Timatsi isanquenatacotaquenaniri peerani yora quenquetsatacantantatsiniri. Noponeaca inquitequi, natiritapaaque. Meeca anta Jerosarequi omoncarataquea maaroni isanquenatacotaquenaniri. ");
INSERT INTO cniNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iraacantena ashaninca arori, irayena itsipapee atiri. Irishirontimentajeitena, iroashinoncaajeitena, inquitiojena, ");
INSERT INTO cniNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","impasanatena, iroyena. Oncaratapaaque mava quitaiteri, nontinaanaje aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iro cantaincha te inquemajeitavaqueroji icantajeivetacariri, icomijeitavacaro. ");
INSERT INTO cniNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ari icaantanaca Jesoshi, iquenanaque avotsiqui, irotaintsi irareetea nampitsiqui pajitachari Jerico. Itimi anta avotsinampiqui shirampari caari amenatsi, icoacotapinijeitiri avisayetatsiri irineshinocatanaqueri, impayetanaqueri quirequi. ");
INSERT INTO cniNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ari iquemavaque caari amenatsi ipocajeitapaaque oshequi atiri. Isampitiri itsipa: —¿Janica pocatsineri? ");
INSERT INTO cniNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yacanaqueri: —Coraque Jesoshi, yora nasaretesati, yoijajeitiri oshequi atiri. Iravisanaje aca. ");
INSERT INTO cniNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ari icajemacotavaqueri: —Jesoshi, aviro ishanincani Iravirini. Pincavintsaanaquenave. ");
INSERT INTO cniNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ari icantajeitiri jivajeitiriri Jesoshi: —Pimajerete. Iro cantaincha, aiquero icantanaitii: —Jesoshi, pincavintsaanaquenave. ");
INSERT INTO cniNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ari icatiapaaca Jesoshi, icantanaque: —Pamaqueri aca. Ari yameetaqueri. Impoiji isampitiri: ");
INSERT INTO cniNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Paita picoaqueri? Yacanaqueri: —Novincatsarite, nocoaque namenaje narori. ");
INSERT INTO cniNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Icantiri: —Ari, aitaque pamenaje meeca. Pishiretaquena, irootaque pavisacotantajeari. ");
INSERT INTO cniNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Irosati yamenantanaja. Ari yoijatanaqueri Jesoshi, icantanaque: —Yamenacaajana Tasorentsi, tempa icameetsataque. Aisati iquempejeitacari maaroni amenajeitaqueriri, icantajeitaque: —Tempa icameetsataque Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Impoiji iquenanaque Jesoshi nampitsiqui, pajitachari Jerico. ");
INSERT INTO cniNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Itimi anta ashitaarantincari pajitachari Saqueo. Iriotaque iriori jivatacaajeitiriri yora apatotapinitiniriri oromasati iirequite jorio. ");
INSERT INTO cniNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Icoaveta Saqueo irineerime Jesoshi, iro cantaincha te iranteariteji, icaajaniquitiji. Icarati oshequi atiri, yojocaajeitavaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ari ishianaca, ijivatanaque anta avotsiqui. Yataitapaaquero inchato anta otsapiqui, anta inquenanaquenta Jesoshi. Iramenavaqueri inquenapaaque ishaaviji. ");
INSERT INTO cniNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ari yareetantapaacari Jesoshi, yamenapaaque jenoqui, ineapaaqueri, icantiri: —Saqueo, pishintsite paniireapaaje. Nocoaque meeca nosavique pivancoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ari ishitsitaque yaniireapaaji, icantaqueri: —Tsamequeti novancoqui. Ari oshequi iquimoshiretanaque Saqueo, ");
INSERT INTO cniNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","iro cantaincha iquisajeitanaca amenajeitaqueriri. Icantajeiti: —Te incameetsanirotejive yora. ¿Paita ijatashitantariri Jesoshi anta ivancoqui? ");
INSERT INTO cniNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ari iquempejitasanotapaacari Saqueo Jesoshi, icantiri: —Novincatsarite, meeca nompaarantajeitajeri ashinoncaincari cashetani timimojeitanari. Itimirica atiri namatavitiri nocoshitantacariri, noimpiajeneri maaroni, aisati nompajeri aisati. Ocaratirica aparo nocoshitaqueri, nompajeri 4. ");
INSERT INTO cniNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Ari icantiri Jesoshi: —Meeca quitaiteri pavisacotaji, aisati iravisacotaje pishaninca aca pivancoqui. Noponeaca narori inquitequi, natiritapaaque: nocoaque namenacaajeitajeri ashinoncaajeitachari, nocoaque noavisacojeitempi maaroni. Tempa aviro ishanincani Avaramani. ");
INSERT INTO cniNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ari iquemajeitaquero atiripee icantaqueri Jesoshi. Aisati iojeitaque irotaintsi irareetea Jerosarequi. Ijitashijeitaca irotaintsi meeca impoque Tasorentsi impincatsariventante aca quipatsiqui, ");
INSERT INTO cniNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","irootaque ishiacantiniriri oca: —Itimini aparoni shirampari, pincatsarivetachari. Impoiji icajemaqueri pashini pincatsari anta pashiniqui quipatsi. Ari irijatanaque, impeaqueri pincatsarisanori impincatsariventanteariri ishaninca anta inampiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ari irotaintsi irijate, icajemaqueri iratirite caratatsiri 10, ipajeitaqueri oshequi quirequi. Icantaqueri: “Jerica aparoni quirequi, ipinataca oshequi. Nocoaque piomparijeitea. Ariorica nompiaje, namenapaajeri jaoca incarate quirequi pampatotenari”. ");
INSERT INTO cniNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ari ijatanaque impeantajeari pincatsari. Iro cantaincha te impincatsajeiteriji ishaninca, oshequi iquisajeitaqueri. Itiancayevetacari aparopee ishaninca, icantavetacari yora itsipapee pincatsari: “Te nonintajeiteji impincatsariventajeitena yoranqui, te incameetsateji”. ");
INSERT INTO cniNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Iro cantaincha ipeaqueri pincatsari, impoiji ipianaja impincatsariventanteariri. Icajemacantajeitaqueri iratiritepee: yora ipajeivetari iirequite. Isampijeitaqueri: “¿Pishequiaquenarimpa noirequite?” ");
INSERT INTO cniNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ari icantiri yora jivatatsiri: “Pamene, meeca noshequiasanotaqueri quirequi. Aparo ishequiasanotanaque, icarataque meeca 10”. ");
INSERT INTO cniNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ari icantiri pincatsari: “Cameetsataque. Oshequi piotaque. Piquearioventaquenaro capichaji. Meeca nompeaquempi pincatsariventeroneri oshequi nampitsi, oncarate 10. Pinquearioventenaro pimpincatsate”. ");
INSERT INTO cniNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ari ipocapaaque itsipapee, icantajeitapaaqueri: “Jerica piirequite. Pipaquenari aparo, meeca icarati apapacoroni”. ");
INSERT INTO cniNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Icanti: “Ari pimpincatsariventeri atiri savicatsiri apapacoroni nampitsi”. ");
INSERT INTO cniNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Impoiji ipocaque itsipa aisati, icanti: “Novincatsarite, jerica piirequite pipaquenari chapinqui. Noquempoyeaquempiri novaniotequi. ");
INSERT INTO cniNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Oshequi notsaroacaaquempi, niotaque oshequi pipincatsaritaque. Paapitsatiri itsipapee yashiyetari, aisati paayetiro oitsoqui caari pipanquiti”. ");
INSERT INTO cniNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Impoiji icantaqueri: “Te pincameetsateji, te pimatenaroji nocoacaavetaquempiri. Picantavetana: ‘Oshequi pipincatsariti, paapitsatiri itsipapee yashiyevetari, paayetiro oitsoqui caari pipanquiti’. Ari pioveta, irootaque noquisantaquempiri meeca. ");
INSERT INTO cniNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Paita caari poantari noirequite vaancoqui? Poaquerime anta, ari intimeme meeca noirequite, aisati itsipa quirequi impaquenarime yora quempoyeajanariri”. ");
INSERT INTO cniNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Irosati icantantari yora catiajeitainchari: “Paapitsatajeri noirequite. Pimperi yora ashitariri 10”. ");
INSERT INTO cniNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ari icantajeivetari: “Novincatsarite, oshequi iirequite meeca. ¿Paitaquea pimpashitanteariri itsipa aisati?” ");
INSERT INTO cniNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yacanaqueri: “Noncamantempi, intimerica ashitaarantayetachari, nompajeri aisati. Irinti yora caari ashitaarantacha, naapitsatajeri ora capichaji timimovetariri. ");
INSERT INTO cniNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aisati itimi quisaquenari caari coatsine impincatsajeitena. Pamajeitaquenari, namenacojeitempiri poajeiteri”. Irootaque iquenquetsatacaajeitiriri Jesoshi atiripee. ");
INSERT INTO cniNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Impoiji yovaanaja aisati Jesoshi, irijate Jerosarequi. ");
INSERT INTO cniNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Irotapaintsi irareetearo nampitsi pajitachari Vetajaje aisati Vetania. Otimi anta toncaariqui pajitachari Orivomashi. Impoiji itianquiri iroamere apite, ");
INSERT INTO cniNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","icantaqueri: —Pijate anta nampitsiqui, pineapaaqueri voro itsatacotaca anta. Tequera inquijacoyeeteari. Pintsatacoreapaaqueri, pamaquenari. ");
INSERT INTO cniNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ariorica irisampiyeetempi: “¿Paita pitsatacoreantariri?” Ari pincanteri: “Icoaqueri Avincatsarite”. ");
INSERT INTO cniNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ari ijajeitanaque apite, ineapaaqueri icantaqueriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ari itsatacoreapaaqueri. Irosati isampitantacari ashitariri: —¿Paita pitsatacoreantariri novorote? ");
INSERT INTO cniNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yacanaqueri: —Icoaqueri Avincatsarite. —Ari, paanaqueneri. ");
INSERT INTO cniNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ari yaanaqueri anta Jesoshiqui. Yoanquetaqueneri imititsaqui iitsaarepee irisavicanteari Jesoshi, impoiji iquijacotanacari. ");
INSERT INTO cniNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ari yovaacotanaja anta avotsiqui, yoajeitiniri atiripee iitsaarepee avotsiqui, iraniitantanaqueari voro. ");
INSERT INTO cniNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ari intanacaro meeca yoirincacotanaja. Yoijajeitanaqueri oshequi quemisantajeitatsiri, iveshireimentajeitanacari, icajemajeitanaque. Icantajeitanaque: —Tempa icameetsataque Tasorentsi. Aneajeitaqueri itasoncaventapinijeitaquee. ");
INSERT INTO cniNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Icameetsataque Avincatsarite itiancaqueeri Tasorentsi. Cameetsa isavicajeitaque maaroni inquitesati, ineacameetsajeitaqueri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ari itimaiti anta variseopee, icarajeitaqueri atiripee. Icantavetari Jesoshi: —Oametantatsiri, poimajerentajeiteri yora oijajeitimpiri. ");
INSERT INTO cniNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yacanaqueri: —¿Paita noimajerentanteariri? Ocameetsataque icantajeitaqueri. Irimajerejeiteme yocapee, irointi irineanatacaaqueme Tasorentsi mapipee ompincatsatantenameri. ");
INSERT INTO cniNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ari iquempejijeitapaaque, meeca oconijatapaaque Jerosare. Iraacojeitaqueri Jesoshi savicajeitatsiri, ");
INSERT INTO cniNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","icanti: —Nocoavetaca nosavicacaajeitempime cameetsa catsini, iro cantaincha te pincoajeiteji. Pitseencajeitaquena, meeca eiro pineanatsi nompincatsariventajeitempi. ");
INSERT INTO cniNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Coajica intime quisasanojeitempineri, inticasanojeitapaaquempi, irishoncajeitapaaquempi soraropee, eiro ishinejeitimpitsi pinquenanaje jaocarica. Irimanajeitempi, ");
INSERT INTO cniNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","intireajeitajero pivancopee, intireasanojeitajero catsini. Irovaaranteri savicajeitatsiri. Nopocashijeivetaquempi, nompincatsariventajeitempime, iro cantaincha te pimpincatsajeitavaquenaji, irointi pitseencajeitavaquena. Irootaque inquisajeitantempiri coajica soraropee. ");
INSERT INTO cniNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ari yareetapaaca Jesoshi ivancoqui Tasorentsi, yaajeitapaaqueri pimantayetatsiri aisati amanantayetatsiri, yojocajeitaqueri saiteriqui. Itsoncajeitaqueri maaroni, ");
INSERT INTO cniNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","icantaqueri: —Tempa osanquenataca irineane Tasorentsi: “Nocoaque inquenquetsatacaapinijeitena atiri aca novancoquica, irootaque novetsicacantantarori”. Iro cantaincha avirojeitaque amatavitantatsiri, pipeaquero pivanco avirori. ");
INSERT INTO cniNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Impoiji ipiapinita maaroni quitaiteri ivancoqui Tasorentsi, yoametantapinitaque. Iro cantaincha iquisajeitaqueri yora jivatacaajeitiriri saserotepee, yora oametantirori isanquenareni Moishishi, aisati yora pincatsariventajeitiriri savicajeitatsiri. Isampitavacaajeitaca: —¿Jaoca ancanteriri Jesoshi, avacantanteariri? ");
INSERT INTO cniNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Iro cantaincha te iriojeiteji jaoca incanteriri, tempa itimi oshequi atiri pincatsajeitiriri, quemisantajeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ari pashini quitaiteri itimi Jesoshi anta ivancoqui Tasorentsi yoamejeitaqueri atiripee, icamantaqueri jaoca incantajeiteari iroavisacotantajeari. Ari ipocajeitaque yora jivatacaajeitiriri saserotepee, yora oametantirori sanquenarentsi, yora jivatacaajeitantatsiri, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Icantajeitapaaqueri: —Pincamantajeitena janica peaquempiri pincatsari: ¿janica tiancaquempiri pantayetantarori oca? ");
INSERT INTO cniNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yacanaqueri: —Aisati narori, timatsi nosampijeitempiri. Pincamantajeitena: ");
INSERT INTO cniNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿janicampa tiancaqueriri Joa ivaotisatanti? ¿Iriompa Tasorentsi tiancaqueriri? Terica, ¿iriompa tianquiriri atiri? ");
INSERT INTO cniNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Te irancajeiteriji, irointi icantavacaajeitanaca: —¿Paita ancanteriri? Ancanteririca: “Irio Tasorentsi tianquiriri”, icantajeiteecari: “¿Paita caari piquemisantantari?” ");
INSERT INTO cniNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Irompa ancanteririca: “Irio atiri tiancaqueriri”, tempa inquisajeitaquee atiripee. Ipitseecari. Icantajeitaque iriori itiancaqueri Tasorentsi Joa ivaotisatanti. ");
INSERT INTO cniNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ari impoiji icantajeiti: —Te niojeiteji janicarica tiancaqueriri Joa. ");
INSERT INTO cniNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Irosati icantantari Jesoshi: —Aisati narori, eiro nocamantimpitsi janica tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Impoiji aisati iquenquetsatacaajeitiri Jesoshi atiri, jero oca ishiacantiniri: —Itimini panquitirori ova anta iipatsitequi. Impoiji icantaqueri iratirite: “Pamenenarorica, coajica ariorica oitsoquitanaque, paaqueyea avirori cashetani oitsoqui, cashetani pimpena narori”. Icantajeiti: “Ari cameetsa”. Impoiji ijatanaque pashiniqui quipatsi, peerani ipeaca. ");
INSERT INTO cniNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Impoiji omoncarataca irayetero oitsoqui. Yora ashitarori irovate itiancaque yora inampire: “Pijataite anta otiminta novate, picoacotaiteri yora amenanarori impaarantena cashetani”. Ari ijavetaca, iro cantaincha iquisajeitavaqueri, ipasanatavaqueri, yoipiavajiri. Tecatsi impavaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Impoiji itiancavetacari pashini inampire, iro cantaincha ishirontimentavacari, ipasanatavaqueri, yoipiavajiri. Tecatsi impavaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Impoiji itiancavetacari pashini aisati, iro cantaincha ipasanayetavaqueri, tac, tac, oshequi irirajanive. Yojocanajiri aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Iotantacari yora ashitarori, icanti: “¿Paita nanteri meeca? Irioyeata nontianqueri notomi nonintasanotiri. Ariorica irineajeitavaqueri irinti, impincatsatavaqueri”. Ari itiancavetacari iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ineantajeitavacariri, icantavacaajeitanaca: “Pamenerite itomi ashitarori iipatsite. Ariorica incame iriri, iriotaque ashitajearoneri. Tsame avavaqueri, impoiji ashijeitajearo ainti quipatsi”. ");
INSERT INTO cniNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ari yaajeitavaqueri, shepi. Yaajeitanaqueri anta ocaratapaaque iipatsite, yoajeitaqueri, shemi. Irootaque iquenquetsatacaajeitaqueriri Jesoshi. Impoiji isampijeitiri: —Aamaaca, ¿jaoca incanteriri yora ashitarori iipatsite? ");
INSERT INTO cniNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tempa irijate iriori, inquisasanojeitaqueri tsameevetanariri iipatsite, iroapaaqueri. Impoiji iramenaje pashini tsameetajenerine. Ari icantajeiti quemajeitaqueriri: —Te oncameetsateji irimajeitero oca, eiro ishinetiritsi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yamenajeitaqueri Jesoshi, icanti: —¿Pijivetacampa eiro imatirotsi? ¿Paitampa otimantacari oca sanquenarentsi? Tempa ocanti: “Itseencaquero yora vetsicavetarori pancotsi otincami, yojocajiro. Iro cantaincha ipeaquero Tasorentsi antearo otincami pancotsi”. ¿Paita oshiacantiri? ");
INSERT INTO cniNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Incarajaque maaroni pariatsiri mapiqui, ariorica ontsinacapaaqueri atiri oca mapi, ompeaqueri ovane quipatsi, ontsoncaqueri. Narotaque shiaquerori mapi: nompoyereajeitaqueri maaroni quisajeitaquenari. ");
INSERT INTO cniNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yora jivatacaajeitiriri saserotepee, aisati yora oametantirori Sanquenarentsi icoajeiveta irayerime meeca Jesoshi, tempa iojeitaque ishiacaventiri iriori. Irayerime, iro cantaincha itsaroacaajeitacari atiripee, icanti: “Eiro airitsi, iquisacoventaricari ashanincapee”. ");
INSERT INTO cniNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Impoiji itiancaqueri saserote ishaninca: —Meeca pijate pamatavitaiteri yora Jesoshi. Pishiacantamempeapeempa picoaque pinquemisanteri, iro cantaincha, pincomitacayeari irineane. Ariorica incomitanaquearo incanteri, pishintsite pimpoque pincamantapeena. Impoiji ancamanteri pincatsari icantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ari ijatashitaqueri Jesoshi, icantapaaqueri: —Oametanari, niojeitaque oqueariotasanotaque maaroni picantaquenari aisati maaroni poametaquenari. Te pamenashiteariji ashaninca piotanteari icameetsatirica, irointi piotasanotaqueri iquenqueshiretiri. Aisati cameetsa poamejeitaquenaro icoacaajeitaquenari Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Meeca pincamantena: ¿ocameetsatimpa ampajeiteri yora ivincatsarite oromasati airequite icoacotaqueeri? ¿Eirompa apiritsi? ");
INSERT INTO cniNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ari iotaqueri Jesoshi icoajeiveta iramataviterime. Icantiri: —¿Paitaquea picoantari pincomitacayenaro noneane? ");
INSERT INTO cniNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Poniajayenari iitsoqui piirequite. ¿Janica ishiavorotaqueri aca quirequiqui? ¿Janica ashitarori ivajiro isanquenataqueri? Yacanaqueri: —Iro ivoro ivincatsarite oromasati, aisati osanquenataca ivajiro: yora Sesari. ");
INSERT INTO cniNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ari icantiri Jesoshi: —Ocameetsataque pimpincatsateri yora Sesari, iro cantaincha ocameetsataque aisati pimpincatsatasanoteri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tecatsi icantajeitea incomitacayeari irineane Jesoshi, cameetsa yoametantasanotaque. Yoajeitanaqueri cavaco yora amataviterinemeri, irootaque imajerejeitantacari. Tecatsi incantajeri aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Impoiji ijatashitaqueri saroseo Jesoshi. Icantaque iriori saroseo eiro itinaajeitajatsi camayetatsiri, eiro ijajeititsi inquitequi. Ari icantapaaqueri: ");
INSERT INTO cniNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Oametanari, peerani isanquenataqueroni Moishishi. Icanti ariorica iraavetearo shirampari ijina, impoiji incamaque. Eirorica itimacairo ijananequite, cameetsataque iraajero irirentini. Impoiji intimerica otomi irishiacantajeri itomini irirentini. ");
INSERT INTO cniNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ariorica itimi shirampari irirenti 6. Yaavetaro ijina, impoiji icamaque. Te intimeji itomi. ");
INSERT INTO cniNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Impoiji yaavetajaro iriori irirentini. Aisati te intimacayeroji ijina itomi, impoiji icamaque iriori, toren. ");
INSERT INTO cniNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aisati iquempetaca pashini irirentini. Yaavetajaro tsinane, impoiji aisati icamaque. Aisati iquempejeitaca maaroni irirentini. Tecatsi timacayerone otomi. ");
INSERT INTO cniNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ari impoitanaque iroori tsinane, ocamaque. ");
INSERT INTO cniNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Meeca pincamantena: queariorica intinaajeitanaje maaroni camajeivetainchari, ¿janica jinantajearone oca tsinane? Tempa icarajeiveta aayevetaroniri 7. ");
INSERT INTO cniNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ari yacanaqueri Jesoshi: —Queario, aca quipatsiqui yamejeitacaro shirampari yairo ijina. Aisati tsinanepee aajeiti ojime. ");
INSERT INTO cniNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ari irointinaajeitajeri Tasorentsi maaroni atiri ineacameetsatiri, iro cantaincha anta inquitequi eiro yaajitsi ijina. Aisati tsinane, eiro aajitsi ojime. ");
INSERT INTO cniNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aisati eiro anta icamajitsi aisati, inquempejeiteari maaroni inampirepee Tasorentsi, saviquimojeitiriri: te incamajeiteji iriori. Icantani yaneajeiti. Aisati intomintasanojeiteari maaroni atiri yora irointinaajeitajeri. ");
INSERT INTO cniNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Peerani iotitani Moishishini intinaajeitanaje camayetatsiri. Iquenquetsatacotantarori totseequi otaavetaca, iquenquetsatacotiri aisati Avincatsarite. Icantini: “Iquemisantiri Avarama Tasorentsi. Aisati Isaca iquemisantaqueri, jeri aisati Jacovo”. ");
INSERT INTO cniNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pineaquero, te incanteji: “Iquemisantaveitarini Avaramani”. Yaneanaji Avarama aisati itsipapee, irootaque icantantacari: “Iquemisantiri”. ");
INSERT INTO cniNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Impoiji icantayetiri aparopee oametantirori sanquenarentsi: —Oametanari, cameetsa oca picantaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ari itsaroacaajeitacari irisampitajerime aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pashini aisati icantaqueri Jesoshi: —¿Paita picantajeitantari: “Iriotaque Quirishito ishanincani Iravirini”? ");
INSERT INTO cniNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tempa peerani ipampoyeaventirini Iravirini Tasorentsi, isanquenataquero oca: “Yora Tasorentsi, icantaqueri novincatsarite: ‘Notomi, pisavique aca nacosanoriqui, pincaratena ampicatsarijeite, ");
INSERT INTO cniNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","irosati impincatsajeitantempiri maaroni quisajeivetaquempiri’ ”. ");
INSERT INTO cniNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Iriompa Quirishito ishanincani Iravirini? Iriorica ishanincani, ¿paita icantantariri peerani: “Novincatsarite”? Te pamejeivetearoji pimpincatsajeiteri impoitatsiri itimi. ");
INSERT INTO cniNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Impoiji iquemajeitaqueri atiri Jesoshi, yoamejeitaqueri iroamerepee, icantaqueri: ");
INSERT INTO cniNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Paamayeariyea yora oametantajeitirori sanquenarentsi. Oshequi icoaque inquenaquenatsantsanayete. Icoaque aisati cameetsa iraacameetsajeitavaqueri ishaninca anta nampitsiqui. Aisati anta pancotsiqui apatojeitantapinitari, icoaque irisaviquimotapiniteri pincatsaripee. Aisati ariorica yampatojeita atiri yoajeita, icoaque quiso iroapiniteri pincatsaripee. ");
INSERT INTO cniNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Oshequi ishiacantanirota. Osamani iquenquetsatacaamempeacari Tasorentsi. Icoaque irijitashijeitanteariri ishaninca iquemisantasanoti. Iro cantaincha yamatavitapinitiro camajimentaaro, icoshitantarori timimojeivetarori. Queariotaque oca noncamantempiri: iroasanquetaasanojeitaqueri Tasorentsi, catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ari isavicaque Jesoshi anta ivancoqui Tasorentsi. Yamenayetavaqueri ashitaarantincari yamayetaqueri iirequite anta inantariqui quirequi. ");
INSERT INTO cniNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aisati ineaquero camajimentaaro amaqueri apite iitsoqui quirequi, caari pinatacha. ");
INSERT INTO cniNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Icanti: —Queario oca noncamantempiri: pitseenquitirocari yoca amaqueri oca camajimentaaro. Oshequi ineacameetsatitacaro Tasorentsi yoca amaqueri, anaacotaqueri yamajeivetacari yora ashitaarantincari. ");
INSERT INTO cniNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Oshequi ivinaro yamavetacari iriori, iro cantaincha itimaarantaque oshequi catsini iquempoyeanontavajari iriori. Irompa oca, amaqueri maaroni timimovetarori, te aneajeriji timaarantajantsine, tecatsi amanantantearori oyeari. ");
INSERT INTO cniNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ari iquenquetsatavacaajeitaca iroamerepee, icantajeiti: —Tempa ocameetsatasanotaque ivancoca Tasorentsi. Aisati maaroni mapipee yovetsicantacarori, ocameetsajeitaque, aisati maaroni yoaneencajeitantarori anta otantoqui. Iquemantajeitacariri, icantiri Jesoshi: ");
INSERT INTO cniNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Coajica intireetajero maaroni oca pineacameetsajeitiri meeca. Irojoqueetajero mapipeeca arejiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ari isampijeitaqueri: —¿Jaoca oncarate omoncaratanteari oca picantaquenari? Aisati, ¿paita iotacaayenaneri irotaintsi omoncaratea? ");
INSERT INTO cniNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Icantaqueri: —Paamayea, yamataviyeetimpicari. Impoque oshequi atiri cantempineri: “Naro nainti Quirishito”. Pashini incante: “Itiancaquena Quirishito noncamantempi irotaintsi impoque”. Iro cantaincha eiro piquemisantiritsi. ");
INSERT INTO cniNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pinquemapiniteri atiri incante irimanatavacaajeitea atiripee, aisati irojocajeiteri ivincatsarite. Iro cantaincha eiro pitsaroajeititsi. Aitaque incanteari inquisavacaapinijeitea, iro cantaincha tequera omoncarateaji. ");
INSERT INTO cniNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jero pashini icantaqueriri aisati: —Yora atiripee irimanayeteri itsipapee atiri. Yora savicayetatsiri aparopeequi nampitsi irimanateri yora savicayetsiri pashinipeequi nampitsi. ");
INSERT INTO cniNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aisati oshequi onicasanotanaquea quipatsi. Aajeiteri atiripee itashe, oshequi incamajeitanaque; aisati irojoquiijeitea itsipapee atiri, incamaarantayetanaque iriori. Aisati, anta inquitequi pineaquero caari pineapinijeiti, oshequi pintsaroacayearo. ");
INSERT INTO cniNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Aisati icantajeitiri: —Iro cantaincha irijivayeetempi inquisanayeetempi. Iraajeitanaquempi anta pancotsiqui yapatojeitantari, aisati iroiminqueayetempi caravosoqui. Iraajeitanaquempi aisati anta pincatsaripeequi, inquisatsajeitempi: “¿Paita piquemisantanirotantariri Quirishito?” ");
INSERT INTO cniNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Iro cantaincha eiro pitsaroacaaritsi yora quisavetempineri, irointi pincamantajeiteri jaoca nocanta noavisacojeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Eiro piquenqueshiretitsi: “Ariorica irayeetena, ¿paita noncanteriri?” ");
INSERT INTO cniNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ariorica iraanajempi noamejeitempi nainti paitarica pincanteriri. Eiro imatirotsi yora quishempineri impiatsatempi. ");
INSERT INTO cniNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Noncamantempi: iraacantempi piripee, piniropee, pirentipee, pitsiropee, pishanincapee, maaroni. Iroaarantempi aparopee. ");
INSERT INTO cniNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Iriojeitanaque atiri piquemisantaquena, irootaque inquisajeitantempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Iro cantaincha ariorica quiso poyena aisati pinquearioventenaro maaroni nocantajeitaquempiri, nonquempoyeasanojeitaquempi. Tecatsi catsini incantajeitempi yora quishempineri, eiro yaapitsatimpirotsi aparoni piishi. Aisati pincantaitatiyempani pintime inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aisati icanti Jesoshi: —Ariorica pineajeitavaqueri soraro irishoncajeitaquearo Jerosare, ari piojeitanaque irotaintsi intsoncajeitajero pinampi. ");
INSERT INTO cniNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ocameetsati irishiajeitanaque toncaariqui maaroni savicajeitatsineri. Aisati maaroni savicatsineri Joreaqui, irishiajeitanaque. Aisati yora jayetatsineri oantsipeequi, eiro ipiajeitanaja nampitsiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aitaque omoncarataquea maaroni oca isanquenatiniri peerani: “Iroasanquetaasanojeiteri Tasorentsi maaroni tseencajeitaqueriri”. ");
INSERT INTO cniNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ashinoncaajeitanaquea maaroni tsinane tsomonteyetatsineri, aisati maaroni antsotaayeterineri ojananequite. Oshequi irineacatsiyetearo yora savicajeitatsiri. Oshequi iroasanquetaajeiteri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Irimanajeiteri oshequi atiri, incamaarantayetanaque. Itsipapee iroisoyeteri, iraanajeri otsipapeequi quipatsi. Intime pashinipee atiri Jerosarequi peerani, irosati incantanteari Tasorentsi: “Moncarataca”. ");
INSERT INTO cniNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jeroca icantiriri aisati Jesoshi: —Pineajeitavaqueri impashinijeitanaque inquitesati: yora catsirincaiteri, cashiri, impoquiropee, maaroni. Pineero caari pineapinijeiti. Aisati intsaroajeitanaque maaroni atiri, inquemajeitavaquero oneajatanaque antearoja incajare, soooo. Aisati irineavaquero antearoja otavoncajare. Iramenajeitavaquero, sorererere. ");
INSERT INTO cniNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Eiro iojeititsi atiri jaocarica incanteeteriri, irootaque intsaroasanojeitantanaqueari catsini. Irishevayetanaquea impoquiro. ");
INSERT INTO cniNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Impoiji pineajeitavaquena, nompiaje aisati. Tempa noponeaca peerani inquitequi, natiritapaaque. Ariorica nompiaje aisati, nonquenapaaje mencoriqui, nontasorentsitasanotapaaque, nompincatsaritasanotapaaque. ");
INSERT INTO cniNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ariorica pineajeitavaquero oca nocantajeitaquempiri, piveshireajeitanaquea, pamenajeitavaquena: irotaintsi noavisacotasanojeitempi. ");
INSERT INTO cniNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Impoiji ishiacantiniri oca: —Ari pamenero iyera, jaoca ocantari. Terica iyera, ari pashini inchato pamenero. ");
INSERT INTO cniNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ariorica ontimayetanaje oshi, eereshitanaje, ari piojeitaque irootimatajantsi onquimojantsitaje. ");
INSERT INTO cniNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aisati oquempetaca, ariorica pineaquero omoncarataquea maaroni nocamantitanaquempiri, piojeitaque irotaintsi impincatsariventasanojeitempi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ariorica pineajeitavaquero intanaquea oca nocamantaquempiri, ari eirotsitarica picamitsi, aitaque pineajeitaquero omoncarataquea maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Coajica, peerani, ompeanaquea quipatsi aisati impeajeitanajea maaroni inquitequiniri: cashiri, catsirincaiteri, impoquiropee, maaroni. Iro cantaincha eiro opeimatatsi irointi noneane catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Aisati icantiri: —Paamaasanojeitajena: nomapocapaimpicari. Piquenqueshiretirocari caari cameetsatatsi. Pishinquijeitacari. Piquenqueshiretapinitirocari timajeitatsiri aca quipatsiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Aitaque nomapocapaaqueri maaroni savicajeitatsiri quipatsiqui. Iroashinoncaajeitea maaroni caari aamaventajeitachane. ");
INSERT INTO cniNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Paamaventea. Aisati pincanteri Tasorentsi iramitacotempi cameetsa pareejeitantajenari, eirota piquematsicatarotsi maaroni oca nocamantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ari maaroni quitaiteriqui yoametantaque Jesoshi anta ivancoqui Tasorentsi. Maaroni tsiteniriqui ijatapiniti anta toncaariqui ipajiyeetiri Orivomashi. ");
INSERT INTO cniNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aisati maaroni quitaiteriqui ijajeitamanaji atiripee ivancoqui Tasorentsi iquemisantapinijeitiri. ");
INSERT INTO cniNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Irotaintsi quitaiteri yoapinijeitantarori tanta caari iconoyeeti tapiacairori. Yapiitapinijeitiro joriopee maaroni osarintsi iquenqueshireantarori peerani anta Ejipitoqui yavisajeitanajiro oantatsiri ivancopee. ");
INSERT INTO cniNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ari yoametavacaajeitaca yora jivatacaajeitiriri saserotepee aisati yora oametantajeitirori sanquenarentsi: —¿Jaocasa ancanteriri Jesoshi avanteariri? Aamaaca ari inquisacotanaqueari atiripee. ");
INSERT INTO cniNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Impoiji yora Satanashi ishintsinataqueri Jorashi Ishicariote, yora yoamevetacari Jesoshi: yoametaqueri iraacanteri. ");
INSERT INTO cniNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ari ijatashitaqueri yora saserotepee, icantapaaqueri: —Namitacotempi paacanteri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Iquemantavacariri, iquimoshirejeitanaque, icantajeitavaqueri: —Ari, cameetsa. Ariorica ayeri, ari nompinatempi quirequi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Icanti: —Ari. Namenasanoteri, impoiji noncamantempi jaoca pincanteari pimanacanteariri paacanteri. Eiroquea ineajeitiritsi atiripee. ");
INSERT INTO cniNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ari moncarataca meeca vieshita. Meeca yoacaajeitacari atiripee ovisha, iquempetacari ishaninca peerani anta Ejipitoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ari Jesoshi itiancaqueri Petero aisati Joa, icantavaqueri: —Pijate povetsicajeitapee avajeiteari, anquenqueshirejeiterota yavisantanacari peerani oamaantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Isampitiri: —¿Jaoca picoaqueri novetsiquerori? ");
INSERT INTO cniNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yacanaqueri: —Ariorica pareetea nampitsiqui, pineapaaqueri shirampari yaacotanajiro nija. Poijatanaqueri anta pancotsiqui, jaocarica inqueapaajeri. ");
INSERT INTO cniNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pincantapaaqueri yora ashitarori ivanco: “Icanti Avincatsarite: ‘¿Jaoca noacayeariri noamerepee?’ ” ");
INSERT INTO cniNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ari ironijayempiro anta oshitamencotanta jenoqui. Ovetsicajeitaca asavicajeitanteari. Ari povetsicajeitero avirori avajeiteari. ");
INSERT INTO cniNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Irosati ijajeitantanaca, ineajeitapaaquero icantaqueriri Jesoshi. Yovetsicajeitapaaquero yoari. ");
INSERT INTO cniNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Impoiji yareejeitapaaca maaroni, yoajeitapaaca. ");
INSERT INTO cniNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Impoiji icantajeitaqueri Jesoshi: —Oshequi nocoitacani tequeratani noncame, nontsipajeitanajempita meeca tsiteniriquica noacaajeitanajempita tanta. ");
INSERT INTO cniNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Noncamantempi, eiro napiitajirotsi noajearo aisati aca quipatsiqui. Aintiquea noapaajearo anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ari yaaquero tsota, ipasonquitaqueri Iriri, impoiji icanti: —Paacojeitavaquero oca, pirajeitero. ");
INSERT INTO cniNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Noncamantempi: eiro nirajirotsi ovaja aca quipatsiquica. Aintiquea nirapaajero aisati anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Impoiji yaaquero tanta, ipasonquitiri Iriri. Icarajaquero, ipajeitaqueri iroamere, icantiri: —Jero oca tanta, poajeitearo. Narotaque camimentajeitempineri. Nocoaque poapinitearo tanta pinquenqueshiretapinitantenari nocamimentajeitaquempi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ari yoajeitaca, maaroni. Impoiji ipacojeitaqueri ovaja aisati. Icantajeitaqueri: —Ariorica pirero oca, nocoaque piojeite nocamantajeitaquempi noavisacojeitempi. Irootaque niraja amparajatimentajeitempineri, noncamimentajeitempi noavisacojeitantempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Impoiji icantajeitaqueri: —Timatsi acarajeitaqueri meeca avajeitaca yora aacantenaneri iroacantantenari. ");
INSERT INTO cniNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Noponeaca inquitequi, natiritapaaque noncamimentajeiteri maaroni atiri, iro cantaincha irashinoncaasanoitaquea yora aacantenaneri iroacantena. ");
INSERT INTO cniNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iquemantajeitacariri, isampitavacaajeitaca: —¿Janicampa aacantaniroterineri? ");
INSERT INTO cniNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ari anta icantavacaajeitanaca iroamerepee: —¿Janica coajica jivatacaajeiteeneri? ¿Janica anaacojeiteeneri impincatsaritasanote? ¿Naroitatsimpa jivatacaajeitajempine? ");
INSERT INTO cniNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ari icantiri Jesoshi: —Yamejeitaro yora atiripee ipincatsajeitaqueri ivincatsaritepee, iro cantaincha iperanatapinijeitacari pincatsari ishanincapee. Jero icantashijeitaca: “Nintacojeitacari natiritepee”. ");
INSERT INTO cniNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Iro cantaincha eiro piquempejeitaritsi. Ariorica picoaque pimpincatsariventante, eiro pishemetitsi, irointi pamitacotapiniteri itsipapee. ");
INSERT INTO cniNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Janica ipincatsatasanotiri atiri? ¿Yorampa vetsicapinitiniriri yoari? Teve. Tempa ipincatsayeetiri yora peranajeitariri inampirepee. Iro cantaincha te nomperanajeitempiji nainti, irointi nintacojeitaquempi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Quiso poajeitaquena peerani, piojeitaque opomerentsitimotapinijeitaquee. ");
INSERT INTO cniNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Irootaque nocantantimpiri meeca: oquempetaca incantena Apa nompincatsaritante, aisati noncantajeitempi pimpincatsarijeite. ");
INSERT INTO cniNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Pincaratapinijeitena avapinijeitea aisati irapinijeite anta nompincatsaritenta, aisati ampincatsariventajeiteri maaroni joriopee. ");
INSERT INTO cniNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Aisati icantiri Avincatsarite: —Shimo, yora Satanashi icantaqueri Tasorentsi icoaque irineantempi, iriotanteari piquemisantasanotirica. Queariompia, icoaque irantacayempiro caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Iro cantaincha noncanteri Tasorentsi iramitacotempi eiroquea pojocasanotantarotsi piquemisanti. Coajica, ariorica pinquenqueshirereempa aisati pinquemisantajena, pinquenqueshiretacaajeiteri maaroni piyemisantaririnte, pinquemisantacaasanojeiteri. ");
INSERT INTO cniNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yacanaqueri Shimo: —Tempa aviro novincatsarite, quiso noanaquempi; ariorica iroiminqueetempi, eiro nojoquimpitsi. Iroiminqueetenata narori. Ariorica iroyeetempi, nontsipatasanotanaquempi. Iroyeetenata narori. ");
INSERT INTO cniNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Icantaqueri: —Noncamantempi: meeca tsiteniriquica, eirotsitarica ineaji teapa, oncarate mava pincante: “Te noneeriji Jesoshi”. ");
INSERT INTO cniNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Impoiji icantajeitiri Jesoshi iroamerepee: —Peerani notiancajeitaquempi piquenquetsatacaajeitaqueri atiripee. Nocantajeitavaquempi: “Eiro paanajirotsi pitsarate, piirequite, aisati otsipa piitsaare”. Meeca nosampijeitempi: “¿Pashinoncaajeitanacampa? ¿Otimaquempa coiteimojeitaquempiri?” Yacajeitanaqueri: —Te. Tecatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Impoiji icantajeitaqueri: —Meeca noncantajeitempi: ontimerica pitsarate, paanajero. Intimerica piirequite, paanajeri. Terica ontime pivesamento, pimpimantero poicoro pamanantantearori aparoni. ");
INSERT INTO cniNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aitaque omoncarataquea isanquenatacotaquenaniri peerani Isayashini: “Iroyeeteri, inquempetacanteeteri oayeri”. Queario, ontsataajeitaquea maaroni isanquenatacotaquenaniri peerani yora quenquetsatacantantatsiniri. ");
INSERT INTO cniNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Impoiji icantajeitiri: —Jero oca, Novincatsarite: apite ocarati avesamento. Yacanaqueri: —Ari, moncarataca. ");
INSERT INTO cniNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Impoiji isoquijanaji Jesoshi, ijatanaji anta ijatapinitinta: anta toncaariqui pajitachari Orivomashi. Yoijajeitanaqueri iroamerepee. ");
INSERT INTO cniNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ari yareejeitapaaca, icantajeitaqueri: —Meeca pincantajeiteri Tasorentsi iramitacojeitantempiri: pantirocari caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Impoiji ari ijataque Jesoshi apaniro aiquetiji ara. Itiyeroapaaca, iquenquetsatacairi Iriri: ");
INSERT INTO cniNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Apa, pincoaquerica, poavisacotenaro oca nonquematsicataqueari. Iro cantaincha eiro pantirotsi nocoaqueri narori, irointi picoacaaquenari avirori. ");
INSERT INTO cniNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Impoiji ipocaque aparoni inampire Tasorentsi, intacotapaacari Jesoshi, ishintsitantacari. ");
INSERT INTO cniNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Oshequi iquematsicatacaro, aiquero ijatatii iquenquetsatacairi Iriri. Oshequi imasavitanaque, ovitejatanaque quipatsiqui, oquempevetaca iriraja. ");
INSERT INTO cniNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ari itsoncanaquero iquenquetsatacairi iriri, ijatanaji anta yoisavicanaquerinta iroamerepee, ineajeitapaatiiri maajeitaque ini. Oshequi yoashirejeitanaca incaranqui, irootaque imaojeitantacari. ");
INSERT INTO cniNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Icantajeitapairi: —¿Paita pimaajeitantacari? Pintinaajeitanaje. Pincantajeiteri Tasorentsi eiroquea pantantarotsi caari cameeetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ainiroquera iquenquetsatacaajeitiri Jesoshi iroamere, yareejeitapaaca oshequi atiri, ijivajeitapaaqueri Jorashi. Iroamere Jesoshi inaveta, iro cantaincha icoaque iraacantajeri meeca. Ijatashitaqueri, inintavoronirotapaaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Icantavaqueri: —Iro pinintavoronirotantanari, paacantena. Tempa piotaque naro poneainchari inquitequi, natiritapaaque. ");
INSERT INTO cniNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ari ineajeitavaqueri itsipajeitari Jesoshi. Isampijeitiri: —Novincatsarite, ¿picoaquempa nompesheri? ");
INSERT INTO cniNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ari ipeshitavaqueri iyempitasanori aparoni inampire yora ivincatsarite saserote, peti. ");
INSERT INTO cniNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Icantiri Jesoshi: —Ari inaji, eiro pantiritsi. Impoiji yoipiajiniri iyempita, yoavisacotajiri. ");
INSERT INTO cniNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Irio itsipajeitapaacari Jorashi yora jivatacaajeitiriri saserotepee, jeri aisati yora jivatacaantatsiri anta ivancoqui Tasorentsi, jeri aisati savicacaantajeitatsiri. Icantavaqueri Jesoshi: —¿Paita pamashitantanari pivesamentopee aisati inchaquipee? ¿Narompa coshinti? ");
INSERT INTO cniNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tempa nocaratapinijeitaquempi anta ivancoqui Tasorentsi, iro cantaincha te payenaji. Ja, moncarataca meeca paantaquenari: meeca ipincatsaritanti camaari. ");
INSERT INTO cniNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Impoiji yaasanotaqueri Jesoshi, shepi. Yaajeitanaqueri anta ivancoqui ivincatsarite saserote. Osamanitanaque Petero, yoijatacoventavetanacari. ");
INSERT INTO cniNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Anta pancotsiqui, ocaraiteti, yoisheetiro paamari. Isavicajeitapaaque, icotsitajeitapaaca yora aajeitaqueriri Jesoshi. Impoiji itsipajeitapaacari Petero. ");
INSERT INTO cniNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Impoiji aisati, opoqui aparoni inampire saserote. Ocatiapaaca, amenapaaqueri Petero, sorerere. Impoiji ocanti: —Jeri yoca oijatiriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Icanti: —Te nioteriji. ");
INSERT INTO cniNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Impoiji pashini amenaqueriri, icantiri: —Aviro oijatiriri Jesoshi. Icantiri: —Teve. Te noijateriji. ");
INSERT INTO cniNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ari osamanitapainti aisati, icantiri pashini: —Queario yoijavetacari yoca shirampari, tempa aisati iponeaca iriori Carireaqui. ");
INSERT INTO cniNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Icantiri: —Te nioteji paitarica picantaqueri. Irosati ineantanaca teapa. ");
INSERT INTO cniNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yora Jesoshi ipitsocashitanacari Petero, yamenanaqueri. Irosati iquenqueshiretantanacaro icantaqueriri incaranqui: “Tequeratsitarica irineaje teapa, mava pincante: ‘Te nioteriji Jesoshi’ ”. ");
INSERT INTO cniNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ari ijatanaque Petero, iraasanotanaca, jii, jii. Oshequi yoashiretanaca, catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yora shentajeitaqueriri Jesoshi ishirontimentajeitacari, aisati ipasanataqueri, tac, tac, tac. ");
INSERT INTO cniNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Impoiji ipashicajaquitaqueri aisati ipasavorotaqueri, icantaqueri: —Pincamantenate janica pasavorotaquempiri. Iji, iji, iji. ");
INSERT INTO cniNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Icantani, oshequi yoashinoncaaqueri, ishirontimentacari. ");
INSERT INTO cniNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ari meeca oquitaitetamanaji. Yapatojeitamanaja yora savicacantajeitatsiri, yora jivatacaajeitiriri saserotepee, yora oametantirori sanquenarentsi, maaroni. Yaajeitanaqueri Jesoshi anta yoametavacaapinijeitanta. ");
INSERT INTO cniNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Isampijeitaqueri: —Pincamantenate: ¿avirompa Quirishitotatsiri naamaajeitacari? Yacanaqueri: —Noncantempiricame: “Je, narotaque Quirishito”, eiro pishiretarotsi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aisati, nosampitempiricame paitapeerica, eiro pacanatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Noponeaca nainti inquitequi, natiritapaaque. Irotaintsi nompianaje jenoqui, nosaviquimotapaajeri Apa iracosanoriqui, noncaratapaajeri nontasoncantajeitaje. ");
INSERT INTO cniNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Isampijeitaqueri: —¿Avirompa Itomi Tasorentsi? Yacanaqueri: —Je, narotaque. ");
INSERT INTO cniNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Impoiji icanti: —¿Paita ancoanteari itsipa camantacoterineri? Tempa aquemajeitaqueri, ijitasorentsinirotacateemi. Ainiro yantane. ");
INSERT INTO cniNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ari ijajeitanaque, yaajeitanaqueri Jesoshi anta Piratoqui. Oromasati ini iriori, ipincatsariventajeitiri joriopee. ");
INSERT INTO cniNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Icantapaaqueri: —Ainiro yantanirotaqueri yoca. Yamatavijeitaqueri noshanincapee, icantajeivetacari: “Eiro pipiritsi pincatsari piirequite”. Aisati icantapiniti: “Narotaque Quirishito, pimpincatsajeitena nainti”. ");
INSERT INTO cniNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ari isampitiri Pirato: —¿Queariompa? ¿Avirompa ivicatsarite jorio? Yacanaqueri: —Je, narotaque. ");
INSERT INTO cniNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Impoiji yora Pirato icantajeitavaqueri: —Te aneroji irantane yoca. ");
INSERT INTO cniNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aiquero icantajeiti: —Iquisacaajeitacari atiripee, icantajeitaqueri atiri: “Tsame ajocajeri avincatsarite”. Intanacaro anta Carireaqui, meeca iquenaquenayeti aca Joreaqui, yamatavijeitaqueri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Iquemantacarori Pirato icantajeitaqueriri, isampitaqueri: —¿Iriompa carireasati yoca? ");
INSERT INTO cniNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yacanaqueri: —Je, iriotaque. Icantiri: —Ari, paanajeri anta Eroreshiqui. Iriotaque pincatsariventajeitiriri carireasati. Savicatsi meeca aca Jerosarequi. Ipoqui chapinqui. ");
INSERT INTO cniNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ari yaajeitanajiri anta. Ineantavacariri Eroreshi Jesoshi, iquimoshiretanaque. Oshequi iquemacotapinitaqueri, itasoncantayetaque, irootaque icoantavetacaniri irineeri. Icoaveta irineerime intasoncantayeteme. ");
INSERT INTO cniNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Oshequi isampiyevetacari paitapeerica, iro cantaincha te iranqueriji Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Oshequi yapiitapinitiniri yora amaqueriri: —Te incameetsateji. Ainiro irantane. ");
INSERT INTO cniNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Impoiji ishirontimentajeitacari Jesoshi yora Eroreshi aisati maaroni soraropee. Impoiji iquitsaataqueri cameetsari quitsaarentsi, ishiacantamempeacari pincatsari, irishirontimentajeitanteariri aisati. Impoiji itianquiri aisati anta Piratoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ari peerani iquisavacaapinita Eroreshi aisati Pirato, iro cantaincha meeca intanacaro yaacameetsatavacaaja. Yojocajiro iquisavacaaveitani. ");
INSERT INTO cniNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Impoiji yapatojeitacari Pirato yora jivatacaajeitiriri saserotepee, pincatsaripee, aisati oshequi atiripee pashini. ");
INSERT INTO cniNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ari icantavaqueri: —Pamene, incaranqui pamavetaquenari yoca, picantajeivetaquena yoamejeitaqueri atiri irojocajeitena narori, aisati iriori novincatsaririntepee. Pineajeitaquena nosampitaqueri paitaricapee, iro cantaincha noneacameetsatiri: te aneeroji irantane. ");
INSERT INTO cniNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aisati iriori Eroreshi, ineacameetsataqueri, irootaque yoipiantacariri aca. Pineaquero, tecatsi irante noacantanteariri. ");
INSERT INTO cniNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Meeca nompasatacanteri, impoiji noimpacajeri. ");
INSERT INTO cniNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ari maaroni osarintsi ariorica omoncarataca oca vieshita iquenqueshiretantarori yavisantaniri peerani inampire Tasorentsi, yora oantatsiri, yora Pirato yoipacajiri aparoni shirampari yoiminqueetaqueri. ");
INSERT INTO cniNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ari itsipatavacaajeitaca icantajeitaqueri: —Poacanteri yoca, irinti Varavashi poimpacajeri. ");
INSERT INTO cniNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ari yora Varavashi peerani icantajeitaqueri ishaninca anta Jerosarequi: “Tsame ajocajeri yora pincatsari”. Impoiji yoaqueri ishaninca, irootaque yoiminqueantacariri caravosoqui. ");
INSERT INTO cniNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Icoaveta Pirato iroimpacajerime Jesoshi, irootaque icoantavetacari iroimajerentajerime atiripee, iro cantaincha ");
INSERT INTO cniNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","aiquero icantajeitanajatiiri: —Pimpajacotacanteri. Pimpajacotacanteri. ");
INSERT INTO cniNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yapiivetajari aisati Pirato: —¿Paita nompajacotacantanteariri? ¿Paita yantaqueri? Nosampijeivetaquempi, iro cantaincha tecatsi piotacaasanotena noacantanteariri. Nompasanatacanteri, impoiji noimpacajeri. ");
INSERT INTO cniNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Icantani icajemajeitanaque: —Pimpajacotacanterive. Pimpajacotacanterive. Aiquero icantanaitii, irosati iquemisantantacariri Pirato, ");
INSERT INTO cniNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","icantiri: —Ari nomajeitempiro oca picoacaajeitaquenari. ");
INSERT INTO cniNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yoipacaacantajiri Varavashi, aisati icantajeitaqueri: —Paajeitanaqueriqueti Jesoshica, jaocarica pincanteriri. ");
INSERT INTO cniNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ari yaajeitanaqueri Jesoshi anta impajacoterinta, iquenanaque avotsiqui. Jeri itonquiojeitavacari shirenesati pajitachari Shimo. Iponeanaca oantsiqui. Ari iperanatavacari soraro yanatanaqueneri Jesoshi coroshi, ora impajacotanteariri. Yoijatapairi itapiiqui Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yoijajeitanaqueri oshequi atiri. Otimi aisati oshequi tsinane iraacojeitaqueriri. Oshequi oashiretacotacari, irootaque ocajemacojeitantacariri aisati. Jerosaresato onajeiti. ");
INSERT INTO cniNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iro cantaincha yamenanaquero Jesoshi, icantajeitanaquero: —Eiro piracojeitanatsi, avisati iracojeitajanchane, aisati piracojeiteri pitomipee. ");
INSERT INTO cniNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Coajica ompomerentsitimojeitempi, pashinoncaajeitanaquea. Pincantajeite: “Oquimoshiretaque caari timatsi otomi”. ");
INSERT INTO cniNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Incoajeivetea atiri ontijerime imperita. ");
INSERT INTO cniNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pamene, tecatsi nanteni nainti, iro cantaincha iroashinoncayena. Tempa coajica irashinoncaasanotaquea maaroni antirori caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aisati anta yaayeetanajiri apite coshitantatsiri, intsipajeiteari iriori Jesoshi, impajacojeiteri. ");
INSERT INTO cniNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ari yareetacaajeitapaacari anta Caraveraqui, ipajacojeitapaaqueri coroshiqui, tac, tac, tac. Irinti yora coshitantatsiri, ipajacotaqueri pashiniqui coroshi anta iracosanoriqui Jesoshi. Irio itsipa ipajacotaqueri anta irampatequi. ");
INSERT INTO cniNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Impoiji iquenquetsatacairi Jesoshi iriri: —Apa, pincavintsayeri yocapee, eiro poasanquetaimentiritsi yoaquena. Te irioteji paitarica yantiri. Ari icoajeitaque soraropee iraajeitero iitsaareni Jesoshi. Icanti: —Tsame ampishonquero mapijaniqui ayojeitanteari janicarica aitajerine iitsaareni. Icanti itsipa: —Jaa, jentsiqueti, aneantearo. ");
INSERT INTO cniNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ari itimi anta oshequi atiri, amenajeitaqueriri, aisati itimi yora pincatsaripee, ishirontimentajeitacari Jesoshi, iji, iji, iji; icanti: —Yoavisacovetacari itsipapee, jentsite amenavaquerita ariorica irimatajea iroavisacotajea irisati. Iriotasanotaquerica Quirishito, itiancane Tasorentsi, ari irimatajea irisati iroavisacotajea. ");
INSERT INTO cniNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aisati iriori soraropee, ishirontimentajeitacari. Ijatashitaqueri, imperime ovaja, quepishijari. ");
INSERT INTO cniNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Icantaqueri: —Avirorica ivincatsarite jorio, jentsite poavisacotajea avisati: iji, iji, iji. ");
INSERT INTO cniNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ainiro ipajacoyeetaquero anta coroshiqui sanquenarentsi, otimi iitoqui Jesoshi, jenioquiji. Osanquenataca irineanequi quereshiasati, aisati irineanequi oromasati, aisati irineanequi jorio. Osanquenataca, ocanti: “Jeri yoca ivincatsarite jorio”. ");
INSERT INTO cniNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aisati yora coshitantatsiri ipajacoyeetaqueri, ishirontimentacari iriori. —Avirorica Quirishito, poavisacotajea avisati, aisati poavisacotena narori. ");
INSERT INTO cniNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Iro cantaincha iquisatsataqueri itsipa coshitantatsiri: —Tempa pimpincatsateri Tasorentsi. Aisati avirori, irotaintsi pincame. ");
INSERT INTO cniNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ainiro antanepee arori ancamajeitanteari, irintiquea yoca, tecatsi irante incamanteari. ");
INSERT INTO cniNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aisati icantiri: —Jesoshi, ariorica pareetea anta pimpincatsaritenta, pinquenqueshiretapeena narori, poavisacotena. ");
INSERT INTO cniNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yacanaqueri: —Queario oca noncantempiri: meeca quitaiteri pintsipatanaquena anta ocameetsaitetinta. ");
INSERT INTO cniNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Itampaticatapaaque meeca catsirincaiteri. Omapocashitanaca antearo otsitenitanaque. Ari otsitenitanaque irosati ishaaviniji. ");
INSERT INTO cniNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Aisati itsitenitanaque catsirincaiteri. Aisati otimi anta ivancoqui Tasorentsi oticaashiro nianqui. Ari omapocashitanaca, otsereanaque, tsererere, tsati; apitemaotanaque. Impoiji antearojenca icantanaque Jesoshi: ");
INSERT INTO cniNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","—Apa, meeca noncame. Aviro quempoyeajenaneri. Irosati icamantanaca, toren. ");
INSERT INTO cniNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ineantavacariri iyapitanote soraro, icanti: —Tempa icameetsataque Tasorentsi. Queario icameetsatasanotini yoca shiramparini. Te ontimeniji irantane. ");
INSERT INTO cniNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aisati yora amenajeitiriri, iquenqueshirejeitanaca maaroni. Ipiajeitanaja nampitsiqui, yoashirejeitanaca catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Irintiquea yora iojeitiriniri Jesoshi, icatiajeitaca ara aiquetiji, yamenajeitanaque. Ocarajeitiri oca tsinanepee poneachari Carireaqui, tsipatapaacariri chapinqui Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ari itimi anta cameetsari shirampari, pajitachari Jose, arimateasati. Otimi Arimatea anta Joreaqui. Ari icarajeitaqueri Jose yora itsipapee pincatsariyetatsiri, yoametavacaapinijeita, iro cantaincha te incoaveteaji irinti impajacotacanteri Jesoshi. Ipincatsataqueri irinti Tasorentsi, yaamaajeitacari impoque impincatsariventajeiteri maaroni atiri. ");
INSERT INTO cniNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ari ijataque iriori, yameniri Pirato, icantaqueri: —Nocoaque pishinetenari Jesoshini, naanajeri. Icantiri: —Ari, pijatequeti, paanajeri. ");
INSERT INTO cniNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Impoiji yoaniireajiri, yapinaicacotaqueri tocoyaqui, cameetsamaotatsiri. Yaanajiri anta oninta mapi, ora iroaquera imoqueeti, yominqueapaaqueri tsompoinaqui. Tecatsi itsipa iroyeete anta omoroquinta. ");
INSERT INTO cniNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tempa irootaque Viereneshi icamantacari Jesoshi. Yovetsicajeitaquero atiri paitapeerica, tempa irotaintsi saavaro imaoreajeitantari. ");
INSERT INTO cniNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ora tsinanepee oijatacojeitiri Jesoshi, amenacojeitaqueri yaajeitanaqueri omoroqui, anta yoajeitaqueri tsompoina. ");
INSERT INTO cniNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Impoiji opiajeitanaja anta ovancoqui. Ovetsicapaaquero casancajari aisati pashini casancatatsiri. Impoiji saavaro omaoreajeitanaque, omoncarataquero isanquenare Moishishi. ");
INSERT INTO cniNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ari otomincotamanaji, tsiteniquera ojatamanaque tsinane anta yoyeetaquerinta Jesoshi. Aanaquero casancajari ovetsicaqueri. Oijatanaquero otsipapee tsinane. ");
INSERT INTO cniNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ari yoyeetaqueri chapinqui omoroqui antearo mapi, itsinacacoyeetanaqueri omoroqui. Iro cantaincha areevetapaacaro oneapaatiiro tivironcaja oni. ");
INSERT INTO cniNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Oqueashivetapaacari Jesoshi omoroqui, iro cantaincha te oneapeeriji Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Te iojeiteji paitarica onquenqueshirejeiteri. Impoiji imapocashitapaacaro apite shirampari, icatiimotapaacaro quempeji. Oshipaquireamaotanaque iitsaare. ");
INSERT INTO cniNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Oshequi otsaroacaavacari, oivotasanotanaca. Isampitapaaquero: —¿Paita picoantariri aneatsiri aca? Aca yoyeetapinitiri camasanoyetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Te aneajeriji Jesoshi aca, tempa tinaanaja ini. Pinquenqueshiretero icamantitaquempiri anta Carireaqui. ");
INSERT INTO cniNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tempa icamantitaquempi: “Noponeaca inquitequi, natiritapaaque. Coajica irayena caari quemisantatsi, impajacotena coroshiqui. Oncarate mava quitaiteri ari nontinaanaje aisati”. Meeca omoncarataca icamantitaquempiniri. ");
INSERT INTO cniNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Impoiji oquenqueshiretasanotaquero icamantitacaroniri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Opianaja nampitsiqui, ocamantapaaqueri iroamerepee aisati itsipapee quemisantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Opajita oca tsinanepee Maria ora maquitarasato, Joana, Maria iriniro Santiaco; aisati otimi otsipapee tsinane. ");
INSERT INTO cniNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Iro cantaincha te irishiretearoji yora quemisantatsiri oca ocamantavetapaacariri, ijitashijeiveta te ioteji. ");
INSERT INTO cniNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Iro cantaincha iriori Petero ishianaca anta omoroqui yoajeivetacarinta chapinqui Jesoshi. Yamenapaaquero tsompoina, ineapaaquero tocoya yapinaicacotantavetacariri. Impoiji ipianaja pancotsiqui, oshequi iquenqueshiretanaca. ");
INSERT INTO cniNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Impoiji ijatanaque apite iroamere Jesoshi anta Emaoshiqui. Ariorica imponeaquea Jerosarequi, ocarati 11 quirometoro irareetanteari nampitsiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ari iquenanaque, iquenquetsatavacaajeitaca. Iquenquetsatacotaqueri jaoca icanteetiri Jesoshi, aisati maaroni yantayetiri iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ari iquenanaque, icantavacaanaca, irosati itsipajeitantacari Jesoshi, quiso yoanaqueri anta avotsiqui. ");
INSERT INTO cniNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ineajeivetacari, iro cantaincha te irishineteriji Tasorentsi iriojeitajeri. ");
INSERT INTO cniNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ari isampitiri Jesoshi: —Incaranqui, piquenantacari avotsiqui, ¿paita picantavacaimentacari? ¿Paita poashirejeitantacari? ");
INSERT INTO cniNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ari ipajita aparoni Quereojashi, yacanaqueri iriori: —Iojeitaque maaroni jerosaresati: ¿paita caari piotanta avirori? ");
INSERT INTO cniNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Isampitiri: —¿Paitaquea? Yacanaqueri: —¿Tempa pinquemacoteri Jesoshini, yora nasaretesati? Iquenquetsatacaapinijeitanaroni irineane Tasorentsi aisati oshequi itasoncantapiniyetini. Ineacameetsataqueri Tasorentsi aisati noneacameetsajeitaqueri narori. ");
INSERT INTO cniNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yaajeitaqueri yora jivatacaajeitiriri saserote aisati avincatsaritepee. Icantajeiti te incameetsateji, ipajacotacantaqueri, icamaque toren. ");
INSERT INTO cniNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nojijeivetaca irio oavisacojeiteenemeri, pincatsariventajeiteenemeri. Meeca ocarataque mava quitaiteri icamantacari. ");
INSERT INTO cniNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ocarajeitaquena aparopee tsinane jatamanatsiri incaranqui anta noavetacarinta. Opiaja, omapocapaaquena, ");
INSERT INTO cniNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ocamantapaaquena: “Te noneapaajeriji Jesoshini, te aneajeriji. Irintiquea noneapaaque inampirepee Tasorentsi, icantaquena iriori: ‘Tinaanaja Jesoshi’ ”. Irootaque ocantaquenari. ");
INSERT INTO cniNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Impoiji ishiayetanaca aparopee anta, ineaquero ocantaquenari tsinanepee: irintiquea Jesoshi, te irineeriji. ");
INSERT INTO cniNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Impoiji icantaqueri Jesoshi: —Te aneajeroji piojeitantari, pitseencaqueri yora quenquetsatirori irineane Tasorentsi. Te pinquemisantajeiteriji. ");
INSERT INTO cniNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tempa icantajeiti irijivate Quirishito inquematsicataquearo maaroni oca, impoijiquea impincatsaritasanotanaque. ");
INSERT INTO cniNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ari yoametasanojeitanaqueri Sanquenarentsi, itsoteaquero maaroni quenquetsatacotiriri iriori. Ijivataqueneri isanquenare Moishishini, impoiji yoamejeitiri isanquenare itsipapee quenquetsatacantajeitatsiniri. ");
INSERT INTO cniNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ari yareejeitapaaca nampitsiqui, iravisanajeme Jesoshi, ");
INSERT INTO cniNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","iro cantaincha icantaqueri itsipapee: —Eirota pijatita, pisavicapee novancoqui. Ishaavijiiteanaji, irotaintsi ontsitenijencaitete. Ari ijatapainti ivancoqui iriori. ");
INSERT INTO cniNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Impoiji itsipatavacaajeitaca, yoajeitaca. Impoiji yaaquero Jesoshi tanta, ipasonquitiri Tasorentsi, impoiji ipajeitaqueri itsipapee. ");
INSERT INTO cniNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Irosati iquenqueshireantanaja, iojeitavajiri. Impoiji imapocanaja Jesoshi, ipeanaja. ");
INSERT INTO cniNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Icantavacaajeitanaca: —Tempa ocameetsatasanotaque icantaqueeri anta avotsiqui. Oshequi aquenqueshiretaquero, aquimoshireventasanotaquero. ");
INSERT INTO cniNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Irosati ijajeitantanaja, ipiajeitanaja Jerosarequi. Ineapaaqueri yora iroamereni Jesoshi, icarataji 11, itsipajeitacari itsipapee quemisantatsiri, yapatojeitaca. ");
INSERT INTO cniNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Icantajeitavaqueri yora savicajeitatsiri: —Quearioteemi: itinaasanotanaja Avincatsarite. Ineaqueri Shimo. ");
INSERT INTO cniNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Irosati icamantantapaacari: —Aisati narori, noneajeitaqueri anta avotsiqui, cameetsa catsini yoametaquena, iro cantaincha te nioveteariji. Impoiji anta novancoqui icarajaquero tanta, ipaquenaro, irosati niotantajari. ");
INSERT INTO cniNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ari ainirojeitatsi iriori anta pancotsiqui, iquenquetsatavacaajeitaca, irosati imapocantapaajari Jesoshi, icatiimojeitapaajari nianqui. Icantapaajiri: —Pinquimoshirejeitanaque, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yoajeitanaqueri cavaco, te iriojeitavaqueriji, ijitashijeivetavacari camaari. Itsaroajeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Isampitapaaqueri: —¿Paita pitsaroacantanari? ¿Paita pitseencajeitantanari? ");
INSERT INTO cniNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pamenajeitero naco aisati noiti oqueanaquena quiravo. Narotaque pocajantsiri. Jentsite, pimpamijeitena piojeitantenari. Pineaquena, otimi novatsa aisati notonqui, te nonquempeteariji camaari. ");
INSERT INTO cniNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Irosati yonijantajeitacari iraco aisati iiti. ");
INSERT INTO cniNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Iro cantaincha tequera irishiretasanoteari itinaanaja. Iquimoshirejeivetaca, iro cantaincha itseencashirejeitaque. Icantiri Jesoshi: —¿Timatsimpa avajeiteari? ");
INSERT INTO cniNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ari ipavaqueri shima shincorentsi, ");
INSERT INTO cniNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","yoacari. Iriorijei yamenashejeitaqueri, sorerere. ");
INSERT INTO cniNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Impoiji icantajeitaqueri: —Tempa chapinqui nocamantaquempi: “Oshequi nonquematsicataquearo, iroyeetena. Aitaque omoncarataquea maaroni isanquenatacotitaquenaniri Moishishini, aisati yora quenquetsatacaantatsiniri, aisati yora pampoyeaventajeitiriniri Tasorentsi”. Meeca moncarataca. ");
INSERT INTO cniNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Impoiji yoametasanojeitaqueri ocantayetiri Sanquenarentsi, ");
INSERT INTO cniNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","icantajeitaqueri: —Tempa ocanti Sanquenarentsi: “Incamaque Quirishito, oncarate mava quitaiteri ari intinaanaje aisati. ");
INSERT INTO cniNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Inquenquetsatacoyeeteri maaroni quipatsipeequi, irijivate aca Jerosarequi: inquemacojeitaqueri maaroni atiri. Incamantajeiteri atiri: ‘Pinquenqueshirejeitanaquea, pojocajeitajero caari cameetsatatsi pantajeitiri. Paventeari Tasorentsi iroavisacotantempiri’ ”. ");
INSERT INTO cniNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ari pineajeitaquero meeca omoncarataca isanquenatacotitaquenaniri peerani. ");
INSERT INTO cniNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Meeca nontianquempiro icashiacaaquempiri Apa: ompocashitempi Ishire, quiso oajeitantempiri. Pisavicavaqueta aca nampitsiqui irosati ompocanteari. Impoiji irimatacaajeitempi Tasorentsi pantajeitantearori paitapeerica incoacaayempiri. ");
INSERT INTO cniNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Impoiji yora Jesoshi yaajeitanaqueri iroamerepee anta Vetaniaqui. Ari anta nianqui, yacotanaque Jesoshi, iquenquetsatacairi iriri, icantiri: —Apa, jeri yoca noamereca: pintasoncaventajeiteri, poveshireacaajeiteari. ");
INSERT INTO cniNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Irosati yovancantanaja inquitequi, ipeanaja. ");
INSERT INTO cniNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Oshequi ipincatsajeitaqueri, impoiji ipiajeitanaja Jerosarequi, iquimoshirejeitanaque catsini. ");
INSERT INTO cniNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ijatapinitaque anta ivancoqui Tasorentsi icantapinijeitaque: —Tempa icameetsataque Tasorentsi. Ari ocarati. Narotaque sanquenatirori: Irocashi");
INSERT INTO cniNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Iriotaque Quirishito intasanotarori itimi: irio Ashitarori Irineane oamejeitaqueeri. Itsipatarini Tasorentsi, tempa Tasorentsi ini iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Itsipatarini peerani iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iriotaque vetsicajeitirori maaroni, paitaricapee. Tecatsi imashiyetachane: eirome itimime eiro ovetsicayetame timayetaintsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iriotaque oaneajeitaqueeri, quitaitetacojeitaqueeri: tempa iotacaajeitaquee jaoca icantari Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Peerani te ayojeiveitearini, oquempetimoveiteeni atimini tsiteniriqui; impoiji ipocapaaque, iotacaajeitapaaquee, meeca oquempetimotaquee iquitaitetacojeitaquee. Meeca eiro atimajitsi aisati tsiteniriqui. ");
INSERT INTO cniNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ari itimaveitani aparoni shirampari pajitachari Joa, itiancane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","8","Iquenayetanaque, icamantacoyetapaaqueri yora quitaitetacojeitaqueeri, iquemisantajeitantariri maaroni atiri. Yora Joa caari ini quitaitetacotantatsi, irointiquea ineaqueri aisati iquenquetsatacotaqueri. Irootaque itiancantacariri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ari impoiji ipocapaaque aca quipatsiqui yora quitaitetacotasanotantatsiri irinti, iotacaajeitaquee arori, aisati iriori maaroni savicajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ari itimapaaque quipatsiqui, oca yovetsicaqueri peerani, iro cantaincha te iriojeitavaqueriji atiri, yora yovetsicajeivetacari. ");
INSERT INTO cniNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ipocavetapaaca inampiqui, ishanincavetapaacari joriopee, iro cantaincha te iraacameetsajeitavaqueriji. ");
INSERT INTO cniNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Irintiquea aacameetsatavaqueriri, yora quemisantajeitavaqueriri: itasoncacoventajeitaqueri, ipeajeitajiri itomi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Iriotaque Tasorentsi tomintajeitaqueeri arori, aisati maaroni quemisantajeitiriri iriori. Te inquempeteariji ashijeitaqueeri aca quipatsiquica, itimacaajeitiro irinti ijina itomi. Aisati tecatsi ancantajeite arori: “Nompeajeata nainti itomi Tasorentsi”, eiro amatirotsi. Tempa icoashita irinti, irootaque itomintajeitantaqueeri, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tempa Tasorentsi ini yora Ashitarori Irineane: iponeanaca inquitequi, yatiritapaaque, itimimojeitapaaquee aca quipatsiqui. Yashi yoiro ineshinoncajeitaquee, queariotasanotaque oca yoamejeitaqueeri. Noneajeitavaqueri narori ipincatsaritasanotaque, iquempetacari Tasorentsi; tempa iriotaque itomi irapintite. ");
INSERT INTO cniNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yora Joa icamantacotaqueri Quirishito, icantajeitaqueri atiri: —Jeri yoca nocamantacotaqueri chapinqui: “Yanaacotaquena impoitapeenaneri, ipincatsaritasanoti irinti. Te nompincatsariteji narori. Tequerani nontimeni narori, itimitani irinti”. ");
INSERT INTO cniNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yashi yoiro ineshinoncatantaque Quirishito, irootaque ineshinoncatanteeri arori. Aiquero ijatatii ineshinoncajeitaquee. ");
INSERT INTO cniNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Peerani yora Moishishini, isanquenatironi oca peranajeitaqueeri; irintiquea Quirishito ineshinoncajeitaquee, queariotasanotaque maaroni yoamejeitaqueeri. ");
INSERT INTO cniNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tecatsi atiri neerine Tasorentsi, apaniro irinti ineiri itomi irapintite. Iquempetacari iriri, tempa quiso yoitarini, irootaque iotantacariri: meeca yoamejeitaquee jaoca icantari. ");
INSERT INTO cniNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yora joriopee jerosaresati itiancayetaqueri saserotepee, jeri ishanincapeeni Irevi. Itiancaqueneri Joa, ari ijataque. Isampitapaaqueri: —¿Janicampimpa? ¿Avirompa Quirishito naamaajeivetacari? ");
INSERT INTO cniNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ari te irimanacoteaji. Icamantasanotavaqueri: —Caarina noni Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yapiitajiri: —¿Queariompa? ¿Avirompa Iriashini? —Caarina. —¿Avirompa camantantatsineri naamaajeitacari? —Caarina. ");
INSERT INTO cniNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Isampitajiri aisati: —¿Janicampimpa? ¿Paitampa noncamantapeeriri tiancaquenari? ¿Paita pantiri? ");
INSERT INTO cniNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Icantiri: —Narotaque iquenquetsatacotiniri peerani Isayashini, tempa isanquenatini: “Coajica impoque camantantatsineri, inquenquetsatapinite anta caaraiteriqui, incante: ‘Pinquenqueshireempa, pinquemisanteri Avincatsarite iroameetsatantempiri’ ”. ");
INSERT INTO cniNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ari isampitaqueri: —¿Queariompa? ¿Caarimpimpa Quirishito? ¿Caarimpimpa Iriashini? ¿Caarimpimpa yora camantantatsineri naamaajeitacari impoque? ¿Paitampa pivaotisatantariri ashanincapee? ");
INSERT INTO cniNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yacanaqueri Joa: —Iro novaotisatantariri nija. Timatsi meeca pashini shirampari caari piojeiti. ");
INSERT INTO cniNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iriotaque impoitapeenaneri, pincatsaritasanotatsiri ini. Oshequi nopincatsataqueri, te nompincatsateji narori. ");
INSERT INTO cniNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Aitaque icantapinita Joa anta Vetaniaqui. Otimi Vetania intatiqueronta Jorirani. Anta ivaotisatantapinitinta. ");
INSERT INTO cniNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Otsipani quitaiteri yamenanaque Joa, ineavaqueri Jesoshi, ipocapaaque. Icantiri atiripee: —Jeritapaaque ovishatatsiri itiancaqueeneri Tasorentsi. Iriotaque oavisacojeiterineri maaroni atiri caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iriotaque noquenquetsatacotaqueri chapinqui: “Yanaacotaquena impoitapeenaneri, ipincatsaritasanoti irinti. Te nompincatsariteji nainti. Tequerani nontimeni narori, itimitani irinti”. ");
INSERT INTO cniNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Te niovetearini narori, iro cantaincha meeca icoaque Tasorentsi iriojeiteri maaroni ajorioririnte. Irootaque nopocantacari narori novaotisatantayeti. ");
INSERT INTO cniNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Icamantantaji Joa aisati: —Te niovetearini narori. Iro cantaincha itiancaquena Tasorentsi, icantaquena: “Pivaotisatapiniteri pishaninca nijaqui, poamejeiteri inquenqueshirejeitanaquea. Coajica pineavaquero aniireapee noshire. Janicarica aatapaaqueri, iriotaque yora pajeiterineri atiripee noshire”. Ari impoiji noneavaquero aniireapaaque Ishire Tasorentsi, oponeanaca inquitequi. Oshiavetapaacari sampaquiti: aatapaaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Queario noneasanotaquero. Irootaque nocamantacotantacariri: “Iriotaque Itomi Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Oquitaitetamani icatiaja Joa aisati ara, itsipatacari iroamere apite. ");
INSERT INTO cniNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ipampoyeaqueri Jesoshi yaniiti anta avotsiqui. Icanti: —Jeri yonta ovishatatsiri itiancaqueeri Tasorentsi, iriotaque camimentajeiteeneri oameetsajeitajeeneri. ");
INSERT INTO cniNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Iquemantavacariri iroamere apite, yoijajeitanaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ipitsocashitanacari iriori, ineavaqueri yoijatapaaqueri. Icantavaqueri: —¿Paita picoiri? Icantanaqueri: —¿Jaoca pisaviquiri maishitoro? Acantiri maishitoro aneanequi arori: oametantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ari icantiri: —Poijatanaquena, nonijayempiro. Irosati yoijajeitantanacari, ineapaaquero ivanco isavicantari. Ari ishavijiiteanaque catsirincaiteri, irosati isaviquimojeitantapaacari. ");
INSERT INTO cniNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ari ipajita aparoni savicapaintsiri Antirishi, iriotaque irirenti Shimo Petero. ");
INSERT INTO cniNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Impoiji ijatanaque Antirishi, icoapaaqueri irirenti. Ineantapaacariri, icantapaaqueri: —Noneaqueri Meshiashi. Acanti Meshiashi aneanequi arori: Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Icantiri: —Tsame, poijatanaquena, pineapeeri. —Tsame. Ari yareetacaacari Jesoshiqui. Yamenavaqueri, icantavaqueri: —Tempa aviro Shimo, itomi Jonashi. Coajica impajiyeetajempi: Sejashi. Acantajeitiri Sejashi aneanequi arori: Petero, mapitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Otsipaniqui quitaiteri ijataque Jesoshi pashiniqui quipatsi. Opajita quipatsi Carirea. Ari ineapaaqueri Jeripi, icantapaaqueri: —Poijatanaquena. ");
INSERT INTO cniNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Yora Jeripi vetsairasati ini. Vetsaira irootaque inampi Antirishi, jeri Petero. ");
INSERT INTO cniNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jeripi ineapaaqueri Natanaeri. Icamantapaaqueri: —Noneaqueriyea yora isanquenatacotitacaniri peerani Moishishini. Aisati camantantatsiniri isanquenatacotitajeitacarini iriori. Iriotaque Jesoshi, itomi Jose nasaretesati. ");
INSERT INTO cniNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Icantanaqueri Natanaeri: —Te incameetsajeiteji nasaretesati. ¿Icameetsatimpa iriori? Yacanajiri Jeripi: —Tsame, pamenaiteri, piotanteariri icameetsatirica. ");
INSERT INTO cniNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ari iquempejijeitapaacari Jesoshi, ineavaqueri ipocapaaque, icantiri itsipajeitari: —Pamenerite yora Natanaeri. Iriotaque quempetasanotariri Ishiraeri: icameetsataque, te irioteji iramatavitante. ");
INSERT INTO cniNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Isampitapaaqueri Natanaeri: —¿Jaoca picantacari piotantavaquenari nocameetsati? Yacanaqueri Jesoshi: —Noneitaquempi anta pitsititaro iyera, tequerata incamantempi Jeripi. ");
INSERT INTO cniNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Icantaqueri: —Tempa aviro itomi Tasorentsi: pitsoteaquero maaroni, pioyetiro. Avirotaque pincatsariventerineri joriopee. ");
INSERT INTO cniNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Icantiri Jesoshi: —Pamene, incaranqui nocantaquempi: “Noneitaquempi pitsititaro iyera”. ¿Irootaquempa piquemisantantaquenari? Ari pineaquero coajicani nontasoncantasanoyetanaque, impoijiquea pinquemisantasanotanaquena. ");
INSERT INTO cniNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Queario oca nocantimpiri. Aitaque pineaquero coajica inquite tsompoina. Pineaqueri inampire Tasorentsi iraniireashitena, iroancanajea aisati. Tempa naro poneachari inquitequi, natiritapaaque. ");
INSERT INTO cniNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Avisanaque mava quitaiteri, aitaque iquimoshirejeitanaque canasati. Otimi Cana Carireaqui. Yoveshireimentajeitacari aparoni shirampari aatsiri ijina. Ainiro iroori iriniro Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ari icajemacanteetaqueri aisati Jesoshi, aisati narori, jeri aisati itsipapee iroamerepee. ");
INSERT INTO cniNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ari nirajeitapaaque ovaja; nocarajeitaqueri itsipapee pocajeitatsiri. Otsaatapaaca, te ontimeji aisati. Iriniro Jesoshi ocantiri otomi: —Te aneajeroji ovaja: ¿arimpa pimataquero pamitacoteri? ");
INSERT INTO cniNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Icantiro: —¿Paita, ina, picantantanari? Tequeratsita omoncarateaji nontasoncantayete. ");
INSERT INTO cniNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iro cantaincha ocantiri nampirentsi: —Pinquemisanteriyea paitarica imperanataquempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Onaque ara chomo, ocarati 6. Yovetsiqueetiro mapi, antearo oni. Irootaque onantari nija iquivapinitantari joriopee. ");
INSERT INTO cniNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesoshi icantajeitiri nampirentsi: —Pisaje nija chomoquira. Isajeitanaque, ijaajeitaquero. ");
INSERT INTO cniNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Irosati icantantanacariri: —Pinquite meeca. Paacotanaqueneri peranatimpiri. Yaacojeitanaqueneri. ");
INSERT INTO cniNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ineantavacarori, opeanaja ovaja aisati. Te irioteji peranatariri nampirentsi jaoca oquenacotapaajiri. Irinti iotaintsi nampirentsi quitaquerori nija. Irosati icajemantacariri aatsiri ijina. ");
INSERT INTO cniNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Icantiri: —Tempa iro ajivatapinitiri cameetsajari ovaja. Ariorica ashinquijeitanaquea ompocacotapee masancajari. Aitaque ocantari amejeitari. Aviroyeata quempoyeaquerori cameetsajari. Iroaquera meeca pamacantajiro aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Otimi Cana anta Carireaqui. Ijivataque Jesoshi anta itasoncantaque. Nocarajeitaqueri itsipapee iroamerepee noneajeitaquero, irosati noshirejeitantanacariri. ");
INSERT INTO cniNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Irosati noirincantajeitanaca Caperenaoqui. Itsipatanacaro Jesoshi iriniro, irirentipee, narori, itsipapee iroamerepee aisati. Nomaajeitanaque anta aparopee quitaiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Irotimataintsi quitaiteri iquimoshirejeitantapinitari joriopee, ipajiyeetiro: yavisantaniri. Iro iquenqueshiretiri quitaiteri peerani yavisantaniri inampire Tasorentsi anta Ejipitoqui: te iroyeriji itomipee jorio, irinti yoaque itomipee ejipitosati. Ari itoncaanaque Jesoshi Jerosarequi. Nocarajeitanaqueri itsipapee iroamerepee, noijajeitanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Noneajeitapairi ivancoqui Tasorentsi pimantajeitiriri vaca, ovisha, sampaquiti, maaroni. Isavicajeitaque ara pinavacaayetariri atiri iirequite. ");
INSERT INTO cniNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ari yampitsataquero Jesoshi iviritsa impasatanteariri vaca. Irosati yoimisoquijacantajeitacariri ovisha, vaca, maaroni. Ipitamonquitaqueri imesatepee pinavacaariri iirequite, itequitaqueri iirequite. ");
INSERT INTO cniNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Icantiri pimantajeitiriri sampaquiti: —Poimisoquijajeitajeri yoca. Eiro pipimantayetitsi aca ivancoquica Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Irosati noquenqueshireantajeitanajarori isanquenatitacaniri: “Icanti Quirishito: ‘Nontsaneacotearo, Apa, pivanco; irootaque iroimenteetenari coajicani’ ”. ");
INSERT INTO cniNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Icantanaque jorio: —¿Paita pantantarori oca? ¿Paita pinijayenari niojeitantempiri avirorica Tasorentsi? ");
INSERT INTO cniNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yacanaqueri Jesoshi: —Pintireajerorica oca ivancoca Tasorentsi, ari oncarate mava quitaiteri novetsicajero aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Irosati icantantanacari: —Ocarati 46 osarintsi yovetsicanteetacarori pancotsica. ¿Ariompa oncarate mava quitaiteri povetsicantajearori avinti? ");
INSERT INTO cniNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ja, irisati shiacantaincha. Tempa iriotaque shiaquerori ivanco Tasorentsi, tempa quiso yoaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Icamanaque, ocarataque mava quitaiteri itinaantanajari aisati. Impoiji, aitaque noquenqueshireajeitanajiro oca ishiacantaqueri. Aisati niotanaquero oquenquetsatacotaqueniri peerani sanquenarentsi, moncarataca meeca maaroni oquenquetsatacotaqueriniri. ");
INSERT INTO cniNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Areetapaaja aisati yavisantaniri, iquimoshirejeitantari. Itimapaaji Jesoshi Jerosarequi, oshequi itasoncantayetapaaque. Ineayetaqueri atiri, irootaque iquemisantantajeitacariri oshequi. ");
INSERT INTO cniNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yora Jesoshi ioti jaoca icantashirejeitari maaroni atiri, irootaque yaamaventantanacari: “Yayeetanacari”. ");
INSERT INTO cniNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Iojeitaqueri atiri jaoca ocantajeitari iquenqueshirejeitiri. Iotashitaca, tecatsi camanterineri. ");
INSERT INTO cniNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Itimini aparoni shirampari pincatsariventiriri joriopee, ipajita Nicoremo. Variseo ini. ");
INSERT INTO cniNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ari yananincashitanaqueri Jesoshi, icantapairi: —Niotaquempi, oametanari, piponeaca Tasorentsiqui; irootaque pipocantacari, poamejeitapeena. Eirome itsipatimpime Tasorentsi, eirome pitasoncantime. ");
INSERT INTO cniNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Icantiri Jesoshi: —Queariotaque oca noncamantempiri: yora caari apiitajanchane intimaje, tecatsi incantea irijate anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Icantiri iriori Nicoremo: —Ariorica anteashiparitanaje, ¿jaoca ancantajeari antimaje aisati? ¿Arimpa amatajearo ampianajero otsomontequi anironi ontimacotantajeeri aisati? ");
INSERT INTO cniNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yacanajiri: —Queariotaque oca noncamantempiri. Maaroni caari vaotisatajachane nijaqui, aisati maaroni caari ontimaje Ishire Tasorentsi, tecatsi incantea irareetea anta ipincatsaritinta Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tsinane, ariorica ontimeri otomi, irishanincatajeari iriri. Aisati oquempevetaca Ishire Tasorentsi: ariorica ontimajeri atiri, irishanincatajeari Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ariorica noncantempi: “Pampiitajea pintimaje”, eiro poanatsi cavaco. ");
INSERT INTO cniNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jaocarica oninti, ojeaoncaque tampea, piquemavaquero opoimatapaaque, sooo. Iro cantaincha te pioteji jaoca oquenapaaqueri, aisati te pioteji jaocarica ojateri. Aisati iquempeyevetaro maaroni otimajiri Ishire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Icantajiri Nicoremo: —¿Jaoca ocantari oca pishiacantanari? ");
INSERT INTO cniNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yacanajiri iriori Jesoshi: —¿Caarimpimpa oamejeitiriri ajorioririntepee? ¿Paita caari piotantavacaro oca nocantimpiri? ");
INSERT INTO cniNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Queariotaque oca noncamantempiri: nocamantacotiro nioyetiri aisati noneayetiri, iro cantaincha te pinquemisanteroji nocamantayevetimpiri. ");
INSERT INTO cniNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jero noquenquetsavetimpiro ineeyetiri aca quipatsiquica, iro cantaincha te pinquemisantenaji. Nonquenquetsatempirome timayetatsiri inquitequi, ¿arimpa pinquemisantaquename? ");
INSERT INTO cniNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aitaque noponeari narori inquitequi, natiritapaaque; coajica nompianaje aisati. Noquenquetsatacotirorica inquite, niotaquero nocantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Peerani anta caaraiteriqui yatsicajeitaqueri ashanincani oshequi maranquepee. Ari icantirini Tasorentsi: “Pishiacanteri maranque, poatiacoteri inchaquiiqui iramenajeitanteariri atiripee, eiroquea icamajeitantatsi maaroni amenajeiterineri”. Ari yoatiacotaqueri Moishishi, yavisacojeitantajari oshequi atiri. Aisati narori iroatiacoyeetaquena, coajica. ");
INSERT INTO cniNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Maaroni quemisantenaneri incantaitatiyempani iraneajeitanaje anta inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Inintasanojeitiri Tasorentsi maaroni atiri, irootaque itiancantaquenari aca quipatsiqui. Narotaque itomi irapintite. Incantaitatiyempani iraneajeitapaaje inquitequi maaroni quemisantajeitanari; eiro catsini ijatitsi ishaaviji maaroni quemisantajeitanari. ");
INSERT INTO cniNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Te iro intiancantena Apa noasanquetaajeiteri atiripee, irointi itiancantaquena noavisacojeiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Eiro yashinoncaajeitatsi maaroni quemisantanari. Iro cantaincha iroasanquetaajeitaqueri Apa maaroni caari quemisantana. Iro iroasanquetaanteariri, itseencajeitana. ");
INSERT INTO cniNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nopoqui noamejeiteri atiri jaoca icantari Tasorentsi aisati iriotanteari intimajeite cameetsa: oquempevetaca noquitaitetacovetacari atiri. Iro cantaincha yantapinijeitiro caari cameetsatatsi, te incoajeiteji iriojeitero oca noamejeivetacariri; oquempetaca inintasanojeitiro tsiteniri irointi. Te incoajeiteji intimajeite quitaiteriqui, icantajeiti: “Ineiteerocari Tasorentsi antayetiri, yoasanquetayeecari”. ");
INSERT INTO cniNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yora antajeitirori caari cameetsatsi iquisajeitana. Te incoajeiteji impocashitena: iotaque nonijaantiteri caari cameetsatatsi yantajeitiri, irootaque caari ipocashitantana inquemisantena. ");
INSERT INTO cniNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Antirori cameetsayetatsiri, iriotaque pocashitanari irinti. Nonijayetiri ocameetsajeitaque yantayetaqueri. Tempa irio Tasorentsi antacaajeitiriri cameetsayetatsiri, irootaque caari ipashiventanta ipocashitana. Irootaque icantaqueriri Jesoshi Nicoremo. ");
INSERT INTO cniNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Irosati ijatantanaja Jesoshi Joreaqui, nocarajeitanaqueri itsipapee iroamerepee, noijajeitanaqueri. Nosavicajeitapaaji anta, novaotisatantapaaji. ");
INSERT INTO cniNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aisati iriori Joa, ivaotisatanti aisati Ainoqui, oquempejitaro Sarimi. Oshequitapai nija anta. Ijatashijeitanaqueri oshequi atiri irivaotisatanteariri. ");
INSERT INTO cniNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","25","Tequeratsita iroiminqueeteriji Joa. Yora iroamere, ipiatsatacari aparoni jorio. Iro ipiatsatavacaimentari jaoca ancantajeitajeari ancameetsajeitantajeari. ");
INSERT INTO cniNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Irosati ipocashitantapaacari Joa iroamere, icantapaaqueri: —Oametanari, jeri ivaotisatanti yoranqui pitsipatariranqui chapinqui intatiqueronta Jorirani. Yoranqui picantiri Quirishito. Irootaque ijatashijeitantanacariri maaroni atiri, meeca yojocajeitanaquee arori. ¿Paitaquea? ");
INSERT INTO cniNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yacanaqueri Joa: —Tecatsi amatashitea arori, irintiquea Tasorentsi jenoquisati matacayeerori maaroni cameetsayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Piquemajeitaquena nocantaqueri chapinqui: “Caarina noni Quirishito. Itiancaquena Tasorentsi nojivataqueri”. ");
INSERT INTO cniNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yora aintsiri ijina, iriotaque aasanotirori. Yora ishaninca icarajeitiri inquimoshireimenteari inquemavaqueririca irineanate. Aisati meeca noquempetari narori. Oshequi noquimoshireimentasanotanaqueri iriori Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aiquero ijatatii ipincatsaritasanotanaque irinti. Narori, te: ");
INSERT INTO cniNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","eiro nopincatsarititsi. Yoraquea poneachari jenoqui ipincatsariventasanotanti irinti. Aroquea quipatsisati ashanincatasanojeitari savicajeitatsiri quipatsiqui, te ampincatsarijeiteji. Aquenquetsatacotiro oca aneayetiri aca quipatsiqui. ");
INSERT INTO cniNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yora poneachari inquitequi icamantacoyetiro paitarica ineayetiri aisati iquemayetiri anta. Iro cantaincha te intimasanoveteaji quemisantasanotavaqueroneri icantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Irintiquea maaroni quemisantavaquerori, ioti irinti otampaticatasanotaque maaroni icantiriri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iriotaque Tasorentsi tianquiriri Jesoshi, meeca yoametapaaqueero irineane. Yora Tasorentsi te intsaneemparoji Ishire, quiso oajeitaquee. ");
INSERT INTO cniNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Apa jenoquisati inintiri Itomi, itiancaqueeri ipincatsariventajeitee maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Maaroni quemisantajeiterineri Itomi Tasorentsi incantaitatiyempani iranee inquitequi. Eiro ijatitsi inquitequi caari quemisanterine irinti, irosati incantatiyempani Tasorentsi inquisheri irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Yora variseopee iquemacotaqueri Jesoshi, icantajeitiri atiri: —Jesoshi yanaacotiri Joa yoametanti. Oshequi iquemisantacaaqueri atiri, oshequi ivaotisatanti. Te iri Jesoshi vaotisaterine atiri, narojeitaque nainti iroamerepee vaotisatantatsiri. Iotaque Avincatsarite icantaqueri variseopee, ");
INSERT INTO cniNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","yojocanajiro Jorea, ipianaja aisati Carireaqui. ");
INSERT INTO cniNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","5","Iquenanaji Jesoshi Samariaqui, noijatanaqueri narori. Nareejeitapaacaro nampitsi samariaquiniri pajitachari Shicari. Oquempejitaro iipatsiteni Jacovoni: oca ipaqueriniri itomini Jose. ");
INSERT INTO cniNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Otimi ara iiyanareni Jacovoni. Imaotapaaque Jesoshi, tempa noponeajeitaca arejiqui. Isaviquimotapaaquero iriori iiyanareni. Irotimataintsi intampaticate catsirincaiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","(-) ");
INSERT INTO cniNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Notsipatacari itsipapee iroamerepee, nojajeitapainti nampitsiqui namanantapaintiro noyeari. (v 7) Irosati opocantapaaca tsinane samariasato, onquitaate nija. Icantavaquero Jesoshi: —Pimpacotena nire. ");
INSERT INTO cniNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ocantiri: —¿Caarimpimpa jorio? ¿Paita pamanantanari nija? Samariasato noni. Te iraacameetsajeiteriji jorio samariasati, irootaque ocantantacariri. ");
INSERT INTO cniNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yacanaquero Jesoshi: —Te pioteji paitarica inintacaaquempiri Tasorentsi nomatempiri. Aisati te piotenaji narori, janicanarica. Nocantaquempi: “Pimpacotena nireta”. Iro cantaincha piotaquename, pincantaquename avinti: “Aviro avinti penaneri nireri”. Irosati nompashitantempirome nija oaneantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ocantanaqueri: —Tecatsi pinquitaatanteari. Tsompoina oni nija. ¿Jaoca payerori oca nija ovaneantatsiri? ");
INSERT INTO cniNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Panaacotirimpa yora Jacovoni, quianatironiri oca iiyanareni? Irironi nijaca, irajeitironi itomipee iriori, aisati ivira. Irosati meeca nirajeitiro narori. Ocameetsajataque nijaca: ¿pijitimpa ari pimpajena nija anaacoteroneri oca ocameetsajati? ");
INSERT INTO cniNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yacanajiro aisati: —Irimirejeitanaje aisati maaroni irapinitirori oca nija. ");
INSERT INTO cniNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Irintiquea yora iraqueroneri nija nompaqueriri nainti: eiro imiretajitsi aisati. Ora nija nomperiri amotoapaaque ishirequi, irootaque aneacaajerine incantaitatiyempani. ");
INSERT INTO cniNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ocantanajiri tsinane: —Pimpenaroqueti meeca ora nija picantaquenari, eiroquea nomiretantajatsi. Eiro natsipetajatsi nompocaje nonquitaataje aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Icantanajiro: —Pijate meeca, pincajemaitenari pijime, pimpiaje aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Acanajiri: —Te intimeji nojime. Icantanajiro: —Queariotaque picantaquenari: “Te intimeji nojime”. ");
INSERT INTO cniNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Icarajeitaque pijime paavetacari apapacoroni. Yora pitsipatari meeca caari ini pijime. Queario picantaquena. ");
INSERT INTO cniNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ocantanajiri: —Aviroyeata camantantatsiri: aparo meeca nosampitempi. ");
INSERT INTO cniNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Aca toncaariqui iquemisantapinijeitiri noshaninca Tasorentsi. Avirojei jorio, picantajeiti avirori cameetsa anquemisantajeite Jerosarequi. ¿Paitaquea anashitavacantacari? ");
INSERT INTO cniNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Icantanajiro: —Pinquemisantero oca noncamantempiri meeca. Coajica eiro piquenqueshiretajirotsi jaocarica pinquemisanteriri Tasorentsi. Atsipetashita aquenqueshiretashitaro jaoca anquemisanteri, irointi cameetsatasanotatsiri anquenqueshiretero janica aquemisantiri. ");
INSERT INTO cniNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Avirojei samariasati te piojeiveteariji yora piquemisantajeivetari. Narojei, jorio, niojeitiri nainti janica noquemisantajeitiri. Jorio irine oavisacotantatsineri. ");
INSERT INTO cniNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Moncarataca pinquemisantasanojeiteri Apa: pincoaquerica, ari amitacojeitempi Ishire Tasorentsi, oametempiro quearioyetatsiri. Aitaque icoaque Apa inquemisantajeiteri maaroni coyeroneri Ishire oamejeiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Te ontimeji ivatsa Tasorentsi, irointi Ishire. Coatsiri inquemisanteri Tasorentsi inquemisantasanotero Ishire iriotantearori quearioyetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ocantanajiri: —Niotaque impoque Meshiashi, yora icanteetiri Quirishito. Irareetapeemparica iriotacaajeitapaajee maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Icantanaquero: —Narotaque nainti Quirishito neanataquempirica. ");
INSERT INTO cniNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Irootaque icantaquerori Jesoshi. Irosati narori, nocarajeitiri itsipapee iroamerepee, nareejeitapaaja. Noneapaaqueri iquenquetsatacairo tsinane, noajeitapaaque cavaco. Iro cantaincha te nosampitapeeri: “¿Paita picantirori tsinane? ¿Paita piquenquetsatacantarori?” Namenashitapaacari. ");
INSERT INTO cniNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Irosati ojocantanacaro ochomone, ojatanaque nampitsiqui. Ocamantapairi onampiquiniri: ");
INSERT INTO cniNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Tsame, poijajeitanaquena. Nonijayempiri shirampari cantaquenari maaroni, paitarica nantayetiniri. Irioyeata Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Irosati yoijajeitantacaro irameneri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Irosatiquera nonajeitaque iiyanareniqui, nocantavetari Jesoshi: —Oametanari, poyea. ");
INSERT INTO cniNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Icantana: —Timatsi noari narori caari piojeiti avinti. ");
INSERT INTO cniNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Irosati nocantavacaajeitantanaca: —¿Yameetinirimpa yoari? ");
INSERT INTO cniNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Icantanaquena: —Nantiniri tiancaquenari inintacaanari: oquempetimotaquena noaca, te meeca nonquemeroji notashe. ");
INSERT INTO cniNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ariorica pipanquitiro pivanquire, tempa picantavacaajeita: “Itsipasatinivani cashiri aajeitantearori avanquire”. Pinquemisantajeitero noncamantajeitempiri meeca: piotavaquero noshiacantempiri. Pamenajeitero panquirentsi: sampatanaque, ");
INSERT INTO cniNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","moncarataca iraanteetearori. Impinateri ashitarori, impoiji inquimoshirejeitanaque: yora ashitarori, aisati iratiritepee, maaroni. Aviro noshiacantiri aayetirori, irio Tasorentsi ashitarori. Ariorica pinquemisantacayeri atiri impinatempi, aisati incantaitatiyempani iranee maaroni pinquemisantacaajeiteri. Irampatojeiteri Tasorentsi maaroni irioriqui, anquimoshirejeitantajeari, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Queariotaque oca icantapiniyeetiri: “Yora panquitaquerori, eiro yaayetirotsi; irinti pashini aajeroneri”. ");
INSERT INTO cniNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Notiancajeitaquempi nainti paajeitantearori caari pipanquiti avirori. Timatsi pashini panquitaquerori, pimpoijeitajeri avirori. Ari pimoncaratavacaajeitaca pantajeitaquero nocoacaajeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Irosati areetantajari tsinane aisati maaroni oijajeitaquerori. Iro ipocajeitantacari ishirejeitavacaro ocantapaaqueriri tsinane. Ocantapaaqueri onampipeequiniri incaranqui: “Icantaquena Jesoshi maaroni, paitarica nantayetiri: irioyeata Quirishito”. Irootaque iquemisantajeitantanacariri Jesoshi oshequi. ");
INSERT INTO cniNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Irosati ipocashijeitantacari, icantapairi: —Pisaviquimotanaquenatsita. Ari isavicanaque apite quitaiteri, ");
INSERT INTO cniNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","iquenquetsatacaanaqueri. Iquemisantasanojeitanaqueri oshequi. ");
INSERT INTO cniNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Icantajeitaquero tsinane: —Noquemisantavetacaro picantaquenari, iro cantaincha meecaquea noquemasanotaqueri iriori Jesoshi, irootaque niojeitantacari queario oni picantaquenari. Iriotaque oavisacojeiteeneri. Iriotaque yoca Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ari apite imaaque Jesoshi anta, irosati ijatantanajari. Ijatanaji aisati Carireaqui. Narori, noijajeitanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jero oca icantapinitiri Jesoshi: “Te impincatsatasanoteriji yora inampipeequiniri camantantatsiri, irointi itseencapinitiri ishanincasanori”. ");
INSERT INTO cniNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ari nareejeitapaaja Carireaqui. Yaacameetsajeitavaqueri carireasati irinti. Ijajeitanaque chapinqui iriori anta Jerosarequi, iquimoshirejeitinta. Aitaque anta ineayetaquero yantayetiri Jesoshi. Irootaque meeca ineacameetsajeitantacariri. ");
INSERT INTO cniNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ipianaja aisati Jesoshi Canaqui: ora carireaquiniri. Anta chapinqui ipeaquero nija ovaja. Itimaiti Caperenaoqui pincatsari, yojoquiitaca itomi. ");
INSERT INTO cniNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Iquemacotavaqueri Jesoshi, iponeanaja Joreaqui, yareetapaaja Carireaqui. Ari ijatashitanaqueri, icantapairi: —Irotaintsi incame notomi. Tsame poavisacotajantenari. ");
INSERT INTO cniNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Icantaqueri Jesoshi atiripee: —Eirorica notasoncantayeti, ¿ariompa pinquemisantajeitena? Aitaque picantajeitari avirori, pitseencajeiti. ");
INSERT INTO cniNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Icantanajiri aisati: —Intsipaite apa, pijate novancoqui. Icamicari notomi. ");
INSERT INTO cniNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Icantanaqueri: —Pijataje meeca. Eiro icamitsi pitomi, aitaque iravisacotaje. Iquemisantaqueri icantaqueriri, ijatanaji. ");
INSERT INTO cniNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nianqui itonquiotavacari inampirepee, icantavajiri: —Avisacotanaji pitomi. ");
INSERT INTO cniNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Irosati isampitantavacari: —¿Jaoca ocaratiri yavisacotantajari? Yacanajiri: —Oshaiteji, itaanaji catsirincaiteri, aitaque opeanaja iyatsiire. ");
INSERT INTO cniNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Iquenqueshireanajiro aitaque icaratiri catsirincaiteri icantantacariri Jesoshi: “Eiro icamitsi pitomi”. Ari iquemisantanaque iriori. Aisati iquempejeitaja maaroni ishaninca, iquemisantajeitaji. ");
INSERT INTO cniNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ari meeca isaviqui Jesoshi Carireaqui, iponeanaja chapinqui Joreaqui. Ocarati meeca apite itasoncantaque Jesoshi anta. ");
INSERT INTO cniNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Irosati iquimoshirejeitantanaja aisati joriopee. Itoncaanaji Jesoshi Jerosarequi, tonca, tonca. ");
INSERT INTO cniNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Otsapiqui nampitsi otimi yoiminqueantapinitariri ovisha. Otimi anta quempeji incajare. Irineanequi Evereo opajita Vetsata. Otimi anta pancotsipee apapacoroni. ");
INSERT INTO cniNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Irootaque inariantajeitari joquiijeitachari oshequi. Yapatojeita quitapoajari, mayempiri, choriveetatsiri. Yoyeajeitiro nija oshevajatajea. ");
INSERT INTO cniNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yaniireashitapinitiro incajare inampire Tasorentsi. Ishevajatacaapinitaro nija, irosati iqueajatantarori yora joquiijeitachari. Jaocarica itimiri jivatasanotatsiri iqueajataque, yavisacotaji; opeanaja paitarica oavetariri. ");
INSERT INTO cniNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Itimaiti ara aparoni shirampari joquiitachari: ocarati 38 osarintsi yojoquiitantacari. ");
INSERT INTO cniNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ineapaaqueri Jesoshi inariaita. Iotacotapaaqueri aitaque ocaratiri yoshequitaquero osarintsi. Icantiri: —¿Picoimpa pavisacotaje? ");
INSERT INTO cniNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yacanaqueri: —Tecatsi queajatacayenane ariorica oshevajaveta nija. Irointita nopomerentsita narori, irosati yanaacotantanari itsipapee: iqueajatanaque irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Icantanaqueri Jesoshi: —Pintinaanaje, pajiricajero pinariantaveitari, paniitanaje. ");
INSERT INTO cniNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Irosati yavisacotantanaja. Yajiricanajiro inariantaveitaniri, irosati yaniitantanaja. Irootaque saavaro, quitaiteri imaoreanteetari. ");
INSERT INTO cniNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Irootaque icantajeitantacariri joriopee yora avisacotajantsiri: —Irootaque meeca quitaiteri amaoreantajeitari. Te oshinetanteaji paanajero meeca pinariantari. ");
INSERT INTO cniNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yacanaqueri: —Yora oavisacotajanari irio cantanari: “Paanajero pinariantaitari, paniitanaje”. ");
INSERT INTO cniNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Irosati icantantanajari: —¿Janicampa cantaquempiri? ");
INSERT INTO cniNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Te irioteji iriori janicarica oavisacotajiriri. Itimaiti ara oshequi atiri, ipeimotanacari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Impoiji ineajiri aisati anta ivancoqui Tasorentsi. Icantiri: —Pineaquero, avisacotajimpi meeca. Eiro pantajirotsi aisati caari cameetsatatsi. Apiitajimpicari, omatasanoticari catsini. ");
INSERT INTO cniNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Irosati ijatantanaja shirampari. Icamantapaajiri joriopee: —Irio oavisacotajanari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Irootaque iquisajeitantanacariri joriopee Jesoshi. Iro icoantacari iroyerime, ineaqueri yoavisacotantaque quitaiteriqui imaoreantajeitari. ");
INSERT INTO cniNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iro cantaincha icantanaqueri: —Irosati icantani Apa yantayetiro cameetsatatsiri. Aisati noquempetacari narori: ¿paitampa noimpacaantearori saavaroqui? ");
INSERT INTO cniNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aiquero catsini icoasanotanaiti iroyerime. Ineaqueri Jesoshi yantaveetantaro quitaiteri imaoreantajeitari. Iquemaqueri aisati icanti: “Iriotaque Apa Tasorentsi”. Irosati icantantanaca joriopee: —Ijitasorentsitacateemi, te incameetsateji. ");
INSERT INTO cniNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yacanajiri Jesoshi: —Queariotaque oca noncamantempiri. Naro itomi Tasorentsi. Te nantaveetashiteaji, irointiquea nomoncarayetaquero paitarica noneacotiriri yantiri Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Inintaquena iriori, yoameyetaquenaro maaroni nantayetiri. Coajica irimatacayena nomatasanoyetero catsini nontasoncantayete, poantenari cavaco. ");
INSERT INTO cniNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tempa yoitinaapiniyetiri Apa camayetatsiri, yoaneajiri. Aisati nonquempetea narori, noaneajeri janicarica noncoacayeri. ");
INSERT INTO cniNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Eiro icantacoventiritsi Apa atiri, eiro catsini; irootaque itiancantaquenari nainti noncantacoventanteariri. ");
INSERT INTO cniNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Icoaque Apa impincatsajeiteri maaroni atiri. Aisati icoacaaquena narori, impincatsajeitena maaroni. Yora caari pincatsatana narori, te impincatsateriji aisati Apa, yora tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Queariotaque oca noncamantempiri. Maaroni quemeroneri noneane, ariorica inquemisanteri tiancanari, incantaitatiyempani iraneajeitanaje inquitequi. Eiro yoasanquetairitsi Apa. Incamavetaquea, iro cantaincha iraneanaje aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Queariotaque oca nocantimpiri. Irotimataintsi yora camavetainchari inquemajeitena noneanate: tempa naro Itomi Tasorentsi. Icantaitatiyempani iraneajeitanaje maaroni quemajeitenaneri. Aitaquequea meeca omoncarataca inquemajeitantenari. ");
INSERT INTO cniNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Irisati aneashitacha Apa. Aisati icoacaaquena narori nomoncaratacari, narosati aneashitacha narori. ");
INSERT INTO cniNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tempa noponeanaca inquitequi, natiritapaaque. Irootaque itiancantanari noncantacoventeri maaroni atiri. ");
INSERT INTO cniNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Eiro poajeititsi cavaco. Coajica inquemajeitena noneanate maaroni yora tijajeivetainchari. ");
INSERT INTO cniNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aitaque intinaajeitanaje antirori cameetsayetatsiri, iraneajeitanaje aisati. Aisati iriori antayetirori caari cameetsatatsi: intinaajeivetanajea, iro cantaincha noashinoncaasanojeiteri irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Tecatsi noncantea nantashitearo. Nocantacoventantirica, nomoncarataquero icantanari Apa. Tampatica nocantacoventanti. Te nantashitearoji paitarica nonintiri narori, irointi nantiniri Apa tiancanari inintacaaquenari iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Aisati icantajeitiri Jesoshi: —Narosatirica camantacotachaneme apaniro pincanteme: “Te ontampaticateji icantiri”. ");
INSERT INTO cniNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Iro cantaincha ainiro pashini camantacotitananiri: yora Joani. Nioti queario oni icamantacotanari iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pitiancayetaqueri pishaninca, pisampitacantaqueri. Ari icamantacotasanotaquero queariotasanotatsiri, icamantaquempi: “Iriotaque Jesoshi Quirishitotatsiri, Itomi Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Te oncantimoneentenaji incanterica atiri: “Icameetsati Jesoshi”, iro cantaincha nocoaque pavisacojeitaje, irootaque nocamantantimpirori oca. ");
INSERT INTO cniNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yora Joa iquempevetacaro tsiomentotsi amorecasanotatsiri. Pineajeitavaqueri itsiojeitapaaquempi: tempa oshequi iotacaajeitaquempi. Piquimoshireventajeivetavacari osamani. ");
INSERT INTO cniNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Timatsi aisati otsipa iotacaaquempiri, ora anaacotiriri Joa, piotasanotantenari. Apa itiancaquena. Meeca nontsoteeneri icantaquenari. Paitarica nantayetiri narori, irootaque piotantenari itiancaquena Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aisati icamantacotaquena Apa tiancaquenari. Queario, te pinquemapiniteriji irineanate, aisati te pineapiniteriji jaoca icantari. ");
INSERT INTO cniNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Iro cantaincha te pinquemisanteriji itiancane, irootaque caari pishiretantaro irineane. ");
INSERT INTO cniNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pineanatapinijeitaquero Sanquenarentsi, tempa pijitashijeivetaca ariorica pineanatero, pincantaitatiyempani paneajeitanaje. Tempa irootaque camantacotanari. ");
INSERT INTO cniNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Iro cantaincha te pincoyeji paventena noaneantajeitajempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Te oncantimoneentenaji pineacameetsajeitanarica. ");
INSERT INTO cniNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Niojeitimpi nainti, te pininteriji Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Itiancana Apa, irootaque nopocantacari. Iro cantaincha te pineacameetsajeitenaji. Ariorica impocashitempi irinti yora caari itiancane, irioquea pineacameetsajeitavaqueri irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Avisati neacameetsatavacaajeitacha. Aitaque picantajeitari. Iro cantaincha te pincoyeji irineacameetsajeitempi Tasorentsi. Iriotaque Tasorentsi apaniro. ¿Jaoca pincanteari meeca pinquemisantasanoteri? ");
INSERT INTO cniNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Eiro pijitashitatsi naro camantacotempineri Apaqui: “Ainiro, Apa, yantajeitiri yocapee”. Timatsi pashini camantacotempineri: iriotaque yora Moishishini, incanteri Apa: “Te inquemisantajeiteroji yocapee ora pisanquenatacaaquenari”. ¿Pijivetacampa ari irancacoventaquempi? ");
INSERT INTO cniNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Arime pinquemisantasanojeiterime Moishishini, aitaque pinquemisantajeitavaquename narori. Isanquenatacotaquena iriori peerani. ");
INSERT INTO cniNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Niotaque te pinquemisanteroji isanquenatiniri. ¿Ariompa pinquemisantero nocantimpiri narori? Irootaque icantajeitiriri Jesoshi joriopee. ");
INSERT INTO cniNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Irosati imonteantanajaro Jesoshi incajare pajitachari Tiveriashi, onta carireaquiniri; noijajeitanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Oshequi catsini oijajeitiriri. Ineacojeitaqueri itasoncacoventajiri joquiitachari, irootaque yoijajeitantanacariri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Itoncaanaque Jesoshi toncaariqui. Isavicapaaque anta, nocarajeitaqueri itsipapee iroamerepee, notsipajeitanacari. ");
INSERT INTO cniNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Irotimataintsi inquimoshirejeitantajeari joriopee. Ipajiyeetiro quitaiteri “Yavisantaniri”. ");
INSERT INTO cniNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yamenanaque Jesoshi. Ineavaqueri oshequi atiri pocashijeitaqueriri, isampitiri Jeripi: —Jeripi, ¿jaoca amananterori meeca tanta iroajeiteari ashanincapee? ");
INSERT INTO cniNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iro icantashitantacariri, icoaque Jesoshi irineanteari Jeripi. Irinti Jesoshi, iotaque jaoca incanteriri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ari yacanaqueri: —Amanantavetearorica tanta oshequi, ampinaventavetaquearorica 200 tenario, eiro inajeitarotsi. Ariorica ampayevetaqueari capichaji, eiro inajeitarotsi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ari itimi anta pashini iroamere, yora Antirishi. Iriotaque irirenti Shimo Petero. Icantiri: ");
INSERT INTO cniNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Oametanari, jerica aparoni evancari, timatsi itantane apapacoroni. Timatsi aisati ishivajaniquite apite. Iro cantaincha notseencaqueri: tempa oshequi catsini atiri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Irosati icantantanacari Jesoshi: —Poisavicajeiteri maaroni atiri. Ocasaveshiiteaquera. Icarajeitaque 5,000 shirampari savicajeitaintsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Irosati yaantacaro Jesoshi tanta. Ipasonquitacotaquero. Ipajeitaqueri savicajeitaintsiri. Aisati iquempetaqueri shivajaniqui, ipajeitaqueri. Aitaque ocarati icoajeitaqueri aitaque ocarati ipaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Iquemajeitanaca maaroni. Irosati icantajeitantajari Jesoshi iroamerepee: —Paajeitajero timaarantapaajantsiri, aparatacari. ");
INSERT INTO cniNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Iquemajeitacaro oca tanta apapacoroni. Yaajeitajiro timaarantapaajantsiri. Itetajiro cantiriqui. Ijaajeitajiro ocarati 12. ");
INSERT INTO cniNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Noneajeitaqueri itasoncaquero tanta, irosati nocantajeitantanacari: —Iriotasanotaque yoca camantantatsiri aquemacotaqueri, aamaajeiveitaniri peerani. ");
INSERT INTO cniNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iotavaque Jesoshi impocashijeiterime oajeitainchari iraanaquerime, impeajerime ivincatsarite. Irosati ipeapitsatantanajari. Ijatanaji toncaariqui apaniro. ");
INSERT INTO cniNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ishavijiiteanaque, nocarajeitanajiri itsipapee iroamere, noirincajeitanaja incajarequi, ");
INSERT INTO cniNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","notejeitapaajaro pitotsi. Notiancajiro nomonteanaje intatiquero, anta Caperenaoqui. Tsitenitasanotanaji, tequeratsita intsipajeitajena Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Opocaque antearo tampea, oquisaatanaca incajare, soooo, irootaque otimantacari antearo omotoncane. ");
INSERT INTO cniNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aitaque nonajeitaque nianquijaqui. Osamani quipatsi, aamaaca ari ocarati 5 quirometero, arioricampa 6 nareetantajeari. Aiquero nocomajeivetaca. Irosati noneantavajari Jesoshi yaniijatapaaji incajarequi, te intsitiaquiiteji. Iquempejitapaajaro pitotsi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Notsaroajeitanaque. Icantapaajana iriori Jesoshi: —Narotaque, eiro pitsaroacaajeitanatsi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nocoajeivetanaca nontetavajerime, iro cantaincha noneacotashitapaaca naatacojeitapaaque otsapijaqui, anta nojajeitenta. ");
INSERT INTO cniNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Oshaiteji icatiajeitaca atiri intatiqueronta. Ineajeitavajana narori notejeitanaja novitoqui. Te intsipajeitanajena Jesoshi, nainti jajeitajantsi. Tecatsi pashini pitotsi vaatachane anta. ");
INSERT INTO cniNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Meeca yareejeivetapaaca tiveriashisati, iquenacotapaaque ivitoqui. Yaatacojeitapaaque quempeji yoacaajeitacarinta oshaiteji tanta. Icoavetapaacari: —¿Jaocame Jesoshi? ¿Jaoca iroamerepee? ");
INSERT INTO cniNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Te irineajeitapaajeriji Jesoshi; aisati narorijei iroamerejei, te irineajeitapaajenaji. Ari impoiji itejeitanaja atiripee ivitopeequi, ijatacojeitanaji Caperenaoqui, icoajeitapaajiri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aitaque ineajeitapaajiriri intatiquero. Icantajeitapaajiri: —Oametanari, ¿jaoca ocaratiri pareetantajari aca? ");
INSERT INTO cniNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yacanajiri: —¿Paitasa picoantanari? Queariotaque oca noncamantempiri: te iro pincoimentena pimpincatsatena, irointiquea picoimentana noacaaquempi oshaiteniji tanta. Meeca picoajeiveta noacaajeitajempi aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ora ayeari ario ontsoncanaquea. Eiro piquenqueshiretapinitirotsi. Naintiquea pinquenqueshiretasanote nainti, naro materone noaneasanojeitempi pincantaitatiyempani paneasanojeitantapaajeari anta inquitequi. Notimitani inquitequi, itiancaquena Apa quipatsiquica, natiritapaaque noaneajeitantajempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Isampitiri jorio: —¿Jaoca noncanteari nantanteanariri inintacaanari Tasorentsi? ");
INSERT INTO cniNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yacanajiri Jesoshi: —Pinquemisantajeitena: irootaque inintacaajeitimpiri Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Irosati isampitantanajari: —¿Paita ponijayenari nonquemisantantempiri? Ariorica noneaquempi pintasoncante, ari niotaque queario picantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Peerani yora ashanincani yoajeitaro mana anta caaraiteriqui. Ocanti sanquenarentsi: “Ipeetaqueri yoari yoajeitantarori. Oponeaca inquitequi”. Tempa irio Moishishi pajeitaqueriri, irootaque iojeitantacaniri ashanincani ocameetsati iroijajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Icantanajiri Jesoshi: —Queariotaque oca noncamantempiri. Te irio Moishishini perineri yoajeitari poneainchari inquitequi. Irinti Apa pajeivetacariniri. Meeca icoaveta impempi pashini poajeiteari, cameetsatasanotatsiri, poneachari inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Noponeaca narori inquitequi, naniireapaaque quipatsiqui noaneajeiteri maaroni atiri: noshiaquero poyeameri impempimeri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Icantanajiri: —Irosati pincanteani, novincatsarite, pimpapinitenaro ora noyeari picamantaquenari. Aiquero pimpapinitenaro. ");
INSERT INTO cniNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Icantanajiri iriori: —Narotaque shiirori oanarontsi aneacantatsiri. Pocashitanari eiro aajiritsi itashe. Quemisantanari eiro imiretajitsi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aitaque nocantajeivetaquempi. Pineajeivetaquena, iro cantaincha te pinquemisantenaji. ");
INSERT INTO cniNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yora icantanari Apa: “Pinquempoyeajeitenari”, iriojeitaque pocashitajenaneri. Pocashitapaajenaneri eiro noipiavajiritsi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Te iro naniireantapeempa nantapeero nonintiri narori, irointi nante inintacaanari tiancanari. Irootaque naniireantapaacari. ");
INSERT INTO cniNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yontapee noquempoyeaqueneri Apa, eiro ipeatsi aparoni. Nontinaajeitajeri omoncaratapeemparica quitaiteri. Irootaque inintacaanari Apa tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Maaroni neenaneri, ariorica inquemisantena, incantaitatiyempani iraneanaje inquitequi. Nontinaajeitajeri coajicani, omoncaratapeemparica quitaiteri. Irootaque inintacaanari Apa tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Irosati icantimajeitantanacariri joriopee. Iquemaqueri icantaqueri: “Narotaque shiirori oanarontsi, poneachari inquitequi”, irosati icantimajeitantanacari. ");
INSERT INTO cniNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Icantajeiti: —Tempa iriotaque Jesoshi, itomi Jose. Tempa aneapinijeitiri iriri, iriniro aisati. ¿Paita icantantari: “Noponeaca inquitequi”? ");
INSERT INTO cniNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Icantanaqueri iriori Jesoshi: ");
INSERT INTO cniNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","—Eiro picantimajeitanatsi. Eirome inintacairime Apa tiancaquenari, tecatsi pocashitimatenaneme. Iriotaque nontinaajeri coajicani omoncaratapeemparica quitaiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Isanquenatacotitacarini peerani camantantatsiniri: “Tasorentsi iroamejeitajeri maaroni”. Maaroni quemavaquerori icantiri Apa, iriotavaquerorica, impocashitena noavisacotanteariri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Noponeanaca Tasorentsiqui, irootaque noneantariri Apa. Tecatsi pashini neerine. ");
INSERT INTO cniNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Queariotaque oca nocantimpiri. Yora quemisantanari incantaitatiyempani iraneajeitanaje inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jero oca icantajeitiri aisati: —Narotaque oanarontsi aneacaantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yoajeivetacaroni pishanincani mana peerani anta caaraiteriqui, iro cantaincha yanteashipajeitanaque, icamajeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Oca oanarontsi noquenquetsatacotiri oponeaca inquitequi. Eiro icamanetajitsi oaquearoneri irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Narotaque shiirori oanarontsi aneatsiri, noponeaca inquitequi. Maaroni oyearoneri oca oanarontsi incantaitatiyempani iraneajeitaje inquitequi. Nompajeiteri maaroni atiri iraneajeitantajeari: irootaque novatsa. ");
INSERT INTO cniNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Irosati icantavacaajeitantanacari joriopee. Icantajeiti: —¿Jaoca incanteari yoca impanteerori ivatsa avantearori? ");
INSERT INTO cniNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Icantajeitiri Jesoshi: —Queariotaque oca noncamantempiri. Noponeaca inquitequi, natiritapaaque. Eirorica poarotsi novatsa, aisati eirorica pirirotsi niraja, eiro paneajitsi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Maaroni oyearoneri novatsa, aisati ireroneri niraja, incantaitatiyempani iraneaje inquitequi iriori. Nontinaajeri coajicani omoncaratapeemparica quitaiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Novatsa irootaque oanarontsisanori. Niraja irootaque ireetasanoyeetiri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Oyearoneri novatsa aisati ireroneri niraja irosati incantea, quiso iroajena. Aisati nonquempetea narori, quiso noajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Aneatsiri ini Apa tiancaquenari: iriotaque oaneaquenari narori. Aisati inquempejeitea iriori oyearoneri novatsa, noaneajeiteri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Irootaque oca oanarontsi aniireapaintsiri inquitequi. Te onquempetearoji ora yoajeivetacaniri peerani pishanincani. Tempa icamajeitaque irinti. Yora oyearoneri oanarontsica nocantaquempiri incantaitatiyempani iraneajeitanaje irinti inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Aitaque ocanta icantajeitaqueriri Jesoshi anta pancotsiqui yapatojeitantari. Otimi anta Caperenaoqui. ");
INSERT INTO cniNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Oshequi catsini quemajeivetavacarori yoamejeivetacariri, irosati icantajeitantanaja: —Te oncameetsate oca icantiri, tecatsi ancantea anquemisantero. ");
INSERT INTO cniNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iotashitaca Jesoshi icantimentavacaajeitacaro yora yoamejeivetacari. Icantanajiri: ");
INSERT INTO cniNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","—Terica oncameetsatimotempi oca nocantaquempiri. Peerani noponeanaca narori inquitequi, natiritapaaque. Coajica pineajeitavajena nompianaje aisati jenoqui. Impoiji, ¿paita pinquenqueshirejeiteri? ");
INSERT INTO cniNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ishire Tasorentsi, irootaque oaneajeitajerineri maaroni savicajeitatsiri inquitequi. Eiro isavicajeititsi maaroni atiri. Oca nocamantaquempiri oshiavetaro Ishire Tasorentsi: ariorica pinquemisantero, ari oaneaquempi inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Niotacojeitimpi: timatsi picarajeitica caari quemisantatsine. Peerani iotitari Jesoshi caari quemisantajeitatsine. Aisati iotitacari aacanterineri coajicani. ");
INSERT INTO cniNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Icantanaqueri: —Niotaque te pinquemisantajeitenaji maaroni, irootaque nocantantaquempiri incaranqui: “Eirome inintacairime Apa, tecatsi pocashitenaneme narori”. ");
INSERT INTO cniNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Irosati yojocaarantantanajari oshequi yora yoamejeivetacari. Te meeca iroijajeitanajeriji. ");
INSERT INTO cniNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Irosati icantajeitantajanari Jesoshi: —Noamerepee, ¿aisatimpa pojocajeitanajena avirori? ");
INSERT INTO cniNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yacanaqueri Shimo Petero: —Novincatsarite, eirorica noijatimpitsi, ¿janicampa noijatanajeri? Incantaitatiyempani iraneajeitanaje inquitequi maaroni quemisantajeitirori pineane. ");
INSERT INTO cniNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Noquemisantajeitimpi, niojeitanaquempi; avirotaque itiancane Tasorentsi, picameetsataque. ");
INSERT INTO cniNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yacanajiri Jesoshi: —Tempa nocoyeajeitaquempi. Picarajeiti aca 12, iro cantaincha aparo picarajeitica, iriotaque camaaritajantsineri. ");
INSERT INTO cniNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iquenquetsatacotaqueri Jorashi Ishicariote, yora itomi Shimo. Ainiroquera icarajeivetana maaroni. Iriotaque aacanterineri Jesoshi coajicani. ");
INSERT INTO cniNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Irosati iquenantanaca Jesoshi Carireaqui. Icoaveta joriopee iroyerime, irootaque caari icoanta irijate Joreaqui. ");
INSERT INTO cniNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Irotimataintsi inquimoshirejeitanteari joriopee. Irotaintsi irovetsicajeitero pancotsijaniqui inquenqueshirejeitantearori iquenajeitanaque ishanincani caaraiteriqui. ");
INSERT INTO cniNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Irirentipee Jesoshi icantajeitiri: —Pijate meeca Joreaqui. Pinijaayetapeeri poamerepee anta paitarica pantayetiri. ");
INSERT INTO cniNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pincoaquerica iriojeitempi maaroni atiripee pinquenaquenayetanaque irineajeitantempiri. Eiro pimanirotsi paitarica pantayeteri. Ariorica pintasoncantayete, pinijaayeteri maaroni atiri. ");
INSERT INTO cniNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Te inquemisantajeiteji irirentipee iriori, ");
INSERT INTO cniNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","irootaque icantantacariri. Icantajeitanajiri Jesoshi: —Tequerata omoncarateaji nomatantearori. ");
INSERT INTO cniNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Avirojei, pijajeite avinti. Tecatsi incantea atiri inquisajeitempi avinti. Irompa nainti, iquisajeitaquena. Nocamantajeitaqueri: “Te oncameetsateji oca pantayetiri”, irootaque iquishimentaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pintoncaajeitanaquetsita avinti Joreaqui. Eirotsita nojatita narori, tequeratsita omoncarateaji nojatanteari. ");
INSERT INTO cniNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aitaque icantajeitaqueriri Jesoshi. Isavicanaji Carireaqui. ");
INSERT INTO cniNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Irinti irirentipee jajeitaintsi Joreaqui, itoncaajeitanaque, tonca, tonca. Iquimoshirejeitapaaque. Impoitanaji iriori Jesoshi, itoncaanaji, iro cantaincha te irinijaantapeempaji: te incoyeji irineeyeteri. ");
INSERT INTO cniNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Icanta joriopee iquimoshirejeitanaque. Icoajeivetacari Jesoshi Jerosarequi, icantajeiti: —¿Jaoca meeca yoranqui Jesoshi? ");
INSERT INTO cniNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Apatojeitainchari anta icantavacaajeitanaca. Icantacoyetiri Jesoshi: —Cameetsari ini. Pashini cantayetaintsi: —Te incameetsateji, irointi yamatavitiri atiri. ");
INSERT INTO cniNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Iro cantaincha itsaroacaajeitacari atiripee yora jivatacaajeitiriri, irootaque imanacojeitantacarori icantacoyetiriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yovaanajiro aisati iquimoshirejeitanaji. Itoncaanaque Jesoshi iriori ivancoqui Tasorentsi, yoametantapaaji. ");
INSERT INTO cniNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yoajeitanaque cavaco joriopee. Icanti: —¿Jaoca icantari iotantarori paitapeerica? Tecatsi oameterine. ");
INSERT INTO cniNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yacanaqueri Jesoshi: —Te naro iotashitearone oca noametimpiri, irinti iotacaanaro yora tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pincoasanoterica panteneri inintacaaquempiri, aitaque piotanaque. Piotanaque itiancaquenarica Tasorentsi. Piotanaque noneaveetashitarica. ");
INSERT INTO cniNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yora neaveetashitachari icoi impincatsayeeyeteri iriori. Intimerica coatsiri impincatsayeeyeteri tiancaqueriri, icameetsati iriori; te irioteji iramatavitante. ");
INSERT INTO cniNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Tempa irootaque icantajeitimpiniri Moishishini peerani: “Jeroca pantayeteri”. Iro cantaincha tecatsi aca matasanojeiteroneri oca icantaquempiniri. ¿Paita pisareantanari poyena narori? ");
INSERT INTO cniNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yacajeitanaqueri apatojeitainchari: —Yoitsaviantaquempi camaari. ¿Janica sareimpiri iroyempi? ");
INSERT INTO cniNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yacanaqueri: —Jero aparo notasoncantaque saavaroqui, meeca poajeitanaquena cavaco maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Icantimpiniri Moishishini: “Pintoyeantea”. Iro cantaincha caari ini Moishishini cantasanotatsine, irintiquea yora intasanotaroniri. Irootaque meeca pitoyeantantacari. Pitoyeantapinita aisati saavaroqui amaoreantari. ");
INSERT INTO cniNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tempa pitoyeantapinita saavaroqui, pimoncaratantarori isanquenatiniri. Irosati saavaroqui noavisacotantariri yora shirampari. Aiquero piquisanaitiana. ¿Paitaquea? ");
INSERT INTO cniNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ariorica pamenavoroteri pishaninca, eiro picantashitatsi: “Cameetsari ini. Yora pashini te incameetsateji”. Pijivateta piotasanoteri, impoijiquea piotanaque paitarica pinquenquetsatacoteriri. Aisati onquempetea, pinquenqueshiretasanotero nocantimpiri piotasanotantenari. ");
INSERT INTO cniNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Irosati icantayetantanaca jerosaresati aparopee: —¿Caarimpa yoca icoyeetiri iroyeeteri? ");
INSERT INTO cniNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pameneri meeca, yoametantayeti, te irimaneroji. Tecatsi cantimenterine: “Pimajerete”. ¿Yaamaajeitarimpa avincatsarite iriosanotaque yoca Quirishito? ");
INSERT INTO cniNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Iro cantaincha ayotacojeitaqueri arori jaoca iponeacari yoca. Impocasanotapaajerica Quirishito, tecatsi iotacoterine jaoca imponeempari iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yoametanti Jesoshi ivancoqui Tasorentsi, icanti: —¿Piojeitanampa? ¿Piotimpa jaoca noponeacari? Te nompocashiteaji, timatsi tiancaquenari: icameetsatasanotaque catsini. Te pioteriji avinti, ");
INSERT INTO cniNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","narori niotiri nainti. Iriotaque tiancaquenari, iriotaque noponeimotacari. ");
INSERT INTO cniNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Irosati icoajeitantavetacari iraayerime. Iro cantaincha tecatsi ayerine. Tequeratsita omoncarateaji iraanteeteariri. ");
INSERT INTO cniNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Oshequi apatojeitainchari quemisantajeitaqueriri. Icantayeti: —¿Ariorica impocapaaque Quirishito, iranaacotapeerimpa Jesoshi intasoncantayetapee? ");
INSERT INTO cniNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yora variseopee iquemajeitavaqueri atiri iquenquetsatacojeitaqueri Jesoshi. Irosati itiancantacari variria iraayerime. Iriojeitaque tiancaqueriri jivatacaajeitiriri saserotepee, variseopee aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Irosati icantantanacari Jesoshi atiri: —Capichanivaniji nontsipajeitanajempi. Irotanaintsi nompianaje tiancanariqui. ");
INSERT INTO cniNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pincoajeivetajenarica, iro cantaincha eiro pineajanatsi. Jaocarica nosavicapaaje eiro pimatirotsi pijataje avirori. ");
INSERT INTO cniNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Icantanaque jorio: —¿Jaocampa irijateri yoca eiro aneantajaritsi? ¿Ariompa irijatashiteri ashaninca savicayetatsiri pashinipeequi nampitsi? Irioyeata oamejeitapeerine itsipapee atiri. ");
INSERT INTO cniNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Jero icantaque: “Pincoajeivetajenarica eiro pineajanatsi. Jaocarica nosavicapaaje eiro pimatirotsi pijataje avirori”. ¿Paita icantantari? ");
INSERT INTO cniNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Irootaque quitaiteri ivecaratantarori iquimoshirejeitanaque. Irosati icatiantanaca Jesoshi. Icajemanaque: —Maaroni miretatsiri impocashitenata irirapeeta, ");
INSERT INTO cniNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ontimanteari ishirequi quemisantanari nija oaneantatsiri, oncontejatapaaqueri. Aitaque oquenquetsatacotiro Sanquenarentsi nija nocantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iro ishiacantaqueri nijatatsiri Ishire Tasorentsi, quiso oajeiterine quemisantajeiterine corajicani. Iro cantaincha tequeratsita iroancajeaji Jesoshi jenoqui, irootaque caariquera opocashitantari quemisantajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Apatojeitainchari ara iquemajeitavaqueri icantaqueriri Jesoshi, irosati icantayetantanaca aparopee: —Iriotasanotaque yoca camantantatsiri aamaajeitacari. ");
INSERT INTO cniNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pashini cantayetatsi: —Iriotaque Quirishito. Pashini cantatsi: —¿Ariompa imponeempari Quirishito Carireaqui? ");
INSERT INTO cniNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tempa ocanti Sanquenarentsi: “Quirishito irio irishanincatajeari Iravirini. Imponeaquea Verequi, anta isavicaveitani Iravirini peerani”. ");
INSERT INTO cniNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Impoiji icantavacaimentajeitacari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Timatsi aparopee coayevetachari irayerime, iro cantaincha te irimateroji. ");
INSERT INTO cniNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ipiajeitanaja variria. Yareetapaajari jivatacaajeitiriri saserotepee, jeri variseopee. Icantajeitavajiri: —¿Paitasa caari pamantanari aca? Nocantavetimpi incaranqui: “Pamaquenari”. ");
INSERT INTO cniNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yacanaqueri: —Cameetsa ineanati yonta shiramparinta. Cameetsa yoametanti, tecatsi pashini quempetearine. ");
INSERT INTO cniNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Icantavaqueri: —¿Yamatavitajimpimpa aisati avirori? ");
INSERT INTO cniNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Iquemisantaquerimpa jivatacairiri ashaninca arori? Te inquemisanteriji. ¿Iquemisantaquerimpa variseo? Te. ");
INSERT INTO cniNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yonta atirinta te irionirojeiteroji Sanquenarentsi. Te oncameetsateji impincatsajeiteri Jesoshi: iroasanquejeiteri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Itimaiti ara Nicoremo, ananincashitanaqueriri Jesoshi chapinqui. Itsipatavacaajeita ivariseoririnte, icantanaqueri: ");
INSERT INTO cniNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Paita ocantiri Sanquenarentsi? ¿Oshinetantampa ancantashitea: “Te incameetsateji Jesoshi”? Tempa ocameetsati ajivatavaqueri anquemisanteri incantaqueeri. Tempa ocameetsati aisati ajivataque ayote paitarica yantayetaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yacanajiri: —Aviroyeata avirori carireasati. Pineanatasanotero Sanquenarentsi piotanteari te imponeempaji Carireaqui camantantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Irosati ijajeitantanaja maaroni ivancopeequi. ");
INSERT INTO cniNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yora Jesoshi ijatanaque toncaariqui, ipajiyeetironta Orivomashi. ");
INSERT INTO cniNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Oquitaitetamanaque ipiapaaja ivancoqui Tasorentsi. Maaroni atiri ijatashijeitajiri. Isavicapaaji, yoametapaajiri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yamajeitapaaqueneri aparoni tsinane, ineetaquero aimentacari ojime. Irio amirori oametantirori Sanquenarentsi, jeri variseopee. Isatecaquero nianqui, ");
INSERT INTO cniNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","icantapaaqueri: —Oametantatsiri, ineetaquero oca aimentacari ojime. ");
INSERT INTO cniNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Peerani icantini Moishishini ocameetsati ampichanatero aimentariri ojime. ¿Paita picantiri avirori? ");
INSERT INTO cniNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ineantavetari, icoajeiveta incomitacayearime, irootaque icantantajeivetariri. Itsentetanaque Jesoshi, isanquenatantanacaro iracotsapaqui quipatsi. ");
INSERT INTO cniNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yapiivetajari: —¿Paita picantiri? Icatianaja Jesoshi. Icantajeitiri: —Timatsirica picarajeitica meeca caari antiro caari cameetsatatsi, irijivaterota impicheero; impoiji ari pimpichaajeitero maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yoivotanaja aisati. Isanquenatanaji aisati quipatsiqui. ");
INSERT INTO cniNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Maaroni quemajeitavaqueriri, ijajeitanaji. Ijivajeitanaji yora anteashiparipee, impoijeitanajiri iriori maaroni evancaripee, ijajeitanaji. Apanivaniji irinti Jesoshi, jero iroori tsinane. Irosati ocatia ara. ");
INSERT INTO cniNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Icatianaja aisati. Tecatsi irineaje, irointi tsinane apaniro. Icantiro: —¿Jaoca meeca yoranqui quisajeitaquempiriranqui? ¿Tempa intimeji quishimentempirone pantiri? ");
INSERT INTO cniNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ocantanaqueri iroori: —Te aneajeriji, novincatsarite, jajeitanaji inaji. Irosati icantantajaro: —Aisati narori, eiro noquishimentimpirotsi. Pijataje meeca, eiro papiitajirotsi caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ineanatajiri aisati Jesoshi atiri, icantajiri: —Narotaque iotacaajeitiriri atiripee, oquempetaca noquitaitetacojeitiri. Eiro iquenashiyetanajatsi tsiteniriqui oijajeitenaneri. Queario, naro iotacaajeitiriri atiripee, aisati oaneajeiterineri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Irosati icantantanacari variseopee: —Avisati camantacotashitacha. Irootaque caari otampaticatanta picantayetaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yacanajiri Jesoshi: —Je, narosati camantacotacha, iro cantaincha otampaticati nocantaqueri. Iro otampaticatantacari nioti nainti jaoca noponeacari. Aisati nioti jaoca nojatajeri. Te piojeiteji avinti jaoca noponeacari, aisati te piojeiteji jaoca nojatajeri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Piquempejeitacari pashinisati atiri: te piojeitenaji, iro cantaincha picantacoventashijeitaquena. Naintiquea, te meeca noncantacoventempiji. ");
INSERT INTO cniNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Iro cantaincha, noncantacoventempime meeca, ontampaticateme noncantacoventempime. Niotaquempi; aisati quiso yoaquena Apa tiancaquenari, iotaquempi aisati. Nocarataque apite iotasanojeitimpiri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tempa ocanti Sanquenarentsi pineanatapinitiri: “Apiterica incarate camantacoterineri ashaninca, ari paamayea queariotaque incanteri”. ");
INSERT INTO cniNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ari nocamantacotaja narosati, icamantacotana Apa tiancaquenari iriori; apite nocanta. ");
INSERT INTO cniNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Icantanaqueri: —¿Jaoca meeca piri? Yacanajiri Jesoshi: —Te piotenaji. Te piojeiteriji aisati Apa. Ariorica piojeitaquename piotaquerime aisati Apa iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Irootaque icantajeitaqueriri Jesoshi anta ivancoqui Tasorentsi. Icatianaja anta ipapinijeitirinta Tasorentsi quirequi. Tequera omoncarateaji incamanteari Jesoshi, irootaque caari imatanteetari irayeeteri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yapiitajiri aisati: —Irotimataintsi nojataje. Pincoacoajeivetajena pineajename aisati, iro cantaincha eiro pineajanatsi. Irotaintsi nojataje. Pincoajeivetea poijajeitena, iro cantaincha eiro pimajeitirotsi pijajeitaje nojatajenta narori. Irosati pincanteani pantapinijeitero caari cameetsatatsi irosati pincamanteari, irootaque pijajeitanteari Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Icantajeitanaque jorio: —Irisatiyeata oajanchane. Piquemaquerinea icantantari: “Irotaintsi nojataje, eiro pimajeitirotsi pijajeitaje nojatajenta narori”. ");
INSERT INTO cniNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Icantajiri Jesoshi: —Avirojeitaque timajeitatsiri quipatsiquica. Noponeaca nainti jenoqui. Aca quipatsiquica irootaque pisavicantajeitari avirori. Te nosavicasanote narori quipatsiquica. ");
INSERT INTO cniNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Irootaque nocantantaquempiri incaranqui: “Irosati pincanteani pantapinijeitero caari cameetsatatsi irosati pincamanteari”. Eirorica piquemisantirotsi nocantaquempiri, irootaque pijatanteari Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Isampitajiri: —¿Janicampimpa? Icantanajiri iriori: —Aitaque nocamantasanovetaquempi. ");
INSERT INTO cniNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Timatsi oshequi noncamantempimeri; otimi aisati pantayetiri noncantacoventantempimeri. Iro cantaincha icameetsataque tiancaquenari, timatsi icamantaquenari iriori: irootaque oca novaaqueneriri atiri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Te iriojeiteriji joriopee irio iquenquetsatacotaqueri Jesoshi Iriri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Icantanajiri Jesoshi: —Ariorica poatiacotaquena, aitaque piojeitanaquenari. Piojeitena noponeanaca inquitequi, natiritapaaque. Aisati piojeitanaque tecatsi nantashitea nainti. Noneanatiro oca yoametaquenari Apa tiancaquenari, ");
INSERT INTO cniNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","quiso yoana iriori. Irosati nantiniri narori paitarica inintacaaquenari iriori, irootaque caari yojocantana. ");
INSERT INTO cniNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Aitaque ocantari icantaqueriri. Icarati oshequi quemisantajeitanaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Irosati Jesoshi icantajeitantanajari joriopee quemisantajeivetacariri: —Ariorica pincantaitatiyempani pishiretearo noneane, avirosanojeitaque noamere. ");
INSERT INTO cniNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aitaque piotavaquero queariotatsiri. Irootaque oipacaacoventajempineri. Eiro itimajitsi peranatajempineri aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yacanaqueri: —Narojeitaque ishanincani Avaramani. Tecatsi peranatenane. ¿Paitasa picantantanari: “Oimpacaacoventajempi queariotatsiri”? ");
INSERT INTO cniNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yacanajiri Jesoshi: —Queariotaque oca noncamantempiri. Timatsi peranajeitariri maaroni antajeitirori caari cameetsatatsi. Ora caari cameetsatatsi yantapinijeitiri, oshiavetacari peranajeitariri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Yora peranarontsi eiro icantatiani irisavicasanote ivancoqui peranatariri. Irintiquea itomi ashitarori ivanco incantatiyempani irisavicasanote irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Narotaque itomi Tasorentsi. Ariorica noimpacaacoventajempi, eiro yapiiyeetajimpitsi iromperanayeetajempi. ");
INSERT INTO cniNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Niotasanojeitaquempi, avirojeivetaca ishanincani Avaramani. Iro cantaincha te pinquemisanteroji noneane. Irootaque pisareantanari poyena. ");
INSERT INTO cniNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ora icamantaquenari Apa, irootaque nocamantajeitimpiri. Ora icantimpiri pirintajeitari irootaque pantapinijeitiri avirori. ");
INSERT INTO cniNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yacanaqueri: —Nirintajeitacari Avaramani. Icantanajiri Jesoshi: —Avirome ishanincani Avaramani, aitaque pinquempejeitajearime. Iquemisantini peerani iriori; pishanincataquearime, pinquempejeitaquearime avirori, pinquemisantajeitaquename. ");
INSERT INTO cniNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Narotaque neanavetarori queariotatsiri noquemiriri Tasorentsi. Iro cantaincha pisareajeitana poyena. Te inquempeteaniji irinti Avaramani. ");
INSERT INTO cniNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pantapinijeitiro avinti yantayetiri pirintasanotari. Irosati icantajeitantanacari: —¿Pashinimpa ashitana? Apaniro ini nirintajeitari. Iriotaque Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Icantajeitaqueri Jesoshi: —Irioricame pirintajeiteame Tasorentsi aitaque pinintajeitaquename narori. Te nompocashiteaji; aitaque noponeacari Tasorentsiqui, iriotaque tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Paita caari piotantavacaro nocantimpiri? Te pimateroji pinquemisantero noneane. ");
INSERT INTO cniNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Camaari ini pirintajeitacari. Irootaque picoantajeitacari pantapinijeitiniri inintacaajeitimpiri. Oantatsiri ini peerani: irio nijantirori yoanti. Te inquenqueshireteroji quearioyetatsiri, irootaque caari icameetsatanta. Tseeyari ini, irootaque itseeyantacari. Yashi yoiro itseeya. Iriotaque tseeyacaayetariri atiri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Irompa nainti nocamantavetaquempiro queariotatsiri, te pinquemisantenaji. ");
INSERT INTO cniNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Timatsimpa aca neaquenari narori nantiro caari cameetsatatsi? Tempa otampaticati nocantajeitaquempiri. ¿Paitampa caari piquemisantantana? ");
INSERT INTO cniNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Maaroni itomintajeitari Tasorentsi, iriojeitaque quemisantajeitirori irineane. Te intomintajeitempiji avirori. Irootaque caari piquemisantantaro irineane. ");
INSERT INTO cniNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Irosati yacantanajari jorio: —Queariotaque nocantaquempiri. Avirotaque samariasati, yoitsaviantaquempi camaari. ");
INSERT INTO cniNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yacanajiri: —Te nontsaviateji. Nopincatsatiri Apa. Irompa avinti te pimpicatsajeiteriji; pitseencajeitiri avinti. ");
INSERT INTO cniNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Te noncoyeji impincatsayeetena nainti. Irintiquea Apa coaintsi impincatsayeetena. Aisati iriotaque cantacoventajeiterineri maaroni tseencajeitanari. ");
INSERT INTO cniNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Queariotaque oca nocantimpiri. Quemisantavaquerori noneane eiro icamanetajitsi. ");
INSERT INTO cniNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Irosati icantantanajari joriopee: —Meecaquea niotasanojeitaquempi pitsaviataque. Camaque Avaramani. Aisati camantantatsiniri, camajeitaque iriori. Aiquero picanti: “Eiro icamitsi quemisantajeitirori noneane”. ");
INSERT INTO cniNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Camaque ashanincani Avaramani. Camajeitaque iriori camantantatsiniri. ¿Arimpa pijipincatsaritashitaca? ¿Pijivetampa panaacojeitiri maaroni peeraniniri pipincatsaritasanotaque avinti? ");
INSERT INTO cniNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yacanajiri Jesoshi: —Narosatiricame jitashitachaneme nopincatsaritaque, tempa nantsipetearome. Apa, yora picantajeitiri avirori: “Notasorentsite”, iriotaque pincatsaritacaaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Te piojeiteriji. Nainti niotiri. Ariorica noncantaqueme narori: “Te nioteriji”, aitaque nonquempetaquempime, nontseeyaqueame narori. Irompa niotiri. Noquemisantiro irineane. ");
INSERT INTO cniNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Icamantacotaquenani pishanincani Avaramani, icantini: “Coajica ontime quitaiteri noneanteariri Quirishito, irootaque noquimoshiretantacari”. Ari ineaquena, irosati iquimoshiretasanotantanacari aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Icantanaqueri jorio: —Tequeratsita oncarate pisarintsite 50. ¿Piniirimpa Avaramani? ");
INSERT INTO cniNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Icantanajiri Jesoshi: —Queariotaque oca noncamantempiri. Tequeratsitani intimeni iriori Avaramani, notimitani nainti. Je, noneiri. ");
INSERT INTO cniNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Irosati yaantajeivetanaca mapi, impichaajeiterime. Iro cantaincha ipeapitsajeitanajari ivancoqui Tasorentsi, ineacotashitapaaja jaocarica anta. ");
INSERT INTO cniNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ari iquenanaque anta Jesoshi. Ineapaaqueri aparoni shirampari quitapoajari. Aitaque icantitapaani iroaquera itimapaaque. ");
INSERT INTO cniNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nocarajeitiri iroamerepee nosampijeitiri: —Oametanari, ¿paitampa itimantapaari quitapoajari? ¿Irompa yantayetiro caari cameetsatatsi ashitariri iquitapoajatantacari itomi? ¿Irioricampa yoca antaquerori caari cameetsatatsi iquitapoajatantacari? ");
INSERT INTO cniNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yacanaqueri Jesoshi: —Tecatsi irante, iquitapoajatashitaca. Aisati ashitariri, tecatsi irante. Iro iquitapoajatantacari yoca intasoncacoventantajeariri Tasorentsi. Icoacaajeitaqueri atiri iriojeitanaque queario itasorentsitaque. Ainiroquera meeca oquitaiteti. ");
INSERT INTO cniNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ocameetsatimotana nanteneri meeca tiancanari inintacaanari. Ariorica ontsitenitanaje, tecatsi matajerone irantaveetaje. ");
INSERT INTO cniNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ainiroqueratatsina quipatsiquica narotaque iotacaajeitaqueriri atiri. ");
INSERT INTO cniNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Irootaque icantaqueriri, irosati iquitiojantanacaro quipatsi. Ocajavatsatanaque oca iquitiojaqueri quipatsi, irosati ipatsancajaquitantacari quitapoajari. ");
INSERT INTO cniNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Icantajiri: —Pijate anta Shiroequi, pinquivajaquitajantea. Incajare oni Shiroe. Acanti aneanequi arori: Itianqueetiri. Irosati ijatantanaca, iquivajaquitapaaca. Ipiaja, amenanaji ini. ");
INSERT INTO cniNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Itimi ara inampiquiniri, aisati yora neapinitiriri yamanantapiniti quirequi. Icantajeitanaque: —¿Caarimpa yoca yoranqui savicapinitatsiri amanantapinitatsiri quirequi? ");
INSERT INTO cniNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aparopee cantayetanaintsi: —Iriotaque. Pashini cantayetatsi: —Caari ini. Shiavetariri ini. Icantanaque iriori: —Narotaque. ");
INSERT INTO cniNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Icantaqueri: —¿Jaoca icanteetajimpiri pamenantajari? ");
INSERT INTO cniNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yacanaqueri iriori: —Yora shiramparinta pajitachari Jesoshi icajavatsataquero quipatsi, ipatsancajaquitantajanaro noquiqui. Icantajana: “Pijate Shiroequi, pinquivajaquitajantea”. Nojatanaque, noquivapaaja; irosati namenantanaja. ");
INSERT INTO cniNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Irosati icantantanajari: —¿Jaocariqueame iriori? Yacanajiri: —Jaocarica, te nioteji. ");
INSERT INTO cniNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Irootaque saavaro icajavatsatantacarori Jesoshi quipatsi yamenacantajariri quitapoajaveitachaniri. Iro saavaro imaoreanteevetari. Ari yayeetanaqueneri variseopee, ");
INSERT INTO cniNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","isampitavaqueri: —¿Jaoca icantajimpiri? Icantiri: —Ipatsancajaquitaquena quipatsi noquiqui, irosati nojatantanaca noquivajaquitaja. Meeca namenanaji. ");
INSERT INTO cniNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Irosati icantantanaca variseo aparopee: —Yora shirampari yantaveetantaro saavaro. Te imponeempaji Tasorentsiqui. Pashini cantayetatsi: —Irioricame antayetirori caari cameetsatatsi, eiro imatirome intasoncantayeteme. Irosati icantavacaimentantajeitanacari. ");
INSERT INTO cniNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yapiitajiri isampitajiri: —¿Paita pijitiri avirori yora amenacaajimpiri? Icantanaqueri: —Nojitiri itiancane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yora joriopee te irishiretearoji iquitapoajaveitani. Icajemacantaqueri iriri, jero iriniro, ");
INSERT INTO cniNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","isampitavaqueri: —¿Iriotaquempa yoca pitomi picantiriranqui: “Itimapaaque quitapoajari”? ¿Jaoca icantajari yamenantajari meeca? ");
INSERT INTO cniNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yacanaqueri: —Je, iriotaque notomi. Noneasanotiri yashi yoiro iquitapoajatapaaque. ");
INSERT INTO cniNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jaocarica icantajari yamenantajari, te nioteji narori. Te nioteji aisati janicarica amenacaajiriri. Te irijananequitajeji meeca. Pisampiteri iriori. Irisati camantacotajanchane. ");
INSERT INTO cniNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yora ashitariri itsaroacaacari joriopee, iotaque aitaque yapatotimentajeitacari Jesoshi. Icantajeititaca: “Intimerica cantatsine: ‘Iriotaque Jesoshi Quirishito’, eiro ashinetajiritsi irinti intsipajeitee anquemisantajeite”. Irootaque itsaroajeitantanacari ashitariri, ");
INSERT INTO cniNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","irootaque icantantanacariri: “Te irijananequitaje meeca notomi. Irio pisampite”. ");
INSERT INTO cniNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ari yapiitajiri icajemajiri. Icantavaqueri: —Tasorentsi pimpincatsate. Yora shirampari niojeitiri irio antayetirori caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Irosati yacantanacari iriori: —Irioricampa antayetirori caari cameetsatatsi, te nioteji narori. Apatiro niotaque noquitapoajaveitani, meeca namenanaji. ");
INSERT INTO cniNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Icantanajiri aisati: —¿Jaoca icantajimpiri yamenacantajimpiri? ");
INSERT INTO cniNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yacanajiri iriori: —Aitaque nocamantavetaquempi incaranqui, iro cantaincha te pinquemisanteroji piquemavetaquenari. ¿Paita picoantari aisati pinquemajero? ¿Picoajeitajimpa avirori pimpeajeitajea iroamere? ");
INSERT INTO cniNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Irosati iquisatsatantanacariri, icantanaqueri: —Avironirotaque avinti iroamere. Naro nainti iroamerepeeni Moishishini. ");
INSERT INTO cniNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Niojeiti iquenquetsatacaaquerini Tasorentsi Moishishini peerani. Irompa yoranqui, te niojeiteriji jaocarica iponeacari iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yacanajiri iriori: —Iriotaque amenacaajanari. Piojeiteriquetite avirori jaocarica iponeacari, irootaque noantanaquempiri cavaco. ");
INSERT INTO cniNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ayotacojeitiri Tasorentsi, te inquemeriji antayetirori caari cameetsatatsi. Yora quemisantiriri Tasorentsi, antirori inintacaaqueriri, iquemapinitiri irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Te anquemacotapiniteriji amenacayerine timapaatsiri quitapoajari. ");
INSERT INTO cniNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Eirome iponeame Tasorentsiqui, tecatsi irimateme. ");
INSERT INTO cniNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yacanajiri: —Peerani pitimantapaacari te pincameetsatapeeni. ¿Arimpa picoaque meeca poamejeitena? Irosati yojocantanajari. ");
INSERT INTO cniNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iquemacotajiri Jesoshi yojocajeitaqueri quitapoajaveitachaniri. Impoiji ineapaajiri aisati, icantapaajiri: —¿Piquemisantirimpa Atiritapaintsiri? ");
INSERT INTO cniNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ari yacanaqueri: —¿Jaoca itimiri, apa? Nonquemisanteri. Yacanaqueri: ");
INSERT INTO cniNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Tempa narotaque: noponeanaca inquitequi, natiritapaaque. Pineaquena, meeca noneanataquempi. ");
INSERT INTO cniNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Icantanaqueri: —Noquemisantimpi, Novincatsarite. Itiyeroashitanacari. ");
INSERT INTO cniNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Icantiri Jesoshi: —Irootaque nopocantacari quipatsiqui noncantajeitanteariri atiri jaoca incantajeiteari. Namenacaajeitajeri quitapoajavetachari. Yora amenajeivetachari nonquempetacantajeri quitapoajatatsiri. Pineaquero, niotacaajeiteri caari iojeitatsi; irinti iovetachari nompeapitsatajeri iotantavetari. ");
INSERT INTO cniNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yora variseopee itsipajeitacari, iquemajeitavaquero icantaqueriri. Irosati icantajeitantanaca aparopee: —¿Jaocampa nocantajeitari narori? ¿Noquitapoajatimpa? ");
INSERT INTO cniNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yacanajiri Jesoshi: —Pinquitapoajateme, eiro otimime pantane; iro cantaincha picantajeiveta: “Namenajeiti”, irosati picantani pantapinijeitiro caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Aisati yoametanti Jesoshi, icanti: —Queariotaque oca noncamantempiri. Tempa yoiminqueapinitiri ashitariri irovishate itantoqui iquempoyeantariri. Yora coshitiriri irovishate, te inqueapeeji omoroqui, ainti yataitashitapaaqueri araquerora. Icanti: “Ineanacari ashitariri”. ");
INSERT INTO cniNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","3","Intimerica iratirite shentiniriri omoro, ariorica impocapaaque irinti ashitariri, ari irashireavaqueneri, irishineteri iravisanaje. Ariorica inqueashitapaajeri, incajemapeeri ivajiropee, ari impocashijeiteri, eiro itsaroacaavacaritsi. Impoiji iraajeitanajeri anta paashitomashiqui, ");
INSERT INTO cniNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","irijivatanaqueri. Ari iotsajeititiri irineane, irootaque yoijajeitantariri. ");
INSERT INTO cniNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ariorica incajamaveteari caari ineapiniti, eiro iotsajeititavaqueritsi irineane. Eiro yoijajeitiritsi, aintiquea irishiapitsajeitanaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Aitaque ocantari ishiacaaventaqueneriri Jesoshi, iro cantaincha te iriojeitavaqueroji icantavetacariri. ");
INSERT INTO cniNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Icantajeitaqueri aisati: —Queariotaque oca noncamantempiri. Narotaque shiacaventachari omoro tantorentsi iqueapinitantari ovisha. ");
INSERT INTO cniNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Maaroni jivajeitaquenari, coshinti ini irinti, coshitantatsiri; irootaque caari iquemisantajeitantari ovishapee. ");
INSERT INTO cniNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Narotaque iqueapinitantari, nareetacaajeiteari maaroni pocashijeitenane. Iriojeitaque avisacotajantsine. Inqueapinijeite, aisati irijatashitapinitero iroyeari. ");
INSERT INTO cniNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ipocashitiri coshinti icoshiteri ovisha, iroyeri, impoyereeri. Irompa nainti, nopocashitiri naneacaajeiteri oijajeitenaneri, naneacaasanojeitajeri inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Narotaque ashitariri cameetsari, irootaque nocoantacari noncamimenteri novishate. ");
INSERT INTO cniNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Te nonquempeteariji oisantiniriri ashitariri. Caari ini ashitariri ovisha. Ariorica irineavaqueri maniti impocapaaque, intsaroanaque, irishiapitsatanaqueri; irojocanaqueri ovishapee. Irosati iraantapeempariri maniti ovisha, irovarayetapeeri. ");
INSERT INTO cniNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Aitaque icantari oisantiniriri irovishate. Te inquenqueshireteriji ovisha, irinti iquenqueshireti quirequi impinayeeteri, irootaque ishiantanacari. ");
INSERT INTO cniNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Narotaque ashitariri cameetsatatsiri. Niotiri novishate. Yora nashijeitacari iojeitaquena iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Aisati iquempeta Apa, iotaquena; aisati niotiri narori. Coajica noncamimentajeiteri novishate noavisacotanteariri. ");
INSERT INTO cniNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ainiro aisati pashini, tequerata noviratajeari aca. Iriojeitaque nampatojeitajeri. Ariorica noneanateri iriotsatavaquena, inquempeavacantajeitajeari novishatepee maaroni. Apaniro nashijeitajeari maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Aisati icanti Jesoshi: —Noncamimenteri novishate, irosati naneantajeari. Irootaque inintacaanari Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tecatsi matashitenaneme iroyename, irointiquea nocoasanotaque noncamimenteri novishate. Noncamavetaquea, aisati nontinaanaje: irootaque inintacaaquenari Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aitaque ocantari icantaqueriri Jesoshi. Irosati icantavacaimentajeitanacari joriopee. ");
INSERT INTO cniNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Timatsi icarajeiti oshequi cantayetatsiri: —Yoitsaviantaqueri camaari. Ishinquiventaitia. ¿Paita piquemisantantariri? ");
INSERT INTO cniNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Icanti itsipapee: —Te intsaviateji: tempa cameetsa yoametanti. Caari ini camaari: tempa icavintsaajiri quitapoajari, irootaque yamenacantajariri. ");
INSERT INTO cniNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iquimoshirejeitaji aisati joriopee Jerosarequi. Iquenqueshiretajiro yoameetsayeetantajaroniri peerani ivanco Tasorentsi. Opariantsitapaaji. ");
INSERT INTO cniNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yaniiveeti Jesoshi anta oveshintsayetacanta otincamipee pancotsi. Iro yovetsicacantiniri peerani Saromoni. ");
INSERT INTO cniNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yapatojeitashitapaacari joriopee. Icantapaaqueri: —Peerani pimanapitsataquenaro. Pincamantasanotena: ¿avirompa Quirishito? ");
INSERT INTO cniNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yacanajiri: —Aitaque nocamantajeivetaquempi. Iro cantaincha te pinquemisantavaquenaji. Paitarica nomayetaqueri, iriotaque Apa tiancanari matacaaquenarori. Oca nomayetaqueri, irootaque iotacayetempineri narotaque Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Aitaque nocantaquempi: “Avirojeitaque caari novishate, irootaque caari piquemisantantana”. ");
INSERT INTO cniNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Novishate iquemisantiro noneane. Niojeitiri, aisati iriori, yoijajeitana. ");
INSERT INTO cniNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aitaque naneacaajeitajiri. Incantaitatiyempani iraneanaje inquitequi. Eiro yashinoncaajatsi. Noquempoyeasanotaqueri, oquempetimotaquena najiricaqueri. Tecatsi aapitsatajenarine. ");
INSERT INTO cniNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Icantaquena Apa: “Pinquempoyeajenari”. Yanaacojeitiri maaroni itasoncantasanoti, tecatsi aapitsatajerine aisati iriori Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nomoncaratasanotacari Apa, imoncarataquena iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Irosati yaantajeivetanaca mapi impichaajeiterime. ");
INSERT INTO cniNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Icantanajiri Jesoshi: —Iriotaque Apa tasoncacaaquenari. Oshequi nonijayetaquempiro. ¿Paita pimpitseimentenari? ");
INSERT INTO cniNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Icantanajiri: —Te iro nompitseimentempi pantiri cameetsatatsiri. Aviro shirampari, iro cantaincha pijitasorentsitashitaca, irootaque nompitseimentempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yacanajiri Jesoshi: —Tempa isanquenayeetinirini atiri: “Noncamantajeitempi: ‘Avirojeitaque tasorentsitatsiri’ ”. ");
INSERT INTO cniNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yora isanquenatiniri irineane Tasorentsi, icanteetiri: “Tasorentsitatsiri”. Tecatsi ancantero ampashinitajero Sanquenarentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Inintacaaquena Apa, irootaque itiancantaquenari aca quipatsiquica. Incaranqui nocantaquempi: “Narotaque Itomi Tasorentsi”. ¿Paita meeca picantantanari: “Pijitasorentsitashitaca”? Itasoncantaque Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Terica nonquempeteari eiro piquemisantanatsi. ");
INSERT INTO cniNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Irompa noquempetacaririca, pinquemisantajeitena. Eiro piquemisantashitanatsi narori, irointi pinquemisantimentenaro nomayetaqueri. Pinquemisante, piotanteari iquempetaquena Apa. Aisati narori noquempetacari Apa. Piotasanotavaquero. ");
INSERT INTO cniNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Icoasanojeivetanaja aisati irayerime, iro cantaincha ipeimotanacari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ari imonteanajaro aisati Jesoshi Jorirani. Ijataji anta intacaronta peerani Joani ivaotisatantaqueni. Aitaque itimapaajiri anta. ");
INSERT INTO cniNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Oshequi pocashijeitajiriri aisati. Icantajeitapaaji: —Te intasoncanteji irinti Joani, iro cantaincha queario oni maaroni icantacotaqueriri Jesoshica. ");
INSERT INTO cniNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Oshequi quemisantajeitavaqueriri Jesoshi anta. ");
INSERT INTO cniNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Isaviqui Vetaniaqui shirampari pajitachari Irasaro, yojoquiitaca. Osaviqui aisati ivancoqui iritsiropee: jero Maria, jero Marita. ");
INSERT INTO cniNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Chapinqui osaitiri Maria Avincatsarite iitiqui. Iro osaitantari casancajari. Oshetantajari oishi aisati. Ari yojoquiitaca ojariri, ");
INSERT INTO cniNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","irootaque otiancantacariri camanterine Jesoshi. Arejiqui ijatashitaqueri. Ineantapaacariri icantapaaqueri: —Novincatsarite, yora Irasaro pinintasanotiri, yojoquiitaca. ");
INSERT INTO cniNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iquemavaqueri Jesoshi, icantavaqueri: —Yojoquiivetaca, iro cantaincha eiro icamasanotitsi. Iro yojoquiitantacari, icoaque Tasorentsi impincatsatanteeteariri, aisati impincatsatanteetenari narori. ");
INSERT INTO cniNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesoshi inintiro iroori Marita, ireento, jeri ojariri. ");
INSERT INTO cniNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ari iquemacotitacari yojoquiitaca, iro cantaincha apite quitaiteri isavicanaque. ");
INSERT INTO cniNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Irosati icantantajana aisati icantajeitiri itsipapee iroamerepee: —Tsame ampiajeitanaje aisati Joreaqui. ");
INSERT INTO cniNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nocantanaqueri narori: —Chapinqui, oametanari, anta impichaaquempime ashanincapee. ¿Ariompa pimpiashitanajeri aisati anta? Eiro ajatitsi: yoicari. ");
INSERT INTO cniNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yacanaquena: —Noshiacantempiro. Icontetapaaque catsirincaiteri, iquitaitetacotapaajee. Ariorica inquianaje, ari ontsiteniiteanaje. Yora aniitatsiri quitaiteriqui, iniiro oquitaiteti quipatsiqui, irootaque caari itsitincanta. ");
INSERT INTO cniNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Iro cantaincha itsitincajeita aniitatsiri tsiteniriqui. Iro itsitincantacari, tecatsi quitaitetacoterine. ");
INSERT INTO cniNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aitaque icantaquenari. Irosati icantantanari: —Maanaqueyea Irasaro. Nojate meeca noncaocapaajeri. ");
INSERT INTO cniNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nocantanaqueri: —Maanaquerica, Novincatsarite, aitaque iravisacotaje. ");
INSERT INTO cniNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iro cantaincha, irointi iquenquetsatacovetacari Irasaro, icamaque. Narori, nojitashivetaca iro icantaquenari: “Imaashita, irimaoreanteari”. ");
INSERT INTO cniNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Irosati icamantasanotantajanari: —Camanaque Irasaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Te nontsipatavaqueariji narori. Meeca pinquemisantajeitanaquena, irootaque noquimoshiretantanacari. Tsame amenajeitaiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yora Tomashi ipajiyeetiri Tsipari, icantajeitana: —Tsame aijajeitanaqueri, iroavaqueeta arori. ");
INSERT INTO cniNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Irotimataintsi inampini Irasaro. Niojeitaque icaratacotaque otsipasati quitaiteri yoiminqueantacariri Irasaroni omoroqui imperita. ");
INSERT INTO cniNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ora Vetania oquempejitaro Jerosare, ocarati 3 quirometero. ");
INSERT INTO cniNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Iponeanaca Jerosarequi oshequi joriopee pocashitirori Marita, jero Maria. Icantapaaquero: —Eiro poashiretacoshirearitsi pijaririni. ");
INSERT INTO cniNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Oquemacotavaqueri Marita quempejitapaaque Jesoshi. Osoquijanaque, ojataque otonquiotavacari. Irointi Maria, ainiro osaviqui pancotsiqui. ");
INSERT INTO cniNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ocantavaqueri Marita Jesoshi: —Ariorica pintimaiteme aca, Novincatsarite, eiro icamime jaijini. ");
INSERT INTO cniNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Niotaque meeca paitarica pincanteriri Tasorentsi aitaque inquemisantaquempi. ");
INSERT INTO cniNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Icantanaquero Jesoshi: —Aitaque intinaaje pijaririni. ");
INSERT INTO cniNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ocantanajiri aisati: —Ariorica omoncaratapaaquea intinaajeitantanajeari camajeitaintsiri, aitaque intinaanaje iriori jaijini. Niotaquero. ");
INSERT INTO cniNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Icantanajiro: —Narotaque tinaajeitajerineri camajeitaintsiri, oaneajeitajerineri aisati. Incamajeivetaquea quemisantanari, iro cantaincha iraneanaje aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Maaroni aneajeitatsiri, inquemisantenarica iriori, eiro icamasanotitsi. ¿Pishiretacarompa oca nocantaquempirica? ");
INSERT INTO cniNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ocantanajiri: —Je, Novincatsarite, niotaquempi, avirotaque Quirishito, Itomi Tasorentsi pocaintsiri quipatsiquica. ");
INSERT INTO cniNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Irosati opiantanaja ocajemiro ireento. Ocamantatsatapaaquero: —Areetapaaca Oametantatsiri, icajemacantaquempi. ");
INSERT INTO cniNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ocantiro: —Ari. Intsipaite ocatianaca, ojatashitanaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tequeratsita irareetea iriori nampitsiqui. Ainiroqueratatsi anta oneaitirinta Marita. ");
INSERT INTO cniNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ari ineajeitavaquero quivantajeitirori ojatanaque, irosati yoijajeitantanacaro. Ijijeivetaca ario ojateri omoroqui yoiminqueetaquerinta ojaririni. Aisati ijijeitiro ojate iraacotajeari aisati anta. ");
INSERT INTO cniNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ari oneapaaqueri Jesoshi, ojatashitiri, otiyeroashitapaacari. Ocantapaaqueri: —Ariorica pintimaiteme aca, Novincatsarite, eiro icamime jaijini. ");
INSERT INTO cniNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ineavaquero Jesoshi iraimotapaacari. Iraajeitaca joriopee tsipajeitarori. Irosati icantashiretantanacari iriori Jesoshi, yoashiretanaca. ");
INSERT INTO cniNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Icantanaque: —¿Jaoca poaqueriri? Icantanaqueri: —Anta, Novincatsarite, noaqueri omoroqui. Tsame pamenaiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","36","Iraapaaca Jesoshi iriori. Irosati icantantanaca jorio: —Pineaqueri, oshequi inintasanovetarini. ");
INSERT INTO cniNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Timatsi aparopee cantatsiri: —¿Caarimpa yoca amenacaajiriri quitapoajari? Intimeme aca, ¿eirompa aisati yoavisacotajirime Irasaroni, eiro icamime? ");
INSERT INTO cniNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Icantashiretasanotanaji Jesoshi aisati. Iquempejitapaacaro omoro, ora imorotashiyeetaqueriri imperitaqui. Yashitacoyeetantacari mapi. ");
INSERT INTO cniNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Icantapaaque Jesoshi: —Pintivironcajero mapica. Ocantanaqueri Marita: —Novincatsarite, otsipasatitanaque quitaiteri icamantacari. Shititanaque. ");
INSERT INTO cniNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Icantanajiro: —Tempa nocantaquempi: “Pinquemisantaquenarica aitaque pineaquero intasoncante Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Irosati itivironcanteetajaro mapi. Yamenanaque Jesoshi jenoqui, icantanaque: —Ariove, Apa, niotaque piquemaquena. ");
INSERT INTO cniNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Niotaque irosati picanta piquemapinitana. Jeri oshequi catiimojeitanari. Nocoaque iriojeite pitiancaquena, irootaque noquenquetsatacantimpiri. ");
INSERT INTO cniNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Irosati icajemasanotantanaca: —Irasaro, pintinaanaje, pimpocaje. ");
INSERT INTO cniNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Irosati isoquijantanaja camavetainchari. Ora chapinqui yoisotanteetavacariri tocoyatsa: iracoqui, iitiqui, maaroni. Ipashicavorotanteetavacariri paanio. Icantiri Jesoshi: —Poisoreajeri, pishineteri irijataje. ");
INSERT INTO cniNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Joriopee, yora tsipajeitacarori Maria, ineacojeitaqueri Jesoshi. Oshequi quemisantajeitanaqueriri; ");
INSERT INTO cniNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","itsipapee ijatashitaqueri variseopee, icamantacotapaaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yora jivatacaajeitiriri saserotepee, jeri aisati variseo, yapatojeitaqueri pincatsaripee oametavacaajeitainchari. Icantavacaajeitaca: —¿Paita antajeiteri? Yora shirampari oshequi itasoncantapinitaque. ");
INSERT INTO cniNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ariorica ashinetajeri aisati, ario inquemisantajeitanaqueri maaroni atiri; impoiji ipocashijeiteecari oromasati, itireayetirocari ivanco Tasorentsi. Ipoyereajeiteecari, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Itsipajeitari anta Caijashi iriori. Meeca osarintsi ipincatsariventiri saserotepee. Icantanaque iriori: ");
INSERT INTO cniNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","—Tecatsi piojeite avinti. Te pinquenqueshireempaji. Pamenajeite: ocameetsatimojeitee incameta shiramparinta aparoni, iroavisacojeitantajeeri eiro apoyereajeitantatsi. ");
INSERT INTO cniNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Te incantashitearoji oca. Iriotaque pincatsariventajeitiriri maaroni saserotepee. Yoametiri Tasorentsi, iotantacari incamimentajeiteri Jesoshi maaroni joriopee. ");
INSERT INTO cniNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Te apaniro incamimentajeiteri joriopee, irointi incamimenteri maaroni atiri intomintajeiteari Tasorentsi. Inashijeiveta, isavicajeiti nampitsipeequi arejipeequiniri, iro cantaincha incamimenteri irampatojeitanteariri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Irosati isareajeitantacariri iroyeri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Irootaque caari meeca iquenapinitantaja Jesoshi anta yoshequitinta joriopee, te ironijaapeempariji. Ijatanaji quipatsiqui pajitachari Ejerai, otsapitapaacanta caaraiteri. Aitaque isavicapaajiri, icarajeitana, aisati maaroni itsipapee iroamerepee. ");
INSERT INTO cniNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Irotimataintsi Yavisantaniri, inquimoshirejeitanaque noshanincapee. Meeca itoncaajeitanaque Jerosarequi iroameetsatantajeari, inquemisantanteariri Tasorentsi. Ijajeitanaque maaroni savicajeitatsiri jaocarica, ");
INSERT INTO cniNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","icoajeitapaajiri Jesoshi. Iqueajeitapaaque ivancoqui Tasorentsi, icantavacaajeitapaaja: —Paamaaca, ¿ari impoque Jesoshi? Eirorica ipoquitsi iriori inquemisante. ");
INSERT INTO cniNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aitaque icantacantaque jivatacaajeitiriri saserotepee, jeri variseopee: —Piotaqueririca jaocarica inaqueri Jesoshi, pincamantenata. Icoajeitanaque iraacanteri. ");
INSERT INTO cniNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ocaranivani 6 quitaiteri inquimoshireventearo Yavisantaniri. Yareetaja Jesoshi Vetaniaqui, anta isaviquinta Irasaro camavetainchari: yora yoitinaajiri Jesoshi, yoaneajiri. ");
INSERT INTO cniNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Aitaque icarajeitiri Irasaro Jesoshi, yoajeita. Marita irootaque amacoyetiniriri yoari. ");
INSERT INTO cniNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria amaqueneri Jesoshi casancajari, cameetsajatasanotatsiri. Opinatasanotaca. Quejitsi oni, ojaacaro voteyajaniqui. Osaitiri iitiqui, irosati oshetantajari oishi. Otimanaque ojencaare, otsoteanaquero maaroni pancotsi. ");
INSERT INTO cniNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ari itimaiti ara Jorashi Ishicariote. Iroamere Jesoshi inaveta, iriotaque aacanterine coajicani. Icantanaque: ");
INSERT INTO cniNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Paitampa caari pipimantantaro casancajarica? Opinaveta 300 tenario, ampayetajerimeri iriori ashinoncaincari. Paparajatashitacaro maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Icantashita: te irineshinoncateriji ashinoncaincari. Iquempoyeajeivetanari noirequite maaroni, iro cantaincha coshinti ini. Ari icoshitaarantitavajanari, irootaque iquishimentantarori te omperiji ovinaro casancajari. ");
INSERT INTO cniNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Icantiri Jesoshi: —Oncanteata. Iotaque noncame, irootaque osaitantanari tequeratsita noncame. ");
INSERT INTO cniNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Incantaitatiyempani incarajeitempi ashinoncaincari, ari pineshinoncatapinitatiyerini. Irompa nainti eiro nocantatiani noncarajeitempi. Eiro osamanitajitsi pineshinoncatantajenari aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Oshequi jorio quemacojeitajiriri Jesoshi itimapaaji anta, ijatashijeitanaqueri. Aisati ijatashijeitanaqueri irineeri Irasaro, yora camavetainchari yoitinaajiri. ");
INSERT INTO cniNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Isareajeitacari jivatacaajeitiriri saserotepee iroyeri aisati Irasaro. ");
INSERT INTO cniNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Oshequi joriopee neacojeitaqueriri Jesoshi yoitinaajiri Irasaro, irootaque yojocajeitantanajarori iquemisantavetari saserotepee, iquemisantajeitantajariri Jesoshi irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Oquitaitetamanaji aisati. Oshequi catsini pocaintsiri inquimoshirejeite. Iquemacojeitajiri Jesoshi impoque Jerosarequi. ");
INSERT INTO cniNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ari ijajeitanaque itonquiojeitavacari. Yaajeitaqueneri tsiaroshi. Icajemajeiti: —Jeri yoca oavisacotajeeneri, icameetsatasanoti. Iriotaque itiancane Avincatsarite. Iriotaque yoca pincatsariventajeitajerine ashanincapee, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ineapaaqueri Jesoshi aparo voro caariquera iquijacoyeeta. Iriotaque iquijacotapaacari. Aitaque peerani isanquenatacotitari: ");
INSERT INTO cniNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Savicajeitatsiri Sioniqui, eiro pitsaroashitatsi. Jeri yoca pocaintsiri, iriotaque pincatsariventajeitempine; iquijacotapaacari vorojaniqui”. ");
INSERT INTO cniNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tequeratsita niotacojeiteri oca isanquenatacotitacariniri peerani: ijatanaji Jesoshi jenoqui, impoijiquea noquenqueshireajeitanaquero. Aitaquequea imoncarataquero maaroni isanquenatacotitacariniri. ");
INSERT INTO cniNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ari chapinqui icajemiri Irasaro: “Pincontetapaaje”, ari icontetapaaji. Camasanovetainchari, iro cantaincha yoitinaajiri: nocarajeiti oshequi neacojeitiriri, impoiji nocamantacojeitaquero ora noneajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ari iquemacojeitaqueri atiri itasoncantayeti Jesoshi, irootaque ijatashijeitantacariri itonquiojeitavacari. ");
INSERT INTO cniNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Icantavacaajeitanaca variseo: —Pineaquero, tecatsi ancantanirojeiteri. Yoijajeitaqueri maaroni atiri. ");
INSERT INTO cniNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Itoncaajeitanaque Jerosarequi oshequi atiri inquimoshirejeite, inquemisantajeite. Icarajeitiri pashinisatipee atiri, iroaquera peajancha jorio. ");
INSERT INTO cniNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ijatashijeitapaaqueri iriori Jeripi, yora vetsairasati. Otimi Vetsaira Carireaqui. Icantapaaqueri: —Apa, nocoi noneeri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jeripi ijatashitanaqueri icamantaitiri Antirishi. Irosati ijatantanaja apite, icamantiri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Icantavaqueri: —Noponeanaca inquitequi, natiritapaaque; irotaintsi meeca impincatsayeetena. ");
INSERT INTO cniNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Queariotaque oca noncamantempiri. Ariorica ompariye quipatsiqui apaitsoquiro tirico, eirorica otijatsi, irosati oncantea: apaitsoquiro onapaaque. Irompa ontijaquearica, ari oshiocanaque, oshequiasanotanaque aisati oitsoqui. ");
INSERT INTO cniNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Timatsi atiri quempoyeavetachari irisati, te incoyeji irashinoncayea, yatsipetashitaca iquempoyeaca irisati; eiro yaneasanotajitsi inquitequi iriori. Irintiquea caari quempoyeacha irisati meeca, incantaitatiyempani iraneanaje irinti inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Maaroni coatsiri irantayetenaro nocoacairiri, iroijatenata; incarajeitenaya jaocarica nontimeri narori. ");
INSERT INTO cniNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","28","Aisati impinateri Apa. Meeca noquenqueshiretanaca. ¿Paita noncanteriri meeca Apa? ¿Noncanterimpa: “Apa, irotaintsi iroashinonqueetena, poavisacotena”? Eiro nocantiritsi. Irootaque nopocantacari quipatsiqui nonquematsicatearo meeca. Irosati iquenquetsatacantacariri iriri: —Apa, nocoaque impincatsajeitempita atiripee, irineacameetsajeitempita. Irosati noquemajeitantacariri Apa anta inquitequi, icanti: —Aitanaque niotacaajeitiri nopincatsaritasanotaque. Coajica niotacaajeitajeri aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ari iquemajeivetavacari catiajeivetainchari, iro cantaincha te iriotasanotavaqueroji. Icantashijeitanaca: —Otirei. Pashini cantayetanaintsi: —Ineanatiri inampire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Icantiri Jesoshi: —Te naro iroamete: avirojeivetaca avinti yoamejeivetaca. ");
INSERT INTO cniNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Meecaquea incantacoventajeiteri maaroni tseencantayetatsiri: “Ainiro pantane, aitaque noasanquetimentempiro”. Meeca aisati irojoqueri Apa yora pincatsariventajeitiriri tseencantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Irotaintsi iroatiacoyeetena, irosatiquea nampatojeitanteariri maaroni atiri, impocashijeitena. ");
INSERT INTO cniNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Irootaque icantaqueriri Jesoshi. Icamantitacari jaoca incanteari incamanteari coajicani. ");
INSERT INTO cniNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yacanaqueri atiri: —Oamejeitee Sanquenarentsi: “Irosati incantaitatiyempani Quirishito iranee”. ¿Paita picantiri? ¿Paita picantantarori avirori: “Iroatiacoyeetaqueri Atiritapaintsiri”? ¿Janicampa yora Atiritapaintsiri camatsineri? ");
INSERT INTO cniNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yacanajiri Jesoshi: —Ainiroquera oquitaiteti, iro cantaincha eiro meeca osamanitajitsi ontsitenitantajeari. Paniitanaque meeca, omapoquimpicari tsiteniri. Ariorica paniitanaje tsiteniriqui, eiro piotitsi jaocarica pinquenanajeri. ");
INSERT INTO cniNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ainiroquera noquitaitetacotimpi, niotacaimpi; picoaquerica pinquemisantena, pinquemisantenata meeca. Impoiji pinquempejeiteri pishanincapee: pinquitaitetacoteri, piotacaajeiteri iriori. Irosati ijatantanaja, imanapitsatanajari. ");
INSERT INTO cniNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ineajeivetacari oshequi atiri itasoncantayeti Jesoshi, iro cantaincha te inquemisantajeitavaqueriji. ");
INSERT INTO cniNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Imoncarajeitaquero isanquenatacotitacaniri peerani Isayashini: “Novincatsarite, eiro ishequitasanotitsi quemisantavaqueroneri ora ancamanteriri. Irineajeivetempi pintasoncante, iro cantaincha eiro iquemisantimpitsi”. Camantantatsiniri inaveitani Isayashini. ");
INSERT INTO cniNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Icantitacani aisati: “Yora Tasorentsi inquitapoajatacayeri tseencajeitiriri, impeitaqueri iquenqueshireantavetari. Icanti: ‘Ineicari. Ioticari. Yaventanacari. Noavisacotiricari’ ”. Irootaque caari imajeitantaro tseencantatsiri inquenqueshireempa. ");
INSERT INTO cniNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Peerani ineaqueri Isayashini ishipaquireaque Avincatsarite, impoiji iquenquetsatacotiri. ");
INSERT INTO cniNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Aisati oshequi jivatacaajeitiriri joriopee, iquemisantajeivetanacari Jesoshi. Iro cantaincha itsaroacaajeitacari variseopee, irootaque caari icamantantari ishaninca: “Noquemisantiri Jesoshi”. Iquenqueshireti: “Iquishimentanaricari noquemisantiri Jesoshi, eiro ishinetanatsi nampatojeiteari noshaninca nonquemisantajeite”. ");
INSERT INTO cniNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yora variseopee icoapinijeiti irineacameetsajeiteri atiri, te irio incoye irineacameetsateri Tasorentsi irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Irosati icajemantanaca Jesoshi: —Maaroni quemisantanari, te naro inquemisantasanote, irintiquea iquemisantasanotaque tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Maaroni neaquenari, irinti ineaque aisati tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Irootaque nopocantacari nonquitaitetacoteri atiri, niotacaasanojeiteri. Yora quemisantanari, eiro yatsipetajaro intimaje tsiteniriqui; tempa ioyetaque. ");
INSERT INTO cniNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yora quemayevetacarori noneane: eirorica iquemisantiro, eiro noasanquetiritsi nainti. Te iro nompocantea quipatsiquica noasanquetaayeteri atiri, irointi nopocanta noavisacojeiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Maaroni tseencaquenari, caari quemisantiro noyenquetsare, timatsi oasanquetaajeiterineri coajicani. Jero oca noneane nocantavetacari: coajica omoncaratapeemparica, iroasanquetimenteri itseenquiro noneane. Te noneaveetashiteaji. ");
INSERT INTO cniNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Apa tiancaquenari, iriotaque cantavaquenari: “Iroyea oca pineanatapeeri. Jero oca pincantapeeriri”. ");
INSERT INTO cniNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yora quemisantavaquerori irineane Apa, incantaitatiyempani iraneanaje inquitequi. Niotaquero oca. Oca nocantaquempiri, nomoncarataquero icantaquenari Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tequeratsita inquimoshireventajeitajearo Yavisantaniri. Aitaque iotaque Jesoshi omoncarataca irojocantanajearori quipatsica, impiantanajeari iririqui. Icantatiani inintajeitaqueri yashijeitacari quipatsiquiniri. Meeca inintasanojeitiri. ");
INSERT INTO cniNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ari noajeitaca, notsipajeitacari Jorashi Ishicariote, yora itomi Shimo. Iquenqueshireacaacari camaari iraacanteri Jesoshi coajicani. ");
INSERT INTO cniNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iotaque Jesoshi itiancaqueri Iriri impincatsariventajeiteri maaroni atiri. Iotaque aisati iponeaca Tasorentsiqui, impiashitanajeri aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ari yoacaajeitaquena Jesoshi, impoiji icatianaca. Yojoquireaquero yoicoro. Ishiticatsaquitanacaro ishevorotantari. ");
INSERT INTO cniNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Irosati isantacaro nija metaroqui, irosati iquivantajeitaquenarori noitipee: narori, aisati itsipapee iroamerepee. Iro ishetantajanarori noiti ishevorotantari. ");
INSERT INTO cniNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Irovetaincha inquivaquiitapeerime iriori Petero, icantavaqueri: —Tempa avirotaque Novincatsarite, te oncameetsateji pinquivenaro noiti narori. Oncameetsateme nonquivempirome piiti avinti. ");
INSERT INTO cniNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yacanaqueri Jesoshi: —Te piotacoteroji meeca oca nantaquempiri. Aitaque piotajero coajicani. ");
INSERT INTO cniNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Icantanaqueri: —Eiro piquivanarotsi noiti catsini. Yacanaqueri: —Eirorica noquivimpirotsi piiti, eiro aquempeavacaatsi coajicani. ");
INSERT INTO cniNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Irosati icantantacariri: —Jentsite, Novincatsarite, pinquivenaro noitipee, naco, noito, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Icantanajiri Jesoshi: —Eiro yapiitajatsi inquivajea caajeitaintsiri. Quitejeivetaquempi avinti, iro cantaincha te pinquitejeiteji maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iotaque Jesoshi janica aacanterineri. Irootaque icantantacari: “Te pinquitejeiteji maaroni”. ");
INSERT INTO cniNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Itsoncajeitaquena iquivajeitaquenaro noiti maaroni. Iquitsaatajaro aisati yoicoro. Aisati isaviquimojeitajana, icantana: —¿Piojeitaquempa meeca paita nantantayetarori ocapee? ");
INSERT INTO cniNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tempa picantapinijeitana: Oametantatsiri, aisati Pincatsari. Queariotaque oca picantaquenari. Narotaque oamejeitimpiri, pincatsariventajeitimpiri. ");
INSERT INTO cniNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pineaquena meeca, noquivajeitaquempiro piiti. Aitaque pinquempetavacaajeiteari avirori, pinquivavacayea piitiqui. ");
INSERT INTO cniNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Naro onijaaquempirori. Aitaque meeca pinquempejeitavacayea avirori, pinquivavacaajeitea. ");
INSERT INTO cniNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Queariotaque oca nocantimpiri. Inampire te iranaacoteriji nampitariri impincatsarite. Aisati itiancane eiro yanaacotiritsi impincatsarite yora tianquiriri. ");
INSERT INTO cniNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ariorica piquemavaquero oca noametimpiri, pimataquero nocoacaimpiri pinquimoshirejeitanteari. ");
INSERT INTO cniNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Timatsi meeca aparoni nocamantacotasanotiri, te maaroni nonquenquetsatacotempiji. Nocoyeajeitaquempi, tempa niojeitaquempi. Ainiro Sanquenarentsi caariquera moncaratacha, ocanti: “Yora oacotaquenari notantane, iraacantena”. ");
INSERT INTO cniNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Aitaque nocamantitajeitaquempi tequeratsita irayeetena. Ariorica piotaque omoncarataca nocantimpiri, aitaque pishiretearo naro nainti isanquenatacotitaniri. ");
INSERT INTO cniNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Queariotaque oca nocantimpiri. Ariorica iraacameetsayeetavaqueri notiancane, aisati narori, iraacameetsatena. Ariorica iraacameetsatavaquena narori, aisati inquempeteri iriori tiancanari, iraacameetsateri. ");
INSERT INTO cniNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Irosati yoashiretantanaca Jesoshi, icamantajeitana: —Queariotaque oca noncamantajeitempiri. Timatsi aca aacantenaneri. ");
INSERT INTO cniNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ari namenavacaajeitanaca, te nioteji janicarica icantacotaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Narotaque iroamere inintasanotiri Jesoshi, ainirona narori, notiinatacari inejiqui. ");
INSERT INTO cniNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ijicotaquena Shimo Petero, icantana: —Pisampiteri. ¿Janica iquenquetsatacotiri? ");
INSERT INTO cniNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Irosati notiinatasanotantanacariri aisati inejiqui Jesoshi. Nosampitaqueri: —Novincatsarite, ¿janicampa aacantempine? ");
INSERT INTO cniNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yacanaquena: —Ariorica novincaquero tantaca, yoca nompaqueri, iriotaque aacantenaneri. Irosati yovincantanacaro tanta, ipaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Irosati iquenqueshiretacaantacariri Satanashi Jorashi iraacaanteri Jesoshi. Icantanaqueri Jesoshi: —Ora piquenqueshiretiri panteri, pimateroqueti. ");
INSERT INTO cniNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yora oajeitainchari ara te iriotavaqueroji icantaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","30","Ari yaanirotavaquero tanta, irosati ijatantanaca iraacaantanteariri. Yora Jorashi iriotaque quempoyeaquenariri noirequite maaroni. Ijatantacari, yaamaanaca aparopee icantiri Jesoshi: “Pamanantaite ayeari anquimoshireventearo Yavisantaniri”. Pashini yaamaaca icantiri: “Pijate pimpashiyetaiteari ashinoncayetachari”. Ari ijatantanacari, otsitenitanaji. ");
INSERT INTO cniNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Impoiji icantanaquena Jesoshi: —Noponeanaca narori inquitequi, natiritapaaque. Irotaintsi meeca impincatsajeitena atiripee, aisati niotacaajeiteri impincatsajeiteri Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Aisati inquempetea Apa iriori, iriotacaajeiteri atiri impincatsajeitena narori. Meeca irimatero, eiro isamanitirotsi. ");
INSERT INTO cniNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Meeca, noamerejei, eiro osamanititsi nojocajeitantanajempiri. Aitaque nocamantitacari joriopee, aisati meeca noncamantajeitempi avirori: anta nojatajenta, eiro pimatirotsi pijataje avirori. ");
INSERT INTO cniNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pashini noncantajeitempiri meeca: pinintavacaajeitea maaroni. Oquempetaca narori nonintajeitimpi, aisati pinquempetavacaajeitea avirori, pinintavacaajeitea. ");
INSERT INTO cniNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ariorica pinintavacaajeitaquea, aitaque iriojeitaquempi maaroni atiri: avirojeitaque noamere. ");
INSERT INTO cniNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Icantanaqueri Shimo Petero: —¿Jaoca pijatajeri, Novincatsarite? Yacanaqueri: —Anta nojatajenta, eiro pimatirotsi poijatanaquena meeca. Coajicaquea aitaque poijatanajena. ");
INSERT INTO cniNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Icantanaqueri Avincatsarite: —¿Paitampa caari nomatantearo noijatanaquempi meeca? Iroyeeteerica, iro cantaincha nintacotanaquempi. ");
INSERT INTO cniNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yacanajiri Jesoshi: —¿Ariompa pintacotasanotanaquena? Queariotaque oca noncamantempiri: eirotsitarica inei teapa, pincantaque: “Te noneeriji Jesoshi”. Oncarate mava pincantaque. ");
INSERT INTO cniNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Aisati icantajeitana Jesoshi: —Eiro picantashirejeititsi, irointi pishireteari Tasorentsi. Aisati narori, pishiretena. ");
INSERT INTO cniNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Anta inampiqui Apa otimi oshequi pancotsipee. Eiro oshequitime, aitaque noncamantaquempime te oshequiteji. Nojate anta novetsicanontapeempi pisavicantajeiteari avirori coajicani. ");
INSERT INTO cniNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ariorica nomatempiro pisavicanteari, nompiashijeitajantempi aisati, naajeitajantempi. Aitaque pintsipajeitapaajena nosaviquinta narori. ");
INSERT INTO cniNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Piojeitaque jaoca nojatajeri. Piojeitaque aisati jaoca nonquenanajeri. ");
INSERT INTO cniNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Icantanaqueri Tomashi: —Te niojeiteji jaocarica pijatajeri. ¿Jaoca noncanteari niotanteari jaoca pinquenanajeri? ");
INSERT INTO cniNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Icantanajiri Jesoshi: —Tempa narotaque nijaanajempironeri pinquenantanajeari, aisati narotaque oametapinijeitaquempirori queariotasanotatsiri, aneacaajeitaquempiri. Tecatsi pincantea pijatashiteri Apa, narotaque aajeitanajempine. ");
INSERT INTO cniNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Piojeitaquenaricame, aisati piojeitaquerime Apa iriori. Meeca piojeitaqueri. Aitaque pineajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Icantanaqueri Jeripi: —Novincatsarite, ponijayenari piri; irootaque aparoni nocantimpiri, aitapaji. ");
INSERT INTO cniNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Icantanajiri Jesoshi: —Peeranitaque notsipajeitaquempi. ¿Tequerampa piotimatena? Maaroni neaquenari, ineaqueri Apa iriori. ¿Paita picantantanari meeca: “Ponijayenari piri”? ");
INSERT INTO cniNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tequerampa piotimateji noquempetacari Apa? Aisati iquempetana iriori. Te noncantashiteaji. Iquempetaquena Apa, iriotaque matacaanarori notasoncanti. ");
INSERT INTO cniNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tempa nocamantimpi noquempetacari Apa. Aisati iquempetaquena iriori. Pishiretearo oca nocamantaquempiri. Pineasanojeitaquena notasoncantaque, pinquemisantimentasanotenaro. ");
INSERT INTO cniNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jero aisati icantajeitana Jesoshi: —Queariotaque oca noncamantempiri. Maaroni quemisantanari inquempejeitena, intasoncante iriori. Nompianaje Apaqui, irootaque iranaacojeitantenari intasoncantasanojeite iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ariorica pishiretaquena, aitaque nomataquempiro paitarica pincoacoteriri Apa. Oca nomatempiro irineapincatsatanteeteariri Apa. Tempa narotaque Itomi. ");
INSERT INTO cniNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pishiretenarica, aitaque nomataquempiro paitarica pincanteriri. ");
INSERT INTO cniNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Pinintanarica, pinquemisantajeitena paitarica noncamantajeitempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Narotaque quenquetsatacayerine Apa. Noncanteri, irootaque intiancantajeitempirori pashini Amitacotajempineri. Irosati oncanteani ontsipajeitempi irointi: ");
INSERT INTO cniNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","irootaque Ishire Tasorentsi, oamejeitempironeri maaroni quearioyetatsiri. Te iriojeiteroji irinti tseencantatsiri, irootaque caari opocashijeitantari ontsipajeiteari. Aitaque quiso oajeitaquempi, oncantaitatiyempani. Irootaque piojeitantacarori avinti. ");
INSERT INTO cniNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Eiro nojoquimpitsi apaniro, aitaque nompiashijeitajempi. ");
INSERT INTO cniNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Irotaintsi nojataje. Eiro ineajeitajanatsi tseencantatsiri, avintiquea neajeitajenane. Nashi noiro nanei, irootaque paneantajeitanajeari avirori: pincantaitatiyempani inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ariorica nontinaanaje, impoijiquea piojeitanaque noquempetacari Apa. Piquempejeitaquena avirori, aisati noquempejeitaquempi narori: aacameetsatavacaajeitaca. ");
INSERT INTO cniNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Maaroni iotavaquerori nocantiriri, inquemisantaquerorica aisati, iriotaque nintanari. Apa ario irinintaqueri nintaquenari. Aisati narori ario nonintaqueri. Niotacaasanojeiteri jaoca nocanta. ");
INSERT INTO cniNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ainiro anta pashini Jorashi, caari ini yora Ishicariote. Isampitiri: —Novincatsarite, piotacaasanotaquena narori jaoca picanta. ¿Paita caari piotacantari tseencantatsiri iriori? ");
INSERT INTO cniNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yacanaque Jesoshi: —Ariorica pinintena, pinquemisantero noneane, irosati irinintantempiri Apa iriori. Impoiji nompocashijeitajempi quiso noantempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Irintiquea caari nintana, eiro iquemisantirotsi noneane. Oca nocantaquempirica, caari nashi noneane, irointi irineane Apa tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ainiroqueratatsi nocarajeitimpi, aitaque nocamantitaquempiro. ");
INSERT INTO cniNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ioti Apa pishiretaquena, irootaque intiancantempirori Ishire, Amitacojeitajempineri. Oamejeitapaajempi maaroni. Irootaque quenqueshireacaajeitajempironeri maaroni nocantajeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Aisati icantajeitana Jesoshi: —Noquimoshiretanaque narori, te noncantashireteji. Noninti pinquempetena, pinquimoshirejeitanaque avirori. Eiro imatirotsi atiri iroimoshirenquempi. Eiro meeca picantashiretitsi, irointi piveshireajeitanaquea. ");
INSERT INTO cniNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aitaque piquemaquero nocantajeitaquempiri. Nojatanaje, coajica nompiashijeitajantempi aisati. Yanaacotana Apa itasorentsitasanoti. Arioricame pinintajeitaquename pinquimoshireimentajeitaquearome nocamantaquempiri: “Nojatanaje Apaqui”. ");
INSERT INTO cniNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Meeca nocamantitaquempiro tequeratsita nojataje. Ariorica piotaque omoncarataca nocamantaquempiri, pinquemisantajeitaque. ");
INSERT INTO cniNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Eiro osamanitajitsi nonquenquetsatacaajempi aisati. Quempejitapaaque pincatsariventajeitiriri tseencantatsiri. Tecatsi incantea iriori impincatsariventena. ");
INSERT INTO cniNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Meeca iriojeitanaquero atiri nonintiri Apa, tempa nantapinitiniri paitarica inintacaaquenari. Ari, pincatiajeitanaje. Tsame avaajeitanajea. ");
INSERT INTO cniNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jero aisati ishiacantaquenari Jesoshi: —Narotaque quempetarori ovorentsasanori ova. Iriotaque Apa tsameetacotirori. ");
INSERT INTO cniNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ipesayetiro ojempequi caari oitsoquitatsi. Irompa irointi oitsoquitatsiri yoameetsataquero oitsoquitasanotantanaqueari. ");
INSERT INTO cniNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Oca noamejeitaquempiri, aitaque oameetsashirejeitaquempi. ");
INSERT INTO cniNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Quiso poajeitena. Aisati narori, quiso noajeitempi. Ojempequi ova, ariorica onchaoreanaque ovorentsa, eiro omatajatsi oitsoquitaje, tempa oncamaque. Aitaque piquempejeitarori avirori. Eirorica quiso poajeitanatsi, eiro pimatirotsi cameetsayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Narotaque quempetarori ovorentsa. Avirojeitaque quempejeitarori ojempequi. Maaroni quiso oanari irio majeitajerone paitarica noncoacaayeteriri. Quiso noyeri narori. Ariorica pintentareajeitanajena, tecatsi pimatimataje. ");
INSERT INTO cniNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yora caari quiso oana, inquempetacaanteeteri ojempequi ova, impesheetero, peti. Impoiji ompirijatanaque, irampatoyeetajero coajicani, irojoqueetero paamariqui, ontayea, pomein. ");
INSERT INTO cniNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Irosatirica quiso poajeitena, aisati ariorica pishiretearo noneane, pincantena paitarica picoayetiri: aitaque nomataquempiro. ");
INSERT INTO cniNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ariorica pimayetaquero paitarica noncoacayempiri, impincatsayeetanteariri Apa. Impoiji iriotasanojeitempi avirotasanotaque noamere. ");
INSERT INTO cniNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jero aisati icantajeitanari Jesoshi: —Inintana Apa. Aisati noquempejeitimpi narori, nonintajeitimpi. Quiso poajeitena, anintavacaajeitanteari. ");
INSERT INTO cniNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Pinquemisanterorica nocantajeitimpiri, irosati noncanteani nonintajeitempi narori. Noquemisantiro icantaquenari Apa, irosati icantani iriori, inintana. ");
INSERT INTO cniNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Noquimoshiretanaque narori. Iro nocamantantimpirori oca pinquempetantenari, pinquimoshirejeitanteari avirori. Nocoaque pinquimoshiretasanojeitanaque maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jero oca noncamantempiri: tempa nonintajeitimpi narori. Aisati pinquempetea avirori, pinintavacaajeitea. ");
INSERT INTO cniNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yora intacotariri ishaninca, incamimentaqueririca, iriotaque nintasanotiriri. ");
INSERT INTO cniNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ariorica pimajeitaquero nocantaquempiri, avirotasanotaque noshaninca. ");
INSERT INTO cniNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Eiro meeca nocantajeitajimpitsi nonampire, te irioteji nampirentsi paitarica yantiri nampitariri. Iro cantaincha niotacaajeitajimpi paitarica icantaquenari Apa, irootaque noshanincatasanotantajimpiri. ");
INSERT INTO cniNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Te aviro coyeajeitenane; naro nainti coyeajeitimpiri. Nontianquempi pimatantearori paitarica noncoacaayetempiri. Eiro patsipetarotsi paitarica pantayetenari. Pishiretenarica, aitaque irimatempiro Apa paitarica pincanteriri. ");
INSERT INTO cniNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nampiitajempiro oca noncamantajeitajempi: pinintavacaajeitea maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Pashini aisati icantaquena Jesoshi: —Ariorica inquisajeitaquempi tseencantatsiri, piotasanote naro ijivataque iquisaquena peerani. ");
INSERT INTO cniNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yora tseencantatsiri inintavacaaca. Arioricame pinquempetearime avirori, aitaque irinintajeitaquempime. Iro cantaincha te pinquempejeitajeari. Nocoyeajeitaquempi, irootaque iquisajeitantaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pinquenqueshireajero nocantaquempiri chapinqui: “Yora inampire te iranaacoteriji nampitariri impincatsarite”. Ari iquisajeitaquena. Aisati inquempejeitempi avirori, inquisajeitempi. Te inquemisanteroji nocantajeivetacariri. Aisati avirori, eiro iquemisantajeitirotsi pincamantajeiveteariri. ");
INSERT INTO cniNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Iriotaque Tasorentsi tiancaquenari. Iro cantaincha te iriojeiteriji iriori, irootaque inquisajeitantempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ari nopocashivetacari, noquenquetsatacaavetacari. Eirome nopocashitirime, eiro otimimotirime meeca irantane. Iro cantaincha meeca tecatsi incantajeite incante: “Te aneroji nantane”. ");
INSERT INTO cniNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yora quisaquenari iquisaqueri Apa iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tempa ineajeivetaquena notasoncantayeti. Nomayetaquero caari imayeti atiri iriori. Eirome ineajeivetaquename, eirome otimimotirime irantane. Aiquero ineavetaquena, iquisaquena. Aisati iquisaqueri Apa iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aitaque icantajeitari. Moncaratapaaca oca isanquenayeetiniri: “Iquisashijeitaquena, tecatsi nantavetea”. ");
INSERT INTO cniNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ari nontiancajeitajempi Amitacotempineri, ora Ishire Tasorentsi. Omponeaquea Apaqui, cameetsa oamejeitapeempi. Ariorica ompocaque oncamantacotapaajena narori. ");
INSERT INTO cniNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aisati avirori, pincamantacojeitajena narori. Tempa avirojeitaque tsipatapinijeitaquenari peerani. ");
INSERT INTO cniNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Aisati icantana: —Nocoi eiro pojocajirotsi piquemisanti, irootaque nocamantantajeitimpirori oca. ");
INSERT INTO cniNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Coajica pincoajeivetea pincarajeiterime ajorioririnte anta apatojeitapinitanta, iro cantaincha iroimpiavajempi. Coajica iroyempi aisati. Aiquero yora quisajeitaquempineri iraamayea yantiniri Tasorentsi inintacaaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Te iriojeiteriji Apa, aisati narori te iriojeitenaji, irootaque inquisajeitantempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ariorica omoncarataquea oca nocamantaquempiri, aitaque pinquenqueshireanaquero nocamantitaquempiniri, irootaque meeca nocamantantimpirori. Peerani notsipatimpini, irootaque caari nocamantitantimpini peerani, meecari meeca irootaji nojataje, irootaque nocamantasanotantimpiri. ");
INSERT INTO cniNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Aisati icantana Jesoshi: —Meeca nojatanaje tiancaquenariqui. Iro cantaincha te pisampijeitenaji: “¿Jaoca pijatajeri?” ");
INSERT INTO cniNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Meecaquea, meeca, nocamantaquempi, irootaque poashiretasanojeitantanacari. ");
INSERT INTO cniNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tampatica nocamantaquempiro oca. Ocameetsatimotimpi nojataje. Eirorica nojatajitsi, eiro opocashijeitimpitsi Amitacojeitempineri. Ariorica nojatanaje, aitaque nontiancajeitapaaquempiro. ");
INSERT INTO cniNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Areetapeemparica, iotacaajeitapaaqueri tseencantatsiri te oncameetsateji yantayetiri. Iotacaajeitapaaqueri aisati jaoca incantajeitajeari incameetsatantajeari. Aisati iotacaajeitapaaqueri jaoca incanteari Tasorentsi iroasanquetanteariri maaroni tseenquiriri. ");
INSERT INTO cniNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Te inquemisantajeitenaji, irootaque iroasanquetimentanteariri caari cameetsatatsi. ");
INSERT INTO cniNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Coajica nompeimotanajempi, nojatanaje Apaqui, irootaque iotacantajeitapeempariri atiri nocameetsataque. ");
INSERT INTO cniNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Iotacaajeitapeeri iroasanquejeiteri Tasorentsi. Tempa irisati oasanquejeiterineri yora pincatsariventajeitiriri tseencantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ainiroquera oshequi noncamantajeitempimeri, iro cantaincha eiro pimajeitirotsi piojeitavaquero meeca. ");
INSERT INTO cniNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Queariotasanotaque maaroni oamejeitempiri Ishire Tasorentsi. Ariorica ompocapaaque, iotacaapeempiro maaroni queariotatsiri. Eiro oametantashitapaatsi. Paitarica oquemaqueri irootaque oamejeitapeempiri. Oametempi jaoca incanteeteari coajicani. ");
INSERT INTO cniNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Oca nocantajeitimpiri, irootaque oametempineri; iotacantempiri nopincatsaritaque. Maaroni icantayetanari Apa, nocamantayetajimpiro aisati narori, ");
INSERT INTO cniNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","irootaque nocantajeitantaquempiri: “Oca nocantayetaquempiri, irootaque oametempineri”. ");
INSERT INTO cniNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Aisati icantana Jesoshi: —Capichanivaniji eiro pineajanatsi. Osamanitimataque capichaji, ario pineajena aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Irosati nocantavacaarantantanacari: —¿Jaoca ocantari oca icantaqueeri? “Capichanivaniji eiro pineajanatsi. Osamanitimataque capichaji, ario pineajena aisati”. Icanti aisati: “Nojataje Apaqui”. ");
INSERT INTO cniNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Paitasa icantantari: “Capichanivaniji”? Te ayotacotavaqueri icantaqueeri. ");
INSERT INTO cniNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iotaque Jesoshi nocoajeiveta nosampiterime. Icantanaquena: —¿Pisampitimentavacaarompa nocantaquempiri? “Capichanivaniji eiro pineajanatsi. Osamanitimataque capichaji pineajena aisati”. ");
INSERT INTO cniNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Queariotaque oca noncamantajeitempiri. Ario piraacojeitanaquena, maaroni, poashirejeitanaquea. Irinti quimoshirejeivetachane tseencantatsiri. Poashirejeivetaquea, iro cantaincha pinquimoshirejeitanaje aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ariorica omoncarataca otimiri tsinane otomi, oquemaatsitacari. Itimanaquerica ojananequite, te onquenqueshireajeroji oquemaatsitacari, irointi oquimoshireimentiri yora timaintsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Aitaque pinquempejeitaqueari meeca avirori, poashirejeivetanaquea. Iro cantaincha aitaque noneajeitajempi aisati. Pinquimoshirejeitanaque, tecatsi oashiretacaajempine aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Meeca, eiro pisampijeitajanatsi paitarica. Queariotaque oca nocantimpiri. Ariorica pishiretaquena, impaquempi Apa paitarica pincantajeiteriri. ");
INSERT INTO cniNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Peerani te pishirejeitenani, te pinquenquetsatacaajeiterini Apa. Meecaquea pinquenquetsatacaapiniteri. Paitarica pincanteriri, aitaque inquemisantaquempi, pinquimoshirejeitasanotantanaqueari. ");
INSERT INTO cniNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Aisati icantaquena: —Ari noshiacaventapinitimpironi paitarica, iro cantaincha coajica eiro noshiacaventajimpirotsi aisati. Aitaque tampatica noncamantacotasanoteri Apa, eiro nomanapitsatajimpirotsi. ");
INSERT INTO cniNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Impoiji pishiretanaquena, pinquenquetsatacayeri Apa. Avirojeitaque nintaquenari. Pishiretacaro noponeaca Tasorentsiqui, irootaque inintajeitantimpiri Apa. Ari inintasanojeitaquempi, irootaque impajeitantempirori maaroni coiteimojeitimpiri. Natsipetashitarocari namanacoventajeitajempi aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nosavicaveitani irioriqui, irosati nopocantacari quipatsiquica. Meeca nojocanajero quipatsica, nompiashitanajeri Apa. ");
INSERT INTO cniNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nocantiri: —Meecaquea picamantasanotaquenaro. Te pishiacaventajenaroji. ");
INSERT INTO cniNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Meeca niojeitaque pitsotencajeitiro piojeitiro maaroni, irootaque noquemisantantacari piponeaca Tasorentsiqui. Tecatsi meeca nosampitajempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yacanajana Jesoshi: ");
INSERT INTO cniNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","—¿Ariompa piquemisantasanotaque meeca? Irotaintsi iroimishiyeetempi, pijajeitanaje pinampipeequi. Pojocajeitanajena apaniro. Aitaque irotaintsi omoncaratapeempa meeca. Iro cantaincha te apaniro none, quiso yoana Apa irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iro nocamantantimpirori oca piveshireanteari. Aitaque piveshireimentajena. Aca quipatsiquica iroashinonqueetempi, iro cantaincha piveshireajeitanaquea. Nanaacojeitaqueri maaroni timajeitatsiri quipatsiquica, nopincatsaritasanoti nainti. ");
INSERT INTO cniNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Irootaque icantajeitanari Jesoshi, irosati yamenantanaca jenoqui. Icanti: —Apa, moncaratapaaca. Meeca piotacaajeiteri atiri nopincatsaritasanoti: tempa narotaque pitomi. Aisati nonquempetea, niotacaajeiteri pipincatsaritasanoti avirori. ");
INSERT INTO cniNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tempa aitaque pitiancaquena nompincatsariventajeiteri maaroni atiri, irootaque nomatantarori naneacaajeitajiri maaroni picoyeaquenari. Iro picoyeantacariri incantaitatiyempani iraneajeitanaje iriori aviroriqui. ");
INSERT INTO cniNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aviro Tasorentsi, apaniro pini. Cameetsa iriojeitempi maaroni atiri. Cameetsa iriote naro pitiancane, naro Jesoquirishito. Maaroni iotanari incantaitatiyempani iranee inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Aca quipatsiqui nomajeitaquempiro maaroni pinintacaaquenari, irootaque ipincatsatantimpiri atiri. ");
INSERT INTO cniNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Peerani, Apa, tequeratani avetsiqueroni quipatsi, notsipatimpini, nopincatsaritaqueni. Meeca pinquempetacaajena aisati, nompincatsaritaje, nontsipatajempi. ");
INSERT INTO cniNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ari yovaajiro aisati, icantiri Iriri: —Jeri yoca atiripee quipatsiquiniri pashijeitacari. Picantaquena: “Pinquempoyeajenari”. Ari niotacaajeitaqueri jaoca picantari. Iquemisantajeitavaquero pineane. ");
INSERT INTO cniNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Meeca iojeitanaque aviro avinti intasanotarori maaroni poamejeitaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Maaroni poametaquenari, novaaqueneri noamerepee, noametasanojeitaqueri maaroni. Iojeitavaquero. Iotasanotavaque aviro tiancaquenari. Ainiro ishire iriori iquemisantantarori aviro tiancaquenari. ");
INSERT INTO cniNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iriojeitaque nocantacoventaqueri. Te noncantacoventeriji irinti tseencantatsiri, irintiquea yoca noquempoyeajimpiri. Tempa avirotaque ashijeitariri, ");
INSERT INTO cniNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","aisati nashijeitacari narori. Aisati nashijei narori, pashijeitacari avirori. Iquemisantajeitana, irootaque ineapincatsajeitantanari. ");
INSERT INTO cniNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Eiro notimanajitsi aisati quipatsiquica, irioquea irinti timajeitanajantsine, naintiquea nainti piashitanajempine. Aviro, Apa, cameetsari. Tempa picantani pitasoncanti. Meeca aviro quempoyeajeitajerine yoca noquempoyeaquempiri, inquempeavacaanteari. Nocoaque irimoncarajeitajeeta aquempeavacaajeita arori. ");
INSERT INTO cniNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nocarajeitantacariri, tempa pimatacaaquena, irootaque nomatantarori noquempoyeantacariri. Nojocacoventajeitaqueri: tecatsi ashinoncachane, apaniro irashinoncayea Jorashi, iriotaque jatatsineri Sharincaveniqui. Aitaque omoncarataquea ocamantacotitarini sanquenatachaniri peerani. ");
INSERT INTO cniNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Meeca nompiashitanajempi. Ainiroqueratatsina quipatsiquica, nocamantajeitiri oca, inquimoshirejeitasanotanteari, inquempetena narori noquimoshireti. ");
INSERT INTO cniNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Noametaqueri pineane, meeca iquisajeitanaqueri tseencantatsiri. Iro iquisantacariri, te inquempeempariji. Iquempetana narori, te nonquempeempariji tseencantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jeri itimajeiti noquempoyeaquempiri quipatsiquica. Te noncantempiji: “Paanajeri”. Apatiroti nocantimpi: “Pojocacoventeri. Yantiricari camaari”. ");
INSERT INTO cniNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Te inquempeempariji tseencantatsiri. Iquempetana narori, te nonquempeempariji. ");
INSERT INTO cniNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Piotacaajeiteri queariotasanotatsiri, inquearioventantempirori maaroni picoacairiri. Ora pineane, irootaque queariotasanotatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Pitiancaquena nojatashitantariri atiri noquenquetsatacaajeitiri. Aisati narori noquempetaqueri, notiancajeitaqueri irijatashitanteariri atiri inquenquetsatacaajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Noquearioventimpiro maaroni, iojeitantarori queariotatsiri, irosati inquearioventajeitantempirori iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Jero aisati icantiriri Jesoshi iriri: —Nocantacoventajeitiri noamereca. Aisati noncantacoventajeiteri yora iquemisantacaajeitiri: yora quemisantajeitanari, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nocoaque inquempeavacaajeitanajea maaroni. Tempa aquempeavacaaca, Apa, arori. Aisati nocoaque inquempejeitajee iriori quemisantajeitanari, irosati inquemisantanteari atiri pitiancasanotaquena. ");
INSERT INTO cniNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Pitasoncacoventaquena noquempetantaquempiri avirori, aisati notasoncacoventajeitaqueri iriori, inquempetavacaajeitantajeari. Irimoncarajeitajee arori, aquempeavacaaca. ");
INSERT INTO cniNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iquempetaquena narori. Noquempetaquempi avirori. Irootaque inquempetavacaasanojeitanteari, irosati iriojeitanteari atiri pitiancaquena. Iriojeitanaque pinintaquena, aisati piquempejeitaqueri, pinintasanojeitaqueri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tequerani ontimeni quipatsi, tempa pinintitanani, irootaque pipeantaquenari pincatsari. Meeca, Apa, nocoaque intsipajeitena iriori irineantenari nompincatsaritasanotanaque. Tempa picantana: “Pinquempoyeajeitenari”, aitaque nomataquempiri. ");
INSERT INTO cniNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Picameetsatasanotaque, Apa. Te iriojeitempiji tseencantatsiri, iro cantaincha niotimpi nainti. Aisati iojeitaquempi yocapee pitiancaquenari, ");
INSERT INTO cniNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","niotacaajeitaqueri jaoca picantari avirori. Aitaque nampiitajeri niotacaasanoteri, pinintasanojeitanteariri, pinquempetacanteri narori pinintasanotana. Aisati inquempeajeitena. Irootaque icantiriri Jesoshi Iriri. ");
INSERT INTO cniNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ari yovecarataquero Jesoshi iquenquetsatacairi iriri, irosati nojajeitantanaja: Jesoshi, aisati maaroni iroamerepee. Nomonteanajaro pirijavinteni pajitachari Seroni. Nojajeitanaji panquiveerentsiqui anta. ");
INSERT INTO cniNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aitaque anta ijatacaapinijeitanari Jesoshi, irootaque iotantarori iriori Jorashi, yora aacanterineri. ");
INSERT INTO cniNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yora jivatacaajeitiriri saserotepee, jeri variseopee itiancajeitavaque soraro, jeri variria. Ijivajeitapaaqueri Jorashi. Yamajeitapaaque tsiomentotsi, sampi, yoantamento aisati; ");
INSERT INTO cniNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","5","ipocashijeitapaaqueri Jesoshi. Iotaque iriori Jesoshi jaoca incanteriri. Ijatanaque itonquiotavacari, icantavaqueri: —¿Janica picoiri? Yacanaqueri: —Yora Jesoshi nasaretesati. Icantavaqueri: —Narotaque. ");
INSERT INTO cniNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Icantantavacariri Jesoshi: “Narotaque”, irosati ipiantanaca itapiiqui. Ipariajeitanaque quipatsiqui, tiriquicn. ");
INSERT INTO cniNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yapiitajiri: —¿Janica picoasanotiri? Yacanajiri iriori: —Yora Jesoshi nasaretisati. ");
INSERT INTO cniNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Icantajiri: —Aitaque nocantajeivetaquempi: “Narotaque Jesoshi”. Naroricampa picoiri, pishinejeiteri irijajeiteta yoca notsipajeitacarica. ");
INSERT INTO cniNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Moncaratapaaca icantaqueriri Jesoshi Iriri: “Yoca picantaquenari: ‘Pinquempoyenari’, tecatsi ashinoncachane”. ");
INSERT INTO cniNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Irosati Shimo Petero yaantanacaro isavirite. Ipesaqueri inampire ivincatsarite saserotepee: ipeshitaqueri iyempita iracosanoriquiniri. Ipajita nampirentsi Marico. ");
INSERT INTO cniNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Irosati icantantanacari Jesoshi Petero: —Poimpiajero pisavirite poantaroriqui. Irootaque inintacaaquenari Apa irayeetena. ¿Nontsaneapitsatearimpa? ");
INSERT INTO cniNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Irosati yaajeitantanacari Jesoshi. Irio aajeitanaqueriri soraropee, iyapitanote, variria. Ari yoisojeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ijivatapainti yaanaqueneri Anashi. Iriotaque iriconquiri Caijashi. Ari iquenquetsatacairi Jesoshi. (v 24) Impoiji icanti yora Anashi: —Paanajeri anta Caijashiqui, irisampitavaquerita iriori paitapeerica. Yora Caijashi, iriotaque meeca ivincatsarite saserotepee, ");
INSERT INTO cniNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","cantaqueriri joriopee: “Ocameetsatimotimpi incameta shiramparinta aparoni, iravisacojeitantajeari ashanincapee”. ");
INSERT INTO cniNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Shimo Petero iriotaque oijatacoventavetanacariri Jesoshi, itsipatari pashini iroamere. Yora ivincatsarite saserote iotiri yora tsipatariri Shimo, irootaque ishinetantacariri iriori ipocaque ivancoqui, itsipatapaacari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Irinti Petero icatiapaaca ashitacorontsiqui araquerora. Isoquijanaji yora itsipatapaacari, icantapaaquero shentirori ashitacorontsi: —Pishineteri inqueapee iriori. Ocantiri: —Ari. Irosati iqueantapaacari Petero iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ora nampirentsi ocantavaqueri: —¿Caarimpimpa avirori iroamere Jesoshi? Icantiro: —Caarina. ");
INSERT INTO cniNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ocatsincaiteaque. Yoisajeitaquero paamari nampirentsipee, jeri soraropee. Yaquitsiantajeitaca paamariqui. Aisati iriori Petero itsipajeitapaacari yaquitsiantapaaca. ");
INSERT INTO cniNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yora ivincatsarite saserote isampitaqueri Jesoshi: —¿Janica poametapinitiri? ¿Paita poametapinijeitiriri? ");
INSERT INTO cniNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yacanaqueri Jesoshi: —Iquemajeitaquena maaroni atiri noametantiri. Noametantapiniti anta yapatojeitantari. Aisati noametapinitantaque ivancoqui Tasorentsi. Tecatsi nomanapitsateri ashaninca. ");
INSERT INTO cniNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Paita pisampitantanari narori? Pisampijeiteri irinti quemajeitaquenari paitarica nocantaqueriri. Iojeitaquero iriori. ");
INSERT INTO cniNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Irosati ipasavorotantanacari aparoni soraro catiainchari ara. Icantiri: —¿Arimpa ampiatsateari ivincatsarite saserote? ");
INSERT INTO cniNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yacanaqueri: —Terica oncameetsate nocantaqueriri, piotacayenaro. Irompa ocameetsatirica nocantaqueriri, ¿paita pipasavorotantanari? ");
INSERT INTO cniNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","(-) ");
INSERT INTO cniNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ainiroquera Shimo Petero yaquitsiantaca. Irosati icantanteetacariri: —Tempa aviro iroamere Jesoshi. Irisati manacotanaincha, icantanaque: —Caarina. ");
INSERT INTO cniNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Itsipajeitari aparo inampire Caijashi. Iriotaque ishaninca yora ipesaquempitavetacari Petero. Icantaqueri: —Tempa noniimpi panquirentsiqui, pitsipatari Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Yapiitajiro Petero imanacotaja. Irosati ineantanaca teapa. ");
INSERT INTO cniNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Capichaji quitaiteri yojocajeitanaquero ivanco Caijashi. Yayeetanaqueri Jesoshi ivancoqui Pirato, yora pincatsaritatsiri. Caari ini jorio, irootaque caari icoajeitanta joriopee inqueajeitapee ivancoqui. Icanti: —Irotaintsi avajeitimentearo Yavisantaniri. Ariorica ajate ivancoqui Pirato, eiro amatirotsi avajeitea, eiro ineacameetsajeiteetsi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Irosati isoquijashijeitantanacariri Pirato. Icantajeitavaqueri: —¿Paitampa yantaqueri yoca shiramparica pamantaquenariri? ");
INSERT INTO cniNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yacanaqueri iriori: —Ainiro yantayetiri. Eirome yantirome caari cameetsatatsi, eiro namimpirime. ");
INSERT INTO cniNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Irosati icantantavetacari Pirato: —Paajeitanajeri avinti. Tempa otimi sanquenarentsi oametimpiri poasanquejeitanteariri. Pimamateriquetite avinti poasanquetayeri. Icantanaqueri iriori: —Te irishineyeetenariji noyeri. ");
INSERT INTO cniNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Irootaque icantaqueri omoncaratantacari icantitacari Jesoshi. Tempa icantitani: “Impajacoyeetena”. ");
INSERT INTO cniNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Irosati ipiantanaja Pirato ivancoqui. Icajemacantajiri Jesoshi aisati. Icantiri: —¿Avirompa ivincatsarite joriopee? ");
INSERT INTO cniNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yacanaqueri Jesoshi: —¿Piovetaquenampa? ¿Paita pisampitantanari? ¿Timatsimpa pashini camantaquempiri? ");
INSERT INTO cniNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Yacanaqueri Pirato: —¿Narompa meeca jorio? Iriotaque pishaninca amajeitaquempiri aca, jeri jivatacaajeitiriri saserotepee iriori. ¿Paita pantaqueri iquisajeitantaquempiri? ");
INSERT INTO cniNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yacanaqueri Jesoshi: —Te nompincatsariventante aca quipatsiqui. Nompincatsariventanteme aca, aitaque inquisacoventajeitaquename nonampire. Eirome ishinetirime joriopee iramename. Iro cantaincha te aca nompincatsariventante. ");
INSERT INTO cniNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Irosati icantantacari: —¿Ariompa? ¿Avirotaquempa pincatsari? —Je, narotaque Pincatsari. Queario picantaquena. Nocamantajeitiri atiripee queariotasanotatsiri. Irootaque notimantacari, irootaque nopocantacari quipatsiquica. Maaroni yora iotavaquerori queariotasanotatsiri, iriojeitaque quemisantanari. ");
INSERT INTO cniNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Icantiri iriori Pirato: —¿Paita ojita oca picantiri: “Queariotasanotatsiri”? Irosati isoquijashitantanajari joriopee, icantajeitiri: —Nosampivetaquempi incaranqui, te pincamantenaji paita yantasanotaqueri noamaanteariri. ");
INSERT INTO cniNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pashini icanti aisati: —Ariorica omoncaratapaaja Yavisantaniri, noimisoquijapinitimpiri aparo yoiminqueetiri. Tempa aitaque ocantari amejeitari. ¿Picoimpa noimpacajempiri pivincatsariteca? ");
INSERT INTO cniNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Irosati icajemantajeitanaca maaroni: —Eiro poipacanaritsi yora. Irio poimisoquijajenari Varavashi irinti. Yora Varavashi coshinti ini. ");
INSERT INTO cniNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Irosati yaacantantacariri Pirato Jesoshi, ipasatacantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yora soraro itapoyetaqueneri iramatseere quemariiti. Yamatseetacaacari. Iquitsaataqueri quitioncari. ");
INSERT INTO cniNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ipocashitapinijeitaqueri, icantamempeashijeitacari: —¿Avirompa pincatsariventiriri jorio? Iji, iji, iji. ");
INSERT INTO cniNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ipasavorotantapaacari iraco. Isoquijashitanajiri Pirato joriopee aisati. Icantajeitiri: —Jeri yoca, namajimpiri aisati. Nosampivetaquempi, iro cantaincha tecatsi pincamantajeitena niotanteari paita piquisantacariri. ");
INSERT INTO cniNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Isoquijanaji Jesoshi iriori. Yamatseetacaro quemariiti, iquitsaataca quitioncari. Icantajeitiri Pirato: —Jerica. ");
INSERT INTO cniNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yamenajeitavaqueri jivatacaajeitiriri saserotepee, soraro aisati. Icajemajeitanaji: —Pimpajacotacanteri, pimpajacotacanteri. Icantiri Pirato: —Paajeitanaqueri avinti, pimpajacojeiteri. Nosampitacovetacari, tecatsi nonquemacoteri irante. ");
INSERT INTO cniNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yacanajiri jorio: —Timatsi sanquenarentsi oametanari ocameetsati incame jitasorentsitachari. Tempa icanti iriori: “Narotaque Itomi Tasorentsi”, irootaque ocameetsatantacari incame. ");
INSERT INTO cniNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Iquemantavacariri Pirato icantajeitaqueriri, aiquero ijatatii itsaroasanotanaque. ");
INSERT INTO cniNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ipianaja, iqueanaji ivancoqui. Icantapaajiri Jesoshi: —¿Jaoca piponeari avirori? ");
INSERT INTO cniNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Te iranqueji Jesoshi iriori. Irosati icantantanacari Pirato: —¿Paita caari pacantana? Naro pincatsari. Noncoaquerica, ari nomatero noimpacacoventajempi. Aisati oquempeta, noncoaquerica, nomatero nompajacotacantempi. Tempa piotaquero. ");
INSERT INTO cniNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yacanaqueri Jesoshi: —Eirome ishinetimpime Tasorentsi, tecatsi pincantename. Yora amacantaquenari aca, irio antasanotaquerori caari cameetsatatsi irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Irosati icoantavetanaja Pirato iroimpacaajerime. Iro cantaincha icajemajeitanaji joriopee aisati: —Ariorica poimpacaajeri yora, te pishanicateariji Shisari. Jeri yora cantashitachari: “Narotaque pincatsari”. Tempa iriotaque quisaqueriri pivincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Iquemantacari Pirato icantajeitaqueriri, isoquijacaanajiri Jesoshi. Isavicapaaque anta icantacoventantapinitinta. Anta yovetsiqueetironta mapi, ipampaiteyeetironta. Icanteetiro evereo “Cavata”. ");
INSERT INTO cniNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Itampaticati meeca catsirincaiteri, irotaintsi quitaiteri iquenqueshiretantarori Yavisantaniri. Irosati icantajeitantacari Pirato: —Jeri yoca pivincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Icajemajeitanaque iriori: —Payeri. Paanaqueri anta. Pimpajacotacanteri. Isampitiri: —¿Nompajacotacanterimpa pivincatsarite? Yacanaqueri jivatacaajeitiriri saserotepee: —Te nompincatsateriji, apaniro irinti Shisari. ");
INSERT INTO cniNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Irosati ipajacotacantantacari. ");
INSERT INTO cniNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Irio soraro aajeitanaqueriri. Irisati aanajiro Jesoshi coroshi. Yojocanajiro nampitsi, yareetapaaca toncaariqui pajitachari Iitontsini. Evereo ipajitiro: “Coricota”. ");
INSERT INTO cniNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aitaque ipajacoyeetaqueriri coroshiqui. Itsipatacari apite shirampari. Ipajacoyeetaqueri iriori coroshiqui pashini. Yoyeetaqueri Jesoshi nianqui. Aparo yoyeetaque iracosanoriqui Jesoshi, irio itsipa irampatequi. ");
INSERT INTO cniNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pirato isanquenatacantaque cantatsiri: “Jesoshi nasaretesati, iriotaque ivincatsarite jorio”. Ipatacacotacantaquero coroshiqui. ");
INSERT INTO cniNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Oquempejitaro nampitsi aitaque ipajacotaqueriri Jesoshi. Oshequi jorio neanataquerori isanquenatiri. Osanquenavetaca irineanequi jorio, oromasati, aisati irineanequi quireshiasati. ");
INSERT INTO cniNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yora jivatacaajeitiriri saserotepee icantiri Pirato: —Eiro pisanquenatirotsi: “Iriotaque ivincatsarite jorio”, irointi pisanquenate: “Irio cantashitachari: ‘Naro ivincatsarite jorio’ ”. ");
INSERT INTO cniNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Yacanaqueri Pirato: —Aitanaque, nomataquero: nosanquenatacantaquero. ");
INSERT INTO cniNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ari ipajacotaqueri soraro. Yovojeaquero iitsaareni, otsipasatitapaaque, irosati ipavacaantacaro. Te orimpiteaji iroicoroni, intani itijeetiro maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Irootaque icantavacaantajeitacari: —Eiro atsereirotsi. Tsame antanatiteri, ayotanteari janica ashitajearone. Aitaque icantari soraro. Imoncarataquero Sanquenarentsi cantatsiri: “Impavacayearo noitsaareni. Irantanatitajeitaquenaro noicoroni”. ");
INSERT INTO cniNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ora iriniro Jesoshi ocatiapaaca quempeji ipajacotaca. Ainiro otimi ireento, aisati opajita iroori Maria. Irootaque ijina Quereojashi. Otimi ara aisati Maria maquitarasato. ");
INSERT INTO cniNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ineajiro Jesoshi iriniro, aisati ineaquena narori. Narotaque iroamere inintasanotiri. Icantanaquero: —Ina, jeri yora, pintomintajeari. ");
INSERT INTO cniNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Icantanaquena: —Jero ora, pinirontajearo. Irosati naantanajaro novancoqui. ");
INSERT INTO cniNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iotanaque Jesoshi aitaque moncarajeitaca maaroni. Irosati icantantanaca: —Nomireni. Iro icantantari imoncarataquero ocantiri Sanquenarentsi. ");
INSERT INTO cniNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Otimi ara choncorina, ojaaca quepishijari. Yoviinqueetaquero atsimiicajatirori. Yoaqueneri sataamentotsiqui. Ijicotacotaqueneri ivantequi Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yatsimiicavaquero, irosati icantantanaca: —Aitaque meeca, nomoncarataquero icoacaanari Apa. Irosati yoivotantanaca, icamanaque, toren. ");
INSERT INTO cniNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Meeca yovetsiquimentajeitiro jorio Yavisantaniri. Onquitaitetamanaque, iro saavaro irimaoreantasanojeiteari. Te incoajeiteji jorio yora pajacojeitachari iroavisayero saavaro coroshiqui, irootaque icantajeitantacariri Pirato: —Pincarajacantitajeiteri ivoripee, irosati pimpajacoreacantantajeariri. ");
INSERT INTO cniNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Irosati ijatashijeitantanajari soraro, icarajavoritaqueri yora itsipatacari Jesoshi. Aisati icarajitaqueri iriori pashini. ");
INSERT INTO cniNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yovaashivetapaacari iriori Jesoshi, incarajiterime iriori; iro cantaincha ineapaaqueri camaque irinti, irootaque caari icarajitantari irinti ivori. ");
INSERT INTO cniNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Iro cantaincha aparo soraro isataapaaqueri imerequiqui. Ocontejatapaaque iriraja, tsiquiririri. Nija aisati. ");
INSERT INTO cniNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Naro neacotaqueriri, meeca narotaque camantacotaqueriri. Nioti queario oni nocamantimpiri, pinquemisantantajeari avirori. ");
INSERT INTO cniNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Aitaque icanteetaqueriri, irootaque omoncaratantacari Sanquenarentsi cantatsiniri: “Eiro icarajiteetiritsi itonqui aparoni”. ");
INSERT INTO cniNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Timatsi pashini isanquenayeetiniri: “Aitaque irameneeteri Quirishito, yora irisatayeeteri”. ");
INSERT INTO cniNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Itimi anta Jose arimateasati. Iroamere Jesoshi inaveta, iro cantaincha imanaquero. Iro imanantacarori, itsaroacaacari ivincatsaritepee jorio. Ijatashitaqueri meeca Pirato, icantapairi: —Pishinetajenari Jesoshini, naanajerita. Icantiri: —Paanajeri. Irosati ijatantanaca, yaanajiri. ");
INSERT INTO cniNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ijatanaque iriori Nicoremo. Iriotaque jatashitiriniri peerani Jesoshi tsiteniriqui. Yaacotanaqueneri intiritanteariri. Iconoaquero oyashi inchato pajitachari mira, ovane inchato pajitachari aroeshi. Aamaaca otenati 45 quiro. ");
INSERT INTO cniNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yaajeitanaqueneri Jesoshini. Iro tocoyatsa yapinaicacotantacariri, itsipataquero casancajari. Irootaque yametari joriopee, ariorica yovetsiquiri camatsiri. ");
INSERT INTO cniNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Otiminta panquirentsi quempeji ipajacojeitaquerinta. Anta panquirentsiqui otiminta iroanteariri camatsiri, iroaquera imoqueetiro. ");
INSERT INTO cniNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Irotaintsi inquee catsirincaiteri, omoncaratanteari Yavisantaniri. Ineaquero Jose oquempejitaque omoro, irootaque yoantacariri Jesoshini anta. ");
INSERT INTO cniNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Otomincotapaaque. Tsiteniquera ojatamanaque Maria maquitarasato anta omoroqui yoavetacarinta Jesoshini. Oneapaatiiro jocanaja mapi yashitacotanteevetacariri. ");
INSERT INTO cniNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Narotaque iroamereni inintasanotiniri Jesoshi. Notsipatari anta Shimo Petero. Jero oshiashitapaaquena Maria. Ocantapaaquena: —Yayeetajiri Avincatsariteni. Te aneajeriji yoavetacarinta. Te nioteji jaocarica yoyeetajiriri. ");
INSERT INTO cniNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Irosati nojatantanaca apite. Nojatanaque yoavetacarinta. ");
INSERT INTO cniNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Noshianaca apite, nanaacotaqueri nainti Petero. Naro anaacotaqueriri nareetapaaca anta yoavetacarinta. ");
INSERT INTO cniNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Noivotapaaca, namenapaaque tsompoina. Noneajiro tocoyatsa ovaja omoroqui, iro cantaincha te nonqueapeeji. ");
INSERT INTO cniNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Impoitapaaji iriori Shimo Petero. Irinti queapaintsi tsompoina. Irosati ineapaaque iriori tocoyatsa. ");
INSERT INTO cniNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ora panio ipashicanteevetacariri iitoqui, te ontsipatearoji tocoyatsa. Apitivitaja, ovashitaja iroori. ");
INSERT INTO cniNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ari noqueanaque narori, noneapaaquero, irosati niotantanaca tinaanaja Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tequerata nonquenqueshiretajeroji Sanquenarentsi cantatsiri: “Incamavetaquearica Quirishito, aitaque intinaanaje”. ");
INSERT INTO cniNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Irosati nopiantanaja novancoqui. ");
INSERT INTO cniNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Irointi Maria catianaincha saiteriqui, iraacotaqueri. Oivotanaca, amenanaque tsompoina. ");
INSERT INTO cniNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Oneaqueri apite inampire Tasorentsi, iquitsaataro quitamarori. Isavicaque yoavetacarinta Jesoshini. Isavicaque aparoni iitoyeevetacari Jesoshini, irio itsipa iitiqui. ");
INSERT INTO cniNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Icantiro: —Tsinane, ¿paita piraantari? Ocantajiri iroori: —Yayeetanajiri novincatsariteni. Te nioteji jaocarica yoyeetajiriri. ");
INSERT INTO cniNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Irosati opitsocantanaja. Oneaqueri Jesoshi icatiapaaca, iro cantaincha te iotavaqueriji. ");
INSERT INTO cniNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Icantiro: —Tsinane, ¿paita piraantari? ¿Janica picoiri? Ojitavaqueri irio tsameetacoyetirori panquirentsipee. Ocantiri: —¿Avirompa aanajiriri novincatsariteni? Pincamantajenate jaocarica poajiriri. Aitaque naajanteri narori. ");
INSERT INTO cniNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Icantanajiro iriori: —Maria. Opitsocanaca iroori, ocantanaqueri: —Oametanari. ");
INSERT INTO cniNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Irosati avitsanotantacariri. Icantanajiro: —Poimpacajena: tequeratsita novajenoquea Apaqui. Meeca nocoaque pijatashijeiteri quemisantajeitanari, pincamantajeitapaajeri meeca novajenocajea Apaqui. Tempa iriotaque Tasorentsi. Tempa irisati Piri avirori, piotiri Tasorentsi ini, irootaque pipincatsatantacariri avirori. ");
INSERT INTO cniNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Irosati opocashitantajanari narori, aisati itsipapee iroamerepee, ocamantajeitapaajana: —Noneajiriyea Avincatsarite. Ocamantapaaquena icamantayetaquerori Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ishaavijiiteanaji meeca, napatojeitaja, nocarajeitajiri itsipapee iroamere. Notsaroacaajeitanacari jivatacaajeitiriri noshanincapee, yora oacantaqueriri Jesoshi, irootaque noyavitantacarori ashitacorontsi. Imapocashijeitapaajana Jesoshi, icatiapaaja nianqui. Icantajeitapaajana: —Piveshireajeitanajea. ");
INSERT INTO cniNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Irosati inijantajeitapaaquenaro iraco, aisati imerequi. Noneajeitavajiri Novincatsarite, irosati noquimoshirejeitantanaja. ");
INSERT INTO cniNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yapiitajana: —Piveshireajeitanajea. Tempa irio tiancaquenari Apa peerani, aisati meeca nonquempetacayempi avirori, nontianquempi. ");
INSERT INTO cniNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Irosati itasoncantajeitanaquena, joo. Icanti: —Meeca ompocashijeitempi Ishire Tasorentsi, quiso oajeitanaquempi. ");
INSERT INTO cniNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ariorica pineaqueri ashaninca iquemisantasanotaquena, irosati pincantanteariri: “Incavintsayempi Tasorentsi avirori, eiro iquishimentimpirotsi pantayetiri”. Irootaque pincanteriri: tempa aitaque incavintsaasanoteri Apa yora pincanteri. Pincanteririca itsipapee: “Te pinquemisanteji, irootaque inquishimentantempirori Tasorentsi pantayetiri”, aitaque inquishimentaqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ipocashijeitantaquenari, te aneriji irinti Tomashi, yora ipajiyeetiri Tsipari; aparoni peaincha. ");
INSERT INTO cniNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ari ipocapaaji iriori, nocamantavajiri: —Noneajeitajiriyea Avincatsarite. Icantanaque: —Nocoi noneero iraco, ora oqueaqueri quiravo, noninti noiminqueero nacotsapaqui. Aisati noninti noiminqueero naco imerequiqui. Eirorica noiminqueirotsi, eiro noquemisantitsi. ");
INSERT INTO cniNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Avisanaque 8 quitaiteri, ari napatojeitanaja aisati pancotsiqui, itsipajeitajana iriori Tomashi. Oshequi catsini notsaroacaajeitacari quisajeitanari, irootaque noyavitantacarori ashitacorontsi. Imapocapaajana aisati Jesoshi, icatiashitapaajana nianqui. Icantajeitapaajana: —Piveshireajeitanajea. ");
INSERT INTO cniNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Irosati icantantanacari Tomashi: —Pamenero naco. Pancote, poiminqueero pacotsapaqui aca. Pancote aisati, poiminqueero paco nomerequiquica. Eiro pitseencajanatsi aisati, pinquemisante irointi. ");
INSERT INTO cniNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Irosati yacantanacari Tomashi: —Avirotasanotaque novincatsarite, avirotasanotaque notasorentsite. ");
INSERT INTO cniNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Icantanaqueri Jesoshi: —Meeca pineajana, irootaque piquemisantantajanari. Timatsi caari neenane, iro cantaincha inquemisantajeitena; inquimoshiretasanojeitanaque irinti. ");
INSERT INTO cniNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Oshequi catsini itasoncantayetaque Jesoshi. Narojeitaque iroamere, noneajeitaqueri, iro cantaincha te nosanquenajeiteroji maaroni aca. ");
INSERT INTO cniNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nosanquenajeitaquero oca pinquemisantantajeiteariri Jesoshi iriotaque Quirishito, yora Itomi Tasorentsi. Ariorica pinquemisantajeitaqueri, aitaque iraneacaajeitajempi anta inquitequi, pincantaitatiyempani. ");
INSERT INTO cniNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Irosati inijaantajeitajana aisati Jesoshi, aisati itsipapee iroamerepee. Noneajeitajiri otsapijaqui incajare Tiveriashi. Aitaque ocantari. ");
INSERT INTO cniNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Napatojeitaca, nocarajeitiri Shimo Petero, jeri iriori Tomashi: icanteetiri aisati Tsipari. Jeri Natanaeri poneachari Canaqui, onta carireaquiniri. Narojeitaque itomipee Severeo. Jeri aisati apite pashini iroamere Jesoshi. Napatojeitaca maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Icantajeitana Shimo Petero: —Nojate nonquitsate. Nocantajeitanaqueri: —Narosati, noijajeitanaquempi. Ari nojajeitanaque. Notejeitapaaca pitotsiqui. Noquitsajeivetaca, irosati noquitaitetacotantacari. Tecatsi naye. ");
INSERT INTO cniNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Oquitaitetamanaji, irosati icatiantapaaja Jesoshi otsapijaqui. Te niojeitavajeriji. ");
INSERT INTO cniNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Icantajeitana: —Ayompari. ¿Chorampa shima? Nacajeitanaqueri: —Te aneeriji. ");
INSERT INTO cniNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Icantajeitana: —Pinquitsataje aisati pacosanoriqui, aitaque paye. Ari noquitsajeitanaji. Naajeitaque oshequi catsini shima, te naaveacoteriji nontetacoteri pitotsiqui. ");
INSERT INTO cniNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Naro iroamere inintasanotiri Jesoshi. Nocantiri Petero: —Ja, iriotaqueyeatsi Avincatsarite. Ari isapocaquero Shimo iitsaare incaranqui, irointi itorosate. Iquemantaquenari, irosati iquitsaatantanajaro iitsaare. Ishiticatsaquitanaja. Ipiincacotanaquero iitsaare, pocn; yamaatashitanajiri, yaatapaaji. ");
INSERT INTO cniNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nimpoitacojeitapaaji narori, nonoshicacojeitiri shima. Quempejitapaaji otsapija, aamaaca ocarati 100 metero. ");
INSERT INTO cniNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nomitajajeitanaque quipatsiqui. Noneapaaque oparasheti paamari, itashitiri shima. Otimi aisati tanta. ");
INSERT INTO cniNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Icantajeitavaquena Jesoshi: —Pamaquenari meeca shima piquitsataqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Itetapaaja aisati Shimo Petero, inoshicacotajiri shima quipatsiqui. Jaasanotaca antearipee shima, icarati 153. Yoshequiasanovetaca catsini, iro cantaincha te ompesanaqueji noquitsatantariri. ");
INSERT INTO cniNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Icantajeitana Jesoshi: —Pimpocajeite meeca poajeitapeempa. Notsaroacaacari noncanterime: “¿Janicampimpa?” Maaroni niojeitaqueri Avincatsarite ini. ");
INSERT INTO cniNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Irosati iquempejijeitantaquenari Jesoshi. Yaaquero tanta, ipajeitaquena. Aisati shima, ipajeitaquena maaroni. ");
INSERT INTO cniNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Icamavetaca Jesoshi chapinqui, itinaanaja. Mavatanaque meeca inijaajana. ");
INSERT INTO cniNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Noajeitaca. Irosati isampitantajari Jesoshi: —Shimo, itomi Jonashi, ¿panaacojeitaquerimpa yocapee, pinintasanotana avinti? Yacanaqueri iriori: —Aviro, Novincatsarite, iotatsiri nonintimpi. Icanti: —Pimperi novishajaniquite iroyea. ");
INSERT INTO cniNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yapiitajiri aisati isampitajiri: —¿Pinintanampa? Yacanajiri aisati: —Je, Novincatsarite. Aviro iotatsiri nonintimpi. Icantiri: —Pinquempoyeajeitenari novishate. ");
INSERT INTO cniNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mavatanaque isampitiri: —¿Pinintasanotanampa? Irosati iquenqueshireantanaca Petero. Iro iquenqueshireantanacari, mavatanaque isampitaqueri: “¿Pinintanampa?” Yacanajiri aisati: —Avirotaque, Novincatsarite, iotirori maaroni. Piotana avinti nonintasanotimpirica. Icantiri: ");
INSERT INTO cniNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","—Pimperi novishate iroyea. Queariotaque oca noncamantempiri: peerani, ainiroquera pevancariveitani, piquitsaatapiniveitaroni piitsaare. Pijatapiniyetini jaocarica pinintiri: tecatsi tsaneempineri. Iro cantaincha ariorica panteashiparitasanotapaaque, pancotsaye pacoqui, iroisoyeetempi, inquitsaatajempi itsipapee. Iraanaquempi tenta pincoavetea pijate. ");
INSERT INTO cniNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Aitaque icantaqueriri. Yoametaqueri jaoca incanteari incamanteari Petero iriori. Ariorica irineeteri incamaque, irioyeetanaque ipincatsaritasanoti Tasorentsi. Irosati icantantanajari: —Tsame, poijatanaquena. ");
INSERT INTO cniNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ipitsocanaca Petero. Ineaquena noijatanaqueri, tempa naro iroamere Jesoshi inintasanotiri. Chapinqui noacaajeitantacariri Jesoshi, naro sampitaqueriri: “Novincatsarite, ¿janicampa aacantempineri?” ");
INSERT INTO cniNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ineantaquenari Petero, ijicotana, aisati isampitiri Jesoshi: —Novincatsarite, ¿jaoca incanteeteriri coajica yora? ");
INSERT INTO cniNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Icantanaqueri: —Noninterica intimavaqueta aca irosati nompiantajeari, eiro piquenqueshiretirotsi. Poijatenata nainti. ");
INSERT INTO cniNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yovaajeitaquero maaroni quemisantatsiri icantiriri Jesoshi. Ijijeivetaca eiro nocamitsi. Iro cantaincha te incanteriji Jesoshi: “Eiro icamitsi Joa”. Irointiquea icantavetari: “Noninterica intimavaqueta aca irosati nompiantajeari, eiro piquenqueshiretirotsi”. ");
INSERT INTO cniNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Narosanotaque iroamereni Jesoshi, sanquenatirori oca. Ayojeitaque queariotasanotaque oca nosanquenataqueri. ");
INSERT INTO cniNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Timatsi oshequi pashini yantayetaqueri Jesoshi. Ariorica nontsoteaquerome nosanquenatacotaquerome maaroni, eiro onarome quipatsiquica sanquenarentsi. Joa");
INSERT INTO cniNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","¿Ainirompi Tiojiro? ¿Tecatsimpa oyempine? Peerani nintantacarori nosanquenatantaquempironiri, noquenquetsatacaimpironi maaroni yantayetiniri Jesoshi. Aisati noquenquetsatacaimpiro maaroni yoametantayetiniri. ");
INSERT INTO cniNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Ari oshequi ineacatsitacaro, icamaque, itinaanaja aisati, irosati yonijaantapaajariri iroamerepeeni. Oshequi ineacotapinijeitajiri yantayetapaajiri, irootaque iotasanotantajariri itinaanaja. Ocarati 40 quitaiteri yonijaapinitantajariri. Iquenquetsatacotaquero jaoca icantari Tasorentsi ipincatsariventanti. Itiancajeitaqueri iroamerepee, iriotaque yora icoyeajeitaqueri. Iro cantiriri Ishire Tasorentsi. Impoiji yoancajiri Tasorentsi inquitequi, irosati narori novecaratantacarori noyenquetsare peerani. Meeca novaajempiro: noncamantajeitempiro yantayetiri iriori iroamereni Jesoshi, yora itiancanaqueri peerani. ");
INSERT INTO cniNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ari yoacaajeitajari Jesoshi. Icantasanotaqueri: —Eirota pojoquitarotsi Jerosare; nocoaque poyeavaquerota icashiacaaquempiri Apa: ora piquemitaquenari peerani nocamantitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yora Joani ivaotisajeitaquempi nijaqui iojeitantacari atiri piquemisantajeitirini. Iro cantaincha eiro osamanititsi ompocashijeitempi Ishire Tasorentsi, quiso oajeitempi iriojeitanteari atiri queario piquemisantaquena narori. ");
INSERT INTO cniNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yora apatotimentacariri, isampijeitiri: —Novincatsarite. Arojeitaque ishanincani yora intacaroniri Ishiraeri. Peerani itimaveitani pincatsariventaveitariniri ashanincani; meecampa, tecatsi. ¿Ariompa meeca pincanteri pashini impincatsariventajeitajena? Oshequi nocoajeitaque. Yacanaqueri: ");
INSERT INTO cniNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","—Te incoacayempiji Apa piojeitero jaoca oncarate. Osamanitatsirica, irompa jaocarica oncarate. Irintiquea Apa apaniro cantatsine. ");
INSERT INTO cniNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Coajica intasoncaventajeitempi, aisati ompocashijeitempi Ishire. Nocoaque pinquenquetsatacojeitena anta Jerosarequi, pintsoteaquero Jorea. Pinquenquetsajeite anta Samariaqui, aisati pintsoteanaquero anta pashinipeequi quipatsi. ");
INSERT INTO cniNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Irootaque icantanaqueriri Jesoshi. Ari yamenajeitavajiri, irosati yoajenocantanaja jenoqui, ipeanaja mencoriqui. ");
INSERT INTO cniNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ari yamenajeitavajiri sorerere, ijatanaji. Ari imapocapaaqueri apite shirampari, icatiimojeitapaacari. Quitamarori iitsaare. ");
INSERT INTO cniNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Icantapaaqueri: —¿Ainirompi, carireasati? ¿Paita pamenantarori inquite? Pineavajiri yora Jesoshi yoajenocanaja inquitequi. Iriotaque piajantsineri coajica aisati. Ariorica impiaje aisati, inquempetapaajea meeca ijatantanajari. ");
INSERT INTO cniNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ari ipiajeitanaja Jerosarequi iroamereni Jesoshi. Iponeanaja toncaariqui opajitanta Orivomashi. Oquempejitaro Jerosare, te arejiteji. ");
INSERT INTO cniNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ari yareejeitapaaja, yataijeitapaaji oshitamencotanta jenoqui. Anta imaapinijeitinta yora Petero, jeri Joa, Santiaco, Antirishi, Jeripi, Tomashi, Varitorome, Mateyo, Santiaco itomi Arijeo, Shimo yora Shintsitatsiri. Aisati imaapinitinta Jorashi, yora itomi Santiaco, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ari yapatojeitaja aisati iquenquetsatacaajeitiri Tasorentsi. Itsipajeitari irirentipeeni Jesoshi, jero Maria irinironi, jero otsipapee tsinane. Aitaque icantani iquenquetsatacaapinijeitiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ari pashini quitaiteri yora Petero icatiimojeitanacari iyemisantaririntepee. Aamaaca icarajeiti 120. Icanti: ");
INSERT INTO cniNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Noyemisantaririnte, moncarataca ocantiniri Sanquenarentsi. Peerani oametirini Ishire Tasorentsi Iravirini iquenquetsatacotantariniri Jorashini: yora jivajeitaqueriri aajeitaqueriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Aitaque acarajeiveitarini. Peerani itsipajeiveiteeni intacojeitantani, iro cantaincha ");
INSERT INTO cniNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","impoiji yaacantanirotaqueri Avincatsarite, ipinatashiyeevetacari quirequi. Yaavetacari, impoiji yoipiajiniri, iriotaque quirequi yamanantanteetajarori quipatsi. Impoiji irisati shiticajancha, shiti; itsatanaca. Impoiji ipesacotanaque, peti; iquenaitaque tirin; ipitiancapaaca; irosati itsirajantapaaca imotijaqui, tsira, osoquijanaque iramporetsa. ");
INSERT INTO cniNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iojeitaqueri maaroni jerosaresati. Irootaque ipajitanteetarori quipatsi yamananteetiri Asererama. Acantiri aneanequi arori: “Ivinaroni Jesoshi yoanteevetacariniri”. ");
INSERT INTO cniNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Aitaque isanquenayeetironi peerani pampoyeantsi cantatsiri: “Oncaarapancoitetanaque ivanconi aacanterineri Avincatsarite, eiro itimajitsi timantitajearine”. Aisati ocantini pampoyeantsi: “Ocameetsati intimaje poyeetajearineri quenquetsatacantajantsineri”. ");
INSERT INTO cniNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Tsame meeca ancanteri itsipa: “Pimpoyeetajeari Jorashini”: tempa irootaque icoacaaqueeri Tasorentsi. Iriotaque ancanteri tsipatitapinijeiteeniri peerani: neasanotiriri Joani ivaotisatantini, aisati neapinitiriri Jesoshi. Acoaque neaqueriri itinaanaja aisati ijatanaji jenoqui: ancanteri incarajeitee anquenquetsatacojeiteri Jesoshi. ¿Janicampa meeca ancanteri? ");
INSERT INTO cniNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ari icanti itsipa: —Iriorica yoca Jose Varasavashi, ipajiyeetiri aisati Joshito. Terica, iriorica yoca Matiashica. Ari icajemiri apite: —Caate aca nianqui. ");
INSERT INTO cniNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Impoiji iquenquetsatacairi Tasorentsi, icantiri: —Novincatsarite, aviro avinti iotirori jaoca icantajeitari maaroni atiri. Jeri yoca apite. Piotacayenari janicarica picoasanotaqueri avinti ");
INSERT INTO cniNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","poyeetajearine Jorashini. Tecatsi incantea meeca iriori inquenquetsataje aisati irintacotantajea: tempa camaque ini, janirotaque anta Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Impoiji ipishoncajeitiro mapijaniqui iriotanteari janicarica icoacaaqueri Tasorentsi, irio icoyeaque Matiashi. Ari icaraveita itiancane Jesoshi 11. Meeca icarajeitajiri aisati Matiashi. ");
INSERT INTO cniNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ari omoncaratapaaja meeca quitaiteri ipajiyeetiri: “Pentecoshiteshi”. Ari yapatojeitaca Jerosarequi quemisantajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Omapocashitapaacari, iquemavaquero shiavetarori tampea antearo, oneapaaque, sooo. Oponeanaca jenoqui, otsoteapaaquero pancotsi isavicajeitantari. ");
INSERT INTO cniNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aisati oconijatimotashitapaacari shiavetacarori paamari, ovaraapaaca; opomencajeitapaaqueri iitopeequi maaroni savicajeitaintsiri, pomein. ");
INSERT INTO cniNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Otimantashirejeitapaacari Ishire Tasorentsi. Irosati ineanatantanacaro otsipapee neantsipee, imajeitaquero ora oneaveetacaaqueriri Ishire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ari isaviqui anta Jerosarequi joriopee, quemisantasanotatsiri, iponeayetaca pashinipeequi quipatsi, jaocaricapee. ");
INSERT INTO cniNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Iquemantajeitavacariri ineanajeitanaque, irosati yapatojeitantaca oshequi atiri. Iquemajeitapaaquero irineanesanori. Te iriotacotapeeriji. ");
INSERT INTO cniNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yoajeitapaaque cavaco, iquenqueshireajeitapaaca, isampitavacaajeitapaaca: —Tempa carireasati inajeiveta yoca neaveetaintsirica. ");
INSERT INTO cniNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Jaoca icantacari iquemantajeitajarori maaroni aneanepee? ");
INSERT INTO cniNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Meeca acarajeitaqueri paratosati, merosati, eramitasati. Jeri savicatsiri Mesopotamiaqui, Joreaqui, Caparoshiaqui, Pontoqui, Ashiaqui, ");
INSERT INTO cniNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Jirijiaqui, Pampiriaqui, Ejipitoqui. Aisati acarajeitaqueri poneayetainchari otsapitapaaca Iriviaqui anta oquempejitapai Shirene. Jeri aisati acarajeitaqueri quivantatsiri poneayetachari Oromaqui. ");
INSERT INTO cniNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Acarajeitaqueri joriosanotatsiri aisati peajanchari jorio. Acarajeitiri queretasati aisati aravesati. Iro cantaincha aquemajeitaqueri ineanajeitantaro aneanesanoripee. Iquenquetsatacotiri Tasorentsi, jaoca icanta itasoncantayeti. ");
INSERT INTO cniNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ari yoajeitanaque atiripee cavaco, te iriotacoteriji. Isampitavacaajeitanaca: —¿Paitaquea iquemantarori aneane? ");
INSERT INTO cniNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Irinti pashini, ishirontimentajeitanacari, icanti: —Ishinquijeitaca yonta, iji, iji, iji. ");
INSERT INTO cniNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ari ainiro anta iriori Petero, icarajeitiri itsipapee itiancane Jesoshi. Quimojenca icamantaqueri: —Nojorioririnte: maaroni aviro savicajeitatsiri aca Jerosarequi, piojeitavaquero oca noncamantempiri, pinquemisantajeitavaquena. ");
INSERT INTO cniNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Pijitashijeivetacari ishinquijeitaca yocapee. Ja, te irishinquijeiteaji. Tempa ashinquitapinijeita tsiteniriqui, iro cantaincha oquitaitetamani meeca, tequera irijenoquitapeeji catsirincaiteri. Tequera omoncarateaji ishinquitapiniyeeta, ");
INSERT INTO cniNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","irointi oca piquemaqueri icamantacotiri camantantaveitachaniri peerani Joirini: ");
INSERT INTO cniNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Icanti Tasorentsi: ‘Coajica irineajeitero maaroni atiri nontianqueneri Noshire. Incamantantayete itomipee, irishintopee. Yora evancaripee irioshiretashitearo paitapeerica. Aisati irimishiveetashitea anteashiparipee. ");
INSERT INTO cniNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jeri quemisantajeitenane: shiramparipee, tsinanepee, nontiancajeiteneri Noshire, inquenquetsatacotantenari. ");
INSERT INTO cniNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ari nomatero coajica caari pineapiniti inquitequinta jenoqui, aisati aca quipatsiqui: poajeitanaquero cavaco. Aitaque pineajeitero coajica irirajani camajeitatsineri, aisati pineavaquero ontaajeitanaquea pancotsipee: oshequi oncachaajencatanaque. ");
INSERT INTO cniNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Irijivate intsivacanaque catsirincaiteri; aisati yora cashiri, inquitioncatanaque, irishianaquero irajantsi. Impoijiquea omoncaratapaaquea quitaiteri irareetantapaajeari Avincatsarite. Oshequi irimatapaaque, iriotacojeitaqueri maaroni atiri. ");
INSERT INTO cniNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Iroavisacojeitea maaroni aventajeitearine’ ”. Irootaque isanquenatiniri Joirini. ");
INSERT INTO cniNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Aisati icanti Petero: —Noshaninca. Pinquemisantavaquero oca noncamantempiri, nonquenquetsatacoteri Jesoshi, yora nasaretesatini. Itasoncantayeti, imayetaquero caari aneapiniti. Aisati imayetaquero paitapeerica, ayotantariri itasorentsitasanotaque. Tempa pineapinijeitaqueri avirori, piotitacari. Tempa irio Tasorentsi matacaaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Peerani aitaque iotacotitarini, icantitani: “Aitaque oncanteari, impimanteeteri yora Jesoshi”. Irio caari cameetsatatsi oaqueriri, iro cantaincha pipajacotacantajeitaqueri avirori, poamaacantajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ari oshequi iquematsicayetacaro, icamanaque, torein. Iro cantaincha yoitinaajiri Tasorentsi, te incoacayeriji incamasanote. ");
INSERT INTO cniNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tempa isanquenatitacaroni peerani Iravirini irineane Jesoshi: “Niotaque quiso yoaquena Novincatsarite, isavicaque nacosanoriqui yamitacotapinitantanari, caari noashiretanta. ");
INSERT INTO cniNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Oshequi noquimoshireventaqueri, otimantari nocantantariri: ‘Apa, oshequi noveshireaca. Niotaque eiro pojocanatsi anta ishaaviji. Aisati eiro pishinetanatsi nompatsaye, tempa pineacameetsatana. Niotaque pimataquenaro oca picantaquenari. ");
INSERT INTO cniNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Piotacaaquenaro noncanteani naneasanotanaje, quiso avavacayea, noncanteani noveshireimentanaquempi’ ”. Irootaque irineane Jesoshi isanquenatiniri Iravirini. ");
INSERT INTO cniNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ari yovaajiro aisati Petero: —Meeca, noshaninca, noncamantasanotempi. Icamaque intacantaqueeri Iravirini, itijaca. Timatsiquera meeca itijacanta. ");
INSERT INTO cniNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Camantantatsiniri inaveitani. Iotasanotironi icantitariniri Tasorentsi: “Queariotaque oca noncamantasanotempiri, eiro namatavitimpitsi. Coajica impincatsariventante pishanincasanori, poyetajempineri”. ");
INSERT INTO cniNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Pineaquero, tequeratsitani intinaajeji Quirishito, iro cantaincha iotacotitacarini Iravirini. Tempa isanquenatini: “Incante Quirishito: ‘Apa, niotaque eiro pojocanatsi anta ishaaviji, aisati eiro pishinetanatsi nompatsaye’ ”. ");
INSERT INTO cniNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iriotaque Jesoshi yoitinaajiri Tasorentsi. Aitaque noneajeitaqueri narori, meeca nocamantasanotaquempiro. ");
INSERT INTO cniNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Impoiji yoancajiri anta iracosanoriqui, icaratantapaajariri ipincatsariventanti. Irosati quiso oantacariri Jesoshi Ishire Tasorentsi, ora icashiacaaqueriri Iriri. Meecaquea, itiancajeitaquenaro narori aca: irootaque pineantajeitaquenari aisati piquemajeitantaquenari. ");
INSERT INTO cniNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pamene, te irio quenquetsatacotajanchane irisati Iravirini peerani, irintiquea iquenquetsatacotiri Quirishito. Te irovajenocajeaji irinti Iravirini jenoqui, irintiquea Quirishito. Tempa isanquenatitani peerani: “Tempa irio Tasorentsi cantiriri Avincatsarite Quirishito: ‘Pisavicapee aca nacosanoriqui, pincaratena ampincatsariventante ");
INSERT INTO cniNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","irosati impincatsajeitantempiri maaroni quisajeivetimpiri’ ”. ");
INSERT INTO cniNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Aisati icantajeitiri Petero: —Tempa arojeitaque ishanincani Ishiraerini. Cameetsa iriotasanojeitero ashanincajei oca nocantaquempiri: pipajacotacantavetacari Jesoshi, iro cantaincha yoitinaajiri Tasorentsi, ipeavajiri aisati Pincatsari, irisati Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Iquemantajeitavacarori oca, oshequi iquenqueshiretasanojeitanaca. Isampijeitiri Petero: —Noshaninca, ¿jaoca noncantajeiteari? Yacanaqueri: ");
INSERT INTO cniNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","—Pinquenqueshireajea, eiro piquempetajatsi peerani. Paventajeitajeari Jesoquirishito aisati pivaotisatimentajeitajeari, incavintsaajeitantempiri Tasorentsi, eiro iquenqueshireacotajimpirotsi aisati caari cameetsatatsi pantajeiveitaniri. Irootaque quiso oajeitantempiri aisati Ishire intianquempiri. ");
INSERT INTO cniNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Irootaque icashiacaajeitaquempiri avirori; aisati icashiacaajeitaqueri iriori pishanincatajeari coajicani, jeri aisati maaroni arejipeequiniri iriori. Irootaque icashiacaajeitaqueeri maaroni; irootaque icoacaajeitaqueeri Avincatsarite, ariorica anquemisanteri. ");
INSERT INTO cniNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Oshequi pashini icamantasanojeitiriri, icoaque inquemisantacayeri. Jero oca icantaqueriri aisati: —Poavisacojeitea. Pishiajeitaricari timajeitatsiri meeca: yora caari cameetsajeitatsi. ");
INSERT INTO cniNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ivaotisajeitaca maaroni quemisantajeitaquerori irineane, aamaaca icarajeitaque 3,000. ");
INSERT INTO cniNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Icantatiani iquemisantapinijeitiro oca yoamejeitiriri. Icantatiani cameetsa iquempeavacaajeitaca: itsipatavacaajeitaca icarajapinijeitiro tanta, iquenqueshirejeitantacariri yora camimentajeiteeri, aisati iquenquetsatacaapinijeitiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yora quemisantatsiri imatapinitaqueneri atiripee caari ineapinijeiti, aisati imayetaquero paitarica iotantacariri queario itsipatari Tasorentsi. Yoajeitanaqueri cavaco maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ari iquempeavacaajeitaca quemisantajeitatsiri. Te irimashitsajeiteji, irointi ipavacaapinijeita timimojeitiriri, paitaricapee. ");
INSERT INTO cniNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ipimantajeitiro irovaararo, iipatsite aisati. Ipaarantajeitiri maaroni ishaninca coiteimojeitariri. ");
INSERT INTO cniNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Maaroni quitaiteri ijatapinijeiti anta ivancoqui Tasorentsi. Aisati icarajajeitaquero tanta ivancopeequi iriori, iquenqueshireantariri camimentajeitaqueeri. Ariorica yoajeita, iquimoshiretasanojeiti, aisati cameetsa ipashitavacaajeitaca. ");
INSERT INTO cniNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Icantajeiti: —Cameetsa ini Tasorentsi. Jeri yora maaroni timajeitatsiri ineacameetsajeitaqueri quemisantatsiri. Icantatiani maaroni quitaiteri iquemisantaque pashini atiri, yoshequiacaasanojeitaqueri Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pashini quitaiteri, jenoquiquera catsirincaiteri, irotaintsi omoncaratea iquenquetsatacaantapinitariri jorio Tasorentsi. Itoncaanaque Petero, jeri Joa anta ivancoqui Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ainiro isavicaque anta aparoni shirampari, choriveetatsiri iitiqui. Aitaque icantitapaa peerani, iroaquera itimapaaque. Ari maaroni quitaiteri yameetapinitiri omoroqui pancotsi ipajiyeetiri: “Cameetsari omoro”. Aitaque yoyeetapinitiriri omoroqui iramananteariri iirequite queayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yora Petero, jeri Joa irovetaincha inqueajeitapeeme pancotsiqui, iro cantaincha ineavaqueri, icantavetavacari: —Pincavintsayena noshaninca, pimpena quirequi. ");
INSERT INTO cniNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ari yamenapaaqueri Petero, icantiri: —Pamenenate. ");
INSERT INTO cniNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yamenasanovetavacari, ijitashivetaca ari impaquerime paitarica. ");
INSERT INTO cniNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Iro cantaincha icantanaqueri: —Tecatsi noirequite, iro cantaincha nocoaque noncavintsayempi. Noncanteri Jesoquirishito, yora nasaretesati iraniitacaajempi irinti, paniitantajeari. ");
INSERT INTO cniNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yajiricaqueri iracosanoriqui, yoatiaqueri. Intsipaite yavisacotaji, ishintsitanaji iitiqui. ");
INSERT INTO cniNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ishintsiti icatianaja, cati. Icatiasanotanaja, yaniitanaji. Itsipatanacari, iqueanaque pancotsiqui. Isapocasapocatanaque, icantanaque: —Cameetsa ini Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ineajeitavaqueri maaroni atiri: yaniitanaji. Iquemajeitavaqueri icantanaji: —Cameetsa ini Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ari iojeitavaqueri, iriotaque yoca savicaveitachaniri omoroqui, amanantaveitachaniri quirequi. Ineajeitaqueri yavisacotaji, irootaque yoajeitantanacariri cavaco. Te iriotacoteriji. ");
INSERT INTO cniNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ari yajiricasanotajiri Petero, jeri Joa. Inajeitaque anta yapatotapinijeitanta: irio Saromo vetsicacantironiri peerani pancotsi. Irosati ishiashitantapaacari maaroni atiri, yoajeitanaqueri cavaco. ");
INSERT INTO cniNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ineavaqueri Petero, icantavaqueri ijorioririnte: —Noshaninca, ¿paita poajeitantanacari cavaco? ¿Paita pamenantajeitanari, sorerere? Eiro pijitashitanatsi naro Tasorentsi naniitacantajariri yoca choriveitachaniri. Eiro aisati pijitanatsi noquemisantasanoti nomatantajariri. ");
INSERT INTO cniNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","14","Irinti Tasorentsi oavisacotajiriri. Peerani iquemisantaveitarini Avarama, Isaca, Jacovo, jeri aisati maaroni intacantaroniri. Ocameetsati pinquempejeiteari iriorini, pinquemisantajeiteri Tasorentsi. Iriotaque neacameetsatasanotiriri Jesoshi, icanti: “Pineaqueri, icameetsatasanoti Notomi, yantaquenaro maaroni nocoacaaqueriri”. Queario icameetsatasanoti Jesoshi, catsini. Iriotaque paacantaqueri. Iro iroimpacaajerime Pirato, aiquero picantacoventatiiri: “Te noncoyeji poimpacaajeri”, irinti picoaqueri yoipacajimpiri oantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Poacantaqueri oaneajeitiriri atiri. Icamavetapainta, impoiji yoitinaajiri Tasorentsi. Aisatitapaaji, noneajeitajiri. ");
INSERT INTO cniNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jeri yoca shirampari: iquemacotantavacariri Jesoshi, iquemisantaque, irootaque yavisacotantajari. Jerica pineaqueri. Tempa piojeitiri. Ari iquemisantaque, irootaque itecatsitantajari. Pineaqueri meeca yaniitanaji. Aisati icantajeitiri Petero: ");
INSERT INTO cniNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","—Ari noshaninca, meeca niotaque te piojeiveiteani avinti. Aisati iquempeta avincatsaritepee, te iriojeiveiteani. ");
INSERT INTO cniNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Imataquero Tasorentsi oca icantitaniri peerani: “Coajica oshequi inquematsicatearo Quirishito, incamimentajeiteri atiri iroavisacotantajeariri”. Tempa iquenquetsatacotitarini Quirishito maaroni yora camantantatsiniri. ");
INSERT INTO cniNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pinquenqueshirejeitanaquea, eiro piquempejeitajatsi peerani, irointiquea pinquemisantajeite; impoiji incavintsayempi Tasorentsi: iroameetsajeitempi, eiro iquenqueshireacotajimpirotsi aisati caari cameetsatatsi pantaveitaniri. Irosati intsipajeitantempiri Avincatsarite, iriveshireacaajeitempi. ");
INSERT INTO cniNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Aisati intianquempiri Jesoshi, yora Quirishitotatsiri. Tempa peerani icamantasanotaquempini. ");
INSERT INTO cniNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Incantaitatiyempani intimapaaje anta jenoqui, irosati iroameetsatantayetaquearori maaroni, paitapeerica. Tempa irootaque icantiniri peerani yora camantantatsiniri, yora yoameetsajeitiri Tasorentsi: iriotaque neanatacaajeitiriniri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Icantini Moishishi: “Yora Avincatsarite Tasorentsi intianquempiri camantajempineri, inquempetajena narori itiancaquena. Avirotaque irishanincatajeari. Paitarica incamantempiri, pinquemisantavaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Irinti maaroni caari quemisantiri iriori, eiro quiso yoiritsi ishaninca, irointiquea intsoncajeitajeri”. ");
INSERT INTO cniNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Iquenquetsatacotitaroni peerani maaroni camantantajeitatsiniri oca pineayetaqueri meeca. Jeri yora Samoirini, intacaroniri, jeri aisati maaroni impoijeitiriri. Iquenquetsatacojeitiro, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aitaque ashanincajeitacari yora camantantatsiniri. Peerani icantirini Tasorentsi Avarama: “Coajica iriveshireimentajeiteari maaroni atiri pishanincani: yora Quirishito pocatsineri”. Moncarataca icantaqueriniri. Ocameetsati meeca piveshireimentajeiteari. ");
INSERT INTO cniNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Itiancaqueri aroriqui, ijivajeitaquee yoamejeitaquee. Ainiro pantajeitiro caari cameetsatatsi, iro cantaincha ipocashijeitimpi iroavisacojeitempi eiro pashinoncanta; icoaque iroveshireacaajeitempi. ");
INSERT INTO cniNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Irosatiquera iquenquetsatacairi Petero ishaninca, ari ipocapaaque saserotepee. Jeri aisati jivatacairiri atiri anta ivancoqui Tasorentsi. Jeri saroseopee. ");
INSERT INTO cniNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Icantashirejeitanaque, icantavacaanaca: —Paitateemi yoametantariri atiri. Jero icamantaqueriri: “Intinaye camajeitatsiri: tempa itinaaja Jesoshi”. Te oncameetsateji oca yoamejeitiriri. ");
INSERT INTO cniNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ari ishaaviniji catsirincaiteri, irosati yaantacari, tapi. Yaajeitanaqueri, yoiminqueajeitapaaqueri, ari iquitaitacojeitaque. ");
INSERT INTO cniNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Iro cantaincha iquemisantaque oshequi quemajeitavaqueriri Petero, aamaaca icarajeiti 5,000 shirampari, quemisantajeitaintsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Oquitaitetamanaji yapatojeitaja aisati anta Jerosarequi pincatsaritatsiri, savicacantantatsiri, oametantirori sanquenarentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Icarajeitiri Anashi, yora ivincatsarite saserote. Aisati yapatotiri Caijashi, Joa, Arijantero, jeri maaroni ishaninca ivincatsarite saserote. ");
INSERT INTO cniNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ari icajemacantaqueri quemisantatsiri, isatecaqueri nianqui, isampijeitaqueri: —¿Janica matacaaquempirori oca? ¿Janicampa cantaquempiri? ");
INSERT INTO cniNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ari oametaqueri Ishire Tasorentsi Petero, omatacaasanotaqueri. Iquenquetsatacaajeitaqueri apatotimentajeitariri: ");
INSERT INTO cniNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","—¿Iriompa pisampitacoventiri yora choriveitachaniri ineshinoncatiri Tasorentsi? Pineaqueri, avisacotanaji ini. ¿Picoaquempa piote jaoca icantacari yavisacotantajari? Pinquemajeitavaquero oca. Aisati ocameetsati iriojeitavaquero maaroni ashanincapee. Iriotaque Jesoquirishito, yora nasaretesati, oavisacotajiriri. Pipajacotacantavetacari, iro cantaincha yoitinaajiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iriotaque Jesoshi shiacantachari mapitatsiri itseencaqueri vetsicavetarori pancotsi: iro cantaincha ipeaqueri Tasorentsi itincamitantarori. Avirojeitaque avinti shiaqueriri vetsicavetarori: pitseencaqueri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Iro cantaincha te intimeji pashini oavisacotantatsineri: te intimeji aca quipatsiqui pashini oavisacojeiteeneri: apaniro Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ari yoajeitanaqueri cavaco yora pincatsaripee, icanti: —Pineajeitaqueri, te intsaroajeitanaqueji iriori. ¿Paita caari itsaroacantajeitee? Aisati te intsoteavetearoji sanquenarentsi, te irishitoriotasanovetearoji, iro cantaincha oshequi ioti. ¿Paitaquea iotacairiri? ¿Iriompa oametiriri Jesoshi, yora quiso yoaveitaniri? ");
INSERT INTO cniNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ari ineajeitaqueri itsipatacari yora yoavisacoyeetajiri. Tecatsi incantea incantimenteri. ");
INSERT INTO cniNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ari itiancajiri: —Pisoquijajeitanaje anta; ari coajica noncajemajempi aisati. Ari isoquijajeitanaji. Impoiji icantavacaajeitanaca iriori pincatsaripee: ");
INSERT INTO cniNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Jaoca ancanteriri yonta? Iojeitanaqueri maaroni jerosaresati itasoncaventaqueri yora choriveitachaniri. Tecatsi ancante: “Te irimateroji”. ");
INSERT INTO cniNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Te oncameetsateji inquenquetsatacaajeitajeri pashini atiri. Tsame ancantasanoterita: “Eiroyea meeca piquenquetsatacotajiritsi yora Jesoshi”. ");
INSERT INTO cniNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ari yapiitajiri, icajemajiri. Icantasanotiri: —Eiroyea meeca piquenquetsatacotajiritsi Jesoshi. Eiroyea picamantacotajiritsi. ");
INSERT INTO cniNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yacanaqueri: —Tempa ineajeitee Tasorentsi. Pincamantasanotenate: ¿cameetsampa nonquemisantempi? Tempa irio Tasorentsi nonquemisanteri. ");
INSERT INTO cniNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tecatsi noncantea meeca nojocajero noquenquetsatacotiro oca noneasanotaqueri, aisati oca noquemasanotaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ari yapiitajiri aisati icantasanovetajari, irosati itiancantajari. Tecatsi irante impasatimenteriri. Ineajeitaquero atiri oca imataqueri, icantapinijeitanaque: “Cameetsa ini Tasorentsi, oshequi imatacaajeitaqueri quemisantatsiri”, irootaque caari ipasatantari. ");
INSERT INTO cniNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Peerani imoncarataquero 40 irosarintsite choriveitachaniri. Ari oshequi iquenqueshirejeitaquero atiri yoavisacotiri Jesoshi, iojeitantacari itasorentsitaque. ");
INSERT INTO cniNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ari yoimpacaajeitajiri pincatsaripee, impoiji ijajeitanaji quemisantatsiri ishanincaqui. Icamantapaaqueri oca icantavetacariri yora cantavetacariri. ");
INSERT INTO cniNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iquemantavacarori oca, iquenquetsatacaajeitaqueri Tasorentsi. Antearojenca icanti: —Novincatsarite. Aviro vetsiquirori inquite, quipatsi, incajare, maaroni; aisati povetsicajeitaqueri maaroni timantajeitarori. ");
INSERT INTO cniNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Aisati peerani poametaquerini noshanincani Iravirini, yora quemisantimpiri. Oametaqueri pishire, isanquenatantarori oca: “¿Paita itseencajeitantacari yora pashinisatipee atiri? ¿Paita iquenqueshiretashitantarori caari cameetsayetatsi? ");
INSERT INTO cniNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yora ivincatsaritepee iraimanajeiveteari Pincatsarisanori, aisati yora Quirishitotatsiri; incoajeivetea intsoncajeiterime”. ");
INSERT INTO cniNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Aca nampitsiquica yapatojeitaca yaimanajeivetacari pitomi Jesoshi, yora pineacameetsatiri. Tempa pipeaqueri Quirishitotasanotatsiri. Icarajeiti aimanajeitantachari Eroreshi, Pontsio Pirato, joriopee, pashinisatipee atiri, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Peerani piotitani, picantitani: “Aitaque oncanteari”. Ari meeca imataquero yocapee. ");
INSERT INTO cniNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Meeca, Novincatsarite, piotaquero oca icantasanovetaquena: “Eiro piquenquetsatacotajiritsi Jesoshi”. Tempa narotaque quemisantimpiri. Pimatacaasanotena eiro notsaroantatsi nonquenquetsatasanotero pineane. ");
INSERT INTO cniNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pintasoncacoventante, poavisacotanteariri mantsiaripee; pimatapinitero caari ineapinijeiti, piotacaajeiteri atiri queario iriotaque Jesoshi pitomi, aisati pineacameetsatiri. ");
INSERT INTO cniNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Aitaque icantajeitiriri Tasorentsi. Impoiji onicanaca pancotsi isavicajeitantari. Otasoncacoventajeitapaaqueri Ishire Tasorentsi, irosati cameetsa iquenquetsatantarori irineane Tasorentsi, te intsaroimateji. ");
INSERT INTO cniNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Oshequi icarati meeca quemisantatsiri, cameetsa isavicajeitaque, aisati imoncaratavacaajeitaca: paitarica icoajeitiri aisati paitarica iquenqueshirejeitiri. Te irimashitsajeiteji, irointi ipavacaajeitacaro maaroni coiteimojeitariri. ");
INSERT INTO cniNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jeri iroamereni Jesoshi, icamantapinitiri atiripee: —Itinaasanotaja Avincatsarite Jesoshi. Aisati icantajeiti atiripee: —Tempa icameetsajeiti quemisantajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Yora maaroni ashiyetachari iipatsite aisati ivanco, ipimantajeitiro. Oca opinayetari, yamajeitaqueneri iroamereni Jesoshi, ipapaaqueri. Irosati ipaarantaqueriri itsipapee iriori coiteimotariri, caari yashinoncaajeitanta quemisantajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Icarajeitiri quemisantatsiri ishanincani Irevi, pajitachari Jose. Pashini ipajitiri yora itianqueetiri: Verenave. Ocanti ivajiro aneanequi arori: “Veshireacaantachari”. Iriotaque poneachari Tsipirequi. ");
INSERT INTO cniNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yashivetaro quipatsi, impoiji ipimantiro. Yaanaque ovinaro, ari ipapaaqueri yora iroamereni Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Iro cantaincha itimi pashini shirampari pajitachari Ananiashi, iro ijina Sajira. Ipimantiro iipatsite, ");
INSERT INTO cniNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","yaarantavaji ovinaro nianqui. Irointi cashetani aisati yaanaque, ipapaaqueri iroamereni Jesoshi. Icantapairi: —Jeri yoca quirequi, iriotaque maaroni ovinaro noipatsiteni nopimantaqueri. Iotaque aisati ijina iroori iramataviterime. ");
INSERT INTO cniNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Iro cantaincha icantavaqueri Petero: —Ananiashi, tempa paarantavaji ovinaro piipatsite. Yoametaquempi Satanashi, picoantavetacari pamataviterome Ishire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tempa iro piipatsiteni onaveitani, tempa iriotaque pashi ovinaro. Ocameetsati pinquempoyeri ovinaro. ¿Paita picantanirotantari: “Jeri yoca maaroni ovinaro noipatsiteni”? Pamatavivetaquena narori, iro cantaincha tecatsi pincanteri pamataviteri irinti Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Iquemantavacariri Ananiashi, irosati itaantanaca, poron. Icamanaque, toren. Itsaroasanojeitanaque catsini maaroni neajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Impoiji yovetsicajeitaqueri evancaripee intijeri; yaanaqueri, itijiri. ");
INSERT INTO cniNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Osamanitapainti capichaji, ari oqueapaaque ijinani iroori. Te ioteji camaque ojimeni. ");
INSERT INTO cniNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Icantavaquero Petero: —¿Pipaquenarimpa maaroni quirequi, ora ovinaro piipatsiteni pipimantaqueri? Ari acanaqueri: —Je, nopaquempiri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Irosati icantantacaro iroori: —¿Paita piquempetantariri pijimeni, pamataviterome Ishire Avincatsarite? Jeritapaaji tijaitiriri pijimeni: irisati aanaquempine avirori. ");
INSERT INTO cniNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Irosati oteimotantanacari, ocamanaque. Iqueapaaji yora evancari, ineapaaquero, camaque. Ari yaanaquero, itijaitiro iroori, itsipatajantiro ojimeni. ");
INSERT INTO cniNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ari itsaroajeitanaque maaroni yora quemisantajeitatsiri, aisati itsaroajeitanaque maaroni quemacojeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Oshequi itasoncaventanti yora iroamereni Jesoshi. Oshequi imayetaqueneri atiri, irosati yoantajeitanacari cavaco. Ari yapatojeitaca anta pancotsiqui yovetsicacantiniri Saromoni. ");
INSERT INTO cniNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Oshequi ipincatsajeitaqueri atiripee, irootaque itsaroacantajeitacariri intsipajeitajearime. Iro cantaincha icantajeiti atiripee: —Icameetsatasanojeiti quemisantajeitiriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aiquero ijatatii yoshequiasanotanaque quemisantiriri Avincatsarite. Oshequi icarajeiti shirampari, jero tsinane. ");
INSERT INTO cniNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yoapiniyetaqueri atiri mantsiaripee anta avotsiqui: yoiponaayetiri shitashintsiqui, oncanteata ariorica iravisanaque Petero, intsimancayetanaqueri iravisacotantajeari. ");
INSERT INTO cniNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Aisati yapatotashitaca oshequi atiri, poneayetachari nampitsipeequi anta otsapiyetapaa Jerosare. Yamayetaqueneri mantsiaripee, jeri aisati neiriri camaari. Yoavisacojeitajiri maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ari ocantimoneentanacari ivincatsarite saserote, jeri itsipapee: iriojeitaque saroseotatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ari yaacantaqueri yora iroamereni Jesoshi, yoiminqueacantavetacari caravosoqui. ");
INSERT INTO cniNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Iro cantaincha yananincaque inampire Avincatsarite, yashitareapaajiniri ashitacorontsi, yaanajiri saiteriqui. Icantiri: ");
INSERT INTO cniNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Pijataje anta ivancoqui Tasorentsi, pincatiapaaje. Pincamantasanojeiteri atiri jaoca incantajeari intimantajeari inquitequi, incantaitatiyempani. ");
INSERT INTO cniNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yacanaqueri: —Je, ari noncamantajeitaqueri. Ari iroaquera oquitaitetamani ijatanaque ivancoqui Tasorentsi, yoametantapaaji. Jeri ivincatsarite saserote, itsipajeitacari ishanincapee anta pashiniqui pancotsi. Yapatojeitiri oametavacainchari: yora ivincatsaritepee jorio. Ari icantiri variria: —Pijajeite anta poiminqueaquerinta oshaiteji quemisantiriri Jesoshi, pamajeitenari. ");
INSERT INTO cniNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ari ijatashivetari, te irineapaajeriji. Irosati ipiantaja, icantapaaqueri: ");
INSERT INTO cniNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Te aneajeriji. Noneapaaquero pancotsi, ashitasanovetaca ashitacorontsi, oyavivetaca. Ainiro icatiavetaca shentavetarori omoropee. Iro cantaincha nashitareavetapaacaro omoro, noquea vetapaaca; tecatsi noneapaaje tsompoina. ");
INSERT INTO cniNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Iquemantavacariri, icantavacaanaca: —¿Jaocaquea meeca iquenanajiri? —Jaocateemi. —¿Jaocaqueame ancanteriri? ");
INSERT INTO cniNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Irosati yareetantapaacari aparo camantapaaqueriri, icantapairi: —Yora shirampari poiminqueacantavetacari, catiajeitapaaja anta ivancoqui Tasorentsi. Yoamejeitapaajiri atiri. ");
INSERT INTO cniNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Irosati ijatashitantajariri capitano, yaajeitanaqueri variriapee, iro cantaincha itsaroacaacari ashanincapee; icanti: —Iquisacoventaricari atiripee quemisantatsiri, ipitseecari. Irootaque cameetsa yaantanacariri, te inquisanatanaqueriji. ");
INSERT INTO cniNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ari yaanaqueri, yoatiapaaqueri anta itiminta oametavacainchari. Icantavaqueri ivincatsarite saserote: ");
INSERT INTO cniNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿Paita piquenquetsatacantajariri aisati atiri? Tempa nocantasanovetimpi: “Eiro picamantacotajiritsi Jesoshi”. Meeca aiquero poamejeitatiiri maaroni jerosaresati. Jero oca picantacotaquena: “Irio saserotepee oacantaqueriri Jesoshi”. Te oncameetsateji picantajeitaqueri. Pimajerejeite, eiro picamantantajitsi aisati. ");
INSERT INTO cniNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Yacanaqueri Petero: —Eiro noquemisantiritsi atiri, irintiquea nonquemisantasanoteri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Queario avirojeitaque oacantaqueriri Jesoshi. Pipajacotacantaqueri coroshiqui. Irinti oitinaajiriri Tasorentsi, yora iquemisantiniri ashanincani peerani. ");
INSERT INTO cniNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yoancajiri anta iracosanoriqui. Ipeajiri Jivatacaajeitaqueeri, aisati Oavisacojeitaqueeri. Icoacaajeitaqueri ajorioririnte inquenqueshirejeitanaquea, impoiji incavintsaajeiteri, eiro iquenqueshiretajirotsi aisati caari cameetsatatsi yantajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aitaque noneasanotaquero yantayetaqueri Jesoshi, aisati niotaque quiso oajeitiri Ishire Tasorentsi maaroni quemisantajeitiriri. Irootaque noquenquetsatacaapinitiriri atiri. Tecatsi noncantea nomajerete. Impoiji icantajeiti itsipapee iroamereni Jesoshi: —Queario oca icantiri Petero. ");
INSERT INTO cniNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ari iquemantajeitavacariri, iquisajeitanaqueri, icoajeivetanaca iroyerime. ");
INSERT INTO cniNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ari icatianaca ishaninca pajitachari Camariyeri. Variseo ini, irisati oametantirori sanquenarentsi. Maaroni ineacameetsajeitiri atiri. Icanti: —Noshaninca, nocoaque irisoquijajeitanaque quemisantiriri Jesoshi, eiro iquemantaro noncantempiri. Impoijiquea impiaje aisati. Ari itiancajeitaqueri saiteriqui. ");
INSERT INTO cniNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Impoiji icantiri: —Noshaninca. Quearioya, pantiricari quemisantiriri Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Jeri itimaveitani peerani yora Teorashi, oshequi ishemetaqueni. Ari yapatotashivetacari oshequi iratiritepee, naamaaca icarajeiti 400. Yoyeetaqueri, impoiji inijantareavacaajeitanaca oijajeivetariri. Ipeashijeitanaca, tecatsi anquemacotajeri aisati. ");
INSERT INTO cniNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Impoitiri aisati Jorashi, yora carireasati. Anta isanquenatacojeitanta, aisati ijivatanaqueri aparopee atiri. Aisati iriori, yoyeetaqueri. Yovaraanaca oijajeivetariri, tecatsi aisati anquemacotajeri. ");
INSERT INTO cniNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ari meeca noncamantempi, eiro pineashirenquiritsi yocapee, incanteata. Iriorica tianquiriri atiri iquenquetsati, tempa aisati impeajeitanajea iriori. ");
INSERT INTO cniNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Iriorica tianquiriri Tasorentsi, tecatsi pincanteri poimajerenteri. Piquishimatiricari Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ari onimojeitanaqueri iriori. Icajemajiri aisati, ipasanatacaantaqueri. Impoiji icantasanovetari: —Eiro aisati piquenquetsatacotajiritsi Jesoshi. Irosati itiancantajariri. ");
INSERT INTO cniNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ari ijajeitanaque, Iquimoshirejeitanaque, icantajeiti: —Ineacameetsajeitee Jesoshi, irootaque ishinetantaqueeri aneacatsitimentajeitacari. ");
INSERT INTO cniNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Maaroni quitaiteri yoametantapiniti anta ivancoqui Tasorentsi, aisati pancotsipeequi. Icantani: yoametantapiniti, icamantantapiniti. Icantapinitiri ishaninca: —Iriotaque Jesoshi yora Quirishitotatsiri aamaajeitaniri peerani. ");
INSERT INTO cniNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Yoshequiantacari quemisantatsiri, jeri iquisashireanaca yora iotirori quirieco. Icantavacaanaca: —Maaroni quitaiteri, ariorica intacotanta, te irintacotearoji ashaninca arori: oca camajimentaaro. Apaniro intacotaro irointi iotirori evereo. ");
INSERT INTO cniNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ari yora iroamereni Jesoshi yapatojeitaqueri maaroni quemisantatsiri. Icantiri: —Te oncameetsateji nojocajero noquenquetsatapinitiro irineane Tasorentsi, nompantayetempirori poyeari. ");
INSERT INTO cniNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Meeca, noshaninca, pincoyeanontea 7 shirampari, yora pineacameetsatasanotiri. Pincoyeaqueri timatsiri iotantari, quemisantasanotirori Ishire Tasorentsi. Noncanterita iriori irintacotantea. ");
INSERT INTO cniNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Irompa nainti, apatiroti nonquenquetsatacoteri Tasorentsi, aisati noncanteani nonquenquetsatero irineane. ");
INSERT INTO cniNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Onimojeitacari oca icantaqueriri. Icoyeaqueri Ishiteva: quemisantincari ini, quemisantasanotirori Ishire Tasorentsi. Icoyeaqueri Jeripi, Pirocoro, Nicanori, Timo, Parimenashi. Aisati icoyeaqueri Nicorashi, yora peajanchari jorio, poneachari Antioquiaqui. ");
INSERT INTO cniNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Irosati yonijaantapaacari. Icantajeitiri Tasorentsi: “Pamitacojeiteri yocapee irintacotantea”, aisati yajiricainataqueri iitoqui. ");
INSERT INTO cniNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Oshequi icarati quemajeitaquerori irineane Tasorentsi. Aiquero ijatatii yoshequiti quemisantatsiri anta Jerosarequi. Aisati oshequi catsini icarati saserote shiretacarori oca aquemisantiri. ");
INSERT INTO cniNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Catsini icameetsashiretaque Ishiteva. Oshequi itasoncacairi Tasorentsi. Imatasanoyetiniri atiri caari ineapinijeiti. Imataqueneri paitapeerica iojeitantacari Tasorentsi ini Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ainiro yapatotapinijeitanta anta ivancoquinta Tasorentsi atiri yora ipimanteevetari peerani, iro cantaincha yoipacajiri amanantavetariri. Aisati anta yapatotanta shirenesati, arejantiriasati, poneachari Shirishiaqui, Ashiaqui. Ijatashijeivetacari Ishiteva, iquisatsajeivetacari aisati ipiatsajeivetacari. ");
INSERT INTO cniNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Iro cantaincha oshequi ioti Ishiteva yoametanti, tecatsi incantajeiteri impiatsatasanojeiteari. Ainiro iotantari, cameetsa ineanati aisati, tempa oametaqueri Ishire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ari oshequi iquisajeitaqueri yoranqui, icantiri pashini ishanincapee: —Pamene, nocoaque pintseeyacoteari Ishiteva. Ariorica pimajeitero nocantaquempiri, nompinatempi quirequi. Jero oca pincantacotashiteariri: “Noquemaqueri Ishiteva, itseenquimataqueri Moishishi. Aisati iquempetaqueri iriori Tasorentsi, icantimataqueri”. Icantiri: —Ari, noncamantajeiteri ashanincapee. ");
INSERT INTO cniNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iquemantacariri atiripee, iquisajeitanaca: savicacantantatsiri, oametantirori sanquenarentsi, maaroni. Jentsipaite ijatashijeitaqueri Ishiteva, yaapaintiri, tapi; yaajeitanaqueri anta yoametavacaapinijeitanta pincatsaripee. ");
INSERT INTO cniNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Yaanajiri aisati iriori yora tseeyachari, icantanirotapaaqueri: —Aitaque icantani Ishiteva, icantapiniti: “Te oncameetsateji ivanco Tasorentsi”. Aisati iquempetiro isanquenare Moishishi, itseencapinitiro. ");
INSERT INTO cniNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Noquemaqueri, icanti: “Yora Jesoshi, nasaretesati, intireajero oca pancotsica. Impashinitero oca ameyetacari, aisati impashiniyetajero yoameyetaqueeniri Moishishi”. ");
INSERT INTO cniNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yamenajeitaqueri maaroni savicajeitaintsiri, sorerere. Ishipaquireavorotanaque Ishiteva, iquempetanacari inampire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Isampitiri ivincatsarite saserote: —¿Queariompa oca icantaqueri? ");
INSERT INTO cniNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yacanaqueri Ishiteva: —Novincatsarite, pinquemisantajeitavaquena. Peerani isavicantaveitaniri anta Mesopotamiaqui intacantaqueeniri Avaramani, inijaapaacari Tasorentsi, yora cameetsatatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ari icantapaaqueri: “Pojocanajero piipatsiteca, pijate anta pashiniqui quipatsi ora nonijayempiri”. ");
INSERT INTO cniNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Irosati yojocantanajaro iipatsite careasati, yovaanaja anta Jaraqui. Aitaque icamapaaqueri iriri, irosati yovaacaantajariri Tasorentsi aca aipatsitequica. ");
INSERT INTO cniNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Iro cantaincha, te imperiji iipatsite, te impimateriji capichaji irisavicanteari. Aisati tequerani intimeni itomi. Iro cantaincha icantitacari: “Intime pitomi, aisati nompempi piipatsite avirori. Aisati nompajeiteri maaroni impoijeitempineri intimaje”. ");
INSERT INTO cniNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Aisati icantaqueri Tasorentsi: “Coajica intimaje poyeetajempineri iipatsitequi pashinisati atiri. Peerani catsini iromperanatasanoteari, oncarate osarintsi 400 iroashinoncaasanoteri. ");
INSERT INTO cniNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Impoijiniquea noasanquetaqueri yora peranavetearineri. Irintiquea pishanincani, noimpiajeitajeri aca quipatsiquica, impoiji inquemisantaquena aca. ");
INSERT INTO cniNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nocoaque meeca pintoyeantea iriotanteari atiri piquemisantaquena aisati pinquenqueshiretantearori nocantaquempiri”. Ari impoiji itimanaque itomi, yora Isaca. Ocarataque quitaiteri 8, irosati itoyeantantacari. Itimaque itomi iriori Isaca, ipajitaqueri Jacovo. Itomipee iriori Jacovo icarajeitaque 12. Tempa iriojeitaque intacantajeitaqueeri. ");
INSERT INTO cniNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ari yovaajiniri Ishiteva, icantiri: —Ari yantearijeitanaque, iquisajeitaqueri irirenti, pajitachari Jose. Ipimantajeitaqueri, impoiji yayeetanaqueri Ejipitoqui. ");
INSERT INTO cniNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ari yoashinoncaajeivetacari savicajeitatsiri, iro cantaincha yoavisacotiri Tasorentsi. Itasoncacoventiri, irootaque ineacameetsatantariri ivincatsarite ejipitosati, pajitachari Jarao. Ineaqueri otimimotiri iotantari, irootaque ipeantajariri iriori ivincatsaririnte. Ipincatsariventajeitiri maaroni ejipitosati, aisati ishaninca Jarao. ");
INSERT INTO cniNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Impoiji otashentsiiteanaque maaroni Ejipitoqui, aisati Cananaqui. Oshequi yashinoncaajeitaca, tecatsi iraanajero intacantaqueeri iroajeitajeari. ");
INSERT INTO cniNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Iriori Jacovo iquemacotaquero ari otimaqueri tirico anta Ejipitoqui. Ijivataqueri itiancaqueri itomipee: “Pijajeite Ejipitoqui pamanantaitero ayeari”. Ari yamanantaiti, aisati ipianaja. ");
INSERT INTO cniNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Impoiji otsoncaja, itiancajiri aisati: “Pijajeite pamanantajante aisati”. Ari ijajeitanaji aisati, jeri ineajeitapaajiri pincatsari. Icantavaqueri: “Narotaque Jose pipimantaqueri peerani”. Aisati icantiri Jarao: “Jeri yoca iyentisanoripee narori”. ");
INSERT INTO cniNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Impoiji icantiri aisati: “Pincantaiteri apa impoque aca, aisati maaroni ishaninca”. ");
INSERT INTO cniNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Irosati ijatantanacari Jacovo anta Ejipitoqui, yaajeitanaqueri ishaninca, icarajeiti 75. Ari icamapaaqueri. Aisati iquempejeitacari maaroni itomipee, icamajeitaque iriori. ");
INSERT INTO cniNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Impoiji yaatonquijeitanajiro itonquini Jacovoni, itijapaajiro anta Shiquemiqui, ari opajitari quipatsi yamanantiniri Avarama. Irio pimantirori quipatsi itomipee Emori. Ipinataqueri quirequi. ");
INSERT INTO cniNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Irosati yovaajiniriri Ishiteva, icantiri: —Irotanaintsi omoncarataquea icantitacaniri Tasorentsi. Icarati oshequi ashaninca arori, yoshequianaque anta Ejipitoqui. ");
INSERT INTO cniNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Impoiji ipincatsariventanti pashini, caari iotacotiri Jose. ");
INSERT INTO cniNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yamatavijeitiri ashanincani. Ishintsitsanajeitiri, yaajeitaqueri itomipee, yoitajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Irosati itimantanaca Moishishi. Aitaque icanta Tasorentsi, ineacameetsatiri. Icarati mava cashiri iqueveanaque anta ivancoqui iriri, imanapitsataqueri ejipitosati. ");
INSERT INTO cniNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Te irimateroji irimaneri aisati ivancoqui, irootaque yovetsicantacanariri pitotsijaniqui, imanavetacari otsapijaqui eni. Iro cantaincha oneaqueri irishinto Jarao, aaqueri. Oyeveajiri onampiqui, oquempetacantajiri otomisanori. ");
INSERT INTO cniNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yoametasanotiri ejipitosati maaroni ocarayeti ioyetiri iriori. Cameetsa ineaveeti. Imatasanoyetiro paitapeerica yantayetiri. Jero aisati icantiriri Ishiteva: ");
INSERT INTO cniNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","—Ari ocarati irosarintsite Moishishi 40, irosati ijatantanacari irineeri ishaninca: yora ijorioririnte. ");
INSERT INTO cniNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ineapaaqueri aparo, yashinoncaaca: ipasanatiri ejipitosati. Ari iquisacoventapaacari Moishishi ashaninca, irosati yoantapaacariri ejipitosati. ");
INSERT INTO cniNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ijivetaca iriori Moishishi ari impincatsajeitavaquerime ishanincapee, aisati ijivetaca ari iriojeitavaqueri iriotaque cavintsaajeitajerine. Ijivetaca irioteme itiancaqueri Tasorentsi, iro cantaincha te impincatsajeitavaqueriji. ");
INSERT INTO cniNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Oquitaitetanaji ineaqueri ishaninca apite, iquisatsatavacaanaca. Icoaveta iroimajerenterime. Icantiri: “Tempa pishanincatavacaaca. ¿Paita piquisavacantajeitacari?” ");
INSERT INTO cniNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ari itatsincavaqueri yora quisasanotainchari, icantiri: “¿Janicampa peaquempiri meeca novincatsarite? ¿Picoaquempa pimperanajeitena? ");
INSERT INTO cniNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Picoaquempa meeca poyena narori, pinquempetacantena yoranquini ejipitosati poaqueri oshaiteniji?” ");
INSERT INTO cniNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Iquemavaque icantaqueriri, irosati ishiantanaca Moishishi, itsaroanaque. Irosati isavicantapaaca nampitsineentsiqui anta iipatsitequi Matia. Yaapaaque ijina, impoiji itimanaque itomi apite. ");
INSERT INTO cniNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ari yovaajiniri Ishiteva iquenquetsatacaajeitiri: —Ocarataque 40 osarintsi isaviquimotiri Moishishi iriconquiri. Irosati inijaantacari inampire Tasorentsi, anta amorequimotaqueri totseequishi. Ocaaraitetinta anta, oquempejitaro toncaari pajitachari Shinai. ");
INSERT INTO cniNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Yamenanaquero, irosati yoantanacaro cavaco: “Otaavetaca totseequishi, iro cantaincha te ontsonqueaji. ¿Paitaquea?” Ari ijatashitaquero, icoaveta iramenasanoterome. Irosati iquemantacari Avincatsarite, ");
INSERT INTO cniNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","icantiri: “Narotaque Tasorentsi, icantani ipincatsajeitaquena pishanincani: yora Avarama, Isaca, jeri yora Jacovo, maaroni”. Jaa iriori Moishishi itsaroasanotanaque, te iramenanajeroji. ");
INSERT INTO cniNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Icantiri aisati Tasorentsi: “Pipincatsatanarica, pisapatoreempa, picatiantacaro meeca quipatsi noameetsantiri, oca nopashinitiri. ");
INSERT INTO cniNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Noneaqueri anta Ejipitoqui pishaninca nocoyeaqueri, oshequi yashinoncaajeitaca. Noquemaqueri icavintsaajeitaca, meeca nocavintsaajeitiri. Irootaque nopocashitantariri noimpacacoventajeri. Meeca, nontianquempi Ejipitoqui”. ");
INSERT INTO cniNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tempa peerani itseenqueevetacari yora Moishishi, icantirini: “¿Janicampa peaquempiri novincatsarite?” Iriotaque yoca itiancaqueri Tasorentsi. Ipeajiri pincatsaritatsiri, aisati oavisacojeitiriri ashanincani. Irio tiancaqueriri inampire Tasorentsi, yora ineaqueri peerani anta totseequishiqui. ");
INSERT INTO cniNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yaajantiri ishaninca, imayetaquero caari ineapinijeiti, aisati itasoncacoventanti. Imayetaquero anta Ejipitoqui, incajarequi Quitioncajaroni, jero aisati anta caaraiteriqui. Ocarati 40 osarintsi imatapiniyetaquero. Aisati icanti Ishiteva: ");
INSERT INTO cniNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","—Iriotaque yoca Moishishi cantiriri ajorioririnteni: “Oquempetaca narori itimacaaquena Tasorentsi, aisati inquempeteri pashini ashaninca intimacayeri: camantantapaatsineri iriori”. ");
INSERT INTO cniNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Peerani iquenaquenajeitantaniri ashanincani anta caaraiteriqui, ijivajeitaqueri yora Moishishini. Anta toncaariqui pajitachari Shinai iquenquetsatacairi inampire Tasorentsi. Iquemavaquero Moishishi irineane Tasorentsi, irosati yovaajeitantacanariri intacantaqueeri, iotantacariri Tasorentsi. Irosati yovaajeitantaqueero meeca arori. ");
INSERT INTO cniNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Iro cantaincha te incoyeji intacantaqueeri inquemisanteri Moishishi, irointiquea itseencaqueri. Icoajeiveta impianajeme Ejipitoqui. ");
INSERT INTO cniNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Icantajeitiri Aaro: “Yora Moishishi iriovetaca aajeitajanteeri anta Ejipitoqui, yamajeivetaquee aca. Iro cantaincha ijataque chapinqui Shinaiqui. Meeca te ayotacoteriji paitanirica oaqueriri caari ipocantaja. Povetsicajeitajena pashini atasorentsite, ampincatsajeitajero iroori”. ");
INSERT INTO cniNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ari yovetsicajeitiro, ishiacantiri vacajaniqui. Icoi impeajerome itasorentsite. Yoaquenero ovisha, yamashiyetacanaro, ipashiyetacaro. Iquimoshireventashivetacaro yovetsicane. ");
INSERT INTO cniNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ishemanaca Tasorentsi, yojocanaqueri: ishinejeitiri ijitasorentsitashiyetari catsirincaiteri, cashiri, impoquiropee, paitapeerica. Tempa irootaque isanquenatacotiniri peerani yora Amoshini. Jero oca isanquenatiniri: “Noshaninca, jero oca icantimpiri Tasorentsi: ‘Ishanincani Ishiraeri, anta ocaaraiteapaaquenta pisavicaveitani 40 osarintsi. Iro cantaincha te poapinitenariji poshiniri, te pintaapinitenariji: te pimpincatsatimajeitenaji catsini. ");
INSERT INTO cniNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Irointi pipincatsatashitacaro ipajiyeetiri Maroco. Aisati pipincatsatashitacari impoquiro pajitachari Ireja. Aisati pipincatsatashitacaro povetsicajeitiri. Irootaque nontiancanteariri vavironiasati iraajeitanaquempi inampiqui, imperanajeitempi’ ”. Irootaque isanquenatiniri peerani Amoshini. ");
INSERT INTO cniNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Irosati yovaaqueneri aisati Ishiteva: —Peerani anta caaraiteriqui otimimoveitarini ashanincani cajo, onantari isanquenare Moishishi. Irio vetsicacantirori Tasorentsi. Imoncarataqueneri Moishishi icantaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Impoiji yaajeitanaquero ashanincani jaocarica ijayetiri. Ijivajeitaqueri Josoe iipatsitequi pashinipee atiri. Itiancajeitiri Tasorentsi atiripee, otimantari isavicantari ashanincani. Quiso yoajeitiro cajo, irosati itimantacari Iravirini iriori. ");
INSERT INTO cniNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Yora Tasorentsi ineacameetsatiri Iravirini. Icantavetarini iriori: “Apa, tempa aviro Tasorentsi, ipincatsatimpini Jacovoni. Nocoaque pishinetena meeca novetsiquempiro pinampitanteari”. ");
INSERT INTO cniNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Iro cantaincha irinti Saromoni vetsicasanotirori pancotsi. ");
INSERT INTO cniNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Te irisavicantearoji Tasorentsi oca pancotsi yovetsicayetiri atiri. Tempa irio savicasanotatsiri inquitequinta jenoqui. Tempa aitaque icantita camantantatsiniri: ");
INSERT INTO cniNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Icanti Avincatsarite: ‘Irootaque inquite nosavicasanotantari. Ora quipatsi, te iro nonampi. ¿Jaoca pincanteari povetsicantenari pancotsi nosavicanteari? ¿Arimpa nonaquearo pancotsi? ");
INSERT INTO cniNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tempa narotaque vetsicajeitaquerori maaroni timayetatsiri’ ”. ");
INSERT INTO cniNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Noshaninca, te pincoyeji piote. Pishiajeitaqueri pashinisati atiri: te pinquenqueshireempa. Te pinquemisantajeiteji. Aitaque picantaitatiani pipiatsatacaro Ishire Tasorentsi. Pishiaqueri intacantimpiniri. ");
INSERT INTO cniNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Timatsimpa camantantatsiniri caari iquishini pishanincani? Teve aneeriji, tempa iotaca iquisajeitaquerini. Yoajeitaquerini maaroni camantantajeivetachaniri; icantini: “Coajica impoque cameetsatasanotatsineri”. Ipocavetaca, iro cantaincha te pimpincatsajeitavaqueriji avinti, irointi paacantaqueri, poacantaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Piojeivetaro irineane Tasorentsi yoamevetimpiri inampire, iro cantaincha te pinquemisanteroji. Irootaque icantiriri Ishiteva ishaninca. ");
INSERT INTO cniNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ari iquemajeitavaquero oca icantaqueriri, irosati iquisajeitantanaca. Oshequi iquisajeitanaqueri, yatsicanajitimentajeitanacari irajiqui, taquiririri. ");
INSERT INTO cniNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Irompa irinti Ishiteva, iveshireimentashiretasanotacaro Ishire Tasorentsi. Yamenasanotanaque inquitequi, ineaquero ishipaquireane Tasorentsi. Jeri ineaqueri Jesoshi aisati, icatiaca iracosanoriqui Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Icantanaque: —Jaa, yonta noneasanotaqueri inquitequi, icatiaca Atirivetapaintachaniri anta iracosanoriqui Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Shintsi icajemajeitanaque, yovijeitanaquero iyempita, ishiashijeitapaacari. Yaajeitaqueri, shepi; ");
INSERT INTO cniNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","yaajeitanaqueri anta ovecaratapaacanta nampitsi. Irosati ipichaanajeitantacariri. Yora pichaaqueriri, isapocaquero yoicoro, yoaquero iitiqui Saoro, icantiri: —Pamenenaro noicoro, nompichaavaquerita. Icantiri: —Ari. Evancari ini Saoro iriori. ");
INSERT INTO cniNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ari ipichaanataqueri Ishiteva, irosati iquenquetsatacantanacari Tasorentsi, icantanaque: —Novincatsarite Jesoshi, paavajero noshire. ");
INSERT INTO cniNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Itiyeroanaca, antearojenca ineanatanaque, icanti: —Novincatsarite, te oncameetsate oca yantajeitaqueri, iro cantaincha eiro piquishimentiritsi. Irootaque icantaqueriri, irosati icamantanaca, torein. Icantanaque Saoro iriori: —Ariove, camanirotaque ini; ineacarove. ");
INSERT INTO cniNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Irosatiquea intantanacari iquisajeitiri quemisantatsiri anta Jerosarequi. Itsoncajeitanaca maaroni, ishiajeitanaca Joreaqui, aisati Samariaqui. Irinti timajeitanaintsi yora iroamerepeeni Jesoshini. ");
INSERT INTO cniNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ari itijaqueri Ishitevani. Irio tijaqueriri quemisantasanotatsiri. Oshequi iraacojeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Irinti Saoro, icoaveta intsoncajeiterime yora quemisantatsiri. Ijatashijeitiri ivancopeequi, inoshicajeitiri shirampari, tsinane, maaroni. Yoiminqueajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yora shiajeitanainchari, iquenaquenayetanaque otsipapeequi nampitsi. Iquenquetsajeitaquero irineane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Yora Jeripi yareetapaaca nampitsiqui, onta Samariaquiniri. Icamantacotapaaqueri Quirishito. ");
INSERT INTO cniNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Iquemajeitantacariri, aisati ineajeitantacariri itasoncantayeti, iquemisantasanojeitavaqueri atiripee. ");
INSERT INTO cniNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yoavisacojeitiri oshequi neiriri camaari, antearojenca icajemajeitanaque camaaripee, irosati ijatantanaja. Yoavisacojeitiri oshequi choriveetatsiri, aisati amashitachari iitiqui. ");
INSERT INTO cniNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Irosati iquimoshirejeitantanaca yora savicajeitatsiri nampitsiquinta. ");
INSERT INTO cniNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Itimi aisati anta shirampari pajitachari Shimo. Peerani oshequi osarintsi isheripiariveitani. Yoajeivetarini cavaco maaroni samariasati, irootaque ishemetantacari oshequi. Ipincatsajeivetacari atiripee: pincatsaripee, iratiritepee, maaroni. Icantajeiti: —Tempa iriotaque Shimo yoca matirori itasorenca Tasorentsi. Tempa irio pincatsaritatsiri. Tsame ampincatsajeiteri. ");
INSERT INTO cniNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Iro cantaincha impoiji yareetapaaca Jeripi, icamantacotaqueri Tasorentsi, jaoca icanta ipincatsariventanti. Aisati icamantacotaqueri Jesoquirishito. Ari ivaotisajeitaqueri quemisantajeitaintsiri: shirampari, tsinane, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Aisati iquempetaja Shimo iriori, iquemisantaji, ivaotisataja. Impoiji quiso yoanaqueri Jeripi. Ineacoyetaqueri paitarica yantayetaqueri, aisati itasoncantasanoyeti. Irosati yoantanacari cavaco. ");
INSERT INTO cniNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yora iroamereni Jesoshi savicatsiri Jerosarequi iquemacojeitaqueri samariasati, iquemisantajeitaquero iriori irineane Tasorentsi, irosati itiancantacariri Petero, jeri Joa. ");
INSERT INTO cniNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ijajeitanaque anta. Icantiri Tasorentsi: “Pintasoncacoventajeiteri samariasatipee, quiso oajeitanteariri Pishire”. ");
INSERT INTO cniNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Iro cantaincha tequerata quiso oajeiteri, apatiroquera ivaotisatimentajeitacari Avincatsarite Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ari yajiricainatapaaqueri iitopeequi, irosati yaashirejeitantacaro Ishire Tasorentsi, otasoncacaajeitaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ineacotaqueri Shimo. Iotanaque ariorica yajiricainatapaaqueri, yaashirejeitaquero iriori Ishire Tasorentsi, irosati icantantacari: ");
INSERT INTO cniNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","—Jerica quirequi, nocoaque poametena nontasoncante narori, nonquempetempi avirori. Nocoaque ariorica najiricainateri noshaninca, iraashirejeitantearori Ishire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Icantanaqueri Petero: —Pijate Sharincaveniqui, paanajeri aisati piirequite. Pijitashivetaca avirori ari pamanantero itasorenca Tasorentsi: apaniro imatacanti Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tecatsi pincantea pinquempetena: ioti Tasorentsi te pincameetsashireteji. ");
INSERT INTO cniNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Te oncameetsateji oca piquenqueshirevetacari. Pinquenqueshiretanaquea, pojoquero caari cameetsatatsi pantayetiri. Pincanteri Avincatsarite: “Pincavintsayena”. ");
INSERT INTO cniNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Niotaquempi, oshequi pishemeti, aisati pashi poiro te pincameetsateji. ");
INSERT INTO cniNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Yacanaqueri Shimo, icanti: —Pincanterite Tasorentsi incavintsayena oncanteataquea eiro nojatantatsi Sharincaveniqui. ");
INSERT INTO cniNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yora Petero aisati Joa, icamantacotiro irineane Avincatsarite, iquenquetsatacotiro. Iquenayetanaque oshequi nampitsipeequi Samariaqui, icantajeitiri savicajeitatsiri: —Ariorica pinquemisanteri Jesoshi, iroavisacotempi Tasorentsi, iraajeitanaquempi inquitequi. Irosati ipiajeitantanaja Jerosarequi. ");
INSERT INTO cniNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ari ineanatiri inampire Avincatsarite, icantiri Jeripi: —Meeca pijatanaque, pinquenanaque anta avotsiqui quenantachari caaraiteriqui: ora poneachari Jerosarequi, jatatsiri irosati Casaqui. ");
INSERT INTO cniNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ari ijatanaque, iquenanaque avotsiqui. Itonquiotavacari shirampari poneachari Etiopiaqui. Aitsoquireari ini. Irisati ovincatsaririnte Cantasheshi, yora quempoyeinirori maaroni oirequite. Irootaque iroori ivincatsarote etiopiasati. Ari ijaiti anta Jerosarequi, iquemisantaitiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Meeca ipiaja, isavicaque ishiacomentoqui, ineanatiro isanquenareni Isayashini, camantantaveitachaniri. ");
INSERT INTO cniNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Iro Ishire Tasorentsi cantaqueriri Jeripi: —Pijate anta, pintonquiotavaquearo shiacomentotsinta. ");
INSERT INTO cniNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ishiashitanacari, iquemapaaqueri ineanatiro. Icantapaaqueri: —¿Piotaquerompa oca pineanatiri? ");
INSERT INTO cniNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yacanaqueri: —Teve nioteroji. ¿Jaoca noncanteari niotantearori? Tecatsi oametenarone. Pintetapeempa, pisaviquimotapeena aca. ");
INSERT INTO cniNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jero oca ocantiri sanquenarentsi ineanatapairi: “Ariorica yoyeetiri ovisha, imajeretashitanaca. Ariorica yameeyeetiri ovishajaniqui, imajeretashita. Aisati inquempeteari Quirishito iriori, irimajerete. ");
INSERT INTO cniNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Iroashiventeeteri, eiro otampaticatitsi incantacoyeeteriri. Impoiji iroyeeteri. Eiro itimitsi irinti itomipee”. ");
INSERT INTO cniNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Isampitiri: —Pincamantenate. ¿Janicampa iquenquetsatacotiri yora camantantatsiniri? ¿Irisatimpa quenquetsatacotashitacha? ¿Pashinimpa iquenquetsatacotiri? ");
INSERT INTO cniNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Irosati icamantantanacari Jeripi, icamantacotiri Jesoshi. Ijivataqueneri ocantiri ora Sanquenarentsi, yoametasanotaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Aiquero ijatacairiri avotsiqui, irosati ineantapaacaro nija. Icantaqueri: —Jero oca nija. ¿Cameetsanimpa novaotisatea? ");
INSERT INTO cniNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Yacanaqueri: —Piquemisantasanotiririca Quirishito, cameetsa pivaotisataquea. Icantiri: —Noquemisanti. Iriotaque Jesoquirishito Itomi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yoatiaquero shiacomentotsi. Ari yaniireajeitanaque, itsipatavacaanaca apite, yaniijatanaquero nija, ivaotisataqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ari yaatanaji, irosati quiso oantanacari Jeripi Ishire Avincatsarite. Te irineavajeriji aisati yora itsipavetacari. Apaniro yovaanaja iriori, iquimoshiretanaque. ");
INSERT INTO cniNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Irintiquea Jeripi ineacotashitapaaca nampitsiqui anta opajitanta Asoto. Ari yovaanaca, iquenquetsayetanaque nampitsipeequi: —Pinquemisantajeiteri Quirishito pavisacojeitantajeari. Irosati yareetantanaja anta Sesareaqui. ");
INSERT INTO cniNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ari yashi yoiro iquisa Saoro. Isareavetacari iroajeiterime maaroni quemisantajeitiriri Avincatsarite. Irosati ijatashitantacari ivincatsarite saserote, icantiri: ");
INSERT INTO cniNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","—Nocoaque pisanquenateneri yora quemisantacaajeitiriri ajorioririnte anta Tamashicoqui, pincanteri: “Pamitacojeiteri Saoro iraajeiteri maaroni quemisantajeitiriri Jesoshi. Nocoaque iraajeiteri: shirampari, tsinane, maaroni. Impoiji iroisojeiteri, iramajeiteri aca Jerosarequi”. Ari isanquenatiniri, ipavaqueri. ");
INSERT INTO cniNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Impoiji ijatanaque, icantanaca, icantanaca: irotapaintsi Tamashico. Omapocapaaqueri amorecatsiri, amorecacotapaaqueri, morec: oponeaca inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Iparianaque quipatsiqui, tiricn, iquematiiro irineane Jesoshi: —Saoro, Saoro: ¿paita piquisantanari? ");
INSERT INTO cniNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—¿Janicampi, Novincatsarite? ");
INSERT INTO cniNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","—Narotaque Jesoshi, piisane. Pijate, povaanaquea nampitsiqui. Coajica incamanteetempi paitarica panteri. ");
INSERT INTO cniNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ari icatiajeitaca yora shirampari itsipajeivetacari, yoajeitaque cavaco. Iquemashitacaro irineane, iro cantaincha tecatsi irinee. ");
INSERT INTO cniNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Iriori Saoro, icatianaja. Yoquireavetanaja, te irimatajeaji iramenaje, irootaque yacatsatantanajariri, yareetacaacari Tamashicoqui. ");
INSERT INTO cniNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ocarati isavicashitaca mava quitaiteri. Te irineajeji, te iroajeaji, te irirajeji. ");
INSERT INTO cniNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ari itimiri anta Tamashicoqui quemisantatsiri, pajitachari Ananiashi. Ineashitavacari Avincatsarite, icantapaaqueri: —Ananiashi. Yacanaqueri: —¿Paita, Novincatsarite? Ainirona aca. Icantiri: ");
INSERT INTO cniNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","—Meeca pijate anta avotsiqui ipajiyeetirinta: “Tampaticari”. Pincoapaaqueri shirampari pajitachari Saoro, yora tarisosati. Pincoapaaqueri anta ivancoqui Jorashi. Ainiro iriori, iquenquetsatacaana. ");
INSERT INTO cniNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nomishitacaacari, ineaquempi piqueashitapaaqueri, pajiricainatapaaqueri; ineaca yamenanaji. ");
INSERT INTO cniNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yacanaqueri: —Oshequi noquemacotiri, iquenquetsatacoyeetiri yora picantaquenari. Oshequi yoashinoncaajeitiri quemisantajeitimpiri anta Jerosarequi, icantirive. ");
INSERT INTO cniNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tempa itianquiri aca yora jivatacaajeitiriri saserote iraajeitantanaquenari, maaroni aventajeitimpiri. Oshequi notsaroacaacari. ");
INSERT INTO cniNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Iro cantaincha icantiri: —Pijate. Tempa iriotaque nocoyeaqueri. Iriotaque quenquetsatacotajenaneri. Inquenquetsatacaajeiteri joriopee, pashinisatipee atiri, pincatsaripee, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aisati nonijayeri jaoca oncarate irineacatsitimentena. ");
INSERT INTO cniNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ari ijatanaque Ananiashi, iqueapaaque pancotsiqui. Yajiricapaaqueri, icantiri: —Saoro, avirotaque noyemisantaririnte. Itiancaquena Avincatsarite Jesoshi, yora onijaaquempiri anta avotsiqui piquenapaaquenta. Itiancana pamenantajeari, quiso oasanotantempiri Ishire iriori. ");
INSERT INTO cniNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Irosati opariantanaja iroquiquiniri shiavetarori iventaqui shima, yamenasanotanaji. Ari ijatanaque, ivaotisataca. ");
INSERT INTO cniNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Aisati yoaja, ishintsitanaji. Aparopee quitaiteri itimimovetanacari quemisantatsiri anta Tamashicoqui. ");
INSERT INTO cniNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Impoiji icamantantayeti anta pancotsiqui yapatojeitanta joriopee. Icantapinijeitiri: —Iriotasanotaqueyeata Jesoshi Itomi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yoajeitanaqueri cavaco yora quemajeitavaqueriri. Icantajeiti: —Tempa iriotaque yora tsoncajeiterinemeri quemisantatsiri anta Jerosarequi. Tempa irootaque ipocashitantavetacariri aca iroisojeiterime quemisantiriri Jesoshi, iraajeitanaquerime anta saserotepeequinta. ");
INSERT INTO cniNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Aiquero ijatatiini Saoro iquenquetsati, tecatsi intsaroacaimateari. Yoajeitavaqueri cavaco yora joriotatsiri. Iotacaasanotaqueri, icanti: —Yora Jesoshi, iriotaque Quirishitotatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ari avisanaque oshequi quitaiteri, irosati isareantajeivetacari iroyerime. ");
INSERT INTO cniNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Iro cantaincha iotacotaqueri Saoro isareacari. Maaroni quitaiteriqui, tsiteniriqui, yamenajeivetacaro joriopee iqueantapinitari nampitsi, icoajeivetaca iraavaquerime Saoro, iroyerime. ");
INSERT INTO cniNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Iro cantaincha, osaite yaanaqueri iroamerepee tantotsiqui, ora shoncarori nampitsi; yataitacaanaqueri, impoiji yoaniireacojeitajiri cantiriqui araquerora. Irosati ishiantanaja, te irineajeitavajeriji oyerinemeri. ");
INSERT INTO cniNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ari yareetapaaca Jerosarequi. Icoaveta intsipajeitapeemparime quemisantajeitatsiri, iro cantaincha itsaroacaajeitavacari. Ijitashivetacari te inquemisanteji. ");
INSERT INTO cniNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Impoiji yaanaqueri Verenave, ijivatanaqueri anta itiminta iroamereni Jesoshi. Icamantapaaqueri: —Queario, iraajeiterime Saoroca ayemisantaririnte anta Tamashicoqui, iro cantaincha anta avotsiqui ineaqueri Avincatsarite, iquenquetsatacaaqueri. Iquemisantaque, impoiji anta Tamashicoqui iquenquetsatacotapinitiri Jesoshi, te intsaroacayeariji tseencantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ari yaacameetsajeitaqueri quemisantatsiri, cameetsa itimimotaqueri iriori anta Jerosarequi. Icantani Saoro, quiso yoajeitaqueri ayemisantaririnte. Cameetsa iquenquetsatacotasanotiri Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Iquenquetsatacaajeivetacari joriopee iotirori quirieco, iro cantaincha ipiatsajeitavacari; icoajeivetanaca iroyerime, ");
INSERT INTO cniNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","iro cantaincha iotacotaqueri iyemisantaririnte, irosati yaantanajari Saoro anta Sesareaqui. Impoiji itiancajeitaqueri Tarisoqui. ");
INSERT INTO cniNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Cameetsa itimajeiti quemisantajeitatsiri anta Joreaqui, Carireaqui, Samariaqui. Aiquero ijatatii iquemisantajeitanaque. Yamejeitaca ipincatsajeitiri Avincatsarite. Aisati oshequi oveshireacaasanojeitacari Ishire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ari iquenaquenayetanaque Petero iquivantayetiri quemisantayetatsiri, irosati yareetantacari Iriraqui. Anta isaviqui oshequi quemisantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ineapaaqueri shirampari pajitachari Eneashi. Ocarati osarintsi 8, inareaca imaamentoqui, ichoritaque. ");
INSERT INTO cniNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Icantapaaqueri: —Eneashi, iriotaque Jesoquirishito oavisacotajempine. Pincatianaje, povetsicajero pimaamento. Jentsipaite itinaanaja. ");
INSERT INTO cniNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ineajeitaqueri irirasati, jeri saronasati; irosati iquemisantajeitantanajari Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Otimaveta Jopequi quemisantatsiri pajitachari Tavita. Acanti aneanequi arori: Maniro. Cameetsa oca antayetiri: ashi oiro intacotantayeta. ");
INSERT INTO cniNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Omantsiatanaque, impoiji ocamaque, torein. Ari iquivatsempequiyeetaquero ovatsani, impoiji yoaquero anta shitamencotsiqui, onta jenioquijiniri. ");
INSERT INTO cniNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jero Irira oquempejitaro Jope. Yora quemisantajeitatsiri, iquemacotaqueri Petero, inapaaque anta. Itiancaqueri apite shirampari: —Pishintsite, pincantaiteri Petero impoque. Ari ijataque, icantasanotapaaqueri: —Pishintsite poijatanaquena pamenapeero tsinane, camaque oni. ");
INSERT INTO cniNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ari ijatanaque Petero, yoijatanaqueri. Yareetacaacari, yaanaqueri anta pancotsiqui jenioquiji. Oshonquimentajeitacaro maaroni camajimentaaro, iraajeitaca. Onijaayetiri oicoropee, aisati oitsaaresanoripee. Ocantajeitaque: —Tequerani oncameni Tavita, otijayetanaroni maaroni ocapee. ");
INSERT INTO cniNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ari yoimisoquijapaaqueri maaroni atiri. Itiyeroanaca, iquenquetsatacairi Tasorentsi. Ipitsocashitanacaro camaintsiri, icantiro: —Tavita, pintinaanaje. Oquireanaji, oneaqueri Petero, irosati osavicantaja. ");
INSERT INTO cniNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Yaavacotiro, yoatiajiro. Icajemajeitiri aisati quemisantajeitatsiri, aisati iroori icajemajeitiro camajimentaaro, maaroni. Icantajeitavaqueri: —Jero, aneanaji. ");
INSERT INTO cniNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ari iquemacojeitaquero maaroni jopesati. Icarati oshequi quemisantayetanajiriri Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Oshequi quitaiteri isaviqui Petero Jopequi. Isaviqui ivancoqui Shimo, yora vetsicapinitiriri meshinantsi. ");
INSERT INTO cniNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ari itimaiti anta Sesareaqui shirampari pajitachari Coronerio. Iriotaque iyapitanote oshequi soraro, poneayetachari Itariaqui. ");
INSERT INTO cniNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Quemisantasanotatsiri ini, ipincatsatiri Tasorentsi. Aisati iquempejeitari maaroni ishanincapee iriori, saviquimojeitiriri. Oshequi icavintsaajeitiri atiripee. Icantani iquenquetsatacairi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ishaavijitanaque catsirincaiteri ineashitavacari inampire Tasorentsi, iconijatasanotapaaque. Iquempejitapaacari, icantapaaqueri: —Coronerio. ");
INSERT INTO cniNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Yamenasanotavaqueri, sorerere. Itsaroasanotanaque catsini. Icantavaqueri: —¿Paita, Novincatsarite? Icantiri: —Iquemaquempi Tasorentsi piquenquetsatacaapinitaqueri, aisati ineaquempi pintacotapinijeitacari atiripee. ");
INSERT INTO cniNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Icoaque meeca pintianque aparopee shirampari anta Jopequi. Pincajemacanteri yora Shimo, ipajiyeetiri aisati Petero. ");
INSERT INTO cniNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Irio isaviquimotiri pajitachari aisati Shimo, yora vetsicapinitiriri meshinantsi. Otimi ivanco otsapijaqui incajare. ");
INSERT INTO cniNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ari ipianaja inampire Tasorentsi, yora neanaitiriri. Icajemaqueri Coronerio inampire apite, aisati soraro aparo. Quemisantasanotatsiri ini soraro. Icarajeitiri amitacojeitiriri Coronerio. ");
INSERT INTO cniNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Icamantajeitaqueri maaroni oca icantaqueriri inampire Tasorentsi, impoiji icantiri: —Nocoaque pijajeite Jopequi, pamenaiteri yora Petero. Ari ijajeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Oquitaitetamanaji, itampaticatapaaque catsirincaiteri. Iquenapaaque, irosati iquempejitantapaacaro nampitsi. Iriori Petero, yataitanaque jenoqui, iquenquetsatacairi Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Itasheavetaca, icoaveta iroyeame. Ainiroquera ovetsiquiniri iroyeari, omapocapaaqueri ineashitacaro. ");
INSERT INTO cniNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ineaquero inquite tsompoina. Oaniimaotapaaca quipatsiqui shiavetarori tocoya antearo. Yajiriqueetaquero anta ocaramaotapaaque. ");
INSERT INTO cniNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Iteyetaca yora caari yoyeeta; jeri iteyetaca maranquepee, vanquiyetachari, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Iquemavaqueri Tasorentsi, icantiri: —Petero. Jeri yoca, poyeri, impoiji poyeari. ");
INSERT INTO cniNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Icantanaqueri: —Novincatsarite, eiro noaritsi. Te nameteariji caari yoyeeta, caari icoacayeetana noyeari. ");
INSERT INTO cniNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yapiitajiri: —Tempa narotaque Tasorentsi, nocamantimpi nainti: “Cameetsari ini, poyeari”. Eiro picantashitaritsi avirori: “Te incameetsateji”. ");
INSERT INTO cniNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yapiitajiniri aisati: —Poyeri, poyeari. Irosati yoancacotanteetajariri jenoqui. ");
INSERT INTO cniNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Te iriotacoteroji Petero oca ineaqueri. Irosati yareetantapaaca pancotsiqui itiancane Coronerio. Isampitacotapaaqueri: —¿Jaoca ivanco Shimo, yora vetsicapinitiriri meshinantsi? Icamanteetiri: —Irootaque oca ivanco. ");
INSERT INTO cniNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ari isampitajiri: —¿Ariompa isaviquimotimpiri yora Shimo Petero? Icanteetiri: —Je, aitaque isaviquiri. ");
INSERT INTO cniNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Irosatiquera iquenqueshiretiro Petero ineaqueri. Ari ocantaqueri Ishire Tasorentsi: ");
INSERT INTO cniNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","—Jerijeitapaaque shirampari, coimpiri. Pijate, paniireashitanaqueri. Eiro picantashiretitsi, poijajeitanaqueri. Tempa narotaque amajeitaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ari yaniireashitapaaqueri, icantapaaqueri: —Narotaque picoiri. ¿Paita pipocashitantanari? ");
INSERT INTO cniNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ari yacanaqueri iriori: —Itiancaquena Coronerio, yora capitanotatsiri. Icameetsashiretasanoti, aisati ipincatsatiri Tasorentsi. Maaroni joriotatsiri ineacameetsajeitiri. Icantiri inampire Tasorentsi: “Pincajemacanteri Petero pivancoqui. Pinquemisantavaquero irineane”. Irootaque itiancantanari aca. Ari icantavaqueri: ");
INSERT INTO cniNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","—Pinqueapee. Ari ineshinoncatavaqueri. Ari oquitaitamanaji yoijatanaqueri, itsipajeitanacari iyemisantaririnte aparopee, yora jopesati. ");
INSERT INTO cniNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aparo imaajeitanaque nianqui, irosati yareetantamanaca anta Sesareaqui. Yoyeaqueri Coronerio anta, yapatojeitaqueri maaroni ishaninca aisati itsipatapinijeitari. ");
INSERT INTO cniNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Iqueapaaque Petero. Yovetsatavacari Coronerio, impoiji itiyeroashitavacari iitiqui. ");
INSERT INTO cniNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ari yoatiajiri Petero, icantiri: —Pincatianaje. Te naro Tasorentsi, tempa narosati narori atiri, aquempetavacaaca. ");
INSERT INTO cniNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ari iquenquetsatavacaaca, iqueapaaquero pancotsi. Ineapaatiiri oshequi apatojeitainchari, ");
INSERT INTO cniNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","icantapaaqueri: —Naro jorio. Piojeiti avirori te irishinetenaji noshaninca nontsipajeiteari pashinisatipee atiri. Aisati te irishinetenaji nonquivanteri. Iro cantaincha yoametaquena Tasorentsi te oncameetsateji nompinqueri pashini atiri, te oncameetsateji noncante: “Te incameetsateji”. ");
INSERT INTO cniNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ari picajemacantaquena, irosati nopocantanaca, te nonquisotanaque. Meeca nosampitempi, ¿paita picajemacantantanari? ");
INSERT INTO cniNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Icantiri Coronerio: —Ocarati meeca 4 quitaiteri, ishaavijitanaque catsirincaiteri, iquempetaca meeca. Noquenquetsatacairi Tasorentsi aca novancoqui. Noneaqueri aparoni shirampari, icatiimotapaaquena. Iquitsaataro shipaquireatsiri iitsaare. ");
INSERT INTO cniNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Icantapaaquena: “Coronerio. Iquemavaquero Tasorentsi piquenquetsatacaaqueriri. Iotaquempi pintacotantayeta. ");
INSERT INTO cniNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pintianque anta Jopequi, pincajemacanteri Shimo, ipajiyeetiri aisati Petero. Isaviquimotiri itsipa Shimo, yora vetsiquiriri meshinantsi. Otimi ivanco otsapijaqui incajare”. ");
INSERT INTO cniNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Intsipaite nocajemacantaquempi, irosati pipocantacari. Meeca nocarajeitaqueri iriori Tasorentsi aca. Nocoajeitaque nonquemajeitero oca inintacaaquempiri Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ari ineaveetanaque Petero iriori, icanti: —Meeca niotasanotaque te irinashitacaajeiteeji Tasorentsi, tempa icanti: “Piquempetavacaajeitaca, eiro pipincavacaajeitatsi”. ");
INSERT INTO cniNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Te inquenqueshiretacoteeroji onashiyetarica aneane aisati ameyetari, irointi ineacameetsajeitaqueri maaroni pincatsajeitiriri, aisati maaroni antapinitirori cameetsayetatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Naro jorio. Piojeitavaquero irineane Tasorentsi ijivajeitaquena, iotacaajeitaquena. Cameetsa oca icamantaquenari: “Ariorica pinquemisantajeiteri Jesoquirishito, cameetsa nosavicacaajeitempi, pinquempetavacantajeiteari”. Tempa iriotaque Jesoshi Avincatsarite maaroni, ");
INSERT INTO cniNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","piojeitaquero. Ijivataque Joani iquenquetsatacotaqueri, icanti: “Cameetsa pivaotisatimentajeiteari Quirishito”. Impoiji iquenquetsatacotaqueri itsipapee, intanacaro anta Carireaqui. Yovaacaanacaro maaroni nampitsipeequi anta Joreaqui. ");
INSERT INTO cniNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Icamantajeitiri atiri jaoca icantaqueriri Tasorentsi Jesoshi, yora nasaretesati, itiancantacariri Ishire, aisati ipantacariri itasorenca; irootaque iquenaquenayetantacari, yantantayetacarori cameetsayetatsiri. Yoavisacojeitiri neajeitiriri camaari. Quiso yoiri Tasorentsi, irootaque imatantacariri. ");
INSERT INTO cniNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Noneajeitaqueri yantayetiri anta inampipeequi noshaninca, aisati anta Jerosarequi. Noneaqueri yoanteetacariri, ipajacotanteetacariri coroshiqui. ");
INSERT INTO cniNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Omavatapaaque quitaiteri itinaajiri Tasorentsi, yonijaajanari. ");
INSERT INTO cniNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Te ironijaajeiteriji maaroni, narojeitaque nainti, yonijaajiri. Icoyeaquena Tasorentsi, irootaque noneantavajariri. Icamasanovetaca, itinaanaja aisati. Impoiji noacaavajari, aisati niracaavajiri. ");
INSERT INTO cniNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Icantaquena: “Pincamantajeiteri atiri: ‘Inintacaaqueri Tasorentsi Jesoshi incantacoventajeiteri maaroni atiri: aneatsiri aisati camaintsiri’ ”. ");
INSERT INTO cniNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tempa peerani iquenquetsatacotirini Quirishito yora camantantatsiniri, icantajeitini: “Ainiro yantajeitaquero maaroni atiri caari cameetsatatsi; iro cantaincha ariorica inquemisanteri Quirishito, incavintsaajeiteri irinti, eiro iquishimentiritsi yantajeitiri, eiro iquenqueshireacotiritsi”. ");
INSERT INTO cniNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ainiroquera iquenquetsati Petero, irosati opocashitantacari Ishire Tasorentsi. Aisati opocashijeitaqueri maaroni quemajeitavaquerori icantaqueriri. ");
INSERT INTO cniNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ari yoajeitanaque cavaco yora jorio, quemisantatsiri: yora tsipatariri Petero. Ari iojeitaque itiancasanotaquero Tasorentsi Ishire, quiso oantacariri pashinisati atiri. Irootaque yoajeitantanacari cavaco. ");
INSERT INTO cniNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Iquemajeitavaqueri ishaninca Coronerio ineanatantashitanacaro pashinipee neantsi, aisati icantajeiti: —Cameetsa ini Tasorentsi. Ari icantanaji Petero: ");
INSERT INTO cniNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Iquempetaquee arori, yaashirejeitaquero Ishire Tasorentsi. Tempa ocameetsati irivaotisajeitea. Icantiri itsipapee jorio: —Je, cameetsataque. ");
INSERT INTO cniNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Irosati icantantariri Petero ishaninca Coronerio: —Pivaotisatimentajeiteari Jesoquirishito, iriojeitantempiri atiri pipincatsajeitaqueri. Icantajeitanaqueri: —Jentsiqueti pivaotisatena. Ari ivaotisajeitaqueri. Impoiji icantajeitavaqueri: —Pisaviquimotanaquenatsita aparopee quitaiteri, poametasanotajena aisati. ");
INSERT INTO cniNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Iquemacojeitaqueri joreasati: jeri yora itiancanepee Jesoshi, jeri maaroni quemisantajeitatsiri. Icamanteetiri: —Iquemisantaqueri Jesoshi pashinisatipee atiri; irio quemisantacaajeitaqueriri Petero. ");
INSERT INTO cniNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Itoncantanajari Petero Jerosarequi, iquishimentajeitavaqueri ijorioririnte: quemisantatsiri inaveta. ");
INSERT INTO cniNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Icantajeitavaqueri: —¿Paita pijatashitantariri pashinisati atiri? ¿Paita poimotantariri iriori? Te oncameetsateji. ");
INSERT INTO cniNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Itsoteasanotaqueneri Petero, icantiri: ");
INSERT INTO cniNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Meeca noncamantempi. Anta notimaitinta Jopequi, noquenquetsatacairi Tasorentsi. Noneashitavacaro, noneaquero shiavetarori tocoya antearomaronca. Yajiriqueetaquero anta ocaramaoyetapaaque, oponeaca inquitequinta, oaniimaotimotapaaquena. ");
INSERT INTO cniNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Namenasanotavaquero sorerere: noneaqueri caari avajeita: chancho, maranque, vanquiyetachari, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Noquemaqueri Tasorentsi, icantaquena: “Meeca poyeri; poyeari”. ");
INSERT INTO cniNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Iro cantaincha nocantavetacari: “Novincatsarite, eiro noaritsi. Te nameteariji caari yoyeeta, caari icoacayeetana noyeari”. ");
INSERT INTO cniNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Apitetaque Yapiitaquena, icantana: “Tempa narotaque Tasorentsi cantimpiri: ‘Cameetsari ini’. Eiro picantashitaritsi avirori: ‘Te incameetsateji’ ”. ");
INSERT INTO cniNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Aitaque apiitaca mava. Irosati ovancantanaja inquitequi. ");
INSERT INTO cniNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Irosati yareetantapaaca mava shirampari anta pancotsiqui notimaitinta. Iponeanaca Sesareaqui, itianqueetaquenari. ");
INSERT INTO cniNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Irosati ocantantaquena Ishire Tasorentsi: “Poijatanaqueri, eiro piquisotanaquetsi”. Ari noijatanaqueri. Aisati yoijatanaquena iriori ayemisantaririnte, icarajeiti 6. Noqueajeitapaaque ivancoqui yora cajemacantaquenari. ");
INSERT INTO cniNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Iquenquetsatacaavaquena, icamantavaquena jaoca icantacari ineantacariri inampire Tasorentsi. Yonijantapaacariri, icantiri: “Pintianque anta Jopequi. Pincajemacanteri Shimo: ipajiyeetiri aisati Petero. ");
INSERT INTO cniNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iriotaque oametapeempirone irineane Tasorentsi, pavisacotantajeari. Aisati inquempejeitajea iriori maaroni pivancoquiniri”. ");
INSERT INTO cniNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nintantacarori noquenquetsatacaaqueri, ari opocashijeitaqueri Ishire Tasorentsi. Oquempetacaajeitaquee intantaqueeri arori. ");
INSERT INTO cniNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Noquenqueshiretanaquero irineane Avincatsarite icantitacari: “Yora Joa ivaotisatantaroni nija, irompa nainti nontianquempiro Ishire Tasorentsi”. ");
INSERT INTO cniNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Peerani aquemisantajeitantariri Avincatsarite Jesoquirishito, itiancaqueero Tasorentsi Ishire. Meeca imoncaratajiniri iriori itsipapee atiri. ¿Arimpa nontsaneaqueari? Tempa irio Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iquemajeitantavacarori oca, tecatsi incantanaqueri impiateari, irointi icantajeiti: —Cameetsa ini Tasorentsi. Tempa icoacairi aisati pashinisatipee atiri iquenqueshirejeitiri, irijajeitantajeari iriori anta jenoqui. ");
INSERT INTO cniNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ari iquisacoyeetanacari Ishitevani. Meeca iquisheetanaqueri maaroni quemisantajeitatsiri, irosati ishiajeitantanaca pashinipeequi quipatsi: Jenishiaqui, Tsipirequi, Antioquiaqui, maaroni. Anta te inquenquetsatacayeriji pashinisati atiri, irinti itsataayetiri ijorioririnte. ");
INSERT INTO cniNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ainiro iconoayetacari itsipapee quemisantatsiri, poneayetanainchari Tsipirequi, jero Shirenequi. Yareetantanacari irinti anta Antioquiaqui, iquenquetsatacaapaaqueri caari jorioyetatsi. Icantajeitiri: —Pinquemisantajeiteri Jesoquirishito pavisacotantajeari. ");
INSERT INTO cniNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Itasoncacoventapinitiri Avincatsarite, itimantacari oshequi catsini quemisantajeitavaqueriri, aventajeitariri. ");
INSERT INTO cniNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ari anta Jerosarequi iquemacojeitaqueri quemisantatsiri. Itiancaqueri Verenave anta Antioquiaqui. ");
INSERT INTO cniNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Yareetapaaca iriori, iotapaaqueri ineshinoncatiri Tasorentsi. Iquimoshiretapaaque, icantajeitiri: —Quearioyea, quiso poajeiteri yora Avincatsarite, pinquearioventeneri maaroni icoacaajeitimpiri. ");
INSERT INTO cniNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Cameetsari ini iriori Verenave. Quiso yoasanotiro Ishire Tasorentsi, yashi yoiro iquemisantasanoti. Aisati aiquero ijatatii yoshequiajeitanaque quemisantajeitiriri Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Impoiji yovaanaca Verenave Tarisoqui, icoapaaqueri Saoro. Ineapaajiri, irosati yoijatantajariri Antioquiaqui. ");
INSERT INTO cniNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Anta yapatotapinitirinta quemisantatsiri. Icantani, ocarati aparoni osarintsi. Yoametapaaqueri oshequi catsini atiri. Aitaque anta intanacaro ipajiyeetiri quemisantatsiri: “Quirishitianotatsiri”. ");
INSERT INTO cniNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Irosati yareejeitantapaaca Antioquiaqui pashini camantantatsiri, iponeanaca iriori Jerosarequi. ");
INSERT INTO cniNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Icarataqueri aparoni, pajitachari Acavo. Icatiapaaca anta yapatojeitanta, oametaqueri Ishire Tasorentsi, icantantari: —Coajica intasheajeitanaque atiripee anta Joreaqui. Ainironi ipincatsariventanti Caraorio, omoncarataja icantitaniri Acavo. ");
INSERT INTO cniNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Icantajeiti quemisantatsiri: —Tsame ancavintsaajeiteri ayemisantaririnte anta Joreaqui, ampacanteri paitarica icoajeitiri. ");
INSERT INTO cniNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jaocarica ocarayetiri timimoyeteeri, aitaque oncarate ampacantayeteriri. Aitaque imataquero icantaqueri. Yapatotaqueri quirequi, ipavaqueri Verenave, jeri Saoro. Icantaqueri: —Jeri yoca quirequi: paajeitanaqueneri quenquetsatacantatsiri anta Jerosarequi, incavintsaajeitanteariri ashinoncaajeitachari. Ari yaanaqueneri jerosaresati, ipapaaqueri quenquetsatacantatsiri. Ari yovaajeitaqueneri iriori ashinoncaajeitachari. ");
INSERT INTO cniNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Impoiji yora pincatsari Eroreshi iquisayetaqueri aparopee quemisantatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yoacantaqueri Santiaco, iro ipesanteetacariri saviri, peti. Irio irirentini Joa. ");
INSERT INTO cniNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ionirotaque Eroreshi onimojeitaqueri joriotatsiri, irootaque yaacantantavetacariri Petero aisati. ");
INSERT INTO cniNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Iro yaacantantacariri quitaiteri yoantapiniyeetarori tanta caari tapiacha. Ijitashivetaca ariorica omoncarataquea quitaiteri Yavisantaniri, iramenacojeiteri joriopee iroyeri. Yaaqueri, impoiji ipaqueri 16 soraro, irishentanteariri. ");
INSERT INTO cniNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ari yominqueaqueri. Yora quemisantatsiri iquenquetsatacaasanojeitiri Tasorentsi, icantiri: “Poavisacotajeri Petero”. ");
INSERT INTO cniNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ari otsitenitanaque, iro osaitequera iroisoquijerime Eroreshi, iroacaantantearirime. Icoaveta iramenajeiterime atiri incamaque. Ainiro inaveta Petero caravosoqui, imaanaque; isatecaqueri apite soraro. Yoisotantacari apite carenatsa. Ishentavetaro ashitacorontsi itsipapee soraro. ");
INSERT INTO cniNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ari imapocapaaqueri anta inampire Avincatsarite. Oconijaiteashitimotanacari. Itincapaaqueri imerequiqui, icaocapaaqueri. Icantaqueri: —Pishintsite pintinaanaje. Irosati oisoreashitantanaja carenatsa iracoquiniri, yoisotantavetacariri. ");
INSERT INTO cniNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Aisati icantiri: —Pinquitsaatajea, pisapatotajea. Ari iquitsaataja, isapototaja. Aisati icantajiri: —Pampinaicajearo poicoro, poijatanaquena. ");
INSERT INTO cniNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Isoquijanaji, yoijatanaqueri. Te irioteji Petero queariosanotaquerica yoavisacotajiri inampire Tasorentsi. Yaamaaca imishitaca. ");
INSERT INTO cniNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Yavisanaqueri shentavetariri aparo, jeri aisati itsipa yavisanaqueri. Yareetacaro onta ashitacorontsi, onta iquenantapinitari nampitsiqui. Ashitareimotashitanajari. Yavisanajiro, yovaanaca anta avotsiqui. Irosati inijantareantanajari inampire Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Iotacotaja Petero, icanti: —Meeca niotasanotaque itiancaquenari Novincatsarite inampire. Yojocaacoventaquena iroyename Eroreshi. Aisati iquempetacoventaquena, yojocaacoventaquena jaocarica incantenameri noshanincapee. ");
INSERT INTO cniNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Iquenqueshiretanaquero, irosati ijatantaca ovancoqui Maria, iriniro Joa. Ipajiyeetiri Joa aisati Maricoshi. Anta yapatojeitacanta oshequi quemisantatsiri, iquenquetsatacaajeitiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Iposanavetapaaro Petero ashitacorontsi, ora otsapiquiniri: toc, toc. Ari ocatiashivetanacari nampirentsi pajitachari Irore. ");
INSERT INTO cniNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Iotsatavajiri irineane Petero, oquimoshiretasanotanaque. Iro cantaincha te ashitareanaqueneriji, ainti oshiashitanaca. Ocamantajeitiri quenquetsatacaajeitiriri Tasorentsi: —Jeritapaaji Petero omoroquinta. ");
INSERT INTO cniNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Icantajeitavaquero: —Pishinquiventacateemi. Aiquero ocantanaitii: —Queariosanotaque. Icantaquero: —Caari ini Petero, irintiata inampire Tasorentsi, amenacoventiriri. ");
INSERT INTO cniNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Aiquero catsini iposanaitiiro, toc, toc, irosati yashitareantajanari. Ari ineajeitavajiri, yoajeitavaqueri cavaco, icantavacaajeitanaja: —¿Jaoca iquenapaajiri? ");
INSERT INTO cniNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ari yacotashitanaqueri, icantiri: —Pimajerejeite. Impoiji icamantajeitapaajiri jaoca icantajiriri Avincatsarite, yoimisoquijantajariri. Aisati icantiri: —Pincamantaiteri Santiaco, aisati pincamantajeiteri ayemisantaririnte. Irosati isoquijantanaja, ijatanaji imanapitsatacari soraropee. ");
INSERT INTO cniNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Oquitaitetamani oshequi icantavacaimentajeitacari soraropee: —¿Jaocaquea meeca icantanajari Petero? ");
INSERT INTO cniNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Icoacantavetacari Eroreshi, te irineajeriji. Isampinatiri soraro shentavetariri: —¿Jaocaqueame iquenanajiri? Yacanaqueri: —Caa, jaocarica, te nioteji; te noneavajeriji. Ari iquisaqueri Eroreshi soraropee, yoacantajeitaqueri, shemi. Ari impoiji yojocanajiro Eroreshi Jorea, yovaanaja anta Sesareaqui, irosati isavicantapaaja. ");
INSERT INTO cniNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ari anta Tiroqui aisati Shiroqui aajeitaqueri savicajeitatsiri itashe, te ontimasanoteji iroajeiteari. Peerani icantiri iriori Eroreshi: —Pincavintsaajeitena, nocamicari. Pimpapinijeitenaro noyeari. Ari ipapinijeivetacari, iro cantaincha meeca iquisajeitaqueri. Oshequi iquenqueshireajeitanaca tirosati aisati shirosati. Icantavacaajeitaca: —Itsaneapitsajeiteerocari avajeiteari. Tsame ancanteri Varashito iramitacojeitee ampitsimareacaajeari: tempa iriotaque inampire Eroreshi. Ariorica incanteri, iraacameetsajeitajee aisati, eiroquea itsaneapitsatanteerotsi ayeari. Icantiri Varashito; impoiji icantiri iriori: —Ari, namitacojeitempi. Noncanteri novincatsarite incajemajeitempi, iraacameetsajeitempi. ");
INSERT INTO cniNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ari pashini quitaiteri icajemajeitaqueri Eroreshi, yaacameetsajeitaqueri. Yoaneencaro pincatsari iitsaare, isavicaque anta ivincatsarimentoqui. Oshequi ishemetaque, iquenquetsatacaajeitaqueri. Icantiri: —Eiro piquenqueshirejeitatsi. Nompajeitempi maaroni coiteimojeitaquempiri. ");
INSERT INTO cniNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Irosati iquimoshirejeitantanaca pocajeitaintsiri, icantajeitaque: —Te irio atiri aquemajeitaqueri, irinti Tasorentsi. Cameetsa ini. ");
INSERT INTO cniNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ari oshequi ishemetaque Eroreshi, iveshireimentacaro icantajeitaqueriri atiri. Iro cantaincha ishemacari Avincatsarite, itiancaqueri inampire: —Te impincatsatenaji Eroreshi. Pijate pojoquiitacayeari. Ari ijataque, yojoquitacaacari, impoiji icamanaque, torein, irosati yoantacari quenitsi. ");
INSERT INTO cniNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Irosati iquenacaantayetanacaro quemisantatsiri irineane Avincatsarite. Yoshequianaque quemisantajeitatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Iriori Verenave, aisati Saoro intacotanta anta Jerosarequi. Irosati ipiantanaja Antioquiaqui, itsipatanajari Joa, ipajiyeetiri aisati Maricoshi. ");
INSERT INTO cniNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Icarajeitiri quemisantatsiri anta Antioquiaqui camantantatsiri, aisati oametantatsiri: jeri Verenave, aisati Shimo Nijeri. Iroshio shirenesati, Manaemi ishaninca pincatsari Eroreshi, Saoro, maaroni. ");
INSERT INTO cniNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ari pashini quitaiteri yapatojeita iquemisantajeitiri Avincatsarite, tecatsi iroajeiteari. Irosati icantantacari Ishire Tasorentsi: —Pincantajeiteri Verenave aisati Saoro: “Pimateneri Tasorentsi paitarica incoacayempiri”. ");
INSERT INTO cniNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ari impoiji yajiricainajeitaqueri iitoqui, irosati icantantariri: ");
INSERT INTO cniNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","—Pijate pantero icoacaimpiri Tasorentsi, naroquea canterineri Tasorentsi iramitacotempi. Ari otiancaqueri Ishire Tasorentsi, irosati ijatantacari anta Sereoshiaqui. Yoijatanaqueri Joa Maricoshi iramitacotanteariri. Ari itetapaaca pitotsiqui. Otiancacotiri tampea, iquenacotanaque Tsipirequi. Otimi anta nampitsiqui pajitachari Saramina: yareejeitantapaacari anta, iquenquetsatapaaquero irineane Tasorentsi anta pancotsiqui yapatotapinijeitantari joriopee. ");
INSERT INTO cniNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Impoiji itsoteajeitanaquero maaroni nampitsipeequi anta Tsipirequi, maaroni. Impoiji yareejeitapaaca Pajoshiqui. Anta ineapaaqueri sheripiaritatsiri, pajitachari Varijesoshi. Jorio ini. Irishiyerime camantantatsiri, icantapiniti: —Naro quenquetsatirori irineane Tasorentsi. Ja, itseeyani. ");
INSERT INTO cniNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Itsipatapinitari pincatsaritatsiri pajitachari Serijio Pavoro. Ainiro iotantari iriori. Icajemacantaqueri Verenave, jeri Saoro: icoaque inquemero irineane Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Iro cantaincha itsaneavetacari yora sheripiari: te irinintacaaveteariji inquemisante yora pincatsaritatsiri. ");
INSERT INTO cniNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ari iotacotaqueri Saoro, pajitachari aisati Pavoro. Oametasanotiri Ishire Tasorentsi, yamenasanotanaqueri sheripiari, ");
INSERT INTO cniNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","icantanaqueri: —Pamatavitantasanotaque. Te catsini pincameetsateji: piquempetacari camaari. Te pininteroji cameetsayetatsiri, irointi picoasanotaque pamatavitante. Picoaque pamatavijeiteri maaroni coatsiri irioteri Novincatsarite. ¿Eirompa piquenqueshiretatsi? ");
INSERT INTO cniNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Meeca intasonquempi Novincatsarite pinquitapoajaquitanaque. Osamanitanaque, eiro pamenitajatsi. Irosati icamarajatantanaca, otsiteniiteacotanaqueri. Ipamipamitanaque, pami, pami; icanti: —Teve namenajeve. Pancatsatanajenave. ");
INSERT INTO cniNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ari ineavaqueri yora pincatsaritatsiri, aisati iquemiro irineane Avincatsarite, irosati iquemisantantanaca. Icanti: —Cameetsave oca icamantacotiriri Avincatsarite. ");
INSERT INTO cniNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Iponeanaja Pavoro Pajoshiqui, itetanaja pitotsiqui, itejeitanaja aisati maaroni icarajeitiri. Iquenacotanaque anta Perejequi, ora Pampiriaquiniri. Iriori Joa yojocanajiri, ipianaja iriori Jerosarequi. ");
INSERT INTO cniNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Impoiji itsipapee, yovaajeitanaja aisati. Yareejeitapaaca anta pashiniqui Antioquia: ora Pishiriaquiniri. Quitaiteri imaoreantajeitari iqueajeitapaaque pancotsiqui yapatojeitantari, ari isavicajeitapaaque. ");
INSERT INTO cniNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ineanayeetiro isanquenareni Moishishi, aisati isanquenareni camantantatsiniri. Yora jivatacantantatsiri anta pancotsiqui, icantavaqueri: —Noshaninca, pincoaquerica avirori pinquemisantacayeri ashanincapee aca, pincamanteriqueti. ");
INSERT INTO cniNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ari icatianaca Pavoro, yacotashitaqueri yoimajerentajeitaqueri. Icanti: —Noshaninca, ariorica pipincatsataqueri Tasorentsi, pinquemisantajeitavaquena. ");
INSERT INTO cniNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Meeca nonquenquetsatacotempiri Tasorentsi iquemisantiniri Ishiraerini. Peerani icoyeaqueri intacantayetacariniri inquemisanteri. Impoiji, itimantacari ashanincani anta Ejipitoqui, yoshequiacaaqueri. Itasoncacoventajeitiri, irosati ishinetantacari peranavetariri ijajeitanaque. ");
INSERT INTO cniNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ocarati 40 osarintsi itimajeiveitani ashanincani anta caaraiteriqui, iro cantaincha oshequi itseencajeitaqueri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Icoajeivetaca irareejeiteame Cananaqui, iro cantaincha isaviqui pashinisatipee atiri, ticaajeivetavacariri. Inashiyetaca iriori, ocarati irineanepee 7. Impoiji itasoncaventiniri Tasorentsi ashanincani, itsoncajeitaqueri savicajeiveitachaniri. Impoiji ipaqueri ashanincani iipatsite, icantiri: “Jero oca, pisavicajeitanteari”. ");
INSERT INTO cniNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ari ocarataque osarintsi isavicajeitaque 450. Te intimeji pincatsariventasanojeiterineri, irinti ijivatashijeivetacarini itsipapee savicacantayetatsiri. Impoiji ijivatacanti yora camantantatsiniri pajiveitachaniri Samoiri. ");
INSERT INTO cniNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Impoiji icantaqueri ashanincani Tasorentsi: “Nocoajeitaque pincatsariventasanojeitenaneri”. Ari icoyeaqueneri Saoro, ipincatsariventantariniri ashanincani. Irio iriri iriori Saoro ipajita Shishi. Iriojeitaque ishanincapeeni Vejami. Ocarati 40 osarintsi ipincatsariventantaque Saoro, ");
INSERT INTO cniNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","impoiji icanti Tasorentsi: “Eiro ipincatsariventantajitsi aisati Saoro, te incameetsateji, irinti pincatsaritajantsine Iraviri, yora itomi Jese. Irio noneacameetsatasanotaqueri, irantenaro irinti maaroni nonintacayeriri”. ");
INSERT INTO cniNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Iriotaque ishanincani Iravirini oavisacotajeeri: ipajita iriori Jesoshi. Tempa icantini Tasorentsi: “Irio ishanincani Iravirini oavisacojeiterineri atiri”. Moncarataca meeca icantitacaniri. ");
INSERT INTO cniNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ijivataqueri Joa iquenquetsatacaajeitaquerini maaroni ashaninca: “Pinquenqueshirejeitajea, eiro piquempejeitajatsi peerani, impoiji novaotisajeitempi, aisati iroavisacojeitempi Tasorentsi”. Impoijiquea iquenquetsatapaaque Jesoshi. ");
INSERT INTO cniNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Iriori Joa irotaintsi incame, ari icanti: “Te narosano yora piquenqueshirejeivetari. Te naro Quirishito oavisacojeitempineri, irintiquea impoitapeenaneri. Oshequi nopincatsatasanotaqueri narori; irompa nainti, te nompincatsatimateaji”. ");
INSERT INTO cniNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ari yovaajiniri aisati Pavoro, icantiri: —Noshaninca, tempa ashanincajeitarini Avaramani, tsame anquempetasanojeiteari, ampincatsatasanojeiteri Tasorentsi. Meeca noncamantajeitempi: ariorica ampincatsatasanojeiteri Jesoshi, ari iroavisacojeitee. ");
INSERT INTO cniNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Te iriojeitavaqueriji jerosaresati, itseencajeitavaqueri. Aisati iquempejeitaqueri ivincatsaritepee, te iriojeiteriji Quirishito ini. Maaroni saavaro ineanatapinijeivetaro isanquenayetiniri camantantatsiniri, iro cantaincha te inquemasanotavaqueroji, irootaque caari iojeitantaro oquenquetsatacotiri Jesoshi. Iriotaque oquenquetsatacotiri Sanquenarentsi: “Iroyeeteri Quirishito”. Ari yoacantajeitaqueri ashanincajei Quirishito, iro cantaincha te irioteriji. ");
INSERT INTO cniNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Tecatsi irantavetea, yoacantashitacari. Icantacoventashitacari Pirato: “Poacanteri”. ");
INSERT INTO cniNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Moncarayetaca maaroni isanquenatacotitacariniri: oshequi yoashinoncaaqueri, ipajacotaqueri coroshiqui, icamanaque, torein. Impoiji yoaniireajiri, yoaqueri anta omoroqui imperita. ");
INSERT INTO cniNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Icamasanovetaca, iro cantaincha yoitinaajiri Tasorentsi. ");
INSERT INTO cniNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ari ocarataque oshequi quitaiteri inijaapinijeitajari iroamere, yora tsipajeitapaajariri chapinqui Jerosarequi: yora poneachari Carireaqui. Iriojeitaque meeca camantajeitiriri atiri. Jero aisati icantajeitiriri Pavoro: ");
INSERT INTO cniNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","—Ocameetsataque icamantaqueriniri peerani Tasorentsi ashanincani. Isanquenatacaaqueri peeraniniri otimantacari pampoyeantsi, oca apitetaintsiri. Ocantini: “Incanteri Tasorentsi Quirishito: ‘Ariorica nontinaajempi noncantajempi notomi’ ”. Meeca noncamantajeitempi: imataquero Tasorentsi icantaqueriniri ashanincani: yoitinaajiri Jesoshi, ayojeitantacari Quirishito ini. ");
INSERT INTO cniNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jeroca pashini icantaqueriniri Tasorentsi: “Notiomi, nomoncaratasanotempiro maaroni nocantaqueriniri Iravirini: nontasoncacoventempi pimpincatsaritasanotanteari. Queariotasanotaque: tempa narotaque cantaquempiri”. Irootaque, noshaninca, piojeitantacariri yoitinaasanotajiri Tasorentsi Quirishito, irootaque ipincatsaritasanotantajari. Icamasanovetaca, yoitinaajiri, te impatsayeji quipatsiqui. ");
INSERT INTO cniNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tempa irootaque oca isanquenataqueniri pashini pampoyeaveitachaniri: “Tasorentsi, niotaque eiro pishinetiritsi pitomi impatsaye quipatsiqui: tempa oshequi pineacameetsataqueri”. ");
INSERT INTO cniNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pinquenqueshireteri peerani Iravirini, imoncarataqueneri Tasorentsi maaroni icoacairiri. Impoiji icamaque iriori, torein. Itijeetaqueri, itsipayeetaqueri ishanincapeeni, irosati ipatsaasanotantanaca. ");
INSERT INTO cniNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Irompa irinti Jesoshi itinaa