﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmok_vpl;
CREATE TABLE cmok_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmok_vpl WRITE;
INSERT INTO cmok_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ឞើស​នតើម​ឆាអើម​ឆាអាម​កោរាញ​ឞ្រាស​ញជេង​ត្រោក ញជេង​នែស​នតូ។ ");
INSERT INTO cmok_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","នោក​នៃ​នើស​នែស​នតូ​អេ​ហ៝ៈ​គែស​អោស ហោម​ញឆ៝យ្ស​ឞ៝ង់​លាហឺរ ង៝​ចេក​កោលាក់​ងាន់​តា​ឞើស​លើ​ទាក​ជ្រូ ជេសរី​ឞ្រាស​ហ្វេង​អ្វែស​កោរាញ​ឞ្រាស​ហាន់​រាឆ៝ង​តា​កាលើ​ទាក​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ជេសរី​កោរាញ​ឞ្រាស​លាស៖ “អ៝ន់​គែស​អាង” ជេសរី​គែស​អាង​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","កោរាញ​ឞ្រាស​ឆៃ​អាង​អី​នៃ​លែៈ​អ្វែស​ជេស ជេសរី​ពាង់​តឹម​ងខាស​លើយ​អាង​នៃ​ឞើស​ង៝។ ");
INSERT INTO cmok_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","កោរាញ​ឞ្រាស​ក្វាល់​អាង​អី​នៃ​រាញា «នារ» ជេសរី​ពាង់​ក្វាល់​ដ៝ង់​ង៝​រាញា «មាង់» តា​នៃ​គែស​មាង់​គែស​អោយ អី​នៃ​ជេង​នារ​ត៝ល់​ង្វាយ។ ");
INSERT INTO cmok_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ជេសរី​កោរាញ​ឞ្រាស​លាស៖ “អ៝ន់​គែស​ទូ​មល៝ម់​រាលាត​តា​ងក្លាង​ងគូល​ទាក​គៃ​មា​តឹម​ងខាស​លើយ​ទាក”។ ");
INSERT INTO cmok_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","នទ្រី​កោរាញ​ឞ្រាស​ជាន​រាលាត​អី​នៃ គៃ​មា​តឹម​ងខាស​លើយ​ទាក​ឞើស​ទ៝ង់​ឞើស​លើ ជេសរី​គែស​កើត​អី​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ជេសរី​កោរាញ​ឞ្រាស​ក្វាល់​រាលាត​អី​នៃ​រាញា​«ត្រោក» តា​នៃ​គែស​មាង់​គែស​អោយ អី​នៃ​ជេង​នារ​ត៝ល់​ឞារ។ ");
INSERT INTO cmok_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ជេសរី​កោរាញ​ឞ្រាស​លាស៖ “ទាក​អី​តា​ន៝ម់​ត្រោក​អី​នៃ​អ៝ន់​ញឆុន​គុ​ទូ​នតុក គៃ​អ៝ន់​មពើល​កើស” ជេសរី​គែស​កើត​អី​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","កោរាញ​ឞ្រាស​ក្វាល់​កើស​អី​នៃ​រាញា​«នែស» ក្វាល់​ទាក​ញឆុន​អី​នៃ​រាញា​«ទាក​វាច់​ទាក​វារ់» កោរាញ​ឞ្រាស​ឆៃ​លែៈ​នទើ​ពាង់​ញជេង​អី​នៃ​អ្វែស​ទាទេ​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ជេសរី​កោរាញ​ឞ្រាស​លាស៖ “អ៝ន់​នែស​គែស​ហ៝ន​តើម​ឆី​តើម​គ្លែ​រេប​ជា​អី​គែស​ងគារ់ តើម​ឆី​តើម​គ្លែ​អី​គែស​ព្លៃ​អី​គែស​ងគារ់​ហ៝ន​តាៈ​ឞើស​នែស គែស​លែៈ​នតីល​តឹង​នតីល​អេងៗ” ជេសរី​គែស​កើត​អី​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","តា​កាលើ​នែស​ពាង់​គែស​ហ៝ន​ព្រូ​តើម​ឆី​តើម​គ្លែ​រេប​ជា​ទឹង​លែៈ​នតីល​អេងៗ នទ្រែល​មា​តើម​ឆី​តើម​គ្លែ​អី​គែស​ព្លៃ​អី​គែស​ងគារ់។ កោរាញ​ឞ្រាស​ឆៃ​លែៈ​នទើ​ពាង់​ញជេង​អី​នៃ​អ្វែស​ទាទេ​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","តា​នៃ​គែស​មាង់​គែស​អោយ អី​នៃ​ជេង​នារ​ត៝ល់​ពែ។ ");
INSERT INTO cmok_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ជេសរី​កោរាញ​ឞ្រាស​លាស៖ “អ៝ន់​គែស​នទើ​អាង​អេងៗ​តា​កាលើ​ត្រោក គៃ​មា​តឹម​ងខាស​លើយ​នារ​ដាស​មាង់ អ៝ន់​មា​ឞ្លាវ​កើប​នារ ខៃ នាម់ ");
INSERT INTO cmok_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","នទ្រែល​មា​អាង​តា​នែស​នតូ​អ្យា​ដ៝ង់” ជេសរី​គែស​កើត​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","នទើ​អាង​កោរាញ​ឞ្រាស​លែៈ​ជេស​ញជេង​គែស​នទើ​អាង​ក្វ៝ង់ៗ​ឞារ​មល៝ម់​តា​កាលើ​ត្រោក នទើ​អាង​អី​ទូ​មល៝ម់​រី​ទាង់​រាលាវ​ឞូ​មា​អាង​នោក​នារ នទើ​អាង​ដេៈៗ​រី​មា​អាង​នោក​មាង់ នហ៝​មា​ពាង់​ញជេង​ដ៝ង់​ទឹង​លែៈ​មាញ់​មឞីង។ ");
INSERT INTO cmok_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","កោរាញ​ឞ្រាស​តេៈ​នទើ​អាង​តា​កាលើ​ត្រោក​នៃ គៃ​មា​អាង​តា​នែស​នតូ​អ្យា ");
INSERT INTO cmok_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","មា​អាង​តា​នោក​នារ តា​នោក​មាង់ គៃ​មា​តឹម​ងខាស​អាង​ឞើស​ង៝​ដ៝ង់ កោរាញ​ឞ្រាស​ឆៃ​លែៈ​នទើ​អាង​អី​នៃ​អ្វែស​ទាទេ​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","តា​នៃ​គែស​មាង់​គែស​អោយ អី​នៃ​ជេង​នារ​ត៝ល់​ព្វាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ជេសរី​កោរាញ​ឞ្រាស​លាស៖ “តា​ត្រោម​ទាក​អ៝ន់​គែស​កឹត​កា​ងគ្លា​មែ​រែ​អ៝ន់​អ៝ក់​រ៝ក់ តា​កាលើ​ត្រោក​អ៝ន់​គែស​ឆ្យុម​មពារ់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","នទ្រី​កោរាញ​ឞ្រាស​ញជេង​កា​ក្វ៝ង់ៗ​ងាន់​រ៝ៈ​ទាក​វាច់​ទាក​វារ់ នទ្រែល​មា​ទឹង​លែៈ​នទើ​អី​គែស​រេស​គែស​នហ៝ម់​ឞ្លាវ​មព៝ត់​ឞ្លាវ​ញឆ្ល៝ង់​ព៝ល់​រែ​លិញ​វិញ​តា​ទាក តឹង​នតីល​អេងៗ​ងាន់ ទឹង​លែៈ​ឆ្យុម​នារ​គែស​តឹង​នតីល​អេងៗ​ដ៝ង់។ កោរាញ​ឞ្រាស​ឆៃ​ទឹង​លែៈ​នទើ​អី​នៃ​អ្វែស​ទាទេ​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ជេសរី​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​ទឹង​លែៈ​នតីល​នទើ​អី​នៃ ពាង់​លាស៖ “អ៝ន់​គែស​អ៝ស​គែស​ក៝ន​ឞឹក​រឹ​លាម​ទាក​វាច់​ទាក​វារ់​នៃ ឆ្យុម​នារ​អ៝ន់​គែស​អ៝ស​គែស​ក៝ន​ឞឹក​រឹ​តា​នែស​នតូ​អ្យា​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","តា​នៃ​គែស​មាង់​គែស​អោយ អី​នៃ​ជេង​នារ​ត៝ល់​ព្រាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ជេសរី​កោរាញ​ឞ្រាស​លាស៖ “តា​នែស​នតូ​អ្យា​អ៝ន់​គែស​មពោមពា​(ឆ្យុម)​តឹង​នតីល​អេងៗ មពោមពា​(ឆ្យុម)​តា​ប៝ន មពោមពា​(ឆ្យុម)​ហូង​វើរ មពោមពា​(ឆ្យុម)​តា​ឞ្រី” ជេសរី​គែស​កើត​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","កោរាញ​ឞ្រាស​ញជេង​មពោមពា​(ឆ្យុម)​តា​ឞ្រី គែស​តឹង​នតីល​អេងៗ មពោមពា​(ឆ្យុម)​តា​ប៝ន​តឹង​នតីល​អេងៗ ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អី​ហូង​អី​វើរ​តា​នែស​នតូ​អ្យា​គែស​តឹង​នតីល​អេងៗ​ដ៝ង់ ពាង់​ឆៃ​ទឹង​លែៈ​នតីល​នទើ​អី​នៃ​អ្វែស​ទាទេ​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ជេសរី​កោរាញ​ឞ្រាស​លាស៖ “អ៝ន់​ឞ៝ន់​ជាន​ក៝ន​ឞូនុយ្ស​ឞ្លាវ​មឹន​ជេង​កោរាញ​តឹម​ឞាន​មា​ឞ៝ន់​នើម​កើត​ឞ៝ន់​នើម អ៝ន់​ពាង់​កោរាញ​មា​នែស​នតូ​អ្យា ទើយ​ដាស​មា​កឹត​កា​តា​ទាក​វាច់​ទាក​វារ់ ឆ្យុម​មពារ់​តា​កាលើ​ត្រោក មពោមពា​(ឆ្យុម)​តា​ឞ្រី​តា​ប៝ន​លាម​នែស​នតូ នទ្រែល​មា​អ៝ន់​ពាង់​ទើយ​ទាទេ​ដាស​ទឹង​លែៈ​នតីល​នទើ​ហូង​នទើ​វើរ​តា​នែស​នតូ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","កោរាញ​ឞ្រាស​ញជេង​ក៝ន​ឞូនុយ្ស​នើស​ឞ្លាវ​មឹន​ជេង​កោរាញ​តឹម​ឞាន​មា​ពាង់នើម​ងាន់ កើត​ពាង់នើម​ងាន់​រ៝ កោរាញ​ឞ្រាស​ញជេង​ខាន់​ពាង់​អ៝ន់​គែស​ឞូ​ក្លោ​គែស​ឞូ​អូរ។ ");
INSERT INTO cmok_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ជេសរី​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​ខាន់​ពាង់ ពាង់​លាស៖ “អ៝ន់​ឞាៈ​អ៝ស​រ៝ង​ក៝ន​ឞឹក​រឹ​លាម​នែស​នតូ​អ្យា អ៝ន់​ជេង​កោរាញ​មា​នែស​នតូ​អ្យា ជេសរី​ទើយ​ដាស​មា​កឹត​កា​តា​ទាក​វាច់​ទាក​វារ់ ឆ្យុម​មពារ់​តា​កាលើ​ត្រោក ទើយ​ដាស​ទឹង​លែៈ​រាងោច​មពោមពា​(ឆ្យុម)​អី​គែស​តា​នែស​នតូ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","កោរាញ​ឞ្រាស​លាស​ជឹត៖ “ហើយ​ខាន់​អៃ​មៃ អ្វាញ់​អ្យា! គ៝ប់​ញជេង​អ៝ន់​គែស​ទឹង​លែៈ​នតីល​រេប​ជា​អី​គែស​ងគារ់​ហ៝ន​លាម​នែស​នតូ​អ្យា នទ្រែល​មា​ទឹង​លែៈ​នតីល​តើម​ឆី​តើម​គ្លែ​អី​គែស​ព្លៃ​គែស​ងគារ់​អ្យា គៃ​មា​អ៝ន់​ខាន់​អៃ​មៃ​ឆោង​ឆា ");
INSERT INTO cmok_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ជេសរី​លែៈ​រាងោច​ឆ្យុម​មពារ់​កាលើ​ត្រោក លែៈ​រាងោច​មពោមពា​(ឆ្យុម) ទឹង​លែៈ​នតីល​នទើ​ហូង​នទើ​វើរ ទឹង​លែៈ​នតីល​នទើ​អី​គែស​រេស​គែស​នហ៝ម់​តា​នែស​នតូ​អ្យា គ៝ប់​អ៝ន់​ដ៝ង់​រេប​ជា​តើម​ឆី​តើម​គ្លែ​ទឹង​លែៈ​នតីល​អ្យា​ព្រែ​មា​កាប់​មា​ឆា​ដ៝ង់” ជេសរី​ពាង់​គែស​កើត​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","កោរាញ​ឞ្រាស​អ្វាញ់​ទឹង​លែៈ​រាងោច​នទើ​ពាង់​ញជេង​អី​នៃ​នើស ពាង់​ឆៃ​ទឹង​លែៈ​នតីល​នទើ​ពាង់​ជាន​នើស លែៈ​អ្វែស​ងាន់​រ៝ តា​នៃ​គែស​មាង់​គែស​អោយ អី​នៃ​ជេង​នារ​ត៝ល់​ព្រាវ។ ");
INSERT INTO cmok_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","នទ្រី​ត្រោក នែស​នតូ លែៈ​រាងោច​អាប់​នតីល​នទើ លែៈ​រាងោច​អាប់​នតីល​មពោមពា​(ឆ្យុម) កោរាញ​ឞ្រាស​ញជេង​ជេស​លែៈ​ផ្យៅ​ទាទេ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ត៝ត់​នារ​ពើស កោរាញ​ឞ្រាស​ជាន​លែៈ​នទើ​នើស​លែៈ​ជេស​លែៈ​ផ្យៅ ជេសរី​ពាង់​គុ​ទើម​ឞាស​ជាន​ការ​តា​នារ​ពើស​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​តា​នារ​ពើស​អី​នៃ កើប​នារ​អី​នៃ​ជេង​នារ​ខ្លៃ​ជេង​នារ​ក្ល៝ស​អ្វែស យ៝រ​លាស​នារ​អី​នៃ​ពាង់​គុ​ឞាស​ទឹង​លែៈ​នទើ​ពាង់​ជាន​ពាង់​ញជេង​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","នទ្រី​នាវ​ងក៝ច​នតើម​គែស​ត្រោក​នតើម​គែស​នែស​នតូ។ ឞើស​នោក​ឞ្រាស​យេហោវា ​ញជេង​ត្រោក ញជេង​នែស​នតូ ");
INSERT INTO cmok_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","តើម​ឆី​អេ​ហ៝ៈ​គែស​ហ៝ន ឞា​ទូ​ងក៝ង​អេ​ហ៝ៈ​គែស​ដ៝ង់ យ៝រ​លាស​ឞ្រាស​យេហោវា ​អេ​ហ៝ៈ​អ៝ន់​គែស​ទាក​មីស​តុប​តា​នែស​នតូ​អ្យា ឞូនុយ្ស​មា​ជាន​មីរ​មោ​ហ៝ៈ​គែស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","គែស​ទាក​លោស​នហោល​តាៈ​ឞើស​នែស​ទើម​ឞែៈ​លាម​នែស​នតូ។ ");
INSERT INTO cmok_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ជេសរី​ឞ្រាស​យេហោវា ​ឆ៝ៈ​នែស​មោយ​ជាន​ម៝ន​ទូ​ហ្វេ​ឞូនុយ្សពាង់​ខោម​នហ៝ម់​លាប់​រ៝ៈ​ត្រោម​មុស​ឞូនុយ្ស​អី​នៃ ជេសរី​គែស​នហ៝ម់​គែស​ឆ្វាន ជេង​រេស​ប្លឺ​នទ្រី​ពាង់​ហែស។ ");
INSERT INTO cmok_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ឞ្រាស​យេហោវា ​អ៝ន់​គែស​ទូ​មល៝ម់​មីរ​តា​ឞ្រី​អេដែន  តា​នតុក​មពែស​មា​លោស​នារ​នៃ ជេសរី​ឆ៝ៈ​ឞូនុយ្ស​អី​ពាង់​ម៝ន​ជាន​នើស​លែវ​គុ​តា​នតុក​មីរ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ជេសរី​ឞ្រាស​យេហោវា ​អ៝ន់​តើម​ឆី​តើម​គ្លែ​អាប់​នតីល​ហ៝ន​ដែស​ព្រូ​តាៈ​ឞើស​នែស អ្វែស​ងាន់​អ្វាញ់ នទ្រែល​មា​គែស​ព្លៃ​ឆា​កាស​ដ៝ង់។ តា​ងក្លាង​ងគូល​មីរ​អី​នៃ​គែស​តើម​ឆី​ឞារ​តើម តើម​ឆី​អី​ទូ​តើម​រី​អ៝ន់​មា​នាវ​រេស តើម​ឆី​អី​ទូ​តើម​រី​ជឹត​អ៝ន់​មា​គឹត​នាល់​នទើ​អ្វែស​នទើ​អ្យើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","គែស​ទូ​មល៝ម់​នហ៝ង​លោស​តាៈ​ឞើស​ឞ្រី​អេដែន ​ហ៝ច​រ៝ៈ​មីរ​អី​នៃ ជេសរី​នហ៝ង​អី​នៃ​គែស​ញចាស​ព្វាន់​អឹ​នហ៝ង​ដ៝ង់​លោស​ឞើស​នហ៝ង​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ទូ​មល៝ម់​នហ៝ង​រាញា​ពីហុន  ហ៝ច​ងក្វែ​ងក្វាច់​រ៝ៈ​ឞ្រី​ហាវីលា  នតុក​ឞ្រី​អី​គែស​មាយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","មាយ្ស​អី​លោស​តាៈ​ឞើស​នតុក​អី​នៃ​អ្វែស​ងាន់ ជេសរី​គែស​ដ៝ង់​នតាក់​ឆី​បោ​កាស នទ្រែល​មា​លុ​ខ្លៃ​រាញា​ដៃកៀម ។ ");
INSERT INTO cmok_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","នហ៝ង​ត៝ល់​ឞារ​រាញា​កីហូន  អី​ហ៝ច​ងក្វែ​ងក្វាច់​រ៝ៈ​ឞ្រី​កុស ។ ");
INSERT INTO cmok_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","នហ៝ង​ត៝ល់​ពែ​រាញា​ហីដេកែល  ហ៝ច​មពែស​មា​លោស​នារ​មា​ប៝ន​អាឆើរ ។ ជេសរី​នហ៝ង​ត៝ល់​ព្វាន់​រាញា​អើប្រាត ។ ");
INSERT INTO cmok_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ជេសរី​ឞ្រាស​យេហោវា ​ឆ៝ៈ​ឞូនុយ្ស​អី​ពាង់​ជាន​ម៝ន​នើស​អ៝ន់​គុ​តា​មីរ​អេដែន ​អី​នៃ នហ៝​មា​ដាៈ​ឞូនុយ្ស​អី​នៃ​គុ​ម៝ត់​អ្វាញ់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ឞ្រាស​យេហោវា ​ដាៈ​ឞូនុយ្ស​អី​នៃ ពាង់​លាស៖ “លែៈ​រាងោច​ព្លៃ​ឆី​ព្លៃ​គ្លែ​តា​មីរ​អ្យា​មៃ​ឆា​ទាទេ​មោ​ច្រាវ​វាៈ ");
INSERT INTO cmok_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","តីស​មា​តា​ព្លាង់​តើម​ឆី​អ៝ន់​មា​គឹត​នាល់​នទើ​អ្វែស​នទើ​អ្យើស គ៝ប់​មោ​អោស​អ៝ន់​មៃ​ឆា មោ​អ៝ន់​មៃ​ឆា​វាៈ លាស​មៃ​ឆា​មៃ​ខឹត​នារ​នៃ​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ជេសរី​ឞ្រាស​យេហោវា ​មឹន​អេង៖ “លាស​អ៝ន់​ឞូនុយ្ស​អ្យា​គុ​ទូ​ហ្វេ​អេង​លិច​អ្វែស​អោស លាស​នទ្រី​គ៝ប់​ជាន​តៃ​ទូ​ហ្វេ​ឞូនុយ្ស​ជឹត​អ៝ន់​មា​ពាង់​គុ​នទ្រែល​តឹម​កើល​ឞាល់”។ ");
INSERT INTO cmok_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","នោក​ឞ្រាស​យេហោវា ​ញជេង​មពោមពា​(ឆ្យុម)​ទឹង​លែៈ​នើស ពាង់​ឆ៝ៈ​នែស​ម៝ន​អាប់​នតីល​មពោមពា​(ឆ្យុម)​តា​នែស​នតូ អាប់​នតីល​ឆ្យុម​មពារ់​តា​កាលើ​ត្រោក។ ជេសរី​ឞ្រាស​យេហោវា ​លែវ​ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អី​នៃ​មា​ឞូនុយ្ស យ៝រ​លាស​ឞ្រាស​យេហោវា ​អុច​គឹត​អា​មើម​ឞូនុយ្ស​អី​នៃ​តេៈ​រាញា​អ៝ន់​មា​មពោមពា​(ឆ្យុម)​ទឹង​លែៈ​អី​នៃ ជេសរី​មពោមពា​(ឆ្យុម)​ទឹង​លែៈ​គែស​រាញា​តឹង​ឞូនុយ្ស​តេៈ​រាញា​អ៝ន់។ ");
INSERT INTO cmok_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ឞូនុយ្ស​តេៈ​រាញា​លែៈ​រាងោច​មពោមពា​(ឆ្យុម)​តា​ឞ្រី តា​ប៝ន នទ្រែល​មា​ឆ្យុម​មពារ់​តា​កាលើ​ត្រោក​ដ៝ង់។ យើន​មា​មោ​អោស​ឆៃ​គែស​ទូ​នតីល​នទើ​មា​ឞ្លាវ​តឹម​កើល​ឞូនុយ្ស​អី​នៃ មា​ឞ្លាវ​គុ​នទ្រែល​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","នទ្រី​ឞ្រាស​យេហោវា ​អ៝ន់​ឞូនុយ្ស​អី​នៃ​លេត​ឞិច ឞ្រាស​យេហោវា ​ឆ៝ៈ​ទូ​មល៝ម់​នតីង​ពាយ្ស​ឞូនុយ្ស​អី​នៃ ជេសរី​ញជឹរ​លើយ​មលៃ​អ៝ន់​ជឹរ។ ");
INSERT INTO cmok_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","នតីង​ពាយ្ស​អី​ឞ្រាស​យេហោវា ​ឆ៝ៈ​តាៈ​ឞើស​ឞូនុយ្ស​អី​នៃ​ពាង់​ជាន​ជេង​ឞូ​អូរ ជេសរី​លែវ​ឞូ​អូរ​អី​នៃ​អ៝ន់​មា​ឞូនុយ្ស​ឞូ​ក្លោ​អី​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ឞូនុយ្ស​អី​នៃ​លាស៖ “ឞូនុយ្ស​អ្យា​រ៝​នតីង​អី​ឆ៝ៈ​តាៈ​ឞើស​នតីង​គ៝ប់ មលៃ​អី​ឆ៝ៈ​តាៈ​ឞើស​មលៃ​គ៝ប់ គ៝ប់​ក្វាល់​ពាង់​រាញា «ឞូ​អូរ» យ៝រ​លាស​ពាង់​នើស​លោស​តាៈ​ឞើស​ឞូ​ក្លោ”។ ");
INSERT INTO cmok_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","យ៝រ​មា​កើត​នទ្រី​ទឹង​ឞូ​ក្លោ​លោស​ទូ​ឞើស​មែ​ឞឹ ហាន់​គុ​អា​អូរ ជេសរី​ឞារ​ហៃ​ខាន់​ពាង់​នៃ​ជេង​អូរ​ឆាយ​ជេង​ទូ​រាង្លៃ​ឆាក់។ ");
INSERT INTO cmok_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","នោក​នៃ​លែៈ​ឞារ​ហៃ​អូរ​ឆាយ​ខាន់​ពាង់​នៃ​គុ​លាហោក មោ​គែស​នាវ​ដីត​ព្រេង​ដេៈ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","នតើម​នើស​គែស​ទូ​មល៝ម់​ឞេស​ជេង​មពោមពា​(ឆ្យុម)​ឞ្រី ពាង់​ឞ្លាវ​រាលាម់​នាវ​រាលាវ​ឞូ ដាស​មា​មពោមពា​(ឆ្យុម)​អាបាៈ​អេង​តា​ឞ្រី​អី​ឞ្រាស​យេហោវា ​លែៈ​ជេស​ញជេង។ គែស​ទូ​នារ​ឞេស​នៃ​អោប​មា​ឞូ​អូរ​អី​នៃ៖ “ហើយ​យោស ងាន់​លាស​កោរាញ​ឞ្រាស​លាស​នើស៖ «មោ​អ៝ន់​ខាន់​អៃ​មៃ​ឆា​ព្លៃ​ទឹង​លែៈ​តា​មីរ​អ្យា?»” ");
INSERT INTO cmok_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ឞូ​អូរ​អី​នៃ​អើស​មា​ពាង់៖ “លិច​នទ្រី​អោស ព្លៃ​តា​មីរ​អ្យា​កោរាញ​ឞ្រាស​អ៝ន់​ហេន​ឆា​ទាទេ‌ ");
INSERT INTO cmok_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","តើម​ព្លៃ​អី​ងក្លាង​មីរ​អី​នៃ​ទូ​តើម​ទើម កោរាញ​ឞ្រាស​លាស៖ «ព្លៃ​តើម​ឆី​អី​ងក្លាង​មីរ​អី​នៃ​មោ​អោស​អ៝ន់​ខាន់​អៃ​មៃ​ឆា មោ​អោស​អ៝ន់​ខាន់​អៃ​មៃ​ពាស លាស​ឆា​លាស​ពាស​ខាន់​អៃ​មៃ​មរា​ខឹត​រ៝» នទ្រី​លាស​ព្រែ​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ឞេស​លាស​មា​ឞូ​អូរ​អី​នៃ​ជឹត៖ “មោ​ខឹត​អោស​យោស ខាន់​អៃ​មៃ​មោ​ខឹត​វាៈ។ ");
INSERT INTO cmok_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","កោរាញ​ឞ្រាស​ពាង់​គឹត លាស​ខាន់​អៃ​មៃ​ឆា មាត់​មរា​អាង រី​មើ​ទឹង​ខាន់​អៃ​មៃ​ជេង​តឹម​ឞាន​មា​កោរាញ​ឞ្រាស​នើម គឹត​នាល់​នទើ​អ្វែស​នទើ​អ្យើស​ដ៝ង់​អេៈ”។ ");
INSERT INTO cmok_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ជេសរី​ឞូ​អូរ​អី​នៃ​ឆៃ​ព្លៃ​ឆី​អី​នៃ​ទុម​អ្វែស​ងាន់ អុច​មា​ឆា​រ៝ ពាង់​កើញ​គែស​នាវ​គឹត​ឞ្លាវ​អី​រី នហ៝​មា​ត៝ត់​ពាង់​ពែៈ​ឆា។ អី​ឆាយ​ពាង់​គុ​ដាស​ពាង់​នើម​តា​នៃ​ដ៝ង់ ជេសរី​ពាៈ​អ៝ន់​អី​ឆាយ​ពាង់​ឆា អី​ឆាយ​ពាង់​ឆា​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ជេស​ឆា​ព្លៃ​អី​នៃ មាត់​ខាន់​ពាង់​ឆៃ​អាង​ងាន់​រ៝ នហ៝​មា​គឹត​លាស​ឆាក់​ខាន់​ពាង់​នើម​គុ​លាហោក​ដ៝ង់ ជេសរី​ខាន់​ពាង់​ពែៈ​នហា​រាវី  ជឹង​តឹម​ងក្រេប​ជាន​ឞ៝ក​គៃ​មា​មឞាន់​ឆាក់​ជាន់​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ត៝ត់​នារ​វែត​ញឆ្រិញ​រិញ​នអីក​រាងេត​នៃ ខាន់​ពាង់​តាង់​នតែស​ឞ្រាស​យេហោវា ​ហាន់​ឞ្រោៈ​រ៝ៈ​មីរ​នៃ ខាន់​ពាង់​ទូ​ញច្វាត់​ក្រាប​តា​ន៝ម់​តើម​ឆី​តា​មីរ​នៃ​រ៝ គៃ​មា​លើយ​អ៝ន់​ឞ្រាស​យេហោវា ​ឆៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ជេសរី​ឞ្រាស​យេហោវា ​ក្វាល់​អី​ឆាយ​រី៖ “ហើយ​អាដាម់  អាស​មៃ​ហ្យើ?” ");
INSERT INTO cmok_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ពាង់​អើស៖ “គ៝ប់​តាង់​មៃ​ហាន់​រ៝ៈ​មីរ​នៃ គ៝ប់​ក្លាច​ញឆ៝រ់​ងាន់ យ៝រ​លាស​គ៝ប់​នើស​គុ​ឆាក់​លាហោក​ទើម កើត​នទ្រី​ទឹង​គ៝ប់​ក្រាប​កោរាញ​ឞ្រាស​មេ”។ ");
INSERT INTO cmok_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ឞ្រាស​យេហោវា ​អោប​ជឹត៖ “ឞូ​ម៝ស​មឞើស​មា​មៃ ទឹង​មៃ​គឹត​លាស​គុ​លាហោក? គឹត​មៃ​គែស​ឆា​ព្លៃ​ឆី​អី​គ៝ប់​ឞ្វៃ​មោ​អ៝ន់​មៃ​ឆា​នើស​មោ?” ");
INSERT INTO cmok_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","អាដាម់ ​អើស៖ “ឞូ​អូរ​អី​មៃ​អ៝ន់​គុ​នទ្រែល​គ៝ប់​នើស ពាង់​អ៝ន់​ព្លៃ​អី​នៃ​មា​គ៝ប់ ជេសរី​គ៝ប់​ឆា​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ជេសរី​ឞ្រាស​យេហោវា ​លាស​ឞូ​អូរ​អី​នៃ៖ “ម៝ស​ជាន​អៃ​កើត​នទ្រី​រី?” ឞូ​អូរ​អី​នៃ​អើស៖ “ឞេស​ទែ​មរោស​ដាៈ​គ៝ប់​ឆា ទឹង​គ៝ប់​ឆា​ព្លៃ​ឆី​អី​នៃ​នើស កោរាញ​ឞ្រាស​មេ”។ ");
INSERT INTO cmok_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ឞ្រាស​យេហោវា ​លាស​ឞេស៖ “យ៝រ​មា​មៃ​ជាន​នអៃ ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អាបាៈ​អេង អី​តា​ឞ្រី​តា​ប៝ន ទូ​មល៝ម់​មៃ​អ្យា​គ៝ប់​រាតាប់​អ៝ន់​មៃ​ឞ្រោៈ​ហូង​មា​នទុល នទ្រែល​មា​ឆា​លែរ​នែស ទូ​ញជារ់​នាវ​រេស​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ជេសរី​គ៝ប់​អ៝ន់​គែស​នាវ​តឹម​លើស​មៃ ដាស​ឞូ​អូរ​អី​នៃ នទ្រែល​មា​រាន៝យ​ទែស​ឞូ​អូរ​អី​នៃ ដាស​មា​អី​ក៝ន​ឆៅ​មៃ​តៃ​ដ៝ង់ រាន៝យ​ទែស​ពាង់​តៃ​មរា​ជ៝ត​ឞោក​មៃ ជេសរី​មៃ​តៃ​មរា​ចោក​រាមាង់​អ្យារ់​រាន៝យ​ទែស​ពាង់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ជេសរី​ឞ្រាស​យេហោវា ​លាស​មា​ឞូ​អូរ​អី​នៃ​ដ៝ង់៖ “ទោល​អៃ​គុ​អ៝ស​គ៝ប់​អ៝ន់​អៃ​គែស​នាវ​ជេរ​ហោ​រាលាវ​ជឹត អៃ​គែស​នាវ​ជី​នទុល​ហោ​ងាន់​រ៝ នូយ្ស​នហ៝ម់​អៃ​មរា​អុច​ងាន់​ម៝ត់​ឞោក​ឆាយ​អៃ តីស​មា​ឆាយ​អៃ​ម៝ត់​ឞោក​អៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ជេសរី​ឞ្រាស​យេហោវា ​លាស​អាដាម់ ​ដ៝ង់៖ “គ៝ប់​រាតាប់​នែស​អ្យា មោ​អោស​អ៝ន់​គែស​ជេង យ៝រ​មា​មៃ​អ្យាត់​នាវ​អូរ​មៃ​ឆា​ព្លៃ​ឞើស​តើម​ឆី​អី​គ៝ប់​មោ​អ៝ន់​ឆា​នៃ​នើស នទ្រី​ទឹង​មៃ​ជ៝យ​នទើ​ឆោង​ឆា​ព៝ក់​នែស​រាអាស​រាគាញ់​អាប់​នារ​ទូ​ញជារ់​នាវ​រេស​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ជេសរី​មៃ​ឆោង​ឆា​នទើ​អី​ហ៝ន​លោស​តាៈ​ឞើស​ឞ្រី​ឞើស​មីរ យើន​មា​នែស​ហ៝ន​រេប​ហ៝ន​ល៝ក​ដ៝ង់ ");
INSERT INTO cmok_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","មៃ​ជាន​ការ​លោស​រាហាល​ពាល​មលៃ​ងាន់ រី​មើ​គែស​នទើ​ឆោង​ឆា​មា​ឆ្យាម់​ឆាក់​ត៝ត់​ខឹត​ងក្រែ​មា​លេក​តៃ​តា​នែស យ៝រ​លាស​គ៝ប់​ឆ៝ៈ​ម៝ន​មៃ​នើស​តាៈ​ឞើស​នែស​មោយ កើត​នទ្រី​មៃ​មរា​ជេង​តៃ​នែស​មោយ​កើត​អើម​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ជេសរី​អាដាម់ ​តេៈ​រាញា​អូរ​ពាង់​អី​នៃ​ក្វាល់​លាស​«អេវា » យ៝រ​លាស​ពាង់​នើស​អី​មេៈ​ទឹង​លែៈ​រាងោច​ឞូនុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ជេសរី​ឞ្រាស​យេហោវា ​ឆ៝ៈ​នតោ​មពោមពា​(ឆ្យុម)​ឆើម​ជាន​ឞ៝ក​អាវ​ឆើម​ញឆ៝ស​អ៝ន់​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ឞ្រាស​យេហោវា ​លាស​អេង​ពាង់នើម៖ “អាបៃ​រី​ឞូនុយ្ស​ជេង​តឹម​ឞាន​មា​ឞ៝ន់ លែៈ​គឹត​នាល់​នទើ​អ្វែស​នទើ​អ្យើស លាស​នទ្រី​គៃ​មា​លើយ​អ៝ន់​ខាន់​ពាង់​គែស​នាវ​រេស​នហ៝​រ៝ លើយ​អោស​អ៝ន់​ខាន់​ពាង់​ពែៈ​ឆា​តៃ​ព្លៃ​តើម​ឆី​អ៝ន់​នាវ​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","នទ្រី​ទឹង​ឞ្រាស​យេហោវា ​នត្រុត​មព្រើស​ខាន់​ពាង់​ទូ​លោស​ឞើស​មីរ​អេដែន ​នៃ អ៝ន់​ខាន់​ពាង់​គុ​នតុក​អេង ជាន​មីរ​ព៝ក់​នែស​អី​ឞ្រាស​យេហោវា ​ឆ៝ៈ​ម៝ន​ញជេង​ខាន់​ពាង់​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ជេស​នត្រុត​មព្រើស​ខាន់​ពាង់​ទូ​លោស​ឞើស​មីរ​អេដែន ​អី​នៃ ឞ្រាស​យេហោវា ​អ៝ន់​តោង​ពារ់​ចេរូបីន នទ្រែល​មា​ដាវ​អុញ​រាវាវ​ញជ្រាង់​ត្រ៝ង ក៝ប់​ឞើស​មពែស​លោស​នារ​មីរ​អេដែន ​នៃ គៃ​មា​លើយ​អោស​អ៝ន់​ឞូនុយ្ស​ព្លឹ​តៃ​តា​តើម​ឆី​អី​អ៝ន់​នាវ​រេស​នហ៝​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ជេសរី​អាដាម់ ​គុ​ដាស​អេវា ​អី​អូរ​ពាង់​រី អេវា ​នត្រែវ​គុ​អ៝ស​គែស​ក៝ន​ង្វាយ ជេសរី​អេវា ​លាស៖ “អ្យា​ឞ្រាស​យេហោវា ​អ៝ន់​គ៝ប់​គែស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ គ៝ប់​ឞែ​តេៈ​រាញា​ពាង់​«កាអីន »”។ ");
INSERT INTO cmok_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ជេសរី​ពាង់​គែស​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត ពាង់​តេៈ​រាញា​អាបែល ។ ត៝ត់​ខាន់​ពាង់​លែៈ​នទាម់ អី​អ៝ស​រី​ឞូនុយ្ស​ច្យាប់​ឞែ​ឞ្យាប់ អី​នោ​រី​ឞូនុយ្ស​ជាន​មីរ។ ");
INSERT INTO cmok_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","គែស​ទូ​នារ​អី​នោ​ឆ៝ៈ​បាៈ​នទើ​អី​គែស​តាៈ​ឞើស​មីរ​ពាង់​នើម​នៃ ជេសរី​ញអោត​ញហើរ​អ៝ន់​មា​ឞ្រាស​យេហោវា ។ ");
INSERT INTO cmok_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ល៝ង់​អី​អ៝ស​រី​ញហើរ​ដ៝ង់ ពាង់​ឆ៝ៈ​អី​ក៝ន​ទាក​ឞោក​តា​ផូង​មពោមពា​(ឆ្យុម)​អី​ព្រែ​ច្យាប់​នៃ​បាៈ នទ្រែល​មា​អី​ងី​តា​ឆាក់ ជេសរី​ពាង់​ញហើរ​អ៝ន់​មា​ឞ្រាស​យេហោវា ។ នោក​ពាង់​ញហើរ​នៃ ឞ្រាស​យេហោវា ​រាម់​ងាន់​មា​ពាង់ នទ្រែល​មា​នទើ​ញហើរ​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","តីស​មា​កាអីន ​អី​នោ​ពាង់​រី ឞ្រាស​យេហោវា ​មោ​រាម់​អោស នទ្រែល​មា​នទើ​ញហើរ​ពាង់។ នទ្រី​ទឹង​កាអីន ​នូយ្ស​ហោ​ងាន់ មុស​មាត់​ពាង់​ចាង់​រាហ៝ញ់។ ");
INSERT INTO cmok_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ឞ្រាស​យេហោវា ​លាស​មា​ពាង់៖ “ហើយ​កាអីន  ម៝ស​នូយ្ស​មៃ​អី​នៃ? ម៝ស​ជាន​មុស​មាត់​មៃ​ចាង់​រាហ៝ញ់​នៃ​មេស? ");
INSERT INTO cmok_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","លាស​មៃ​ជាន​អ្វែស គែស​នាវ​រាម់​ងាន់ លាស​មៃ​មោ​អោស​ជាន​អ្វែស ជាន​ងខើង​នទើ​អ្យើស​ច្រាវ នាវ​អ្យើស​អី​នៃ​ពាង់​គុ​ក៝ប់​តា​ឞោក​មពោង​មៃ​នៃ តឹម​ឞាន​មា​យៅ​គុ​ញឆាន​ក៝ប់​ឆា​ហេក​ទូ​មល៝ម់​មពោមពា​(ឆ្យុម)។ នទើ​អ្យើស​អុច​ជាន​កោរាញ​ក៝ប់​ដាៈ​មៃ​ជាន​អ្យើស លាស​នទ្រី​អ៝ន់​មៃ​ទើយ​ដាស​នាវ​អ្យើស​អី​នៃ​ហ៝ម់”។ ");
INSERT INTO cmok_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","កាស​ទូ​នារ​នៃ កាអីន ​ជាៈ​អី​អ៝ស​ពាង់​នៃ​ហាន់​លោស​អា​មីរ។ ត៝ត់​តា​មីរ​រី កាអីន ​រាទោស​ងខឹត​លើយ​អ៝ស​ពាង់​នៃ​ត៝ត់​ខឹត​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ជេសរី​ឞ្រាស​យេហោវា ​អោប៖ “ហើយ​កាអីន  អាស​អ៝ស​មៃ​នៃ​មេស?” កាអីន ​អើស៖ “គឹត​អែស គ៝ប់​មោ​គឹត​អោស​កោរាញ​ឞ្រាស​មេ គ៝ប់​គឹត​មា​ឞូនុយ្ស​ម៝ត់​ពាង់​លាស?” ");
INSERT INTO cmok_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ជេសរី​ឞ្រាស​យេហោវា ​លាស៖ “ម៝ស​ឆី​កោៈ​មៃ​ជាន​កើត​នៃ​មេស? យ៝រ​លាស​មហាម​អ៝ស​មៃ​អី​មៃ​ងខឹត​នើស​ហ៝ច​តា​នែស មហាម​អី​នៃ​តឹម​ឞាន​មា​នតែរ​ក្វាល់​ដាៈ​គ៝ប់​កោស​មៃ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","អាបៃ​រី​គ៝ប់​រាតាប់​មៃ នត្រុត​មៃ​ទូ​លោស​ងាយ​តាៈ​ឞើស​នតុក​នែស​អ្យា​ងាន់​រ៝ ឞើស​នតុក​នែស​អី​មហាម​អ៝ស​មៃ​ហ៝ច​អ្យា​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","មៃ​តៃ​លើស​មីរ​ជាន​ឆ្រែ មោ​អោស​គែស​មោ​អោស​ជេង​មា​មៃ​ដ៝ង់ មៃ​គុ​រេស​ងគ្លាៈ​ងគ្លើត​លាម​នតុក​អ្យា​នតុក​រី”។ ");
INSERT INTO cmok_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","កាអីន ​អើស៖ “អើ​កោរាញ​ឞ្រាស ទោយ្ស​មៃ​តេៈ​មា​គ៝ប់​អ្យា​ជ៝ក់​ងាន់ កោរាញ​ឞ្រាស​មេ គ៝ប់​មោ​អោស​ទើយ​ទោរ។ ");
INSERT INTO cmok_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ល៝ង់​នារ​អ្យា​មៃ​នត្រុត​គ៝ប់​ទូ​ឞើស​នតុក​នែស​អ្យា ទូ​ងាយ​ឞើស​មាត់​មៃ​ដ៝ង់ គ៝ប់​គុ​រេស​ងគ្លាៈ​ងគ្លើត​លាម​នតុក​អ្យា​នតុក​រី លាស​គែស​ឞូ​ម៝ប់ ឞូ​មរា​ងខឹត​គ៝ប់​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ឞ្រាស​យេហោវា ​អើស៖ “មោ​អោស លាស​ឞូ​ងខឹត​មៃ គ៝ប់​មរា​ព្លើង​ពាង់​ពើស​តឹ”។ ជេសរី​ឞ្រាស​យេហោវា ​ព្លា​កែប​ទូ​មល៝ម់​នទើ​តា​កាលើ​កាអីន ​នៃ គៃ​មា​លើយ​អោស​អ៝ន់​ឞូ​លើស​ងខឹត​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ជេសរី​កាអីន ​ទូ​លោស​ឞើស​នៃ ពាង់​ទូ​ឞើស​មាត់​ឞ្រាស​យេហោវា ​ងាន់ គុ​តា​នតុក​ឞ្រី​នោត ​មពែស​លោស​នារ​មា​នតុក​អេដែន  នទ្រី​ពាង់​កាអីន ​អី​រី​ហែស។ ");
INSERT INTO cmok_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ជេសរី​កាអីន ​គុ​ដាស​អី​អូរ​ពាង់​រី អូរ​ពាង់​នត្រែវ​គុ​អ៝ស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ រាញា​ហេនុក ។ ជេសរី​ពាង់​ជាន​ទូ​មល៝ម់​ប៝ន ពាង់​ក្វាល់​ប៝ន​អី​នៃ​ហេនុក ​កើត​រាញា​ក៝ន​ពាង់​នើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ជេសរី​ហេនុក ​គែស​ក៝ន​ឞូ​ក្លោ​រាញា​អីរាត អីរាត​ឞាៈ​មហូយាអែល មហូយាអែល ​ឞាៈ​មាតូឆាអែល មាតូឆាអែល ​ឞាៈ​លាមេក ។ ");
INSERT INTO cmok_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","លាមេក ​គែស​អូរ​ឞារ អូរ​តើម​រាញា​អាដា  អូរ​ចោង​រាញា​ឆីលា ។ ");
INSERT INTO cmok_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","អាដា ​គែស​ឞារ​អឹ​ក៝ន អី​នោ​រាញា​យាបាល  ពាង់​អី​ឞូនុយ្ស​ទាក​ឞោក​គុ​តា​ចូន គុ​ច្យាប់​តា​នតុក​អ្យា​នតុក​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","អី​អ៝ស​យាបាល  រាញា​យូបាល  ពាង់​អី​ឞូនុយ្ស​ទាក​ឞោក​ងក្រេស​នទើ​តឹម​ឞាន​មា​គ៝ង​រេង នទ្រែល​មា​អោស​នទើ​តឹម​ឞាន​មា​រាលែត។ ");
INSERT INTO cmok_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ជេសរី​ឆីលា ​គែស​ក៝ន​ដ៝ង់ រាញា​តូបាល-កាអីន  ពាង់​អី​ឞូនុយ្ស​ទាក​ឞោក​ឞ្លាវ​ទ្រែប​ច្យារ់​កោង នទ្រែល​មា​ល៝យ្ស។ អ៝ស​ឞូ​អូរ​តូបាល-កាអីន  រាញា​នាអាមា ។ ");
INSERT INTO cmok_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ជេសរី​លាមេក ​លាស​មា​លែៈ​ឞារ​ហៃ​អី​អូរ​ពាង់​នៃ៖ “ហើយ​អាដាឆីលា  ខាន់​អៃ​អ្យាត់​នាវ​គ៝ប់​ហ៝ៈ! ហើយ​ខាន់​អៃ រាកេង​ហ៝ម់​តោរ​អ្យាត់​នាវ​គ៝ប់​ងើយ​មឞ្រាម​មា​គឹត! គ៝ប់​ងខឹត​ឞូនុយ្ស​ទូ​ហ្វេ​ឞូ​ក្លោ យ៝រ​លាស​ពាង់​នើស​ជាន​អ៝ន់​គ៝ប់​គែស​ឆោត គ៝ប់​ងខឹត​ទូ​ហ្វេ​ឞូ​នទាម់ យ៝រ​មា​ពាង់​លើស​គ៝ប់​ឞុរ។ ");
INSERT INTO cmok_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","លាស​ឞូ​ងខឹត​ទូ​ហ្វេ​កាអីន  ឞូ​មរា​ព្លើង​ងខឹត​ពើស​តឹ យើន​មា​លាស​ឞូ​ងខឹត​លាមេក  អ៝ន់​ព្លើង​ងខឹត​ត៝ត់ ៧៧ តឹ​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","អាដាម់ ​ហោម​គុ​ដាស​អូរ​ពាង់​ជឹត ជេសរី​អូរ​ពាង់​គុ​អ៝ស​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ ពាង់​លាស៖ “ក៝ន​អ្យា​កោរាញ​ឞ្រាស​អ៝ន់​តៃ​មា​គ៝ប់ គៃ​មា​នត្រ៝ៈ​អាបែល ​អី​កាអីន ​ទែ​ងខឹត​នើស” កើត​នទ្រី​រាញា​ពាង់​«ឆេត »។ ");
INSERT INTO cmok_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ជេសរី​ឆេត ​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ ពាង់​រាញា​ក៝ន​អី​នៃ​អេនោស ។ នតើម​ឞើស​នៃ​ឞូ​ក្វាល់​កោរាញ​ឞ្រាស៖ «ឞ្រាស​យេហោវា » នោក​ឞូ​យើក​មឞាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","អ្យា​នាវ​មឞើស​ងក៝ច​រាន៝យ​ទែស​អាដាម់ ។ នោក​កោរាញ​ឞ្រាស​ញជេង​ឞូនុយ្ស​នើស កោរាញ​ឞ្រាស​ញជេង​ខាន់​ពាង់​កើត​ពាង់នើម​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","កោរាញ​ឞ្រាស​ញជេង​ខាន់​ពាង់​គែស​ឞូ​ក្លោ​ឞូ​អូរ តា​នារ​នៃ​កោរាញ​ឞ្រាស​តេៈ​រាញា​ខាន់​ពាង់​«ឞូនុយ្ស» ជេសរី​អ៝ន់​នាវ​គែស​ជេង​មា​ខាន់​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ត៝ត់​អាដាម់ ​គែស ១៣០ នាម់ ពាង់​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​តឹម​ឞាន​មា​ពាង់​នើម​កើត​ពាង់​នើម​ងាន់ ជេសរី​អាដាម់ ​តេៈ​រាញា​ពាង់​«ឆេត »។ ");
INSERT INTO cmok_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ជេស​ពាង់​ឞាៈ​ឆេត ​នៃ ឞើស​កើយ​នៃ​ពាង់​ហោម​រេស​គែស ៨០០ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ពាង់​រេស​ទឹង​លែៈ​គែស ៩៣០ នាម់ ជេសរី​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ត៝ត់​ឆេត ​គែស ១០៥ នាម់ ពាង់​ឞាៈ​អេនោស ។ ");
INSERT INTO cmok_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ជេស​ពាង់​ឞាៈ​អេនោស ​អី​នៃ ពាង់​រេស​គែស ៨០៧ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ពាង់​រេស​ទឹង​លែៈ​គែស ៩១២ នាម់ ជេសរី​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ត៝ត់​អេនោស ​គែស ៩០ នាម់ ពាង់​ឞាៈ​ខេនាន ។ ");
INSERT INTO cmok_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ជេស​ពាង់​ឞាៈ​ខេនាន ​អី​នៃ ពាង់​រេស​គែស ៨១៥ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ពាង់​រេស​ទឹង​លែៈ​គែស ៩០៥ នាម់ ជេសរី​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ត៝ត់​ខេនាន ​គែស ៧០ នាម់ ពាង់​ឞាៈ​មហាលេលអែល ។ ");
INSERT INTO cmok_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ជេស​ពាង់​ឞាៈ​មហាលេលអែល ​អី​នៃ ពាង់​រេស​គែស ៨៤០ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ពាង់​រេស​ទឹង​លែៈ​គែស ៩១០ នាម់ ជេសរី​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ត៝ត់​មហាលេលអែល ​គែស ៦៥ នាម់ ពាង់​ឞាៈ​យារេត ។ ");
INSERT INTO cmok_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ជេស​ពាង់​ឞាៈ​យារេត ​អី​នៃ ពាង់​រេស​គែស ៨៣០ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ពាង់​រេស​ទឹង​លែៈ​គែស ៨៩៥ នាម់ ជេសរី​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ត៝ត់​យារេត ​គែស ១៦២ នាម់ ពាង់​ឞាៈ​ហេនុក ។ ");
INSERT INTO cmok_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ជេស​ពាង់​ឞាៈ​ហេនុក ​អី​នៃ ពាង់​រេស​គែស ៨០០ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ពាង់​រេស​ទឹង​លែៈ​គែស ៩៦២ នាម់ ជេសរី​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ត៝ត់​ហេនុក ​គែស ៦៥ នាម់ ពាង់​ឞាៈ​មឹថូឆាលាស ។ ");
INSERT INTO cmok_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ជេស​ពាង់​ឞាៈ​មឹថូឆាលាស ​អី​នៃ ពាង់​គុ​តឹម​ទេស​តឹម​ទាច់​ដាស​កោរាញ​ឞ្រាស នទ្រែល​មា​អ្យាត់​នាវ​ពាង់​ដ៝ង់​គែស ៣០០ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ពាង់​រេស​ទឹង​លែៈ​គែស ៣៦៥ នាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ហេនុក ​គុ​តឹម​ទេស​តឹម​ទាច់​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ងាន់ ជេសរី​ពាង់​រ៝ស​ក្ល៝ក់​ឞើស​នែស​នតូ​អ្យា យ៝រ​លាស​កោរាញ​ឞ្រាស​ឆ៝ៈ​គុ​នទ្រែល​ពាង់នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ត៝ត់​មឹថូឆាលាស ​គែស ១៨៧ នាម់ ពាង់​ឞាៈ​លាមេក ។ ");
INSERT INTO cmok_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ជេស​ពាង់​ឞាៈ​លាមេក ​អី​នៃ ពាង់​រេស​គែស ៧៨២ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ពាង់​រេស​ទឹង​លែៈ​គែស ៩៦៩ នាម់ ជេសរី​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ត៝ត់​លាមេក ​គែស ១៨២ នាម់ ពាង់​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ ");
INSERT INTO cmok_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ពាង់​តេៈ​រាញា​ក៝ន​អី​នៃ​«នោអេ » ពាង់​លាស៖ “ក៝ន​អ្យា​ពាង់​មរា​កើល​ឞ៝ញ​លែង​លែៈ​នាវ​ការ​ជេរ​ហេន លែៈ​នាវ​រាអាស​ហេន​ជាន​មីរ តាៈ​ឞើស​ឞ្រាស​យេហោវា ​ទែ​រាតាប់​នែស​អី​អ្យា​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ជេស​ពាង់​ឞាៈ​នោអេ ​អី​នៃ ពាង់​រេស​គែស ៥៩៥ នាម់​ជឹត នហ៝​ពាង់​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ពាង់​រេស​ទឹង​លែៈ​គែស ៧៧៧ នាម់ ជេសរី​ពាង់​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ត៝ត់​នោអេ ​គែស ៥០០ នាម់ ពាង់​ឞាៈ​ក៝ន​ពែ​អឹ ឆិម ហាម់  នទ្រែល​មា​យាផែត ។ ");
INSERT INTO cmok_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ជេសរី​ឞូនុយ្ស​តា​នែស​នតូ​លើ​មា​អ៝ក់​លើ​មា​អ៝ក់​ងាន់ ខាន់​ពាង់​ឞាៈ​ក៝ន​ឞូ​អូរ ");
INSERT INTO cmok_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ជេសរី​ក៝ន​ឞូ​ក្លោ​ឞ្រាស​ឆៃ​ក៝ន​ឞូ​អូរ​ឞូនុយ្ស​អ្វែសៗ​ងាន់ ខាន់​ពាង់​លែវ​ឞាល់​ឆ៝ៈ​អូរ ឆ៝ៈ​ឞូ​មា​ហែ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ជេស​ឞ្រាស​យេហោវា ​ឆៃ​ខាន់​ពាង់​ជាន​កើត​នៃ ជេសរី​ពាង់​ងើយ​អេង​ឆាក់​ពាង់​នើម៖ “ហ្វេង​គ៝ប់​មោ​ហោម​អោស​គុ​នហ៝​រ៝​តា​ឞូនុយ្ស យ៝រ​លាស​ឆាក់​ខាន់​ពាង់​នើស​មរា​ខឹត កើត​នៃ​ទឹង​គ៝ប់​អ៝ន់​ខាន់​ពាង់​រេស​ទុត​តា ១២០ នាម់​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","តា​នោក​នៃ​នើស គែស​ឞូនុយ្ស​ឆាក់​ជាន់​ក្វ៝ង់ៗ​ងាន់​តា​នែស​នតូ​អ្យា ត៝ត់​អា​កើយ​នៃ​ហោម​អែ​គែស​ដ៝ង់។ ខាន់​ពាង់​អី​នៃ​អី​ក៝ន​តាៈ​ឞើស​ក៝ន​ឞ្រាស​ឆ៝ៈ​អូរ​ឆាយ​ដាស​ឞូ​អូរ​ឞូនុយ្ស​នើស ខាន់​ពាង់​នើស​ទាង់ៗ​ងាន់​តឹម​លើស កើត​នទ្រី​ទឹង​គែស​រានោក​កាល់​អែ​នើស​ឞូ​លឺ​ខាន់​ពាង់​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ជេសរី​ឞ្រាស​យេហោវា ​ឆៃ​នាវ​តីស​ឞូនុយ្ស​ជាន​តា​នែស​នតូ​អ្យា​ហោ​ងាន់ នូយ្ស​នហ៝ម់​នាវ​មឹន​ខាន់​ពាង់​នើស​អុច​ជាន​នទើ​ទុត​អ្យើស​នឹង​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ឞ្រាស​យេហោវា ​រាង៝ត​ងាន់​តា​នូយ្ស​នហ៝ម់ ពាង់​នទុយ្ស​តោរ​លាន់​ញជេង​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ពាង់​លាស​អេង​ឆាក់​ពាង់នើម៖ “គ៝ប់​មរា​លើស​ហេង​លើយ​ឞូនុយ្ស​អី​គ៝ប់​ញជេង​អ៝ន់​លែៈ​ឞើស​នែស​នតូ​អ្យា​ប៝ត់ នតើម​ឞើស​ឞូនុយ្ស​ត៝ត់​មា​មពោមពា​(ឆ្យុម)​តា​ឞ្រី​តា​ប៝ន ឆ្យុម​មពារ់​តា​កាលើ​ត្រោក នទ្រែល​មា​អាប់​នតីល​មពោមពា​(ឆ្យុម)​ហូង​វើរ​តា​នែស​នតូ​អ្យា យ៝រ​លាស​គ៝ប់​ញហ្វាច​លាន់​ញជេង​ពាង់​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","យើន​មា​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​រាញា​ពាង់​នោអេ ឞ្រាស​យេហោវា ​ទី​នូយ្ស​នហ៝ម់​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","អ្យា​ងក៝ច​នាវ​រេស​ជេង​នោអេ ។ តា​រានោក​នោអេ ​នៃ​នើស គែស​ទូ​ហ្វេ​ពាង់​ទើម​ឞូនុយ្ស​អ្វែស​ឞូនុយ្ស​ឆ៝ង់ មោ​អោស​ឆៃ​គែស​ទោយ្ស​តា​ពាង់។ ពាង់​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","នោអេ ​ឞាៈ​ក៝ន​ឞូ​ក្លោ​ពែ​អឹ រាញា​ខាន់​ពាង់​ឆិម ហាម់  នទ្រែល​មា​យាផែត ។ ");
INSERT INTO cmok_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","នោក​នៃ​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា​អ្យើស​មហឹក​ទាទេ​ងាន់​តា​នាប់​មាត់​កោរាញ​ឞ្រាស ខាន់​ពាង់​ជាន​អ្យើស​អ៝ក់​នតីល​ងាន់ ហាត់​ជាញ​តឹម​លើស​តឹម​ងខឹត​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","កោរាញ​ឞ្រាស​ឆៃ​នែស​នតូ​អ្យើស​លែៈ​ផ្យៅ យ៝រ​លាស​ឞូនុយ្ស​ទឹង​លែៈ​តា​នែស​នតូ​អ្យា​នើស ខាន់​ពាង់​ជាន​អ្យើស​មហឹក​ទាទេ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ជេសរី​កោរាញ​ឞ្រាស​លាស​មា​នោអេ ៖ “ហើយ​នោអេ គ៝ប់​លែៈ​អុច​ងខឹត​លើយ​ទឹង​លែៈ​នទើ​អី​គែស​នាវ​រេស​តា​នែស​នតូ​អ្យា​មេៈ យ៝រ​លាស​ឞូនុយ្ស​លាម​នែស​នតូ​អ្យា ខាន់​ពាង់​ជាន​អ្យើស​អ៝ក់​នតីល​ងាន់ ហាត់​ជាញ​តឹម​លើស​តឹម​ងខឹត​ហោ​ងាន់។ អោ គ៝ប់​មរា​លើស​លើយ​ខាន់​ពាង់​អ៝ន់​ហេង​លែៈ​ផ្យៅ នទ្រែល​មា​លែៈ​នទើ​តា​នែស​នតូ​អ្យា​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“អាបៃ​រី​គ៝ប់​ដាៈ​មៃ​ជាន​ទូ​មល៝ម់​ទូក​អ៝ន់​ទុត​ក្វ៝ង់ ជាន​មា​តើម​ឆី​អី​អ្វែស ជេសរី​ឆ៝ៈ​នតាក់​ចាយ​លឹរ​ឞើស​ទីស​ឞើស​ត្រោម​ទូក​អី​នៃ​អ៝ន់​ជឹរ នទ្រែល​មា​ជាន​ជ្រោ​អ៝ន់​អ៝ក់​តា​ត្រោម​ទូក​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","អ៝ន់​មៃ​ជាន​កើត​នអា៖ ជ៝ង​អ៝ន់​គែស ៣០០ ហាត់ ហ្វី ៥០ ហាត់ អី​ព្រេស ៣០ ហាត់។ ");
INSERT INTO cmok_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ជេសរី​ជាន​ច៝រ​ឞើស​លើ​ទូក​នៃ ព្រេស​ទូ​ហាត់។ រ៝ង​ជាន​មពោង​អ៝ន់​ឞើស​មពុង ជេសរី​ជាន​ទូក​អី​នៃ​អ៝ន់​គែស​តឹម​រាទាប់ ទូ​ទាប់​ឞើស​ទ៝ង់ ទូ​ទាប់​តា​ងក្លាង ទូ​ទាប់​ឞើស​លើ។ ");
INSERT INTO cmok_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ជេសរី​គ៝ប់​មរា​អ៝ន់​គែស​ទាក​លេង​ទាក​ទើង​លាម​នែស​នតូ​អ្យា អ៝ន់​ទាក​ឞុក​លែៈ​រាងោច​នទើ​អី​គែស​នាវ​រេស​អី​គែស​នហ៝ម់​តា​ឞើស​ទ៝ង់​ត្រោក​អ្យា។ លែៈ​នទើ​គែស​តា​នែស​នតូ​អ្យា​មរា​ខឹត​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","យើន​មា​គ៝ប់​ហោម​តឹម​រាង្លាប់​មា​មៃ​នានាវ មៃ​មរា​លាប់​តា​ត្រោម​ទូក​នៃ នទ្រែល​អូរ​មៃ​ក៝ន​មៃ​មាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ជេសរី​អ៝ន់​មៃ​ឆ៝ៈ​លែវ​មពោមពា​(ឆ្យុម)​ឞារៗ​ទឹង​លែៈ​នតីល​មពោមពា​(ឆ្យុម) អ៝ន់​មៃ​ឆ៝ៈ​មែ​ង្វាយ​ងក្វ៝ង់​ង្វាយ​អ៝ន់​លាប់​តា​ត្រោម​ទូក​នៃ​ទាទេ គៃ​មា​គែស​ក្លាយ្ស​នាវ​រេស​នទ្រែល​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ពាង់​មរា​រាន​វាច់​តា​មៃ​ឞារៗ​រ៝ ទឹង​លែៈ​នតីល​មពោមពា​(ឆ្យុម)​តឹង​នតីល​អេងៗ ឆ្យុម​មពារ់​តា​កាលើ​ត្រោក មពោមពា​(ឆ្យុម)​តា​ឞ្រី​តា​ប៝ន នទ្រែល​មា​អាប់​នតីល​មពោមពា​(ឆ្យុម)​ហូង​វើរ​តា​នែស​នតូ​អ្យា គៃ​មា​គែស​ក្លាយ្ស​នាវ​រេស។ ");
INSERT INTO cmok_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ជេសរី​ឆ៝ៈ​ញអោត​លែៈ​នទើ​អី​មៃ​វៃ​ឆោង​ឆា​ព្រាប់​អ៝ន់​មា​មៃ​នើម នទ្រែល​មា​មពា មា​អ៝ន់​មពោមពា​(ឆ្យុម)​ទឹង​លែៈ​អី​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","នោអេ ​ជាន​កើត​នៃ​ងាន់​រ៝ ពាង់​ជាន​ជេស​លែៈ​ផ្យៅ​តឹង​នាវ​កោរាញ​ឞ្រាស​ដាៈ​មា​ពាង់​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ជេសរី​ឞ្រាស​យេហោវា ​លាស​មា​នោអេ ៖ “ហើយ​នោអេ  លែវ​រានាក់​វ៝ល់​មៃ លាប់​គុ​តា​ត្រោម​ទូក​ក្វ៝ង់​អី​នៃ​នទ្រែល​មៃ​នើម យ៝រ​លាស​ទឹង​លែៈ​រាងោច​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា គ៝ប់​ឆៃ​ទូ​ហ្វេ​មៃ​ទើម​ឞូនុយ្ស​អ្វែស​ឞូនុយ្ស​ឆ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ជេសរី​អ៝ន់​មៃ​ឆ៝ៈ​លែវ​មពោមពា​(ឆ្យុម)​អី​កើប​ក្ល៝ស​ជេង​មពោមពា​(ឆ្យុម)​អី​ខាន់​មៃ​ទើយ​ញហើរ​មា​គ៝ប់ មែ​ពើស​អឹ​ងក្វ៝ង់​ពើស​អឹ មពោមពា​(ឆ្យុម)​អី​កើប​មោ​ក្ល៝ស​មៃ​ឆ៝ៈ​លែវ​មែ​ង្វាយ​ងក្វ៝ង់​ង្វាយ​ហ៝ៈ ");
INSERT INTO cmok_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","មៃ​លែវ​ដ៝ង់​ឆ្យុម​មពារ់​កាលើ​ត្រោក​មែ​ពើស​អឹ​ងក្វ៝ង់​ពើស​អឹ ទឹង​លែៈ​អាប់​នតីល​អី​នៃ គៃ​មា​រ៝ង​នតីល​តា​នែស​នតូ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","យ៝រ​លាស​ហោម​ពើស​នារ​ជឹត​គ៝ប់​អ៝ន់​គែស​មីស​តា​នែស​នតូ​អ្យា​ព្វាន់​ជឹត​នាង់​ព្វាន់​ជឹត​នារ គៃ​មា​លើស​ហេង​លើយ​អ៝ន់​លែៈ​រាងោច​នទើ​អី​គែស​នាវ​រេស​អី​គ៝ប់​លែៈ​ញជេង អ៝ន់​លែៈ​ឞើស​នែស​នតូ​អ្យា​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","នោអេ ​ជាន​ជេស​លែៈ​ផ្យៅ​តឹង​នាវ​ឞ្រាស​យេហោវា ​ដាៈ​មា​ពាង់​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","នោក​គែស​ទាក​លេង​ទាក​ទើង​អី​នៃ​តា​នែស​នតូ នោអេ ​លែៈ​គែស ៦០០ នាម់​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ពាង់​លាប់​គុ​តា​ត្រោម​ទូក​ក្វ៝ង់​អី​រី អូរ​ពាង់ ក៝ន​ពាង់ នទ្រែល​មា​មាន់​ពាង់​ដ៝ង់ គៃ​មា​ក្លាយ្ស​ឞើស​ទាក​លេង​ទាក​ទើង​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","គែស​មពោមពា​(ឆ្យុម)​អី​កើប​ក្ល៝ស មពោមពា​(ឆ្យុម)​អី​កើប​មោ​ក្ល៝ស ឆ្យុម​មពារ់​កាលើ​ត្រោក នទ្រែល​មា​អាប់​នតីល​មពោមពា​(ឆ្យុម)​អី​ហូង​វើរ​តា​នែស​នតូ​អ្យា​ដ៝ង់ ");
INSERT INTO cmok_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ឞ្រោៈ​មា​ឞារ​មា​ឞារ​ងាន់​រ៝​ឞើស​រី​ត៝ត់​តា​នតុក​នោអេ ​នៃ គែស​មែ​គែស​ងក្វ៝ង់​លាប់​តា​ត្រោម​ទូក​រី តឹង​កើត​នាវ​កោរាញ​ឞ្រាស​ដាៈ​មា​ពាង់​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ត៝ត់​ពើស​នារ​ឞើស​កើយ​នៃ ទាក​លេង​ទាក​ទើង​នតើម​រាលាប​លាម​នែស​នតូ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","តា​នាម់​នោអេ ​អី​គែស ៦០០ នាម់ ខៃ​ឞារ​នារ ១៧ តា​នារ​អី​នៃ​រ៝​ទឹង​លែៈ​តូ​ទាក​នតើម​លោស​រាទោល​តាៈ​ឞើស​ទ៝ង់​រី​ទាទេ ជេសរី​តា​កាលើ​ត្រោក​គែស​មីស​នត៝ង់​ងាន់ តឹម​ឞាន​មា​ពើក​មពោង​ឞ្ល៝ស។ ");
INSERT INTO cmok_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","មីស​ងខុត​តា​នែស​នតូ​អ្យា ៤០ នាង់ ៤០ នារ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","នារ​អី​នៃ​ដ៝ង់​នោអេ  នទ្រែល​មា​ក៝ន​ឞូ​ក្លោ​ពាង់ ឆិមហាម់យាផែត  អូរ​ពាង់ ជេសរី​មាន់​ពាង់​ពែ​នុយ្ស​លាប់​គុ​តា​ត្រោម​ទូក​រី​ទាទេ ");
INSERT INTO cmok_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","នទ្រែល​មា​លែៈ​អាប់​នតីល​មពោមពា​(ឆ្យុម)​តា​ឞ្រី​តា​ប៝ន មពោមពា​(ឆ្យុម)​ហូង​វើរ​តា​នែស​នតូ​អ្យា ឆ្យុម​មពារ់​តា​កាលើ​ត្រោក លែៈ​នទើ​អី​គែស​នារ លាប់​ទាទេ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ទឹង​លែៈ​នទើ​អី​គែស​នាវ​រេស​នៃ​នើស​ពាង់​ឞ្រោៈ​ឞើស​រី​មា​ឞារ​មា​ឞារ​រ៝ គុ​នទ្រែល​នោអេ ​តា​ត្រោម​ទូក​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","អាប់​នតីល​នទើ​អី​គែស​នាវ​រេស គែស​មែ គែស​ងក្វ៝ង់ ពាង់​លាប់​គុ​តា​ត្រោម​ទូក​រី​ទាទេ តឹង​កើត​នាវ​កោរាញ​ឞ្រាស​ដាៈ​មា​នោអេ ​នើស ជេសរី​ឞ្រាស​យេហោវា ​នើម​នតឹល​មពោង​ទូក​អី​នៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ជេសរី​មីស​គែស ៤០ នាង់ ៤០ នារ។ ទាក​លេង​ទាក​ទើង​រាលាប​លាម​នែស​នតូ​អ្យា​ហាវ​តេស​ងាន់ ត៝ត់​មា​ទូក​អី​នៃ​នហោង​មពឺប​ឞើស​លើ​នែស​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ទាក​លេង​ទាក​ទើង​អី​រី​លើ​មា​ហាវ​តេស​លើ​មា​ក្វ៝ង់​លើ​មា​ជ្រូ​ងាន់ ទូក​អី​រី​នហោង​ឞើស​លើ​ទាក​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ហាវ​តេស​ទាក​លើ​មា​ក្វ៝ង់​លើ​មា​ក្វ៝ង់​តា​កាលើ​នែស​នតូ​អ្យា ត៝ត់​មា​ឞុក​នទ៝ប់​លែៈ​ផ្យៅ​យោក​អី​ព្រេសៗ​ទឹង​លែៈ​ឞើស​ទ៝ង់​ត្រោក​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ទាក​ហាវ​តេស​ត៝ត់​មា​ឞាម់​រាលាវ​ឞើស​លើ​យោក​អី​នៃ ១៥ ហាត់​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ជេសរី​លែៈ​រាងោច​នទើ​អី​គែស​នាវ​រេស​តា​នែស​នតូ​អ្យា ទឹង​ឆ្យុម​មពារ់​កាលើ​ត្រោក ទឹង​មពោមពា​(ឆ្យុម)​តា​ប៝ន​តា​ឞ្រី លែៈ​រាងោច​មពោមពា​(ឆ្យុម)​ហូង​វើរ​លាម​នែស​នតូ​អ្យា នទ្រែល​មា​លែៈ​រាងោច​ឞូនុយ្ស​ខឹត​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","លែៈ​នទើ​អី​ឞ្លាវ​នហាវ​នហ៝ម់ អី​គុ​រេស​តា​កាលើ​នែស​នតូ​អ្យា​ខឹត​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ឞ្រាស​យេហោវា ​លើស​ហេង​លើយ​លែៈ​នទើ​អី​គែស​នាវ​រេស​ឞើស​នែស​នតូ​អ្យា នតើម​ឞើស​ឞូនុយ្ស​ត៝ត់​មា​មពោមពា​(ឆ្យុម)​តា​ឞ្រី​តា​ប៝ន មពោមពា​(ឆ្យុម)​ហូង​វើរ ត៝ត់​មា​ឆ្យុម​មពារ់​កាលើ​ត្រោក​អ៝ន់​រ៝ស​លែៈ​ផ្យៅ ហោម​អែ​នោអេ  នទ្រែល​មា​ឞូ​ម៝ស​អី​គុ​តា​ត្រោម​ទូក​នទ្រែល​ពាង់ ទាស​រី​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ជេសរី​ទាក​លេង​ទាក​ទើង​ក្វ៝ង់​តា​នែស​នតូ​អ្យា​គែស ១៥០ នារ។ ");
INSERT INTO cmok_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ជេសរី​កោរាញ​ឞ្រាស​ហោម​កាស​គឹត​មា​នោអេ  នទ្រែល​មា​លែៈ​មពោមពា​(ឆ្យុម)​អី​គុ​តា​ត្រោម​ទូក​នទ្រែល​ពាង់​នៃ កើត​នទ្រី​កោរាញ​ឞ្រាស​អ៝ន់​គែស​ឆ្យាល​ខោម​តា​នែស​នតូ​អ្យា ជេសរី​ទាក​នតើម​អ្យ៝ស​អ្យហុប។ ");
INSERT INTO cmok_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ទឹង​លែៈ​តូ​ទាក​អី​លោស​រាទោល​តាៈ​ឞើស​នតុក​ជ្រូ​រី នទ្រែល​មា​អី​កើត​មពោង​ឞ្ល៝ស​កាលើ​ត្រោក​រាទ៝ល់​អ៝ន់​ជឹរ មីស​ឞាស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ទាក​តា​នែស​នតូ​អ្យា​នតើម​អ្យ៝ស​ទូ​តឹ​ដេៈ​ទូ​តឹ​ដេៈ ត៝ត់ ១៥០ នារ​ពាង់​នតើម​អ្យ៝ស។ ");
INSERT INTO cmok_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","តា​នារ ១៧ ខៃ​ពើស​ទូក​អី​នៃ​ខាន​តា​កាលើ​យោក​អារារាត ។ ");
INSERT INTO cmok_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ទាក​ហោម​អ្យ៝ស​ដេៈ​អ្យ៝ស​ដេៈ​ត៝ត់​ខៃ​ជឹត តា​នារ​ង្វាយ​ខៃ​ជឹត​អី​នៃ នារ​នៃ​នោអេ ​នតើម​មពើល​ឆៃ​យោក។ ");
INSERT INTO cmok_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ជ៝ៈ ៤០ នារ​ឞើស​កើយ​នៃ នោអេ ​ពឹ​មពោង​ឞ្ល៝ស​ទូក​អី​ពាង់​ជាន​នើស ");
INSERT INTO cmok_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","បើក​ទូ​មល៝ម់​នអាក។ នអាក​អី​នៃ​មពារ់​នាប់​មពារ់​កើយ​នហ៝​មា​ត៝ត់​ឆ្វាត់​ទាក។ ");
INSERT INTO cmok_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ជេសរី​ពាង់​បើក​ដ៝ង់​ទូ​មល៝ម់​ព្លុក គៃ​មា​គឹត​លាស​ទាក​លែៈ​ឆ្វាត់​មោ​លាស​អេ​ហ៝ៈ។ ");
INSERT INTO cmok_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ព្លុក​អី​នៃ​មពារ់​ជ៝យ​នតុក​មា​ទ្រ៝ម់​មោ​គែស​អោស យ៝រ​លាស​ទាក​ហោម​លាម​នែស​នតូ​អ្យា ជេសរី​ព្លឹ​តៃ​អា​នោអេ ​អ្យា ពាង់​នតា​តី​ញុប​ព្លុក​អី​នៃ​ងលាប់​តៃ​តា​ត្រោម​ទូក​នទ្រែល​ពាង់​នើម​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","នោអេ ​ក៝ប់​ត៝ត់​ពើស​នារ​ជឹត ជេសរី​ពាង់​បើក​តៃ​ព្លុក​អី​នៃ​ទូ​តឹ​ជឹត​លោស​ឞើស​ត្រោម​ទូក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ត៝ត់​កេង​មាង់​ព្លុក​អី​នៃ​ព្លឹ​អា​ពាង់​នើម​អ្យា យី ងក្រែ​មា​គ្លែង​ងកុរ​តើម​ឆី​អោលីវ​ដ៝ង់។ កើត​នទ្រី​ទឹង​នោអេ ​គឹត​លាស​ទាក​លែៈ​ឆ្វាត់​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ពាង់​ក៝ប់​ហោម​ពើស​នារ​ជឹត ជេសរី​ពាង់​បើក​តៃ​ព្លុក​អី​នៃ តីស​មា​មោ​ហោម​អោស​ឆៃ​ព្លុក​ព្លឹ​អា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","នោក​នោអេ ​គែស ៦០១ នាម់ នារ​ង្វាយ​ខៃ​ង្វាយ នាម់​អី​នៃ​ទាក​ឆ្វាត់​លែៈ​ផ្យៅ​ឞើស​នែស​នតូ​អ្យា។ ជេសរី​នោអេ ​ព្លោក​ច៝រ​ទូក ល៝ង់​ពាង់​ឆៃ​មពើល​នែស​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","តា​នារ ២៧ ខៃ​ឞារ នារ​អី​នៃ​នែស​ឆើស​លែៈ​ផ្យៅ​តា​កាលើ​នែស​នតូ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","នោក​នៃ​កោរាញ​ឞ្រាស​ងើយ​មា​នោអេ ៖ ");
INSERT INTO cmok_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ហើយ​នោអេ  មៃ​លោស​ឞើស​ទូក​នៃ​ហ៝ម់ អូរ​មៃ ក៝ន​មៃ នទ្រែល​មា​មាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ជេសរី​មៃ​ងលោស​អាប់​នតីល​មពោមពា​(ឆ្យុម)​អី​គុ​នទ្រែល​មៃ​នើម​តា​ត្រោម​ទូក​នៃ​ដ៝ង់ ទឹង​ឆ្យុម​មពារ់​កាលើ​ត្រោក ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​តា​ឞ្រី​តា​ប៝ន មពោមពា​(ឆ្យុម)​ហូង​វើរ​តា​នែស​នតូ លោស​អា​ទីស​ត៝ អ៝ន់​មា​គែស​អ៝ស​គែស​ក៝ន​ឞឹក​រឹ​លាម​នែស​នតូ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ជេសរី​នោអេ  អូរ​ពាង់ ក៝ន​ពាង់ នទ្រែល​មា​មាន់​ពាង់​លោស​អា​ទីស​អ្យា​ទាទេ ");
INSERT INTO cmok_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","នទ្រែល​មា​លែៈ​មពោមពា​(ឆ្យុម)​តា​ឞ្រី​តា​ប៝ន ឆ្យុម​មពារ់​កាលើ​ត្រោក មពោមពា​(ឆ្យុម)​ហូង​វើរ​តា​នែស លោស​ឞើស​ទូក​រី​ទាទេ​តឹង​នតីល​ពាង់​នើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ជេសរី​នោអេ ​ឆ៝ៈ​លុ​តឹម​រាទាប់ គៃ​មា​ជាន​នតុក​ជាន​ឞ្រាស​មា​ឞ្រាស​យេហោវា ។ ពាង់​ឆ៝ៈ​បាៈ​មពោមពា​(ឆ្យុម)​ប៝ន​អាប់​នតីល​អី​កើប​ក្ល៝ស ឆ៝ៈ​បាៈ​ឆ្យុម​មពារ់​អាប់​នតីល​អី​កើប​ក្ល៝ស ពាង់​ញហើរ​នទើ​អី​នៃ គុច​ពូរ​មល៝ម់​តា​កាលើ​នតុក​ជាន​ឞ្រាស​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ជេសរី​ឞ្រាស​យេហោវា ​រាម់​ងាន់​តា​នូយ្ស​នហ៝ម់​គែស​បោ​អី​នៃ ពាង់​មឹន​អេង​ពាង់នើម៖ “គ៝ប់​មោ​ហោម​អោស​រាតាប់​នែស​នតូ​យ៝រ​មា​នទើ​ក៝ន​ឞូនុយ្ស​ជឹត ឞ៝ល​លាស​នាវ​មឹន​ឞូនុយ្ស​អ្យើស​លែៈ​អើម​ឞើស​ជេៈ គ៝ប់​មោ​ហោម​អោស​លើស​ហេង​ជឹត​ទឹង​លែៈ​នទើ​អី​គែស​នាវ​រេស​កើត​គ៝ប់​មហែ​លើស​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ទោល​នែស​នតូ​ហោម​គែស ខៃ​តូច​ខៃ​តាម់ ខៃ​កាច់​ខៃ​រ៝យ្ស ខៃ​មីស​ខៃ​វាយ គែស​ទោស​គែស​នអីក គែស​នារ​គែស​មាង់ ពាង់​ហោម​គែស​នឹង​ទើម មោ​អោស​ឞ្លាវ​រ៝ស”។ ");
INSERT INTO cmok_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ជេសរី​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​នោអេ  នទ្រែល​មា​ពែ​នុយ្ស​ក៝ន​ឞូ​ក្លោ​ពាង់ កោរាញ​ឞ្រាស​លាស៖ “អ៝ន់​ឞាៈ​អ៝ស​រ៝ង​ក៝ន​ឞឹក​រឹ​លាម​នែស​នតូ​អ្យា! ");
INSERT INTO cmok_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","គ៝ប់​អ៝ន់​ខាន់​មៃ​ជាន​កោរាញ​មា​ទឹង​លែៈ​នតីល​មពោមពា​(ឆ្យុម) ទឹង​លែៈ​ឆ្យុម​មពារ់​កាលើ​ត្រោក ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​ហូង​វើរ​តា​នែស នទ្រែល​មា​ទឹង​លែៈ​នតីល​កឹត​កា​តា​ត្រោម​ទាក​វាច់​ទាក​វារ់ នតើម​ឞើស​អាបៃ​រី​ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អី​នៃ​ក្លាច​ញឆ៝រ់​ខាន់​មៃ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អី​គែស​នាវ​រេស​តា​នែស​នតូ​អ្យា អ៝ន់​មា​ខាន់​មរែ​ឆ៝ៈ​ជាន​ត្រាវ​ទាទេ គ៝ប់​អ៝ន់​ទឹង​លែៈ​នទើ​អ្យា​មា​ខាន់​មៃ​កើត​គ៝ប់​អ៝ន់​ត្រាវ​បាង់​មា​ខាន់​មៃ​នើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","តីស​មា​ឞ្វៃ​ឆា​ព្វាច់​អី​ហោម​គែស​មហាម​តា​ត្រោម​ឆាក់ យ៝រ​លាស​តា​មហាម​ជេង​នាវ​រេស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ម៝ស​នទើ​អី​ងខឹត​ឞូនុយ្ស គ៝ប់​ដាៈ​ងខឹត​លើយ​នទើ​អី​នៃ កើត​គ៝ប់​ដាៈ​ឞូនុយ្ស​អី​ងខឹត​ឞូនុយ្ស​អ៝ន់​ត៝ម់​ខឹត​ឆាក់​តឹម​ឞាន​កើត​អី​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ឞូ​ម៝ស​ពាង់​អី​ញចាយ​មហាម​ឞូនុយ្ស ឞូ​មរា​ញចាយ​មហាម​នើម​អី​នៃ​មោ​ក្លាយ្ស​រ៝ យ៝រ​លាស​គ៝ប់​ញជេង​ឞូនុយ្ស​នើស​កើត​គ៝ប់​នើម​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","អាបៃ​អ្យា​គ៝ប់​អ៝ន់​ខាន់​មៃ​គែស​ក៝ន​គែស​ឆៅ​ឞឹក​រឹ​លាម​នែស​នតូ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","កោរាញ​ឞ្រាស​ងើយ​ជឹត​មា​នោអេ  នទ្រែល​មា​លែៈ​ក៝ន​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“អ្យាត់​យឹ អាបៃ​អ្យា​គ៝ប់​នើម​តឹម​រាង្លាប់​នទ្រែល​ខាន់​មៃ នហ៝​រ៝​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​ខាន់​មៃ​អា​កើយ​តៃ ");
INSERT INTO cmok_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","នទ្រែល​មា​មពោមពា​(ឆ្យុម)​ទឹង​លែៈ​អី​គែស​នាវ​រេស​គុ​នទ្រែល​ខាន់​មៃ​នើស ឆ្យុម​មពារ់​កាលើ​ត្រោក មពោមពា​(ឆ្យុម)​តា​ឞ្រី​តា​ប៝ន ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​ហោម​គែស​តា​នែស​នតូ​នទ្រែល​ខាន់​មៃ​អ្យា ងើយ​ទូ​ត៝ង​លាស​ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អី​លោស​តាៈ​ឞើស​ទូក​ក្វ៝ង់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","គ៝ប់​តឹម​រាង្លាប់​នទ្រែល​ខាន់​មៃ នទើ​គែស​នាវ​រេស​តា​នែស​នតូ​អ្យា​មោ​ហោម​អោស​គែស​ខឹត​រ៝ស​ហេង​លែៈ​យ៝រ​មា​ទាក​លេង​ទាក​ទើង​ឞុក​ជឹត មោ​ហោម​គែស​ទាក​លេង​ទាក​ទើង​មា​ឞុក​លែៈ​នែស​នតូ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","កោរាញ​ឞ្រាស​លាស​ជឹត៖ “គ៝ប់​អ៝ន់​នទើ​មឞេន​មា​ខាន់​មៃ​គឹត​នាល់​នាវ​តឹម​រាង្លាប់​គ៝ប់​នទ្រែល​ខាន់​មៃ នទ្រែល​មា​ទឹង​លែៈ​រាងោច​នទើ​អី​គែស​នាវ​រេស​គុ​នទ្រែល​ខាន់​មៃ នាវ​តឹម​រាង្លាប់​អ្យា​នហ៝​រ៝​អាប់​រានោក។ ");
INSERT INTO cmok_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","គ៝ប់​អ៝ន់​គែស​ឞេស​ចុង​តឹង​គ៝ប់​តា​កាលើ​ត្រោក គៃ​មា​ឆៃ​នទើ​មឞេន​អ៝ន់​គឹត​នាល់​នាវ​តឹម​រាង្លាប់​គ៝ប់​នទ្រែល​មា​នែស​នតូ។ ");
INSERT INTO cmok_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","លាស​គ៝ប់​អ៝ន់​គែស​តុក​តា​កាលើ​ត្រោក​អ្យា ជេសរី​ឞេស​ចុង​តឹង​លោស​តា​កាលើ​ត្រោក​នៃ‌ ");
INSERT INTO cmok_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","តា​នៃ​គ៝ប់​កាស​គឹត​នាវ​តឹម​រាង្លាប់​គ៝ប់​នទ្រែល​ខាន់​មៃ នទ្រែល​មា​លែៈ​រាងោច​នទើ​គែស​នាវ​រេស​តា​នែស​នតូ​អ្យា​ដ៝ង់។ ជេសរី​មោ​ហោម​អោស​គែស​ទាក​លេង​ទាក​ទើង​ឞុក​ខឹត​រ៝ស​ហេង​លែៈ​រាងោច​នទើ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","លាស​ឞេស​ចុង​តឹង​គុ​តា​កាលើ​ត្រោក គ៝ប់​អ្វាញ់​ពាង់ កាស​គឹត​នាវ​តឹម​រាង្លាប់​គ៝ប់​ហោម​នហ៝​រ៝ នទ្រែល​មា​លែៈ​រាងោច​នទើ​អី​ហោម​រេស​តា​នែស​នតូ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","កោរាញ​ឞ្រាស​លាស​តៃ​មា​នោអេ ៖ “ឞេស​ចុង​តឹង​អី​នៃ​នទើ​មឞេន​អ៝ន់​គឹត​នាល់​នាវ​តឹម​រាង្លាប់​គ៝ប់​នទ្រែល​មា​ទឹង​លែៈ​នទើ​គែស​នាវ​រេស​តា​នែស​នតូ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ក៝ន​ឞូ​ក្លោ​នោអេ ​អី​លោស​តាៈ​ឞើស​ត្រោម​ទូក​នៃ រាញា​ខាន់​ពាង់​ឆិមហាម់  ជេសរី​យាផែត ។ ហាម់​អី​នៃ​អី​ឞឹ​កានាន ។ ");
INSERT INTO cmok_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ពែ​នុយ្ស​ខាន់​ពាង់​អី​នៃ​អី​ក៝ន​នោអេ  លែៈ​ឞូនុយ្ស​លាម​នែស​នតូ​អ្យា​តាៈ​ឞើស​ខាន់​ពាង់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ជេស​ទាក​លេង​ទាក​ទើង​នៃ នោអេ ​ឞូនុយ្ស​ជាន​មីរ ពាង់​ឞូនុយ្ស​ល៝រ​ឞូ​ឞាល់​ងាន់​តាម់​តើម​ព្លៃ​យុងយារ​ប៝ន​មា​ជាន​នទ្រាញ់។ ");
INSERT INTO cmok_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","គែស​ទូ​នារ​រី​ពាង់​ញេត​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​អី​នៃ​ត៝ត់​ញុល នហ៝​មា​ឞិច​លាហោក​លាហាក​តា​ចូន​ពាង់​នើម​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ជេសរី​ហាម់ ​អី​ឞឹ​កានាន ​រី​នើស​ឆៃ​ឞឹ​ពាង់​ឞិច​លាហោក​លាហាក​តា​ចូន​កើត​នទ្រី ពាង់​លោស​ឞើស​នៃ​ហាន់​មឞើស​អី​អ៝ស​នោ​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ជេសរី​អី​អ៝ស​នោ​រី​ឆ៝ៈ​ទូ​ឞ្លាស​ឞ៝ក​មអាក់​តា​មលីក​ខាន់​ពាង់​នើម ជេសរី​ឞ្រោៈ​ងកើយៗ​ងកុម​ឞ៝ក​អី​នៃ​ឞើស​លើ​អី​ឞឹ​រី។ ឞារ​ហៃ​ខាន់​ពាង់​អី​នៃ​មោ​អោស​រាលែ​មាត់​ជឹត​អី​ឞឹ​រី កើត​នទ្រី​ទឹង​ខាន់​ពាង់​មោ​ឆៃ​អី​ឞឹ​លាហោក។ ");
INSERT INTO cmok_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ត៝ត់​អី​ឞឹ​លែៈ​អាយ្ស ពាង់​គឹត​នាវ​ក៝ន​អី​ជេៈ​ជាន​មា​ពាង់​នើស ");
INSERT INTO cmok_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ជេសរី​ពាង់​លាស៖ “កានាន ​លែៈ​គែស​នាវ​រាតាប់​ជេស! អ៝ន់​ពាង់​គុ​ជាន​ទឹក​តា​ន៝ម់​ឞូ​មា​អី​អ៝ស​នោ​ពាង់​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ពាង់​លាស​ជឹត៖ “រានេ​មា​ឞ្រាស​យេហោវា ​អី​ឞ្រាស​ឆិម  ជេសរី​អ៝ន់​កានាន ​អី​នៃ​មា​គុ​ជាន​ទឹក​ពាង់ ");
INSERT INTO cmok_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នែស​ហ្វី​មា​យាផែត  ជេសរី​រ៝ម​ពាង់​គុ​នទ្រែល​ឆិម ​នើម អី​កានាន ​រី​អ៝ន់​ជាន​ទឹក​យាផែត​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ជេស​ទាក​លេង​ទាក​ទើង​នៃ នោអេ ​គុ​រេស​គែស ៣៥០ នាម់​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","នោអេ ​រេស​ទឹង​លែៈ​រាងោច​គែស ៩៥០ នាម់ ជេសរី​ពាង់​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","អ្យា​នាវ​ងក៝ច​រាន៝យ​ទែស​ឆិម ហាម់  នទ្រែល​មា​យាផែត ​អី​ក៝ន​នោអេ ​នៃ​នើស។ ជេស​ទាក​លេង​ទាក​ទើង​អី​នៃ ខាន់​ពាង់​ពែ​នុយ្ស​អី​នៃ​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","អី​ក៝ន​ឞូ​ក្លោ​យាផែត  ខាន់​ពាង់​គែស​រាញា​កោមើរ មាកុកមាដាយយាវានតូបាលមេឆេក  នទ្រែល​មា​តីរាស ​។ ទឹង​លែៈ​អី​ក៝ន​ឆៅ​ឞើស​កើយ​ឞើស​កើយ ខាន់​ពាង់​ឆ៝ៈ​ទឹង​លែៈ​រាញា​អី​នៃ​មា​ជេង​រាញា​មពោល​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ជេសរី​អី​ក៝ន​ឞូ​ក្លោ​កោមើរ  ខាន់​ពាង់​គែស​រាញា​អាសកេនាសរីផាត  នទ្រែល​មា​តូការមា ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","អី​ក៝ន​ឞូ​ក្លោ​យាវាន ​ជឹត ខាន់​ពាង់​គែស​រាញា​អេលីឆាតាឆើសកីតីម  នទ្រែល​មា​ដោដានីម ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ខាន់​ពាង់​អី​នៃ​អី​អូ​ចែ​មពោល​ឞូនុយ្ស​អេងៗ​គុ​រ៝ៈ​ទាក​វាច់​ទាក​វារ់។ ខាន់​ពាង់​ញចាស​មពោល​អេងៗ តឹង​រានាក់​វ៝ល់ តឹង​នាវ​ងើយ តឹង​ទាក​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","អី​ក៝ន​ឞូ​ក្លោ​ហាម់ ​ជឹត ខាន់​ពាង់​គែស​រាញា​កុសអេឆីប ពូត នទ្រែល​មា​កានាន ។ ទឹង​លែៈ​អី​ក៝ន​ឆៅ​ឞើស​កើយ​ឞើស​កើយ ខាន់​ពាង់​ឆ៝ៈ​ទឹង​លែៈ​រាញា​អី​នៃ​មា​ជេង​រាញា​មពោល​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","អី​ក៝ន​ឞូ​ក្លោ​កុស  ខាន់​ពាង់​គែស​រាញា​ចេបាហាវីលាឆាបតារាមា  នទ្រែល​មា​ឆាបតិកា ។ អី​ក៝ន​ឞូ​ក្លោ​រាមា  ពាង់​គែស​រាញា​ឆេបា  នទ្រែល​មា​ដេដាន ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ជេសរី​កុស ​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ជឹត​គែស​រាញា​និមរោត  ពាង់​អី​នៃ​អី​ឞូនុយ្ស​ល៝រ​ឞូ​ឞាល់​ជេង​កោរាញ​ម៝ត់​អ្វាញ់​ទាង់​ងាន់​តា​នែស​នតូ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ពាង់​ជេង​ឞូនុយ្ស​ឞ្រែន​ទុត​អ្វែស​ដ៝ង់​តា​នាប់​មាត់​ឞ្រាស​យេហោវា  នទ្រី​ទឹង​ឞូ​វៃ​លាស៖ «មៃ​ឞ្រែន​ទុត​អ្វែស​តឹម​ឞាន​មា​និមរោត ​តា​នាប់​មាត់​ឞ្រាស​យេហោវា »។ ");
INSERT INTO cmok_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","នតើម​នើស​ពាង់​គុ​ម៝ត់​អ្វាញ់​តា​ប៝ន​បាបីល  ប៝ន​អេរេក  ប៝ន​អាកាត  នទ្រែល​មា​ប៝ន​កាល់នេ  តា​ឞ្រី​ឆីនើរ ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ជេស​ឞើស​នៃ​ពាង់​លោស​ហាន់​ជឹត​ឞ្រី​អាឆើរ  ត៝ត់​តា​ឞ្រី​អាឆើរ ​រី​ពាង់​ជាន​ប៝ន​នីនីវេ  ប៝ន​រេហូបុត  ប៝ន​កាលាស  ");
INSERT INTO cmok_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","នទ្រែល​មា​ប៝ន​រេឆែន  ប៝ន​អី​នៃ​ក្វ៝ង់​ងាន់​វាស​វាង​ប៝ន​នីនីវេ ​មា​ប៝ន​កាលាស ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","អី​ក៝ន​ឆៅ​អេឆីប ​អី​រី​ជឹត​ជេង​មពោល​លូដីម  មពោល​អានាមីម  មពោល​លេហាបីម  មពោល​នាប់ថូហីម  ");
INSERT INTO cmok_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","មពោល​ពាត្រូឆីម  មពោល​កាសលូហីម  នទ្រែល​មា​មពោល​កាប់ថ៝រីម  មពោល​កាសលូហីម ​អី​នៃ​ជេង​ផូង​អូ​ចែ​មពោល​ផាលីសតីន ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ជេសរី​អី​កានាន ​អី​រី​ឞាៈ​ឆីដោន ​ក៝ន​ទាក​ឞោក ជេសរី​ឞាៈ​ហេត  ");
INSERT INTO cmok_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","នទ្រែល​មា​មពោល​យេបូឆីត  មពោល​អាមោរី  មពោល​គីរកាឆីត  ");
INSERT INTO cmok_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","មពោល​ហីវី  មពោល​អារ់កីត  មពោល​ឆីនីត  ");
INSERT INTO cmok_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","មពោល​អារ់វាតីត  មពោល​ឆេមារីត  នទ្រែល​មា​មពោល​ហាមាថីត ។ ជេសរី​មពោល​កានាន ​ហាន់​គុ​នតុក​អេងៗ​ឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ឞ្រី​ទាក​ខាន់​ពាង់ នតើម​ឞើស​ប៝ន​ឆីដោន ​ត៝ត់​មា​ប៝ន​កេរារ ​អី​ទាច់​ប៝ន​កាឆា  នហ៝​មា​ត៝ត់​ប៝ន​ឆោដុម  ប៝ន​កោមោរា  ប៝ន​អាតមា  នទ្រែល​មា​ប៝ន​ឆេប៝យីម  ជេសរី​នហ៝​មា​ត៝ត់​អា​ប៝ន​លាឆា​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","នទ្រី​រាន៝យ​ទែស​ហាម់  ពាង់​គុ​តឹង​រានាក់​វ៝ល់ តឹង​នាវ​ងើយ តឹង​ឞ្រី តឹង​ទាក​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ជេសរី​ឆិម ​អី​នោ​យាផែត ​រី​ពាង់​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន​ដ៝ង់។ ពាង់​អី​នៃ​អី​អូ​ចែ​មពោល​អេបែរ ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ក៝ន​ពាង់​គែស​រាញា​អេលាមអាសឆើរអារពាក់ឆាតលូត  ជេសរី​អារាម ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","អារាម ​ឞាៈ​អុស  ឞាៈ​ហូល  ឞាៈ​កេថើរ  នទ្រែល​មា​ឞាៈ​មាស ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","អារពាក់ឆាត ​ឞាៈ​ឆេលាសឆេលាស ​ឞាៈ​អេបែរ ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","អេបែរ ​ឞាៈ​ក៝ន​ឞូ​ក្លោ​ឞារ​ហៃ អី​នោ​រាញា​ផេលេក  រាញា​អី​នៃ​រាឞ្លាង​លាស​«ចាស​ច្រាយ​ឞាល់» យ៝រ​លាស​នោក​នៃ​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា​គុ​ចាស​ច្រាយ​ឞាល់។ អី​អ៝ស​ពាង់​រាញា​យុកថាន ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","យុកថាន ​ឞាៈ​អាល់មោដាត  ឞាៈ​ឆេលេប  ឞាៈ​ហាឆារមាវេត  ឞាៈ​យេរាស  ");
INSERT INTO cmok_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ឞាៈ​ហាដោរាម  ឞាៈ​អូឆាល  ឞាៈ​ដិកលា  ");
INSERT INTO cmok_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ឞាៈ​អោបាល  ឞាៈ​អាបីមាអែល  ឞាៈ​ឆេបា  ");
INSERT INTO cmok_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ឞាៈ​អោផីរ  ឞាៈ​ហាវីលា  នទ្រែល​មា​ឞាៈ​យោបាប ។ ទឹង​លែៈ​ខាន់​ពាង់​អី​នៃ​ក៝ន​យុកថាន ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ឞ្រី​ទាក​ខាន់​ពាង់​គុ​រេស​នតើម​ឞើស​ឞ្រី​មេឆា ​នហ៝​មា​ត៝ត់​នតុក​យោក​ឞ្រី​ឆេផារ ​អី​មពែស​មា​លោស​នារ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","អី​នៃ​រាន៝យ​ទែស​ឆិម  ពាង់​គុ​តឹង​រានាក់​វ៝ល់ តឹង​នាវ​ងើយ តឹង​ឞ្រី តឹង​ទាក​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","លែៈ​អី​នៃ​នើស​រាន៝យ​ទែស​អី​ក៝ន​នោអេ ​ពែ​នុយ្ស តឹង​រាន៝យ​ទែស​តឹង​ឞ្រី​ខាន់​ពាង់​នើម។ ជេស​ទាក​លេង​ទាក​ទើង​នៃ​នើស ខាន់​ពាង់​ចាស​ច្រាយ​កើត​នៃ ទឹង​គែស​មា​ជេង​លែៈ​ឞ្រី​ទាក​អេងៗ​តា​នែស​នតូ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","នោក​កាល់​អែ​នើស​ទឹង​លែៈ​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា​ទូ​នាវ​ងើយ​ទើម មឞើស​ងើយ​តឹម​ឞាន​ឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ជេសរី​ខាន់​ពាង់​នត្រើន​នតុក​ឞើស​លោស​នារ ត៝ត់​តា​នតុក​ល៝ង់​តា​ឞ្រី​ឆីនើរ  ខាន់​ពាង់​គុ​ជាន​ប៝ន​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ខាន់​ពាង់​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ “ហោៈ​ឞ៝ន់ លែវ​ឞាល់​ម៝ន​នែស​គុច អ៝ន់​ពាង់​មា​ក្រ៝ស​អ៝ន់​ទាង់”។ ជេសរី​ខាន់​ពាង់​ឆ៝ៈ​នែស​អី​គុច​នៃ​មា​ជាន​ជៃ ឆ៝ៈ​ចាយ​ក្រាក់​មា​ជាន​នទើ​លឹរ​មា​ក្រេប។ ");
INSERT INTO cmok_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ជេសរី​ខាន់​ពាង់​លាស៖ “អ៝ន់​ឞ៝ន់​ជាន​ទូ​ប៝ន​ក្វ៝ង់ ជេសរី​ជាន​ទូ​មល៝ម់​ជៃ​អ៝ន់​ទុត​ព្រេស​ប្លឺវ​ត៝ត់​អា​ត្រោក​ងាន់ អ៝ន់​ឞូ​លឺ​ឞ៝ន់ រី​មើ​ឞ៝ន់​មោ​អោស​ចាស​ច្រាយ​លាម​នែស​នតូ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ជេស​ខាន់​ពាង់​ជាន​ជៃ​ទុត​ព្រេស​អី​នៃ ឞ្រាស​យេហោវា ​ជុរ​អ្វាញ់​ប៝ន នទ្រែល​មា​ជៃ​ព្រេស​អី​ឞូនុយ្ស​ជាន​អី​នៃ ");
INSERT INTO cmok_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ជេសរី​ឞ្រាស​យេហោវា ​លាស​អេង​ពាង់នើម៖ “យី! ខាន់​ពាង់​អ្យា​ជេង​ទូ​មពោល​ទើម មឞើស​ងើយ​ទូ​នាវ​ងើយ​ទើម​ដ៝ង់ លាស​ឞ្លាវ​ជាន​អ្យា​អាបៃ​រី តា​ជឹត​នាប់​តៃ​ខាន់​ពាង់​ទើយ​ជាន​ដ៝ង់​ម៝ស​នទើ​អី​ខាន់​ពាង់​អុច។ ");
INSERT INTO cmok_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","លាស​នទ្រី​ឞ៝ន់​ជុរ​ជាន​វិ​លើយ​នាវ​ងើយ​ខាន់​ពាង់​ប៝ត់ លើយ​ហោម​អោស​អ៝ន់​ខាន់​ពាង់​តឹម​គឹត​ងើយ​ជឹត​នាប់​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ជេសរី​ឞ្រាស​យេហោវា ​អ៝ន់​ខាន់​ពាង់​ចាស​ច្រាយ​ឞាល់​ទូ​ងាយ​តាៈ​ឞើស​នតុក​អី​នៃ ទឹង​គែស​លាម​នែស​នតូ​អ្យា នទ្រី​ខាន់​ពាង់​ឞាស​ជាន​ប៝ន​តា​នតុក​អី​នៃ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","កើត​នទ្រី​ទឹង​ឞូ​តេៈ​រាញា​ប៝ន​អី​នៃ​លាស បាបីល  រាឞ្លាង​លាស​«វិ» យ៝រ​លាស​តា​នតុក​អី​នៃ​អី​ឞ្រាស​យេហោវា ​ជាន​វិ​នាវ​ងើយ​អ៝ន់​ឞូនុយ្ស​ទឹង​លែៈ​តា​នែស​នតូ​អ្យា​ងើយ​តឹម​តីស​ឞាល់ អ៝ន់​ឞូនុយ្ស​ចាស​ច្រាយ​ឞាល់​តាៈ​ឞើស​នតុក​នៃ​ទឹង​គែស​លាម​នែស​នតូ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","អ្យា​នាវ​ងក៝ច​រាន៝យ​ទែស​ឆិម ។ ត៝ត់​ឆិម ​គែស ១០០ នាម់​ពាង់​ឞាៈ​អារពាក់ឆាត  នាម់​អី​នៃ​លែៈ​គែស​ឞារ​នាម់ ជេស​ទាក​លេង​ទាក​ទើង​ក្វ៝ង់​អី​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ជេស​ពាង់​ឞាៈ​អារពាក់ឆាត ​រី ពាង់​រេស​គែស ៥០០ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ត៝ត់​អារពាក់ឆាត ​គែស ៣៥ នាម់ ពាង់​ឞាៈ​ឆេលាស ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ជេស​ពាង់​ឞាៈ​ឆេលាស  ពាង់​រេស​គែស ៤០៣ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ត៝ត់​ឆេលាស ​គែស ៣០ នាម់ ពាង់​ឞាៈ​អេបែរ ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ជេស​ពាង់​ឞាៈ​អេបែរ ​រី ពាង់​រេស​គែស ៤០៣ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ត៝ត់​អេបែរ ​គែស ៣៤ នាម់ ពាង់​ឞាៈ​ផេលេក ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ជេស​ពាង់​ឞាៈ​ផេលេក ​រី ពាង់​រេស​គែស ៤៣០ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ត៝ត់​ផេលេក ​គែស ៣០ នាម់ ពាង់​ឞាៈ​រេអូ ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ជេស​ពាង់​ឞាៈ​រេអូ ​រី ពាង់​រេស​គែស ២០៩ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ត៝ត់​រេអូ ​គែស ៣២ នាម់ ពាង់​ឞាៈ​ឆេរូក ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ជេស​ពាង់​ឞាៈ​ឆេរូក ​រី ពាង់​រេស​គែស ២០៧ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ត៝ត់​ឆេរូក ​គែស ៣០ នាម់ ពាង់​ឞាៈ​នាហោរ ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ជេស​ពាង់​ឞាៈ​នាហោរ ​រី ពាង់​រេស​គែស ២០០ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ត៝ត់​នាហោរ ​គែស ២៩ នាម់ ពាង់​ឞាៈ​ថេរា ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ជេស​ពាង់​ឞាៈ​ថេរា ​រី ពាង់​រេស​គែស ១១៩ នាម់​ជឹត នហ៝​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន គែស​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ត៝ត់​ថេរា ​គែស ៧០ នាម់ ពាង់​ឞាៈ​អាប់រាម  ឞាៈ​នាហោរ  នទ្រែល​មា​ឞាៈ​ហារាន ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","អ្យា​ជេង​នាវ​ងក៝ច​រាន៝យ​ទែស​ថេរា ។ ថេរា ​ឞាៈ​អាប់រាម  ឞាៈ​នាហោរ  នទ្រែល​មា​ឞាៈ​ហារាន ។ ជេសរី​ហារាន ​ឞាៈ​លុត ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ហារាន ​ខឹត​តា​ប៝ន​អូរ ​តា​ឞ្រី​ខាលដេ  នតុក​ឞ្រី​ពាង់​នើម ទោល​អី​ឞឹ​ពាង់​ថេរា ​ហោម​រេស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","អាប់រាម  នទ្រែល​មា​នាហោរ ​អី​អ៝ស​ពាង់​រី ខាន់​ពាង់​ឆ៝ៈ​អូរ។ អី​អូរ​អាប់រាម ​រាញា​ឆារាយ  អី​អូរ​នាហោរ ​រី​រាញា​មីលកា ​អី​ក៝ន​ហារាន ហារាន ​អី​រី​អី​ឞឹ​ក៝ន​ឞូ​អូរ​មីលកា  នទ្រែល​មា​អីសកា ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ល៝ង់​ឆារាយ ​អី​អូរ​អាប់រាម ​នៃ ជេង​ឞូ​អូរ​មោ​អោស​ឞាៈ​ក៝ន ពាង់​មោ​គែស​ក៝ន​វាៈ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ជេសរី​ថេរា ​លែវ​អាប់រាម ​អី​ក៝ន​ពាង់​នើម​រី នទ្រែល​មា​អី​ឆៅ​លុត ​ពាង់​រី អី​ក៝ន​ហារាន ​រី​នើស ជេសរី​ឆារាយ ​អី​មាន់​ពាង់​នើម​រី​ដ៝ង់ ខាន់​ពាង់​លោស​តាៈ​ឞើស​ប៝ន​អូរ ​ឞ្រី​ខាលដេ ​នៃ ហាន់​ជឹត​ឞ្រី​កានាន ។ ត៝ត់​តា​ប៝ន​ចារាន ​រី ខាន់​ពាង់​ជាន​នតុក​មា​គុ​តា​ប៝ន​នៃ អេ​អោស​ត៝ត់​តា​ឞ្រី​កានាន ។ ");
INSERT INTO cmok_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ថេរា ​រេស​គែស ២០៥ នាម់ ជេសរី​ខឹត ពាង់​ខឹត​តា​ប៝ន​ចារាន ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ជេសរី​ឞ្រាស​យេហោវា​លាស​មា​អាប់រាម ​កើត​នអា៖ “មៃ​ទូ​លោស​ហ៝ម់​ឞើស​ឞ្រី​មៃ​នើម ឞើស​នទុល​មពោល​មៃ​នើម នទ្រែល​មា​ឞើស​រានាក់​វ៝ល់​ឞឹ​មៃ​នើម ជេសរី​ហាន់​គុ​តា​ឞ្រី​គ៝ប់​ញហើ​មា​មៃ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","គ៝ប់​អ៝ន់​មៃ​គែស​រាន៝យ​ទែស​អ៝ក់ អ៝ន់​ខាន់​ពាង់​ជេង​ទូ​ផូង​ទុត​ក្វ៝ង់ គ៝ប់​អ៝ន់​មៃ​គែស​ជេង នទ្រែល​មា​អ៝ន់​ឞូ​លឺ​ឆាក់​មៃ កើត​នទ្រី​ទឹង​មៃ​ជេង​ឞូនុយ្ស​អ៝ន់​គែស​ជេង​មា​ឞូ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","គ៝ប់​អ៝ន់​គែស​ជេង​មា​ឞូ​ម៝ស​អី​អ៝ន់​គែស​ជេង​មា​មៃ គ៝ប់​រាតាប់​ដ៝ង់​មា​ឞូ​ម៝ស​អី​រាតាប់​មៃ ទឹង​លែៈ​រានាក់​វ៝ល់​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា គែស​ជេង​តាៈ​ឞើស​មៃ​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ជេស​ឞ្រាស​យេហោវា​ដាៈ​អាប់រាម​កើត​នៃ ពាង់​ជាន​តឹង​រ៝ ពាង់​ទូ​លោស​ឞើស​ប៝ន​ចារាន  ជេសរី​អី​ម៝ន​ពាង់​លុត ​ហាន់​នទ្រែល​ដ៝ង់។ ទោល​អាប់រាម ​ទូ​លោស​ឞើស​នតុក​នៃ ពាង់​លែៈ​គែស ៧៥ នាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ពាង់ អី​អូរ​ឆារាយ ​ពាង់ អី​ម៝ន​លុត ​ពាង់ នទ្រែល​មា​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស នអ៝ប់​មា​ផូង​ឞូនុយ្ស​អី​នតើម​ជាន​ការ​មា​ពាង់​តា​ប៝ន​ចារាន ​នៃ​នើស ពាង់​ញអោត​ហាន់​ជឹត​ឞ្រី​កានាន ​រី​ទាទេ។ លែៈ​ត៝ត់​តា​ឞ្រី​កានាន ​រី ");
INSERT INTO cmok_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","អាប់រាម ​ហាន់​គ្លាត់​រ៝ៈ​ឞ្រី​នៃ​ត៝ត់​តា​តើម​ជ្រី​អី​ឞូ​រាញា​មោរេ  ទាច់​មា​ប៝ន​ឆីកែម ។ ទោល​នៃ​ផូង​កានាន​គុ​តា​ឞ្រី​ទាក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ជេសរី​ឞ្រាស​យេហោវា​តឹម​មពើល​អ៝ន់​មា​អាប់រាម ​ឆៃ ពាង់​លាស៖ “គ៝ប់​អ៝ន់​ឞ្រី​ទាក​អ្យា​មា​ផូង​រាន៝យ​ទែស​មៃ”។ ជេសរី​អាប់រាម ​ជាន​ទូ​នតុក​មា​ជាន​ឞ្រាស​តា​នតុក​នៃ​គៃ​មា​ញហើរ​មា​ឞ្រាស​យេហោវា​អី​លែៈ​តឹម​មពើល​អ៝ន់​ពាង់​ឆៃ​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ជេសរី​ពាង់​ហាន់​ជឹត ហាន់​តា​នតុក​យោក​មពែស​ឞើស​លោស​នារ​ប៝ន​បេតអែល ពាង់​ជាន​ចូន​គុ​តា​នតុក​នៃ ពាង់​គុ​វាស​វាង​ប៝ន​បេតអែល ដាស​មា​ប៝ន​អាយ គែស​មពែស​ឞើស​លោស​នារ​មា​ប៝ន​បេតអែល។ គែស​មពែស​ឞើស​ញ៝ប់​នារ​មា​ប៝ន​អាយ តា​នតុក​នៃ​ពាង់​ជាន​ទូ​នតុក​ជឹត​មា​ជាន​ឞ្រាស​មា​ឞ្រាស​យេហោវា ជេសរី​ពាង់​យើក​មឞាស​មា​ឞ្រាស​យេហោវា​។ ");
INSERT INTO cmok_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ជេសរី​ពាង់​ហាន់​ងាន់ ត៝ត់​តា​ឞ្រី​នេកិប។ ");
INSERT INTO cmok_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","នោក​នៃ​តា​ឞ្រី​កានាន​គែស​នាវ​ជី​ឆ៝ត់​ជី​ង៝ត យ៝រ​រី​អាប់រាម​ហាន់​គុ​តា​ឞ្រី​អេឆីប  យ៝រ​លាស​នាវ​ជី​ឆ៝ត់​ជី​ង៝ត​តា​ឞ្រី​កានាន​នៃ​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ទោល​ពាង់​ហាន់​ឞើយ​ត៝ត់​តា​ឞ្រី​អេឆីប  ពាង់​លាស​មា​អូរ​ពាង់៖ “គ៝ប់​គឹត​អៃ​អ្យា​ជេង​ឞូ​អូរ​អ្វែស​រែស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ត៝ត់​ផូង​អេឆីប ​ឆៃ​អៃ ឞូ​លាស​អៃ​ជេង​អូរ​គ៝ប់ លាស​នទ្រី​ឞូ​មរា​ងខឹត​លើយ​គ៝ប់ ហោម​រ៝ង​អៃ​រេស។ ");
INSERT INTO cmok_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","លាស​នទ្រី​អ៝ន់​អៃ​មឞើស​មា​ឞូ​លាស អៃ​ជេង​អ៝ស​គ៝ប់ គៃ​មា​ឞូ​ជាន​អ្វែស​មា​គ៝ប់​យ៝រ​តាៈ​ឞើស​អៃ ជេសរី​ឞូ​រ៝ង​គ៝ប់​រេស​យ៝រ​តាៈ​ឞើស​អៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ត៝ត់​តា​ឞ្រី​អេឆីប​រី ផូង​អេឆីប ​ឆៃ​អូរ​អាប់រាម​អ្វែស​រែស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ផូង​កោរាញ​កាដាច់​ផារ៝ន​នើម​ឆៃ​ពាង់​ដ៝ង់ ខាន់​ពាង់​រានេ​អ្វែស​ឆារាយ ​រី​មឞើស​មា​ផារ៝ន ជេសរី​ឞូ​លែវ​ពាង់​ញជុន​តា​ញីស​កាដាច់​ផារ៝ន​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ល៝ង់​អី​អាប់រាម​រី ផារ៝ន​ជាន​អ្វែស​មា​ពាង់​ងាន់​យ៝រ​តាៈ​មា​អូរ​ឆារាយ ​ពាង់​រី ផារ៝ន​អ៝ន់​ទឹក​ឞូ​អូរ​ទឹក​ឞូ​ក្លោ​មា​ពាង់ អ៝ន់​ឞែ​ឞ្យាប់ អ៝ន់​នទ្រោក​ងក្វ៝ង់ អ៝ន់​ឆែស​លៀ​មែ​ដ៝ង់ ឆែស​លៀ​ងក្វ៝ង់​ដ៝ង់ នទ្រែល​មា​អ៝ន់​ឆែស​ឆាមោ។ ");
INSERT INTO cmok_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","យើន​មា​ឞ្រាស​យេហោវា​ជាន​អ៝ន់​នាវ​ជី​ក្វ៝ង់​ងាន់​មា​ផារ៝ន នទ្រែល​មា​ឞូនុយ្ស​ទឹង​លែៈ​តា​ញីស​ពាង់ យ៝រ​មា​ឆារាយ ​អី​អូរ​អាប់រាម​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ជេសរី​ផារ៝ន​ក្វាល់​អាប់រាម ​លាស​ពាង់៖ “ម៝ស​កោៈ​មៃ​ជាន​មា​គ៝ប់​កើត​នអា​មេស? ខ៝ន់​មៃ​មា​មឞើស​ឆ៝ង់​មា​គ៝ប់ ឞូ​អូរ​អ្យា​ជេង​អូរ​មៃ! ");
INSERT INTO cmok_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ម៝ស​ទឹង​មៃ​លាស​ពាង់​ជេង​អ៝ស​មៃ ជាន​អ៝ន់​គ៝ប់​ឆ៝ៈ​ពាង់​ជាន​អូរ​ច្រាវ? អឺស​អូរ​មៃ ញឆឹត​មរែ​អា​រី ទូ​ឞើស​នតុក​អ្យា​ហ៝ម់!” ");
INSERT INTO cmok_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ជេសរី​ផារ៝ន​ដាៈ​តាហែន​ពាង់​ញជុន​អាប់រាម  នទ្រែល​មា​អូរ​ពាង់ នអ៝ប់​មា​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស​ទូ​លោស​ឞើស​ឞ្រី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ជេសរី​អាប់រាម ​នទ្រែល​មា​អូរ​ពាង់​លោស​ឞើស​ឞ្រី​អេឆីប ​ព្លឹ​ឆឹត​តៃ​តា​ឞ្រី​នេកិប លែៈ​ទ្រាប់​នទើ​ពាង់​គែស ញអោត​លែវ​នទ្រែល​ពាង់​នើម​ទាទេ។ លុត ​ហាន់​នទ្រែល​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","អាប់រាម​គែស​មពោមពា​(ឆ្យុម) នទ្រែល​មា​ព្រាក់​មាយ្ស​អ៝ក់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ពាង់​លោស​ឞើស​ឞ្រី​នេកិប​នៃ ត៝ត់​តា​ប៝ន​បេតអែល​នតុក​ពាង់​គុ​ជាន​ចូន​អា​ល៝រ​នើស តា​វាស​វាង​ប៝ន​បេតអែល ដាស​មា​ប៝ន​អាយ​នៃ ");
INSERT INTO cmok_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ជេសរី​ពាង់​មឞើស​ឆើម​ក្វាល់​ឞ្រាស​យេហោវា​តា​នតុក​ពាង់​លែៈ​ជាន​នតុក​មា​ជាន​ឞ្រាស​អា​ល៝រ​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","លុត ​អី​វៃ​ហាន់​នទ្រែល​មា​អាប់រាម​រី ពាង់​គែស​ឞែ​ឞ្យាប់​ផូង គែស​នទ្រោក​ផូង នទ្រែល​មា​គែស​ចូន​អ៝ក់ តឹម​ឞាន​មា​អាប់រាម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","តា​ឞ្រី​នៃ​មោ​អោស​ត៝ង់​មពា​មា​អ៝ន់​មពោមពា​(ឆ្យុម)​ឞារ​ហៃ​ខាន់​ពាង់ យ៝រ​លាស​ខាន់​ពាង់​គែស​មពោមពា​(ឆ្យុម)​ទ្រាប់​នទើ​អ៝ក់​ងាន់ នទ្រី​ទឹង​ខាន់​ពាង់​មោ​ហោម​អោស​ឞ្លាវ​គុ​នទ្រែល ");
INSERT INTO cmok_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","គែស​នាវ​តឹម​ល៝ក់​ឞាល់​ផូង​ច្យាប់​អាប់រាម ​នទ្រែល​មា​ផូង​ច្យាប់​លុត ។ រានោក​នៃ​ផូង​កានាន នទ្រែល​មា​ផូង​ពេរិឆីត​គុ​តា​ឞ្រី​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ជេសរី​អាប់រាម​លាស​មា​លុត ៖ “អើ​ម៝ន លើយ​អ៝ន់​អោស​គ៝ប់​នទ្រែល​មៃ​គែស​នាវ​តឹម​ល៝ក់​ឞាល់ មោ​លាស​ផូង​ច្យាប់​គ៝ប់ នទ្រែល​មា​ផូង​ច្យាប់​មៃ យ៝រ​លាស​ឞ៝ន់​ជេង​អ៝ស​នោ។ ");
INSERT INTO cmok_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ឞ្រី​តា​អ្យា​ហោម​ហ្វី​ងាន់ លាស​នទ្រី​អ៝ន់​ឞ៝ន់​គុ​តឹម​ងខាស​ឞាល់ លាស​មៃ​គុ​មពែស​ឞើស​ច្យៅ គ៝ប់​គុ​មពែស​ឞើស​មា លាស​មៃ​គុ​មពែស​ឞើស​មា គ៝ប់​គុ​មពែស​ឞើស​ច្យៅ”។ ");
INSERT INTO cmok_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ជេសរី​លុត ​ងគឹល​អ្វាញ់​ឆៃ​នទ្រិច​រាដុង​រ៝ៈ​ទាក​រាលាយ​យោរដាន់​មពែស​មា​ប៝ន​ឆោអារ​អ្វែស​ងាន់​គែស​ទាក​ទាទេ។ នតុក​នៃ​នោក​អេ​ហ៝ៈ​ឞ្រាស​យេហោវា​លើស​រាយ​លើយ​ប៝ន​ឆោដុម នទ្រែល​មា​ប៝ន​កោមោរា​ជេង​តឹម​ឞាន​មា​អេដែន​អី​មីរ​កោរាញ​ឞ្រាស មោ​លាស​កើត​ឞ្រី​អេឆីប ​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","នទ្រី​លុត ​ឆ៝ៈ​លែៈ​នទ្រិច​រាដុង​យោរដាន់​នៃ​មា​ពាង់​នើម ពាង់​ហាន់​មពែស​ជឹត​លោស​នារ​រី កើត​នទ្រី​ទឹង​គែស​មា​តឹម​ងខាស​ខាន់​ពាង់​ឞារ​ហៃ​អី​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","អាប់រាម​គុ​តា​ឞ្រី​កានាន​នៃ យើន​មា​លុត ​គុ​រ៝ៈ​ប៝ន​នទ្រិច​រាដុង​យោរដាន់​រី ឞើស​កើយ​នៃ​ពាង់​គុ​ជាន​ចូន​តា​មែង​ប៝ន​ឆោដុម​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ឞូនុយ្ស​តា​ប៝ន​ឆោដុម​រី ជេង​ផូង​អ្យើស ជាន​តីស​មា​ឞ្រាស​យេហោវា​ទុត​ហោ។ ");
INSERT INTO cmok_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ជេស​លុត ​ទូ​លោស​ឞើស​នតុក​នៃ ឞ្រាស​យេហោវា​លាស​មា​អាប់រាម៖ “អ៝ន់​មៃ​ងគើរ​អ្វាញ់​ឞើស​នតុក​មៃ​គុ​នៃ​អាបៃ​រី អ្វាញ់​ជឹត​លោស​នារ​អ្វាញ់​ជឹត​ញ៝ប់​នារ អ៝ន់​មៃ​អ្វាញ់​មពែស​ជឹត​លើ​អ្វាញ់​មពែស​ជឹត​ទ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","យ៝រ​លាស​លែៈ​រាងោច​ឞ្រី​អី​មៃ​ឆៃ​នៃ គ៝ប់​អ៝ន់​មា​មៃ​តា​ជឹត​នាប់​តៃ នទ្រែល​មា​រាន៝យ​ទែស​មៃ​នហ៝​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","គ៝ប់​អ៝ន់​មៃ​រាន៝យ​ទែស​ឞឹក​រឹ​អ៝ក់​តឹម​ឞាន​មា​នែស​មោយ មោ​គែស​អោស​ឞូនុយ្ស​ទើយ​កើប តឹម​ឞាន​មា​ឞូ​មោ​ទើយ​កើប​នែស​មោយ​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","មៃ​ទ៝ក់​ហ៝ម់ ហាន់​លាម​ឞ្រី​នៃ យ៝រ​លាស​គ៝ប់​អ៝ន់​ឞ្រី​អី​នៃ​មា​មៃ​តា​ជឹត​នាប់​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ជេសរី​អាប់រាម​រើយ្ស​ចូន​ពាង់​រី ហាន់​ត្រើន​គុ​អា​នតុក​តើម​ជ្រី​មាម់រេ ទាច់​មា​ប៝ន​ហេប្រ៝ន តា​នតុក​នៃ​ពាង់​រាទាប់​លុ​ជាន​ទូ​នតុក​មា​ជាន​ឞ្រាស​មា​យើក​មឞាស​ឞ្រាស​យេហោវា។ ");
INSERT INTO cmok_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","នោក​នៃ​គែស​ទូ​ហ្វេ​កាដាច់​ក្វ៝ង់​រាញា​កេដោលោមើរ​ជេង​កាដាច់​តា​ឞ្រី​អេលាម ពាង់​តឹម​រាង្លាប់​ដាស​ពែ​នុយ្ស​កាដាច់ កាដាច់​តា​ឞ្រី​ឆីនើរ​រាញា​អាម់រាផែល កាដាច់​តា​ឞ្រី​អេលាឆារ​រាញា​អារយុក នទ្រែល​មា​កាដាច់​តា​ឞ្រី​កោយីម​រាញា​ថីដាល។ ");
INSERT INTO cmok_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","លែៈ​ព្វាន់​នុយ្ស​កាដាច់​អី​នៃ​លែវ​ឞាល់​ហាន់​តឹម​លើស​ដាស​ព្រាម់​នុយ្ស​កាដាច់ កាដាច់​តា​ប៝ន​ឆោដុម​រាញា​បេរា កាដាច់​តា​ប៝ន​កោមោរា​រាញា​បីរឆា កាដាច់​តា​ប៝ន​អាតមា​រាញា​ឆីនាប កាដាច់​តា​ប៝ន​ឆេប៝យីម​រាញា​ឆេមេបើរ នទ្រែល​មា​កាដាច់​តា​ប៝ន​បេលា​អី​ឞូ​ក្វាល់​ដ៝ង់​ប៝ន​ឆោអារ។ ");
INSERT INTO cmok_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","លែៈ​រាងោច​ព្រាម់​នុយ្ស​កាដាច់​អី​នៃ រាគូម​តាហែន​ខាន់​ពាង់​នើម​ហាន់​តឹម​រាង្លាប់​នទ្រែល​តា​រាដុង​យោក​ឆីដីម​ទាទេ នតុក​ទាក​វាច់​ទាក​វារ់​ឞ៝ស​អាបៃ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","លែៈ​គែស ១២ នាម់​ជេស លែៈ​ព្រាម់​នុយ្ស​កាដាច់​អី​នៃ​គុ​តា​ន៝ម់​កាដាច់​ក្វ៝ង់​កេដោលោមើរ ត៝ត់​នាម់ ១៣ ខាន់​ពាង់​លែវ​ឞាល់​ឞាស​អ្យាត់​នាវ​ដាស​កាដាច់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","យើន​មា​ត៝ត់​នាម់ ១៤ កាដាច់​កេដោលោមើរ នទ្រែល​មា​លែៈ​កាដាច់​អី​គុ​នទ្រែល​ពាង់ លែវ​ឞាល់​ហាន់​តឹម​លើស​ដាស​មពោល​កាដាច់​អី​ឞាស​អ្យាត់​នាវ​ពាង់។ ទោល​ហាន់​រ៝ៈ​ត្រ៝ង​នៃ ខាន់​ពាង់​តឹម​លើស​ដាស​ផូង​រេផែម​តា​ប៝ន​អាសថោរោត-​ការនែម ផូង​ឆោឆីម​តា​ប៝ន​ហាម់ ផូង​អេមីម​តា​នតុក​ឞ្រី​ល៝ង់​ខិរយាថែម ");
INSERT INTO cmok_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","នទ្រែល​មា​ផូង​ហោរី​រ៝ៈ​យោក​ឆេអីរ នហ៝​មា​ត៝ត់​តា​ប៝ន​អែលបារាន​ទាច់​មា​ឞ្រី​រាទាស​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ជេស​ទើយ​ខាន់​ពាង់​តឹម​លើស​ដាស​ផូង​អី​នៃ ខាន់​ពាង់​ព្លឹ​ឆឹត​ឞើស​នៃ​ត៝ត់​តា​ប៝ន​អេន-​មីសផាត អី​ឞូ​ក្វាល់​ប៝ន​កាដែស​ដ៝ង់ ខាន់​ពាង់​តឹម​លើស​ដាស​ផូង​អាមាលេក​តា​ឞ្រី​នៃ នទ្រែល​មា​ដាស​ផូង​អាមោរី​គុ​តា​ឞ្រី​ហាឆាឆោន-​តាមារ​នៃ​ទើយ​ខាន់​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ផូង​កាដាច់​ព្រាម់​នុយ្ស​អី​ឞាស​អ្យាត់​នាវ​កាដាច់​ក្វ៝ង់​កេដោលោមើរ​នើស ជេង​កាដាច់​ប៝ន​ឆោដុម កាដាច់​ប៝ន​កោមោរា កាដាច់​ប៝ន​អាតមា កាដាច់​ប៝ន​ឆេប៝យីម នទ្រែល​មា​កាដាច់​ប៝ន​បេលា ខាន់​ពាង់​លែវ​ឞាល់​តឹម​លើស​តា​រាដុង​យោក​ឆីដីម។ ប៝ន​បេលា​អី​នៃ​ឞូ​ក្វាល់​ប៝ន​ឆោអារ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","តា​រាដុង​យោក​ឆីដីម​នៃ ខាន់​ពាង់​តឹម​លើស​ដាស​កាដាច់​កេដោលោមើរ​ជេង​កាដាច់​ឞ្រី​អេលាម កាដាច់​ថីដាល​ជេង​កាដាច់​ឞ្រី​កោយីម កាដាច់​អាម់រាផែល​ជេង​កាដាច់​ឞ្រី​ឆីនើរ នទ្រែល​មា​កាដាច់​អារយុក​ជេង​កាដាច់​ឞ្រី​អេលាឆារ នទ្រី​គែស​ព្វាន់​កាដាច់​តឹម​លើស​ដាស​ព្រាម់​កាដាច់។ ");
INSERT INTO cmok_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","តា​រាដុង​យោក​ឆីដីម​នៃ​គែស​នតូ​ទាក​ព្រីង​ក្រាក់​អ៝ក់​ងាន់។ ទើយ​កាដាច់​កេដោលោមើរ ជេសរី​កាដាច់​ប៝ន​ឆោដុម នទ្រែល​មា​កាដាច់​ប៝ន​កោមោរា​ញច្វាត់​ចាស​ច្រាយ​តុប​តា​នតូ​ព្រីង​រី​ខឹត​លែៈ​ផ្យៅ​នទ្រែល​តាហែន​ខាន់​ពាង់​នើម ជេសរី​កាដាច់​អី​ហោម​ពែ​នុយ្ស​រី​ញច្វាត់​ជឹត​យោក​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","កាដាច់​អី​ទើយ​លើស​ឞូ​នៃ ខាន់​ពាង់​ឆ៝ៈ​លែៈ​ទ្រាប់​នទើ​តា​ប៝ន​ឆោដុម នទ្រែល​មា​តា​ប៝ន​កោមោរា​រី នអ៝ប់​មា​នទើ​ឆោង​ឆា​ដ៝ង់ ជេសរី​ទូ​ឆឹត​ឞើស​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","លុត ​អី​ម៝ន​អាប់រាម​គុ​តា​ប៝ន​ឆោដុម​រី ឞូ​ញុប​រាទូ​ពាង់​ដ៝ង់ នទ្រែល​មា​លែៈ​ទ្រាប់​នទើ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ក្លាយ្ស ហាន់​ញច្វាត់​មឞើស​មា​អាប់រាម​អី​ផូង​ហេឞ្រើ នោក​ពាង់​ហោម​គុ​តា​នតុក​តើម​ជ្រី​មាម់រេ។ មាម់រេ​ជេង​ឞូ​ក្លោ​ផូង​អាមោរី ជេង​អ៝ស​នោ​មា​អែសកុល នទ្រែល​មា​អានើរ​ដ៝ង់។ អែសកុល នទ្រែល​មា​អានើរ​នៃ​លែៈ​តឹម​រាង្លាប់​មា​អាប់រាម។ ");
INSERT INTO cmok_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ត៝ត់​អាប់រាម​តាង់​លាស​ម៝ន​ពាង់​លែៈ​ឞូ​ញុប​រាទូ ពាង់​លែវ​ឞាល់ ៣១៨ នុយ្ស ជេង​ឞូនុយ្ស​អី​ឞ្លាវ​តឹម​លើស​អី​ទែស​តា​ជៃ​ពាង់​នើម ខាន់​ពាង់​តឹង​ផូង​រាលាង់​ត៝ត់​តា​ប៝ន​ដាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","អាប់រាម​តឹម​ពាៈ​មពោល​តា​ផូង​ពាង់​នើម​នៃ ជេសរី​លើស​ផូង​កាដាច់​អី​នៃ​តា​នោក​មាង់ នហ៝​មា​តឹង​លើស​ត៝ត់​តា​ប៝ន​ហោបា​មពែស​ឞើស​លើ​ប៝ន​ដាមាស​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ខាន់​ពាង់​ឆ៝ៈ​ឆឹត​ទាទេ​លែៈ​ទ្រាប់​នទើ ឆ៝ៈ​អី​ម៝ន​លុត ​ពាង់​រី នទ្រែល​មា​ទ្រាប់​នទើ​ពាង់​ដ៝ង់ ឆ៝ៈ​ផូង​ឞូ​អូរ នទ្រែល​មា​លែៈ​រាងោច​ឞូនុយ្ស​អេងៗ​អី​ឞូ​ញុប​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ជេស​អាប់រាម​ឆឹត​ទើយ​តឹម​លើស​ដាស​កាដាច់​កេដោលោមើរ នទ្រែល​មា​កាដាច់​អាបាៈ​អេង​អី​គុ​តឹម​រាង្លាប់​នទ្រែល​កាដាច់​នៃ កាដាច់​ប៝ន​ឆោដុម​ហាន់​ច្វាៈ​ពាង់​តា​រាដុង​យោក​ឆាវេ អី​ឞូ​ក្វាល់​ដ៝ង់​«រាដុង​យោក​កាដាច់»។ ");
INSERT INTO cmok_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ជេសរី​កាដាច់​ប៝ន​ឆាលេម​រាញា​មិលកីឆាដែក​ញអោត​នុមពាង់ នទ្រែល​មា​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មា​អ៝ន់​អាប់រាម  កាដាច់​នៃ​ជេង​ឞូនុយ្ស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​អី​ទុត​ព្រេស។ ");
INSERT INTO cmok_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ពាង់​លាស​នាវ​គែស​ជេង​អ៝ន់​មា​អាប់រាម៖ “ទាន់​កោរាញ​ឞ្រាស​អី​ទុត​ព្រេស​តា​កាលើ នើម​តើម​ញជេង​ត្រោក នទ្រែល​មា​នែស​នតូ អ៝ន់​នាវ​គែស​ជេង​មា​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","រានេ​មា​កោរាញ​ឞ្រាស​អី​ទុត​ព្រេស​តា​កាលើ ឞ្រាស​អី​អ៝ន់​មៃ​ទើយ​ដាស​ផូង​រាលាង់​មៃ”។ ជេសរី​អាប់រាម​អ៝ន់​មា​កាដាច់​អី​នៃ​ទូ​កោៈ​តឹម​ជឹត លែៈ​ទ្រាប់​នទើ​អី​ពាង់​ឆ៝ៈ​លើស​ឞូ​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ជេសរី​កាដាច់​ប៝ន​ឆោដុម​លាស​មា​អាប់រាម៖ “មៃ​មព្លឹ​ប៝ន​លាន​គ៝ប់​នើម​មា​គ៝ប់​គាប់​ហើយ្ស ទ្រាប់​នទើ​អី​នៃ​មៃ​ឆ៝ៈ​ទោស”។ ");
INSERT INTO cmok_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","យើន​មា​អាប់រាម​លាស​មា​កាដាច់​ប៝ន​ឆោដុម​នៃ៖ “គ៝ប់​ត៝ន​តា​ឞើស​នាប់​ឞ្រាស​យេហោវា​អី​កោរាញ​ឞ្រាស​ទុត​ព្រេស នើម​តើម​ញជេង​ត្រោក នទ្រែល​មា​នែស​នតូ ");
INSERT INTO cmok_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","គ៝ប់​មោ​អោស​ឆ៝ៈ​ទ្រាប់​នទើ​មៃ​ទូ​មល៝ម់ ឞ៝ល​លាស​ទូ​មល៝ម់​រាឆែ​ឞ្រាយ មោ​លាស​ទូ​មល៝ម់​រាឆែ​នតោ​ជ៝ត​ក៝ៈ​គ៝ប់​មោ​ឆ៝ៈ​ដ៝ង់ លើយ​អ៝ន់​មៃ​លាស៖ «គ៝ប់​យា​ឆើម​នហើម​នទ្រ៝ង់​អ៝ន់​អាប់រាម»។ ");
INSERT INTO cmok_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","គ៝ប់​មោ​អោស​ឆ៝ៈ​នទើ គ៝ប់​ទាន់​មៃ​អ៝ន់​នទើ​ឆោង​ឆា​អី​ផូង​ហាន់​តឹម​លើស​នទ្រែល​គ៝ប់​ជេង​ផូង​អី​គុ​តា​ជៃ​គ៝ប់​នើម​លែៈ​ជេស​ឆា​នើស​គាប់​ហើយ្ស។ យើន​មា​អានើរអែសកុល នទ្រែល​មា​មាម់រេ ខាន់​ពាង់​ជេង​ឞូនុយ្ស​តឹម​រាង្លាប់​នទ្រែល​គ៝ប់ អ៝ន់​ខាន់​ពាង់​នៃ​ឆ៝ៈ​អេង​ទ្រាប់​នទើ​មា​ខាន់​ពាង់​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ជេស​នាវ​អី​នៃ​ឞ្រាស​យេហោវា​អ៝ន់​មា​អាប់រាម​ឆៃ​នទើ​តា​នាវ​តឹម​មពើល លាស​មា​ពាង់​កើត​នអា៖ “អើ​អាប់រាម ​មៃ​លើយ​ក្លាច​អោស យ៝រ​លាស​គ៝ប់​ជេង​ខេល​មា​មៃ នទ្រែល​មា​អ៝ន់​នទើ​ងខោម​ទុត​ក្វ៝ង់​មា​មៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","យើន​មា​អាប់រាម​អើស​មា​កោរាញ​ឞ្រាស​លាស៖ “អើ​ឞ្រាស​យេហោវា​អី​កោរាញ​គ៝ប់ ម៝ស​នទើ​មៃ​អ៝ន់​មា​គ៝ប់​ក៝ៈ​មោ​គែស​ខ្លៃ​ដ៝ង់ យ៝រ​លាស​គ៝ប់​មោ​អោស​គែស​ក៝ន ឞូនុយ្ស​អី​ទើន​ទ្រាប់​នទើ​ខ្លៃ​តា​ជៃ​គ៝ប់​ជេង​អេលេឆើរ​តាៈ​ឞើស​ប៝ន​ដាមាស​នៃ​ច្រាវ”។ ");
INSERT INTO cmok_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","អាប់រាម​លាស​តៃ៖ “មៃ​មោ​អោស​អ៝ន់​គ៝ប់​គែស​ក៝ន លាស​នទ្រី​ឞូនុយ្ស​អី​ទើន​ទ្រាប់​នទើ​ខ្លៃ​គ៝ប់​ជេង​ទឹក​អី​គុ​តា​ជៃ​គ៝ប់​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","យើន​មា​ឞ្រាស​យេហោវា​លាស​មា​អាប់រាម​កើត​នអា៖ “មោ​ទី​អោស​ឞូនុយ្ស​នៃ​ទើន​ទ្រាប់​នទើ​ខ្លៃ​មៃ ក៝ន​ឞូ​ក្លោ​មៃ​នើម​ជេង​ឞូនុយ្ស​ទើន​ទ្រាប់​នទើ​ខ្លៃ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ជេសរី​ឞ្រាស​យេហោវា​លែវ​អាប់រាម​លោស​អា​ទីស លាស​មា​ពាង់៖ “ល៝ង់​មៃ​ងើក​អ្វាញ់​ជឹត​ត្រោក​តី មៃ​ទើយ​ដ៝ង់​កើប​មាញ់​អី​តី? រាន៝យ​ទែស​មៃ​អ៝ក់​តឹម​ឞាន​មា​មាញ់​អី​តី​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","អាប់រាម​អ្យាត់​ញឆីង​នាវ​ឞ្រាស​យេហោវា​អី​នៃ យ៝រ​មា​នាវ​ពាង់​អ្យាត់​ញឆីង​នៃ​ទឹង​ឞ្រាស​យេហោវា​កើប​ពាង់​ជេង​ឞូនុយ្ស​ឆ៝ង់​ឆ្រាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ឞ្រាស​យេហោវា​លាស​តៃ​មា​អាប់រាម៖ “គ៝ប់​អ្យា​ឞ្រាស​យេហោវាគ៝ប់​លែវ​មៃ​ទូ​លោស​ឞើស​ប៝ន​អូរ​ឞ្រី​ខាលដេ  គៃ​មា​អ៝ន់​ឞ្រី​ទាក​អ្យា​មា​មៃ​ទើន”។ ");
INSERT INTO cmok_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","អាប់រាម​អោប៖ “អើ​ឞ្រាស​យេហោវា មើម​ទឹង​គ៝ប់​គឹត​លាស​គ៝ប់​ទើន​ឞ្រី​ទាក​អ្យា​ងាន់?” ");
INSERT INTO cmok_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ជេសរី​ឞ្រាស​យេហោវា​លាស​មា​ពាង់៖ “អ៝ន់​មៃ​ឆ៝ៈ​ទូ​មល៝ម់​នទ្រោក​មែ​អី​លែៈ​គែស​ពែ​នាម់ ឆ៝ៈ​ទូ​មល៝ម់​ឞែ​មែ​អី​លែៈ​គែស​ពែ​នាម់ ឆ៝ៈ​ទូ​មល៝ម់​ឞែ​ឞ្យាប់​ងក្វ៝ង់​អី​លែៈ​គែស​ពែ​នាម់ ទូ​មល៝ម់​នតើប នទ្រែល​មា​ទូ​មល៝ម់​ព្លុក​រាស​ញហើរ​អ៝ន់​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ជេសរី​អាប់រាម​ឆ៝ៈ​លែៈ​មពោមពា​(ឆ្យុម)​អី​នៃ​ព្លាស​ទូ​ដាស​ទូ​ដាស​តេៈ​តឹម​ញច្រឹង​ក្រែប​តា​រី អី​ឆ្យុម​នារ​រី​ពាង់​ងខឹត​ដ៝ង់​យើន​មា​មោ​ព្លាស​អោស។ ");
INSERT INTO cmok_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ជេសរី​គែស​គ្រ៝ត់​នអាក​ទ្រ៝ម់​ឆា​ព្វាច់​អី​នៃ យើន​មា​អាប់រាម​នត្រូ​លើយ​គ្រ៝ត់​នអាក​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ត៝ត់​ឞើយ​ញ៝ប់​នារ​រី អាប់រាម​ហាក់​ឞិច​ឆ្វេប ជេសរី​ពាង់​រាៈ​ឞោក​ក្វ៝ង់​ហោ​ងាន់ គែស​ង៝​ចេក​កោលាក់​ងកុម​តា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ជេសរី​ឞ្រាស​យេហោវា​លាស​មា​អាប់រាម៖ “អ៝ន់​មៃ​គឹត​នហេល​យឹ រាន៝យ​ទែស​មៃ​មរា​ទូ​គុ​តា​ទូ​ឞ្រី ឞ្រី​នៃ​មោ​អោស​ទី​ឞ្រី​ខាន់​ពាង់​នើម ខាន់​ពាង់​គុ​ជាន​ទឹក​ឞូ​តា​ឞ្រី​នៃ ឞូនុយ្ស​តា​ឞ្រី​នៃ​តុន​ជ៝ត​ខាន់​ពាង់​ជ៝ៈ ៤០០ នាម់ ");
INSERT INTO cmok_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","យើន​មា​គ៝ប់​តេៈ​ទោយ្ស​មា​ផូង​ឞូនុយ្ស​អី​តុន​ជ៝ត​រាន៝យ​ទែស​មៃ​នៃ ជេសរី​តៃ​ខាន់​ពាង់​ទូ​លោស​ឞើស​ឞ្រី​នៃ ញអោត​នអ៝ប់​មា​ទ្រាប់​នទើ​អ៝ក់​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","អី​មៃ​នៃ​តៃ ត៝ត់​មៃ​ខឹត​មៃ​ខឹត​មា​នាវ​ដាប់​មពាន់ ឞូ​មរា​ត៝ប់​មៃ ជេស​មៃ​រេស​លែៈ​រាញ​ងាន់​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ត៝ត់​តា​រានោក ៤ រី​មើ​រាន៝យ​ទែស​មៃ​ព្លឹ​ឆឹត​តៃ​តា​ឞ្រី​អ្យា យ៝រ​លាស​នាវ​តីស​ផូង​អាមោរី​អី​គុ​តា​ឞ្រី​អ្យា​អាបៃ​រី​អេ​ហ៝ៈ​អោស​ឞេង​អេ​ហ៝ៈ​អោស​ទី​មា​តេៈ​ទោយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ត៝ត់​នារ​លែៈ​ញ៝ប់ ឞ្រី​លែៈ​ង៝ តា​នៃ​ទោ​មា​ឆៃ​គែស​គ្លាស​ញហូក​អុញ នហ៝​មា​គែស​អុញ​ហីត​រ៝ៈ​វាស​វាង​ព្វាច់​អី​ព្លាសៗ​រី​នើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","តា​នារ​នៃ​ឞ្រាស​យេហោវា​តឹម​រាង្លាប់​មា​អាប់រាម ពាង់​លាស​មា​អាប់រាម៖ “គ៝ប់​អ៝ន់​ឞ្រី​ទាក​អ្យា​មា​រាន៝យ​ទែស​មៃ នតើម​ឞើស​ទាក​រាលាយ​ឞ្រី​អេឆីប ​រី ត៝ត់​មា​ទាក​រាលាយ​ក្វ៝ង់ ជេង​ទាក​រាលាយ​អើប្រាត ");
INSERT INTO cmok_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","គ៝ប់​អ៝ន់​ដ៝ង់​ឞ្រី​ទាក​ទឹង​លែៈ​ផូង​កែន ផូង​កេនិឆីត ផូង​កាត់មោនី ");
INSERT INTO cmok_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ផូង​ហេត ផូង​ពេរិឆីត ផូង​រេផែម ");
INSERT INTO cmok_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ផូង​អាមោរី ផូង​កានាន ផូង​គីរកាឆីត នទ្រែល​មា​ផូង​យេបូឆីត​អី​ហោម​គុ​អាបៃ​រី”។ ");
INSERT INTO cmok_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ឆារាយ ​អី​អូរ​អាប់រាម​រី​មោ​អោស​ឞាៈ​ក៝ន​មា​អាប់រាម។ ពាង់​គែស​ទូ​ហ្វេ​ទឹក​ឞូ​អូរ​ផូង​អេឆីប ​រាញា​ហាការ។ ");
INSERT INTO cmok_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ជេសរី​ឆារាយ ​លាស​មា​អាប់រាម៖ “យ៝រ​មា​ឞ្រាស​យេហោវា​មោ​អ៝ន់​គ៝ប់​គែស​ក៝ន លាស​នទ្រី​មៃ​ឆ៝ៈ​ទឹក​ឞូ​អូរ​គ៝ប់​នៃ​ទោ ក្លាប់​លាស​គ៝ប់​គែស​ទូ​ហ្វេ​ក៝ន​តាៈ​ឞើស​ពាង់”។ អាប់រាម​អ្យាត់​នាវ​អី​អូរ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ត៝ត់​អាប់រាម​លែៈ​គែស ១០ នាម់​គុ​តា​ឞ្រី​កានាន​នៃ ឆារាយ ​អី​អូរ​ពាង់​រី​ឆ៝ៈ​ហាការ​អី​ឞូ​អូរ​ផូង​អេឆីប ​ជេង​ទឹក​ពាង់​នើម​រី អ៝ន់​មា​អាប់រាម​អី​ឆាយ​ពាង់​រី​មា​ជាន​អូរ។ ");
INSERT INTO cmok_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","អាប់រាម​គុ​អូរ​ឆាយ​នទ្រែល​មា​ហាការ​រី ជេសរី​ហាការ​នត្រែវ។ ត៝ត់​មា​ហាការ​គឹត​លាស​ឆាក់​ពាង់​លែៈ​នត្រែវ ពាង់​នតើម​មឺច​រាម៝ត​កោរាញ​ឞូ​អូរ​ពាង់​នើម​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ឆារាយ ​លាស​មា​អាប់រាម៖ “យ៝រ​មា​មៃ​ទឹង​គ៝ប់​គែស​នាវ​ដីត​ព្រេង គ៝ប់​ឆ៝ៈ​ឞូ​អូរ​ទឹក​គ៝ប់​អ៝ន់​តា​នតើស​មៃ ត៝ត់​មា​ពាង់​គឹត​លាស​ឆាក់​ពាង់​លែៈ​នត្រែវ បេង​ពាង់​មា​មឺច​រាម៝ត​គ៝ប់​ច្រាវ។ លាស​នទ្រី​ទាន់​ឞ្រាស​យេហោវា​ឆើម​ផាត​ទោយ្ស​មា​ឞ៝ន់​ឞារ​ហៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ជេសរី​អាប់រាម​លាស​មា​ឆារាយ ៖ “ឞូ​អូរ​អ្យា​គុ​តា​ន៝ម់​អៃ លាស​នទ្រី​មើម​នាវ​អៃ​អុច​ជាន​មា​ពាង់ តឹង​អៃ​នើម​អុច”។ ជេសរី​ឆារាយ ​ជាន​ទាង់​ហោ​ងាន់​មា​ហាការ ត៝ត់​មា​ពាង់​ទូ​ញច្វាត់​ងាយ។ ");
INSERT INTO cmok_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ជេស​ពាង់​ទូ​ញច្វាត់​នៃ គែស​តោង​ពារ់​ឞ្រាស​យេហោវា​ហាន់​ម៝ប់​ហាការ​ទាច់​មា​ទូ​មល៝ម់​តូ​ទាក​តា​ឞ្រី​រាទាស​រី កេង​មែង​ត្រ៝ង​ហាន់​ជឹត​ឞ្រី​ឆូរ។ ");
INSERT INTO cmok_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","តោង​ពារ់​អោប​ហាការ​នៃ៖ “ហើយ​ហាការ​ទឹក​ឆារាយ  ឞើស​តាៈ​អៃ​នៃ អាស​ជឹត​លែត​ហាន់​អៃ​នៃ​អេស?” ហាការ​អើស៖ “គ៝ប់​ទូ​ញច្វាត់​ឞើស​ឆារាយ ​កោរាញ​គ៝ប់​នើម​លាស”។ ");
INSERT INTO cmok_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","តោង​ពារ់​ឞ្រាស​យេហោវា​លាស​មា​ពាង់៖ “អ៝ន់​អៃ​ឆឹត​អា​ជៃ​កោរាញ​អៃ​នើម​រី អ្យាត់​នាវ​ពាង់​ទោ”។ ");
INSERT INTO cmok_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","តោង​ពារ់​ឞ្រាស​យេហោវា​នៃ​លាស​តៃ​ដ៝ង់​មា​ពាង់៖ “តៃ​ទឹង​គ៝ប់​ជាន​រាន៝យ​ទែស​អៃ​អ៝ន់​ឞឹក​រឹ​ទុត​អ៝ក់​ងាន់​មោ​ហោម​អោស​ទើយ​កើប”។ ");
INSERT INTO cmok_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","តោង​ពារ់​ឞ្រាស​យេហោវា​នៃ​លាស​តៃ​មា​ពាង់​ដ៝ង់៖ “អាបៃ​រី​អៃ​លែៈ​នត្រែវ​ជេស អៃ​តៃ​គុ​អ៝ស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ ជេសរី​អ៝ន់​អៃ​តេៈ​រាញា​ពាង់​អីសមាអែល គែស​នាវ​ខ្លៃ​លាស​«កោរាញ​ឞ្រាស​តាង់» យ៝រ​លាស​ឞ្រាស​យេហោវា​លែៈ​តាង់​នាវ​អៃ​នតែរ​ទោល​អៃ​គែស​នាវ​ជេរ​ជ៝ត់​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ក៝ន​អី​នៃ​ជាន​នទើ​តឹង​នូយ្ស​នហ៝ម់​ពាង់​នើម​អុច​ទើម តឹម​ឞាន​មា​មពោមពា​(ឆ្យុម)​ឞ្រី​ដ៝ង់។ ពាង់​តឹម​លើស​ដាស​មា​លែៈ​រាងោច​ឞូនុយ្ស ជេសរី​លែៈ​រាងោច​ឞូនុយ្ស​តឹម​លើស​ដាស​ពាង់​ដ៝ង់។ ពាង់​មោ​អោស​គុ​នទ្រែល​នទុល​មពោល​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ហាការ​តេៈ​រាញា​ឞ្រាស​យេហោវា​អី​ងើយ​មា​ពាង់​នៃ «កោរាញ​ឞ្រាស​អី​អ្វាញ់​ឆៃ» យ៝រ​លាស​ហាការ​មឹន​អេង៖ “នតុក​អ្យា​គ៝ប់​លែៈ​ឆៃ​កោរាញ​ឞ្រាស ជេសរី​ពាង់​អ្វាញ់​ឆៃ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","កើត​នទ្រី​ទឹង​ឞូ​ក្វាល់​តូ​ទាក​នៃ​រាញា «តូ​ទាក​លាហាយរ៝យ» គែស​នាវ​ខ្លៃ​លាស «តូ​ទាក​ឞ្រាស​រេស​ងាន់​អី​អ្វាញ់​ឆៃ​គ៝ប់»។ តូ​ទាក​អី​នៃ​វាស​វាង​ប៝ន​កាដែស មា​ប៝ន​ពារែត។ ");
INSERT INTO cmok_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ជេសរី​ហាការ​គុ​អ៝ស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ពាង់​ដាស​អាប់រាម ។ អាប់រាម​តេៈ​រាញា​ក៝ន​នៃ​«អីសមាអែល»។ ");
INSERT INTO cmok_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","នោក​ហាការ​ទែស​អីសមាអែល​នៃ អាប់រាម​លែៈ​គែស ៨៦ នាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ត៝ត់​អាប់រាម​លែៈ​គែស ៩៩ នាម់ ឞ្រាស​យេហោវា​តឹម​មពើល​អ៝ន់​ពាង់​ឆៃ ពាង់​លាស​មា​អាប់រាម៖ “គ៝ប់​ជេង​ឞ្រាស​អី​ទុត​គែស​នាវ​ទើយ អ៝ន់​មៃ​អ្យាត់​នាវ​គ៝ប់ គុ​អ្វែស​ឆ៝ង់​ឆ្រាង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","គ៝ប់​អុច​តឹម​រាង្លាប់​ដាស​មៃ អុច​ជាន​រាន៝យ​ទែស​មៃ​អ៝ន់​ឞឹក​រឹ​ទុត​អ៝ក់”។ ");
INSERT INTO cmok_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","អាប់រាម​ពាន់​ក្រាប​អា​នែស​ឆូ ជេសរី​កោរាញ​ឞ្រាស​លាស​មា​ពាង់​ជឹត៖ ");
INSERT INTO cmok_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“អ្យា​នាវ​គ៝ប់​តឹម​រាង្លាប់​នទ្រែល​មៃ​កើត​នអា មៃ​តៃ​ជេង​ចែ​មា​ផូង​ឞូនុយ្ស​ទុត​អ៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ឞូ​មោ​ហោម​អោស​ក្វាល់​មៃ «អាប់រាម»​ជឹត គែស​នាវ​ខ្លៃ «ឞឹ​ក្វ៝ង់» ឞូ​ក្វាល់​មៃ «អាឞ្រាហាម់ » គែស​នាវ​ខ្លៃ «ឞឹ​ផូង​ឞូនុយ្ស​ទុត​អ៝ក់» យ៝រ​លាស​គ៝ប់​អ៝ន់​មៃ​ជេង​ឞឹ​មា​ផូង​ឞូនុយ្ស​ទុត​អ៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","គ៝ប់​ជាន​អ៝ន់​មៃ​គែស​ក៝ន​គែស​ឆៅ​ទុត​អ៝ក់ គ៝ប់​អ៝ន់​រាន៝យ​ទែស​មៃ​ជេង​គែស​ផូង​អ៝ក់​ងាន់ នទ្រែល​មា​អ៝ន់​គែស​កាដាច់​អាបាៈ​តាៈ​ឞើស​រាន៝យ​ទែស​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","គ៝ប់​តឹម​រាង្លាប់​មា​មៃ​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​មៃ​ឞើស​កើយ​ឞើស​កើយ​តឹម​អាប់​រានោក។ នាវ​តឹម​រាង្លាប់​អ្យា​ហោម​នហ៝​រ៝។ គ៝ប់​ជេង​ឞ្រាស​មៃ នហ៝​មា​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​មៃ​ឞើស​កើយ​ឞើស​កើយ​រី​តៃ ");
INSERT INTO cmok_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","គ៝ប់​អ៝ន់​ទឹង​លែៈ​ឞ្រី​ទាក​កានាន​អី​មៃ​វែស​គុ​អ្យា​ជេង​ឞ្រី​ទាក​មៃ​នហ៝​រ៝ នទ្រែល​មា​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​មៃ​ឞើស​កើយ​ឞើស​កើយ​តៃ​ដ៝ង់ ជេសរី​គ៝ប់​ជេង​ឞ្រាស​មា​ក៝ន​ឆៅ​មៃ​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","កោរាញ​ឞ្រាស​លាស​មា​អាឞ្រាហាម់ ៖ “ល៝ង់​អី​មៃ​នៃ អ៝ន់​មៃ​ញអោត​នាវ​តឹម​រាង្លាប់​គ៝ប់ នអ៝ប់​មា​មៃ​នើម​នហ៝​រ៝ នអ៝ប់​មា​ក៝ន​មា​ឆៅ​មៃ​ឞើស​កើយ​ឞើស​កើយ​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","អ្យា​នាវ​តឹម​រាង្លាប់​អី​គ៝ប់​អ៝ន់​មា​ខាន់​អៃ​មៃ​ញអោត នទ្រែល​មា​ក៝ន​មា​ឆៅ​ខាន់​អៃ​មៃ​នៃ អ៝ន់​លែៈ​ក៝ន​ឞូ​ក្លោ​តា​ផូង​ខាន់​អៃ​មៃ​អ៝ន់​ក៝ស​នតោ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","អ៝ន់​ខាន់​អៃ​មៃ​ក៝ស​តា​ចោង​នតោ​នទើ​ឞូ​ក្លោ​រី អី​នៃ​ជេង​នទើ​មឞេន​នាវ​តឹម​រាង្លាប់​គ៝ប់​អ៝ន់​មា​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ទឹង​លែៈ​ក៝ន​ឞូ​ក្លោ​អ្យាត់​មា​ត៝ត់​ផាម​នារ​ជេស​ទែស ជាន​ក៝ស​នតោ​ទាទេ ឞ៝ល​លាស​ទឹក​ទែស​តា​ជៃ​ខាន់​អៃ​មៃ​នើម​កាដោយ​លែៈ ឞ៝ល​លាស​ទឹក​រាវាត់​ឞើស​ឞូ​នាច់​ផូង​ឞ្រី​អេង​កាដោយ​លែៈ ជាន​នាវ​អ្យា​នហ៝​រ៝​តឹម​អាប់​រានោក​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ទឹង​លែៈ​ទឹក​ឞូ​ក្លោ​ទែស​តា​ជៃ​ខាន់​អៃ​មៃ​នើម មោ​លាស​ទឹក​រាវាត់​មា​ព្រាក់​កាដោយ ជាន​ក៝ស​នតោ​ទាទេ អី​នៃ​ជេង​នទើ​មឞេន​នាវ​តឹម​រាង្លាប់​គ៝ប់​អ៝ន់​មពែស​មា​ឆាក់​ជាន់​ខាន់​អៃ​មៃ​ហោម​នហ៝​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","លាស​ឞូ​ម៝ស​ឞូ​ក្លោ​អី​មោ​អោស​ក៝ស​នតោ​តា​ឆាក់​ពាង់​រី មោ​ហោម​អោស​កើប​ពាង់​ជេង​ផូង​ប៝ន​លាន​ខាន់​អៃ​មៃ​ជឹត យ៝រ​លាស​ពាង់​លែៈ​មអារ់​លើយ​នាវ​តឹម​រាង្លាប់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","កោរាញ​ឞ្រាស​លាស​មា​អាឞ្រាហាម់ ​ជឹត៖ “ឆារាយ ​អូរ​មៃ​នៃ មៃ​មោ​ហោម​អោស​ក្វាល់​ពាង់​ឆារាយ ​ជឹត ក្វាល់​ពាង់ «ឆារា»​ហ៝ៈ។ ");
INSERT INTO cmok_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","គ៝ប់​អ៝ន់​នាវ​គែស​ជេង​មា​ពាង់ គ៝ប់​អ៝ន់​មៃ​គែស​ទូ​មល៝ម់​ក៝ន​ឞូ​ក្លោ​តាៈ​ឞើស​ពាង់។ គ៝ប់​អ៝ន់​នាវ​គែស​ជេង​មា​ពាង់ ជេសរី​រាន៝យ​ទែស​ពាង់​ជេង​ផូង​ឞ្រី​អេងៗ នទ្រែល​មា​គែស​កាដាច់​អាបាៈ​តា​រាន៝យ​ទែស​ពាង់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ជេសរី​អាឞ្រាហាម់ ​ក្រាប​ពាន់​អា​នែស​ឆូ គើម​អេង​តា​នូយ្ស​នហ៝ម់​រី​លាស៖ “ឞូ​ក្លោ​លែៈ ១០០ នាម់ អើម​ហោម​ឞ្លាវ​គែស​ក៝ន​លាស? ល៝ង់​ឆារា​លែៈ ៩០ នាម់ គឹត​មា​ហោម​ឞាៈ​ក៝ន​លាស?” ");
INSERT INTO cmok_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","អាឞ្រាហាម់ ​លាស​មា​កោរាញ​ឞ្រាស៖ “លាស​មៃ​អ៝ន់​អីសមាអែល​ទើន​នាវ​ត៝ន​មៃ​អ្យា លែៈ​គាប់​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","កោរាញ​ឞ្រាស​លាស​មា​អាឞ្រាហាម់ ៖ “មោ​អោស យ៝រ​លាស​អូរ​មៃ​ឆារា​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​មា​មៃ! អ៝ន់​មៃ​តេៈ​រាញា​ពាង់ «អីឆាក់» គែស​នាវ​ខ្លៃ​«គើម»។ គ៝ប់​តឹម​រាង្លាប់​មា​ពាង់ ជេង​នាវ​តឹម​រាង្លាប់​ហោម​នហ៝​រ៝​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ល៝ង់​អីសមាអែល​អី​នៃ លែៈ​គ៝ប់​តាង់​នាវ​មៃ​លាស តៃ​គ៝ប់​អ៝ន់​នាវ​គែស​ជេង​មា​ពាង់ គ៝ប់​ជាន​អ៝ន់​ពាង់​គែស​ក៝ន​គែស​ឆៅ​ឞឹក​រឹ​ទុត​អ៝ក់។ គ៝ប់​អ៝ន់​គែស​កាដាច់ ១២ នុយ្ស​តាៈ​ឞើស​រាន៝យ​ទែស​ពាង់ នទ្រែល​មា​អ៝ន់​រាន៝យ​ទែស​ពាង់​ជេង​ទូ​ផូង​ឞ្រី​ទាក​ទុត​ក្វ៝ង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","យើន​មា​គ៝ប់​តឹម​រាង្លាប់​ដាស​មា​អីឆាក់​ក៝ន​ឆារា ពាង់​ទែស​នាម់​តៃ ខៃ​អ្យា​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ជេស​លែៈ​ផ្យៅ​កោរាញ​ឞ្រាស​ងើយ​នទ្រែល​មា​អាឞ្រាហាម់  ជេសរី​ពាង់​ទូ​ឞើស​នតុក​នៃ​យ៝ត​ក្ល៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ជេសរី​អាឞ្រាហាម់ ​លែវ​អីសមាអែល លែវ​លែៈ​រាងោច​ផូង​ទឹក​ទែស​តា​ជៃ​ពាង់​រី នអ៝ប់​មា​ផូង​ទឹក​អី​ពាង់​រាវាត់​មា​ព្រាក់ ទឹង​លែៈ​ឞូ​ក្លោ​អី​គុ​តា​ជៃ​ពាង់​រី ពាង់​ក៝ស​នតោ​តា​នារ​នៃ​ទាទេ ពាង់​ជាន​កើត​នាវ​កោរាញ​ឞ្រាស​ទែ​ដាៈ​មា​ពាង់​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","នោក​អាឞ្រាហាម់ ​ក៝ស​នតោ ពាង់​លែៈ​គែស ៩៩ នាម់ ");
INSERT INTO cmok_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","យើន​មា​អីសមាអែល​អី​ក៝ន​ពាង់​រី លែៈ​គែស ១៣ នាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","អាឞ្រាហាម់  នទ្រែល​មា​អីសមាអែល​ក៝ស​នតោ​ទូ​នារ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","នអ៝ប់​មា​លែៈ​រាងោច​ផូង​ឞូ​ក្លោ​អី​គុ​តា​ជៃ​ពាង់​រី ផូង​ទឹក​ទែស​តា​ជៃ​ពាង់ ផូង​ទឹក​ពាង់​រាវាត់​មា​ព្រាក់​ឞើស​ផូង​ឞូ​នាច់​ឞ្រី​អេង​កាដោយ ខាន់​ពាង់​ក៝ស​នតោ​នទ្រែល​មា​អាឞ្រាហាម់ ​ទាទេ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ជេសរី​ឞ្រាស​យេហោវា​តឹម​មពើល​អ៝ន់​មា​អាឞ្រាហាម់ ​ឆៃ​តៃ​តា​តើម​ជ្រី​មាម់រេ​រី ទោល​អាឞ្រាហាម់ ​គុ​តា​ឞោក​មពោង​ចូន​ពាង់​នើម​រី នោក​នារ​ងក្លាង​ឞោក។ ");
INSERT INTO cmok_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ជេសរី​អាឞ្រាហាម់ ​ងើក​ឆៃ​ឞូនុយ្ស​ពែ​នុយ្ស​ទ៝ក់​ឞើស​នាប់​ពាង់​រី។ ត៝ត់​មា​ឆៃ​ខាន់​ពាង់ ពាង់​ញច្វាត់​ឞើស​មពោង​ចូន​ពាង់​នើម​នៃ​ហាន់​រាន​អា​ខាន់​ពាង់​ពាន់​អា​នែស​ឆូ តឹង​នាវ​វៃ​អោប​អ្វែស​លាង់​មា​កោរាញ។ ");
INSERT INTO cmok_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ជេសរី​ពាង់​លាស៖ “អើ​កោរាញ លាស​ខាន់​មៃ​រ៝ង់​មា​គ៝ប់​ងាន់ ទាន់​ប៝ត់​ហ៝ៈ​អោស​នហ៝ត​ឞើស​គ៝ប់​ជេង​ឞូនុយ្ស​តា​ន៝ម់​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","អ៝ន់​គ៝ប់​ដាៈ​ឞូ​ឆ៝ៈ​ទាក​ដេៈ​មា​រាវ​ជ៝ង់​ខាន់​មៃ ទាន់​ខាន់​មៃ​គុ​រាលូ​តា​ន៝ម់​តើម​ឆី​អ្យា​ប៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","គ៝ប់​ហាន់​ឆ៝ៈ​នទើ​ឆោង​ឆា​ដេៈ​ដាៈ​ខាន់​មរែ​មា​ឆោង មា​គែស​ឆ្វាន​ខាន់​មៃ​មា​ហាន់​ជឹត​នាប់​ជឹត លែៈ​ខាន់​មៃ​មា​ត៝ត់​តា​នតុក​គ៝ប់​អ្យា”។ ជេសរី​ពែ​នុយ្ស​ខាន់​ពាង់​នៃ​លាស​មា​ពាង់៖ “ជាន​ហ៝ម់​កើត​នាវ​មៃ​លាស​រី”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ជេសរី​អាឞ្រាហាម់ ​ហាន់​តា​ចូន​រី​រ៝ មឞើស​មា​ឆារា​អី​អូរ​ពាង់​នើម៖ “អៃ​ឆ៝ៈ​រានីស​មោយ​ពែ​ប្វាត់ ម៝ន​ជាន​នុមពាង់​អ៝ន់​គើញ​អ៝យ”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","អាឞ្រាហាម់ ​នើម​រី​ហាន់​ញច្វាត់​តា​ផូង​មពោមពា​(ឆ្យុម)​ជ៝យ​ទូ​មល៝ម់​ក៝ន​នទ្រោក​លៃ​អ្វែស​ងាន់ អ៝ន់​ឞូនុយ្ស​ជាន​ការ​មា​ពាង់​ទូ​ហ្វេ​ជាន ឞូនុយ្ស​ជាន​ការ​អី​នៃ​ឆ៝ៈ​ជាន​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ជេសរី​អាឞ្រាហាម់ ​ឆ៝ៈ​ងី​ទាក​ត៝ស​នទ្រោក ឆ៝ៈ​ទាក​ត៝ស​នទ្រោក នទ្រែល​មា​ឆ៝ៈ​ព្វាច់​ក៝ន​នទ្រោក​អី​ឞូ​ជាន​ត្រាវ​រី​នើស លែវ​អ៝ន់​តា​នាប់​មពោល​ពែ​នុយ្ស​នៃ​ឆោង​ឆា។ ជេសរី​ខាន់​ពាង់​អី​នៃ​ឆោង​ឆា អាឞ្រាហាម់ ​នើម​រី​ហោម​គុ​នទ្រែល មា​ឆើម​ឆ៝ៈ​នទើ​ឆោង​ឆា​មា​ខាន់​ពាង់​តា​ន៝ម់​តើម​ឆី​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ជេសរី​មពោល​ពែ​នុយ្ស​នៃ​អោប​អាឞ្រាហាម់ ៖ “អាស​ឆារា​អូរ​មៃ​នៃ?” អាឞ្រាហាម់ ​អើស​មា​ខាន់​ពាង់៖ “ពាង់​គុ​អា​ត្រោម​ចូន​ត៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ជេសរី​ឞ្រាស​យេហោវា​លាស​មា​អាឞ្រាហាម់ ៖ “នាម់​ជឹត​នាប់​ក្លាប់​លាស​តា​ខៃ​អ្យា​ដ៝ង់ ហេន​ហាន់​ម៝ប់​មៃ​ទូ​តឹ​តៃ​ជឹត តា​នោក​រី​តៃ​ឆារា​លែៈ​គែស​ទូ​មល៝ម់​ក៝ន​ឞូ​ក្លោ”។ ឆារា​គុ​អ្យាត់​តាង់​នាវ​ខាន់​ពាង់​ងើយ​តា​ឞោក​មពោង​ឞើស​កើយ​អាឞ្រាហាម់ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","អាឞ្រាហាម់  នទ្រែល​មា​ឆារា​លែៈ​រាញៗ​ងាន់ ឆារា​លែៈ​ឞាស​គែស​ឆាក់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","នទ្រី​ឆារា​គើម​លាស​អេង​តា​នូយ្ស​នហ៝ម់​រី៖ “ឆាក់​លែៈ​រាញ​ទាស​អ្យា​ជេស ល៝ង់​ឆាយ​គ៝ប់​លែៈ​រាញ​ងាន់​ដ៝ង់ គ៝ប់​អើម​ហោម​រ៝ង់​មា​នាវ​មអាក​លាស?” ");
INSERT INTO cmok_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ឞ្រាស​យេហោវា​លាស​មា​អាឞ្រាហាម់ ៖ “មើម​ទឹង​ឆារា​គើម? នអ៝ប់​មា​លាស «គ៝ប់​លែៈ​រាញ​ងាន់​អើម​ហោម​គែស​ក៝ន​លាស?» ");
INSERT INTO cmok_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","អើម​គែស​លាស​នទើ​ឞ្រាស​យេហោវា​ជាន​មោ​ឞ្លាវ? ត៝ត់​អាប់​ខៃ​រី​តៃ​ហេន​ហាន់​ម៝ប់​តៃ​មៃ នោក​នៃ​ឆារា​គែស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","យើន​មា​ឆារា​រាលាច់​លាស៖ “មោ​អោស គ៝ប់​មោ​អោស​ព្រ៝ត​គើម” ទឹង​ពាង់​លាស​កើត​នៃ យ៝រ​លាស​ពាង់​លែៈ​ក្លាច។ ឞ្រាស​យេហោវា​លាស​មា​ពាង់៖ “មោ​អោស អៃ​លែៈ​គើម​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ជេសរី​ពែ​នុយ្ស​ខាន់​ពាង់​នៃ​ទ៝ក់​ហាន់ ខាន់​ពាង់​ងគឹល​អ្វាញ់​ជឹត​ប៝ន​ឆោដុម​រី អាឞ្រាហាម់ ​ហាន់​នទ្រែល​ដ៝ង់​គៃ​មា​ញជុន​ខាន់​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","នោក​នៃ​ឞ្រាស​យេហោវា​លាស៖ “នាវ​គ៝ប់​នទ្រាប់​អុច​ជាន​អ្យា គ៝ប់​មោ​អោស​ម៝​មា​អាឞ្រាហាម់  ");
INSERT INTO cmok_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","យ៝រ​លាស​អាឞ្រាហាម់ ​តៃ​ជេង​ឞឹ​មា​ទូ​ផូង​ឞ្រី​ទាក​អី​ទុត​ក្វ៝ង់ នអ៝ប់​មា​គែស​នាវ​ទើយ​ដ៝ង់ លែៈ​រាងោច​ឞ្រី​ទាក​តា​នែស​នតូ​អ្យា​មរា​ឆ៝ៈ​ទើន​នាវ​គែស​ជេង​តាៈ​ឞើស​ពាង់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","លែៈ​គ៝ប់​កើយ្ស​ជេស​ពាង់​គៃ​មា​អ៝ន់​ពាង់​នតុម​នតី​ក៝ន​ឞូ​ក្លោ​ពាង់ នទ្រែល​មា​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​ពាង់​ឞើស​កើយ​ឞើស​កើយ​តៃ អ៝ន់​ញអោត​ន៝ប់​ត្រ៝ង​ឞ្រាស​យេហោវា គៃ​មា​គុ​ងាវ​តឹម​ទី នទ្រែល​មា​អ៝ន់​ឆ៝ង់។ លាស​ក៝ន​ឆៅ​ពាង់​ជាន​កើត​នអា​ងាន់ គ៝ប់​ជាន​ទឹង​លែៈ​នាវ​គ៝ប់​ត៝ន​មា​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ជេសរី​ឞ្រាស​យេហោវា​លាស៖ “យ៝រ​លាស​នាវ​ឞូ​លាស​មា​ប៝ន​ឆោដុម នទ្រែល​មា​ប៝ន​កោមោរា​លែៈ​ហោ​ងាន់​ឞូនុយ្ស​តា​ប៝ន​នៃ​ជាន​តីស​ទុត​អ៝ក់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","លាស​នទ្រី​គ៝ប់​អុច​ហាន់​ជុរ​អ្វាញ់ គៃ​មា​គឹត​នាវ​ឞូ​ជាន​តា​នៃ​ជេង​ទី​កើត​នាវ​គ៝ប់​លែៈ​តាង់​លាស​មោ។ លាស​មោ​ងាន់​គ៝ប់​អុច​គឹត​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ជេសរី​ឞារ​ហៃ​ហាន់​រាប៝ង់​ជឹត​ប៝ន​ឆោដុម​រី។ អាឞ្រាហាម់ ​រី​ហោម​ទ៝ក់​នទ្រែល​មា​ឞ្រាស​យេហោវា​តា​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","អាឞ្រាហាម់ ​ហាន់​ទាច់​អោប​ឞ្រាស​យេហោវា៖ “អើម​មៃ​លើស​លើយ​ងាន់​លាស ឞូនុយ្ស​ឆ៝ង់ នទ្រែល​មា​ឞូនុយ្ស​តីស? ");
INSERT INTO cmok_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","លាស​គែស ៥០ នុយ្ស​ឞូនុយ្ស​ឆ៝ង់​គុ​តា​ប៝ន​អី​នៃ អាស​មៃ​លើស​លើយ​ដ៝ង់​ប៝ន​អី​នៃ​បាស? លាស​នទ្រី​មៃ​មោ​យោៈ​មា​ប៝ន​អី​នៃ​យ៝រ​មា​គែស​ឞូនុយ្ស​ឆ៝ង់ ៥០ នុយ្ស​គុ​តា​ប៝ន​អី​នៃ? ");
INSERT INTO cmok_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","លាស​មៃ​លើស​កើត​នៃ ជេង​លើស​លើយ​ឞូនុយ្ស​ឆ៝ង់​នទ្រែល​មា​ឞូនុយ្ស​តីស​មោ​ជេង​វាៈ លាស​លើស​កើត​នៃ​មៃ​ហោម​តេៈ​ទោយ្ស​ឞូនុយ្ស​ឆ៝ង់​ជេង​តឹម​ឞាន​មា​ឞូនុយ្ស​តីស មោ​ជេង​វាៈ។ ជាន​កើត​នៃ​អើម​ទី​កោរាញ​ផាត​ទោយ្ស​មា​លែៈ​រាងោច​នែស​នតូ​លាស?” ");
INSERT INTO cmok_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ជេសរី​ឞ្រាស​យេហោវា​លាស៖ “លាស​គ៝ប់​ឆៃ​គែស ៥០ នុយ្ស​ឞូនុយ្ស​ឆ៝ង់​គុ​តា​ប៝ន​ឆោដុម​នៃ គ៝ប់​មោ​លើស​អោស គ៝ប់​យោៈ​មា​ប៝ន​អី​នៃ​យ៝រ​មា​ឞូនុយ្ស ៥០ នុយ្ស​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","អាឞ្រាហាម់ ​ងើយ​មា​ឞ្រាស​យេហោវា​ជឹត៖ “គ៝ប់​អ្យា​ជេង​នែស​មោយ នទ្រែល​មា​អុញ​ឞុស​ទើម​មោ​គែស​នាវ​ខ្លៃ ទាន់​មៃ​លើយ​ក្លាប់​នទាង់​នាវ​តីស​គ៝ប់​ហោម​ងើយ​ជឹត​មា​មៃ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","លាស​តា​ប៝ន​អី​នៃ​មោ​អោស​ត៝ត់ ៥០ នុយ្ស គែស ៤៥ នុយ្ស​ទើម លាស​នទ្រី​មៃ​លើស​ប៝ន​នៃ​យ៝រ​មា​ហោម​អែ​ព្រាម់​នុយ្ស​អេ​ហ៝ៈ​រឹង​នៃ​ឞើស?” ពាង់​អើស៖ “លាស​គ៝ប់​ឆៃ​គែស ៤៥ នុយ្ស​ឞូនុយ្ស​ឆ៝ង់ គ៝ប់​មោ​លើស​អោស”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","អាឞ្រាហាម់ ​ងើយ​តៃ​មា​ឞ្រាស​យេហោវា៖ “ក្លាប់​លាស​គែស ៤០ នុយ្ស​ទើម”។ ពាង់​លាស៖ “គ៝ប់​មោ​លើស​អោស យ៝រ​មា​ផូង ៤០ នុយ្ស​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","អាឞ្រាហាម់ ​ងើយ​ជឹត៖ “ទាន់​មៃ​លើយ​ជី​នូយ្ស​មា​គ៝ប់ គ៝ប់​ទាន់​ងើយ​មា​មៃ​ទូ​តឹ​ជឹត។ ក្លាប់​លាស​គែស ៣០ នុយ្ស​ទើម”។ ពាង់​លាស៖ “លាស​គ៝ប់​ឆៃ​គែស ៣០ នុយ្ស គ៝ប់​មោ​លើស​អោស”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","អាឞ្រាហាម់ ​ងើយ​ជឹត៖ “ទាន់​មៃ​លើយ​ក្លាប់​នទាង់​នាវ​គ៝ប់​ហោម​ងើយ​នទ្រែល​មៃ​អ្យា ក្លាប់​លាស​គែស ២០ នុយ្ស​ទើម”។ ពាង់​លាស៖ “គ៝ប់​មោ​លើស​អោស យ៝រ​មា​ផូង ២០ នុយ្ស​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","អាឞ្រាហាម់ ​ងើយ​ជឹត៖ “ទាន់​កោរាញ​ឞ្រាស​លើយ​ជី​នូយ្ស​មា​គ៝ប់ គ៝ប់​ទាន់​ងើយ​ហោម​ទូ​តឹ​អ្យា​ទើម។ ក្លាប់​លាស​គែស​ជឹត​នុយ្ស​ទើម”។ ពាង់​លាស៖ “គ៝ប់​មោ​លើស​អោស យ៝រ​មា​ផូង​ជឹត​នុយ្ស​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ជេស​លែៈ​ផ្យៅ​ឞ្រាស​យេហោវា​ងើយ​នទ្រែល​អាឞ្រាហាម់ ​រី ពាង់​ហាន់​យ៝ត​ក្ល៝ក់​ឞើស​នតុក​នៃ ជេសរី​អាឞ្រាហាម់ ​ព្លឹ​ឆឹត​តៃ​តា​ចូន​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ត៝ត់​កេង​មាង់​រី ឞារ​ហៃ​តោង​ពារ់​នៃ​ហាន់​ត៝ត់​តា​ប៝ន​ឆោដុម។ លុត ​គុ​តា​ឞោក​មពោង​ប៝ន​នៃ ត៝ត់​មា​ឆៃ​តោង​ពារ់​ឞារ​ហៃ​នៃ ពាង់​រាន​ច្វាៈ​នហ៝​មា​ពាន់​ក្រាប​អា​នែស​ឆូ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ពាង់​លាស​មា​ឞារ​ហៃ​តោង​ពារ់​នៃ៖ “អើ​កោរាញ គ៝ប់​ជេង​ឞូនុយ្ស​តា​ន៝ម់​ខាន់​មៃ ហាន់​លាប់​អា​ជៃ​គ៝ប់​ប៝ត់ គៃ​មា​រាវ​ជ៝ង់​ខាន់​មៃ ជេសរី​ឞិច​តា​អ្យា​ទូ​មាង់ ក៝ប់​អោយ​តៃ​ទឹង​ទ៝ក់​អើម​អោយ​ហាន់​ជឹត”។ យើន​មា​តោង​ពារ់​នៃ​អើស​មា​ពាង់៖ “មោ​អោស មាង់​អ្យា​ហេន​ឞិច​តា​ជ៝ង់​គូង​ប៝ន”។ ");
INSERT INTO cmok_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","យ៝រ​មា​លុត ​ទាន់​ហោ​ងាន់ នទ្រី​ទឹង​មពោល​តោង​ពារ់​នៃ​ហាន់​ឞិច​អា​ជៃ​ពាង់ ពាង់​នទ្រាប់​នទើ​ឆោង​ឆា​អ្វែស ដាៈ​ឞូ​គុច​នុមពាង់​មោ​គែស​នទ្រូយ​អ៝ន់​មា​មពោល​តោង​ពារ់​នៃ ជេសរី​មពោល​តោង​ពារ់​នៃ​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ទោល​ខាន់​ពាង់​អេ​ហ៝ៈ​ឞិច​អោស ទឹង​លែៈ​ឞូនុយ្ស​តា​ប៝ន​នៃ លែៈ​រាងោច​ឞូ​ក្លោ​តា​ប៝ន​ឆោដុម​រី នតើម​ឞើស​ឞូ​នទាម់​ត៝ត់​មា​ឞូ​រាញ លែវ​ឞាល់​ហាន់​ញជ្វែង​ជៃ​លុត ​រី​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ផូង​អី​នៃ​នតែរ​អោប​លុត ៖ “អាស​គុ​ឞូនុយ្ស​អី​លាប់​តា​ជៃ​មៃ​មាង់​អ្យា​នើស​មេស? ហាន់​មៃ​ងលោស​ខាន់​ពាង់​មា​ហេន ហេន​ទែ​មា​តឹម​ហាវ​ដាស​ខាន់​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ជេសរី​លុត ​លោស​អា​ទីស​ទ៝ក់​ឞើស​ទីស​មពោង​រី ពាង់​នតឹល​មពោង​ឞើស​កើយ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ពាង់​លាស៖ “អើ​អ៝ស​នោ គ៝ប់​ទាន់​ទោយ្ស​មា​ខាន់​មៃ​ខឹត​អោម​លោម​លាៈ​ងាន់ លើយ​ជាន​អ្យើស​កើត​នៃ! ");
INSERT INTO cmok_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","គ៝ប់​គែស​ក៝ន​ឞូ​អូរ​ទ្រោស​ឞារ​ហៃ អេ​ហ៝ៈ​ដាស​ឞូ​អោស គ៝ប់​អ៝ន់​ខាន់​ពាង់​មា​ខាន់​មៃ ទាស​ខាន់​មៃ​អុច​ជាន អ្យាត់​មា​ខាន់​មៃ​លើយ​លើស​មា​ឞារ​ហៃ​ខាន់​ពាង់​អ្យា យ៝រ​លាស​ខាន់​ពាង់​លែៈ​វែស​ឞិច​តា​ជៃ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ឞូ​លាស​មា​ពាង់៖ “ទុ​មៃ​អ្យាៈ!” ជេសរី​ឞូ​លាស​តៃ​ពាង់​ជឹត៖ “មៃ​អី​នៃ​មោ​អោស​ទី​ផូង​ហេន មើម​អាបៃ​រី​អុច​ជាន​កោរាញ​ហេន? លាស​នទ្រី​លើស​អ្យើស​មៃ​អ៝ន់​ហោ​រាលាវ​មា​ឞារ​ហៃ​នៃ​ជឹត”។ ជេសរី​ឞូ​នត្រោល​លុត ​ទុត​ហោ លាប់​អុច​មា​មព្លុង​មពោង​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","យើន​មា​តោង​ពារ់​ទែ​ឆូក​តី​មផ៝ក់​លុត ​លាប់​អា​ត្រោម​ជៃ ជេសរី​នតឹល​មពោង។ ");
INSERT INTO cmok_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ជេស​ឞើស​នៃ​តោង​ពារ់​ទែ​ជាន​ចែស​ត្រោម​មាត់​ផូង​អី​គុ​តា​ឞោក​មពោង​រី​អ៝ន់​ចែស​ទាទេ នតើម​ឞើស​ឞូ​ជេៈ​ត៝ត់​មា​ឞូ​ក្វ៝ង់ នទ្រី​ទឹង​ផូង​អី​នៃ​ជ៝យ​ងាន់​ជ៝យ​ងាន់​មពោង​មោ​ហោម​ឆៃ​ជឹត​អោស។ ");
INSERT INTO cmok_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ជេសរី​តោង​ពារ់​នៃ​អោប​លុត ៖ “មៃ​គែស​នទុល​មពោល​អាបាៈ​គុ​តា​ប៝ន​អ្យា​ដ៝ង់? មោ​លាស​គែស​ក៝ន​គែស​ក្លៃ? អ៝ន់​មៃ​លែវ​លែៈ​ឞូនុយ្ស​មៃ​ទូ​លោស​ឞើស​នតុក​អ្យា​ហ៝ម់។ ");
INSERT INTO cmok_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ប៝ន​អ្យា​ហេន​លើស​លើយ យ៝រ​លាស​នាវ​អ្យើស​តា​ប៝ន​អ្យា​លើ​ហោ​ងាន់​លឺ​អា​ឞ្រាស​យេហោវា​រី កើត​នទ្រី​ទឹង​ពាង់​ដាៈ​ហេន​ហាន់​លើស​ហេង​លើយ​ប៝ន​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ជេសរី​លុត ​ទ៝ក់​មឞើស​ក្លៃៗ​អី​នអាប់​មា​ក៝ន​ពាង់​រី៖ “ទ៝ក់​ទូ​ឞើស​នតុក​អ្យា​ហ៝ម់ យ៝រ​លាស​ឞ្រាស​យេហោវា​ឞើយ​មា​លើស​ហេង​លើយ​ប៝ន​អ្យា”។ តីស​មា​អី​ក្លៃៗ​រី​មោ​អោស​អ្យាត់ ខាន់​ពាង់​នអោន​លាស​ងើយ​ព៝ល់​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ត៝ត់​ឞ្រី​លែៈ​ប្ហីត​អាង តោង​ពារ់​ទែ​ញច៝ប់​លុត ៖ “ទ៝ក់​ហ៝ម់ លែវ​អូរ​មៃ នទ្រែល​មា​ក៝ន​មៃ​ទូ​ឞើស​នតុក​អ្យា ក្លាច​លាស​គែស​ខឹត​នទ្រែល​ផូង​តីស​តា​ប៝ន​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","តីស​មា​លុត ​ហោម​អែ​គុ​មឞ្រែៈ​មឞ្រើយ។ ជេសរី​តោង​ពារ់​ទែ​តេក​តី​លុត  តេក​តី​អី​អូរ​ពាង់ នទ្រែល​មា​តេក​តី​អី​ក៝ន​ពាង់​រី លែវ​ខាន់​ពាង់​អ៝ន់​គុ​អា​ឞើស​ទីស​ប៝ន​រី យ៝រ​លាស​ឞ្រាស​យេហោវា​យោៈ​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ត៝ត់​ឞើស​ទីស​ប៝ន​រី ទូ​ហ្វេ​តោង​ពារ់​លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ញច្វាត់​ហ៝ម់​គៃ​មា​ក្លាយ្ស លើយ​អោស​ងគឹល​ជឹត​កើយ នទ្រែល​មា​លើយ​ញឆ្រុង​តា​នតុក​ឞ្រី​រាដុង​ដ៝ង់ អ៝ន់​ខាន់​មៃ​ញច្វាត់​ជឹត​យោក​រី គៃ​មា​ក្លាយ្ស​ឞើស​នាវ​ខឹត​ហេង”។ ");
INSERT INTO cmok_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","លុត ​ងើយ​មា​តោង​ពារ់៖ “អើ​កោរាញ លើយ​អោស​ញច៝ប់​គ៝ប់​នទ្រី។ ");
INSERT INTO cmok_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","មៃ​លែៈ​យោៈ​មា​គ៝ប់​ហោ​ងាន់ រាក្លាយ្ស​នាវ​រេស​គ៝ប់។ យើន​មា​លាស​មៃ​ដាៈ​គ៝ប់​ញច្វាត់​ជឹត​យោក​រី​មោ​នាន់​អោស ក្លាច​លាស​នាវ​អ្យើស​នៃ​ឞាន​គ៝ប់​ច្រាវ ជេសរី​គ៝ប់​ខឹត​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","អើ​កោរាញ តា​អ្យា​គែស​ទូ​ប៝ន​ទាច់​អ៝យ​គ៝ប់​ទើយ​មា​ញច្វាត់ ប៝ន​អី​នៃ​ជេៈ​ទើម លាស​នទ្រី​មៃ​អ៝ន់​គ៝ប់​ញច្វាត់​តា​ប៝ន​ជេៈ​នៃ គៃ​មា​រេស!” ");
INSERT INTO cmok_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","តោង​ពារ់​លាស​មា​ពាង់៖ “លាស​នទ្រី​គ៝ប់​តឹង​នាវ​មៃ គ៝ប់​មោ​អោស​លើស​ហេង​ប៝ន​ជេៈ​អី​មៃ​លាស​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","មៃ​ញច្វាត់​អ៝ន់​គើញ​ហ៝ម់​តា​ប៝ន​នៃ យ៝រ​លាស​គ៝ប់​មោ​អោស​ឞ្លាវ​ជាន​លាស​មៃ​អេ​ហ៝ៈ​ត៝ត់​តា​នៃ”។ នទ្រី​ទឹង​ឞូ​តេៈ​រាញា​ប៝ន​អី​នៃ​«ឆោអារ» គែស​នាវ​ខ្លៃ​«ជេៈ»។ ");
INSERT INTO cmok_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ត៝ត់​លុត ​លែៈ​លាប់​តា​ប៝ន​ឆោអារ​រី នារ​លែៈ​លោស​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","នោក​នៃ​ឞ្រាស​យេហោវា​អ៝ន់​គែស​ញឆីវ​ហីត​អុញ​តាៈ​ឞើស​ត្រោក​តី​តឹម​ឞាន​មា​មីស​ងាន់​ងខុត​តា​ប៝ន​ឆោដុម នទ្រែល​មា​ប៝ន​កោមោរា។ ");
INSERT INTO cmok_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ឞ្រាស​យេហោវា​លើស​ហេង​លើយ​ទឹង​លែៈ​ប៝ន​នៃ នទ្រែល​មា​លែៈ​រាងោច​នតុក​ឞ្រី​រាដុង ឞូនុយ្ស​ទឹង​លែៈ​តា​ប៝ន នអ៝ប់​មា​លែៈ​នទើ​ហ៝ន​តា​នែស ខឹត​រ៝ស​ហេង​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ល៝ង់​អី​អូរ​លុត ​រី ពាង់​ងគឹល​ជឹត​កើយ នហ៝​មា​ជេង​ឞ៝ស​រូប​អី​ឆាក់​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","អាឞ្រាហាម់ ​ទ៝ក់​អើម​អោយ ពាង់​ហាន់​តា​នតុក​ពាង់​គុ​នទ្រែល​ឞ្រាស​យេហោវា​រី​នើស ");
INSERT INTO cmok_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ជេសរី​ពាង់​អ្វាញ់​ឞើស​លើ​យោក​ជឹត​ប៝ន​ឆោដុម ជឹត​ប៝ន​កោមោរា នទ្រែល​មា​លែៈ​រាងោច​នតុក​ឞ្រី​រាដុង​រី ពាង់​ឆៃ​ញហូក​អុញ​តឹម​ឞាន​មា​ញហូក​អុញ​មពុយ្ស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","កើត​នទ្រី​នោក​ឞ្រាស​យេហោវា​លើស​ហេង​លើយ​ទឹង​លែៈ​ប៝ន​រ៝ៈ​នតុក​ឞ្រី​រាដុង​នៃ ពាង់​កាស​គឹត​មា​អាឞ្រាហាម់  ជេសរី​ពាង់​រាក្លាយ្ស​លុត ​អ៝ន់​រេស នោក​ពាង់​លើស​ហេង​លើយ​ប៝ន​លុត ​គុ​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","លុត  នទ្រែល​មា​ឞារ​ហៃ​ក៝ន​ទ្រោស​ពាង់​លោស​ឞើស​ប៝ន​ឆោអារ​ហាន់​គុ​អា​យោក​រី យ៝រ​លាស​ពាង់​មោ​អោស​ឞាញ់​គុ​តា​ប៝ន​ឆោអារ នទ្រី​ទឹង​ពាង់​ហាន់​គុ​អា​ទូ​មល៝ម់​ត្រោម​យោក នទ្រែល​មា​ឞារ​ហៃ​ក៝ន​ទ្រោស​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ទោល​នៃ​អី​យោស​រី​លាស​មា​អី​អ៝ស៖ “ឞឹ​ឞ៝ន់​លែៈ​រាញ តា​ឞ្រី​អ្យា​មោ​អោស​គែស​ឞូ​ក្លោ​ឆ៝ៈ​ឞ៝ន់​មា​ជាន​អូរ កើត​ឞូ​អាបាៈ​អេង​តា​នែស​នតូ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","លាស​នទ្រី​ឞ៝ន់​ជាៈ​ពាង់​ញេត​នទ្រាញ់​អ៝ន់​ត៝ត់​ញុល ជេសរី​ឞិច​នទ្រែល​ពាង់ គៃ​មា​ហោម​គែស​រាន៝យ​ទែស​តាៈ​ឞើស​ឞឹ​ឞ៝ន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","មាង់​នៃ​ឞារ​ហៃ​ខាន់​ពាង់​រី​ជាៈ​ឞឹ​ខាន់​ពាង់​ញេត​នទ្រាញ់​អ៝ន់​ញុល​រ៝ ជេសរី​អី​យោស​រី​លាប់​ឞិច​នទ្រែល​អី​ឞឹ​រី យើន​មា​លុត ​មោ​គឹត​អោស​ក៝ន​ពាង់​ឞិច​ដាស​ពាង់ យ៝រ​មា​លែៈ​ញុល​ហោ​អីរ។ ");
INSERT INTO cmok_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","កាស​អោយ​តៃ​អី​យោស​រី​លាស​មា​អី​អ៝ស៖ “អា​មាង់​នើស​គ៝ប់​លែៈ​ជេស​ឞិច​ដាស​ឞឹ មាង់​អ្យា​ឞ៝ន់​ជាៈ​ពាង់​ញេត​នទ្រាញ់​អ៝ន់​ត៝ត់​ញុល​ជឹត ជេសរី​អៃ​ឞិច​ដាស​ពាង់ គៃ​មា​ហោម​គែស​រាន៝យ​ទែស​តាៈ​ឞើស​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ត៝ត់​មាង់​នៃ ខាន់​ពាង់​ជាៈ​តៃ​អី​ឞឹ​ញេត​នទ្រាញ់​អ៝ន់​ត៝ត់​ញុល ជេសរី​អី​អ៝ស​រី​លាប់​ឞិច​ដាស​អី​ឞឹ​រី យើន​មា​លុត ​មោ​គឹត​អោស​ក៝ន​ពាង់​ឞិច​ដាស​ពាង់ យ៝រ​មា​លែៈ​ញុល​ហោ​អីរ។ ");
INSERT INTO cmok_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ជេសរី​លែៈ​ឞារ​ហៃ​ក៝ន​ទ្រោស​លុត ​រី នត្រែវ​ដាស​ពាង់​នើម​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","អី​យោស​រី​គុ​អ៝ស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ ពាង់​តេៈ​រាញា​មោអាប់ ពាង់​អី​នៃ​ជេង​ចែ​មា​ផូង​មោអាប់​នហ៝​មា​ត៝ត់​អាបៃ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","អី​អ៝ស​រី​គុ​អ៝ស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ដ៝ង់ ពាង់​តេៈ​រាញា​បេន-​អាមី ពាង់​អី​នៃ​ជេង​ចែ​មា​ផូង​អាមោន​នហ៝​មា​ត៝ត់​អាបៃ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ជេសរី​អាឞ្រាហាម់ ​លោស​ឞើស​នតុក​ពាង់​គុ​នៃ ហាន់​មពែស​មា​ឞ្រី​នេកិប។ ពាង់​គុ​តា​ប៝ន​កេរារ ជេង​វាស​វាង​ប៝ន​កាដែស​មា​ឞ្រី​ឆូរ។ ");
INSERT INTO cmok_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","តា​នៃ​អាឞ្រាហាម់ ​ងើយ​ងក៝ច​ឆារា​អី​អូរ​ពាង់​រី​មា​ឞូ ពាង់​លាស​ឆារា​នៃ​ជេង​អី​អ៝ស​ពាង់។ តា​ប៝ន​កេរារ​នៃ​គែស​ទូ​ហ្វេ​រាញា​អាបីមាលិច ពាង់​ជេង​កាដាច់​ឞ្រី​នៃ ត៝ត់​ពាង់​គឹត​មា​នាវ​អាឞ្រាហាម់​ងក៝ច​អី​នៃ ពាង់​ដាៈ​ឞូ​ហាន់​ឆ៝ៈ​ឆារា​លែវ​អា​ពាង់​មា​ជាន​អូរ‌ ");
INSERT INTO cmok_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","យើន​មា​តា​មាង់​នៃ​កោរាញ​ឞ្រាស​ហាន់​ម៝ប់​មា​នាវ​មឞើយ លាស​មា​ពាង់៖ “មៃ​តៃ​ខឹត​រ៝​យ៝រ​មា​ឞូ​អូរ​អី​មៃ​ឆ៝ៈ​នៃ យ៝រ​លាស​ពាង់​នើស​ជេង​អូរ​ឞូ”។ ");
INSERT INTO cmok_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","យើន​មា​កាដាច់​អាបីមាលិច​អេ​ហ៝ៈ​អោស​ឞិច​ដាស​ឆារា នទ្រី​ពាង់​អោប៖ “អើ​កោរាញ​ឞ្រាស មៃ​លើស​លើយ​ដ៝ង់​ឞើស លាស​គ៝ប់​នទ្រែល​មា​ប៝ន​លាន​គ៝ប់​មោ​ម៝ប់​ជាន​តីស? ");
INSERT INTO cmok_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","អើម​មោ​ទី​លាស​ពាង់​លែៈ​មឞើស​មា​គ៝ប់​លាស៖ «ឞូ​អូរ​អ្យា​ជេង​អ៝ស​គ៝ប់»? ជេសរី​ឞូ​អូរ​នៃ​ក៝ៈ​មឞើស​មា​គ៝ប់​លាស៖ «ឞូ​ក្លោ​អ្យា​ជេង​នោ​គ៝ប់»​ដ៝ង់។ កើត​នទ្រី​នាវ​គ៝ប់​ជាន​អ្យា​ជេង​ទី​មា​គ៝ប់ គ៝ប់​ក៝ៈ​មោ​ជាន​តីស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","កោរាញ​ឞ្រាស​លាស​មា​ពាង់​តឹម​នាវ​មឞើយ​នៃ៖ “គ៝ប់​គឹត​នាវ​មៃ​ជាន​នៃ​ជេង​ទី​មា​មៃ កើត​នទ្រី​ទឹង​គ៝ប់​ឞ្វៃ​មៃ មោ​អ៝ន់​មៃ​ជាន​តីស​មា​គ៝ប់។ គ៝ប់​មោ​ប៝ង់​គ៝រ​អ៝ន់​មៃ​ឞិច​ដាស​ឞូ​អូរ​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","លាស​នទ្រី​អ៝ន់​មៃ​មព្លឹ​ឞូ​អូរ​នៃ​អា​ឆាយ​ពាង់​អាបៃ​រី តៃ​ពាង់​មឞើស​ឆើម​អ៝ន់​មា​មៃ គៃ​មា​មៃ​ហោម​គុ​រេស​ជឹត យ៝រ​លាស​ពាង់​ជេង​ឞូនុយ្ស​នតើយ្ស​នាវ​គ៝ប់​ងើយ។ លាស​មៃ​មោ​អោស​មព្លឹ​ឞូ​អូរ​នៃ​អា​ពាង់ មៃ​តៃ នទ្រែល​មា​ប៝ន​លាន​មៃ​ខឹត​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","កាដាច់​អាបីមាលិច​រី​ទ៝ក់​អើម​អោយ ពាង់​ក្វាល់​រាគូម​ផូង​កើល​ជាន​ការ​ពាង់ ជេសរី​មឞើស​ងក៝ច​ទឹង​លែៈ​នាវ​មឞើយ​អី​នៃ​អ៝ន់​មា​ខាន់​ពាង់​តាង់។ ជេស​តាង់​នាវ​អី​នៃ លែៈ​រាងោច​ខាន់​ពាង់​ក្លាច​ញឆ៝រ់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ជេសរី​កាដាច់​អាបីមាលិច​ដាៈ​ឞូ​ហាន់​ក្វាល់​អាឞ្រាហាម់  កាដាច់​លាស​ពាង់៖ “ម៝ស​មៃ​ជាន​មា​ហេន​កើត​នអា​មេស? ម៝ស​បាៈ​គ៝ប់​ជាន​តីស​មា​មៃ ទឹង​មៃ​ជាន​អ៝ន់​មា​គ៝ប់ នទ្រែល​មា​ឞ្រី​ទាក​គ៝ប់​គែស​នាវ​តីស​ទុត​ក្វ៝ង់​កើត​នអា? យ៝រ​លាស​នាវ​អី​មៃ​ជាន​មា​គ៝ប់​អ្យា ឞូ​មោ​គែស​អោស​ទី​មា​ជាន!” ");
INSERT INTO cmok_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","កាដាច់​អាបីមាលិច​លាស​តៃ​មា​អាឞ្រាហាម់ ៖ “មើម​នាវ​មៃ​មឹន ទឹង​មៃ​អុច​ជាន​កើត​នអា?” ");
INSERT INTO cmok_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","អាឞ្រាហាម់ ​លាស​មា​កាដាច់​នៃ៖ “យ៝រ​លាស​គ៝ប់​មឹន ឞូនុយ្ស​តា​ឞ្រី​អ្យា​មោ​គែស​អោស​ទូ​ហ្វេ​ក្លាច​មា​កោរាញ​ឞ្រាស ល៝ង់​គ៝ប់​តៃ​ឞូ​ទែ​ងខឹត​យ៝រ​មា​អុច​ឆ៝ៈ​អូរ​គ៝ប់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","នទ្រែល​មា​ពាង់​នើស​ជេង​អ៝ស​គ៝ប់​ងាន់ ជេង​ក៝ន​ឞឹ​គ៝ប់​ដ៝ង់ តីស​មា​មេៈ​គ៝ប់​ដាស​មេៈ​ពាង់​ជេង​មេៈ​អេងៗ ជេសរី​គ៝ប់​ឆ៝ៈ​ពាង់​នអាប់​អូរ​ឆាយ។ ");
INSERT INTO cmok_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ទោល​កោរាញ​ឞ្រាស​អ៝ន់​គ៝ប់​ទូ​ងាយ​ដាស​មា​នទុល​មពោល​គ៝ប់​នើម គ៝ប់​លែៈ​លាស​មា​ពាង់៖ «អ៝ន់​អៃ​យោៈ​នអាច​មា​គ៝ប់​បាៈ​យឹ អាស​នតុក​ឞ៝ន់​ហាន់ អ៝ន់​អៃ​មឞើស​ងក៝ច​មា​ឞូ​លាស ឞ៝ន់​ជេង​រោស​ក្លោ​ហ៝ៈ»”។ ");
INSERT INTO cmok_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ជេសរី​កាដាច់​អាបីមាលិច​ឆ៝ៈ​ឞែ​ឞ្យាប់ ឆ៝ៈ​នទ្រោក​តាៈ​ឞើស​ផូង​មពោមពា​(ឆ្យុម)​ពាង់​នើម នទ្រែល​មា​ឆ៝ៈ​ទឹក​ឞូ​អូរ​ទឹក​ឞូ​ក្លោ​ពាង់​នើម​អ៝ន់​មា​អាឞ្រាហាម់  នអ៝ប់​មា​មព្លឹ​ឆារា​អី​អូរ​ពាង់​នើម​រី​នើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","កាដាច់​នៃ​លាស​មា​អាឞ្រាហាម់ ៖ “ល៝ង់​ឞ្រី​ទាក​គ៝ប់​តា​អ្យា អាស​នតុក​មៃ​អុច​គុ ទាស​មៃ​អុច”។ ");
INSERT INTO cmok_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ពាង់​លាស​ដ៝ង់​មា​ឆារា៖ “អ្យា​ព្រាក់​គ៝ប់​ទូ​រាឞាន់​កាក់​ព្រាក់ គ៝ប់​អ៝ន់​មា​នោ​អៃ គៃ​មា​មពោល​អី​គុ​នទ្រែល​អៃ​នៃ​គឹត​នហេល​អៃ​មោ​អោស​គែស​ជាន​តីស​ទូ​នតីល គៃ​មា​ឞូនុយ្ស​ទឹង​លែៈ​គឹត​នហេល​អៃ​មោ​អោស​គែស​ជាន​តីស”។ ");
INSERT INTO cmok_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","នោក​នៃ​យ៝រ​មា​ឆារា​អី​អូរ​អាឞ្រាហាម់ ​នៃ​គុ​តា​ជៃ​កាដាច់​អាបីមាលិចឞ្រាស​យេហោវា​អ៝ន់​ទឹង​លែៈ​ឞូ​អូរ​អី​គុ​តា​ជៃ​ពាង់​ឞាស​ឞាៈ​ក៝ន។ អាឞ្រាហាម់ ​មឞើស​ឆើម​អ៝ន់​មា​អាបីមាលិច​ទាន់​មា​កោរាញ​ឞ្រាស ជេសរី​កោរាញ​ឞ្រាស​ជាន​អ៝ន់​ឞាស​ជី​ពាង់ អ៝ន់​ឞាស​ជី​អូរ​ពាង់ នទ្រែល​មា​លែៈ​ទឹក​ឞូ​អូរ​ពាង់ ជេសរី​មពោល​នៃ​គែស​អ៝ស​គែស​ក៝ន​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ឞ្រាស​យេហោវា​ជាន​តឹង​នាវ​ពាង់​លែៈ​លាស​នើស ពាង់​អ៝ន់​ឆារា​គែស​ក៝ន​ងាន់​កើត​នាវ​ពាង់​លែៈ​ត៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ឆារា​នត្រែវ​ងាន់ ត៝ត់​តា​ទី​នារ​កោរាញ​ឞ្រាស​លាស ពាង់​គុ​អ៝ស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​អ៝ន់​មា​អាឞ្រាហាម់  នោក​អាឞ្រាហាម់​លែៈ​រាញ​ងាន់​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ក៝ន​ឆារា​ទែស​មា​អាឞ្រាហាម់ ​នៃ ជេសរី​អាឞ្រាហាម់​តេៈ​រាញា «អីឆាក់»។ ");
INSERT INTO cmok_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ត៝ត់​អីឆាក់​លែៈ​គែស​ផាម​នារ​ជេស​ទែស អាឞ្រាហាម់ ​ជាន​ក៝ស​នតោ​មា​ពាង់ កើត​នាវ​កោរាញ​ឞ្រាស​ទែ​ដាៈ​មា​ពាង់​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","នោក​ទែស​អីឆាក់​នៃ អាឞ្រាហាម់ ​លែៈ​គែស ១០០ នាម់​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","នោក​នៃ​ឆារា​លាស៖ “កោរាញ​ឞ្រាស​ជាន​អ៝ន់​គ៝ប់​ជេង​គើម នទ្រែល​មា​ឞូ​ម៝ស​អី​តាង់​នាវ​អ្យា ឞូ​ជេង​គើម​នទ្រែល​មា​គ៝ប់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ឆារា​ងើយ​ជឹត៖ “ឞូ​ម៝ស​ឞាញ់​មឞើស​ងក៝ច​មា​អាឞ្រាហាម់ ៖ «គែស​ទូ​នារ​អូរ​មៃ​មពូ​ត៝ស​ក៝ន»? ល៝ង់​អាបៃ​រី​គ៝ប់​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​អ៝ន់​មា​អាឞ្រាហាម់  ទោល​ពាង់​លែៈ​រាញ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ត៝ត់​អីឆាក់​លែៈ​ក្វ៝ង់​អ៝យ ពាង់​ឞាស​ពូ​ត៝ស ជេសរី​អាឞ្រាហាម់ ​នទ្រាប់​ញេត​ទុត​ក្វ៝ង់ នារ​ក៝ន​ឆែ​នៃ​ឞាស​ពូ​ត៝ស។ ");
INSERT INTO cmok_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ឆារា​ឆៃ​អីសមាអែល​អី​ក៝ន​ហាការ​ផូង​អេឆីប ​ទែស​អ៝ន់​មា​អាឞ្រាហាម់ ​គើម​មឺច​មា​អីឆាក់​អី​ក៝ន​ពាង់​នើម‌ ");
INSERT INTO cmok_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ជេសរី​ពាង់​លាស​មា​អាឞ្រាហាម់ ៖ “មព្រើស​លើយ​ទឹក​ឞូ​អូរ​នៃ នទ្រែល​មា​ក៝ន​ពាង់​ទូ​លោស​ឞើស​នតុក​អ្យា អ្យាត់​មា​ក៝ន​ទឹក​ឞូ​អូរ​អី​នៃ​មោ​អោស​ទើន​ឆ៝ៈ​ទ្រាប់​នទើ​ខ្លៃ​នទ្រែល​ក៝ន​គ៝ប់​អីឆាក់​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","នាវ​ងើយ​នៃ​ជាន​អ៝ន់​អាឞ្រាហាម់ ​ហោ​ងាន់​រាង៝ត​តា​នូយ្ស​នហ៝ម់​ពាង់​រី យ៝រ​លាស​អីសមាអែល​នៃ​ក៝ន​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","យើន​មា​កោរាញ​ឞ្រាស​លាស​មា​ពាង់៖ “មៃ​លើយ​តា​រាង៝ត​អោស យ៝រ​មា​ក៝ន​ឆែ​នទ្រែល​មា​អី​មែ​ពាង់​នៃ។ អ៝ន់​មៃ​អ្យាត់​ម៝ស​នាវ​ឆារា​ទែ​លាស យ៝រ​លាស​រាន៝យ​ទែស​អី​គ៝ប់​ត៝ន​មា​មៃ​កើប​តា​អីឆាក់។ ");
INSERT INTO cmok_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","យើន​មា​ក៝ន​អូរ​ចោង​មៃ​នៃ តៃ​គ៝ប់​អ៝ន់​ពាង់​ជេង​ទូ​ផូង​គែស​ឞ្រី​ទាក​ដ៝ង់ យ៝រ​លាស​ពាង់​នើស​រាន៝យ​ទែស​មៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ត៝ត់​អោយ​តៃ​រី​អាឞ្រាហាម់ ​ទ៝ក់​អើម​អោយ ពាង់​ឆ៝ៈ​នទើ​ឆោង​ឆា នទ្រែល​មា​នោង​ទាក​អ៝ន់​មា​ហាការ ពឺ​ទឹង​លែៈ​នទើ​អី​នៃ​អ៝ន់​តា​ត៝ង​ក៝​អី​មេៈ​រី ដាៈ​ពាង់​ហាន់​នទ្រែល​មា​អី​ក៝ន​ពាង់។ ជេសរី​ហាការ​ទូ​លោស​ឞើស​នតុក​នៃ​ហាន់​ញហើត​ត្រ៝ង​តា​ឞ្រី​រាទាស​តឹម​ទាច់​ដាស​ប៝ន​បេរឆេបា​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ត៝ត់​លែៈ​ទាក​តា​នោង​រី ហាការ​នត្លើយ​អី​ក៝ន​ពាង់​គុ​តា​ន៝ម់​ទូ​ពុម​រាលោ‌ ");
INSERT INTO cmok_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ជេសរី​ពាង់​នើម​គុ​បាស​មា​ក៝ន​ពាង់​រី ក្លាប់​លាស​ងាយ​ត្រុយ្ស​ពាញ់​មា​នា យ៝រ​លាស​ពាង់​លាស៖ “លើយ​អ៝ន់​គ៝ប់​ឆៃ​ខឹត​ក៝ន​គ៝ប់”។ ជេសរី​ពាង់​គុ​បាស​មា​ក៝ន នទ្រី​ទឹង​ពាង់​ញុម​នតែរ។ ");
INSERT INTO cmok_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","កោរាញ​ឞ្រាស​តាង់​អ្យាត់​មា​ក៝ន​ឞូ​ក្លោ​នៃ​ញុម ជេសរី​តោង​ពារ់​កោរាញ​ឞ្រាស​ក្វាល់​ហាការ​ឞើស​កាលើ​ត្រោក​នតុក​ពាង់​នើម៖ “ហើយ​ហាការ មើម​ជាន​អៃ​រុង​រាង់​ងាន់​នៃ​ហែស? អៃ​លើយ​អោស​រាវៃ យ៝រ​លាស​កោរាញ​ឞ្រាស​លែៈ​តាង់​អ្យាត់​ក៝ន​អី​នៃ​ញុម​នតែរ​ឞើស​នតុក​ពាង់​គុ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","អៃ​ទ៝ក់​ហ៝ម់ ហាន់​តេក​តី​ក៝ន​អៃ​នៃ យ៝រ​លាស​តៃ​គ៝ប់​ជាន​អ៝ន់​ពាង់​ជេង​ទូ​ផូង​ក្វ៝ង់​គែស​ឞ្រី​ទាក”។ ");
INSERT INTO cmok_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","កោរាញ​ឞ្រាស​ជាន​អ៝ន់​មាត់​ហាការ​ឆៃ​ទូ​មល៝ម់​នតូ​ទាក​គែស​ទាក ពាង់​ទ៝ក់​ហាន់​ឞុក​ទាក​អី​នៃ​ឞេង​នោង ជេសរី​អ៝ន់​ក៝ន​ពាង់​ញេត។ ");
INSERT INTO cmok_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","កោរាញ​ឞ្រាស​គុ​នទ្រែល​មា​ក៝ន​ឞូ​ក្លោ​អី​នៃ ពាង់​គុ​រេស​តា​ឞ្រី​រាទាស​រី​នហ៝​មា​ត៝ត់​ក្វ៝ង់​ត៝ត់​នទាម់ ពាង់​ជេង​ឞូនុយ្ស​ឞ្លាវ​ពាញ់​នា​ទុត​ឞ្លាវ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ពាង់​គុ​តា​ឞ្រី​រាទាស​ពារាន ជេសរី​អី​មេៈ​រី​កើយ្ស​ឞូ​អូរ​ផូង​អេឆីប ​ទូ​ហ្វេ​មា​ជេង​អូរ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","នោក​នៃ​កាដាច់​អាបីមាលិច នទ្រែល​មា​ផីកុល​អី​កោរាញ​តាហែន​ក្វ៝ង់​ពាង់ ពាង់​លាស​មា​អាឞ្រាហាម់ ៖ “កោរាញ​ឞ្រាស​គុ​នទ្រែល​មៃ ទឹង​លែៈ​នតីល​នទើ​មៃ​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","លាស​នទ្រី​អ៝ន់​មៃ​ត៝ន​មា​គ៝ប់​តា​អ្យា អ៝ន់​កោរាញ​ឞ្រាស​គឹត​ឆៃ មៃ​លាស​មោ​នទើម​គ៝ប់ ក៝ន​គ៝ប់ នទ្រែល​មា​ក៝ន​ឆៅ​គ៝ប់។ យ៝រ​លាស​គ៝ប់​លែៈ​ជាន​អ្វែស​ជេស​មា​មៃ លាស​នទ្រី​អ៝ន់​មៃ​ជាន​អ្វែស​មា​គ៝ប់ នទ្រែល​មា​ឞ្រី​ទាក​គ៝ប់​អី​មៃ​គុ​អ្យា​អ៝ន់​កើត​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","អាឞ្រាហាម់ ​អើស​មា​កាដាច់៖ “អើ គ៝ប់​ត៝ន”។ ");
INSERT INTO cmok_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ជេសរី​អាឞ្រាហាម់ ​លាស​មា​ពាង់​ទូ​មល៝ម់​នតូ​ទាក​អី​ផូង​ប៝ន​លាន​ពាង់​អីន​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","កាដាច់​អាបីមាលិច​អើស​មា​ពាង់៖ “គ៝ប់​មោ​គឹត​អោស​ឞូ​ម៝ស​អី​ជាន​កើត​នៃ យ៝រ​លាស​មៃ​មោ​ព្រ៝ត​ងក៝ច​មា​គ៝ប់​ដ៝ង់ ត៝ត់​នារ​អ្យា​មើ​ទឹង​គ៝ប់​គឹត​នាវ​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","អាឞ្រាហាម់ ​ឆ៝ៈ​ឞែ​ឞ្យាប់​អាបាៈ នទ្រែល​មា​នទ្រោក​អាបាៈ​អ៝ន់​មា​កាដាច់​អាបីមាលិច ជេសរី​លែៈ​ឞារ​ហៃ​ខាន់​ពាង់​រី​តឹម​រាង្លាប់​នទ្រែល។ ");
INSERT INTO cmok_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","អាឞ្រាហាម់ ​ឆ៝ៈ​ពើស​អឹ​ឞែ​ឞ្យាប់​អី​ទ្រោសៗ​អ៝ន់​គុ​អេង។ ");
INSERT INTO cmok_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","កាដាច់​អាបីមាលិច​អោប​អាឞ្រាហាម់ ៖ “ពើស​អឹ​ឞែ​ឞ្យាប់​អី​ទ្រោសៗ​មៃ​អ៝ន់​គុ​អេង​នៃ​ម៝ស​ជាន?” ");
INSERT INTO cmok_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","អាឞ្រាហាម់ ​មឞើស​មា​ពាង់៖ “ពើស​អឹ​ឞែ​ឞ្យាប់​អី​អ្យា គ៝ប់​អ៝ន់​មា​មៃ​មា​តី​គ៝ប់​នើម នទើ​អ្យា​គៃ​មា​មឞើស​នហេល​នានេៈ​លាស នតូ​ទាក​នៃ​លែៈ​គ៝ប់​កុយ្ស​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","កើត​នទ្រី​ទឹង​ឞូ​ក្វាល់​នតុក​នៃ​រាញា​«បេរឆេបា» គែស​នាវ​ខ្លៃ​ជេង​«នតូ​ទាក​ពើស​នទើ» មោ​លាស៖ «នតូ​ទាក​ត៝ន» យ៝រ​លាស​នតុក​នៃ​ជេង​នតុក​ខាន់​ពាង់​លែៈ​ជេស​តឹម​ត៝ន​ឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","កើត​នទ្រី​នាវ​ខាន់​ពាង់​លែៈ​តឹម​រាង្លាប់​ឞាល់​តា​បេរឆេបា​រី។ ជេសរី​កាដាច់​អាបីមាលិច នទ្រែល​មា​កោរាញ​តាហែន​ក្វ៝ង់​ពាង់​រី ព្លឹ​ឆឹត​តៃ​តា​ឞ្រី​ផាលីសតីន។ ");
INSERT INTO cmok_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ជេសរី​អាឞ្រាហាម់ ​តាម់​ទូ​មល៝ម់​តើម​ឆី​តា​បេរឆេបា​នៃ តា​នតុក​នៃ​ដ៝ង់​នហ៝​មា​ពាង់​យើក​មឞាស​ឞ្រាស​យេហោវា​អី​កោរាញ​ឞ្រាស​អី​ហោម​គុ​រេស​នហ៝​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","អាឞ្រាហាម់ ​គុ​តា​ឞ្រី​ផាលីសតីន​រី​ជ៝ៈ​នារ។ ");
INSERT INTO cmok_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ជេស​គែស​នាវ​នៃ កោរាញ​ឞ្រាស​អុច​រាល៝ង​នូយ្ស​នហ៝ម់​អាឞ្រាហាម់ ពាង់​ក្វាល់​អាឞ្រាហាម់ ៖ “ហើយ​អាឞ្រាហាម់ !” អាឞ្រាហាម់ ​អើស៖ “ម៝ស​កោរាញ?” ");
INSERT INTO cmok_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","កោរាញ​ឞ្រាស​លាស​មា​ពាង់៖ “ឆ៝ៈ​អីឆាក់​ក៝ន​មៃ​នៃ​អី​មៃ​រ៝ង់​មា​ពាង់​ទុត​ហោ ជេង​ក៝ន​ឞូ​ក្លោ​មៃ​នើម​ង្វាយ​អឹ​ទើម​នៃ លែវ​ពាង់​ហាន់​តា​ឞ្រី​មោរីយា។ តា​រី​អ៝ន់​មៃ​ពូរ​ញហើរ​ពាង់​អ៝ន់​មា​គ៝ប់​តា​កាលើ​យោក តា​ទូ​មល៝ម់​យោក​នតុក​គ៝ប់​មឞើស​មា​មៃ​រី​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","អាឞ្រាហាម់ ​ទ៝ក់​អើម​អោយ ពាង់​ចោក​ល៝ង​មា​ពូរ​នទើ​ញហើរ ពាង់​ឆ៝ៈ​ទុរ​តេៈ​តា​កាលើ​ឆែស​លៀ​រី ជេសរី​ឆ៝ៈ​ឞារ​ហៃ​ឞូ​ក្លោ​ជាន​ការ​ពាង់​នើម នទ្រែល​មា​អីឆាក់​អី​ក៝ន​ពាង់​នើម​រី ហាន់​នទ្រែល​មា​ពាង់​នើម​ជឹត​នតុក​កោរាញ​ឞ្រាស​ទែ​មឞើស​មា​ពាង់​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ត៝ត់​ឞ្រោៈ​លែៈ​គែស​ពែ​នារ អាឞ្រាហាម់ ​ងគើរ​ឆៃ​នតុក​នៃ​ឞើស​ងាយ ");
INSERT INTO cmok_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ជេសរី​លាស​មា​ឞារ​ហៃ​មពោល​ឞូនុយ្ស​ជាន​ការ​នៃ៖ “ឞារ​ហៃ​ខាន់​មៃ​អ្យា​មា​គុ​ចាម់​ឆែស​លៀ​តា​អ្យា​ប៝ត់ គ៝ប់ នទ្រែល​មា​ក៝ន​គ៝ប់​អ្យា​មា​ហាវ​យើក​មឞាស​កោរាញ​ឞ្រាស​តា​កាលើ​យោក​រី ជេស​ទឹង​ហេន​ព្លឹ​ឆឹត​តៃ​តា​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","អាឞ្រាហាម់ ​ក៝ត់​ល៝ង​មា​ពូរ​នទើ​ញហើរ​រី​អ៝ន់​អីឆាក់​តូយ ពាង់​នើម​រី​ញអោត​អុញ នទ្រែល​មា​ពេស ជេសរី​ហាន់​លែៈ​ឞារ​ហៃ​ឞឹ​ក៝ន​អា​រី​រើន​ទ្រើន។ ");
INSERT INTO cmok_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ទោល​នៃ​អីឆាក់​ងើយ​ដាស​អី​ឞឹ​ពាង់៖ “ហើយ​ឞឹ” អាឞ្រាហាម់ ​អើស៖ “ម៝ស​ក៝ន?” អីឆាក់​លាស៖ “តា​អ្យា​ឞ៝ន់​លែៈ​គែស​អុញ លែៈ​គែស​ពេស លាស​នទ្រី​អាស​ឞែ​ឞ្យាប់​នទើ​មា​ពូរ​ញហើរ?” ");
INSERT INTO cmok_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","អាឞ្រាហាម់ ​អើស៖ “អើ​ក៝ន ឞែ​ឞ្យាប់​នទើ​មា​ពូរ​ញហើរ​អី​នៃ កោរាញ​ឞ្រាស​នើម​ឆើម​អ៝ន់”។ ជេសរី​លែៈ​ឞារ​ហៃ​ឞឹ​ក៝ន​រី​ហាន់​ជឹត​នាប់​រើន​ទ្រើន​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ត៝ត់​តា​នតុក​កោរាញ​ឞ្រាស​ទែ​មឞើស​មា​ពាង់​រី​នើស អាឞ្រាហាម់ ​ឞូន​លុ​ទូ​នតុក​តា​នតុក​នៃ​មា​នតុក​ជាន​ឞ្រាស ជេស​ឞូន​នៃ ពាង់​ឞូន​ល៝ង​ឞើស​លើ​រី ពាង់​ញុប​ក៝ត់​អីឆាក់​អី​ក៝ន​ពាង់​នើម​រី​តេៈ​ឞើស​លើ​ល៝ង​ឞើស​លើ​នតុក​ជាន​ឞ្រាស​រី ");
INSERT INTO cmok_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ជេសរី​ពាង់​ឆ៝ៈ​ពេស​នតើម​យាត​តី​មា​លាច់​ត៝ង​ក៝​អី​ក៝ន​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ទោល​នៃ​ទោ​មា​តាង់​តោង​ពារ់​ឞ្រាស​យេហោវា​ទែ​ក្វាល់​ពាង់​តាៈ​ឞើស​លើ​ត្រោក​តី​លាស៖ “អាឞ្រាហាម់ ! អាឞ្រាហាម់ !” ពាង់​អើស៖ “ម៝ស​កោរាញ?” ");
INSERT INTO cmok_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","តោង​ពារ់​នៃ​លាស៖ “លើយ​មៃ​ងខឹត​ក៝ន​ឆែ​នៃ លើយ​តា​លើស​ពាង់​អោស អាបៃ​រី​លែៈ​គ៝ប់​គឹត​ជេស​មៃ​ក្លាច​យើក​មា​កោរាញ​ឞ្រាស យ៝រ​លាស​មៃ​មោ​អោស​ញហ្វាច​ក៝ន​មៃ​នើម​អើម​ង្វាយ​អឹ​កោលឹ​នៃ​អ៝ន់​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ជេសរី​អាឞ្រាហាម់ ​ងគឹល​ឆៃ​ទូ​មល៝ម់​ឞែ​ឞ្យាប់​ងក្វ៝ង់​តា​រី វាក់​ខាន​ងកែ​តា​តើម​ឆី។ ជេសរី​ពាង់​ហាន់​ឆ៝ៈ​ឞែ​ឞ្យាប់​អី​នៃ​ព្លាច់​មា​ពូរ​ញហើរ​នត្រ៝ៈ​អី​ក៝ន​ពាង់​នើម​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","អាឞ្រាហាម់ ​ក្វាល់​នតុក​នៃ​រាញា៖ «ឞ្រាស​យេហោវា​នើម​ឆើម​អ៝ន់» នទ្រី​ទឹង​ឞូ​ក្វាល់​នតុក​នៃ​ត៝ត់​អាបៃ​រី​រាញា៖ «តា​កាលើ​យោក​ឞ្រាស​យេហោវាពាង់​នើម​ឆើម​អ៝ន់»។ ");
INSERT INTO cmok_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","តោង​ពារ់​ឞ្រាស​យេហោវា​ក្វាល់​តៃ​អាឞ្រាហាម់ ​ឞើស​លើ​ត្រោក​តី​ទូ​តឹ​ជឹត ");
INSERT INTO cmok_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ពាង់​លាស៖ “គ៝ប់​អ្យា​ឞ្រាស​យេហោវាគ៝ប់​ឆ៝ៈ​រាញា​គ៝ប់​នើម​មា​ត៝ន មៃ​មោ​អោស​ញហ្វាច​ក៝ន​មៃ​នើម​អើម​ង្វាយ​អឹ​កោលឹ​នៃ​អ៝ន់​មា​គ៝ប់។ យ៝រ​មា​មៃ​លែៈ​ជាន​ជេស​កើត​នៃ ");
INSERT INTO cmok_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","គ៝ប់​អ៝ន់​គែស​ជេង​មា​មៃ​ទុត​អ៝ក់ តៃ​គ៝ប់​អ៝ន់​នាវ​គែស​ជេង​មា​មៃ​អ៝ក់​ឞេង​លែរ​ងាន់​ងេន ជេសរី​ជាន​រាន៝យ​ទែស​មៃ​អ៝ន់​អ៝ក់​ឞឹក​រឹ​តឹម​ឞាន​មា​មាញ់​មឞីង​តា​កាលើ​ត្រោក មោ​លាស​តឹម​ឞាន​មា​ច៝យ្ស​រ៝ៈ​មែង​ទាក​វាច់​ទាក​វារ់​ដ៝ង់។ ជេសរី​រាន៝យ​ទែស​មៃ​តៃ​ទើយ​ម៝ត់​អ្វាញ់​ផូង​រាលាង់​ដាស​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","នទ្រី​ទឹង​លែៈ​ផូង​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា ឞូ​គែស​ជេង​តាៈ​ឞើស​រាន៝យ​ទែស​មៃ យ៝រ​លាស​មៃ​លែៈ​អ្យាត់​ជេស​នាវ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ជេស​នៃ​អាឞ្រាហាម់  នទ្រែល​មា​ក៝ន​ពាង់​ព្លឹ​ឆឹត​តៃ​តា​ផូង​ឞូ​ក្លោ​ជាន​ការ​ពាង់​នើម​រី​នើស ជេសរី​ខាន់​ពាង់​ទ៝ក់​ហាន់​នទ្រែល​ជឹត​ប៝ន​បេរឆេបា​រី។ ត៝ត់​តា​បេរឆេបា​រី អាឞ្រាហាម់ ​គុ​តា​ប៝ន​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ជេស​គែស​នាវ​នៃ គែស​ឞូ​ហាន់​មឞើស​ងក៝ច​មា​អាឞ្រាហាម់ ៖ “ល៝ង់​មីលកា ​គុ​អ៝ស​គែស​ក៝ន​ឞូ​ក្លោ​អ៝ក់​ងាន់​អ៝ន់​មា​នាហោរ​អ៝ស​មៃ តា​នៃ​គែស៖ ");
INSERT INTO cmok_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","អុស​ជេង​ក៝ន​ឞោក​ទាក គែស​បុស​ជេង​អី​អ៝ស គែស​កេមោអែល​អី​ឞឹ​អារាម ");
INSERT INTO cmok_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","គែស​កេឆែត គែស​ហាឆោ គែស​ពីលដាស គែស​យិតលាប នទ្រែល​មា​គែស​បេថូអែល។ ");
INSERT INTO cmok_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","បេថូអែល​នៃ​អី​ឞឹ​ឞូ​អូរ​រេបេកា។ លែៈ​ផាម​នុយ្ស​ក៝ន​អី​នៃ​ជេង​មីលកា ​ទែស​មា​នាហោរ​អី​អ៝ស​អាឞ្រាហាម់ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ល៝ង់​អី​អូរ​ចោង​នាហោរ​រី​រាញា​រេយោមា ពាង់​គែស​ក៝ន​ឞូ​ក្លោ​ដ៝ង់ តា​នៃ​គែស៖ ថេបា គែស​កាហាម់ គែស​ថាហាស នទ្រែល​មា​គែស​មាកា។ ");
INSERT INTO cmok_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ឆារា​អី​អូរ​អាឞ្រាហាម់ ​រេស​ត៝ត់ ១២៧ នាម់ ទាស​នៃ​ជេង​អ៝ក់​នាម់​ពាង់​រេស។ ");
INSERT INTO cmok_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ជេសរី​ពាង់​ខឹត​តា​ប៝ន​ខិរយាត់-អារបា អី​ឞូ​ក្វាល់​ដ៝ង់​ប៝ន​ហេប្រ៝ន តា​ឞ្រី​កានាន។ អាឞ្រាហាម់ ​ញុម​នអ៝រ​ឆារា។ ");
INSERT INTO cmok_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ជេសរី​ពាង់​ទ៝ក់​ឞើស​នតុក​ឞូនុយ្ស​ខឹត​នៃ ហាន់​ងើយ​ដាស​មា​ផូង​ហេត៖ ");
INSERT INTO cmok_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“គ៝ប់​អ្យា​ជេង​ផូង​ឞូ​នាច់​ឞ្រី​អេង ជេង​ឞូនុយ្ស​វែស​គុ​ទូ​ប្ល៝ត់​តា​ខាន់​មៃ​អ្យា។ លាស​នទ្រី​គ៝ប់​ទាន់​ខាន់​មៃ​តាច់​នែស​មោច​ទូ​នតុក​អ៝ន់​មា​គ៝ប់​តា​ឞ្រី​ខាន់​មៃ​អ្យា គ៝ប់​ឞែ​មា​ត៝ប់​អូរ​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ផូង​ហេត​អើស​មា​អាឞ្រាហាម់ ៖ ");
INSERT INTO cmok_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“អើ​កោរាញ ទាន់​មៃ​អ្យាត់​ផូង​ហេន មៃ​ជេង​ឞូ​ក្វ៝ង់​គុ​តា​ផូង​ហេន​អ្យា ទាន់​មៃ​ត៝ប់​អូរ​មៃ​តា​នែស​មោច​ផូង​ហេន​អី​ទុត​អ្វែស​ទោ។ យ៝រ​លាស​ទឹង​លែៈ​ផូង​ហេន​មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​ឞ្វៃ​មៃ​មោ​អ៝ន់​នែស​មោច​មា​ត៝ប់​អូរ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ជេសរី​អាឞ្រាហាម់ ​ទ៝ក់​ពាន់​តា​នាប់​ផូង​ហេត​អី​ឞូនុយ្ស​ឞ្រី​នៃ ");
INSERT INTO cmok_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ពាង់​លាស​មា​ផូង​នៃ៖ “លាស​ខាន់​មៃ​អ៝ន់​គ៝ប់​ត៝ប់​អូរ​គ៝ប់​តា​អ្យា​រី ទាន់​ខាន់​មៃ​ឆើម​ងើយ​ដាស​អេប្រុន​អី​ក៝ន​ឆោហារ​អ៝ន់​មា​គ៝ប់ ");
INSERT INTO cmok_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ទាន់​ពាង់​អ៝ន់​ត្រោម​យោក​មាក់ពេលា​ឞើស​ចោង​មីរ​ពាង់​នៃ​អ៝ន់​មា​គ៝ប់ ទាន់​ពាង់​តាច់​នតុក​នៃ​អ៝ន់​គ៝ប់ អ៝ន់​ទី​ខ្លៃ​តា​ឞើស​នាប់​ខាន់​មៃ អ៝ន់​រឹង​ឆៃ​រឹង​តាង់ គៃ​មា​នតុក​នែស​មោច​អី​នៃ​ជេង​នតុក​គ៝ប់​នើម​តា​ផូង​ខាន់​មៃ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ល៝ង់​អេប្រុន​អី​ផូង​ហេត​ពាង់​គុ​នទ្រែល​មា​ផូង​ប៝ន​លាន​តា​នៃ​ដ៝ង់ ពាង់​លាស​មា​អាឞ្រាហាម់ ​តា​នាប់​ផូង​ប៝ន​លាន​ពាង់​នើម នទ្រែល​មា​តា​នាប់​ទឹង​លែៈ​ផូង​ប៝ន​លាន​អី​គុ​តា​ឞោក​មពោង​ប៝ន​នៃ ពាង់​លាស​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“មោ​អោស​កោរាញ ទាន់​មៃ​អ្យាត់​គ៝ប់​ប៝ត់ នែស​មីរ នទ្រែល​មា​នតុក​ត្រោម​យោក​នៃ​គ៝ប់​អ៝ន់​មា​មៃ​ទាទេ គ៝ប់​អ៝ន់​នតុក​នៃ​មា​មៃ​តា​នាប់​មាត់​ទឹង​លែៈ​ផូង​ប៝ន​លាន​គ៝ប់​នើម។ អ៝ន់​មៃ​ត៝ប់​អូរ​មៃ​តា​នែស​នៃ​ទោ”។ ");
INSERT INTO cmok_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ជេសរី​អាឞ្រាហាម់ ​ពាន់​តា​នាប់​មាត់​ទឹង​លែៈ​ផូង​ប៝ន​លាន​តា​ឞ្រី​នៃ​ទូ​តឹ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ពាង់​លាស​មា​អេប្រុន​តា​នាប់​មាត់​ផូង​ប៝ន​លាន​ទឹង​លែៈ៖ “លាស​មៃ​អ៝ន់​កើត​រី ទាន់​មៃ​អ្យាត់​គ៝ប់ គ៝ប់​រាវាត់​នែស​មីរ​មៃ​នៃ​អ៝ន់​ទី​ខ្លៃ ទាន់​មៃ​ឆ៝ៈ​ខ្លៃ​ឞើស​គ៝ប់​ហ៝ម់ គ៝ប់​ឞែ​មា​ត៝ប់​អូរ​គ៝ប់​តា​នតុក​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","យើន​មា​អេប្រុន​អើស​មា​អាឞ្រាហាម់ ៖ ");
INSERT INTO cmok_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“អើ​កោរាញ ខ្លៃ​នែស​នៃ​តា ៤០០ កាក់​ព្រាក់​ទើម ព្រាក់​ទាស​អ្យា​មៃ​មា​គ៝ប់ ឞ៝ន់​មោ​អោស​កើប​ខ្លៃ ទាន់​មៃ​ត៝ប់​អូរ​មៃ​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ជេសរី​អាឞ្រាហាម់ ​អ្យាត់​នាវ​អេប្រុន​លាស​នៃ ពាង់​ញជីង​ព្រាក់​អ៝ន់​មា​អេប្រុន​តា​នាប់​មាត់​ផូង​ប៝ន​លាន​ហេត​តឹម​ទី​ខ្លៃ​កើត​នាវ​ពាង់​លែៈ​លាស​រី​នើស តឹម ៤០០ កាក់​ព្រាក់ ពាង់​ញជីង​ព្រាក់​អី​នៃ​តឹម​ទី​តឹង​នាវ​វៃ​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ជេសរី​នែស​មីរ​អេប្រុន​តា​នតុក​មាក់ពេលា​អី​មពែស​ឞើស​លោស​នារ​មា​ប៝ន​មាម់រេ លែៈ​មា​នែស​មីរ លែៈ​មា​នែស​ត្រោម​យោក នទ្រែល​មា​លែៈ​តើម​ឆី​តា​មីរ​នៃ ");
INSERT INTO cmok_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ជេង​នទើ​អាឞ្រាហាម់ ​ទាទេ នោក​ខាន់​ពាង់​តឹម​អ៝ន់​នៃ តា​នៃ​គែស​ផូង​ប៝ន​លាន​ហេត នទ្រែល​មា​ទឹង​លែៈ​ផូង​ប៝ន​លាន​អី​គុ​តា​ឞោក​មពោង​មពេរ​ប៝ន​នៃ​ឆៃ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ជេសរី​អាឞ្រាហាម់ ​ត៝ប់​ឆារា​អី​អូរ​ពាង់​តា​ត្រោម​យោក​មីរ​មាក់ពេលា មពែស​ឞើស​លោស​នារ​មា​ប៝ន​មាម់រេ អី​ឞូ​ក្វាល់​ដ៝ង់​ប៝ន​ហេប្រ៝ន តា​ឞ្រី​កានាន​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","នែស​មីរ នទ្រែល​មា​នែស​ត្រោម​យោក ទឹង​លែៈ​នតុក​អី​នៃ​លែៈ​ផូង​ប៝ន​លាន​ហេត​អ៝ន់​ជេស​មា​អាឞ្រាហាម់  ជេង​នតុក​នែស​មោច។ ");
INSERT INTO cmok_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","អាឞ្រាហាម់ ​លើ​មា​រាញ​ងាន់ ឞ្រាស​យេហោវា​លែៈ​អ៝ន់​នាវ​គែស​ជេង​តា​លែៈ​នតីល​នទើ​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","គែស​ទូ​នារ​រី​អាឞ្រាហាម់ ​លាស​មា​ឞូនុយ្ស​ជាន​ការ​មា​ពាង់ ឞូនុយ្ស​អី​រាញ​រាលាវ​ឞូ​គុ​តា​ជៃ​ពាង់ នទ្រែល​មា​នើម​អី​នៃ​ជេង​ឞូនុយ្ស​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​ដ៝ង់ ពាង់​លាស៖ “អ៝ន់​មៃ​តេៈ​តី​តា​ន៝ម់​តឹម​ឞ្លូ​គ៝ប់​អ្យា ");
INSERT INTO cmok_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ជេសរី​អ៝ន់​មៃ​ត៝ន​មា​ឞ្រាស​យេហោវា អី​កោរាញ​ឞ្រាស​មា​ត្រោក នទ្រែល​មា​នែស​នតូ អ៝ន់​មៃ​លាស មៃ​លើយ​អោស​ជ៝យ​អូរ​អ៝ន់​មា​ក៝ន​គ៝ប់​តាៈ​ឞើស​ឞូ​អូរ​ផូង​កានាន​តា​នតុក​ឞ្រី​គ៝ប់​គុ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","អ៝ន់​មៃ​ហាន់​តា​នតុក​ឞ្រី​ទែស​គ៝ប់​នើម​រី ជេសរី​ឆើម​ជ៝យ​អូរ​តាៈ​ឞើស​នទុល​មពោល​គ៝ប់​នើម​តា​នៃ​អ៝ន់​មា​ក៝ន​អីឆាក់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ឞូនុយ្ស​ជាន​ការ​នៃ​អើស​មា​ពាង់៖ “ក្លាប់​លាស​ឞូ​អូរ​នៃ​មោ​អុច​អោស​ហាន់​តឹង​គ៝ប់​តា​ឞ្រី​អ្យា លាស​នទ្រី​អ៝ន់​គ៝ប់​លែវ​ក៝ន​មៃ​ហាន់​ព្លឹ​គុ​តា​ឞ្រី​នតុក​ឞ្រី​មៃ​ទូ​លោស​នៃ​នើស​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","អាឞ្រាហាម់ ​លាស​មា​ពាង់៖ “មៃ​ញជ្រាង់​ហ៝ៈ គ៝ប់​លាស​មា​មៃ ក៝ន​គ៝ប់​មោ​អោស​អ៝ន់​លែវ​ហាន់​តា​ឞ្រី​នៃ! ");
INSERT INTO cmok_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","យ៝រ​លាស​ឞ្រាស​យេហោវា​អី​កោរាញ​តា​កាលើ​ត្រោក​លែៈ​លែវ​ជេស​គ៝ប់​ទូ​លោស​ឞើស​នទុល​មពោល​គ៝ប់ ឞើស​នតុក​ឞ្រី​ទែស​គ៝ប់​នើម ជេសរី​ពាង់​លែៈ​លាស​មា​គ៝ប់ នទ្រែល​មា​លែៈ​ត៝ន​ដ៝ង់ នហេល​នានេៈ​ងាន់​ឞ្រី​អ្យា​ពាង់​ត៝ន​អ៝ន់​មា​រាន៝យ​ទែស​គ៝ប់។ លាស​នទ្រី​ពាង់​ដាៈ​តោង​ពារ់​ពាង់នើម​ហាន់​ឞើស​នាប់​មៃ​រ៝​គៃ​មា​កើល​មៃ ជេសរី​អ៝ន់​មៃ​ឆ៝ៈ​អូរ​មា​ក៝ន​គ៝ប់​តាៈ​ឞើស​ឞ្រី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","យើន​មា​លាស​ឞូ​អូរ​នៃ​រាលាច់​មោ​អុច​ហាន់​តឹង​មៃ មៃ​លែៈ​ក្លាយ្ស​ជេស​នាវ​មៃ​ត៝ន​អ្យា​មា​គ៝ប់ អ្យាត់​មា​មៃ​លើយ​អោស​លែវ​ក៝ន​គ៝ប់​ហាន់​តា​ឞ្រី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ជេសរី​ឞូនុយ្ស​ជាន​ការ​នៃ​តេៈ​តី​តា​តឹម​ឞ្លូ​អាឞ្រាហាម់ ​កោរាញ​ពាង់​រី នហ៝​មា​ពាង់​ត៝ន​នាវ​នៃ​ដាស​អាឞ្រាហាម់ ។ ");
INSERT INTO cmok_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ជេសរី​ឞូនុយ្ស​ជាន​ការ​នៃ​ឆ៝ៈ​ឆែស​ឆាមោ​ជឹត​អឹ នទ្រែល​មា​ញអោត​ទ្រាប់​នទើ​គែស​នាវ​ខ្លៃ​អី​កោរាញ​រី​អ៝ន់ ពាង់​ហាន់​តា​ប៝ន​នាហោរ​ឞ្រី​មេឆោពោតាមៀ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ហាន់​ត៝ត់​កេង​ទូ​នតូ​ទាក​តា​ឞើស​ទីស​ប៝ន​រី ពាង់​អ៝ន់​ទឹង​លែៈ​ឆែស​ឆាមោ​ពាង់​រី​ទ្រោម​ទាទេ នោក​នៃ​ឞ្រី​លែៈ​កេង​មាង់​តឹម​ទី​មា​ផូង​ឞូ​អូរ​វៃ​ហាន់​ឞ្រោៈ​ឞុក​ទាក​ត៝។ ");
INSERT INTO cmok_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ឞូនុយ្ស​ជាន​ការ​នៃ​មឞើស​ឆើម៖ “អើ​ឞ្រាស​យេហោវា អី​ឞ្រាស​អាឞ្រាហាម់ ​ជេង​កោរាញ​គ៝ប់​យើក​មឞាស នារ​អ្យា​ទាន់​មៃ​កើល​គ៝ប់ អ៝ន់​គ៝ប់​តឹម​ម៝ប់​មា​ឞូ​អូរ​ទូ​ហ្វេ​មា​ជាន​អូរ​អីឆាក់។ ទាន់​ញហើ​ហ៝ម់​នាវ​រ៝ង់​រាប់​ជាប់​មៃ​អី​ហោម​នឹង​មា​អាឞ្រាហាម់ ​កោរាញ​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","គ៝ប់​លែៈ​គុ​ទាច់​កេង​មែង​នតូ​ទាក​អ្យា​ជេស លាស​ត៝ត់​ផូង​ក៝ន​ឞូ​អូរ​តា​ប៝ន​អ្យា​ហាន់​ឞុក​ទាក ");
INSERT INTO cmok_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","លាស​ឞូ​ម៝ស​ឞូ​អូរ​ទ្រោស​អី​គ៝ប់​ទែ​លាស៖ «ទាន់​ទាក​តា​រាឞ៝ង់​អៃ​នៃ​គ៝ប់​ឞែ​មា​ញេត​ដេៈ​យោស​អើ» ជេសរី​លាស​ពាង់​អើស​មា​គ៝ប់៖ «ញេត​ហែស​កោញ តៃ​គ៝ប់​ឞុក​ទាក​មា​អ៝ន់​ឆែស​ឆាមោ​មៃ​ញេត​ដ៝ង់» លាស​នទ្រី​ទាន់​អ៝ន់​តឹម​ទី​មា​ឞូ​អូរ​អី​មៃ​លែៈ​នត្រ៝ង់​មា​ជេង​អូរ​អីឆាក់។ នទ្រី​ទឹង​គ៝ប់​គឹត​នទើ​នៃ​នហេល​នានេៈ​ងាន់ ជេង​នទើ​មៃ​ញហើ​នាវ​រ៝ង់​រាប់​ជាប់​មៃ​អ៝ន់​មា​កោរាញ​គ៝ប់​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","អេ​ហ៝ៈ​នាន់​អោស​លោច​នាវ​ពាង់​មឞើស​ឆើម​នៃ ទោ​មា​ឆៃ​រេបេកា​លោស​ឞើស​ប៝ន​នៃ តេៈ​នោង​រាឞ៝ង់​តា​មលីក​ពាង់​នើម​រី។ រេបេកា​នៃ​អី​ក៝ន​ឞូ​អូរ​បេថូអែលបេថូអែល​អី​ក៝ន​ឞូ​ក្លោ​មីលកា មីលកា ​អី​អូរ​នាហោរ​អ៝ស​អាឞ្រាហាម់ ​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","រេបេកា​ជេង​ឞូ​អូរ​អ្វែស​រែស​ងាន់ ហោម​អែ​ទ្រោស​អេ​ហ៝ៈ​គែស​អោស​ដាស​ឞូ​ក្លោ។ ពាង់​ហាន់​ត៝ត់​តា​នតូ​ទាក​នៃ ពាង់​ជុរ​ឞុក​ទាក​ឞេង​នោង​រាឞ៝ង់​រី ជេសរី​ពាង់​ទ៝ក់​ឆឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ឞូនុយ្ស​ជាន​ការ​អាឞ្រាហាម់ ​នៃ​ញច្វាត់​រាន​ជឹត​ពាង់​រី ជេសរី​លាស៖ “ទាន់​ទាក​តា​រាឞ៝ង់​អៃ​នៃ​គ៝ប់​ឞែ​មា​ញេត​ដេៈ​យោស​អើ”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ឞូ​អូរ​នៃ​អើស៖ “ញេត​ហែស​កោរាញ”។ ឞូ​អូរ​នៃ​ជុយ្ស​រ៝​អ៝ន់​ពាង់​ញេត។ ");
INSERT INTO cmok_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ជេស​អ៝ន់​ពាង់​ញេត​រី ឞូ​អូរ​នៃ​លាស៖ “តៃ​គ៝ប់​ហាន់​ឞុក​ទាក​មា​អ៝ន់​ឆែស​ឆាមោ​មៃ​ញេត​អ៝ន់​ត៝ត់​ហើម​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ជេសរី​ពាង់​ងខុត​ទាក​តា​ឞ៝ង​រី​រ៝ ពាង់​ព្លឹ​ឞុក​តៃ​ទាក​មា​អ៝ន់​ឆែស​ឆាមោ​រី​ញេត​ត៝ត់​ហើម​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ឞូ​ក្លោ​អី​នៃ​អ្វាញ់​ជឹត​ពាង់​រី​រាល៝ល់ ពាង់​មឹន​អេង​តា​នូយ្ស​នហ៝ម់​រី​អុច​គឹត គឹត​ឞ្រាស​យេហោវា​ជាន​អ៝ន់​ពាង់​កើត​នាវ​ពាង់​អុច​នើស​ងាន់​លាស​មោ។ ");
INSERT INTO cmok_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ទឹង​លែៈ​ឆែស​ឆាមោ​រី​ញេត​ទាក​លែៈ​ហើម​ទាទេ​ជេស ជេសរី​ពាង់​ឆ៝ៈ​ទូ​មល៝ម់​រាគេន​មាយ្ស​ជ៝ក់​ទូ​ចី​ងគូល​តេៈ​តា​ត្រោម​មុស​ឞូ​អូរ​នៃ ឆ៝ៈ​ដ៝ង់​ឞារ​មល៝ម់​កោង​តី​មាយ្ស​ជ៝ក់ ៣០ ចី​អ៝ន់​មា​ឞូ​អូរ​ទ្រោស​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ជេសរី​ពាង់​អោប​ឞូ​អូរ​ទ្រោស​នៃ៖ “អៃ​ឞូ​ម៝ស​ក៝ន? ទាន់​មឞើស​មា​គ៝ប់។ អាស​តា​ជៃ​ឞឹ​អៃ​គឹត​គែស​នតុក​ហេន​ទែ​មា​ឞិច​មាង់​អ្យា?” ");
INSERT INTO cmok_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ឞូ​អូរ​ទ្រោស​នៃ​អើស​មា​ពាង់៖ “គ៝ប់​ក៝ន​បេថូអែល អី​ក៝ន​ចែ​នាហោរ នទ្រែល​មា​អូ​មីលកា ”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ឞូ​អូរ​ទ្រោស​នៃ​លាស​តៃ​មា​ពាង់៖ “តា​ជៃ​ហេន​គែស​អ៝ក់​រាហែ​មា​ឆែស​ឆាមោ​ឞិច នទ្រែល​មា​រេប​លែៈ​ឆើស​មា​មពា​ឆែស​ឆាមោ​ឆា នទ្រែល​មា​នតុក​មា​អ៝ន់​ខាន់​មៃ​ឞិច​គែស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ជេសរី​ឞូនុយ្ស​ជាន​ការ​នៃ​ពាង់​កុញ​ឞោក យើក​មឞាស​មា​ឞ្រាស​យេហោវា ");
INSERT INTO cmok_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ពាង់​លាស៖ “រានេ​មា​ឞ្រាស​យេហោវា អី​ឞ្រាស​អាឞ្រាហាម់ ​ជេង​កោរាញ​គ៝ប់​យើក​មឞាស មៃ​មោ​រាលូន​អោស​អ៝ន់​នាវ​រ៝ង់​រាប់​ជាប់​មៃមៃ​ជាន​កើត​នាវ​មៃ​លែៈ​លាស​បាបើ​មា​កោរាញ​គ៝ប់ ល៝ង់​គ៝ប់​អ្យា​ឞ្រាស​យេហោវា​ដ៝ង់​លែវ​ត្រ៝ង​ទឹង​ត៝ត់​តា​ជៃ​នទុល​មពោល​កោរាញ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ជេសរី​ឞូ​អូរ​នៃ​ញច្វាត់​អា​ជៃ​មេៈ​ពាង់ នហ៝​មា​មឞើស​ងក៝ច​នាវ​អី​នៃ​មា​ទឹង​លែៈ​ឞូនុយ្ស​តា​ជៃ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","រេបេកា​គែស​ទូ​ហ្វេ​នោ​រាញា​លាបានលាបាន​ញច្វាត់​ជ៝យ​ឞូ​ក្លោ​នៃ​អា​នតូ​ទាក​រី ");
INSERT INTO cmok_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","យ៝រ​លាស​ពាង់​ឆៃ​កោង​តា​តី​ដ៝ង់ ឆៃ​រាគេន​តា​ត្រោម​មុស​ដ៝ង់ នទ្រែល​មា​តាង់​រេបេកា​អី​អ៝ស​ទែ​មឞើស​ងក៝ច​ទឹង​លែៈ​នាវ​ឞូ​ក្លោ​នៃ​លាស ជេសរី​ពាង់​ហាន់​ម៝ប់​ឞូ​ក្លោ​នៃ ឆៃ​ពាង់​ទ៝ក់​កេង​នតូ​ទាក​រី​នទ្រែល​មា​ឆែស​ឆាមោ។ ");
INSERT INTO cmok_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","លាបាន​លាស​មា​ឞូ​ក្លោ​អី​នៃ៖ “អើ​ឞូនុយ្ស​លែៈ​ឞ្រាស​យេហោវា​ទែ​អ៝ន់​គែស​ជេង លាប់​ហ៝ម់ ម៝ស​គុ​មៃ​ឞើស​ទីស​អ្យា? លែៈ​ជេស​គ៝ប់​នទ្រាប់​ជៃ​មា​មៃ នទ្រែល​មា​នតុក​អ៝ន់​ឆែស​ឆាមោ​មៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ជេសរី​ឞូ​ក្លោ​អី​នៃ​លាប់​អា​ត្រោម​ជៃ​តី។ លាបាន​ទ្រីស​ញជុរ​នទ៝ស​នទើ​ឞើស​លើ​ឆែស​ឆាមោ​រី​ផ្យៅ ឞូ​ឆ៝ៈ​ជា​ឆ៝ៈ​រាហែ​មា​អ៝ន់​ឆែស​ឆាមោ​ទែ​ឆា នទ្រែល​មា​ឆ៝ៈ​ទាក​មា​អ៝ន់​ឞូ​ក្លោ​នៃ​រាវ​ជ៝ង់ នអ៝ប់​មា​មពោល​អី​ហាន់​នទ្រែល​ពាង់​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ជេសរី​ឞូ​លែៈ​នទ្រាប់​ព្យាង់​ត្រាវ​អ៝ន់​ពាង់​ឆោង យើន​មា​ពាង់​លាស៖ “គ៝ប់​មោ​ហ៝ៈ​អោស​ឆោង លាស​នាវ​គ៝ប់​ហាន់​អ្យា​គ៝ប់​មោ​ហ៝ៈ​មឞើស​ងក៝ច​មា​ខាន់​មៃ” លាបាន​លាស៖ “នែស ងក៝ច​ហ៝ម់!” ");
INSERT INTO cmok_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ពាង់​លាស៖ “គ៝ប់​អ្យា​ជេង​ឞូនុយ្ស​ជាន​ការ​អាឞ្រាហាម់ ។ ");
INSERT INTO cmok_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ឞ្រាស​យេហោវា​អ៝ន់​គែស​ជេង​មា​កោរាញ​គ៝ប់​លែៈ​ទុត​អ៝ក់ នហ៝​មា​ពាង់​ត៝ត់​ជេង​ឞូនុយ្ស​នទ្រ៝ង់​ងាន់ កោរាញ​ឞ្រាស​អ៝ន់​ពាង់​គែស​ឞែ​ឞ្យាប់ គែស​នទ្រោក គែស​ឆែស​ឆាមោ គែស​ឆែស​លៀ នទ្រែល​មា​គែស​ព្រាក់ គែស​មាយ្ស គែស​នអ៝ប់​មា​ទឹក​ឞូ​អូរ​ទឹក​ឞូ​ក្លោ​អ៝ក់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","នោក​កោរាញ​គ៝ប់​ពាង់​លែៈ​រាញ​ងាន់ អី​អូរ​ពាង់​រាញា​ឆារា​គុ​អ៝ស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​មា​ពាង់ កោរាញ​គ៝ប់​លែៈ​អ៝ន់​ជេស​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស​មា​ក៝ន​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","កោរាញ​គ៝ប់​ពាង់​ដាៈ​គ៝ប់​ត៝ន​អ្យាត់​នាវ​ពាង់ ពាង់​លាស៖ «មៃ​លើយ​អោស​ជ៝យ​អូរ​មា​ក៝ន​គ៝ប់​តាៈ​ឞើស​ផូង​កានាន​នតុក​ឞ្រី​គ៝ប់​គុ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","អ៝ន់​មៃ​ហាន់​តា​ជៃ​ឞឹ​គ៝ប់ តា​នទុល​មពោល​គ៝ប់​នើម​រី ជេសរី​ឆើម​ជ៝យ​អូរ​មា​ក៝ន​គ៝ប់​តាៈ​ឞើស​មពោល​នៃ»។ ");
INSERT INTO cmok_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","គ៝ប់​លាស​មា​កោរាញ​គ៝ប់៖ «ក្លាប់​លាស​ឞូ​អូរ​អី​នៃ​មោ​អុច​អោស​តឹង​គ៝ប់​តា​ឞ្រី​អ្យា»។ ");
INSERT INTO cmok_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ពាង់​លាស​មា​គ៝ប់៖ «ឞ្រាស​យេហោវា​អី​គ៝ប់​ទែ​អ្យាត់​បាបើ ពាង់​អ៝ន់​តោង​ពារ់​ពាង់នើម​ហាន់​នទ្រែល​មៃ គៃ​មា​ជាន​អ៝ន់​មៃ​ត៝ត់​គែស​ងាន់។ អ៝ន់​មៃ​ឆើម​ជ៝យ​អូរ​មា​ក៝ន​គ៝ប់​តាៈ​ឞើស​នទុល​មពោល​តាៈ​ឞើស​រានាក់​វ៝ល់​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","អ៝ន់​មៃ​ហាន់​ត៝ត់​តា​នទុល​មពោល​គ៝ប់​រី លាស​ឞូ​មោ​អោស​អ៝ន់​ក៝ន​មា​មៃ រី​មើ​មៃ​មោ​ហោម​អោស​ក្រេប​ដាស​នាវ​លែៈ​ជេស​ត៝ន​អ្យា»។ ");
INSERT INTO cmok_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","នារ​អ្យា​គ៝ប់​ហាន់​ត៝ត់​តា​នតូ​ទាក គ៝ប់​មឞើស​ឆើម៖ «អើ​ឞ្រាស​យេហោវា អី​ឞ្រាស​អាឞ្រាហាម់ ​ជេង​កោរាញ​គ៝ប់​យើក​មឞាស ទាន់​មៃ​អ៝ន់​គែស​ងាន់​នទើ​អី​កោរាញ​គ៝ប់​ដាៈ​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","អាបៃ​រី​គ៝ប់​លែៈ​គុ​ទាច់​កេង​នតូ​ទាក​អ្យា​ជេស លាស​គែស​ឞូ​អូរ​ទ្រោស​ហាន់​ឞុក​ទាក លាស​គ៝ប់​លាស​មា​ពាង់៖ «អើ​យោស ទាន់​ទាក​តា​រាឞ៝ង់​អៃ​នៃ​គ៝ប់​ឞែ​មា​ញេត​ដេៈ​អើ» ");
INSERT INTO cmok_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","លាស​ឞូ​អូរ​នៃ​អើស៖ «អ្យា​ញេត​ហ៝ម់ តៃ​គ៝ប់​ឞុក​ជឹត​មា​អ៝ន់​ឆែស​ឆាមោ​មៃ​ញេត​ដ៝ង់» លាស​នទ្រី​អ៝ន់​តឹម​ទី​មា​ឞូ​អូរ​អី​មៃ​លែៈ​ជេស​នត្រ៝ង់​មា​ជេង​អូរ​អី​ក៝ន​កោរាញ​គ៝ប់​ងាន់»។ ");
INSERT INTO cmok_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","នោក​នៃ​គ៝ប់​មឞើស​ឆើម​អេ​ហ៝ៈ​នាន់​លោច​អោស ទោ​មា​ឆៃ​រេបេកា​លោស​ឞើស​ប៝ន តេៈ​នោង​រាឞ៝ង់​តា​មលីក​ពាង់​រី​ហាន់​អា​នតូ​ទាក។ ជេស​ពាង់​ជុរ​ឞុក​ទាក​ឞេង គ៝ប់​លាស​មា​ពាង់៖ «អើ​យោស ទាន់​ទាក​អៃ​នៃ​គ៝ប់​ឞែ​មា​ញេត​ដេៈ​អើ»។ ");
INSERT INTO cmok_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ពាង់​ជុយ្ស​នោង​រាឞ៝ង់​ឞើស​មលីក​រី​រ៝ ពាង់​លាស​មា​គ៝ប់៖ «អ្យា​ញេត​ហ៝ម់ តៃ​គ៝ប់​ឞុក​ជឹត​ទាក​មា​អ៝ន់​ឆែស​ឆាមោ​មៃ​ញេត​ដ៝ង់»។ ជេសរី​គ៝ប់​ញេត​ទាក​អី​រី ពាង់​ឞុក​តៃ​ទាក​មា​អ៝ន់​ឆែស​ឆាមោ​គ៝ប់​ញេត​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","គ៝ប់​អោប​ពាង់៖ «អៃ​ឞូ​ម៝ស​ក៝ន?» ពាង់​អើស៖ «គ៝ប់​ក៝ន​បេថូអែល អី​ក៝ន​ចែ​នាហោរ នទ្រែល​មា​អូ​មីលកា »។ ជេសរី​គ៝ប់​ឆ៝ៈ​រាគេន​តេៈ​តា​ត្រោម​មុស​ពាង់ នទ្រែល​មា​កោង​តី​នទ៝ក​តា​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ជេសរី​គ៝ប់​ពាន់​យើក​មឞាស​មា​ឞ្រាស​យេហោវា រានេ​មា​ឞ្រាស​យេហោវា​អី​ឞ្រាស​អាឞ្រាហាម់ ​ជេង​កោរាញ​គ៝ប់​យើក​មឞាស យ៝រ​មា​ពាង់​ឆើម​លែវ​ត្រ៝ង​មា​គ៝ប់​ទឹង​ត៝ត់​តា​នទុល​មពោល​កោរាញ​គ៝ប់ នទ្រែល​មា​ឆៃ​ក៝ន​ឞូ​អូរ​ខាន់​ពាង់ គៃ​មា​ឆ៝ៈ​ជេង​អូរ​អី​ក៝ន​កោរាញ​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","អាបៃ​អ្យា លាស​ខាន់​មៃ​ជាន​អ្វែស នទ្រែល​មា​នាវ​ងាន់​មា​កោរាញ​គ៝ប់ ទាន់​ខាន់​មៃ​ងើយ អុច​មោ​លាស​មោ គៃ​មា​គ៝ប់​គឹត​ដ៝ង់ ម៝ស​នទើ​គ៝ប់​ជាន​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ជេសរី​លាបាន នទ្រែល​មា​បេថូអែល​លាស​មា​ពាង់៖ “ទឹង​គែស​ជេង​នាវ​អ្យា​នើស​តាៈ​ឞើស​ឞ្រាស​យេហោវា លាស​នទ្រី​ហេន​មោ​ឞ្លាវ​លាស​អុច មោ​ឞ្លាវ​លាស​មោ​អុច​មា​មៃ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","នៃ​រេបេកា​លែៈ​តា​នៃ មៃ​ញអោត​លែវ​ពាង់​អា​រី មា​អ៝ន់​ដាស​ក៝ន​កោរាញ​មៃ​រី កើត​នាវ​ឞ្រាស​យេហោវា​ទែ​លាស​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ត៝ត់​មា​ឞូនុយ្ស​ជាន​ការ​អាឞ្រាហាម់ ​តាង់​លាស​កើត​នៃ ពាង់​ពាន់​យើក​មឞាស​មា​ឞ្រាស​យេហោវា​។ ");
INSERT INTO cmok_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ជេសរី​ពាង់​ងលោស​ទ្រាប់​នទើ​ងក្រឹ ព្រាក់ មាយ្ស នទ្រែល​មា​ឞ៝ក​អាវ​អ៝ន់​មា​រេបេកា​នៃ ពាង់​អ៝ន់​ដ៝ង់​នទើ​ទុត​ខ្លៃ​មា​មេៈ​មា​នោ​រេបេកា​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ជេសរី​មើ​ទឹង​ពាង់ នទ្រែល​មា​មពោល​អី​ហាន់​ដាស​ពាង់​នៃ​នើស​ញេត​ឆោង។ មាង់​នៃ​ខាន់​ពាង់​ឞិច​តា​នៃ កាស​អោយ​តៃ​រី​អើម​អោយ​ពាង់​ទ៝ក់ ពាង់​លាស​មា​ផូង​តើម​ជៃ​នៃ៖ “ទាន់​អ៝ន់​គ៝ប់​ព្លឹ​ឆឹត​អា​កោរាញ​គ៝ប់​នើម​នារ​អ្យា​យឹ”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","យើន​មា​អី​នោ នទ្រែល​មា​អី​មេៈ​រេបេកា​នៃ​លាស​មា​ពាង់៖ “អ៝ន់​រេបេកា​គុ​នទ្រែល​មា​ហេន​តា​អ្យា​ប៝ត់​ហែស ក្លាប់​លាស​ត៝ត់​ជឹត​នារ​ប៝ត់​ទឹង​ហាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ឞូនុយ្ស​ជាន​ការ​អាឞ្រាហាម់ ​នៃ​អើស​មា​ខាន់​ពាង់៖ “ខាន់​អៃ​មៃ​លើយ​អោស​ក៝ន់​គ៝ប់ អ៝ន់​គ៝ប់​ព្លឹ​ឆឹត​មា​កោរាញ​គ៝ប់​នើម យ៝រ​លាស​នាវ​ឞ្រោៈ​ហាន់​គ៝ប់​អ្យា​លែៈ​ឞ្រាស​យេហោវា​ជាន​ជេស​ផ្យៅ​ជេស”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ខាន់​ពាង់​លាស៖ “ក៝ប់​ហេន​ក្វាល់​រេបេកា អោប​ពាង់​នើម​ប៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ជេសរី​ខាន់​ពាង់​ក្វាល់​រេបេកា អោប​ពាង់៖ “អ៝ស អៃ​អុច​ហាន់​នទ្រែល​មា​ពាង់​អ្យា​ឞើស?” រេបេកា​អើស៖ “អើ គ៝ប់​អុច”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ជេសរី​អ៝ន់​រេបេកា​អី​អ៝ស​ឞូ​អូរ​ពាង់​រី នទ្រែល​មា​ឞូនុយ្ស​ឆើម​មពូ​ត៝ស​ពាង់​នៃ អ៝ន់​ហាន់​នទ្រែល​មា​ឞូនុយ្ស​ជាន​ការ​អាឞ្រាហាម់  ឞូ​អ៝ន់​ខាន់​ពាង់​ហាន់​ទាទេ​នទ្រែល​មា​លែៈ​ឞូនុយ្ស​អី​ហាន់​ដាស​ពាង់​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","រានាក់​វ៝ល់​រេបេកា​អ៝ន់​នាវ​គែស​ជេង​មា​ពាង់៖ “អើ​អ៝ស អ៝ន់​អៃ​គែស​ក៝ន​ឞឹក​រឹ​ងាន់ ជេសរី​រាន៝យ​ទែស​អៃ​អ៝ន់​ជេង​កោរាញ​មា​ផូង​រាលាង់​ដាស​ខាន់​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ជេសរី​រេបេកា នទ្រែល​មា​មពោល​ឞូ​អូរ​ជាន​ការ​មា​ពាង់​ញច៝​ឆែស​ឆាមោ​ហាន់​តឹង​ឞូ​ក្លោ​អី​ឞូនុយ្ស​ជាន​ការ​អាឞ្រាហាម់ ​ហាន់​ព្លឹ​ឆឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","នោក​ខាន់​ពាង់​ហោម​ហាន់​រ៝ៈ​ត្រ៝ង អីឆាក់​លែៈ​លោស​ឞើស​នតុក​រាញា​តូ​ទាក​លាហាយរ៝យ ពាង់​គុ​តា​ឞ្រី​រាទាស​នេកិប។ ");
INSERT INTO cmok_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","នោក​ឞ្រី​កេង​មាង់ ពាង់​ហាន់​ព៝ល់​រ៝ៈ​មីរ ពាង់​ងើក​ឆៃ​ហាន់​នហ៝ច​ឆែស​ឆាមោ​ត៝ត់​តា​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","រេបេកា​នៃ​ឆៃ​ដ៝ង់ ត៝ត់​មា​ឆៃ​អីឆាក់​រី ពាង់​ជុរ​ឞើស​លើ​ឆែស​ឆាមោ ");
INSERT INTO cmok_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","អោប​ឞូនុយ្ស​ជាន​ការ​អាឞ្រាហាម់ ​នៃ៖ “ឞូ​ម៝ស​អី​គុ​តា​មីរ​រី ហាន់​ជឹត​អ្យា​រី?” ពាង់​អើស៖ “ពាង់​អី​នៃ​អីឆាក់​អី​កោរាញ​គ៝ប់”។ នទ្រី​រេបេកា​ឆ៝ៈ​ឞ៝ក​ងកុម​លើយ​មុស​មាត់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ឞូនុយ្ស​ជាន​ការ​អី​នៃ​មឞើស​ងក៝ច​មា​អីឆាក់​ទឹង​លែៈ​នតីល​នទើ​ពាង់​ជាន​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ជេសរី​អីឆាក់​ឆ៝ៈ​រេបេកា​ជេង​អូរ​ពាង់ ពាង់​លែវ​រេបេកា​លាប់​តា​ត្រោម​ចូន​ឆារា​អី​មេៈ​ពាង់​រី​នើស ពាង់​គែស​នូយ្ស​នហ៝ម់​រ៝ង់​មា​រេបេកា​ហោ​ងាន់ នហ៝​មា​ឞាស​ងក្ល៝ន់​រាវៃ​អី​មេៈ​ពាង់​ខឹត​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","អាឞ្រាហាម់ ​ឆ៝ៈ​តៃ​អូរ​អេង​ជឹត​រាញា​កិតូរា។ ");
INSERT INTO cmok_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ឞូ​អូរ​នៃ​គុ​អ៝ស​ក៝ន​ឞូ​ក្លោ​មា​ពាង់ តា​នៃ​គែស៖ ឆឹមរាន គែស​យុកឆាន គែស​មេដាន គែស​មីដៀន គែស​អីសបាក់ នទ្រែល​មា​គែស​ឆូអា។ ");
INSERT INTO cmok_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","យុកឆាន​អី​នៃ​ឞាៈ​ឆេបា នទ្រែល​មា​ដេដាន អី​ក៝ន​ឆៅ​ដេដាន​នៃ​ទឹង​ជេង​គែស​ផូង​អាសឆើរ ផូង​លេតូឆីម នទ្រែល​មា​ផូង​លេអូមីម។ ");
INSERT INTO cmok_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","អី​ក៝ន​ឆៅ​មីដៀន​រី តា​នៃ​គែស៖ អេផា គែស​អេផើរ គែស​ហានុក  គែស​អាបីដា នទ្រែល​មា​គែស​អែលដា។ ទឹង​លែៈ​ផូង​អី​នៃ​ជេង​ក៝ន​ឆៅ​កិតូរា​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ទឹង​លែៈ​នទើ​អាឞ្រាហាម់ ​គែស ពាង់​អ៝ន់​មា​អីឆាក់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","យើន​មា​នោក​អាឞ្រាហាម់ ​ហោម​រេស ពាង់​អ៝ន់​ដ៝ង់​នទើ​អាបាៈ​មា​ក៝ន​អូរៗ​ចោង​ពាង់​រី ពាង់​អ៝ន់​ផូង​នៃ​ទូ​ងាយ​ឞើស​អីឆាក់ អ៝ន់​ខាន់​ពាង់​គុ​អា​ឞ្រី​មពែស​ឞើស​លោស​នារ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","អាឞ្រាហាម់ ​រេស គែស ១៧៥ នាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ពាង់​រេស​មពៃ​លែៈ​ជ៝ៈ​ងាន់ នអ៝ប់​មា​លែៈ​រាញ​ងាន់​ដ៝ង់ ជេសរី​ពាង់​រ៝ស​នហ៝ម់​ខឹត​ហាន់​គុ​នទ្រែល​មា​ផូង​ចែ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ជេសរី​ក៝ន​ពាង់​អីឆាក់ នទ្រែល​មា​អីសមាអែល​ត៝ប់​ពាង់​តា​ត្រោម​យោក​មាក់ពេលា​មពែស​ឞើស​លោស​នារ​មា​ប៝ន​មាម់រេ តា​មីរ​អេប្រុន​អី​ក៝ន​ឆោហារ​ផូង​ហេត។ ");
INSERT INTO cmok_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","អី​នៃ​ជេង​មីរ​អាឞ្រាហាម់ ​ទែ​រាវាត់​តាៈ​ឞើស​ផូង​ហេត​នើស តា​នៃ​ឞូ​ត៝ប់​អាឞ្រាហាម់  ត៝ប់​នទ្រែល​តា​នតុក​ពាង់​ត៝ប់​ឆារា​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ជេស​ខឹត​អាឞ្រាហាម់ ​រី កោរាញ​ឞ្រាស​អ៝ន់​គែស​ជេង​មា​អីឆាក់​ក៝ន​ពាង់​រី អីឆាក់​ហាន់​គុ​ទាច់​កេង​តូ​ទាក​លាហាយរ៝យ។ ");
INSERT INTO cmok_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","អ្យា​ជេង​ងក៝ច​យៅ​ទែស​ក៝ន​ឆៅ​អីសមាអែល អី​ក៝ន​អាឞ្រាហាម់  ជេង​ក៝ន​ហាការ​ឞូ​អូរ​ផូង​អេឆីប ​អី​ទឹក​ឆារា​ឞាៈ​អ៝ន់​មា​អាឞ្រាហាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","អ្យា​ជេង​រាញា​ក៝ន​ឞូ​ក្លោ​អីសមាអែល រាញា​តឹង​ឞូ​ម៝ស​ទែស​ល៝រ ឞូ​ម៝ស​ទែស​ឞើស​កើយ ក៝ន​ឞោក​ទាក​អីសមាអែល​រាញា​នេបាយោត ជេសរី​អី​អ៝សៗ​រាញា​កេដារ រាញា​អាត់បែល រាញា​មីបឆាម‌ ");
INSERT INTO cmok_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","រាញា​មីសមា រាញា​ដូមា រាញា​មាឆា‌ ");
INSERT INTO cmok_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","រាញា​ហាដាត់ រាញា​ថេមា រាញា​យេថូរ រាញា​នាផីស នទ្រែល​មា​រាញា​កេតមា។ ");
INSERT INTO cmok_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ទឹង​លែៈ​ក៝ន​អីសមាអែល​អី​នៃ អី​នៃ​រាញា​ខាន់​ពាង់​តឹង​ប៝ន​តឹង​នតុក​ខាន់​ពាង់​គុ ទឹង​លែៈ ១២ នុយ្ស​នៃ​ជេង​កោរាញ​តា​នទុល​មពោល​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","អីសមាអែល​រេស​គែស ១៣៧ នាម់ ជេសរី​ពាង់​រ៝ស​នហ៝ម់​ខឹត​គុ​នទ្រែល​មា​ផូង​ចែ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ឞ្រី​ផូង​ក៝ន​ឆៅ​អីសមាអែល​គុ នតើម​ឞើស​ឞ្រី​ហាវីលា ត៝ត់​អា​ឞ្រី​ឆូរ​ទាច់​មា​ឞ្រី​អេឆីប ​មពែស​មា​ឞ្រី​អាឆើរ។ ផូង​ក៝ន​ឆៅ​អីសមាអែល​ខាន់​ពាង់​គុ​តឹម​លើស​នទ្រាង់​អ៝ស​នោ​ខាន់​ពាង់​នើម​នឹង។ ");
INSERT INTO cmok_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","អ្យា​នាវ​ងក៝ច​យៅ​អីឆាក់​ក៝ន​អាឞ្រាហាម់ ៖ អាឞ្រាហាម់ ​ឞាៈ​អីឆាក់។ ");
INSERT INTO cmok_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ត៝ត់​អីឆាក់​លែៈ​គែស ៤០ នាម់ ពាង់​ឆ៝ៈ​រេបេកា​ជេង​អូរ។ រេបេកា​នៃ​អី​ក៝ន​បេថូអែល​អី​អ៝ស​លាបានបេថូអែល​នៃ​ផូង​អារាម​គុ​តា​ឞ្រី​ពាដាន-អារាម។ ");
INSERT INTO cmok_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","អីឆាក់​មឞើស​ឆើម​មា​ឞ្រាស​យេហោវា យ៝រ​លាស​អូរ​ពាង់​នៃ​ជេង​ឞូ​អូរ​មោ​អោស​ឞាៈ​ក៝ន ឞ្រាស​យេហោវា​អ្យាត់​នាវ​ពាង់​មឞើស​ឆើម ជេសរី​អូរ​ពាង់​នត្រែវ។ ");
INSERT INTO cmok_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ក៝ន​តា​ត្រោម​នទុល​រេបេកា​គែស​ឞារ​អឹ​តឹម​ថាក់​ឞាល់ ពាង់​លាស៖ “មើម​ទឹង​ជេង​កើត​នទ្រី​ច្រាវ?” ជេសរី​ពាង់​អោប​ឞ្រាស​យេហោវា។ ");
INSERT INTO cmok_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ឞ្រាស​យេហោវា​លាស​មា​ពាង់៖ “អៃ​គែស​ឞារ​អឹ​ឞ្រី​ទាក​គុ​តា​ត្រោម​នទុល​អៃ​នៃ អៃ​ទែស​គែស​ឞារ​អឹ​ផូង​តាៈ​ឞើស​នទុល​អៃ​អី​តឹម​រាទ៝ង់​ឞាល់ ទូ​ផូង​ជេង​ទាង់​រាលាវ​ដាស​មា​ទូ​ផូង ក៝ន​ឞោក​ទាក​ជេង​ព្លាច់​ឆើម​កើល​ជាន​ការ​អ៝ន់​មា​អី​អ៝ស”។ ");
INSERT INTO cmok_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ត៝ត់​អាប់​ខៃ​រី ពាង់​គុ​អ៝ស​គែស​ក៝ន​ឞារ​ងាន់ ក៝ន​ឞូ​ក្លោ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ក៝ន​អី​ឞោក​ទាក​រី​ឆាក់​ពាង់​ទុម​ងាន់ គែស​រាឆៅ​តឹម​ឞាន​មា​រាឆៅ​មពោមពា​(ឆ្យុម) ឞូ​តេៈ​រាញា «អេឆាវ»។ ");
INSERT INTO cmok_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ជេសរី​អី​អ៝ស​លោស​ដ៝ង់ តី​ពាង់​ក្វាន់​ការ់​ញើន​តា​ជ៝ង់​អេឆាវ​រី កើត​នទ្រី​ទឹង​ឞូ​តេៈ​រាញា «យាកោប» គែស​នាវ​ខ្លៃ​លាស​«ក្វាន់​ការ់​ញើន​តា​ជ៝ង់»។ នោក​គុ​អ៝ស​នៃ​អីឆាក់​លែៈ​គែស ៦០ នាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ជេសរី​អី​ក៝ន​ពាង់​ឞារ​អឹ​រី​ត៝ត់​ក្វ៝ង់​ត៝ត់​នទាម់ អេឆាវ​ជេង​ឞូនុយ្ស​ឞ្រែន​ពាញ់​ព្វាច់ ពាង់​ហោ​ងាន់​ឞ្រោៈ​ឞ្រី។ ល៝ង់​យាកោប​រី ជេង​ឞូនុយ្ស​គុ​រាមឺយ្ស​ទើម ពាង់​គុ​ទាច់​តា​ចូន​ឞ៝ក​រី​ច្យាប់​ឞែ​ឞ្យាប់។ ");
INSERT INTO cmok_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","អីឆាក់​រ៝ង់​មា​អេឆាវ​ហោ​ងាន់ យ៝រ​លាស​ពាង់​រ៝ង់​ឆា​ព្វាច់​អេឆាវ​ទែ​ពាញ់ យើន​មា​រេបេកា​រ៝ង់​មា​យាកោប។ ");
INSERT INTO cmok_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","គែស​ទូ​នារ​យាកោប​គុ​គ៝ម់​ត្រាវ អេឆាវ​ឆឹត​ឞើស​នទ្រិច​រី​ពាង់​ហ្វារ់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ពាង់​លាស​មា​យាកោប៖ “ទាន់​ពាៈ​គ៝ប់​ដេៈ​ត្រាវ​ទុម​អី​ជាន​មា​តោស​មៃ​នៃ​គ៝ប់​ឞែ​មា​ឆា លែៈ​ហោ​ងាន់​ហ្វារ់​គ៝ប់​តា​រី!” (កើត​នទ្រី​ទឹង​ឞូ​ក្វាល់​ពាង់ «អេដ៝ម់» យ៝រ​លាស​គែស​នាវ​ខ្លៃ​«ទុម»។) ");
INSERT INTO cmok_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","យាកោប​លាស​មា​ពាង់៖ “ព្លាច់​អ៝ន់​មា​គ៝ប់​នាវ​ខ្លៃ​មៃ​ជេង​ក៝ន​ឞោក​ទាក​នៃ​មើ”។ ");
INSERT INTO cmok_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","អេឆាវ​អើស​មា​ពាង់៖ “គ៝ប់​តា​រី​លែៈ​ឞើយ​មា​ខឹត​ងាន់ ម៝ស​ហោម​ខ្លៃ​ជេង​ក៝ន​ឞោក​ទាក?” ");
INSERT INTO cmok_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","យាកោប​លាស​តៃ​មា​ពាង់៖ “លាស​នទ្រី​មៃ​ត៝ន​អ៝ន់​មា​គ៝ប់​ល៝រ​ប៝ត់”។ ជេសរី​អេឆាវ​ត៝ន​ព្លាច់​អ៝ន់​មា​យាកោប​នាវ​ខ្លៃ​ជេង​ក៝ន​ឞោក​ទាក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","យាកោប​ឆ៝ៈ​នុមពាង់ នទ្រែល​មា​ត្រាវ​តោស​ទុម​ពាង់​គ៝ម់​នៃ​អ៝ន់​មា​អេឆាវ​ឆោង។ អេឆាវ​ញេត​ឆោង​នទើ​យាកោប​អ៝ន់​នៃ ជេសរី​ទ៝ក់​ទូ​ឞើស​នតុក​នៃ។ កើត​នទ្រី​ពាង់​លែៈ​មឺច​ជេស​នាវ​ខ្លៃ​តា​ឆាក់​ពាង់​នើម​ជេង​ក៝ន​ឞោក​ទាក​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","នោក​នៃ​គែស​នាវ​ជី​ឆ៝ត់​ជី​ង៝ត​ក្វ៝ង់​តា​ឞ្រី​នៃ​ទូ​តឹ​ជឹត តឹម​ឞាន​មា​លែៈ​គែស​តា​រានោក​អាឞ្រាហាម់ ​នើស​ដ៝ង់។ នទ្រី​អីឆាក់ ​ហាន់​តា​ប៝ន​កេរារ  គៃ​មា​ទាន់​គុ​នទ្រែល​កាដាច់​អាបីមាលិច  ជេង​កាដាច់​ផូង​ផាលីសតីន ។ ");
INSERT INTO cmok_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ជេសរី​ឞ្រាស​យេហោវា​តឹម​មពើល​មា​អីឆាក់ លាស​មា​ពាង់៖ “មៃ​លើយ​អោស​ទូ​តា​ឞ្រី​អេឆីប  អ៝ន់​មៃ​គុ​តា​នតុក​ឞ្រី​គ៝ប់​មឞើស​មា​មៃ​ហ៝ៈ។ ");
INSERT INTO cmok_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","អ៝ន់​មៃ​គុ​តា​ឞ្រី​អី​មោ​អោស​ទី​ឞ្រី​មៃ​នើម​អ្យា​ហ៝ៈ គ៝ប់​មរា​គុ​នទ្រែល​មា​មៃ គ៝ប់​មរា​អ៝ន់​គែស​ជេង​មា​មៃ គ៝ប់​មរា​អ៝ន់​ទឹង​លែៈ​ឞ្រី​អ្យា​មា​មៃ​នហ៝​មា​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​មៃ គ៝ប់​មរា​ជាន​ងាន់​កើត​នាវ​គ៝ប់​លែៈ​ត៝ន​មា​អាឞ្រាហាម់ ​ឞឹ​មៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","គ៝ប់​មរា​អ៝ន់​ក៝ន​ឆៅ​មៃ​ឞឹក​រឹ​អ៝ក់​តឹម​ឞាន​មា​មាញ់​កាលើ​ត្រោក គ៝ប់​មរា​អ៝ន់​ទឹង​លែៈ​ឞ្រី​ទាក​អ្យា​មា​ក៝ន​ឆៅ​មៃ ជេសរី​ទឹង​លែៈ​ឞូនុយ្ស​លាម​នែស​នតូ​អ្យា​ឞូ​មរា​ឆ៝ៈ​ទើន​គែស​ជេង​យ៝រ​មា​តាៈ​ឞើស​ក៝ន​ឆៅ​មៃ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","គ៝ប់​មរា​ជាន​ទឹង​លែៈ​នទើ​អី​នៃ យ៝រ​លាស​អាឞ្រាហាម់ ​អ្យាត់​នាវ​គ៝ប់​នើស ពាង់​ជាន​តឹង​នាវ​គ៝ប់​ដាៈ​គ៝ប់​លាស នទ្រែល​មា​ជាន​តឹង​នាវ​វៃ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ជេសរី​អីឆាក់​គុ​តា​ប៝ន​កេរារ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","លាស​ឞូនុយ្ស​តា​ប៝ន​នៃ​អោប​ពាង់​មា​នាវ​អូរ​ពាង់​នៃ៖ “ឞូ​ម៝ស​ឞូ​អូរ​អ្យា?” ពាង់​មឞើស​មា​ឞូ​លាស៖ “អ៝ស​គ៝ប់”។ ពាង់​មោ​អោស​ឞាញ់​មឞើស​មា​ឞូ​លាស​អូរ​ពាង់ យ៝រ​លាស​ពាង់​គឹត​លាស៖ “គ៝ប់​ក្លាច​ឞូ​ក្លោ​តា​ប៝ន​អ្យា​ងខឹត​គ៝ប់ គៃ​មា​ឆ៝ៈ​អូរ​គ៝ប់ យ៝រ​លាស​អូរ​គ៝ប់​អ្វាញ់​អ្វែស​រែស​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ត៝ត់​ពាង់​គុ​តា​ប៝ន​នៃ​លែៈ​ជ៝ៈ​ងាន់ គែស​ទូ​នារ​កាដាច់​អាបីមាលិច​ជេង​កាដាច់​ផូង​ផាលីសតីន ពាង់​អ្វាញ់​ឞើស​មពោង​ឞ្ល៝ស​រី ឆៃ​អីឆាក់​នទ្រែល​មា​រេបេកា​អី​អូរ​រី​តឹម​អូត​តឹម​លោរ។ ");
INSERT INTO cmok_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ជេសរី​កាដាច់​អាបីមាលិច​ដាៈ​ឞូ​ក្វាល់​អីឆាក់ លាស​ពាង់៖ “ពាង់​អូរ​មៃ​ងាន់ មើម​ទឹង​មៃ​លាស «ពាង់​អ៝ស​គ៝ប់»?” អីឆាក់​អើស៖ “ទឹង​គ៝ប់​លាស​កើត​នៃ យ៝រ​លាស​គ៝ប់​ក្លាច​ឞូ​ងខឹត​យ៝រ​មា​អូរ​គ៝ប់​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","កាដាច់​អាបីមាលិច​លាស​មា​ពាង់៖ “ម៝ស​ទឹង​មៃ​ជាន​មា​ហេន​កើត​នៃ? លាស​គែស​ទូ​ហ្វេ​តា​ផូង​ប៝ន​លាន​គ៝ប់​ឞិច​នទ្រែល​មា​អូរ​មៃ លាស​នទ្រី​មៃ​ញឆុក​ផូង​ហេន​ជេង​តីស”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ជេសរី​កាដាច់​អាបីមាលិច​មឞើស​ទឹង​លែៈ​ផូង​ប៝ន​លាន ពាង់​លាស​កើត​នអា៖ “ឞូ​ម៝ស​ជាន​អ្យើស​ឞូ​ក្លោ​អ្យា មោ​លាស​អី​អូរ​ពាង់ ងខឹត​លើយ​ឞូនុយ្ស​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","អីឆាក់​គុ​តូច​តាម់​តា​ឞ្រី​នៃ ត៝ត់​ពាង់​កាច់​ពាង់​រែក​ពាង់​គែស​រាហ្យាង់ យ៝រ​លាស​ឞ្រាស​យេហោវា​អ៝ន់​គែស​ជេង​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ជេសរី​ត៝ត់​ពាង់​នទ្រ៝ង់ ត៝ត់​ពាង់​គែស​ទ្រាប់​នទើ​លើ​មា​អ៝ក់​នហ៝​មា​ជេង​ឞូនុយ្ស​ទុត​នទ្រ៝ង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ពាង់​គែស​ឞែ​ឞ្យាប់ គែស​នទ្រោក​អ៝ក់​ងាន់ នទ្រែល​មា​គែស​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​អ៝ក់​ដ៝ង់ កើត​នទ្រី​ផូង​ផាលីសតីន​មោ​នាច​មា​អោឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ទឹង​លែៈ​នតូ​ទាក​មពោល​ឆើម​កើល​ជាន​ការ​ឞឹ​ពាង់​អាឞ្រាហាម់ ​កុយ្ស​រានោក​អាឞ្រាហាម់ ​ហោម​រេស​នើស ផូង​ផាលីសតីន​ឞ្រោយ​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ជេសរី​កាដាច់​អាបីមាលិច​លាស​អីឆាក់៖ “មៃ​ទូ​ឞើស​នតុក​អ្យា​ហ៝ម់ យ៝រ​លាស​មៃ​គែស​ឞូនុយ្ស​គែស​ទ្រាប់​នទើ​ទុត​អ៝ក់​រាលាវ​ហេន”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ជេសរី​អីឆាក់​ទូ​ឞើស​នតុក​នៃ​ហាន់​គុ​តា​ញជ៝ង់​យោក​កេរារ តេៈ​ចូន​ឞ៝ក​គុ​តា​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","អីឆាក់​ដាៈ​ឞូ​ក្វាយ​តៃ​ទឹង​លែៈ​នតូ​ទាក​អាឞ្រាហាម់ ​អី​ឞឹ​ទែ​កុយ្ស​រី​នើស យ៝រ​លាស​លែៈ​ផូង​ផាលីសតីន​ទែ​ឞ្រោយ​លើយ​ទាទេ​ជេស​ខឹត​អាឞ្រាហាម់ ​នៃ​នើស អីឆាក់​តេៈ​តៃ​រាញា​ទឹង​លែៈ​នតូ​ទាក​អី​នៃ​តឹង​កើត​រាញា​អី​ឞឹ​ពាង់​លែៈ​តេៈ​នើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","មពោល​ឆើម​កើល​ជាន​ការ​អីឆាក់​កុយ្ស​ទូ​នតូ​ទាក​តា​ញជ៝ង់​យោក​នៃ គែស​ទាក​លោស​ហ៝ច​នឹង​ឞើស​នតូ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","យើន​មា​ផូង​ច្យាប់​តា​ឞ្រី​កេរារ​នៃ​តឹម​ល៝ក់​ដាស​ផូង​ច្យាប់​អីឆាក់ ផូង​នៃ​លាស៖ “អ្យា​ជេង​នតូ​ទាក​ហេន” ជេសរី​អីឆាក់​តេៈ​រាញា​នតូ​នៃ «អេឆេក» គែស​នាវ​ខ្លៃ​លាស​«នាវ​តឹម​រាលាច់» យ៝រ​លាស​ផូង​នៃ​លែៈ​តឹម​ល៝ក់​ដាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","មពោល​ឆើម​កើល​ជាន​ការ​អីឆាក់​កុយ្ស​តៃ​ទូ​មល៝ម់​នតូ​ទាក​ជឹត យើន​មា​ផូង​ច្យាប់​តឹម​ល៝ក់​ដាស​ពាង់​ដ៝ង់ នទ្រី​អីឆាក់​តេៈ​រាញា​នតូ​ទាក​នៃ «ឆិតនា» គែស​នាវ​ខ្លៃ​លាស​«តឹម​រាទ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ជេសរី​ពាង់​ទូ​នតុក​អេង ពាង់​កុយ្ស​តៃ​ទូ​មល៝ម់​នតូ​ទាក​ជឹត នតូ​ទាក​នៃ​មោ​ហោម​អោស​ឆៃ​ឞូ​តឹម​ពីត នទ្រី​ទឹង​ពាង់​តេៈ​រាញា​នតូ​ទាក​នៃ «រេហោបោត» គែស​នាវ​ខ្លៃ​លាស​«ហ្វី» ពាង់​លាស៖ “អាបៃ​អ្យា​ឞ្រាស​យេហោវា​លែៈ​អ៝ន់​នតុក​ហ្វី​មា​ហេន​ជេស អ៝ន់​ហេន​គែស​ទ្រាប់​នទើ​នទ្រ៝ង់​តា​ឞ្រី​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ជេសរី​ពាង់​ទូ​ឞើស​នតុក​នៃ​ហាន់​គុ​តា​ប៝ន​បេរឆេបា។ ");
INSERT INTO cmok_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","តា​មាង់​នៃ​ឞ្រាស​យេហោវា​តឹម​មពើល​មា​ពាង់ លាស​មា​ពាង់​កើត​នអា៖ “មៃ​លើយ​អោស​ក្លាច យ៝រ​លាស​គ៝ប់​គុ​នទ្រែល​មៃ គ៝ប់​អ្យា​អី​ឞ្រាស​អាឞ្រាហាម់ ​ឞឹ​មៃ​យើក​មឞាស​នើស គ៝ប់​អ៝ន់​គែស​ជេង​មា​មៃ គ៝ប់​ជាន​អ៝ន់​មៃ​គែស​ក៝ន​គែស​ឆៅ​ឞឹក​រឹ យ៝រ​លាស​អាឞ្រាហាម់ ​នើស​អី​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ជេសរី​ពាង់​ជាន​ទូ​នតុក​មា​ជាន​ឞ្រាស​តា​នតុក​នៃ ពាង់​យើក​មឞាស​ឞ្រាស​យេហោវា​តា​នតុក​នៃ។ ពាង់​តេៈ​ចូន​ឞ៝ក​ពាង់​នើម​គុ​តា​នតុក​នៃ ជេសរី​មពោល​ឆើម​កើល​ជាន​ការ​ពាង់​កុយ្ស​នតូ​ទាក​តា​នតុក​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","គែស​ទូ​នារ​កាដាច់​អាបីមាលិច​ហាន់​ម៝ប់​អីឆាក់ ហាន់​នទ្រែល​ពាង់​គែស​អាហូឆាត​ជេង​ឞូនុយ្ស​កើល​ពាង់ នទ្រែល​មា​ផីកុល​ជេង​កោរាញ​តាហែន​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","អីឆាក់​លាស​មា​កាដាច់​នៃ៖ “ម៝ស​នាវ​ខាន់​មៃ​ហោម​អុច​ហាន់​ម៝ប់​គ៝ប់ យ៝រ​លាស​ខាន់​មៃ​លែៈ​ឞ្យាញ់​មព្រើស​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","កាដាច់​អាបីមាលិច​លាស​មា​អីឆាក់៖ “លែៈ​ហេន​គឹត​ឞ្រាស​យេហោវា​គុ​នទ្រែល​មៃ​ងាន់ កើត​នទ្រី​ហេន​មឹន ហេន​អុច​អ៝ន់​ឞ៝ន់​តឹម​ត៝ន​តឹម​រាង្លាប់​នទ្រែល។ ");
INSERT INTO cmok_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","អ៝ន់​មៃ​ត៝ន​មា​ហេន មៃ​មោ​លើស​អ្យើស​មា​ហេន កើត​ហេន​មោ​លើស​អ្យើស​មា​មៃ ជាន​នទើ​អ្វែស​ទើម​មា​មៃ លែៈ​អ៝ន់​មៃ​ឆឹត​ដាប់​មពាន់​នើស អាបៃ​អ្យា​មៃ​លែៈ​ឞ្រាស​យេហោវា​ទែ​អ៝ន់​គែស​ជេង​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","អីឆាក់​នទ្រាប់​ញេត​ឆា​ក្វ៝ង់​អ៝ន់​មា​កាដាច់ នទ្រែល​មា​លែៈ​ផូង​អី​ហាន់​នទ្រែល​ពាង់​នៃ ជេសរី​ខាន់​ពាង់​ញេត​ឆោង​ឆា​នទ្រែល​តា​រី​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ត៝ត់​អោយ​តៃ ខាន់​ពាង់​ទ៝ក់​អើម​អោយ​តឹម​ត៝ន​ឞាល់ ជេសរី​អីឆាក់​ញជុន​កាដាច់​អាបីមាលិច នទ្រែល​មា​ផូង​អី​ហាន់​នទ្រែល​ពាង់​នៃ​ឆឹត ខាន់​ពាង់​ឆឹត​ដាប់​មពាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","តា​នារ​នៃ​ដ៝ង់ មពោល​ឆើម​កើល​ជាន​ការ​មា​អីឆាក់​ហាន់​មឞើស​មា​ពាង់​នតូ​ទាក​អី​ខាន់​ពាង់​មហែ​កុយ្ស​នៃ​នើស ខាន់​ពាង់​លាស៖ “នតូ​ហេន​កុយ្ស​នើស​លែៈ​គែស​ទាក”។ ");
INSERT INTO cmok_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","អីឆាក់​តេៈ​រាញា​នតូ​ទាក​នៃ «ឆីបា» គែស​នាវ​ខ្លៃ​លាស​«នាវ​ត៝ន» នទ្រី​ទឹង​ឞូ​នតើ​ប៝ន​នៃ «បេរឆេបា» គែស​នាវ​ខ្លៃ​លាស​«នតូ​ទាក​ត៝ន» នហ៝​មា​ត៝ត់​អាបៃ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ត៝ត់​អេឆាវ​លែៈ​គែស ៤០ នាម់ ពាង់​ឆ៝ៈ​អូរ​ឞារ​ឞើស​ផូង​ហេត ទូ​ហ្វេ​រាញា​យូដីត​អី​ក៝ន​បេរី អី​ទូ​ហ្វេ​រាញា​បាសមាត​អី​ក៝ន​អេលោន។ ");
INSERT INTO cmok_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","លែៈ​ឞូ​អូរ​ឞារ​ហៃ​នៃ​ជាន​អ៝ន់​អីឆាក់ នទ្រែល​មា​រេបេកា​រាង៝ត​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ត៝ត់​អីឆាក់​លែៈ​រាញ​ងាន់ មាត់​ពាង់​ង៝​អ្វាញ់​មោ​ហោម​អោស​ឆៃ។ ពាង់​ក្វាល់​អេឆាវ​ក៝ន​ឞោក​ទាក​ពាង់​រី៖ “ហើយ​នោ” អេឆាវ​អើស៖ “ម៝ស​ឞឹ!” ");
INSERT INTO cmok_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ឞឹ​ពាង់​លាស៖ “គ៝ប់​អ្យា​លែៈ​រាញ មោ​គឹត​នារ​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","លាស​នទ្រី​មៃ​ឆ៝ៈ​នទើ​មៃ​វៃ​ពាញ់ នា​ដូត​ហារ់​ទឹង​កាម់ ហាន់​អា​ឞ្រី​ពាញ់​ព្វាច់​អ៝ន់​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","មៃ​ជាន​ត្រាវ​ព្វាច់​នៃ​អ៝ន់​ទុត​កាស​មា​គ៝ប់ អ៝ន់​ទី​ក៝​គ៝ប់​វៃ​ឆា គ៝ប់​ឞែ​មា​ឆោង ជេសរី​ទឹង​គ៝ប់​អ៝ន់​គែស​ជេង​មា​មៃ អេ​ល៝រ​មា​គ៝ប់​ខឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ជេសរី​អេឆាវ​ហាន់​អា​ឞ្រី​រី ជ៝យ​ពាញ់​ព្វាច់​មា​អ៝ន់​អី​ឞឹ​ពាង់។ នោក​អីឆាក់​ងើយ​មា​អេឆាវ​ក៝ន​ពាង់​នៃ​នើស រេបេកា​តាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ជេសរី​រេបេកា​មឞើស​មា​យាកោប​ក៝ន​ពាង់​នៃ៖ “គ៝ប់​តាង់​ឞឹ​មៃ​លាស​មា​អេឆាវ​នោ​មៃ​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","«ពាញ់​ព្វាច់​អ៝ន់​មា​គ៝ប់ ជេសរី​ជាន​ត្រាវ​អ៝ន់​ទុត​កាស​មា​គ៝ប់ អ៝ន់​ទី​ក៝​គ៝ប់​វៃ​ឆា គ៝ប់​ឞែ​មា​ឆោង ជេសរី​ទឹង​គ៝ប់​អ៝ន់​គែស​ជេង​មា​មៃ​តា​នាប់​មាត់​ឞ្រាស​យេហោវា អេ​ល៝រ​មា​គ៝ប់​ខឹត»។ ");
INSERT INTO cmok_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","លាស​នទ្រី​អើ​នោ មៃ​អ្យាត់​នាវ​គ៝ប់ ជាន​តឹង​នាវ​គ៝ប់​ដាៈ​មា​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","មៃ​ហាន់​តា​ឞែ​ឞ្យាប់​ផូង​រី ជេសរី​ឆ៝ៈ​ឞារ​អឹ​ក៝ន​ឞែ​អី​អ្វែសៗ​អ៝ន់​មា​គ៝ប់ គ៝ប់​ឞែ​មា​ជាន​ត្រាវ​អ៝ន់​ទុត​កាស អ៝ន់​ទី​ក៝​ឞឹ​មៃ​វៃ​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","មៃ​ញអោត​ត្រាវ​នៃ​ញជុន​អ៝ន់​ឞឹ​មៃ​ឆា គៃ​មា​ពាង់​អ៝ន់​គែស​ជេង​មា​មៃ អេ​ល៝រ​មា​ពាង់​ខឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","យើន​មា​យាកោប​អើស​មា​មេៈ​ពាង់៖ “អេឆាវ​នោ​គ៝ប់ ពាង់​គែស​រាឆៅ​លាម​ឆាក់ ល៝ង់​គ៝ប់​មោ​អោស​គែស​រាឆៅ។ ");
INSERT INTO cmok_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ក្លាប់​លាស​ឞឹ​គ៝ប់​ពាង់​ឞូត​គ៝ប់ ជេសរី​គឹត​គ៝ប់​ជេង​ឞូនុយ្ស​នទើម​ពាង់ លាស​នទ្រី​គ៝ប់​មោ​អោស​គែស​ឆ៝ៈ​ទើន​គែស​ជេង​តាៈ​ឞើស​ឞឹ​គ៝ប់ គែស​ងខើង​នាវ​រាតាប់​ច្រាវ”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","មេៈ​ពាង់​លាស៖ “អើ​នោ អ៝ន់​នាវ​រាតាប់​នៃ​គែស​តា​គ៝ប់ អ៝ន់​មៃ​ជាន​តឹង​នាវ​គ៝ប់ ហាន់​ឆ៝ៈ​ហ៝ម់​ឞែ​លែវ​អា​គ៝ប់​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ជេសរី​យាកោប​ហាន់​ឆ៝ៈ​ឞែ​ញជុន​អ៝ន់​មេៈ​ពាង់ មេៈ​ពាង់​ជាន​ត្រាវ​អ៝ន់​ទុត​កាស អ៝ន់​ទី​ក៝​អី​ឞឹ​ពាង់​វៃ​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ជេសរី​មេៈ​ពាង់​ឆ៝ៈ​អាវ​អេឆាវ អាវ​អី​ទុត​អ្វែស​អី​គែស​តា​ជៃ​រេបេកា​នើម​រី ឆើម​ញឆ៝ស​អ៝ន់​មា​យាកោប​អី​អ៝ស​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ពាង់​ឆ៝ៈ​ដ៝ង់​រាឆៅ​ឞែ​ពូត​តា​គ្លាន់​តី នទ្រែល​មា​តា​ត៝ង​ក៝​យាកោប​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ជេស​ឞើស​នៃ​មេៈ​ពាង់​រី​ឆ៝ៈ​ត្រាវ​ព្វាច់​ទុត​កាស នទ្រែល​មា​នុមពាង់​អី​ព្រែ​លែៈ​ជេស​ជាន​រី​នើស នទឹ​អ៝ន់​យាកោប​ញអោត។ ");
INSERT INTO cmok_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ជេសរី​យាកោប​ញជុន​ព្យាង់​ត្រាវ​នៃ​មា​ឞឹ​ពាង់ ពាង់​លាស៖ “ហើយ​ឞឹ!” អីឆាក់​អើស៖ “គ៝ប់​តា​អ្យា ឞូ​ម៝ស​មៃ​រី​អើ​នោ?” ");
INSERT INTO cmok_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","យាកោប​អើស៖ “គ៝ប់​ហែស​ឞឹ គ៝ប់​អេឆាវ​ក៝ន​ឞោក​ទាក​មៃ​ហែស លែៈ​ជេស​គ៝ប់​ជាន​តឹង​នាវ​មៃ​ដាៈ​មា​គ៝ប់​នើស ទ៝ក់​ហ៝ម់ ឆា​ព្វាច់​អី​គ៝ប់​ឞែ​ពាញ់​តាៈ​ឞើស​ឞ្រី​អ្យា​ប៝ត់ ជេសរី​ទឹង​មៃ​អ៝ន់​គែស​ជេង​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","អីឆាក់​អោប​ពាង់៖ “អើ​នោ មើម​ទឹង​ងាច់​គែស​ពាញ់​មរែ​រី?” យាកោប​អើស៖ “​ឞ្រាស​យេហោវា​អី​ឞ្រាស​មៃ​យើក​មឞាស​ឆើម​កើល​អ៝ន់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","អីឆាក់​លាស​មា​យាកោប៖ “អើ​នោ មៃ​ហាន់​ទាច់​អា​គ៝ប់​អ្យា​ដេៈ​គ៝ប់​ឞែ​មា​ឞូត គៃ​មា​គឹត​នហេល​មៃ​ក៝ន​គ៝ប់​អេឆាវ​ងាន់​លាស​មោ”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","យាកោប​ហាន់​ទាច់​អា​ឞឹ​ពាង់​រី ជេសរី​ឞឹ​ពាង់​ឞូត ពាង់​លាស៖ “តី​អ្យា​ជេង​តី​អេឆាវ​ងាន់ តីស​មា​ងើយ​រី​ងើយ​យាកោប”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","អីឆាក់​មោ​អោស​គឹត​នាល់​យាកោប យ៝រ​លាស​អី​តី​ពាង់​រី​គែស​រាឆៅ​តឹម​ឞាន​មា​តី​អេឆាវ​ដ៝ង់។ យើន​មា​អេ​ល៝រ​ពាង់​អ៝ន់​គែស​ជេង​មា​យាកោប‌ ");
INSERT INTO cmok_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ពាង់​អោប​នហេល៖ “មៃ​អេឆាវ​ក៝ន​គ៝ប់​ងាន់​ឞើស?” យាកោប​អើស៖ “អើ​គ៝ប់​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","អីឆាក់​លាស​មា​ក៝ន​ពាង់៖ “ពឺ​ត្រាវ​ព្វាច់​អ៝ន់​ទាច់​កេង​គ៝ប់​អ្យា គ៝ប់​ឞែ​មា​ឆា​ព្វាច់​អី​មៃ​ពាញ់​នៃ​ប៝ត់​នោ តៃ​ទឹង​គ៝ប់​អ៝ន់​គែស​ជេង​មា​មៃ”។ យាកោប​ពឺ​ត្រាវ​ព្វាច់​អ៝ន់​ឞឹ​ពាង់​ឆា ពាង់​កេត​ដ៝ង់​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​អ៝ន់​ឞឹ​ពាង់​ញេត។ ");
INSERT INTO cmok_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ជេសរី​អីឆាក់​ឞឹ​ពាង់​រី​លាស​មា​ក៝ន​ពាង់៖ “អើ​នោ មៃ​ហាន់​ទាច់​អា​អ្យា​ចុម​គ៝ប់​ប៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","យាកោប​ហាន់​ទាច់​ចុម​អី​ឞឹ​ពាង់​រី អី​ឞឹ​ពាង់​រី​នាល់​បោ​ងលុម​ឞ៝ក​អាវ​អេឆាវ ជេសរី​ពាង់​អ៝ន់​គែស​ជេង​មា​យាកោប ពាង់​លាស៖ “បោ​ងលុម​ក៝ន​គ៝ប់​រី​ជេង​បោ​ងលុម​មីរ​ឞ្រាស​យេហោវា​ទែ​លែៈ​អ៝ន់​គែស​ជេង។ ");
INSERT INTO cmok_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​មា​មៃ​គែស​ទាក​រាងេត​តាៈ​ឞើស​កាលើ​ត្រោក នទ្រែល​មា​អ៝ន់​នែស​កាស​មា​មៃ​ដ៝ង់។ ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​មៃ​គែស​ឞា នទ្រែល​មា​អ៝ន់​មៃ​គែស​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​ទុត​អ៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ទាន់​ពាង់​អ៝ន់​ផូង​ឞូនុយ្ស​អេងៗ​អ៝ន់​ឆើម​កើល​ជាន​ការ​មា​មៃ។ ទាន់​ពាង់​អ៝ន់​ឞូនុយ្ស​ឞ្រី​ទាក​អេងៗ​កុញ​ឞោក​យើក​មា​មៃ។ ទាន់​ពាង់​អ៝ន់​មៃ​ជេង​កោរាញ​មា​អ៝ស​នោ​ទូ​នទុល​ទែស​មៃ​នើម។ ទាន់​ពាង់​អ៝ន់​អ៝ស​នោ​ទូ​នទុល​ទែស​មា​មៃ​កុញ​ឞោក​យើក​មា​មៃ។ ឞូ​ម៝ស​ពាង់​អី​រាតាប់​មៃ​អ៝ន់​កោរាញ​ឞ្រាស​រាតាប់​មា​ពាង់។ ឞូ​ម៝ស​ពាង់​អី​អ៝ន់​គែស​ជេង​មា​មៃ​អ៝ន់​កោរាញ​ឞ្រាស​អ៝ន់​គែស​ជេង​មា​ពាង់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","លែៈ​ជេស​អីឆាក់​អ៝ន់​គែស​ជេង​មា​យាកោប នទុត​យាកោប​ទូ​លោស​ឞើស​ឞឹ​ពាង់​នៃ អេឆាវ​ឆឹត​ពាញ់​ព្វាច់​ឞើស​ឞ្រី​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ពាង់​ជាន​ត្រាវ​ទុត​កាស​ញជុន​អ៝ន់​ឞឹ​ពាង់​ដ៝ង់ ពាង់​លាស​មា​ឞឹ​ពាង់៖ “ហើយ​ឞឹ ទ៝ក់​ហ៝ម់ ឆា​ព្វាច់​គ៝ប់​ឞែ​អី​ពាញ់​អ្យា​ប៝ត់ ជេសរី​ទឹង​មៃ​អ៝ន់​គែស​ជេង​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","អីឆាក់​ឞឹ​ពាង់​រី​អោប៖ “ឞូ​ម៝ស​មៃ​រី?” អេឆាវ​អើស៖ “គ៝ប់​អេឆាវ​ហែស​ឞឹ ក៝ន​ឞោក​ទាក​មៃ​ហែស”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","អីឆាក់​ញឆ៝រ់​ឆាក់​ទុត​ហោ ពាង់​អោប៖ “លាស​នទ្រី​ឞូ​ម៝ស​ញអោត​ព្វាច់​អ៝ន់​មា​គ៝ប់​នទើស​នើស? ឞើស​នាប់​មៃ​នើស​អា​ពើ គ៝ប់​ឆា​ព្វាច់​ពាង់​លែៈ​ផ្យៅ ជេសរី​គ៝ប់​អ៝ន់​គែស​ជេង​មា​ពាង់។ កោរាញ​ឞ្រាស​មរា​អ៝ន់​គែស​ជេង​នៃ​មា​ពាង់​នហ៝​រ៝​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ត៝ត់​អេឆាវ​តាង់​នាវ​ឞឹ​ពាង់​លាស​នៃ ពាង់​នតែរ​ទុត​ទាង់ នអ៝ប់​មា​រាង៝ត​ហោ​ងាន់ ពាង់​លាស​មា​ឞឹ​ពាង់៖ “អើ​ឞឹ អ៝ន់​គែស​ជេង​មា​គ៝ប់​ដ៝ង់​អើ!” ");
INSERT INTO cmok_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","អីឆាក់​អើស​មា​ពាង់៖ “អ៝ស​មៃ​ពាង់​ឞ្រោៈ​នទើម ជេសរី​ពីត​លើយ​គែស​ជេង​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","អេឆាវ​លាស៖ “ទី​ងាន់​ឞូ​តេៈ​រាញា​ពាង់​«យាកោប»​នៃ យ៝រ​លាស​ពាង់​ពីត​លើយ​នទើ​គ៝ប់​លែៈ​ឞារ​តឹ​មា​អ្យា​ជេស ទូ​តឹ​ពាង់​ពីត​នាវ​ខ្លៃ​ក៝ន​ឞោក​ទាក​គ៝ប់ អាបៃ​អ្យា​ពាង់​ពីត​ដ៝ង់​គែស​ជេង​គ៝ប់​ជឹត។ អើ​ឞឹ លាស​នទ្រី​មៃ​មោ​រ៝ង​គែស​ជេង​មា​អ៝ន់​គ៝ប់​ដ៝ង់?” ");
INSERT INTO cmok_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","អីឆាក់​លាស​មា​អេឆាវ៖ “លែៈ​គ៝ប់​អ៝ន់​ពាង់​ជាន​កោរាញ​មៃ​ជេស ជេសរី​លែៈ​ផូង​អ៝ស​នោ​ពាង់ លែៈ​គ៝ប់​អ៝ន់​ខាន់​ពាង់​ឆើម​កើល​ជាន​ការ​មា​ពាង់​ទាទេ។ ឞា នទ្រែល​មា​ព្លៃ​យុងយារ​ប៝ន​លែៈ​គ៝ប់​អ៝ន់​មា​ពាង់​ដ៝ង់ លាស​នទ្រី​មាៈ​នទើ​គ៝ប់​អ៝ន់​មា​មៃ?” ");
INSERT INTO cmok_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","អេឆាវ​អោប​ឞឹ​ពាង់៖ “អើ​ឞឹ មៃ​គែស​ទូ​នៃ​ទើម​គែស​ជេង​មៃ? ពាៈ​គ៝ប់​ដ៝ង់​គែស​ជេង​មៃ​ឞឹ​អើ”។ នោក​នៃ​អេឆាវ​ញុម​នតែរ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","អីឆាក់​ឞឹ​ពាង់​រី​លាស​មា​ពាង់៖ “មៃ​តៃ​គុ​តា​នតុក​នែស​ឆ៝ត់ ទាក​រាងេត​តាៈ​ឞើស​កាលើ​ត្រោក​មោ​គែស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","មៃ​តៃ​រេស​ឆ្យាម់​ឆាក់​មា​ដាវ​មៃ​នើម នទ្រែល​មា​គុ​ឆើម​កើល​ជាន​ការ​មា​អ៝ស​មៃ​នើម។ យើន​មា​គែស​ទូ​នារ មៃ​មរា​ក្លាយ្ស​ឞើស​អ៝ស​មៃ មអារ់​លើយ​ម៝ង់​មឞាក់​ពាង់​តា​ត៝ង​ក៝​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","អេឆាវ​ជី​នូយ្ស​យាកោប​ទុត​ហោ​ងាន់ យ៝រ​មា​នាវ​គែស​ជេង​ឞឹ​ពាង់​អ៝ន់​នៃ​លែៈ​យាកោប​ឆ៝ៈ។ អេឆាវ​លាស​អេង​តា​នូយ្ស​នហ៝ម់​ពាង់​រី៖ “នារ​ញុម​រាង៝ត​ឞឹ​គ៝ប់​ខឹត​ឞើយ​មា​ត៝ត់ នោក​នៃ​តៃ​ទឹង​គ៝ប់​ងខឹត​លើយ​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","គែស​ឞូ​ហាន់​មឞើស​មា​រេបេកា​នាវ​អេឆាវ​ក៝ន​ឞោក​ទាក​ពាង់​លាស​នៃ ជេសរី​រេបេកា​ដាៈ​ឞូ​ហាន់​ក្វាល់​យាកោប​អី​អ៝ស​រី មឞើស​មា​ពាង់៖ “អេឆាវ​នោ​មៃ ពាង់​អុច​ព្លើង​មា​មៃ អុច​ងខឹត​លើយ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","អើ​នោ អាបៃ​អ្យា​មៃ​អ្យាត់​នាវ​គ៝ប់ មៃ​ញច្វាត់​តា​ប៝ន​ចារាន  គុ​អា​នោ​គ៝ប់​លាបាន​រី​ទោ។ ");
INSERT INTO cmok_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","អ៝ន់​មៃ​គុ​នទ្រែល​ពាង់​ជ៝ៈ​អ៝យ ត៝ត់​នោ​មៃ​នអីក​នូយ្ស​ប៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ត៝ត់​ពាង់​ឞាស​នូយ្ស​មា​មៃ លែៈ​ច្វេល​នាវ​មៃ​ជាន​មា​ពាង់​នើស តៃ​ទឹង​គ៝ប់​ដាៈ​ឞូ​ហាន់​មឞើស​មៃ​ព្លឹ​ឆឹត​តៃ​តា​អ្យា យ៝រ​លាស​គ៝ប់​មោ​អុច​អោស​ឆៃ​ខាន់​មៃ​ខឹត​លែៈ​ឞារ​ហៃ​ទូ​នារ”។ ");
INSERT INTO cmok_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","រេបេកា​លាស​មា​អីឆាក់៖ “គ៝ប់​ទឹល​ងាន់​មា​មាន់​ឞូ​អូរ​ផូង​ហេត​អ្យា លាស​យាកោប​ឆ៝ៈ​អូរ​ផូង​ហេត​តា​ឞ្រី​អ្យា​ដ៝ង់ គ៝ប់​មោ​ហោម​អុច​អោស​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","នទ្រី​អីឆាក់​ក្វាល់​យាកោប ពាង់​អ៝ន់​គែស​ជេង​មា​ក៝ន​ពាង់​នៃ ជេសរី​ឞ្វៃ​ពាង់៖ “មៃ​លើយ​អោស​ឆ៝ៈ​អូរ​តាៈ​ឞើស​ក៝ន​ឞូ​អូរ​ផូង​កានាន​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","មៃ​ហាន់​តា​ឞ្រី​ពាដាន-អារាម តា​ជៃ​បេថូអែល​ចែ​អី​ឞឹ​មេៈ​មៃ​រី មៃ​ឆ៝ៈ​អូរ​ដាស​ក៝ន​វា​លាបាន​អី​នោ​មេៈ​មៃ​នៃ​ហ៝ៈ។ ");
INSERT INTO cmok_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ទាន់​កោរាញ​ឞ្រាស​នើម​អី​ទុត​គែស​នាវ​ទើយ​អ៝ន់​គែស​ជេង​មា​មៃ ជាន​អ៝ន់​មៃ​គែស​អ៝ស​គែស​ក៝ន​ឞឹក​រឹ​អ៝ន់​ទុត​អ៝ក់ ជេសរី​អ៝ន់​រាន៝យ​ទែស​មៃ​ជេង​អ៝ក់​ផូង​ឞូនុយ្ស​អេងៗ។ ");
INSERT INTO cmok_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​មា​មៃ​គែស​ជេង​អី​កោរាញ​ឞ្រាស​ទែ​អ៝ន់​មា​ឞឹ​គ៝ប់​អាឞ្រាហាម់ ​នៃ​នើស នទ្រែល​មា​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​មៃ​ដ៝ង់ គៃ​មា​ឞ្រី​អី​មៃ​វែស​គុ​អ្យា​ជេង​នទើ​មៃ យ៝រ​លាស​ឞ្រី​អ្យា​លែៈ​កោរាញ​ឞ្រាស​ទែ​អ៝ន់​មា​ឞឹ​គ៝ប់​អាឞ្រាហាម់ ​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ជេសរី​អីឆាក់​អ៝ន់​យាកោប​ហាន់ នទ្រី​ពាង់​ហាន់​តា​ឞ្រី​ពាដាន-អារាម ហាន់​តា​ជៃ​លាបាន​ក៝ន​បេថូអែល​ផូង​អារាម ជេង​អី​នោ​រេបេកា​នើម​អី​មេៈ​យាកោប នទ្រែល​អេឆាវ។ ");
INSERT INTO cmok_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","អេឆាវ​ឆៃ​អីឆាក់​អ៝ន់​គែស​ជេង​មា​យាកោប នទ្រែល​មា​ដាៈ​ពាង់​ហាន់​ឆ៝ៈ​អូរ​តា​ឞ្រី​ពាដាន-អារាម នតិញ​ពាង់​មោ​អោស​អ៝ន់​ពាង់​ឆ៝ៈ​អូរ​ដាស​ផូង​ឞូ​អូរ​កានាន‌ ");
INSERT INTO cmok_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ឆៃ​យាកោប​អ្យាត់​នាវ​មេៈ​ឞឹ​ហាន់​តា​ឞ្រី​ពាដាន-អារាម​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ត៝ត់​អេឆាវ​គឹត​ជេស​អី​ឞឹ​ពាង់​មោ​តឹម​ទី​មា​ឞូ​អូរ​ផូង​កានាន‌ ");
INSERT INTO cmok_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ជេសរី​ពាង់​ហាន់​តា​អីសមាអែល​ក៝ន​អាឞ្រាហាម់ ឆ៝ៈ​អូរ​ង្វាយ​ជឹត​ដាស​ក៝ន​អីសមាអែល​រី ពាង់​ឆ៝ៈ​មាហាលាត​អី​អ៝ស​នេបាយោត ពាង់​គែស​អូរ​ពែ។ ");
INSERT INTO cmok_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","យាកោប​ទូ​ឞើស​ប៝ន​បេរឆេបា​ហាន់​តា​ប៝ន​ចារាន ។ ");
INSERT INTO cmok_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ពាង់​ហាន់​ត៝ត់​តា​ទូ​នតុក ជេសរី​ពាង់​រាលូ​តា​នតុក​នៃ យ៝រ​លាស​នារ​លែៈ​ញ៝ប់ ពាង់​ឆ៝ៈ​ទូ​មល៝ម់​លុ​តា​នតុក​នៃ​មា​ទ៝ម់​ឞោក ជេសរី​ពាង់​ឞិច​ហាក់​ខេរ។ ");
INSERT INTO cmok_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ពាង់​មឞើយ​គែស​ទូ​មល៝ម់​នតូង​គូង​រាទ៝ក់​តា​នែស អី​ចោង​នតូង​គូង​នៃ​នទាល់​ត៝ត់​អា​ត្រោក​រី ជេសរី​គែស​ផូង​តោង​ពារ់​កោរាញ​ឞ្រាស​ឞ្រោៈ​ញឆ៝ង​ជុរ​ហាវ​រ៝ៈ​នតូង​គូង​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ឞ្រាស​យេហោវា​ទ៝ក់​តា​កាលើ​នតូង​គូង​នៃ លាស​មា​ពាង់៖ “គ៝ប់​អ្យា​ឞ្រាស​យេហោវា អី​ឞ្រាស​អាឞ្រាហាម់ ​ចែ​មៃ​យើក​មឞាស អី​ឞ្រាស​អីឆាក់​ឞឹ​មៃ​យើក​មឞាស​ដ៝ង់។ នែស​នតុក​មៃ​ឞិច​អ្យា​គ៝ប់​អ៝ន់​មា​មៃ នហ៝​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ក៝ន​ឆៅ​មៃ​តៃ​អ៝ក់​តឹម​ឞាន​មា​នែស​មោយ ខាន់​ពាង់​មរា​គុ​លាម​នតុក​ត៝ត់​ជឹត​ញ៝ប់​នារ ត៝ត់​ជឹត​លោស​នារ ត៝ត់​ជឹត​ទ៝ង់ នទ្រែល​មា​ត៝ត់​ជឹត​លើ។ ជេសរី​ទឹង​លែៈ​នទុល​មពោល​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា​ឞូ​គែស​ជេង​តាៈ​ឞើស​ក៝ន​ឆៅ​មៃ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","គ៝ប់​គុ​នទ្រែល​មៃ អាស​នតុក​មៃ​ហាន់​គ៝ប់​ម៝ត់​ញជ្រាង់​មៃ នទ្រែល​មា​លែវ​មៃ​ព្លឹ​តៃ​តា​ឞ្រី​អ្យា​ដ៝ង់ គ៝ប់​មោ​អោស​មអារ់​មៃ យ៝រ​លាស​ម៝ស​នាវ​គ៝ប់​លែៈ​ជេស​ត៝ន​មា​មៃ គ៝ប់​ជាន​អ៝ន់​ត៝ត់​ជេង​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ត៝ត់​យាកោប​កាស​រាងាល់​ឞិច ពាង់​លាស៖ “​ឞ្រាស​យេហោវា​គុ​តា​នតុក​អ្យា​ងាន់​រ៝ យើន​មា​គ៝ប់​មោ​គឹត​អោស”។ ");
INSERT INTO cmok_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ពាង់​ក្លាច ជេសរី​លាស៖ “ក្លាច​ងាន់​នតុក​អ្យា​អឺស! តា​អ្យា​រ៝​ជៃ​កោរាញ​ឞ្រាស នទ្រែល​មា​នតុក​មពោង​មពេរ​ត្រោក​អី​នតុក​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","យាកោប​ទ៝ក់​អើម​អោយ ពាង់​ឆ៝ៈ​លុ​អី​ព្រែ​ទ៝ម់​ឞោក​រី​នើស​ពាង់​រាទ៝ក់​ជាន​ងគ៝ង់​តា​រី ជាន​នទើ​គឹត​នាល់​គែស​កោរាញ​ឞ្រាស​គុ ជេសរី​ពាង់​ត៝ៈ​ទាក​ងី​ឞើស​លើ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ពាង់​តេៈ​រាញា​នតុក​នៃ «បេតអែល» គែស​នាវ​ខ្លៃ​លាស​«ជៃ​កោរាញ​ឞ្រាស»។ ឞើស​នតើម​នើស​ឞូ​ក្វាល់​នតុក​នៃ​រាញា «លុស»។ ");
INSERT INTO cmok_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ជេសរី​យាកោប​ត៝ន ពាង់​លាស៖ “លាស​កោរាញ​ឞ្រាស​គុ​នទ្រែល​គ៝ប់ ម៝ត់​ញជ្រាង់​គ៝ប់​រ៝ៈ​ត្រ៝ង​គ៝ប់​ហាន់​អ្យា អ៝ន់​ព្យាង់​ត្រាវ​មា​គ៝ប់ នទ្រែល​មា​អ៝ន់​ឞ៝ក​ងគូត​អាវ​ញឆ៝ស​មា​គ៝ប់‌ ");
INSERT INTO cmok_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","អ៝ន់​គ៝ប់​ព្លឹ​ឆឹត​ត៝ត់​តា​ជៃ​ឞឹ​គ៝ប់​ដាប់​មពាន់ លាស​នទ្រី​គ៝ប់​មរា​យើក​មឞាស​មា​ឞ្រាស​យេហោវា​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","លុ​គ៝ប់​រាទ៝ក់​ជាន​ងគ៝ង់​អ្យា​ជេង​នតុក​មា​យើក​មឞាស​មៃ ម៝ស​នទើ​មៃ​អ៝ន់​មា​គ៝ប់ តៃ​គ៝ប់​ឆ៝ៈ​នទើ​នៃ​ទូ​កោៈ​តឹម​ជឹត​ញហើរ​មាមៃ​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ជេសរី​យាកោប​ទ៝ក់​ហាន់ ពាង់​ហាន់​ត៝ត់​តា​ឞ្រី​ផូង​ឞូនុយ្ស​គុ​មពែស​ឞើស​លោស​នារ។ ");
INSERT INTO cmok_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ពាង់​ឆៃ​គែស​ទូ​មល៝ម់​នតូ​ទាក​តា​ទូ​លោក​មីរ នទ្រែល​មា​គែស​ឞែ​ឞ្យាប់​ពែ​ផូង​ក្វែន​កេង​មែង​នតូ​ទាក​រី​ដ៝ង់ យ៝រ​លាស​ឞើស​នតូ​ទាក​អី​នៃ​ឞូ​វៃ​អ៝ន់​មា​ឞែ​ឞ្យាប់​ទែ​ញេត យើន​មា​គែស​លុ​ក្វ៝ង់​ងាន់​កុប​ឞើស​លើ​ឞ៝រ់​នតូ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","លាស​ទឹង​លែៈ​ឞែ​ឞ្យាប់​ផូង​ឞូ​លែៈ​វែង​លែៈ​រាគូម​តា​រី​ទាទេ រី​មើ​ទឹង​ឞូ​លែវ​ឞាល់​ពឺ​រាលាៈ​លុ​ឞើស​ឞ៝រ់​នតូ​រី​អ៝ន់​ឞែ​ឞ្យាប់​ញេត ជេសរី​ឞូ​រាលាៈ​តៃ​លុ​នៃ​កុប​តៃ​តា​ឞ៝រ់​នតូ​រី​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","យាកោប​អោប​មពោល​អី​ច្យាប់​នៃ៖ “អើ​អ៝ស​នោ ខាន់​មៃ​ឞើស​តាៈ?” ខាន់​ពាង់​អើស៖ “ហេន​តាៈ​ឞើស​ប៝ន​ចារាន ”។ ");
INSERT INTO cmok_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ពាង់​អោប​តៃ​មពោល​អី​នៃ​ជឹត៖ “លាស​នទ្រី​ខាន់​មៃ​នាល់​ដ៝ង់​វា​លាបាន​អី​ក៝ន​ចែ​នាហោរ?” ខាន់​ពាង់​អើស៖ “នាល់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","យាកោប​អោប​ខាន់​ពាង់៖ “លាស​នទ្រី​អ្វែស​លាង់​ដ៝ង់​ពាង់?” ខាន់​ពាង់​អើស៖ “អ្វែស​លាង់​ដ៝ង់ រី​ម៝ស រាចែល​អី​ក៝ន​ឞូ​អូរ​ពាង់ ហាន់​នទ្រែល​មា​ឞែ​ឞ្យាប់​ផូង​រី​ម៝ស”។ ");
INSERT INTO cmok_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","យាកោប​លាស​មា​ខាន់​ពាង់៖ “នារ​ហោម​អែ​ព្រេស មោ​ហ៝ៈ​ទី​ម៝ង​រាគូម​ឞែ​ឞ្យាប់ ជេស​អ៝ន់​ពាង់​ញេត​ទាក បើក​តៃ​អ៝ន់​ពាង់​ឆា​មពា​ប៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ខាន់​ពាង់​លាស៖ “មោ​ទើយ​អោស ហេន​ក៝ប់​គូម​អ៝ន់​រឹង​ឞែ​ឞ្យាប់​ផូង​ប៝ត់ ជេសរី​ពឺ​រាលាៈ​លុ​ឞើស​ឞ៝រ់​នតូ​ទាក​នៃ​រី​មើ​ទឹង​អ៝ន់​ឞែ​ឞ្យាប់​ញេត​ទាក”។ ");
INSERT INTO cmok_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ទោល​យាកោប​ហោម​អែ​ងើយ​ដាស​មពោល​នៃ រាចែល​ឆឹត​ត៝ត់​តា​នៃ នទ្រែល​មា​ឞែ​ឞ្យាប់​ឞឹ​ពាង់ យ៝រ​លាស​ពាង់​ឞូនុយ្ស​ច្យាប់​ឞែ​ឞ្យាប់។ ");
INSERT INTO cmok_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ត៝ត់​យាកោប​ឆៃ​រាចែល​អី​ក៝ន​លាបាន​ជេង​ក៝ន​អី​នោ​មេៈ​ពាង់​រី នទ្រែល​មា​ឞែ​ឞ្យាប់​លាបាន​ត៝ត់​តា​នៃ ពាង់​ហាន់​ពឺ​រាលាៈ​លុ​ឞើស​ឞ៝រ់​នតូ​ទាក​នៃ​អ៝ន់​ឞែ​ឞ្យាប់​លាបាន​រី​ញេត។ ");
INSERT INTO cmok_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ជេសរី​ពាង់​ចុម​រាចែល​រី​តា​តឹម​ឞ៝ម នហ៝​មា​ញុម។ ");
INSERT INTO cmok_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","យាកោប​មឞើស​ងក៝ច​មា​រាចែល ពាង់​ជេង​មពោល​ឞាល់​ដាស​ឞឹ​រាចែល ពាង់​អី​ក៝ន​រេបេកា។ ត៝ត់​មា​តាង់​នាវ​ងក៝ច​អី​នៃ រាចែល​ញច្វាត់​មឞើស​មា​អី​ឞឹ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ត៝ត់​មា​លាបាន​តាង់​ងក៝ច​យាកោប​ក៝ន​អី​អ៝ស​ឞូ​អូរ​ពាង់​នើម ពាង់​ហាន់​ញច្វាត់​រ៝ ចុម​អូត​យាកោប​រី លែវ​យាកោប​ឆឹត​លាប់​អា​ជៃ​ពាង់​រី។ ជេសរី​យាកោប​ងក៝ច​ឞ្រី​មា​លាបាន​នោ​នាវ​ពាង់​ហាន់​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","លាបាន​លាស​មា​យាកោប៖ “មៃ​អ្យា​មលៃ​មហាម​គ៝ប់​ងាន់”។ ជេស​យាកោប​គុ​នទ្រែល​លាបាន​តា​រី​គែស​ទូ​ខៃ ");
INSERT INTO cmok_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","លាបាន​លាស​មា​យាកោប៖ “ឞ៝ល​លាស​មៃ​មា​គ៝ប់​ជេង​វា​ម៝ន មើម​ឞ្លាវ​ជាន​ការ​ទើម​ទាម មៃ​មឞើស​មា​គ៝ប់ ម៝ស​នទើ​មៃ​អុច​មា​ងខោម?” ");
INSERT INTO cmok_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","លាបាន​គែស​ឞារ​ហៃ​ក៝ន​ឞូ​អូរ អី​យោស​រាញា​លេអា អី​អ៝ស​រាញា​រាចែល។ ");
INSERT INTO cmok_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","លេអា​ត្រោម​មាត់​ពាង់​អ្វែស យើន​មា​រាចែល​លែៈ​មុស​មាត់​លែៈ​ឆាក់​ជាន់​ពាង់​អ្វែស​រែស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","យាកោប​រ៝ង់​រាចែល​ហោ​ងាន់ ពាង់​អើស​កើត​នអា៖ “គ៝ប់​អុច​ជាន​ការ​មា​មៃ​ពើស​នាម់​វា គៃ​មា​គែស​ឆ៝ៈ​រាចែល​ក៝ន​មៃ​នៃ​មា​ជេង​អូរ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","លាបាន​អើស​មា​ពាង់៖ “អ្វែស​រាលាវ​គ៝ប់​អ៝ន់​ពាង់​មា​មៃ​ដាស​មា​គ៝ប់​អ៝ន់​ពាង់​មា​ឞូ​អេង លាស​នទ្រី​មៃ​គុ​នទ្រែល​គ៝ប់​ទោស​ម៝ន!” ");
INSERT INTO cmok_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ជេសរី​យាកោប​គុ​ជាន​ការ​មា​លាបាន​ពើស​នាម់ គៃ​មា​គែស​ឆ៝ៈ​រាចែល​នៃ ឞ៝ល​លាស​ជ៝ៈ​ទាស​នៃ​កាដោយ​តឹម​ឞាន​មា​ពែ​ព្វាន់​នារ​ទើម​មា​ពាង់ យ៝រ​លាស​ពាង់​រ៝ង់​រាចែល​ទុត​ហោ។ ");
INSERT INTO cmok_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ជេស​ឞើស​នៃ​យាកោប​លាស​មា​លាបាន៖ “អើ​វា មៃ​នអាប់​គ៝ប់​ដាស​រាចែល​ហ៝ម់ គៃ​មា​គ៝ប់​គុ​ដាស​ពាង់ យ៝រ​លាស​គ៝ប់​ជាន​ការ​អ៝ន់​មៃ​លែៈ​លោច​ពើស​នាម់ នាវ​ឞ៝ន់​តឹម​ត៝ន​នើស​លែៈ​ត៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ជេសរី​លាបាន​ជាន​នទ្រាប់​ញេត​នអាប់​ក៝ន​ពាង់​នៃ ពាង់​ជាៈ​ទឹង​លែៈ​ឞូនុយ្ស​តា​ប៝ន​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ត៝ត់​អា​មាង់ លាបាន​ទែ​រាព្លាច់​ឆ៝ៈ​ក៝ន​ពាង់​លេអា​អ៝ន់​ឞិច​ដាស​យាកោប ជេសរី​យាកោប​ឞិច​ដាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","លាបាន​ឆ៝ៈ​ឆិលផា​អី​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​មា​ពាង់​នើម​អ៝ន់​មា​លេអា មា​ឆើម​កើល​ជាន​ការ​ក៝ន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ត៝ត់​អាង​អោយ​យាកោប​ឆៃ​លេអា​ច្រាវ ជេសរី​ពាង់​លាស​លាបាន៖ “ម៝ស​មៃ​ជាន​មា​គ៝ប់​កើត​នអា? អើម​មោ​ទី​លាស​គៃ​មា​គែស​ឆ៝ៈ​រាចែល​គ៝ប់​ជាន​ការ​មៃ​នើស? ម៝ស​មៃ​នទើម​គ៝ប់?” ");
INSERT INTO cmok_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","លាបាន​អើស​មា​ពាង់៖ “តា​ឞ្រី​អ្យា​ឞូ​មោ​អោស​វៃ​អ៝ន់​ល៝រ​អី​អ៝ស។ ");
INSERT INTO cmok_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","អ៝ន់​មៃ​គុ​ដាស​ពាង់​ត៝ត់​ទូ​ពើស​ប៝ត់ តៃ​ទឹង​គ៝ប់​អ៝ន់​រាចែល​អ្យា​មា​មៃ​ដ៝ង់ ជេសរី​មៃ​គុ​ជាន​ការ​តៃ​មា​គ៝ប់​អ៝ន់​គែស​ពើស​នាម់​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","យាកោប​ជាន​តឹង​នាវ​លាបាន​ទែ​លាស​មា​ពាង់​នៃ ពាង់​គុ​ដាស​លេអា​ត៝ត់​លោច​ទូ​ពើស ជេសរី​លាបាន​អ៝ន់​តៃ​រាចែល​មា​យាកោប​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ពាង់​ឆ៝ៈ​ដ៝ង់​បិលហា​អី​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​មា​ពាង់​នើម​អ៝ន់​មា​រាចែល មា​ឆើម​កើល​ជាន​ការ​អ៝ន់​មា​ក៝ន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","យាកោប​ហាន់​ឞិច​នទ្រែល​រាចែល​ដ៝ង់ ពាង់​រ៝ង់​រាចែល​រាលាវ​ដាស​ពាង់​រ៝ង់​លេអា។ ជេសរី​ពាង់​គុ​ជាន​ការ​មា​លាបាន​ពើស​នាម់​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ឞ្រាស​យេហោវា​ឆៃ​យាកោប​មោ​រ៝ង់​មា​លេអាពាង់​ជាន​អ៝ន់​មា​លេអា​គែស​ក៝ន តីស​មា​រាចែល​មោ​គែស​ក៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","លេអា​នត្រែវ ពាង់​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ ជេសរី​ពាង់​តេៈ​រាញា​«រូបេន» យ៝រ​លាស​ពាង់​លាស៖ “​ឞ្រាស​យេហោវា​លែៈ​ឆៃ​នាវ​រាង៝ត​តា​គ៝ប់ អាបៃ​អ្យា​គឹត​លាស​ឆាយ​គ៝ប់​រ៝ង់​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ជេសរី​ពាង់​នត្រែវ​តៃ​ឞាៈ​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត ពាង់​លាស៖ “ឞ្រាស​យេហោវា​លែៈ​ពាង់​តាង់​ជេស​ឆាយ​គ៝ប់​មោ​រ៝ង់​មា​គ៝ប់ នទ្រី​ទឹង​ពាង់​អ៝ន់​តៃ​ក៝ន​ឞូ​ក្លោ​អ្យា​មា​គ៝ប់”។ ជេសរី​លេអា​តេៈ​រាញា​ក៝ន​នៃ «ឆីមោន»។ ");
INSERT INTO cmok_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ពាង់​នត្រែវ​តៃ​ឞាៈ​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត ពាង់​លាស៖ “ជ៝ង់​អ្យា​ឆាយ​គ៝ប់​មរា​ក្រេប​រ៝ង់​មា​គ៝ប់​ងាន់​រ៝ យ៝រ​លាស​គ៝ប់​គុ​អ៝ស​ក៝ន​ឞូ​ក្លោ​មា​ពាង់​លែៈ​ពែ​អឹ”។ កើត​នទ្រី​ទឹង​ពាង់​តេៈ​រាញា​ក៝ន​នៃ «លេវី»។ ");
INSERT INTO cmok_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ជេសរី​ពាង់​នត្រែវ​តៃ​ឞាៈ​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត ពាង់​លាស៖ “ទូ​តឹ​អ្យា​គ៝ប់​រានេ​មា​ឞ្រាស​យេហោវា”។ កើត​នទ្រី​ទឹង​ពាង់​តេៈ​រាញា​ក៝ន​នៃ «យូដា» ជេសរី​ពាង់​មោ​ហោម​អោស​ឞាៈ​ក៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","នោក​រាចែល​ឆៃ​ឆាក់​ពាង់​នើម​មោ​អោស​ឞាៈ​ក៝ន​មា​យាកោប ពាង់​មោ​នាច​អី​យោស​ព្រែ។ ជេសរី​ពាង់​លាស​មា​យាកោប៖ “អ៝ន់​គ៝ប់​គែស​ក៝ន​បាៈ លាស​មោ​គែស​ក៝ន​ខឹត​ហើយ្ស​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","យាកោប​ហាវ​នូយ្ស​ឞ្រូត ពាង់​ជី​នូយ្ស​មា​រាចែល ពាង់​អើស៖ “គ៝ប់​អ្យា​គឹត​មា​កោរាញ​ឞ្រាស​អី​មោ​អ៝ន់​អៃ​គែស​ក៝ន​លាស?” ");
INSERT INTO cmok_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","រាចែល​លាស៖ “នៃ​បិលហា​តា​នៃ ពាង់​អី​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​គ៝ប់​នើម មៃ​ឆ៝ៈ​ពាង់​ទោ គៃ​មា​ពាង់​ឞាៈ​ក៝ន​មា​គ៝ប់ គ៝ប់​ឆ៝ៈ​ក៝ន​នៃ​ម៝ត់​ជេង​តឹម​ឞាន​មា​ក៝ន​គ៝ប់​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","រាចែល​ឆ៝ៈ​បិលហា​អី​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​ពាង់​នើម​នៃ​អ៝ន់​ជេង​អូរ​យាកោប នទ្រី​យាកោប​ឞិច​ដាស​បិលហា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ជេសរី​បិលហា​នត្រែវ ពាង់​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​មា​យាកោប។ ");
INSERT INTO cmok_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","រាចែល​លាស៖ “លែៈ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​ឆ៝ង់​មា​គ៝ប់ លែៈ​ពាង់​តាង់​នាវ​គ៝ប់​ទាន់ យ៝រ​លាស​ពាង់​លែៈ​អ៝ន់​គ៝ប់​គែស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ” នទ្រី​ទឹង​រាចែល​តេៈ​រាញា​ក៝ន​នៃ «ដាន»។ ");
INSERT INTO cmok_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ជេសរី​បិលហា​អី​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​មា​រាចែល​នៃ ពាង់​នត្រែវ​តៃ​ឞាៈ​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត​មា​យាកោប។ ");
INSERT INTO cmok_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","រាចែល​លាស៖ “គ៝ប់​តឹម​រាទ៝ង់​ដាស​មា​យោស​គ៝ប់​គៃ​មា​កោរាញ​ឞ្រាស​កើល ត៝ត់​ទើយ​គ៝ប់​ដ៝ង់”។ ជេសរី​ពាង់​តេៈ​រាញា​ក៝ន​នៃ «នាប់តាលី»។ ");
INSERT INTO cmok_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ត៝ត់​លេអា​ឆៃ​ឆាក់​ពាង់​នើម​មោ​ហោម​ឞាៈ​ក៝ន ពាង់​ឆ៝ៈ​ឆិលផា​អី​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​មា​ពាង់​នើម​នៃ​អ៝ន់​ជេង​អូរ​យាកោប។ ");
INSERT INTO cmok_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ជេសរី​ឆិលផា​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​មា​យាកោប។ ");
INSERT INTO cmok_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","លេអា​លាស៖ “គែស​នាវ​លាប​ងាន់” ជេសរី​ពាង់​តេៈ​រាញា​ក៝ន​នៃ «កាត»។ ");
INSERT INTO cmok_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ឆិលផា​អី​អ៝ស​ម៝ន​លេអា​នៃ​ឞាៈ​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត​មា​យាកោប។ ");
INSERT INTO cmok_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","លេអា​លាស៖ “គ៝ប់​រាម់​មអាក​ងាន់ យ៝រ​លាស​ទឹង​លែៈ​ផូង​ឞូ​អូរ ឞូ​លាស​មា​គ៝ប់​រាម់​មអាក​ងាន់”។ ជេសរី​ពាង់​តេៈ​រាញា​ក៝ន​នៃ «អាឆើរ»។ ");
INSERT INTO cmok_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ត៝ត់​ខៃ​រែក​ឞា​ព្រាង់ រូបេន​ហាន់​អា​មីរ ពាង់​ឆៃ​ព្លៃ​ឆានែ​ពាង់​ពែៈ​អ៝ន់​លេអា​អី​មេៈ​ពាង់។ ជេសរី​រាចែល​លាស​មា​លេអា៖ “ទាន់​ពាៈ​ព្លៃ​ឆានែ​ក៝ន​អៃ​នៃ​អ៝ន់​គ៝ប់​បាៈ​យោស”។ ");
INSERT INTO cmok_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","លេអា​លាស​មា​ពាង់៖ “មោ​ហ៝ៈ​ឆ៝ប់​អៃ​ពីត​ឆាយ​គ៝ប់​បាស? អាបៃ​អ្យា​អៃ​អុច​ទាន់​ព្លៃ​ឆានែ​ក៝ន​គ៝ប់​ជឹត”។ រាចែល​អើស​មា​ពាង់៖ “លាស​អៃ​អ៝ន់​ព្លៃ​ឆានែ​ក៝ន​អៃ​នៃ​មា​គ៝ប់ គ៝ប់​អ៝ន់​ឆាយ​គ៝ប់​ឞិច​ដាស​អៃ​មាង់​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ត៝ត់​កេង​មាង់ នោក​យាកោប​ឆឹត​ឞើស​មីរ លេអា​ហាន់​ច្វាៈ​ពាង់​អា​ត្រ៝ង​រី ពាង់​លាស៖ “អ្យាត់​មា​មៃ​ឞិច​ដាស​គ៝ប់​មាង់​អ្យា យ៝រ​លាស​លែៈ​ជេស​គ៝ប់​រាវាត់​មៃ​មា​ព្លៃ​ឆានែ​ក៝ន​គ៝ប់”។ ជេសរី​មាង់​នៃ​យាកោប​ហាន់​ឞិច​ដាស​មា​លេអា។ ");
INSERT INTO cmok_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","កោរាញ​ឞ្រាស​អើស​នាវ​លេអា​ទាន់ ជេសរី​លេអា​នត្រែវ​ឞាៈ​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត នៃ​ជេង​ក៝ន​ត៝ល់​ព្រាម់​លេអា​ឞាៈ​មា​យាកោប។ ");
INSERT INTO cmok_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","លេអា​លាស៖ “កោរាញ​ឞ្រាស​អ៝ន់​នទើ​ងខោម​មា​គ៝ប់ យ៝រ​លាស​លែៈ​គ៝ប់​អ៝ន់​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​មា​គ៝ប់​នើម​មា​ឆាយ​គ៝ប់”។ ជេសរី​ពាង់​តេៈ​រាញា​ក៝ន​នៃ «អីឆាខារ»។ ");
INSERT INTO cmok_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","លេអា​នត្រែវ​តៃ​ឞាៈ​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត​មា​យាកោប ជេង​ក៝ន​ត៝ល់​ព្រាវ។ ");
INSERT INTO cmok_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","លេអា​លាស៖ “កោរាញ​ឞ្រាស​អ៝ន់​ទើម​ទាម​នទើ​ខ្លៃ​មា​គ៝ប់ ទូ​តឹ​អ្យា​ឆាយ​គ៝ប់​ពាង់​យើក​មា​គ៝ប់​រ៝ យ៝រ​លាស​លែៈ​គ៝ប់​ឞាៈ​ព្រាវ​អឹ​ក៝ន​ឞូ​ក្លោ​មា​ពាង់”។ ជេសរី​ពាង់​តេៈ​រាញា​ក៝ន​នៃ «ឆាប់យូលោន»។ ");
INSERT INTO cmok_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ជេស​ឞើស​នៃ​ពាង់​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​អូរ ពាង់​តេៈ​រាញា «ដីនា»។ ");
INSERT INTO cmok_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","កោរាញ​ឞ្រាស​ហោម​កើល​មា​រាចែល​អើស​នាវ​ពាង់​ទាន់ ជេសរី​ជាន​អ៝ន់​រាចែល​គែស​ក៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ជេសរី​ពាង់​នត្រែវ​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ ពាង់​លាស៖ “កោរាញ​ឞ្រាស​មោ​ហោម​អោស​អ៝ន់​គ៝ប់​គែស​នាវ​ដីត​ព្រេង​ជឹត​”។ ");
INSERT INTO cmok_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ជេសរី​ពាង់​តេៈ​រាញា​ក៝ន​នៃ «យោឆែប» ពាង់​លាស៖ “ទាន់​ឞ្រាស​យេហោវា​នត៝ប​អ៝ន់​មា​គ៝ប់​ហោម​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ជេស​រាចែល​ឞាៈ​យោឆែបយាកោប​ងើយ​មា​លាបាន៖ “អើ​ចែ គ៝ប់​ទាន់​អ៝ន់​គ៝ប់​ព្លឹ​ឆឹត​តា​ឞ្រី​គ៝ប់​នើម​រី ");
INSERT INTO cmok_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","គ៝ប់​ទាន់​លែវ​អូរ​លែវ​ក៝ន​គ៝ប់​អ្យា​ហាន់​នទ្រែល​គ៝ប់​នើម គ៝ប់​លែៈ​លោច​ជេស​ជាន​ការ​មា​បែ​យ៝រ​មា​ឞារ​ហៃ​ក៝ន​បែ​អ្យា។ បែ​លែៈ​គឹត​ដ៝ង់​នាវ​គ៝ប់​ជាន​ការ​អ្វែស​មា​បែ”។ ");
INSERT INTO cmok_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","លាបាន​អើស​មា​ពាង់៖ “ទាន់​បែ​អ្យាត់​នាវ​គ៝ប់​ប៝ត់ លែៈ​គ៝ប់​គឹត​នហេល​ងាន់​ឞ្រាស​យេហោវា​ទែ​អ៝ន់​គែស​ជេង​មា​គ៝ប់​អ្យា ជេង​តាៈ​ឞើស​បែ។ ");
INSERT INTO cmok_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","មឞើស​មា​គ៝ប់​ហ៝ម់ ម៝ស​នទើ​បែ​អុច​ឆ៝ៈ​ងខោម​ឞើស​គ៝ប់ គ៝ប់​អ៝ន់​មា​បែ”។ ");
INSERT INTO cmok_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","យាកោប​អើស​មា​ពាង់៖ “អើ​ចែ បែ​លែៈ​គឹត​ជេស​នាវ​គ៝ប់​គុ​ជាន​ការ​រាអាស​រាគាញ់​មា​បែ​នើស គ៝ប់​ម៝ត់​អ្វាញ់​មពោមពា​(ឆ្យុម)​ផូង​បែ​នើស ជេសរី​គែស​លើ​មា​អ៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","នោក​អេ​ហ៝ៈ​គ៝ប់​គុ​នទ្រែល​មា​បែ មពោមពា​(ឆ្យុម)​បែ​ដេៈ​ទើម ល៝ង់​អាបៃ​អ្យា​មពោមពា​(ឆ្យុម)​បែ​លែៈ​ឞឹក​រឹ​អ៝ក់​ងាន់ នតើម​ឞើស​គ៝ប់​គុ​នទ្រែល​បែ​ឞ្រាស​យេហោវា​អ៝ន់​គែស​ជេង​មា​បែ​តា​ទឹង​លែៈ​នទើ​គ៝ប់​ជាន។ អាបៃ​អ្យា​គ៝ប់​អុច​ជាន​ការ​អ៝ន់​មា​រានាក់​វ៝ល់​គ៝ប់​នើម​ហាញ”។ ");
INSERT INTO cmok_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","លាបាន​លាស​មា​យាកោប៖ “លាស​នទ្រី​ម៝ស​នទើ​បែ​អុច​គ៝ប់​អ៝ន់​មា​បែ?” យាកោប​អើស៖ “អើ​ចែ បែ​លើយ​អោស​អ៝ន់​នទើ​មា​គ៝ប់។ លាស​បែ​អុច អ៝ន់​គ៝ប់​ហោម​គុ​ច្យាប់​ឞែ​ឞ្យាប់​ផូង​បែ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","នារ​អ្យា​គ៝ប់​ហាន់​អ្វាញ់​តា​ឞែ​ឞ្យាប់​ផូង​បែ ទឹង​លែៈ​ឞែ​ឞ្យាប់​អី​គែស​រាវាញ​រុក​លុក នទ្រែល​មា​ក៝ន​ឞែ​ឞ្យាប់​អី​ក្រាក់ៗ គ៝ប់​ងខាស​អ៝ន់​គុ​អេង។ ទឹង​លែៈ​ឞែ​អី​គែស​រាវាញ​រុក​លុក​គ៝ប់​ងខាស​អ៝ន់​គុ​អេង​ឞើស​ផូង​មពោមពា​(ឆ្យុម)​បែ។ ជេសរី​ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​នៃ​គ៝ប់​ទាន់​ឆ៝ៈ​ជេង​នទើ​ងខោម​អ៝ន់​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","នារ​ជឹត​នាប់​តៃ​ត៝ត់​បែ​ហាន់​អ្វាញ់​មពោមពា​(ឆ្យុម)​អី​ងខោម​មា​គ៝ប់ បែ​ឆៃ​ទី​កើត​នាវ​គ៝ប់​លាស​នៃ​រ៝ ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​មោ​គែស​រាវាញ​រុក​លុក​អី​បែ​ឆៃ មោ​លាស​ទឹង​លែៈ​ឞែ​ឞ្យាប់​មោ​គែស​ក្រាក់​គុ​តា​មពោមពា​(ឆ្យុម)​ផូង​គ៝ប់ ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​នៃ​ជេង​កើប​គ៝ប់​នតុង”។ ");
INSERT INTO cmok_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","លាបាន​អើស៖ “អើ កាដោយ​ដ៝ង់ បែ​ជាន​តឹង​នាវ​បែ​លាស​រី​ទោស!” ");
INSERT INTO cmok_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ជេសរី​នារ​នៃ​រ៝​លាបាន​ហាន់​តឹម​ងខាស​ឞែ​ងក្វ៝ង់​អី​គែស​រាវាញ​មព៝រ នទ្រែល​មា​ឞែ​មែ​អី​គែស​រាវាញ​មព៝រ ទឹង​លែៈ​ឞែ​អី​គែស​ងលាង​ដេៈ នទ្រែល​មា​ឞែ​ឞ្យាប់​អី​ក្រាក់ៗ ពាង់​តឹម​ងខាស​អ៝ន់​គុ​អេង ផូង​អី​នៃ​ពាង់​អ៝ន់​មា​មពោល​ក៝ន​ពាង់​នើម​ម៝ត់​ច្យាប់។ ");
INSERT INTO cmok_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ជេសរី​លាបាន​អ៝ន់​ខាន់​ពាង់​គុ​បាស​ងាយ​ដាស​យាកោប​ពែ​នារ​ឞ្រោៈ​ត្រ៝ង។ យាកោប​គុ​ម៝ត់​មពោមពា​(ឆ្យុម)​លាបាន​អី​ហោម​តា​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","យាកោប​គិច​ងគីង​ពែ​នតីល​តើម​ឆី​អី​គែស​ងលាង​តា​ន៝ម់​នតោ​អី​ហោម​រេស ពាង់​ព្លោក​ច៝រ​អី​នតោ​រី​អ៝ន់​ឆៃ​ងលាង​រូន​អូន។ ");
INSERT INTO cmok_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ជេសរី​ពាង់​ឆ៝ៈ​ងគីង​ឆី​អី​នៃ​នទើម​តា​ត្រ៝ង​ទាក នទ្រែល​មា​តា​ឞ៝ង នតុក​មពោមពា​(ឆ្យុម)​ពាង់​វៃ​ញេត​ទាក គៃ​មា​អ៝ន់​មពោមពា​(ឆ្យុម)​នៃ​ឆៃ យ៝រ​លាស​ពាង់​តឹម​ជើង​ឞាល់​ទោល​ពាង់​ញេត​ទាក។ ");
INSERT INTO cmok_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","លាស​ពាង់​តឹម​ជើង​តា​ព្លាង់​ងគីង​ឆី​នៃ ត៝ត់​មា​ទែស​ក៝ន​ជេង​រាវាញ​មព៝រ។ ");
INSERT INTO cmok_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ជេសរី​យាកោប​តឹម​ងខាស​លើយ​ទឹង​លែៈ​ក៝ន​អី​គែស​រាវាញ​មព៝រ​អ៝ន់​គុ​អេង​ឞើស​មពោមពា​(ឆ្យុម)​លាបាន។ នោក​តឹម​ជើង ពាង់​អ៝ន់​មពោមពា​(ឆ្យុម)​លាបាន​អ្វាញ់​ជឹត​មពោមពា​(ឆ្យុម)​អី​រាវាញ​មព៝រ មោ​លាស​អី​ក្រាក់ៗ គៃ​មា​គែស​ក៝ន​រាវាញ​មព៝រ។ កើត​នទ្រី​មពោមពា​(ឆ្យុម)​ផូង​ពាង់​នើម​គែស​លើ​មា​អ៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ត៝ត់​មា​មពោមពា​(ឆ្យុម)​អី​ទាង់ៗ​តឹម​ជើង​ឞាល់ យាកោប​ឆ៝ៈ​ងគីង​ឆី​រី​នទើម​តា​ត្រ៝ង​ទាក​អ៝ន់​មពោមពា​(ឆ្យុម)​នៃ​ឆៃ គៃ​មា​អ៝ន់​ពាង់​តឹម​ជើង​ឞាល់​តា​ព្លាង់​ឞើស​នាប់​ងគីង​ឆី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","លាស​មពោមពា​(ឆ្យុម)​អី​មោ​ទាង់​មោ​ទាង់​តឹម​ជើង​ឞាល់ ពាង់​មោ​អោស​នទើម​ងគីង​ឆី​នៃ។ កើត​នទ្រី​ទឹង​មពោមពា​(ឆ្យុម)​អី​មោ​ទាង់​មោ​ទាង់​ជេង​មពោមពា​(ឆ្យុម)​លាបាន ជេសរី​មពោមពា​(ឆ្យុម)​អី​ទាង់ៗ​ជេង​មពោមពា​(ឆ្យុម)​យាកោប។ ");
INSERT INTO cmok_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ជេសរី​យាកោប​គែស​ទ្រាប់​នទើ​លើ​មា​អ៝ក់​ងាន់ ពាង់​គែស​មពោមពា​(ឆ្យុម)​ទុត​អ៝ក់ គែស​នអ៝ប់​មា​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​ឞូ​អូរ​ឞូ​ក្លោ នអ៝ប់​មា​ឆែស​ឆាមោ នទ្រែល​មា​ឆែស​លៀ​អ៝ក់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ជេសរី​យាកោប​តាង់​ផូង​ក៝ន​ឞូ​ក្លោ​លាបាន​តឹម​លាស៖ “លែៈ​យាកោប​ឆ៝ៈ​ញឆ្យាន់​ទ្រាប់​នទើ​ឞឹ​ឞ៝ន់។ ពាង់​នទ្រ៝ង់​អ៝ក់​ទ្រាប់​នទើ​នៃ​តាៈ​ឞើស​ទ្រាប់​នទើ​ឞឹ​ឞ៝ន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","យាកោប​ឆៃ​លាបាន​មោ​ហោម​អោស​លាង់​មឞើស​ងើយ​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ជេសរី​ឞ្រាស​យេហោវា​លាស​មា​ពាង់៖ “មៃ​ព្លឹ​ឆឹត​ហ៝ម់​តា​ឞ្រី​អូ​ចែ​មៃ​នើម តា​នទុល​មពោល​មៃ​នើម​រី គ៝ប់​មរា​គុ​នទ្រែល​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ជេសរី​យាកោប​ដាៈ​ឞូ​ហាន់​ក្វាល់​រាចែល នទ្រែល​មា​លេអា ហាន់​គុ​នទ្រែល​ពាង់​តា​នតុក​ច្យាប់​ឞែ​ឞ្យាប់​តា​នទ្រិច​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","យាកោប​លាស​មា​ឞារ​ហៃ​អូរ​ពាង់​នៃ៖ “លែៈ​គ៝ប់​ឆៃ​ឞឹ​ខាន់​អៃ​មោ​ហោម​អោស​លាង់​មឞើស​ងើយ​មា​គ៝ប់​កើត​ឞើស​នតើម​នើស យើន​មា​កោរាញ​ឞ្រាស​អី​ឞឹ​គ៝ប់​យើក​មឞាស​លែៈ​គុ​នទ្រែល​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ខាន់​អៃ​លែៈ​គឹត​ដ៝ង់​គ៝ប់​គុ​ជាន​ការ​អ៝ន់​មា​ឞឹ​ខាន់​អៃ លែៈ​ឞើស​ឞ្រាត់​ឆ្វាន​គ៝ប់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","យើន​មា​ឞឹ​ខាន់​អៃ​ពាង់​នទើម​មរោស​គ៝ប់ ពាង់​ងើយ​មព្លាច់​នទើ​ងខោម​មា​គ៝ប់​លែៈ​ជឹត​តឹ។ យើន​មា​កោរាញ​ឞ្រាស​មោ​អោស​អ៝ន់​ពាង់​ជាន​អ្យើស​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","លាស​ឞឹ​ខាន់​អៃ​លាស៖ «ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អី​គែស​រាវាញ​រុក​លុក​ទើម ជេង​នទើ​ងខោម​មា​អ៝ន់​បែ​ទាទេ» ជេសរី​ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​ត៝ត់​មា​ទែស​ក៝ន​គែស​រាវាញ​រុក​លុក​ទាទេ​រ៝ លាស​ឞឹ​ខាន់​អៃ​លាស៖ «ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អី​គែស​រាវាញ​មព៝រ​ទើម ជេង​នទើ​ងខោម​មា​អ៝ន់​បែ​ទាទេ» ជេសរី​ត៝ត់​មា​ទែស​ក៝ន​គែស​រាវាញ​មព៝រ​ទាទេ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","កើត​នទ្រី​កោរាញ​ឞ្រាស​ឆ៝ៈ​មពោមពា​(ឆ្យុម)​ឞឹ​ខាន់​អៃ​អ៝ន់​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","នោក​ខៃ​តឹម​ជើង​មពោមពា​(ឆ្យុម) គែស​ទូ​មាង់​គ៝ប់​មឞើយ​ឆៃ​ឞែ​ងក្វ៝ង់​ជើង​ឞែ​មែ តា​នៃ​ឞែ​ងក្វ៝ង់​គែស​រាវាញ​មព៝រ នទ្រែល​មា​គែស​រាវាញ​រុក​លុក​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ជេសរី​តោង​ពារ់​កោរាញ​ឞ្រាស​ក្វាល់​គ៝ប់៖ «ហើយ​យាកោប!” គ៝ប់​អើស៖ «ម៝ស​នទើ»។ ");
INSERT INTO cmok_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","តោង​ពារ់​នៃ​លាស៖ «មៃ​អ្វាញ់​នៃ! ទឹង​លែៈ​ឞែ​ងក្វ៝ង់​ជើង​ឞែ​មែ តា​នៃ​ឞែ​ងក្វ៝ង់​គែស​រាវាញ​មព៝រ នទ្រែល​មា​រាវាញ​រុក​លុក​ទាទេ យ៝រ​លាស​គ៝ប់​លែៈ​ឆៃ​នាវ​លាបាន​ទែ​ជាន​មា​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","គ៝ប់​អ្យា​កោរាញ​ឞ្រាស​អី​ញហើ​ឆាក់​មា​មៃ​តា​ប៝ន​បេតអែល នតុក​មៃ​ត៝ៈ​ទាក​ងី​តា​ងគ៝ង់​លុ​នៃ​នើស នអ៝ប់​មា​មៃ​ត៝ន​មា​គ៝ប់​ដ៝ង់។ អាបៃ​អ្យា​មៃ​ទ៝ក់​លោស​ឞើស​ឞ្រី​ទាក​អ្យា​ហ៝ម់ ព្លឹ​ឆឹត​តា​នតុក​ឞ្រី​ទាក​ទែស​មៃ​នើម​រី​នើស»”។ ");
INSERT INTO cmok_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","រាចែល នទ្រែល​មា​លេអា​អើស​មា​យាកោប៖ “ឞឹ​ហេន​ពាង់​មោ​គែស​អោស​អ៝ន់​ទ្រាប់​នទើ​ខ្លៃ​មា​នទ្រៃ​អ៝ន់​មា​ហេន។ ");
INSERT INTO cmok_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ពាង់​លែៈ​កើប​ហេន​ជេង​តឹម​ឞាន​មា​ផូង​ឞូ​នាច់​ដ៝ង់ ពាង់​តឹម​ឞាន​មា​តាច់​ហេន ជេសរី​ទ្រាប់​នទើ​អី​មៃ​លែៈ​ជាន​ការ​មា​ពាង់​យ៝រ​មា​ហេន ពាង់​ឆ៝ៈ​មា​ពាង់​នើម​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ទឹង​លែៈ​ទ្រាប់​នទើ​កោរាញ​ឞ្រាស​ទែ​អ៝ន់​មា​មៃ​ឆ៝ៈ​តាៈ​ឞើស​ឞឹ​ហេន ជេង​ទ្រាប់​នទើ​មា​ហេន នទ្រែល​មា​ផូង​អ៝ស​ក៝ន​ហេន។ លាស​នទ្រី​មៃ​ជាន​ហ៝ម់​ម៝ស​នទើ​កោរាញ​ឞ្រាស​ទែ​ដាៈ​មា​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ជេសរី​យាកោប​ទ៝ក់​ហាន់ ពាង់​អ៝ន់​អូរ​អ៝ន់​ក៝ន​ពាង់​ញច៝​ឆែស​ឆាមោ‌ ");
INSERT INTO cmok_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ជេសរី​ពាង់​វែង​ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​ផូង​ពាង់​នើម នអ៝ប់​មា​ញអោត​លែវ​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស​ទោល​ពាង់​គុ​តា​ឞ្រី​ពាដាន-អារាម​នៃ​នើស គៃ​មា​ព្លឹ​ឆឹត​តា​អីឆាក់​ឞឹ​ពាង់​នើម​តា​ឞ្រី​កានាន​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ទោល​នៃ​លាបាន​នទុត​ហាន់​ក៝ស​រាឆៅ​ឞែ​ឞ្យាប់​ពាង់​នើម ជេសរី​រាចែល​នតុង​លែៈ​ផ្យៅ​រូប​ឞ្រាស​ឞឹ​ពាង់​តា​ជៃ​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","យាកោប​ញច្វាត់​នតុង​មា​លាបាន​ផូង​អារាម​នៃ ពាង់​មោ​អោស​មឞើស​អ៝ន់​លាបាន​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","យាកោប​ញអោត​លែវ​លែៈ​ផ្យៅ​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស។ ពាង់​ហាន់​គ្លាត់​ទាក​រាលាយ​អើប្រាត ហាន់​លែត​ជឹត​យោក​ឞ្រី​កាលាត​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ត៝ត់​លែៈ​ពែ​នារ គែស​ឞូ​ហាន់​មឞើស​មា​លាបាន​នាវ​យាកោប​លែៈ​ញច្វាត់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ជេសរី​លាបាន​លែវ​នទុល​មពោល​ពាង់​ហាន់​តឹង​យាកោប ខាន់​ពាង់​តឹង​ពើស​នារ រី​មើ​ទឹង​ឞាន​តា​យោក​កាលាត​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","យើន​មា​កោរាញ​ឞ្រាស​ហាន់​មឞើស​មា​លាបាន​ផូង​អារាម​នៃ​តា​នាវ​មឞើយ​តា​នោក​មាង់ ពាង់​លាស៖ “មៃ​ញជ្រាង់​ហ៝ៈ មៃ​លើយ​អោស​ទាស​មា​ងើយ​មា​យាកោប ឞ៝ល​លាស​នាវ​អ្វែស មោ​លាស​នាវ​អ្យើស”។ ");
INSERT INTO cmok_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","លាបាន​តឹង​ឞាន​យាកោប នោក​យាកោប​លែៈ​គុ​រាទ៝ក់​ចូន​ឞ៝ក​តា​កាលើ​យោក​ឞ្រី​កាលាត​រី លាបាន នទ្រែល​មា​នទុល​មពោល​ពាង់​គុ​រាទ៝ក់​ចូន​ឞ៝ក​តា​កាលើ​យោក​កាលាត​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","លាបាន​លាស​យាកោប៖ “ម៝ស​ទឹង​បែ​ជាន​ក្វែ​ញច្វាត់​នតុង​មា​គ៝ប់? រាទូ​ក៝ន​ឆៅ​គ៝ប់ តឹម​ឞាន​មា​ឞូ​ញុប​វែង​ឞើស​នតុក​តឹម​លើស​តឹម​ឆ្រែស​នៃ ម៝ស​ទឹង​បែ​ជាន​កើត​នៃ? ");
INSERT INTO cmok_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ម៝ស​ទឹង​បែ​ញច្វាត់​នតុង​មា​គ៝ប់​កើត​នៃ មោ​មឞើស​អ៝ន់​គ៝ប់​គឹត? លាស​គ៝ប់​គឹត គ៝ប់​ញជុន​ខាន់​បែ​មា​នាវ​រាម់​មអាក នអ៝ប់​មា​មព្រឹត​មា​មព្រើ នអ៝ប់​មា​គ៝ស​គ៝ង​គ៝ស​គ៝រ់ គ៝ស​គ៝ង​រេង​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ម៝ស​បែ​មោ​អ៝ន់​គ៝ប់​ចុម​គ៝ប់​នតិញ​ក៝ន​ឆៅ​គ៝ប់? បែ​ជាន​កើត​នៃ​ជេង​រាលូក​ម៝ល់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","គ៝ប់​គែស​នាវ​ទើយ​លើស​ខាន់​បែ យើន​មា​កោរាញ​ឞ្រាស​អី​ឞឹ​បែ​យើក​មឞាស​លែៈ​ពាង់​ឞ្វៃ​គ៝ប់​អា​មាង់​នើស ពាង់​លាស៖ «មៃ​ញជ្រាង់​ហ៝ៈ មៃ​លើយ​អោស​ទាស​មា​ងើយ​មា​យាកោប ឞ៝ល​លាស​នាវ​អ្វែស មោ​លាស​នាវ​អ្យើស»។ ");
INSERT INTO cmok_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","អាបៃ​អ្យា​លាស​បែ​ញច្វាត់​យ៝រ​មា​មោ​អ្យាង់​ឞឹ​មោ​ច្រាវ​វាៈ លាស​នទ្រី​ម៝ស​ទឹង​បែ​នតុង​នអ៝ប់​មា​រូប​ឞ្រាស​គ៝ប់?” ");
INSERT INTO cmok_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","យាកោប​អើស​មា​លាបាន៖ “ទឹង​គ៝ប់​ជាន​កើត​នអា យ៝រ​លាស​គ៝ប់​ក្លាច​បែ​ឆ៝ៈ​ពីត​អ៝ស​ក៝ន​បែ​នើម​តាៈ​ឞើស​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ល៝ង់​រូប​ឞ្រាស​បែ​រី លាស​បែ​ឆៃ​តា​ឞូ​ម៝ស អ្យាត់​មា​ងខឹត​ឞូនុយ្ស​អី​នៃ។ បែ​ញឆើរ​ជ៝យ​អាប់​ឞូនុយ្ស​តា​នាប់​ឞាល់​មពោល​បែ​នៃ​ទោ លាស​ឆៃ​គែស​នទើ​បែ បែ​ឆ៝ៈ​ឆឹត​ទោ”។ យើន​មា​យាកោប​មោ​អោស​គឹត​លាស​លែៈ​រាចែល​ទែ​ញអោត​នតុង​រូប​ឞ្រាស​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ជេសរី​លាបាន​លាប់​តា​ចូន​យាកោប លាប់​តា​ចូន​លេអា នទ្រែល​មា​លាប់​តា​ចូន​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មា​លេអារាចែល ជ៝យ​នទើ​នៃ​មោ​ឆៃ​អោស។ លាបាន​លោស​ឞើស​ចូន​លេអា​រី លាប់​តា​ចូន​រាចែល។ ");
INSERT INTO cmok_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","រាចែល​ឆ៝ៈ​ទឹង​លែៈ​រូប​ឞ្រាស​អី​នៃ ពាង់​ពោន​តា​ទុរ​ឆែស​ឆាមោ​រី ជេសរី​ពាង់​នើម​គុ​ឞើស​លើ។ លាបាន​ជ៝យ​លាម​ចូន​នៃ ជ៝យ​មោ​អោស​ឆៃ​នទើ។ ");
INSERT INTO cmok_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","រាចែល​មឞើស​មា​ឞឹ​ពាង់៖ “លើយ​តា​ឞឹ​ក្លាប់​នទាង់​មា​គ៝ប់ គ៝ប់​មោ​ទ៝ក់​តា​នាប់​មៃ គ៝ប់​មោ​ទើយ​ទ៝ក់ យ៝រ​លាស​គ៝ប់​មោ​អ្វែស​ឆាក់”។ កើត​នទ្រី​ពាង់​ជ៝យ​រូប​ឞ្រាស​អី​នៃ យើន​មា​មោ​អោស​ឆៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","យាកោប​ជី​នូយ្ស​ងាន់ ពាង់​លាស​លាបាន៖ “ម៝ស​ទោយ្ស​គ៝ប់ ម៝ស​នទើ​តីស​តា​គ៝ប់​ទឹង​បែ​តឹង​គ៝ប់​នអ៝ប់​មា​នូយ្ស? ");
INSERT INTO cmok_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ទោល​បែ​ញឆើរ​រាហី​នទើ​គ៝ប់ ម៝ស​បាៈ​បែ​ឆៃ​នទើ​បែ​តា​ផូង​ហេន? ល៝ង់​បែ​ញហើ​អ៝ន់​មា​ឞាល់​មពោល​គ៝ប់​ឆៃ ញហើ​អ៝ន់​មា​ឞាល់​មពោល​បែ​ឆៃ​តា​អ្យា គៃ​មា​អ៝ន់​ផូង​ខាន់​ពាង់​នៃ​ឆើម​ផាត​ទោយ្ស​មា​ឞារ​ហៃ​ឞ៝ន់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","លែៈ ២០ នាម់ គ៝ប់​គុ​នទ្រែល​បែ ទឹង​លែៈ​ឞែ​ឞ្យាប់​មែ នទ្រែល​មា​ឞែ​មែ​បែ មោ​គែស​អោស​ទូ​មល៝ម់​រាលេស​ក៝ន ឞែ​ឞ្យាប់​ងក្វ៝ង់​បែ​ទូ​មល៝ម់​គ៝ប់​មោ​ហ៝ៈ​គែស​ឆា​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","លាស​គែស​មពោមពា​(ឆ្យុម)​ឞ្រី​កាប់​ឆា បែ​ហោម​ដាៈ​គ៝ប់​ត្រ៝ៈ មោ​អោស​អ៝ន់​គ៝ប់​ញអោត​មពោមពា​(ឆ្យុម)​ខឹត​នៃ​នទឹ​អ៝ន់​បែ​មា​ឆៃ​ទើម លាស​គែស​ឞូ​នតុង​នោក​នារ មោ​លាស​នោក​មាង់ បែ​ដាៈ​គ៝ប់​ត្រ៝ៈ​ទាទេ គ៝ប់​ត្រ៝ៈ​អ៝ន់​បែ​មរ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","កើត​នអា​ងាន់​នាវ​គ៝ប់​ញឆ្រោយ្ស នោក​នារ​មា​ទោស​នារ នោក​មាង់​មា​នអីក នទ្រែល​មា​រាងែស​មាង់​គាង់​មាត់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","គ៝ប់​គុ​នទ្រែល​បែ​ជ៝ៈ ២០ នាម់ គ៝ប់​ជាន​ការ​មា​បែ ១៤ នាម់ គៃ​មា​គែស​ឆ៝ៈ​ក៝ន​ឞូ​អូរ​បែ​ឞារ​ហៃ​នៃ ជេសរី​ព្រាវ​នាម់​ជឹត​គៃ​មា​គែស​មពោមពា​(ឆ្យុម)​ផូង។ យើន​មា​នទើ​ងខោម​គ៝ប់​នៃ បេង​មា​ងើយ​មព្លាច់​ជឹត​តឹ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","លាស​មោ​គែស​កោរាញ​ឞ្រាស​អី​ចែ​គ៝ប់​យើក​មឞាស អី​ឞឹ​គ៝ប់​ក្លាច​យើក​នៃ​គុ​នទ្រែល​គ៝ប់ បែ​អ៝ន់​គ៝ប់​ឆឹត​មពាង​តី​ទើម​ងាន់​រ៝។ កោរាញ​ឞ្រាស​លែៈ​ឆៃ​នទើ​ជេរ​តា​គ៝ប់ កើត​នទ្រី​ទឹង​អា​មាង់​នើស​ពាង់​លាស​បែ”។ ");
INSERT INTO cmok_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","លាបាន​លាស​មា​យាកោប៖ “ផូង​ឞូ​អូរ​អ្យា​ក៝ន​គ៝ប់​ទាទេ ទឹង​លែៈ​ផូង​ក៝ន​ឆែ​អ្យា​ឆៅ​គ៝ប់​ទាទេ ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អ្យា​មពោមពា​(ឆ្យុម)​គ៝ប់ នទ្រែល​មា​ទឹង​លែៈ​នទើ​បែ​ឆៃ​តា​អ្យា​នទើ​គ៝ប់​ទាទេ នារ​អ្យា​គ៝ប់​មោ​អោស​ទាន់​ឆ៝ៈ​ក៝ន​ឞូ​អូរ​គ៝ប់ គ៝ប់​មោ​អោស​ទាន់​ឆ៝ៈ​ឆៅ​គ៝ប់​ខាន់​ពាង់​ឞាៈ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","លាស​នទ្រី​នារ​អ្យា​អ៝ន់​ឞ៝ន់​ជាន​នាវ​តឹម​រាង្លាប់​ឞាល់ នអ៝ប់​មា​ជាន​នទើ​មឞេន​អ៝ន់​មា​ហោម​កាស​គឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ជេសរី​យាកោប​ឆ៝ៈ​ទូ​មល៝ម់​លុ ពាង់​រាទ៝ក់​ជាន​ងគ៝ង់​តា​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ពាង់​លាស​មា​ឞាល់​មពោល​ពាង់៖ “ខាន់​អៃ​មៃ​ឞូន​លុ​ហ៝ម់”។ ខាន់​ពាង់​ទោញ​លុ​ឞូន​រាទុល ជេសរី​លែវ​ឞាល់​គុ​ឆោង​តា​មែង​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","លាបាន​ក្វាល់​នតុក​នៃ​រាញា៖ «យេការ-ឆាហាដូថា» យើន​មា​យាកោប​ក្វាល់​នតុក​នៃ​រាញា៖ «កាលេត»។ ");
INSERT INTO cmok_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ជេសរី​លាបាន​លាស៖ “នារ​អ្យា​ឞ៝ន់​ឆ៝ៈ​លុ​អ្យា​ជាន​នទើ​មឞេន​បែ​នទ្រែល​គ៝ប់”។ កើត​នទ្រី​ទឹង​ឞូ​ក្វាល់​លុ​អី​ឞូន​នៃ​រាញា «កាលេត» គែស​នាវ​ខ្លៃ​លាស​«ឞូន​លុ​នាក់​ឆៃ​នាក់​តាង់»។ ");
INSERT INTO cmok_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","យើន​មា​ឞូ​ក្វាល់ «មីសពា» ដ៝ង់ គែស​នាវ​ខ្លៃ​លាស​«ច្វាញ​ងកើង​មា​នតុក​ញជ្រាង់» យ៝រ​លាស​លាបាន​លាស៖ “ទាន់​ឞ្រាស​យេហោវា​ញជ្រាង់​បែ​នទ្រែល​គ៝ប់ ទោល​ឞ៝ន់​គុ​តឹម​បាស​ងាយ។ ");
INSERT INTO cmok_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","លាស​បែ​ជាន​អ្យើស​មា​ក៝ន​ឞូ​អូរ​គ៝ប់ មោ​លាស​ឆ៝ៈ​អូរ​អេង​នោក​ខាន់​ពាង់​ហោម​រេស ឞ៝ល​លាស​ខាន់​ពាង់​មោ​គែស​នទុល​មពោល​គុ​នទ្រែល​កាដោយ ហោម​គែស​កោរាញ​ឞ្រាស​ដ៝ង់​ឆៃ យ៝រ​លាស​ពាង់​អី​លែៈ​គឹត​ឆៃ​នាវ​ឞ៝ន់​លែៈ​តឹម​រាង្លាប់​តា​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","លាបាន​ងើយ​តៃ​មា​យាកោប៖ “អ្វាញ់​អ្យា​យឹ លុ​ឞូន​អ្យា នទ្រែល​មា​ងគ៝ង់​លុ​អ្យា​លែៈ​គ៝ប់​តេៈ​តា​ងក្លាង​ងគូល​វាស​វាង​បែ​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","លុ​ឞូន​អ្យា នទ្រែល​មា​ងគ៝ង់​លុ​អ្យា​ជេង​នទើ​មឞេន​មា​នាវ​ឞ៝ន់​លែៈ​តឹម​រាង្លាប់​អ៝ន់​មា​ងកាស​តោរ​ឞ៝ន់ គ៝ប់​មោ​អោស​មរា​ហាន់​រាលាវ​ឞើស​ដាស​លុ​អ្យា​គៃ​មា​លើស​បែ បែ​ក៝ៈ​មោ​ដ៝ង់​មរា​ហាន់​រាលាវ​ឞើស​ដាស​លុ​អ្យា​គៃ​មា​លើស​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ទាន់​កោរាញ​ឞ្រាស​អី​អាឞ្រាហាម់ អី​នាហោរ នអ៝ប់​មា​អី​ឞឹ​ខាន់​ពាង់​យើក​មឞាស​នៃ ឆើម​ផាត​ទោយ្ស​អ៝ន់​មា​ឞ៝ន់”។ ជេសរី​យាកោប​ត៝ន​ដ៝ង់ តា​រាញា​កោរាញ​ឞ្រាស​អី​អីឆាក់​អី​ឞឹ​ពាង់​ក្លាច​យើក​រី​ពាង់​ត៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","យាកោប​ញហើរ​នទើ​ជាន​ឞ្រាស​តា​កាលើ​យោក​នៃ ជេសរី​ពាង់​ក្វាល់​ទឹង​លែៈ​ផូង​អី​គុ​តា​នៃ​វាច់​ឆោង​ឆា​នទ្រែល។ ជេស​ឆោង​ជេស​ឆា ខាន់​ពាង់​ឞិច​តា​កាលើ​យោក​នៃ​ទូ​មាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","អើម​អោយ​លាបាន​ទ៝ក់ ពាង់​ចុម​ក៝ន​ចុម​ឆៅ​ពាង់​រី នទ្រែល​មា​អ៝ន់​គែស​ជេង​មា​ផូង​ខាន់​ពាង់។ ជេសរី​ពាង់​ព្លឹ​ឆឹត​តៃ​តា​ឞ្រី​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","យាកោប​ទ៝ក់​ហាន់​ជឹត​នាប់​ជឹត ជេសរី​គែស​ផូង​តោង​ពារ់​កោរាញ​ឞ្រាស​តឹម​ម៝ប់​ដាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ត៝ត់​មា​យាកោប​ឆៃ​ផូង​តោង​ពារ់​នៃ ពាង់​លាស៖ “នតុក​អ្យា​ជេង​នតុក​ផូង​តោង​ពារ់​កោរាញ​ឞ្រាស​គុ​រ៝” ជេសរី​ពាង់​រាញា​នតុក​នៃ៖ «មាហានែម» គែស​នាវ​ខ្លៃ​លាស​«គែស​ឞារ​ផូង​គុ​តា​នៃ»។ ");
INSERT INTO cmok_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","យាកោប​ដាៈ​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ពាង់​ហាន់​ល៝រ​តឹម​ម៝ប់​ដាស​អេឆាវ​នោ​ពាង់​តា​នតុក​អេដ៝ម់ ឞ្រី​ឆេអីរ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","យាកោប​លាស​មា​មពោល​អី​នៃ៖ “ខាន់​មៃ​មឞើស​កើត​នអា​មា​អេឆាវ​កោរាញ​គ៝ប់​តៃ៖ «យាកោប​អី​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មៃ ពាង់​ដាៈ​ហេន​មឞើស​កើត​នអា៖ «គ៝ប់​មាន​មា​គុ​នទ្រែល​លាបាន​ត៝ត់​នារ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","គ៝ប់​គែស​នទ្រោក គែស​ឆែស​លៀ គែស​ឞែ​ឞ្យាប់ គែស​ឞែ នទ្រែល​មា​គែស​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​ឞូ​អូរ​ឞូ​ក្លោ​អ៝ក់​ដ៝ង់។ អាបៃ​អ្យា​គ៝ប់​ដាៈ​ឞូ​ហាន់​មឞើស​មា​មៃ​អី​កោរាញ​គ៝ប់ គៃ​មា​មៃ​យោៈ​គ៝ប់»”។ ");
INSERT INTO cmok_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ជេសរី​មពោល​អី​ពាង់​ដាៈ​ហាន់​នៃ ព្លឹ​ឆឹត​មឞើស​ងក៝ច​មា​យាកោប៖ “លែៈ​ជេស​ហេន​តឹម​ម៝ប់​ដាស​អេឆាវ​នោ​មៃ។ ពាង់​ហាន់​តឹម​ម៝ប់​ដាស​មៃ​ដ៝ង់ នទ្រែល​មា​លែវ​ឞាល់ ៤០០ នុយ្ស​ហាន់​នទ្រែល​ពាង់​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","យាកោប​ក្លាច​រាវៃ​ហោ​ងាន់ ជេសរី​ពាង់​តឹម​ពាៈ​នតុក​គុ​ឞារ​មពោល នទ្រោក ឞែ​ឞ្យាប់ ឞែ នទ្រែល​មា​ឆែស​ឆាមោ​ពាង់​តឹម​ពាៈ​ឞារ​មពោល​ដ៝ង់‌ ");
INSERT INTO cmok_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","យ៝រ​លាស​ពាង់​មឹន លាស​អេឆាវ​លើស​ទូ​នតុក ហោម​ទូ​នតុក​ដ៝ង់​ក្លាយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","យាកោប​មឞើស​ឆើម​មា​កោរាញ​ឞ្រាស៖ “អើ​កោរាញ​ឞ្រាស​អី​អាឞ្រាហាម់ ​ចែ​គ៝ប់​យើក​មឞាស អី​អីឆាក់​ឞឹ​គ៝ប់​យើក​មឞាស អើ​ឞ្រាស​យេហោវាមៃ​លែៈ​លាស​ជេស​មា​គ៝ប់៖ «ហាន់​មៃ​ព្លឹ​ឆឹត​ហ៝ម់​តា​ឞ្រី​ចែ​មៃ​នើម តា​នទុល​មពោល​មៃ​នើម​រី គ៝ប់​មរា​ជាន​នទើ​អ្វែស​មា​មៃ»។ ");
INSERT INTO cmok_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","គ៝ប់​អ្យា​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មៃ​ទើម មោ​ទី​មៃ​រ៝ង់​មា​គ៝ប់​រាប់​ជាប់ នទ្រែល​មា​គុ​តា​គ៝ប់​រាប់​ជាប់​ត៝ត់​ទាស​អ្យា​អីរ​មា​គ៝ប់។ យ៝រ​លាស​ទោល​គ៝ប់​ហាន់​គ្លាត់​ទាក​រាលាយ​យោរដាន់​អ្យា គ៝ប់​គែស​ទូ​មល៝ម់​ម៝ង់​ជ្រា​ទើម យើន​មា​អាបៃ​អ្យា​គ៝ប់​លែៈ​ជេង​ឞារ​មពោល​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ទាន់​មៃ​កើល​គ៝ប់ អ៝ន់​គ៝ប់​ក្លាយ្ស​ឞើស​តី​អេឆាវ​នោ​គ៝ប់ យ៝រ​លាស​គ៝ប់​ក្លាច​ពាង់​ត៝ត់​តា​អ្យា ពាង់​ងខឹត​ញហាង​រានាក់​វ៝ល់​គ៝ប់ នអ៝ប់​មា​ឞូ​អូរ​ក៝ន​ឆែ។ ");
INSERT INTO cmok_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","យើន​មា​មៃ​លែៈ​លាស​ជេស​មា​គ៝ប់៖ «តៃ​គ៝ប់​អ៝ន់​នាវ​អ្វែស​មអាក​ដាប់​មពាន់​មា​មៃ តៃ​គ៝ប់​ជាន​រាន៝យ​ទែស​មៃ​អ៝ន់​ឞឹក​រឹ​អ៝ក់​តឹម​ឞាន​មា​ច៝យ្ស​រ៝ៈ​ទាក​វាច់​ទាក​វារ់ មោ​ហោម​ឞ្លាវ​កើប»”។ ");
INSERT INTO cmok_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","មាង់​នៃ​ពាង់​ឞិច​តា​នតុក​នៃ។ ពាង់​ឆ៝ៈ​ទ្រាប់​នទើ​ពាង់​គែស​បាៈ មា​អ៝ន់​អេឆាវ​នោ​ពាង់​រី‌ ");
INSERT INTO cmok_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","គែស​ឞែ​មែ ២០០ ឞែ​ងក្វ៝ង់ ២០ ឞែ​ឞ្យាប់​មែ ២០០ ឞែ​ឞ្យាប់​ងក្វ៝ង់ ២០ ");
INSERT INTO cmok_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ឆែស​ឆាមោ​នអ៝ប់​មា​ហោម​ក៝ន​ពូ​ត៝ស ៣០ នទ្រោក​មែ ៤០ នទ្រោក​ងក្វ៝ង់ ១០ ឆែស​លៀ​មែ ២០ នទ្រែល​មា​ឆែស​លៀ​ងក្វ៝ង់ ១០។ ");
INSERT INTO cmok_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ពាង់​អ៝ន់​ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អី​នៃ​មា​ផូង​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មា​ពាង់​រី តឹង​ផូង​តឹង​ផូង​អេងៗ ជេសរី​ពាង់​លាស​មា​មពោល​ឆើម​កើល​ជាន​ការ​មា​ពាង់​នៃ៖ “ខាន់​មៃ​ហាន់​ល៝រ លែវ​មពោមពា​(ឆ្យុម)​អ្យា​អ៝ន់​តឹម​បាស​តឹង​ផូង​តឹង​ផូង គ៝ប់​ហាន់​ឞើស​កើយ”។ ");
INSERT INTO cmok_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","យាកោប​នតិញ​មា​ផូង​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មា​ពាង់​នៃ ពាង់​លាស៖ “លាស​អេឆាវ​នោ​គ៝ប់​ម៝ប់​ខាន់​មៃ​តៃ លាស​ពាង់​អោប៖ «ឞូ​ម៝ស​កោរាញ​មៃ? អាស​នតុក​ឞ្រោៈ​នតុក​ហាន់​មៃ? មពោមពា​(ឆ្យុម)​ផូង​ហាន់​ឞើស​នាប់​មៃ​នៃ​ឞ្រែ​ម៝ស?» ");
INSERT INTO cmok_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","អ៝ន់​ខាន់​មៃ​លាស​មា​ពាង់​កើត​នអា៖ «ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អ្យា មពោមពា​(ឆ្យុម)​យាកោប​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មា​មៃ​នើម ពាង់​អ៝ន់​ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​អ្យា​មា​មៃ កោរាញ។ ពាង់​នើម​ហោម​អែ​ឞ្រោៈ​ឞើស​កើយ​ហេន​រី»”។ ");
INSERT INTO cmok_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","យាកោប​ដាៈ​មា​ទឹង​លែៈ​ឞូនុយ្ស​អី​វែង​ឞើស​កើយ​ឞើស​កើយ​ទឹង​លែៈ​ផូង​មពោមពា​(ឆ្យុម)​នៃ​ពាង់​ដាៈ​កើត​នៃ​ទាទេ។ ពាង់​លាស​មា​ផូង​ខាន់​ពាង់៖ “នោក​ខាន់​មៃ​ម៝ប់​អេឆាវ​រី​តៃ អ៝ន់​ខាន់​មៃ​មឞើស​មា​ពាង់​កើត​នៃ​ទាទេ​យឹ។ ");
INSERT INTO cmok_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ខាន់​មៃ​មឞើស​មា​ពាង់៖ «យាកោប​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មៃ​ហោម​អែ​ឞ្រោៈ​ឞើស​កើយ​គ៝ប់​រ៝»”។ យាកោប​ជាន​កើត​នៃ យ៝រ​លាស​ពាង់​មឹន៖ “ទឹង​លែៈ​នទើ​គ៝ប់​អ៝ន់​ឞូ​លែវ​ញអោត​ល៝រ​មា​អ៝ន់​នោ​គ៝ប់​នៃ គ៝ប់​អុច​ពាង់​ឞាស​ជី​នូយ្ស​មា​គ៝ប់​រ៝។ ជេសរី​ត៝ត់​គ៝ប់​តឹម​ម៝ប់​ដាស​ពាង់​នើម​តៃ ក្លាប់​លាស​ពាង់​រ៝ម​គ៝ប់​មា​នាវ​អ្វែស”។ ");
INSERT INTO cmok_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​ព្រែ​អ៝ន់​នៃ​ឞូ​លែវ​ញអោត​ល៝រ​ទាទេ យាកោប​នើម​រី​ហោម​ឞិច​តា​ចូន​ឞ៝ក​នៃ​ទូ​មាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","តា​មាង់​នៃ​ដ៝ង់ យាកោប​ទ៝ក់​លែវ​លែៈ​អូរ​ពាង់​ឞារ​ហៃ លែៈ​ឞូ​អូរ​អី​ឆើម​កើល​ជាន​ការ​មា​ឞារ​ហៃ​អូរ​ពាង់​នៃ នទ្រែល​មា​ក៝ន​ឞូ​ក្លោ​ពាង់ ១១ នុយ្ស​រី​ហាន់​គ្លាត់​នហ៝ង​ទាក​យាបុក​ព្លាង់​នតុក​ថើល​ឞូ​វៃ​ហាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ជេស​ពាង់​ញជុន​អូរ​ក៝ន​ពាង់​នើម​ត៝ត់​កាល់​តី​ទាក​រី​លែៈ​ផ្យៅ ពាង់​ដាៈ​ឞូ​ហាន់​នតោស​ទ្រាប់​នទើ​ពាង់​នើម​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","យាកោប​ហោម​គុ​ពាង់​ទូ​ហ្វេ​អេង​តា​នៃ។ តា​មាង់​នៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ហាន់​តឹម​ញាត់​ដាស​ពាង់​នហ៝​មា​ត៝ត់​អាង​អោយ។ ");
INSERT INTO cmok_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ត៝ត់​មា​ឞូ​ក្លោ​នៃ​ពាង់​គឹត​លាស ពាង់​មោ​អោស​ទើយ​ដាស​យាកោប ជេសរី​ពាង់​លើស​យាកោប​តា​ព្លាង់​ងគាង​ឞុត។ យាកោប​នហ៝​មា​គ្លែត​រ៝​នោក​ខាន់​ពាង់​តឹម​ញាត់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ឞូ​ក្លោ​នៃ​លាស​មា​ពាង់៖ “បើក​អ៝ន់​គ៝ប់​ឆឹត យ៝រ​លាស​ឞ្រី​លែៈ​អាង”។ យាកោប​អើស៖ “គ៝ប់​មោ​អោស​បើក​មៃ ត៝ត់​មៃ​លែៈ​អ៝ន់​នាវ​គែស​ជេង​មា​គ៝ប់​ប៝ត់​មើ”។ ");
INSERT INTO cmok_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ឞូ​ក្លោ​នៃ​អោប​យាកោប៖ “មៃ​មើម​រាញា?” ពាង់​អើស៖ “គ៝ប់​រាញា​យាកោប”។ ");
INSERT INTO cmok_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ឞូ​ក្លោ​នៃ​លាស​តៃ៖ “មៃ​មោ​ហោម​អោស​នតើ​យាកោប​ជឹត មៃ​នតើ​អីឆ្រាអែល យ៝រ​លាស​មៃ​តឹម​ញាត់​ដាស​កោរាញ​ឞ្រាស តឹម​ញាត់​ដាស​ឞូនុយ្ស​ដ៝ង់ លែៈ​ទើយ​មៃ”។ «អីឆ្រាអែល» គែស​នាវ​ខ្លៃ​លាស​«ពាង់​តឹម​ញាត់​ដាស​ឞ្រាស»។ ");
INSERT INTO cmok_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","យាកោប​អោប​ឞូ​ក្លោ​នៃ៖ “ទាន់​មៃ​មឞើស​រាញា​មៃ​អ៝ន់​គ៝ប់​គឹត”។ ឞូ​ក្លោ​នៃ​លាស​មា​ពាង់៖ “ម៝ស​មៃ​អោប​អុច​គឹត​រាញា​គ៝ប់?” ជេសរី​ពាង់​អ៝ន់​គែស​ជេង​មា​យាកោប​តា​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","យាកោប​តេៈ​រាញា​នតុក​នៃ «ពេនីអែល» គែស​នាវ​ខ្លៃ​លាស​«មុស​មាត់​ឞ្រាស» យ៝រ​លាស​ពាង់​លាស៖ “គ៝ប់​លែៈ​ឆៃ​មា​មាត់​ងាន់​មុស​មាត់​កោរាញ​ឞ្រាស យើន​មា​ឆាក់​គ៝ប់​នើម​ហោម​អែ​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","នារ​លែៈ​លោស យាកោប​លោស​ហាន់​ឞើស​នតុក​ពេនូអែល​នៃ។ ពាង់​ហាន់​ដឹល​នទឹត​ដឹល​នទឹត យ៝រ​លាស​ងគាង​ឞុត​ពាង់​គ្លែត។ ");
INSERT INTO cmok_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","កើត​នទ្រី​ទឹង​ផូង​ក៝ន​ឆៅ​អីឆ្រាអែល​ត៝ត់​អាបៃ​អ្យា ខាន់​ពាង់​មោ​អោស​ឆា​ព្វាច់​មលៃ​តា​ងគាង​ឞុត យ៝រ​លាស​លែៈ​កោរាញ​ឞ្រាស​លើស​យាកោប​តា​ព្លាង់​ងគាង​ឞុត។ ");
INSERT INTO cmok_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ជេសរី​យាកោប​ងគើរ​មាត់​អ្វាញ់ ឆៃ​អេឆាវ​ហាន់ នអ៝ប់​មា​គែស​ឞាល់​ពាង់ ៤០០ នុយ្ស​ហាន់​នទ្រែល​ពាង់​ដ៝ង់ ជេសរី​យាកោប​តឹម​ពាៈ​ក៝ន​អ៝ន់​មា​លេអា អ៝ន់​មា​រាចែល នទ្រែល​មា​អ៝ន់​មា​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​ឞារ​ហៃ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","យាកោប​អ៝ន់​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​ឞារ​ហៃ​នៃ នទ្រែល​មា​ទឹង​លែៈ​ក៝ន​ខាន់​ពាង់​ហាន់​ល៝រ ជេសរី​លេអា នទ្រែល​មា​ទឹង​លែៈ​ក៝ន​ពាង់ ងគ្លែៈ​ទុត​ឞូ​រី​ពាង់​អ៝ន់​រាចែល​នទ្រែល​មា​យោឆែប​ហាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","យាកោប​នើម​រី​ពាង់​ហាន់​ឞើស​នាប់​ផូង​នៃ ពាង់​ហាន់​ពាន់​មឞាស​អា​នែស​ឆូ​ពើស​តឹ នហ៝​មា​ត៝ត់​ទាច់​អេឆាវ​នោ​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","អេឆាវ​ញច្វាត់​រាន​ពាង់ អូត​ពាង់ អូត​តា​ត៝ង​ក៝​ពាង់ ចុម​ពាង់ ជេសរី​ញុម​លែៈ​ឞារ​ហៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","អេឆាវ​អ្វាញ់​ឆៃ​ផូង​ឞូ​អូរ នទ្រែល​មា​ផូង​ក៝ន​ឆែ ពាង់​អោប៖ “ឞូ​ម៝ស​ផូង​គុ​នទ្រែល​មៃ​អ្យា?” យាកោប​អើស៖ “អ្យា​ក៝ន កោរាញ​ឞ្រាស​ទែ​អ៝ន់​មា​គ៝ប់​តាៈ​ឞើស​នាវ​អ្វែស​ពាង់នើម”។ ");
INSERT INTO cmok_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ជេសរី​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​មា​ឞារ​ហៃ​អូរ​ពាង់​រី នទ្រែល​មា​ទឹង​លែៈ​ក៝ន​ខាន់​ពាង់​ហាន់​ពាន់​មឞាស​អេឆាវ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ជេស​នៃ​លេអា​នទ្រែល​មា​ទឹង​លែៈ​ក៝ន​ពាង់​ហាន់​ពាន់​មឞាស ងគ្លែៈ​ទុត​ឞើស​កើយ​យោឆែប នទ្រែល​មា​រាចែល​ហាន់​ពាន់​មឞាស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ជេសរី​អេឆាវ​អោប​យាកោប៖ “ម៝ស​ជាន​នទើ​មៃ​អី​អ៝ន់​ឞូ​លែវ​ម៝ប់​គ៝ប់​នទើស​នើស?” យាកោប​អើស៖ “គ៝ប់​លែវ​មា​ញជុន​អ៝ន់​មៃ​នោ គៃ​មា​នោ​យោៈ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","អេឆាវ​លាស​មា​ពាង់៖ “អើ​អ៝ស គ៝ប់​ឞែ​លែៈ​គែស​អ៝ក់​ងាន់ មៃ​ឆ៝ៈ​នទើ​មៃ​នៃ​ព្រាប់​អ៝ន់​មា​មៃ​នើម​ទោ”។ ");
INSERT INTO cmok_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","យាកោប​អើស៖ “មោ​អោស​នទ្រី​នោ លាស​មៃ​យោៈ​គ៝ប់​ងាន់ មៃ​ទើន​នទើ​គ៝ប់​ញជុន​អ៝ន់​មា​មៃ​នៃ​ទោ។ ទោល​គ៝ប់​ឆៃ​មុស​មាត់​មៃ​តឹម​ឞាន​មា​ឆៃ​មុស​មាត់​កោរាញ​ឞ្រាស​ដ៝ង់ យ៝រ​លាស​លែៈ​មៃ​រ៝ម​គ៝ប់​មា​នាវ​អ្វែស​ដាប់​មពាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","លាស​នទ្រី​ទាន់​មៃ​ឆ៝ៈ​ទើន​ហ៝ម់​នទើ​គ៝ប់​ញជុន​អ៝ន់​មៃ​នៃ យ៝រ​លាស​លែៈ​កោរាញ​ឞ្រាស​អ៝ន់​គែស​ជេង​មា​គ៝ប់ អ៝ន់​គ៝ប់​គែស​ទ្រាប់​នទើ​អ៝ក់​រាមែស”។ ជេសរី​អេឆាវ​ឆ៝ៈ​ទើន​នទើ​នៃ យ៝រ​មា​យាកោប​ញច៝ប់​ពាង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","អេឆាវ​លាស៖ “ហោៈ ហាន់​ហ៝ម់​ឞ៝ន់ គ៝ប់​ហាន់​នទ្រែល​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","យាកោប​លាស​មា​ពាង់៖ “អើ​នោ មៃ​លែៈ​គឹត ឞ៝ន់​ឞ្រោៈ​ត្រ៝ង​ហាន់​នទ្រែល​ក៝ន​ឆែ​អ៝ស​ឞេ​មោ​គែស​អោស​អ្វែស គ៝ប់​គែស​ឞែ​ឞ្យាប់ គែស​ឞែ នទ្រែល​មា​គែស​នទ្រោក​ហោម​អែ​ក៝ន​ពូ​ត៝ស។ លាស​ឞ៝ន់​ញច៝ប់​អ៝ន់​ហាន់​ងាយ​អីរ​តា​ទូ​នារ ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​នៃ​ខឹត​លែៈ​ផ្យៅ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","លាស​នទ្រី​មៃ​ហាន់​ល៝រ​គ៝ប់​អី​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មា​មៃ​ទោស​នោ គ៝ប់​មា​ហាន់​មព្លេមៗ​ផូង​ក៝ន​ឆែ នទ្រែល​មា​មពោមពា​(ឆ្យុម) នហ៝​មា​ត៝ត់​គ៝ប់​តឹម​ម៝ប់​ដាស​មៃ​តា​ឞ្រី​ឆេអីរ​រី”។ ");
INSERT INTO cmok_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","អេឆាវ​លាស​មា​យាកោប៖ “លាស​នទ្រី​គ៝ប់​អ៝ន់​ឞាល់​គ៝ប់​ហាន់​នទ្រែល​មៃ​បាៈ​ទោស”។ យាកោប​អើស៖ “មោ​ច្រាវ​អោស​នោ មៃ​លែៈ​យោៈ​មា​គ៝ប់​កើត​នៃ​លែៈ​គាប់​ជេស”។ ");
INSERT INTO cmok_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ជេសរី​អេឆាវ​ព្លឹ​ឆឹត​តា​ឞ្រី​ឆេអីរ​រី​នារ​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","យើន​មា​យាកោប​មោ​អោស​ហាន់​តា​ឞ្រី​ឆេអីរ ពាង់​ហាន់​ត៝ត់​តា​ប៝ន​ឆូកោត​ច្រាវ។ ពាង់​ជាន​ទូ​មល៝ម់​ជៃ​មា​គុ​ពាង់​នើម នទ្រែល​មា​រាទ៝ក់​ងកឺប​មា​អ៝ន់​មពោមពា​(ឆ្យុម)​ពាង់​នើម​ដ៝ង់។ កើត​នទ្រី​ទឹង​ឞូ​ក្វាល់​នតុក​នៃ «ឆូកោត» គែស​នាវ​ខ្លៃ​លាស​«ចូន»។ ");
INSERT INTO cmok_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ឞើស​កើយ​យាកោប​ឆឹត​ឞើស​ឞ្រី​ពាដាន-អារាម​នៃ ពាង់​ហាន់​តា​ប៝ន​ឆីកែម​ឞ្រី​កានាន​មា​នាវ​ដាប់​មពាន់ ជេសរី​ពាង់​រាទ៝ក់​ចូន​ឞ៝ក​តឹម​ទាច់​មា​ប៝ន​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","នែស​នតុក​ពាង់​ជាន​ចូន​ឞ៝ក​នៃ ពាង់​រាវាត់​តាៈ​ឞើស​ផូង​អ៝ស​ក៝ន​ហាម៝រ​អី​ឞឹ​ឆីកែម ខ្លៃ ១០០ កាក់​ព្រាក់។ ");
INSERT INTO cmok_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ជេសរី​ពាង់​ជាន​ទូ​នតុក​មា​ជាន​ឞ្រាស​តា​នតុក​នៃ ពាង់​តេៈ​រាញា «អែលអែលោហេអីឆ្រាអែល» គែស​នាវ​ខ្លៃ​លាស​«កោរាញ​ឞ្រាស​ជេង​ឞ្រាស​អីឆ្រាអែល​យើក​មឞាស»។ ");
INSERT INTO cmok_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ដីនា​អី​ក៝ន​លេអា​ឞាៈ​អ៝ន់​មា​យាកោប​នៃ​នើស ពាង់​ហាន់​ខ៝ល់​ផូង​ឞូ​អូរ​តា​ឞ្រី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ទោល​នៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​រាញា​ឆីកែម​អី​ឞឹ​ពាង់​រាញា​ហាម៝រ​ផូង​ហីវី ជេង​កោរាញ​តា​ឞ្រី​នៃ ឆីកែម​ឆៃ​ដីនា ញុប​ត៝ម​គែស​អោឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ពាង់​ទី​មាត់​ងាន់​មា​ដីនា​ក៝ន​យាកោប​រី ពាង់​រ៝ង់​ហោ​ងាន់​មា​ឞូ​អូរ​នៃ មឞើស​ងើយ​អ្វែសៗ​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ឆីកែម​លាស​មា​ហាម៝រ​អី​ឞឹ​ពាង់​នៃ៖ “អើ​ឞឹ ដាៈ​មៃ​អោប​វាង់​ឞូ​អូរ​នៃ គ៝ប់​អុច​ឆ៝ៈ​ពាង់​ជេង​អូរ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","យាកោប​លែៈ​គឹត​ជេស​ឆីកែម​លើស​អ្យើស​មា​ក៝ន​ឞូ​អូរ​ពាង់​រី យើន​មា​ពាង់​គុ​អ្យាត់​ឆាក់​រាក្លាក់​ទើម យ៝រ​លាស​ទឹង​លែៈ​ក៝ន​ឞូ​ក្លោ​ពាង់​ហោម​គុ​ច្យាប់​អា​ជា​រី​ទាទេ ពាង់​ក៝ប់​ត៝ត់​ខាន់​ពាង់​ឆឹត​ឞើស​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","យើន​មា​ហាម៝រ​អី​ឞឹ​ឆីកែម​រី ហាន់​តឹម​ម៝ប់​ដាស​យាកោប គៃ​មា​តឹម​ងើយ​នទ្រែល​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ត៝ត់​មា​ផូង​ក៝ន​យាកោប​ឆឹត​តាៈ​ឞើស​ច្យាប់​រី ខាន់​ពាង់​តាង់​នាវ​នៃ ខាន់​ពាង់​ទោស​នូយ្ស​ហោ​ងាន់​រ៝ ខាន់​ពាង់​ជី​នូយ្ស​ទុត​ហោ​មា​ឆីកែម​យ៝រ​មា​នទើ​ពាង់​លែៈ​ជាន​ទុត​បឹ​តា​រានាក់​វ៝ល់​យាកោប នាវ​ពាង់​ញុប​ត៝ម​ក៝ន​ឞូ​អូរ​យាកោប យ៝រ​លាស​នទើ​នៃ​ឞូ​មោ​អោស​ទី​មា​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ហាម៝រ​ងើយ​មា​យាកោប នទ្រែល​មា​លែៈ​ក៝ន​ឞូ​ក្លោ​ពាង់៖ “ឆីកែម​ក៝ន​គ៝ប់ ពាង់​លែៈ​ទី​មាត់​ងាន់​មា​ក៝ន​ឞូ​អូរ​មៃ​នៃ គ៝ប់​ទាន់​ខាន់​មៃ​អ៝ន់​ឞូ​អូរ​នៃ​ដាស​ពាង់ ព្រែ​មា​ឆ៝ៈ​ជេង​អូរ។ ");
INSERT INTO cmok_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","អ៝ន់​ខាន់​មៃ​តឹម​រាង្លាប់​ដាស​ហេន​ទោ អ៝ន់​ក៝ន​ឞូ​អូរ​ខាន់​មៃ​តឹម​នអាប់​ដាស​ហេន ជេសរី​ហេន​ព្លើង​អ៝ន់​ក៝ន​ឞូ​អូរ​ហេន​តឹម​នអាប់​ដាស​ខាន់​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","អ៝ន់​ខាន់​មៃ​គុ​នទ្រែល​ហេន​តា​អ្យា ឞ្រី​ហេន​ឆ៝យ្ស​មា​អ៝ន់​ខាន់​មៃ ខាន់​មៃ​គុ​ទោ​តា​ឞ្រី​អ្យា តាច់​រាគ៝ល់​ទ្រាប់​នទើ រាវាត់​នែស​មា​គែស​នតុក​ខាន់​មៃ​នើម​គុ”។ ");
INSERT INTO cmok_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ជេសរី​ឆីកែម​ងើយ​មា​យាកោប នទ្រែល​មា​អី​នោៗ​ដីនា​រី​ដ៝ង់ ពាង់​លាស៖ “ទាន់​ខាន់​មៃ​យោៈ​មា​គ៝ប់ ម៝ស​នទើ​ខាន់​មៃ​កែស គ៝ប់​អ៝ន់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","អ៝ន់​ខាន់​មៃ​កែស​នទើ​ខ្លៃ​ឞើស​គ៝ប់ មោ​លាស​កែស​ទ្រាប់​នទើ​ទុត​អ៝ក់​កាដោយ ម៝ស​នទើ​ខាន់​មៃ​កែស​ឞើស​នៃ​គ៝ប់​អ៝ន់​ទាទេ អ្យាត់​មា​ខាន់​មៃ​អ៝ន់​អ៝ស​ឞូ​អូរ​ខាន់​មៃ​នៃ​មា​ជេង​អូរ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ជេសរី​ផូង​ក៝ន​យាកោប​ព្លើង​អើស​នាវ​ឆីកែម នទ្រែល​មា​នាវ​ហាម៝រ​អី​ឞឹ​រី ខាន់​ពាង់​អុច​នទើម យ៝រ​លាស​ឆីកែម​លែៈ​ជាន​អ្យើស​មា​ដីនា​អ៝ស​ខាន់​ពាង់​នៃ ខាន់​ពាង់​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“មោ​ទើយ​អោស​ហេន​អ៝ន់​អ៝ស​ហេន​មា​ផូង​ឞូ​ក្លោ​មោ​គែស​ក៝ស​នតោ។ លាស​ហេន​ជាន​កើត​នអា ហេន​ដីត​ព្រេង​ទុត​ហោ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","លាស​ខាន់​មៃ​អុច​ក៝ស​នតោ​កើត​ហេន ទឹង​លែៈ​ផូង​ឞូ​ក្លោ​តា​ផូង​ខាន់​មៃ​អ៝ន់​ក៝ស​នតោ​ទាទេ​ដ៝ង់ រី​មើ​ហេន​ឆ៝ៈ​ទើន​នាវ​ខាន់​មៃ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ទឹង​ហេន​អ៝ន់​ក៝ន​ឞូ​អូរ​ហេន​មា​ខាន់​មៃ តៃ​ហេន​ព្លើង​ឆ៝ៈ​ក៝ន​ឞូ​អូរ​ខាន់​មៃ​ដ៝ង់ ទឹង​ហេន​គុ​នទ្រែល​មា​ខាន់​មៃ ជេសរី​ឞ៝ន់​នហ៝​មា​ជេង​ទូ​ផូង​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","យើន​មា​លាស​ខាន់​មៃ​មោ​អុច​ក៝ស​នតោ​កើត​ហេន ហេន​ឆ៝ៈ​លើយ​អ៝ស​ឞូ​អូរ​ហេន ជេសរី​ទូ​ឞើស​នតុក​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","នាវ​ងើយ​នៃ​ទី​នូយ្ស​ក្លឺៈ​ងាន់​មា​ហាម៝រ នទ្រែល​មា​ឆីកែម​ក៝ន​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ឆីកែម​មោ​ហោម​អោស​រ៝ង​ក៝ប់​ជ៝ៈ​ដ៝ង់​ជាន​នាវ​នៃ យ៝រ​លាស​ពាង់​រ៝ង់​ហោ​ងាន់​មា​ក៝ន​ឞូ​អូរ​យាកោប។ តា​រានាក់​វ៝ល់​ហាម៝រ​រី​ឞូ​យើក​ឆីកែម​រាលាវ​ឞូ។ ");
INSERT INTO cmok_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ជេសរី​ហាម៝រ នទ្រែល​មា​ឆីកែម​ក៝ន​ពាង់​ហាន់​ត៝ត់​តា​មពោង​មពេរ​ប៝ន​ខាន់​ពាង់​នើម លាស​មា​ផូង​ឞូ​ក្លោ​តា​ប៝ន​នៃ៖ ");
INSERT INTO cmok_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ផូង​ខាន់​ពាង់​នៃ​អុច​គុ​ដាប់​មពាន់​នទ្រែល​ឞ៝ន់ លាស​នទ្រី​រ៝ម​ខាន់​ពាង់ អ៝ន់​ខាន់​ពាង់​គុ​តា​ឞ្រី​អ្យា​តាច់​រាគ៝ល់​ទ្រាប់​នទើ​នទ្រែល​ឞ៝ន់​ទោ យ៝រ​លាស​នែស​ឞ៝ន់​ហ្វី​ដ៝ង់ ត៝ង់​មា​រ៝ម​អ៝ន់​ខាន់​ពាង់​គុ។ អ៝ន់​ឞ៝ន់​ឆ៝ៈ​ក៝ន​ឞូ​អូរ​ខាន់​ពាង់​មា​ជេង​អូរ ជេសរី​អ៝ន់​ក៝ន​ឞូ​អូរ​ឞ៝ន់​មា​ខាន់​ពាង់​មា​ជេង​អូរ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","យើន​មា​ទឹង​ខាន់​ពាង់​អុច​គុ​នទ្រែល​ឞ៝ន់ គៃ​មា​ជេង​ទូ​ផូង អ៝ន់​ទឹង​លែៈ​ផូង​ឞូ​ក្លោ​តា​ផូង​ឞ៝ន់​ក៝ស​នតោ​អ៝ន់​កើត​ខាន់​ពាង់​ដ៝ង់​មើ។ ");
INSERT INTO cmok_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","លាស​ឞ៝ន់​ជាន​កើត​នៃ ទឹង​លែៈ​ទ្រាប់​នទើ​ខាន់​ពាង់ នទ្រែល​មា​មពោមពា​(ឆ្យុម)​ខាន់​ពាង់​ជេង​ទ្រាប់​នទើ​ឞ៝ន់​ទាទេ​រ៝។ ហោៈ អ៝ន់​ឞ៝ន់​ជាន​កើត​នាវ​ខាន់​ពាង់​ទាន់ អ៝ន់​ខាន់​ពាង់​គុ​នទ្រែល​ឞ៝ន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ទឹង​លែៈ​ឞូ​ក្លោ​តា​ប៝ន​នៃ ខាន់​ពាង់​អ្យាត់​នាវ​ហាម៝រ នទ្រែល​មា​ឆីកែម​ក៝ន​ពាង់​រី ជេសរី​ទឹង​លែៈ​ផូង​ឞូ​ក្លោ​តា​ប៝ន​អី​នៃ​ក៝ស​នតោ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ត៝ត់​ពែ​នារ​រី ទឹង​លែៈ​ឞូ​ក្លោ​តា​ប៝ន​នៃ​ហោម​ជី​ទាទេ ជេសរី​ក៝ន​យាកោប​ឞារ​ហៃ ឆីមោន នទ្រែល​មា​លេវី​អី​នោ​ទូ​មែ​ឞាៈ​មា​ដីនា​រី ខាន់​ពាង់​ញអោត​ដាវ​ហាន់​លាប់​តា​ត្រោម​ប៝ន​នៃ ឆ្រែស​ទឹង​លែៈ​ផូង​ឞូ​ក្លោ​តា​ប៝ន​នៃ​លែៈ​ផ្យៅ មោ​គែស​អោស​ទូ​ហ្វេ​មា​តឹម​រាទ៝ង់​ដាស​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ខាន់​ពាង់​ងខឹត​ហាម៝រ នទ្រែល​មា​ឆីកែម​ក៝ន​ពាង់​រី​មា​ដាវ ជេសរី​ឆ៝ៈ​ដីនា​លោស​ឞើស​ជៃ​ឆីកេម​នៃ ឆឹត​តា​នតុក​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ទឹង​លែៈ​ក៝ន​ឞូ​ក្លោ​យាកោប​អាបាៈ​អេង ខាន់​ពាង់​ហាន់​ត៝ត់​តា​ផូង​ឞូនុយ្ស​ខឹត​រី ជេសរី​លាប់​ឆ៝ៈ​គ្រ៝​ទ្រាប់​នទើ​តា​ប៝ន​នៃ​ញច្វាន់​លែៈ​ផ្យៅ យ៝រ​លាស​ឞូនុយ្ស​តា​ប៝ន​នៃ​លែៈ​ជាន​អ្យើស​អ៝ន់​មា​ដីនា។ ");
INSERT INTO cmok_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ខាន់​ពាង់​ឆ៝ៈ​លែៈ​ឞែ​ឞ្យាប់ ឆ៝ៈ​លែៈ​ឞែ ឆ៝ៈ​លែៈ​នទ្រោក ឆ៝ៈ​លែៈ​ឆែស​លៀ​តា​ប៝ន នអ៝ប់​មា​តា​មីរ។ ");
INSERT INTO cmok_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ខាន់​ពាង់​ឆ៝ៈ​ញច្វាន់​លែៈ​ផ្យៅ​ទ្រាប់​នទើ​ឞូនុយ្ស​តា​ប៝ន​នៃ ញុប​អូរ​ញុប​ក៝ន​ដ៝ង់ នទ្រែល​មា​ទឹង​លែៈ​ទ្រាប់​នទើ​តា​ញីស​ជៃ​ខាន់​ពាង់​ឆ៝ៈ​រាគូម​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ជេសរី​យាកោប​លាស​មា​ឆីមោន នទ្រែល​មា​លេវី​ក៝ន​ពាង់​រី៖ “ខាន់​មៃ​ជាន​អ៝ន់​គ៝ប់​គែស​នាវ​រាវៃ​ងាន់ ជាន​អ៝ន់​ផូង​កានាន នទ្រែល​មា​ផូង​ពេរិឆីត​តា​ឞ្រី​អ្យា​ឞូ​ជី​ឞ្យាញ់​មា​គ៝ប់។ លាស​ឞូ​រាគូម​ឞាល់​ហាន់​លើស​គ៝ប់ ខាន់​ពាង់​មរា​ងគ្រ៝ស​លើយ​គ៝ប់ នទ្រែល​មា​រានាក់​វ៝ល់​គ៝ប់ យ៝រ​លាស​ឞាល់​គ៝ប់​គែស​ដេៈ​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","យើន​មា​ឞារ​ហៃ​ខាន់​ពាង់​អើស​មា​ពាង់៖ “ហេន​មោ​អុច​អោស​ឞូ​ជាន​មា​អ៝ស​ហេន​តឹម​ឞាន​មា​ទូ​ហ្វេ​ឞូ​អូរ​វាង់​តឹរ”។ ");
INSERT INTO cmok_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ជេសរី​កោរាញ​ឞ្រាស​លាស​មា​យាកោប៖ “មៃ​លោស​ឞើស​នតុក​អ្យា ហាន់​ទូ​តា​ប៝ន​បេតអែល​រី គុ​តា​នតុក​នៃ ជេង​នតុក​គ៝ប់​លែៈ​តឹម​មពើល​មា​មៃ ទោល​មៃ​ទូ​ញច្វាត់​ឞើស​អេឆាវ​នោ​មៃ​នើស។ តា​នតុក​នៃ​អ៝ន់​មៃ​ជាន​នតុក​ជាន​ឞ្រាស​មា​ញហើរ​នទើ​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ជេសរី​យាកោប​លាស​មា​ផូង​រានាក់​វ៝ល់​ពាង់ នទ្រែល​មា​ទឹង​លែៈ​ឞូនុយ្ស​គុ​ដាស​ពាង់៖ “ទឹង​លែៈ​រូប​ឞ្រាស​ផូង​ឞូ​នាច់​តា​ផូង​ខាន់​មៃ អ៝ន់​ខាន់​មៃ​មអារ់​លើយ​អ៝ន់​លែៈ ជេសរី​រាវ​ឆាក់​ខាន់​មៃ​នើម​អ៝ន់​ក្ល៝ស នទ្រែល​មា​តើស​លើយ​ឞ៝ក​អាវ​ខាន់​មៃ​នៃ ញឆ៝ស​ឞ៝ក​អាវ​អី​អ្វែស អី​មោ​អោស​គែស​រាមាវ។ ");
INSERT INTO cmok_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ឞ៝ន់​ហាន់​ទូ​តា​ប៝ន​បេតអែល​រី។ តា​នតុក​នៃ​គ៝ប់​ជាន​នតុក​ជាន​ឞ្រាស​មា​គុច​ពូរ​នទើ​ញហើរ​មា​កោរាញ​ឞ្រាស មា​នើម​លែៈ​កើល​តឹង​នាវ​គ៝ប់​ទាន់​ទោល​គ៝ប់​គែស​នាវ​ជេរ​នើស ជេសរី​អាប់​នតុក​គ៝ប់​ហាន់​ពាង់​គុ​នទ្រែល​គ៝ប់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ជេស​យាកោប​លាស​កើត​នៃ ខាន់​ពាង់​ឆ៝ៈ​ទឹង​លែៈ​រូប​ឞ្រាស​អី​ខាន់​ពាង់​គែស នទ្រែល​មា​ទ្រ៝ស​រាគេន​ឞើស​តោរ​ខាន់​ពាង់​នើម​រី នទឹ​អ៝ន់​មា​យាកោប​លែៈ​ផ្យៅ។ ជេសរី​យាកោប​ឆ៝ៈ​លែៈ​នទើ​នៃ ពាង់​កុយ្ស​នែស​ត៝ប់​តា​ន៝ម់​តើម​ឆី​ក្វ៝ង់​ពោថិ​កេង​ប៝ន​ឆីកែម​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ជេស​ឞើស​នៃ​ខាន់​ពាង់​លែវ​ឞាល់​ហាន់​ទ្រឺម។ ទឹង​លែៈ​ប៝ន​ទាច់ៗ​តា​ប៝ន​នៃ​កោរាញ​ឞ្រាស​ជាន​អ៝ន់​ផូង​ខាន់​ពាង់​ក្លាច​ញឆ៝រ់​ហោ​ងាន់ នហ៝​មា​មោ​អោស​ឞាញ់​ហាន់​តឹង​ផូង​អ៝ស​ក៝ន​យាកោប​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ជេសរី​យាកោប នទ្រែល​មា​ទឹង​លែៈ​ផូង​ហាន់​ដាស​ពាង់​ហាន់​ត៝ត់​តា​ប៝ន​លុស​ឞ្រី​កានាន ជេង​ប៝ន​បេតអែល​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","តា​នតុក​នៃ​យាកោប​ជាន​នតុក​ជាន​ឞ្រាស​អី​នៃ ពាង់​តេៈ​រាញា​នតុក​នៃ «កោរាញ​ឞ្រាស​បេតអែល» យ៝រ​លាស​តា​នតុក​នៃ​កោរាញ​ឞ្រាស​តឹម​មពើល​មា​ពាង់ ទោល​ពាង់​ញច្វាត់​ឞើស​នោ​ពាង់​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","នោក​នៃ​ដេបោរា​ខឹត ពាង់​ជេង​ឞូនុយ្ស​មពូ​ត៝ស​អ៝ន់​មា​រេបេកា​នោក​ហោម​អ៝ស​ឞេ ជេសរី​ឞូ​ត៝ប់​ពាង់​តា​ញជ៝ង់​យោក​បេតអែល តា​ន៝ម់​ទូ​មល៝ម់​តើម​ជ្រី ឞូ​ក្វាល់​លាស «តើម​ជ្រី​ញុម​រាង៝ត»។ ");
INSERT INTO cmok_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","នោក​នៃ​យាកោប​លែៈ​ព្លឹ​ឆឹត​តាៈ​ឞើស​ឞ្រី​ពាដាន-អារាម​រី ជេសរី​កោរាញ​ឞ្រាស​តឹម​មពើល​តៃ​មា​ពាង់​ទូ​តឹ​ជឹត​តា​បេតអែល​នៃ នហ៝​មា​កោរាញ​ឞ្រាស​ទែ​អ៝ន់​គែស​ជេង​មា​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","លាស​មា​ពាង់​កើត​នអា៖ “មៃ​រាញា​យាកោប យើន​មា​ឞូ​មោ​ហោម​អោស​ក្វាល់​មៃ​យាកោប​ជឹត ឞូ​ក្វាល់​មៃ​អីឆ្រាអែល”។ កើត​នទ្រី​កោរាញ​ឞ្រាស​តេៈ​រាញា​ពាង់​អីឆ្រាអែល។ ");
INSERT INTO cmok_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","កោរាញ​ឞ្រាស​លាស​មា​ពាង់​ជឹត៖ “គ៝ប់​អ្យា​អី​ឞ្រាស​ទុត​គែស​នាវ​ទើយ អ៝ន់​មៃ​គែស​ក៝ន​គែស​ឆៅ​ឞឹក​រឹ​អ៝ន់​អ៝ក់។ មរា​គែស​ទូ​ផូង​ឞូនុយ្ស​តាៈ​ឞើស​មៃ នហ៝​មា​អ៝ក់​ផូង​អេងៗ​ជឹត​អី​គែស​តាៈ​ឞើស​មៃ មរា​គែស​កាដាច់​អ៝ក់​គែស​តាៈ​ឞើស​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ឞ្រី​អី​លែៈ​គ៝ប់​ត៝ន​អ៝ន់​មា​អាឞ្រាហាម់  នទ្រែល​មា​អីឆាក់​នៃ គ៝ប់​អ៝ន់​ឞ្រី​នៃ​មា​មៃ​នហ៝​រ៝​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​មៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ជេសរី​កោរាញ​ឞ្រាស​ហាវ​ឆឹត​ឞើស​នតុក​នៃ ឞើស​នតុក​ពាង់​ងើយ​ដាស​យាកោប​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ជេសរី​យាកោប​រាទ៝ក់​លុ​ជាន​ងគ៝ង់​តា​ព្លាង់​នតុក​កោរាញ​ឞ្រាស​ទែ​ងើយ​មា​ពាង់​នៃ​នើស ពាង់​ត៝ៈ​ហ៝ច​ទាក​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន នទ្រែល​មា​ត៝ៈ​ទាក​ងី​តា​កាលើ​លុ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","នទ្រី​យាកោប​តេៈ​រាញា​នតុក​កោរាញ​ឞ្រាស​ទែ​ងើយ​មា​ពាង់​នៃ​នើស «បេតអែល»។ ");
INSERT INTO cmok_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ជេសរី​យាកោប​លែវ​រានាក់​វ៝ល់​ពាង់​ទូ​ឞើស​បេតអែល។ ហោម​ដេៈ​មា​ត៝ត់​តា​ប៝ន​អេប្រាតារាចែល​គុ​អ៝ស​ទុត​ជេរ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ទោល​ពាង់​គុ​អ៝ស​គែស​នាវ​ជេរ​នៃ ឞូនុយ្ស​ញអោត​នទុល​លាស​មា​ពាង់៖ “អៃ​លើយ​ក្លាច យ៝រ​លាស​អៃ​គែស​តៃ​ទូ​មល៝ម់​ក៝ន​ឞូ​ក្លោ​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ទោល​រាចែល​ឞើយ​តាច់​នហ៝ម់ ពាង់​តេៈ​រាញា​ក៝ន​នៃ «បែន-​អោនី» រាឞ្លាង​នាវ​នៃ «ក៝ន​ឞូ​ក្លោ​នាវ​រាង៝ត​គ៝ប់» យើន​មា​ឞឹ​ពាង់​តេៈ​រាញា​ក៝ន​នៃ «បែនយាមឹន» រាឞ្លាង​នាវ​នៃ «ក៝ន​ឞូ​ក្លោ​តី​ឞើស​មា»។ ");
INSERT INTO cmok_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","រាចែល​ខឹត ជេសរី​ឞូ​ត៝ប់​ពាង់​រ៝ៈ​ត្រ៝ង​ហាន់​ជឹត​ប៝ន​អេប្រាតា ជេង​ប៝ន​បេតលេហឹម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","យាកោប​រាទ៝ក់​លុ​ជាន​ងគ៝ង់​តា​ឞើស​លើ​មោច​រាចែល​រី ជេង​ងគ៝ង់​មោច​រាចែល​នហ៝​មា​ហោម​ត៝ត់​អាបៃ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ជេសរី​យាកោប​អី​គែស​រាញា​អីឆ្រាអែល​ដ៝ង់​ហាន់​ឞើស​នតុក​នៃ ពាង់​រាទ៝ក់​ចូន​ឞើស​នាប់​មិកដាល-​អេដើរ​តី។ ");
INSERT INTO cmok_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ទោល​អីឆ្រាអែល​គុ​តា​ឞ្រី​នៃ រូបេន​ឞិច​នទ្រែល​មា​បិលហា​អូរ​ចោង​ឞឹ​ពាង់​នើម ជេសរី​អីឆ្រាអែល​តាង់​ឞូ​ងក៝ច​នាវ​នៃ។ យាកោប​គែស​ក៝ន​ឞូ​ក្លោ ១២ នុយ្ស ");
INSERT INTO cmok_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","តា​នៃ​ក៝ន​លេអា​គែស​រូបេន​ជេង​ក៝ន​ឞោក​ទាក ជេសរី​គែស​ឆីមោន គែស​លេវី គែស​យូដា គែស​អីឆាខារ នទ្រែល​មា​គែស​ឆាប់យូលោន។ ");
INSERT INTO cmok_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ក៝ន​រាចែល តា​នៃ​គែស​យោឆែប នទ្រែល​មា​បែនយាមឹន។ ");
INSERT INTO cmok_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ក៝ន​បិលហា អី​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​មា​រាចែល តា​នៃ​គែស​ដាន នទ្រែល​មា​នាប់តាលី។ ");
INSERT INTO cmok_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ក៝ន​ឞូ​ក្លោ​ឆិលផា អី​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​មា​លេអា តា​នៃ​គែស​កាត នទ្រែល​មា​អាឆើរ។ ទឹង​លែៈ​ផូង​នៃ​ជេង​ក៝ន​ឞូ​ក្លោ​យាកោប ទែស​តា​ឞ្រី​ពាដាន-អារាម​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ជេសរី​យាកោប​ត៝ត់​តា​នតុក​អីឆាក់​ឞឹ​ពាង់​នើម​គុ​តា​ប៝ន​មាម់រេ ជេង​ប៝ន​ខិរយាត់-អារបា ជេង​ប៝ន​ហេប្រ៝ន ជេង​នតុក​ប៝ន​អាឞ្រាហាម់  នទ្រែល​មា​អីឆាក់​វែស​គុ។ ");
INSERT INTO cmok_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","អីឆាក់​រេស​គែស ១៨០ នាម់ ");
INSERT INTO cmok_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ជេសរី​ខឹត គុ​នទ្រែល​ផូង​ចែ​ពាង់ ពាង់​រេស​នើស​លែៈ​ជ៝ៈ​នាម់ នទ្រែល​មា​លែៈ​រាញ​ងាន់​ដ៝ង់។ ជេសរី​អេឆាវ នទ្រែល​មា​យាកោប​ក៝ន​ពាង់​ត៝ប់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","អ្យា​នាវ​ងក៝ច​យៅ​មា​ផូង​ក៝ន​ឆៅ​អេឆាវ ឞូ​ក្វាល់​ពាង់​ជេង​អេដ៝ម់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","អេឆាវ​ឆ៝ៈ​អូរ​តា​ក៝ន​ឞូ​អូរ​ឞ្រី​កានាន តា​នៃ​គែស​អាដា​អី​ក៝ន​អេលោន​ជេង​ផូង​ហេត គែស​អោហោលីបាមា​អី​ក៝ន​អានា​អី​ឆៅ​ឆីបៀន​ជេង​ផូង​ហីវី ");
INSERT INTO cmok_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","នទ្រែល​មា​បាសមាត​អី​ក៝ន​អីសមាអែល ជេង​អី​អ៝ស​នេបាយោត។ ");
INSERT INTO cmok_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","អាដា​ឞាៈ​អេលីផាស​មា​អេឆាវបាសមាត​ឞាៈ​រេហូល ");
INSERT INTO cmok_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ជេសរី​អោហោលីបាមា​ឞាៈ​យេអុស ឞាៈ​យាលាម នទ្រែល​មា​ឞាៈ​កោរា។ ទឹង​លែៈ​ផូង​នៃ​ជេង​ក៝ន​ឞូ​ក្លោ​អេឆាវ​ទែស​តា​ឞ្រី​កានាន។ ");
INSERT INTO cmok_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","អេឆាវ​លែវ​អូរ​លែវ​ក៝ន​ពាង់ លែវ​ទឹង​លែៈ​ឞូនុយ្ស​អី​គុ​នទ្រែល​ពាង់ នទ្រែល​មា​មពោមពា​(ឆ្យុម)​ផូង​ពាង់ នអ៝ប់​មា​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស​ទោល​ពាង់​គុ​តា​ឞ្រី​កានាន​នៃ ជេសរី​ពាង់​ហាន់​គុ​តា​ឞ្រី​អេង​ជឹត ជេង​តឹម​បាស​ងាយ​ដាស​មា​យាកោប​អី​អ៝ស​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ទឹង​ពាង់​ហាន់​កើត​នៃ យ៝រ​លាស​ខាន់​ពាង់​នទ្រ៝ង់​ងាន់ មពោមពា​(ឆ្យុម)​ផូង​ឞារ​ហៃ​ខាន់​ពាង់​នៃ​មោ​អោស​ត៝ង់​មា​គុ​នតុក​នៃ កើត​នទ្រី​ខាន់​ពាង់​គុ​នទ្រែល​មោ​ជេង​អោស។ ");
INSERT INTO cmok_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ជេសរី​អេឆាវ​គុ​រ៝ៈ​យោក​ឆេអីរ។ អេឆាវ​នៃ​គែស​រាញា​អេដ៝ម់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","អ្យា​ជេង​មឞើស​ងក៝ច​រាន៝យ​ទែស​ផូង​ក៝ន​ឆៅ​អេឆាវ ជេង​ចែ​តើម​មា​ផូង​អេដ៝ម់​គុ​រ៝ៈ​ឞ្រី​យោក​ឆេអីរ។ ");
INSERT INTO cmok_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","គែស​រាញា​ឆាក់​ផូង​ក៝ន​ឆៅ​ឞូ​ក្លោ​អេឆាវ៖ តា​នៃ​គែស​អេលីផាស​ក៝ន​អាដា​អូរ​អេឆាវ។ រេហូល​ក៝ន​បាសមាត​អូរ​អេឆាវ។ ");
INSERT INTO cmok_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","អ្យា​ជេង​ផូង​ក៝ន​អេលីផាស៖ តា​នៃ​គែស​ថេមាន គែស​អោមារ គែស​ឆេផោ គែស​កាថាម នទ្រែល​មា​កេនាស។ ");
INSERT INTO cmok_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","អេលីផាស​ក៝ន​អេឆាវ ពាង់​គែស​អូរ​ចោង​រាញា​ថិមនាថិមនា​នៃ​ទែស​អាមាលេក។ ទឹង​លែៈ​ផូង​នៃ​ជេង​ក៝ន​អាដា​អូរ​អេឆាវ។ ");
INSERT INTO cmok_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","អ្យា​ជេង​ផូង​ក៝ន​ឞូ​ក្លោ​រេហូល៖ តា​នៃ​គែស​នាហាត គែស​ឆេរាស គែស​ឆាម់មា នទ្រែល​មា​មីឆា។ ទឹង​លែៈ​ផូង​នៃ​ជេង​ក៝ន​ឆៅ​បាសមាត​អូរ​អេឆាវ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","អ្យា​ជេង​ផូង​ក៝ន​ឞូ​ក្លោ​អោហោលីបាមា​អី​អូរ​អេឆាវ​ក៝ន​អានា​ឆៅ​ឆីបៀន៖ ពាង់​ឞាៈ​ក៝ន តា​នៃ​គែស​យេអុសយាលាម នទ្រែល​មា​កោរា។ ");
INSERT INTO cmok_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","អ្យា​ជេង​មពោល​កោរាញ​តា​ផូង​ក៝ន​ឆៅ​អេឆាវ។ ជេសរី​មពោល​កោរាញ​តា​ផូង​ក៝ន​ឆៅ​អេលីផាស​ក៝ន​ទាក​ឞោក​អេឆាវ៖ តា​នៃ​គែស​ថេមាន គែស​អោមារ គែស​ឆេផោ គែស​កេនាស‌ ");
INSERT INTO cmok_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","គែស​កោរា គែស​កាថាម នទ្រែល​មា​អាមាលេក។ ទឹង​លែៈ​មពោល​កោរាញ​នៃ​ជេង​ក៝ន​អេលីផាស​តា​ឞ្រី​អេដ៝ម់ ជេង​ក៝ន​ឆៅ​អាដា​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","អ្យា​ជេង​មពោល​កោរាញ​តា​ផូង​ក៝ន​ឆៅ​រេហូល​ក៝ន​អេឆាវ៖ តា​នៃ​គែស​នាហាត គែស​ឆេរាស គែស​ឆាម់មា គែស​មីឆា។ ទឹង​លែៈ​មពោល​កោរាញ​នៃ​ជេង​ក៝ន​រេហូល​តា​ឞ្រី​អេដ៝ម់ ជេង​ក៝ន​ឆៅ​បាសមាត​អូរ​អេឆាវ។ ");
INSERT INTO cmok_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","អ្យា​ជេង​មពោល​កោរាញ​តា​ផូង​ក៝ន​ឆៅ​អោហោលីបាមា​អូរ​អេឆាវ៖ តា​នៃ​គែស​យេអុស គែស​យាលាម នទ្រែល​មា​គែស​កោរា។ ទឹង​លែៈ​មពោល​កោរាញ​នៃ​ជេង​ក៝ន​ឆៅ​អោហោលីបាមា​អូរ​អេឆាវ ក៝ន​អានា។ ");
INSERT INTO cmok_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ទឹង​លែៈ​មពោល​នៃ​ជេង​ក៝ន​ឆៅ​អេឆាវ នទ្រែល​មា​ជេង​កោរាញ​ខាន់​ពាង់។ អេឆាវ​នៃ​ពាង់​រាញា​អេដ៝ម់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","អ្យា​ជេង​មពោល​ក៝ន​ឞូ​ក្លោ​ឆេអីរ​ផូង​ហោរី​អី​គុ​តា​ឞ្រី​អេដ៝ម់​នៃ៖ តា​នៃ​គែស​លោថាន គែស​ឆោបាល គែស​ឆីបៀន គែស​អានា‌ ");
INSERT INTO cmok_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","គែស​ដីឆ៝ន គែស​អេឆើរ នទ្រែល​មា​ដីឆាន។ ទឹង​លែៈ​មពោល​កោរាញ​នៃ​ជេង​ក៝ន​ឆៅ​ឆេអីរ​ផូង​ហោរី​តា​ឞ្រី​អេដ៝ម់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ក៝ន​ឞូ​ក្លោ​លោថាន៖ តា​នៃ​គែស​ហោរី នទ្រែល​មា​ហេមាម។ ជេសរី​អី​អ៝ស​ឞូ​អូរ​លោថាន​រាញា​ថិមនា។ ");
INSERT INTO cmok_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","អ្យា​ជេង​មពោល​ក៝ន​ឞូ​ក្លោ​ឆោបាល៖ តា​នៃ​គែស​អាលវាន គែស​មានាហាត គែស​អេបាល គែស​ឆេផោ នទ្រែល​មា​អោនាម។ ");
INSERT INTO cmok_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","អ្យា​ជេង​មពោល​ក៝ន​ឞូ​ក្លោ​ឆីបៀន៖ តា​នៃ​គែស​អៃយា នទ្រែល​មា​អានាអានា​អ្យា​ឆៃ​ទាក​តូ​តា​ឞ្រី​រាទាស ទាក​អី​នៃ​ទោស ទោល​ពាង់​ច្យាប់​ឆែស​លៀ​ឆីបៀន​ឞឹ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","អ្យា​ជេង​មពោល​ក៝ន​អានា៖ តា​នៃ​គែស​ដីឆ៝ន នទ្រែល​មា​អោហោលីបាមា​ជេង​ក៝ន​ឞូ​អូរ។ ");
INSERT INTO cmok_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","អ្យា​ជេង​មពោល​ក៝ន​ឞូ​ក្លោ​ដីឆ៝ន៖ តា​នៃ​គែស​ហែមដាន គែស​អែសបាន គែស​យិតរាន នទ្រែល​មា​កេរាន។ ");
INSERT INTO cmok_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","អ្យា​ជេង​មពោល​ក៝ន​ឞូ​ក្លោ​អេឆើរ៖ តា​នៃ​គែស​បិលហាន គែស​ឆាវាន នទ្រែល​មា​អាកាន។ ");
INSERT INTO cmok_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","អ្យា​ជេង​មពោល​ក៝ន​ឞូ​ក្លោ​ដីឆាន៖ តា​នៃ​គែស​អុស នទ្រែល​មា​អារាន។ ");
INSERT INTO cmok_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","អ្យា​ជេង​មពោល​កោរាញ​តា​ផូង​ហោរី៖ តា​នៃ​គែស​លោថាន គែស​ឆោបាល គែស​ឆីបៀន គែស​អានា‌ ");
INSERT INTO cmok_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","គែស​ដីឆ៝ន គែស​អេឆើរ នទ្រែល​មា​ដីឆាន។ ទឹង​លែៈ​មពោល​នៃ​ជេង​កោរាញ​មា​ផូង​ហោរី​តា​ឞ្រី​ឆេអីរ។ ");
INSERT INTO cmok_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","នោក​ផូង​ក៝ន​ឆៅ​អីឆ្រាអែល​មោ​ហ៝ៈ​អោស​គែស​កាដាច់​ម៝ត់​អ្វាញ់ អ្យា​ជេង​មពោល​កាដាច់​លែៈ​គែស​តា​ឞ្រី​អេដ៝ម់៖ ");
INSERT INTO cmok_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","បេលា​ក៝ន​បេអ៝រ​ពាង់​ជេង​កាដាច់​ម៝ត់​អ្វាញ់​ឞ្រី​អេដ៝ម់ គុ​តា​ប៝ន​ដីនហាបា។ ");
INSERT INTO cmok_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ត៝ត់​លែៈ​ខឹត​បេលា គែស​យោបាប​ក៝ន​ឆេរាស​តាៈ​ឞើស​ប៝ន​បោសរា​ពាង់​ត្រ៝ៈ​ជេង​កាដាច់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ត៝ត់​លែៈ​ខឹត​យោបាប គែស​ហូឆាម​តាៈ​ឞើស​ឞ្រី​ផូង​ថេមាន​ពាង់​ត្រ៝ៈ​ជេង​កាដាច់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ត៝ត់​លែៈ​ខឹត​ហូឆាម គែស​ហាដាត​ក៝ន​បេដាត​ពាង់​ត្រ៝ៈ​ជេង​កាដាច់ រាញា​ប៝ន​ពាង់​អាវីត កាដាច់​អី​នៃ​តឹម​លើស​ដាស​ផូង​មីដៀន​តា​ឞ្រី​មោអាប់​ទើយ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ត៝ត់​លែៈ​ខឹត​ហាដាត គែស​ឆាម់លា​តាៈ​ឞើស​ប៝ន​មាសរេកា​ពាង់​ត្រ៝ៈ​ជេង​កាដាច់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ត៝ត់​លែៈ​ខឹត​ឆាម់លា គែស​ឆោល​តាៈ​ឞើស​ប៝ន​រេហោបោត​ទាច់​ដាស​ទាក​រាលាយ​អើប្រាត​ពាង់​ត្រ៝ៈ​ជេង​កាដាច់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ត៝ត់​លែៈ​ខឹត​ឆោល គែស​បាលហានាន​អី​ក៝ន​អាសប៝រ​ពាង់​ត្រ៝ៈ​ជេង​កាដាច់។ ");
INSERT INTO cmok_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ត៝ត់​លែៈ​ខឹត​បាលហានាន​អី​ក៝ន​អាសប៝រ គែស​ហាដារ​ពាង់​ត្រ៝ៈ​ជេង​កាដាច់ រាញា​ប៝ន​ពាង់​ពាវ។ រាញា​អូរ​កាដាច់​នៃ មហេថាបែល​អី​ក៝ន​មាតរេត អី​ឆៅ​មេឆាហាប។ ");
INSERT INTO cmok_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","អ្យា​ជេង​រាញា​មពោល​កោរាញ​តា​ផូង​ក៝ន​ឆៅ​អេឆាវ តឹង​នទុល​មពោល​ខាន់​ពាង់​នើម តឹង​ឞ្រី​ខាន់​ពាង់​នើម​គុ៖ តា​នៃ​គែស​ថិមនា គែស​អាលវា គែស​យេថេត ");
INSERT INTO cmok_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","គែស​អោហោលីបាមា គែស​អេលា គែស​ពីនោន ");
INSERT INTO cmok_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","គែស​កេនាស គែស​ថេមាន គែស​មិបឆារ‌ ");
INSERT INTO cmok_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","គែស​មាក់ដៀល នទ្រែល​មា​អីរាម។ ទឹង​លែៈ​មពោល​នៃ​ជេង​កោរាញ​មា​ផូង​អេដ៝ម់ តឹង​នតុក​ខាន់​ពាង់​គុ តឹង​ឞ្រី​ខាន់​ពាង់​គុ អេឆាវ​អ្យា​ជេង​ចែ​តើម​មា​ផូង​អេដ៝ម់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","យាកោប​គុ​តា​ឞ្រី​កានាន ជេង​ឞ្រី​ឞឹ​ពាង់​វែស​គុ​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","អ្យា​ជេង​នាវ​ងក៝ច​ឞ្រី​មា​ផូង​ក៝ន​ឆៅ​យាកោប។ ទោល​យោឆែប​អី​ក៝ន​យាកោប​នៃ​លែៈ​គែស ១៧ នាម់ ពាង់​កើល​ច្យាប់​ឞែ​ឞ្យាប់​នទ្រែល​នោៗ​ពាង់ អី​ក៝ន​បិលហា នទ្រែល​មា​អី​ក៝ន​ឆិលផា​អូរ​ចោង​អី​ឞឹ​ពាង់​រី។ ពាង់​មឞើស​ងក៝ច​មា​ឞឹ​ពាង់​នាវ​អ្យើស​តា​អី​នោៗ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","អីឆ្រាអែល​អី​គែស​រាញា​យាកោប​ដ៝ង់ ពាង់​រ៝ង់​មា​យោឆែប​រាលាវ​ដាស​មា​ក៝ន​ពាង់​បាបាៈ យ៝រ​លាស​នោក​គុ​យោឆែប​នៃ​ពាង់​លែៈ​រាញ។ ពាង់​ដាៈ​ឞូ​ជឹង​ទូ​ឞ្លាស​អាវ​ជ៝ង​ទុត​អ្វែស​អ៝ន់​មា​យោឆែប។ ");
INSERT INTO cmok_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ទឹង​លែៈ​នោៗ​ពាង់​រី​ឆៃ​អី​ឞឹ​រ៝ង់​មា​យោឆែប​រាលាវ​ដាស​មា​ខាន់​ពាង់ ជេសរី​ខាន់​ពាង់​ឞ្យាញ់​មា​យោឆែប​ទាទេ មោ​គែស​អោស​មឞើស​ងើយ​អ្វែស​មា​អោឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","គែស​ទូ​នារ​យោឆែប​មឞើយ ជេសរី​ពាង់​ងក៝ច​មឞើយ​នៃ​មា​នោៗ​ពាង់ ជាន​អ៝ន់​នោៗ​រី​ឞ្យាញ់​មា​ពាង់​លើ​មា​ហោ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ពាង់​លាស​មា​ខាន់​ពាង់៖ “ល៝ង់​ខាន់​មៃ​អ្យាត់​គ៝ប់​ងក៝ច​មឞើយ​គ៝ប់៖ ");
INSERT INTO cmok_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","គ៝ប់​មឞើយ ទឹង​លែៈ​ឞ៝ន់​គុ​ក៝ត់​ញចាប់​ឞា​តា​មីរ​រី​ទាទេ ទោល​នៃ​ទោ​មា​ញចាប់​ឞា​គ៝ប់​រី​ទ៝ក់​ឆ៝ង់​ជឹត​លើ​តី ល៝ង់​ញចាប់​ឞា​ខាន់​មៃ​រី​ទ៝ក់​ជុម​ញចាប់​ឞា​គ៝ប់​រី ជេសរី​កុញ​មឞាស​មា​ញចាប់​ឞា​គ៝ប់​រី​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","អី​នោៗ​រី​លាស​មា​ពាង់៖ “លាស​នទ្រី​មៃ​គែស​នាវ​មឹន​អុច​ជេង​កោរាញ​មា​ផូង​ហេន​បាស​? មោ​លាស​មៃ​គែស​នាវ​មឹន​អុច​ម៝ត់​ឞោក​ហេន?” ខាន់​ពាង់​លើ​មា​ហោ​ឞ្យាញ់​មា​ពាង់ យ៝រ​មា​នាវ​មឞើយ​ពាង់​នៃ នអ៝ប់​មា​នាវ​ពាង់​ងក៝ច​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ជេសរី​ពាង់​មឞើយ​តៃ​នទើ​អេង​ជឹត ពាង់​ងក៝ច​មឞើយ​នៃ​មា​នោៗ​ពាង់ ពាង់​លាស៖ “គ៝ប់​មឞើយ​កើត​នអា នារ ខៃ នទ្រែល​មា​មាញ់ ១១ កុញ​មឞាស​មា​គ៝ប់​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ពាង់​ងក៝ច​មឞើយ​នៃ​មា​ឞឹ​ពាង់ កើត​ពាង់​ងក៝ច​មា​នោៗ​ពាង់​នើស​ដ៝ង់។ ឞឹ​ពាង់​លាស​ពាង់៖ “មើម​មឞើយ​មៃ​កើត​នទ្រី​រី? លាស​នទ្រី​មៃ​អុច​អ៝ន់​គ៝ប់​អ្យា មេៈ​មៃ​នៃ នទ្រែល​មា​ទឹង​លែៈ​អ៝ស​នោ​មៃ​នៃ​ពាន់​មឞាស​មា​មៃ​ទាទេ​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ទឹង​លែៈ​នោៗ​រី​ខាន់​ពាង់​មោ​នាច​មា​យោឆែប យើន​មា​ឞឹ​ពាង់​រី​ហោម​កាស​គឹត​មរ៝​នាវ​នៃ​តា​នូយ្ស​នហ៝ម់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","គែស​ទូ​នារ​អី​នោៗ​យោឆែប ខាន់​ពាង់​ហាន់​ច្យាប់​ឞែ​ឞ្យាប់​ឞឹ​ពាង់​តា​ប៝ន​ឆីកែម។ ");
INSERT INTO cmok_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ជេសរី​យាកោប​អី​ឞូ​ក្វាល់​អីឆ្រាអែល​លាស​មា​យោឆែប៖ “នោៗ​មៃ​លែៈ​ហាន់​ច្យាប់​ឞែ​ឞ្យាប់​តា​ប៝ន​ឆីកែម​រី គ៝ប់​អុច​អ៝ន់​មៃ​ហាន់​តា​រី”។ យោឆែប​អើស៖ “អើ”។ ");
INSERT INTO cmok_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","អីឆ្រាអែល​លាស​មា​ពាង់៖ “ហាន់​មៃ​ហាន់​អា​នោៗ​មៃ​រី គឹត​អ្វែស​លាង់​ខាន់​ពាង់​តា​រី ឞែ​ឞ្យាប់​ខាន់​ពាង់​គឹត​អ្វែស​ដ៝ង់​មោ​លាស​មោ។ ជេសរី​មៃ​ហាន់​ព្លឹ​មឞើស​តៃ​មា​គ៝ប់​អ្យា”។ ពាង់​ដាៈ​យោឆែប​តាៈ​ឞើស​ញជ៝ង់​យោក​ហេប្រ៝ន​អ្យា​ហាន់​ជឹត​ឆីកែម​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ត៝ត់​តា​រី គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ឆៃ​យោឆែប​ហាន់​រាឆ៝ង​នាប់​រាឆ៝ង​កើយ​តា​ជា​លាច​រី ឞូ​ក្លោ​នៃ​អោប៖ “ម៝ស​ជ៝យ​មរែ​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","យោឆែប​អើស៖ “គ៝ប់​ជ៝យ​នោៗ​គ៝ប់ មៃ​ឆើម​មឞើស​មា​គ៝ប់​អឺស​អាស​នតុក​ខាន់​ពាង់​ច្យាប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ឞូ​ក្លោ​នៃ​អើស​មា​ពាង់៖ “ខាន់​ពាង់​លែៈ​ត្រើន​ឞើស​នតុក​អ្យា យ៝រ​លាស​គ៝ប់​តាង់​ខាន់​ពាង់​តឹម​លាស៖ «ហោៈ​ឞ៝ន់! ហាន់​តា​ប៝ន​ដោថាន​រី»។ ជេសរី​យោឆែប​ហាន់​តឹង​អី​នោៗ​ពាង់ ឆៃ​ខាន់​ពាង់​តា​ប៝ន​ដោថាន​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ទោល​ខាន់​ពាង់​ឆៃ​យោឆែប​ហោម​ឞើស​ងាយ មោ​ហ៝ៈ​ត៝ត់ ខាន់​ពាង់​លែៈ​តឹម​ទី​ឞាល់​អុច​ងខឹត​លើយ​យោឆែប។ ");
INSERT INTO cmok_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ខាន់​ពាង់​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ “អ្វាញ់​រី! កោរាញ​មឞើយ​លែៈ​ត៝ត់! ");
INSERT INTO cmok_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ហោៈ​ឞ៝ន់​ងខឹត​លើយ​ពាង់​អាបៃ​រី ល៝ង់​តា​អ្យា​គែស​អ៝ក់​ត្រោម​នតូ ជេសរី​ងក្លាច់​ពាង់​តា​ទូ​មល៝ម់​ត្រោម​នតូ។ ឞ៝ន់​លាស​លែៈ​មពោមពា​(ឆ្យុម)​ជាញ​ឆា​ហេក ឞ៝ន់​ជាន​កើត​នៃ ជេសរី​អ៝ន់​ឞ៝ន់​ក៝ប់​អ្វាញ់​មើម​ហោម​ជេង​ដ៝ង់​តា​នាវ​មឞើយ​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ត៝ត់​រូបេន​តាង់​នាវ​ខាន់​ពាង់​ងើយ​កើត​នៃ ជេសរី​ពាង់​អុច​កើល​យោឆែប ពាង់​លាស​មា​ខាន់​ពាង់៖ “លើយ​អោស​ឞ៝ន់​ងខឹត​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","រូបេន​លាស​ជឹត៖ “លើយ​អោស​ញចាយ​មហាម​ពាង់ ឞ៝ន់​ងក្លាច់​ពាង់​តា​ត្រោម​នតូ​តា​ឞ្រី​រាទាស​អ្យា​ហ៝ៈ លើយ​អោស​ងខឹត​ពាង់”។ រូបេន​ងើយ​កើត​នៃ យ៝រ​លាស​ពាង់​អុច​រាក្លាយ្ស​យោឆែប​ឞើស​តី​នោៗ​ពាង់ ជេសរី​អុច​ញជុន​អ៝ន់​ពាង់​ឆឹត​អា​ឞឹ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","យោឆែប​ហាន់​ត៝ត់​តា​អី​នោៗ​រី ខាន់​ពាង់​ទ្រ៝ស​លើយ​អាវ​ទុត​អ្វែស​យោឆែប​ទែ​ញឆ៝ស​រី‌ ");
INSERT INTO cmok_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ញុប​ពាង់​ងក្លាច់​តា​ត្រោម​នតូ​រី នតូ​នៃ​មោ​ហោម​អោស​គែស​ទាក។ ");
INSERT INTO cmok_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ជេសរី​ខាន់​ពាង់​នើម​គុ​ឆោង ទោ​មា​ខាន់​ពាង់​ងគឹល​មាត់​ឆៃ​ផូង​អីសមាអែល​ទូ​មពោល នអ៝ប់​មា​ឆែស​ឆាមោ​ខាន់​ពាង់​តាៈ​ឞើស​ឞ្រី​កាលាត។ ឆែស​ឆាមោ​ខាន់​ពាង់​រាទែង​ចាយ​ក្រ៝ស នទ្រែល​មា​នទើ​បោ​កាស​អេងៗ​លែវ​ជឹត​ឞ្រី​អេឆីប ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ឆៃ​កើត​នៃ យូដា​លាស​មា​អ៝ស​នោ​ពាង់៖ “លាស​ឞ៝ន់​ងខឹត​អ៝ស​ឞ៝ន់ មោ​អោស​ឆៃ​នតីល ជេរ​ដ៝ង់​មា​ម៝។ ");
INSERT INTO cmok_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","លាស​នទ្រី​ឞ៝ន់​តាច់​ពាង់​អ៝ន់​មា​ផូង​អីសមាអែល​ទោស លើយ​ងខឹត​ពាង់ យ៝រ​លាស​ពាង់​អ៝ស​ឞ៝ន់ ជេង​មហាម​ឞ៝ន់​ដ៝ង់”។ ខាន់​ពាង់​អ្យាត់​នាវ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ទោល​នៃ​គែស​មពោល​តាច់​ទ្រាប់​ត៝ត់​តា​រី អី​នោៗ​យោឆែប​នហាវ​ពាង់​ឞើស​ត្រោម​នតូ​រី តាច់​ពាង់​អ៝ន់​មា​ផូង​អីសមាអែល​ខ្លៃ ២០ កាក់​ព្រាក់។ ជេសរី​មពោល​នៃ​លែវ​ពាង់​ជឹត​ឞ្រី​អេឆីប ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ត៝ត់​រូបេន​ព្លឹ​អ្វាញ់​តៃ​តា​ត្រោម​នតូ​រី​មោ​ហោម​អោស​ឆៃ​យោឆែប ពាង់​ងខេក​ឞ៝ក​អាវ​ពាង់​នើម យ៝រ​លាស​ពាង់​រាង៝ត​ហោ​ងាន់‌ ");
INSERT INTO cmok_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ជេសរី​ហាន់​តា​អ៝សៗ​រី លាស​មា​ខាន់​ពាង់៖ “ក៝ន​ឆែ​នៃ​លែៈ​រ៝ស​ជេស លាស​នទ្រី​គ៝ប់​អ្យា​អាស​ជឹត​គុ?” ");
INSERT INTO cmok_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ជេសរី​ខាន់​ពាង់​ងខឹត​ទូ​មល៝ម់​ឞែ​ងក្វ៝ង់ ឆ៝ៈ​អាវ​យោឆែប​អី​ទុត​អ្វែស​រី​នើស​យុក​តា​មហាម​ឞែ​រី‌ ");
INSERT INTO cmok_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","លែវ​អាវ​នៃ​ញហើ​មា​អី​ឞឹ​រី មឞើស​មា​ពាង់៖ “ហេន​ឆៃ​អាវ​អ្យា។ ល៝ង់​មៃ​អ្វាញ់​ឞឹ គឹត​ទី​អាវ​ក៝ន​មៃ​ងាន់​មោ​លាស​មោ?” ");
INSERT INTO cmok_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","យាកោប​នាល់​អាវ​នៃ ជេសរី​លាស៖ “អាវ​អ្យា​អាវ​ក៝ន​គ៝ប់​ងាន់ លែៈ​ឞូ​កាប់​ឆា​រ៝​ពាង់​អ្យា​អើ លែៈ​ងាន់​រ៝​ឞូ​ឆា​ហេក​យោឆែប​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ជេសរី​យាកោប​ងខេក​ឞ៝ក​អាវ​ពាង់​នើម​រី ញឆ៝ស​ងគូត​បៅ​ច្យាត់ ពាង់​គុ​រាង៝ត​ងក្ល៝ន់​មា​ក៝ន​ពាង់​នៃ​ជ៝ៈ​នារ។ ");
INSERT INTO cmok_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ទឹង​លែៈ​អ៝ស​ក៝ន​ពាង់ នអ៝ប់​មា​ឞូ​អូរ​នអ៝ប់​មា​ឞូ​ក្លោ​ហាន់​ឞ៝ញ​លែង​ពាង់​ទាទេ យើន​មា​ពាង់​មោ​អោស​ឞាស​នាវ​រាង៝ត​ងក្ល៝ន់​នៃ ពាង់​លាស៖ “គ៝ប់​មរា​ខឹត​តឹម​ម៝ប់​ដាស​ក៝ន​គ៝ប់ ក៝ៈ​មោ​ឞាស​ដ៝ង់​រាង៝ត​ងក្ល៝ន់​ក៝ន​គ៝ប់” នទ្រី​ទឹង​ពាង់​ហោម​ញុម​នឹង។ ");
INSERT INTO cmok_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ល៝ង់​យោឆែប​នៃ​ផូង​មីដៀន​ទែ​លែវ​ពាង់​ហាន់​តា​ឞ្រី​អេឆីប  តាច់​ពាង់​អ៝ន់​មា​ផោតីផារ កោរាញ​ម៝ត់​ញជ្រាង់​កាដាច់​ផារ៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","នោក​នៃ​យូដា​ទូ​លោស​ឞើស​អ៝ស​នោ​ពាង់ ហាន់​គុ​នទ្រែល​ទូ​ហ្វេ​ឞូ​ក្លោ​តា​ប៝ន​អាដូលាម រាញា​ហីរា។ ");
INSERT INTO cmok_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","តា​នតុក​នៃ​ពាង់​ឆៃ​ទូ​ហ្វេ​ឞូ​អូរ​ទ្រោស ក៝ន​ឆូអា​ផូង​កានាន ពាង់​ឆ៝ៈ​ឞូ​អូរ​នៃ​ជេង​អូរ​ពាង់ គុ​នទ្រែល​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ជេសរី​ឞូ​អូរ​នៃ​នត្រែវ​គុ​អ៝ស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ ពាង់​តេៈ​រាញា​អេរ។ ");
INSERT INTO cmok_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ឞូ​អូរ​នៃ​នត្រែវ​គុ​អ៝ស​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត នហ៝​មា​តេៈ​រាញា​អោនាន។ ");
INSERT INTO cmok_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ជេសរី​ពាង់​នត្រែវ​គុ​អ៝ស​តៃ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​ជឹត នហ៝​មា​តេៈ​រាញា​ឆេលា។ នោក​ពាង់​គុ​អ៝ស​អី​នៃ យូដា​គុ​តា​ប៝ន​កេឆីប​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ជេសរី​ត៝ត់​អេរ​អី​ក៝ន​ឞោក​ទាក​រី​លែៈ​នទាម់ យូដា​អោប​អូរ​មា​ពាង់ ឞូ​អូរ​នៃ​រាញា​ថាមារ។ ");
INSERT INTO cmok_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","យើន​មា​អេរ​អី​ក៝ន​ឞោក​ទាក​យូដា​ជេង​ឞូនុយ្ស​អ្យើស​ជាញ​តា​នាប់​មាត់​ឞ្រាស​យេហោវា កើត​នទ្រី​ទឹង​ឞ្រាស​យេហោវា​ងខឹត​លើយ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ជេសរី​យូដា​លាស​មា​អោនាន​អី​អ៝ស​អេរ​នៃ៖ “មៃ​ឆ៝ៈ​មី​មៃ​នៃ​ទោ ជេង​ទី​មា​នាវ​វៃ​ឞ៝ន់ គុ​នទ្រែល​ពាង់ គៃ​មា​ហោម​គែស​រាន៝យ​ទែស​មា​នោ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","យើន​មា​អោនាន​លែៈ​គឹត លាស​គែស​ក៝ន​នៃ​មោ​អោស​កើប​ជេង​ក៝ន​ពាង់​នើម កើត​នទ្រី​នោក​ពាង់​ហាន់​គុ​ដាស​មី​ពាង់​នៃ ពាង់​ងលោស​លើយ​ទាក​ពាង់​អា​នែស គៃ​មា​លើយ​អ៝ន់​គែស​ក៝ន​មា​នោ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","នទើ​អោនាន​ជាន​នៃ​ជេង​អ្យើស​តា​នាប់​មាត់​ឞ្រាស​យេហោវាឞ្រាស​យេហោវា​ងខឹត​លើយ​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ជេសរី​យូដា​លាស​មា​ថាមារ​អី​មាន់​ពាង់​នៃ៖ “បែ​ឆឹត​គុ​នទ្រោ​តា​ជៃ​ឞឹ​បែ​រី​ប៝ត់ មពើ​មា​ក្វ៝ង់​ឆេលា​ក៝ន​គ៝ប់” យ៝រ​លាស​ពាង់​ក្លាច​អី​ក៝ន​ទុត​ពាង់​នៃ​ខឹត​ដ៝ង់។ ជេសរី​ថាមារ​ឆឹត​គុ​អា​ជៃ​ឞឹ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ជ៝ៈ​ឞើស​កើយ​នៃ អី​អូរ​យូដា​ក៝ន​ឆូអា​រី​នើស​ខឹត។ ត៝ត់​យូដា​លែៈ​ឞាស​រាង៝ត​ងក្ល៝ន់​ខឹត​អី​អូរ​នៃ ជេសរី​ពាង់​ហាន់​តា​ប៝ន​ថិមនា ហាន់​នទ្រែល​មា​មឹត​ជាង់​ពាង់​រាញា​ហីរា​ឞើស​ប៝ន​អាដូលាម គៃ​មា​អ្វាញ់​ឞូ​ក៝ស​រាឆៅ​ឞែ​ឞ្យាប់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","គែស​ឞូ​ហាន់​មឞើស​មា​ថាមារ៖ “ឞឹ​ព៝​អៃ​ហាន់​ក៝ស​រាឆៅ​ឞែ​ឞ្យាប់​ពាង់​នើម​តា​ប៝ន​ថិមនា”។ ");
INSERT INTO cmok_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","តាង់​លាស​កើត​នៃ ពាង់​ទ្រីស​លើយ​ឞ៝ក​អាវ​ឞូ​អូរ​នទ្រោ​ពាង់​នើម​រី ជេសរី​ពាង់​ឆ៝ៈ​ឞ៝ក​ពូត​លើយ​មុស​មាត់​ពាង់​នើម មោ​អោស​អ៝ន់​ឞូ​គឹត​នាល់។ ពាង់​ហាន់​គុ​អា​ត្រ៝ង​ទាច់​កេង​ប៝ន​អេនាយីម ជេង​ត្រ៝ង​ហាន់​តា​ថិមនា​រី។ ពាង់​ជាន​កើត​នៃ យ៝រ​លាស​ពាង់​ឆៃ​ឆេលា​លែៈ​ក្វ៝ង់ តីស​មា​មោ​អោស​ឆៃ​យូដា​ឆ៝ៈ​ពាង់​អ៝ន់​មា​ជេង​អូរ​ឆេលា។ ");
INSERT INTO cmok_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ទោល​យូដា​ឆៃ​ពាង់ យូដា​នអោន​លាស​ឞូ​អូរ​វាង់​តឹរ​គៃ​មា​គែស​ព្រាក់ យ៝រ​លាស​មុស​មាត់​ពាង់​លែៈ​ងកុម​លើយ។ ");
INSERT INTO cmok_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ជេសរី​យូដា​ហាន់​ទាច់​តា​ឞូ​អូរ​នៃ ពាង់​លាស៖ “ហោៈ! ហាន់​ឞិច​នទ្រែល​គ៝ប់”។ ពាង់​មោ​គឹត​អោស​លាស​ឞូ​អូរ​នៃ​មាន់​ពាង់​នើម​ច្រាវ។ ឞូ​អូរ​នៃ​អើស​មា​ពាង់៖ “លាស​គ៝ប់​ឞិច​ដាស​មៃ ម៝ស​នទើ​មៃ​អ៝ន់​មា​គ៝ប់?” ");
INSERT INTO cmok_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ពាង់​អើស៖ “តៃ​គ៝ប់​អ៝ន់​ទូ​មល៝ម់​ក៝ន​ឞែ​មា​អៃ”។ ឞូ​អូរ​នៃ​អើស៖ “អើ​គ៝ប់​អុច លាស​នទ្រី​ម៝ស​នទើ​មៃ​ញចាម់​មា​គ៝ប់​ល៝រ គឹត​ជ៝ៈ​មៃ​អ៝ន់​ក៝ន​ឞែ​នៃ​មា​គ៝ប់?” ");
INSERT INTO cmok_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ពាង់​លាស៖ “លាស​នទ្រី​ម៝ស​នទើ​អៃ​អុច​គ៝ប់​ញចាម់​អ៝ន់​អៃ?” ឞូ​អូរ​នៃ​អើស៖ “នៃ មៃ​អ៝ន់​ត្រា​មៃ នអ៝ប់​មា​អី​រាឆែ​យោង​នៃ នទ្រែល​មា​អ៝ន់​ម៝ង់​តា​តី​មៃ​នៃ​មា​គ៝ប់”។ យូដា​អ៝ន់​នទើ​នៃ​មា​ពាង់ ជេសរី​ហាន់​ឞិច​ដាស​ពាង់។ ឞូ​អូរ​នៃ​នហ៝​មា​នត្រែវ​មា​ពាង់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ជេសរី​ឞូ​អូរ​នៃ​ទ៝ក់​ឆឹត ពាង់​ទ្រីស​លើយ​ឞ៝ក​ងកុម​មុស​មាត់​ពាង់​រី​នើស ពាង់​ញឆ៝ស​ងគូត​តៃ​ឞ៝ក​អាវ​ឞូ​អូរ​នទ្រោ។ ");
INSERT INTO cmok_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","នោក​យូដា​អ៝ន់​ទូ​មល៝ម់​ក៝ន​ឞែ​តា​មឹត​ជាង់​ពាង់​អី​តាៈ​ឞើស​ប៝ន​អាដូលាម គៃ​មា​អ៝ន់​មឹត​ជាង់​នៃ​ហាន់​ច្វាយ​នទើ​ពាង់​ញចាម់​តា​ឞូ​អូរ​នៃ​នើស យើន​មា​មឹត​ជាង់​នៃ​ជ៝យ​ឞូ​អូរ​នៃ​មោ​ឆៃ​អោស។ ");
INSERT INTO cmok_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ពាង់​អោប​ឞូ​តា​នៃ៖ “អាស​នតុក​គុ​ឞូ​អូរ​វាង់​តឹរ​គុ​តា​មែង​ត្រ៝ង​លាប់​ជឹត​អេនាយីម​អ្យា​នើស?” ឞូ​អើស៖ “តា​នតុក​អ្យា​មោ​គែស​អោស​ឞូ​អូរ​វាង់​តឹរ”។ ");
INSERT INTO cmok_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ជេសរី​ពាង់​ឆឹត​មឞើស​អ៝ន់​មា​យូដា៖ “គ៝ប់​ជ៝យ​ឞូ​អូរ​នៃ​មោ​ឆៃ​អោស ឞូ​តា​ឞ្រី​នៃ​លាស៖ «តា​នតុក​អ្យា​មោ​គែស​អោស​ឞូ​អូរ​វាង់​តឹរ»”។ ");
INSERT INTO cmok_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","យូដា​លាស​មា​ពាង់៖ “លាស​នទ្រី​អ៝ន់​ពាង់​ញអោត​កាដោយ​នទើ​គ៝ប់​ញចាម់​នៃ លើយ​ហោម​ជ៝យ ដីត​ឞូ។ យ៝រ​លាស​គ៝ប់​លែៈ​អុច​អ៝ន់​ក៝ន​ឞែ​មា​ពាង់​កើត​នាវ​គ៝ប់​លែៈ​ត៝ន យើន​មា​មៃ​ជ៝យ​ពាង់​មោ​ឆៃ​អោស”។ ");
INSERT INTO cmok_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ត៝ត់​ពែ​ខៃ​ឞើស​កើយ​នៃ គែស​ឞូ​ហាន់​មឞើស​មា​យូដា៖ “ថាមារ​មាន់​មៃ​ឞូ​អូរ​វាង់​តឹរ លែៈ​នត្រែវ​អេង​ដាស​ឞូ”។ យូដា​លាស៖ “ងលោស​ពាង់​អា​ទីស​អ្យា ពូរ​ងគ្រេស​ពាង់​តា​អុញ​ទោស!” ");
INSERT INTO cmok_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ត៝ត់​ឞូ​លែវ​ពាង់​លោស​អា​ទីស​អ្យា ឞូ​អូរ​នៃ​ងើយ​មា​យូដា​ឞឹ​ព៝​ពាង់​រី៖ “គ៝ប់​នត្រែវ​ដាស​ពាង់​អី​តើម​នទើ​អ្យា ល៝ង់​មៃ​អ្វាញ់ ឞ្រែ​ម៝ស​ម៝ង់ ត្រា នទ្រែល​មា​រាឆែ​អ្យា?” ");
INSERT INTO cmok_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","យូដា​នាល់​លែៈ​នទើ​នៃ ជេសរី​លាស៖ “បែ​ឆ៝ង់​រាលាវ​គ៝ប់​ងាន់ យ៝រ​លាស​គ៝ប់​មោ​គែស​អ៝ន់​បែ​មា​ឆេលា​មា​ជេង​អូរ​ក៝ន​គ៝ប់”។ នតើម​ឞើស​នៃ​យូដា​មោ​ហោម​អោស​ឞិច​នទ្រែល​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ត៝ត់​ឞើយ​អាប់​ខៃ​គុ​អ៝ស ឆៃ​តា​ត្រោម​នទុល​ពាង់​រី​គែស​ក៝ន​ឞារ។ ");
INSERT INTO cmok_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ត៝ត់​ពាង់​គុ​អ៝ស គែស​អី​ទូ​ហ្វេ​លោស​ល៝រ​តី ជេសរី​ឞូនុយ្ស​ញអោត​នទុល​នៃ​ឆ៝ៈ​រាឆែ​ឞ្រាយ​គុរ​ក៝ត់​តា​តី​អ៝ស​ឞេ​រី ពាង់​លាស៖ “ក៝ន​អ្យា​រ៝​លោស​ល៝រ”។ ");
INSERT INTO cmok_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","យើន​មា​អ៝ស​ឞេ​នៃ​ពាង់​រាហ្វាត់​តី​លាប់​ជឹត​ត្រោម​រី អី​នោ​ពាង់​លោស​ល៝រ។ ឞូនុយ្ស​ញអោត​នទុល​នៃ​លាស៖ “មើម​មៃ​អ្យា​ច្រាវ​លោស​ល៝រ” ជេសរី​ឞូ​តេៈ​រាញា​ក៝ន​នៃ ពេរេស គែស​នាវ​ខ្លៃ​លាស​«មព្លុង»។ ");
INSERT INTO cmok_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ជេស​ឞើស​នៃ​លោស​អី​អ៝ស​រី​ជឹត នអ៝ប់​មា​គែស​រាឆែ​ឞ្រាយ​គុរ​ក៝ត់​តា​តី​ពាង់​រី​ដ៝ង់។ ជេសរី​ឞូ​តេៈ​រាញា​ក៝ន​នៃ «ឆេរាស» គែស​នាវ​ខ្លៃ​លាស​«ត្រោក​គុរ​អា​អោយ»។ ");
INSERT INTO cmok_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ផូង​អីសមាអែល​លែៈ​លែវ​យោឆែប​ជុរ​តា​ឞ្រី​អេឆីប  តាច់​ពាង់​អ៝ន់​មា​ទូ​ហ្វេ​ផូង​អេឆីប រាញា​ផោតីផារ កោរាញ​ម៝ត់​ញជ្រាង់​កាដាច់​ផារ៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ឞ្រាស​យេហោវា​គុ​នទ្រែល​មា​យោឆែប ជេសរី​ទឹង​លែៈ​នទើ​ពាង់​ជាន​គែស​ជេង​ទាទេ។ ពាង់​គុ​តា​ជៃ​កោរាញ​ពាង់​ផូង​អេឆីប ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","កោរាញ​ពាង់​ឆៃ​ឞ្រាស​យេហោវា​គុ​នទ្រែល​ពាង់ នអ៝ប់​មា​ឞ្រាស​យេហោវា​ជាន​អ៝ន់​ពាង់​គែស​នាវ​អ្វែស​ទាទេ​ទឹង​លែៈ​នទើ​ពាង់​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","នទ្រី​ផោតីផារ​ទី​នូយ្ស​នហ៝ម់​មា​យោឆែប​ងាន់ ជេសរី​អ៝ន់​យោឆែប​ជាន​ការ​មា​ពាង់​នើម ពាង់​អ៝ន់​យោឆែប​ជាន​កោរាញ​តា​ញីស​ជៃ​ពាង់ នទ្រែល​មា​អ៝ន់​ពាង់​ទើយ​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស។ ");
INSERT INTO cmok_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","នតើម​ឞើស​ផោតីផារ​អ៝ន់​យោឆែប​ជាន​កោរាញ​តា​ញីស​ជៃ​ពាង់ នទ្រែល​មា​អ៝ន់​ពាង់​ទើយ​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស ឞ្រាស​យេហោវា​អ៝ន់​នាវ​គែស​ជេង​មា​រានាក់​វ៝ល់​ផោតីផារ​នៃ យ៝រ​តាៈ​ឞើស​យោឆែប ជេសរី​ឞ្រាស​យេហោវា​អ៝ន់​គែស​ជេង​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស តា​ញីស​តា​ជៃ តា​មីរ​តា​ឆ្រែ។ ");
INSERT INTO cmok_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស​រី ពាង់​អ៝ន់​មា​យោឆែប​ម៝ត់​អ្វាញ់​ទាទេ ពាង់​នើម​មោ​ហោម​អោស​គែស​មឹន​រាវៃ​ទូ​នតីល​នទើ ពាង់​មឹន​មា​នទើ​ឆោង​ឆា​ទើម។ យោឆែប​ជេង​ឞូនុយ្ស​អ្វែស​រែស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ត៝ត់​ឞើស​កើយ​រី អូរ​ផោតីផារ​នៃ​ឆៃ​យោឆែប​ជេស​រី​អុច​ពាង់​ហោ​ងាន់ នហ៝​មា​លាស៖ “ហាន់​ឞិច​នទ្រែល​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","យោឆែប​រាលាច់ ពាង់​លាស​មា​អូរ​កោរាញ​ពាង់​នៃ៖ “តា​អ្យា​កោរាញ​គ៝ប់​លែៈ​ពាង់​អ៝ន់​មា​គ៝ប់​ទាទេ​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស យ៝រ​មា​គ៝ប់​ពាង់​នើម​មោ​ហោម​អោស​គែស​មឹន​រាវៃ​ទូ​នតីល​នទើ។ ");
INSERT INTO cmok_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","តា​ជៃ​អ្យា​មោ​ហោម​គែស​ឞូនុយ្ស​អេង​ក្វ៝ង់​រាលាវ​គ៝ប់ ពាង់​អ៝ន់​គ៝ប់​ទើយ​ទ៝ង់​ទាទេ​ទឹង​លែៈ​នទើ​តា​ជៃ​អ្យា អៃ​ទូ​ហ្វេ​ទើម​គ៝ប់​មោ​ទើយ យ៝រ​លាស​អៃ​ជេង​អូរ​ពាង់។ លាស​នទ្រី​មើម​គ៝ប់​ទើយ​ជាន​នាវ​ទុត​អ្យើស​អ្យា? គ៝ប់​មោ​អុច​ជាន​តីស​ដាស​មា​កោរាញ​ឞ្រាស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ឞូ​អូរ​នៃ​ជាៈ​យោឆែប​ឞិច​នទ្រែល​ពាង់​អាប់​នារ​ងាន់ យើន​មា​យោឆែប​មោ​អុច​អោស​អ្យាត់​នាវ​ពាង់ ឞ៝ល​លាស​គុ​ទាច់​មោ​អុច​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","គែស​ទូ​នារ​នៃ យោឆែប​លាប់​ជាន​ការ​តា​ត្រោម​ជៃ​រី តា​ត្រោម​ជៃ​នៃ​មោ​គែស​អោស​ឞូនុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","អូរ​ផោតីផារ​រី​ក្វាន់​ន៝ប់​អាវ​យោឆែប ជេសរី​លាស៖ “ហាន់​ឞិច​នទ្រែល​គ៝ប់​ប៝ត់”។ យោឆែប​ទ្រីស​អាវ​ហោម​ខាន​តា​តី​ឞូ​អូរ​នៃ ពាង់​នើម​រី​ញច្វាត់​លោស​អា​ទីស។ ");
INSERT INTO cmok_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ឞូ​អូរ​នៃ​ឆៃ​អាវ​យោឆែប​ហោម​តា​តី​រី អី​ឆាក់​ពាង់​នើម​លែៈ​ញច្វាត់​អា​ទីស‌ ");
INSERT INTO cmok_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ជេសរី​ឞូ​អូរ​នៃ​នតែរ​ក្វាល់​ឞូនុយ្ស​អី​គុ​ជាន​ការ​តា​ជៃ​នៃ ពាង់​មឞើស​មា​ឞូ៖ “អ្វាញ់​អ្យាៈ ឆាយ​គ៝ប់​លែវ​ផូង​ហេឞ្រើ​អ្យា ពាង់​មឺច​រាម៝ត​គ៝ប់។ ពាង់​អុច​លាប់​ឞិច​នទ្រែល​គ៝ប់ ងាច់​គ៝ប់​ទែ​នតែរ​ទុត​នតែស។ ");
INSERT INTO cmok_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ត៝ត់​តាង់​គ៝ប់​នតែរ​នៃ ពាង់​នត្លើយ​អាវ​តា​គ៝ប់​អ្យា ពាង់​នើម​ញច្វាត់​លោស​អា​ទីស​រី”។ ");
INSERT INTO cmok_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ឞូ​អូរ​នៃ​ព្រាប់​អាវ​យោឆែប​កេង​ឆាក់​ពាង់​នើម​រី នហ៝​មា​ត៝ត់​ឆឹត​អី​ឆាយ​ពាង់​តា​ជៃ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ពាង់​មឞើស​មា​ឆាយ​ពាង់​កើត​នអា៖ “ទឹក​ផូង​ហេឞ្រើ​មៃ​លែវ​តា​អ្យា ពាង់​អុច​ត៝ម​គ៝ប់‌ ");
INSERT INTO cmok_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","យើន​មា​គ៝ប់​នតែរ​ក្វាល់​ឞូ ពាង់​ញច្វាត់​អា​ទីស អាវ​ពាង់​នត្លើយ​តា​គ៝ប់​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ត៝ត់​មា​តាង់​អូរ​ពាង់​មឞើស​នាវ​អ្យើស​យោឆែប៖ “កើត​នអា​ទឹក​មៃ​នៃ​ជាន​មា​គ៝ប់” ពាង់​ជី​នូយ្ស​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ជេសរី​ពាង់​ដាៈ​ឞូ​ញុប​យោឆែប​ក្រុង​តា​នតុក​ឞូ​ក្រុង​ផូង​ទោយ្ស​កាដាច់។ ទោល​យោឆែប​គុ​តា​នទ្រូង​នៃ‌ ");
INSERT INTO cmok_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ឞ្រាស​យេហោវា​ហោម​គុ​នទ្រែល​យោឆែបពាង់​ញហើ​នាវ​រ៝ង់​រាប់​ជាប់​ពាង់​នើម​អ៝ន់​មា​យោឆែប ជេសរី​ជាន​អ៝ន់​កោរាញ​នទ្រូង​នៃ​កើប​ពាង់​គែស​នាវ​ខ្លៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ជេសរី​កោរាញ​នទ្រូង​នៃ​អ៝ន់​មា​យោឆែប​ទើយ​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ឞូនុយ្ស​ទោយ្ស​តា​ត្រោម​នទ្រូង​នៃ នទ្រែល​មា​ម៝ស​នទើ​នាវ​ជាន​ការ​តា​ត្រោម​នទ្រូង​នៃ​យោឆែប​ដ៝ង់​ទើយ​ម៝ត់​អ្វាញ់។ ");
INSERT INTO cmok_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","កោរាញ​នទ្រូង​នៃ​ពាង់​មោ​ហោម​អោស​មឹន​រាវៃ​ម៝ស​ការ​យោឆែប​ជាន យ៝រ​លាស​ឞ្រាស​យេហោវា​គុ​នទ្រែល​ពាង់ លែៈ​ការ​ពាង់​ជាន​ជេង​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ជេស​គែស​នាវ​នៃ គែស​ឞារ​ហៃ​ឞូនុយ្ស​ជាន​ការ​មា​កាដាច់​អេឆីប  ទូ​ហ្វេ​ឞូនុយ្ស​ជាន​ការ​ញអោត​ងោរ​នទ្រាញ់ ទូ​ហ្វេ​ជឹត​ឞូនុយ្ស​ជាន​ការ​ញអោត​នុមពាង់។ ខាន់​ពាង់​ជាន​តីស​មា​កាដាច់​កោរាញ​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","កាដាច់​ផារ៝ន​ជី​នូយ្ស​ហោ​ងាន់​មា​លែៈ​ឞារ​ហៃ​កោរាញ​នៃ ទូ​ហ្វេ​ឞូនុយ្ស​ញអោត​ងោរ​នទ្រាញ់ ទូ​ហ្វេ​ជឹត​ឞូនុយ្ស​ញអោត​នុមពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","នទ្រី​ពាង់​ដាៈ​ឞូ​ញុប​ឞារ​ហៃ​ខាន់​ពាង់​នៃ​ក្រុង​តា​ត្រោម​នទ្រូង​កោរាញ​ម៝ត់​ញជ្រាង់​កាដាច់ នតុក​នទ្រូង​ឞូ​ក្រុង​យោឆែប​រី​នើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","កោរាញ​ម៝ត់​ញជ្រាង់​ញជុន​ឞារ​ហៃ​ខាន់​ពាង់​នៃ​ដាៈ​យោឆែប​ឆើម​ជាន​ការ​មា​ខាន់​ពាង់ ទោល​ខាន់​ពាង់​គុ​ជ៝ៈ​នារ​តា​ត្រោម​នទ្រូង​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","គែស​ទូ​មាង់​រី លែៈ​ឞារ​ហៃ​កោរាញ​គែស​នទ្រូង​នៃ​មឞើយ​ទាទេ ទូ​ហ្វេ​ឞូនុយ្ស​ជាន​ការ​ញអោត​ងោរ​នទ្រាញ់ នទ្រែល​មា​ទូ​ហ្វេ​ជឹត​ឞូនុយ្ស​ជាន​ការ​ញអោត​នុមពាង់ យើន​មា​នាវ​មឞើយ​ខាន់​ពាង់​នៃ​គែស​នាវ​ខ្លៃ​អេង​ឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ត៝ត់​អា​អោយ យោឆែប​ហាន់​ម៝ប់​ខាន់​ពាង់ ឆៃ​មុស​មាត់​ខាន់​ពាង់​ញ៝​រឹ​ញឹ។ ");
INSERT INTO cmok_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ជេសរី​ពាង់​អោប​ឞារ​ហៃ​កោរាញ​ជាន​ការ​អ៝ន់​មា​ផារ៝ន ឞូ​ទែ​ក្រុង​នទ្រែល​មា​ពាង់​តា​ត្រោម​នទ្រូង​កោរាញ​ពាង់​នើម​នៃ ពាង់​លាស៖ “នារ​អ្យា​ម៝ស​លើស​ខាន់​មៃ​ញ៝​រឹ​ញឹ​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ខាន់​ពាង់​មឞើស​មា​ពាង់៖ “ហេន​គែស​មឞើយ យើន​មា​មោ​គែស​អោស​ឞូនុយ្ស​ទើយ​ឆើម​រាឞ្លាង​នាវ​មឞើយ​នៃ”។ យោឆែប​លាស​មា​ខាន់​ពាង់៖ “គែស​កោរាញ​ឞ្រាស​ទើម​ទើយ​ឆើម​រាឞ្លាង​នាវ​មឞើយ! ទាន់​ខាន់​មៃ​មឞើស​ងក៝ច​នាវ​មឞើយ​នៃ​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ជេសរី​ឞូនុយ្ស​ញអោត​ងោរ​នទ្រាញ់​មា​កាដាច់​នៃ​មឞើស​ងក៝ច​នាវ​មឞើយ​ពាង់​មា​យោឆែប ពាង់​លាស៖ “គ៝ប់​មឞើយ​កើត​នអា៖ គែស​តើម​ព្លៃ​យុងយារ​ប៝ន​ទូ​តើម​ឞើស​នាប់​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","តើម​ព្លៃ​យុងយារ​ប៝ន​នៃ​គែស​ងគីង​ពែ​អឹ​មោ​អោស​គែស​នហា ជេសរី​ទោ​មា​ចាត់​ងក៝ត កាវ​ពាង់​ទាង ជេសរី​គែស​ព្លៃ​ទុម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ទោល​នៃ​ងោរ​កាដាច់​ផារ៝ន​គ៝ប់​ញអោត​តា​តី​គ៝ប់ គ៝ប់​ពែៈ​ព្លៃ​យុងយារ​ប៝ន​មពែត​តា​ត្រោម​ងោរ​ពាង់​រី ជេសរី​គ៝ប់​នទឹ​ងោរ​នៃ​អ៝ន់​តា​តី​កាដាច់​ផារ៝ន”។ ");
INSERT INTO cmok_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","យោឆែប​លាស​មា​ពាង់៖ “មឞើយ​មៃ​នៃ​កើត​នអា​នាវ​រាឞ្លាង៖ ងគីង​ពែ​អឹ​នៃ ជេង​ពែ​នារ។ ");
INSERT INTO cmok_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ហោម​ពែ​នារ​ជឹត កាដាច់​ផារ៝ន​អ៝ន់​មៃ​លោស​ឞើស​នតុក​អ្យា ពាង់​អ៝ន់​មៃ​ជាន​ការ​កើត​អើម មៃ​ញអោត​ងោរ​នទ្រាញ់​តា​តី​ពាង់ កើត​មៃ​លែៈ​ជាន​ការ​មា​ពាង់​ឞើស​នតើម​នើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ត៝ត់​មៃ​លែៈ​អ្វែស​លាង់​ដាប់​មពាន់​តៃ ទាន់​លើយ​ច្វេល​មា​គ៝ប់ ទាន់​មៃ​យោៈ​នអាច​មឞើស​ងក៝ច​នាវ​គ៝ប់​អ៝ន់​ផារ៝ន​គឹត ជេសរី​ទាន់​ឆ៝ៈ​គ៝ប់​លោស​ឞើស​នតុក​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","យ៝រ​លាស​ឞូ​ញុប​គ៝ប់​តាៈ​ឞើស​ផូង​ហេឞ្រើ នទ្រា​មា​ញុប​ទើម គ៝ប់​គុ​តា​ឞ្រី​អ្យា​មោ​ដ៝ង់​ម៝ប់​ជាន​តីស ឞូ​ញុប​គ៝ប់​ក្រុង​តា​ត្រោម​នទ្រូង​ច្រាវ”។ ");
INSERT INTO cmok_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ត៝ត់​មា​កោរាញ​ញអោត​នុមពាង់​ឆៃ​តា​នាវ​មឞើយ​នៃ​គែស​នាវ​អ្វែស ជេសរី​ពាង់​លាស​មា​យោឆែប៖ “គ៝ប់​មឞើយ​កើត​នអា​មេៈ៖ គ៝ប់​គែស​ពែ​ញជើ​នុមពាង់​តា​កាលើ​ឞោក​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","តា​ញជើ​កាលើ​ទុត​រី​គែស​នុម​អាប់​នតីល​ផារ៝ន​វៃ​ឆា យើន​មា​គែស​ឆ្យុម​ហាន់​ច៝ក​លើយ​នុម​តា​ញជើ​ឞោក​គ៝ប់​រី​លែៈ​ផ្យៅ”។ ");
INSERT INTO cmok_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","យោឆែប​លាស​មា​ពាង់៖ “មឞើយ​មៃ​នៃ​កើត​នអា​នាវ​រាឞ្លាង៖ ញជើ​ពែ​អឹ​នៃ ជេង​ពែ​នារ។ ");
INSERT INTO cmok_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ហោម​ពែ​នារ​ជឹត ផារ៝ន​ក៝ស​ត៝ង​ក៝​មៃ យោង​មៃ​តា​តើម​ឆី ជេសរី​គែស​ឆ្យុម​ហាន់​ច៝ក​ឆា​ឆាក់​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ត៝ត់​ពែ​នារ​នៃ ជេង​ទី​នារ​កាដាច់​ផារ៝ន​ជាន​នទ្រាប់​ញេត​ងកាស​នារ​ទែស​ពាង់​នើម ពាង់​ក្វាល់​ទឹង​លែៈ​ផូង​កោរាញ​ពាង់។ កាដាច់​ដាៈ​ឞូ​ក្វាល់​កោរាញ​ញអោត​ងោរ​នទ្រាញ់ នទ្រែល​មា​កោរាញ​ញអោត​នុមពាង់​អ៝ន់​គុ​តា​ងក្លាង​ផូង​កោរាញ​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","កាដាច់​អ៝ន់​កោរាញ​ញអោត​ងោរ​នទ្រាញ់​នៃ អ៝ន់​ពាង់​ជាន​ការ​តៃ​កើត​ពាង់​ឞើស​នតើម។ ");
INSERT INTO cmok_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","យើន​មា​កាដាច់​ដាៈ​ឞូ​យោង​ក៝​កោរាញ​ញអោត​នុមពាង់​នៃ ជេង​តឹម​ទី​កើត​នាវ​យោឆែប​ទែ​រាឞ្លាង​មា​ខាន់​ពាង់​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ល៝ង់​កោរាញ​ញអោត​ងោរ​នទ្រាញ់​នៃ ពាង់​ច្វេល​ក្លាក់​ទើម មោ​ហោម​អោស​កាស​គឹត​មា​យោឆែប។ ");
INSERT INTO cmok_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ត៝ត់​គែស​ឞារ​នាម់​ឞើស​កើយ​នៃ កាដាច់​ផារ៝ន​មឞើយ​កើត​នអា៖ ពាង់​ទ៝ក់​កេង​មែង​ទាក​រាលាយ​នីល។ ");
INSERT INTO cmok_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ពាង់​ឆៃ​គែស​ពើស​អឹ​នទ្រោក​មែ លៃៗ​អ្វែស​ងាន់ លោស​តាៈ​ឞើស​ទាក​រាលាយ ហាវ​ឆា​ជា​តា​នទ្រិច។ ");
INSERT INTO cmok_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ជេសរី​គែស​ពើស​អឹ​នទ្រោក​មែ​ដ៝ង់ លោស​តាៈ​ឞើស​ទាក​រាលាយ​ឆូ ទុត​រាគៃៗ​រូម​គ្រូម​ងាន់ ហាវ​គុ​កេង​នទ្រោក​អី​លៃៗ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","នទ្រោក​មែ​ទុត​រាគៃៗ​រូម​គ្រូម​នៃ ពាង់​ឆា​លើយ​នទ្រោក​មែ​អី​លៃៗ​អ្វែស​រី​លែៈ​ផ្យៅ។ ជេសរី​កាដាច់​ផារ៝ន​កាស​រាងាល់​ឞិច។ ");
INSERT INTO cmok_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ជេសរី​ពាង់​រើយ​ឞិច​ជឹត ពាង់​មឞើយ​តៃ​ទូ​តឹ​ជឹត។ ពាង់​មឞើយ​ឆៃ​ងក៝ង​ឞា​ពើស​រាកុម ព្លៃ​ឆាក់​រាកុម​ងាន់ អី​តើម​ពាង់​ទូ​តើម​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ជេសរី​គែស​ដ៝ង់​ងក៝ង​ឞា​ពើស​រាកុម​ជឹត លោស​ឞើស​កើយ​ឞា​ឆាក់​នៃ យើន​មា​ញឆ្យាប់​លែៈ​ផ្យៅ យ៝រ​មា​គែស​ឆ្យាល​ទោស​មពែស​ឞើស​លោស​នារ​ឞាន។ ");
INSERT INTO cmok_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ឞា​ញឆ្យាប់​នៃ ឆា​លើយ​ឞា​ឆាក់​ព្លៃ​រាកុម​លែៈ​ផ្យៅ។ ជេសរី​កាដាច់​ផារ៝ន​កាស​រាងាល់​ឞិច ងក្ល៝ន់ នៃ​ជេង​នាវ​មឞើយ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ត៝ត់​អាង​អោយ កាដាច់​ផារ៝ន​គែស​នាវ​រាវៃ​ហោ​ងាន់​តា​នូយ្ស​នហ៝ម់​ពាង់​រី ពាង់​ក្វាល់​ទឹង​លែៈ​ឞូនុយ្ស​គែស​នាវ​ឞ្លាវ​មឹន នទ្រែល​មា​ឞូ​នហុម​តា​ឞ្រី​អេឆីប ​រី​អ៝ន់​វាច់​លែៈ ជេសរី​ពាង់​មឞើស​ងក៝ច​នាវ​មឞើយ​ពាង់​នៃ​មា​ឞូ យើន​មា​មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​ទើយ​រាឞ្លាង​នាវ​មឞើយ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ទោល​នៃ​កោរាញ​អី​ញអោត​ងោរ​នទ្រាញ់ លាស​មា​កាដាច់​ផារ៝ន៖ “នារ​អ្យា​គ៝ប់​លែៈ​កាស​គឹត​នោក​គ៝ប់​តីស​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","នោក​កាដាច់​ជី​នូយ្ស​មា​ឞារ​ហៃ​ហេន​នើស ដាៈ​ឞូ​ញុប​គ៝ប់ នទ្រែល​មា​កោរាញ​ញអោត​នុមពាង់​ក្រុង​តា​ត្រោម​នទ្រូង​កោរាញ​ម៝ត់​ញជ្រាង់​កាដាច់។ ");
INSERT INTO cmok_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","លែៈ​ឞារ​ហៃ​ហេន​គែស​នាវ​មឞើយ​តា​ទូ​មាង់​ទើម យើន​មា​តា​នាវ​មឞើយ​ហេន​នៃ​គែស​នាវ​ខ្លៃ​អេង​ឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","តា​ត្រោម​នទ្រូង​នៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​នទាម់​ផូង​ហេឞ្រើ ពាង់​ជេង​ឞូនុយ្ស​ទឹក​មា​កោរាញ​ម៝ត់​ញជ្រាង់​កាដាច់ ហេន​ងក៝ច​នាវ​មឞើយ​ហេន​នៃ​មា​ពាង់ ជេសរី​ពាង់​ឆើម​រាឞ្លាង​អ៝ន់​មា​ហេន តឹង​នាវ​ហេន​មឞើយ​ទូ​ហ្វេ​ទូ​ហ្វេ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ត៝ត់​ឞើស​កើយ​នៃ​ជេង​ទី​កើត​នាវ​ពាង់​លាស​មា​ហេន​ងាន់ គ៝ប់​អ្យា​កាដាច់​អ៝ន់​ជាន​ការ​តៃ​កើត​ឞើស​នតើម ជេសរី​កោរាញ​ញអោត​នុមពាង់​កាដាច់​ដាៈ​ឞូ​យោង​ក៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ជេសរី​កាដាច់​ផារ៝ន​ដាៈ​ឞូ​ហាន់​ឆ៝ៈ​យោឆែប​នៃ​រ៝។ ឞូ​ងលោស​ពាង់​ឞើស​ត្រោម​នទ្រូង​រី ពាង់​ព៝យ្ស​តេប តើស​ខ៝​អាវ ជេសរី​ហាន់​តឹម​ម៝ប់​មា​ផារ៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ផារ៝ន​លាស​មា​យោឆែប៖ “គ៝ប់​គែស​នាវ​មឞើយ តីស​មា​មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​ទើយ​ឆើម​រាឞ្លាង។ យើន​មា​គ៝ប់​តាង់​មៃ​ទើយ​ឆើម​រាឞ្លាង លាស​មៃ​តាង់​ឞូ​ងក៝ច​មឞើយ​នៃ​មា​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","យោឆែប​លាស​មា​ផារ៝ន​នៃ៖ “មោ​ទី​គ៝ប់​អោស​ទើយ​ឆើម​រាឞ្លាង គែស​ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ទើម​ទើយ ពាង់​មរា​មឞើស​នាវ​អ្វែស​អ៝ន់​មា​មៃ​កាដាច់”។ ");
INSERT INTO cmok_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ជេសរី​ផារ៝ន​មឞើស​មា​យោឆែប៖ “គ៝ប់​មឞើយ​កើត​នអា៖ គ៝ប់​ទ៝ក់​កេង​មែង​ទាក​រាលាយ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ទោ​មា​គែស​ពើស​អឹ​នទ្រោក​មែ លៃៗ​អ្វែស​ងាន់ លោស​ឞើស​ទាក​រាលាយ​រី ហាវ​ឆា​ជា​តា​នទ្រិច​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ជេសរី​គែស​ពើស​អឹ​នទ្រោក​មែ​ជឹត លោស​តាៈ​ឞើស​ទាក​រាលាយ​រី​ដ៝ង់ ទុត​រាគៃៗ​រូម​គ្រូម​ងាន់ ឆៃ​នតោ​នទ្រែល​មា​នតីង​ទើម គ៝ប់​មោ​អោស​ព្រ៝ត​ម៝ប់​ឆៃ​នទ្រោក​ទុត​អ្យើស​កើត​នៃ​តា​ឞ្រី​អេឆីប ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","នទ្រោក​មែ​ផូង​ទុត​រាគៃៗ​រូម​គ្រូម​នៃ ពាង់​ឆា​លើយ​លែៈ​ផ្យៅ​នទ្រោក​អី​លៃៗ​លោស​ល៝រ​អី​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","នទ្រោក​មែ​ផូង​ទុត​រាគៃ​នៃ ឞ៝ល​លាស​ពាង់​ឆា​នទ្រោក​មែ​ផូង​លៃ​លែៈ​ផ្យៅ​កាដោយ​ដ៝ង់ ហោម​អែ​រាគៃ​កើត​អើម​ដ៝ង់​នទ្រោក​មែ​ផូង​ទុត​រាគៃ​នៃ ជេសរី​គ៝ប់​កាស​ព្រុស។ ");
INSERT INTO cmok_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ជេសរី​គ៝ប់​មឞើយ​តៃ​ទូ​តឹ​ជឹត ឆៃ​ងក៝ង​ឞា​ពើស​រាកុម ព្លៃ​ឆាក់​រាកុម​ងាន់ អី​តើម​ពាង់​ទូ​តើម​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ជេសរី​គែស​ដ៝ង់​ងក៝ង​ឞា​ពើស​រាកុម​ជឹត លោស​ឞើស​កើយ តីស​មា​ឞា​អី​នៃ​ខឹត​ឞូ​តោស​លែៈ​ផ្យៅ យ៝រ​មា​គែស​ឆ្យាល​ទែ​ពោស។ ");
INSERT INTO cmok_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ល៝ង់​ឞា​ញឆ្យាប់​នៃ ឆា​លើយ​ឞា​ឆាក់​រាង្លៃ​លែៈ​ផ្យៅ។ គ៝ប់​លែៈ​មឞើស​ងក៝ច​ដ៝ង់​នាវ​មឞើយ​គ៝ប់​អ្យា​មា​មពោល​ឞូ​នហុម យើន​មា​មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​ទើយ​ឆើម​រាឞ្លាង​អ៝ន់​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","យោឆែប​លាស​មា​កាដាច់​ផារ៝ន៖ “នាវ​មៃ​មឞើយ​នៃ​កាដាច់ គែស​នាវ​ខ្លៃ​ង្វាយ​ទើម កោរាញ​ឞ្រាស​មឞើស​ងក៝ច​អ៝ន់​មា​មៃ​គឹត​ម៝ស​នាវ​ពាង់​អុច​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","នតីល​នាវ​ខ្លៃ​នទ្រោក​មែ​ពើស​អឹ​លៃៗ​អី​នៃ ជេង​ពើស​នាម់ ជេសរី​ឞា​ពើស​រាកុម​ឆាក់​រាង្លៃ​អី​នៃ ជេង​ពើស​នាម់​ដ៝ង់ លែៈ​ឞារ​មឞើយ​អ្យា​ជេង​គែស​នាវ​ខ្លៃ​ង្វាយ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","នតីល​នាវ​ខ្លៃ​នទ្រោក​មែ​លោស​ឞើស​កើយ​ទុត​រាគៃ​ងាន់​អី​នៃ ជេង​ពើស​នាម់ ជេសរី​នតីល​នាវ​ខ្លៃ​ឞា​ញឆ្យាប់​យ៝រ​មា​ឆ្យាល​ឞាន​អី​នៃ ជេង​គែស​នាវ​ជី​ង៝ត​ក្វ៝ង់​ជ៝ៈ​ពើស​នាម់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","អើ​កាដាច់ ទី​កើត​នាវ​គ៝ប់​លែៈ​ជេស​មឞើស​មា​មៃ​នើស​ងាន់ កោរាញ​ឞ្រាស​មឞើស​ងក៝ច​អ៝ន់​មា​មៃ​គឹត​ម៝ស​នាវ​ពាង់​អុច​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ហោម​ពើស​នាម់ លាម​ឞ្រី​អេឆីប ​អ្យា​គែស​ព្យាង់​ឞា​អ៝ក់​រាមែស​លែរ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ជេសរី​ពើស​នាម់​ជឹត​នាប់​ជឹត គែស​នាវ​ជី​ង៝ត​ក្វ៝ង់​ងាន់ ទឹង​លែៈ​ផូង​ប៝ន​លាន​តា​ឞ្រី​អេឆីប ​មរា​ច្វេល​លែៈ​ផ្យៅ​នាវ​គែស​អ៝ក់​រាមែស​តា​ខាន់​ពាង់​នៃ​នើស យ៝រ​លាស​នាវ​ជី​ង៝ត​ក្វ៝ង់​អី​នៃ​លើស​អ្យើស​មា​ឞ្រី​ខាន់​ពាង់​អ៝ន់​ហេង​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ផូង​ប៝ន​លាន​ច្វេល​លែៈ​ផ្យៅ​នាវ​គែស​អ៝ក់​រាមែស​តា​ឞ្រី​ខាន់​ពាង់​នើម យ៝រ​លាស​នាវ​ជី​ង៝ត​អី​នៃ​លែៈ​ទុត​ហោ​អីរ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ទឹង​មៃ​មឞើយ​ឞារ​តឹ​ងាន់​អ្យា យ៝រ​លាស​លែៈ​កោរាញ​ឞ្រាស​នទ្រាប់​ជាន​ងាន់​នាវ​អ្យា ពាង់​ជាន​គើញៗ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","អាបៃ​រី​នអា​ទោស​កាដាច់៖ មៃ​ជ៝យ​ទូ​ហ្វេ​ឞូនុយ្ស​គែស​នាវ​មឹន​គឹត​ឞ្លាវ អ៝ន់​ពាង់​ជាន​កោរាញ​ម៝ត់​អ្វាញ់​តា​ឞ្រី​អេឆីប ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ជេសរី​មៃ​ជ៝យ​ឞូនុយ្ស​អេង​ដ៝ង់ គៃ​មា​រាហ្វាត់​នទើ​ទូ​កោៈ​តឹម​ព្រាម់ ទោល​ឞ្រី​ទាក​គែស​ឞា​អ៝ក់​រាមែស​តឹម​ពើស​នាម់​ជឹត​នាប់​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","មៃ​អ៝ន់​ផូង​អី​នៃ​រាគូម​ទឹង​លែៈ​ព្យាង់​ឞា​ទោល​ឞ្រី​ទាក​គែស​អ៝ក់​រាមែស​តឹម​ពើស​នាម់​អ្យា តោស​ព្រាប់​តា​ត្រោម​ជៃ​អាប់​ប៝ន ជេសរី​មៃ​នើម​ដាៈ​ឞូ​ម៝ត់​រាបៃ​ទឹង​លែៈ​នទើ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ព្យាង់​ឞា​អី​នៃ​ព្រាប់​មា​ទ៝ង់​ទោល​ឞ្រី​ទាក​គែស​នាវ​ជី​ង៝ត​ក្វ៝ង់​ពើស​នាម់​តា​ឞ្រី​អេឆីប  គៃ​មា​លើយ​អោស​អ៝ន់​ផូង​ប៝ន​លាន​ខឹត​ហ្វារ់​ជី​ង៝ត​”។ ");
INSERT INTO cmok_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","នាវ​យោឆែប​ងើយ​នៃ​ជេង​ទី​មា​នូយ្ស​នហ៝ម់​កាដាច់​ផារ៝ន​ងាន់ នទ្រែល​មា​ទឹង​លែៈ​មពោល​កោរាញ​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ជេសរី​ផារ៝ន​លាស​មា​មពោល​កោរាញ​ពាង់៖ “មោ​ហោម​គែស​ឞូនុយ្ស​អេង​រាលាវ​មា​ពាង់​អ្យា គែស​ហ្វេង​កោរាញ​ឞ្រាស​គុ​តា​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ផារ៝ន​លាស​មា​យោឆែប៖ “កោរាញ​ឞ្រាស​លែៈ​មឞើស​អ៝ន់​មា​មៃ​គឹត​នាវ​អ្យា លាស​នទ្រី​មោ​ហោម​គែស​អោស​ឞូនុយ្ស​អេង​មា​គែស​នាវ​មឹន​គឹត​ឞ្លាវ​កើត​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","គ៝ប់​អ៝ន់​មៃ​ម៝ត់​អ្វាញ់​តា​ឞ្រី​អេឆីប ​អ្យា នទ្រែល​មា​ទឹង​លែៈ​ផូង​ប៝ន​លាន​គ៝ប់ ខាន់​ពាង់​អ្យាត់​ទាទេ​នាវ​មៃ​ដាៈ។ ទឹង​គ៝ប់​ក្វ៝ង់​រាលាវ​មៃ យ៝រ​លាស​គ៝ប់​គុ​តា​រានើល​កាដាច់”។ ");
INSERT INTO cmok_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ផារ៝ន​លាស​តៃ​មា​យោឆែប៖ “អាបៃ​រី​គ៝ប់​អ៝ន់​មៃ​ទើយ​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​តា​ឞ្រី​អេឆីប ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ជេសរី​ផារ៝ន​ទ្រីស​រាគេន​ត្រា​ឞើស​តី​ពាង់​នើម​រី នទ៝ក​តា​តី​យោឆែប ឆ៝ៈ​អាវ​ទុត​អ្វែស​ឆើម​ញឆ៝ស​មា​យោឆែប​រី​ដ៝ង់ នទ្រែល​មា​ឆ៝ៈ​រាឆែ​មាយ្ស​វាន់​តា​ត៝ង​ក៝​យោឆែប​រី​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ពាង់​អ៝ន់​យោឆែប​ញច៝​រាទែស​ឆែស​កាដាច់ ញច៝​គ្រ៝យ​ឞើស​កើយ​ពាង់​នើម​រី ជេសរី​គែស​ឞូ​នតែរ​លាស៖ “ច៝ន​កោម៝ក់​មឞាស​ពាង់!” កើត​នទ្រី​នាវ​កាដាច់​ផារ៝ន​អ៝ន់​យោឆែប​ទើយ​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​តា​ឞ្រី​អេឆីប ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ផារ៝ន​លាស​តៃ​មា​យោឆែប៖ “គ៝ប់​អ្យា​កាដាច់​ផារ៝ន ទឹង​លែៈ​ឞូនុយ្ស​លាម​ឞ្រី​អេឆីប ​អ្យា លាស​មោ​លោស​នាវ​តាៈ​ឞើស​មៃ ឞូ​មោ​ទើយ​អោស​ជាន​ទូ​នតីល​នទើ”។ ");
INSERT INTO cmok_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","កាដាច់​ផារ៝ន​តេៈ​រាញា​មហែ​អ៝ន់​មា​យោឆែប «ឆាប់នាត-​ផានាស» ជេសរី​ពាង់​ឆើម​អោប​ទូ​ហ្វេ​ឞូ​អូរ​រាញា​អាសនាត ក៝ន​ផោថីផេរា​ឞូនុយ្ស​ជាន​ឞ្រាស​តា​ប៝ន​អោន គៃ​មា​នអាប់​ដាស​យោឆែប។ ទោល​នៃ​យោឆែប​ហាន់​ញឆ៝ង​អ្វាញ់​តា​ឞ្រី​អេឆីប ។ ");
INSERT INTO cmok_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","យោឆែប​លែៈ​គែស ៣០ នាម់ នោក​ពាង់​ហាន់​តឹម​ម៝ប់​ដាស​កាដាច់​ផារ៝ន ជេសរី​ពាង់​លោស​ឞើស​កាដាច់​ផារ៝ន​នៃ ហាន់​ញឆ៝ង​លាម​នតុក​តា​ឞ្រី​អេឆីប ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","នោក​ពើស​នាម់​នៃ តា​ឞ្រី​អេឆីប ​គែស​ព្យាង់​ឞា​អ៝ក់​រាមែស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","យោឆែប​ហាន់​រាគូម​ព្យាង់​ឞា​ទឹង​លែៈ​ព្យាង់​ឞា​តា​ឞ្រី​អេឆីប ​រី នោក​ព្យាង់​ឞា​គែស​អ៝ក់​រាមែស​តា​ពើស​នាម់​នៃ ពាង់​តោស​ព្យាង់​ឞា​ឞើស​មីរ​ជុម​ប៝ន​រ៝ៈ​អាប់​ប៝ន​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","យោឆែប​រាគូម​ព្យាង់​ឞា​ទុត​អ៝ក់​ងាន់ តឹម​ឞាន​មា​ច៝យ្ស​រ៝ៈ​ទាក​វាច់​ទាក​វារ់ នហ៝​មា​មោ​ហោម​អោស​ទាង់​កើប​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","នោក​នាម់​អេ​ហ៝ៈ​ត៝ត់​នាវ​ជី​ង៝ត​ក្វ៝ង់​អី​នៃ យោឆែប នទ្រែល​មា​អូរ​ពាង់​រាញា​អាសនាត​លែៈ​គែស​ក៝ន​ឞូ​ក្លោ​ឞារ​ហៃ អូរ​ពាង់​នៃ​អី​ក៝ន​ផោថីផេរា​អី​ឞូនុយ្ស​ជាន​ឞ្រាស​តា​ប៝ន​អោន។ ");
INSERT INTO cmok_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","យោឆែប​តេៈ​រាញា​មា​ក៝ន​ឞោក​ទាក​ពាង់​នៃ «មានាឆេ» យ៝រ​លាស​ពាង់​លាស៖ “លែៈ​កោរាញ​ឞ្រាស​ជាន​អ៝ន់​គ៝ប់​ច្វេល​លែៈ​ផ្យៅ​នាវ​ជេរ​ជ៝ត់​តា​គ៝ប់ នទ្រែល​មា​ច្វេល​លែៈ​ផ្យៅ​ឞើស​នទុល​មពោល​គ៝ប់​នើម​ដ៝ង់”។ «មានាឆេ» នតែស​តា​នាវ​ងើយ​ហេឞ្រើ តឹម​ឞាន​មា​នាវ​«អ៝ន់​ច្វេល»។ ");
INSERT INTO cmok_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ពាង់​តេៈ​រាញា​មា​ក៝ន​ត៝ល់​ឞារ «អេប្រាអីម» យ៝រ​លាស​ពាង់​លាស៖ “លែៈ​កោរាញ​ឞ្រាស​អ៝ន់​គែស​ក៝ន​មា​គ៝ប់ នតុក​គ៝ប់​គែស​នាវ​ជេរ​អ្យា”។ «អេប្រាអីម» នតែស​តា​នាវ​ងើយ​ហេឞ្រើ តឹម​ឞាន​មា​នាវ​«អ៝ន់​គែស​ក៝ន»។ ");
INSERT INTO cmok_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ពើស​នាម់​នាវ​គែស​អ៝ក់​រាមែស​តា​ឞ្រី​អេឆីប ​នៃ​លែៈ​លោច​ជេស‌ ");
INSERT INTO cmok_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ជេសរី​នតើម​គែស​នាវ​ជី​ង៝ត​ក្វ៝ង់​ពើស​នាម់ កើត​នាវ​យោឆែប​លែៈ​លាស​នើស​ងាន់។ ទឹង​លែៈ​ឞ្រី​ទាក​អេង​គែស​នាវ​ជី​ង៝ត​ក្វ៝ង់​ទាទេ ហោម​តា​ឞ្រី​អេឆីប ​អី​រី​ទើម​ហោម​គែស​នទើ​ឆោង​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ត៝ត់​ផូង​ប៝ន​លាន​តា​ឞ្រី​អេឆីប ​នតើម​មោ​គែស​នទើ​ឆោង​ឆា ជេសរី​ខាន់​ពាង់​លែវ​ឞាល់​ហាន់​ទាន់​ព្យាង់​ឞា​តា​កាដាច់​ផារ៝ន ពាង់​លាស​មា​ផូង​ប៝ន​លាន​នៃ៖ “ខាន់​មៃ​ហាន់​ម៝ប់​យោឆែប​រី​ទោ អ្យាត់​ម៝ស​នាវ​ពាង់​ដាៈ”។ ");
INSERT INTO cmok_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ទោល​នៃ​នាវ​ជី​ង៝ត​ក្វ៝ង់​លែៈ​លាម​ឞ្រី​អេឆីប ​ងាន់។ យោឆែប​ពើក​ទឹង​លែៈ​ជៃ​ឞា​រ៝ៈ​ប៝ន​អេងៗ​រ៝ គៃ​មា​តាច់​ឞា​អ៝ន់​មា​ផូង​ប៝ន​លាន​អេឆីប  យ៝រ​លាស​នាវ​ជី​ង៝ត​ក្វ៝ង់​អី​នៃ​លើ​មា​ហោ​ងាន់​តា​ឞ្រី​អេឆីប ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ឞូនុយ្ស​ទឹង​លែៈ​ឞ្រី​ហាន់​រាវាត់​ឞា​យោឆែប​តា​ឞ្រី​អេឆីប ​រី​ទាទេ យ៝រ​លាស​នាវ​ជី​ង៝ត​ក្វ៝ង់​អី​នៃ​លើ​មា​ហោ​លាម​នែស​នតូ​អ្យា​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ត៝ត់​មា​យាកោប​លែៈ​គឹត​តា​ឞ្រី​អេឆីប ​រី​គែស​ឞា ជេសរី​ពាង់​លាស​មា​អ៝ស​ក៝ន​ពាង់៖ “មើម​គុ​ខាន់​មៃ​រ៝ង់​គ៝ង់​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ពាង់​លាស​តៃ​មា​ខាន់​ពាង់៖ “គ៝ប់​តាង់​តា​ឞ្រី​អេឆីប ​រី​គែស​ឞា​តាច់។ លាស​នទ្រី​ខាន់​មៃ​ហាន់​តា​ឞ្រី​នៃ​ទោ រាវាត់​ឞា​គៃ​មា​ឞ៝ន់​រេស លើយ​អ៝ន់​ខឹត​ជី​ង៝ត​ឆា”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ជេសរី​ជឹត​នុយ្ស​អី​នោៗ​យោឆែប​ហាន់​រាវាត់​ឞា​តា​ឞ្រី​អេឆីប ​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","យើន​មា​យាកោប​មោ​អោស​អ៝ន់​បែនយាមឹន​អី​អ៝ស​យោឆែប​ហាន់​នទ្រែល​នោៗ​ពាង់ យ៝រ​លាស​ក្លាច​គែស​នាវ​ត៝ត់​ជេរ​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ជេសរី​អី​ក៝នៗ​យាកោប​អី​ឞូ​ក្វាល់​អីឆ្រាអែល​ដ៝ង់ ហាន់​រាវាត់​ឞា​នទ្រែល​ឞូ​អាបាៈ​អេង​ដ៝ង់ យ៝រ​លាស​តា​ឞ្រី​កានាន​អី​នៃ​គែស​នាវ​ជី​ង៝ត​ក្វ៝ង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ទោល​នៃ​យោឆែប​ជាន​កោរាញ​ក្វ៝ង់​ម៝ត់​អ្វាញ់​តា​ឞ្រី​អេឆីប  ពាង់​អី​នៃ​ដ៝ង់​តើម​តាច់​ឞា​អ៝ន់​ទឹង​លែៈ​ផូង​ប៝ន​លាន​លាម​ឞ្រី។ អី​នោៗ​ពាង់​ហាន់​ត៝ត់​តា​រី​ពាន់​មឞាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","យោឆែប​នាល់​អី​នោៗ​ពាង់​រ៝ យើន​មា​មោ​អោស​អ៝ន់​អី​នោៗ​នាល់​ពាង់។ ពាង់​ងើយ​ជាញ​មា​ខាន់​ពាង់៖ “ឞើស​តាៈ​ខាន់​មៃ?” ខាន់​ពាង់​អើស៖ “អើ​កោរាញ ហេន​អ្យា​តាៈ​ឞើស​ឞ្រី​កានាន ហាន់​ជ៝យ​រាវាត់​នទើ​ឆោង​ឆា”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","យោឆែប​នាល់​ខាន់​ពាង់ យើន​មា​ខាន់​ពាង់​មោ​អោស​គឹត​នាល់​យោឆែប។ ");
INSERT INTO cmok_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ទោល​នៃ​យោឆែប​កាស​គឹត​នាវ​មឞើយ​មា​អី​នោៗ​ពាង់​ពាន់​មឞាស​មា​ពាង់។ ពាង់​លាស​មា​អី​នោៗ​ពាង់៖ “ខាន់​មៃ​ជេង​ឞូនុយ្ស​ហាន់​មេត​អ្វាញ់​តា​ឞ្រី​អ្យា​ទើម គៃ​មា​អ្វាញ់​នតុក​មោ​គែស​តាហែន​អ៝ក់”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ខាន់​ពាង់​អើស៖ “មោ​អោស​កោរាញ ហេន​អ្យា​អី​ឞូនុយ្ស​ឆើម​ជាន​ការ​មា​មៃ ហាន់​រាវាត់​នទើ​ឆោង​ឆា​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ទឹង​លែៈ​ហេន​អ្យា​ទូ​ឞឹ​ឞាៈ​ទើម ហេន​ជេង​ឞូនុយ្ស​ឆ៝ង់​ងាន់ មោ​គែស​អោស​ឞូនុយ្ស​ហាន់​មេត​អ្វាញ់​នតុក​”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ពាង់​អើស៖ “ខាន់​មៃ​មរោស! ខាន់​មៃ​ហាន់​តា​អ្យា​គៃ​មា​មេត​អ្វាញ់​នតុក​មោ​គែស​តាហែន​អ៝ក់​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ខាន់​ពាង់​អើស៖ “អើ​កោរាញ ទឹង​លែៈ​អ៝ស​នោ​ហេន​គែស ១២ នុយ្ស ជេង​ទូ​ឞឹ​ឞាៈ​ទើម ហេន​គុ​តា​ឞ្រី​កានាន។ អាបៃ​អ្យា​អ៝ស​ទុត​ហេន​ហោម​គុ​នទ្រែល​ឞឹ​ហេន ជេសរី​អ៝ស​ហេន​ទូ​ហ្វេ​រី​លែៈ​ខឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","យើន​មា​យោឆែប​លាស​មា​ខាន់​ពាង់៖ “ទី​កើត​នាវ​គ៝ប់​លាស​ងាន់ ខាន់​មៃ​អ្យា​ជេង​ឞូនុយ្ស​ហាន់​មេត​អ្វាញ់​នតុក! ");
INSERT INTO cmok_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","គ៝ប់​អុច​រាល៝ង​មា​ខាន់​មៃ៖ គ៝ប់​ត៝ន​មា​ខាន់​មៃ​តា​កាដាច់​ផារ៝ន លាស​អ៝ស​ខាន់​មៃ​មោ​ត៝ត់​តា​អ្យា ខាន់​មៃ​មោ​ទើយ​អោស​លោស​ឞើស​នតុក​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ខាន់​មៃ​អ៝ន់​ទូ​ហ្វេ​ហាន់​ឆ៝ៈ​អ៝ស​ទុត​ខាន់​មៃ​ឞើស​រី ខាន់​មៃ​អាបាៈ​នៃ​ក្រុង​តា​អ្យា​ប៝ត់ យ៝រ​លាស​គ៝ប់​អុច​គឹត​ខាន់​មៃ​ងើយ​ងាន់​លាស​មោ។ លាស​មោ​ងាន់ គ៝ប់​ត៝ន​តា​កាដាច់​ផារ៝ន ខាន់​មៃ​ជេង​ឞូនុយ្ស​ហាន់​មេត​អ្វាញ់​នតុក​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ជេសរី​យោឆែប​ដាៈ​ឞូ​ក្រុង​អី​នោៗ​ពាង់​រី​ពែ​នារ។ ");
INSERT INTO cmok_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ត៝ត់​ពែ​នារ យោឆែប​ងើយ​មា​ខាន់​ពាង់៖ “លាស​ខាន់​មៃ​អុច​រេស ខាន់​មៃ​ជាន​កើត​នអា​ទោ យ៝រ​លាស​គ៝ប់​ជេង​ឞូនុយ្ស​ក្លាច​យើក​កោរាញ​ឞ្រាស៖ ");
INSERT INTO cmok_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","លាស​ខាន់​មៃ​ជេង​ឞូនុយ្ស​ឆ៝ង់​ងាន់ ខាន់​មៃ​អ៝ន់​ទូ​ហ្វេ​តា​មពោល​ខាន់​មៃ​នៃ​ក្រុង​តា​អ្យា ជេសរី​ខាន់​មៃ​អាបាៈ​នៃ​ហាន់​ឆឹត​តា​ឞ្រី​ខាន់​មៃ​នើម នទ្រែល​មា​ញអោត​លែវ​ព្យាង់​ឞា​មា​គែស​នទើ​ឆោង​ឆា​តា​រានាក់​វ៝ល់​មា​ឞាស​ជី​ង៝ត។ ");
INSERT INTO cmok_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ជេសរី​លែវ​អ៝ស​ទុត​ខាន់​មៃ​ហាន់​តា​អ្យា គៃ​មា​គឹត​នាវ​ខាន់​មៃ​ងើយ​នៃ​ជេង​ងើយ​ងាន់។ នទ្រី​ខាន់​មៃ​មោ​ខឹត​អោស”។ ខាន់​ពាង់​ជាន​កើត​នៃ‌ ");
INSERT INTO cmok_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ជេសរី​ខាន់​ពាង់​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ “ឆៃ​បាស ឞ៝ន់​តីស​យ៝រ​មា​ឞ៝ន់​ជាន​អ្យើស​មា​អ៝ស​ឞ៝ន់​នើស​រ៝ យ៝រ​លាស​ឞ៝ន់​ឆៃ​ពាង់​ទុត​រាង៝ត​ងាន់​ទាន់​ឞ៝ន់​កើល​ពាង់ តីស​មា​ឞ៝ន់​មោ​អោស​អ្យាត់​ពាង់។ កើត​នទ្រី​ទឹង​នាវ​ជេរ​អ្យា​គែស​តា​មពោល​ឞ៝ន់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","រូបេន​លាស​មា​ខាន់​ពាង់៖ “លែៈ​គ៝ប់​លាស​មា​ខាន់​មៃ​នើស លើយ​ងខឹត​ពាង់ ខាន់​មៃ​មោ​អ្យាត់​នាវ​គ៝ប់។ អាបៃ​អ្យា​ទឹង​ឞ៝ន់​គែស​នាវ​ជេរ យ៝រ​មា​ឞ៝ន់​លែៈ​ញចាយ​មហាម​អ៝ស​ឞ៝ន់​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ខាន់​ពាង់​មោ​គឹត​អោស​លាស​យោឆែប​អ្យាត់​នាវ​ខាន់​ពាង់​ងើយ​នៃ​គឹត​ទាទេ យ៝រ​លាស​នោក​ពាង់​ងើយ​មា​ខាន់​ពាង់​គែស​ឞូនុយ្ស​ឆើម​រាឞ្លាង​អ៝ន់។ ");
INSERT INTO cmok_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","យោឆែប​ទូ​ឞើស​នតុក​ខាន់​ពាង់​នៃ​ញុម​អេង ជេសរី​ពាង់​ព្លឹ​ងើយ​តៃ​ដាស​ខាន់​ពាង់។ ពាង់​ឆ៝ៈ​ឆីមោន​ក៝ត់​តា​នាប់​មាត់​អ៝ស​នោ​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","យោឆែប​ដាៈ​ឞូ​ត៝ល់​មឞេង​ឞា​អ៝ន់​មា​នោៗ​ពាង់ នអ៝ប់​មា​មព្លឹ​ព្រាក់​តេៈ​តា​ទុង​ព្រាក់​តា​ត្រោម​បៅ​ខាន់​ពាង់​នើម​ដ៝ង់ នទ្រែល​មា​អ៝ន់​នទើ​ខាន់​ព្រែ​មា​ឆោង​ឆា​រ៝ៈ​ត្រ៝ង​ជឹត។ ឞូ​ជាន​មា​ខាន់​ពាង់​កើត​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ខាន់​ពាង់​ទាប់​ឞា​តា​កាលើ​ឆែស​លៀ​ខាន់​ពាង់​នើម​រី ជេសរី​ហាន់​ឆឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ត៝ត់​តា​នតុក​រាលូ​រ៝ៈ​ត្រ៝ង​រី គែស​ទូ​ហ្វេ​តា​មពោល​ខាន់​ពាង់​រី​ទ្រីស​បៅ ឆ៝ៈ​មពា​គៃ​មា​អ៝ន់​ឆែស​លៀ​ឆា ពាង់​ឆៃ​ទុង​ព្រាក់​តា​ឞ៝រ់​បៅ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ពាង់​មឞើស​មា​អ៝ស​នោ​ពាង់៖ “អ្វាញ់​អ្យាៈ ព្រាក់​គ៝ប់​លែៈ​ឞូ​មព្លឹ ឞូ​អ៝ន់​តា​ត្រោម​បៅ​អ្យា”។ ទោល​នៃ​ទឹង​លែៈ​ខាន់​ពាង់​នទ្រ៝ត់​ទាទេ ខាន់​ពាង់​ក្លាច​ញឆ៝រ់​ងាន់ ជេសរី​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ “មើម​កោរាញ​ឞ្រាស​ជាន​មា​ឞ៝ន់!” ");
INSERT INTO cmok_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ជេសរី​ខាន់​ពាង់​ឆឹត​ត៝ត់​តា​ឞ្រី​កានាន​តា​ឞឹ​ខាន់​ពាង់​នើម​រី ខាន់​ពាង់​មឞើស​ងក៝ច​អ៝ន់​មា​ឞឹ​ខាន់​ពាង់​នើម ម៝ស​នាវ​គែស​តា​ខាន់​ពាង់​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ខាន់​ពាង់​លាស៖ “កោរាញ​ម៝ត់​អ្វាញ់​តា​ឞ្រី​អេឆីប ​នៃ​ងើយ​ទុត​ជាញ​ងាន់​មា​ហេន នទ្រែល​មា​នតោន​ហេន​ជេង​ឞូនុយ្ស​ហាន់​មេត​អ្វាញ់​នតុក​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","យើន​មា​ហេន​អើស​មា​ពាង់៖ «ហេន​អ្យា​ជេង​ឞូនុយ្ស​ឆ៝ង់ មោ​អោស​ទី​ឞូនុយ្ស​ហាន់​មេត​អ្វាញ់​នតុក។ ");
INSERT INTO cmok_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ហេន​គែស ១២ នុយ្ស​អ៝ស​នោ ហេន​ទូ​ឞឹ​ឞាៈ​ទើម អ៝ស​ហេន​ទូ​ហ្វេ​លែៈ​ខឹត ហោម​អ៝ស​ទុត​គុ​នទ្រែល​ឞឹ​ហេន​តា​ឞ្រី​កានាន​រី»។ ");
INSERT INTO cmok_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","កោរាញ​ម៝ត់​អ្វាញ់​តា​ឞ្រី​អេឆីប ​នៃ​លាស​មា​ហេន​កើត​នអា៖ «អាបៃ​អ្យា​នអា​ទោ គៃ​មា​គឹត​នាវ​ខាន់​មៃ​ងើយ​នៃ​ងើយ​ងាន់​លាស​មោ៖ ខាន់​មៃ​អ៝ន់​ទូ​ហ្វេ​ឞូនុយ្ស​តា​មពោល​ខាន់​មៃ​នៃ​គុ​តា​អ្យា ខាន់​មៃ​អាបាៈ​នៃ​ហាន់​ឆឹត​តា​ឞ្រី​ខាន់​មៃ​នើម​រី នទ្រែល​មា​ញអោត​លែវ​ព្យាង់​ឞា​អ៝ន់​មា​រានាក់​វ៝ល់​ខាន់​មៃ​នើម​អា​រី​មា​ឞាស​ជី​ង៝ត​ទោ។ ");
INSERT INTO cmok_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ជេសរី​លែវ​អ៝ស​ទុត​ខាន់​មៃ​ឞើស​រី​ហាន់​តឹម​ម៝ប់​នទ្រែល​គ៝ប់។ កើត​នទ្រី​ទឹង​គ៝ប់​គឹត​លាស​ខាន់​មៃ​ជេង​ឞូនុយ្ស​ឆ៝ង់ មោ​អោស​ទី​ឞូនុយ្ស​ហាន់​មេត​អ្វាញ់​នតុក។ តៃ​ទឹង​គ៝ប់​បើក​ឞូនុយ្ស​អ្យា ជេសរី​ខាន់​មៃ​ហាន់​រាឆ៝ង​រាវាត់​នទើ​តា​ឞ្រី​អ្យា​មោ​ច្រាវ​អោស»”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ត៝ត់​មា​ខាន់​ពាង់​ងខុត​បៅ​ឞា អាប់​នើម​ខាន់​ពាង់ ខាន់​ពាង់​ឆៃ​ទុង​ព្រាក់​តា​ត្រោម​បៅ​ឞា​ខាន់​ពាង់​នើម​រី​ទាទេ។ ត៝ត់​មា​ឆៃ​ទុង​ព្រាក់​អី​នៃ ខាន់​ពាង់ នទ្រែល​មា​ឞឹ​ខាន់​ពាង់​ក្លាច​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","យាកោប​អី​ឞឹ​រី​លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ជាន​អ៝ន់​គ៝ប់​រ៝ស​លែៈ​ក៝ន យោឆែប​រ៝ស ឆីមោន​រ៝ស អាបៃ​អ្យា​ខាន់​មៃ​អុច​ឆ៝ៈ​បែនយាមឹន​ហាន់​ជឹត ជាន​អ៝ន់​គ៝ប់​អោស​នូយ្ស​អោស​នហ៝ម់​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","រូបេន​លាស​មា​ឞឹ​ពាង់៖ “អើ​ឞឹ លាស​គ៝ប់​មោ​អោស​លែវ​បែនយាមឹន​ព្លឹ​ញឆឹត​អ៝ន់​មៃ មៃ​ងខឹត​លើយ​ទោ​ក៝ន​ឞូ​ក្លោ​គ៝ប់​ឞារ​ហៃ​នៃ! មៃ​អ៝ន់​ពាង់​ហាន់​នទ្រែល​គ៝ប់ ឞឹ តៃ​គ៝ប់​លែវ​ពាង់​ព្លឹ​ឆឹត​មា​មៃ​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","យើន​មា​យាកោប​លាស៖ “គ៝ប់​មោ​អោស​អ៝ន់​ក៝ន​ងគ្លែៈ​ទុត​គ៝ប់​ហាន់​នទ្រែល​ខាន់​មៃ យ៝រ​លាស​នោ​ពាង់​លែៈ​ខឹត​ដ៝ង់ ហោម​អែ​ទូ​ហ្វេ​ពាង់​ទើម។ លាស​ម៝ស​គែស​នាវ​ម៝ស​រាមាន​រ៝ៈ​ត្រ៝ង​ទោល​ពាង់​ហាន់​នទ្រែល​ខាន់​មៃ​នៃ លាស​នទ្រី​ជាន​អ៝ន់​គ៝ប់​លែៈ​រាញ​ងាន់​អ្យា​ខឹត យ៝រ​មា​ក្ល៝ង់​រាង៝ត​ហោ​អីរ​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","នាវ​ជី​ង៝ត​ក្វ៝ង់​តា​ឞ្រី​កានាន​នៃ​លើ​មា​ហោ​លើ​មា​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ត៝ត់​មា​លែៈ​ឆា​ឞា​រាវាត់​តាៈ​ឞើស​ឞ្រី​អេឆីប ​នៃ​នើស យាកោប​លាស​មា​អ៝ស​ក៝ន​ពាង់៖ “ហាន់​ព្លឹ​រាវាត់​តៃ​ឞា​អាបាៈ​តា​ឞ្រី​អេឆីប ​រី​ហ៝ម់”។ ");
INSERT INTO cmok_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","យូដា​អើស​មា​ឞឹ​ពាង់៖ “ឞូនុយ្ស​អី​នៃ​លាស​មា​ហេន​នអា​ងាន់៖ «លាស​ខាន់​មៃ​មោ​លែវ​អ៝ស​ទុត​ខាន់​មៃ​ហាន់​តា​អ្យា គ៝ប់​មោ​អ៝ន់​ខាន់​មៃ​ម៝ប់​គ៝ប់​អោស»។ ");
INSERT INTO cmok_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","អើ​ឞឹ លាស​មៃ​អ៝ន់​ពាង់​ហាន់​នទ្រែល​ហេន នទ្រី​មើ​ទឹង​ហេន​ហាន់​រាវាត់​ឞា។ ");
INSERT INTO cmok_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","យើន​មា​លាស​មៃ​មោ​អ៝ន់​ពាង់​ហាន់ ហេន​មោ​ហាន់​ដ៝ង់ យ៝រ​លាស​ឞូនុយ្ស​នៃ​លែៈ​លាស​មា​ហេន៖ «លាស​ខាន់​មៃ​មោ​លែវ​អ៝ស​ទុត​ខាន់​មៃ​ហាន់​តា​អ្យា គ៝ប់​មោ​អ៝ន់​ខាន់​មៃ​ម៝ប់​គ៝ប់​អោស!»” ");
INSERT INTO cmok_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","អីឆ្រាអែល​អី​ឞូ​ក្វាល់​យាកោប​ដ៝ង់​លាស​មា​ខាន់​ពាង់៖ “ហៃ ម៝ស​ញជោ​លាស​ខាន់​មៃ​ជាន​អ្យើស​មា​គ៝ប់ មឞើស​ងក៝ច​មា​ឞូនុយ្ស​នៃ​លាស​ហោម​គែស​អ៝ស​ទុត​ទូ​ហ្វេ​ហៃ!” ");
INSERT INTO cmok_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ខាន់​ពាង់​អើស៖ “ឞូនុយ្ស​អី​នៃ​អោប​ហេន​ហាច់​មពឹ​លឹ​នតីល​ងាន់ នទ្រែល​មា​អោប​នទុល​មពោល​ឞ៝ន់ ពាង់​លាស៖ «ឞឹ​ខាន់​មៃ​ហោម​រេស​ដ៝ង់? ខាន់​មៃ​ហោម​គែស​អ៝ស​នោ​ដ៝ង់?» ជេង​ហេន​អើស​កើត​នាវ​ពាង់​អោប​នៃ អើម​ហេន​គឹត​លាស​ពាង់​ដាៈ​អ៝ស​ហាន់​តា​ឞ្រី​អេឆីប ​លាស?” ");
INSERT INTO cmok_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","យូដា​ទាន់​មា​អីឆ្រាអែល​ឞឹ​ពាង់​រី៖ “អើ​ឞឹ មៃ​អ៝ន់​អ៝ស​នៃ​ហាន់​នទ្រែល​គ៝ប់​ទោ។ នទ្រី​ហេន​ហាន់​អាបៃ​អ្យា​រ៝ គៃ​មា​ឞ៝ន់​រេស លើយ​អ៝ន់​ខឹត នអ៝ប់​មា​មៃ នអ៝ប់​មា​ឆៅៗ​មៃ នអ៝ប់​មា​ហេន​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","គ៝ប់​ឞាញ់​ត៝ន​ពាង់​មា​មៃ លាស​មោ​អោស​ឆៃ​គ៝ប់​ញជុន​ពាង់​មា​មៃ លាស​នទ្រី​គ៝ប់​គែស​ទោយ្ស​ដាស​មៃ​លែៈ​ទូ​ញជារ់​រេស​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","លាស​ហេន​មោ​គុ​ញជ៝ង ហេន​ឞ្រោៈ​លែៈ​គែស​ឞារ​តឹ​ព្លឹ​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ទុត​មា​ទេល​អីឆ្រាអែល​អី​ឞឹ​រី​លាស​មា​ខាន់​ពាង់៖ “លាស​នទ្រី​នអា​ទោ ខាន់​មៃ​ញអោត​នទើ​ទុត​អ្វែស​តាៈ​ឞើស​ឞ្រី​ឞ៝ន់​អ្យា​អ៝ន់​មា​ឞូនុយ្ស​អី​នៃ​បាៈ ខាន់​មៃ​ញអោត​នទើ​បោ​កាស​អាប់​នតីល​បាៈ ទាក​ឆុត​បាៈ នអ៝ប់​មា​គារ់​តោស​អាប់​នតីល​បាៈ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ខាន់​មៃ​ញអោត​ព្រាក់​តា​ឆាក់​អ៝ន់​អ៝ក់​រាលាវ​ខាន់​មរែ​ឞើស​នាប់​នើស​ឞារ​តឹ ព្រាក់​អី​មា​រាវាត់​តៃ​ឞា នទ្រែល​មា​ព្រាក់​អី​ខាន់​មៃ​ឆៃ​តា​បៅ​នើស​ដ៝ង់ ក្លាប់​លាស​ឞូ​វិ​ទាប់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ជេសរី​លែវ​អ៝ស​ខាន់​មៃ​នៃ​ហាន់​អាបៃ​អ្យា​ម៝ប់​ឞូនុយ្ស​អី​រី​ហ៝ម់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ទាន់​កោរាញ​ឞ្រាស​នើម​អី​ទុត​គែស​នាវ​ទើយ​ជាន​អ៝ន់​មា​ឞូនុយ្ស​នៃ​គែស​នាវ​យោៈ​នអាច​មា​ខាន់​មៃ គៃ​មា​បើក​អ៝ន់​ឆីមោន នទ្រែល​បែនយាមឹន​ព្លឹ​ឆឹត​នទ្រែល​មា​ខាន់​មៃ​ដ៝ង់។ គ៝ប់​អ្យា​លាស​មោ​ហោម​គែស​ក៝ន ផាលាស​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ជេសរី​ខាន់​ពាង់​ញអោត​នទ៝ស​នទើ​នៃ នអ៝ប់​មា​ព្រាក់​អ៝ក់​ឞារ​តឹ នទ្រែល​មា​លែវ​បែនយាមឹន​ដ៝ង់ ហាន់​តា​ឞ្រី​អេឆីប  ហាន់​តឹម​ម៝ប់​ដាស​យោឆែប​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ត៝ត់​តា​ឞ្រី​អេឆីប យោឆែប​ឆៃ​បែនយាមឹន​ហាន់​នទ្រែល​នោៗ​ពាង់ ពាង់​លាស​មា​ឞូនុយ្ស​ម៝ត់​អ្វាញ់​ញីស​ជៃ​ពាង់​រី៖ “លែវ​ខាន់​ពាង់​លាប់​តា​ជៃ​គ៝ប់ ជេសរី​មឞាង​មពោមពា​(ឆ្យុម)​ជាន​ត្រាវ យ៝រ​លាស​ទឹង​លែៈ​ខាន់​ពាង់​អី​នៃ​ឆោង​នារ​នទ្រែល​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ពាង់​ជាន​កើត​នាវ​យោឆែប​ទែ​ដាៈ​មា​ពាង់ ជេសរី​លែវ​ខាន់​ពាង់​អី​នៃ​ហាន់​លាប់​តា​ជៃ​យោឆែប។ ");
INSERT INTO cmok_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ខាន់​ពាង់​ក្លាច​ហោ​ងាន់ ឆៃ​ឞូ​លែវ​លាប់​តា​ជៃ​យោឆែប ខាន់​ពាង់​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ “ទឹង​ឞូ​ញជុន​ឞ៝ន់​ហាន់​តា​អ្យា​អា យ៝រ​មា​ព្រាក់​តា​ត្រោម​បៅ​នើស​រ៝។ ឞូ​លែវ​ឞ៝ន់​ហាន់​តា​អ្យា​អា យ៝រ​លាស​ឞូ​គៃ​មា​តេៈ​ទោយ្ស​ឞ៝ន់ គៃ​មា​ឆ៝ៈ​លើយ​ឆែស​លៀ​ឞ៝ន់ នហ៝​មា​ឆ៝ៈ​ឞ៝ន់​គុ​ជាន​ទឹក​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ត៝ត់​តា​ឞោក​មពោង​ជៃ​រី ខាន់​ពាង់​ហាន់​ទាច់​មា​ឞូនុយ្ស​ម៝ត់​អ្វាញ់​ញីស​ជៃ​យោឆែប ជេសរី​ងើយ​ដាស​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“អើ​កោរាញ នារ​ឞើស​កើយ​នើស​ហេន​ហាន់​រាវាត់​ឞា​តា​អ្យា​លែៈ​ទូ​តឹ។ ");
INSERT INTO cmok_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ហេន​ឆឹត​ត៝ត់​តា​នតុក​រាលូ​រី ហេន​ទ្រីស​បៅ ឆៃ​ទុង​ព្រាក់​តា​ត្រោម​បៅ​ឞា​ហេន​នើម​រី​ទាទេ រឹង​កើត​អើម។ នារ​អ្យា​ហេន​ញអោត​តៃ​ព្រាក់​នៃ​នទឹ​មា​មៃ‌ ");
INSERT INTO cmok_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","យ៝រ​លាស​ហេន​មោ​គឹត ឞូ​ម៝ស​តេៈ​ព្រាក់​នៃ​តា​ត្រោម​បៅ​ឞា​ហេន។ ជេសរី​ហេន​ញអោត​តៃ​ព្រាក់​អា​អេង​ជឹត​មា​រាវាត់​តៃ​ឞា”។ ");
INSERT INTO cmok_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ឞូ​ក្លោ​អី​នៃ​អើស​មា​ខាន់​ពាង់៖ “លើយ​អោស​រាវៃ គុ​ដាប់​មពាន់​ហ៝ៈ កោរាញ​ឞ្រាស​ខាន់​មៃ​នើម កោរាញ​ឞ្រាស​ឞឹ​ខាន់​មៃ​នើម​ឆើម​អ៝ន់​ព្រាក់​នៃ​តា​ត្រោម​បៅ​ខាន់​មៃ។ យ៝រ​លាស​ព្រាក់​ខ្លៃ​ខាន់​មៃ​រាវាត់​ឞា​នើស​លែៈ​រឹង​តា​គ៝ប់​អ្យា​ទាទេ”។ ជេសរី​ពាង់​បើក​ឆីមោន​អ៝ន់​គុ​នទ្រែល​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ជេសរី​ពាង់​លែវ​ខាន់​ពាង់​អី​នៃ​លាប់​តា​ត្រោម​ជៃ​យោឆែប​រី ឆើម​ឆ៝ៈ​ទាក​អ៝ន់​ខាន់​ព្រែ​មា​រាវ​ជ៝ង់ នទ្រែល​មា​ឆ៝ៈ​មពា​មា​អ៝ន់​ឆែស​លៀ​ខាន់​ពាង់​ទែ​ឆា​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ខាន់​ពាង់​លែៈ​នទ្រាប់​លើយ​ទឹង​លែៈ​នទើ​មា​អ៝ន់​យោឆែប ទោល​គុ​ក៝ប់​យោឆែប​ត៝ត់​តា​នៃ យ៝រ​លាស​ខាន់​ពាង់​លែៈ​គឹត​ខាន់​ពាង់​គុ​ឆោង​នារ​តា​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ត៝ត់​ឆឹត​យោឆែប​តា​ជៃ​រី ទឹង​លែៈ​ខាន់​ពាង់​ឆ៝ៈ​នទើ​នៃ​ញជុន​អ៝ន់​មា​យោឆែប ជេសរី​ពាន់​មឞាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","យោឆែប​អោប​នាវ​អ្វែស​លាង់​ខាន់​ពាង់៖ “អា​ល៝រ​នើស​ខាន់​មៃ​មឞើស​មា​គ៝ប់​លាស​គែស​ឞឹ​លែៈ​រាញ​ងាន់ អាស​អ្វែស​លាង់​ដ៝ង់​ពាង់? ពាង់​ហោម​រេស​ដ៝ង់​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ខាន់​ពាង់​អើស៖ “ឞឹ​ហេន​ហោម​រេស កោរាញ​មេ ពាង់​អ្វែស​លាង់​ដ៝ង់”។ ជេស​មឞើស​នៃ ខាន់​ពាង់​ពាន់​មឞាស​ពាង់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ជេសរី​យោឆែប​អ្វាញ់​ឆៃ​បែនយាមឹន អ៝ស​ទូ​នទុល​ទែស​ដាស​ពាង់​នើម ពាង់​អោប​ខាន់​ពាង់៖ “អ្យា​អ៝ស​ទុត​ខាន់​មៃ​មឞើស​ងក៝ច​មា​គ៝ប់​នើស​បាស? ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​មៃ​អ៝ស”។ ");
INSERT INTO cmok_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","យោឆែប​រាង៝ត​ហោ​ងាន់​ឆៃ​អ៝ស​ពាង់ ជេសរី​ពាង់​ហាន់​ញុម​តា​ត្រោម​ជ្រោ​ពាង់​នើម​រី យ៝រ​លាស​ពាង់​មោ​អោស​ទើយ​អ៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ពាង់​រាពោស​មុស​មាត់​ផ្យៅ លោស​អា​ទីស​អ្យា ពាង់​ញឆ្រោយ្ស​អ៝ត់​ងាន់ ជេសរី​ដាៈ​ឞូ​ពឺ​ព្យាង់​ត្រាវ។ ");
INSERT INTO cmok_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ឞូ​ពឺ​ព្យាង់​ត្រាវ​មា​យោឆែប​អ៝ន់​អេង ផូង​អេឆីប ​អី​គុ​តា​រី​គុ​ឆោង​អេង មពោល​អ៝ស​នោ​ពាង់​រី​អ៝ន់​គុ​ឆោង​អេង។ នាវ​វៃ​តា​ផូង​អេឆីប ​មោ​អោស​អ៝ន់​ឆោង​នទ្រែល​ផូង​ហេឞ្រើ យ៝រ​លាស​ខាន់​ពាង់​អ្វាញ់​នាវ​នៃ​បឹ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","មពោល​អ៝ស​នោ​យោឆែប​គុ​ឆោង​រាលែ​មាត់​ជឹត​ពាង់​រី​ទាទេ ឞូ​អ៝ន់​ខាន់​ពាង់​គុ​តឹង​ឞោក​នោ នតើម​ឞើស​នោ​ឞោក​ទាក ត៝ត់​មា​អ៝ស​ទុត ទឹង​លែៈ​ខាន់​ពាង់​នទ្រ៝ត់​ទាទេ​ងាន់ មោ​វ៝ត់​អោស​មើម​ទឹង​ឞូ​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","យោឆែប​ដាៈ​ឞូ​ឆ៝ៈ​នទើ​ឆា​ឞើស​នាប់​ពាង់​នើម​រី អ៝ន់​មា​មពោល​អ៝ស​នោ​ពាង់ យើន​មា​បែនយាមឹន​ឞូ​អ៝ន់​អ៝ក់​រាលាវ​ព្រាម់​តឹ​ដាស​មា​ខាន់​ពាង់​អាបាៈ។ ខាន់​ពាង់​ញេត​ឆោង​នទ្រែល​យោឆែប​មអាក​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ជេសរី​យោឆែប​ដាៈ​មា​ឞូនុយ្ស​អី​ម៝ត់​អ្វាញ់​ញីស​ជៃ​ពាង់​នៃ៖ “ត៝ល់​អ៝ន់​ឞេងៗ​បៅ​ខាន់​ពាង់ ទាស​ទើយ​ខាន់​ពាង់​ញអោត ជេសរី​តេៈ​ទុង​ព្រាក់​ខាន់​ពាង់​នើម​តា​ត្រោម​បៅ​ខាន់​ពាង់​នើម​ទូ​ហ្វេ​ទូ​ហ្វេ។ ");
INSERT INTO cmok_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","មៃ​អ្វាញ់​ឞូ​ម៝ស​អី​ក៝ន​ឆែ​រាលាវ​ឞូ​អី​រី ជេសរី​មៃ​តេៈ​ងោរ​ព្រាក់​គ៝ប់​អ្យា​តា​ត្រោម​បៅ​ពាង់ នទ្រែល​មា​ព្រាក់​ខ្លៃ​រាវាត់​ឞា​នៃ​នើស”។ ឞូនុយ្ស​អី​នៃ​ជាន​កើត​នាវ​យោឆែប​ទែ​ដាៈ​មា​ពាង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ត៝ត់​អាង​អោយ ឞូ​អ៝ន់​ខាន់​ពាង់​ហាន់ នទ្រែល​មា​ឆែស​លៀ​ខាន់​ពាង់​នើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ខាន់​ពាង់​លោស​ឞើស​ប៝ន​នៃ​អេ​ហ៝ៈ​ងាយ​អោស យោឆែប​លាស​មា​ឞូនុយ្ស​ម៝ត់​អ្វាញ់​ញីស​ជៃ​ពាង់៖ “តឹង​ហ៝ម់​ផូង​អ្យា​អ៝ន់​ត៝ត់​ឞាន ត៝ត់​ឞាន​ខាន់​ពាង់​មៃ​លាស​កើត​នអា៖ «ម៝ស​ខាន់​មៃ​ជាន​កើត​នអៃ ឞូ​លែៈ​ជាន​អ្វែស​មា​ខាន់​មៃ ខាន់​មៃ​ជាន​អ្យើស​មា​ឞូ​ច្រាវ? ");
INSERT INTO cmok_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ខាន់​មៃ​គឹត​បាស? ងោរ​នៃ​កោរាញ​គ៝ប់​វៃ​ទ៝ង់​មា​ញេត នទ្រែល​មា​នាវ​ច្រ៝ង់ ខាន់​មៃ​ជាន​កើត​នៃ​គែស​ទោយ្ស​ជ្រូ​ងាន់»”។ ");
INSERT INTO cmok_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ជេសរី​ឞូនុយ្ស​នៃ​តឹង​ខាន់​ពាង់​ត៝ត់​ឞាន ពាង់​លាស​ខាន់​ពាង់​អី​នៃ​កើត​នាវ​យោឆែប​ទែ​ដាៈ​មា​ពាង់​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ខាន់​ពាង់​តឹម​អើស​ដាស​ពាង់៖ “ម៝ស​មៃ​លាស​ហេន​កើត​នទ្រី​រី​កោរាញ? ហេន​មោ​អោស​គែស​ជាន​កើត​នាវ​មៃ​លាស​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ព្រាក់​ហេន​ឆៃ​តា​ត្រោម​បៅ​ហេន​នើស លែៈ​ហេន​ញអោត​មព្លឹ​អ៝ន់​មៃ​តាៈ​ឞើស​ឞ្រី​កានាន លាស​នទ្រី​មើម​ហេន​ហោម​ឞ្លាវ​នតុង​ដ៝ង់​ព្រាក់​មាយ្ស​តា​ត្រោម​ជៃ​កោរាញ​មៃ? ");
INSERT INTO cmok_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","លាស​នទ្រី​ឞូ​ម៝ស​ឞូនុយ្ស​មៃ​ឆៃ​ជ៝យ​ងោរ​អី​នៃ​តា​មពោល​ហេន​អ្យា ឞូនុយ្ស​អី​នៃ​មៃ​ងខឹត​លើយ​ទោ ជេសរី​ឆ៝ៈ​ទឹង​លែៈ​ហេន​អ្យា​គុ​ជាន​ទឹក​មា​មៃ​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ឞូនុយ្ស​នៃ​អើស​មា​ខាន់​ពាង់៖ “អើ លាស​នទ្រី​ជាន​កើត​នាវ​ខាន់​មៃ​លែៈ​លាស​រី​ទោស ឞូ​ម៝ស​បៅ​គ៝ប់​ឆៃ​ងោរ​នៃ ឞូនុយ្ស​អី​នៃ​អ៝ន់​គុ​ជាន​ទឹក​គ៝ប់ ឞូនុយ្ស​អាបាៈ​មោ​ហោម​ដ៝ង់​អោស​គែស​ទោយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ជេសរី​ទឹង​លែៈ​ខាន់​ពាង់​ញជុរ​បៅ​អា​នែស​ទាទេ​រ៝ ទ្រីស​បៅ​អី​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ឞូ​នុយ្ស​នៃ​រាហី​អ្វាញ់​នតើម​ឞើស​បៅ​នោ​ឞោក​ទាក នហ៝​មា​ត៝ត់​បៅ​អ៝ស​ទុត ពាង់​ឆៃ​ងោរ​អី​នៃ​តា​ត្រោម​បៅ​បែនយាមឹន។ ");
INSERT INTO cmok_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ល៝ង់​អី​នោៗ​រី រាង៝ត​ហោ​ងាន់ ងខេក​ឞ៝ក​អាវ​ខាន់​ពាង់​នើម ពឺ​ទ្រាប់​នទើ​ទាប់​តា​កាលើ​ឆែស​លៀ ជេសរី​ព្លឹ​តៃ​តា​ប៝ន​យោឆែប​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","យូដា​នទ្រែល​មា​អ៝ស​នោ​ពាង់​ព្លឹ​ជឹត​កើយ ត៝ត់​តា​ជៃ​យោឆែប​រី ឆៃ​ពាង់​ហោម​តា​នៃ​ដ៝ង់។ ខាន់​ពាង់​ពាន់​តា​នែស​តា​នាប់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","យោឆែប​លាស​មា​ខាន់​ពាង់៖ “ម៝ស​ខាន់​មៃ​ជាន​កើត​នអៃ ខាន់​មៃ​មោ​គឹត​បាស គ៝ប់​អ្យា​ជេង​ឞូនុយ្ស​ឞ្លាវ​ច្រ៝ង់​ងាន់?” ");
INSERT INTO cmok_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","យូដា​អើស​មា​ពាង់៖ “ហេន​មោ​ហោម​អោស​គែស​នាវ​អើស​មា​កោរាញ​ដ៝ង់ ហេន​មោ​ហោម​គែស​នាវ​ងើយ​ដ៝ង់ យ៝រ​លាស​លែៈ​កោរាញ​ឞ្រាស​ញហើ​ជេស​នាវ​តីស​ហេន អាបៃ​អ្យា​ទឹង​លែៈ​ហេន​អ្យា នទ្រែល​មា​ឞូនុយ្ស​នតុង​ងោរ​អី​នៃ ហេន​គុ​ជាន​ទឹក​មា​កោរាញ”។ ");
INSERT INTO cmok_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","យោឆែប​អើស​មា​ខាន់​ពាង់៖ “គ៝ប់​មោ​អោស​ជាន​កើត​នអៃ ឞូ​ម៝ស​បៅ​ឆៃ​ងោរ ឞូនុយ្ស​អី​នៃ​ទូ​ហ្វេ​ទើម​គ៝ប់​ឆ៝ៈ​ជាន​ទឹក។ ខាន់​មៃ​អាបាៈ​នៃ​ព្លឹ​ឆឹត​តា​រានាក់​វ៝ល់ តា​ឞឹ​ខាន់​មៃ​នើម​រី​មា​នាវ​ដាប់​មពាន់​ទោ”។ ");
INSERT INTO cmok_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","យូដា​ហាន់​ទាច់​អា​យោឆែប​ងើយ​មា​ពាង់៖ “អើ​កោរាញ ទាន់​មៃ​យោៈ​នអាច​មា​គ៝ប់ លើយ​ជី​នូយ្ស​មា​គ៝ប់ អ៝ន់​គ៝ប់​ងើយ​ដាស​មៃ​ទូ​ត៝ង មៃ​តឹម​ឞាន​មា​កាដាច់​ផារ៝ន​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","មៃ​លែៈ​អោប​ហេន៖ «ខាន់​មៃ​គែស​ឞឹ គែស​អ៝ស​ដ៝ង់?» ");
INSERT INTO cmok_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ហេន​លែៈ​មឞើស​ងក៝ច​មា​មៃ៖ «ហេន​គែស​ឞឹ​លែៈ​រាញ​ងាន់ នទ្រែល​មា​អ៝ស​ទុត​ទូ​ហ្វេ នោក​ទែស​ពាង់​អី​នៃ​ឞឹ​ហេន​លែៈ​រាញ អី​នោ​ពាង់​លែៈ​ខឹត​ដ៝ង់ ទូ​មេៈ​ឞាៈ​ពាង់​ហោម​ពាង់​អី​នៃ​ទូ​ហ្វេ​ទើម ឞឹ​ហេន​រ៝ង់​មា​ពាង់​អី​នៃ​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","មៃ​លែៈ​លាស​មា​ហេន៖ «លែវ​ពាង់​ហាន់​តា​គ៝ប់​អ្យា គ៝ប់​ឞែ​មា​ឆៃ​មុស​មាត់​ពាង់»។ ");
INSERT INTO cmok_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ជេសរី​ហេន​លែៈ​មឞើស​ងក៝ច​មា​មៃ៖ «អ៝ស​ហេន​អី​នៃ​មោ​អោស​ទើយ​បាស​ងាយ​ដាស​ឞឹ​ហេន លាស​បាស​ងាយ​ឞឹ​ហេន​ខឹត​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","មៃ​លែៈ​លាស​មា​ហេន​អី​ឞូនុយ្ស​ឆើម​ជាន​ការ​មា​មៃ៖ «លាស​អ៝ស​ទុត​ខាន់​មៃ​មោ​អោស​ហាន់​តា​អ្យា ខាន់​មៃ​មោ​ម៝ប់​មុស​មាត់​គ៝ប់​ជឹត»។ ");
INSERT INTO cmok_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ត៝ត់​ហេន​ព្លឹ​ឆឹត​អា​ឞឹ​ហេន​រី ហេន​មឞើស​ងក៝ច​នាវ​មៃ​លាស​នៃ​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ឞឹ​ហេន​លាស​មា​ហេន៖ «ខាន់​មៃ​ហាន់​ព្លឹ​រាវាត់​តៃ​ឞា​អាបាៈ​អ៝ន់​មា​ឞ៝ន់​ជឹត»។ ");
INSERT INTO cmok_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ហេន​អើស​មា​ពាង់៖ «ហេន​មោ​ទើយ​អោស​ហាន់ អ៝ស​ទុត​អី​នៃ​ហាន់​នទ្រែល​ហេន នទ្រី​មើ​ទឹង​ហេន​ហាន់​ព្លឹ​រាវាត់​តៃ លាស​ពាង់​អី​នៃ​មោ​ហាន់​នទ្រែល​ហេន ឞូ​មោ​អោស​អ៝ន់​ហេន​ហាន់​ម៝ប់​មុស​មាត់​ឞូនុយ្ស​អី​រី​»។ ");
INSERT INTO cmok_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ជេសរី​ឞឹ​ហេន​លាស​មា​ហេន៖ «ខាន់​មៃ​លែៈ​គឹត​ដ៝ង់ អូរ​គ៝ប់​ឞាៈ​ក៝ន​មា​គ៝ប់​ក៝ន​ឞូ​ក្លោ​ឞារ​អឹ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ក៝ន​ង្វាយ​លែៈ​រ៝ស​ដ៝ង់ គ៝ប់​មឹន​លាស​លែៈ​មពោមពា​(ឆ្យុម)​ឞ្រី​ឆា​ហេក​លែៈ​ផ្យៅ​រ៝ គ៝ប់​មោ​ហោម​អោស​ឆៃ​មុស​មាត់​ពាង់ នហ៝​មា​ត៝ត់​នារ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","អាបៃ​អ្យា​ខាន់​មៃ​អុច​ឆ៝ៈ​ពាង់​អី​នៃ​លែវ​ហាន់​អា​រី​ដ៝ង់ លាស​គែស​នាវ​ម៝ស​រាមាន​ត៝ត់​ជេរ​មា​ពាង់ ខាន់​មៃ​ជាន​អ៝ន់​គ៝ប់​អី​លែៈ​រាញ​ងាន់​អ្យា​ខឹត យ៝រ​មា​នាវ​អ្យើស»។ ");
INSERT INTO cmok_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","អាបៃ​អ្យា​លាស​ហេន​ឆឹត​ម៝ប់​ឞឹ​ហេន លាស​អ៝ស​ហេន​អី​នៃ​មោ​ហាន់​នទ្រែល​ហេន យ៝រ​លាស​ឞូនុយ្ស​អី​នៃ​ឞឹ​ហេន​រ៝ង់​ហោ​ងាន់‌ ");
INSERT INTO cmok_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","លាស​មោ​ឆៃ​ពាង់ ឞឹ​ហេន​ខឹត​ងាន់​រ៝។ លាស​នទ្រី​ហេន​ជាន​អ៝ន់​ឞឹ​ហេន​លែៈ​រាញ​ខឹត យ៝រ​មា​ក្ល៝ង់​រាង៝ត​ហោ​អីរ។ ");
INSERT INTO cmok_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","គ៝ប់​លែៈ​ត៝ន​មា​ឞឹ​គ៝ប់៖ «លាស​គ៝ប់​មោ​លែវ​ពាង់​ព្លឹ​ឆឹត​មា​មៃ​ឞឹ គ៝ប់​គែស​ទោយ្ស​មា​មៃ​លែៈ​ទូ​ញជារ់​នាវ​រេស​គ៝ប់»។ ");
INSERT INTO cmok_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","អើ​កោរាញ លាស​នទ្រី​ទាន់​មៃ​អ៝ន់​គ៝ប់​គុ​ជាន​ទឹក​មា​មៃ​តា​អ្យា​ត្រ៝ៈ​អ៝ស​គ៝ប់។ មៃ​អ៝ន់​ពាង់​អី​នៃ​ព្លឹ​ឆឹត​នទ្រែល​អ៝ស​នោ​គ៝ប់​អា​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","លាស​មៃ​មោ​អ៝ន់​ពាង់​អី​នៃ​ឆឹត​នទ្រែល​គ៝ប់ មើម​គ៝ប់​ឞាញ់​ហាន់​ម៝ប់​ឞឹ​គ៝ប់? យ៝រ​លាស​គ៝ប់​មោ​អុច​ឆៃ​នាវ​រាង៝ត​ឞឹ​គ៝ប់​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","យោឆែប​មោ​ហោម​អោស​ទើយ​អ៝ត់​រាទ៝ង់​នូយ្ស​នហ៝ម់​តា​នាប់​ផូង​គុ​កេង​ពាង់​រី ជេសរី​ពាង់​ដាៈ​ឞូ​ទូ​លោស​ឞើស​នតុក​នៃ​លែៈ​ផ្យៅ។ នោក​យោឆែប​ញហើ​ឆាក់​ពាង់​នើម​អ៝ន់​មា​អ៝ស​នោ​ពាង់​នាល់ ឞូ​អាបាៈ​មោ​អោស​គុ​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","យោឆែប​ញុម​លុង​ល៝ច​ងាន់ តាង់​ត៝ត់​តា​ផូង​អេឆីប  នទ្រែល​មា​ផូង​គុ​តា​ជៃ​កាដាច់​ផារ៝ន​រី​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","យោឆែប​លាស​មា​អ៝ស​នោ​ពាង់៖ “គ៝ប់​អ្យា​យោឆែប! អាស​ឞឹ​គ៝ប់​ហោម​រេស​ដ៝ង់?” មពោល​អ៝ស​នោ​ពាង់​មោ​ហោម​អោស​ឞ្លាវ​អើស ខាន់​ពាង់​ក្លាច​ទាទេ យ៝រ​លាស​លែៈ​ឆៃ​យោឆែប​ឞើស​នាប់​ខាន់​ពាង់​នើម​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","យោឆែប​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​ទាន់​ខាន់​មៃ​ហាន់​ទាច់​អា​គ៝ប់​អ្យា” ខាន់​ពាង់​ហាន់​ទាច់​អា​យោឆែប​ត៝។ ជេសរី​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​អ្យា​យោឆែប​អ៝ស​ខាន់​មៃ អី​ខាន់​មៃ​តាច់​អ៝ន់​មា​ផូង​អេឆីប ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","អើ​នោ ខាន់​មៃ​លើយ​រាវៃ លើយ​ហោម​អោស​រាង៝ត​នាវ​ខាន់​មៃ​លែៈ​តាច់​គ៝ប់​អ្យា​នើស យ៝រ​លាស​ជេង​កោរាញ​ឞ្រាស​នើម​ញជុន​អ៝ន់​គ៝ប់​ហាន់​ល៝រ​តា​អ្យា គៃ​មា​កើល​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ល៝ង់​អាបៃ​អ្យា​នាវ​ជី​ង៝ត​ក្វ៝ង់​អី​នៃ​លែៈ​គែស​ឞារ​នាម់ យើន​មា​ហោម​ព្រាម់​នាម់​ជឹត​នាប់​ជឹត មោ​អោស​គែស​ឞូនុយ្ស​មា​តូច​តាម់ មា​កាច់​រ៝យ្ស។ ");
INSERT INTO cmok_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","កោរាញ​ឞ្រាស​ញជុន​អ៝ន់​គ៝ប់​ហាន់​ល៝រ​តា​អ្យា គៃ​មា​រាគូម​ព្រាប់​ព្យាង់​ឞា​មា​អ៝ន់​ខាន់​មៃ​ហោម​រេស​តា​នែស​នតូ​អ្យា អ្យា​ជេង​នាវ​រាក្លាយ្ស​ទុត​ក្វ៝ង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","លាស​នទ្រី​មោ​គែស​អោស​ខាន់​មៃ​ញជុន​គ៝ប់​ហាន់​តា​អ្យា កោរាញ​ឞ្រាស​អី​នាក់​ញជុន​គ៝ប់ កោរាញ​ឞ្រាស​អ៝ន់​គ៝ប់​ជាន​កោរាញ​ទុត​ក្វ៝ង់​មា​កាដាច់​ផារ៝ន អ៝ន់​គ៝ប់​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​តា​ញីស​ជៃ​ពាង់ នទ្រែល​មា​អ៝ន់​គ៝ប់​ជាន​កោរាញ​ម៝ត់​អ្វាញ់​លាម​ឞ្រី​អេឆីប ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","អើ​នោ ខាន់​មៃ​ហាន់​ព្លឹ​អា​ឞឹ​រី​អ៝ន់​គើញ​ហ៝ម់ មឞើស​ងក៝ច​មា​ពាង់​កើត​នអា៖ «អើ​ឞឹ យោឆែប​ក៝ន​មៃ​ទាន់​នតិញ កោរាញ​ឞ្រាស​អ៝ន់​ក៝ន​ជាន​កោរាញ​ម៝ត់​អ្វាញ់​លាម​ឞ្រី​អេឆីប  ទាន់​ឞឹ​ហាន់​តឹម​ម៝ប់​ដាស​ក៝ន​តា​អ្យា​រ៝ លើយ​អោស​ក៝ប់​ជ៝ៈ។ ");
INSERT INTO cmok_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","មៃ​គុ​តា​ឞ្រី​កោឆែន​តឹម​ទាច់​ដាស​នតុក​គ៝ប់​គុ នអ៝ប់​មា​មៃ​នើម នអ៝ប់​មា​ក៝ន​មា​ឆៅ​មៃ នអ៝ប់​មា​នទ្រោក​មា​ឞែ​ឞ្យាប់​មៃ នទ្រែល​មា​ទឹង​លែៈ​នទើ​មៃ​គែស។ ");
INSERT INTO cmok_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","តៃ​គ៝ប់​ពេត​ឆ្យាម់​មៃ​តា​ឞ្រី​អី​នៃ នទ្រែល​មា​រានាក់​វ៝ល់​មៃ មោ​អោស​អ៝ន់​ខាន់​មៃ​ខឹត​ជី​ង៝ត​ឆា យ៝រ​លាស​ហោម​ព្រាម់​នាម់​ជឹត​នាវ​ជី​ង៝ត​ក្វ៝ង់​អ្យា»។ ");
INSERT INTO cmok_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","អើ​នោ ទឹង​លែៈ​ខាន់​មៃ នទ្រែល​មា​អ៝ស​បែនយាមឹន​លែៈ​ឆៃ​ជេស​គ៝ប់​តា​អ្យា គ៝ប់​ងាន់​ងើយ​នទ្រែល​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","អើ​នោ ខាន់​មៃ​មឞើស​ងក៝ច​មា​ឞឹ​ឞ៝ន់​រី​តៃ ទឹង​លែៈ​នាវ​ទើយ​គ៝ប់​ជាន​តា​ឞ្រី​អេឆីប ​អ្យា នទ្រែល​មា​ទឹង​លែៈ​នទើ​ខាន់​មៃ​លែៈ​ឆៃ។ អ៝ន់​គើញ​ខាន់​មៃ​លែវ​ឞឹ​ហាន់​តា​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","យោឆែប​អូត​បែនយាមឹន​នហ៝​មា​ញុម​តា​អ៝ស​ពាង់​រី បែនយាមឹន​កើត​នទ្រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","យោឆែប​អូត​នោៗ​ពាង់​ទឹង​លែៈ ញុម​ដ៝ង់ ជេសរី​ខាន់​ពាង់​តឹម​មឞើស​ងើយ​ងក៝ច​ឞ្រី​ដាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","នាវ​អី​នៃ​តាង់​ត៝ត់​តា​ជៃ​កាដាច់​ផារ៝ន​រី​ងាន់ លាស​អ៝ស​នោ​យោឆែប​លែៈ​ត៝ត់​តា​រី ផារ៝ន នទ្រែល​មា​ផូង​កោរាញ​ពាង់​រាម់​មអាក​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","កាដាច់​ផារ៝ន​លាស​មា​យោឆែប៖ “មៃ​លាស​មា​អ៝ស​នោ​មៃ​កើត​នអា៖ «នទ្រាប់​ឆែស​លៀ​ខាន់​មៃ​នៃ​ព្លឹ​ឆឹត​ហ៝ម់​តា​ឞ្រី​កានាន​រី‌ ");
INSERT INTO cmok_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ជេសរី​លែវ​ឞឹ នទ្រែល​មា​រានាក់​វ៝ល់​ខាន់​មៃ​ហាន់​តា​អ្យា តៃ​គ៝ប់​អ៝ន់​នតុក​អ្វែស​រាលាវ​ឞូ​តា​ឞ្រី​អេឆីប ​អ្យា​មា​ខាន់​មៃ ជេសរី​ខាន់​មៃ​ឆា​នទើ​អី​កាស​រាលាវ​ឞូ​ដ៝ង់​តា​ឞ្រី​អ្យា»។ ");
INSERT INTO cmok_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","មៃ​លាស​ដ៝ង់​មា​ខាន់​ពាង់៖ «អ៝ន់​ខាន់​មៃ​ញអោត​រាទែស​ឞើស​ឞ្រី​អេឆីប ​អ្យា​មា​ញច្វាន់​រាទែង​អូរ​ក៝ន​ខាន់​មៃ នទ្រែល​មា​ឞឹ​ខាន់​មៃ​ហាន់​តា​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","លើយ​អោស​ពើស​ទ្រាប់​នទើ​ខាន់​មៃ យ៝រ​លាស​នទើ​អ្វែស​រាលាវ​ឞូ​តា​ឞ្រី​អេឆីប ​អ្យា​ជេង​នទើ​ខាន់​មៃ»”។ ");
INSERT INTO cmok_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ជេសរី​មពោល​អ៝ស​ក៝ន​អីឆ្រាអែល​ជាន​តឹង​កើត​នៃ។ យោឆែប​ឆ៝ៈ​រាទែស​អ៝ន់​មា​ខាន់​ពាង់​កើត​នាវ​ផារ៝ន​លាស​មា​ពាង់ នទ្រែល​មា​អ៝ន់​នទើ​ខាន់​ពាង់​ឆោង​ឆា​រ៝ៈ​ត្រ៝ង​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","យោឆែប​អ៝ន់​ឞ៝ក​អាវ​មហែ​មា​នោៗ​ពាង់​ទូ​ឞ្លាស​ទូ​ហ្វេ​ទូ​ហ្វេ យើន​មា​ពាង់​អ៝ន់​ព្រាក់​មា​បែនយាមឹន ៣០០ កាក់​ព្រាក់ នទ្រែល​មា​ព្រាម់​ឞ្លាស​ឞ៝ក​អាវ។ ");
INSERT INTO cmok_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ពាង់​ញជ្វាល់​នទើ​មា​ឞឹ​ពាង់ ឆែស​លៀ​ជឹត​អឹ គែស​នអ៝ប់​មា​នទើ​អ្វែសៗ​តាៈ​ឞើស​ឞ្រី​អេឆីប  ឆែស​លៀ​មែ​ជឹត​អឹ គែស​នអ៝ប់​មា​ឞា​ទាប់​តា​កាលើ​រី នទ្រែល​មា​នទើ​អ៝ន់​ឞឹ​ពាង់​ឆោង​ឆា​រ៝ៈ​ត្រ៝ង​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ជេសរី​យោឆែប​អ៝ន់​អ៝ស​នោ​ពាង់​ឆឹត នហ៝​មា​នតិញ​ខាន់​ពាង់៖ “លើយ​តា​ខាន់​មៃ​តឹម​រាលាច់​តឹម​ល៝ក់​រ៝ៈ​ត្រ៝ង​រី​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ខាន់​ពាង់​លោស​ឞើស​ឞ្រី​អេឆីប  ឆឹត​តា​យាកោប​ឞឹ​ខាន់​ពាង់​នើម តា​ឞ្រី​កានាន​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ត៝ត់​តា​ឞ្រី​នៃ ខាន់​ពាង់​មឞើស​ងក៝ច​មា​ឞឹ​ខាន់​ពាង់៖ “ក៝ន​មៃ​យោឆែប​ហោម​រេស ពាង់​ជាន​កោរាញ​ម៝ត់​អ្វាញ់​លាម​ឞ្រី​អេឆីប ​ងាន់”។ យើន​មា​យាកោប​មោ​អោស​ជី​ឞោក​ជី​តោរ យ៝រ​លាស​ពាង់​មោ​អោស​អ្យាត់​នាវ​ខាន់​ពាង់​មឞើស​ងក៝ច​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ត៝ត់​មា​ខាន់​ពាង់​មឞើស​ងក៝ច​ទឹង​លែៈ​នាវ​យោឆែប​ទែ​នតិញ​រី​នើស ឆៃ​រាទែស​យោឆែប​ទែ​ញជ្វាល់​គៃ​មា​រាទែង​ពាង់​ហាន់​តា​ឞ្រី​អេឆីប  រី​មើ​យាកោប​នតើម​នទ្រ៝ត់​ឆាក់។ ");
INSERT INTO cmok_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ជេសរី​អីឆ្រាអែល​អី​ឞូ​ក្វាល់​យាកោប​ដ៝ង់​លាស៖ “លែៈ​គ៝ប់​អ្យាត់​ហើយ្ស! យោឆែប​ក៝ន​គ៝ប់​ពាង់​ហោម​រេស គ៝ប់​អុច​ហាន់​ម៝ប់​ពាង់​អេ​ល៝រ​មា​គ៝ប់​ខឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ជេសរី​អីឆ្រាអែល​អី​ឞូ​ក្វាល់​យាកោប​ដ៝ង់ ញអោត​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​គែស​ហាន់​នទ្រែល​ពាង់​នើម។ ត៝ត់​តា​ប៝ន​បេរឆេបា​រី ពាង់​គុច​ញហើរ​នទើ​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​អី​ឞ្រាស​អីឆាក់​ឞឹ​ពាង់​នើម​យើក​មឞាស។ ");
INSERT INTO cmok_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","កោរាញ​ឞ្រាស​ងើយ​មា​អីឆ្រាអែល​តា​នាវ​តឹម​ឆៃ​នោក​មាង់៖ “អើ​យាកោប! អើ​យាកោប!” អីឆ្រាអែល​អើស៖ “ម៝ស​ហាៈ​កោរាញ​ឞ្រាស!” ");
INSERT INTO cmok_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","កោរាញ​ឞ្រាស​លាស​មា​ពាង់៖ “គ៝ប់​អ្យា​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ឞឹ​មៃ​យើក​មឞាស។ មៃ​លើយ​អោស​ក្លាច​ហាន់​តា​ឞ្រី​អេឆីប  យ៝រ​លាស​តា​ឞ្រី​អី​នៃ​តៃ​គ៝ប់​ជាន​អ៝ន់​មៃ​ជេង​ទូ​ផូង​ក្វ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","គ៝ប់​ហាន់​នទ្រែល​មៃ​តា​ឞ្រី​អេឆីប ​នៃ ជេសរី​តៃ​គ៝ប់​លែវ​មៃ​ព្លឹ​ឞើស​ឞ្រី​អី​នៃ​ដ៝ង់។ ត៝ត់​មៃ​ខឹត​យោឆែប​ឆើម​រាទេប​មាត់​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ជេសរី​យាកោប​លោស​ឞើស​បេរឆេបា​នៃ ផូង​អ៝ស​ក៝ន​អីឆ្រាអែល​រាទែង​ឞឹ​ខាន់​ពាង់​នើម នទ្រែល​មា​អូរ​ក៝ន​ខាន់​ពាង់​នើម​មា​រាទែស​កាដាច់​ផារ៝ន​ទែ​ញជ្វាល់​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ខាន់​ពាង់​ញអោត​ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​ទឹង​លែៈ​ទ្រាប់​នទើ​ខាន់​ពាង់​នើម​គែស​តា​ឞ្រី​កានាន លែវ​នទ្រែល​ខាន់​ពាង់​នើម​ទាទេ។ យាកោប​លែវ​រាន៝យ​ទែស​ពាង់​នើម​លែៈ​ផ្យៅ​ហាន់​តា​ឞ្រី​អេឆីប ។ ");
INSERT INTO cmok_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","យាកោប​លែវ​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ ឆៅ​ឞូ​អូរ​ឆៅ​ឞូ​ក្លោ នទ្រែល​មា​ទឹង​លែៈ​រាន៝យ​ទែស​ពាង់​នើស ហាន់​តា​ឞ្រី​អេឆីប ​រី​នទ្រែល​ពាង់​នើម​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","អ្យា​ជេង​គែស​រាញា​ឆាក់​ផូង​ក៝ន​ឆៅ​អីឆ្រាអែល​ហាន់​តា​ឞ្រី​អេឆីប ៖ យាកោប នទ្រែល​មា​ទឹង​លែៈ​អ៝ស​ក៝ន​ពាង់។ ក៝ន​ឞោក​ទាក​យាកោប​រាញា​រូបេន។ ");
INSERT INTO cmok_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ក៝ន​ឞូ​ក្លោ​រូបេន តា​នៃ​គែស៖ ហានុក  គែស​ផាលូ គែស​ហេឆ្រុន នទ្រែល​មា​ការមី។ ");
INSERT INTO cmok_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ក៝ន​ឞូ​ក្លោ​ឆីមោន៖ តា​នៃ​គែស​យេមូអែល គែស​យាមីន គែស​អោហាត គែស​យាកីន គែស​ឆោហារ នទ្រែល​មា​ឆោល។ មេៈ​ឆោល​ឞូ​អូរ​ផូង​កានាន។ ");
INSERT INTO cmok_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ក៝ន​ឞូ​ក្លោ​លេវី៖ តា​នៃ​គែស​កេរឆ៝ន គែស​កេហាត នទ្រែល​មា​មរារី។ ");
INSERT INTO cmok_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ក៝ន​ឞូ​ក្លោ​យូដា៖ តា​នៃ​គែស​អេរ គែស​អោនាន គែស​ឆេលា គែស​ពេរេស នទ្រែល​មា​ឆេរាស។ (ក៝ន​ឞារ​ហៃ​អេរ នទ្រែល​មា​អោនាន​លែៈ​ខឹត​តា​ឞ្រី​កានាន។) ក៝ន​ឞូ​ក្លោ​ពេរេស៖ តា​នៃ​គែស​ហេឆ្រុន នទ្រែល​មា​ហាមុល។ ");
INSERT INTO cmok_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ក៝ន​ឞូ​ក្លោ​អីឆាខារ៖ តា​នៃ​គែស​ថោលា គែស​ពូវា គែស​យោប នទ្រែល​មា​ឆីមរោន។ ");
INSERT INTO cmok_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ក៝ន​ឞូ​ក្លោ​ឆាប់យូលោន៖ តា​នៃ​គែស​ឆេរែត គែស​អេលោន នទ្រែល​មា​យាលៀល។ ");
INSERT INTO cmok_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ទឹង​លែៈ​ខាន់​ពាង់​អី​នៃ​ជេង​ក៝ន​លេអា​ទាទេ ពាង់​ឞាៈ​អ៝ន់​មា​យាកោប​ទោល​គុ​តា​ឞ្រី​ពាដាន-អារាម​នើស នទ្រែល​មា​ដីនា​ក៝ន​ឞូ​អូរ​ពាង់។ ទឹង​លែៈ​ក៝ន​លេអា នអ៝ប់​មា​ឆៅ​ពាង់​គែស ៣៣ នុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ក៝ន​ឞូ​ក្លោ​កាត៖ តា​នៃ​គែស​ឆេផុន គែស​ហាកី គែស​ឆូនី គែស​អេសប៝ន គែស​អេរី គែស​អារោដី នទ្រែល​មា​អារេលី។ ");
INSERT INTO cmok_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ក៝ន​ឞូ​ក្លោ​អាឆើរ៖ តា​នៃ​គែស​យិមនា គែស​យីសវា គែស​អីសវី គែស​បេរីយា នទ្រែល​មា​ឆេរា​អ៝ស​ឞូ​អូរ។ ក៝ន​បេរីយា៖ តា​នៃ​គែស​ហេបើរ នទ្រែល​មា​មាល់កៀល។ ");
INSERT INTO cmok_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ទឹង​លែៈ​ខាន់​ពាង់​អី​នៃ​ជេង​ក៝ន​ឆៅ​ឆិលផា​អី​លាបាន​ទែ​អ៝ន់​មា​លេអា​នើស។ ទឹង​លែៈ​ក៝ន​ឆិលផា នអ៝ប់​មា​ឆៅ​ពាង់​គែស ១៦ នុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ក៝ន​ឞូ​ក្លោ​រាចែល​អូរ​យាកោប៖ តា​នៃ​គែស​យោឆែប នទ្រែល​មា​បែនយាមឹន។ ");
INSERT INTO cmok_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","តា​ឞ្រី​អេឆីប ​យោឆែប​គែស​ឞារ​ហៃ​ក៝ន​ឞូ​ក្លោ៖ តា​នៃ​គែស​មានាឆេ នទ្រែល​មា​អេប្រាអីម។ អាសនាត​ក៝ន​ឞូ​អូរ​ផោថីផេរា​ឞូនុយ្ស​ជាន​ឞ្រាស​តា​ប៝ន​អោន​ឞាៈ​ខាន់​ពាង់​មា​យោឆែប។ ");
INSERT INTO cmok_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ក៝ន​ឞូ​ក្លោ​បែនយាមឹន៖ តា​នៃ​គែស​បេលា គែស​បេកើរ គែស​អាសបេល គែស​កេរា គែស​នាមាន គែស​អេហី គែស​រោស គែស​មូផីម គែស​ហូផីម នទ្រែល​មា​អារើត។ ");
INSERT INTO cmok_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ទឹង​លែៈ​ខាន់​ពាង់​អី​នៃ​ជេង​ក៝ន​ឆៅ​រាចែល​ទាទេ ក៝ន​ឆៅ​រាចែល​ទឹង​លែៈ​គែស ១៤ នុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ក៝ន​ឞូ​ក្លោ​ដាន៖ តា​នៃ​គែស​ហូឆីម។ ");
INSERT INTO cmok_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ក៝ន​ឞូ​ក្លោ​នាប់តាលី៖ តា​នៃ​គែស​យាឆៀល គែស​កូនី គែស​យេឆើរ នទ្រែល​មា​ឆីលេម។ ");
INSERT INTO cmok_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ទឹង​លែៈ​ខាន់​ពាង់​អី​នៃ​ជេង​ក៝ន​បិលហា​អី​លាបាន​ទែ​អ៝ន់​មា​រាចែល​នើស។ ក៝ន​ឆៅ​បិលហា​អ៝ន់​មា​យាកោប​ទឹង​លែៈ​គែស ៧ នុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ទឹង​លែៈ​ក៝ន​ឆៅ​យាកោប​ហាន់​នទ្រែល​ពាង់​នើម​តា​ឞ្រី​អេឆីប  គែស ៦៦ នុយ្ស មោ​អោស​កើប​បាន់ៗ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","លាស​កើប​នអ៝ប់​មា​ក៝ន​យោឆែប​ឞារ​ហៃ​ទែស​តា​ឞ្រី​អេឆីប ​រី​ដ៝ង់ ទឹង​លែៈ​ឞូនុយ្ស​តា​រានាក់​វ៝ល់​យាកោប​ហាន់​គុ​តា​ឞ្រី​អេឆីប ​គែស ៧០ នុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","យាកោប​ដាៈ​យូដា​ហាន់​ល៝រ​ម៝ប់​យោឆែប គៃ​មា​អោប​ត្រ៝ង​ហាន់​ជឹត​ឞ្រី​កោឆែន ជេសរី​យាកោប​នទ្រែល​មា​រានាក់​វ៝ល់​ពាង់​ហាន់​ត៝ត់​តា​ឞ្រី​កោឆែន។ ");
INSERT INTO cmok_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","យោឆែប​អ៝ន់​ឞូ​នទ្រាប់​រាទែស​ឆែស​ពាង់​នើម ជេសរី​ញច៝​ហាន់​ច្វាៈ​យាកោប​អី​ឞូ​ក្វាល់​អីឆ្រាអែល​ឞឹ​ពាង់​នើម​តា​ឞ្រី​កោឆែន ត៝ត់​តា​រី​ពាង់​អូត​ឞឹ​ពាង់ នហ៝​មា​ញុម​ជ៝ង​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","អីឆ្រាអែល​លាស​មា​យោឆែប៖ “អាបៃ​អ្យា​លាស​គ៝ប់​ខឹត​មោ​ច្រាវ​អោស យ៝រ​លាស​លែៈ​គ៝ប់​ឆៃ​មុស​មាត់​មៃ​ហោម​អែ​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","យោឆែប​ងើយ​មា​អ៝ស​នោ​ពាង់ នអ៝ប់​មា​ទឹង​លែៈ​ឞូនុយ្ស​អី​ហាន់​នទ្រែល​ខាន់​ពាង់៖ “គ៝ប់​ហាន់​មឞើស​ងក៝ច​មា​កាដាច់​ផារ៝ន​លាស៖ «ទឹង​លែៈ​អ៝ស​នោ​គ៝ប់ នទ្រែល​មា​រានាក់​វ៝ល់​ឞឹ​គ៝ប់​ឞើស​ឞ្រី​កានាន អាបៃ​អ្យា​ខាន់​ពាង់​លែៈ​ត៝ត់​តា​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ខាន់​ពាង់​លែវ​នអ៝ប់​មា​នទ្រោក មា​ឞែ​ឞ្យាប់ នទ្រែល​មា​ទឹង​លែៈ​មពោមពា​(ឆ្យុម)​ខាន់​ពាង់​គែស យ៝រ​លាស​ខាន់​ពាង់​ជេង​ឞូនុយ្ស​ច្យាប់ នាវ​រេស​ខាន់​ពាង់​នើស​គុ​ម៝ត់​មពោមពា​(ឆ្យុម)​ទើម»។ ");
INSERT INTO cmok_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","លាស​កាដាច់​ផារ៝ន​អោប​ខាន់​មៃ៖ «ខាន់​មៃ​ម៝ស​បាៈ​វៃ​ជាន?» ");
INSERT INTO cmok_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","អ៝ន់​ខាន់​មៃ​អើស​មា​ពាង់​កើត​នអា៖ «អើ​កោរាញ ហេន​វៃ​ច្យាប់​នតើម​ឞើស​ជេៈ​នហ៝​មា​ត៝ត់​អាបៃ​អ្យា កើត​ផូង​ចែ​ហេន​កាល់​អែ​នើស​ដ៝ង់»។ លាស​ខាន់​មៃ​អើស​មា​ពាង់​កើត​នៃ ខាន់​មៃ​គែស​គុ​តា​នតុក​ឞ្រី​កោឆែន​អ្យា​រ៝ យ៝រ​លាស​ផូង​អេឆីប ​មឺច​ហោ​ងាន់​មា​ផូង​ច្យាប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","យោឆែប​ហាន់​មឞើស​ងក៝ច​មា​កាដាច់​ផារ៝ន៖ “ឞឹ​គ៝ប់ នទ្រែល​មា​អ៝ស​នោ​គ៝ប់ ខាន់​ពាង់​លែៈ​លោស​តាៈ​ឞើស​ឞ្រី​កានាន លែវ​នអ៝ប់​មា​នទ្រោក មា​ឞែ​ឞ្យាប់ នទ្រែល​មា​ទឹង​លែៈ​នទើ​ខាន់​ពាង់​គែស អាបៃ​អ្យា​ខាន់​ពាង់​លែៈ​ត៝ត់​តា​ឞ្រី​កោឆែន”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","យោឆែប​លែវ​អ៝ស​នោ​ពាង់​ព្រាម់​នុយ្ស​ហាន់​ម៝ប់​កាដាច់​ផារ៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ផារ៝ន​អោប​ខាន់​ពាង់៖ “ម៝ស​នទើ​ខាន់​មៃ​វៃ​ជាន?” ខាន់​ពាង់​អើស៖ “អើ​កោរាញ ហេន​ជេង​ផូង​ច្យាប់​កើត​ផូង​ចែ​ហេន​កាល់​អែ​នើស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ខាន់​ពាង់​ងើយ​តៃ​មា​កាដាច់៖ “អើ​កោរាញ ហេន​ទាន់​គុ​តា​ឞ្រី​អ្យា​ទូ​ប្ល៝ត់ យ៝រ​លាស​តា​ឞ្រី​កានាន​គែស​នាវ​ជី​ង៝ត​ក្វ៝ង់ រេប​ជា​មា​អ៝ន់​មពោមពា​(ឆ្យុម)​ឆា​មោ​ហោម​គែស​ដ៝ង់។ កើត​នទ្រី​ហេន​ទាន់​មៃ​រ៝ម​ហេន​អ៝ន់​ហេន​គុ​តា​ឞ្រី​កោឆែន”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ផារ៝ន​លាស​មា​យោឆែប៖ “ឞឹ​មៃ នទ្រែល​មា​អ៝ស​នោ​មៃ​លែៈ​ត៝ត់​តា​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","អ៝ន់​មៃ​កើយ្ស​ឞ្រី​អី​អ្វែស​រាលាវ​ឞូ​អ៝ន់​មា​ឞឹ​មៃ នទ្រែល​មា​អ៝ស​នោ​មៃ ម៝ស​ឞ្រី​អី​មៃ​អុច លាស​មៃ​អុច អ៝ន់​ខាន់​ពាង់​គុ​តា​ឞ្រី​កោឆែន​នៃ​ទោ។ តា​ផូង​ខាន់​ពាង់​អី​នៃ​ឞូ​ម៝ស​មៃ​ឆៃ​អី​ឞ្លាវ អ៝ន់​ពាង់​ជាន​កោរាញ​ម៝ត់​អ្វាញ់​មា​មពោមពា​(ឆ្យុម)​គ៝ប់​នើម​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ជេសរី​យោឆែប​លែវ​ឞឹ​ពាង់​ហាន់​ម៝ប់​កាដាច់​ផារ៝ន​ដ៝ង់ យាកោប​ទាន់​នាវ​គែស​ជេង​កោរាញ​ឞ្រាស​អ៝ន់​មា​ផារ៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ផារ៝ន​អោប​យាកោប៖ “ទាស​អ៝ក់​នាម់​មៃ​ចែ?” ");
INSERT INTO cmok_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","យាកោប​មឞើស​ងក៝ច​មា​កាដាច់​ផារ៝ន៖ “នាម់​គ៝ប់​គុ​រេស​អាបៃ​អ្យា​លែៈ​គែស ១៣០ នាម់។ នាម់​គ៝ប់​ដេៈ​ទើម នាវ​រេស​គ៝ប់​មោ​គែស​នាវ​អ្វែស​ដ៝ង់ គ៝ប់​រេស​មោ​អោស​ជ៝ៈ​ជ៝ង​កើត​ផូង​ចែ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","យាកោប​ទាន់​នាវ​គែស​ជេង​កោរាញ​ឞ្រាស​អ៝ន់​មា​ផារ៝ន​ទូ​តឹ​ជឹត ជេសរី​ពាង់​លោស​ឞើស​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ជេសរី​យោឆែប​អ៝ន់​នែស​ទុត​អ្វែស​តា​ឞ្រី​អេឆីប ​អ៝ន់​មា​ឞឹ​ពាង់ នទ្រែល​មា​អ៝ស​នោ​ពាង់ ជេង​នទើ​មា​ខាន់​ពាង់​នើម ពាង់​អ៝ន់​ខាន់​ពាង់​គុ​តា​ឞ្រី​កោឆែន​ទាច់​កេង​ប៝ន​រាម់ឆែស កើត​នាវ​ផារ៝ន​ទែ​លាស។ ");
INSERT INTO cmok_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","យោឆែប​ម៝ត់​ឆ្យាម់​ឞឹ​ពាង់ នទ្រែល​មា​អ៝ស​នោ​ពាង់ នអ៝ប់​មា​ទឹង​លែៈ​ឞូនុយ្ស​គុ​តា​រានាក់​វ៝ល់​ខាន់​ពាង់​រី តឹង​អ៝ក់​ឞូនុយ្ស​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","នាវ​ជី​ង៝ត​ក្វ៝ង់​ហោ​ងាន់ លាម​ឞ្រី​ទាក​មោ​អោស​គែស​ព្យាង់​ឆោង ឞូនុយ្ស​តា​ឞ្រី​អេឆីប  នទ្រែល​មា​តា​ឞ្រី​កានាន​គែស​នាវ​ជេរ​ជ៝ត់​ហោ​ងាន់ យ៝រ​មា​ជី​ង៝ត​ក្វ៝ង់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","យោឆែប​លែៈ​តាច់​ឞា​អ៝ន់​មា​ឞ្រី​អេឆីប  នទ្រែល​មា​ឞ្រី​កានាន ពាង់​រាគូម​ទឹង​លែៈ​ព្រាក់​តាច់​ឞា​អី​នៃ ជេសរី​ញជុន​តា​ជៃ​កាដាច់​ផារ៝ន ត៝ត់​មា​មោ​ហោម​អោស​គែស​ព្រាក់​តា​ទឹង​លែៈ​ឞ្រី​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ព្រាក់​មា​រាវាត់​ឞា​មោ​ហោម​អោស​តា​ឞ្រី​អេឆីប  នទ្រែល​មា​តា​ឞ្រី​កានាន​លែៈ​ផ្យៅ ទឹង​លែៈ​ផូង​ប៝ន​លាន​អេឆីប ​ខាន់​ពាង់​ហាន់​ម៝ប់​មា​យោឆែប​ទាទេ ងើយ​ដាស​ពាង់៖ “ទាន់​មៃ​អ៝ន់​ព្យាង់​ឞា​មា​ហេន លាស​មៃ​មោ​អ៝ន់ ហេន​ខឹត​តា​នាប់​មៃ​ងាន់​រ៝ យ៝រ​លាស​ហេន​មោ​ហោម​គែស​ព្រាក់​មា​រាវាត់”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","យោឆែប​អើស​មា​ខាន់​ពាង់៖ “លាស​ខាន់​មៃ​មោ​ហោម​គែស​ព្រាក់ ខាន់​មៃ​អ៝ន់​មពោមពា​(ឆ្យុម)​ខាន់​មៃ​មា​គ៝ប់ តៃ​គ៝ប់​អ៝ន់​ព្យាង់​ឞា​មា​ខាន់​មៃ​ឆោង”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ជេសរី​ខាន់​ពាង់​លែវ​មពោមពា​(ឆ្យុម)​ខាន់​ពាង់​នើម​អ៝ន់​មា​យោឆែបយោឆែប​អ៝ន់​ព្យាង់​ឞា​មា​ខាន់​ពាង់ តឹម​រាគ៝ល់​ដាស​ឆែស ដាស​ឞែ​ឞ្យាប់ ដាស​នទ្រោក ដាស​ឆែស​លៀ។ យោឆែប​អ៝ន់​ព្យាង់​ឞា​មា​ខាន់​ពាង់​នាម់​នៃ តឹម​រាគ៝ល់​ដាស​មពោមពា​(ឆ្យុម)​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","នាម់​នៃ​លែៈ​លោច​ជេស លាប់​នាម់​អេង ខាន់​ពាង់​ហាន់​ម៝ប់​តៃ​យោឆែប​ទូ​តឹ​ជឹត ខាន់​ពាង់​ងើយ​ដាស​ពាង់៖ “អើ​កោរាញ ហេន​ទាន់​មឞើស​ងក៝ច​មា​មៃ ហេន​មោ​អោស​ពោន​ម៝ ព្រាក់​តា​ឆាក់​ហេន​លែៈ​ផ្យៅ មពោមពា​(ឆ្យុម)​ហេន​លែៈ​ហេន​ញជុន​អ៝ន់​មៃ​លែៈ​ផ្យៅ​ដ៝ង់ ហេន​មោ​ហោម​អោស​គែស​នទើ​ទូ​នតីល ហោម​អែ​នែស នទ្រែល​មា​ឆាក់​ហេន​នើម​ទូ​រី​ទើម​ហោម។ ");
INSERT INTO cmok_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","អើ​កោរាញ គៃ​មា​ហេន​ហោម​រេស ទាន់​មៃ​រាវាត់​នែស​ហេន នទ្រែល​មា​ឆាក់​ហេន​នើម​តឹម​រាគ៝ល់​ដាស​ព្យាង់​ឞា​មៃ​នៃ អ៝ន់​ហេន​គុ​ជាន​ទឹក​ផារ៝ន នទ្រែល​មា​នែស​ហេន​អ៝ន់​ជេង​ទ្រាប់​នទើ​ពាង់ យ៝រ​លាស លាស​ហេន​ខឹត​លែៈ​ផ្យៅ​នែស​ហេន​នៃ​ឞូ​ម៝ស​មា​នទើន? ទាន់​កោរាញ​អ៝ន់​ឞា​នតីល​មា​ហេន គៃ​មា​ហេន​ហោម​រេស មោ​ខឹត លើយ​អោស​អ៝ន់​ឞ្រី​ទាក​រាង៝ត​រាងាត់”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","យោឆែប​រាវាត់​លែៈ​ផ្យៅ​នែស​តា​ឞ្រី​អេឆីប ​អ៝ន់​មា​កាដាច់​ផារ៝ន ទឹង​លែៈ​ផូង​អេឆីប ​តាច់​នែស​មីរ​ខាន់​ពាង់​នើម​យ៝រ​មា​នាវ​ជី​ង៝ត​ក្វ៝ង់​អី​នៃ​លើ​មា​ហោ​ងាន់ កើត​នទ្រី​នែស​លាម​ឞ្រី​អី​នៃ​ជេង​នែស​ផារ៝ន​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ជេសរី​ទឹង​លែៈ​ផូង​ប៝ន​លាន​លាម​ឞ្រី​អេឆីប ​នៃ​ជេង​ទឹក​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","នែស​ផូង​ឞូនុយ្ស​ជាន​ឞ្រាស​ទើម​យោឆែប​មោ​រាវាត់ យ៝រ​លាស​ផូង​អី​នៃ​គែស​ផារ៝ន​ឆើម​អ៝ន់​ព្យាង់​ឞា កើត​នទ្រី​ទឹង​នែស​ខាន់​ពាង់​មោ​តាច់។ ");
INSERT INTO cmok_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","យោឆែប​លាស​មា​ផូង​ប៝ន​លាន៖ “នារ​អ្យា​លែៈ​គ៝ប់​រាវាត់​ជេស​ឆាក់​ខាន់​មៃ​នើម នទ្រែល​មា​នែស​ខាន់​មៃ​អ៝ន់​មា​កាដាច់​ផារ៝ន។ អាបៃ​អ្យា​គ៝ប់​អ៝ន់​នតីល​ឞា​មា​ខាន់​មៃ ខាន់​មរែ​មា​តូច​តាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ត៝ត់​ខៃ​លែៈ​កាច់​លែៈ​រែក​តៃ ខាន់​មៃ​អ៝ន់​ទូ​កោៈ​តឹម​ព្រាម់​(១/៥)​មា​ផារ៝ន ជេសរី​ព្វាន់​កោៈ​មា​ខាន់​មៃ​នើម គៃ​មា​គែស​នតីល នទ្រែល​មា​នទើ​ឆោង​ឆា​មា​ខាន់​មៃ​នើម មា​អ៝ស​ក៝ន​ខាន់​មៃ នអ៝ប់​មា​ឞូនុយ្ស​គុ​តា​ញីស​ជៃ​ខាន់​មៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ផូង​ប៝ន​លាន​លាស​មា​យោឆែប៖ “មៃ​លែៈ​រាក្លាយ្ស​នាវ​រេស​ផូង​ហេន។ លាស​មៃ​អុច តៃ​ហេន​គុ​ជាន​ទឹក​មា​ផារ៝ន”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","យោឆែប​អ៝ន់​នាវ​វៃ​តា​ឞ្រី​អេឆីប ​នហ៝​មា​ត៝ត់​អាបៃ​អ្យា ដាៈ​ផូង​អេឆីប ​អ៝ន់​មា​ផារ៝ន​ទូ​កោៈ​តឹម​ព្រាម់​នទើ​ខាន់​ពាង់​គែស​តាៈ​ឞើស​នែស​នៃ នែស​ផូង​ឞូនុយ្ស​ជាន​ឞ្រាស​ទើម​មោ​ជេង​នទើ​ផារ៝ន។ ");
INSERT INTO cmok_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ផូង​អីឆ្រាអែល​គុ​រេស​តា​ឞ្រី​អេឆីប  ខាន់​ពាង់​គុ​តា​នតុក​កោឆែន គែស​នែស​តា​នតុក​នៃ ខាន់​ពាង់​ឞាៈ​អ៝ស​ឞាៈ​ក៝ន​អ៝ក់​ឞឹក​រឹ​ងាន់​តា​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","យាកោប​គុ​រេស​តា​ឞ្រី​អេឆីប ​គែស ១៧ នាម់។ ទឹង​លែៈ​នាម់​ពាង់​រេស​គែស ១៤៧ នាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ត៝ត់​អីឆ្រាអែល​អី​ឞូ​ក្វាល់​យាកោប​ដ៝ង់ ឞើយ​មា​ខឹត ពាង់​ក្វាល់​ក៝ន​ពាង់​យោឆែប នតិញ​មា​ពាង់៖ “អើ​នោ លាស​មៃ​រ៝ង់​មា​គ៝ប់ មៃ​តេៈ​តី​មៃ​អី​នៃ​តា​ន៝ម់​តឹម​ឞ្លូ​គ៝ប់​អ្យា នអ៝ប់​មា​ត៝ន អ៝ន់​មៃ​ជាន​អ្វែស ជាន​ឆ៝ង់​មា​គ៝ប់ មៃ​លើយ​អោស​ត៝ប់​គ៝ប់​តា​ឞ្រី​អេឆីប ​អ្យា! ");
INSERT INTO cmok_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","មៃ​ត៝ប់​គ៝ប់​តា​នតុក​ត៝ប់​ផូង​ចែ​គ៝ប់ មៃ​រាទែង​គ៝ប់​លោស​ឞើស​ឞ្រី​អេឆីប ​អ្យា ជេសរី​ត៝ប់​គ៝ប់​តា​នតុក​មោច​ផូង​ចែ​គ៝ប់​នើម”។ យោឆែប​អើស​មា​ពាង់៖ “តៃ​គ៝ប់​ជាន​កើត​នាវ​មៃ​លាស​ឞឹ”។ ");
INSERT INTO cmok_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","យាកោប​លាស​តៃ​មា​ពាង់៖ “លាស​នទ្រី​មៃ​ត៝ន​មា​គ៝ប់” នទ្រី​យោឆែប​ត៝ន​មា​ពាង់។ ជេសរី​យាកោប​អី​ឞូ​ក្វាល់​អីឆ្រាអែល​ដ៝ង់​យើក​មឞាស​កោរាញ​ឞ្រាស​តា​ឞោក​ឞិច​ពាង់​នើម​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ឞើស​កើយ​នៃ គែស​ឞូ​មឞើស​មា​យោឆែប​ឞឹ​ពាង់​ជី។ យោឆែប​ហាន់​ច៝ប​ឞឹ​ពាង់ ពាង់​លែវ​ក៝ន​ឞូ​ក្លោ​ពាង់​ឞារ​ហៃ​ហាន់​នទ្រែល​ពាង់​នើម៖ មានាឆេ នទ្រែល​មា​អេប្រាអីម។ ");
INSERT INTO cmok_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ឞូ​មឞើស​មា​យាកោប៖ “ក៝ន​មៃ​យោឆែប​ហាន់​ច៝ប​មៃ”។ យាកោប​អី​ឞូ​ក្វាល់​អីឆ្រាអែល​ដ៝ង់​ញឆ្រោយ្ស​ទ៝ក់​គុ​តា​គ្រែ​រី‌ ");
INSERT INTO cmok_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ជេសរី​លាស​មា​យោឆែប៖ “កោរាញ​ឞ្រាស​នើម​អី​ទុត​គែស​នាវ​ទើយ ពាង់​វាច់​អ៝ន់​គ៝ប់​ឆៃ​ពាង់​តា​ប៝ន​លុស​ឞ្រី​កានានពាង់​អ៝ន់​គែស​ជេង​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","កោរាញ​ឞ្រាស​លាស​មា​គ៝ប់៖ «តៃ​គ៝ប់​ជាន​អ៝ន់​មៃ​គែស​អ៝ស​គែស​ក៝ន​ឞឹក​រឹ​អ៝ក់​ងាន់ នហ៝​មា​គែស​អ៝ក់​ផូង​ឞូនុយ្ស​តាៈ​ឞើស​មៃ។ តៃ​គ៝ប់​អ៝ន់​ឞ្រី​អ្យា​មា​ក៝ន​ឆៅ​មៃ ជេង​នតុក​មា​ខាន់​ពាង់​នើម​នហ៝​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ក៝ន​ឞូ​ក្លោ​មៃ​ឞារ​ហៃ​ទែស​តា​ឞ្រី​អេឆីប ​ទោល​គ៝ប់​អេ​ហ៝ៈ​ត៝ត់​តា​អ្យា កើប​ជេង​ក៝ន​គ៝ប់ អេប្រាអីម នទ្រែល​មា​មានាឆេ ខាន់​ពាង់​អី​នៃ​ជេង​ក៝ន​គ៝ប់ តឹម​ឞាន​មា​រូបេន នទ្រែល​មា​ឆីមោន​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ក៝ន​មៃ​ទែស​ឞើស​កើយ​ឞើស​កើយ​នៃ អី​នៃ​កើប​ក៝ន​មៃ ខាន់​ពាង់​ឆ៝ៈ​ទើន​នែស​តា​នែស​អេប្រាអីម នទ្រែល​មា​មានាឆេ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ទោល​គ៝ប់​ព្លឹ​ឆឹត​តាៈ​ឞើស​ឞ្រី​ពាដាន-អារាមរាចែល​មេៈ​មៃ​ខឹត​តា​តី​គ៝ប់​នើម ទាច់​កេង​ប៝ន​អេប្រាតា​ឞ្រី​កានាន គ៝ប់​ត៝ប់​មេៈ​មៃ​រ៝ៈ​ត្រ៝ង​ហាន់​ជឹត​ប៝ន​អេប្រាតា”។ អេប្រាតា​ជេង​ប៝ន​បេតលេហឹម។ ");
INSERT INTO cmok_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","អីឆ្រាអែល​ឆៃ​ក៝ន​ឞូ​ក្លោ​យោឆែប ពាង់​អោប៖ “ឞូ​ម៝ស​ឞារ​ហៃ​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","យោឆែប​អើស៖ “ខាន់​ពាង់​ក៝ន​គ៝ប់ កោរាញ​ឞ្រាស​អ៝ន់​មា​គ៝ប់​តា​ឞ្រី​អ្យា”។ អីឆ្រាអែល​លាស​មា​ពាង់៖ “លែវ​ខាន់​ពាង់​ហាន់​ទាច់​តា​គ៝ប់​អ្យា គ៝ប់​ឞែ​មា​ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​ខាន់​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ទោល​នៃ​មាត់​អីឆ្រាអែល​លែៈ​ង៝ អ្វាញ់​មោ​ហោម​អោស​ឆៃ យ៝រ​លាស​ឆាក់​ពាង់​លែៈ​រាញ។ យោឆែប​លែវ​ខាន់​ពាង់​ហាន់​ទាច់​តា​អីឆ្រាអែល ជេសរី​ពាង់​អូត នទ្រែល​មា​ចុម​អី​ឆៅៗ​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","អីឆ្រាអែល​ងើយ​មា​យោឆែប៖ “អា​ល៝រ​នើស គ៝ប់​មោ​គឹត​លាស​ហោម​ឆៃ​មុស​មាត់​មៃ​នអា យើន​មា​អាបៃ​អ្យា​កោរាញ​ឞ្រាស​អ៝ន់​គ៝ប់​ឆៃ​នអ៝ប់​មា​រាន៝យ​ទែស​មៃ​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ជេសរី​យោឆែប​តេក​ក៝ន​ពាង់​ឞារ​ហៃ​អី​នៃ​បាស​ដាស​កោម៝ក់​ឞឹ​ពាង់ ជេសរី​ច៝ន​ម៝ន​កោម៝ក់​ពាន់​អា​នែស។ ");
INSERT INTO cmok_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ជេស​នៃ​យោឆែប​លែវ​ក៝ន​ពាង់​ហាន់​ទាច់​តា​អី​ឞឹ​តៃ​ជឹត ពាង់​អ៝ន់​អេប្រាអីម​មពែស​ឞើស​មា​ពាង់​នើម ជេង​មពែស​ឞើស​ច្យៅ​អីឆ្រាអែលមានាឆេ​មពែស​ឞើស​ច្យៅ​ពាង់​នើម ជេង​មពែស​ឞើស​មា​អីឆ្រាអែល។ ");
INSERT INTO cmok_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","អីឆ្រាអែល​តេៈ​តី ពាង់​រាព្លាច់​តី​មា​តេៈ​តា​ឞោក​អេប្រាអីម​អី​អ៝ស ជេសរី​ពាង់​តេៈ​តី​ច្យៅ​តា​ឞោក​មានាឆេ​ជេង​ក៝ន​ឞោក​ទាក ឞ៝ល​លាស​មានាឆេ​ជេង​ក៝ន​ឞោក​ទាក​កាដោយ អីឆ្រាអែល​ជាន​កើត​នៃ​ពាង់​លែៈ​គឹត​នហេល​នានេៈ។ ");
INSERT INTO cmok_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ជេសរី​អីឆ្រាអែល​ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​គែស​ជេង​មា​យោឆែប ពាង់​លាស៖ “ទាន់​កោរាញ​ឞ្រាស​អី​ឞ្រាស​អាឞ្រាហាម់  នទ្រែល​មា​អី​ឞ្រាស​អីឆាក់​វៃ​យើក​មឞាស ទាន់​កោរាញ​ឞ្រាស​អី​ម៝ត់​ញជ្រាង់​គ៝ប់​នតើម​ឞើស​ជេៈ​ត៝ត់​អាបៃ​អ្យា អី​តឹម​ឞាន​មា​ឞូនុយ្ស​ច្យាប់​ម៝ត់​ញជ្រាង់​មពោមពា​(ឆ្យុម)​ផូង​ពាង់​នើម ");
INSERT INTO cmok_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ទាន់​តោង​ពារ់​កោរាញ​ឞ្រាស​នើម​អី​លែៈ​រាក្លាយ្ស​ជេស​គ៝ប់​ឞើស​អាប់​នតីល​នាវ​ជេរ ទាន់​ពាង់​អ៝ន់​គែស​ជេង​មា​ក៝ន​ឞូ​ក្លោ​ឞារ​ហៃ​អ្យា អ៝ន់​ឞូ​ហោម​កាស​គឹត​មា​រាញា​ឆាក់​គ៝ប់ រាញា​ឆាក់​អាឞ្រាហាម់ ​ជេង​ចែ នទ្រែល​មា​រាញា​ឆាក់​អីឆាក់​ឞឹ​គ៝ប់ យ៝រ​មា​ឞារ​ហៃ​ខាន់​ពាង់​អ្យា។ ទាន់​អ៝ន់​មា​ឞារ​ហៃ​ខាន់​ពាង់​អ្យា​គែស​អ៝ស​គែស​ក៝ន​ឞឹក​រឹ​អ៝ន់​អ៝ក់​ងាន់​តា​នែស​នតូ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","យោឆែប​ឆៃ​ឞឹ​ពាង់​តេៈ​តី​ឞើស​មា​តា​ឞោក​អេប្រាអីម ពាង់​មោ​អោស​មអាក។ ពាង់​ក្វាន់​តី​ឞឹ​ពាង់​តឹម​រាគ៝ល់​ឞើស​ឞោក​អេប្រាអីម​តេៈ​តា​ឞោក​មានាឆេ។ ");
INSERT INTO cmok_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","យោឆែប​មឞើស​មា​ឞឹ​ពាង់៖ “មោ​អោស​ទី​កើត​នៃ​អើ​ឞឹ អី​អ្យា​ក៝ន​ឞោក​ទាក មៃ​តេៈ​តី​មា​មៃ​តា​ឞោក​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ឞឹ​ពាង់​មោ​អោស​អ្យាត់ ពាង់​លាស​មា​យោឆែប៖ “អើ​នោ គ៝ប់​លែៈ​គឹត គ៝ប់​លែៈ​គឹត​ជេស​មានាឆេ​ជេង​ក៝ន​ឞោក​ទាក ពាង់​តៃ​គែស​ទូ​ផូង​ក្វ៝ង់​ដ៝ង់។ យើន​មា​អេប្រាអីម​គែស​ទូ​ផូង​ក្វ៝ង់​រាលាវ​ពាង់​ងាន់។ រាន៝យ​ទែស​អេប្រាអីម​មរា​អ៝ក់​ផូង​អេងៗ​ក្វ៝ង់ៗ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","នារ​នៃ​អីឆ្រាអែល​អ៝ន់​គែស​ជេង​មា​ខាន់​ពាង់​ឞារ​ហៃ​អី​នៃ ពាង់​លាស៖ “ជឹត​នាប់​តៃ ទឹង​លែៈ​ផូង​អីឆ្រាអែល មរា​ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​ឞូ​កើត​នអា៖ «ទាន់​កោរាញ​ឞ្រាស​ជាន​អ៝ន់​មៃ​ជេង​តឹម​ឞាន​មា​អេប្រាអីម តឹម​ឞាន​មា​មានាឆេ»”។ កើត​នទ្រី​អីឆ្រាអែល​កើប​អេប្រាអីម​ខ្លៃ​រាលាវ​ដាស​មា​មានាឆេ។ ");
INSERT INTO cmok_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","អីឆ្រាអែល​ងើយ​មា​យោឆែប៖ “គ៝ប់​ឞើយ​មា​ខឹត​ជេស យើន​មា​កោរាញ​ឞ្រាស​មរា​គុ​នទ្រែល​ខាន់​មៃ នទ្រែល​មា​លែវ​ខាន់​មៃ​ព្លឹ​ឆឹត​តៃ​តា​ឞ្រី​ផូង​ចែ​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","គ៝ប់​អុច​ពាៈ​នែស​អ៝ន់​មៃ​ក្វ៝ង់​រាលាវ​ដាស​មា​ផូង​អ៝ស​នោ​មៃ ជេង​នែស​ទាច់​តា​ប៝ន​ឆីកែម​នៃ នតុក​អី​គ៝ប់​លែៈ​ទើយ​ពីត​តឹម​លើស​ដាស​ផូង​អាមោរី​មា​ដាវ មា​នា​ទុត​គ៝ប់​នើម​នៃ​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","យាកោប​អី​ឞូ​ក្វាល់​អីឆ្រាអែល​ដ៝ង់ ពាង់​ក្វាល់​ទឹង​លែៈ​ក៝ន​ពាង់​វាច់​តា​រី​ទាទេ ជេសរី​លាស៖ “ទាន់​ខាន់​មៃ​ហាន់​រឹង​ទាទេ គៃ​មា​គ៝ប់​មឞើស​ងក៝ច​អ៝ន់​ខាន់​មៃ​គឹត​ម៝ស​នាវ​គែស​តា​នារ​ជឹត​នាប់​អ្យា​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","អើ​ផូង​ក៝ន​ឆៅ​យាកោប វាច់​រឹង​ហ៝ម់​គៃ​មា​អ្យាត់ អ្យាត់​ហ៝ម់​នាវ​អីឆ្រាអែល​ឞឹ​ខាន់​មៃ​នើម។ ");
INSERT INTO cmok_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","អើ​រូបេន មៃ​ជេង​ក៝ន​ឞោក​ទាក​គ៝ប់ គ៝ប់​ឞាៈ​មៃ​ល៝រ​ឞូ​ទោល​គ៝ប់​គែស​ឆ្វាន​ទុត​ទាង់ មៃ​ឞូ​លឺ​រាលាវ​ឞូ នទ្រែល​មា​គែស​នាវ​ទើយ​រាលាវ​ឞូ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","មៃ​ទាង់​តឹម​ឞាន​មា​ទាក​រាឞុស មោ​អោស​ទើយ​អ៝ត់​ទើយ​រាទ៝ង់ តីស​មា​មៃ​មោ​អោស​ជាន​ឞោក យ៝រ​លាស​មៃ​ហាវ​កាលើ​គ្រែ​គ៝ប់ មៃ​ឞិច​នទ្រែល​មា​អូរ​គ៝ប់ ជាន​អ៝ន់​គ្រែ​គ៝ប់​អារ។ ");
INSERT INTO cmok_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","ឆីមោន នទ្រែល​មា​លេវី​ជេង​អ៝ស​នោ​ទូ​នទុល​ទែស នូយ្ស​នហ៝ម់​ខាន់​ពាង់​ហាត់​ជាញ​ងាន់ ខាន់​ពាង់​ងខឹត​ឞូ​មា​ដាវ។ ");
INSERT INTO cmok_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","គ៝ប់​មោ​អោស​អុច​គុ​នទ្រែល​ខាន់​ពាង់ នោក​ខាន់​ពាង់​តឹម​ញច្រាៈ​នាវ​ជាន​អ្យើស។ យ៝រ​លាស​នោក​ខាន់​ពាង់​ជី​នូយ្ស ខាន់​ពាង់​ងខឹត​ឞូ​នើស ជេសរី​ខាន់​ពាង់​ក៝ស​លើយ​ជ៝ង់​ជ៝ន​នទ្រោក​ងក្វ៝ង់​ទាស​ខាន់​ពាង់​នើម​អុច​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","គ៝ប់​រាក​រាតាប់​លើយ​នាវ​ជី​នូយ្ស​ខាន់​ពាង់ យ៝រ​មា​ខាន់​ពាង់​ហាត់​ជាញ​ហោ​អីរ ជេសរី​តា​នាវ​ជី​នូយ្ស​ខាន់​ពាង់​ជាន​នទើ​ទុត​អ្យើស​ហោ​ងាន់ ទាស​ខាន់​ពាង់​នើម​អុច គ៝ប់​មរា​ញចាស​លើយ​ខាន់​ពាង់​ឞារ​ហៃ​អី​នៃ​តា​រាន៝យ​ទែស​គ៝ប់ មោ​អោស​អ៝ន់​គុ​នទ្រែល​ទូ​នតុក​តា​ឞ្រី​អីឆ្រាអែល។ ");
INSERT INTO cmok_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","អើ​យូដា អ៝ស​នោ​មៃ​មរា​រានេ​មៃ​ទាទេ​ងាន់ មៃ​តៃ​ទើយ​លើស​ដាស​ផូង​រាលាង់​មា​មៃ អ៝ស​នោ​មៃ​តៃ​ពាន់​យើក​មា​មៃ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","អើ​យូដា​ក៝ន​គ៝ប់ មៃ​ជេង​តឹម​ឞាន​មា​ក៝ន​យៅ​មុរ ឆឹត​ហើម​ឞើស​កាប់​ឆា​មពោមពា​(ឆ្យុម) មៃ​តឹម​ឞាន​មា​យៅ​មុរ​អី​ពាន់​ញឆាន មៃ​តឹម​ឞាន​មា​យៅ​មុរ​អី​ឞិច មោ​គែស​អោស​ឞូនុយ្ស​ឞាញ់​រាខ្វាក។ ");
INSERT INTO cmok_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ម៝ង់​តាក់​ជ្រា​កាដាច់​គែស​តា​មៃ​នឹង រាន៝យ​ទែស​មៃ​តៃ​មរា​ជេង​កាដាច់​មរ៝​មរាង់ នហ៝​មា​ត៝ត់​ត្រុយ្ស​ពាង់​អី​គែស​នាវ​ទើយ​ក្វ៝ង់​នៃ នអ៝ប់​មា​ទឹង​លែៈ​ផូង​ឞូនុយ្ស​លាម​នតុក​អ្យាត់​នាវ​ពាង់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ពាង់​នទ្រ៝ង់​ងាន់ នទ្រី​ទឹង​ពាង់​ក៝ត់​ឆែស​លៀ​ពាង់​នើម​តា​តើម​ព្លៃ​យុងយារ​ប៝ន ឞ៝ល​លាស​តើម​ព្លៃ​នៃ​ទុត​ខ្លៃ ពាង់​មោ​អោស​រាវៃ​ឆែស​លៀ​ឆា​អី​ព្លៃ​អី​នហា​នៃ ពាង់​ពីស​អាវ​ពាង់​នើម​មា​ទាក​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន ពីស​ឞ៝ក​ពាង់​នើម​មា​ទាក​ព្លៃ​យុងយារ​ប៝ន​អី​ចាង់​តឹម​ឞាន​មា​មហាម។ ");
INSERT INTO cmok_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ត្រោម​មាត់​ពាង់​ចាង់​ងាន់​រាលាវ​មា​ទាក​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន ងលាង​ឆេក​ពាង់​រាលាវ​មា​ទាក​ត៝ស​នទ្រោក​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ឆាប់យូលោន​តៃ​គុ​រ៝ៈ​មែង​ទាក​វាច់​ទាក​វារ់ នតុក​ពាង់​ជេង​នតុក​ញឆ្រុង​ទូក​ក្វ៝ង់ នហារ់​នែស​ពាង់​នហ៝​មា​ត៝ត់​តា​ប៝ន​ឆីដោន​រី​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","អីឆាខារ​ជេង​តឹម​ឞាន​មា​ឆែស​លៀ​ទុត​ទាង់ ពាង់​ឞិច​តា​វាស​វាង​ងគារ​ឞែ​ឞ្យាប់។ ");
INSERT INTO cmok_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ពាង់​មឹន​លាស​នតុក​ពាង់​គុ​រាលូ​នៃ​ជេង​នតុក​អ្វែស នទ្រែល​មា​ទើស​ដ៝ង់ ជេសរី​ពាង់​កុញ​ឆាក់​ពាង់​នើម​អ៝ន់​ឞូ​ទ៝ង់​រាទែង​ទ្រាប់​នទើ តឹម​ឞាន​មា​ទឹក​ឞូ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ដាន​ជេង​កោរាញ​ម៝ត់​អ្វាញ់​មពោល​ប៝ន​លាន​ពាង់​នើម កើត​មពោល​អេងៗ​តា​ផូង​អីឆ្រាអែល​ទឹង​លែៈ​ដ៝ង់ ");
INSERT INTO cmok_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ពាង់​ជេង​តឹម​ឞាន​មា​ឞេស​ហូង​រ៝ៈ​ត្រ៝ង តឹម​ឞាន​មា​ឞេស​កូ​គុ​តា​មែង​ត្រ៝ង ក៝ប់​ចោក​តា​ជ៝ង់​ជ៝ន​ឆែស ជេសរី​ឞូនុយ្ស​អី​គុ​ញច៝​តា​កាលើ​រី​តុប​អា​នែស”។ ");
INSERT INTO cmok_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ជេសរី​យាកោប​មឞើស​ឆើម​លាស៖ “អើ​ឞ្រាស​យេហោវា គ៝ប់​ហោម​ក៝ប់​នារ​មៃ​រាក្លាយ្ស​គ៝ប់”។ ជេសរី​ពាង់​នហ៝​មា​លាស​មា​អ៝ស​ក៝ន​ពាង់​ជឹត៖ ");
INSERT INTO cmok_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“កាត​គែស​ផូង​តាហែន​ហាន់​លើស​ពាង់ យើន​មា​ពាង់​ហាន់​លើស​ផូង​តាហែន​អី​នៃ​តាៈ​ឞើស​កើយ។ ");
INSERT INTO cmok_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","អាឆើរ​គែស​នទើ​ឆោង​ឆា​កាស​ងាន់ ពាង់​តៃ​អ៝ន់​នទើ​ឆោង​ឆា​កាស​ងាន់​មា​អ៝ន់​កាដាច់​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","នាប់តាលី​ជេង​តឹម​ឞាន​មា​ងក្រ៝ង់​មែ​លែៈ​ក្លាយ្ស ពាង់​ឞាៈ​ក៝ន​អ្វែសៗ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","យោឆែប​ជេង​តឹម​ឞាន​មា​ងគីង​គែស​ព្លៃ​អ៝ក់ ងគីង​គែស​ព្លៃ​អ៝ក់​ហ៝ន​កេង​មែង​នហ៝ង​ទាក ងគីង​ពាង់​ព្រេស​រាលាវ​មពេរ​ប៝ន​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ផូង​រាលាង់​តឹម​លើស​ដាស​ពាង់ ឞូ​ពាញ់​ពាង់​មា​នា ");
INSERT INTO cmok_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","យើន​មា​យោឆែប​ហោម​ទាង់​រាលាវ ពាង់​ហោម​ទាង់​ងាន់ យ៝រ​មា​គែស​នាវ​ទើយ​កោរាញ​ឞ្រាស​អី​គ៝ប់​យើក​មឞាស។ កោរាញ​ឞ្រាស​ទុត​គែស​នាវ​ទើយ​ងាន់ មោ​គែស​អោស​ឞូនុយ្ស​ទើយ​ដ៝ង់។ កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ផូង​អីឆ្រាអែល តឹម​ឞាន​មា​នើម​ច្យាប់​មពោមពា​(ឆ្យុម)​ផូង។ កោរាញ​ឞ្រាស​ទុត​ន៝ប់​មា​កើល​ញជ្រាង់ តឹម​ឞាន​មា​លុ​ក្លេរ​មោ​អោស​ទើយ​ងគើ។ ");
INSERT INTO cmok_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","កោរាញ​ឞ្រាស​អី​ឞ្រាស​គ៝ប់​យើក​មឞាស​មរា​កើល​មៃ កោរាញ​ឞ្រាស​នើម​អី​ទុត​គែស​នាវ​ទើយ​មរា​អ៝ន់​នាវ​គែស​ជេង​មា​មៃ ពាង់​មរា​អ៝ន់​គែស​ទាក​មីស​មា​មៃ ពាង់​មរា​អ៝ន់​គែស​ទាក​លោស​តាៈ​ឞើស​ទ៝ង់​ឆូ​មា​មៃ នទ្រែល​មា​អ៝ន់​មៃ​គែស​ក៝ន​អ៝ក់ នអ៝ប់​មា​គែស​មពោមពា​(ឆ្យុម)​អ៝ក់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","នាវ​គែស​ជេង​គ៝ប់​ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​មា​មៃ​អ្យា ជេង​ក្វ៝ង់​រាលាវ​មា​នាវ​គែស​ជេង​ផូង​ចែ​គ៝ប់​ទាន់​ឞើស​កោរាញ​ឞ្រាស​អ៝ន់​មា​គ៝ប់ ជេង​ព្រេស​រាលាវ​មា​យោក​ទុត​ន៝ប់​នហ៝​រ៝​ជឹត ទាន់​ទឹង​លែៈ​នាវ​គែស​ជេង​អ្យា​អ៝ន់​គែស​តា​មៃ ទាន់​អ៝ន់​គែស​តា​ឞោក​មៃ​អី​លែៈ​កោរាញ​ឞ្រាស​តឹម​ងខាស​ជេស​ដាស​ផូង​អ៝ស​នោ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","បែនយាមឹន​ជេង​តឹម​ឞាន​មា​ឆ៝​ឞ្រី​ទុត​ជាញ អា​អោយ​ពាង់​ហាន់​កាប់​ឆា​ហេក​មពោមពា​(ឆ្យុម) ត៝ត់​កេង​មាង់​ពាង់​តឹម​ពាៈ​មពា​ពាង់​គ្លែង​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ទឹង​លែៈ​ផូង​ខាន់​ពាង់​អី​នៃ​ជេង​មពោល​រាន៝យ​ទែស​ផូង​អីឆ្រាអែល អី​នៃ​ជេង​នាវ​ឞឹ​ខាន់​ពាង់​នតិញ​មា​ខាន់​ពាង់ ពាង់​ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​ខាន់​ពាង់ ១២ នុយ្ស​នៃ ទូ​ហ្វេ​ទូ​ហ្វេ​ពាង់​អ៝ន់​អេងៗ តឹម​ទី​មា​អាប់​នើម​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ជេសរី​យាកោប​នតិញ​មា​ផូង​អ៝ស​ក៝ន​ពាង់៖ “ហោម​ទូ​ប្ល៝ត់​គ៝ប់​តៃ​ខឹត គ៝ប់​ហាន់​តឹម​ម៝ប់​មា​ផូង​ចែ​គ៝ប់​នើម។ អ៝ន់​ខាន់​មៃ​លែវ​ត៝ប់​គ៝ប់​កេង​មោច​ផូង​ចែ​គ៝ប់​តា​ត្រោម​យោក​តា​មីរ​អេប្រុន​ផូង​ហេត‌ ");
INSERT INTO cmok_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ជេង​តា​មីរ​មាក់ពេលា តឹម​ទាច់​មា​ប៝ន​មាម់រេ​តា​ឞ្រី​កានាន មីរ​នៃ​លែៈ​ចែ​អាឞ្រាហាម់ ​ទែ​រាវាត់​តាៈ​ឞើស​អេប្រុន​ផូង​ហេត គៃ​មា​នតុក​មោច។ ");
INSERT INTO cmok_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","តា​នតុក​នៃ​ឞូ​ត៝ប់​ចែ​អាឞ្រាហាម់  នទ្រែល​មា​អូ​ឆារា​អូរ​ពាង់ ឞូ​ត៝ប់​អីឆាក់ នទ្រែល​មា​រេបេកា​អូរ​ពាង់ លេអា​គ៝ប់​ត៝ប់​ពាង់​តា​នតុក​អី​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","មីរ​នទ្រែល​មា​នតូ​យោក​អី​នៃ​លែៈ​ចែ​អាឞ្រាហាម់ ​ទែ​រាវាត់​ឞើស​ផូង​ហេត”។ ");
INSERT INTO cmok_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ជេស​យាកោប​នតិញ​មា​ផូង​អ៝ស​ក៝ន​ពាង់​លែៈ​ផ្យៅ ជេសរី​ពាង់​យើក​ជ៝ង់​ល៝ង់​ឆាក់​តា​គ្រែ​ពាង់​នើម​រី នហ៝​មា​រ៝ស​នហ៝ម់​ហាន់​តឹម​ម៝ប់​មា​ផូង​ចែ​ពាង់​នើម​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","យោឆែប​អូត​ចុម​ឞឹ​ពាង់ ញុម​តា​មុស​មាត់​ឞឹ​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","យោឆែប​ដាៈ​ផូង​កោរាញ​ទាក​ឆី​ជាន​អ្វែស​ឆាក់​ឞឹ​ពាង់​រី។ ជេសរី​ផូង​កោរាញ​ទាក​ឆី​ខាន់​ពាង់​លែវ​ឞាល់​ជាន​អ្វែស​ឆាក់​អីឆ្រាអែល​អី​រី​មា​នទើ​បោ​កាស គៃ​មា​មោ​អោស​អោម​នតោ​មលៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ខាន់​ពាង់​ជាន​កើត​នៃ​គែស ៤០ នារ ទាស​នៃ​នាវ​ជ៝ៈ​ខាន់​ពាង់​ជាន​អ្វែស​ឆាក់​គៃ​មា​ត៝ប់។ ផូង​អេឆីប ​គុ​ងក្ល៝ន់​រាង៝ត​យាកោប​អី​ឞូ​ក្វាល់​អីឆ្រាអែល​ដ៝ង់ ទឹង​លែៈ​គែស ៧០ នារ។ ");
INSERT INTO cmok_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ត៝ត់​លែៈ​លោច​ជេស​នាវ​ខាន់​ពាង់​គុ​ងក្ល៝ន់​រាង៝ត​នៃ យោឆែប​លាស​មា​ផូង​កោរាញ​កាដាច់​ផារ៝ន​កើត​នអា៖ “លាស​ខាន់​មៃ​យោៈ​មា​គ៝ប់ ទាន់​ខាន់​មៃ​មឞើស​ងក៝ច​នាវ​គ៝ប់​អ៝ន់​មា​ផារ៝ន​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ឞឹ​គ៝ប់​ដាៈ​គ៝ប់​ត៝ន​មា​ពាង់៖ «គ៝ប់​រេស​មោ​ហោម​អោស​ជ៝ៈ​ដ៝ង់ ត៝ត់​គ៝ប់​ខឹត​តៃ​អ៝ន់​មៃ​ត៝ប់​គ៝ប់​តា​មោច​គ៝ប់​លែៈ​ជេស​នទ្រាប់​តា​ឞ្រី​កានាន​រី»។ លាស​នទ្រី​អាបៃ​អ្យា​គ៝ប់​ទាន់​ហាន់​ត៝ប់​ឞឹ​គ៝ប់ ជេសរី​ទឹង​គ៝ប់​ព្លឹ​តៃ​តា​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","កាដាច់​ផារ៝ន​លាស​មា​ពាង់៖ “មៃ​ហាន់​ត៝ប់​ឞឹ​មៃ​រី​ហ៝ម់ កើត​នាវ​មៃ​លែៈ​ជេស​ត៝ន​ដាស​ពាង់​រី​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ជេសរី​យោឆែប​ហាន់​ត៝ប់​ឞឹ​ពាង់​អា​រី ទឹង​លែៈ​ផូង​កោរាញ​កាដាច់​ផារ៝ន ទឹង​លែៈ​មពោល​ឞូ​រាញ​តា​ជៃ​កាដាច់ នទ្រែល​មា​ទឹង​លែៈ​ផូង​កោរាញ​តា​ឞ្រី​អេឆីប ​រី ខាន់​ពាង់​ហាន់​នហ៝ច​នទ្រែល​មា​យោឆែប​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ទឹង​លែៈ​រានាក់​វ៝ល់​យោឆែប អ៝ស​នោ​ពាង់ នទ្រែល​មា​ទឹង​លែៈ​នទុល​មពោល​ឞឹ​ពាង់ ហាន់​ទាទេ​ដ៝ង់ ហោម​អែ​ក៝ន​ឆែ​ជេៈៗ នទ្រែល​មា​នទ្រោក ឞែ​ឞ្យាប់​ទូ​រី​ទើម​ហោម​គុ​តា​ឞ្រី​កោឆែន​រី។ ");
INSERT INTO cmok_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","គែស​អ៝ក់​ហាន់​នទ្រែល​តា​នៃ គែស​នអ៝ប់​មា​រាទែស​ឆែស គែស​នអ៝ប់​មា​តាហែន​ញច៝​ឆែស អ៝ក់​នហ៝ច​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ត៝ត់​តា​នតុក​អាថាត​រី​ជេង​នតុក​ឞូ​រាពាត់​ព្លេន​ឞា កាល់​អា​ទាក​រាលាយ​យោរដាន់ ខាន់​ពាង់​គុ​ញុម​ក្ល៝ង់​រាង៝ត​តា​នតុក​នៃ​ក្វ៝ង់​ងាន់។ យោឆែប​លែវ​ខាន់​ពាង់​ងក្ល៝ន់​រាង៝ត​មា​ឞឹ​ពាង់​តា​នតុក​នៃ​ពើស​នារ។ ");
INSERT INTO cmok_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ទោល​ផូង​អេឆីប ​គែស​នាវ​ងក្ល៝ន់​រាង៝ត​តា​អាថាត​នៃ ផូង​ឞ្រី​កានាន​អី​គុ​តា​នៃ​តឹម​លាស៖ “យី! ហោ​ងាន់​ងក្ល៝ន់​រាង៝ត​ផូង​អេឆីប ​នៃ​ហៃ”។ កើត​នទ្រី​ទឹង​ឞូ​ក្វាល់​នតុក​កាល់​អា​ទាក​រាលាយ​យោរដាន់​អី​នៃ​លាស៖ “អាបែល-​មីឆ្រែម” គែស​នាវ​ខ្លៃ​លាស​«នាវ​ញុម​រាង៝ត​អេឆីប»។ ");
INSERT INTO cmok_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ផូង​អ៝ស​ក៝ន​យាកោប​ជាន​កើត​នាវ​ពាង់​នតិញ​មា​ខាន់​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ខាន់​ពាង់​ត៝ប់​យាកោប​តា​ឞ្រី​កានាន តា​មីរ​ត្រោម​យោក​មាក់ពេលា​មពែស​ឞើស​លោស​នារ​ប៝ន​មាម់រេ ជេង​នតុក​មីរ​លែៈ​អាឞ្រាហាម់ ​ទែ​រាវាត់​តាៈ​ឞើស​អេប្រុន​ផូង​ហេត​នៃ​នើស គៃ​មា​នតុក​មោច។ ");
INSERT INTO cmok_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ជេស​ត៝ប់​ឞឹ​ពាង់​រី​ផ្យៅ យោឆែប នទ្រែល​មា​ផូង​អ៝ស​នោ​ពាង់ នអ៝ប់​មា​ផូង​ហាន់​ត៝ប់​ឞឹ​ពាង់​អី​រី​នើស ខាន់​ពាង់​ព្លឹ​ឆឹត​តា​ឞ្រី​អេឆីប ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","អី​នោៗ​យោឆែប​ត៝ត់​ឞឹ​ខាន់​ពាង់​លែៈ​ខឹត ខាន់​ពាង់​នតើម​គែស​នាវ​មឹន​រាវៃ​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់៖ “ក្លាប់​លាស​យោឆែប​ឞ្យាញ់​មា​ឞ៝ន់​រ៝ ពាង់​ព្លើង​នាវ​ឞ៝ន់​ជាន​អ្យើស​មា​ពាង់​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ជេសរី​ខាន់​ពាង់​អ៝ន់​ទូ​ហ្វេ​ហាន់​ងើយ​មា​យោឆែប៖ “ឞឹ​ឞ៝ន់​នតិញ​មា​មៃ​កើត​នអា​អេ​ល៝រ​ពាង់​មា​ខឹត​នើស៖ ");
INSERT INTO cmok_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«ខាន់​មៃ​មឞើស​ងក៝ច​មា​យោឆែប៖ «អើ​ក៝ន ទាន់​មៃ​យោៈ​នអាច​មា​នោៗ​មៃ លើយ​ក្លាប់​នទាង់​នាវ​តីស​ខាន់​ពាង់​ជាន​អ្យើស​មា​មៃ»។ នាវ​តីស​ហេន​ជាន​មា​មៃ​នើស​ហោ​ងាន់​ដ៝ង់ លាស​នទ្រី​ទាន់​មៃ​លើយ​ក្លាប់​នទាង់​មា​ហេន​ជេង​ផូង​ជាន​ការ​មា​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ឞឹ​ឞ៝ន់​យើក​មឞាស”។ យោឆែប​តាង់​នាវ​នៃ ពាង់​ញហ្យាង់​ញុម​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ជេសរី​ទឹង​លែៈ​នោៗ​យោឆែប ហាន់​តឹម​ម៝ប់​មា​ពាង់ ពាន់​តា​នាប់​ពាង់ លាស​មា​ពាង់៖ “ទឹង​លែៈ​ហេន​ជាន​ទឹក​មៃ​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","យោឆែប​លាស​មា​ខាន់​ពាង់៖ “លើយ​ក្លាច យ៝រ​លាស​គ៝ប់​មោ​អោស​កោរាញ​ឞ្រាស​ទឹង​ផាត​ទោយ្ស​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ខាន់​មៃ​តឹម​ទី​ទូ​នតោរ​នាវ​ជាន​អ្យើស​មា​គ៝ប់​នើស យើន​មា​កោរាញ​ឞ្រាស​ជាន​នាវ​នៃ​ជេង​អ្វែស កោរាញ​ឞ្រាស​រាក្លាយ្ស​ឞូនុយ្ស​ទុត​អ៝ក់ កើត​មា​ឞ៝ន់​លែៈ​ឆៃ​អាបៃ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","អើ​នោ ខាន់​មៃ​លើយ​អោស​ក្លាច តៃ​គ៝ប់​ហោម​ម៝ត់​ឆ្យាម់​ខាន់​មៃ នទ្រែល​មា​អ៝ស​ក៝ន​ខាន់​មៃ”។ នទ្រី​នាវ​យោឆែប​ឞ៝ញ​លែង​នោៗ​ពាង់ ងើយ​អ្វែស​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","យោឆែប​នទ្រែល​មា​ទឹង​លែៈ​រានាក់​វ៝ល់​ឞឹ​ពាង់​ហោម​គុ​តា​ឞ្រី​អេឆីប ។ យោឆែប​រេស​គែស ១១០ នាម់។ ");
INSERT INTO cmok_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","យោឆែប​ឆៃ​ក៝ន​ឆៅ​អេប្រាអីម​ត៝ត់​មា​ឆែ នទ្រែល​មា​ពាង់​លែៈ​ឆៃ​ដ៝ង់​អី​ក៝ន​មាកីរមាកីរ​នៃ​ជេង​អី​ក៝ន​មានាឆេ ទឹង​លែៈ​ឆែ​អី​នៃ​ពាង់​កើប​ជេង​ក៝ន​ពាង់​នើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","នោក​យោឆែប​ឞើយ​មា​ខឹត ពាង់​ងើយ​មា​ផូង​អ៝ស​នោ​ពាង់៖ “គ៝ប់​ឞើយ​មា​ខឹត​ជេស យើន​មា​កោរាញ​ឞ្រាស​គុ​នទ្រែល​ខាន់​មៃ ពាង់​មរា​លែវ​ខាន់​មៃ​ទូ​លោស​ឞើស​ឞ្រី​អ្យា​ឆឹត​តា​ឞ្រី​នតុក​ពាង់​លែៈ​ត៝ន​មា​អាឞ្រាហាម់  មា​អីឆាក់ នទ្រែល​មា​យាកោប​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ជេសរី​យោឆែប​អ៝ន់​ផូង​ក៝ន​ឆៅ​អីឆ្រាអែល​ត៝ន​មា​ពាង់៖ “ត៝ត់​កោរាញ​ឞ្រាស​ហាន់​កើល​ខាន់​មៃ​តៃ អ៝ន់​ខាន់​មៃ​ឆើម​ញអោត​នតីង​គ៝ប់​ឞើស​នតុក​អ្យា​លែវ​នទ្រែល​មា​ខាន់​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","យោឆែប​រេស​គែស ១១០ នាម់ ជេសរី​ពាង់​ខឹត ឞូ​ជាន​អ្វែស​ឆាក់​ពាង់ តេៈ​ពាង់​តា​ឞាង់ ជេសរី​ឞូ​ត៝ប់​ពាង់​តា​ឞ្រី​អេឆីប ​រី៕៚");
INSERT INTO cmok_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","រានោក​កាល់​អែ​តា​ឞ្រី​អីឆ្រាអែល ​អេ​ល៝រ​មា​គែស​កាដាច់ គែស​កោរាញ​ផាត​ទោយ្ស​ទើម​កើល​ម៝ត់​អ្វាញ់​ប៝ន​លាន​តា​ឞ្រី​អី​នៃ។ នោក​នៃ​គែស​ឞារ​ហៃ​អូរ​ឆាយ​គុ​តា​ប៝ន​បេតលេហឹម ​តា​ឞ្រី​យូដា ។ តា​ឞ្រី​នៃ​គែស​នាវ​ត៝ត់​ជី​ឆ៝ត់​ជី​ង៝ត​ក្វ៝ង់​ឞេង​ឞ្រី​ងាន់។ យ៝រ​មា​គែស​នាវ​ជី​ឆ៝ត់​ជី​ង៝ត​ក្វ៝ង់​អី​នៃ​ខាន់​ពាង់​លែវ​ឞារ​ហៃ​ក៝ន​ឞូ​ក្លោ​ខាន់​ពាង់​ទូ​ឞើស​ឞ្រី​យូដា ​ហាន់​គុ​ជឹត​ឞ្រី​មោអាប់ ។ ");
INSERT INTO cmok_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","អី​ឆាយ​នៃ​រាញា​អេលីមាលេក  អី​អូរ​ពាង់​រាញា​នាអោមី  អី​ក៝ន​ពាង់​រាញា​មាលោន  នទ្រែល​មា​កីលីយោន  ខាន់​ពាង់​តាៈ​ឞើស​ឞាល់​មពោល​អេព្រាតា ​តា​ប៝ន​បេតលេហឹម ​តា​ឞ្រី​យូដា  ជេសរី​ខាន់​ពាង់​គុ​តា​ឞ្រី​មោអាប់ ។ ");
INSERT INTO cmok_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","ត៝ត់​អា​កើយ​រី អេលីមាលេក ​ខឹត នត្លើយ​អូរ​នទ្រែល​មា​ក៝ន​ពាង់​ឞារ​ហៃ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","ជេសរី​ក៝ន​ពាង់​ឞារ​ហៃ​អី​នៃ​ឆ៝ៈ​អូរ​ឞើស​ផូង​មោអាប់  ទូ​ហ្វេ​រាញា​អោរពា  ទូ​ហ្វេ​ជឹត​រាញា​រូត  ខាន់​ពាង់​គុ​តា​ឞ្រី​អី​នៃ​ក្លាប់​លាស​គែស​ជឹត​នាម់។ ");
INSERT INTO cmok_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","ជេសរី​មាលោន ​នទ្រែល​មា​កីលីយោន ​នៃ​ខឹត​ដ៝ង់ នត្លើយ​អី​មេៈ​គុ​ទូ​ហ្វេ​អេង ខឹត​លែៈ​ក៝ន​លែៈ​ឆាយ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","គែស​ទូ​នារ​រី​នាអោមី ​លឺ​តាង់​ឞូ​ងក៝ច​លាស​ឞ្រាស​យេហោវា លែៈ​កើល​ប៝ន​លាន​ផូង​អីឆ្រាអែល ​អី​ប៝ន​លាន​ពាង់​នើម​អ៝ន់​គែស​ជេង​គែស​នទើ​ឆោង​ឆា​ត៝ង់​តា​ឞ្រី​យូដា ។ ជេសរី​ពាង់​នទ្រែល​ឞារ​ហៃ​អី​មាន់​នៃ​នទ្រាប់​នទ៝ស​នទើ​ព្លឹ​ឆឹត​ជឹត​ប៝ន​ពាង់​នើម​រី។ ");
INSERT INTO cmok_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","ពែ​នុយ្ស​ខាន់​ពាង់​ទូ​ឞើស​នតុក​នៃ​ហាន់​រ៝ៈ​ត្រ៝ង​ងាយ​ឆឹត​តៃ​តា​ឞ្រី​យូដា ។ ");
INSERT INTO cmok_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","ជេសរី​នាអោមី ​លាស​មា​អី​មាន់​ពាង់​ឞារ​ហៃ​នៃ៖ “ខាន់​បែ​ហាន់​ឆឹត​តឹង​មេៈ​ឞឹ​ខាន់​បែ​នើម​អា​រី​ទោស! ខាន់​បែ​នើស​លែៈ​ជាន​នាវ​អ្វែស​មា​ក៝ន​គ៝ប់​លែៈ​ខឹត នទ្រែល​មា​គ៝ប់​នើម​ដ៝ង់។ គ៝ប់​ទាន់​ឞ្រាស​យេហោវា​ជាន​នាវ​អ្វែស​មា​ខាន់​បែ​កើត​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","គ៝ប់​ទាន់​ឞ្រាស​យេហោវា​អ៝ន់​ខាន់​បែ​ឞារ​ហៃ​អ្យា​គែស​ឆាយ​តៃ រេស​ជេង​អ្វែស​ដាប់​មពាន់​តា​រានាក់​វ៝ល់”។ ជេសរី​អី​ព៝​ចុម​នតិញ​អី​មាន់​ពាង់​ឞារ​ហៃ​នៃ​តឹង​មា​នាវ​វៃ​ខាន់​ពាង់។ ខាន់​ពាង់​ឞារ​ហៃ​នៃ​ញុម​លុង​ងាន់ ");
INSERT INTO cmok_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","ងើយ​មា​អី​ព៝​ពាង់​លាស៖ “ហេន​មោ​អុច​អោស​តឹម​ងខាស! ហេន​អុច​តឹង​គុ​នទ្រែល​បែ នទ្រែល​មា​ប៝ន​លាន​បែ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","តីស​មា​នាអោមី ​មោ​រ៝ម៖ “ហើយ​ក៝ន! ខាន់​បែ​ព្លឹ​ឆឹត​អា​រី​ហ៝ម់ ម៝ស​នាវ​ខាន់​បែ​អុច​ឞ្រោៈ​នទ្រែល​គ៝ប់? គ៝ប់​លែៈ​អ៝ក់​នាម់​ហើយ មោ​ហោម​អោស​ឞាៈ​ក៝ន​មា​នត្រ៝ៈ​ឆាយ​ខាន់​បែ​តឹង​នាវ​វៃ​ឞ៝ន់។ ");
INSERT INTO cmok_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","ព្លឹ​ឆឹត​អា​រី​ហ៝ម់! យ៝រ​លាស​គ៝ប់​លែៈ​រាញ​ហើយ្ស​លិច​ហោម​គែស​ឆាយ​តៃ​អោស។ ឞ៝ល​លាស​គ៝ប់​ហោម​រានើម​គែស​ក៝ន លាស​គែស​ឆាយ​គុ​ដាស​គ៝ប់​តា​មាង់​អ្យា ជេសរី​គែស​ឞារ​ហៃ​ក៝ន​ឞូ​ក្លោ‌ ");
INSERT INTO cmok_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","លាស​នទ្រី​អើម​ខាន់​បែ​អុច​ក៝ប់​ខាន់​ពាង់​ត្រុយ្ស​ក្វ៝ង់​លាស? អើម​ខាន់​បែ​អុច​គុ​ទើម​លិច​អុច​ឆ៝ៈ​ឆាយ​លាស? មោ​អោស! ជាន​កើត​រី​លិច​ទី​អោស! ឞ្រាស​យេហោវា​លែៈ​តឹម​រាទ៝ង់​ដាស​គ៝ប់​ជាន​អ៝ន់​នាវ​រេស​គ៝ប់​អ៝ត​នូយ្ស​អ៝ត​នហ៝ម់​រាលាវ​មា​ខាន់​បែ​នៃ​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","ជេសរី​ឞារ​ហៃ​អី​មាន់​ពាង់​នៃ​ញុម​លុង​ទូ​តឹ​ជឹត អី​មាន់​រាញា​អោរពា ​នៃ​ចុម​នតិញ​ព៝​ពាង់​ទូ​តឹ​ជឹត យ៝រ​មា​ពាង់​លែៈ​អុច​ព្លឹ​ឆឹត​តា​រានាក់​វ៝ល់​ពាង់​នើម យើន​មា​អី​មាន់​រាញា​រូត ​នៃ​ក្វាន់​រាទ៝ង់​ព៝​ពាង់​ហោ​ងាន់ មោ​អុច​អោស​ងខាស​ដាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","នាអោមី ​ងើយ​មា​រូត ៖ “ហើយ​មាន់ មាន់​បែ​លែៈ​ព្លឹ​ឆឹត​ជ៝យ​នទុល​មពោល​ពាង់​នើម ព្លឹ​ឆឹត​យើក​មឞាស​ឞ្រាស​ពាង់​នើម​ដ៝ង់។ អ៝ន់​បែ​តឹង​មាន់​បែ​អា​រី​ហ៝ម់!” ");
INSERT INTO cmok_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","ជេសរី​រូត ​អើស៖ “ទាន់​បែ​លើយ​អោស​នត្រុត​គ៝ប់​ទូ​ឞើស​បែ លើយ​អោស​ឞ្វៃ​គ៝ប់​តឹង​បែ! អាស​នតុក​បែ​ហាន់ គ៝ប់​ហាន់​តា​រី​ដ៝ង់ អាស​នតុក​បែ​គុ គ៝ប់​គុ​តា​រី​ដ៝ង់ ផូង​ប៝ន​លាន​បែ​ជេង​ផូង​ប៝ន​លាន​គ៝ប់ ឞ្រាស​អី​បែ​យើក​មឞាស​ជេង​ឞ្រាស​អី​គ៝ប់​យើក​មឞាស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","អាស​នតុក​បែ​ខឹត គ៝ប់​ខឹត​តា​រី​ដ៝ង់ ជេសរី​ឞូ​ត៝ប់​គ៝ប់​តា​នតុក​នៃ​ដ៝ង់។ នាវ​ខឹត​ទើម​ទើយ​តឹម​ងខាស​គ៝ប់​ឞើស​បែ លាស​មោ​ងាន់ ទាន់​ឞ្រាស​យេហោវា ​តេៈ​ទោយ្ស​ក្វ៝ង់​មា​គ៝ប់​ទោស!” ");
INSERT INTO cmok_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","ត៝ត់​តាង់​អី​មាន់​ពាង់​អុច​គុ​នទ្រែល​ទុត​ហោ​កើត​នទ្រី នាអោមី ​រ៝ម ជេសរី​គុ​អ្យាត់​ឆាក់​រាក្លាក់។ ");
INSERT INTO cmok_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","ជេសរី​ខាន់​ពាង់​ឞ្រោៈ​ត៝ត់​តា​ប៝ន​បេតលេហឹម។ នោក​ខាន់​ពាង់​ឞារ​ហៃ​ត៝ត់​តា​ប៝ន​នៃ​លែៈ​រាងោច​ប៝ន​លាន​នទ្រ៝ត់​ទាទេ ជេសរី​គែស​ផូង​ឞូ​អូរ​តឹម​អោប​លាស៖ “យោស​អី​នៃ នាអោមី ​ងាន់​លាស​ហ្យាស?” ");
INSERT INTO cmok_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","យើន​មា​ពាង់​អើស​លាស៖ “លើយ​ហោម​ក្វាល់​គ៝ប់​«នាអោមី »​ជឹត​អោស ក្វាល់​គ៝ប់​«មារា »​ហ៝ៈ យ៝រ​លាស​នាអោមី ​គែស​នាវ​ខ្លៃ​«នាវ​រាម់​មអាក» តីស​មា​មារា ​គែស​នាវ​ខ្លៃ​«នទើ​តាង់​ខែរ​ងាន់»។ យ៝រ​លាស​កោរាញ​ឞ្រាស​អី​គែស​នាវ​ទើយ​ទុត​ព្រេស​ទុត​ក្វ៝ង់​ជាន​អ៝ន់​នាវ​រេស​គ៝ប់​អ៝ត​នូយ្ស​អ៝ត​នហ៝ម់។ ");
INSERT INTO cmok_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","គ៝ប់​ទូ​តាៈ​ឞើស​អ្យា​នើស​គែស​នទើ​អាប់​នតីល តីស​មា​ឞ្រាស​យេហោវា​អ៝ន់​គ៝ប់​ព្លឹ​ឆឹត​តា​អ្យា​ជ៝ង់​លាង​មពាង​តី​ទើម ម៝ស​នាវ​ហោម​ក្វាល់​គ៝ប់ «នាអោមី »? ឞ្រាស​យេហោវា ​តឹម​រាទ៝ង់​ដាស​គ៝ប់ ជេង​កោរាញ​ឞ្រាស​អី​គែស​នាវ​ទើយ​ទុត​ព្រេស​ទុត​ក្វ៝ង់​អ៝ន់​គែស​នាវ​ជេរ​ជ៝ត់​មា​គ៝ប់!” ");
INSERT INTO cmok_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","នទ្រី​នាវ​នាអោមី ​ព្លឹ​ឆឹត​តា​ប៝ន​ពាង់​នើម លែវ​នអ៝ប់​មា​អី​មាន់​ពាង់​តាៈ​ឞើស​ឞ្រី​មោអាប់ ​ឆឹត​នហាញ​ដ៝ង់។ ខាន់​ពាង់​ឞារ​ហៃ​ត៝ត់​តា​ប៝ន​បេតលេហឹម ​តា​ខៃ​នតើម​រែក​ឞា​ព្រាង់ ។ ");
INSERT INTO cmok_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","តា​ប៝ន​បេតលេហឹម ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ឞាល់​មពោល​តឹម​ទាច់​ដាស​ឆាយ​នាអោមី ​រាញា​ឞោអាស  ពាង់​ឞូ​តេស​ឞូ​ក្វ៝ង់​គែស​ទ្រាប់​នទើ​អ៝ក់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","គែស​ទូ​នារ​រី​រូត ​អី​ផូង​មោអាប់ ​នៃ​នើស​ងើយ​មា​ព៝​ពាង់៖ “ហើយ​អូ អ៝ន់​គ៝ប់​ឞ្រោៈ​ទោញ​ឞា​ព្រាង់ ​តា​មីរ​ឞូ​យឹ បារ​នា​ឞូ​យោៈ​អ៝ន់​គ៝ប់​ទោញ​ឞើស​កើយ​ឞូ”។ នាអោមី ​អើស៖ “ឞ្រោៈ​ហែស​មាន់!” ");
INSERT INTO cmok_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","ជេសរី​រូត ​ឞ្រោៈ​ទោញ​ឞា​អី​តុប​ឞើស​កើយ​មពោល​អី​រែក​ឞា​រី​អ៝ន់​មា​ពាង់​នើម គែស​ទោញ​ព្លាង់​មីរ​ឞោអាស ​អី​ឞាល់​មពោល​អេលីមាលេក ​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","ជេសរី​ឞោអាស ​ឞ្រោៈ​តាៈ​ឞើស​ប៝ន​បេតលេហឹម  ត៝ត់​តា​នៃ​ពាង់​អោប​អ្វែស​លាង់​មា​មពោល​រែក​ឞា​នៃ៖ “ទាន់​ឞ្រាស​យេហោវា​គុ​នទ្រែល​ខាន់​អៃ​មៃ!” ខាន់​ពាង់​អើស៖ “ទាន់​ឞ្រាស​យេហោវា​អ៝ន់​នាវ​គែស​ជេង​មា​កោរាញ​ដ៝ង់!” ");
INSERT INTO cmok_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","ជេសរី​ឞោអាស ​អោប​ឞូ​ក្លោ​អី​ម៝ត់​អ្វាញ់​មពោល​រែក​ឞា​នៃ៖ “ឞូ​ម៝ស​មពោល​ឞូ​អូរ​ទ្រោស​អី​ត៝​មេស?” ");
INSERT INTO cmok_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","ពាង់​អើស៖ “ឞូ​អូរ​ផូង​មោអាប់ ​អី​ឆឹត​នទ្រែល​នាអោមី ​ឞើស​ឞ្រី​មោអាប់ ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","ពាង់​ទាន់​តឹង​ឞើស​កើយ​ឞូ​គៃ​មា​រាបុន​ឞា​អី​តុប​តា​នែស ពាង់​ឞ្រោៈ​ទោញ​អើម​អោយ​ញឆ្រោយ្ស​នហ៝​មា​ត៝ត់​អាបៃ​អ្យា ពាង់​រាលូ​តា​ងកឺប​ទូ​នទ៝ម់​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","ជេសរី​ឞោអាស ​ហាន់​ម៝ប់​រូត ​អា​ត៝​លាស​មា​ពាង់៖ “ហើយ​អ៝ស ទាន់​អ្យាត់​គ៝ប់​យឹ! លើយ​ទោញ​ឞា​តា​មីរ​ឞូ​អេង​យឹ មោ​ខាច់​អោស​ហាន់​តា​មីរ​ឞូ​អេង ហាន់​គុ​នទ្រែល​ឞូ​អូរ​អ៝ស​ម៝ន​គ៝ប់​តា​អ្យា​ហ៝ៈ! ");
INSERT INTO cmok_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","អ្វាញ់​អាស​នតុក​ឞូ​រែក ជេសរី​តឹង​ខាន់​ពាង់​ឞើស​កើយ​ឞើស​កើយ នទ្រែល​មា​ផូង​ឞូ​អូរ គ៝ប់​ឞ្វៃ​អ៝ស​ម៝ន​ផូង​ឞូ​ក្លោ មោ​អោស​អ៝ន់​ជាន​អ្យើស​មា​អៃ។ លាស​អៃ​ជី​ហីរ​ទាក ញេត​ទាក​នោង​អី​អ៝ស​ម៝ន​គ៝ប់​មឞុក​នៃ​ហ៝ៈ!” ");
INSERT INTO cmok_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","ជេស​រូត ​តាង់​នាវ​នៃ​ពាង់​ពាន់​តា​នែស ជេសរី​អើស​មា​ឞោអាស ៖ “ម៝ស​នាវ​កោរាញ​យោៈ​មា​គ៝ប់​ឞូនុយ្ស​ផូង​ឞូ​នាច់​អេង​អ្យា?” ");
INSERT INTO cmok_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","ឞោអាស ​លាស៖ “ឞូ​ងក៝ច​មា​គ៝ប់​លែៈ​រាងោច​នាវ​អៃ​ជាន​មា​ព៝​អៃ ជេស​ឆាយ​អៃ​ខឹត​នើស អៃ​ទើយ​នត្លើយ​មេៈ​ឞឹ នទ្រែល​មា​ឞ្រី​ប៝ន​អៃ​នើម ទូ​គុ​នទ្រែល​មពោល​អី​អៃ​មោ​វៃ​នាល់​ឞើស​នតើម​នើស។ ");
INSERT INTO cmok_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","អ៝ន់​ឞ្រាស​យេហោវា​ព្លើង​ជាន​អ្វែស​មា​អៃ យ៝រ​មា​នទើ​អ្វែស​អី​អៃ​លែៈ​ជាន​នើស។ អ៝ន់​ឞ្រាស​យេហោវា​អី​ឞ្រាស​ផូង​អីឆ្រាអែល ​យើក​មឞាស​ងខោម​នទើ​អ៝ក់​មា​អៃ យ៝រ​លាស​អៃ​រាន​គុ​នទែ​តា​ពាង់​តឹម​ឞាន​មា​ក៝ន​អ្យារ់​រាន​គុ​តា​ន៝ម់​នារ​មែ​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","រូត ​លាស៖ “អើ​កោរាញ មៃ​គែស​នូយ្ស​នហ៝ម់​អ្វែស​មា​គ៝ប់​ហោ​ងាន់ មៃ​លែៈ​រាថី​គ៝ប់ ឞ៝ល​លាស​គ៝ប់​ឞូនុយ្ស​គុ​តា​ន៝ម់​អ៝ស​ម៝ន​ឞូ​អូរ​មៃ​កាដោយ មៃ​ហោម​ងើយ​អ្វែស​មា​គ៝ប់​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","នោក​ឆោង​ឆា ឞោអាស ​លាស​មា​រូត ៖ “ហោៈ​ឆា​នុមពាង់​លុប​ដាស​ទាក​លុប​អ្យា!” ជេសរី​រូត ​គុ​នទ្រែល​មពោល​អ៝ស​ម៝ន​នៃ ឞោអាស ​នទឹ​មឞ៝​គែ​លែៈ​ជេស​វ៝រ់​អ៝ន់​ពាង់ ពាង់​ឆា​ត៝ត់​ហើម ហោម​រាមែស​ដ៝ង់ ជេសរី​ពាង់​ព្រាប់។ ");
INSERT INTO cmok_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","ជេស​ឆោង​ឆា​រី​ពាង់​ទ៝ក់​ឞ្រោៈ​ទោញ​តៃ​ឞា ឞោអាស ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “អ៝ន់​ពាង់​ទោញ​ឞា​តា​នតុក​អី​ឞូន​នៃ​ដ៝ង់ លើយ​អោស​ឞ្វៃ​ពាង់! ");
INSERT INTO cmok_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","នតុប​ឞា​ឞើស​ញចាប់​បាៈ អ៝ន់​ពាង់​ទោញ លើយ​អោស​លាស​ពាង់!” ");
INSERT INTO cmok_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","ជេសរី​ពាង់​ទោញ​ឞា​នហ៝​មា​ត៝ត់​កេង​មាង់ ព្លេន​ឞា​អី​នៃ​ឞើយ​មា​ឞេង​ឆាស។ ");
INSERT INTO cmok_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","ពាង់​អាញ​ឞា​អី​នៃ​ឆឹត​អា​ប៝ន​ញហើ​អ៝ន់​អី​ព៝​ពាង់​ឆៃ នហ៝​មា​ញអោត​នទើ​ឆោង​ឆា​អី​រាមែស​នើស​នទឹ​អ៝ន់​មា​អី​ព៝​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","ព៝​ពាង់​អោប៖ “នារ​អ្យា​ឞូ​ម៝ស​មីរ​បែ​ទោញ​ហាៈ? អ៝ន់​ឞ្រាស​យេហោវា​អ៝ន់​នាវ​គែស​ជេង​មា​ពាង់​អី​គែស​នូយ្ស​នហ៝ម់​ល៝ង់​មា​បែ!” ជេសរី​រូត ​ងក៝ច​មា​ព៝​ពាង់៖ “នារ​អ្យា​គ៝ប់​ទោញ​ឞា​តា​មីរ​ឞូ​ក្លោ​រាញា​ឞោអាស  អូ​អេៈ”។ ");
INSERT INTO cmok_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","នាអោមី ​អើស​មា​អី​មាន់​ពាង់៖ “គ៝ប់​ទាន់​ឞ្រាស​យេហោវា​អ៝ន់​នាវ​គែស​ជេង​មា​ពាង់! ឞ្រាស​យេហោវា​គែស​នូយ្ស​នហ៝ម់​អ្វែស​រាប់​ជាប់ ហោម​កាស​គឹត​នាវ​ពាង់​រ៝ង់​ន៝ប់​មា​ឞូនុយ្ស​ហោម​រេស ឞ៝ល​លាស​ឞូនុយ្ស​លែៈ​ខឹត​ដ៝ង់!” នាអោមី ​ងើយ​តៃ៖ “ឞូ​ក្លោ​អី​នៃ​ជេង​ឞាល់​មពោល​ឞ៝ន់ ជេង​ទូ​ហ្វេ​ឞូនុយ្ស​នទើន​ម៝ត់​អ្វាញ់​ឞ៝ន់”។ ");
INSERT INTO cmok_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","រូត ​អី​ផូង​មោអាប់ ​នៃ​អើស៖ “នហ៝​ពាង់​ដាៈ​គ៝ប់​គុ​ទោញ​ឞា​នទ្រែល​អ៝ស​ម៝ន​ពាង់​ត៝ត់​ជេស​រែក​ឞា​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","ជេសរី​នាអោមី ​ងើយ​តៃ​មា​អី​មាន់​ពាង់៖ “បែ​គុ​ទោញ​ឞា​នទ្រែល​អ៝ស​ម៝ន​ឞូ​អូរ​ឞោអាស ​នៃ​អ្វែស​ងាន់! លាស​បែ​ឞ្រោៈ​មីរ​ឞូ​អេង​ក្លាច​លាស​ឞូ​ជាន​អ្យើស​មា​បែ”។ ");
INSERT INTO cmok_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","អាប់​នារ​អាប់​នារ​រូត ​គុ​ទោញ​ឞា​នទ្រែល​អ៝ស​ម៝ន​ឞោអាស ​នៃ អា​មាង់ៗ​ពាង់​ឆឹត​គុ​ច្វាញ​អី​ព៝​ពាង់​ដ៝ង់ នហ៝​មា​ត៝ត់​លែៈ​រែក​ឞា​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","ត៝ត់​ទូ​នារ​រី នាអោមី ​ងើយ​មា​រូត ៖ “គ៝ប់​ឆើម​នអាប់​ឆាយ​អ៝ន់​បែ​គែស​នាវ​រេស​អ្វែស​ដាប់​មពាន់​លែត​ជឹត​នាប់។ ");
INSERT INTO cmok_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","ឞោអាស ​អី​បែ​វៃ​ជាន​ការ​នទ្រែល​មពោល​អ៝ស​ម៝ន​ពាង់​នើស មពោល​ឞាល់​ឞ៝ន់​ដ៝ង់។ កេង​មាង់​អ្យា​ពាង់​ហាន់​រាពាត់​ឞា​តា​នតុក​រាពាត់​ឞា​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","បែ​អុម​បែ​ងក្រឹ​ឆាក់​អ៝ន់​អ្វែស​ព៝ត​ទាក​ឆី​បោ​កាស​ញឆ៝ស​ឞ៝ក​អាវ​អី​អ្វែសៗ ជេសរី​ហាន់​នតុក​រាពាត់​ឞា​រី លើយ​អោស​ញហើ​ឆាក់​អ៝ន់​ពាង់​នាល់ នហ៝​មា​ត៝ត់​ជេស​ពាង់​ញេត​ឆោង។ ");
INSERT INTO cmok_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","បែ​អ្វាញ់​នហេល​នានេៈ​នតុក​ពាង់​ឞិច ជេសរី​បែ​ហាន់​ពើក​ផោយ​មពែស​ឞើស​ជ៝ង់​ពាង់​នៃ បែ​ឞិច​តា​រី​យឹ គៃ​មា​ទាន់​ពាង់​កើល​បែ ជេសរី​បែ​ជាន​លែៈ​នតីល​នាវ​ពាង់​មឞើស​ដាៈ​បែ”។ ");
INSERT INTO cmok_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","រូត ​អើស៖ “អើ គ៝ប់​ជាន​តឹង​ទឹង​លែៈ​នាវ​បែ​ដាៈ”។ ");
INSERT INTO cmok_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","ជេសរី​រូត ​ហាន់​នតុក​រាពាត់​ឞា​ជាន​តឹង​នាវ​អី​ព៝​ពាង់​ដាៈ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","ជេស​ឞោអាស ​ញេត​ឆោង​ផ្យៅ ពាង់​មអាក​រាម់​នហ៝​មា​ឞិច​នតុក​ឞូន​ឞា​នៃ ជេសរី​រូត ​ហាន់​រាម្យាត់​ពើក​ផោយ​នហ៝​មា​ឞិច​ឞើស​ទ៝ង់​ជ៝ង់​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","ត៝ត់​ងគូល​មាង់​នៃ ឞោអាស ​កាស​រាងាល់​ឞិច​ប្លី ពាង់​រាព្លាច់​ឆាក់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ឆៃ​ទូ​ហ្វេ​ឞូ​អូរ​ឞិច​ឞើស​ទ៝ង់​ជ៝ង់​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","ជេសរី​ឞោអាស ​អោប៖ “ឞូ​ម៝ស​អ្យា?” រូត ​អើស៖ “គ៝ប់​រូត ​ជេង​ឞូនុយ្ស​ជាន​ការ​មា​មៃ កោរាញ​មេ ទាន់​កោរាញ​យោៈ​នអាច​មា​គ៝ប់ អ៝ន់​គ៝ប់​ជេង​អូរ​មៃ យ៝រ​លាស​មៃ​ជេង​មពោល​ឞាល់​គ៝ប់ ទើន​ម៝ត់​អ្វាញ់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","ឞោអាស ​លាស៖ “អ៝ន់​ឞ្រាស​យេហោវា អ៝ន់​នាវ​គែស​ជេង​មា​អ៝ស! អា​ល៝រ​នើស​អៃ​លែៈ​ញហើ​នាវ​រ៝ង់​រាប់​ជាប់​អៃ​គុ​នទ្រែល​ព៝​អៃ យើន​មា​អាបៃ​រី​អៃ​ញហើ​នូយ្ស​នហ៝ម់​ឆ៝ង់​រាលាវ​អី​នៃ​ជឹត អៃ​មោ​អោស​ឆ៝ៈ​ឆាយ​នទាម់​អ៝​អាច មោ​លាស​ឆាយ​នទាម់​អី​នទ្រ៝ង់ តីស​មា​ឆ៝ៈ​គ៝ប់​ច្រាវ។ ");
INSERT INTO cmok_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","លើយ​តា​រាវៃ​អោស ម៝ស​នទើ​អៃ​ទាន់ គ៝ប់​ទើយ​ជាន​ទឹង​លែៈ យ៝រ​លាស​ប៝ន​លាន​ទឹង​លែៈ​គឹត​នហេល​អៃ​ជេង​ឞូនុយ្ស​ឆ៝ង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","ទី​ងាន់​គ៝ប់​ឞាល់​មពោល​នទើន​ម៝ត់​អ្វាញ់​អៃ យើន​មា​ហោម​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ជឹត ឞាល់​មពោល​ទាច់​រាលាវ​មា​គ៝ប់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","មាង់​អ្យា​អៃ​ឞិច​តា​អ្យា​ហ៝ៈ! អោយ​តៃ​គ៝ប់​ហាន់​ម៝ប់​ពាង់ លាស​ពាង់​អុច​នទើន​ម៝ត់​អ្វាញ់​អៃ​អ៝ន់​ពាង់​ម៝ត់ លាស​ពាង់​មោ​អុច​អោស គ៝ប់​ត៝ន​មា​អៃ ជាៈ​ឞ្រាស​យេហោវា​អី​រេស​មោ​ឞ្លាវ​ខឹត​កើល​អ្វាញ់​ឆៃ​លែៈ​នាវ​គ៝ប់​ត៝ន គ៝ប់​នទើន​ម៝ត់​អ្វាញ់​អៃ​ងាន់! លាស​នទ្រី​អៃ​ឞិច​តា​អ្យា​ប៝ត់ នហ៝​មា​ត៝ត់​អាង​អោយ”។ ");
INSERT INTO cmok_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","ជេសរី​រូត ​ឞិច​ឞើស​ទ៝ង់​ជ៝ង់​ឞោអាស ​នៃ នហ៝​មា​ត៝ត់​កេង​អាង ពាង់​ទ៝ក់​អើម​អោយ​ឞ្រី​ហោម​ង៝​គៃ​មា​លើយ​អ៝ន់​ឞូ​គឹត​នាល់ យ៝រ​មា​ឞោអាស ​លាស៖ “មោ​អុច​អោស​អ៝ន់​ឞូ​គឹត​លាស​គែស​ឞូ​អូរ​លាប់​ឞិច​នតុក​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","ជេស​រី​ឞោអាស ​លាស៖ “ហើយ​អ៝ស ទ្រ៝ស​ឞ៝ក​អៃ​អី​ក្វ៝ង់​នៃ ក្វាន់​អ៝ន់​ន៝ប់”។ ជេសរី​ឞោអាស ​ត្រ៝ច​ឞា​ឞេង​ឞ៝ក​អី​នៃ​អ៝ន់​មា​ពាង់​នហ៝​កើល​ពឺ​អ៝ន់​ពាង់​មឞាក់ ជេសរី​ពាង់​មឞាក់​ឞា​អី​នៃ​ឆឹត​អា​ប៝ន។ ");
INSERT INTO cmok_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","ត៝ត់​អា​ច្វាញ​រី​ព៝​ពាង់​អោប៖ “អា​មើម​ពាង់​ជាន​មា​បែ​ហាៈ?” ជេសរី​រូត ​ងក៝ច​មា​អី​ព៝​ពាង់​នើម​ទឹង​លែៈ​នាវ​ឞោអាស ​ជាន​នើស។ ");
INSERT INTO cmok_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","រូត ​លាស៖ “លែៈ​ឞា​អ្យា​ពាង់​អ៝ន់​មា​គ៝ប់​នហ៝​មា​លាស៖ «អៃ​មោ​អោស​ទី​ឆឹត​ទើម​អា​ព៝​អៃ!»” ");
INSERT INTO cmok_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","ជេសរី​នាអោមី ​លាស៖ “ហើយ​មាន់ គុ​ក៝ប់​អ្វាញ់​ប៝ត់ នហ៝​មា​ត៝ត់​គឹត​លាស​នាវ​អ្យា​អា​មើម​ពាង់ យ៝រ​លាស​ឞោអាស ​មោ​អោស​នអ៝ម​ជ៝ៈ​ជ៝ង ពាង់​ជាន​ជេស​តា​នារ​អ្យា​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","ជេសរី​ឞោអាស ​ឞ្រោៈ​នតុក​មពោង​មពេរ​ប៝ន​នៃ ជេង​នតុក​ឞូ​វៃ​តឹម​រាគូម​ឞាល់ ត៝ត់​តា​នៃ​ពាង់​គុ​ក៝ប់ ជេសរី​ពាង់​ឆៃ​អី​ឞូ​ក្លោ​ឞាល់​មពោល​ទាច់​រាលាវ​អី​ពាង់​មឞើស​មា​រូត ​នើស​ឞ្រោៈ​រ៝ៈ​នៃ ឞោអាស ​ក៝ន់​ឞូ​ក្លោ​អី​នៃ​លាស៖ “ហើយ​នោ ទាន់​មៃ​គុ​តា​អ្យា​ប៝ត់”។ ឞូ​ក្លោ​អី​នៃ​គុ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","ជេសរី​ឞោអាស ​ជាៈ​ជឹត​នុយ្ស​កោរាញ​ប៝ន​គុ​នទ្រែល​តា​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","ឞោអាស ​លាស​មា​ឞូ​ក្លោ​អី​នៃ៖ “ហើយ​នោ មៃ​គឹត​ហើយ្ស​យោស​នាអោមី ​ព្លឹ​ឆឹត​តាៈ​ឞើស​ឞ្រី​មោអាប់  ពាង់​អុច​តាច់​នែស​មីរ​នោ​អេលីមាលេក ​នើម​នើស។ ");
INSERT INTO cmok_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","គ៝ប់​អុច​អោប​នហេល​មៃ លាស​មៃ​អុច​រាវាត់​នែស​មីរ​ពាង់​នៃ យ៝រ​មា​មៃ​អី​ឞាល់​មពោល​នទើន​ម៝ត់​អ្វាញ់​នទើន​រាវាត់​ច្វាយ​ល៝រ​ឞូ អុច​អ៝ន់​កោរាញ​អី​គុ​តា​អ្យា​នទ្រែល​ឞូនុយ្ស​អេង​ជឹត​អី​គុ​តា​អ្យា​កើល​ឆៃ​កើល​តាង់​ម៝ស​នាវ​មៃ​ងើយ។ លាស​មៃ​អុច​រាវាត់ រាវាត់​ទោស! លាស​មោ​អុច​រាវាត់ មឞើស​មា​គ៝ប់​ដ៝ង់ យ៝រ​លាស​គ៝ប់​នទើន​ម៝ត់​អ្វាញ់​នទើន​រាវាត់​ច្វាយ​ឞើស​កើយ​មៃ”។ ឞូ​ក្លោ​អី​នៃ​អើស៖ “អើ​គ៝ប់​អុច!” ");
INSERT INTO cmok_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","ឞោអាស ​លាស​តៃ៖ “រូត ​អី​ឞូ​អូរ​ផូង​មោអាប់ ​រី​ពាង់​នទ្រោ​ខឹត​ឆាយ​ឆ៝ៈ​ក៝ន​អេលីមាលេក ។ លាស​មៃ​រាវាត់​នែស​មីរ​យោស​នាអោមី ​អី​នៃ​ងក្រែ​មៃ​ឆ៝ៈ​រូត ​ជាន​អូរ​ឆាយ​ដាស​មៃ​ដ៝ង់ គៃ​មា​គែស​ក៝ន​នទើន​តៃ​នែស​មីរ​អី​នៃ លាស​នទ្រី​ហោម​គែស​តៃ​រាន៝យ​ទែស​មា​នែស​មីរ​នោ​ឞ៝ន់​អី​លែៈ​ខឹត​នៃ​នើស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","ឞូ​ក្លោ​អី​នៃ​អើស​មា​ពាង់៖ “លាស​នទ្រី​គ៝ប់​មោ​អោស​ទើយ​រាវាត់ យ៝រ​លាស​គ៝ប់​ក្លាច​រ៝ស​នែស​គ៝ប់​នើម។ អ៝ន់​មៃ​រាវាត់​ទោស គ៝ប់​មោ​អោស​ទើយ​រាវាត់!” ");
INSERT INTO cmok_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","រានោក​នៃ​នើស​តា​ឞ្រី​អីឆ្រាអែល  នោក​ឞូ​តាច់​រាគ៝ល់​ទ្រាប់​នទើ ទូ​ហ្វេ​ឞូនុយ្ស​ទ្រ៝ស​នតោ​ជ៝ត​នទឹ​អ៝ន់​មា​ទូ​ហ្វេ​ជឹត គៃ​មា​ញហើ​ខាន់​ពាង់​លែៈ​តឹម​ទី​នាវ។ ");
INSERT INTO cmok_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","ជេសរី​ឞូ​ក្លោ​នៃ​លាស៖ “អ៝ន់​មៃ​រាវាត់​ទោស!” ជេសរី​ពាង់​ទ្រ៝ស​នតោ​ជ៝ត​នទឹ​អ៝ន់​មា​ឞោអាស ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","ជេសរី​ឞោអាស ​លាស​មា​កោរាញ​ប៝ន នទ្រែល​មា​ផូង​ប៝ន​លាន​ទឹង​លែៈ​តា​នៃ៖ “នារ​អ្យា​ទាន់​ទឹង​លែៈ​អ៝ស​នោ​កោញ​វា​ជេង​នើម​លែៈ​ឆៃ​លែៈ​តាង់​នាវ​អី​អ្យា គ៝ប់​រាវាត់​ឞើស​យោស​នាអោមី ​ទឹង​លែៈ​ទ្រាប់​នទើ​នោ​អេលីមាលេក  ទ្រាប់​នទើ​អី​ក៝ន​ពាង់​ឞារ​ហៃ​កីលីយោន ​នទ្រែល​មា​មាលោន ។ ");
INSERT INTO cmok_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","គ៝ប់​ងក្រែ​ឆ៝ៈ​រូត ​អី​ឞូ​អូរ​ផូង​មោអាប់ ​អី​អូរ​មាលោន ​នើស នអាប់​អូរ​ឆាយ​ដាស​គ៝ប់​ដ៝ង់ គៃ​មា​គែស​ក៝ន​នទើន​តៃ​នែស​មីរ​អី​នៃ លាស​នទ្រី​ហោម​គែស​តៃ​រាន៝យ​ទែស​មា​នែស​មីរ​នោ​ឞ៝ន់​អី​លែៈ​ខឹត​នៃ​នើស គៃ​មា​លើយ​រ៝ស​រាញា​ពាង់​តា​នទុល​មពោល​ពាង់ លើយ​រ៝ស​រាញា​ពាង់​តា​ឞ្រី​ប៝ន​អ្យា។ នារ​អ្យា​ទឹង​លែៈ​អ៝ស​នោ​កោញ​វា​លែៈ​ឆៃ​លែៈ​តាង់​ជេស​នាវ​អី​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","លែៈ​រាងោច​ផូង​កោរាញ នទ្រែល​មា​ទឹង​លែៈ​ប៝ន​លាន​អី​គុ​តា​នៃ​អើស៖ “លែៈ​រាងោច​ផូង​ហេន​លែៈ​ឆៃ​លែៈ​តាង់​ទាទេ​ជេស! អ៝ន់​ឞ្រាស​យេហោវា​កើល​រូត ​គែស​ក៝ន​អ៝ក់​តឹម​ឞាន​មា​ឞូ​អូរ​រាចែល  នទ្រែល​មា​ឞូ​អូរ​លេអា ​កាល់​អែ​នើស​អី​មែ​ឞាៈ​ប៝ន​លាន​ផូង​អីឆ្រាអែល ​ដ៝ង់! អ៝ន់​មៃ​ជេង​ឞូនុយ្ស​តេស​ឞូនុយ្ស​នទ្រ៝ង់​គុ​តា​ឞាល់​មពោល​អេព្រាតា  នទ្រែល​មា​លឺ​ឆាក់​មៃ​តា​ប៝ន​បេតលេហឹម ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","អ៝ន់​ឞ្រាស​យេហោវា​កើល​មៃ នទ្រែល​មា​អូរ​មៃ​ឞាៈ​ក៝ន​ឞាៈ​ឆៅ​អ៝ន់​អ៝ក់ គៃ​មា​អ៝ន់​រានាក់​វ៝ល់​មៃ​តឹម​ឞាន​មា​រានាក់​វ៝ល់​ពេរេស ​អី​ក៝ន​ឞូ​ក្លោ​យូដា  ឞើស​ឞូ​អូរ​ថាមារ ​នើស​ដ៝ង់!” ");
INSERT INTO cmok_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","ជេស​ឞោអាស ​ឆ៝ៈ​រូត ​ជេង​អូរ​ពាង់ ឞ្រាស​យេហោវា​អ៝ន់​នាវ​គែស​ជេង​មា​រូត ។ ត៝ត់​នារ​ឞើស​កើយ​នៃ​ពាង់​នត្រែវ​ឞាៈ​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ។ ");
INSERT INTO cmok_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","ផូង​ឞូ​អូរ​គុ​តា​ប៝ន​បេតលេហឹម ​នៃ​លាស​មា​នាអោមី ៖ “រានេ​មា​ឞ្រាស​យេហោវា​យ៝រ​នារ​អ្យា​ពាង់​អ៝ន់​អៃ​គែស​ទូ​ហ្វេ​ឆៅ​ឞូ​ក្លោ​មា​ម៝ត់​អ្វាញ់​អៃ អ៝ន់​ពាង់​លឺ​លាម​ឞ្រី​អីឆ្រាអែល ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","មាន់​អៃ​រ៝ង់​មា​អៃ​ហោ​ងាន់ ពាង់​លែៈ​ជាន​អ៝ក់​នទើ​អ្វែស​មា​អៃ អ៝ក់​រាលាវ​មា​ពើស​នុយ្ស​ក៝ន​ឞូ​ក្លោ ជេសរី​អាបៃ​អ្យា​ពាង់​ឞាៈ​ទូ​ហ្វេ​ឆៅ​ឞូ​ក្លោ​មា​អៃ ឆៅ​អី​នៃ​ទើយ​ម៝ត់​អ្វាញ់​អៃ​គែស​នាវ​រេស​ជេង​ដាប់​មពាន់​តៃ នហ៝​មា​ត៝ត់​ខឹត”។ ");
INSERT INTO cmok_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","ជេសរី​នាអោមី ​ពឺ​អី​ឆៅ​នៃ​តុ នហ៝​មា​ម៝ត់​ឆ្យាម់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","ផូង​ឞូ​អូរ​អី​គុ​ច្យៅ​មែង​នៃ​លែវ​ឞាល់​លាស៖ “ក៝ន​ឞូ​ក្លោ​អ្យា​អាបៃ​រី​កើប​ក៝ន​នាអោមី !” ជេសរី​ខាន់​ពាង់​រាញា​អ៝ស​ឞេ​អី​នៃ៖ «អោបេត » អោបេត ​អ្យា​អី​ឞឹ​យេឆេ យេឆេ ​អី​ឞឹ​កាដាច់​ដាវីត ។ ");
INSERT INTO cmok_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","អ្យា​ជេង​រាន៝យ​មពោល​ពេរេស ​ត៝ត់​មា​កាដាច់​ដាវីត ពេរេស ​អី​ឞឹ​ហេឆ្រុន  ");
INSERT INTO cmok_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","ហេឆ្រុន ​អី​ឞឹ​រាម រាម ​អី​ឞឹ​អាមីនាដាប់  ");
INSERT INTO cmok_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","អាមីនាដាប់ ​អី​ឞឹ​នាសឆោន នាសឆោន ​អី​ឞឹ​ឆាល់មោន  ");
INSERT INTO cmok_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","ឆាល់មោន ​អី​ឞឹ​ឞោអាស ឞោអាស ​អី​ឞឹ​អោបេត  ");
INSERT INTO cmok_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","អោបេត ​អី​ឞឹ​យេឆេ យេឆេ ​អី​ឞឹ​កាដាច់​ដាវីត ៕៚");
INSERT INTO cmok_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","ឞើស​កាល់​អែ​នើស​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​រាញា​យោនាយ្ស ​អី​ក៝ន​អាមីថាយ ។ ត៝ត់​ទូ​នារ​រី​ឞ្រាស​យេហោវា ​ដាៈ​មា​យោនាយ្ស ​៖ ");
INSERT INTO cmok_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“ហើយ​យោនាយ្ស  មៃ​ទ៝ក់​ហាន់​ហ៝ម់​តា​ប៝ន​នីនីវេ ​អី​ប៝ន​ទុត​ក្វ៝ង់​មពែស​មា​លោស​នារ​នៃ មឞើស​មា​នាវ​តេៈ​ទោយ្ស​ឞូនុយ្ស​តា​ប៝ន​អី​នៃ យ៝រ​លាស​នាវ​តីស​អ្យើស​ខាន់​ពាង់​ជាន​នៃ លឺ​ងគារ់​តាង់​ត៝ត់​អា​គ៝ប់​អ្យា​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","យោនាយ្ស ​មោ​អ្យាត់​អោស​នាវ​ឞ្រាស​យេហោវា ​ពាង់​ទូ​ញច្វាត់​ឞើស​មាត់​ឞ្រាស​យេហោវា  ពាង់​ទ៝ក់​ឞើស​នៃ​រ៝ ហាន់​ជឹត​ប៝ន​យោបពេ ​រី នតុក​ប៝ន​គែស​ទូក​ក្វ៝ង់ៗ គៃ​មា​ហាន់​ជឹត​ប៝ន​តាឆើស ​អី​ប៝ន​មពែស​មា​ញ៝ប់​នារ​កាល់​តី​ទាក​វាច់​ទាក​វារ់​ច្រាវ។ ពាង់​ឆៃ​គែស​ទូ​មល៝ម់​ទូក​ក្វ៝ង់ អុច​នទ្រាប់​ហាន់​ជឹត​ប៝ន​តាឆើស  ពាង់​អ៝ន់​ព្រាក់​មា​ញច៝​ទូក ជេសរី​ពាង់​ជុរ​ញច៝​ទូក​អី​នៃ​រ៝ ហាន់​ជឹត​ប៝ន​តាឆើស ​នទ្រែល​ឞូ​អាបាៈ​អេង ពាង់​អុច​ទូ​ក្រាប​ងាយ​ឞើស​មាត់​ឞ្រាស​យេហោវា ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","ទូក​អី​នៃ​លោស​ឞើស​យោបពេ  ត៝ត់​តា​ងក្លាង​ទាក​នៃ ជេសរី​ឞ្រាស​យេហោវា ​អ៝ន់​គែស​ឆ្យាល​ផុត​ទុត​ហោ​រ៝ គៃ​មា​ខោម​មព្រាត​រ៝ៈ​ទាក​វាច់​ទាក​វារ់។ កើត​នទ្រី​រ៝ៈ​ទាក​អី​នៃ​គែស​ឆ្យាល​ទុត​ហោ​ងាន់ អ៝ន់​ខាន់​ពាង់​ក្លាច​លាស​ទូក​ខាន់​ពាង់​នើស​អ្យើស​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","មពោល​ជាន​ការ​តា​កាលើ​ទូក​នៃ​ខាន់​ពាង់​ក្លាច​នតែរ​ទាទេ ខាន់​ពាង់​នតែរ​ក្វាល់​ទូ​ហ្វេ​ទូ​ហ្វេ​ដាៈ​ឞ្រាស​ខាន់​ពាង់​នើម​កើល។ ជេសរី​ខាន់​ពាង់​ពឺ​លែៈ​ទ្រាប់​នទើ​តា​កាលើ​ទូក​អី​នៃ មអារ់​លើយ​តា​ទាក​វាច់​ទាក​វារ់​រី​គៃ​មា​អ៝ន់​ទូក​អី​នៃ​ងគើច។ អី​យោនាយ្ស ​នើម​រី​លែៈ​អើម​ជុរ​គុ​ឞិច​ហាក់​ខុរ​ឞើស​ទ៝ង់​ឆូ​តា​ឞ្លាត​ទូក​រី​ពាង់​ហែស។ ");
INSERT INTO cmok_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","ជេសរី​ពាង់​អី​តើម​ទូក​រី​ហាន់​ជ៝យ​យោនាយ្ស ​គៃ​មា​លាស ពាង់​លាស៖ “មើម​គុ​ឞិច​មៃ​អ្យា​ហ្យាស? ទ៝ក់​ហ៝ម់​ហែស! ក្វាល់​ហ៝ម់​ឞ្រាស​មៃ​នើម! ងខេប​លាស​ឞ្រាស​អី​នៃ​កាស​គឹត​មា​ឞ៝ន់ លើយ​អ៝ន់​ឞ៝ន់​ខឹត”។ ");
INSERT INTO cmok_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","មពោល​ឞូនុយ្ស​អី​គុ​ញច៝​តា​កាលើ​ទូក​នៃ​តឹម​ញច្រាៈ​ឞាល់​លាស៖ “ល៝ង់​ឞ៝ន់​ញុប​នទើ​ញច្រ៝ស គៃ​មា​គឹត​ឞូ​ម៝ស​ឞូនុយ្ស​អី​ជាន​នាវ​អ្យើស ទឹង​ឞ៝ន់​គែស​នាវ​ជេរ​កើត​អ្យា”។ ជេសរី​ញច្រ៝ស​នាវ​អី​នៃ​ទី​តា​ព្លាង់​យោនាយ្ស ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","ជេសរី​ខាន់​ពាង់​អោប​យោនាយ្ស ៖ “ឞូ​ម៝ស​ជាន ទឹង​គែស​នាវ​ជេរ​កើត​អ្យា? មឞើស​មា​ហេន​ហ៝ម់ មៃ​ម៝ស​ជាន? ឞើស​តាៈ​មៃ? ម៝ស​ប៝ន? មៃ​ឞូ​ម៝ស​មពោល?” ");
INSERT INTO cmok_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","យោនាយ្ស ​មឞើស​មា​ខាន់​ពាង់៖ “គ៝ប់​មពោល​ហេឞ្រើ  គ៝ប់​ក្លាច​មា​ឞ្រាស​យេហោវា ​ឞ្រាស​អី​គុ​តា​កាលើ​ត្រោក ពាង់​អី​ញជេង​ទាក​វាច់​ទាក​វារ់ នទ្រែល​មា​នែស​នតូ​អ្យា​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","យោនាយ្ស ​ងក៝ច​លែៈ​នាវ​ពាង់​អី​នៃ​នើស​អ៝ន់​ឞូ​គឹត ត៝ត់​មា​គឹត​នាវ​យោនាយ្ស ​ពាង់​ញច្វាត់​ទូ​ឞើស​ឞ្រាស​យេហោវា  កើត​នៃ ខាន់​ពាង់​ក្លាច​ទាទេ​លើ​ហោ​ងាន់ លែៈ​ឞូនុយ្ស​អី​គុ​ញច៝​តា​ទូក​អី​នៃ ខាន់​ពាង់​លាស​មា​យោនាយ្ស ៖ “ម៝ស​ជាន​មៃ​កើត​នទ្រី​រី?” ");
INSERT INTO cmok_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","ទាក​រាឞុស​លើ​មា​ហោ​លើ​មា​ហោ​ងាន់ ជេសរី​ខាន់​ពាង់​អោប​មា​យោនាយ្ស ៖ “លាស​នទ្រី មើម​ហេន​ជាន​មា​មៃ គៃ​មា​ទាក​អ្យា​រាង៝ន់​មេស?” ");
INSERT INTO cmok_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","យោនាយ្ស ​អើស៖ “ខាន់​មៃ​ងក្លាច់​លើយ​គ៝ប់​តា​ទាក​រី​មើ​ឞាស យ៝រ​លាស​គ៝ប់​គឹត​ឆ្យាល​ផុត​ទុត​ហោ​អ្យា តាៈ​ឞើស​នាវ​តីស​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","ខាន់​ពាង់​មោ​អ្យាត់​អោស ខាន់​ពាង់​ញឆ្រោយ្ស​វាស​ទូក​អី​នៃ​អ៝ន់​ហាន់​ជឹត​មែង មោ​ទើយ​រ៝ យ៝រ​មា​ទាក​រាឞុស​លើ​មា​ហោ​ទាង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","ជេសរី​ខាន់​ពាង់​នតែរ​ក្វាល់​ឞ្រាស​យេហោវា  ៖ “អើយ​ឞ្រាស​យេហោវា ​ទាន់​មៃ​យោៈ​នអាច​អ៝ន់​មា​ហេន លើយ​អ៝ន់​ហេន​ខឹត​យ៝រ​មា​ហេន​ងខឹត​ងក្លាច់​លើយ​ឞូនុយ្ស​អ្យា​តា​ទាក។ អើយ​ឞ្រាស​យេហោវា ​លើយ​តេៈ​ទោយ្ស​មា​ហេន​លាស​ឞូនុយ្ស​អ្យា​មោ​គែស​នាវ​តីស​អោស លែៈ​នាវ​អ្យា​នើស​តាៈ​ឞើសមៃ​នើម​អុច”។ ");
INSERT INTO cmok_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","ជេសរី​ខាន់​ពាង់​ពឺ​យោនាយ្ស ​ងក្លាច់​លើយ​តា​ទាក​វាច់​ទាក​វារ់​អី​នៃ ជេសរី​ទាក​រាង៝ន់​នទាល​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","លែៈ​រាងោច​មពោល​អី​នៃ​ក្លាច​ឞ្រាស​យេហោវា ​ហោ​ងាន់ ខាន់​ពាង់​លែវ​ឞាល់​ឆ៝ៈ​នទើ​ជាន​មា​ឞ្រាស​យេហោវា ​នទ្រែល​មា​ម៝ត់​ត៝ន​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","ជេសរី​ឞ្រាស​យេហោវា ​អ៝ន់​ទូ​មល៝ម់​កា​ក្វ៝ង់​រាង្វាន់​យោនាយ្ស  ជេសរី​កា​ក្វ៝ង់​អី​នៃ​រាង្វាន់​យោនាយ្ស ​រី ពាង់​គុ​តា​ត្រោម​នទុល​កា​ពែ​នាង់​ពែ​នារ ");
INSERT INTO cmok_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","ជេសរី​ពាង់​មឞើស​ឆើម​មា​ឞ្រាស​យេហោវា ​អី​ឞ្រាស​ពាង់​នើម​រី​ឞើស​ត្រោម​នទុល​កា​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","ពាង់​លាស៖ “ទោល​គ៝ប់​គែស​នាវ​ជេរ គ៝ប់​ជ៝យ​ក្វាល់​ឞ្រាស​យេហោវា  ពាង់​ព្លឹ​អើស​ងាន់​រ៝ ទោល​គ៝ប់​មឹន​គ៝ប់​មរា​ខឹត​ងាន់​រ៝​គ៝ប់​នតែរ​ទាន់​មៃ​កើល មៃ​កើល​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","មៃ​មអារ់​គ៝ប់​តា​នតុក​ទុត​ជ្រូ​ងាន់ តា​ន៝ម់​ឞ្លាត​ទាក​វាច់​ទាក​វារ់ ច្យៅ​មា​នាប់​កើយ​ទ៝ង់​លើ​គ៝ប់​នើស​គែស​ទាក​ទាទេ មៃ​ដាៈ​ដ៝ង់​ទាក​ញច៝ច់​រាឞុស ត្រុយ្ស​តា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","គ៝ប់​មឹន​លាស​មៃ​មអារ់​គ៝ប់​ងាយ ឞើស​មាត់​មៃ​ងាន់ គ៝ប់​មោ​មរា​អ្វាញ់ ញីស​ជាន​ឞ្រាស​ក្ល៝ស​អ្វែសមៃ​នើម​ជឹត​អោស។ ");
INSERT INTO cmok_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","គ៝ប់​ង៝ម់​តា​ន៝ម់​ទាក​ងាន់​ឞើយ​មា​ខឹត​រ៝ គ៝ប់​គុ​តា​ងក្លាង​ទាក​ទុត​ជ្រូ​ងាន់ មឞ្រឹង​ពូត​ជុម​ឞោក​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","ហើយ​ឞ្រាស​យេហោវា ​អី​ឞ្រាស​គ៝ប់​អើយ គ៝ប់​នើស​ង៝ម់​តា​ន៝ម់​ទាក​វាច់​ទាក​វារ់​ទុត​ជ្រូ​តា​ញជ៝ង់​យោក​រី ងក្រែ​មា​ខាន​តា​ឞ្រី​ផាន​នៃ យើន​មា​មៃ​លែៈ​ឆ៝ៈ​ជេស​ឞើស​នតុក​នៃ​អ៝ន់​គ៝ប់​រេស​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","ទោល​គ៝ប់​ឞើយ​អុច​តាច់​នហ៝ម់ គ៝ប់​កាស​គឹត​មឞើស​ឆើម​មា​មៃ ជេសរី​តាង់​ត៝ត់ តា​ញីស​ជាន​ឞ្រាស​មៃ​តា​ប៝ន​យេរូឆាលឹម ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","ឞូនុយ្ស​អី​តឹង​មឞាស​មា​ឞ្រាស​អេងៗ​អី​មោ​គែស​នាវ​ខ្លៃ ពាង់​មោ​អោស​ទើយ​គែស​ឆ៝ៈ​នាវ​រ៝ង់​រាប់​ជាប់​តាៈ​ឞើស​កោរាញ​ឞ្រាស​អី​អុច​អ៝ន់​អី​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","គ៝ប់​ឞែ​នើស​លាស​អ្វែស​មា​កោរាញ​ឞ្រាស នទ្រែល​មា​ឆ៝ៈ​នទើ​ជាន​ញហើរ​មា​ឞ្រាស​យេហោវា  តឹម​ទី​ដាស​នាវ​គ៝ប់​ម៝ត់​ត៝ន យ៝រ​លាស​ឞ្រាស​យេហោវា ​ទើម​ទើយ​រាក្លាយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","ជេសរី​ឞ្រាស​យេហោវា ​ដាៈ​កា​អី​នៃ​ហ៝ក​ងលោស​លើយ​យោនាយ្ស  ជេសរី​កា​អី​នៃ​ហ៝ក​ងលោស​ពាង់​អា​កើស​តី​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","ឞ្រាស​យេហោវា  ដាៈ​មា​យោនាយ្ស ​ទូ​តឹ​ជឹត៖ ");
INSERT INTO cmok_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“ទ៝ក់​ហ៝ម់ ហាន់​តា​ប៝ន​នីនីវេ ​អី​ប៝ន​ទុត​ក្វ៝ង់​រី ជេសរី​មឞើស​មា​ឞូនុយ្ស​គុ​តា​ប៝ន​រី​អ៝ន់​គឹត កើត​នាវ​គ៝ប់​នតិញ​ដាៈ​មា​មៃ​នើស!” ");
INSERT INTO cmok_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","យោនាយ្ស ​អ្យាត់​នាវ​ឞ្រាស​យេហោវា ​ដាៈ ជេសរី​ពាង់​ទ៝ក់​ដើប​ឞើស​នៃ ហាន់​តា​ប៝ន​នីនីវេ  ប៝ន​អី​នៃ​ទុត​ក្វ៝ង់​ងាន់ ឞ្រោៈ​ពែ​នារ​រី​មើ​លោច។ ");
INSERT INTO cmok_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","យោនាយ្ស ​ត៝ត់​តា​ប៝ន​អី​នៃ ពាង់​នតើម​ហាន់​លាប់​រ៝ៈ​ប៝ន​អី​នៃ​ទូ​នារ ពាង់​មឞើស​លាស៖ “ហោម​ព្វាន់​ជឹត​នារ​ជឹត​នាប់​កោរាញ​ឞ្រាស​មរា​លើស​អ៝ន់​ហេង​លើយ​ប៝ន​អ្យា!” ");
INSERT INTO cmok_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","ជេសរី​ឞូនុយ្ស​តា​ប៝ន​នីនីវេ ​នៃ​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​អី​មឞើស​នតិញ​តឹង​យោនាយ្ស ​អី​នៃ ខាន់​ពាង់​នទុយ្ស​តោរ​លែៈ​លាន់​នាវ​ខាន់​ពាង់​ជាន​តីស អុច​ញហើ​ខាន់​ពាង់​មអារ់​លើយ​លែៈ​នាវ​តីស​អា​ល៝រ​នើស កើត​នទ្រី​ខាន់​ពាង់​លែវ​ឞាល់​មឞើស​ងក៝ច​នាវ​អី​នៃ​អ៝ត់​ឆោង​ឆា ញឆ៝ស​ងគូត​ឞ៝ក​បៅ​ច្យាត់ នតើម​ឞើស​ឞូនុយ្ស​នទ្រ៝ង់​ត៝ត់​មា​ឞូនុយ្ស​អ៝​អាច​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","នាវ​អ្យា​លឺ​តាង់​ត៝ត់​អា​កាដាច់​នីនីវេ ​ងាន់ ពាង់​នទុយ្ស​តោរ​អុច​ញហើ​លែៈ​នាវ​ពាង់​ជាន​តីស​នើស នទ្រី​ទឹង​ពាង់​ជុរ​ឞើស​លើ​រានើល​កាដាច់​ពាង់​អី​នៃ ទ្រ៝ស​លើយ​អី​អាវ​កាដាច់​នៃ ញឆ៝ស​ងគូត​ឞ៝ក​បៅ​ច្យាត់ ជេសរី​គុ​តា​នតុក​អុញ​ឞុស​ឆី​ឆ៝។ ");
INSERT INTO cmok_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","ជេសរី​លោស​នាវ​តាៈ​ឞើស​កាដាច់​ដាៈ​ឞូ​មឞើស​លាម​តា​ប៝ន​នីនីវេ ​អី​នៃ​លាស៖ “អ្យា​នាវ​កាដាច់ នទ្រែល​មា​ផូង​កោរាញ​កើល​ជាន​ការ។ ទឹង​លែៈ​ឞូនុយ្ស​មោ​អោស​អ៝ន់​ឆោង​ឆា​ញេត​ទាក នទ្រែល​មា​មពោមពា​(ឆ្យុម)​នទ្រោក​ឞែ​មោ​អ៝ន់​ដ៝ង់​ឆា​មពា​ញេត​ទាក។ ");
INSERT INTO cmok_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","អ៝ន់​ទឹង​លែៈ​ឞូនុយ្ស នទ្រែល​មា​មពោមពា​(ឆ្យុម)​ញឆ៝ស​ងគូត​ឞ៝ក​បៅ​ច្យាត់​ទាទេ ជេសរី​ញុម​នតែរ អ៝ន់​ទឹង​លែៈ​ឞូនុយ្ស​មឞើស​ឆើម​ក្វាល់​កោរាញ​ឞ្រាស​អ៝ន់​ហោ​ងាន់ ងក្លើយ​លើយ​នូយ្ស​នហ៝ម់​អ្យើស នទ្រែល​មា​នាវ​ហាត់​ជាញ​តឹម​លើស​តឹម​ងខឹត​អី​ខាន់​អៃ​មៃ​វៃ​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","ងខេប​លាស​កោរាញ​ឞ្រាស​រាគ៝ល់​នូយ្ស​នហ៝ម់​ពាង់ មោ​ហោម​នូយ្ស​មា​ឞ៝ន់ លាស​នទ្រី​ឞ៝ន់​មោ​អោស​មរា​ខឹត​ហេង”។ ");
INSERT INTO cmok_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","កោរាញ​ឞ្រាស​ឆៃ​នូយ្ស​នហ៝ម់​រាគ៝ល់​លើយ​ទាទេ​លែៈ​នាវ​អ្យើស​ខាន់​ពាង់​ជាន​នើស ជេសរី​កោរាញ​ឞ្រាស​រាគ៝ល់​នូយ្ស​នហ៝ម់​ពាង់​នើម​អ៝ន់​មា​ផូង​អី​នៃ ឞាស​លើស​ហេង​មា​ខាន់​ពាង់ មោ​អោស​លើស​កើត​នាវ​ពាង់​ថាម់​ឞើស​នតើម​នើស។ ");
INSERT INTO cmok_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","ត៝ត់​មា​យោនាយ្ស ​ឆៃ​កើត​នៃ​នើស​ពាង់​មោ​អ្យាង់​អោស ពាង់​ជី​នូយ្ស​ទុត​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","ពាង់​មឞើស​ឆើម​មា​ឞ្រាស​យេហោវា  ៖ “អើយ​ឞ្រាស​យេហោវា  ឞើស​អា​ល៝រ​នើស​ងាន់​គ៝ប់​គឹត​មៃ​មោ​តេៈ​ទោយ្ស​ឞូនុយ្ស​តា​ប៝ន​នីនីវេ ​អ្យា ឞើស​នោក​ហោម​គុ​តា​ប៝ន​គ៝ប់​នើម​នើស​ងាន់ កើត​នទ្រី​ទឹង​គ៝ប់​គើញ​ញច្វាត់​ទូ​តា​ប៝ន​តាឆើស  យ៝រ​លាស​មៃ​ឞ្រាស​អី​គែស​នាវ​យោៈ​នអាច គែស​នូយ្ស​នហ៝ម់​ល៝ង់ គែស​នូយ្ស​នហ៝ម់​រ៝ង់​រាប់​ជាប់ មោ​អោស​គើញ​នូយ្ស។ ជេសរី​លាស​ឞូនុយ្ស​នទុយ្ស​តោរ​មា​នាវ​តីស​អី​ពាង់​លាន់​ជាន​រាគ៝ល់​ឞាស​ជាន​មហឹក មៃ​រាគ៝ល់​លើយ​ឞើស​នាវ​អុច​លើស​ហេង ជេសរី​ឞាស​តេៈ​ទោយ្ស​ឞូនុយ្ស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","អើយ​ឞ្រាស​យេហោវា ​ទាន់​មៃ​ឆើម​រាហ្វាត់​លើយ​នហ៝ម់​គ៝ប់ អ្វែស​អ៝ន់​គ៝ប់​មា​ខឹត​លើយ ដាស​មា​ហោម​រេស​ជឹត​នាប់​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","ឞ្រាស​យេហោវា ​ព្លឹ​លាស​មា​យោនាយ្ស ៖ “ទី​លែៈ​លាស​មោ មៃ​នូយ្ស​កើត​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","ជេសរី​យោនាយ្ស ​ទ៝ក់​ដឺប​ឞើស​នៃ​ហាន់​មពែស​ឞើស​លោស​នារ​មា​ប៝ន​នីនីវេ ។ ត៝ត់​តា​នតុក​នៃ​ពាង់​ជាន​ទូ​មល៝ម់​ងកឺប​គុ​តា​ន៝ម់​នហ៝ម់ គៃ​មា​ក៝ប់​អ្វាញ់​ម៝ស​នតីល​នាវ​ត៝ត់​មា​ប៝ន​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","ឞ្រាស​យេហោវា  អ៝ន់​តើម​ឆី​ទូ​តើម​ហ៝ន​ឞើស​លើ​ឞោក​យោនាយ្ស ​រី គៃ​អ៝ន់​នហ៝ម់​មា​ពាង់​ជឹត លើយ​អីរ​អ៝ន់​ពាង់​រាញាល់។ ជេសរី​យោនាយ្ស ​ពាង់​មអាក​ងាន់​គែស​នហ៝ម់​តើម​ឆី​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","កាស​អើម​អោយ​អោយ​តៃ​ឞ្រី​ហោម​ង៝ កោរាញ​ឞ្រាស​ដាៈ​ទូ​មល៝ម់​នទ្រុង​ហាន់​ចោស​ឆា​តើម​ឆី​អី​នៃ ជេសរី​នទ្រ៝​ប្រុង។ ");
INSERT INTO cmok_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","ត៝ត់​លោស​នារ កោរាញ​ឞ្រាស​ដាៈ​ឆ្យាល​ទោស​ខោម​តាៈ​ឞើស​លោស​នារ ជេសរី​នារ​ទោស​អ្យ្រែង​កាលើ​ឞោក​កាលើ​ឆាក់​យោនាយ្ស ​ដ៝ង់ ពាង់​លេត​រាគាញ់​ហោ​ងាន់ ទាន់​មា​កោរាញ​ឞ្រាស​ដាៈ​ងខឹត​ពាង់៖ “អ្វែស​គ៝ប់​មា​ខឹត​លើយ ដាស​មា​ហោម​រេស​ជឹត​នាប់​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","កោរាញ​ឞ្រាស​លាស​មា​ពាង់៖ “មៃ​ទី​លែៈ​នូយ្ស​យ៝រ​មា​តើម​ឆី​អី​នៃ?” យោនាយ្ស ​អើស​មា​កោរាញ​ឞ្រាស៖ “អើ ទុត​ហោ​ងាន់” ");
INSERT INTO cmok_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","ឞ្រាស​យេហោវា ​លាស​មា​យោនាយ្ស ​ជឹត៖ “ល៝ង់​មៃ​មឹន! មៃ​យោៈ​មា​តើម​ឆី​អី​មៃ​មោ​គែស​តាម់​មោ​គែស​រាអាស​ម៝ត់​អី​នៃ ហ៝ន​តា​ទូ​មាង់​ទើម ជេសរី​ខឹត​នទ្រ៝​តា​ទូ​មាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","គ៝ប់​ឞែ​យោៈ​ហោ​ងាន់​មា​ប៝ន​នីនីវេ ​ប៝ន​ទុត​ក្វ៝ង់​អ្យា យ៝រ​លាស​ប៝ន​អី​នៃ​គែស​អ៝ក់​ឞូនុយ្ស ១២០០០០ នុយ្ស​រាលាវ ខាន់​ពាង់​មោ​ហ៝ៈ​គឹត​នាល់​តីស​ទី​អោស ជេសរី​នទ្រែល​មា​គែស​ទុត​អ៝ក់​ដ៝ង់​មពោមពា​(ឆ្យុម)​ខាន់​ពាង់​ម៝ត់​តា​ប៝ន​អី​នៃ”។៚");
INSERT INTO cmok_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","អ្យា​នាវ​ងក៝ច​យៅ​អូ​ចែ​ឞ្រាស​យេឆូ​ក្រីស  អី​ក៝ន​ឆៅ​កាដាច់​ដាវីត ​កាល់​អែ​នើស នទ្រែល​មា​អី​ក៝ន​ឆៅ​អាឞ្រាហាម់ ​ដ៝ង់។ លែៈ​រាងោច​ផូង​អីឆ្រាអែល ​ជេង​រាន៝យ​ទែស​អាឞ្រាហាម់ ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","អាឞ្រាហាម់ ​អី​ឞឹ​អីឆាក់ អីឆាក់ ​អី​ឞឹ​យាកោប យាកោប ​អី​ឞឹ​យូដា  នទ្រែល​មា​អ៝ស​នោ​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","យូដា ​ឆ៝ៈ​អូរ​រាញា​ពាង់​ថាមារ ​ឞាៈ​ក៝ន​ឞូ​ក្លោ​រាញា​ពេរេស  នទ្រែល​មា​អ៝ស​ពាង់​រាញា​ឆេរាស ពេរេស ​អី​ឞឹ​ហេឆ្រុន ហេឆ្រុន ​អី​ឞឹ​អារាម ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","អារាម ​អី​ឞឹ​អាមីនាដាប់ អាមីនាដាប់ ​អី​ឞឹ​នាសឆោន នាសឆោន ​អី​ឞឹ​ឆាល់មោន ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ឆាល់មោន ​ឆ៝ៈ​អូរ​រាញា​ពាង់​រាហាប់ ​ឞាៈ​ក៝ន​ឞូ​ក្លោ​រាញា​ពាង់​ឞោអាស ឞោអាស ​ឆ៝ៈ​អូរ​រាញា​ពាង់​រូត ​ឞាៈ​ក៝ន​ឞូ​ក្លោ​រាញា​ពាង់​អោបេត អោបេត ​អី​ឞឹ​យេឆេ ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","យេឆេ ​អី​ឞឹ​កាដាច់​ដាវីត ។ កាដាច់​ដាវីត ​ឆ៝ៈ​ពីត​អូរ​ឞូ ឞាៈ​កាដាច់​ឆាលោមោន  រាញា​ឆាយ​អី​អូរ​កាដាច់​ដាវីត ​ពីត​នៃ​អូរី ។ ");
INSERT INTO cmok_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","កាដាច់​ឆាលោមោន ​អី​ឞឹ​កាដាច់​រេហូបាម់  កាដាច់​រេហូបាម់ ​អី​ឞឹ​កាដាច់​អាបីយា  កាដាច់​អាបីយា ​អី​ឞឹ​កាដាច់​អាឆា ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","កាដាច់​អាឆា ​អី​ឞឹ​កាដាច់​យោឆាផាត  កាដាច់​យោឆាផាត ​អី​ឞឹ​កាដាច់​យោរាម  កាដាច់​យោរាម ​អី​ឞឹ​កាដាច់​អោឆីស ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","កាដាច់​អោឆីស ​អី​ឞឹ​កាដាច់​យោថាម  កាដាច់​យោថាម ​អី​ឞឹ​កាដាច់​អេហាស  កាដាច់​អេហាស ​អី​ឞឹ​កាដាច់​ហេឆេកៀ ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","កាដាច់​ហេឆេកៀ ​អី​ឞឹ​កាដាច់​មានាឆេ  កាដាច់​មានាឆេ ​អី​ឞឹ​កាដាច់​អាមោន  កាដាច់​អាមោន ​អី​ឞឹ​កាដាច់​យោឆីស ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","កាដាច់​យោឆីស ​អី​ឞឹ​កាដាច់​យេកោនីស  នទ្រែល​មា​អ៝សៗ​ពាង់​ដ៝ង់។ ទោល​នៃ​ឞូ​វែង​គ្រ៝​ប៝ន​លាន​អីឆ្រាអែល ​គុ​ជឹត​ឞ្រី​បាបីលោន ។ ");
INSERT INTO cmok_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ជេស​ឞូ​វែង​គ្រ៝​ប៝ន​លាន​អីឆ្រាអែល ​គុ​តា​ឞ្រី​បាបីលោន ​កាដាច់​យេកោនីស ​ឞាៈ​ឆាលាថីល ឆាលាថីល ​អី​ឞឹ​ឆោរោបាបែល ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ឆោរោបាបែល ​អី​ឞឹ​អាបីយូត អាបីយូត ​អី​ឞឹ​អេលេកីម អេលេកីម ​អី​ឞឹ​អាឆោរ ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","អាឆោរ ​អី​ឞឹ​ឆាដុក ឆាដុក ​អី​ឞឹ​អាកីម អាកីម ​អី​ឞឹ​អេលីយូត ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","អេលីយូត ​អី​ឞឹ​អេលាឆារ អេលាឆារ ​អី​ឞឹ​មាថាន មាថាន ​អី​ឞឹ​យាកោប ‌ ");
INSERT INTO cmok_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","យាកោប ​អី​ឞឹ​យោឆែប ​អី​ឆាយ​មារី ។ មារី ​អី​នៃ​ឞាៈ​ឞ្រាស​យេឆូ ​ឞូ​ក្វាល់​លាស​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់។ ");
INSERT INTO cmok_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","កើត​នទ្រី នតើម​ឞើស​អាឞ្រាហាម់ ​ត៝ត់​មា​កាដាច់​ដាវីត ​ពាង់​គែស ១៤ ឞោង​ឞូនុយ្ស។ នតើម​ឞើស​កាដាច់​ដាវីត ​ត៝ត់​មា​រានោក​ឞូ​វែង​គ្រ៝​ប៝ន​លាន​អីឆ្រាអែល ​គុ​តា​ឞ្រី​បាបីលោន  គែស ១៤ ឞោង​ឞូនុយ្ស។ នតើម​ឞើស​រានោក​ឞូ​វែង​គ្រ៝​ប៝ន​លាន​អីឆ្រាអែល ​គុ​តា​ឞ្រី​បាបីលោន ​ត៝ត់​មា​ឞ្រាស​យេឆូ ​អី​ឞ្រាស​ក្រីស ​គែស ១៤ ឞោង​ឞូនុយ្ស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ឞើស​ទ៝ង់​អ្យា​ងក៝ច​ឞ្រី​នាវ​ទែស​ឞ្រាស​យេឆូ​ក្រីស ។ គែស​ទូ​ហ្វេ​ឞូ​អូរ​រាញា​ពាង់​មារី  ពាង់​អី​នទ្រោយ​យោឆែប ។ អេ​ល៝រ​ខាន់​ពាង់​តឹម​គុ​នទ្រែល មារី ​លែៈ​អើម​នត្រែវ​ឞ្រាស​យេឆូ ​យ៝រ​មា​នាវ​ទើយ​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​អ៝ន់​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","យោឆែប ​អី​នទ្រោយ​មារី ​នៃ យ៝រ​មា​ពាង់​ឞូនុយ្ស​ឆ៝ង់​ឞូនុយ្ស​អ្វែស ជេស​ឆៃ​នទ្រោយ​ពាង់​លែៈ​នត្រែវ ពាង់​អុច​នត្លើយ​នទ្រោយ​ពាង់​នើម​មោ​អោស​អ៝ន់​ឞូ​គឹត ពាង់​មោ​អុច​អ៝ន់​នទ្រោយ​ពាង់​ដីត​ព្រេង​ឞូ កើត​នទ្រី​ពាង់​អុច​នត្លើយ​អ៝ន់​នទ៝ប់ៗ។ ");
INSERT INTO cmok_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ញចោ​អែ​មា​ពាង់​ងក្ល៝ន់​កើត​នៃ គែស​តោង​ពារ់​តាៈ​ឞើស​កោរាញ​ឞ្រាស​មឞើស​អ៝ន់​ពាង់​មា​នាវ​មឞើយ៖ “ហើយ​យោឆែប ​ក៝ន​ឆៅ​កាដាច់​ដាវីត ! លើយ​ក្លាច​អោស​ឆ៝ៈ​មារី ​ជេង​អូរ​មៃ។ ក៝ន​អី​តា​ត្រោម​នទុល​ពាង់​នៃ​មោ​អោស​តាៈ​ឞើស​ឞូនុយ្ស តាៈ​ឞើស​នាវ​ទើយ​ឞ្រាស​ហ្វេង​អ្វែស​អ៝ន់។ ");
INSERT INTO cmok_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ពាង់​គុ​អ៝ស​ឞូ​ក្លោ ជេសរី​មៃ​តេៈ​រាញា​ក៝ន​អី​នៃ​ក្វាល់ «យេឆូ » - គែស​នាវ​ខ្លៃ​លាស​«កោរាញ​ឞ្រាស​រាក្លាយ្ស» - យ៝រ​លាស​ក៝ន​អី​នៃ​មរា​រាក្លាយ្ស​ផូង​ប៝ន​លាន​ពាង់​នើម​ឞើស​នាវ​តីស​ខាន់​ពាង់​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","លែៈ​នាវ​អ្យា​គែស​គៃ​មា​តឹម​ទី​ងាន់​ដាស​នាវ​កោរាញ​ឞ្រាស​នតិញ​តឹង​ទូ​ហ្វេ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស៖ ");
INSERT INTO cmok_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«អ្វាញ់​តៃ​យឹ! ទូ​ហ្វេ​ឞូ​អូរ​ទ្រោស​អេ​ហ៝ៈ​គែស​គុ​នទ្រែល​ឞូ​ក្លោ​មរា​នត្រែវ ពាង់​គុ​អ៝ស​ឞូ​ក្លោ‌ ជេសរី​ឞូ​ក្វាល់​ក៝ន​អី​នៃ «អេមានូអែល »»។ «អេមានូអែល »​នាវ​ងើយ​ហេឞ្រើ ​រាឞ្លាង​លាស «កោរាញ​ឞ្រាស​គុ​នទ្រែល​ឞ៝ន់»។ ");
INSERT INTO cmok_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ត៝ត់​យោឆែប ​កាស​ឞិច ពាង់​អ្យាត់​តឹង​នាវ​តោង​ពារ់​ដាៈ​មា​ពាង់ ឆ៝ៈ​មារី ​ជេង​អូរ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","តីស​មា​ពាង់​អេ​ហ៝ៈ​អោស​គែស​ឞិច​នទ្រែល​ឞូ​អូរ​ឞូ​ក្លោ​ដាស​អូរ​ពាង់​ត៝ត់​មា​អូរ​ពាង់​គុ​អ៝ស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ ជេសរី​ពាង់​តេៈ​រាញា​ក៝ន​អី​នៃ​ក្វាល់ «ឞ្រាស​យេឆូ »។ ");
INSERT INTO cmok_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ឞ្រាស​យេឆូ ​ទែស​តា​ប៝ន​បេតលេហឹម ​ឞ្រី​យូដា ​នោក​កាដាច់​ហេរោត ​ម៝ត់​អ្វាញ់​ឞ្រី​ទាក​អី​នៃ។ ជេស​ពាង់​ទែស​រី គែស​ឞូនុយ្ស​គឹត​ឞ្លាវ​គឹត​នាល់​អ្វាញ់​មាញ់​មឞីង​ហាន់​តាៈ​ឞើស​ឞ្រី​ងាយ​មពែស​មា​លោស​នារ​ត៝ត់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ខាន់​ពាង់​អោប​ឞូ​តា​រី៖ “អាស​នតុក​ទែស​កាដាច់​មហែ​ផូង​អីឆ្រាអែល ​ហ្យាស? ហេន​លែៈ​គឹត​ពាង់​ទែស យ៝រ​មា​ហេន​ឆៃ​ទូ​មល៝ម់​មាញ់​ច្រាត​ងាន់​លោស​មពែស​ឞើស​ឞ្រី​ហេន​ជេង​នទើ​មឞេន​មា​នាវ​អី​នៃ។ នទ្រី​ទឹង​ហេន​ហាន់​យើក​មឞាស​មា​ពាង់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ត៝ត់​កាដាច់​ហេរោត ​តាង់​លឺ​នាវ​អោប​អី​នៃ ពាង់​រាវៃ​ហោ​ងាន់​គុ​មោ​ដាប់​ចាប់​មោ​គ៝ន់​រ៝ ក្លាច​គែស​ឞូនុយ្ស​អេង​ជាន​កាដាច់។ លែៈ​ប៝ន​លាន​តា​យេរូឆាលឹម ​រី ខាន់​ពាង់​រាវៃ​ទាទេ​មើម​កាដាច់​ហេរោត ​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ជេសរី​ពាង់​រាគូម​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  គៃ​មា​អោប​នតុក​ប៝ន​ទែស​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់។ ");
INSERT INTO cmok_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ជេសរី​ផូង​អី​នៃ​មឞើស​មា​កាដាច់៖ “នតុក​ឞ្រាស​ក្រីស ​ទែស​តា​ប៝ន​បេតលេហឹម ​ឞ្រី​យូដា  យ៝រ​លាស​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​ញចីស៖ ");
INSERT INTO cmok_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","«កោរាញ​ឞ្រាស​លាស៖ «ហើយ​ប៝ន​លាន​ប៝ន​បេតលេហឹម ​តា​ឞ្រី​យូដា ​អើយ! ប៝ន​ខាន់​អៃ​មៃ​មោ​អោស​ទី​ជេៈ​តា​ន៝ម់​ឞូ​ដាស​ប៝ន​ឞ្រី​យូដា ​អ្យា​អី​គែស​នាវ​ខ្លៃ‌ យ៝រ​លាស​ជឹត​នាប់​តៃ​គែស​ទូ​ហ្វេ​កោរាញ​លោស​តាៈ​ឞើស​ប៝ន​ខាន់​អៃ​មៃ‌ ពាង់​អី​នៃ​ម៝ត់​អ្វាញ់​ប៝ន​លាន​អីឆ្រាអែល ​អី​ប៝ន​លាន​គ៝ប់​នើម តឹម​ឞាន​មា​ទូ​ហ្វេ​នើម​ច្យាប់​ឞែ​ឞ្យាប់»»”។ ");
INSERT INTO cmok_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ជេសរី​កាដាច់​ហេរោត ​ក្វាល់​នតុង​មពោល​គឹត​ឞ្លាវ​អី​នៃ អោប​ជែក​អេង​ខាន់​ពាង់​ទាស​ហ៝ៈ​ជ៝ៈ​ឆៃ​មាញ់​អី​រី គៃ​មា​គឹត​ក៝ន​ឞេ​អី​រី​ទាស​ហ៝ៈ​អ៝ក់​ខៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ជេសរី​ដាៈ​មពោល​អី​នៃ​ហាន់​ជឹត​ប៝ន​បេតលេហឹម ​រី ពាង់​លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ហាន់​ទោស អោប​នហេល​មា​ក៝ន​ឆែ​ជេៈ​អី​នៃ។ ជេស​ឆៃ​ពាង់​តៃ ព្លឹ​មឞើស​មា​គ៝ប់​យឹ។ គ៝ប់​អុច​ហាន់​យើក​មឞាស​មា​ក៝ន​ឆែ​ជេៈ​អី​នៃ​ដ៝ង់”។ តីស​មា​កាដាច់​ហេរោត ​មោ​អោស​ងើយ​ងាន់ ពាង់​គៃ​មា​អុច​ងខឹត​ក៝ន​ឆែ​អី​នៃ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ជេស​អ្យាត់​នាវ​កាដាច់​មឞើស​នៃ ខាន់​ពាង់​លោស​ឞើស​ប៝ន​យេរូឆាលឹម ​រី។ ល៝ង់​មាញ់​អី​ខាន់​ពាង់​ឆៃ​មពែស​ឞើស​លោស​នារ​រី​នើស​លែវ​ត្រ៝ង​មា​ខាន់​ពាង់​នហ៝​មា​ត៝ត់​តឹម​ឆ៝ង់​កាលើ​នតុក​អ៝ស​ឞេ​គុ​រី​មើ​ញឆ្រុង។ ");
INSERT INTO cmok_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ខាន់​ពាង់​រាម់​មអាក​លែៈ​ឞើស​នូយ្ស​ឞើស​នហ៝ម់​ងាន់​ឆៃ​មាញ់​លែៈ​គុ​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ជេសរី​ខាន់​ពាង់​លាប់​តា​ត្រោម​ជៃ​នតុក​អ៝ស​ឞេ​គុ​រី ឆៃ​អ៝ស​ឞេ​នទ្រែល​មេៈ​ពាង់។ ខាន់​ពាង់​ពាន់​មឞាស​មា​អ៝ស​ឞេ​អី​នៃ ជេសរី​ឆ៝ៈ​នទើ​ខ្លៃ​ឞើស​ត្រោម​ហុប​ខាន់​ពាង់​នើម​រី៖ មាយ្ស នតាក់​ឆី​បោ​កាស​មា​ឆូ នទ្រែល​មា​នតាក់​ឆី​បោ​កាស​មឹរ ​ញហើរ​អ៝ន់​មា​អ៝ស​ឞេ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ជេសរី​ខាន់​ពាង់​ឆឹត​ជឹត​ឞ្រី​ទាក​ខាន់​ពាង់​នើម​រី ឆឹត​ជឹត​ត្រ៝ង​អេង យ៝រ​លាស​កោរាញ​ឞ្រាស​មឞើស​មា​ខាន់​ពាង់​តឹម​នាវ​មឞើយ មោ​អោស​អ៝ន់​ខាន់​ពាង់​ព្លឹ​មឞើស​មា​កាដាច់​ហេរោត ។ ");
INSERT INTO cmok_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","នទុត​ឆឹត​ខាន់​ពាង់​អា​រី គែស​តោង​ពារ់​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ញហើ​ឆាក់​មា​យោឆែប ​តា​នាវ​មឞើយ ពាង់​លាស៖ “ហើយ​យោឆែប  ទ៝ក់​ហ៝ម់​លែវ​ក៝ន​ឞេ​អី​នៃ នទ្រែល​មា​អី​មេៈ​ពាង់​ញច្វាត់​ទូ​គុ​តា​ឞ្រី​អេឆីប ​រី។ មៃ​គុ​តា​ឞ្រី​នៃ​ក៝ប់​ត៝ត់​គ៝ប់​ក្វាល់​ប៝ត់​ទឹង​មៃ​ព្លឹ​ឆឹត យ៝រ​លាស​កាដាច់​ហេរោត ​អុច​តឹង​ងខឹត​ក៝ន​ឞេ​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ជេសរី​យោឆែប ​កាស​រាងាល់​ឞិច លែវ​អូរ​លែវ​ក៝ន​ពាង់​ញច្វាត់​ទូ​ជឹត​ឞ្រី​អេឆីប ​ទឹង​មាង់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ខាន់​ពាង់​គុ​តា​ឞ្រី​អី​នៃ​ត៝ត់​ខឹត​កាដាច់​ហេរោត  នទ្រី​នាវ​អ្យា​ជេង​ទី​ដាស​នាវ​កោរាញ​ឞ្រាស​ដាៈ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​ពាង់​កាល់​អែ​នើស​ញចីស៖ «កោរាញ​ឞ្រាស​លាស៖ «គ៝ប់​ក្វាល់​ក៝ន​គ៝ប់​លោស​តាៈ​ឞើស​ឞ្រី​អេឆីប ​នៃ»»។ ");
INSERT INTO cmok_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ត៝ត់​មា​កាដាច់​ហេរោត ​លែៈ​គឹត​ជេស​មពោល​គឹត​ឞ្លាវ​គឹត​នាល់​អ្វាញ់​មាញ់​មឞីង​អី​នៃ​រាលាម់​ពាង់ មោ​អុច​ព្លឹ​មឞើស ពាង់​ជី​នូយ្ស​ហោ​ងាន់ មឹន​លាស​ក៝ន​ឞេ​ហោម​តា​ប៝ន​បេតលេហឹម  ជេសរី​ដាៈ​ឞូ​ហាន់​ងខឹត​លើយ​ក៝ន​ឞូ​ក្លោ​តា​ប៝ន​បេតលេហឹម  នទ្រែល​មា​ប៝ន​អី​តឹម​ទាច់​ដាស​ប៝ន​បេតលេហឹម ​រី​ដ៝ង់ ងខឹត​ក៝ន​ឆែ​អី​នតើម​ឞើស​ឞារ​នាម់​ជុរ​ជឹត​ទ៝ង់​អ៝ន់​លែៈ។ កាដាច់​ហេរោត ​កើប​នាម់​ក៝ន​ឆែ​ពាង់​ដាៈ​ងខឹត​អី​នៃ ពាង់​កើប​នតើម​ឞើស​មពោល​អី​គឹត​ឞ្លាវ​អី​នៃ​ឆៃ​មាញ់​នើស​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ប៝ន​បេតលេហឹម  នទ្រែល​មា​ប៝ន​រាមា  តា​នតុក​គែស​រាន៝យ​ទែស​រាចែល ​អី​អូរ​យាកោប ​គុ​កាល់​អែ​នើស។ នទ្រី​នាវ​អ្យា​ជេង​ទី​ងាន់​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស រាញា​ពាង់​យេរេមី ​ពាង់​ញចីស៖ ");
INSERT INTO cmok_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«គែស​នាវ​លឺ​ងគារ់​តា​ប៝ន​រាមា  នតុក​ឞូ​អូរ​មែ​អី​រាន៝យ​ទែស​រាចែល ​អី​នៃ។ ជេង​នាវ​ញហ្យាង់​ញុម​ក្រីត​រាង៝ត​ហោ​ងាន់‌ ញុម​វើល​យោៈ​នអាច​មា​ក៝ន​ពាង់។ ពាង់​មោ​អុច​អោស​ឞូ​ឞ៝ញ យ៝រ​លាស​ក៝ន​ពាង់​លែៈ​ខឹត​ជេស»។ ");
INSERT INTO cmok_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ត៝ត់​កាដាច់​ហេរោត ​លែៈ​ខឹត​ជេស តោង​ពារ់​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ញហើ​ឆាក់​មា​យោឆែប ​តា​ឞ្រី​អេឆីប ​រី តា​នាវ​មឞើយ ពាង់​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ហើយ​យោឆែប ! លែវ​ក៝ន​ឞេ​អី​នៃ នទ្រែល​មា​អី​មេៈ​ពាង់​ព្លឹ​ឆឹត​តា​ឞ្រី​អីឆ្រាអែល ​ហ៝ម់ យ៝រ​លាស​ឞូនុយ្ស​អី​អុច​ងខឹត​ក៝ន​ឞេ​អី​នៃ​នើស​លែៈ​ខឹត​លែៈ​ផ្យៅ​ជេស”។ ");
INSERT INTO cmok_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ជេសរី​យោឆែប ​លែវ​ក៝ន​ឞេ​អី​នៃ នទ្រែល​មា​អី​មេៈ​ពាង់​ព្លឹ​ឆឹត​តា​ឞ្រី​អីឆ្រាអែល ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","តីស​មា​យោឆែប ​មោ​អោស​ឞាញ់​គុ​តា​នតុក​ឞ្រី​យូដា  យ៝រ​មា​ពាង់​លឺ​កោរាញ​អារកេលោស ​អី​ក៝ន​កាដាច់​ហេរោត  ពាង់​នត្រ៝ៈ​អី​ឞឹ​ម៝ត់​អ្វាញ់​តា​ឞ្រី​យូដា ​រី នហ៝​មា​កោរាញ​ឞ្រាស​មឞើស​មា​ពាង់​តឹង​នាវ​មឞើយ​ជឹត មោ​អ្វែស​អោស​លាស​គុ​តា​ឞ្រី​យូដា ។ នទ្រី​ទឹង​ពាង់​ហាន់​ជឹត​ឞ្រី​កាលីលេ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ត៝ត់​តា​ឞ្រី​កាលីលេ ​រី​ពាង់​គុ​តា​ទូ​ប៝ន ប៝ន​អី​នៃ​រាញា​នាឆារែត ។ នទ្រី​តឹម​ទី​ដាស​នាវ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​ញចីស​មា​ឞ្រាស​ក្រីស ៖ «ឞូ​មរា​ក្វាល់​ពាង់​ឞូនុយ្ស​ប៝ន​នាឆារែត »។ ");
INSERT INTO cmok_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ជេសរី​យោហាន-​បាប់តែម ​ត៝ត់​តា​ឞ្រី​រាទាស​តា​ឞ្រី​យូដា  ពាង់​នតើម​នតី​ផូង​ប៝ន​លាន​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“រាគ៝ល់​ហ៝ម់​នូយ្ស​នហ៝ម់​អ្យើស​ខាន់​អៃ​មៃ យ៝រ​លាស​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​លែៈ​ឞើយ​ត៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ពាង់​អី​នៃ​ឞូនុយ្ស​អី​គែស​ញចីស​តា​ឆ៝ម់បុត​អេឆាយ ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​ញចីស​កើត​នអា៖ «គែស​ទូ​ហ្វេ​ឞូនុយ្ស​នតែរ​តា​ឞ្រី​រាទាស​លាស៖ «នទ្រាប់​ហ៝ម់​នូយ្ស​នហ៝ម់​អ៝ន់​មា​កោរាញ​ឞ្រាស តឹម​ឞាន​មា​ឞូនុយ្ស​ក្វាយ្ស​ត្រ៝ង​ញឆ៝ង់​ត្រ៝ង​អ៝ន់​មា​កាដាច់​ហាន់»»។ ");
INSERT INTO cmok_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ល៝ង់​យោហាន-​បាប់តែម ​ពាង់​ញឆ៝ស​អាវ​ជ៝ង​តាញ​មា​រាឆៅ​ឆែស​ឆាមោ វាន់​រាឆែ​ឞុត​ជាន​មា​នតោ នទើ​ឆោង​ឆា​ពាង់​ក្រាស​នទ្រាច ដាស​ទាក​ឆុត។ ");
INSERT INTO cmok_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","នោក​នៃ​អ៝ក់​ឞូនុយ្ស​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  អ៝ក់​ឞូនុយ្ស​តា​ឞ្រី​យូដា  នទ្រែល​មា​អ៝ក់​ឞូនុយ្ស​គុ​រ៝ៈ​ទាក​រាលាយ​យោរដាន់  វាច់​រាន​តា​យោហាន-​បាប់តែម ​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ខាន់​ពាង់​គឹត​ឆាក់​ខាន់​ពាង់​នើម​តីស​មឞើស​រ៝ ជេសរី​យោហាន-​បាប់តែម ​ជាន​បាប់តែម​យុក​ខាន់​ពាង់​មា​ទាក​តា​ទាក​រាលាយ​យោរដាន់ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ត៝ត់​មា​ឆៃ​វាច់​ផូង​ផារីឆី  នទ្រែល​មា​ផូង​ឆាដោឆី ​អ៝ក់​ដ៝ង់ ហាន់​អុច​ជាន​បាប់តែម​យុក​មា​ទាក ពាង់​លាស​ខាន់​ពាង់​កើត​នអា៖ “យេ! មពោល​ឞូនុយ្ស​អ្យើស​ឞូនុយ្ស​ជាញ​តឹម​ឞាន​មា​ឞេស​កូ ឞូ​ម៝ស​មឞើស​មា​ខាន់​មៃ​ទឹង​គែស​មា​ញច្វាត់​ក្រាប​ឞើស​នាវ​តេៈ​ទោយ្ស​កោរាញ​ឞ្រាស​អី​ឞើយ​មា​ត៝ត់​អ្យា? ");
INSERT INTO cmok_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","លាស​ខាន់​មៃ​មោ​អុច​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស លាស​នទ្រី​គុ​ឆ៝ង់​ជាន​អ្វែស​ហ៝ម់ គៃ​មា​គឹត​ឆៃ​នូយ្ស​នហ៝ម់​ខាន់​មៃ​លែៈ​រាគ៝ល់​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","លើយ​ហោម​លាស​អេង​តា​ឆាក់​ខាន់​មៃ​នើម៖ «គ៝ប់​លែៈ​ឆៅ​អាឞ្រាហាម់ ​ងាន់ នទ្រី​កោរាញ​ឞ្រាស​មោ​ហោម​អោស​តេៈ​ទោយ្ស»។ គ៝ប់​លាស​មា​ខាន់​មៃ៖ ជេង​ឆៅ​អាឞ្រាហាម់ ​ទើម​មោ​អោស​គែស​នាវ​ខ្លៃ។ លុ​អ្យា​កោរាញ​ឞ្រាស​ឆ៝ៈ​ញជេង​ឆៅ​អាឞ្រាហាម់ ​ជេង​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","អាបៃ​អ្យា​កោរាញ​ឞ្រាស​អុច​តេៈ​ទោយ្ស​មា​លែៈ​ឞូនុយ្ស​អី​មោ​ជាន​អ្វែស។ ពាង់​តឹម​ឞាន​មា​ឞូនុយ្ស​នទ្រាប់​លើយ​ពេស​ថាវ​តេៈ​តា​រែស​តើម​ឆី ពាង់​មរា​កាល់​លើយ​តើម​ឆី​មោ​គែស​ព្លៃ​អ្វែស ជេសរី​ឆូ​លើយ​មា​អុញ។ ");
INSERT INTO cmok_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","គ៝ប់​ជាន​បាប់តែម​អ៝ន់​ខាន់​មៃ​យុក​មា​ទាក​ទើម គៃ​មា​ញហើ​ខាន់​មៃ​លែៈ​រាគ៝ល់​នូយ្ស​នហ៝ម់​អ្យើស​ជេស។ យើន​មា​គែស​ទូ​ហ្វេ​កោរាញ​ឞើយ​ត៝ត់​ជេស ពាង់​គែស​នាវ​ទើយ​រាលាវ​គ៝ប់​ងាន់។ តា​នាប់​ពាង់​គ៝ប់​ជេង​ឞូនុយ្ស​ជេៈ​លេៈ​ទើម ឞ៝ល​លាស​គ៝ប់​ឆើម​ទ្រ៝ស​នតោ​ជ៝ត​ពាង់ ហោម​អែ​មោ​ហ៝ៈ​ទី​ដ៝ង់​ដាស​នាវ​ជាន​ការ​អ៝ន់​មា​ពាង់។ ពាង់​បាប់តែម​អ៝ន់​ខាន់​មៃ​មា​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស នទ្រែល​មា​អុញ។ ");
INSERT INTO cmok_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ពាង់​តឹម​ឞាន​មា​ឞូនុយ្ស​ញអោត​ទោង គៃ​មា​រាឆែង​គុម​មព្រោស​លែៈ​ឞា​អី​គែស​តា​នតុក​ពាង់​ព្លេន​នៃ។ ឞា​រាង្លៃ​ពាង់​ឆ៝ៈ​តោស​ព្រាប់​តា​ជៃ​ឞា​ពាង់​នើម អី​ញឆ្យាប់​ពាង់​ឆូ​លើយ​មា​អុញ​មោ​អោស​ឞ្លាវ​ញហ៝ត់។ កើត​នទ្រី​ពាង់​តឹម​ងខាស​លើយ​ឞូនុយ្ស​ឆ៝ង់​ដាស​ឞូនុយ្ស​តីស ជេសរី​តេៈ​ទោយ្ស​មា​ឞូនុយ្ស​តីស”។ ");
INSERT INTO cmok_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","នោក​នៃ​ឞ្រាស​យេឆូ ​ហាន់​តាៈ​ឞើស​ឞ្រី​កាលីលេ  ហាន់​ម៝ប់​យោហាន-​បាប់តែម ​តា​ទាក​រាលាយ​យោរដាន់  គៃ​មា​អ៝ន់​យោហាន-​បាប់តែម ​ជាន​បាប់តែម​យុក​ពាង់​មា​ទាក។ ");
INSERT INTO cmok_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","យើន​មា​ត៝ត់​តា​នៃ​យោហាន ​រាលាច់​លាស​មា​ពាង់៖ “មើម​ហាន់​តា​គ៝ប់ ដាៈ​គ៝ប់​ច្រាវ​ជាន​បាប់តែម​យុក​មៃ​មា​ទាក? ទី​លាស​មៃ​ឆើម​ជាន​អ៝ន់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ឞ្រាស​យេឆូ ​លាស៖ “អាបៃ​អ្យា​អ៝ន់​មៃ​ជាន​ប៝ត់​ទោ គៃ​មា​ជាន​តឹម​ទី​ទាទេ​ដាស​នាវ​កោរាញ​ឞ្រាស​លែៈ​ដាៈ”។ ជេសរី​យោហាន-​បាប់តែម ​អុច​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ជេស​ឞ្រាស​យេឆូ ​ទើន​បាប់តែម​យុក​មា​ទាក នោក​ពាង់​លោស​ឞើស​ទាក​នៃ ទោ​មា​ឆៃ​ត្រោក​ពើក​ឞ៝ង់​លាហឺរ​មា​ពាង់ ជេសរី​ពាង់​ឆៃ​ឞ្រាស​ហ្វេង​អ្វែស​កោរាញ​ឞ្រាស​តឹម​ឞាន​មា​ព្លុក​ជុរ​ទ្រ៝ម់​តា​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ទោល​នៃ​គែស​តាង់​នតែស​ឞ៝រ់​តាៈ​ឞើស​កាលើ​ត្រោក​លាស៖ “អ្យា​ក៝ន​គ៝ប់​រ៝ង់ គ៝ប់​រាម់​រាហើន​មា​ពាង់​ហោ​ងាន់​ងេន”។ ");
INSERT INTO cmok_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ជេសរី​ឞ្រាស​ហ្វេង​អ្វែស​លែវ​ឞ្រាស​យេឆូ ​ហាន់​តា​ឞ្រី​រាទាស គៃ​មា​អ៝ន់​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​នទើម​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ឞ្រាស​យេឆូ ​អ៝ត់​ឆោង​ឆា ៤០ នាង់ ៤០ នារ ឞើស​កើយ​នៃ​ពាង់​ជី​ង៝ត​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ជេសរី​ឆាតាង់ ​អី​ឞូ​ក្វាល់​លាស​«កោរាញ​នទើម»​ដ៝ង់ ហាន់​ទាច់​អា​ពាង់ លាស​មា​ពាង់៖ “លាស​មៃ​ក៝ន​កោរាញ​ឞ្រាស​ងាន់​ងេន ល៝ង់​មៃ​ដាៈ​លុ​អាបាៈ​អ្យា​អ៝ន់​ជេង​នទើ​ឆោង​ឆា!” ");
INSERT INTO cmok_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","យើន​មា​ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “មោ​អោស។ លែៈ​ឞូ​ញចីស​ជេស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ៖ «ឞូនុយ្ស​មោ​អោស​រេស​តាៈ​ឞើស​នទើ​ឆោង​ឆា​ទើម‌ រេស​តាៈ​ឞើស​ទឹង​លែៈ​នាវ​ងើយ​លោស​តាៈ​ឞើស​មឞូង​កោរាញ​ឞ្រាស»”។ ");
INSERT INTO cmok_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ជេស​ឞើស​នៃ​កោរាញ​មពោល​ឞ្រាស​អ្យើស​អី​នៃ​លែវ​ឞ្រាស​យេឆូ ​លាប់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​អី​ប៝ន​ក្ល៝ស​អ្វែស ជេសរី​អ៝ន់​ពាង់​តា​កាលើ​ច៝រ​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស តា​នតុក​អី​ទុត​ព្រេស​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ពាង់​លាស​មា​ឞ្រាស​យេឆូ ៖ “លាស​មៃ​ក៝ន​កោរាញ​ឞ្រាស​ងាន់​ងេន ល៝ង់​មៃ​ញឆាត់​ជឹត​ទ៝ង់​ឆូ យ៝រ​លាស​លែៈ​ឞូ​ញចីស​ជេស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ៖ «កោរាញ​ឞ្រាស​ដាៈ​មពោល​តោង​ពារ់​ពាង់​នើម​អ៝ន់​កើល​មៃ» គែស​ញចីស​ដ៝ង់៖ «តី​តោង​ពារ់​ទ្រើ​មៃ‌ មោ​អោស​អ៝ន់​ជ៝ង់​មៃ​គែស​ញចិញ​មា​លុ»”។ ");
INSERT INTO cmok_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​ញចីស​កើត​នអា៖ «លើយ​អោស​រាល៝ង​នាវ​ទើយ​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ខាន់​អៃ​មៃ​យើក​មឞាស»”។ ");
INSERT INTO cmok_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ជេសរី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​អី​នៃ​លែវ​ឞ្រាស​យេឆូ ​ហាវ​តា​កាលើ​យោក​ទុត​ព្រេស ញហើ​អ៝ន់​ពាង់​ឆៃ​ទឹង​លែៈ​ឞ្រី​ទាក​តា​នែស​នតូ​អ្យា នទ្រែល​មា​ទឹង​លែៈ​នទើ​ខ្លៃ​តា​ឞ្រី​ទាក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ពាង់​លាស​មា​ឞ្រាស​យេឆូ ៖ “លាស​មៃ​ពាន់​យើក​មឞាស​មា​គ៝ប់ ទឹង​លែៈ​នទើ​អី​នៃ​គ៝ប់​អ៝ន់​មា​មៃ​ម៝ត់​អ្វាញ់​ទាទេ!” ");
INSERT INTO cmok_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ឞ្រាស​យេឆូ ​លាស៖ “ហើយ​ឆាតាង់  អ៝ន់​មៃ​ទូ​ហ៝ម់! យ៝រ​លាស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​ញចីស​ជេស៖ «ដាៈ​ខាន់​អៃ​មៃ​យើក​មឞាស​មា​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ខាន់​អៃ​មៃ​នើម‌ ជាន​ការ​អ្យាត់​នាវ​ទូ​ហ្វេ​ពាង់​អី​នៃ​ទើម»”។ ");
INSERT INTO cmok_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ជេសរី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​អី​នៃ​ទូ​ឞើស​ឞ្រាស​យេឆូ ​នៃ ទោ​មា​គែស​ផូង​តោង​ពារ់​កោរាញ​ឞ្រាស​វាច់​តា​ឞ្រាស​យេឆូ  ឆើម​កើល​ជាន​ការ​អ៝ន់​នទើ​ឆោង​ឆា​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ត៝ត់​ឞ្រាស​យេឆូ ​គឹត​យោហាន-​បាប់តែម ​លែៈ​ឞូ​ក្រុង​តា​នទ្រូង ជេសរី​ពាង់​លោស​ឞើស​ឞ្រី​យូដា ​ព្លឹ​គុ​តៃ​តា​ឞ្រី​កាលីលេ ។ ");
INSERT INTO cmok_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ពាង់​ហាន់​តា​ប៝ន​នាឆារែត  ជេសរី​ហាន់​គុ​តា​ប៝ន​កាពើនិម ​អី​ទាច់​កេង​ងលៅ​ក្វ៝ង់​កាលីលេ  តា​នហារ់​ឞ្រី​មពោល​ឆាបូលោន  ដាស​មា​ឞ្រី​មពោល​នាប់តាលី ។ ឞារ​មពោល​អី​នៃ​ជេង​មពោល​អីឆ្រាអែល ​តា ១២ មពោល​ខាន់​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ពាង់​គុ​តា​នៃ​គៃ​មា​តឹម​ទី​ដាស​នាវ​ងើយ​អេឆាយ ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ញចីស​ជេស៖ ");
INSERT INTO cmok_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«អើ​ឞ្រី​មពោល​ឆាបូលោន  នទ្រែល​មា​ឞ្រី​មពោល​នាប់តាលី  អី​រ៝ៈ​ត្រ៝ង​រ៝ៈ​មែង​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ  អើ​ឞ្រី​មពែស​កាល់​តី​ទាក​រាលាយ​យោរដាន់  ឞ្រី​កាលីលេ ​នតុក​អ៝ក់​ផូង​អី​មោ​ទី​ផូង​អីឆ្រាអែល ​គុ! ");
INSERT INTO cmok_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ផូង​ប៝ន​លាន​តា​នៃ​ខាន់​ពាង់​តឹម​ឞាន​មា​គុ​តា​នាវ​ង៝ ក្លាច​មា​នាវ​ខឹត មោ​គែស​នាវ​រានើម‌ ខាន់​ពាង់​តឹម​ឞាន​មា​ឆៃ​នាវ​អាង​ទុត​ក្វ៝ង់ អាង​ងាន់ អ៝ន់​ខាន់​ពាង់​គែស​នាវ​រានើម​យ៝រ​មា​នទើ​អី​គែស​តា​ឞ្រី​ខាន់​ពាង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","នតើម​ឞើស​នោក​នៃ​ឞ្រាស​យេឆូ ​មឞើស​ងក៝ច៖ “រាគ៝ល់​ហ៝ម់​នូយ្ស​នហ៝ម់​អ្យើស​ខាន់​អៃ​មៃ យ៝រ​លាស​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞើយ​មា​ត៝ត់​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","គែស​ទូ​នារ​រី​ឞ្រាស​យេឆូ ​ហាន់​ឞ្រោៈ​រ៝ៈ​មែង​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ ពាង់​ឆៃ​ឞារ​ហៃ​អ៝ស​នោ​គុ​ឆែង​ជាល​តា​ទាក​នៃ ឆីមោន ​អី​ឞូ​ក្វាល់​ពេត្រោស ​ដ៝ង់ នទ្រែល​មា​អ៝ន់ទ្រេ ។ ឞារ​ហៃ​ខាន់​ពាង់​អី​នៃ​ជេង​ឞូនុយ្ស​ជាន​ការ​វាង់​កា​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ហើយ​អ៝ស​នោ ហោៈ​តឹង​គ៝ប់គ៝ប់​អ៝ន់​ខាន់​មៃ​ហាន់​ជ៝យ​ឞូនុយ្ស​អ្យាត់​នាវ​គ៝ប់ តឹម​ឞាន​មា​ឆែង​កា”។ ");
INSERT INTO cmok_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ទោ​មា​ឞារ​ហៃ​ខាន់​ពាង់​រី​នត្លើយ​ជាល​ព្រុង​តា​នៃ ជេសរី​តឹង​ឞ្រាស​យេឆូ ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ហាន់​ត៝ត់​អា​នាប់​ឞ្រាស​យេឆូ ​ឆៃ​ឞារ​ហៃ​អ៝ស​នោ​អា​អេង​ជឹត យាកើ  នទ្រែល​មា​យោហាន ​អី​ក៝ន​ឆេបេដេ ។ ខាន់​ពាង់​ទោល​គុ​ឆុល​ជាល​តា​ទូក នទ្រែល​មា​អី​ឞឹ​ខាន់​ពាង់​នើម។ ឞ្រាស​យេឆូ ​ក្វាល់​ជាៈ​ឞារ​ហៃ​ខាន់​ពាង់​នៃ​ហាន់​នទ្រែល​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ជេសរី​ខាន់​ពាង់​នត្លើយ​ទូក នត្លើយ​ឞឹ​ខាន់​ពាង់​នើម​តា​រី ហាន់​តឹង​ឞ្រាស​យេឆូ ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ឞ្រាស​យេឆូ ​ហាន់​លាម​ឞ្រី​កាលីលេ ពាង់​នតី​ផូង​ប៝ន​លាន​តា​ញីស​រាបុន​ផូង​អីឆ្រាអែល ​ខាន់​ពាង់​នើម។ ពាង់​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​មា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ ជេសរី​ជាន​ឞាស​ទឹង​លែៈ​នាវ​ជី​អាប់​នតីល។ ");
INSERT INTO cmok_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ឞូ​លឺ​ឞ្រាស​យេឆូ ​លាម​ឞ្រី​ឆីរី ​ដ៝ង់​អី​តឹម​ទាច់​មា​ឞ្រី​កាលីលេ ។ ជេសរី​ឞូ​ញជុន​លែវ​ទឹង​លែៈ​ឞូនុយ្ស​អី​គែស​នាវ​ជី​អា​ពាង់ ឞូនុយ្ស​គែស​នាវ​ជី​ក្វែត​អាប់​នតីល ឞូនុយ្ស​ឞ្រាស​អ្យើស​លើស ឞូនុយ្ស​ឞ្រុត នទ្រែល​មា​ឞូនុយ្ស​រាវែន​ជ៝ង់​រាវែន​តី ពាង់​ជាន​ឞាស​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ជេសរី​គែស​ឞូនុយ្ស​ផូង​អ៝ក់​តឹង​ពាង់ ខាន់​ពាង់​តាៈ​ឞើស​ឞ្រី​កាលីលេ  តាៈ​ឞើស​ឞ្រី​ដេកាពោលីស  តាៈ​ឞើស​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  តាៈ​ឞើស​ឞ្រី​យូដា  នទ្រែល​មា​តាៈ​ឞើស​កាល់​តី​ទាក​រាលាយ​យោរដាន់ ។ ");
INSERT INTO cmok_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ត៝ត់​ឞ្រាស​យេឆូ ​ឆៃ​ផូង​ប៝ន​លាន​អ៝ក់ ពាង់​ហាវ​តា​មែង​យោក គុ​រាគើប​តា​នៃ។ មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​អា​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ជេសរី​ឞ្រាស​យេឆូ ​នតី​លាស​ខាន់​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“អ្វែស​មអាក​ងាន់​មា​ឞូ​ម៝ស​អី​លែៈ​គឹត​ជេស​ឞ្លាវ​ជាន​នទើ​អ្វែស​លាស​កោរាញ​ឞ្រាស​កើល​ទើម យ៝រ​លាស​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","អ្វែស​មអាក​ងាន់​មា​ឞូ​ម៝ស​អី​គែស​នាវ​ញុម​រាង៝ត យ៝រ​លាស​កោរាញ​ឞ្រាស​មរា​ឞ៝ញ​លែង​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","អ្វែស​មអាក​ងាន់​មា​ឞូ​ម៝ស​គែស​នូយ្ស​នហ៝ម់​មលែស យ៝រ​លាស​ខាន់​ពាង់​តៃ​ឆ៝ៈ​ទើន​ទឹង​លែៈ​នែស​នតូ។ ");
INSERT INTO cmok_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","អ្វែស​មអាក​ងាន់​មា​ឞូ​ម៝ស​នអើរ​ជ៝យ​នាវ​ឆ៝ង់​តឹម​ឞាន​មា​ឞូនុយ្ស​ជី​ង៝ត​ជី​ហីរ​ជ៝យ​នទើ​ឆោង​ឆា យ៝រ​លាស​កោរាញ​ឞ្រាស​មរា​អ៝ន់​ខាន់​ពាង់​ហើម​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","អ្វែស​មអាក​ងាន់​មា​ឞូ​ម៝ស​គែស​នាវ​យោៈ​មា​ឞូ យ៝រ​លាស​កោរាញ​ឞ្រាស​យោៈ​អ៝ន់​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","អ្វែស​មអាក​ងាន់​មា​ឞូ​ម៝ស​គែស​នូយ្ស​នហ៝ម់​ក្ល៝ស យ៝រ​លាស​ខាន់​ពាង់​តៃ​ឆៃ​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","អ្វែស​មអាក​ងាន់​មា​ឞូ​ម៝ស​គឹត​តឹម​កើល​តឹម​រាង្លាប់ យ៝រ​លាស​ខាន់​ពាង់​ឞូ​ក្វាល់​តៃ​ជេង​ក៝ន​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","អ្វែស​មអាក​ងាន់​មា​ឞូ​ម៝ស​ឞូ​ជាន​ជេរ​អាច​មា​ជាន​តឹង​នាវ​ឆ៝ង់ យ៝រ​លាស​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","អ្វែស​មអាក​ងាន់​មា​ខាន់​អៃ​មៃ លាស​ឞូ​រាក​ឆ្វាយ​ជាន​ជេរ នទ្រែល​មា​ងើយ​ញចើត​អាប់​នតីល​មា​ខាន់​អៃ​មៃ អាច​មា​អ្យាត់​តឹង​នាវ​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","រាម់​ហ៝ម់ មអាក​រាម់​ហ៝ម់ យ៝រ​លាស​ខាន់​អៃ​មៃ​តៃ​គែស​នទើ​ងខោម​ក្វ៝ង់​តា​ប៝ន​អ្វែស​តា​កាលើ​ត្រោក។ អ៝ន់​កាស​គឹត ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​ឞូ​ជាន​ជេរ​កើត​អ្យា​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ខាន់​អៃ​មៃ​តឹម​ឞាន​មា​ឞ៝ស​អ៝ន់​មា​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា។ ឞ៝ស​ជេង​ទូ​នតីល​នទើ​តេៈ​ត្រាវ​មា​កាស​ងាន់ លាស​ឞ៝ស​អី​នៃ​មោ​ហោម​គែស​កាស មើម​ហោម​ឞ្លាវ​ជាន​គៃ​មា​អ៝ន់​ព្លឹ​កាស​ជឹត? លាស​នទ្រី​ឞូ​មអារ់​លើយ​ឞើស​ទីស ជេសរី​ឞូ​ជ៝ត​រាប្លាច​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ខាន់​អៃ​មៃ​តឹម​ឞាន​មា​នាវ​អាង​មា​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា តឹម​ឞាន​មា​ប៝ន​អី​ឞូ​ជាន​តា​កាលើ​យោក​មោ​អោស​ទើយ​ពោន​នទ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ឞូ​មោ​វៃ​អោស​មព៝ស​អុញ​ឆាគេង ជេសរី​កុប​លើយ​មា​នទ៝ស។ ឞូ​យោង​អុញ​ឆាគេង​អី​នៃ​តា​ងគ៝ង់ គៃ​មា​អាង​ទឹង​លែៈ​ឞូនុយ្ស​តា​ត្រោម​ជៃ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","លាស​នទ្រី​នាវ​អាង​ខាន់​អៃ​មៃ​អ៝ន់​ងអាង​ហ៝ម់​ទឹង​លែៈ​ឞូនុយ្ស គៃ​មា​អ៝ន់​ឞូ​គឹត​ឆៃ​នាវ​អ្វែស​ខាន់​អៃ​មៃ​ជាន ជេសរី​ឞូ​រានេ​នាវ​ច្រេក​លើប​ឞឹ​ខាន់​អៃ​មៃ​នើម​អី​គុ​តា​កាលើ​ត្រោក​រី”។ ");
INSERT INTO cmok_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ទាន់​ខាន់​អៃ​មៃ​លើយ​តា​មឹន​អោស​គ៝ប់​អ្យា​វាច់ គៃ​មា​ងគ្រ៝ស​មអារ់​លើយ​នាវ​វៃ​ផូង​ឞ៝ន់ មោ​លាស​ងគ្រ៝ស​មអារ់​លើយ​នាវ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​គែស​លាស។ គ៝ប់​មោ​គែស​អោស​វាច់​គៃ​មា​ងគ្រ៝ស​មអារ់​លើយ​នទើ​អី​នៃ គ៝ប់​វាច់​គៃ​មា​អ៝ន់​នាវ​អី​នៃ​ជេង​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ លាស​ត្រោក នទ្រែល​មា​នែស​នតូ​អេ​ហ៝ៈ​លោច​អោស មោ​គែស​អោស​រ៝ស​ទូ​រាព្លៃ​រាឆ៝​តា​ឆ៝ម់បុត​នាវ​វៃ​អី​នៃ ទូ​នតីល​តា​រាព្លៃ​រាឆ៝​ទុត​ជេៈ​មោ​រ៝ស​ដ៝ង់ នាវ​កោរាញ​ឞ្រាស​ងើយ​អី​នៃ​ហោម​បាបើ​ត៝ត់​លោច​ទឹង​លែៈ។ ");
INSERT INTO cmok_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ឞូ​ម៝ស​អី​ជាន​តីស​មា​ទូ​នតីល​នាវ​អី​ទុត​ជេៈៗ​តា​នាវ​វៃ​អី​នៃ ជេសរី​នតី​អ៝ន់​មា​ឞូ​ជាន​តឹង​កើត​ដ៝ង់ តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​តៃ​ឞូ​ក្វាល់​ពាង់​ជេង​ឞូនុយ្ស​ជេៈ​តា​ន៝ម់​ឞូ។ យើន​មា​ឞូ​ម៝ស​ជាន​តឹង​នាវ​វៃ​អី​នៃ ជេសរី​នតី​អ៝ន់​មា​ឞូ​ជាន​តឹង​កើត​ដ៝ង់ តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​តៃ​ឞូ​ក្វាល់​ពាង់​ជេង​ឞូនុយ្ស​ក្វ៝ង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","គ៝ប់​លាស​មា​ខាន់​អៃ​មៃ៖ លាស​នាវ​ឆ៝ង់​ខាន់​អៃ​មៃ​មោ​រាលាវ​អោស​មា​នាវ​ឆ៝ង់​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ នទ្រែល​មា​នាវ​ឆ៝ង់​ផូង​ផារីឆី  ខាន់​អៃ​មៃ​មោ​ទើយ​អោស​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់”។ ");
INSERT INTO cmok_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ខាន់​អៃ​មៃ​លែៈ​តាង់​ឞូ​លាស​មា​ផូង​អូ​ចែ​កាល់​អែ​នើស៖ «លើយ​អោស​ងខឹត​ឞូនុយ្ស»។ លាស​ឞូ​ម៝ស​ងខឹត​ឞូនុយ្ស ពាង់​អី​នៃ​ឞូ​តេៈ​ទោយ្ស​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","យើន​មា​គ៝ប់​លាស​មា​ខាន់​អៃ​មៃ​កើត​នអា៖ ឞូ​ម៝ស​អី​ជី​នូយ្ស​ដាស​មា​អ៝ស​នោ​ពាង់​ទើម ពាង់​អី​នៃ​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​មា​ពាង់។ ឞូ​ម៝ស​អី​ងើយ​អ្យើស​មា​អ៝ស​នោ​ពាង់ ពាង់​អី​នៃ​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស។ ជេសរី​ឞូ​ម៝ស​អី​រាក​ឆ្វាយ​ឞូ ពាង់​អី​នៃ​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​គុ​តា​នទ្រូង​អុញ​នហ៝​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","លាស​នទ្រី​នោក​ខាន់​អៃ​មៃ​ញអោត​នទើ​ញហើរ​ហាន់​តា​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​តា​ញឆឺង​គុច​ពូរ​នទើ​ជាន​ឞ្រាស ត៝ត់​តា​នៃ​លាស​ខាន់​អៃ​មៃ​កាស​គឹត​ខាន់​អៃ​មៃ​គែស​ជាន​តីស​មា​អ៝ស​នោ​ខាន់​អៃ​មៃ‌ ");
INSERT INTO cmok_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","អ៝ន់​ខាន់​អៃ​មៃ​ព្រាប់​នទើ​ញហើរ​អី​នៃ​តា​នៃ​ប៝ត់ ជេសរី​ហាន់​ទាន់​នាវ​យោៈ​ល៝រ​ដាស​អ៝ស​នោ​ខាន់​អៃ​មៃ រី​មើ​ទឹង​ខាន់​អៃ​មៃ​ព្លឹ​ញហើរ​តៃ​នទើ​អី​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","អ៝ន់​ខាន់​អៃ​មៃ​តឹម​ទាន់​នាវ​យោៈ​ហ៝ម់​ដាស​ឞូនុយ្ស​អី​គែស​នាវ​ដាស​ខាន់​អៃ​មៃ​ទោល​ខាន់​អៃ​មៃ​ហោម​ហាន់​នទ្រែល​ពាង់​រ៝ៈ​ត្រ៝ង​ហាន់​តា​កោរាញ​ផាត​ទោយ្ស។ ក្លាច​លាស​ពាង់​ញជុន​ខាន់​អៃ​មៃ​អ៝ន់​មា​កោរាញ​ផាត​ទោយ្ស កោរាញ​ផាត​ទោយ្ស​ញជុន​ខាន់​អៃ​មៃ​អ៝ន់​មា​កោរាញ​នទ្រូង ជេសរី​កោរាញ​នទ្រូង​ក្រុង​ខាន់​អៃ​មៃ​តា​ត្រោម​នទ្រូង​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ លាស​ខាន់​អៃ​មៃ​មោ​រឹង​អ៝ន់​ព្រាក់​មា​ឞូ ខាន់​អៃ​មៃ​មោ​អោស​ទើយ​លោស​ឞើស​នតុក​នៃ ឞ៝ល​លាស​ទូ​ឆេន​មោ​រ៝ស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ខាន់​អៃ​មៃ​លែៈ​តាង់​តា​នាវ​វៃ​ឞ៝ន់​លែៈ​ញចីស​លាស​កើត​នអា៖ «លើយ​តា​ល៝ម់​អូរ​ល៝ម់​ឆាយ»។ ");
INSERT INTO cmok_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","យើន​មា​គ៝ប់​លាស​មា​ខាន់​អៃ​មៃ លាស​ឞូ​ម៝ស​អ្វាញ់​ឞូ​អូរ​នអ៝ប់​មា​កើញ លាស​នទ្រី​តា​នូយ្ស​នហ៝ម់​ពាង់​រី​លែៈ​កើប​ល៝ម់​អូរ​ដាស​ឞូ​អូរ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","លាស​នទ្រី​លាស​ត្រោម​មាត់​ឞើស​មា​ខាន់​អៃ​មៃ​លែវ​ជាន​តីស អ៝ន់​ខាន់​អៃ​មៃ​រាវែក​មអារ់​លើយ​ត្រោម​មាត់​អី​នៃ យ៝រ​លាស​អ្វែស​ដេៈ​លាស​ទើន​រ៝ស​ត្រោម​មាត់​ទូ​ទីង មា​ដាស​ទឹង​លែៈ​ឆាក់​ជាន់​ខាន់​អៃ​មៃ​ហោម​រឹង ជេសរី​ហាន់​តា​នទ្រូង​អុញ​នហ៝​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","លាស​តី​ឞើស​មា​ខាន់​អៃ​មៃ​លែវ​ជាន​តីស អ៝ន់​ខាន់​អៃ​មៃ​ក៝ស​មអារ់​លើយ​តី​អី​នៃ យ៝រ​លាស​អ្វែស​ដេៈ​លាស​ទើន​រ៝ស​តី​ទូ​ទីង មា​ដាស​ទឹង​លែៈ​ឆាក់​ជាន់​ខាន់​អៃ​មៃ​ហោម​រឹង ជេសរី​ហាន់​តា​នទ្រូង​អុញ​នហ៝​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“តា​នាវ​វៃ​ឞ៝ន់​លែៈ​ញចីស​លាស​កើត​នអា៖ «ឞូ​ម៝ស​អី​អុច​នត្លើយ​អូរ​ពាង់​នើម អ៝ន់​ពាង់​អី​នៃ​ជាន​ឆ៝ម់បុត​តឹម​នត្លើយ​ទើម​អ៝ន់​មា​អូរ​ពាង់ ជេសរី​ទើយ​នត្លើយ​អី​អូរ​ពាង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","យើន​មា​គ៝ប់​លាស​មា​ខាន់​អៃ​មៃ លាស​ឞូ​អូរ​អី​នៃ​មោ​គែស​អោស​ល៝ម់​ឆាយ តីស​មា​ឆាយ​ពាង់​នត្លើយ ឆាយ​អី​នៃ​ជាន​អ៝ន់​អូរ​ពាង់​ជេង​ឞូនុយ្ស​ល៝ម់​ឆាយ។ ជេសរី​លាស​ឞូ​ម៝ស​តឹម​នអាប់​ដាស​ឞូ​អូរ​ឆាយ​នត្លើយ ពាង់​ជេង​ឞូនុយ្ស​ល៝ម់​អូរ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ខាន់​អៃ​មៃ​លែៈ​តាង់​ឞូ​លាស​មា​ផូង​អូ​ចែ​កាល់​អែ​នើស៖ «លើយ​អោស​ត៝ន​មរោស អ៝ន់​ខាន់​អៃ​មៃ​ជាន​រឹង​ទឹង​លែៈ​នទើ​អី​ខាន់​អៃ​មៃ​លែៈ​ត៝ន​មា​កោរាញ​ឞ្រាស»។ ");
INSERT INTO cmok_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","យើន​មា​គ៝ប់​លាស​មា​ខាន់​អៃ​មៃ លើយ​អោស​ត៝ន​ដាស​ត្រោក យ៝រ​លាស​ត្រោក​ជេង​រានើល​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","លើយ​ដ៝ង់​ត៝ន​ដាស​នែស​នតូ យ៝រ​លាស​នែស​នតូ​អ្យា​ជេង​រានើល​ឆាប់​ជ៝ង់​កោរាញ​ឞ្រាស។ ដាស​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​មោ​ទី​ដ៝ង់ យ៝រ​លាស​ប៝ន​យេរូឆាលឹម ​នតុក​កោរាញ​ឞ្រាស​អី​កាដាច់​ក្វ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","លើយ​អោស​ត៝ន​ដាស​ឞោក​ខាន់​អៃ​មៃ​នើម យ៝រ​លាស​ខាន់​អៃ​មៃ​មោ​ទើយ​អោស​ជាន​ទូ​មល៝ម់​ឆ៝ក់​ខាន់​អៃ​មៃ​នើម​អ៝ន់​ជេង​ងលាង អ៝ន់​ជេង​ក្រាក់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","អ៝ន់​ខាន់​អៃ​មៃ​ងើយ​ឆ៝ង់​នឹង​ហ៝ៈ «អើ» អ៝ន់​គឹត​លាស​«អើ»‌ «មោ» អ៝ន់​គឹត​លាស​«មោ»។ នទើ​នាវ​ងើយ​នត៝ប​ជេង​លោស​តាៈ​ឞើស​កោរាញ​មពោល​ឞ្រាស​អ្យើស​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ខាន់​អៃ​មៃ​លែៈ​តាង់​តា​នាវ​វៃ​ឞ៝ន់​លែៈ​ញចីស​លាស​កើត​នអា៖ «លាស​រ៝ស​មាត់​ទូ​ទីង ព្លើង​អ៝ន់​រ៝ស​មាត់​ទូ​ទីង លាស​ទែស​ទូ​មល៝ម់​ឆេក ព្លើង​អ៝ន់​ទែស​ទូ​មល៝ម់​ឆេក​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","យើន​មា​គ៝ប់​លាស​មា​ខាន់​អៃ​មៃ លើយ​អោស​តឹម​ព្លើង​ដាស​មា​ឞូនុយ្ស​អ្យើស។ លាស​ឞូ​តាប​តឹម​ឞ៝ម​ខាន់​អៃ​មៃ​ទូ​ទីង អ៝ន់​ខាន់​អៃ​មៃ​រាលែ​ទូ​ទីង អ៝ន់​ឞូ​តាប​តៃ​ទូ​ទីង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","លាស​ឞូ​នតោន​ខាន់​អៃ​មៃ​តា​នាប់​កោរាញ​ផាត​ទោយ្ស​គៃ​មា​កើញ​គែស​អាវ​គ្លែស​ខាន់​អៃ​មៃ អ៝ន់​ឞូ​ឆ៝ៈ​នអ៝ប់​មា​អាវ​ជ៝ង​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","លាស​តាហែន​ញច៝ប់​ខាន់​អៃ​មៃ​អ៝ន់​អាញ​នទើ​ឞ្រោៈ​ទូ​ន៝រ​យោក អ៝ន់​ខាន់​អៃ​មៃ​ឞ្រោៈ​ឞារ​ន៝រ​យោក​នទ្រែល​ឞូ​ទោ។ ");
INSERT INTO cmok_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ឞូ​ម៝ស​ទាន់​នទើ​ខាន់​អៃ​មៃ ខាន់​អៃ​មៃ​អ៝ន់​ទោ លើយ​អោស​ទូ​ក្រាប​លាស​ឞូ​ហាន់​មាញ​នទើ​ខាន់​អៃ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ខាន់​អៃ​មៃ​លែៈ​តាង់​តា​នាវ​វៃ​ឞ៝ន់​លែៈ​ញចីស​លាស​កើត​នអា៖ «អ៝ន់​ខាន់​អៃ​មៃ​រ៝ង់​មា​ឞូ​ច្យៅ​មែង ជេសរី​ឞ្យាញ់​មា​ផូង​ជាន​អ្យើស​ដាស​ខាន់​អៃ​មៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","យើន​មា​គ៝ប់​លាស​មា​ខាន់​អៃ​មៃ អ៝ន់​ខាន់​អៃ​មៃ​រ៝ង់​មា​ផូង​ជាន​អ្យើស​ដាស​ខាន់​អៃ​មៃ ជេសរី​មឞើស​ឆើម​ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​ឞូ​ម៝ស​ជាន​ជេរ​ដាស​ខាន់​អៃ​មៃ‌ ");
INSERT INTO cmok_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","គៃ​មា​ខាន់​អៃ​មៃ​ជេង​ក៝ន​ងាន់​មា​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​គុ​តា​កាលើ​ត្រោក​រី។ យ៝រ​លាស​កោរាញ​ឞ្រាស​អ៝ន់​នារ​លោស​អាង គៃ​មា​ងអាង​ឞូនុយ្ស​អ្វែស នអ៝ប់​មា​ឞូនុយ្ស​អ្យើស ជេសរី​ពាង់​អ៝ន់​ទាក​មីស​មា​ឞូនុយ្ស​ឆ៝ង់ នអ៝ប់​មា​ឞូនុយ្ស​ក្វែ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","លាស​ខាន់​អៃ​មៃ​ទើន​រ៝ង់​ទើម​មា​ឞូនុយ្ស​រ៝ង់​ដាស​ខាន់​អៃ​មៃ លាស​នទ្រី​មើម​ទឹង​កោរាញ​ឞ្រាស​រានេ​អ៝ន់​នាវ​ងខោម​មា​ខាន់​អៃ​មៃ? យ៝រ​លាស​ឞូនុយ្ស​អី​ឞូ​កើប​ឞូនុយ្ស​តីស​កើត​លាស​ផូង​អី​ក៝ប់​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន​គៃ​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ ខាន់​ពាង់​ហោម​ឞ្លាវ​រ៝ង់​មា​ឞូនុយ្ស​អី​រ៝ង់​ខាន់​ពាង់​នើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","លាស​ខាន់​អៃ​មៃ​ទើន​រ៝ម​ទើម​មា​អ៝ស​នោ​ខាន់​អៃ​មៃ​នើម លាស​នទ្រី​មើម​ទឹង​ខាន់​អៃ​មៃ​ជាន​នទើ​អ្វែស​រាលាវ​ឞូ​អេង? ឞ៝ល​លាស​ផូង​អី​មោ​គឹត​នាល់​នាវ​កោរាញ​ឞ្រាស ខាន់​ពាង់​វៃ​ជាន​កើត​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","លាស​នទ្រី​អ៝ន់​ខាន់​អៃ​មៃ​គុ​ទុត​អ្វែស​ហ៝ម់ យ៝រ​លាស​ឞឹ​ខាន់​អៃ​មៃ​អី​គុ​តា​កាលើ​ត្រោក​រី ពាង់​លែៈ​ទុត​អ្វែស​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់ លើយ​អោស​ជាន​នទើ​អ្វែស​មា​ឞូ​តា​នាប់​ឞាល់​ផូង​គៃ​មា​អ៝ន់​ឞូ​ឆៃ។ លាស​ជាន​កើត​នៃ ខាន់​អៃ​មៃ​មោ​គែស​អោស​នទើ​ងខោម​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​អី​គុ​តា​កាលើ​ត្រោក​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","នោក​ខាន់​អៃ​មៃ​អ៝ន់​នទើ​យោៈ​មា​ផូង​អ៝​អាច លើយ​អោស​មឞើស​មា​ទឹង​លែៈ​ឞូនុយ្ស​មា​នទើ​ខាន់​អៃ​មៃ​ជាន​អី​នៃ​តឹម​ឞាន​មា​ផូង​អី​ញហើ​នាវ​អ្វែស​អ៝ន់​ឞូ​ឆៃ​តា​កាលើ​នតោ​ទើម​វៃ​ជាន​តា​ញីស​រាបុន​ផូង​ឞ៝ន់ មោ​លាស​រ៝ៈ​ត្រ៝ង គៃ​មា​អ៝ន់​ឞូ​រានេ។ គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ផូង​អី​ញហើ​នាវ​អ្វែស​អ៝ន់​ឞូ​ឆៃ​តា​កាលើ​នតោ​ទើម​អី​នៃ​លែៈ​គែស​ឞូ​រានេ​ខាន់​ពាង់​ជេស កោរាញ​ឞ្រាស​មោ​ហោម​អោស​អ៝ន់​នទើ​អ្វែស​មា​ខាន់​ពាង់​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","យើន​មា​នោក​ខាន់​អៃ​មៃ​អ៝ន់​នទើ​យោៈ អ៝ន់​ខាន់​អៃ​មៃ​ជាន​នតុង​មពោន​ហ៝ៈ តឹម​ឞាន​មា​លើយ​អ៝ន់​តី​ឞើស​ច្យៅ​គឹត​អី​តី​ឞើស​មា​ជាន ជេសរី​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​អី​ឆៃ​ទឹង​លែៈ​នទើ​អី​ឞូ​ជាន​នតុង​មពោន​ដ៝ង់ តៃ​ពាង់​ងខោម​មា​ខាន់​អៃ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“នោក​ខាន់​អៃ​មៃ​មឞើស​ឆើម លើយ​អោស​ជាន​តឹម​ឞាន​មា​ផូង​អី​ញហើ​នាវ​អ្វែស​អ៝ន់​ឞូ​ឆៃ​តា​កាលើ​នតោ​ទើម​វៃ​ទ៝ក់​មឞើស​ឆើម​តា​ត្រោម​ញីស​រាបុន​ផូង​ឞ៝ន់ នទ្រែល​មា​តា​មែង​ត្រ៝ង គៃ​មា​ឞូ​ឆៃ។ គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ផូង​អី​នៃ​លែៈ​គែស​ជេស​នទើ​ងខោម​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","យើន​មា​ខាន់​អៃ​មៃ នោក​មឞើស​ឆើម អ៝ន់​ខាន់​អៃ​មៃ​លាប់​តា​ត្រោម​ជ្រោ​នតឹល​មពោង​អ៝ន់​ន៝ប់ ជេសរី​មឞើស​ឆើម​ទាន់​មា​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​អី​ឞូនុយ្ស​មោ​ឞ្លាវ​ឆៃ។ លាស​នទ្រី​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​អី​ឆៃ​ទឹង​លែៈ​នទើ​អី​គែស​តា​នតុក​នទ៝ប់​ដ៝ង់ តៃ​ពាង់​ងខោម​មា​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","នោក​ខាន់​អៃ​មៃ​មឞើស​ឆើម លើយ​លាស​ជ៝ង​រាហេង​កើត​ផូង​អី​មោ​គឹត​នាល់​នាវ​កោរាញ​ឞ្រាស នាវ​អី​នៃ​មោ​គែស​អោស​ខ្លៃ។ ខាន់​ពាង់​មឹន​លាស​កោរាញ​ឞ្រាស​អ្យាត់​ខាន់​ពាង់​តាៈ​ឞើស​នាវ​ងើយ​អ៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","លាស​នទ្រី​ខាន់​អៃ​មៃ​លើយ​អោស​ជាន​កើត​ខាន់​ពាង់​អី​នៃ យ៝រ​លាស​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​លែៈ​អើម​គឹត​ល៝រ​ម៝ស​នទើ​ខាន់​អៃ​មៃ​អុច​ទាន់​តាៈ​ឞើស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","លាស​នទ្រី​អ៝ន់​ខាន់​អៃ​មៃ​មឞើស​ឆើម​កើត​នអា៖ «អើ​កោរាញ​ឞ្រាស​ឞឹ​ហេន​គុ​តា​កាលើ​ត្រោក‌ អ៝ន់​ទឹង​លែៈ​ឞូនុយ្ស​យើក​មឞាស​មា​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","អ៝ន់​នាវ​មៃ​ម៝ត់​អ្វាញ់​គើញ​ត៝ត់។ ទាន់​ទឹង​លែៈ​នាវ​តា​នែស​នតូ​អ្យា​តឹង​នាវ​មៃ​អុច‌ តឹម​ឞាន​មា​ទឹង​លែៈ​នាវ​តា​កាលើ​ត្រោក​លែៈ​តឹង​នាវ​មៃ​អុច។ ");
INSERT INTO cmok_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","អ៝ន់​នទើ​ឆោង​ឆា​មា​ហេន​នារ​អ្យា​អ៝ន់​ត៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","យោៈ​នអាច​លើយ​ហោម​កើប​នាវ​តីស​ហេន‌ តឹម​ឞាន​មា​ហេន​យោៈ​នអាច​មា​ឞូនុយ្ស​ជាន​តីស​មា​ហេន មោ​ហោម​កើប​នាវ​តីស​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","កើល​ហេន​លើយ​អោស​ជាន​តីស នោក​ហេន​គែស​នាវ​នទើម។ ទាន់​រាក្លាយ្ស​ហេន​ឞើស​នាវ​អ្យើស​មហឹក។ មៃ​ជេង​កាដាច់ មៃ​គែស​នាវ​ឞ្រាស នទ្រែល​មា​គែស​នាវ​ច្រេក​លើប​បាបើ​នហ៝​រ៝។ អើ​អ៝ន់​គែស​កើត​នអា​ងាន់​រ៝។» ");
INSERT INTO cmok_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","លាស​ខាន់​អៃ​មៃ​យោៈ​ឞូ​មោ​កើប​នាវ​តីស​អី​ឞូ​ជាន​មា​ខាន់​អៃ​មៃ កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​តា​កាលើ​ត្រោក​យោៈ​ខាន់​អៃ​មៃ​មោ​ហោម​កើប​ដ៝ង់​នាវ​តីស។ ");
INSERT INTO cmok_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","តីស​មា​លាស​ខាន់​អៃ​មៃ​មោ​គែស​នាវ​យោៈ ហោម​កើប​នាវ​តីស​ឞូ កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​អី​គុ​តា​កាលើ​ត្រោក​មោ​យោៈ​ដ៝ង់​ហោម​កើប​នាវ​តីស​មា​ខាន់​អៃ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“នោក​ខាន់​អៃ​មៃ​អ៝ត់​ឆោង​គៃ​មា​មឞើស​ឆើម លើយ​អោស​ជាន​មុស​មាត់​រាង៝ត​តឹម​ឞាន​មា​ផូង​អី​ញហើ​នាវ​អ្វែស​អ៝ន់​ឞូ​ឆៃ​តា​កាលើ​នតោ​ទើម។ ខាន់​ពាង់​ជាន​កើត​នៃ គៃ​មា​អ៝ន់​ឞូ​គឹត​លាស​ខាន់​ពាង់​អ៝ត់​ឆោង។ គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ផូង​អី​នៃ​លែៈ​គែស​ជេស​នទើ​ងខោម​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","យើន​មា​ខាន់​អៃ​មៃ នោក​ខាន់​អៃ​មៃ​អ៝ត់​ឆោង អ៝ន់​ខាន់​អៃ​មៃ​កឹត​ឆ៝ក់ ជេសរី​រាពោស​មុស​មាត់‌ ");
INSERT INTO cmok_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","គៃ​មា​លើយ​អ៝ន់​ឞូ​ឆៃ​ខាន់​អៃ​មៃ​អ៝ត់​ឆោង។ អ៝ន់​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​អី​ឞូនុយ្ស​មោ​ឞ្លាវ​ឆៃ​ទើម​ហ៝ៈ​ឆៃ លាស​នទ្រី​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​អី​ឆៃ​ទឹង​លែៈ​នទើ​អី​គែស​តា​នតុក​នទ៝ប់​ដ៝ង់ តៃ​ពាង់​ងខោម​មា​ខាន់​អៃ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“លើយ​អោស​រាបុន​ទ្រាប់​នទើ​ព្រាប់​មា​ឆាក់​ខាន់​អៃ​មៃ​នើម​តា​នែស​នតូ​អ្យា ជេង​នតុក​អាច់​គាម់​ឆា នទ្រែល​មា​តាប់ទឹរ​គ្រាច់ ជេសរី​គែស​ឞូនុយ្ស​នតុង​ហាន់​លោក​មពីរ​គៃ​មា​នតុង។ ");
INSERT INTO cmok_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","អ៝ន់​ខាន់​អៃ​មៃ​រាបុន​ទ្រាប់​នទើ​ព្រាប់​មា​ឆាក់​ខាន់​អៃ​មៃ​នើម​តា​នតុក​កោរាញ​ឞ្រាស​តា​កាលើ​ត្រោក​រី​ហ៝ៈ ជេង​នតុក​មោ​គែស​អាច់​គាម់​ឆា នទ្រែល​មា​មោ​គែស​តាប់ទឹរ​គ្រាច់ មោ​គែស​ដ៝ង់​ឞូនុយ្ស​នតុង​ហាន់​លោក​មពីរ​មា​នតុង។ ");
INSERT INTO cmok_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ញជ្រាង់​ហ៝ម់ នទើ​អី​ខាន់​អៃ​មៃ​នត្រ៝ង់​ខ្លៃ​រាលាវ​ឞូ ជេង​នទើ​អី​ខាន់​អៃ​មៃ​មឹន​រាវៃ​រាលាវ​ឞូ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ត្រោម​មាត់​ជេង​តឹម​ឞាន​មា​ឆាគេង​មា​ឆាក់​ជាន់ លាស​ត្រោម​មាត់​ខាន់​អៃ​មៃ​ហោម​អាង​អ្វែស លែៈ​ឆាក់​ជាន់​ខាន់​អៃ​មៃ​ហោម​អាង​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","យើន​មា​លាស​មាត់​ខាន់​អៃ​មៃ​លែៈ​ង៝ ទឹង​លែៈ​ឆាក់​ជាន់​ខាន់​អៃ​មៃ​ង៝​ទាទេ​ដ៝ង់។ លាស​នាវ​អាង​តា​ឆាក់​ខាន់​អៃ​មៃ​លែៈ​ង៝ លាស​នទ្រី​នាវ​ង៝​អី​នៃ​លែៈ​ហោ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​ឞ្លាវ​ជាន​ការ​អ៝ន់​មា​ឞារ​ហៃ​កោរាញ យ៝រ​លាស​ពាង់​មរា​រ៝ង់​មា​ទូ​ហ្វេ​កោរាញ ជេសរី​ឞ្យាញ់​មា​ទូ​ហ្វេ​កោរាញ មោ​លាស​តឹង​ជឹត​ទូ​ហ្វេ មឺច​អី​ទូ​ហ្វេ​រី។ កើត​នទ្រី​ខាន់​អៃ​មៃ​មោ​ទើយ​អោស​គៃ​គែស​នាវ​រេស​នហ៝​រ៝​តា​កោរាញ​ឞ្រាស គៃ​គែស​នអ៝ប់​មា​ទ្រាប់​នទើ​តា​នែស​នតូ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","កើត​នទ្រី​ទឹង​គ៝ប់​មឞើស​ខាន់​អៃ​មៃ លើយ​រាវៃ​អោស​មា​នទើ​ឆោង​ឆា​មា​នទើ​ញេត​មា​ឆ្យាម់​នាវ​រេស មោ​លាស​ឞ៝ក​អាវ​មា​ញឆ៝ស​ងគូត​ឆាក់​ជាន់​ខាន់​អៃ​មៃ។ គែស​នទើ​អេង​ជឹត​តា​នាវ​រេស​អី​គែស​នាវ​ខ្លៃ​រាលាវ​មា​នទើ​ឆោង​ឆា គែស​នទើ​អេង​ជឹត​មា​ឞូនុយ្ស​អី​គែស​នាវ​ខ្លៃ​រាលាវ​មា​ឞ៝ក​អាវ​មា​ញឆ៝ស។ ");
INSERT INTO cmok_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ល៝ង់​អ្វាញ់​ឆ្យុម​មពារ់​កាលើ​ត្រោក ពាង់​មោ​គែស​អោស​តូច​តាម់ មោ​គែស​អោស​កាច់​រ៝យ្ស មោ​គែស​តោស​ឞា​តា​ត្រោម​ជៃ​ដ៝ង់ យើន​មា​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​តា​កាលើ​ត្រោក​ម៝ត់​ឆ្យាម់​ខាន់​ពាង់​ដ៝ង់។ លាស​នទ្រី​អាស​ខាន់​អៃ​មៃ​អើម​មោ​លាស​ខ្លៃ​រាលាវ​មា​ឆ្យុម​មពារ់​អី​នៃ​ជឹត​បាស? ");
INSERT INTO cmok_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","តា​មពោល​ខាន់​អៃ​មៃ​អី​នៃ ឞ៝ល​លាស​ខ៝ម់​រាវៃ​ទុត​ហោ​កាដោយ​លែៈ ក៝ៈ​មោ​គែស​ឞូនុយ្ស​មា​ទើយ​នត៝ប​នាវ​រេស​ពាង់​នើម​អ៝ន់​ជ៝ង​អោស ដេៈ​ក៝ៈ​មោ​ទើយ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","មើម​ទឹង​ខាន់​អៃ​មៃ​រាវៃ​មា​នទើ​ញឆ៝ស​ងគូត? ល៝ង់​ខាន់​អៃ​មៃ​អ្វាញ់​កាវ​ឆី​ហ៝ន​អេង​តា​ឞ្រី ពាង់​មោ​អោស​រាអាស​មោ​អោស​រាគាញ់​ជាន​ការ មោ​លាស​រូយ​តាញ​គៃ​មា​អ្វែស​អ្វាញ់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ ឞ៝ល​លាស​កាដាច់​ឆាលោមោន ​កាល់​អែ​នើស នោក​ពាង់​ងក្រឹ​ឆាក់​ជាន់​ឆ៝ស​ងគូត​ខ៝​អាវ​ខ្លៃ​អ្វែស ក៝ៈ​មោ​ទើយ​ឞាន​អ្វែស​កាវ​ឆី​ទូ​ងក៝ង​អ្យា​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ហើយ​ឞូនុយ្ស​គែស​នាវ​ញឆីង​ដេៈ​ទើម លាស​កោរាញ​ឞ្រាស​អ៝ន់​ជេស​មា​កាវ​ឆី​អី​នៃ​អ្វែស​ងាន់​អ្វាញ់ នារ​អ្យា​ពាង់​ទាង នារ​អោយ​តៃ​ឞូ​ឆូ​លើយ​ពាង់​មា​អុញ លាស​នទ្រី​លើ​រាលាវ​មា​នៃ​ដ៝ង់​បាស​កោរាញ​ឞ្រាស​នទ្រាប់​ខ៝​អាវ​អ៝ន់​មា​ខាន់​អៃ​មៃ? ");
INSERT INTO cmok_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","លាស​នទ្រី​ខាន់​អៃ​មៃ​លើយ​រាវៃ​អោស​មា​នទើ​ឆោង​ឆា មា​នទើ​ញេត មោ​លាស​មា​នទើ​ញឆ៝ស​ងគូត។ ");
INSERT INTO cmok_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","គែស​ផូង​អី​មោ​គឹត​នាល់​កោរាញ​ឞ្រាស​ខ៝ម់​ញឆ្រោយ្ស​ជ៝យ​ទឹង​លែៈ​នទើ​អី​នៃ។ ល៝ង់​អី​ខាន់​អៃ​មៃ​នៃ​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​នើម​តា​កាលើ​ត្រោក​រី លែៈ​ពាង់​គឹត​ទាទេ​ជេស​ម៝ស​នទើ​អី​ខាន់​អៃ​មៃ​អេ​ហ៝ៈ​ត៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","លាស​នទ្រី​ញឆ្រោយ្ស​ជ៝យ នទ្រែល​មា​អ្យាត់​លែៈ​នទើ​អី​ឆ៝ង់​តា​នាប់​មាត់​កោរាញ​ឞ្រាស​ល៝រ រី​មើ​ពាង់​អ៝ន់​នត៝ប​ទឹង​លែៈ​នទើ​អី​នៃ​មា​ខាន់​អៃ​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ខាន់​អៃ​មៃ​លើយ​អោស​រាវៃ​មា​នារ​អោយ​តៃ យ៝រ​លាស​នារ​អោយ​តៃ​មរា​គែស​នាវ​រាវៃ​មា​នារ​អី​នៃ។ រាវៃ​មា​នាវ​ជេរ​តា​នារ​អ្យា​លែៈ​គាប់​ហើយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ខាន់​អៃ​មៃ​លើយ​អោស​អ្វាញ់​នាវ​តីស​ឞូ គៃ​មា​លើយ​អ៝ន់​កោរាញ​ឞ្រាស​អ្វាញ់​នាវ​តីស​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","លាស​ខាន់​អៃ​មៃ​អ្វាញ់​នាវ​តីស​ឞូ កោរាញ​ឞ្រាស​អ្វាញ់​នាវ​តីស​ខាន់​អៃ​មៃ​កើត​នៃ​ដ៝ង់។ កោរាញ​ឞ្រាស​រាញ្វែស​អ៝ន់​មា​ខាន់​អៃ​មៃ តឹង​ខាន់​អៃ​មៃ​រាញ្វែស​អ៝ន់​ឞូ​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","នាវ​តីស​ឞូនុយ្ស​ជេង​តឹម​ឞាន​មា​នទើ​តា​ត្រោម​មាត់។ មើម​ខាន់​អៃ​មៃ​អ្វាញ់​ឆៃ​នទ្រុយ្ស​តា​ត្រោម​មាត់​អ៝ស​នោ​ខាន់​អៃ​មៃ​ទើម តីស​មា​អ្វាញ់​មោ​អោស​ឆៃ​ម៝ង់​រាលាត​តា​ត្រោម​មាត់​ខាន់​អៃ​មៃ​នើម? ");
INSERT INTO cmok_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","លាស​គែស​ម៝ង់​រាលាត​តា​ត្រោម​មាត់​ខាន់​អៃ​មៃ​នើម មើម​ទើយ​លាស​មា​អ៝ស​នោ៖ «អ៝ន់​គ៝ប់​ងខែៈ​នទ្រុយ្ស​នៃ»? ");
INSERT INTO cmok_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","អើ​ឞូនុយ្ស​មរោស! អ៝ន់​ឆ៝ៈ​រាលាត​តា​ត្រោម​មាត់​ខាន់​អៃ​មៃ​នើម​នៃ​ល៝រ​ប៝ត់ រី​មើ​ឆៃ​នហេល​នទ្រុយ្ស​តា​ត្រោម​មាត់​អ៝ស​នោ ទឹង​ឞ្លាវ​ងខែៈ​នទ្រុយ្ស​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“លើយ​អោស​មអារ់​នទើ​ក្ល៝ស​អ្វែស​អ៝ន់​មា​ឆ៝ មោ​ទើយ​មអារ់​អ៝ន់​មា​ឆុរ​ដ៝ង់ ក្លាច​លាស​ពាង់​ជ៝ត​រាប្លាច ជេសរី​រាទោស​ព្លឹ​កាប់​ខាន់​អៃ​មៃ​នើម។ កើត​នទ្រី​ដ៝ង់​អ៝ន់​គឹត​មើម​ទឹង​នតី​នាវ​កោរាញ​ឞ្រាស​អ៝ន់​មា​ឞូនុយ្ស​អី​មោ​អុច​អ្យាត់”។ ");
INSERT INTO cmok_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ទាន់​មរ៝​មរាង់​ហ៝ម់​មា​កោរាញ​ឞ្រាស​ទឹង​ពាង់​អ៝ន់​មា​ខាន់​អៃ​មៃ។ ជ៝យ​មរ៝​មរាង់​ហ៝ម់​ទឹង​ឆៃ។ ក្វាល់ ​មរ៝​មរាង់​ហ៝ម់​ឞើស​ទីស​មពោង​ទឹង​កោរាញ​ឞ្រាស​ពើក​អ៝ន់​មា​ខាន់​អៃ​មៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","យ៝រ​លាស​ឞូ​ម៝ស​ទាន់ មរា​គែស ឞូ​ម៝ស​ជ៝យ​មរា​ឆៃ ជេសរី​ឞូ​ម៝ស​អី​ក្វាល់​ឞើស​ទីស​មពោង មរា​ពើក​អ៝ន់​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","តា​មពោល​ខាន់​អៃ​មៃ​វៃ​គែស​ដ៝ង់ លាស​ក៝ន​ទាន់​ព្យាង់​អ៝ន់​ងខើង​លុ​មា​ពាង់​ច្រាវ? ");
INSERT INTO cmok_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","លាស​ក៝ន​ទាន់​កា ឞឹ​ពាង់​អ៝ន់​ងខើង​ឞេស​គែស​កាច់​មា​ពាង់​ច្រាវ​ឞើស? ");
INSERT INTO cmok_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ឞ៝ល​លាស​ខាន់​អៃ​មៃ​ជេង​ឞូនុយ្ស​តីស​កាដោយ ខាន់​អៃ​មៃ​ហោម​ឞ្លាវ​អ៝ន់​នទើ​អ្វែស​មា​ក៝ន​ខាន់​អៃ​មៃ​ដ៝ង់។ លាស​នទ្រី​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​អី​គុ​តា​កាលើ​ត្រោក​រាលាវ​ឞើស​នៃ​អ៝ន់​នទើ​អ្វែស​មា​ឞូ​ម៝ស​ទាន់​ឞើស​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“តា​អាប់​នតីល​នទើ ម៝ស​នាវ​អុច​អ៝ន់​ឞូ​ជាន​មា​ខាន់​អៃ​មៃ អ៝ន់​ខាន់​អៃ​មៃ​ជាន​មា​ឞូ​ល៝រ។ នាវ​អី​នៃ​ជេង​តឹម​ទី​ដាស​នាវ​វៃ នទ្រែល​មា​នាវ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​លែៈ​ញចីស។ ");
INSERT INTO cmok_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","អ៝ន់​ខាន់​អៃ​មៃ​លាប់​រ៝ៈ​មពោង​មពេរ​ហ្វេត យ៝រ​លាស​មពោង​មពេរ​អី​ហាន់​តា​នាវ​រ៝ស​ហេង​ហ្វី នទ្រែល​មា​ត្រ៝ង​អី​ញជុន​តា​នាវ​រ៝ស​ហេង​ទើស​ងាន់​មា​ហាន់ គែស​អ៝ក់​ឞូនុយ្ស​លាប់​រ៝ៈ​មពោង​មពេរ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","យើន​មា​មពោង​មពេរ​អី​ហាន់​តា​នាវ​រេស​នហ៝​រ៝​ហ្វេត នទ្រែល​មា​ត្រ៝ង​អី​ញជុន​តា​នាវ​រេស​នហ៝​រ៝​ជេរ​មា​ហាន់ គែស​ដេៈ​ទើម​ឞូនុយ្ស​ជ៝យ​ឆៃ​ត្រ៝ង​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​ហ៝ម់​មា​ឞូនុយ្ស​នតើយ្ស​ងក្លាៈ​នាវ​ងើយ​កោរាញ​ឞ្រាស។ ខាន់​ពាង់​វាច់​អា​ខាន់​អៃ​មៃ​មលែស អ្វាញ់​តឹម​ឞាន​មា​ឞែ​ឞ្យាប់ យើន​មា​តា​ត្រោម​នូយ្ស​នហ៝ម់​ខាន់​ពាង់​រី​ជាញ​តឹម​ឞាន​មា​ឆ៝​ឞ្រី​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ខាន់​អៃ​មៃ​គឹត​នាល់​ខាន់​ពាង់​តាៈ​ឞើស​នទើ​ខាន់​ពាង់​ជាន តឹម​ឞាន​មា​ឞូ​គឹត​នាល់​តើម​ឆី​តាៈ​ឞើស​ព្លៃ​ពាង់។ ឞូ​មោ​ព្រ៝ត​អោស​ពែៈ​ព្លៃ​យុងយារ​ប៝ន មោ​លាស​ពែៈ​ព្លៃ​រាវី ​តាៈ​ឞើស​ពុម​ល៝ក​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","លាស​នទ្រី​ទឹង​លែៈ​តើម​ឆី​អ្វែស ព្លៃ​ពាង់​អ្វែស យើន​មា​តើម​ឆី​អ្យើស ព្លៃ​ពាង់​អ្យើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","មោ​ព្រ៝ត​គែស​អោស​លាស​តើម​អ្វែស​អី​ព្លៃ​អ្យើស តើម​អ្យើស​អី​ព្លៃ​អ្វែស។ ");
INSERT INTO cmok_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ទឹង​លែៈ​តើម​ឆី​ព្លៃ​មោ​អ្វែស ឞូ​កាល់​ពូរ​លើយ​តា​អុញ។ ");
INSERT INTO cmok_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","លាស​នទ្រី​ទឹង​ខាន់​អៃ​មៃ​ទើយ​គឹត​នាល់​ឞូនុយ្ស​នតើយ្ស​ងក្លាៈ យ៝រ​មា​ឆៃ​នទើ​ពាង់​ជាន”។ ");
INSERT INTO cmok_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ឞូនុយ្ស​ទើយ​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ មោ​ទើន​ក្វាល់​គ៝ប់ «អើ​កោរាញ អើ​កោរាញ»​ទើម​អោស។ ពាង់​អី​ជាន​តឹង​កោរាញ​ឞ្រាស​ឞឹ​គ៝ប់​គុ​តា​កាលើ​ត្រោក​អុច ពាង់​អី​នៃ​ទើម​ទើយ​លាប់។ ");
INSERT INTO cmok_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","តា​នារ​ផាត​ទោយ្ស​ទឹង​លែៈ​ឞូនុយ្ស មរា​គែស​អ៝ក់​ឞូនុយ្ស​លាស​មា​គ៝ប់៖ «អើ​កោរាញ អើ​កោរាញ ហេន​វៃ​នតើយ្ស​នាវ​ងើយ​មៃ ហេន​វៃ​មព្រើស​ឞ្រាស​អ្យើស​មា​រាញា​ឆាក់​មៃ នទ្រែល​មា​អ៝ក់​ងាន់​ហេន​ជាន​នាវ​ខ្លៃ​មា​រាញា​ឆាក់​មៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","យើន​មា​តា​នោក​នារ​នៃ​តៃ គ៝ប់​លាស​មា​ឞូនុយ្ស​អី​នៃ៖ «អើ​ផូង​ក្វែ​ផូង​អ្យើស ទូ​ងាយ​ហ៝ម់​ឞើស​គ៝ប់គ៝ប់​មោ​អោស​គឹត​នាល់​ខាន់​អៃ​មៃ»”។ ");
INSERT INTO cmok_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ឞូ​ម៝ស​តាង់​នាវ​គ៝ប់​ងើយ​អ្យា ជេសរី​ជាន​តឹង​កើត ពាង់​អី​នៃ​ជេង​តឹម​ឞាន​មា​ឞូនុយ្ស​ឞ្លាវ​មឹន​ជាន​ជៃ​ពាង់​នើម​តាម់​មែស​កុយ្ស​នតូ​អ៝ន់​ជ្រូ។ ");
INSERT INTO cmok_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ឞ៝ល​លាស​គែស​មីស​ក្វ៝ង់ គែស​ទាក​ក្វ៝ង់​រាលាប​ហ៝ច នទ្រែល​មា​គែស​ឆ្យាល​ខោម​អ៝ន់​ងគើ​កាដោយ​ដ៝ង់ ជៃ​អី​នៃ​មោ​អោស​ទើយ​រាល៝ម់ យ៝រ​លាស​មែស​ពាង់​លែៈ​ឞូ​តាម់​អ៝ន់​ន៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","យើន​មា​ឞូ​ម៝ស​លែៈ​តាង់​ជេស​នាវ​គ៝ប់​ងើយ​អ្យា តីស​មា​មោ​អោស​ជាន​តឹង​កើត ពាង់​អី​នៃ​ជេង​តឹម​ឞាន​មា​ឞូនុយ្ស​ម៝ល់​ជាន​ជៃ​ពាង់​នើម​ងគ៝ន់​ទើម​តា​កាលើ​នែស។ ");
INSERT INTO cmok_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","លាស​គែស​មីស​ក្វ៝ង់ គែស​ទាក​រាលាប​ហ៝ច នទ្រែល​មា​គែស​ឆ្យាល​ខោម​អ៝ន់​ងគើ​កាដោយ​ដ៝ង់ ជៃ​អី​នៃ​រាល៝ម់​អ្យើស​លែៈ​ផ្យៅ​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ត៝ត់​មា​លែៈ​ជេស​ឞ្រាស​យេឆូ ​ងើយ​ទឹង​លែៈ​នាវ​អី​នៃ ផូង​ប៝ន​លាន​គុ​អ្យាត់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់​តាង់​នាវ​ពាង់​នតី​អី​នៃ‌ ");
INSERT INTO cmok_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","យ៝រ​លាស​នាវ​ពាង់​នតី​នើស​គែស​នាវ​ទើយ​ងាន់ មោ​គែស​អោស​កើត​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","នោក​ឞ្រាស​យេឆូ ​ជុរ​ឞើស​កាលើ​យោក​នៃ គែស​អ៝ក់​ឞូនុយ្ស​តឹង​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","តា​នៃ​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ផុង​ឆា​ច៝ន​កោម៝ក់​តា​នាប់​ឞ្រាស​យេឆូ  ពាង់​លាស៖ “អើ​កោរាញ! គ៝ប់​គឹត​មៃ​ទើយ​ជាន​ឆាក់​គ៝ប់​អ៝ន់​ក្ល៝ស​អ៝ន់​ឞាស​ជី លាស​មៃ​អុច”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ឞ្រាស​យេឆូ ​ពាស​តី​តា​ឆាក់​ពាង់​រី ជេសរី​លាស​មា​ឞូនុយ្ស​ផុង​ឆា​អី​នៃ៖ “អើ គ៝ប់​អុច​ដ៝ង់ ឞាស​ហ៝ម់!” ទូ​ប្ល៝ត់​តា​នៃ​ពាង់​ឞាស​រ៝ មោ​ហោម​ផុង​ឆា​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “មៃ​លើយ​អោស​មឞើស​ងក៝ច​នាវ​អី​អ្យា​អ៝ន់​ឞូ​គឹត អ៝ន់​មៃ​ហាន់​ឞ្រ៝ង់​ញហើ​ឆាក់​មា​ឞូនុយ្ស​ជាន​ឞ្រាស​រី ជេសរី​ញហើរ​នទើ​ជាន​ឞ្រាស​តឹង​នាវ​វៃ​មោឆេ ​ដាៈ​មា​ឞូនុយ្ស​ឞាស​នាវ​ជី​ផុង​ឆា គៃ​មា​ឞូ​គឹត​នហេល​ឆាក់​មៃ​លែៈ​ក្ល៝ស​លែៈ​ឞាស​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ត៝ត់​ឞ្រាស​យេឆូ ​ហាន់​លាប់​តា​ប៝ន​កាពើនិម  គែស​ទូ​ហ្វេ​កោរាញ​តាហែន​រោម ​ហាន់​ឞ៝ញ​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“អើ​កោរាញ គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ជាន​ការ​មា​គ៝ប់​ឞិច​រាខ្វែន​តា​គ្រែ​រី ពាង់​ជី​រាវែន​គែស​នាវ​ជេរ​ទុត​ហោ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ហោៈ​គ៝ប់​ហាន់​ជាន​អ៝ន់​ពាង់​ឞាស”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","កោរាញ​តាហែន​អី​នៃ​លាស​មា​ឞ្រាស​យេឆូ ៖ “អើ​កោរាញ មោ​ខាច់​អោស​ជាៈ​លែវ​មៃ​លាប់​តា​ជៃ​គ៝ប់ យ៝រ​លាស​គ៝ប់​មោ​ទី​ផូង​អីឆ្រាអែល  នទ្រី​ទឹង​មោ​អោស​ទី លាស​គ៝ប់​ជាៈ​មៃ​លាប់​តា​ជៃ​គ៝ប់ ទាន់​មៃ​លាស​ទូ​ត៝ង​ឞើស​នៃ​ទើម ឞូនុយ្ស​ជាន​ការ​មា​គ៝ប់​ឞាស​ជី​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","គ៝ប់​គុ​តា​ន៝ម់​ឞូ យើន​មា​គែស​អ៝ក់​ក៝ន​តាហែន​គុ​តា​ន៝ម់​គ៝ប់​ដ៝ង់។ លាស​គ៝ប់​ដាៈ​ទូ​ហ្វេ​ហាន់ ពាង់​ហាន់​រ៝ លាស​ដាៈ​ឞូនុយ្ស​អា​អេង​វាច់ ពាង់​វាច់​រ៝។ លាស​គ៝ប់​ដាៈ​ទឹក​គ៝ប់​ជាន​នទើ​ទូ​នតីល ពាង់​ជាន​រ៝។ លាស​នទ្រី​គ៝ប់​គឹត​លាស​មៃ​ងើយ​គែស​នាវ​ទើយ​កើត​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ត៝ត់​មា​ឞ្រាស​យេឆូ ​លែៈ​តាង់​នាវ​នៃ តា​នូយ្ស​នហ៝ម់​ពាង់​រី​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់ ពាង់​លាស​មា​ផូង​តឹង​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ តា​ផូង​អីឆ្រាអែល ​អី​កើប​អេង​ឆាក់​ខាន់​ពាង់​នើម​លាស​លែៈ​គឹត​នាល់​កោរាញ​ឞ្រាស អេ​ហ៝ៈ​ឆៃ​គែស​ទូ​ហ្វេ​គែស​នាវ​ញឆីង​កើត​ពាង់​អី​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ មរា​គែស​អ៝ក់​ឞូនុយ្ស​តាៈ​ឞើស​លោស​នារ នទ្រែល​មា​តាៈ​ឞើស​ញ៝ប់​នារ ខាន់​ពាង់​អី​មោ​អោស​ទី​ផូង​អីឆ្រាអែល  តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ វាច់​គូម​ឆោង​ឆា​នទ្រែល​អាឞ្រាហាម់ អីឆាក់  នទ្រែល​មា​យាកោប ​អី​ចែ​ផូង​ឞ៝ន់។ ");
INSERT INTO cmok_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","យើន​មា​ផូង​អីឆ្រាអែល ​អី​អើម​ទី​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ គែស​អ៝ក់​ឞូ​មអារ់​លើយ​ខាន់​ពាង់​ឞើស​ទីស​តា​នតុក​ង៝ តា​នតុក​នៃ​គែស​នាវ​ញហ្យាង់​ញុម នទ្រែល​មា​រាច្យាត់​ឆេក”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​កោរាញ​តាហែន​រោម ​អី​នៃ៖ “មៃ​ហាន់​ឆឹត​ទោ អ៝ន់​គែស​កើត​នាវ​ញឆីង​មៃ​នៃ​ងាន់”។ ឞូនុយ្ស​ជាន​ការ​មា​ពាង់​ឞាស​នាវ​ជី​ម៝ង​នៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​លាប់​តា​ជៃ​ពេត្រោស ពាង់​ឆៃ​មេៈ​ព៝​ពេត្រោស ​ជី​ក៝ប​ឞិច​តា​គ្រែ​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ឞ្រាស​យេឆូ ​ពាស​តា​តី​ពាង់ ពាង់​ឞាស​រ៝ ជេសរី​ពាង់​ជាន​ព្យាង់​ត្រាវ​មា​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ត៝ត់​ឞ្រី​កេង​មាង់​ឞូ​ញជុន​ឞូនុយ្ស​ឞ្រាស​អ្យើស​លាប់​អ៝ក់​ហាន់​អា​ឞ្រាស​យេឆូ ។ ពាង់​មព្រើស​ឞ្រាស​អ្យើស​អី​នៃ​មា​នាវ​ពាង់​ងើយ នទ្រែល​មា​ជាន​ឞាស​ឞូនុយ្ស​ជី​ក្វែត​អ៝ន់​ឞាស​ទាទេ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ពាង់​ជាន​កើត​នៃ គៃ​មា​តឹម​ទី​ដាស​នាវ​អេឆាយ ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ញចីស​ជេស៖ «ពាង់​អី​នៃ​លែៈ​ឆ៝ៈ​ទើន​ទឹង​លែៈ​នាវ​ក្វែត​រាវែន​ឞ៝ន់​តា​ពាង់​នើម នាវ​ជី​ឞ៝ន់​ពាង់​តូយ​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ត៝ត់​ឞ្រាស​យេឆូ ​ឆៃ​ឞូ​គុ​ជុម​ពាង់​អ៝ក់​ង៝​ងាន់ ពាង់​ដាៈ​មពោល​អ៝ស​ម៝ន​គៃ​មា​ញច៝​ទូក​ហាន់​កាល់​តី​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ ។ ");
INSERT INTO cmok_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","នោក​នៃ​គែស​ទូ​ហ្វេ​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​លាស​មា​ឞ្រាស​យេឆូ ៖ “អើ​កោរាញ អាស​នតុក​មៃ​ហាន់ គ៝ប់​ហាន់​តឹង​មៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ល៝ង់​ឆ្រ៝ត​គែស​ត្រោម​នតុក​ពាង់​គុ ឆ្យុម​នារ​គែស​រាឆ្វាន់​ដ៝ង់ តីស​មា​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​មោ​គែស​អោស​នតុក​គ៝ប់​នើម​ងាន់​មា​ទ៝ម់​ឞោក”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","គែស​ទូ​ហ្វេ​តា​មពោល​អ៝ស​ម៝ន​ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “អើ​កោរាញ អ៝ន់​គ៝ប់​ក៝ប់​ឞឹ​គ៝ប់​ខឹត នទ្រែល​មា​ត៝ប់​ពាង់​ប៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ហាន់​តឹង​គ៝ប់​អាបៃ​រី​ហ៝ម់។ ឞូនុយ្ស​មោ​អ្យាត់​នាវ​គ៝ប់​តឹម​ឞាន​មា​ឞូនុយ្ស​លែៈ​ខឹត អ៝ន់​ខាន់​ពាង់​តឹម​ត៝ប់​អេង​នទ្រាង់​ខាន់​ពាង់​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ជេសរី​ឞ្រាស​យេឆូ ​ជុរ​ញច៝​ទូក ផូង​អ៝ស​ម៝ន​ពាង់​ញច៝​នទ្រែល​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ទោ​មា​គែស​ឆ្យាល​ផុត​ទុត​ហោ​ត៝ត់​មា​ទាក​រាឞុស​លាប់​តា​ត្រោម​ទូក​រី។ យើន​មា​ឞ្រាស​យេឆូ ​លែៈ​ហាក់​ឞិច។ ");
INSERT INTO cmok_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ផូង​អ៝ស​ម៝ន​រាលៃ​ពាង់៖ “អើ​កោរាញ! កើល​រាក្លាយ្ស​ហ៝ម់​ហេន ខឹត​រ៝​ឞ៝ន់​មេ!” ");
INSERT INTO cmok_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “អើ​ផូង​គែស​នាវ​ញឆីង​ដេៈ​ទើម ម៝ស​នាវ​ខាន់​មៃ​ក្លាច​ហោ​អីរ?” ឞ្រាស​យេឆូ ​ទ៝ក់ ពាង់​ឞ្វៃ​ឆ្យាល​ផុត នទ្រែល​មា​ទាក ទាក​ញច៝ច់​រាឞុស​រាង៝ន់​ញជុប​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","នោក​នៃ​ផូង​អ៝ស​ម៝ន​នទ្រ៝ត់​ហីស​រាហ៝ល់ ខាន់​ពាង់​តឹម​លាស៖ “ហៃ ឞូ​ម៝ស​ពាង់​អី​នៃ​ហ្យាស ទឹង​គែស​មា​ឆ្យាល​ផុត នទ្រែល​មា​ទាក​ញច៝ច់​អ្យាត់​ពាង់?” ");
INSERT INTO cmok_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","នោក​ឞ្រាស​យេឆូ  នទ្រែល​មា​ផូង​អ៝ស​ម៝ន​ពាង់​ត៝ត់​កាល់​តី​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ ​តា​ឞ្រី​កេរាឆីន  នតុក​ប៝ន​អី​នៃ​ឞូ​មោ​អោស​តឹង​នាវ​វៃ​ផូង​អីឆ្រាអែល  តា​នៃ​គែស​ឞារ​ហៃ​ឞូ​ក្លោ​ឞ្រាស​អ្យើស​លាប់។ ខាន់​ពាង់​លោស​ឞើស​នតុក​មោច​រី ហាន់​រាន​អា​ឞ្រាស​យេឆូ ។ ឞារ​ហៃ​ឞូ​ក្លោ​អី​នៃ​ជាញៗ​ងាន់ កើត​នទ្រី​ទឹង​ឞូ​មោ​ឞាញ់​ហាន់​រ៝ៈ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ឞារ​ហៃ​ឞូ​ក្លោ​អី​នៃ​នតែរ​លាស​ឞ្រាស​យេឆូ ៖ “អើ​ក៝ន​កោរាញ​ឞ្រាស ម៝ស​គែស​នាវ​មៃ​មា​ហេន​ហាៈ? មៃ​ហាន់​តា​អ្យា​គៃ​មា​អុច​ងក្រីត​ហេន​អេ​ល៝រ​មា​ត៝ត់​ទី​នារ​កោរាញ​ឞ្រាស​លែៈ​នទ្រាប់​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ងាយ​អ៝យ​ដាស​មពោល​ខាន់​ពាង់​អី​នៃ គែស​ឆុរ​ផូង​គុ​ឆា​មពា​តា​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ផូង​ឞ្រាស​អ្យើស​អី​នៃ​ឞ៝ញ​ឞ្រាស​យេឆូ ៖ “អើ​កោរាញ លាស​មៃ​មព្រើស​ហេន ទាន់​មៃ​ញជ្វាល់​ហេន​លាប់​តា​ឆុរ​ផូង​អី​នៃ​អើ”។ ");
INSERT INTO cmok_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ឞ្រាស​យេឆូ ​លាស៖ “ហាន់​ហ៝ម់!” ជេសរី​ផូង​ឞ្រាស​អ្យើស​លោស​ឞើស​ឞារ​ហៃ​ឞូ​ក្លោ​អី​នៃ​លាប់​តា​ឆុរ​រី។ ល៝ង់​ឆុរ​ផូង​អី​រី​ញច្វាត់​រាឞុល​ជឹត​ឆ៝ប​រាប៝ង់​ជឹត​ទាក​ងលៅ​ក្វ៝ង់​ខឹត​រាម៝ក​តា​ទាក​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","មពោល​ម៝ត់​ឆុរ​អី​នៃ​លែវ​ឞាល់​ញច្វាត់​អា​ប៝ន មឞើស​ងក៝ច​ទឹង​លែៈ​នាវ​អី​នៃ នអ៝ប់​មា​មឞើស​ងក៝ច​មា​ឞារ​ហៃ​ឞូនុយ្ស​ឞ្រាស​អ្យើស​លាប់​នៃ​នើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ទឹង​លែៈ​ឞូនុយ្ស​តា​ប៝ន​នៃ​រាន​ហាន់​ម៝ប់​ឞ្រាស​យេឆូ ​ទាទេ ត៝ត់​មា​លែៈ​ឆៃ​ឞ្រាស​យេឆូ  ខាន់​ពាង់​ឞ៝ញ​ឞ្រាស​យេឆូ ​អ៝ន់​ពាង់​លោស​ឞើស​ឞ្រី​ខាន់​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ជេសរី​ឞ្រាស​យេឆូ ​ញច៝​ទូក​ព្លឹ​ឆឹត​តា​ប៝ន​កាពើនិម ​នតុក​ប៝ន​ពាង់​គុ។ ");
INSERT INTO cmok_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","តា​នៃ​គែស​ឞូ​តូង​ទូ​ហ្វេ​ឞូនុយ្ស​រាវែន​ជ៝ង់​រាវែន​តី​ឞិច​តា​ងក៝ៈ​ហាន់​តា​ឞ្រាស​យេឆូ ។ ពាង់​ឆៃ​ខាន់​ពាង់​គែស​នាវ​ញឆីង ជេសរី​លាស​មា​ឞូនុយ្ស​រាវែន​អី​នៃ៖ “អើ​អ៝ស អ៝ន់​មៃ​រាម់​ហ៝ម់។ គ៝ប់​លែៈ​យោៈ​មៃ មោ​ហោម​អោស​កើប​នាវ​តីស​តា​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","តា​នៃ​គែស​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​អាបាៈ​លាស​អេង​តា​នូយ្ស​នហ៝ម់​ខាន់​ពាង់​នើម៖ “មើម​ពាង់​ងើយ​កើត​នៃ ពាង់​អី​នៃ​មឺច​រាម៝ត​កោរាញ​ឞ្រាស​ងាន់​ហៃ!” ");
INSERT INTO cmok_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ឞ្រាស​យេឆូ ​លែៈ​ឆៃ​នាវ​មឹន​ផូង​អី​នៃ ពាង់​លាស៖ “មើម​ទឹង​ខាន់​មៃ​គែស​នាវ​មឹន​អ្យើស​កើត​នៃ? ");
INSERT INTO cmok_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","អ៝ន់​ខាន់​មៃ​គឹត​នាវ​អ្យា លាស​គ៝ប់​លាស​មា​ឞូនុយ្ស​រាវែន​អី​នៃ៖ «នាវ​តីស​មៃ​លែៈ​គ៝ប់​យោៈ​ហើយ» មោ​លាស «មៃ​ទ៝ក់​ឞ្រោៈ​ហ៝ម់» លាស​នទ្រី​ម៝ស​នាវ​លាស​អី​ទើស​រាលាវ​ហាៈ? ");
INSERT INTO cmok_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","គ៝ប់​អុច​អ៝ន់​ខាន់​មៃ​គឹត​ឆៃ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទើយ​យោៈ​នាវ​តីស​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា”។ ជេសរី​ឞ្រាស​យេឆូ ​អ្វាញ់​ជឹត​ឞូនុយ្ស​រាវែន​អី​នៃ​លាស៖ “មៃ​ទ៝ក់​ហ៝ម់ ញអោត​ងក៝ៈ​មៃ​នៃ​ឆឹត​អា​ជៃ​មៃ​នើម​រី”។ ");
INSERT INTO cmok_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ជេសរី​ឞូនុយ្ស​រាវែន​អី​នៃ​ទ៝ក់​រ៝ ឆឹត​អា​ជៃ​ពាង់​នើម​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ឆៃ​កើត​នៃ ផូង​ប៝ន​លាន​នទ្រ៝ត់​ហីស​រាហ៝ល់​ទាទេ ខាន់​ពាង់​រានេ​កោរាញ​ឞ្រាស យ៝រ​លាស​លែៈ​ពាង់​អ៝ន់​នាវ​ទើយ​កើត​នៃ​មា​ឞូនុយ្ស​តា​នែស​នតូ។ ");
INSERT INTO cmok_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​ឞើស​នតុក​នៃ ពាង់​ឆៃ​មាថាយ ​គុ​ក៝ប់​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់។ ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ហើយ​នោ ហោៈ​ឞ្រោៈ​តឹង​គ៝ប់”។ ពាង់​ទ៝ក់​ឞើស​នៃ ជេសរី​តឹង​ឞ្រាស​យេឆូ ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","តា​នារ​នៃ​មាថាយ ​ជាៈ​ឞ្រាស​យេឆូ ​ឆោង​ឆា​តា​ជៃ​ពាង់​នើម។ គែស​អ៝ក់​ផូង​ឞូនុយ្ស​ក៝ប់​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ នអ៝ប់​មា​ផូង​ឞូនុយ្ស​ជាន​តីស​អេង​ហាន់​គុ​ឆោង​ឆា​នទ្រែល​ឞ្រាស​យេឆូ  នទ្រែល​មា​ផូង​អ៝ស​ម៝ន​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ត៝ត់​មា​ផូង​ផារីឆី ​ឆៃ​កើត​នៃ ខាន់​ពាង់​អោប​ផូង​អ៝ស​ម៝ន​ឞ្រាស​យេឆូ ៖ “មើម​ទឹង​កោរាញ​ខាន់​មៃ​គុ​ឆោង​ឆា​នទ្រែល​ឞូនុយ្ស​ក៝ប់​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន នអ៝ប់​មា​ផូង​ឞូនុយ្ស​ជាន​តីស​អេង​កើត​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ឞ្រាស​យេឆូ ​តាង់​កើត​នៃ ជេសរី​អោប​ខាន់​ពាង់៖ “ឞូនុយ្ស​គែស​ឆាក់​ជាន់​អ្វែស​មោ​អុច​អោស​មា​កោរាញ​ទាក​ឆី ឞូនុយ្ស​អី​គែស​នាវ​ជី​ទើម​អុច។ ");
INSERT INTO cmok_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","អ៝ន់​ខាន់​មៃ​វ៝ត់​តា​ត្រ៝ង​លែៈ​ញចីស​កើត​នអា៖ «គ៝ប់​អុច​ឞូនុយ្ស​ឞ្លាវ​យោៈ​នអាច មោ​អុច​អោស​មា​នទើ​ជាន​ឞ្រាស»។ គ៝ប់​វាច់​តា​អ្យា​មោ​អោស​គៃ​មា​ក្វាល់​ឞូនុយ្ស​ឆ៝ង់ អុច​ក្វាល់​ឞូនុយ្ស​តីស គៃ​មា​កើល​ខាន់​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","នោក​នៃ​គែស​មពោល​អ៝ស​ម៝ន​យោហាន-​បាប់តែម ​ហាន់​ម៝ប់​ឞ្រាស​យេឆូ  អោប​ពាង់៖ “ហេន នទ្រែល​មា​ផូង​ផារីឆី ​គែស​នាវ​វៃ​អ៝ត់​ឆោង​ឆា​អ៝ក់​នារ​គៃ​មា​មឞើស​ឆើម មើម​ទឹង​មពោល​អ៝ស​ម៝ន​មៃ​មោ​ជាន​កើត​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “នោក​តឹម​នអាប់​អូរ​ឆាយ ឞូ​នាច់​វៃ​គុ​រាង៝ត​អ៝ត់​ឆោង​ឆា​ដ៝ង់​ឞើស? មោ​វៃ​អោស។ គ៝ប់​តឹម​ឞាន​មា​ឞូ​ក្លោ​នអាប់​អូរ​ឆាយ។ ត៝ត់​ទី​នារ​រី​តៃ​ឞូ​តឹម​ងខាស​គ៝ប់​ដាស​មពោល​អ៝ស​ម៝ន​គ៝ប់ រី​មើ​ខាន់​ពាង់​អ៝ត់​ឆោង​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ឞូ​មោ​វៃ​អោស​ឆ៝ៈ​ឞ៝ក​មហែ​អេ​ហ៝ៈ​ពីស​មឞោល​តា​អាវ​លែៈ​ឆាត។ លាស​ជាន​កើត​នៃ​ឞ៝ក​អី​ឆាត​រី​លើ​មា​ហោ​ហេក​រាលាវ​អើម​ងាន់ យ៝រ​មា​អី​ឞ៝ក​មហែ​នៃ​ជេង​រោត​នោក​ជេស​ពីស។ ");
INSERT INTO cmok_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","កើត​នទ្រី​ដ៝ង់ ឞូ​មោ​វៃ​អោស​តេៈ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មហែ​តា​ទុង​នតោ​អើម លាស​ជាន​កើត​នៃ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មហែ​ជាន​អ៝ន់​ទុង​នតោ​អី​នៃ​ព្រែក នទ្រាញ់​ហុក​ដ៝ង់ ជេសរី​ទុង​នតោ​អី​នៃ​ជេង​ឆាត​ដ៝ង់ យ៝រ​លាស​ទុង​នតោ​អើម​មោ​ហោម​អោស​ត៝ច។ ឞូ​តេៈ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មហែ​តា​ទុង​នតោ​មហែ នទ្រី​នទើ​ឞារ​អឹ​នៃ​ហោម”។ ");
INSERT INTO cmok_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","នោក​ឞ្រាស​យេឆូ ​ហោម​ងើយ​នាវ​អី​នៃ ទោ​មា​គែស​ទូ​ហ្វេ​កោរាញ​ញីស​រាបុន​ផូង​អីឆ្រាអែល ​ហាន់​ច៝ន​កោម៝ក់​ឞើស​នាប់​ឞ្រាស​យេឆូ  លាស​មា​ពាង់៖ “ក៝ន​ឞូ​អូរ​គ៝ប់​មហែ​ខឹត​នទើស​នើស​ពើ។ ទាន់​មៃ​ហាន់​ពាស​តី​តា​ពាង់​អើ ជេសរី​ពាង់​ទ៝ក់​រេស​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ឞ្រាស​យេឆូ ​ទ៝ក់​ហាន់​នទ្រែល​ពាង់ មពោល​អ៝ស​ម៝ន​ឞ្រាស​យេឆូ ​ហាន់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","រ៝ៈ​ត្រ៝ង​នៃ​គែស​ទូ​ហ្វេ​ឞូ​អូរ​ជី​រីស​លែៈ​ជ៝ៈ ១២ នាម់ ពាង់​លាស​អេង​តា​ឆាក់​ពាង់​នើម៖ “លាស​គែស​ពាស​អាវ​ពាង់​អី​នៃ គ៝ប់​ឞាស​រ៝”។ ជេសរី​ពាង់​តឹង​ឞ្រាស​យេឆូ ​ឞើស​កើយ ពាស​តា​ច្យាង់​អាវ​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ឞ្រាស​យេឆូ ​ងគឹល​ជឹត​កើយ ឆៃ​ឞូ​អូរ​អី​នៃ ជេសរី​លាស​មា​ពាង់៖ “អៃ​រាម់​ហ៝ម់​អើ​អ៝ស នាវ​អៃ​ញឆីង​ជាន​ឞាស​អៃ​ហើយ”។ នាវ​ជី​រីស​ពាង់​ឞាស​តា​នៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ជេសរី​ឞ្រាស​យេឆូ ​ត៝ត់​តា​ជៃ​កោរាញ​ញីស​រាបុន​នៃ ពាង់​ឆៃ​ផូង​គែស​នាវ​រាង៝ត​អោស​នហោម​អោស​រាលែត​គ្រុ​គ្រាៈ​យាៈ​យ៝រ់​ងាន់ ");
INSERT INTO cmok_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ពាង់​លាស​មា​ផូង​អី​នៃ៖ “ខាន់​អៃ​មៃ​ទូ​លោស​អា​ទីស! មោ​ខឹត​អោស​ក៝ន​ឆែ​ឞូ​អូរ​អ្យា មាន​មា​ហាក់​ឞិច​ទើម”។ ទឹង​លែៈ​ឞូ​តា​នៃ​គើម​មឺច​មា​ឞ្រាស​យេឆូ ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ត៝ត់​លោស​លែៈ​ផ្យៅ​ផូង​អី​នៃ​អា​ទីស ឞ្រាស​យេឆូ ​លាប់​តា​ត្រោម​ជៃ ញុប​តី​ក៝ន​ឆែ​ឞូ​អូរ​អី​នៃ ជេសរី​ក៝ន​ឆែ​អី​នៃ​ទ៝ក់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ជេសរី​នាវ​អី​នៃ​លឺ​លាម​ឞ្រី​អី​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","នោក​ឞ្រាស​យេឆូ ​ហាន់​ឞើស​នតុក​នៃ គែស​ឞារ​ហៃ​ឞូនុយ្ស​ចែស​មាត់​តឹង​ឞើស​កើយ​ឞ្រាស​យេឆូ  ខាន់​ពាង់​នតែរ៖ “អើ​ក៝ន​ឆៅ​កាដាច់​ដាវីត ! យោៈ​នអាច​ហេន​បាៈ​អើ!” ");
INSERT INTO cmok_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ត៝ត់​ឞ្រាស​យេឆូ ​លែៈ​លាប់​ទូ​មល៝ម់​ជៃ ឞារ​ហៃ​ឞូនុយ្ស​ចែស​មាត់​នៃ​ហាន់​អា​ពាង់។ ជេសរី​ឞ្រាស​យេឆូ ​អោប​ខាន់​ពាង់៖ “អាស​ខាន់​មៃ​លែៈ​ញឆីង​មា​គ៝ប់​ដ៝ង់ គ៝ប់​ទើយ​ជាន​ត្រោម​មាត់​ខាន់​មៃ​អ៝ន់​ឆៃ​អាង?” ខាន់​ពាង់​អើស៖ “អើ ហេន​លែៈ​ញឆីង កោរាញ”។ ");
INSERT INTO cmok_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ជេសរី​ឞ្រាស​យេឆូ ​ពាស​តា​ត្រោម​មាត់​ខាន់​ពាង់​រី​លាស៖ “អ៝ន់​គែស​ងាន់ កើត​នាវ​ខាន់​មៃ​លែៈ​ញឆីង”។ ");
INSERT INTO cmok_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ជេសរី​ត្រោម​មាត់​ខាន់​ពាង់​ឆៃ​អាង​ងាន់​រ៝។ ឞ្រាស​យេឆូ ​ឞ្វៃ​ទាង់​ងាន់​មា​ខាន់​ពាង់៖ “លើយ​អោស​អ៝ន់​ឞូ​គឹត​នាវ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","យើន​មា​ឞារ​ហៃ​ខាន់​ពាង់​អី​នៃ ហាន់​មឞើស​ងក៝ច​នាវ​នៃ​មា​ឞូ​លាម​ឞ្រី​នៃ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","នទុត​ឆឹត​ឞារ​ហៃ​ខាន់​ពាង់​នៃ គែស​ឞូ​លែវ​ទូ​ហ្វេ​ឞូនុយ្ស​មល៝​ឞ្រាស​អ្យើស​លាប់​ហាន់​អា​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ត៝ត់​ឞ្រាស​យេឆូ ​លែៈ​មព្រើស​ឞ្រាស​អ្យើស​លែៈ​ទូ​លោស​ឞើស​ឞូនុយ្ស​មល៝​អី​នៃ ឞូនុយ្ស​អី​នៃ​ឞ្លាវ​ងើយ​រ៝។ ល៝ង់​ផូង​ប៝ន​លាន​អី​គុ​តា​រី​នទ្រ៝ត់​ហីស​រាហ៝ល់​លែៈ​នាវ​ងាន់ ខាន់​ពាង់​លាស៖ “នតើម​ឞើស​កាល់​អែ​នើស​មោ​អោស​ព្រ៝ត​ឆៃ​គែស​នាវ​ឞ្រាស​កើត​នៃ​តា​ឞ្រី​អីឆ្រាអែល ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","យើន​មា​ផូង​ផារីឆី ​លាស៖ “ទឹង​ពាង់​ទើយ​មព្រើស​ឞ្រាស​អ្យើស​នៃ អាច​មា​កោរាញ​មពោល​ឞ្រាស​អ្យើស​អ៝ន់​នាវ​ទើយ​តា​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​រ៝ៈ​ប៝ន​ក្វ៝ង់​ប៝ន​ជេៈ នតុម​នតី​ឞូ​តា​ញីស​រាបុន​ខាន់​ពាង់​នើម នទ្រែល​មា​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​មា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ នអ៝ប់​មា​ជាន​ឞាស​ទឹង​លែៈ​នាវ​ជី​អាប់​នតីល​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ត៝ត់​មា​ឆៃ​ផូង​ប៝ន​លាន ឞ្រាស​យេឆូ ​គែស​នាវ​យោៈ​នអាច​មា​ខាន់​ពាង់​ទុត​ហោ យ៝រ​លាស​ខាន់​ពាង់​រាវៃ​តា​នូយ្ស​នហ៝ម់​មោ​ហោម​គែស​ឆ្វាន តឹម​ឞាន​មា​ផូង​ឞែ​ឞ្យាប់​អី​មោ​គែស​ឞូនុយ្ស​ម៝ត់​អ្វាញ់។ ");
INSERT INTO cmok_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “ហើយ​អ៝ស​ម៝ន គែស​អ៝ក់​ឞូនុយ្ស​អុច​អ្យាត់​នាវ​មហែ​មហាន​អ្វែស ខាន់​ពាង់​តឹម​ឞាន​មា​ឞា​លែៈ​ទុម​អី​អ៝ក់​ងាន់។ ឞូនុយ្ស​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​តឹម​ឞាន​មា​ឞូនុយ្ស​រែក តីស​មា​ឞូនុយ្ស​អី​នៃ​ដេៈ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","លាស​នទ្រី​ទាន់​កោរាញ​ឞ្រាស​នើម​អី​តើម​ឞា​នៃ​ញជ្វាល់​ឞូនុយ្ស​អា​អេង​ជឹត កើល​រែក​ឞា​ទុម​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ជេសរី​ឞ្រាស​យេឆូ ​ក្វាល់ ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​ពាង់ នហ៝​មា​ពាង់​អ៝ន់​នាវ​ទើយ​មា​ខាន់​ពាង់ ទើយ​មព្រើស​ឞ្រាស​អ្យើស​លោស​ឞើស​ឞូនុយ្ស នទ្រែល​មា​ទើយ​ជាន​ឞាស​ទឹង​លែៈ​នាវ​ជី​អាប់​នតីល​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​នៃ តា​នៃ​គែស​ល៝រ​ឞូ ឆីមោន ​អី​ឞូ​ក្វាល់​ពេត្រោស ​ដ៝ង់ ជេសរី​គែស​អ៝ស​ពាង់​អ៝ន់ទ្រេ  គែស​យាកើ  នទ្រែល​មា​អ៝ស​ពាង់​យោហាន ​អី​ក៝ន​ឆេបេដេ ‌ ");
INSERT INTO cmok_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","គែស​ផីលីប  គែស​បារថោលោមេ  គែស​ថោមាស  គែស​មាថាយ ​អី​ឞូនុយ្ស​ក៝ប់​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ គែស​យាកើ ​អី​ក៝ន​អាល់ផាយ  គែស​ថាដេ ‌ ");
INSERT INTO cmok_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","គែស​ឆីមោន ​អី​ឞូនុយ្ស​ផូង​កានាអាន  នទ្រែល​មា​គែស​យូដាស-​អីឆាការីយោត ​ឞូនុយ្ស​អី​លែវ​ឞូ​ហាន់​ញុប​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ជេសរី​ឞ្រាស​យេឆូ ​ដាៈ ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​អី​នៃ​ហាន់​តា​ប៝ន​អេងៗ នហ៝​មា​នតិញ​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​លើយ​ហាន់​អោស​តា​ផូង​អី​មោ​ទី​ផូង​អីឆ្រាអែល  លើយ​អោស​លាប់​តា​ប៝ន​ឞ្រី​ឆាមារី ‌ ");
INSERT INTO cmok_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","យើន​មា​អ៝ន់​ខាន់​មៃ​ហាន់​តា​ផូង​អីឆ្រាអែល ​ទើម ខាន់​ពាង់​តឹម​ឞាន​មា​ផូង​ឞែ​ឞ្យាប់​លែៈ​ហ្យើត។ ");
INSERT INTO cmok_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","អ៝ន់​ខាន់​មៃ​មឞើស​ងក៝ច៖ «នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​លែៈ​ឞើយ​ត៝ត់»។ ");
INSERT INTO cmok_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","អ៝ន់​ខាន់​មៃ​ជាន​ឞាស​ឞូនុយ្ស​ជី​ក្វែត ឞូនុយ្ស​ខឹត​ជាន​អ៝ន់​ទ៝ក់​រេស ឞូនុយ្ស​ផុង​ឆា​ជាន​អ៝ន់​ឞាស​អ៝ន់​ក្ល៝ស នទ្រែល​មា​មព្រើស​ឞ្រាស​អ្យើស​អ៝ន់​ទូ​លោស​ឞើស​ឞូនុយ្ស។ លើយ​អោស​ឆ៝ៈ​ខ្លៃ​ឞើស​ឞូ យ៝រ​លាស​នាវ​ទើយ​ខាន់​មៃ​នើស​គែស​ទើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","មោ​អ៝ន់​អោស​ញអោត​ព្រាក់ ឞ៝ល​លាស​ដេៈ​កាដោយ​តា​ទុង​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","លើយ​ចែង​ទុង​ទោល​ខាន់​មៃ​ឞ្រោៈ​ប៝ន​អេងៗ លើយ​អោស​ញអោត​លែវ​ខ៝​អាវ​នតោ​ជ៝ត​អា​អេង​ជឹត​ទើន​អី​គែស​ញឆ៝ស​តា​ឆាក់​រី​ហ៝ៈ លើយ​ញអោត​ម៝ង់​ជ្រា។ យ៝រ​លាស​ទី​មា​ឞូនុយ្ស​អី​ជាន​ការ​មា​កោរាញ​ឞ្រាស​ឆ៝ៈ​ទើន​នទើ​អុច​តា​នាវ​រេស​ពាង់​តាៈ​ឞើស​ឞូនុយ្ស​អី​ពាង់​កើល​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","នោក​ខាន់​មៃ​លាប់​តា​ប៝ន​ក្វ៝ង់ មោ​លាស​ប៝ន​ជេៈ អ៝ន់​ខាន់​មៃ​ជ៝យ​ឞូនុយ្ស​អី​ទី​មា​ខាន់​មៃ​គុ​នទ្រែល ជេសរី​គុ​តា​ជៃ​ពាង់​នហ៝​មា​ត៝ត់​នារ​ខាន់​មៃ​លោស​ឞើស​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","នោក​ខាន់​មៃ​លាប់​តា​ជៃ​ឞូនុយ្ស​អី​នៃ អ៝ន់​ខាន់​មៃ​លាស៖ «អ៝ន់​គែស​នាវ​ដាប់​មពាន់​មា​ខាន់​អៃ​មៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","លាស​តា​ជៃ​អី​នៃ​ទី​ឆ៝ៈ​ទើន​នាវ​ដាប់​មពាន់​អី​នៃ កោរាញ​ឞ្រាស​មរា​អ៝ន់​កើត​នៃ​ងាន់​រ៝។ លាស​មោ​ទី​ឆ៝ៈ​ទើន កោរាញ​ឞ្រាស​មោ​អ៝ន់​អោស យើន​មា​ខាន់​មៃ​ហោម​គែស​នាវ​ដាប់​មពាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","លាស​ឞូ​មោ​អោស​រ៝ម​ខាន់​មៃ មោ​អ្យាត់​អោស​នាវ​ខាន់​មៃ នោក​ខាន់​មៃ​លោស​ឞើស​ប៝ន​ឞើស​ជៃ​នៃ អ៝ន់​រាតោស​នែស​មោយ​ឞើស​ជ៝ង់​ខាន់​មៃ​នើម គៃ​មា​ញហើ​លាស​ឞូនុយ្ស​អី​នៃ​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ ឞូនុយ្ស​តា​ឞ្រី​ប៝ន​ឆោដុម ​ប៝ន​កោមោរា  អី​ជាន​តីស​ទុត​ហោ​កាល់​អែ​នើស នទ្រី​ទឹង​កោរាញ​ឞ្រាស​ទែ​លើស​ហេង​ខាន់​ពាង់​មា​អុញ​ឞើស​កាលើ​ត្រោក ខាន់​ពាង់​អី​នៃ​ហោម​អែ​គែស​ទោយ្ស​ថើល​មា​ដាស​ឞូនុយ្ស​តា​ប៝ន​អី​នៃ តា​នារ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​លាម​នែស​នតូ”។ ");
INSERT INTO cmok_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“គ៝ប់​ដាៈ​ខាន់​មៃ​ហាន់​តា​ប៝ន​ផូង​អីឆ្រាអែល ​តឹម​ឞាន​មា​ដាៈ​ឞែ​ឞ្យាប់​គុ​តា​ងក្លាង​ផូង​ឆ៝​ឞ្រី។ លាស​នទ្រី​អ៝ន់​ខាន់​មៃ​ឞ្លាវ​ញជ្រាង់​តឹម​ឞាន​មា​ឞេស មលែស​តឹម​ឞាន​មា​ព្លុក​ជេង​ឆ្យុម​ទូ​នតីល​អី​មោ​ជាន​តីស។ ");
INSERT INTO cmok_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","អ៝ន់​ឞ្លាវ​ញជ្រាង់​មា​ឞូនុយ្ស យ៝រ​លាស​ឞូ​មរា​ញុប​ញជុន​ខាន់​មៃ​អ៝ន់​មា​មពោល​កោរាញ​ជាន​ការ​ផូង​អីឆ្រាអែល  ជេសរី​ឞូ​មរា​រាពាត់​ខាន់​មៃ​មា​ម៝ង់​រាឆែ​តា​ត្រោម​ញីស​រាបុន​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ឞូ​មរា​ញជុន​ខាន់​មៃ​អ៝ន់​មា​កោរាញ​ក្វ៝ង់ នទ្រែល​មា​ញជុន​ខាន់​មៃ​មា​កាដាច់ គៃ​មា​ផាត​ទោយ្ស​ខាន់​មៃ​អាច​មា​តឹង​គ៝ប់។ ជេសរី​ខាន់​មៃ​ទើយ​ងក៝ច​នាវ​ញឆីង​មា​គ៝ប់​អ៝ន់​មា​ខាន់​ពាង់ អ៝ន់​មា​ផូង​អី​មោ​ទី​ផូង​អីឆ្រាអែល ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","នោក​ឞូ​ញុប​ញជុន​ខាន់​មៃ លើយ​អោស​ខាន់​មៃ​រាវៃ​នាវ​មឞើស​ងើយ​មា​ឞូ យ៝រ​លាស​កោរាញ​ឞ្រាស​ឆើម​អ៝ន់​នាវ​មឞើស​ងើយ​មា​ខាន់​មៃ​តា​នោក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","មោ​ទី​ខាន់​មៃ​នើម​អោស​មឞើស​ងើយ ឞ្រាស​ហ្វេង​អ្វែស​អី​ហ្វេង​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​មៃ​នើម​ឆើម​ងើយ​អ៝ន់​មា​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","អ៝ស​មា​នោ ឞឹ​មា​ក៝ន​មរា​តឹម​រាលាម់​ញុប​ញជុន​អ៝ន់​ឞូ​ងខឹត នទ្រែល​មា​អី​ក៝នៗ​លែវ​ឞាល់​តឹម​រាទ៝ង់​ដាស​មេៈ​ឞឹ នហ៝​មា​ញជុន​អ៝ន់​ឞូ​ងខឹត​លើយ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","យ៝រ​មា​ខាន់​មៃ​ញឆីង​មា​គ៝ប់ នទ្រី​ទឹង​អ៝ក់​ឞូនុយ្ស​មរា​ឞ្យាញ់​មា​ខាន់​មៃ។ យើន​មា​ឞូ​ម៝ស​អី​ទើយ​អ៝ត់​នហ៝​មា​ត៝ត់​លោច កោរាញ​ឞ្រាស​មរា​រាក្លាយ្ស​ពាង់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","លាស​ឞូ​ជាន​ជេរ​ខាន់​មៃ​តា​ទូ​ប៝ន អ៝ន់​ខាន់​មៃ​ញច្វាត់​ទូ​តា​ប៝ន​អេង​ជឹត។ គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ ខាន់​មៃ​ហាន់​អេ​ហ៝ៈ​អោស​លាម​ប៝ន​ទឹង​លែៈ​តា​ឞ្រី​អីឆ្រាអែល គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​លែៈ​ត៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“មោ​គែស​អោស​ផូង​នតី​គឹត​រាលាវ​មា​នើម​នតី មោ​គែស​អោស​ទឹក​ក្វ៝ង់​រាលាវ​មា​កោរាញ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","លាស​ផូង​នតី​លែៈ​ឞ្លាវ​តឹម​ឞាន​មា​នើម​នតី​ខាន់​ពាង់ លាស​ទឹក​លែៈ​តឹម​ឞាន​មា​កោរាញ​ពាង់​នើម លាស​នទ្រី​លែៈ​គាប់​ហើយ្ស។ លាស​ឞូនុយ្ស​តើម​ជៃ​ឞូ​ក្វាល់៖ «បេលឆេបូល » លាស​នទ្រី​ទឹង​លែៈ​ឞូនុយ្ស​អី​គុ​តា​ជៃ​ពាង់​នៃ រាលាវ​មា​នៃ​ជឹត​អ្យើស​ឞូ​ក្វាល់​ខាន់​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“លើយ​អោស​ក្លាច​ផូង​អី​ជាន​ជេរ​នៃ យ៝រ​លាស​គែស​ទូ​នារ​ជឹត​នាប់​តៃ​កោរាញ​ឞ្រាស​មរា​អ៝ន់​ឞូ​ឆៃ​ទឹង​លែៈ​នទើ​អី​ឞូនុយ្ស​ហោម​មពោន។ កោរាញ​ឞ្រាស​អ៝ន់​ឞូ​គឹត​ទាទេ​ដ៝ង់ ទឹង​លែៈ​នទើ​អី​ឞូនុយ្ស​មោ​អុច​អ៝ន់​ឞូ​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","លាស​នទ្រី​ម៝ស​នទើ​គ៝ប់​លាស​ខាន់​មៃ​តា​នតុក​ង៝ អ៝ន់​ខាន់​មៃ​មឞើស​ងក៝ច​ហ៝ម់​តា​នតុក​អាង។ ម៝ស​នទើ​គ៝ប់​ងើយ​ឆ្វីស​តា​តោរ​ខាន់​មៃ អ៝ន់​មឞើស​ងក៝ច​ហ៝ម់​តា​កាលើ​ច៝រ​ជៃ​គៃ​មា​អ៝ក់​ឞូនុយ្ស​តាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","លើយ​ក្លាច​អោស​មា​នើម​ទើយ​ងខឹត​រាង្លៃ​ឆាក់​ទើម យើន​មា​មោ​ទើយ​អោស​ងខឹត​ហ្វេង អ៝ន់​ខាន់​មៃ​ក្លាច​កោរាញ​ឞ្រាស​ហ៝ៈ យ៝រ​លាស​ពាង់​ទើយ​អ៝ន់​ហ្វេង នទ្រែល​មា​រាង្លៃ​ឆាក់​លើស​ញអ្យើស​តា​នទ្រូង​អុញ។ ");
INSERT INTO cmok_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ឞូ​វៃ​តាច់​ឞារ​មល៝ម់​ឆ្យុម​រាលែវ​ខ្លៃ​ទូ​មល៝ម់​កាក់​ជេៈ យើន​មា​ឞ៝ល​លាស​ថ៝ក​កើត​នៃ លាស​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​មៃ​មោ​អ៝ន់ មោ​គែស​អោស​ទូ​មល៝ម់​ឆ្យុម​រាលែវ​តុប​តា​នែស។ ");
INSERT INTO cmok_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ឞ៝ល​លាស​ទឹង​លែៈ​ឆ៝ក់​តា​ឞោក​ខាន់​មៃ​នើម កោរាញ​ឞ្រាស​លែៈ​ជេស​កើប​ទឹង​លែៈ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","កើត​នទ្រី​លើយ​ក្លាច​អោស យ៝រ​លាស​កោរាញ​ឞ្រាស​កើប​ខាន់​មៃ​ខ្លៃ​ងាន់​រាលាវ​មា​ឆ្យុម​រាលែវ​ទូ​ផូង​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ឞូ​ម៝ស​អី​មឞើស​មា​ឞូ​លាស​ពាង់​តឹង​គ៝ប់គ៝ប់​មរា​មឞើស​ពាង់​អី​នៃ​ជេង​អ៝ស​ម៝ន​គ៝ប់​តា​ឞើស​នាប់​មាត់​ឞឹ​គ៝ប់​តា​កាលើ​ត្រោក។ ");
INSERT INTO cmok_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","យើន​មា​ឞូ​ម៝ស​អី​រាលាច់​មា​ឞូ​លាស​មោ​តឹង​គ៝ប់គ៝ប់​មោ​ដ៝ង់​មឞើស​ពាង់​អី​នៃ​ជេង​អ៝ស​ម៝ន​គ៝ប់​តា​ឞើស​នាប់​មាត់​ឞឹ​គ៝ប់​តា​កាលើ​ត្រោក”។ ");
INSERT INTO cmok_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“លើយ​មឹន​អោស​គ៝ប់​វាច់​តា​នែស​នតូ​អ្យា​លែវ​នាវ​ដាប់​មពាន់។ គ៝ប់​វាច់​តា​អ្យា​តឹម​ឞាន​មា​ញអោត​ដាវ លែវ​នាវ​តឹម​រាទ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","គ៝ប់​វាច់​អ៝ន់៖ «ក៝ន​ឞូ​ក្លោ​តឹម​ងខាស​ដាស​ឞឹ​ពាង់‌ ក៝ន​ឞូ​អូរ​តឹម​ងខាស​ដាស​មេៈ​ពាង់‌ មាន់​អ៝ន់​តឹម​ងខាស​ដាស​មេៈ​ព៝​ពាង់​នើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ឞូនុយ្ស​គុ​នទ្រែល​ទូ​ជៃ ជេង​តឹម​រាលាង់​នទ្រាង់​ខាន់​ពាង់​នើម»”។ ");
INSERT INTO cmok_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ឞូ​ម៝ស​រ៝ង់​មា​មេៈ​ឞឹ​ពាង់​នើម​អ៝ក់​រាលាវ​មា​រ៝ង់​គ៝ប់ ពាង់​អី​នៃ​មោ​អោស​ទី​ជេង​អ៝ស​ម៝ន​គ៝ប់។ ឞូ​ម៝ស​រ៝ង់​មា​ក៝ន​ឞូ​អូរ​ក៝ន​ឞូ​ក្លោ​ពាង់​នើម​អ៝ក់​រាលាវ​មា​រ៝ង់​គ៝ប់ ពាង់​អី​នៃ​មោ​ដ៝ង់​ទី​ជេង​អ៝ស​ម៝ន​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ឞូ​ម៝ស​មោ​តូយ​ឆី​តឹម​រាកាង់​ពាង់​នើម​ឞ្រោៈ​តឹង​គ៝ប់ ជេង​គែស​នាវ​ខ្លៃ​មោ​អ្យាត់​ទឹង​លែៈ​នាវ​កោរាញ​ឞ្រាស​ដាៈ ឞ៝ល​លាស​ត៝ត់​ខឹត​ឆាក់​កាដោយ ពាង់​អី​នៃ​មោ​អោស​ទី​ជេង​អ៝ស​ម៝ន​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ជេសរី​ឞូ​ម៝ស​ព្រាប់​រាវាន​មា​នាវ​រេស​ឆាក់​ពាង់​នើម ពាង់​តៃ​ខឹត​នហ៝​រ៝ យើន​មា​ឞូ​ម៝ស​ខឹត​អាច​មា​តឹង​គ៝ប់ ពាង់​តៃ​រេស​នហ៝​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ឞូ​ម៝ស​រ៝ម​ខាន់​មៃ តឹម​ឞាន​មា​ពាង់​រ៝ម​គ៝ប់ ឞូ​ម៝ស​រ៝ម​គ៝ប់​តឹម​ឞាន​មា​ពាង់​រ៝ម​កោរាញ​ឞ្រាស​តើម​ញជ្វាល់​គ៝ប់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ឞូ​ម៝ស​រ៝ម​ទូ​ហ្វេ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស អាច​មា​ពាង់​ជេង​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស ឞូនុយ្ស​អី​នៃ​គែស​នទើ​ងខោម​តឹម​ឞាន​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ដ៝ង់។ ឞូ​ម៝ស​រ៝ម​ទូ​ហ្វេ​ឞូនុយ្ស​ឆ៝ង់ អាច​មា​ពាង់​ជេង​ឞូនុយ្ស​ឆ៝ង់ ឞូនុយ្ស​អី​នៃ​គែស​នទើ​ងខោម​តឹម​ឞាន​មា​ឞូនុយ្ស​ឆ៝ង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ឞូ​ម៝ស​អ៝ន់​ទាក​នអីក​ទូ​កែវ​មា​ទូ​ហ្វេ​ឞូ​ជេៈ អាច​មា​ឞូ​ជេៈ​អី​នៃ​ជេង​អ៝ស​ម៝ន​គ៝ប់គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ នាវ​ងខោម​មា​ឞូនុយ្ស​អី​នៃ​មោ​រ៝ស​អោស”។ ");
INSERT INTO cmok_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ជេស​ឞ្រាស​យេឆូ ​លាស​នាវ​អី​នៃ​អ៝ន់​មា ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​ពាង់ ជេសរី​ពាង់​លោស​ឞើស​នតុក​នៃ គៃ​មា​ហាន់​នតុម​នតី​ឞូ​រ៝ៈ​ប៝ន​អេងៗ។ ");
INSERT INTO cmok_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","នោក​នៃ​យោហាន-​បាប់តែម ​ឞូ​ក្រុង​តា​នទ្រូង។ ត៝ត់​ពាង់​តាង់​លឺ​ឞូ​មឞើស​ងក៝ច​ទឹង​លែៈ​នទើ​ឞ្រាស​ក្រីស ​ជាន ពាង់​ដាៈ​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​អោប​ឞ្រាស​យេឆូ ​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“នោក​កាល់​អែ​នើស​កោរាញ​ឞ្រាស​លែៈ​ត៝ន​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​លាស៖ គែស​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​ជុរ​វាច់​តាៈ​ឞើស​កាលើ​ត្រោក​នតុក​កោរាញ​ឞ្រាស​នើម។ មៃ​អ្យា​ឞ្រាស​ក្រីស ​អី​នៃ​ឞើស មោ​លាស​អ៝ន់​ហេន​ហោម​ក៝ប់​ទូ​ហ្វេ​អា​អេង​ជឹត?” ");
INSERT INTO cmok_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​មឞើស​ងក៝ច​មា​ពាង់​រី ទឹង​លែៈ​នទើ​ខាន់​មៃ​តាង់​ខាន់​មៃ​ឆៃ​គ៝ប់​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ឞូនុយ្ស​ចែស​មាត់​អ្វាញ់​ឆៃ ឞូនុយ្ស​ក្វែត​រាវែន​ឞ្លាវ​ឞ្រោៈ ឞូនុយ្ស​ផុង​ឆា​ឞាស ក្ល៝ស ឞូនុយ្ស​តឹក​តោរ​អ្យាត់​តាង់ ឞូនុយ្ស​ខឹត​ទ៝ក់​រេស នអ៝ប់​មា​ឞូនុយ្ស​អ៝​អាច​តាង់​នាវ​មហែ​មហាន​អ្វែស។ ");
INSERT INTO cmok_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","អ្វែស​មអាក​ងាន់​មា​ឞូនុយ្ស​មោ​មអារ់​នាវ​ពាង់​ញឆីង​មា​គ៝ប់ យ៝រ​មា​នទើ​គ៝ប់​ជាន​អេង​ងាន់​ឞើស​នាវ​មឹន​ពាង់​អុច!” ");
INSERT INTO cmok_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","នទុត​ឆឹត​ផូង​អ៝ស​ម៝ន​យោហាន-​បាប់តែម ឞ្រាស​យេឆូ ​នតើម​ងើយ​មា​យោហាន-​បាប់តែម ​អ៝ន់​មា​ផូង​ប៝ន​លាន៖ “ម៝ស​ឞូនុយ្ស​អ្វាញ់​ខាន់​អៃ​មៃ​ហាន់​តា​ឞ្រី​រាទាស? ហាន់​អ្វាញ់​ឞូនុយ្ស​អី​ងើយ​ទាស​មា​ឞូនុយ្ស​អេងៗ​អុច​តឹម​ឞាន​មា​ជា​មពាត់​រាងោញ​ទាស​ឆ្យាល​មា​ខោម​ឞើស? ពាង់​មោ​ទី​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ម៝ស​ឞូនុយ្ស​ខាន់​អៃ​មៃ​ហាន់​អ្វាញ់? អ្វាញ់​ឞូនុយ្ស​ញឆ៝ស​ឞ៝ក​អ្វែស​អាវ​អ្វែស​ឞើស? មោ​អោស។ ឞូនុយ្ស​ញឆ៝ស​ឞ៝ក​អ្វែស​អាវ​អ្វែស មពោល​នៃ​គុ​តា​ជៃ​កាដាច់​គុ មោ​អោស​គុ​តា​ឞ្រី​រាទាស។ ");
INSERT INTO cmok_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","លាស​នទ្រី​ឞូ​ម៝ស​ឞូនុយ្ស​ខាន់​អៃ​មៃ​ហាន់​អ្វាញ់? អ្វាញ់​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ឞើស? ទី​ងាន់។ យើន​មា​ពាង់​អី​នៃ​រាលាវ​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","យ៝រ​លាស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​គែស​ញចីស​លាស​មា​ពាង់៖ «កោរាញ​ឞ្រាស​លាស៖ «ល៝ង់​គ៝ប់​ញជ្វាល់​ឞូនុយ្ស​ហាន់​ល៝រ​មៃ គៃ​មា​នទ្រាប់​នូយ្ស​នហ៝ម់​ឞូនុយ្ស​អ៝ន់​មា​មៃ​តឹម​ឞាន​មា​ក្វាយ្ស​ត្រ៝ង​អ៝ន់​មា​មៃ»» យោហាន-​បាប់តែម ​អី​នៃ​អី​ឞូនុយ្ស​ហាន់​ល៝រ​តា​នាវ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ខាន់​អៃ​មៃ​អ្យាត់​នាវ​គ៝ប់​នហេល​នានេៈ​ងាន់ ទឹង​លែៈ​ឞូនុយ្ស​អី​ទែស​តាៈ​ឞើស​ឞូ​អូរ​តា​នែស​នតូ​អ្យា មោ​គែស​អោស​ទូ​ហ្វេ​ជេង​ក្វ៝ង់​រាលាវ​យោហាន-​បាប់តែម  យើន​លាស​តា​មពោល​ឞូនុយ្ស​អី​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ ឞូនុយ្ស​អី​ជេៈ​តា​ន៝ម់​ឞូ ឞូនុយ្ស​អី​នៃ​ជេង​ក្វ៝ង់​រាលាវ​យោហាន-​បាប់តែម ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","នតើម​ឞើស​នារ​យោហាន-​បាប់តែម ​ជាន​បាប់តែម​ត៝ត់​មា​អាបៃ​អ្យា គែស​ឞូនុយ្ស​ញឆ្រោយ្ស​មឞើស​ងក៝ច​មា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ ជេសរី​ឞូនុយ្ស​អី​ញឆ្រោយ្ស​ងាន់​រី​មើ​គែស​លាប់។ ");
INSERT INTO cmok_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ទឹង​លែៈ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស នហ៝​មា​ត៝ត់​យោហាន-​បាប់តែម  លែៈ​គែស​ងក៝ច​មា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ នទ្រែល​មា​តា​នាវ​វៃ​ផូង​ឞ៝ន់​លែៈ​គែស​មឞើស​ងក៝ច​នាវ​អី​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","តា​នាវ​វៃ​ឞ៝ន់​លែៈ​គែស​មឞើស​ងក៝ច​ជេស​មា​ទូ​ហ្វេ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​អី​តឹម​ឞាន​មា​អេលីយា ​ពាង់​មរា​វាច់ លាស​ខាន់​អៃ​មៃ​អុច​អ្យាត់​នាវ​គ៝ប់យោហាន-​បាប់តែម ​ជេង​ឞូនុយ្ស​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ឞូ​ម៝ស​តាង់​នាវ​គ៝ប់​ងើយ​អ្យា អ៝ន់​ពាង់​មឹន​អេង​តា​ឆាក់! ");
INSERT INTO cmok_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","លាស​នទ្រី​មើម​គ៝ប់​តឹម​រាដឹល​មា​ឞូនុយ្ស​អាបៃ​អ្យា? ខាន់​ពាង់​ជេង​តឹម​ឞាន​មា​ក៝ន​ឆែ​គុ​ព៝ល់​តា​ជ៝ង់​គូង​ប៝ន គែស​អាបាៈ​តឹម​នតែរ​នទ្រាង់​ខាន់​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","«ហេន​លែៈ​អោស​នហោម​គ៝ស​គ៝រ់ តីស​មា​ខាន់​អៃ​មៃ​មោ​ព៝ល់​រាម់​មអាក​(រ៝ម់)‌ ជេសរី​ហេន​លែៈ​នអ៝រ​នត៝ង់​ទ៝ង់​ខឹត តីស​មា​ខាន់​អៃ​មៃ​មោ​អុច​ញុម​នអ៝រ​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","នទ្រី​យោហាន-​បាប់តែម ​ពាង់​អ៝ត់​ឆោង​ឆា អ៝ត់​ញេត​នទ្រាញ់ តីស​មា​ឞូ​លាស​ពាង់​ឞូនុយ្ស​ឞ្រាស​អ្យើស​លាប់។ ");
INSERT INTO cmok_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ល៝ង់​គ៝ប់​អ្យា​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​គែស​ញេត​គែស​ឆោង មោ​អ៝ត់​ឆោង​ឆា ឞូ​លាស​គ៝ប់៖ «ឞូនុយ្ស​ហៃ​ញេត​ហៃ​ឆោង ជាន​មឹត​ជាង់​ដាស​ឞូនុយ្ស​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន​គៃ​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ ជេសរី​គុ​នទ្រែល​ឞូនុយ្ស​តីស​អា​អេង​ជឹត»។ យើន​មា​ឞូនុយ្ស​អី​តឹង​នាវ​កោរាញ​ឞ្រាស ញហើ​នាវ​កោរាញ​ឞ្រាស​អី​នៃ​ជេង​ទី​អ្វែស​ងាន់​តា​នាវ​រេស​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ជេសរី​ឞ្រាស​យេឆូ ​នទុយ្ស​ប៝ន​អី​ពាង់​លែៈ​ជាន​នាវ​ខ្លៃ​អ៝ក់​រាលាវ​ឞូ យ៝រ​មា​ខាន់​ពាង់​មោ​អុច​រាគ៝ល់​នូយ្ស​នហ៝ម់​អ្យើស ពាង់​លាស​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“រេស​រាញាល់​ងាន់​មា​ឞូនុយ្ស​គុ​តា​ប៝ន​ខោរាឆីន  នទ្រែល​មា​ប៝ន​បេតឆៃដា  យ៝រ​លាស​ខាន់​ពាង់​លែៈ​ឆៃ​ទឹង​លែៈ​នទើ​អ្វែស​នទើ​ខ្លៃ​គ៝ប់​ជាន តីស​មា​មោ​អោស​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស។ ឞូនុយ្ស​តា​ប៝ន​តីរុស  នទ្រែល​មា​តា​ប៝ន​ឆីដោន ​ជេង​ផូង​មោ​គឹត​នាល់​កោរាញ​ឞ្រាស លាស​ខាន់​ពាង់​ឆៃ​នាវ​ខ្លៃ​អី​នៃ ខាន់​ពាង់​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស​រ៝ ជេសរី​គៃ​មា​ញហើ​នាវ​ខាន់​ពាង់​លែៈ​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស ខាន់​ពាង់​ញឆ៝ស​ងគូត​បាវ​ច្យាត់​គុ​តា​អុញ​ឞុស។ ");
INSERT INTO cmok_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","លាស​នទ្រី​គ៝ប់​មឞើស​ងក៝ច​មា​ខាន់​អៃ​មៃ តា​នារ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​លាម​នែស​នតូ​តៃ ឞូនុយ្ស​តា​ប៝ន​តីរុស  នទ្រែល​មា​តា​ប៝ន​ឆីដោន  ខាន់​ពាង់​គែស​ទោយ្ស​ថើល​តា​ន៝ម់​ឞូនុយ្ស​គុ​តា​ប៝ន​ខោរាឆីន  ប៝ន​បេតឆៃដា ។ ");
INSERT INTO cmok_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ឞូនុយ្ស​គុ​តា​ប៝ន​កាពើនិម ​អី​ប៝ន​គ៝ប់​គុ​ជ៝ៈ​ខៃ នទ្រែល​មា​គ៝ប់​លែៈ​នតី​លែៈ​ជាន​នទើ​នាវ​ខ្លៃ លើយ​អោស​មឹន​លាស​ឆាក់​ខាន់​អៃ​មៃ​នើម​លែៈ​ជេង​ឞូនុយ្ស​អ្វែស​ហាវ​តា​ប៝ន​អ្វែស​កាលើ។ មោ​អោស ខាន់​អៃ​មៃ​តៃ​តុប​តា​នតុក​រេស​រាញាល់​តា​នទ្រូង​អុញ​រ៝។ យ៝រ​លាស​នាវ​ខ្លៃ​អី​លែៈ​គែស​ជេស​តា​ងក្លាង​ខាន់​អៃ​មៃ លាស​ប៝ន​ឆោដុម ​អី​ជាន​តីស​ទុត​ហោ​កាល់​អែ​នើស នទ្រី​ទឹង​កោរាញ​ឞ្រាស​ទែ​លើស​ហេង​ខាន់​ពាង់​មា​អុញ​ឞើស​កាលើ​ត្រោក ខាន់​ពាង់​ឆៃ​កើត​នៃ ឞូនុយ្ស​តា​ប៝ន​នៃ​មោ​អោស​គែស​រ៝ស ហោម​ត៝ត់​តា​នារ​អាបៃ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","នទ្រី​ទឹង​គ៝ប់​លាស​មា​ខាន់​អៃ​មៃ តា​នារ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​ទឹង​លែៈ​ឞូនុយ្ស​តា​នែស​នតូ​តៃ ឞូនុយ្ស​តាៈ​ឞើស​ឞ្រី​ប៝ន​ឆោដុម ​គែស​ទោយ្ស​ថើល​ទើម​តា​ន៝ម់​ខាន់​អៃ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ជេសរី​ឞ្រាស​យេឆូ ​លាស​កើត​នអា៖ “ហើយ​ឞឹ អី​កោរាញ​មា​ត្រោក នទ្រែល​មា​នែស​នតូ គ៝ប់​រានេ​មៃ​ហោ​ងាន់ យ៝រ​លាស​មៃ​លែៈ​ញហើ​នាវ​មៃ​នតើម​ម៝ត់​អ្វាញ់​ឞូនុយ្ស​អ្យា​អ៝ន់​មា​ឞូនុយ្ស​រាលូក​ម៝ល់​មោ​វ៝ត់​តឹម​ឞាន​មា​ក៝ន​ឆែ ជេសរី​ពោន​នទ៝ប់​លើយ​នទើ​អី​នៃ​មា​ឞូនុយ្ស​អី​កើប​អេង​ឆាក់​ខាន់​ពាង់​នើម​ជេង​ឞូនុយ្ស​គឹត​ឞូនុយ្ស​ឞ្លាវ។ ");
INSERT INTO cmok_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ហើយ​ឞឹ នូយ្ស​នហ៝ម់​មៃ​អុច​កើត​នអា​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ទឹង​លែៈ​នតីល​នទើ លែៈ​ឞឹ​ជាវ​មា​គ៝ប់​ទាទេ​ជេស។ មោ​គែស​អោស​ឞូនុយ្ស​គឹត​នាល់​គ៝ប់​អី​ក៝ន​មៃ គែស​មៃ​អី​ឞឹ​គ៝ប់​នើម​ទើម​គឹត​នាល់។ មោ​គែស​អោស​ឞូនុយ្ស​គឹត​នាល់​មៃ​អី​ឞឹ​គ៝ប់ គែស​គ៝ប់​អី​ក៝ន​មៃ​ទើម​គឹត​នាល់ នទ្រែល​មា​ទឹង​លែៈ​ឞូនុយ្ស​អី​គ៝ប់​អុច​អ៝ន់​គឹត​នាល់​មៃ ទូ​រី​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ឞូ​ម៝ស​គែស​នាវ​លេត​រាគាញ់ នទ្រែល​មា​អាញ​ជ៝ក់ វាច់​ហ៝ម់​អា​គ៝ប់គ៝ប់​អ៝ន់​ខាន់​អៃ​មៃ​រាលូ។ ");
INSERT INTO cmok_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ឆ៝ៈ​ហ៝ម់​នទើ​មឞាក់​គ៝ប់ ជេសរី​នតី​តាៈ​ឞើស​គ៝ប់ នូយ្ស​នហ៝ម់​ខាន់​អៃ​មៃ​នអីក​រាងេត​ងាន់​រ៝ យ៝រ​លាស​នូយ្ស​នហ៝ម់​គ៝ប់​មលែស នទ្រែល​មា​ទេស​រាហេត។ ");
INSERT INTO cmok_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","នទើ​មឞាក់​គ៝ប់​ងគើច នទ្រែល​មា​នទើ​គ៝ប់​អ៝ន់​ខាន់​អៃ​មៃ​អាញ​ងគើច​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","គែស​ទូ​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល ​ឞ្រាស​យេឆូ  នទ្រែល​មា​ផូង​អ៝ស​ម៝ន​ពាង់​ហាន់​គ្លាត់​រ៝ៈ​មីរ ផូង​អ៝ស​ម៝ន​ជី​ង៝ត ខាន់​ពាង់​រ៝យ្ស​ឞា​ព្រាង់ ​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ផូង​ផារីឆី ​ឆៃ​កើត​នៃ ខាន់​ពាង់​ហាន់​លាស​ឞ្រាស​យេឆូ ៖ “ល៝ង់​មៃ​អ្វាញ់ ម៝ស​ឆី​កោៈ​មពោល​អ៝ស​ម៝ន​មៃ​ជាន​ការ​តា​នារ​ឆាបាត់ ​អ្យា​មេស? ឞ៝ល​លាស​ខាន់​ពាង់​រ៝យ្ស​ដេៈៗ​កើត​នៃ ហោម​អែ​កើប​តីស​ដាស​នាវ​វៃ​នារ​រាលូ​ផូង​ឞ៝ន់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ឞ្រាស​យេឆូ ​លាស​មា​ផូង​ផារីឆី ៖ “លាស​នទ្រី​ខាន់​មៃ​លែៈ​ច្វេល​បាស នាវ​ខាន់​មៃ​វៃ​រ៝ៈ​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ? នោក​ដាវីត ​អេ​ហ៝ៈ​ជេង​កាដាច់ ពាង់ នទ្រែល​មា​ឞូនុយ្ស​គុ​នទ្រែល​ពាង់​ជី​ង៝ត‌ ");
INSERT INTO cmok_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ជេសរី​ពាង់​លាប់​តា​ត្រោម​នតុក​ចូន​កោរាញ​ឞ្រាស​អី​ជាន​មា​ឞ៝ក ឆ៝ៈ​ឆា​នុមពាង់​អី​ឞូ​តេៈ​ញហើរ​អ៝ន់​កោរាញ​ឞ្រាស​នៃ នហ៝​មា​ពាៈ​ឞូនុយ្ស​អី​គុ​នទ្រែល​ពាង់​នៃ​ឆា​ដ៝ង់។ ឞូ​មោ​លាស​ពាង់​ដ៝ង់​ឞ៝ល​លាស​តឹង​មា​នាវ​វៃ​គែស​មពោល​ជាន​ឞ្រាស​ទើម​ទើយ​ឆា​នុមពាង់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ជេសរី​ខាន់​មៃ​លែៈ​គែស​អ្វាញ់​ដ៝ង់​តា​ឆ៝ម់បុត​នាវ​វៃ​ឞ៝ន់​លាស​ផូង​ឞូនុយ្ស​ជាន​ឞ្រាស​គុ​ជាន​ការ​តា​ញីស​ជាន​ឞ្រាស ខាន់​ពាង់​ហោម​ជាន​ការ​តា​នារ​ឆាបាត់  នាវ​អី​នៃ​មោ​តឹម​ទី​មា​ជាន​តា​នារ​ឆាបាត់  យើន​មា​មោ​អោស​គែស​នាវ​តីស។ ");
INSERT INTO cmok_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","នទ្រី​ទឹង​គ៝ប់​លាស​មា​ខាន់​មៃ តា​អ្យា​គែស​ទូ​ហ្វេ​គ៝ប់​ក្វ៝ង់​រាលាវ​មា​ញីស​ជាន​ឞ្រាស​អី​នៃ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","លាស​ខាន់​មៃ​លែៈ​វ៝ត់​តា​នាវ​លាស​អី​អ្យា៖ «គ៝ប់​មោ​អោស​អុច​មា​នទើ​ជាន​ឞ្រាស​ខាន់​អៃ​មៃ គ៝ប់​អុច​មា​ខាន់​អៃ​មៃ​គែស​នាវ​យោៈ​មា​ឞូ» ខាន់​មៃ​មោ​អោស​នទុយ្ស​មា​ផូង​មោ​គែស​នាវ​តីស។ ");
INSERT INTO cmok_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស គ៝ប់​ជេង​កោរាញ​ម៝ស​នទើ​អី​ទើយ​អ៝ន់​ឞូ​ជាន មោ​លាស​មោ​ទើយ​អ៝ន់​ឞូ​ជាន​តា​នារ​ឆាបាត់ ​អី​នារ​រាលូ”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​នតុក​នៃ ហាន់​លាប់​តា​ញីស​រាបុន​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","តា​ញីស​រាបុន​នៃ​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ឆ្យារ់​តី។ ផូង​ផារីឆី ​អោប​ឞ្រាស​យេឆូ ៖ “តឹង​មា​នាវ​វៃ​ផូង​ឞ៝ន់ អាស​ទី​ដ៝ង់​ឞើស ជាន​ឞាស​នាវ​ជី​តា​នារ​ឆាបាត់ ​អី​នារ​គុ​រាលូ​ឞ្វៃ​ជាន​ការ?” ខាន់​ពាង់​អោប​កើត​នៃ គៃ​មា​ជ៝យ​នាវ​មា​នតោន​ឞ្រាស​យេឆូ ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “តា​ផូង​ខាន់​មៃ លាស​គែស​ទូ​ហ្វេ​គែស​ទូ​មល៝ម់​ឞែ​ឞ្យាប់​ពាង់​តុប​តា​នតូ​តា​នារ​ឆាបាត់  អាស​ពាង់​មោ​ឆ៝ៈ​ឞែ​ឞ្យាប់​អី​នៃ​លោស​អា​កាលើ​អ្យា? ");
INSERT INTO cmok_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","យើន​មា​ឞូនុយ្ស​ខ្លៃ​រាលាវ​ឞែ​ឞ្យាប់ លាស​នទ្រី​ទើយ​ជាន​នទើ​អ្វែស​តា​នារ​ឆាបាត់ ​មោ​អោស​តីស​មា​នាវ​វៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ឞូនុយ្ស​ឆ្យារ់​តី​នៃ៖ “យើរ​ហ៝ម់​តី​មៃ​នៃ”។ ពាង់​យើរ​រ៝ ជេសរី​តី​ពាង់​ឞាស​កើត​តី​ទូ​ទីង​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","យើន​មា​ផូង​ផារីឆី ​លោស​អា​ទីស​តឹម​ញច្រាៈ​នាវ​គៃ​មា​ជ៝យ​នាវ​មើម​ទឹង​គែស​ងខឹត​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","នោក​ឞ្រាស​យេឆូ ​គឹត​នាវ​អី​នៃ ជេសរី​ពាង់​លោស​ឞើស​នតុក​នៃ គែស​អ៝ក់​ផូង​ប៝ន​លាន​តឹង​ពាង់​ដ៝ង់ ទឹង​លែៈ​នាវ​ជី​ខាន់​ពាង់ ពាង់​ជាន​ឞាស​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ឞ្រាស​យេឆូ ​ឞ្វៃ​ខាន់​ពាង់ មោ​អោស​អ៝ន់​ខាន់​ពាង់​មឞើស​ងក៝ច​អ៝ន់​ឞូ​គឹត​នាល់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ពាង់​ជាន​កើត​នៃ​គៃ​មា​តឹម​ទី​ដាស​នាវ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​អេឆាយ ​លែៈ​ញចីស​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«កោរាញ​ឞ្រាស​លាស៖ «ឞូនុយ្ស​អ្យា ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មា​គ៝ប់ លែៈ​គ៝ប់​កើយ្ស​ពាង់‌ គ៝ប់​រ៝ង់​ពាង់​ហោ​ងាន់ ទី​នូយ្ស​នហ៝ម់​គ៝ប់​ក្លឹ​ងាន់។ គ៝ប់​អ៝ន់​ឞ្រាស​ហ្វេង​អ្វែស​គ៝ប់​គុ​តា​ពាង់ គៃ​មា​ផាត​ទោយ្ស​ផូង​អី​មោ​ទី​ផូង​អីឆ្រាអែល ​មា​នាវ​ឆ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ពាង់​មោ​គែស​តឹម​រាលាច់​ដាស​ឞូ មោ​គែស​អោស​នតែរ‌ មោ​គែស​ដ៝ង់​ឞូនុយ្ស​តាង់​ឞ៝រ់​ពាង់​រ៝ៈ​ត្រ៝ង។ ");
INSERT INTO cmok_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ពាង់​មោ​អោស​រាតាច់​លើយ​ជា​លែៈ​ទែស‌ ពាង់​មោ​ខោម​លើយ​ដ៝ង់​អុញ​ឆាគេង​លែៈ​ឞើយ​មា​ញហ៝ត់ គែស​នាវ​យោៈ​មា​ឞូនុយ្ស​អី​គែស​នាវ​ញឆីង​ដេៈ‌ នហ៝​មា​មោ​អោស​ឞាស​ជាន​ការ​ត៝ត់​មា​ទើយ​ដាស​ទឹង​លែៈ​នាវ​អ្យើស។ ");
INSERT INTO cmok_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ជេសរី​ទឹង​លែៈ​ផូង​អី​មោ​ទី​ផូង​អីឆ្រាអែល  ឞូ​រានើម​មា​ពាង់​ងាន់»»។ ");
INSERT INTO cmok_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ជេសរី​គែស​ឞូ​លែវ​ទូ​ហ្វេ​ឞូនុយ្ស​ឞូ​ក្លោ​ឞ្រាស​អ្យើស​លើស​ហាន់​អា​ឞ្រាស​យេឆូ  ឞូនុយ្ស​អី​នៃ​មល៝ នទ្រែល​មា​ចែស​មាត់។ ឞ្រាស​យេឆូ ​ជាន​អ៝ន់​ពាង់​ឞ្លាវ​ងើយ​មាត់​ឆៃ​អាង​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ទឹង​លែៈ​ឞូនុយ្ស​តា​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់ ខាន់​ពាង់​តឹម​លាស៖ “គឹត​ពាង់​អី​នៃ​បាស​អី​ក៝ន​ឆៅ​កាដាច់​ដាវីត ​អី​នើម​រាក្លាយ្ស​កោរាញ​ឞ្រាស​ទែ​លែៈ​ត៝ន​ហាន់​តា​អ្យា?” ");
INSERT INTO cmok_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","យើន​មា​តាង់​ឞូ​ងើយ​កើត​នអៃ ផូង​ផារីឆី ​លាស៖ “អាច​មា​បេលឆេបូល ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​គុ​តា​ឆាក់​ពាង់​ទើម ទឹង​ពាង់​ទើយ​មព្រើស​ឞ្រាស​អ្យើស​កើត​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ឞ្រាស​យេឆូ ​លែៈ​គឹត​ជេស​នាវ​មឹន​ខាន់​ពាង់ ជេសរី​ពាង់​លាស៖ “ទឹង​លែៈ​ឞ្រី​អី​គែស​នាវ​តឹម​ល៝ក់​តឹម​ជាញ​ចាស​ច្រាយ​ឞាល់ ឞ្រី​អី​នៃ​រ៝ស​ហេង​រ៝ ទឹង​លែៈ​ប៝ន​ទឹង​លែៈ​រានាក់​វ៝ល់​អី​គែស​នាវ​តឹម​ល៝ក់​តឹម​ជាញ​នទ្រាង់​នើម ប៝ន​រានាក់​អី​នៃ​រ៝ស​ហេង​មោ​ហោម​គែស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","លាស​គ៝ប់​នត្រុត​ឞ្រាស​អ្យើស​តាៈ​ឞើស​នាវ​ទើយ​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស ឞ្រាស​អ្យើស​គែស​នាវ​តឹម​រាទ៝ង់​តឹម​ជាញ​ចាស​ច្រាយ​ឞាល់ លាស​នទ្រី​មើម​ទឹង​ហោម​គែស​ឆាតាង់ ​ម៝ត់​អ្វាញ់? ");
INSERT INTO cmok_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","អ៝ស​ម៝ន​ខាន់​មៃ​នត្រុត​ឞ្រាស​អ្យើស​ដ៝ង់។ លាស​គ៝ប់​នត្រុត​ឞ្រាស​អ្យើស​យ៝រ​មា​នាវ​ទើយ​ឆាតាង់ ​ងាន់ ខាន់​មៃ​អើម​មោ​លាស លាស​ខាន់​ពាង់​នត្រុត​ឞ្រាស​អ្យើស​យ៝រ​មា​នាវ​ទើយ​ឆាតាង់ ? លាស​នទ្រី​អ៝ស​ម៝ន​ខាន់​មៃ​នើម​អី​នៃ​មរា​តេៈ​ទោយ្ស​ខាន់​មៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","យើន​មា​លាស​នាវ​ទើយ​គ៝ប់​នត្រុត​ឞ្រាស​អ្យើស​តាៈ​ឞើស​ឞ្រាស​ហ្វេង​អ្វែស​កោរាញ​ឞ្រាស លាស​នទ្រី​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​មា​ខាន់​មៃ​លែៈ​ត៝ត់​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","មើម​ទឹង​ឞូនុយ្ស​ទើយ​ហាន់​តា​ជៃ​ឞូនុយ្ស​ទាង់ ជេសរី​នតុង​ទ្រាប់​នទើ​ពាង់? អ៝ន់​ញុប​ក៝ត់​ល៝រ​ពាង់​អី​នៃ​ប៝ត់ រី​មើ​ទើយ​ពីត​ឆ៝ៈ​ទ្រាប់​នទើ​ទឹង​លែៈ​តា​ជៃ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ឞូ​ម៝ស​មោ​គុ​មពែស​ឞើស​គ៝ប់ ពាង់​អី​នៃ​ជេង​តឹម​រាលាង់​ដាស​គ៝ប់។ ឞូ​ម៝ស​អី​មោ​រាគូម​នទ្រែល​គ៝ប់ ពាង់​អី​នៃ​ជេង​ឞូនុយ្ស​តឹម​ងខាស​ញហីង​ញហាង។ ");
INSERT INTO cmok_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","កើត​នទ្រី​ទឹង​គ៝ប់​មឞើស​អ៝ន់​មា​ខាន់​អៃ​មៃ ទឹង​លែៈ​នទើ​ឞូនុយ្ស​ជាន​តីស នទ្រែល​មា​លាស​មឺច​រាម៝ត​កោរាញ​ឞ្រាស កោរាញ​ឞ្រាស​ហោម​យោៈ​មោ​អោស​កើប​នាវ​តីស​ជឹត។ តីស​មា​ឞូ​ម៝ស​អី​លាស​មឺច​រាម៝ត​ឞ្រាស​ហ្វេង​អ្វែស​អី​រី មោ​អោស​កោរាញ​ឞ្រាស​យោៈ​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ឞូ​ម៝ស​ពាង់​អី​ងើយ​តឹម​រាទ៝ង់​ដាស​គ៝ប់​អី​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស កោរាញ​ឞ្រាស​ហោម​យោៈ​មោ​អោស​កើប​នាវ​តីស​ពាង់ យើន​មា​ឞូ​ម៝ស​ពាង់​អី​ងើយ​តឹម​រាទ៝ង់​ដាស​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស កោរាញ​ឞ្រាស​ហោម​កើប​នាវ​តីស​ពាង់​នានាវ ឞ៝ល​លាស​តា​រានោក​អាបៃ​អ្យា មោ​លាស​តា​រានោក​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ឞូនុយ្ស​ងាន់​តៃ​កាដោយ”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“លាស​តើម​អ្វែស ព្លៃ​ពាង់​អ្វែស​ដ៝ង់ តីស​មា​លាស​តើម​មោ​អ្វែស ព្លៃ​ពាង់​មោ​អ្វែស​ដ៝ង់ យ៝រ​លាស​ទឹង​ឞូ​គឹត​នាល់​តើម​ឆី​តាៈ​ឞើស​ព្លៃ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","យេ! មពោល​ឞូនុយ្ស​អ្យើស​ឞូនុយ្ស​ជាញ​តឹម​ឞាន​មា​ឞេស​កូ! មើម​ខាន់​មៃ​ឞ្លាវ​ងើយ​នាវ​អ្វែស លាស​ឆាក់​ខាន់​មៃ​ជេង​ឞូនុយ្ស​អ្យើស? យ៝រ​លាស​ឞូនុយ្ស​ទឹង​លោស​ងើយ តាៈ​ឞើស​នាវ​មឹន​អ៝ក់​ងាន់​តា​នូយ្ស​នហ៝ម់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ឞូនុយ្ស​អ្វែស​ងើយ​នទើ​អ្វែស យ៝រ​លាស​តា​ឆាក់​ពាង់​រី​គែស​នាវ​មឹន​អ្វែស​នឹង ឞូនុយ្ស​អ្យើស​ងើយ​នទើ​អ្យើស យ៝រ​លាស​តា​ឆាក់​ពាង់​រី​គែស​នាវ​មឹន​អ្យើស​នឹង។ ");
INSERT INTO cmok_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","គ៝ប់​លាស​មា​ខាន់​មៃ តា​នារ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​ទឹង​លែៈ​ឞូនុយ្ស​តា​នែស​នតូ​តៃ ពាង់​ផាត​ទោយ្ស​ឞូនុយ្ស​មា​ទឹង​លែៈ​នាវ​អី​ឞូនុយ្ស​ងើយ​លាៈ​ងើយ​លេង​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ពាង់​លែៈ​កើប​ខាន់​មៃ​ឆ៝ង់​មោ​គែស​ទោយ្ស យ៝រ​លាស​លោស​នាវ​ខាន់​មៃ​មឞើស​ងើយ មោ​លាស​ពាង់​កើប​ខាន់​មៃ​គែស​ទោយ្ស យ៝រ​លោស​នាវ​ខាន់​មៃ​មឞើស​ងើយ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","នោក​នៃ​គែស​អាបាៈ​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​ផារីឆី ​លាស​មា​ឞ្រាស​យេឆូ ៖ “អើ​នើម​នតីមៃ​ជាន​ទូ​នាវ​មឞេន​អ៝ន់​ហេន​ឆៃ​អឺស គៃ​មា​ញហើ​នាវ​ទើយ​មៃ​តាៈ​ឞើស​កោរាញ​ឞ្រាស”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","យើន​មា​ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ឞូនុយ្ស​តា​រានោក​អាបៃ​អ្យា​ហោ​ងាន់​អ្យើស​មហឹក មោ​អុច​ជាន​តឹង​នាវ​កោរាញ​ឞ្រាស​អុច អុច​ឆៃ​មា​នាវ​មឞេន​ទើម យើន​មា​កោរាញ​ឞ្រាស​មោ​អោស​អ៝ន់​នាវ​មឞេន​អេង​ជឹត។ ពាង់​អ៝ន់​ទូ​នាវ​មឞេន​តឹម​ឞាន​មា​នាវ​មឞេន​យោនាយ្ស ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","យ៝រ​លាស​យោនាយ្ស ​គុ​តា​ត្រោម​នទុល​កា​ក្វ៝ង់​ពែ​នាង់​ពែ​នារ កើត​នអៃ​ដ៝ង់​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​តៃ​គុ​តា​ត្រោម​នែស​ពែ​នាង់​ពែ​នារ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","តា​នារ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​ទឹង​លែៈ​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា ឞូនុយ្ស​តា​ប៝ន​នីនីវេ ​មរា​តេៈ​ទោយ្ស​ឞូនុយ្ស​តា​រានោក​អាបៃ​អ្យា​ដ៝ង់ យ៝រ​លាស​រានោក​កាល់​អែ​នើស ជេស​ខាន់​ពាង់​តាង់​នាវ​យោនាយ្ស ​មឞើស ខាន់​ពាង់​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស​រ៝ ខាន់​ពាង់​នទុយ្ស​តោរ​លែៈ​លាន់​នាវ​ខាន់​ពាង់​ជាន​តីស​នើស។ យើន​មា​តា​អ្យា​អាបៃ​អ្យា​គែស​ដ៝ង់​ទូ​ហ្វេ​ឞូនុយ្ស​ក្វ៝ង់​រាលាវ​មា​យោនាយ្ស ​នៃ​ជឹត តីស​មា​ខាន់​មៃ​មោ​អោស​រាគ៝ល់​នូយ្ស​នហ៝ម់​អ្យើស។ ");
INSERT INTO cmok_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","តា​នារ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​ទឹង​លែៈ​ឞូនុយ្ស​តា​នែស​នតូ គែស​កាដាច់​ឞូ​អូរ​រាញា​ពាង់​ឆេបា  ពាង់​មរា​តេៈ​ទោយ្ស​មា​ឞូនុយ្ស​រានោក​អាបៃ​អ្យា។ កាល់​អែ​នើស​ពាង់​កាដាច់​តា​ឞ្រី​អេង​ងាយ​មពែស​ឞើស​ទ៝ង់​ឞ្រី​អីឆ្រាអែល  ឞ៝ល​លាស​ពាង់​គុ​ងាយ​ទុត​ឞ្រី​ទុត​នែស​កាដោយ ពាង់​ហាន់​តា​ឞ្រី​អីឆ្រាអែល ​គៃ​មា​អ្យាត់​នាវ​មឹន​គឹត​ឞ្លាវ​កាដាច់​ឆាលោមោន ​តា​ឞ្រី​អ្យា។ យើន​មា​នារ​អ្យា​តា​នតុក​អ្យា​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​នាវ​ងើយ​ពាង់​ខ្លៃ​រាលាវ​នាវ​ងើយ​កាដាច់​ឆាលោមោន  តីស​មា​ខាន់​មៃ​មោ​អោស​អុច​អ្យាត់​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“លាស​ឞ្រាស​អ្យើស​លោស​ឞើស​ទូ​ហ្វេ​ឞូនុយ្ស ជេសរី​ពាង់​ឞ្រោៈ​រ៝ៈ​ឞ្រី​រាទាស ពាង់​ជ៝យ​នតុក​មា​គុ​មោ​គែស​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ជេសរី​ពាង់​មរា​លាស​អេង​កើត​នអា៖ «គ៝ប់​ព្លឹ​គុ​តា​ជៃ​អើម​គ៝ប់ នតុក​គ៝ប់​មហែ​លោស​នើស​ប៝ត់»។ ត៝ត់​ពាង់​ព្លឹ​តា​នៃ ឆៃ​ជៃ​អី​នៃ​លែៈ​ញឆ៝យ្ស​ទាទេ​មពេស​អ្វែស នទ្រាប់​អ្យាហែប‌ ");
INSERT INTO cmok_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ជេសរី​ពាង់​ហាន់​ជាៈ​ពើស​ឞ្រាស​អ្យើស​អា​អេង​តៃ ឞ្រាស​អ្យើស​អី​នៃ​ជាញៗ​រាលាវ​ពាង់​ងាន់ ហាន់​លាប់​គុ​នទ្រែល​តា​នៃ​ដ៝ង់ ជាន​អ៝ន់​ឞូនុយ្ស​អី​នៃ​គែស​នាវ​ជេរ​អ្យើស​រាលាវ​អើម​នើស​ជឹត។ កើត​នទ្រី​ឞូនុយ្ស​អ្យើស​តា​រានោក​អ្យា​គែស​តឹម​ឞាន​កើត​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","នោក​ឞ្រាស​យេឆូ ​ហោម​គុ​ងើយ​ដាស​ផូង​ប៝ន​លាន​នៃ គែស​មេៈ​ពាង់​នទ្រែល​មពោល​អ៝ស​ឞូ​ក្លោ​ពាង់​គុ​ឞើស​ទីស​រី អុច​ងើយ​ដាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ហាន់​មឞើស​មា​ពាង់៖ “ហើយ​នើម​នតី មេៈ​មៃ នទ្រែល​មា​ផូង​អ៝ស​ឞូ​ក្លោ​មៃ​គុ​ឞើស​ទីស​រី ខាន់​ពាង់​អុច​ងើយ​ដាស​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","យើន​មា​ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “ឞូ​ម៝ស​មេៈ​គ៝ប់? ឞូ​ម៝ស​ផូង​អ៝ស​នោ​គ៝ប់?” ");
INSERT INTO cmok_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ជេសរី​ឞ្រាស​យេឆូ ​ញច៝ង់​តី​ជឹត​ផូង​អ៝ស​ម៝ន​ពាង់ពាង់​លាស៖ “ខាន់​ពាង់​អ្យា​មេៈ​គ៝ប់ នទ្រែល​មា​ផូង​អ៝ស​នោ​គ៝ប់​ហែស! ");
INSERT INTO cmok_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","យ៝រ​លាស​ឞូ​ម៝ស​អី​អ្យាត់​តឹង​នាវ​អុច​ឞឹ​គ៝ប់​គុ​តា​កាលើ​ត្រោក ពាង់​អី​នៃ​អ៝ស​នោ​រោស​ក្លោ​គ៝ប់ នទ្រែល​មា​មេៈ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","នារ​នៃ​ដ៝ង់​ឞ្រាស​យេឆូ ​លោស​ឞើស​ជៃ ហាន់​គុ​រាគើប​តា​មែង​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ ។ ");
INSERT INTO cmok_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","តា​នៃ​គែស​អ៝ក់​ឞូនុយ្ស​ហាន់​វាច់​អា​ពាង់ នទ្រី​ពាង់​ហាវ​គុ​រាគើប​តា​កាលើ​ទូ​មល៝ម់​ទូក ជេសរី​នតី​ឞើស​កាលើ​ទូក​រី ផូង​ប៝ន​លាន​គុ​រ៝ៈ​មែង​ទាក។ ");
INSERT INTO cmok_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ជេសរី​ឞ្រាស​យេឆូ ​នតី​លាស​អ៝ន់​មា​ខាន់​ពាង់​អ៝ក់​មា​នាវ​ងើយ​នតឹត ពាង់​លាស​កើត​នអា៖ “អ្យាត់​ហ៝ៈ! គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ឞូ​ក្លោ​ហាន់​ឆូយ​គារ់​នតីល​តា​មីរ។ ");
INSERT INTO cmok_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","នោក​ពាង់​ឆូយ​នៃ​អាបាៈ​តុប​រ៝ៈ​ត្រ៝ង ជេសរី​ឆ្យុម​ច៝ក​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","គារ់​អាបាៈ​តុប​តា​នែស​ក្លេរ គារ់​អី​នៃ​គើញ​ហ៝ន​ព្រូ​យ៝រ​លាស​នែស​នហើ។ ");
INSERT INTO cmok_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","យើន​មា​ត៝ត់​ទោស​នារ​តើម​អី​នៃ​នទ្រ៝​ប្រុង យ៝រ​មា​រែស​ពាង់​ហ៝ន​មោ​ជ្រូ។ ");
INSERT INTO cmok_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","គារ់​អាបាៈ​ជឹត​តុប​តា​នែស​ល៝ក ជេសរី​ល៝ក​ហ៝ន​ត៝ល់​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ល៝ង់​គារ់​អី​អាបាៈ​ជឹត​តុប​តា​នែស​អ្វែស ពាង់​ហ៝ន​ព្រូ​អ្វែស​ជេង​ងាន់ នហ៝​មា​ត៝ត់​គែស​ព្លៃ​ទូ​គារ់​គែស ១០០‌ អាបាៈ​ទូ​គារ់​គែស ៦០‌ អាបាៈ​ជឹត​ទូ​គារ់​គែស ៣០។ ");
INSERT INTO cmok_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ឞូ​ម៝ស​តាង់​នាវ​គ៝ប់​ងើយ​អ្យា អ៝ន់​ពាង់​ងក្ល៝ន់​អេង​តា​ឆាក់!” ");
INSERT INTO cmok_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ជេសរី​ផូង​អ៝ស​ម៝ន​ហាន់​អោប​ឞ្រាស​យេឆូ ៖ “មើម​ទឹង​មៃ​ងើយ​ដាស​ផូង​ប៝ន​លាន​ងើយ​នតឹត​កើត​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “អា​ល៝រ​នើស​នាវ​ខ្លៃ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស​ហោម​នទ៝ប់​មពោន អាបៃ​អ្យា​កោរាញ​ឞ្រាស​អ៝ន់​មា​ខាន់​អៃ​មៃ​គឹត​វ៝ត់​នទើ​អី​នៃ។ ល៝ង់​ខាន់​ពាង់​កោរាញ​ឞ្រាស​មោ​អ៝ន់។ ");
INSERT INTO cmok_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ឞូ​ម៝ស​អី​លែៈ​គែស កោរាញ​ឞ្រាស​កើយ​នត៝ប​អ៝ន់​មា​ពាង់​ជឹត ជេសរី​ឞូនុយ្ស​អី​នៃ​គែស​អ៝ក់​រាមែស​លែរ តីស​មា​ឞូ​ម៝ស​អី​មោ​គែស កោរាញ​ឞ្រាស​ឆ៝ៈ​រាហ្វាត់​លើយ​ទឹង​លែៈ​នទើ​អី​ពាង់​លែៈ​គែស ឞ៝ល​លាស​ដេៈ​កាដោយ។ ");
INSERT INTO cmok_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","កើត​នទ្រី​ទឹង​គ៝ប់​ងើយ​មា​ខាន់​ពាង់​ងើយ​នតឹត កើត​នទ្រី​ឞ៝ល​លាស​ខាន់​ពាង់​អ្វាញ់​នទើ​គ៝ប់​ជាន​ក៝ៈ​មោ​វ៝ត់​នទើ​ខ្លៃ​នាវ​អី​នៃ ខាន់​ពាង់​តាង់​នាវ​គ៝ប់​ងើយ​ក៝ៈ​មោ​អ្យាត់​មោ​វ៝ត់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","នាវ​អី​អ្យា​ជេង​តឹម​ទី​ដាស​នាវ​អេឆាយ ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​លាស​មា​ខាន់​ពាង់៖ «ខាន់​អៃ​មៃ​តាង់​ងាន់ តីស​មា​មោ​វ៝ត់។ ខាន់​អៃ​មៃ​អ្វាញ់​ងាន់ តីស​មា​មោ​អោស​ឆៃ​មោ​អោស​វ៝ត់‌ ");
INSERT INTO cmok_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","យ៝រ​លាស​នូយ្ស​នហ៝ម់​ផូង​ប៝ន​លាន​អ្យា​ទាង់​ក៝​ងាន់ តោរ​ខាន់​ពាង់​មឞ៝ល់។ ខាន់​ពាង់​ញេប​លើយ​មាត់ មោ​អ៝ន់​ឆៃ‌ តោរ​មោ​អ៝ន់​តាង់ នាវ​មឹន​គឹត​ឞ្លាវ​មោ​អ៝ន់​វ៝ត់ នទ្រី​ខាន់​ពាង់​មោ​ព្លឹ​ឆឹត​មា​គ៝ប់‌ ជេសរី​គ៝ប់​មោ​អុច​ជាន​ឞាស​ខាន់​ពាង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","យើន​មា​អ្វែស​មអាក​ងាន់​មា​ខាន់​អៃ​មៃ យ៝រ​លាស​ត្រោម​មាត់​ខាន់​អៃ​មៃ​លែៈ​ឆៃ តោរ​ខាន់​អៃ​មៃ​លែៈ​តាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ គែស​អ៝ក់​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស នទ្រែល​មា​អ៝ក់​ឞូនុយ្ស​ឆ៝ង់​កាល់​អែ​នើស​អុច​ឆៃ​ងាន់​ទឹង​លែៈ​នាវ​អី​ខាន់​អៃ​មៃ​ឆៃ​អាបៃ​អ្យា តីស​មា​មោ​អោស​ឆៃ ខាន់​ពាង់​អុច​តាង់​ងាន់​នាវ​អី​ខាន់​អៃ​មៃ​តាង់​អ្យា តីស​មា​មោ​អោស​តាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“លាស​នទ្រី​អ៝ន់​ខាន់​អៃ​មៃ​អ្យាត់​ហ៝ម់ ម៝ស​នាវ​ខ្លៃ​ងើយ​នតឹត​មា​ឞូនុយ្ស​ឆូយ​គារ់​នតីល​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","លាស​គែស​ឞូនុយ្ស​តាង់​នាវ​ងក៝ច​មា​នាវ​កោរាញ​ឞ្រាស​អុច​ម៝ត់​អ្វាញ់​ឞូនុយ្ស តីស​មា​មោ​វ៝ត់​អោស អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​ហាន់​ឆ៝ៈ​នតុង​ទឹង​លែៈ​នទើ​អី​លែៈ​គែស​លាប់​តា​នូយ្ស​នហ៝ម់​ពាង់ នាវ​អី​នៃ​តឹម​ឞាន​មា​គារ់​តុប​តា​ត្រ៝ង។ ");
INSERT INTO cmok_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ឞូនុយ្ស​អី​តឹម​ឞាន​មា​គារ់​តុប​តា​នែស​លុ ពាង់​តាង់​នាវ​កោរាញ​ឞ្រាស ជេសរី​អ្យាត់​រ៝​រាម់​មអាក​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ហ៝ន​អ្វែស​ទូ​ប្ល៝ត់​ទើម នាវ​កោរាញ​ឞ្រាស​មោ​អោស​ហ៝ន​រែស​តា​នូយ្ស​នហ៝ម់​ពាង់​នើម នទ្រី​ត៝ត់​គែស​នាវ​ជេរ​អេងៗ មោ​លាស​ឞូ​ជាន​ជេរ​យ៝រ​មា​នាវ​កោរាញ​ឞ្រាស ពាង់​មអារ់​រ៝​នាវ​ញឆីង។ ");
INSERT INTO cmok_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ឞូនុយ្ស​អី​តឹម​ឞាន​មា​គារ់​នតីល​តុប​តា​នែស​ល៝ក ពាង់​តាង់​នាវ​ងើយ​កោរាញ​ឞ្រាស តីស​មា​តា​នូយ្ស​នហ៝ម់​ពាង់​ងក្ល៝ន់​រាវៃ​ហោ​ងាន់​មា​នាវ​រេស​តា​នែស​នតូ​អ្យា អុច​រាវាន​កើញ​គែស​ទ្រាប់​នទើ ជេសរី​នាវ​អី​នៃ​ពូត​បារ់​នាវ​កោរាញ​ឞ្រាស​អី​នៃ​មោ​អ៝ន់​ត៝ត់​ព្លៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ល៝ង់​គារ់​អី​តុប​តា​នែស​អ្វែស តឹម​ឞាន​មា​ឞូនុយ្ស​តាង់​នាវ​កោរាញ​ឞ្រាស នហ៝​មា​វ៝ត់​នាវ​ខ្លៃ ជេសរី​ត៝ត់​គែស​ព្លៃ គែស​ទូ​ហ្វេ​ឞូនុយ្ស​រី​ទូ​គារ់​ជេង​គែស ១០០‌ ទូ​គារ់​ជេង​គែស ៦០‌ ឞូនុយ្ស​អាបាៈ​រី​ជឹត​ទូ​គារ់​ជេង​គែស ៣០ ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ឞ្រាស​យេឆូ ​ងើយ​នតឹត​ទូ​នតីល​នាវ​ជឹត​អ៝ន់​មា​ឞូ​កើត​នអា៖ “នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស ជេង​តឹម​ឞាន​មា​ទូ​ហ្វេ​ឞូនុយ្ស​ហាន់​ឆូយ​គារ់​នតីល​ឞា​អ្វែស​តា​មីរ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","យើន​មា​ត៝ត់​ឞូ​លែៈ​ឞិច គែស​ទូ​ហ្វេ​ឞូនុយ្ស​រាលាង់​ដាស​ពាង់ ហាន់​ឆូយ​គារ់​នតីល​ឞា​ឞ្រាក​តា​មីរ​អី​នៃ​ដ៝ង់ ជេសរី​ទូ​រ៝ស​ក្លាក់។ ");
INSERT INTO cmok_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ត៝ត់​មា​ឞា​លែៈ​ហ៝ន​លែៈ​ជេង​លោស​មឞោន ឞា​ឞ្រាក​អី​នៃ​ហ៝ន​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ជេសរី​ផូង​ទឹក​អី​តើម​មីរ​អី​នៃ​ហាន់​មឞើស​អា​កោរាញ​ខាន់​ពាង់៖ «អើ​កោរាញ នោក​មៃ​ឆូយ​គារ់​នតីល​តា​មីរ​មៃ​នើស គារ់​នតីល​ឞា​អ្វែស។ លាស​នទ្រី​ឞើស​តាៈ​លោស​ឞា​ឞ្រាក​អ្យា?» ");
INSERT INTO cmok_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","កោរាញ​អី​នៃ​លាស៖ «គែស​ឞូនុយ្ស​រាលាង់​រ៝​ហាន់​ឆូយ​អី​រី»។ ផូង​ទឹក​អើស​មា​ពាង់៖ «លាស​នទ្រី​មៃ​អុច​អ៝ន់​ហេន​រោក​លើយ​ឞើស?» ");
INSERT INTO cmok_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","កោរាញ​ពាង់​អើស៖ «មោ​ខាច់​អោស លាស​ខាន់​មៃ​រោក ក្លាច​លាស​គែស​រោក​នអ៝ប់​មា​ឞា។ ");
INSERT INTO cmok_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","អុច​រ៝ង​អ៝ន់​ពាង់​ហ៝ន​នទ្រែល​ហ៝ៈ ត៝ត់​ខៃ​រែក​រី​តៃ គ៝ប់​មរា​មឞើស​មា​ឞូនុយ្ស​រែក ដាៈ​ខាន់​ពាង់​រែក​ល៝រ​ឞា​ឞ្រាក​ចាប់​រាគូម​ពូរ​លើយ​តា​អុញ ជេសរី​ទឹង​រែក​រាគូម​ឞា​ងាន់​តោស​ព្រាប់​តា​ជៃ​គ៝ប់​នើម»”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ឞ្រាស​យេឆូ ​ងើយ​នតឹត​អ៝ន់​មា​ខាន់​ពាង់​ទូ​នតីល​នាវ​ជឹត៖ “នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស​តឹម​ឞាន​មា​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ហាន់​ឆូយ​គារ់​ទូ​នតីល​ទុត​ជេៈ​តា​មីរ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ឞ៝ល​លាស​គារ់​នតីល​អី​នៃ​ជេៈ​រាលាវ​ឞូ​ងាន់​ដាស​មា​ទឹង​លែៈ​គារ់​នតីល​អេងៗ ត៝ត់​ពាង់​លែៈ​ហ៝ន ពាង់​ក្វ៝ង់​រាលាវ​តើម​ឆី​អេងៗ​តា​មីរ ជេង​ទូ​មល៝ម់​តើម​ឆី​ក្វ៝ង់​ងាន់ គែស​ឆ្យុម​ទ្រ៝ម់​គុ​ជាន​រាឆ្វាន់​តា​ងគីង​នថាន​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ឞ្រាស​យេឆូ ​ងើយ​នតឹត​ទូ​នតីល​នាវ​ជឹត៖ “នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស​ជេង​តឹម​ឞាន​មា​នទ្រូយ​អី​ដេៈ ទូ​ហ្វេ​ឞូ​អូរ​ឆ៝ៈ​ព៝ត​លាយ​នទ្រែល​រានីស​ឞា​ព្រាង់ ​អ៝ក់ ពាង់​តេៈ​ទាក​មព្យាច់​អ៝ន់​តឹម​លាប់​ឞាល់​គៃ​មា​ជាន​នុមពាង់។ ត៝ត់​ជ៝ៈ​ទូ​ម៝ង​ឞារ​ម៝ង​ឞើស​កើយ​នៃ ឞ៝ល​លាស​ពាង់​តេៈ​នទ្រូយ​ដេៈ​កាដោយ ហោម​ទឹង​លែៈ​នទើ​អី​នៃ​លើ​មា​ក្វ៝ង់​លើ​មា​ក្វ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ទឹង​លែៈ​នាវ​អី​នៃ​ឞ្រាស​យេឆូ ​ងើយ​អ៝ន់​មា​ផូង​ប៝ន​លាន ពាង់​ងើយ​នតឹត​ទាទេ ពាង់​មោ​គែស​អោស​ងើយ​នាវ​លាស​ពាង់​មោ​ងើយ​នតឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ពាង់​ងើយ​កើត​នៃ គៃ​មា​តឹម​ទី​ដាស​នាវ​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​លាស​កើត​នអា៖ «គ៝ប់​មរា​ងើយ​មា​ខាន់​ពាង់​មា​នាវ​ងើយ​នតឹត‌ គ៝ប់​មឞើស​ងក៝ច​នាវ​នទ៝ប់​មពោន​ឞើស​នតើម​ឆាអើម​អ៝ន់​ខាន់​ពាង់​គឹត»។ ");
INSERT INTO cmok_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ជេសរី​ឞ្រាស​យេឆូ ​ឆឹត​ឞើស​ផូង​ប៝ន​លាន​នៃ​លាប់​តា​ទូ​មល៝ម់​ជៃ ផូង​អ៝ស​ម៝ន​ហាន់​អោប​ពាង់៖ “ទាន់​មៃ​មឞើស​អ៝ន់​ហេន ម៝ស​នាវ​ខ្លៃ​ងើយ​នតឹត​មា​ឞា​ឞ្រាក​តា​មីរ​អី​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ឞ្រាស​យេឆូ ​មឞើស​មា​ខាន់​ពាង់៖ “នើម​អី​ឆូយ​គារ់​នតីល​ឞា​អ្វែស នតឹត​តឹម​ឞាន​មា​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","មីរ​អី​នៃ​នតឹត​តឹម​ឞាន​មា​នែស​នតូ​អ្យា។ គារ់​នតីល​ឞា​អ្វែស​នតឹត​តឹម​ឞាន​មា​ផូង​ឞូនុយ្ស​អី​លែៈ​គុ​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់។ ឞា​ឞ្រាក​អី​នៃ​នតឹត​តឹម​ឞាន​មា​ផូង​ឞូនុយ្ស​អី​អ្យាត់​នាវ​កោរាញ​មពោល​ឞ្រាស​អ្យើស។ ");
INSERT INTO cmok_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ឞូនុយ្ស​រាលាង់​ឆូយ​ឞា​ឞ្រាក​អី​នៃ​នតឹត​តឹម​ឞាន​មា​កោរាញ​មពោល​ឞ្រាស​អ្យើស។ ខៃ​រែក​នតឹត​តឹម​ឞាន​មា​នារ​ងគ្លែៈ​ទុត​នែស​នតូ​តៃ។ នើម​នាក់​រែក​នតឹត​តឹម​ឞាន​មា​ផូង​តោង​ពារ់។ ");
INSERT INTO cmok_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ឞូ​រែក​ឞា​ឞ្រាក​ឆូ​លើយ​តា​អុញ លាស​នទ្រី​តា​នារ​ងគ្លែៈ​ទុត​នែស​នតូ​តៃ​ពាង់​គែស​តឹម​ឞាន​កើត​នៃ​ដ៝ង់៖ ");
INSERT INTO cmok_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​មរា​ដាៈ​តោង​ពារ់​គ៝ប់​នើម​ហាន់​ញុប​ទឹង​លែៈ​ផូង​ជាន​អ្យើស នទ្រែល​មា​ទឹង​លែៈ​ផូង​លែវ​ឞូ​ជាន​តីស ងលោស​ខាន់​ពាង់​ឞើស​នាវ​គ៝ប់​ម៝ត់​អ្វាញ់‌ ");
INSERT INTO cmok_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ងក្លាច់​លើយ​ខាន់​ពាង់​តា​នទ្រូង​អុញ តា​នតុក​នៃ​គែស​នាវ​ញហ្យាង់​ញុម នទ្រែល​មា​រាច្យាត់​ឆេក។ ");
INSERT INTO cmok_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","យើន​មា​ឞូនុយ្ស​ឆ៝ង់​គែស​នាវ​ច្រាត​អាង​តឹម​ឞាន​មា​នារ​ងាន់ គុ​នទ្រែល​នាវ​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​ពាង់​នើម​ម៝ត់​អ្វាញ់។ ឞូ​ម៝ស​តាង់​នាវ​គ៝ប់​ងើយ​អ្យា អ៝ន់​ពាង់​មឹន​អេង​តា​ឆាក់​ពាង់​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​នតឹត​តឹម​ឞាន​មា​ឞូ​ត៝ប់​នទ៝ប់​ទ្រាប់​នទើ​ខ្លៃ​តា​មីរ។ គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ឆៃ​ទ្រាប់​នទើ​ខ្លៃ​អី​នៃ ពាង់​ពោន​រ៝ ពាង់​រាម់​មអាក​ហោ​ងាន់ ជេសរី​ពាង់​ឆឹត​តាច់​ទឹង​លែៈ​នទើ​ពាង់​គែស គៃ​មា​ឆ៝ៈ​ព្រាក់​រាវាត់​នែស​មីរ​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​នតឹត​តឹម​ឞាន​មា​ទូ​ហ្វេ​ឞូនុយ្ស​ហាន់​ជ៝យ​រាវាត់​ពិច​មល៝ម់​(លុ​គ្ល៝)​អី​ខ្លៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ត៝ត់​ពាង់​លែៈ​ឆៃ​ពិច​ទូ​មល៝ម់​(លុ​គ្ល៝)​ទុត​ខ្លៃ ពាង់​ឆឹត​តាច់​ទឹង​លែៈ​នទើ​ពាង់​គែស គៃ​មា​រាវាត់​ពិច​(លុ​គ្ល៝)​ខ្លៃ​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស​នតឹត​តឹម​ឞាន​មា​ម៝ង​អី​ឞូ​ទ្រាង់​តា​ទាក​វាច់​ទាក​វារ់​គែស​កា​អាប់​នតីល​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ត៝ត់​មា​លែៈ​គែស​ឞេង​ម៝ង​រី ឞូ​អូយ្ស​ហាវ​អា​កើស​អ្យា ជេសរី​គុ​ទោញ​កា​អី​អ្វែសៗ​តេៈ​តា​ត្រោម​ឆាស កា​អី​មោ​អ្វែស​មអារ់​លើយ។ ");
INSERT INTO cmok_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","តា​នារ​ងគ្លែៈ​ទុត​នែស​នតូ​តៃ​តឹម​ឞាន​មា​កើត​នៃ​ដ៝ង់។ ផូង​តោង​ពារ់​ហាន់​តឹម​ងខាស​ផូង​តីស​លោស​ឞើស​ផូង​ឆ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ជេសរី​ខាន់​ពាង់​ងក្លាច់​ផូង​តីស​តា​នទ្រូង​អុញ តា​នតុក​នៃ​គែស​នាវ​ញហ្យាង់​ញុម នទ្រែល​មា​រាច្យាត់​ឆេក”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ឞ្រាស​យេឆូ ​អោប​ផូង​អ៝ស​ម៝ន​ពាង់៖ “អាស​ខាន់​អៃ​មៃ​គឹត​វ៝ត់​ដ៝ង់​នាវ​ទឹង​លែៈ​អ្យា?” ខាន់​ពាង់​អើស៖ “វ៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ឞ្រាស​យេឆូ ​លាស​តៃ​មា​ខាន់​ពាង់៖ “ទឹង​លែៈ​ផូង​នើម​នតី​នាវ​វៃ​ឞ៝ន់ អី​នតី​តឹង​នាវ​គ៝ប់​នតី​មា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស ពាង់​តឹម​នតឹត​តឹម​ឞាន​មា​ទូ​ហ្វេ​ឞូនុយ្ស​តើម​ជៃ ពាង់​ងលោស​ទឹង​លែៈ​ទ្រាប់​នទើ​ខ្លៃ​ពាង់​នើម​ឞើស​នតុក​ពាង់​ព្រាប់ នអ៝ប់​មា​នទើ​អើម​នទើ​មហែ”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ជេស​ឞ្រាស​យេឆូ ​ងើយ​នតឹត​កើត​នៃ ជេសរី​ពាង់​ទូ​លោស​ឞើស​នតុក​នៃ‌ ");
INSERT INTO cmok_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ហាន់​តា​ប៝ន​នាឆារែត ​អី​ប៝ន​ពាង់​នើម ពាង់​នតុម​នតី​ឞូ​តា​ញីស​រាបុន​ខាន់​ពាង់​នើម។ ទឹង​លែៈ​ឞូនុយ្ស​គែស​នាវ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់ ជេសរី​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ “ហៃ! ឞើស​តាៈ​គែស​នាវ​មឹន​គឹត​ឞ្លាវ​ពាង់​អី​នៃ នទ្រែល​មា​នាវ​ទើយ ទើយ​ជាន​នាវ​ខ្លៃ​នៃ​ហៃ? ");
INSERT INTO cmok_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ពាង់​អី​នៃ​អី​ក៝ន​ឞូនុយ្ស​នាក់​ជាន​ការ​តើម​ឆី​ទើម មេៈ​ពាង់​រាញា​មារី  អ៝ស​ឞូ​ក្លោ​ពាង់​រាញា​យាកើ យោឆែប ឆីមោន  នទ្រែល​មា​យូដាស ‌ ");
INSERT INTO cmok_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ទឹង​លែៈ​អី​អ៝សៗ​ឞូ​អូរ​ពាង់​គុ​នទ្រែល​ឞ៝ន់​តា​ប៝ន​អ្យា​ដ៝ង់។ លាស​នទ្រី​ឞើស​តាៈ​នាវ​គឹត​នាវ​ទើយ​ពាង់​អី​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","នទ្រី​ទឹង​ខាន់​ពាង់​ជី​នូយ្ស​ក៝ៈ​នូយ្ស​ក៝ៈ​នហ៝ម់​មោ​អុច​អ្យាត់​នាវ​ពាង់។ ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ទី​ងាន់! មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស ឞូ​យើក​តា​ទឹង​លែៈ​នតុក យើន​មា​ឞូ​មឺច​ខាន់​ពាង់​តា​ឞ្រី​ខាន់​ពាង់​នើម នទ្រែល​មា​តា​ជៃ​ខាន់​ពាង់​នើម​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","តា​នតុក​នៃ​ឞ្រាស​យេឆូ ​ជាន​នទើ​អ្វែស​នទើ​ខ្លៃ​មោ​អោស​អ៝ក់ យ៝រ​លាស​ឞូ​មោ​អោស​ញឆីង​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","នោក​នៃ​ហេរោត-​អ៝ន់តីពាស ​អី​កោរាញ​ម៝ត់​អ្វាញ់​ឞ្រី​កាលីលេ ​តាង់​លឺ​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ពាង់​លាស​មា​ផូង​កើល​ជាន​ការ​មា​ពាង់៖ “ឞូនុយ្ស​អី​នៃ​យោហាន-​បាប់តែម ​អី​គ៝ប់​លែៈ​ងខឹត ពាង់​លែៈ​ទ៝ក់​រេស​តៃ នទ្រី​ទឹង​ពាង់​អី​នៃ​គែស​នាវ​ទើយ​ជាន​លែៈ​នាវ​កើត​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","អា​ល៝រ​នើស​ហេរោត ​ពីត​ឆ៝ៈ​អូរ​អី​អ៝ស​ពាង់​រាញា​ផីលីប  ជេសរី​ពាង់​ឆ៝ៈ​អី​អូរ​ផីលីប ​រាញា​ហេរោដៀស ​ជាន​អូរ។ ជេស​គឹត​នទ្រី​យោហាន-​បាប់តែម ​លាស​ហេរោត ៖ “មោ​អោស​ទី​ដាស​នាវ​វៃ​ឞ៝ន់ វែរ​ឆ៝ៈ​អូរ​អ៝ស​ជាន​អូរ​មៃ”។ ជេសរី​ហេរោត ​ដាៈ​តាហែន​ញុប​យោហាន-​បាប់តែម ​ក៝ត់​ក្រុង​តា​នទ្រូង​រី គៃ​មា​អី​អូរ​ពាង់​នៃ​រាម់​មអាក។ ");
INSERT INTO cmok_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","កើត​នទ្រី​ទឹង​ហេរោត ​អុច​ងខឹត​យោហាន-​បាប់តែម  យើន​មា​ពាង់​មោ​អោស​ឞាញ់ ក្លាច​ផូង​ប៝ន​លាន យ៝រ​មា​ផូង​ប៝ន​លាន​អ្វាញ់​យោហាន-​បាប់តែម ​ជេង​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស នទ្រី​ទឹង​ហេរោត ​ញុប​ងក្រុង​ពាង់​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","តា​នារ​ញេត​បុន​កាស​គឹត​នារ​ទែស​ហេរោត  ក៝ន​ឞូ​អូរ​ហេរោដៀស ​លាប់​រ៝ម់​ឞើស​នាប់​ផូង​ឞូ​នាច់​គុ​រាបុន​តា​នៃ ជាន​អ៝ន់​ហេរោត ​រាម់​ងាន់‌ ");
INSERT INTO cmok_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ត៝ត់​មា​ពាង់​ត៝ន​អ៝ន់​នទើ​មា​ក៝ន​ឞូ​អូរ​អី​នៃ ម៝ស​នទើ​ក៝ន​ឞូ​អូរ​អី​នៃ​ទាន់ ពាង់​អ៝ន់​ទាទេ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ក៝ន​ឞូ​អូរ​អី​នៃ​អ្យាត់​នាវ​មេៈ​ពាង់​ដាៈ ពាង់​ទាន់​មា​ហេរោត ​កើត​នអា៖ “គ៝ប់​ទាន់​ឞោក​យោហាន-​បាប់តែម ​អ៝ន់​មា​គ៝ប់ តេៈ​តា​កាលើ​ងាន​ថាង​តា​អ្យា​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ជេស​តាង់​នាវ​ទាន់​អី​នៃ ហេរោត ​នទុយ្ស​តោរ​ហោ​ងាន់ យើន​មា​ពាង់​ដាៈ​ឞូ​ជាន​កើត​នាវ​ក៝ន​ឞូ​អូរ​អី​នៃ​ទាន់ យ៝រ​មា​កាដាច់​លែៈ​លាន់​ត៝ន​ឞើស​នាប់​ផូង​ឞូ​នាច់​អី​គុ​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ពាង់​ដាៈ​ឞូ​ហាន់​ក៝ស​ត៝ង​ក៝​យោហាន-​បាប់តែម ​តា​ត្រោម​នទ្រូង​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ឞូ​ឆ៝ៈ​អី​ឞោក​តេៈ​កាលើ​ងាន​ថាង ជេសរី​នទឹ​អ៝ន់​មា​ឞូ​ទ្រោស​នៃ ឞូ​ទ្រោស​អី​នៃ​ញអោត​នទឹ​អ៝ន់​មា​អី​មេៈ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ជេសរី​ផូង​អ៝ស​ម៝ន​យោហាន-​បាប់តែម ​ហាន់​ឆ៝ៈ​ឆាក់​ពាង់​ហាន់​ត៝ប់ ជេសរី​ហាន់​មឞើស​ងក៝ច​នាវ​អី​នៃ​អ៝ន់​មា​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ត៝ត់​ឞ្រាស​យេឆូ ​តាង់​នាវ​អី​នៃ ជេសរី​ពាង់​លោស​ឞើស​នតុក​នៃ​ញច៝​ទូក​នទ្រែល​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​តា​ទូ​នតុក​បាស​មា​ឞូ។ យើន​មា​ផូង​ប៝ន​លាន​លែៈ​តាង់ ខាន់​ពាង់​លោស​តាៈ​ឞើស​ប៝ន​អេងៗ ហាន់​ឞ្រោៈ​តឹង​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","នោក​ឞ្រាស​យេឆូ ​ជុរ​ឞើស​ទូក​នៃ​ឆៃ​ផូង​ប៝ន​លាន​អ៝ក់​មពឺម​ងាន់។ ពាង់​គែស​នាវ​យោៈ​នអាច​មា​ខាន់​ពាង់​ងាន់ ជេសរី​ពាង់​ជាន​ឞាស​ឞូនុយ្ស​គែស​នាវ​ជី​ក្វែត​តា​ផូង​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ត៝ត់​ឞើយ​មា​ទេស​នារ មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​មឞើស​មា​ឞ្រាស​យេឆូ ​លាស៖ “តា​អ្យា​នតុក​រាទាស​ងាយ​ឞើស​ប៝ន មោ​អោស​គែស​នទើ​ឆា នារ​លែៈ​ឞើយ​ញ៝ប់​ដ៝ង់។ មៃ​ដាៈ​ផូង​ប៝ន​លាន​ព្លឹ​ឆឹត​ជ៝យ​រាវាត់​នទើ​មា​ឆោង​ឆា​រ៝ៈ​ប៝ន​អី​ទាច់ៗ​អ៝យ​តា​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","យើន​មា​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “មោ​ខាច់​អោស​អ៝ន់​ឞូ​ជ៝យ​រាវាត់​នទើ ខាន់​អៃ​មៃ​អ៝ន់​ឞូ​ឆោង​ឆា​ហែស”។ ");
INSERT INTO cmok_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","មពោល​អ៝ស​ម៝ន​អើស​មា​ពាង់៖ “ហេន​គែស​ព្រាម់​មល៝ម់​នុមពាង់ នទ្រែល​មា​ឞារ​មល៝ម់​កា​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ញអោត​លែវ​នុមពាង់ នទ្រែល​មា​កា​អី​នៃ​អា​គ៝ប់​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ជេសរី​ឞ្រាស​យេឆូ ​ដាៈ​ផូង​ប៝ន​លាន​គុ​កាលើ​រេប​ញឆែ ពាង់​ឆ៝ៈ​ព្រាម់​មល៝ម់​នុមពាង់ នទ្រែល​មា​ឞារ​មល៝ម់​កា​រី ពាង់​ងគើរ​មាត់​ជឹត​លើ​មឞើស​ឆើម​នទើ​ឆោង​ឆា​អី​នៃ​មា​កោរាញ​ឞ្រាស។ លោច​ជេស​ពាង់​គិច​នុមពាង់​អី​នៃ​នទឹ​អ៝ន់​អ៝ស​ម៝ន មពោល​អ៝ស​ម៝ន​ពាៈ​ផូង​ប៝ន​លាន​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ជេស​តឹម​ពាៈ​នទើ​ឆា​អី​រី ទឹង​លែៈ​ឞូនុយ្ស​គុ​ឆា​តា​នៃ​ហើម​ទាទេ ជេសរី​មពោល​អ៝ស​ម៝ន​រាគូម​នុមពាង់ នទ្រែល​មា​កា​អី​ហោម​រាមែស​នៃ​គែស ១២ ឆាស។ ");
INSERT INTO cmok_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ផូង​ប៝ន​លាន​អី​ឆា​នៃ​នើស​កើប​អី​ឞូ​ក្លោ​ទើម​អ៝ក់ ៥០០០ នុយ្ស មោ​កើប​អោស​ផូង​ឞូ​អូរ នទ្រែល​មា​ក៝ន​ឆែ។ ");
INSERT INTO cmok_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ទូ​នទ៝ម់​តា​នៃ ឞ្រាស​យេឆូ ​ដាៈ​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​ល៝រ​ញច៝​ទូក​មពែស​ជឹត​កាល់​តី​រី ជេសរី​ពាង់​ដាៈ​ផូង​ប៝ន​លាន​ទឹង​លែៈ​អី​គុ​តា​នៃ​ព្លឹ​ឆឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ជេស​ដាៈ​នទ្រី ឞ្រាស​យេឆូ ​ហាវ​តា​កាលើ​យោក​ទូ​ហ្វេ​អេង​គៃ​មា​មឞើស​ឆើម។ ត៝ត់​ឞ្រី​លែៈ​មាង់​ពាង់​ហោម​គុ​ទូ​ហ្វេ​អេង​តា​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","នោក​នៃ​ទូក​លែៈ​តា​ងក្លាង​ទាក​ងលៅ​ក្វ៝ង់ ងាយ​ឞើស​កើស គែស​ទាក​រាឞុស​ទុត​ទាង់ យ៝រ​លាស​ខាន់​ពាង់​ហាន់​រាលឹ​ឞើស​ចោង​ឆ្យាល។ ");
INSERT INTO cmok_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ត៝ត់​មា​លែៈ​ទូ​តឹ​នទ្រាវ​អ្យារ់ ឞ្រាស​យេឆូ ​ហាន់​តឹង​ផូង​អ៝ស​ម៝ន​ពាង់ពាង់​ឞ្រោៈ​តា​កាលើ​ទាក។ ");
INSERT INTO cmok_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ត៝ត់​មា​ឆៃ​ពាង់​ឞ្រោៈ​តា​កាលើ​ទាក​ងលៅ​នៃ មពោល​អ៝ស​ម៝ន​ក្លាច​ញឆ៝រ់​ងាន់ ខាន់​ពាង់​លាស៖ “ច្យាក​ញហូ​ឞ៝ន់​មេៈ!” ខាន់​ពាង់​នតែរ​ទ្រើវ។ ");
INSERT INTO cmok_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","យើន​មា​ឞ្រាស​យេឆូ ​លាស​ខាន់​ពាង់​រ៝៖ “លើយ​ក្លាច​អោស អ៝ន់​នូយ្ស​នហ៝ម់​ឞាញ់ គ៝ប់​យា!” ");
INSERT INTO cmok_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ពេត្រោស ​លាស​មា​ឞ្រាស​យេឆូ ៖ “អើ​កោរាញ លាស​មៃ​ងាន់ អ៝ន់​គ៝ប់​ឞ្រោៈ​កាលើ​ទាក​ហាន់​អា​មៃ​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “វាច់​តា​អ្យា​ហ៝ម់!” ជេសរី​ពេត្រោស ​ជុរ​ឞើស​លើ​ទូក ឞ្រោៈ​កាលើ​ទាក​ហាន់​អា​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","យើន​មា​ត៝ត់​ពាង់​ឆៃ​ឆ្យាល​ហោ​អីរ នតើម​ក្លាច​ងាន់ ពាង់​នតើម​ង៝ម់​តា​ទាក នហ៝​មា​នតែរ​ក្វាល់​ឞ្រាស​យេឆូ ៖ “អើ​កោរាញ កើល​គ៝ប់​អើ!” ");
INSERT INTO cmok_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ឞ្រាស​យេឆូ ​នតា​តី​ញុប​តី​ពាង់​រ៝ នអ៝ប់​មា​លាស៖ “អើ​ឞូនុយ្ស​គែស​នាវ​ញឆីង​ដេៈ មើម​មៃ​មោ​គុ​ន៝ប់​តា​នាវ​ញឆីង?” ");
INSERT INTO cmok_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​ពេត្រោស ​ហាវ​តា​កាលើ​ទូក ឆ្យាល​ឞាស​រាង៝ន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ផូង​គុ​ញច៝​តា​កាលើ​ទូក​រី យើក​មឞាស​ឞ្រាស​យេឆូ  នអ៝ប់​មា​លាស​ពាង់៖ “មៃ​ក៝ន​កោរាញ​ឞ្រាស​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់ ហាន់​ត៝ត់​កាល់​តី​ទាក ត៝ត់​តា​ឞ្រី​កេនេឆារែត ។ ");
INSERT INTO cmok_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ឞូនុយ្ស​តា​ឞ្រី​នៃ​នាល់​ពាង់​រ៝ ជេសរី​ខាន់​ពាង់​ហាន់​មឞើស​ងក៝ច​រ៝ៈ​ជៃ​លាម​ឞ្រី​នៃ។ ទឹង​លែៈ​ឞូនុយ្ស​អី​គែស​នាវ​ជី​ក្វែត ឞូ​ញជុន​អា​ពាង់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ខាន់​ពាង់​ឞ៝ញ​ឞ្រាស​យេឆូ ​ទាន់​ពាស​ពាង់ ឞ៝ល​លាស​ពាស​តា​ច្យាង់​អាវ​ពាង់​ទើម​កាដោយ ឞូ​ម៝ស​អី​គែស​ពាស​ឞាស​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ជេសរី​ផូង​ផារីឆី  នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​អី​តាៈ​ឞើស​ប៝ន​យេរូឆាលឹម  ហាន់​អោប​ឞ្រាស​យេឆូ ៖ ");
INSERT INTO cmok_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ម៝ស​ឆី​កោៈ​មពោល​អ៝ស​ម៝ន​មៃ​មោ​ជាន​តឹង​នាវ​វៃ​អើម​ឞើស​កាល់​អែ យ៝រ​លាស​ខាន់​ពាង់​ឆោង​អេ​ហ៝ៈ​រាវ​តី​ល៝រ?” ");
INSERT INTO cmok_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “លាស​នទ្រី​ខាន់​មៃ ម៝ស​ឆី​កោៈ​មោ​ជាន​តឹង​នាវ​កោរាញ​ឞ្រាស​ដាៈ ងខើង​មា​ជាន​តឹង​នាវ​វៃ​ខាន់​មៃ​នើម? ");
INSERT INTO cmok_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","យ៝រ​លាស​កោរាញ​ឞ្រាស​លែៈ​លាស​កើត​នអា៖ «អ៝ន់​ខាន់​អៃ​មៃ​យើក​ហ៝ម់​មា​មេៈ​ឞឹ» ជេសរី «ឞូ​ម៝ស​រាក​ឆ្វាយ​មា​មេៈ​ឞឹ​ពាង់​នើម ពាង់​អី​នៃ​គែស​ទោយ្ស​ត៝ត់​ឞូ​ងខឹត​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","យើន​មា​ខាន់​មៃ​លាស ឞូ​ម៝ស​លាស​មា​មេៈ​ឞឹ​ពាង់​នើម៖ «ទឹង​លែៈ​នទើ​អី​ទី​មា​គ៝ប់​អ៝ន់​មា​ខាន់​អៃ​មៃ លែៈ​គ៝ប់​ត៝ន​ញហើរ​មា​កោរាញ​ឞ្រាស»។ ");
INSERT INTO cmok_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","លាស​នទ្រី​ឞូនុយ្ស​អី​នៃ​មោ​ហោម​អោស​ខាច់​យើក​មា​មេៈ​ឞឹ​ពាង់។ កើត​នទ្រី​ខាន់​មៃ​ងគ្រ៝ស​លើយ​នាវ​ងើយ​កោរាញ​ឞ្រាស ញអោត​ងខើង​នាវ​វៃ​ខាន់​មៃ​នើម​ច្រាវ។ ");
INSERT INTO cmok_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ខាន់​មៃ​ឞូនុយ្ស​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម។ ទី​ងាន់​នាវ​អេឆាយ ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ញចីស​លាស​មា​ខាន់​មៃ​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«កោរាញ​ឞ្រាស​លាស៖ «ផូង​ប៝ន​លាន​អ្យា​យើក​មឞាស​គ៝ប់​មា​ឞ៝រ់​មឞូង​ទើម‌ នូយ្ស​នហ៝ម់​ខាន់​ពាង់​គុ​ងាយ​ដាស​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ខាន់​ពាង់​យើក​មឞាស​គ៝ប់​មោ​អោស​គែស​នតីល​ខ្លៃ មោ​អើម​យ៝រ​មា​ខាន់​ពាង់​នតុម​នតី​ឆ៝ៈ​នាវ​វៃ​តាៈ​ឞើស​ឞូនុយ្ស​ទើម យើន​មា​ខាន់​ពាង់​លាស​នាវ​វៃ​អី​នៃ​តាៈ​ឞើស​គ៝ប់​ដាៈ»»”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ជេសរី​ឞ្រាស​យេឆូ ​ក្វាល់​ផូង​ប៝ន​លាន​វាច់​អា​ពាង់ លាស​មា​ខាន់​ពាង់៖ “អើ​អ៝ស​នោ​កោញ​វា អ្យាត់​នាវ​គ៝ប់​លែរ​ងែរ​ប៝ត់ អ៝ន់​គឹត​វ៝ត់​នាវ​អ្យា៖ ");
INSERT INTO cmok_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","មោ​អោស​ទី​នទើ​លាប់​រ៝ៈ​មឞូង​អ៝ន់​ឞូនុយ្ស​ជេង​មោ​ហោម​ក្ល៝ស។ នទើ​អី​អ៝ន់​ឞូនុយ្ស​ជេង​មោ​ហោម​ក្ល៝ស ជេង​នទើ​អី​លោស​តាៈ​ឞើស​មឞូង​ច្រាវ”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","មពោល​អ៝ស​ម៝ន​ហាន់​អា​ឞ្រាស​យេឆូ ​អោប​ពាង់៖ “អាស​មៃ​គឹត​ដ៝ង់​បាស ផូង​ផារីឆី ​ជី​នូយ្ស​មា​មៃ តាង់​នាវ​មៃ​ងើយ​កើត​នៃ​នើស?” ");
INSERT INTO cmok_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ទឹង​លែៈ​តើម​ឆី​អី​មោ​គែស​ឞឹ​គ៝ប់​អី​គុ​តា​កាលើ​ត្រោក​តាម់ ឞូ​រោក​លើយ។ ឞូនុយ្ស​អី​ជី​នូយ្ស​ដាស​គ៝ប់​តឹម​ឞាន​មា​តើម​ឆី​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","លើយ​ទឹង​អោស​រាវៃ​ខាន់​ពាង់ ខាន់​ពាង់​អី​នៃ​តឹម​ឞាន​មា​ឞូនុយ្ស​ចែស​មាត់​តឹម​តេក​នទ្រាង់​ឞូនុយ្ស​ចែស​មាត់។ លាស​អ៝ន់​ឞូនុយ្ស​ចែស​មាត់​តឹម​តេក​នទ្រាង់​ឞូនុយ្ស​ចែស​មាត់ លែៈ​ឞារ​ហៃ​ខាន់​ពាង់​តុប​តា​នតូ​ទាទេ​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ពេត្រោស ​លាស​មា​ឞ្រាស​យេឆូ ៖ “ទាន់​មៃ​មឞើស​នាវ​ងើយ​នតឹត​អី​នៃ​អ៝ន់​ហេន​វ៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ឞ្រាស​យេឆូ ​លាស៖ “អាស​ខាន់​មៃ​អេ​ហ៝ៈ​ដ៝ង់​គឹត​វ៝ត់? ");
INSERT INTO cmok_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","នទើ​អី​លាប់​រ៝ៈ​មឞូង​ឞូនុយ្ស ពាង់​នហ៝ត​លាប់​ត្រោម​នទុល ជេសរី​លោស​អាច់ នទ្រី​បាស? ");
INSERT INTO cmok_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","យើន​មា​នទើ​អី​លោស​តាៈ​ឞើស​មឞូង​ឞូនុយ្ស ពាង់​លោស​តាៈ​ឞើស​នូយ្ស​នហ៝ម់ នទើ​អី​នៃ​ជាន​អ៝ន់​ឞូនុយ្ស​មោ​ហោម​ក្ល៝ស៖ ");
INSERT INTO cmok_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","នាវ​អុច​ជាន​នទើ​អ្យើស នាវ​ងខឹត​ឞូ នាវ​តឹម​ល៝ម់​តឹម​រាលាវ នាវ​តឹម​ទ៝ង់ នាវ​នតុង​ងគ្លាញ់ នាវ​មរោស​រាលាម់ នាវ​ងើយ​ញចើត ជេង​លោស​តាៈ​ឞើស​នូយ្ស​នហ៝ម់​ឞូនុយ្ស​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ទឹង​លែៈ​នទើ​អី​នៃ​ជាន​អ៝ន់​ឞូនុយ្ស​ទឹង​គែស​ជេង​បឹ​បើច អ៝ន់​កោរាញ​ឞ្រាស​មោ​ហោម​រ៝ម។ ឆោង​មោ​គែស​រាវ​តី​ល៝រ មោ​គែស​អោស​អ៝ន់​ឞូនុយ្ស​មោ​ហោម​ក្ល៝ស”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​នតុក​នៃ ហាន់​តា​នតុក​ទាច់​តា​ប៝ន​ក្វ៝ង់​តីរុស  នទ្រែល​មា​ហាន់​ទាច់​តា​ប៝ន​ក្វ៝ង់​ឆីដោន ។ ");
INSERT INTO cmok_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","តា​ឞ្រី​នៃ​គែស​ទូ​ហ្វេ​ឞូ​អូរ​ឞ្រី​កានាអាន ​អី​មោ​ទី​ផូង​អីឆ្រាអែល ​ពាង់​ហាន់​អា​ឞ្រាស​យេឆូ  នហ៝​មា​នតែរ​ក្វាល់​ឞ្រាស​យេឆូ ​មោ​ឞាស​អោស៖ “អើ​កោរាញ! អើ​ក៝ន​ឆៅ​កាដាច់​ដាវីត ! ទាន់​មៃ​យោៈ​នអាច​គ៝ប់​អើ ក៝ន​ឞូ​អូរ​គ៝ប់​ឞ្រាស​អ្យើស​លើស ពាង់​គែស​នាវ​រេស​រាញាល់​ហោ​ងាន់!” ");
INSERT INTO cmok_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","យើន​មា​ឞ្រាស​យេឆូ ​មោ​អើស​អោស ជេសរី​មពោល​អ៝ស​ម៝ន​ហាន់​អា​ឞ្រាស​យេឆូ  ឞ៝ញ​ពាង់៖ “ទាន់​មៃ​ដាៈ​ឞូ​អូរ​អី​នៃ​ទូ​ឞើស​ឞ៝ន់ យ៝រ​លាស​ហោ​ងាន់​ពាង់​នតែរ​តឹង​ឞើស​កើយ​ឞ៝ន់”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ឞ្រាស​យេឆូ ​អើស៖ “កោរាញ​ឞ្រាស​ដាៈ​គ៝ប់​ហាន់ អ៝ន់​គ៝ប់​ជ៝យ​ឞូនុយ្ស​តា​ផូង​អីឆ្រាអែល ​អី​មោ​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម ខាន់​ពាង់​តឹម​ឞាន​មា​ឞែ​ឞ្យាប់​លែៈ​ហ្យើត”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","យើន​មា​ឞូ​អូរ​អី​នៃ​ហាន់​ទាច់​អា​ឞ្រាស​យេឆូ ​ច៝ន​កោម៝ក់​មឞាស​ឞើស​នាប់​ពាង់​រី ជេសរី​លាស៖ “អើ​កោរាញ ទាន់​កើល​គ៝ប់​អើ”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ឞ្រាស​យេឆូ ​អើស៖ “មោ​ទី​អោស លាស​ឆ៝ៈ​នទើ​ឆោង​ឆា​ឞើស​ក៝ន ជេសរី​មអារ់​អ៝ន់​ឆ៝​ឆា”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ឞូ​អូរ​អី​នៃ​អើស​មា​ឞ្រាស​យេឆូ ៖ “ទី​ងាន់​កោរាញ យើន​មា​ឆ៝​ហោម​ឆា​នទើ​នទាក់​ត្រោស​ឞើស​កាលើ​គ្រែ​កោរាញ​ពាង់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “អើ​យោស នាវ​ញឆីង​អៃ​ក្វ៝ង់​ងាន់ លាស​នទ្រី​អ៝ន់​គែស​កើត​នាវ​អៃ​លែៈ​អុច​ងាន់​រ៝!” ជេសរី​ក៝ន​ឞូ​អូរ​ពាង់​ទោ​មា​ឞាស​នោក​នៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ឞ្រាស​យេឆូ ​លោស​ឞើស​នតុក​នៃ ហាន់​អា​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ  ជេសរី​ហាវ​អា​កាលើ​យោក​គុ​រាគើប​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","អ៝ក់​ងាន់​ឞូនុយ្ស​ហាន់​អា​ពាង់ នអ៝ប់​មា​លែវ​ឞូនុយ្ស​ក្វែត​រាវែន ឞូនុយ្ស​ឆ្យារ់​ជ៝ង់​តី ឞូនុយ្ស​ចែស​មាត់ ឞូនុយ្ស​មល៝ នទ្រែល​មា​ឞូនុយ្ស​ជី​ក្វែត​អេងៗ។ ឞូ​អ៝ន់​ឞិច​ឞើស​នាប់​ជ៝ង់​ឞ្រាស​យេឆូ ​រី ជេសរី​ពាង់​ជាន​ឞាស​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ទឹង​លែៈ​ឞូនុយ្ស​ឆៃ​កើត​នៃ​គែស​នាវ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់ ឆៃ​ឞូនុយ្ស​មល៝​ឞ្លាវ​ងើយ ឞូនុយ្ស​ឆ្យារ់​ជ៝ង់​តី​ជេង​ទាង់ ឞូនុយ្ស​ក្វែត​រាវែន​ឞ្លាវ​ឞ្រោៈ ឞូនុយ្ស​ចែស​មាត់​អ្វាញ់​ឆៃ។ ទឹង​លែៈ​ខាន់​ពាង់​លែវ​ឞាល់​រានេ​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ផូង​អីឆ្រាអែល ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ឞ្រាស​យេឆូ ​ក្វាល់​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​អា​ពាង់ ជេសរី​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​យោៈ​ងាន់​មា​ផូង​ប៝ន​លាន​នៃ ខាន់​ពាង់​គុ​នទ្រែល​គ៝ប់​លែៈ​ពែ​នារ​ហើយ នទើ​មា​ឆោង​ឆា​មោ​គែស​ដ៝ង់។ គ៝ប់​មោ​អុច​អ៝ន់​ខាន់​ពាង់​ព្លឹ​ឆឹត​នទុល​ទើម ក្លាច​លាស​ហ្វារ់​រ៝ៈ​ត្រ៝ង”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","មពោល​អ៝ស​ម៝ន​លាស​មា​ឞ្រាស​យេឆូ ៖ “តា​អ្យា​រាង៝ត​រាងាត់ លាស​នទ្រី​អាស​នតុក​ហេន​ជ៝យ​គៃ​មា​ត៝ង់​អ៝ន់​ផូង​ឞូនុយ្ស​អ៝ក់​អី​នៃ​ឆា?” ");
INSERT INTO cmok_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ឞ្រាស​យេឆូ ​អោប​ខាន់​ពាង់៖ “លាស​នទ្រី​ទាស​អ៝ក់​គែស​នុមពាង់​ខាន់​មៃ?” ខាន់​ពាង់​អើស៖ “ហេន​គែស​ពើស​មល៝ម់ នទ្រែល​មា​កា​ជេៈ​ដេៈ​ដាៈ”។ ");
INSERT INTO cmok_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ជេសរី​ឞ្រាស​យេឆូ ​ដាៈ​ផូង​ប៝ន​លាន​គុ​រើប​គើប​តា​នែស​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ពាង់​ឆ៝ៈ​ពើស​មល៝ម់​នុមពាង់​នៃ នទ្រែល​មា​កា​អី​នៃ មឞើស​ឆើម​លាស​អ្វែស​មា​កោរាញ​ឞ្រាស ពាង់​គិច​អ៝ន់​មា​មពោល​អ៝ស​ម៝ន ជេសរី​មពោល​អ៝ស​ម៝ន​ពាៈ​មា​ផូង​ប៝ន​លាន​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ទឹង​លែៈ​ឞូ​ឆា​ហើម​ទាទេ ជេសរី​រាគូម​នុមពាង់ នទ្រែល​មា​កា​អី​រាមែស​នៃ​គែស​ពើស​ឆាស។ ");
INSERT INTO cmok_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ទឹង​លែៈ​ឞូនុយ្ស​អី​គុ​ឆា​តា​នៃ​គែស ៤០០០ នុយ្ស​ឞូ​ក្លោ មោ​កើប​អោស​ផូង​ឞូ​អូរ នទ្រែល​មា​ក៝ន​ឆែ។ ");
INSERT INTO cmok_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ជេស​ឞ្រាស​យេឆូ ​អ៝ន់​ផូង​ប៝ន​លាន​ឆឹត ជេស​នៃ​ពាង់​ញច៝​ទូក​ហាន់​តា​នតុក​ក្វាល់​លាស​មាកាដាន ។ ");
INSERT INTO cmok_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","នោក​នៃ​ផូង​ផារីឆី  នទ្រែល​មា​ផូង​ឆាដោឆី ​អាបាៈ​ហាន់​អុច​រាល៝ង​ឞ្រាស​យេឆូ  ដាៈ​ពាង់​ជាន​ទូ​នាវ​មឞេន​គៃ​មា​ញហើ​នាវ​ទើយ​ពាង់​តាៈ​ឞើស​កោរាញ​ឞ្រាស​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","យើន​មា​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ត្រោក​គុរ​អា​អោយ ខាន់​មៃ​វៃ​លាស​ព្រាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ត្រោក​គុរ​កេង​មាង់ ខាន់​មៃ​វៃ​លាស​នារ​អោយ​តៃ​មីស​រ៝។ ខាន់​មៃ​ឞ្លាវ​មឞេន​ត្រោក លាស​នទ្រី​មើម​ទឹង​មោ​គឹត​វ៝ត់​នទើ​អី​កោរាញ​ឞ្រាស​ជាន​តា​រានោក​អាបៃ​អ្យា? ");
INSERT INTO cmok_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ឞូនុយ្ស​តា​រានោក​អាបៃ​អ្យា​ហោ​ងាន់​អ្យើស​មហឹក​ជាន​តីស​មា​នាវ​អុច​កោរាញ​ឞ្រាស អុច​ឆៃ​មា​នាវ​មឞេន​ទើម យើន​មា​កោរាញ​ឞ្រាស​មោ​អោស​អ៝ន់​នាវ​មឞេន​អេង​ជឹត ពាង់​អ៝ន់​ទូ​នាវ​មឞេន​តឹម​ឞាន​មា​នាវ​មឞេន​យោនាយ្ស ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​ទើម”។ ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​នត្លើយ​ខាន់​ពាង់​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","នោក​មពោល​អ៝ស​ម៝ន​ហាន់​គ្លាត់​កាល់​តី​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ  ខាន់​ពាង់​ច្វេល​ញអោត​នុមពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​ងាន់​ហ៝ម់​នទ្រូយ​ផូង​ផារីឆី  នទ្រែល​មា​នទ្រូយ​ផូង​ឆាដោឆី ​ហ៝ៈ”។ ");
INSERT INTO cmok_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","មពោល​អ៝ស​ម៝ន​ងើយ​នទ្រាង់​ខាន់​ពាង់​នើម៖ “ពាង់​ងើយ​កើត​នៃ​អាច​មា​ឞ៝ន់​មោ​គែស​ញអោត​នុមពាង់​ទើម​មោ យ៝រ​មា​ឞូ​ជាន​នុមពាង់​មា​នទ្រូយ!” ");
INSERT INTO cmok_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ឞ្រាស​យេឆូ ​គឹត​នាវ​ខាន់​ពាង់​ងើយ ពាង់​លាស៖ “អើ​ផូង​គែស​នាវ​ញឆីង​ដេៈ​ទើម ម៝ស​ងើយ​ខាន់​ម្រែ​នាវ​មោ​គែស​នុមពាង់​នៃ? ");
INSERT INTO cmok_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ខាន់​អៃ​មៃ​ហោម​មោ​គឹត​វ៝ត់​នាវ​ដ៝ង់? អាស​ខាន់​អៃ​មៃ​មោ​ហោម​កាស​គឹត​នោក​គ៝ប់​ពាៈ​ព្រាម់​មល៝ម់​នុមពាង់​អ៝ន់​មា​ឞូនុយ្ស ៥០០០ នុយ្ស​នើស? ជេសរី​ខាន់​អៃ​មៃ​លែៈ​ច្វេល​បាស នោក​ខាន់​អៃ​មៃ​រាគូម​នទើ​រាមែស ទាស​អ៝ក់​ឆាស? ");
INSERT INTO cmok_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","មោ​លាស​ពើស​មល៝ម់​នុមពាង់​គ៝ប់​អ៝ន់​ឞូនុយ្ស ៤០០០ នុយ្ស​នើស ជេសរី​ខាន់​អៃ​មៃ​រាគូម​នទើ​រាមែស​ទាស​អ៝ក់​ឆាស​ហោម​គែស? ");
INSERT INTO cmok_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","មើម​ទឹង​ខាន់​អៃ​មៃ​អេ​ហ៝ៈ​គឹត​វ៝ត់​ដ៝ង់ គ៝ប់​មោ​គែស​អោស​ងើយ​មា​នុមពាង់​ងាន់។ គ៝ប់​អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​នទ្រូយ​ផូង​ផារីឆី  នទ្រែល​មា​នទ្រូយ​ផូង​ឆាដោឆី ”។ ");
INSERT INTO cmok_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ជេសរី​មើ​ទឹង​មពោល​អ៝ស​ម៝ន​គឹត​នាវ​ឞ្រាស​យេឆូ ​លាស​អី​នៃ​អ៝ន់​ខាន់​ពាង់​ញជ្រាង់​នាវ​នតុម​នតី​ផូង​ផារីឆី  នទ្រែល​មា​ផូង​ឆាដោឆី  មោ​អោស​ទី​នទ្រូយ​តេៈ​រានីស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","នោក​ឞ្រាស​យេឆូ ​ហាន់​នតុក​ទាច់​មា​ប៝ន​ឆេឆារា-​ផីលីប ពាង់​អោប​មពោល​អ៝ស​ម៝ន​ពាង់៖ “តឹង​មា​នាវ​ឞូ​លាស ឞូ​ម៝ស​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស?” ");
INSERT INTO cmok_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ជេសរី​ខាន់​ពាង់​អើស៖ “ឞូ​អាបាៈ​លាស​មៃ​យោហាន-​បាប់តែម ​អី​លែៈ​ទ៝ក់​រេស ឞូ​អាបាៈ​លាស​មៃ​អេលីយា ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ព្លឹ​តា​អ្យា ឞូ​អាបាៈ​ជឹត​លាស​មៃ​យេរេមី ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​អី​លែៈ​ទ៝ក់​រេស មោ​លាស​មៃ​ទូ​ហ្វេ​ឞូនុយ្ស​អេង​ជឹត​តា​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​អី​លែៈ​ទ៝ក់​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ឞ្រាស​យេឆូ ​អោប​ខាន់​ពាង់៖ “លាស​នទ្រី​ខាន់​អៃ​មៃ​អែស គ៝ប់​ឞូ​ម៝ស​ខាន់​អៃ​មៃ​លាស​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ឆីមោន ​អី​ឞូ​ក្វាល់​ពេត្រោស ​ដ៝ង់​លាស៖ “មៃ​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់ អី​ក៝ន​កោរាញ​ឞ្រាស ឞ្រាស​អី​រេស​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “អើ​ឆីមោន ​ក៝ន​យោនាយ្ស  រាម់​មអាក​ងាន់​មា​មៃ យ៝រ​លាស​ឞឹ​គ៝ប់​គុ​តា​កាលើ​ត្រោក​អ៝ន់​មៃ​គឹត​គ៝ប់​ឞ្រាស​ក្រីស ។ នាវ​អី​នៃ​មោ​គែស​អោស​តាៈ​ឞើស​នាវ​គឹត​ឞ្លាវ​ឞូនុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","គ៝ប់​មឞើស​មា​មៃ មៃ​រាញា​ពេត្រោស  រាញា​អី​នៃ​គែស​នាវ​ខ្លៃ​លាស​«រាលាត​លុ» ជេសរី​តា​កាលើ​រាលាត​លុ​អ្យា​គ៝ប់​នតាម់​អី​ញីស​ឞ្រាស​គ៝ប់​អី​ទឹង​លែៈ​មពោល​ឞូនុយ្ស​ញឆីង​មា​គ៝ប់។ នាវ​ខឹត​មោ​អោស​ទើយ​ដាស​ផូង​ខាន់​ពាង់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","គ៝ប់​មរា​អ៝ន់​មៃ​នាវ​ទើយ​មា​អ៝ន់​ឞូនុយ្ស​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ តឹម​ឞាន​មា​អ៝ន់​ទូ​មល៝ម់​ក៝ន​ឆ៝​មពោង​មា​មៃ។ ជេសរី​ម៝ស​នទើ​មៃ​ឞ្វៃ​មោ​អ៝ន់​ឞូ​ជាន​តា​នែស​នតូ​អ្យា កោរាញ​ឞ្រាស​អី​គុ​តា​កាលើ​ត្រោក​អុច​កើត​នអៃ។ ម៝ស​នទើ​មៃ​មោ​ឞ្វៃ​មា​ឞូ​ជាន​តា​នែស​នតូ​អ្យា កោរាញ​ឞ្រាស​អី​គុ​តា​កាលើ​ត្រោក​អុច​កើត​នអៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ជេសរី​ពាង់​ឞ្វៃ​ហោ​ងាន់​មពោល​អ៝ស​ម៝ន​ពាង់ លើយ​មឞើស​ងក៝ច​អ៝ន់​ឞូ​គឹត​អោស​ពាង់​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់។ ");
INSERT INTO cmok_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","នតើម​ឞើស​នោក​នៃ ឞ្រាស​យេឆូ ​នតើម​មឞើស​ងក៝ច​អ៝ន់​មា​មពោល​អ៝ស​ម៝ន​ពាង់​គឹត​លាស អ្យាត់​មា​ពាង់​ហាន់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  នហ៝​មា​តា​ប៝ន​នៃ​ពាង់​គែស​នាវ​ជេរ​ជ៝ត់​ទុត​ហោ​ងាន់​តាៈ​ឞើស​មពោល​ឞូ​រាញ មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នហ៝​មា​ងខឹត​លើយ​អោឞាល់ យើន​មា​ត៝ត់​ពែ​នារ​ពាង់​ទ៝ក់​រេស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ជេសរី​ពេត្រោស ​ជាៈ​ឞ្រាស​យេឆូ ​ហាន់​នតុក​អេង​បាស​មា​ឞូ គៃ​មា​លាស​ពាង់៖ “អើ​កោរាញ អ៝ន់​កោរាញ​ឞ្រាស​ឞ្វៃ​នាវ​អី​នៃ លើយ​អោស​អ៝ន់​នាវ​អី​នៃ​ត៝ត់​មា​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","យើន​មា​ឞ្រាស​យេឆូ ​ងគឹល​ជឹត​ពេត្រោស  ជេសរី​លាស៖ “ហើយ​ឆាតាង់  មៃ​ទូ​ងាយ​ឞើស​គ៝ប់​ហ៝ម់ មៃ​អុច​ងកីង​លើយ​ត្រ៝ង​គ៝ប់។ នាវ​មឹន​មៃ​មោ​អោស​ទី​ដាស​នាវ​មឹន​កោរាញ​ឞ្រាស នាវ​មឹន​នៃ​តាៈ​ឞើស​ឞូនុយ្ស​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “ឞូ​ម៝ស​ពាង់​អី​អុច​តឹង​គ៝ប់ អ៝ន់​មអារ់​លើយ​នទើ​ឆាក់​ពាង់​នើម​អុច ជេសរី​តូយ​ឆី​តឹម​រាកាង់​ពាង់​នើម ឞ៝ល​លាស​ត៝ត់​ខឹត​ឆាក់​កាដោយ រី​មើ​ពាង់​តឹង​គ៝ប់​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“យ៝រ​លាស​ឞូ​ម៝ស​អី​អុច​ព្រាប់​មា​នាវ​រេស​ពាង់​នើម ពាង់​អី​នៃ​មោ​អោស​គែស​នាវ​រេស​នហ៝​រ៝ យើន​មា​ឞូ​ម៝ស​ខឹត​យ៝រ​មា​តឹង​គ៝ប់ ពាង់​អី​នៃ​មរា​គែស​នាវ​រេស​នហ៝​រ៝​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","លាស​ទូ​ហ្វេ​ឞូនុយ្ស​ពាង់​ជ៝យ​គែស​ទឹង​លែៈ​នែស​នតូ​អ្យា​ជេង​ទ្រាប់​នទើ​ពាង់​នើម​ទាទេ តីស​មា​ឆាក់​ពាង់​នើម​ខឹត​រ៝ស​ហេង មោ​អោស​គែស​នាវ​រេស​នហ៝​រ៝ នទ្រី​ម៝ស​គែស​នាវ​ខ្លៃ​មា​ពាង់? មោ​លាស​ឞូនុយ្ស​អើម​ទើយ​ឆ៝ៈ​ទ្រាប់​នទើ​រាគ៝ល់​មា​នាវ​រេស​ពាង់​នើម​នហ៝​រ៝​ដ៝ង់​ឞើស? ");
INSERT INTO cmok_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","នោក​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់​នអ៝ប់​មា​នាវ​ច្រេក​លើប​ឞឹ​គ៝ប់​នើម នទ្រែល​មា​ផូង​តោង​ពារ់​គ៝ប់គ៝ប់​ញអោត​នទើ​ងខោម មោ​លាស​តេៈ​ទោយ្ស​តឹង​នាវ​ជាន​ការ​ទូ​ហ្វេ​ទូ​ហ្វេ​ឆាក់។ ");
INSERT INTO cmok_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ឞូនុយ្ស​អាបាៈ​អី​គុ​តា​អ្យា​មោ​ខឹត​អោស​អេ​ល៝រ​មា​ឆៃ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ជេង​នើម​ម៝ត់​អ្វាញ់”។ ");
INSERT INTO cmok_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","គែស​ព្រាវ​នារ​ឞើស​កើយ​នៃ​ឞ្រាស​យេឆូ ​ជាៈ​ពេត្រោស យាកើ  នទ្រែល​មា​យោហាន ​អី​អ៝ស​យាកើ  ហាវ​កាលើ​យោក​ព្រេស មោ​អោស​លែវ​ឞូ​អា​អេង​ហាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","តា​នៃ​ឆាក់​ជាន់​ពាង់​រាគ៝ល់​ឞើស​នាប់​ខាន់​ពាង់។ មុស​មាត់​ពាង់​រីល​ងាន់​តឹម​ឞាន​មា​អាង​នារ អី​ឞ៝ក​អាវ​ពាង់​ជេង​ងលាង អាង​ច្រាត​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ខាន់​ពាង់​ទោ​មា​ឆៃ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ឞើស​កាល់​អែ​នើស​រាញា​អេលីយា  នទ្រែល​មា​កោរាញ​ផូង​អីឆ្រាអែល ​កាល់​អែ​នើស​រាញា​មោឆេ ​គុ​ងើយ​នទ្រែល​ឞ្រាស​យេឆូ ​តា​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ជេស​ឆៃ​លែៈ​នាវ​អី​នៃ ពេត្រោស ​លាស​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញ ឞ៝ន់​គុ​តា​អ្យា​អ្វែស​ងាន់​មេ។ លាស​មៃ​អុច អ៝ន់​គ៝ប់​ជាន​ពែ​មល៝ម់​ចូន ទូ​មល៝ម់​អ៝ន់​មា​មៃ ទូ​មល៝ម់​អ៝ន់​មា​មោឆេ ​ទូ​មល៝ម់​ជឹត​អ៝ន់​មា​អេលីយា ”។ ");
INSERT INTO cmok_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","នោក​ពាង់​ហោម​ងើយ ទោ​មា​ឆៃ​គែស​តុក​ងកុម​ជុម​ខាន់​ពាង់​លែៈ​រាងោច​អាង​រាល​ហោ​ងាន់ តាង់​នតែស​ងើយ​តាៈ​ឞើស​តុក​នៃ​លាស៖ “ពាង់​អ្យា​ក៝ន​គ៝ប់​អី​គ៝ប់​រ៝ង់​ហោ​ងាន់។ ហោ​ងាន់​គ៝ប់​រាម់​ពាង់។ អ្យាត់​នាវ​ពាង់​ទោ!” ");
INSERT INTO cmok_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ត៝ត់​មពោល​អ៝ស​ម៝ន​តាង់​កើត​អី​នៃ ខាន់​ពាង់​ចោត​ចុន​មុស​មាត់​អា​នែស​ឆូ​ទាទេ ក្លាច​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","យើន​មា​ឞ្រាស​យេឆូ ​ហាន់​ពាស​ខាន់​ពាង់​លាស៖ “ទ៝ក់​ហ៝ម់ លើយ​អោស​ក្លាច!” ");
INSERT INTO cmok_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ត៝ត់​ខាន់​ពាង់​ងើក​អ្វាញ់ ឆៃ​ទូ​ហ្វេ​ឞ្រាស​យេឆូ ​ទើម ឞូនុយ្ស​អាបាៈ​អេង​មោ​អោស​ឆៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ជេសរី​ខាន់​ពាង់​ជុរ​តាៈ​ឞើស​យោក ឞ្រាស​យេឆូ ​ឞ្វៃ​ខាន់​ពាង់​កើត​នអា៖ “លើយ​អោស​ងក៝ច​អ៝ន់​ឞូ​គឹត​នទើ​អី​ខាន់​មៃ​ឆៃ​នៃ​នើស នហ៝​មា​ក៝ប់​ត៝ត់​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ខឹត​ទ៝ក់​រេស​ប៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ជេសរី​ខាន់​ពាង់​អោប​ឞ្រាស​យេឆូ ៖ “លាស​នទ្រី​ម៝ស​នាវ​ទឹង​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់​នតី​លាស​អេលីយា ​អ្យាត់​មា​ពាង់​វាច់​ល៝រ​តា​អ្យា ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​វាច់​ឞើស​កើយ​រ៝?” ");
INSERT INTO cmok_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ទី​ងាន់​នាវ​ព្រែ​លាស។ អេលីយា ​វាច់ គៃ​មា​កើយ​នទ្រាប់​អ៝ន់​អាប់​ទឹង​លែៈ​រាងោច។ ");
INSERT INTO cmok_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","យើន​មា​គ៝ប់​មឞើស​ងក៝ច​មា​ខាន់​មៃ អេលីយា ​លែៈ​ព្លឹ​ងាន់ ជេសរី​ឞូ​មោ​អោស​គឹត​នាល់​ពាង់ ហោ​ងាន់​ឞូ​ជាន​ជេរ​មា​អោឞាល់​ទាស​ទាង់​អុច​ខាន់​ពាង់​នើម។ កើត​នអា​ដ៝ង់​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ខាន់​ពាង់​ជាន​ជេរ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","នោក​នៃ​មពោល​អ៝ស​ម៝ន​គឹត​វ៝ត់ ឞ្រាស​យេឆូ ​ងើយ​មា​យោហាន-​បាប់តែម ។ ");
INSERT INTO cmok_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","នោក​ឞ្រាស​យេឆូ  នទ្រែល​មា​ពែ​នុយ្ស​មពោល​អ៝ស​ម៝ន​ពាង់​ត៝ត់​តា​នតុក​ឞូនុយ្ស​ផូង គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ហាន់​ច៝ន​កោម៝ក់​ឞើស​នាប់​ឞ្រាស​យេឆូ ​រី ");
INSERT INTO cmok_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ជេសរី​លាស៖ “អើ​កោរាញ ទាន់​មៃ​យោៈ​នអាច​ក៝ន​ឞូ​ក្លោ​គ៝ប់​អើ! ពាង់​ខឹត​ឞ្រុត​មេ តា​ពាង់​រេស​រាញាល់​ងាន់ អ៝ក់​តឹ​ពាង់​វៃ​ចោត​តា​អុញ ចោត​តា​ទាក​មរ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","គ៝ប់​លែៈ​លែវ​ពាង់​អា​មពោល​អ៝ស​ម៝ន​មៃ យើន​មា​ខាន់​ពាង់​ជាន​មោ​ទើយ​អោស”។ ");
INSERT INTO cmok_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ឞ្រាស​យេឆូ ​លាស​មា​ទឹង​លែៈ​ឞូនុយ្ស៖ “ហើយ​ឞូនុយ្ស​អ្យើស ឞូនុយ្ស​មោ​អ្យាត់​នាវ​កោរាញ​ឞ្រាស! ទាស​ហោម​ជ៝ៈ​អ៝ន់​គ៝ប់​ញឆ្រោយ្ស​គុ​នទ្រែល​ខាន់​អៃ​មៃ? ទាស​ហោម​ជ៝ៈ​អ៝ន់​គ៝ប់​ញឆ្រោយ្ស​នទ្រែល​ខាន់​អៃ​មៃ? លែវ​ហ៝ម់​ពាង់​អី​នៃ​អា​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ជេសរី​ឞ្រាស​យេឆូ ​មឞ្រាម​ឞ្រាស​អ្យើស​អី​គុ​តា​ក៝ន​ឆែ​រី ឞ្រាស​អ្យើស​លោស​ឞើស​ក៝ន​ឆែ​រ៝ នតើម​ឞើស​នោក​នៃ​រ៝​ក៝ន​ឆែ​អី​នៃ​ឞាស។ ");
INSERT INTO cmok_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ជេសរី​មពោល​អ៝ស​ម៝ន​ហាន់​អោប​អេង​ឞ្រាស​យេឆូ ៖ “មើម​ទឹង​ហេន​មោ​ទើយ​មព្រើស​ឞ្រាស​អ្យើស​អ៝ន់​លោស​ហ្យាស?” ");
INSERT INTO cmok_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “អាច​មា​នាវ​ញឆីង​ខាន់​អៃ​មៃ​ដេៈ​អីរ។ គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ លាស​ខាន់​អៃ​មៃ​គែស​នាវ​ញឆីង​ដេៈ​តឹម​ឞាន​មា​ទូ​នតីល​គារ់​នតីល​ទុត​ជេៈ ខាន់​អៃ​មៃ​ទើយ​ដាៈ​យោក៖ «ទូ​ហ៝ម់​ឞើស​នតុក​អ្យា ហាន់​គុ​តា​នតុក​រី» ពាង់​ទូ​ងាន់​រ៝ នហ៝​មា​មោ​គែស​អោស​ទូ​នតីល​នទើ​ខាន់​អៃ​មៃ​មោ​ទើយ​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ទឹង​ឞូ​ទើយ​មព្រើស​អ៝ន់​លោស​នតីល​ឞ្រាស​អ្យើស​អី​អ្យា យ៝រ​មា​នាវ​មឞើស​ឆើម នទ្រែល​មា​អ៝ត់​ឆោង​ឆា។” ");
INSERT INTO cmok_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","នោក​គុ​តា​ឞ្រី​កាលីលេ ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន៖ “គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស ឞូ​មរា​ញជុន​អ៝ន់​មា​ឞូនុយ្ស ");
INSERT INTO cmok_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","អី​ងខឹត​លើយ​គ៝ប់ យើន​មា​ត៝ត់​ពែ​នារ​គ៝ប់​ទ៝ក់​រេស​ដ៝ង់”។ មពោល​អ៝ស​ម៝ន​តាង់​កើត​នៃ ខាន់​ពាង់​រាង៝ត​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","នោក​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​ត៝ត់​តា​ប៝ន​កាពើនិម  មពោល​ឞូនុយ្ស​អី​រាគូម​ព្រាក់​មា​អ៝ន់​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​តា​ប៝ន​យេរូឆាលឹម  ខាន់​ពាង់​ហាន់​ម៝ប់​ពេត្រោស  ជេសរី​អោប៖ “អាស​នើម​នតី​ខាន់​មៃ​អ៝ន់​ព្រាក់​មា​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​ដ៝ង់?” ");
INSERT INTO cmok_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ពេត្រោស ​អើស៖ “អើ ពាង់​អ៝ន់”។ នោក​ពេត្រោស ​លាប់​តា​ត្រោម​ជៃ ឞ្រាស​យេឆូ ​អោប​ពាង់​ល៝រ៖ “អើ​ពេត្រោស  តឹង​មា​នាវ​មៃ​មឹន កាដាច់​តា​នែស​នតូ​អ្យា​ឞើស​តាៈ​ពាង់​ឆ៝ៈ​ព្រាក់​មេស? ឆ៝ៈ​ឞើស​អ៝ស​ក៝ន​ពាង់​នើម មោ​លាស​ឞើស​ឞូ​អេង?” ");
INSERT INTO cmok_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ពេត្រោស ​អើស៖ “ឆ៝ៈ​ឞើស​ឞូ​អេង”។ ឞ្រាស​យេឆូ ​លាស៖ “លាស​នទ្រី​ក៝ន​កាដាច់​មោ​ខាច់​អ៝ន់​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","យើន​មា​គៃ​មា​លើយ​អ៝ន់​ខាន់​ពាង់​ជី​នូយ្ស អ៝ន់​មៃ​ហាន់​តេៈ​នទារ​អា​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ  មៃ​ងខាក​មឞូង​កា​អី​ល៝រ​ប៝ស​នទារ តា​ត្រោម​មឞូង​កា​អី​នៃ​មៃ​ឆៃ​គែស​ទូ​មល៝ម់​ព្រាក់​កាក់​មា​គាប់​ឞារ​ហៃ​ឞ៝ន់ ជេសរី​មៃ​ឆ៝ៈ​ព្រាក់​អី​នៃ​នទឹ​អ៝ន់​ឞូ ឆើម​នទឹ​អ៝ន់​មា​គ៝ប់ នអ៝ប់​មា​មៃ​នើម​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","នោក​នៃ​មពោល​អ៝ស​ម៝ន​ហាន់​អោប​ឞ្រាស​យេឆូ ៖ “ឞូ​ម៝ស​ក្វ៝ង់​រាលាវ​ឞូ​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់?” ");
INSERT INTO cmok_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ឞ្រាស​យេឆូ ​ក្វាល់​ទូ​ហ្វេ​ក៝ន​ឆែ​ជេៈ​គុ​តា​ងក្លាង​ផូង​ខាន់​ពាង់​រី‌ ");
INSERT INTO cmok_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ជេសរី​លាស៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ លាស​ខាន់​អៃ​មៃ​មោ​រាគ៝ល់​នូយ្ស​នហ៝ម់​អ៝ន់​ជេង​តឹម​ឞាន​មា​ក៝ន​ឆែ​ជេៈ ខាន់​អៃ​មៃ​មោ​អោស​ទើយ​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់។ ");
INSERT INTO cmok_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ឞូ​ម៝ស​អី​ញជុរ​ឆាក់​ពាង់​នើម​ជេង​តឹម​ឞាន​មា​ក៝ន​ឆែ​ជេៈ​អ្យា ពាង់​អី​នៃ​ជេង​ក្វ៝ង់​រាលាវ​ឞូ​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់។ ");
INSERT INTO cmok_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ជេសរី​ឞូ​ម៝ស​រ៝ម​ទូ​ហ្វេ​ក៝ន​ឆែ​ជេៈ​កើត​នអា យ៝រ​មា​ក៝ន​ឆែ​អី​នៃ​ញឆីង​មា​គ៝ប់ ពាង់​អី​នៃ​តឹម​ឞាន​មា​រ៝ម​គ៝ប់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ឞ្រាស​យេឆូ ​លាស​ជឹត៖ “ឞូ​ម៝ស​លែវ​ទូ​ហ្វេ​ក៝ន​ឆែ​ជេៈ​អី​ញឆីង​មា​គ៝ប់​ជាន​នាវ​តីស នទ្រី​អ្វែស​រាលាវ​លាស​ឞូ​ឆ៝ៈ​មពាល់​លុ​ក៝ត់​តា​ត៝ង​ក៝​ពាង់​ងក្លាច់​តា​ទាក​វាច់​ទាក​វារ់ រាម៝ក​តា​ទាក​វាច់​ទាក​វារ់​ជ្រូ​រី មា​ដាស​អ៝ន់​ពាង់​រេស​ជាន​កើត​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","រេស​រាញាល់​ងាន់​មា​ឞូនុយ្ស​តា​នែស​នតូ យ៝រ​មា​លែវ​ឞូ​ជាន​តីស។ មរា​គែស​ងាន់​នាវ​លែវ​ជាន​តីស យើន​មា​រេស​រាញាល់​ងាន់​រ៝​មា​ឞូ​ម៝ស​អី​លែវ​អ៝ន់​ជាន​តីស! ");
INSERT INTO cmok_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","លាស​ឆៃ​តី​មោ​លាស​ជ៝ង់​ខាន់​អៃ​មៃ​លែវ​ជាន​នាវ​តីស ក៝ស​មអារ់​លើយ​តី​មោ​លាស​ជ៝ង់​អី​នៃ។ អ្វែស​រាលាវ​មា​គុ​រេស​ជឹត​នាប់​តៃ​រ៝ង​ទូ​ទីង​តី​មោ​លាស​ទូ​ទីង​ជ៝ង់​ទើម ជេសរី​ទើន​នាវ​រេស​នហ៝​រ៝ មា​ដាស​តី​មោ​លាស​ជ៝ង់​ឞារ​ដាស ជេសរី​គុ​តា​នតុក​អី​គែស​អុញ​ហីត​នហ៝​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","លាស​ឆៃ​ត្រោម​មាត់​ខាន់​អៃ​មៃ​លែវ​ជាន​នាវ​តីស រាវែក​មអារ់​លើយ​ត្រោម​មាត់​អី​នៃ។ អ្វែស​រាលាវ​មា​រ៝ង​ទូ​ទីង​ត្រោម​មាត់​ទើន​នាវ​រេស​នហ៝​រ៝ មា​ដាស​ឞារ​ទីង​ត្រោម​មាត់ ជេសរី​កោរាញ​ឞ្រាស​ងក្លាច់​តា​នទ្រូង​អុញ។ ");
INSERT INTO cmok_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​ហ៝ម់ លើយ​អោស​អ្វាញ់​មោ​ខ្លៃ​តា​ក៝ន​ឆែ​ជេៈ​កើត​នៃ។ គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ តា​នតុក​កោរាញ​ឞ្រាស​តា​កាលើ​ត្រោក​ផូង​តោង​ពារ់​អី​កើល​ញជ្រាង់​ក៝ន​ឆែ​អី​នៃ​គុ​នឹង​តា​នាប់​មាត់​ឞឹ​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​វាច់​តា​នែស​នតូ​អ្យា គៃ​មា​រាក្លាយ្ស​ឞូនុយ្ស​តីស​អី​រ៝ស​យ៝ត ឞូនុយ្ស​អី​នូយ្ស​នហ៝ម់​ងាយ​ឞើស​កោរាញ​ឞ្រាស​តឹម​ឞាន​មា​ឞែ​ឞ្យាប់​រ៝ស”។ ");
INSERT INTO cmok_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“មើម​ខាន់​អៃ​មៃ​គឹត មើម​ជាន​ទូ​ហ្វេ​ឞូនុយ្ស​លាស​គែស​ឞែ​ឞ្យាប់ ១០០ យើន​មា​គែស​ទូ​មល៝ម់​ឞែ​ឞ្យាប់​រ៝ស? អើម​មោ​លាស​ពាង់​នត្លើយ​ឞែ​ឞ្យាប់​អី ៩៩ តា​កាលើ​យោក ជេសរី​ហាន់​ជ៝យ​ឞែ​ឞ្យាប់​អី​រ៝ស​នៃ​រ៝? ");
INSERT INTO cmok_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ លាស​ពាង់​ជ៝យ​ឆៃ​ឞែ​ឞ្យាប់​អី​រ៝ស​នៃ ពាង់​រាម់​រាហើន​ងាន់​មា​ឞែ​ឞ្យាប់​អី​នៃ រាលាវ​មា​ឞែ​ឞ្យាប់ ៩៩ អី​មោ​រ៝ស​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","លាស​នទ្រី​តឹម​ឞាន​កើត​នៃ​ដ៝ង់​ឞឹ​ខាន់​អៃ​មៃ​អី​គុ​តា​កាលើ​ត្រោក ពាង់​មោ​អុច​អោស​អ៝ន់​ទូ​ហ្វេ​ក៝ន​ឆែ​ជេៈ​អី​អ្យា​រ៝ស​ខឹត​នហ៝​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“លាស​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ញឆីង​មា​កោរាញ​ឞ្រាស​ជាន​តីស​ដាស​ខាន់​អៃ​មៃ អ៝ន់​ខាន់​អៃ​មៃ​ហាន់​ទូ​ហ្វេ​អេង​ម៝ប់​ពាង់ ងើយ​ដាស​ពាង់។ លាស​ពាង់​អ្យាត់​នាវ​ខាន់​អៃ​មៃ ខាន់​អៃ​មៃ​គែស​តៃ​នាវ​ដាប់​មពាន់​ដាស​ពាង់​កើត​អើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","លាស​ពាង់​មោ​អោស​អ្យាត់​ខាន់​អៃ​មៃ អ៝ន់​ខាន់​អៃ​មៃ​ជាៈ​ទូ​ហ្វេ មោ​លាស​ឞារ​ហៃ​ហាន់​នទ្រែល​ខាន់​អៃ​មៃ គៃ​មា​គឹត​តាង់​ទឹង​លែៈ​នទើ​អី​គែស​ងើយ។ ");
INSERT INTO cmok_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","លាស​ពាង់​ហោម​អែ​មោ​អ្យាត់​ដ៝ង់​ផូង​ខាន់​អៃ​មៃ​អី​នៃ លាស​នទ្រី​មឞើស​ងក៝ច​នាវ​អី​នៃ​អ៝ន់​មា​ផូង​ញឆីង​មា​កោរាញ​ឞ្រាស។ លាស​ពាង់​មោ​អុច​អ្យាត់​ដ៝ង់​ផូង​ញឆីង​អី​នៃ លាស​នទ្រី​កើប​ពាង់​ជេង​ឞូនុយ្ស​អី​មោ​ញឆីង​មា​កោរាញ​ឞ្រាស មោ​លាស​កើប​ពាង់​ជេង​ឞូនុយ្ស​ជាន​តីស​អា​អេង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ជេសរី​ម៝ស​នទើ​ខាន់​អៃ​មៃ​ឞ្វៃ​មោ​អ៝ន់​ឞូ​ជាន​តា​នែស​នតូ​អ្យា កោរាញ​ឞ្រាស​អី​គុ​តា​កាលើ​ត្រោក​អុច​កើត​នអៃ។ ម៝ស​នទើ​ខាន់​អៃ​មៃ​មោ​ឞ្វៃ​មា​ឞូ​ជាន​តា​នែស​នតូ​អ្យា កោរាញ​ឞ្រាស​អី​គុ​តា​កាលើ​ត្រោក​អុច​កើត​នអៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ទូ​តឹ​ជឹត គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ លាស​គែស​ឞារ​ហៃ​តា​ផូង​ខាន់​អៃ​មៃ​តា​នែស​នតូ​មឞើស​ឆើម​ទូ​នតោរ​នាវ ម៝ស​នទើ​ខាន់​ពាង់​ទាន់ ឞឹ​គ៝ប់​អី​គុ​តា​កាលើ​ត្រោក​អ៝ន់​នទើ​អី​នៃ​មា​ខាន់​ពាង់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","យ៝រ​លាស​ព្លាង់​នតុក​គែស​ឞារ​ពែ​នុយ្ស​គុ​រាបុន​យ៝រ​មា​ខាន់​ពាង់​ញឆីង​មា​គ៝ប់គ៝ប់​គុ​នទ្រែល​តា​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ជេសរី​ពេត្រោស ​ហាន់​អោប​ឞ្រាស​យេឆូ ៖ “អើ​កោរាញ លាស​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ញឆីង​មា​កោរាញ​ឞ្រាស​ជាន​តីស​មា​គ៝ប់ លាស​នទ្រី​ទុម​ឞ្រី​តឹ​គ៝ប់​យោៈ​នាវ​តីស​អ៝ន់​ពាង់​មេស? ត៝ត់​មា​ពើស​តឹ​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “មោ​អោស​ទើន​មា​ពើស​តឹ​ទើម យើន​មា ៧០ តឹ​ពើស”។ ");
INSERT INTO cmok_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“កើត​នទ្រី​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ នតឹត​តឹម​ឞាន​មា​ទូ​ហ្វេ​កាដាច់​អុច​តឹង​រាន៝ន​មពោល​ឞូនុយ្ស​កើល​ជាន​ការ​អី​ខាន​រាន៝ន​ដាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","នោក​កាដាច់​នៃ​នតើម​ជាន គែស​ឞូ​ញជុន​ទូ​ហ្វេ​ឞូនុយ្ស​មា​ពាង់​អី​ហោម​ខាន​រាន៝ន​អ៝ក់​រាកែស។ ");
INSERT INTO cmok_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","អាច​មា​ពាង់​អី​នៃ​មោ​ហោម​ទើយ​គែស​ព្រាក់​មា​ត៝ម់​រាន៝ន កាដាច់​ដាៈ​ឞូ​តាច់​អូរ​តាច់​ក៝ន នអ៝ប់​មា​តាច់​ឆាក់​ពាង់​នើម នទ្រែល​មា​តាច់​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់ គៃ​មា​ត៝ម់​រាន៝ន​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ឞូនុយ្ស​កើល​ជាន​ការ​អី​នៃ​ពាន់​មឞាស​តា​ជ៝ង់​ពាង់​រី ជេសរី​លាស៖ «អើ​កោរាញ! ទាន់​មៃ​ញឆ្រោយ្ស​ក៝ប់​ប៝ត់​អើ គ៝ប់​មរា​ត៝ម់​រឹង​អ៝ន់​មៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","កាដាច់​យោៈ​នអាច​មា​ពាង់​ហោ​ងាន់ អ៝ន់​ពាង់​ឆឹត ងក្រែ​មា​ងគ្រ៝ស​លែៈ​អី​រាន៝ន​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ជេសរី​ឞូនុយ្ស​កើល​ជាន​ការ​អី​នៃ​ទូ​ឆឹត​ឞើស​កាដាច់ ពាង់​តឹម​ម៝ប់​ដាស​ទូ​ហ្វេ​មឹត​ជាង់​វៃ​កើល​ជាន​ការ​នទ្រែល​ពាង់​នើម។ អោឞាល់​អី​នៃ​ខាន​រាន៝ន​ដាស​ពាង់ ១០០ ព្រាក់​កាក់ ញុប​មពែត​អោឞាល់​តា​ត៝ង​ក៝ ជេសរី​លាស៖ «ត៝ម់​ហ៝ម់​រាន៝ន​គ៝ប់!» ");
INSERT INTO cmok_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","អី​មឹត​ជាង់​ពាង់​នៃ​ពាន់​តា​ជ៝ង់​ពាង់ ឞ៝ញ​ទាន់​ពាង់៖ «ទាន់​មៃ​ញឆ្រោយ្ស​ក៝ប់​ប៝ត់​អើ គ៝ប់​មរា​ត៝ម់​រឹង​អ៝ន់​មៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","យើន​មា​ពាង់​មោ​អុច​អ្យាត់​អោស ញុប​ក្រុង​អោឞាល់​តា​ត្រោម​នទ្រូង នហ៝​មា​ត៝ត់​អោឞាល់​ត៝ម់​រឹង​រាន៝ន​មើ។ ");
INSERT INTO cmok_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ឞូនុយ្ស​កើល​ជាន​ការ​អាបាៈ​អេង​ឆៃ​កើត​នៃ ខាន់​ពាង់​រាង៝ត​ហោ​ងាន់ មឞើស​ងក៝ច​ទឹង​លែៈ​នាវ​អី​នៃ​អ៝ន់​មា​កាដាច់។ ");
INSERT INTO cmok_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","កាដាច់​ដាៈ​ឞូ​ហាន់​ក្វាល់​ពាង់ ជេសរី​លាស៖ «ហើយ​ឞូនុយ្ស​អ្យើស​មហឹក! ទឹង​លែៈ​រាន៝ន​មៃ​លែៈ​គ៝ប់​ងគ្រ៝ស​លើយ​លែៈ​ផ្យៅ អាច​មា​គ៝ប់​ឆៃ​មៃ​ទាន់​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","មើម​ទឹង​មៃ​មោ​អុច​យោៈ​អោស​ឞូនុយ្ស​កើល​ជាន​ការ​នទ្រែល​មៃ​នើម កើត​គ៝ប់​លែៈ​យោៈ​មា​មៃ?» ");
INSERT INTO cmok_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","កាដាច់​អី​នៃ​ជី​នូយ្ស​ហោ​ងាន់​មា​ពាង់ ជេសរី​ញជុន​ពាង់​មា​កោរាញ​ម៝ត់​អ្វាញ់​នទ្រូង​គៃ​មា​ងក្រីត​ពាង់ តេៈ​ពាង់​តា​ត្រោម​នទ្រូង​នហ៝​មា​ត៝ត់​ពាង់​ត៝ម់​រឹង​រាន៝ន។ ");
INSERT INTO cmok_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","តឹម​ឞាន​ដ៝ង់​តា​ផូង​ខាន់​អៃ​មៃ លាស​ខាន់​អៃ​មៃ​មោ​អោស​តឹម​យោៈ​នាវ​តីស មោ​ឞ្លាវ​ឞាស​កើប​នាវ​តីស​នទ្រាង់​ខាន់​អៃ​មៃ​នើម​អ៝ន់​លែៈ​ឞើស​នូយ្ស​នហ៝ម់​ងាន់ ឞឹ​គ៝ប់​គុ​តា​កាលើ​ត្រោក​ពាង់​ជាន​មា​ខាន់​អៃ​មៃ​កើត​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","លោច​ជេស​ឞ្រាស​យេឆូ ​ងើយ​កើត​នៃ ពាង់​លោស​ឞើស​ឞ្រី​កាលីលេ  ហាន់​ជឹត​ឞ្រី​យូដា ​មពែស​ឞើស​កាល់​តី​ទាក​រាលាយ​យោរដាន់  ជេង​មពែស​ឞើស​លោស​នារ។ ");
INSERT INTO cmok_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","គែស​ឞូនុយ្ស​អ៝ក់​ងាន់​តឹង​ពាង់ ជេសរី​ពាង់​ជាន​ឞាស​ផូង​ជី​ក្វែត​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","គែស​ផូង​ផារីឆី ​អាបាៈ​ហាន់​អា​ឞ្រាស​យេឆូ ​អោប​រាល៝ង​ពាង់៖ “ហើយ​នើម​នតី! អាស​តឹង​មា​នាវ​វៃ​ផូង​ឞ៝ន់ ឆាយ​ទើយ​នត្លើយ​អូរ ម៝ស​នាវ​អាបាៈ​អេង​ទើយ​ដ៝ង់​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​លែៈ​អ្វាញ់​បាស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ ឞើស​នតើម​ឆាអើម​កោរាញ​ឞ្រាស​ញជេង​ឞូនុយ្ស​ដ៝ង់ គែស​ឞូ​ក្លោ គែស​ឞូ​អូរ? ");
INSERT INTO cmok_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ជេសរី​លាស៖ «នទ្រី​ទឹង​គែស​ឞូ​ក្លោ​លោស​ទូ​ឞើស​មេៈ​ឞឹ ហាន់​គុ​អា​អូរ ជេសរី​ឞារ​ហៃ​ខាន់​ពាង់​ជេង​អូរ​ឆាយ​ជេង​ទូ​រាង្លៃ​ឆាក់» ");
INSERT INTO cmok_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","នទ្រី​ខាន់​ពាង់​មោ​អោស​ហោម​ជេង​ឞារ​ហៃ​តៃ លែៈ​ជេង​ទូ​រាង្លៃ​ឆាក់​ទើម។ លាស​នទ្រី​ឞារ​ហៃ​អូរ​ឆាយ​អី​កោរាញ​ឞ្រាស​ទែ​រាង្លាប់​នៃ​លើយ​អោស​អ៝ន់​ឞូនុយ្ស​តឹម​ងខាស”។ ");
INSERT INTO cmok_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ផូង​ផារីឆី ​អោប​ឞ្រាស​យេឆូ ៖ “លាស​នទ្រី​មើម​ទឹង​មោឆេ ​ដាៈ​អី​ឆាយ​ជាន​ឆ៝ម់បុត​នាវ​តឹម​នត្លើយ ជេសរី​ទើយ​មព្រើស​អី​អូរ​ពាង់​នើម?” ");
INSERT INTO cmok_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ឞ្រាស​យេឆូ ​លាស​ខាន់​ពាង់៖ “អាច​មា​នូយ្ស​នហ៝ម់​ខាន់​មៃ​ទាង់​ក៝​ហោ​អីរ នទ្រី​ទឹង​មោឆេ ​ដាៈ​ខាន់​មៃ​ជាន​ឆ៝ម់បុត​នត្លើយ​អូរ។ យើន​មា​ឞើស​នតើម​នើស​មោ​អោស​គែស​កើត​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","គ៝ប់​មឞើស​មា​ខាន់​មៃ ឞូ​ម៝ស​នត្លើយ​អូរ​ពាង់​នើម យើន​មា​អូរ​ពាង់​មោ​គែស​អោស​ល៝ម់​ឆាយ ជេសរី​ឆ៝ៈ​អូរ​អេង ឞូនុយ្ស​អី​នៃ​កើប​ពាង់​លែៈ​ជេង​ឞូនុយ្ស​ល៝ម់​អូរ”។ ");
INSERT INTO cmok_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","មពោល​អ៝ស​ម៝ន​លាស​មា​ពាង់៖ “លាស​កើត​នទ្រី​ងាន់​នាវ​ឆ៝ៈ​អូរ​ឆាយ អ្វែស​ដេៈ​លាស​មោ​ឆ៝ៈ​អូរ​ឆ៝ៈ​ឆាយ”។ ");
INSERT INTO cmok_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ឞ្រាស​យេឆូ ​ព្លឹ​លាស​មា​ខាន់​ពាង់៖ “មោ​ទី​អោស​ទឹង​លែៈ​ឞូនុយ្ស​គឹត​វ៝ត់​នាវ​អ្យា គែស​ឞូនុយ្ស​អី​កោរាញ​ឞ្រាស​អ៝ន់ ពាង់​អី​នៃ​ទើម​ទើយ​គឹត​វ៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","គែស​ឞូនុយ្ស​អាបាៈ​នហ៝​មា​មោ​ឞ្លាវ​ឆ៝ៈ​អូរ​ឆ៝ៈ​ឆាយ​នតើម​ឞើស​ទែស ឞូនុយ្ស​អាបាៈ​លែៈ​ឞូ​ចារ​លើយ ឞូនុយ្ស​អាបាៈ​ជឹត​មោ​អុច​អោស​ឆ៝ៈ​អូរ​ឆ៝ៈ​ឆាយ​យ៝រ​មា​អុច​កើល​ជាន​ការ​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់។ លាស​នទ្រី​ឞូ​ម៝ស​អី​ឞ្លាវ​គឹត​វ៝ត់​នាវ​ងើយ​អី​នៃ អ៝ន់​ពាង់​តឹង​កើត​ទោ!” ");
INSERT INTO cmok_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ជេសរី​គែស​ឞូ​លែវ​ក៝ន​ឆែ​ជេៈៗ​ញជុន​អា​ឞ្រាស​យេឆូ  គៃ​មា​អ៝ន់​ពាង់​តេៈ​តី​មឞើស​ឆើម​មា​ខាន់​ពាង់ យើន​មា​មពោល​អ៝ស​ម៝ន​ឞ្វៃ​លើយ​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","យើន​មា​ឞ្រាស​យេឆូ ​លាស៖ “អ៝ន់​ផូង​ក៝ន​ឆែ​វាច់​តា​គ៝ប់ លើយ​អោស​ឞ្វៃ​ខាន់​ពាង់។ ឞូនុយ្ស​អី​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ ខាន់​ពាង់​គែស​កើត​នទ្រី​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ជេស​ឞ្រាស​យេឆូ ​តេៈ​តី​តា​ក៝ន​ឆែ​រី ជេសរី​ពាង់​ទូ​លោស​ឞើស​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","នោក​នៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ហាន់​ទាច់​អា​ឞ្រាស​យេឆូ ​អោប​ពាង់៖ “អើ​នើម​នតី មើម​គ៝ប់​ជាន​នាវ​អ្វែស​គៃ​មា​គែស​នាវ​រេស​នហ៝​រ៝​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “មើម​មៃ​អោប​គ៝ប់​មា​នាវ​អ្វែស? គែស​ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ទើម​ជេង​អ្វែស ជេសរី​លាស​មៃ​អុច​គែស​នាវ​រេស​នហ៝​រ៝ អ៝ន់​មៃ​ញអោត​នាវ​វៃ​ឞ៝ន់​ទោ”។ ");
INSERT INTO cmok_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ពាង់​អោប​ឞ្រាស​យេឆូ ៖ “ម៝ស​នាវ​វៃ​អាបាៈ​មេស?” ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “លើយ​ងខឹត​ឞូ លើយ​ល៝ម់​អូរ​ល៝ម់​ឆាយ លើយ​នតុង លើយ​ងើយ​ញចើត‌ ");
INSERT INTO cmok_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","យើក​មា​មេៈ​ឞឹ​ហ៝ៈ ជេសរី​រ៝ង់​មា​ផូង​ច្យៅ​មែង​តឹម​ឞាន​មា​រ៝ង់​ឆាក់​មៃ​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ឞូ​ក្លោ​នទាម់​អី​នៃ​លាស​មា​ឞ្រាស​យេឆូ ៖ “ទឹង​លែៈ​នាវ​វៃ​អី​នៃ​លែៈ​គ៝ប់​ញអោត​ទាទេ លាស​នទ្រី​ម៝ស​នទើ​អេ​ហ៝ៈ​គែស​ដ៝ង់?” ");
INSERT INTO cmok_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “លាស​មៃ​អុច​ជេង​ឆ៝ង់​ទុត​អ្វែស​ងាន់ អ៝ន់​មៃ​តាច់​ហ៝ម់​ទឹង​លែៈ​ទ្រាប់​នទើ​មៃ​គែស ពាៈ​អ៝ន់​មា​មពោល​អ៝​អាច នទ្រី​មើ​មៃ​គែស​នទើ​ខ្លៃ​តា​ប៝ន​អ្វែស​តា​កាលើ ជេសរី​ហាន់​តឹង​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ត៝ត់​ឞូ​ក្លោ​នទាម់​អី​នៃ​តាង់​នាវ​ងើយ​កើត​នៃ ពាង់​ទូ​ឆឹត​នអ៝ប់​មា​នាវ​រាង៝ត យ៝រ​លាស​ពាង់​គែស​ទ្រាប់​នទើ​ទុត​អ៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ជេរ​ងាន់​មា​ឞូនុយ្ស​នទ្រ៝ង់​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់។ ");
INSERT INTO cmok_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","គ៝ប់​លាស​តៃ​មា​ខាន់​អៃ​មៃ មា​ឞូនុយ្ស​នទ្រ៝ង់​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ ជេរ​រាលាវ​ដាស​អ៝ន់​ឆែស​ឆាមោ​លាប់​តា​ត្រោម​ងលាយ”។ ");
INSERT INTO cmok_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ត៝ត់​មា​តាង់​នាវ​ងើយ​កើត​នៃ មពោល​អ៝ស​ម៝ន​មោ​អោស​គឹត​វ៝ត់ ខាន់​ពាង់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់ អោប​ឞ្រាស​យេឆូ ៖ “លាស​ឞូនុយ្ស​នទ្រ៝ង់​លែៈ​គែស​ជេរ​ជេស​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ លាស​នទ្រី​ឞូនុយ្ស​អា​អេង​ហោម​ទើយ​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ដ៝ង់​លាស​មោ?” ");
INSERT INTO cmok_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ឞ្រាស​យេឆូ ​អ្វាញ់​ជឹត​ខាន់​ពាង់​លាស៖ “នាវ​លាប់​អី​នៃ​ឞូនុយ្ស​ជាន​មោ​អោស​ទើយ យើន​មា​កោរាញ​ឞ្រាស​ទើយ​ជាន​ទាទេ​ទឹង​លែៈ​នទើ”។ ");
INSERT INTO cmok_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ជេសរី​ពេត្រោស ​អោប​ឞ្រាស​យេឆូ ៖ “លែៈ​មៃ​ឆៃ​ហើយ្ស​ហេន ហេន​លែៈ​នត្លើយ​នទ៝ស​នទើ​ហេន​នើម​លែៈ​ផ្យៅ ហាន់​តឹង​មៃ។ លាស​នទ្រី​ហេន​តៃ​ម៝ស​នទើ​គែស?” ");
INSERT INTO cmok_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ នោក​នែស​នតូ​រាគ៝ល់​មហែ នោក​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​គុ​តា​រានើល​កាដាច់​គ៝ប់​អី​គែស​នាវ​ច្រេក​លើប លាស​នទ្រី​ខាន់​មៃ​អី​លែៈ​តឹង​គ៝ប់​គុ​តា​រានើល​កាដាច់ ១២ អឹ​ដ៝ង់ នហ៝​មា​ផាត​ទោយ្ស​លែៈ​ឞូនុយ្ស ១២ មពោល​រាន៝យ​ទែស​ផូង​អីឆ្រាអែល ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","លាស​នទ្រី​ឞូ​ម៝ស​នត្លើយ​ញីស​ជៃ មេៈ​ឞឹ អ៝ស​នោ អ៝ស​នូរ អ៝ស​ក៝ន មោ​លាស​មីរ​ឞា​យ៝រ​មា​តឹង​គ៝ប់ ពាង់​អី​នៃ​គែស​ទូ​មល៝ម់​ជេង​លោស ១០០ នអ៝ប់​មា​ទើន​នាវ​រេស​នហ៝​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","គែស​ឞូនុយ្ស​អ៝ក់​តា​នែស​នតូ​អ្យា​ឞូ​គឹត​ខាន់​ពាង់​គែស​នាវ​ខ្លៃ​ងាន់ យើន​មា​តា​ជឹត​នាប់​តៃ​មោ​អោស​គែស​នាវ​ខ្លៃ។ តីស​មា​គែស​ឞូនុយ្ស​អ៝ក់​អេង​ជឹត​តា​នែស​នតូ​អ្យា​ឞូ​គឹត​ខាន់​ពាង់​មោ​អោស​គែស​នាវ​ខ្លៃ យើន​មា​តា​ជឹត​នាប់​តៃ​បេង​មា​គែស​នាវ​ខ្លៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស តឹម​ឞាន​មា​ទូ​ហ្វេ​ឞូនុយ្ស​គែស​មីរ។ អើម​អោយ​ពាង់​ហាន់ គៃ​មា​ជ៝យ​ឞូនុយ្ស​ជាន​ការ​តា​មីរ​ព្លៃ​យុងយារ​ប៝ន​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ពាង់​លែៈ​តឹម​ទី​ជេស​ទូ​នតោរ​នាវ​អ៝ន់​មា​ទឹង​លែៈ​ឞូនុយ្ស​ជាន​ការ​អី​នៃ​ទូ​មល៝ម់​ព្រាក់​កាក់​ទូ​នារ ជេសរី​ដាៈ​ខាន់​ពាង់​ហាន់​ជាន​ការ​តា​មីរ​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ក្លាប់​លាស​តា​ម៝ង​ឆឹន​ពាង់​ហាន់​តៃ​ដ៝ង់ ឆៃ​ឞូនុយ្ស​អាបាៈ​ហោម​គុ​ទើម​តា​នតុក​តាច់​ទ្រាប់ មោ​គែស​នតុក​ជាន​ការ។ ");
INSERT INTO cmok_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ពាង់​លាស​មា​ខាន់​ពាង់៖ «អ៝ន់​ខាន់​មៃ​ហាន់​ជាន​ការ​តា​មីរ​គ៝ប់​រី គ៝ប់​មរា​ងខោម​ខាន់​មៃ​អ៝ន់​តឹម​ទី»។ ");
INSERT INTO cmok_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ជេសរី​ផូង​អី​នៃ​ហាន់​រ៝។ ត៝ត់​ងគូល​នារ ត៝ត់​ម៝ង​ពែ​កេង​មាង់ ពាង់​ហាន់​ដាៈ​តៃ​ឞូ​អា​អេង​កើត​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ត៝ត់​លែៈ​ម៝ង​ព្រាម់ ពាង់​ហាន់​តៃ​ទូ​តឹ​ជឹត ឆៃ​ឞូនុយ្ស​អាបាៈ​អា​អេង​ជឹត​ហោម​គុ​ទើម​តា​នតុក​តាច់​ទ្រាប់​រី។ ពាង់​លាស​មា​ផូង​អី​នៃ៖ «ម៝ស​គុ​ទើម​ខាន់​មៃ​តា​អ្យា​ទូ​នារ​រាមាង់​នៃ?» ");
INSERT INTO cmok_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ខាន់​ពាង់​អើស៖ «យ៝រ​លាស​មោ​គែស​ឞូនុយ្ស​អុច​ជ៝យ​ហេន​ជាន​ការ»។ ពាង់​លាស​មា​ផូង​អី​នៃ៖ «ខាន់​មៃ​ហាន់​ជាន​ការ​ហ៝ម់​អា​មីរ​គ៝ប់​រី»។ ");
INSERT INTO cmok_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ត៝ត់​កេង​មាង់ ពាង់​អី​តើម​មីរ​នៃ​លាស​មា​ឞូនុយ្ស​ញអោត​ព្រាក់៖ «ក្វាល់​ហ៝ម់​ផូង​ជាន​ការ បើក​ព្រាក់​អ៝ន់​ខាន់​ពាង់ បើក​នតើម​ឞើស​ងគ្លែៈ​ទុត​ឞូ ត៝ត់​មា​ពាង់​អី​ល៝រ​ឞូ»។ ");
INSERT INTO cmok_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ត៝ត់​ផូង​ជាន​ការ​អី​នតើម​ម៝ង​ព្រាម់ ឞូ​បើក​អ៝ន់​ខាន់​ពាង់​ទូ​ហ្វេ​ទូ​មល៝ម់​ព្រាក់​កាក់។ ");
INSERT INTO cmok_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ជេសរី​ត៝ត់​ផូង​ជាន​ការ​អី​ល៝រ​ឞូ ខាន់​ពាង់​ងក្ល៝ន់​គែស​ព្រាក់​អ៝ក់​រាលាវ​ឞូ យើន​មា​គែស​ទូ​មល៝ម់​ព្រាក់​កាក់​តឹម​ឞាន​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ជេស​ខាន់​ពាង់​ឆ៝ៈ​ព្រាក់​អី​នៃ ខាន់​ពាង់​ងើយ​ប្រោក​មា​ឞូនុយ្ស​អី​តើម​មីរ​អី​នៃ៖ ");
INSERT INTO cmok_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","«ផូង​អី​ជាន​ការ​ងគ្លែៈ​ទុត​ឞើស​កើយ ជាន​ទូ​ម៝ង​ទើម។ មៃ​បើក​ព្រាក់​អ៝ន់​ខាន់​ពាង់​តឹម​ឞាន​មា​ហេន​ជាន​ការ​គុ​ថ៝ង់​តា​ទោស​នារ​ទូ​នារ​រាមាង់​ដ៝ង់!» ");
INSERT INTO cmok_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ឞូនុយ្ស​អី​តើម​មីរ​នៃ​លាស​មា​ទូ​ហ្វេ​ឞូនុយ្ស​តា​ខាន់​ពាង់​អី​នៃ៖ «អើ​ជាង់ គ៝ប់​មោ​គែស​អោស​មរោស​មៃ យ៝រ​លាស​មៃ​លែៈ​តឹម​ទី​ទូ​នតោរ​នាវ​អុច​ជាន​ការ​អ៝ន់​គ៝ប់​ទូ​នារ​ទូ​មល៝ម់​ព្រាក់​កាក់។ ");
INSERT INTO cmok_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","លាស​នទ្រី​ឆ៝ៈ​ព្រាក់​មៃ​នៃ​ហាន់​ហ៝ម់ ឞូនុយ្ស​អី​ជាន​ការ​ឞើស​កើយ​មៃ គ៝ប់​អុច​អ៝ន់​តឹម​ឞាន​មា​មៃ​ដ៝ង់‌ ");
INSERT INTO cmok_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","យ៝រ​លាស​ព្រាក់​គ៝ប់​នើម​តឹង​នូយ្ស​នហ៝ម់​គ៝ប់​នើម​អុច​ទ៝ង់។ មោ​លាស​អាច​មា​ឆៃ​គ៝ប់​ជាន​អ្វែស មៃ​តឹម​មោ​នាច​មា​ខាន់​ពាង់?» ");
INSERT INTO cmok_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","គែស​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា​ឞូ​គឹត​ខាន់​ពាង់​គែស​នាវ​ខ្លៃ​ងាន់ យើន​មា​តា​ជឹត​នាប់​តៃ​មោ​អោស​គែស​នាវ​ខ្លៃ។ តីស​មា​គែស​ឞូនុយ្ស​អេង​ជឹត​តា​នែស​នតូ​អ្យា​ឞូ​គឹត​ខាន់​ពាង់​មោ​អោស​គែស​នាវ​ខ្លៃ យើន​មា​តា​ជឹត​នាប់​តៃ​បេង​មា​គែស​នាវ​ខ្លៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","នោក​ឞ្រាស​យេឆូ ​ហាន់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ពាង់​លែវ ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​ពាង់ ហាន់​អេង នោក​ហោម​ហាន់​រ៝ៈ​ត្រ៝ង ពាង់​លាស​មា​ខាន់​ពាង់​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“អាបៃ​អ្យា​ឞ៝ន់​ហាន់​ជឹត​ប៝ន​យេរូឆាលឹម ។ គ៝ប់​អ្យា​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស ឞូ​ទែ​ញជុន​អ៝ន់​មា​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់។ ជេសរី​ខាន់​ពាង់​អី​នៃ​តេៈ​ទោយ្ស​គ៝ប់​ត៝ត់​ខឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ខាន់​ពាង់​អី​នៃ​ញជុន​គ៝ប់​មា​ផូង​អី​មោ​ទី​ផូង​អីឆ្រាអែល  អ៝ន់​ឞូ​គើម​ងគ្រើស រាពាត់​មា​ម៝ង់​រាឆែ នហ៝​មា​ងខឹត​គ៝ប់​តា​ឆី​តឹម​រាកាង់។ យើន​មា​ត៝ត់​ពែ​នារ​កោរាញ​ឞ្រាស​អ៝ន់​គ៝ប់​ទ៝ក់​រេស​តៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","នោក​នៃ​អី​អូរ​ឆេបេដេ  លែវ​ឞារ​ហៃ​ក៝ន​ពាង់​នើម​ហាន់​ច៝ន​កោម៝ក់​តា​ជ៝ង់​ឞ្រាស​យេឆូ ​រី អុច​ទាន់​ទូ​នតីល​នាវ។ ");
INSERT INTO cmok_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ឞ្រាស​យេឆូ ​អោប​ពាង់៖ “ម៝ស​នាវ​អៃ​អុច?” ពាង់​អើស៖ “នោក​មៃ​ជេង​កាដាច់​ងាន់​តា​នាវ​មៃ​នើម​ម៝ត់​អ្វាញ់​តៃ អ៝ន់​ឞារ​ហៃ​ក៝ន​គ៝ប់​អ្យា​ជេង​ក្វ៝ង់​រាលាវ​ឞូ​គុ​តា​ន៝ម់​មៃ​នើម ទូ​ហ្វេ​គុ​ឞើស​មា​ទូ​ហ្វេ​គុ​ឞើស​ច្យៅ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","យើន​មា​ឞ្រាស​យេឆូ ​អើស៖ “ខាន់​អៃ​មៃ​មោ​គឹត​វ៝ត់​អោស ម៝ស​នទើ​ខាន់​អៃ​មៃ​ទាន់។ លាស​នទ្រី​ខាន់​មៃ​ទើយ​ឆ៝ៈ​ទើយ​ញេត​ដ៝ង់​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​តា​កាច៝ក​អី​គ៝ប់​ឞែ​ញេត គែស​នាវ​ខ្លៃ​លាស​គែស​នាវ​ជេរ​ជ៝ត់​កើត​គ៝ប់​ដ៝ង់?” យាកើ  នទ្រែល​មា​យោហាន ​អើស៖ “អើ ហេន​ទើយ​ឆ៝ៈ​ទើន”។ ");
INSERT INTO cmok_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “នាវ​ខាន់​មៃ​ឆ៝ៈ​ទើន​ញេត​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​តា​កាច៝ក​អី​គ៝ប់​ញេត​មរា​គែស​ងាន់ តីស​មា​អី​នាវ​គុ​ឞើស​មា​ឞើស​ច្យៅ​រី គ៝ប់​មោ​អោស​ទើយ​រ៝ម យ៝រ​មា​នតុក​អី​នៃ​លែៈ​នទ្រាប់​អ៝ន់​មា​ឞូនុយ្ស​អី​ឞឹ​គ៝ប់​នើម​លែៈ​អុច​អ៝ន់​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ត៝ត់​មពោល​អ៝ស​ម៝ន​អី​ជឹត​នុយ្ស​នៃ​តាង់​លាស​កើត​នៃ ខាន់​ពាង់​ជី​នូយ្ស​មា​ឞារ​ហៃ​ខាន់​ពាង់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ជេសរី​ឞ្រាស​យេឆូ ​ក្វាល់​ទឹង​លែៈ​មពោល​អ៝ស​ម៝ន​ពាង់ ជេសរី​លាស៖ “ខាន់​មៃ​លែៈ​គឹត​ហើយ្ស​ឞូនុយ្ស​អី​ម៝ត់​អ្វាញ់​មា​ផូង​ឞូនុយ្ស​អី​មោ​ទី​ផូង​អីឆ្រាអែល  ខាន់​ពាង់​អី​នៃ​ទាស​អុច​ជាន​មា​ផូង​ប៝ន​លាន​ខាន់​ពាង់​នើម គែស​ដ៝ង់​មពោល​អី​តេស​ក្វ៝ង់​តុន​ជ៝ត​មា​ផូង​ប៝ន​លាន​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","តា​មពោល​ខាន់​មៃ​តៃ​មោ​អោស​គែស​កើត​នៃ! តា​មពោល​ខាន់​មៃ​លាស​គែស​ទូ​ហ្វេ​អុច​ជាន​ក្វ៝ង់ អ៝ន់​ពាង់​អី​នៃ​ជេង​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មា​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","លាស​គែស​ទូ​ហ្វេ​អុច​ជាន​ក្វ៝ង់​រាលាវ​ឞូ អ្យាត់​មា​ពាង់​ជាន​ទឹក​មា​ខាន់​មៃ​ប៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","តឹម​ឞាន​មា​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​វាច់​តា​នែស​នតូ​អ្យា មោ​អោស​គ៝ប់​ដាៈ​ឞូ​ឆើម​កើល​ជាន​ការ​អ៝ន់​មា​គ៝ប់។ បេង​មា​គ៝ប់​ច្រាវ​ឆើម​កើល​ជាន​ការ​អ៝ន់​មា​ឞូ ជេសរី​គ៝ប់​ជាវ​ឆាក់​គ៝ប់​នើម​ត៝ត់​ខឹត​ឆាក់ គៃ​មា​ច្វាយ​អ៝ក់​ឞូនុយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","នោក​ខាន់​ពាង់​លោស​ឞើស​ប៝ន​យេរីខោ  គែស​អ៝ក់​ឞូនុយ្ស​តឹង​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","នោក​នៃ​គែស​ឞារ​ហៃ​ឞូនុយ្ស​ចែស​មាត់​គុ​តា​មែង​ត្រ៝ង​រី។ ត៝ត់​ខាន់​ពាង់​តាង់​លាស​ឞ្រាស​យេឆូ ​ហាន់​រ៝ៈ​ត្រ៝ង​នៃ ខាន់​ពាង់​នតែរ​រ៝៖ “អើ​កោរាញ​អី​ក៝ន​ឆៅ​កាដាច់​ដាវីត  យោៈ​នអាច​ហេន​បាៈ​អើ!” ");
INSERT INTO cmok_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","គែស​ឞូនុយ្ស​អ៝ក់​ឞ្វៃ​ខាន់​ពាង់​អ៝ន់​គុ​អ្យាត់​ឆាក់​រាក្លាក់​ហ៝ៈ យើន​មា​លើ​ហោ​ខាន់​ពាង់​នតែរ៖ “អើ​កោរាញ​អី​ក៝ន​ឆៅ​កាដាច់​ដាវីត  យោៈ​នអាច​ហេន​អើ!” ");
INSERT INTO cmok_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ឞ្រាស​យេឆូ ​ញឆ្រុង ជេសរី​ក្វាល់​ឞារ​ហៃ​ឞូនុយ្ស​ចែស​មាត់​អី​នៃ​អោប៖ “ម៝ស​នទើ​ខាន់​មៃ​អុច​អ៝ន់​គ៝ប់​ជាន​មា​ខាន់​មៃ?” ");
INSERT INTO cmok_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ខាន់​ពាង់​អើស៖ “អើ​កោរាញ អ៝ន់​មាត់​ហេន​ឆៃ​អាង”។ ");
INSERT INTO cmok_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ឞ្រាស​យេឆូ ​យោៈ​នអាច​ខាន់​ពាង់​ហោ​ងាន់ ពាស​ត្រោម​មាត់​ខាន់​ពាង់ ជេសរី​ត្រោម​មាត់​ខាន់​ពាង់​ទោ​មា​ឆៃ​អាង​រ៝ ជេសរី​ខាន់​ពាង់​តឹង​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","នោក​ឞ្រាស​យេឆូ ​ហាន់​ឞើយ​មា​ត៝ត់​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  លែៈ​ត៝ត់​តា​ប៝ន​បេតផាឆេ ​តា​យោក​តើម​អោលីវ ពាង់​ដាៈ​ឞារ​ហៃ​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​ល៝រ‌ ");
INSERT INTO cmok_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ពាង់​លាស៖ “អ៝ន់​ខាន់​មៃ​ហាន់​តា​ប៝ន​ឞើស​នាប់​រី លាប់​តា​ប៝ន​នៃ​ខាន់​មៃ​មរា​ឆៃ​ទូ​មល៝ម់​មែ​ឆែស​លៀ​ឞូ​ក៝ត់​នអ៝ប់​មា​ក៝ន​ពាង់​ដ៝ង់។ ខាន់​មៃ​ទ្រ៝ស​តេក​លែៈ​ឞារ​អា​គ៝ប់​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","លាស​គែស​ឞូ​អោប​ខាន់​មៃ ខាន់​មៃ​លាស​មា​ពាង់​កើត​នអា៖ «កោរាញ​អុច​ទ៝ង់​ពាង់​ទឹង​លែៈ​ឞារ» ឞូ​មរា​អ៝ន់​ខាន់​មៃ​តេក​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ទឹង​លែៈ​នាវ​អ្យា​គែស គៃ​មា​តឹម​ទី​ដាស​នាវ​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ញចីស​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«អ៝ន់​មឞើស​ងក៝ច​ហ៝ម់​មា​ផូង​ប៝ន​លាន​តា​ប៝ន​យេរូឆាលឹម ៖ «ល៝ង់​អ្វាញ់​អ្យា កាដាច់​ខាន់​អៃ​មៃ​វាច់។ ពាង់​មលែស​ហោ​ងាន់ ញច៝​តា​កាលើ​ឆែស​លៀ‌ ញច៝​តា​ក៝ន​ឆែស​លៀ​ដ៝ង់»»។ ");
INSERT INTO cmok_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ជេសរី​ឞារ​ហៃ​មពោល​អ៝ស​ម៝ន​អី​នៃ​ហាន់​ជាន​កើត​នាវ​ឞ្រាស​យេឆូ ​ដាៈ។ ");
INSERT INTO cmok_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ខាន់​ពាង់​តេក​មែ​ឆែស​លៀ នអ៝ប់​មា​អី​ក៝ន​ពាង់ ជេសរី​នតាៈ​អាវ​ក្វ៝ង់​ខាន់​ពាង់​នើម​តា​កាលើ​លែៈ​ឞារ​មល៝ម់​ឆែស​នៃ អ៝ន់​ឞ្រាស​យេឆូ ​ញច៝​លាប់​តា​ប៝ន។ ");
INSERT INTO cmok_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ផូង​ប៝ន​លាន​ទុត​អ៝ក់​ងាន់​តា​ប៝ន​នៃ ខាន់​ពាង់​ទ្រ៝ស​អាវ​ក្វ៝ង់​ខាន់​ពាង់​នើម​លាក់​តា​ត្រ៝ង។ ឞូនុយ្ស​អាបាៈ​តែ​នថាន​ឆី​ឞើស​មីរ​លាក់​រ៝ៈ​ត្រ៝ង​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ឞូនុយ្ស​អ៝ក់​ងាន់​ឞ្រោៈ​តឹង​ឞ្រាស​យេឆូ ​ឞើស​នាប់​ឞើស​កើយ លែវ​ឞាល់​នតែរ​ទ្រើវ​លាស៖ “រានេ​មា​កោរាញ​ឞ្រាស​អ៝ន់​មា​អី​ក៝ន​ឆៅ​កាដាច់​ដាវីត ! ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​ពាង់​អី​កោរាញ​ឞ្រាស​ទែ​ដាៈ​វាច់! រានេ​មា​កោរាញ​ឞ្រាស​អី​គុ​កាលើ​ត្រោក​ទុត​ព្រេស​រី!” ");
INSERT INTO cmok_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","នោក​ឞ្រាស​យេឆូ ​លាប់​តា​ប៝ន​យេរូឆាលឹម  ទឹង​លែៈ​ឞូនុយ្ស​តា​ប៝ន​នៃ​គែស​នាវ​នទ្រ៝ត់​ទុត​ហោ​ងាន់ ខាន់​ពាង់​មោ​អោស​វ៝ត់ អោប៖ “ឞូ​ម៝ស​ពាង់​អី​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ផូង​ឞូនុយ្ស​អី​តឹង​ឞ្រាស​យេឆូ ​លាស៖ “ពាង់​អ្យា​យេឆូ ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​តាៈ​ឞើស​ប៝ន​នាឆារែត ​ឞ្រី​កាលីលេ ”។ ");
INSERT INTO cmok_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ជេសរី​ឞ្រាស​យេឆូ ​នទ្រែល​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​លាប់​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស។ ផូង​អី​តាច់​រាគ៝ល់​តា​នៃ​ពាង់​មព្រើស​លែៈ​ផ្យៅ។ ពាង់​ងក្លឹ​គ្រែ​ឞូ​គុ​រាគ៝ល់​ព្រាក់ នអ៝ប់​មា​គ្រែ​ឞូ​តាច់​ព្លុក។ ");
INSERT INTO cmok_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ឞ្រាស​យេឆូ ​លាស​ខាន់​ពាង់​អី​នៃ៖ “តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​គែស​ញចីស​កើត​នអា៖ «កោរាញ​ឞ្រាស​លាស៖ «ញីស​គ៝ប់​ជេង​នតុក​មា​មឞើស​ឆើម​មា​គ៝ប់»» បេង​មា​ខាន់​មៃ​ឆ៝ៈ​ជាន​នតុក​គុ​រាគូម​មពោល​នតុង​ច្រាវ”។ ");
INSERT INTO cmok_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","នោក​នៃ​គែស​ឞូនុយ្ស​ចែស​មាត់ នទ្រែល​មា​ឞូនុយ្ស​ក្វែត​រាវែន​ហាន់​អា​ឞ្រាស​យេឆូ ​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​រី ជេសរី​ពាង់​ជាន​ឞាស​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","យើន​មា​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  ឆៃ​ឞ្រាស​យេឆូ ​ជាន​នទើ​អី​នៃ​លែៈ​នាវ​ងាន់ ជេសរី​តាង់​ផូង​ក៝ន​ឆែ​នតែរ​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​លាស៖ “រានេ​មា​កោរាញ​ឞ្រាស​មា​អី​ក៝ន​ឆៅ​កាដាច់​ដាវីត !” ខាន់​ពាង់​ជី​នូយ្ស​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ខាន់​ពាង់​អោប​ឞ្រាស​យេឆូ ៖ “មៃ​តាង់​ដ៝ង់​នាវ​ផូង​ក៝ន​ឆែ​នតែរ​នៃ?” ឞ្រាស​យេឆូ ​អើស៖ “តាង់​ដ៝ង់។ លាស​នទ្រី​ខាន់​មៃ​លែៈ​អ្វាញ់​ដ៝ង់​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​ញចីស​កើត​នអា៖ «អើ​កោរាញ​ឞ្រាស មៃ​លែៈ​នទ្រាប់​អ៝ន់​នាវ​រានេ​មា​មៃ​នើម តា​មឞូង​ក៝ន​ឆែ នទ្រែល​មា​តា​អ៝ស​ឞេ​ហោម​ពូ​ត៝ស»”។ ");
INSERT INTO cmok_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ជេសរី​ឞ្រាស​យេឆូ ​នត្លើយ​ខាន់​ពាង់​គុ​តា​នៃ។ ពាង់​លោស​ឞើស​នតុក​នៃ​ហាន់​តា​ប៝ន​បេថានី  គុ​តា​ប៝ន​នៃ​ទូ​មាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ត៝ត់​អើម​អោយ អោយ​តៃ​ឞ្រាស​យេឆូ ​ព្លឹ​តៃ​តា​ប៝ន​យេរូឆាលឹម ។ នោក​នៃ​ពាង់​ជី​ង៝ត។ ");
INSERT INTO cmok_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ពាង់​ឆៃ​តើម​ព្លៃ​រាវី ​ទូ​តើម​រ៝ៈ​ត្រ៝ង ជេសរី​ពាង់​ហាន់​ទាច់​តើម​ព្លៃ​អី​នៃ​ជ៝យ​ព្លៃ យើន​មា​មោ​អោស​គែស​ព្លៃ គែស​នហា​ទើម។ ពាង់​លាស​មា​តើម​ព្លៃ​អី​នៃ៖ “នតើម​ឞើស​នារ​អ្យា មៃ​តើម​ព្លៃ​អី​អ្យា​លើយ​ហោម​អោស​គែស​ព្លៃ!” ជេសរី​ទោ​មា​នទ្រ៝​រ៝​តើម​រាវី ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ត៝ត់​មា​មពោល​អ៝ស​ម៝ន​ឆៃ​កើត​នៃ ខាន់​ពាង់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់ ខាន់​ពាង់​អោប៖ “មើម​នទ្រ៝​នទាល​តើម​រាវី ​អី​អ្យា​ហ្យាស?” ");
INSERT INTO cmok_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ លាស​ខាន់​មៃ​លែៈ​គែស​នាវ​ញឆីង​ន៝ប់​មោ​គែស​នាវ​វិ​វែៈ​តា​នូយ្ស​នហ៝ម់ មោ​អោស​ទើន​កើត​មា​គ៝ប់​ជាន​តើម​ព្លៃ​រាវី ​អ្យា​ទើម​ខាន់​មៃ​ទើយ​ជាន យើន​មា​លាស​ខាន់​មៃ​ដាៈ​យោក​អ្យា៖ «ទូ​ហ៝ម់​ឞើស​នតុក​អ្យា អ៝ន់​តុប​អា​ទាក​វាច់​ទាក​វារ់​រី» ពាង់​គែស​កើត​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ម៝ស​នទើ​ខាន់​មៃ​មឞើស​ឆើម​ទាន់​កោរាញ​ឞ្រាស​មា​នូយ្ស​នហ៝ម់​គែស​នាវ​ញឆីង ខាន់​មៃ​គែស​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ជេសរី​ឞ្រាស​យេឆូ ​លាប់​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស។ នោក​ពាង់​នតី​ឞូ គែស​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​មពោល​ឞូ​រាញ​ផូង​ប៝ន​លាន​ហាន់​អា​ឞ្រាស​យេឆូ ​អោប​ពាង់៖ “មឞើស​អ៝ន់​មា​ហេន​គឹត នទើ​មៃ​ជាន​អ្យា​ឞើស​តាៈ​នាវ​ទើយ? ឞូ​ម៝ស​អ៝ន់​នាវ​ទើយ​អី​នៃ​មា​មៃ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ឞ្រាស​យេឆូ ​អើស៖ “គ៝ប់​អោប​ទូ​នាវ​មា​ខាន់​មៃ​ប៝ត់ ល៝ង់​ខាន់​មៃ​អើស​មា​គ៝ប់​ដ៝ង់ នទ្រី​មើ​គ៝ប់​មរា​មឞើស​មា​ខាន់​មៃ ឞើស​តាៈ​នាវ​ទើយ​មា​នទើ​អី​គ៝ប់​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","លាស​នទ្រី​ឞូ​ម៝ស​ដាៈ​យោហាន-​បាប់តែម ​ជាន​បាប់តែម​យុក​មា​ទាក? តាៈ​ឞើស​កោរាញ​ឞ្រាស មោ​លាស​តាៈ​ឞើស​ឞូនុយ្ស?” ខាន់​ពាង់​តឹម​ញច្រាៈ​អេង៖ “លាស​ឞ៝ន់​លាស៖ «តាៈ​ឞើស​កោរាញ​ឞ្រាស» ពាង់​មរា​លាស​ឞ៝ន់៖ «លាស​នទ្រី​មើម​ទឹង​ខាន់​មៃ​មោ​អ្យាត់​នាវ​ពាង់?» ");
INSERT INTO cmok_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","លាស​ឞ៝ន់​អើស៖ «តាៈ​ឞើស​ឞូនុយ្ស» នទ្រី​ឞ៝ន់​ក្លាច​ផូង​ប៝ន​លាន​ជី​នូយ្ស យ៝រ​មា​អ៝ក់​ឞូនុយ្ស​អ្យាត់​នាវ​យោហាន-​បាប់តែម ​កើប​ពាង់​ជេង​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ជេសរី​ខាន់​ពាង់​អើស​មា​ឞ្រាស​យេឆូ ៖ “ហេន​មោ​អោស​គឹត!” ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “លាស​នទ្រី​គ៝ប់​មោ​មឞើស​អ៝ន់​មា​ខាន់​មៃ​គឹត​ដ៝ង់ ឞូ​ម៝ស​អ៝ន់​នាវ​ទើយ​គ៝ប់​ជាន​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“មើម​ខាន់​មៃ​វ៝ត់​មា​នាវ​នតឹត​ឞារ​ហៃ​ក៝ន​ឞូ​ក្លោ? គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​គែស​ឞារ​ហៃ​ក៝ន​ឞូ​ក្លោ ពាង់​លាស​មា​ក៝ន​ឞោក​ទាក៖ «អើ​នោ នារ​អ្យា​ដាៈ​មៃ​ហាន់​ជាន​ការ​តា​មីរ​ព្លៃ​យុងយារ​ប៝ន​រី»។ ");
INSERT INTO cmok_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","អី​ក៝ន​ពាង់​អើស៖ «គ៝ប់​មោ​អុច​ហាន់​អោស!» យើន​មា​ឞើស​កើយ​នៃ​ពាង់​រាគ៝ល់​នាវ​មឹន ជេសរី​ហាន់​តា​មីរ។ ");
INSERT INTO cmok_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ជេសរី​អី​ឞឹ​ងើយ​កើត​នៃ​ដ៝ង់​មា​ក៝ន​អា​អេង ក៝ន​អី​នៃ​អើស៖ «អើ​គ៝ប់​ហាន់​ឞឹ!» យើន​មា​ពាង់​មោ​ហាន់​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","លាស​នទ្រី​ទឹង​លែៈ​ឞារ​ហៃ​ក៝ន​អី​នៃ ឞូ​ម៝ស​អី​អ្យាត់​នាវ​ឞឹ​ពាង់?” ខាន់​ពាង់​អើស៖ “អី​នោ”។ ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ មពោល​ក៝ប់​ឆ៝ៈ​ព្រាក់​ផូង​ប៝ន​លាន​គៃ​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ នទ្រែល​មា​ឞូ​អូរ​វាង់​តឹរ ខាន់​ពាង់​អី​នៃ​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ល៝រ​ឞើស​នាប់​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","យ៝រ​លាស​យោហាន-​បាប់តែម ​លែៈ​វាច់​នតុម​នតី​នាវ​គុ​រេស​តឹង​នាវ​កោរាញ​ឞ្រាស​អុច​មា​ខាន់​មៃ តីស​មា​ខាន់​មៃ​មោ​អុច​អោស​អ្យាត់​ពាង់។ មពោល​ក៝ប់​ឆ៝ៈ​ព្រាក់​ផូង​ប៝ន​លាន​អី​នៃ នទ្រែល​មា​ឞូ​អូរ​វាង់​តឹរ​អី​នៃ ខាន់​ពាង់​អ្យាត់​នាវ​ពាង់។ ល៝ង់​ខាន់​មៃ​ឞ៝ល​លាស​លែៈ​ឆៃ​ទឹង​លែៈ​នាវ​អី​នៃ​កាដោយ ខាន់​មៃ​ហោម​អែ​មោ​អុច​អោស​រាគ៝ល់​នូយ្ស​នហ៝ម់​គឹត​មឹន​មា​ពាង់ មោ​អុច​ញឆីង​មា​ពាង់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“ទាន់​អ្យាត់​ទូ​នាវ​ងើយ​នតឹត​អេង​ជឹត។ គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​តាម់​ទូ​លោក​មីរ​តើម​ព្លៃ​យុងយារ​ប៝ន។ ពាង់​ជាន​ងគារ​ជុម​មីរ​នៃ ជាន​ទូ​នតុក​មា​ឞូ​ញជ៝ត​ព្លៃ​អី​នៃ នទ្រែល​មា​ជាន​ទូ​មល៝ម់​ច្វាញ​ងកើង​ដ៝ង់​គៃ​មា​ញជ្រាង់។ ជេសរី​អ៝ន់​ឞូ​ម៝ត់​មីរ​អី​នៃ ដាៈ​ឞូ​ពាៈ​ព្លៃ​មា​ពាង់​អាប់​នាម់។ ពាង់​នើម​រី​ហាន់​គុ​ឞ្រី​អេង។ ");
INSERT INTO cmok_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ត៝ត់​ទី​ខៃ​ទុម​ព្លៃ​យុងយារ​ប៝ន​រី ពាង់​ដាៈ​ទឹក​ពាង់​អាបាៈ​ហាន់​តឹម​ម៝ប់​មា​មពោល​ម៝ត់​មីរ​អី​នៃ គៃ​មា​ឆ៝ៈ​ព្លៃ​អី​ឞូ​ពាៈ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","មពោល​ម៝ត់​មីរ​អី​នៃ​ញុប​ខាន់​ពាង់ អី​ទូ​ហ្វេ​មឞាង អី​ទូ​ហ្វេ​ងខឹត​លើយ ជេសរី​អី​ទូ​ហ្វេ​ជឹត​នតុប​អោឞាល់​មា​លុ។ ");
INSERT INTO cmok_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ជេសរី​ពាង់​ដាៈ​តៃ​ទឹក​ពាង់​អា​អេង​ជឹត​ហាន់ អ៝ក់​រាលាវ​ទឹក​អី​ឞើស​កើយ​នើស។ យើន​មា​មពោល​ម៝ត់​មីរ​លើស​ខាន់​ពាង់​កើត​ទឹក​អី​ឞើស​កើយ​នើស​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","កេង​មា​ទុត​ពាង់​ដាៈ​អី​ក៝ន​ឞូ​ក្លោ​ពាង់​នើម​ហាន់​ឞើស​កើយ​ឞូ ពាង់​មឹន​អេង​លាស៖ «ឞូ​ក្លាច​យើក​មា​ក៝ន​គ៝ប់​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","យើន​មា​ត៝ត់​មពោល​ម៝ត់​មីរ​ឆៃ​ពាង់ ខាន់​ពាង់​តឹម​លាស៖ «ពាង់​អី​នៃ​រ៝​នត្រ៝ៈ​នទើន​មីរ​អី​អ្យា​នារ​ជឹត​នាប់​តៃ។ ហាន់​ឞ៝ន់​ងខឹត​លើយ​ពាង់​អី​នៃ​ទោស ឆ៝ៈ​មីរ​អី​អ្យា​មា​ឞ៝ន់​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ជេសរី​ឞូ​ទែ​ញុប​អី​ក៝ន​ពាង់​នើម​អី​តើម​មីរ​នៃ មអារ់​អោឞាល់​ឞើស​ទីស​មីរ​អី​នៃ ងខឹត​លើយ​អោឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","លាស​ត៝ត់​ពាង់​នើម​អី​តើម​មីរ​ហាន់ មើម​ពាង់​ជាន​មា​មពោល​ម៝ត់​មីរ​អី​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ខាន់​ពាង់​អើស​មា​ពាង់៖ “ពាង់​ងខឹត​ងក្រីត​លើយ​មពោល​អ្យើស​អី​នៃ​រ៝ មោ​អោស​គែស​រ៝ង ជេសរី​ជ៝យ​ងខោម​អ៝ន់​ឞូ​អេង​ជឹត​ម៝ត់​មីរ​ពាង់ មពោល​អី​ពាៈ​ព្លៃ​មា​ពាង់​ត៝ត់​ទី​ខៃ​ពែៈ​ព្លៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “នទ្រី​ខាន់​មៃ​មោ​គែស​រ៝ៈ​ឆ៝ម់បុត​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​គែស​ញចីស​លាស៖ «ឞូនុយ្ស​ឞ្លាវ​ជាន​ជៃ​លុ​ឞ្ល៝ន​លែៈ​មអារ់​លើយ​ទូ​មល៝ម់​លុ​ឞ្ល៝ន‌ យើន​មា​លុ​ឞ្ល៝ន​អី​នៃ​ងខើង​មា​ជេង​លុ​ទុត​ន៝ប់​ខ្លៃ​រាលាវ​ឞូ​មា​ជាន​ជៃ។ កោរាញ​ឞ្រាស​នើម​ជាន​នាវ​អី​នៃ​លែៈ​នាវ​ងាន់‌ ឆៃ​កើត​នៃ​អ៝ន់​ឞ៝ន់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ហោ​ងាន់»។ ");
INSERT INTO cmok_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","កើត​នទ្រី​ទឹង​គ៝ប់​លាស​មា​ខាន់​មៃ កោរាញ​ឞ្រាស​ឆ៝ៈ​លើយ​នាវ​ពាង់​នើម​ម៝ត់​អ្វាញ់​តាៈ​ឞើស​ខាន់​មៃ​អ៝ន់​ផូង​ឞូនុយ្ស​អេង​អី​អ៝ន់​គែស​ព្លៃ​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","លាស​នទ្រី​ម៝ស​នាវ​ឞូ​នតឹត​អ្យា? លុ​ឞ្ល៝ន​អី​នៃ​ជេង​នតឹត​មា​គ៝ប់។ ឞូ​ម៝ស​អី​ចោត​តា​លុ​ឞ្ល៝ន​អី​នៃ ពាង់​អី​នៃ​លេក​រាហ៝ច់​រ៝។ ជេសរី​លាស​លុ​ឞ្ល៝ន​អី​នៃ​តុប​កាលើ​ទូ​ហ្វេ​ឞូនុយ្ស ឞូនុយ្ស​អី​នៃ​ហាច់​លែៈ​ផ្យៅ”។ ");
INSERT INTO cmok_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","នោក​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​ផារីឆី ​តាង់​នាវ​នតឹត​កើត​នៃ ខាន់​ពាង់​គឹត​លាស​ឞ្រាស​យេឆូ ​លាស​នត្រ៝ង់​ជឹត​ខាន់​ពាង់​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ខាន់​ពាង់​អុច​ញុប​ឞ្រាស​យេឆូ  តីស​មា​ខាន់​ពាង់​ក្លាច​មា​ផូង​ប៝ន​លាន យ៝រ​លាស​ផូង​ប៝ន​លាន​កើប​ពាង់​ជេង​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ឞ្រាស​យេឆូ ​ងើយ​នតឹត​មា​ខាន់​ពាង់​ទូ​តឹ​ជឹត៖ ");
INSERT INTO cmok_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​តឹម​ឞាន​មា​ទូ​ហ្វេ​កាដាច់​នទ្រាប់​នាវ​ញេត​ឆោង​ក្វ៝ង់​មា​នអាប់​ក៝ន​នទាម់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ជេសរី​ពាង់​ដាៈ​ផូង​ទឹក​ពាង់​ហាន់​ក្វាល់​ឞូនុយ្ស​អី​លែៈ​ពាង់​ជាៈ​លាប់​ញេត​ឆោង​ឆា​តឹម​នអាប់​អី​នៃ យើន​មា​ខាន់​ពាង់​មោ​អុច​អោស​វាច់។ ");
INSERT INTO cmok_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ពាង់​ដាៈ​តៃ​ផូង​ទឹក​អា​អេង​ជឹត​ហាន់ លាស​មា​ផូង​ទឹក​អី​នៃ៖ «អ៝ន់​ខាន់​មៃ​មឞើស​មា​ឞូនុយ្ស​អី​លែៈ​ជេស​ជាៈ៖ «គ៝ប់​លែៈ​ជេស​នទ្រាប់​ផ្យៅ​ព្យាង់​ត្រាវ គ៝ប់​លែៈ​មឞាង​នទ្រោក នទ្រែល​មា​មពោមពា​(ឆ្យុម)​អី​គ៝ប់​ពេត លាស​នទ្រី​ហាន់​ញេត​ឆោង​ហ៝ម់!»» ");
INSERT INTO cmok_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","យើន​មា​ឞូ​មោ​អោស​គែស​ទោស​តោរ អាបាៈ​លោស​អា​មីរ អាបាៈ​ហាន់​តាច់​ទ្រាប់‌ ");
INSERT INTO cmok_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","អាបាៈ​ជឹត​ញុប​លើស​ផូង​ទឹក​ពាង់ នហ៝​មា​ងខឹត​លើយ​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","កាដាច់​ជី​នូយ្ស​ហោ​ងាន់ ជេសរី​ដាៈ​ផូង​តាហែន​ហាន់​ងខឹត​លើយ​ផូង​អី​ងខឹត​ទឹក​ពាង់​នៃ នហ៝​មា​ឆូ​ប៝ន​ខាន់​ពាង់​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ជេសរី​ពាង់​លាស​មា​ផូង​ទឹក​ពាង់៖ «នាវ​ញេត​ឆោង​តឹម​នអាប់​ឞ៝ន់​នទ្រាប់​លែៈ​ជេស​ផ្យៅ យើន​មា​ទឹង​លែៈ​ផូង​អី​នៃ​មោ​គែស​អោស​ទី​លាប់​តា​នតុក​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","លាស​នទ្រី​ខាន់​មៃ​ហាន់​ហ៝ម់​រ៝ៈ​មែង​ត្រ៝ង ជាៈ​ទឹង​លែៈ​ឞូនុយ្ស​អី​ខាន់​មៃ​ម៝ប់​អ៝ន់​ខាន់​ពាង់​លាប់​ញេត​ឆោង​ឆា​នទ្រែល​តា​អ្យា​ទាទេ»។ ");
INSERT INTO cmok_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ជេសរី​ផូង​ទឹក​ពាង់​ហាន់​រ៝ៈ​ត្រ៝ង ជាៈ​ទឹង​លែៈ​ឞូនុយ្ស​អី​ខាន់​ពាង់​ម៝ប់ នអ៝ប់​មា​ឞូនុយ្ស​អ្វែស​ឞូនុយ្ស​អ្យើស គែស​ឞេង​ជៃ​(រោង) តឹម​នអាប់​រី​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","នោក​កាដាច់​លាប់​តា​ត្រោម​ជៃ​តឹម​នអាប់​អ្វាញ់​ឞូ​នាច់​គុ​ឆោង​ឆា​តា​នៃ ពាង់​ឆៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ញឆ៝ស​ងគូត​មោ​អោស​តឹម​ទី​មា​នាវ​ញេត​ឆោង​តឹម​នអាប់។ ");
INSERT INTO cmok_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ពាង់​លាស​មា​ឞូ​ក្លោ​អី​នៃ៖ «អើ​ជាង់! មើម​មៃ​លាប់​តា​នតុក​អ្យា​ញឆ៝ស​ងគូត​មោ​តឹម​ទី​ដាស​នាវ​ញេត​ឆោង​តឹម​នអាប់?» ឞូ​ក្លោ​អី​នៃ​ជ៝យ​នាវ​មា​អើស​មោ​ហោម​អោស​ឞ្លាវ។ ");
INSERT INTO cmok_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","កាដាច់​លាស​មា​ផូង​កើល​ជាន​ការ​មា​ពាង់៖ «ញុប​ក៝ត់​ជ៝ង់​តី​ពាង់ មអារ់​ពាង់​ឞើស​ទីស​តា​នតុក​ង៝ តា​នតុក​នៃ​គែស​នាវ​ញហ្យាង់​ញុម នទ្រែល​មា​រាច្យាត់​ឆេក»។ ");
INSERT INTO cmok_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ឞូនុយ្ស​កោរាញ​ឞ្រាស​ក្វាល់​អ៝ក់​ងាន់ យើន​មា​ដេៈ​ទើម​ពាង់​កើយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","នោក​នៃ​ផូង​ផារីឆី ​ហាន់​តឹម​ញច្រាៈ​ឞាល់ ជ៝យ​ញុប​នាវ​តីស​តា​នាវ​ឞ្រាស​យេឆូ ​ងើយ។ ");
INSERT INTO cmok_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ជេសរី​ខាន់​ពាង់​ដាៈ​មពោល​អ៝ស​ម៝ន​ខាន់​ពាង់ នទ្រែល​មា​មពោល​អី​តឹង​កោរាញ​ម៝ត់​អ្វាញ់​ហេរោត-​អ៝ន់តីពាស ​ហាន់​អា​ឞ្រាស​យេឆូ ។ ត៝ត់​តា​នៃ​ខាន់​ពាង់​អោប៖ “ហើយ​នើម​នតី! ហេន​គឹត​មៃ​ឞូនុយ្ស​ឆ៝ង់​ងាន់ មៃ​នតី​នាវ​កោរាញ​ឞ្រាស​អ៝ន់​តឹម​ទី​ងាន់ មៃ​មោ​អោស​ក្លាច​មា​ឞូនុយ្ស មោ​អោស​កើយ្ស​ឞូនុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","លាស​នទ្រី​ទាន់​មៃ​មឞើស​អ៝ន់​ហេន មើម​នាវ​មៃ​មឹន? ទី​ដ៝ង់​តឹង​នាវ​វៃ​ឞ៝ន់​អ៝ន់​ព្រាក់​អី​កោរាញ​កាដាច់​តា​ប៝ន​ក្វ៝ង់​រោម ​ដាៈ​ឞ៝ន់​អ៝ន់​មា​ពាង់​នៃ​មោ​លាស​មោ?” ");
INSERT INTO cmok_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ឞ្រាស​យេឆូ ​លែៈ​គឹត​នាវ​មឹន​អ្យើស​តា​ខាន់​ពាង់ នទ្រី​ពាង់​លាស៖ “អើ​ផូង​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម! ម៝ស​នាវ​ខាន់​មៃ​អុច​អោប​រាល៝ង​មា​គ៝ប់​កើត​នៃ​មេស? ");
INSERT INTO cmok_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ញហើ​នតីល​ព្រាក់​អី​ឞូ​អ៝ន់​មា​កោរាញ​កាដាច់​រី អ៝ន់​គ៝ប់​អ្វាញ់!” ជេសរី​ខាន់​ពាង់​ឆ៝ៈ​ព្រាក់​ទូ​មល៝ម់​ព្រាក់​កាក់​នតីល​អី​នៃ​នទឹ​អ៝ន់​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ឞ្រាស​យេឆូ ​អោប​ខាន់​ពាង់៖ “នទ្រី​តា​កាលើ​ព្រាក់​កាក់​អ្យា​ឞូ​ម៝ស​រូប? ឞូ​ម៝ស​រាញា?” ");
INSERT INTO cmok_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ខាន់​ពាង់​អើស៖ “រូប នទ្រែល​មា​រាញា​កោរាញ​កាដាច់​តា​ប៝ន​រោម !” ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “លាស​នទ្រី នទើ​កោរាញ​កាដាច់​តា​ប៝ន​រោម ​មព្លឹ​អ៝ន់​មា​ពាង់ នទើ​កោរាញ​ឞ្រាស​មព្លឹ​អ៝ន់​មា​កោរាញ​ឞ្រាស​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ត៝ត់​តាង់​នាវ​ឞ្រាស​យេឆូ ​អើស​កើត​នៃ ខាន់​ពាង់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់ ជេសរី​ទូ​លោស​ឞើស​ឞ្រាស​យេឆូ ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","នោក​នារ​នៃ​គែស​ផូង​ឆាដោឆី ​ហាន់​អា​ឞ្រាស​យេឆូ  ផូង​អី​នៃ​មោ​អ្យាត់​អោស​លាស​ឞូនុយ្ស​ខឹត​ទ៝ក់​រេស ខាន់​ពាង់​អោប​ឞ្រាស​យេឆូ ៖ ");
INSERT INTO cmok_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“ហើយ​នើម​នតី មោឆេ ​កាល់​អែ​នើស​លែៈ​ញចីស​ជេស​តា​ឆ៝ម់បុត​អ៝ន់​មា​ឞ៝ន់​ផូង​អីឆ្រាអែល ​លាស​កើត​នអា៖ «លាស​ឞូ​ក្លោ​ឆ៝ៈ​អូរ ជេសរី​ពាង់​ខឹត លាស​ពាង់​មោ​គែស​ក៝ន ដាៈ​អី​អ៝ស​នោ​ពាង់​រី​នត្រ៝ៈ​ឆ៝ៈ​អូរ​ពាង់ ជេសរី​កើប​ក៝ន​ខាន់​ពាង់​ជេង​ក៝ន​មា​ពាង់​អី​លែៈ​ខឹត​នៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","នតឹត​លាស​តា​ផូង​ហេន​គែស​អ៝ស​នោ​ពើស​នុយ្ស អី​នោ​ឞោក​ទាក​ឆ៝ៈ​អូរ ជេសរី​ខឹត​មោ​អោស​គែស​ក៝ន អី​អូរ​នៃ​អ៝ន់​អី​អ៝ស​ពាង់​ត្រ៝ៈ​ឆ៝ៈ។ ");
INSERT INTO cmok_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","អ៝ស​ត៝ល់​ង្វាយ អ៝ស​ត៝ល់​ឞារ នហ៝​មា​ត៝ត់​អី​អ៝ស​មពុត ខាន់​ពាង់​នអាប់​ដាស​ឞូ​អូរ​អី​នៃ​ទាទេ តីស​មា​ទឹង​លែៈ​ខាន់​ពាង់​នៃ​ខឹត​មោ​គែស​ក៝ន​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ងគ្លែៈ​ទុត​ងគ្លែៈ​ទេល​ឞូ​អូរ​អី​នៃ​ខឹត​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","លាស​នទ្រី​តា​នារ​ឞូនុយ្ស​ខឹត​ទ៝ក់​រេស​តៃ ឞូ​អូរ​អី​នៃ​ឞ្រែ​ម៝ស​អូរ? យ៝រ​លាស​ទឹង​លែៈ​ពើស​នុយ្ស​ខាន់​ពាង់​លែៈ​ឆ៝ៈ​ពាង់​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​លែៈ​វ៝ត់​តីស​ជេស យ៝រ​លាស​ខាន់​មៃ​មោ​គឹត​អោស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ នអ៝ប់​មា​នាវ​ទើយ​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","នោក​ឞូនុយ្ស​លែៈ​ខឹត ជេសរី​ទ៝ក់​រេស​តៃ ខាន់​ពាង់​មោ​ហោម​អោស​ឆ៝ៈ​អូរ​ឆ៝ៈ​ឆាយ​ជឹត។ ខាន់​ពាង់​ជេង​តឹម​ឞាន​មា​តោង​ពារ់​កោរាញ​ឞ្រាស​គុ​តា​ប៝ន​អ្វែស​កាលើ។ ");
INSERT INTO cmok_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","ល៝ង់​មា​នាវ​ឞូនុយ្ស​ខឹត​ទ៝ក់​រេស​តៃ លែៈ​កោរាញ​ឞ្រាស​មឞើស​មា​ខាន់​មៃ​តា​នាវ​ពាង់​ងើយ ពាង់​លាស​កើត​នអា៖ «គ៝ប់​ជេង​ឞ្រាស​អាឞ្រាហាម់ ​យើក​មឞាស ជេង​ឞ្រាស​អីឆាក់ ​យើក​មឞាស ជេង​ឞ្រាស​យាកោប ​យើក​មឞាស»។ អាស​ខាន់​មៃ​គែស​រ៝ៈ​អ្វាញ់​ដ៝ង់​បាស? នោក​កោរាញ​ឞ្រាស​ងើយ​នាវ​អី​នៃ​ពែ​នុយ្ស​ខាន់​ពាង់​អី​នៃ​លែៈ​ខឹត​អ៝ក់​នាម់​ជេស យើន​មា​ឞើស​នាវ​កោរាញ​ឞ្រាស​ងើយ​អី​នៃ​គឹត​នាល់​ខាន់​ពាង់​ហោម​រេស​មា​កោរាញ​ឞ្រាស។ កោរាញ​ឞ្រាស​មោ​អោស​ទី​ឞ្រាស​មា​ឞូនុយ្ស​ខឹត ពាង់​ឞ្រាស​មា​ឞូនុយ្ស​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ផូង​ប៝ន​លាន​តាង់​នាវ​ពាង់​នតុម​នតី​កើត​នៃ ខាន់​ពាង់​គែស​នាវ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ហោ​ងាន់​តា​ឆាក់​ខាន់​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","នោក​ផូង​ផារីឆី ​គឹត​ឞ្រាស​យេឆូ ​ទើយ​ដាស​ផូង​ឆាដោឆី  ខាន់​ពាង់​រាគូម​ឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ជេសរី​តា​ផូង​ខាន់​ពាង់​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​គែស​នាវ​មឹន​គឹត​ឞ្លាវ​មពែស​មា​នាវ​វៃ​ផូង​អីឆ្រាអែល  អោប​រាល៝ង​ឞ្រាស​យេឆូ ៖ ");
INSERT INTO cmok_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“អើ​នើម​នតី! តា​នាវ​វៃ​ឞ៝ន់​ម៝ស​នទើ​អី​ខ្លៃ​រាលាវ​ឞូ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ឞ្រាស​យេឆូ ​អើស៖ “«អ៝ន់​រ៝ង់​មា​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ខាន់​អៃ​មៃ​នើម មា​លែៈ​នូយ្ស​នហ៝ម់ មា​លែៈ​ហ្វេង នទ្រែល​មា​លែៈ​នាវ​មឹន»។ ");
INSERT INTO cmok_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","អី​នៃ​នាវ​វៃ​អី​ទុត​ក្វ៝ង់ នាវ​វៃ​ខ្លៃ​រាលាវ​ឞូ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","នាវ​វៃ​ឞើស​កើយ​នាវ​វៃ​អី​នៃ​គែស​នាវ​ខ្លៃ​តឹម​ឞាន​កើត​នៃ​ដ៝ង់៖ «អ៝ន់​រ៝ង់​មា​ឞូ​ច្យៅ​មែង​កើត​រ៝ង់​មា​ឆាក់​ខាន់​អៃ​មៃ​នើម​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","យ៝រ​លាស​ទឹង​លែៈ​នាវ​វៃ​ឞ៝ន់​អា​អេង នទ្រែល​មា​ទឹង​លែៈ​នាវ​អី​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ញចីស ជេង​លោស​តាៈ​ឞើស​ឞារ​នាវ​វៃ​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","នោក​ផូង​ផារីឆី ​ហោម​គុ​គូម​តា​រី ឞ្រាស​យេឆូ ​អោប​ខាន់​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“មើម​ខាន់​មៃ​គឹត​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់ ពាង់​ឞូ​ម៝ស​ក៝ន​ឆៅ?” ខាន់​ពាង់​អើស៖ “ពាង់​ក៝ន​ឆៅ​កាដាច់​ដាវីត ”។ ");
INSERT INTO cmok_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “លាស​ឞ្រាស​ក្រីស ​អី​ក៝ន​ឆៅ​កាដាច់​ដាវីត  មើម​ទឹង​កាដាច់​ដាវីត ​ងើយ​មា​ឞ្រាស​ហ្វេង​អ្វែស​ក្វាល់​ឞ្រាស​ក្រីស ៖ «កោរាញ»? ");
INSERT INTO cmok_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","យ៝រ​លាស​កាដាច់​ដាវីត ​លែៈ​ញចីស​កើត​នអា៖ «កោរាញ​ឞ្រាស​លាស​មា​កោរាញ​គ៝ប់៖ «គុ​មពែស​ឞើស​មា​គ៝ប់​ហ៝ម់​តា​នតុក​ឞូ​លឺ‌ ក៝ប់​ត៝ត់​គ៝ប់​អ៝ន់​ផូង​រាលាង់​ដាស​មៃ​មោ​ហោម​គែស​នាវ​ទើយ​អ៝ន់​គុ​តា​ន៝ម់​ជ៝ង់​មៃ​ប៝ត់»»។ ");
INSERT INTO cmok_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","លាស​លែៈ​កាដាច់​ដាវីត ​នើម​ក្វាល់​ឞ្រាស​ក្រីស ​កោរាញ​ពាង់​នើម​កើត​នៃ យើន​មា​ក៝ន​ឆៅ​មោ​គែស​ក្វ៝ង់​រាលាវ​មា​អូ​ចែ លាស​នទ្រី​ឞ្រាស​ក្រីស ​មើម​ហោម​ឞ្លាវ​ជេង​ក៝ន​ឆៅ​កាដាច់​ដាវីត ​ជឹត?” ");
INSERT INTO cmok_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","មោ​គែស​អោស​ឞូនុយ្ស​ទើយ​អើស​មា​ឞ្រាស​យេឆូ  ជេសរី​នតើម​ឞើស​នោក​នៃ​មោ​ហោម​អោស​គែស​ឞូនុយ្ស​អា​អេង​ឞាញ់​អោប​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ផូង​ឞូនុយ្ស​អ៝ក់ នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ នទ្រែល​មា​ផូង​ផារីឆី  ខាន់​ពាង់​តឹម​ឞាន​មា​គុ​តា​រានើល​មោឆេ  យ៝រ​មា​ខាន់​ពាង់​នតី​នាវ​វៃ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ទឹង​លែៈ​នទើ​ខាន់​ពាង់​នតុម​នតី​អ៝ន់​មា​ខាន់​អៃ​មៃ អ៝ន់​ខាន់​អៃ​មៃ​អ្យាត់ នទ្រែល​មា​ឆ៝ៈ​ទើន។ យើន​មា​លើយ​អោស​ជាន​តឹង​ខាន់​ពាង់​ជាន យ៝រ​លាស​ខាន់​ពាង់​មាន​មា​លាស​ទើម ឆាក់​ខាន់​ពាង់​នើម​មោ​អោស​ជាន​តឹង។ ");
INSERT INTO cmok_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ខាន់​ពាង់​ញជេង​នាវ​វៃ​ទុត​ជេរ​ទុត​ជ៝ក់​ងាន់​អ៝ន់​មា​ឞូនុយ្ស​ញអោត យើន​មា​ខាន់​ពាង់​នើម​មោ​អុច​អោស​ពាស ឞ៝ល​លាស​ពាស​ដេៈ​មោ​អុច​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ទឹង​លែៈ​នទើ​ខាន់​ពាង់​ជាន​នៃ គៃ​មា​អ៝ន់​ឞូ​ឆៃ ជេសរី​អ៝ន់​ឞូ​កើប​ខាន់​ពាង់​ជេង​ឞូនុយ្ស​អី​តឹង​នាវ​កោរាញ​ឞ្រាស​រាលាវ​ឞូ​ទើម។ នទ្រី​ទឹង​ខាន់​ពាង់​លើ​មា​ជាន​ក្វ៝ង់​ទុង​អី​ឞ៝ន់​វៃ​ក៝ត់​តា​ឞោក នទ្រែល​មា​ក៝ត់​តា​តី​នោក​មឞើស​ឆើម នទ្រែល​មា​ជាន​ច្យាង់​អាវ​លើ​មា​ជ៝ង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ខាន់​ពាង់​រ៝ង់​គែស​គុ​តា​នតុក​ឞូ​យើក​នោក​ញេត​ឆោង​ក្វ៝ង់ ជេសរី​តា​ត្រោម​ញីស​រាបុន​អុច​គុ​ឞើស​នាប់​ឞូ​តា​នតុក​ឞូ​លឺ។ ");
INSERT INTO cmok_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ខាន់​ពាង់​អុច​អ៝ន់​ឞូ​មឞាស​កុញ​ឞោក​មា​ខាន់​ពាង់​រ៝ៈ​នតុក​ឞូ​តាច់​រាគ៝ល់​ទ្រាប់​នទើ មោ​លាស​រ៝ៈ​ត្រ៝ង​ក្វ៝ង់ នទ្រែល​មា​អុច​អ៝ន់​ឞូ​ក្វាល់​ខាន់​ពាង់៖ «នើម​នតី»។ ");
INSERT INTO cmok_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ល៝ង់​មា​ខាន់​អៃ​មៃ​នៃ លើយ​អោស​អ៝ន់​ឞូ​ក្វាល់​ខាន់​អៃ​មៃ «នើម​នតី» យ៝រ​លាស​គែស​ទូ​ហ្វេ «នើម​នតី»​ទើម ជេសរី​ទឹង​លែៈ​រាងោច​ខាន់​អៃ​មៃ​ជេង​អ៝ស​នោ​នទ្រែល​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","លើយ​អោស​ក្វាល់​ទូ​ហ្វេ​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា «ឞឹ» យ៝រ​លាស​ខាន់​អៃ​មៃ​លែៈ​គែស​ទូ​ហ្វេ​ឞឹ​អី​គុ​តា​កាលើ​ត្រោក។ ");
INSERT INTO cmok_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","លើយ​អោស​ក្វាល់​ឆាក់​ខាន់​អៃ​មៃ​នើម «នើម​នតី» យ៝រ​លាស​ខាន់​អៃ​មៃ​គែស​ទូ​ហ្វេ​នើម​នតី៖ ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់។ ");
INSERT INTO cmok_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","យើន​មា​ឞូ​ម៝ស​ពាង់​អី​ក្វ៝ង់​រាលាវ​ឞូ​តា​ផូង​ខាន់​អៃ​មៃ អ៝ន់​ពាង់​ជេង​ឞូនុយ្ស​អី​ឆើម​កើល​ជាន​ការ​អ៝ន់​មា​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ឞូ​ម៝ស​អី​នហាវ​អេង​ឆាក់​ពាង់​នើម កោរាញ​ឞ្រាស​ញជុរ​លើយ យើន​មា​ឞូ​ម៝ស​អី​ញជុរ​អេង​ឆាក់​អុច​អ្យាត់​ពាង់ កោរាញ​ឞ្រាស​ឆើម​នហាវ​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“អើ​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ នទ្រែល​មា​ខាន់​មៃ​អី​ផូង​ផារីឆី ! ខាន់​មៃ​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម។ កោរាញ​ឞ្រាស​មរា​អ៝ន់​នាវ​រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ យ៝រ​លាស​ខាន់​មៃ​ងកីង​លើយ​ត្រ៝ង​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់។ ខាន់​មៃ​នើម​មោ​អុច​លាប់ ជេសរី​ឞូនុយ្ស​អី​អុច​លាប់​ខាន់​មៃ​ងកីង​លើយ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“អើ​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ នទ្រែល​មា​ខាន់​មៃ​អី​ផូង​ផារីឆី ! ខាន់​មៃ​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម។ កោរាញ​ឞ្រាស​មរា​អ៝ន់​នាវ​រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ យ៝រ​លាស​ខាន់​មៃ​មរោស​ឞូ​អូរ​នទ្រោ​លែៈ​ខឹត​ឆាយ​គៃ​មា​ឆ៝ៈ​ពីត​ទ្រាប់​នទើ​ញីស​ជៃ​ខាន់​ពាង់។ ខាន់​មៃ​ជាន​មឞើស​ឆើម​ទុត​ជ៝ៈ​ងាន់​អ៝ន់​ឞូ​អេង​តាង់ គៃ​មា​ញហើ​ខាន់​មៃ​នើម​ជេង​ឞូនុយ្ស​រ៝ង់​មា​កោរាញ​ឞ្រាស​ងាន់។ នទ្រី​ទឹង​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​ជ្រូ​រាលាវ​ឞូ​អេង​តា​នារ​ជឹត​នាប់​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“អើ​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ នទ្រែល​មា​ខាន់​មៃ​អី​ផូង​ផារីឆី ! ខាន់​មៃ​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម។ កោរាញ​ឞ្រាស​មរា​អ៝ន់​នាវ​រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ យ៝រ​លាស​ខាន់​មៃ​ហាន់​ញឆ៝ង​ទុត​ងាយ​រ៝ៈ​កាលើ​នែស រ៝ៈ​ទាក​វាច់​ទាក​វារ់ គៃ​មា​ជាៈ​ទូ​ហ្វេ​ឞូនុយ្ស​លាប់​តឹង​នាវ​វៃ​ផូង​ឞ៝ន់។ ត៝ត់​មា​លែៈ​គែស​ឞូ​លាប់​ជេស ខាន់​មៃ​ជាន​អ៝ន់​ឞូនុយ្ស​អី​នៃ​លើ​មា​ហោ​អ្យើស​ទុត​ហោ​ងាន់ ទី​មា​តុប​តា​នទ្រូង​អុញ អ្យើស​រាលាវ​ឞារ​តឹ​ខាន់​មៃ​នើម​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“កោរាញ​ឞ្រាស​មរា​អ៝ន់​នាវ​រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ។ ខាន់​មៃ​ឞូនុយ្ស​លែវ​ឞូ យើន​មា​ខាន់​មៃ​នើម​តឹម​ឞាន​មា​ឞូនុយ្ស​ចែស​មាត់ យ៝រ​លាស​ខាន់​មៃ​ងើយ​កើត​នអា៖ «ឞូ​ម៝ស​ត៝ន​ដាស​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស នាវ​ត៝ន​អី​នៃ​មោ​អោស​គែស​នាវ​ខ្លៃ យើន​មា​ឞូ​ម៝ស​ត៝ន​ដាស​មាយ្ស​តា​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស រី​មើ​នាវ​ត៝ន​អី​នៃ​គែស​នាវ​ខ្លៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","អើ​មពោល​ឞូនុយ្ស​មឞ្លុ ខាន់​មៃ​តឹម​ឞាន​មា​មពោល​ឞូនុយ្ស​ចែស​មាត់! ម៝ស​នទើ​អី​គែស​នាវ​ខ្លៃ​រាលាវ? មាយ្ស​អី​គែស​តា​ញីស​ជាន​ឞ្រាស មោ​លាស​ញីស​ជាន​ឞ្រាស​អី​អ៝ន់​មាយ្ស​អី​នៃ​ជេង​ក្ល៝ស​អ្វែស​ជេង​នទើ​កោរាញ​ឞ្រាស​នើម? ");
INSERT INTO cmok_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ខាន់​មៃ​លាស​ដ៝ង់៖ «ឞូ​ម៝ស​ត៝ន​ដាស​ញឆឺង​គុច​ពូរ​នទើ​ជាន​ឞ្រាស នាវ​ត៝ន​អី​នៃ​មោ​អោស​គែស​នាវ​ខ្លៃ យើន​មា​ឞូ​ម៝ស​ត៝ន​ដាស​នទើ​ជាន​ឞ្រាស​តា​កាលើ​នតុក​ជាន​ឞ្រាស រី​មើ​នាវ​ត៝ន​អី​នៃ​ទឹង​គែស​នាវ​ខ្លៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","អើ​មពោល​ឞូនុយ្ស​ចែស​មាត់ ម៝ស​នទើ​អី​គែស​នាវ​ខ្លៃ​រាលាវ? នទើ​ជាន​ឞ្រាស មោ​លាស​ញឆឺង​គុច​ពូរ​នទើ​ជាន​ឞ្រាស​អី​អ៝ន់​នទើ​ជាន​ឞ្រាស​ជេង​ក្ល៝ស​អ្វែស​ជេង​នទើ​កោរាញ​ឞ្រាស​នើម? ");
INSERT INTO cmok_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","លាស​នទ្រី​ឞូ​ម៝ស​ត៝ន​មា​ញឆឺង​គុច​ពូរ​នទើ​ជាន​ឞ្រាស ពាង់​ត៝ន​មា​ញឆឺង​គុច​ពូរ​នទើ​ជាន​ឞ្រាស នទ្រែល​មា​ទឹង​លែៈ​នទើ​ជាន​ឞ្រាស​អី​គែស​តា​កាលើ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ជេសរី​ឞូ​ម៝ស​ត៝ន​ដាស​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស ពាង់​ត៝ន​មា​ញីស​អី​នៃ នទ្រែល​មា​ត៝ន​ដាស​មា​កោរាញ​ឞ្រាស​អី​គុ​តា​ញីស​ជាន​ឞ្រាស​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ឞូ​ម៝ស​ត៝ន​ដាស​នតុក​កោរាញ​ឞ្រាស​តា​កាលើ​ត្រោក ពាង់​អី​នៃ​ត៝ន​នអ៝ប់​មា​រានើល​កោរាញ​ឞ្រាស​នើម នអ៝ប់​មា​កោរាញ​ឞ្រាស​អី​គុ​តា​រានើល​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“អើ​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ នទ្រែល​មា​ខាន់​មៃ​អី​ផូង​ផារីឆី ! ខាន់​មៃ​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម។ កោរាញ​ឞ្រាស​មរា​អ៝ន់​នាវ​រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ យ៝រ​លាស​ខាន់​មៃ​នើស​ឆ៝ៈ​នទើ​គែស​ជឹត​អឹ​រាហ្វាត់​ង្វាយ​ញហើរ​មា​កោរាញ​ឞ្រាស កើត​លាស​នទើ​មោ​ខ្លៃ ក្លោយ្ស គីរ នទ្រែល​មា​នទើ​បោ​អាបាៈ​អេង​ដ៝ង់។ នាវ​អី​ញហើរ​ជេង​ទី តីស​មា​ខាន់​មៃ​មអារ់​លើយ​នទើ​អី​គែស​នាវ​ខ្លៃ​រាលាវ​មា​នទើ​អី​នៃ​តា​នាវ​វៃ​ឞ៝ន់ នទើ​អី​គែស​នាវ​ខ្លៃ​រាលាវ​នៃ៖ នាវ​ឆ៝ង់ នាវ​យោៈ​នអាច នទ្រែល​មា​នាវ​ញឆីង​មា​កោរាញ​ឞ្រាស។ លាស​នទ្រី​អ៝ន់​ខាន់​មៃ​ញឆ្រោយ្ស​ជាន​នាវ​ឆ៝ង់ នាវ​យោៈ​នអាច នទ្រែល​មា​នាវ​ញឆីង ជេសរី​ញហើរ​កើត​អី​នៃ​មា​កោរាញ​ឞ្រាស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“ខាន់​មៃ​ឞូនុយ្ស​លែវ​ឞូ យើន​មា​ខាន់​មៃ​នើម​តឹម​ឞាន​មា​ឞូនុយ្ស​ចែស​មាត់។ ខាន់​មៃ​ងខែៈ​លើយ​រាហ្វៃ​ឞើស​ទាក​តា​កាច៝ក​ខាន់​មៃ គៃ​មា​លើយ​រាង្វាន់ តីស​មា​ខាន់​មៃ​តឹម​ឞាន​មា​រាង្វាន់​ទូ​មល៝ម់​ឆែស​ឆាមោ!” ");
INSERT INTO cmok_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“អើ​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ នទ្រែល​មា​ខាន់​មៃ​អី​ផូង​ផារីឆី ! ខាន់​មៃ​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម។ កោរាញ​ឞ្រាស​មរា​អ៝ន់​នាវ​រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ យ៝រ​លាស​ខាន់​មៃ​ជេង​តឹម​ឞាន​មា​ឞូនុយ្ស​អី​រាវ​ងាន រាវ​យាង់​តា​ឞើស​ទីស​ទើម យើន​មា​តា​ត្រោម​ហោម​អែ​អូក​រាមាវ។ ខាន់​មៃ​រាវ​តី​តឹង​មា​នាវ​វៃ​ខាន់​មៃ តីស​មា​តា​នូយ្ស​នហ៝ម់​ខាន់​មៃ​រី​ហោម​ទុត​អុច​មា​នាវ​រាវាន​កើញ​គែស​មា​ទ្រាប់​នទើ នទ្រែល​មា​នាវ​ឆា​ញឆ្យាន់​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","អើ​ផូង​ផារីឆី ​ចែស​មាត់ អ៝ន់​រាវ​កែវ​រាវ​ងាន​តា​ត្រោម​ល៝រ​ប៝ត់ ជេសរី​រាវ​ឞើស​ទីស​ដ៝ង់ រី​មើ​ទឹង​លែៈ​ក្ល៝ស​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“អើ​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ នទ្រែល​មា​ខាន់​មៃ​អី​ផូង​ផារីឆី ! ខាន់​មៃ​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម។ កោរាញ​ឞ្រាស​មរា​អ៝ន់​នាវ​រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ យ៝រ​លាស​ខាន់​មៃ​តឹម​ឞាន​មា​មោច​ឞូ​ហឹង​មា​ទាក​ឆី​ងលាង អ្វាញ់​ឞើស​ទីស​តឹម​ឞាន​មា​អ្វែស​ងាន់ តីស​មា​តា​ត្រោម​រី​នតីង​ឞូនុយ្ស​ខឹត នទ្រែល​មា​នទើ​បឹ​អាប់​នតីល​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ខាន់​មៃ​តឹម​ឞាន​មា​កើត​នៃ​ងាន់ ឞូ​អ្វាញ់​ឞើស​ទីស​ជាន​តឹម​ឞាន​មា​ឞូនុយ្ស​ឆ៝ង់ តីស​មា​តា​ត្រោម​រី​នូយ្ស​នហ៝ម់​នទ៝ប់​មពោន នទ្រែល​មា​មោ​ជាន​តឹង​នាវ​កោរាញ​ឞ្រាស​អុច”។ ");
INSERT INTO cmok_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“អើ​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ នទ្រែល​មា​ខាន់​មៃ​អី​ផូង​ផារីឆី ! ខាន់​មៃ​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម។ កោរាញ​ឞ្រាស​មរា​អ៝ន់​នាវ​រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ យ៝រ​លាស​ខាន់​មៃ​ជាន​អ្វែស​ជៃ​មោច​មា​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស នទ្រែល​មា​ងក្រឹ​អ្វែស​មោច​មា​ផូង​ឞូនុយ្ស​ឆ៝ង់‌ ");
INSERT INTO cmok_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ជេសរី​ខាន់​មៃ​លាស៖ «លាស​ហេន​គុ​រេស​រានោក​ផូង​អូ​ចែ​អី​នៃ​នើស ហេន​មោ​អោស​តឹម​ទី​នាវ​ដាស​ខាន់​ពាង់​ងខឹត​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស»។ ");
INSERT INTO cmok_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","នទ្រី​នាវ​ខាន់​មៃ​ងើយ​កើត​នៃ យើន​មា​ខាន់​មៃ​ហោម​ក្វាល់​ឞូនុយ្ស​អី​នៃ​អូ​ចែ​ខាន់​មៃ កើត​នទ្រី​ខាន់​មៃ​លែៈ​ញហើ​នូយ្ស​នហ៝ម់​ខាន់​មៃ​តឹម​ទី​មា​ផូង​ងខឹត​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","លាស​នទ្រី​អ៝ន់​ខាន់​មៃ​ហោម​ជាន​កើត​ផូង​អូ​ចែ​ខាន់​មៃ​នៃ​ត៝ត់​លោច​ហ៝ម់!” ");
INSERT INTO cmok_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“យេ! មពោល​ឞូនុយ្ស​អ្យើស​ឞូនុយ្ស​ជាញ​តឹម​ឞាន​មា​ឞេស​កូ! មើម​ជាន​ខាន់​មៃ​ហោម​ទើយ​ក្លាយ្ស​ឞើស​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​នតុប​តា​នទ្រូង​អុញ? ");
INSERT INTO cmok_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","កើត​នទ្រី​ទឹង​គ៝ប់​ញជុន​តៃ​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស មពោល​ឞូនុយ្ស​គឹត​ឞ្លាវ នទ្រែល​មា​ផូង​នើម​នតី​អ៝ន់​មា​ខាន់​មៃ តីស​មា​អាបាៈ​ខាន់​មៃ​ងខឹត​លើយ​ខាន់​ពាង់​តា​ឆី​តឹម​រាកាង់ អាបាៈ​ជឹត​ខាន់​មៃ​រាពាត់​ខាន់​ពាង់​មា​ម៝ង់​រាឆែ​តា​ញីស​រាបុន​ខាន់​មៃ នទ្រែល​មា​ខាន់​មៃ​តឹង​ជ៝យ​ខាន់​ពាង់​រ៝ៈ​ប៝ន​អ្យា​ប៝ន​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","លាស​នទ្រី​ទឹង​លែៈ​មហាម​មពោល​ឞូនុយ្ស​ឆ៝ង់​អី​នៃ​ក្រេប​តា​ខាន់​មៃ​ទាទេ ជេង​នតើម​ឞើស​ក៝ន​អាដាម់ ​រាញា​ពាង់​កាអីន ​ងខឹត​អី​អ៝ស​ពាង់​រាញា​អាបែល  នហ៝​មា​ត៝ត់​ឞូ​ងខឹត​ឆាការី ​អី​ក៝ន​បារាកី ​អី​អូ​ចែ​ខាន់​មៃ​ងខឹត​ពាង់​តា​វាស​វាង​ញីស​ជាន​ឞ្រាស តា​ញឆឺង​គុច​ពូរ​នទើ​ជាន​ឞ្រាស​រី។ ឞ៝ល​លាស​ទឹង​លែៈ​ឞូនុយ្ស​អី​នៃ​លែៈ​ឞូ​ងខឹត​ឞើស​កាល់​អែ​នើស ទោយ្ស​អី​នៃ​ហោម​អែ​តេៈ​មា​ខាន់​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ ទឹង​លែៈ​ទោយ្ស​ទាក​អី​នៃ​ញឆុន​មា​ឞូនុយ្ស​តា​រានោក​អ្យា​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ហើយ​ឞូនុយ្ស​តា​ប៝ន​យេរូឆាលឹម  ឞូនុយ្ស​តា​យេរូឆាលឹម  ខាន់​អៃ​មៃ​លែៈ​ងខឹត​ជេស​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស ឆ៝ៈ​លុ​នតុប​ងខឹត​លើយ​អី​ឞូនុយ្ស​កោរាញ​ឞ្រាស​ដាៈ​ហាន់​នតី​ខាន់​អៃ​មៃ។ យើន​មា​លែៈ​បាបើ​ងាន់​គ៝ប់​អុច​រាគូម​ខាន់​អៃ​មៃ តឹម​ឞាន​មា​មែ​អ្យារ់​រាតុក​ក៝ន​អ៝ន់​គុ​គូម​តា​ន៝ម់​នារ​ពាង់។ តីស​មា​ខាន់​អៃ​មៃ​មោ​អោស​អុច។ ");
INSERT INTO cmok_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ល៝ង់​អ្វាញ់ ប៝ន​ខាន់​អៃ​មៃ​តៃ​កោរាញ​ឞ្រាស​នត្លើយ​ងាន់ ជេង​រាង៝ល។ ");
INSERT INTO cmok_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ គ៝ប់​ហាន់​អា​ខាន់​អៃ​មៃ​ហោម​ទូ​តឹ​ទើម ជេសរី​តៃ​ខាន់​អៃ​មៃ​មោ​ហោម​អោស​ឆៃ​គ៝ប់​ជឹត នហ៝​មា​ត៝ត់​ខាន់​អៃ​មៃ​លាស៖ «ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​ទូ​ហ្វេ​ឞូនុយ្ស​អ្យា​អី​កោរាញ​ឞ្រាស​ទែ​ដាៈ​វាច់»”។ ");
INSERT INTO cmok_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","នោក​ឞ្រាស​យេឆូ ​លោស​ឞើស​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​ហាន់​អា​រី មពោល​អ៝ស​ម៝ន​ញច៝ង់​ទឹង​លែៈ​នទើ​គែស​តា​ញីស​ជាន​ឞ្រាស​នៃ​អ៝ន់​ពាង់​ឆៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ៖ នារ​ជឹត​នាប់​តៃ លែៈ​នទើ​អី​ខាន់​អៃ​មៃ​ឆៃ​នៃ​ឞូ​មរា​លើស​រាល៝ម់​លែៈ​ផ្យៅ​រ៝ មោ​ហោម​អោស​គែស​ទូ​មល៝ម់​លុ​ឞ្ល៝ន​តឹម​រាទាប់​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","នោក​ឞ្រាស​យេឆូ ​គុ​តា​យោក​តើម​អោលីវ  មពោល​អ៝ស​ម៝ន​ហាន់​អេង​អា​ពាង់ អោប​ពាង់៖ “ហើយ​នើម​នតី ល៝ង់​មៃ​មឞើស​អ៝ន់​មា​ហេន​គឹត​ដ៝ង់ ទាស​ហោម​ជ៝ៈ​នារ​ត៝ត់​នាវ​អី​នៃ​មេស? លាស​នទ្រី​ម៝ស​នទើ​មឞេន​អ៝ន់​មា​ហេន​គឹត​លាស​នារ​មៃ​ព្លឹ​វាច់ នទ្រែល​មា​តា​នារ​ងគ្លែៈ​ទុត​នែស​នតូ​តៃ?” ");
INSERT INTO cmok_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​ងាន់​ហ៝ៈ។ លើយ​ទឹង​អោស​អ៝ន់​ឞូ​មរោស​នទើម​ខាន់​អៃ​មៃ​ញហើត​លាៈ​លេង។ ");
INSERT INTO cmok_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","យ៝រ​មា​នារ​ជឹត​នាប់​តៃ​គែស​អ៝ក់​ឞូ​នតូប​រាញា​គ៝ប់៖ «គ៝ប់​អ្យា​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​ហែស!» ខាន់​ពាង់​លែវ​ញហើត​ឞូនុយ្ស​អ៝ក់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ខាន់​អៃ​មៃ​មរា​តាង់​នាវ​មហែ​មា​នាវ​តឹម​លើស​តឹម​ឆ្រែស នទ្រែល​មា​តាង់​ឞូ​ងក៝ច​ញច្រ៝ស​មា​នាវ​តឹម​លើស​តឹម​ឆ្រែស។ លើយ​អោស​ក្លាច យ៝រ​លាស​លែៈ​នាវ​អី​នៃ​ពាង់​គែស​ងាន់​រ៝ យើន​មា​នារ​ងគ្លែៈ​ទុត​នែស​នតូ​អេ​ហ៝ៈ​អោស​ត៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ទូ​មពោល​តឹម​លើស​ដាស​ទូ​មពោល​អេង​ជឹត ទូ​ឞ្រី​ទាក​តឹម​លើស​ដាស​ទូ​ឞ្រី​ទាក​ជឹត។ គែស​នាវ​ជី​ឆ៝ត់​ជី​ង៝ត​ក្វ៝ង់ នទ្រែល​មា​គែស​នាវ​ងគារ់​នែស​តា​នតុក​អេងៗ។ ");
INSERT INTO cmok_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","យើន​មា​នាវ​ជេរ​អី​នៃ​ជេង​នតើម​នាវ​ជេរ​ទើម តឹម​ឞាន​មា​នាវ​ឞូ​អូរ​នតើម​ត៝ត់​ជី​នទុល​គុ​អ៝ស។ ");
INSERT INTO cmok_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","នោក​នៃ​ឞូ​ញជុន​ខាន់​អៃ​មៃ​អ៝ន់​ឞូ​ងក្រីត​ជាន​ជេរ នទ្រែល​មា​ឞូ​ងខឹត​លើយ​ខាន់​អៃ​មៃ។ ទឹង​លែៈ​ឞូនុយ្ស​តា​ឞ្រី​ទាក​តា​នែស​នតូ​អ្យា​ឞូ​រាងឹ​ឞ្យាញ់​ងាន់​មា​ខាន់​អៃ​មៃ​អាច​មា​តឹង​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","តា​នោក​នៃ​គែស​អ៝ក់​ឞូនុយ្ស​មអារ់​នាវ​ញឆីង​មា​គ៝ប់ ជេសរី​តឹម​មរោស​នទ្រាង់​នើម​គៃ​មា​ញជុន​អ៝ន់​ឞូ​ជាន​ជេរ នទ្រែល​មា​តឹម​រាងឹ​ឞ្យាញ់​នទ្រាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","មរា​គែស​អ៝ក់​ឞូនុយ្ស​នតើយ្ស​ងក្លាៈ​នាវ​ងើយ​កោរាញ​ឞ្រាស​លែវ​អ៝ក់​ឞូនុយ្ស​ហ្យើត។ ");
INSERT INTO cmok_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ជេសរី​យ៝រ​មា​នាវ​ជាន​តីស​មា​នាវ​កោរាញ​ឞ្រាស​អុច​លើ​មា​អ៝ក់ នាវ​រ៝ង់​ឞូនុយ្ស​អ៝ក់​លើ​មា​រ៝ស។ ");
INSERT INTO cmok_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","យើន​មា​ឞូ​ម៝ស​អី​ទើយ​ញឆ្រោយ្ស​នហ៝​មា​ត៝ត់​លោច កោរាញ​ឞ្រាស​មរា​រាក្លាយ្ស​ពាង់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","នាវ​មហែ​មហាន​អ្វែស​មា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​អ្យា​ឞូ​មឞើស​ងក៝ច​លាម​នែស​នតូ គៃ​មា​ទឹង​លែៈ​ឞូនុយ្ស​ទឹង​លែៈ​ឞ្រី​ទាក​តាង់​នាវ​ខ្លៃ​អី​នៃ រី​មើ​នារ​ងគ្លែៈ​ទុត​នែស​នតូ​ត៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ត៝ត់​ខាន់​អៃ​មៃ​ឆៃ​នទើ​ទុត​បឹ​បើច​ឞូ​តេៈ​តា​នតុក​ក្ល៝ស​អ្វែស​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​រាញា​ដានីអែល ​ទែ​លែៈ​មឞើស​ងក៝ច​កាល់​អែ​នើស - ឞូ​ម៝ស​អី​រ៝ៈ​នាវ​អី​នៃ​អ៝ន់​ពាង់​គឹត​វ៝ត់​នាវ​អី​នៃ - ");
INSERT INTO cmok_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ជេស​ឆៃ​នទើ​អី​នៃ​ឞូនុយ្ស​អី​គុ​តា​ឞ្រី​យូដា ​រី​អ៝ន់​ទូ​ញច្វាត់​នទែ​តា​យោក។ ");
INSERT INTO cmok_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ឞូ​ម៝ស​អី​គុ​កាលើ​ច៝រ​ជៃ​ល៝ង់ លើយ​ហោម​អោស​ជុរ​លាប់​តា​ត្រោម​ឆ៝ៈ​ទ្រាប់​នទើ។ ");
INSERT INTO cmok_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ឞូ​ម៝ស​អី​គុ​តា​មីរ លើយ​ហោម​ដ៝ង់​ព្លឹ​តា​ជៃ​ឆ៝ៈ​អាវ​ក្វ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","នោក​នៃ​ឞូ​អូរ​នត្រែវ ឞូ​អូរ​មពូ​ត៝ស​ក៝ន​គែស​នាវ​រេស​រាញាល់​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","អ៝ន់​ខាន់​អៃ​មៃ​មឞើស​ឆើម​ទាន់​មា​កោរាញ​ឞ្រាស​ហ៝ម់ គៃ​មា​លើយ​អោស​គែស​នាវ​ញច្វាត់​ទូ​អី​នៃ​តា​នោក​ខៃ​ជី​កាត់ មោ​លាស​តា​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ឞ៝ន់‌ ");
INSERT INTO cmok_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","យ៝រ​លាស​តា​នោក​នៃ​គែស​នាវ​ជេរ​ជ៝ត់​ហោ​ងាន់។ នតើម​ឞើស​រានោក​នតើម​គែស​នែស​នតូ​អ្យា​ត៝ត់​អាបៃ​អ្យា នហ៝​មា​នារ​ងគ្លែៈ​ទុត​នែស​នតូ​តៃ មោ​ព្រ៝ត​គែស​នាវ​ទុត​ជេរ​កើត​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","លាស​កោរាញ​ឞ្រាស​មោ​នហុច​លើយ​ទឹង​លែៈ​នារ​នៃ នទ្រី​មោ​ហោម​អោស​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​រេស ខឹត​លែៈ​ផ្យៅ។ យើន​មា​កោរាញ​ឞ្រាស​នហុច​លើយ​នារ​អី​នៃ យ៝រ​មា​នាវ​យោៈ​មពោល​អី​លែៈ​ពាង់​កើយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","តា​នោក​នៃ​លាស​គែស​ឞូ​មឞើស​មា​ខាន់​អៃ​មៃ៖ «ល៝ង់​ខាន់​អៃ​មៃ​អ្វាញ់​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​គុ​តា​អ្យា!» មោ​លាស «គុ​តា​ត៝!» លើយ​អោស​អ្យាត់​ឞូ‌ ");
INSERT INTO cmok_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","យ៝រ​មា​គែស​ឞូនុយ្ស​នតូប​លាស​ឆាក់​ពាង់​ឞ្រាស​ក្រីស  នទ្រែល​មា​គែស​ឞូនុយ្ស​នតូប​លាស​ឆាក់​ពាង់​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស។ ខាន់​ពាង់​អី​នៃ​ជាន​នាវ​មឞេន​អី​ខ្លៃ​ក្វ៝ង់​អេងៗ​ដ៝ង់ គៃ​មា​លែវ​ឞូនុយ្ស​អ៝ន់​ញហើត​លាៈ​លេង ងខេប​លាស​ទើយ​លែវ​ញហើត​ផូង​អី​កោរាញ​ឞ្រាស​លែៈ​កើយ្ស​ដ៝ង់ យើន​មា​មោ​អោស​ទើយ។ ");
INSERT INTO cmok_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","អ៝ន់​ញជ្រាង់​ហ៝ៈ! នទ្រី​ទឹង​គ៝ប់​មឞើស​ងក៝ច​អ៝ន់​ខាន់​អៃ​មៃ​គឹត​ល៝រ។ ");
INSERT INTO cmok_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","លាស​គែស​ឞូ​លាស​មា​ខាន់​អៃ​មៃ៖ «ឞ្រាស​ក្រីស ​គុ​តា​ឞ្រី​រាទាស!» ខាន់​អៃ​មៃ​លើយ​អោស​ហាន់​អ្វាញ់។ មោ​លាស លាស​ឞូ​លាស​មា​ខាន់​អៃ​មៃ៖ «ឞ្រាស​ក្រីស ​គុ​ក្រាប​តា​ត្រោម​ជ្រោ!» ខាន់​អៃ​មៃ​លើយ​ដ៝ង់​អ្យាត់​នាវ​ឞូ។ ");
INSERT INTO cmok_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","យ៝រ​លាស​នារ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់ តឹម​ឞាន​មា​លើប​ងលាយ្ស​អាង​ឞើស​ជ៝ង់​ត្រោក​ទូ​ទីង​ត៝ត់​មា​ជ៝ង់​ត្រោក​ទូ​ទីង។ កើត​នៃ​ដ៝ង់​លាម​នែស​នតូ​មរា​គឹត​ឆៃ​នារ​គ៝ប់​ព្លឹ​វាច់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","អាស​នតុក​គែស​នទើ​ខឹត គ្រ៝ត់​មរា​រាគូម​ឞាល់​មពារ់​នទាច់​តា​នតុក​អី​នៃ​ដ៝ង់ កើត​នទ្រី​នទើ​អី​នៃ​អ៝ន់​មពើល​មា​ឞូនុយ្ស​ឆៃ​ឞើស​ងាយ”។ ");
INSERT INTO cmok_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“លោច​ជេស​នារ​ជេរ​ជ៝ត់​អី​នៃ​រ៝ «តា​នោក​នៃ​នារ​ជេង​ង៝‌ ខៃ​មោ​ហោម​អោស​អាង‌ មាញ់​មឞីង​ដុស​ឞើស​ត្រោក‌ លែៈ​នទើ​អី​តេស​ក្វ៝ង់​កាលើ​ត្រោក​ងគើ​ទាទេ»។ ");
INSERT INTO cmok_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","នោក​នៃ​តា​ត្រោក​មពើល​នទើ​គឹត​មឞេន​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់។ ជេសរី​ទឹង​លែៈ​មពោល​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា​ញុម​នអ៝រ។ ខាន់​ពាង់​មរា​ឆៃ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​ហាន់​រ៝ៈ​នទ៝រ់​តុក​តា​កាលើ​ត្រោក នអ៝ប់​មា​នាវ​ទើយ នទ្រែល​មា​នាវ​ច្រេក​លើប​ទុត​ហោ។ ");
INSERT INTO cmok_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ជេសរី​គ៝ប់​ញជ្វាល់​ផូង​តោង​ពារ់​គ៝ប់​ហាន់​អាប់​ព្វាន់​ញជោញ​ឞ្រី​លាម​នែស​នតូ នទ្រែល​មា​អោស​នុង​ទុត​នតែស គៃ​មា​រាគូម​លែៈ​មពោល​អី​កោរាញ​ឞ្រាស​នើម​លែៈ​កើយ្ស​នើស​ឞើស​ជ៝ង់​ត្រោក​ទូ​ទីង​ត៝ត់​មា​ជ៝ង់​ត្រោក​ទូ​ទីង”។ ");
INSERT INTO cmok_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“អ៝ន់​ខាន់​អៃ​មៃ​គឹត​ងក្ល៝ន់​ទោ​នាវ​នតឹត​មា​តើម​រាវី ​អ្យា៖ លាស​ងគីង​ពាង់​គែស​ចាត់​នហា​ញឆែ​នអឹរ ខាន់​អៃ​មៃ​គឹត​លាស​ខៃ​តា​មីស​ឞើយ​ត៝ត់​ហើយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","នទ្រី​លាស​ខាន់​អៃ​មៃ​ឆៃ​ទឹង​លែៈ​នាវ​អី​នៃ​លែៈ​ត៝ត់ គឹត​រ៝​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ឞើយ​ត៝ត់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ លែៈ​នាវ​អ្យា​ពាង់​ត៝ត់​ទោល​ឞូនុយ្ស​តា​រានោក​អាបៃ​អ្យា​ហោម​រេស។ ");
INSERT INTO cmok_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ត្រោក​នែស​នតូ​មរា​រ៝ស​លេក​រ៝ យើន​មា​នាវ​គ៝ប់​ងើយ​មោ​អោស​ឞ្លាវ​រ៝ស​លេក ហោម​គែស​ទឹង​លែៈ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ម៝ង​នារ​អី​នៃ​មោ​អោស​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ទើយ​គឹត ឞ៝ល​លាស​តោង​ពារ់​តា​កាលើ​ត្រោក​អី​នតុក​កោរាញ​ឞ្រាស មោ​លាស​គ៝ប់​អី​ក៝ន​កោរាញ​ឞ្រាស​មោ​ទើយ​គឹត​ដ៝ង់ គែស​ទូ​ហ្វេ​ឞឹ​គ៝ប់​ទើម​ទើយ​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","តា​នោក​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់​នៃ ជេង​តឹម​ឞាន​មា​រានោក​នោអេ ​កាល់​អែ​នើស​ដ៝ង់‌ ");
INSERT INTO cmok_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","អេ​ល៝រ​មា​គែស​ទាក​លេង​ទាក​ទើង​ក្វ៝ង់។ រានោក​នៃ​ឞូនុយ្ស​គុ​ញេត​ឆោង​ឆា នអាប់​អូរ​ឆាយ លើស​មីរ​ជាន​ឞា នហ៝​មា​ត៝ត់​នារ​នោអេ ​លាប់​តា​ត្រោម​ទូក​ក្វ៝ង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ខាន់​ពាង់​មោ​គឹត​អោស​នារ​ទាក​លេង​ទាក​ទើង​លែៈ​ត៝ត់​ជេស នហ៝​មា​ឞុក​ខាន់​ពាង់​លែៈ​ផ្យៅ។ តា​នារ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់​តៃ​តឹម​ឞាន​កើត​អី​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","នោក​នៃ​លាស​គែស​ឞារ​ហៃ​ឞូនុយ្ស​គុ​តា​មីរ ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ឆ៝ៈ​មា​អ៝ន់​គុ​តា​ប៝ន​អ្វែស​តា​កាលើ ហោម​រ៝ង​ទូ​ហ្វេ​មា​តេៈ​ទោយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","លាស​គែស​ឞារ​ហៃ​ឞូ​អូរ​គុ​ពែស​តឹម​រាប់ កោរាញ​ឞ្រាស​ឆ៝ៈ​ទូ​ហ្វេ​អ៝ន់​គុ​តា​ប៝ន​អ្វែស​តា​កាលើ ហោម​រ៝ង​ទូ​ហ្វេ​មា​តេៈ​ទោយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","លាស​នទ្រី​ខាន់​អៃ​មៃ​គុ​ញជ្រាង់​នឹង យ៝រ​លាស​មោ​គឹត​អោស​ម៝ស​ម៝ង​កោរាញ​ខាន់​អៃ​មៃ​វាច់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","អ៝ន់​ខាន់​អៃ​មៃ​គឹត​នាវ​អ្យា៖ លាស​ឞូនុយ្ស​តើម​ជៃ​គឹត​ម៝ង​ឞូ​ហាន់​នតុង​តា​មាង់ ពាង់​រាងែស​មោ​អោស​ប៝ក​គ៝រ​អ៝ន់​ឞូនុយ្ស​នតុង​អី​នៃ​លាប់​តា​ជៃ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","លាស​នទ្រី​អ៝ន់​ខាន់​អៃ​មៃ​គុ​ញជ្រាង់​តឹម​ឞាន​ដ៝ង់ យ៝រ​លាស​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់​តា​ម៝ង​ខាន់​អៃ​មៃ​មោ​គែស​មឹន”។ ");
INSERT INTO cmok_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ឞូ​ម៝ស​អី​តឹម​ឞាន​មា​ទូ​ហ្វេ​ទឹក​អី​គែស​នូយ្ស​នហ៝ម់​ឆ៝ង់ នទ្រែល​មា​លែៈ​ឞ្លាវ​ងាន់? កោរាញ​ជាវ​ពាង់​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ទឹក​អា​អេង​តា​ជៃ នទ្រែល​មា​អ៝ន់​ពាង់​ពាៈ​នទើ​ឆោង​ឆា​តឹម​ទី​ម៝ង​អ៝ន់​មា​ខាន់​ពាង់​ដ៝ង់។ ជេសរី​កោរាញ​ពាង់​ហាន់​តា​នតុក​ងាយ​ជ៝ៈ​នារ។ ");
INSERT INTO cmok_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","នោក​កោរាញ​ពាង់​ឆឹត​ត៝ត់​តា​ជៃ​រី ហោម​ឆៃ​ពាង់​ជាន​ការ​កើត​នៃ ទឹក​អី​នៃ​គែស​នាវ​អ្វែស​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ កោរាញ​អី​នៃ​មរា​អ៝ន់​ទឹក​អី​នៃ​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​នទើ​ពាង់​គែស។ ");
INSERT INTO cmok_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","យើន​មា​លាស​ទឹក​អី​នៃ​អ្យើស ពាង់​គែស​លាស​អេង​តា​នូយ្ស​នហ៝ម់​ពាង់​នើម​រី៖ «កោរាញ​គ៝ប់​ជ៝ៈ​ងាន់​ឆឹត មោ​អោស​គើញ​ឆឹត»។ ");
INSERT INTO cmok_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ជេសរី​ពាង់​នតើម​រាពាត់​មឞាង​ទឹក​អា​អេង នទ្រែល​មា​ឆោង​ឆា​ញេត​នទ្រាញ់​នទ្រែល​ឞូនុយ្ស​ហៃ​ញេត។ ");
INSERT INTO cmok_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ជេសរី​កោរាញ​ទឹក​អី​នៃ​ព្លឹ​ឆឹត​ត៝ត់​តា​រី តា​នារ​ទឹក​អី​នៃ​មោ​អោស​គែស​ញជ្រាង់ តា​ម៝ង​ពាង់​មោ​ដ៝ង់​គែស​គឹត​ល៝រ។ ");
INSERT INTO cmok_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","កោរាញ​ងក្រីត​ពាង់​រ៝ នទ្រែល​មា​អ៝ន់​ពាង់​គុ​តា​នតុក​ផូង​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម​ដ៝ង់។ តា​នតុក​នៃ​គែស​ញហ្យាង់​ញុម នទ្រែល​មា​រាច្យាត់​ឆេក”។ ");
INSERT INTO cmok_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“នោក​នៃ​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​តឹម​ឞាន​មា​ឞូ​អូរ​ទ្រោស​ជឹត​នុយ្ស​ហាន់​វើត​ឆាយ​មហែ​អា​មាង់។ ខាន់​ពាង់​ញអោត​អុញ​ឆាគេង​អាប់​ឞូនុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","គែស​ព្រាម់​នុយ្ស​តា​មពោល​ខាន់​ពាង់​នៃ​មោ​គែស​អោស​នាវ​មឹន យើន​មា​គែស​ព្រាម់​នុយ្ស​គែស​នាវ​មឹន។ ");
INSERT INTO cmok_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","មពោល​អី​មោ​គែស​នាវ​មឹន​នៃ ញអោត​ទើម​ទាក​ព្រីង​តា​ឆាគេង តីស​មា​មោ​គែស​អោស​ញអោត​រានាៈ។ ");
INSERT INTO cmok_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","យើន​មា​មពោល​អី​គែស​នាវ​មឹន ខាន់​ពាង់​ញអោត​ទាក​ព្រីង​តា​ឆាគេង នទ្រែល​មា​គែស​ញអោត​រានាៈ​តា​ដ៝ប​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","យ៝រ​មា​ក៝ប់​ឆាយ​មហែ​អី​នៃ​ជ៝ៈ​ងាន់​ត៝ត់ ខាន់​ពាង់​ជី​ឞិច​នហ៝​មា​ហាក់​លេរ​ខេរ។ ");
INSERT INTO cmok_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ត៝ត់​ងគូល​មាង់​រី តាង់​ឞូ​នតែរ៖ «ឆាយ​មហែ​លែៈ​ត៝ត់​ជេស! រាន​វើត​ពាង់​ហ៝ម់!» ");
INSERT INTO cmok_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ទឹង​លែៈ​ឞូ​អូរ​ទ្រោស​អី​នៃ​ទ៝ក់ នទ្រាប់​ឆាគេង​ឞូ​មា​ហែ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","មពោល​អី​មោ​គែស​នាវ​មឹន​លាស​មា​មពោល​អី​គែស​នាវ​មឹន៖ «ទាន់​ពាៈ​អ៝ន់​ហេន​បាៈ​ទាក​ព្រីង​អើ យ៝រ​លាស​អុញ​ឆាគេង​ហេន​ឞើយ​មា​ញហាត់»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","មពោល​អី​គែស​នាវ​មឹន​អើស៖ «មោ​អោស លាស​ហេន​ពាៈ​អ៝ន់​ខាន់​អៃ មាៈ​មា​ហេន​នើម មាៈ​មា​ខាន់​អៃ។ អ៝ន់​ខាន់​អៃ​ហាន់​តា​នតុក​ឞូ​តាច់​ព្រីង​រី​រាវាត់​ទោ!» ");
INSERT INTO cmok_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","យើន​មា​នទុត​ខាន់​ពាង់​ហាន់​រាវាត់​ព្រីង ឆាយ​មហែ​ត៝ត់​រ៝។ ល៝ង់​មពោល​ឞូ​អូរ​អី​លែៈ​គុ​នទ្រាប់​ឆាក់​លែវ​ឞាល់​លាប់​រាងាត់​តា​ត្រោម​ជៃ​នតឹល​មពោង ជេសរី​ឆោង​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ជ៝ៈ​ទូ​ប្ល៝ត់​ត៝ត់​មពោល​ឞូ​អូរ​អី​មោ​គែស​នាវ​មឹន​រី​នតែរ៖ «អើ​កោរាញ អើ​កោរាញ! ពឹ​មពោង​អ៝ន់​ហេន​អើ!» ");
INSERT INTO cmok_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","យើន​មា​កោរាញ​មោ​អោស​អ៝ន់​លាប់ ពាង់​អើស៖ «គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ គ៝ប់​មោ​អោស​គឹត​នាល់​ខាន់​អៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","លាស​នទ្រី​អ៝ន់​គុ​ញជ្រាង់​ហ៝ម់ យ៝រ​លាស​ខាន់​អៃ​មៃ​មោ​គឹត​អោស​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់​ម៝ស​ម៝ង នារ​មោ​គឹត​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​តឹម​ឞាន​មា​ទូ​ហ្វេ​ឞូ​ក្លោ អេ​ល៝រ​មា​ពាង់​ហាន់​ប៝ន​ងាយ ពាង់​ក្វាល់​ផូង​ទឹក​ពាង់ ជេសរី​ជាវ​ទ្រាប់​នទើ​មា​ខាន់​ពាង់​អ៝ន់​ម៝ត់​អ្វាញ់។ ");
INSERT INTO cmok_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ទូ​ហ្វេ​ពាង់​អ៝ន់ ៥០០០ ទូ​ហ្វេ​ពាង់​អ៝ន់ ២០០០‌ ទូ​ហ្វេ​ជឹត​ពាង់​អ៝ន់ ១០០០។ ពាង់​អ៝ន់​ទូ​ហ្វេ​ទូ​ហ្វេ​តឹង​អី​នាវ​ខាន់​ពាង់​ឞ្លាវ។ ជេសរី​អី​ពាង់​នើម​នៃ​ទូ​លោស​ឞើស​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","នើម​អី​ទើន ៥០០០ រី ពាង់​ឆ៝ៈ​ព្រាក់​អី​នៃ​ហាន់​តាច់​រាគ៝ល់​រ៝ ពាង់​ហាវ​គែស ៥០០០ ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","នើម​អី​ទើន ២០០០ តឹម​ឞាន​កើត​នៃ​ដ៝ង់ ពាង់​ឆ៝ៈ​ព្រាក់​ហាន់​តាច់​រាគ៝ល់​ហាវ​គែស ២០០០ ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ល៝ង់​នើម​អី​ទើន ១០០០ រី ពាង់​កុយ្ស​នតូ​ត៝ប់​លើយ​ព្រាក់​អី​កោរាញ​ពាង់​អ៝ន់​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ត៝ត់​ជ៝ៈ​នារ​ឞើស​កើយ​ឆឹត​អី​កោរាញ​ខាន់​ពាង់​អី​នៃ​ឞើស​រី ពាង់​អោប​ព្រាក់​តឹង​រាន៝ស​អ៝ក់​ពាង់​អ៝ន់​មា​ខាន់​ពាង់​រី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","នើម​អី​ទើន​ព្រាក់ ៥០០០ រី​នើស​ហាន់​តា​ឞើស​នាប់​ពាង់​រី ញអោត​ព្រាក់​អី​ហាវ ៥០០០ រី​នើស​ជឹត លាស​មា​កោរាញ​ពាង់៖ «អើ​កោរាញ មៃ​អ៝ន់​ព្រាក់​មា​គ៝ប់​នើស ៥០០០‌ អាបៃ​អ្យា​ហាវ​គែស ៥០០០ ជឹត»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","កោរាញ​លាស​មា​ពាង់៖ «អ្វែស​ងាន់! អើ​ទឹក​អ្វែស​គែស​នូយ្ស​នហ៝ម់​រាប់​ជាប់ នទើ​ជេៈ​គ៝ប់​អ៝ន់ មៃ​ជាន​លែៈ​រាប់​ជាប់។ គ៝ប់​មរា​អ៝ន់​មៃ​ម៝ត់​អ្វាញ់​នទើ​ក្វ៝ង់​ជឹត។ លាប់​ហ៝ម់​គុ​មអាក​នទ្រែល​គ៝ប់​នើម»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","នើម​អី​ទើន​ព្រាក់ ២០០០ រី​នើស ញអោត​ព្រាក់​អី​ហាវ ២០០០ ជឹត ហាន់​នទឹ​អា​កោរាញ​ពាង់ លាស​កើត​នទ្រី​ដ៝ង់៖ «អើ​កោរាញ! មៃ​អ៝ន់​ព្រាក់​មា​គ៝ប់​នើស ២០០០‌ អាបៃ​អ្យា​ហាវ​គែស ២០០០ ជឹត»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","កោរាញ​ពាង់​អើស៖ «អ្វែស​ងាន់! អើ​ឞូនុយ្ស​ជាន​ការ​អ្វែស​គែស​នូយ្ស​នហ៝ម់​ឆ៝ង់ នទើ​ជេៈ​គ៝ប់​អ៝ន់ មៃ​ជាន​លែៈ​ឆ៝ង់។ គ៝ប់​មរា​អ៝ន់​មៃ​ម៝ត់​អ្វាញ់​នទើ​ក្វ៝ង់​ជឹត។ លាប់​ហ៝ម់​គុ​មអាក​នទ្រែល​គ៝ប់​នើម»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ជេសរី​នើម​អី​ទើន​ព្រាក់ ១០០០ រី​នើស​ហាន់​អា​កោរាញ​ពាង់​ដ៝ង់ លាស​មា​ពាង់៖ «អើ​កោរាញ! គ៝ប់​គឹត​មៃ​ជេង​ឞូនុយ្ស​ជាញ​ងាន់។ យ៝រ​លាស​មៃ​កាច់​តា​នតុក​មៃ​មោ​ព្រ៝ត​តូច ជេសរី​រែក​តា​នតុក​មោ​ព្រ៝ត​តាម់។ ");
INSERT INTO cmok_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","កើត​នទ្រី​គ៝ប់​ឆ៝ៈ​ព្រាក់​អី​មៃ​អ៝ន់​មា​គ៝ប់​នើស​ត៝ប់​លើយ យ៝រ​លាស​គ៝ប់​ក្លាច​ហោ​អីរ​ងាន់។ អ្យា​ព្រាក់​មៃ​នើម​ឆ៝ៈ​ហ៝ម់»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","យើន​មា​កោរាញ​ពាង់​អើស៖ «អើ​ឞូនុយ្ស​ជាន​ការ​អ្យើស​មហឹក នទ្រែល​មា​រាលែស​ប្លាវ! មៃ​គឹត​គ៝ប់​កាច់​តា​នតុក​គ៝ប់​មោ​ព្រ៝ត​តូច ជេសរី​រែក​តា​នតុក​មោ​ព្រ៝ត​តាម់។ ");
INSERT INTO cmok_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","លាស​នទ្រី​ទី​លាស​អ៝ន់​មៃ​ឆ៝ៈ​ព្រាក់​អី​នៃ​អ៝ន់​តា​ជៃ​ឞូ​តាច់​រាគ៝ល់ ត៝ត់​គ៝ប់​ព្លឹ​ឆឹត គ៝ប់​គែស​ព្រាក់​អើម គែស​នអ៝ប់​មា​លោស​ក៝ន​ពាង់​ដ៝ង់! ");
INSERT INTO cmok_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","លាស​នទ្រី​ខាន់​មៃ​ឆ៝ៈ​ហ៝ម់​ព្រាក់​ឞើស​ពាង់​អ្យា​អ៝ន់​មា​ឞូនុយ្ស​អី​គែស ១០០០០។ ");
INSERT INTO cmok_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","កើត​នទ្រី​ឞូ​ម៝ស​អី​លែៈ​គែស ឞូ​កើយ​នត៝ប​អ៝ន់​តៃ អ៝ន់​គែស​អ៝ក់​រាមែស​ជឹត។ យើន​មា​ឞូ​ម៝ស​អី​មោ​គែស​អោស ឞូ​រាហ្វាត់​លើយ​នអ៝ប់​មា​ម៝ស​នទើ​អី​ពាង់​លែៈ​គែស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ល៝ង់​ឞូនុយ្ស​អី​ជាន​ការ​មោ​គែស​នាវ​ខ្លៃ​អ្យា ញុប​មអារ់​លើយ​ពាង់​តា​នតុក​ង៝​ឞើស​ទីស តា​នតុក​នៃ​ញហ្យាង់​ញុម នទ្រែល​មា​រាច្យាត់​ឆេក!»” ");
INSERT INTO cmok_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“នោក​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់​នអ៝ប់​មា​នាវ​ច្រេក​លើប​គ៝ប់ នទ្រែល​មា​ទឹង​លែៈ​ផូង​តោង​ពារ់ នោក​នៃ​គ៝ប់​គុ​តា​រានើល​កាដាច់​ច្រេក​លើប​គ៝ប់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","នោក​នៃ​ទឹង​លែៈ​ឞូនុយ្ស​ទឹង​លែៈ​នទុល​មពោល​វាច់​គូម​តា​គ៝ប់​ទាទេ។ គ៝ប់​តឹម​ងខាស​លើយ​ខាន់​ពាង់ តឹម​ឞាន​មា​ឞូនុយ្ស​ច្យាប់​តឹម​ងខាស​ឞែ​ឞ្យាប់​ដាស​ឞែ។ ");
INSERT INTO cmok_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ឞូនុយ្ស​អី​តឹម​ឞាន​មា​ឞែ​ឞ្យាប់​គ៝ប់​អ៝ន់​គុ​ឞើស​មា ឞូនុយ្ស​អី​តឹម​ឞាន​មា​ឞែ​គ៝ប់​អ៝ន់​គុ​ឞើស​ច្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","នោក​នៃ​គ៝ប់​អី​កាដាច់​លាស​មា​ផូង​គុ​ឞើស​មា​គ៝ប់​នតុក​ឞូ​លឺ៖ «អើ​ផូង​លែៈ​ឞឹ​គ៝ប់​អ៝ន់​នាវ​គែស​ជេង​ជេស! វាច់​ហ៝ម់ លាប់​គុ​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​អី​លែៈ​ពាង់​នទ្រាប់​អ៝ន់​មា​ខាន់​អៃ​មៃ​នតើម​ឞើស​ញជេង​នែស​នតូ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","យ៝រ​លាស​នោក​គ៝ប់​ជី​ង៝ត​ខាន់​អៃ​មៃ​លែៈ​អ៝ន់​នទើ​ឆោង​ឆា​មា​គ៝ប់ នោក​គ៝ប់​ជី​ហីរ​ខាន់​អៃ​មៃ​អ៝ន់​ទាក​គ៝ប់​ញេត នោក​គ៝ប់​ជេង​ឞូ​នាច់​អី​ខាន់​អៃ​មៃ​មោ​គឹត​នាល់ ខាន់​អៃ​មៃ​ហោម​រ៝ម​អ៝ន់​គុ‌ ");
INSERT INTO cmok_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","នោក​គ៝ប់​គុ​ឆាក់​កុស​ខាន់​អៃ​មៃ​អ៝ន់​ឞ៝ក​អាវ​ញឆ៝ស នោក​គ៝ប់​គែស​នាវ​ជី​ខាន់​អៃ​មៃ​ហាន់​ច៝ប នោក​គ៝ប់​គែស​នទ្រូង​ខាន់​អៃ​មៃ​ហាន់​ខ៝ល់​កើល​គ៝ប់​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ជេសរី​ផូង​ឆ៝ង់​លាស​មា​គ៝ប់៖ «អើ​កោរាញ! ហេន​មោ​ព្រ៝ត​អោស​ឆៃ​មៃ​ជី​ង៝ត ជេសរី​អ៝ន់​មៃ​ឆោង មោ​លាស​ជី​ហីរ​ទាក​អ៝ន់​ទាក​មៃ​ញេត។ ");
INSERT INTO cmok_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ហេន​មោ​ព្រ៝ត​អោស​ឆៃ​មៃ​ជេង​ឞូ​នាច់​អី​ហេន​មោ​គឹត​នាល់ ជេសរី​រ៝ម​មៃ​លាប់​ជៃ មោ​លាស​ឆៃ​មៃ​គុ​ឆាក់​កុស​ហេន​អ៝ន់​ឞ៝ក​អាវ​មា​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ហេន​មោ​ព្រ៝ត​ដ៝ង់​ឆៃ​មៃ​គែស​នាវ​ជី មោ​លាស​គែស​នទ្រូង ជេសរី​ហាន់​ច៝ប​ខ៝ល់​កើល​មៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ជេសរី​គ៝ប់​អី​កាដាច់​លាស​មា​ខាន់​ពាង់៖ «គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ អាប់​តឹ​ខាន់​អៃ​មៃ​លែៈ​គែស​ជាន​នាវ​អី​នៃ​មា​ទូ​ហ្វេ​ឞូនុយ្ស​អី​ទុត​ជេៈ​តា​ន៝ម់​ឞូ​តា​ផូង​អ៝ស​នោ​គ៝ប់ តឹម​ឞាន​មា​ខាន់​អៃ​មៃ​លែៈ​គែស​ជាន​អ៝ន់​មា​គ៝ប់​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ជេសរី​គ៝ប់​លាស​មា​ផូង​អី​គុ​ឞើស​ច្យៅ​គ៝ប់៖ «អើ​ផូង​លែៈ​កោរាញ​ឞ្រាស​រាក​រាតាប់! រុច​ទូ​ងាយ​ហ៝ម់​ឞើស​គ៝ប់​ហាន់​តា​នទ្រូង​អុញ​ហីត​មរ៝​មរាង់ ជេង​នតុក​នទ្រាប់​មា​តេៈ​ទោយ្ស​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស នទ្រែល​មា​ផូង​អី​តឹង​ពាង់! ");
INSERT INTO cmok_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","យ៝រ​លាស​នោក​គ៝ប់​ជី​ង៝ត​ខាន់​អៃ​មៃ​មោ​អ៝ន់​គ៝ប់​ឆោង នោក​គ៝ប់​ជី​ហីរ​ខាន់​អៃ​មៃ​មោ​អ៝ន់​ទាក​គ៝ប់​ញេត‌ ");
INSERT INTO cmok_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","នោក​គ៝ប់​ជេង​ឞូ​នាច់​អី​ខាន់​អៃ​មៃ​មោ​គឹត​នាល់ ខាន់​អៃ​មៃ​មោ​រ៝ម​គុ នោក​គ៝ប់​គុ​ឆាក់​កុស​ខាន់​អៃ​មៃ​មោ​អ៝ន់​ឞ៝ក​អាវ​មា​គ៝ប់គ៝ប់​គែស​នាវ​ជី នទ្រែល​មា​គែស​នទ្រូង​ខាន់​អៃ​មៃ​មោ​ហាន់​ខ៝ល់​កើល​គ៝ប់​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ជេសរី​ផូង​អី​នៃ​អើស​មា​គ៝ប់៖ «អើ​កោរាញ! ហេន​មោ​ព្រ៝ត​អោស​ឆៃ​មៃ​ជី​ង៝ត ជី​ហីរ​ទាក ជេង​ឞូ​នាច់​អី​ហេន​មោ​គឹត​នាល់ គុ​ឆាក់​កុស គែស​នាវ​ជី មោ​លាស​គែស​នទ្រូង ជេសរី​មោ​គែស​កើល​មៃ!» ");
INSERT INTO cmok_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ជេសរី​គ៝ប់​លាស​តៃ​មា​ខាន់​ពាង់៖ «គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ អាប់​តឹ​ខាន់​អៃ​មៃ​មោ​គែស​អោស​ជាន​នាវ​អី​នៃ​មា​ទូ​ហ្វេ​ឞូនុយ្ស​អី​ទុត​ជេៈ​តា​ន៝ម់​ឞូ​តា​ផូង​អ៝ស​នោ​គ៝ប់ លាស​នទ្រី​ជេង​តឹម​ឞាន​មា​ខាន់​អៃ​មៃ​មោ​គែស​ដ៝ង់​ជាន​មា​គ៝ប់»។ ");
INSERT INTO cmok_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ល៝ង់​ទឹង​លែៈ​ផូង​អី​នៃ​ហាន់​តា​នតុក​តេៈ​ទោយ្ស​នហ៝​រ៝ យើន​មា​ផូង​ឆ៝ង់​គែស​នាវ​រេស​នហ៝​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ជេស​ឞ្រាស​យេឆូ ​លាស​កើត​នៃ ជេសរី​ពាង់​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ខាន់​មៃ​លែៈ​គឹត​ជេស​ហោម​ឞារ​នារ​ជឹត​ទី​នារ​ញេត​បុន​នហ៝ត ជេសរី​ឞូ​ញុប​ញជុន​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​អ៝ន់​ឞូ​ងខឹត​តា​ឆី​តឹម​រាកាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","នោក​នៃ​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​កោរាញ​ប៝ន​លាន​គុ​រាបុន​តា​ជៃ​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់ រាញា​ពាង់​កៃផាស ‌ ");
INSERT INTO cmok_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ជេសរី​តឹម​ញច្រាៈ​ឞាល់​ជ៝យ​នាវ មើម​ទឹង​គែស​ញុប​នតុង​ឞ្រាស​យេឆូ ​ងខឹត​លើយ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","យើន​មា​ខាន់​ពាង់​តឹម​ញច្រាៈ​ឞាល់​លាស៖ “លើយ​អោស​ឞ៝ន់​ញុប​តា​នោក​ជាន​បុន ក្លាច​លាស​គែស​នាវ​អុស​អាស​តាស​ត៝រ់​មា​ផូង​ប៝ន​លាន”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","នោក​ឞ្រាស​យេឆូ ​គុ​តា​ប៝ន​បេថានី ពាង់​គុ​តា​ជៃ​ឆីមោន ​ឞូនុយ្ស​តាៈ​ផុង​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","នោក​ពាង់​ឆោង​ឆា​នទ្រែល គែស​ទូ​ហ្វេ​ឞូ​អូរ​ឞ្រោៈ​ត៝ត់​លាប់​តា​ជៃ​នៃ​ញអោត​ទូ​មល៝ម់​ដ៝ប​លុ។ តា​ត្រោម​ដ៝ប​នៃ​គែស​ងី​បោ​កាស​អី​ខ្លៃ​ងាន់។ ជេសរី​ពាង់​ត៝ៈ​ទាក​ងី​បោ​កាស​តា​ឞោក​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","យើន​មា​មពោល​អ៝ស​ម៝ន​ឆៃ​កើត​នៃ​ជី​នូយ្ស ខាន់​ពាង់​លាស៖ “ម៝ស​ជាន​មពុង​មពាង់​កើត​នៃ! ");
INSERT INTO cmok_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","លាស​ឆ៝ៈ​ទាក​ងី​អី​នៃ​តាច់​គែស​ព្រាក់​អ៝ក់​ងាន់ ជេសរី​ពាៈ​អ៝ន់​ឞូនុយ្ស​អ៝​អាច!” ");
INSERT INTO cmok_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","យើន​មា​ឞ្រាស​យេឆូ ​គឹត​នាវ​ខាន់​ពាង់​ងើយ ពាង់​លាស​មា​ខាន់​ពាង់៖ “មើម​ទឹង​ខាន់​មៃ​ជាន​អ៝ន់​ឞូ​អូរ​អី​នៃ​គែស​នាវ​រាង៝ត​កើត​នៃ? ពាង់​លែៈ​ជាន​នាវ​អ្វែស​អ៝ន់​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ឞូនុយ្ស​អ៝​អាច​ហោម​គុ​នទ្រែល​ខាន់​មៃ​មរ៝ យើន​មា​គ៝ប់​អ្យា​មោ​អោស​គុ​នទ្រែល​ខាន់​មៃ​មរ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","យោស​អ្យា​ត៝ៈ​ទាក​ងី​បោ​កាស​តា​ឆាក់​គ៝ប់ ពាង់​នទ្រាប់​ត៝ប់​គ៝ប់​តា​មោច។ ");
INSERT INTO cmok_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ អាប់​នតុក​ឞូ​ហាន់​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​អ្យា​លាម​ងគ៝រ​ឞ្រី​តា​នែស​នតូ​អ្យា ឞូ​ងក៝ច​មា​នាវ​អី​ពាង់​ជាន​នើស​ដ៝ង់ គៃ​មា​ងកាស​តោរ​ឞូ​ឞាស​ច្វេល​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","នោក​នៃ​គែស​ទូ​ហ្វេ​អ៝ស​ម៝ន​តា​មពោល​កោរាញ​អ៝ស​ម៝ន ១២ នុយ្ស​រី រាញា​ពាង់​យូដាស-​អីឆាការីយោត  ពាង់​ហាន់​ម៝ប់​មពោល​កោរាញ​ជាន​ឞ្រាស អោប​ខាន់​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ម៝ស​នទើ​ខាន់​មៃ​អ៝ន់​មា​គ៝ប់ លាស​គ៝ប់​ញជុន​ឞូនុយ្ស​អី​នៃ​មា​ខាន់​មៃ?” ខាន់​ពាង់​អ៝ន់​ព្រាក់​មា​ពាង់ ៣០ កាក់​ព្រាក់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","នតើម​ឞើស​នោក​នៃ​យូដាស-​អីឆាការីយោត ​ជ៝យ​ម៝ង​អី​អ្វែស គៃ​មា​លែវ​ឞូ​ហាន់​ញុប​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","តា​នារ​លាប់​ញេត​បុន​នុមពាង់​មោ​គែស​នទ្រូយ មពោល​អ៝ស​ម៝ន​ហាន់​អា​ឞ្រាស​យេឆូ ​អោប​ពាង់៖ “ហើយ​កោរាញ អាស​នតុក​មៃ​អុច​អ៝ន់​ហេន​នទ្រាប់​មា​មៃ​ញេត​ឆោង​បុន​នហ៝ត​អ្យា​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ហាន់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​រី ហាន់​តា​ទូ​ហ្វេ​ឞូ​ក្លោ​អី​នៃ លាស​មា​ពាង់៖ «នើម​នតី​លាស នារ​នាវ​ជេរ​ជ៝ត់​គ៝ប់​ឞើយ​ត៝ត់​ជេស គ៝ប់​អុច​នទ្រាប់​ញេត​បុន​នហ៝ត​នទ្រែល​មពោល​អ៝ស​ម៝ន​គ៝ប់​តា​ជៃ​មៃ»”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ជេសរី​មពោល​អ៝ស​ម៝ន​ជាន​តឹង​នាវ​ឞ្រាស​យេឆូ ​ដាៈ​មា​ខាន់​ពាង់ នហ៝​មា​ខាន់​ពាង់​នទ្រាប់​នទើ​ឆោង​ឆា​មា​នាវ​ញេត​បុន​នហ៝ត​តា​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ត៝ត់​កេង​មាង់​ឞ្រាស​យេឆូ ​គុ​តា​ញឆឺង​នទ្រែល ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","នោក​គុ​ឆោង​ឆា​ពាង់​លាស​កើត​នអា៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ តា​មពោល​ខាន់​មៃ​គែស​ទូ​ហ្វេ​លែវ​ឞូ​ហាន់​ញុប​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ទឹង​លែៈ​មពោល​កោរាញ​អ៝ស​ម៝ន​រាវៃ​ហោ​ងាន់ ខាន់​ពាង់​អោប​ឞ្រាស​យេឆូ ៖ “អើ​កោរាញ! គឹត​គ៝ប់​ហើ?” ");
INSERT INTO cmok_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ឞូ​ម៝ស​ពាង់​អី​លុប​នុមពាង់​តា​ងាន​នទ្រែល​គ៝ប់ ពាង់​អី​នៃ​លែវ​ឞូ​ហាន់​ញុប​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ឞូ​មរា​ងខឹត តឹង​មា​នាវ​លែៈ​ញចីស​លាស​មា​នាវ​គ៝ប់។ តីស​មា​ពាង់​អី​លែវ​ឞូ​ហាន់​ញុប​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​នៃ ពាង់​អី​នៃ​គែស​នាវ​រេស​រាញាល់​ងាន់​រ៝ អ្វែស​រាលាវ​លើយ​ទឹង​ទែស​ពាង់​អី​នៃ​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","យូដាស-​អីឆាការីយោត ​អី​នើម​លែវ​ឞូ​ហាន់​ញុប​ពាង់​រី​លាស៖ “អើ​នើម​នតី! គឹត​គ៝ប់​ហើ?” ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ទី​កើត​នាវ​មៃ​លាស​នៃ​ងាន់!” ");
INSERT INTO cmok_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ខាន់​ពាង់​ហោម​គុ​ឆោង​ឆា ជេសរី​ឞ្រាស​យេឆូ ​ឆ៝ៈ​ទូ​មល៝ម់​នុមពាង់ លាស​អ្វែស​មា​កោរាញ​ឞ្រាស ជេសរី​គិច​អ៝ន់​មពោល​អ៝ស​ម៝ន​ឆា នហ៝​មា​លាស៖ “ខាន់​មៃ​ឆ៝ៈ​ឆា​យឹ អ្យា​អី​ឆាក់​ជាន់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ជេសរី​ពាង់​ឆ៝ៈ​កាច៝ក​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​លាស​អ្វែស​មា​កោរាញ​ឞ្រាស ពាង់​នទឹ​អ៝ន់​មា​ខាន់​ពាង់ ជេសរី​លាស៖ “ញេត​ទឹង​លែៈ​មា​ឞាល់​ហ៝ម់‌ ");
INSERT INTO cmok_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","យ៝រ​លាស​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​តា​កាច៝ក​អ្យា​អី​មហាម​គ៝ប់ អី​ហ៝ច​ឞើស​ឆាក់​ជាន់​គ៝ប់​នោក​គ៝ប់​ខឹត​តៃ គៃ​មា​យោៈ​ឞូនុយ្ស​មោ​ហោម​អោស​កើប​នាវ​តីស​ខាន់​ពាង់។ មា​មហាម​អី​អ្យា​កោរាញ​ឞ្រាស​ជាន​នាវ​តឹម​រាង្លាប់​មហែ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","គ៝ប់​មឞើស​អ៝ន់​មា​ខាន់​មៃ​គឹត គ៝ប់​មោ​ហោម​អោស​ញេត​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​អ្យា​ជឹត នហ៝​មា​ត៝ត់​នារ​គ៝ប់​ញេត​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មហែ​ត៝ត់​នាវ​ឞឹ​គ៝ប់​ម៝ត់​អ្វាញ់​លែៈ​ត៝ត់​ងាន់​មើ”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ជេស​មព្រើ​រានេ ឞ្រាស​យេឆូ ​នទ្រែល​មពោល​អ៝ស​ម៝ន​ពាង់​លោស​ឞើស​នៃ​ហាន់​ជឹត​យោក​តើម​អោលីវ ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “ទឹង​លែៈ​ខាន់​មៃ​នត្លើយ​គ៝ប់​តា​មាង់​អ្យា យ៝រ​មា​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​គែស​ញចីស៖ «កោរាញ​ឞ្រាស​លាស៖ «គ៝ប់​មឞាង​ងខឹត​លើយ​នើម​ច្យាប់​ឞែ​ឞ្យាប់‌ ជេសរី​ផូង​ឞែ​ឞ្យាប់​ទូ​ចាស​ច្រាយ​លែៈ»»។ ");
INSERT INTO cmok_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","យើន​មា​ជេស​គ៝ប់​ទ៝ក់​រេស​តៃ គ៝ប់​ហាន់​ត៝ត់​ល៝រ​ឞើស​នាប់​ខាន់​មៃ​តា​ឞ្រី​កាលីលេ ”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ជេស​តាង់​ឞ្រាស​យេឆូ ​ងើយ​នទ្រី​ពេត្រោស ​លាស​មា​ពាង់៖ “ឞ៝ល​លាស​ទឹង​លែៈ​ខាន់​ពាង់​នត្លើយ​មៃ​កាដោយ ទូ​ញជារ់​នាវ​រេស​គ៝ប់ គ៝ប់​មោ​អោស​នត្លើយ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​មៃ៖ តា​មាង់​អ្យា​រ៝ អេ​ល៝រ​មា​អ្យារ់​នទ្រាវ មៃ​រាលាច់​ពែ​តឹ​លាស​មោ​គឹត​នាល់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ពេត្រោស ​លាស​មា​ឞ្រាស​យេឆូ ៖ “មោ​អោស! ឞ៝ល​លាស​ឞូ​ងខឹត​គ៝ប់​នទ្រែល​មៃ​កាដោយ គ៝ប់​មោ​គែស​អោស​រាលាច់​លាស​មោ​គឹត​នាល់​មៃ”។ ទឹង​លែៈ​មពោល​អ៝ស​ម៝ន​អាបាៈ​លាស​កើត​ពាង់​ទាទេ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​ផូង​អ៝ស​ម៝ន​ពាង់​ហាន់​ជឹត​ទូ​នតុក​រាញា​គេតឆេមានី ។ ពាង់​លាស៖ “ខាន់​មៃ​គុ​តា​អ្យា​ប៝ត់​យឹ។ គ៝ប់​ហាន់​មឞើស​ឆើម​អា​ត៝​ប៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ឞ្រាស​យេឆូ ​ជាៈ​ពេត្រោស  នទ្រែល​មា​ឞារ​ហៃ​អី​ក៝ន​ឆេបេដេ ​ហាន់​នទ្រែល​ពាង់។ នោក​នៃ​តា​នូយ្ស​នហ៝ម់​ឞ្រាស​យេឆូ ​នតើម​គែស​នាវ​រាង៝ត នទ្រែល​មា​គែស​នាវ​អោស​នូយ្ស​អោស​នហ៝ម់​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ពាង់​លាស​មា​ពែ​នុយ្ស​ខាន់​ពាង់​នៃ៖ “នូយ្ស​នហ៝ម់​គ៝ប់​រាង៝ត​ហោ​ងាន់​នទាៈ​មា​ខឹត​រ៝។ ខាន់​មៃ​ហោម​គុ​តា​អ្យា​ប៝ត់ គុ​រាងែស​ញជ្រាង់​នទ្រែល​គ៝ប់​ហ៝ៈ”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​ជឹត​នាប់​ដេៈ ពាន់​ត្រុយ្ស​អា​នែស​មឞើស​ឆើម​ទាន់៖ “អើ​ឞឹ! លាស​ទើយ ទាន់​មៃ​ឆ៝ៈ​នាវ​ជេរ​ជ៝ត់​អ្យា​អ៝ន់​ទូ​ងាយ​ឞើស​គ៝ប់ យើន​មា​លើយ​តឹង​នូយ្ស​នហ៝ម់​គ៝ប់​អុច​អោស អ៝ន់​តឹង​នាវ​មៃ​នើម​អុច​ហ៝ៈ”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ជេសរី​ពាង់​ព្លឹ​ជឹត​មពោល​អ៝ស​ម៝ន​នៃ ឆៃ​ខាន់​ពាង់​ហាក់​ឞិច ពាង់​លាស​មា​ពេត្រោស ៖ “មើម​ខាន់​មៃ​គុ​រាងែស​នទ្រែល​គ៝ប់​ទូ​ម៝ង​មោ​ទើយ​ដ៝ង់! ");
INSERT INTO cmok_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ខាន់​មៃ​ញជ្រាង់​ហ៝ម់​នហ៝​មា​មឞើស​ឆើម គៃ​មា​មោ​ជាន​តីស​នោក​គែស​នាវ​នទើម។ នូយ្ស​នហ៝ម់​ឞូនុយ្ស​លែៈ​អុច​ជាន​ទី​ងាន់ តីស​មា​មោ​អោស​ឞ្លាវ​ជាន យ៝រ​មា​ហោម​រាអ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ជេសរី​ពាង់​ព្លឹ​មឞើស​ឆើម​តៃ​ទូ​តឹ​ជឹត៖ “អើ​ឞឹ! លាស​នាវ​ជេរ​អ្យា​មោ​អោស​ទើយ​បាស​ងាយ​ឞើស​គ៝ប់ លាស​នទ្រី​តឹង​នាវ​មៃ​នើម​អុច!” ");
INSERT INTO cmok_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ត៝ត់​ឞ្រាស​យេឆូ ​ព្លឹ​តៃ​តា​មពោល​អ៝ស​ម៝ន​រី ឆៃ​ខាន់​ពាង់​ហោម​ហាក់​ឞិច​ទាទេ លីន​មាត់​មោ​ទើយ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ពាង់​ហាន់​ឞើស​នតុក​នៃ​ទូ​តឹ​ជឹត ព្លឹ​មឞើស​ឆើម​អាប់​ពែ​តឹ ពាង់​មឞើស​ឆើម​កើត​នាវ​អើម។ ");
INSERT INTO cmok_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ជេសរី​ពាង់​ព្លឹ​តៃ​តា​ផូង​អ៝ស​ម៝ន​រី លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ហោម​ឞិច​ទាស​ជ៝ៈ​មា​កាស? ល៝ង់​អាបៃ​អ្យា​ម៝ង​លែៈ​ត៝ត់​ជេស ឞូ​ញជុន​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​អ៝ន់​មា​ផូង​ឞូនុយ្ស​តីស។ ");
INSERT INTO cmok_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ទ៝ក់​ហ៝ម់​លែវ​ឞាល់​ហាន់ នើម​អី​លែវ​ឞូ​ហាន់​ញុប​គ៝ប់ លែៈ​ឞើយ​ត៝ត់​ហើយ!” ");
INSERT INTO cmok_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ទោល​ឞ្រាស​យេឆូ ​ហោម​ងើយ​នៃ​ត៝ត់​យូដាស-​អីឆាការីយោត ​អី​ទូ​ហ្វេ​ឞូនុយ្ស​តា ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​នៃ។ គែស​ទូ​ផូង​ក្វ៝ង់​ហាន់​នទ្រែល​ពាង់​នៃ ញអោត​ម៝ង់​ញអោត​ដាវ។ ខាន់​ពាង់​អី​នៃ​តាៈ​ឞើស​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​កោរាញ​ប៝ន​លាន​ទែ​ដាៈ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","យូដាស-​អីឆាការីយោត ​អី​លែវ​ឞូ​ហាន់​ញុប​ឞ្រាស​យេឆូ ​នៃ​លែៈ​ជេស​មឞើស​ទូ​នតីល​នាវ​អ៝ន់​គឹត​នាល់​មា​ឞូ​លាស៖ “ឞូ​ម៝ស​អី​គ៝ប់​ចុមពាង់​អី​រី​រ៝ នទ្រី​ខាន់​មៃ​ញុប​ពាង់​ទោ”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","យូដាស-​អីឆាការីយោត ​ត៝ត់​តា​រី ពាង់​ហាន់​ជឹត​ឞ្រាស​យេឆូ  អោប​ឞ្រាស​យេឆូ ៖ “អ្វែស​លាង់​នើម​នតី!” ជេសរី​ចុម​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ឞ្រាស​យេឆូ ​អោប​ពាង់៖ “អើ​ជាង់! ម៝ស​នទើ​មៃ​ហាន់​តា​អ្យា​អុច​ជាន មៃ​ជាន​ហ៝ម់!” ជេសរី​ឞូ​ញុប​ក្រុប​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ទោ​មា​ឆៃ​គែស​ទូ​ហ្វេ​តា​ផូង​គុ​នទ្រែល​ឞ្រាស​យេឆូ  តាក់​ដាវ​ឆ្រែស​តាច់​តោរ​ទូ​ទីង​ទឹក​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់​អី​នៃ៖ “នត្រុប​ហ៝ម់​ដាវ​មៃ​នៃ​តា​នទ្រោម យ៝រ​លាស​ឞូ​ម៝ស​អី​ទ៝ង់​ដាវ ពាង់​ខឹត​មា​ដាវ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","គឹត​មៃ​នអោន​លាស​គ៝ប់​មោ​អោស​ទើយ​ទាន់​មា​ឞឹ​គ៝ប់ ជេសរី​ពាង់​ញជ្វាល់​ផូង​តោង​ពារ់​រាលាវ​មា ១២ ផូង ទូ​ផូង​គែស ៦០០០ នុយ្ស​ហាន់​កើល​គ៝ប់​រ៝? ");
INSERT INTO cmok_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","យើន​មា​លាស​ជាន​កើត​នៃ មើម​ទឹង​គែស​មា​ទី​ដាស​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​គែស​ញចីស​អ៝ន់​គែស​នាវ​អ្យា​ងាន់?” ");
INSERT INTO cmok_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ផូង​អី​នៃ៖ “ម៝ស​ឞ្រោៈ​ខាន់​មៃ​ញអោត​នអ៝ប់​មា​ម៝ង់​មា​ដាវ​កើត​នៃ កើប​គ៝ប់​ជេង​ឞូនុយ្ស​នតុង​ឞើស? អាប់​នារ​កាល់​ទឹ​នើស គ៝ប់​គុ​នតុម​នតី​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស។ ខាន់​មៃ​គុ​តា​នៃ​ដ៝ង់ មោ​អោស​ឆៃ​ញុប​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ទឹង​លែៈ​នាវ​អ្យា​គែស​ងាន់ គៃ​មា​ជេង​ទី​កើត​នាវ​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ញចីស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ”។ ជេសរី​មពោល​អ៝ស​ម៝ន​ញច្វាត់​លែៈ​រាង៝ត់ នត្លើយ​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ផូង​អី​ញុប​ឞ្រាស​យេឆូ ​ញជុន​ពាង់​ហាន់​តា​ជៃ​កៃផាស ​អី​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់ ជេង​នតុក​មពោល​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​កោរាញ​ឞ្រី​យូដា ​គុ​រាគូម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ពេត្រោស ​តឹង​ឞ្រាស​យេឆូ ​ឞ្រោៈ​នទ៝ប់​ឞោក​មពើល​ឞោក នហ៝​មា​ត៝ត់​តា​ជ៝ង់​គូង​ជៃ​កោរាញ​ជាន​ឞ្រាស​អី​នៃ។ ពាង់​លាប់​គុ​នទ្រែល​មពោល​ឞូនុយ្ស​កើល​ជាន​ការ​តា​នតុក​នៃ គៃ​មា​អុច​គឹត​ម៝ស​នទើ​នាវ​គែស។ ");
INSERT INTO cmok_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ទឹង​លែៈ​ផូង​កោរាញ​ជាន​ការ​ផូង​អីឆ្រាអែល ​តឹម​ញច្រាៈ​ឞាល់​ជ៝យ​ឞូនុយ្ស​មា​តើម​នតោន​ងក្លាៈ​ឞ្រាស​យេឆូ ​គៃ​មា​តេៈ​ទោយ្ស​ងខឹត​លើយ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ជ៝យ​មោ​អោស​ទើយ​ឆៃ ឞ៝ល​លាស​គែស​អ៝ក់​ឞូនុយ្ស​ងើយ​ញចើត​មា​អោឞាល់​កាដោយ​ដ៝ង់។ ជេសរី​គែស​ឞារ​ហៃ​ឞូនុយ្ស​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ឞូនុយ្ស​អ្យា​លែៈ​លាស​កើត​នអា៖ «គ៝ប់​ទើយ​រើយ្ស​លើយ​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស ជេសរី​ជាន​ជេស​តៃ​ពែ​នារ​ទើម»”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ជេសរី​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់​ទ៝ក់​លាស​ឞ្រាស​យេឆូ ៖ “មើម​មៃ​មោ​អើស​នាវ​ឞូ​នតោន​មៃ​នៃ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","យើន​មា​ឞ្រាស​យេឆូ ​គុ​អ្យាត់​ឆាក់​រាក្លាក់។ ជេសរី​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់​នៃ​អោប​តៃ៖ “គ៝ប់​ដាៈ​មៃ​មឞើស​មា​ហេន​មា​នាវ​ត៝ន​តា​ឞើស​នាប់​កោរាញ​ឞ្រាស​អី​រេស​ងាន់៖ មៃ​ជេង​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​ងាន់ អី​ក៝ន​កោរាញ​ឞ្រាស​ងាន់​បាស?” ");
INSERT INTO cmok_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ឞ្រាស​យេឆូ ​អើស៖ “នាវ​មៃ​លាស​អី​រី​ទី​ងាន់ យើន​មា​គ៝ប់​មឞើស​ងក៝ច​មា​ខាន់​មៃ ទឹង​លែៈ​ខាន់​មៃ​មរា​ឆៃ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស គុ​ឞើស​មា​តី​កោរាញ​ឞ្រាស​នើម​អី​ទុត​នាវ​ទើយ‌ ជេសរី​ជុរ​ឞើស​ត្រោក​រី​ហាន់​រ៝ៈ​នទ៝រ់​តុក”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ជេស​តាង់​ពាង់​ងើយ​កើត​នៃ កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់​នៃ​ងខេក​ច្វីក​អាវ​ពាង់​នើម ជេសរី​លាស៖ “អ្វាញ់​លែៈ​ពាង់​មឺច​រាម៝ត​កោរាញ​ឞ្រាស! ឞ៝ន់​មោ​ហោម​អោស​ខាច់​ជ៝យ​ឞូនុយ្ស​តើម​ឆៃ​តើម​តាង់​អា​អេង​ជឹត។ លែៈ​ខាន់​មៃ​តាង់​ទាទេ​ជេស​នាវ​ព្រែ​មឺច​រាម៝ត​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","លាស​នទ្រី​មើម​ខាន់​មៃ​អុច​តេៈ​ទោយ្ស​មា​ពាង់?” ខាន់​ពាង់​អើស៖ “អ្យាត់​មា​តេៈ​ទោយ្ស​ងខឹត​ពាង់​រ៝!” ");
INSERT INTO cmok_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ជេសរី​ឞូ​ឆ៝ស​ទាក​ទីវ​តា​មុស​មាត់​ឞ្រាស​យេឆូ  ថុក​ពាង់​ថាក់​ពាង់ ឞូនុយ្ស​អាបាៈ​តាប​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","នអ៝ប់​មា​លាស​ពាង់៖ “អើ​ឞ្រាស​ក្រីស  លាស​មៃ​ឞ្រាស​ក្រីស ​ងាន់​មៃ​គឹត​ទឹង​លែៈ​នទើ លាស​នទ្រី​មៃ​មឞើស​មា​ហេន​ឞូ​ម៝ស​ថុក​មៃ!” ");
INSERT INTO cmok_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","នោក​នៃ​ពេត្រោស ​គុ​តា​ឞើស​ទីស​ជៃ​តា​ជ៝ង់​គូង។ គែស​ទូ​ហ្វេ​ឞូ​អូរ​ឆើម​កើល​ជាន​ការ​តា​នៃ​ហាន់​ទាច់​ពាង់ ជេសរី​អោប៖ “ងាន់​មៃ​ឞាល់​មពោល​ដាស​យេឆូ ​ត៝​អី​តាៈ​ឞើស​ឞ្រី​កាលីលេ ​ដ៝ង់!” ");
INSERT INTO cmok_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ពេត្រោស ​រាលាច់​លាស៖ “គ៝ប់​មោ​គឹត​អោស​ម៝ស​នាវ​អៃ​រែ​លាស​រី”។ ");
INSERT INTO cmok_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","នោក​ពេត្រោស ​ហាន់​គុ​អា​មែង​មពោង គែស​ទូ​ហ្វេ​ឞូ​អូរ​អា​អេង​ជឹត​ឆើម​កើល​ជាន​ការ​តា​នៃ​លាស​មា​ឞូ៖ “ពាង់​អ្យា​ដ៝ង់​គុ​នទ្រែល​យេឆូ ​ប៝ន​នាឆារែត !” ");
INSERT INTO cmok_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ពេត្រោស ​រាលាច់​តៃ​ទូ​តឹ​ជឹត​នអ៝ប់​មា​ត៝ន៖ “គ៝ប់​មោ​អោស​គឹត​នាល់​ឞូនុយ្ស​អី​នៃ!” ");
INSERT INTO cmok_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ទូ​ប្ល៝ត់​ជឹត​ផូង​អី​គុ​តា​នៃ​ហាន់​អា​ពាង់​លាស៖ “មៃ​អ្យា​ឞាល់​មពោល​ឞូនុយ្ស​អី​នៃ​ងាន់​រ៝ យ៝រ​លាស​នាវ​មៃ​ងើយ​តឹម​ឞាន​មា​នាវ​ងើយ​ឞូនុយ្ស​គុ​តា​ឞ្រី​កាលីលេ !” ");
INSERT INTO cmok_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ពេត្រោស ​លាស៖ “លាស​គ៝ប់​មរោស​គ៝ប់​រាតាប់​ឆាក់​គ៝ប់​នើម។ អ៝ន់​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​មា​គ៝ប់​ទោស។ គ៝ប់​មោ​គឹត​នាល់​ឞូនុយ្ស​អី​នៃ”។ ទោ​មា​អ្យារ់​នទ្រាវ។ ");
INSERT INTO cmok_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ជេសរី​ពេត្រោស ​នតើម​កាស​គឹត​នាវ​ឞ្រាស​យេឆូ ​លាស៖ “អេ​ល៝រ​មា​អ្យារ់​នទ្រាវ មៃ​រាលាច់​ពែ​តឹ​លាស​មោ​គឹត​នាល់​គ៝ប់”។ ជេសរី​ពាង់​លោស​អា​ទីស​ញុម​រាង៝ត​ហោ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ត៝ត់​អា​អោយ​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​មពោល​កោរាញ​ផូង​អីឆ្រាអែល  ខាន់​ពាង់​តឹម​ទី​ទូ​នតោរ​នាវ​អុច​ងខឹត​លើយ​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ខាន់​ពាង់​ក៝ត់​អោឞាល់​លែវ​ញជុន​អា​ពីលាត ​ឞូនុយ្ស​ប៝ន​រោម  អី​កោរាញ​ក្វ៝ង់​ម៝ត់​អ្វាញ់​ឞ្រី​យូដា ។ ");
INSERT INTO cmok_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","នោក​នៃ​យូដាស-​អីឆាការីយោត ​អី​នើម​លែវ​ឞូ​ហាន់​ញុប​ឞ្រាស​យេឆូ ​នើស​ឆៃ​ឞូ​តេៈ​ទោយ្ស​ឞ្រាស​យេឆូ  ពាង់​នទុយ្ស​តោរ​លាន់​តា​នូយ្ស​នហ៝ម់។ ពាង់​ឆ៝ៈ​ព្រាក់​អី ៣០ កាក់​រី​នើស​មព្លឹ​អ៝ន់​មា​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​កោរាញ​ផូង​អីឆ្រាអែល ‌ ");
INSERT INTO cmok_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ជេសរី​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​លែៈ​តីស​ញជុន​ឞូនុយ្ស​មោ​គែស​នាវ​តីស​អ៝ន់​ខាន់​មៃ​ងខឹត​ពាង់”។ ខាន់​ពាង់​អើស៖ “គឹត​អែស​មៃ! អី​នៃ​ជេង​នាវ​មៃ​នើម!” ");
INSERT INTO cmok_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","យូដាស-​អីឆាការីយោត ​មអារ់​មឞ្រាច​ព្រាក់​អី​នៃ​តា​ញីស​ជាន​ឞ្រាស ជេសរី​ទូ​លោស​ឞើស​នៃ​ហាន់​ងខឹត​យោង​ក៝​ឆាក់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","មពោល​កោរាញ​ជាន​ឞ្រាស​ទោញ​ព្រាក់​អី​នៃ ជេសរី​លាស៖ “ព្រាក់​អ្យា​ឞ៝ន់​មោ​អោស​ទី​តេៈ​តា​កែស​ព្រាក់​កោរាញ​ឞ្រាស យ៝រ​លាស​ព្រាក់​ខ្លៃ​មហាម”។ ");
INSERT INTO cmok_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ជេស​ខាន់​ពាង់​តឹម​ញច្រាៈ​រី ខាន់​ពាង់​ឆ៝ៈ​ព្រាក់​អី​នៃ​រាវាត់​មីរ​ឞូនុយ្ស​ម៝ន​គ្លាស​មា​អ៝ន់​ត៝ប់​ខឹត​ផូង​ឞូ​នាច់​អេង។ ");
INSERT INTO cmok_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","កើត​នទ្រី​ទឹង​ឞូ​ក្វាល់​នតុក​អី​នៃ​នហ៝​មា​ត៝ត់​នារ​អ្យា​លាស «មីរ​មហាម»។ ");
INSERT INTO cmok_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","នាវ​អី​នៃ​ជេង​ទី​ដាស​នាវ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​រាញា​យេរេមី ​លែៈ​ញចីស៖ «ឞូ​លែៈ​ឆ៝ៈ​ព្រាក់ ៣០ កាក់​អី​ផូង​អីឆ្រាអែល ​លែៈ​លាស​ខ្លៃ​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ជេសរី​ឞូ​ឆ៝ៈ​ព្រាក់​អី​នៃ​រាវាត់​នែស​ឞូនុយ្ស​ម៝ន​គ្លាស កើត​កោរាញ​ឞ្រាស​លែៈ​ដាៈ​ជេស​មា​គ៝ប់»។ ");
INSERT INTO cmok_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ឞ្រាស​យេឆូ ​ទ៝ក់​ឞើស​នាប់​កោរាញ​ក្វ៝ង់​ពីលាត ពីលាត ​អោប​ពាង់​កើត​នអា៖ “ងាន់​លាស​មៃ​កាដាច់​ផូង​អីឆ្រាអែល ​បាស?” ឞ្រាស​យេឆូ ​អើស៖ “អើ​កើត​នាវ​មៃ​លាស​នាវ​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","យើន​មា​នោក​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​មពោល​កោរាញ​ផូង​អីឆ្រាអែល ​នតោន​ឞ្រាស​យេឆូ ពាង់​មោ​អើស​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ពីលាត ​លាស​ពាង់៖ “មៃ​មោ​តាង់​បាស ទឹង​លែៈ​នាវ​ខាន់​ពាង់​នតោន​មៃ​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ពាង់​មោ​អើស​អោស ទូ​ត៝ង​ពាង់​មោ​អើស​ដ៝ង់ នហ៝​មា​ត៝ត់​កោរាញ​ក្វ៝ង់​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","តឹម​អាប់​នាម់​ញេត​បុន​នហ៝ត កោរាញ​ក្វ៝ង់​អី​នៃ​វៃ​មអើក​ទូ​ហ្វេ​ឞូនុយ្ស​ទោយ្ស​តឹង​ផូង​ប៝ន​លាន​ទាន់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","នោក​នៃ​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ទោយ្ស​ឞូ​លឺ​គុ​នទ្រូង រាញា​ពាង់​បារាបាស ។ ");
INSERT INTO cmok_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ជេស​ផូង​ប៝ន​លាន​តឹម​រាគូម​ឞាល់ ពីលាត ​អោប​ខាន់​ពាង់៖ “ឞូ​ម៝ស​ខាន់​អៃ​មៃ​អុច​អ៝ន់​គ៝ប់​មអើក? មអើក​បារាបាស  មោ​លាស​យេឆូ ​អី​ឞូ​ក្វាល់​ឞ្រាស​ក្រីស ?” ");
INSERT INTO cmok_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ពាង់​លាស​កើត​នៃ យ៝រ​មា​ពាង់​លែៈ​គឹត​ជេស​នូយ្ស​នហ៝ម់​មពោល​កោរាញ​ជាន​ឞ្រាស​មោ​នាច នទ្រី​ទឹង​ខាន់​ពាង់​ញជុន​ឞ្រាស​យេឆូ ​អ៝ន់​មា​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","នោក​ពីលាត ​ហោម​គុ​តា​នតុក​ផាត​ទោយ្ស​នៃ អូរ​ពាង់​ដាៈ​ឞូ​ហាន់​មឞើស​មា​ពាង់៖ “លើយ​អោស​ជាន​មា​ឞូនុយ្ស​អី​នៃ ពាង់​មោ​អោស​គែស​នាវ​តីស។ យ៝រ​មា​ឞូនុយ្ស​អី​នៃ​មាង់​ត៝​នើស​គ៝ប់​មឞើយ​អ្យើស​ហោ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","យើន​មា​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​មពោល​កោរាញ​ផូង​អីឆ្រាអែល ​ញច៝ប់​ប៝ន​លាន​ទាន់​មអើក​បារាបាស  ជេសរី​ទាន់​ងខឹត​លើយ​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","កោរាញ​ក្វ៝ង់​ពីលាត ​អោប​ខាន់​ពាង់​ទូ​តឹ​ជឹត៖ “ឞារ​ហៃ​ខាន់​ពាង់​អ្យា ឞូ​ម៝ស​ខាន់​អៃ​មៃ​អុច​អ៝ន់​គ៝ប់​មអើក?” ខាន់​ពាង់​អើស៖ “បារាបាស !” ");
INSERT INTO cmok_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ពីលាត ​អោប​តៃ​ខាន់​ពាង់៖ “លាស​នទ្រី​យេឆូ ​អី​ឞូ​ក្វាល់​ឞ្រាស​ក្រីស ​អ្យា មើម​ខាន់​អៃ​មៃ​អុច​អ៝ន់​គ៝ប់​ជាន?” ទឹង​លែៈ​ខាន់​ពាង់​នតែរ​ទ្រើវ៖ “ងខឹត​ពាង់​តា​ឆី​តឹម​រាកាង់!” ");
INSERT INTO cmok_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ពីលាត ​អោប​តៃ​លាស៖ “ឞូនុយ្ស​អ្យា​ម៝ស​នាវ​អ្យើស​ពាង់​លែៈ​ជាន?” ផូង​ប៝ន​លាន​នតែរ​ទ្រើវ​លើ​មា​ហោ​លាស៖ “ដាៈ​ឞូ​ងខឹត​ពាង់​តា​ឆី​តឹម​រាកាង់!” ");
INSERT INTO cmok_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ពីលាត ​គឹត​ពាង់​នើម​មោ​ហោម​ទើយ ឆៃ​ប៝ន​លាន​អុស​អាស​លើ​មា​ហោ​ដ៝ង់។ ជេសរី​ពាង់​ឆ៝ៈ​ទាក​រាវ​តី​តា​នាប់​ផូង​ឞូនុយ្ស​អ៝ក់ នហ៝​មា​លាស៖ “នាវ​អ្យា​ទុត​តា​ខាន់​អៃ​មៃ​នើម​យឹ គ៝ប់​មោ​អោស​គែស​ទោយ្ស​ដាស​ងខឹត​ឞូនុយ្ស​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ទឹង​លែៈ​ផូង​ប៝ន​លាន​អើស​ទ្រើវ៖ “លាស​ពាង់​មោ​គែស​នាវ​តីស អ៝ន់​ទោយ្ស​អី​នៃ​តុប​តា​ហេន​នើម នទ្រែល​មា​ក៝ន​ឆៅ​ហេន​នើម​មហាម​ពាង់​អី​នៃ!” ");
INSERT INTO cmok_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","អាច​មា​ពីលាត ​អុច​ជាន​តឹង​នាវ​ផូង​ប៝ន​លាន​ទាន់​នើស ពាង់​មអើក​លើយ​បារាបាស ។ ជេសរី​ពាង់​ដាៈ​តាហែន​រាពាត់​ឞ្រាស​យេឆូ ​មា​ម៝ង់​រាឆែ នហ៝​មា​ជាវ​អ៝ន់​តាហែន​ងខឹត​អោឞាល់​តា​ឆី​តឹម​រាកាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ផូង​តាហែន​កោរាញ​ក្វ៝ង់​ពីលាត ​លែវ​ឞ្រាស​យេឆូ ​ហាន់​លាប់​តា​ជ៝ង់​គូង​ញីស​កោរាញ​ក្វ៝ង់​នៃ ជេសរី​ទឹង​លែៈ​តាហែន​តា​នៃ​គុ​ជុម​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ខាន់​ពាង់​ទ្រ៝ស​លើយ​ឞ៝ក​អាវ​អោឞាល់ ជេសរី​ឆ៝ៈ​អាវ​ចាង់​ក្វ៝ង់​អី​តឹម​ឞាន​មា​អាវ​កាដាច់​ញឆ៝ស​តា​អោឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ខាន់​ពាង់​ឆ៝ៈ​រាតាវ​ល៝ក​បារ់​ជាន​មោក​កាដាច់​នទោ​តា​ឞោក​ឞ្រាស​យេឆូ ​រី នទ្រែល​មា​ឆ៝ៈ​ម៝ង់​ជាន​ម៝ង់​កាដាច់​អ៝ន់​តី​ឞើស​មា​ពាង់​ក្វាន់ ជេសរី​ច៝ន​កោម៝ក់​មឞាស​មឺច​រាម៝ត​អោឞាល់​នហ៝​មា​លាស៖ “ហើយ​កាដាច់​ផូង​អីឆ្រាអែល ! ហេន​យើក​មៃ!” ");
INSERT INTO cmok_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ខាន់​ពាង់​រាឆ៝ស​ទាក​ទីវ​តា​អោឞាល់ នទ្រែល​មា​ឆ៝ៈ​ម៝ង់​អី​នៃ​មឞាង​ឞោក​អោឞាល់​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ជេស​មឺច​រាម៝ត​មា​អោឞាល់​កើត​នទ្រី ជេសរី​តាហែន​ទ្រ៝ស​លើយ​អាវ​អី​នៃ​ឞើស​ឆាក់​ពាង់ ព្លឹ​ញឆ៝ស​តៃ​អាវ​ពាង់​នើម​នើស ជេសរី​តេក​លែវ​អោឞាល់​អា​នតុក​ឆី​តឹម​រាកាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","នោក​លោស​ឞើស​ប៝ន ផូង​តាហែន​ម៝ប់​ទូ​ហ្វេ​ឞូ​ក្លោ​រាញា​ពាង់​ឆីមោន ​តាៈ​ឞើស​ប៝ន​ក្វ៝ង់​កីរេន  ឞូ​ដាៈ​អោឞាល់​តូយ​ឆី​តឹម​រាកាង់​ឞ្រាស​យេឆូ  ");
INSERT INTO cmok_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ត៝ត់​តា​ទូ​នតុក​រាញា​«កោលកោថា » រាឞ្លាង​លាស «នតុក​នតីង​ឞោក»។ ");
INSERT INTO cmok_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ជេសរី​ឞូ​ឆ៝ៈ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​លាយ​ដាស​ទាក​ព្លៃ​មាត់​តាង់​ងាន់​អ៝ន់​ឞ្រាស​យេឆូ ​ញេត ជេស​ពាង់​ច្យាម់​ដេៈ ពាង់​មោ​អុច​ញេត​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ជេស​ឞូ​ព៝ង់​អោឞាល់​តា​ឆី​តឹម​រាកាង់ ឞូ​តឹម​ពាៈ​ឞ៝ក​អាវ​ពាង់​មា​នទើ​ញច្រ៝ស។ ");
INSERT INTO cmok_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ខាន់​ពាង់​គុ​រើប​គើប​តា​នៃ​ញជ្រាង់​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","តា​កាលើ​ឞោក​ឞ្រាស​យេឆូ ​រី ខាន់​ពាង់​ព្លា​ទូ​រាលាត​កាដារ​ញចីស​មឞើស​ងក៝ច​នាវ​ឞូ​នតោន​ពាង់ លាស​កើត​នអា៖ «អ្យា​រាញា​យេឆូ  កាដាច់​ផូង​អីឆ្រាអែល »។ ");
INSERT INTO cmok_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","នោក​នៃ​ឞូ​ងខឹត​នទ្រែល​ឞ្រាស​យេឆូ ​ឞារ​ហៃ​ឞូនុយ្ស​នតុង​ដ៝ង់ អី​ទូ​ហ្វេ​អ៝ន់​ឞើស​មា​ពាង់ ទូ​ហ្វេ​ជឹត​អ៝ន់​ឞើស​ច្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","លែៈ​ឞូនុយ្ស​អី​ឞ្រោៈ​រ៝ៈ​នៃ ងគ្រើស​ងគ្រាប់​រាតែស​ឞោក​រុល​ទុល​មឺច​មា​អោឞាល់ ");
INSERT INTO cmok_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","នហ៝​មា​លាស៖ “ហើយ​ឞូនុយ្ស​អី​លាស​រើយ្ស​លើយ​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស ជាន​តៃ​អី​មហែ​ពែ​នារ​ជេស។ លាស​នទ្រី​រាក្លាយ្ស​អេង​ឆាក់​មៃ​នើម លាស​មៃ​ក៝ន​កោរាញ​ឞ្រាស​ងាន់ ជុរ​ឞើស​ឆី​តឹម​រាកាង់​នៃ​ហ៝ម់!” ");
INSERT INTO cmok_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","មពោល​កោរាញ​ជាន​ឞ្រាស ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​មពោល​កោរាញ​ផូង​អីឆ្រាអែល ​លែវ​ឞាល់​ងើយ​ងគ្រើស​មា​ពាង់​កើត​នៃ​ដ៝ង់ ខាន់​ពាង់​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ពាង់​ទើយ​កើល​អ៝ក់​ឞូ​អាបាៈ​អេង តីស​មា​មោ​អោស​ទើយ​រាក្លាយ្ស​ឆាក់​ពាង់​នើម! លាស​ពាង់​អី​កាដាច់​ផូង​អីឆ្រាអែល ​ងាន់ អ៝ន់​ពាង់​ជុរ​ឞើស​ឆី​តឹម​រាកាង់​អាបៃ​អ្យា ជេសរី​ហេន​អ្យាត់​មា​ពាង់​ដ៝ង់! ");
INSERT INTO cmok_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ពាង់​លែៈ​ញឆីង​មា​កោរាញ​ឞ្រាស លាស​កោរាញ​ឞ្រាស​អុច អ៝ន់​កោរាញ​ឞ្រាស​រាក្លាយ្ស​ពាង់​អាបៃ​អ្យា​រ៝ យ៝រ​លាស​ពាង់​លាស៖ «គ៝ប់​អី​ក៝ន​កោរាញ​ឞ្រាស»”។ ");
INSERT INTO cmok_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ឞ៝ល​លាស​ឞារ​ហៃ​ឞូនុយ្ស​នតុង​អី​ឞូ​ងខឹត​នទ្រែល​ឞ្រាស​យេឆូ ​តា​រី មឺច​រាម៝ត​អោឞាល់​កើត​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","នតើម​ឞើស​នារ​ងក្លាង​ឞោក​លាម​ឞ្រី​ទាក​អី​នៃ​ត្រោក​គែស​ង៝​ទាទេ នហ៝​មា​ត៝ត់​ម៝ង​ពែ​កេង​មាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ក្លាប់​លាស​តា​ម៝ង​ពែ​កេង​មាង់ ឞ្រាស​យេឆូ ​នតែរ​ទុត​ទាង់​តា​នាវ​ងើយ​ហេឞ្រើ ៖ “អេលី! អេលី! លាមា​ឆាបាច់​ថានី ?” រាឞ្លាង​នាវ​នៃ៖ «អើ​កោរាញ​ឞ្រាស​គ៝ប់​អើយ! អើ​កោរាញ​ឞ្រាស​គ៝ប់​អើយ! ម៝ស​នាវ​មៃ​នត្លើយ​គ៝ប់?» ");
INSERT INTO cmok_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ឞូ​បាបាៈ​អី​គុ​តា​នៃ​តាង់​នាវ​ពាង់​នតែរ​នើស​វ៝ត់​វិ ឞូ​លាស៖ “ពាង់​ក្វាល់​អេលីយា ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ឞើស​កាល់​អែ​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ទោ​មា​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​តា​ផូង​ខាន់​ពាង់​ញច្វាត់​ឆ៝ៈ​ឞ៝ក​យុក​តា​ទាក​ឆ្រាត​ពូត​តា​ចោង​ម៝ង់​នទឹ​អ៝ន់​ពាង់​ញេត។ ");
INSERT INTO cmok_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","យើន​មា​ឞូនុយ្ស​អាបាៈ​លាស៖ “ក៝ប់​អ្វាញ់​ប៝ត់ គឹត​អេលីយា ​ហាន់​រាក្លាយ្ស​ពាង់​មោ​លាស​មោ”។ ");
INSERT INTO cmok_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ជេសរី​ឞ្រាស​យេឆូ ​នតែរ​តៃ​ទុត​ទាង់ នហ៝​មា​រ៝ស​នហ៝ម់​ក្ល៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","តា​ម៝ង​នៃ​ឞ៝ក​អី​ញចីង​តា​មពោង​ជ្រោ​ទុត​ក្ល៝ស​អ្វែស​តា​ត្រោម​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស ទោ​មា​ហេក​ច្វីក​ជេង​ឞារ នតើម​ឞើស​លើ​នហ៝​មា​ត៝ត់​អា​ទ៝ង់ នែស​នតូ​ងគារ់ លុ​ក្លេរ​ដាង។ ");
INSERT INTO cmok_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","នតូ​មោច​ពើក​ឞ៝ង់​រឺក​បឺក ខឹត​ផូង​ឞូនុយ្ស​ក្ល៝ស​អ្វែស​អ៝ក់​អី​វៃ​គុ​ឆ៝ង់​តា​ឞើស​នាប់​កោរាញ​ឞ្រាស​ទ៝ក់​រេស។ ");
INSERT INTO cmok_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ជេស​ឞ្រាស​យេឆូ ​ទ៝ក់​រេស ផូង​ខាន់​ពាង់​លោស​ឞើស​នតូ​មោច លាប់​តា​ប៝ន​យេរូឆាលឹម ​អី​ប៝ន​ក្ល៝ស​អ្វែស ញហើ​អ៝ន់​អ៝ក់​ឞូនុយ្ស​ឆៃ។ ");
INSERT INTO cmok_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","នោក​កោរាញ​តាហែន​រោម  នទ្រែល​មា​ផូង​តាហែន​ក៝ប់​ញជ្រាង់​ឞ្រាស​យេឆូ ​តា​នៃ ឆៃ​ងគារ់​នែស​នតូ នទ្រែល​មា​ឆៃ​ទឹង​លែៈ​នាវ​គែស​កើត​នៃ ខាន់​ពាង់​ក្លាច​ញឆ៝រ់​ហោ​ងាន់ ជេសរី​លាស៖ “ឞូ​ក្លោ​អ្យា​អី​ក៝ន​កោរាញ​ឞ្រាស​ងាន់​យា!” ");
INSERT INTO cmok_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","តា​នតុក​នៃ​គែស​អ៝ក់​ឞូ​អូរ​អី​តឹង​ឞ្រាស​យេឆូ ​តាៈ​ឞើស​ឞ្រី​កាលីលេ  អី​កើល​ពាង់​ដ៝ង់ ខាន់​ពាង់​គុ​អ្វាញ់​ពាង់​ទឹង​លែៈ​នាវ​អី​នៃ​ឞើស​ងាយ។ ");
INSERT INTO cmok_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","តា​នៃ​គែស​មារី ​តាៈ​ឞើស​ប៝ន​មាដាលា មារី ​អី​មេៈ​យាកើ យោឆែប  ជេសរី​គែស​នអ៝ប់​មា​អី​មេៈ​យាកោប យោហាន ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ត៝ត់​កេង​មាង់​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​នទ្រ៝ង់​រាញា​ពាង់​យោឆែប  តាៈ​ឞើស​ប៝ន​អារីមាថេ  ពាង់​ជេង​មពោល​អ៝ស​ម៝ន​ឞ្រាស​យេឆូ ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ពាង់​ហាន់​ម៝ប់​ពីលាត ​ទាន់​ឆ៝ៈ​ឆាក់​ជាន់​ឞ្រាស​យេឆូ ពីលាត ​ដាៈ​ឞូ​អ៝ន់​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ជេសរី​ពាង់​ឆ៝ៈ​ឆាក់​ជាន់​ឞ្រាស​យេឆូ ​ពូត​ដាស​ឞ៝ក​លាយ្ស​ក្ល៝ស​ងលាង។ ");
INSERT INTO cmok_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ពាង់​ញជ៝រ​ឆាក់​ឞ្រាស​យេឆូ ​នៃ​តា​ត្រោម​នតូ​មោច​មហែ នតូ​អី​ពាង់​លែៈ​ដាៈ​ឞូ​លោក​តា​លុ​ក្លេរ​មា​នទ្រាប់​មា​ឆាក់​ពាង់​នើម។ ជេសរី​ពាង់​រាលាៈ​ទូ​មល៝ម់​លុ​ក្វ៝ង់​រាទ៝ល់​ត្រោម​មោច​រី ពាង់​នើម​ឆឹត​យ៝ត​ក្លាក់។ ");
INSERT INTO cmok_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","មារី ​តាៈ​ឞើស​ប៝ន​មាដាលា  នទ្រែល​មា​មារី ​ទូ​ហ្វេ​អេង​ជឹត​គុ​តា​នៃ​ដ៝ង់ ខាន់​ពាង់​គុ​តឹម​ឆ៝ង់​មពោង​មោច​រី។ ");
INSERT INTO cmok_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ត៝ត់​អោយ​តៃ​រី តា​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល  មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​ផារីឆី ​ខាន់​ពាង់​លែវ​ឞាល់​ហាន់​ម៝ប់​ពីលាត  ");
INSERT INTO cmok_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","មឞើស​មា​ពាង់៖ “អើ​កោរាញ ហេន​ហោម​កាស​គឹត​នាវ​ឞូនុយ្ស​មរោស​អី​នៃ​លាស​នោក​ពាង់​ហោម​រេស​នើស៖ «ជេស​គ៝ប់​ខឹត ត៝ត់​ពែ​នារ​គ៝ប់​ទ៝ក់​រេស​តៃ»។ ");
INSERT INTO cmok_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","លាស​នទ្រី​ទាន់​កោរាញ​ដាៈ​តាហែន​អ៝ន់​ញជ្រាង់​ងាន់​មោច​អី​នៃ​អ៝ន់​លោច​ពែ​នារ។ ក្លាច​លាស​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​ឆ៝ៈ​នតុង​ឆាក់​ពាង់​នៃ ជេសរី​មឞើស​ងក៝ច​មា​ផូង​ប៝ន​លាន​លាស​ពាង់​លែៈ​ទ៝ក់​រេស។ លាស​នទ្រី​នាវ​មរោស​អាបៃ​អ្យា​អ្យើស​រាលាវ​មា​ឞើស​កើយ​នើស​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ពីលាត ​លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ឆ៝ៈ​តាហែន ដាៈ​ឞូ​ញជ្រាង់​ងាន់​អ៝ន់​ទុត​អ្វែស​ទោ ទាស​អុច​ខាន់​មៃ​នើម!” ");
INSERT INTO cmok_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ជេសរី​ខាន់​ពាង់​ហាន់​អា​មោច ញជឹរ​នតូ​មោច​ព្លា​នទើ​វែរ​កាលើ​ជឹត​គៃ​មា​លើយ​អ៝ន់​ឞូ​លាប់ នទ្រែល​មា​អ៝ន់​តាហែន​គុ​ញជ្រាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ជេស​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល  អើម​អោយ​នារ​ង្វាយ​តា​ពើស​អី​នៃ មារី ​ឞើស​ប៝ន​មាដាលា  នទ្រែល​មា​មារី ​អី​ទូ​ហ្វេ​អេង​ជឹត ខាន់​ពាង់​លែវ​ឞាល់​ហាន់​អា​មោច។ ");
INSERT INTO cmok_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","នោក​នៃ​ទោ​មា​គែស​ងគារ់​នែស​ទុត​ហោ យ៝រ​លាស​គែស​តោង​ពារ់​កោរាញ​ឞ្រាស​ជុរ​តាៈ​ឞើស​ត្រោក​អី​នតុក​កោរាញ​ឞ្រាស​នើម ងក្លឹ​លើយ​លុ​ឞើស​ឞ៝រ់​មោច​នៃ ជេសរី​គុ​រាគើប​តា​កាលើ​លុ​អី​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","អ្វាញ់​ពាង់​រីល​តឹម​ឞាន​មា​លើប​ងលាយ្ស ឞ៝ក​អាវ​ពាង់​ងលាង​តឹម​ឞាន​មា​មលី។ ");
INSERT INTO cmok_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ផូង​តាហែន​អី​គុ​ញជ្រាង់​មោច​តា​នៃ​ក្លាច​ញឆ៝រ់​ហោ​ងាន់ នហ៝​មា​ចោត​ខឹត​យើស។ ");
INSERT INTO cmok_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","យើន​មា​តោង​ពារ់​លាស​មា​មពោល​ឞូ​អូរ​អី​រី៖ “ខាន់​អៃ​លើយ​ក្លាច​អោស! គ៝ប់​លែៈ​គឹត​ជេស​ខាន់​អៃ​ហាន់​ជ៝យ​ឞ្រាស​យេឆូ ​អី​ឞូ​ងខឹត​តា​ឆី​តឹម​រាកាង់​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ពាង់​មោ​ហោម​អោស​តា​អ្យា យ៝រ​លាស​កោរាញ​ឞ្រាស​រាទ៝ក់​អ៝ន់​ទ៝ក់​រេស​តៃ កើត​នាវ​ពាង់​លែៈ​ងក៝ច​នើស។ ហាន់​អ្វាញ់​ហ៝ម់​តា​នតុក​ឞូ​ញជ៝រ​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ជេសរី​ហាន់​គើញ​អា​មពោល​អ៝ស​ម៝ន​ពាង់​រី មឞើស​អ៝ន់​ខាន់​ពាង់​គឹត​កោរាញ​ឞ្រាស​លែៈ​រាទ៝ក់​ពាង់​អ៝ន់​ទ៝ក់​រេស អាបៃ​អ្យា​ពាង់​ហាន់​ល៝រ​ខាន់​អៃ​មៃ​តា​ឞ្រី​កាលីលេ ​រី។ តា​នតុក​នៃ​ខាន់​អៃ​មៃ​ឆៃ​ពាង់។ នទ្រី​នាវ​គ៝ប់​មឞើស​មា​ខាន់​អៃ​យឹ!” ");
INSERT INTO cmok_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ជេសរី​ខាន់​ពាង់​ហាន់​រ៝​តាៈ​ឞើស​មោច​នៃ​នអ៝ប់​មា​គែស​នាវ​ក្លាច​គែស​នាវ​រាម់​ហោ​ងាន់ ខាន់​ពាង់​ញច្វាត់​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អី​នៃ​មា​មពោល​អ៝ស​ម៝ន​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ទោ​មា​ឞ្រាស​យេឆូ ​ហាន់​ម៝ប់​ខាន់​ពាង់​អោប​ខាន់​ពាង់៖ “អ្វែស​លាង់​ខាន់​អៃ!” ជេសរី​ខាន់​ពាង់​រាន​ទាច់​ឞ្រាស​យេឆូ ​ពាន់​តា​នែស​ក្វាន់​តា​ជ៝ង់​ឞ្រាស​យេឆូ ​រី យើក​មឞាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “លើយ​ក្លាច​អោស! ខាន់​អៃ​ហាន់​មឞើស​ងក៝ច​មា​មពោល​អ៝ស​នោ​គ៝ប់ អ៝ន់​ខាន់​ពាង់​ហាន់​តា​ឞ្រី​កាលីលេ ​រី តា​នតុក​នៃ​ខាន់​ពាង់​ឆៃ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ទោល​ផូង​ឞូ​អូរ​នៃ​ហាន់​រ៝ៈ​ត្រ៝ង គែស​ផូង​តាហែន​អី​ញជ្រាង់​មោច​នៃ​នើស​អាបាៈ​លាប់​តា​ប៝ន មឞើស​ងក៝ច​ទឹង​លែៈ​នាវ​គែស​អី​នៃ​នើស​អ៝ន់​មា​មពោល​កោរាញ​ជាន​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","មពោល​កោរាញ​ជាន​ឞ្រាស តឹម​ម៝ប់​តឹម​ញច្រាៈ​ដាស​មពោល​កោរាញ​ផូង​អីឆ្រាអែល  ខាន់​ពាង់​តឹម​ទី​ទូ​នតោរ​នាវ​អ៝ន់​ព្រាក់​អ៝ក់​ងាន់​មា​ផូង​តាហែន‌ ");
INSERT INTO cmok_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","នហ៝​មា​នតុម​ខាន់​ពាង់​កើត​នអា៖ “អ៝ន់​ខាន់​មៃ​លាស៖ «នទុត​ហេន​ហាក់​ឞិច​គែស​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​អា​មាង់​ឆ៝ៈ​នតុង​ឆាក់​ពាង់»។ ");
INSERT INTO cmok_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","លាស​កោរាញ​ក្វ៝ង់​ពីលាត ​គឹត​នាវ​អ្យា ហេន​មរា​មឞើស​មា​ពាង់។ ខាន់​មៃ​មោ​ច្រាវ​អោស​គែស​ទោយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ជេសរី​ខាន់​ពាង់​ឆ៝ៈ​ទើន​ព្រាក់​អី​នៃ ជាន​កើត​នាវ​ឞូ​ដាៈ​មា​ខាន់​ពាង់។ នាវ​អី​នៃ​គឹត​លឺ​លាម​ផូង​អីឆ្រាអែល  នហ៝​មា​ត៝ត់​នារ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ជេសរី ១១ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​ហាន់​តា​ឞ្រី​កាលីលេ  ត៝ត់​តា​យោក​នតុក​ឞ្រាស​យេឆូ ​លែៈ​មឞើស​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ត៝ត់​ខាន់​ពាង់​ឆៃ​ឞ្រាស​យេឆូ  ខាន់​ពាង់​យើក​មឞាស​មា​ពាង់ យើន​មា​គែស​ឞូនុយ្ស​អាបាៈ​ហោម​អែ​វិ​វែៈ​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ឞ្រាស​យេឆូ ​ហាន់​តា​ខាន់​ពាង់ ជេសរី​លាស​មា​ខាន់​ពាង់៖ “លែៈ​នាវ​ទើយ​តា​ត្រោក នអ៝ប់​មា​តា​នែស​នតូ​លែៈ​ឞឹ​អ៝ន់​ជេស​មា​គ៝ប់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","លាស​នទ្រី​ហាន់​ហ៝ម់​អាប់​នទុល​មពោល​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា ញជេង​ខាន់​ពាង់​ជេង​អ៝ស​ម៝ន​គ៝ប់ ជេសរី​ជាន​បាប់តែម​យុក​ខាន់​ពាង់​មា​ទាក តា​រាញា​ឞឹ តា​រាញា​គ៝ប់​អី​ក៝ន​ពាង់ នទ្រែល​មា​តា​រាញា​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស។ ");
INSERT INTO cmok_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ជេសរី​នតុម​នតី​អ៝ន់​ខាន់​ពាង់​អ្យាត់​ទឹង​លែៈ​នាវ​គ៝ប់​លែៈ​ដាៈ​មា​ខាន់​មៃ​នើស។ អ៝ន់​ហោម​កាស​គឹត​នឹង៖ គ៝ប់​ហោម​អែ​គុ​នឹង​នទ្រែល​ខាន់​មៃ​នហ៝​មា​ត៝ត់​នារ​លោច​នែស​នតូ​អ្យា”៕៚");
INSERT INTO cmok_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","អ្យា​នតើម​នាវ​មហែ​មហាន​អ្វែស​មា​ឞ្រាស​យេឆូ​ក្រីស ​អី​ក៝ន​កោរាញ​ឞ្រាស​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","តា​ឆ៝ម់បុត​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស រាញា​អេឆាយ ​លែៈ​ញចីស​លាស៖ «កោរាញ​ឞ្រាស​លាស៖ «អ្វាញ់​យឹ គ៝ប់​ដាៈ​ទូ​ហ្វេ​ឞូនុយ្ស​ហាន់​ល៝រ​នទ្រាប់​នូយ្ស​នហ៝ម់​ឞូនុយ្ស​អ៝ន់​មៃ តឹម​ឞាន​ឞូ​ក្វាយ្ស​ត្រ៝ង មឞើស​មា​ឞូ​មៃ​ហាន់​ឞើស​កើយ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ឞូនុយ្ស​អី​នៃ​នតែរ​តា​ឞ្រី​រាទាស​លាស៖ «នទ្រាប់​ហ៝ម់​នូយ្ស​នហ៝ម់​អ៝ន់​មា​កោរាញ​ឞ្រាស តឹម​ឞាន​មា​ឞូនុយ្ស​ក្វាយ្ស​ត្រ៝ង‌ ញឆ៝ង់​ត្រ៝ង​អ៝ន់​មា​កាដាច់​ហាន់»»»។ ");
INSERT INTO cmok_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","នទ្រី​នាវ​ងក៝ច​អី​នៃ​លែៈ​ត៝ត់​ហើយ គែស​ទូ​ហ្វេ​ឞូនុយ្ស​រាញា​យោហាន ​គុ​តា​ឞ្រី​រាទាស ពាង់​មឞើស​ងក៝ច​មា​ប៝ន​លាន​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស នហ៝​មា​ទើន​នាវ​យុក​មា​ទាក អី​ឞូ​ក្វាល់​«បាប់តែម» គៃ​មា​ញហើ​ខាន់​ពាង់​អុច​តឹង​នាវ​កោរាញ​ឞ្រាស នទ្រី​ទឹង​កោរាញ​ឞ្រាស​យោៈ​នអាច​មោ​ហោម​អោស​កើប​នាវ​តីស​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","គែស​អ៝ក់​ឞូនុយ្ស​តា​ឞ្រី​យូដា  នទ្រែល​មា​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​ហាន់​រាន​អា​ពាង់​ទាទេ។ ខាន់​ពាង់​គឹត​ឆាក់​ខាន់​ពាង់​នើម​តីស​មឞើស​រ៝ ជេសរី​យោហាន ​ជាន​បាប់តែម​យុក​ខាន់​ពាង់​មា​ទាក​តា​ទាក​រាលាយ​យោរដាន់ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ល៝ង់​យោហាន ​ពាង់​ញឆ៝ស​អាវ​ជ៝ង​ជាន​មា​រាឆៅ​ឆែស​ឆាមោ វាន់​រាឆែ​ឞុត​ជាន​មា​នតោ ពាង់​ឆា​ក្រាស​នទ្រាច​ដាស​ទាក​ឆុត។ ");
INSERT INTO cmok_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ពាង់​មឞើស​ងក៝ច​មា​ផូង​ប៝ន​លាន៖ “គែស​ទូ​ហ្វេ​កោរាញ ពាង់​ហាន់​ឞើស​កើយ​គ៝ប់​ឞើយ​មា​ត៝ត់​ជេស ពាង់​គែស​នាវ​ទើយ​រាលាវ​គ៝ប់​ងាន់។ តា​នាប់​ពាង់​គ៝ប់​ជេង​ឞូនុយ្ស​ជេៈ​លេៈ​ទើម ឞ៝ល​លាស​គ៝ប់​កុញ​ឆើម​ទ្រ៝ស​នតោ​ជ៝ត​ពាង់ ហោម​អែ​មោ​ហ៝ៈ​ទី​ដាស​នាវ​ជាន​ការ​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","គ៝ប់​ជាន​បាប់តែម​អ៝ន់​ខាន់​អៃ​មៃ​យុក​មា​ទាក​ទើម ល៝ង់​ពាង់​អី​នៃ​ជាន​បាប់តែម​អ៝ន់​ខាន់​អៃ​មៃ​មា​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស”។ ");
INSERT INTO cmok_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ត៝ត់​នារ​ឞើស​កើយ​ឞ្រាស​យេឆូ ​អី​តាៈ​ឞើស​ប៝ន​នាឆារែត ​ឞ្រី​កាលីលេ ​ពាង់​ហាន់​ត៝ត់​តា​នតុក​យោហាន ​ជាន​បាប់តែម​នៃ ជេសរី​យោហាន ​ជាន​បាប់តែម​មា​ឞ្រាស​យេឆូ ​យុក​មា​ទាក​តា​ទាក​រាលាយ​យោរដាន់ ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ជេស​យុក​ពាង់​តា​ទាក​រី លោស​ប្លូ​ឞើស​ទាក​រី ឞ្រាស​យេឆូ ​ឆៃ​ត្រោក​ពើក​ឞ៝ង់​លាហឺរ ជេសរី​គែស​ឞ្រាស​ហ្វេង​អ្វែស​ជុរ​ទ្រ៝ម់​តា​ពាង់​អ្វាញ់​តឹម​ឞាន​មា​ព្លុក។ ");
INSERT INTO cmok_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ទោល​នៃ​គែស​តាង់​នតែស​ឞ៝រ់​តាៈ​ឞើស​កាលើ​ត្រោក​លាស៖ “មៃ​អី​ក៝ន​គ៝ប់​រ៝ង់ គ៝ប់​រាម់​រាហើន​មៃ​ហោ​ងាន់​ងេន”។ ");
INSERT INTO cmok_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ជេស​ឞើស​នៃ​ឞ្រាស​ហ្វេង​អ្វែស​ដាៈ​ឞ្រាស​យេឆូ ​ទូ​ហាន់​អា​ឞ្រី​រាទាស។ ");
INSERT INTO cmok_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ពាង់​គុ​តា​នតុក​នៃ ៤០ នាង់ ៤០ នារ គែស​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​នទើម​ពាង់​ដ៝ង់។ ពាង់​គុ​នទ្រែល​មពោមពា​(ឆ្យុម)​ឞ្រី​តា​នតុក​នៃ គែស​មពោល​តោង​ពារ់​ឆើម​កើល​ជាន​ការ​មា​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","លែៈ​ជេស​ឞូ​ញុប​យោហាន-​បាប់តែម ​ក្រុង​តា​នទ្រូង ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​តា​ឞ្រី​កាលីលេ ​នហ៝​មា​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ពាង់​លាស៖ “ម៝ង​លែៈ​ត៝ត់​ជេស នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​អៃ​មៃ​លែៈ​ទាច់​ងាន់​រ៝។ លាស​នទ្រី​រាគ៝ល់​ហ៝ម់​នូយ្ស​នហ៝ម់​អ្យើស​ខាន់​អៃ​មៃ ជេសរី​ញឆីង​មា​នាវ​មហែ​មហាន​អ្វែស​អ្យា​ទោ!” ");
INSERT INTO cmok_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","គែស​ទូ​នារ​រី​ឞ្រាស​យេឆូ ​ហាន់​ឞ្រោៈ​រ៝ៈ​មែង​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ ពាង់​ឆៃ​ឞារ​ហៃ​អ៝ស​នោ​គុ​ឆែង​ជាល​តា​ទាក​នៃ អី​នោ​រាញា​ឆីមោន  នទ្រែល​មា​អ៝ន់ទ្រេ ​អី​អ៝ស។ ឞារ​ហៃ​ខាន់​ពាង់​អី​នៃ​ជេង​ឞូនុយ្ស​ជាន​ការ​វាង់​កា​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ហើយ​អ៝ស​នោ ហោៈ​តឹង​គ៝ប់គ៝ប់​អ៝ន់​ខាន់​មៃ​ហាន់​ជ៝យ​ឞូនុយ្ស​អ្យាត់​នាវ​គ៝ប់ តឹម​ឞាន​មា​ឆែង​កា”។ ");
INSERT INTO cmok_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ទោ​មា​ឞារ​ហៃ​ខាន់​ពាង់​រី​នត្លើយ​ជាល​ព្រុង​តា​នៃ ជេសរី​តឹង​ឞ្រាស​យេឆូ ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​ជឹត​នាប់ ពាង់​ឆៃ​ឞារ​ហៃ​អ៝ស​នោ​យាកើ  នទ្រែល​មា​យោហាន ​គុ​ឆុល​ជាល​តា​ទូក​រី ឞារ​ហៃ​ខាន់​ពាង់​នៃ​អី​ក៝ន​ឆេបេដេ ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ត៝ត់​ឆៃ​ខាន់​ពាង់​តា​រី ឞ្រាស​យេឆូ ​ជាៈ​រ៝ ជេសរី​ខាន់​ពាង់​នត្លើយ​អី​ឞឹ នទ្រែល​មា​មពោល​អី​ពាង់​ងខោម​ជាន​ការ​មា​ពាង់​តា​រី ហាន់​តឹង​ឞ្រាស​យេឆូ ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​តា​ប៝ន​កាពើនិម ។ ត៝ត់​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល ​ពាង់​លាប់​នតុម​នតី​តា​ញីស​រាបុន​ផូង​អីឆ្រាអែល ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ឞូ​នទ្រ៝ត់​ញហីស​ងាន់​តាង់​នាវ​ពាង់​នតី​អី​នៃ។ នាវ​ពាង់​នតី​នើស​គែស​នាវ​ទើយ មោ​អោស​តឹម​ឞាន​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","តា​ញីស​រាបុន​នៃ គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​លាប់​តា​នៃ​ឞ្រាស​អ្យើស​គុ​តា​ឆាក់​ពាង់​ដ៝ង់ ពាង់​នតែរ៖ ");
INSERT INTO cmok_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“អើ​យេឆូ ​តាៈ​ឞើស​ប៝ន​នាឆារែត ! លើយ​មៃ​រាខ្វាក​ហេន មៃ​ហាន់​អុច​លើស​លើយ​ហេន​ឞើស? គ៝ប់​នាល់​មៃ​ងាន់ មៃ​អី​នៃ​អី​ឞូនុយ្ស​ក្ល៝ស​អ្វែស​តាៈ​ឞើស​កោរាញ​ឞ្រាស”។ ");
INSERT INTO cmok_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ឞ្រាស​យេឆូ ​ទែ​មឞ្រាម​ឞ្រាស​អ្យើស​អី​នៃ៖ “លើយ​ហោម​ងើយ គុ​អ្យាត់​ឆាក់​រាក្លាក់​ហ៝ៈ ទូ​លោស​ឞើស​ឞូនុយ្ស​អី​នៃ​ហ៝ម់!” ");
INSERT INTO cmok_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ជេស​តាង់​ឞ្រាស​យេឆូ ​លាស​នទ្រី​ឞ្រាស​អ្យើស​លើស​ឞូនុយ្ស​អី​នៃ​ចោត​ទុល​ញឆ្ល៝ង់​ឆ៝ង់​ឆា នតែរ​លុង​ល៝ច​ងាន់​លោស​ប្ហុច​ឞ្រាស​អ្យើស​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ទឹង​លែៈ​ឞូនុយ្ស​ឆៃ​កើត​នៃ​នើស នទ្រ៝ត់​ហីស​រាហ៝ល់​ទាទេ​ងាន់ ជេសរី​តឹម​អោប​នទ្រាង់​ខាន់​ពាង់​នើម៖ “យេ! លែៈ​នាវ​ងាន់​ហៃ! នាវ​នតុម​នតី​ពាង់​អី​នៃ​មហែ​ងាន់​ហៃ នអ៝ប់​មា​គែស​នាវ​ទើយ​ដ៝ង់។ ឞ៝ល​លាស​ឞ្រាស​អ្យើស​អ្យាត់​នាវ​ពាង់​ដាៈ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ជេសរី​គើញ​ងាន់​ឞូ​លឺ​ពាង់​ហោ​លាម​ឞ្រី​កាលីលេ ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​ញីស​រាបុន​អី​នៃ ហាន់​ឞ្រ៝ង់​តា​ជៃ​ឞារ​ហៃ​អ៝ស​នោ ឆីមោន  នទ្រែល​អ៝ន់ទ្រេ ។ យាកើ  នទ្រែល​មា​យោហាន ​ហាន់​នទ្រែល​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ល៝ង់​អី​មេៈ​ព៝​ឆីមោន ​រី​ជី​ក៝ប​ឞិច​តា​គ្រែ​រី។ ត៝ត់​តា​នៃ​ឞូ​មឞើស​មា​ឞ្រាស​យេឆូ ​រ៝​នាវ​ជី​ក៝ប​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ឞ្រាស​យេឆូ ​ហាន់​រាន​តា​ពាង់ ញុប​តី​រាទ៝ក់​ពាង់។ នាវ​ជី​ក៝ប​ឞាស​រ៝ ជេសរី​ពាង់​ជាន​ព្យាង់​ត្រាវ​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ត៝ត់​ឞ្រី​កេង​មាង់​នោក​នារ​លែៈ​ញ៝ប់ លែៈ​ឞូនុយ្ស​គែស​នាវ​ជី នទ្រែល​មា​ឞូនុយ្ស​ឞ្រាស​អ្យើស​លាប់ ឞូ​លែវ​ហាន់​អា​ឞ្រាស​យេឆូ ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","គែស​អ៝ក់​ងាន់​ឞូនុយ្ស​តា​ប៝ន​នៃ​គុ​គូម​តា​មពោង​ជៃ​រី​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ជេសរី​គែស​អ៝ក់​ឞូនុយ្ស​ឞ្រាស​យេឆូ ​ជាន​ឞាស​អាប់​នតីល​នាវ​ជី​តា​ខាន់​ពាង់ មព្រើស​ឞ្រាស​អ្យើស​ទូ​លោស​ឞើស​ឞូនុយ្ស​ដ៝ង់។ ពាង់​ឞ្វៃ​ឞ្រាស​អ្យើស​មោ​អោស​អ៝ន់​ងើយ យ៝រ​លាស​ផូង​ឞ្រាស​អ្យើស​លែៈ​នាល់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","កាស​អើម​អោយ​ឞ្រី​ហោម​ង៝ ឞ្រាស​យេឆូ ​ទ៝ក់​ឞិច​ហាន់​ទូ​ហ្វេ​អេង​តា​នតុក​ឞ្រី​រាទាស​ងាយ​ដាស​ឞូនុយ្ស ជេសរី​មឞើស​ឆើម​តា​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ឆីមោន  នទ្រែល​មា​មពោល​អី​គុ​នទ្រែល​ពាង់ ហាន់​ជ៝យ​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ត៝ត់​មា​ឆៃ​ពាង់ ខាន់​ពាង់​លាស៖ “អ៝ក់​ងាន់​ឞូនុយ្ស​អុច​ជ៝យ​មៃ​មេៈ”។ ");
INSERT INTO cmok_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ហោៈ​ឞ៝ន់​ឞ្រោៈ​រ៝ៈ​ប៝ន​អី​ទាច់ៗ​តា​អ្យា។ គ៝ប់​ឞែ​មា​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​អ៝ន់​មា​ប៝ន​អី​នៃ នទ្រី​ទឹង​គ៝ប់​ហាន់​ត៝ត់​តា​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​តា​ញីស​រាបុន​ផូង​អីឆ្រាអែល ​លាម​ឞ្រី​កាលីលេ ​នហ៝​មា​មព្រើស​ឞ្រាស​អ្យើស​ទូ​លោស​ឞើស​ឞូនុយ្ស​អ៝ក់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ផុង​ឆា​ហាន់​ច៝ន​កោម៝ក់​ឞ៝ញ​ឞ្រាស​យេឆូ ៖ “ទាន់​មៃ​យោៈ​នអាច​មា​គ៝ប់​អើ! គ៝ប់​លែៈ​គឹត​មៃ​ទើយ​ជាន​ឆាក់​គ៝ប់​អ៝ន់​ក្ល៝ស​អ៝ន់​ឞាស​ជី លាស​មៃ​អុច”។ ");
INSERT INTO cmok_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ឞ្រាស​យេឆូ ​យោៈ​នអាច​មា​ឞូ​ក្លោ​ផុង​ឆា​នៃ។ ឞ្រាស​យេឆូ ​នតា​តី​ពាស​តា​ឆាក់​ពាង់​រី ជេសរី​លាស​មា​ឞូនុយ្ស​ផុង​ឆា​អី​នៃ៖ “អើ គ៝ប់​អុច​ដ៝ង់ ឞាស​ហ៝ម់!” ");
INSERT INTO cmok_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ជេស​ឞ្រាស​យេឆូ ​ងើយ​រី ឞូ​ក្លោ​ផុង​ឆា​អី​នៃ​ទោ​មា​ឞាស​អ្វែស​ក្ល៝ស​រាងុច​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ជេសរី​ឞ្រាស​យេឆូ ​ដាៈ​ពាង់​ឆឹត នហ៝​មា​ឞ្វៃ​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“មៃ​លើយ​អោស​មឞើស​ងក៝ច​នាវ​អី​អ្យា​អ៝ន់​ឞូ​គឹត អ៝ន់​មៃ​ហាន់​ឞ្រ៝ង់​ញហើ​ឆាក់​មា​ឞូនុយ្ស​ជាន​ឞ្រាស​រី ជេសរី​ញហើរ​នទើ​ជាន​ឞ្រាស​តឹង​នាវ​វៃ​មោឆេ ​ដាៈ​មា​ឞូនុយ្ស​ឞាស​នាវ​ជី​ផុង​ឆា គៃ​មា​ឞូ​គឹត​នហេល​ឆាក់​មៃ​លែៈ​ក្ល៝ស​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","តីស​មា​ឞូ​ក្លោ​អី​នៃ​មឞូង​រាបើច​ហាន់​មឞើស​ងក៝ច​មា​ឞូ​រ៝ ពាង់​មឞើស​ងក៝ច​នាវ​អី​នៃ​អ៝ន់​ឞូ​គឹត​លាម​អាប់​នតុក​អាប់​នតោ។ អាច​មា​ងក៝ច​នទ្រី ឞ្រាស​យេឆូ ​ទែរ​មោ​ហោម​អោស​ទើយ​លាប់​តា​ប៝ន​ក្វ៝ង់​កើត​អា​ល៝រ​នើស ពាង់​គុ​ឞើស​ទីស​ប៝ន ជេសរី​ហោម​គែស​ឞូនុយ្ស​តាៈ​ឞើស​អាប់​ញជោញ​អាប់​ញជាញ់​ហាន់​អា​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ត៝ត់​ជ៝ៈ​ឞារ​ពែ​នារ​រី ឞ្រាស​យេឆូ ​ព្លឹ​តៃ​តា​ប៝ន​កាពើនិម ។ ឞូនុយ្ស​តា​ប៝ន​នៃ​តាង់​លឺ​ពាង់​លែៈ​ព្លឹ​ឆឹត​តៃ​គុ​តា​ជៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","គែស​ឞូនុយ្ស​រាន​តា​ជៃ​នៃ​អ៝ក់​មពឺម​ងាន់ ជ៝យ​នតុក​មា​គុ​មោ​គែស​អោស ឞ៝ល​លាស​ឞើស​ទីស​មពោង​មោ​ហោម​គែស​ដ៝ង់។ ជេសរី​ឞ្រាស​យេឆូ ​មឞើស​ងក៝ច​នាវ​កោរាញ​ឞ្រាស​អ៝ន់​មា​ខាន់​ពាង់​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ជេសរី​គែស​ឞូនុយ្ស​ព្វាន់​នុយ្ស​ហាន់​ឞើស​កើយ​តូង​ទូ​ហ្វេ​ឞូ​ក្លោ​រាវែន​ជ៝ង់​រាវែន​តី ហាន់​អា​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ត៝ត់​តា​ជៃ​នៃ​ជ៝យ​ត្រ៝ង​លាប់​ហាន់​តា​ឞ្រាស​យេឆូ ​មោ​ឆៃ​អោស យ៝រ​មា​គែស​ឞូនុយ្ស​អ៝ក់​អីរ។ កើត​នទ្រី​ខាន់​ពាង់​លោក​ត្រោម​កាលើ​ច៝រ​ជៃ​តឹម​ឆ៝ង់​នតុក​ឞ្រាស​យេឆូ ​គុ ជេសរី​ញជុរ​ឞូ​ក្លោ​រាវែន​អី​ឞិច​តា​មឞេល​នៃ​រ៝ៈ​ត្រោម​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ឞ្រាស​យេឆូ ​ឆៃ​ខាន់​ពាង់​គែស​នាវ​ញឆីង​ពាង់​ទើយ​ជាន​ឞាស​នាវ​ជី​កើត​នៃ ពាង់​លាស​មា​ឞូនុយ្ស​រាវែន​អី​នៃ៖ “ហើយ​អ៝ស គ៝ប់​លែៈ​យោៈ​មៃ មោ​ហោម​អោស​កើប​នាវ​តីស​តា​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","តា​នៃ​គែស​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​អាបាៈ​ងក្ល៝ន់​អេង​តា​តោរ៖ ");
INSERT INTO cmok_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ហឺស! មើម​ទឹង​ពាង់​ឞាញ់​ងើយ​មឺច​រាម៝ត​កោរាញ​ឞ្រាស​កើត​នទ្រី? គែស​ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ទើម​ទើយ​យោៈ​ឞូនុយ្ស មោ​ហោម​អោស​កើប​មោ​ហោម​អោស​ក្លាប់​នទាង់​នាវ​តីស!” ");
INSERT INTO cmok_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","យើន​មា​ឞ្រាស​យេឆូ ​គឹត​រ៝​លែៈ​នាវ​ខាន់​ពាង់​ងក្ល៝ន់​កើត​នៃ ពាង់​លាស​មា​ខាន់​ពាង់៖ “មើម​ទឹង​ខាន់​មៃ​គែស​នាវ​មឹន​កើត​នអៃ? ");
INSERT INTO cmok_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","អ៝ន់​ខាន់​មៃ​គឹត​នាវ​អ្យា លាស​គ៝ប់​លាស​មា​ឞូ​ក្លោ​រាវែន​នៃ «នាវ​តីស​មៃ​លែៈ​គ៝ប់​យោៈ​ហើយ» មោ​លាស «មៃ​ទ៝ក់​ញអោត​មឞេល​ឞ្រោៈ​ហ៝ម់» លាស​នទ្រី​ម៝ស​នាវ​លាស​អី​ទើស​រាលាវ​ហាៈ? ");
INSERT INTO cmok_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","គ៝ប់​អុច​អ៝ន់​ខាន់​មៃ​គឹត​ឆៃ គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស នទ្រី​ទឹង​គ៝ប់​ទើយ​យោៈ​នាវ​តីស​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា”។ ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ឞូ​ក្លោ​រាវែន​អី​នៃ៖ ");
INSERT INTO cmok_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“មៃ​ទ៝ក់​ហ៝ម់! មៃ​ញអោត​មឞេល​មៃ​នៃ​ឆឹត​អា​ជៃ​មៃ​នើម​រី”។ ");
INSERT INTO cmok_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ពាង់​ទ៝ក់​ដើប​ឞើស​មឞេល​នៃ​រ៝ ញអោត​មឞេល​ពាង់​នើម​នៃ​ហាន់​ឆឹត​លាប់​រ៝ៈ​ងក្លាង​ផូង​ឞាល់​អ៝ក់។ ល៝ង់​លែៈ​ឞូនុយ្ស​អី​គុ​តា​នៃ​គែស​នាវ​នទ្រ៝ត់​ហីស​រាហ៝ល់ ខាន់​ពាង់​រានេ​មា​កោរាញ​ឞ្រាស នហ៝​មា​លាស៖ “ឞ៝ន់​មោ​អោស​វៃ​ឆៃ​នាវ​អ្យា​កាល់​ទឹ​ត៝!” ");
INSERT INTO cmok_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​រ៝ៈ​មែង​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ ​ទូ​តឹ​ជឹត ផូង​ប៝ន​លាន​អ៝ក់​ងាន់​ហាន់​តា​ពាង់ពាង់​នតុម​នតី​អ៝ន់​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ជេស​នតុម​នតី​នៃ​ពាង់​លោស​ឞើស​នៃ​ឞ្រោៈ​តៃ​ជឹត​នាប់ ជេសរី​ឆៃ​ទូ​ហ្វេ​ឞូនុយ្ស​រាញា​លេវី ​អី​ក៝ន​អាល់ផាយ ​គុ​ក៝ប់​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ ពាង់​គុ​តា​នតុក​ពាង់​វៃ​ឆ៝ៈ​ព្រាក់។ ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ហោៈ​ឞ្រោៈ​តឹង​គ៝ប់”។ ពាង់​ទ៝ក់​ឞើស​នៃ ជេសរី​តឹង​ឞ្រាស​យេឆូ ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","តា​នារ​នៃ​លេវី ​ជាៈ​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ហាន់​ឆោង​ឆា​តា​ជៃ​ពាង់​នើម។ តា​ជៃ​នៃ​គែស​ឞូនុយ្ស​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន នទ្រែល​មា​ឞូនុយ្ស​តីស​អាបាៈ​អេង​គែស​អ៝ក់​គុ​ឆោង​ឆា​នទ្រែល​ដ៝ង់។ គែស​ឞូនុយ្ស​អី​កើត​នៃ​អ៝ក់​ងាន់​ហាន់​តឹង​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ត៝ត់​ឆៃ​ឞ្រាស​យេឆូ ​គុ​ឆោង​ឆា​នទ្រែល​ផូង​ឞូនុយ្ស​តីស​នៃ ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​ជេង​ផូង​ផារីឆី ​ដ៝ង់ លាស​មា​អ៝ស​ម៝ន​ពាង់៖ “មើម​ទឹង​ឞូនុយ្ស​អី​នៃ​គុ​ឆោង​ឆា​នទ្រែល​ឞូនុយ្ស​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន នទ្រែល​មា​ឞូនុយ្ស​ជាន​តីស​អេង​កើត​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ជេស​ឞ្រាស​យេឆូ ​តាង់​ខាន់​ពាង់​លាស​កើត​នៃ ពាង់​លាស៖ “ឞូនុយ្ស​គែស​ឆាក់​ជាន់​អ្វែស​មោ​អុច​អោស​មា​កោរាញ​ទាក​ឆី ឞូនុយ្ស​អី​គែស​នាវ​ជី​ទើម​អុច។ នទ្រី​ទឹង​គ៝ប់​វាច់​តា​អ្យា​មោ​អោស​គៃ​មា​ក្វាល់​ឞូនុយ្ស​ឆ៝ង់ អុច​ក្វាល់​ឞូនុយ្ស​តីស គៃ​មា​កើល​ខាន់​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ល៝ង់​គែស​ទូ​នារ​មពោល​អ៝ស​ម៝ន​យោហាន-​បាប់តែម  នទ្រែល​មា​មពោល​ផារីឆី ​ខាន់​ពាង់​អ៝ត់​ឆោង​ឆា។ ជេសរី​គែស​ឞូ​ហាន់​អោប​ឞ្រាស​យេឆូ ៖ “មពោល​អ៝ស​ម៝ន​យោហាន-​បាប់តែម  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ផូង​ផារីឆី ​អ៝ត់​ឆោង​ឆា មើម​ទឹង​មពោល​អ៝ស​ម៝ន​មៃ​មោ​អ៝ត់?” ");
INSERT INTO cmok_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “នោក​តឹម​នអាប់​អូរ​ឆាយ ឞូ​នាច់​វៃ​អ៝ត់​ឆោង​ឆា​ដ៝ង់​ឞើស? មោ​វៃ​អោស។ អ្យាត់​មា​អី​ឆាយ​មហែ​ហោម​គុ​នទ្រែល​តា​រី នាវ​តឹម​នអាប់​នៃ​អេ​ហ៝ៈ​លោច​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","គ៝ប់​តឹម​ឞាន​មា​ឞូ​ក្លោ​នអាប់​អូរ​ឆាយ ត៝ត់​ទី​នារ​រី​តៃ​ឞូ​តឹម​ងខាស​គ៝ប់​ដាស​មពោល​អ៝ស​ម៝ន​គ៝ប់ តា​នារ​អី​នៃ​ខាន់​ពាង់​អ៝ត់​ឆោង​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ឞូ​មោ​វៃ​អោស​ឆ៝ៈ​ឞ៝ក​មហែ​អេ​ហ៝ៈ​ពីស​មឞោល​តា​អាវ​លែៈ​ឆាត។ លាស​ជាន​កើត​នៃ​ឞ៝ក​អី​ឆាត​រី​លើ​មា​ហោ​ហេក​រាលាវ​អើម​ងាន់ យ៝រ​មា​អី​ឞ៝ក​មហែ​នៃ​ជេង​រោត​នោក​ជេស​ពីស។ ");
INSERT INTO cmok_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","កើត​នទ្រី​ដ៝ង់ ឞូ​មោ​វៃ​អោស​តេៈ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មហែ​តា​ទុង​នតោ​អើម លាស​ជាន​កើត​នៃ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មហែ​ជាន​អ៝ន់​ទុង​នតោ​អី​នៃ​ព្រែក នទ្រាញ់​ហុក​ដ៝ង់ ជេសរី​ទុង​នតោ​អី​នៃ​ជេង​ឆាត​ដ៝ង់ យ៝រ​លាស​ទុង​នតោ​អើម​មោ​ហោម​អោស​ត៝ច។ ឞូ​តេៈ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មហែ​តា​ទុង​នតោ​មហែ”។ ");
INSERT INTO cmok_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","គែស​ទូ​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល ​ឞ្រាស​យេឆូ  នទ្រែល​អ៝ស​ម៝ន​ពាង់​ហាន់​គ្លាត់​រ៝ៈ​មីរ​ឞា​ព្រាង់  ជេសរី​មពោល​អ៝ស​ម៝ន​ពាង់​រ៝យ្ស​ឞា​ព្រាង់ ​គៃ​មា​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","គែស​ផូង​ផារីឆី ​ហាន់​ឞើស​កើយ​លាស​ឞ្រាស​យេឆូ ៖ “ល៝ង់​មៃ​អ្វាញ់ ម៝ស​ឆី​កោៈ​មពោល​អ៝ស​ម៝ន​មៃ​ជាន​ការ​តា​នារ​ឆាបាត់ ​អ្យា​មេស? ឞ៝ល​លាស​ខាន់​ពាង់​រ៝យ្ស​ដេៈៗ​កើត​នៃ ហោម​អែ​កើប​តីស​ដាស​នាវ​វៃ​នារ​រាលូ​ផូង​ឞ៝ន់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","ឞ្រាស​យេឆូ ​អោប៖ “លាស​នទ្រី​ខាន់​មៃ​លែៈ​ច្វេល​បាស នាវ​ខាន់​មៃ​វៃ​រ៝ៈ​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ? ឞើស​នោក​អាបីយាថារ ​ជាន​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់ ដាវីត  នទ្រែល​មា​ឞូនុយ្ស​គុ​នទ្រែល​ពាង់​ហោ​ងាន់​ជី​ង៝ត ខាន់​ពាង់​អុច​គែស​នទើ​ឆោង​ឆា។ នោក​នៃ​ដាវីត ​អេ​ហ៝ៈ​ជេង​កាដាច់។ ជេសរី​ដាវីត ​លាប់​តា​ត្រោម​នតុក​ចូន​ឞ៝ក​កោរាញ​ឞ្រាស ពាង់​ឆា​នុមពាង់​អី​ឞូ​តេៈ​ញហើរ​មា​កោរាញ​ឞ្រាស​នៃ នហ៝​មា​ពាៈ​ឞូនុយ្ស​អី​គុ​នទ្រែល​ពាង់​ឆា​ដ៝ង់។ ឞូ​មោ​លាស​ពាង់​ដ៝ង់​ឞ៝ល​លាស​តឹង​មា​នាវ​វៃ​គែស​មពោល​ជាន​ឞ្រាស​ទើម​ទើយ​ឆា​នុមពាង់​អី​នៃ!” ");
INSERT INTO cmok_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ឞ្រាស​យេឆូ ​លាស​ជឹត៖ “កោរាញ​ឞ្រាស​ដាៈ​ក៝ន​ឞូនុយ្ស​រាលូ​តា​នារ​ឆាបាត់ ​គៃ​មា​កើល​ក៝ន​ឞូនុយ្ស មោ​គែស​អោស​ពាង់​ញជេង​ក៝ន​ឞូនុយ្ស​ជាន​ទឹក​មា​នារ​ឆាបាត់ ! ");
INSERT INTO cmok_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស នទ្រី​ទឹង​គ៝ប់​ជេង​កោរាញ​ម៝ស​នទើ​អី​ទើយ​អ៝ន់​ឞូ​ជាន មោ​លាស​មោ​ទើយ​អ៝ន់​ឞូ​ជាន​តា​នារ​ឆាបាត់ ​អី​នារ​រាលូ”។ ");
INSERT INTO cmok_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ជេសរី​ឞ្រាស​យេឆូ ​លាប់​តា​ញីស​រាបុន​ផូង​អីឆ្រាអែល ​ទូ​តឹ​ជឹត តា​នៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​រាវែន​តី​ទូ​ទីង។ ");
INSERT INTO cmok_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ឞូ​អុច​ជ៝យ​នាវ​មា​នតោន​ឞ្រាស​យេឆូ ​ងខេប​លាស​ពាង់​ជាន​ឞាស​ឞូនុយ្ស​ជី​តា​នារ​ឆាបាត់  យ៝រ​លាស​ខាន់​ពាង់​នតី​តា​នាវ​វៃ​ផូង​អីឆ្រាអែល ​មោ​អ៝ន់​អោស​ជាន​ឞាស​ឞូនុយ្ស​ជី​តា​នារ​ឆាបាត់  នទ្រី​ទឹង​ខាន់​ពាង់​អ្វាញ់​ជឹត​ពាង់​លែរ​ងែរ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ឞូ​ក្លោ​អី​នៃ៖ “ហើយ​អ៝ស មៃ​ទ៝ក់​ហ៝ម់ ហាន់​ទ៝ក់​ឞើស​នាប់​ឞូ​ត៝!” ");
INSERT INTO cmok_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អី​ក៝ប់​អ្វាញ់​ពាង់៖ “គ៝ប់​អោប​ខាន់​មៃ តឹង​នាវ​វៃ​ផូង​ឞ៝ន់​តា​នារ​ឆាបាត់ ​ឞូនុយ្ស​ទើយ​ជាន​នទើ​អ្វែស​មោ​លាស​នទើ​អ្យើស? ទើយ​រាក្លាយ្ស​នាវ​រេស​ឞូនុយ្ស​មោ​លាស​ងខឹត​ពាង់?” ទឹង​លែៈ​ខាន់​ពាង់​គុ​អ្យាត់​ឆាក់​រាក់​ក្លាក់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ឞ្រាស​យេឆូ ​អ្វាញ់​ទឹង​លែៈ​ឞូនុយ្ស​អី​គុ​តា​នៃ ពាង់​ជី​នូយ្ស​រាង៝ត​អេង​ឆាក់​ពាង់​នើម ឆៃ​ខាន់​ពាង់​ទាង់​ក៝​មោ​គែស​នាវ​តឹម​យោៈ។ ជេសរី​ពាង់​លាស​មា​ឞូ​ក្លោ​អី​រាវែន​តី​នៃ៖ “ល៝ង់​មៃ​រ៝ក​តី​មៃ​នៃ​ហ៝ម់!” ជេសរី​ពាង់​រ៝ក​តី​ពាង់​ឞាស​កើត​អើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ជេសរី​ផូង​ផារីឆី ​អី​គុ​តា​នៃ​លោស​រុច​ព្លុច​ឞើស​ញីស​រាបុន​នៃ ហាន់​ឞ្រ៝ង់​តឹម​ញច្រាៈ​ដាស​ឞាល់​មពោល​ហេរោត-​អ៝ន់តីពាស ​រ៝ គៃ​មា​ជ៝យ​នាវ​មើម​ទឹង​គែស​ងខឹត​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​នតុក​នៃ​ហាន់​តា​ងលៅ​ក្វ៝ង់​កាលីលេ ​នទ្រែល​មពោល​អ៝ស​ម៝ន​ពាង់។ គែស​អ៝ក់​ផូង​ប៝ន​លាន​ហាន់​តឹង​ពាង់ ផូង​អី​នៃ​តាៈ​ឞើស​ឞ្រី​កាលីលេ ​ឞើស​ឞ្រី​យូដា ‌ ");
INSERT INTO cmok_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ឞើស​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  ឞើស​ឞ្រី​អីដូមេ  ឞើស​កាល់​តី​ទាក​រាលាយ​យោរដាន់  ឞើស​អាប់​នតុក​ជុម​ប៝ន​ក្វ៝ង់​តីរុស  នទ្រែល​មា​ឞើស​អាប់​នតុក​ជុម​ប៝ន​ក្វ៝ង់​ឆីដោន ។ នទ្រី​ទឹង​អ៝ក់​ងាន់​ឞូនុយ្ស​ហាន់​វាច់​អា​ពាង់​នៃ យ៝រ​លាស​តាង់​ឞូ​មឞើស​ងក៝ច​ទឹង​លែៈ​នាវ​ពាង់​ជាន​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ឆៃ​អ៝ក់​អីរ​ប៝ន​លាន​នៃ​ឞ្រាស​យេឆូ ​ដាៈ​មពោល​អ៝ស​ម៝ន​ពាង់​នទ្រាប់​ទូ​មល៝ម់​ទូក​អ៝ន់​មា​ពាង់ ក្លាច​លាស​ផូង​ប៝ន​លាន​រុន​មពែត​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","លែៈ​ជេស​ពាង់​ជាន​ឞាស​ឞូនុយ្ស​ជី​អ៝ក់​ងាន់ នទ្រី​ទឹង​ឞូនុយ្ស​អេងៗ​អី​គែស​នាវ​ជី​ញឆ្រោយ្ស​ចុល​ហាន់​ទាច់ៗ អុច​ពាស​ឞ្រាស​យេឆូ ​គៃ​មា​ឞាស​នាវ​ជី​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ត៝ត់​ផូង​ឞូនុយ្ស​អី​គែស​ឞ្រាស​អ្យើស​គុ​តា​ខាន់​ពាង់​ឆៃ​ឞ្រាស​យេឆូ  ខាន់​ពាង់​ពាន់​តា​ឞើស​នាប់​ឞ្រាស​យេឆូ ​រ៝ នអ៝ប់​មា​នតែរ៖ “មៃ​អី​ក៝ន​កោរាញ​ឞ្រាស!” ");
INSERT INTO cmok_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ជេសរី​ឞ្រាស​យេឆូ ​មឞ្រាម មោ​អោស​អ៝ន់​ខាន់​ពាង់​មឞើស​ងក៝ច​មា​ឞូ​គឹត​នាល់​ពាង់​អី​ក៝ន​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ឞ្រាស​យេឆូ ​លែៈ​ហាវ​កាលើ​យោក ជេសរី​ពាង់​ក្វាល់​ជាៈ​ឞូនុយ្ស​អី​ពាង់​អុច​ហាន់​នទ្រែល​ពាង់ ជេសរី​ខាន់​ពាង់​អី​នៃ​ហាន់​តឹង​ពាង់​តា​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ឞើស​មពោល​អី​នៃ​ពាង់​កើយ្ស ១២ នុយ្ស ពាង់​ក្វាល់​ខាន់​ពាង់ «កោរាញ​អ៝ស​ម៝ន»។ មពោល​អី​នៃ​គៃ​មា​គុ​នទ្រែល​ពាង់​នើម អ៝ន់​ខាន់​ពាង់​មឞើស​ងក៝ច​នាវ​ពាង់​អ៝ន់​មា​ឞូ‌ ");
INSERT INTO cmok_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","នទ្រែល​មា​អ៝ន់​ខាន់​ពាង់​គែស​នាវ​ទើយ ទើយ​មព្រើស​ឞ្រាស​អ្យើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","មពោល ១២ នុយ្ស​នៃ តា​នៃ​គែស​ឆីមោន ​អី​ឞ្រាស​យេឆូ ​តេៈ​រាញា​មហែ​ពាង់​ពេត្រោស ‌ ");
INSERT INTO cmok_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","គែស​ឞារ​ហៃ​អ៝ស​នោ​អី​ក៝ន​ឆេបេដេ ​រាញា​យាកើ  នទ្រែល​មា​យោហាន ។ ឞារ​ហៃ​ខាន់​ពាង់​អី​នៃ​ឞ្រាស​យេឆូ ​ទែ​តេៈ​រាញា «បោអានេរកេ » រាឞ្លាង​នាវ​អី​នៃ «ក៝ន​នតែស​នត៝រ់​ងលាយ្ស»។ ");
INSERT INTO cmok_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","គែស​រាញា​អ៝ន់ទ្រេ  រាញា​ផីលីប  រាញា​បារថោលោមេ  រាញា​មាថាយ  រាញា​ថោមាស  រាញា​យាកើ ​អី​ក៝ន​អាល់ផាយ  រាញា​ថាដេ  រាញា​ឆីមោន ​អី​ឞូ​ក្វាល់​«គើយ្ស»‌ ");
INSERT INTO cmok_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","នទ្រែល​មា​រាញា​យូដាស-​អីឆាការីយោត ​អី​ឞូនុយ្ស​លែវ​ឞូ​ហាន់​ញុប​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​គុ​តា​ទូ​មល៝ម់​ជៃ ត៝ត់​តា​នៃ​គែស​ឞូនុយ្ស​វាច់​តៃ​តា​រី លើ​មា​អ៝ក់​លើ​មា​អ៝ក់​ងាន់។ ល៝ង់​ពាង់ នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​មោ​អោស​ហ៝ច​ឆោង​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ជេស​ផូង​ឞាល់​មពោល​ពាង់​តាង់​ឞូ​ទែ​ងក៝ច​នាវ​អី​នៃ ឞូ​លាស​ដ៝ង់៖ “ហឺស មោ​ហោម​អោស​គឹត​ឆាក់​ពាង់​រី”។ នទ្រី​ទឹង​ខាន់​ពាង់​ជាៈ​ឞាល់​ហាន់​ឆ៝ៈ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ល៝ង់​អី​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​អី​តាៈ​ឞើស​ប៝ន​យេរូឆាលឹម ​រី​ហាន់​ត៝ត់​តា​នៃ ខាន់​ពាង់​លាស៖ “ឞូនុយ្ស​អី​នៃ​គែស​ឞ្រាស​អ្យើស​បេលឆេបូល ​គុ​តា​ឆាក់​ពាង់។ យ៝រ​លាស​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​អ៝ន់​នាវ​ទើយ​តា​ពាង់ ទឹង​ពាង់​ទើយ​មព្រើស​ឞ្រាស​អ្យើស”។ ");
INSERT INTO cmok_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ឞ្រាស​យេឆូ ​ក្វាល់​ផូង​នើម​នតី​នៃ​ហាន់​ទាច់​អា​ពាង់ ជេសរី​លាស​មា​នាវ​ងើយ​នតឹត៖ “មើម​ឞ្លាវ​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​មព្រើស​ឆាក់​ពាង់​នើម? ");
INSERT INTO cmok_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","លាស​តា​ទូ​ឞ្រី​ផូង​ប៝ន​លាន​ពាង់​តឹម​ល៝ក់​តឹម​ជាញ​ចាស​ច្រាយ​ឞាល់ ឞ្រី​អី​នៃ​មោ​ហោម​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","មោ​លាស​តា​ទូ​រានាក់​វ៝ល់​គែស​តឹម​ល៝ក់​តឹម​ជាញ​ឞាល់​នឹង​នែង រានាក់​វ៝ល់​អី​នៃ​រ៝ស​ហេង​មោ​ហោម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","លាស​គែស​ឆាតាង់ ​តឹម​ល៝ក់​តឹម​ជាញ​នទ្រាង់​ពាង់​នើម ពាង់​មោ​ទើយ​អោស​គុ​ន៝ប់ រ៝ស​ហេង​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","មោ​គែស​អោស​ឞូនុយ្ស​ទើយ​ហាន់​តា​ជៃ​ឞូនុយ្ស​ទាង់ ជេសរី​នតុង​ទ្រាប់​នទើ​ពាង់។ អ៝ន់​ញុប​ក៝ត់​ល៝រ​ឞូនុយ្ស​អី​នៃ​ប៝ត់ រី​មើ​ទើយ​នតុង​ទឹង​លែៈ​ទ្រាប់​នទើ​តា​ជៃ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ ទឹង​លែៈ​នទើ​ឞូនុយ្ស​ជាន​តីស នទ្រែល​មា​លាស​មឺច​រាម៝ត​កោរាញ​ឞ្រាស កោរាញ​ឞ្រាស​ហោម​យោៈ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","តីស​មា​ឞូ​ម៝ស​អី​លាស​មឺច​រាម៝ត​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​រី មោ​អោស​កោរាញ​ឞ្រាស​យោៈ​មា​ពាង់ ពាង់​អី​នៃ​គែស​ទោយ្ស​នហ៝​រ៝​មោ​ឞ្លាវ​ឞាស”។ ");
INSERT INTO cmok_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","នទ្រី​ទឹង​ឞ្រាស​យេឆូ ​ងើយ​កើត​នៃ អាច​ខាន់​ពាង់​លាស​ពាង់​គែស​ឞ្រាស​អ្យើស​គុ​តា​ឆាក់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ជេសរី​មេៈ​ឞ្រាស​យេឆូ  នទ្រែល​មា​អ៝ស​ឞូ​ក្លោ​ពាង់ ហាន់​ត៝ត់​តា​ជៃ​ឞ្រាស​យេឆូ ​គុ​នតុម​នតី​នៃ។ ខាន់​ពាង់​គុ​ឞើស​ទីស​រី ជេសរី​ដាៈ​ឞូ​មឞើស​ពាង់​ហាន់​ម៝ប់​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ផូង​ប៝ន​លាន​អី​គុ​ជុម​ឞ្រាស​យេឆូ ​រី​មឞើស​ពាង់៖ “ហើយ​នើម​នតី មេៈ​មៃ នទ្រែល​មា​អ៝ស​ឞូ​ក្លោ​មៃ​គុ​ក៝ប់​ឞើស​ទីស​ត៝ អុច​ម៝ប់​មៃ​មេៈ!” ");
INSERT INTO cmok_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ជេសរី​ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ឞូ​ម៝ស​មេៈ​គ៝ប់? ឞូ​ម៝ស​អ៝ស​នោ​គ៝ប់?” ");
INSERT INTO cmok_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ជេសរី​ពាង់​អ្វាញ់​ឞូនុយ្ស​អី​គុ​ជុម​ពាង់ពាង់​លាស៖ “ឞូនុយ្ស​អី​គុ​តា​អ្យា​គ៝ប់​ក្វាល់​មេៈ​គ៝ប់ អ៝ស​នោ​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ឞូ​ម៝ស​អី​អ្យាត់​តឹង​នាវ​កោរាញ​ឞ្រាស​អុច ពាង់​អី​នៃ​អ៝ស​នោ​គ៝ប់ នទ្រែល​មា​មេៈ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","គែស​ទូ​នារ​រី​ឞ្រាស​យេឆូ ​គុ​នតី​ផូង​ប៝ន​លាន​រ៝ៈ​មែង​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ ​ទូ​តឹ​ជឹត។ តា​នៃ​គែស​អ៝ក់​ងាន់​ឞូនុយ្ស​ហាន់​វាច់​តា​ពាង់ នទ្រី​ពាង់​ហាវ​គុ​រាគើប​កាលើ​ទូក ជេសរី​នតី​កាលើ​ទូក​រី ផូង​ប៝ន​លាន​គុ​ឞើស​កើស​អ្យា គុ​រ៝ៈ​មែង​ទាក។ ");
INSERT INTO cmok_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ឞ្រាស​យេឆូ ​នតុម​នតី​ខាន់​ពាង់​អ៝ក់​ងាន់​មា​នាវ​ងើយ​នតឹត​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“អ្យាត់​ហ៝ៈ គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ហាន់​ឆូយ​គារ់​នតីល។ ");
INSERT INTO cmok_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","នោក​ពាង់​ឆូយ​នៃ​អាបាៈ​តុប​រ៝ៈ​ត្រ៝ង ជេសរី​ឆ្យុម​ច៝ក​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","គារ់​អាបាៈ​តុប​តា​នែស​ក្លេរ គារ់​អី​នៃ​គើញ​ហ៝ន​ព្រូ​យ៝រ​លាស​នែស​នហើ។ ");
INSERT INTO cmok_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ត៝ត់​ទោស​នារ​តើម​អី​នៃ​នទ្រ៝​ប្រុង យ៝រ​មា​រែស​ពាង់​ហ៝ន​មោ​ជ្រូ។ ");
INSERT INTO cmok_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","គារ់​អាបាៈ​ជឹត​តុប​តា​នែស​ល៝ក ជេសរី​ល៝ក​ហ៝ន​ត៝ល់​លែៈ​ផ្យៅ នហ៝​មា​មោ​អោស​ត៝ត់​ព្លៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ល៝ង់​គារ់​អី​អាបាៈ​ជឹត​តុប​តា​នែស​អ្វែស ពាង់​ហ៝ន​ព្រូ​អ្វែស​ជេង នហ៝​មា​ត៝ត់​គែស​ព្លៃ​ទូ​គារ់​គែស ៣០‌ អាបាៈ​ទូ​គារ់​គែស ៦០‌ អាបាៈ​ជឹត​ទូ​គារ់​គែស ១០០”។ ");
INSERT INTO cmok_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ជេសរី​ឞ្រាស​យេឆូ ​លាស​តៃ៖ “ឞូ​ម៝ស​តាង់​នាវ​គ៝ប់​ងើយ​អ្យា អ៝ន់​ពាង់​ងក្ល៝ន់​អេង​តា​ឆាក់!” ");
INSERT INTO cmok_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","នោក​ឞ្រាស​យេឆូ ​គុ​ងាយ​ដាស​ឞាល់​ផូង តា​នៃ​គែស ១២ នុយ្ស មពោល​អ៝ស​ម៝ន នទ្រែល​មា​ឞូ​អាបាៈ​ដ៝ង់​គុ​នទ្រែល​ពាង់ ជេសរី​ខាន់​ពាង់​អោប​ពាង់៖ “មៃ​មឞើស​នហេល​នាវ​ងើយ​នតឹត​អី​នៃ​អឺស”។ ");
INSERT INTO cmok_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ឞ្រាស​យេឆូ ​អើស​លាស៖ “អា​ល៝រ​នើស​នាវ​ខ្លៃ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស​ហោម​នទ៝ប់​មពោន អាបៃ​រី​កោរាញ​ឞ្រាស​អ៝ន់​មា​ខាន់​អៃ​មៃ​គឹត​វ៝ត់​នទើ​អី​នៃ។ ល៝ង់​ឞូនុយ្ស​អាបាៈ​ជឹត គ៝ប់​ងើយ​នតឹត​អ៝ន់​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","នទ្រី​តឹម​ទី​ដាស​នាវ​កោរាញ​ឞ្រាស​ងើយ​កាល់​អែ​នើស៖ «ឞ៝ល​លាស​ខាន់​ពាង់​អ្វាញ់​នទើ​គ៝ប់​ជាន​ក៝ៈ​មោ​វ៝ត់​នទើ​ខ្លៃ​នាវ​អី​នៃ។ ខាន់​ពាង់​តាង់​នាវ​គ៝ប់​ងើយ​ក៝ៈ​មោ​វ៝ត់​ដ៝ង់។ លាស​ខាន់​ពាង់​វ៝ត់ ខាន់​ពាង់​រាគ៝ល់​នូយ្ស​នហ៝ម់​អ្យើស ជេសរី​កោរាញ​ឞ្រាស​យោៈ​នអាច​មោ​ហោម​កើប​នាវ​តីស​ខាន់​ពាង់»”។ ");
INSERT INTO cmok_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ឞ្រាស​យេឆូ ​លាស​តៃ​មា​ខាន់​ពាង់៖ “នាវ​ងើយ​នតឹត​អ្យា​លាស​ខាន់​អៃ​មៃ​មោ​វ៝ត់​ដ៝ង់ មើម​ខាន់​អៃ​មៃ​ទើយ​វ៝ត់​នាវ​ងើយ​នតឹត​អាបាៈ​អេង​ជឹត​ហាៈ! ");
INSERT INTO cmok_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ឞូនុយ្ស​អី​ឆូយ​គារ់​នតីល​នៃ កើត​ឞូនុយ្ស​អី​មឞើស​ងក៝ច​នាវ​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","គារ់​នតីល​អី​តុប​រ៝ៈ​ត្រ៝ង តឹម​ឞាន​មា​ឞូនុយ្ស​អី​អ្យាត់​នាវ​កោរាញ​ឞ្រាស ជេស​អ្យាត់​ទោ​មា​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​ពីត​លើយ​នាវ​ពាង់​អ្យាត់​នៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ឞូនុយ្ស​អី​តឹម​ឞាន​មា​គារ់​នតីល​តុប​តា​នែស​ក្លេរ​តាង់​នាវ​កោរាញ​ឞ្រាស ខាន់​ពាង់​អ្យាត់​រ៝​រាម់​មអាក​ងាន់‌ ");
INSERT INTO cmok_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ហ៝ន​អ្វែស​ទូ​ប្ល៝ត់​ទើម។ នាវ​កោរាញ​ឞ្រាស​មោ​អោស​ហ៝ន​រែស​តា​នូយ្ស​នហ៝ម់​ខាន់​ពាង់​នើម នទ្រី​ត៝ត់​គែស​នាវ​ជេរ​អេងៗ មោ​លាស​ឞូ​ជាន​ជេរ​យ៝រ​មា​នាវ​កោរាញ​ឞ្រាស ខាន់​ពាង់​មអារ់​រ៝​នាវ​ញឆីង។ ");
INSERT INTO cmok_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ឞូនុយ្ស​អាបាៈ​ជឹត​តឹម​ឞាន​មា​គារ់​នតីល​តុប​តា​នែស​ល៝ក ខាន់​ពាង់​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ដ៝ង់‌ ");
INSERT INTO cmok_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","តីស​មា​តា​ត្រោម​នូយ្ស​នហ៝ម់​ខាន់​ពាង់​ងក្ល៝ន់​រាវៃ​ហោ​ងាន់​មា​នាវ​រេស​តា​នែស​នតូ​អ្យា អុច​រាវាន​កើញ​គែស​ទ្រាប់​នទើ នអ៝ប់​មា​នូយ្ស​នហ៝ម់​ខាន់​ពាង់​រ៝ង់​គែស​មា​នទើ​អេងៗ។ ជេសរី​ពូត​បារ់​នាវ​កោរាញ​ឞ្រាស​អី​នៃ​មោ​អ៝ន់​ត៝ត់​ព្លៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ល៝ង់​ខាន់​ពាង់​អី​តឹម​ឞាន​មា​គារ់​នតីល​តុប​តា​នែស​អ្វែស​រី ជេស​តាង់​នាវ​កោរាញ​ឞ្រាស​ពាង់​អ្យាត់ នហ៝​មា​ត៝ត់​គែស​ព្លៃ គែស​ឞូនុយ្ស​អាបាៈ​រី​ទូ​គារ់​ជេង​គែស ៣០‌ ទូ​គារ់​ជេង​គែស ៦០‌ ឞូនុយ្ស​អាបាៈ​រី​ជឹត​ទូ​គារ់​ជេង​គែស ១០០ ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ផូង​ប៝ន​លាន៖ “មោ​វៃ​ឆៃ​អោស​ឞូ​មពេស​អុញ​ឆាគេង ជេសរី​កុប​លើយ​មា​ឆាស មោ​លាស​តេៈ​តា​ន៝ម់​គ្រែ។ ឞូ​វៃ​យោង​អុញ​ឆាគេង​អ៝ន់​ព្រេស។ ");
INSERT INTO cmok_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ទឹង​លែៈ​នទើ​អី​មពោន​ម៝ កោរាញ​ឞ្រាស​អ៝ន់​ឞូ​គឹត​ទាទេ។ ទឹង​លែៈ​នទើ​អី​ឞូ​មោ​ឆៃ ពាង់​ញហើ​អ៝ន់​ឞូ​ឆៃ​ក្ល៝ស​រាស​វាស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ឞូ​ម៝ស​អី​តាង់​នាវ​គ៝ប់​ងើយ​អ្យា​អ៝ន់​ពាង់​មឹន​អេង​តា​ឆាក់!” ");
INSERT INTO cmok_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​ងាន់​ហ៝ម់​នាវ​អី​ខាន់​អៃ​មៃ​អ្យាត់​អី​អ្យា។ កោរាញ​ឞ្រាស​រាញ្វែស​អ៝ន់​មា​ខាន់​អៃ​មៃ តឹង​ខាន់​អៃ​មៃ​រាញ្វែស​អ៝ន់​មា​ឞូ​ដ៝ង់ ជេសរី​ពាង់​កើយ​នត៝ប​តៃ​មា​ខាន់​អៃ​មៃ​អ៝ន់​រាលាវ​អី​នៃ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ឞូ​ម៝ស​អី​លែៈ​គែស កោរាញ​ឞ្រាស​កើយ​នត៝ប​អ៝ន់​មា​ពាង់​ជឹត តីស​មា​ឞូ​ម៝ស​អី​មោ​គែស កោរាញ​ឞ្រាស​ឆ៝ៈ​រាហ្វាត់​លើយ​លែៈ​នទើ​អី​ពាង់​គឹត​លាស​លែៈ​គែស”។ ");
INSERT INTO cmok_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ឞ្រាស​យេឆូ ​លាស​តៃ៖ “នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស​តឹម​ឞាន​មា​ទូ​ហ្វេ​ឞូ​ក្លោ​លោស​តូច​ឞា​តា​មីរ​ពាង់​នើម‌ ");
INSERT INTO cmok_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ជេសរី​អា​មាង់​ឞិច អា​នារ​ជាន​ការ។ គារ់​ឞា​អី​នៃ​ហ៝ន យើន​មា​ពាង់​មោ​គឹត​ដ៝ង់​អា​មើម​នតើម​ហ៝ន។ ");
INSERT INTO cmok_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","នែស​អ៝ន់​គារ់​ឞា​អី​នៃ​គែស​ហ៝ន​អេង​ពាង់​នើម។ ឞើស​នតើម​ពាង់​លោស​នហា ព្រេស​ដេៈ​ព្រេស​ដេៈ​នហ៝​មា​ត៝ត់​លោស​ត៝ត់​មឞោន ជេសរី​មើ​ជេង​ព្លៃ​ឞា។ ");
INSERT INTO cmok_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ត៝ត់​ឞា​លែៈ​ទុម ពាង់​ឆ៝ៈ​ញអែវ​ហាន់​រែក យ៝រ​លាស​លែៈ​ទី​ខៃ​រែក”។ ");
INSERT INTO cmok_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ឞ្រាស​យេឆូ ​លាស៖ “នទ្រី​ម៝ស​នទើ​ឞ៝ន់​តឹម​រាដឹល​មា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស? ម៝ស​នាវ​ងើយ​នតឹត​ឞ៝ន់​ឆ៝ៈ​មា​តឹម​រាដឹល​ដាស​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់? ");
INSERT INTO cmok_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស តឹម​ឞាន​មា​ទូ​នតីល​គារ់​ឆី​អី​ឞូ​ឆូយ​តា​នែស គារ់​ឆី​អី​នៃ​រាហេន​រាលាវ​ឞូ​ងាន់​មា​ដាស​គារ់​ឆី​ទឹង​លែៈ​តា​នែស​នតូ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ជេស​ឞូ​ឆូយ​ពាង់​តា​នែស​រី ត៝ត់​មា​ហ៝ន​តើម​អី​នៃ​ក្វ៝ង់​រាលាវ​មា​តើម​អាបាៈ​អេង​ជឹត គែស​ងគីង​គែស​នថាន​នហ៝ម់​ងាន់ នហ៝​មា​គែស​ឆ្យុម​គុ​ជាន​រាឆ្វាន់​តា​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","កើត​នទ្រី​ឞ្រាស​យេឆូ ​នតុម​នតី​នាវ​កោរាញ​ឞ្រាស ពាង់​ទ៝ង់​នាវ​ងើយ​នតឹត​កើត​នអា តឹង​អី​ប៝ន​លាន​ទើយ​វ៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ប៝ន​លាន​តាង់​ពាង់​ងើយ​នាវ​ងើយ​នតឹត​ទើម យើន​មា​នោក​ពាង់​គុ​អេង ពាង់​រាឞ្លាង​នាវ​អី​នៃ​អ៝ន់​មា​មពោល​អ៝ស​ម៝ន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","នោក​នៃ​ឞ្រាស​យេឆូ ​ហោម​គុ​តា​ទូក ត៝ត់​កេង​មាង់​នារ​អី​នៃ​ដ៝ង់ ពាង់​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “ហោៈ ឞ៝ន់​ហាន់​ជឹត​កាល់​តី​ទាក​រី”។ ");
INSERT INTO cmok_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ជេស​រី​ខាន់​ពាង់​ញច៝​ទូក​នៃ​ទូ​ឞើស​ប៝ន​លាន​ហាន់​ជឹត​កាល់​តី​រី គែស​ទូក​អាបាៈ​ដ៝ង់​ហាន់​នទ្រែល​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ជេសរី​ទោ​មា​គែស​ផុត​ច្វាញ់​ទុត​ហោ​ងាន់។ ទាក​រាឞុស លាប់​តា​ទូក​រី​ឞើយ​មា​ឞេង។ ");
INSERT INTO cmok_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ល៝ង់​ឞ្រាស​យេឆូ ​រី​ពាង់​លែៈ​ហាក់​ឞិច​តា​ខានើយ​តា​ច្យាង់​ទូក​នៃ។ មពោល​អ៝ស​ម៝ន​រាលៃ​ពាង់៖ “ហើយ​នើម​នតី លែៈ​ខឹត​ងាន់​ឞ៝ន់! មើម​ឞិច​មៃ​ថើ​លាវើ​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ឞ្រាស​យេឆូ ​កាស​រាងាល់​ពាង់​ទ៝ក់​ដើប ឞ្វៃ​ផុត នទ្រែល​មា​ទាក​រាឞុស​នៃ៖ “ឞាស​ហ៝ម់! រាង៝ន់​ហ៝ម់!” ជេសរី​ផុត​ឞាស​ឆ្យាល​មោ​ហោម ទាក​រាឞុស​រាង៝ន់​ញជុប​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ឞ្រាស​យេឆូ ​លាស​ខាន់​ពាង់៖ “មើម​ទឹង​ខាន់​មៃ​ក្លាច​ហោ​អីរ​កើត​នៃ? មើម​ទឹង​មោ​ហោម​គែស​នាវ​ញឆីង​មា​គ៝ប់?” ");
INSERT INTO cmok_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ងាន់​ខាន់​ពាង់​តា​នៃ​ក្លាច​ញឆ៝រ់​ហោ ជេសរី​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ “ឞូ​ម៝ស​ពាង់​អី​នៃ​ហ្យាស ទឹង​គែស​មា​ផុត នទ្រែល​មា​ទាក​រាឞុស​អ្យាត់​នាវ​ពាង់?” ");
INSERT INTO cmok_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​អ៝ស​ម៝ន​ពាង់​ត៝ត់​កាល់​តី​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ ​រី ទាច់​នតុក​ប៝ន​កេរាឆីន ។ នតុក​ប៝ន​អី​នៃ​ឞូ​មោ​អោស​តឹង​នាវ​វៃ​ផូង​អីឆ្រាអែល ។ ");
INSERT INTO cmok_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ជេស​ឞ្រាស​យេឆូ ​ជុរ​ឞើស​ទូក​នៃ ទូ​ប្ល៝ត់​តា​នៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ឞ្រាស​អ្យើស​គុ​តា​ឆាក់​ពាង់ ពាង់​លោស​ឞើស​នតុក​មោច​អុច​ហាន់​ម៝ប់​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ពាង់​អី​នៃ​គុ​តា​នតុក​មោច​ទើម មោ​គែស​អោស​ឞូនុយ្ស​ទើយ​ញុប​ទើយ​ក៝ត់​ពាង់ ក៝ត់​ដាស​រាឆែ​រាវាក់​ក៝ៈ​មោ​ខាន​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ឞ៝ល​លាស​ឞូ​លែៈ​ងកោង​ជ៝ង់​តី ក៝ត់​ពាង់​ដាស​រាឆែ​រាវាក់​អ៝ក់​តឹ ពាង់​លើស​ងក្លាស​តាច់​លែៈ​ផ្យៅ​នទើ​អី​ឞូ​ងកោង​ឞូ​ក៝ត់​ពាង់​នៃ មោ​គែស​អោស​ឞូនុយ្ស​ទើយ​ដាប់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ទឹង​មាង់​ទឹង​នារ​ពាង់​គុ​រ៝ៈ​មោច​រ៝ៈ​យោក នអ៝ប់​មា​នតែរ ជេសរី​ឆ៝ៈ​លុ​មព្លោញ​ត៝រ​អេង​ឆាក់​ពាង់​នើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ត៝ត់​ពាង់​ឆៃ​ឞ្រាស​យេឆូ ​ឞើស​ងាយ ពាង់​ញច្វាត់​រាន​ច៝ន​កោម៝ក់​កុញ​ឞោក​ឞើស​នាប់​ឞ្រាស​យេឆូ ​រ៝‌ ");
INSERT INTO cmok_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ពាង់​នតែរ​ទុត​នតែសៗ​ងាន់៖ “ហើយ​ឞ្រាស​យេឆូ ​ក៝ន​កោរាញ​ឞ្រាស​ទុត​ព្រេស​តា​កាលើ​ត្រោក មើម​មៃ​ជាន​មា​គ៝ប់​មេស? ខឹត​អោម​លោម​លាៈ អ៝ន់​មៃ​ត៝ន​មា​គ៝ប់​តា​ឞើស​នាប់​កោរាញ​ឞ្រាស ទាន់​មៃ​លើយ​អោស​ងក្រីត​គ៝ប់!” ");
INSERT INTO cmok_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ទឹង​ឞ្រាស​អ្យើស​លាស​កើត​នៃ អាច​មា​ឞ្រាស​យេឆូ ​លែៈ​ជេស​លាស​ពាង់៖ “មពោល​ឞ្រាស​អ្យើស ទូ​ហ៝ម់​ឞើស​ឞូនុយ្ស​អ្យា!” ");
INSERT INTO cmok_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ជេសរី​ឞ្រាស​យេឆូ ​អោប​ពាង់៖ “មើម​រាញា​មៃ​មេស?” “គ៝ប់​រាញា «មពោល​តាហែន​អ៝ក់​រាឞាន់» យ៝រ​មា​ឞាល់​ហេន​អ៝ក់​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ពាង់​ឞ៝ញ​ឞ្រាស​យេឆូ ​ហ៝ល់​រាដ៝ក់៖ “លើយ​ទឹង​មព្រើស​ហេន​ទូ​លោស​ឞើស​ឞ្រី​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","កេង​នតុក​នៃ​គែស​ឆុរ​ទូ​ផូង​ក្វ៝ង់​គុ​ឆា​មពា​រ៝ៈ​ញជ៝ង់​យោក។ ");
INSERT INTO cmok_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ផូង​ឞ្រាស​អ្យើស​អី​នៃ​ទាន់​តៃ​ទុត​ហោ​ងាន់៖ “ទាន់​មៃ​ញជ្វាល់​អ៝ន់​ហេន​លាប់​តា​ឆុរ​ផូង​អី​រី​អើ!” ");
INSERT INTO cmok_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ជេសរី​ឞ្រាស​យេឆូ ​អ៝ន់​ខាន់​ពាង់​លាប់​តា​ឆុរ​រី។ ជេសរី​មពោល​ឞ្រាស​អ្យើស​អី​រី​លោស​ឞើស​ឞូនុយ្ស​អី​នៃ​លាប់​គុ​តា​ឆុរ​រី​លែៈ​រាង៝ត់។ ឆុរ​ផូង​អី​នៃ​ក្លាប់​លាស​អ៝ក់ ២០០០ មល៝ម់ ជេសរី​ញច្វាត់​រាឞុល​ជឹត​ឆ៝ប​រាប៝ង់​ជឹត​ទាក​ងលៅ​រី លាប់​តា​ទាក​រាម៝ក​ខឹត​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ជេសរី​មពោល​អី​ច្យាប់​ឆុរ​នៃ ញច្វាត់​មឞើស​ងក៝ច​នាវ​អី​នៃ​មា​ឞូ​រ៝ៈ​ប៝ន​រ៝ៈ​មីរ។ ឞូ​អី​តាង់​រាន​អ្វាញ់​នាវ​ត៝ត់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ខាន់​ពាង់​រាន​ត៝ត់​អា​ឞ្រាស​យេឆូ  ជេសរី​ឆៃ​ឞូនុយ្ស​អី​តាៈ​ឞ្រាស​អ្យើស​លាប់​អ៝ក់​ងាន់​នើស​គុ​តា​រី ញឆ៝ស​ឞ៝ក​អាវ​នហ៝​មា​កាស​គឹត​ឆាក់​ដ៝ង់ ជេស​ឆៃ​លែៈ​នាវ​នៃ​ខាន់​ពាង់​ក្លាច​ទាទេ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","មពោល​អី​ឆៃ​នហេល​មា​មាត់​លែៈ​នាវ​ត៝ត់​អី​គែស​តា​ឞូ​ក្លោ​អី​នៃ នទ្រែល​មា​ឆុរ​ផូង​នៃ​ដ៝ង់ ខាន់​ពាង់​មឞើស​ងក៝ច​មា​ផូង​ប៝ន​លាន​តា​នៃ​អ៝ន់​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ជេសរី​ប៝ន​លាន​ឞ៝ញ​ឞ្រាស​យេឆូ ​ដាៈ​ពាង់​ទូ​ឞើស​ឞ្រី​ប៝ន​ខាន់​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ជេសរី​ឞ្រាស​យេឆូ ​ញចោ​មា​ហាន់​ហាវ​កាលើ​ទូក​រី។ ឞូ​ក្លោ​អី​ឞ្រាស​អ្យើស​លាប់​អា​ល៝រ​នើស​ទាន់​តឹង​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","យើន​មា​ឞ្រាស​យេឆូ ​មោ​រ៝ម​អោស បេង​ពាង់​មា​ដាៈ៖ “ហាន់​មៃ​ឆឹត​អា​ជៃ​មៃ​នើម​រី មឞើស​ងក៝ច​មា​ឞាល់​មពោល​មៃ​លែៈ​នាវ​អី​កោរាញ​ឞ្រាស​លែៈ​ជាន​មា​មៃ​នើស នទ្រែល​មា​នាវ​អី​កោរាញ​ឞ្រាស​យោៈ​នអាច​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ជេសរី​ឞូ​ក្លោ​អី​នៃ​ហាន់​រ៝ នតើម​មឞើស​អ៝ន់​មា​ប៝ន​លាន​តា​ឞ្រី​ដេកាពោលីស ​អ៝ន់​ខាន់​ពាង់​គឹត​ទឹង​លែៈ​នាវ​អី​ឞ្រាស​យេឆូ ​ជាន​មា​ពាង់។ ជេស​តាង់​នាវ​ពាង់​មឞើស​ងក៝ច​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់​ប៝ន​លាន។ ");
INSERT INTO cmok_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ជេសរី​ឞ្រាស​យេឆូ ​ញច៝​ទូក​ត៝ត់​កាល់​តី​ទាក​រី ពាង់​គុ​តា​មែង​ទាក​ងលៅ​ក្វ៝ង់ តា​នៃ​គែស​ប៝ន​លាន​អ៝ក់​មពឺម​ងាន់​ហាន់​គុ​ញជ្វែង​ជុម​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ជេសរី​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​រាញា​យៃរុស ​ហាន់​តា​នៃ​ដ៝ង់ ពាង់​កោរាញ​ញីស​រាបុន​ផូង​អីឆ្រាអែល ។ ត៝ត់​ពាង់​ឆៃ​ឞ្រាស​យេឆូ ​ពាង់​រាន​ពាន់​តា​ជ៝ង់‌ ");
INSERT INTO cmok_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ពាង់​ឞ៝ញ​ជាៈ​ឞ្រាស​យេឆូ ​ហោ​ងាន់ ពាង់​លាស៖ “ហើយ​នើម​នតី ក៝ន​ឞូ​អូរ​គ៝ប់​ជី​ហោ​ងាន់​លែៈ​ឞើយ​ខឹត​មេ។ ទាន់​មៃ​ហាន់​តេៈ​តី​តា​ពាង់​អើ អ៝ន់​ឞាស​នាវ​ជី​លើយ​អ៝ន់​ពាង់​ខឹត!” ");
INSERT INTO cmok_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​នទ្រែល​ពាង់។ គែស​អ៝ក់​ងាន់​ផូង​ប៝ន​លាន​ហាន់​តឹង​ពាង់​ដ៝ង់ ត៝ត់​មា​តឹម​មពែត​ឞាល់​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","តា​មពោល​នៃ​គែស​ដ៝ង់​ទូ​ហ្វេ​ឞូ​អូរ​ជី​រីស​លែៈ​ជ៝ៈ ១២ នាម់​ហើយ។ ");
INSERT INTO cmok_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","នទ្រី​ពាង់​ញឆ្រោយ្ស​ងាន់​អ៝ត់​នាវ​ជី​អី​អ៝ក់​ផូង​នើម​ទាក​ឆី​ទែ​ឆាម់ តីស​មា​មោ​អោស​ទើយ​ឞាស។ ពាង់​ហ្វាច​លែៈ​ទ្រាប់​នទើ​ពាង់ មោ​ឆៃ​ឞាស​ដេៈ​រ៝ នាវ​ជី​ពាង់​លើ​មា​ហោ​លើ​មា​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ត៝ត់​ពាង់​គឹត​លឺ​ឞ្រាស​យេឆូ ​ហាន់​តា​នៃ ពាង់​រាន​ចុល​លាប់​តា​ងក្លាង​ឞាល់​អ៝ក់​ពាស​អី​អាវ​ក្វ៝ង់​ឞ្រាស​យេឆូ ​ឞើស​កើយ។ ");
INSERT INTO cmok_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ពាង់​មឹន​អេង៖ “លាស​គ៝ប់​គែស​ពាស​អី​អាវ​ពាង់ នាវ​ជី​គ៝ប់​ឞាស​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ជេស​ពាង់​ពាស​អាវ​ឞ្រាស​យេឆូ ​នៃ មហាម​ពាង់​ឞាស​នទាល​តា​នៃ​រ៝ មោ​ហោម​ត្រោស​អោស។ ជេសរី​ពាង់​គឹត​អេង​តា​ឆាក់​នាវ​ជី​ពាង់​លែៈ​ឞាស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","នោក​នៃ​ឞ្រាស​យេឆូ ​គឹត​រ៝​គែស​លោស​នាវ​ឞ្រាស​តាៈ​ឞើស​ឆាក់​ពាង់ ជេសរី​ពាង់​រាលែ​ជឹត​ផូង​ប៝ន​លាន​នៃ​លាស៖ “ឞូ​ម៝ស​ពាស​អាវ​គ៝ប់​ហ្យាស?” ");
INSERT INTO cmok_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","មពោល​អ៝ស​ម៝ន​ពាង់​អើស៖ “ហើយ​កោរាញមៃ​ឆៃ​ហើយ​គែស​ឞូនុយ្ស​អ៝ក់​ងាន់​តឹម​មពែត​ឞាល់​គែស​ពាស​មៃ​ទាទេ។ មើម​ទឹង​មៃ​អោប​លាស៖ ឞូ​ម៝ស​ពាស​គ៝ប់?” ");
INSERT INTO cmok_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ជេសរី​ឞ្រាស​យេឆូ ​អ្វាញ់​ជុម​ពាង់​នើម អុច​គឹត​ឞូ​ម៝ស​អី​ពាស​អាវ​ពាង់​អា​នទើស​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ឞូ​អូរ​អី​នៃ​ក្លាច​ញឆ៝រ់​ងាន់ ឆៃ​នាវ​ទើយ​តា​ឆាក់​ពាង់​នើម ពាង់​ពាន់​តា​ជ៝ង់​ឞ្រាស​យេឆូ ​ជេសរី​មឞើស​លែៈ​នាវ​អី​នៃ មោ​ពាង់​ម៝​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ឞ្រាស​យេឆូ ​លាស​មា​ឞូ​អូរ​នៃ៖ “ហើយ​អ៝ស! នាវ​អៃ​ញឆីង​មា​គ៝ប់​ជាន​ឞាស​អៃ​ហើយ ឆឹត​អ៝ន់​អ្វែស​លាង់​ដាប់​មពាន់​យឹ។ នាវ​ជី​អៃ​អ៝ន់​ឞាស​ដ៝ង់!” ");
INSERT INTO cmok_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","នោក​ឞ្រាស​យេឆូ ​ហោម​អែ​ងើយ​នៃ គែស​ឞូនុយ្ស​អាបាៈ​តាៈ​ឞើស​ជៃ​យៃរុស ​មឞើស​លាស៖ “ក៝ន​ឞូ​អូរ​មៃ​លែៈ​ខឹត​មេ។ ម៝ស​នាវ​ហោម​រាខ្វាក​នើម​នតី​នៃ​ជឹត​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ឞ្រាស​យេឆូ ​តាង់​ដ៝ង់​នាវ​អី​ឞូ​មឞើស​នៃ លើ​ពាង់​មា​លាស​មា​យៃរុស ៖ “លើយ​ទឹង​ក្លាច​អោស អ៝ន់​មៃ​ញឆីង​មា​គ៝ប់​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់ មោ​អោស​រ៝ម​ឞូ​អាបាៈ​ហាន់​តឹង​ពាង់។ ពាង់​រ៝ម​ពែ​នុយ្ស​ពេត្រោស យាកើ  នទ្រែល​មា​យោហាន ​អី​អ៝ស​យាកើ ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ត៝ត់​តា​ជៃ​យៃរុស ​អី​កោរាញ​ញីស​រាបុន​នៃ ឞ្រាស​យេឆូ ​តាង់​ឞូ​ញុម​វើល​ទុត​នតែស​អុស​អាស​គាស​គាយ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ឞ្រាស​យេឆូ ​លាប់​តា​ត្រោម​ជៃ​លាស​មា​ខាន់​ពាង់៖ “ម៝ស​នាវ​ញុម​ខាន់​អៃ​មៃ​អុស​អាស​គាស​គាយ​នៃ? មោ​ខឹត​អោស​ក៝ន​ឆែ​អ្យា មាន​មា​ហាក់​ឞិច​ទើម!” ");
INSERT INTO cmok_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ជេស​តាង់​នាវ​នៃ​ខាន់​ពាង់​គើម​មឺច​មា​ឞ្រាស​យេឆូ ។ ជេសរី​ឞ្រាស​យេឆូ ​មព្រើស​ខាន់​ពាង់​លោស​អា​ទីស​លែៈ​រាងោច ពាង់​ជាៈ​អី​មេៈ​ឞឹ​ក៝ន​ឆែ​នៃ នទ្រែល​មា​ពែ​នុយ្ស​មពោល​អ៝ស​ម៝ន​ពាង់​លាប់​តា​ត្រោម​ជ្រោ​នតុក​ក៝ន​ឆែ​ឞិច​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ជេសរី​ពាង់​ញុប​តី​ក៝ន​ឆែ​នៃ នហ៝​ពាង់​លាស៖ “តាលីថា​កូមី ” - រាឞ្លាង​លាស «ហើយ​អ៝ស អៃ​ទ៝ក់​ហ៝ម់!» ");
INSERT INTO cmok_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ទោ​មា​ក៝ន​ឆែ​ឞូ​អូរ​នៃ​ទ៝ក់​ដើប ឞ្រោៈ​រ៝។ ឞូនុយ្ស​អី​គុ​នទ្រែល​តា​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ទុត​ហោ​ងាន់។ ក៝ន​ឆែ​នៃ​លែៈ​គែស ១២ នាម់​ហើយ។ ");
INSERT INTO cmok_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","យើន​មា​ឞ្រាស​យេឆូ ​ឞ្វៃ​ខាន់​ពាង់ មោ​អោស​អ៝ន់​មឞើស​ងក៝ច​មា​ឞូ​គឹត​នាវ​អ្យា ជេសរី​ដាៈ​ខាន់​ពាង់​ឆ៝ៈ​នទើ​អ៝ន់​ក៝ន​ឆែ​នៃ​ឆោង​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​នតុក​នៃ​ព្លឹ​ឆឹត​តា​ប៝ន​ឞ្រី​ពាង់​នើម​តា​ប៝ន​នាឆារែត  មពោល​អ៝ស​ម៝ន​តឹង​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ត៝ត់​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល ​រី ពាង់​លាប់​តា​ត្រោម​ញីស​រាបុន​នតុម​នតី​ឞូ គែស​អ៝ក់​ឞូនុយ្ស​អី​តាង់​នាវ​ពាង់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់ ខាន់​ពាង់​អោប​នទ្រាង់​ខាន់​ពាង់​លាស៖ “ឞើស​តាៈ​គឹត​នាវ​ពាង់​អី​នៃ​ហ្យាស? នាវ​មឹន​គឹត​ឞ្លាវ​ពាង់​នៃ​ឞើស​តាៈ​ឆ៝ៈ? នទើ​អ្វែស​នទើ​ខ្លៃ​ពាង់​ទើយ​ជាន​នើស​ឞើស​តាៈ​ទើយ? ");
INSERT INTO cmok_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ពាង់​នៃ​មោ​ទី​អី​ក៝ន​មារី ​ជាន​ការ​តើម​ឆី អី​នោ​យាកើ យោឆែប យូដាស  នទ្រែល​មា​ឆីមោន ​បាស? អី​អ៝ស​ឞូ​អូរ​ពាង់​គុ​តា​ប៝ន​អ្យា​នទ្រែល​ឞ៝ន់​ដ៝ង់!” នទ្រី​ទឹង​ខាន់​ពាង់​ជី​នូយ្ស ក៝ៈ​នូយ្ស​ក៝ៈ​នហ៝ម់​មោ​អុច​អ្យាត់​នាវ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​អី​ឞូ​យើក យើន​មា​ឞូនុយ្ស​តា​ប៝ន​ពាង់​នើម តា​មពោល​ឞាល់ នទ្រែល​មា​តា​ជៃ​ពាង់​នើម​វៃ​មឺច​រាម៝ត​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","លាស​នទ្រី​តា​ប៝ន​នៃ​ពាង់​មោ​អោស​ទើយ​ជាន​នទើ​អ្វែស​នទើ​ខ្លៃ​អ៝ក់ មាន​មា​តេៈ​តី​កាលើ​ឞូនុយ្ស​ជី​អាបាៈ​ទើម​គៃ​មា​អ៝ន់​ឞាស​ជី។ ");
INSERT INTO cmok_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ពាង់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់​យ៝រ​មា​មោ​ឆៃ​ខាន់​ពាង់​គែស​នាវ​ញឆីង​កើត​នៃ។ ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​រ៝ៈ​ប៝ន​អេងៗ នហ៝​មា​នតុម​នតី​អ៝ន់​ឞូ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ពាង់​ក្វាល់ ១២ នុយ្ស​មពោល​អ៝ស​ម៝ន​វាច់​អា​ពាង់ ជេសរី​ដាៈ​ខាន់​ពាង់​ហាន់​ឞារ​ហៃ​ឞារ​ហៃ​រ៝ៈ​ប៝ន​អេងៗ នហ៝​មា​អ៝ន់​នាវ​ទើយ​តា​ខាន់​ពាង់​មព្រើស​ឞ្រាស​អ្យើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ពាង់​នតិញ​មា​ខាន់​ពាង់៖ “ហើយ​អ៝ស​នោ លើយ​អោស​ញអោត​នទ៝ស​នទើ​ហាន់​ត្រ៝ង ញអោត​ម៝ង់​ជ្រា​ហ៝ៈ លើយ​ញអោត​នទើ​ឆោង​ឆា ទុង​ចែង មោ​លាស​ព្រាក់​រៀល​ងការ់​ឆាក់‌ ");
INSERT INTO cmok_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ហាន់​ញឆ៝ស​នតោ​ជ៝ត លើយ​អោស​ញឆ៝ស​អាវ​ក្វ៝ង់​ឞារ​ឞ្លាស”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ពាង់​លាស​មា​ខាន់​ពាង់​ជឹត៖ “ម៝ស​ជៃ​ខាន់​មៃ​លាប់​នៃ គុ​តា​ជៃ​នៃ​ហ៝ៈ​នហ៝​មា​ត៝ត់​ខាន់​មៃ​លោស​ឞើស​ប៝ន​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","លាស​គែស​ប៝ន​អី​មោ​រ៝ម​មោ​អ្យាត់​ខាន់​មៃ លោស​ឞើស​ប៝ន​អី​នៃ ជេសរី​រាតោស​នែស​មោយ​ឞើស​ជ៝ង់​ខាន់​មៃ​នើម គៃ​មា​ញហើ​លាស​ប៝ន​អី​នៃ​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ជេសរី​មពោល​អ៝ស​ម៝ន​ពាង់​លោស​ឞើស​នៃ​ហាន់​នតុម​នតី​ដាៈ​ឞូ​រាគ៝ល់​នូយ្ស​នហ៝ម់​អ្យើស។ ");
INSERT INTO cmok_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","មពោល​ខាន់​ពាង់​ទើយ​មព្រើស​ឞ្រាស​អ្យើស​អ៝ក់​លោស​ឞើស​ឞូនុយ្ស នហ៝​មា​ត៝ៈ​ទាក​ងី​តា​ឞូនុយ្ស​ជី​អ៝ក់​ងាន់​អ៝ន់​ឞាស​ឞើស​នាវ​ជី។ ");
INSERT INTO cmok_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ជេសរី​កាដាច់​ហេរោត-​អ៝ន់តីពាស ​គឹត​រ៝​នាវ​ឞ្រាស​យេឆូ ​ជាន យ៝រ​មា​លឺ​ឆាក់​ឞ្រាស​យេឆូ ​នៃ​ហោ​ងាន់។ គែស​ឞូ​បាបាៈ​ងើយ​លាស៖ “យោហាន-​បាប់តែម ​លែៈ​ទ៝ក់​រេស​តៃ នទ្រី​ទឹង​ពាង់​អី​នៃ​គែស​នាវ​ទើយ​ជាន​លែៈ​នាវ​កើត​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ឞូ​អាបាៈ​អេង​លាស៖ “ពាង់​អី​នៃ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​រាញា​អេលីយា ”។ ឞូ​អាបាៈ​ជឹត​លាស៖ “ពាង់​អី​នៃ​ទូ​ហ្វេ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​តឹម​ឞាន​មា​ឞូនុយ្ស​នតើយ្ស​រានោក​កាល់​អែ​នើស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ល៝ង់​កាដាច់​ហេរោត ​រី ជេស​ពាង់​គឹត​លែៈ​នាវ​អី​នៃ ពាង់​លាស៖ “ពាង់​អ្យា​ងាន់​យោហាន ​អី​គ៝ប់​ដាៈ​តាហែន​ក៝ស​ត៝ង​ក៝​នើស អាបៃ​ពាង់​លែៈ​ទ៝ក់​រេស​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","កាដាច់​ហេរោត ​លាស​នទ្រី យ៝រ​លាស​ឞើស​នតើម​នើស​ពាង់​ដាៈ​តាហែន​ញុប​យោហាន ​ក៝ត់​ក្រុង​តា​នទ្រូង​រី យ៝រ​មា​នាវ​ពីត​អូរ​អី​អ៝ស​ពាង់​រាញា​ផីលីប  ជេសរី​កាដាច់​ហេរោត ​ឆ៝ៈ​នទាៈ​អី​អូរ​ផីលីប ​រាញា​ហេរោដៀស ​ជាន​អូរ​ឆាយ។ ");
INSERT INTO cmok_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ជេស​គឹត​នទ្រី​យោហាន ​លែៈ​ជេស​លាស​កាដាច់​ហេរោត ៖ “មោ​អោស​ទី​ដាស​នាវ​វៃ​មៃ​ឆ៝ៈ​អូរ​អ៝ស​ជាន​អូរ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ជេសរី​ហេរោដៀស ​ជី​នូយ្ស​អុច​ងខឹត​លើយ​យោហាន ​នៃ មោ​ទើយ​អោស យ៝រ​មា​កាដាច់​ហេរោត ​មោ​អ៝ន់។ ");
INSERT INTO cmok_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","កាដាច់​ហេរោត ​ក្លាច​យោហាន-​បាប់តែម  កើប​ពាង់​ឞូនុយ្ស​ឆ៝ង់​ឞូនុយ្ស​ក្ល៝ស​អ្វែស។ នទ្រី​កាដាច់​ហេរោត ​អុច​ងកីង​ពាង់​ឞើស​ហេរោដៀស ។ កាដាច់​ហេរោត ​អុច​ងាន់​តាង់​នាវ​ពាង់​ងើយ យើន​មា​នាវ​ងើយ​អី​នៃ​ជាន​អ៝ន់​តា​នូយ្ស​នហ៝ម់​កាដាច់​ហេរោត ​គែស​នាវ​មឹន​រាវៃ​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","គែស​ទូ​នារ​រី​ទី​នារ​កាស​គឹត​នារ​ទែស​កាដាច់​ហេរោត  ពាង់​នទ្រាប់​នាវ​ញេត​ឆោង​ក្វ៝ង់​ងាន់។ ពាង់​ជាៈ​ឞូនុយ្ស​អី​កើល​ពាង់​ម៝ត់​អ្វាញ់ ជាៈ​កោរាញ​តាហែន នទ្រែល​មា​ឞូនុយ្ស​តេស​ឞូនុយ្ស​នទ្រ៝ង់​អី​គុ​តា​ឞ្រី​កាលីលេ ​នៃ។ តា​នារ​នៃ​រ៝​គែស​នាវ​ឞូ​អូរ​ហេរោដៀស ​ទើយ​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ជេសរី​អី​ក៝ន​ទ្រោស​ហេរោដៀស ​លាប់​រ៝ម់​តា​នតុក​ញេត​ឆោង​នៃ ត៝ត់​កាដាច់​ហេរោត  នទ្រែល​មា​ទឹង​លែៈ​ឞូ​នាច់​អី​គុ​តា​នៃ​ឆៃ ខាន់​ពាង់​រាម់​ងាន់ ជេសរី​កាដាច់​លាស​មា​ពាង់៖ “ម៝ស​នទើ​អៃ​អុច ទាន់​មា​គ៝ប់​ទោ គ៝ប់​អ៝ន់​មា​អៃ​រ៝!” ");
INSERT INTO cmok_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","នហ៝​មា​ត៝ន​លាស៖ “ម៝ស​នតីល​នទើ​អៃ​ទាន់​មា​គ៝ប់ គ៝ប់​អ៝ន់​មា​អៃ​រ៝ ឞ៝ល​លាស​ព្លាស​ទូ​ដាស​ឞ្រី​អី​គ៝ប់​ម៝ត់​អ្វាញ់​កាដោយ”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ឞូ​ទ្រោស​នៃ​លោស​ប្ហុច​ឞើស​នតុក​នៃ​ហាន់​អោប​អី​មេៈ​ពាង់៖ “ហើយ​មេៈ ម៝ស​នទើ​គ៝ប់​ទាន់​អេស?” អី​មេៈ​ពាង់​អើស៖ “ទាន់​អី​ឞោក​យោហាន-​បាប់តែម !” ");
INSERT INTO cmok_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ជេសរី​ពាង់​ព្លឹ​ឞ្រុល​ឞើស​នៃ​មឞើស​មា​កាដាច់​នៃ​រ៝៖ “គ៝ប់​អុច​ទាន់​អី​ឞោក​យោហាន-​បាប់តែម ​តេៈ​កាលើ​ងាន​ថាង​អាបៃ​រី​រ៝!” ");
INSERT INTO cmok_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ជេស​តាង់​នាវ​ទាន់​អី​នៃ​កាដាច់​នទុយ្ស​តោរ​ហោ​ងាន់ តីស​មា​មោ​រាលាច់​អោស យ៝រ​មា​កាដាច់​លែៈ​ជេស​ត៝ន​ឞើស​នាប់​ផូង​ឞូ​នាច់​អី​គុ​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","កាដាច់​ដាៈ​រ៝​ទូ​ហ្វេ​តាហែន​ហាន់​ឆ៝ៈ​អី​ឞោក​យោហាន ។ ត៝ត់​តា​នទ្រូង​រី ពាង់​ក៝ស​ត៝ង​ក៝​យោហាន ‌ ");
INSERT INTO cmok_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ឆ៝ៈ​អី​ឞោក​តេៈ​កាលើ​ងាន​ថាង ជេសរី​នទឹ​អ៝ន់​មា​ឞូ​ទ្រោស​នៃ។ ឞូ​ទ្រោស​អី​នៃ​ញអោត​នទឹ​អ៝ន់​មា​អី​មេៈ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ត៝ត់​មពោល​អ៝ស​ម៝ន​យោហាន ​គឹត​នាវ​អី​នៃ ខាន់​ពាង់​លែវ​ឞាល់​ហាន់​ឆ៝ៈ​អី​ឆាក់​ពាង់​ញជ៝រ​តា​ត្រោម​មោច​លុ។ ");
INSERT INTO cmok_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ជេស​មពោល​កោរាញ​អ៝ស​ម៝ន​ឞ្រាស​យេឆូ ​ព្លឹ​ឆឹត​ឞើស​នតុក​អេងៗ ខាន់​ពាង់​ងក៝ច​មា​ឞ្រាស​យេឆូ ​ទឹង​លែៈ​នទើ​អី​ខាន់​ពាង់​ជាន នទ្រែល​មា​នាវ​ខាន់​ពាង់​គែស​នតុម​នតី​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","តា​នតុក​នៃ​គែស​អ៝ក់​ឞូនុយ្ស​ហាន់​លោស​លាប់ នទ្រី​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​គៃ​មា​ឆោង​ឆា​មោ​អោស​ទើយ​រូ។ ជេសរី​ឞ្រាស​យេឆូ ​ដាៈ​មពោល​អ៝ស​ម៝ន​ពាង់៖ “ហោៈ​ហាន់​លែវ​ឞាល់​ជ៝យ​នតុក​បាស​ងាយ​មា​ផូង​ប៝ន​លាន រាលូ​ទូ​នទ៝ម់​ប៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ជេសរី​ខាន់​ពាង់​លោស​ឞើស​នតុក​នៃ​ជុរ​ញច៝​ទូក​ហាន់​ជឹត​នតុក​អេង​បាស​មា​ឞូ។ ");
INSERT INTO cmok_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ខាន់​ពាង់​ញច៝​ទូក​រ៝ៈ​ទាក​នៃ​គែស​អ៝ក់​ឞូនុយ្ស​ឆៃ​គឹត​នាល់​ខាន់​ពាង់​អី​នៃ។ ត៝ត់​ប៝ន​លាន​គឹត​នតុក​ពាង់​ហាន់​រី ជេសរី​លែវ​ឞាល់​លោស​តាៈ​ឞើស​ប៝ន​អេងៗ ញច្វាត់​គ្រុង​ល៝រ​ឞើស​នាប់​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","នោក​ឞ្រាស​យេឆូ ​ជុរ​ឞើស​ទូក​នៃ​ឆៃ​ផូង​ប៝ន​លាន​អ៝ក់​មពឺម​ងាន់ ពាង់​គែស​នាវ​យោៈ​នអាច​មា​ខាន់​ពាង់​ងាន់ ឆៃ​ខាន់​ពាង់​អី​នៃ​តឹម​ឞាន​មា​ផូង​ឞែ​ឞ្យាប់​អី​មោ​គែស​ឞូនុយ្ស​ម៝ត់​អ្វាញ់។ នទ្រី​ពាង់​នតុម​នតី​អ៝ក់​នតីល​នាវ​អ៝ន់​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ត៝ត់​នារ​លែៈ​ទេស មពោល​អ៝ស​ម៝ន​ហាន់​មឞើស​មា​ឞ្រាស​យេឆូ ​លាស៖ “តា​អ្យា​នតុក​រាទាស​ងាយ​ឞើស​ប៝ន​មោ​អោស​គែស​នទើ​ឆា នារ​លែៈ​ឞើយ​ញ៝ប់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","មៃ​ដាៈ​ខាន់​ពាង់​ព្លឹ​ឆឹត​ជ៝យ​នទើ​រាវាត់​មា​ឆោង​ឆា​រ៝ៈ​ជៃ​រ៝ៈ​ប៝ន​អី​ទាច់ៗ​អ៝យ​តា​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់​លាស៖ “ខាន់​មៃ​អ៝ន់​ឞូ​ឆោង​ឆា​ហែស!” ខាន់​ពាង់​អើស​លាស៖ “នទ្រី​ហេន​ឆ៝ៈ​ព្រាក់ ២០០ ព្រាក់​កាក់ ហាន់​រាវាត់​នុមពាង់​អ៝ន់​មា​ផូង​ប៝ន​លាន​ទែ​ឆា​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “អ្វាញ់​ប៝ត់​ហែស ទាស​អ៝ក់​គែស​នុមពាង់​ខាន់​មៃ?” ត៝ត់​មា​គឹត​នៃ​ខាន់​ពាង់​មឞើស​មា​ពាង់៖ “គែស​ព្រាម់​មល៝ម់​នុមពាង់ ឞារ​មល៝ម់​កា​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ជេសរី​ឞ្រាស​យេឆូ ​មឞើស​មា​មពោល​អ៝ស​ម៝ន​ពាង់ ដាៈ​ផូង​ប៝ន​លាន​គុ​ទូ​មពោល​ទូ​មពោល កាលើ​រេប​ញឆែ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","នទ្រី​ខាន់​ពាង់​គុ មពោល​អាបាៈ​គែស ១០០ នុយ្ស មពោល​អាបាៈ​គែស ៥០ នុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ជេសរី​ឞ្រាស​យេឆូ ​ឆ៝ៈ​ព្រាម់​មល៝ម់​នុមពាង់ នទ្រែល​មា​ឞារ​មល៝ម់​កា​រី ពាង់​ងគើរ​មាត់​ជឹត​លើ​មឞើស​ឆើម​នទើ​ឆោង​ឆា​អី​នៃ​មា​កោរាញ​ឞ្រាស។ លោច​ជេស​ពាង់​គិច​នុមពាង់​អី​នៃ​នទឹ​អ៝ន់​អ៝ស​ម៝ន ដាៈ​ខាន់​ពាង់​ពាៈ​អ៝ន់​ឞូ​ឆា នហ៝​មា​ពាៈ​កា​អី​ឞារ​មល៝ម់​នៃ​អ៝ន់​ទឹង​លែៈ​ឞូនុយ្ស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ជេស​តឹម​ពាៈ​នទើ​ឆា​អី​រី ទឹង​លែៈ​ឞូនុយ្ស​គុ​ឆា​តា​នៃ​ហើម​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ជេសរី​មពោល​អ៝ស​ម៝ន​រាគូម​នុមពាង់ នទ្រែល​មា​កា​អី​ហោម​រាមែស​នៃ​គែស ១២ ឆាស។ ");
INSERT INTO cmok_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ផូង​ប៝ន​លាន​អី​ឆា​នៃ​នើស​កើប​អី​ឞូ​ក្លោ​អ៝ក់ ៥០០០ នុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ទូ​នទ៝ម់​នៃ ឞ្រាស​យេឆូ ​ដាៈ​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​ល៝រ​ញច៝​ទូក​មពែស​ជឹត​កាល់​តី​ទាក​រី ជឹត​ប៝ន​បេតឆៃដា ​រី ជេសរី​ពាង់​ដាៈ​ទឹង​លែៈ​ផូង​ប៝ន​លាន​អី​គុ​តា​នៃ​ព្លឹ​ឆឹត។ ");
INSERT INTO cmok_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ជេស​ដាៈ​នទ្រី​ឞ្រាស​យេឆូ ​លោស​ឞើស​នៃ​ហាន់​ហាវ​កាលើ​យោក​មឞើស​ឆើម​តា​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ត៝ត់​នារ​លែៈ​ញ៝ប់​ទូក​អី​អ៝ស​ម៝ន​ញច៝​នៃ​ញចោ​មា​តា​ងក្លាង​ទាក​ងលៅ​ក្វ៝ង់​រី អី​ឞ្រាស​យេឆូ ​រី​ហោម​គុ​អេង​កាលើ​កើស។ ");
INSERT INTO cmok_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ពាង់​អ្វាញ់​ឆៃ​មពោល​អ៝ស​ម៝ន​ពាង់​វាស​ទូក​រាន​ហ្វាន​ជេរ​ងាន់​ហាន់​រាលឹ​ជឹត​តើម​ឆ្យាល។ ត៝ត់​ឞ្រី​លែៈ​ឞើយ​អាង​ឞ្រាស​យេឆូ ​ឞ្រោៈ​កាលើ​ទាក​ងលៅ​ក្វ៝ង់​រី​ឞ្រោៈ​ទាច់​កេង​អ៝ស​ម៝ន​ពាង់ ជេសរី​ពាង់​អុច​ហាន់​នហ៝ត។ ");
INSERT INTO cmok_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ត៝ត់​ឆៃ​ពាង់​ឞ្រោៈ​កាលើ​ទាក​ងលៅ​នៃ ខាន់​ពាង់​នតែរ​ទ្រើវ នអោន​លាស​ច្យាក​ញហូ។ ");
INSERT INTO cmok_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","លែៈ​ខាន់​ពាង់​ឆៃ​ទាទេ​ក្លាច​ញឆ៝រ់​ងាន់ នទ្រី​ឞ្រាស​យេឆូ ​ងើយ​មា​ខាន់​ពាង់​រ៝៖ “លើយ​ក្លាច​អោស អ៝ន់​នូយ្ស​នហ៝ម់​ឞាញ់ គ៝ប់​យា!” ");
INSERT INTO cmok_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ជេសរី​ពាង់​ហាវ​ញច៝​ទូក​នទ្រែល​ខាន់​ពាង់ ឆ្យាល​ទោ​មា​ឞាស​រាង៝ន់​ញជុប​រ៝។ នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់​មពោល​អ៝ស​ម៝ន​តា​នៃ‌ ");
INSERT INTO cmok_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","យ៝រ​លាស​ខាន់​ពាង់​មោ​ហ៝ៈ​អោស​ទើយ​គឹត​នាវ​នុមពាង់​នើស ខាន់​ពាង់​ហោម​ទាង់​ក៝។ ");
INSERT INTO cmok_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​អ៝ស​ម៝ន​ត៝ត់​មពែស​កាល់​តី​ទាក​រី តា​ឞ្រី​កេនេឆារែត ។ ខាន់​ពាង់​ញឆ្រុង​តា​នៃ​ក៝ត់​ទូក​តា​មែង​ទាក​រី‌ ");
INSERT INTO cmok_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ជេសរី​ខាន់​ពាង់​ហាវ​កាលើ​កើស។ ត៝ត់​មា​ឆៃ ទឹង​លែៈ​ឞូនុយ្ស​អី​គុ​តា​នៃ​គឹត​នាល់​ពាង់​រ៝‌ ");
INSERT INTO cmok_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","នទ្រី​ឞូ​ហាន់​ញច្វាត់​តាៈ​ឞើស​អាប់​នតុក​ប៝ន លែវ​ឞាល់​តូង​ឞូនុយ្ស​ជី​ហាន់​តា​នតុក​អី​ឞូ​លឺ​លាស​ពាង់​គុ​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","អាប់​នតុក​អី​ឞ្រាស​យេឆូ ​ហាន់ ឞ៝ល​លាស​តា​ឞ្រី​តា​ប៝ន មោ​លាស​តា​ប៝ន​ក្វ៝ង់​កាដោយ ឞូ​លែវ​ឞូនុយ្ស​ជី​អ៝ន់​គុ​តា​នតុក​ឞូ​តាច់​ទ្រាប់ ជេសរី​ទាន់​ឞ៝ញ​ពាង់​ឆើម​មា​គែស​ពាស​ច្យាង់​អាវ​ក្វ៝ង់​ពាង់​ដេៈៗ​អែង នទ្រី​ទឹង​លែៈ​ឞូនុយ្ស​អី​គែស​ពាស​អាវ​ក្វ៝ង់​ពាង់​ឞាស​ទាទេ​រ៝​នាវ​ជី។ ");
INSERT INTO cmok_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","គែស​ទូ​នារ​រី​ផូង​ផារីឆី  នទ្រែល​មា​នើម​នតី​អាបាៈ​តាៈ​ឞើស​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​ហាន់​ម៝ប់​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ត៝ត់​តា​នៃ​ខាន់​ពាង់​ឆៃ​មពោល​អ៝ស​ម៝ន​ឞ្រាស​យេឆូ ​ឆោង​ឆា​មា​តី​អី​ខាន់​ពាង់​កើប​មោ​ក្ល៝ស​តឹង​មា​នាវ​វៃ​អើម​ដាៈ យ៝រ​មា​មពោល​អ៝ស​ម៝ន​អី​នៃ​មោ​រាវ​តី​ល៝រ​ឆោង​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ផូង​ផារីឆី  នទ្រែល​មា​ផូង​អីឆ្រាអែល ​ទឹង​លែៈ​ញអោត​តឹង​នាវ​វៃ​អើម​ឞើស​ឞូ​រាញ​ខាន់​ពាង់​នើម​កាល់​អែ​នើស អេ​ល៝រ​មា​ឆោង​ឆា​ខាន់​ពាង់​រាវ​តី រី​មើ​ឆោង​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","គែស​ដ៝ង់​ឆឹត​តាៈ​ឞើស​នតុក​ឞូ​តាច់​ទ្រាប់ លាស​ខាន់​ពាង់​ឆោង​ឆា​មោ​គែស​រាវ​តឹង​នាវ​វៃ​ល៝រ នទ្រី​ក្លាច​កោរាញ​ឞ្រាស​មោ​ឆ៝ៈ​ទើន។ ខាន់​ពាង់​ញអោត​មោ​នត្លើយ​នាវ​វៃ​អេងៗ​អ៝ក់​ដ៝ង់ កើត​មា​រាវ​កែវ​រាវ​នទ៝ស​រាវ​គ្លាស​ជាន​មា​កោង​រាវ​គ្រែ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","នទ្រី​ផូង​ផារីឆី  នទ្រែល​មា​ផូង​នើម​នតី​អោប​ឞ្រាស​យេឆូ ​លាស៖ “ម៝ស​នាវ​មពោល​អ៝ស​ម៝ន​មៃ​មោ​ញអោត​តឹង​នាវ​វៃ​អើម​ឞូ​រាញ ឆោង​ឆា​មា​តី​មោ​ក្ល៝ស​កើត​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “នាវ​អេឆាយ ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​លែៈ​ញចីស​កាល់​អែ​នើស គ៝ប់​លែៈ​ឆៃ​ពាង់​ញចីស​តឹម​ទី​ដាស​ខាន់​មៃ។ ខាន់​មៃ​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម អេឆាយ ​លែៈ​ញចីស​លាស៖ «កោរាញ​ឞ្រាស​លាស៖ «ផូង​ប៝ន​លាន​អ្យា​យើក​មឞាស​គ៝ប់​មា​ឞ៝រ់​មឞូង​ទើម‌ តា​នូយ្ស​នហ៝ម់​ខាន់​ពាង់​គុ​ងាយ​ដាស​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ខាន់​ពាង់​យើក​មឞាស​មា​គ៝ប់​មោ​គែស​អោស​នតីល​ខ្លៃ ដេៈ​មោ​អើម‌ យ៝រ​មា​ខាន់​ពាង់​នតុម​នតី​ឆ៝ៈ​នាវ​វៃ​តាៈ​ឞើស​ឞូនុយ្ស​ទើម។ តីស​មា​ខាន់​ពាង់​លាស​មរោស​នាវ​វៃ​អី​នៃ​តាៈ​ឞើស​គ៝ប់​ដាៈ»»។ ");
INSERT INTO cmok_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","នាវ​វៃ​អី​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ខាន់​មៃ​មអារ់​លើយ បេង​មា​ញអោត​តឹង​នាវ​វៃ​ឞូនុយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ពាង់​លាស​ជឹត៖ “ខាន់​មៃ​ឞ្លាវ​ងាន់​តឹង​នាវ​វៃ​ឞូនុយ្ស​នហ៝​មា​មោ​ហោម​អ្យាត់​នាវ​វៃ​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","នតឹត​លាស​មោឆេ ​លែៈ​ញចីស​កាល់​អែ​នើស​លាស៖ «អ៝ន់​ខាន់​អៃ​មៃ​យើក​មឞាស​ហ៝ម់​មា​មេៈ​ឞឹ» ជេសរី «ឞូ​ម៝ស​រាក​ឆ្វាយ​មា​មេៈ​ឞឹ​ពាង់​នើម ពាង់​អី​នៃ​គែស​ទោយ្ស​ត៝ត់​ឞូ​ងខឹត​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","តីស​មា​ខាន់​មៃ​លាស​នអា៖ «លាស​ទូ​ហ្វេ​ឞូនុយ្ស​ងើយ​មា​អី​មេៈ​ឞឹ​លាស ម៝ស​នទើ​អី​គ៝ប់​អុច​កើល​មា​មេៈ​ឞឹ នទើ​អី​នៃ​លាស​លែៈ​កោរបាន់ » - នាវ «កោរបាន់ » អ្យា​រាឞ្លាង​លាស «នទើ​ញហើរ​មា​កោរាញ​ឞ្រាស»។ ");
INSERT INTO cmok_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ជេសរី​ឞូនុយ្ស​អី​ងើយ​កើត​នអៃ ខាន់​មៃ​មោ​ហោម​អោស​អ៝ន់​ពាង់​កើល​មា​មេៈ​ឞឹ។ ");
INSERT INTO cmok_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","នទ្រី​ទឹង​ខាន់​មៃ​ជូត​លើយ​នាវ​វៃ​កោរាញ​ឞ្រាស ងខើង​មា​ឆ៝ៈ​នាវ​វៃ​អើម​ឞើស​ឞូ​រាញ។ ខាន់​មៃ​ជាន​នទើ​អេងៗ​អ៝ក់​ងាន់ កើត​នទើ​អី​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ជេសរី​ឞ្រាស​យេឆូ ​ក្វាល់​លែៈ​ផូង​ប៝ន​លាន​អី​គុ​ទាច់​តា​នៃ លាស​មា​ខាន់​ពាង់៖ “លែៈ​អ៝ស​នោ​កោញ​វា​អ្យាត់​នាវ​គ៝ប់​លែរ​ងែរ​ប៝ត់​អ៝ន់​គឹត​វ៝ត់​នាវ​អ្យា៖ ");
INSERT INTO cmok_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","លែៈ​នទើ​ឞើស​ទីស​អី​លាប់​តា​ត្រោម​ឆាក់​ឞូនុយ្ស មោ​ទើយ​អោស​ជាន​អ៝ន់​ឞូនុយ្ស​ជេង​មោ​ក្ល៝ស លែៈ​នទើ​អី​លោស​ឞើស​ឞូនុយ្ស នទើ​អី​នៃ​ទើយ​ជាន​អ៝ន់​ជេង​មោ​ក្ល៝ស។ ");
INSERT INTO cmok_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ឞូ​ម៝ស​តាង់​នាវ​គ៝ប់​ងើយ​អ្យា អ៝ន់​ពាង់​មឹន​អេង​តា​ឆាក់!” ");
INSERT INTO cmok_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​ផូង​ប៝ន​លាន​ហាន់​លាប់​តា​ត្រោម​ជៃ តា​នៃ​មពោល​អ៝ស​ម៝ន​ពាង់​លែវ​ឞាល់​អោប​ពាង់​មា​នាវ​នតី​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ពាង់​លាស​មា​ខាន់​ពាង់៖ “នទ្រី​ខាន់​មៃ​មោ​ហ៝ៈ​គឹត​វ៝ត់​ដ៝ង់​បាស? អ៝ន់​ខាន់​មៃ​គឹត​វ៝ត់​នាវ​អ្យា លែៈ​នទើ​តាៈ​ឞើស​ទីស​អី​លាប់​តា​ឆាក់​ឞូនុយ្ស​មោ​ទើយ​អោស​ជាន​អ៝ន់​ឞូនុយ្ស​អី​នៃ​ជេង​មោ​ក្ល៝ស‌ ");
INSERT INTO cmok_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","យ៝រ​មា​នទើ​អី​នៃ​មោ​គែស​អោស​លាប់​តា​ត្រោម​នូយ្ស​នហ៝ម់ លាប់​តា​ត្រោម​នទុល​ទើម ជេសរី​លោស​លែៈ​ផ្យៅ”។ - នទ្រី​ពាង់​មឞើស​លាស​លែៈ​នទើ​ឆោង​ឆា​ជេង​ទី​មា​ឆា​ទាទេ​ងាន់។ - ");
INSERT INTO cmok_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ពាង់​លាស​ជឹត៖ “គែស​នទើ​អី​លោស​ឞើស​ឞូនុយ្ស​ទើម​ទើយ​ជាន​អ៝ន់​ឞូ​ជេង​មោ​ក្ល៝ស‌ ");
INSERT INTO cmok_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","យ៝រ​លាស​ទឹង​លែៈ​នាវ​មឹន​អ្យើស​អ្យើត​លោស​តាៈ​ឞើស​នូយ្ស​នហ៝ម់​ឞូនុយ្ស នាវ​មឹន​អី​នៃ​លែវ​ជេង​ខើស​ក្លែរ នតុង​ឞូ ងខឹត​ឞូ‌ ");
INSERT INTO cmok_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ល៝ម់​អូរ​ល៝ម់​ឆាយ រាវាន​កើញ​គែស​មា​ទ្រាប់​នទើ ជាន​នទើ​អ្យើស មរោស​ឞូ មោ​គែស​នាវ​ដីត អុច​មា​នាវ​តឹម​ពីត ងើយ​ញចើត នាវ​ហឺន នទ្រែល​មា​នាវ​មោ​ហោម​អោស​គឹត​នទើ​អ្វែស​នទើ​អ្យើស។ ");
INSERT INTO cmok_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","លែៈ​នាវ​អ្យើស​អី​នៃ​លោស​តាៈ​ឞើស​នូយ្ស​នហ៝ម់​ឞូនុយ្ស ជាន​អ៝ន់​ជេង​មោ​ក្ល៝ស”។ ");
INSERT INTO cmok_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​អ៝ស​ម៝ន​ពាង់​លោស​ឞើស​នតុក​នៃ ហាន់​តា​ឞ្រី​អី​ទាច់​ដាស​ប៝ន​ក្វ៝ង់​តីរុស  នទ្រែល​មា​ប៝ន​ក្វ៝ង់​ឆីដោន ​រី។ ត៝ត់​តា​ទូ​ប៝ន​ខាន់​ពាង់​លាប់​គុ​តា​ទូ​មល៝ម់​ជៃ មោ​អុច​អោស​អ៝ន់​ឞូ​គឹត​លាស​ពាង់​គុ​តា​នៃ តីស​មា​មោ​អោស​ទើយ​នទ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ទូ​នទ៝ម់​គែស​ទូ​ហ្វេ​ឞូ​អូរ​តាង់​ឞូ​ងក៝ច​ឞ្រាស​យេឆូ ​គុ​តា​នៃ។ អី​ក៝ន​ឞូ​អូរ​ពាង់​រី​ឞ្រាស​អ្យើស​លាប់ ជេសរី​ពាង់​ហាន់​តា​ជៃ​អី​នៃ​ពាន់​តា​ជ៝ង់​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ឞូ​អូរ​អី​នៃ​មោ​អោស​ទី​ផូង​អីឆ្រាអែល  អី​ប៝ន​តើម​ពាង់​ទាច់​មា​ប៝ន​ផេនីសី ​តា​ឞ្រី​ឆីរី ។ ជេសរី​ពាង់​ឞ៝ញ​ដាៈ​ឞ្រាស​យេឆូ ​មព្រើស​ឞ្រាស​អ្យើស​អី​នៃ​អ៝ន់​លោស​ឞើស​អី​ក៝ន​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ឞ្រាស​យេឆូ ​ងើយ​នតឹត​មា​ពាង់៖ “អ៝ន់​អ៝ស​ក៝ន​ឆោង​ឆា​ហើម​ប៝ត់ មោ​ទី​អោស​ឆ៝ៈ​ព្យាង់​ត្រាវ​អ៝ស​ក៝ន​មអារ់​អ៝ន់​ឆ៝​ឆា​ច្រាវ”។ ");
INSERT INTO cmok_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ឞូ​អូរ​អី​នៃ​អើស​លាស៖ “ងាន់​កោរាញ​មេ! ឞ៝ល​លាស​មោ​មអារ់​ព្យាង់​ត្រាវ​កាដោយ ឆ៝​ហោម​គុ​តា​ន៝ម់​គ្រែ​នតេរ​ឆា​ព្យាង់​ត្រាវ​នទាក់​អី​អ៝ស​ក៝ន​គែស​តុប​នើស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ត៝ត់​តាង់​នាវ​ឞូ​អូរ​លាស​នៃ​ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “យ៝រ​មា​អៃ​ងើយ​នទ្រី ឞ្រាស​អ្យើស​លែៈ​លោស​ឞើស​ក៝ន​អៃ​ហើយ អៃ​ព្លឹ​ឆឹត​អា​រី​ទោស”។ ");
INSERT INTO cmok_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ពាង់​ឆឹត​ត៝ត់​តា​ជៃ​ឆៃ​អី​ក៝ន​ពាង់​ឞិច​អ្វែស​កាលើ​គ្រែ​រី ឞ្រាស​អ្យើស​លែៈ​លោស​ឞើស​ក៝ន​ពាង់​នៃ​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​ឞ្រី​អី​ទាច់​ដាស​ប៝ន​ក្វ៝ង់​តីរុស ​ហាន់​គ្លាត់​រ៝ៈ​ប៝ន​ក្វ៝ង់​ឆីដោន ​នហ៝​មា​ត៝ត់​តា​ឞ្រី​ដេកាពោលីស ​អី​ទាច់​មា​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ជេសរី​តា​នៃ​ឞូ​លែវ​ទូ​ហ្វេ​ឞូ​ក្លោ​តឹក​តោរ​ហាន់​តា​ឞ្រាស​យេឆូ ។ ឞូ​ក្លោ​អី​នៃ​មោ​លាង់​ឞ្លាវ​ងើយ​ដ៝ង់។ ឞូ​ឞ៝ញ​ពាង់​ដាៈ​តេៈ​តី​តា​ឞូ​ក្លោ​អី​តឹក​តោរ​នៃ គៃ​មា​ឞាស​នាវ​ជី​ឞូ​ក្លោ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ជេសរី​ឞ្រាស​យេឆូ ​លែវ​ឞូ​ក្លោ​អី​នៃ​ហាន់​គុ​នតុក​អេង​បាស​ដេៈ​មា​ផូង​ប៝ន​លាន ពាង់​ល៝ក់​លាវ​តី​តា​ត្រោម​តោរ​ឞូ​ក្លោ​អី​នៃ ឆ៝ស​ទាក​ទីវ​តា​លាវ​តី​ពាង់​នើម​តេៈ​តា​មព្យាត់​ឞូ​ក្លោ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ជេសរី​ឞ្រាស​យេឆូ ​ងគើរ​កាលើ​ត្រោក​រី ញឆោរ​នហ៝ម់​ក្វ៝ង់​អ្យហូត ពាង់​លាស៖ “អែបផាថា ” - រាឞ្លាង​លាស «អ៝ន់​ពើក​ហ៝ម់»។ ");
INSERT INTO cmok_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ទូ​នទ៝ម់​ទោ​មា​តោរ​ឞូ​ក្លោ​អី​នៃ​អ្យាត់​តាង់​រ៝ មព្យាត់​ឞ្លាវ​រាលាម់​នហ៝​មា​ងើយ​ក្ល៝ស​រាស​វាស​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ជេសរី​ឞ្រាស​យេឆូ ​ឞ្វៃ​ខាន់​ពាង់​លើយ​អោស​ងក៝ច​នាវ​អ្យា​មា​ឞូ។ ពាង់​ឞ្វៃ​លើយ​ទឹង​ងក៝ច​នាវ​អី​នៃ យើន​មា​ខាន់​ពាង់​លើ​មា​ហោ​ងាន់​ងក៝ច​នាវ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ទឹង​លែៈ​ឞូនុយ្ស​អី​តាង់​នាវ​អី​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់ ជេសរី​លាស៖ “លែៈ​នទើ​អី​ពាង់​ជាន​នៃ​ជេង​អ្វែស​ទាទេ​ងាន់ ឞ៝ល​លាស​ឞូនុយ្ស​តឹក​តោរ​ពាង់​ជាន​អ៝ន់​តាង់ ឞូនុយ្ស​មល៝​ជេង​ឞ្លាវ​ងើយ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","នោក​នៃ​គែស​ដ៝ង់​ផូង​ប៝ន​លាន​អ៝ក់​ងាន់​ហាន់​គុ​រាគូម​ឞាល់​ជឹត។ ខាន់​ពាង់​មោ​គែស​អោស​នទើ​មា​ឆោង​ឆា នទ្រី​ឞ្រាស​យេឆូ ​ក្វាល់​មពោល​អ៝ស​ម៝ន​ពាង់ពាង់​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“គ៝ប់​យោៈ​ងាន់​មា​ផូង​ប៝ន​លាន​នៃ ខាន់​ពាង់​គុ​នទ្រែល​គ៝ប់​លែៈ​ពែ​នារ​ហើយ នទើ​មា​ឆោង​ឆា​មោ​គែស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","លាស​គ៝ប់​ដាៈ​ខាន់​ពាង់​ព្លឹ​ឆឹត​នទុល​ទើម រាគាញ់​ចោត​រ៝ៈ​ត្រ៝ង​រ៝។ ឞូ​អាបាៈ​ឞ្រោៈ​តាៈ​ឞើស​ប៝ន​ងាយៗ”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","មពោល​អ៝ស​ម៝ន​អើស​លាស៖ “តា​អ្យា​រាង៝ត​រាងាត់ អាស​នតុក​ជ៝យ​នទើ​មា​អ៝ន់​ខាន់​ពាង់​ឆោង​ឆា​មា​ត៝ង់?” ");
INSERT INTO cmok_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ឞ្រាស​យេឆូ ​អោប​ខាន់​ពាង់៖ “នទ្រី​ខាន់​មៃ​ទាស​អ៝ក់​គែស​នុមពាង់​ហាៈ?” “គែស​ពើស​មល៝ម់”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ជេសរី​ឞ្រាស​យេឆូ ​ដាៈ​ផូង​ប៝ន​លាន​គុ​រើប​គើប​តា​នែស​រី ពាង់​ឆ៝ៈ​នុមពាង់​ពើស​មល៝ម់​នៃ មឞើស​ឆើម​លាស​អ្វែស​មា​កោរាញ​ឞ្រាស ពាង់​គិច​អ៝ន់​មា​មពោល​អ៝ស​ម៝ន​ពាៈ​មា​ផូង​ប៝ន​លាន​នៃ ជេសរី​ខាន់​ពាង់​ជាន​កើត​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","គែស​កា​ជេៈ​អាបាៈ​ដ៝ង់ នទ្រី​ឞ្រាស​យេឆូ ​មឞើស​ឆើម​លាស​អ្វែស​មា​កោរាញ​ឞ្រាស ជេសរី​ដាៈ​មពោល​អ៝ស​ម៝ន​ពាៈ​កា​អី​នៃ​អ៝ន់​មា​ផូង​ប៝ន​លាន។ ");
INSERT INTO cmok_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ជេស​ជាន​នទ្រី​លែៈ​ខាន់​ពាង់​ឆា​ហើម​រោច​ដ្ហោច ជេសរី​រាគូម​នុមពាង់ នទ្រែល​មា​កា​អី​រាមែស​នៃ​គែស​ពើស​ឆាស។ ");
INSERT INTO cmok_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ទឹង​លែៈ​ឞូនុយ្ស​តា​នៃ​នើស​អ៝ក់ ៤០០០ នុយ្ស។ ជេស​ឞើស​នៃ​ឞ្រាស​យេឆូ ​ដាៈ​ខាន់​ពាង់​ព្លឹ​ឆឹត​អា​ជៃ​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ទូ​នទ៝ម់​ឞើស​កើយ​នៃ ពាង់​ញច៝​ទូក​នទ្រែល​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​ជឹត​ឞ្រី​ដាល់មានូថា ។ ");
INSERT INTO cmok_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ជេស​ខាន់​ពាង់​ត៝ត់​តា​រី ផូង​ផារីឆី ​លែវ​ឞាល់​ម៝ប់​ឞ្រាស​យេឆូ ​តឹម​រាលាច់​មា​ពាង់ ដាៈ​ពាង់​ជាន​ទូ​នាវ​មឞេន​អ្វែស​អ៝ន់​គឹត​នហេល​លាស​ពាង់​ទើន​នាវ​ទើយ​តាៈ​ឞើស​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ជេស​តាង់​នាវ​ខាន់​ពាង់​ដាៈ​នៃ ឞ្រាស​យេឆូ ​ញឆោរ​នហ៝ម់​ក្វ៝ង់​អ្យហូត ជេសរី​លាស៖ “មើម​ទឹង​ឞូនុយ្ស​តា​រានោក​អាបៃ​អ្យា​អុច​គឹត​ឆៃ​នាវ​មឞេន​កើត​រី? គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ កោរាញ​ឞ្រាស​មោ​អោស​អ៝ន់​ឆៃ​នាវ​មឞេន​មា​ឞូនុយ្ស​រានោក​អាបៃ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ជេសរី​ឞ្រាស​យេឆូ ​ទូ​ឞើស​ខាន់​ពាង់​នៃ ញច៝​ទូក​ហាន់​តៃ​ជឹត​មពែស​កាល់​តី​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ជេសរី​មពោល​អ៝ស​ម៝ន​លែៈ​ច្វេល​ញអោត​នុមពាង់ តា​ទូក​នៃ​គែស​ទូ​មល៝ម់​នុមពាង់​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ជេសរី​ឞ្រាស​យេឆូ ​ងើយ​ងកាស​មា​ខាន់​ពាង់៖ “អ៝ន់​ខាន់​មៃ​ញជ្រាង់​ងាន់​មា​នទ្រូយ​ផូង​ផារីឆី  នទ្រែល​មា​នទ្រូយ​កោរាញ​ម៝ត់​អ្វាញ់​ហេរោត-​អ៝ន់តីពាស ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","មពោល​អ៝ស​ម៝ន​ងើយ​នទ្រាង់​ខាន់​ពាង់​នើម៖ “ពាង់​ងើយ​កើត​នៃ​អាច​ឞ៝ន់​មោ​គែស​នុមពាង់​ទើម​មោ?” ");
INSERT INTO cmok_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ឞ្រាស​យេឆូ ​គឹត​នាវ​ខាន់​ពាង់​ងើយ ពាង់​លាស៖ “ម៝ស​ងើយ​ខាន់​មរែ​នាវ​មោ​គែស​នុមពាង់​នៃ? ខាន់​មៃ​មោ​ឆៃ​អ្យាត់ មោ​ឆៃ​គឹត​វ៝ត់​នាវ​ដ៝ង់? ខាន់​មៃ​ហោម​ទាង់​ក៝​បាស? ");
INSERT INTO cmok_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ខាន់​មៃ​គែស​ទើម​ត្រោម​មាត់​អ្វាញ់​មោ​ឆៃ គែស​ទើម​តោរ​អ្យាត់​មោ​តាង់​បាស? នទ្រី​ខាន់​មៃ​លែៈ​ច្វេល​បាស‌ ");
INSERT INTO cmok_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","នោក​គ៝ប់​គិច​ព្រាម់​មល៝ម់​នុមពាង់​ពាៈ​អ៝ន់​មា​ឞូនុយ្ស ៥០០០ នុយ្ស​នើស? ជេសរី​ខាន់​មៃ​រាគូម​នុមពាង់​អី​រាមែស​នើស​ទាស​អ៝ក់​ហោម?” ខាន់​ពាង់​អើស​លាស៖ “១២ ឆាស”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“នទ្រី​នោក​គ៝ប់​គិច​នុមពាង់​ពើស​មល៝ម់​ពាៈ​អ៝ន់​មា​ឞូនុយ្ស ៤០០០ នុយ្ស​នើស ខាន់​មៃ​រាគូម​ទាស​អ៝ក់​ហោម?” ខាន់​ពាង់​អើស​លាស៖ “ហោម​ពើស​ឆាស”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “មើម​ខាន់​មៃ​អេ​ហ៝ៈ​គឹត​វ៝ត់​ដ៝ង់?” ");
INSERT INTO cmok_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ត៝ត់​តា​ប៝ន​បេតឆៃដា ។ តា​នៃ​គែស​ឞូ​លែវ​ទូ​ហ្វេ​ឞូ​ក្លោ​ចែស​មាត់​ហាន់​តា​ពាង់ ជេសរី​ឞ៝ញ​ដាៈ​ពាង់​ពាស​ឞូ​ក្លោ​អី​នៃ គៃ​មា​ឞាស​នាវ​ជី។ ");
INSERT INTO cmok_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ជេសរី​ពាង់​តេក​តី​ឞូ​ក្លោ​អី​ចែស​មាត់​នៃ លែវ​ហាន់​លោស​ឞើស​ទីស​ប៝ន ពាង់​ឆ៝ស​ទាក​ទីវ​មហឹង​កាលើ​ត្រោម​មាត់ នហ៝​មា​តេៈ​តី ជេសរី​អោប​ពាង់៖ “មៃ​លែៈ​ឆៃ​នទើ​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ឞូ​ក្លោ​អី​នៃ​ងើក​អ្វាញ់ មឞើស​លាស៖ “គ៝ប់​ឆៃ​ឞូនុយ្ស​ឞ្រោៈ​ងគូយ​ងគាយ អ្វាញ់​ខាន់​ពាង់​តឹម​ឞាន​មា​តើម​ឆី”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ឞ្រាស​យេឆូ ​តេៈ​តី​កាលើ​ត្រោម​មាត់​ពាង់​ទូ​តឹ​ជឹត ជេសរី​ពាង់​អ្វាញ់​ឆៃ​ទឹង​លែៈ​នទើ​ក្ល៝ស​រាស​វាស ត្រោម​មាត់​ពាង់​លែៈ​ឞាស​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ជេសរី​ឞ្រាស​យេឆូ ​ដាៈ​ពាង់៖ “មៃ​ឆឹត​ឞ្រ៝ង់​អា​ជៃ​មៃ​នើម​រី លើយ​ទឹង​លាប់​រ៝ៈ​ប៝ន​យឹ”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​លោស​ឞើស​នៃ ហាន់​តា​ប៝ន​អេងៗ​ទាច់​ដាស​ប៝ន​ក្វ៝ង់​ឆេឆារា-​ផីលីប ។ នោក​ហាន់​រ៝ៈ​ត្រ៝ង​ពាង់​អោប​ខាន់​ពាង់៖ “អា​មើម​ឞូ​លាស​គ៝ប់?” ");
INSERT INTO cmok_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","មពោល​អ៝ស​ម៝ន​អើស​លាស៖ “អាបាៈ​លាស​មៃ​ជេង​យោហាន-​បាប់តែម ​អី​លែៈ​ទ៝ក់​រេស អាបាៈ​លាស​ជេង​អេលីយា ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ព្លឹ​តា​អ្យា អាបាៈ​ជឹត​លាស​មៃ​ជេង​ទូ​ហ្វេ​ឞូនុយ្ស​អី​អេង​នើម​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ទ៝ក់​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ជេសរី​ឞ្រាស​យេឆូ ​អោប​មា​ខាន់​ពាង់​នើម៖ “នទ្រី​ខាន់​មៃ​លាស​គ៝ប់​ឞូ​ម៝ស​ហាៈ?” ពេត្រោស ​អើស​មា​ពាង់៖ “មៃ​អី​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​ងាន់!” ");
INSERT INTO cmok_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ជេសរី​ឞ្រាស​យេឆូ ​ឞ្វៃ​មពោល​អ៝ស​ម៝ន មោ​អោស​អ៝ន់​ខាន់​ពាង់​ងក៝ច​នាវ​នៃ​មា​ឞូ។ ");
INSERT INTO cmok_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ជេសរី​ឞ្រាស​យេឆូ ​នតើម​នតុម​នតី​មា​មពោល​អ៝ស​ម៝ន​ពាង់​នៃ ពាង់​លាស៖ “គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស មោ​អោស​ទើយ​ក្លាយ្ស​គែស​នាវ​ជេរ​ជ៝ត់​ទុត​ហោ​ងាន់។ មពោល​ឞូ​រាញ មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ឞ៝ន់​មអារ់​លើយ​គ៝ប់ នហ៝​មា​ងខឹត​គ៝ប់​ដ៝ង់ យើន​មា​ត៝ត់​ពែ​នារ​ឞើស​កើយ​គ៝ប់​ទ៝ក់​រេស​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ពាង់​ងក៝ច​មា​ខាន់​ពាង់​ឆ៝ង់ៗ​ងាន់ មោ​គែស​អោស​ពោន​ម៝។ ជេសរី​ពេត្រោស ​ជាៈ​ឞ្រាស​យេឆូ ​ហាន់​នតុក​អេង​បាស​មា​ឞូ ជេសរី​ឞ្វៃ​ពាង់​លើយ​តា​ងើយ​កើត​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ឞ្រាស​យេឆូ ​រាលែ​អ្វាញ់​ជឹត​មពោល​អ៝ស​ម៝ន ជេសរី​ពាង់​លាស​ពេត្រោស ៖ “ហើយ​ឆាតាង់  មៃ​ទូ​ងាយ​ឞើស​គ៝ប់​ហ៝ម់ នាវ​មឹន​មៃ​មោ​ទី​ដាស​នាវ​មឹន​កោរាញ​ឞ្រាស ​អោស នាវ​មឹន​នៃ​តាៈ​ឞើស​ឞូនុយ្ស​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ជេសរី​ឞ្រាស​យេឆូ ​ក្វាល់​ផូង​ប៝ន​លាន នទ្រែល​មា​មពោល​អ៝ស​ម៝ន ពាង់​លាស​មា​ខាន់​ពាង់៖ “ឞូ​ម៝ស​ពាង់​អី​អុច​តឹង​គ៝ប់ អ៝ន់​មអារ់​លើយ​នទើ​ឆាក់​ពាង់​នើម​អុច ជេសរី​តូយ​ឆី​តឹម​រាកាង់​ពាង់​នើម ជេង​គែស​នាវ​ខ្លៃ​អ្យាត់​នាវ​គ៝ប់ ឞ៝ល​លាស​ត៝ត់​ខឹត​ឆាក់​កាដោយ រី​មើ​ទើយ​តឹង​គ៝ប់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","យ៝រ​លាស​ឞូ​ម៝ស​អី​កើប​អេង​នាវ​រេស​ពាង់​នើម​ខ្លៃ​រាលាវ ពាង់​អី​នៃ​មោ​អោស​គែស​នាវ​រេស​នហ៝​រ៝ យើន​មា​ឞូ​ម៝ស​ខឹត​យ៝រ​មា​តឹង​គ៝ប់ មោ​លាស​យ៝រ​មា​នាវ​មហែ​មហាន​អ្វែស ពាង់​អី​នៃ​គែស​នាវ​រេស​នហ៝​រ៝​ងាន់​តា​នារ​ជឹត​នាប់​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","លាស​ទូ​ហ្វេ​ឞូនុយ្ស​ពាង់​គែស​ទឹង​លែៈ​នែស​នតូ​អ្យា​ជេង​ទ្រាប់​នទើ​ពាង់​នើម​ទាទេ តីស​មា​ឆាក់​ពាង់​នើម​ខឹត​រ៝ស​ហេង មោ​អោស​គែស​នាវ​រេស​នហ៝​រ៝ នទ្រី​ម៝ស​គែស​នាវ​ខ្លៃ​មា​ពាង់? ");
INSERT INTO cmok_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ឞូនុយ្ស​អើម​ទើយ​លាស​ឆ៝ៈ​ទ្រាប់​នទើ​មា​រាគ៝ល់​នាវ​រេស​ពាង់​នើម​នហ៝​រ៝? ");
INSERT INTO cmok_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","អាបៃ​អ្យា​ខាន់​អៃ​មៃ​គុ​នទ្រែល​ឞូនុយ្ស​អ្យើស​ឞូនុយ្ស​តីស​មោ​អ្យាត់​នាវ​កោរាញ​ឞ្រាស។ ឞូ​ម៝ស​អី​ដីត​ព្រេង​មោ​ឞាញ់​មឞើស​ពាង់​តឹង​គ៝ប់ ដីត​ព្រេង​តឹង​នាវ​គ៝ប់​នតី​ដ៝ង់ លាស​នទ្រី​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ដីត​ព្រេង​មោ​គឹត​នាល់​ពាង់​អី​នៃ​ដ៝ង់​តា​នារ​គ៝ប់​ព្លឹ​វាច់ នអ៝ប់​មា​គែស​នាវ​អ្វែស​ច្រេក​លើប​ឞឹ​គ៝ប់ នទ្រែល​មា​ផូង​តោង​ពារ់​ក្ល៝ស​អ្វែស”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ជេសរី​ឞ្រាស​យេឆូ ​លាស៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ឞូនុយ្ស​អាបាៈ​អី​គុ​តា​អ្យា​មោ​ខឹត​អោស អេ​ល៝រ​មា​ឆៃ​នាវ​ទើយ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","គែស​ព្រាវ​នារ​ឞើស​កើយ​នៃ​ឞ្រាស​យេឆូ ​ជាៈ​ពេត្រោស យាកើ  នទ្រែល​មា​យោហាន ​ហាវ​កាលើ​យោក​ព្រេស មោ​អោស​លែវ​ឞូ​អា​អេង​ហាន់។ តា​នៃ​ឆាក់​ជាន់​ពាង់​រាគ៝ល់​ឞើស​នាប់​ខាន់​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","អី​ឞ៝ក​អាវ​ពាង់​ជេង​ងលាង​អាង​ច្រាត​ងាន់ មោ​គែស​អោស​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា​ទើយ​ជាន​តឹម​ឞាន​កើត​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","តា​នៃ​ពែ​នុយ្ស​មពោល​អ៝ស​ម៝ន​ទោ​មា​ឆៃ​ឞូនុយ្ស​ឞារ​ហៃ​អី​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ឞើស​កាល់​អែ រាញា​អេលីយា  នទ្រែល​មា​មោឆេ ​គុ​ងើយ​នទ្រែល​ឞ្រាស​យេឆូ ​តា​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ជេស​ឆៃ​លែៈ​នាវ​អី​នៃ ពេត្រោស ​លាស​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​នើម​នតី! ឞ៝ន់​គុ​តា​អ្យា​អ្វែស​ងាន់​មេ អ៝ន់​ហេន​ជាន​ពែ​មល៝ម់​ចូន ទូ​មល៝ម់​អ៝ន់​មា​មៃ ទូ​មល៝ម់​អ៝ន់​មា​មោឆេ  ទូ​មល៝ម់​ជឹត​អ៝ន់​មា​អេលីយា ”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","នាវ​ពេត្រោស ​ងើយ​កើត​នៃ​ពាង់​នើម​មោ​អោស​គឹត​ឆាក់ ទាស​មា​លោស​មឞូង​ងើយ យ៝រ​មា​ខាន់​ពាង់​ក្លាច​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ជេសរី​គែស​តុក​ងកុម​កាលើ​ខាន់​ពាង់​លែៈ​រាងោច តាង់​នតែស​ងើយ​តាៈ​ឞើស​តុក​នៃ​លាស៖ “ពាង់​អ្យា​ក៝ន​គ៝ប់​អី​គ៝ប់​រ៝ង់​ហោ​ងាន់ អ្យាត់​នាវ​ពាង់​ទោ!” ");
INSERT INTO cmok_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ទូ​នទ៝ម់​តា​នៃ មពោល​អ៝ស​ម៝ន​អ្វាញ់​ជុម​ខាន់​ពាង់​នើម​រី មោ​ហោម​អោស​ឆៃ​ឞូនុយ្ស ឆៃ​ទូ​ហ្វេ​ឞ្រាស​យេឆូ ​ទើម​គុ​នទ្រែល​ខាន់​ពាង់​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​ពែ​នុយ្ស​អ៝ស​ម៝ន​ពាង់​ជុរ​តាៈ​ឞើស​យោក ពាង់​ឞ្វៃ​ខាន់​ពាង់​មោ​អោស​អ៝ន់​ងក៝ច​នាវ​អី​ខាន់​ពាង់​ឆៃ​នើស​មា​ឞូ នហ៝​មា​ត៝ត់​ពាង់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទ៝ក់​រេស​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","នទ្រី​ខាន់​ពាង់​អ្យាត់​តឹង​នាវ​ពាង់​លាស តឹម​អោប​នទ្រាង់​ខាន់​ពាង់​នើម៖ “នទ្រី​«នាវ​ទ៝ក់​រេស​តៃ» ម៝ស​នាវ​ខ្លៃ​ហ្យាស?” ");
INSERT INTO cmok_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ជេសរី​ខាន់​ពាង់​អោប​ឞ្រាស​យេឆូ ៖ “ម៝ស​នាវ​ទឹង​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់​នតី​លាស​អេលីយា ​អ្យាត់​មា​ពាង់​វាច់​ល៝រ​តា​អ្យា ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​វាច់​ឞើស​កើយ​រ៝?” ");
INSERT INTO cmok_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ពាង់​អើស​មា​ខាន់​ពាង់​លាស៖ “ទី​ងាន់​នាវ​ព្រែ​លាស អេលីយា ​វាច់​ល៝រ គៃ​មា​កើយ​នទ្រាប់​អ៝ន់​អាប់​ទឹង​លែៈ​រាងោច តីស​មា​មើម​ទឹង​ឞូ​ញចីស​តា​ត្រោម​ឆ៝ម់បុត​លាស​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​គែស​នាវ​ជេរ​ជ៝ត់​ទុត​ហោ ឞូ​មឺច​រាម៝ត​ដ៝ង់? ");
INSERT INTO cmok_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","គ៝ប់​មឞើស​មា​ខាន់​មៃ អេលីយា ​លែៈ​ជេស​វាច់​គុ​តា​នែស​នតូ​អ្យា​ហើយ្ស ល៝ង់​ឞូ​អាបាៈ​ជាន​ជេរ​មា​អោឞាល់​អី​នៃ​អាប់​មពឹ​លឹ​នតីល ទាស​អុច​ឞូ​ជាន​តឹង​មា​នាវ​ឞូ​គែស​ញចីស​ល៝រ​មា​ពាង់​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​ពែ​នុយ្ស​អ៝ស​ម៝ន​រី​ព្លឹ​ត៝ត់​តា​នតុក​អ៝ស​ម៝ន​ទឹង​លែៈ​អី​គុ​តា​នៃ ឆៃ​អ៝ក់​ផូង​ប៝ន​លាន​ជុម​អ៝ស​ម៝ន​ពាង់​នៃ គែស​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​បាបាៈ​តឹម​រាលាច់​ដាស​ខាន់​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ត៝ត់​ផូង​ប៝ន​លាន​ឆៃ​ឞ្រាស​យេឆូ ​ទឹង​លែៈ​ខាន់​ពាង់​នទ្រ៝ត់​រោស​ព្រោស​ញច្វាត់​រាន​អោប​អ្វែស​លាង់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ពាង់​អោប​ខាន់​ពាង់៖ “ម៝ស​នាវ​តឹម​រាលាច់​ខាន់​មរែ​ដាស​ខាន់​ពាង់​នទើស​នើស?” ");
INSERT INTO cmok_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ជេសរី​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​តា​ផូង​ប៝ន​លាន​នៃ​អើស​មា​ពាង់៖ “ហើយ​នើម​នតី! គ៝ប់​លែវ​ក៝ន​ឞូ​ក្លោ​គ៝ប់​អី​ឞ្រាស​អ្យើស​លាប់​តា​ឆាក់​ពាង់ ជាន​អ៝ន់​ពាង់​មល៝​មោ​ឞ្លាវ​ងើយ។ ");
INSERT INTO cmok_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ត៝ត់​ឞ្រាស​អ្យើស​អី​នៃ​លើស​នតឹៗ​ក៝ន​គ៝ប់​ចោត​តា​នែស​ទាង់​ជ៝ង់​ទាង់​តី លោស​មពុញ​ទាក​ទីវ រាច្យាត់​ឆេក​រាច្យាត់​នែង នទ្រី​មេៈ។ គ៝ប់​ដាៈ​មពោល​អ៝ស​ម៝ន​មៃ​មព្រើស​ដ៝ង់ ខាន់​ពាង់​មព្រើស​មោ​អោស​ទើយ​លោស”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ហើយ​ផូង​ឞូនុយ្ស​មោ​គែស​នាវ​ញឆីង​មា​កោរាញ​ឞ្រាស! ទាស​ហោម​ជ៝ៈ​អ៝ន់​គ៝ប់​គុ​នទ្រែល​ខាន់​អៃ​មៃ​ហ្យាស? ទាស​ហោម​ជ៝ៈ​អ៝ន់​គ៝ប់​ញឆ្រោយ្ស​នទ្រែល​ខាន់​អៃ​មៃ? លែវ​ក៝ន​ឆែ​នៃ​ជឹត​គ៝ប់​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ជេសរី​ឞូ​លែវ​ពាង់​ហាន់​អា​ឞ្រាស​យេឆូ ។ ត៝ត់​ឆៃ​ឞ្រាស​យេឆូ  ឞ្រាស​អ្យើស​ជាន​អ៝ន់​ក៝ន​ឆែ​នៃ​ចោត​ញឆ្ល៝ង់​ញឆ្លាង់​រ៝ រាលិ​រាលាង​តា​នែស​នហ៝​មា​លោស​មពុញ​ទាក​ទីវ។ ");
INSERT INTO cmok_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ឞ្រាស​យេឆូ ​អោប​អី​ឞឹ​ពាង់៖ “ទាស​ជ៝ៈ​នតើម​គែស​នាវ​ត៝ត់​អី​នៃ​មា​ពាង់?” “នតើម​ឞើស​ហោម​ជេៈ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ឞ្រាស​អ្យើស​ជាន​ពាង់​ចោត​តា​អុញ​តុប​តា​ទាក​នឹង​ងាន់ អុច​ងខឹត​ពាង់។ លាស​មៃ​ទើយ​ជាន ទាន់​មៃ​កើល​ហេន យោៈ​នអាច​មា​ហេន​បាៈ​អើ”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ឞ្រាស​យេឆូ ​អើស​លាស​មា​ពាង់៖ “ម៝ស​នាវ​មៃ​លាស «លាស​មៃ​ទើយ​ជាន» កើត​នៃ? គ៝ប់​ទើយ​ជាន​ទឹង​លែៈ​នតីល​នទើ​អ៝ន់​មា​ឞូ​ម៝ស​អី​ញឆីង​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ជេស​តាង់​លាស​នទ្រី​អី​ឞឹ​ក៝ន​ឆែ​នៃ​នតែរ​ហ៝រ​ទាក​មាត់​លាស៖ “គ៝ប់​ញឆីង​ហើយ្ស! ទាន់​កើល​គ៝ប់​អ៝ន់​គែស​នាវ​ញឆីង​ងាន់!” ");
INSERT INTO cmok_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","តា​នៃ​ឞ្រាស​យេឆូ ​ឆៃ​ផូង​ប៝ន​លាន​ញច្វាត់​រាន​អា​ពាង់ នទ្រី​ពាង់​រាអ៝ត់​ឞ្រាស​អ្យើស​លាស៖ “ហើយ​ឞ្រាស​អ្យើស​អី​ជាន​អ៝ន់​ក៝ន​ឆែ​អ្យា​តឹក​តោរ មល៝! គ៝ប់​ដាៈ​មៃ​លោស​ឞើស​ក៝ន​ឆែ​អ្យា​ហ៝ម់ លើយ​ហោម​អោស​លាប់​តា​ពាង់​ជឹត!” ");
INSERT INTO cmok_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ឞ្រាស​អ្យើស​នៃ​នតែរ​រ៝ ជាន​អ៝ន់​ក៝ន​ឆែ​នៃ​ញឆ្ល៝ង់​ញឆ្លាង់​ទុត​ហោ​ងាន់ ជេសរី​លោស​ប្ហុច។ ជេស​នៃ​ក៝ន​ឆែ​ឞិច​លាអ៝យ្ស​តឹម​ឞាន​មា​ឞូនុយ្ស​លែៈ​ខឹត អ៝ក់​ឞូនុយ្ស​លាស​ពាង់​លែៈ​ខឹត​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","យើន​មា​ឞ្រាស​យេឆូ ​ញុប​តី​ពាង់ រាទ៝ក់​ពាង់ ក៝ន​ឆែ​នៃ​ទ៝ក់​ដើប។ ");
INSERT INTO cmok_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​លាប់​តា​ទូ​មល៝ម់​ជៃ មពោល​អ៝ស​ម៝ន​អោប​អេង​ពាង់៖ “មើម​ទឹង​ហេន​មោ​ទើយ​មព្រើស​ឞ្រាស​អ្យើស​អ៝ន់​លោស​ហ្យាស?” ");
INSERT INTO cmok_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “គៃ​មា​ទើយ​មព្រើស​ឞ្រាស​អ្យើស​កើត​នៃ មឞើស​ឆើម​ នទ្រែល​មា​អ៝ត់​ឆោង​ឆា​មើ​ពា​ហែស”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​លោស​ឞើស​នតុក​នៃ ហាន់​គ្លាត់​រ៝ៈ​ឞ្រី​កាលីលេ ​មោ​អុច​អោស​អ៝ន់​ឞូ​គឹត‌ ");
INSERT INTO cmok_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ពាង់​នតុម​នតី​មា​មពោល​អ៝ស​ម៝ន​ពាង់​កើត​នអា៖ “គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស ឞូ​មរា​ញជុន​អ៝ន់​មា​ឞូនុយ្ស​អី​ងខឹត​លើយ​គ៝ប់ យើន​មា​លោច​ពែ​នារ​ឞើស​កើយ​ជេស​ឞូ​ងខឹត គ៝ប់​ទ៝ក់​រេស​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","មពោល​អ៝ស​ម៝ន​ពាង់​មោ​វ៝ត់​អោស​នាវ​ពាង់​ងើយ ខាន់​ពាង់​មោ​ឞាញ់​អោប​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ហាន់​ត៝ត់​តា​ប៝ន​កាពើនិម ​តា​ឞ្រី​កាលីលេ ។ ខាន់​ពាង់​លាប់​តា​ទូ​មល៝ម់​ជៃ ជេសរី​ពាង់​អោប​មា​មពោល​អ៝ស​ម៝ន៖ “ម៝ស​នាវ​តឹម​ញច្រាៈ​ខាន់​ម្រែ​នោក​ហាន់​រ៝ៈ​ត្រ៝ង​នើស?” ");
INSERT INTO cmok_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ខាន់​ពាង់​អ្យាត់​ឆាក់​រាក់​ក្លាក់ យ៝រ​លាស​នោក​ហាន់​រ៝ៈ​ត្រ៝ង​នើស ខាន់​ពាង់​តឹម​រាលាច់​អុច​គឹត​នហេល​តា​មពោល​ខាន់​ពាង់ ឞូ​ម៝ស​អី​ក្វ៝ង់​រាលាវ​ឞូ។ ");
INSERT INTO cmok_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ជេសរី​ឞ្រាស​យេឆូ ​គុ​ងគូច ពាង់​ក្វាល់​លែៈ ១២ នុយ្ស​មពោល​អ៝ស​ម៝ន​នៃ ពាង់​លាស៖ “ឞូ​ម៝ស​អី​អុច​ក្វ៝ង់​រាលាវ​ឞូ ពាង់​អី​នៃ​ញជុរ​ឆាក់​ពាង់​នើម​អ៝ន់​ជេៈ​តា​ន៝ម់​ឞូ នហ៝​មា​ជាន​ទឹក​ឞូ​ទឹង​លែៈ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ពាង់​លែវ​ទូ​ហ្វេ​ក៝ន​ឆែ​ជេៈ អ៝ន់​ទ៝ក់​តា​ងក្លាង​ខាន់​ពាង់ ពាង់​អូត​ក៝ន​ឆែ​អី​នៃ លាស​មា​មពោល​អ៝ស​ម៝ន៖ ");
INSERT INTO cmok_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ឞូ​ម៝ស​អី​រ៝ម​មា​ទូ​ហ្វេ​ក៝ន​ឆែ​ជេៈ​កើត​អ្យា យ៝រ​មា​អុច​អ្យាត់​នាវ​គ៝ប់ ពាង់​តឹម​ឞាន​មា​រ៝ម​គ៝ប់​ដ៝ង់ ជេសរី​ឞូ​ម៝ស​ពាង់​អី​រ៝ម​គ៝ប់ មោ​អោស​ទើន​រ៝ម​មា​ទូ​ហ្វេ​គ៝ប់​ទើម រ៝ម​មា​កោរាញ​ឞ្រាស​អី​តើម​ញជ្វាល់​អ៝ន់​គ៝ប់​ជុរ​តា​អ្យា​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ជេសរី​យោហាន ​មឞើស​មា​ឞ្រាស​យេឆូ ​លាស៖ “ហើយ​នើម​នតី! ហេន​ឆៃ​ទូ​ហ្វេ​ឞូនុយ្ស​មព្រើស​ឞ្រាស​អ្យើស​មា​ម៝ស​រាញា​មៃ។ ជេសរី​ហេន​ឞ្វៃ​ពាង់ យ៝រ​លាស​ពាង់​មោ​គែស​អោស​មពោល​ឞ៝ន់”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ឞ្រាស​យេឆូ ​លាស៖ “លើយ​អោស​ឞ្វៃ​ពាង់។ មោ​គែស​អោស​ឞូនុយ្ស​ទើយ​ជាន​នាវ​ទើយ​មា​ម៝ស​រាញា​គ៝ប់ ជេសរី​បេង​មា​ងើយ​អ្យើស​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","នទ្រី​ឞូ​ម៝ស​មោ​រាទ៝ង់​ដាស​ឞ៝ន់ ពាង់​អី​នៃ​គុ​មពែស​មា​ឞ៝ន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ជេសរី​ជឹត​លាស​ឞូ​ម៝ស​អ៝ន់​ទាក​ទូ​កែវ​មា​ខាន់​មៃ យ៝រ​មា​ខាន់​មៃ​ជេង​មពោល​អ៝ស​ម៝ន​គ៝ប់​អី​ឞ្រាស​ក្រីស គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ ពាង់​អី​នៃ​គែស​នទើ​ងខោម​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ឞ្រាស​យេឆូ ​លាស​ជឹត៖ “ឞូ​ម៝ស​លែវ​ទូ​ហ្វេ​ក៝ន​ឆែ​ជេៈ​អី​ញឆីង​មា​គ៝ប់​ជាន​នាវ​តីស នទ្រី​អ្វែស​រាលាវ​លាស​ឞូ​ឆ៝ៈ​មពាល់​លុ​ក៝ត់​តា​ត៝ង​ក៝​ពាង់ ងក្លាច់​ពាង់​តា​ទាក​វាច់​ទាក​វារ់​រី មា​ដាស​អ៝ន់​រ៝ង​ពាង់​រេស។ ");
INSERT INTO cmok_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","លាស​ឆៃ​តី​ខាន់​មៃ​លែវ​ជាន​នាវ​តីស​ក៝ស​មអារ់​លើយ​តី​អី​នៃ។ អ្វែស​រាលាវ​មា​គុ​រេស​ជឹត​នាប់​តៃ​រ៝ង​ទូ​ទីង​តី​ទើម ជេសរី​ទើន​នាវ​រេស​នហ៝​រ៝ មា​ដាស​ឞារ​ដាស​តី ជេសរី​គុ​តា​នតុក​អី​គែស​អុញ​ហីត​មោ​ឞ្លាវ​ញហ៝ត់ ");
INSERT INTO cmok_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ជេង​នតុក​អី​គែស​នាវ​រេស​រាញាល់​រាហាយ​ឆា​ឆាក់​ឞូនុយ្ស​នហ៝​រ៝ នតុក​គែស​អុញ​ហីត​មោ​ឞ្លាវ​ញហ៝ត់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","លាស​ឆៃ​ជ៝ង់​ខាន់​មៃ​លែវ​ជាន​នាវ​តីស ក៝ស​មអារ់​លើយ​ជ៝ង់​អី​នៃ។ អ្វែស​រាលាវ​មា​គុ​រេស​ជឹត​នាប់​តៃ​រ៝ង​ទូ​ទីង​ជ៝ង់​ទើម ជេសរី​ទើន​នាវ​រេស​នហ៝​រ៝ មា​ដាស​ឞារ​ដាស​ជ៝ង់ ជេសរី​កោរាញ​ឞ្រាស​ងក្លាច់​តា​នទ្រូង​អុញ ");
INSERT INTO cmok_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ជេង​នតុក​អី​គែស​នាវ​រេស​រាញាល់​រាហាយ​ឆា​ឆាក់​ឞូនុយ្ស​នហ៝​រ៝ នតុក​គែស​អុញ​ហីត​មោ​ឞ្លាវ​ញហ៝ត់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","លាស​ឆៃ​ត្រោម​មាត់​ខាន់​មៃ​លែវ​ជាន​នាវ​តីស​រាវែក​មអារ់​លើយ​ត្រោម​មាត់​អី​នៃ។ អ្វែស​រាលាវ​មា​រ៝ង​ទូ​ទីង​ត្រោម​មាត់​លាប់​គុ​តា​ប៝ន​អ្វែស​កោរាញ​ឞ្រាស មា​ដាស​ឞារ​ដាស​ត្រោម​មាត់ ជេសរី​កោរាញ​ឞ្រាស​ងក្លាច់​តា​នទ្រូង​អុញ‌ ");
INSERT INTO cmok_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ជេង​នតុក​អី​គែស​នាវ​រេស​រាញាល់​រាហាយ​ឆា​ឆាក់​ឞូនុយ្ស​នហ៝​រ៝ នតុក​គែស​អុញ​ហីត​មោ​ឞ្លាវ​ញហ៝ត់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","កោរាញ​ឞ្រាស​រាល៝ង​ទឹង​លែៈ​ឞូនុយ្ស​មា​នាវ​ជេរ​ជ៝ត់​តឹម​ឞាន​មា​លាប់​តា​អុញ​ហីត។ នទើ​អី​នៃ​តឹម​ឞាន​មា​នាវ​ញហើរ​មា​កោរាញ​ឞ្រាស​ទឹង​លែៈ​គែស​ព៝ត​លាយ​មា​ឞ៝ស។ ");
INSERT INTO cmok_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ឞ៝ស​ជេង​ទូ​នតីល​នទើ​តេៈ​ត្រាវ​មា​កាស​ងាន់ លាស​ឞ៝ស​អី​នៃ​មោ​ហោម​គែស​កាស មើម​ហោម​ឞ្លាវ​ជាន​គៃ​មា​អ៝ន់​ព្លឹ​កាស​ជឹត? អ៝ន់​ខាន់​មៃ​គឹត​មា​នាវ​ខ្លៃ​ឞ៝ស​អ្យា ជេសរី​គុ​នទ្រែល​ឞាល់​អ៝ន់​គែស​នាវ​អ្វែស​លាង់​ដាប់​មពាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​ប៝ន​នៃ ហាន់​ជឹត​ឞ្រី​យូដា ​មពែស​ឞើស​កាល់​តី​ទាក​រាលាយ​យោរដាន់  ជេង​មពែស​ឞើស​លោស​នារ។ ផូង​ប៝ន​លាន​លែវ​ឞាល់​រាន​អា​ឞ្រាស​យេឆូ ​ទូ​តឹ​ជឹត ជេសរី​ពាង់​នតុម​នតី​តៃ​តឹង​មា​នាវ​វៃ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","គែស​ផូង​ផារីឆី ​អាបាៈ​ហាន់​លាប់​គុ​ទាច់​អុច​អោប​រាល៝ង​ពាង់ ជេសរី​ខាន់​ពាង់​អោប​ពាង់៖ “ហើយ​នើម​នតី! អាស​តឹង​មា​នាវ​វៃ​ផូង​ឞ៝ន់ ឆាយ​ទើយ​នត្លើយ​អូរ​ដ៝ង់​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ពាង់​អើស​លាស៖ “នទ្រី​មើម​មោឆេ ​ដាៈ​ខាន់​មៃ​តា​នាវ​វៃ​ពាង់?” ");
INSERT INTO cmok_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ខាន់​ពាង់​អើស៖ “មោឆេ ​ញចីស​លាស អ៝ន់​អី​ឆាយ​ជាន​ឆ៝ម់បុត​នាវ​តឹម​នត្លើយ ជេសរី​ទើយ​មព្រើស​អី​អូរ​ពាង់​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “អាច​មា​ខាន់​មៃ​ទាង់​ក៝​ហោ​អីរ ទឹង​មោឆេ ​ញចីស​នាវ​វៃ​កើត​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ឞើស​នតើម​កាល់​អែ កោរាញ​ឞ្រាស​ទែ​ញជេង​ទឹង​លែៈ​តា​នែស​នតូ​អ្យា ពាង់​ញជេង​ឞូនុយ្ស​ដ៝ង់ គែស​ឞូ​ក្លោ​គែស​ឞូ​អូរ។ ");
INSERT INTO cmok_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","មោឆេ ​ញចីស៖ «នទ្រី​ទឹង​គែស​ឞូ​ក្លោ​លោស​ទូ​ឞើស​មេៈ​ឞឹ ហាន់​គុ​អា​អូរ‌ ");
INSERT INTO cmok_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ជេសរី​ឞារ​ហៃ​ខាន់​ពាង់​ជេង​អូរ​ឆាយ​ជេង​ទូ​រាង្លៃ​ឆាក់»។ នទ្រី​ខាន់​ពាង់​មោ​ហោម​អោស​ជេង​ឞារ​ហៃ​តៃ លែៈ​ជេង​ទូ​រាង្លៃ​ឆាក់​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","លាស​នទ្រី​ឞារ​ហៃ​អូរ​ឆាយ​អី​កោរាញ​ឞ្រាស​ទែ​រាង្លាប់​នៃ​លើយ​អ៝ន់​អោស​ឞូនុយ្ស​តឹម​ងខាស”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ជេសរី​ត៝ត់​ឆឹត​គុ​តា​ទូ​មល៝ម់​ជៃ មពោល​អ៝ស​ម៝ន​អោប​ឞ្រាស​យេឆូ ​មា​នាវ​អី​នៃ​ទូ​តឹ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ពាង់​លាស​មា​ខាន់​ពាង់៖ “ឞូ​ម៝ស​នត្លើយ​អូរ ជេសរី​ឆ៝ៈ​តៃ​អូរ​អេង​ជឹត ឞូ​ក្លោ​អី​នៃ​ជេង​ឞូនុយ្ស​ល៝ម់​អូរ។ ");
INSERT INTO cmok_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","លាស​ឞូ​អូរ​អី​លែៈ​នត្លើយ​ឆាយ ជេសរី​ឆ៝ៈ​ឆាយ​អេង​ជឹត ឞូ​អូរ​អី​នៃ​ជេង​ឞូនុយ្ស​ល៝ម់​ឆាយ”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","គែស​ទូ​នារ​រី​ឞូ​លែវ​ក៝ន​ឆែ​ជេៈៗ ដាៈ​ឞ្រាស​យេឆូ ​ពាស​អ៝ន់​នាវ​គែស​ជេង​មា​ក៝ន​ឆែ​អី​នៃ តីស​មា​មពោល​អ៝ស​ម៝ន​លាស​ឞ្វៃ​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ឞ្រាស​យេឆូ ​នូយ្ស​មឞូ ត៝ត់​ឆៃ​កើត​នៃ ពាង់​លាស៖ “អ៝ន់​ផូង​ក៝ន​ឆែ​វាច់​តា​គ៝ប់ លើយ​អោស​ឞ្វៃ​ខាន់​ពាង់ យ៝រ​លាស​ខាន់​ពាង់​មោ​អោស​នហាវ​អេង​ឆាក់​ខាន់​ពាង់​នើម យើន​មា​ញឆីង​មា​មេៈ​ឞឹ​ហោ​ងាន់។ ឞូនុយ្ស​អី​កោរាញ​ឞ្រាស​អុច​ម៝ត់​អ្វាញ់ ខាន់​ពាង់​គែស​កើត​នទ្រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ឞូ​ម៝ស​មោ​រ៝ម​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​តឹម​ឞាន​មា​ក៝ន​ឆែ​ជេៈ​រ៝ម ឞូនុយ្ស​អី​នៃ​កោរាញ​ឞ្រាស​មោ​រ៝ម​ដ៝ង់ មោ​អ៝ន់​ពាង់​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​នើម​ម៝ត់​អ្វាញ់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ជេសរី​ឞ្រាស​យេឆូ ​ពឺ​អូត​មពោល​ក៝ន​ឆែ​នៃ នហ៝​មា​មឞើស​ឆើម​តេៈ​តី​អ៝ន់​នាវ​គែស​ជេង​មា​ខាន់​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ជេសរី​ឞ្រាស​យេឆូ ​នទ្រាប់​មា​លោស​ឞើស​នៃ​ហាន់​រ៝ៈ​ត្រ៝ង គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ញច្វាត់​រាន​ត៝ត់​តា​នៃ ច៝ន​កោម៝ក់​ឞើស​នាប់​ពាង់ នហ៝​មា​អោប​លាស៖ “ហើយ​នើម​នតី​អ្វែស មើម​គ៝ប់​ជាន​មេស គៃ​មា​គែស​នាវ​រេស​នហ៝​រ៝?” ");
INSERT INTO cmok_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ឞ្រាស​យេឆូ ​អើស​លាស៖ “មើម​ទឹង​មៃ​ក្វាល់​គ៝ប់​«អ្វែស»​កើត​នៃ​មេស? មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​អ្វែស គែស​ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ទើម​អ្វែស។ ");
INSERT INTO cmok_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","មៃ​លែៈ​គឹត​ជេស​តា​នាវ​វៃ​ផូង​ឞ៝ន់​លាស៖ «លើយ​ងខឹត​ឞូ លើយ​ល៝ម់​អូរ​ល៝ម់​ឆាយ លើយ​នតុង លើយ​ងើយ​ញចើត លើយ​មរោស​គៃ​មា​ឆ៝ៈ​ទ្រាប់​នទើ​ឞូ ជេសរី​យើក​មា​មេៈ​ឞឹ​ហ៝ៈ»”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ឞូ​ក្លោ​អី​នៃ​អើស​មា​ពាង់៖ “ហើយ​នើម​នតី! ទឹង​លែៈ​នាវ​អី​នៃ​គ៝ប់​លែៈ​ញអោត​នតើម​ឞើស​ជេៈ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ជេស​តាង់​ពាង់​អើស​កើត​នទ្រី ឞ្រាស​យេឆូ ​អ្វាញ់​ជឹត​ពាង់​នៃ រ៝ង់​មា​ឞូ​ក្លោ​នៃ ឞ្រាស​យេឆូ ​ងើយ​លាស៖ “ហោម​ទូ​នតីល​មៃ​មោ​ហ៝ៈ​ជាន តាច់​លែៈ​ទ្រាប់​នទើ​មៃ ពាៈ​អ៝ន់​មា​មពោល​អ៝​អាច រី​មើ​មៃ​គែស​នទើ​ខ្លៃ​តា​ប៝ន​អ្វែស​តា​កាលើ។ ជេសរី​ហាន់​តឹង​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ជេស​ឞូ​ក្លោ​នៃ​តាង់​លាស​កើត​នៃ មុស​មាត់​ពាង់​ឆើស​រាអើយ្ស ជេសរី​ព្លឹ​ឆឹត នូយ្ស​នហ៝ម់​ពាង់​រាវៃ​ញហ្វាច​ហោ​ងាន់ យ៝រ​មា​ទុត​អ៝ក់​ទ្រាប់​នទើ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ឞ្រាស​យេឆូ ​អ្វាញ់​ជុម​ពាង់​នើម ជេសរី​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “ជេរ​ងាន់​មា​ឞូនុយ្ស​នទ្រ៝ង់​អ៝ន់​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","មពោល​អ៝ស​ម៝ន​នទ្រ៝ត់​ហីស​រាហ៝ល់​ហោ​ងាន់​មា​នាវ​ពាង់​ងើយ​អី​នៃ។ ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់​ជឹត៖ “ហើយ​អ៝ស​នោ នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ជេរ​ងាន់​លាប់! ");
INSERT INTO cmok_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","មា​ឞូនុយ្ស​នទ្រ៝ង់​លាប់​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ ជេរ​រាលាវ​ដាស​អ៝ន់​ឆែស​ឆាមោ​លាប់​តា​ត្រោម​ងលាយ”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","មពោល​អ៝ស​ម៝ន​នទ្រ៝ត់​ហីស​រាហ៝ល់​លើ​ហោ​ជឹត ជេសរី​អោប​នទ្រាង់​ខាន់​ពាង់​នើម៖ “លាស​ឞូនុយ្ស​នទ្រ៝ង់​លែៈ​គែស​ជេរ​ជេស​មា​អ៝ន់​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​ពាង់ លាស​នទ្រី​ឞូនុយ្ស​អា​អេង​ហោម​ទើយ​អ៝ន់​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ដ៝ង់​មោ​លាស​មោ?” ");
INSERT INTO cmok_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ឞ្រាស​យេឆូ ​ងគឹល​អ្វាញ់​ជឹត​ខាន់​ពាង់​លាស៖ “នាវ​អ្យា​ឞូនុយ្ស​ជាន​មោ​អោស​ទើយ យើន​មា​កោរាញ​ឞ្រាស​ហោម​ទើយ​ជាន យ៝រ​លាស​ទឹង​លែៈ​នទើ​ពាង់​ជាន​ទើយ​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ពេត្រោស ​លាស​មា​ឞ្រាស​យេឆូ ៖ “លែៈ​មៃ​ឆៃ​ជេស​ហេន ហេន​លែៈ​នត្លើយ​នទ៝ស​នទើ​ហេន​នើម​លែៈ​ផ្យៅ ហាន់​តឹង​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ឞ្រាស​យេឆូ ​អើស​លាស៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ ឞូ​ម៝ស​នត្លើយ​ញីស​ជៃ អ៝ស​នោ អ៝ស​នូរ មេៈ​ឞឹ អ៝ស​ក៝ន មោ​លាស​មីរ​ឞា យ៝រ​មា​តឹង​គ៝ប់ នទ្រែល​មា​តឹង​នាវ​មហែ​មហាន​អ្វែស‌ ");
INSERT INTO cmok_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","នទ្រី​ទឹង​កោរាញ​ឞ្រាស​ងខោម​តា​នាវ​រេស​ជេង​ពាង់​អី​នៃ​អាបៃ​អ្យា​អ៝ន់​អ៝ក់​ងាន់​ងេន​មា​ញីស​ជៃ អ៝ស​នោ អ៝ស​នូរ មេៈ​ឞឹ អ៝ស​ក៝ន នទ្រែល​មា​មីរ​ឞា។ ពាង់​ឞូ​ជាន​នាវ​ក្រីត​ជេរ​ដ៝ង់ យើន​មា​នារ​ជឹត​នាប់​តៃ​ពាង់​ទើន​នាវ​រេស​នហ៝​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ល៝ង់​អ៝ក់​ឞូនុយ្ស​អី​ឞើស​នាប់​ព្លាច់​ឞើស​កើយ ឞូនុយ្ស​អី​ឞើស​កើយ​ព្លាច់​ឞើស​នាប់​ច្រាវ។ គែស​អ៝ក់​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា​ឞូ​គឹត​ខាន់​ពាង់​គែស​នាវ​ខ្លៃ​ងាន់ យើន​មា​ជឹត​នាប់​តៃ​មោ​គែស​អោស​នាវ​ខ្លៃ តីស​មា​គែស​អ៝ក់​ឞូនុយ្ស​អេង​ជឹត​តា​នែស​នតូ​អ្យា​ឞូ​គឹត​ខាន់​ពាង់​មោ​គែស​អោស​នាវ​ខ្លៃ យើន​មា​តា​ជឹត​នាប់​តៃ​គែស​នាវ​ខ្លៃ​ច្រាវ”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​ហាវ​ជឹត​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ។ ពាង់​ហាន់​ឞើស​នាប់​ឞូ ល៝ង់​មពោល​អ៝ស​ម៝ន​រាវៃ​រោត​អោត​ងាន់ លែៈ​ឞូ​អី​ហាន់​តឹង​ឞើស​កើយ​ក្លាច​ដ៝ង់។ ជេសរី​ឞ្រាស​យេឆូ ​លែវ ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​នៃ​ហាន់​នតុក​អេង​បាស​មា​ឞូ ងក៝ច​មា​នាវ​អី​គែស​ត៝ត់​មា​ឆាក់​ពាង់​នើម​តៃ៖ ");
INSERT INTO cmok_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“អាបៃ​អ្យា​ឞ៝ន់​ហាវ​ជឹត​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ។ គ៝ប់​អ្យា​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស ឞូ​ទែ​ញជុន​អ៝ន់​មា​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់។ ជេសរី​ខាន់​ពាង់​អី​នៃ​តេៈ​ទោយ្ស​គ៝ប់​ត៝ត់​ខឹត ញជុន​គ៝ប់​មា​ផូង​អី​មោ​ទី​ផូង​អីឆ្រាអែល ។ ");
INSERT INTO cmok_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","លែៈ​ផូង​អី​នៃ​គើម​ងគ្រើស​គ៝ប់ ឆ៝ស​ទាក​ទីវ​តា​គ៝ប់ រាពាត់​គ៝ប់​មា​ម៝ង់​រាឆែ ជេសរី​ងខឹត​លើយ​គ៝ប់ យើន​មា​លោច​ពែ​នារ​ឞើស​កើយ​នៃ​គ៝ប់​ទ៝ក់​រេស​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ជេសរី​រ៝ៈ​ត្រ៝ង​នៃ​ឞារ​ហៃ​អ៝ស​នោ​ខាន់​ពាង់​យាកើ  នទ្រែល​មា​យោហាន ​អី​ក៝ន​ឆេបេដេ ​ទាន់​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​នើម​នតី! ទាន់​មៃ​យោៈ​អ៝ន់​តឹង​នាវ​ហេន​ទាន់​ដ៝ង់​អើ”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ឞ្រាស​យេឆូ ​អោប​ខាន់​ពាង់៖ “ម៝ស​នទើ​អុច​គ៝ប់​ជាន​អ៝ន់​មា​ខាន់​មៃ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ខាន់​ពាង់​អើស​លាស៖ “នោក​មៃ​ជេង​កាដាច់​ម៝ត់​អ្វាញ់​ឞ្រី​កោរាញ​ឞ្រាស​តៃ អ៝ន់​ហេន​គុ​កេង​មៃ​នើម​ម៝ត់​អ្វាញ់​នទ្រែល​មៃ ទូ​ហ្វេ​គុ​ឞើស​មា ទូ​ហ្វេ​គុ​ឞើស​ច្យៅ​អើ”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ឞ្រាស​យេឆូ ​អើស​នាវ​នតឹត​លាស៖ “ឞារ​ហៃ​ខាន់​មៃ​នៃ​មោ​គឹត​អោស​ម៝ស​នទើ​ទាន់។ នទ្រី​ខាន់​មៃ​ទើយ​ឆ៝ៈ​ទើន​ញេត​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​តា​កាច៝ក​អី​គ៝ប់​ឞែ​ទើយ​ដ៝ង់? ខាន់​មៃ​ទើយ​ទើន​ដ៝ង់​នាវ​បាប់តែម​អី​គ៝ប់​ទើន​លាស​មោ?” ");
INSERT INTO cmok_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ខាន់​ពាង់​អើស៖ “អើ ហេន​ទើយ​ឆ៝ៈ​ទើន”។ ឞ្រាស​យេឆូ ​លាស៖ “ខាន់​មៃ​ឆ៝ៈ​ទើន​ញេត​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​តា​កាច៝ក​អី​គ៝ប់​ញេត នទ្រែល​មា​ទើន​នាវ​បាប់តែម​អី​គ៝ប់​ទើន​តៃ​ងាន់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","តីស​មា​អី​នាវ​គុ​ឞើស​មា​ឞើស​ច្យៅ​រី គ៝ប់​មោ​អោស​ទើយ​រ៝ម យ៝រ​មា​នតុក​អី​នៃ​លែៈ​នទ្រាប់​អ៝ន់​មា​ឞូនុយ្ស​អី​កោរាញ​ឞ្រាស​នើម​អុច​អ៝ន់​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ត៝ត់​មា​មពោល​អ៝ស​ម៝ន​អី​ជឹត​នុយ្ស​នៃ​តាង់​លាស​កើត​នៃ ខាន់​ពាង់​ជី​នូយ្ស​ដាស​យាកើ  នទ្រែល​មា​យោហាន ។ ");
INSERT INTO cmok_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ជេសរី​ឞ្រាស​យេឆូ ​ក្វាល់​លែៈ​រាងោច​មពោល​អ៝ស​ម៝ន​ពាង់ពាង់​លាស៖ “ខាន់​មៃ​លែៈ​គឹត​ជេស​ឞូនុយ្ស​អី​ជាន​កាដាច់​មា​ផូង​ឞូនុយ្ស​អី​មោ​ទី​ផូង​អីឆ្រាអែល  ខាន់​ពាង់​អី​នៃ​ទាស​អុច​ជាន​មា​ផូង​ប៝ន​លាន​ខាន់​ពាង់​នើម។ គែស​ដ៝ង់​មពោល​អី​តេស​ក្វ៝ង់​តុន​ជ៝ត​ផូង​ប៝ន​លាន​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","តា​មពោល​ខាន់​មៃ​លើយ​អោស​ជាន​កើត​នៃ! តា​មពោល​ខាន់​មៃ​លាស​គែស​ទូ​ហ្វេ​អុច​ជាន​ក្វ៝ង់ អ៝ន់​ពាង់​អី​នៃ​ជេង​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មា​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","លាស​គែស​ទូ​ហ្វេ​អុច​ជាន​ក្វ៝ង់​រាលាវ​ឞូ អ្យាត់​មា​ពាង់​ជាន​ទឹក​មា​ទឹង​លែៈ​ឞូនុយ្ស​អេង​ប៝ត់‌ ");
INSERT INTO cmok_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","យ៝រ​មា​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ជុរ​តា​នែស​នតូ​អ្យា មោ​អោស​គ៝ប់​ដាៈ​ឞូ​ឆើម​កើល​ជាន​ការ​អ៝ន់​មា​គ៝ប់។ គ៝ប់​ច្រាវ​ឆើម​កើល​ជាន​ការ​អ៝ន់​មា​ឞូ ជេសរី​គ៝ប់​ឆើម​ឆាក់​គ៝ប់​នើម​ត៝ត់​ខឹត​ឆាក់ គៃ​មា​ច្វាយ​ទឹង​លែៈ​ឞូនុយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ហាន់​ត៝ត់​តា​ប៝ន​យេរីខោ ។ នោក​ខាន់​ពាង់​លោស​ឞើស​ប៝ន​យេរីខោ ​នៃ ផូង​ប៝ន​លាន​ឞ្រោៈ​នទ្រែល​ទ្រឺម។ គែស​ដ៝ង់​ទូ​ហ្វេ​ឞូ​ក្លោ​ចែស​មាត់ រាញា​បារតីមេ ​អី​ក៝ន​តីមេ ​គុ​ក៝ប់​ទាន់​ព្រាក់​ឞូ​តា​មែង​ត្រ៝ង​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ត៝ត់​ពាង់​តាង់​ឞូ​លាស៖ “យេឆូ ​ប៝ន​នាឆារែត ​ឞ្រោៈ​ត៝ត់​តា​អ្យា” ពាង់​នតែរ​លាស៖ “ហើយ​កោរាញ​យេឆូ ​អី​ក៝ន​ឆៅ​កាដាច់​ដាវីត ! ទាន់​យោៈ​នអាច​មា​គ៝ប់​បាៈ​អើ!” ");
INSERT INTO cmok_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","អ៝ក់​ឞូនុយ្ស​លាស​ពាង់​គុ​រាក្លាក់​ហ៝ៈ​លើយ​ហោម​នតែរ យើន​មា​ពាង់​នតែរ​លើ​មា​នតែសៗ​លាស៖ “ហើយ​ក៝ន​ឆៅ​កាដាច់​ដាវីត ! ទាន់​យោៈ​នអាច​មា​គ៝ប់​បាៈ​អើ!” ");
INSERT INTO cmok_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ជេសរី​ឞ្រាស​យេឆូ ​ញឆ្រុង​ព្លឹ​លាស៖ “ដាៈ​ពាង់​ហាន់​អា​អ្យា”។ ជេសរី​ឞូ​ដាៈ​ឞូនុយ្ស​ចែស​មាត់​នៃ​លាស៖ “លើយ​ហោម​រាវៃ ទ៝ក់​ហ៝ម់ ពាង់​ក្វាល់​មៃ​ហើយ”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ឞូនុយ្ស​ចែស​មាត់​អី​នៃ​មអារ់​ច្រ៝ប់​អាវ​ក្វ៝ង់ ទ៝ក់​ដើប​ហាន់​រាន​ទឺស​អា​ឞ្រាស​យេឆូ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ជេសរី​ឞ្រាស​យេឆូ ​អោប​ពាង់៖ “ម៝ស​នទើ​អុច​គ៝ប់​ជាន​អ៝ន់​មា​មៃ​មេស?” ឞូនុយ្ស​ចែស​មាត់​អី​នៃ​អើស​លាស៖ “ហើយ​នើម​នតី! ដាៈ​មៃ​ជាន​ត្រោម​មាត់​គ៝ប់​អ៝ន់​ឆៃ​អាង​អើ”។ ");
INSERT INTO cmok_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “មៃ​ហាន់​ឆឹត​អ៝ន់​អ្វែស​លាង់​យឹ! នាវ​មៃ​ញឆីង​មា​គ៝ប់​លែៈ​ជាន​ឞាស​មៃ​ជេស!” ទោ​មា​អ្វាញ់​ឆៃ​អាង​រ៝ នហ៝​មា​ហាន់​តឹង​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​នទ្រែល​មពោល​អ៝ស​ម៝ន​ជឹត​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ។ ខាន់​ពាង់​ត៝ត់​កេង​ប៝ន​បេតផាឆេ  នទ្រែល​មា​ប៝ន​បេថានី ​អី​គុ​តា​យោក​តើម​អោលីវ ​មោ​ហោម​ងាយ​មា​ប៝ន​យេរូឆាលឹម ។ ជេសរី​ពាង់​ដាៈ​ឞារ​ហៃ​អ៝ស​ម៝ន​ហាន់​ល៝រ ពាង់​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“អ៝ន់​ខាន់​មៃ​ហាន់​តា​ប៝ន​ឞើស​នាប់​រី លាប់​តា​ប៝ន​នៃ​ខាន់​មៃ​មរា​ឆៃ​ទូ​មល៝ម់​ក៝ន​ឆែស​លៀ​ឞូ​ក៝ត់​តា​នៃ ឆែស​លៀ​អី​នៃ​អេ​ហ៝ៈ​គែស​ឞូ​ញច៝​អោស អ៝ន់​ខាន់​មៃ​ទ្រីស​តេក​ពាង់​ឞើស​រី​អា​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","លាស​គែស​ឞូ​អោប​ខាន់​មៃ៖ «ម៝ស​ជាន​ទ្រីស​ខាន់​មរែ​នៃ​មេស?» ខាន់​មៃ​អើស​លាស៖ «កោរាញ​អុច​ញច៝​ពាង់»។ ជេសរី​ពាង់​ដាៈ​តេក​មព្លឹ​តា​អ្យា​តៃ​គើញ​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ជេសរី​ខាន់​ពាង់​ហាន់​រ៝ង់​ឞ្រ៝ង់​ត៝ត់​តា​នៃ​ឆៃ​ទូ​មល៝ម់​ក៝ន​ឆែស​លៀ ឞូ​ក៝ត់​ឞើស​ទីស​មពោង​ច្វាញ​មែង​ត្រ៝ង ជេសរី​ខាន់​ពាង់​ទ្រីស។ ");
INSERT INTO cmok_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","តា​នៃ​គែស​ឞូ​បាបាៈ​អោប​មា​ខាន់​ពាង់៖ “ម៝ស​ជាន​ខាន់​មរែ​នៃ? ម៝ស​ជាន​ទ្រីស​ក៝ន​ឆែស​លៀ​អី​នៃ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ឞារ​ហៃ​ខាន់​ពាង់​នៃ​អើស​មា​ឞូ​តឹង​នាវ​អី​ឞ្រាស​យេឆូ ​ទែ​នតិញ​នើស ជេសរី​ឞូ​អ៝ន់​ខាន់​ពាង់​តេក។ ");
INSERT INTO cmok_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ខាន់​ពាង់​លោស​ឞើស​ប៝ន​នៃ​តេក​លែវ​អ៝ន់​មា​ឞ្រាស​យេឆូ  ជេសរី​លាក់​អាវ​ក្វ៝ង់​ខាន់​ពាង់​នើម​កាលើ​ឆែស​លៀ​នៃ អ៝ន់​ឞ្រាស​យេឆូ ​ញច៝​ហាន់​ជឹត​ប៝ន​យេរូឆាលឹម ។ ");
INSERT INTO cmok_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","គែស​អ៝ក់​ឞូនុយ្ស​លែវ​ឞាល់​ឆ៝ៈ​អាវ​ក្វ៝ង់​ខាន់​ពាង់​នើម​លាក់​រ៝ៈ​ត្រ៝ង​ឞើស​នាប់​ឞ្រាស​យេឆូ ​រី ល៝ង់​ឞូ​បាបាៈ​ជឹត​តែ​នថាន​ឆី​ឞើស​មីរ​លាក់​រ៝ៈ​ត្រ៝ង​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ទឹង​លែៈ​ឞូនុយ្ស​អី​ឞ្រោៈ​តឹង​ឞ្រាស​យេឆូ ​ឞើស​នាប់​ឞើស​កើយ លែវ​ឞាល់​នតែរ​ទ្រើវ​លាស៖ “រានេ​មា​កោរាញ​ឞ្រាស! ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​ពាង់​អី​កោរាញ​ឞ្រាស​ទែ​ដាៈ​វាច់! ");
INSERT INTO cmok_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​នាវ​ពាង់​ម៝ត់​អ្វាញ់​អី​មរា​ម៝ត់​អ្វាញ់​ហេន​តឹម​ឞាន​មា​កាដាច់​ដាវីត ​អី​ចែ​ហេន​ឞើស​កាល់​អែ​នើស! រានេ​មា​កោរាញ​ឞ្រាស! រានេ​មា​កោរាញ​ឞ្រាស​អី​គុ​កាលើ​ត្រោក​ទុត​ព្រេស​រី!” ");
INSERT INTO cmok_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ឞ្រាស​យេឆូ ​លែៈ​ត៝ត់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ពាង់​ហាន់​លាប់​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស។ ជេស​អ្វាញ់​ជុម​អាប់​ផ្យៅ​ឞ្រី​លែៈ​កេង​មាង់​ជេស នទ្រី​ទឹង​ពាង់​ព្លឹ​តា​ប៝ន​បេថានី ​នទ្រែល ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន។ ");
INSERT INTO cmok_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","កាស​អោយ​តៃ​ខាន់​ពាង់​លោស​ឞើស​ប៝ន​បេថានី ​នៃ​ហាន់​ជឹត​ប៝ន​យេរូឆាលឹម ឞ្រាស​យេឆូ ​ជី​ង៝ត​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ពាង់​អ្វាញ់​ឞើស​ងាយ​ឆៃ​តើម​រាវី ​ទូ​តើម​គែស​នហា​នអឹរ​រាងឹត ពាង់​ហាន់​អ្វាញ់​ទាច់​ងខេប​លាស​គែស​ព្លៃ។ ត៝ត់​តា​តើម​នៃ​ឆៃ​ទើម​អី​នហា អេ​ហ៝ៈ​ទី​ខៃ​ព្លៃ​ទុម​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​តើម​រាវី ​អី​នៃ៖ “នតើម​ឞើស​នារ​អ្យា​មោ​ហោម​គែស​អោស​ឞូនុយ្ស​ឆា​ព្លៃ​មៃ!” នាវ​ព្រែ​លាស​នៃ មពោល​អ៝ស​ម៝ន​ពាង់​តាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ជេសរី​ឞ្រាស​យេឆូ ​នទ្រែល​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​ត៝ត់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ។ ពាង់​ហាន់​លាប់​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស ផូង​អី​តាច់​រាគ៝ល់​តា​នៃ​ពាង់​មព្រើស​លែៈ​ផ្យៅ។ ពាង់​ងក្លឹ​គ្រែ​ឞូ​គុ​រាគ៝ល់​ព្រាក់ នទ្រែល​មា​គ្រែ​ឞូ​តាច់​ព្លុក។ ");
INSERT INTO cmok_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ពាង់​មោ​អោស​អ៝ន់​ឞូ​ញអោត​លែវ​នទ៝ស​នទើ​លាប់​គ្លាត់​រ៝ៈ​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ឞ្រាស​យេឆូ ​នតុម​នតី​មា​ឞូ​លាស៖ “តា​ឆ៝ម់បុត​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​ញចីស​លាស៖ «ញីស​គ៝ប់​ជេង​នតុក​អ៝ន់​មា​ទឹង​លែៈ​ឞូនុយ្ស​អាប់​ឞ្រី​ទាក​មឞើស​ឆើម» បេង​មា​ខាន់​មៃ​ឆ៝ៈ​ជាន​នតុក​គុ​រាគូម​មពោល​នតុង​ច្រាវ”។ ");
INSERT INTO cmok_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ត៝ត់​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​គឹត​នាវ​អី​នៃ ខាន់​ពាង់​លែវ​ឞាល់​គៃ​មា​ជ៝យ​នាវ​មើម​ទឹង​គែស​ងខឹត​លើយ​ឞ្រាស​យេឆូ ។ យើន​មា​ខាន់​ពាង់​ក្លាច​ពាង់ យ៝រ​មា​ផូង​ប៝ន​លាន​នទ្រ៝ត់​ហីស​រាហ៝ល់​ហោ​ងាន់​មា​នាវ​នតុម​នតី​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ត៝ត់​កេង​មាង់​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​លោស​ឞើស​ប៝ន​អី​នៃ​ព្លឹ​តៃ​តា​ប៝ន​បេថានី ។ ");
INSERT INTO cmok_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","កាស​អោយ​តៃ​ហាន់​រ៝ៈ​ត្រ៝ង មពោល​អ៝ស​ម៝ន​ឆៃ​តើម​រាវី ​នើស នទ្រ៝​ប្រុង​ត៝ត់​អា​រែស​ឆូ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ជេសរី​ពេត្រោស ​កាស​គឹត​នាវ​អី​ឞ្រាស​យេឆូ ​លាស​នើស មឞើស​មា​ពាង់​លាស៖ “ហើយ​នើម​នតី! ល៝ង់​អ្វាញ់​អ្យា តើម​រាវី ​អី​មៃ​រាតាប់​នើស​លែៈ​នទ្រ៝​ងាន់​មេ!” ");
INSERT INTO cmok_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ញឆីង​មា​កោរាញ​ឞ្រាស​ហ៝ម់! ");
INSERT INTO cmok_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ លាស​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​លាស​មា​យោក​អ្យា៖ «ហាន់​ទូ​ឞើស​នតុក​អ្យា​តុប​អា​ទាក​វាច់​ទាក​វារ់​រី​ហ៝ម់!» លាស​ឞូនុយ្ស​អី​នៃ​មោ​គែស​នាវ​វិ​វែៈ​តា​នូយ្ស​នហ៝ម់​មា​នទើ​អី​នៃ នហ៝​មា​ញឆីង​មា​នទើ​អី​ពាង់​លាស​នៃ​មរា​គែស​ងាន់ នទ្រី​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​ទើយ​តឹង​នាវ​ពាង់​លាស​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","នទ្រី​ទឹង​គ៝ប់​មឞើស​មា​ខាន់​មៃ ម៝ស​នទើ​អី​ខាន់​មៃ​មឞើស​ឆើម​ទាន់ អ៝ន់​ខាន់​មៃ​ញឆីង​គែស​ងាន់ ជេសរី​កោរាញ​ឞ្រាស​អ៝ន់​មា​ខាន់​មៃ​គែស​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ជេសរី​ជឹត នោក​ខាន់​មៃ​មឞើស​ឆើម លាស​ខាន់​មៃ​គែស​នាវ​ជី​នូយ្ស​ដាស​ឞូ អ៝ន់​ខាន់​មៃ​គែស​នាវ​យោៈ លើយ​ហោម​អោស​កើប​នាវ​តីស​ឞូ នទ្រី​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​មៃ​អី​គុ​តា​កាលើ​ត្រោក​លើ​ហោ​យោៈ​នអាច​មោ​ហោម​កើប​នាវ​តីស​ខាន់​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","តីស​មា​លាស​ខាន់​មៃ​មោ​គែស​នាវ​យោៈ ហោម​កើប​នាវ​តីស​ឞូ កោរាញ​ឞ្រាស​ឞឹ​ខាន់​មៃ​អី​គុ​តា​កាលើ​ត្រោក​មោ​យោៈ ហោម​កើប​នាវ​តីស​មា​ខាន់​មៃ​ដ៝ង់។” ");
INSERT INTO cmok_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ឞ្រាស​យេឆូ ​ហាន់​ត៝ត់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​នទ្រែល​មពោល​អ៝ស​ម៝ន​ទូ​តឹ​ជឹត។ នោក​ពាង់​ឞ្រោៈ​រាឆ៝ង​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស ត៝ត់​ឞ្រោៈ​មពោល​កោរាញ​ជាន​ឞ្រាស ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​កោរាញ​ឞ្រី​យូដា ​ម៝ប់​អោប​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ទាន់​មឞើស​អ៝ន់​មា​ហេន​គឹត នទើ​មៃ​ជាន​អ្យា​ឞើស​តាៈ​នាវ​ទើយ? ឞូ​ម៝ស​អ៝ន់​នាវ​ទើយ​អី​នៃ​មា​មៃ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ឞ្រាស​យេឆូ ​អើស​លាស៖ “គ៝ប់​ទាន់​អោប​ទូ​នាវ​មា​ខាន់​មៃ​ប៝ត់។ ល៝ង់​ខាន់​មៃ​អើស​មា​គ៝ប់​ដ៝ង់ នទ្រី​មើ​គ៝ប់​មឞើស​មា​ខាន់​មៃ​តៃ ឞើស​តាៈ​នាវ​ទើយ​គ៝ប់​ជាន​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ទាន់​អើស​មា​គ៝ប់ លាស​នទ្រី​ឞូ​ម៝ស​ដាៈ​យោហាន-​បាប់តែម ​ជាន​បាប់តែម​យុក​មា​ទាក? តាៈ​ឞើស​កោរាញ​ឞ្រាស មោ​លាស​តាៈ​ឞើស​ឞូនុយ្ស?” ");
INSERT INTO cmok_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ខាន់​ពាង់​តឹម​ញច្រាៈ​អេង​លាស៖ “លាស​ឞ៝ន់​លាស៖ «តាៈ​ឞើស​កោរាញ​ឞ្រាស» ពាង់​មរា​លាស​ឞ៝ន់៖ «លាស​នទ្រី​មើម​ទឹង​ខាន់​មៃ​មោ​អ្យាត់​នាវ​ពាង់?» ");
INSERT INTO cmok_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","លាស​ឞ៝ន់​អើស​លាស៖ «តាៈ​ឞើស​ឞូនុយ្ស»”។ នទ្រី​ខាន់​ពាង់​ក្លាច​ផូង​ប៝ន​លាន​ជី​នូយ្ស យ៝រ​មា​អ៝ក់​ឞូនុយ្ស​អ្យាត់​នាវ​យោហាន-​បាប់តែម  កើប​ពាង់​ជេង​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ជេសរី​ខាន់​ពាង់​អើស​មា​ឞ្រាស​យេឆូ ៖ “ហេន​មោ​គឹត​អោស!” ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “លាស​នទ្រី​គ៝ប់​មោ​ដ៝ង់​មឞើស​អ៝ន់​មា​ខាន់​មៃ​គឹត ឞូ​ម៝ស​អ៝ន់​នាវ​ទើយ​គ៝ប់​ជាន​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ជេសរី​ឞ្រាស​យេឆូ ​ងើយ​នាវ​នតឹត​មា​ខាន់​ពាង់​លាស៖ “គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​តាម់​តើម​ព្លៃ​យុងយារ​ប៝ន​ទូ​លោក​មីរ។ ពាង់​ជាន​ងគារ​ជុម​មីរ​នៃ ជាន​ទូ​នតុក​មា​ឞូ​ញជ៝ត​ព្លៃ​អី​នៃ នទ្រែល​មា​ជាន​ទូ​មល៝ម់​ច្វាញ​ងកើង​ដ៝ង់​គៃ​មា​ញជ្រាង់។ ជេសរី​អ៝ន់​ឞូ​ម៝ត់​មីរ​អី​នៃ ដាៈ​ឞូ​ពាៈ​ព្លៃ​មា​ពាង់​អាប់​នាម់ អី​ពាង់​នើម​រី​ហាន់​គុ​ឞ្រី​អេង។ ");
INSERT INTO cmok_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ត៝ត់​ទី​ខៃ​ទុម​ព្លៃ​យុងយារ​ប៝ន​រី ពាង់​ដាៈ​ទូ​ហ្វេ​ទឹក​ពាង់​ហាន់​តឹម​ម៝ប់​មា​មពោល​ម៝ត់​មីរ​អី​នៃ គៃ​មា​ឆ៝ៈ​ព្លៃ​អី​ឞូ​ពាៈ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","បេង​មា​ឞូ​ទែ​ញុប​លើស​អោឞាល់ ជេសរី​មព្រើស​អោឞាល់​អ៝ន់​ឆឹត​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ពាង់​អី​នើម​តើម​មីរ​នៃ ដាៈ​ទូ​ហ្វេ​ទឹក​ជឹត​ហាន់​ដ៝ង់ មពោល​អី​ម៝ត់​មីរ​នៃ​មឞាង​ឞោក​អោឞាល់​នៃ នហ៝​មា​រាក​ឆ្វាយ​អោឞាល់​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ជេសរី​ពាង់​ដាៈ​ទូ​ហ្វេ​ទឹក​ជឹត​ហាន់។ មពោល​អី​ម៝ត់​មីរ​អី​នៃ​ងខឹត​អោឞាល់​នៃ។ ជេសរី​ទឹក​ពាង់​អាបាៈ​អេង​ជឹត​ឞូ​ទែ​លើស​កើត​នៃ​ដ៝ង់ អាបាៈ​ឞូ​ទែ​មឞាង អាបាៈ​ឞូ​ទែ​ងខឹត​លើយ។ ");
INSERT INTO cmok_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ពាង់​អី​នើម​តើម​មីរ​នៃ​ហោម​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​អេង​ជឹត​គុ​នទ្រែល​ពាង់ ជេង​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​អី​ពាង់​នើម​រ៝ង់​ហោ​ងាន់។ កេង​មា​ទុត​ពាង់​ដាៈ​អី​ក៝ន​នៃ​ហាន់​ឞើស​កើយ​ឞូ ពាង់​មឹន​អេង​លាស៖ «ឞូ​ក្លាច​យើក​មា​ក៝ន​គ៝ប់​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","តីស​មា​មពោល​អី​ម៝ត់​មីរ​នៃ​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ «ពាង់​អី​នៃ​រ៝​នត្រ៝ៈ​នទើន​មីរ​អី​អ្យា​នារ​ជឹត​នាប់​តៃ ហាន់​ឞ៝ន់​ងខឹត​លើយ​ពាង់​អី​នៃ​ទោស នទ្រី​មើ​មីរ​អី​អ្យា​នហ៝​គែស​មា​ឞ៝ន់​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ជេសរី​ឞូ​ទែ​ញុប​អី​ក៝ន​ពាង់​នើម​អី​តើម​មីរ​នៃ ងខឹត​លើយ​អោឞាល់​មអារ់​ឞើស​ទីស​មីរ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","នទ្រី​មើម​ពាង់​អី​តើម​មីរ​នៃ​ជាន? ពាង់​ហាន់​ងខឹត​លើយ​មពោល​អី​ម៝ត់​មីរ​នៃ​រ៝ ជេសរី​ជាវ​មីរ​តើម​ព្លៃ​យុងយារ​ប៝ន​អី​នៃ​អ៝ន់​មា​ឞូ​អេង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","នទ្រី​ខាន់​មៃ​មោ​គែស​រ៝ៈ​ឆ៝ម់បុត​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​គែស​ញចីស​លាស៖ «ឞូនុយ្ស​ឞ្លាវ​ជាន​ជៃ​លុ​ឞ្ល៝ន​លែៈ​មអារ់​លើយ​ទូ​មល៝ម់​លុ​ឞ្ល៝ន‌ យើន​មា​លុ​ឞ្ល៝ន​អី​នៃ​ជេង​លុ​ឞ្ល៝ន​ទុត​ន៝ប់​ខ្លៃ​រាលាវ​ឞូ​ច្រាវ​មា​ជាន​ជៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","កោរាញ​ឞ្រាស​នើម​ជាន​នាវ​អី​នៃ​លែៈ​នាវ​ងាន់‌ ជាន​អ៝ន់​ឞ៝ន់​នទ្រ៝ត់​ញហីស​ហោ​ងាន់»”។ ");
INSERT INTO cmok_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ត៝ត់​មា​មពោល​កោរាញ​ជាន​ឞ្រាស ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​កោរាញ​ឞ្រី​យូដា ​គឹត​លាស​ពាង់​ងើយ​នតឹត​នាវ​អី​នៃ​លាស​មា​ឆាក់​ខាន់​ពាង់​នើម ជេសរី​ខាន់​ពាង់​អុច​ញុប​ឞ្រាស​យេឆូ  តីស​មា​ខាន់​ពាង់​ក្លាច​មា​ផូង​ប៝ន​លាន នទ្រី​ខាន់​ពាង់​លោស​ទូ​ឞើស​ពាង់​នៃ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ជេសរី​ខាន់​ពាង់​ដាៈ​ផូង​ផារីឆី ​បាបាៈ នទ្រែល​មា​មពោល​អី​តឹង​កោរាញ​ម៝ត់​អ្វាញ់​ហេរោត-​អ៝ន់តីពាស ​ហាន់​គុ​ទាច់​កេង​ឞ្រាស​យេឆូ ​គៃ​មា​តាង់​នាវ​ពាង់​ងើយ​នទើ​តីស នទ្រី​ទឹង​ខាន់​ពាង់​ជ៝យ​នាវ​មា​នតោន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ជេសរី​ខាន់​ពាង់​ហាន់​ត៝ត់​តា​នៃ​អោប​ពាង់៖ “ហើយ​នើម​នតី! ហេន​គឹត​មៃ​ឞូនុយ្ស​ឆ៝ង់​ងាន់ មៃ​មោ​អោស​ក្លាច​មា​ឞូនុយ្ស មោ​អោស​កើយ្ស​ឞូនុយ្ស មៃ​នតី​នាវ​កោរាញ​ឞ្រាស​អ៝ន់​ទី។ ទាន់​មឞើស​មា​ហេន​តឹង​នាវ​វៃ​ឞ៝ន់ ទី​ដ៝ង់​អ៝ន់​ព្រាក់​អី​កោរាញ​កាដាច់​តា​ប៝ន​រោម​ដាៈ​ឞ៝ន់​អ៝ន់​នៃ​មោ​លាស​មោ? ");
INSERT INTO cmok_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ទី​មា​ឞ៝ន់​អ៝ន់​មោ​លាស​មោ?” យើន​មា​ឞ្រាស​យេឆូ ​លែៈ​គឹត​នូយ្ស​នហ៝ម់​នទ៝ប់​មពោន​ខាន់​ពាង់ ពាង់​លាស៖ “ម៝ស​នាវ​ខាន់​មៃ​អុច​អោប​រាល៝ង​មា​គ៝ប់​កើត​នៃ​មេស? ល៝ង់​ឆ៝ៈ​ព្រាក់​អី​អ៝ន់​មា​កាដាច់​អី​នៃ​ទូ​មល៝ម់​អ៝ន់​គ៝ប់​អ្វាញ់”។ ");
INSERT INTO cmok_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ជេសរី​ឞូ​ឆ៝ៈ​ព្រាក់​ទូ​កាក់​នទឹ​អ៝ន់​ឞ្រាស​យេឆូ ។ ពាង់​អោប​មា​ខាន់​ពាង់៖ “នទ្រី​តា​កាលើ​ព្រាក់​កាក់​អ្យា​ឞូ​ម៝ស​រូប ឞូ​ម៝ស​រាញា?” ខាន់​ពាង់​អើស​លាស៖ “រូប នទ្រែល​មា​រាញា​កោរាញ​កាដាច់​តា​ប៝ន​រោម !” ");
INSERT INTO cmok_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “លាស​នទ្រី​នទើ​កោរាញ​កាដាច់​តា​ប៝ន​រោម ​មព្លឹ​អ៝ន់​មា​ពាង់ នទើ​កោរាញ​ឞ្រាស​មព្លឹ​អ៝ន់​មា​កោរាញ​ឞ្រាស​នើម”។ ខាន់​ពាង់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ហោ​ងាន់​មា​នាវ​ឞ្រាស​យេឆូ ​អើស។ ");
INSERT INTO cmok_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ជេសរី​គែស​ផូង​ឆាដោឆី ​ហាន់​ម៝ប់​ពាង់ ផូង​អី​នៃ​ជាន​កោរាញ​តា​ឞ្រី​យូដា ​ដ៝ង់ តីស​មា​ខាន់​ពាង់​មោ​អ្យាត់​អោស​ឞូនុយ្ស​លែៈ​ខឹត​ហោម​ទ៝ក់​រេស​ជឹត។ ខាន់​ពាង់​គែស​ទូ​នាវ​អោប​មា​ឞ្រាស​យេឆូ ៖ ");
INSERT INTO cmok_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ហើយ​នើម​នតីមោឆេ ​កាល់​អែ​នើស​លែៈ​ញចីស​ជេស​តា​ឆ៝ម់បុត​អ៝ន់​មា​ឞ៝ន់​ផូង​អីឆ្រាអែល ​លាស​កើត​នអា៖ «លាស​ឞូ​ក្លោ​ឆ៝ៈ​អូរ ជេសរី​ពាង់​ខឹត លាស​ពាង់​មោ​គែស​ក៝ន ដាៈ​អី​អ៝សៗ​ពាង់​រី​នត្រ៝ៈ​ឆ៝ៈ​អូរ​ពាង់​គៃ​មា​គែស​ក៝ន​មា​ពាង់»។ ");
INSERT INTO cmok_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","នតឹត​លាស​គែស​ពើស​នុយ្ស​អ៝ស​នោ​ឞូ​ក្លោ។ អី​នោ​ឞោក​ទាក​នៃ​ឆ៝ៈ​អូរ ជេសរី​ខឹត​មោ​ឞាៈ​ក៝ន​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ជេសរី​អី​អ៝ស​គ្រ៝យ​ឞើស​កើយ​ពាង់​នៃ​នត្រ៝ៈ​ឆ៝ៈ​អី​មី​នៃ ជេសរី​ខឹត​មោ​ឞាៈ​ក៝ន​ដ៝ង់។ អី​អ៝ស​ត៝ល់​ពែ​ឞើស​កើយ​ឆ៝ៈ​អី​មី​នៃ​ខឹត​កើត​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ទឹង​លែៈ​ពើស​នុយ្ស​អ៝ស​នោ​ខាន់​ពាង់​នៃ​មោ​ឞាៈ​ក៝ន​ទាទេ។ ទុត​មា​ទេល​ឞូ​អូរ​អី​នៃ​ខឹត​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ត៝ត់​នារ​ឞូនុយ្ស​ទ៝ក់​រេស​តៃ នទ្រី​ឞូ​ម៝ស​អោប​ពាង់​«អូរ»? យ៝រ​លាស​លែៈ​ពើស​នុយ្ស​ខាន់​ពាង់​នើស​លែៈ​តាៈ​ឆ៝ៈ​ពាង់​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​មោ​វ៝ត់​អោស​នាវ​កោរាញ​ឞ្រាស​ងើយ នអ៝ប់​មា​មោ​វ៝ត់​ដ៝ង់​នាវ​ទើយ​កោរាញ​ឞ្រាស នទ្រី​ទឹង​នាវ​មឹន​ខាន់​មៃ​មោ​ទី​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","នោក​ឞូនុយ្ស​ខឹត ជេសរី​ទ៝ក់​រេស​តៃ ខាន់​ពាង់​មោ​ហោម​អោស​ឆ៝ៈ​អូរ​ឆ៝ៈ​ឆាយ​ជឹត។ ខាន់​ពាង់​ជេង​តឹម​ឞាន​មា​តោង​ពារ់​កោរាញ​ឞ្រាស​គុ​តា​ប៝ន​អ្វែស​កាលើ”។ ");
INSERT INTO cmok_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“ល៝ង់​មា​នាវ​ឞូនុយ្ស​ខឹត​ទ៝ក់​រេស​តៃ មោឆេ ​លែៈ​ញចីស​លាស​តា​ព្លាង់​ត្រ៝ង​ពុម​ល៝ក​អី​គែស​ហីត​អុញ នទ្រី​ខាន់​មៃ​វៃ​រ៝ៈ​ដ៝ង់​លាស​មោ? តា​នៃ​កោរាញ​ឞ្រាស​លាស​មា​ពាង់៖ «គ៝ប់​ជេង​ឞ្រាស​អាឞ្រាហាម់ ​យើក​មឞាស ជេង​ឞ្រាស​អីឆាក់ ​យើក​មឞាស ជេង​ឞ្រាស​យាកោប ​យើក​មឞាស»។ ");
INSERT INTO cmok_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","នោក​កោរាញ​ឞ្រាស​ងើយ​នាវ​អី​នៃ ខាន់​ពាង់​ពែ​នុយ្ស​អី​នៃ​លែៈ​ខឹត​អ៝ក់​នាម់​ជេស។ យើន​មា​ឞើស​នាវ​កោរាញ​ឞ្រាស​ងើយ​អី​នៃ​គឹត​នាល់​ខាន់​ពាង់​ហោម​រេស​មា​កោរាញ​ឞ្រាស។ កោរាញ​ឞ្រាស​មោ​អោស​ទី​ឞ្រាស​មា​ឞូនុយ្ស​ខឹត ពាង់​ឞ្រាស​មា​ឞូនុយ្ស​រេស។ តីស​ងាន់​នាវ​ខាន់​មៃ​មឹន​នៃ!” ");
INSERT INTO cmok_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ជេសរី​ត៝ត់​ឞ្រោៈ​ទូ​ហ្វេ​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  តាង់​ខាន់​ពាង់​តឹម​រាលាច់​ដាស​ឞ្រាស​យេឆូ  ជេសរី​តាង់​នាវ​ឞ្រាស​យេឆូ ​អើស​នៃ​ទី​ងាន់ ពាង់​ហាន់​ទាច់​អោប​ឞ្រាស​យេឆូ ៖ “ទឹង​លែៈ​នាវ​វៃ​ឞ៝ន់ ម៝ស​នាវ​វៃ​អី​ខ្លៃ​រាលាវ​ឞូ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ឞ្រាស​យេឆូ ​អើស៖ “«ហើយ​ផូង​អីឆ្រាអែល ​អ្យាត់​ហ៝ម់! គែស​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ឞ៝ន់​ទូ​ហ្វេ​ទើម​អី​កោរាញ​ឞ្រាស​ងាន់​ងេន។ ");
INSERT INTO cmok_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","អ៝ន់​រ៝ង់​មា​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ខាន់​អៃ​មៃ​នើម មា​លែៈ​នូយ្ស​នហ៝ម់ មា​លែៈ​ហ្វេង មា​លែៈ​នហ៝ម់​ឆ្វាន នទ្រែល​មា​លែៈ​នាវ​មឹន» អ្យា​នាវ​វៃ​នតីល​ង្វាយ។ ");
INSERT INTO cmok_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","នាវ​វៃ​នតីល​ឞារ «អ៝ន់​រ៝ង់​មា​ឞូ​ច្យៅ​មែង​កើត​រ៝ង់​មា​ឆាក់​ខាន់​អៃ​មៃ​នើម​ដ៝ង់»។ មោ​គែស​អោស​នាវ​វៃ​អី​ខ្លៃ​រាលាវ​មា​ឞារ​អឹ​នាវ​វៃ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","នើម​នតី​នាវ​វៃ​នៃ​លាស​មា​ពាង់៖ “អើ​នើម​នតី ទី​ងាន់​នាវ​មៃ​លាស​នៃ​មេស។ គែស​ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ទើម មោ​ហោម​គែស​អោស​ឞ្រាស​អេង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ឞ៝ន់​រ៝ង់​មា​ពាង់​អ៝ន់​លែៈ​នូយ្ស​នហ៝ម់ អ៝ន់​លែៈ​មា​នាវ​មឹន​គឹត​ឞ្លាវ នទ្រែល​មា​អ៝ន់​លែៈ​ឞ្រាត់​ឆ្វាន ជេសរី​រ៝ង់​មា​ឞូ​ច្យៅ​មែង​កើត​រ៝ង់​មា​ឆាក់​ឞ៝ន់​នើម​ដ៝ង់ នាវ​អី​នៃ​ខ្លៃ​រាលាវ​ងាន់​មា​លែៈ​រាងោច​នទើ​ឞូ​ញហើរ នអ៝ប់​មា​លែៈ​មពោមពា​(ឆ្យុម)​គុច​មា​ជាន​ឞ្រាស​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ត៝ត់​ឞ្រាស​យេឆូ ​តាង់​ពាង់​អើស​គឹត​ឞ្លាវ​កើត​នៃ ឞ្រាស​យេឆូ ​លាស៖ “មៃ​មោ​គែស​គុ​ងាយ​ដាស​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​មៃ”។ ឞើស​កើយ​នៃ​មោ​ហោម​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​ឞាញ់​អោប​ឞ្រាស​យេឆូ ​នាវ​អេង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ឞ្រាស​យេឆូ ​ហោម​នតុម​នតី​ឞូ​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស ពាង់​លាស៖ “មើម​ទឹង​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់​ក្វាល់​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​រី​លាស​ក៝ន​ឆៅ​កាដាច់​ដាវីត ​ទើម? ");
INSERT INTO cmok_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ល៝ង់​កាដាច់​ដាវីត  ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​អ៝ន់​ពាង់​ងក៝ច៖ «កោរាញ​ឞ្រាស​លាស​មា​កោរាញ​គ៝ប់៖ «គុ​មពែស​ឞើស​មា​គ៝ប់​ហ៝ម់ ក៝ប់​ត៝ត់​គ៝ប់​អ៝ន់​ផូង​រាលាង់​ដាស​មៃ​ជេង​នតុក​រាកើល​ជ៝ង់​មៃ​ប៝ត់»»។ ");
INSERT INTO cmok_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","លាស​លែៈ​កាដាច់​ដាវីត ​នើម​ក្វាល់​ឞ្រាស​ក្រីស ​លាស​កោរាញ​ពាង់​នើម​កើត​នៃ យើន​មា​ក៝ន​ឆៅ​មោ​គែស​ក្វ៝ង់​រាលាវ​មា​អូ​ចែ លាស​នទ្រី​ឞ្រាស​ក្រីស ​មើម​ហោម​ឞ្លាវ​ក៝ន​ឆៅ​ដាវីត ​ជឹត?” អ៝ក់​ផូង​ប៝ន​លាន​គុ​តា​នៃ ខាន់​ពាង់​គែស​នូយ្ស​នហ៝ម់​រាម់​ហោ​ងាន់​តាង់​នាវ​ឞ្រាស​យេឆូ ​នតី។ ");
INSERT INTO cmok_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ឞ្រាស​យេឆូ ​នតុម​នតី​មា​ខាន់​ពាង់៖ “អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​ដាស​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់​នៃ យ៝រ​លាស​ខាន់​ពាង់​អុច​ញឆ៝ស​អាវ​ជ៝ង​អី​អ្វែស ជេសរី​ឞ្រោៈ​រាឆ៝ង គៃ​មា​អ៝ន់​ឞូ​គឹត​លាស​ខាន់​ពាង់​គែស​នាវ​ខ្លៃ​ងាន់ អុច​អ៝ន់​ឞូ​មឞាស​កុញ​ឞោក​មា​ខាន់​ពាង់​រ៝ៈ​នតុក​ឞូ​តាច់​រាគ៝ល់​ទ្រាប់​នទើ មោ​លាស​រ៝ៈ​ត្រ៝ង​ក្វ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ខាន់​ពាង់​អុច​គុ​ឞើស​នាប់​ឞូ​តា​នតុក​ឞូ​លឺ​តា​ញីស​រាបុន​ផូង​ឞ៝ន់ ជេសរី​លាស​ញេត​ក្វ៝ង់​ឆោង​ក្វ៝ង់​នៃ​អុច​គុ​តា​នតុក​ឞូ​យើក​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","តីស​មា​ខាន់​ពាង់​មរោស​ឞូ​អូរ​នទ្រោ​លែៈ​ខឹត​ឆាយ គៃ​មា​ឆ៝ៈ​ពីត​ទ្រាប់​នទើ​ញីស​ជៃ​ខាន់​ពាង់។ ជេសរី​ខាន់​ពាង់​ជាន​មឞើស​ឆើម​ទុត​ជ៝ៈ​ងាន់​អ៝ន់​ឞូ​អេង​តាង់ គៃ​មា​ញហើ​ខាន់​ពាង់​នើម​ជេង​ឞូនុយ្ស​រ៝ង់​មា​កោរាញ​ឞ្រាស​ងាន់។ ផូង​អី​នៃ​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​ទុត​ជ្រូ​រ៝​តា​នារ​ជឹត​នាប់​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​គុ​ឞើស​នាប់​ហុប​តេៈ​ញហើរ​មា​កោរាញ​ឞ្រាស​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស ពាង់​អ្វាញ់​ផូង​ប៝ន​លាន​ឆ៝ៈ​ព្រាក់​តេៈ​តា​ត្រោម​ហុប​នៃ។ ពាង់​ឆៃ​អ៝ក់​ឞូនុយ្ស​នទ្រ៝ង់​តេៈ​ព្រាក់​អ៝ក់ៗ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ជេសរី​ឆៃ​ទូ​ហ្វេ​ឞូ​អូរ​នទ្រោ​ខឹត​ឆាយ​អ៝​អាច។ ត៝ត់​តា​នៃ​ឞូ​នទ្រោ​អី​នៃ​ឆ៝ៈ​ព្រាក់​ឞារ​មល៝ម់​កាក់​ជេៈ​ទើម​អី​មោ​លាង់​គែស​ខ្លៃ​អោស​តេៈ​តា​ត្រោម​ហុប​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ឞ្រាស​យេឆូ ​ក្វាល់​មពោល​អ៝ស​ម៝ន​ពាង់ ជេសរី​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ កោរាញ​ឞ្រាស​កើប​ឞូ​អូរ​នទ្រោ​អ៝​អាច​អ្យា​តេៈ​ព្រាក់​អ៝ក់​រាលាវ​ទឹង​លែៈ​ឞូ​អី​តេៈ​ព្រាក់​តា​ហុប​អ្យា‌ ");
INSERT INTO cmok_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","យ៝រ​លាស​ទឹង​លែៈ​មពោល​អី​នៃ ព្រាក់​អី​ខាន់​ពាង់​តេៈ​តា​ត្រោម​ហុប​នើស ឆ៝ៈ​ព្រាក់​រាមែស​ឞើស​ឆាក់​ខាន់​ពាង់​នើម។ ល៝ង់​អី​ឞូ​អូរ​នទ្រោ​ទែ​នៃ ពាង់​ឞូនុយ្ស​អ៝​អាច​ហោ​ងាន់ ឞ៝ល​លាស​ព្រាក់​អី​នៃ​គៃ​មា​ឆ្យាម់​នាវ​រេស​ពាង់​នើម​កាដោយ​លែៈ ពាង់​ហោម​ឆ៝ៈ​លែៈ​ផ្យៅ​តេៈ​ញហើរ​មា​កោរាញ​ឞ្រាស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","នោក​ឞ្រាស​យេឆូ ​លោស​ឞើស​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស គែស​ទូ​ហ្វេ​អ៝ស​ម៝ន​មឞើស​មា​ពាង់៖ “ហើយ​នើម​នតី ល៝ង់​មៃ​អ្វាញ់​ញីស​ជាន​ឞ្រាស​ត៝​ទុត​អ្វែស​ទុត​ក្វ៝ង់​ងាន់ អី​លុ​ឞ្ល៝ន​ពាង់​ត៝​ក្វ៝ង់​ដ៝ង់!” ");
INSERT INTO cmok_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ឞ្រាស​យេឆូ ​លាស​មា​អ៝ស​ម៝ន​ពាង់​នៃ៖ “នារ​ជឹត​នាប់​តៃ លែៈ​ជៃ​ក្វ៝ង់ៗ​អី​មៃ​ឆៃ​នៃ​ឞូ​មរា​លើស​រាល៝ម់​លែៈ​ផ្យៅ​រ៝ មោ​ហោម​អោស​គែស​ទូ​មល៝ម់​លុ​ឞ្ល៝ន​តឹម​រាទាប់​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ជេសរី​ឞ្រាស​យេឆូ ​គុ​តា​យោក​តើម​អោលីវ ​តឹម​ឆ៝ង់​មា​ញីស​ជាន​ឞ្រាស។ ពេត្រោស យាកើ យោហាន  នទ្រែល​មា​អ៝ន់ទ្រេ  គុ​ងាយ​ដាស​ឞូ​អោប​អេង​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ហើយ​នើម​នតី ល៝ង់​មៃ​មឞើស​អ៝ន់​មា​ហេន​គឹត​ដ៝ង់ ទាស​ហោម​ជ៝ៈ​នារ​ត៝ត់​នាវ​អី​នៃ​មេស? លាស​នទ្រី​ម៝ស​នទើ​មឞេន​អ៝ន់​មា​ហេន​គឹត​លាស​នាវ​អី​នៃ​លែៈ​ឞើយ​ត៝ត់​ងាន់?” ");
INSERT INTO cmok_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “អ៝ន់​ខាន់​មៃ​ញជ្រាង់​ងាន់​ហ៝ៈ លើយ​ទឹង​អ៝ន់​ឞូ​មរោស​រាលាម់​ខាន់​មៃ​អ៝ន់​ញហើត​លាៈ​លេង។ ");
INSERT INTO cmok_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","យ៝រ​មា​នារ​ជឹត​នាប់​តៃ​គែស​អ៝ក់​ឞូ​នតូប​រាញា​គ៝ប់​លាស៖ «គ៝ប់​អ្យា​ឞ្រាស​ក្រីស ​ហែស!» ខាន់​ពាង់​លែវ​ញហើត​ឞូនុយ្ស​អ៝ក់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ត៝ត់​ខាន់​មៃ​តាង់​នាវ​មហែ​មា​នាវ​តឹម​លើស​តឹម​ឆ្រែស នទ្រែល​មា​តាង់​ឞូ​ងក៝ច​ញច្រ៝ស​មា​នាវ​តឹម​លើស​តឹម​ឆ្រែស លើយ​អោស​ក្លាច យ៝រ​លាស​លែៈ​នាវ​អី​នៃ​ពាង់​គែស​ងាន់​រ៝ យើន​មា​នារ​ងគ្លែៈ​ទុត​នែស​នតូ​អេ​ហ៝ៈ​ត៝ត់​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ទូ​មពោល​តឹម​លើស​ដាស​ទូ​មពោល​អេង​ជឹត ទូ​ឞ្រី​ទាក​តឹម​លើស​ដាស​ទូ​ឞ្រី​ទាក​អេង​ជឹត នតុក​បាបាៈ​គែស​នាវ​ងគារ់​នែស នទ្រែល​មា​គែស​នាវ​ជី​ឆ៝ត់​ជី​ង៝ត​ក្វ៝ង់​តា​នតុក​អេងៗ។ យើន​មា​នាវ​ជេរ​អី​នៃ​ជេង​នតើម​នាវ​ជេរ​ទើម តឹម​ឞាន​មា​នាវ​ឞូ​អូរ​នតើម​ត៝ត់​ជី​នទុល​គុ​អ៝ស។ ");
INSERT INTO cmok_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","នទ្រី​ខាន់​មៃ​ញជ្រាង់​ឆាក់​ហ៝ម់ យ៝រ​មា​ឞូ​ញជុន​ខាន់​មៃ​តា​នតុក​តេៈ​ទោយ្ស ឞូ​ឆ៝ៈ​ម៝ង់​រាពាត់​ខាន់​មៃ​តា​ត្រោម​ញីស​រាបុន​ផូង​ឞ៝ន់ នទ្រែល​មា​ឞូ​លែវ​ខាន់​មៃ​ឞើស​នាប់​កោរាញ​ក្វ៝ង់ ឞើស​នាប់​កាដាច់​ដ៝ង់ យ៝រ​មា​ខាន់​មៃ​តឹង​គ៝ប់។ ជេសរី​ខាន់​មៃ​ទើយ​ងក៝ច​នាវ​ញឆីង​មា​គ៝ប់​អ៝ន់​ឞូ​គឹត​ឞូ​តាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","អេ​ល៝រ​មា​នារ​ងគ្លែៈ​ទុត​គែស​ឞូនុយ្ស​មឞើស​នាវ​មហែ​មហាន​អ្វែស​អ៝ន់​មា​ប៝ន​លាន​អាប់​ងគ៝រ​ឞ្រី​តាង់​ល៝រ​ប៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ត៝ត់​ឞូ​ញុប​ខាន់​មៃ​ញជុន​តា​នតុក​ផាត​ទោយ្ស នោក​នៃ​លើយ​អោស​រាវៃ​ល៝រ​មា​នាវ​អី​ខាន់​មៃ​ងើយ​នៃ អ៝ន់​ខាន់​មៃ​ងើយ​តឹង​នាវ​ឞ្រាស​ហ្វេង​អ្វែស​អ៝ន់​មា​ខាន់​មៃ យ៝រ​មា​នាវ​ងើយ​អី​នៃ​មោ​អោស​លោស​តាៈ​ឞើស​ឆាក់​ខាន់​មៃ​នើម តាៈ​ឞើស​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","អ៝ស​មា​នោ ឞឹ​មា​ក៝ន​មរា​តឹម​រាលាម់​ញុប​ញជុន​អ៝ន់​ឞូ​ងខឹត នទ្រែល​មា​អី​ក៝នៗ​លែវ​ឞាល់​តឹម​រាទ៝ង់​ដាស​អី​មេៈ​ឞឹ នហ៝​មា​ញជុន​អ៝ន់​ឞូ​ងខឹត​លើយ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","យ៝រ​មា​ខាន់​មៃ​ញឆីង​មា​គ៝ប់ នទ្រី​អ៝ក់​ឞូ​មរា​ឞ្យាញ់​មា​ខាន់​មៃ។ យើន​មា​ឞូ​ម៝ស​អី​ទើយ​អ៝ត់ នហ៝​មា​ត៝ត់​លោច កោរាញ​ឞ្រាស​មរា​រាក្លាយ្ស​ពាង់​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ត៝ត់​ខាន់​មៃ​ឆៃ​នទើ​ទុត​បឹ​បើច​ឞូ​តេៈ​តា​នតុក​ក្ល៝ស​អ្វែស​អី​នតុក​ឞូ​មោ​អ៝ន់​តេៈ - ឞូ​ម៝ស​អី​រ៝ៈ​នាវ​អី​នៃ​អ៝ន់​ពាង់​គឹត​វ៝ត់​នាវ​អី​នៃ - ជេស​ឆៃ​នទើ​អី​នៃ​ឞូនុយ្ស​អី​គុ​តា​ឞ្រី​យូដា ​រី​អ៝ន់​ទូ​ញច្វាត់​នទែ​តា​យោក។ ");
INSERT INTO cmok_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ឞូ​ម៝ស​អី​គុ​កាលើ​ច៝រ​ជៃ​ល៝ង់ លើយ​ហោម​អោស​ជុរ​លាប់​តា​ត្រោម​ឆ៝ៈ​ទ្រាប់​នទើ។ ");
INSERT INTO cmok_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ឞូ​ម៝ស​អី​គុ​តា​មីរ លើយ​ហោម​ព្លឹ​តា​ជៃ​ឆ៝ៈ​អាវ​ក្វ៝ង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","នោក​នៃ​ឞូ​អូរ​នត្រែវ ឞូ​អូរ​មពូ​ត៝ស​ក៝ន​គែស​នាវ​រេស​រាញាល់​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","មឞើស​ឆើម​ទាន់​មា​កោរាញ​ឞ្រាស​ហ៝ម់ លើយ​អោស​អ៝ន់​គែស​នាវ​ត៝ត់​អ្យា​តា​ខៃ​ជី​កាត់។ ");
INSERT INTO cmok_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","តា​នោក​នៃ​គែស​នាវ​ជេរ​ជ៝ត់​ហោ​ងាន់។ នតើម​ឞើស​រានោក​កោរាញ​ឞ្រាស​ញជេង​ទឹង​លែៈ​នតីល​នទើ​ត៝ត់​អាបៃ​អ្យា នហ៝​មា​នារ​ជឹត​នាប់​តៃ មោ​ព្រ៝ត​ដ៝ង់​គែស​នាវ​ទុត​ជេរ​កើត​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","លាស​កោរាញ​ឞ្រាស​មោ​នហុច​លើយ​ទឹង​លែៈ​នារ​នៃ នទ្រី​មោ​ហោម​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​រេស ខឹត​លែៈ​ផ្យៅ យើន​មា​កោរាញ​ឞ្រាស​នហុច​លើយ​នារ​អី​នៃ យ៝រ​មា​ពាង់​យោៈ​មពោល​អី​លែៈ​ពាង់​កើយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","តា​នោក​នៃ​លាស​គែស​ឞូ​មឞើស​មា​ខាន់​មៃ៖ «ល៝ង់​មៃ​អ្វាញ់​ឞ្រាស​ក្រីស ​គុ​តា​អ្យា» មោ​លាស «គុ​តា​ត៝» លើយ​អោស​អ្យាត់​ឞូ។ ");
INSERT INTO cmok_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","យ៝រ​មា​គែស​ឞូនុយ្ស​នតូប​លាស​ឆាក់​ពាង់​ឞ្រាស​ក្រីស  នទ្រែល​មា​គែស​ឞូនុយ្ស​នតូប​លាស​ឆាក់​ពាង់​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស។ ខាន់​ពាង់​អី​នៃ​ជាន​នាវ​មឞេន​អី​ខ្លៃ​អេងៗ​ដ៝ង់ គៃ​មា​លែវ​ឞូនុយ្ស​អ៝ន់​ញហើត​លាៈ​លេង ងខេប​លាស​ទើយ​លែវ​ញហើត​ផូង​អី​កោរាញ​ឞ្រាស​លែៈ​កើយ្ស​ដ៝ង់ យើន​មា​មោ​ទើយ​អោស។ ");
INSERT INTO cmok_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","អ៝ន់​ញជ្រាង់​ងាន់​ហ៝ៈ! គ៝ប់​លែៈ​ងក៝ច​ល៝រ​អ៝ន់​មា​ខាន់​មៃ​នាវ​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“លោច​ជេស​នារ​ជេរ​ជ៝ត់​អី​នៃ តា​នោក​នៃ​នារ​ជេង​ង៝‌ ខៃ​មោ​ហោម​អោស​អាង‌ ");
INSERT INTO cmok_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","មាញ់​មឞីង​ដុស​ឞើស​ត្រោក‌ លែៈ​នទើ​អី​តេស​ក្វ៝ង់​កាលើ​ត្រោក​គែស​ងគើ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","នោក​នៃ​ទឹង​លែៈ​ឞូនុយ្ស​ឆៃ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស ហាន់​រ៝ៈ​នទ៝រ់​តុក​នអ៝ប់​មា​គែស​នាវ​ទើយ នទ្រែល​មា​នាវ​ច្រេក​លើប​ទុត​ហោ។ ");
INSERT INTO cmok_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ជេសរី​គ៝ប់​ញជ្វាល់​ផូង​តោង​ពារ់​គ៝ប់​ហាន់​អាប់​ព្វាន់​ញជោញ​ឞ្រី​លាម​នែស​នតូ នតើម​មពែស​ឞើស​លោស​នារ​ត៝ត់​មពែស​ឞើស​ញ៝ប់​នារ គៃ​មា​រាគូម​លែៈ​មពោល​អី​កោរាញ​ឞ្រាស​នើម​លែៈ​កើយ្ស​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","អ៝ន់​ខាន់​មៃ​ងក្ល៝ន់​រាវៃ​ទោ នាវ​នតឹត​មា​តើម​រាវី ។ លាស​ងគីង​ពាង់​គែស​ចាត់​នហា​ញឆែ​នអឹរ ខាន់​មៃ​គឹត​លាស​ខៃ​តា​មីស​ឞើយ​ត៝ត់​ហើយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","នទ្រី​លាស​ខាន់​មៃ​ឆៃ​នាវ​អី​នៃ​លែៈ​ត៝ត់ គឹត​រ៝​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ឞើយ​ត៝ត់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ លែៈ​នាវ​អ្យា​ពាង់​ត៝ត់​ទោល​ឞូនុយ្ស​តា​រានោក​អាបៃ​រី​ហោម​រេស។ ");
INSERT INTO cmok_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ត្រោក​នែស​នតូ​មរា​រ៝ស​លេក​រ៝ យើន​មា​នាវ​គ៝ប់​ងើយ​មោ​អោស​ឞ្លាវ​រ៝ស​លេក ហោម​គែស​ទឹង​លែៈ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ម៝ង​នារ​អី​នៃ​មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​ទើយ​គឹត ឞ៝ល​លាស​តោង​ពារ់​អី​គុ​តា​កាលើ​ត្រោក​អី​នតុក​កោរាញ​ឞ្រាស មោ​លាស​គ៝ប់​អី​ក៝ន​កោរាញ​ឞ្រាស​មោ​ទើយ​គឹត​ដ៝ង់ គែស​ទូ​ហ្វេ​ឞឹ​គ៝ប់​ទើម​ទើយ​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ខាន់​មៃ​មោ​អោស​ទើយ​គឹត​ម៝ង​នារ​ត៝ត់​ល៝រ នទ្រី​អ៝ន់​ញជ្រាង់​ឆាក់​ជាន់​ងាន់‌ ");
INSERT INTO cmok_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","យ៝រ​មា​នោក​ម៝ង​នារ​អី​នៃ​ត៝ត់​តឹម​ឞាន​មា​ទូ​ហ្វេ​ឞូ​ក្លោ​អី​លោស​ឞើស​ជៃ​ហាន់​នតុក​អេង។ ពាង់​ដាៈ​មពោល​ទឹក​ម៝ត់​អ្វាញ់​ជៃ នហ៝​មា​ពាៈ​នាវ​ជាន​ការ​អ៝ន់​មា​ទូ​ហ្វេ​ទូ​ហ្វេ ជេសរី​ពាង់​ដាៈ​ឞូនុយ្ស​អី​ចាម់​ជៃ​នៃ​ញជ្រាង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","លាស​នទ្រី​អ៝ន់​ខាន់​មៃ​គុ​រាងែស​ញជ្រាង់​ងាន់​កើត​នៃ​ដ៝ង់ យ៝រ​លាស​ខាន់​មៃ​មោ​គឹត​អោស​ម៝ង​នារ​អី​នៃ តឹម​ឞាន​មា​ទឹក​អី​នៃ​មោ​គឹត​អោស​ម៝ង​នារ​តើម​ជៃ​នៃ​ព្លឹ​ឆឹត គឹត​មាង់​គឹត​ងគូល​មាង់​គឹត​នទ្រាវ​អ្យារ់ មោ​លាស​អើម​អោយ។ ");
INSERT INTO cmok_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ក្លាច​លាស​ត៝ត់​ពាង់​ព្លឹ​ឆឹត​មោ​គែស​មឞើស​ល៝រ ជេសរី​ឆៃ​ខាន់​មៃ​ហាក់​ឞិច។ ");
INSERT INTO cmok_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","នាវ​អី​គ៝ប់​មឞើស​មា​ខាន់​មៃ​អ្យា គ៝ប់​អុច​មឞើស​មា​ទឹង​លែៈ​ឞូនុយ្ស​ដ៝ង់៖ អ៝ន់​គុ​រាងែស​ញជ្រាង់​ឆាក់!” ");
INSERT INTO cmok_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ជេសរី​បុន​នហ៝ត នទ្រែល​មា​បុន​នុមពាង់​មោ​គែស​នទ្រូយ​ហោម​ឞារ​នារ​មា​ត៝ត់។ មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​ជ៝យ​នាវ​មើម​ទឹង​គែស​ញុប​នតុង​ឞ្រាស​យេឆូ ​ងខឹត​លើយ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ខាន់​ពាង់​តឹម​ញច្រាៈ​ឞាល់​លាស៖ “លើយ​អោស​ឞ៝ន់​ញុប​តា​នោក​ជាន​បុន ក្លាច​គែស​នាវ​អុស​អាស​តាស​ត៝រ់​មា​ផូង​ប៝ន​លាន”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​តា​ប៝ន​បេថានី ។ ពាង់​គុ​តា​ជៃ​ទូ​ហ្វេ​ឞូ​ក្លោ​រាញា​ឆីមោន ​អី​តាៈ​គែស​ផុង​ឆា។ នោក​នៃ​តឹង​មា​នាវ​វៃ​ផូង​នទ្រ៝ង់​ខាន់​ពាង់​ឆោង​ឆា​គុ​ឞិច​ងកេង​ជឹត​ច្យៅ អី​ជ៝ង់​រ៝ក​ជឹត​កើយ។ នោក​ពាង់​ឆោង​ឆា​នទ្រែល​ត៝ត់​ឞ្រោៈ​ទូ​ហ្វេ​ឞូ​អូរ​លាប់​តា​ជៃ​នៃ​ញអោត​ទូ​មល៝ម់​ដ៝ប​លុ។ តា​ត្រោម​ដ៝ប​នៃ​គែស​ងី​បោ​កាស​អី​ខ្លៃ​ងាន់ អី​ឞូ​ក្វាល់​លាស​ទាក​ងី​«នារតូ»។ ជេសរី​ពាង់​គិច​លើយ​ឞោក​ដ៝ប​លុ​អី​នៃ​ត៝ៈ​ងី​បោ​កាស​តា​ឞោក​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","គែស​ឞូ​បាបាៈ​អី​គុ​តា​នៃ​ជី​នូយ្ស ខាន់​ពាង់​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ “ម៝ស​ជាន​មពុង​មពាង់​ងី​បោ​កាស​កើត​នៃ! ");
INSERT INTO cmok_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","លាស​ឆ៝ៈ​ព្រីង​អី​នៃ​តាច់​គែស​ព្រាក់ ៣០០ ព្រាក់​កាក់​រាលាវ​រ៝​យាៈ ជេសរី​ពាៈ​មា​ឞូនុយ្ស​អ៝​អាច”។ ជេសរី​ខាន់​ពាង់​នទុយ្ស​អោឞាល់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ល៝ង់​ឞ្រាស​យេឆូ ​ទែ​លាស៖ “អ៝ន់​ទាស​មា​ជាន​ព្រែ​ហ៝ៈ! មើម​ទឹង​ខាន់​មៃ​ជាន​អ៝ន់​ពាង់​គែស​នាវ​រាង៝ត​កើត​នៃ? ពាង់​លែៈ​ជាន​នាវ​អ្វែស​អ៝ន់​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ផូង​អ៝​អាច​ហោម​គុ​នទ្រែល​ខាន់​មៃ​មរ៝។ ខាន់​មៃ​ជាន​អ្វែស​មា​ផូង​អី​នៃ​តឹង​នូយ្ស​នហ៝ម់​ខាន់​មៃ​នើម​អុច យើន​មា​គ៝ប់​អ្យា​មោ​អោស​គុ​នទ្រែល​ខាន់​មៃ​មរ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","យោស​អ្យា​ជាន​តឹង​នាវ​ទើយ​ពាង់។ ពាង់​ត៝ៈ​ងី​បោ​កាស​តា​ឆាក់​ជាន់​គ៝ប់​អេ​ល៝រ​មា​គ៝ប់​ខឹត ជេង​តឹង​នាវ​វៃ​ផូង​ឞ៝ន់​ជាន​មា​នទ្រាប់​អេ​ល៝រ​មា​ឞូ​ត៝ប់​ឞូនុយ្ស​ខឹត​តា​មោច។ ");
INSERT INTO cmok_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ អាប់​នតុក​ឞូ​ហាន់​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​លាម​ងគ៝រ​ឞ្រី​តា​នែស​នតូ​អ្យា ឞូ​ងក៝ច​មា​នាវ​អី​ពាង់​ជាន​នើស​ដ៝ង់ គៃ​មា​ងកាស​តោរ​ឞូ​ឞាស​ច្វេល​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ជេសរី​យូដាស-​អីឆាការីយោត ​ទូ​ហ្វេ​កោរាញ​អ៝ស​ម៝ន​តា​មពោល ១២ នុយ្ស ពាង់​ហាន់​ម៝ប់​ដាស​មពោល​កោរាញ​ជាន​ឞ្រាស គៃ​មា​តឹម​ញច្រាៈ​ឞាល់​លែវ​ឞូ​ញុប​ឞ្រាស​យេឆូ ​ញជុន​អ៝ន់​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ជេស​ផូង​អី​នៃ​តាង់​នាវ​យូដាស-​អីឆាការីយោត ​ងើយ​នៃ នូយ្ស​នហ៝ម់​ខាន់​ពាង់​រាម់​ងាន់ ខាន់​ពាង់​ត៝ន​ងខោម​ព្រាក់​មា​ពាង់។ នទ្រី​យូដាស-​អីឆាការីយោត ​នតើម​ជ៝យ​ម៝ស​នោក​អី​អ្វែស​គៃ​មា​លែវ​ឞូ​ហាន់​ញុប​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","តា​នារ​នតើម​នទ្រាប់​ញេត​បុន​នុមពាង់​មោ​គែស​នទ្រូយ ជេង​នារ​ឞូ​ងខឹត​ក៝ន​ឞែ​ឞ្យាប់​មា​ជាន​ឞ្រាស​គៃ​មា​ញេត​បុន​នហ៝ត ជេសរី​មពោល​អ៝ស​ម៝ន​អោប​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញ អាស​នតុក​មៃ​អុច​អ៝ន់​ហេន​នទ្រាប់​មា​មៃ​ញេត​ឆោង​បុន​នហ៝ត​អ្យា​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ឞ្រាស​យេឆូ ​ដាៈ​ឞារ​ហៃ​អ៝ស​ម៝ន​ហាន់​ជ៝យ​នតុក​មឞើស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ហាន់​តា​ប៝ន​ក្វ៝ង់​រី ខាន់​មៃ​ម៝ប់​ទូ​ហ្វេ​ឞូ​ក្លោ​តេៈ​ទាក​យាង់​កាលើ​មលីក។ អ៝ន់​ខាន់​មៃ​ហាន់​តឹង​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ម៝ស​ជៃ​ពាង់​លាប់ អ៝ន់​ខាន់​មៃ​ងើយ​មា​នើម​តើម​ជៃ​នៃ៖ «នើម​នតី​ហេន​ដាៈ​ហេន​ហាន់​អោប​មៃ ជ្រោ​មា​ពាង់​ញេត​បុន​នទ្រែល​អ៝ស​ម៝ន​ពាង់​តា​នារ​ញេត​បុន​នហ៝ត​អ្យា អាស​នតុក​មេស?» ");
INSERT INTO cmok_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ឞូនុយ្ស​តើម​ជៃ​នៃ​លែវ​មា​ខាន់​មៃ​រ៝​តា​នតុក​កាលើ​រី​ជ្រោ​ហ្វី​ងាន់ លែៈ​អើម​ជេស​នទ្រាប់​អាប់​លែៈ​ផ្យៅ។ អ៝ន់​ខាន់​មៃ​នទ្រាប់​នាវ​ញេត​ឆោង​អ៝ន់​មា​ឞ៝ន់​តា​ជ្រោ​នៃ​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ជេសរី​អ៝ស​ម៝ន​ឞារ​ហៃ​នៃ​ឞ្រោៈ​ទ្រើន​រ៝ ត៝ត់​តា​ប៝ន​ក្វ៝ង់​នៃ​ខាន់​ពាង់​ឆៃ​កើត​នាវ​ឞ្រាស​យេឆូ ​លាស​នើស ជេសរី​ខាន់​ពាង់​នទ្រាប់​នទើ​ឆោង​ឆា​មា​នាវ​ញេត​បុន​នហ៝ត​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ត៝ត់​កេង​មាង់​ឞ្រាស​យេឆូ ​ត្រុយ្ស​តា​នតុក​នៃ​នទ្រែល ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","នោក​ឞ្រាស​យេឆូ ​គុ​ឆោង​ឆា​នទ្រែល​មពោល​អ៝ស​ម៝ន ពាង់​មឞើស៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ តា​មពោល​ខាន់​មៃ​គែស​ទូ​ហ្វេ​លែវ​ឞូ​ហាន់​ញុប​គ៝ប់ ពាង់​អី​នៃ​គុ​ឆោង​ឆា​នទ្រែល​ឞ៝ន់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","មពោល​អ៝ស​ម៝ន​រាវៃ​ហោ​ងាន់ លែៈ​ខាន់​ពាង់​នៃ​អោប​ឞ្រាស​យេឆូ ៖ “នទ្រី​គឹត​គ៝ប់​ហើ?” ");
INSERT INTO cmok_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ពាង់​អី​នៃ​តាៈ​ឞើស ១២ នុយ្ស​មពោល​ខាន់​មៃ ពាង់​អី​លុប​នុមពាង់​តា​ងាន​នទ្រែល​គ៝ប់​អាបៃ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ឞូ​មរា​ងខឹត តឹង​មា​នាវ​លែៈ​ញចីស​លាស​មា​គ៝ប់។ តីស​មា​ពាង់​អី​លែវ​ឞូ​ហាន់​ញុប​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​នៃ ពាង់​អី​នៃ​គែស​នាវ​រេស​រាញាល់​ងាន់​រ៝។ អ្វែស​រាលាវ​លើយ​ទឹង​ទែស​ពាង់​អី​នៃ​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ខាន់​ពាង់​ហោម​គុ​ឆោង​ឆា ជេសរី​ឞ្រាស​យេឆូ ​ឆ៝ៈ​ទូ​មល៝ម់​នុមពាង់ លាស​អ្វែស​មា​កោរាញ​ឞ្រាស ជេសរី​គិច​អ៝ន់​មា​ខាន់​ពាង់​ឆា នហ៝​មា​លាស៖ “ខាន់​មៃ​ឆ៝ៈ​ឆា​យឹ អ្យា​អី​ឆាក់​ជាន់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ជេសរី​ពាង់​ឆ៝ៈ​កាច៝ក​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន លាស​អ្វែស​មា​កោរាញ​ឞ្រាស ជេសរី​អ៝ន់​មា​ខាន់​ពាង់​ញេត​លែៈ​មា​ឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ពាង់​លាស​មា​ខាន់​ពាង់៖ “នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​តា​កាច៝ក​អ្យា​អី​មហាម​គ៝ប់ អី​ហ៝ច​ឞើស​ឆាក់​ជាន់​គ៝ប់​នោក​គ៝ប់​ខឹត​តៃ គៃ​មា​រាក្លាយ្ស​អ៝ក់​ឞូនុយ្ស។ មា​មហាម​អី​អ្យា​កោរាញ​ឞ្រាស​ជាន​នាវ​តឹម​រាង្លាប់​មហែ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​មៃ គ៝ប់​មោ​ហោម​អោស​ញេត​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​អ្យា​ជឹត នហ៝​មា​ត៝ត់​នារ​គ៝ប់​ញេត​តៃ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​ត៝ត់​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ឞូនុយ្ស​ងាន់​មើ”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ជេស​មព្រើ​នាវ​តឹម​រានេ ឞ្រាស​យេឆូ  នទ្រែល​មពោល​អ៝ស​ម៝ន​ពាង់​លោស​ឞើស​នៃ​ហាន់​ជឹត​យោក​តើម​អោលីវ ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “ទឹង​លែៈ​ខាន់​មៃ​នត្លើយ​គ៝ប់ យ៝រ​មា​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​គែស​ញចីស៖ «កោរាញ​ឞ្រាស​លាស៖ «គ៝ប់​មឞាង​ងខឹត​លើយ​នើម​ច្យាប់​ឞែ​ឞ្យាប់‌ ជេសរី​ផូង​ឞែ​ឞ្យាប់​ទូ​ចាស​ច្រាយ​លែៈ»»។ ");
INSERT INTO cmok_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","យើន​មា​ជេស​គ៝ប់​ទ៝ក់​រេស​តៃ គ៝ប់​ហាន់​តា​ឞ្រី​កាលីលេ ​ល៝រ​ឞើស​នាប់​ខាន់​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ជេស​តាង់​ឞ្រាស​យេឆូ ​ងើយ​នទ្រី​ពេត្រោស ​លាស​មា​ពាង់៖ “ឞ៝ល​លាស​ទឹង​លែៈ​ខាន់​ពាង់​នត្លើយ​មៃ​កាដោយ គ៝ប់​មោ​អោស​នត្លើយ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​មៃ តា​មាង់​អ្យា​រ៝ អេ​ល៝រ​មា​អ្យារ់​នទ្រាវ​ឞារ​តឹ មៃ​រាលាច់​ពែ​តឹ​លាស​មោ​គឹត​នាល់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ពេត្រោស ​រាលាច់​លើ​មា​ហោ៖ “មោ​អោស! ឞ៝ល​លាស​ឞូ​ងខឹត​គ៝ប់​នទ្រែល​មៃ​កាដោយ គ៝ប់​មោ​គែស​អោស​រាលាច់​លាស​មោ​គឹត​នាល់​មៃ”។ ទឹង​លែៈ​មពោល​អ៝ស​ម៝ន​គែស​ងើយ​កើត​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​ជឹត​នតុក​ឞូ​រាញា​គេតឆេមានី ។ ពាង់​លាស៖ “ខាន់​មៃ​គុ​តា​អ្យា​ប៝ត់​យឹ គ៝ប់​ហាន់​មឞើស​ឆើម​ប៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ពាង់​ជាៈ​ពេត្រោស យាកើ  នទ្រែល​មា​យោហាន ​ហាន់​នទ្រែល។ នោក​នៃ​ពាង់​នតើម​គែស​នាវ​រាវៃ​ហោ​ងាន់ នូយ្ស​នហ៝ម់​មោ​ដាប់​មពាន់ រាង៝ត​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ពាង់​លាស​មា​ពែ​នុយ្ស​ខាន់​ពាង់​នៃ៖ “នូយ្ស​នហ៝ម់​គ៝ប់​រាង៝ត​ហោ​ងាន់​នទាៈ​មា​ខឹត​រ៝។ ខាន់​មៃ​ហោម​គុ​តា​អ្យា​ប៝ត់ គុ​រាងែស​ញជ្រាង់​ងាន់​ហ៝ៈ”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​ជឹត​នាប់​ដេៈ ពាន់​ត្រុយ្ស​អា​នែស​មឞើស​ឆើម​ទាន់​លើយ​តា​គែស​អោស​នាវ​ជេរ​ជ៝ត់ លាស​ទើយ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ពាង់​លាស៖ “អាប់បា​អើ​ឞឹ! ទាស​មៃ​នើម​អុច​មៃ​ទើយ​ជាន​ទឹង​លែៈ​នតីល​នាវ ទាន់​មៃ​ឆ៝ៈ​នាវ​ជេរ​ជ៝ត់​អ្យា​អ៝ន់​ទូ​ងាយ​ឞើស​គ៝ប់។ យើន​មា​លើយ​អោស​តឹង​នូយ្ស​នហ៝ម់​គ៝ប់​អុច អ៝ន់​តឹង​នាវ​មៃ​នើម​អុច​ហ៝ៈ”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ជេសរី​ពាង់​ព្លឹ​ជឹត​មពោល​អ៝ស​ម៝ន​នៃ ឆៃ​ខាន់​ពាង់​ហាក់​ឞិច ពាង់​លាស​មា​ពេត្រោស ៖ “ហើយ​ឆីមោន ​ម៝ស​ឞិច​មៃ​នៃ​ហ្យាស? ម៝ស​មៃ​មោ​ទើយ​ញឆ្រោយ្ស មាន​មា​ទូ​ម៝ង​មោ​ទើយ​ដ៝ង់? ");
INSERT INTO cmok_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ខាន់​មៃ​ញជ្រាង់​ហ៝ម់​នហ៝​មា​មឞើស​ឆើម គៃ​មា​មោ​ជាន​តីស​នោក​គែស​នាវ​នទើម។ នូយ្ស​នហ៝ម់​ឞូនុយ្ស​លែៈ​អុច​ជាន​ទី​ងាន់ តីស​មា​មោ​អោស​ឞ្លាវ​ជាន យ៝រ​មា​ហោម​រាអ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ជេសរី​ឞ្រាស​យេឆូ ​ទូ​តៃ​ឞើស​ខាន់​ពាង់ មឞើស​ឆើម​កើត​នាវ​អើម​នើស​ទូ​តឹ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ជេសរី​ពាង់​ព្លឹ​ឆឹត​ហាន់​ម៝ប់​មា​មពោល​អ៝ស​ម៝ន​ជឹត ឆៃ​ខាន់​ពាង់​ហោម​ហាក់​ឞិច លីន​មាត់​មោ​ទើយ ជេសរី​ជ៝យ​នាវ​អើស​មា​ពាង់​មោ​គែស។ ");
INSERT INTO cmok_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ឞ្រាស​យេឆូ ​ហាន់​ព្លឹ​ម៝ប់​តៃ​ខាន់​ពាង់​លែៈ​ពែ​តឹ​ជេស ពាង់​លាស​ខាន់​ពាង់៖ “ខាន់​មៃ​ហោម​ឞិច​ទាស​ជ៝ៈ​មា​កាស? ទាស​នៃ​គាប់​ហើយ្ស! អាបៃ​អ្យា​ម៝ង​លែៈ​ត៝ត់​ជេស ឞូ​ញជុន​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​អ៝ន់​មា​ផូង​ឞូនុយ្ស​តីស។ ");
INSERT INTO cmok_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ទ៝ក់​ហ៝ម់​លែវ​ឞាល់​ហាន់ ពាង់​អី​លែវ​ឞូ​ហាន់​ញុប​គ៝ប់​លែៈ​ឞើយ​ត៝ត់​ហើយ!” ");
INSERT INTO cmok_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ឞ្រាស​យេឆូ ​ហោម​អែ​ងើយ ទោ​មា​ត៝ត់​យូដាស-​អីឆាការីយោត ​ជេង​ទូ​ហ្វេ​ឞូនុយ្ស​តា ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​នៃ។ គែស​ទូ​ផូង​ហាន់​នទ្រែល​ពាង់​នៃ ញអោត​ម៝ង់​ញអោត​ដាវ។ ខាន់​ពាង់​អី​នៃ​តាៈ​ឞើស​មពោល​កោរាញ​ជាន​ឞ្រាស ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​កោរាញ​ឞ្រី​យូដា ​ទែ​ដាៈ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","យូដាស-​អីឆាការីយោត ​អី​លែវ​ឞូ​ហាន់​ញុប​ឞ្រាស​យេឆូ ​នៃ​លែៈ​ជេស​មឞើស​ទូ​នទើ​គឹត​នាល់​មា​ឞូ​លាស៖ “ឞូ​ម៝ស​អី​គ៝ប់​ចុមពាង់​អី​រី​រ៝។ នទ្រី​ខាន់​មៃ​ញុប​លែវ​ពាង់​ទោ”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ជេសរី​យូដាស-​អីឆាការីយោត ​ហាន់​ត៝ត់​តា​ឞ្រាស​យេឆូ ​រ៝ ពាង់​លាស៖ “ហើយ​នើម​នតី!” ពាង់​ចុម​ឞ្រាស​យេឆូ ‌ ");
INSERT INTO cmok_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ជេសរី​ឞូ​ញុប​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","គែស​ទូ​ហ្វេ​អ៝ស​ម៝ន​អី​គុ​ទាច់​តា​រី​តាក់​ដាវ​ច្រីប ឆ្រែស​តោរ​អី​ទឹក​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់​តាច់​ទូ​ទីង។ ");
INSERT INTO cmok_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ផូង​អី​នៃ៖ “ម៝ស​ឞ្រោៈ​ខាន់​មៃ​ញអោត​នអ៝ប់​មា​ម៝ង់​មា​ដាវ​គៃ​មា​ញុប​គ៝ប់​កើត​នៃ កើប​គ៝ប់​ជេង​ឞូនុយ្ស​នតុង​ឞើស? ");
INSERT INTO cmok_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","អាប់​នារ​កាល់​ទឹ​នើស គ៝ប់​គុ​នតុម​នតី​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស។ ខាន់​មៃ​គុ​តា​នៃ​ដ៝ង់ មោ​អោស​ញុប​គ៝ប់។ អ្យាត់​មា​គែស​នាវ​ត៝ត់​អ្យា​ជេង​ទី​ដាស​នាវ​កោរាញ​ឞ្រាស​ងើយ​អី​ឞូ​លែៈ​ញចីស”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ជេសរី​មពោល​អ៝ស​ម៝ន​ញច្វាត់​រាង៝ត់​លែៈ​ផ្យៅ នត្លើយ​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","គែស​ទូ​ហ្វេ​ឞូ​នទាម់​អី​តឹង​ពាង់ ឞូ​នទាម់​អី​នៃ​គែស​ឞ៝ក​ទូ​ឞ្លាស​ទើម​មា​ងគូត​ឆាក់​ជាន់ ឞូ​ទែ​ញុប​អោឞាល់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ពាង់​មអារ់​ឞ៝ក​អី​នៃ ញច្វាត់​ឆាក់​កុស​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ជេសរី​ឞូ​លែវ​ឞ្រាស​យេឆូ ​អា​ជៃ​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់។ លែៈ​មពោល​កោរាញ​ជាន​ឞ្រាស ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​កោរាញ​ឞ្រី​យូដា ​គុ​រាគូម​តា​រី​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ល៝ង់​ពេត្រោស ​រី​តឹង​ឞ្រាស​យេឆូ ​ឞើស​កើយ ឞ្រោៈ​នទ៝ប់​ឞោក​មពើល​ឞោក នហ៝​មា​ត៝ត់​តា​ត្រោម​ជ៝ង់​គូង​ជៃ​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់ ជេសរី​លាប់​គុ​ញជ៝រ់​អុញ​នទ្រែល​មពោល​ឞូនុយ្ស​កើល​ជាន​ការ​តា​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ទឹង​លែៈ​ផូង​កោរាញ​ជាន​ការ​ផូង​អីឆ្រាអែល ​តឹម​ញច្រាៈ​ឞាល់​ជ៝យ​នាវ​នតោន​ឞ្រាស​យេឆូ ​គៃ​មា​តេៈ​ទោយ្ស​ងខឹត​លើយ​ពាង់ ជ៝យ​មោ​អោស​ទើយ​ឆៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","គែស​អ៝ក់​ឞូនុយ្ស​ងើយ​ញចើត​នតោន​ពាង់ យើន​មា​ទឹង​លែៈ​នាវ​ខាន់​ពាង់​នតោន​នៃ​មោ​អោស​តឹម​ទី​ឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ឞូ​បាបាៈ​ទ៝ក់​ងើយ​ញចើត​នតោន​ឞ្រាស​យេឆូ ​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ហេន​តាង់​ពាង់​ងើយ​លាស៖ «គ៝ប់​រើយ្ស​មអារ់​លែៈ​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​អី​តី​ឞូនុយ្ស​ជាន ជេសរី​តា​ពែ​នារ​ឞើស​កើយ​នៃ​គ៝ប់​ជាន​ញីស​ជាន​ឞ្រាស​ទូ​មល៝ម់​អេង​ជឹត ញីស​ជាន​ឞ្រាស​អី​នៃ​មោ​គែស​អោស​តី​ឞូនុយ្ស​ជាន»”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ឞ៝ល​លាស​ខាន់​ពាង់​នតោន​មា​នាវ​អី​នៃ​កាដោយ ក៝ៈ​ហោម​មោ​តឹម​ទី​ឞាល់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ជេសរី​ទ៝ក់​ដឺប​អី​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់​នៃ ទ៝ក់​ឞើស​នាប់​លែៈ​ឞូនុយ្ស​អី​គុ​តា​នៃ ពាង់​អោប​ឞ្រាស​យេឆូ ៖ “មើម​មៃ​មោ​អើស​នាវ​ឞូ​នតោន​មៃ​នៃ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ឞ្រាស​យេឆូ ​គុ​អ្យាត់​ឆាក់​ក្លាក់​មោ​អើស​ដេៈ​រ៝។ កោរាញ​ជាន​ឞ្រាស​អោប​តៃ​ពាង់​ទូ​តឹ​ជឹត៖ “នទ្រី​មៃ​ជេង​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​ងាន់ អី​ក៝ន​កោរាញ​ឞ្រាស​ងាន់​បាស?” ");
INSERT INTO cmok_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ឞ្រាស​យេឆូ ​អើស៖ “អើ​គ៝ប់​អ្យា​ងាន់។ ទឹង​លែៈ​ខាន់​មៃ​មរា​ឆៃ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស គុ​ឞើស​មា​តី​កោរាញ​ឞ្រាស​នើម​អី​ទុត​នាវ​ទើយ​គៃ​មា​ម៝ត់​អ្វាញ់‌ ជេសរី​ជុរ​ឞើស​ត្រោក​រី​ហាន់​រ៝ៈ​នទ៝រ់​តុក”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ជេស​តាង់​ពាង់​ងើយ​កើត​នៃ កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់​នៃ​ងខេក​អាវ​ពាង់​នើម​ច្វីក ជេសរី​លាស៖ “ឞ៝ន់​មោ​ហោម​ខាច់​អោស​ជ៝យ​ឞូនុយ្ស​តើម​ឆៃ​តើម​តាង់​អា​អេង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","លែៈ​ខាន់​មៃ​តាង់​ទាទេ​ជេស​នាវ​ព្រែ​មឺច​រាម៝ត​កោរាញ​ឞ្រាស។ នទ្រី​មើម​ខាន់​មៃ​អុច​តេៈ​ទោយ្ស​មា​ពាង់?” ទឹង​លែៈ​ឞូ​លាស​តេៈ​ទោយ្ស​ងខឹត​លើយ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ឞូ​បាបាៈ​លែវ​ឞាល់​ឆ៝ស​ទាក​ទីវ​តា​អោឞាល់ ងកុម​មាត់​ថុក​អោឞាល់ ជេសរី​អោប៖ “លាស​មៃ​ឞ្រាស​ក្រីស ​ងាន់ មឞើស​មា​ហេន​ឞូ​ម៝ស​ថុក​មៃ!” ជេសរី​មពោល​តាហែន​ញជ្រាង់​ញីស​ជាន​ឞ្រាស​តាប​អោឞាល់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ល៝ង់​ពេត្រោស ​រី​ពាង់​ហោម​គុ​តា​ជ៝ង់​គូង ជេស​រី​ត៝ត់​ឞ្រោៈ​ទូ​ហ្វេ​ឞូ​អូរ​តា​នៃ ពាង់​ជាន​ការ​មា​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ត៝ត់​ឆៃ​ពេត្រោស ​គុ​ញជ៝រ់​អុញ​តា​នៃ ពាង់​អ្វាញ់​អ៝ន់​នហេល​អី​មុស​មាត់ ជេសរី​លាស៖ “ងាន់​មៃ​ជេង​ឞាល់​មពោល​យេឆូ ​ត៝​អី​តាៈ​ឞើស​ប៝ន​នាឆារែត !” ");
INSERT INTO cmok_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ពេត្រោស ​រាលាច់​លាស៖ “គ៝ប់​មោ​អោស​គឹត​វ៝ត់​ម៝ស​នាវ​អៃ​រែ​លាស​រី”។ ជេសរី​ពេត្រោស ​ទូ​ឞើស​នតុក​អី​នៃ​ហាន់​អា​មពោង​មពេរ នោក​នៃ​អ្យារ់​លែៈ​នតើម​នទ្រាវ។ ");
INSERT INTO cmok_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ជេសរី​ឞូ​អូរ​អី​ជាន​ការ​តា​នៃ​ឆៃ​ពេត្រោស ​គុ​តា​នៃ ពាង់​មឞើស​លែៈ​ឞូនុយ្ស​អី​គុ​តា​រី​ទូ​តឹ​ជឹត៖ “ពាង់​អី​នៃ​ឞាល់​មពោល​ឞូនុយ្ស​អី​ឞូ​ញុប​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ពេត្រោស ​រាលាច់​តៃ​ជឹត។ ត៝ត់​ទូ​នទ៝ម់​ឞើស​កើយ មពោល​ឞូនុយ្ស​អី​គុ​តា​នៃ​ងើយ​មា​ពេត្រោស ​លាស៖ “មៃ​អ្យា​ឞាល់​មពោល​ពាង់​ងាន់​រ៝ រាលាវ​មៃ​ឞ្រី​កាលីលេ ​តឹម​ឞាន”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ពេត្រោស ​ងើយ​លាស៖ “លាស​គ៝ប់​មរោស គ៝ប់​រាតាប់​ឆាក់​គ៝ប់​នើម ទាន់​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​មា​គ៝ប់​ទោស។ គ៝ប់​មោ​អោស​គឹត​នាល់​ពាង់​អី​ខាន់​អៃ​មៃ​លាស”។ ");
INSERT INTO cmok_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ទោ​មា​អ្យារ់​នទ្រាវ​ទូ​តឹ​ជឹត ជេសរី​ពេត្រោស ​នតើម​កាស​គឹត​នាវ​ឞ្រាស​យេឆូ ​លាស​នើស៖ “អេ​ល៝រ​មា​អ្យារ់​នទ្រាវ​ឞារ​តឹ​មៃ​រាលាច់​ពែ​តឹ​លាស​មោ​គឹត​នាល់​គ៝ប់”។ ជេសរី​ពាង់​ញុម​រាង៝ត​ហោ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","កាស​អោយ​តៃ​អើម​អោយ​មពោល​កោរាញ​ជាន​ឞ្រាស មពោល​កោរាញ​ឞ្រី​យូដា  ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​កោរាញ​ជាន​ការ​ផូង​ឞ្រី​យូដា ​ទឹង​លែៈ​តឹម​ម៝ប់​ឞាល់​តឹម​ញច្រាៈ​នាវ ជេសរី​ដាៈ​ឞូ​ចាប់​ឞ្រាស​យេឆូ ​លែវ​ញជុន​ពាង់​មា​កោរាញ​ក្វ៝ង់​ពីលាត ​អី​ឞូនុយ្ស​ផូង​រោម​។ ");
INSERT INTO cmok_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ពីលាត ​អោប​ឞ្រាស​យេឆូ ៖ “ងាន់​លាស​មៃ​កាដាច់​ផូង​អីឆ្រាអែល ​បាស?” ឞ្រាស​យេឆូ ​អើស​មា​ពាង់​លាស៖ “អើ កើត​នាវ​មៃ​លាស​នាវ​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","មពោល​កោរាញ​ជាន​ឞ្រាស​នតោន​ឞ្រាស​យេឆូ ​ជាន​តីស​អ៝ក់​នតីល​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ជេសរី​ពីលាត ​អោប​ពាង់​ទូ​តឹ​ជឹត៖ “ល៝ង់​ខាន់​ពាង់​នតោន​មៃ​ជាន​តីស​អ៝ក់​នតីល​ងាន់ ម៝ស​នាវ​ទឹង​មៃ​មោ​អុច​អើស?” ");
INSERT INTO cmok_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ឞ្រាស​យេឆូ ​មោ​អុច​អើស​ដេៈ​រ៝ នទ្រី​ទឹង​ពីលាត ​គែស​នាវ​នទ្រ៝ត់​ហីស​រាហ៝ល់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","អាប់​នាម់​តា​នារ​ញេត​បុន​នហ៝ត ពីលាត ​វៃ​មអើក​ទូ​ហ្វេ​ឞូនុយ្ស​ទោយ្ស​ឞូ​ម៝ស​អី​ផូង​ប៝ន​លាន​ទែ​ទាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​រាញា​បារាបាស ​ឞូ​ក្រុង​តា​នទ្រូង។ ឞូ​ញុប​ពាង់​នទ្រែល​មពោល​ឞូនុយ្ស​អី​លែៈ​តឹម​រាទ៝ង់​ដាស​ផូង​រោម  នទ្រែល​មា​លែៈ​ងខឹត​ឞូនុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ផូង​ប៝ន​លាន​លែវ​ឞាល់​ហាន់​ម៝ប់​មា​ពីលាត ​ទាន់​ពាង់​បើក​ទូ​ហ្វេ​ឞូនុយ្ស​ទោយ្ស​តឹង​មា​នាវ​វៃ​ពាង់​ជាន​អ៝ន់​មា​ប៝ន​លាន។ ");
INSERT INTO cmok_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ពីលាត ​អោប​ខាន់​ពាង់​លាស៖ “នទ្រី​ខាន់​អៃ​មៃ​អុច​អ៝ន់​គ៝ប់​បើក​លើយ​អី​កាដាច់​ផូង​អីឆ្រាអែល ​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ពាង់​លាស​កើត​នៃ យ៝រ​មា​ពាង់​លែៈ​គឹត​ជេស​នូយ្ស​នហ៝ម់​មពោល​កោរាញ​ជាន​ឞ្រាស​មោ​នាច នទ្រី​ទឹង​ខាន់​ពាង់​ញជុន​ឞ្រាស​យេឆូ ​អ៝ន់​មា​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","មពោល​កោរាញ​ជាន​ឞ្រាស​លែវ​ឞាល់​ញឆោច​ផូង​ប៝ន​លាន ងខើង​មា​ដាៈ​ពីលាត ​បើក​លើយ​បារាបាស ។ ");
INSERT INTO cmok_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ជេសរី​ពីលាត ​លាស​មា​ផូង​អី​នៃ​ទូ​តឹ​ជឹត៖ “នទ្រី​អា​មើម​ខាន់​អៃ​មៃ​អ៝ន់​គ៝ប់​ជាន​មា​ឞូនុយ្ស​អី​ខាន់​អៃ​មៃ​ក្វាល់​លាស​«កាដាច់​ផូង​អីឆ្រាអែល »​អ្យា?” ");
INSERT INTO cmok_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ឞូ​នតែរ​ទ្រើវ​លាស៖ “ងខឹត​ពាង់​តា​ឆី​តឹម​រាកាង់!” ");
INSERT INTO cmok_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ពីលាត ​អោប​តៃ​លាស៖ “ឞូនុយ្ស​អ្យា​ម៝ស​នាវ​តីស​តា​ពាង់?” ផូង​ប៝ន​លាន​នតែរ​ទ្រើវ​លើ​មា​ហោ​លាស៖ “ងខឹត​ពាង់​តា​ឆី​តឹម​រាកាង់!” ");
INSERT INTO cmok_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","អាច​មា​ពីលាត ​អុច​ជាន​តឹង​នាវ​ផូង​ប៝ន​លាន​ទាន់​នើស គៃ​មា​អ៝ន់​ខាន់​ពាង់​រាម់​មអាក ពាង់​បើក​លើយ​បារាបាស ។ ជេសរី​ពាង់​ដាៈ​តាហែន​រាពាត់​ឞ្រាស​យេឆូ ​មា​ម៝ង់​រាឆែ នហ៝​មា​ជាវ​អ៝ន់​តាហែន​ងខឹត​អោឞាល់​តា​ឆី​តឹម​រាកាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ជេសរី​ផូង​តាហែន​តេក​លែវ​ឞ្រាស​យេឆូ ​ហាន់​លាប់​តា​ជ៝ង់​គូង​ញីស​កោរាញ​ក្វ៝ង់។ ត៝ត់​តា​នៃ​ក្វាល់​លែៈ​ផូង​តាហែន​អ៝ន់​តឹម​ម៝ប់​ឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ឞូ​ទែ​ឆ៝ៈ​អាវ​ជ៝ង​ចាង់​អី​តឹម​ឞាន​មា​អាវ​កាដាច់​ញឆ៝ស​អ៝ន់​អោឞាល់​ញឆ៝ស ជេសរី​ឆ៝ៈ​រាតាវ​ល៝ក​បារ់​ជាន​មោក​កាដាច់​នទោ​តា​ឞោក​អោឞាល់​រី។ ");
INSERT INTO cmok_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ជេសរី​តាហែន​លែវ​ឞាល់​ងើយ​ងគ្រើស​ងគ្រាប់​មា​អោឞាល់​លាស៖ “ហើយ​កាដាច់​ផូង​អីឆ្រាអែល ! ហេន​យើក​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ជេសរី​តាហែន​ទែ​ឆ៝ៈ​ម៝ង់​រែស​រាពាត់​តា​ឞោក​ពាង់ ឆ៝ស​ទាក​ទីវ​តា​អោឞាល់​នហ៝​មា​ជាន​លាស​ច៝ន​កោម៝ក់​យើក​មឞាស​មា​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ជេស​ងគ្រើស​ងគ្រាប់​មា​អោឞាល់​កើត​នទ្រី ជេសរី​តាហែន​ទ្រ៝ស​លើយ​អាវ​ចាង់​ឞើស​ឆាក់​ពាង់ ព្លឹ​ញឆ៝ស​តៃ​អាវ​ពាង់​នើម​នើស ជេសរី​តេក​លែវ​អោឞាល់​អា​នតុក​ងខឹត​តា​ឆី​តឹម​រាកាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","រ៝ៈ​ត្រ៝ង​នៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​អី​តាៈ​ឞើស​ប៝ន​កីរេន ​ពាង់​តាៈ​ឞើស​ឞ្រី​លាប់​អា​ប៝ន។ តាហែន​ទែ​ញច៝ប់​អោឞាល់​តូយ​ឆី​តឹម​រាកាង់​ឞ្រាស​យេឆូ ។ ពាង់​អី​នៃ​រាញា​ឆីមោន ​អី​ឞឹ​អាលេកឆាន់ត្រុស  នទ្រែល​មា​អី​ឞឹ​រូផុស ។ ");
INSERT INTO cmok_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ជេសរី​តាហែន​លែវ​ឞ្រាស​យេឆូ ​ត៝ត់​តា​នតុក​អី​ឞូ​រាញា «កោលកោថា » រាឞ្លាង​លាស​«នតុក​នតីង​ឞោក»។ ");
INSERT INTO cmok_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ឞូ​ឆ៝ៈ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​លាយ​ដាស​ទាក​ឆី​តាង់​ទូ​នតីល​អី​ឞូ​ក្វាល់​លាស​«មឹរ »​អ៝ន់​ពាង់​ញេត‌​ពាង់​មោ​អុច​អោស​ញេត។ ");
INSERT INTO cmok_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ជេស​រី​តាហែន​ទែ​ងខឹត​អោឞាល់​តា​ឆី​តឹម​រាកាង់ នហ៝​មា​ឆ៝ៈ​ញុប​នទើ​ញច្រ៝ស​គៃ​មា​តឹម​ពាៈ​ឞាល់​ខ៝​អាវ​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","តា​ម៝ង​ឆឹន​អោយ​តាហែន​ងខឹត​ពាង់​តា​ឆី​តឹម​រាកាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ឞូ​ព្លា​កាដារ​ទូ​រាលាត​ញចីស​មឞើស​នាវ​តីស​ពាង់​លាស៖ «ពាង់​អ្យា​កាដាច់​ផូង​អីឆ្រាអែល »។ ");
INSERT INTO cmok_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","តា​នៃ​គែស​ដ៝ង់​ឞារ​ហៃ​ឞូនុយ្ស​នតុង ឞូ​ទែ​ងខឹត​តា​ឆី​តឹម​រាកាង់​កើត​ឞ្រាស​យេឆូ ​ដ៝ង់ អី​ទូ​ហ្វេ​អ៝ន់​ឞើស​មា​ពាង់ ទូ​ហ្វេ​ជឹត​អ៝ន់​ឞើស​ច្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","នាវ​ត៝ត់​អ្យា​តឹម​ទី​មា​នាវ​លែៈ​គែស​ញចីស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​លាស៖ «ពាង់​អី​នៃ​ឞូ​កើប​នទ្រែល​ឞូនុយ្ស​តីស»។ ");
INSERT INTO cmok_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","លែៈ​ឞូនុយ្ស​អី​ឞ្រោៈ​រ៝ៈ​នៃ ងគ្រើស​ងគ្រាប់​រាតែស​ឞោក​មា​អោឞាល់ នហ៝​មា​លាស៖ “ហើយ​ឞូនុយ្ស​លាស​រើយ្ស​លើយ​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស ជាន​តៃ​អី​មហែ​ពែ​នារ​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","លាស​នទ្រី​រាក្លាយ្ស​អេង​ឆាក់​មៃ​នើម​ជុរ​ឞើស​ឆី​តឹម​រាកាង់​នៃ​ហ៝ម់!” ");
INSERT INTO cmok_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​លែវ​ឞាល់​ងើយ​ងគ្រើស​មា​ពាង់​កើត​នៃ​ដ៝ង់ ខាន់​ពាង់​លាស៖ “ពាង់​លែៈ​កើល​អ៝ន់​មា​ឞូ​អេងៗ តីស​មា​ឆាក់​ពាង់​នើម​មោ​អោស​ទើយ​កើល។ ");
INSERT INTO cmok_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","អ៝ន់​ពាង់​អី​ឞ្រាស​ក្រីស ​ជេង​ឞូនុយ្ស​លែៈ​កោរាញ​ឞ្រាស​ទែ​កើយ្ស​ងាន់ ពាង់​កាដាច់​ផូង​អីឆ្រាអែល ​ជុរ​ឞើស​ឆី​តឹម​រាកាង់​អាបៃ​រី អ៝ន់​ហេន​ឆៃ​នហ៝​មា​ញឆីង​ដ៝ង់!” ឞូនុយ្ស​អី​ឞូ​ងខឹត​កេង​ឞ្រាស​យេឆូ ​នៃ មឺច​រាម៝ត​អោឞាល់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ត៝ត់​នារ​ងក្លាង​ឞោក​ទោ​មា​លាម​ឞ្រី​ទាក​អី​នៃ​ត្រោក​គែស​ង៝​ទាទេ​នហ៝​មា​ត៝ត់​ម៝ង​ពែ​កេង​មាង់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","តា​ម៝ង​ពែ​កេង​មាង់ ឞ្រាស​យេឆូ ​នតែរ​ទុត​ហោ​លាស​តា​នាវ​ងើយ​ហេឞ្រើ ៖ “អេល៝យ អេល៝យ លាមា​ឆាបាច់​ថានី ?” នាវ​អ្យា​រាឞ្លាង​លាស «អើ​កោរាញ​ឞ្រាស​គ៝ប់ អើ​កោរាញ​ឞ្រាស​គ៝ប់ ម៝ស​នាវ​មៃ​នត្លើយ​គ៝ប់?» ");
INSERT INTO cmok_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ឞូ​បាបាៈ​អី​គុ​តា​នៃ​តាង់​នាវ​ពាង់​នតែរ​នើស​វិ​អ្យាត់ ឞូ​លាស៖ “អោ ពាង់​ក្វាល់​អេលីយា ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ឞើស​កាល់​អែ​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ហាន់​ញច្វាត់​ឆ៝ៈ​ឞ៝ក​យុក​តា​ទាក​ឆ្រាត​ពូត​តា​ចោង​ម៝ង់​នទឹ​អ៝ន់​ពាង់​ញេត នហ៝​មា​ងើយ​លាស៖ “ក៝ប់​អ្វាញ់​ប៝ត់ គឹត​អេលីយា ​ហាន់​ញជុរ​ពាង់​ឞើស​ឆី​តឹម​រាកាង់​មោ​លាស​មោ”។ ");
INSERT INTO cmok_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ជេសរី​ឞ្រាស​យេឆូ ​នតែរ​ទុត​ហោ នហ៝​មា​រ៝ស​នហ៝ម់​ក្ល៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","តា​ម៝ង​នៃ​ឞ៝ក​អី​ញចីង​តា​ជ្រោ​ទុត​ក្ល៝ស​អ្វែស​តា​ត្រោម​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​ទោ​មា​ហេក​ច្វីក​ជេង​ឞារ នតើម​ឞើស​លើ​នហ៝​មា​ត៝ត់​អា​ទ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ទូ​ហ្វេ​កោរាញ​តាហែន​រោម ​អី​ទ៝ក់​ឞើស​នាប់​ឞ្រាស​យេឆូ ​ឆៃ​ពាង់​រ៝ស​នហ៝ម់​កើត​នៃ កោរាញ​តាហែន​អី​នៃ​ងើយ​លាស៖ “ឞូ​ក្លោ​អ្យា​អី​ក៝ន​កោរាញ​ឞ្រាស​ងាន់​យា!” ");
INSERT INTO cmok_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","គែស​មពោល​ឞូ​អូរ​បាបាៈ​អ្វាញ់​ឞើស​ងាយ។ តា​មពោល​ឞូ​អូរ​អី​នៃ គែស​មារី ​អី​តាៈ​ឞើស​ប៝ន​មាដាលា  គែស​មារី ​អី​មេៈ​យាកើ ​ជេៈ នទ្រែល​មា​អី​មេៈ​យោឆេ  នទ្រែល​មា​ឆាលោមេ ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","លែៈ​ឞូ​អូរ​អី​នៃ​តឹង​កើល​ឞ្រាស​យេឆូ ​នតើម​ឞើស​ពាង់​គុ​តា​ឞ្រី​កាលីលេ ។ គែស​អ៝ក់​ឞូ​អូរ​អេង​ជឹត ខាន់​ពាង់​លែៈ​រាងោច​តឹង​ពាង់​ត៝ត់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ។ ");
INSERT INTO cmok_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","លែៈ​នាវ​អី​នៃ​ត៝ត់​តា​នារ​នទ្រាប់​អី​នារ​អេ​ល៝រ​មា​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល ។ លែៈ​ត៝ត់​កេង​មាង់​នារ​អី​នៃ​ជេស‌ ");
INSERT INTO cmok_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ជេសរី​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​រាញា​យោឆែប ​អី​តាៈ​ឞើស​ប៝ន​អារីមាថេ  ពាង់​ឞូនុយ្ស​លឺ​ក្វ៝ង់​តា​មពោល​កោរាញ​ជាន​ការ​ផូង​អីឆ្រាអែល ។ ពាង់​ហោម​ក៝ប់​ត៝ត់​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​លែៈ​ឞូនុយ្ស​ដ៝ង់ នទ្រី​នូយ្ស​នហ៝ម់​ពាង់​ឞាញ់​ងាន់​ហាន់​ម៝ប់​ពីលាត ​ទាន់​ឆ៝ៈ​ឆាក់​ឞ្រាស​យេឆូ ​គៃ​មា​ត៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ត៝ត់​ពាង់​ម៝ប់​ពីលាត ពីលាត ​គែស​នាវ​មឹន​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់​តាង់​ងក៝ច​លាស​ឞ្រាស​យេឆូ ​លែៈ​ខឹត​ហើយ្ស​កើត​នៃ។ ពាង់​ក្វាល់​កោរាញ​តាហែន​អី​ងខឹត​ឞ្រាស​យេឆូ ​នៃ​នើស គៃ​មា​គឹត​នហេល​លាស​ឞ្រាស​យេឆូ ​លែៈ​ខឹត​ងាន់​មោ​លាស​មោ។ ");
INSERT INTO cmok_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ជេស​ពាង់​តាង់​លែៈ​នាវ​តាហែន​នៃ​ងក៝ច ពាង់​អ៝ន់​យោឆែប ​ឆ៝ៈ​ឆាក់​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","យោឆែប ​រាវាត់​ឞ៝ក​លាយ្ស​ងលាង ជេសរី​ពាង់​ញជុរ​ឆាក់​ឞ្រាស​យេឆូ ​ឞើស​ឆី​តឹម​រាកាង់ ញជ៝រ​ពូត​មា​ឞ៝ក​អី​នៃ​តេៈ​តា​ត្រោម​មោច​លុ​ទូ​នតុក​អី​ឞូ​ទែ​លោក​តា​លុ​ក្លេរ​មា​ជាន​ត្រោម​មោច។ ជេសរី​ពាង់​រាលាៈ​ទូ​មល៝ម់​លុ​រាទ៝ល់​ត្រោម​មោច​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","មារី ​អី​តាៈ​ឞើស​ប៝ន​មាដាលា  នទ្រែល​មា​មារី ​អី​មេៈ​យោឆេ ​លែៈ​គុ​តា​នៃ​ដ៝ង់ លែៈ​អ្វាញ់​ឆៃ​នតុក​ឞូ​តេៈ​ឆាក់​ឞ្រាស​យេឆូ ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","អា​មាង់​ជេស​លោច​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល ​មពោល​ឞូ​អូរ​មារី ​អី​តាៈ​ឞើស​ប៝ន​មាដាលា មារី ​អី​មេៈ​យាកើ  នទ្រែល​មា​ទូ​ហ្វេ​ឞូ​អូរ​អេង​ជឹត​រាញា​ឆាលោមេ ​លែវ​ឞាល់​រាវាត់​ទាក​ងី​បោ​កាស​គៃ​មា​ញអោត​ត៝ៈ​តា​ឆាក់​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","កាស​អើម​អោយ​តា​នារ​ពើស ខាន់​ពាង់​លែវ​ឞាល់​ហាន់​អា​មោច​នោក​ឞ្រី​លែៈ​អាង​នារ​លែៈ​លោស‌ ");
INSERT INTO cmok_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ងើយ​នទ្រាង់​ខាន់​ពាង់​នើម​លាស៖ “នទ្រី​ឞូ​ម៝ស​ឆើម​រាលាៈ​លុ​អី​រាទ៝ល់​ត្រោម​មោច​អ៝ន់​មា​ឞ៝ន់​ហ្យាស?” ");
INSERT INTO cmok_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ត៝ត់​តា​មោច​នៃ ខាន់​ពាង់​ងើក​អ្វាញ់​ឆៃ​លុ​លែៈ​អើម​រាលាៈ​ជឹត​មែង​ត្រោម​មោច។ លុ​អី​នៃ​ក្វ៝ង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ជេស​ខាន់​ពាង់​លាប់​តា​ត្រោម​មោច​នៃ ឆៃ​ទូ​ហ្វេ​ឞូ​នទាម់​គុ​រាគើប​មពែស​ឞើស​មា ញឆ៝ស​អាវ​ក្វ៝ង់​ងលាង។ ល៝ង់​មពោល​ឞូ​អូរ​អី​នៃ​ក្លាច​ញឆ៝រ់។ ");
INSERT INTO cmok_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ឞូ​នទាម់​អី​នៃ​លាស​មា​ខាន់​ពាង់៖ “លើយ​ទឹង​ក្លាច​អោស! ខាន់​អៃ​ជ៝យ​ឞ្រាស​យេឆូ ​អី​តាៈ​ឞើស​ប៝ន​នាឆារែត ​អី​ឞូ​ងខឹត​តា​ឆី​តឹម​រាកាង់​នើស។ លែៈ​កោរាញ​ឞ្រាស​រាទ៝ក់​ពាង់​អ៝ន់​ទ៝ក់​រេស​តៃ។ ពាង់​មោ​ហោម​អោស​គុ​តា​អ្យា អ្វាញ់​អែស តា​នតុក​អ្យា​ឞូ​ញជ៝រ​ឆាក់​ពាង់​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ហាន់​ខាន់​អៃ​ឆឹត​មឞើស​មពោល​អ៝ស​ម៝ន​ពាង់​រី នហ៝​មា​មឞើស​ពេត្រោស ​ដ៝ង់៖ «ពាង់​ហាន់​អា​ឞ្រី​កាលីលេ ​ល៝រ​ឞើស​នាប់​ខាន់​អៃ​មៃ អា​រី​តៃ​ខាន់​អៃ​មៃ​ឆៃ​ពាង់ តឹម​ទី​កើត​ពាង់​លែៈ​ជេស​នតិញ​នើស»”។ ");
INSERT INTO cmok_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ជេសរី​មពោល​ឞូ​អូរ​នៃ​ទូ​លោស​ឞើស​មោច​ញច្វាត់​រ៝ង់​ឞ្រ៝ង់​នអ៝ប់​មា​ញឆ៝រ់​ក្លាច​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់។ ខាន់​ពាង់​មោ​អោស​មឞើស​នាវ​អី​នៃ​អ៝ន់​មា​ឞូ យ៝រ​មា​ក្លាច​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","តា​អោយ​នារ​ពើស ឞ្រាស​យេឆូ ​ទ៝ក់​រេស​តៃ ពាង់​ញហើ​ល៝រ​ឆាក់​អ៝ន់​មា​មារី ​ឆៃ មារី ​អី​នៃ​តាៈ​ឞើស​ប៝ន​មាដាលា ។ ពាង់​ឞ្រាស​យេឆូ ​លែៈ​មព្រើស​ពើស​ឞ្រាស​អ្យើស​លោស​ឞើស​ឆាក់​ពាង់​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ជេស​រី​មារី ​ហាន់​មឞើស​នាវ​អី​នៃ​អ៝ន់​មា​មពោល​អ៝ស​ម៝ន​ពាង់ ខាន់​ពាង់​ហោម​អែ​រាង៝ត​រាវៃ​ញុម​វើល​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ត៝ត់​តាង់​មារី ​ងក៝ច​លាស​ពាង់​លែៈ​ទ៝ក់​រេស​តៃ តាង់​ងក៝ច​ដ៝ង់​លាស​មារី ​លែៈ​ឆៃ​ពាង់ មោ​អោស​ខាន់​ពាង់​អុច​អ្យាត់។ ");
INSERT INTO cmok_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ជេសរី​ឞ្រាស​យេឆូ ​ញហើ​ឆាក់​អ៝ន់​ឞារ​ហៃ​អ៝ស​ម៝ន​ឆៃ ជេស​ខាន់​ពាង់​លោស​ឞើស​ប៝ន​យេរូឆាលឹម ​ហាន់​រ៝ៈ​ត្រ៝ង។ នោក​នៃ​មុស​មាត់​ឞ្រាស​យេឆូ ​អេង​ដាស​អា​ល៝រ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ជេសរី​ឞារ​ហៃ​ខាន់​ពាង់​ហាន់​ព្លឹ​ជឹត​កើយ​មឞើស​នាវ​អី​នៃ​មា​មពោល​អ៝ស​ម៝ន​អា​អេង​ដ៝ង់ តីស​មា​ខាន់​ពាង់​មោ​អុច​អ្យាត់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","កេង​មា​ទុត​នោក​ខាន់​ពាង់​ហោម​គុ​ឆោង​ឆា ឞ្រាស​យេឆូ ​ញហើ​ឆាក់​អ៝ន់​មា ១១ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​ឆៃ ជេសរី​ឞ្រាស​យេឆូ ​នទុយ្ស​ខាន់​ពាង់ អាច​មា​ខាន់​ពាង់​ទាង់​ក៝​មោ​អុច​អ្យាត់​លែៈ​នាវ​អី​ឞូ​ងក៝ច​លាស​ឆៃ​ពាង់​លែៈ​ជេស​ទ៝ក់​រេស​តៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ពាង់​លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ហាន់​អ៝ន់​លាម​នែស​នតូ​អ្យា ជេសរី​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​អ៝ន់​មា​ទឹង​លែៈ​ឞូនុយ្ស​ទោ។ ");
INSERT INTO cmok_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ឞូ​ម៝ស​អ្យាត់​នាវ​ងក៝ច​អី​នៃ​ជេសរី​ទើន​នាវ​បាប់តែម​យុក​មា​ទាក ពាង់​អី​នៃ​កោរាញ​ឞ្រាស​ទែ​រាក្លាយ្ស។ ឞូ​ម៝ស​អី​មោ​អ្យាត់​អោស​ពាង់​អី​នៃ​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​មា​ពាង់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ឞូ​ម៝ស​អី​អ្យាត់​នាវ​អី​នៃ ខាន់​ពាង់​ជាន​នាវ​មឞេន​កើត​នអា៖ មព្រើស​ឞ្រាស​អ្យើស​យ៝រ​មា​នាវ​ទើយ​គ៝ប់ ឞ្លាវ​នាវ​ងើយ​អី​ខាន់​ពាង់​មោ​អោស​ព្រ៝ត​ងើយ។ ");
INSERT INTO cmok_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","លាស​ខាន់​ពាង់​ញុប​ឞេស​គែស​កាច់ មោ​លាស​ញេត​នទើ​ខេស ខាន់​ពាង់​មោ​គែស​នាវ​ត៝ត់​ដ៝ង់។ លាស​ខាន់​ពាង់​តេៈ​តី​តា​ឞូនុយ្ស​ជី នាវ​ជី​ពាង់​ឞាស​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ជេស​កោរាញ​យេឆូ ​ងើយ​លែៈ​នាវ​អី​នៃ ជេសរី​កោរាញ​ឞ្រាស​ឆ៝ៈ​នហាវ​ពាង់​ឆឹត​តា​ប៝ន​អ្វែស​កាលើ​ត្រោក អ៝ន់​គុ​មពែស​ឞើស​មា​តី​កោរាញ​ឞ្រាស​នើម។ ");
INSERT INTO cmok_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ជេសរី​ខាន់​ពាង់​ហាន់​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​អាប់​នតុក នហ៝​មា​កោរាញ​ឞ្រាស​កើល​ជាន​ការ​នទ្រែល​ខាន់​ពាង់ អ៝ន់​ខាន់​ពាង់​ទើយ​ជាន​នាវ​មឞេន​អេងៗ គៃ​មា​អ៝ន់​ឞូ​ឆៃ​នាវ​អី​នៃ​លែៈ​ទី​ងាន់៕៚");
INSERT INTO cmok_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","ទាន់​កោស​មឞាស​លាស​អ្វែស​មា​កោរាញ​ថេវផីល  អ៝ន់​គឹត! គែស​អ៝ក់​ឞូនុយ្ស​អី​ឆៃ​មា​មាត់​អ៝ក់​នតីល​នាវ​ឞ្រាស​យេឆូ ​ជាន នតើម​ពាង់​នតុម​នតី​មា​ឞូនុយ្ស។ ជេសរី​ឞូនុយ្ស​អី​នៃ​នហ៝​មា​ជាន​ការ​មឞើស​ងក៝ច​នាវ​កោរាញ​ឞ្រាស។ គែស​អ៝ក់​ឞូនុយ្ស​តាង់​នាវ​ខាន់​ពាង់​មឞើស​ងក៝ច​នៃ ជេសរី​ញចីស​នាវ​អី​នៃ​អ៝ន់​មា​ហេន​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ល៝ង់​គ៝ប់​មេត​អ្វាញ់​ទឹង​លែៈ​នាវ​អី​នៃ​ទុត​នហេល​នានេៈ​ងាន់។ គ៝ប់​គឹត​នាវ​អ្យា​ទី​ងាន់​ញចីស​អ៝ន់​នហេល​ងាន់​គៃ​មា​ញជ្វាល់​អ៝ន់​មៃ​ដ៝ង់‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","អុច​អ៝ន់​មៃ​គឹត​នាល់​ទឹង​លែៈ​នាវ​អី​មៃ​លែៈ​តាង់​ឞូ​នតី​លាស​មា​មៃ​នើស នាវ​អី​នៃ​ជេង​ទី​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","នោក​ហេរោត ​ជេង​កាដាច់​ម៝ត់​អ្វាញ់​តា​ឞ្រី​យូដា  នោក​នៃ​គែស​ដ៝ង់​ទូ​ហ្វេ​ឞូនុយ្ស​ជាន​ឞ្រាស​រាញា​ពាង់​ឆាការី  អូរ​ពាង់​រាញា​អេលីឆាបិត  លែៈ​ឞារ​ហៃ​ខាន់​ពាង់​រាន៝យ​ទែស​អារោន ​អី​ឞូនុយ្ស​ជេង​កោរាញ​ជាន​ឞ្រាស​ល៝រ​ឞូ​តា​ផូង​អីឆ្រាអែល ។ នោក​នៃ​មពោល​ជាន​ឞ្រាស​គែស ២៤ មពោល​តឹម​ព្លែស​ជាន​ការ​តា​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ឆាការី ​គុ​តា​មពោល​រាញា​អាបីយា ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","លែៈ​ឞារ​ហៃ​អូរ​ឆាយ​នៃ​កោរាញ​ឞ្រាស​កើប​ខាន់​ពាង់​ជេង​ឞូនុយ្ស​ឆ៝ង់​ឆ្រាង់​ងាន់ ញអោត​ន៝ប់​ទឹង​លែៈ​នាវ​កោរាញ​ឞ្រាស​ដាៈ ជាន​ទី​ទាទេ​មោ​អោស​ទូ​នតីល​តីស។ ");
INSERT INTO cmok_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","តីស​មា​ខាន់​ពាង់​មោ​គែស​ក៝ន យ៝រ​លាស​អេលីឆាបិត ​អី​ឞូ​អូរ​មោ​ឞាៈ​ក៝ន ឆាក់​ជាន់​ខាន់​ពាង់​លែៈ​រាញ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ត៝ត់​ទី​នារ​ព្លែស​មពោល​ជាន​ឞ្រាស​មពោល​អាបីយា ​លាប់​ជាន​ការ​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស នារ​នៃ​ឆាការី ​ឞូនុយ្ស​ជាន​ឞ្រាស​គែស​លាប់​ជាន​ការ​តា​ញីស​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","តឹង​នាវ​វៃ​ជាន​មពោល​ជាន​ឞ្រាស ខាន់​ពាង់​កើយ្ស​ទូ​ហ្វេ​ឞូនុយ្ស​មា​នទើ​ញច្រ៝ស ទី​តា​ព្លាង់​ឆាការី  ជេសរី​ពាង់​លាប់​ឆូ​នទើ​បោ​កាស​តា​ត្រោម​ញីស​ជាន​ឞ្រាស​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ជេសរី​ឆាការី ​លាប់​តា​ត្រោម​នៃ ឆូ​នទើ​បោ​កាស ឞើស​ទីស​អ្យា​គែស​អ៝ក់​ឞូនុយ្ស​គុ​មឞើស​ឆើម។ ");
INSERT INTO cmok_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ទូ​នហ៝ម់​តា​នៃ​ពាង់​ឆៃ​ទូ​ហ្វេ​តោង​ពារ់​តាៈ​ឞើស​កោរាញ​ឞ្រាស ទ៝ក់​ឞើស​មា​ញឆឺង​មា​គុច​នទើ​បោ​កាស​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ត៝ត់​មា​ឆៃ​កើត​នៃ ពាង់​នទ្រ៝ត់​ព្រោស ក្លាច​ទុត​ញឆ៝រ់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ជេសរី​តោង​ពារ់​លាស​មា​ពាង់៖ “ហើយ​ឆាការី  លើយ​ក្លាច​អោស! កោរាញ​ឞ្រាស​អ្យាត់​កើត​នាវ​មៃ​លែៈ​ជេស​ទាន់ នារ​ជឹត​នាប់​តៃ​អូរ​មៃ​គែស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ អ៝ន់​មៃ​តេៈ​រាញា​ក្វាល់​ពាង់ «យោហាន »។ ");
INSERT INTO cmok_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ក៝ន​អី​នៃ​មៃ​រាម់​រាហើន​ហោ​ងាន់ ជេសរី​គែស​អ៝ក់​ឞូនុយ្ស​ដ៝ង់​រាម់​មអាក​ពាង់​ទែស‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","យ៝រ​លាស​កោរាញ​ឞ្រាស​កើប​ក៝ន​អី​នៃ​ខ្លៃ​ហោ​ងាន់​ងេន។ លើយ​អោស​អ៝ន់​ពាង់​ញេត​នទ្រាញ់ មោ​លាស​ទូ​នតីល​នទើ​ញុល ទូ​តឹ​មោ​អ៝ន់​ដ៝ង់។ ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​គុ​តា​ពាង់​នតើម​ឞើស​នទុល​មែ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ជេសរី​ពាង់​លែវ​ប៝ន​លាន​អីឆ្រាអែល ​អ៝ក់​ឞូនុយ្ស​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស​ព្លឹ​ឆឹត​មា​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ពាង់​វាច់​ល៝រ​ឞើស​នាប់​កោរាញ​ឞ្រាស នហ៝​មា​គែស​ឞ្រាស​ហ្វេង​អ្វែស​គុ​តា​ពាង់​តឹម​ឞាន​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស រាញា​អេលីយា  គែស​នាវ​ទាង់​តឹម​ឞាន​មា​អេលីយា ​នៃ​ដ៝ង់។ ក៝ន​មៃ​អី​នៃ​រាព្លឹ​នូយ្ស​នហ៝ម់​ឞឹ​អ៝ន់​ព្លឹ​រ៝ង់​មា​ក៝ន​ពាង់​នើម យ៝រ​មា​ឞ្រាស​ហ្វេង​អ្វែស​គុ​តា​ពាង់។ គែស​អ៝ក់​ឞូនុយ្ស​មោ​អ្យាត់​នាវ​កោរាញ​ឞ្រាស ក៝ន​មៃ​អី​នៃ​រាគ៝ល់​នូយ្ស​នហ៝ម់​អ្យើស​ខាន់​ពាង់​ព្លឹ​ឆឹត​មា​កោរាញ​ឞ្រាស​ជេង​ឞូនុយ្ស​ឆ៝ង់​ឞូនុយ្ស​អ្វែស កើត​នទ្រី​ពាង់​នទ្រាប់​ឞូនុយ្ស​ទូ​ផូង​អ៝ន់​មា​វើត​ទើន​កោរាញ​ឞ្រាស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ឆាការី ​អោប​តោង​ពារ់​អី​នៃ​លាស៖ “មើម​ជាន​ហាៈ ទឹង​គឹត​នាវ​នៃ​ហ៝ច​ងាន់? យ៝រ​លាស​ឆាក់​គ៝ប់​អ្យា​លែៈ​រាញ​ជេស នាម់​អូរ​គ៝ប់​លែៈ​អ៝ក់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","តោង​ពារ់​ព្លឹ​អើស​មា​ពាង់៖ “គ៝ប់​អ្យា​រាញា​កាព្រីយែល ​អី​កោរាញ​តោង​ពារ់​កើល​ជាន​ការ​មា​កោរាញ​ឞ្រាស ពាង់​ដាៈ​គ៝ប់​លែវ​នាវ​អ្វែស​អ្យា​មឞើស​អ៝ន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","នាវ​អ្យា​គែស​ងាន់​ត៝ត់​ទី​នារ​រី​តៃ តីស​មា​មៃ​មោ​អ្យាត់​អោស​នាវ​គ៝ប់​មឞើស​ងក៝ច​នើស។ អ្វាញ់​មៃ​តៃ​ជេង​ឞូនុយ្ស​មល៝​ងើយ​មោ​ឞ្លាវ​អោស នហ៝​មា​ត៝ត់​អូរ​មៃ​គុ​អ៝ស”។ ");
INSERT INTO cmok_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ឞូនុយ្ស​គុ​ក៝ប់​ឆាការី ​ឞើស​ទីស​រី មោ​វ៝ត់​អោស​ម៝ស​នាវ​គុ​ជ៝ៈ​ពាង់​តា​ត្រោម​ញីស​ជាន​ឞ្រាស​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ជេសរី​ឆាការី ​លោស​អា​ទីស​អ្យា ពាង់​ងើយ​ដាស​ឞូ​មោ​ឞ្លាវ​អោស។ ពាង់​ញច៝ង់​មា​តី​ទើម​គៃ​អ៝ន់​ឞូ​គឹត​អី​នាវ​ពាង់​ឆៃ​រី​នើស។ ត៝ត់​ឆៃ​ពាង់​ញច៝ង់​នទ្រី ខាន់​ពាង់​គឹត​វ៝ត់​នទើស​នើស​តា​ត្រោម​ញីស​ជាន​ឞ្រាស​នៃ ឆាការី ​គែស​ឆៃ​នទើ​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ពាង់​អេ​ហ៝ៈ​លែៈ​នារ​ឆឹត​អោស ហោម​គុ​ជាន​ការ​តា​ញីស​ជាន​ឞ្រាស​អី​នៃ​ជឹត ត៝ត់​ទី​លែៈ​នារ​ឞាស​ជាន​ការ ជេសរី​ពាង់​ព្លឹ​ឆឹត​អា​ប៝ន​ពាង់​នើម​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","កាស​អា​កើយ​រី​ឆៃ​អូរ​ពាង់​នត្រែវ ជេសរី​អី​អូរ​ពាង់​គុ​ងាន់​តា​ជៃ​ពាង់​នើម​រី​ជ៝ៈ​ព្រាម់​ខៃ​លិច​លោស​ទីស​អីស​នារ​អោស។ ជេសរី​ពាង់​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“នាវ​នត្រែវ​គ៝ប់​អ្យា​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទើម​អ៝ន់​មា​គ៝ប់ ពាង់​ជាន​គ៝ប់ អាបៃ​អ្យា​មោ​ហោម​អោស​ដីត​ព្រេង​ឞូ​ជឹត!” ");
INSERT INTO cmok_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ត៝ត់​អេលីឆាបិត ​នត្រែវ​ក្លាប់​គែស​ព្រាវ​ខៃ កោរាញ​ឞ្រាស​ដាៈ​តោង​ពារ់​រាញា​កាព្រីយែល ​ហាន់​តា​ប៝ន​នាឆារែត  ឞ្រី​កាលីលេ ‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","គៃ​មា​ម៝ប់​ទូ​ហ្វេ​ឞូ​ទ្រោស រាញា​ពាង់​មារី ។ ឞូ​ទ្រោស​អី​នៃ​ពាង់​លែៈ​ជាន​នទ្រោយ​ដាស​ទូ​ហ្វេ​ឞូ​នទាម់ រាញា​ពាង់​យោឆែប ​អី​ចែ​ពាង់​កាល់​អែ​នើស​កាដាច់​ដាវីត ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ជេសរី​តោង​ពារ់​អី​នៃ​លាប់​តា​ត្រោម​ជៃ​មារី  ពាង់​លាស៖ “ហើយ​យោស​មារី  អ្វែស​លាង់​អៃ​ឞើស! កោរាញ​ឞ្រាស​លែៈ​កើយ្ស​ទូ​ហ្វេ​អៃ​ទើម អ៝ន់​នាវ​គែស​ជេង​មា​អៃ​លើ​មា​ក្វ៝ង់​លើ​មា​ព្រេស​ងាន់ ពាង់​គុ​នទ្រែល​អៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ត៝ត់​មារី ​តាង់​កើត​នៃ​ពាង់​មោ​អោស​គឹត​វ៝ត់ គែស​នាវ​រាវៃ​ងាន់ ជេសរី​ងក្ល៝ន់​អេង​តា​ឆាក់​ពាង់​នើម៖ “ម៝ស​បាៈ​គែស​នាវ​ខ្លៃ​ងើយ​ព្រែ​អី​នៃ​នើស?” ");
INSERT INTO cmok_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ជេសរី​តោង​ពារ់​លាស​មា​ពាង់​ជឹត៖ “អើយ​មារី  លើយ​អៃ​ក្លាច​អោស កោរាញ​ឞ្រាស​កើយ្ស​អៃ គៃ​អ៝ន់​នាវ​គែស​ជេង​ក្វ៝ង់​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","អៃ​តៃ​នត្រែវ ជេសរី​គែស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ អ៝ន់​អៃ​តេៈ​រាញា​ពាង់​ក្វាល់ «យេឆូ »។ ");
INSERT INTO cmok_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ក៝ន​អ្យា​គែស​នាវ​ខ្លៃ​នាវ​ទើយ​ហោ​ងាន់​ងេន ឞូ​ក្វាល់​ពាង់​លាស៖ «ក៝ន​កោរាញ​ឞ្រាស​អី​ទុត​ព្រេស» ជេសរី​កោរាញ​ឞ្រាស​អ៝ន់​ក៝ន​អី​នៃ​ជេង​កាដាច់​មា​ផូង​អីឆ្រាអែល ​តឹម​ឞាន​មា​កាដាច់​ដាវីត ​អី​ចែ​ពាង់​កាល់​អែ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","យើន​មា​ពាង់​តៃ​ជេង​កោរាញ​ម៝ត់​អ្វាញ់​ប៝ន​លាន​អីឆ្រាអែល ​អី​ក៝ន​ឆៅ​រាន៝យ​ទែស​យាកោប ​នហ៝​រ៝ ពាង់​ម៝ត់​អ្វាញ់​មោ​អោស​ឞ្លាវ​លោច​ឞ្លាវ​ទុត”។ ");
INSERT INTO cmok_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ជេសរី​មារី ​អោប​តោង​ពារ់​អី​នៃ​លាស៖ “មើម​ជាន​មេស​ទឹង​គែស​នាវ​អ្យា​ត៝ត់​ងាន់​រ៝ យ៝រ​លាស​គ៝ប់​អេ​ហ៝ៈ​គែស​ឆាយ?” ");
INSERT INTO cmok_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","តោង​ពារ់​អើស៖ “ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​វាច់​គុ​តា​អៃ នាវ​ទើយ​កោរាញ​ឞ្រាស​អី​ទុត​ព្រេស​ងកុម​អ៝ន់​នហ៝ម់​មា​អៃ អ៝ន់​អៃ​នត្រែវ។ កើត​នទ្រី​ទឹង​ក៝ន​អី​នៃ​ក្ល៝ស​អ្វែស ឞូ​ក្វាល់​ពាង់ «ក៝ន​កោរាញ​ឞ្រាស»។ ");
INSERT INTO cmok_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ល៝ង់​អេលីឆាបិត ​អី​នទុល​ទែស​អៃ​នើម ឞ៝ល​លាស​ពាង់​លែៈ​រាញ នទ្រែល​មា​ឞូ​លាស​ពាង់​ឞូ​អូរ​មោ​ឞាៈ​ក៝ន​កាដោយ​លែៈ យើន​មា​អាបៃ​អ្យា​ពាង់​លែៈ​នត្រែវ​ក៝ន​ឞូ​ក្លោ​ក្លាប់​លាស​គែស​ព្រាវ​ខៃ​ជេស‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","យ៝រ​លាស​មោ​គែស​អោស​ទូ​នតីល​នទើ​កោរាញ​ឞ្រាស​មោ​ឞ្លាវ​ជាន”។ ");
INSERT INTO cmok_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","មារី ​អើស៖ “គ៝ប់​អ្យា​អុច​ជាន​តឹង​ទឹង​លែៈ​នាវ​កោរាញ​ឞ្រាស អ៝ន់​ត៝ត់​ងាន់​កើត​នាវ​អី​មៃ​លាស​រី!” ជេសរី​តោង​ពារ់​ទូ​លោស​ឞើស​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ជេសរី​មារី  ទ៝ក់​នទាល​ឞើស​នតុក​នៃ ហាន់​ឞ្រុល​រ៝​ជឹត​ប៝ន​ឆាការី ​គុ​រី​តា​ឞ្រី​យោក នតុក​ឞ្រី​យូដា ​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ត៝ត់​តា​ជៃ​ឆាការី ​រី​ពាង់​អោប​នាវ​អ្វែស​លាង់​មា​អេលីឆាបិត ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ត៝ត់​តាង់​មារី ​អោប​នៃ ទោ​មា​មព៝ត់​រ៝​អី​ក៝ន​តា​ត្រោម​នទុល​អេលីឆាបិត ​រី។ ជេសរី​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​គុ​ងាន់​តា​អេលីឆាបិត ​នៃ​រ៝‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","អ៝ន់​នាវ​ពាង់​លាស ជេសរី​ពាង់​ងើយ​នតែសៗ​ងាន់៖ “កោរាញ​ឞ្រាស​លែៈ​អ៝ន់​នាវ​គែស​ជេង​ទុត​អ្វែស​មា​អៃ​អ៝ក់​រាលាវ​មា​ដាស​ទឹង​លែៈ​ឞូ​អូរ​អេង​ជឹត នហ៝​ពាង់​អ៝ន់​នាវ​គែស​ជេង​មា​ក៝ន​តា​ត្រោម​នទុល​អៃ​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ម៝ស​គែស​នាវ​ខ្លៃ​តា​គ៝ប់​អ្យា​ហៃ ទឹង​គែស​មា​ឞូ​អូរ​អី​មែ​កោរាញ​គ៝ប់​នើម​ហាន់​ខ៝ល់​គ៝ប់! ");
INSERT INTO cmok_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","គ៝ប់​គឹត​នាល់​រី​នើស យ៝រ​លាស​ក៝ន​តា​ត្រោម​នទុល​គ៝ប់​មព៝ត់​រាម់​មអាក​ងាន់​រ៝ ត៝ត់​គ៝ប់​តាង់​នាវ​អៃ​អោប​អ្វែស​លាង់​នើស។ ");
INSERT INTO cmok_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","អៃ​លាប​ងាន់​យ៝រ​មា​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​លាស​អី​នៃ​ត៝ត់​មា​អៃ​ងាន់​រ៝ អ៝ស​អេ”។ ");
INSERT INTO cmok_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ជេសរី​មារី ​មព្រើ​លាស៖ “នូយ្ស​នហ៝ម់​គ៝ប់​រានេ​មា​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","គ៝ប់​រាម់​មអាក​ហោ​ងាន់​មា​កោរាញ​ឞ្រាស​អី​នើម​រាក្លាយ្ស​គ៝ប់‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","យ៝រ​លាស​កោរាញ​ឞ្រាស​ហោម​កើយ្ស​គ៝ប់​អី​ឞូនុយ្ស​ប៝ន​លាន​ទើម​ក៝ប់​អ្យាត់​នាវ​កោរាញ​ឞ្រាស។ នតើម​ឞើស​អ្យា​ជឹត​នាប់​តៃ​អាប់​រានោក​ឞូនុយ្ស ឞូ​ក្វាល់​គ៝ប់​អី​ឞូ​អូរ​លាប​ងាន់​ងេន‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","យ៝រ​លាស​កោរាញ​ឞ្រាស​អី​គែស​នាវ​ទើយ​អ៝ន់​នទើ​នាវ​ខ្លៃ​ងាន់​មា​គ៝ប់។ កោរាញ​ឞ្រាស​ក្ល៝ស​អ្វែស​ងាន់​ងេន‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ពាង់​យោៈ​នអាច​មា​ឞូ​ម៝ស​អី​ក្លាច​អ្យាត់​នាវ​កោរាញ​ឞ្រាស នហ៝​រ៝​ត៝ត់​អាប់​រានោក​ឞូនុយ្ស‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","នទ្រែល​មា​ញហើ​នាវ​ទាង់​ពាង់‌ នត្រុត​លើយ​ឞូនុយ្ស​អី​កើប​អេង​ឆាក់​ពាង់​នើម​ក្វ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ពាង់​នអុស​លើយ​កាដាច់​គែស​នាវ​ទើយ​ងាន់​អ៝ន់​ជេង​ឞូនុយ្ស​ប៝ន​លាន​ទើម‌ ជេសរី​ពាង់​នហាវ​ឞូនុយ្ស​អី​ប៝ន​លាន។ ");
INSERT INTO cmok_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ពាង់​អ៝ន់​គែស​រាមែស​លែរ​មា​ឞូនុយ្ស​ជី​ង៝ត​ជី​ហីរ‌ តីស​មា​ឞូនុយ្ស​នទ្រ៝ង់​ក្វ៝ង់​អ៝ន់​ឆឹត​ទើម តឹង​កោរាញ​ឞ្រាស​នើម​អុច។ ");
INSERT INTO cmok_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ពាង់​កើល​ប៝ន​លាន​អីឆ្រាអែល ​អី​ផូង​ជាន​ការ​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​នើម‌ យ៝រ​មា​ហោម​កាស​គឹត​នាវ​យោៈ​នអាច​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ពាង់​ជាន​កើត​នអា​តឹង​នាវ​ពាង់​ត៝ន​មា​ចែ​អាឞ្រាហាម់ ​កាល់​អែ​នើស នហ៝​មា​ត៝ត់​ក៝ន​ត៝ត់​ឆៅ​អាឞ្រាហាម់ ​នហ៝​រ៝”។ នទ្រី​នាវ​មព្រើ​មារី ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ពាង់​គុ​នទ្រែល​អេលីឆាបិត ​ក្លាប់​លាស​គែស​ពែ​ខៃ រី​មើ​ព្លឹ​ឆឹត​អា​ជៃ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ត៝ត់​អេលីឆាបិត ​អាប់​ខៃ​ជេស ពាង់​គុ​អ៝ស​ក៝ន​ឞូ​ក្លោ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ឞូ​ងក៝ច​ដើន​នាវ​អូ​លែៈ​រាញ​អី​នៃ​ហោម​គែស​ក៝ន​អ៝ន់​លែៈ​មពោល​ច្យៅ​មែង នទ្រែល​មា​ឞាល់​មពោល​ពាង់​នើស​គឹត។ ជេស​តាង់​លឺ​កោរាញ​ឞ្រាស​យោៈ​នអាច​មា​ពាង់​ហោ​ងាន់​ងេន​កើត​នអា ខាន់​ពាង់​រាម់​មអាក​នទ្រែល​ពាង់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ត៝ត់​អ៝ស​ឞេ​អី​នៃ​លែៈ​គែស​ផាម​នារ លែៈ​ឞាល់​មពោល​ឞារ​ហៃ​អូរ​ឆាយ​ខាន់​ពាង់ នទ្រែល​មា​ឞូនុយ្ស​ច្យៅ​មែង​ហាន់​រាន​តា​ខាន់​ពាង់​ដ៝ង់ តឹង​នាវ​វៃ​ផូង​អីឆ្រាអែល  អ៝ន់​ឞូ​ក៝ស​នតោ​មា​ក៝ន​ឞេ​អី​នៃ ងក្រែ​មា​អុច​តេៈ​រាញា​ពាង់ ក្វាល់ «ឆាការី » កើត​រាញា​អី​ឞឹ​ពាង់​នើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","តីស​មា​អី​មេៈ​រី​លាស៖ “មោ​អោស អុច​តេៈ​រាញា​ពាង់ ក្វាល់ «យោហាន »”។ ");
INSERT INTO cmok_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ឞូ​ព្លឹ​អើស​មា​ពាង់៖ “តឹង​មា​នាវ​វៃ​ឞ៝ន់​មោ​ទី​អោស យ៝រ​លាស​តា​ឞាល់​មពោល​ខាន់​អៃ​មៃ​មោ​គែស​ទូ​ហ្វេ​រាញា​កើត​នទ្រី”។ ");
INSERT INTO cmok_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ជេសរី​ឞូ​អោប​ឆាការី ​ញច៝ក់​មា​តី ម៝ស​អុច​តេៈ​រាញា​អ៝ន់​មា​ក៝ន​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ឆាការី ​ញច៝ក់​ដាៈ​ខាន់​ពាង់​ឆ៝ៈ​រាលាត​កាដារ ជេសរី​ញចីស​តា​រី​លាស៖ “ក៝ន​អ្យា​តេៈ​រាញា​ពាង់ ក្វាល់​«យោហាន »”។ លែៈ​ឞូ​តា​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ទូ​នហ៝ម់​តា​នៃ​ឆាការី ​ឞ្លាវ​ងើយ​កើត​អើម​រ៝ ជេសរី​ពាង់​នតែស​ឞ៝រ់​ប្ហ៝ង់​រានេ​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ឞូនុយ្ស​ច្យៅ​មែង​ក្លាច​ទាទេ​ឆៃ​នាវ​ទាង់​កោរាញ​ឞ្រាស។ ឞូ​លឺ​នាវ​អ្យា​លាម​នតុក​ប៝ន​រ៝ៈ​យោក​ឞ្រី​យូដា ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ឞូ​ម៝ស​អី​តាង់​លឺ​នាវ​អ្យា​ពាង់​ងក្ល៝ន់​អេង​តា​នូយ្ស​នហ៝ម់​ហោ​ងាន់ ជេសរី​អោប​អេង​ឆាក់​ពាង់​នើម​លាស៖ “ត៝ត់​ក៝ន​អី​នៃ​លែៈ​ក្វ៝ង់ មើម​ពាង់​ជេង?” ខាន់​ពាង់​ងើយ​កើត​នទ្រី​យ៝រ​លាស​ឞូ​ឆៃ​នាវ​ទើយ​កោរាញ​ឞ្រាស​គុ​តា​ក៝ន​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ជេសរី​ឆាការី ​អី​ឞឹ​អ៝ស​ឞេ​រី ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​គុ​តា​ពាង់​ងាន់ ដាៈ​ពាង់​ងើយ យ៝រ​រី​ពាង់​ងើយ​តាៈ​ឞើស​កោរាញ​ឞ្រាស ពាង់​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“រានេ​មា​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ផូង​អីឆ្រាអែល ​យើក​មឞាស‌ យ៝រ​លាស​ពាង់​វាច់​អុច​រាក្លាយ្ស​ផូង​ប៝ន​លាន​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","កោរាញ​ឞ្រាស​អ៝ន់​ទូ​ហ្វេ​ឞូនុយ្ស​គៃ​មា​រាក្លាយ្ស​ឞ៝ន់ ឞូនុយ្ស​អី​នៃ​គែស​នាវ​ទើយ​ងាន់‌ ពាង់​រាន៝យ​ទែស​កាដាច់​ដាវីត ​អី​ឞូនុយ្ស​ជាន​ការ​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស ពាង់​អី​នៃ​អី​ឞូ​ក្វាល់​ឞ្រាស​ក្រីស ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","កោរាញ​ឞ្រាស​លែៈ​មឞើស​ជេស​នាវ​អ្យា​អ៝ន់​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ពាង់​ងើយ​កាល់​អែ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","នោក​នៃ​នើស​កោរាញ​ឞ្រាស​លាស ពាង់​មរា​រាក្លាយ្ស​ឞ៝ន់​ឞើស​តី​ផូង​រាលាង់ នទ្រែល​មា​អ៝ន់​ឞ៝ន់​លោស​ឞើស​មពោល​រាងឹ​មពោល​ឞ្យាញ់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ពាង់​លែៈ​ត៝ន​នាវ​យោៈ​នអាច​មា​អូ​ចែ​ឞ៝ន់​កាល់​អែ​នើស។ នាវ​តឹម​រាង្លាប់​ក្ល៝ស​អ្វែស​កោរាញ​ឞ្រាស​ពាង់​មោ​ច្វេល​អោស។ ");
INSERT INTO cmok_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ពាង់​លែៈ​ត៝ន​ងាន់​មា​អាឞ្រាហាម់  ចែ​ឞ៝ន់​កាល់​អែ​នើស‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ពាង់​តៃ​រាក្លាយ្ស​ឞ៝ន់​ឞើស​តី​ផូង​រាលាង់‌ គៃ​មា​ឞ៝ន់​មោ​ហោម​ក្លាច​ជាន​ការ​អ្យាត់​នាវ​កោរាញ​ឞ្រាស‌ ");
INSERT INTO cmok_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","នទ្រែល​មា​អ៝ន់​ឞ៝ន់​ជាន​ការ​នៃ​ឆ៝ង់​ឆ្រាង់ តឹម​ទី​ដាស​នាវ​កោរាញ​ឞ្រាស​អុច​នហ៝​រ៝​អាប់​ញជារ់​នាវ​រេស។ ");
INSERT INTO cmok_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ល៝ង់​ក៝ន​គ៝ប់​អ្យា ឞូ​តៃ​លាស​ពាង់​ជេង​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ទុត​ព្រេស‌ យ៝រ​លាស​មៃ​ហាន់​ល៝រ​ឞើស​នាប់​ឞ្រាស​ក្រីស  គៃ​មា​នទ្រាប់​នូយ្ស​នហ៝ម់​ឞូនុយ្ស​អ៝ន់​មា​ពាង់​តឹម​ឞាន​មា​ឞូ​ក្វាយ្ស​ត្រ៝ង​អ៝ន់​មា​កាដាច់​ហាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","មៃ​អ៝ន់​ប៝ន​លាន​អីឆ្រាអែល ​គឹត​នាល់​លាស​មើម​កោរាញ​ឞ្រាស​រាក្លាយ្ស​ខាន់​ពាង់​លោស​ឞើស​នាវ​តេៈ​ទោយ្ស‌ មើម​កោរាញ​ឞ្រាស​យោៈ​មោ​ហោម​អោស​កើប​មោ​ហោម​អោស​ក្លាប់​នទាង់​នាវ​តីស​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ពាង់​យោៈ​នអាច​ឞ៝ន់​ហោ​ងាន់‌ នទ្រី​ពាង់​អ៝ន់​ឞ្រាស​ក្រីស ​តាៈ​ឞើស​កាលើ​ត្រោក​នតុក​កោរាញ​ឞ្រាស​រី​ជុរ​វាច់​តា​ឞ៝ន់ តឹម​ឞាន​មា​ប្រីង​លោស​នារ​អា​អោយ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ឞូនុយ្ស​អី​មោ​គឹត​នាល់​កោរាញ​ឞ្រាស ជេង​តឹម​ឞាន​មា​ឞូនុយ្ស​អី​គុ​តា​នតុក​ង៝ ឞូនុយ្ស​អី​ក្លាច​ខឹត​ដ៝ង់ យើន​មា​ឞ្រាស​ក្រីស ​វាច់​តា​អ្យា​ជេង​នាវ​អាង​មា​ឞូនុយ្ស​អី​នៃ‌ ពាង់​លែវ​ឞ៝ន់​រ៝ៈ​ត្រ៝ង​ដាប់​មពាន់”។ នទ្រី​នាវ​ឆាការី ​ងើយ។ ");
INSERT INTO cmok_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ល៝ង់​យោហាន ​រី​ឆាក់​ជាន់​ពាង់​លើ​មា​ហាវ​នទាម់ នាវ​មឹន​គឹត​ឞ្លាវ​ពាង់​លើ​មា​ហោ​ដ៝ង់។ ជេសរី​ពាង់​គុ​រេស​តា​នតុក​ឞ្រី​រាទាស​ងាយ​ឞើស​ប៝ន​អេងៗ នហ៝​មា​ត៝ត់​នារ​ពាង់​ញហើ​ឆាក់ ជេសរី​នតើម​នតុម​នតី​ប៝ន​លាន​អីឆ្រាអែល ​នៃ​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","នោក​នៃ​តា​ប៝ន​ក្វ៝ង់​រោម  គែស​កោរាញ​កាដាច់​ឞូ​ក្វាល់​ឆេឆារ  រាញា​ពាង់​អៅកុស  ពាង់​លាប់​ម៝ត់​អ្វាញ់​កាដាច់​តា​ឞ្រី​អេងៗ។ គែស​ទូ​នារ​រី​លោស​នាវ​តាៈ​ឞើស​កោរាញ​កាដាច់​អី​នៃ​ដាៈ​ប៝ន​លាន​ទឹង​លែៈ​ឞ្រី​អី​ពាង់​ម៝ត់ ញចីស​ឆាក់​កើប​ឞូនុយ្ស​តឹង​ឞ្រី​តឹង​ប៝ន​អូ​ចែ​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","នាវ​ញចីស​ឆាក់​ប៝ន​លាន​អី​នៃ​ឞូ​ជាន​ឞោក​ទាក​ឞូ ទោល​កីរេនីស ​ជាន​កោរាញ​ក្វ៝ង់​តា​ឞ្រី​ឆីរី ។ ");
INSERT INTO cmok_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","កើត​នទ្រី​ទឹង​លែៈ​ឞូនុយ្ស​ហាន់​គ្រុង​ញចីស​ឆាក់​តឹង​ប៝ន​អូ​ចែ​ខាន់​ពាង់​នើម​គុ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ជេសរី​យោឆែប  លោស​ឞើស​ប៝ន​នាឆារែត ​តា​ឞ្រី​កាលីលេ ​អី​នតុក​ពាង់​គុ​នៃ ឞ្រោៈ​ជឹត​ឞ្រី​លើ​ជឹត​ប៝ន​បេតលេហឹម  តា​ឞ្រី​យូដា ​អី​រី អី​នតុក​ប៝ន​ទែស​កាដាច់​ដាវីត ​កាល់​អែ​នើស យ៝រ​លាស​យោឆែប ​អី​នៃ​ពាង់​រាន៝យ​ទែស​កាដាច់​ដាវីត ។ ");
INSERT INTO cmok_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ពាង់​ឞ្រោៈ​ញចីស​ឆាក់​នទ្រែល​មារី ​អី​ឞូ​អូរ​ឞូ​គឹត​លាស​អូរ​ពាង់ មារី ​អី​នៃ​លែៈ​នត្រែវ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ត៝ត់​តា​ប៝ន​បេតលេហឹម មារី ​អី​នៃ​លែៈ​អាប់​ខៃ​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","តា​ជៃ​ឞូ​នាច់​វែស​ឞិច​លែៈ​ឞេង​ទាទេ។ ជេសរី​ពាង់​គុ​អ៝ស​ក៝ន​ឞូ​ក្លោ អី​នៃ​ក៝ន​ឞោក​ទាក។ មេៈ​ពាង់​ងក្រូម​អ៝ស​ឞេ​អី​នៃ​មា​ឞ៝ក ជេសរី​តេៈ​តា​ឞ៝ង​មពោមពា​(ឆ្យុម)​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","មាង់​អី​នៃ​តា​ប៝ន​បេតលេហឹម  គែស​មពោល​ច្យាប់​គុ​រាងែស​ក៝ប់​អ្វាញ់​ឞែ​ឞ្យាប់​ផូង ឞែ​ផូង​តា​នទ្រិច​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ជេសរី​ទោ​មា​ឆៃ​ទូ​ហ្វេ​តោង​ពារ់​កោរាញ​ឞ្រាស​ទ៝ក់​កេង​ខាន់​ពាង់​រី។ នាវ​អ្វែស​ច្រេក​មា​លើប​កោរាញ​ឞ្រាស​ច្រាត​ទាទេ​ងាន់​ជុម​នតុក​នៃ ត៝ត់​មា​ខាន់​ពាង់​ក្លាច​ញឆ៝រ់​ឆាក់​ជាន់​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","តោង​ពារ់​រី​លាស​មា​ខាន់​ពាង់៖ “លើយ​តា​ខាន់​មៃ​ក្លាច​អោស! គ៝ប់​លែវ​មឞើស​នាវ​មហែ​មហាន​អ្វែស​ងក៝ច​អ៝ន់​មា​ខាន់​មៃ។ នាវ​មហែ​មហាន​អ្វែស​អ្យា​អ៝ន់​មា​ទឹង​លែៈ​ឞូនុយ្ស​រាម់​មអាក​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","មាង់​អ្យា​តា​ប៝ន​បេតលេហឹម ​អី​ប៝ន​កាដាច់​ដាវីត  គែស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​មហែ​ទែស​ជេង​នើម​រាក្លាយ្ស​ទឹង​លែៈ​ឞូនុយ្ស។ ពាង់​អី​នៃ​ឞូ​លែៈ​មឞើស​ល៝រ​កាល់​អែ​នើស ពាង់​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់ ពាង់​កោរាញ​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ខាន់​មៃ​គឹត​នាល់​ពាង់​កើត​អ្យា លាស​ឆៃ​ទូ​ហ្វេ​អ៝ស​ឞេ​មហែ​ទែស​ឞូ​ពូត​ពាង់​មា​ឞ៝ក អ៝ន់​ឞិច​តា​ឞ៝ង​មពោមពា​(ឆ្យុម)​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ជេសរី​ទោ​មា​ឆៃ​ដ៝ង់​ផូង​តោង​ពារ់​ទុត​អ៝ក់​ងាន់ ជុរ​តាៈ​ឞើស​កាលើ​ត្រោក​នតុក​កោរាញ​ឞ្រាស​រី គុ​នទ្រែល​ទូ​ហ្វេ​តោង​ពារ់​អី​នៃ​នើស មព្រើ​រានេ​មា​កោរាញ​ឞ្រាស​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“អ៝ន់​រានេ​មា​កោរាញ​ឞ្រាស​គុ​តា​កាលើ​ត្រោក​ទុត​ព្រេស‌ ជេសរី​អ៝ន់​គែស​នាវ​ដាប់​មពាន់​មា​ឞូនុយ្ស​អី​កោរាញ​ឞ្រាស​រ៝ង់​តា​នែស​នតូ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","នទុត​តោង​ពារ់​ហាវ​ឆឹត​អា​កាលើ​ត្រោក​លែៈ​រាង៝ត់ ខាន់​ពាង់​តឹម​ជាៈ​នទ្រាង់​ខាន់​ពាង់​នើម៖ “ហោៈ! ល៝ង់​ឞ៝ន់​ហាន់​តា​ប៝ន​បេតលេហឹម  អ្វាញ់​អ៝ស​ឞេ​មហែ​ទែស​រី កើត​នាវ​កោរាញ​ឞ្រាស​មឞើស​មា​ឞ៝ន់​នទើស​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ជេសរី​ខាន់​ពាង់​ទ៝ក់​នទាល​តាៈ​ឞើស​នៃ​ហាន់​ជ៝យ​នតុក​គុ​អ៝ស​ឞេ​រី។ ត៝ត់​អា​រី​ឆៃ​មារី យោឆែប  នទ្រែល​មា​អ៝ស​ឞេ​ឞិច​តា​ឞ៝ង​មពោមពា​(ឆ្យុម)​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ជេស​ឆៃ​អ៝ស​ឞេ​អី​នៃ ខាន់​ពាង់​មឞើស​ងក៝ច​នាវ​តោង​ពារ់​លាស​មា​អ៝ស​ឞេ​អី​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","លែៈ​ឞូនុយ្ស​អី​តាង់​នាវ​មពោល​ច្យាប់​ឞែ​ឞ្យាប់​ច្យាប់​ឞែ​អី​នៃ​ងក៝ច ខាន់​ពាង់​នទ្រ៝ត់​ហីស​រាហ៝ល់​តា​នូយ្ស​នហ៝ម់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ល៝ង់​អី​មារី ​នៃ​ពាង់​ហោម​ព្រាប់​ងក្ល៝ន់​នាវ​អី​នៃ​តា​ឆាក់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ជេសរី​មពោល​ច្យាប់​ឞែ​ឞ្យាប់​អី​នៃ​ខាន់​ពាង់​ព្លឹ​ឆឹត នហ៝​មា​មព្រើ​រានេ​មា​កោរាញ​ឞ្រាស យ៝រ​លាស​មាត់​លែៈ​ឆៃ​តោរ​លែៈ​តាង់ លែៈ​នទើ​តោង​ពារ់​មឞើស​មា​ខាន់​ពាង់​នើស​ជេង​ទី​ទាទេ មោ​គែស​អោស​តីស​ទូ​នតីល។ ");
INSERT INTO cmok_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ត៝ត់​ផាម​នារ​ជេស​ទែស មេៈ​ឞឹ​ដាៈ​ឞូ​ក៝ស​នតោ​អ៝ន់​មា​អ៝ស​ឞេ​អី​នៃ​តឹង​មា​នាវ​វៃ​ផូង​អីឆ្រាអែល ​មា​ក៝ន​ឞូ​ក្លោ នហ៝​មា​តេៈ​រាញា​ពាង់ ក្វាល់ «យេឆូ » កើត​តោង​ពារ់​មឞើស​មា​មារី ​នោក​ពាង់​អេ​ហ៝ៈ​នត្រែវ​នើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","ជេស​គុ​អ៝ស​គែស ៤០ នារ មារី ​តឹង​នាវ​វៃ​មោឆេ ​លែៈ​ញចីស​កាល់​អែ​នើស ពាង់​ញហើរ​ឆ្យុម​នារ​មា​ជាន​ឞ្រាស គៃ​មា​រាវ​ឆាក់​ពាង់​នើម​អ៝ន់​ក្ល៝ស។ ត៝ត់​ទី​នារ​នៃ​ពាង់ នទ្រែល​មា​ឆាយ​ពាង់ លែវ​អ៝ស​ឞេ​ជេៈ​រី​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ។ ត៝ត់​តា​ប៝ន​នៃ ខាន់​ពាង់​លាប់​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​ញហើរ​ឞារ​មល៝ម់​ឆ្យុម​នារ​មា​ជាន​ឞ្រាស​តឹម​ទី​ដាស​នាវ​វៃ​កោរាញ​ឞ្រាស​លែៈ​ដាៈ​ញហើរ​នើស។ អាប់​តឹ​ជេស​គុ​អ៝ស នាវ​វៃ​នៃ​ដាៈ​ឞូ​ញហើរ “ឞារ​មល៝ម់​នតើប មោ​លាស​ឞារ​មល៝ម់​ព្លុក​រាស”។ ជេសរី​មេៈ​ឞឹ​ញហើរ​អ៝ស​ឞេ​រី​មា​កោរាញ​ឞ្រាស​ដ៝ង់ ខាន់​ពាង់​ជាន​កើត​នទ្រី​តឹង​នាវ​វៃ​កោរាញ​ឞ្រាស​លែៈ​ដាៈ​ឞូ​ញចីស​កាល់​អែ​នើស​លាស៖ “ទឹង​លែៈ​ក៝ន​ឞូ​ក្លោ​ឞោក​ទាក នអ៝ប់​មា​ក៝ន​មពោមពា​(ឆ្យុម)​ងក្វ៝ង់​ឞោក​ទាក អ៝ន់​ញហើរ​ព្រាប់​មា​កោរាញ​ឞ្រាស”។ ");
INSERT INTO cmok_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​រី​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​រាញា​ពាង់​ឆីមេអោន  ពាង់​អី​ឞូនុយ្ស​អ្វែស​ឆ៝ង់​ឆ្រាង់ អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ងាន់ ពាង់​គុ​ក៝ប់​រាហើប​ឞ្រាស​ក្រីស ​អី​កោរាញ​ឞ្រាស​ត៝ន​ដាៈ​ហាន់​រាតុក​រាថី​នហ៝​មា​រាក្លាយ្ស​ប៝ន​លាន​អីឆ្រាអែល ​ដ៝ង់។ ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​ជុរ​គុ​តា​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","មឞើស​អ៝ន់​ពាង់​គឹត ពាង់​មោ​ខឹត​អោស​លាស​មោ​ហ៝ៈ​ឆៃ​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","កាស​ទូ​នារ​រី​ឞ្រាស​ហ្វេង​អ្វែស​ដាៈ​ឆីមេអោន ​ហាន់​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស។ ត៝ត់​តា​នៃ​ឆៃ​យោឆែប  នទ្រែល​មា​មារី ​លែវ​អ៝ស​ឞេ​ហាន់​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​រី​ដ៝ង់ គៃ​មា​ញហើរ​អ៝ស​ឞេ​អី​នៃ​មា​កោរាញ​ឞ្រាស​កើត​នាវ​ឞូ​លែៈ​ជេស​ញចីស​តា​នាវ​វៃ​នៃ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ជេស​ឆីមេអោន ​ឆៃ​អ៝ស​ឞេ​អី​រី ពាង់​ក្លូ ជេសរី​ពាង់​រានេ​មា​កោរាញ​ឞ្រាស៖ ");
INSERT INTO cmok_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“អើយ​កោរាញ​ឞ្រាស! គ៝ប់​អ្យា​អី​ឞូនុយ្ស​ជាន​ការ​អ្យាត់​នាវ​មៃ អាបៃ​អ្យា​លាស​គ៝ប់​ខឹត គ៝ប់​លែៈ​គែស​នាវ​ដាប់​មពាន់​ជេស‌ យ៝រ​នាវ​មៃ​ត៝ន​មា​គ៝ប់​នើស​ជេង​ទី​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ត្រោម​មាត់​គ៝ប់​លែៈ​ឆៃ​នាវ​រាក្លាយ្ស​មៃ​អ៝ន់​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","នាវ​រាក្លាយ្ស​អី​នៃ​មៃ​លែៈ​នទ្រាប់​អ៝ន់​មា​លែៈ​មពោល​ឞូនុយ្ស​ឆៃ‌ ");
INSERT INTO cmok_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ពាង់​ជេង​តឹម​ឞាន​នាវ​អាង​គៃ​មា​ងអាង​លែៈ​មពោល​ឞូនុយ្ស​អី​មោ​ទី​ផូង​អីឆ្រាអែល  យ៝រ​មា​ពាង់​អ៝ន់​ខាន់​ពាង់​នៃ​គឹត​នាល់​កោរាញ​ឞ្រាស‌ ជេសរី​ផូង​អេងៗ​រានេ​រាហើន​ផូង​អីឆ្រាអែល  យ៝រ​មា​ឞ្រាស​ក្រីស ​តាៈ​ឞើស​ផូង​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","មេៈ​ឞឹ​អ៝ស​ឞេ​អី​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​នាវ​ឆីមេអោន ​លាស​មា​ក៝ន​ឞេ​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ឆីមេអោន ​មឞើស​នាវ​គែស​ជេង​មា​ខាន់​ពាង់ ជេសរី​លាស​មា​មារី ៖ “កោរាញ​ឞ្រាស​លែៈ​អ៝ន់​ឞូនុយ្ស​អ៝ក់​តា​ផូង​អីឆ្រាអែល ​គែស​នាវ​រ៝ស​ហេង​យ៝រ​មា​ខាន់​ពាង់​មោ​អ្យាត់​អោស​មា​ក៝ន​ឞេ​អ្យា យើន​មា​គែស​អ៝ក់​ជឹត​គែស​នាវ​រាក្លាយ្ស​យ៝រ​មា​ខាន់​ពាង់​អ្យាត់​មា​ក៝ន​ឞេ​អ្យា។ កោរាញ​ឞ្រាស​នើម​លែៈ​ញជ្វាល់​ជេស​ក៝ន​ឞេ​អ្យា​វាច់​តា​អ្យា តីស​មា​អ៝ក់​ឞូនុយ្ស​ហោម​តឹម​រាទ៝ង់​ដាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","នទ្រី​ទឹង​ឞូ​ឆៃ​ក្ល៝ស​រាស​វាស​នាវ​មឹន​ឞូនុយ្ស​ទុត​នទ៝ប់ អី​អៃ​នើម​តៃ​គែស​ជី​អោស​អេត​អោស​អេល​ងាន់ នហាៈ​មា​គែស​ដាវ​នត៝ប់​រាហ៝​តា​ព្លៃ​នូយ្ស​ព្លៃ​នហ៝ម់​អៃ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ជេសរី​គែស​ទូ​ហ្វេ​អូ​រាញ ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស ពាង់​រាញា​អាន  អី​ក៝ន​ផានូអែល ​តា​មពោល​អាឆើរ ។ ពាង់​នអាប់​លែៈ​គែស​ពើស​នាម់ ជេសរី​ឆាយ​ពាង់​ខឹត‌ ");
INSERT INTO cmok_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ជេស​ឆាយ​ពាង់​ខឹត​នៃ ពាង់​គុ​នទ្រោ​នហ៝ នោក​នៃ​ពាង់​លែៈ​រាញ ៨៤ នាម់។ ពាង់​គុ​ងក្រែ​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស ពាង់​យើក​មឞាស​មា​កោរាញ​ឞ្រាស​ទឹង​មាង់​ទឹង​នារ គែស​អ៝ក់​ពាង់​មឞើស​ឆើម​អ៝ត់​ឆោង​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","នោក​ឆីមេអោន ​ហោម​ងើយ អូ​អាន ​ត្រុយ្ស​តា​នៃ ត៝ត់​ឆៃ​អ៝ស​ឞេ​អី​នៃ ពាង់​រាន​រានេ​មា​កោរាញ​ឞ្រាស ជេសរី​ពាង់​មឞើស​ងក៝ច​មា​អ៝ស​ឞេ​ជេៈ​នៃ​អ៝ន់​មា​ឞូនុយ្ស​អី​គុ​ក៝ប់​រើប​ហើប​ឞ្រាស​ក្រីស ​អី​កោរាញ​ឞ្រាស​ដាៈ​ហាន់​គៃ​មា​រាក្លាយ្ស​ប៝ន​លាន​អីឆ្រាអែល ។ ");
INSERT INTO cmok_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ជេស​មេៈ​ឞឹ​ឞ្រាស​យេឆូ ​ជាន​លែៈ​ផ្យៅ​តឹម​ទី​តឹង​នាវ​វៃ​កោរាញ​ឞ្រាស ជេសរី​ខាន់​ពាង់​ព្លឹ​ឆឹត​តា​ប៝ន​ខាន់​ពាង់​នើម ប៝ន​នាឆារែត ​តា​ឞ្រី​កាលីលេ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ជេសរី​ឞ្រាស​យេឆូ ​នតើម​តេស​ដេៈ​ក្វ៝ង់​ដេៈ​ឆាក់​ជាន់​ពាង់​ទាង់ គែស​នាវ​មឹន​គឹត​ឞ្លាវ​ងាន់ យ៝រ​មា​កោរាញ​ឞ្រាស​គុ​នទ្រែល​កើល​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","តា​អាប់​នាម់​ឞូ​ញេត​បុន​នហ៝ត មេៈ​ឞឹ​ឞ្រាស​យេឆូ  នទ្រែល​មា​ផូង​ប៝ន​លាន​អីឆ្រាអែល ​វៃ​ហាន់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","តឹង​នាវ​វៃ​ខាន់​ពាង់​វៃ​ជាន​នើស មេៈ​ឞឹ​ឞ្រាស​យេឆូ ​ហាវ​លាប់​ញេត​បុន។ ត៝ត់​ទូ​នាម់​ឞ្រាស​យេឆូ ​លែៈ​គែស ១២ នាម់ ជេសរី​មេៈ​ឞឹ​លែវ​ពាង់​ហាន់​នទ្រែល​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ត៝ត់​លោច​ញេត​បុន អី​មេៈ​ឞឹ​រី​ឆឹត​គ្រុង។ មោ​គឹត​អោស​លាស​ក៝ន​ខាន់​ពាង់​ហោម​គុ​តា​ប៝ន​យេរូឆាលឹម ‌ ");
INSERT INTO cmok_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","នអោន​លាស​លែៈ​ហាន់​នទ្រែល​ឞូ។ ត៝ត់​ហាន់​លែៈ​គែស​ទូ​នារ​រាមាង់ រី​មើ​ខាន់​ពាង់​នតើម​ជ៝យ​ក៝ន​ខាន់​ពាង់​តា​ឞាល់​មពោល​ខាន់​ពាង់​គឹត​នាល់‌ ");
INSERT INTO cmok_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ជ៝យ​មោ​ឆៃ​អោស ជេសរី​ខាន់​ពាង់​ព្លឹ​តៃ​តា​ប៝ន​យេរូឆាលឹម  គៃ​មា​ជ៝យ​ពាង់​តា​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ជ៝យ​ត៝ត់​ពែ​នារ ខាន់​ពាង់​ឆៃ​ពាង់​គុ​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស​នទ្រែល​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​តា​រី ពាង់​គុ​អ្យាត់​នាវ​ឞូ​ងើយ ងក្រែ​មា​អោប​ឞូ​នាវ​អេងៗ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ឞូ​ម៝ស​អី​តាង់​នាវ​ឞ្រាស​យេឆូ ​អើស ឞូ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់ មោ​វ៝ត់​អោស​នាវ​ពាង់​អើស​អី​នៃ​ឞ្លាវ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ត៝ត់​មេៈ​ឞឹ​ឆៃ​ជេស​អី​ក៝ន​នៃ ឞារ​ហៃ​ខាន់​ពាង់​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់។ មេៈ​ពាង់​អោប៖ “ហើយ​នោ! មើម​ជាន​មៃ​កើត​នអៃ​នៃ​ហាៈ? ហេន​រាវៃ​ហោ​ងាន់​ហាន់​ជ៝យ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ក៝ន​ពាង់​អើស៖ “ហើយ​មេៈ​ឞឹ ម៝ស​នាវ​ខាន់​អៃ​មៃ​ជ៝យ​គ៝ប់? គ៝ប់​អ្យា​គុ​តា​ជៃ​អី​ឞឹ​គ៝ប់​នើម​ហែស”។ ");
INSERT INTO cmok_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","តីស​មា​មេៈ​ឞឹ​មោ​វ៝ត់​អោស​នាវ​ក៝ន​ពាង់​អើស​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","អី​មេៈ​ពាង់​រី​ព្រាប់​លែៈ​នាវ​អី​នៃ​តា​ត្រោម​ឆាក់​ពាង់​នើម។ ជេសរី​អី​ក៝ន​នៃ​ព្លឹ​ឆឹត​អា​ប៝ន​នាឆារែត ​នទ្រែល​មេៈ​ឞឹ អ្យាត់​នាវ​អី​មេៈ​ឞឹ​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ឞ្រាស​យេឆូ ​លើ​មា​នទាម់ លើ​មា​គែស​នាវ​មឹន​គឹត​ឞ្លាវ ទី​នូយ្ស​ទី​នហ៝ម់​កោរាញ​ឞ្រាស​ងាន់ នទ្រែល​មា​ទី​នូយ្ស​ទី​នហ៝ម់​ឞូនុយ្ស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","នោក​កោរាញ​កាដាច់​ឆេឆារ ​រាញា​តីបេរៀស  ពាង់​ម៝ត់​អ្វាញ់​តា​ប៝ន​រោម ​លែៈ​គែស ១៥ នាម់ គែស​ពុនតេស-​ពីលាត ​ជាន​កោរាញ​ក្វ៝ង់​តា​ឞ្រី​យូដា  គែស​ហេរោត-​អ៝ន់តីពាស  ពាង់​ម៝ត់​អ្វាញ់​ឞ្រី​កាលីលេ  គែស​ផីលីប ​អី​នោ​ហេរោត ​រី ពាង់​ម៝ត់​អ្វាញ់​ឞ្រី​អីតូរេ  នទ្រែល​មា​ឞ្រី​ត្រាខោនីត  គែស​លីឆានេស  ពាង់​ម៝ត់​អ្វាញ់​ឞ្រី​អាបែលែន ។ ");
INSERT INTO cmok_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ជេសរី​គែស​ដ៝ង់​ឞារ​ហៃ​កោរាញ​មពោល​ជាន​ឞ្រាស រាញា​ខាន់​ពាង់​អានាស  នទ្រែល​មា​កៃផាស ។ នោក​នៃ​យោហាន ​អី​ក៝ន​ឆាការី ​គុ​តា​ឞ្រី​រាទាស​ងាយ​ឞើស​ប៝ន​អេងៗ ជេសរី​កោរាញ​ឞ្រាស​នតិញ​នាវ​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ជេសរី​យោហាន ​ឞ្រោៈ​អាប់​ប៝ន​រ៝ៈ​ទាក​រាលាយ​យោរដាន់  មឞើស​ងក៝ច​មា​ប៝ន​លាន​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស ជេសរី​ទើន​នាវ​យុក​មា​ទាក អី​ឞូ​ក្វាល់​«បាប់តែម» គៃ​មា​ញហើ​ខាន់​ពាង់​អុច​តឹង​នាវ​កោរាញ​ឞ្រាស នទ្រី​ទឹង​កោរាញ​ឞ្រាស​យោៈ​នអាច​មោ​ហោម​អោស​កើប​នាវ​តីស​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ពាង់​ជាន​កើត​នៃ​តឹម​ទី​កើត​នាវ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស រាញា​អេឆាយ  ពាង់​ញចីស​លាស៖ «គែស​ទូ​ហ្វេ​ឞូនុយ្ស​នតែរ​តា​ឞ្រី​រាទាស​លាស៖ «នទ្រាប់​ហ៝ម់​នូយ្ស​នហ៝ម់​អ៝ន់​មា​កោរាញ​ឞ្រាស តឹម​ឞាន​មា​ឞូនុយ្ស​ក្វាយ្ស​ត្រ៝ង​ញឆ៝ង់​ត្រ៝ង​អ៝ន់​មា​កាដាច់​ហាន់‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","តឹម​ឞាន​មា​ឞូនុយ្ស​ឞ្រោយ​លើយ​នតុក​រាលុង​អ៝ន់​ឞេង‌ យោក​ជេៈ​ក្វ៝ង់​ខាន់​ពាង់​ជាន​អ៝ន់​ល៝ង់ ខាន់​ពាង់​ញឆ៝ង់​នតុក​ក្វែ​ក្វាច់​អ៝ន់​ឆ៝ង់ នតុក​នទោស​នទាប់​ខាន់​ពាង់​ឞ្រោយ​លើយ​អ៝ន់​ល៝ង់ តឹម​ឞាន​មា​ក្វាយ្ស​ត្រ៝ង​អ៝ន់​មា​កាដាច់​ឞ្រោៈ។ ");
INSERT INTO cmok_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","នទ្រី​ទឹង​លែៈ​ឞូនុយ្ស​គឹត​ឆៃ​នើម​រាក្លាយ្ស​អី​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់»»។ ");
INSERT INTO cmok_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ជេស​តាង់​នាវ​យោហាន ​មឞើស​នៃ​នើស ខាន់​ពាង់​ឞ្រោៈ​គ្រុង​ដាៈ​ពាង់​បាប់តែម​យុក​មា​ទាក គែស​អ៝ក់​ឞូនុយ្ស​អី​ហាន់​បាប់តែម​យុក​មា​ទាក យើន​មា​មោ​អុច​អោស​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស យោហាន ​លាស៖ “យេ! មពោល​ឞូនុយ្ស​អ្យើស​ឞូនុយ្ស​ជាញ​តឹម​ឞាន​មា​ឞេស​កូ ឞូ​ម៝ស​មឞើស​មា​ខាន់​អៃ​មៃ​ទឹង​គែស​មា​ញច្វាត់​ក្រាប​ឞើស​នាវ​តេៈ​ទោយ្ស​កោរាញ​ឞ្រាស​អី​ឞើយ​មា​ត៝ត់​អ្យា? ");
INSERT INTO cmok_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","លាស​ខាន់​អៃ​មៃ​មោ​អុច​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស លាស​នទ្រី​គុ​ឆ៝ង់​ជាន​អ្វែស​ហ៝ម់ គៃ​មា​គឹត​ឆៃ​នូយ្ស​នហ៝ម់​ខាន់​អៃ​មៃ​លែៈ​រាគ៝ល់​ងាន់​រ៝។ លើយ​ហោម​លាស​អេង​តា​ឆាក់​ខាន់​អៃ​មៃ​នើម៖ «គ៝ប់​លែៈ​ឆៅ​អាឞ្រាហាម់ ​ងាន់ នទ្រី​កោរាញ​ឞ្រាស​មោ​ហោម​អោស​តេៈ​ទោយ្ស»។ គ៝ប់​លាស​មា​ខាន់​អៃ​មៃ ជេង​ឆៅ​អាឞ្រាហាម់ ​ទើម​មោ​អោស​គែស​នាវ​ខ្លៃ លុ​អ្យា​កោរាញ​ឞ្រាស​ឆ៝ៈ​ជាន​ឆៅ​អាឞ្រាហាម់ ​ជេង​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","អាបៃ​អ្យា​កោរាញ​ឞ្រាស​អុច​តេៈ​ទោយ្ស​មា​លែៈ​ឞូនុយ្ស​អី​មោ​ជាន​អ្វែស ពាង់​តឹម​ឞាន​មា​ឞូនុយ្ស​នទ្រាប់​ពេស​ថាវ​មា​កាល់​លើយ​តើម​ឆី​មោ​គែស​ព្លៃ ជេសរី​ឆូ​លើយ​មា​អុញ”។ ");
INSERT INTO cmok_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ផូង​អី​នៃ​អោប​យោហាន ៖ “មើម​ជាន​ហាៈ គៃ​មា​រាក្លាយ្ស​ឞើស​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​ហេន?” ");
INSERT INTO cmok_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","យោហាន ​អើស​មា​ខាន់​ពាង់៖ “ឞូ​ម៝ស​អី​គែស​ឞារ​ឞ្លាស​អាវ អ៝ន់​ពាង់​ពាៈ​ទូ​ឞ្លាស​មា​ឞូនុយ្ស​មោ​គែស ឞូនុយ្ស​អី​គែស​នទើ​ឆោង​ឆា អ៝ន់​ពាង់​ពាៈ​មា​ឞូនុយ្ស​មោ​គែស”។ ");
INSERT INTO cmok_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","គែស​ឞូនុយ្ស​អាបាៈ​តាៈ​ឞើស​មពោល​ក៝ប់​ឆ៝ៈ​ព្រាក់​ឞើស​ប៝ន​លាន​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ ឞ្រោៈ​ទាន់​យោហាន ​បាប់តែម​យុក​មា​ទាក​តា​រី អោប​ពាង់​ដ៝ង់៖ “ហើយ​នើម​នតី លាស​នទ្រី​ហេន​អ្យា​មើម​ជាន​មេស?” ");
INSERT INTO cmok_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","យោហាន ​អើស៖ “លើយ​អោស​រាអ៝ត់​លើយ​អោស​មរោស​ឞូ​គៃ​មា​ឆ៝ៈ​ព្រាក់​អ៝ក់​រាលាវ​កែស”។ ");
INSERT INTO cmok_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","គែស​ផូង​តាហែន​អាបាៈ​អោប​ពាង់៖ “លាស​នទ្រី​ហេន​អ្យា មើម​ជាន​មេស?” ពាង់​អើស៖ “លើយ​ទឹង​នតោន​ញច្រ៝ស​ឞូ លើយ​អោស​តុន​ជ៝ត​ឞូ​គៃ​មា​ឆ៝ៈ​ព្រាក់​ឞូ អ៝ន់​ឆ៝ប់​ត៝ង់​ទើន​មា​ព្រាក់​ខៃ​ខាន់​មៃ​នើម​ហ៝ៈ”។ ");
INSERT INTO cmok_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ផូង​ប៝ន​លាន​អីឆ្រាអែល  ខាន់​ពាង់​ហោម​គុ​ក៝ប់​ត៝ត់​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​រី​វាច់។ ឞូនុយ្ស​អី​តាង់​នាវ​យោហាន ​លាស ទឹង​លែៈ​ខាន់​ពាង់​អី​នៃ​គែស​មឹន​អេង​តា​នូយ្ស​នហ៝ម់៖ “ពាង់​អី​នៃ​ឞ្រាស​ក្រីស ​មោ​លាស​មោ?” ");
INSERT INTO cmok_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ជេសរី​យោហាន ​មឞើស​ទឹង​លែៈ​ឞូនុយ្ស ពាង់​លាស៖ “គ៝ប់​ជាន​បាប់តែម​អ៝ន់​ខាន់​អៃ​មៃ​យុក​មា​ទាក​ទើម យើន​មា​គែស​ទូ​ហ្វេ​កោរាញ​ឞើយ​ត៝ត់​ជេស ពាង់​គែស​នាវ​ទើយ​រាលាវ​គ៝ប់​ងាន់ តា​នាប់​ពាង់​គ៝ប់​ជេង​ឞូនុយ្ស​ជេៈ​លេៈ​ទើម ឞ៝ល​លាស​គ៝ប់​ឆើម​ទ្រ៝ស​នតោ​ជ៝ត​ពាង់ ហោម​អែ​មោ​ហ៝ៈ​ទី​ដ៝ង់​ដាស​នាវ​ជាន​ការ​ពាង់។ ពាង់​បាប់តែម​អ៝ន់​ខាន់​អៃ​មៃ​មា​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស នទ្រែល​មា​អុញ។ ");
INSERT INTO cmok_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ពាង់​តឹម​ឞាន​មា​ឞូនុយ្ស​ញអោត​ទោង គៃ​មា​រាឆែង​លែៈ​ឞា​អី​គែស​តា​នតុក​ពាង់​ព្លេន​នៃ ឞា​រាង្លៃ​ពាង់​ឆ៝ៈ​តោស​ព្រាប់​តា​ជៃ​ឞា​ពាង់​នើម អី​ញឆ្យាប់​ពាង់​ឆូ​លើយ​មា​អុញ​មោ​អោស​ឞ្លាវ​ញហ៝ត់ កើត​នទ្រី​ពាង់​តឹម​ងខាស​លើយ​ឞូនុយ្ស​អ្វែស​ដាស​ឞូនុយ្ស​អ្យើស ជេសរី​តេៈ​ទោយ្ស​មា​ឞូនុយ្ស​អ្យើស”។ ");
INSERT INTO cmok_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","នទ្រី​យោហាន ​ពាង់​មឞើស​នាវ​មហែ​មហាន​អ្វែស​អី​នៃ​មា​ផូង​ប៝ន​លាន នទ្រែល​មា​នតុម​នតី​នាវ​អា​អេង​អ៝ក់​ជឹត​គៃ​មា​អ៝ន់​ខាន់​ពាង់​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស។ ");
INSERT INTO cmok_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ជេសរី​យោហាន ​នទុយ្ស​លាស​ទុត​ទាង់​អ៝ន់​មា​ហេរោត-​អ៝ន់តីពាស ​អី​កោរាញ​ម៝ត់​អ្វាញ់​ឞ្រី​កាលីលេ  យ៝រ​មា​ពាង់​ឆ៝ៈ​ពីត​អូរ​អី​អ៝ស​ពាង់​នើម រាញា​ឞូ​អូរ​អី​នៃ​ហេរោដៀស  ជេសរី​ពាង់​ឆ៝ៈ​ជាន​អូរ។ យោហាន ​លាស​ហេរោត ​អី​នៃ​មា​នាវ​ពាង់​ជាន​តីស​អេងៗ​អ៝ក់​ជឹត មោ​អោស​ទើន​មា​នាវ​តីស​អី​នៃ​ទើម‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ពាង់​ជាន​តីស​លើ​មា​ហោ​ជឹត​ត៝ត់​ពាង់​ញុប​ក្រុង​យោហាន ​តេៈ​តា​ត្រោម​នទ្រូង​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","នោក​យោហាន ​ហោម​ជាន​បាប់តែម​មា​ផូង​ប៝ន​លាន ត៝ត់​ឞ្រោៈ​ឞ្រាស​យេឆូ ​ទើន​នាវ​យុក​បាប់តែម​ដ៝ង់ ជេស​បាប់តែម​ពាង់​ហោម​មឞើស​ឆើម ទោ​មា​ត្រោក​ពើក​ឞ៝ង់​លាហឺរ។ ");
INSERT INTO cmok_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ជេសរី​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស អ្វាញ់​តឹម​ឞាន​មា​ព្លុក ជុរ​ទ្រ៝ម់​តា​ពាង់​រី ទោល​នៃ​គែស​តាង់​នតែស​ឞ៝រ់​តាៈ​ឞើស​កាលើ​ត្រោក​លាស៖ “មៃ​អី​ក៝ន​គ៝ប់​រ៝ង់ គ៝ប់​រាម់​រាហើន​មៃ​ហោ​ងាន់​ងេន”។ ");
INSERT INTO cmok_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ត៝ត់​នារ​ឞ្រាស​យេឆូ ​នតើម​ជាន​ការ​មា​កោរាញ​ឞ្រាស នាម់​ពាង់​ក្លាប់​លាស​លែៈ​គែស ៣០ នាម់។ តឹង​នាវ​ឞូ​មឹន ពាង់​នើស​អី​ក៝ន​យោឆែប យោឆែប ​អី​ក៝ន​ហេលី ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ហេលី ​អី​ក៝ន​មាត់ថាត់ មាត់ថាត់ ​អី​ក៝ន​លេវី លេវី ​អី​ក៝ន​មេលកី មេលកី ​អី​ក៝ន​យានាយ យានាយ ​អី​ក៝ន​យោឆែប ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","យោឆែប ​អី​ក៝ន​មាតាថេស មាតាថេស ​អី​ក៝ន​អាមុស អាមុស ​អី​ក៝ន​នាហុម នាហុម ​អី​ក៝ន​អេឆាលី អេឆាលី ​អី​ក៝ន​នាគាយ ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","នាគាយ ​អី​ក៝ន​មាត មាត ​អី​ក៝ន​មាតាថេស មាតាថេស ​អី​ក៝ន​ឆេមី ឆេមី ​អី​ក៝ន​យោឆែក យោឆែក ​អី​ក៝ន​យូដា ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","យូដា ​អី​ក៝ន​យោអានាន យោអានាន ​អី​ក៝ន​រេឆា រេឆា ​អី​ក៝ន​ឆោរោបាបែល ឆោរោបាបែល ​អី​ក៝ន​ឆាលាថីល ឆាលាថីល ​អី​ក៝ន​នេរី ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","នេរី ​អី​ក៝ន​មេលកី មេលកី ​អី​ក៝ន​អាដី អាដី ​អី​ក៝ន​កោឆាន កោឆាន ​អី​ក៝ន​អេលមាដាម់ អេលមាដាម់ ​អី​ក៝ន​អែរ ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","អែរ ​អី​ក៝ន​យោឆ្វេ យោឆ្វេ ​អី​ក៝ន​អេលេឆារ អេលេឆារ ​អី​ក៝ន​យោរីម យោរីម ​អី​ក៝ន​មាថាត មាថាត ​អី​ក៝ន​លេវី ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","លេវី ​អី​ក៝ន​ឆីមេអោន ឆីមេអោន ​អី​ក៝ន​យូដា យូដា ​អី​ក៝ន​យោឆែប យោឆែប ​អី​ក៝ន​យោនាម យោនាម ​អី​ក៝ន​អេលេកីម ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","អេលេកីម ​អី​ក៝ន​មេលេអា មេលេអា ​អី​ក៝ន​មេនា មេនា ​អី​ក៝ន​មាតាថា មាតាថា ​អី​ក៝ន​នាថាន នាថាន ​អី​ក៝ន​កាដាច់​ដាវីត ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","កាដាច់​ដាវីត ​អី​ក៝ន​យេឆេ យេឆេ ​អី​ក៝ន​អោបេត អោបេត ​អី​ក៝ន​ឞោអាស ឞោអាស ​អី​ក៝ន​ឆាល់មោន ឆាល់មោន ​អី​ក៝ន​នាសឆោន ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","នាសឆោន ​អី​ក៝ន​អាមីនាដាប់ អាមីនាដាប់ ​អី​ក៝ន​អារាម អារាម ​អី​ក៝ន​ហេឆ្រុន ហេឆ្រុន ​អី​ក៝ន​ពេរេស ពេរេស ​អី​ក៝ន​យូដា ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","យូដា ​អី​ក៝ន​យាកោប យាកោប ​អី​ក៝ន​អីឆាក់ អីឆាក់ ​អី​ក៝ន​អាឞ្រាហាម់ អាឞ្រាហាម់ ​អី​ក៝ន​ថេរា ថេរា ​អី​ក៝ន​នាហោរ ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","នាហោរ ​អី​ក៝ន​ឆេរូក ឆេរូក ​អី​ក៝ន​រេអូ រេអូ ​អី​ក៝ន​ផាលេក ផាលេក ​អី​ក៝ន​អេបែរ អេបែរ ​អី​ក៝ន​ឆេលាស ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ឆេលាស ​អី​ក៝ន​ខៃនាន ខៃនាន ​អី​ក៝ន​អារពាក់ឆាត អារពាក់ឆាត ​អី​ក៝ន​ឆិម ឆិម ​អី​ក៝ន​នោអេ នោអេ ​អី​ក៝ន​លាមេក ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","លាមេក ​អី​ក៝ន​មឹថូឆាលា មឹថូឆាលា ​អី​ក៝ន​ហេនុក ហេនុក ​អី​ក៝ន​យារេត យារេត ​អី​ក៝ន​មហាលលេលអែល មហាលលេលអែល ​អី​ក៝ន​ខៃនាន ‌ ");
INSERT INTO cmok_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ខៃនាន ​អី​ក៝ន​អេនោស អេនោស ​អី​ក៝ន​ឆេត ឆេត ​អី​ក៝ន​អាដាម់ អាដាម់ ​អី​រី​អី​ក៝ន​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​ទាក​រាលាយ​យោរដាន់ ​នហ៝​មា​ឞ្រាស​ហ្វេង​អ្វែស​គុ​តា​ពាង់​ងាន់ ជេសរី​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​លែវ​ពាង់​តា​ឞ្រី​រាទាស​ងាយ​ឞើស​ប៝ន​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","តា​នតុក​នៃ​កោរាញ​មពោល​ឞ្រាស​អ្យើស​នទើម​ពាង់ ៤០ នាង់ ៤០ នារ នោក​នៃ​ពាង់​មោ​គែស​អោស​លាប់​នទើ​ឆោង​ឆា​ទូ​រាង្លៃ​តា​ឆាក់។ ជេស​ឞើស​នៃ​ពាង់​ជី​ង៝ត​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ជេសរី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​លាស​មា​ពាង់៖ “លាស​មៃ​ក៝ន​កោរាញ​ឞ្រាស​ងាន់​ងេន ល៝ង់​មៃ​ដាៈ​លុ​អ្យា​អ៝ន់​ជេង​នុមពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ឞ្រាស​យេឆូ ​អើស៖ “មោ​អោស លែៈ​ឞូ​ញចីស​ជេស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ៖ «ឞូនុយ្ស​មោ​អោស​រេស​តាៈ​ឞើស​នទើ​ឆោង​ឆា​ទើម»”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ជេសរី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​លែវ​ឞ្រាស​យេឆូ ​តា​នតុក​ព្រេស ញហើ​ទូ​នទ៝ម់​ទើម​អ៝ន់​ពាង់​ឆៃ​ទឹង​លែៈ​ឞ្រី​ទាក​តា​នែស​នតូ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ជេសរី​លាស​មា​ឞ្រាស​យេឆូ ៖ “គ៝ប់​អ៝ន់​នាវ​ទើយ​មា​មៃ​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ឞ្រី​ទាក​អី​នៃ នទ្រែល​មា​លែៈ​ទ្រាប់​នទើ​នាវ​ខ្លៃ​គែស​តា​ឞ្រី​ទាក​អី​នៃ គ៝ប់​អ៝ន់​មា​មៃ​ទាទេ យ៝រ​លាស​លែៈ​ទ្រាប់​នទើ​អី​នៃ​នើស​ជេង​ទ្រាប់​នទើ​គ៝ប់​នើម​ទាទេ ឞូ​ម៝ស​គ៝ប់​អុច​អ៝ន់​ទុត​តា​គ៝ប់​នើម​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","លាស​នទ្រី​មៃ​យើក​មឞាស​មា​គ៝ប់​ទោ នទ្រី​មើ​ទឹង​លែៈ​ទ្រាប់​នទើ​អី​នៃ​ជេង​ទ្រាប់​នទើ​មៃ​ទាទេ​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “មោ​អោស លែៈ​ឞូ​ញចីស​ជេស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​កាល់​អែ​នើស៖ «ដាៈ​ខាន់​អៃ​មៃ​យើក​មឞាស​មា​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ខាន់​អៃ​មៃ​នើម​ទើម​ហ៝ៈ ជាន​ការ​អ្យាត់​នាវ​ទូ​ហ្វេ​ពាង់​អី​នៃ​ទើម​ហ៝ៈ»”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ជេស​ឞើស​នៃ​ពាង់​លែវ​ឞ្រាស​យេឆូ ​លាប់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  ជេសរី​អ៝ន់​ឞ្រាស​យេឆូ ​ទ៝ក់​តា​កាលើ​ច៝រ​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស តា​នតុក​អី​ទុត​ព្រេស​នៃ ពាង់​លាស​មា​ឞ្រាស​យេឆូ ៖ “លាស​មៃ​ក៝ន​កោរាញ​ឞ្រាស​ងាន់​ងេន ល៝ង់​មៃ​ញឆាត់​ជឹត​ទ៝ង់​ឆូ‌ ");
INSERT INTO cmok_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","យ៝រ​លាស​លែៈ​ឞូ​ញចីស​ជេស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ៖ «កោរាញ​ឞ្រាស​ដាៈ​តោង​ពារ់​ពាង់​នើម​ហាន់ ម៝ត់​ញជ្រាង់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","តី​ពាង់​ទ្រើ​មៃ‌ មោ​អោស​អ៝ន់​ជ៝ង់​មៃ​គែស​ញចិញ​មា​លុ»”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ឞ្រាស​យេឆូ ​អើស​លាស៖ “លែៈ​ឞូ​ញចីស​ជេស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​លាស៖ «លើយ​អោស​រាល៝ង​នាវ​ទើយ​កោរាញ​ឞ្រាស​អី​ឞ្រាស​មៃ​នើម»”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","លែៈ​ជេស​អាប់​ផ្យៅ​ពាង់​នទើម​ឞ្រាស​យេឆូ  ជេសរី​ពាង់​ទូ​តាៈ​ឞើស​ឞ្រាស​យេឆូ ​រី​នហ៝​មា​ក៝ប់​ត៝ត់​ទី​នារ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ជេសរី​ឞ្រាស​យេឆូ ​ព្លឹ​ឆឹត​តា​ឞ្រី​កាលីលេ ។ នាវ​ទើយ​ឞ្រាស​ហ្វេង​អ្វែស​គុ​តា​ពាង់។ ជេសរី​ឞូ​លឺ​ឆាក់​ពាង់​អាប់​នតុក​តា​ឞ្រី​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ពាង់​គុ​នតុម​នតី​ឞូ​អាប់​នតុក​តា​ញីស​រាបុន​ខាន់​ពាង់​នើម អាប់​ឞូនុយ្ស​រានេ​ពាង់​ទាទេ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","គែស​ទូ​នារ​រី​ឞ្រាស​យេឆូ ​ហាន់​តា​ប៝ន​នាឆារែត  នតុក​ពាង់​គុ​ឞើស​ជេៈ​នើស។ តឹង​មា​នាវ​វៃ​ពាង់​នើស នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល ​ពាង់​ហាន់​តា​ញីស​រាបុន។ ជេសរី​ពាង់​ទ៝ក់​គៃ​មា​នទ្រាប់​រ៝ៈ​នាវ​កោរាញ​ឞ្រាស​ងើយ​អ៝ន់​ឞូ​អ្យាត់។ ");
INSERT INTO cmok_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ជេសរី​ឞូ​ឆ៝ៈ​នាវ​កោរាញ​ឞ្រាស​ងើយ ឆ៝ម់បុត​អេឆាយ ​ញចីស​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស នទឹ​អ៝ន់​ឞ្រាស​យេឆូ ។ ជេសរី​ពាង់​ពើក​លីង​អ្វាញ់​តា​ព្លាង់​នតុក​អេឆាយ ​ញចីស​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«ឞ្រាស​ហ្វេង​អ្វែស​គុ​តា​គ៝ប់‌ ពាង់​លែៈ​កើយ្ស​គ៝ប់ គៃ​មា​គ៝ប់​លែវ​នាវ​មហែ​មហាន​អ្វែស​មឞើស​មា​ឞូនុយ្ស​អ៝​អាច។ ពាង់​ដាៈ​គ៝ប់​ហាន់​មឞើស​ងក៝ច​នាវ​រាក្លាយ្ស​អ៝ន់​មា​ឞូនុយ្ស​អី​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​លែៈ​ញុប​ក៝ត់ កោរាញ​ឞ្រាស​ទែ​ទ្រីស​បើក​ទាទេ។ ពាង់​ដាៈ​គ៝ប់​ហាន់​មឞើស​ងក៝ច​មា​ឞូនុយ្ស​ចែស​មាត់​អ៝ន់​ឆៃ​អាង។ ជេសរី​ដាៈ​គ៝ប់​រាក្លាយ្ស​ឞូនុយ្ស​ឞូ​តុន​ជ៝ត។ ");
INSERT INTO cmok_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","នហ៝​មា​មឞើស​នាម់​កោរាញ​ឞ្រាស​យោៈ​នអាច​លែៈ​ត៝ត់»។ ");
INSERT INTO cmok_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","លោច​ជេស​ឞ្រាស​យេឆូ ​រ៝ៈ​នាវ​អី​នៃ ពាង់​ក្លោន​នាវ​កោរាញ​ឞ្រាស​ងើយ​នទឹ​អ៝ន់​មា​ឞូនុយ្ស​ម៝ត់​ញីស​រាបុន ជេសរី​ពាង់​គុ​នតី​នាវ​អី​នៃ។ លែៈ​ឞូនុយ្ស​គុ​តា​ត្រោម​ញីស​អី​នៃ​អ្វាញ់​ផ៝ង់​រាវ​លាវ​ជឹត​ពាង់​រី​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ជេសរី​ឞ្រាស​យេឆូ ​លាស៖ “លែៈ​នាវ​កោរាញ​ឞ្រាស​ងើយ​អី​ខាន់​អៃ​មៃ​តាង់​នទើស​នើស នារ​អ្យា​លែៈ​ត៝ត់​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ឞើស​នតើម​ទឹង​លែៈ​ឞូនុយ្ស​តា​នៃ​ខាន់​ពាង់​មអាក​រានេ​មា​ឞ៝រ់​មឞូង​ពាង់​ទាទេ តាង់​នាវ​ពាង់​នតី​នើស​ឞ្លាវ​អ្វែស​ងាន់។ ជេសរី​គែស​ឞូនុយ្ស​តឹម​រាលាច់​មា​នាវ​ពាង់​មឞើស​អី​នៃ​នើស ខាន់​ពាង់​លាស៖ “ហៃ! មើម​ពាង់​ឞាញ់​ងើយ​កើត​នៃ? យ៝រ​លាស​ពាង់​អី​នៃ​ក៝ន​យោឆែប ​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ងាន់​រ៝ ខាន់​អៃ​មៃ​ឆ៝ៈ​នាវ​ងើយ​នតឹត​អ្យា​លាស​មា​គ៝ប់៖ «ហើយ​កោរាញ​ទាក​ឆី ឆាម់​ឞាស​ឆាក់​មៃ​នើម​ល៝រ​ប៝ត់» គែស​នាវ​ខ្លៃ​លាស «ហេន​លឺ​តាង់​នាវ​មៃ​លែៈ​ជាន​តា​ប៝ន​កាពើនិម  ល៝ង់​ជាន​តៃ​នាវ​អី​នៃ​តា​ប៝ន​មៃ​នើម​អ្យា​ដ៝ង់»”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ឞ្រាស​យេឆូ ​លាស​តៃ​មា​ខាន់​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​តា​ប៝ន​ពាង់​នើម​មោ​គែស​អោស​ឞូ​អ្យាត់​នាវ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស រាញា​ពាង់​អេលីយា  នោក​នៃ​គែស​នាម់​ផាង​ជ៝ៈ​ពែ​នាម់​ងគូល មោ​គែស​អោស​នទើ​ឆោង​ឆា គែស​នាវ​ជី​ឆ៝ត់​ជី​ង៝ត​ក្វ៝ង់​លាម​ឞ្រី។ គែស​អ៝ក់​ដ៝ង់​ឞូ​អូរ​នទ្រោ​តា​ឞ្រី​អីឆ្រាអែល ។ ");
INSERT INTO cmok_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","យើន​មា​កោរាញ​ឞ្រាស​មោ​អោស​ដាៈ​ពាង់​ហាន់​កើល​ទូ​ហ្វេ​ឞូ​អូរ​នទ្រោ​អី​នៃ ពាង់​ដាៈ​ហាន់​កើល​ងខើង​ទូ​ហ្វេ​ឞូ​អូរ​នទ្រោ​តា​ឞ្រី​ឆីដោន  ប៝ន​ឆារិបដា ​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","គែស​ទូ​ហ្វេ​ជឹត​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស រាញា​ពាង់​អេលីឆេ  គែស​អ៝ក់​ឞូនុយ្ស​ផុង​ឆា​តា​ឞ្រី​អីឆ្រាអែល  មោ​អោស​ទូ​ហ្វេ​ឞាស ទើន​ឞាស​ទូ​ហ្វេ​តា​ផូង​ឞ្រី​ឆីរី ​ទើម​រាញា​ពាង់​នាមាន់ ”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ត៝ត់​មា​តាង់​នាវ​ឞ្រាស​យេឆូ ​ងើយ​កើត​រី លែៈ​ឞូនុយ្ស​គុ​អ្យាត់​ជី​នូយ្ស​មា​ពាង់​ទាទេ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ជេសរី​ខាន់​ពាង់​ទ៝ក់​ទ្រឺម​ញជោម​ជុម​ឞ្រាស​យេឆូ ​តេក​ងលោស​ពាង់​ទូ​លោស​ឞើស​ប៝ន​ឞូ​ជាន​តា​កាលើ​យោក​នៃ លែវ​ពាង់​ជឹត​ជ្រែង​យោក​រី​គៃ​មា​ងក្លឹ​ជឹត​ទ៝ង់​ឆូ។ ");
INSERT INTO cmok_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","យើន​លាស​ឞ្រាស​យេឆូ ​ឞ្រោៈ​រ៝ៈ​វាស​វាង​ឞូនុយ្ស​អ៝ក់​លោស​ឞើស​នតុក​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​ជឹត​ប៝ន​កាពើនិម  តា​ឞ្រី​កាលីលេ ។ អាប់​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល ឞ្រាស​យេឆូ ​នតុម​នតី​ឞូ​តា​ញីស​រាបុន។ ");
INSERT INTO cmok_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ឞូ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់​តាង់​នាវ​ពាង់​នតី​អី​នៃ យ៝រ​លាស​នាវ​ងើយ​ពាង់​គែស​នាវ​ទើយ តីស​ឞាល់​ដាស​នាវ​ឞូ​អេងៗ​នតី។ ");
INSERT INTO cmok_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","គែស​ទូ​នារ​ឆាបាត់  តា​ញីស​រាបុន​នៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ឞ្រាស​អ្យើស​លាប់​តា​ឆាក់​ពាង់ ជាន​អ៝ន់​នតែរ​ទុត​ទាង់ៗ​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“អើ​ឞ្រាស​យេឆូ ​តាៈ​ឞើស​ប៝ន​នាឆារែត ! លើយ​មៃ​រាខ្វាក​ហេន មៃ​ហាន់​អុច​លើស​លើយ​ហេន​ឞើស? គ៝ប់​នាល់​មៃ​ងាន់ មៃ​អី​នៃ​អី​ឞូនុយ្ស​ក្ល៝ស​អ្វែស​តាៈ​ឞើស​កោរាញ​ឞ្រាស”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ឞ្រាស​យេឆូ ​ទែ​មឞ្រាម​ឞ្រាស​អ្យើស​អី​នៃ៖ “លើយ​ហោម​ងើយ គុ​អ្យាត់​ឆាក់​រាក្លាក់​ហ៝ៈ ទូ​លោស​ហ៝ម់​ឞើស​ឞូនុយ្ស​អី​នៃ!” ឞ្រាស​អ្យើស​លើស​ឞូ​ក្លោ​អី​នៃ​អ៝ន់​ពាង់​ចោត​តា​នាប់​ឞាល់​ផូង ជេសរី​លោស​ប្ហុច​ឞើស​ឞូនុយ្ស​អី​នៃ មោ​អោស​អ៝ន់​អោឞាល់​គែស​នាវ​ជី។ ");
INSERT INTO cmok_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ទឹង​លែៈ​ឞូនុយ្ស​ឆៃ​កើត​នៃ​នើស នទ្រ៝ត់​ហីស​រាហ៝ល់​ទាទេ​ងាន់ ជេសរី​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ “ហៃ! មើម​នាវ​ងើយ​ពាង់​អី​នៃ​ទឹង​តាម​ងាន់​ហ្យាស ទើយ​ដាៈ​ឞ្រាស​អ្យើស​លោស លោស​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ឞូ​លឺ​រាញា​ឆាក់​ឞ្រាស​យេឆូ ​លាម​នតុក​អាប់​ប៝ន​អី​នៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ជេស​ឞ្រាស​យេឆូ ​លោស​ឞើស​ញីស​រាបុន​នៃ ហាន់​ជឹត​ជៃ​ឆីមោន  តា​ជៃ​អី​នៃ​មេៈ​ព៝​ឆីមោន ​គែស​នាវ​ជី តា​ឆាក់​ពាង់​ទោស​ហោ​ងាន់ ឞូ​ទាន់​ឞ្រាស​យេឆូ ​ជាន​អ៝ន់​ឞាស​ព៝​ពាង់​អី​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​តា​ឞូនុយ្ស​ជី​អី​នៃ នហ៝​មា​មឞ្រាម​នាវ​ជី​អី​រី នាវ​ជី​ឞាស​នទាល​រ៝។ ជេសរី​ពាង់​ទ៝ក់​ដឺប​ជាន​ការ​នទ្រាប់​នទើ​ឆោង​ឆា​អ៝ន់​មា​ឞូ​នាច់​អី​គុ​តា​ជៃ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ត៝ត់​កេង​មាង់​ឞូនុយ្ស​តា​ប៝ន​អី​នៃ​ខាន់​ពាង់​លែវ​អ៝ស​នោ​អី​គែស​នាវ​ជី​អេងៗ​រាន​ម៝ប់​ឞ្រាស​យេឆូ ។ ពាង់​តេៈ​តី​កាលើ​ឆាក់​ផូង​ឞូនុយ្ស​ជី​អី​នៃ​អាប់​ខាន់​ពាង់ ជាន​ខាន់​ពាង់​ឞាស​ជី​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","គែស​ឞូនុយ្ស​អ៝ក់​ឞ្រាស​អ្យើស​លោស​ឞើស​ឆាក់​ខាន់​ពាង់ នហ៝​មា​នតែរ​លាស៖ “មៃ​ក៝ន​កោរាញ​ឞ្រាស!” យ៝រ​លាស​ខាន់​ពាង់​គឹត​ឞ្រាស​យេឆូ ​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់។ តីស​មា​ឞ្រាស​យេឆូ ​មឞ្រាម​មពោល​ឞ្រាស​អ្យើស​មោ​អ៝ន់​អោស​ងើយ។ ");
INSERT INTO cmok_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ត៝ត់​អើម​អោយ​អោយ​តៃ​រី ឞ្រាស​យេឆូ ​លោស​ឞើស​ប៝ន​អី​នៃ​ហាន់​ទូ​ហ្វេ​អេង​តា​នតុក​រាទាស​ងាយ​ដាស​ឞូនុយ្ស​គៃ​មា​មឞើស​ឆើម។ យើន​មា​គែស​ផូង​ប៝ន​លាន​តឹង​ជ៝យ​ពាង់​គ្រ៝ចៗ​ងាន់ ត៝ត់​ឆៃ​ឞ្រាស​យេឆូ ​ខាន់​ពាង់​ក៝ន់​គុ​នទ្រែល​មោ​អ៝ន់​អោស​ពាង់​ទូ​ឞើស​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “កោរាញ​ឞ្រាស​ដាៈ​គ៝ប់​មឞើស​នាវ​មហែ​មហាន​អ្វែស​ជេង​កោរាញ​ឞ្រាស​អុច​ម៝ត់​អ្វាញ់​ឞូនុយ្ស អ៝ន់​មា​ប៝ន​អេងៗ​ជឹត យ៝រ​នាវ​អ្យា​ទឹង​ពាង់​ដាៈ​គ៝ប់​ហាន់​តា​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ជេសរី​ឞ្រាស​យេឆូ ​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​អាប់​ញីស​រាបុន​ផូង​អីឆ្រាអែល ​រ៝ៈ​ឞ្រី​កាលីលេ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","គែស​ទូ​នារ​រី​ឞ្រាស​យេឆូ ​ទ៝ក់​តា​មែង​ទាក​ងលៅ​ក្វ៝ង់ រាញា​ងលៅ​អី​នៃ​កេនេឆារែត  មោ​លាស​រាញា​ងលៅ​កាលីលេ ។ នារ​នៃ​គែស​អ៝ក់​ឞូនុយ្ស​រាន​តា​ពាង់​តឹម​មពែត​ងាន់ គៃ​មា​អ្យាត់​ពាង់​នតី​នាវ​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ជេសរី​ពាង់​ឆៃ​ឞារ​មល៝ម់​ទូក​តា​មែង​កើស​រី អី​ឆាក់​ខាន់​ពាង់​នើម​លែៈ​ជុរ​រាវ​ជាល​អា​ទាក​ឆូ ខាន់​ពាង់​អី​នៃ​ជេង​ឞូនុយ្ស​ជាន​ការ​វាង់​កា​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ជេសរី​ឞ្រាស​យេឆូ ​ញច៝​ទូ​មល៝ម់​ទូក ឞូនុយ្ស​តើម​ទូក​អី​នៃ​រាញា​ពាង់​ឆីមោន ឞ្រាស​យេឆូ ​ដាៈ​ពាង់​វាស​ទូក​ងាយ​ឞើស​មែង​រី​ដេៈ។ ពាង់​គុ​រាគើប​តា​កាលើ​ទូក​នតី​ផូង​ប៝ន​លាន។ ");
INSERT INTO cmok_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","លោច​ជេស​ឞ្រាស​យេឆូ ​នតី​ផូង​ប៝ន​លាន ពាង់​លាស​មា​ឆីមោន ៖ “ហើយ​អ៝ស ល៝ង់​មៃ​វាស​ទូក​ហាន់​ជឹត​ទាក​ជ្រូ​រី ជេសរី​ឆែង​ជាល​មៃ​នៃ​អា​ទាក​ឆូ”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ឆីមោន ​ព្លឹ​អើស​មា​ពាង់​លាស៖ “អើយ​កោរាញ ឞើស​ឞោក​មាង់​ត៝ង់​អាង​ងាន់​ហេន​ឆែង​ជាល​មោ​អោស​គែស​កា យើន​មា​លាស​មៃ​ដាៈ​រី នទ្រី​គ៝ប់​ឆែង​អ្យាត់​នាវ​មៃ​ហើយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ជេសរី​ខាន់​ពាង់​ឆែង​ជាល ត៝ត់​មា​ឆែង​រី​គែស​កា​ទុត​អ៝ក់​ឞើយ​មា​ព្លុង​ជាល​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ឆៃ​អ៝ក់​គែស​កា​នៃ ខាន់​ពាង់​រាវេស​តី​ក្វាល់​អី​ឞាល់​តា​ទូក​អេង​ជឹត​ជាៈ​កើល។ ជេសរី​ខាន់​ពាង់​តេៈ​កា​ឞេង​លែៈ​ឞារ​មល៝ម់​ទូក គែស​អ៝ក់​កា​អី​រី​ឞើយ​ង៝ម់​ទូក។ ");
INSERT INTO cmok_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","ត៝ត់​ឆៃ​គែស​កា​អ៝ក់​អីរ​អារ​អី​នៃ ឞូនុយ្ស​អី​គុ​នទ្រែល​តា​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ទាទេ​ងាន់។ នោក​ឆីមោន ​អី​ឞូ​ក្វាល់​ពេត្រោស ​ដ៝ង់​ឆៃ​នាវ​ទើយ​កោរាញ​ឞ្រាស​គុ​តា​ឞ្រាស​យេឆូ ​រី ពាង់​ពាន់​មឞាស​តា​ជ៝ង់​ឞ្រាស​យេឆូ ​រី​រ៝ ជេសរី​លាស៖ “ហើយ​កោរាញ ទូ​ងាយ​ឞើស​គ៝ប់​អ្យា យ៝រ​លាស​គ៝ប់​ឞូនុយ្ស​គែស​នាវ​តីស”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","យើន​មា​ឞ្រាស​យេឆូ ​លាស​មា​ឆីមោន ៖ “ហើយ​អ៝ស មៃ​លើយ​ក្លាច​អោស នារ​ឞើស​កើយ​នើស​មៃ​ជ៝យ​គែស​កា នតើម​នារ​អ្យា​មៃ​ហាន់​ជ៝យ​គែស​ឞូនុយ្ស​អ្យាត់​នាវ​គ៝ប់ តឹម​ឞាន​មា​ឆែង​ឞូនុយ្ស”។ ឞូនុយ្ស​វាង់​កា​នទ្រែល​ឆីមោន  ទូ​ហ្វេ​រាញា​យាកើ  ទូ​ហ្វេ​រាញា​យោហាន  ឞារ​ហៃ​ខាន់​ពាង់​អី​នៃ​ក៝ន​ឆេបេដេ  ខាន់​ពាង់​វៃ​ជាន​ការ​នទ្រែល​ឆីមោន  ខាន់​ពាង់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ទាទេ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ជេសរី​ខាន់​ពាង់​វាស​ទូក​ជឹត​មែង​កើស ត៝ត់​ទូក​អា​មែង​កើស​តី ខាន់​ពាង់​នត្លើយ​នទ៝ស​នទើ​តា​រី​ទាទេ ងក្រែ​មា​លែវ​ឞាល់​ឞ្រោៈ​តឹង​ឞ្រាស​យេឆូ ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","គែស​ទូ​នារ​ឞ្រាស​យេឆូ ​គុ​តា​ទូ​ប៝ន តា​ប៝ន​អី​នៃ​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ផុង​ឆា​ឞេង​ឆាក់​ឞេង​ជាន់​ងាន់ ត៝ត់​ឆៃ​ឞ្រាស​យេឆូ  ពាង់​រាន​ពាន់​មឞាស​ឞើស​នាប់​ឞ្រាស​យេឆូ ​តា​នែស​រ៝ នហ៝​មា​ឞ៝ញ​ពាង់៖ “អើ​កោរាញ ទាន់​មៃ​យោៈ​នអាច​មា​គ៝ប់​អើ លាស​មៃ​អុច គ៝ប់​នាល់​មៃ​ទើយ​ជាន​ឆាក់​គ៝ប់​អ៝ន់​ក្ល៝ស​អ៝ន់​ឞាស​ជី”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","តឹង​នាវ​វៃ​ផូង​អីឆ្រាអែល ​ឞូ​មោ​អោស​ឞាញ់​គុ​ទាច់​មោ​អោស​ឞាញ់​ពាស​មា​ឞូនុយ្ស​ផុង​ឆា យើន​មា​ឞ្រាស​យេឆូ ​ពាស​តី​តា​ឆាក់​ពាង់​រី​ច្រាវ ជេសរី​លាស​មា​ឞូនុយ្ស​ផុង​ឆា​អី​នៃ៖ “អើ​គ៝ប់​អុច​ដ៝ង់ ឞាស​ហ៝ម់!” ជេសរី​ឞាស​នទាល​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ឞ្រាស​យេឆូ ​ឞ្វៃ​ពាង់​លាស៖ “លើយ​មៃ​ងក៝ច​នាវ​អ្យា​មា​ឞូ​អេង​គឹត​យឹ អ៝ន់​មៃ​ហាន់​ឞ្រ៝ង់​ញហើ​ឆាក់​មា​ឞូនុយ្ស​ជាន​ឞ្រាស​រី ជេសរី​ញហើរ​នទើ​តឹង​នាវ​វៃ​មោឆេ ​ដាៈ​មា​ឞូនុយ្ស​ឞាស​នាវ​ជី​ផុង​ឆា គៃ​មា​ឞូ​គឹត​នហេល​ឆាក់​មៃ​លែៈ​ក្ល៝ស​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","យើន​មា​ឞូ​លឺ​ឞ្រាស​យេឆូ ​លើ​មា​ហោ​លើ​មា​ហោ​ងាន់។ អ៝ក់​ឞូនុយ្ស​វាច់​រាន​អ្យាត់​នាវ​ពាង់​ងើយ នហ៝​មា​ដាៈ​ពាង់​ជាន​ឞាស​នាវ​ជី​អេងៗ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","យើន​មា​តឹង​នាវ​វៃ​ឞ្រាស​យេឆូ ពាង់​ហាន់​តា​នតុក​រាទាស​ងាយ​ដាស​ឞូនុយ្ស គៃ​មា​មឞើស​ឆើម​អេង។ ");
INSERT INTO cmok_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","គែស​ទូ​នារ​ជឹត​ទោល​ឞ្រាស​យេឆូ ​គុ​នតី​តា​ត្រោម​ញីស គែស​ផូង​ផារីឆី  នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  ខាន់​ពាង់​គុ​អ្យាត់​តា​នៃ​ដ៝ង់។ ផូង​អី​នៃ​តាៈ​ឞើស​អាប់​ប៝ន​ឞ្រី​កាលីលេ  អាប់​ប៝ន​ឞ្រី​យូដា  នទ្រែល​មា​ឞើស​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ។ ឞ្រាស​យេឆូ ​គែស​នាវ​ទើយ​កោរាញ​ឞ្រាស​គុ​នទ្រែល​ពាង់ គៃ​មា​ជាន​ឞាស​ឞូនុយ្ស​ជី។ ");
INSERT INTO cmok_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","នោក​នៃ​គែស​ឞូ​តូង​ទូ​ហ្វេ​ឞូ​ក្លោ​រាវែន​ជ៝ង់​រាវែន​តី​មា​ងក៝ៈ ខាន់​ពាង់​ជ៝យ​ត្រ៝ង​មា​លែវ​ឞូនុយ្ស​អី​នៃ​ហាន់​ទាច់​ឞ្រាស​យេឆូ ​គៃ​មា​តេៈ​ឞើស​នាប់​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","តីស​មា​ជ៝យ​ត្រ៝ង​មោ​គែស​អោស អ៝ក់​អីរ​ឞូនុយ្ស ជេសរី​ហាវ​រ៝ៈ​គូង​កាលើ​ច៝រ​ញីស​រី ច៝រ​ញីស​អី​នៃ​ល៝ង់ ខាន់​ពាង់​ព្លោក​ច៝រ​អី​នៃ ញជុរ​ឞូនុយ្ស​រាវែន​រី​នអ៝ប់​មា​ងក៝ៈ​ពាង់​នើម​តា​ងក្លាង​ឞូ​ឞាល់ ព្លាង់​ឞើស​នាប់​ឞ្រាស​យេឆូ ​រី​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ឞ្រាស​យេឆូ ​ឆៃ​ខាន់​ពាង់​គែស​នាវ​ញឆីង​ពាង់​ទើយ​ជាន​ឞាស​នាវ​ជី​កើត​នៃ ពាង់​លាស​មា​ឞូនុយ្ស​រាវែន​អី​នៃ៖ “ហើយ​អ៝ស គ៝ប់​លែៈ​យោៈ​មៃ មោ​ហោម​អោស​កើប​នាវ​តីស​តា​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ត៝ត់​តាង់​នាវ​នៃ ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​ផារីឆី  លាស​អេង​តា​នូយ្ស​នហ៝ម់៖ “ឞូ​ម៝ស​ពាង់​អី​នៃ​ហៃ? ទឹង​ឞាញ់​ងើយ​មឺច​រាម៝ត​កោរាញ​ឞ្រាស​កើត​នទ្រី! គែស​ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ទើម​ទើយ​យោៈ​នាវ​តីស​ឞូនុយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ឞ្រាស​យេឆូ ​គឹត​នាវ​ខាន់​ពាង់​មឹន​តា​នូយ្ស​នហ៝ម់ ជេសរី​ពាង់​អោប៖ “មើម​ទឹង​ខាន់​មៃ​គែស​នាវ​មឹន​កើត​នអៃ? ");
INSERT INTO cmok_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","អ៝ន់​ខាន់​មៃ​គឹត​នាវ​អ្យា លាស​គ៝ប់​លាស​មា​ឞូនុយ្ស​រាវែន​អី​នៃ «នាវ​តីស​មៃ​លែៈ​គ៝ប់​យោៈ​ហើយ» មោ​លាស «មៃ​ទ៝ក់​ឞ្រោៈ​ហ៝ម់» លាស​នទ្រី​ម៝ស​នាវ​លាស​អី​ទើស​រាលាវ​ហាៈ? លែៈ​ឞារ​នាវ​អី​នៃ​ឞូនុយ្ស​ទើម​មោ​ទើយ​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","គ៝ប់​អុច​អ៝ន់​ខាន់​មៃ​គឹត​ឆៃ គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស នទ្រី​ទឹង​គ៝ប់​ទើយ​យោៈ​នាវ​តីស​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា”។ ជេសរី​ឞ្រាស​យេឆូ ​អ្វាញ់​ជឹត​ឞូនុយ្ស​រាវែន​អី​នៃ​លាស៖ “មៃ​ទ៝ក់​ហ៝ម់ ញអោត​ងក៝ៈ​មៃ​នៃ​ឆឹត​អា​ជៃ​មៃ​នើម​រី”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ជេសរី​ទោ​មា​ឆៃ​ឞូនុយ្ស​រាវែន​អី​នៃ​ទ៝ក់​ដឺប​តា​នាប់​ឞូ​ឞាល់ ពាង់​ញអោត​ងក៝ៈ​អី​ឞូ​តូង​ពាង់​នើស​ឆឹត​ជឹត​ជៃ នហ៝​មា​រានេ​មា​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","លែៈ​ឞូនុយ្ស​អី​គុ​តា​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ទាទេ រានេ​កោរាញ​ឞ្រាស។ ខាន់​ពាង់​ក្លាច​ហោ​ងាន់ នហ៝​មា​លាស៖ “លែៈ​នាវ​ងាន់​នទើ​ឞ៝ន់​ឆៃ​នារ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​ប៝ន​អី​នៃ​ហាន់​រ៝ៈ​ត្រ៝ង​ឆៃ​ទូ​ហ្វេ​ឞូ​ក្លោ​គុ​ក៝ប់​ឆ៝ៈ​ព្រាក់​ឞើស​ឞូ​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ រាញា​ពាង់​អី​នៃ​លេវី  ពាង់​គុ​តា​នតុក​ពាង់​វៃ​ឆ៝ៈ​ព្រាក់។ ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ហើយ​នោ ហោៈ​ឞ្រោៈ​តឹង​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ពាង់​នត្លើយ​លែៈ​ផ្យៅ​នទ៝ស​នទើ​តា​រី ជេសរី​តឹង​ឞ្រាស​យេឆូ ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ជេសរី​ពាង់​ជាៈ​ឞ្រាស​យេឆូ ​ហាន់​តា​ជៃ​ពាង់​នើម ពាង់​នទ្រាប់​នាវ​ញេត​ឆា​តេស​អ៝ន់​មា​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ឞ្រាស​យេឆូ ។ គែស​អ៝ក់​ឞូនុយ្ស​ហាន់​លាប់​ឆោង​ឆា​នទ្រែល​តា​រី​ដ៝ង់ តា​នៃ​គែស​ឞូនុយ្ស​ក៝ប់​ឆ៝ៈ​ព្រាក់​ឞើស​ឞូ​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ នទ្រែល​មា​ឞូនុយ្ស​អាបាៈ​អេង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ត៝ត់​ឆៃ​កើត​នៃ ផូង​ផារីឆី  នទ្រែល​មា​ផូង​នើម​នតី​អី​តឹង​ផូង​ផារីឆី ​អី​នៃ ជី​នូយ្ស​ក៝ៈ​នូយ្ស​ក៝ៈ​នហ៝ម់​ងាន់ ខាន់​ពាង់​លាស​មពោល​អ៝ស​ម៝ន​ឞ្រាស​យេឆូ ៖ “ម៝ស​ខាន់​មៃ​ឆោង​នទ្រែល​ឞូនុយ្ស​ឆ៝ៈ​ព្រាក់​ឞូ ញេត​នទ្រែល​ឞូនុយ្ស​តីស?” ");
INSERT INTO cmok_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ឞូនុយ្ស​អ្វែស​ឆាក់​លាង់​ជាន់​មោ​អុច​អោស​មា​កោរាញ​ទាក​ឆី ឞូនុយ្ស​អី​គែស​នាវ​ជី​ទើម​អុច។ ");
INSERT INTO cmok_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","នទ្រី​ទឹង​គ៝ប់​វាច់​តា​អ្យា​មោ​អោស​គៃ​មា​ក្វាល់​ឞូនុយ្ស​ឆ៝ង់ អុច​ក្វាល់​ឞូនុយ្ស​តីស គៃ​មា​ពាង់​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស​អ៝ន់​អ្យាត់​តឹង​នាវ​កោរាញ​ឞ្រាស”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ជេសរី​ផូង​ផារីឆី  នទ្រែល​មា​ផូង​នើម​នតី​អី​តឹង​ផូង​ផារីឆី ​អី​នៃ​អោប​ឞ្រាស​យេឆូ ៖ “មពោល​អ៝ស​ម៝ន​យោហាន-​បាប់តែម  អ៝ត់​ឆោង​ឆា មឞើស​ឆើម​បាបើ កើត​មពោល​អ៝ស​ម៝ន​ផារីឆី ​ដ៝ង់។ មើម​ទឹង​មពោល​អ៝ស​ម៝ន​មៃ​គុ​ញេត​គុ​ឆោង​កើត​នអៃ​ច្រាវ?” ");
INSERT INTO cmok_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ឞ្រាស​យេឆូ ​អើស៖ “លាស​តឹម​នអាប់​អូរ​ឆាយ ខាន់​មៃ​វៃ​ឞ្វៃ​ឞូ​នាច់​មោ​អ៝ន់​ឆោង​ឆា​ដ៝ង់​ឞើស? ឞូ​មោ​វៃ​អោស​ឞ្វៃ​នទ្រី។ ");
INSERT INTO cmok_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","គ៝ប់​តឹម​ឞាន​មា​ឞូ​ក្លោ​នអាប់​អូរ​ឆាយ ត៝ត់​ទី​នារ​រី​តៃ​ឞូ​តឹម​ងខាស​គ៝ប់​ដាស​មពោល​អ៝ស​ម៝ន​គ៝ប់ រី​មើ​ខាន់​ពាង់​អ៝ត់​ឆោង​ឆា”។ ");
INSERT INTO cmok_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ជេសរី​ឞ្រាស​យេឆូ ​ងើយ​នាវ​នតឹត៖ “ឞូ​មោ​វៃ​អោស​ងខេក​អាវ​មហែ គៃ​មា​ជឹង​មឞោល​តា​អាវ​ឆាត លាស​ជាន​កើត​នៃ​អាវ​មហែ​លែៈ​ជេង​ឆាត នទ្រែល​មា​ឞ៝ក​អី​ងខេក​ឞើស​អាវ​មហែ​មឞោល​តា​អាវ​អើម​ពាង់​មោ​ដ៝ង់​តឹម​ទី​ឞាល់។ ");
INSERT INTO cmok_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ឞូ​មោ​វៃ​អោស​តេៈ​ព្រាប់​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មហែ​តា​ទុង​នតោ​អើម លាស​ជាន​កើត​នៃ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មហែ​ជាន​អ៝ន់​ទុង​នតោ​អី​នៃ​ព្រែក នទ្រាញ់​ហុក ជេសរី​ទុង​នតោ​អី​នៃ​ជេង​ឆាត​ដ៝ង់ យ៝រ​លាស​ទុង​នតោ​អើម​មោ​ហោម​អោស​ត៝ច។ ");
INSERT INTO cmok_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","លាស​នទ្រី​ឞូ​តេៈ​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​មហែ​តា​ទុង​នតោ​មហែ រី​មើ​ទុង នទ្រែល​មា​នទ្រាញ់​ហោម​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","លាស​លែៈ​ជេស​ញេត​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​អើម ឞូ​មោ​ហោម​អោស​អុច​ញេត​អី​មហែ​ជឹត លាស​ញេត​ឞូ​លាស «អី​អើម​កាស​រាលាវ​អី​មហែ»”។ ");
INSERT INTO cmok_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","គែស​ទូ​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ផូង​អីឆ្រាអែល ឞ្រាស​យេឆូ ​នទ្រែល​អ៝ស​ម៝ន​ពាង់​ហាន់​គ្លាត់​រ៝ៈ​មីរ​ឞា​ព្រាង់  ទោល​ឞ្រោៈ​រ៝ៈ​មីរ​អី​នៃ​មពោល​អ៝ស​ម៝ន​ពាង់​រ៝យ្ស​ឞា​ត្រ៝​មា​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ជេសរី​គែស​ផូង​ផារីឆី ​អាបាៈ​ឆៃ​ជាន​កើត​នៃ លាស​ខាន់​ពាង់៖ “ម៝ស​កោៈ​ខាន់​មៃ​ជាន​ការ​តា​នារ​ឆាបាត់ ​នៃ​មេស? ឞ៝ល​លាស​ខាន់​មៃ​រ៝យ្ស​ដេៈៗ​កើត​នៃ ហោម​អែ​កើប​តីស​ដាស​នាវ​វៃ​មា​នារ​រាលូ​ផូង​ឞ៝ន់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ឞ្រាស​យេឆូ ​អោប​រាលឹ​ខាន់​ពាង់៖ “លាស​នទ្រី​ខាន់​មៃ​លែៈ​ច្វេល​បាស នាវ​ខាន់​មៃ​វៃ​រ៝ៈ​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ? នោក​ដាវីត ​អេ​ហ៝ៈ​ជេង​កាដាច់ ពាង់ នទ្រែល​មា​ឞូនុយ្ស​គុ​នទ្រែល​ពាង់​ជី​ង៝ត‌ ");
INSERT INTO cmok_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ជេសរី​ពាង់​លាប់​តា​ត្រោម​នតុក​ចូន​ឞ៝ក​កោរាញ​ឞ្រាស ឆ៝ៈ​ឆា​នុមពាង់​អី​ឞូ​តេៈ​ញហើរ​អ៝ន់​កោរាញ​ឞ្រាស​នៃ នហ៝​មា​ពាៈ​ឞូនុយ្ស​អី​គុ​នទ្រែល​ពាង់​នៃ​ឆា​ដ៝ង់។ ឞូ​មោ​ដ៝ង់​លាស​ពាង់​ឞ៝ល​លាស​តឹង​មា​នាវ​វៃ​គែស​មពោល​ជាន​ឞ្រាស​ទើម​ទើយ​ឆា​នុមពាង់​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ឞ្រាស​យេឆូ ​លាស​តៃ៖ “គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់ នទ្រី​ទឹង​គ៝ប់​ជេង​កោរាញ​មា​នារ​ឆាបាត់ ​អី​នារ​រាលូ​ម៝ស​នទើ​អី​ទើយ​អ៝ន់​ឞូ​ជាន មោ​លាស​មោ​ទើយ​អ៝ន់​ឞូ​ជាន​តា​នារ​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","គែស​ទូ​នារ​ឆាបាត់ ​អេង​ជឹត ឞ្រាស​យេឆូ ​លាប់​នតី​ឞូ​តា​ញីស​រាបុន​ផូង​អីឆ្រាអែល ។ តា​នតុក​នៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ឆ្យារ់​តី​ឞើស​មា។ ");
INSERT INTO cmok_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","គែស​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​ផារីឆី ​ក៝ប់​អ្វាញ់​ឞ្រាស​យេឆូ ។ ផូង​អី​នៃ​អុច​ជ៝យ​នាវ​មា​នតោន​ឞ្រាស​យេឆូ  ងខេប​លាស​ពាង់​ជាន​ឞាស​ឞូនុយ្ស​ជី​តា​នារ​ឆាបាត់  យ៝រ​លាស​ខាន់​ពាង់​នតី​តា​នាវ​វៃ​ផូង​អីឆ្រាអែល ​មោ​អ៝ន់​អោស​ជាន​ឞាស​ឞូនុយ្ស​ជី​តា​នារ​ឆាបាត់  នទ្រី​ទឹង​ខាន់​ពាង់​អ្វាញ់​ជឹត​ពាង់​លែរ​ងែរ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","យើន​លាស​ឞ្រាស​យេឆូ ​គឹត​នូយ្ស​នហ៝ម់​នាវ​មឹន​ខាន់​ពាង់ ជេសរី​ពាង់​លាស​មា​ឞូនុយ្ស​ឆ្យារ់​តី​នៃ៖ “ហើយ​អ៝ស មៃ​ទ៝ក់​ហាន់​តា​ងក្លាង​ឞូ​ត៝!” ឞូនុយ្ស​ឆ្យារ់​តី​អី​នៃ​ទ៝ក់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ជេសរី​ឞ្រាស​យេឆូ ​អោប​ខាន់​ពាង់៖ “គ៝ប់​អោប​ខាន់​មៃ តឹង​នាវ​វៃ​ផូង​ឞ៝ន់​តា​នារ​ឆាបាត់ ​ឞូនុយ្ស​ទើយ​ជាន​នទើ​អ្វែស​មោ​លាស​នទើ​អ្យើស? ទើយ​រាក្លាយ្ស​នាវ​រេស​ឞូនុយ្ស​មោ​លាស​ងខឹត​ពាង់?” ");
INSERT INTO cmok_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ឞ្រាស​យេឆូ ​អ្វាញ់​ជឹត​ទឹង​លែៈ​ឞូនុយ្ស​អី​គុ​តា​នៃ យើន​មា​មោ​គែស​អោស​ទូ​ហ្វេ​អើស ជេសរី​លាស​មា​ឞូនុយ្ស​រាវែន​តី​នៃ៖ “ល៝ង់​មៃ​រ៝ក​តី​មៃ​នៃ​ហ៝ម់”។ ជេសរី​ពាង់​រ៝ក តី​ពាង់​ឞាស​កើត​អើម​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ផូង​អី​អុច​ជ៝យ​នាវ​មា​នតោន​ឞ្រាស​យេឆូ ​នៃ​ជី​នូយ្ស​ទុត​ហោ ជេសរី​តឹម​ញច្រាៈ​ឞាល់​គៃ​មា​លើស​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","នោក​នៃ​ឞ្រាស​យេឆូ ​ហាវ​កាលើ​យោក​គៃ​មា​មឞើស​ឆើម។ ពាង់​មឞើស​ឆើម​មា​កោរាញ​ឞ្រាស​តា​នតុក​នៃ​ទូ​នាង់​រាអាង។ ");
INSERT INTO cmok_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","កាស​អាង​អោយ​តៃ​ពាង់​ក្វាល់​រាគូម​មពោល​អី​វៃ​តឹង​ពាង់​វាច់​តា​រី ជេសរី​កើយ្ស ១២ នុយ្ស​ឞូ​ក្លោ អី​ពាង់​ក្វាល់​លាស​«កោរាញ​អ៝ស​ម៝ន»​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","តា​នៃ​គែស​រាញា​ឆីមោន  ជេសរី​ឞ្រាស​យេឆូ ​ក្វាល់​រាញា​មហែ​ពាង់ ពេត្រោស  នទ្រែល​មា​អី​អ៝ស​ពាង់​រាញា​អ៝ន់ទ្រេ  ជេសរី​ឞូនុយ្ស​អាបាៈ​អេង​ជឹត​រាញា​យាកើ  រាញា​យោហាន  រាញា​ផីលីប  រាញា​បារថោលោមេ ‌ ");
INSERT INTO cmok_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","រាញា​មាថាយ  រាញា​ថោមាស  រាញា​យាកើ ​អី​ក៝ន​អាល់ផាយ  រាញា​ឆីមោន ​អី​ឞូ​ក្វាល់​«គើយ្ស» ");
INSERT INTO cmok_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","រាញា​យូដាស ​អី​ក៝ន​យាកើ  នទ្រែល​មា​រាញា​យូដាស-​អីឆាការីយោត  ជេង​ឞូនុយ្ស​ញជុន​ឞ្រាស​យេឆូ ​អ៝ន់​មា​ផូង​រាលាង់​ពាង់​តា​នារ​ជឹត​នាប់​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​ជុរ​ឞើស​លើ​យោក​នៃ ហាន់​ត៝ត់​តា​នតុក​ល៝ង់​រី។ តា​នតុក​នៃ​គែស​អ៝ក់​មពោល​អ៝ស​ម៝ន​អ្យាត់​នាវ​ពាង់ នទ្រែល​មា​ផូង​ប៝ន​លាន​អ៝ក់​ងាន់ ខាន់​ពាង់​តាៈ​ឞើស​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  នទ្រែល​មា​ឞើស​ប៝ន​អេងៗ​តា​ឞ្រី​យូដា  ឞើស​ឞ្រី​រាគ៝ៈ​ទាក​វាច់​ទាក​វារ់​ទាច់​កេង​ប៝ន​ក្វ៝ង់​តីរុស ​ប៝ន​ក្វ៝ង់​ឆីដោន ។ ");
INSERT INTO cmok_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ខាន់​ពាង់​វាច់​គូម​តា​រី​អ៝ក់​ងាន់ គៃ​គុ​អ្យាត់​នាវ​ឞ្រាស​យេឆូ ​នតី នទ្រែល​មា​អ៝ន់​ពាង់​ជាន​ឞាស​នាវ​ជី​ក្វែត​ខាន់​ពាង់​នើម​ដ៝ង់។ ឞូនុយ្ស​អី​ឞ្រាស​អ្យើស​លើស កើត​លាស​ឞូនុយ្ស​ឞ្រុត​នទ្រាង់​វាច់​តា​រី ជេសរី​ឞាស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","លែៈ​ឞូនុយ្ស​តឹម​មពែត​ងាន់​រាន​ពាស​ឞ្រាស​យេឆូ  ជេសរី​ឞូ​ឞាស​ទាទេ យ៝រ​លាស​ពាង់​គែស​នាវ​ឞ្រាស​តា​ឆាក់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ជេសរី​ឞ្រាស​យេឆូ ​អ្វាញ់​ជឹត​មពោល​អ៝ស​ម៝ន​ពាង់ពាង់​លាស៖ “អ្វែស​មអាក​ងាន់​មា​ខាន់​អៃ​មៃ​ឞូនុយ្ស​ក្រ៝​អ៝​អាច‌ យ៝រ​លាស​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","អ្វែស​មអាក​ងាន់​មា​ខាន់​អៃ​មៃ​អាបៃ​អ្យា​គុ​តា​នាវ​ជី​ង៝ត‌ យ៝រ​លាស​ជឹត​នាប់​តៃ​ខាន់​អៃ​មៃ​ហើម​ងាន់។ អ្វែស​មអាក​ងាន់​មា​ខាន់​អៃ​មៃ​គុ​តា​នាវ​ញហ្យាង់​ញុម​អាបៃ​អ្យា‌ យ៝រ​លាស​ជឹត​នាប់​តៃ​ខាន់​អៃ​មៃ​គែស​នាវ​រាម់​មអាក។ ");
INSERT INTO cmok_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","អ្វែស​មអាក​ងាន់​មា​ខាន់​អៃ​មៃ លាស​គែស​ឞូ​រាងឹ​ឞូ​ឞ្យាញ់​មោ​រ៝ម​ខាន់​អៃ​មៃ មោ​លាស​រាក​ឆ្វាយ អាច​មា​ខាន់​អៃ​មៃ​អ្យាត់​តឹង​នាវ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","នោក​កាល់​អែ​នើស​តឹម​ឞាន​កើត​នៃ​ដ៝ង់ អូ​ចែ​មពោល​រាងឹ​ឞ្យាញ់​អី​នៃ​ជាន​អ្យើស​មា​មពោល​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស។ លាស​គែស​កើត​នទ្រី​រាម់​នត្លោៈ​ហ៝ម់ រាម់​មអាក​ហ៝ម់ យ៝រ​លាស​ជឹត​នាប់​តៃ​ខាន់​អៃ​មៃ​គែស​នាវ​ងខោម​ក្វ៝ង់​ងាន់​រ៝​តា​ប៝ន​អ្វែស​តា​កាលើ។ ");
INSERT INTO cmok_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","តីស​មា​រេស​រាញាល់​ងាន់​មា​ខាន់​អៃ​មៃ​អី​ឞូនុយ្ស​លែៈ​នទ្រ៝ង់​ក្វ៝ង់​អាបៃ​អ្យា‌ យ៝រ​លាស​ខាន់​អៃ​មៃ​អាបៃ​អ្យា​លែៈ​គែស​ជេស​នាវ​រាម់​មអាក។ ");
INSERT INTO cmok_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","រេស​រាញាល់​ងាន់​មា​ខាន់​អៃ​មៃ​អាបៃ​អ្យា​លែៈ​ហើម​ជេស‌ ខាន់​អៃ​មៃ​តៃ​គែស​នាវ​ជី​ង៝ត​ជី​ហីរ​រ៝។ រេស​រាញាល់​ងាន់​មា​ខាន់​អៃ​មៃ​អាបៃ​អ្យា​លែៈ​គែស​នាវ​រាម់​មអាក‌ ខាន់​អៃ​មៃ​តៃ​គែស​នាវ​ងក្ល៝ន់​រាង៝ត​រាវៃ ជេសរី​នាវ​ញហ្យាង់​ញុម​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","រេស​រាញាល់​ងាន់​មា​ខាន់​អៃ​មៃ​អី​គែស​អ៝ក់​ឞូនុយ្ស​រានេ យ៝រ​មា​អូ​ចែ​ខាន់​ពាង់​លែៈ​រានេ​មា​ឞូនុយ្ស​នតើយ្ស​ងក្លាៈ​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ជេសរី​ឞ្រាស​យេឆូ ​ងើយ​ជឹត៖ “ល៝ង់​ទឹង​លែៈ​ឞូនុយ្ស​អី​អ្យាត់​នាវ​គ៝ប់គ៝ប់​ដាៈ​ខាន់​អៃ​មៃ​រ៝ង់​មា​ឞូនុយ្ស​រាលាង់ ជេសរី​ជាន​អ្វែស​មា​ឞូនុយ្ស​ឞ្យាញ់​ដាស​ខាន់​អៃ​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","អ៝ន់​ខាន់​អៃ​មៃ​ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​គែស​ជេង​មា​ឞូនុយ្ស​រាក​ឆ្វាយ​ខាន់​អៃ​មៃ ជេសរី​មឞើស​ឆើម​ទាន់​កោរាញ​ឞ្រាស​ជាន​អ្វែស​មា​ឞូនុយ្ស​អី​ជាន​ជេរ​មា​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","លាស​ឞូ​តាប​តឹម​ឞ៝ម​ខាន់​អៃ​មៃ​ទូ​ទីង ជេសរី​រាលែ​អ៝ន់​ឞូ​តាប​តៃ​ទូ​ទីង​ជឹត។ លាស​ឞូ​ឆ៝ៈ​អាវ​ក្វ៝ង់​លើយ​អោស​ឞ្វៃ​មោ​អ៝ន់​ឞូ​ឆ៝ៈ​អាវ​ជេៈ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ម៝ស​នទើ​ឞូ​ទាន់​ខាន់​អៃ​មៃ អ៝ន់​នទើ​អី​នៃ​មា​ឞូ លាស​គែស​ឞូ​ឆ៝ៈ​នទ៝ស​នទើ​ខាន់​អៃ​មៃ​លើយ​ហោម​មព្លឹ​អោស។ ");
INSERT INTO cmok_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ម៝ស​នាវ​អុច​អ៝ន់​ឞូ​ជាន​មា​ខាន់​អៃ​មៃ អ៝ន់​ខាន់​អៃ​មៃ​ជាន​មា​ឞូ​ល៝រ។ ");
INSERT INTO cmok_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","លាស​ខាន់​អៃ​មៃ​រ៝ង់​ទើម​មា​ឞូនុយ្ស​រ៝ង់​ខាន់​អៃ​មៃ​ល៝រ កោរាញ​ឞ្រាស​មោ​អោស​រានេ​ខាន់​អៃ​មៃ យ៝រ​លាស​ឞូនុយ្ស​តីស​ឞ្លាវ​តឹម​រ៝ង់​នទ្រាង់​ឞូនុយ្ស​តីស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","លាស​ខាន់​អៃ​មៃ​ជាន​អ្វែស​ទើម​មា​ឞូនុយ្ស​ជាន​អ្វែស​ដាស​ខាន់​អៃ​មៃ កោរាញ​ឞ្រាស​មោ​អោស​រានេ​ខាន់​អៃ​មៃ យ៝រ​លាស​ឞូនុយ្ស​តីស​ឞ្លាវ​ជាន​អ្វែស​នទ្រាង់​ឞូនុយ្ស​តីស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","លាស​ខាន់​អៃ​មៃ​អ៝ន់​ឞូ​មាញ​ទ្រាប់ មោ​លាស​ព្រាក់​មា​ឞូនុយ្ស​អី​ទើយ​នត្រ៝ៈ​ទើម កោរាញ​ឞ្រាស​មោ​អោស​រានេ​ខាន់​អៃ​មៃ យ៝រ​លាស​ឞូនុយ្ស​តីស​តឹម​អ៝ន់​មាញ​ហោម​តឹម​ត្រ៝ៈ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","កើត​នទ្រី​គ៝ប់​អុច​អ៝ន់​ខាន់​អៃ​មៃ​ជាន​តីស​ឞាល់​ដាស​ខាន់​ពាង់។ អ៝ន់​ខាន់​អៃ​មៃ​រ៝ង់​មា​ឞូនុយ្ស​រាលាង់ ជាន​អ្វែស​មា​ពាង់ នទ្រែល​មា​អ៝ន់​ពាង់​មាញ​ទ្រាប់​នទើ ជេសរី​លើយ​ហោម​អោស​ងកាស​តោរ​មា​ទ្រាប់​នទើ​អី​នៃ។ លាស​ជាន​នទ្រី​ខាន់​អៃ​មៃ​តៃ​គែស​នាវ​ងខោម​ក្វ៝ង់ នហ៝​មា​ជេង​ក៝ន​កោរាញ​ឞ្រាស​នើម​អី​ឞ្រាស​ទុត​ក្វ៝ង់ យ៝រ​លាស​កោរាញ​ឞ្រាស​ជាន​អ្វែស​ដ៝ង់​មា​ឞូនុយ្ស​មោ​គឹត​តោរ​មា​ពាង់ នទ្រែល​មា​ឞូនុយ្ស​អ្យើស។ ");
INSERT INTO cmok_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","លាស​នទ្រី​អ៝ន់​ខាន់​អៃ​មៃ​គែស​នាវ​យោៈ​នអាច តឹម​ឞាន​មា​កោរាញ​ឞ្រាស​ឞឹ​ខាន់​អៃ​មៃ​តា​កាលើ​ត្រោក​ពាង់​គែស​នាវ​យោៈ​នអាច​មា​ខាន់​អៃ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ជេសរី​លើយ​អោស​អ្វាញ់​នាវ​តីស​ឞូ គៃ​មា​លើយ​អ៝ន់​កោរាញ​ឞ្រាស​អ្វាញ់​នាវ​តីស​ខាន់​អៃ​មៃ។ លើយ​ផាត​ទោយ្ស​ឞូ គៃ​មា​លើយ​អ៝ន់​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​ខាន់​អៃ​មៃ។ អ៝ន់​ខាន់​អៃ​មៃ​យោៈ​នអាច​នាវ​តីស​ឞូ នទ្រី​ទឹង​កោរាញ​ឞ្រាស​យោៈ​នអាច​នាវ​តីស​ខាន់​អៃ​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","អ៝ន់​នទើ​មា​ឞូ ជេសរី​កោរាញ​ឞ្រាស​អ៝ន់​នទើ​មា​ខាន់​អៃ​មៃ ពាង់​ឆ៝ល់​ញឆ្រោស ជេសរី​តេៈ​ឞេង​រាមែស​មា​ខាន់​អៃ​មៃ​ដ៝ង់ យ៝រ​លាស​ទាស​អ៝ក់​ខាន់​អៃ​មៃ​អ៝ន់​មា​ឞូ កោរាញ​ឞ្រាស​អ៝ន់​កើត​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ឞ្រាស​យេឆូ ​ងើយ​នាវ​នតឹត​ទូ​នាវ​អេង​ជឹត​មា​ខាន់​ពាង់​ដ៝ង់៖ “លាស​គែស​ឞារ​ហៃ​ឞូនុយ្ស​ចែស​មាត់​តឹម​តេក​នទ្រាង់​ខាន់​ពាង់​នើម ឞ្លាវ​ដ៝ង់​លាស​មោ? ពាង់​តុប​តា​ត្រោម​នតូ​លែៈ​ឞារ​ហៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","មោ​គែស​អោស​ផូង​នតី​គឹត​រាលាវ​មា​នើម​នតី យើន​មា​លាស​ពាង់​នតី​លែៈ​អាប់​ផ្យៅ ពាង់​ជេង​តឹម​ឞាន​មា​នើម​ឆើម​នតី​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","នាវ​តីស​ឞ៝ន់​ជេង​តឹម​ឞាន​មា​នទើ​តា​ត្រោម​មាត់ មើម​ខាន់​អៃ​មៃ​អ្វាញ់​ឆៃ​នទ្រុយ្ស​តា​ត្រោម​មាត់​អ៝ស​នោ​ខាន់​អៃ​មៃ​ទើម តីស​មា​អ្វាញ់​មោ​ឆៃ​ម៝ង់​រាលាត​តា​ត្រោម​មាត់​ខាន់​អៃ​មៃ​នើម? ");
INSERT INTO cmok_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","លាស​មោ​ទើយ​ឆៃ​ម៝ង់​រាលាត​តា​ត្រោម​មាត់​ខាន់​អៃ​មៃ​នើម មើម​ទើយ​លាស​មា​អ៝ស​នោ៖ «អ៝ន់​គ៝ប់​ងខែៈ​នទ្រុយ្ស​នៃ»? អើ​ឞូនុយ្ស​មរោស! អ៝ន់​ឆ៝ៈ​រាលាត​តា​ត្រោម​មាត់​ខាន់​អៃ​មៃ​នើម​នៃ​ល៝រ​ប៝ត់ រី​មើ​ឆៃ​នហេល​នទ្រុយ្ស​តា​ត្រោម​មាត់​អ៝ស​នោ ទឹង​ឞ្លាវ​ងខែៈ​នទ្រុយ្ស​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“មោ​ព្រ៝ត​អោស​គែស​តើម​ឆី អី​តើម​អ្វែស អី​ព្លៃ​មោ​អ្វែស មោ​លាស​អី​តើម​មោ​អ្វែស អី​ព្លៃ​អ្វែស។ ");
INSERT INTO cmok_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ឞូ​ទើយ​គឹត​នាល់​តើម​ឆី​យ៝រ​មា​ព្លៃ​ពាង់។ ឞូ​មោ​ព្រ៝ត​ពែៈ​ព្លៃ​ងលែ​ឞើស​តើម​រាឆ៝ប់ ព្លៃ​យុងយារ​ប៝ន​ឞើស​តើម​នាម។ ");
INSERT INTO cmok_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ឞូនុយ្ស​កើត​នទ្រី​ដ៝ង់ ឞូនុយ្ស​អ្វែស​ពាង់​ជាន​ម៝ស​នតីល​នទើ​អ្វែស យ៝រ​លាស​តា​នូយ្ស​នហ៝ម់​ឆាក់​ជាន់​ពាង់​នើស​អ្វែស តីស​លាស​ឞូនុយ្ស​អ្យើស ពាង់​ជាន​នតីល​នទើ​អ្យើស យ៝រ​លាស​តា​នូយ្ស​នហ៝ម់​ឆាក់​ជាន់​ពាង់​នើស​អ្យើស នទ្រី​ទឹង​លែៈ​នតីល​ឞ៝រ់​មឞូង​ឞូនុយ្ស​ងើយ នទ្រែល​មា​នទើ​ពាង់​ជាន លោស​តាៈ​ឞើស​នូយ្ស​នហ៝ម់​ឆាក់​ជាន់​ពាង់​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“មើម​ខាន់​អៃ​មៃ​ក្វាល់​គ៝ប់ «អើ​កោរាញ! អើ​កោរាញ!» តីស​មា​មោ​ជាន​តឹង​នាវ​គ៝ប់​ដាៈ? ");
INSERT INTO cmok_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","គ៝ប់​មឞើស​អ៝ន់​ខាន់​អៃ​មៃ៖ ឞូនុយ្ស​អី​ឞ្រោៈ​អ្យាត់​នាវ​គ៝ប់​ងើយ ជេសរី​ជាន​តឹង​នាវ​គ៝ប់​លាស ឞូនុយ្ស​អី​នៃ​មើម​ជេង​តឹម​ឞាន​មា​ពាង់? ");
INSERT INTO cmok_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ឞូនុយ្ស​អី​នៃ​ជេង​តឹម​ឞាន​មា​ឞូនុយ្ស​ជាន​ជៃ។ ពាង់​កុយ្ស​នតូ​ជ្រូ ជេសរី​ពាង់​តាម់​មែស​តា​ត្រោម​នតូ​នៃ លាស​គែស​ទាក​ក្វ៝ង់​ហ៝ច​ថាង់​រ៝ៈ​ជៃ​អី​នៃ​ក៝ៈ​មោ​ទើយ​រាងោញ​ដ៝ង់ យ៝រ​លាស​លែៈ​ជាន​ទុត​ន៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ឞូនុយ្ស​អី​តាង់​នាវ​គ៝ប់ ជេសរី​មោ​ជាន​តឹង​នាវ​គ៝ប់​លាស ឞូនុយ្ស​អី​នៃ​ជេង​តឹម​ឞាន​មា​ឞូនុយ្ស​ជាន​ជៃ​ងគ៝ន់​ទើម​តា​កាលើ​នែស។ លាស​ត៝ត់​គែស​ទាក​ក្វ៝ង់​ហ៝ច​ថាង់​រ៝ៈ​នៃ ជៃ​អី​នៃ​រាល៝ម់ នហ៝​មា​អ្យើស​លែៈ​ផ្យៅ​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ជេស​ឞ្រាស​យេឆូ ​ងើយ​នាវ​អី​នៃ​អ៝ន់​មា​ផូង​ប៝ន​លាន ជេសរី​ពាង់​ហាន់​លាប់​តា​ប៝ន​កាពើនិម ​ឞ្រី​កាលីលេ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","តា​ប៝ន​នៃ​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ជី​ហោ​ងាន់​ឞើយ​មា​ខឹត ឞូនុយ្ស​អី​នៃ​ជេង​ទឹក​ទូ​ហ្វេ​កោរាញ​តាហែន​រោម  កោរាញ​រ៝ង់​ងាន់​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ត៝ត់​កោរាញ​តាហែន​អី​នៃ​តាង់​លឺ​ឞូ​ងក៝ច​ឞ្រាស​យេឆូ  ជេសរី​ពាង់​ដាៈ​មពោល​កោរាញ​អីឆ្រាអែល ​អាបាៈ​ហាន់​ជាៈ​ឞ្រាស​យេឆូ  គៃ​មា​ហាន់​ជាន​ឞាស​ទឹក​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ជេសរី​មពោល​កោរាញ​អី​នៃ​ហាន់​ម៝ប់​ឞ្រាស​យេឆូ  ត៝ត់​តា​ឞ្រាស​យេឆូ ​រី​ខាន់​ពាង់​ឞ៝ញ​ពាង់​ហាន់​នទ្រែល​ខាន់​ពាង់៖ “អើយ​កោរាញមៃ​យោៈ​មា​កោរាញ​តាហែន​រោម ​អី​នៃ​ទី​មេៈ‌ ");
INSERT INTO cmok_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","យ៝រ​លាស​ពាង់​រ៝ង់​មា​ប៝ន​លាន​ឞ៝ន់ ជេសរី​ពាង់​ឆើម​អ៝ន់​ព្រាក់​មា​ជាន​ទូ​មល៝ម់​ញីស​រាបុន​ជឹត​អ៝ន់​ឞ៝ន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​នទ្រែល​មពោល​កោរាញ​អី​នៃ។ ត៝ត់​ឞើយ​ត្រុយ្ស​អា​ជៃ​រី កោរាញ​តាហែន​អី​នៃ​ដាៈ​មឹត​ជាង់​ពាង់​ហាន់​ច្វាៈ​មឞើស​ឞ្រាស​យេឆូ ​អា​ត្រ៝ង​រី៖ “អើ​កោរាញ! មោ​ខាច់​អោស​ជាៈ​លែវ​មៃ​លាប់​តា​ជៃ​គ៝ប់ យ៝រ​លាស​គ៝ប់​មោ​ទី​ផូង​អីឆ្រាអែល  នទ្រី​ទឹង​មោ​លាង់​ទី​លាស​គ៝ប់​ជាៈ​មៃ​លាប់​តា​ជៃ​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","នទ្រី​ទឹង​គ៝ប់​នើម​មោ​ឞាញ់​ហាន់​ម៝ប់​មៃ​ដ៝ង់។ ទាន់​មៃ​លាស​ទូ​ត៝ង​ឞើស​នៃ ទឹក​គ៝ប់​ឞាស​ជី​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","គ៝ប់​គុ​តា​ន៝ម់​ឞូ យើន​លាស​គែស​ក៝ន​តាហែន​អ៝ក់​គុ​តា​ន៝ម់​គ៝ប់​ដ៝ង់។ លាស​គ៝ប់​ដាៈ​ទូ​ហ្វេ​ហាន់ ពាង់​ហាន់​រ៝ លាស​ដាៈ​ឞូនុយ្ស​អា​អេង​វាច់ ពាង់​វាច់​រ៝។ លាស​គ៝ប់​ដាៈ​ទឹក​គ៝ប់​ជាន​ទូ​នតីល​នទើ ពាង់​ជាន​រ៝។ លាស​នទ្រី គ៝ប់​គឹត​លាស​មៃ​ងើយ​គែស​នាវ​ទើយ​កើត​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ត៝ត់​ឞ្រាស​យេឆូ ​តាង់​នាវ​កោរាញ​តាហែន​អី​នៃ តា​នូយ្ស​នហ៝ម់​ពាង់​នទ្រ៝ត់​ញហីស​ងាន់។ ជេសរី​ពាង់​រាលែ​ជឹត​ឞូនុយ្ស​អី​ឞ្រោៈ​នទ្រែល​ពាង់ ងក្រែ​មា​លាស៖ “គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ ឞ៝ល​លាស​តា​ផូង​អីឆ្រាអែល ​អី​កើប​អេង​ឆាក់​ខាន់​ពាង់​នើម​លាស​លែៈ​គឹត​នាល់​កោរាញ​ឞ្រាស អេ​ហ៝ៈ​គែស​នាវ​ញឆីង​កើត​ពាង់​អី​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ជេសរី​មឹត​ជាង់​អី​កោរាញ​តាហែន​ដាៈ​ហាន់​នៃ​នើស ខាន់​ពាង់​ព្លឹ​ឆឹត​ជឹត​កើយ ត៝ត់​អា​ជៃ​ឆៃ​ទឹក​ពាង់​អី​នៃ​លែៈ​ឞាស​ជី។ ");
INSERT INTO cmok_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​ជឹត​តា​ទូ​ប៝ន រាញា​ប៝ន​អី​នៃ​នាអីន ។ គែស​អ៝ក់​ឞូនុយ្ស​ហាន់​នទ្រែល​ពាង់ មពោល​អ៝ស​ម៝ន​ពាង់​នើម នទ្រែល​មា​ឞូនុយ្ស​អាបាៈ​អេង​អ៝ក់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","នោក​ខាន់​ពាង់​ឞើយ​មា​ត៝ត់​តា​មែង​មពោង​មពេរ​ប៝ន​អី​នៃ ឆៃ​គែស​ឞូនុយ្ស​ឞ្រោៈ​នហ៝ច​ត៝ប់​ខឹត។ ឞូនុយ្ស​អី​ខឹត​នៃ​ក៝ន​ឞូ​ក្លោ ទើន​គែស​ទូ​ហ្វេ​ក៝ន​ឞូ​ក្លោ​អី​នៃ​ទើម អី​មេៈ​រី​នទ្រោ​ខឹត​ឆាយ​ជឹត។ ជេសរី​គែស​អ៝ក់​ឞូនុយ្ស​តា​ប៝ន​អី​នៃ​ឞ្រោៈ​នទ្រែល​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ត៝ត់​ឞ្រាស​យេឆូ ​ឆៃ​ឞូ​អូរ​នទ្រោ​ខឹត​ឆាយ​អី​នៃ ពាង់​យោៈ​នអាច​ហោ​ងាន់។ ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “លើយ​ហោម​ញុម”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ជេស​រី​ឞ្រាស​យេឆូ ​ហាន់​ទាច់​ពាស​តា​ម៝ង់​រានូង​នៃ មពោល​អី​តូង​រី​ញឆ្រុង​ដ៝ង់ ពាង់​លាស​មា​ឞូនុយ្ស​អី​ខឹត​នៃ៖ “ហើយ​អ៝ស គ៝ប់​មឞើស​មា​មៃ​ទ៝ក់​ហ៝ម់!” ");
INSERT INTO cmok_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ជេសរី​ឞូនុយ្ស​ខឹត​អី​នៃ​ទ៝ក់​ដើប​គុ​តា​រី​រ៝ ឞ្លាវ​មឞើស​ងើយ​ប្ហ៝ៈ។ ជេសរី​ឞ្រាស​យេឆូ ​ញជុន​ឞូ​ក្លោ​នទាម់​អី​នៃ​អា​មេៈ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","លែៈ​ឞូនុយ្ស​អី​គុ​តា​នៃ​ក្លាច​ទាទេ​ងាន់ ខាន់​ពាង់​រានេ​មា​កោរាញ​ឞ្រាស៖ “លែៈ​គែស​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ទុត​ក្វ៝ង់​លែៈ​វាច់​គុ​នទ្រែល​ឞ៝ន់ ពាង់​វាច់​តឹម​ឞាន​មា​កោរាញ​ឞ្រាស​វាច់​កើល​ផូង​ប៝ន​លាន​ពាង់​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ខាន់​ពាង់​មឞើស​ងក៝ច​ឞ្រាស​យេឆូ ​នៃ​លាម​ឞ្រី​យូដា  នទ្រែល​មា​លាម​ឞ្រី​ច្យៅ​មែង​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","មពោល​អ៝ស​ម៝ន​យោហាន-​បាប់តែម ​ឆៃ​ទឹង​លែៈ​នៃ ជេសរី​ហាន់​មឞើស​ទឹង​លែៈ​នាវ​អី​នៃ​អ៝ន់​យោហាន-​បាប់តែម ​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ជេសរី​យោហាន-​បាប់តែម ​ដាៈ​ឞារ​ហៃ​មពោល​អ៝ស​ម៝ន​ពាង់​ហាន់​ម៝ប់​ឞ្រាស​យេឆូ ​អោប​ពាង់​កើត​នអា៖ “នោក​កាល់​អែ​នើស​កោរាញ​ឞ្រាស​លែៈ​ត៝ន​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​លាស គែស​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​លែៈ​កោរាញ​ឞ្រាស​ទែ​កើយ្ស​ជុរ​វាច់​តាៈ​ឞើស​កាលើ​ត្រោក​នតុក​កោរាញ​ឞ្រាស​នើម។ មៃ​អ្យា​ឞ្រាស​ក្រីស ​អី​នៃ​ឞើស មោ​លាស​អ៝ន់​ហេន​ហោម​ក៝ប់​ទូ​ហ្វេ​អេង​ជឹត?” ");
INSERT INTO cmok_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ជេសរី​ឞារ​ហៃ​ខាន់​ពាង់​អី​នៃ​ហាន់​ត៝ត់​តា​ឞ្រាស​យេឆូ  អោប​ពាង់៖ “ហើយ​កោរាញ ហេន​អ្យា​យោហាន-​បាប់តែម ​ដាៈ​ហាន់​អោប​មៃ គឹត​មៃ​អ្យា​ងាន់​ឞ្រាស​ក្រីស ​អី​កោរាញ​ឞ្រាស​លែៈ​ត៝ន​ជុរ​វាច់ មោ​លាស​អ៝ន់​ហេន​ហោម​ក៝ប់​ទូ​ហ្វេ​អេង​ជឹត?” ");
INSERT INTO cmok_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","នោក​នៃ​អ៝ក់​ឞូនុយ្ស​ឞ្រាស​យេឆូ ​លែៈ​ជាន​អ៝ន់​ឞាស​ជី ឞូនុយ្ស​គែស​នាវ​ជី​អេងៗ ឞូនុយ្ស​ឞ្រាស​អ្យើស​លើស ជេសរី​អ៝ក់​ឞូនុយ្ស​ចែស​មាត់​ពាង់​ជាន​អ៝ន់​ឆៃ​អាង​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​យោហាន-​បាប់តែម ​អី​នៃ៖ “ខាន់​មៃ​មឞើស​ងក៝ច​មា​ពាង់​រី ទឹង​លែៈ​នទើ​ខាន់​មៃ​លែៈ​តាង់ លែៈ​ឆៃ​គ៝ប់​ជាន។ ឞូនុយ្ស​ចែស​មាត់​អ្វាញ់​ឆៃ ឞូនុយ្ស​តឹក​តោរ​អ្យាត់​តាង់ ឞូនុយ្ស​ក្វែត​រាវែន​ឞ្លាវ​ឞ្រោៈ ឞូនុយ្ស​ផុង​ឆា​ឞាស​ក្ល៝ស ឞូនុយ្ស​ខឹត​ទ៝ក់​រេស ជេសរី​ឞូនុយ្ស​អ៝​អាច​តាង់​នាវ​មហែ​មហាន​អ្វែស។ ");
INSERT INTO cmok_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","អ្វែស​មអាក​ងាន់​មា​ឞូនុយ្ស​មោ​មអារ់​នាវ​ពាង់​ញឆីង​មា​គ៝ប់ យ៝រ​មា​នទើ​គ៝ប់​ជាន​តីស​ដាស​នាវ​មឹន​ពាង់​អុច!” ");
INSERT INTO cmok_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","នទុត​ខាន់​ពាង់​ព្លឹ​ឆឹត ឞ្រាស​យេឆូ ​នតើម​ងើយ​មា​យោហាន-​បាប់តែម ​អ៝ន់​មា​ផូង​ប៝ន​លាន៖ “ម៝ស​ឞូនុយ្ស​អ្វាញ់​ខាន់​អៃ​មៃ​ហាន់​តា​ឞ្រី​រាទាស? ហាន់​អ្វាញ់​ឞូនុយ្ស​អី​ងើយ​ទាស​មា​ឞូនុយ្ស​អេងៗ​អុច តឹម​ឞាន​មា​ជា​មពាត់​រាងោញ​ទាស​ឆ្យាល​មា​ខោម​ឞើស? ពាង់​មោ​ទី​អោស។ ");
INSERT INTO cmok_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ម៝ស​ឞូនុយ្ស​ខាន់​អៃ​មៃ​ហាន់​អ្វាញ់? អ្វាញ់​ឞូនុយ្ស​ញឆ៝ស​ឞ៝ក​អ្វែស​អាវ​អ្វែស​ឞើស? មោ​អោស។ ឞូនុយ្ស​ញឆ៝ស​ឞ៝ក​អ្វែស​អាវ​អ្វែស ឆោង​ឆា​ព្យាង់​កាស​ត្រាវ​កាស មពោល​នៃ​គុ​នតុក​កាដាច់​គុ មោ​អោស​គុ​តា​ឞ្រី​រាទាស។ ");
INSERT INTO cmok_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","លាស​នទ្រី​ឞូ​ម៝ស​ឞូនុយ្ស​ខាន់​អៃ​មៃ​ហាន់​អ្វាញ់? អ្វាញ់​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ឞើស? ទី​ងាន់។ យើន​មា​ពាង់​អី​នៃ​រាលាវ​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ជឹត‌ ");
INSERT INTO cmok_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","យ៝រ​លាស​តា​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​គែស​ញចីស​លាស​មា​ពាង់៖ «ល៝ង់​គ៝ប់​ញជ្វាល់​ឞូនុយ្ស​ហាន់​ល៝រ​មៃ គៃ​មា​នទ្រាប់​នូយ្ស​នហ៝ម់​ឞូនុយ្ស​តឹម​ឞាន​មា​ក្វាយ្ស​ត្រ៝ង​អ៝ន់​មា​មៃ»។ យោហាន-​បាប់តែម ​អី​នៃ​អី​ឞូនុយ្ស​ហាន់​ល៝រ​តា​នាវ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ខាន់​អៃ​មៃ​អ្យាត់​នាវ​គ៝ប់ ទឹង​លែៈ​ឞូនុយ្ស​អី​ទែស​តាៈ​ឞើស​ឞូ​អូរ​តា​នែស​នតូ​អ្យា មោ​គែស​អោស​ទូ​ហ្វេ​ក្វ៝ង់​រាលាវ​យោហាន-​បាប់តែម  យើន​លាស​តា​មពោល​ឞូនុយ្ស​អី​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ ឞូនុយ្ស​អី​ជេៈ​តា​ន៝ម់​ឞូ ឞូនុយ្ស​អី​នៃ​ជេង​ក្វ៝ង់​រាលាវ​ពាង់​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ផូង​ប៝ន​លាន នទ្រែល​មា​ឞូនុយ្ស​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន​គៃ​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ ជេស​ខាន់​ពាង់​អ្យាត់​នាវ​យោហាន-​បាប់តែម  ជេសរី​ខាន់​ពាង់​អ៝ន់​ពាង់​បាប់តែម​ខាន់​ពាង់​យុក​មា​ទាក នទ្រី​ខាន់​ពាង់​ញហើ​ខាន់​ពាង់​គឹត​កោរាញ​ឞ្រាស​ជេង​ទី​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","តីស​មា​ផូង​ផារីឆី  នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  ខាន់​ពាង់​មោ​អោស​អ៝ន់​ពាង់​បាប់តែម​យុក​ខាន់​ពាង់​មា​ទាក នទ្រី​ខាន់​ពាង់​ទូន​លើយ​លែៈ​នាវ​កោរាញ​ឞ្រាស​អុច​អ៝ន់​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ជេសរី​ឞ្រាស​យេឆូ ​លាស៖ “លាស​នទ្រី​មើម​គ៝ប់​តឹម​រាដឹល​មា​ឞូនុយ្ស​អាបៃ​អ្យា? ពាង់​មើម​ជេង? ");
INSERT INTO cmok_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ពាង់​ជេង​តឹម​ឞាន​មា​ក៝ន​ឆែ​គុ​ព៝ល់​តា​ជ៝ង់​គូង​ប៝ន គែស​អាបាៈ​តឹម​នតែរ​នទ្រាង់​ពាង់៖ «ហេន​លែៈ​អោស​នហោម​គ៝ស​គ៝រ់ តីស​មា​ខាន់​អៃ​មៃ​មោ​ព៝ល់​រាម់​មអាក‌ ជេសរី​ហេន​លែៈ​នអ៝រ​នត៝ង់​ទ៝ង់​ខឹត តីស​មា​ខាន់​អៃ​មៃ​មោ​អុច​ញុម​ព៝ល់​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","លាស​នទ្រី​យោហាន-​បាប់តែម  នទ្រែល​មា​គ៝ប់​ជេង​តឹម​ឞាន​មា​ផូង​ក៝ន​ឆែ​អី​នៃ យោហាន-​បាប់តែម ​អ៝ត់​ឆោង មោ​អោស​ញេត​នទ្រាញ់ តីស​មា​ខាន់​អៃ​មៃ​លាស​ពាង់​ឞូនុយ្ស​ឞ្រាស​អ្យើស​លាប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","“ល៝ង់​គ៝ប់​អ្យា​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​គែស​ញេត​គែស​ឆោង មោ​អ៝ត់​ឆោង​ឆា ខាន់​អៃ​មៃ​លាស​គ៝ប់៖ «ឞូនុយ្ស​ហៃ​ញេត​ហៃ​ឆោង ជាន​មឹត​ជាង់​នទ្រែល​ឞូនុយ្ស​ឆ៝ៈ​ព្រាក់​ប៝ន​លាន ជេសរី​គុ​នទ្រែល​ឞូនុយ្ស​តីស​អា​អេង​ជឹត»។ ");
INSERT INTO cmok_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","យើន​លាស​ឞូនុយ្ស​អី​តឹង​នាវ​កោរាញ​ឞ្រាស ញហើ​នាវ​កោរាញ​ឞ្រាស​អី​នៃ​ជេង​ទី​អ្វែស​ងាន់​តា​នាវ​រេស​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","គែស​ទូ​នារ​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​តា​ផូង​ផារីឆី ​រាញា​ពាង់​ឆីមោន  ជាៈ​ឞ្រាស​យេឆូ ​ហាន់​ឆោង​ឆា​តា​ជៃ​ពាង់​នើម ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​គុ​ឆោង​ឆា​នទ្រែល​តា​ជៃ​ពាង់​នៃ។ នោក​នៃ​តឹង​មា​នាវ​វៃ​ផូង​នទ្រ៝ង់​ខាន់​ពាង់​ឆោង​ឆា​គុ​ឞិច​ងកេង​ជឹត​ច្យៅ អី​ជ៝ង់​រ៝ក​ជឹត​កើយ។ ");
INSERT INTO cmok_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","តា​ប៝ន​នៃ​ដ៝ង់​គែស​ទូ​ហ្វេ​ឞូ​អូរ​វាង់​តឹរ។ ត៝ត់​ពាង់​តាង់​គែស​ឞ្រាស​យេឆូ ​គុ​ឆោង​ឆា​តា​ជៃ​ផារីឆី ​អី​នៃ ពាង់​ឆ៝ៈ​ដ៝ប​ជេៈ​ឞូ​ជាន​មា​លុ តា​ដ៝ប​រី​គែស​ទាក​ងី​បោ​កាស​ខ្លៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ជេសរី​ពាង់​ហាន់​តា​ជៃ​ឆីមោន ​គុ​ឞើស​កើយ​ឞ្រាស​យេឆូ ​រី ពាង់​ញុម​ហ៝រ​ទាក​មាត់​តា​ជ៝ង់​ឞ្រាស​យេឆូ  យ៝រ​មា​ពាង់​រាង៝ត​មា​នាវ​តីស​ពាង់​នើម ជេសរី​ឆ៝ៈ​ឆ៝ក់​ពាង់​នើម​រី​ជូត​ជ៝ង់​ឞ្រាស​យេឆូ  ជេសរី​ចុម​តា​ជ៝ង់​រី ជេស​ចុម​រី​ពាង់​ឆ៝ៈ​ទាក​ងី​បោ​កាស​ត៝ៈ​តា​ជ៝ង់​ឞ្រាស​យេឆូ ​រី​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ឞូនុយ្ស​អី​តើម​ជាៈ​ឞ្រាស​យេឆូ ​ឆោង​រី​នើស ពាង់​ឆៃ​កើត​នៃ ជេសរី​មឹន​អេង​តា​ឆាក់​រី៖ “លាស​ពាង់​ជេង​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ងាន់ ពាង់​គឹត​រ៝​ឞូ​អូរ​អី​ពាស​ពាង់​នៃ​ជេង​ឞូ​អូរ​តីស”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ឆីមោន ៖ “ហើយ​នោ គ៝ប់​អុច​ងក៝ច​ឞ្រី​មា​មៃ”។ ពាង់​អើស៖ “អើ​មោ​ច្រាវ​កោរាញ នែស​មៃ​ងក៝ច​ហ៝ម់”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ឞ្រាស​យេឆូ ​លាស​ទូ​នាវ​ងើយ​នតឹត៖ “គែស​ឞារ​ហៃ​ឞូនុយ្ស​មាញ​ព្រាក់​ឞូ ទូ​ហ្វេ​មាញ ៥០០ ព្រាក់​កាក់ ទូ​ហ្វេ​មាញ ៥០ ព្រាក់​កាក់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","យ៝រ​មា​ឞារ​ហៃ​ខាន់​ពាង់​អី​នៃ​មោ​គែស​ព្រាក់​ត៝ម់ នទ្រី​ទឹង​ឞូនុយ្ស​អី​តើម​អ៝ន់​មាញ​ព្រាក់​នៃ​មោ​ហោម​ដាៈ​ត៝ម់។ លាស​នទ្រី​លែៈ​ឞារ​ហៃ​អី​នៃ ឞូ​ម៝ស​រ៝ង់​ហោ​រាលាវ​មា​តើម​អ៝ន់​មាញ​ព្រាក់​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ពាង់​អើស៖ “គ៝ប់​គឹត​លាស​ឞូនុយ្ស​អី​មាញ​អ៝ក់”។ ឞ្រាស​យេឆូ ​លាស៖ “ទី​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ជេសរី​ឞ្រាស​យេឆូ ​អ្វាញ់​ជឹត​ឞូ​អូរ​អី​នៃ លាស​មា​ឆីមោន ៖ “មៃ​ឆៃ​ឞូ​អូរ​អ្យា​ជាន​បាស? គ៝ប់​លាប់​តា​ជៃ​មៃ តឹង​មា​នាវ​វៃ​ឞ៝ន់​ទី​មា​មៃ​ឆ៝ៈ​ទាក​គ៝ប់​ឞែ​មា​រាវ​ជ៝ង់ តីស​មា​មៃ​មោ​អោស​ឆ៝ៈ ល៝ង់​ពាង់ ពាង់​ញុម​ហ៝រ​ទាក​មាត់​តា​ជ៝ង់​គ៝ប់​ឞែៈ​លែៈ​ផ្យៅ ជេសរី​ឆ៝ៈ​ឆ៝ក់​ពាង់​នើម​ជូត​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","តឹង​មា​នាវ​វៃ​ឞ៝ន់​មៃ​ចុម​តា​តឹម​ឞ៝ម​គ៝ប់ តីស​មា​មៃ​មោ​អោស​ចុម ល៝ង់​ពាង់ ចុម​ជ៝ង់​គ៝ប់​មោ​រាលូ នតើម​ឞើស​គ៝ប់​ត្រុយ្ស​តា​អ្យា​នើស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","តឹង​មា​នាវ​វៃ​ឞ៝ន់​ទី​មា​មៃ​ត៝ៈ​ទាក​ងី​តា​ឞោក​គ៝ប់ តីស​មា​មៃ​មោ​អោស​ត៝ៈ ល៝ង់​ពាង់ ត៝ៈ​ទាក​ងី​បោ​កាស​ជូត​តា​ជ៝ង់​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","កើត​នទ្រី​គ៝ប់​មឞើស​មា​មៃ ឞូ​អូរ​អ្យា​អ៝ក់​ងាន់​នាវ​តីស​ពាង់ គ៝ប់​លែៈ​យោៈ​នអាច​ជេស​ទឹង​លែៈ​នាវ​តីស​ពាង់ មោ​ហោម​អោស​កើប​នាវ​តីស​ពាង់ នទ្រី​ទឹង​ពាង់​គែស​នាវ​រ៝ង់​ហោ​ងាន់។ តីស​មា​ឞូ​ម៝ស​អី​គែស​យោៈ​នអាច​ដេៈ នាវ​រ៝ង់​ពាង់​គែស​ដេៈ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ជេសរី​ឞ្រាស​យេឆូ ​លាស​ជឹត​ឞូ​អូរ​រី៖ “នាវ​តីស​អៃ​លែៈ​គ៝ប់​យោៈ​ជេស គ៝ប់​មោ​ហោម​អោស​កើប​នាវ​តីស”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","លែៈ​ឞូនុយ្ស​អី​គុ​នទ្រែល​តា​នៃ​មឹន​អេង​តា​ឆាក់​រី៖ “ឞូ​ម៝ស​ពាង់​អី​នៃ​ហ្យាស ទឹង​ឞាញ់​លាស​យោៈ​នអាច​នាវ​តីស​ដ៝ង់? គែស​កោរាញ​ឞ្រាស​ទើម​ទើយ​យោៈ​នាវ​តីស”។ ");
INSERT INTO cmok_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ឞូ​អូរ​អី​នៃ៖ “ហើយ​អ៝ស យ៝រ​នាវ​អៃ​ញឆីង​មា​គ៝ប់ អៃ​លែៈ​ក្លាយ្ស​ជេស​ឞើស​នាវ​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស ឆឹត​អ៝ន់​អ្វែស​លាង់​ដាប់​មពាន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា ១២ កោរាញ​អ៝ស​ម៝ន​ពាង់ ហាន់​រ៝ៈ​ប៝ន​ក្វ៝ង់​ប៝ន​ជេៈ​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​អី​កោរាញ​ឞ្រាស​អុច​ម៝ត់​អ្វាញ់​ឞូនុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","គែស​ឞូ​អូរ​អាបាៈ​ហាន់​នទ្រែល​ដ៝ង់ ឞូ​អូរ​អាបាៈ​លែៈ​ឞ្រាស​យេឆូ ​ជាន​ឞាស​ជេស​នាវ​ជី នទ្រែល​មា​លែៈ​នត្រុត​ឞ្រាស​អ្យើស​អ៝ន់​លោស តា​នៃ​គែស​រាញា​មារី  តាៈ​ឞើស​ប៝ន​មាដាលា  ឞូ​អូរ​អី​នៃ​ឞ្រាស​យេឆូ ​នត្រុត​ពើស​ឞ្រាស​អ្យើស​លោស​ឞើស​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ជេសរី​ឞូ​អូរ​រាញា​យោអាន់នា  អី​អូរ​ខូឆា ​ឞូនុយ្ស​ម៝ត់​អ្វាញ់​មពោល​ជាន​ការ​មា​ហេរោត-​អ៝ន់តីពាស ​អី​កោរាញ​ម៝ត់​អ្វាញ់​ឞ្រី​កាលីលេ  គែស​ឞូ​អូរ​រាញា​ឆូឆាន  នទ្រែល​មា​ឞូ​អូរ​អាបាៈ​អេង​អ៝ក់​ដ៝ង់ ខាន់​ពាង់​ឆ៝ៈ​ទ្រាប់​នទើ​ខាន់​ពាង់​នើម​គៃ​មា​កើល​ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","គែស​អ៝ក់​ឞូនុយ្ស​តាៈ​ឞើស​ប៝ន​អេងៗ ហាន់​វាច់​តា​ឞ្រាស​យេឆូ ​រី ជេសរី​ពាង់​ងើយ​នាវ​នតឹត​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ហាន់​ឆូយ​គារ់​នតីល។ នោក​ពាង់​ឆូយ​នៃ​អាបាៈ​តុប​រ៝ៈ​ត្រ៝ង គែស​ឞូនុយ្ស​ជ៝ត ជេសរី​ឆ្យុម​ច៝ក​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","គារ់​អាបាៈ​តុប​តា​នែស​ក្លេរ ហ៝ន​ព្រូ ជេសរី​នទ្រ៝​លែៈ​រាងោច យ៝រ​លាស​រែស​មោ​ជ្រូ​មោ​គែស​ទាក។ ");
INSERT INTO cmok_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","គារ់​អាបាៈ​តុប​តា​នែស​ល៝ក ល៝ក​ហ៝ន​នទ្រែល ជេសរី​ល៝ក​ត៝ល់​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","គែស​គារ់​អាបាៈ​ជឹត​តុប​តា​នែស​អ្វែស ហ៝ន​ត៝ត់​ព្លៃ ទូ​គារ់​ជេង​គែស ១០០ រាង្លៃ​រ៝”។ ជេស​ឞ្រាស​យេឆូ ​ងើយ​នាវ​នៃ ពាង់​ក្វាល់៖ “ឞូ​ម៝ស​តាង់​នាវ​គ៝ប់​ងើយ​អ្យា អ៝ន់​ពាង់​មឹន​អេង​តា​ឆាក់!” ");
INSERT INTO cmok_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ជេសរី​មពោល​អ៝ស​ម៝ន​អោប​ឞ្រាស​យេឆូ ៖ “លាស​នទ្រី​ម៝ស​នាវ​ខ្លៃ​តា​នាវ​ងើយ​នតឹត​អី​នៃ?” ");
INSERT INTO cmok_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ពាង់​អើស៖ “កោរាញ​ឞ្រាស​លែៈ​អ៝ន់​ជេស​នាវ​ខ្លៃ​នាវ​អី​នៃ​មា​ខាន់​មៃ​គឹត​វ៝ត់ មពើល​នាវ​នទ៝ប់​អា​ល៝រ​នើស អី​នៃ​ជេង​នាវ​ខ្លៃ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស។ ល៝ង់​ឞូនុយ្ស​អាបាៈ​ជឹត គ៝ប់​ងើយ​នតឹត​អ៝ន់​មា​ខាន់​ពាង់។ កើត​នទ្រី​ឞ៝ល​លាស «ខាន់​ពាង់​អ្វាញ់​នទើ​គ៝ប់​ជាន​ក៝ៈ​មោ​វ៝ត់​នទើ​ខ្លៃ​នាវ​អី​នៃ‌ ខាន់​ពាង់​តាង់​នាវ​គ៝ប់​ងើយ​ក៝ៈ​មោ​វ៝ត់​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","អ្យា​គ៝ប់​រាឞ្លាង​នាវ​នតឹត៖ គារ់​នើស​ជេង​នាវ​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ឞូនុយ្ស​អាបាៈ​តឹម​ឞាន​មា​គារ់​តុប​តា​ត្រ៝ង តាង់​ដ៝ង់​នាវ​កោរាញ​ឞ្រាស តីស​មា​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​ពីត​លើយ​នាវ​កោរាញ​ឞ្រាស​ឞើស​នូយ្ស​នហ៝ម់​ខាន់​ពាង់ គៃ​លើយ​អ៝ន់​អ្យាត់ ជេសរី​លើយ​គែស​នាវ​រាក្លាយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ឞូនុយ្ស​អាបាៈ​ជឹត​តឹម​ឞាន​មា​គារ់​តុប​តា​នែស​ក្លេរ ត៝ត់​តាង់​នាវ​កោរាញ​ឞ្រាស ខាន់​ពាង់​អ្យាត់​រាម់​មអាក​ងាន់ តីស​មា​ខាន់​ពាង់​អ្យាត់​ទូ​នទ៝ម់​ទើម មោ​អោស​អ៝ន់​នាវ​កោរាញ​ឞ្រាស​អី​នៃ​ហ៝ន​រែស​ជ្រូ​តា​នូយ្ស​នហ៝ម់​ខាន់​ពាង់ លាស​គែស​នាវ​ជេរ​នាវ​នទើម ខាន់​ពាង់​នត្លើយ​នាវ​ញឆីង​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","គារ់​តុប​តា​នែស​ល៝ក តឹម​ឞាន​មា​ឞូនុយ្ស​អ្យាត់​នាវ​កោរាញ​ឞ្រាស តីស​មា​តា​ត្រោម​នូយ្ស​នហ៝ម់​រី​រាវៃ​កើញ​មា​ទ្រាប់​នទើ​ហោ​ងាន់​គឹត​មា​នាវ​មអាក​ទើម នូយ្ស​នហ៝ម់​អុច​មា​គែស ឞូនុយ្ស​កើត​នៃ​តឹម​ឞាន​មា​ល៝ក​បារ់​មោ​អ៝ន់​ខាន់​ពាង់​ព្លៃ​ត្រុយ្ស​ទុម។ ");
INSERT INTO cmok_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ល៝ង់​គារ់​អី​តុប​តា​នែស​អ្វែស​រី តឹម​ឞាន​មា​ឞូនុយ្ស​អ្យាត់​នាវ​កោរាញ​ឞ្រាស គែស​នូយ្ស​នហ៝ម់​អ្វែស ញអោត​ន៝ប់​តា​នូយ្ស​នហ៝ម់​ពាង់​នើម​នាវ​អី​នៃ នហ៝​មា​ត៝ត់​គែស​ព្លៃ​អ៝ក់​ងាន់ យ៝រ​មា​នូយ្ស​នហ៝ម់​ញឆ្រោយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ឞ្រាស​យេឆូ ​លាស​ជឹត៖ “មោ​គែស​អោស​ឞូនុយ្ស​មពេស​អុញ​ឆាគេង ជេសរី​ឆ៝ៈ​ថុង​កុប​ឞើស​លើ មោ​លាស​តេៈ​តា​ន៝ម់​គ្រែ។ ឞូ​វៃ​យោង​ព្រេស គៃ​មា​អាង​លែៈ​ឞូនុយ្ស​អី​លាប់​តា​ត្រោម​ជៃ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ទឹង​លែៈ​នទើ​មពោន​ម៝​មា​ឞូ កោរាញ​ឞ្រាស​អុច​ឞូ​គឹត​នហេល ជេសរី​ទឹង​លែៈ​នទើ​នទ៝ប់​ពាង់​អុច​ឞូ​ឆៃ​ក្ល៝ស​រាស​វាស​តា​អាង។ ");
INSERT INTO cmok_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","លាស​នទ្រី​ញជ្រាង់​ងាន់​ហ៝ម់​នាវ​អី​ខាន់​មៃ​លែៈ​តាង់ យ៝រ​លាស​ឞូ​ម៝ស​អី​លែៈ​គែស កោរាញ​ឞ្រាស​កើយ​នត៝ប​អ៝ន់​មា​ពាង់​ជឹត តីស​មា​ឞូ​ម៝ស​អី​មោ​គែស កោរាញ​ឞ្រាស​ឆ៝ៈ​រាហ្វាត់​លើយ​លែៈ​នទើ​អី​ពាង់​គឹត​លាស​លែៈ​គែស”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ជេសរី​អី​មេៈ​ឞ្រាស​យេឆូ  នទ្រែល​មា​អី​អ៝ស​ឞូ​ក្លោ​ពាង់ ហាន់​តា​ប៝ន​នៃ​គៃ​មា​ម៝ប់​ពាង់ ត៝ត់​តា​នៃ​មោ​គែស​អោស​ត្រ៝ង​លាប់ យ៝រ​លាស​ឞូនុយ្ស​អ៝ក់​អីរ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ជេសរី​គែស​ឞូ​មឞើស​មា​ឞ្រាស​យេឆូ ៖ “មេៈ​មៃ នទ្រែល​មា​អ៝ស​មៃ​គុ​ឞើស​ទីស​រី​អុច​ម៝ប់​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ឞ្រាស​យេឆូ ​អើស៖ “ឞូ​ម៝ស​អី​គុ​អ្យាត់​នាវ​ងើយ​កោរាញ​ឞ្រាស ជេសរី​តឹង​ជាន ឞូនុយ្ស​អី​នៃ​ជេង​មេៈ ជេង​អ៝ស​នោ​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","គែស​ទូ​នារ​ឞ្រាស​យេឆូ ​ជាៈ​មពោល​អ៝ស​ម៝ន​ពាង់៖ “ហោៈ ឞ៝ន់​ហាន់​ជឹត​កាល់​តី​ទាក​តី”។ ជេសរី​ខាន់​ពាង់​ញច៝​ទូក​ហាន់​ជឹត​កាល់​តី​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ទោល​ខាន់​ពាង់​ញច៝​រី ឞ្រាស​យេឆូ ​ហាក់​ឞិច ជេសរី​ទោ​មា​គែស​ផុត​ច្វាញ់​ទុត​ហោ​រ៝ៈ​ទាក​ងលៅ​ក្វ៝ង់​រី ទូក​ខាន់​ពាង់​ទាក​លាប់​ឞើយ​មា​ង៝ម់ លែៈ​ខាន់​ពាង់​តា​កាលើ​ទូក​រី​ឞើយ​មា​ខឹត​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ជេសរី​ខាន់​ពាង់​រាលៃ​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញ! ហើយ​កោរាញ! ខឹត​រ៝​ឞ៝ន់​មេ”។ ឞ្រាស​យេឆូ ​កាស​រាងាល់ វាល់​ផុត​ច្វាញ់ នទ្រែល​មា​ទាក​រាឞុស។ ជេសរី​ផុត​ច្វាញ់ នទ្រែល​មា​ទាក​រាឞុស​ឞាស​រ៝ ទាក​រាង៝ន់​កើត​អើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ឞ្រាស​យេឆូ ​រាង៝ត ជេសរី​លាស​មពោល​អ៝ស​ម៝ន​ពាង់៖ “អាស​អ៝ន់​នាវ​ញឆីង​ខាន់​មៃ?” មពោល​អ៝ស​ម៝ន​ក្លាច​ញឆ៝រ់​ងាន់ នទ្រ៝ត់​ហីស​រាហ៝ល់​ដ៝ង់។ មពោល​អ៝ស​ម៝ន​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ “មើម​ទឹង​គែស​នាវ​ទើយ​កើត​នៃ ទើយ​ដាៈ​ផុត ដាៈ​ទាក ជេសរី​ផុត​នទ្រែល​ទាក​អ្យាត់​នាវ​ពាង់​ឞាស​ផ្យៅ​ដ៝ង់?” ");
INSERT INTO cmok_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ឞ្រាស​យេឆូ  នទ្រែល​អ៝ស​ម៝ន​ពាង់​ត៝ត់​កាល់​តី​ទាក​ងលៅ​ក្វ៝ង់​កាលីលេ  ទាច់​នតុក​ប៝ន​រាញា​កេរាឆីន ​រី នតុក​ប៝ន​អី​នៃ​ឞូ​មោ​អោស​តឹង​នាវ​វៃ​ផូង​អីឆ្រាអែល ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","នោក​ឞ្រាស​យេឆូ ​ហាវ​អា​កើស​តី គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​តាៈ​ឞើស​ប៝ន​នៃ​រាន​ជឹត​ពាង់​អ្យា។ ឞូនុយ្ស​អី​នៃ​ឞ្រាស​អ្យើស​លាប់​គុ​តា​ពាង់ អ៝ន់​ពាង់​គុ​លាហោក មោ​គែស​អោស​គុ​តា​ជៃ គុ​តា​នតុក​មោច​ទើម​លែៈ​ជ៝ៈ​នាម់​ហើយ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","គែស​អ៝ក់​តឹ​ឞ្រាស​អ្យើស​ញុប​ពាង់ ឞ៝ល​លាស​ឞូ​ក៝ត់​ជ៝ង់​ក៝ត់​តី​ពាង់​មា​រាឆែ​រាវាក់​អ៝ន់​គុ​ទូ​នតុក​ហ៝ៈ ពាង់​ងក្លាស​លើយ​រាឆែ​រាវាក់​លែៈ​ផ្យៅ ជេសរី​ឞ្រាស​អ្យើស​លែវ​ពាង់​គុ​អេង​តា​ឞ្រី​រាទាស​ងាយ​ឞើស​ឞូនុយ្ស។ ត៝ត់​ឆៃ​ឞ្រាស​យេឆូ ​រី ពាង់​ពាន់​តា​ជ៝ង់​ឞ្រាស​យេឆូ ​នៃ ជេសរី​ឞ្រាស​យេឆូ ​នត្រុត​ឞ្រាស​អ្យើស​ដាៈ​ពាង់​លោស​ឞើស​ឞូ​ក្លោ​អី​នៃ យើន​មា​ឞ្រាស​អ្យើស​អេ​ហ៝ៈ​លោស​អោស ពាង់​នតែរ​ទុត​នតែសៗ​ងាន់៖ “ហើយ​ឞ្រាស​យេឆូ ក៝ន​កោរាញ​ឞ្រាស​អី​ទុត​ព្រេស​តា​កាលើ​ត្រោក មើម​មៃ​ជាន​មា​គ៝ប់​មេស? ខឹត​អោម​លោម​លាៈ លើយ​ទឹង​ងក្រីត​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ជេសរី​ឞ្រាស​យេឆូ ​អោប​ពាង់៖ “មើម​រាញា​មៃ​មេស?” ពាង់​អើស៖ “គ៝ប់​រាញា​មពោល​តាហែន​អ៝ក់​រាឞាន់”។ ពាង់​អើស​កើត​នៃ​យ៝រ​លាស​ឞ្រាស​អ្យើស​អ៝ក់​ងាន់​គុ​តា​ឆាក់​ពាង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","មពោល​ឞ្រាស​អ្យើស​អី​នៃ​ឞ៝ញ​ឞ្រាស​យេឆូ  លើយ​អោស​ងក្លាច់​ខាន់​ពាង់​តា​នតូ​ឞ្រ៝ង់​អី​នតុក​តេៈ​ទោយ្ស​មា​ឞ្រាស​អ្យើស។ ");
INSERT INTO cmok_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","គែស​ឆុរ​ផូង​គុ​ឆា​មពា​រ៝ៈ​យោក​ទាច់​មា​នតុក​នៃ។ មពោល​ឞ្រាស​អ្យើស​អី​រី​ឞ៝ញ​ឞ្រាស​យេឆូ ​អ៝ន់​លាប់​គុ​តា​ឆុរ​អី​នៃ ជេសរី​ឞ្រាស​យេឆូ ​អ៝ន់​ពាង់​លាប់​តា​ឆុរ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ជេសរី​មពោល​ឞ្រាស​អ្យើស​អី​រី​លោស​ឞើស​ឞូនុយ្ស​អី​នៃ​លាប់​គុ​តា​ឆុរ​រី​លែៈ​រាង៝ត់ ជេសរី​ឆុរ​អី​នៃ​ញច្វាត់​រាឞុល​ជឹត​ឆ៝ប​រាប៝ង់​ជឹត​ទាក​ងលៅ​រី លាប់​តា​ទាក​រាម៝ក​ខឹត​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ជេស​មពោល​ច្យាប់​ឆុរ​អី​នៃ​ឆៃ​កើត​នៃ ខាន់​ពាង់​ញច្វាត់​មឞើស​រ៝​មា​ឞូនុយ្ស​គុ​រ៝ៈ​ប៝ន រ៝ៈ​មីរ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ជេសរី​ឞូនុយ្ស​អី​តាង់​នាវ​នៃ​ខាន់​ពាង់​ហាន់​អ្វាញ់​គៃ​មា​ឆៃ​នហេល​នទើ​អី​នៃ។ ត៝ត់​តា​ឞ្រាស​យេឆូ ​ខាន់​ពាង់​ក្លាច​ទាទេ​ងាន់ ឆៃ​ឞូ​ក្លោ​ឞ្រាស​អ្យើស​លាប់​នើស​គុ​តា​នាប់​ឞ្រាស​យេឆូ ​រី នទ្រែល​មា​ញឆ៝ស​ខ៝​អាវ​កាស​គឹត​ឆាក់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ឞូនុយ្ស​អី​លែៈ​ឆៃ​មា​មាត់​នាវ​នៃ ខាន់​ពាង់​ដើន​ងក៝ច​អ៝ន់​មា​ឞូ​អេង​មើម​បាៈ​ឞ្រាស​យេឆូ ​ជាន​ឞាស​មា​ឞូនុយ្ស​ឞ្រាស​អ្យើស​លាប់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","លែៈ​ឞូនុយ្ស​គុ​រ៝ៈ​ឞ្រី​ទាច់​មា​ប៝ន​កេរាឆីន ​ក្លាច​ញឆ៝រ់​ហោ​ងាន់ ខាន់​ពាង់​ឞ៝ញ​ឞ្រាស​យេឆូ ​ដាៈ​ពាង់​ទូ​លោស​ឞើស​នតុក​នៃ នទ្រី​ទឹង​ឞ្រាស​យេឆូ ​ញច៝​ទូក​ឆឹត នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ល៝ង់​ឞូនុយ្ស​អី​លែៈ​ឞ្រាស​អ្យើស​លោស​នៃ​នើស ពាង់​ឞ៝ញ​ទាន់​គុ​នទ្រែល​ឞ្រាស​យេឆូ  តីស​មា​ឞ្រាស​យេឆូ ​មោ​រ៝ម​អោស ជេសរី​លាស​មា​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“មៃ​ឆឹត​ជឹត​ជៃ​មៃ​នើម​រី មឞើស​លែៈ​នាវ​កោរាញ​ឞ្រាស​ជាន​អ្វែស​មា​មៃ​នើស”។ ជេសរី​ពាង់​ហាន់​លាម​ប៝ន​ក្វ៝ង់ មឞើស​លែៈ​នាវ​ឞ្រាស​យេឆូ ​ជាន​មា​ឆាក់​ពាង់​នើម​នើស​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ត៝ត់​ឞ្រាស​យេឆូ ​ព្លឹ​ឆឹត​តា​រី ប៝ន​លាន​រ៝ម​ពាង់ ឞូ​រាន​ច្វាៈ​ពាង់ យ៝រ​លាស​លែៈ​ឞូ​នើស​អ្វាញ់​មាត់​តើម​ត្រ៝ង​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","តា​នៃ​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ ពាង់​រាញា​យៃរុស  ពាង់​កោរាញ​ញីស​រាបុន​ផូង​អីឆ្រាអែល ​តា​នៃ ពាង់​រាន​ពាន់​តា​ជ៝ង់​ឞ្រាស​យេឆូ ​រី ឞ៝ញ​ជាៈ​ឞ្រាស​យេឆូ ​ហាន់​អា​ជៃ​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","យ៝រ​លាស​ក៝ន​ឞូ​អូរ​ពាង់​ជី​ឞើយ​ខឹត។ ពាង់​គែស​ទូ​ហ្វេ​ក៝ន​អី​នៃ​ទើម ក្លាប់​លាស ១២ នាម់។ ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​ជឹត​ជៃ​ពាង់ រ៝ៈ​ត្រ៝ង​នៃ​គែស​អ៝ក់​ឞូនុយ្ស​តឹម​មពែត​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","តា​មពោល​នៃ​គែស​ដ៝ង់​ទូ​ហ្វេ​ឞូ​អូរ​ជី​រីស​លែៈ​ជ៝ៈ ១២ នាម់​ហើយ ពាង់​ហ្វាច​លែៈ​ទ្រាប់​នទើ​ពាង់ គៃ​មា​អ៝ន់​កោរាញ​ទាក​ឆី តីស​មា​មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​ទើយ​ជាន​ឞាស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ពាង់​អី​រី​ហាន់​ឞើស​កើយ​ឞ្រាស​យេឆូ  ពាស​តា​ច្យាង់​អាវ​ឞ្រាស​យេឆូ ​រី ជេសរី​មហាម​ពាង់​ឞាស​នទាល​តា​នៃ​រ៝​មោ​ហោម​អោស​ត្រោស។ ");
INSERT INTO cmok_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ឞ្រាស​យេឆូ ​លាស៖ “ឞូ​ម៝ស​ពាស​គ៝ប់?” ទឹង​លែៈ​ឞូ​តា​នៃ ឞូ​លាស​មោ​ពាស​អោស។ ពេត្រោស ​លាស៖ “ហើយ​កោរាញ ឞូនុយ្ស​ជុម​មៃ​តឹម​មពែត​ងាន់ ទឹង​លែៈ​ឞូ​គែស​គ៝ៈ​មៃ​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ឞ្រាស​យេឆូ ​លាស៖ “គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ពាស​គ៝ប់​ងាន់​រ៝ យ៝រ​លាស​គ៝ប់​គឹត​នាវ​ឞ្រាស​គែស​លោស​តាៈ​ឞើស​ឆាក់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ជេសរី​ឞូ​អូរ​អី​នៃ​ហាន់​តា​នាប់​ឞ្រាស​យេឆូ ​រី​ញឆ៝រ់​ងាន់ ពាន់​តា​ជ៝ង់​ឞ្រាស​យេឆូ ​រី ពាង់​លែៈ​គឹត​នាវ​អី​នៃ​ពោន​មោ​នទ៝ប់​អោស។ ពាង់​ងក៝ច​អ៝ន់​មា​ឞ្រាស​យេឆូ ​តា​នាប់​ឞូ​ឞាល់ ម៝ស​យ៝រ​ទឹង​ពាង់​ពាស​ឞ្រាស​យេឆូ  មើម​ទឹង​ពាង់​ឞាស​នទាល​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ហើយ​អ៝ស នាវ​អៃ​ញឆីង​ជាន​ឞាស​អៃ​ហើយ ឆឹត​អ៝ន់​អ្វែស​លាង់​ដាប់​មពាន់​យឹ”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","នោក​ឞ្រាស​យេឆូ ​ហោម​អែ​ងើយ​នៃ គែស​ទូ​ហ្វេ​ឞូនុយ្ស​តាៈ​ឞើស​ជៃ​យៃរុស ​រី​មឞើស​មា​យៃរុស ​អី​កោរាញ​ញីស​រាបុន៖ “ក៝ន​មៃ​លែៈ​ខឹត​មេ លើយ​ហោម​រាខ្វាក​អោឞាល់”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ត៝ត់​ឞ្រាស​យេឆូ ​តាង់​ឞូ​មឞើស​កើត​នៃ ពាង់​លាស​មា​យៃរុស ៖ “លើយ​ទឹង​ក្លាច​អោស អ្យាត់​មា​មៃ​ញឆីង​មា​គ៝ប់ ក៝ន​មៃ​រេស​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​ត៝ត់​តា​ជៃ​យៃរុស ពាង់​លាប់​តា​ត្រោម​ជៃ ឞូ​អាបាៈ​អេង​មោ​អោស​អ៝ន់​លាប់ ពាង់​អ៝ន់​ពេត្រោស យោហាន យាកើ  នទ្រែល​មា​អី​មេៈ​ឞឹ​ក៝ន​ឆែ​អី​នៃ ទូ​នៃ​ទើម​អ៝ន់​លាប់។ ");
INSERT INTO cmok_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ទឹង​លែៈ​ឞូនុយ្ស​តា​នៃ​ញុម​វើល​មា​ក៝ន​ឆែ​អី​ខឹត​រី​ទាទេ ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “លើយ​ហោម​ញុម ពាង់​មោ​អោស​ខឹត ពាង់​ហាក់​ឞិច​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","មពោល​អី​នៃ​គើម​មឺច​មា​ឞ្រាស​យេឆូ  យ៝រ​លាស​ខាន់​ពាង់​លែៈ​គឹត​ជេស​ក៝ន​ឆែ​អី​នៃ​លែៈ​ខឹត​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ជេសរី​ឞ្រាស​យេឆូ ​ញុប​តី​ក៝ន​ឆែ​អី​នៃ លាស​មា​ពាង់៖ “ហើយ​អ៝ស អៃ​ទ៝ក់​ហ៝ម់!” ");
INSERT INTO cmok_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","នោក​នៃ​រ៝​ហ្វេង​ពាង់​ព្លឹ​ឆឹត​តា​ពាង់​នើម ជេសរី​ទ៝ក់​រេស​រ៝។ ឞ្រាស​យេឆូ ​ដាៈ​ឞូ​ឆ៝ៈ​នទើ​អ៝ន់​មា​ពាង់​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","មេៈ​ឞឹ​ក៝ន​ឆែ​អី​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់​មោ​វ៝ត់​អោស យើន​មា​ឞ្រាស​យេឆូ ​ឞ្វៃ​មោ​អោស​អ៝ន់​ខាន់​ពាង់​ងក៝ច​នាវ​អី​នៃ​មា​ឞូ​អេង​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","គែស​ទូ​នារ​រី​ឞ្រាស​យេឆូ ​ក្វាល់​អី ១២ អ៝ស​ម៝ន ជេសរី​អ៝ន់​នាវ​ទើយ​មា​ខាន់​ពាង់ ទើយ​នត្រុត​ឞ្រាស​អ្យើស នទ្រែល​មា​ទើយ​ជាន​ឞាស​ឞូនុយ្ស​គែស​នាវ​ជី​អេងៗ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ពាង់​ដាៈ​ខាន់​ពាង់​ហាន់​មឞើស​អ៝ន់​ឞូ​គឹត​នាវ​កោរាញ​ឞ្រាស​អុច​ម៝ត់​អ្វាញ់​ឞូនុយ្ស នទ្រែល​មា​ជាន​ឞាស​នាវ​ជី​ក្វែត​ឞូ​អ៝ន់​ឞាស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ទោល​ខាន់​មៃ​ឞ្រោៈ​ប៝ន​អេងៗ មោ​អ៝ន់​អោស​លែវ​ញអោត​នទើ​តា​ឆាក់ ឞ៝ល​លាស​ម៝ង់​ជ្រា ទុង​ចែង នទើ​ឆា ព្រាក់​កាយ្ស មោ​លាស​ខ៝​អាវ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ម៝ស​ជៃ​ខាន់​មៃ​លាប់ គុ​តា​ជៃ​អី​នៃ​ហ៝ៈ នហ៝​មា​ត៝ត់​ខាន់​មៃ​លោស​ឞើស​ប៝ន​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","លាស​ប៝ន​អី​នៃ​មោ​អោស​រ៝ម​ខាន់​មៃ អ៝ន់​លោស​ឞើស​នតុក​នៃ​ហ៝ម់ ជេសរី​រាតោស​នែស​មោយ​ឞើស​ជ៝ង់​ខាន់​មៃ​នើម គៃ​មា​ញហើ​លាស​ប៝ន​អី​នៃ​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ជេសរី​មពោល​អ៝ស​ម៝ន​នៃ​ហាន់​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​អ៝ក់​ប៝ន នទ្រែល​មា​ជាន​ឞាស​ឞូនុយ្ស​ជី​អាប់​នតុក​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ត៝ត់​ហេរោត-​អ៝ន់តីពាស ​អី​កោរាញ​ម៝ត់​អ្វាញ់​ឞ្រី​កាលីលេ ​នៃ​តាង់​លឺ​ទឹង​លែៈ​នាវ​ឞ្រាស​យេឆូ ​ជាន​រី ពាង់​អ្យាត់​មោ​គឹត លិច​មោ​គឹត យ៝រ​លាស​គែស​ឞូនុយ្ស​អាបាៈ​ងក៝ច​លាស៖ “យោហាន-​បាប់តែម ​លែៈ​ទ៝ក់​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ឞូ​អាបាៈ​អេង​លាស៖ “ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស រាញា​ពាង់​អេលីយា  លែៈ​ញហើ​ឆាក់​អ៝ន់​មា​ឞូ​ឆៃ”។ ឞូ​អាបាៈ​អេង​ជឹត​លាស៖ “គែស​ទូ​ហ្វេ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ឞើស​កាល់​អែ​នើស លែៈ​ទ៝ក់​រេស​ជេស”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ល៝ង់​កាដាច់​ហេរោត ​លាស៖ “លាស​យោហាន-​បាប់តែម ​លែៈ​គ៝ប់​ក៝ស​ត៝ង​ក៝​ពាង់​ជេស លាស​នទ្រី​ឞូ​ម៝ស​ពាង់​អី​ជាន​នាវ​អី​រី?” ជេសរី​ពាង់​ជ៝យ​នាវ​អុច​ម៝ប់​ឞ្រាស​យេឆូ ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ជេស​មពោល​កោរាញ​អ៝ស​ម៝ន​ពាង់​ឆឹត​តាៈ​ឞើស​នតុក​អេងៗ ខាន់​ពាង់​ងក៝ច​ឞ្រី​អ៝ន់​មា​ឞ្រាស​យេឆូ ​ទឹង​លែៈ​នាវ​ខាន់​ពាង់​ជាន។ ជេសរី​ឞ្រាស​យេឆូ ​ជាៈ​អេង​ខាន់​ពាង់​ហាន់​តា​ទូ​ប៝ន រាញា​ប៝ន​បេតឆៃដា ‌ ");
INSERT INTO cmok_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ជេស​ប៝ន​លាន​លែៈ​គឹត ខាន់​ពាង់​លែវ​ឞាល់​ហាន់​តឹង​ឞ្រាស​យេឆូ ។ ឞ្រាស​យេឆូ ​រ៝ម​ខាន់​ពាង់​អី​នៃ ជេសរី​មឞើស​ងក៝ច​អ៝ន់​ខាន់​ពាង់​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​អុច​ម៝ត់​អ្វាញ់​ឞូនុយ្ស នទ្រែល​មា​ជាន​អ៝ន់​ឞាស​ឞូនុយ្ស​គែស​នាវ​ជី​ក្វែត​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ត៝ត់​ទេស​នារ ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​អី​នៃ​ហាន់​តា​ឞ្រាស​យេឆូ  លាស​មា​ពាង់៖ “ហើយ​កោរាញ ដាៈ​មៃ​មឞើស​អ៝ន់​ប៝ន​លាន​ឆឹត​ជ៝យ​នតុក​ឞិច ជ៝យ​នទើ​ឆោង​ឆា​រ៝ៈ​ជៃ​រ៝ៈ​ប៝ន​ទាច់ៗ​អ៝យ​តា​អ្យា យ៝រ​លាស​តា​អ្យា​នតុក​រាទាស​ងាយ​ឞើស​ប៝ន​មោ​គែស​អោស​នទើ​ឆា”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់​អី​នៃ៖ “ខាន់​មៃ​អ៝ន់​ឞូ​ឆោង​ឆា​ហែស”។ មពោល​កោរាញ​អ៝ស​ម៝ន​អើស៖ “ហេន​គែស​ព្រាម់​មល៝ម់​នុមពាង់ នទ្រែល​មា​ឞារ​មល៝ម់​កា​ទើម កោរាញ​មេ អើម​ជេង​ត៝ង់​លាស? លាស​នទ្រី​កើយ​រាវាត់​មើ​ត៝ង់​មា​អ៝ន់​ខាន់​ពាង់​អី​នៃ​ឆា”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ខាន់​ពាង់​ងើយ​នទ្រី យ៝រ​លាស​តា​នតុក​អី​នៃ​ក្លាប់​លាស​គែស ៥០០០ នុយ្ស​ឞូ​ក្លោ។ ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​អ៝ស​ម៝ន៖ “ខាន់​មៃ​ដាៈ​ឞូ​គុ​ទូ​មពោល​ទូ​មពោល​អ៝ន់​គែស​ក្លាប់​លាស ៥០ នុយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","មពោល​អ៝ស​ម៝ន​ជាន​កើត​នាវ​ពាង់​ដាៈ ជេសរី​ទឹង​លែៈ​ឞូ​គុ​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ជេសរី​ឞ្រាស​យេឆូ ​ឆ៝ៈ​ព្រាម់​មល៝ម់​នុមពាង់ នទ្រែល​មា​ឞារ​មល៝ម់​កា​រី ពាង់​ងគើរ​មាត់​ជឹត​លើ​ត្រោក​មឞើស​ឆើម​នទើ​ឆោង​ឆា​អី​នៃ​មា​កោរាញ​ឞ្រាស លោច​ជេស​ពាង់​គិច​នុមពាង់​អី​នៃ​នទឹ​អ៝ន់​អ៝ស​ម៝ន ដាៈ​ខាន់​ពាង់​ពាៈ​អ៝ន់​ឞូ​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ជេស​តឹម​ពាៈ​នទើ​ឆា​អី​រី ទឹង​លែៈ​ឞូនុយ្ស​គុ​ឆា​តា​នៃ​ហើម​ទាទេ ជេសរី​រាគូម​នទើ​រាមែស​ឆា​អី​នៃ​ហោម​គែស ១២ ឆាស ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","គែស​ទូ​នារ​ឞ្រាស​យេឆូ ​មឞើស​ឆើម​អេង តា​នៃ​គែស​មពោល​អ៝ស​ម៝ន​ទើម​គុ​នទ្រែល​ពាង់ ផូង​ប៝ន​លាន​មោ​គែស​អោស។ ឞ្រាស​យេឆូ ​អោប​មពោល​អ៝ស​ម៝ន​អី​នៃ៖ “លែៈ​ផូង​ប៝ន​លាន​លាស​គ៝ប់​ឞូ​ម៝ស?” ");
INSERT INTO cmok_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","មពោល​អ៝ស​ម៝ន​អើស៖ “អាបាៈ​លាស​មៃ​ជេង​យោហាន-​បាប់តែម ​អី​លែៈ​ទ៝ក់​រេស អាបាៈ​លាស​ជេង​អេលីយា ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ព្លឹ​តា​អ្យា អាបាៈ​ជឹត​លាស​មៃ​ជេង​ទូ​ហ្វេ​ឞូនុយ្ស​អី​អេង​អី​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​លែៈ​ទ៝ក់​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ឞ្រាស​យេឆូ ​អោប​ជឹត៖ “លាស​នទ្រី​ខាន់​មៃ​អែស គ៝ប់​ឞូ​ម៝ស​ខាន់​មៃ​លាស​មេស?” ពេត្រោស ​អើស៖ “មៃ​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ឞ្រាស​យេឆូ ​ឞ្វៃ មោ​អ៝ន់​អោស​ខាន់​ពាង់​ងក៝ច​នាវ​នៃ​មា​ឞូ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ពាង់​លាស៖ “នារ​ជឹត​នាប់​តៃ ឞ៝ល​លាស​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស គ៝ប់​មរា​គែស​នាវ​ជេរ​ជ៝ត់​ទុត​ហោ។ មពោល​ឞូ​រាញ មពោល​កោរាញ​ជាន​ឞ្រាស ផូង​នើម​នតី មអារ់​លើយ​គ៝ប់ នហ៝​មា​ងខឹត​លើយ។ យើន​មា​ត៝ត់​ពែ​នារ​ឞើស​កើយ​នៃ​គ៝ប់​ទ៝ក់​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ទឹង​លែៈ​ឞូនុយ្ស៖ “ឞូ​ម៝ស​ពាង់​អី​អុច​តឹង​គ៝ប់ អ៝ន់​មអារ់​លើយ​នទើ​ឆាក់​ពាង់​នើម​អុច ជេសរី​តូយ​ឆី​តឹម​រាកាង់​ពាង់​នើម​អ៝ន់​អាប់​នារ ជេង​គែស​នាវ​ខ្លៃ​អ្យាត់​ទឹង​លែៈ​នាវ​កោរាញ​ឞ្រាស​ដាៈ ឞ៝ល​លាស​ត៝ត់​ខឹត​ឆាក់​កាដោយ រី​មើ​ទើយ​តឹង​គ៝ប់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","យ៝រ​លាស​ឞូ​ម៝ស​អី​អុច​ព្រាប់​មា​នាវ​រេស​ពាង់​នើម ពាង់​អី​នៃ​មោ​គែស​អោស​នាវ​រេស​នហ៝​រ៝ យើន​មា​ឞូ​ម៝ស​ខឹត​យ៝រ​មា​តឹង​គ៝ប់ ពាង់​អី​នៃ​គែស​នាវ​រេស​នហ៝​រ៝​ងាន់​តា​នារ​ជឹត​នាប់​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","លាស​ទូ​ហ្វេ​ឞូនុយ្ស​ពាង់​គែស​ទឹង​លែៈ​នែស​នតូ​អ្យា​ជេង​ទ្រាប់​នទើ​ពាង់​នើម​ទាទេ តីស​មា​ឆាក់​ពាង់​នើម​ខឹត​រ៝ស​ហេង​មោ​គែស​អោស​នាវ​រេស​នហ៝​រ៝ លាស​នទ្រី​ម៝ស​នទើ​គែស​នាវ​ខ្លៃ​មា​ពាង់? ");
INSERT INTO cmok_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","លាស​ឞូ​ម៝ស​អី​ដីត​ព្រេង​មោ​ឞាញ់​មឞើស​តឹង​គ៝ប់ ដីត​ព្រេង​នាវ​គ៝ប់​នតី លាស​នទ្រី​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ដីត​ព្រេង​មោ​គឹត​នាល់​មា​ពាង់​អី​នៃ​ដ៝ង់ តា​នារ​គ៝ប់​ព្លឹ​វាច់​គែស​នាវ​អ្វែស​ច្រេក​លើប​គ៝ប់​នើម គែស​នអ៝ប់​មា​នាវ​អ្វែស​ច្រេក​លើប​ឞឹ​គ៝ប់ នទ្រែល​មា​នាវ​អ្វែស​ច្រេក​លើប​ផូង​តោង​ពារ់​ក្ល៝ស​អ្វែស។ ");
INSERT INTO cmok_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","គ៝ប់​មឞើស​អ៝ន់​មា​ខាន់​អៃ​មៃ​គឹត​នហេល​នានេៈ​ងាន់ គែស​ឞូនុយ្ស​អាបាៈ​តា​អ្យា​ពាង់​មោ​មរា​ខឹត​អោស ល៝រ​មា​ឆៃ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ក្លាប់​លាស​គែស​ផាម​នារ​ជេស​ឞ្រាស​យេឆូ ​ងើយ​នាវ​អី​នៃ ជេសរី​ពាង់​លែវ​ពេត្រោស  លែវ​យោហាន  នទ្រែល​មា​យាកើ  ហាវ​កាលើ​យោក​គៃ​មា​មឞើស​ឆើម។ ");
INSERT INTO cmok_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","នោក​ពាង់​មឞើស​ឆើម អី​មុស​មាត់​ពាង់​គែស​រាគ៝ល់ អាវ​ពាង់​ជេង​ងលាង​អាង​ច្រាត​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ទោ​មា​ឆៃ​ដ៝ង់​គែស​ឞារ​ហៃ​ឞូ​ក្លោ​ងើយ​នទ្រែល​ពាង់មោឆេ  នទ្រែល​មា​អេលីយា  ខាន់​ពាង់​អី​នៃ​ជេង​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ឞើស​កាល់​អែ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ឞារ​ហៃ​អី​នៃ​គែស​នាវ​អ្វែស​ច្រេក​លើប​ងាន់​តា​ខាន់​ពាង់ ខាន់​ពាង់​ងក៝ច​មា​នាវ​ឞ្រាស​យេឆូ ​ខឹត​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​ហោម​ដេៈ​នារ​ជឹត​នាប់​តៃ ខឹត​តឹង​នាវ​កោរាញ​ឞ្រាស​អុច។ ");
INSERT INTO cmok_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ល៝ង់​ពេត្រោស  នទ្រែល​មា​ឞារ​ហៃ​ឞាល់​ពាង់​នៃ​ហាក់​ឞិច​ទាទេ។ ត៝ត់​កាស​ឞិច​រី​ខាន់​ពាង់​ឆៃ​នាវ​អ្វែស​នាវ​ច្រេក​លើប​ឞ្រាស​យេឆូ  នទ្រែល​មា​ឆៃ​ឞារ​ហៃ​ឞូនុយ្ស​គុ​នទ្រែល​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ត៝ត់​មា​មោឆេ  នទ្រែល​មា​អេលីយា ​ទូ​លោស​ឞើស​ឞ្រាស​យេឆូ ​រី ពេត្រោស ​ងើយ​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញ ឞ៝ន់​គុ​តា​អ្យា​អ្វែស​ងាន់​មេ អ៝ន់​ហេន​ជាន​ពែ​មល៝ម់​ចូន ទូ​មល៝ម់​អ៝ន់​មា​មៃ ទូ​មល៝ម់​អ៝ន់​មា​មោឆេ  ទូ​មល៝ម់​ជឹត​អ៝ន់​មា​អេលីយា ”។ នាវ​ពេត្រោស ​ងើយ​អី​នៃ​ពាង់​នើម​មោ​អោស​គឹត​ឆាក់ ពាង់​ទាស​មា​ងើយ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","នោក​ពេត្រោស ​ហោម​អែ​ងើយ​នៃ គែស​តុក​ងកុម​ឞើស​លើ​ខាន់​ពាង់​រី ខាន់​ពាង់​ជេង​លាប់​គុ​តា​ត្រោម​តុក​ជាន​អ៝ន់​ខាន់​ពាង់​ក្លាច​ទាទេ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ជេសរី​តាង់​នតែស​ងើយ​តាៈ​ឞើស​តុក​នៃ៖ “ពាង់​អ្យា​ក៝ន​គ៝ប់ អី​គ៝ប់​លែៈ​កើយ្ស​ពាង់ អ្យាត់​នាវ​ពាង់​ទោ”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ជេស​តាង់​ងើយ​កើត​នៃ​ឆៃ​ឞ្រាស​យេឆូ ​ទូ​ហ្វេ​អេង​ទើម​គុ​តា​រី។ លែៈ​នាវ​អី​ឆៃ​នៃ​នើស ខាន់​ពាង់​មោ​អោស​ងក៝ច​អ៝ន់​មា​ឞូ​អេង​គឹត ត៝ត់​ជ៝ៈ​ឞើស​នាប់​មើ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ត៝ត់​អោយ​តៃ ឞ្រាស​យេឆូ  នទ្រែល​មា​មពោល​អ៝ស​ម៝ន​ពាង់​ជុរ​ឞើស​លើ​យោក​រី តា​នៃ​គែស​អ៝ក់​ឞូនុយ្ស​វាច់​រាន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ជេសរី​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​តា​ផូង​ឞូនុយ្ស​អ៝ក់​អី​នៃ​នតែរ​ក្វាល់​ឞ្រាស​យេឆូ ៖ “ហើយ​នើម​នតី! ទាន់​មៃ​យោៈ​នអាច​មា​ក៝ន​គ៝ប់​អើ យ៝រ​លាស​គ៝ប់​គែស​ទូ​ហ្វេ​ក៝ន​អ្យា​ទើម​មេ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","គែស​ឞ្រាស​អ្យើស​ង្វាយ​លើស​ពាង់​ទូ​តឹ​ទូ​តឹ អ៝ន់​ពាង់​នតែរ​មព៝ត់​ញឆ្ល៝ង់​ញឆ្លាង់​ងាន់ លោស​មពុញ​ទាក​ទីវ​តា​មឞូង ឆាក់​ជាន់​លោស​ឞុរ​លោស​មោរ ត៝ត់​មា​ពាង់​លែៈ​ហ្វារ់​ងាន់ រី​មើ​ឞ្រាស​អ្យើស​អី​រី​លោស​ទូ​នហ៝ម់​មេ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","មពោល​អ៝ស​ម៝ន​មៃ​លែៈ​គ៝ប់​ដាៈ​ដ៝ង់ ខាន់​ពាង់​នត្រុត​មោ​អោស​ទើយ​លោស”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ឞ្រាស​យេឆូ ​លាស​មា​ទឹង​លែៈ​ឞូនុយ្ស៖ “ហើយ​ឞូនុយ្ស​អ្យើស ឞូនុយ្ស​មោ​អ្យាត់! ទាស​ហោម​ជ៝ៈ​អ៝ន់​គ៝ប់​ញឆ្រោយ្ស​គុ​នទ្រែល​ខាន់​អៃ​មៃ​អី​ឞូនុយ្ស​ទាង់​ក៝? លែវ​ហ៝ម់​ក៝ន​មៃ​អី​នៃ​អា​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","នោក​ក៝ន​ពាង់​ឞ្រោៈ​អេ​ហ៝ៈ​ត៝ត់​អា​ឞ្រាស​យេឆូ  ឞ្រាស​អ្យើស​ងក្លឹ​ពាង់​ចោត​ញឆ្ល៝ង់​ញឆ្លាង់​រ៝។ ជេសរី​ឞ្រាស​យេឆូ ​មឞ្រាម​ឞ្រាស​អ្យើស​រី ជាន​ក៝ន​ពាង់​ឞាស លែវ​ពាង់​មា​ឞឹ​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","លែៈ​ឞូនុយ្ស​តា​នៃ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ទាទេ​ងាន់​ឆៃ​នាវ​ទើយ​កោរាញ​ឞ្រាស​កើត​នៃ។ ទោល​ទឹង​លែៈ​ខាន់​ពាង់​តា​នៃ​ហោម​ងក្ល៝ន់​អេង​តា​ឆាក់​រី​ទឹង​លែៈ​នទើ​ទើយ​អី​ឞ្រាស​យេឆូ ​ជាន​អី​នៃ ជេសរី​ពាង់​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“អ៝ន់​ខាន់​អៃ​មៃ​ញអោត​អ្យាត់​នាវ​អ្យា ងកាស​ឆាក់​លើយ​ច្វេល​អោស ឞើយ​ត៝ត់​ឞូ​ញជុន​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​តា​តី​ឞូនុយ្ស​ញុប”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ជេស​តាង់​នាវ​ឞ្រាស​យេឆូ ​រី​នើស មពោល​អ៝ស​ម៝ន​មោ​វ៝ត់​អោស​នាវ​ពាង់​លាស​នៃ យ៝រ​លាស​កោរាញ​ឞ្រាស​អេ​ហ៝ៈ​អ៝ន់​ខាន់​ពាង់​វ៝ត់​អោស ខាន់​ពាង់​ក្លាច​មោ​ឞាញ់​អោប​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","គែស​ទូ​នារ​មពោល​អ៝ស​ម៝ន​គុ​តឹម​រាលាច់​ឞាល់​មា​នាវ​ខាន់​ពាង់​អុច​គឹត​មា​មពោល​ខាន់​ពាង់​នើម ឞូ​ម៝ស​ពាង់​អី​ក្វ៝ង់​រាលាវ​ឞូ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","យើន​មា​ឞ្រាស​យេឆូ ​លែៈ​គឹត​នាវ​ខាន់​ពាង់​មឹន​នៃ ជេសរី​ពាង់​លែវ​ទូ​ហ្វេ​ក៝ន​ឆែ​ជេៈ​គុ​ទាច់​កេង​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ជេសរី​ពាង់​លាស៖ “ឞូ​ម៝ស​រ៝ម​ទូ​ហ្វេ​ក៝ន​ឆែ​ជេៈ​យ៝រ​មា​អុច​អ្យាត់​នាវ​គ៝ប់ តឹម​ឞាន​មា​រ៝ម​គ៝ប់​នើម​ដ៝ង់។ ជេសរី​ឞូ​ម៝ស​ពាង់​អី​រ៝ម​គ៝ប់​តឹម​ឞាន​មា​រ៝ម​ឞឹ​គ៝ប់​អី​តើម​ញជ្វាល់​គ៝ប់​នើស​ដ៝ង់។ ឞូ​ម៝ស​ពាង់​អី​ជេៈ​តា​ន៝ម់​ឞូ​ទឹង​លែៈ​តា​មពោល​ខាន់​អៃ​មៃ ពាង់​អី​នៃ​ជេង​ក្វ៝ង់​រាលាវ​ឞូ”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ជេសរី​យោហាន ​មឞើស​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​នើម​នតី ហេន​ឆៃ​ទូ​ហ្វេ​ឞូនុយ្ស​នត្រុត​ឞ្រាស​អ្យើស​មា​ម៝ស​រាញា​មៃ។ ជេសរី​ហេន​ឞ្វៃ​ពាង់ យ៝រ​លាស​ពាង់​មោ​គែស​អោស​មពោល​ឞ៝ន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “លើយ​ឞ្វៃ​ពាង់​អោស ឞូ​ម៝ស​ពាង់​អី​មោ​តឹម​រាទ៝ង់​ដាស​ខាន់​អៃ​មៃ ឞូនុយ្ស​អី​នៃ​ជេង​មពោល​ឞាល់​មពែស​មា​ខាន់​អៃ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ត៝ត់​ឞើយ​ទី​នារ​ឞ្រាស​យេឆូ ​ហាវ​ឆឹត​តា​នតុក​កោរាញ​ឞ្រាស​តា​កាលើ ពាង់​ញឆ្រោយ្ស​ហាន់​ជឹត​ប៝ន​យេរូឆាលឹម ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​ជឹត​ទូ​ប៝ន​តា​ឞ្រី​ឆាមារី ពាង់​ដាៈ​ឞូនុយ្ស​អាបាៈ​ហាន់​ល៝រ​គៃ​មា​នទ្រាប់​នតុក​វើត​ទើន​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","តីស​មា​តា​ប៝ន​អី​នៃ​ឞូ​មោ​អោស​រ៝ម​ឞ្រាស​យេឆូ ​គុ​តា​រី យ៝រ​លាស​ខាន់​ពាង់​គឹត​ជេស​ឞ្រាស​យេឆូ ​អុច​ហាន់​នហ៝ត​ជឹត​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ។ ");
INSERT INTO cmok_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ត៝ត់​ខាន់​ពាង់​ឆៃ​កើត​នៃ ឞារ​ហៃ​អ៝ស​ម៝ន យាកើ  នទ្រែល​មា​យោហាន  ខាន់​ពាង់​លាស៖ “ហើយ​កោរាញមៃ​អុច​ឞើស អ៝ន់​ហេន​ក្វាល់​អុញ​តាៈ​កាលើ​ត្រោក​តុប​តា​ប៝ន​អ្យា ឆូ​លើយ​ផូង​អី​នៃ ជាន​កើត​អេលីយា ​ពាង់​ជាន​កាល់​អែ​នើស?” ");
INSERT INTO cmok_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ឞ្រាស​យេឆូ ​អ្វាញ់​ជឹត​ខាន់​ពាង់​នហ៝​មា​រាអ៝ត់​ខាន់​ពាង់៖ “ខាន់​មៃ​មោ​គឹត​ម៝ស​ហ្វេង​គុ​តា​ត្រោម​ឆាក់​ខាន់​មៃ‌ ");
INSERT INTO cmok_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","យ៝រ​លាស​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស តាៈ​ឞើស​កោរាញ​ឞ្រាស​វាច់ គៃ​មា​រាក្លាយ្ស​ឞូនុយ្ស មោ​អុច​អោស​លើស​ហេង​ឞូនុយ្ស”។ ជេសរី​លែវ​ឞាល់​នហ៝ត​ជឹត​ប៝ន​អេង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ទោល​ឞ្រាស​យេឆូ ​ឞ្រោៈ​រ៝ៈ​ត្រ៝ង​រី គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​លាស​មា​ពាង់៖ “ហើយ​កោរាញ អាស​នតុក​មៃ​ហាន់? គ៝ប់​ហាន់​តឹង​មៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ល៝ង់​ឆ្រ៝ត​គែស​ត្រោម​នតុក​ពាង់​គុ ឆ្យុម​នារ​គែស​រាឆ្វាន់​ដ៝ង់ តីស​មា​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​មោ​គែស​អោស​នតុក​គ៝ប់​នើម​ងាន់​មា​ទ៝ម់​ឞោក”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ទូ​ហ្វេ​ឞូនុយ្ស​អេង​ជឹត៖ “ហោៈ ហាន់​តឹង​គ៝ប់!” ឞូនុយ្ស​អី​នៃ​អើស៖ “ហើយ​កោរាញ អ៝ន់​គ៝ប់​ក៝ប់​ឞឹ​គ៝ប់​ខឹត នទ្រែល​មា​ត៝ប់​ពាង់​ប៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ឞូនុយ្ស​មោ​អ្យាត់​នាវ​គ៝ប់​តឹម​ឞាន​មា​ឞូនុយ្ស​លែៈ​ខឹត អ៝ន់​ខាន់​ពាង់​តឹម​ត៝ប់​អេង​នទ្រាង់​ខាន់​ពាង់​នើម មៃ​មា​ហាន់​មឞើស​នាវ​កោរាញ​ឞ្រាស​អុច​ម៝ត់​អ្វាញ់​ឞូនុយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ជឹត​លាស​មា​ពាង់​ដ៝ង់៖ “ហើយ​កោរាញ គ៝ប់​អុច​តឹង​មៃ​ដ៝ង់ យើន​មា​អ៝ន់​គ៝ប់​ហាន់​នតិញ​រានាក់​វ៝ល់​គ៝ប់​ប៝ត់”។ ");
INSERT INTO cmok_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ឞូ​ម៝ស​អី​ក្វាន់​ងគ៝ល់​ច្វ៝រ់ ជេសរី​ងគឹល​ជឹត​កើយ ឞូនុយ្ស​អី​នៃ​មោ​អោស​អ៝ន់​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​មា​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ជេស​ឞើស​កើយ​នៃ ឞ្រាស​យេឆូ ​កើយ្ស​ដ៝ង់​អ៝ស​ម៝ន ៧២ នុយ្ស ​ជឹត ជេសរី​ដាៈ​ខាន់​ពាង់​ហាន់​ល៝រ ហាន់​ឞារ​ហៃ​ឞារ​ហៃ អាប់​ប៝ន អាប់​នតុក​អី​ឞ្រាស​យេឆូ ​អុច​នទ្រាប់​ហាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ហើយ​អ៝ស​ម៝ន គែស​អ៝ក់​ឞូនុយ្ស​អុច​អ្យាត់​នាវ​មហែ​មហាន​អ្វែស ខាន់​ពាង់​តឹម​ឞាន​មា​ឞា​លែៈ​ទុម​អី​អ៝ក់​ងាន់ ឞូនុយ្ស​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស​តឹម​ឞាន​មា​ឞូនុយ្ស​រែក តីស​មា​ឞូនុយ្ស​អី​នៃ​ដេៈ​ទើម។ លាស​នទ្រី​ទាន់​កោរាញ​ឞ្រាស​នើម​អី​តើម​ឞា​នៃ​ញជ្វាល់​ឞូនុយ្ស​អា​អេង​ជឹត កើល​រែក​ឞា​ទុម​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","អ៝ន់​ខាន់​មៃ​ហាន់​ហ៝ម់ គ៝ប់​ដាៈ​ខាន់​មៃ​ហាន់​តឹម​ឞាន​មា​អ៝ន់​ក៝ន​ឞែ​ឞ្យាប់​គុ​តា​ងក្លាង​ផូង​ឆ៝​ឞ្រី។ ");
INSERT INTO cmok_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","គ៝ប់​ដាៈ​ខាន់​មៃ​ហាន់​ឆាក់​ទើម លើយ​ញអោត​ព្រាក់ លើយ​ចែង​ទុង លើយ​ញអោត​នតោ​ជ៝ត លាស​ម៝ប់​ឞូ​រ៝ៈ​ត្រ៝ង​លើយ​ងក៝ច​ឞ្រី​ជ៝ៈ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ម៝ស​ជៃ​អី​ខាន់​មៃ​លាប់​រី អ៝ន់​ខាន់​មៃ​លាស​កើត​នអា​ល៝រ៖ «ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​អ្វែស​លាង់​ដាប់​មពាន់​មា​ឞូនុយ្ស​គុ​តា​ជៃ​អ្យា»។ ");
INSERT INTO cmok_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","លាស​ឞូនុយ្ស​តា​ជៃ​អី​នៃ​រ៝ម​ខាន់​មៃ​អុច​នាវ​ដាប់​មពាន់ នាវ​ដាប់​មពាន់​អី​ខាន់​មៃ​ទាន់​នើស​គុ​តា​ជៃ​ពាង់​នៃ​រ៝។ លាស​ពាង់​មោ​អុច នាវ​ដាប់​មពាន់​អី​នៃ​មោ​ហោម​អោស​គុ​តា​ជៃ​ពាង់​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ជេសរី​គុ​តា​ជៃ​ពាង់​អី​នៃ​ហ៝ៈ លើយ​អោស​នត្រើន​ជៃ​អេង។ ញេត​ឆោង​លែៈ​នទើ​អី​ឞូ​អ៝ន់​មា​ខាន់​មៃ យ៝រ​លាស​នទើ​អី​នៃ​ជេង​នទើ​ឞូ​ងខោម​មា​ខាន់​មៃ ឞូនុយ្ស​នតុម​នតី​ឞូ​តឹម​ឞាន​មា​គែស​ជាន​ការ​មា​ឞូ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ម៝ស​ប៝ន​អី​ខាន់​មៃ​ហាន់​នៃ លាស​គែស​ឞូ​រ៝ម លែៈ​នទើ​អី​ឞូ​អ៝ន់​ឆា ខាន់​មៃ​ឆា​រ៝‌ ");
INSERT INTO cmok_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","នហ៝​មា​ជាន​ឞាស​នាវ​ជី​ឞូ។ ជេសរី​មឞើស​ងក៝ច​មា​ប៝ន​នៃ៖ «នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​អៃ​មៃ​លែៈ​ទាច់​មា​ខាន់​អៃ​មៃ​ងាន់​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","លាស​ឞូ​មោ​អោស​រ៝ម ប៝ន​អី​ខាន់​មៃ​លាប់​រី លោស​ហ៝ម់​ឞើស​នតុក​នៃ ហាន់​រ៝ៈ​ប៝ន​ខាន់​មៃ​លាស​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«ឞ៝ល​លាស​គែស​នែស​មោយ​នតុក​ប៝ន​ខាន់​អៃ​មៃ​ក្រេប​តា​ជ៝ង់​ហេន ហេន​រាតោស​លើយ​មា​ខាន់​អៃ​មៃ​នើម​ដ៝ង់ យើន​មា​អ៝ន់​ខាន់​អៃ​មៃ​គឹត​នាវ​អ្យា នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​អៃ​មៃ​លែៈ​ទាច់​ងាន់​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ខាន់​មៃ​គុ​អ្យាត់​នាវ​គ៝ប់​ប៝ត់ ឞូនុយ្ស​តា​ប៝ន​ឆោដុម ​អី​ជាន​តីស​ទុត​ហោ​កាល់​អែ​នើស នទ្រី​កោរាញ​ឞ្រាស​ទែ​លើស​ហេង​ខាន់​ពាង់​មា​អុញ​ឞើស​កាលើ​ត្រោក ខាន់​ពាង់​អី​នៃ​ហោម​អែ​គែស​ទោយ្ស​ថើល​មា​ដាស​ឞូនុយ្ស​តា​ប៝ន​អី​នៃ តា​នារ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​លាម​នែស​នតូ”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ជេសរី​ឞ្រាស​យេឆូ ​លាស​ជឹត៖ “រេស​រាញាល់​ងាន់​មា​ឞូនុយ្ស​គុ​តា​ប៝ន​ខោរាឆីន  នទ្រែល​មា​ប៝ន​បេតឆៃដា  យ៝រ​លាស​ខាន់​ពាង់​លែៈ​ឆៃ​ទឹង​លែៈ​នទើ​អ្វែស​នទើ​ខ្លៃ​គ៝ប់​ជាន តីស​មា​មោ​អោស​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស។ ឞូនុយ្ស​តា​ប៝ន​តីរុស  នទ្រែល​មា​តា​ប៝ន​ឆីដោន ​ជេង​ផូង​មោ​គឹត​នាល់​កោរាញ​ឞ្រាស លាស​ខាន់​ពាង់​ឆៃ​នាវ​ខ្លៃ​អី​នៃ ខាន់​ពាង់​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស​រ៝ ជេសរី​គៃ​មា​ញហើ​នាវ​ខាន់​ពាង់​លែៈ​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស ខាន់​ពាង់​ញឆ៝ស​ងគូត​បាវ​ច្យាត់ គុ​តា​អុញ​ឞុស។ ");
INSERT INTO cmok_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","នទ្រី​តា​នារ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​លាម​នែស​នតូ​តៃ ឞូនុយ្ស​តា​ប៝ន​ក្វ៝ង់​តីរុស  នទ្រែល​មា​តា​ប៝ន​ក្វ៝ង់​ឆីដោន  ខាន់​ពាង់​គែស​ទោយ្ស​ថើល​តា​ន៝ម់​ឞូនុយ្ស​គុ​តា​ប៝ន​ខោរាឆីន  ប៝ន​បេតឆៃដា ។ ");
INSERT INTO cmok_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ឞូនុយ្ស​គុ​តា​ប៝ន​កាពើនិម ​អី​ប៝ន​គ៝ប់​គុ​ជ៝ៈ​ខៃ នទ្រែល​មា​គ៝ប់​លែៈ​នតី​លែៈ​ជាន​នទើ​នាវ​ខ្លៃ លើយ​អោស​នអោន​លាស​ឆាក់​ខាន់​អៃ​មៃ​នើម​លែៈ​ជេង​ឞូនុយ្ស​អ្វែស​ហាវ​តា​ប៝ន​អ្វែស​កាលើ‌ មោ​អោស ខាន់​អៃ​មៃ​តៃ​តុប​តា​នតុក​រេស​រាញាល់​តា​នទ្រូង​អុញ​រី​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់​ដ៝ង់៖ “ឞូ​ម៝ស​ពាង់​អី​អ្យាត់​នាវ​ខាន់​មៃ តឹម​ឞាន​មា​អ្យាត់​នាវ​គ៝ប់​ដ៝ង់។ ឞូ​ម៝ស​អី​មោ​អ្យាត់​អោស​នាវ​ខាន់​មៃ តឹម​ឞាន​មា​មោ​អ្យាត់​នាវ​គ៝ប់​ដ៝ង់ ឞូ​ម៝ស​មោ​អ្យាត់​នាវ​គ៝ប់ តឹម​ឞាន​មា​មោ​អ្យាត់​ដ៝ង់​នាវ​កោរាញ​ឞ្រាស​នើម​អី​ញជ្វាល់​ដាៈ​គ៝ប់​ហាន់​តា​អ្យា​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ជេសរី​មពោល​អ៝ស​ម៝ន​អី ៧២ នុយ្ស​នៃ​ព្លឹ​ឆឹត​ឞើស​រី​រាម់​រាហើន ខាន់​ពាង់​ងក៝ច​នាវ​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញ យ៝រ​មា​ម៝ស​រាញា​ឆាក់​មៃ ឞ៝ល​លាស​ឞ្រាស​អ្យើស​អ្យាត់​នាវ​ហេន​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​លែៈ​ឆៃ​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​តុប​តាៈ​ឞើស​កាលើ​ត្រោក​តឹម​ឞាន​មា​លើប​ងលាយ្ស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","អ្យា​គ៝ប់​លែៈ​អ៝ន់​នាវ​ទើយ​មា​ខាន់​មៃ ខាន់​មៃ​ទើយ​ដាស​មា​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស នទ្រែល​មា​លែៈ​មពោល​អ្យើស​ពាង់​ដ៝ង់ ទើយ​ឞ្រោៈ​ជ៝ត​ឞេស នទ្រែល​មា​នទើរ​វីង មោ​គែស​អោស​ទូ​នតីល​នទើ​ជាន​អ្យើស​អ៝ន់​មា​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","លើយ​តា​រាម់​អោស​យ៝រ​មា​ឆៃ​ឞ្រាស​អ្យើស​អ្យាត់​នាវ​ខាន់​មៃ​នៃ​ទើម យើន​មា​អ៝ន់​ខាន់​មៃ​រាម់​មអាក​កោរាញ​ឞ្រាស​លែៈ​គែស​ញចីស​ឆាក់​ខាន់​មៃ​តា​កាលើ​ត្រោក​នតុក​ពាង់​នើម​គុ​រី​ហ៝ៈ នទ្រី​នារ​ជឹត​នាប់​តៃ​ខាន់​មៃ​គុ​នទ្រែល​កោរាញ​ឞ្រាស​នហ៝​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","នោក​នៃ​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​ជាន​អ៝ន់​ឞ្រាស​យេឆូ ​គែស​នូយ្ស​នហ៝ម់​រាម់​មអាក​ងាន់ ឞ្រាស​យេឆូ ​លាស​កើត​នអា៖ “ហើយ​ឞឹ អី​កោរាញ​មា​ត្រោក នទ្រែល​មា​នែស​នតូ គ៝ប់​រានេ​មៃ​ហោ​ងាន់ យ៝រ​លាស​មៃ​លែៈ​ញហើ​នាវ​មៃ​នតើម​ម៝ត់​អ្វាញ់​ឞូនុយ្ស​អ្យា​អ៝ន់​មា​ឞូនុយ្ស​រាលូក​ម៝ល់​មោ​វ៝ត់​តឹម​ឞាន​មា​ក៝ន​ឆែ ជេសរី​ពោន​នទ៝ប់​លើយ​នទើ​អី​នៃ​មា​ឞូនុយ្ស​អី​កើប​អេង​ឆាក់​ខាន់​ពាង់​នើម​ជេង​ឞូនុយ្ស​គឹត​ឞូនុយ្ស​ឞ្លាវ។ ហើយ​ឞឹ នូយ្ស​នហ៝ម់​មៃ​អុច​កើត​នអា​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ជេសរី​ពាង់​លាស​ជឹត៖ “ទឹង​លែៈ​នតីល​នទើ លែៈ​ឞឹ​ជាវ​មា​គ៝ប់​ទាទេ​ជេស។ មោ​គែស​អោស​ឞូនុយ្ស​គឹត​នាល់​គ៝ប់​លាស​អី​ក៝ន​កោរាញ​ឞ្រាស គែស​ឞឹ​គ៝ប់​នើម​ទើម​គឹត​នាល់ មោ​គែស​អោស​ឞូនុយ្ស​គឹត​នាល់​ឞឹ​ងាន់​គ៝ប់ គែស​គ៝ប់​អី​ក៝ន​ពាង់​ទើម​គឹត​នាល់ នទ្រែល​មា​ទឹង​លែៈ​ឞូនុយ្ស​អី​គ៝ប់​អុច​អ៝ន់​គឹត​នាល់ ទូ​រី​ទើម”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","នោក​មោ​គែស​អោស​ឞូនុយ្ស​អា​អេង​គុ​តា​រី ឞ្រាស​យេឆូ ​ងើយ​ដាស​មពោល​អ៝ស​ម៝ន​ទើម ពាង់​លាស៖ “អ្វែស​មអាក​ងាន់​មា​ខាន់​អៃ​មៃ យ៝រ​លាស​មាត់​ខាន់​អៃ​មៃ​ឆៃ​ទឹង​លែៈ​នាវ​គ៝ប់​លែៈ​ជាន។ ");
INSERT INTO cmok_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ គែស​អ៝ក់​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស នទ្រែល​មា​អ៝ក់​កាដាច់​ផូង​អីឆ្រាអែល ​កាល់​អែ​នើស​អុច​ឆៃ​ងាន់​ទឹង​លែៈ​នាវ​អី​ខាន់​អៃ​មៃ​លែៈ​ឆៃ​អាបៃ​អ្យា តីស​មា​មោ​ឆៃ​អោស ខាន់​ពាង់​អុច​តាង់​ងាន់​នាវ​អី​ខាន់​អៃ​មៃ​លែៈ​តាង់​អ្យា តីស​មា​មោ​តាង់​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","នោក​នៃ​គែស​ទូ​ហ្វេ​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  ពាង់​ទ៝ក់​អុច​អោប​រាល៝ង​ឞ្រាស​យេឆូ ៖ “ហើយ​នើម​នតី មើម​អ៝ន់​គ៝ប់​ជាន​គៃ​មា​គែស​នាវ​រេស​នហ៝​រ៝​មេស?” ");
INSERT INTO cmok_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “ម៝ស​បាៈ​គែស​នាវ​មោឆេ ​ញចីស​តា​ឆ៝ម់បុត​នាវ​វៃ​កាល់​អែ​នៃ​នើស? ទោល​មៃ​អ្វាញ់ ម៝ស​បាៈ​មៃ​វ៝ត់?” ");
INSERT INTO cmok_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ឞូនុយ្ស​អី​នៃ​អើស​មា​ឞ្រាស​យេឆូ ៖ “«អ៝ន់​រ៝ង់​មា​កោរាញ​ឞ្រាស​អី​ឞ្រាស​ខាន់​អៃ​មៃ​នើម​មា​លែៈ​នូយ្ស​នហ៝ម់ មា​លែៈ​ហ្វេង មា​លែៈ​នហ៝ម់​ឆ្វាន នទ្រែល​មា​លែៈ​នាវ​មឹន» ជេសរី «រ៝ង់​មា​ឞូ​ច្យៅ​មែង​កើត​រ៝ង់​មា​ឆាក់​មៃ​នើម​ដ៝ង់»”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “នាវ​មៃ​អើស​អី​នៃ​ជេង​ទី​ងាន់ អ៝ន់​មៃ​ជាន​កើត​នាវ​នៃ​បាបើ នទ្រី​មើ​នារ​ជឹត​នាប់​តៃ​មៃ​មរា​គែស​នាវ​រេស​នហ៝​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","យើន​មា​ឞូនុយ្ស​អី​នៃ​អុច​ញហើ​នាវ​អោប​ពាង់​នើម​ជេង​នាវ​អោប​ទី មោ​អោស​អោប​រាល៝ង​ទើម ជេសរី​អោប​ឞ្រាស​យេឆូ ​ជឹត៖ “លាស​នទ្រី​ឞូ​ម៝ស​ជេង​ឞូ​ច្យៅ​មែង​គ៝ប់​មេស?” ");
INSERT INTO cmok_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ឞ្រាស​យេឆូ ​អើស​មា​ពាង់​មា​នាវ​ងើយ​នតឹត៖ “គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​លោស​ឞើស​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  ហាន់​ជឹត​ប៝ន​យេរីខោ ​រី។ រ៝ៈ​ត្រ៝ង​នៃ​ពាង់​ម៝ប់​មា​មពោល​នតុង ឞូ​លើស​ពាង់​ត៝ត់​ខឹត​យើស ឆ៝ៈ​លែៈ​ទ្រាប់​នទើ​ឆ៝ៈ​ខ៝​អាវ​ពាង់​ដ៝ង់ ជេសរី​លែវ​ឞាល់​ញច្វាត់​លែៈ​រាងាត់ នត្លើយ​អេង​អោឞាល់​តា​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ជេសរី​គែស​ទូ​ហ្វេ​តា​មពោល​ជាន​ឞ្រាស​ហាន់​រ៝ៈ​ត្រ៝ង​នៃ មពោល​អី​នៃ​ឞ្លាវ​ងាន់​តា​នាវ​វៃ​ផូង​ឞ៝ន់។ ត៝ត់​មា​ឆៃ​ឞូនុយ្ស​រាមាញ​អី​នៃ ពាង់​ហាន់​ទែរ។ ");
INSERT INTO cmok_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ជេសរី​គែស​ដ៝ង់​ទូ​ហ្វេ​មពោល​លេវី  មពោល​អី​នៃ​ជេង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ ពាង់​ហាន់​ត៝ត់​តា​នៃ​ឆៃ​ឞូនុយ្ស​រាមាញ​អី​នៃ នហ៝​មា​ហាន់​ទែរ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ងខេប​ងាន់​គែស​ទូ​ហ្វេ​មពោល​ឞ្រី​ឆាមារី ​ហាន់​រ៝ៈ​ត្រ៝ង​នៃ​ដ៝ង់ ជេង​ឞូនុយ្ស​អី​ផូង​ឞ៝ន់​មឺច​រាម៝ត​ហោ​ងាន់ មពោល​ពាង់​មោ​អោស​ឞ្លាវ​តា​នាវ​វៃ​ផូង​ឞ៝ន់។ ត៝ត់​មា​ឆៃ​ឞូនុយ្ស​រាមាញ​អី​នៃ ហោ​ងាន់​ពាង់​គែស​នាវ​យោៈ​គែស​នាវ​នអាច​មា​ឞូនុយ្ស​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ពាង់​ហាន់​ទាច់​ជឹត​ឞូនុយ្ស​រាមាញ​នៃ ពាង់​ឆ៝ៈ​ទាក​ងី ឆ៝ៈ​នទ្រាញ់​ពាង់​នើម​ឞើស​អ្យា​ត៝ៈ​កាលើ​ឆោត​ឞូនុយ្ស​អី​នៃ ឆើម​ពូត​ឆោត​ពាង់​រី ជេសរី​ពឺ​តេៈ​កាលើ​ឆែស​លៀ​ពាង់​ញច៝​រី លែវ​ហាន់​តា​ជៃ​វែស​ឞិច​ឞូ​នាច់។ ត៝ត់​តា​នៃ​ពាង់​ម៝ត់​អ្វាញ់​ឞូនុយ្ស​អី​នៃ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","កាស​អោយ​តៃ​ពាង់​អ៝ន់​ឞារ​មល៝ម់​ព្រាក់​កាក់​មា​តើម​ជៃ​នៃ ងក្រែ​មា​នតិញ​ពាង់៖ «ដាៈ​មៃ​ឆើម​ម៝ត់​ឆាម់​ឞូនុយ្ស​អ្យា លាស​លែៈ​ទ៝ង់​រាលាវ​ឞើស​ព្រាក់​គ៝ប់​អ៝ន់​អ្យា ត៝ត់​គ៝ប់​ព្លឹ​តៃ គ៝ប់​កើយ​អ៝ន់​រឹង​មា​មៃ»។ ");
INSERT INTO cmok_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","លាស​នទ្រី​លែៈ​ពែ​នុយ្ស​ខាន់​ពាង់​អី​នៃ ឞូ​ម៝ស​មៃ​មឹន​ជេង​ឞូនុយ្ស​ច្យៅ​មែង​ដាស​មា​ឞូនុយ្ស​មពោល​នតុង​នៃ​លើស​មេស?” ");
INSERT INTO cmok_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","នើម​នតី​នៃ​អើស៖ “ជេង​ឞូនុយ្ស​អី​គែស​នាវ​យោៈ​នអាច​មា​ពាង់​អី​នៃ”។ ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “អ៝ន់​មៃ​ហាន់​ជាន​តឹង​កើត​ពាង់​អី​ទូ​ហ្វេ​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","ជេសរី​ឞ្រាស​យេឆូ  នទ្រែល​មា​អ៝ស​ម៝ន​ពាង់​ហាន់​ជឹត លាប់​តា​ទូ​ប៝ន តា​ប៝ន​នៃ​គែស​ឞារ​ហៃ​អ៝ស​នូរ​រាញា​ខាន់​ពាង់​មាថា  នទ្រែល​មា​មារី  ជេសរី​មាថា ​ជាៈ​ឞ្រាស​យេឆូ ​លាប់​គុ​តា​ជៃ​ពាង់។ ត៝ត់​តា​ជៃ​នៃ​មារី ​អី​អ៝ស​រី​គុ​អ្យាត់​នាវ​ឞ្រាស​យេឆូ ​នតី ពាង់​គុ​កេង​ជ៝ង់​ឞ្រាស​យេឆូ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ល៝ង់​មាថា ​ឞ៝ប់​ហោ​ងាន់​មា​នទ្រាប់​ព្យាង់​ត្រាវ ជេសរី​ពាង់​ហាន់​មឞើស​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញមៃ​មោ​គឹត​ឞើស អ៝ស​គ៝ប់​ប៝ង់​អេង​គ៝ប់​ជាន​ការ​ទូ​ហ្វេ​អេង​ទើម? មៃ​មឞើស​ដាៈ​ពាង់​កើល​គ៝ប់​បាៈ​ហែស”។ ");
INSERT INTO cmok_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “អើ​អ៝ស​មាថា  អ៝ស​មាថា ​អើយ! អៃ​រាង៝ត​រាវៃ​មា​នទើ​អេងៗ​អ៝ក់​ងាន់‌ ");
INSERT INTO cmok_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","យើន​មា​គែស​ទូ​នាវ​ការ​ទើម​គែស​នាវ​ខ្លៃ អ៝ស​អៃ​លែៈ​កើយ្ស​ជេស​ការ​នាវ​ខ្លៃ​អី​នៃ ជេង​ពាង់​អ្យាត់​នាវ​គ៝ប់​នតី។ នាវ​អី​នៃ​ឞូ​មោ​អោស​ឞ្លាវ​ឆ៝ៈ​ឞើស​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","គែស​ទូ​នារ​ឞ្រាស​យេឆូ ​មឞើស​ឆើម​តា​ទូ​នតុក។ ជេស​ពាង់​មឞើស​ឆើម​រី គែស​ទូ​ហ្វេ​អ៝ស​ម៝ន​លាស​មា​ពាង់៖ “ហើយ​កោរាញ ដាៈ​មៃ​នតី​អ៝ន់​ហេន​ឞ្លាវ​មឞើស​ឆើម​បាៈ​អើ កើត​យោហាន-​បាប់តែម ​នតី​មា​មពោល​អ៝ស​ម៝ន​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “អ៝ន់​ខាន់​អៃ​មៃ​មឞើស​ឆើម​កើត​នអា៖ «អើ​ឞឹ​គុ​តា​កាលើ​ត្រោក‌ អ៝ន់​ទឹង​លែៈ​ឞូនុយ្ស​យើក​មឞាស​មា​មៃ ទាន់​ទឹង​លែៈ​នាវ​តា​នែស​នតូ​អ្យា​តឹង​នាវ​មៃ​អុច តឹម​ឞាន​មា​នាវ​មៃ​នើម​លែៈ​អុច​តា​កាលើ​ត្រោក​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","អ៝ន់​នទើ​ឆោង​ឆា​មា​ហេន​អាប់​នារ​អ៝ន់​ត៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","យោៈ​នអាច​លើយ​ហោម​កើប​នាវ​តីស​ហេន តឹម​ឞាន​មា​ហេន​យោៈ​នអាច​មា​ឞូនុយ្ស​ជាន​តីស​មា​ហេន មោ​ហោម​កើប​នាវ​តីស​ពាង់​ដ៝ង់។ កើល​ហេន​លើយ​អោស​ជាន​តីស នោក​ហេន​គែស​នាវ​នទើម ទាន់​រាក្លាយ្ស​ហេន​ឞើស​នាវ​អ្យើស​មហឹក»”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ជេសរី​ឞ្រាស​យេឆូ ​លាស​ដ៝ង់​មា​មពោល​អ៝ស​ម៝ន​នៃ៖ “តា​មពោល​ខាន់​អៃ​មៃ លាស​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ឞ្រោៈ​តា​ជៃ​មឹត​ជាង់​ងគូល​ផុត​ងគូល​មាង់ ពាង់​ក្វាល់៖ «ហើយ​ជាង់ អ៝ន់​គ៝ប់​មាញ​នទើ​ឆោង​ឆា​អាបាៈ​ប៝ត់​អើ‌ ");
INSERT INTO cmok_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","យ៝រ​លាស​គ៝ប់​គែស​ជាង់​មហែ​ត៝ត់​តាៈ​ឞើស​ងាយ​លាស។ គ៝ប់​មោ​គែស​នទើ​មា​អ៝ន់​ពាង់​ឆោង​ឆា​មេ»។ ");
INSERT INTO cmok_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ខាន់​អៃ​មៃ​លាស ឞូនុយ្ស​តា​ត្រោម​ជៃ​នៃ​អើស​មា​ពាង់​កើត​នអា​បាស?៖ «លើយ​ហោម​រាខ្វាក​គ៝ប់​ហ្យា មពោង​លែៈ​ជេស​រាដាង់ អ៝ស​ក៝ន​គ៝ប់​លែៈ​ឞិច​ដ៝ង់ គ៝ប់​មោ​ទើយ​ទ៝ក់​ឆ៝ៈ​អ៝ន់​មា​មៃ​ជាង់​មេ»។ ");
INSERT INTO cmok_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","មោ​ទី​នទ្រី​អោស។ គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ ឞូនុយ្ស​តើម​ជៃ​នៃ​មរា​ទ៝ក់​នទឹ​រ៝ នទ្រែល​មា​អ៝ន់​ម៝ស​នទើ​អាបាៈ​អេង​ជឹត​មឹត​ជាង់​ពាង់​អុច។ ពាង់​ទ៝ក់​នទឹ​នៃ យ៝រ​លាស​ឞូនុយ្ស​អី​នៃ​ឞាញ់​រាខ្វាក​ពាង់​មោ​ឞ្លាវ​ទុត មោ​អោស​យ៝រ​មា​ជេង​មឹត​ជាង់​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","កើត​នទ្រី​គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ ទាន់​មរ៝​មរាង់​ហ៝ម់​មា​កោរាញ​ឞ្រាស​ទឹង​ពាង់​អ៝ន់​មា​ខាន់​អៃ​មៃ ជ៝យ​មរ៝​មរាង់​ហ៝ម់​ទឹង​ឆៃ ក្វាល់ ​មរ៝​មរាង់​ហ៝ម់​ឞើស​ទីស​មពោង​ទឹង​កោរាញ​ឞ្រាស​ពើក​អ៝ន់​មា​ខាន់​អៃ​មៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","យ៝រ​លាស​ឞូ​ម៝ស​ទាន់​មរា​គែស ឞូ​ម៝ស​ជ៝យ​មរា​ឆៃ ជេសរី​ឞូ​ម៝ស​អី​ក្វាល់​ឞើស​ទីស​មពោង​មរា​ពើក​អ៝ន់​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","តា​មពោល​ខាន់​អៃ​មៃ​វៃ​គែស​ដ៝ង់ លាស​ក៝ន​ទាន់​ព្យាង់​អ៝ន់​ងខើង​លុ​មា​ពាង់? លាស​ក៝ន​ទាន់​កា ឞឹ​ពាង់​អ៝ន់​ងខើង​ឞេស​គែស​កាច់​មា​ពាង់​ឞើស? ");
INSERT INTO cmok_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","មោ​លាស​ក៝ន​ទាន់​តាប់​អ្យារ់​អ៝ន់​ងខើង​នទើរ​វីង​មា​ពាង់? ");
INSERT INTO cmok_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ឞ៝ល​លាស​ខាន់​អៃ​មៃ​ជេង​ឞូនុយ្ស​តីស​កាដោយ ខាន់​អៃ​មៃ​ហោម​ឞ្លាវ​អ៝ន់​នទើ​អ្វែស​មា​ក៝ន​ដ៝ង់ លាស​នទ្រី​ឞឹ​គុ​តា​កាលើ​ត្រោក​រាលាវ​ឞើស​នៃ​អ៝ន់​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​មា​ឞូ​ម៝ស​ទាន់​ឞើស​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ឞ្រាស​អ្យើស​លាប់​អ៝ន់​ពាង់​មល៝ ត៝ត់​ទូ​នារ​រី​ឞ្រាស​យេឆូ ​នត្រុត​ឞ្រាស​អ្យើស​អី​នៃ​លោស​ឞើស​ពាង់ ជេសរី​ពាង់​ឞ្លាវ​ងើយ​រ៝។ ឞូនុយ្ស​គុ​តា​នៃ​អ៝ក់​ងាន់។ ត៝ត់​ឆៃ​នាវ​អី​នៃ​ទឹង​លែៈ​ខាន់​ពាង់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ទាទេ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","យើន​មា​គែស​ឞូ​អាបាៈ​លាស៖ “យ៝រ​លាស​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​អ៝ន់​នាវ​ទើយ​តា​ពាង់ ទឹង​ពាង់​ទើយ​នត្រុត​ឞ្រាស​អ្យើស”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","គែស​ឞូ​អាបាៈ​ជឹត​អុច​រាល៝ង​ឞ្រាស​យេឆូ ​ទើម ដាៈ​ពាង់​ជាន​ទូ​នាវ​មឞេន​គៃ​មា​ញហើ​នាវ​ទើយ​ពាង់​តាៈ​ឞើស​កោរាញ​ឞ្រាស​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","យើន​មា​ឞ្រាស​យេឆូ ​លែៈ​គឹត​ជេស​នាវ​ខាន់​ពាង់​មឹន ជេសរី​ពាង់​លាស៖ “ទឹង​លែៈ​ឞ្រី​អី​គែស​នាវ​តឹម​ល៝ក់​តឹម​ជាញ​ចាស​ច្រាយ​ឞាល់ ឞ្រី​អី​នៃ​រ៝ស​ហេង​រ៝។ ទឹង​លែៈ​រានាក់​អី​គែស​នាវ​តឹម​ល៝ក់​តឹម​ជាញ​នទ្រាង់​នើម រានាក់​អី​នៃ​រ៝ស​ហេង​មោ​ហោម​គែស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","លាស​គ៝ប់​នត្រុត​ឞ្រាស​អ្យើស​តាៈ​ឞើស​នាវ​ទើយ​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស ឞ្រាស​អ្យើស​គែស​នាវ​តឹម​រាលាច់​តឹម​ជាញ​ចាស​ច្រាយ​ឞាល់ លាស​នទ្រី​មើម​ទឹង​ហោម​គែស​ឞ្រី​ជឹត? គ៝ប់​ងើយ​កើត​នអា យ៝រ​លាស​ខាន់​មៃ​លាស​គ៝ប់​នត្រុត​ឞ្រាស​អ្យើស​យ៝រ​មា​ឆាតាង់ ​អ៝ន់​នាវ​ទើយ​មា​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","លាស​គ៝ប់​នត្រុត​ឞ្រាស​អ្យើស​យ៝រ​មា​នាវ​ទើយ​ឆាតាង់ ​ងាន់ ឞើស​តាៈ​នាវ​ទើយ​អ៝ស​ម៝ន​ខាន់​មៃ​នត្រុត​ឞ្រាស​អ្យើស​ដ៝ង់? លាស​នទ្រី​អ៝ស​ម៝ន​ខាន់​មៃ​នើម​អី​នៃ​មរា​តេៈ​ទោយ្ស​ខាន់​មៃ​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","យើន​មា​លាស​នាវ​ទើយ​គ៝ប់​នត្រុត​ឞ្រាស​អ្យើស​តាៈ​ឞើស​កោរាញ​ឞ្រាស លាស​នទ្រី​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​មា​ខាន់​មៃ​លែៈ​ត៝ត់​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","លាស​ឞូនុយ្ស​ទាង់​ញអោត​តាក​ញអោត​ដាវ គុ​ញជ្រាង់​ញីស​ជៃ​ពាង់​នើម លាស​នទ្រី​ទ្រាប់​នទើ​ពាង់​ហោម​កើន។ ");
INSERT INTO cmok_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","យើន​មា​លាស​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ជឹត​ទាង់​រាលាវ​ពាង់ តឹម​លើស​ទើយ​ឞូ ឞូ​មរា​ឆ៝ៈ​តាក​ដាវ​ពាង់​អី​នៃ នទ្រែល​មា​ឆ៝ៈ​ទ្រាប់​នទើ​ពាង់​ពាៈ​អ៝ន់​មា​ឞូនុយ្ស​អេង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ឞូ​ម៝ស​អី​មោ​គុ​មពែស​មា​គ៝ប់ ឞូនុយ្ស​អី​នៃ​តឹម​រាទ៝ង់​ដាស​គ៝ប់ ឞូ​ម៝ស​អី​មោ​គុ​គូម​នទ្រែល​គ៝ប់ ឞូនុយ្ស​អី​នៃ​ចាស​ច្រាយ​ញហីង​ញហាង”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“លាស​ឞ្រាស​អ្យើស​លោស​ឞើស​ទូ​ហ្វេ​ឞូនុយ្ស ជេសរី​ពាង់​ឞ្រោៈ​រ៝ៈ​ឞ្រី​រាទាស ពាង់​ជ៝យ​នតុក​មា​គុ​មោ​គែស​អោស ជេសរី​ពាង់​មរា​លាស​អេង​កើត​នអា៖ «គ៝ប់​ព្លឹ​គុ​តា​ជៃ​អើម​គ៝ប់​នតុក​គ៝ប់​មហែ​លោស​នើស​ប៝ត់»។ ");
INSERT INTO cmok_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ត៝ត់​ពាង់​ព្លឹ​តា​នៃ ឆៃ​ជៃ​អី​នៃ​លែៈ​មពេស​អ្វែស នទ្រាប់​អ្យាហែប‌ ");
INSERT INTO cmok_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ជេសរី​ពាង់​ហាន់​ជាៈ​ឞ្រាស​អ្យើស​អា​អេង​ពើស​អឹ​ជឹត ឞ្រាស​អ្យើស​អី​នៃ​ជាញ​រាលាវ​ពាង់​ងាន់ ហាន់​លាប់​គុ​នទ្រែល​តា​នៃ​ដ៝ង់ ជាន​អ៝ន់​ឞូនុយ្ស​អី​នៃ​គែស​នាវ​ជេរ​អ្យើស​រាលាវ​អើម​នើស​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ទោល​ឞ្រាស​យេឆូ ​ហោម​ងើយ​នាវ​នៃ គែស​ទូ​ហ្វេ​ឞូ​អូរ​តា​ផូង​ឞូនុយ្ស​អ៝ក់​នៃ​លាស៖ “ឞូ​អូរ​អី​ទែស​មៃ អី​មពូ​មៃ​មា​ត៝ស ឞូ​អូរ​អី​នៃ​លាប​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","យើន​មា​ឞ្រាស​យេឆូ ​អើស៖ “ឞូនុយ្ស​អី​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ងើយ នហ៝​មា​តឹង​កើត ពាង់​អី​នៃ​លាប​អ៝ក់​រាលាវ”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ជេសរី​ឞូនុយ្ស​គុ​គូម​លើ​មា​អ៝ក់​ងាន់ ឞ្រាស​យេឆូ ​លាស​មា​ផូង​អី​នៃ៖ “ឞូនុយ្ស​តា​រានោក​អាបៃ​រី​អ្យើស​មហឹក​ហោ​ងាន់ អុច​ឆៃ​មា​នាវ​មឞេន​ទើម យើន​មា​កោរាញ​ឞ្រាស​មោ​អោស​អ៝ន់​នាវ​មឞេន​អេង​ជឹត ពាង់​អ៝ន់​ទូ​នាវ​មឞេន​តឹម​ឞាន​មា​នាវ​មឞេន​យោនាយ្ស ​អី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","យោនាយ្ស ​ជេង​នាវ​មឞេន​មា​ប៝ន​នីនីវេ ​ឆៃ នទ្រី​តា​នារ​ជឹត​នាប់​តៃ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ជេង​នាវ​មឞេន​តា​រានោក​អាបៃ​អ្យា​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","តា​នារ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​ទឹង​លែៈ​ឞូនុយ្ស​តា​នែស​នតូ គែស​កាដាច់​ឞូ​អូរ​រាញា​ពាង់​ឆេបា  ពាង់​មរា​តេៈ​ទោយ្ស​មា​ឞូនុយ្ស​រានោក​អាបៃ​អ្យា។ កាល់​អែ​នើស​ពាង់​កាដាច់​តា​ឞ្រី​អេង​ងាយ​មពែស​ឞើស​ទ៝ង់​ឞ្រី​អីឆ្រាអែល  ឞ៝ល​លាស​ពាង់​គុ​ងាយ​ទុត​ឞ្រី​ទុត​នែស​កាដោយ ពាង់​ហាន់​តា​ឞ្រី​អីឆ្រាអែល ​គៃ​មា​អ្យាត់​នាវ​មឹន​គឹត​ឞ្លាវ​កាដាច់​ឆាលោមោន ​តា​ឞ្រី​អ្យា។ យើន​មា​នារ​អ្យា​តា​នតុក​អ្យា​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​នាវ​ងើយ​ពាង់​ខ្លៃ​រាលាវ​នាវ​ងើយ​កាដាច់​ឆាលោមោន  តីស​មា​ខាន់​អៃ​មៃ​មោ​អុច​អោស​អ្យាត់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","តា​នារ​កោរាញ​ឞ្រាស​ផាត​ទោយ្ស​ទឹង​លែៈ​ឞូនុយ្ស​តា​នែស​នតូ​អ្យា ឞូនុយ្ស​ប៝ន​នីនីវេ ​មរា​តេៈ​ទោយ្ស​ឞូនុយ្ស​តា​រានោក​អាបៃ​អ្យា​ដ៝ង់ យ៝រ​លាស​រានោក​កាល់​អែ​នើស ជេស​ខាន់​ពាង់​តាង់​នាវ​យោនាយ្ស ​មឞើស ខាន់​ពាង់​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស​រ៝ ខាន់​ពាង់​រាង៝ត​លែៈ​លាន់​នាវ​ខាន់​ពាង់​ជាន​តីស​នើស យើន​មា​តា​អ្យា​អាបៃ​អ្យា​គែស​ដ៝ង់​ទូ​ហ្វេ​ឞូនុយ្ស​ក្វ៝ង់​រាលាវ​មា​យោនាយ្ស ​នៃ​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ឞ្រាស​យេឆូ ​នតី​ជឹត៖ “មោ​គែស​អោស​ឞូនុយ្ស​មពេស​អុញ​ឆាគេង ជេសរី​ពោន​តា​ក្វឹល មោ​លាស​កុប​លើយ​ដាស​ឆាស​ឞើស​លើ។ ឞូ​វៃ​មពេស​ឆាគេង​យោង​តា​កាលើ គៃ​មា​អាង​លែៈ​ឞូនុយ្ស​អី​លាប់​តា​ត្រោម​ជៃ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ត្រោម​មាត់​ខាន់​អៃ​មៃ​ជេង​តឹម​ឞាន​មា​ឆាគេង​មា​ឆាក់​ជាន់ លាស​ត្រោម​មាត់​ខាន់​អៃ​មៃ​ហោម​អាង​អ្វែស លែៈ​ឆាក់​ជាន់​ខាន់​អៃ​មៃ​ហោម​អាង​ទាទេ យើន​មា​លាស​ត្រោម​មាត់​ខាន់​អៃ​មៃ​លែៈ​ង៝​ជេស លែៈ​ឆាក់​ជាន់​ខាន់​អៃ​មៃ​ជេង​ង៝​ទាទេ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","កើត​នអៃ​អ៝ន់​ខាន់​អៃ​មៃ​ឞ្លាវ​ញជ្រាង់ លើយ​អ៝ន់​ខាន់​អៃ​មៃ​កើប​អេង​នាវ​អាង ជេសរី​ឞូ​មោ​អោស​ឆៃ​នាវ​អាង ឆៃ​នាវ​ង៝​ច្រាវ។ ");
INSERT INTO cmok_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","លាស​លែៈ​ឆាក់​ជាន់​ខាន់​អៃ​មៃ​ហោម​អាង​ទាទេ មោ​អោស​គែស​នតុក​ង៝ លាស​នទ្រី​លែៈ​នាវ​រេស​ខាន់​អៃ​មៃ​គែស​អាង​ទាទេ តឹម​ឞាន​មា​អុញ​ឆាគេង​ងអាង​ខាន់​អៃ​មៃ​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ជេស​ឞ្រាស​យេឆូ ​ងើយ​នៃ គែស​ទូ​ហ្វេ​ផូង​ផារីឆី ​ជាៈ​ឞ្រាស​យេឆូ ​ហាន់​ឆោង​ឆា​តា​ជៃ​ពាង់​រី។ ឞ្រាស​យេឆូ ​ហាន់​ត៝ត់​តា​នៃ​គុ​ឆោង​ឆា​នទ្រែល​តា​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ឞូនុយ្ស​ផារីឆី ​អី​នៃ​គែស​នាវ​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់​ឆៃ​ឞ្រាស​យេឆូ ​ឆោង​មោ​គែស​រាវ​តី​ល៝រ។ ");
INSERT INTO cmok_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","លាស​នទ្រី​ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ហើយ​នោ ផូង​ផារីឆី ​ខាន់​មៃ​ជេង​តឹម​ឞាន​មា​ឞូនុយ្ស​អី​រាវ​ងាន រាវ​យាង់​តា​ឞើស​ទីស​ទើម យើន​មា​តា​ត្រោម​ហោម​អែ​អូក​រាមាវ ខាន់​មៃ​រាវ​តី​តឹង​មា​នាវ​វៃ​ខាន់​មៃ តីស​មា​តា​នូយ្ស​នហ៝ម់​ខាន់​មៃ​រី​ហោម​ទុត​អុច​មា​នាវ​ឆា​ញឆ្យាន់ នទ្រែល​មា​នាវ​មឹន​អ្យើស​មហឹក​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ហើយ​ឞូនុយ្ស​មឞ្លុ លាស​កោរាញ​ឞ្រាស​លែៈ​ញជេង​ជេស​នទើ​ឞើស​ទីស តា​ត្រោម​ពាង់​ញជេង​នទើ​ដ៝ង់ លាស​នទ្រី​ពាង់​អុច​តា​នូយ្ស​នហ៝ម់​ខាន់​មៃ​អ៝ន់​ក្ល៝ស​តឹម​ឞាន​មា​ឆាក់​ជាន់​ខាន់​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","លាស​នទ្រី​អ៝ន់​អ៝ក់​នទើ​មា​ឞូនុយ្ស​អ៝​អាច រី​មើ​ខាន់​មៃ​ក្ល៝ស​តា​នូយ្ស​នហ៝ម់​ដ៝ង់ ជេសរី​ខាន់​មៃ​ក្ល៝ស​ឞើស​ទីស​ដ៝ង់ ក្ល៝ស​តា​នូយ្ស​នហ៝ម់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ហើយ​ផូង​ផារីឆី  រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ​មេ! ខាន់​មៃ​នើស​ឆ៝ៈ​នទើ​គែស​ជឹត​អឹ​រាហ្វាត់​ង្វាយ​ញហើរ​មា​កោរាញ​ឞ្រាស កើត​លាស​នទើ​មោ​ខ្លៃ ក្លោយ្ស គីរ នទ្រែល​មា​នទើ​បោ​អាបាៈ​អេង​ដ៝ង់។ នាវ​អី​ញហើរ​ជេង​ទី តីស​មា​ខាន់​មៃ​មអារ់​លើយ​នាវ​ឆ៝ង់ នទ្រែល​មា​នាវ​រ៝ង់​កោរាញ​ឞ្រាស​អី​គែស​នាវ​ខ្លៃ​រាលាវ​ឞូ លាស​នទ្រី​អ៝ន់​ខាន់​មៃ​ញឆ្រោយ្ស​ញហើរ​កើត​អី​នៃ​មា​កោរាញ​ឞ្រាស​ដ៝ង់ យើន​មា​លើយ​ច្វេល​នាវ​ឆ៝ង់ នទ្រែល​មា​នាវ​រ៝ង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ហើយ​ផូង​ផារីឆី  រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ​មេ! យ៝រ​លាស​តា​នតុក​ញីស​រាបុន​ផូង​ឞ៝ន់​ខាន់​មៃ​នើស​អុច​គុ​ឞើស​នាប់​ឞូ​អី​នតុក​ឞូ​លឺ​ងាន់ នទ្រែល​មា​អុច​ហាន់​រ៝ៈ​នតុក​ឞូ​តាច់​ទ្រាប់ អ៝ក់​ឞូនុយ្ស​ឞូ​កុញ​ឞោក​មឞាស​មា​ខាន់​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ​មេ អី​ផូង​ផារីឆី  នទ្រែល​មា​អី​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ ខាន់​មៃ​មពោល​នូយ្ស​នហ៝ម់​នទ៝ប់​មពោន យ៝រ​លាស​ខាន់​មៃ​នើស​ជេង​តឹម​ឞាន​មា​នតូ​មោច​អ្វាញ់​មោ​ឆៃ ជេសរី​ឞូ​ទែ​ឞ្រោៈ​ជ៝ត​កាលើ​មោ​អោស​គឹត​ឆាក់ នទ្រី​ពាង់​មោ​ហោម​ក្ល៝ស​អោស។ កើត​នទ្រី​ដ៝ង់​ខាន់​មៃ​អ្វែស​តា​ឞើស​ទីស តីស​មា​តា​នូយ្ស​នហ៝ម់​រី​អ្យើស”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","គែស​ទូ​ហ្វេ​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​អើស​មា​ឞ្រាស​យេឆូ  ពាង់​លាស៖ “ហើយ​នើម​នតីមៃ​ងើយ​កើត​អី​នៃ ជេង​មៃ​មឺច​ញឆ៝ត​មា​ផូង​ហេន​ដ៝ង់​មេ”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “ហើយ​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់ រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ យ៝រ​លាស​ខាន់​មៃ​តេៈ​នាវ​វៃ​ទុត​ជ៝ក់​អ៝ន់​មា​ឞូនុយ្ស​ជាន តីស​មា​ខាន់​មៃ​នើម​មោ​គែស​អោស​កើល​ជាន​នាវ​អី​នៃ ដេៈ​ក៝ៈ​មោ​គែស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ យ៝រ​មា​ខាន់​មៃ​ជាន​អ្វែស​ងាន់​ជៃ​មោច​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស អី​អូ​ចែ​ខាន់​មៃ​លែៈ​ងខឹត​លើយ​កាល់​អែ​នើស តីស​មា​ខាន់​មៃ​មោ​អោស​ជាន​តឹង​នាវ​នតី​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ខាន់​មៃ​ជាន​កើត​នៃ ខាន់​មៃ​តឹម​ទី​ទូ​នតោរ​នាវ​នទ្រែល​អូ​ចែ​ខាន់​មៃ​នៃ​ដ៝ង់ ខាន់​ពាង់​មា​ងខឹត ខាន់​មៃ​មា​ជាន​ជៃ​មោច​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","នទ្រី​កោរាញ​ឞ្រាស​អី​គែស​នាវ​គឹត​មឹន​លាស​កើត​នអា៖ «គ៝ប់​ដាៈ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​គ៝ប់​ហាន់​អា​ខាន់​ពាង់ នទ្រែល​មា​កោរាញ​អ៝ស​ម៝ន​ដ៝ង់ តីស​មា​ឞូនុយ្ស​អី​នៃ អាបាៈ​ខាន់​ពាង់​ងខឹត​លើយ អាបាៈ​ជឹត​ខាន់​ពាង់​ជាន​ជេរ»។ ");
INSERT INTO cmok_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","កើត​នទ្រី​គ៝ប់​កើប​ឞូនុយ្ស​តា​រានោក​អាបៃ​អ្យា​គែស​ទោយ្ស​ងខឹត​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​នតើម​ឞើស​ញជេង​នែស​នតូ។ ឞ៝ល​លាស​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​អី​នៃ​លែៈ​ឞូ​ងខឹត​ឞើស​កាល់​អែ​នើស ទោយ្ស​អី​នៃ​ហោម​តេៈ​ត៝ត់​មា​ឞូនុយ្ស​តា​រានោក​អាបៃ​អ្យា​ដ៝ង់‌ ");
INSERT INTO cmok_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ជេង​នតើម​ឞើស​ក៝ន​អាដាម់ ​រាញា​ពាង់​កាអីន ​ងខឹត​អី​អ៝ស​ពាង់​រាញា​អាបែល  នហ៝​មា​ត៝ត់​ឞូ​ងខឹត​ឆាការី  អី​ឞូ​ងខឹត​ពាង់​តា​វាស​វាង​ញឆឺង​គុច​ពូរ​នទើ​ជាន​ឞ្រាស មា​ញីស​ជាន​ឞ្រាស​រី។ គ៝ប់​មឞើស​មា​ខាន់​មៃ មហាម​ខាន់​ពាង់​អី​នៃ​កោរាញ​ឞ្រាស​មរា​តេៈ​ទោយ្ស​តា​រានោក​ឞូនុយ្ស​អាបៃ​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ហើយ​ឞូនុយ្ស​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  រេស​រាញាល់​ងាន់​មា​ខាន់​មៃ​មេ យ៝រ​លាស​ខាន់​មៃ​មោ​អ៝ន់​ឞូ​គឹត​នាល់​នាវ​ងាន់​កោរាញ​ឞ្រាស។ នាវ​អី​នៃ​តឹម​ឞាន​មា​រាដាង់​លើយ​មពោង​ឞើស​ទីស​មា​លាប់​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់ ឆាក់​ខាន់​មៃ​នើម​លែៈ​មោ​គែស​លាប់​តា​មពោង​អី​នៃ ជេសរី​ខាន់​មៃ​ឞ្វៃ​ដ៝ង់​ឞូ​អេង​ជឹត​អី​អុច​លាប់ មោ​អ៝ន់​លាប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","នតើម​ឞើស​ឞ្រាស​យេឆូ ​លោស​ឞើស​នតុក​នៃ ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​ផារីឆី  តឹម​រាទ៝ង់​ដាស​ពាង់​ទុត​ហោ ជេសរី​អោប​មពែត​ពាង់​មា​នាវ​អេងៗ​អ៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ខាន់​ពាង់​ជាន​កើត​នៃ​អុច​ជ៝យ​នាវ​លាស​ឞ្រាស​យេឆូ ​អើស​តីស មោ​លាស​ងើយ​តីស គៃ​មា​នតោន​ពាង់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","នោក​នៃ​គែស​ឞូនុយ្ស​គុ​រាបុន​អ៝ក់​រាឞាន់​ងាន់ គៃ​មា​ម៝ប់​ឞ្រាស​យេឆូ  ត៝ត់​មា​តឹម​មពែត​តឹម​ជ៝ត​ឞាល់​ងាន់។ ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់​ល៝រ៖ “អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​នូយ្ស​នហ៝ម់​នទ៝ប់​មពោន​ផូង​ផារីឆី  នាវ​អ្យើស​នូយ្ស​នហ៝ម់​នទ៝ប់​មពោន​អី​នៃ​លើ​ក្វ៝ង់​លើ​ក្វ៝ង់ តឹម​ឞាន​មា​នទ្រូយ​ដេៈ​ជាន​អ៝ន់​ព្យាង់​នទ្រាញ់​អ៝ក់​ជេង​ទាង។ ");
INSERT INTO cmok_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","គែស​ទូ​នារ​ជឹត​នាប់​តៃ​កោរាញ​ឞ្រាស​មរា​អ៝ន់​ឞូ​ឆៃ​ទឹង​លែៈ​នទើ​អី​ឞូនុយ្ស​ហោម​មពោន កោរាញ​ឞ្រាស​អ៝ន់​ឞូ​គឹត​ទាទេ​ដ៝ង់ ទឹង​លែៈ​នទើ​អី​ឞូនុយ្ស​មោ​អុច​អ៝ន់​ឞូ​គឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","កើត​នទ្រី​ទឹង​លែៈ​នាវ​ខាន់​អៃ​មៃ​ងើយ​តា​នតុក​ង៝ ឞូ​មរា​តាង់​តា​នតុក​អាង លែៈ​នាវ​ខាន់​អៃ​មៃ​ងើយ​ឆ្វីស​តា​ត្រោម​តោរ​តា​ត្រោម​ជ្រោ ឞូ​មរា​មឞើស​ងក៝ច​នាវ​អី​នៃ​តា​កាលើ​ច៝រ​ជៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ហើយ​មឹត​ជាង់ ខាន់​អៃ​មៃ​អ្យាត់​នាវ​គ៝ប់ ខាន់​អៃ​មៃ​លើយ​អោស​ក្លាច​ឞូនុយ្ស ខាន់​ពាង់​គែស​នាវ​ទើយ​ងខឹត​តា​រាង្លៃ​ឆាក់​ទើម ជេសរី​ជាន​មោ​អោស​ហោម​ឞ្លាវ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","គ៝ប់​មឞើស​នទើ​អី​ខាន់​អៃ​មៃ​ទី​ក្លាច ក្លាច​មា​កោរាញ​ឞ្រាស​ហ៝ៈ យ៝រ​លាស​ជេស​ពាង់​ងខឹត ជេសរី​ពាង់​គែស​នាវ​ទើយ​ងក្លាច់​តា​នទ្រូង​អុញ​ជឹត។ នទ្រី​គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ អ៝ន់​ខាន់​អៃ​មៃ​ក្លាច​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ឞូ​វៃ​តាច់​ព្រាម់​មល៝ម់​ឆ្យុម​រាលែវ​ខ្លៃ​ឞារ​មល៝ម់​កាក់​ជេៈ​ទើម ឞ៝ល​លាស​ថ៝ក​កើត​នៃ​កាដោយ​លែៈ មោ​គែស​អោស​ទូ​មល៝ម់​ឆ្យុម​រាលែវ​កោរាញ​ឞ្រាស​ច្វេល។ ");
INSERT INTO cmok_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ឞ៝ល​លាស​ទឹង​លែៈ​ឆ៝ក់​តា​ឞោក​ខាន់​អៃ​មៃ​នើម កោរាញ​ឞ្រាស​លែៈ​ជេស​កើប​ដ៝ង់។ កើត​នទ្រី​លើយ​ក្លាច​អោស យ៝រ​លាស​កោរាញ​ឞ្រាស​កើប​ខាន់​អៃ​មៃ​ខ្លៃ​ងាន់​រាលាវ​មា​ឆ្យុម​រាលែវ​ទូ​ផូង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ហើយ​ខាន់​អៃ​មៃ​អ្យាត់​ហ៝ម់ ឞូ​ម៝ស​អី​ឞាញ់​មឞើស​មា​ឞូ​ពាង់​តឹង​គ៝ប់គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​មរា​មឞើស​ពាង់​អី​នៃ​ជេង​អ៝ស​ម៝ន​គ៝ប់​តា​ឞើស​នាប់​មាត់​កោរាញ​ឞ្រាស នទ្រែល​មា​តា​ឞើស​នាប់​មាត់​ផូង​តោង​ពារ់​កោរាញ​ឞ្រាស​នើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","យើន​មា​ឞូ​ម៝ស​អី​មោ​ឞាញ់​មឞើស​មា​ឞូ​ពាង់​តឹង​គ៝ប់គ៝ប់​មោ​ដ៝ង់​មឞើស​ពាង់​អី​នៃ​ជេង​អ៝ស​ម៝ន​គ៝ប់​តា​ឞើស​នាប់​មាត់​កោរាញ​ឞ្រាស នទ្រែល​មា​មពោល​តោង​ពារ់​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ឞូ​ម៝ស​ពាង់​អី​ងើយ​តឹម​រាទ៝ង់​ដាស​គ៝ប់​អី​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស កោរាញ​ឞ្រាស​ហោម​យោៈ​មោ​អោស​កើប​នាវ​តីស​ពាង់ យើន​មា​ឞូ​ម៝ស​ពាង់​អី​ងើយ​តឹម​រាទ៝ង់​ដាស​មា​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស កោរាញ​ឞ្រាស​ហោម​កើប​នាវ​តីស​ពាង់​នានាវ។ ");
INSERT INTO cmok_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","លាស​ឞូ​លែវ​ខាន់​អៃ​មៃ​ហាន់​តា​ញីស​រាបុន​ផូង​ឞ៝ន់​គៃ​មា​ផាត​ទោយ្ស​យ៝រ​មា​ខាន់​អៃ​មៃ​តឹង​គ៝ប់ មោ​លាស​ឞូ​លែវ​ខាន់​អៃ​មៃ​ហាន់​តា​ឞើស​នាប់​មាត់​កោរាញ​ម៝ត់​អ្វាញ់ មោ​លាស​មពោល​ឞូ​រាញ លើយ​អោស​ខាន់​អៃ​មៃ​រាវៃ​ម៝ស​នាវ​អី​ខាន់​អៃ​មៃ​អុច​ងើយ មោ​លាស​ម៝ស​នាវ​អី​ខាន់​អៃ​មៃ​អុច​អើស​មា​នាវ​ខាន់​ពាង់​នតោន។ ");
INSERT INTO cmok_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","យ៝រ​លាស​តា​ម៝ង​អី​នៃ​ឞ្រាស​ហ្វេង​អ្វែស​អី​ក្ល៝ស​អ្វែស​មឞើស​មា​ខាន់​អៃ​មៃ ម៝ស​នាវ​អី​ខាន់​អៃ​មៃ​អុច​ងើយ”។ ");
INSERT INTO cmok_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​តា​ផូង​ឞូនុយ្ស​អ៝ក់​នៃ​លាស​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​នើម​នតី ឞឹ​ហេន​លែៈ​ខឹត​ជេស ដាៈ​មៃ​មឞើស​មា​នោ​គ៝ប់ ដាៈ​ពាង់​ពាៈ​ទ្រាប់​នទើ​នទើន​អ៝ន់​មា​គ៝ប់​បាៈ​អើ”។ ");
INSERT INTO cmok_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “ឞូ​ម៝ស​ដាៈ​គ៝ប់​ជាន​កោរាញ​ផាត​ទោយ្ស មោ​លាស​ជេង​ឞូនុយ្ស​កើល​ពាៈ​ទ្រាប់​នទើ​អ៝ន់​មា​ខាន់​មៃ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ផូង​ឞូនុយ្ស​នៃ៖ “អ៝ន់​ញជ្រាង់​ហ៝ម់ លើយ​អោស​រាវាន​កើញ​គែស​មា​ទ្រាប់​នទើ។ ឞ៝ល​លាស​ឞូនុយ្ស​គែស​ទ្រាប់​នទើ​អ៝ក់​រាមែស នាវ​រេស​ពាង់​មោ​អោស​តាៈ​ឞើស​ទ្រាប់​នទើ​អ៝ក់​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ជេសរី​ឞ្រាស​យេឆូ ​ងើយ​នាវ​នតឹត​មា​ខាន់​ពាង់ ពាង់​លាស៖ “គែស​ទូ​ហ្វេ​ឞូនុយ្ស​នទ្រ៝ង់ តា​មីរ​ពាង់​រី​គែស​ឞា​ជេង​អ្វែស​ងាន់ ព្លៃ​រាគ្លែត​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ជេសរី​ពាង់​មឹន​អេង​តា​ឆាក់​ពាង់​នើម​កើត​នអា៖ «មោ​ហោម​គែស​អោស​នតុក​មា​ទើ​ឞា​គ៝ប់​អី​នៃ​តៃ លាស​នទ្រី​មើម​គ៝ប់​ជាន?» ");
INSERT INTO cmok_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ពាង់​មឹន​ជឹត៖ «គ៝ប់​ជាន​កើត​នអា រើយ្ស​លើយ​ជៃ​ឞា​អើម​អី​នៃ ជេសរី​កើយ​ជាន​អ៝ន់​ហ្វី​អ៝ន់​ក្វ៝ង់​ងាន់ ឆ៝ៈ​ឞា នទ្រែល​មា​ទ្រាប់​នទើ​អី​គ៝ប់​គែស​រី​តោស​ឞូន​តា​នតុក​ជៃ​ឞា​មហែ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ជេសរី​គ៝ប់​លាស​អេង​មា​ឆាក់​គ៝ប់​នើម គ៝ប់​គែស​ជេស​ឞា​ឞេង​ឞា​រាហ្យាង់​ទុត​អ៝ក់​អ្យា អ៝ន់​មា​ព្រាប់​ឆា​ជ៝ៈ​នាម់​ជឹត​នាប់ គ៝ប់​គុ​ទើម ជេសរី​មឹន​មា​ឆា​កាស​លាស​រាង្លៃ​ហ៝ៈ»។ ");
INSERT INTO cmok_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","តីស​មា​កោរាញ​ឞ្រាស​លាស​មា​ពាង់៖ «ហើយ​ឞូនុយ្ស​រាលូក តា​មាង់​អ្យា​រ៝ គ៝ប់​រាហ្វាត់​លើយ​ហ្វេង​មៃ។ លាស​នទ្រី​លែៈ​ទ្រាប់​នទើ​អី​មៃ​គែស​ព្រាប់​អី​នៃ​នើស ជេង​ឞូ​ម៝ស​មា​នទើន?» ");
INSERT INTO cmok_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","តឹម​ឞាន​កើត​នៃ​ដ៝ង់ លាស​ឞូ​ម៝ស​ជ៝យ​ព្រាក់​ទ្រាប់​នទើ​ព្រាប់​មា​ឆាក់​ពាង់​នើម​ទើម តីស​មា​មោ​គឹត​មា​នទើ​កោរាញ​ឞ្រាស​ទែ​ដាៈ”។ ");
INSERT INTO cmok_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “កើត​នទ្រី​ទឹង​គ៝ប់​មឞើស​ខាន់​អៃ​មៃ លើយ​អោស​រាវៃ​មា​នទើ​ឆោង​ឆា​មា​ឆ្យាម់​នាវ​រេស មោ​លាស​ឞ៝ក​អាវ​មា​ញឆ៝ស​ងគូត​ឆាក់​ជាន់​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","គែស​នទើ​អេង​ជឹត​តា​នាវ​រេស​អី​គែស​នាវ​ខ្លៃ​រាលាវ​មា​នទើ​ឆោង​ឆា គែស​នទើ​អេង​ជឹត​មា​ឆាក់​ជាន់​អី​គែស​នាវ​ខ្លៃ​រាលាវ​មា​ឞ៝ក​អាវ​មា​ញឆ៝ស។ ");
INSERT INTO cmok_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ល៝ង់​អ្វាញ់​នអាក ពាង់​មោ​តូច​តាម់ មោ​កាច់​រ៝យ្ស មោ​អោស​គែស​ទ្រ៝ង់​មោ​អោស​គែស​ជៃ​ឞា យើន​មា​កោរាញ​ឞ្រាស​ម៝ត់​ឆ្យាម់​ពាង់​ដ៝ង់។ លាស​នទ្រី​ល៝ង់​ខាន់​អៃ​មៃ​អី​នៃ​កោរាញ​ឞ្រាស​កើប​គែស​នាវ​ខ្លៃ​អ៝ក់​រាលាវ​ងាន់​មា​ដាស​ឆ្យុម​អ៝ច​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","តា​មពោល​ខាន់​អៃ​មៃ​អី​នៃ ឞ៝ល​លាស​ខ៝ម់​រាវៃ​ទុត​ហោ​កាដោយ​លែៈ ក៝ៈ​មោ​គែស​អោស​ឞូនុយ្ស​មា​ទើយ​នត៝ប​នាវ​រេស​ពាង់​នើម​អ៝ន់​ជ៝ង ដេៈ​ក៝ៈ​មោ​ទើយ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","លាស​នទ្រី​នាវ​អី​ទុត​ជេៈ​អី​នៃ លាស​ខាន់​អៃ​មៃ​ជាន​មោ​ទើយ​ដ៝ង់ មើម​ទឹង​ហោម​រាវៃ​មា​នាវ​អាបាៈ​អេង​ជឹត? ");
INSERT INTO cmok_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ល៝ង់​ខាន់​អៃ​មៃ​អ្វាញ់​កាវ​ឆី​ហ៝ន​អេង​តា​ឞ្រី ពាង់​មោ​អោស​រាអាស​មោ​អោស​រាគាញ់​ជាន​ការ មោ​លាស​រូយ​តាញ​គៃ​មា​អ្វែស​អ្វាញ់។ គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ ឞ៝ល​លាស​កាដាច់​ឆាលោមោន ​កាល់​អែ​នើស នោក​ពាង់​ងក្រឹ​ឆាក់​ជាន់​ឆ៝ស​ងគូត​ខ៝​អាវ​អ្វែស ហោម​មោ​ទើយ​ឞាន​អ្វែស​កាវ​ឆី​ទូ​ងក៝ង​អ្យា​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ហើយ​ឞូនុយ្ស​គែស​នាវ​ញឆីង​ដេៈ​ទើម លាស​កោរាញ​ឞ្រាស​អ៝ន់​ជេស​មា​កាវ​ឆី​អី​នៃ​អ្វែស​ងាន់​អ្វាញ់ នារ​អ្យា​ពាង់​ទាង នារ​អោយ​តៃ​ឞូ​ឆូ​លើយ​ពាង់​មា​អុញ លាស​នទ្រី​កោរាញ​ឞ្រាស​នទ្រាប់​អ៝ន់​ខ៝​អាវ​មា​ខាន់​អៃ​មៃ​រាលាវ​ឞើស​នៃ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","កើត​នទ្រី​ខាន់​អៃ​មៃ​អី​នៃ​លើយ​អោស​មឹន​រាវៃ លើយ​អោស​ជ៝យ​មា​នទើ​ឆោង​ឆា​មា​នទើ​ញេត​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","គែស​មពោល​អី​មោ​អ្យាត់​មា​កោរាញ​ឞ្រាស​ខ៝ម់​ញឆ្រោយ្ស​ជ៝យ​ទឹង​លែៈ​នទើ​អី​នៃ។ ល៝ង់​អី​ខាន់​អៃ​មៃ​នៃ​ឞឹ​ខាន់​អៃ​មៃ​នើម​តា​កាលើ​ត្រោក​រី លែៈ​ពាង់​គឹត​ទាទេ​ជេស​ម៝ស​នទើ​អី​ខាន់​អៃ​មៃ​អេ​ហ៝ៈ​ត៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","លាស​នទ្រី​ញឆ្រោយ្ស​ជ៝យ នទ្រែល​មា​អ្យាត់​លែៈ​នទើ​កោរាញ​ឞ្រាស​អុច​ល៝រ រី​មើ​ពាង់​អ៝ន់​នត៝ប​នទើ​អី​នៃ​មា​ខាន់​អៃ​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ហើយ​មពោល​ជេៈ​គ៝ប់ លើយ​ក្លាច​អោស ឞឹ​ខាន់​អៃ​មៃ​នើម​តា​កាលើ​ត្រោក​រី​មអាក​ងាន់​ម៝ត់​អ្វាញ់​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","តាច់​ហ៝ម់​ទ្រាប់​នទើ​ខាន់​អៃ​មៃ​គែស ពាៈ​អ៝ន់​មា​មពោល​អ៝​អាច។ នទ្រី​មើ​ខាន់​អៃ​មៃ​ជេង​រាបុន​ទ្រាប់​នទើ​អី​មោ​ឞ្លាវ​អោម​អី​មោ​ឞ្លាវ​លែៈ រាបុន​ទ្រាប់​នទើ​ព្រាប់​មា​ខាន់​អៃ​មៃ​នើម​តា​នតុក​កោរាញ​ឞ្រាស​តា​កាលើ​ត្រោក​រី នតុក​អី​នៃ​មោ​អោស​គែស​ឞូនុយ្ស​នតុង មោ​អោស​គែស​ញច្យារ់​រែស។ ");
INSERT INTO cmok_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ញជ្រាង់​ហ៝ម់ នទើ​អី​ខាន់​អៃ​មៃ​នត្រ៝ង់​ខ្លៃ​រាលាវ​ឞូ ជេង​នទើ​អី​ខាន់​អៃ​មៃ​មឹន​រាវៃ​រាលាវ​ឞូ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​បាបើ​ហ៝ម់ ក៝ប់​គ៝ប់​ព្លឹ​តៃ​តា​អ្យា តឹម​ឞាន​មា​ទឹក​គុ​ក៝ប់​កោរាញ​ខាន់​ពាង់​ព្លឹ​ឆឹត​ឞើស​ឆា​នអាប់​នោក​មាង់។ ខាន់​ពាង់​នទ្រាប់​ឆាក់​ជាន់ អ៝ន់​គែស​អុញ​ឆាគេង​ហីត​ទូ​នាង់​រាអាង​ដ៝ង់ គៃ​មា​ទើស​ពើក​មពោង​មា​ពាង់ នទ្រែល​មា​គើញ​ជាន​ការ​អ៝ន់​មា​ពាង់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ត៝ត់​កោរាញ​ឆឹត​តា​រី អ្វែស​ងាន់​មា​ទឹក​អាបាៈ​អី​ពាង់​ឆៃ​ហោម​គុ​រាងែស​ក៝ប់​តា​រី។ គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ អី​កោរាញ​នៃ​មរា​អ៝ន់​ទឹក​ពាង់​រី​គុ​ឆោង​ឆា​តា​ញឆឺង​រ៝ អី​ពាង់​នើម​រី​នទ្រាប់​ឆាក់​ជាន់​មា​ព្លាច់​ឆើម​កើល​ជាន​ការ​អ៝ន់​ខាន់​ពាង់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ឞ៝ល​លាស​អី​កោរាញ​ពាង់​ត៝ត់​ងគូល​មាង់ មោ​លាស​កេង​អាង​កាដោយ ហោម​ឆៃ​ទឹក​ពាង់​ហោម​គុ​រាងែស​ក៝ប់​ដ៝ង់ ទឹក​អី​នៃ​គែស​នាវ​អ្វែស​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","អ៝ន់​ខាន់​អៃ​មៃ​គឹត​នាវ​អ្យា៖ លាស​ឞូនុយ្ស​តើម​ជៃ​គឹត​ម៝ង​ឞូ​ហាន់​នតុង ពាង់​មោ​អោស​ប៝ក​គ៝រ​អ៝ន់​ឞូនុយ្ស​នតុង​អី​នៃ​លាប់​តា​ជៃ​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","លាស​នទ្រី​អ៝ន់​ខាន់​អៃ​មៃ​គុ​ញជ្រាង់​តឹម​ឞាន​ដ៝ង់ យ៝រ​លាស​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់ តា​ម៝ង​ងើត​រាងើយ​ខាន់​អៃ​មៃ​មោ​គែស​មឹន”។ ");
INSERT INTO cmok_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ពេត្រោស ​អោប​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញ នាវ​មៃ​ងើយ​នតឹត​អ្យា​ទើន​លាស​មា​ហេន​ទើម មោ​លាស​អុច​លាស​មា​ទឹង​លែៈ​ប៝ន​លាន​ដ៝ង់?” ");
INSERT INTO cmok_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “គ៝ប់​មឞើស​មា​ទឹង​លែៈ​ឞូនុយ្ស​អី​តឹម​ឞាន​មា​ទូ​ហ្វេ​ទឹក​អី​គែស​នូយ្ស​នហ៝ម់​ឆ៝ង់ នទ្រែល​មា​លែៈ​ឞ្លាវ​ងាន់។ កោរាញ​ជាវ​ពាង់​ម៝ត់​អ្វាញ់​ទឹក​អា​អេង​តា​ជៃ​នៃ នទ្រែល​មា​អ៝ន់​ពាង់​ពាៈ​នទើ​ឆោង​ឆា​តឹម​ទី​ម៝ង​អ៝ន់​មា​ខាន់​ពាង់​ដ៝ង់។ ជេសរី​កោរាញ​ហាន់​តា​នតុក​ងាយ​ជ៝ៈ​នារ។ ");
INSERT INTO cmok_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","នោក​កោរាញ​ពាង់​ឆឹត​ត៝ត់​តា​ជៃ​រី ហោម​ឆៃ​ពាង់​ជាន​ការ​កើត​នៃ ទឹក​អី​នៃ​គែស​នាវ​អ្វែស​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","គ៝ប់​មឞើស​ងាន់​មា​ខាន់​អៃ​មៃ កោរាញ​មរា​អ៝ន់​ទឹក​អី​នៃ​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​នទើ​កោរាញ​គែស។ ");
INSERT INTO cmok_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","តីស​មា​លាស​ទឹក​អី​នៃ​ពាង់​គែស​លាស​អេង​តា​នូយ្ស​នហ៝ម់​ពាង់​នើម​រី៖ «កោរាញ​គ៝ប់​ជ៝ៈ​ងាន់​ឆឹត ពាង់​មោ​អោស​គើញ​ឆឹត»។ ជេសរី​ពាង់​នតើម​រាពាត់​មឞាង​ទឹក​អា​អេង នអ៝ប់​មា​ឞូ​អូរ​ដ៝ង់​ឞូ​ក្លោ​ដ៝ង់ នទ្រែល​មា​ឆោង​ឆា​ញេត​នទ្រាញ់​ញុល​ឞ្លឹក​ឞ្លែក។ ");
INSERT INTO cmok_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ជេសរី​អី​កោរាញ​ទឹក​អី​នៃ​ព្លឹ​ឆឹត​ត៝ត់​តា​រី តា​នារ​នៃ​ទឹក​អី​នៃ​មោ​អោស​គែស​ញជ្រាង់ តា​ម៝ង​នៃ​ពាង់​មោ​គែស​គឹត​ដ៝ង់។ កោរាញ​ងក្រីត​ពាង់​រ៝ នទ្រែល​មា​អ៝ន់​ពាង់​គុ​តា​នតុក​ទឹង​លែៈ​ឞូនុយ្ស​អី​មោ​គែស​ដ៝ង់​ជាន​ការ​អ៝ន់​ឆ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ឞូ​ម៝ស​ទឹក​អី​លែៈ​គឹត​នាល់​នូយ្ស​នហ៝ម់​កោរាញ​ពាង់​នើម​អុច តីស​មា​មោ​នទ្រាប់​ឆាក់​ជាន់ នទ្រែល​មា​មោ​ជាន​តឹង​នូយ្ស​នហ៝ម់​កោរាញ​អុច ទឹក​អី​នៃ​មរា​ម៝ប់​ម៝ង់​អ៝ក់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","យើន​មា​ទឹក​អី​មោ​គឹត​នាល់​នូយ្ស​នហ៝ម់​កោរាញ​រី ពាង់​គែស​ជាន​តីស​ដ៝ង់ តីស​មា​ម៝ប់​ម៝ង់​ដេៈ​ដាៈ​ទើម។ យើន​មា​ឞូ​ម៝ស​អី​ឞូ​អ៝ន់​នទើ​អ៝ក់ ឞូ​មរា​ទាន់​តាៈ​ឞើស​ឞូនុយ្ស​អី​នៃ​អ៝ក់​ដ៝ង់។ ឞូ​ម៝ស​អី​ឞូ​ជាវ​ជាន​ការ​ក្វ៝ង់ ឞូ​មរា​អោប​ឞើស​ពាង់​អី​នៃ​លើ​ហោ​អ៝ក់​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ឞ្រាស​យេឆូ ​លាស​ជឹត៖ “គ៝ប់​វាច់​គៃ​មា​លែវ​អុញ​ទោស​តា​នែស​នតូ។ គ៝ប់​អុច​ងាន់​លាស​ឆៃ​អុញ​អី​នៃ​លែៈ​ហីត។ ");
INSERT INTO cmok_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ហោម​ដេៈ​នារ​ជឹត​នាប់​តៃ​គ៝ប់​គែស​នាវ​ក្រីត​ជេរ​ហោ​ងាន់ នទើ​អី​នៃ​ជេង​ទូ​នតីល​បាប់តែម​មា​គ៝ប់ តា​នូយ្ស​នហ៝ម់​គ៝ប់​រាង៝ត​ហោ​ងាន់​ត៝ត់​មា​នាវ​អី​អ្យា​ជេស​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","លើយ​អោស​ខាន់​អៃ​មៃ​មឹន​គ៝ប់​វាច់​គៃ​មា​លែវ​នាវ​ដាប់​មពាន់​តា​នែស​នតូ​អ្យា មោ​ទី​អោស វាច់​គៃ​មា​លែវ​នាវ​តឹម​ងខាស​មពោល។ ");
INSERT INTO cmok_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","នតើម​ឞើស​នារ​អ្យា​ជឹត​នាប់ នតឹត​លាស​គែស​ទូ​មល៝ម់​ជៃ គែស​ឞូនុយ្ស​ព្រាម់​នុយ្ស ឞូនុយ្ស​ព្រាម់​នុយ្ស​អី​នៃ​មរា​តឹម​ងខាស​មពោល ពែ​នុយ្ស​តឹម​ងខាស​មពោល​ដាស​មា​ឞារ​ហៃ ឞារ​ហៃ​តឹម​ងខាស​មពោល​ដាស​មា​ពែ​នុយ្ស ");
INSERT INTO cmok_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","«ឞឹ​តឹម​ងខាស​មពោល​ដាស​ក៝ន​ឞូ​ក្លោ‌ ក៝ន​ឞូ​ក្លោ​តឹម​ងខាស​មពោល​ដាស​ឞឹ‌ មេៈ​តឹម​ងខាស​មពោល​ដាស​ក៝ន​ឞូ​អូរ‌ ក៝ន​ឞូ​អូរ​តឹម​ងខាស​មពោល​ដាស​មេៈ‌ ព៝​ឞូ​អូរ​តឹម​ងខាស​មពោល​ដាស​មាន់‌ មាន់​តឹម​ងខាស​មពោល​ដាស​ព៝​ឞូ​អូរ»”។ ");
INSERT INTO cmok_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ឞ្រាស​យេឆូ ​លាស​មា​ផូង​ប៝ន​លាន​ដ៝ង់៖ “ទោល​ខាន់​អៃ​មៃ​ឆៃ​តុក​ឞ្រោៈ​មពែស​ឞើស​ញ៝ប់​នារ​រី ខាន់​អៃ​មៃ​លាស​រ៝៖ «ឞើយ​អុច​មីស​ជេស» នទ្រី​គែស​មីស​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","លាស​ខាន់​អៃ​មៃ​ឆៃ​គែស​ឆ្យាល​ខោម​តាៈ​មពែស​ឞើស​ទ៝ង់​រី ខាន់​អៃ​មៃ​លាស៖ «នារ​អ្យា​ហោ​ទោស» ពាង់​គែស​ទោស​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ហើយ​ឞូនុយ្ស​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម ខាន់​អៃ​មៃ​ឞ្លាវ​មឞេន​ត្រោក នទ្រែល​មា​ឞ្លាវ​មឞេន​នែស លាស​នទ្រី​មើម​ទឹង​មោ​គឹត​វ៝ត់​នទើ​អី​កោរាញ​ឞ្រាស​ជាន​តា​នោក​អាបៃ​អ្យា?” ");
INSERT INTO cmok_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ជេសរី​មើម​ទឹង​ខាន់​អៃ​មៃ​មោ​គែស​ងក្ល៝ន់​អេង​តា​ឆាក់​ខាន់​អៃ​មៃ​នើម អី​នាវ​ខាន់​អៃ​មៃ​ជាន​ទី? ");
INSERT INTO cmok_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","លាស​ខាន់​អៃ​មៃ​ហាន់​ជឹត​ញីស​ផាត​ទោយ្ស​រី ទោល​ខាន់​អៃ​មៃ​ហាន់​រ៝ៈ​ត្រ៝ង​នទ្រែល​ឞូនុយ្ស​អី​ខាន់​អៃ​មៃ​គែស​នាវ​នៃ អ៝ន់​ខាន់​អៃ​មៃ​តឹម​ទាន់​នាវ​យោៈ​ឞាល់ ក្លាច​លាស​ឞូ​ញជុន​ខាន់​អៃ​មៃ​ជឹត​កោរាញ​ផាត​ទោយ្ស កោរាញ​ផាត​ទោយ្ស​អី​នៃ​ញជុន​មា​កោរាញ​នទ្រូង ជេសរី​កោរាញ​នទ្រូង​អី​នៃ​ក្រុង​ខាន់​អៃ​មៃ​តា​ត្រោម​នទ្រូង​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ លាស​មោ​រឹង​ជាន​ទោយ្ស​អ៝ន់​ឞូ ខាន់​អៃ​មៃ​មោ​ទើយ​អោស​លោស​ឞើស​នតុក​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","តា​នតុក​នៃ​ដ៝ង់ គែស​ឞូនុយ្ស​អាបាៈ​តា​ផូង​អី​នៃ​មឞើស​មា​ឞ្រាស​យេឆូ ​មា​នាវ​កោរាញ​ពីលាត ​ទែ​ជាន ខាន់​ពាង់​លាស៖ “ហើយ​កោរាញ គែស​មពោល​កាលីលេ ​ពីលាត ​ទែ​ងខឹត​ខាន់​ពាង់​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស តា​នតុក​នៃ​ខាន់​ពាង់​ហោម​អែ​ជាន​ឞ្រាស នទ្រី​មហាម​ខាន់​ពាង់​ហ៝ច​លាយ​ដាស​មហាម​មពោមពា​(ឆ្យុម)​អី​ខាន់​ពាង់​ជាន​ឞ្រាស​នើស”។ ");
INSERT INTO cmok_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “អាស​ខាន់​អៃ​មៃ​មឹន​មពោល​កាលីលេ ​អី​នៃ​គែស​នាវ​តីស​អ៝ក់​រាលាវ​មា​ដាស​ផូង​កាលីលេ ​អេងៗ​ឞើស ទឹង​គែស​មា​ខាន់​ពាង់​ខឹត​អ្យើស​កើត​នៃ? ");
INSERT INTO cmok_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ មោ​ទី​អោស! លាស​ខាន់​អៃ​មៃ​មោ​គែស​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស ខាន់​អៃ​មៃ​មរា​រ៝ស​ហេង​តឹម​ឞាន​មា​ខឹត​ឞូ​អី​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","លាស​នទ្រី​អ៝ន់​ខាន់​អៃ​មៃ​កាស​គឹត​នោក​ទូ​មល៝ម់​ជៃ​ព្រេស​រាញា​ឆីល៝ម ​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  ជៃ​អី​នៃ​ងក្ល៝ន់​ឞូនុយ្ស ១៨ នុយ្ស​ខឹត។ អាស​ខាន់​អៃ​មៃ​មឹន​ខាន់​ពាង់​អី​នៃ​យ៝រ​មា​គែស​នាវ​តីស​អ៝ក់​រាលាវ​មា​ឞូនុយ្ស​អាបាៈ​អេង​តា​ប៝ន​យេរូឆាលឹម ​ឞើស? ");
INSERT INTO cmok_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","មោ​ទី​អោស! គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ លាស​ខាន់​អៃ​មៃ​មោ​គែស​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស ខាន់​អៃ​មៃ​តៃ​រ៝ស​ហេង​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ជេសរី​ឞ្រាស​យេឆូ ​ងើយ​នាវ​នតឹត​អ្យា​លាស៖ “គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​តាម់​ទូ​តើម​រាវី ​តា​មីរ​ពាង់​នើម។ អាប់​នាម់​ត៝ត់​ខៃ​គែស​ព្លៃ​ឞូនុយ្ស​អី​តើម​មីរ​អី​នៃ​គៃ​មា​ពែៈ​ព្លៃ​ឞើស​តើម​រាវី ​អី​នៃ​មោ​អោស​ឆៃ​គែស​ព្លៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ជេសរី​ពាង់​លាស​មា​ឞូនុយ្ស​ម៝ត់​មីរ​នៃ៖ «ហើយ​មៃ តើម​រាវី ​អ្យា​លែៈ​ពែ​នាម់​ជេស​គ៝ប់​គៃ​មា​ពែៈ​ព្លៃ មោ​អោស​ឆៃ​ព្លៃ។ កាល់​មអារ់​លើយ​ទោស ម៝ស​ជាន​រ៝ង​ហ្វាច​ទើម​នែស!» ");
INSERT INTO cmok_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ជេសរី​ឞូនុយ្ស​អី​ម៝ត់​មីរ​នៃ​លាស៖ «ហើយ​កោរាញ មៃ​រ៝ង​ពាង់​ហោម​ទូ​នាម់​ជឹត ក៝ប់​គ៝ប់​ញឆើរ​នែស តេៈ​អាច់​នទ្រោក​ប៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ងខេប​លាស​នាម់​ឞើស​នាប់​តៃ​ព្លៃ។ លាស​មោ​ឆៃ​ព្លៃ​ដ៝ង់​ទឹង​គែស​មា​កាល់​លើយ​ពាង់!»” ");
INSERT INTO cmok_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","គែស​ទូ​នារ​រី ជេង​នារ​ឆាបាត់ ​អី​នារ​ផូង​អីឆ្រាអែល ​រាលូ​ឞ្វៃ​ជាន​ការ ឞ្រាស​យេឆូ ​គុ​នតី​ឞូ​តា​ញីស​រាបុន​ផូង​អីឆ្រាអែល ​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","តា​នតុក​នៃ​គែស​ទូ​ហ្វេ​ឞូ​អូរ​ឞ្រាស​អ្យើស​លើស​ពាង់ លែៈ​ជ៝ៈ ១៨ នាម់​ហើយ ច៝រ​កុយ្ស​ពាង់​ដុន ទ៝ក់​ឆ៝ង់​មោ​ឞ្លាវ​អោស។ ");
INSERT INTO cmok_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ទោល​ឞ្រាស​យេឆូ ​ឆៃ​ឞូ​អូរ​អី​នៃ ពាង់​ក្វាល់​ឞូ​អូរ​អី​នៃ​វាច់​ទាច់ ជេសរី​លាស​មា​ពាង់៖ “នាវ​ដុន​ច៝រ​កុយ្ស​អៃ​លែៈ​ឞាស​ជេស”។ ");
INSERT INTO cmok_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ឞ្រាស​យេឆូ ​តេៈ​តី​កាលើ​ឆាក់​ពាង់​រី ជេសរី​ឞូ​អូរ​អី​នៃ​ទ៝ក់​ឆ៝ង់​ឞាស​នទាល​តា​នៃ​រ៝ ងក្រែ​មា​ពាង់​រានេ​មា​កោរាញ​ឞ្រាស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","តីស​មា​ឞូនុយ្ស​អី​ម៝ត់​អ្វាញ់​ញីស​រាបុន​នៃ ឆៃ​ឞ្រាស​យេឆូ ​ជាន​ឞាស​ឞូ​តា​នារ​ឆាបាត់  ពាង់​ជី​នូយ្ស​ងាន់។ ពាង់​លាស​មា​ផូង​ប៝ន​លាន​អី​នៃ៖ “គែស​ព្រាវ​នារ​ទើយ​ជាន​ការ លាស​នទ្រី​ខាន់​អៃ​មៃ​ហាន់​តា​នារ​អី​នៃ​ទោ លាស​អុច​ជាន​ឞាស​នាវ​ជី លើយ​អោស​ហាន់​តា​នារ​ឆាបាត់ ”។ ");
INSERT INTO cmok_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ឞ្រាស​យេឆូ ​លាស​មា​ឞូនុយ្ស​អី​ម៝ត់​ញីស​រាបុន​នៃ៖ “ហើយ​ឞូនុយ្ស​ជាន​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ទើម! អាស​ទឹង​លែៈ​ខាន់​មៃ​អើម​មោ​លាស​ទ្រ៝ស​នទ្រោក ឆែស​លៀ ឞើស​នទ្រូង​ងគារ​លែវ​អ៝ន់​ពាង់​ញេត​ទាក​តា​នារ​ឆាបាត់ ​ហែស? នទើ​អី​នៃ​ជាន​ការ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ឞូ​អូរ​អ្យា​ក៝ន​ឆៅ​អាឞ្រាហាម់ ​អី​ចែ​ផូង​ឞ៝ន់​ដ៝ង់។ ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​ក៝ត់​ពាង់​លែៈ​ជ៝ៈ ១៨ នាម់​ងាន់ លាស​នទ្រី​គ៝ប់​រាក្លាយ្ស​ពាង់​តា​នារ​ឆាបាត់ ​អើម​មោ​ទី​បាស?” ");
INSERT INTO cmok_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ជេស​ឞ្រាស​យេឆូ ​ងើយ​នៃ ដីត​ព្រេង​ទាទេ​ងាន់​លែៈ​ឞូនុយ្ស​អី​តឹម​រាទ៝ង់​ដាស​ពាង់​រី​នើស។ ល៝ង់​អី​ប៝ន​លាន​រី​ឞូ​គែស​នាវ​រាម់​មអាក​ងាន់​មា​លែៈ​នាវ​ទើយ​នាវ​អ្វែស​ឞ្រាស​យេឆូ ​ជាន​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ជេសរី​ឞ្រាស​យេឆូ ​លាស៖ “ម៝ស​នទើ​ទើយ​តឹម​នតឹត​មា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់? លាស​នទ្រី​ម៝ស​នទើ​គ៝ប់​ជាន​គៃ​មា​ទើយ​តឹម​រាដឹល​មា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស​នៃ? ");
INSERT INTO cmok_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស ជេង​តឹម​ឞាន​មា​គារ់​ឆី​ទូ​នតីល​ទុត​ជេៈ គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​តាម់​តា​មីរ​ពាង់​នើម​រី។ គារ់​ឆី​អី​នៃ​ហ៝ន​ជេង​តើម​ឆី​ទុត​ក្វ៝ង់ ជេសរី​នហ៝​មា​គែស​ឆ្យុម​ជាន​រាឆ្វាន់​តា​ងគីង​នៃ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ឞ្រាស​យេឆូ ​លាស​ជឹត៖ “លាស​នទ្រី​ម៝ស​នទើ​អេង​ជឹត​គ៝ប់​នតឹត​គៃ​មា​ទើយ​តឹម​ឞាន​មា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​នៃ? ");
INSERT INTO cmok_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ឞូនុយ្ស ជេង​តឹម​ឞាន​មា​នទ្រូយ​ទូ​មល៝ម់ ទូ​ហ្វេ​ឞូ​អូរ​ឆ៝ៈ​ព៝ត​លាយ​នទ្រែល​រានីស​ឞា​ព្រាង់  ពាង់​តេៈ​ទាក​មព្យាច់​អ៝ន់​តឹម​លាប់​ឞាល់​គៃ​មា​ជាន​នុមពាង់ ត៝ត់​ជ៝ៈ​ទូ​ម៝ង​ឞារ​ម៝ង​ឞើស​កើយ​នៃ ទឹង​លែៈ​នទើ​អី​នៃ​លើ​មា​ក្វ៝ង់​លើ​មា​ក្វ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​រាប៝ង់​ជឹត​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ពាង់​ហាន់​គ្លាត់​រ៝ៈ​ប៝ន​ក្វ៝ង់ រ៝ៈ​ប៝ន​ជេៈ​អេងៗ នហ៝​មា​នតុម​នតី​ឞូ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","តា​ទូ​ប៝ន​គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​អោប​ពាង់៖ “ហើយ​កោរាញ ឞូនុយ្ស​អី​គែស​នាវ​រាក្លាយ្ស​គែស​ដេៈ​ទើម​បាស?” ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ត្រ៝ង​តា​នាវ​រាក្លាយ្ស​តឹម​ឞាន​មា​មពោង​ជៃ​ហ្វេត លាស​នទ្រី​អ៝ន់​ខាន់​អៃ​មៃ​ញឆ្រោយ្ស​លាប់​រ៝ៈ​មពោង​ជៃ​ហ្វេត​អី​នៃ។ គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ គែស​អ៝ក់​ឞូនុយ្ស​អុច​លាប់ តីស​មា​មោ​ទើយ​អោស។ ");
INSERT INTO cmok_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","គែស​ទូ​ហ្វេ​តើម​ជៃ ត៝ត់​ទូ​នារ​ពាង់​ទ៝ក់​រាដាង់​លើយ​មពោង ខាន់​អៃ​មៃ​គុ​ឞើស​ទីស​មពោង​រី នតើម​ក្វាល់​ពាង់៖ «ហើយ​កោរាញ! ហើយ​កោរាញ! ពឹ​មពោង​មា​ហេន​បាៈ​អើ»។ ពាង់​អី​តើម​ជៃ​នៃ​អើស​មា​ខាន់​អៃ​មៃ​លាស៖ «មោ​អោស គ៝ប់​មោ​អោស​គឹត​នាល់​ខាន់​អៃ​មៃ​អី​នៃ​ឞើស​តាៈ!» ");
INSERT INTO cmok_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ជេសរី​ខាន់​អៃ​មៃ​មឞើស​តៃ​មា​ពាង់​ដ៝ង់៖ «ម៝ស​នើស! ហេន​វៃ​គុ​ឆោង​ឆា​នទ្រែល​មៃ​នើស​ហ្យើ មៃ​វៃ​នតុម​នតី​ហេន​រ៝ៈ​ប៝ន​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ពាង់​លាស​មា​ខាន់​អៃ​មៃ៖ «ហើយ​មពោល​ជាន​ការ​ក្វែ ទូ​ងាយ​ឞើស​គ៝ប់​ហ៝ម់! គ៝ប់​មោ​អោស​គឹត​នាល់​ខាន់​អៃ​មៃ​អី​នៃ​ឞើស​តាៈ!» គ៝ប់​តឹម​ឞាន​មា​តើម​ជៃ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ជេសរី​ខាន់​អៃ​មៃ​គែស​នាវ​ញហ្យាង់​ញុម នទ្រែល​មា​រាច្យាត់​ឆេក ទោល​ខាន់​អៃ​មៃ​ឆៃ​មពោល​ចែ​ខាន់​អៃ​មៃ​អាឞ្រាហាម់ អីឆាក់  នទ្រែល​មា​យាកោប  ជេសរី​នទ្រែល​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស​គុ​តា​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​នៃ តីស​មា​អី​ខាន់​អៃ​មៃ​នៃ​កោរាញ​ឞ្រាស​នត្លើយ​លើយ​ឞើស​ទីស​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","គែស​ឞូនុយ្ស​អី​តាៈ​ឞើស​អាប់​ញជោញ​ឞ្រី ខាន់​ពាង់​មោ​អោស​ទី​ផូង​អីឆ្រាអែល  គុ​ញេត​ឆោង​ឆា​នទ្រែល​តា​នតុក​ឞ្រី​កាដាច់​កោរាញ​ឞ្រាស​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ល៝ង់​ឞូនុយ្ស​អី​ឞើស​កើយ​ព្លាច់​ឞើស​នាប់ ឞូនុយ្ស​អី​ឞើស​នាប់​ព្លាច់​ឞើស​កើយ​ច្រាវ គែស​ឞូនុយ្ស​អាបាៈ​តា​នែស​នតូ​អ្យា​ឞូ​គឹត​ខាន់​ពាង់​គែស​នាវ​ខ្លៃ​ងាន់ យើន​មា​តា​ជឹត​នាប់​តៃ​មោ​អោស​គែស​នាវ​ខ្លៃ តីស​មា​គែស​ឞូនុយ្ស​អាបាៈ​អេង​ជឹត​តា​នែស​នតូ​អ្យា​ឞូ​គឹត​ខាន់​ពាង់​មោ​អោស​គែស​នាវ​ខ្លៃ យើន​មា​តា​ជឹត​នាប់​តៃ​ងខើង​មា​គែស​នាវ​ខ្លៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","តា​នោក​នៃ​គែស​ផូង​ផារីឆី ​អាបាៈ​ហាន់​ម៝ប់​ឞ្រាស​យេឆូ  ជេសរី​លាស​មា​ពាង់៖ “មៃ​ទូ​ឞើស​នតុក​អ្យា​ហ៝ម់ កោរាញ​ម៝ត់​អ្វាញ់​ហេរោត-​អ៝ន់តីពាស ​អុច​ងខឹត​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ឞ្រាស​យេឆូ ​លាស​មា​ផូង​អី​នៃ៖ “ពាង់​មោ​អោស​គែស​នាវ​ទើយ​មា​គ៝ប់ ហាន់​ខាន់​មៃ​មឞើស​មា​ពាង់​អី​ឞូនុយ្ស​តឹម​ឞាន​មា​ឆ៝​ឞ្រី​អី​នៃ នារ​អ្យា នារ​អោយ​តៃ គ៝ប់​ហោម​នត្រុត​ឞ្រាស​អ្យើស នទ្រែល​មា​ជាន​ឞាស​ឞូនុយ្ស​ជី ត៝ត់​នារ​អោយ​ក្លាក​គ៝ប់​ជាន​ការ​គ៝ប់​អ្យា​ត៝ត់​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","យើន​មា​នារ​អ្យា នារ​អោយ​តៃ នទ្រែល​មា​នារ​អោយ​ក្លាក អ្យាត់​មា​គ៝ប់​ហាន់​រ៝ៈ​ត្រ៝ង គ៝ប់​ហាន់​ត៝ត់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  យ៝រ​លាស​មោ​ទី​អោស​មា​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ខឹត​ឞើស​ទីស​ប៝ន​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ហើយ​ឞូនុយ្ស​តា​ប៝ន​យេរូឆាលឹម  ឞូនុយ្ស​តា​ប៝ន​យេរូឆាលឹម  ខាន់​អៃ​មៃ​លែៈ​ងខឹត​ជេស​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស ឆ៝ៈ​លុ​នតុប​ងខឹត​លើយ​អី​ឞូនុយ្ស​កោរាញ​ឞ្រាស​ដាៈ​ហាន់​នតី​ខាន់​អៃ​មៃ។ យើន​មា​លែៈ​បាបើ​ងាន់​គ៝ប់​អុច​រាគូម​ខាន់​អៃ​មៃ តឹម​ឞាន​មា​មែ​អ្យារ់​រាតុក​ក៝ន​អ៝ន់​គុ​គូម​តា​ន៝ម់​នារ​ពាង់ តីស​មា​ខាន់​អៃ​មៃ​មោ​អុច​អោស។ ");
INSERT INTO cmok_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ គ៝ប់​ហាន់​អា​ខាន់​អៃ​មៃ​ហោម​ទូ​តឹ​ទើម ជេសរី​តៃ​ខាន់​អៃ​មៃ​មោ​ហោម​អោស​ឆៃ​គ៝ប់​ជឹត។ អ្វាញ់​ប៝ន​ខាន់​អៃ​មៃ​តៃ​កោរាញ​ឞ្រាស​នត្លើយ​ងាន់ នហ៝​មា​ត៝ត់​ម៝ង​ខាន់​អៃ​មៃ​លាស​មា​គ៝ប់៖ «ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​ឞូនុយ្ស​អ្យា អី​កោរាញ​ឞ្រាស​ទែ​ដាៈ​វាច់»”។ ");
INSERT INTO cmok_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","គែស​ទូ​នារ​ជេង​នារ​ឆាបាត់ ឞ្រាស​យេឆូ ​ហាន់​ឆោង​ឆា​តា​ជៃ​ទូ​ហ្វេ​កោរាញ​ផូង​ផារីឆី ។ ត៝ត់​តា​នៃ​លែៈ​មពោល​អី​គុ​តា​ជៃ​នៃ​ក៝ប់​រាម្យាង់​អ្វាញ់​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","តា​នៃ​ឆៃ​ទូ​ហ្វេ​ឞូនុយ្ស​ជី​ពុក​ជី​មោរ គុ​ឞើស​នាប់​ឞ្រាស​យេឆូ ​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ជេសរី​ឞ្រាស​យេឆូ ​អោប​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​ផូង​ផារីឆី ៖ “តឹង​មា​នាវ​វៃ​ផូង​ឞ៝ន់ អាស​ទី​ដ៝ង់​ឞើស ជាន​ឞាស​ឞូនុយ្ស​ជី​តា​នារ​ឆាបាត់ ​អី​នារ​គុ​រាលូ​ឞ្វៃ​ជាន​ការ?” ");
INSERT INTO cmok_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","លែៈ​ខាន់​ពាង់​រី​គុ​អ្យាត់​ឆាក់​រាក់​ក្លាក់​ទើម មោ​អោស​ទូ​ហ្វេ​ងើយ ជេសរី​ឞ្រាស​យេឆូ ​ក្វាន់​ឞូនុយ្ស​អី​នៃ​ជាន​ឞាស​នាវ​ជី ដាៈ​ពាង់​ឆឹត​អា​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់​អី​នៃ៖ “តា​ផូង​ខាន់​មៃ លាស​គែស​ក៝ន​ឞូ​ក្លោ មោ​លាស​នទ្រោក​ខាន់​មៃ​តុប​តា​ត្រោម​នតូ​ទាក​តា​នារ​ឆាបាត់  លាស​នទ្រី​អើម​មោ​លាស​ខាន់​មៃ​ឆ៝ៈ​ពាង់​ឞើស? នទើ​អី​នៃ​ជេង​ជាន​ការ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ខាន់​ពាង់​មោ​អោស​ឞ្លាវ​អើស​នាវ​អី​នៃ​មា​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ឞ្រាស​យេឆូ ​ឆៃ​មពោល​ឞូ​នាច់​កើយ្ស​នតុក​គុ​ឞូ​លឺ ជេសរី​ពាង់​ងើយ​នាវ​នតឹត​មា​មពោល​អី​នៃ៖ ");
INSERT INTO cmok_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“លាស​គែស​ឞូ​ក្វាល់​ខាន់​មៃ​លាប់​ញេត​ឆោង​តា​នតុក​តឹម​នអាប់​ទូ​នតុក លើយ​ខាន់​មៃ​គុ​អោស​តា​នតុក​ឞូ​រ៝ង​អ៝ន់​មា​ឞូ​តេស​ឞូ​ក្វ៝ង់ ងខេប​លាស​គែស​ពាង់​ក្វាល់​ដ៝ង់​ឞូ​អី​ក្វ៝ង់​រាលាវ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","លាស​ឞូនុយ្ស​អី​តើម​តឹម​នអាប់​នៃ ពាង់​ក្វាល់​មៃ នទ្រែល​មា​ក្វាល់​ឞូនុយ្ស​អី​ក្វ៝ង់​រាលាវ​មៃ​ដ៝ង់ ពាង់​មរា​លាស​មា​មៃ៖ «ទាន់​នតុក​អី​អ្យា​អ៝ន់​មា​ឞូនុយ្ស​អី​អ្យា»​រ៝។ ជេសរី​មៃ​ព្លាច់​គុ​ឞើស​កើយ​ទុត​ឞូ​រី តា​ម៝ង​អី​នៃ​មៃ​គែស​នាវ​ដីត​ព្រេង​ឞូ​ទុត​ហោ។ ");
INSERT INTO cmok_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","លាស​នទ្រី អ៝ន់​ខាន់​មៃ​គុ​ឞើស​កើយ​ទុត​ឞូ​រី​ប៝ត់ ក៝ប់​ពាង់​នើម​អី​តើម​តឹម​នអាប់​នៃ​លាស៖ «ហើយ​ជាង់ ហាន់​គុ​អា​នតុក​អី​អ្វែស​អី​ឞូ​លឺ​អា​នាប់​អ្យា​ហ៝ម់» អី​នៃ​ជេង​នាវ​ឞូ​យើក​មា​មៃ​មា​លែៈ​ឞូ​អី​គុ​ឆោង​ឆា​នទ្រែល​តា​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ឞូ​ម៝ស​អី​នហាវ​អេង​ឆាក់​ពាង់​នើម កោរាញ​ឞ្រាស​ញជុរ​លើយ​ពាង់ យើន​មា​ឞូ​ម៝ស​អី​ញជុរ​អេង​ឆាក់​អុច​អ្យាត់​ពាង់ កោរាញ​ឞ្រាស​ឆើម​នហាវ​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ឞូនុយ្ស​អី​តើម​ជាៈ​ពាង់​ញេត​ឆោង​អី​នៃ៖ “លាស​មៃ​នទ្រាប់​នាវ​ញេត​ឆោង ងគូល​នារ មោ​លាស​កេង​មាង់ មៃ​លើយ​ជាៈ​អោស​មឹត​ជាង់ អ៝ស​នោ ឞាល់​មពោល មោ​លាស​ឞូនុយ្ស​ច្យៅ​មែង​អី​គែស​ទ្រាប់​នទើ​អ៝ក់ យ៝រ​លាស​មពោល​អី​នៃ​ព្លើង​ជាៈ​មៃ​ទើយ លាស​នទ្រី​លែៈ​គែស​ឞូ​ត្រ៝ៈ​មា​មៃ​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","យើន​មា​លាស​មៃ​នទ្រាប់​នាវ​ញេត​ឆោង អ៝ន់​មៃ​ជាៈ​ផូង​អ៝​អាច ផូង​លុត​ជ៝ង់​តី ផូង​ក្វែត​រាវែន នទ្រែល​មា​ផូង​ចែស​មាត់​ហ៝ៈ។ ");
INSERT INTO cmok_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","កើត​នទ្រី​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​មៃ​រ៝ យ៝រ​លាស​ទឹង​លែៈ​ឞូនុយ្ស​អី​នៃ ខាន់​ពាង់​មោ​អោស​ទើយ​ព្លើង​ជាៈ​មៃ​ដ៝ង់ យើន​មា​កោរាញ​ឞ្រាស​ទើម​ឆើម​ព្លើង​ត្រ៝ៈ​អ៝ន់​មា​មៃ ត៝ត់​មា​ពាង់​អ៝ន់​ឞូនុយ្ស​ឆ៝ង់​ឆ្រាង់​ទ៝ក់​រេស​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ជេស​ឞ្រាស​យេឆូ ​ងើយ​នៃ ទូ​ហ្វេ​ឞូ​ក្លោ​អី​គុ​ឆោង​ឆា​នទ្រែល ពាង់​លាស​មា​ឞ្រាស​យេឆូ ៖ “អ្វែស​មអាក​ងាន់​មា​ឞូនុយ្ស​អី​គុ​ឆោង​ក្វ៝ង់​ញេត​ក្វ៝ង់​នទ្រែល​តា​ប៝ន​អ្វែស​កោរាញ​ឞ្រាស”។ ");
INSERT INTO cmok_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","យើន​មា​ឞ្រាស​យេឆូ ​លាស​នាវ​ងើយ​នតឹត​មា​ពាង់៖ “គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​នទ្រាប់​នាវ​ញេត​ឆោង​ទុត​ក្វ៝ង់ ជេសរី​ពាង់​ជាៈ​ឞូ​នាច់​អ៝ក់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ត៝ត់​ទី​ម៝ង​ញេត​ឆោង​អី​នៃ ពាង់​ដាៈ​ទឹក​ពាង់​រី​ហាន់​មឞើស​ឞូ​លាស៖ «ហាន់​ហ៝ម់! ព្យាង់​ត្រាវ​នទ្រាប់​លែៈ​ជេស​លែៈ​ផ្យៅ»។ ");
INSERT INTO cmok_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","តីស​មា​ទឹង​លែៈ​ឞូ​នាច់​អី​នៃ​រាលាច់​ទាទេ ពាង់​អី​ឞើស​នាប់​រី​លាស​នអា៖ «គ៝ប់​មហែ​រាវាត់​មីរ​ទូ​លោក អាបៃ​រី​គ៝ប់​អុច​ហាន់​អ្វាញ់​ងាន់​រ៝ គ៝ប់​ទាន់​ទោយ្ស​មា​កោរាញ​មៃ​ហៃ»។ ");
INSERT INTO cmok_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ពាង់​អី​ទូ​ហ្វេ​ជឹត​លាស​នអា៖ «គ៝ប់​មហែ​រាវាត់​ជឹត​អឹ​នទ្រោក​ងក្វ៝ង់ គ៝ប់​អុច​រាល៝ង​តេៈ​ពាង់ គ៝ប់​ទាន់​ទោយ្ស​មា​កោរាញ​មៃ​ហៃ»។ ");
INSERT INTO cmok_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","អី​ទូ​ហ្វេ​រី​ជឹត​លាស​នអា៖ «គ៝ប់​មហែ​នអាប់​មេ កើត​នទ្រី​ទឹង​គ៝ប់​មោ​គែស​ហាន់​ឆោង​ឆា​នទ្រែល»។ ");
INSERT INTO cmok_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ទឹក​អី​នៃ​ព្លឹ​មឞើស​មា​កោរាញ​រី​តឹង​នាវ​អី​នៃ។ ជេសរី​កោរាញ​អី​នៃ​ជី​នូយ្ស​ហោ​ងាន់ លាស​មា​ទឹក​ពាង់​រី៖ «ឞ្រោៈ​អ៝ន់​គើញ​ហ៝ម់ រ៝ៈ​ត្រ៝ង​ក្វ៝ង់​ត្រ៝ង​ជេៈ តា​ប៝ន​ក្វ៝ង់​អ្យា ជាៈ​លែវ​ផូង​អ៝​អាច ផូង​លុត​ជ៝ង់​តី ផូង​ក្វែត​រាវែន ផូង​ចែស​មាត់​ហាន់​ញេត​ឆោង​តា​អ្យា»។ ");
INSERT INTO cmok_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ជេស​ជាន​កើត​នៃ ពាង់​មឞើស​មា​កោរាញ​ពាង់៖ «ហើយ​កោរាញ! លែៈ​ជេស​គ៝ប់​ជាន​តឹង​នាវ​មៃ​ដាៈ​នៃ យើន​មា​នតុក​ហោម​អែ​រាមែស​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","អី​កោរាញ​នៃ​ដាៈ​ជឹត៖ «ហាន់​ឞ្រោៈ​រ៝ៈ​ត្រ៝ង​រ៝ៈ​មីរ ញច៝ប់​ដាៈ​ឞូ​ហាន់​អ៝ន់​ឞេង​ជៃ​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ខាន់​អៃ​មៃ​អ្យាត់​នាវ​គ៝ប់​លាស លែៈ​ឞូនុយ្ស​អី​លែៈ​ជេស​គ៝ប់​ជាៈ​នើស គ៝ប់​មោ​ហោម​អោស​អ៝ន់​ទូ​ហ្វេ​ច៝ក់​ព្យាង់​ត្រាវ​គ៝ប់!»” ");
INSERT INTO cmok_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","គែស​អ៝ក់​ឞូនុយ្ស​ឞ្រោៈ​តឹង​ឞ្រាស​យេឆូ ។ ពាង់​ងគឹល​ជឹត​ផូង​អី​នៃ ជេសរី​លាស​មា​ខាន់​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“លាស​ឞូ​ម៝ស​អុច​តឹង​គ៝ប់ តីស​មា​មោ​រ៝ង់​គ៝ប់​រាលាវ​ដាស​នាវ​ពាង់​រ៝ង់​មេៈ​ឞឹ អូរ​ក៝ន អ៝ស​នោ​អ៝ស​នូរ ឞ៝ល​លាស​ដាស​នាវ​រេស​ពាង់​នើម​កាដោយ ឞូនុយ្ស​អី​នៃ​ជាន​អ៝ស​ម៝ន​គ៝ប់​មោ​ទើយ​អោស។ ");
INSERT INTO cmok_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ជេសរី​ឞូ​ម៝ស​អី​មោ​តូយ​ឆី​តឹម​រាកាង់​ពាង់​នើម​ឞ្រោៈ​តឹង​គ៝ប់ ជេង​គែស​នាវ​ខ្លៃ​មោ​អ្យាត់​ទឹង​លែៈ​នាវ​កោរាញ​ឞ្រាស​ដាៈ​ឞ៝ល​លាស​ត៝ត់​ខឹត​ឆាក់​កាដោយ ឞូនុយ្ស​អី​នៃ​មោ​ទើយ​ជាន​អ៝ស​ម៝ន​គ៝ប់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","លាស​ខាន់​អៃ​មៃ​អុច​តឹង​គ៝ប់ អ៝ន់​ខាន់​អៃ​មៃ​គឹត​នហេល​ល៝រ។ កើត​នទ្រី​លាស​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​អុច​ជាន​ជៃ​ក្វ៝ង់ ពាង់​គុ​មឹន​ល៝រ​មើ ទាស​អ៝ក់​លែៈ​ហ្វាច​ជាន ទាស​អ៝ក់​គែស​ព្រាក់​តា​ឆាក់​ពាង់​នើម​រី​គៃ​មា​គឹត​ជាន​ជេស មោ​លាស​មោ​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ក្លាច​លាស​តេៈ​មែស​ជេស​លែៈ​ផ្យៅ តីស​មា​ជាន​មោ​ទើយ​ជេស។ កើត​នទ្រី​ឞូ​ម៝ស​អី​ឆៃ ឞូ​គើម​មឺច ");
INSERT INTO cmok_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","កើត​នអា៖ «ពាង់​អ្យា​ជាន​ជៃ តីស​មា​មោ​ទើយ​ជេស​ហ្យាស!» ");
INSERT INTO cmok_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","មោ​លាស លាស​គែស​ទូ​ហ្វេ​កាដាច់ ជេសរី​ពាង់​អុច​តឹម​លើស​ដាស​ទូ​ហ្វេ​កាដាច់​អេង លាស​នទ្រី​កាដាច់​អី​នៃ​គុ​មឹន​តឹម​ញច្រាៈ​ល៝រ​មើ លាស​ពាង់​គែស​តាហែន ១០០០០ នុយ្ស​ទើម ទើយ​តឹម​រាទ៝ង់​ដាស​កាដាច់​អី​លែវ​តាហែន ២០០០០ នុយ្ស​នៃ​លាស​មោ។ ");
INSERT INTO cmok_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","លាស​ពាង់​គឹត​លាស​មោ​ទើយ​រ៝ ពាង់​ដាៈ​ឞូនុយ្ស​ឆើម​នតាង​ពាង់​ឞ្រោៈ​អោប មើម​ជាន​គៃ​មា​គែស​នាវ​ដាប់​មពាន់ ទោល​កាដាច់​អី​នៃ​ហោម​អែ​ងាយ។ ");
INSERT INTO cmok_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","កើត​នទ្រី​តា​ផូង​ខាន់​អៃ​មៃ​នៃ ឞូ​ម៝ស​អី​មោ​ទើយ​បាស​មា​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​នើម​គែស ឞូនុយ្ស​អី​នៃ​មោ​អោស​ទើយ​ជាន​អ៝ស​ម៝ន​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ឞ៝ស​ជេង​ទូ​នតីល​នទើ​តេៈ​ត្រាវ​មា​កាស​ងាន់ លាស​ឞ៝ស​អី​នៃ​មោ​ហោម​គែស​កាស មើម​ហោម​ឞ្លាវ​ជាន​គៃ​មា​អ៝ន់​ព្លឹ​កាស​ជឹត? ");
INSERT INTO cmok_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ពាង់​មោ​ហោម​អោស​គែស​នាវ​ខ្លៃ​ជឹត ឞ៝ល​លាស​ឆ៝ៈ​ព៝ត​លាយ​មា​នែស មោ​លាស​មា​អាច់​នទ្រោក​មោ​ហោម​គែស​នាវ​ខ្លៃ​ដ៝ង់ ផាលាស​មា​ងខុត​មអារ់​លើយ​ឞើស​ទីស​ទើម។ ឞូ​ម៝ស​គែស​តោរ​មា​អ្យាត់ អ៝ន់​អ្យាត់​ទោ!” ");
INSERT INTO cmok_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ជេសរី​គែស​ទូ​នារ គែស​មពោល​ក៝ប់​ឆ៝ៈ​ព្រាក់​ឞើស​ឞូ​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ នទ្រែល​មា​ឞូនុយ្ស​អី​ឞូ​កើប​ជេង​ឞូនុយ្ស​តីស រាន​វាច់​តា​ឞ្រាស​យេឆូ ​រី​ទាទេ គៃ​មា​អ្យាត់​នាវ​ពាង់​ងើយ។ ");
INSERT INTO cmok_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ជេសរី​ផូង​ផារីឆី  នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  ខាន់​ពាង់​ងើយ​បុក​ងើយ​ឆ្វីស​លាស៖ “ល៝ង់​ពាង់​អី​នៃ​រ៝ម​ឞូនុយ្ស​តីស ឆោង​ឆា​នទ្រែល​ខាន់​ពាង់​ដ៝ង់!” ");
INSERT INTO cmok_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់​មា​នាវ​ងើយ​នតឹត៖ ");
INSERT INTO cmok_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“នតឹត​លាស​តា​ផូង​ខាន់​មៃ ឞូ​ម៝ស​គែស​ឞែ​ឞ្យាប់ ១០០ ជេសរី​រ៝ស​ទូ​មល៝ម់ ពាង់​មរា​នត្លើយ​ឞែ​ឞ្យាប់ ៩៩ អី​នៃ​តា​ឞ្រី​រាទាស ជេសរី​ហាន់​ជ៝យ​ងាន់​ជ៝យ​ងាន់​ទូ​មល៝ម់​ឞែ​ឞ្យាប់​អី​រ៝ស​នៃ​អ៝ន់​ត៝ត់​ឆៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ត៝ត់​ឆៃ​រី ពាង់​រាម់​មអាក​ងាន់ ពឺ​ឞែ​ឞ្យាប់​អី​នៃ​តេៈ​តា​មលីក​ពាង់​នើម​រី ជេសរី​ព្លឹ​ឆឹត​តៃ​តា​នតុក​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ឆឹត​ត៝ត់​អា​ជៃ​ពាង់​នើម​រី ពាង់​ក្វាល់​មឹត​ជាង់​ពាង់ នទ្រែល​មា​អ៝ស​នោ​ច្យៅ​មែង មឞើស​មា​ខាន់​ពាង់៖ «ហើយ​ខាន់​អៃ​មៃ​កើល​រាម់​មអាក​នទ្រែល​គ៝ប់​ហ៝ម់ យ៝រ​លាស​ឞែ​ឞ្យាប់​គ៝ប់​អី​រ៝ស​នើស​លែៈ​ឆៃ​ជេស»។ ");
INSERT INTO cmok_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","គ៝ប់​មឞើស​មា​ខាន់​មៃ គែស​នាវ​រាម់​មអាក​ហោ​ងាន់​តា​កាលើ​ត្រោក​តា​នតុក​កោរាញ​ឞ្រាស​នើម មា​ទូ​ហ្វេ​ឞូនុយ្ស​តីស​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស រាលាវ​មា​ឞូនុយ្ស​ឆ៝ង់ ៩៩ អី​មោ​ហោម​ខាច់​រាគ៝ល់​នូយ្ស​នហ៝ម់​អ្យើស”។ ");
INSERT INTO cmok_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ឞ្រាស​យេឆូ ​ងើយ​ទូ​នាវ​នតឹត​ជឹត៖ “នតឹត​លាស លាស​គែស​ទូ​ហ្វេ​ឞូ​អូរ​គែស​ជឹត​មល៝ម់​ព្រាក់​កាក់ ជេសរី​រ៝ស​ទូ​កាក់ ពាង់​មរា​មពេស​នទ៝ក់​មរ៝ម់ មពេស​អុញ​ងអាង​រ៝ៈ​ពុង​រ៝ៈ​ញជោញ​ជ៝យ​រាម្យាង់​អ៝ន់​ត៝ត់​ឆៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ត៝ត់​មា​ឆៃ​រី ពាង់​ក្វាល់​មឹត​ជាង់​ពាង់ នទ្រែល​មា​អ៝ស​នោ​ច្យៅ​មែង មឞើស​មា​ខាន់​ពាង់៖ «ហើយ​ខាន់​អៃ​មៃ​កើល​រាម់​មអាក​នទ្រែល​គ៝ប់​ហ៝ម់ យ៝រ​លាស​ព្រាក់​គ៝ប់​អី​រ៝ស​នើស​លែៈ​ឆៃ​ជេស»។ ");
INSERT INTO cmok_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","គ៝ប់​មឞើស​មា​ខាន់​មៃ តោង​ពារ់​កោរាញ​ឞ្រាស​គែស​នាវ​រាម់​មអាក​ទុត​ហោ យ៝រ​លាស​គែស​ទូ​ហ្វេ​ទើម​ឞូនុយ្ស​តីស​លែៈ​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស”។ ");
INSERT INTO cmok_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ឞ្រាស​យេឆូ ​លាស​ជឹត៖ “គែស​ទូ​ហ្វេ​ឞូនុយ្ស​គែស​ឞារ​ហៃ​ក៝ន​ឞូ​ក្លោ។ ");
INSERT INTO cmok_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","គែស​ទូ​នារ អី​ក៝ន​មពុត​នៃ​លាស​មា​ឞឹ​ពាង់៖ «ហើយ​ឞឹ ដាៈ​មៃ​ពាៈ​ទ្រាប់​នទើ​ខ្លៃ​អី​មៃ​អុច​ពាៈ​អ៝ន់​មា​គ៝ប់​នោក​មៃ​ខឹត មៃ​ពាៈ​ហ៝ម់​អ៝ន់​គ៝ប់​អាបៃ​អ្យា​រ៝។ គ៝ប់​មោ​អុច​អោស​ក៝ប់​ត៝ត់​មៃ​ខឹត»។ ជេសរី​អី​ឞឹ​រី​ពាៈ​ទ្រាប់​នទើ​ខ្លៃ​អ៝ន់​មា​លែៈ​ឞារ​ហៃ​ក៝ន​នៃ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ត៝ត់​ឞារ​ពែ​នារ​ឞើស​កើយ​នៃ អី​ក៝ន​មពុត​រី​ពាង់​តាច់​ទឹង​លែៈ​ទ្រាប់​នទើ​ពាង់​នើម ជេសរី​ញអោត​ព្រាក់​ហាន់​ជឹត​ឞ្រី​ងាយ។ តា​ឞ្រី​អី​នៃ​ពាង់​ទឹ​ញរីស​(មអីស​មអែស) ព្រាក់​ពាង់​នើម​ត៝ត់​លែៈ។ ");
INSERT INTO cmok_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ត៝ត់​មា​លែៈ​ព្រាក់​រី ល៝ង់​តា​ឞ្រី​អី​នៃ​នតើម​គែស​នាវ​ជី​ឆ៝ត់​ជី​ង៝ត​ទុត​ហោ អី​ពាង់​នើម​រី​លែៈ​អ៝​អាច​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ជេសរី​ពាង់​ហាន់​ទាន់​គុ​ជាន​ការ​ឞូ​ទូ​ហ្វេ​តា​ឞ្រី​នៃ ឞូ​ដាៈ​ពាង់​ម៝ត់​ឆុរ​ផូង​រ៝ៈ​មីរ។ ");
INSERT INTO cmok_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ពាង់​អុច​ងាន់​មា​មពា​ឞូ​អ៝ន់​ឆុរ​ឆា​គៃ​មា​ឞាស​ជី​ង៝ត តីស​មា​មោ​គែស​អោស​ឞូ​អ៝ន់​ពាង់​ឆា។ ");
INSERT INTO cmok_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ត៝ត់​ទូ​នារ​ពាង់​កាស​គឹត​ឆាក់ ពាង់​មឹន​អេង​តា​ឆាក់​ពាង់​នើម​រី៖ «ទឹង​លែៈ​ឞូនុយ្ស​ជាន​ការ​មា​ឞឹ​គ៝ប់​គែស​នទើ​ឆោង​ឆា​ត៝ង់​រាមែស ល៝ង់​គ៝ប់​គុ​តា​អ្យា​តាច់​ព្រ៝ច​អុច​មា​ខឹត​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","គ៝ប់​ព្លឹ​ឆឹត​មា​ឞឹ​ហើយ្ស មឞើស​មា​ពាង់៖ «ហើយ​ឞឹ ក៝ន​ជាន​តីស​មា​កោរាញ​ឞ្រាស ជេសរី​ជាន​តីស​មា​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","គ៝ប់​អ្យា​មោ​ហោម​អោស​ទី​មៃ​ក្វាល់​ជេង​ក៝ន​មៃ​ជឹត​ឞឹ ទាន់​មៃ​កើប​គ៝ប់​ជេង​ឞូនុយ្ស​ជាន​ការ​មា​មៃ​ទើម​ហ៝ៈ»»។ ");
INSERT INTO cmok_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ជេស​មឹន​កើត​នៃ​ពាង់​ទ៝ក់​ឆឹត​មា​ឞឹ​ពាង់​រ៝។ ពាង់​ហាន់​រ៝ៈ​ត្រ៝ង​ឞឹ​ពាង់​ឆៃ​ហោម​ងាយ ត៝ត់​មា​ឆៃ​ឞឹ​ពាង់​យោៈ​នអាច​ហោ​ងាន់ ញច្វាត់​រាន​អូត​អី​ក៝ន​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ជេសរី​អី​ក៝ន​រី​មឞើស​មា​ឞឹ៖ «ហើយ​ឞឹ ក៝ន​ជាន​តីស​មា​កោរាញ​ឞ្រាស ជេសរី​ជាន​តីស​មា​ឞឹ​ដ៝ង់ គ៝ប់​អ្យា​មោ​ហោម​អោស​ទី​មៃ​ក្វាល់​ជេង​ក៝ន​មៃ​ជឹត ឞឹ»។ ");
INSERT INTO cmok_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ជេសរី​អី​ឞឹ​នៃ​មឞើស​មា​ទឹក​ពាង់៖ «ហាន់​ឆ៝ៈ​ឞ៝ក​អាវ​អី​ទុត​អ្វែស​អ៝ន់​គើញ ញឆ៝ស​អ៝ន់​មា​ក៝ន​គ៝ប់​អ្យា ជេសរី​ឆ៝ៈ​រាគេន នទ្រែល​មា​នតោ​ជ៝ត​ឆើម​នត្រុប​អ៝ន់​ពាង់​ដ៝ង់ គៃ​មា​ញហើ​ពាង់​ជេង​ក៝ន​គ៝ប់​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ជេសរី​ឆ៝ៈ​ក៝ន​នទ្រោក​អី​ពេត​អេង​នើស​លាច់​គុច​ញេត​ឆោង​ឆា​អ៝ន់​មអាក‌ ");
INSERT INTO cmok_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","យ៝រ​លាស​ក៝ន​គ៝ប់​នើស​តឹម​ឞាន​មា​ខឹត អាបៃ​អ្យា​ពាង់​លែៈ​រេស​ជឹត ពាង់​នើស​រ៝ស អាបៃ​អ្យា​លែៈ​គ៝ប់​ឆៃ​ដ៝ង់»។ ជេសរី​ខាន់​ពាង់​លែវ​ឞាល់​ញេត​ឆោង​ឆា​មអាក​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","នោក​នៃ​អី​ក៝ន​ឞោក​ទាក​រី​គុ​អា​មីរ។ ត៝ត់​ពាង់​ឆឹត​ឞើយ​ត៝ត់​អា​ជៃ តាង់​នតែស​គ៝ង​គ៝រ់ នទ្រែល​មា​រ៝ម់​មព្រើ‌ ");
INSERT INTO cmok_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ពាង់​ក្វាល់​ទូ​ហ្វេ​ទឹក​អោប៖ «ម៝ស​នទើ​ជាន​នៃ?» ");
INSERT INTO cmok_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ទឹក​អី​នៃ​មឞើស​មា​ពាង់៖ «អ៝ស​មៃ​លែៈ​ឆឹត។ ឞឹ​មៃ​ដាៈ​ឞូ​លាច់​គុច​ក៝ន​នទ្រោក​អី​ឞ៝ន់​ពេត​នើស យ៝រ​លាស​ក៝ន​ពាង់​ព្លឹ​ឆឹត​គែស​នាវ​អ្វែស​លាង់»។ ");
INSERT INTO cmok_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ក៝ន​ឞោក​ទាក​អី​នៃ​ជី​នូយ្ស​រាមាវ​ងាន់ មោ​អុច​អោស​លាប់​ត្រោម​ជៃ ជេសរី​អី​ឞឹ​រី​លោស​អា​ទីស​អ្យា​ឞ៝ញ​ដាៈ​ពាង់​លាប់។ ");
INSERT INTO cmok_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ពាង់​អើស​មា​អី​ឞឹ៖ «គ៝ប់​គុ​នទ្រែល​មៃ​លែៈ​ជ៝ៈ​នាម់​ងាន់ មោ​អោស​រាលាវ​ឞ៝រ់​មឞូង​មៃ ជេសរី​ឞ៝ល​លាស​អី​ក៝ន​ឞែ​មៃ​មោ​អ៝ន់​មា​គ៝ប់ គ៝ប់​ឞែ​មា​លាច់​គុច​ញេត​ឆោង​ឆា​នទ្រែល​មឹត​ជាង់ ទូ​មល៝ម់​មោ​អើម។ ");
INSERT INTO cmok_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ល៝ង់​អី​ក៝ន​មៃ​អី​នៃ ពាង់​ទឹ​ញរីស​(មអីស​មអែស) លែៈ​ទ្រាប់​នទើ​មៃ ឆ៝ៈ​ទ៝ង់​គុ​ដាស​ឞូ​អូរ​អេងៗ យើន​មា​ត៝ត់​មា​ពាង់​ព្លឹ​ឆឹត​មៃ​លាច់​ក៝ន​នទ្រោក​អី​ពេត​អ៝ន់​មា​ពាង់​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","អី​ឞឹ​អើស​មា​ពាង់៖ «ហើយ​នោ មៃ​គុ​នទ្រែល​គ៝ប់​មរ៝ លែៈ​នទើ​គ៝ប់​ហោម​គែស​នើស​ជេង​នទើ​មៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","យ៝រ​លាស​អ៝ស​មៃ​អី​នៃ​នើស​តឹម​ឞាន​មា​ខឹត អាបៃ​អ្យា​លែៈ​រេស​ជឹត ពាង់​នើស​រ៝ស អាបៃ​អ្យា​លែៈ​ឞ៝ន់​ឆៃ​ដ៝ង់ លាស​នទ្រី​អ៝ន់​ឞ៝ន់​ញេត​ឆោង​ឆា​មអាក»”។ ");
INSERT INTO cmok_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “គែស​ទូ​ហ្វេ​ឞូនុយ្ស​នទ្រ៝ង់ ពាង់​អ៝ន់​ទូ​ហ្វេ​ឞូនុយ្ស​ជាន​ការ​ម៝ត់​អ្វាញ់​ទ្រាប់​នទើ​ពាង់។ ជេសរី​គែស​ឞូ​ឞ្រោៈ​មឞើស​មា​ឞូនុយ្ស​នទ្រ៝ង់​អី​នៃ​លាស ឞូនុយ្ស​អី​ម៝ត់​អ្វាញ់​អី​នៃ​ទឹ​ញរីស​(មអីស​មអែស)​ទ្រាប់​នទើ​ពាង់​ទុត​ហោ។ ");
INSERT INTO cmok_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ជេសរី​ឞូនុយ្ស​អី​នទ្រ៝ង់​ក្វាល់​ឞូនុយ្ស​អី​ម៝ត់​អ្វាញ់​អី​នៃ​លាស៖ «ល៝ង់​មៃ​ងក៝ច​មា​គ៝ប់​អី​ទ្រាប់​នទើ​គ៝ប់​មៃ​ម៝ត់​អ្វាញ់ ម៝ស​នទើ​លែៈ​គែស​អាបៃ​អ្យា? យ៝រ​លាស​លែៈ​នាវ​គ៝ប់​តាង់​ឞូ​ងក៝ច​មា​មៃ​មោ​អោស​គែស​នាវ​អ្វែស នទ្រី​មៃ​មោ​ហោម​អោស​ម៝ត់​អ្វាញ់​ទ្រាប់​នទើ​គ៝ប់​ជឹត»។ ");
INSERT INTO cmok_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ឞូនុយ្ស​អី​នៃ​ងក្ល៝ន់​អេង​តា​ឆាក់​ពាង់​នើម​រី៖ «ឞាស​កោរាញ​មោ​អោស​អ៝ន់​គ៝ប់​ម៝ត់​អ្វាញ់​ទ្រាប់​នទើ​ពាង់​ជឹត។ លាស​នទ្រី​ម៝ស​នទើ​ជាន​គ៝ប់​អី​រី​តៃ? លាស​ព៝ក់​នែស​ហ៝ៈ​មោ​ទើយ លាស​ទាន់​ឞូ​ហ៝ៈ​ដីត។ ");
INSERT INTO cmok_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","អោ! គឹត​ហើយ្ស គ៝ប់​មរា​ជាន​កើត​នអា គៃ​មា​ឞូ​រ៝ម​គ៝ប់​គុ​តា​ជៃ​ខាន់​ពាង់ លាស​ពាង់​មោ​ហោម​អ៝ន់​គ៝ប់​ជាន​ការ​អ្យា​តៃ»។ ");
INSERT INTO cmok_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ជេសរី​ពាង់​ក្វាល់​ទឹង​លែៈ​ឞូនុយ្ស​អី​ហោម​រាន៝ន​ដាស​កោរាញ​ពាង់​រី​នើស អ៝ន់​លាប់​ទូ​ហ្វេ​ទូ​តឹ ពាង់​អោប​ឞូនុយ្ស​អី​ឞើស​នាប់​រី៖ «ទាស​អ៝ក់​មៃ​ហោម​រាន៝ន​មា​កោរាញ​គ៝ប់​មេស?» ");
INSERT INTO cmok_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ឞូនុយ្ស​អី​នៃ​មឞើស​មា​ពាង់៖ «ហោម​ងី ១០០ យាង់​ទុង​យាង់​ក្រែង»។ ពាង់​លាស​មា​ឞូនុយ្ស​អី​នៃ៖ «ឆ៝ៈ​ងាច់​ហ៝ម់​ឆ៝ម់បុត​រាន៝ន​មៃ​ញចីស​តេៈ​លាស ៥០ យាង់​ទុង​យាង់​ក្រែង​ហ៝ៈ»។ ");
INSERT INTO cmok_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ជេសរី​ពាង់​អោប​ទូ​ហ្វេ​ឞូនុយ្ស​ជឹត៖ «មៃ​ទាស​អ៝ក់​ហោម​រាន៝ន​មា​កោរាញ​គ៝ប់​មេស?» ឞូនុយ្ស​អី​នៃ​មឞើស​មា​ពាង់៖ «ហោម​ឞា ១០០ ឆាស»។ ពាង់​លាស​មា​ឞូនុយ្ស​អី​នៃ៖ «ឆ៝ៈ​ឆ៝ម់បុត​រាន៝ន​មៃ​ហ៝ម់​ញចីស​តេៈ​លាស ៨០ ឆាស​ហ៝ៈ»។ ");
INSERT INTO cmok_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ជេសរី​អី​កោរាញ​រី​រានេ​មា​ឞូនុយ្ស​ម៝ត់​អ្វាញ់​ក្វែ​អី​នៃ យ៝រ​លាស​ពាង់​ឞ្លាវ​គឹត​មឹន​ងាន់។ នទ្រី​ឞូនុយ្ស​មោ​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​ឞ្លាវ​រាលាវ​ឞូនុយ្ស​អ្យាត់ យ៝រ​លាស​ខាន់​ពាង់​ឞ្លាវ​ជ៝យ​ឆា គៃ​មា​គែស​នាវ​រេស​អ្វែស​តា​នែស​នតូ​អ្យា។ យើន​មា​ឞូនុយ្ស​អ្យាត់​នាវ​កោរាញ​ឞ្រាស​មោ​អោស​ឞ្លាវ​កើត​ខាន់​ពាង់​គុ​រេស​គឹត​មា​នាវ​រេស​អ្វែស​តា​នារ​ជឹត​នាប់​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ នោក​ខាន់​អៃ​មៃ​ហោម​គុ​តា​នែស​នតូ​អ្យា ពាៈ​ទ្រាប់​នទើ​ខាន់​អៃ​មៃ​នើម​ជាន​មឹត​ជាង់​នទ្រែល​ឞូនុយ្ស​អ៝ក់ គៃ​មា​ត៝ត់​ខាន់​អៃ​មៃ​ខឹត​ឆឹត​ប៝ន​អ្វែស​តា​កាលើ​ត្រោក​រី មឹត​ជាង់​ខាន់​អៃ​មៃ​នៃ​រ៝ម​គុ​នទ្រែល​នហ៝​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ឞូ​ម៝ស​ឆ៝ង់​មា​ជាន​នទើ​ជេៈ ពាង់​ឆ៝ង់​មា​ជាន​នទើ​ក្វ៝ង់​ដ៝ង់។ ឞូ​ម៝ស​ក្វែ​មា​ជាន​នទើ​ជេៈ ពាង់​ក្វែ​មា​ជាន​នទើ​ក្វ៝ង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","លាស​នទ្រី លាស​ខាន់​អៃ​មៃ​មោ​ឆ៝ង់​អុច​ឆា​ញឆ្យាន់​មា​ទ្រាប់​នទើ​ខាន់​អៃ​មៃ​នើម​តា​នែស​នតូ​អ្យា កោរាញ​ឞ្រាស​មោ​អោស​អ៝ន់​មា​ខាន់​អៃ​មៃ​ទ្រាប់​នទើ​អី​គែស​នាវ​ខ្លៃ​ងាន់​តា​ប៝ន​អ្វែស​តា​កាលើ។ ");
INSERT INTO cmok_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","លាស​ខាន់​អៃ​មៃ​មោ​ឆ៝ង់​មា​ទ្រាប់​នទើ​ឞូ​អេង មើម​កោរាញ​ឞ្រាស​ទើយ​អ៝ន់​ទ្រាប់​នទើ​មា​ខាន់​អៃ​មៃ​តា​ប៝ន​អ្វែស​តា​កាលើ? ");
INSERT INTO cmok_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​ទើយ​ជាន​ការ​អ៝ន់​មា​ឞារ​ហៃ​កោរាញ យ៝រ​លាស​ពាង់​មរា​រ៝ង់​មា​ទូ​ហ្វេ​កោរាញ ជេសរី​ឞ្យាញ់​មា​ទូ​ហ្វេ​កោរាញ​អី​អេង មោ​លាស​តឹង​ជឹត​ទូ​ហ្វេ មឺច​អី​ទូ​ហ្វេ​អី​អេង​រី។ កើត​នទ្រី​ខាន់​អៃ​មៃ​យើក​មឞាស​មា​កោរាញ​ឞ្រាស​ដ៝ង់ យើក​មឞាស​មា​ទ្រាប់​នទើ​តា​នែស​នតូ​ដ៝ង់​មោ​ទើយ​អោស”។ ");
INSERT INTO cmok_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","គែស​ផូង​ផារីឆី ​តាង់​នាវ​ងើយ​កើត​នៃ ខាន់​ពាង់​គើម​មឺច​មា​ឞ្រាស​យេឆូ  យ៝រ​លាស​ខាន់​ពាង់​នើស​រ៝ង់​មា​ព្រាក់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ជេង​ផូង​អុច​ជាន​ឆ៝ង់​អ៝ន់​មាត់​ឞូនុយ្ស​ឆៃ យើន​មា​កោរាញ​ឞ្រាស​លែៈ​គឹត​ជេស​នូយ្ស​នហ៝ម់​ខាន់​មៃ។ គែស​អ៝ក់​នទើ​អី​ឞូនុយ្ស​កើប​ខ្លៃ តីស​មា​កោរាញ​ឞ្រាស​ឞ្យាញ់​ងាន់​នទើ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ឆ៝ម់បុត​នាវ​វៃ​ផូង​ឞ៝ន់ នទ្រែល​មា​ឆ៝ម់បុត​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស ទឹង​លែៈ​នទើ​លែៈ​គែស​ញចីស​តា​នៃ​កោរាញ​ឞ្រាស​អ៝ន់​ផូង​ឞ៝ន់​អ្យាត់ នហ៝​មា​ត៝ត់​យោហាន-​បាប់តែម ​នតើម​នតុម​នតី​ឞូ។ តាៈ​ឞើស​យោហាន-​បាប់តែម ​អី​នៃ​គ៝ប់​មឞើស​ងក៝ច​នតី​នាវ​មហែ​មហាន​អ្វែស​មា​នាវ​កោរាញ​ឞ្រាស​អុច​ម៝ត់​អ្វាញ់​ឞូនុយ្ស។ អ៝ន់​ទឹង​លែៈ​ឞូនុយ្ស​ញឆ្រោយ្ស​គៃ​មា​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","យើន​មា​នាវ​វៃ​ផូង​ឞ៝ន់​អី​កោរាញ​ឞ្រាស​អ៝ន់​មោ​អោស​ទើយ​រាគ៝ល់។ ត្រោក នទ្រែល​មា​នែស​នតូ​ឞ្លាវ​រ៝ស យើន​មា​តា​នាវ​វៃ​អី​នៃ​ឞ៝ល​លាស​តា​នាវ​អី​ទុត​ជេៈ​កាដោយ​មោ​អោស​ឞ្លាវ​រ៝ស។ ");
INSERT INTO cmok_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","នតឹត​លាស​ឞូ​ម៝ស​នត្លើយ​អូរ ជេសរី​ឆ៝ៈ​តៃ​អូរ​អេង​ជឹត ឞូ​ក្លោ​អី​នៃ​ជេង​ឞូនុយ្ស​ល៝ម់​អូរ។ ឞូ​ម៝ស​ឆ៝ៈ​អូរ​ដាស​ឞូ​អូរ​ឆាយ​នត្លើយ ឞូ​ក្លោ​អី​នៃ​ជេង​ឞូនុយ្ស​ល៝ម់​អូរ​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ជេសរី​ឞ្រាស​យេឆូ ​ងើយ​ជឹត៖ “គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​នទ្រ៝ង់ ពាង់​ញឆ៝ស​ងគូត​មា​ឞ៝ក​អាវ​អី​អ្វែសៗ​ងាន់ ឆ៝ៈ​ឞើស​ឞ៝ក​ឆូត​ឞ៝ក​ហូល ពាង់​គុ​រេស​មអាក​ងាន់​ឆោង​ឆា​ព្យាង់​ត្រាវ​កាស​ងាន់​អ៝ក់​រាមែស​អាប់​នារ។ ");
INSERT INTO cmok_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","គែស​ដ៝ង់​ទូ​ហ្វេ​ឞូ​ក្លោ​អ៝​អាច​រាញា​ពាង់​លាឆារ  លាម​ឆាក់​ជាន់​ពាង់​គែស​ឆោត​គ្រាយ្ស​ទាទេ ឞូ​លែវ​ពាង់​អ៝ន់​ឞិច​តា​ឞោក​មពោង​ជៃ​ឞូនុយ្ស​នទ្រ៝ង់​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ពាង់​អុច​ងាន់​ឆា​ព្យាង់​នទាក់​ត្រាវ​នទាក់​អី​ត្រោស​ឞើស​លើ​ញឆឺង​ឆោង​ឞូនុយ្ស​នទ្រ៝ង់​អី​នៃ​គៃ​មា​ឞាស​ជី​ង៝ត គែស​នអ៝ប់​មា​ឆ៝​ហាន់​លែរ​ឆោត​គ្រាយ្ស​ពាង់​តា​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ត៝ត់​ទូ​នារ​ឞូនុយ្ស​អ៝​អាច​អី​នៃ​ខឹត ជេសរី​ផូង​តោង​ពារ់​លែវ​ពាង់​គុ​នទ្រែល​អាឞ្រាហាម់ ​អី​ចែ​ផូង​ឞ៝ន់​តា​ប៝ន​អ្វែស​តា​កាលើ​គៃ​មា​គុ​រេស​អ្វែស​តា​រី។ ឞូនុយ្ស​នទ្រ៝ង់​អី​នៃ​ខឹត​ដ៝ង់ ឞូ​លែវ​ត៝ប់​ពាង់​តា​មោច។ ");
INSERT INTO cmok_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ជេសរី​ពាង់​គុ​តា​ឞ្រី​ផាន តា​ឞ្រី​ផាន​រី​គែស​នាវ​រេស​រាញាល់​ក្រីត​ជេរ​ទុត​ហោ​ងាន់​មា​ឞូនុយ្ស​នទ្រ៝ង់​អី​នៃ ពាង់​ងគើរ​អ្វាញ់​ឆៃ​ចែ​អាឞ្រាហាម់ ​ឞើស​ងាយ នទ្រែល​មា​លាឆារ ​គុ​កេង​ពាង់​រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ឞូនុយ្ស​នទ្រ៝ង់​អី​នៃ​នតែរ​ក្វាល់​ចែ​អាឞ្រាហាម់ ៖ «ហើយ​ចែ! ទាន់​មៃ​យោៈ​នអាច​មា​គ៝ប់​បាៈ​អើ។ ឆើម​ដាៈ​លាឆារ ​ដាៈ​ពាង់​យុក​ទាក​មា​លាវ​តី ជេសរី​ហាន់​នត្រោស​តា​មព្យាត់​គ៝ប់​អ្យា​អ៝ន់​មា​នអីក​អ៝យ យ៝រ​លាស​គុ​តា​អុញ​អ្យា​គែស​នាវ​រេស​ញជី​ទុត​ហោ​ងាន់»។ ");
INSERT INTO cmok_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ចែ​អាឞ្រាហាម់ ​អើស​មា​ពាង់៖ «ហើយ​ឆៅ! អ៝ន់​មៃ​កាស​គឹត ទោល​មៃ​ហោម​រេស​តា​នែស​នតូ​នើស មៃ​លែៈ​នាល់​មា​នាវ​អ្វែស​ងាន់ ល៝ង់​លាឆារ ​អ្យា​ពាង់​នាល់​មា​នាវ​អ្យើស​ទើម។ អាបៃ​អ្យា​លាឆារ ​លែៈ​គែស​នាវ​ឞ៝ញ​តា​អ្យា​ហើយ អី​មៃ​នៃ​មៃ​គុ​តា​នាវ​រេស​ញជី​ទុត​ហោ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","គែស​ដ៝ង់​នតូ​ឞ្រ៝ង់​ទុត​ហ្វី​វាស​វាង​ហេន​មា​មៃ កើត​នទ្រី​ទឹង​ឞូ​ម៝ស​អុច​ហាន់​ឞើស​នតុក​អ្យា​ជឹត​នតុក​មៃ​នៃ ឞើស​នតុក​មៃ​ជឹត​នតុក​ហេន​អ្យា ឆ្វាង​មោ​ទើយ​អោស»។ ");
INSERT INTO cmok_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ឞូនុយ្ស​នទ្រ៝ង់​អី​នៃ​លាស​មា​ចែ​អាឞ្រាហាម់ ៖ «ហើយ​ចែ! លាស​កើត​នទ្រី ខឹត​អោម​លោម​លាៈ ទាន់​មៃ​ដាៈ​លាឆារ ​ហាន់​តា​ជៃ​ឞឹ​គ៝ប់​រី​អើ‌ ");
INSERT INTO cmok_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","យ៝រ​មា​គ៝ប់​គែស​ព្រាម់​នុយ្ស​អ៝ស​នោ​ឞូ​ក្លោ​លាស។ ដាៈ​ពាង់​មឞើស​មា​ខាន់​ពាង់ អ៝ន់​ខាន់​ពាង់​កាស​គឹត​ញជ្រាង់​ឆាក់ គៃ​មា​លើយ​អោស​អ៝ន់​ហាន់​តា​នតុក​នាវ​រេស​រាញាល់​ទុត​ហោ​អ្យា»។ ");
INSERT INTO cmok_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ចែ​អាឞ្រាហាម់ ​អើស​មា​ពាង់៖ «អ៝ស​នោ​មៃ​លែៈ​គែស​ឆ៝ម់បុត​មោឆេ  នទ្រែល​មា​ឆ៝ម់បុត​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​កាល់​អែ​នើស លាស​នទ្រី​អ៝ន់​ខាន់​ពាង់​អ្យាត់​ទឹង​លែៈ​នទើ​អី​មពោល​ខាន់​ពាង់​អី​នៃ​គែស​ញចីស​តា​នៃ​ទោ»។ ");
INSERT INTO cmok_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ឞូនុយ្ស​នទ្រ៝ង់​ជ៝ល់​អើស​មា​ពាង់​ជឹត៖ «មោ​អោស! ហើយ​ចែ អ៝ន់​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​អី​តាៈ​ឞើស​ខឹត​ហាន់​មឞើស រី​មើ​ខាន់​ពាង់​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស»។ ");
INSERT INTO cmok_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ចែ​អាឞ្រាហាម់ ​អើស​មា​ពាង់៖ «លាស​ខាន់​ពាង់​មោ​អ្យាត់​នាវ​មោឆេ  នទ្រែល​មា​នាវ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​លែៈ​គែស​ញចីស ឞ៝ល​លាស​គែស​ឞូនុយ្ស​ខឹត​ទ៝ក់​រេស​ហាន់​មឞើស​មា​ខាន់​ពាង់ ក៝ៈ​ខាន់​ពាង់​មោ​អ្យាត់​ដ៝ង់»”។ ");
INSERT INTO cmok_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","គែស​ទូ​នារ​ឞ្រាស​យេឆូ ​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “គែស​អ៝ក់​នតីល​ជាន​អ៝ន់​ឞូនុយ្ស​គែស​ជាន​តីស។ តីស​មា​រេស​រាញាល់​ងាន់​មា​ឞូ​ម៝ស​អី​លែវ​ឞូ​ជាន​តីស កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​ទុត​ក្វ៝ង់​ងាន់​មា​ឞូនុយ្ស​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","អ្វែស​រាលាវ​លាស​ឞូ​ឆ៝ៈ​មពាល់​លុ​ក៝ត់​តា​ត៝ង​ក៝​ពាង់ ជេសរី​ងក្លាច់​ពាង់​តា​ទាក​វាច់​ទាក​វារ់​រី មា​ដាស​អ៝ន់​រ៝ង​ពាង់​រេស​លែវ​ទូ​ហ្វេ​ឞូនុយ្ស​ញឆីង​ជេៈ​ជាន​តីស។ ");
INSERT INTO cmok_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​ឆាក់​ខាន់​អៃ​មៃ​នើម។ លាស​គែស​អ៝ស​នោ​ជាន​តីស អ៝ន់​ខាន់​អៃ​មៃ​លាស​នតុម​ពាង់ លាស​ពាង់​រាគ៝ល់​លើយ​នូយ្ស​នហ៝ម់​អ្យើស អ៝ន់​ខាន់​អៃ​មៃ​យោៈ​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","លាស​ពាង់​ជាន​តីស​មា​ខាន់​អៃ​មៃ​ពើស​តឹ​តា​ទូ​នារ ជេសរី​ពាង់​ព្លឹ​ងើយ​មា​ខាន់​អៃ​មៃ​ពើស​តឹ​ដ៝ង់​តា​ទូ​នារ ពាង់​លាស៖ «លែៈ​លាន់​គ៝ប់​ជាន​តីស​នើស​មេ» អ៝ន់​ខាន់​អៃ​មៃ​យោៈ​មា​ពាង់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","មពោល​កោរាញ​អ៝ស​ម៝ន​លាស​មា​ឞ្រាស​យេឆូ ៖ “ទាន់​មៃ​អ៝ន់​នាវ​ញឆីង​មា​ហេន​លើ​មា​ជ្រូ​ជឹត​អើ”។ ");
INSERT INTO cmok_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “លាស​ខាន់​មៃ​គែស​នាវ​ញឆីង​ជេៈ​តឹម​ឞាន​មា​ទូ​គារ់​នតីល​ទុត​ជេៈ ជេសរី​ខាន់​មៃ​លាស​មា​តើម​ឆី​ក្វ៝ង់​អ្យា៖ «រោក​រាយែស​មៃ​ហ៝ន​តា​ងក្លាង​ទាក​វាច់​ទាក​វារ់​រី» ពាង់​មរា​អ្យាត់​នាវ​ខាន់​មៃ​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“តា​មពោល​ខាន់​មៃ លាស​គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ពាង់​គែស​ទឹក​ហាន់​ជាន​ការ​តា​មីរ មោ​លាស​ច្យាប់​ឞែ​ឞ្យាប់ ត៝ត់​ពាង់​ព្លឹ​ឆឹត​ឞើស​មីរ​រី អី​កោរាញ​រី​ងើយ​មា​ទឹក​អី​នៃ៖ «គុ​ឆោង​ឆា​ប៝ត់» នទ្រី​ឞើស? ");
INSERT INTO cmok_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","មោ​នទ្រី​អោស កោរាញ​អី​នៃ​មរា​លាស​មា​ពាង់​កើត​នអា​រ៝៖ «នទ្រាប់​ព្យាង់​ត្រាវ​អ៝ន់​មា​គ៝ប់ ជេសរី​មៃ​តើស​ខ៝​អាវ​រាក់​អ៝ន់​គ៝ប់​ឆោង ក៝ប់​ជេស​គ៝ប់​ឆោង​ទឹង​មៃ​ឆោង​ឞើស​កើយ»។ ");
INSERT INTO cmok_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","អាស​កោរាញ​លាស​អ្វែស​មា​ទឹក​អី​នៃ​ឞើស ឆៃ​ពាង់​ជាន​តឹង​នាវ​កោរាញ​ដាៈ? មោ​អោស! ");
INSERT INTO cmok_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ខាន់​មៃ​តឹម​ឞាន​ដ៝ង់ ទោល​ខាន់​មៃ​ជាន​ការ​តឹង​នាវ​កោរាញ​ឞ្រាស​ដាៈ​អាប់​លែៈ​ផ្យៅ​ជេស អ៝ន់​ខាន់​មៃ​លាស៖ «ហេន​ជេង​ទឹក​កោរាញ​ឞ្រាស​ទើម ហេន​ជាន​ការ​ម៝ស​នទើ​អី​ហេន​ទី​ជាន​ទើម»”។ ");
INSERT INTO cmok_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ទោល​ឞ្រាស​យេឆូ ​ហាន់​ជឹត​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  ពាង់​ហាន់​រ៝ៈ​នហារ់​ឞ្រី​ឆាមារី  ដាស​ឞ្រី​កាលីលេ ។ ");
INSERT INTO cmok_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​លាប់​រ៝ៈ​ទូ​ប៝ន គែស​មពោល​ផុង​ឆា​ជឹត​នុយ្ស​ហាន់​ម៝ប់​ពាង់។ តឹង​នាវ​វៃ ឞ្វៃ​ខាន់​ពាង់​មោ​អ៝ន់​គុ​ទាច់​មា​ឞូនុយ្ស​អេង នទ្រី​ទឹង​ខាន់​ពាង់​គុ​ឞើស​ងាយ​នតែរ​ក្វាល់៖ ");
INSERT INTO cmok_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“ហើយ​កោរាញ​យេឆូ  ទាន់​យោៈ​នអាច​ជាន​ឞាស​មា​ហេន​បាៈ​អើ”។ ");
INSERT INTO cmok_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ឞ្រាស​យេឆូ ​អ្វាញ់​ជឹត​ខាន់​ពាង់ ជេសរី​លាស៖ “ហាន់​ញហើ​ឆាក់​ខាន់​មៃ​នៃ​អ៝ន់​មា​មពោល​ជាន​ឞ្រាស​អ្វាញ់​អា​រី គៃ​មា​គឹត​នាល់​ឞាស​នាវ​ជី”។ ខាន់​ពាង់​លោស​ឞើស​ឞ្រាស​យេឆូ​នៃ ទោល​ខាន់​ពាង់​ហាន់​រ៝ៈ​ត្រ៝ង នាវ​ជី​ផុង​ឆា​លែៈ​ខាន់​ពាង់​រី​នើស​ទោ​មា​ឞាស​ក្ល៝ស​ទាទេ​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ត៝ត់​មា​ឆៃ​ឆាក់​ខាន់​ពាង់​នើម​ឞាស​ក្ល៝ស​លែៈ​ផ្យៅ​កើត​នៃ គែស​ទូ​ហ្វេ​តា​មពោល​អី​នៃ​ពាង់​ព្លឹ​ជឹត​កើយ​អ្យា ងក្រែ​មា​រានេ​មា​កោរាញ​ឞ្រាស​ទុត​នតែសៗ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ត៝ត់​តា​នៃ​ពាង់​ពាន់​តា​ជ៝ង់​ឞ្រាស​យេឆូ ​រី កុញ​ឞោក​ជឹត​នែស ជេសរី​លាស​អ្វែស​មា​កោរាញ​ឞ្រាស។ ឞូនុយ្ស​អី​នៃ​មពោល​ឞ្រី​ឆាមារី  មោ​អោស​ទី​ផូង​អីឆ្រាអែល ។ ");
INSERT INTO cmok_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ជេសរី​ឞ្រាស​យេឆូ ​លាស៖ “មោ​ទី​មពោល​អី​ជឹត​នុយ្ស​ឞាស​ទាទេ លាស​នទ្រី​មពោល​អី​មឞ៝ល់​តោរ​ឆឹន​នុយ្ស​អាស​ជឹត​គុ? ");
INSERT INTO cmok_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","គែស​ទូ​ហ្វេ​មពោល​ឞ្រី​អេង​អ្យា​ទើម​ឞើស ព្លឹ​រានេ​មា​កោរាញ​ឞ្រាស?” ");
INSERT INTO cmok_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ជេសរី​ពាង់​លាស​មា​ឞូនុយ្ស​អី​នៃ​ជឹត៖ “មៃ​ទ៝ក់​ហាន់​រី​ហ៝ម់ នាវ​មៃ​ញឆីង​ជាន​ឞាស​នាវ​ជី​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","គែស​ទូ​នារ​ផូង​ផារីឆី ​អោប​ឞ្រាស​យេឆូ  ទាស​ជ៝ៈ​នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​វាច់។ ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​វាច់​មោ​គែស​អោស​នាវ​ឆៃ​មា​មាត់​ឞូនុយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","មោ​គែស​អោស​ឞូនុយ្ស​ទើយ​លាស៖ «នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​តា​នតុក​អ្យា» មោ​លាស «តា​នតុក​រី»។ អ៝ន់​ខាន់​មៃ​គឹត​លាស នាវ​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​គែស​តា​នូយ្ស​នហ៝ម់​ឞូនុយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ឞ្រាស​យេឆូ ​លាស​មា​អ៝ស​ម៝ន​ពាង់៖ “ជឹត​នាប់​តៃ ខាន់​អៃ​មៃ​អុច​ឆៃ​នារ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់ គៃ​មា​ម៝ត់​អ្វាញ់​ខាន់​អៃ​មៃ​តា​នាវ​ទើយ​កោរាញ​ឞ្រាស តីស​មា​ខាន់​អៃ​មៃ​មោ​ឆៃ​អោស។ ");
INSERT INTO cmok_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","នោក​នៃ​គែស​ឞូ​មឞើស​មា​ខាន់​អៃ​មៃ​លាស៖ «កោរាញ​ឞ្រាស​តា​នតុក​អ្យា» មោ​លាស «តា​នតុក​រី» ខាន់​អៃ​មៃ​លើយ​អោស​អ្យាត់​ខាន់​ពាង់ លើយ​អោស​ហាន់​អ្វាញ់។ ");
INSERT INTO cmok_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","យ៝រ​លាស​នារ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់ តឹម​ឞាន​មា​លើប​ងលាយ្ស​អាង​ច្រាត​ឞើស​ជ៝ង់​ត្រោក​ទូ​ទីង​ត៝ត់​មា​ជ៝ង់​ត្រោក​ទូ​ទីង កើត​នៃ​ដ៝ង់​លាម​នែស​នតូ​មរា​គឹត​ឆៃ​នារ​គ៝ប់​ព្លឹ​វាច់។ ");
INSERT INTO cmok_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","យើន​មា​អេ​ល៝រ​មា​ត៝ត់​នារ​អី​នៃ​នើស គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​មរា​គែស​នាវ​ជេរ​ជ៝ត់​ទុត​ហោ​ល៝រ ជេសរី​ឞូនុយ្ស​តា​រានោក​អាបៃ​អ្យា​មអារ់​លើយ​គ៝ប់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","តា​នោក​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់​នៃ ជេង​តឹម​ឞាន​មា​រានោក​នោអេ ​កាល់​អែ​នើស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","រានោក​នៃ​ឞូនុយ្ស​គុ​ញេត​ឆោង​ឆា នអាប់​អូរ​ឆាយ​លើស​មីរ​ជាន​ឞា ឞាៈ​អ៝ស​ឞាៈ​ក៝ន នហ៝​មា​ត៝ត់​នារ​នោអេ ​លាប់​តា​ត្រោម​ទូក​ក្វ៝ង់​រី ជេសរី​ទាក​លេង​ទាក​ទើង​ឞុក​លើស​ហេង​ខាន់​ពាង់​លែៈ​ផ្យៅ។ ");
INSERT INTO cmok_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","នារ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់ ជេង​តឹម​ឞាន​មា​រានោក​លុត ​កាល់​អែ​នើស​ដ៝ង់។ រានោក​នៃ​ឞូនុយ្ស​គុ​ញេត​ឆោង តាច់​រាគ៝ល់​ទ្រាប់​នទើ តូច​តាម់ នទ្រែល​មា​ជាន​ញីស​ជាន​ជៃ​អាប់​នារ​អាប់​នារ។ ");
INSERT INTO cmok_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","នហ៝​មា​ត៝ត់​នារ​លុត ​ទូ​លោស​ឞើស​ប៝ន​ឆោដុម ​នៃ គែស​អុញ នទ្រែល​មា​លុ​ហីត​អុញ​តាៈ​ឞើស​កាលើ​ត្រោក​តី​តឹម​ឞាន​មា​តុប​មីស​ងាន់ ជាន​ហេង​លែៈ​ផ្យៅ​ឞូនុយ្ស​តា​ប៝ន​ឆោដុម ​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","នារ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់​ញឆោស​ឆាក់ ជេង​តឹម​ឞាន​មា​កើត​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","តា​នារ​អី​នៃ លាស​ឞូ​ម៝ស​គុ​កាលើ​ច៝រ​ជៃ​ល៝ង់ លាស​ពាង់​គែស​ទ្រាប់​នទើ​តា​ត្រោម​ជៃ​លើយ​អោស​ជុរ​លាប់​ឆ៝ៈ អ៝ន់​ពាង់​ជុរ​ទូ​ញច្វាត់​ហ៝ៈ។ ឞូ​ម៝ស​អី​គុ​តា​មីរ​តឹម​ឞាន​កើត​នៃ​ដ៝ង់ លើយ​អោស​ព្លឹ​តា​ជៃ​មា​ឆ៝ៈ​នទើ អ៝ន់​ទូ​ញច្វាត់​ហ៝ៈ។ ");
INSERT INTO cmok_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","អ៝ន់​កាស​គឹត​នាវ​ត៝ត់​មា​អី​អូរ​លុត  ពាង់​ខឹត​យ៝រ​លាស​ពាង់​ងគឹល​ជឹត​កើយ​នោក​ខាន់​ពាង់​ទូ​ឞើស​ប៝ន​ឆោដុម ។ ");
INSERT INTO cmok_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","យ៝រ​លាស​ឞូ​ម៝ស​អី​អុច​ព្រាប់​មា​នាវ​រេស​ពាង់​នើម ពាង់​អី​នៃ​មោ​អោស​គែស​នាវ​រេស​នហ៝​រ៝ យើន​មា​ឞូ​ម៝ស​រ៝ស​នាវ​រេស​យ៝រ​មា​តឹង​គ៝ប់ ពាង់​អី​នៃ​គែស​នាវ​រេស​នហ៝​រ៝​ងាន់​តា​នារ​ជឹត​នាប់​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ តា​នារ​នៃ​លាស​គែស​ឞារ​ហៃ​ឞូនុយ្ស​ឞិច​តា​ទូ​មល៝ម់​គ្រែ​ទើម​តា​នោក​មាង់ ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ឆ៝ៈ​អ៝ន់​គុ​តា​ប៝ន​អ្វែស​តា​កាលើ ហោម​រ៝ង​ទូ​ហ្វេ​មា​តេៈ​ទោយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","គែស​ឞារ​ហៃ​ឞូ​អូរ​ពែស​តឹម​រាប់ ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ឆ៝ៈ​អ៝ន់​គុ​តា​ប៝ន​អ្វែស​តា​កាលើ ហោម​រ៝ង​ទូ​ហ្វេ​មា​តេៈ​ទោយ្ស។ ");
INSERT INTO cmok_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","លាស​ឞារ​ហៃ​ឞូ​ក្លោ​គុ​តា​មីរ ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ឆ៝ៈ​ហោម​រ៝ង​ទូ​ហ្វេ”។ ");
INSERT INTO cmok_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","អ៝ស​ម៝ន​អោប​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញ អាស​នតុក​គែស​នាវ​អី​នៃ​មេស?” ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “អាស​នតុក​គែស​នទើ​ខឹត គ្រ៝ត់​មរា​រាគូម​ឞាល់​មពារ់​នទាច់​តា​នតុក​អី​នៃ​ដ៝ង់ កើត​នទ្រី​នទើ​អី​នៃ​អ៝ន់​មពើល​មា​ឞូនុយ្ស​ឆៃ​ឞើស​ងាយ”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ជេសរី​ឞ្រាស​យេឆូ ​នតុម​នតី​មពោល​អ៝ស​ម៝ន​ពាង់ អ៝ន់​មឞើស​ឆើម​បាបើ លើយ​អោស​ទឹល​នូយ្ស​នហ៝ម់។ ");
INSERT INTO cmok_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ពាង់​ងើយ​នតឹត៖ “តា​ទូ​ប៝ន​គែស​ទូ​ហ្វេ​កោរាញ​ផាត​ទោយ្ស ពាង់​ឞូនុយ្ស​មោ​អោស​គឹត​ក្លាច​មា​កោរាញ​ឞ្រាស មោ​កាៈ​មោ​រានាម​មា​ឞូនុយ្ស​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","តា​ប៝ន​នៃ​គែស​ដ៝ង់​ទូ​ហ្វេ​ឞូ​អូរ​នទ្រោ​ខឹត​ឆាយ​ដាៈ​ពាង់​ផាត​ទោយ្ស​បាបើ​ងាន់។ ឞូ​អូរ​នទ្រោ​អី​នៃ​លាស៖ «ហើយ​កោរាញ ដាៈ​មៃ​ឆើម​ផាត​ទោយ្ស​មា​ឞូនុយ្ស​អី​ជាន​តីស​មា​គ៝ប់​អើ»។ ");
INSERT INTO cmok_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ពាង់​រាលាច់​មោ​អុច​ផាត​ទោយ្ស​អ៝ន់​មា​ឞូ​អូរ​នៃ​លែៈ​ជ៝ៈ​នារ​ងាន់ យើន​មា​ជឹត​នាប់​តៃ​ពាង់​មឹន​អេង​តា​នូយ្ស​នហ៝ម់​រី៖ «ឞ៝ល​លាស​គ៝ប់​មោ​គឹត​ក្លាច​មា​កោរាញ​ឞ្រាស មោ​គឹត​ឆ្រីម​មោ​គឹត​រាមាច​មា​ឞូនុយ្ស​កាដោយ​លែៈ‌ ");
INSERT INTO cmok_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","គ៝ប់​ហោម​ផាត​ទោយ្ស​អ៝ន់​មា​ឞូ​អូរ​នទ្រោ​អ្យា​ដ៝ង់ យ៝រ​លាស​ពាង់​ឞ្រោៈ​រាខ្វាក​គ៝ប់​បាបើ​ងាន់។ លាស​គ៝ប់​មោ​អោស​ផាត​ទោយ្ស​អ៝ន់​មា​ពាង់ ពាង់​ហោម​ដាៈ​គ៝ប់​ជ៝ល់​ក៝​ដ៝ង់ អ៝ន់​គ៝ប់​ទឹល»”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ឞ្រាស​យេឆូ ​លាស​ជឹត៖ “ល៝ង់​អ្យាត់​ម៝ស​នាវ​កោរាញ​ផាត​ទោយ្ស​អ្យើស​អ្យា​ពាង់​ងើយ​នើស។ ");
INSERT INTO cmok_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","កោរាញ​ឞ្រាស​រាលាវ​មា​នៃ ពាង់​ឆើម​កើល​អ៝ន់​មា​ខាន់​អៃ​មៃ​អី​ឞូនុយ្ស​លែៈ​ពាង់​កើយ្ស អី​ជ៝យ​ក្វាល់​ពាង់​ទឹង​មាង់​ទឹង​នារ។ អាស​ពាង់​ជាន​មឞ្រែៈ​មឞ្រើយ​មា​ខាន់​អៃ​មៃ​ឞើស? ");
INSERT INTO cmok_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","មោ​អោស គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ កោរាញ​ឞ្រាស​ឆើម​កើល​អ៝ន់​មា​ពាង់​គើញ​រ៝។ យើន​មា​ទោល​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ព្លឹ​វាច់​តា​នែស​នតូ​អ្យា ហោម​ឆៃ​ឞូនុយ្ស​គែស​នាវ​ញឆីង​កើត​នអា​ដ៝ង់​លាស​មោ?” ");
INSERT INTO cmok_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ជេសរី​ឞ្រាស​យេឆូ ​ងើយ​ទូ​នាវ​នតឹត​ជឹត​អ៝ន់​មា​ឞូនុយ្ស​អី​កើប​អេង​ឆាក់​ពាង់​នើម​ជេង​ឞូនុយ្ស​ឆ៝ង់​តា​ឞើស​នាប់​កោរាញ​ឞ្រាស ជេសរី​មឺច​មា​ឞូ​អេង។ ");
INSERT INTO cmok_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ពាង់​លាស​កើត​នអា៖ “គែស​ឞារ​ហៃ​ឞូ​ក្លោ​ហាន់​មឞើស​ឆើម​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស។ ទូ​ហ្វេ​ផូង​ផារីឆី  ទូ​ហ្វេ​ជឹត​មពោល​ក៝ប់​ឆ៝ៈ​ព្រាក់​ឞើស​ឞូ​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់។ ");
INSERT INTO cmok_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ពាង់​អី​ផារីឆី ​រី​ទ៝ក់​ទូ​ហ្វេ​អេង​ពាង់​នើម​មឞើស​ឆើម​ឞើស​អ្យា​លាស៖ «ហើយ​កោរាញ​ឞ្រាស គ៝ប់​លាស​អ្វែស​មា​មៃ យ៝រ​លាស​គ៝ប់​មោ​អោស​កើត​ឞូនុយ្ស​អាបាៈ​អេង លែៈ​មពោល​អី​នៃ​ជេង​ឞូនុយ្ស​នតុង ឞូនុយ្ស​ក្វែ ឞូនុយ្ស​ល៝ម់​អូរ​ល៝ម់​ឆាយ ជេសរី​គ៝ប់​មោ​តឹម​ឞាន​មា​ឞូនុយ្ស​ក៝ប់​ឆ៝ៈ​ព្រាក់​ឞូ​អី​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ល៝ង់​គ៝ប់​អ្យា​អ៝ត់​ឆោង​ឆា​រាលាវ​មា​ឞូនុយ្ស​អេង​ទូ​ពើស​អ៝ត់​ឞារ​នារ ជេសរី​ឆ៝ៈ​នទើ​គែស​ជឹត​អឹ​រាហ្វាត់​ង្វាយ​ញហើរ​មា​កោរាញ​ឞ្រាស​លែៈ​នទើ​គ៝ប់​មហែ​គែស​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ល៝ង់​ពាង់​អី​ក៝ប់​ឆ៝ៈ​ព្រាក់​ឞូ​រី ទ៝ក់​ឞើស​ងាយ​មោ​ឞាញ់​ដ៝ង់​ងគើរ​មាត់​ជឹត​លើ​មា​កោរាញ​ឞ្រាស។ ពាង់​នតុរ​នតាង​នតើស​ពាង់​នើម​យ៝រ​មា​ពាង់​រាង៝ត​មា​នាវ​តីស​ពាង់​នើម ពាង់​លាស៖ «ហើយ​កោរាញ​ឞ្រាស ទាន់​មៃ​យោៈ​នអាច​មា​គ៝ប់ គ៝ប់​ជេង​ឞូនុយ្ស​តីស»។ ");
INSERT INTO cmok_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","គ៝ប់​មឞើស​មា​ខាន់​មៃ ខាន់​ពាង់​ព្លឹ​ឆឹត​តា​ជៃ កោរាញ​ឞ្រាស​កើប​ទូ​ហ្វេ​ឞូនុយ្ស​អ្យា​ជេង​ឞូនុយ្ស​លែៈ​ឆ៝ង់ លែៈ​យោៈ​នាវ​តីស​ពាង់ តីស​មា​ទូ​ហ្វេ​ផូង​ផារីឆី ​អី​នៃ​កោរាញ​ឞ្រាស​មោ​អោស​កើប​ជេង​ឞូនុយ្ស​ឆ៝ង់ មោ​អោស​យោៈ​នអាច​នាវ​តីស​ពាង់។ យ៝រ​លាស​ឞូ​ម៝ស​អី​នហាវ​អេង​ឆាក់​ពាង់​នើម កោរាញ​ឞ្រាស​ញជុរ​លើយ ឞូ​ម៝ស​អី​ញជុរ​ឆាក់​ពាង់​នើម កោរាញ​ឞ្រាស​ទែ​នហាវ​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","គែស​ទូ​នារ​ឞូ​លែវ​ក៝ន​ឆែ​ជេៈៗ​ហាន់​តា​ឞ្រាស​យេឆូ  គៃ​មា​ដាៈ​ពាង់​ពាស​តី​តា​ក៝ន​ឆែ​អី​នៃ​អ៝ន់​នាវ​គែស​ជេង​មា​ខាន់​ពាង់។ ត៝ត់​មា​មពោល​អ៝ស​ម៝ន​ឆៃ​កើត​នៃ ខាន់​ពាង់​ឞ្វៃ​លើយ​ហាន់​ទាច់​អា​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","យើន​មា​ឞ្រាស​យេឆូ ​ក្វាល់​មពោល​ក៝ន​ឆែ​អី​នៃ​ហាន់​អា​ពាង់ ជេសរី​ពាង់​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ “អ៝ន់​ផូង​ក៝ន​ឆែ​វាច់​តា​គ៝ប់ លើយ​អោស​ឞ្វៃ​ពាង់ យ៝រ​លាស​ខាន់​ពាង់​មោ​អោស​នហាវ​អេង​ឆាក់​ខាន់​ពាង់​នើម យើន​មា​ញឆីង​មា​មេៈ​ឞឹ​ហោ​ងាន់ ឞូនុយ្ស​អី​កោរាញ​ឞ្រាស​អុច​ម៝ត់​អ្វាញ់​ខាន់​ពាង់​គែស​កើត​នទ្រី​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ឞូ​ម៝ស​មោ​អោស​តឹម​ឞាន​មា​ក៝ន​ឆែ​ជេៈ​អ្យា មោ​គែស​អោស​កោរាញ​ឞ្រាស​រ៝ម​ពាង់​មា​ម៝ត់​អ្វាញ់”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","គែស​ទូ​ហ្វេ​កោរាញ​ផូង​អីឆ្រាអែល ​អោប​ឞ្រាស​យេឆូ ​កើត​នអា៖ “ហើយ​នើម​នតី​អ្វែស មើម​គ៝ប់​ជាន​មេស គៃ​មា​គែស​នាវ​រេស​នហ៝​រ៝​តៃ?” ");
INSERT INTO cmok_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ឞ្រាស​យេឆូ ​អើស​មា​ពាង់៖ “មើម​ទឹង​មៃ​ក្វាល់​គ៝ប់​«អ្វែស»​កើត​នៃ​មេស? មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​អ្វែស គែស​ទូ​ហ្វេ​កោរាញ​ឞ្រាស​ទើម​អ្វែស។ ");
INSERT INTO cmok_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","មៃ​លែៈ​គឹត​ជេស​តា​នាវ​វៃ​ផូង​ឞ៝ន់​លាស៖ «លើយ​ល៝ម់​អូរ​ល៝ម់​ឆាយ លើយ​ងខឹត​ឞូ លើយ​នតុង លើយ​ងើយ​ញចើត ជេសរី​យើក​មា​មេៈ​ឞឹ​ហ៝ៈ»”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ឞូ​ក្លោ​អី​នៃ​អើស​មា​ឞ្រាស​យេឆូ ៖ “ទឹង​លែៈ​នាវ​វៃ​អី​នៃ​គ៝ប់​ញអោត​នតើម​ឞើស​ជេៈ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ត៝ត់​ឞ្រាស​យេឆូ ​តាង់​កើត​នៃ ជេសរី​ពាង់​លាស​មា​ឞូ​ក្លោ​អី​នៃ៖ “ហោម​ទូ​នតីល​មៃ​មោ​ហ៝ៈ​ជាន តាច់​លែៈ​ទ្រាប់​នទើ​មៃ ពាៈ​អ៝ន់​មា​មពោល​អ៝​អាច រី​មើ​មៃ​គែស​នទើ​ខ្លៃ​តា​ប៝ន​អ្វែស​តា​កាលើ ជេសរី​ទឹង​ហាន់​តឹង​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ជេស​តាង់​កើត​នៃ ពាង់​រាវៃ​ញហ្វាច​ហោ​ងាន់ យ៝រ​លាស​ពាង់​ជេង​ឞូនុយ្ស​នទ្រ៝ង់​គែស​ទ្រាប់​នទើ​អ៝ក់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ទោល​ឞ្រាស​យេឆូ ​ឆៃ​ឞូនុយ្ស​នទ្រ៝ង់​នៃ​គែស​នូយ្ស​នហ៝ម់​រាវៃ ពាង់​លាស៖ “ជេរ​ងាន់​មា​ឞូនុយ្ស​នទ្រ៝ង់​អ៝ន់​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ជេរ​រាលាវ​មា​អ៝ន់​ឆែស​ឆាមោ​លាប់​តា​ត្រោម​ងលាយ”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ឞូនុយ្ស​អី​តាង់​នាវ​ឞ្រាស​យេឆូ ​លាស​នៃ ខាន់​ពាង់​អោប៖ “លាស​ឞូនុយ្ស​នទ្រ៝ង់​លែៈ​គែស​ជេរ​ជេស​មា​អ៝ន់​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ខាន់​ពាង់ លាស​នទ្រី​ឞូនុយ្ស​អា​អេង​ហោម​ទើយ​អ៝ន់​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ដ៝ង់​លាស​មោ?” ");
INSERT INTO cmok_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “នទើ​ឞូនុយ្ស​ជាន​មោ​ឞ្លាវ កោរាញ​ឞ្រាស​ជាន​ហោម​ឞ្លាវ ឞូនុយ្ស​មោ​អោស​ឞ្លាវ​រាក្លាយ្ស​អេង​ឆាក់​ពាង់​នើម យើន​មា​កោរាញ​ឞ្រាស​ហោម​ឞ្លាវ​រាក្លាយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ពេត្រោស ​លាស​មា​ឞ្រាស​យេឆូ ៖ “មៃ​លែៈ​ឆៃ​ហេន​ជេស លែៈ​នទើ​ហេន​គែស​ហេន​មអារ់​លើយ ជេសរី​តឹង​មៃ លាស​នទ្រី​មើម​ហេន​មេស?” ");
INSERT INTO cmok_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ ឞូ​ម៝ស​មអារ់​ញីស​ជៃ អូរ​ក៝ន មេៈ​ឞឹ នទ្រែល​មា​អ៝ស​នោ យ៝រ​មា​អ៝ន់​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​មា​ពាង់‌ ");
INSERT INTO cmok_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ឞូនុយ្ស​អី​នៃ​ពាង់​ទើន​នទើ​គែស​អ៝ក់​រាលាវ​អី​នៃ​តា​នោក​អាបៃ​អ្យា នទ្រែល​មា​គែស​នាវ​រេស​នហ៝​រ៝​ដ៝ង់​តា​នារ​ជឹត​នាប់​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ឞ្រាស​យេឆូ ​លែវ​លែៈ ១២ កោរាញ​អ៝ស​ម៝ន​ហាន់​តា​នតុក​អេង​នទ្រែល​ពាង់​នើម។ ពាង់​លាស​មា​ខាន់​ពាង់​នៃ៖ “អាបៃ​អ្យា​ឞ៝ន់​ហាន់​តា​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  យ៝រ​លាស​លែៈ​នាវ​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​លែៈ​ញចីស​កាល់​អែ​នើស​ងក៝ច​មា​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស នាវ​អី​នៃ​ត៝ត់​ងាន់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","យ៝រ​លាស​ឞូ​ញជុន​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​អ៝ន់​មា​ផូង​អី​មោ​ទី​ផូង​ឞ៝ន់។ ផូង​អី​នៃ​គើម​ងគ្រើស​គ៝ប់ រាក​ឆ្វាយ នទ្រែល​មា​ឆ៝ស​ទាក​ទីវ​តា​គ៝ប់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ឞូ​រាពាត់​គ៝ប់​មា​ម៝ង់​រាឆែ ជេសរី​ងខឹត​លើយ​គ៝ប់ យើន​មា​ពែ​នារ​ឞើស​កើយ​នៃ​គ៝ប់​ទ៝ក់​រេស​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","លែៈ​មពោល​កោរាញ​អ៝ស​ម៝ន​មោ​វ៝ត់​អោស​នាវ​ឞ្រាស​យេឆូ ​ងើយ​អី​នៃ ខាន់​ពាង់​មោ​វ៝ត់​ម៝ស​នាវ​ពាង់​អុច​លាស យ៝រ​លាស​នាវ​អី​នៃ​ហោម​ម៝​មា​ខាន់​ពាង់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ទោល​ឞ្រាស​យេឆូ ​ហាន់​ឞើយ​ត៝ត់​ប៝ន​យេរីខោ  គែស​ទូ​ហ្វេ​ឞូនុយ្ស​ចែស​មាត់​គុ​ទាន់​ឞូ​តា​មែង​ត្រ៝ង​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ទោល​ពាង់​តាង់​នតែស​ឞូនុយ្ស​ផូង​ហាន់​រ៝ៈ​ត្រ៝ង​នៃ ពាង់​អោប​ឞូ៖ “ម៝ស​គែស​នាវ​ហ្យាស?” ");
INSERT INTO cmok_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ឞូ​មឞើស​មា​ពាង់៖ “នើម​នតី​យេឆូ ​តាៈ​ឞើស​ប៝ន​នាឆារែត ពាង់​ហាន់​រ៝ៈ​ត្រ៝ង​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ជេសរី​ឞូនុយ្ស​ចែស​មាត់​នតើម​នតែរ៖ “ហើយ​កោរាញ​យេឆូ ​ក៝ន​ឆៅ​កាដាច់​ដាវីត ! យោៈ​នអាច​មា​គ៝ប់​បាៈ​អើ!” ");
INSERT INTO cmok_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ឞូ​អី​ឞ្រោៈ​ឞើស​នាប់​នៃ​ឞ្វៃ​ពាង់​ដាៈ​គុ​អ្យាត់​ឆាក់​ហ៝ៈ យើន​មា​ពាង់​លើ​មា​នតែរ​ទុត​នតែសៗ៖ “ហើយ​ក៝ន​ឆៅ​កាដាច់​ដាវីត ! យោៈ​នអាច​មា​គ៝ប់​បាៈ​អើ!” ");
INSERT INTO cmok_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ឞ្រាស​យេឆូ ​ញឆ្រុង ជេសរី​ដាៈ​ឞូ​លែវ​ឞូនុយ្ស​នៃ​អា​ពាង់។ ឞូនុយ្ស​ចែស​មាត់​នៃ​ហាន់​ត៝ត់​តា​រី ជេសរី​ឞ្រាស​យេឆូ ​អោប៖ ");
INSERT INTO cmok_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ម៝ស​មៃ​អុច​អ៝ន់​គ៝ប់​ជាន​មា​មៃ​មេស?” ឞូនុយ្ស​ចែស​មាត់​នៃ​អើស៖ “ហើយ​កោរាញ អ៝ន់​មាត់​គ៝ប់​ឆៃ​អាង”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “អាង​ហ៝ម់ នាវ​មៃ​ញឆីង​មា​គ៝ប់​លែៈ​រាក្លាយ្ស​មៃ​ជេស”។ ");
INSERT INTO cmok_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ជេសរី​មាត់​ពាង់​ទោ​មា​ឆៃ​អាង​រ៝ ពាង់​តឹង​ឞ្រាស​យេឆូ ​ឞើស​កើយ ងក្រែ​មា​រានេ​មា​កោរាញ​ឞ្រាស។ លែៈ​ឞូនុយ្ស​អី​ឆៃ​នាវ​នៃ​ខាន់​ពាង់​រានេ​មា​កោរាញ​ឞ្រាស​ទាទេ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ជេសរី​ឞ្រាស​យេឆូ ​លាប់​តា​ប៝ន​យេរីខោ ​រី ពាង់​ហាន់​រ៝ៈ​ប៝ន​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​រាញា​ឆាខេ  ពាង់​ជេង​កោរាញ​មា​មពោល​ក៝ប់​ឆ៝ៈ​ព្រាក់​ឞើស​ឞូ​មា​អ៝ន់​កោរាញ​ម៝ត់​អ្វាញ់ ពាង់​នទ្រ៝ង់​គែស​ទ្រាប់​នទើ​អ៝ក់​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ពាង់​អុច​ងាន់​ឆៃ​ឞ្រាស​យេឆូ  តីស​មា​ឆាក់​ពាង់​នើស​ទេស នទ្រែល​មា​គែស​ឞូនុយ្ស​អ៝ក់​អីរ កើត​នទ្រី​ពាង់​អ្វាញ់​ឞ្រាស​យេឆូ ​មោ​ទើយ​ឆៃ​អោស។ ");
INSERT INTO cmok_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ជេសរី​ពាង់​ញច្វាត់​ឞើស​នាប់​រី ហាវ​កាលើ​តើម​រាវី  ក៝ប់​អ្វាញ់​ឞ្រាស​យេឆូ ​ហាន់​រ៝ៈ​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ឞ្រាស​យេឆូ ​ឞ្រោៈ​រ៝ៈ​ត្រ៝ង​នៃ ត៝ត់​តា​តើម​ឆី​នៃ​ពាង់​ងគើរ​អ្វាញ់​ជឹត​លើ ជេសរី​លាស​មា​ឆាខេ ៖ “ហើយ​នោ​ឆាខេ  មៃ​ជុរ​ហ៝ម់ យ៝រ​លាស​កោរាញ​ឞ្រាស​ដាៈ​គ៝ប់​គុ​ឞិច​តា​ជៃ​មៃ​នារ​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ជេសរី​ពាង់​ជុរ​រ៝ រ៝ម​ឞ្រាស​យេឆូ ​ពាង់​រាម់​មអាក​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ទោល​ឆៃ​កើត​នៃ ឞូ​អ៝ក់​ឞ៝រ់​ញជ៝រ់​ឆេក​ងាន់ ឞូ​លាស៖ “យី! អ្វាញ់​ពាង់​អី​នៃ! ហាន់​តា​ជៃ​ឞូនុយ្ស​តីស”។ ");
INSERT INTO cmok_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ត៝ត់​តា​ជៃ​នៃ​ឆាខេ ​ទ៝ក់​លាស​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញ គ៝ប់​ពាៈ​ទ្រាប់​នទើ​គ៝ប់​ងគូល​អ៝ន់​មា​មពោល​អ៝​អាច លាស​គ៝ប់​លែៈ​ឆ៝ៈ​ព្រាក់​ឞូ​រាលាវ​កែស​នើស គ៝ប់​ត៝ម់​មា​ឞូ​ង្វាយ​លោស​ព្វាន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “នារ​អ្យា​នាវ​រាក្លាយ្ស​លែៈ​ត៝ត់​ជេស​មា​ឞូនុយ្ស​តា​ជៃ​អ្យា យ៝រ​លាស​មៃ​អ្យា​ញឆីង​មា​កោរាញ​ឞ្រាស តឹម​ឞាន​មា​ចែ​អាឞ្រាហាម់ ​ឞ៝ន់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​វាច់​គៃ​មា​ជ៝យ នទ្រែល​មា​រាក្លាយ្ស​ឞូនុយ្ស​តីស​អី​រ៝ស​យ៝ត​នូយ្ស​នហ៝ម់​ងាយ​ឞើស​កោរាញ​ឞ្រាស​តឹម​ឞាន​មា​ទូ​មល៝ម់​ឞែ​ឞ្យាប់​ហ្យើត”។ ");
INSERT INTO cmok_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","តា​នតុក​ខាន់​ពាង់​គុ​នៃ​មោ​គែស​ងាយ​ឞើស​ប៝ន​យេរូឆាលឹម ។ ជេស​ខាន់​ពាង់​តាង់​ឞ្រាស​យេឆូ ​ងើយ​កើត​នទ្រី ខាន់​ពាង់​គឹត​វិ​លាស​ឞ្រាស​យេឆូ ​ហាន់​ជឹត​ប៝ន​អី​នៃ​គៃ​មា​ជេង​កាដាច់។ នទ្រី​ឞ្រាស​យេឆូ ​ងើយ​នតឹត​ទូ​នាវ​ជឹត ");
INSERT INTO cmok_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","លាស៖ “គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​ជេង​ឞូនុយ្ស​នទ្រ៝ង់ ពាង់​ទែស​តា​រាន៝យ​ទែស​កាដាច់ ពាង់​នទ្រាប់​ហាន់​តា​ឞ្រី​ងាយ​គៃ​មា​ឞូ​នតាម់​ពាង់​ជេង​កាដាច់​តា​ឞ្រី​ពាង់​នើម ត៝ត់​មា​លែៈ​ជេង​ជេស ជេសរី​តៃ​ពាង់​ព្លឹ​ឆឹត​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","អេ​ល៝រ​ពាង់​មា​ហាន់ ពាង់​ក្វាល់​ទឹក​ជឹត​នុយ្ស ជេសរី​អ៝ន់​ព្រាក់​ជឹត​កាក់​ក្វ៝ង់​មា​ខាន់​ពាង់​ទូ​ហ្វេ​ទូ​ហ្វេ​ទូ​កាក់ ពាង់​លាស៖ «ព្រាក់​អ្យា​អ៝ន់​ខាន់​មរែ​មា​ជ៝យ​ឆា នហ៝​មា​ត៝ត់​គ៝ប់​ព្លឹ​ឆឹត​តៃ»។ ");
INSERT INTO cmok_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","តីស​មា​គែស​ឞូនុយ្ស​អ៝ក់​តា​ឞ្រី​អី​នៃ​មោ​អុច​អោស​មា​ពាង់ ជេសរី​ខាន់​ពាង់​ញជ្វាល់​ឞូនុយ្ស​អា​អេង​ជឹត​ហាន់​តឹង​ឞើស​កើយ​ដាៈ​មឞើស​នាវ​កើត​នអា៖ «ហេន​មោ​អុច​អោស​អ៝ន់​ឞូនុយ្ស​អ្យា​ជាន​កាដាច់​មា​ហេន»។ ");
INSERT INTO cmok_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ត៝ត់​ពាង់​លែៈ​គែស​ជាន​កាដាច់ ពាង់​ព្លឹ​ឆឹត​ឞើស​រី ជេសរី​ពាង់​ក្វាល់​លែៈ​ទឹក​អី​ពាង់​អ៝ន់​ព្រាក់​នៃ​នើស​អោប គៃ​មា​អុច​គឹត​ទាស​អ៝ក់​គែស​លោស​ក៝ន​ព្រាក់​ទូ​ហ្វេ​ទូ​ហ្វេ។ ");
INSERT INTO cmok_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ទឹក​អី​ល៝រ​ឞើស​នាប់​ឞូ​នៃ​ពាង់​មឞើស៖ «ហើយ​កោរាញ ព្រាក់​អី​មៃ​អ៝ន់​មា​គ៝ប់​នើស គែស​លោស​ក៝ន​ជឹត​កាក់​ក្វ៝ង់​ជឹត»។ ");
INSERT INTO cmok_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ជេសរី​កាដាច់​អី​នៃ​លាស​មា​ពាង់៖ «មៃ​ជាន​អ្វែស​ងាន់ ហើយ​ទឹក​អ្វែស គ៝ប់​មរា​អ៝ន់​មៃ​ម៝ត់​អ្វាញ់​ជឹត​អឹ​ប៝ន យ៝រ​លាស​នាវ​ការ​ជេៈ​អ្យា​មៃ​ជាន​រាប់​ជាប់​ងាន់»។ ");
INSERT INTO cmok_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ជេសរី​ទឹក​ត៝ល់​ឞារ​លាស៖ «ហើយ​កោរាញ ព្រាក់​អី​មៃ​អ៝ន់​មា​គ៝ប់​នើស គែស​លោស​ក៝ន​ព្រាក់​ព្រាម់​កាក់​ជឹត»។ ");
INSERT INTO cmok_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ជេសរី​កាដាច់​នៃ​លាស​មា​ពាង់៖ «នទ្រី​គ៝ប់​អ៝ន់​មៃ​ម៝ត់​អ្វាញ់​ព្រាម់​មល៝ម់​ប៝ន»។ ");
INSERT INTO cmok_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ជេសរី​ទឹក​អី​ទូ​ហ្វេ​រី​ជឹត​ហាន់​មឞើស​មា​កាដាច់៖ «ហើយ​កោរាញ អ្យា​ព្រាក់​អី​មៃ​អ៝ន់​មា​គ៝ប់​នើស​ហោម​កើត​អើម គ៝ប់​ងក្ល៝ម់​ព្រាប់​ពាង់​មា​ឞ៝ក​ព្រាប់​អ៝ន់​អ្វែស​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","គ៝ប់​ក្លាច​មៃ យ៝រ​លាស​មៃ​ជេង​ឞូនុយ្ស​ជាញ។ មៃ​ឆ៝ៈ​នទើ​អី​មោ​ទី​នទើ​មៃ​នើម កាច់​ឞា​អី​មៃ​នើម​មោ​គែស​តូច»។ ");
INSERT INTO cmok_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ជេសរី​ពាង់​លាស​មា​ទឹក​អី​នៃ៖ «ហើយ​ទឹក​អ្យើស! គ៝ប់​មរា​តេៈ​ទោយ្ស​មៃ​តឹង​នាវ​មៃ​លាស​នើស។ មៃ​លែៈ​គឹត​ជេស​គ៝ប់​ជេង​ឞូនុយ្ស​ជាញ គ៝ប់​ឆ៝ៈ​នទើ​អី​មោ​ទី​នទើ​គ៝ប់​នើម កាច់​ឞា​អី​មោ​គែស​គ៝ប់​នើម​តូច។ ");
INSERT INTO cmok_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","លាស​នទ្រី​ខាន់​មៃ​ឆ៝ៈ​ព្រាក់​គ៝ប់​នៃ​អ៝ន់​តា​នតុក​ជៃ​ឞូ​មាញ​ព្រាក់ ត៝ត់​គ៝ប់​ឆឹត​ឞើស​រី​តៃ ឞូ​ត្រ៝ៈ​ព្រាក់​អើម នទ្រែល​មា​គែស​លោស​ក៝ន​ព្រាក់​ដ៝ង់»។ ");
INSERT INTO cmok_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ជេសរី​ពាង់​លាស​មា​មពោល​អី​គុ​តា​នៃ៖ «ឆ៝ៈ​លើយ​ព្រាក់​អី​នៃ​ឞើស​ពាង់ អ៝ន់​មា​ឞូនុយ្ស​អី​គែស​ជឹត​កាក់​នៃ»។ ");
INSERT INTO cmok_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","មពោល​ខាន់​ពាង់​នៃ​លាស៖ «ហើយ​កោរាញ ពាង់​លែៈ​គែស​ជឹត​កាក់​ជេស»។ ");
INSERT INTO cmok_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ពាង់​អើស៖ «គ៝ប់​មឞើស​មា​ខាន់​អៃ​មៃ ឞូ​ម៝ស​ជាន​រាប់​ជាប់​មា​នទើ​ពាង់​គែស ឞូ​មរា​នត៝ប​អ៝ន់​មា​ពាង់ ឞូ​ម៝ស​មោ​ជាន​រាប់​ជាប់​មា​នទើ​ពាង់​គែស ឞ៝ល​លាស​នទើ​អី​ដេៈ​ពាង់​គែស​ឞូ​មរា​ឆ៝ៈ​លើយ​ឞើស​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ជេសរី​ដ៝ង់ មពោល​អី​មោ​អ៝ន់​គ៝ប់​ជាន​កាដាច់​នើស អ៝ន់​ខាន់​មៃ​ងខឹត​លើយ​ខាន់​ពាង់​អ៝ន់​លែៈ​ផ្យៅ​ឞើស​នាប់​មាត់​គ៝ប់»”។ ");
INSERT INTO cmok_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","លោច​ជេស​ឞ្រាស​យេឆូ ​ងើយ​នាវ​អី​នៃ ជេសរី​ពាង់​ហាន់​ជឹត ហាវ​ជឹត​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ឞើយ​ត៝ត់​ប៝ន​បេតផាឆេ  ដាស​មា​ប៝ន​បេថានី  តា​យោក​អី​ឞូ​ក្វាល់​លាស​យោក​តើម​អោលីវ ​រី ឞ្រាស​យេឆូ ​ដាៈ​ឞារ​ហៃ​អ៝ស​ម៝ន​ហាន់​ល៝រ‌ ");
INSERT INTO cmok_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ពាង់​លាស​មា​ខាន់​ពាង់៖ “អ៝ន់​ខាន់​មៃ​ហាន់​តា​ប៝ន​ឞើស​នាប់​រី លាប់​តា​ប៝ន​នៃ​ខាន់​មៃ​មរា​ឆៃ​ទូ​មល៝ម់​ក៝ន​ឆែស​លៀ​ឞូ​ក៝ត់​តា​នៃ ឆែស​លៀ​អី​នៃ​អេ​ហ៝ៈ​គែស​ឞូ​ញច៝​អោស អ៝ន់​ខាន់​មៃ​ទ្រីស​តេក​ពាង់​ឞើស​រី​អា​អ្យា។ ");
INSERT INTO cmok_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","លាស​គែស​ឞូ​អោប​ខាន់​មៃ៖ «ម៝ស​ជាន​ទ្រីស​ខាន់​មរែ​នៃ​មេស?» ខាន់​មៃ​អើស​លាស៖ «កោរាញ​អុច​ញច៝​ពាង់»”។ ");
INSERT INTO cmok_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ជេសរី​ឞារ​ហៃ​អ៝ស​ម៝ន​អី​នៃ​ហាន់​អា​រី ត៝ត់​អា​រី​ឆៃ​កើត​នាវ​ឞ្រាស​យេឆូ ​មឞើស​នើស​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ទោល​ឞារ​ហៃ​អ៝ស​ម៝ន​អី​នៃ​ទ្រីស​ក៝ន​ឆែស​លៀ​អី​នៃ គែស​ខាន់​ពាង់​អី​តើម​ឆែស​លៀ​រី​លាស៖ “ម៝ស​ជាន​ទ្រីស​ខាន់​មរែ​នៃ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","មពោល​អ៝ស​ម៝ន​អើស៖ “កោរាញ​អុច​ញច៝​ពាង់”។ ជេសរី​ខាន់​ពាង់​អី​តើម​ឆែស​លៀ​នៃ​អ៝ន់​ខាន់​ពាង់​តេក។ ");
INSERT INTO cmok_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ជេសរី​ខាន់​ពាង់​តេក​ឆែស​លៀ​អី​នៃ​អ៝ន់​មា​ឞ្រាស​យេឆូ  លាក់​អាវ​ក្វ៝ង់​ខាន់​ពាង់​នើម​តា​កាលើ​នទុរ​កើយ​ក៝ន​ឆែស​លៀ​នៃ​ពឺ​អ៝ន់​ពាង់​ញច៝។ ");
INSERT INTO cmok_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ជេសរី​ឞ្រាស​យេឆូ ​ញច៝​ឆែស​លៀ​ហាន់​រ៝ៈ​ត្រ៝ង​នៃ ត៝ត់​ឆៃ​ពាង់ ឞូ​ទ្រ៝ស​អាវ​ក្វ៝ង់​ខាន់​ពាង់​នើម​លាក់​រ៝ៈ​ត្រ៝ង​រី​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ឞ្រាស​យេឆូ ​ឞើយ​ត៝ត់​តា​នតុក​ត្រ៝ង​ជុរ​រ៝ៈ​យោក​តើម​អោលីវ  តា​នតុក​នៃ​គែស​ផូង​អ៝ស​ម៝ន​អ៝ក់​ងាន់​រាម់​មអាក​រានេ​មា​កោរាញ​ឞ្រាស​ទុត​នតែសៗ​ងាន់ យ៝រ​មា​លែៈ​នទើ​អ្វែស​នទើ​ខ្លៃ​ខាន់​ពាង់​លែៈ​ឆៃ​ឞ្រាស​យេឆូ ​ជាន​នើស។ ");
INSERT INTO cmok_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ខាន់​ពាង់​លាស៖ “ទាន់​កោរាញ​ឞ្រាស​អ៝ន់​នាវ​គែស​ជេង​មា​កាដាច់​អ្យា អី​កោរាញ​ឞ្រាស​ទែ​ដាៈ​វាច់។ អ៝ន់​គែស​នាវ​ដាប់​មពាន់​មា​ហេន​ដាស​មា​កោរាញ​ឞ្រាស​តា​កាលើ​ត្រោក។ រានេ​នាវ​អ្វែស​រែស​មា​កោរាញ​ឞ្រាស​គុ​តា​កាលើ​ត្រោក​ទុត​ព្រេស​រី!” ");
INSERT INTO cmok_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","គែស​ផូង​ផារីឆី ​អាបាៈ​គុ​នទ្រែល​ប៝ន​លាន​នៃ​លាស​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​នើម​នតី ឞ្វៃ​អ៝ស​ម៝ន​មៃ​នៃ​លើយ​អ៝ន់​ខាន់​ពាង់​ងើយ​កើត​នទ្រី!” ");
INSERT INTO cmok_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ឞ្រាស​យេឆូ ​អើស​មា​ផូង​ផារីឆី ៖ “គ៝ប់​មឞើស​មា​ខាន់​មៃ លាស​ខាន់​ពាង់​អ្យា​គុ​អ្យាត់​ឆាក់​រាក់​ក្លាក់ លុ​អ្យា​មរា​នតែរ​រានេ​មា​គ៝ប់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ឞ្រាស​យេឆូ ​ឞើយ​ត៝ត់​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម ពាង់​អ្វាញ់​ឆៃ​ប៝ន​អី​នៃ ជេសរី​ពាង់​ញុម​រាង៝ត​មា​ប៝ន​អី​នៃ‌ ");
INSERT INTO cmok_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ពាង់​លាស៖ “ហើយ​ឞូនុយ្ស​តា​យេរូឆាលឹម ! ញហ្វាច​ងាន់ គ៝ប់​អុច​ងាន់​ខាន់​អៃ​មៃ​វ៝ត់​នាវ​ដាប់​មពាន់​កោរាញ​ឞ្រាស​អុច​អ៝ន់​មា​ខាន់​អៃ​មៃ​តា​នារ​អ្យា តីស​មា​អាបៃ​អ្យា​នាវ​ខ្លៃ​អី​នៃ​ងកីង​នទ៝ប់​មោ​អោស​អ៝ន់​ខាន់​អៃ​មៃ​វ៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","នារ​ជឹត​នាប់​តៃ​មរា​គែស​ផូង​រាលាង់​គុ​ញជ្វែង​ជុម​ខាន់​អៃ​មៃ តោស​នហាវ​នែស​អ៝ន់​ព្រេស​គៃ​មា​ហាវ​កាលើ​មពេរ​ប៝ន លើស​ខាន់​អៃ​មៃ​អាប់​ញជោញ​អាប់​ញជាញ់។ ");
INSERT INTO cmok_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ឞូ​លើស​ហេង​ខាន់​អៃ​មៃ​លែៈ​ផ្យៅ លែៈ​អ៝ស​ម៝ន​ក៝ន​ឆៅ​ខាន់​អៃ​មៃ។ មោ​ហោម​អោស​គែស​លុ​ឞ្ល៝ន​តឹម​រាទាប់​កាលើ​លុ​ឞ្ល៝ន​តា​ប៝ន​អ្យា​ជឹត យ៝រ​លាស​ខាន់​អៃ​មៃ​មោ​គឹត​នាល់​ម៝ង​កោរាញ​ឞ្រាស​វាច់​គៃ​មា​រាក្លាយ្ស​ខាន់​អៃ​មៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ឞ្រាស​យេឆូ ​ត៝ត់​តា​ប៝ន​យេរូឆាលឹម  ជេសរី​ពាង់​លាប់​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​រី តា​នតុក​នៃ​ពាង់​ឆៃ​ឞូនុយ្ស​គុ​តាច់​រាគ៝ល់​ទ្រាប់​នទើ ជេសរី​ពាង់​នត្រុត​ផូង​អី​នៃ​លោស​ឞើស​នតុក​នៃ​រ៝‌ ");
INSERT INTO cmok_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ពាង់​លាស៖ “តា​ឆ៝ម់បុត​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​ជេស​ញចីស៖ «ញីស​គ៝ប់​ជេង​នតុក​អ៝ន់​មា​មឞើស​ឆើម»។ តីស​មា​ខាន់​អៃ​មៃ​ឆ៝ៈ​ជាន​ងខើង​នតុក​គុ​រាគូម​មពោល​នតុង”។ ");
INSERT INTO cmok_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ជេសរី​ឞ្រាស​យេឆូ ​គុ​នតី​ឞូ​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​អាប់​នារ​អាប់​នារ។ យើន​មា​មពោល​កោរាញ​ជាន​ឞ្រាស ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​មពោល​កោរាញ​ប៝ន​លាន​អាបាៈ​អេង​ជឹត ខាន់​ពាង់​លែវ​ឞាល់​ជ៝យ​នាវ​គៃ​មា​ញុប​ងខឹត​លើយ​ឞ្រាស​យេឆូ ។ ");
INSERT INTO cmok_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","តីស​មា​មោ​ឞ្លាវ​អោស ខាន់​ពាង់​ក្លាច​ផូង​ប៝ន​លាន​តឹម​លើស​ដាស​ខាន់​ពាង់ យ៝រ​លាស​លែៈ​ផូង​ប៝ន​លាន​គុ​អ្យាត់​នាវ​ពាង់​រើប​ហើប​ទាទេ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","គែស​ទូ​នារ​ឞ្រាស​យេឆូ ​គុ​នតី​ប៝ន​លាន​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស​មា​កោរាញ​ឞ្រាស នទ្រែល​មា​មឞើស​ងក៝ច​នាវ​មហែ​មហាន​អ្វែស។ ជេសរី​គែស​មពោល​កោរាញ​ជាន​ឞ្រាស ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​កោរាញ​អាបាៈ​អេង​ជឹត ខាន់​ពាង់​លែវ​ឞាល់​ហាន់​តា​នៃ​ដ៝ង់‌ ");
INSERT INTO cmok_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","អោប​ឞ្រាស​យេឆូ ​រី៖ “ទាន់​មឞើស​អ៝ន់​មា​ហេន​គឹត នទើ​មៃ​ជាន​អ្យា​ឞើស​តាៈ​នាវ​ទើយ? ឞូ​ម៝ស​អ៝ន់​នាវ​ទើយ​អី​នៃ​មា​មៃ​មេស?” ");
INSERT INTO cmok_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “គ៝ប់​ទាន់​អោប​ទូ​នាវ​មា​ខាន់​មៃ​ប៝ត់ ល៝ង់​ខាន់​មៃ​មឞើស​មា​គ៝ប់៖ ");
INSERT INTO cmok_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","លាស​នទ្រី​ឞូ​ម៝ស​ដាៈ​យោហាន-​បាប់តែម ​ជាន​បាប់តែម​យុក​មា​ទាក? តាៈ​ឞើស​កោរាញ​ឞ្រាស មោ​លាស​តាៈ​ឞើស​ឞូនុយ្ស?” ");
INSERT INTO cmok_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","មពោល​អី​នៃ​តឹម​ញច្រាៈ​ឞាល់៖ “លាស​ឞ៝ន់​លាស៖ «តាៈ​ឞើស​កោរាញ​ឞ្រាស» ពាង់​មរា​លាស​ឞ៝ន់៖ «លាស​នទ្រី​មើម​ទឹង​ខាន់​មៃ​មោ​អ្យាត់​នាវ​ពាង់?» ");
INSERT INTO cmok_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","លាស​ឞ៝ន់​លាស៖ «តាៈ​ឞើស​ឞូនុយ្ស» ប៝ន​លាន​មរា​នតុប​ឞ៝ន់​មា​លុ​រ៝ យ៝រ​លាស​ឞូ​គឹត​នហេល​យោហាន-​បាប់តែម ​ពាង់​ឞូនុយ្ស​នតើយ្ស​នាវ​ងើយ​កោរាញ​ឞ្រាស​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ជេសរី​ខាន់​ពាង់​អើស​មា​ឞ្រាស​យេឆូ ៖ “ហេន​មោ​គឹត​អោស ឞូ​ម៝ស​ដាៈ​ពាង់​ជាន”។ ");
INSERT INTO cmok_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ជេសរី​ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់​ដ៝ង់៖ “លាស​នទ្រី​គ៝ប់​មោ​ដ៝ង់​មឞើស​អ៝ន់​មា​ខាន់​មៃ​គឹត ឞូ​ម៝ស​អ៝ន់​នាវ​ទើយ​គ៝ប់​ជាន​អ្យា”។ ");
INSERT INTO cmok_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ជេសរី​ឞ្រាស​យេឆូ ​ងើយ​នតឹត​អ៝ន់​មា​ផូង​ប៝ន​លាន៖ “គែស​ទូ​ហ្វេ​ឞូ​ក្លោ​តាម់​តើម​ព្លៃ​យុងយារ​ប៝ន​ទូ​លោក​មីរ ជេសរី​អ៝ន់​ឞូ​ម៝ត់​មីរ​អី​នៃ ដាៈ​ឞូ​ពាៈ​ព្លៃ​មា​ពាង់​អាប់​នាម់។ អី​ពាង់​នើម​រី​ហាន់​គុ​ជឹត​ឞ្រី​អេង​ជ៝ៈ​ងាន់។ ");
INSERT INTO cmok_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ត៝ត់​ទី​ខៃ​ទុម​ព្លៃ​យុងយារ​ប៝ន​រី ពាង់​ដាៈ​ទូ​ហ្វេ​ទឹក​ពាង់​ហាន់​តឹម​ម៝ប់​មា​មពោល​ម៝ត់​មីរ​អី​នៃ គៃ​មា​ឆ៝ៈ​ព្លៃ​អី​ឞូ​ពាៈ​នៃ។ តីស​មា​លែៈ​មពោល​អី​នៃ​លើស​អោឞាល់ ជេសរី​នត្រុត​អោឞាល់​អ៝ន់​ឆឹត​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ពាង់​ដាៈ​តៃ​ទូ​ហ្វេ​ទឹក​ជឹត​ហាន់ មពោល​ម៝ត់​មីរ​អី​នៃ​លើស​អោឞាល់ រាក​ឆ្វាយ នត្រុត​អោឞាល់​អ៝ន់​ឆឹត​ទើម​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ជេសរី​ពាង់​អី​តើម​មីរ​នៃ​ដាៈ​តៃ​ទូ​ហ្វេ​ទឹក​ជឹត។ ត៝ត់​តា​នៃ​មពោល​ម៝ត់​មីរ​អី​នៃ​លើស​មឞាង​អោឞាល់​ត៝ត់​មា​ឆោត​រាមាញ ពឺ​មអារ់​អោឞាល់​ឞើស​ទីស​មីរ​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ជេសរី​ពាង់​អី​តើម​មីរ​រី​លាស​អេង​ឆាក់​ពាង់​នើម៖ «មើម​គ៝ប់​ជាន​ហៃ? អាបៃ​អ្យា​ដាៈ​ក៝ន​ឞូ​ក្លោ​អី​គ៝ប់​នើម​រ៝ង់​ហោ​ងាន់​អ្យា អ៝ន់​ពាង់​ហាន់​ប៝ត់ លាស​ខាន់​ពាង់​ឆៃ​ក្លាប់​លាស​ខាន់​ពាង់​អ្យាត់​ពាង់​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ត៝ត់​មា​មពោល​ម៝ត់​មីរ​អី​នៃ​ឆៃ​ពាង់ ជេសរី​ខាន់​ពាង់​តឹម​លាស​នទ្រាង់​ខាន់​ពាង់​នើម៖ «ពាង់​អី​នៃ​រ៝​នត្រ៝ៈ​នទើន​មីរ​អ្យា​នារ​ជឹត​នាប់​តៃ ហាន់​ឞ៝ន់​ងខឹត​លើយ​ពាង់​អី​នៃ​ទោស មីរ​អ្យា​នហ៝​គែស​មា​ឞ៝ន់​រ៝»។ ");
INSERT INTO cmok_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ជេសរី​ឞូ​មអារ់​អោឞាល់​ឞើស​ទីស​មីរ​រី ងខឹត​លើយ​អោឞាល់។ លាស​នទ្រី​ពាង់​អី​តើម​មីរ​អី​នៃ មើម​ពាង់​ជាន​មា​មពោល​ម៝ត់​មីរ​អី​នៃ? ");
INSERT INTO cmok_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ពាង់​មរា​ហាន់​ងខឹត​លើយ​ខាន់​ពាង់ ជេសរី​អ៝ន់​ឞូ​អេង​ជឹត​ម៝ត់​មីរ​អី​នៃ”។ ត៝ត់​មា​តាង់​នាវ​អី​នៃ​ឞូ​លាស៖ “មោ​អោស! លើយ​អោស​អ៝ន់​គែស​កើត​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ជេសរី​ឞ្រាស​យេឆូ ​អ្វាញ់​ជឹត​ឞូ ពាង់​លាស៖ “តា​ឆ៝ម់បុត​នាវ​កោរាញ​ឞ្រាស​ងើយ​លាស៖ «ឞូនុយ្ស​ឞ្លាវ​ជាន​ជៃ​លុ​ឞ្ល៝ន​លែៈ​មអារ់​លើយ​ទូ​មល៝ម់​លុ​ឞ្ល៝ន‌ យើន​មា​លុ​ឞ្ល៝ន​អី​នៃ​ជេង​លុ​ឞ្ល៝ន​ទុត​ន៝ប់​ខ្លៃ​រាលាវ​ឞូ​មា​ជាន​ជៃ»។ ");
INSERT INTO cmok_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","លាស​នទ្រី​ម៝ស​នាវ​ឞូ​នតឹត​អ្យា? លុ​ឞ្ល៝ន​អី​នៃ​ជេង​នតឹត​មា​គ៝ប់។ ជេសរី​ឞូ​ម៝ស​រាលាច់​មា​គ៝ប់​តឹម​ឞាន​មា​ឞូនុយ្ស​ចោត​តា​កាលើ​លុ​អី​នៃ ជេសរី​នាវ​ផាត​ទោយ្ស​គ៝ប់​តា​ជឹត​នាប់​តៃ តឹម​ឞាន​មា​លុ​តុប​តា​កាលើ​ឞូនុយ្ស។ ឞូ​ម៝ស​អី​ចោត​តា​កាលើ​លុ​ឞ្ល៝ន​អី​នៃ ពាង់​អី​នៃ​លេក​រាហ៝ច់​រ៝។ ជេសរី​លាស​លុ​ឞ្ល៝ន​អី​នៃ​តុប​កាលើ​ទូ​ហ្វេ​ឞូនុយ្ស ឞូនុយ្ស​អី​នៃ​ហាច់​លែៈ​ផ្យៅ”។ ");
INSERT INTO cmok_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ជេស​ខាន់​ពាង់​តាង់​ឞ្រាស​យេឆូ ​ងើយ​នាវ​នតឹត​នៃ ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  នទ្រែល​មា​មពោល​កោរាញ​ជាន​ឞ្រាស ខាន់​ពាង់​គឹត​វ៝ត់​នាវ​ងើយ​អី​នៃ​លាស​មា​ឆាក់​ខាន់​ពាង់​រ៝ នទ្រី​ទឹង​ខាន់​ពាង់​អុច​ញុប​ឞ្រាស​យេឆូ ​តា​នៃ​រ៝ យើន​មា​ក្លាច​ផូង​ប៝ន​លាន​លើស។ ");
INSERT INTO cmok_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","នទ្រី​ខាន់​ពាង់​អី​នៃ​ក៝ប់​អ្វាញ់​នអោយ​ឞ្រាស​យេឆូ  ជេសរី​ដាៈ​ឞូ​គ្រ៝យ​ពាង់។ មពោល​អី​នៃ​គុ​ងាវ​ជាន​កើត​ឞូនុយ្ស​ឆ៝ង់ គៃ​មា​នទើម​ពាង់​ញុប​នាវ​តីស​តា​នទើ​ពាង់​មឞើស​ងក៝ច។ ខាន់​ពាង់​អុច​គែស​នាវ​មា​ញជុន​ពាង់​តា​កោរាញ​ក្វ៝ង់​ពីលាត ​អ៝ន់​តេៈ​ទោយ្ស​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ជេសរី​មពោល​អី​នៃ​អោប​ឞ្រាស​យេឆូ ៖ “ហើយ​នើម​នតី! ហេន​គឹត​ទឹង​លែៈ​នាវ​មៃ​មឞើស​នតី​នៃ​ជេង​ទី​ទាទេ​ងាន់។ មៃ​មោ​អោស​ក្លាច​មា​ឞូនុយ្ស មោ​អោស​កើយ្ស​ឞូនុយ្ស មៃ​នតី​នាវ​កោរាញ​ឞ្រាស​អ៝ន់​ទី។ ");
INSERT INTO cmok_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ទាន់​មឞើស​មា​ហេន​តឹង​នាវ​វៃ​ឞ៝ន់ ទី​ដ៝ង់​អ៝ន់​ព្រាក់​អី​កោរាញ​កាដាច់​តា​ឞ្រី​រោម ​ដាៈ​ឞ៝ន់​អ៝ន់​នៃ​មោ​លាស​មោ?” ");
INSERT INTO cmok_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","យើន​មា​ឞ្រាស​យេឆូ ​លែៈ​គឹត​អី​នាវ​ខាន់​ពាង់​អុច​អោប​នៃ ជេង​អោប​រាល៝ង​ពាង់ លាស​ពាង់​លាស​ទី ផូង​ប៝ន​លាន​មោ​ហោម​រ៝ង់​មា​ពាង់ យ៝រ​លាស​ខាន់​ពាង់​ឞ្យាញ់​អ៝ន់​ព្រាក់​អី​នៃ។ លាស​ពាង់​លាស​មោ​ទី ខាន់​ពាង់​អុច​នតោន​ពាង់​តា​កោរាញ​ក្វ៝ង់​ពីលាត  យ៝រ​លាស​ពាង់​ងើយ​តឹម​រាទ៝ង់​ដាស​ឞ្រី​រោម ​មោ​អ៝ន់​ប៝ន​លាន​អ៝ន់​ព្រាក់​មា​កោរាញ តឹង​កាដាច់​ក្វ៝ង់​តា​ឞ្រី​អី​នៃ​ដាៈ។ ជេសរី​ពាង់​លាស​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ល៝ង់​ញហើ​ព្រាក់​អី​អ៝ន់​មា​កាដាច់​អី​នៃ​ទូ​មល៝ម់។ តា​កាលើ​កាក់​នៃ​ឞូ​ម៝ស​រូប នទ្រែល​មា​ឞូ​ម៝ស​គែស​រាញា?” ឞូ​អើស​មា​ពាង់៖ “គែស​រូប នទ្រែល​មា​គែស​រាញា​កាដាច់​ក្វ៝ង់​តា​ឞ្រី​រោម ”។ ");
INSERT INTO cmok_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “លាស​នទ្រី នទើ​កោរាញ​កាដាច់​តា​ឞ្រី​រោម ​មព្លឹ​អ៝ន់​មា​ពាង់ នទើ​កោរាញ​ឞ្រាស​មព្លឹ​អ៝ន់​មា​កោរាញ​ឞ្រាស​នើម”។ ");
INSERT INTO cmok_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","នទ្រី​ខាន់​ពាង់​មោ​អោស​ទើយ​ញុប​ឞ្រាស​យេឆូ ​តា​នាប់​ឞាល់​ផូង យ៝រ​លាស​តា​នាវ​ពាង់​ងើយ​មោ​អោស​ឆៃ​គែស​តីស។ ខាន់​ពាង់​នទ្រ៝ត់​ហីស​រាហ៝ល់​ងាន់​យ៝រ​មា​តាង់​នាវ​ពាង់​អើស​ឞ្លាវ​ងាន់ ជេសរី​ខាន់​ពាង់​គុ​អ្យាត់​ឆាក់​រាក់​ក្លាក់​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ជេសរី​គែស​ផូង​ឆាដោឆី ​អាបាៈ​ហាន់​អោប​ឞ្រាស​យេឆូ  ផូង​អី​នៃ​កោរាញ​តា​ផូង​អីឆ្រាអែល ​ដ៝ង់ តីស​មា​ខាន់​ពាង់​មោ​អ្យាត់​អោស​ឞូនុយ្ស​លែៈ​ខឹត​ហោម​ទ៝ក់​រេស​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ខាន់​ពាង់​អោប​រាល៝ង៖ “ហើយ​នើម​នតីមោឆេ ​កាល់​អែ​នើស​លែៈ​ញចីស​ជេស​តា​ឆ៝ម់បុត​អ៝ន់​មា​ឞ៝ន់​អី​ផូង​អីឆ្រាអែល ​លាស​កើត​នអា៖ «លាស​ឞូ​ក្លោ​ឆ៝ៈ​អូរ ជេសរី​ពាង់​ខឹត លាស​ពាង់​មោ​គែស​ក៝ន ដាៈ​អី​អ៝ស​នោ​ពាង់​រី​នត្រ៝ៈ​ឆ៝ៈ​អូរ​ពាង់​គៃ​មា​គែស​ក៝ន​មា​ពាង់»។ ");
INSERT INTO cmok_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","នតឹត​លាស លាស​គែស​ពើស​នុយ្ស​អ៝ស​នោ អី​នោ​ឞោក​ទាក​រី​ឆ៝ៈ​អូរ ជេសរី​ពាង់​ខឹត ពាង់​មោ​អោស​គែស​ក៝ន។ ");
INSERT INTO cmok_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","អី​អ៝ស​គ្រ៝យ​ឞើស​កើយ​ពាង់​នៃ​នត្រ៝ៈ​ឆ៝ៈ ខឹត​មោ​គែស​ក៝ន​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ជេសរី​អី​អ៝ស​ត៝ល់​ពែ​នៃ​នត្រ៝ៈ​ឆ៝ៈ​ដ៝ង់ នហ៝​មា​លែៈ​ពើស​នុយ្ស​ខាន់​ពាង់​នៃ​ឆ៝ៈ​ពាង់​ទាទេ តីស​មា​មោ​អោស​គែស​ក៝ន។ ");
INSERT INTO cmok_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","កេង​មា​ទុត​មា​ទេល​ឞូ​អូរ​អី​នៃ​ខឹត​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ត៝ត់​នារ​ឞូនុយ្ស​ទ៝ក់​រេស​តៃ លាស​នទ្រី​ឞូ​ម៝ស​ឆ៝ៈ​ឞូ​អូរ​អី​នៃ? យ៝រ​លាស​លែៈ​ពើស​នុយ្ស​ខាន់​ពាង់​នើស​លែៈ​តាៈ​ឆ៝ៈ​ពាង់​ទាទេ”។ ");
INSERT INTO cmok_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ឞូនុយ្ស​តា​នែស​នតូ​អ្យា​វៃ​ឆ៝ៈ​អូរ​ឆ៝ៈ​ឆាយ។ ");
INSERT INTO cmok_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","យើន​មា​នារ​ជឹត​នាប់​តៃ ឞូ​ម៝ស​អី​កោរាញ​ឞ្រាស​ទែ​ទី​មា​រាក្លាយ្ស​ឞើស​ខឹត ខាន់​ពាង់​ទ៝ក់​រេស​គុ​តា​ប៝ន​អ្វែស​តា​កាលើ ឞូនុយ្ស​អី​នៃ​មោ​ហោម​អោស​ឆ៝ៈ​អូរ​ឆ៝ៈ​ឆាយ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ខាន់​ពាង់​មោ​ហោម​អោស​ឞ្លាវ​ខឹត​ជឹត ខាន់​ពាង់​ជេង​តឹម​ឞាន​មា​តោង​ពារ់​កោរាញ​ឞ្រាស ខាន់​ពាង់​លែៈ​ជេង​ក៝ន​កោរាញ​ឞ្រាស​ងាន់ យ៝រ​មា​ខាន់​ពាង់​លែៈ​ទ៝ក់​រេស​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","មោឆេ ​លែៈ​ងក៝ច​ជេស​មា​ឞូនុយ្ស​ខឹត​ទ៝ក់​រេស ពាង់​គែស​ញចីស​លាស​តា​ព្លាង់​ត្រ៝ង​ពុម​ល៝ក​អី​គែស​ហីត​អុញ នតុក​នៃ​ពាង់​ក្វាល់​កោរាញ​ឞ្រាស​លាស «ជេង​ឞ្រាស​អាឞ្រាហាម់ ​យើក​មឞាស ជេង​ឞ្រាស​អីឆាក់ ​យើក​មឞាស ជេង​ឞ្រាស​យាកោប ​យើក​មឞាស»។ ");
INSERT INTO cmok_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","នោក​មោឆេ ​ងើយ​នាវ​អី​នៃ​លែៈ​ពែ​នុយ្ស​ខាន់​ពាង់​អី​នៃ​លែៈ​ខឹត​អ៝ក់​នាម់​ជេស យើន​មា​ឞើស​នាវ​កោរាញ​ឞ្រាស​ងើយ​គឹត​នាល់​ខាន់​ពាង់​ហោម​រេស​មា​កោរាញ​ឞ្រាស។ កោរាញ​ឞ្រាស​មោ​អោស​ទី​ឞ្រាស​មា​ឞូនុយ្ស​ខឹត ពាង់​ឞ្រាស​មា​ឞូនុយ្ស​រេស”។ ");
INSERT INTO cmok_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ជេសរី​គែស​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល ​អាបាៈ​លាស​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​នើម​នតី! នាវ​មៃ​អើស​អី​នៃ​ឞ្លាវ​អ្វែស​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ជេសរី​ឞូ​មោ​ហោម​អោស​ឞាញ់​អោប​ពាង់​នាវ​អេងៗ​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ជេសរី​ឞ្រាស​យេឆូ ​អោប​ឞូ៖ “មើម​ទឹង​ឞូ​ក្វាល់​ឞ្រាស​ក្រីស ​អី​នើម​រាក្លាយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ទែ​ញជ្វាល់​រី​លាស​ក៝ន​ឆៅ​កាដាច់​ដាវីត ​ទើម? ");
INSERT INTO cmok_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","យ៝រ​លាស​តា​ឆ៝ម់បុត​នាវ​មព្រើ​អើម​កាដាច់​ដាវីត ​គែស​ងក៝ច​ល៝រ​មា​ឞ្រាស​ក្រីស ​ពាង់​លាស៖ «កោរាញ​ឞ្រាស​លាស​មា​កោរាញ​គ៝ប់៖ «គុ​មពែស​ឞើស​មា​គ៝ប់​ហ៝ម់ តា​នតុក​ឞូ​យើក​រាលាវ​ឞូ។ ");
INSERT INTO cmok_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ក៝ប់​ត៝ត់​គ៝ប់​អ៝ន់​ផូង​រាលាង់​ដាស​មៃ​ជេង​នតុក​រាកើល​ជ៝ង់​មៃ​ប៝ត់»»។ ");
INSERT INTO cmok_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","លាស​លែៈ​កាដាច់​ដាវីត ​នើម​ក្វាល់​ឞ្រាស​ក្រីស ​លាស​កោរាញ​ពាង់​នើម​កើត​នៃ យើន​មា​ក៝ន​ឆៅ​មោ​គែស​ក្វ៝ង់​រាលាវ​មា​អូ​ចែ លាស​នទ្រី​ឞ្រាស​ក្រីស ​មើម​ហោម​ឞ្លាវ​ក៝ន​ឆៅ​កាដាច់​ដាវីត ​ជឹត?” ");
INSERT INTO cmok_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","នោក​ប៝ន​លាន​ហោម​អែ​គុ​អ្យាត់​នាវ​ឞ្រាស​យេឆូ ​ងើយ​នៃ ជេសរី​ពាង់​លាស​មា​មពោល​អ៝ស​ម៝ន​ពាង់៖ ");
INSERT INTO cmok_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“អ៝ន់​ខាន់​អៃ​មៃ​ញជ្រាង់​ងាន់​ដាស​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​ឞ៝ន់​នៃ យ៝រ​លាស​ខាន់​ពាង់​អុច​ញឆ៝ស​អាវ​ជ៝ង​អី​អ្វែស ជេសរី​ឞ្រោៈ​រាឆ៝ង គៃ​មា​អ៝ន់​ឞូ​គឹត​លាស​ខាន់​ពាង់​គែស​នាវ​ខ្លៃ​ងាន់ អុច​អ៝ន់​ឞូ​មឞាស​កុញ​ឞោក​មា​ខាន់​ពាង់​រ៝ៈ​នតុក​ឞូ​តាច់​រាគ៝ល់​ទ្រាប់​នទើ មោ​លាស​រ៝ៈ​ត្រ៝ង​ក្វ៝ង់ នទ្រែល​មា​អុច​គុ​ឞើស​នាប់​ឞូ​តា​នតុក​ឞូ​លឺ​តា​ញីស​រាបុន​ផូង​ឞ៝ន់ ជេសរី​លាស​ញេត​ក្វ៝ង់​ឆោង​ក្វ៝ង់​នៃ​អុច​គុ​តា​នតុក​ឞូ​យើក​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","តីស​មា​ខាន់​ពាង់​មរោស​រាលាម់​ឞូ​អូរ​នទ្រោ​លែៈ​ខឹត​ឆាយ​គៃ​មា​ឆ៝ៈ​ពីត​ទ្រាប់​នទើ​ញីស​ជៃ​ឞូ​អូរ​នទ្រោ​អី​នៃ។ ជេសរី​ខាន់​ពាង់​ជាន​មឞើស​ឆើម​ទុត​ជ៝ៈ​ងាន់​អ៝ន់​ឞូ​អេង​តាង់ គៃ​មា​ញហើ​ខាន់​ពាង់​នើម​ជេង​ឞូនុយ្ស​រ៝ង់​មា​កោរាញ​ឞ្រាស​ងាន់។ ផូង​អី​នៃ​កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​ទុត​ជ្រូ​រ៝​តា​នារ​ជឹត​នាប់​តៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","នោក​ឞ្រាស​យេឆូ ​គុ​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស ពាង់​ងើក​ឆៃ​មពោល​នទ្រ៝ង់​តេៈ​ព្រាក់​តា​ត្រោម​ហុប​ញហើរ​មា​កោរាញ​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ជេសរី​ពាង់​ឆៃ​ទូ​ហ្វេ​ឞូ​អូរ​នទ្រោ​ខឹត​ឆាយ​អ៝​អាច ហាន់​តេៈ​ព្រាក់​ដេៈ​ទើម​ឞារ​មល៝ម់​កាក់​ជេៈ​តា​ត្រោម​ហុប​អី​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ឞ្រាស​យេឆូ ​លាស៖ “គ៝ប់​មឞើស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ កោរាញ​ឞ្រាស​កើប​ឞូ​អូរ​នទ្រោ​អ៝​អាច​អី​អ្យា​តេៈ​ព្រាក់​អ៝ក់​រាលាវ​ទឹង​លែៈ​ឞូ‌ ");
INSERT INTO cmok_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","យ៝រ​លាស​ទឹង​លែៈ​មពោល​អី​នៃ ព្រាក់​អី​ខាន់​ពាង់​តេៈ​តា​ត្រោម​ហុប​នើស ឆ៝ៈ​ព្រាក់​រាមែស​ឞើស​ឆាក់​ខាន់​ពាង់​នើម។ ល៝ង់​អី​ឞូ​អូរ​នទ្រោ​ទែ​នៃ ពាង់​ឞូនុយ្ស​អ៝​អាច​ហោ​ងាន់ ឞ៝ល​លាស​ព្រាក់​នៃ​គៃ​មា​ឆ្យាម់​នាវ​រេស​ពាង់​នើម​កាដោយ​លែៈ ពាង់​ហោម​ឆ៝ៈ​លែៈ​ផ្យៅ​តេៈ​ញហើរ​មា​កោរាញ​ឞ្រាស​ដ៝ង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ជេសរី​គែស​ឞូនុយ្ស​អាបាៈ​រានេ​មា​នាវ​អ្វែស​ញីស​ជាន​ឞ្រាស អី​ឞូ​ជាន​មា​លុ​អ្វែស នទ្រែល​មា​ព្លា​នទើ​អេងៗ​អី​ឞូ​ញហើរ​អ៝ន់​មា​កោរាញ​ឞ្រាស ឞ្រាស​យេឆូ ​លាស៖ ");
INSERT INTO cmok_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“លែៈ​នទើ​លែៈ​ជៃ​អី​ខាន់​អៃ​មៃ​ឆៃ​តា​អ្យា តា​នារ​ជឹត​នាប់​តៃ​ឞូ​មរា​លើស​រាល៝ម់​លែៈ​ផ្យៅ​រ៝ មោ​ហោម​អោស​គែស​ទូ​មល៝ម់​លុ​ឞ្ល៝ន​តឹម​រាទាប់​ជឹត”។ ");
INSERT INTO cmok_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ឞូ​អោប​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​នើម​នតី! ទាស​ហោម​ជ៝ៈ​នារ​អី​នៃ​មេស? លាស​នទ្រី​ម៝ស​នទើ​មឞេន​អ៝ន់​មា​ហេន​គឹត​លាស​នារ​អី​នៃ​ឞើយ​ត៝ត់?” ");
INSERT INTO cmok_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ឞ្រាស​យេឆូ ​អើស​មា​ខាន់​ពាង់៖ “ញជ្រាង់​ងាន់​ហ៝ម់ លើយ​អោស​អ៝ន់​ឞូ​នទើម​មា​ខាន់​អៃ​មៃ យ៝រ​លាស​នារ​ជឹត​នាប់​តៃ​គែស​អ៝ក់​ឞូ​នតូប​រាញា​គ៝ប់ ខាន់​ពាង់​លាស៖ «គ៝ប់​អ្យា​ឞ្រាស​ក្រីស ​ហែស»។ មោ​លាស​ខាន់​ពាង់​លាស៖ «នារ​ងគ្លែៈ​ទុត​ឞើយ​ត៝ត់​ជេស»។ លើយ​អោស​អ្យាត់​មពោល​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","លាស​ខាន់​អៃ​មៃ​តាង់​ឞូ​ងក៝ច​គែស​នាវ​តឹម​លើស​តឹម​ឆ្រែស មោ​លាស​គែស​នាវ​អុស​អាស លើយ​ក្លាច​រាវៃ​អោស យ៝រ​លាស​លែៈ​នាវ​អី​នៃ​ពាង់​ល៝រ​គែស​ងាន់​រ៝ យើន​មា​នារ​ងគ្លែៈ​ទុត​នែស​នតូ​អេ​ហ៝ៈ​ត៝ត់​គើញ​រ៝​អោស”។ ");
INSERT INTO cmok_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ឞ្រាស​យេឆូ ​លាស​ជឹត៖ “អេ​ល៝រ​មា​នារ​អី​នៃ ទូ​មពោល​តឹម​លើស​ដាស​ទូ​មពោល​អេង​ជឹត ទូ​ឞ្រី​ទាក​តឹម​លើស​ដាស​ទូ​ឞ្រី​ទាក​អេង​ជឹត។ ");
INSERT INTO cmok_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","តា​នតុក​អេងៗ គែស​ងគារ់​នែស​នតូ​ទុត​ទាង់ គែស​នាវ​ជី​ឆ៝ត់​ជី​ង៝ត​ក្វ៝ង់ គែស​នាវ​ជី​ខឹត​រុង​ខឹត​រាចាៈ នអ៝ប់​មា​គែស​នាវ​ត៝ត់​អេងៗ​ជាន​អ៝ន់​គែស​នាវ​ក្លាច​រាវៃ នទ្រែល​មា​គែស​នទើ​មឞេន​ក្វ៝ង់​ងាន់​អី​ឞូ​មោ​វៃ​ឆៃ​អោស​តា​កាលើ​ត្រោក​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","អេ​ល៝រ​មា​គែស​ទឹង​លែៈ​នាវ​អី​នៃ គែស​ឞូ​ជាន​ជេរ​មា​ខាន់​អៃ​មៃ ឞូ​ញុប ឞូ​ញជុន​ខាន់​អៃ​មៃ​តា​ញីស​រាបុន​ផូង​ឞ៝ន់​គៃ​មា​ផាត​ទោយ្ស តេៈ​ខាន់​អៃ​មៃ​តា​ត្រោម​នទ្រូង។ ឞូ​ញជុន​ខាន់​អៃ​មៃ​មា​កាដាច់ មា​កោរាញ​ក្វ៝ង់ គៃ​មា​តេៈ​ទោយ្ស​ខាន់​អៃ​មៃ​យ៝រ​មា​អ្យាត់​តឹង​គ៝ប់​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","យើន​មា​នាវ​អី​នៃ​ព្លាច់​អ៝ន់​មា​ខាន់​អៃ​មៃ​គែស​មឞើស​នាវ​មហែ​មហាន​អ្វែស​មា​ខាន់​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","អ៝ន់​ខាន់​អៃ​មៃ​គែស​នូយ្ស​នហ៝ម់​ន៝ប់​ហ៝ៈ លើយ​អោស​រាវៃ​នាវ​ល៝រ​គៃ​មា​តឹម​អើស​ដាស​នាវ​ខាន់​ពាង់​នតោន។ ");
INSERT INTO cmok_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","យ៝រ​មា​នោក​នៃ​គ៝ប់​អ៝ន់​មា​ខាន់​អៃ​មៃ​គែស​នាវ​មា​អើស នទ្រែល​មា​គែស​នាវ​មឹន​គឹត​ឞ្លាវ មោ​អោស​អ៝ន់​ទឹង​លែៈ​មពោល​តឹម​រាទ៝ង់​ទើយ​តឹម​អើស​ទើយ​តឹម​រាលាច់​ដាស​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ឞ៝ល​លាស​មេៈ​ឞឹ អ៝ស​នោ នទុល​មពោល នទ្រែល​មា​មឹត​ជាង់​ខាន់​អៃ​មៃ​នើម​កាដោយ​លែៈ ញជុន​ខាន់​អៃ​មៃ​មា​ខាន់​ពាង់ ជេសរី​ខាន់​អៃ​មៃ​អាបាៈ​ឞូ​ងខឹត​លើយ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","នោក​នៃ​គែស​ឞូនុយ្ស​អ៝ក់​ងាន់​ឞ្យាញ់​មា​ខាន់​អៃ​មៃ​ងាន់ យ៝រ​មា​ខាន់​អៃ​មៃ​តឹង​ឆាក់​គ៝ប់។ ");
INSERT INTO cmok_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","យើន​មា​ខាន់​ពាង់​មោ​គែស​នាវ​ទើយ​ដាស​ហ្វេង​ខាន់​អៃ​មៃ មោ​គែស​នាវ​ទើយ​ដាស​នាវ​រេស​នហ៝​រ៝​ខាន់​អៃ​មៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","លាស​ខាន់​អៃ​មៃ​ទាង់​អ៝ត់​ដាស​ទឹង​លែៈ​នទើ​អី​នៃ មោ​ឞាស​ញឆីង​មា​គ៝ប់ ខាន់​អៃ​មៃ​មរា​គែស​នាវ​រេស​នហ៝​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“លាស​ខាន់​អៃ​មៃ​ឆៃ​តាហែន​ហាន់​ញជ្វែង​ជុម​ប៝ន​ក្វ៝ង់​យេរូឆាលឹម  អ៝ន់​ខាន់​អៃ​មៃ​គឹត​លាស​ប៝ន​អី​នៃ​ឞើយ​មា​ហេង​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","នោក​នៃ​អ៝ន់​ឞូនុយ្ស​អី​គុ​តា​ឞ្រី​យូដា ​ទូ​ញច្វាត់​ក្រាប​តា​យោក ឞូនុយ្ស​អី​គុ​តា​ប៝ន​យេរូឆាលឹម ​រី​ញច្វាត់​លោស​ឞើស​ប៝ន​នៃ ឞូនុយ្ស​អី​គុ​ឞើស​ទីស​ប៝ន​នៃ​លើយ​អោស​ហាន់​លាប់​តា​ត្រោម​ប៝ន។ ");
INSERT INTO cmok_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","យ៝រ​លាស​នោក​នៃ​រ៝​កោរាញ​ឞ្រាស​ក្លាប់​នទាង់​តេៈ​ទោយ្ស​ប៝ន​លាន​ពាង់​នើម គៃ​មា​តឹម​ទី​ដាស​នាវ​លែៈ​គែស​ញចីស​តា​ឆ៝ម់បុត​នាវ​កោរាញ​ឞ្រាស​ងើយ។ ");
INSERT INTO cmok_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","នោក​នៃ​ដ៝ង់​ឞូ​អូរ​នត្រែវ ឞូ​អូរ​មពូ​ត៝ស​ក៝ន​គែស​នាវ​រេស​រាញាល់​ហោ​ងាន់ យ៝រ​លាស​គែស​នាវ​ជេរ​រាវៃ​ទុត​ហោ​ងាន់​តា​ឞ្រី​អី​នៃ កោរាញ​ឞ្រាស​តេៈ​ទោយ្ស​មា​ផូង​ប៝ន​លាន​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","គែស​អ៝ក់​ឞូនុយ្ស​ចោត​ខឹត​យ៝រ​មា​ដាវ នទ្រែល​មា​គែស​អ៝ក់​ឞូ​វែង​គុ​ជាន​ទឹក​តា​ឞ្រី​អេងៗ។ ផូង​ឞ្រី​អេងៗ​អី​មោ​ទី​ផូង​ឞ៝ន់​រី​ជ៝ត​មពែត​ប៝ន​យេរូឆាលឹម  នហ៝​មា​ត៝ត់​ទី​នារ​កោរាញ​ឞ្រាស​អ៝ន់​មា​ផូង​អី​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“នោក​នៃ​គែស​នទើ​ឞូ​មោ​វៃ​ឆៃ​តា​នារ តា​ខៃ នទ្រែល​មា​តា​មាញ់​មឞីង​រី។ លែៈ​ឞូនុយ្ស​តា​នែស​នតូ​គែស​នាវ​ជេរ​រាវៃ មោ​ហោម​អោស​ឞ្លាវ​មឹន ត៝ត់​មា​តាង់​នតែស​រាឞុស​ទាក​វាច់​ទាក​វារ់ នទ្រែល​មា​រាឞុស​ទុត​ក្វ៝ង់​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ឞូនុយ្ស​តា​នែស​នតូ​ក្លាច​ញឆ៝រ់ ទោល​គុ​មឹន​នាវ​ត៝ត់​តា​នែស​នតូ​អ្យា លែៈ​នទើ​តា​កាលើ​ត្រោក​គែស​ងគើ​ដាត់​ញហីង​ញហាង។ ");
INSERT INTO cmok_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","នោក​នៃ​ឞូ​ឆៃ​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​ហាន់​រ៝ៈ​នទ៝រ់​តុក​នអ៝ប់​មា​គែស​នាវ​ទើយ នទ្រែល​មា​នាវ​ច្រេក​លើប​ទុត​ហោ។ ");
INSERT INTO cmok_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ទោល​នាវ​អី​នៃ​នតើម​គែស អ៝ន់​ខាន់​អៃ​មៃ​ទ៝ក់​ហ៝ម់​ងគើរ​អ្វាញ់ អ៝ន់​គែស​នូយ្ស​នហ៝ម់​ឞាញ់ យ៝រ​លាស​នោក​កោរាញ​ឞ្រាស​រាក្លាយ្ស​ខាន់​អៃ​មៃ​ឞើស​ទឹង​លែៈ​នាវ​ជេរ​នើស​ឞើយ​មា​ត៝ត់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ជេសរី​ឞ្រាស​យេឆូ ​ងើយ​នតឹត​មា​តើម​រាវី ពាង់​លាស៖ “អ៝ន់​ខាន់​អៃ​មៃ​អ្វាញ់​តើម​រាវី  នទ្រែល​មា​ទឹង​លែៈ​តើម​ឆី។ ");
INSERT INTO cmok_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","លាស​ខាន់​អៃ​មៃ​ឆៃ​នហា​ពាង់​នតើម​ចាត់​ងកុរ ខាន់​អៃ​មៃ​គឹត​លាស​ខៃ​មីស​ឞើយ​មា​ត៝ត់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","តឹម​ឞាន​ដ៝ង់ ទោល​ខាន់​អៃ​មៃ​ឆៃ​លែៈ​នាវ​អី​នៃ​លែៈ​ត៝ត់ អ៝ន់​ខាន់​អៃ​មៃ​គឹត​លាស​នោក​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ឞូនុយ្ស​ងាន់​ឞើយ​មា​ត៝ត់​រ៝។ ");
INSERT INTO cmok_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","គ៝ប់​លាស​នហេល​នានេៈ​ងាន់​មា​ខាន់​អៃ​មៃ លែៈ​នាវ​អ្យា​ពាង់​ត៝ត់ ទោល​ឞូនុយ្ស​តា​រានោក​អាបៃ​អ្យា​ហោម​រេស​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ត្រោក​នែស​នតូ​មរា​រ៝ស​លេក​រ៝ យើន​មា​នាវ​គ៝ប់​ងើយ​មោ​អោស​ឞ្លាវ​រ៝ស​លេក ហោម​គែស​ទឹង​លែៈ​ងាន់”។ ");
INSERT INTO cmok_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“អ៝ន់​ខាន់​អៃ​មៃ​គុ​ញជ្រាង់! លើយ​អោស​អ៝ន់​នូយ្ស​នហ៝ម់​ខាន់​អៃ​មៃ​ពើស​មា​នទើ​ព៝ល់​រាម់​មអាក ពើស​មា​ញុល​នទ្រាញ់ មោ​លាស​ពើស​មា​មឹន​រាវៃ​មា​នាវ​រេស ក្លាច​លាស​នារ​គ៝ប់​ព្លឹ​វាច់​នៃ​ខាន់​អៃ​មៃ​តឹម​ឞាន​មា​គែស​ទាក់​យ៝រ​មា​ខាន់​អៃ​មៃ​មោ​គែស​គុ​ញជ្រាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","នារ​គ៝ប់​ព្លឹ​វាច់​តា​អ្យា មោ​គែស​អោស​ទូ​ហ្វេ​ឞូនុយ្ស​គឹត​ល៝រ ទឹង​លែៈ​ឞូនុយ្ស​លាម​នែស​នតូ​អ្យា​គែស​ទាក់​ទាទេ។ ");
INSERT INTO cmok_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ញជ្រាង់ នទ្រែល​មា​មឞើស​ឆើម​បាបើ​ហ៝ម់ គៃ​មា​គែស​ឆ្វាន​ទើយ​អ៝ត់​មា​លែៈ​នាវ​ត៝ត់​អី​នៃ នទ្រែល​មា​ទើយ​ទ៝ក់​ន៝ប់​មោ​គែស​ក្លាច​តា​នាប់​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស”។ ");
INSERT INTO cmok_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","អាប់​នារ​ឞ្រាស​យេឆូ ​គុ​នតី​ឞូ​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស តា​មាង់​ពាង់​ហាន់​គុ​តា​យោក​តើម​អោលីវ ។ ");
INSERT INTO cmok_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","អើម​អោយ​ផូង​ប៝ន​លាន​ហាន់​អ្យាត់​នាវ​ពាង់​នតី​តា​ជ៝ង់​គូង​ញីស​ជាន​ឞ្រាស។ ");
INSERT INTO cmok_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ជេសរី​បុន​នុមពាង់​មោ​គែស​នទ្រូយ អី​ឞូ​ក្វាល់​លាស​បុន​នហ៝ត​ដ៝ង់ លែៈ​ឞើយ​មា​ត៝ត់​ជេស។ ");
INSERT INTO cmok_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​ផូង​នើម​នតី​នាវ​វៃ​ផូង​អីឆ្រាអែល  ជ៝យ​នាវ​មើម​ជាន​គៃ​មា​ងខឹត​លើយ​ឞ្រាស​យេឆូ ​មោ​អ៝ន់​គែស​នាវ​អុស​អាស យ៝រ​មា​ខាន់​ពាង់​ក្លាច​ផូង​ប៝ន​លាន​នូយ្ស​នោក​ញុប​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ជេសរី​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​លាប់​គុ​តា​យូដាស  អី​ឞូ​ក្វាល់​អីឆាការីយោត ​ដ៝ង់។ ពាង់​ជេង​ទូ​ហ្វេ​ឞូនុយ្ស​តា ១២ នុយ្ស​មពោល​កោរាញ​អ៝ស​ម៝ន​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ពាង់​ហាន់​ម៝ប់​មា​មពោល​កោរាញ​ជាន​ឞ្រាស នទ្រែល​មា​មពោល​កោរាញ​តាហែន​ញីស​ជាន​ឞ្រាស គៃ​មា​ញច្រាៈ​ឞាល់​មើម​ជ៝យ​នាវ​គៃ​មា​គែស​ញជុន​ឞ្រាស​យេឆូ ​មា​ខាន់​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ជេស​ញច្រាៈ​ឞាល់​នាវ​អី​នៃ ផូង​អី​នៃ​រាម់​ងាន់ ខាន់​ពាង់​លែៈ​តឹម​ទី​ត៝ន​អ៝ន់​ព្រាក់​មា​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","យូដាស-​អីឆាការីយោត ​អុច​ដ៝ង់ ជេសរី​ជ៝យ​ម៝ង​គៃ​មា​លែវ​ឞូ​ហាន់​ញុប​ឞ្រាស​យេឆូ  នោក​ផូង​ប៝ន​លាន​មោ​គែស​គុ​នទ្រែល​ពាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ជេសរី​នារ​នទ្រាប់​ញេត​បុន​នុមពាង់​មោ​គែស​នទ្រូយ​លែៈ​ត៝ត់​ជេស ជេង​នារ​ឞូ​ងខឹត​ក៝ន​ឞែ​ឞ្យាប់​មា​ជាន​ឞ្រាស នទ្រែល​មា​ញេត​បុន​នហ៝ត។ ");
INSERT INTO cmok_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ជេសរី​ឞ្រាស​យេឆូ ​ដាៈ​ឞារ​ហៃ​កោរាញ​អ៝ស​ម៝ន​ពេត្រោស  នទ្រែល​យោហាន ​ហាន់​ល៝រ ពាង់​លាស​មា​ខាន់​ពាង់៖ “ខាន់​មៃ​ហាន់​នទ្រាប់​នាវ​ញេត​បុន​នហ៝ត​អ្យា​ឞ៝ន់​ទែ​មា​ឆោង​ឆា”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ខាន់​ពាង់​អោប​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញ អាស​នតុក​មៃ​អុច​អ៝ន់​ហេន​នទ្រាប់​នាវ​ញេត​ឆោង​ឆា​អ្យា​មេស?” ");
INSERT INTO cmok_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ឞ្រាស​យេឆូ ​អើស៖ “អ្យាត់​គ៝ប់​ហ៝ម់ ត៝ត់​លាប់​តា​ប៝ន​យេរូឆាលឹម ​រី​តៃ ខាន់​មៃ​ឆៃ​ទូ​ហ្វេ​ឞូ​ក្លោ​តេៈ​ទាក​យាង់​តា​មលីក។ អ៝ន់​ខាន់​មៃ​ហាន់​តឹង​ពាង់​នហ៝​មា​ត៝ត់​ពាង់​លាប់​តា​ត្រោម​ជៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ជេសរី​ខាន់​មៃ​ងើយ​ដាស​មា​តើម​ជៃ​អី​នៃ​លាស៖ «នើម​នតី​ហេន​ដាៈ​ហេន​ហាន់​អោប​មៃ ជ្រោ​មា​ពាង់​ញេត​បុន​នទ្រែល​អ៝ស​ម៝ន​តា​នារ​ញេត​បុន​នហ៝ត​អ្យា អាស​នតុក​មេស?» ");
INSERT INTO cmok_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ឞូនុយ្ស​តើម​ជៃ​នៃ​លែវ​មា​ខាន់​មៃ​រ៝​តា​នតុក​កាលើ​រី។ ជ្រោ​ហ្វី​ងាន់ លែៈ​អើម​ជេស​នទ្រាប់​ផ្យៅ អ៝ន់​ខាន់​មៃ​នទ្រាប់​នាវ​ញេត​ឆោង​អ៝ន់​មា​ឞ៝ន់​តា​ជ្រោ​នៃ​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ជេសរី​ឞារ​ហៃ​ខាន់​ពាង់​នៃ​ឞ្រោៈ​ទ្រើន​រ៝ ត៝ត់​អា​រី​ឆៃ​កើត​នាវ​ឞ្រាស​យេឆូ ​លាស​នើស ជេសរី​ខាន់​ពាង់​នទ្រាប់​នទើ​ឆោង​ឆា​មា​នាវ​ញេត​បុន​នហ៝ត​អី​នៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ត៝ត់​ទី​ម៝ង​នៃ ឞ្រាស​យេឆូ ​គុ​ឆោង​ឆា​តា​ញឆឺង​នទ្រែល​មពោល​កោរាញ​អ៝ស​ម៝ន‌ ");
INSERT INTO cmok_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ពាង់​លាស៖ “ហើយ​អ៝ស​ម៝ន គ៝ប់​អុច​ហោ​ងាន់​ឆោង​ឆា​នទ្រែល​ខាន់​មៃ​តា​នារ​ញេត​បុន​នហ៝ត​អ្យា អេ​ល៝រ​មា​គ៝ប់​គែស​នាវ​ជេរ​ជ៝ត់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","គ៝ប់​មឞើស​មា​ខាន់​មៃ គ៝ប់​មោ​ហោម​អោស​ឆោង​ឆា​ញេត​បុន​នហ៝ត​អ្យា​ជឹត នហ៝​មា​ត៝ត់​ញេត​បុន​អ្យា​គែស​នោក​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ឞូនុយ្ស​ងាន់​រី​មើ”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ជេសរី​ឞ្រាស​យេឆូ ​ឆ៝ៈ​កាច៝ក​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន លាស​អ្វែស​មា​កោរាញ​ឞ្រាស។ ជេស​លាស​អ្វែស​រី​ពាង់​លាស៖ “ឆ៝ៈ​កាច៝ក​អ្យា​តឹម​ពាៈ​ឞាល់​ញេត។ ");
INSERT INTO cmok_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","គ៝ប់​មឞើស​មា​ខាន់​មៃ នតើម​ឞើស​អាបៃ​អ្យា​គ៝ប់​មោ​ហោម​អោស​ញេត​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​ជឹត នហ៝​មា​ត៝ត់​កោរាញ​ឞ្រាស​ម៝ត់​អ្វាញ់​ទឹង​លែៈ​ឞូនុយ្ស​ងាន់​មើ”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ជេសរី​ពាង់​ឆ៝ៈ​ដ៝ង់​នុមពាង់​លាស​អ្វែស​មា​កោរាញ​ឞ្រាស ពាង់​គិច​នុមពាង់​អី​នៃ​អ៝ន់​ខាន់​ពាង់​ឆា​នហ៝​មា​លាស៖ “អ្យា​ជេង​ឆាក់​ជាន់​គ៝ប់ អី​គ៝ប់​អ៝ន់​មា​ខាន់​មៃ​តៃ អ៝ន់​ខាន់​មៃ​ជាន​កើត​នអា​លែត​ជឹត​នាប់​តៃ គៃ​មា​កាស​គឹត​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","លោច​ជេស​នាវ​ញេត​ឆោង​នៃ ឞ្រាស​យេឆូ ​ឆ៝ៈ​កាច៝ក​នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​ជាន​កើត​អី​នៃ​ដ៝ង់ ពាង់​លាស៖ “នទ្រាញ់​ព្លៃ​យុងយារ​ប៝ន​តា​កាច៝ក​អ្យា​ជេង​នាវ​តឹម​រាង្លាប់​មហែ​កោរាញ​ឞ្រាស​នទ្រែល​ខាន់​មៃ។ នាវ​តឹម​រាង្លាប់​មហែ​អី​នៃ​គ៝ប់​ជាន​មា​ខាន់​មៃ​មា​មហាម​គ៝ប់​អី​ហ៝ច​ឞើស​ឆាក់​ជាន់​គ៝ប់​នោក​គ៝ប់​ខឹត​តៃ។ ");
INSERT INTO cmok_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ល៝ង់​ឞូនុយ្ស​អី​ញជុន​គ៝ប់​មា​ផូង​រាលាង់​ដាស​គ៝ប់ ពាង់​គុ​ឆោង​ឆា​នទ្រែល​គ៝ប់​តា​ញឆឺង​អ្យា​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","អ្យាត់​មា​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​មរា​ខឹត តឹង​កោរាញ​ឞ្រាស​នើម​លែៈ​អុច យើន​មា​ឞូនុយ្ស​អី​ញជុន​គ៝ប់​គែស​នាវ​រេស​រាញាល់​ងាន់​រ៝​មា​ពាង់”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ជេសរី​មពោល​កោរាញ​អ៝ស​ម៝ន​អី​នៃ​តឹម​អោប​នទ្រាង់​ខាន់​ពាង់​នើម ឞូ​ម៝ស​ពាង់​អី​ជាន​នាវ​អី​នៃ​តា​មពោល​ខាន់​ពាង់​នើម​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","នោក​នៃ​មពោល​កោរាញ​អ៝ស​ម៝ន​គែស​នាវ​តឹម​រាលាច់​ឞាល់ ឞូ​ម៝ស​ពាង់​អី​ក្វ៝ង់​រាលាវ​ឞូ​តា​មពោល​ខាន់​ពាង់​នើម។ ");
INSERT INTO cmok_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “ទឹង​លែៈ​កាដាច់​ឞ្រី​អី​មោ​ទី​ផូង​ឞ្រី​ឞ៝ន់ ខាន់​ពាង់​ក្វាន់​ឞោក​ផូង​ប៝ន​លាន​ខាន់​ពាង់​នើម ជេសរី​មពោល​អី​គែស​នាវ​ទើយ​អី​នៃ​លាស​អេង​ឆាក់​ខាន់​ពាង់​នើម​ជេង​ឞូនុយ្ស​អ្វែស។ ");
INSERT INTO cmok_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","យើន​មា​តា​មពោល​ខាន់​មៃ​លើយ​អោស​ជាន​កើត​នៃ។ ឞូ​ម៝ស​ពាង់​អី​ក្វ៝ង់​រាលាវ​ឞូ​អ៝ន់​ជាន​តឹម​ឞាន​មា​ឞូនុយ្ស​ជេៈ​តា​ន៝ម់​ឞូ។ ឞូ​ម៝ស​អី​កោរាញ អ៝ន់​ពាង់​ជាន​តឹម​ឞាន​មា​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​មា​ឞូ។ ");
INSERT INTO cmok_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","យ៝រ​លាស​ឞូនុយ្ស​គុ​ឆោង​តា​ញឆឺង ដាស​មា​ឞូនុយ្ស​ឆើម​ឆ៝ៈ​ព្យាង់​ត្រាវ ឞូ​ម៝ស​លើ​ក្វ៝ង់? ឞូ​វៃ​លាស​ក្វ៝ង់​រាលាវ​ជេង​ឞូនុយ្ស​អី​គុ​ឆោង​តា​ញឆឺង​រី មា​ដាស​ឞូនុយ្ស​ឆើម​ឆ៝ៈ​ព្យាង់​ត្រាវ។ ល៝ង់​គ៝ប់​អ្យា​កោរាញ​ខាន់​មៃ​គុ​នទ្រែល​ខាន់​មៃ គ៝ប់​ជេង​តឹម​ឞាន​មា​ឞូនុយ្ស​ឆើម​កើល​ជាន​ការ​ឆើម​ឆ៝ៈ​ព្យាង់​ត្រាវ​ទើម។ ");
INSERT INTO cmok_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ខាន់​មៃ​លែៈ​ញឆ្រោយ្ស​នទ្រែល​គ៝ប់​តា​នាវ​ជេរ​គ៝ប់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","កើត​ឞឹ​គ៝ប់​លែៈ​អ៝ន់​មា​គ៝ប់ កើត​នទ្រី​ទឹង​គ៝ប់​អ៝ន់​មា​ខាន់​មៃ​ម៝ត់​អ្វាញ់​ផូង​ញឆីង​មា​គ៝ប់​ដ៝ង់‌ ");
INSERT INTO cmok_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","គៃ​មា​ខាន់​មៃ​គុ​ឆោង​ឆា​តា​ញឆឺង​នទ្រែល​គ៝ប់​នោក​គ៝ប់​ជេង​កាដាច់​ងាន់។ នហ៝​មា​ខាន់​មៃ​គុ​តា​រានើល​កាដាច់ គៃ​មា​ផាត​ទោយ្ស​លែៈ​ឞូនុយ្ស​តា ១២ មពោល​រាន៝យ​ទែស​ឞ៝ន់​នៃ”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ឞ្រាស​យេឆូ ​លាស៖ “ហើយ​ឆីមោន  ហើយ​ឆីមោន  អ្យាត់​គ៝ប់​ហ៝ម់! លែៈ​ឆាតាង់ ​អី​កោរាញ​មពោល​ឞ្រាស​អ្យើស​ទាន់​មា​កោរាញ​ឞ្រាស​រាល៝ង​ខាន់​មៃ។ ជេសរី​កោរាញ​ឞ្រាស​អ៝ន់​ជាន​កើត​នទ្រី។ ឆាតាង់ ​អុច​អ៝ន់​នាវ​នទើម​មា​ខាន់​មៃ គៃ​មា​ឆៃ​ឞូ​ម៝ស​អី​មោ​ញឆីង​ងាន់​មា​គ៝ប់ ពាង់​ជេង​តឹម​ឞាន​មា​ឞូ​រាឆែង​ផែ​គៃ​មា​លោស​ល៝ក់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","យើន​មា​លែៈ​គ៝ប់​មឞើស​ឆើម​ទាន់​មា​ឞឹ លើយ​អ៝ន់​មៃ​ឞាស​ញឆីង​មា​គ៝ប់។ ជេសរី​ត៝ត់​មៃ​ព្លឹ​ឆឹត​តៃ​មា​គ៝ប់ ញឆីង​មា​គ៝ប់​ជឹត អ៝ន់​មៃ​កើល​អ៝ស​ម៝ន​គ៝ប់​អ៝ន់​ខាន់​ពាង់​ញឆីង​ន៝ប់​មា​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ឆីមោន ​អី​ឞូ​ក្វាល់​ពេត្រោស ​ដ៝ង់ ពាង់​អើស៖ “ហើយ​កោរាញ! គ៝ប់​លែៈ​ជេស​នទ្រាប់​ឆាក់​ជាន់ អាស​នតុក​មៃ​ហាន់ គ៝ប់​តឹង​ហាន់​ដ៝ង់ ឞ៝ល​លាស​គុ​នទ្រូង មោ​លាស​ត៝ត់​ខឹត​ឆាក់”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ហើយ​ពេត្រោស ! គ៝ប់​មឞើស​មា​មៃ មាង់​អ្យា​អ្យារ់​អេ​ហ៝ៈ​នទ្រាវ ត៝ត់​មា​មៃ​រាលាច់​ពែ​តឹ​លាស​មោ​គឹត​នាល់​គ៝ប់”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ជេសរី​ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “នោក​គ៝ប់​ដាៈ​ខាន់​មៃ​ហាន់​គៃ​មា​មឞើស​នាវ​មហែ​មហាន​អ្វែស​នើស មោ​គែស​ព្រាក់ មោ​គែស​ទុង មោ​គែស​ញអោត​នតោ​ជ៝ត លែៈ​រឹង​ឞើស?” អ៝ស​ម៝ន​អើស​មា​ពាង់៖ “អើ លែៈ​រឹង”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ឞ្រាស​យេឆូ ​លាស៖ “អាបៃ​អ្យា ឞូ​ម៝ស​គែស​ទុង​ព្រាក់ ឞូ​ម៝ស​គែស​ទុង​ចែង អ៝ន់​ពាង់​ញអោត​តា​ឆាក់​ពាង់​នើម។ ឞូ​ម៝ស​អី​មោ​គែស​ដាវ អ៝ន់​ពាង់​តាច់​អាវ​ក្វ៝ង់​ពាង់​នើម​មា​រាវាត់​ទូ​ងគ៝រ់​ដាវ។ ");
INSERT INTO cmok_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","គ៝ប់​មឞើស​មា​ខាន់​មៃ តា​ឆ៝ម់បុត​នាវ​កោរាញ​ឞ្រាស​ងើយ​លែៈ​ញចីស​លាស​មា​គ៝ប់៖ «ឞូ​កើប​ពាង់​ជេង​តឹម​ឞាន​មា​ឞូនុយ្ស​គែស​ទោយ្ស»។ អ្យាត់​មា​នទើ​អ្យា​ជេង​ត៝ត់​ងាន់ យ៝រ​មា​អ្យាត់​មា​ទឹង​លែៈ​នទើ​អី​គែស​ញចីស​មា​គ៝ប់​ជេង​ត៝ត់​ងាន់​រ៝”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","អ៝ស​ម៝ន​អើស​មា​ពាង់៖ “ហើយ​កោរាញ! ឞ៝ន់​គែស​ឞារ​ងគ៝រ់​ដាវ”។ ឞ្រាស​យេឆូ ​អើស៖ “អើ ងើយ​ទាស​នៃ​លែៈ​គាប់​ហើយ្ស”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ជេសរី​ឞ្រាស​យេឆូ ​លោស​ឞើស​ជៃ​នៃ តឹង​មា​នាវ​វៃ​ពាង់ពាង់​ហាន់​តា​យោក​តើម​អោលីវ ​រី មពោល​អ៝ស​ម៝ន​លែវ​ឞាល់​ហាន់​តឹង​ពាង់​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ត៝ត់​តា​នតុក​ពាង់​វៃ​ហាន់​នៃ ឞ្រាស​យេឆូ ​លាស​មា​ខាន់​ពាង់៖ “មឞើស​ឆើម​ហ៝ម់ គៃ​មា​មោ​ជាន​តីស​នោក​គែស​នាវ​នទើម”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ជេសរី​ឞ្រាស​យេឆូ ​ហាន់​បាស​ងាយ​ឞើស​ខាន់​ពាង់​នៃ​ក្លាប់​លាស​ត្រុយ្ស​នតុប​លុ។ ត៝ត់​តា​រី​ពាង់​គុ​ច៝ន​ម៝ន​កោម៝ក់ មឞើស​ឆើម​កើត​នអា៖ ");
INSERT INTO cmok_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ហើយ​ឞឹ! លាស​មៃ​អុច ទាន់​មៃ​លើយ​អោស​អ៝ន់​គែស​នាវ​ជ៝ក់​ជេរ​អ្យា​មា​គ៝ប់។ យើន​មា​លើយ​អោស​តឹង​នូយ្ស​នហ៝ម់​គ៝ប់​អុច អ៝ន់​តឹង​នាវ​មៃ​អុច​ហ៝ៈ”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ទោល​នៃ​គែស​ឆៃ​តោង​ពារ់​កោរាញ​ឞ្រាស​ជុរ​តាៈ​ឞើស​កាលើ​ត្រោក​នតុក​កោរាញ​ឞ្រាស អ៝ន់​ឞ្រាស​យេឆូ ​គែស​នហ៝ម់​ឆ្វាន​ទាង់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","តា​នៃ​ពាង់​គែស​នាវ​រាង៝ត​រាវៃ​ទុត​ហោ ជេសរី​ពាង់​មឞើស​ឆើម​លើ​មា​ហោ​ដ៝ង់ លោស​ទាក​រាហាល​ពាង់​តឹម​ឞាន​មា​ហ៝ច​មហាម​ត្រោស​ក្លិច​ងាន់​តា​នែស​រី។ ");
INSERT INTO cmok_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ឞ្រាស​យេឆូ ​ទ៝ក់​ឞើស​នតុក​មឞើស​ឆើម​នៃ ហាន់​ជឹត​មពោល​អ៝ស​ម៝ន​ពាង់ ឆៃ​មពោល​អ៝ស​ម៝ន​នៃ​ហាក់​ឞិច​ទាទេ ខាន់​ពាង់​រាគាញ់​យ៝រ​មា​រាង៝ត​ហោ​អីរ​តា​នូយ្ស​នហ៝ម់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ពាង់​រាលៃ​ខាន់​ពាង់​លាស៖ “ម៝ស​ឞិច​ខាន់​មៃ​នៃ? ទ៝ក់​មឞើស​ឆើម​ហ៝ម់ គៃ​មា​មោ​ជាន​តីស​នោក​គែស​នាវ​នទើម”។ ");
INSERT INTO cmok_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ទោល​ឞ្រាស​យេឆូ ​ហោម​ងើយ​នៃ ទោ​មា​ត៝ត់​យូដាស-​អីឆាការីយោត ​នអ៝ប់​មា​លែវ​ទូ​មពោល​ឞូនុយ្ស ពាង់​ហាន់​ទាច់​ឞ្រាស​យេឆូ  ជេសរី​ចុម​អ្វែស​លាង់​ឞ្រាស​យេឆូ ​តឹង​នាវ​វៃ​ផូង​អីឆ្រាអែល  ពាង់​ជេង​អ៝ស​ម៝ន​តា​មពោល ១២ នុយ្ស​នៃ​ដ៝ង់។ ");
INSERT INTO cmok_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ឞ្រាស​យេឆូ ​លាស​មា​ពាង់៖ “ហើយ​យូដាស  មៃ​ជាន​ចុម​ទូ​ត៝ង​កើត​នៃ​គៃ​មា​ញជុន​គ៝ប់​អី​ក៝ន​ឞូនុយ្ស​តាៈ​ឞើស​កោរាញ​ឞ្រាស​នទ្រី​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ជេសរី​មពោល​អី​គុ​នទ្រែល​ឞ្រាស​យេឆូ ​ឆៃ​នាវ​អី​ឞើយ​មា​ត៝ត់ លាស​មា​ឞ្រាស​យេឆូ ៖ “ហើយ​កោរាញ! អ៝ន់​ហេន​ឆ៝ៈ​ដាវ​មា​ឆ្រែស​ឞើស?” ");
INSERT INTO cmok_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","គែស​ទូ​ហ្វេ​អ៝ស​ម៝ន​រី​តាក់​ដាវ​ឆ្រែស​ទឹក​កោរាញ​ជាន​ឞ្រាស​ទុត​ក្វ៝ង់​តាច់​តោរ​ឞើស​មា។ ");
INSERT INTO cmok_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","តីស​មា​ឞ្រាស​យេឆូ ​លាស៖ “លើយ​ហោម!” ជេសរី​ឞ្រាស​យេឆូ ​ញុប​តោរ​ឞូ​ក្លោ​អី​នៃ ជាន​តោរ​ពាង់​អ៝ន់