﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmo_vpl;
CREATE TABLE cmo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmo_vpl WRITE;
INSERT INTO cmo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bơh ntơm saơm saam Kôranh Brah njêng trôk, njêng neh ntu. ");
INSERT INTO cmo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nôk nây nơh neh ntu ê hŏ geh ôh, hôm nsoyh bŏng lahưr, ngo chêk kôlăk ngăn ta bơh lơ dak jru, jêh ri Brah Huêng Ueh Kôranh Brah hăn rsong ta kalơ dak ri. ");
INSERT INTO cmo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Jêh ri Kôranh Brah lah: “Ăn geh ang” jêh ri geh ang ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kôranh Brah say ang i nây lĕ ueh jêh, jêh ri Păng tâm nkhah lơi ang nây bơh ngo. ");
INSERT INTO cmo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kôranh Brah kuăl ang i nây rnha «Nar», jêh ri Păng kuăl đŏng ngo rnha «Măng», ta nây geh măng geh ôi, i nây jêng nar tŏl nguai. ");
INSERT INTO cmo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Jêh ri Kôranh Brah lah: “Ăn geh du mlŏm rlat ta nklang n'gul dak gay ma tâm nkhah lơi dak”. ");
INSERT INTO cmo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ndri Kôranh Brah jan rlat i nây, gay ma tâm nkhah lơi dak bơh dŏng bơh lơ, jêh ri geh kơt i nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Jêh ri Kôranh Brah kuăl rlat i nây rnha «Trôk», ta nây geh măng geh ôi, i nây jêng nar tŏl bar. ");
INSERT INTO cmo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Jêh ri Kôranh Brah lah: “Dak i ta nâm trôk i nây ăn nsŭn gŭ du ntŭk, gay ăn mpơl kơh” jêh ri geh kơt i nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kôranh Brah kuăl kơh i nây rnha «Neh», kuăl dak nsŭn i nây rnha «Dak văch dak văr», Kôranh Brah say lĕ ndơ Păng njêng i nây ueh dadê jêh. ");
INSERT INTO cmo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Jêh ri Kôranh Brah lah: “Ăn neh geh hon tơm si tơm gle rêp ja i geh n'găr, tơm si tơm gle i geh play i geh n'găr hon tă bơh neh, geh lĕ ntil tâng ntil êng êng” jêh ri geh kơt i nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ta kalơ neh păng geh hon pru tơm si tơm gle rêp ja dâng lĕ ntil êng êng, ndrel ma tơm si tơm gle i geh play i geh n'găr. Kôranh Brah say lĕ ndơ Păng njêng i nây ueh dadê jêh. ");
INSERT INTO cmo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ta nây geh măng geh ôi, i nây jêng nar tŏl pe. ");
INSERT INTO cmo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Jêh ri Kôranh Brah lah: “Ăn geh ndơ ang êng êng ta kalơ trôk, gay ma tâm nkhah lơi nar đah măng, ăn ma blao kơp nar, khay, năm ");
INSERT INTO cmo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ndrel ma ang ta neh ntu dja đŏng” jêh ri geh kơt nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ndơ ang Kôranh Brah lĕ jêh njêng geh ndơ ang kuŏng kuŏng bar mlŏm ta kalơ trôk, ndơ ang i du mlŏm ri dăng rlao bu ma ang nôk nar, ndơ ang đê̆ đê̆ ri ma ang nôk măng, n'ho ma Păng njêng đŏng dâng lĕ mănh mbing. ");
INSERT INTO cmo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kôranh Brah tê̆ ndơ ang ta kalơ trôk nây, gay ma ang ta neh ntu dja ");
INSERT INTO cmo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ma ang ta nôk nar, ta nôk măng, gay ma tâm nkhah ang bơh ngo đŏng, Kôranh Brah say lĕ ndơ ang i nây ueh dadê jêh. ");
INSERT INTO cmo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ta nây geh măng geh ôi, i nây jêng nar tŏl puăn. ");
INSERT INTO cmo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Jêh ri Kôranh Brah lah: “Ta trôm dak ăn geh kât ka n'gla me re ăn ŏk rŏk, ta kalơ trôk ăn geh siŭm mpăr đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ndri Kôranh Brah njêng ka kuŏng kuŏng ngăn rŏ dak văch dak văr, ndrel ma dâng lĕ ndơ i geh rêh geh n'hâm blao mpŏt blao nslŏng pâl re lĭnh vĭnh ta dak, tâng ntil êng êng ngăn, dâng lĕ siŭm nar geh tâng ntil êng êng đŏng. Kôranh Brah say dâng lĕ ndơ i nây ueh dadê jêh. ");
INSERT INTO cmo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Jêh ri Kôranh Brah ăn nau geh jêng dâng lĕ ntil ndơ i nây, Păng lah: “Ăn geh oh geh kon bâk rơ̆ lam dak văch dak văr nây, siŭm nar ăn geh oh geh kon bâk rơ̆ ta neh ntu dja đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ta nây geh măng geh ôi, i nây jêng nar tŏl prăm. ");
INSERT INTO cmo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Jêh ri Kôranh Brah lah: “Ta neh ntu dja ăn geh mpômpa (siŭm) tâng ntil êng êng, mpômpa (siŭm) ta ƀon, mpômpa (siŭm) hung vơr, mpômpa (siŭm) ta bri” jêh ri geh kơt nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kôranh Brah njêng mpômpa (siŭm) ta bri, geh tâng ntil êng êng, mpômpa (siŭm) ta ƀon tâng ntil êng êng, dâng lĕ mpômpa (siŭm) i hung i vơr ta neh ntu dja geh tâng ntil êng êng đŏng, Păng say dâng lĕ ntil ndơ i nây ueh dadê jêh. ");
INSERT INTO cmo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Jêh ri Kôranh Brah lah: “Ăn Bân jan kon bunuyh blao mân jêng kôranh tâm ban ma Bân Nơm kơt Bân Nơm, ăn păng kôranh ma neh ntu dja, dơi đah ma kât ka ta dak văch dak văr, siŭm mpăr ta kalơ trôk, mpômpa (siŭm) ta bri ta ƀon lam neh ntu, ndrel ma ăn păng dơi dadê đah dâng lĕ ntil ndơ hung ndơ vơr ta neh ntu dja”. ");
INSERT INTO cmo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kôranh Brah njêng kon bunuyh nơh blao mân jêng kôranh tâm ban ma Păng Nơm ngăn Kơt Păng Nơm ngăn ro Kôranh Brah njêng khân păng ăn geh bu klô geh bu ur. ");
INSERT INTO cmo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Jêh ri Kôranh Brah ăn nau geh jêng ma khân păng, Păng lah: “Ăn bă oh rong kon bâk rơ̆ lam neh ntu dja, ăn jêng kôranh ma neh ntu dja, jêh ri dơi đah ma kât ka ta dak văch dak văr, siŭm mpăr ta kalơ trôk, dơi đah dâng lĕ rngôch mpômpa (siŭm) i geh ta neh ntu dja”. ");
INSERT INTO cmo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kôranh Brah lah jât: “Hơi khân ay may, uănh dja! Gâp njêng ăn geh dâng lĕ ntil rêp ja i geh n'găr hon lam neh ntu dja, ndrel ma dâng lĕ ntil tơm si tơm gle i geh play geh n'găr dja, gay ma ăn khân ay may sông sa ");
INSERT INTO cmo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","jêh ri lĕ rngôch siŭm mpăr kalơ trôk, lĕ rngôch mpômpa (siŭm), dâng lĕ ntil ndơ hung ndơ vơr, dâng lĕ ntil ndơ i geh rêh geh n'hâm ta neh ntu dja, gâp ăn đŏng rêp ja tơm si tơm gle dâng lĕ ntil dja pre ma kăp ma sa đŏng” jêh ri păng geh kơt nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kôranh Brah uănh dâng lĕ rngôch ndơ Păng njêng i nây nơh, Păng say dâng lĕ ntil ndơ Păng jan nơh, lĕ ueh ngăn ro, ta nây geh măng geh ôi, i nây jêng nar tŏl prao. ");
INSERT INTO cmo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ndri trôk, neh ntu, lĕ rngôch ăp ntil ndơ, lĕ rngôch ăp ntil mpômpa (siŭm), Kôranh Brah njêng jêh lĕ phiao dadê đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tât nar pơh, Kôranh Brah jan lĕ ndơ nơh lĕ jêh lĕ phiao, jêh ri Păng gŭ dơm bah jan kar ta nar pơh i nây. ");
INSERT INTO cmo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kôranh Brah ăn nau geh jêng ta nar pơh i nây, kơp nar i nây jêng nar khlay jêng nar kloh ueh, yorlah nar i nây Păng gŭ bah dâng lĕ ndơ Păng jan Păng njêng nơh. ");
INSERT INTO cmo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ndri nau nkoch ntơm geh trôk ntơm geh neh ntu. Bơh nôk Brah Yêhôva njêng trôk, njêng neh ntu ");
INSERT INTO cmo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","tơm si ê hŏ geh hon, ba du nkong ê hŏ geh đŏng, yorlah Brah Yêhôva ê hŏ ăn geh dak mih tŭp ta neh ntu dja, bunuyh ma jan mir mâu hŏ geh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Geh dak lôh n'hôl tă bơh neh dơm bĕ lam neh ntu. ");
INSERT INTO cmo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Jêh ri Brah Yêhôva sŏ neh môi jan mon du huê bunuyh, Păng khôm n'hâm lăp rŏ trôm muh bunuyh i nây, jêh ri geh n'hâm geh suan, jêng rêh ƀlư ndri păng heh. ");
INSERT INTO cmo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Brah Yêhôva ăn geh du mlŏm mir ta bri Êđen, ta ntŭk mpeh ma lôh nar nây, jêh ri sŏ bunuyh i Păng mon jan nơh leo gŭ ta ntŭk mir i nây. ");
INSERT INTO cmo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Jêh ri Brah Yêhôva ăn tơm si tơm gle ăp ntil hon đeh pru tă bơh neh, ueh ngăn uănh, ndrel ma geh play sa kah đŏng. Ta nklang n'gul mir i nây geh tơm si bar tơm, tơm si i du tơm ri ăn ma nau rêh, tơm si i du tơm ri jât ăn ma gĭt năl ndơ ueh ndơ djơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Geh du mlŏm n'hong lôh tă bơh bri Êđen hoch rŏ mir i nây, jêh ri n'hong i nây geh nchah puăn ơ̆ n'hong đŏng lôh bơh n'hong i nây. ");
INSERT INTO cmo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Du mlŏm n'hong rnha Pihŭn, hoch nkue nkuăch rŏ bri Havila, ntŭk bri i geh mayh. ");
INSERT INTO cmo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Mayh i lôh tă bơh ntŭk i nây ueh ngăn, jêh ri geh đŏng ntăk si ƀô kah, ndrel ma lŭ khlay rnha Đâykiâm. ");
INSERT INTO cmo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","N'hong tŏl bar rnha Kihun, i hoch nkue nkuăch rŏ bri Kuh. ");
INSERT INTO cmo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","N'hong tŏl pe rnha Hiđêkel, hoch mpeh ma lôh nar ma ƀon Asơr. Jêh ri n'hong tŏl puăn rnha Ơprat. ");
INSERT INTO cmo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Jêh ri Brah Yêhôva sŏ bunuyh i Păng jan mon nơh ăn gŭ ta mir Êđen i nây, n'ho ma đă bunuyh i nây gŭ mât uănh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Brah Yêhôva đă bunuyh i nây, Păng lah: “Lĕ rngôch play si play gle ta mir dja may sa dadê mâu chrao vă ");
INSERT INTO cmo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","tih ma ta plăng tơm si ăn ma gĭt năl ndơ ueh ndơ djơh, Gâp mâu ôh ăn may sa, mâu ăn may sa vă, lah may sa may khât nar nây ro”. ");
INSERT INTO cmo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Jêh ri Brah Yêhôva mân êng: “Lah ăn bunuyh dja gŭ du huê êng lĭch ueh ôh, lah ndri Gâp jan tay du huê bunuyh jât ăn ma păng gŭ ndrel tâm kơl băl”. ");
INSERT INTO cmo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Nôk Brah Yêhôva njêng mpômpa (siŭm) dâng lĕ nơh, Păng sŏ neh mon ăp ntil mpômpa (siŭm) ta neh ntu, ăp ntil siŭm mpăr ta kalơ trôk. Jêh ri Brah Yêhôva leo dâng lĕ mpômpa (siŭm) i nây ma bunuyh, yorlah Brah Yêhôva ŭch gĭt a mơm bunuyh i nây tê̆ rnha ăn ma mpômpa (siŭm) dâng lĕ i nây, jêh ri mpômpa (siŭm) dâng lĕ geh rnha tâng bunuyh tê̆ rnha ăn. ");
INSERT INTO cmo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Bunuyh tê̆ rnha lĕ rngôch mpômpa (siŭm) ta bri, ta ƀon, ndrel ma siŭm mpăr ta kalơ trôk đŏng. Yơn ma mâu ôh say geh du ntil ndơ ma blao tâm kơl bunuyh i nây, ma blao gŭ ndrel păng. ");
INSERT INTO cmo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ndri Brah Yêhôva ăn bunuyh i nây lêt bêch, Brah Yêhôva sŏ du mlŏm nting payh bunuyh i nây, jêh ri njâr lơi mlay ăn jâr. ");
INSERT INTO cmo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nting payh i Brah Yêhôva sŏ tă bơh bunuyh i nây Păng jan jêng bu ur, jêh ri leo bu ur i nây ăn ma bunuyh bu klô i nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Bunuyh i nây lah: “Bunuyh dja ro nting i sŏ tă bơh nting gâp Mlay i sŏ tă bơh mlay gâp Gâp kuăl păng rnha «Bu ur» Yorlah păng nơh lôh tă bơh bu klô”. ");
INSERT INTO cmo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yor ma kơt ndri dâng bu klô lôh du bơh me bơ̆, hăn gŭ a ur, jêh ri bar hê khân păng nây jêng ur sai jêng du rnglay săk. ");
INSERT INTO cmo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nôk nây lĕ bar hê ur sai khân păng nây gŭ lahôk, mâu geh nau đit prêng đê̆ ro. ");
INSERT INTO cmo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ntơm nơh geh du mlŏm bêh jêng mpômpa (siŭm) bri, păng blao rlăm nau rlao bu, đah ma mpômpa (siŭm) aƀă êng ta bri i Brah Yêhôva lĕ jêh njêng. Geh du nar bêh nây ôp ma bu ur i nây: “Hơi yôh, ngăn lah Kôranh Brah lah nơh: «Mâu ăn khân ay may sa play dâng lĕ ta mir dja?»” ");
INSERT INTO cmo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Bu ur i nây ơh ma păng: “Lĭch ndri ôh, play ta mir dja Kôranh Brah ăn hên sa dadê, ");
INSERT INTO cmo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","tơm play i nklang mir i nây du tơm dơm, Kôranh Brah lah: «Play tơm si i nklang mir i nây mâu ôh ăn khân ay may sa, mâu ôh ăn khân ay may pah, lah sa lah pah khân ay may mra khât ro», ndri lah pre nơh”. ");
INSERT INTO cmo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Bêh lah ma bu ur i nây jât: “Mâu khât ôh yôh, khân ay may mâu khât vă. ");
INSERT INTO cmo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kôranh Brah Păng gĭt, lah khân ay may sa, măt mra ang, ri mơ dâng khân ay may jêng tâm ban ma Kôranh Brah nơm, gĭt năl ndơ ueh ndơ djơh đŏng ê̆”. ");
INSERT INTO cmo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Jêh ri bu ur i nây say play si i nây dŭm ueh ngăn, ŭch ma sa ro, păng kơnh geh nau gĭt blao i ri, n'ho ma tât păng pĕ sa. I sai păng gŭ đah păng nơm ta nây đŏng, jêh ri pă ăn i sai păng sa, i sai păng sa đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Jêh sa play i nây, măt khân păng say ang ngăn ro, n'ho ma gĭt lah săk khân păng nơm gŭ lahôk đŏng, jêh ri khân păng pĕ n'ha Rvijâng tâm nkrêp jan bok gay ma mbăn săk jăn khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Tât nar vet nsrĭnh rĭnh nđik rngêt nây, khân păng tăng nteh Brah Yêhôva hăn brô̆ rŏ mir nây, khân păng du nchuăt krap ta nâm tơm si ta mir nây ro, gay ma lơi ăn Brah Yêhôva say. ");
INSERT INTO cmo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Jêh ri Brah Yêhôva kuăl i sai ri: “Hơi Ađăm, ah may hiơ?” ");
INSERT INTO cmo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Păng ơh: “Gâp tăng May hăn rŏ mir nây, gâp klach nsŏr ngăn, yorlah gâp nơh gŭ săk lahôk dơm, kơt ndri dâng gâp krap Kôranh Brah mê”. ");
INSERT INTO cmo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Brah Yêhôva ôp jât: “Bu moh mbơh ma may, dâng may gĭt lah gŭ lahôk? Gĭt may geh sa play si i Gâp buay mâu ăn may sa nơh mâu?” ");
INSERT INTO cmo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ađăm ơh: “Bu ur i May ăn gŭ ndrel gâp nơh, păng ăn play i nây ma gâp, jêh ri gâp sa đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Jêh ri Brah Yêhôva lah bu ur i nây: “Moh jan ay kơt ndri ri?” Bu ur i nây ơh: “Bêh de mƀrôh đă gâp sa, dâng gâp sa play si i nây nơh, Kôranh Brah mê”. ");
INSERT INTO cmo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Brah Yêhôva lah bêh: “Yor ma may jan nđay Dâng lĕ mpômpa (siŭm) aƀă êng I ta bri ta ƀon Du mlŏm may dja Gâp rtăp ăn may brô̆ hung ma ndŭl Ndrel ma sa ler neh Du njăr nau rêh may. ");
INSERT INTO cmo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Jêh ri Gâp ăn geh nau tâm lơh may, đah bu ur i nây Ndrel ma rnoi deh bu ur i nây, đah ma i kon sau may tay đŏng Rnoi deh păng tay mra jot bôk may Jêh ri may tay mra chôk rmăng iăr rnoi deh păng đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Jêh ri Brah Yêhôva lah ma bu ur i nây đŏng: “Dôl ay gŭ oh Gâp ăn ay geh nau jêr hô rlao jât Ay geh nau ji ndŭl hô ngăn ro Nuih n'hâm ay mra ŭch ngăn mât bôk sai ay Tih ma sai ay mât bôk ay”. ");
INSERT INTO cmo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Jêh ri Brah Yêhôva lah Ađăm đŏng: “Gâp rtăp neh dja, mâu ôh ăn geh jêng Yor ma may iăt nau ur may sa play bơh tơm si i Gâp mâu ăn sa nây nơh Ndri dâng may joi ndơ sông sa pŏk neh rơah rgănh ăp nar du njăr nau rêh may. ");
INSERT INTO cmo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Jêh ri may sông sa ndơ i hon lôh tă bơh bri bơh mir Yơn ma neh hon rêp hon lok đŏng ");
INSERT INTO cmo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","May jan kar lôh rhal pal mlay ngăn Ri mơ geh ndơ sông sa ma siăm săk tât khât nkre ma lêk tay ta neh Yorlah Gâp sŏ mon may nơh tă bơh neh môi Kơt ndri may mra jêng tay neh môi kơt ơm đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Jêh ri Ađăm tê̆ rnha ur păng i nây kuăl lah «Êva», yorlah păng nơh i mê̆ dâng lĕ rngôch bunuyh. ");
INSERT INTO cmo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Jêh ri Brah Yêhôva sŏ ntô mpômpa (siŭm) sơm jan bok ao sơm nsoh ăn ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Brah Yêhôva lah êng Păng Nơm: “Aƀaơ ri bunuyh jêng tâm ban ma Bân, lĕ gĭt năl ndơ ueh ndơ djơh, lah ndri gay ma lơi ăn khân păng geh nau rêh n'ho ro, lơi ôh ăn khân păng pĕ sa tay play tơm si ăn nau rêh”. ");
INSERT INTO cmo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ndri dâng Brah Yêhôva ntrŭt mprơh khân păng du lôh bơh mir Êđen nây, ăn khân păng gŭ ntŭk êng, jan mir pŏk neh i Brah Yêhôva sŏ mon njêng khân păng nơh. ");
INSERT INTO cmo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Jêh ntrŭt mprơh khân păng du lôh bơh mir Êđen i nây, Brah Yêhôva ăn tông păr Chêrupin, ndrel ma đao ŭnh rvao njrăng trong, kŏp bơh mpeh lôh nar mir Êđen nây, gay ma lơi ôh ăn bunuyh plơ̆ tay ta tơm si i ăn nau rêh n'ho ro. ");
INSERT INTO cmo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Jêh ri Ađăm gŭ đah Êva i ur păng ri, Êva ntreo gŭ oh geh kon nguai, jêh ri Êva lah: “Dja Brah Yêhôva ăn gâp geh du huê kon bu klô, gâp be tê̆ rnha păng «Kain»”. ");
INSERT INTO cmo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Jêh ri păng geh tay du huê kon bu klô jât, păng tê̆ rnha Abel. Tât khân păng lĕ ndăm, i oh ri bunuyh chiăp be biăp, i nô ri bunuyh jan mir. ");
INSERT INTO cmo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Geh du nar i nô sŏ ƀă ndơ i geh tă bơh mir păng nơm nây, jêh ri ndjôt nhhơr ăn ma Brah Yêhôva. ");
INSERT INTO cmo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Lŏng i oh ri nhhơr đŏng, păng sŏ i kon dak bôk ta phung mpômpa (siŭm) i pre chiăp nây ƀă, ndrel ma i ngi ta săk, jêh ri păng nhhơr ăn ma Brah Yêhôva. Nôk păng nhhơr nây, Brah Yêhôva răm ngăn ma păng, ndrel ma ndơ nhhơr păng nây. ");
INSERT INTO cmo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tih ma Kain i nô păng ri, Brah Yêhôva mâu răm ôh, ndrel ma ndơ nhhơr păng. Ndri dâng Kain nuih hô ngăn, muh măt păng chăng rhŏnh. ");
INSERT INTO cmo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Brah Yêhôva lah ma păng: “Hơi Kain, moh nuih may i nây? Moh jan muh măt may chăng rhŏnh nây mêh? ");
INSERT INTO cmo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Lah may jan ueh, geh nau răm ngăn, lah may mâu ôh jan ueh, jan nkhơng ndơ djơh chrao, nau djơh i nây păng gŭ kŏp ta bôk mpông may nây, tâm ban ma yao gŭ nsan kŏp sa hêk du mlŏm mpômpa (siŭm). Ndơ djơh ŭch jan kôranh kŏp đă may jan djơh, lah ndri ăn may dơi đah nau djơh i nây hŏm”. ");
INSERT INTO cmo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kah du nar nây, Kain jă i oh păng nây hăn lôh a mir. Tât ta mir ri, Kain rdôh nkhât lơi oh păng nây tât khât ro. ");
INSERT INTO cmo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Jêh ri Brah Yêhôva ôp: “Hơi Kain, ah oh may nây mêh?” Kain ơh: “Gĭt eh, gâp mâu gĭt ôh Kôranh Brah mê, gâp gĭt ma bunuyh mât păng lah?” ");
INSERT INTO cmo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Jêh ri Brah Yêhôva lah: “Moh si kô̆ may jan kơt nây mêh? Yorlah mham oh may i may nkhât nơh hoch ta neh, mham i nây tâm ban ma nter kuăl đă Gâp kôh may ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Aƀaơ ri Gâp rtăp may, ntrŭt may du lôh ngai tă bơh ntŭk neh dja ngăn ro, bơh ntŭk neh i mham oh may hoch dja nơh. ");
INSERT INTO cmo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","May tay lơh mir jan sre, mâu ôh geh mâu ôh jêng ma may đŏng, may gŭ rêh n'glă n'glơt lam ntŭk dja ntŭk ri”. ");
INSERT INTO cmo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain ơh: “Ơ Kôranh Brah, dôih May tê̆ ma gâp dja jŏk ngăn, Kôranh Brah mê, gâp mâu ôh dơi dôr. ");
INSERT INTO cmo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lŏng nar dja May ntrŭt gâp du bơh ntŭk neh dja, du ngai bơh măt May đŏng, gâp gŭ rêh n'glă n'glơt lam ntŭk dja ntŭk ri, lah geh bu mâp, bu mra nkhât gâp ngăn ro”. ");
INSERT INTO cmo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Brah Yêhôva ơh: “Mâu ôh, lah bu nkhât may, Gâp mra plơng păng pơh tơ̆”. Jêh ri Brah Yêhôva pla kep du mlŏm ndơ ta kalơ Kain nây, gay ma lơi ôh ăn bu lơh nkhât păng. ");
INSERT INTO cmo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Jêh ri Kain du lôh bơh nây, păng du bơh măt Brah Yêhôva ngăn, gŭ ta ntŭk bri Nôt mpeh lôh nar ma ntŭk Êđen, ndri păng Kain i ri heh. ");
INSERT INTO cmo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Jêh ri Kain gŭ đah i ur păng ri, ur păng ntreo gŭ oh du huê kon bu klô, rnha Hênŏk. Jêh ri păng jan du mlŏm ƀon, păng kuăl ƀon i nây Hênŏk kơt rnha kon păng nơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Jêh ri Hênŏk geh kon bu klô rnha Irat, Irat bă Mhuiael, Mhuiael bă Matusael, Matusael bă Lamêk. ");
INSERT INTO cmo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamêk geh ur bar, ur tơm rnha Ađa, ur chông rnha Sila. ");
INSERT INTO cmo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ađa geh bar ơ̆ kon, i nô rnha Yapal, păng i bunuyh dak bôk gŭ ta chun, gŭ chiăp ta ntŭk dja ntŭk ri. ");
INSERT INTO cmo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","I oh Yapal, rnha Yupal, păng i bunuyh dak bôk nkrêh ndơ tâm ban ma gong rêng, ndrel ma ôh ndơ tâm ban ma rlet. ");
INSERT INTO cmo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Jêh ri Sila geh kon đŏng, rnha Tupal-kain, păng i bunuyh dak bôk blao drep chiăr kông, ndrel ma loyh. Oh bu ur Tupal-kain, rnha Naama. ");
INSERT INTO cmo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Jêh ri Lamêk lah ma lĕ bar hê i ur păng nây: “Hơi Ađa, Sila, khân ay iăt nau gâp hŏ! Hơi khân ay, rkêng hŏm tôr iăt nau gâp ngơi mbram ma gĭt! Gâp nkhât bunuyh du huê bu klô, yorlah păng nơh jan ăn gâp geh sôt Gâp nkhât du huê bu ndăm, yor ma păng lơh gâp bŭr. ");
INSERT INTO cmo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Lah bu nkhât du huê Kain, bu mra plơng nkhât pơh tơ̆ Yơn ma lah bu nkhât Lamêk, ăn plơng nkhât tât 77 tơ̆ ngăn ro”. ");
INSERT INTO cmo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ađăm hôm gŭ đah ur păng jât, jêh ri ur păng gŭ oh tay du huê kon bu klô, păng lah: “Kon dja Kôranh Brah ăn tay ma gâp, gay ma ntrŏ Abel i Kain de nkhât nơh” kơt ndri rnha păng «Sêt». ");
INSERT INTO cmo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Jêh ri Sêt bă du huê kon bu klô, păng rnha kon i nây Ênôs. Ntơm bơh nây bu kuăl Kôranh Brah: «Brah Yêhôva», nôk bu yơk mbah Păng. ");
INSERT INTO cmo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Dja nau mbơh nkoch rnoi deh Ađăm. Nôk Kôranh Brah njêng bunuyh nơh, Kôranh Brah njêng khân păng kơt Păng Nơm ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Kôranh Brah njêng khân păng geh bu klô bu ur, ta nar nây Kôranh Brah tê̆ rnha khân păng «Bunuyh», jêh ri ăn nau geh jêng ma khân păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Tât Ađăm geh 130 năm, păng bă du huê kon bu klô tâm ban ma păng nơm kơt păng nơm ngăn, jêh ri Ađăm tê̆ rnha păng «Sêt». ");
INSERT INTO cmo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Jêh păng bă Sêt nây, bơh kơi nây păng hôm rêh geh 800 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Păng rêh dâng lĕ geh 930 năm, jêh ri khât. ");
INSERT INTO cmo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tât Sêt geh 105 năm, păng bă Ênôs. ");
INSERT INTO cmo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Jêh păng bă Ênôs i nây, păng rêh geh 807 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Păng rêh dâng lĕ geh 912 năm, jêh ri khât. ");
INSERT INTO cmo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tât Ênôs geh 90 năm, păng bă Khênan. ");
INSERT INTO cmo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Jêh păng bă Khênan i nây, păng rêh geh 815 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Păng rêh dâng lĕ geh 905 năm, jêh ri khât. ");
INSERT INTO cmo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tât Khênan geh 70 năm, păng bă Mhalêlel. ");
INSERT INTO cmo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Jêh păng bă Mhalêlel i nây, păng rêh geh 840 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Păng rêh dâng lĕ geh 910 năm, jêh ri khât. ");
INSERT INTO cmo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tât Mhalêlel geh 65 năm, păng bă Yarêt. ");
INSERT INTO cmo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jêh păng bă Yarêt i nây, păng rêh geh 830 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Păng rêh dâng lĕ geh 895 năm, jêh ri khât. ");
INSERT INTO cmo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tât Yarêt geh 162 năm, păng bă Hênŏk. ");
INSERT INTO cmo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jêh păng bă Hênŏk i nây, păng rêh geh 800 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Păng rêh dâng lĕ geh 962 năm, jêh ri khât. ");
INSERT INTO cmo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tât Hênŏk geh 65 năm, păng bă Mâthusalah. ");
INSERT INTO cmo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Jêh păng bă Mâthusalah i nây, păng gŭ tâm dêh tâm dăch đah Kôranh Brah, ndrel ma iăt nau Păng đŏng geh 300 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Păng rêh dâng lĕ geh 365 năm. ");
INSERT INTO cmo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hênŏk gŭ tâm dêh tâm dăch iăt nau Kôranh Brah ngăn, jêh ri păng roh klŏk bơh neh ntu dja, yorlah Kôranh Brah sŏ gŭ ndrel Păng Nơm. ");
INSERT INTO cmo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tât Mâthusalah geh 187 năm, păng bă Lamêk. ");
INSERT INTO cmo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Jêh păng bă Lamêk i nây, păng rêh geh 782 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Păng rêh dâng lĕ geh 969 năm, jêh ri khât. ");
INSERT INTO cmo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tât Lamêk geh 182 năm, păng bă du huê kon bu klô ");
INSERT INTO cmo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","păng tê̆ rnha kon i nây «Nôê», păng lah: “Kon dja păng mra kơl bonh leng lĕ nau kar jêr hên, lĕ nau rơah hên jan mir, tă bơh Brah Yêhôva de rtăp neh i dja nơh”. ");
INSERT INTO cmo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Jêh păng bă Nôê i nây, păng rêh geh 595 năm jât, n'ho păng bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Păng rêh dâng lĕ geh 777 năm, jêh ri păng khât. ");
INSERT INTO cmo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Tât Nôê geh 500 năm, păng bă kon pe ơ̆, Sĭm, Hăm, ndrel ma Yaphet. ");
INSERT INTO cmo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Jêh ri bunuyh ta neh ntu lơ ma ŏk lơ ma ŏk ngăn, khân păng bă kon bu ur ");
INSERT INTO cmo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","jêh ri kon bu klô brah say kon bu ur bunuyh ueh ueh ngăn, khân păng leo băl sŏ ur, sŏ bu ma he ro. ");
INSERT INTO cmo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Jêh Brah Yêhôva say khân păng jan kơt nây, jêh ri păng ngơi êng săk Păng nơm: “Huêng Gâp mâu hôm ôh gŭ n'ho ro ta bunuyh, yorlah săk khân păng nơh mra khât, kơt nây dâng Gâp ăn khân păng rêh dŭt ta 120 năm dơm”. ");
INSERT INTO cmo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ta nôk nây nơh, geh bunuyh săk jăn kuŏng kuŏng ngăn ta neh ntu dja, tât a kơi nây hôm e geh đŏng. Khân păng i nây i kon tă bơh kon brah sŏ ur sai đah bu ur bunuyh nơh, khân păng nơh dăng dăng ngăn tâm lơh, kơt ndri dâng geh rnôk kăl e nơh bu lư khân păng hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Jêh ri Brah Yêhôva say nau tih bunuyh jan ta neh ntu dja hô ngăn, nuih n'hâm nau mân khân păng nơh ŭch jan ndơ dŭt djơh nâng ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Brah Yêhôva rngot ngăn ta nuih n'hâm, Păng nduih tôr lăn njêng bunuyh ta neh ntu dja nơh. ");
INSERT INTO cmo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Păng lah êng săk Păng Nơm: “Gâp mra lơh hêng lơi bunuyh i Gâp njêng ăn lĕ bơh neh ntu dja ƀŏt, ntơm bơh bunuyh tât ma mpômpa (siŭm) ta bri ta ƀon, siŭm mpăr ta kalơ trôk, ndrel ma ăp ntil mpômpa (siŭm) hung vơr ta neh ntu dja, yorlah Gâp nhhuach lăn njêng păng nơh”. ");
INSERT INTO cmo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Yơn ma geh du huê bu klô rnha păng Nôê, Brah Yêhôva di nuih n'hâm ma păng. ");
INSERT INTO cmo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dja nkoch nau rêh jêng Nôê. Ta rnôk Nôê nây nơh, geh du huê păng dơm bunuyh ueh bunuyh sŏng, mâu ôh say geh dôih ta păng. Păng iăt nau Kôranh Brah ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nôê bă kon bu klô pe ơ̆, rnha khân păng Sĭm, Hăm, ndrel ma Yaphet. ");
INSERT INTO cmo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Nôk nây bunuyh ta neh ntu dja djơh mhĭk dadê ngăn ta năp măt Kôranh Brah, khân păng jan djơh ŏk ntil ngăn, hăt janh tâm lơh tâm nkhât hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kôranh Brah say neh ntu djơh lĕ phiao, yorlah bunuyh dâng lĕ ta neh ntu dja nơh, khân păng jan djơh mhĭk dadê ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Jêh ri Kôranh Brah lah ma Nôê: “Hơi Nôê, Gâp lĕ ŭch nkhât lơi dâng lĕ ndơ i geh nau rêh ta neh ntu dja mê̆, yorlah bunuyh lam neh ntu dja, khân păng jan djơh ŏk ntil ngăn, hăt janh tâm lơh tâm nkhât hô ngăn. Ô, Gâp mra lơh lơi khân păng ăn hêng lĕ phiao, ndrel ma lĕ ndơ ta neh ntu dja ro”. ");
INSERT INTO cmo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“Aƀaơ ri Gâp đă may jan du mlŏm duk ăn dŭt kuŏng, jan ma tơm si i ueh, jêh ri sŏ ntăk chai lâr bơh dih bơh trôm duk i nây ăn jâr, ndrel ma jan jrô ăn ŏk ta trôm duk nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ăn may jan kơt nđa: Jong ăn geh 300 hăt, huy 50 hăt, i prêh 30 hăt. ");
INSERT INTO cmo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Jêh ri jan chor bơh lơ duk nây, prêh du hăt. Rong jan mpông ăn bơh mpŭng, jêh ri jan duk i nây ăn geh tâm rdăp, du dăp bơh dŏng, du dăp ta nklang, du dăp bơh lơ. ");
INSERT INTO cmo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Jêh ri Gâp mra ăn geh dak lêng dak dơng lam neh ntu dja, ăn dak bŭk lĕ rngôch ndơ i geh nau rêh i geh n'hâm ta bơh dŏng trôk dja. Lĕ ndơ geh ta neh ntu dja mra khât lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Yơn ma Gâp hôm tâm rnglăp ma may nanao, may mra lăp ta trôm duk nây, ndrel ur may kon may măn may. ");
INSERT INTO cmo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Jêh ri ăn may sŏ leo mpômpa (siŭm) bar bar dâng lĕ ntil mpômpa (siŭm), ăn may sŏ me nguai nkuŏng nguai ăn lăp ta trôm duk nây dadê, gay ma geh klaih nau rêh ndrel may đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Păng mra ran văch ta may bar bar ro, dâng lĕ ntil mpômpa (siŭm) tâng ntil êng êng, siŭm mpăr ta kalơ trôk, mpômpa (siŭm) ta bri ta ƀon, ndrel ma ăp ntil mpômpa (siŭm) hung vơr ta neh ntu dja, gay ma geh klaih nau rêh. ");
INSERT INTO cmo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Jêh ri sŏ ndjôt lĕ ndơ i may vay sông sa prăp ăn ma may nơm, ndrel ma mpa, ma ăn mpômpa (siŭm) dâng lĕ i nây đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nôê jan kơt nây ngăn ro, păng jan jêh lĕ phiao tâng nau Kôranh Brah đă ma păng nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Jêh ri Brah Yêhôva lah ma Nôê: “Hơi Nôê, leo rnăk vâl may, lăp gŭ ta trôm duk kuŏng i nây ndrel may nơm, yorlah dâng lĕ rngôch bunuyh ta neh ntu dja, Gâp say du huê may dơm bunuyh ueh bunuyh sŏng. ");
INSERT INTO cmo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Jêh ri ăn may sŏ leo mpômpa (siŭm) i kơp kloh jêng mpômpa (siŭm) i khân may dơi nhhơr ma Gâp, me pơh ơ̆ nkuŏng pơh ơ̆, mpômpa (siŭm) i kơp mâu kloh may sŏ leo me nguai nkuŏng nguai hŏ ");
INSERT INTO cmo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","may leo đŏng siŭm mpăr kalơ trôk me pơh ơ̆ nkuŏng pơh ơ̆, dâng lĕ ăp ntil i nây, gay ma rong ntil ta neh ntu dja. ");
INSERT INTO cmo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Yorlah hôm pơh nar jât Gâp ăn geh mih ta neh ntu dja puăn jât năng puăn jât nar, gay ma lơh hêng lơi ăn lĕ rngôch ndơ i geh nau rêh i Gâp lĕ njêng, ăn lĕ bơh neh ntu dja ro”. ");
INSERT INTO cmo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nôê jan jêh lĕ phiao tâng nau Brah Yêhôva đă ma păng nơh. ");
INSERT INTO cmo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nôk geh dak lêng dak dơng i nây ta neh ntu, Nôê lĕ geh 600 năm jêh. ");
INSERT INTO cmo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Păng lăp gŭ ta trôm duk kuŏng i ri, ur păng, kon păng, ndrel ma măn păng đŏng, gay ma klaih bơh dak lêng dak dơng i nây. ");
INSERT INTO cmo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Geh mpômpa (siŭm) i kơp kloh, mpômpa (siŭm) i kơp mâu kloh, siŭm mpăr kalơ trôk, ndrel ma ăp ntil mpômpa (siŭm) i hung vơr ta neh ntu dja đŏng ");
INSERT INTO cmo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","brô̆ ma bar ma bar ngăn ro bơh ri tât ta ntŭk Nôê nây, geh me geh nkuŏng lăp ta trôm duk ri, tâng kơt nau Kôranh Brah đă ma păng nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tât pơh nar bơh kơi nây, dak lêng dak dơng ntơm rlap lam neh ntu dja. ");
INSERT INTO cmo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ta năm Nôê i geh 600 năm, khay bar nar 17 ta nar i nây ro dâng lĕ tu dak ntơm lôh rdôl tă bơh dŏng ri dadê, jêh ri ta kalơ trôk geh mih ntŏng ngăn, tâm ban ma pơk mpông bloh. ");
INSERT INTO cmo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mih nkhŭt ta neh ntu dja 40 năng 40 nar ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Nar i nây đŏng Nôê, ndrel ma kon bu klô păng, Sĭm, Hăm, Yaphet, ur păng, jêh ri măn păng pe nuyh lăp gŭ ta trôm duk ri dadê ");
INSERT INTO cmo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ndrel ma lĕ ăp ntil mpômpa (siŭm) ta bri ta ƀon, mpômpa (siŭm) hung vơr ta neh ntu dja, siŭm mpăr ta kalơ trôk, lĕ ndơ i geh nar, lăp dadê đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Dâng lĕ ndơ i geh nau rêh nây nơh păng brô̆ bơh ri ma bar ma bar ro, gŭ ndrel Nôê ta trôm duk ri. ");
INSERT INTO cmo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ăp ntil ndơ i geh nau rêh, geh me, geh nkuŏng, păng lăp gŭ ta trôm duk ri dadê, tâng kơt nau Kôranh Brah đă ma Nôê nơh, jêh ri Brah Yêhôva nơm ntâl mpông duk i nây ro. ");
INSERT INTO cmo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Jêh ri mih geh 40 năng 40 nar. Dak lêng dak dơng rlap lam neh ntu dja hao têh ngăn, tât ma duk i nây n'hông mpưp bơh lơ neh ri. ");
INSERT INTO cmo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Dak lêng dak dơng i ri lơ ma hao têh lơ ma kuŏng lơ ma jru ngăn, duk i ri n'hông bơh lơ dak ri. ");
INSERT INTO cmo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Hao têh dak lơ ma kuŏng lơ ma kuŏng ta kalơ neh ntu dja, tât ma bŭk ndŏp lĕ phiao yôk i prêh prêh dâng lĕ bơh dŏng trôk dja. ");
INSERT INTO cmo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Dak hao têh tât ma băm rlao bơh lơ yôk i nây 15 hăt jât. ");
INSERT INTO cmo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Jêh ri lĕ rngôch ndơ i geh nau rêh ta neh ntu dja, dâng siŭm mpăr kalơ trôk, dâng mpômpa (siŭm) ta ƀon ta bri, lĕ rngôch mpômpa (siŭm) hung vơr lam neh ntu dja, ndrel ma lĕ rngôch bunuyh khât lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Lĕ ndơ i blao n'hao n'hâm, i gŭ rêh ta kalơ neh ntu dja khât dadê. ");
INSERT INTO cmo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Brah Yêhôva lơh hêng lơi lĕ ndơ i geh nau rêh bơh neh ntu dja, ntơm bơh bunuyh tât ma mpômpa (siŭm) ta bri ta ƀon, mpômpa (siŭm) hung vơr, tât ma siŭm mpăr kalơ trôk ăn roh lĕ phiao, hôm e Nôê, ndrel ma bu moh i gŭ ta trôm duk ndrel păng, dah ri dơm. ");
INSERT INTO cmo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Jêh ri dak lêng dak dơng kuŏng ta neh ntu dja geh 150 nar. ");
INSERT INTO cmo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Jêh ri Kôranh Brah hôm kah gĭt ma Nôê, ndrel ma lĕ mpômpa (siŭm) i gŭ ta trôm duk ndrel păng nây, kơt ndri Kôranh Brah ăn geh sial khôm ta neh ntu dja, jêh ri dak ntơm djoh djhŭp. ");
INSERT INTO cmo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Dâng lĕ tu dak i lôh rdôl tă bơh ntŭk jru ri, ndrel ma i kơt mpông bloh kalơ trôk rdŏl ăn jâr, mih bah đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Dak ta neh ntu dja ntơm djoh du tơ̆ đê̆ du tơ̆ đê̆, tât 150 nar păng ntơm djoh. ");
INSERT INTO cmo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ta nar 17 khay pơh duk i nây khan ta kalơ yôk Ararat. ");
INSERT INTO cmo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Dak hôm djoh đê̆ djoh đê̆ tât khay jât, ta nar nguai khay jât i nây, nar nây Nôê ntơm mpơl say yôk. ");
INSERT INTO cmo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Jŏ 40 nar bơh kơi nây, Nôê pơ̆ mpông bloh duk i păng jan nơh ");
INSERT INTO cmo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ƀơk du mlŏm nđak. Nđak i nây mpăr năp mpăr kơi n'ho ma tât suăt dak. ");
INSERT INTO cmo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Jêh ri păng ƀơk đŏng du mlŏm plŭk, gay ma gĭt lah dak lĕ suăt mâu lah ê hŏ. ");
INSERT INTO cmo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Plŭk i nây mpăr joi ntŭk ma drŏm mâu geh ôh, yorlah dak hôm lam neh ntu dja, jêh ri plơ̆ tay a Nôê dja, păng nta ti nhŭp plŭk i nây nglăp tay ta trôm duk ndrel păng nơm jât. ");
INSERT INTO cmo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nôê kŏp tât pơh nar jât, jêh ri păng ƀơk tay plŭk i nây du tơ̆ jât lôh bơh trôm duk nây. ");
INSERT INTO cmo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tât kêng măng plŭk i nây plơ̆ a păng nơm dja, yi, nkre ma gleng nkŭr tơm si Ôlive đŏng. Kơt ndri dâng Nôê gĭt lah dak lĕ suăt jêh. ");
INSERT INTO cmo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Păng kŏp hôm pơh nar jât, jêh ri păng ƀơk tay plŭk i nây, tih ma mâu hôm ôh say plŭk plơ̆ a păng. ");
INSERT INTO cmo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nôk Nôê geh 601 năm, nar nguai khay nguai, năm i nây dak suăt lĕ phiao bơh neh ntu dja. Jêh ri Nôê plôk chor duk, lŏng păng say mpơl neh dadê. ");
INSERT INTO cmo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ta nar 27 khay bar, nar i nây neh sơh lĕ phiao ta kalơ neh ntu dja. ");
INSERT INTO cmo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Nôk nây Kôranh Brah ngơi ma Nôê: ");
INSERT INTO cmo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Hơi Nôê, may lôh bơh duk nây hŏm, ur may, kon may, ndrel ma măn may. ");
INSERT INTO cmo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Jêh ri may nglôh ăp ntil mpômpa (siŭm) i gŭ ndrel may nơm ta trôm duk nây đŏng, dâng siŭm mpăr kalơ trôk, dâng lĕ mpômpa (siŭm) ta bri ta ƀon, mpômpa (siŭm) hung vơr ta neh ntu, lôh a dih to, ăn ma geh oh geh kon bâk rơ̆ lam neh ntu dja”. ");
INSERT INTO cmo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Jêh ri Nôê, ur păng, kon păng, ndrel ma măn păng lôh a dih dja dadê ");
INSERT INTO cmo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ndrel ma lĕ mpômpa (siŭm) ta bri ta ƀon, siŭm mpăr kalơ trôk, mpômpa (siŭm) hung vơr ta neh, lôh bơh duk ri dadê tâng ntil păng nơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Jêh ri Nôê sŏ lŭ tâm rdăp, gay ma jan ntŭk jan brah ma Brah Yêhôva. Păng sŏ ƀă mpômpa (siŭm) ƀon ăp ntil i kơp kloh, sŏ ƀă siŭm mpăr ăp ntil i kơp kloh, păng nhhơr ndơ i nây, gŭch pur mlŏm ta kalơ ntŭk jan brah ri. ");
INSERT INTO cmo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Jêh ri Brah Yêhôva răm ngăn ta nuih n'hâm geh ƀô i nây, Păng mân êng Păng Nơm: “Gâp mâu hôm ôh rtăp neh ntu yor ma ndơ kon bunuyh jât, bol lah nau mân bunuyh djơh lĕ ơm bơh jê̆, Gâp mâu hôm ôh lơh hêng jât dâng lĕ ndơ i geh nau rêh kơt Gâp mhe lơh nơh. ");
INSERT INTO cmo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Dôl neh ntu hôm geh Khay tuch khay tăm, khay kăch khay roih, khay mih khay vai Geh dôh geh nđik, geh nar geh măng Păng hôm geh nâng dơm, mâu ôh blao roh”. ");
INSERT INTO cmo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Jêh ri Kôranh Brah ăn nau geh jêng ma Nôê, ndrel ma pe nuyh kon bu klô păng, Kôranh Brah lah: “Ăn bă oh rong kon bâk rơ̆ lam neh ntu dja! ");
INSERT INTO cmo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Gâp ăn khân may jan kôranh ma dâng lĕ ntil mpômpa (siŭm), dâng lĕ siŭm mpăr kalơ trôk, dâng lĕ mpômpa (siŭm) hung vơr ta neh, ndrel ma dâng lĕ ntil kât ka ta trôm dak văch dak văr, ntơm bơh aƀaơ ri dâng lĕ mpômpa (siŭm) i nây klach nsŏr khân may dadê. ");
INSERT INTO cmo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Dâng lĕ mpômpa (siŭm) i geh nau rêh ta neh ntu dja, ăn ma khân mre sŏ jan trao dadê, Gâp ăn dâng lĕ ndơ dja ma khân may kơt Gâp ăn trao ƀăng ma khân may nơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tih ma buay sa puăch i hôm geh mham ta trôm săk, yorlah ta mham jêng nau rêh păng. ");
INSERT INTO cmo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Moh ndơ i nkhât bunuyh, Gâp đă nkhât lơi ndơ i nây, kơt Gâp đă bunuyh i nkhât bunuyh ăn tŏm khât săk tâm ban kơt i nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Bu moh păng i nchai mham bunuyh Bu mra nchai mham nơm i nây mâu klaih ro Yorlah Gâp njêng bunuyh nơh kơt Gâp Nơm ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Aƀaơ dja Gâp ăn khân may geh kon geh sau bâk rơ̆ lam neh ntu dja”. ");
INSERT INTO cmo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kôranh Brah ngơi jât ma Nôê, ndrel ma lĕ kon păng: ");
INSERT INTO cmo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Iăt yơ̆, aƀaơ dja Gâp Nơm tâm rnglăp ndrel khân may, n'ho ro tât kon tât sau khân may a kơi tay ");
INSERT INTO cmo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ndrel ma mpômpa (siŭm) dâng lĕ i geh nau rêh gŭ ndrel khân may nơh, siŭm mpăr kalơ trôk, mpômpa (siŭm) ta bri ta ƀon, dâng lĕ mpômpa (siŭm) hôm geh ta neh ntu ndrel khân may dja, ngơi du tong lah dâng lĕ mpômpa (siŭm) i lôh tă bơh duk kuŏng i nây. ");
INSERT INTO cmo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Gâp tâm rnglăp ndrel khân may, ndơ geh nau rêh ta neh ntu dja mâu hôm ôh geh khât roh hêng lĕ yor ma dak lêng dak dơng bŭk jât, mâu hôm geh dak lêng dak dơng ma bŭk lĕ neh ntu đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Kôranh Brah lah jât: “Gâp ăn ndơ mbên ma khân may gĭt năl nau tâm rnglăp Gâp ndrel khân may, ndrel ma dâng lĕ rngôch ndơ i geh nau rêh gŭ ndrel khân may, nau tâm rnglăp dja n'ho ro ăp rnôk. ");
INSERT INTO cmo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Gâp ăn geh bêh chŭng tâng Gâp ta kalơ trôk, gay ma say ndơ mbên ăn gĭt năl nau tâm rnglăp Gâp ndrel ma neh ntu. ");
INSERT INTO cmo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Lah Gâp ăn geh tŭk ta kalơ trôk dja, jêh ri bêh chŭng tâng lôh ta kalơ trôk nây, ");
INSERT INTO cmo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ta nây Gâp kah gĭt nau tâm rnglăp Gâp ndrel khân may, ndrel ma lĕ rngôch ndơ geh nau rêh ta neh ntu dja đŏng. Jêh ri mâu hôm ôh geh dak lêng dak dơng bŭk khât roh hêng lĕ rngôch ndơ jât. ");
INSERT INTO cmo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Lah bêh chŭng tâng gŭ ta kalơ trôk, Gâp uănh păng, kah gĭt nau tâm rnglăp Gâp hôm n'ho ro, ndrel ma lĕ rngôch ndơ i hôm rêh ta neh ntu dja”. ");
INSERT INTO cmo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kôranh Brah lah tay ma Nôê: “Bêh chŭng tâng i nây ndơ mbên ăn gĭt năl nau tâm rnglăp Gâp ndrel ma dâng lĕ ndơ geh nau rêh ta neh ntu dja”. ");
INSERT INTO cmo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Kon bu klô Nôê i lôh tă bơh trôm duk nây, rnha khân păng Sĭm, Hăm, jêh ri Yaphet. Hăm i nây i bơ̆ Kanan. ");
INSERT INTO cmo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Pe nuyh khân păng i nây i kon Nôê, lĕ bunuyh lam neh ntu dja tă bơh khân păng i nây. ");
INSERT INTO cmo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Jêh dak lêng dak dơng nây, Nôê bunuyh jan mir, păng bunuyh lor bu băl ngăn tăm tơm play yŭng yar ƀon ma jan ndrănh. ");
INSERT INTO cmo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Geh du nar ri păng nhêt ndrănh play yŭng yar ƀon i nây tât nhŭl, n'ho ma bêch lahôk lahak ta chun păng nơm ri. ");
INSERT INTO cmo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Jêh ri Hăm i bơ̆ Kanan ri nơh say bơ̆ păng bêch lahôk lahak ta chun kơt ndri, păng lôh bơh nây hăn mbơh i oh nô păng ri. ");
INSERT INTO cmo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Jêh ri i oh nô ri sŏ du blah bok mƀăk ta mlik khân păng nơm, jêh ri brô̆ nkơi nkơi nkŭm bok i nây bơh lơ i bơ̆ ri. Bar hê khân păng i nây mâu ôh rle măt jât i bơ̆ ri, kơt ndri dâng khân păng mâu say i bơ̆ lahôk. ");
INSERT INTO cmo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Tât i bơ̆ lĕ ayh, păng gĭt nau kon i jê̆ jan ma păng nơh ");
INSERT INTO cmo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","jêh ri păng lah: “Kanan lĕ geh nau rtăp jêh! Ăn păng gŭ jan dâk ta nâm bu ma i oh nô păng nơm”. ");
INSERT INTO cmo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Păng lah jât: “Rnê ma Brah Yêhôva i brah Sĭm Jêh ri ăn Kanan i nây ma gŭ jan dâk păng ");
INSERT INTO cmo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Dăn Kôranh Brah ăn neh huy ma Yaphet Jêh ri rom păng gŭ ndrel Sĭm nơm I Kanan ri ăn jan dâk Yaphet nây”. ");
INSERT INTO cmo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Jêh dak lêng dak dơng nây, Nôê gŭ rêh geh 350 năm jât. ");
INSERT INTO cmo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nôê rêh dâng lĕ rngôch geh 950 năm, jêh ri păng khât. ");
INSERT INTO cmo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dja nau nkoch rnoi deh Sĭm, Hăm, ndrel ma Yaphet i kon Nôê nây nơh. Jêh dak lêng dak dơng i nây, khân păng pe nuyh i nây bă oh bă kon kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","I kon bu klô Yaphet, khân păng geh rnha Kômơr, Makŭk, Mađai, Yavan, Tupal, Mêsêk, ndrel ma Tirah . Dâng lĕ i kon sau bơh kơi bơh kơi, khân păng sŏ dâng lĕ rnha i nây ma jêng rnha mpôl khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Jêh ri i kon bu klô Kômơr, khân păng geh rnha Ahkênah, Riphat, ndrel ma Tukarma. ");
INSERT INTO cmo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","I kon bu klô Yavan jât, khân păng geh rnha Êlisa, Tasơs, Kitim, ndrel ma Đôđanim. ");
INSERT INTO cmo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Khân păng i nây i u che mpôl bunuyh êng êng gŭ rŏ dak văch dak văr. Khân păng nchah mpôl êng êng, tâng rnăk vâl, tâng nau ngơi, tâng dak khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","I kon bu klô Hăm jât, khân păng geh rnha Kuh, Êsip, Put, ndrel ma Kanan. Dâng lĕ i kon sau bơh kơi bơh kơi, khân păng sŏ dâng lĕ rnha i nây ma jêng rnha mpôl khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","I kon bu klô Kuh, khân păng geh rnha Chêpa, Havila, Sapta, Rama, ndrel ma Saptĭka. I kon bu klô Rama, păng geh rnha Sêƀa, ndrel ma Đêđan. ");
INSERT INTO cmo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Jêh ri Kuh bă du huê kon jât geh rnha Nĭmrôt, păng i nây i bunuyh lor bu băl jêng kôranh mât uănh dăng ngăn ta neh ntu dja. ");
INSERT INTO cmo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Păng jêng bunuyh bren dŭt ueh đŏng ta năp măt Brah Yêhôva, ndri dâng bu vay lah: «May bren dŭt ueh tâm ban ma Nĭmrôt ta năp măt Brah Yêhôva». ");
INSERT INTO cmo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ntơm nơh păng gŭ mât uănh ta ƀon Ƀapil, ƀon Êrêk, ƀon Akat, ndrel ma ƀon Kălnê, ta bri Sinơr. ");
INSERT INTO cmo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Jêh bơh nây păng lôh hăn jât bri Asơr, tât ta bri Asơr ri păng jan ƀon Ninivê, ƀon Rêhupŭt, ƀon Kalah ");
INSERT INTO cmo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ndrel ma ƀon Rêsen, ƀon i nây kuŏng ngăn vah vang ƀon Ninivê ma ƀon Kalah. ");
INSERT INTO cmo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","I kon sau Êsip i ri jât jêng mpôl Luđim, mpôl Anamim, mpôl Lêhapim, mpôl Năpthuhim ");
INSERT INTO cmo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","mpôl Patrusim, mpôl Kahluhim, ndrel ma mpôl Kăpthorim, mpôl Kahluhim i nây jêng phung u che mpôl Phalihtin. ");
INSERT INTO cmo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Jêh ri i Kanan i ri bă Siđôn kon dak bôk, jêh ri bă Hêt ");
INSERT INTO cmo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ndrel ma mpôl Yêpusit, mpôl Amôri, mpôl Girkasit ");
INSERT INTO cmo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","mpôl Hivi, mpôl Ărkit, mpôl Sinit ");
INSERT INTO cmo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","mpôl Arvatit, mpôl Sêmarit, ndrel ma mpôl Hamathit. Jêh ri mpôl Kanan hăn gŭ ntŭk êng êng băl. ");
INSERT INTO cmo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Bri dak khân păng, ntơm bơh ƀon Siđôn tât ma ƀon Kêrar i dăch ƀon Kasa, n'ho ma tât ƀon Sôđŭm, ƀon Kômôra, ƀon Atma, ndrel ma ƀon Sêpoyim, jêh ri n'ho ma tât a ƀon Lasa ri. ");
INSERT INTO cmo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ndri rnoi deh Hăm, păng gŭ tâng rnăk vâl, tâng nau ngơi, tâng bri, tâng dak khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Jêh ri Sĭm i nô Yaphet ri păng bă oh bă kon đŏng. Păng i nây i u che mpôl Êƀer. ");
INSERT INTO cmo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Kon păng geh rnha Êlam, Ahsơr, Arpasat, Lut, jêh ri Aram. ");
INSERT INTO cmo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram bă Uh, bă Hul, bă Kêthơr, ndrel ma bă Mah. ");
INSERT INTO cmo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpasat bă Sêlas, Sêlas bă Êƀer. ");
INSERT INTO cmo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Êƀer bă kon bu klô bar hê, i nô rnha Phêlêk, rnha i nây rblang lah «Chah chrai băl», yorlah nôk nây bunuyh ta neh ntu dja gŭ chah chrai băl. I oh păng rnha Yŭkthan. ");
INSERT INTO cmo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yŭkthan bă Ălmôđat, bă Sêlêp, bă Hasarmavêt, bă Yêrah ");
INSERT INTO cmo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","bă Hađôram, bă Usal, bă Đĭkla ");
INSERT INTO cmo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","bă Ôpal, bă Apimael, bă Sêƀa ");
INSERT INTO cmo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","bă Ôphir, bă Havila, ndrel ma bă Yôƀap. Dâng lĕ khân păng i nây kon Yŭkthan dadê. ");
INSERT INTO cmo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Bri dak khân păng gŭ rêh ntơm bơh bri Mêsa n'ho ma tât ntŭk yôk bri Sêphar i mpeh ma lôh nar nây. ");
INSERT INTO cmo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","I nây rnoi deh Sĭm, păng gŭ tâng rnăk vâl, tâng nau ngơi, tâng bri, tâng dak khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Lĕ i nây nơh rnoi deh i kon Nôê pe nuyh, tâng rnoi deh tâng bri khân păng nơm. Jêh dak lêng dak dơng nây nơh, khân păng chah chrai kơt nây, dâng geh ma jêng lĕ bri dak êng êng ta neh ntu dja. ");
INSERT INTO cmo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nôk kăl e nơh dâng lĕ bunuyh ta neh ntu dja du nau ngơi dơm, mbơh ngơi tâm ban băl. ");
INSERT INTO cmo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Jêh ri khân păng ntrơn ntŭk bơh lôh nar, tât ta ntŭk lŏng ta bri Sinơr, khân păng gŭ jan ƀon ta nây. ");
INSERT INTO cmo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Khân păng tâm lah ndrăng khân păng nơm: “Hô̆ bân, leo băl mon neh gŭch, ăn păng ma kroh ăn dăng”. Jêh ri khân păng sŏ neh i gŭch nây ma jan jay, sŏ chai krăk ma jan ndơ lâr ma krêp. ");
INSERT INTO cmo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Jêh ri khân păng lah: “Ăn bân jan du ƀon kuŏng, jêh ri jan du mlŏm jay ăn dŭt prêh ƀlưu tât a trôk ngăn, ăn bu lư bân, ri mơ bân mâu ôh chah chrai lam neh ntu dja”. ");
INSERT INTO cmo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Jêh khân păng jan jay dŭt prêh i nây, Brah Yêhôva jŭr uănh ƀon, ndrel ma jay prêh i bunuyh jan i nây ");
INSERT INTO cmo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","jêh ri Brah Yêhôva lah êng Păng Nơm: “Yi! Khân păng dja jêng du mpôl dơm, mbơh ngơi du nau ngơi dơm đŏng, lah blao jan dja aƀaơ ri, ta jât năp tay khân păng dơi jan đŏng moh ndơ i khân păng ŭch. ");
INSERT INTO cmo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Lah ndri Bân jŭr jan vĭ lơi nau ngơi khân păng ƀŏt, lơi hôm ôh ăn khân păng tâm gĭt ngơi jât năp tay”. ");
INSERT INTO cmo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Jêh ri Brah Yêhôva ăn khân păng chah chrai băl du ngai tă bơh ntŭk i nây, dâng geh lam neh ntu dja, ndri khân păng bah jan ƀon ta ntŭk i nây jât. ");
INSERT INTO cmo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kơt ndri dâng bu tê̆ rnha ƀon i nây lah, Ƀapil, rblang lah «Vĭ», yorlah ta ntŭk i nây i Brah Yêhôva jan vĭ nau ngơi ăn bunuyh dâng lĕ ta neh ntu dja ngơi tâm tih băl, ăn bunuyh chah chrai băl tă bơh ntŭk nây dâng geh lam neh ntu dja. ");
INSERT INTO cmo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dja nau nkoch rnoi deh Sĭm. Tât Sĭm geh 100 năm păng bă Arpasat, năm i nây lĕ geh bar năm, jêh dak lêng dak dơng kuŏng i nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Jêh păng bă Arpasat ri, păng rêh geh 500 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Tât Arpasat geh 35 năm, păng bă Sêlas. ");
INSERT INTO cmo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Jêh păng bă Sêlas, păng rêh geh 403 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Tât Sêlas geh 30 năm, păng bă Êƀer. ");
INSERT INTO cmo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Jêh păng bă Êƀer ri, păng rêh geh 403 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Tât Êƀer geh 34 năm, păng bă Phêlêk. ");
INSERT INTO cmo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Jêh păng bă Phêlêk ri, păng rêh geh 430 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Tât Phêlêk geh 30 năm, păng bă Rêu. ");
INSERT INTO cmo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Jêh păng bă Rêu ri, păng rêh geh 209 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Tât Rêu geh 32 năm, păng bă Sêruk. ");
INSERT INTO cmo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Jêh păng bă Sêruk ri, păng rêh geh 207 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Tât Sêruk geh 30 năm, păng bă Nahôr. ");
INSERT INTO cmo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Jêh păng bă Nahôr ri, păng rêh geh 200 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Tât Nahôr geh 29 năm, păng bă Thêra. ");
INSERT INTO cmo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Jêh păng bă Thêra ri, păng rêh geh 119 năm jât, n'ho bă oh bă kon, geh kon bu ur kon bu klô đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tât Thêra geh 70 năm, păng bă Ăbram, bă Nahôr, ndrel ma bă Haran. ");
INSERT INTO cmo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Dja jêng nau nkoch rnoi deh Thêra. Thêra bă Ăbram, bă Nahôr, ndrel ma bă Haran. Jêh ri Haran bă Lŭt. ");
INSERT INTO cmo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran khât ta ƀon Ur ta bri Khalđê, ntŭk bri păng nơm, dôl i bơ̆ păng Thêra hôm rêh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ăbram, ndrel ma Nahôr i oh păng ri, khân păng sŏ ur. I ur Ăbram rnha Sarai, i ur Nahôr ri rnha Milka i kon Haran, Haran i ri i bơ̆ kon bu ur Milka, ndrel ma Ihka. ");
INSERT INTO cmo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Lŏng Sarai i ur Ăbram nây, jêng bu ur mâu ôh bă kon, păng mâu geh kon vă. ");
INSERT INTO cmo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Jêh ri Thêra leo Ăbram i kon păng nơm ri, ndrel ma i sau Lŭt păng ri, i kon Haran ri nơh, jêh ri Sarai i măn păng nơm ri đŏng, khân păng lôh tă bơh ƀon Ur bri Khalđê nây, hăn jât bri Kanan. Tât ta ƀon Charan ri, khân păng jan ntŭk ma gŭ ta ƀon nây, ê ôh tât ta bri Kanan. ");
INSERT INTO cmo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Thêra rêh geh 205 năm, jêh ri khât, păng khât ta ƀon Charan nây. ");
INSERT INTO cmo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Jêh ri Brah Yêhôva lah ma Ăbram kơt nđa: “May du lôh hŏm bơh bri may nơm, bơh ndŭl mpôl may nơm, ndrel ma bơh rnăk vâl bơ̆ may nơm, jêh ri hăn gŭ ta bri Gâp nhhơ ma may nây. ");
INSERT INTO cmo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Gâp ăn may geh rnoi deh ŏk, ăn khân păng jêng du phung dŭt kuŏng, Gâp ăn may geh jêng, ndrel ma ăn bu lư săk may, kơt ndri dâng may jêng bunuyh ăn geh jêng ma bu đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Gâp ăn geh jêng ma bu moh i ăn geh jêng ma may, Gâp rtăp đŏng ma bu moh i rtăp may, dâng lĕ rnăk vâl bunuyh ta neh ntu dja, geh jêng tă bơh may dadê”. ");
INSERT INTO cmo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Jêh Brah Yêhôva đă Ăbram kơt nây, păng jan tâng ro, păng du lôh bơh ƀon Charan, jêh ri i mon păng Lŭt hăn ndrel đŏng. Dôl Ăbram du lôh bơh ntŭk nây, păng lĕ geh 75 năm. ");
INSERT INTO cmo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Păng, i ur Sarai păng, i mon Lŭt păng, ndrel ma lĕ drăp ndơ păng geh, nđâp ma phung bunuyh i ntơm jan kar ma păng ta ƀon Charan nây nơh, păng ndjôt hăn jât bri Kanan ri dadê. Lĕ tât ta bri Kanan ri ");
INSERT INTO cmo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ăbram hăn glăt rŏ bri nây tât ta tơm jri i bu rnha Môrê, dăch ma ƀon Sikem. Dôl nây phung Kanan gŭ ta bri dak nây. ");
INSERT INTO cmo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Jêh ri Brah Yêhôva tâm mpơl ăn ma Ăbram say, Păng lah: “Gâp ăn bri dak dja ma phung rnoi deh may”. Jêh ri Ăbram jan du ntŭk ma jan brah ta ntŭk nây gay ma nhhơr ma Brah Yêhôva i lĕ tâm mpơl ăn păng say ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Jêh ri păng hăn jât, hăn ta ntŭk yôk mpeh bơh lôh nar ƀon Ƀêtel, păng jan chun gŭ ta ntŭk nây, păng gŭ vah vang ƀon Ƀêtel, đah ma ƀon Ai, geh mpeh bơh lôh nar ma ƀon Ƀêtel. Geh mpeh bơh nhŏp nar ma ƀon Ai, ta ntŭk nây păng jan du ntŭk jât ma jan brah ma Brah Yêhôva, jêh ri păng yơk mbah ma Brah Yêhôva . ");
INSERT INTO cmo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Jêh ri păng hăn ngăn, tât ta bri Nêkĭp. ");
INSERT INTO cmo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nôk nây ta bri Kanan geh nau ji sŏt ji ngot, yor ri Ăbram hăn gŭ ta bri Êsip, yorlah nau ji sŏt ji ngot ta bri Kanan nây hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Dôl păng hăn bơi tât ta bri Êsip, păng lah ma ur păng: “Gâp gĭt ay dja jêng bu ur ueh reh ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tât phung Êsip say ay, bu lah ay jêng ur gâp, lah ndri bu mra nkhât lơi gâp, hôm rong ay rêh. ");
INSERT INTO cmo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Lah ndri ăn ay mbơh ma bu lah, ay jêng oh gâp, gay ma bu jan ueh ma gâp yor tă bơh ay, jêh ri bu rong gâp rêh yor tă bơh ay đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Tât ta bri Êsip ri, phung Êsip say ur Ăbram ueh reh ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Phung kôranh kađăch Pharaon nơm say păng đŏng, khân păng rnê ueh Sarai ri mbơh ma Pharaon, jêh ri bu leo păng njŭn ta nhih kađăch Pharaon ri. ");
INSERT INTO cmo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Lŏng i Ăbram ri, Pharaon jan ueh ma păng ngăn yor tă ma ur Sarai păng ri, Pharaon ăn dâk bu ur dâk bu klô ma păng, ăn be biăp, ăn ndrôk nkuŏng, ăn seh lia me đŏng, seh lia nkuŏng đŏng, ndrel ma ăn seh samô. ");
INSERT INTO cmo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Yơn ma Brah Yêhôva jan ăn nau ji kuŏng ngăn ma Pharaon, ndrel ma bunuyh dâng lĕ ta nhih păng, yor ma Sarai i ur Ăbram nây. ");
INSERT INTO cmo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Jêh ri Pharaon kuăl Ăbram lah păng: “Moh kô̆ may jan ma gâp kơt nđa mêh? Khŏn may ma mbơh sŏng ma gâp, bu ur dja jêng ur may! ");
INSERT INTO cmo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Moh dâng may lah păng jêng oh may, jan ăn gâp sŏ păng jan ur chrao? Ưh ur may, nsât mre a ri, du bơh ntŭk dja hŏm!” ");
INSERT INTO cmo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Jêh ri Pharaon đă tahen păng njŭn Ăbram, ndrel ma ur păng, nđâp ma lĕ drăp ndơ păng geh du lôh bơh bri nây. ");
INSERT INTO cmo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Jêh ri Ăbram ndrel ma ur păng lôh bơh bri Êsip plơ̆ sât tay ta bri Nêkĭp, lĕ drăp ndơ păng geh, ndjôt leo ndrel păng nơm dadê. Lŭt hăn ndrel păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ăbram geh mpômpa (siŭm), ndrel ma prăk mayh ŏk ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Păng lôh bơh bri Nêkĭp nây, tât ta ƀon Ƀêtel ntŭk păng gŭ jan chun a lor nơh, ta vah vang ƀon Ƀêtel, đah ma ƀon Ai nây ");
INSERT INTO cmo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","jêh ri păng mbơh sơm kuăl Brah Yêhôva ta ntŭk păng lĕ jan ntŭk ma jan brah a lor ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lŭt i vay hăn ndrel ma Ăbram ri, păng geh be biăp phung, geh ndrôk phung, ndrel ma geh chun ŏk, tâm ban ma Ăbram đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ta bri nây mâu ôh tŏng mpa ma ăn mpômpa (siŭm) bar hê khân păng, yorlah khân păng geh mpômpa (siŭm) drăp ndơ ŏk ngăn, ndri dâng khân păng mâu hôm ôh blao gŭ ndrel ");
INSERT INTO cmo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","geh nau tâm lŏk băl phung chiăp Ăbram ndrel ma phung chiăp Lŭt. Rnôk nây phung Kanan, ndrel ma phung Pêrĭsit gŭ ta bri nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Jêh ri Ăbram lah ma Lŭt: “Ơ mon, lơi ăn ôh gâp ndrel may geh nau tâm lŏk băl, mâu lah phung chiăp gâp, ndrel ma phung chiăp may, yorlah bân jêng oh nô. ");
INSERT INTO cmo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Bri ta dja hôm huy ngăn, lah ndri ăn bân gŭ tâm nkhah băl, lah may gŭ mpeh bơh chiao, gâp gŭ mpeh bơh ma, lah may gŭ mpeh bơh ma, gâp gŭ mpeh bơh chiao”. ");
INSERT INTO cmo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Jêh ri Lŭt n'gâl uănh say ndrĭch rđŭng rŏ dak rlai Yôrđăn mpeh ma ƀon Sôar ueh ngăn geh dak dadê. Ntŭk nây nôk ê hŏ Brah Yêhôva lơh rai lơi ƀon Sôđŭm, ndrel ma ƀon Kômôra jêng tâm ban ma Êđen i mir Kôranh Brah, mâu lah kơt bri Êsip ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ndri Lŭt sŏ lĕ ndrĭch rđŭng Yôrđăn nây ma păng nơm, păng hăn mpeh jât lôh nar ri, kơt ndri dâng geh ma tâm nkhah khân păng bar hê i nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ăbram gŭ ta bri Kanan nây, yơn ma Lŭt gŭ rŏ ƀon ndrĭch rđŭng Yôrđăn ri, bơh kơi nây păng gŭ jan chun ta meng ƀon Sôđŭm ri. ");
INSERT INTO cmo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Bunuyh ta ƀon Sôđŭm ri, jêng phung djơh, jan tih ma Brah Yêhôva dŭt hô. ");
INSERT INTO cmo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Jêh Lŭt du lôh bơh ntŭk nây, Brah Yêhôva lah ma Ăbram: “Ăn may n'gơr uănh bơh ntŭk may gŭ nây aƀaơ ri, uănh jât lôh nar uănh jât nhŏp nar, ăn may uănh mpeh jât lơ uănh mpeh jât dŏng. ");
INSERT INTO cmo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Yorlah lĕ rngôch bri i may say nây, Gâp ăn ma may ta jât năp tay, ndrel ma rnoi deh may n'ho ro. ");
INSERT INTO cmo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Gâp ăn may rnoi deh bâk rơ̆ ŏk tâm ban ma neh môi, mâu geh ôh bunuyh dơi kơp, tâm ban ma bu mâu dơi kơp neh môi nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","May dâk hŏm, hăn lam bri nây, yorlah Gâp ăn bri i nây ma may ta jât năp tay”. ");
INSERT INTO cmo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Jêh ri Ăbram rơih chun păng ri, hăn trơn gŭ a ntŭk tơm jri Mămrê, dăch ma ƀon Hêbron, ta ntŭk nây păng rdăp lŭ jan du ntŭk ma jan brah ma yơk mbah Brah Yêhôva. ");
INSERT INTO cmo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nôk nây geh du huê kađăch kuŏng rnha Kêđôlômơr jêng kađăch ta bri Êlam, păng tâm rnglăp đah pe nuyh kađăch, kađăch ta bri Sinơr rnha Ămraphel, kađăch ta bri Êlêasar rnha Aryŭk, ndrel ma kađăch ta bri Kôyim rnha Thiđal. ");
INSERT INTO cmo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Lĕ puăn nuyh kađăch i nây leo băl hăn tâm lơh đah prăm nuyh kađăch, kađăch ta ƀon Sôđŭm rnha Ƀêra, kađăch ta ƀon Kômôra rnha Ƀirsa, kađăch ta ƀon Atma rnha Sinap, kađăch ta ƀon Sêpoyim rnha Sêmêpơr, ndrel ma kađăch ta ƀon Ƀêla i bu kuăl đŏng ƀon Sôar. ");
INSERT INTO cmo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Lĕ rngôch prăm nuyh kađăch i nây, rgum tahen khân păng nơm hăn tâm rnglăp ndrel ta rđŭng yôk Siđim dadê, ntŭk dak văch dak văr boh aƀaơ ri. ");
INSERT INTO cmo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Lĕ geh 12 năm jêh, lĕ prăm nuyh kađăch i nây gŭ ta nâm kađăch kuŏng Kêđôlômơr, tât năm 13 khân păng leo băl bah iăt nau đah kađăch i nây. ");
INSERT INTO cmo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Yơn ma tât năm 14 kađăch Kêđôlômơr, ndrel ma lĕ kađăch i gŭ ndrel păng, leo băl hăn tâm lơh đah mpôl kađăch i bah iăt nau păng. Dôl hăn rŏ trong nây, khân păng tâm lơh đah phung Rêphem ta ƀon Asthôrôt-Karnem, phung Sôsim ta ƀon Hăm, phung Êmim ta ntŭk bri lŏng Khĭriathem ");
INSERT INTO cmo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ndrel ma phung Hôri rŏ yôk Sêir, n'ho ma tât ta ƀon Elƀaran dăch ma bri rdah ri. ");
INSERT INTO cmo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Jêh dơi khân păng tâm lơh đah phung i nây, khân păng plơ̆ sât bơh nây tât ta ƀon Ên-Misphat, i bu kuăl ƀon Kađeh đŏng, khân păng tâm lơh đah phung Amalêk ta bri nây, ndrel ma đah phung Amôri gŭ ta bri Hasasôn-Tamar nây dơi khân păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Phung kađăch prăm nuyh i bah iăt nau kađăch kuŏng Kêđôlômơr nơh, jêng kađăch ƀon Sôđŭm, kađăch ƀon Kômôra, kađăch ƀon Atma, kađăch ƀon Sêpoyim, ndrel ma kađăch ƀon Ƀêla, khân păng leo băl tâm lơh ta rđŭng yôk Siđim. Ƀon Ƀêla i nây bu kuăl ƀon Sôar đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ta rđŭng yôk Siđim nây, khân păng tâm lơh đah kađăch Kêđôlômơr jêng kađăch bri Êlam, kađăch Thiđal jêng kađăch bri Kôyim, kađăch Ămraphel jêng kađăch bri Sinơr, ndrel ma kađăch Aryŭk jêng kađăch bri Êlêasar, ndri geh puăn kađăch tâm lơh đah prăm kađăch. ");
INSERT INTO cmo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ta rđŭng yôk Siđim nây geh ntu dak pring krăk ŏk ngăn. Dơi kađăch Kêđôlômơr, jêh ri kađăch ƀon Sôđŭm, ndrel ma kađăch ƀon Kômôra nchuăt chah chrai tŭp ta ntu pring ri khât lĕ phiao ndrel tahen khân păng nơm, jêh ri kađăch i hôm pe nuyh ri nchuăt jât yôk ri. ");
INSERT INTO cmo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kađăch i dơi lơh bu nây, khân păng sŏ lĕ drăp ndơ ta ƀon Sôđŭm, ndrel ma ta ƀon Kômôra ri, nđâp ma ndơ sông sa đŏng, jêh ri du sât bơh ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lŭt i mon Ăbram gŭ ta ƀon Sôđŭm ri, bu nhŭp rdu păng đŏng, ndrel ma lĕ drăp ndơ păng. ");
INSERT INTO cmo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Geh du huê bunuyh klaih, hăn nchuăt mbơh ma Ăbram i phung Hêbrơ, nôk păng hôm gŭ ta ntŭk tơm jri Mămrê. Mămrê jêng bu klô phung Amôri, jêng oh nô ma Ehkŭl, ndrel ma Anơr đŏng. Ehkŭl, ndrel ma Anơr nây lĕ tâm rnglăp ma Ăbram. ");
INSERT INTO cmo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Tât Ăbram tăng lah mon păng lĕ bu nhŭp rdu, păng leo băl 318 nuyh, jêng bunuyh i blao tâm lơh i deh ta jay păng nơm, khân păng tâng phung rlăng tât ta ƀon Đăn. ");
INSERT INTO cmo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ăbram tâm pă mpôl ta phung păng nơm nây, jêh ri lơh phung kađăch i nây ta nôk măng, n'ho ma tâng lơh tât ta ƀon Hôpa mpeh bơh lơ ƀon Đamas ri. ");
INSERT INTO cmo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Khân păng sŏ sât dadê lĕ drăp ndơ, sŏ i mon Lŭt păng ri, ndrel ma drăp ndơ păng đŏng, sŏ phung bu ur, ndrel ma lĕ rngôch bunuyh êng êng i bu nhŭp đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Jêh Ăbram sât dơi tâm lơh đah kađăch Kêđôlômơr, ndrel ma kađăch aƀă êng i gŭ tâm rnglăp ndrel kađăch nây, kađăch ƀon Sôđŭm hăn chuă păng ta rđŭng yôk Savê, i bu kuăl đŏng «Rđŭng yôk kađăch». ");
INSERT INTO cmo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Jêh ri kađăch ƀon Salêm rnha Mĭlkisađek ndjôt nŭmpăng, ndrel ma ndrănh play yŭng yar ƀon ma ăn Ăbram, kađăch nây jêng bunuyh jan brah ma Kôranh Brah i dŭt prêh. ");
INSERT INTO cmo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Păng lah nau geh jêng ăn ma Ăbram: “Dăn Kôranh Brah i dŭt prêh ta kalơ, nơm tơm njêng trôk, ndrel ma neh ntu, ăn nau geh jêng ma may. ");
INSERT INTO cmo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Rnê ma Kôranh Brah i dŭt prêh ta kalơ, brah i ăn may dơi đah phung rlăng may”. Jêh ri Ăbram ăn ma kađăch i nây du kô̆ tâm jât, lĕ drăp ndơ i păng sŏ lơh bu ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Jêh ri kađăch ƀon Sôđŭm lah ma Ăbram: “May mplơ̆ ƀon lan gâp nơm ma gâp găp hơyh, drăp ndơ i nây may sŏ dôh”. ");
INSERT INTO cmo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Yơn ma Ăbram lah ma kađăch ƀon Sôđŭm nây: “Gâp ton ta bơh năp Brah Yêhôva i Kôranh Brah dŭt prêh, nơm tơm njêng trôk, ndrel ma neh ntu ");
INSERT INTO cmo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","gâp mâu ôh sŏ drăp ndơ may du mlŏm, bol lah du mlŏm rse brai, mâu lah du mlŏm rse ntô jot kŏ gâp mâu sŏ đŏng, lơi ăn may lah: «Gâp ya sơm n'hơm ndrŏng ăn Ăbram». ");
INSERT INTO cmo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Gâp mâu ôh sŏ ndơ, gâp dăn may ăn ndơ sông sa i phung hăn tâm lơh ndrel gâp jêng phung i gŭ ta jay gâp nơm lĕ jêh sa nơh găp hơyh. Yơn ma Anơr, Ehkŭl, ndrel ma Mămrê, khân păng jêng bunuyh tâm rnglăp ndrel gâp, ăn khân păng nây sŏ êng drăp ndơ ma khân păng nơm”. ");
INSERT INTO cmo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Jêh nau i nây Brah Yêhôva ăn ma Ăbram say ndơ ta nau tâm mpơl, lah ma păng kơt nđa: “Ơ Ăbram may lơi klach ôh, yorlah Gâp jêng khêl ma may, ndrel ma ăn ndơ nkhôm dŭt kuŏng ma may đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Yơn ma Ăbram ơh ma Kôranh Brah lah: “Ơ Brah Yêhôva i kôranh gâp, moh ndơ May ăn ma gâp kŏ mâu geh khlay đŏng, yorlah gâp mâu ôh geh kon, bunuyh i dơn drăp ndơ khlay ta jay gâp jêng Êlêsơr tă bơh ƀon Đamas nây chrao”. ");
INSERT INTO cmo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ăbram lah tay: “May mâu ôh ăn gâp geh kon, lah ndri bunuyh i dơn drăp ndơ khlay gâp jêng dâk i gŭ ta jay gâp nây”. ");
INSERT INTO cmo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yơn ma Brah Yêhôva lah ma Ăbram kơt nđa: “Mâu di ôh bunuyh nây dơn drăp ndơ khlay may, kon bu klô may nơm jêng bunuyh dơn drăp ndơ khlay may”. ");
INSERT INTO cmo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Jêh ri Brah Yêhôva leo Ăbram lôh a dih, lah ma păng: “Lŏng may ngơk uănh jât trôk ti, may dơi đŏng kơp mănh i ti? Rnoi deh may ŏk tâm ban ma mănh i ti đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ăbram iăt nsing nau Brah Yêhôva i nây, yor ma nau păng iăt nsing nây dâng Brah Yêhôva kơp păng jêng bunuyh sŏng srăng. ");
INSERT INTO cmo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Brah Yêhôva lah tay ma Ăbram: “Gâp dja Brah Yêhôva, Gâp leo may du lôh bơh ƀon Ur bri Khalđê, gay ma ăn bri dak dja ma may dơn”. ");
INSERT INTO cmo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ăbram ôp: “Ơ Brah Yêhôva, mơm dâng gâp gĭt lah gâp dơn bri dak dja ngăn?” ");
INSERT INTO cmo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Jêh ri Brah Yêhôva lah ma păng: “Ăn may sŏ du mlŏm ndrôk me i lĕ geh pe năm, sŏ du mlŏm be me i lĕ geh pe năm, sŏ du mlŏm be biăp nkuŏng i lĕ geh pe năm, du mlŏm ntơp, ndrel ma du mlŏm plŭk rah nhhơr ăn ma Gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Jêh ri Ăbram sŏ lĕ mpômpa (siŭm) i nây plah du đah du đah tê̆ tâm nchrâng krep ta ri, i siŭm nar ri păng nkhât đŏng yơn ma mâu plah ôh. ");
INSERT INTO cmo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Jêh ri geh grŏt nđak drŏm sa puăch i nây, yơn ma Ăbram ntru lơi grŏt nđak i nây. ");
INSERT INTO cmo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tât bơi nhŏp nar ri, Ăbram hăk bêch suêp, jêh ri păng ră bôk kuŏng hô ngăn, geh ngo chêk kôlăk nkŭm ta păng. ");
INSERT INTO cmo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Jêh ri Brah Yêhôva lah ma Ăbram: “Ăn may gĭt n'hêl yơ̆, rnoi deh may mra du gŭ ta du bri, bri nây mâu ôh di bri khân păng nơm, khân păng gŭ jan dâk bu ta bri nây, bunuyh ta bri nây tŭn jot khân păng jŏ 400 năm ");
INSERT INTO cmo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","yơn ma Gâp tê̆ dôih ma phung bunuyh i tŭn jot rnoi deh may nây, jêh ri tay khân păng du lôh bơh bri nây, ndjôt nđâp ma drăp ndơ ŏk jât. ");
INSERT INTO cmo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","I may nây tay, tât may khât may khât ma nau đăp mpăn, bu mra tŏp may, jêh may rêh lĕ ranh ngăn tay. ");
INSERT INTO cmo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tât ta rnôk 4 ri mơ rnoi deh may plơ̆ sât tay ta bri dja, yorlah nau tih phung Amôri i gŭ ta bri dja aƀaơ ri ê hŏ ôh bêng ê hŏ ôh di ma tê̆ dôih”. ");
INSERT INTO cmo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Tât nar lĕ nhŏp, bri lĕ ngo, ta nây dô ma say geh glah nhhuk ŭnh, n'ho ma geh ŭnh hit rŏ vah vang puăch i plah plah ri nơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ta nar nây Brah Yêhôva tâm rnglăp ma Ăbram, Păng lah ma Ăbram: “Gâp ăn bri dak dja ma rnoi deh may, ntơm bơh dak rlai bri Êsip ri, tât ma dak rlai kuŏng, jêng dak rlai Ơprat ");
INSERT INTO cmo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","gâp ăn đŏng bri dak dâng lĕ phung Ken, phung Kênĭsit, phung Kătmôni ");
INSERT INTO cmo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","phung Hêt, phung Pêrĭsit, phung Rêphem ");
INSERT INTO cmo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","phung Amôri, phung Kanan, phung Girkasit, ndrel ma phung Yêpusit i hôm gŭ aƀaơ ri”. ");
INSERT INTO cmo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai i ur Ăbram ri mâu ôh bă kon ma Ăbram. Păng geh du huê dâk bu ur phung Êsip rnha Hakar. ");
INSERT INTO cmo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Jêh ri Sarai lah ma Ăbram: “Yor ma Brah Yêhôva mâu ăn gâp geh kon, lah ndri may sŏ dâk bu ur gâp nây dô, klăp lah gâp geh du huê kon tă bơh păng”. Ăbram iăt nau i ur păng. ");
INSERT INTO cmo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tât Ăbram lĕ geh 10 năm gŭ ta bri Kanan nây, Sarai i ur păng ri sŏ Hakar i bu ur phung Êsip jêng dâk păng nơm ri, ăn ma Ăbram i sai păng ri ma jan ur. ");
INSERT INTO cmo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ăbram gŭ ur sai ndrel ma Hakar ri, jêh ri Hakar ntreo. Tât ma Hakar gĭt lah săk păng lĕ ntreo, păng ntơm mưch rmot kôranh bu ur păng nơm ri. ");
INSERT INTO cmo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai lah ma Ăbram: “Yor ma may dâng gâp geh nau đit prêng, gâp sŏ bu ur dâk gâp ăn ta ntơh may, tât ma păng gĭt lah săk păng lĕ ntreo, ƀêng păng ma mưch rmot gâp chrao. Lah ndri dăn Brah Yêhôva sơm phat dôih ma bân bar hê”. ");
INSERT INTO cmo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Jêh ri Ăbram lah ma Sarai: “Bu ur dja gŭ ta nâm ay, lah ndri mơm nau ay ŭch jan ma păng, tâng ay nơm ŭch”. Jêh ri Sarai jan dăng hô ngăn ma Hakar, tât ma păng du nchuăt ngai. ");
INSERT INTO cmo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Jêh păng du nchuăt nây, geh tông păr Brah Yêhôva hăn mâp Hakar dăch ma du mlŏm tu dak ta bri rdah ri, kêng meng trong hăn jât bri Sur. ");
INSERT INTO cmo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Tông păr ôp Hakar nây: “Hơi Hakar dâk Sarai, bơh tă ay nây, ah jât let hăn ay nây êh?” Hakar ơh: “Gâp du nchuăt bơh Sarai kôranh gâp nơm lah”. ");
INSERT INTO cmo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tông păr Brah Yêhôva lah ma păng: “Ăn ay sât a jay kôranh ay nơm ri, iăt nau păng dô”. ");
INSERT INTO cmo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Tông păr Brah Yêhôva nây lah tay đŏng ma păng: “Tay dâng gâp jan rnoi deh ay ăn bâk rơ̆ dŭt ŏk ngăn mâu hôm ôh dơi kơp”. ");
INSERT INTO cmo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Tông păr Brah Yêhôva nây lah tay ma păng đŏng: “Aƀaơ ri ay lĕ ntreo jêh, ay tay gŭ oh du huê kon bu klô, jêh ri ăn ay tê̆ rnha păng Ismaêl, geh nau khlay lah «Kôranh Brah tăng» Yorlah Brah Yêhôva lĕ tăng nau ay nter dôl ay geh nau jêr jŏt nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Kon i nây jan ndơ tâng nuih n'hâm păng nơm ŭch dơm, tâm ban ma mpômpa (siŭm) bri đŏng. Păng tâm lơh đah ma lĕ rngôch bunuyh, jêh ri lĕ rngôch bunuyh tâm lơh đah păng đŏng. Păng mâu ôh gŭ ndrel ndŭl mpôl păng”. ");
INSERT INTO cmo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hakar tê̆ rnha Brah Yêhôva i ngơi ma păng nây «Kôranh Brah i uănh say», yorlah Hakar mân êng: “Ntŭk dja gâp lĕ say Kôranh Brah, jêh ri Păng uănh say gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kơt ndri dâng bu kuăl tu dak nây rnha «Tu dak Lahairoi», geh nau khlay lah «Tu dak brah rêh ngăn i uănh say gâp». Tu dak i nây vah vang ƀon Kađeh, ma ƀon Paret. ");
INSERT INTO cmo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Jêh ri Hakar gŭ oh du huê kon bu klô păng đah Ăbram. Ăbram tê̆ rnha kon nây «Ismaêl». ");
INSERT INTO cmo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Nôk Hakar deh Ismaêl nây, Ăbram lĕ geh 86 năm. ");
INSERT INTO cmo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tât Ăbram lĕ geh 99 năm, Brah Yêhôva tâm mpơl ăn păng say, Păng lah ma Ăbram: “Gâp jêng brah i dŭt geh nau dơi, ăn may iăt nau Gâp, gŭ ueh sŏng srăng ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Gâp ŭch tâm rnglăp đah may, ŭch jan rnoi deh may ăn bâk rơ̆ dŭt ŏk”. ");
INSERT INTO cmo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ăbram păn krap a neh su, jêh ri Kôranh Brah lah ma păng jât: ");
INSERT INTO cmo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Dja nau Gâp tâm rnglăp ndrel may kơt nđa, may tay jêng che ma phung bunuyh dŭt ŏk. ");
INSERT INTO cmo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Bu mâu hôm ôh kuăl may «Ăbram» jât, geh nau khlay «Bơ̆ kuŏng», bu kuăl may «Abrahăm», geh nau khlay «Bơ̆ phung bunuyh dŭt ŏk», yorlah Gâp ăn may jêng bơ̆ ma phung bunuyh dŭt ŏk. ");
INSERT INTO cmo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Gâp jan ăn may geh kon geh sau dŭt ŏk, Gâp ăn rnoi deh may jêng geh phung ŏk ngăn, ndrel ma ăn geh kađăch aƀă tă bơh rnoi deh may đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Gâp tâm rnglăp ma may tât kon tât sau may bơh kơi bơh kơi tâm ăp rnôk. Nau tâm rnglăp dja hôm n'ho ro. Gâp jêng brah may, n'ho ma tât kon tât sau may bơh kơi bơh kơi ri tay ");
INSERT INTO cmo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Gâp ăn dâng lĕ bri dak Kanan i may veh gŭ dja jêng bri dak may n'ho ro, ndrel ma tât kon tât sau may bơh kơi bơh kơi tay đŏng, jêh ri Gâp jêng brah ma kon sau may nây”. ");
INSERT INTO cmo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kôranh Brah lah ma Abrahăm: “Lŏng i may nây, ăn may ndjôt nau tâm rnglăp Gâp, nđâp ma may nơm n'ho ro, nđâp ma kon ma sau may bơh kơi bơh kơi tay. ");
INSERT INTO cmo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dja nau tâm rnglăp i Gâp ăn ma khân ay may ndjôt, ndrel ma kon ma sau khân ay may nây, ăn lĕ kon bu klô ta phung khân ay may ăn koh ntô dadê. ");
INSERT INTO cmo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ăn khân ay may koh ta chông ntô ndơ bu klô ri, i nây jêng ndơ mbên nau tâm rnglăp Gâp ăn ma khân ay may. ");
INSERT INTO cmo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Dâng lĕ kon bu klô iăt ma tât pham nar jêh deh, jan koh ntô dadê, bol lah dâk deh ta jay khân ay may nơm kađôi lĕ, bol lah dâk rvăt bơh bu năch phung bri êng kađôi lĕ, jan nau dja n'ho ro tâm ăp rnôk khân ay may. ");
INSERT INTO cmo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Dâng lĕ dâk bu klô deh ta jay khân ay may nơm, mâu lah dâk rvăt ma prăk kađôi, jan koh ntô dadê, i nây jêng ndơ mbên nau tâm rnglăp Gâp ăn mpeh ma săk jăn khân ay may hôm n'ho ro. ");
INSERT INTO cmo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Lah bu moh bu klô i mâu ôh koh ntô ta săk păng ri, mâu hôm ôh kơp păng jêng phung ƀon lan khân ay may jât, yorlah păng lĕ mƀăr lơi nau tâm rnglăp Gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kôranh Brah lah ma Abrahăm jât: “Sarai ur may nây, may mâu hôm ôh kuăl păng Sarai jât, kuăl păng «Sara» hŏ. ");
INSERT INTO cmo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Gâp ăn nau geh jêng ma păng, Gâp ăn may geh du mlŏm kon bu klô tă bơh păng. Gâp ăn nau geh jêng ma păng, jêh ri rnoi deh păng jêng phung bri êng êng, ndrel ma geh kađăch aƀă ta rnoi deh păng đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Jêh ri Abrahăm krap păn a neh su, gơm êng ta nuih n'hâm ri lah: “Bu klô lĕ 100 năm, ơm hôm blao geh kon lah? Lŏng Sara lĕ 90 năm, gĭt ma hôm bă kon lah?” ");
INSERT INTO cmo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abrahăm lah ma Kôranh Brah: “Lah May ăn Ismaêl dơn nau ton May dja, lĕ găp ngăn”. ");
INSERT INTO cmo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kôranh Brah lah ma Abrahăm: “Mâu ôh, yorlah ur may Sara bă du huê kon bu klô ma may! Ăn may tê̆ rnha păng «Isăk», geh nau khlay «Gơm». Gâp tâm rnglăp ma păng, jêng nau tâm rnglăp hôm n'ho ro tât kon tât sau păng. ");
INSERT INTO cmo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Lŏng Ismaêl i nây, lĕ Gâp tăng nau may lah, tay Gâp ăn nau geh jêng ma păng, Gâp jan ăn păng geh kon geh sau bâk rơ̆ dŭt ŏk. Gâp ăn geh kađăch 12 nuyh tă bơh rnoi deh păng, ndrel ma ăn rnoi deh păng jêng du phung bri dak dŭt kuŏng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Yơn ma Gâp tâm rnglăp đah ma Isăk kon Sara, păng deh năm tay, khay dja đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Jêh lĕ phiao Kôranh Brah ngơi ndrel ma Abrahăm, jêh ri Păng du bơh ntŭk nây yot klŏk. ");
INSERT INTO cmo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Jêh ri Abrahăm leo Ismaêl, leo lĕ rngôch phung dâk deh ta jay păng ri, nđâp ma phung dâk i păng rvăt ma prăk, dâng lĕ bu klô i gŭ ta jay păng ri, păng koh ntô ta nar nây dadê, păng jan kơt nau Kôranh Brah de đă ma păng ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Nôk Abrahăm koh ntô, păng lĕ geh 99 năm ");
INSERT INTO cmo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","yơn ma Ismaêl i kon păng ri, lĕ geh 13 năm. ");
INSERT INTO cmo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrahăm, ndrel ma Ismaêl koh ntô du nar dơm. ");
INSERT INTO cmo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Nđâp ma lĕ rngôch phung bu klô i gŭ ta jay păng ri, phung dâk deh ta jay păng, phung dâk păng rvăt ma prăk bơh phung bu năch bri êng kađôi, khân păng koh ntô ndrel ma Abrahăm dadê đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Jêh ri Brah Yêhôva tâm mpơl ăn ma Abrahăm say tay ta tơm jri Mămrê ri, dôl Abrahăm gŭ ta bôk mpông chun păng nơm ri, nôk nar nklang bôk. ");
INSERT INTO cmo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Jêh ri Abrahăm ngơk say bunuyh pe nuyh dâk bơh năp păng ri. Tât ma say khân păng, păng nchuăt bơh mpông chun păng nơm nây hăn ran a khân păng păn a neh su, tâng nau vay ôp ueh lăng ma kôranh. ");
INSERT INTO cmo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Jêh ri păng lah: “Ơ kôranh, lah khân may rŏng ma gâp ngăn, dăn ƀŏt hŏ ôh n'hot bơh gâp jêng bunuyh ta nâm khân may. ");
INSERT INTO cmo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ăn gâp đă bu sŏ dak đê̆ ma rao jŏng khân may, dăn khân may gŭ rlu ta nâm tơm si dja ƀŏt. ");
INSERT INTO cmo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Gâp hăn sŏ ndơ sông sa đê̆ đă khân mre ma sông, ma geh suan khân may ma hăn jât năp jât, lĕ khân may ma tât ta ntŭk gâp dja”. Jêh ri pe nuyh khân păng nây lah ma păng: “Jan hŏm kơt nau may lah ri”. ");
INSERT INTO cmo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Jêh ri Abrahăm hăn ta chun ri ro, mbơh ma Sara i ur păng nơm: “Ay sŏ rnih môi pe ƀuăt, mon jan nŭmpăng ăn gơnh oi”. ");
INSERT INTO cmo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abrahăm nơm ri hăn nchuăt ta phung mpômpa (siŭm) joi du mlŏm kon ndrôk lây ueh ngăn, ăn bunuyh jan kar ma păng du huê jan, bunuyh jan kar i nây sŏ jan ro. ");
INSERT INTO cmo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Jêh ri Abrahăm sŏ ngi dak toh ndrôk, sŏ dak toh ndrôk, ndrel ma sŏ puăch kon ndrôk i bu jan trao ri nơh, leo ăn ta năp mpôl pe nuyh nây sông sa. Jêh ri khân păng i nây sông sa, Abrahăm nơm ri hôm gŭ ndrel, ma sơm sŏ ndơ sông sa ma khân păng ta nâm tơm si ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Jêh ri mpôl pe nuyh nây ôp Abrahăm: “Ah Sara ur may nây?” Abrahăm ơh ma khân păng: “Păng gŭ a trôm chun to”. ");
INSERT INTO cmo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Jêh ri Brah Yêhôva lah ma Abrahăm: “Năm jât năp klăp lah ta khay dja đŏng, Hên hăn mâp may du tơ̆ tay jât, ta nôk ri tay Sara lĕ geh du mlŏm kon bu klô”. Sara gŭ iăt tăng nau khân păng ngơi ta bôk mpông bơh kơi Abrahăm ri. ");
INSERT INTO cmo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahăm, ndrel ma Sara lĕ ranh ranh ngăn, Sara lĕ bah geh săk đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ndri Sara gơm lah êng ta nuih n'hâm ri: “Săk lĕ ranh dah dja jêh, lŏng sai gâp lĕ ranh ngăn đŏng, gâp ơm hôm rŏng ma nau maak lah?” ");
INSERT INTO cmo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Brah Yêhôva lah ma Abrahăm: “Mơm dâng Sara gơm? Nđâp ma lah «Gâp lĕ ranh ngăn ơm hôm geh kon lah?» ");
INSERT INTO cmo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ơm geh lah ndơ Brah Yêhôva jan mâu blao? Tât ăp khay ri tay Hên hăn mâp tay may, nôk nây Sara geh du huê kon bu klô”. ");
INSERT INTO cmo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Yơn ma Sara rlăch lah: “Mâu ôh, gâp mâu ôh prot gơm” dâng păng lah kơt nây, yorlah păng lĕ klach. Brah Yêhôva lah ma păng: “Mâu ôh, ay lĕ gơm ngăn”. ");
INSERT INTO cmo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Jêh ri pe nuyh khân păng nây dâk hăn, khân păng n'gâl uănh jât ƀon Sôđŭm ri, Abrahăm hăn ndrel đŏng gay ma njŭn khân păng nây. ");
INSERT INTO cmo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nôk nây Brah Yêhôva lah: “Nau Gâp ndrăp ŭch jan dja, Gâp mâu ôh mo ma Abrahăm ");
INSERT INTO cmo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","yorlah Abrahăm tay jêng bơ̆ ma du phung bri dak i dŭt kuŏng, nđâp ma geh nau dơi đŏng, lĕ rngôch bri dak ta neh ntu dja mra sŏ dơn nau geh jêng tă bơh păng dadê. ");
INSERT INTO cmo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Lĕ Gâp kơih jêh păng gay ma ăn păng ntŭm nti kon bu klô păng, ndrel ma tât kon tât sau păng bơh kơi bơh kơi tay, ăn ndjôt nâp trong Brah Yêhôva, gay ma gŭ ngao tâm di, ndrel ma ăn sŏng. Lah kon sau păng jan kơt nđa ngăn, Gâp jan dâng lĕ nau Gâp ton ma păng”. ");
INSERT INTO cmo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Jêh ri Brah Yêhôva lah: “Yorlah nau bu lah ma ƀon Sôđŭm, ndrel ma ƀon Kômôra lĕ hô ngăn bunuyh ta ƀon nây jan tih dŭt ŏk đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Lah ndri Gâp ŭch hăn jŭr uănh, gay ma gĭt nau bu jan ta nây jêng di kơt nau Gâp lĕ tăng lah mâu. Lah mâu ngăn Gâp ŭch gĭt đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Jêh ri bar hê hăn rƀŏng jât ƀon Sôđŭm ri. Abrahăm ri hôm dâk ndrel ma Brah Yêhôva ta ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abrahăm hăn dăch ôp Brah Yêhôva: “Ơm May lơh lơi ngăn lah, bunuyh sŏng, ndrel ma bunuyh tih? ");
INSERT INTO cmo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Lah geh 50 nuyh bunuyh sŏng gŭ ta ƀon i nây, ah May lơh lơi đŏng ƀon i nây ƀah? Lah ndri May mâu yô̆ ma ƀon i nây yor ma geh bunuyh sŏng 50 nuyh gŭ ta ƀon i nây? ");
INSERT INTO cmo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Lah May lơh kơt nây, jêng lơh lơi bunuyh sŏng ndrel ma bunuyh tih mâu jêng vă, lah lơh kơt nây May hôm tê̆ dôih bunuyh sŏng jêng tâm ban ma bunuyh tih, mâu jêng vă. Jan kơt nây ơm di kôranh phat dôih ma lĕ rngôch neh ntu lah?” ");
INSERT INTO cmo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Jêh ri Brah Yêhôva lah: “Lah Gâp say geh 50 nuyh bunuyh sŏng gŭ ta ƀon Sôđŭm nây, Gâp mâu lơh ôh, Gâp yô̆ ma ƀon i nây yor ma bunuyh 50 nuyh i nây”. ");
INSERT INTO cmo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrahăm ngơi ma Brah Yêhôva jât: “Gâp dja jêng neh môi, ndrel ma ŭnh buh dơm mâu geh nau khlay, dăn May lơi klăp ndăng nau tih gâp hôm ngơi jât ma May dja. ");
INSERT INTO cmo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Lah ta ƀon i nây mâu ôh tât 50 nuyh, geh 45 nuyh dơm, lah ndri May lơh ƀon nây yor ma hôm e prăm nuyh ê hŏ râng nây bơh?” Păng ơh: “Lah Gâp say geh 45 nuyh bunuyh sŏng, Gâp mâu lơh ôh”. ");
INSERT INTO cmo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahăm ngơi tay ma Brah Yêhôva: “Klăp lah geh 40 nuyh dơm”. Păng lah: “Gâp mâu lơh ôh, yor ma phung 40 nuyh nây”. ");
INSERT INTO cmo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abrahăm ngơi jât: “Dăn May lơi ji nuih ma gâp, gâp dăn ngơi ma May du tơ̆ jât. Klăp lah geh 30 nuyh dơm”. Păng lah: “Lah Gâp say geh 30 nuyh, Gâp mâu lơh ôh”. ");
INSERT INTO cmo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahăm ngơi jât: “Dăn May lơi klăp ndăng nau gâp hôm ngơi ndrel May dja, klăp lah geh 20 nuyh dơm”. Păng lah: “Gâp mâu lơh ôh, yor ma phung 20 nuyh nây”. ");
INSERT INTO cmo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrahăm ngơi jât: “Dăn Kôranh Brah lơi ji nuih ma gâp, gâp dăn ngơi hôm du tơ̆ dja dơm. Klăp lah geh jât nuyh dơm”. Păng lah: “Gâp mâu lơh ôh, yor ma phung jât nuyh nây”. ");
INSERT INTO cmo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Jêh lĕ phiao Brah Yêhôva ngơi ndrel Abrahăm ri, Păng hăn yot klŏk bơh ntŭk nây, jêh ri Abrahăm plơ̆ sât tay ta chun păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tât kêng măng ri, bar hê tông păr nây hăn tât ta ƀon Sôđŭm. Lŭt gŭ ta bôk mpông ƀon nây, tât ma say tông păr bar hê nây, păng ran chuă n'ho ma păn krap a neh su ro. ");
INSERT INTO cmo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Păng lah ma bar hê tông păr nây: “Ơ kôranh, gâp jêng bunuyh ta nâm khân may, hăn lăp a jay gâp ƀŏt, gay ma rao jŏng khân may, jêh ri bêch ta dja du măng, kŏp ôi tay dâng dâk ơm ôi hăn jât”. Yơn ma tông păr nây ơh ma păng: “Mâu ôh, măng dja hên bêch ta jŏng gung ƀon”. ");
INSERT INTO cmo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Yor ma Lŭt dăn hô ngăn, ndri dâng mpôl tông păr nây hăn bêch a jay păng, păng ndrăp ndơ sông sa ueh, đă bu gŭch nŭmpăng mâu geh ndrui ăn ma mpôl tông păr nây, jêh ri mpôl tông păr nây sa. ");
INSERT INTO cmo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Dôl khân păng ê hŏ bêch ôh, dâng lĕ bunuyh ta ƀon nây, lĕ rngôch bu klô ta ƀon Sôđŭm ri, ntơm bơh bu ndăm tât ma bu ranh, leo băl hăn njueng jay Lŭt ri dadê. ");
INSERT INTO cmo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Phung i nây nter ôp Lŭt: “Ah gŭ bunuyh i lăp ta jay may măng dja nơh mêh? Hăn may nglôh khân păng ma hên, hên de ma tâm hao đah khân păng”. ");
INSERT INTO cmo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Jêh ri Lŭt lôh a dih dâk bơh dih mpông ri, păng ntâl mpông bơh kơi păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Păng lah: “Ơ oh nô, gâp dăn dôih ma khân may khât ôm lôm lă ngăn, lơi jan djơh kơt nây! ");
INSERT INTO cmo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Gâp geh kon bu ur drôh bar hê, ê hŏ đah bu ôh, gâp ăn khân păng ma khân may, dah khân may ŭch jan, iăt ma khân may lơi lơh ma bar hê khân păng dja, yorlah khân păng lĕ veh bêch ta jay gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bu lah ma păng: “Dŭ may djă!” Jêh ri bu lah tay păng jât: “May i nây mâu ôh di phung hên, mơm aƀaơ ri ŭch jan kôranh hên? Lah ndri lơh djơh may ăn hô rlao ma bar hê nây jât”. Jêh ri bu ntrôl Lŭt dŭt hô, lăp ŭch ma mplŭng mpông ro. ");
INSERT INTO cmo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Yơn ma tông păr de suk ti mphŏk Lŭt lăp a trôm jay, jêh ri ntâl mpông. ");
INSERT INTO cmo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Jêh bơh nây tông păr de jan cheh trôm măt phung i gŭ ta bôk mpông ri ăn cheh dadê, ntơm bơh bu jê̆ tât ma bu kuŏng, ndri dâng phung i nây joi ngăn joi ngăn mpông mâu hôm say jât ôh. ");
INSERT INTO cmo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Jêh ri tông păr nây ôp Lŭt: “May geh ndŭl mpôl aƀă gŭ ta ƀon dja đŏng? Mâu lah geh kon geh klây? Ăn may leo lĕ bunuyh may du lôh bơh ntŭk dja hŏm. ");
INSERT INTO cmo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ƀon dja hên lơh lơi, yorlah nau djơh ta ƀon dja lơ hô ngăn lư a Brah Yêhôva ri, kơt ndri dâng Păng đă hên hăn lơh hêng lơi ƀon dja”. ");
INSERT INTO cmo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Jêh ri Lŭt dâk mbơh klây klây i nđăp ma kon păng ri: “Dâk du bơh ntŭk dja hŏm, yorlah Brah Yêhôva bơi ma lơh hêng lơi ƀon dja”. Tih ma i klây klây ri mâu ôh iăt, khân păng nđôn lah ngơi pâl dơm. ");
INSERT INTO cmo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tât bri lĕ ƀhit ang, tông păr de nchâp Lŭt: “Dâk hŏm, leo ur may, ndrel ma kon may du bơh ntŭk dja, klach lah geh khât ndrel phung tih ta ƀon dja”. ");
INSERT INTO cmo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tih ma Lŭt hôm e gŭ mbrĕ mbrơi. Jêh ri tông păr de têk ti Lŭt, têk ti i ur păng, ndrel ma têk ti i kon păng ri, leo khân păng ăn gŭ a bơh dih ƀon ri, yorlah Brah Yêhôva yô̆ khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tât bơh dih ƀon ri, du huê tông păr lah ma khân păng: “Khân may nchuăt hŏm gay ma klaih, lơi ôh n'gâl jât kơi, ndrel ma lơi nsrŭng ta ntŭk bri rđŭng đŏng, ăn khân may nchuăt jât yôk ri, gay ma klaih bơh nau khât hêng”. ");
INSERT INTO cmo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lŭt ngơi ma tông păr: “Ơ kôranh, lơi ôh nchâp gâp ndri. ");
INSERT INTO cmo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","May lĕ yô̆ ma gâp hô ngăn, rklaih nau rêh gâp. Yơn ma lah may đă gâp nchuăt jât yôk ri mâu năn ôh, klach lah nau djơh nây ban gâp chrao, jêh ri gâp khât ro. ");
INSERT INTO cmo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ơ kôranh, ta dja geh du ƀon dăch oi gâp dơi ma nchuăt, ƀon i nây jê̆ dơm, lah ndri may ăn gâp nchuăt ta ƀon jê̆ nây, gay ma rêh!” ");
INSERT INTO cmo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Tông păr lah ma păng: “Lah ndri gâp tâng nau may, gâp mâu ôh lơh hêng ƀon jê̆ i may lah nây. ");
INSERT INTO cmo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","May nchuăt ăn gơnh hŏm ta ƀon nây, yorlah gâp mâu ôh blao jan lah may ê hŏ tât ta nây”. Ndri dâng bu tê̆ rnha ƀon i nây «Sôar», geh nau khlay «Jê̆». ");
INSERT INTO cmo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Tât Lŭt lĕ lăp ta ƀon Sôar ri, nar lĕ lôh jêh. ");
INSERT INTO cmo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Nôk nây Brah Yêhôva ăn geh nsiu hit ŭnh tă bơh trôk ti tâm ban ma mih ngăn nkhŭt ta ƀon Sôđŭm, ndrel ma ƀon Kômôra. ");
INSERT INTO cmo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Brah Yêhôva lơh hêng lơi dâng lĕ ƀon nây, ndrel ma lĕ rngôch ntŭk bri rđŭng, bunuyh dâng lĕ ta ƀon, nđâp ma lĕ ndơ hon ta neh, khât roh hêng lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lŏng i ur Lŭt ri, păng n'gâl jât kơi, n'ho ma jêng boh rup i săk păng ri. ");
INSERT INTO cmo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abrahăm dâk ơm ôi, păng hăn ta ntŭk păng gŭ ndrel Brah Yêhôva ri nơh ");
INSERT INTO cmo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","jêh ri păng uănh bơh lơ yôk jât ƀon Sôđŭm, jât ƀon Kômôra, ndrel ma lĕ rngôch ntŭk bri rđŭng ri, păng say nhhuk ŭnh tâm ban ma nhhuk ŭnh mpuyh ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kơt ndri nôk Brah Yêhôva lơh hêng lơi dâng lĕ ƀon rŏ ntŭk bri rđŭng nây, Păng kah gĭt ma Abrahăm, jêh ri Păng rklaih Lŭt ăn rêh, nôk Păng lơh hêng lơi ƀon Lŭt gŭ nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lŭt, ndrel ma bar hê kon drôh păng lôh bơh ƀon Sôar hăn gŭ a yôk ri, yorlah păng mâu ôh bănh gŭ ta ƀon Sôar, ndri dâng păng hăn gŭ a du mlŏm trôm yôk, ndrel ma bar hê kon drôh păng nây. ");
INSERT INTO cmo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Dôl nây i yôh ri lah ma i oh: “Bơ̆ bân lĕ ranh, ta bri dja mâu ôh geh bu klô sŏ bân ma jan ur, kơt bu aƀă êng ta neh ntu dja. ");
INSERT INTO cmo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Lah ndri bân jă păng nhêt ndrănh ăn tât nhŭl, jêh ri bêch ndrel păng, gay ma hôm geh rnoi deh tă bơh bơ̆ bân”. ");
INSERT INTO cmo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Măng nây bar hê khân păng ri jă bơ̆ khân păng nhêt ndrănh ăn nhŭl ro, jêh ri i yôh ri lăp bêch ndrel i bơ̆ ri, yơn ma Lŭt mâu gĭt ôh kon păng bêch đah păng, yor ma lĕ nhŭl hô ir. ");
INSERT INTO cmo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kah ôi tay i yôh ri lah ma i oh: “A măng nơh gâp lĕ jêh bêch đah bơ̆, măng dja bân jă păng nhêt ndrănh ăn tât nhŭl jât, jêh ri ay bêch đah păng, gay ma hôm geh rnoi deh tă bơh păng”. ");
INSERT INTO cmo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tât măng nây, khân păng jă tay i bơ̆ nhêt ndrănh ăn tât nhŭl, jêh ri i oh ri lăp bêch đah i bơ̆ ri, yơn ma Lŭt mâu gĭt ôh kon păng bêch đah păng, yor ma lĕ nhŭl hô ir. ");
INSERT INTO cmo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Jêh ri lĕ bar hê kon drôh Lŭt ri, ntreo đah păng nơm dadê. ");
INSERT INTO cmo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","I yôh ri gŭ oh du huê kon bu klô, păng tê̆ rnha Môăp, păng i nây jêng che ma phung Môăp n'ho ma tât aƀaơ dja. ");
INSERT INTO cmo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","I oh ri gŭ oh du huê kon bu klô đŏng, păng tê̆ rnha Ƀên-Ami, păng i nây jêng che ma phung Amôn n'ho ma tât aƀaơ dja. ");
INSERT INTO cmo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Jêh ri Abrahăm lôh bơh ntŭk păng gŭ nây, hăn mpeh ma bri Nêkĭp. Păng gŭ ta ƀon Kêrar, jêng vah vang ƀon Kađeh ma bri Sur. ");
INSERT INTO cmo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ta nây Abrahăm ngơi nkoch Sara i ur păng ri ma bu, păng lah Sara nây jêng i oh păng. Ta ƀon Kêrar nây geh du huê rnha Abimalĭch, păng jêng kađăch bri nây, tât păng gĭt ma nau Abrahăm nkoch i nây, păng đă bu hăn sŏ Sara leo a păng ma jan ur, ");
INSERT INTO cmo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","yơn ma ta măng nây Kôranh Brah hăn mâp ma nau mbơi, lah ma păng: “May tay khât ro yor ma bu ur i may sŏ nây, yorlah păng nơh jêng ur bu”. ");
INSERT INTO cmo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Yơn ma kađăch Abimalĭch ê hŏ ôh bêch đah Sara, ndri păng ôp: “Ơ Kôranh Brah, May lơh lơi đŏng bơh, lah gâp ndrel ma ƀon lan gâp mâu mâp jan tih? ");
INSERT INTO cmo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ơm mâu di lah păng lĕ mbơh ma gâp lah: «Bu ur dja jêng oh gâp»? Jêh ri bu ur nây kŏ mbơh ma gâp lah: «Bu klô dja jêng nô gâp» đŏng. Kơt ndri nau gâp jan dja jêng di ma gâp, gâp kŏ mâu jan tih đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kôranh Brah lah ma păng tâm nau mbơi nây: “Gâp gĭt nau may jan nây jêng di ma may, kơt ndri dâng Gâp buay may, mâu ăn may jan tih ma Gâp. Gâp mâu ƀŏng gor ăn may bêch đah bu ur nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Lah ndri ăn may mplơ̆ bu ur nây a sai păng aƀaơ ri, tay păng mbơh sơm ăn ma may, gay ma may hôm gŭ rêh jât, yorlah păng jêng bunuyh ntơyh nau Gâp ngơi. Lah may mâu ôh mplơ̆ bu ur nây a păng, may tay, ndrel ma ƀon lan may khât ro”. ");
INSERT INTO cmo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kađăch Abimalĭch ri dâk ơm ôi, păng kuăl rgum phung kơl jan kar păng, jêh ri mbơh nkoch dâng lĕ nau mbơi i nây ăn ma khân păng tăng. Jêh tăng nau i nây, lĕ rngôch khân păng klach nsŏr dadê. ");
INSERT INTO cmo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Jêh ri kađăch Abimalĭch đă bu hăn kuăl Abrahăm, kađăch lah păng: “Moh may jan ma hên kơt nđa mêh? Moh ƀă gâp jan tih ma may, dâng may jan ăn ma gâp, ndrel ma bri dak gâp geh nau tih dŭt kuŏng kơt nđa? Yorlah nau i may jan ma gâp dja, bu mâu geh ôh di ma jan!” ");
INSERT INTO cmo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Kađăch Abimalĭch lah tay ma Abrahăm: “Mơm nau may mân, dâng may ŭch jan kơt nđa?” ");
INSERT INTO cmo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahăm lah ma kađăch nây: “Yorlah gâp mân, bunuyh ta bri dja mâu geh ôh du huê klach ma Kôranh Brah, lŏng gâp tay bu de nkhât yor ma ŭch sŏ ur gâp nây. ");
INSERT INTO cmo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ndrel ma păng nơh jêng oh gâp ngăn, jêng kon bơ̆ gâp đŏng, tih ma mê̆ gâp đah mê̆ păng jêng mê̆ êng êng, jêh ri gâp sŏ păng nđăp ur sai. ");
INSERT INTO cmo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Dôl Kôranh Brah ăn gâp du ngai đah ma ndŭl mpôl gâp nơm, gâp lĕ lah ma păng: «Ăn ay yô̆ nđach ma gâp ƀă yơ̆, ah ntŭk bân hăn, ăn ay mbơh nkoch ma bu lah, bân jêng rôh klô hŏ»”. ");
INSERT INTO cmo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Jêh ri kađăch Abimalĭch sŏ be biăp, sŏ ndrôk tă bơh phung mpômpa (siŭm) păng nơm, ndrel ma sŏ dâk bu ur dâk bu klô păng nơm ăn ma Abrahăm, nđâp ma mplơ̆ Sara i ur păng nơm ri nơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Kađăch nây lah ma Abrahăm: “Lŏng bri dak gâp ta dja, ah ntŭk may ŭch gŭ, dah may ŭch”. ");
INSERT INTO cmo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Păng lah đŏng ma Sara: “Dja prăk gâp du rbăn kăk prăk, gâp ăn ma nô ay, gay ma mpôl i gŭ ndrel ay nây gĭt n'hêl ay mâu ôh geh jan tih du ntil, gay ma bunuyh dâng lĕ gĭt n'hêl ay mâu ôh geh jan tih”. ");
INSERT INTO cmo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Nôk nây yor ma Sara i ur Abrahăm nây gŭ ta jay kađăch Abimalĭch, Brah Yêhôva ăn dâng lĕ bu ur i gŭ ta jay păng bah bă kon. Abrahăm mbơh sơm ăn ma Abimalĭch dăn ma Kôranh Brah, jêh ri Kôranh Brah jan ăn bah ji păng, ăn bah ji ur păng, ndrel ma lĕ dâk bu ur păng, jêh ri mpôl nây geh oh geh kon jât. ");
INSERT INTO cmo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Brah Yêhôva jan tâng nau Păng lĕ lah nơh, Păng ăn Sara geh kon ngăn kơt nau Păng lĕ ton. ");
INSERT INTO cmo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara ntreo ngăn, tât ta di nar Kôranh Brah lah, păng gŭ oh du huê kon bu klô ăn ma Abrahăm, nôk Abrahăm lĕ ranh ngăn jêh. ");
INSERT INTO cmo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Kon Sara deh ma Abrahăm nây, jêh ri Abrahăm tê̆ rnha «Isăk». ");
INSERT INTO cmo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Tât Isăk lĕ geh pham nar jêh deh, Abrahăm jan koh ntô ma păng, kơt nau Kôranh Brah de đă ma păng ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Nôk deh Isăk nây, Abrahăm lĕ geh 100 năm jêh. ");
INSERT INTO cmo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Nôk nây Sara lah: “Kôranh Brah jan ăn gâp jêng gơm, ndrel ma bu moh i tăng nau dja, bu jêng gơm ndrel ma gâp đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sara ngơi jât: “Bu moh bănh mbơh nkoch ma Abrahăm: «Geh du nar ur may mpu toh kon»? Lŏng aƀaơ ri gâp bă du huê kon bu klô ăn ma Abrahăm, dôl păng lĕ ranh ngăn”. ");
INSERT INTO cmo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Tât Isăk lĕ kuŏng oi, păng bah pu toh, jêh ri Abrahăm ndrăp nhêt dŭt kuŏng, nar kon se nây bah pu toh. ");
INSERT INTO cmo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara say Ismaêl i kon Hakar phung Êsip deh ăn ma Abrahăm gơm mưch ma Isăk i kon păng nơm, ");
INSERT INTO cmo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","jêh ri păng lah ma Abrahăm: “Mprơh lơi dâk bu ur nây, ndrel ma kon păng du lôh bơh ntŭk dja, iăt ma kon dâk bu ur i nây mâu ôh dơn sŏ drăp ndơ khlay ndrel kon gâp Isăk dja”. ");
INSERT INTO cmo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Nau ngơi nây jan ăn Abrahăm hô ngăn rngot ta nuih n'hâm păng ri, yorlah Ismaêl nây kon păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Yơn ma Kôranh Brah lah ma păng: “May lơi ta rngot ôh, yor ma kon se ndrel ma i me păng nây. Ăn may iăt moh nau Sara de lah, yorlah rnoi deh i Gâp ton ma may kơp ta Isăk. ");
INSERT INTO cmo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Yơn ma kon ur chông may nây, tay Gâp ăn păng jêng du phung geh bri dak đŏng, yorlah păng nơh rnoi deh may đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Tât ôi tay ri Abrahăm dâk ơm ôi, păng sŏ ndơ sông sa, ndrel ma nông dak ăn ma Hakar, pư dâng lĕ ndơ i nây ăn ta tong ko i mê̆ ri, đă păng hăn ndrel ma i kon păng. Jêh ri Hakar du lôh bơh ntŭk nây hăn nhhơt trong ta bri rdah tâm dăch đah ƀon Ƀêrsêƀa ri. ");
INSERT INTO cmo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tât lĕ dak ta nông ri, Hakar ntlơi i kon păng gŭ ta nâm du pŭm rlô, ");
INSERT INTO cmo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","jêh ri păng nơm gŭ ƀah ma kon păng ri, klăp lah ngai truyh pănh ma na, yorlah păng lah: “Lơi ăn gâp say khât kon gâp”. Jêh ri păng gŭ ƀah ma kon, ndri dâng păng nhŭm nter. ");
INSERT INTO cmo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Kôranh Brah tăng iăt ma kon bu klô nây nhŭm, jêh ri tông păr Kôranh Brah kuăl Hakar bơh kalơ trôk ntŭk Păng nơm: “Hơi Hakar, mơm jan ay rŭng răng ngăn nây heh? Ay lơi ôh rvê, yorlah Kôranh Brah lĕ tăng iăt kon i nây nhŭm nter bơh ntŭk Păng gŭ nây. ");
INSERT INTO cmo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ay dâk hŏm, hăn têk ti kon ay nây, yorlah tay gâp jan ăn păng jêng du phung kuŏng geh bri dak”. ");
INSERT INTO cmo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kôranh Brah jan ăn măt Hakar say du mlŏm ntu dak geh dak, păng dâk hăn bŭk dak i nây bêng nông, jêh ri ăn kon păng nhêt. ");
INSERT INTO cmo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Kôranh Brah gŭ ndrel ma kon bu klô i nây, păng gŭ rêh ta bri rdah ri n'ho ma tât kuŏng tât ndăm, păng jêng bunuyh blao pănh na dŭt blao ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Păng gŭ ta bri rdah Paran, jêh ri i mê̆ ri kơih bu ur phung Êsip du huê ma jêng ur păng. ");
INSERT INTO cmo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nôk nây kađăch Abimalĭch, ndrel ma Phikŭl i kôranh tahen kuŏng păng, păng lah ma Abrahăm: “Kôranh Brah gŭ ndrel may, dâng lĕ ntil ndơ may jan. ");
INSERT INTO cmo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Lah ndri ăn may ton ma gâp ta dja, ăn Kôranh Brah gĭt say, may lah mâu ndơm gâp, kon gâp, ndrel ma kon sau gâp. Yorlah gâp lĕ jan ueh jêh ma may, lah ndri ăn may jan ueh ma gâp, ndrel ma bri dak gâp i may gŭ dja ăn kơt nây đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahăm ơh ma kađăch: “Ơ, gâp ton”. ");
INSERT INTO cmo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Jêh ri Abrahăm lah ma păng du mlŏm ntu dak i phung ƀon lan păng in nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kađăch Abimalĭch ơh ma păng: “Gâp mâu gĭt ôh bu moh i jan kơt nây, yorlah may mâu prot nkoch ma gâp đŏng, tât nar dja mơ dâng gâp gĭt nau i nây”. ");
INSERT INTO cmo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abrahăm sŏ be biăp aƀă, ndrel ma ndrôk aƀă ăn ma kađăch Abimalĭch, jêh ri lĕ bar hê khân păng ri tâm rnglăp ndrel. ");
INSERT INTO cmo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahăm sŏ pơh ơ̆ be biăp i drôh drôh ăn gŭ êng. ");
INSERT INTO cmo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kađăch Abimalĭch ôp Abrahăm: “Pơh ơ̆ be biăp i drôh drôh may ăn gŭ êng nây moh jan?” ");
INSERT INTO cmo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahăm mbơh ma păng: “Pơh ơ̆ be biăp i dja, gâp ăn ma may ma ti gâp nơm, ndơ dja gay ma mbơh n'hêl nanê̆ lah, ntu dak nây lĕ gâp kuyh ngăn”. ");
INSERT INTO cmo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kơt ndri dâng bu kuăl ntŭk nây rnha «Ƀêrsêƀa», geh nau khlay jêng «Ntu dak pơh ndơ», mâu lah: «Ntu dak ton», yorlah ntŭk nây jêng ntŭk khân păng lĕ jêh tâm ton băl. ");
INSERT INTO cmo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kơt ndri nau khân păng lĕ tâm rnglăp băl ta Ƀêrsêƀa ri. Jêh ri kađăch Abimalĭch, ndrel ma kôranh tahen kuŏng păng ri, plơ̆ sât tay ta bri Phalihtin. ");
INSERT INTO cmo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Jêh ri Abrahăm tăm du mlŏm tơm si ta Ƀêrsêƀa nây, ta ntŭk nây đŏng n'ho ma păng yơk mbah Brah Yêhôva i Kôranh Brah i hôm gŭ rêh n'ho ro. ");
INSERT INTO cmo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahăm gŭ ta bri Phalihtin ri jŏ nar. ");
INSERT INTO cmo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Jêh geh nau nây, Kôranh Brah ŭch rlong nuih n'hâm Abrahăm, Păng kuăl Abrahăm: “Hơi Abrahăm!” Abrahăm ơh: “Moh Kôranh?” ");
INSERT INTO cmo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kôranh Brah lah ma păng: “Sŏ Isăk kon may nây i may rŏng ma păng dŭt hô, jêng kon bu klô may nơm nguai ơ̆ dơm nây, leo păng hăn ta bri Moriya. Ta ri ăn may pur nhhơr păng ăn ma Gâp ta kalơ yôk, ta du mlŏm yôk ntŭk Gâp mbơh ma may ri tay”. ");
INSERT INTO cmo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abrahăm dâk ơm ôi, păng chôk long ma pur ndơ nhhơr, păng sŏ dŭr tê̆ ta kalơ seh lia ri, jêh ri sŏ bar hê bu klô jan kar păng nơm, ndrel ma Isăk i kon păng nơm ri, hăn ndrel ma păng nơm jât ntŭk Kôranh Brah de mbơh ma păng ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tât brô̆ lĕ geh pe nar, Abrahăm n'gơr say ntŭk nây bơh ngai ");
INSERT INTO cmo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","jêh ri lah ma bar hê mpôl bunuyh jan kar nây: “Bar hê khân may dja ma gŭ chăm seh lia ta dja ƀŏt, gâp, ndrel ma kon gâp dja ma hao yơk mbah Kôranh Brah ta kalơ yôk ri, jêh dâng hên plơ̆ sât tay ta dja”. ");
INSERT INTO cmo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahăm kât long ma pur ndơ nhhơr ri ăn Isăk tui, păng nơm ri ndjôt ŭnh, ndrel ma pêh, jêh ri hăn lĕ bar hê bơ̆ kon a ri rơn drơn. ");
INSERT INTO cmo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Dôl nây Isăk ngơi đah i bơ̆ păng: “Hơi bơ̆” Abrahăm ơh: “Moh kon?” Isăk lah: “Ta dja bân lĕ geh ŭnh, lĕ geh pêh, lah ndri ah be biăp ndơ ma pur nhhơr?” ");
INSERT INTO cmo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahăm ơh: “Ơ kon, be biăp ndơ ma pur nhhơr i nây, Kôranh Brah nơm sơm ăn”. Jêh ri lĕ bar hê bơ̆ kon ri hăn jât năp rơn drơn jât. ");
INSERT INTO cmo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tât ta ntŭk Kôranh Brah de mbơh ma păng ri nơh, Abrahăm bun lŭ du ntŭk ta ntŭk nây ma ntŭk jan brah, jêh bun nây, păng bun long bơh lơ ri, păng nhŭp kât Isăk i kon păng nơm ri tê̆ bơh lơ long bơh lơ ntŭk jan brah ri ");
INSERT INTO cmo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","jêh ri păng sŏ pêh ntơm yat ti ma lăch tong ko i kon ri. ");
INSERT INTO cmo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Dôl nây dô ma tăng tông păr Brah Yêhôva de kuăl păng tă bơh lơ trôk ti lah: “Abrahăm! Abrahăm!” Păng ơh: “Moh Kôranh?” ");
INSERT INTO cmo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Tông păr nây lah: “Lơi may nkhât kon se nây, lơi ta lơh păng ôh, aƀaơ ri lĕ Gâp gĭt jêh may klach yơk ma Kôranh Brah, yorlah may mâu ôh nhhuach kon may nơm ơm nguai ơ̆ kôlơ̆ nây ăn ma Gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Jêh ri Abrahăm n'gâl say du mlŏm be biăp nkuŏng ta ri, văk khan nke ta tơm si. Jêh ri păng hăn sŏ be biăp i nây plăch ma pur nhhơr ntrŏ i kon păng nơm ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abrahăm kuăl ntŭk nây rnha: «Brah Yêhôva nơm sơm ăn», ndri dâng bu kuăl ntŭk nây tât aƀaơ ri rnha: «Ta kalơ yôk Brah Yêhôva, Păng nơm sơm ăn». ");
INSERT INTO cmo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Tông păr Brah Yêhôva kuăl tay Abrahăm bơh lơ trôk ti du tơ̆ jât ");
INSERT INTO cmo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Păng lah: “Gâp dja Brah Yêhôva, Gâp sŏ rnha Gâp Nơm ma ton, may mâu ôh nhhuach kon may nơm ơm nguai ơ̆ kôlơ̆ nây ăn ma Gâp. Yor ma may lĕ jan jêh kơt nây ");
INSERT INTO cmo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Gâp ăn geh jêng ma may dŭt ŏk, tay Gâp ăn nau geh jêng ma may ŏk bêng ler ngăn ngên, jêh ri jan rnoi deh may ăn ŏk bâk rơ̆ tâm ban ma mănh mbing ta kalơ trôk, mâu lah tâm ban ma choyh rŏ meng dak văch dak văr đŏng. Jêh ri rnoi deh may tay dơi mât uănh phung rlăng đah khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ndri dâng lĕ phung bunuyh ta neh ntu dja, bu geh jêng tă bơh rnoi deh may, yorlah may lĕ iăt jêh nau Gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Jêh nây Abrahăm, ndrel ma kon păng plơ̆ sât tay ta phung bu klô jan kar păng nơm ri nơh, jêh ri khân păng dâk hăn ndrel jât ƀon Ƀêrsêƀa ri. Tât ta Ƀêrsêƀa ri, Abrahăm gŭ ta ƀon nây. ");
INSERT INTO cmo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Jêh geh nau nây, geh bu hăn mbơh nkoch ma Abrahăm: “Lŏng Milka gŭ oh geh kon bu klô ŏk ngăn ăn ma Nahôr oh may, ta nây geh: ");
INSERT INTO cmo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uh jêng kon bôk dak, geh Ƀuh jêng i oh, geh Kêmôel i bơ̆ Aram ");
INSERT INTO cmo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","geh Kêset, geh Hasô, geh Pilđah, geh Yĭtlap, ndrel ma geh Ƀêthuel. ");
INSERT INTO cmo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ƀêthuel nây i bơ̆ bu ur Rêbêka. Lĕ pham nuyh kon i nây jêng Milka deh ma Nahôr i oh Abrahăm ri. ");
INSERT INTO cmo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Lŏng i ur chông Nahôr ri rnha Rêyôma, păng geh kon bu klô đŏng, ta nây geh: Thêpa, geh Kahăm, geh Thahah, ndrel ma geh Maka. ");
INSERT INTO cmo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara i ur Abrahăm rêh tât 127 năm, dah nây jêng ŏk năm păng rêh. ");
INSERT INTO cmo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Jêh ri păng khât ta ƀon Khĭriăt-Arƀa, i bu kuăl đŏng ƀon Hêbron, ta bri Kanan. Abrahăm nhŭm nđor Sara. ");
INSERT INTO cmo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Jêh ri păng dâk bơh ntŭk bunuyh khât nây, hăn ngơi đah ma phung Hêt: ");
INSERT INTO cmo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Gâp dja jêng phung bu năch bri êng, jêng bunuyh veh gŭ du ƀlât ta khân may dja. Lah ndri gâp dăn khân may tăch neh môch du ntŭk ăn ma gâp ta bri khân may dja, gâp be ma tŏp ur gâp. ");
INSERT INTO cmo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Phung Hêt ơh ma Abrahăm: ");
INSERT INTO cmo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ơ kôranh, dăn may iăt phung hên, may jêng bu kuŏng gŭ ta phung hên dja, dăn may tŏp ur may ta neh môch phung hên i dŭt ueh dô. Yorlah dâng lĕ phung hên mâu geh ôh du huê bunuyh buay may mâu ăn neh môch ma tŏp ur may”. ");
INSERT INTO cmo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Jêh ri Abrahăm dâk păn ta năp phung Hêt i bunuyh bri nây ");
INSERT INTO cmo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","păng lah ma phung nây: “Lah khân may ăn gâp tŏp ur gâp ta dja ri, dăn khân may sơm ngơi đah Êprŭn i kon Sôhar ăn ma gâp ");
INSERT INTO cmo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","dăn păng ăn trôm yôk Măkpêla bơh chông mir păng nây ăn ma gâp, dăn păng tăch ntŭk nây ăn gâp, ăn di khlay ta bơh năp khân may, ăn râng say râng tăng, gay ma ntŭk neh môch i nây jêng ntŭk gâp nơm ta phung khân may dja”. ");
INSERT INTO cmo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Lŏng Êprŭn i phung Hêt păng gŭ ndrel ma phung ƀon lan ta nây đŏng, păng lah ma Abrahăm ta năp phung ƀon lan păng nơm, ndrel ma ta năp dâng lĕ phung ƀon lan i gŭ ta bôk mpông ƀon nây, păng lah kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Mâu ôh kôranh, dăn may iăt gâp ƀŏt, neh mir, ndrel ma ntŭk trôm yôk nây gâp ăn ma may dadê, gâp ăn ntŭk nây ma may ta năp măt dâng lĕ phung ƀon lan gâp nơm. Ăn may tŏp ur may ta neh nây dô”. ");
INSERT INTO cmo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Jêh ri Abrahăm păn ta năp măt dâng lĕ phung ƀon lan ta bri nây du tơ̆ jât. ");
INSERT INTO cmo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Păng lah ma Êprŭn ta năp măt phung ƀon lan dâng lĕ: “Lah may ăn kơt ri, dăn may iăt gâp, gâp rvăt neh mir may nây ăn di khlay, dăn may sŏ khlay bơh gâp hŏm, gâp be ma tŏp ur gâp ta ntŭk nây”. ");
INSERT INTO cmo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Yơn ma Êprŭn ơh ma Abrahăm: ");
INSERT INTO cmo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ơ kôranh, khlay neh nây ta 400 kăk prăk dơm, prăk dah dja may ma gâp, bân mâu ôh kơp khlay, dăn may tŏp ur may nây”. ");
INSERT INTO cmo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Jêh ri Abrahăm iăt nau Êprŭn lah nây, păng njing prăk ăn ma Êprŭn ta năp măt phung ƀon lan Hêt tâm di khlay kơt nau păng lĕ lah ri nơh, tâm 400 kăk prăk, păng njing prăk i nây tâm di tâng nau vay khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Jêh ri neh mir Êprŭn ta ntŭk Măkpêla i mpeh bơh lôh nar ma ƀon Mămrê, lĕ ma neh mir, lĕ ma neh trôm yôk, ndrel ma lĕ tơm si ta mir nây ");
INSERT INTO cmo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","jêng ndơ Abrahăm dadê, nôk khân păng tâm ăn nây, ta nây geh phung ƀon lan Hêt, ndrel ma dâng lĕ phung ƀon lan i gŭ ta bôk mpông mpêr ƀon nây say dadê. ");
INSERT INTO cmo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Jêh ri Abrahăm tŏp Sara i ur păng ta trôm yôk mir Măkpêla, mpeh bơh lôh nar ma ƀon Mămrê, i bu kuăl đŏng ƀon Hêbron, ta bri Kanan nây. ");
INSERT INTO cmo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Neh mir, ndrel ma neh trôm yôk, dâng lĕ ntŭk i nây lĕ phung ƀon lan Hêt ăn jêh ma Abrahăm, jêng ntŭk neh môch. ");
INSERT INTO cmo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahăm lơ ma ranh ngăn, Brah Yêhôva lĕ ăn nau geh jêng ta lĕ ntil ndơ ma păng. ");
INSERT INTO cmo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Geh du nar ri Abrahăm lah ma bunuyh jan kar ma păng, bunuyh i ranh rlao bu gŭ ta jay păng, ndrel ma nơm i nây jêng bunuyh mât uănh dâng lĕ drăp ndơ păng đŏng, păng lah: “Ăn may tê̆ ti ta nâm tâm blu gâp dja ");
INSERT INTO cmo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","jêh ri ăn may ton ma Brah Yêhôva, i Kôranh Brah ma trôk, ndrel ma neh ntu, ăn may lah, may lơi ôh joi ur ăn ma kon gâp tă bơh bu ur phung Kanan ta ntŭk bri gâp gŭ dja. ");
INSERT INTO cmo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ăn may hăn ta ntŭk bri deh gâp nơm ri, jêh ri sơm joi ur tă bơh ndŭl mpôl gâp nơm ta nây ăn ma kon Isăk gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Bunuyh jan kar nây ơh ma păng: “Klăp lah bu ur nây mâu ŭch ôh hăn tâng gâp ta bri dja, lah ndri ăn gâp leo kon may hăn plơ̆ gŭ ta bri ntŭk bri may du lôh nây nơh bơh?” ");
INSERT INTO cmo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahăm lah ma păng: “May njrăng hŏ, gâp lah ma may, kon gâp mâu ôh ăn leo hăn ta bri nây! ");
INSERT INTO cmo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yorlah Brah Yêhôva i kôranh ta kalơ trôk lĕ leo jêh gâp du lôh bơh ndŭl mpôl gâp, bơh ntŭk bri deh gâp nơm, jêh ri Păng lĕ lah ma gâp, ndrel ma lĕ ton đŏng, n'hêl nanê̆ ngăn bri dja Păng ton ăn ma rnoi deh gâp. Lah ndri Păng đă tông păr Păng Nơm hăn bơh năp may ro gay ma kơl may, jêh ri ăn may sŏ ur ma kon gâp tă bơh bri nây. ");
INSERT INTO cmo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Yơn ma lah bu ur nây rlăch mâu ŭch hăn tâng may, may lĕ klaih jêh nau may ton dja ma gâp, iăt ma may lơi ôh leo kon gâp hăn ta bri nây”. ");
INSERT INTO cmo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Jêh ri bunuyh jan kar nây tê̆ ti ta tâm blu Abrahăm kôranh păng ri, n'ho ma păng ton nau nây đah Abrahăm. ");
INSERT INTO cmo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Jêh ri bunuyh jan kar nây sŏ seh samô jât ơ̆, ndrel ma ndjôt drăp ndơ geh nau khlay i kôranh ri ăn, păng hăn ta ƀon Nahôr bri Mêsôpôtamia ri. ");
INSERT INTO cmo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Hăn tât kêng du ntu dak ta bơh dih ƀon ri, păng ăn dâng lĕ seh samô păng ri drôm dadê, nôk nây bri lĕ kêng măng tâm di ma phung bu ur vay hăn brô̆ bŭk dak to. ");
INSERT INTO cmo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Bunuyh jan kar nây mbơh sơm: “Ơ Brah Yêhôva, i brah Abrahăm jêng kôranh gâp yơk mbah, nar dja dăn May kơl gâp, ăn gâp tâm mâp ma bu ur du huê ma jan ur Isăk. Dăn nhhơ hŏm nau rŏng răp jăp May i hôm nâng ma Abrahăm kôranh gâp. ");
INSERT INTO cmo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Gâp lĕ gŭ dăch kêng meng ntu dak dja jêh, lah tât phung kon bu ur ta ƀon dja hăn bŭk dak ");
INSERT INTO cmo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","lah bu moh bu ur drôh i gâp de lah: «Dăn dak ta rbŏng ay nây gâp be ma nhêt đê̆ yôh ơ», jêh ri lah păng ơh ma gâp: «Nhêt heh kônh, tay gâp bŭk dak ma ăn seh samô may nhêt đŏng», lah ndri dăn ăn tâm di ma bu ur i May lĕ ntrŏng ma jêng ur Isăk. Ndri dâng gâp gĭt ndơ nây n'hêl nanê̆ ngăn, jêng ndơ May nhhơ nau rŏng răp jăp May ăn ma kôranh gâp ngăn”. ");
INSERT INTO cmo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ê hŏ năn ôh lôch nau păng mbơh sơm nây, dô ma say Rêbêka lôh bơh ƀon nây, tê̆ nông rbŏng ta mlik păng nơm ri. Rêbêka nây i kon bu ur Ƀêthuel, Ƀêthuel i kon bu klô Milka, Milka i ur Nahôr oh Abrahăm nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rêbêka jêng bu ur ueh reh ngăn, hôm e drôh ê hŏ geh ôh đah bu klô. Păng hăn tât ta ntu dak nây, păng jŭr bŭk dak bêng nông rbŏng ri, jêh ri păng dâk sât. ");
INSERT INTO cmo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Bunuyh jan kar Abrahăm nây nchuăt ran jât păng ri, jêh ri lah: “Dăn dak ta rbŏng ay nây gâp be ma nhêt đê̆ yôh ơ”. ");
INSERT INTO cmo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Bu ur nây ơh: “Nhêt heh kôranh”. Bu ur nây juyh ro ăn păng nhêt. ");
INSERT INTO cmo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Jêh ăn păng nhêt ri, bu ur nây lah: “Tay gâp hăn bŭk dak ma ăn seh samô may nhêt ăn tât hơm đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Jêh ri păng nkhŭt dak ta bong ri ro, păng plơ̆ bŭk tay dak ma ăn seh samô ri nhêt tât hơm dadê. ");
INSERT INTO cmo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Bu klô i nây uănh jât păng ri rlŏl, păng mân êng ta nuih n'hâm ri ŭch gĭt, gĭt Brah Yêhôva jan ăn păng kơt nau păng ŭch nơh ngăn lah mâu. ");
INSERT INTO cmo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Dâng lĕ seh samô ri nhêt dak lĕ hơm dadê jêh, jêh ri păng sŏ du mlŏm rgên mayh jŏk du chi n'gul tê̆ ta trôm muh bu ur nây, sŏ đŏng bar mlŏm kông ti mayh jŏk 30 chi ăn ma bu ur drôh nây. ");
INSERT INTO cmo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Jêh ri păng ôp bu ur drôh nây: “Ay bu moh kon? Dăn mbơh ma gâp. Ah ta jay bơ̆ ay gĭt geh ntŭk hên de ma bêch măng dja?” ");
INSERT INTO cmo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Bu ur drôh nây ơh ma păng: “Gâp kon Ƀêthuel, i kon che Nahôr, ndrel ma u Milka”. ");
INSERT INTO cmo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Bu ur drôh nây lah tay ma păng: “Ta jay hên geh ŏk rhe ma seh samô bêch, ndrel ma rêp lĕ sơh ma mpa seh samô sa, ndrel ma ntŭk ma ăn khân may bêch geh đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Jêh ri bunuyh jan kar nây păng kŭnh bôk, yơk mbah ma Brah Yêhôva ");
INSERT INTO cmo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","păng lah: “Rnê ma Brah Yêhôva, i brah Abrahăm jêng kôranh gâp yơk mbah, May mâu rlun ôh ăn nau rŏng răp jăp May, May jan kơt nau May lĕ lah ƀaƀơ ma kôranh gâp, lŏng gâp dja Brah Yêhôva đŏng leo trong dâng tât ta jay ndŭl mpôl kôranh gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Jêh ri bu ur nây nchuăt a jay mê̆ păng, n'ho ma mbơh nkoch nau i nây ma dâng lĕ bunuyh ta jay nây. ");
INSERT INTO cmo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rêbêka geh du huê nô rnha Laƀan, Laƀan nchuăt joi bu klô nây a ntu dak ri ");
INSERT INTO cmo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","yorlah păng say kông ta ti đŏng, say rgên ta trôm muh đŏng, ndrel ma tăng Rêbêka i oh de mbơh nkoch dâng lĕ nau bu klô nây lah, jêh ri păng hăn mâp bu klô nây, say păng dâk kêng ntu dak ri ndrel ma seh samô. ");
INSERT INTO cmo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laƀan lah ma bu klô i nây: “Ơ bunuyh lĕ Brah Yêhôva de ăn geh jêng, lăp hŏm, moh gŭ may bơh dih dja? Lĕ jêh gâp ndrăp jay ma may, ndrel ma ntŭk ăn seh samô may đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Jêh ri bu klô i nây lăp a trôm jay ti. Laƀan drih njŭr ndoh ndơ bơh lơ seh samô ri phiao, bu sŏ ja sŏ rhe ma ăn seh samô de sa, ndrel ma sŏ dak ma ăn bu klô nây rao jŏng, nđâp ma mpôl i hăn ndrel păng nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Jêh ri bu lĕ ndrăp piăng trao ăn păng sông, yơn ma păng lah: “Gâp mâu hŏ ôh sông, lah nau gâp hăn dja gâp mâu hŏ mbơh nkoch ma khân may” Laƀan lah: “Neh, nkoch hŏm!” ");
INSERT INTO cmo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Păng lah: “Gâp dja jêng bunuyh jan kar Abrahăm. ");
INSERT INTO cmo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Brah Yêhôva ăn geh jêng ma kôranh gâp lĕ dŭt ŏk, n'ho ma păng tât jêng bunuyh ndrŏng ngăn, Kôranh Brah ăn păng geh be biăp, geh ndrôk, geh seh samô, geh seh lia, ndrel ma geh prăk, geh mayh, geh nđâp ma dâk bu ur dâk bu klô ŏk ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nôk kôranh gâp păng lĕ ranh ngăn, i ur păng rnha Sara gŭ oh du huê kon bu klô ma păng, kôranh gâp lĕ ăn jêh dâng lĕ drăp ndơ păng geh ma kon i nây. ");
INSERT INTO cmo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Kôranh gâp păng đă gâp ton iăt nau păng, păng lah: «May lơi ôh joi ur ma kon gâp tă bơh phung Kanan ntŭk bri gâp gŭ dja. ");
INSERT INTO cmo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ăn may hăn ta jay bơ̆ gâp, ta ndŭl mpôl gâp nơm ri, jêh ri sơm joi ur ma kon gâp tă bơh mpôl nây». ");
INSERT INTO cmo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Gâp lah ma kôranh gâp: «Klăp lah bu ur i nây mâu ŭch ôh tâng gâp ta bri dja». ");
INSERT INTO cmo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Păng lah ma gâp: «Brah Yêhôva i gâp de iăt ƀaƀơ, Păng ăn tông păr Păng Nơm hăn ndrel may, gay ma jan ăn may tât geh ngăn. Ăn may sơm joi ur ma kon gâp tă bơh ndŭl mpôl tă bơh rnăk vâl gâp. ");
INSERT INTO cmo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ăn may hăn tât ta ndŭl mpôl gâp ri, lah bu mâu ôh ăn kon ma may, ri mơ may mâu hôm ôh krêp đah nau lĕ jêh ton dja». ");
INSERT INTO cmo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Nar dja gâp hăn tât ta ntu dak, gâp mbơh sơm: «Ơ Brah Yêhôva, i brah Abrahăm jêng kôranh gâp yơk mbah, dăn May ăn geh ngăn ndơ i kôranh gâp đă ma gâp. ");
INSERT INTO cmo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Aƀaơ ri gâp lĕ gŭ dăch kêng ntu dak dja jêh, lah geh bu ur drôh hăn bŭk dak, lah gâp lah ma păng: «Ơ yôh, dăn dak ta rbŏng ay nây gâp be ma nhêt đê̆ ơ» ");
INSERT INTO cmo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Lah bu ur nây ơh: «Dja nhêt hŏm, tay gâp bŭk jât ma ăn seh samô may nhêt đŏng», lah ndri ăn tâm di ma bu ur i May lĕ jêh ntrŏng ma jêng ur i kon kôranh gâp ngăn». ");
INSERT INTO cmo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Nôk nây gâp mbơh sơm ê hŏ năn lôch ôh, dô ma say Rêbêka lôh bơh ƀon, tê̆ nông rbŏng ta mlik păng ri hăn a ntu dak. Jêh păng jŭr bŭk dak bêng, gâp lah ma păng: «Ơ yôh, dăn dak ay nây gâp be ma nhêt đê̆ ơ». ");
INSERT INTO cmo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Păng juyh nông rbŏng bơh mlik ri ro, păng lah ma gâp: «Dja nhêt hŏm, tay gâp bŭk jât dak ma ăn seh samô may nhêt đŏng». Jêh ri gâp nhêt dak i ri, păng bŭk tay dak ma ăn seh samô gâp nhêt đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Gâp ôp păng: «Ay bu moh kon?», păng ơh: «Gâp kon Ƀêthuel, i kon che Nahôr, ndrel ma u Milka». Jêh ri gâp sŏ rgên tê̆ ta trôm muh păng, ndrel ma kông ti ndok ta păng ri. ");
INSERT INTO cmo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Jêh ri gâp păn yơk mbah ma Brah Yêhôva, rnê ma Brah Yêhôva i brah Abrahăm jêng kôranh gâp yơk mbah, yor ma Păng sơm leo trong ma gâp dâng tât ta ndŭl mpôl kôranh gâp, ndrel ma say kon bu ur khân păng, gay ma sŏ jêng ur i kon kôranh gâp. ");
INSERT INTO cmo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Aƀaơ dja, lah khân may jan ueh, ndrel ma nau ngăn ma kôranh gâp, dăn khân may ngơi, ŭch mâu lah mâu, gay ma gâp gĭt đŏng, moh ndơ gâp jan jât”. ");
INSERT INTO cmo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Jêh ri Laƀan, ndrel ma Ƀêthuel lah ma păng: “Dâng geh jêng nau dja nơh tă bơh Brah Yêhôva, lah ndri hên mâu blao lah ŭch, mâu blao lah mâu ŭch ma may ri. ");
INSERT INTO cmo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nây Rêbêka lĕ ta nây, may ndjôt leo păng a ri, ma ăn đah kon kôranh may ri, kơt nau Brah Yêhôva de lah nây”. ");
INSERT INTO cmo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tât ma bunuyh jan kar Abrahăm tăng lah kơt nây, păng păn yơk mbah ma Brah Yêhôva . ");
INSERT INTO cmo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Jêh ri păng nglôh drăp ndơ nkrơ̆, prăk, mayh, ndrel ma bok ao ăn ma Rêbêka nây, păng ăn đŏng ndơ dŭt khlay ma mê̆ ma nô Rêbêka nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Jêh ri mơ dâng păng, ndrel ma mpôl i hăn đah păng nây nơh nhêt sông. Măng nây khân păng bêch ta nây, kah ôi tay ri ơm ôi păng dâk, păng lah ma phung tơm jay nây: “Dăn ăn gâp plơ̆ sât a kôranh gâp nơm nar dja yơ̆”. ");
INSERT INTO cmo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Yơn ma i nô, ndrel ma i mê̆ Rêbêka nây lah ma păng: “Ăn Rêbêka gŭ ndrel ma hên ta dja ƀŏt heh, klăp lah tât jât nar ƀŏt dâng hăn”. ");
INSERT INTO cmo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Bunuyh jan kar Abrahăm nây ơh ma khân păng: “Khân ay may lơi ôh kŏn gâp, ăn gâp plơ̆ sât ma kôranh gâp nơm, yorlah nau brô̆ hăn gâp dja lĕ Brah Yêhôva jan jêh phiao jêh”. ");
INSERT INTO cmo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Khân păng lah: “Kŏp hên kuăl Rêbêka, ôp păng nơm ƀŏt”. ");
INSERT INTO cmo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Jêh ri khân păng kuăl Rêbêka, ôp păng: “Oh, ay ŭch hăn ndrel ma păng dja bơh?” Rêbêka ơh: “Ơ, gâp ŭch”. ");
INSERT INTO cmo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Jêh ri ăn Rêbêka i oh bu ur păng ri, ndrel ma bunuyh sơm mpu toh păng nây, ăn hăn ndrel ma bunuyh jan kar Abrahăm, bu ăn khân păng hăn dadê ndrel ma lĕ bunuyh i hăn đah păng nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Rnăk vâl Rêbêka ăn nau geh jêng ma păng: “Ơ oh, ăn ay geh kon bâk rơ̆ ngăn Jêh ri rnoi deh ay ăn jêng kôranh ma phung rlăng đah khân păng”. ");
INSERT INTO cmo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Jêh ri Rêbêka, ndrel ma mpôl bu ur jan kar ma păng ncho seh samô hăn tâng bu klô i bunuyh jan kar Abrahăm hăn plơ̆ sât. ");
INSERT INTO cmo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Nôk khân păng hôm hăn rŏ trong, Isăk lĕ lôh bơh ntŭk rnha tu dak Lahairoi, păng gŭ ta bri rdah Nêkĭp. ");
INSERT INTO cmo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Nôk bri kêng măng, păng hăn pâl rŏ mir, păng ngơk say hăn n'hoch seh samô tât ta ri. ");
INSERT INTO cmo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rêbêka nây say đŏng, tât ma say Isăk ri, păng jŭr bơh lơ seh samô ");
INSERT INTO cmo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ôp bunuyh jan kar Abrahăm nây: “Bu moh i gŭ ta mir ri, hăn jât dja ri?” Păng ơh: “Păng i nây Isăk i kôranh gâp.” Ndri Rêbêka sŏ bok nkŭm lơi muh măt păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Bunuyh jan kar i nây mbơh nkoch ma Isăk dâng lĕ ntil ndơ păng jan ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Jêh ri Isăk sŏ Rêbêka jêng ur păng, păng leo Rêbêka lăp ta trôm chun Sara i mê̆ păng ri nơh, păng geh nuih n'hâm rŏng ma Rêbêka hô ngăn, n'ho ma bah nklŏn rvê i mê̆ păng khât ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahăm sŏ tay ur êng jât rnha Kĭtura. ");
INSERT INTO cmo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Bu ur nây gŭ oh kon bu klô ma păng, ta nây geh: Sâmran, geh Yŭksan, geh Mêđan, geh Miđiân, geh Ihƀăk, ndrel ma geh Sua. ");
INSERT INTO cmo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yŭksan i nây bă Sêƀa, ndrel ma Đêđan, i kon sau Đêđan nây dâng jêng geh phung Ahsơr, phung Lêtusim, ndrel ma phung Lêumim. ");
INSERT INTO cmo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","I kon sau Miđiân ri, ta nây geh: Êpha, geh Êphơr, geh Hanŭk, geh Aƀiđa, ndrel ma geh Elđa. Dâng lĕ phung i nây jêng kon sau Kĭtura dadê. ");
INSERT INTO cmo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Dâng lĕ ndơ Abrahăm geh, păng ăn ma Isăk dadê. ");
INSERT INTO cmo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Yơn ma nôk Abrahăm hôm rêh, păng ăn đŏng ndơ aƀă ma kon ur ur chông păng ri, păng ăn phung nây du ngai bơh Isăk, ăn khân păng gŭ a bri mpeh bơh lôh nar ri. ");
INSERT INTO cmo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahăm rêh, geh 175 năm. ");
INSERT INTO cmo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Păng rêh mpây lĕ jŏ ngăn, nđâp ma lĕ ranh ngăn đŏng, jêh ri păng roh n'hâm khât hăn gŭ ndrel ma phung che păng. ");
INSERT INTO cmo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Jêh ri kon păng Isăk, ndrel ma Ismaêl tŏp păng ta trôm yôk Măkpêla mpeh bơh lôh nar ma ƀon Mămrê, ta mir Êprŭn i kon Sôhar phung Hêt. ");
INSERT INTO cmo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","I nây jêng mir Abrahăm de rvăt tă bơh phung Hêt nơh, ta nây bu tŏp Abrahăm, tŏp ndrel ta ntŭk păng tŏp Sara nơh. ");
INSERT INTO cmo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Jêh khât Abrahăm ri, Kôranh Brah ăn geh jêng ma Isăk kon păng ri, Isăk hăn gŭ dăch kêng tu dak Lahairoi. ");
INSERT INTO cmo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Dja jêng nkoch yao deh kon sau Ismaêl, i kon Abrahăm, jêng kon Hakar bu ur phung Êsip i dâk Sara bă ăn ma Abrahăm. ");
INSERT INTO cmo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Dja jêng rnha kon bu klô Ismaêl, rnha tâng bu moh deh lor, bu moh deh bơh kơi, kon bôk dak Ismaêl rnha Nêƀayôt, jêh ri i oh oh rnha Kêđar, rnha Ătƀel, rnha Mipsam, ");
INSERT INTO cmo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","rnha Mihma, rnha Đuma, rnha Masa, ");
INSERT INTO cmo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","rnha Hađăt, rnha Thêma, rnha Yêthur, rnha Naphih, ndrel ma rnha Kêtma. ");
INSERT INTO cmo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Dâng lĕ kon Ismaêl i nây, i nây rnha khân păng tâng ƀon tâng ntŭk khân păng gŭ, dâng lĕ 12 nuyh nây jêng kôranh ta ndŭl mpôl khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaêl rêh geh 137 năm, jêh ri păng roh n'hâm khât gŭ ndrel ma phung che păng. ");
INSERT INTO cmo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Bri phung kon sau Ismaêl gŭ, ntơm bơh bri Havila, tât a bri Sur dăch ma bri Êsip mpeh ma bri Asơr. Phung kon sau Ismaêl khân păng gŭ tâm lơh ndrăng oh nô khân păng nơm nâng. ");
INSERT INTO cmo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Dja nau nkoch yao Isăk kon Abrahăm: Abrahăm bă Isăk. ");
INSERT INTO cmo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Tât Isăk lĕ geh 40 năm, păng sŏ Rêbêka jêng ur. Rêbêka nây i kon Ƀêthuel i oh Laƀan, Ƀêthuel nây phung Aram gŭ ta bri Pađan-Aram. ");
INSERT INTO cmo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isăk mbơh sơm ma Brah Yêhôva, yorlah ur păng nây jêng bu ur mâu ôh bă kon, Brah Yêhôva iăt nau păng mbơh sơm, jêh ri ur păng ntreo. ");
INSERT INTO cmo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kon ta trôm ndŭl Rêbêka geh bar ơ̆ tâm thăk băl, păng lah: “Mơm dâng jêng kơt ndri chrao?” Jêh ri păng ôp Brah Yêhôva. ");
INSERT INTO cmo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Brah Yêhôva lah ma păng: “Ay geh bar ơ̆ bri dak gŭ ta trôm ndŭl ay nây Ay deh geh bar ơ̆ phung tă bơh ndŭl ay i tâm rdâng băl Du phung jêng dăng rlao đah ma du phung Kon bôk dak jêng plăch sơm kơl jan kar ăn ma i oh”. ");
INSERT INTO cmo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tât ăp khay ri, păng gŭ oh geh kon bar ngăn, kon bu klô dadê. ");
INSERT INTO cmo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kon i bôk dak ri săk păng dŭm ngăn, geh rsau tâm ban ma rsau mpômpa (siŭm), bu tê̆ rnha «Êsao». ");
INSERT INTO cmo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Jêh ri i oh lôh đŏng, ti păng kuăn kăr nhơn ta jŏng Êsao ri, kơt ndri dâng bu tê̆ rnha «Yakôp», geh nau khlay lah «Kuăn kăr nhơn ta jŏng». Nôk gŭ oh nây Isăk lĕ geh 60 năm. ");
INSERT INTO cmo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Jêh ri i kon păng bar ơ̆ ri tât kuŏng tât ndăm, Êsao jêng bunuyh bren pănh puăch, păng hô ngăn brô̆ bri. Lŏng Yakôp ri, jêng bunuyh gŭ rmưyh dơm, păng gŭ dăch ta chun bok ri chiăp be biăp. ");
INSERT INTO cmo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isăk rŏng ma Êsao hô ngăn, yorlah păng rŏng sa puăch Êsao de pănh, yơn ma Rêbêka rŏng ma Yakôp. ");
INSERT INTO cmo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Geh du nar Yakôp gŭ gŏm trao, Êsao sât bơh ndrĭch ri păng huăr ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Păng lah ma Yakôp: “Dăn pă gâp đê̆ trao dŭm i jan ma tôh may nây gâp be ma sa, lĕ hô ngăn huăr gâp ta ri!” (Kơt ndri dâng bu kuăl păng «Êđŏm», yorlah geh nau khlay «Dŭm».) ");
INSERT INTO cmo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakôp lah ma păng: “Plăch ăn ma gâp nau khlay may jêng kon bôk dak nây mơ”. ");
INSERT INTO cmo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Êsao ơh ma păng: “Gâp ta ri lĕ bơi ma khât ngăn, moh hôm khlay jêng kon bôk dak?” ");
INSERT INTO cmo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakôp lah tay ma păng: “Lah ndri may ton ăn ma gâp lor ƀŏt”. Jêh ri Êsao ton plăch ăn ma Yakôp nau khlay jêng kon bôk dak nây. ");
INSERT INTO cmo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yakôp sŏ nŭmpăng, ndrel ma trao tôh dŭm păng gŏm nây ăn ma Êsao sông. Êsao nhêt sông ndơ Yakôp ăn nây, jêh ri dâk du bơh ntŭk nây. Kơt ndri păng lĕ mưch jêh nau khlay ta săk păng nơm jêng kon bôk dak ri. ");
INSERT INTO cmo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nôk nây geh nau ji sŏt ji ngot kuŏng ta bri nây du tơ̆ jât, tâm ban ma lĕ geh ta rnôk Abrahăm nơh đŏng. Ndri Isăk hăn ta ƀon Kêrar, gay ma dăn gŭ ndrel kađăch Abimalĭch, jêng kađăch phung Phalihtin. ");
INSERT INTO cmo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Jêh ri Brah Yêhôva tâm mpơl ma Isăk, lah ma păng: “May lơi ôh du ta bri Êsip, ăn may gŭ ta ntŭk bri Gâp mbơh ma may hŏ. ");
INSERT INTO cmo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ăn may gŭ ta bri i mâu ôh di bri may nơm dja hŏ, Gâp mra gŭ ndrel ma may, Gâp mra ăn geh jêng ma may, Gâp mra ăn dâng lĕ bri dja ma may n'ho ma tât kon tât sau may, Gâp mra jan ngăn kơt nau Gâp lĕ ton ma Abrahăm bơ̆ may nơh. ");
INSERT INTO cmo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Gâp mra ăn kon sau may bâk rơ̆ ŏk tâm ban ma mănh kalơ trôk, Gâp mra ăn dâng lĕ bri dak dja ma kon sau may, jêh ri dâng lĕ bunuyh lam neh ntu dja bu mra sŏ dơn geh jêng yor ma tă bơh kon sau may dadê. ");
INSERT INTO cmo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Gâp mra jan dâng lĕ ndơ i nây, yorlah Abrahăm iăt nau Gâp nơh, păng jan tâng nau Gâp đă Gâp lah, ndrel ma jan tâng nau vay Gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Jêh ri Isăk gŭ ta ƀon Kêrar nây. ");
INSERT INTO cmo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Lah bunuyh ta ƀon nây ôp păng ma nau ur păng nây: “Bu moh bu ur dja?” Păng mbơh ma bu lah: “Oh gâp”. Păng mâu ôh bănh mbơh ma bu lah ur păng, yorlah păng gĭt lah: “Gâp klach bu klô ta ƀon dja nkhât gâp, gay ma sŏ ur gâp, yorlah ur gâp uănh ueh reh ngăn”. ");
INSERT INTO cmo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Tât păng gŭ ta ƀon nây lĕ jŏ ngăn, geh du nar kađăch Abimalĭch jêng kađăch phung Phalihtin, păng uănh bơh mpông bloh ri, say Isăk ndrel ma Rêbêka i ur ri tâm ut tâm lôr. ");
INSERT INTO cmo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Jêh ri kađăch Abimalĭch đă bu kuăl Isăk, lah păng: “Păng ur may ngăn, mơm dâng may lah «Păng oh gâp»?” Isăk ơh: “Dâng gâp lah kơt nây, yorlah gâp klach bu nkhât yor ma ur gâp nây”. ");
INSERT INTO cmo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kađăch Abimalĭch lah ma păng: “Moh dâng may jan ma hên kơt nây? Lah geh du huê ta phung ƀon lan gâp bêch ndrel ma ur may, lah ndri may nsŭk phung hên jêng tih”. ");
INSERT INTO cmo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Jêh ri kađăch Abimalĭch mbơh dâng lĕ phung ƀon lan, păng lah kơt nđa: “Bu moh jan djơh bu klô dja, mâu lah i ur păng, nkhât lơi bunuyh nây”. ");
INSERT INTO cmo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isăk gŭ tuch tăm ta bri nây, tât păng kăch păng rek păng geh rhiăng, yorlah Brah Yêhôva ăn geh jêng ma păng. ");
INSERT INTO cmo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Jêh ri tât păng ndrŏng, tât păng geh drăp ndơ lơ ma ŏk n'ho ma jêng bunuyh dŭt ndrŏng ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Păng geh be biăp, geh ndrôk ŏk ngăn, ndrel ma geh bunuyh sơm kơl jan kar ŏk đŏng, kơt ndri phung Phalihtin mâu nach ma ôbăl. ");
INSERT INTO cmo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Dâng lĕ ntu dak mpôl sơm kơl jan kar bơ̆ păng Abrahăm kuyh rnôk Abrahăm hôm rêh nơh, phung Phalihtin brôi lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Jêh ri kađăch Abimalĭch lah Isăk: “May du bơh ntŭk dja hŏm, yorlah may geh bunuyh geh drăp ndơ dŭt ŏk rlao hên”. ");
INSERT INTO cmo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Jêh ri Isăk du bơh ntŭk nây hăn gŭ ta njŏng yôk Kêrar, tê̆ chun bok gŭ ta ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isăk đă bu kuai tay dâng lĕ ntu dak Abrahăm i bơ̆ de kuyh ri nơh, yorlah lĕ phung Phalihtin de brôi lơi dadê jêh khât Abrahăm nây nơh, Isăk tê̆ tay rnha dâng lĕ ntu dak i nây tâng kơt rnha i bơ̆ păng lĕ tê̆ nơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Mpôl sơm kơl jan kar Isăk kuyh du ntu dak ta njŏng yôk nây, geh dak lôh hoch nâng bơh ntu i nây. ");
INSERT INTO cmo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Yơn ma phung chiăp ta bri Kêrar nây tâm lŏk đah phung chiăp Isăk, phung nây lah: “Dja jêng ntu dak hên” jêh ri Isăk tê̆ rnha ntu nây «Êsêk», geh nau khlay lah «Nau tâm rlăch», yorlah phung nây lĕ tâm lŏk đah păng. ");
INSERT INTO cmo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Mpôl sơm kơl jan kar Isăk kuyh tay du mlŏm ntu dak jât, yơn ma phung chiăp tâm lŏk đah păng đŏng, ndri Isăk tê̆ rnha ntu dak nây «Sĭtna», geh nau khlay lah «Tâm rdâng». ");
INSERT INTO cmo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Jêh ri păng du ntŭk êng, păng kuyh tay du mlŏm ntu dak jât, ntu dak nây mâu hôm ôh say bu tâm pit, ndri dâng păng tê̆ rnha ntu dak nây «Rêhôƀôt», geh nau khlay lah «Huy», păng lah: “Aƀaơ dja Brah Yêhôva lĕ ăn ntŭk huy ma hên jêh, ăn hên geh drăp ndơ ndrŏng ta bri dja”. ");
INSERT INTO cmo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Jêh ri păng du bơh ntŭk nây hăn gŭ ta ƀon Ƀêrsêƀa. ");
INSERT INTO cmo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ta măng nây Brah Yêhôva tâm mpơl ma păng, lah ma păng kơt nđa: “May lơi ôh klach, yorlah Gâp gŭ ndrel may, Gâp dja i brah Abrahăm bơ̆ may yơk mbah nơh, Gâp ăn geh jêng ma may, Gâp jan ăn may geh kon geh sau bâk rơ̆, yorlah Abrahăm nơh i bunuyh sơm kơl jan kar ma Gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Jêh ri păng jan du ntŭk ma jan brah ta ntŭk nây, păng yơk mbah Brah Yêhôva ta ntŭk nây. Păng tê̆ chun bok păng nơm gŭ ta ntŭk nây, jêh ri mpôl sơm kơl jan kar păng kuyh ntu dak ta ntŭk nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Geh du nar kađăch Abimalĭch hăn mâp Isăk, hăn ndrel păng geh Ahusat jêng bunuyh kơl păng, ndrel ma Phikŭl jêng kôranh tahen păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isăk lah ma kađăch nây: “Moh nau khân may hôm ŭch hăn mâp gâp, yorlah khân may lĕ biănh mprơh gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kađăch Abimalĭch lah ma Isăk: “Lĕ hên gĭt Brah Yêhôva gŭ ndrel may ngăn, kơt ndri hên mân, hên ŭch ăn bân tâm ton tâm rnglăp ndrel. ");
INSERT INTO cmo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ăn may ton ma hên, may mâu lơh djơh ma hên, kơt hên mâu lơh djơh ma may, jan ndơ ueh dơm ma may, lĕ ăn may sât đăp mpăn nơh, aƀaơ dja may lĕ Brah Yêhôva de ăn geh jêng đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isăk ndrăp nhêt sa kuŏng ăn ma kađăch, ndrel ma lĕ phung i hăn ndrel păng nây, jêh ri khân păng nhêt sông sa ndrel ta ri dadê. ");
INSERT INTO cmo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tât ôi tay, khân păng dâk ơm ôi tâm ton băl, jêh ri Isăk njŭn kađăch Abimalĭch, ndrel ma phung i hăn ndrel păng nây sât, khân păng sât đăp mpăn. ");
INSERT INTO cmo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ta nar nây đŏng, mpôl sơm kơl jan kar ma Isăk hăn mbơh ma păng ntu dak i khân păng mhe kuyh nây nơh, khân păng lah: “Ntu hên kuyh nơh lĕ geh dak”. ");
INSERT INTO cmo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isăk tê̆ rnha ntu dak nây «Sipa», geh nau khlay lah «Nau ton», ndri dâng bu ntơ ƀon nây «Ƀêrsêƀa», geh nau khlay lah «Ntu dak ton», n'ho ma tât aƀaơ dja. ");
INSERT INTO cmo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Tât Êsao lĕ geh 40 năm, păng sŏ ur bar bơh phung Hêt, du huê rnha Yuđit i kon Ƀêri, i du huê rnha Ƀahmat i kon Êlôn. ");
INSERT INTO cmo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Lĕ bu ur bar hê nây jan ăn Isăk, ndrel ma Rêbêka rngot ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Tât Isăk lĕ ranh ngăn, măt păng ngo uănh mâu hôm ôh say. Păng kuăl Êsao kon bôk dak păng ri: “Hơi nô” Êsao ơh: “Moh bơ̆!” ");
INSERT INTO cmo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Bơ̆ păng lah: “Gâp dja lĕ ranh, mâu gĭt nar khât. ");
INSERT INTO cmo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Lah ndri may sŏ ndơ may vay pănh, na đut hăr dâng kăm, hăn a bri pănh puăch ăn ma gâp. ");
INSERT INTO cmo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","May jan trao puăch nây ăn dŭt kah ma gâp, ăn di ko gâp vay sa, gâp be ma sông, jêh ri dâng gâp ăn geh jêng ma may, ê lor ma gâp khât”. ");
INSERT INTO cmo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Jêh ri Êsao hăn a bri ri, joi pănh puăch ma ăn i bơ̆ păng. Nôk Isăk ngơi ma Êsao kon păng nây nơh, Rêbêka tăng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Jêh ri Rêbêka mbơh ma Yakôp kon păng nây: “Gâp tăng bơ̆ may lah ma Êsao nô may kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","«Pănh puăch ăn ma gâp, jêh ri jan trao ăn dŭt kah ma gâp, ăn di ko gâp vay sa, gâp be ma sông, jêh ri dâng gâp ăn geh jêng ma may ta năp măt Brah Yêhôva, ê lor ma gâp khât». ");
INSERT INTO cmo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Lah ndri ơ nô, may iăt nau gâp, jan tâng nau gâp đă ma may. ");
INSERT INTO cmo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","May hăn ta be biăp phung ri, jêh ri sŏ bar ơ̆ kon be i ueh ueh ăn ma gâp, gâp be ma jan trao ăn dŭt kah, ăn di ko bơ̆ may vay sa. ");
INSERT INTO cmo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","May ndjôt trao nây njŭn ăn bơ̆ may sa, gay ma păng ăn geh jêng ma may, ê lor ma păng khât”. ");
INSERT INTO cmo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yơn ma Yakôp ơh ma mê̆ păng: “Êsao nô gâp, păng geh rsau lam săk, lŏng gâp mâu ôh geh rsau. ");
INSERT INTO cmo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Klăp lah bơ̆ gâp păng but gâp, jêh ri gĭt gâp jêng bunuyh ndơm păng, lah ndri gâp mâu ôh geh sŏ dơn geh jêng tă bơh bơ̆ gâp, geh nkhơng nau rtăp chrao”. ");
INSERT INTO cmo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mê̆ păng lah: “Ơ nô, ăn nau rtăp nây geh ta gâp, ăn may jan tâng nau gâp, hăn sŏ hŏm be leo a gâp dja”. ");
INSERT INTO cmo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jêh ri Yakôp hăn sŏ be njŭn ăn mê̆ păng, mê̆ păng jan trao ăn dŭt kah, ăn di ko i bơ̆ păng vay sa. ");
INSERT INTO cmo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Jêh ri mê̆ păng sŏ ao Êsao, ao i dŭt ueh i geh ta jay Rêbêka nơm ri, sơm nsoh ăn ma Yakôp i oh păng nây. ");
INSERT INTO cmo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Păng sŏ đŏng rsau be put ta glăn ti, ndrel ma ta tong ko Yakôp ri. ");
INSERT INTO cmo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Jêh bơh nây mê̆ păng ri sŏ trao puăch dŭt kah, ndrel ma nŭmpăng i pre lĕ jêh jan ri nơh, ndơ̆ ăn Yakôp ndjôt. ");
INSERT INTO cmo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jêh ri Yakôp njŭn piăng trao nây ma bơ̆ păng, păng lah: “Hơi bơ̆!” Isăk ơh: “Gâp ta dja, bu moh may ri ơ nô?” ");
INSERT INTO cmo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakôp ơh: “Gâp heh bơ̆, gâp Êsao kon bôk dak may heh, lĕ jêh gâp jan tâng nau may đă ma gâp nơh, dâk hŏm, sa puăch i gâp be pănh tă bơh bri dja ƀŏt, jêh ri dâng may ăn geh jêng ma gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isăk ôp păng: “Ơ nô, mơm dâng ngăch geh pănh mre ri?” Yakôp ơh: “ Brah Yêhôva i brah may yơk mbah sơm kơl ăn gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isăk lah ma Yakôp: “Ơ nô, may hăn dăch a gâp dja đê̆ gâp be ma but, gay ma gĭt n'hêl may kon gâp Êsao ngăn lah mâu”. ");
INSERT INTO cmo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakôp hăn dăch a bơ̆ păng ri, jêh ri bơ̆ păng but, păng lah: “Ti dja jêng ti Êsao ngăn, tih ma ngơi ri ngơi Yakôp”. ");
INSERT INTO cmo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isăk mâu ôh gĭt năl Yakôp, yorlah i ti păng ri geh rsau tâm ban ma ti Êsao đŏng. Yơn ma ê lor păng ăn geh jêng ma Yakôp, ");
INSERT INTO cmo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","păng ôp n'hêl: “May Êsao kon gâp ngăn bơh?” Yakôp ơh: “Ơ gâp ngăn”. ");
INSERT INTO cmo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isăk lah ma kon păng: “Pư trao puăch ăn dăch kêng gâp dja, gâp be ma sa puăch i may pănh nây ƀŏt nô, tay dâng gâp ăn geh jêng ma may”. Yakôp pư trao puăch ăn bơ̆ păng sa, păng kêt đŏng ndrănh play yŭng yar ƀon ăn bơ̆ păng nhêt. ");
INSERT INTO cmo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Jêh ri Isăk bơ̆ păng ri lah ma kon păng: “Ơ nô, may hăn dăch a dja chŭm gâp ƀŏt”. ");
INSERT INTO cmo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakôp hăn dăch chŭm i bơ̆ păng ri, i bơ̆ păng ri năl ƀô nglŭm bok ao Êsao, jêh ri păng ăn geh jêng ma Yakôp, păng lah: “Ƀô nglŭm kon gâp ri jêng ƀô nglŭm mir Brah Yêhôva de lĕ ăn geh jêng. ");
INSERT INTO cmo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Dăn Kôranh Brah ăn ma may geh dak rngêt tă bơh kalơ trôk Ndrel ma ăn neh kah ma may đŏng. Dăn Kôranh Brah ăn may geh ba, ndrel ma ăn may geh ndrănh play yŭng yar ƀon dŭt ŏk. ");
INSERT INTO cmo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Dăn Păng ăn phung bunuyh êng êng ăn sơm kơl jan kar ma may. Dăn Păng ăn bunuyh bri dak êng êng kŭnh bôk yơk ma may. Dăn Păng ăn may jêng kôranh ma oh nô du ndŭl deh may nơm. Dăn Păng ăn oh nô du ndŭl deh ma may kŭnh bôk yơk ma may. Bu moh păng i rtăp may ăn Kôranh Brah rtăp ma păng. Bu moh păng i ăn geh jêng ma may ăn Kôranh Brah ăn geh jêng ma păng đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Lĕ jêh Isăk ăn geh jêng ma Yakôp, ndŭt Yakôp du lôh bơh bơ̆ păng nây, Êsao sât pănh puăch bơh bri ri. ");
INSERT INTO cmo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Păng jan trao dŭt kah njŭn ăn bơ̆ păng đŏng, păng lah ma bơ̆ păng: “Hơi bơ̆, dâk hŏm, sa puăch gâp be i pănh dja ƀŏt, jêh ri dâng may ăn geh jêng ma gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isăk bơ̆ păng ri ôp: “Bu moh may ri?” Êsao ơh: “Gâp Êsao heh bơ̆, kon bôk dak may heh”. ");
INSERT INTO cmo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isăk nsŏr săk dŭt hô, păng ôp: “Lah ndri bu moh ndjôt puăch ăn ma gâp ndơh nơh? Bơh năp may nơh a pơ, gâp sa puăch păng lĕ phiao, jêh ri gâp ăn geh jêng ma păng. Kôranh Brah mra ăn geh jêng nây ma păng n'ho ro ngăn”. ");
INSERT INTO cmo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tât Êsao tăng nau bơ̆ păng lah nây, păng nter dŭt dăng, nđâp ma rngot hô ngăn, păng lah ma bơ̆ păng: “Ơ bơ̆, ăn geh jêng ma gâp đŏng ơ!” ");
INSERT INTO cmo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isăk ơh ma păng: “Oh may păng brô̆ ndơm, jêh ri pit lơi geh jêng may”. ");
INSERT INTO cmo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Êsao lah: “Di ngăn bu tê̆ rnha păng «Yakôp» nây, yorlah păng pit lơi ndơ gâp lĕ bar tơ̆ ma dja jêh, du tơ̆ păng pit nau khlay kon bôk dak gâp, aƀaơ dja păng pit đŏng geh jêng gâp jât. Ơ bơ̆, lah ndri may mâu rong geh jêng ma ăn gâp đŏng?” ");
INSERT INTO cmo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isăk lah ma Êsao: “Lĕ gâp ăn păng jan kôranh may jêh, jêh ri lĕ phung oh nô păng, lĕ gâp ăn khân păng sơm kơl jan kar ma păng dadê. Ba, ndrel ma play yŭng yar ƀon lĕ gâp ăn ma păng đŏng, lah ndri mă ndơ gâp ăn ma may?” ");
INSERT INTO cmo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Êsao ôp bơ̆ păng: “Ơ bơ̆, may geh du nây dơm geh jêng may? Pă gâp đŏng geh jêng may bơ̆ ơ”. Nôk nây Êsao nhŭm nter ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isăk bơ̆ păng ri lah ma păng: “May tay gŭ ta ntŭk neh sŏt Dak rngêt tă bơh kalơ trôk mâu geh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","May tay rêh siăm săk ma đao may nơm Ndrel ma gŭ sơm kơl jan kar ma oh may nơm. Yơn ma geh du nar, may mra klaih bơh oh may Mƀăr lơi mŏng mbăk păng ta tong ko may”. ");
INSERT INTO cmo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Êsao ji nuih Yakôp dŭt hô ngăn, yor ma nau geh jêng bơ̆ păng ăn nây lĕ Yakôp sŏ. Êsao lah êng ta nuih n'hâm păng ri: “Nar nhŭm rngot bơ̆ gâp khât bơi ma tât, nôk nây tay dâng gâp nkhât lơi păng”. ");
INSERT INTO cmo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Geh bu hăn mbơh ma Rêbêka nau Êsao kon bôk dak păng lah nây, jêh ri Rêbêka đă bu hăn kuăl Yakôp i oh ri, mbơh ma păng: “Êsao nô may, păng ŭch plơng ma may, ŭch nkhât lơi may. ");
INSERT INTO cmo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ơ nô, aƀaơ dja may iăt nau gâp, may nchuăt ta ƀon Charan, gŭ a nô gâp Laƀan ri dô. ");
INSERT INTO cmo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ăn may gŭ ndrel păng jŏ oi, tât nô may nđik nuih ƀŏt. ");
INSERT INTO cmo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tât păng bah nuih ma may, lĕ chuêl nau may jan ma păng nơh, tay dâng gâp đă bu hăn mbơh may plơ̆ sât tay ta dja, yorlah gâp mâu ŭch ôh say khân may khât lĕ bar hê du nar”. ");
INSERT INTO cmo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rêbêka lah ma Isăk: “Gâp dâl ngăn ma măn bu ur phung Hêt dja, lah Yakôp sŏ ur phung Hêt ta bri dja đŏng, gâp mâu hôm ŭch ôh rêh”. ");
INSERT INTO cmo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ndri Isăk kuăl Yakôp, păng ăn geh jêng ma kon păng nây, jêh ri buay păng: “May lơi ôh sŏ ur tă bơh kon bu ur phung Kanan dja. ");
INSERT INTO cmo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","May hăn ta bri Pađan-Aram, ta jay Ƀêthuel che i bơ̆ mê̆ may ri, may sŏ ur đah kon va Laƀan i nô mê̆ may nây hŏ. ");
INSERT INTO cmo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Dăn Kôranh Brah nơm i dŭt geh nau dơi ăn geh jêng ma may, jan ăn may geh oh geh kon bâk rơ̆ ăn dŭt ŏk, jêh ri ăn rnoi deh may jêng ŏk phung bunuyh êng êng. ");
INSERT INTO cmo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Dăn Kôranh Brah ăn ma may geh jêng i Kôranh Brah de ăn ma bơ̆ gâp Abrahăm nây nơh, ndrel ma tât kon tât sau may đŏng, gay ma bri i may veh gŭ dja jêng ndơ may, yorlah bri dja lĕ Kôranh Brah de ăn ma bơ̆ gâp Abrahăm nơh”. ");
INSERT INTO cmo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Jêh ri Isăk ăn Yakôp hăn, ndri păng hăn ta bri Pađan-Aram, hăn ta jay Laƀan kon Ƀêthuel phung Aram, jêng i nô Rêbêka nơm i mê̆ Yakôp, ndrel Êsao. ");
INSERT INTO cmo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Êsao say Isăk ăn geh jêng ma Yakôp, ndrel ma đă păng hăn sŏ ur ta bri Pađan-Aram, ntĭnh păng mâu ôh ăn păng sŏ ur đah phung bu ur Kanan, ");
INSERT INTO cmo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","say Yakôp iăt nau mê̆ bơ̆ hăn ta bri Pađan-Aram ri. ");
INSERT INTO cmo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tât Êsao gĭt jêh i bơ̆ păng mâu tâm di ma bu ur phung Kanan, ");
INSERT INTO cmo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","jêh ri păng hăn ta Ismaêl kon Abrahăm, sŏ ur nguai jât đah kon Ismaêl ri, păng sŏ Mahalat i oh Nêƀayôt, păng geh ur pe. ");
INSERT INTO cmo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakôp du bơh ƀon Ƀêrsêƀa hăn ta ƀon Charan. ");
INSERT INTO cmo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Păng hăn tât ta du ntŭk, jêh ri păng rlu ta ntŭk nây, yorlah nar lĕ nhŏp, păng sŏ du mlŏm lŭ ta ntŭk nây ma dŏm bôk, jêh ri păng bêch hăk khêr. ");
INSERT INTO cmo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Păng mbơi geh du mlŏm ntung gung rdŏk ta neh, i chông ntung gung nây ndăl tât a trôk ri, jêh ri geh phung tông păr Kôranh Brah brô̆ nsong jŭr hao rŏ ntung gung nây. ");
INSERT INTO cmo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Brah Yêhôva dâk ta kalơ ntung gung nây, lah ma păng: “Gâp dja Brah Yêhôva, i brah Abrahăm che may yơk mbah, i brah Isăk bơ̆ may yơk mbah đŏng. Neh ntŭk may bêch dja Gâp ăn ma may, n'ho tât kon tât sau may. ");
INSERT INTO cmo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Kon sau may tay ŏk tâm ban ma neh môi, khân păng mra gŭ lam ntŭk tât jât nhŏp nar, tât jât lôh nar, tât jât dŏng, ndrel ma tât jât lơ. Jêh ri dâng lĕ ndŭl mpôl bunuyh ta neh ntu dja bu geh jêng tă bơh kon sau may dadê. ");
INSERT INTO cmo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Gâp gŭ ndrel may, ah ntŭk may hăn Gâp mât njrăng may, ndrel ma leo may plơ̆ tay ta bri dja đŏng, Gâp mâu ôh mƀăr may, yorlah moh nau Gâp lĕ jêh ton ma may, Gâp jan ăn tât jêng ngăn ro”. ");
INSERT INTO cmo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Tât Yakôp kah rngăl bêch, păng lah: “ Brah Yêhôva gŭ ta ntŭk dja ngăn ro, yơn ma gâp mâu gĭt ôh”. ");
INSERT INTO cmo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Păng klach, jêh ri lah: “Klach ngăn ntŭk dja ưh! Ta dja ro jay Kôranh Brah, ndrel ma ntŭk mpông mpêr trôk i ntŭk Păng”. ");
INSERT INTO cmo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakôp dâk ơm ôi, păng sŏ lŭ i pre dŏm bôk ri nơh păng rdŏk jan n'gŏng ta ri, jan ndơ gĭt năl geh Kôranh Brah gŭ, jêh ri păng tŏ dak ngi bơh lơ ri. ");
INSERT INTO cmo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Păng tê̆ rnha ntŭk nây «Ƀêtel», geh nau khlay lah «Jay Kôranh Brah». Bơh ntơm nơh bu kuăl ntŭk nây rnha «Luh». ");
INSERT INTO cmo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jêh ri Yakôp ton, păng lah: “Lah Kôranh Brah gŭ ndrel gâp, mât njrăng gâp rŏ trong gâp hăn dja, ăn piăng trao ma gâp, ndrel ma ăn bok n'gut ao nsoh ma gâp, ");
INSERT INTO cmo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ăn gâp plơ̆ sât tât ta jay bơ̆ gâp đăp mpăn, lah ndri gâp mra yơk mbah ma Brah Yêhôva ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Lŭ gâp rdŏk jan n'gŏng dja jêng ntŭk ma yơk mbah May, moh ndơ May ăn ma gâp, tay gâp sŏ ndơ nây du kô̆ tâm jât nhhơr ma May Nơm”. ");
INSERT INTO cmo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jêh ri Yakôp dâk hăn, păng hăn tât ta bri phung bunuyh gŭ mpeh bơh lôh nar. ");
INSERT INTO cmo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Păng say geh du mlŏm ntu dak ta du lôk mir, ndrel ma geh be biăp pe phung kuen kêng meng ntu dak ri đŏng, yorlah bơh ntu dak i nây bu vay ăn ma be biăp de nhêt, yơn ma geh lŭ kuŏng ngăn kŭp bơh lơ bŏr ntu ri. ");
INSERT INTO cmo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Lah dâng lĕ be biăp phung bu lĕ veng lĕ rgum ta ri dadê, ri mơ dâng bu leo băl pư rlă lŭ bơh bŏr ntu ri ăn be biăp nhêt, jêh ri bu rlă tay lŭ nây kŭp tay ta bŏr ntu ri jât. ");
INSERT INTO cmo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakôp ôp mpôl i chiăp nây: “Ơ oh nô, khân may bơh tă?” Khân păng ơh: “Hên tă bơh ƀon Charan”. ");
INSERT INTO cmo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Păng ôp tay mpôl i nây jât: “Lah ndri khân may năl đŏng va Laƀan i kon che Nahôr?” Khân păng ơh: “Năl đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakôp ôp khân păng: “Lah ndri ueh lăng đŏng păng?” Khân păng ơh: “Ueh lăng đŏng, ri moh, Rachel i kon bu ur păng, hăn ndrel ma be biăp phung ri moh”. ");
INSERT INTO cmo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakôp lah ma khân păng: “Nar hôm e prêh, mâu hŏ di mong rgum be biăp, jêh ăn păng nhêt dak, ƀơk tay ăn păng sa mpa ƀŏt”. ");
INSERT INTO cmo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Khân păng lah: “Mâu dơi ôh, hên kŏp gum ăn râng be biăp phung ƀŏt, jêh ri pư rlă lŭ bơh bŏr ntu dak nây ri mơ dâng ăn be biăp nhêt dak”. ");
INSERT INTO cmo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Dôl Yakôp hôm e ngơi đah mpôl nây, Rachel sât tât ta nây, ndrel ma be biăp bơ̆ păng, yorlah păng bunuyh chiăp be biăp. ");
INSERT INTO cmo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tât Yakôp say Rachel i kon Laƀan jêng kon i nô mê̆ păng ri, ndrel ma be biăp Laƀan tât ta nây, păng hăn pư rlă lŭ bơh bŏr ntu dak nây ăn be biăp Laƀan ri nhêt. ");
INSERT INTO cmo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Jêh ri păng chŭm Rachel ri ta tâm bom, n'ho ma nhŭm. ");
INSERT INTO cmo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakôp mbơh nkoch ma Rachel, păng jêng mpôl băl đah bơ̆ Rachel, păng i kon Rêbêka. Tât ma tăng nau nkoch i nây, Rachel nchuăt mbơh ma i bơ̆ ri. ");
INSERT INTO cmo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Tât ma Laƀan tăng nkoch Yakôp kon i oh bu ur păng nơm, păng hăn nchuăt ro, chŭm ut Yakôp ri, leo Yakôp sât lăp a jay păng ri. Jêh ri Yakôp nkoch bri ma Laƀan nô nau păng hăn ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laƀan lah ma Yakôp: “May dja mlay mham gâp ngăn”. Jêh Yakôp gŭ ndrel Laƀan ta ri geh du khay ");
INSERT INTO cmo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laƀan lah ma Yakôp: “Bol lah may ma gâp jêng va mon, mơm blao jan kar dơm dam, may mbơh ma gâp, moh ndơ may ŭch ma nkhôm?” ");
INSERT INTO cmo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laƀan geh bar hê kon bu ur, i yôh rnha Lêa, i oh rnha Rachel. ");
INSERT INTO cmo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lêa trôm măt păng ueh, yơn ma Rachel lĕ muh măt lĕ săk jăn păng ueh reh ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakôp rŏng Rachel hô ngăn, păng ơh kơt nđa: “Gâp ŭch jan kar ma may pơh năm va, gay ma geh sŏ Rachel kon may nây ma jêng ur gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laƀan ơh ma păng: “Ueh rlao gâp ăn păng ma may đah ma gâp ăn păng ma bu êng, lah ndri may gŭ ndrel gâp dôh mon!” ");
INSERT INTO cmo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jêh ri Yakôp gŭ jan kar ma Laƀan pơh năm, gay ma geh sŏ Rachel nây, bol lah jŏ dah nây kađôi tâm ban ma pe puăn nar dơm ma păng, yorlah păng rŏng Rachel dŭt hô. ");
INSERT INTO cmo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jêh bơh nây Yakôp lah ma Laƀan: “Ơ va, may nđăp gâp đah Rachel hŏm, gay ma gâp gŭ đah păng, yorlah gâp jan kar ăn may lĕ lôch pơh năm, nau bân tâm ton nơh lĕ tât”. ");
INSERT INTO cmo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Jêh ri Laƀan jan ndrăp nhêt nđăp kon păng nây, păng jă dâng lĕ bunuyh ta ƀon nây. ");
INSERT INTO cmo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tât a măng, Laƀan de rplăch sŏ kon păng Lêa ăn bêch đah Yakôp, jêh ri Yakôp bêch đah păng. ");
INSERT INTO cmo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laƀan sŏ Sĭlpha i bu ur sơm kơl jan kar ma păng nơm ăn ma Lêa, ma sơm kơl jan kar kon păng. ");
INSERT INTO cmo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tât ang ôi Yakôp say Lêa chrao, jêh ri păng lah Laƀan: “Moh may jan ma gâp kơt nđa? Ơm mâu di lah gay ma geh sŏ Rachel gâp jan kar may nơh? Moh may ndơm gâp?” ");
INSERT INTO cmo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laƀan ơh ma păng: “Ta bri dja bu mâu ôh vay ăn lor i oh. ");
INSERT INTO cmo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ăn may gŭ đah păng tât du pơh ƀŏt, tay dâng gâp ăn Rachel dja ma may đŏng, jêh ri may gŭ jan kar tay ma gâp ăn geh pơh năm jât”. ");
INSERT INTO cmo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakôp jan tâng nau Laƀan de lah ma păng nây, păng gŭ đah Lêa tât lôch du pơh, jêh ri Laƀan ăn tay Rachel ma Yakôp jât. ");
INSERT INTO cmo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Păng sŏ đŏng Ƀĭlha i bu ur sơm kơl jan kar ma păng nơm ăn ma Rachel, ma sơm kơl jan kar ăn ma kon păng. ");
INSERT INTO cmo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakôp hăn bêch ndrel Rachel đŏng, păng rŏng Rachel rlao đah păng rŏng Lêa. Jêh ri păng gŭ jan kar ma Laƀan pơh năm jât. ");
INSERT INTO cmo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Brah Yêhôva say Yakôp mâu rŏng ma Lêa, Păng jan ăn ma Lêa geh kon, tih ma Rachel mâu geh kon. ");
INSERT INTO cmo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lêa ntreo, păng bă du huê kon bu klô, jêh ri păng tê̆ rnha «Rupên», yorlah păng lah: “ Brah Yêhôva lĕ say nau rngot ta gâp, aƀaơ dja gĭt lah sai gâp rŏng ma gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Jêh ri păng ntreo tay bă tay du huê kon bu klô jât, păng lah: “Brah Yêhôva lĕ Păng tăng jêh sai gâp mâu rŏng ma gâp, ndri dâng Păng ăn tay kon bu klô dja ma gâp”. Jêh ri Lêa tê̆ rnha kon nây «Simôn». ");
INSERT INTO cmo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Păng ntreo tay bă tay du huê kon bu klô jât, păng lah: “Jŏng dja sai gâp mra krêp rŏng ma gâp ngăn ro, yorlah gâp gŭ oh kon bu klô ma păng lĕ pe ơ̆”. Kơt ndri dâng păng tê̆ rnha kon nây «Lêvi». ");
INSERT INTO cmo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Jêh ri păng ntreo tay bă tay du huê kon bu klô jât, păng lah: “Du tơ̆ dja gâp rnê ma Brah Yêhôva”. Kơt ndri dâng păng tê̆ rnha kon nây «Yuđa», jêh ri păng mâu hôm ôh bă kon. ");
INSERT INTO cmo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Nôk Rachel say săk păng nơm mâu ôh bă kon ma Yakôp, păng mâu nach i yôh pre. Jêh ri păng lah ma Yakôp: “Ăn gâp geh kon ƀă, lah mâu geh kon khât hơyh gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakôp hao nuih brut, păng ji nuih ma Rachel, păng ơh: “Gâp dja gĭt ma Kôranh Brah i mâu ăn ay geh kon lah?” ");
INSERT INTO cmo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rachel lah: “Nây Ƀĭlha ta nây, păng i bu ur sơm kơl jan kar gâp nơm, may sŏ păng dô, gay ma păng bă kon ma gâp, gâp sŏ kon nây mât jêng tâm ban ma kon gâp nơm”. ");
INSERT INTO cmo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rachel sŏ Ƀĭlha i bu ur sơm kơl jan kar păng nơm nây ăn jêng ur Yakôp, ndri Yakôp bêch đah Ƀĭlha nây. ");
INSERT INTO cmo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Jêh ri Ƀĭlha ntreo, păng bă du huê kon bu klô ma Yakôp. ");
INSERT INTO cmo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel lah: “Lĕ Kôranh Brah phat dôih sŏng ma gâp, lĕ Păng tăng nau gâp dăn, yorlah Păng lĕ ăn gâp geh du huê kon bu klô” ndri dâng Rachel tê̆ rnha kon nây «Dan». ");
INSERT INTO cmo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Jêh ri Ƀĭlha i bu ur sơm kơl jan kar ma Rachel nây, păng ntreo tay bă tay du huê kon bu klô jât ma Yakôp. ");
INSERT INTO cmo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel lah: “Gâp tâm rdâng đah ma yôh gâp gay ma Kôranh Brah kơl, tât dơi gâp đŏng”. Jêh ri păng tê̆ rnha kon nây «Năptali». ");
INSERT INTO cmo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Tât Lêa say săk păng nơm mâu hôm bă kon, păng sŏ Sĭlpha i bu ur sơm kơl jan kar ma păng nơm nây ăn jêng ur Yakôp. ");
INSERT INTO cmo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Jêh ri Sĭlpha bă du huê kon bu klô ma Yakôp. ");
INSERT INTO cmo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lêa lah: “Geh nau lap ngăn” jêh ri păng tê̆ rnha kon nây «Kat». ");
INSERT INTO cmo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Sĭlpha i oh mon Lêa nây bă tay du huê kon bu klô jât ma Yakôp. ");
INSERT INTO cmo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lêa lah: “Gâp răm maak ngăn, yorlah dâng lĕ phung bu ur, bu lah ma gâp răm maak ngăn”. Jêh ri păng tê̆ rnha kon nây «Asơr». ");
INSERT INTO cmo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Tât khay rek ba Prăng, Rupên hăn a mir, păng say play Sane păng pĕ ăn Lêa i mê̆ păng. Jêh ri Rachel lah ma Lêa: “Dăn pă play Sane kon ay nây ăn gâp ƀă yôh”. ");
INSERT INTO cmo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lêa lah ma păng: “Mâu hŏ sŏp ay pit sai gâp ƀah? Aƀaơ dja ay ŭch dăn play Sane kon gâp jât”. Rachel ơh ma păng: “Lah ay ăn play Sane kon ay nây ma gâp, gâp ăn sai gâp bêch đah ay măng dja”. ");
INSERT INTO cmo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Tât kêng măng, nôk Yakôp sât bơh mir, Lêa hăn chuă păng a trong ri, păng lah: “Iăt ma may bêch đah gâp măng dja, yorlah lĕ jêh gâp rvăt may ma play Sane kon gâp”. Jêh ri măng nây Yakôp hăn bêch đah ma Lêa. ");
INSERT INTO cmo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Kôranh Brah ơh nau Lêa dăn, jêh ri Lêa ntreo bă tay du huê kon bu klô jât, nây jêng kon tŏl prăm Lêa bă ma Yakôp. ");
INSERT INTO cmo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lêa lah: “Kôranh Brah ăn ndơ nkhôm ma gâp, yorlah lĕ gâp ăn bu ur sơm kơl jan kar ma gâp nơm ma sai gâp”. Jêh ri păng tê̆ rnha kon nây «Isakhar». ");
INSERT INTO cmo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lêa ntreo tay bă tay du huê kon bu klô jât ma Yakôp, jêng kon tŏl prao. ");
INSERT INTO cmo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lêa lah: “Kôranh Brah ăn dơm dam ndơ khlay ma gâp, du tơ̆ dja sai gâp păng yơk ma gâp ro, yorlah lĕ gâp bă prao ơ̆ kon bu klô ma păng”. Jêh ri păng tê̆ rnha kon nây «Săpyulôn». ");
INSERT INTO cmo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Jêh bơh nây păng bă du huê kon bu ur, păng tê̆ rnha «Đina». ");
INSERT INTO cmo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kôranh Brah hôm kơl ma Rachel ơh nau păng dăn, jêh ri jan ăn Rachel geh kon. ");
INSERT INTO cmo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Jêh ri păng ntreo bă du huê kon bu klô, păng lah: “Kôranh Brah mâu hôm ôh ăn gâp geh nau đit prêng jât ”. ");
INSERT INTO cmo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Jêh ri păng tê̆ rnha kon nây «Yôsep», păng lah: “Dăn Brah Yêhôva ntop ăn ma gâp hôm du huê kon bu klô jât”. ");
INSERT INTO cmo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Jêh Rachel bă Yôsep, Yakôp ngơi ma Laƀan: “Ơ che, gâp dăn ăn gâp plơ̆ sât ta bri gâp nơm ri ");
INSERT INTO cmo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","gâp dăn leo ur leo kon gâp dja hăn ndrel gâp nơm, gâp lĕ lôch jêh jan kar ma ƀe yor ma bar hê kon ƀe dja. Ƀe lĕ gĭt đŏng nau gâp jan kar ueh ma ƀe”. ");
INSERT INTO cmo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laƀan ơh ma păng: “Dăn ƀe iăt nau gâp ƀŏt, lĕ gâp gĭt n'hêl ngăn Brah Yêhôva de ăn geh jêng ma gâp dja, jêng tă bơh ƀe. ");
INSERT INTO cmo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mbơh ma gâp hŏm, moh ndơ ƀe ŭch sŏ nkhôm bơh gâp, gâp ăn ma ƀe”. ");
INSERT INTO cmo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakôp ơh ma păng: “Ơ che, ƀe lĕ gĭt jêh nau gâp gŭ jan kar rơah rgănh ma ƀe nơh, gâp mât uănh mpômpa (siŭm) phung ƀe nơh, jêh ri geh lơ ma ŏk. ");
INSERT INTO cmo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nôk ê hŏ gâp gŭ ndrel ma ƀe, mpômpa (siŭm) ƀe đê̆ dơm, lŏng aƀaơ dja mpômpa (siŭm) ƀe lĕ bâk rơ̆ ŏk ngăn, ntơm bơh gâp gŭ ndrel ƀe Brah Yêhôva ăn geh jêng ma ƀe ta dâng lĕ ndơ gâp jan. Aƀaơ dja gâp ŭch jan kar ăn ma rnăk vâl gâp nơm hanh”. ");
INSERT INTO cmo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laƀan lah ma Yakôp: “Lah ndri moh ndơ ƀe ŭch gâp ăn ma ƀe?” Yakôp ơh: “Ơ che, ƀe lơi ôh ăn ndơ ma gâp. Lah ƀe ŭch, ăn gâp hôm gŭ chiăp be biăp phung ƀe jât. ");
INSERT INTO cmo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nar dja gâp hăn uănh ta be biăp phung ƀe, dâng lĕ be biăp i geh rvanh rŭk lŭk, ndrel ma kon be biăp i krăk krăk, gâp nkhah ăn gŭ êng. Dâng lĕ be i geh rvanh rŭk lŭk gâp nkhah ăn gŭ êng bơh phung mpômpa (siŭm) ƀe. Jêh ri dâng lĕ mpômpa (siŭm) nây gâp dăn sŏ jêng ndơ nkhôm ăn ma gâp. ");
INSERT INTO cmo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Nar jât năp tay tât ƀe hăn uănh mpômpa (siŭm) i nkhôm ma gâp, ƀe say di kơt nau gâp lah nây ro, dâng lĕ mpômpa (siŭm) mâu geh rvanh rŭk lŭk i ƀe say, mâu lah dâng lĕ be biăp mâu geh krăk gŭ ta mpômpa (siŭm) phung gâp, dâng lĕ mpômpa (siŭm) nây jêng kơp gâp ntŭng”. ");
INSERT INTO cmo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laƀan ơh: “Ơ, kađôi đŏng, ƀe jan tâng nau ƀe lah ri dôh!” ");
INSERT INTO cmo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Jêh ri nar nây ro Laƀan hăn tâm nkhah be nkuŏng i geh rvanh mpor, ndrel ma be me i geh rvanh mpor, dâng lĕ be i geh nglang đê̆, ndrel ma be biăp i krăk krăk, păng tâm nkhah ăn gŭ êng, phung i nây păng ăn ma mpôl kon păng nơm mât chiăp. ");
INSERT INTO cmo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Jêh ri Laƀan ăn khân păng gŭ ƀah ngai đah Yakôp pe nar brô̆ trong. Yakôp gŭ mât mpômpa (siŭm) Laƀan i hôm ta ri. ");
INSERT INTO cmo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakôp gĭch n'ging pe ntil tơm si i geh nglang ta nâm ntô i hôm rêh, păng plôk chor i ntô ri ăn say nglang run un. ");
INSERT INTO cmo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Jêh ri păng sŏ n'ging si i nây ndơm ta trong dak, ndrel ma ta bong, ntŭk mpômpa (siŭm) păng vay nhêt dak, gay ma ăn mpômpa (siŭm) nây say, yorlah păng tâm jơng băl dôl păng nhêt dak. ");
INSERT INTO cmo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Lah păng tâm jơng ta plăng n'ging si nây, tât ma deh kon jêng rvanh mpor. ");
INSERT INTO cmo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jêh ri Yakôp tâm nkhah lơi dâng lĕ kon i geh rvanh mpor ăn gŭ êng bơh mpômpa (siŭm) Laƀan. Nôk tâm jơng, păng ăn mpômpa (siŭm) Laƀan uănh jât mpômpa (siŭm) i rvanh mpor, mâu lah i krăk krăk, gay ma geh kon rvanh mpor. Kơt ndri mpômpa (siŭm) phung păng nơm geh lơ ma ŏk. ");
INSERT INTO cmo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tât ma mpômpa (siŭm) i dăng dăng tâm jơng băl, Yakôp sŏ n'ging si ri ndơm ta trong dak ăn mpômpa (siŭm) nây say, gay ma ăn păng tâm jơng băl ta plăng bơh năp n'ging si nây. ");
INSERT INTO cmo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Lah mpômpa (siŭm) i mâu dăng mâu dăng tâm jơng băl, păng mâu ôh ndơm n'ging si nây. Kơt ndri dâng mpômpa (siŭm) i mâu dăng mâu dăng jêng mpômpa (siŭm) Laƀan, jêh ri mpômpa (siŭm) i dăng dăng jêng mpômpa (siŭm) Yakôp. ");
INSERT INTO cmo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Jêh ri Yakôp geh drăp ndơ lơ ma ŏk ngăn, păng geh mpômpa (siŭm) dŭt ŏk, geh nđâp ma bunuyh sơm kơl jan kar bu ur bu klô, nđâp ma seh samô, ndrel ma seh lia ŏk đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jêh ri Yakôp tăng phung kon bu klô Laƀan tâm lah: “Lĕ Yakôp sŏ nsiăn drăp ndơ bơ̆ bân. Păng ndrŏng ŏk drăp ndơ nây tă bơh drăp ndơ bơ̆ bân”. ");
INSERT INTO cmo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakôp say Laƀan mâu hôm ôh lăng mbơh ngơi ma păng. ");
INSERT INTO cmo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Jêh ri Brah Yêhôva lah ma păng: “May plơ̆ sât hŏm ta bri u che may nơm, ta ndŭl mpôl may nơm ri, Gâp mra gŭ ndrel may”. ");
INSERT INTO cmo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jêh ri Yakôp đă bu hăn kuăl Rachel, ndrel ma Lêa, hăn gŭ ndrel păng ta ntŭk chiăp be biăp ta ndrĭch ri. ");
INSERT INTO cmo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yakôp lah ma bar hê ur păng nây: “Lĕ gâp say bơ̆ khân ay mâu hôm ôh lăng mbơh ngơi ma gâp kơt bơh ntơm nơh, yơn ma Kôranh Brah i bơ̆ gâp yơk mbah lĕ gŭ ndrel gâp. ");
INSERT INTO cmo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Khân ay lĕ gĭt đŏng gâp gŭ jan kar ăn ma bơ̆ khân ay, lĕ bơh brăt suan gâp ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Yơn ma bơ̆ khân ay păng ndơm mƀrôh gâp, păng ngơi mplăch ndơ nkhôm ma gâp lĕ jât tơ̆. Yơn ma Kôranh Brah mâu ôh ăn păng jan djơh ma gâp. ");
INSERT INTO cmo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Lah bơ̆ khân ay lah: «Dâng lĕ mpômpa (siŭm) i geh rvanh rŭk lŭk dơm, jêng ndơ nkhôm ma ăn ƀe dadê», jêh ri dâng lĕ mpômpa (siŭm) tât ma deh kon geh rvanh rŭk lŭk dadê ro, lah bơ̆ khân ay lah: «Dâng lĕ mpômpa (siŭm) i geh rvanh mpor dơm, jêng ndơ nkhôm ma ăn ƀe dadê», jêh ri tât ma deh kon geh rvanh mpor dadê đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kơt ndri Kôranh Brah sŏ mpômpa (siŭm) bơ̆ khân ay ăn ma gâp. ");
INSERT INTO cmo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Nôk khay tâm jơng mpômpa (siŭm), geh du măng gâp mbơi say be nkuŏng jơng be me, ta nây be nkuŏng geh rvanh mpor, ndrel ma geh rvanh rŭk lŭk dadê. ");
INSERT INTO cmo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Jêh ri tông păr Kôranh Brah kuăl gâp: «Hơi Yakôp!” Gâp ơh: «Moh ndơ». ");
INSERT INTO cmo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Tông păr nây lah: «May uănh nây! Dâng lĕ be nkuŏng jơng be me, ta nây be nkuŏng geh rvanh mpor, ndrel ma rvanh rŭk lŭk dadê, yorlah Gâp lĕ say nau Laƀan de jan ma may. ");
INSERT INTO cmo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Gâp dja Kôranh Brah i nhhơ săk ma may ta ƀon Ƀêtel, ntŭk may tŏ dak ngi ta n'gŏng lŭ nây nơh, nđâp ma may ton ma Gâp đŏng. Aƀaơ dja may dâk lôh bơh bri dak dja hŏm, plơ̆ sât ta ntŭk bri dak deh may nơm ri nơh»”. ");
INSERT INTO cmo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel, ndrel ma Lêa ơh ma Yakôp: “Bơ̆ hên păng mâu geh ôh ăn drăp ndơ khlay ma ndrây ăn ma hên. ");
INSERT INTO cmo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Păng lĕ kơp hên jêng tâm ban ma phung bu năch đŏng, păng tâm ban ma tăch hên, jêh ri drăp ndơ i may lĕ jan kar ma păng yor ma hên, păng sŏ ma păng nơm dơm. ");
INSERT INTO cmo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Dâng lĕ drăp ndơ Kôranh Brah de ăn ma may sŏ tă bơh bơ̆ hên, jêng drăp ndơ ma hên, ndrel ma phung oh kon hên. Lah ndri may jan hŏm moh ndơ Kôranh Brah de đă ma may”. ");
INSERT INTO cmo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jêh ri Yakôp dâk hăn, păng ăn ur ăn kon păng ncho seh samô, ");
INSERT INTO cmo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","jêh ri păng veng dâng lĕ mpômpa (siŭm) phung păng nơm, nđâp ma ndjôt leo dâng lĕ drăp ndơ păng geh dôl păng gŭ ta bri Pađan-Aram nây nơh, gay ma plơ̆ sât ta Isăk bơ̆ păng nơm ta bri Kanan ri. ");
INSERT INTO cmo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Dôl nây Laƀan ndŭt hăn koh rsau be biăp păng nơm, jêh ri Rachel ntŭng lĕ phiao rup brah bơ̆ păng ta jay ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakôp nchuăt ntŭng ma Laƀan phung Aram nây, păng mâu ôh mbơh ăn Laƀan gĭt. ");
INSERT INTO cmo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yakôp ndjôt leo lĕ phiao dâng lĕ drăp ndơ păng geh. Păng hăn glăt dak rlai Ơprat, hăn let jât yôk bri Kalat ri. ");
INSERT INTO cmo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Tât lĕ pe nar, geh bu hăn mbơh ma Laƀan nau Yakôp lĕ nchuăt nây. ");
INSERT INTO cmo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Jêh ri Laƀan leo ndŭl mpôl păng hăn tâng Yakôp, khân păng tâng pơh nar, ri mơ dâng ban ta yôk Kalat ri. ");
INSERT INTO cmo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Yơn ma Kôranh Brah hăn mbơh ma Laƀan phung Aram nây ta nau mbơi ta nôk măng, Păng lah: “May njrăng hŏ, may lơi ôh dah ma ngơi ma Yakôp, bol lah nau ueh, mâu lah nau djơh”. ");
INSERT INTO cmo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laƀan tâng ban Yakôp, nôk Yakôp lĕ gŭ rdŏk chun bok ta kalơ yôk bri Kalat ri, Laƀan, ndrel ma ndŭl mpôl păng gŭ rdŏk chun bok ta kalơ yôk Kalat ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laƀan lah Yakôp: “Moh dâng ƀe jan kue nchuăt ntŭng ma gâp? Rdu kon sau gâp, tâm ban ma bu nhŭp veng bơh ntŭk tâm lơh tâm sreh nây, moh dâng ƀe jan kơt nây? ");
INSERT INTO cmo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Moh dâng ƀe nchuăt ntŭng ma gâp kơt nây, mâu mbơh ăn gâp gĭt? Lah gâp gĭt, gâp njŭn khân ƀe ma nau răm maak, nđâp ma mprât ma mprơ, nđâp ma goh gong goh gŏr, goh gong rêng ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Moh ƀe mâu ăn gâp chŭm gâp ntĭnh kon sau gâp? Ƀe jan kơt nây jêng rluk mâl ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Gâp geh nau dơi lơh khân ƀe, yơn ma Kôranh Brah i bơ̆ ƀe yơk mbah lĕ Păng buay gâp a măng nơh, Păng lah: «May njrăng hŏ, may lơi ôh dah ma ngơi ma Yakôp, bol lah nau ueh, mâu lah nau djơh». ");
INSERT INTO cmo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Aƀaơ dja lah ƀe nchuăt yor ma mâu djăng bơ̆ mâu chrao vă, lah ndri moh dâng ƀe ntŭng nđâp ma rup brah gâp?” ");
INSERT INTO cmo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakôp ơh ma Laƀan: “Dâng gâp jan kơt nđa, yorlah gâp klach ƀe sŏ pit oh kon ƀe nơm tă bơh gâp. ");
INSERT INTO cmo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Lŏng rup brah ƀe ri, lah ƀe say ta bu moh, iăt ma nkhât bunuyh i nây. Ƀe nsơr joi ăp bunuyh ta năp băl mpôl ƀe nây dô, lah say geh ndơ ƀe, ƀe sŏ sât dô”. Yơn ma Yakôp mâu ôh gĭt lah lĕ Rachel de ndjôt ntŭng rup brah ri. ");
INSERT INTO cmo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Jêh ri Laƀan lăp ta chun Yakôp, lăp ta chun Lêa, ndrel ma lăp ta chun bunuyh sơm kơl jan kar ma Lêa, Rachel, joi ndơ nây mâu say ôh. Laƀan lôh bơh chun Lêa ri, lăp ta chun Rachel. ");
INSERT INTO cmo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel sŏ dâng lĕ rup brah i nây, păng pôn ta dŭr seh samô ri, jêh ri păng nơm gŭ bơh lơ. Laƀan joi lam chun nây, joi mâu ôh say ndơ. ");
INSERT INTO cmo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel mbơh ma bơ̆ păng: “Lơi ta bơ̆ klăp ndăng ma gâp, gâp mâu dâk ta năp may, gâp mâu dơi dâk, yorlah gâp mâu ueh săk”. Kơt ndri păng joi rup brah i nây, yơn ma mâu ôh say. ");
INSERT INTO cmo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakôp ji nuih ngăn, păng lah Laƀan: “Moh dôih gâp, moh ndơ tih ta gâp dâng ƀe tâng gâp nđâp ma nuih? ");
INSERT INTO cmo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Dôl ƀe nsơr rhi ndơ gâp, moh ƀă ƀe say ndơ ƀe ta phung hên? Lŏng ƀe nhhơ ăn ma băl mpôl gâp say, nhhơ ăn ma băl mpôl ƀe say ta dja, gay ma ăn phung khân păng nây sơm phat dôih ma bar hê bân. ");
INSERT INTO cmo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Lĕ 20 năm, gâp gŭ ndrel ƀe, dâng lĕ be biăp me, ndrel ma be me ƀe, mâu geh ôh du mlŏm rlêh kon, be biăp nkuŏng ƀe du mlŏm gâp mâu hŏ geh sa đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Lah geh mpômpa (siŭm) bri kăp sa, ƀe hôm đă gâp trŏ, mâu ôh ăn gâp ndjôt mpômpa (siŭm) khât nây ndơ̆ ăn ƀe ma say dơm, lah geh bu ntŭng nôk nar, mâu lah nôk măng, ƀe đă gâp trŏ dadê, gâp trŏ ăn ƀe mro. ");
INSERT INTO cmo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kơt nđa ngăn nau gâp nsrôyh, nôk nar ma dôh nar, nôk măng ma nđik, ndrel ma rngeh măng găng măt ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Gâp gŭ ndrel ƀe jŏ 20 năm, gâp jan kar ma ƀe 14 năm, gay ma geh sŏ kon bu ur ƀe bar hê nây, jêh ri prao năm jât gay ma geh mpômpa (siŭm) phung. Yơn ma ndơ nkhôm gâp nây, ƀêng ma ngơi mplăch jât tơ̆ ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Lah mâu geh Kôranh Brah i che gâp yơk mbah, i bơ̆ gâp klach yơk nây gŭ ndrel gâp, ƀe ăn gâp sât mpang ti dơm ngăn ro. Kôranh Brah lĕ say ndơ jêr ta gâp, kơt ndri dâng a măng nơh Păng lah ƀe”. ");
INSERT INTO cmo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laƀan lah ma Yakôp: “Phung bu ur dja kon gâp dadê, dâng lĕ phung kon se dja sau gâp dadê, dâng lĕ mpômpa (siŭm) dja mpômpa (siŭm) gâp, ndrel ma dâng lĕ ndơ ƀe say ta dja ndơ gâp dadê, nar dja gâp mâu ôh dăn sŏ kon bu ur gâp, gâp mâu ôh dăn sŏ sau gâp khân păng bă nây. ");
INSERT INTO cmo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Lah ndri nar dja ăn bân jan nau tâm rnglăp băl, nđâp ma jan ndơ mbên ăn ma hôm kah gĭt”. ");
INSERT INTO cmo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jêh ri Yakôp sŏ du mlŏm lŭ, păng rdŏk jan n'gŏng ta ri. ");
INSERT INTO cmo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Păng lah ma băl mpôl păng: “Khân ay may bun lŭ hŏm”. Khân păng dônh lŭ bun rdŭl, jêh ri leo băl gŭ sông ta meng nây. ");
INSERT INTO cmo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laƀan kuăl ntŭk nây rnha: «Yêkar-Sahađutha», yơn ma Yakôp kuăl ntŭk nây rnha: «Kalêt». ");
INSERT INTO cmo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Jêh ri Laƀan lah: “Nar dja bân sŏ lŭ dja jan ndơ mbên ƀe ndrel gâp.” Kơt ndri dâng bu kuăl lŭ i bun nây rnha «Kalêt», geh nau khlay lah «Bun lŭ năk say năk tăng». ");
INSERT INTO cmo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Yơn ma bu kuăl «Mihpa», đŏng, geh nau khlay lah «Chuanh nkơng ma ntŭk njrăng», yorlah Laƀan lah: “Dăn Brah Yêhôva njrăng ƀe ndrel gâp, dôl bân gŭ tâm ƀah ngai. ");
INSERT INTO cmo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Lah ƀe jan djơh ma kon bu ur gâp, mâu lah sŏ ur êng nôk khân păng hôm rêh, bol lah khân păng mâu geh ndŭl mpôl gŭ ndrel kađôi, hôm geh Kôranh Brah đŏng say, yorlah Păng i lĕ gĭt say nau bân lĕ tâm rnglăp ta dja”. ");
INSERT INTO cmo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laƀan ngơi tay ma Yakôp: “Uănh dja yơ̆, lŭ bun dja, ndrel ma n'gŏng lŭ dja lĕ gâp tê̆ ta nklang n'gul vah vang ƀe ma gâp. ");
INSERT INTO cmo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Lŭ bun dja, ndrel ma n'gŏng lŭ dja jêng ndơ mbên ma nau bân lĕ tâm rnglăp ăn ma nkah tôr bân, gâp mâu ôh mra hăn rlao bơh đah lŭ dja gay ma lơh ƀe, ƀe kŏ mâu đŏng mra hăn rlao bơh đah lŭ dja gay ma lơh gâp. ");
INSERT INTO cmo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Dăn Kôranh Brah i Abrahăm, i Nahôr, nđâp ma i bơ̆ khân păng yơk mbah nây, sơm phat dôih ăn ma bân”. Jêh ri Yakôp ton đŏng, ta rnha Kôranh Brah i Isăk i bơ̆ păng klach yơk ri păng ton. ");
INSERT INTO cmo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakôp nhhơr ndơ jan brah ta kalơ yôk nây, jêh ri păng kuăl dâng lĕ phung i gŭ ta nây văch sông sa ndrel. Jêh sông jêh sa, khân păng bêch ta kalơ yôk nây du măng. ");
INSERT INTO cmo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ơm ôi Laƀan dâk, păng chŭm kon chŭm sau păng ri, ndrel ma ăn geh jêng ma phung khân păng. Jêh ri păng plơ̆ sât tay ta bri păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakôp dâk hăn jât năp jât, jêh ri geh phung tông păr Kôranh Brah tâm mâp đah păng. ");
INSERT INTO cmo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Tât ma Yakôp say phung tông păr nây, păng lah: “Ntŭk dja jêng ntŭk phung tông păr Kôranh Brah gŭ ro” jêh ri păng rnha ntŭk nây: «Mahanem», geh nau khlay lah «Geh bar phung gŭ ta nây». ");
INSERT INTO cmo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakôp đă mpôl bunuyh ntơyh nau păng hăn lor tâm mâp đah Êsao nô păng ta ntŭk Êđŏm, bri Sêir ri. ");
INSERT INTO cmo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakôp lah ma mpôl i nây: “Khân may mbơh kơt nđa ma Êsao kôranh gâp tay: «Yakôp i bunuyh sơm kơl jan kar may, păng đă hên mbơh kơt nđa: «Gâp man ma gŭ ndrel Laƀan tât nar dja. ");
INSERT INTO cmo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Gâp geh ndrôk, geh seh lia, geh be biăp, geh be, ndrel ma geh bunuyh sơm kơl jan kar bu ur bu klô ŏk đŏng. Aƀaơ dja gâp đă bu hăn mbơh ma may i kôranh gâp, gay ma may yô̆ gâp»”. ");
INSERT INTO cmo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Jêh ri mpôl i păng đă hăn nây, plơ̆ sât mbơh nkoch ma Yakôp: “Lĕ jêh hên tâm mâp đah Êsao nô may. Păng hăn tâm mâp đah may đŏng, ndrel ma leo băl 400 nuyh hăn ndrel păng nơm”. ");
INSERT INTO cmo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakôp klach rvê hô ngăn, jêh ri păng tâm pă ntŭk gŭ bar mpôl, ndrôk, be biăp, be, ndrel ma seh samô păng tâm pă bar mpôl đŏng, ");
INSERT INTO cmo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","yorlah păng mân, lah Êsao lơh du ntŭk, hôm du ntŭk đŏng klaih. ");
INSERT INTO cmo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yakôp mbơh sơm ma Kôranh Brah: “Ơ Kôranh Brah i Abrahăm che gâp yơk mbah, i Isăk bơ̆ gâp yơk mbah, ơ Brah Yêhôva, May lĕ lah jêh ma gâp: «Hăn may plơ̆ sât hŏm ta bri che may nơm, ta ndŭl mpôl may nơm ri, Gâp mra jan ndơ ueh ma may». ");
INSERT INTO cmo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Gâp dja bunuyh sơm kơl jan kar May dơm, mâu di May rŏng ma gâp răp jăp, ndrel ma gŭ ta gâp răp jăp tât dah dja ir ma gâp. Yorlah dôl gâp hăn glăt dak rlai Yôrđăn dja, gâp geh du mlŏm mŏng jra dơm, yơn ma aƀaơ dja gâp lĕ jêng bar mpôl ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Dăn May kơl gâp, ăn gâp klaih bơh ti Êsao nô gâp, yorlah gâp klach păng tât ta dja, păng nkhât nhhang rnăk vâl gâp, nđâp ma bu ur kon se. ");
INSERT INTO cmo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Yơn ma May lĕ lah jêh ma gâp: «Tay Gâp ăn nau ueh maak đăp mpăn ma may, tay Gâp jan rnoi deh may ăn bâk rơ̆ ŏk tâm ban ma choyh rŏ dak văch dak văr, mâu hôm blao kơp»”. ");
INSERT INTO cmo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Măng nây păng bêch ta ntŭk nây. Păng sŏ drăp ndơ păng geh ƀă, ma ăn Êsao nô păng ri, ");
INSERT INTO cmo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","geh be me 200, be nkuŏng 20, be biăp me 200, be biăp nkuŏng 20 ");
INSERT INTO cmo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","seh samô nđâp ma hôm kon pu toh 30, ndrôk me 40, ndrôk nkuŏng 10, seh lia me 20, ndrel ma seh lia nkuŏng 10. ");
INSERT INTO cmo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Păng ăn dâng lĕ mpômpa (siŭm) i nây ma phung bunuyh sơm kơl jan kar ma păng ri, tâng phung tâng phung êng êng, jêh ri păng lah ma mpôl sơm kơl jan kar ma păng nây: “Khân may hăn lor, leo mpômpa (siŭm) dja ăn tâm ƀah tâng phung tâng phung, gâp hăn bơh kơi”. ");
INSERT INTO cmo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yakôp ntĭnh ma phung bunuyh sơm kơl jan kar ma păng nây, păng lah: “Lah Êsao nô gâp mâp khân may tay, lah păng ôp: «Bu moh kôranh may? Ah ntŭk brô̆ ntŭk hăn may? Mpômpa (siŭm) phung hăn bơh năp may nây bre moh?» ");
INSERT INTO cmo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ăn khân may lah ma păng kơt nđa: «Dâng lĕ mpômpa (siŭm) dja, mpômpa (siŭm) Yakôp bunuyh sơm kơl jan kar ma may nơm, păng ăn dâng lĕ mpômpa (siŭm) dja ma may, kôranh. Păng nơm hôm e brô̆ bơh kơi hên ri»”. ");
INSERT INTO cmo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakôp đă ma dâng lĕ bunuyh i veng bơh kơi bơh kơi dâng lĕ phung mpômpa (siŭm) nây păng đă kơt nây dadê. Păng lah ma phung khân păng: “Nôk khân may mâp Êsao ri tay, ăn khân may mbơh ma păng kơt nây dadê yơ̆. ");
INSERT INTO cmo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Khân may mbơh ma păng: «Yakôp bunuyh sơm kơl jan kar may hôm e brô̆ bơh kơi gâp ro»”. Yakôp jan kơt nây, yorlah păng mân: “Dâng lĕ ndơ gâp ăn bu leo ndjôt lor ma ăn nô gâp nây, gâp ŭch păng bah ji nuih ma gâp ro. Jêh ri tât gâp tâm mâp đah păng nơm tay, klăp lah păng rom gâp ma nau ueh”. ");
INSERT INTO cmo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Dâng lĕ mpômpa (siŭm) pre ăn nây bu leo ndjôt lor dadê, Yakôp nơm ri hôm bêch ta chun bok nây du măng. ");
INSERT INTO cmo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ta măng nây đŏng, Yakôp dâk leo lĕ ur păng bar hê, lĕ bu ur i sơm kơl jan kar ma bar hê ur păng nây, ndrel ma kon bu klô păng 11 nuyh ri hăn glăt n'hong dak Yapŭk plăng ntŭk thơl bu vay hăn. ");
INSERT INTO cmo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Jêh păng njŭn ur kon păng nơm tât kăl ti dak ri lĕ phiao, păng đă bu hăn ntôh drăp ndơ păng nơm ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakôp hôm gŭ păng du huê êng ta nây. Ta măng nây geh du huê bu klô hăn tâm nhăt đah păng n'ho ma tât ang ôi. ");
INSERT INTO cmo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Tât ma bu klô nây Păng gĭt lah, Păng mâu ôh dơi đah Yakôp, jêh ri Păng lơh Yakôp ta plăng n'gang bŭt. Yakôp n'ho ma glet ro nôk khân păng tâm nhăt nây. ");
INSERT INTO cmo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Bu klô nây lah ma păng: “Ƀơk ăn Gâp sât, yorlah bri lĕ ang”. Yakôp ơh: “Gâp mâu ôh ƀơk May, tât May lĕ ăn nau geh jêng ma gâp ƀŏt mơ”. ");
INSERT INTO cmo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Bu klô nây ôp Yakôp: “May mơm rnha?” Păng ơh: “Gâp rnha Yakôp”. ");
INSERT INTO cmo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Bu klô nây lah tay: “May mâu hôm ôh ntơ Yakôp jât, may ntơ Israel, yorlah may tâm nhăt đah Kôranh Brah, tâm nhăt đah bunuyh đŏng, lĕ dơi may”. «Israel», geh nau khlay lah «Păng tâm nhăt đah brah». ");
INSERT INTO cmo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakôp ôp bu klô nây: “Dăn May mbơh rnha May ăn gâp gĭt”. Bu klô nây lah ma păng: “Moh may ôp ŭch gĭt rnha Gâp?” Jêh ri Păng ăn geh jêng ma Yakôp ta ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakôp tê̆ rnha ntŭk nây «Pêniel», geh nau khlay lah «Muh măt brah», yorlah păng lah: “Gâp lĕ say ma măt ngăn muh măt Kôranh Brah, yơn ma săk gâp nơm hôm e rêh”. ");
INSERT INTO cmo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Nar lĕ lôh, Yakôp lôh hăn bơh ntŭk Pênuel nây. Păng hăn đâl ndât đâl ndât, yorlah n'gang bŭt păng glet. ");
INSERT INTO cmo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kơt ndri dâng phung kon sau Israel tât aƀaơ dja, khân păng mâu ôh sa puăch mlay ta n'gang bŭt, yorlah lĕ Kôranh Brah lơh Yakôp ta plăng n'gang bŭt. ");
INSERT INTO cmo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jêh ri Yakôp n'gơr măt uănh, say Êsao hăn, nđâp ma geh băl păng 400 nuyh hăn ndrel păng đŏng, jêh ri Yakôp tâm pă kon ăn ma Lêa, ăn ma Rachel, ndrel ma ăn ma bu ur sơm kơl jan kar bar hê nây. ");
INSERT INTO cmo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yakôp ăn bu ur sơm kơl jan kar bar hê nây, ndrel ma dâng lĕ kon khân păng hăn lor, jêh ri Lêa, ndrel ma dâng lĕ kon păng, n'glĕ dŭt bu ri păng ăn Rachel ndrel ma Yôsep hăn. ");
INSERT INTO cmo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakôp nơm ri păng hăn bơh năp phung nây, păng hăn păn mbah a neh su pơh tơ̆, n'ho ma tât dăch Êsao nô păng ri. ");
INSERT INTO cmo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Êsao nchuăt ran păng, ut păng, ut ta tong ko păng, chŭm păng, jêh ri nhŭm lĕ bar hê. ");
INSERT INTO cmo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Êsao uănh say phung bu ur, ndrel ma phung kon se, păng ôp: “Bu moh phung gŭ ndrel may dja?” Yakôp ơh: “Dja kon, Kôranh Brah de ăn ma gâp tă bơh nau ueh Păng Nơm”. ");
INSERT INTO cmo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Jêh ri bu ur sơm kơl jan kar ma bar hê ur păng ri, ndrel ma dâng lĕ kon khân păng hăn păn mbah Êsao nây. ");
INSERT INTO cmo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Jêh nây Lêa ndrel ma dâng lĕ kon păng hăn păn mbah, n'glĕ dŭt bơh kơi Yôsep, ndrel ma Rachel hăn păn mbah đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Jêh ri Êsao ôp Yakôp: “Moh jan ndơ may i ăn bu leo mâp gâp ndơh nơh?” Yakôp ơh: “Gâp leo ma njŭn ăn may nô, gay ma nô yô̆ gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Êsao lah ma păng: “Ơ oh, gâp be lĕ geh ŏk ngăn, may sŏ ndơ may nây prăp ăn ma may nơm dô”. ");
INSERT INTO cmo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakôp ơh: “Mâu ôh ndri nô, lah may yô̆ gâp ngăn, may dơn ndơ gâp njŭn ăn ma may nây dô. Dôl gâp say muh măt may tâm ban ma say muh măt Kôranh Brah đŏng, yorlah lĕ may rom gâp ma nau ueh đăp mpăn. ");
INSERT INTO cmo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Lah ndri dăn may sŏ dơn hŏm ndơ gâp njŭn ăn may nây, yorlah lĕ Kôranh Brah ăn geh jêng ma gâp, ăn gâp geh drăp ndơ ŏk rmeh”. Jêh ri Êsao sŏ dơn ndơ nây, yor ma Yakôp nchâp păng ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Êsao lah: “Hô̆, hăn hŏm bân, gâp hăn ndrel may”. ");
INSERT INTO cmo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakôp lah ma păng: “Ơ nô, may lĕ gĭt, bân brô̆ trong hăn ndrel kon se oh bê mâu geh ôh ueh, gâp geh be biăp, geh be, ndrel ma geh ndrôk hôm e kon pu toh. Lah bân nchâp ăn hăn ngai ir ta du nar, dâng lĕ mpômpa (siŭm) nây khât lĕ phiao ro. ");
INSERT INTO cmo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Lah ndri may hăn lor gâp i bunuyh sơm kơl jan kar ma may dôh nô, gâp ma hăn mplêm mplêm phung kon se, ndrel ma mpômpa (siŭm), n'ho ma tât gâp tâm mâp đah may ta bri Sêir ri”. ");
INSERT INTO cmo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Êsao lah ma Yakôp: “Lah ndri gâp ăn băl gâp hăn ndrel may ƀă dôh”. Yakôp ơh: “Mâu chrao ôh nô, may lĕ yô̆ ma gâp kơt nây lĕ găp jêh”. ");
INSERT INTO cmo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Jêh ri Êsao plơ̆ sât ta bri Sêir ri nar nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yơn ma Yakôp mâu ôh hăn ta bri Sêir, păng hăn tât ta ƀon Sukôt chrao. Păng jan du mlŏm jay ma gŭ păng nơm, ndrel ma rdŏk nkưp ma ăn mpômpa (siŭm) păng nơm đŏng. Kơt ndri dâng bu kuăl ntŭk nây «Sukôt», geh nau khlay lah «Chun». ");
INSERT INTO cmo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Bơh kơi Yakôp sât bơh bri Pađan-Aram nây, păng hăn ta ƀon Sikem bri Kanan ma nau đăp mpăn, jêh ri păng rdŏk chun bok tâm dăch ma ƀon nây. ");
INSERT INTO cmo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Neh ntŭk păng jan chun bok nây, păng rvăt tă bơh phung oh kon Hamor i bơ̆ Sikem, khlay 100 kăk prăk. ");
INSERT INTO cmo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Jêh ri păng jan du ntŭk ma jan brah ta ntŭk nây, păng tê̆ rnha «El Elôhê Israel», geh nau khlay lah «Kôranh Brah jêng brah Israel yơk mbah». ");
INSERT INTO cmo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Đina i kon Lêa bă ăn ma Yakôp nây nơh, păng hăn khŏl phung bu ur ta bri nây. ");
INSERT INTO cmo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Dôl nây geh du huê bu klô rnha Sikem i bơ̆ păng rnha Hamor phung Hivi, jêng kôranh ta bri nây, Sikem say Đina, nhŭp tom geh ôbăl. ");
INSERT INTO cmo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Păng di măt ngăn ma Đina kon Yakôp ri, păng rŏng hô ngăn ma bu ur nây, mbơh ngơi ueh ueh ma păng. ");
INSERT INTO cmo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sikem lah ma Hamor i bơ̆ păng nây: “Ơ bơ̆, đă may ôp văng bu ur nây, gâp ŭch sŏ păng jêng ur gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakôp lĕ gĭt jêh Sikem lơh djơh ma kon bu ur păng ri, yơn ma păng gŭ iăt săk rklăk dơm, yorlah dâng lĕ kon bu klô păng hôm gŭ chiăp a ja ri dadê, păng kŏp tât khân păng sât bơh ri. ");
INSERT INTO cmo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Yơn ma Hamor i bơ̆ Sikem ri, hăn tâm mâp đah Yakôp, gay ma tâm ngơi ndrel păng. ");
INSERT INTO cmo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Tât ma phung kon Yakôp sât tă bơh chiăp ri, khân păng tăng nau nây, khân păng dôh nuih hô ngăn ro, khân păng ji nuih dŭt hô ma Sikem yor ma ndơ păng lĕ jan dŭt ƀơ̆ ta rnăk vâl Yakôp, nau păng nhŭp tom kon bu ur Yakôp, yorlah ndơ nây bu mâu ôh di ma jan. ");
INSERT INTO cmo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor ngơi ma Yakôp, ndrel ma lĕ kon bu klô păng: “Sikem kon gâp, păng lĕ di măt ngăn ma kon bu ur may nây, gâp dăn khân may ăn bu ur nây đah păng, pre ma sŏ jêng ur. ");
INSERT INTO cmo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ăn khân may tâm rnglăp đah hên dô, ăn kon bu ur khân may tâm nđăp đah hên, jêh ri hên plơng ăn kon bu ur hên tâm nđăp đah khân may đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ăn khân may gŭ ndrel hên ta dja, bri hên soyh ma ăn khân may, khân may gŭ dô ta bri dja, tăch rgâl drăp ndơ, rvăt neh ma geh ntŭk khân may nơm gŭ”. ");
INSERT INTO cmo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Jêh ri Sikem ngơi ma Yakôp, ndrel ma i nô nô Đina ri đŏng, păng lah: “Dăn khân may yô̆ ma gâp, moh ndơ khân may keh, gâp ăn dadê. ");
INSERT INTO cmo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ăn khân may keh ndơ khlay bơh gâp, mâu lah keh drăp ndơ dŭt ŏk kađôi, moh ndơ khân may keh bơh nây gâp ăn dadê, iăt ma khân may ăn oh bu ur khân may nây ma jêng ur gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Jêh ri phung kon Yakôp plơng ơh nau Sikem, ndrel ma nau Hamor i bơ̆ ri, khân păng ŭch ndơm, yorlah Sikem lĕ jan djơh ma Đina oh khân păng nây, khân păng lah: ");
INSERT INTO cmo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Mâu dơi ôh hên ăn oh hên ma phung bu klô mâu geh koh ntô. Lah hên jan kơt nđa, hên đit prêng dŭt hô ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Lah khân may ŭch koh ntô kơt hên, dâng lĕ phung bu klô ta phung khân may ăn koh ntô dadê đŏng, ri mơ hên sŏ dơn nau khân may nây. ");
INSERT INTO cmo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Dâng hên ăn kon bu ur hên ma khân may, tay hên plơng sŏ kon bu ur khân may đŏng, dâng hên gŭ ndrel ma khân may, jêh ri bân n'ho ma jêng du phung dơm. ");
INSERT INTO cmo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Yơn ma lah khân may mâu ŭch koh ntô kơt hên, hên sŏ lơi oh bu ur hên, jêh ri du bơh ntŭk dja”. ");
INSERT INTO cmo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Nau ngơi nây di nuih klư̆ ngăn ma Hamor, ndrel ma Sikem kon păng ri. ");
INSERT INTO cmo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sikem mâu hôm ôh rong kŏp jŏ đŏng jan nau nây, yorlah păng rŏng hô ngăn ma kon bu ur Yakôp. Ta rnăk vâl Hamor ri bu yơk Sikem rlao bu. ");
INSERT INTO cmo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Jêh ri Hamor, ndrel ma Sikem kon păng hăn tât ta mpông mpêr ƀon khân păng nơm, lah ma phung bu klô ta ƀon nây: ");
INSERT INTO cmo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Phung khân păng nây ŭch gŭ đăp mpăn ndrel bân, lah ndri rom khân păng, ăn khân păng gŭ ta bri dja tăch rgâl drăp ndơ ndrel bân dô, yorlah neh bân huy đŏng, tŏng ma rom ăn khân păng gŭ. Ăn bân sŏ kon bu ur khân păng ma jêng ur, jêh ri ăn kon bu ur bân ma khân păng ma jêng ur đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Yơn ma dâng khân păng ŭch gŭ ndrel bân, gay ma jêng du phung, ăn dâng lĕ phung bu klô ta phung bân koh ntô ăn kơt khân păng đŏng mơ. ");
INSERT INTO cmo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Lah bân jan kơt nây, dâng lĕ drăp ndơ khân păng, ndrel ma mpômpa (siŭm) khân păng jêng drăp ndơ bân dadê ro. Hô̆, ăn bân jan kơt nau khân păng dăn, ăn khân păng gŭ ndrel bân”. ");
INSERT INTO cmo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Dâng lĕ bu klô ta ƀon nây, khân păng iăt nau Hamor, ndrel ma Sikem kon păng ri, jêh ri dâng lĕ phung bu klô ta ƀon i nây koh ntô dadê. ");
INSERT INTO cmo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Tât pe nar ri, dâng lĕ bu klô ta ƀon nây hôm ji dadê, jêh ri kon Yakôp bar hê, Simôn, ndrel ma Lêvi i nô du me bă ma Đina ri, khân păng ndjôt đao hăn lăp ta trôm ƀon nây, sreh dâng lĕ phung bu klô ta ƀon nây lĕ phiao, mâu geh ôh du huê ma tâm rdâng đah khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Khân păng nkhât Hamor, ndrel ma Sikem kon păng ri ma đao, jêh ri sŏ Đina lôh bơh jay Sikêm nây, sât ta ntŭk khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Dâng lĕ kon bu klô Yakôp aƀă êng, khân păng hăn tât ta phung bunuyh khât ri, jêh ri lăp sŏ gro drăp ndơ ta ƀon nây nchuăn lĕ phiao, yorlah bunuyh ta ƀon nây lĕ jan djơh ăn ma Đina. ");
INSERT INTO cmo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Khân păng sŏ lĕ be biăp, sŏ lĕ be, sŏ lĕ ndrôk, sŏ lĕ seh lia ta ƀon, nđâp ma ta mir. ");
INSERT INTO cmo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Khân păng sŏ nchuăn lĕ phiao drăp ndơ bunuyh ta ƀon nây, nhŭp ur nhŭp kon đŏng, ndrel ma dâng lĕ drăp ndơ ta nhih jay khân păng sŏ rgum lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jêh ri Yakôp lah ma Simôn, ndrel ma Lêvi kon păng ri: “Khân may jan ăn gâp geh nau rvê ngăn, jan ăn phung Kanan, ndrel ma phung Pêrĭsit ta bri dja bu ji biănh ma gâp. Lah bu rgum băl hăn lơh gâp, khân păng mra n'groh lơi gâp, ndrel ma rnăk vâl gâp, yorlah băl gâp geh đê̆ dơm”. ");
INSERT INTO cmo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Yơn ma bar hê khân păng ơh ma păng: “Hên mâu ŭch ôh bu jan ma oh hên tâm ban ma du huê bu ur văng târ”. ");
INSERT INTO cmo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Jêh ri Kôranh Brah lah ma Yakôp: “May lôh bơh ntŭk dja, hăn du ta ƀon Ƀêtel ri, gŭ ta ntŭk nây, jêng ntŭk Gâp lĕ tâm mpơl ma may, dôl may du nchuăt bơh Êsao nô may nơh. Ta ntŭk nây ăn may jan ntŭk jan brah ma nhhơr ndơ ma Gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jêh ri Yakôp lah ma phung rnăk vâl păng, ndrel ma dâng lĕ bunuyh gŭ đah păng: “Dâng lĕ rup brah phung bu năch ta phung khân may, ăn khân may mƀăr lơi ăn lĕ, jêh ri rao săk khân may nơm ăn kloh, ndrel ma tơh lơi bok ao khân may nây, nsoh bok ao i ueh, i mâu ôh geh rmao. ");
INSERT INTO cmo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Bân hăn du ta ƀon Ƀêtel ri. Ta ntŭk nây gâp jan ntŭk jan brah ma gŭch pur ndơ nhhơr ma Kôranh Brah, ma Nơm lĕ kơl tâng nau gâp dăn dôl gâp geh nau jêr nơh, jêh ri ăp ntŭk gâp hăn Păng gŭ ndrel gâp đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Jêh Yakôp lah kơt nây, khân păng sŏ dâng lĕ rup brah i khân păng geh, ndrel ma droh rgên bơh tôr khân păng nơm ri, ndơ̆ ăn ma Yakôp lĕ phiao. Jêh ri Yakôp sŏ lĕ ndơ nây, păng kuyh neh tŏp ta nâm tơm si kuŏng Pôthĭ kêng ƀon Sikem ri. ");
INSERT INTO cmo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Jêh bơh nây khân păng leo băl hăn drưm. Dâng lĕ ƀon dăch dăch ta ƀon nây Kôranh Brah jan ăn phung khân păng klach nsŏr hô ngăn, n'ho ma mâu ôh bănh hăn tâng phung oh kon Yakôp ri. ");
INSERT INTO cmo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jêh ri Yakôp, ndrel ma dâng lĕ phung hăn đah păng hăn tât ta ƀon Luh bri Kanan, jêng ƀon Ƀêtel đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ta ntŭk nây Yakôp jan ntŭk jan brah i nây, păng tê̆ rnha ntŭk nây «Kôranh Brah Ƀêtel», yorlah ta ntŭk nây Kôranh Brah tâm mpơl ma păng, dôl păng nchuăt bơh nô păng nơh. ");
INSERT INTO cmo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nôk nây Đêpôra khât, păng jêng bunuyh mpu toh ăn ma Rêbêka nôk hôm oh bê, jêh ri bu tŏp păng ta njŏng yôk Ƀêtel, ta nâm du mlŏm tơm jri, bu kuăl lah «Tơm jri nhŭm rngot». ");
INSERT INTO cmo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Nôk nây Yakôp lĕ plơ̆ sât tă bơh bri Pađan-Aram ri, jêh ri Kôranh Brah tâm mpơl tay ma păng du tơ̆ jât ta Ƀêtel nây, n'ho ma Kôranh Brah de ăn geh jêng ma păng, ");
INSERT INTO cmo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","lah ma păng kơt nđa: “May rnha Yakôp, yơn ma bu mâu hôm ôh kuăl may Yakôp jât, bu kuăl may Israel”. Kơt ndri Kôranh Brah tê̆ rnha păng Israel. ");
INSERT INTO cmo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kôranh Brah lah ma păng jât: “Gâp dja i brah dŭt geh nau dơi, ăn may geh kon geh sau bâk rơ̆ ăn ŏk. Mra geh du phung bunuyh tă bơh may, n'ho ma ŏk phung êng êng jât i geh tă bơh may, mra geh kađăch ŏk geh tă bơh may đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Bri i lĕ Gâp ton ăn ma Abrahăm, ndrel ma Isăk nây, Gâp ăn bri nây ma may n'ho ro tât kon tât sau may đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Jêh ri Kôranh Brah hao sât bơh ntŭk nây, bơh ntŭk Păng ngơi đah Yakôp nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jêh ri Yakôp rdŏk lŭ jan n'gŏng ta plăng ntŭk Kôranh Brah de ngơi ma păng nây nơh, păng tŏ hoch dak ndrănh play yŭng yar ƀon, ndrel ma tŏ dak ngi ta kalơ lŭ ri. ");
INSERT INTO cmo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ndri Yakôp tê̆ rnha ntŭk Kôranh Brah de ngơi ma păng nây nơh «Ƀêtel». ");
INSERT INTO cmo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jêh ri Yakôp leo rnăk vâl păng du bơh Ƀêtel. Hôm đê̆ ma tât ta ƀon Êprata, Rachel gŭ oh dŭt jêr ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Dôl păng gŭ oh geh nau jêr nây, bunuyh ndjôt ndŭl lah ma păng: “Ay lơi klach, yorlah ay geh tay du mlŏm kon bu klô jât”. ");
INSERT INTO cmo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Dôl Rachel bơi tăch n'hâm, păng tê̆ rnha kon nây «Ƀen-Ôni», rblang nau nây «Kon bu klô nau rngot gâp», yơn ma bơ̆ păng tê̆ rnha kon nây «Ƀenjamin», rblang nau nây «Kon bu klô ti bơh ma». ");
INSERT INTO cmo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel khât, jêh ri bu tŏp păng rŏ trong hăn jât ƀon Êprata, jêng ƀon Ƀêtlêhem đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakôp rdŏk lŭ jan n'gŏng ta bơh lơ môch Rachel ri, jêng n'gŏng môch Rachel n'ho ma hôm tât aƀaơ ri. ");
INSERT INTO cmo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Jêh ri Yakôp i geh rnha Israel đŏng hăn bơh ntŭk nây, păng rdŏk chun bơh năp Mĭkđal-Êđơr ti. ");
INSERT INTO cmo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Dôl Israel gŭ ta bri nây, Rupên bêch ndrel ma Ƀĭlha ur chông bơ̆ păng nơm, jêh ri Israel tăng bu nkoch nau nây. Yakôp geh kon bu klô 12 nuyh ");
INSERT INTO cmo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ta nây kon Lêa geh Rupên jêng kon bôk dak, jêh ri geh Simôn, geh Lêvi, geh Yuđa, geh Isakhar, ndrel ma geh Săpyulôn. ");
INSERT INTO cmo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Kon Rachel, ta nây geh Yôsep, ndrel ma Ƀenjamin. ");
INSERT INTO cmo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Kon Ƀĭlha, i bu ur sơm kơl jan kar ma Rachel, ta nây geh Dan, ndrel ma Năptali. ");
INSERT INTO cmo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Kon bu klô Sĭlpha, i bu ur sơm kơl jan kar ma Lêa, ta nây geh Kat, ndrel ma Asơr. Dâng lĕ phung nây jêng kon bu klô Yakôp, deh ta bri Pađan-Aram ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jêh ri Yakôp tât ta ntŭk Isăk bơ̆ păng nơm gŭ ta ƀon Mămrê, jêng ƀon Khĭriăt-Arƀa, jêng ƀon Hêbron, jêng ntŭk ƀon Abrahăm, ndrel ma Isăk veh gŭ. ");
INSERT INTO cmo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isăk rêh geh 180 năm ");
INSERT INTO cmo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","jêh ri khât, gŭ ndrel phung che păng, păng rêh nơh lĕ jŏ năm, ndrel ma lĕ ranh ngăn đŏng. Jêh ri Êsao, ndrel ma Yakôp kon păng tŏp păng. ");
INSERT INTO cmo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dja nau nkoch yao ma phung kon sau Êsao, bu kuăl păng jêng Êđŏm đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Êsao sŏ ur ta kon bu ur bri Kanan, ta nây geh Ađa i kon Êlôn jêng phung Hêt, geh Ôhôliƀama i kon Ana i sau Siƀiân jêng phung Hivi ");
INSERT INTO cmo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ndrel ma Ƀahmat i kon Ismaêl, jêng i oh Nêƀayôt. ");
INSERT INTO cmo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ađa bă Êliphah ma Êsao, Ƀahmat bă Rêhul ");
INSERT INTO cmo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","jêh ri Ôhôliƀama bă Yê-uh, bă Yalam, ndrel ma bă Kôra. Dâng lĕ phung nây jêng kon bu klô Êsao deh ta bri Kanan. ");
INSERT INTO cmo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Êsao leo ur leo kon păng, leo dâng lĕ bunuyh i gŭ ndrel păng, ndrel ma mpômpa (siŭm) phung păng, nđâp ma dâng lĕ drăp ndơ păng geh dôl păng gŭ ta bri Kanan nây, jêh ri păng hăn gŭ ta bri êng jât, jêng tâm ƀah ngai đah ma Yakôp i oh păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Dâng păng hăn kơt nây, yorlah khân păng ndrŏng ngăn, mpômpa (siŭm) phung bar hê khân păng nây mâu ôh tŏng ma gŭ ntŭk nây, kơt ndri khân păng gŭ ndrel mâu jêng ôh. ");
INSERT INTO cmo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Jêh ri Êsao gŭ rŏ yôk Sêir. Êsao nây geh rnha Êđŏm đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dja jêng mbơh nkoch rnoi deh phung kon sau Êsao, jêng che tơm ma phung Êđŏm gŭ rŏ bri yôk Sêir. ");
INSERT INTO cmo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Geh rnha săk phung kon sau bu klô Êsao: Ta nây geh Êliphah kon Ađa ur Êsao. Rêhul kon Ƀahmat ur Êsao. ");
INSERT INTO cmo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Dja jêng phung kon Êliphah: Ta nây geh Thêman, geh Ômar, geh Sêphô, geh Katham, ndrel ma Kênah. ");
INSERT INTO cmo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Êliphah kon Êsao, păng geh ur chông rnha Thĭmna, Thĭmna nây deh Amalêk. Dâng lĕ phung nây jêng kon Ađa ur Êsao. ");
INSERT INTO cmo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Dja jêng phung kon bu klô Rêhul: Ta nây geh Nahat, geh Seras, geh Sămma, ndrel ma Misa. Dâng lĕ phung nây jêng kon sau Ƀahmat ur Êsao đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Dja jêng phung kon bu klô Ôhôliƀama i ur Êsao kon Ana sau Siƀiân: Păng bă kon, ta nây geh Yê-uh, Yalam, ndrel ma Kôra. ");
INSERT INTO cmo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dja jêng mpôl kôranh ta phung kon sau Êsao. Jêh ri mpôl kôranh ta phung kon sau Êliphah kon dak bôk Êsao: Ta nây geh Thêman, geh Ômar, geh Sêphô, geh Kênah, ");
INSERT INTO cmo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","geh Kôra, geh Katham, ndrel ma Amalêk. Dâng lĕ mpôl kôranh nây jêng kon Êliphah ta bri Êđŏm, jêng kon sau Ađa dadê. ");
INSERT INTO cmo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Dja jêng mpôl kôranh ta phung kon sau Rêhul kon Êsao: Ta nây geh Nahat, geh Seras, geh Sămma, geh Misa. Dâng lĕ mpôl kôranh nây jêng kon Rêhul ta bri Êđŏm, jêng kon sau Ƀahmat ur Êsao. ");
INSERT INTO cmo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Dja jêng mpôl kôranh ta phung kon sau Ôhôliƀama ur Êsao: Ta nây geh Yê-uh, geh Yalam, ndrel ma geh Kôra. Dâng lĕ mpôl kôranh nây jêng kon sau Ôhôliƀama ur Êsao, kon Ana. ");
INSERT INTO cmo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Dâng lĕ mpôl nây jêng kon sau Êsao, ndrel ma jêng kôranh khân păng. Êsao nây păng rnha Êđŏm đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Dja jêng mpôl kon bu klô Sêir phung Hôri i gŭ ta bri Êđŏm nây: Ta nây geh Lôthan, geh Sôƀal, geh Siƀiân, geh Ana, ");
INSERT INTO cmo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","geh Đison, geh Êsơr, ndrel ma Đisan. Dâng lĕ mpôl kôranh nây jêng kon sau Sêir phung Hôri ta bri Êđŏm dadê. ");
INSERT INTO cmo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Kon bu klô Lôthan: Ta nây geh Hôri, ndrel ma Hêmam. Jêh ri i oh bu ur Lôthan rnha Thĭmna. ");
INSERT INTO cmo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Dja jêng mpôl kon bu klô Sôƀal: Ta nây geh Alvan, geh Manahat, geh Êpal, geh Sêphô, ndrel ma Ônam. ");
INSERT INTO cmo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Dja jêng mpôl kon bu klô Siƀiân: Ta nây geh Âyia, ndrel ma Ana, Ana dja say dak tu ta bri rdah, dak i nây dôh, dôl păng chiăp seh lia Siƀiân bơ̆ păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Dja jêng mpôl kon Ana: Ta nây geh Đison, ndrel ma Ôhôliƀama jêng kon bu ur. ");
INSERT INTO cmo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dja jêng mpôl kon bu klô Đison: Ta nây geh Hemđan, geh Ehƀan, geh Yĭtran, ndrel ma Kêran. ");
INSERT INTO cmo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Dja jêng mpôl kon bu klô Êsơr: Ta nây geh Ƀĭlhan, geh Savan, ndrel ma Akan. ");
INSERT INTO cmo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dja jêng mpôl kon bu klô Đisan: Ta nây geh Uh, ndrel ma Aran. ");
INSERT INTO cmo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Dja jêng mpôl kôranh ta phung Hôri: Ta nây geh Lôthan, geh Sôƀal, geh Siƀiân, geh Ana, ");
INSERT INTO cmo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","geh Đison, geh Êsơr, ndrel ma Đisan. Dâng lĕ mpôl nây jêng kôranh ma phung Hôri ta bri Sêir. ");
INSERT INTO cmo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Nôk phung kon sau Israel mâu hŏ ôh geh kađăch mât uănh, dja jêng mpôl kađăch lĕ geh ta bri Êđŏm: ");
INSERT INTO cmo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ƀêla kon Ƀêor păng jêng kađăch mât uănh bri Êđŏm, gŭ ta ƀon Đin'hapa. ");
INSERT INTO cmo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Tât lĕ khât Ƀêla, geh Yôƀap kon Seras tă bơh ƀon Ƀôhra păng trŏ jêng kađăch. ");
INSERT INTO cmo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Tât lĕ khât Yôƀap, geh Husam tă bơh bri phung Thêman păng trŏ jêng kađăch. ");
INSERT INTO cmo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Tât lĕ khât Husam, geh Hađat kon Ƀêđat păng trŏ jêng kađăch, rnha ƀon păng Avit, kađăch i nây tâm lơh đah phung Miđiân ta bri Môăp dơi păng. ");
INSERT INTO cmo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Tât lĕ khât Hađat, geh Sămla tă bơh ƀon Mahrêka păng trŏ jêng kađăch. ");
INSERT INTO cmo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Tât lĕ khât Sămla, geh Sôl tă bơh ƀon Rêhôƀôt dăch đah dak rlai Ơprat păng trŏ jêng kađăch. ");
INSERT INTO cmo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Tât lĕ khât Sôl, geh Ƀalhanan i kon Ahƀor păng trŏ jêng kađăch. ");
INSERT INTO cmo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Tât lĕ khât Ƀalhanan i kon Ahƀor, geh Hađar păng trŏ jêng kađăch, rnha ƀon păng Pao. Rnha ur kađăch nây, Mhêthapel i kon Matrêt, i sau Mêsahap. ");
INSERT INTO cmo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Dja jêng rnha mpôl kôranh ta phung kon sau Êsao, tâng ndŭl mpôl khân păng nơm, tâng bri khân păng nơm gŭ: Ta nây geh Thĭmna, geh Alua, geh Yêthêt ");
INSERT INTO cmo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","geh Ôhôliƀama, geh Êla, geh Pinôn ");
INSERT INTO cmo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","geh Kênah, geh Thêman, geh Mĭpsar, ");
INSERT INTO cmo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","geh Măkđiâl, ndrel ma Iram. Dâng lĕ mpôl nây jêng kôranh ma phung Êđŏm, tâng ntŭk khân păng gŭ, tâng bri khân păng gŭ, Êsao dja jêng che tơm ma phung Êđŏm nây. ");
INSERT INTO cmo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakôp gŭ ta bri Kanan, jêng bri bơ̆ păng veh gŭ nây nơh. ");
INSERT INTO cmo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Dja jêng nau nkoch bri ma phung kon sau Yakôp. Dôl Yôsep i kon Yakôp nây lĕ geh 17 năm, păng kơl chiăp be biăp ndrel nô nô păng, i kon Ƀĭlha, ndrel ma i kon Sĭlpha ur chông i bơ̆ păng ri. Păng mbơh nkoch ma bơ̆ păng nau djơh ta i nô nô păng. ");
INSERT INTO cmo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel i geh rnha Yakôp đŏng, păng rŏng ma Yôsep rlao đah ma kon păng ƀaƀă, yorlah nôk gŭ Yôsep nây păng lĕ ranh. Păng đă bu jâng du blah ao jong dŭt ueh ăn ma Yôsep. ");
INSERT INTO cmo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Dâng lĕ nô nô păng ri say i bơ̆ rŏng ma Yôsep rlao đah ma khân păng, jêh ri khân păng biănh ma Yôsep dadê, mâu geh ôh mbơh ngơi ueh ma ôbăl. ");
INSERT INTO cmo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Geh du nar Yôsep mbơi, jêh ri păng nkoch mbơi nây ma nô nô păng, jan ăn nô nô ri biănh ma păng lơ ma hô jât. ");
INSERT INTO cmo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Păng lah ma khân păng: “Lŏng khân may iăt gâp nkoch mbơi gâp: ");
INSERT INTO cmo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Gâp mbơi, dâng lĕ bân gŭ kât nchăp ba ta mir ri dadê, dôl nây dô ma nchăp ba gâp ri dâk sŏng jât lơ ti, lŏng nchăp ba khân may ri dâk jŭm nchăp ba gâp ri, jêh ri kŭnh mbah ma nchăp ba gâp ri dadê”. ");
INSERT INTO cmo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","I nô nô ri lah ma păng: “Lah ndri may geh nau mân ŭch jêng kôranh ma phung hên ƀah ? Mâu lah may geh nau mân ŭch mât bôk hên?” Khân păng lơ ma hô biănh ma păng, yor ma nau mbơi păng nây, nđâp ma nau păng nkoch nây. ");
INSERT INTO cmo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Jêh ri păng mbơi tay ndơ êng jât, păng nkoch mbơi nây ma nô nô păng, păng lah: “Gâp mbơi kơt nđa, nar, khay, ndrel ma mănh 11 kŭnh mbah ma gâp dadê”. ");
INSERT INTO cmo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Păng nkoch mbơi nây ma bơ̆ păng, kơt păng nkoch ma nô nô păng nơh đŏng. Bơ̆ păng lah păng: “Mơm mbơi may kơt ndri ri? Lah ndri may ŭch ăn gâp dja, mê̆ may nây, ndrel ma dâng lĕ oh nô may nây păn mbah ma may dadê bơh?” ");
INSERT INTO cmo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Dâng lĕ nô nô ri khân păng mâu nach ma Yôsep, yơn ma bơ̆ păng ri hôm kah gĭt mro nau nây ta nuih n'hâm păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Geh du nar i nô nô Yôsep, khân păng hăn chiăp be biăp bơ̆ păng ta ƀon Sikem. ");
INSERT INTO cmo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Jêh ri Yakôp i bu kuăl Israel lah ma Yôsep: “Nô nô may lĕ hăn chiăp be biăp ta ƀon Sikem ri, gâp ŭch ăn may hăn ta ri”. Yôsep ơh: “Ơ”. ");
INSERT INTO cmo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israel lah ma păng: “Hăn may hăn a nô nô may ri, gĭt ueh lăng khân păng ta ri, be biăp khân păng gĭt ueh đŏng mâu lah mâu. Jêh ri may hăn plơ̆ mbơh tay ma gâp dja”. Păng đă Yôsep tă bơh njŏng yôk Hêbron dja hăn jât Sikem ri. ");
INSERT INTO cmo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Tât ta ri, geh du huê bu klô say Yôsep hăn rsong năp rsong kơi ta ja lach ri, bu klô nây ôp: “Moh joi mre nây?” ");
INSERT INTO cmo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yôsep ơh: “Gâp joi nô nô gâp, may sơm mbơh ma gâp ưh ah ntŭk khân păng chiăp”. ");
INSERT INTO cmo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Bu klô nây ơh ma păng: “Khân păng lĕ trơn bơh ntŭk dja, yorlah gâp tăng khân păng tâm lah: «Hô̆ bân! Hăn ta ƀon Đôthan ri». Jêh ri Yôsep hăn tâng i nô nô păng, say khân păng ta ƀon Đôthan nây. ");
INSERT INTO cmo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Dôl khân păng say Yôsep hôm bơh ngai, mâu hŏ tât, khân păng lĕ tâm di băl ŭch nkhât lơi Yôsep. ");
INSERT INTO cmo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Khân păng tâm lah ndrăng khân păng nơm: “Uănh ri! Kôranh mbơi lĕ tât! ");
INSERT INTO cmo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Hô̆ bân nkhât lơi păng aƀaơ ri, lŏng ta dja geh ŏk trôm ntu, jêh ri nklăch păng ta du mlŏm trôm ntu. Bân lah lĕ mpômpa (siŭm) janh sa hêk, bân jan kơt nây, jêh ri ăn bân kŏp uănh mơm hôm jêng đŏng ta nau mbơi păng”. ");
INSERT INTO cmo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Tât Rupên tăng nau khân păng ngơi kơt nây, jêh ri păng ŭch kơl Yôsep, păng lah ma khân păng: “Lơi ôh bân nkhât păng”. ");
INSERT INTO cmo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Rupên lah jât: “Lơi ôh nchai mham păng, bân nklăch păng ta trôm ntu ta bri rdah dja hŏ, lơi ôh nkhât păng”. Rupên ngơi kơt nây, yorlah păng ŭch rklaih Yôsep bơh ti nô nô păng, jêh ri ŭch njŭn ăn păng sât a bơ̆ ri. ");
INSERT INTO cmo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yôsep hăn tât ta i nô nô ri, khân păng droh lơi ao dŭt ueh Yôsep de nsoh ri, ");
INSERT INTO cmo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","nhŭp păng nklăch ta trôm ntu ri, ntu nây mâu hôm ôh geh dak. ");
INSERT INTO cmo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Jêh ri khân păng nơm gŭ sông, dô ma khân păng n'gâl măt say phung Ismaêl du mpôl, nđâp ma seh samô khân păng tă bơh bri Kalat. Seh samô khân păng rdeng chai kroh, ndrel ma ndơ ƀô kah êng êng leo jât bri Êsip ri. ");
INSERT INTO cmo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Say kơt nây, Yuđa lah ma oh nô păng: “Lah bân nkhât oh bân, mâu ôh say ntil, jêr đŏng ma mo. ");
INSERT INTO cmo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Lah ndri bân tăch păng ăn ma phung Ismaêl dôh, lơi nkhât păng, yorlah păng oh bân, jêng mham bân đŏng”. Khân păng iăt nau păng. ");
INSERT INTO cmo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Dôl nây geh mpôl tăch drăp tât ta ri, i nô nô Yôsep n'hao păng bơh trôm ntu ri, tăch păng ăn ma phung Ismaêl khlay 20 kăk prăk. Jêh ri mpôl nây leo păng jât bri Êsip ri. ");
INSERT INTO cmo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tât Rupên plơ̆ uănh tay ta trôm ntu ri mâu hôm ôh say Yôsep, păng nkhêk bok ao păng nơm, yorlah păng rngot hô ngăn, ");
INSERT INTO cmo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","jêh ri hăn ta oh oh ri, lah ma khân păng: “Kon se nây lĕ roh jêh, lah ndri gâp dja ah jât gŭ?” ");
INSERT INTO cmo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Jêh ri khân păng nkhât du mlŏm be nkuŏng, sŏ ao Yôsep i dŭt ueh ri nơh yŭk ta mham be ri, ");
INSERT INTO cmo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","leo ao nây nhhơ ma i bơ̆ ri, mbơh ma păng: “Hên say ao dja. Lŏng may uănh bơ̆, gĭt di ao kon may ngăn mâu lah mâu?” ");
INSERT INTO cmo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakôp năl ao nây, jêh ri lah: “Ao dja ao kon gâp ngăn, lĕ bu kăp sa ro păng dja ơ, lĕ ngăn ro bu sa hêk Yôsep dja”. ");
INSERT INTO cmo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jêh ri Yakôp nkhêk bok ao păng nơm ri, nsoh n'gut ƀao chiăt, păng gŭ rngot nklŏn ma kon păng nây jŏ nar. ");
INSERT INTO cmo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Dâng lĕ oh kon păng, nđâp ma bu ur nđâp ma bu klô hăn bonh leng păng dadê, yơn ma păng mâu ôh bah nau rngot nklŏn nây, păng lah: “Gâp mra khât tâm mâp đah kon gâp, kŏ mâu bah đŏng rngot nklŏn kon gâp” ndri dâng păng hôm nhŭm nâng. ");
INSERT INTO cmo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Lŏng Yôsep nây phung Miđiân de leo păng hăn ta bri Êsip, tăch păng ăn ma Phôtiphar, kôranh mât njrăng kađăch Pharaon. ");
INSERT INTO cmo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nôk nây Yuđa du lôh bơh oh nô păng, hăn gŭ ndrel du huê bu klô ta ƀon Ađulam, rnha Hira. ");
INSERT INTO cmo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ta ntŭk nây păng say du huê bu ur drôh, kon Sua phung Kanan, păng sŏ bu ur nây jêng ur păng, gŭ ndrel păng. ");
INSERT INTO cmo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Jêh ri bu ur nây ntreo gŭ oh du huê kon bu klô, păng tê̆ rnha Êr. ");
INSERT INTO cmo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Bu ur nây ntreo gŭ oh tay du huê kon bu klô jât, n'ho ma tê̆ rnha Ônan. ");
INSERT INTO cmo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Jêh ri păng ntreo gŭ oh tay du huê kon bu klô jât, n'ho ma tê̆ rnha Sêla. Nôk păng gŭ oh i nây, Yuđa gŭ ta ƀon Kêsip ri. ");
INSERT INTO cmo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Jêh ri tât Êr i kon bôk dak ri lĕ ndăm, Yuđa ôp ur ma păng, bu ur nây rnha Tamar. ");
INSERT INTO cmo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yơn ma Êr i kon bôk dak Yuđa jêng bunuyh djơh janh ta năp măt Brah Yêhôva, kơt ndri dâng Brah Yêhôva nkhât lơi păng. ");
INSERT INTO cmo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Jêh ri Yuđa lah ma Ônan i oh Êr nây: “May sŏ mi may nây dô, jêng di ma nau vay bân, gŭ ndrel păng, gay ma hôm geh rnoi deh ma nô may”. ");
INSERT INTO cmo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Yơn ma Ônan lĕ gĭt, lah geh kon nây mâu ôh kơp jêng kon păng nơm, kơt ndri nôk păng hăn gŭ đah mi păng nây, păng nglôh lơi dak păng a neh, gay ma lơi ăn geh kon ma nô păng. ");
INSERT INTO cmo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ndơ Ônan jan nây jêng djơh ta năp măt Brah Yêhôva, Brah Yêhôva nkhât lơi păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Jêh ri Yuđa lah ma Tamar i măn păng nây: “Ƀe sât gŭ ndrô ta jay bơ̆ ƀe ri ƀŏt, mpơ ma kuŏng Sêla kon gâp” yorlah păng klach i kon dŭt păng nây khât đŏng. Jêh ri Tamar sât gŭ a jay bơ̆ păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Jŏ bơh kơi nây, i ur Yuđa kon Sua ri nơh khât. Tât Yuđa lĕ bah rngot nklŏn khât i ur nây, jêh ri păng hăn ta ƀon Thĭmna, hăn ndrel ma mât jăng păng rnha Hira bơh ƀon Ađulam, gay ma uănh bu koh rsau be biăp păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Geh bu hăn mbơh ma Tamar: “Bơ̆ po ay hăn koh rsau be biăp păng nơm ta ƀon Thĭmna”. ");
INSERT INTO cmo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tăng lah kơt nây, păng drih lơi bok ao bu ur ndrô păng nơm ri, jêh ri păng sŏ bok put lơi muh măt păng nơm, mâu ôh ăn bu gĭt năl. Păng hăn gŭ a trong dăch kêng ƀon Ênaiim, jêng trong hăn ta Thĭmna ri. Păng jan kơt nây, yorlah păng say Sêla lĕ kuŏng, tih ma mâu ôh say Yuđa sŏ păng ăn ma jêng ur Sêla. ");
INSERT INTO cmo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Dôl Yuđa say păng, Yuđa nđôn lah bu ur văng târ gay ma geh prăk, yorlah muh măt păng lĕ nkŭm lơi. ");
INSERT INTO cmo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Jêh ri Yuđa hăn dăch ta bu ur nây, păng lah: “Hô̆! Hăn bêch ndrel gâp”. Păng mâu gĭt ôh lah bu ur nây măn păng nơm chrao. Bu ur nây ơh ma păng: “Lah gâp bêch đah may, moh ndơ may ăn ma gâp?” ");
INSERT INTO cmo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Păng ơh: “Tay gâp ăn du mlŏm kon be ma ay”. Bu ur nây ơh: “Ơ gâp ŭch, lah ndri moh ndơ may nchăm ma gâp lor, gĭt jŏ may ăn kon be nây ma gâp?” ");
INSERT INTO cmo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Păng lah: “Lah ndri moh ndơ ay ŭch gâp nchăm ăn ay?” Bu ur nây ơh: “Nây, may ăn tra may, nđâp ma i rse yông nây, ndrel ma ăn mŏng ta ti may nây ma gâp”. Yuđa ăn ndơ nây ma păng, jêh ri hăn bêch đah păng. Bu ur nây n'ho ma ntreo ma păng ro. ");
INSERT INTO cmo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Jêh ri bu ur nây dâk sât, păng drih lơi bok nkŭm muh măt păng ri nơh, păng nsoh n'gut tay bok ao bu ur ndrô. ");
INSERT INTO cmo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Nôk Yuđa ăn du mlŏm kon be ta mât jăng păng i tă bơh ƀon Ađulam, gay ma ăn mât jăng nây hăn chuai ndơ păng nchăm ta bu ur nây nơh, yơn ma mât jăng nây joi bu ur nây mâu say ôh. ");
INSERT INTO cmo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Păng ôp bu ta nây: “Ah ntŭk gŭ bu ur văng târ gŭ ta meng trong lăp jât Ênaiim dja nơh?” Bu ơh: “Ta ntŭk dja mâu geh ôh bu ur văng târ”. ");
INSERT INTO cmo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Jêh ri păng sât mbơh ăn ma Yuđa: “Gâp joi bu ur nây mâu say ôh, bu ta bri nây lah: «Ta ntŭk dja mâu geh ôh bu ur văng târ»”. ");
INSERT INTO cmo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuđa lah ma păng: “Lah ndri ăn păng ndjôt kađôi ndơ gâp nchăm nây, lơi hôm joi, đit bu. Yorlah gâp lĕ ŭch ăn kon be ma păng kơt nau gâp lĕ ton, yơn ma may joi păng mâu say ôh”. ");
INSERT INTO cmo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tât pe khay bơh kơi nây, geh bu hăn mbơh ma Yuđa: “Tamar măn may bu ur văng târ, lĕ ntreo êng đah bu”. Yuđa lah: “Nglôh păng a dih dja, pur n'grêh păng ta ŭnh dôh!” ");
INSERT INTO cmo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tât bu leo păng lôh a dih dja, bu ur nây ngơi ma Yuđa bơ̆ po păng ri: “Gâp ntreo đah păng i tơm ndơ dja, lŏng may uănh, bre moh mŏng, tra, ndrel ma rse dja?” ");
INSERT INTO cmo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuđa năl lĕ ndơ nây, jêh ri lah: “Ƀe sŏng rlao gâp ngăn, yorlah gâp mâu geh ăn ƀe ma Sêla ma jêng ur kon gâp”. Ntơm bơh nây Yuđa mâu hôm ôh bêch ndrel păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tât bơi ăp khay gŭ oh, say ta trôm ndŭl păng ri geh kon bar. ");
INSERT INTO cmo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tât păng gŭ oh, geh i du huê lôh lor ti, jêh ri bunuyh ndjôt ndŭl nây sŏ rse brai gŭr kât ta ti oh bê ri, păng lah: “Kon dja ro lôh lor”. ");
INSERT INTO cmo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Yơn ma oh bê nây păng rhuăt ti lăp jât trôm ri, i nô păng lôh lor. Bunuyh ndjôt ndŭl nây lah: “Mơm may dja chrao lôh lor” jêh ri bu tê̆ rnha kon nây, Pêrês, geh nau khlay lah «Mplŭng». ");
INSERT INTO cmo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Jêh bơh nây lôh i oh ri jât, nđâp ma geh rse brai gŭr kât ta ti păng ri đŏng. Jêh ri bu tê̆ rnha kon nây «Seras», geh nau khlay lah «Trôk gŭr a ôi». ");
INSERT INTO cmo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Phung Ismaêl lĕ leo Yôsep jŭr ta bri Êsip, tăch păng ăn ma du huê phung Êsip, rnha Phôtiphar, kôranh mât njrăng kađăch Pharaon. ");
INSERT INTO cmo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Brah Yêhôva gŭ ndrel ma Yôsep, jêh ri dâng lĕ ndơ păng jan geh jêng dadê. Păng gŭ ta jay kôranh păng phung Êsip ri. ");
INSERT INTO cmo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kôranh păng say Brah Yêhôva gŭ ndrel păng, nđâp ma Brah Yêhôva jan ăn păng geh nau ueh dadê dâng lĕ ndơ păng jan. ");
INSERT INTO cmo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ndri Phôtiphar di nuih n'hâm ma Yôsep ngăn, jêh ri ăn Yôsep jan kar ma păng nơm, păng ăn Yôsep jan kôranh ta nhih jay păng, ndrel ma ăn păng dơi mât uănh dâng lĕ drăp ndơ păng geh. ");
INSERT INTO cmo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ntơm bơh Phôtiphar ăn Yôsep jan kôranh ta nhih jay păng, ndrel ma ăn păng dơi mât uănh dâng lĕ drăp ndơ păng geh, Brah Yêhôva ăn nau geh jêng ma rnăk vâl Phôtiphar nây, yor tă bơh Yôsep, jêh ri Brah Yêhôva ăn geh jêng dâng lĕ drăp ndơ păng geh, ta nhih ta jay, ta mir ta sre. ");
INSERT INTO cmo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Dâng lĕ drăp ndơ păng geh ri, păng ăn ma Yôsep mât uănh dadê, păng nơm mâu hôm ôh geh mân rvê du ntil ndơ, păng mân ma ndơ sông sa dơm. Yôsep jêng bunuyh ueh reh ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Tât bơh kơi ri, ur Phôtiphar nây say Yôsep jêh ri ŭch păng hô ngăn, n'ho ma lah: “Hăn bêch ndrel gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yôsep rlăch, păng lah ma ur kôranh păng nây: “Ta dja kôranh gâp lĕ păng ăn ma gâp dadê dâng lĕ drăp ndơ păng geh, yor ma gâp păng nơm mâu hôm ôh geh mân rvê du ntil ndơ. ");
INSERT INTO cmo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ta jay dja mâu hôm geh bunuyh êng kuŏng rlao gâp, păng ăn gâp dơi dŏng dadê dâng lĕ ndơ ta jay dja, ay du huê dơm gâp mâu dơi, yorlah ay jêng ur păng. Lah ndri mơm gâp dơi jan nau dŭt djơh dja? Gâp mâu ŭch jan tih đah ma Kôranh Brah đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bu ur nây jă Yôsep bêch ndrel păng ăp nar ngăn, yơn ma Yôsep mâu ŭch ôh iăt nau păng, bol lah gŭ dăch mâu ŭch đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Geh du nar nây, Yôsep lăp jan kar ta trôm jay ri, ta trôm jay nây mâu geh ôh bunuyh. ");
INSERT INTO cmo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ur Phôtiphar ri kuăn nâp ao Yôsep, jêh ri lah: “Hăn bêch ndrel gâp ƀŏt”. Yôsep drih ao hôm khan ta ti bu ur nây, păng nơm ri nchuăt lôh a dih. ");
INSERT INTO cmo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Bu ur nây say ao Yôsep hôm ta ti ri, i săk păng nơm lĕ nchuăt a dih, ");
INSERT INTO cmo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","jêh ri bu ur nây nter kuăl bunuyh i gŭ jan kar ta jay nây, păng mbơh ma bu: “Uănh djă, sai gâp leo phung Hêbrơ dja, păng mưch rmot gâp. Păng ŭch lăp bêch ndrel gâp, ngăch gâp de nter dŭt nteh. ");
INSERT INTO cmo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Tât tăng gâp nter nây, păng ntlơi ao ta gâp dja, păng nơm nchuăt lôh a dih ri”. ");
INSERT INTO cmo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Bu ur nây prăp ao Yôsep kêng săk păng nơm ri, n'ho ma tât sât i sai păng ta jay ri. ");
INSERT INTO cmo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Păng mbơh ma sai păng kơt nđa: “Dâk phung Hêbrơ may leo ta dja, păng ŭch tom gâp, ");
INSERT INTO cmo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","yơn ma gâp nter kuăl bu, păng nchuăt a dih, ao păng ntlơi ta gâp dja”. ");
INSERT INTO cmo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Tât ma tăng ur păng mbơh nau djơh Yôsep: “Kơt nđa dâk may nây jan ma gâp” păng ji nuih ro. ");
INSERT INTO cmo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Jêh ri păng đă bu nhŭp Yôsep krŭng ta ntŭk bu krŭng phung dôih kađăch. Dôl Yôsep gŭ ta ndrung nây, ");
INSERT INTO cmo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Brah Yêhôva hôm gŭ ndrel Yôsep, Păng nhhơ nau rŏng răp jăp Păng nơm ăn ma Yôsep, jêh ri jan ăn kôranh ndrung nây kơp păng geh nau khlay. ");
INSERT INTO cmo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Jêh ri kôranh ndrung nây ăn ma Yôsep dơi mât uănh dâng lĕ bunuyh dôih ta trôm ndrung nây, ndrel ma moh ndơ nau jan kar ta trôm ndrung nây Yôsep đŏng dơi mât uănh. ");
INSERT INTO cmo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kôranh ndrung nây păng mâu hôm ôh mân rvê moh kar Yôsep jan, yorlah Brah Yêhôva gŭ ndrel păng, lĕ kar păng jan jêng dadê. ");
INSERT INTO cmo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Jêh geh nau nây, geh bar hê bunuyh jan kar ma kađăch Êsip, du huê bunuyh jan kar ndjôt ngôr ndrănh, du huê jât bunuyh jan kar ndjôt nŭmpăng. Khân păng jan tih ma kađăch kôranh khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kađăch Pharaon ji nuih hô ngăn ma lĕ bar hê kôranh nây, du huê bunuyh ndjôt ngôr ndrănh, du huê jât bunuyh ndjôt nŭmpăng. ");
INSERT INTO cmo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ndri păng đă bu nhŭp bar hê khân păng nây krŭng ta trôm ndrung kôranh mât njrăng kađăch, ntŭk ndrung bu krŭng Yôsep ri nơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kôranh mât njrăng njŭn bar hê khân păng nây đă Yôsep sơm jan kar ma khân păng, dôl khân păng gŭ jŏ nar ta trôm ndrung nây. ");
INSERT INTO cmo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Geh du măng ri, lĕ bar hê kôranh geh ndrung nây mbơi dadê, du huê bunuyh jan kar ndjôt ngôr ndrănh, ndrel ma du huê jât bunuyh jan kar ndjôt nŭmpăng, yơn ma nau mbơi khân păng nây geh nau khlay êng băl. ");
INSERT INTO cmo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tât a ôi, Yôsep hăn mâp khân păng, say muh măt khân păng nho rơ̆ nhơ̆. ");
INSERT INTO cmo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Jêh ri păng ôp bar hê kôranh jan kar ăn ma Pharaon, bu de krŭng ndrel ma păng ta trôm ndrung kôranh păng nơm nây, păng lah: “Nar dja moh lơh khân may nho rơ̆ nhơ̆ nây?” ");
INSERT INTO cmo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Khân păng mbơh ma păng: “Hên geh mbơi, yơn ma mâu geh ôh bunuyh dơi sơm rblang nau mbơi nây”. Yôsep lah ma khân păng: “Geh Kôranh Brah dơm dơi sơm rblang nau mbơi! Dăn khân may mbơh nkoch nau mbơi nây ma gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Jêh ri bunuyh ndjôt ngôr ndrănh ma kađăch nây mbơh nkoch nau mbơi păng ma Yôsep, păng lah: “Gâp mbơi kơt nđa: Geh tơm play yŭng yar ƀon du tơm bơh năp gâp. ");
INSERT INTO cmo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Tơm play yŭng yar ƀon nây geh n'ging pe ơ̆ mâu ôh geh n'ha, jêh ri dô ma chăt nkot, kao păng dang, jêh ri geh play dŭm đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Dôl nây ngôr kađăch Pharaon gâp ndjôt ta ti gâp, gâp pĕ play yŭng yar ƀon mpet ta trôm ngôr păng ri, jêh ri gâp ndơ̆ ngôr nây ăn ta ti kađăch Pharaon”. ");
INSERT INTO cmo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yôsep lah ma păng: “Mbơi may nây kơt nđa nau rblang: N'ging pe ơ̆ nây, jêng pe nar. ");
INSERT INTO cmo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Hôm pe nar jât, kađăch Pharaon ăn may lôh bơh ntŭk dja, păng ăn may jan kar kơt ơm, may ndjôt ngôr ndrănh ta ti păng, kơt may lĕ jan kar ma păng bơh ntơm nơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tât may lĕ ueh lăng đăp mpăn tay, dăn lơi chuêl ma gâp, dăn may yô̆ nđach mbơh nkoch nau gâp ăn Pharaon gĭt, jêh ri dăn sŏ gâp lôh bơh ntŭk dja. ");
INSERT INTO cmo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Yorlah bu nhŭp gâp tă bơh phung Hêbrơ, ndra ma nhŭp dơm, gâp gŭ ta bri dja mâu đŏng mâp jan tih, bu nhŭp gâp krŭng ta trôm ndrung chrao”. ");
INSERT INTO cmo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Tât ma kôranh ndjôt nŭmpăng say ta nau mbơi nây geh nau ueh, jêh ri păng lah ma Yôsep: “Gâp mbơi kơt nđa mê̆: Gâp geh pe njơ nŭmpăng ta kalơ bôk gâp. ");
INSERT INTO cmo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ta njơ kalơ dŭt ri geh nŭm ăp ntil Pharaon vay sa, yơn ma geh siŭm hăn chok lơi nŭm ta njơ bôk gâp ri lĕ phiao”. ");
INSERT INTO cmo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yôsep lah ma păng: “Mbơi may nây kơt nđa nau rblang: Njơ pe ơ̆ nây, jêng pe nar. ");
INSERT INTO cmo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Hôm pe nar jât, Pharaon koh tong ko may, yông may ta tơm si, jêh ri geh siŭm hăn chok sa săk may”. ");
INSERT INTO cmo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tât pe nar nây, jêng di nar kađăch Pharaon jan ndrăp nhêt nkah nar deh păng nơm, păng kuăl dâng lĕ phung kôranh păng. Kađăch đă bu kuăl kôranh ndjôt ngôr ndrănh, ndrel ma kôranh ndjôt nŭmpăng ăn gŭ ta nklang phung kôranh păng ri. ");
INSERT INTO cmo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Kađăch ăn kôranh ndjôt ngôr ndrănh nây, ăn păng jan kar tay kơt păng bơh ntơm. ");
INSERT INTO cmo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Yơn ma kađăch đă bu yông ko kôranh ndjôt nŭmpăng nây, jêng tâm di kơt nau Yôsep de rblang ma khân păng ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Lŏng kôranh ndjôt ngôr ndrănh nây, păng chuêl klăk dơm, mâu hôm ôh kah gĭt ma Yôsep. ");
INSERT INTO cmo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Tât geh bar năm bơh kơi nây, kađăch Pharaon mbơi kơt nđa: Păng dâk kêng meng dak rlai Nil. ");
INSERT INTO cmo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Păng say geh pơh ơ̆ ndrôk me, lây lây ueh ngăn, lôh tă bơh dak rlai, hao sa ja ta ndrĭch. ");
INSERT INTO cmo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Jêh ri geh pơh ơ̆ ndrôk me đŏng, lôh tă bơh dak rlai su, dŭt rgây rgây rum grum ngăn, hao gŭ kêng ndrôk i lây lây ri. ");
INSERT INTO cmo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ndrôk me dŭt rgây rgây rum grum nây, păng sa lơi ndrôk me i lây lây ueh ri lĕ phiao. Jêh ri kađăch Pharaon kah rngăl bêch. ");
INSERT INTO cmo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Jêh ri păng rơi bêch jât, păng mbơi tay du tơ̆ jât. Păng mbơi say nkong ba pơh rkŭm, play săk rkŭm ngăn, i tơm păng du tơm dơm. ");
INSERT INTO cmo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Jêh ri geh đŏng nkong ba pơh rkŭm jât, lôh bơh kơi ba săk nây, yơn ma nsiăp lĕ phiao, yor ma geh sial dôh mpeh bơh lôh nar ban. ");
INSERT INTO cmo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ba nsiăp nây, sa lơi ba săk play rkŭm lĕ phiao. Jêh ri kađăch Pharaon kah rngăl bêch, nklŏn, nây jêng nau mbơi dơm. ");
INSERT INTO cmo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Tât ang ôi, kađăch Pharaon geh nau rvê hô ngăn ta nuih n'hâm păng ri, păng kuăl dâng lĕ bunuyh geh nau blao mân, ndrel ma bu n'hŭm ta bri Êsip ri ăn văch lĕ, jêh ri păng mbơh nkoch nau mbơi păng nây ma bu, yơn ma mâu geh ôh du huê bunuyh dơi rblang nau mbơi i nây. ");
INSERT INTO cmo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Dôl nây kôranh i ndjôt ngôr ndrănh, lah ma kađăch Pharaon: “Nar dja gâp lĕ kah gĭt nôk gâp tih nơh. ");
INSERT INTO cmo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Nôk kađăch ji nuih ma bar hê hên nơh, đă bu nhŭp gâp, ndrel ma kôranh ndjôt nŭmpăng krŭng ta trôm ndrung kôranh mât njrăng kađăch. ");
INSERT INTO cmo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Lĕ bar hê hên geh nau mbơi ta du măng dơm, yơn ma ta nau mbơi hên nây geh nau khlay êng băl. ");
INSERT INTO cmo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ta trôm ndrung nây geh du huê bu klô ndăm phung Hêbrơ, păng jêng bunuyh dâk ma kôranh mât njrăng kađăch, hên nkoch nau mbơi hên nây ma păng, jêh ri păng sơm rblang ăn ma hên, tâng nau hên mbơi du huê du huê nây. ");
INSERT INTO cmo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tât bơh kơi nây jêng di kơt nau păng lah ma hên ngăn, gâp dja kađăch ăn jan kar tay kơt bơh ntơm, jêh ri kôranh ndjôt nŭmpăng kađăch đă bu yông ko”. ");
INSERT INTO cmo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Jêh ri kađăch Pharaon đă bu hăn sŏ Yôsep nây ro. Bu nglôh păng bơh trôm ndrung ri, păng poyh têp, tơh kho ao, jêh ri hăn tâm mâp ma Pharaon. ");
INSERT INTO cmo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaon lah ma Yôsep: “Gâp geh nau mbơi, tih ma mâu geh ôh du huê bunuyh dơi sơm rblang. Yơn ma gâp tăng may dơi sơm rblang, lah may tăng bu nkoch mbơi nây ma may”. ");
INSERT INTO cmo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yôsep lah ma Pharaon nây: “Mâu di gâp ôh dơi sơm rblang, geh du huê Kôranh Brah dơm dơi, păng mra mbơh nau ueh ăn ma may kađăch”. ");
INSERT INTO cmo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Jêh ri Pharaon mbơh ma Yôsep: “Gâp mbơi kơt nđa: Gâp dâk kêng meng dak rlai ri. ");
INSERT INTO cmo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Dô ma geh pơh ơ̆ ndrôk me, lây lây ueh ngăn, lôh bơh dak rlai ri, hao sa ja ta ndrĭch dja. ");
INSERT INTO cmo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Jêh ri geh pơh ơ̆ ndrôk me jât, lôh tă bơh dak rlai ri đŏng, dŭt rgây rgây rum grum ngăn, say ntô ndrel ma nting dơm, gâp mâu ôh prot mâp say ndrôk dŭt djơh kơt nây ta bri Êsip dja. ");
INSERT INTO cmo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ndrôk me phung dŭt rgây rgây rum grum nây, păng sa lơi lĕ phiao ndrôk i lây lây lôh lor i ri. ");
INSERT INTO cmo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ndrôk me phung dŭt rgây nây, bol lah păng sa ndrôk me phung lây lĕ phiao kađôi đŏng, hôm e rgây kơt ơm đŏng ndrôk me phung dŭt rgây nây, jêh ri gâp kah pruh. ");
INSERT INTO cmo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Jêh ri gâp mbơi tay du tơ̆ jât, say nkong ba pơh rkŭm, play săk rkŭm ngăn, i tơm păng du tơm dơm. ");
INSERT INTO cmo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Jêh ri geh đŏng nkong ba pơh rkŭm jât, lôh bơh kơi, tih ma ba i nây khât bu tôh lĕ phiao, yor ma geh sial de pôh. ");
INSERT INTO cmo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Lŏng ba nsiăp nây, sa lơi ba săk rnglay lĕ phiao. Gâp lĕ mbơh nkoch đŏng nau mbơi gâp dja ma mpôl bu n'hŭm, yơn ma mâu geh ôh du huê bunuyh dơi sơm rblang ăn ma gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yôsep lah ma kađăch Pharaon: “Nau may mbơi nây kađăch, geh nau khlay nguai dơm, Kôranh Brah mbơh nkoch ăn ma may gĭt moh nau Păng ŭch jan. ");
INSERT INTO cmo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ntil nau khlay ndrôk me pơh ơ̆ lây lây i nây, jêng pơh năm, jêh ri ba pơh rkŭm săk rnglay i nây, jêng pơh năm đŏng, lĕ bar mbơi dja jêng geh nau khlay nguai dơm. ");
INSERT INTO cmo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ntil nau khlay ndrôk me lôh bơh kơi dŭt rgây ngăn i nây, jêng pơh năm, jêh ri ntil nau khlay ba nsiăp yor ma sial ban i nây, jêng geh nau ji ngot kuŏng jŏ pơh năm đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ơ kađăch, di kơt nau gâp lĕ jêh mbơh ma may nơh ngăn, Kôranh Brah mbơh nkoch ăn ma may gĭt moh nau Păng ŭch jan. ");
INSERT INTO cmo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hôm pơh năm, lam bri Êsip dja geh piăng ba ŏk rmeh ler ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Jêh ri pơh năm jât năp jât, geh nau ji ngot kuŏng ngăn, dâng lĕ phung ƀon lan ta bri Êsip mra chuêl lĕ phiao nau geh ŏk rmeh ta khân păng nây nơh, yorlah nau ji ngot kuŏng i nây lơh djơh ma bri khân păng ăn hêng lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Phung ƀon lan chuêl lĕ phiao nau geh ŏk rmeh ta bri khân păng nơm, yorlah nau ji ngot i nây lĕ dŭt hô ir ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Dâng may mbơi bar tơ̆ ngăn dja, yorlah lĕ Kôranh Brah ndrăp jan ngăn nau dja, Păng jan gơnh gơnh ro. ");
INSERT INTO cmo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Aƀaơ ri nđa dôh kađăch: May joi du huê bunuyh geh nau mân gĭt blao, ăn păng jan kôranh mât uănh ta bri Êsip dja. ");
INSERT INTO cmo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Jêh ri may joi bunuyh êng đŏng, gay ma rhuăt ndơ du kô̆ tâm prăm, dôl bri dak geh ba ŏk rmeh tâm pơh năm jât năp dja. ");
INSERT INTO cmo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","May ăn phung i nây rgum dâng lĕ piăng ba dôl bri dak geh ŏk rmeh tâm pơh năm dja, tôh prăp ta trôm jay ăp ƀon, jêh ri may nơm đă bu mât rƀây dâng lĕ ndơ nây. ");
INSERT INTO cmo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Piăng ba i nây prăp ma dŏng dôl bri dak geh nau ji ngot kuŏng pơh năm ta bri Êsip, gay ma lơi ôh ăn phung ƀon lan khât huăr ji ngot ”. ");
INSERT INTO cmo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nau Yôsep ngơi nây jêng di ma nuih n'hâm kađăch Pharaon ngăn, ndrel ma dâng lĕ mpôl kôranh păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Jêh ri Pharaon lah ma mpôl kôranh păng: “Mâu hôm geh bunuyh êng rlao ma păng dja, geh huêng Kôranh Brah gŭ ta păng”. ");
INSERT INTO cmo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pharaon lah ma Yôsep: “Kôranh Brah lĕ mbơh ăn ma may gĭt nau dja, lah ndri mâu hôm geh ôh bunuyh êng ma geh nau mân gĭt blao kơt may đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Gâp ăn may mât uănh ta bri Êsip dja, ndrel ma dâng lĕ phung ƀon lan gâp, khân păng iăt dadê nau may đă. Dâng gâp kuŏng rlao may, yorlah gâp gŭ ta rnơl kađăch”. ");
INSERT INTO cmo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pharaon lah tay ma Yôsep: “Aƀaơ ri gâp ăn may dơi mât uănh dâng lĕ ta bri Êsip dja”. ");
INSERT INTO cmo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Jêh ri Pharaon drih rgên tra bơh ti păng nơm ri, ndok ta ti Yôsep, sŏ ao dŭt ueh sơm nsoh ma Yôsep ri đŏng, ndrel ma sŏ rse mayh văn ta tong ko Yôsep ri jât. ");
INSERT INTO cmo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Păng ăn Yôsep ncho rdeh seh kađăch, ncho groi bơh kơi păng nơm ri, jêh ri geh bu nter lah: “Chon kô mŏk mbah păng!” Kơt ndri nau kađăch Pharaon ăn Yôsep dơi mât uănh dâng lĕ ta bri Êsip nây. ");
INSERT INTO cmo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pharaon lah tay ma Yôsep: “Gâp dja kađăch Pharaon, dâng lĕ bunuyh lam bri Êsip dja, lah mâu lôh nau tă bơh may, bu mâu dơi ôh jan du ntil ndơ”. ");
INSERT INTO cmo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kađăch Pharaon tê̆ rnha mhe ăn ma Yôsep «Săpnat-Phanah», jêh ri păng sơm ôp du huê bu ur rnha Ahnat, kon Phôthiphêra bunuyh jan brah ta ƀon Ôn, gay ma nđăp đah Yôsep. Dôl nây Yôsep hăn nsong uănh ta bri Êsip. ");
INSERT INTO cmo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yôsep lĕ geh 30 năm, nôk păng hăn tâm mâp đah kađăch Pharaon, jêh ri păng lôh bơh kađăch Pharaon nây, hăn nsong lam ntŭk ta bri Êsip ri. ");
INSERT INTO cmo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nôk pơh năm nây, ta bri Êsip geh piăng ba ŏk rmeh ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yôsep hăn rgum piăng ba dâng lĕ piăng ba ta bri Êsip ri, nôk piăng ba geh ŏk rmeh ta pơh năm nây, păng tôh piăng ba bơh mir jŭm ƀon rŏ ăp ƀon nây. ");
INSERT INTO cmo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yôsep rgum piăng ba dŭt ŏk ngăn, tâm ban ma choyh rŏ dak văch dak văr, n'ho ma mâu hôm ôh dăng kơp đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Nôk năm ê hŏ tât nau ji ngot kuŏng i nây, Yôsep, ndrel ma ur păng rnha Ahnat lĕ geh kon bu klô bar hê, ur păng nây i kon Phôthiphêra i bunuyh jan brah ta ƀon Ôn. ");
INSERT INTO cmo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yôsep tê̆ rnha ma kon bôk dak păng nây «Manasê», yorlah păng lah: “Lĕ Kôranh Brah jan ăn gâp chuêl lĕ phiao nau jêr jŏt ta gâp, ndrel ma chuêl lĕ phiao bơh ndŭl mpôl gâp nơm đŏng”. «Manasê», nteh ta nau ngơi Hêbrơ, tâm ban ma nau «Ăn chuêl». ");
INSERT INTO cmo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Păng tê̆ rnha ma kon tŏl bar «Êpraim», yorlah păng lah: “Lĕ Kôranh Brah ăn geh kon ma gâp, ntŭk gâp geh nau jêr dja”. «Êpraim», nteh ta nau ngơi Hêbrơ, tâm ban ma nau «Ăn geh kon». ");
INSERT INTO cmo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Pơh năm nau geh ŏk rmeh ta bri Êsip nây lĕ lôch jêh, ");
INSERT INTO cmo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","jêh ri ntơm geh nau ji ngot kuŏng pơh năm, kơt nau Yôsep lĕ lah nơh ngăn. Dâng lĕ bri dak êng geh nau ji ngot kuŏng dadê, hôm ta bri Êsip i ri dơm hôm geh ndơ sông sa. ");
INSERT INTO cmo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tât phung ƀon lan ta bri Êsip ntơm mâu geh ndơ sông sa, jêh ri khân păng leo băl hăn dăn piăng ba ta kađăch Pharaon, păng lah ma phung ƀon lan nây: “Khân may hăn mâp Yôsep ri dô, iăt moh nau păng đă”. ");
INSERT INTO cmo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Dôl nây nau ji ngot kuŏng lĕ lam bri Êsip ngăn. Yôsep pơk dâng lĕ jay ba rŏ ƀon êng êng ro, gay ma tăch ba ăn ma phung ƀon lan Êsip, yorlah nau ji ngot kuŏng i nây lơ ma hô ngăn ta bri Êsip ri. ");
INSERT INTO cmo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bunuyh dâng lĕ bri hăn rvăt ba Yôsep ta bri Êsip ri dadê, yorlah nau ji ngot kuŏng i nây lơ ma hô lam neh ntu dja ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Tât ma Yakôp lĕ gĭt ta bri Êsip ri geh ba, jêh ri păng lah ma oh kon păng: “Mơm gŭ khân may rŏng gŏng nây?” ");
INSERT INTO cmo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Păng lah tay ma khân păng: “Gâp tăng ta bri Êsip ri geh ba tăch. Lah ndri khân may hăn ta bri nây dô, rvăt ba gay ma bân rêh, lơi ăn khât ji ngot sa”. ");
INSERT INTO cmo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Jêh ri jât nuyh i nô nô Yôsep hăn rvăt ba ta bri Êsip ri. ");
INSERT INTO cmo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yơn ma Yakôp mâu ôh ăn Ƀenjamin i oh Yôsep hăn ndrel nô nô păng, yorlah klach geh nau tât jêr ma păng. ");
INSERT INTO cmo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Jêh ri i kon kon Yakôp i bu kuăl Israel đŏng, hăn rvăt ba ndrel bu aƀă êng đŏng, yorlah ta bri Kanan i nây geh nau ji ngot kuŏng đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Dôl nây Yôsep jan kôranh kuŏng mât uănh ta bri Êsip, păng i nây đŏng tơm tăch ba ăn dâng lĕ phung ƀon lan lam bri. I nô nô păng hăn tât ta ri păn mbah păng. ");
INSERT INTO cmo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yôsep năl i nô nô păng ro, yơn ma mâu ôh ăn i nô nô năl păng. Păng ngơi janh ma khân păng: “Bơh tă khân may?” Khân păng ơh: “Ơ kôranh, hên dja tă bơh bri Kanan, hăn joi rvăt ndơ sông sa”. ");
INSERT INTO cmo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yôsep năl khân păng, yơn ma khân păng mâu ôh gĭt năl Yôsep. ");
INSERT INTO cmo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Dôl nây Yôsep kah gĭt nau mbơi ma i nô nô păng păn mbah ma păng. Păng lah ma i nô nô păng: “Khân may jêng bunuyh hăn mêt uănh ta bri dja dơm, gay ma uănh ntŭk mâu geh tahen ŏk”. ");
INSERT INTO cmo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Khân păng ơh: “Mâu ôh kôranh, hên dja i bunuyh sơm jan kar ma may, hăn rvăt ndơ sông sa ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Dâng lĕ hên dja du bơ̆ bă dơm, hên jêng bunuyh sŏng ngăn, mâu geh ôh bunuyh hăn mêt uănh ntŭk ”. ");
INSERT INTO cmo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Păng ơh: “Khân may mƀrôh! Khân may hăn ta dja gay ma mêt uănh ntŭk mâu geh tahen ŏk dơm”. ");
INSERT INTO cmo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Khân păng ơh: “Ơ kôranh, dâng lĕ oh nô hên geh 12 nuyh, jêng du bơ̆ bă dơm, hên gŭ ta bri Kanan. Aƀaơ dja oh dŭt hên hôm gŭ ndrel bơ̆ hên, jêh ri oh hên du huê ri lĕ khât”. ");
INSERT INTO cmo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yơn ma Yôsep lah ma khân păng: “Di kơt nau gâp lah ngăn, khân may dja jêng bunuyh hăn mêt uănh ntŭk! ");
INSERT INTO cmo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Gâp ŭch rlong ma khân may: Gâp ton ma khân may ta kađăch Pharaon, lah oh khân may mâu tât ta dja, khân may mâu dơi ôh lôh bơh ntŭk dja. ");
INSERT INTO cmo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Khân may ăn du huê hăn sŏ oh dŭt khân may bơh ri, khân may aƀă nây krŭng ta dja ƀŏt, yorlah gâp ŭch gĭt khân may ngơi ngăn lah mâu. Lah mâu ngăn, gâp ton ta kađăch Pharaon, khân may jêng bunuyh hăn mêt uănh ntŭk ngăn ro”. ");
INSERT INTO cmo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Jêh ri Yôsep đă bu krŭng i nô nô păng ri pe nar. ");
INSERT INTO cmo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Tât pe nar, Yôsep ngơi ma khân păng: “Lah khân may ŭch rêh, khân may jan kơt nđa dô, yorlah gâp jêng bunuyh klach yơk Kôranh Brah: ");
INSERT INTO cmo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Lah khân may jêng bunuyh sŏng ngăn, khân may ăn du huê ta mpôl khân may nây krŭng ta dja, jêh ri khân may aƀă nây hăn sât ta bri khân may nơm, ndrel ma ndjôt leo piăng ba ma geh ndơ sông sa ta rnăk vâl ma bah ji ngot. ");
INSERT INTO cmo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Jêh ri leo oh dŭt khân may hăn ta dja, gay ma gĭt nau khân may ngơi nây jêng ngơi ngăn. Ndri khân may mâu khât ôh”. Khân păng jan kơt nây, ");
INSERT INTO cmo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","jêh ri khân păng tâm lah ndrăng khân păng nơm: “Say ƀah, bân tih yor ma bân jan djơh ma oh bân nơh ro, yorlah bân say păng dŭt rngot ngăn dăn bân kơl păng, tih ma bân mâu ôh iăt păng. Kơt ndri dâng nau jêr dja geh ta mpôl bân đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rupên lah ma khân păng: “Lĕ gâp lah ma khân may nơh, lơi nkhât păng, khân may mâu iăt nau gâp. Aƀaơ dja dâng bân geh nau jêr, yor ma bân lĕ nchai mham oh bân nơh”. ");
INSERT INTO cmo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Khân păng mâu gĭt ôh lah Yôsep iăt nau khân păng ngơi nây gĭt dadê, yorlah nôk păng ngơi ma khân păng geh bunuyh sơm rblang ăn. ");
INSERT INTO cmo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yôsep du bơh ntŭk khân păng nây nhŭm êng, jêh ri păng plơ̆ ngơi tay đah khân păng. Păng sŏ Simôn kât ta năp măt oh nô păng ri. ");
INSERT INTO cmo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yôsep đă bu tŏl mbêng ba ăn ma nô nô păng, nđâp ma mplơ̆ prăk tê̆ ta dŭng prăk ta trôm ƀao khân păng nơm đŏng, ndrel ma ăn ndơ khân pre ma sông sa rŏ trong jât. Bu jan ma khân păng kơt nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Khân păng dăp ba ta kalơ seh lia khân păng nơm ri, jêh ri hăn sât. ");
INSERT INTO cmo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tât ta ntŭk rlu rŏ trong ri, geh du huê ta mpôl khân păng ri drih ƀao, sŏ mpa gay ma ăn seh lia sa, păng say dŭng prăk ta bŏr ƀao păng nơm. ");
INSERT INTO cmo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Păng mbơh ma oh nô păng: “Uănh djă, prăk gâp lĕ bu mplơ̆, bu ăn ta trôm ƀao dja”. Dôl nây dâng lĕ khân păng ndrŏt dadê, khân păng klach nsŏr ngăn, jêh ri tâm lah ndrăng khân păng nơm: “Mơm Kôranh Brah jan ma bân!” ");
INSERT INTO cmo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Jêh ri khân păng sât tât ta bri Kanan ta bơ̆ khân păng nơm ri, khân păng mbơh nkoch ăn ma bơ̆ khân păng nơm, moh nau geh ta khân păng nơh. ");
INSERT INTO cmo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Khân păng lah: “Kôranh mât uănh ta bri Êsip nây ngơi dŭt janh ngăn ma hên, ndrel ma ntôn hên jêng bunuyh hăn mêt uănh ntŭk đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Yơn ma hên ơh ma păng: «Hên dja jêng bunuyh sŏng, mâu ôh di bunuyh hăn mêt uănh ntŭk. ");
INSERT INTO cmo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Hên geh 12 nuyh oh nô, hên du bơ̆ bă dơm, oh hên du huê lĕ khât, hôm oh dŭt gŭ ndrel bơ̆ hên ta bri Kanan ri». ");
INSERT INTO cmo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kôranh mât uănh ta bri Êsip nây lah ma hên kơt nđa: «Aƀaơ dja nđa dô, gay ma gĭt nau khân may ngơi nây ngơi ngăn lah mâu: Khân may ăn du huê bunuyh ta mpôl khân may nây gŭ ta dja, khân may aƀă nây hăn sât ta bri khân may nơm ri, ndrel ma ndjôt leo piăng ba ăn ma rnăk vâl khân may nơm a ri ma bah ji ngot dô. ");
INSERT INTO cmo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Jêh ri leo oh dŭt khân may bơh ri hăn tâm mâp ndrel gâp. Kơt ndri dâng gâp gĭt lah khân may jêng bunuyh sŏng, mâu ôh di bunuyh hăn mêt uănh ntŭk. Tay dâng gâp ƀơk bunuyh dja, jêh ri khân may hăn rsong rvăt ndơ ta bri dja mâu chrao ôh»”. ");
INSERT INTO cmo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tât ma khân păng nkhŭt ƀao ba, ăp nơm khân păng, khân păng say dŭng prăk ta trôm ƀao ba khân păng nơm ri dadê. Tât ma say dŭng prăk i nây, khân păng, ndrel ma bơ̆ khân păng klach hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakôp i bơ̆ ri lah ma khân păng: “Khân may jan ăn gâp roh lĕ kon, Yôsep roh, Simôn roh, aƀaơ dja khân may ŭch sŏ Ƀenjamin hăn jât, jan ăn gâp ôh nuih ôh n'hâm ngăn”. ");
INSERT INTO cmo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rupên lah ma bơ̆ păng: “Ơ bơ̆, lah gâp mâu ôh leo Ƀenjamin plơ̆ nsât ăn may, may nkhât lơi dô kon bu klô gâp bar hê nây! May ăn păng hăn ndrel gâp, bơ̆, tay gâp leo păng plơ̆ sât ma may ngăn ro”. ");
INSERT INTO cmo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yơn ma Yakôp lah: “Gâp mâu ôh ăn kon n'glĕ dŭt gâp hăn ndrel khân may, yorlah nô păng lĕ khât đŏng, hôm e du huê păng dơm. Lah moh geh nau moh rman rŏ trong dôl păng hăn ndrel khân may nây, lah ndri jan ăn gâp lĕ ranh ngăn dja khât, yor ma klŏng rngot hô ir nây đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Nau ji ngot kuŏng ta bri Kanan nây lơ ma hô lơ ma hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tât ma lĕ sa ba rvăt tă bơh bri Êsip nây nơh, Yakôp lah ma oh kon păng: “Hăn plơ̆ rvăt tay ba aƀă ta bri Êsip ri hŏm”. ");
INSERT INTO cmo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuđa ơh ma bơ̆ păng: “Bunuyh i nây lah ma hên nđa ngăn: «Lah khân may mâu leo oh dŭt khân may hăn ta dja, gâp mâu ăn khân may mâp gâp ôh». ");
INSERT INTO cmo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ơ bơ̆, lah may ăn păng hăn ndrel hên, ndri mơ dâng hên hăn rvăt ba. ");
INSERT INTO cmo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Yơn ma lah may mâu ăn păng hăn, hên mâu hăn đŏng, yorlah bunuyh nây lĕ lah ma hên: «Lah khân may mâu leo oh dŭt khân may hăn ta dja, gâp mâu ăn khân may mâp gâp ôh!»” ");
INSERT INTO cmo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel i bu kuăl Yakôp đŏng lah ma khân păng: “Hay, moh njô lah khân may jan djơh ma gâp, mbơh nkoch ma bunuyh nây lah hôm geh oh dŭt du huê hay!” ");
INSERT INTO cmo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Khân păng ơh: “Bunuyh i nây ôp hên hăch mpơ̆ lơ̆ ntil ngăn, ndrel ma ôp ndŭl mpôl bân, păng lah: «Bơ̆ khân may hôm rêh đŏng? Khân may hôm geh oh nô đŏng?» Jêng hên ơh kơt nau păng ôp nây, ơm hên gĭt lah păng đă oh hăn ta bri Êsip lah?” ");
INSERT INTO cmo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuđa dăn ma Israel bơ̆ păng ri: “Ơ bơ̆, may ăn oh nây hăn ndrel gâp dô. Ndri hên hăn aƀaơ dja ro, gay ma bân rêh, lơi ăn khât, nđâp ma may, nđâp ma sau sau may, nđâp ma hên đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Gâp bănh ton păng ma may, lah mâu ôh say gâp njŭn păng ma may, lah ndri gâp geh dôih đah may lĕ du njăr rêh gâp. ");
INSERT INTO cmo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Lah hên mâu gŭ njong, hên brô̆ lĕ geh bar tơ̆ plơ̆ ro”. ");
INSERT INTO cmo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Dŭt ma dêl Israel i bơ̆ ri lah ma khân păng: “Lah ndri nđa dô, khân may ndjôt ndơ dŭt ueh tă bơh bri bân dja ăn ma bunuyh i nây ƀă, khân may ndjôt ndơ ƀô kah ăp ntil ƀă, dak sŭt ƀă, nđâp ma găr tôh ăp ntil ƀă đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Khân may ndjôt prăk ta săk ăn ŏk rlao khân mre bơh năp nơh bar tơ̆, prăk i ma rvăt tay ba, ndrel ma prăk i khân may say ta ƀao nơh đŏng, klăp lah bu vĭ dăp. ");
INSERT INTO cmo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Jêh ri leo oh khân may nây hăn aƀaơ dja mâp bunuyh i ri hŏm. ");
INSERT INTO cmo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Dăn Kôranh Brah nơm i dŭt geh nau dơi jan ăn ma bunuyh nây geh nau yô̆ nđach ma khân may, gay ma ƀơk ăn Simôn, ndrel Ƀenjamin plơ̆ sât ndrel ma khân may đŏng. Gâp dja lah mâu hôm geh kon, phalah dơm”. ");
INSERT INTO cmo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Jêh ri khân păng ndjôt ndoh ndơ nây, nđâp ma prăk ŏk bar tơ̆, ndrel ma leo Ƀenjamin đŏng, hăn ta bri Êsip, hăn tâm mâp đah Yôsep ri. ");
INSERT INTO cmo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Tât ta bri Êsip, Yôsep say Ƀenjamin hăn ndrel nô nô păng, păng lah ma bunuyh mât uănh nhih jay păng ri: “Leo khân păng lăp ta jay gâp, jêh ri mbang mpômpa (siŭm) jan trao, yorlah dâng lĕ khân păng i nây sông nar ndrel ma gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Păng jan kơt nau Yôsep de đă ma păng, jêh ri leo khân păng i nây hăn lăp ta jay Yôsep. ");
INSERT INTO cmo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Khân păng klach hô ngăn, say bu leo lăp ta jay Yôsep, khân păng tâm lah ndrăng khân păng nơm: “Dâng bu njŭn bân hăn ta dja a, yor ma prăk ta trôm ƀao nơh ro. Bu leo bân hăn ta dja a, yorlah bu gay ma tê̆ dôih bân, gay ma sŏ lơi seh lia bân, n'ho ma sŏ bân gŭ jan dâk jât”. ");
INSERT INTO cmo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tât ta bôk mpông jay ri, khân păng hăn dăch ma bunuyh mât uănh nhih jay Yôsep, jêh ri ngơi đah păng: ");
INSERT INTO cmo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ơ kôranh, nar bơh kơi nơh hên hăn rvăt ba ta dja lĕ du tơ̆. ");
INSERT INTO cmo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Hên sât tât ta ntŭk rlu ri, hên drih ƀao, say dŭng prăk ta trôm ƀao ba hên nơm ri dadê, râng kơt ơm. Nar dja hên ndjôt tay prăk nây ndơ̆ ma may, ");
INSERT INTO cmo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","yorlah hên mâu gĭt, bu moh tê̆ prăk nây ta trôm ƀao ba hên. Jêh ri hên ndjôt tay prăk a êng jât ma rvăt tay ba”. ");
INSERT INTO cmo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Bu klô i nây ơh ma khân păng: “Lơi ôh rvê, gŭ đăp mpăn hŏ, Kôranh Brah khân may nơm, Kôranh Brah bơ̆ khân may nơm sơm ăn prăk nây ta trôm ƀao khân may. Yorlah prăk khlay khân may rvăt ba nơh lĕ râng ta gâp dja dadê”. Jêh ri păng ƀơk Simôn ăn gŭ ndrel khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Jêh ri păng leo khân păng i nây lăp ta trôm jay Yôsep ri, sơm sŏ dak ăn khân pre ma rao jŏng, ndrel ma sŏ mpa ma ăn seh lia khân păng de sa đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Khân păng lĕ ndrăp lơi dâng lĕ ndơ ma ăn Yôsep, dôl gŭ kŏp Yôsep tât ta nây, yorlah khân păng lĕ gĭt khân păng gŭ sông nar ta ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Tât sât Yôsep ta jay ri, dâng lĕ khân păng sŏ ndơ nây njŭn ăn ma Yôsep, jêh ri păn mbah păng. ");
INSERT INTO cmo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yôsep ôp nau ueh lăng khân păng: “A lor nơh khân may mbơh ma gâp lah geh bơ̆ lĕ ranh ngăn, ah ueh lăng đŏng păng? Păng hôm rêh đŏng bơh?” ");
INSERT INTO cmo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Khân păng ơh: “Bơ̆ hên hôm rêh, kôranh mê, păng ueh lăng đŏng”. Jêh mbơh nây, khân păng păn mbah păng dadê. ");
INSERT INTO cmo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Jêh ri Yôsep uănh say Ƀenjamin, oh du ndŭl deh đah păng nơm, păng ôp khân păng: “Dja oh dŭt khân may mbơh nkoch ma gâp nơh ƀah? Dăn Kôranh Brah ăn nau geh jêng ma may oh”. ");
INSERT INTO cmo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yôsep rngot hô ngăn say oh păng, jêh ri păng hăn nhŭm ta trôm jrô păng nơm ri, yorlah păng mâu ôh dơi ăt. ");
INSERT INTO cmo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Păng rpôh muh măt phiao, lôh a dih dja, păng nsrôyh ăt ngăn, jêh ri đă bu pư piăng trao. ");
INSERT INTO cmo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Bu pư piăng trao ma Yôsep ăn êng, phung Êsip i gŭ ta ri gŭ sông êng, mpôl oh nô păng ri ăn gŭ sông êng. Nau vay ta phung Êsip mâu ôh ăn sông ndrel phung Hêbrơ, yorlah khân păng uănh nau nây ƀơ̆ ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Mpôl oh nô Yôsep gŭ sông rle măt jât păng ri dadê, bu ăn khân păng gŭ tâng bôk nô, ntơm bơh nô bôk dak, tât ma oh dŭt, dâng lĕ khân păng ndrŏt dadê ngăn, mâu vât ôh mơm dâng bu gĭt. ");
INSERT INTO cmo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yôsep đă bu sŏ ndơ sa bơh năp păng nơm ri, ăn ma mpôl oh nô păng, yơn ma Ƀenjamin bu ăn ŏk rlao prăm tơ̆ đah ma khân păng aƀă. Khân păng nhêt sông ndrel Yôsep maak ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Jêh ri Yôsep đă ma bunuyh i mât uănh nhih jay păng nây: “Tŏl ăn bêng bêng ƀao khân păng, dah dơi khân păng ndjôt, jêh ri tê̆ dŭng prăk khân păng nơm ta trôm ƀao khân păng nơm du huê du huê. ");
INSERT INTO cmo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","May uănh bu moh i kon se rlao bu i ri, jêh ri may tê̆ ngôr prăk gâp dja ta trôm ƀao păng, ndrel ma prăk khlay rvăt ba nây nơh”. Bunuyh i nây jan kơt nau Yôsep de đă ma păng ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tât ang ôi, bu ăn khân păng hăn, ndrel ma seh lia khân păng nơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Khân păng lôh bơh ƀon nây ê hŏ ngai ôh, Yôsep lah ma bunuyh mât uănh nhih jay păng: “Tâng hŏm phung dja ăn tât ban, tât ban khân păng may lah kơt nđa: «Moh khân may jan kơt nđay, bu lĕ jan ueh ma khân may, khân may jan djơh ma bu chrao? ");
INSERT INTO cmo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Khân may gĭt ƀah? Ngôr nây kôranh gâp vay dŏng ma nhêt, ndrel ma nau chrŏng, khân may jan kơt nây geh dôih jru ngăn»”. ");
INSERT INTO cmo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Jêh ri bunuyh nây tâng khân păng tât ban, păng lah khân păng i nây kơt nau Yôsep de đă ma păng nơh. ");
INSERT INTO cmo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Khân păng tâm ơh đah păng: “Moh may lah hên kơt ndri ri kôranh? Hên mâu ôh geh jan kơt nau may lah ri. ");
INSERT INTO cmo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Prăk hên say ta trôm ƀao hên nơh, lĕ hên ndjôt mplơ̆ ăn may tă bơh bri Kanan, lah ndri mơm hên hôm blao ntŭng đŏng prăk mayh ta trôm jay kôranh may? ");
INSERT INTO cmo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Lah ndri bu moh bunuyh may say joi ngôr i nây ta mpôl hên dja, bunuyh i nây may nkhât lơi dô, jêh ri sŏ dâng lĕ hên dja gŭ jan dâk ma may ro”. ");
INSERT INTO cmo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Bunuyh nây ơh ma khân păng: “Ơ, lah ndri jan kơt nau khân may lĕ lah ri dôh, bu moh ƀao gâp say ngôr nây, bunuyh i nây ăn gŭ jan dâk gâp, bunuyh aƀă mâu hôm đŏng ôh geh dôih”. ");
INSERT INTO cmo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Jêh ri dâng lĕ khân păng njŭr ƀao a neh dadê ro, drih ƀao i ri. ");
INSERT INTO cmo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Bu nuyh nây rhi uănh ntơm bơh ƀao nô bôk dak, n'ho ma tât ƀao oh dŭt, păng say ngôr i nây ta trôm ƀao Ƀenjamin. ");
INSERT INTO cmo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Lŏng i nô nô ri, rngot hô ngăn, nkhêk bok ao khân păng nơm, pư drăp ndơ dăp ta kalơ seh lia, jêh ri plơ̆ tay ta ƀon Yôsep nây. ");
INSERT INTO cmo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuđa ndrel ma oh nô păng plơ̆ jât kơi, tât ta jay Yôsep ri, say păng hôm ta nây đŏng. Khân păng păn ta neh ta năp păng. ");
INSERT INTO cmo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yôsep lah ma khân păng: “Moh khân may jan kơt nđay, khân may mâu gĭt ƀah, gâp dja jêng bunuyh blao chrŏng ngăn?” ");
INSERT INTO cmo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuđa ơh ma păng: “Hên mâu hôm ôh geh nau ơh ma kôranh đŏng, hên mâu hôm geh nau ngơi đŏng, yorlah lĕ Kôranh Brah nhhơ jêh nau tih hên, aƀaơ dja dâng lĕ hên dja, ndrel ma bunuyh ntŭng ngôr i nây, hên gŭ jan dâk ma kôranh”. ");
INSERT INTO cmo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yôsep ơh ma khân păng: “Gâp mâu ôh jan kơt nđay, bu moh ƀao say ngôr, bunuyh i nây du huê dơm gâp sŏ jan dâk. Khân may aƀă nây plơ̆ sât ta rnăk vâl, ta bơ̆ khân may nơm ri ma nau đăp mpăn dô”. ");
INSERT INTO cmo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuđa hăn dăch a Yôsep ngơi ma păng: “Ơ kôranh, dăn may yô̆ nđach ma gâp, lơi ji nuih ma gâp, ăn gâp ngơi đah may du tong, may tâm ban ma kađăch Pharaon đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","May lĕ ôp hên: «Khân may geh bơ̆, geh oh đŏng?» ");
INSERT INTO cmo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Hên lĕ mbơh nkoch ma may: «Hên geh bơ̆ lĕ ranh ngăn, ndrel ma oh dŭt du huê, nôk deh păng i nây bơ̆ hên lĕ ranh, i nô păng lĕ khât đŏng, du mê̆ bă păng hôm păng i nây du huê dơm, bơ̆ hên rŏng ma păng i nây hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","May lĕ lah ma hên: «Leo păng hăn ta gâp dja, gâp be ma say muh măt păng». ");
INSERT INTO cmo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Jêh ri hên lĕ mbơh nkoch ma may: «Oh hên i nây mâu ôh dơi ƀah ngai đah bơ̆ hên, lah ƀah ngai bơ̆ hên khât ro». ");
INSERT INTO cmo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","May lĕ lah ma hên i bunuyh sơm jan kar ma may: «Lah oh dŭt khân may mâu ôh hăn ta dja, khân may mâu mâp muh măt gâp jât». ");
INSERT INTO cmo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tât hên plơ̆ sât a bơ̆ hên ri, hên mbơh nkoch nau may lah nây ma păng. ");
INSERT INTO cmo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Bơ̆ hên lah ma hên: «Khân may hăn plơ̆ rvăt tay ba aƀă ăn ma bân jât». ");
INSERT INTO cmo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Hên ơh ma păng: «Hên mâu dơi ôh hăn, oh dŭt i nây hăn ndrel hên, ndri mơ dâng hên hăn plơ̆ rvăt tay, lah păng i nây mâu hăn ndrel hên, bu mâu ôh ăn hên hăn mâp muh măt bunuyh i ri ». ");
INSERT INTO cmo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Jêh ri bơ̆ hên lah ma hên: «Khân may lĕ gĭt đŏng, ur gâp bă kon ma gâp kon bu klô bar ơ̆ dơm. ");
INSERT INTO cmo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kon nguai lĕ roh đŏng, gâp mân lah lĕ mpômpa (siŭm) bri sa hêk lĕ phiao ro, gâp mâu hôm ôh say muh măt păng, n'ho ma tât nar dja. ");
INSERT INTO cmo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Aƀaơ dja khân may ŭch sŏ păng i nây leo hăn a ri đŏng, lah geh nau moh rman tât jêr ma păng, khân may jan ăn gâp i lĕ ranh ngăn dja khât, yor ma nau djơh». ");
INSERT INTO cmo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Aƀaơ dja lah hên sât mâp bơ̆ hên, lah oh hên i nây mâu hăn ndrel hên, yorlah bunuyh i nây bơ̆ hên rŏng hô ngăn, ");
INSERT INTO cmo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","lah mâu say păng, bơ̆ hên khât ngăn ro. Lah ndri hên jan ăn bơ̆ hên lĕ ranh khât, yor ma klŏng rngot hô ir. ");
INSERT INTO cmo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Gâp lĕ ton ma bơ̆ gâp: «Lah gâp mâu leo păng plơ̆ sât ma may bơ̆, gâp geh dôih ma may lĕ du njăr nau rêh gâp». ");
INSERT INTO cmo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ơ kôranh, lah ndri dăn may ăn gâp gŭ jan dâk ma may ta dja trŏ oh gâp. May ăn păng i nây plơ̆ sât ndrel oh nô gâp a ri. ");
INSERT INTO cmo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Lah may mâu ăn păng i nây sât ndrel gâp, mơm gâp bănh hăn mâp bơ̆ gâp? Yorlah gâp mâu ŭch say nau rngot bơ̆ gâp nây”. ");
INSERT INTO cmo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yôsep mâu hôm ôh dơi ăt rdâng nuih n'hâm ta năp phung gŭ kêng păng ri, jêh ri păng đă bu du lôh bơh ntŭk nây lĕ phiao. Nôk Yôsep nhhơ săk păng nơm ăn ma oh nô păng năl, bu aƀă mâu ôh gŭ ta nây. ");
INSERT INTO cmo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yôsep nhŭm lŭng loch ngăn, tăng tât ta phung Êsip, ndrel ma phung gŭ ta jay kađăch Pharaon ri ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yôsep lah ma oh nô păng: “Gâp dja Yôsep! Ah bơ̆ gâp hôm rêh đŏng?” Mpôl oh nô păng mâu hôm ôh blao ơh, khân păng klach dadê, yorlah lĕ say Yôsep bơh năp khân păng nơm ri. ");
INSERT INTO cmo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yôsep lah ma khân păng: “Gâp dăn khân may hăn dăch a gâp dja” khân păng hăn dăch a Yôsep to. Jêh ri lah ma khân păng: “Gâp dja Yôsep oh khân may, i khân may tăch ăn ma phung Êsip nơh. ");
INSERT INTO cmo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ơ nô, khân may lơi rvê, lơi hôm ôh rngot nau khân may lĕ tăch gâp dja nơh, yorlah jêng Kôranh Brah nơm njŭn ăn gâp hăn lor ta dja, gay ma kơl khân may. ");
INSERT INTO cmo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Lŏng aƀaơ dja nau ji ngot kuŏng i nây lĕ geh bar năm, yơn ma hôm prăm năm jât năp jât, mâu ôh geh bunuyh ma tuch tăm, ma kăch roih. ");
INSERT INTO cmo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kôranh Brah njŭn ăn gâp hăn lor ta dja, gay ma rgum prăp piăng ba ma ăn khân may hôm rêh ta neh ntu dja, dja jêng nau rklaih dŭt kuŏng ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Lah ndri mâu geh ôh khân may njŭn gâp hăn ta dja, Kôranh Brah i năk njŭn gâp, Kôranh Brah ăn gâp jan kôranh dŭt kuŏng ma kađăch Pharaon, ăn gâp mât uănh dâng lĕ ta nhih jay păng, ndrel ma ăn gâp jan kôranh mât uănh lam bri Êsip dja. ");
INSERT INTO cmo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ơ nô, khân may hăn plơ̆ a bơ̆ ri ăn gơnh hŏm, mbơh nkoch ma păng kơt nđa: «Ơ bơ̆, Yôsep kon may dăn ntĭnh, Kôranh Brah ăn kon jan kôranh mât uănh lam bri Êsip, dăn bơ̆ hăn tâm mâp đah kon ta dja ro, lơi ôh kŏp jŏ. ");
INSERT INTO cmo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","May gŭ ta bri Kôsen tâm dăch đah ntŭk gâp gŭ, nđâp ma may nơm, nđâp ma kon ma sau may, nđâp ma ndrôk ma be biăp may, ndrel ma dâng lĕ ndơ may geh. ");
INSERT INTO cmo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Tay gâp pêt siăm may ta bri i nây, ndrel ma rnăk vâl may, mâu ôh ăn khân may khât ji ngot sa, yorlah hôm prăm năm jât nau ji ngot kuŏng dja». ");
INSERT INTO cmo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ơ nô, dâng lĕ khân may, ndrel ma oh Ƀenjamin lĕ say jêh gâp ta dja, gâp ngăn ngơi ndrel khân may. ");
INSERT INTO cmo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ơ nô, khân may mbơh nkoch ma bơ̆ bân ri tay, dâng lĕ nau dơi gâp jan ta bri Êsip dja, ndrel ma dâng lĕ ndơ khân may lĕ say. Ăn gơnh khân may leo bơ̆ hăn ta dja”. ");
INSERT INTO cmo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yôsep ut Ƀenjamin n'ho ma nhŭm ta oh păng ri, Ƀenjamin kơt ndri đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yôsep ut nô nô păng dâng lĕ, nhŭm đŏng, jêh ri khân păng tâm mbơh ngơi nkoch bri đah păng. ");
INSERT INTO cmo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Nau i nây tăng tât ta jay kađăch Pharaon ri ngăn, lah oh nô Yôsep lĕ tât ta ri, Pharaon, ndrel ma phung kôranh păng răm maak ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kađăch Pharaon lah ma Yôsep: “May lah ma oh nô may kơt nđa: «Ndrăp seh lia khân may nây plơ̆ sât hŏm ta bri Kanan ri, ");
INSERT INTO cmo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","jêh ri leo bơ̆, ndrel ma rnăk vâl khân may hăn ta dja, tay gâp ăn ntŭk ueh rlao bu ta bri Êsip dja ma khân may, jêh ri khân may sa ndơ i kah rlao bu đŏng ta bri dja». ");
INSERT INTO cmo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","May lah đŏng ma khân păng: «Ăn khân may ndjôt rdeh bơh bri Êsip dja ma nchuăn rdeng ur kon khân may, ndrel ma bơ̆ khân may hăn ta dja. ");
INSERT INTO cmo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Lơi ôh pơh drăp ndơ khân may, yorlah ndơ ueh rlao bu ta bri Êsip dja jêng ndơ khân may»”. ");
INSERT INTO cmo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Jêh ri mpôl oh kon Israel jan tâng kơt nây. Yôsep sŏ rdeh ăn ma khân păng kơt nau Pharaon lah ma păng, ndrel ma ăn ndơ khân păng sông sa rŏ trong đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yôsep ăn bok ao mhe ma nô nô păng du blah du huê du huê, yơn ma păng ăn prăk ma Ƀenjamin 300 kăk prăk, ndrel ma prăm blah bok ao. ");
INSERT INTO cmo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Păng njuăl ndơ ma bơ̆ păng, seh lia jât ơ̆, geh nđâp ma ndơ ueh ueh tă bơh bri Êsip, seh lia me jât ơ̆, geh nđâp ma ba dăp ta kalơ ri, ndrel ma ndơ ăn bơ̆ păng sông sa rŏ trong tay. ");
INSERT INTO cmo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Jêh ri Yôsep ăn oh nô păng sât, n'ho ma ntĭnh khân păng: “Lơi ta khân may tâm rlăch tâm lŏk rŏ trong ri tay”. ");
INSERT INTO cmo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Khân păng lôh bơh bri Êsip, sât ta Yakôp bơ̆ khân păng nơm, ta bri Kanan ri. ");
INSERT INTO cmo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Tât ta bri nây, khân păng mbơh nkoch ma bơ̆ khân păng: “Kon may Yôsep hôm rêh, păng jan kôranh mât uănh lam bri Êsip ngăn”. Yơn ma Yakôp mâu ôh ji bôk ji tôr, yorlah păng mâu ôh iăt nau khân păng mbơh nkoch nây. ");
INSERT INTO cmo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tât ma khân păng mbơh nkoch dâng lĕ nau Yôsep de ntĭnh ri nơh, say rdeh Yôsep de njuăl gay ma rdeng păng hăn ta bri Êsip, ri mơ Yakôp ntơm ndrŏt săk. ");
INSERT INTO cmo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Jêh ri Israel i bu kuăl Yakôp đŏng lah: “Lĕ gâp iăt hơyh! Yôsep kon gâp păng hôm rêh, gâp ŭch hăn mâp păng ê lor ma gâp khât”. ");
INSERT INTO cmo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jêh ri Israel i bu kuăl Yakôp đŏng, ndjôt dâng lĕ drăp ndơ păng geh hăn ndrel păng nơm. Tât ta ƀon Ƀêrsêƀa ri, păng gŭch nhhơr ndơ jan brah ma Kôranh Brah i brah Isăk bơ̆ păng nơm yơk mbah. ");
INSERT INTO cmo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kôranh Brah ngơi ma Israel ta nau tâm say nôk măng: “Ơ Yakôp! Ơ Yakôp!” Israel ơh: “Moh hă Kôranh Brah!” ");
INSERT INTO cmo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kôranh Brah lah ma păng: “Gâp dja Kôranh Brah i brah bơ̆ may yơk mbah. May lơi ôh klach hăn ta bri Êsip, yorlah ta bri i nây tay Gâp jan ăn may jêng du phung kuŏng. ");
INSERT INTO cmo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Gâp hăn ndrel may ta bri Êsip nây, jêh ri tay Gâp leo may plơ̆ bơh bri i nây đŏng. Tât may khât Yôsep sơm rdêp măt may”. ");
INSERT INTO cmo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jêh ri Yakôp lôh bơh Ƀêrsêƀa nây, phung oh kon Israel rdeng bơ̆ khân păng nơm, ndrel ma ur kon khân păng nơm ma rdeh kađăch Pharaon de njuăl ri nơh. ");
INSERT INTO cmo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Khân păng ndjôt dâng lĕ mpômpa (siŭm) dâng lĕ drăp ndơ khân păng nơm geh ta bri Kanan, leo ndrel khân păng nơm dadê. Yakôp leo rnoi deh păng nơm lĕ phiao hăn ta bri Êsip. ");
INSERT INTO cmo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yakôp leo kon bu ur kon bu klô, sau bu ur sau bu klô, ndrel ma dâng lĕ rnoi deh păng nơh, hăn ta bri Êsip ri ndrel păng nơm dadê. ");
INSERT INTO cmo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Dja jêng geh rnha săk phung kon sau Israel hăn ta bri Êsip: Yakôp, ndrel ma dâng lĕ oh kon păng. Kon bôk dak Yakôp rnha Rupên. ");
INSERT INTO cmo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Kon bu klô Rupên, ta nây geh: Hanŭk, geh Phalu, geh Hesrŭn, ndrel ma Karmi. ");
INSERT INTO cmo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Kon bu klô Simôn: Ta nây geh Yêmuel, geh Yamin, geh Ôhat, geh Yakin, geh Sôhar, ndrel ma Sôl. Mê̆ Sôl bu ur phung Kanan. ");
INSERT INTO cmo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Kon bu klô Lêvi: Ta nây geh Kêrson, geh Kêhat, ndrel ma Mrari. ");
INSERT INTO cmo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Kon bu klô Yuđa: Ta nây geh Êr, geh Ônan, geh Sêla, geh Pêrês, ndrel ma Seras. (Kon bar hê Êr, ndrel ma Ônan lĕ khât ta bri Kanan.) Kon bu klô Pêrês: Ta nây geh Hesrŭn, ndrel ma Hamŭl. ");
INSERT INTO cmo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Kon bu klô Isakhar: Ta nây geh Thôla, geh Puva, geh Yôp, ndrel ma Simrôn. ");
INSERT INTO cmo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Kon bu klô Săpyulôn: Ta nây geh Sêret, geh Êlôn, ndrel ma Yaliâl. ");
INSERT INTO cmo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Dâng lĕ khân păng i nây jêng kon Lêa dadê, păng bă ăn ma Yakôp dôl gŭ ta bri Pađan-Aram nơh, ndrel ma Đina kon bu ur păng. Dâng lĕ kon Lêa, nđâp ma sau păng geh 33 nuyh. ");
INSERT INTO cmo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Kon bu klô Kat: Ta nây geh Sêphŭn, geh Haki, geh Suni, geh Êhƀon, geh Êri, geh Arôđi, ndrel ma Arêli. ");
INSERT INTO cmo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Kon bu klô Asơr: Ta nây geh Yĭmna, geh Yihua, geh Isvi, geh Ƀêriya, ndrel ma Sêra oh bu ur. Kon Ƀêriya: Ta nây geh Hêpơr, ndrel ma Mălkiâl. ");
INSERT INTO cmo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Dâng lĕ khân păng i nây jêng kon sau Sĭlpha i Laƀan de ăn ma Lêa nơh. Dâng lĕ kon Sĭlpha, nđâp ma sau păng geh 16 nuyh. ");
INSERT INTO cmo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Kon bu klô Rachel ur Yakôp: Ta nây geh Yôsep, ndrel ma Ƀenjamin. ");
INSERT INTO cmo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ta bri Êsip Yôsep geh bar hê kon bu klô: Ta nây geh Manasê, ndrel ma Êpraim. Ahnat kon bu ur Phôthiphêra bunuyh jan brah ta ƀon Ôn bă khân păng ma Yôsep. ");
INSERT INTO cmo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Kon bu klô Ƀenjamin: Ta nây geh Ƀêla, geh Ƀêkơr, geh Ahƀêl, geh Kêra, geh Naman, geh Êhi, geh Rôh, geh Muphim, geh Huphim, ndrel ma Arơt. ");
INSERT INTO cmo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dâng lĕ khân păng i nây jêng kon sau Rachel dadê, kon sau Rachel dâng lĕ geh 14 nuyh. ");
INSERT INTO cmo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Kon bu klô Dan: Ta nây geh Husim. ");
INSERT INTO cmo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Kon bu klô Năptali: Ta nây geh Yasiâl, geh Kuni, geh Yêsơr, ndrel ma Silêm. ");
INSERT INTO cmo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dâng lĕ khân păng i nây jêng kon Ƀĭlha i Laƀan de ăn ma Rachel nơh. Kon sau Ƀĭlha ăn ma Yakôp dâng lĕ geh 7 nuyh. ");
INSERT INTO cmo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Dâng lĕ kon sau Yakôp hăn ndrel păng nơm ta bri Êsip, geh 66 nuyh, mâu ôh kơp ƀăn ƀăn păng. ");
INSERT INTO cmo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Lah kơp nđâp ma kon Yôsep bar hê deh ta bri Êsip ri đŏng, dâng lĕ bunuyh ta rnăk vâl Yakôp hăn gŭ ta bri Êsip geh 70 nuyh. ");
INSERT INTO cmo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakôp đă Yuđa hăn lor mâp Yôsep, gay ma ôp trong hăn jât bri Kôsen, jêh ri Yakôp ndrel ma rnăk vâl păng hăn tât ta bri Kôsen. ");
INSERT INTO cmo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yôsep ăn bu ndrăp rdeh seh păng nơm, jêh ri ncho hăn chuă Yakôp i bu kuăl Israel bơ̆ păng nơm ta bri Kôsen, tât ta ri păng ut bơ̆ păng, n'ho ma nhŭm jong ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel lah ma Yôsep: “Aƀaơ dja lah gâp khât mâu chrao ôh, yorlah lĕ gâp say muh măt may hôm e rêh”. ");
INSERT INTO cmo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yôsep ngơi ma oh nô păng, nđâp ma dâng lĕ bunuyh i hăn ndrel khân păng: “Gâp hăn mbơh nkoch ma kađăch Pharaon lah: «Dâng lĕ oh nô gâp, ndrel ma rnăk vâl bơ̆ gâp bơh bri Kanan, aƀaơ dja khân păng lĕ tât ta dja. ");
INSERT INTO cmo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Khân păng leo nđâp ma ndrôk, ma be biăp, ndrel ma dâng lĕ mpômpa (siŭm) khân păng geh, yorlah khân păng jêng bunuyh chiăp, nau rêh khân păng nơh gŭ mât mpômpa (siŭm) dơm». ");
INSERT INTO cmo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Lah kađăch Pharaon ôp khân may: «Khân may moh ƀă vay jan?» ");
INSERT INTO cmo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ăn khân may ơh ma păng kơt nđa: «Ơ kôranh, hên vay chiăp ntơm bơh jê̆ n'ho ma tât aƀaơ dja, kơt phung che hên kăl e nơh đŏng». Lah khân may ơh ma păng kơt nây, khân may geh gŭ ta ntŭk bri Kôsen dja ro, yorlah phung Êsip mưch hô ngăn ma phung chiăp”. ");
INSERT INTO cmo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yôsep hăn mbơh nkoch ma kađăch Pharaon: “Bơ̆ gâp, ndrel ma oh nô gâp, khân păng lĕ lôh tă bơh bri Kanan, leo nđâp ma ndrôk, ma be biăp, ndrel ma dâng lĕ ndơ khân păng geh, aƀaơ dja khân păng lĕ tât ta bri Kôsen”. ");
INSERT INTO cmo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yôsep leo oh nô păng prăm nuyh hăn mâp kađăch Pharaon. ");
INSERT INTO cmo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pharaon ôp khân păng: “Moh ndơ khân may vay jan?” Khân păng ơh: “Ơ kôranh, hên jêng phung chiăp kơt phung che hên kăl e nơh đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Khân păng ngơi tay ma kađăch: “Ơ kôranh, hên dăn gŭ ta bri dja du ƀlât, yorlah ta bri Kanan geh nau ji ngot kuŏng, rêp ja ma ăn mpômpa (siŭm) sa mâu hôm geh đŏng. Kơt ndri hên dăn may rom hên ăn hên gŭ ta bri Kôsen”. ");
INSERT INTO cmo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pharaon lah ma Yôsep: “Bơ̆ may, ndrel ma oh nô may lĕ tât ta may. ");
INSERT INTO cmo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ăn may kơih bri i ueh rlao bu ăn ma bơ̆ may, ndrel ma oh nô may, moh bri i may ŭch, lah may ŭch, ăn khân păng gŭ ta bri Kôsen nây dô. Ta phung khân păng i nây bu moh may say i blao, ăn păng jan kôranh mât uănh ma mpômpa (siŭm) gâp nơm đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Jêh ri Yôsep leo bơ̆ păng hăn mâp kađăch Pharaon đŏng, Yakôp dăn nau geh jêng Kôranh Brah ăn ma Pharaon. ");
INSERT INTO cmo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pharaon ôp Yakôp: “Dah ŏk năm may che?” ");
INSERT INTO cmo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakôp mbơh nkoch ma kađăch Pharaon: “Năm gâp gŭ rêh aƀaơ dja lĕ geh 130 năm. Năm gâp đê̆ dơm, nau rêh gâp mâu geh nau ueh đŏng, gâp rêh mâu ôh jŏ jong kơt phung che gâp”. ");
INSERT INTO cmo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakôp dăn nau geh jêng Kôranh Brah ăn ma Pharaon du tơ̆ jât, jêh ri păng lôh bơh ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Jêh ri Yôsep ăn neh dŭt ueh ta bri Êsip ăn ma bơ̆ păng, ndrel ma oh nô păng, jêng ndơ ma khân păng nơm, păng ăn khân păng gŭ ta bri Kôsen dăch kêng ƀon Rămseh, kơt nau Pharaon de lah. ");
INSERT INTO cmo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yôsep mât siăm bơ̆ păng, ndrel ma oh nô păng, nđâp ma dâng lĕ bunuyh gŭ ta rnăk vâl khân păng ri, tâng ŏk bunuyh khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nau ji ngot kuŏng hô ngăn, lam bri dak mâu ôh geh piăng sông, bunuyh ta bri Êsip, ndrel ma ta bri Kanan geh nau jêr jŏt hô ngăn, yor ma ji ngot kuŏng i nây. ");
INSERT INTO cmo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yôsep lĕ tăch ba ăn ma bri Êsip, ndrel ma bri Kanan, păng rgum dâng lĕ prăk tăch ba i nây, jêh ri njŭn ta jay kađăch Pharaon, tât ma mâu hôm ôh geh prăk ta dâng lĕ bri i nây. ");
INSERT INTO cmo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Prăk ma rvăt ba mâu hôm ôh ta bri Êsip, ndrel ma ta bri Kanan lĕ phiao, dâng lĕ phung ƀon lan Êsip khân păng hăn mâp ma Yôsep dadê, ngơi đah păng: “Dăn may ăn piăng ba ma hên, lah may mâu ăn, hên khât ta năp may ngăn ro, yorlah hên mâu hôm geh prăk ma rvăt”. ");
INSERT INTO cmo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yôsep ơh ma khân păng: “Lah khân may mâu hôm geh prăk, khân may ăn mpômpa (siŭm) khân may ma gâp, tay gâp ăn piăng ba ma khân may sông”. ");
INSERT INTO cmo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Jêh ri khân păng leo mpômpa (siŭm) khân păng nơm ăn ma Yôsep, Yôsep ăn piăng ba ma khân păng, tâm rgâl đah seh, đah be biăp, đah ndrôk, đah seh lia. Yôsep ăn piăng ba ma khân păng năm nây, tâm rgâl đah mpômpa (siŭm) khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Năm nây lĕ lôch jêh, lăp năm êng, khân păng hăn mâp tay Yôsep du tơ̆ jât, khân păng ngơi đah păng: “Ơ kôranh, hên dăn mbơh nkoch ma may, hên mâu ôh pôn mo, prăk ta săk hên lĕ phiao, mpômpa (siŭm) hên lĕ hên njŭn ăn may lĕ phiao đŏng, hên mâu hôm ôh geh ndơ du ntil, hôm e neh, ndrel ma săk hên nơm du ri dơm hôm. ");
INSERT INTO cmo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ơ kôranh, gay ma hên hôm rêh, dăn may rvăt neh hên, ndrel ma săk hên nơm tâm rgâl đah piăng ba may nây, ăn hên gŭ jan dâk Pharaon, ndrel ma neh hên ăn jêng drăp ndơ păng, yorlah, lah hên khât lĕ phiao neh hên nây bu moh ma ndơn? Dăn kôranh ăn ba ntil ma hên, gay ma hên hôm rêh, mâu khât, lơi ôh ăn bri dak rngot rngăt”. ");
INSERT INTO cmo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yôsep rvăt lĕ phiao neh ta bri Êsip ăn ma kađăch Pharaon, dâng lĕ phung Êsip tăch neh mir khân păng nơm yor ma nau ji ngot kuŏng i nây lơ ma hô ngăn, kơt ndri neh lam bri i nây jêng neh Pharaon dadê. ");
INSERT INTO cmo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Jêh ri dâng lĕ phung ƀon lan lam bri Êsip nây jêng dâk dadê. ");
INSERT INTO cmo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Neh phung bunuyh jan brah dơm Yôsep mâu rvăt, yorlah phung i nây geh Pharaon sơm ăn piăng ba, kơt ndri dâng neh khân păng mâu tăch. ");
INSERT INTO cmo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yôsep lah ma phung ƀon lan: “Nar dja lĕ gâp rvăt jêh săk khân may nơm, ndrel ma neh khân may ăn ma kađăch Pharaon. Aƀaơ dja gâp ăn ntil ba ma khân may, khân mre ma tuch tăm. ");
INSERT INTO cmo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Tât khay lĕ kăch lĕ rek tay, khân may ăn du kô̆ tâm prăm (1/5) ma Pharaon, jêh ri puăn kô̆ ma khân may nơm, gay ma geh ntil, ndrel ma ndơ sông sa ma khân may nơm, ma oh kon khân may, nđâp ma bunuyh gŭ ta nhih jay khân may đŏng”. ");
INSERT INTO cmo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Phung ƀon lan lah ma Yôsep: “May lĕ rklaih nau rêh phung hên. Lah may ŭch, tay hên gŭ jan dâk ma Pharaon”. ");
INSERT INTO cmo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yôsep ăn nau vay ta bri Êsip n'ho ma tât aƀaơ dja, đă phung Êsip ăn ma Pharaon du kô̆ tâm prăm ndơ khân păng geh tă bơh neh nây, neh phung bunuyh jan brah dơm mâu jêng ndơ Pharaon. ");
INSERT INTO cmo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Phung Israel gŭ rêh ta bri Êsip, khân păng gŭ ta ntŭk Kôsen, geh neh ta ntŭk nây, khân păng bă oh bă kon ŏk bâk rơ̆ ngăn ta ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakôp gŭ rêh ta bri Êsip geh 17 năm. Dâng lĕ năm păng rêh geh 147 năm. ");
INSERT INTO cmo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Tât Israel i bu kuăl Yakôp đŏng, bơi ma khât, păng kuăl kon păng Yôsep, ntĭnh ma păng: “Ơ nô, lah may rŏng ma gâp, may tê̆ ti may i nây ta nâm tâm blu gâp dja, nđâp ma ton, ăn may jan ueh, jan sŏng ma gâp, may lơi ôh tŏp gâp ta bri Êsip dja! ");
INSERT INTO cmo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","May tŏp gâp ta ntŭk tŏp phung che gâp, may rdeng gâp lôh bơh bri Êsip dja, jêh ri tŏp gâp ta ntŭk môch phung che gâp nơm”. Yôsep ơh ma păng: “Tay gâp jan kơt nau may lah bơ̆”. ");
INSERT INTO cmo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakôp lah tay ma păng: “Lah ndri may ton ma gâp” ndri Yôsep ton ma păng. Jêh ri Yakôp i bu kuăl Israel đŏng yơk mbah Kôranh Brah ta bôk bêch păng nơm ri. ");
INSERT INTO cmo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Bơh kơi nây, geh bu mbơh ma Yôsep bơ̆ păng ji. Yôsep hăn chop bơ̆ păng, păng leo kon bu klô păng bar hê hăn ndrel păng nơm: Manasê, ndrel ma Êpraim. ");
INSERT INTO cmo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Bu mbơh ma Yakôp: “Kon may Yôsep hăn chop may”. Yakôp i bu kuăl Israel đŏng nsrôyh dâk gŭ ta gre ri, ");
INSERT INTO cmo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","jêh ri lah ma Yôsep: “Kôranh Brah nơm i dŭt geh nau dơi, Păng văch ăn gâp say Păng ta ƀon Luh bri Kanan, Păng ăn geh jêng ma gâp. ");
INSERT INTO cmo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Kôranh Brah lah ma gâp: «Tay Gâp jan ăn may geh oh geh kon bâk rơ̆ ŏk ngăn, n'ho ma geh ŏk phung bunuyh tă bơh may. Tay Gâp ăn bri dja ma kon sau may, jêng ntŭk ma khân păng nơm n'ho ro». ");
INSERT INTO cmo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Kon bu klô may bar hê deh ta bri Êsip dôl gâp ê hŏ tât ta dja, kơp jêng kon gâp, Êpraim, ndrel ma Manasê, khân păng i nây jêng kon gâp, tâm ban ma Rupên, ndrel ma Simôn đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kon may deh bơh kơi bơh kơi nây, i nây kơp kon may, khân păng sŏ dơn neh ta neh Êpraim, ndrel ma Manasê đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Dôl gâp plơ̆ sât tă bơh bri Pađan-Aram, Rachel mê̆ may khât ta ti gâp nơm, dăch kêng ƀon Êprata bri Kanan, gâp tŏp mê̆ may rŏ trong hăn jât ƀon Êprata”. Êprata jêng ƀon Ƀêtlêhem. ");
INSERT INTO cmo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel say kon bu klô Yôsep, păng ôp: “Bu moh bar hê nây?” ");
INSERT INTO cmo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yôsep ơh: “Khân păng kon gâp, Kôranh Brah ăn ma gâp ta bri dja”. Israel lah ma păng: “Leo khân păng hăn dăch ta gâp dja, gâp be ma dăn Kôranh Brah ăn nau geh jêng ma khân păng”. ");
INSERT INTO cmo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Dôl nây măt Israel lĕ ngo, uănh mâu hôm ôh say, yorlah săk păng lĕ ranh. Yôsep leo khân păng hăn dăch ta Israel, jêh ri păng ut, ndrel ma chŭm i sau sau păng ri. ");
INSERT INTO cmo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel ngơi ma Yôsep: “A lor nơh, gâp mâu gĭt lah hôm say muh măt may nđa, yơn ma aƀaơ dja Kôranh Brah ăn gâp say nđâp ma rnoi deh may jât”. ");
INSERT INTO cmo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Jêh ri Yôsep têk kon păng bar hê i nây ƀah đah kô mŏk bơ̆ păng, jêh ri chon mon kô mŏk păn a neh. ");
INSERT INTO cmo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Jêh nây Yôsep leo kon păng hăn dăch ta i bơ̆ tay jât, păng ăn Êpraim mpeh bơh ma păng nơm, jêng mpeh bơh chiao Israel, Manasê mpeh bơh chiao păng nơm, jêng mpeh bơh ma Israel. ");
INSERT INTO cmo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israel tê̆ ti, păng rplăch ti ma tê̆ ta bôk Êpraim i oh, jêh ri păng tê̆ ti chiao ta bôk Manasê jêng kon bôk dak, bol lah Manasê jêng kon bôk dak kađôi, Israel jan kơt nây păng lĕ gĭt n'hêl nanê̆. ");
INSERT INTO cmo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Jêh ri Israel dăn Kôranh Brah ăn geh jêng ma Yôsep, păng lah: “Dăn Kôranh Brah i brah Abrahăm, ndrel ma i brah Isăk vay yơk mbah Dăn Kôranh Brah i mât njrăng gâp ntơm bơh jê̆ tât aƀaơ dja, i tâm ban ma bunuyh chiăp mât njrăng mpômpa (siŭm) phung păng nơm ");
INSERT INTO cmo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Dăn tông păr Kôranh Brah nơm i lĕ rklaih jêh gâp bơh ăp ntil nau jêr, dăn Păng ăn geh jêng ma kon bu klô bar hê dja Ăn bu hôm kah gĭt ma rnha săk gâp, rnha săk Abrahăm jêng che, ndrel ma rnha săk Isăk bơ̆ gâp, yor ma bar hê khân păng dja. Dăn ăn ma bar hê khân păng dja geh oh geh kon bâk rơ̆ ăn ŏk ngăn ta neh ntu dja”. ");
INSERT INTO cmo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yôsep say bơ̆ păng tê̆ ti bơh ma ta bôk Êpraim, păng mâu ôh maak. Păng kuăn ti bơ̆ păng tâm rgâl bơh bôk Êpraim tê̆ ta bôk Manasê. ");
INSERT INTO cmo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yôsep mbơh ma bơ̆ păng: “Mâu ôh di kơt nây ơ bơ̆, i dja kon bôk dak, may tê̆ ti ma may ta bôk păng”. ");
INSERT INTO cmo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Bơ̆ păng mâu ôh iăt, păng lah ma Yôsep: “Ơ nô, gâp lĕ gĭt, gâp lĕ gĭt jêh Manasê jêng kon bôk dak, păng tay geh du phung kuŏng đŏng. Yơn ma Êpraim geh du phung kuŏng rlao păng ngăn. Rnoi deh Êpraim mra ŏk phung êng êng kuŏng kuŏng ngăn”. ");
INSERT INTO cmo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Nar nây Israel ăn geh jêng ma khân păng bar hê i nây, păng lah: “Jât năp tay, dâng lĕ phung Israel, mra dăn Kôranh Brah ăn nau geh jêng ma bu kơt nđa: «Dăn Kôranh Brah jan ăn may jêng tâm ban ma Êpraim, tâm ban ma Manasê»”. Kơt ndri Israel kơp Êpraim khlay rlao đah ma Manasê. ");
INSERT INTO cmo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israel ngơi ma Yôsep: “Gâp bơi ma khât jêh, yơn ma Kôranh Brah mra gŭ ndrel khân may, ndrel ma leo khân may plơ̆ sât tay ta bri phung che khân may. ");
INSERT INTO cmo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Gâp ŭch pă neh ăn may kuŏng rlao đah ma phung oh nô may, jêng neh dăch ta ƀon Sikem nây, ntŭk i gâp lĕ dơi pit tâm lơh đah phung Amôri ma đao, ma na dŭt gâp nơm nây nơh”. ");
INSERT INTO cmo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakôp i bu kuăl Israel đŏng, păng kuăl dâng lĕ kon păng văch ta ri dadê, jêh ri lah: “Dăn khân may hăn râng dadê, gay ma gâp mbơh nkoch ăn khân may gĭt moh nau geh ta nar jât năp dja tay. ");
INSERT INTO cmo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Ơ phung kon sau Yakôp, văch râng hŏm gay ma iăt Iăt hŏm nau Israel bơ̆ khân may nơm. ");
INSERT INTO cmo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ơ Rupên, may jêng kon bôk dak gâp Gâp bă may lor bu dôl gâp geh suan dŭt dăng May bu lư rlao bu, ndrel ma geh nau dơi rlao bu đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","May dăng tâm ban ma dak rbuh, mâu ôh dơi ăt dơi rdâng, tih ma may mâu ôh jan bôk Yorlah may hao kalơ gre gâp May bêch ndrel ma ur gâp, jan ăn gre gâp ar. ");
INSERT INTO cmo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simôn, ndrel ma Lêvi jêng oh nô du ndŭl deh Nuih n'hâm khân păng hăt janh ngăn, khân păng nkhât bu ma đao. ");
INSERT INTO cmo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Gâp mâu ôh ŭch gŭ ndrel khân păng Nôk khân păng tâm nchră nau jan djơh. Yorlah nôk khân păng ji nuih, khân păng nkhât bu nơh Jêh ri khân păng koh lơi jŏng jon ndrôk nkuŏng dah khân păng nơm ŭch dơm. ");
INSERT INTO cmo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Gâp rak rtăp lơi nau ji nuih khân păng, yor ma khân păng hăt janh hô ir Jêh ri ta nau ji nuih khân păng jan ndơ dŭt djơh hô ngăn, dah khân păng nơm ŭch Gâp mra nchah lơi khân păng bar hê i nây ta rnoi deh gâp Mâu ôh ăn gŭ ndrel du ntŭk ta bri Israel. ");
INSERT INTO cmo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ơ Yuđa, oh nô may mra rnê may dadê ngăn May tay dơi lơh đah phung rlăng ma may Oh nô may tay păn yơk ma may dadê. ");
INSERT INTO cmo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ơ Yuđa kon gâp, may jêng tâm ban ma kon yao mŭr Sât hơm bơh kăp sa mpômpa (siŭm) May tâm ban ma yao mŭr i păn nsan May tâm ban ma yao mŭr i bêch, mâu geh ôh bunuyh bănh rkhuak. ");
INSERT INTO cmo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mŏng tăk jra kađăch geh ta may nâng Rnoi deh may tay mra jêng kađăch mro mrăng N'ho ma tât truyh păng i geh nau dơi kuŏng nây Nđâp ma dâng lĕ phung bunuyh lam ntŭk iăt nau păng dadê. ");
INSERT INTO cmo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Păng ndrŏng ngăn, ndri dâng păng kât seh lia păng nơm ta tơm play yŭng yar ƀon, bol lah tơm play nây dŭt khlay Păng mâu ôh rvê seh lia sa i play i n'ha nây Păng pih ao păng nơm ma dak ndrănh play yŭng yar ƀon Pih bok păng nơm ma dak play yŭng yar ƀon i chăng tâm ban ma mham. ");
INSERT INTO cmo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Trôm măt păng chăng ngăn rlao ma dak ndrănh play yŭng yar ƀon Nglang sêk păng rlao ma dak toh ndrôk jât. ");
INSERT INTO cmo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Săpyulôn tay gŭ rŏ meng dak văch dak văr Ntŭk păng jêng ntŭk nsrŭng duk kuŏng N'hăr neh păng n'ho ma tât ta ƀon Siđôn ri ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakhar jêng tâm ban ma seh lia dŭt dăng Păng bêch ta vah vang n'gar be biăp. ");
INSERT INTO cmo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Păng mân lah ntŭk păng gŭ rlu nây jêng ntŭk ueh Ndrel ma dơh đŏng Jêh ri păng kŭnh săk păng nơm ăn bu dŏng rdeng drăp ndơ Tâm ban ma dâk bu ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan jêng kôranh mât uănh mpôl ƀon lan păng nơm Kơt mpôl êng êng ta phung Israel dâng lĕ đŏng ");
INSERT INTO cmo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Păng jêng tâm ban ma bêh hung rŏ trong Tâm ban ma bêh ku gŭ ta meng trong Kŏp chôk ta jŏng jon seh Jêh ri bunuyh i gŭ ncho ta kalơ ri tŭp a neh”. ");
INSERT INTO cmo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Jêh ri Yakôp mbơh sơm lah: “Ơ Brah Yêhôva, gâp hôm kŏp nar may rklaih gâp”. Jêh ri păng n'ho ma lah ma oh kon păng jât: ");
INSERT INTO cmo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Kat geh phung tahen hăn lơh păng Yơn ma păng hăn lơh phung tahen i nây tă bơh kơi. ");
INSERT INTO cmo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asơr geh ndơ sông sa kah ngăn Păng tay ăn ndơ sông sa kah ngăn ma ăn kađăch sa. ");
INSERT INTO cmo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Năptali jêng tâm ban ma nkrŏng me lĕ klaih Păng bă kon ueh ueh ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yôsep jêng tâm ban ma n'ging geh play ŏk N'ging geh play ŏk hon kêng meng n'hong dak N'ging păng prêh rlao mpêr ƀon ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Phung rlăng tâm lơh đah păng Bu pănh păng ma na ");
INSERT INTO cmo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Yơn ma Yôsep hôm dăng rlao Păng hôm dăng ngăn, yor ma geh nau dơi Kôranh Brah i gâp yơk mbah. Kôranh Brah dŭt geh nau dơi ngăn, mâu geh ôh bunuyh dơi đŏng. Kôranh Brah mât uănh phung Israel, tâm ban ma nơm chiăp mpômpa (siŭm) phung. Kôranh Brah dŭt nâp ma kơl njrăng, tâm ban ma lŭ klêr mâu ôh dơi n'gơ. ");
INSERT INTO cmo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Kôranh Brah i brah gâp yơk mbah mra kơl may Kôranh Brah nơm i dŭt geh nau dơi mra ăn nau geh jêng ma may Păng mra ăn geh dak mih ma may Păng mra ăn geh dak lôh tă bơh dŏng su ma may Ndrel ma ăn may geh kon ŏk, nđâp ma geh mpômpa (siŭm) ŏk đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Nau geh jêng gâp dăn Kôranh Brah ăn ma may dja Jêng kuŏng rlao ma nau geh jêng phung che gâp dăn bơh Kôranh Brah ăn ma gâp Jêng prêh rlao ma yôk dŭt nâp n'ho ro jât Dăn dâng lĕ nau geh jêng dja ăn geh ta may Dăn ăn geh ta bôk may i lĕ Kôranh Brah tâm nkhah jêh đah phung oh nô may. ");
INSERT INTO cmo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ƀenjamin jêng tâm ban ma so bri dŭt janh A ôi păng hăn kăp sa hêk mpômpa (siŭm) Tât kêng măng păng tâm pă mpa păng gleng i nây”. ");
INSERT INTO cmo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Dâng lĕ phung khân păng i nây jêng mpôl rnoi deh phung Israel, i nây jêng nau bơ̆ khân păng ntĭnh ma khân păng, păng dăn Kôranh Brah ăn nau geh jêng ma khân păng 12 nuyh nây, du huê du huê păng ăn êng êng, tâm di ma ăp nơm khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Jêh ri Yakôp ntĭnh ma phung oh kon păng: “Hôm du ƀlât gâp tay khât, gâp hăn tâm mâp ma phung che gâp nơm. Ăn khân may leo tŏp gâp kêng môch phung che gâp ta trôm yôk ta mir Êprŭn phung Hêt, ");
INSERT INTO cmo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","jêng ta mir Măkpêla, tâm dăch ma ƀon Mămrê ta bri Kanan, mir nây lĕ che Abrahăm de rvăt tă bơh Êprŭn phung Hêt, gay ma ntŭk môch. ");
INSERT INTO cmo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ta ntŭk nây bu tŏp che Abrahăm, ndrel ma u Sara ur păng, bu tŏp Isăk, ndrel ma Rêbêka ur păng, Lêa gâp tŏp păng ta ntŭk i nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mir ndrel ma ntu yôk i nây lĕ che Abrahăm de rvăt bơh phung Hêt”. ");
INSERT INTO cmo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jêh Yakôp ntĭnh ma phung oh kon păng lĕ phiao, jêh ri păng yơk jŏng lŏng săk ta gre păng nơm ri, n'ho ma roh n'hâm hăn tâm mâp ma phung che păng nơm ri. ");
INSERT INTO cmo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yôsep ut chŭm bơ̆ păng, nhŭm ta muh măt bơ̆ păng ri. ");
INSERT INTO cmo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yôsep đă phung kôranh dak si jan ueh săk bơ̆ păng ri. Jêh ri phung kôranh dak si khân păng leo băl jan ueh săk Israel i ri ma ndơ ƀô kah, gay ma mâu ôh ôm ntô mlay. ");
INSERT INTO cmo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Khân păng jan kơt nây geh 40 nar, dah nây nau jŏ khân păng jan ueh săk gay ma tŏp. Phung Êsip gŭ nklŏn rngot Yakôp i bu kuăl Israel đŏng, dâng lĕ geh 70 nar. ");
INSERT INTO cmo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Tât lĕ lôch jêh nau khân păng gŭ nklŏn rngot nây, Yôsep lah ma phung kôranh kađăch Pharaon kơt nđa: “Lah khân may yô̆ ma gâp, dăn khân may mbơh nkoch nau gâp ăn ma Pharaon kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Bơ̆ gâp đă gâp ton ma păng: «Gâp rêh mâu hôm ôh jŏ đŏng, tât gâp khât tay ăn may tŏp gâp ta môch gâp lĕ jêh ndrăp ta bri Kanan ri». Lah ndri aƀaơ dja gâp dăn hăn tŏp bơ̆ gâp, jêh ri dâng gâp plơ̆ tay ta dja”. ");
INSERT INTO cmo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kađăch Pharaon lah ma păng: “May hăn tŏp bơ̆ may ri hŏm, kơt nau may lĕ jêh ton đah păng ri nơh”. ");
INSERT INTO cmo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Jêh ri Yôsep hăn tŏp bơ̆ păng a ri, dâng lĕ phung kôranh kađăch Pharaon, dâng lĕ mpôl bu ranh ta jay kađăch, ndrel ma dâng lĕ phung kôranh ta bri Êsip ri, khân păng hăn n'hoch ndrel ma Yôsep dadê. ");
INSERT INTO cmo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Dâng lĕ rnăk vâl Yôsep, oh nô păng, ndrel ma dâng lĕ ndŭl mpôl bơ̆ păng, hăn dadê đŏng, hôm e kon se jê̆ jê̆, ndrel ma ndrôk, be biăp du ri dơm hôm gŭ ta bri Kôsen ri. ");
INSERT INTO cmo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Geh ŏk hăn ndrel ta nây, geh nđâp ma rdeh seh, geh nđâp ma tahen ncho seh, ŏk n'hoch ngăn. ");
INSERT INTO cmo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tât ta ntŭk Athat ri jêng ntŭk bu rpăt plên ba, kăl a dak rlai Yôrđăn, khân păng gŭ nhŭm klŏng rngot ta ntŭk nây kuŏng ngăn. Yôsep leo khân păng nklŏn rngot ma bơ̆ păng ta ntŭk nây pơh nar. ");
INSERT INTO cmo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Dôl phung Êsip geh nau nklŏn rngot ta Athat nây, phung bri Kanan i gŭ ta nây tâm lah: “Yi! Hô ngăn nklŏn rngot phung Êsip nây hay”. Kơt ndri dâng bu kuăl ntŭk kăl a dak rlai Yôrđăn i nây lah: “Aƀel-Misrem” geh nau khlay lah «Nau nhŭm rngot Êsip». ");
INSERT INTO cmo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Phung oh kon Yakôp jan kơt nau păng ntĭnh ma khân păng, ");
INSERT INTO cmo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","khân păng tŏp Yakôp ta bri Kanan, ta mir trôm yôk Măkpêla mpeh bơh lôh nar ƀon Mămrê, jêng ntŭk mir lĕ Abrahăm de rvăt tă bơh Êprŭn phung Hêt nây nơh, gay ma ntŭk môch. ");
INSERT INTO cmo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Jêh tŏp bơ̆ păng ri phiao, Yôsep, ndrel ma phung oh nô păng, nđâp ma phung hăn tŏp bơ̆ păng i ri nơh, khân păng plơ̆ sât ta bri Êsip dadê. ");
INSERT INTO cmo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","I nô nô Yôsep tât bơ̆ khân păng lĕ khât, khân păng ntơm geh nau mân rvê tâm lah ndrăng khân păng: “Klăp lah Yôsep biănh ma bân ro, păng plơng nau bân jan djơh ma păng nơh”. ");
INSERT INTO cmo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Jêh ri khân păng ăn du huê hăn ngơi ma Yôsep: “Bơ̆ bân ntĭnh ma may kơt nđa ê lor păng ma khât nơh: ");
INSERT INTO cmo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","«Khân may mbơh nkoch ma Yôsep: «Ơ kon, dăn may yô̆ nđach ma nô nô may, lơi klăp ndăng nau tih khân păng jan djơh ma may». Nau tih hên jan ma may nơh hô ngăn đŏng, lah ndri dăn may lơi klăp ndăng ma hên jêng phung jan kar ma Kôranh Brah i brah bơ̆ bân yơk mbah”. Yôsep tăng nau nây, păng nhhiăng nhŭm ro. ");
INSERT INTO cmo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Jêh ri dâng lĕ nô nô Yôsep, hăn tâm mâp ma păng, păn ta năp păng, lah ma păng: “Dâng lĕ hên jan dâk may dadê”. ");
INSERT INTO cmo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yôsep lah ma khân păng: “Lơi klach, yorlah gâp mâu ôh Kôranh Brah dâng phat dôih khân may. ");
INSERT INTO cmo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Khân may tâm di du ntôr nau jan djơh ma gâp nơh, yơn ma Kôranh Brah jan nau nây jêng ueh, Kôranh Brah rklaih bunuyh dŭt ŏk, kơt ma bân lĕ say aƀaơ dja. ");
INSERT INTO cmo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ơ nô, khân may lơi ôh klach, tay gâp hôm mât siăm khân may, ndrel ma oh kon khân may”. Ndri nau Yôsep bonh leng nô nô păng, ngơi ueh ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yôsep ndrel ma dâng lĕ rnăk vâl bơ̆ păng hôm gŭ ta bri Êsip. Yôsep rêh geh 110 năm. ");
INSERT INTO cmo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yôsep say kon sau Êpraim tât ma se, ndrel ma păng lĕ say đŏng i kon Makir, Makir nây jêng i kon Manasê, dâng lĕ se i nây păng kơp jêng kon păng nơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Nôk Yôsep bơi ma khât, păng ngơi ma phung oh nô păng: “Gâp bơi ma khât jêh, yơn ma Kôranh Brah gŭ ndrel khân may, Păng mra leo khân may du lôh bơh bri dja sât ta bri ntŭk Păng lĕ ton ma Abrahăm, ma Isăk, ndrel ma Yakôp nơh”. ");
INSERT INTO cmo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Jêh ri Yôsep ăn phung kon sau Israel ton ma păng: “Tât Kôranh Brah hăn kơl khân may tay, ăn khân may sơm ndjôt nting gâp bơh ntŭk dja leo ndrel ma khân may”. ");
INSERT INTO cmo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yôsep rêh geh 110 năm, jêh ri păng khât, bu jan ueh săk păng, tê̆ păng ta băng, jêh ri bu tŏp păng ta bri Êsip ri.");
INSERT INTO cmo_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Rnôk kăl e ta bri Israel ê lor ma geh kađăch, geh kôranh phat dôih dơm kơl mât uănh ƀon lan ta bri i nây. Nôk nây geh bar hê ur sai gŭ ta ƀon Ƀêtlêhem ta bri Yuđa. Ta bri nây geh nau tât ji sŏt ji ngot kuŏng bêng bri ngăn. Yor ma geh nau ji sŏt kuŏng i nây khân păng leo bar hê kon bu klô khân păng du bơh bri Yuđa hăn gŭ jât bri Môăp. ");
INSERT INTO cmo_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","I sai nây rnha Êlimalêk, i ur păng rnha Naômi, i kon păng rnha Malôn, ndrel ma Kiliiôn, khân păng tă bơh băl mpôl Êprata ta ƀon Ƀêtlêhem ta bri Yuđa, jêh ri khân păng gŭ ta bri Môăp. ");
INSERT INTO cmo_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Tât a kơi ri, Êlimalêk khât, ntlơi ur ndrel ma kon păng bar hê i nây. ");
INSERT INTO cmo_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Jêh ri kon păng bar hê i nây sŏ ur bơh phung Môăp, du huê rnha Ôrpa, du huê jât rnha Rut, khân păng gŭ ta bri i nây klăp lah geh jât năm. ");
INSERT INTO cmo_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Jêh ri Malôn ndrel ma Kiliiôn nây khât đŏng, ntlơi i mê̆ gŭ du huê êng, khât lĕ kon lĕ sai ro. ");
INSERT INTO cmo_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Geh du nar ri Naômi lư tăng bu nkoch lah Brah Yêhôvalĕ kơl ƀon lan phung Israel i ƀon lan Păng nơm ăn geh jêng geh ndơ sông sa tŏng ta bri Yuđa. Jêh ri păng ndrel bar hê i măn nây ndrăp ndoh ndơ plơ̆ sât jât ƀon păng nơm ri. ");
INSERT INTO cmo_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Pe nuyh khân păng du bơh ntŭk nây hăn rŏ trong ngai sât tay ta bri Yuđa. ");
INSERT INTO cmo_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Jêh ri Naômi lah ma i măn păng bar hê nây: “Khân ƀe hăn sât tâng mê̆ bơ̆ khân ƀe nơm a ri dôh! Khân ƀe nơh lĕ jan nau ueh ma kon gâp lĕ khât, ndrel ma gâp nơm đŏng. Gâp dăn Brah Yêhôva jan nau ueh ma khân ƀe kơt nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Gâp dăn Brah Yêhôva ăn khân ƀe bar hê dja geh sai tay, rêh jêng ueh đăp mpăn ta rnăk vâl”. Jêh ri i po chŭm ntĭnh i măn păng bar hê nây tâng ma nau vay khân păng. Khân păng bar hê nây nhŭm lŭng ngăn ");
INSERT INTO cmo_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","ngơi ma i po păng lah: “Hên mâu ŭch ôh tâm nkhah! Hên ŭch tâng gŭ ndrel ƀe, ndrel ma ƀon lan ƀe đŏng”. ");
INSERT INTO cmo_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Tih ma Naômi mâu rom: “Hơi kon! Khân ƀe plơ̆ sât a ri hŏm, moh nau khân ƀe ŭch brô̆ ndrel gâp? Gâp lĕ ŏk năm hơi, mâu hôm ôh bă kon ma ntrŏ sai khân ƀe tâng nau vay bân. ");
INSERT INTO cmo_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Plơ̆ sât a ri hŏm! Yorlah gâp lĕ ranh hơyh lĭch hôm geh sai tay ôh. Bol lah gâp hôm rnơm geh kon, lah geh sai gŭ đah gâp ta măng dja, jêh ri geh bar hê kon bu klô, ");
INSERT INTO cmo_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","lah ndri ơm khân ƀe ŭch kŏp khân păng truyh kuŏng lah? Ơm khân ƀe ŭch gŭ dơm lĭch ŭch sŏ sai lah? Mâu ôh! Jan kơt ri lĭch di ôh! Brah Yêhôva lĕ tâm rdâng đah gâp jan ăn nau rêh gâp ot nuih ot n'hâm rlao ma khân ƀe nây jât”. ");
INSERT INTO cmo_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Jêh ri bar hê i măn păng nây nhŭm lŭng du tơ̆ jât, i măn rnha Ôrpa nây chŭm ntĭnh po păng du tơ̆ jât, yor ma păng lĕ ŭch plơ̆ sât ta rnăk vâl păng nơm, yơn ma i măn rnha Rut nây kuăn rdâng po păng hô ngăn, mâu ŭch ôh nkhah đah păng. ");
INSERT INTO cmo_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naômi ngơi ma Rut: “Hơi măn, măn ƀe lĕ plơ̆ sât joi ndŭl mpôl păng nơm, plơ̆ sât yơk mbah brah păng nơm đŏng. Ăn ƀe tâng măn ƀe a ri hŏm!” ");
INSERT INTO cmo_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Jêh ri Rut ơh: “Dăn ƀe lơi ôh ntrŭt gâp du bơh ƀe Lơi ôh buay gâp tâng ƀe! Ah ntŭk ƀe hăn, gâp hăn ta ri đŏng Ah ntŭk ƀe gŭ, gâp gŭ ta ri đŏng Phung ƀon lan ƀe jêng phung ƀon lan gâp Brah i ƀe yơk mbah jêng brah i gâp yơk mbah đŏng. ");
INSERT INTO cmo_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ah ntŭk ƀe khât, gâp khât ta ri đŏng Jêh ri bu tŏp gâp ta ntŭk nây đŏng. Nau khât dơm dơi tâm nkhah gâp bơh ƀe Lah mâu ngăn Dăn Brah Yêhôva tê̆ dôih kuŏng ma gâp dôh!” ");
INSERT INTO cmo_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Tât tăng i măn păng ŭch gŭ ndrel dŭt hô kơt ndri, Naômi rom, jêh ri gŭ iăt săk rklăk. ");
INSERT INTO cmo_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Jêh ri khân păng brô̆ tât ta ƀon Ƀêtlêhem. Nôk khân păng bar hê tât ta ƀon nây lĕ rngôch ƀon lan ndrŏt dadê, jêh ri geh phung bu ur tâm ôp lah: “Yôh i nây, Naômi ngăn lah hiah?” ");
INSERT INTO cmo_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Yơn ma păng ơh lah: “Lơi hôm kuăl gâp «Naômi» jât ôh Kuăl gâp «Mara» hŏ Yorlah Naômi geh nau khlay «Nau răm maak», tih ma Mara geh nau khlay «Ndơ tăng kher ngăn». Yorlah Kôranh Brah i geh nau dơi dŭt prêh dŭt kuŏng jan ăn nau rêh gâp ot nuih ot n'hâm. ");
INSERT INTO cmo_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Gâp du tă bơh dja nơh geh ndơ ăp ntil Tih ma Brah Yêhôva ăn gâp plơ̆ sât ta dja jŏng lang mpang ti dơm Moh nau hôm kuăl gâp «Naômi»? Brah Yêhôva tâm rdâng đah gâp Jêng Kôranh Brah i geh nau dơi dŭt prêh dŭt kuŏng ăn geh nau jêr jŏt ma gâp!” ");
INSERT INTO cmo_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ndri nau Naômi plơ̆ sât ta ƀon păng nơm, leo nđâp ma i măn păng tă bơh bri Môăp sât n'hanh đŏng. Khân păng bar hê tât ta ƀon Ƀêtlêhem ta khay ntơm rek Ba Prăng. ");
INSERT INTO cmo_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ta ƀon Ƀêtlêhem geh du huê bu klô băl mpôl tâm dăch đah sai Naômi rnha Bôas, păng bu têh bu kuŏng geh drăp ndơ ŏk ngăn. ");
INSERT INTO cmo_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Geh du nar ri Rut i phung Môăp nây nơh ngơi ma po păng: “Hơi u, ăn gâp brô̆ dônh Ba Prăng ta mir bu yơ̆, ƀar na bu yô̆ ăn gâp dônh bơh kơi bu”. Naômi ơh: “Brô̆ heh măn!” ");
INSERT INTO cmo_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Jêh ri Rut brô̆ dônh ba i tŭp bơh kơi mpôl i rek ba ri ăn ma păng nơm, geh dônh plăng mir Bôas i băl mpôl Êlimalêk ri nơh. ");
INSERT INTO cmo_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Jêh ri Bôas brô̆ tă bơh ƀon Ƀêtlêhem, tât ta nây păng ôp ueh lăng ma mpôl rek ba nây: “Dăn Brah Yêhôva gŭ ndrel khân ay may!” Khân păng ơh: “Dăn Brah Yêhôva ăn nau geh jêng ma kôranh đŏng!” ");
INSERT INTO cmo_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Jêh ri Bôas ôp bu klô i mât uănh mpôl rek ba nây: “Bu moh mpôl bu ur drôh i to mêh?” ");
INSERT INTO cmo_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Păng ơh: “Bu ur phung Môăp i sât ndrel Naômi bơh bri Môăp nơh. ");
INSERT INTO cmo_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Păng dăn tâng bơh kơi bu gay ma rƀŭn ba i tŭp ta neh, păng brô̆ dônh ơm ôi nsrôyh n'ho ma tât aƀaơ dja, păng rlu ta nkưp du ndŏm dơm”. ");
INSERT INTO cmo_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Jêh ri Bôas hăn mâp Rut a to lah ma păng: “Hơi oh, dăn iăt gâp yơ̆! Lơi dônh ba ta mir bu êng yơ̆, mâu khăch ôh hăn ta mir bu êng, hăn gŭ ndrel bu ur oh mon gâp ta dja hŏ! ");
INSERT INTO cmo_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Uănh ah ntŭk bu rek, jêh ri tâng khân păng bơh kơi bơh kơi, ndrel ma phung bu ur, gâp buay oh mon phung bu klô, mâu ôh ăn jan djơh ma ay. Lah ay ji hir dak, nhêt dak nông i oh mon gâp mbŭk nây hŏ!” ");
INSERT INTO cmo_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Jêh Rut tăng nau nây păng păn ta neh, jêh ri ơh ma Bôas: “Moh nau kôranh yô̆ ma gâp bunuyh phung bu năch êng dja?” ");
INSERT INTO cmo_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bôas lah: “Bu nkoch ma gâp lĕ rngôch nau ay jan ma po ay, jêh sai ay khât nơh, ay dơi ntlơi mê̆ bơ̆, ndrel ma bri ƀon ay nơm, du gŭ ndrel mpôl i ay mâu vay năl bơh ntơm nơh. ");
INSERT INTO cmo_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ăn Brah Yêhôva plơng jan ueh ma ay, yor ma ndơ ueh i ay lĕ jan nơh. Ăn Brah Yêhôva i brah phung Israel yơk mbah nkhôm ndơ ŏk ma ay, yorlah ay ran gŭ nde ta Păng tâm ban ma kon iăr ran gŭ ta nâm nar me păng”. ");
INSERT INTO cmo_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rut lah: “Ơ kôranh, may geh nuih n'hâm ueh ma gâp hô ngăn, may lĕ rthi gâp, bol lah gâp bunuyh gŭ ta nâm oh mon bu ur may kađôi, may hôm ngơi ueh ma gâp ngăn”. ");
INSERT INTO cmo_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Nôk sông sa, Bôas lah ma Rut: “Hô̆ sa nŭmpăng lŭp đah dak lŭp dja!” Jêh ri Rut gŭ ndrel mpôl oh mon nây, Bôas ndơ̆ mbo ge lĕ jêh vŏr ăn păng, păng sa tât hơm, hôm rmeh đŏng, jêh ri păng prăp. ");
INSERT INTO cmo_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Jêh sông sa ri păng dâk brô̆ dônh tay ba, Bôas lah ma mpôl oh mon păng: “Ăn păng dônh ba ta ntŭk i bun nây đŏng, lơi ôh buay păng! ");
INSERT INTO cmo_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ntŭp ba bơh nchăp ƀă, ăn păng dônh, lơi ôh lah păng!” ");
INSERT INTO cmo_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Jêh ri păng dônh ba n'ho ma tât kêng măng, plên ba i nây bơi ma bêng sah. ");
INSERT INTO cmo_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Păng anh ba i nây sât a ƀon nhhơ ăn i po păng say, n'ho ma ndjôt ndơ sông sa i rmeh nơh ndơ̆ ăn ma i po păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Po păng ôp: “Nar dja bu moh mir ƀe dônh hă? Ăn Brah Yêhôva ăn nau geh jêng ma păng i geh nuih n'hâm lŏng ma ƀe!” Jêh ri Rut nkoch ma po păng: “Nar dja gâp dônh ba ta mir bu klô rnha Bôas, u ê̆”. ");
INSERT INTO cmo_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naômi ơh ma i măn păng: “Gâp dăn Brah Yêhôva ăn nau geh jêng ma păng! Brah Yêhôva geh nuih n'hâm ueh răp jăp, hôm kah gĭt nau Păng rŏng nâp ma bunuyh hôm rêh, bol lah bunuyh lĕ khât đŏng!” Naômi ngơi tay: “Bu klô i nây jêng băl mpôl bân, jêng du huê bunuyh ndơn mât uănh bân”. ");
INSERT INTO cmo_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Rut i phung Môăp nây ơh: “N'ho păng đă gâp gŭ dônh ba ndrel oh mon păng tât jêh rek ba ro”. ");
INSERT INTO cmo_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Jêh ri Naômi ngơi tay ma i măn păng: “Ƀe gŭ dônh ba ndrel oh mon bu ur Bôas nây ueh ngăn! Lah ƀe brô̆ mir bu êng klach lah bu jan djơh ma ƀe”. ");
INSERT INTO cmo_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ăp nar ăp nar Rut gŭ dônh ba ndrel oh mon Bôas nây, a măng măng păng sât gŭ chuanh i po păng đŏng, n'ho ma tât lĕ rek ba i nây. ");
INSERT INTO cmo_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Tât du nar ri, Naômi ngơi ma Rut: “Gâp sơm nđăp sai ăn ƀe geh nau rêh ueh đăp mpăn let jât năp. ");
INSERT INTO cmo_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Bôas i ƀe vay jan kar ndrel mpôl oh mon păng nơh, mpôl băl bân đŏng. Kêng măng dja păng hăn rpăt ba ta ntŭk rpăt ba ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ƀe ŭm ƀe nkrơ̆ săk ăn ueh pot dak si ƀô kah nsoh bok ao i ueh ueh, jêh ri hăn ntŭk rpăt ba ri, lơi ôh nhhơ săk ăn păng năl, n'ho ma tât jêh păng nhêt sông. ");
INSERT INTO cmo_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ƀe uănh n'hêl nanê̆ ntŭk păng bêch, jêh ri ƀe hăn pơk phôi mpeh bơh jŏng păng nây, ƀe bêch ta ri yơ̆, gay ma dăn păng kơl ƀe, jêh ri ƀe jan lĕ ntil nau păng mbơh đă ƀe”. ");
INSERT INTO cmo_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut ơh: “Ơ, gâp jan tâng dâng lĕ nau ƀe đă”. ");
INSERT INTO cmo_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Jêh ri Rut hăn ntŭk rpăt ba jan tâng nau i po păng đă nơh. ");
INSERT INTO cmo_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Jêh Bôas nhêt sông phiao, păng maak răm n'ho ma bêch ntŭk bun ba nây, jêh ri Rut hăn rmiăt pơk phôi n'ho ma bêch bơh dŏng jŏng păng ri. ");
INSERT INTO cmo_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Tât n'gul măng nây, Bôas kah rngăl bêch ƀli, păng rplăch săk ndrŏt hih rhŏl say du huê bu ur bêch bơh dŏng jŏng păng nây. ");
INSERT INTO cmo_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Jêh ri Bôas ôp: “Bu moh dja?” Rut ơh: “Gâp Rut jêng bunuyh jan kar ma may, kôranh mê, dăn kôranh yô̆ nđach ma gâp, ăn gâp jêng ur may, yorlah may jêng mpôl băl gâp, dơn mât uănh gâp”. ");
INSERT INTO cmo_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Bôas lah: “Ăn Brah Yêhôvaăn nau geh jêng ma oh! A lor nơh ay lĕ nhhơ nau rŏng răp jăp ay gŭ ndrel po ay, yơn ma aƀaơ ri ay nhhơ nuih n'hâm sŏng rlao i nây jât, ay mâu ôh sŏ sai ndăm o ach, mâu lah sai ndăm i ndrŏng, tih ma sŏ gâp chrao. ");
INSERT INTO cmo_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Lơi ta rvê ôh, moh ndơ ay dăn, gâp dơi jan dâng lĕ, yorlah ƀon lan dâng lĕ gĭt n'hêl ay jêng bunuyh sŏng ngăn. ");
INSERT INTO cmo_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Di ngăn gâp băl mpôl ndơn mât uănh ay, yơn ma hôm geh du huê bu klô jât, băl mpôl dăch rlao ma gâp ngăn. ");
INSERT INTO cmo_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Măng dja ay bêch ta dja hŏ! Ôi tay gâp hăn mâp păng, lah păng ŭch ndơn mât uănh ay ăn păng mât, lah păng mâu ŭch ôh, gâp ton ma ay, jă Brah Yêhôva i rêh mâu blao khât kơl uănh say lĕ nau gâp ton, gâp ndơn mât uănh ay ngăn! Lah ndri ay bêch ta dja ƀŏt, n'ho ma tât ang ôi”. ");
INSERT INTO cmo_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Jêh ri Rut bêch bơh dŏng jŏng Bôas nây, n'ho ma tât kêng ang, păng dâk ơm ôi bri hôm ngo gay ma lơi ăn bu gĭt năl, yor ma Bôas lah: “Mâu ŭch ôh ăn bu gĭt lah geh bu ur lăp bêch ntŭk dja”. ");
INSERT INTO cmo_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Jêh ri Bôas lah: “Hơi oh, droh bok ay i kuŏng nây, kuăn ăn nâp”. Jêh ri Bôas troch ba bêng bok i nây ăn ma păng n'ho kơl pư ăn păng mbăk, jêh ri păng mbăk ba i nây sât a ƀon. ");
INSERT INTO cmo_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Tât a chuanh ri po păng ôp: “A mơm păng jan ma ƀe hă?” Jêh ri Rut nkoch ma i po păng nơm dâng lĕ nau Bôas jan nơh. ");
INSERT INTO cmo_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Rut lah: “Lĕ ba dja păng ăn ma gâp n'ho ma lah: «Ay mâu ôh di sât dơm a po ay!»” ");
INSERT INTO cmo_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Jêh ri Naômi lah: “Hơi măn, gŭ kŏp uănh ƀŏt, n'ho ma tât gĭt lah nau dja a mơm păng, yorlah Bôas mâu ôh nđom jŏ jong, păng jan jêh ta nar dja ro”. ");
INSERT INTO cmo_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Jêh ri Bôas brô̆ ntŭk mpông mpêr ƀon nây, jêng ntŭk bu vay tâm rgum băl, tât ta nây păng gŭ kŏp, jêh ri păng say i bu klô băl mpôl dăch rlao i păng mbơh ma Rut nơh brô̆ rŏ nây, Bôas kŏn bu klô i nây lah: “Hơi nô, dăn may gŭ ta dja ƀŏt”. Bu klô i nây gŭ ro. ");
INSERT INTO cmo_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Jêh ri Bôas jă jât nuyh kôranh ƀon gŭ ndrel ta nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Bôas lah ma bu klô i nây: “Hơi nô, may gĭt hơyh yôh Naômi plơ̆ sât tă bơh bri Môăp, păng ŭch tăch neh mir nô Êlimalêk nơm nơh. ");
INSERT INTO cmo_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Gâp ŭch ôp n'hêl may, lah may ŭch rvăt neh mir păng nây, yor ma may i băl mpôl ndơn mât uănh ndơn rvăt chuai lor bu, ŭch ăn kôranh i gŭ ta dja ndrel bunuyh êng jât i gŭ ta dja kơl say kơl tăng moh nau may ngơi. Lah may ŭch rvăt, rvăt dôh! Lah mâu ŭch rvăt, mbơh ma gâp đŏng, yorlah gâp ndơn mât uănh ndơn rvăt chuai bơh kơi may”. Bu klô i nây ơh: “Ơ gâp ŭch!” ");
INSERT INTO cmo_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Bôas lah tay: “Rut i bu ur phung Môăp ri păng ndrô khât sai sŏ kon Êlimalêk. Lah may rvăt neh mir yôh Naômi i nây nkre may sŏ Rut jan ur sai đah may đŏng, gay ma geh kon ndơn tay neh mir i nây, lah ndri hôm geh tay rnoi deh ma neh mir nô bân i lĕ khât nây nơh đŏng”. ");
INSERT INTO cmo_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Bu klô i nây ơh ma păng: “Lah ndri gâp mâu ôh dơi rvăt, yorlah gâp klach roh neh gâp nơm. Ăn may rvăt dôh, gâp mâu ôh dơi rvăt!” ");
INSERT INTO cmo_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Rnôk nây nơh ta bri Israel, nôk bu tăch rgâl drăp ndơ, du huê bunuyh droh ntô jot ndơ̆ ăn ma du huê jât, gay ma nhhơ khân păng lĕ tâm di nau. ");
INSERT INTO cmo_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Jêh ri bu klô nây lah: “Ăn may rvăt dôh!” Jêh ri păng droh ntô jot ndơ̆ ăn ma Bôas đŏng. ");
INSERT INTO cmo_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Jêh ri Bôas lah ma kôranh ƀon, ndrel ma phung ƀon lan dâng lĕ ta nây: “Nar dja dăn dâng lĕ oh nô kônh va jêng nơm lĕ say lĕ tăng nau i dja, gâp rvăt bơh yôh Naômi dâng lĕ drăp ndơ nô Êlimalêk, drăp ndơ i kon păng bar hê Kiliiôn ndrel ma Malôn. ");
INSERT INTO cmo_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Gâp nkre sŏ Rut i bu ur phung Môăp i ur Malôn nơh, nđăp ur sai đah gâp đŏng, gay ma geh kon ndơn tay neh mir i nây, lah ndri hôm geh tay rnoi deh ma neh mir nô bân i lĕ khât nây nơh, gay ma lơi roh rnha păng ta ndŭl mpôl păng, lơi roh rnha păng ta bri ƀon dja. Nar dja dâng lĕ oh nô kônh va lĕ say lĕ tăng jêh nau i dja”. ");
INSERT INTO cmo_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Lĕ rngôch phung kôranh, ndrel ma dâng lĕ ƀon lan i gŭ ta nây ơh: “Lĕ rngôch phung hên lĕ say lĕ tăng dadê jêh! Ăn Brah Yêhôva kơl Rut geh kon ŏk tâm ban ma bu ur Rachel, ndrel ma bu ur Lêa kăl e nơh i me bă ƀon lan phung Israel đŏng! Ăn may jêng bunuyh têh bunuyh ndrŏng gŭ ta băl mpôl Êprata, ndrel ma lư săk may ta ƀon Ƀêtlêhem đŏng. ");
INSERT INTO cmo_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Ăn Brah Yêhôva kơl may, ndrel ma ur may bă kon bă sau ăn ŏk, gay ma ăn rnăk vâl may tâm ban ma rnăk vâl Pêrês i kon bu klô Yuđa, bơh bu ur Tamar nơh đŏng!” ");
INSERT INTO cmo_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Jêh Bôas sŏ Rut jêng ur păng, Brah Yêhôva ăn nau geh jêng ma Rut. Tât nar bơh kơi nây păng ntreo bă du huê kon bu klô. ");
INSERT INTO cmo_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Phung bu ur gŭ ta ƀon Ƀêtlêhem nây lah ma Naômi: “Rnê ma Brah Yêhôva yor nar dja Păng ăn ay geh du huê sau bu klô ma mât uănh ay, ăn păng lư lam bri Israel dja. ");
INSERT INTO cmo_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Măn ay rŏng ma ay hô ngăn, păng lĕ jan ŏk ndơ ueh ma ay, ŏk rlao ma pơh nuyh kon bu klô, jêh ri aƀaơ dja păng bă du huê sau bu klô ma ay, sau i nây dơi mât uănh ay geh nau rêh jêng đăp mpăn tay, n'ho ma tât khât”. ");
INSERT INTO cmo_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Jêh ri Naômi pư i sau nây tŭ, n'ho ma mât siăm păng. ");
INSERT INTO cmo_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Phung bu ur i gŭ chiao meng nây leo băl lah: “Kon bu klô dja aƀaơ ri kơp kon Naômi!” Jêh ri khân păng rnha oh bê i nây: «Ôƀêt», Ôƀêt dja i bơ̆ Yêsê, Yêsê i bơ̆ kađăch Đavid. ");
INSERT INTO cmo_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Dja jêng rnoi mpôl Pêrês tât ma kađăch Đavid, Pêrês i bơ̆ Hesrŭn, ");
INSERT INTO cmo_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesrŭn i bơ̆ Ram, Ram i bơ̆ Aminađăp, ");
INSERT INTO cmo_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminađăp i bơ̆ Nahsôn, Nahsôn i bơ̆ Salmôn, ");
INSERT INTO cmo_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmôn i bơ̆ Bôas, Bôas i bơ̆ Ôƀêt, ");
INSERT INTO cmo_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Ôƀêt i bơ̆ Yêsê, Yêsê i bơ̆ kađăch Đavid.");
INSERT INTO cmo_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Bơh kăl e nơh geh du huê bu klô rnha Yônais i kon Amithai. Tât du nar ri Brah Yêhôva đă ma Yônais : ");
INSERT INTO cmo_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Hơi Yônais, may dâk hăn hŏm ta ƀon Ninivê i ƀon dŭt kuŏng mpeh ma lôh nar nây, mbơh ma nau tê̆ dôih bunuyh ta ƀon i nây, yorlah nau tih djơh khân păng jan nây, lư n'găr tăng tât a Gâp dja ngăn”. ");
INSERT INTO cmo_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Yônais mâu iăt ôh nau Brah Yêhôva păng du nchuăt bơh măt Brah Yêhôva, păng dâk bơh nây ro, hăn jât ƀon Yôppê ri, ntŭk ƀon geh duk kuŏng kuŏng, gay ma hăn jât ƀon Tasơs i ƀon mpeh ma nhŏp nar kăl ti dak văch dak văr chrao. Păng say geh du mlŏm duk kuŏng, ŭch ndrăp hăn jât ƀon Tasơs, păng ăn prăk ma ncho duk, jêh ri păng jŭr ncho duk i nây ro, hăn jât ƀon Tasơs ndrel bu aƀă êng, păng ŭch du krap ngai bơh măt Brah Yêhôva ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Duk i nây lôh bơh Yôppê, tât ta nklang dak nây, jêh ri Brah Yêhôva ăn geh sial phŭt dŭt hô ro, gay ma khôm mprat rŏ dak văch dak văr. Kơt ndri rŏ dak i nây geh sial dŭt hô ngăn, ăn khân păng klach lah duk khân păng nơh djơh lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Mpôl jan kar ta kalơ duk nây khân păng klach nter dadê, khân păng nter kuăl du huê du huê đă brah khân păng nơm kơl. Jêh ri khân păng pư lĕ drăp ndơ ta kalơ duk i nây, mƀăr lơi ta dak văch dak văr ri gay ma ăn duk i nây n'gơch. I Yônais nơm ri lĕ ơm jŭr gŭ bêch hăk khŭr bơh dŏng su ta blat duk ri păng heh. ");
INSERT INTO cmo_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Jêh ri păng i tơm duk ri hăn joi Yônais gay ma lah, păng lah: “Mơm gŭ bêch may dja hiah? Dâk hŏm heh! Kuăl hŏm brah may nơm! Nkhêp lah brah i nây kah gĭt ma bân, lơi ăn bân khât”. ");
INSERT INTO cmo_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Mpôl bunuyh i gŭ ncho ta kalơ duk nây tâm nchră băl lah: “Lŏng bân nhŭp ndơ nchroh, gay ma gĭt bu moh bunuyh i jan nau djơh, dâng bân geh nau jêr kơt dja”. Jêh ri nchroh nau i nây di ta plăng Yônais ro. ");
INSERT INTO cmo_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Jêh ri khân păng ôp Yônais: “Bu moh jan, dâng geh nau jêr kơt dja? Mbơh ma hên hŏm, may moh jan? Bơh tă may? Moh ƀon? May bu moh mpôl?” ");
INSERT INTO cmo_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yônais mbơh ma khân păng: “Gâp mpôl Hêbrơ, gâp klach ma Brah Yêhôva Brah i gŭ ta kalơ trôk, Păng i njêng dak văch dak văr, ndrel ma neh ntu dja đŏng”. ");
INSERT INTO cmo_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Yônais nkoch lĕ nau păng i nây nơh ăn bu gĭt, tât ma gĭt nau Yônais păng nchuăt du bơh Brah Yêhôvakơt nây, khân păng klach dadê lơ hô ngăn, lĕ bunuyh i gŭ ncho ta duk i nây, khân păng lah ma Yônais: “Moh jan may kơt ndri ri?” ");
INSERT INTO cmo_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Dak rbuh lơ ma hô lơ ma hô ngăn, jêh ri khân păng ôp ma Yônais: “Lah ndri, mơm hên jan ma may, gay ma dak dja rngŏn mêh?” ");
INSERT INTO cmo_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yônais ơh: “Khân may nklăch lơi gâp ta dak ri mơ bah, yorlah gâp gĭt sial phŭt dŭt hô dja, tă bơh nau tih gâp”. ");
INSERT INTO cmo_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Khân păng mâu iăt ôh, khân păng nsrôyh vah duk i nây ăn hăn jât meng, mâu dơi ro, yor ma dak rbuh lơ ma hô dăng ngăn. ");
INSERT INTO cmo_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Jêh ri khân păng nter kuăl Brah Yêhôva: “Ơi Brah Yêhôva dăn May yô̆ nđach ăn ma hên, lơi ăn hên khât yor ma hên nkhât nklăch lơi bunuyh dja ta dak. Ơi Brah Yêhôva lơi tê̆ dôih ma hên lah bunuyh dja mâu geh nau tih ôh, lĕ nau dja nơh tă bơhMay nơm ŭch”. ");
INSERT INTO cmo_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Jêh ri khân păng pư Yônais nklăch lơi ta dak văch dak văr i nây, jêh ri dak rngŏn ndal ro. ");
INSERT INTO cmo_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Lĕ rngôch mpôl i nây klach Brah Yêhôva hô ngăn, khân păng leo băl sŏ ndơ jan ma Brah Yêhôva ndrel ma mât ton đŏng. ");
INSERT INTO cmo_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Jêh ri Brah Yêhôva ăn du mlŏm ka kuŏng rnguăn Yônais, jêh ri ka kuŏng i nây rnguăn Yônais ri, păng gŭ ta trôm ndŭl ka pe năng pe nar ");
INSERT INTO cmo_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","jêh ri păng mbơh sơm ma Brah Yêhôva i Brah păng nơm ri bơh trôm ndŭl ka i nây. ");
INSERT INTO cmo_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Păng lah: “Dôl gâp geh nau jêr, gâp joi kuăl Brah Yêhôva Păng plơ̆ ơh ngăn ro Dôl gâp mân gâp mra khât ngăn ro gâp nter dăn May kơl May kơl ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","May mƀăr gâp ta ntŭk dŭt jru ngăn Ta nâm blat dak văch dak văr Chiao ma năp kơi dŏng lơ gâp nơh geh dak dadê May đă đŏng dak nchŏch rbuh Truyh ta gâp. ");
INSERT INTO cmo_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Gâp mân lah May mƀăr gâp ngai Bơh măt May ngăn Gâp mâu mra uănh Nhih jan brah kloh uehMay nơm jât ôh. ");
INSERT INTO cmo_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Gâp ngŏm ta nâm dak ngăn bơi ma khât ro Gâp gŭ ta nklang dak dŭt jru ngăn Mbrâng put jŭm bôk gâp. ");
INSERT INTO cmo_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Hơi Brah Yêhôva i Brah gâp ơi Gâp nơh ngŏm ta nâm dak văch dak văr dŭt jru ta njŏng yôk ri Nkre ma khan ta bri phan nây Yơn ma May lĕ sŏ jêh bơh ntŭk nây ăn gâp rêh tay. ");
INSERT INTO cmo_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Dôl gâp bơi ŭch tăch n'hâm Gâp kah gĭt mbơh sơm ma May Jêh ri tăng tât Ta nhih jan brah May ta ƀon Yêrusalem ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Bunuyh i tâng mbah ma brah êng êng i mâu geh nau khlay Păng mâu ôh dơi geh sŏ nau rŏng răp jăp tă bơh Kôranh Brah i ŭch ăn i nây nơh. ");
INSERT INTO cmo_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Gâp be nơh lah ueh ma Kôranh Brah Ndrel ma sŏ ndơ jan nhhơr ma Brah Yêhôva Tâm di đah nau gâp mât ton Yorlah Brah Yêhôva dơm dơi rklaih”. ");
INSERT INTO cmo_vpl VALUES ("JH2_11","033_2_11","JON","2","11","11","Jêh ri Brah Yêhôva đă ka i nây hok nglôh lơi Yônais, jêh ri ka i nây hok nglôh păng a kơh ti ngăn. ");
INSERT INTO cmo_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Brah Yêhôvađă ma Yônais du tơ̆ jât: ");
INSERT INTO cmo_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Dâk hŏm, hăn ta ƀon Ninivê i ƀon dŭt kuŏng ri, jêh ri mbơh ma bunuyh gŭ ta ƀon ri ăn gĭt, kơt nau Gâp ntĭnh đă ma may nơh!” ");
INSERT INTO cmo_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yônais iăt nau Brah Yêhôva đă, jêh ri păng dâk đơp bơh nây, hăn ta ƀon Ninivê, ƀon i nây dŭt kuŏng ngăn, brô̆ pe nar ri mơ lôch. ");
INSERT INTO cmo_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Yônais tât ta ƀon i nây, păng ntơm hăn lăp rŏ ƀon i nây du nar, păng mbơh lah: “Hôm puăn jât nar jât năp Kôranh Brah mra lơh ăn hêng lơi ƀon dja!” ");
INSERT INTO cmo_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Jêh ri bunuyh ta ƀon Ninivê nây iăt nau Kôranh Brah i mbơh ntĭnh tâng Yônais i nây, khân păng nduih tôr lĕ lăn nau khân păng jan tih, ŭch nhhơ khân păng mƀăr lơi lĕ nau tih a lor nơh, kơt ndri khân păng leo băl mbơh nkoch nau i nây ăt sông sa, nsoh n'gut bok ƀao chiăt, ntơm bơh bunuyh ndrŏng tât ma bunuyh o ach ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Nau dja lư tăng tât a kađăch Ninivê ngăn, păng nduih tôr ŭch nhhơ lĕ nau păng jan tih nơh, ndri dâng păng jŭr bơh lơ rnơl kađăch păng i nây, droh lơi i ao kađăch nây, nsoh n'gut bok ƀao chiăt, jêh ri gŭ ta ntŭk ŭnh buh si so. ");
INSERT INTO cmo_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Jêh ri lôh nau tă bơh kađăch đă bu mbơh lam ta ƀon Ninivê i nây lah: “Dja nau kađăch, ndrel ma phung kôranh kơl jan kar. Dâng lĕ bunuyh mâu ôh ăn sông sa nhêt dak, ndrel ma mpômpa (siŭm) ndrôk be mâu ăn đŏng sa mpa nhêt dak. ");
INSERT INTO cmo_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Ăn dâng lĕ bunuyh, ndrel ma mpômpa (siŭm) nsoh n'gut bok ƀao chiăt dadê, jêh ri nhŭm nter, ăn dâng lĕ bunuyh mbơh sơm kuăl Kôranh Brah ăn hô ngăn, nklơi lơi nuih n'hâm djơh, ndrel ma nau hăt janh tâm lơh tâm nkhât i khân ay may vay jan. ");
INSERT INTO cmo_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Nkhêp lah Kôranh Brah rgâl nuih n'hâm Păng, mâu hôm nuih ma bân, lah ndri bân mâu ôh mra khât hêng”. ");
INSERT INTO cmo_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Kôranh Brah say nuih n'hâm rgâl lơi dadê lĕ nau djơh khân păng jan nơh, jêh ri Kôranh Brah rgâl nuih n'hâm Păng nơm ăn ma phung i nây, bah lơh hêng ma khân păng, mâu ôh lơh kơt nau Păng thăm bơh ntơm nơh. ");
INSERT INTO cmo_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Tât ma Yônais say kơt nây nơh păng mâu djăng ôh, păng ji nuih dŭt hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Păng mbơh sơm ma Brah Yêhôva: “Ơi Brah Yêhôvabơh a lor nơh ngăn gâp gĭt May mâu tê̆ dôih bunuyh ta ƀon Ninivê dja, bơh nôk hôm gŭ ta ƀon gâp nơm nơh ngăn, kơt ndri dâng gâp gơnh nchuăt du ta ƀon Tasơs, yorlah May brah i geh nau yô̆ nđach, geh nuih n'hâm lŏng, geh nuih n'hâm rŏng răp jăp, mâu ôh gơnh nuih. Jêh ri lah bunuyh nduih tôr ma nau tih i păng lăn jan rgâl bah jan mhĭk, May rgâl lơi bơh nau ŭch lơh hêng, jêh ri bah tê̆ dôih bunuyh đŏng. ");
INSERT INTO cmo_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ơi Brah Yêhôva dăn May sơm rhuăt lơi n'hâm gâp, ueh ăn gâp ma khât lơi, đah ma hôm rêh jât năp jât”. ");
INSERT INTO cmo_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Brah Yêhôva plơ̆ lah ma Yônais: “Di lĕ lah mâu, may nuih kơt nây?” ");
INSERT INTO cmo_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Jêh ri Yônais dâk đưp bơh nây hăn mpeh bơh lôh nar ma ƀon Ninivê. Tât ta ntŭk nây păng jan du mlŏm nkưp gŭ ta nâm n'hâm, gay ma kŏp uănh moh ntil nau tât ma ƀon i nây. ");
INSERT INTO cmo_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Brah Yêhôvaăn tơm si du tơm hon bơh lơ bôk Yônais ri, gay ăn n'hâm ma păng jât, lơi ir ăn păng rnhăl. Jêh ri Yônais păng maak ngăn geh n'hâm tơm si i nây. ");
INSERT INTO cmo_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Kah ơm ôi ôi tay bri hôm ngo, Kôranh Brah đă du mlŏm ndrŭng hăn chôh sa tơm si i nây, jêh ri ndro ƀrŭng. ");
INSERT INTO cmo_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Tât lôh nar, Kôranh Brah đă sial dôh khôm tă bơh lôh nar, jêh ri nar dôh djreng kalơ bôk kalơ săk Yônais đŏng, păng lêt rgănh hô ngăn, dăn ma Kôranh Brah đă nkhât păng: “Ueh gâp ma khât lơi, đah ma hôm rêh jât năp jât”. ");
INSERT INTO cmo_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Kôranh Brah lah ma păng: “May di lĕ nuih yor ma tơm si i nây?” Yônais ơh ma Kôranh Brah: “Ơ, dŭt hô ngăn” ");
INSERT INTO cmo_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Brah Yêhôva lah ma Yônais jât: “Lŏng may mân! May yô̆ ma tơm si i may mâu geh tăm mâu geh rơah mât i nây, hon ta du măng dơm, jêh ri khât ndro ta du măng đŏng. ");
INSERT INTO cmo_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Gâp be yô̆ hô ngăn ma ƀon Ninivê ƀon dŭt kuŏng dja, yorlah ƀon i nây geh ŏk bunuyh 120000 nuyh rlao, khân păng mâu hŏ gĭt năl tih di ôh, jêh ri ndrel ma geh dŭt ŏk đŏng mpômpa (siŭm) khân păng mât ta ƀon i nây”.");
INSERT INTO cmo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dja nau nkoch yao u che Brah Yêsu Krist, i kon sau kađăch Đavid kăl e nơh, ndrel ma i kon sau Abrahăm đŏng. Lĕ rngôch phung Israel jêng rnoi deh Abrahăm dadê. ");
INSERT INTO cmo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahăm i bơ̆ Isăk, Isăk i bơ̆ Yakôp, Yakôp i bơ̆ Yuđa, ndrel ma oh nô păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuđa sŏ ur rnha păng Tamar bă kon bu klô rnha Pêrês, ndrel ma oh păng rnha Seras, Pêrês i bơ̆ Hesrŭn, Hesrŭn i bơ̆ Aram, ");
INSERT INTO cmo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram i bơ̆ Aminađăp, Aminađăp i bơ̆ Nahsôn, Nahsôn i bơ̆ Salmôn, ");
INSERT INTO cmo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmôn sŏ ur rnha păng Rahap bă kon bu klô rnha păng Bôas, Bôas sŏ ur rnha păng Rut bă kon bu klô rnha păng Ôƀêt, Ôƀêt i bơ̆ Yêsê, ");
INSERT INTO cmo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yêsê i bơ̆ kađăch Đavid. Kađăch Đavid sŏ pit ur bu, bă kađăch Salômôn, rnha sai i ur kađăch Đavid pit nây Uri. ");
INSERT INTO cmo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Kađăch Salômôn i bơ̆ kađăch Rêhôbam, kađăch Rêhôbam i bơ̆ kađăch Abia, kađăch Abia i bơ̆ kađăch Asa, ");
INSERT INTO cmo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","kađăch Asa i bơ̆ kađăch Yôsaphat, kađăch Yôsaphat i bơ̆ kađăch Yôram, kađăch Yôram i bơ̆ kađăch Ôsia, ");
INSERT INTO cmo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","kađăch Ôsia i bơ̆ kađăch Yôtham, kađăch Yôtham i bơ̆ kađăch Ahas, kađăch Ahas i bơ̆ kađăch Hêsêkia, ");
INSERT INTO cmo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","kađăch Hêsêkia i bơ̆ kađăch Manasê, kađăch Manasê i bơ̆ kađăch Amôn, kađăch Amôn i bơ̆ kađăch Yôsia, ");
INSERT INTO cmo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","kađăch Yôsia i bơ̆ kađăch Yêkônis, ndrel ma oh oh păng đŏng. Dôl nây bu veng gro ƀon lan Israel gŭ jât bri Ƀaƀilôn. ");
INSERT INTO cmo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jêh bu veng gro ƀon lan Israel gŭ ta bri Ƀaƀilôn kađăch Yêkônis bă Salathil, Salathil i bơ̆ Sôrôƀaƀel, ");
INSERT INTO cmo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sôrôƀaƀel i bơ̆ Abiut, Abiut i bơ̆ Êliakim, Êliakim i bơ̆ Asôr, ");
INSERT INTO cmo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asôr i bơ̆ Sadôk, Sadôk i bơ̆ Akim, Akim i bơ̆ Êliut, ");
INSERT INTO cmo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Êliut i bơ̆ Êlêasar, Êlêasar i bơ̆ Mathan, Mathan i bơ̆ Yakôp, ");
INSERT INTO cmo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakôp i bơ̆ Yôsep i sai Mari. Mari i nây bă Brah Yêsu bu kuăl lah Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl. ");
INSERT INTO cmo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kơt ndri, ntơm bơh Abrahăm tât ma kađăch Đavid păng geh 14 bông bunuyh. Ntơm bơh kađăch Đavid tât ma rnôk bu veng gro ƀon lan Israel gŭ ta bri Ƀaƀilôn, geh 14 bông bunuyh. Ntơm bơh rnôk bu veng gro ƀon lan Israel gŭ ta bri Ƀaƀilôn tât ma Brah Yêsu i Brah Krist geh 14 bông bunuyh đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bơh dŏng dja nkoch bri nau deh Brah Yêsu Krist. Geh du huê bu ur rnha păng Mari, păng i ndrôi Yôsep. Ê lor khân păng tâm gŭ ndrel, Mari lĕ ơm ntreo Brah Yêsu yor ma nau dơi Brah Huêng Ueh i kloh ueh ăn ma păng. ");
INSERT INTO cmo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yôsep i ndrôi Mari nây, yor ma păng bunuyh sŏng bunuyh ueh, jêh say ndrôi păng lĕ ntreo, păng ŭch ntlơi ndrôi păng nơm mâu ôh ăn bu gĭt, păng mâu ŭch ăn ndrôi păng đit prêng bu, kơt ndri păng ŭch ntlơi ăn ndŏp ndŏp. ");
INSERT INTO cmo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nchô e ma păng nklŏn kơt nây, geh tông păr tă bơh Kôranh Brah mbơh ăn păng ma nau mbơi: “Hơi Yôsep kon sau kađăch Đavid! Lơi klach ôh sŏ Mari jêng ur may. Kon i ta trôm ndŭl păng nây mâu ôh tă bơh bunuyh, tă bơh nau dơi Brah Huêng Ueh ăn. ");
INSERT INTO cmo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Păng gŭ oh bu klô, jêh ri may tê̆ rnha Kon i nây kuăl ‘Yêsu’ - geh nau khlay lah ‘Kôranh Brah rklaih’ - yorlah Kon i nây mra rklaih phung ƀon lan Păng nơm bơh nau tih khân păng nơm.” ");
INSERT INTO cmo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lĕ nau dja geh gay ma tâm di ngăn đah nau Kôranh Brah ntĭnh tâng du huê bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh: ");
INSERT INTO cmo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Uănh tay yơ̆! Du huê bu ur drôh ê hŏ geh gŭ ndrel bu klô mra ntreo, păng gŭ oh bu klô, Jêh ri bu kuăl Kon i nây ‘Êmanuel’’. ‘Êmanuel’ nau ngơi Hêbrơ rblang lah ‘Kôranh Brah gŭ ndrel bân’. ");
INSERT INTO cmo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tât Yôsep kah bêch, păng iăt tâng nau tông păr đă ma păng, sŏ Mari jêng ur păng. ");
INSERT INTO cmo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tih ma păng ê hŏ ôh geh bêch ndrel bu ur bu klô đah ur păng tât ma ur păng gŭ oh du huê Kon Bu Klô, jêh ri păng tê̆ rnha Kon i nây kuăl ‘Brah Yêsu’. ");
INSERT INTO cmo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Brah Yêsu deh ta ƀon Ƀêtlêhem bri Yuđa nôk kađăch Hêrôt mât uănh bri dak i nây. Jêh Păng deh ri, geh bunuyh gĭt blao gĭt năl uănh mănh mbing hăn tă bơh bri ngai mpeh ma lôh nar tât ta ƀon kuŏng Yêrusalem ri. ");
INSERT INTO cmo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Khân păng ôp bu ta ri: “Ah ntŭk deh kađăch mhe phung Israel hiah? Hên lĕ gĭt Păng deh, yor ma hên say du mlŏm mănh chrat ngăn lôh mpeh bơh bri hên jêng ndơ mbên ma nau i nây. Ndri dâng hên hăn yơk mbah ma Păng đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tât kađăch Hêrôt tăng lư nau ôp i nây, păng rvê hô ngăn gŭ mâu đăp chăp mâu gŏn ro, klach geh bunuyh êng jan kađăch. Lĕ ƀon lan ta Yêrusalem ri, khân păng rvê dadê mơm kađăch Hêrôt jan. ");
INSERT INTO cmo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jêh ri păng rgum mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay phung Israel, gay ma ôp ntŭk ƀon deh Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl. ");
INSERT INTO cmo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jêh ri phung i nây mbơh ma kađăch: “Ntŭk Brah Krist deh ta ƀon Ƀêtlêhem bri Yuđa, yorlah bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh nchih: ");
INSERT INTO cmo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kôranh Brah lah: ‘Hơi ƀon lan ƀon Ƀêtlêhem ta bri Yuđa ơi! Ƀon khân ay may mâu ôh di jê̆ ta nâm bu đah ƀon bri Yuđa dja i geh nau khlay, Yorlah jât năp tay geh du huê kôranh lôh tă bơh ƀon khân ay may, Păng i nây mât uănh ƀon lan Israel i ƀon lan Gâp nơm, tâm ban ma du huê nơm chiăp be biăp’’”. ");
INSERT INTO cmo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jêh ri kađăch Hêrôt kuăl ntŭng mpôl gĭt blao i nây, ôp jek êng khân păng dah hŏ jŏ say mănh i ri, gay ma gĭt kon bê i ri dah hŏ ŏk khay. ");
INSERT INTO cmo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jêh ri đă mpôl i nây hăn jât ƀon Ƀêtlêhem ri, păng lah ma khân păng: “Khân may hăn dôh, ôp n'hêl ma kon se jê̆ i nây. Jêh say Păng tay, plơ̆ mbơh ma gâp yơ̆. Gâp ŭch hăn yơk mbah ma kon se jê̆ i nây đŏng.” Tih ma kađăch Hêrôt mâu ôh ngơi ngăn, păng gay ma ŭch nkhât kon se i nây dơm. ");
INSERT INTO cmo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jêh iăt nau kađăch mbơh nây, khân păng lôh bơh ƀon Yêrusalem ri. Lŏng mănh i khân păng say mpeh bơh lôh nar ri nơh leo trong ma khân păng n'ho ma tât tâm sŏng kalơ ntŭk oh bê gŭ ri mơ nsrŭng. ");
INSERT INTO cmo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Khân păng răm maak lĕ bơh nuih bơh n'hâm ngăn say mănh lĕ gŭ ta nây. ");
INSERT INTO cmo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jêh ri khân păng lăp ta trôm jay ntŭk oh bê gŭ ri, say oh bê ndrel mê̆ Păng. Khân păng păn mbah ma oh bê i nây, jêh ri sŏ ndơ khlay bơh trôm hŭp khân păng nơm ri: Mayh, ntăk si ƀô kah ma su, ndrel ma ntăk si ƀô kah Mâr nhhơr ăn ma Oh Bê i nây. ");
INSERT INTO cmo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jêh ri khân păng sât jât bri dak khân păng nơm ri, sât jât trong êng, yorlah Kôranh Brah mbơh ma khân păng tâm nau mbơi, mâu ôh ăn khân păng plơ̆ mbơh ma kađăch Hêrôt. ");
INSERT INTO cmo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ndŭt sât khân păng a ri, geh tông păr tă bơh Kôranh Brah nhhơ săk ma Yôsep ta nau mbơi, păng lah: “Hơi Yôsep, dâk hŏm leo Kon Bê i nây, ndrel ma i mê̆ Păng nchuăt du gŭ ta bri Êsip ri. May gŭ ta bri nây kŏp tât gâp kuăl ƀŏt dâng may plơ̆ sât, yorlah kađăch Hêrôt ŭch tâng nkhât kon bê i nây.” ");
INSERT INTO cmo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jêh ri Yôsep kah rngăl bêch, leo ur leo kon păng nchuăt du jât bri Êsip dâng măng ro. ");
INSERT INTO cmo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Khân păng gŭ ta bri i nây tât khât kađăch Hêrôt, ndri nau dja jêng di đah nau Kôranh Brah đă bunuyh ntơyh nau ngơi Păng kăl e nơh nchih: ‘Kôranh Brah lah: ‘Gâp kuăl Kon Gâp lôh tă bơh bri Êsip nây’’. ");
INSERT INTO cmo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tât ma kađăch Hêrôt lĕ gĭt jêh mpôl gĭt blao gĭt năl uănh mănh mbing i nây rlăm păng, mâu ŭch plơ̆ mbơh, păng ji nuih hô ngăn, mân lah Kon Bê hôm ta ƀon Ƀêtlêhem, jêh ri đă bu hăn nkhât lơi kon bu klô ta ƀon Ƀêtlêhem, ndrel ma ƀon i tâm dăch đah ƀon Ƀêtlêhem ri đŏng, nkhât kon se i ntơm bơh bar năm jŭr jât dŏng ăn lĕ. Kađăch Hêrôt kơp năm kon se păng đă nkhât i nây, păng kơp ntơm bơh mpôl i gĭt blao i nây say mănh nơh ro. ");
INSERT INTO cmo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ƀon Ƀêtlêhem, ndrel ma ƀon Rama, ta ntŭk geh rnoi deh Rachel i ur Yakôp gŭ kăl e nơh. Ndri nau dja jêng di ngăn ma bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, rnha păng Yêrêmi păng nchih: ");
INSERT INTO cmo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Geh nau lư n'găr ta ƀon Rama, ntŭk bu ur me i rnoi deh Rachel i nây. Jêng nau nhhiăng nhŭm krit rngot hô ngăn, Nhŭm vơl yô̆ nđach ma kon păng. Păng mâu ŭch ôh bu bonh, yorlah kon păng lĕ khât jêh’. ");
INSERT INTO cmo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tât kađăch Hêrôt lĕ khât jêh, tông păr tă bơh Kôranh Brah nhhơ săk ma Yôsep ta bri Êsip ri, ta nau mbơi, păng lah: ");
INSERT INTO cmo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Hơi Yôsep! Leo Kon Bê i nây, ndrel ma i mê̆ Păng plơ̆ sât ta bri Israel hŏm, yorlah bunuyh i ŭch nkhât Kon Bê i nây nơh lĕ khât lĕ phiao jêh.” ");
INSERT INTO cmo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jêh ri Yôsep leo Kon Bê i nây, ndrel ma i mê̆ Păng plơ̆ sât ta bri Israel ro. ");
INSERT INTO cmo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tih ma Yôsep mâu ôh bănh gŭ ta ntŭk bri Yuđa, yor ma păng lư kôranh Arkêlôs i kon kađăch Hêrôt, păng ntrŏ i bơ̆ mât uănh ta bri Yuđa ri, n'ho ma Kôranh Brah mbơh ma păng tâng nau mbơi jât, mâu ueh ôh lah gŭ ta bri Yuđa. Ndri dâng păng hăn jât bri Galilê ri. ");
INSERT INTO cmo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tât ta bri Galilê ri păng gŭ ta du ƀon, ƀon i nây rnha Nasaret. Ndri tâm di đah nau bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh nchih ma Brah Krist: ‘Bu mra kuăl Păng bunuyh ƀon Nasaret’. ");
INSERT INTO cmo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jêh ri Yôhan-Ƀaptem tât ta bri rdah ta bri Yuđa, păng ntơm nti phung ƀon lan lah: ");
INSERT INTO cmo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Rgâl hŏm nuih n'hâm djơh khân ay may, yorlah nau Kôranh Brah mât uănh lĕ bơi tât.” ");
INSERT INTO cmo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Păng i nây bunuyh i geh nchih ta samƀŭt Êsai i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh nchih kơt nđa: ‘Geh du huê bunuyh nter ta bri rdah lah: ‘Ndrăp hŏm nuih n'hâm ăn ma Kôranh Brah Tâm ban ma bunuyh kuayh trong nsŏng trong ăn ma kađăch hăn’’. ");
INSERT INTO cmo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Lŏng Yôhan-Ƀaptem păng nsoh ao jong tanh ma rsau seh samô, văn rse bŭt jan ma ntô, ndơ sông sa păng krah ndrach, đah dak sŭt. ");
INSERT INTO cmo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nôk nây ŏk bunuyh ta ƀon kuŏng Yêrusalem, ŏk bunuyh ta bri Yuđa, ndrel ma ŏk bunuyh gŭ rŏ dak rlai Yôrđăn, văch ran ta Yôhan-Ƀaptem ri. ");
INSERT INTO cmo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Khân păng gĭt săk khân păng nơm tih mbơh ro, jêh ri Yôhan-Ƀaptem jan ƀăptem yŭk khân păng ma dak ta dak rlai Yôrđăn ri. ");
INSERT INTO cmo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tât ma say văch phung Pharisi, ndrel ma phung Sađôsi ŏk đŏng, hăn ŭch jan ƀăptem yŭk ma dak, păng lah khân păng kơt nđa: “Yê! Mpôl bunuyh djơh bunuyh janh tâm ban ma bêh ku, bu moh mbơh ma khân may dâng geh ma nchuăt krap bơh nau tê̆ dôih Kôranh Brah i bơi ma tât dja? ");
INSERT INTO cmo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lah khân may mâu ŭch Kôranh Brah tê̆ dôih, lah ndri gŭ sŏng jan ueh hŏm, gay ma gĭt say nuih n'hâm khân may lĕ rgâl ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Lơi hôm lah êng ta săk khân may nơm: ‘Gâp lĕ sau Abrahăm ngăn, ndri Kôranh Brah mâu hôm ôh tê̆ dôih’. Gâp lah ma khân may: Jêng sau Abrahăm dơm mâu ôh geh nau khlay. Lŭ dja Kôranh Brah sŏ njêng sau Abrahăm jêng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aƀaơ dja Kôranh Brah ŭch tê̆ dôih ma lĕ bunuyh i mâu jan ueh. Păng tâm ban ma bunuyh ndrăp lơi pêh thao tê̆ ta reh tơm si, Păng mra kăl lơi tơm si mâu geh play ueh, jêh ri su lơi ma ŭnh. ");
INSERT INTO cmo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Gâp jan ƀăptem ăn khân may yŭk ma dak dơm, gay ma nhhơ khân may lĕ rgâl nuih n'hâm djơh jêh. Yơn ma geh du huê Kôranh bơi tât jêh, Păng geh nau dơi rlau gâp ngăn. Ta năp Păng gâp jêng bunuyh jê̆ lê̆ dơm, bol lah gâp sơm droh ntô jot Păng, hôm e mâu hŏ di đŏng đah nau jan kar ăn ma Păng. Păng ƀăptem ăn khân may ma Brah Huêng Ueh i kloh ueh, ndrel ma ŭnh. ");
INSERT INTO cmo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Păng tâm ban ma bunuyh ndjôt dông, gay ma rseng gŭm mprôh lĕ ba i geh ta ntŭk Păng plên nây. Ba rnglay Păng sŏ tôh prăp ta jay ba Păng nơm, i nsiăp Păng su lơi ma ŭnh mâu ôh blao nhhŏt. Kơt ndri Păng tâm nkhah lơi bunuyh sŏng đah bunuyh tih, jêh ri tê̆ dôih ma bunuyh tih.” ");
INSERT INTO cmo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nôk nây Brah Yêsu hăn tă bơh bri Galilê, hăn mâp Yôhan-Ƀaptem ta dak rlai Yôrđăn, gay ma ăn Yôhan-Ƀaptem jan ƀăptem yŭk Păng ma dak. ");
INSERT INTO cmo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yơn ma tât ta nây Yôhan rlăch lah ma Păng: “Mơm hăn ta gâp, đă gâp chrao jan ƀăptem yŭk May ma dak? Di lah May sơm jan ăn gâp.” ");
INSERT INTO cmo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Brah Yêsu lah: “Aƀaơ dja ăn may jan ƀŏt dô, gay ma jan tâm di dadê đah nau Kôranh Brah lĕ đă.” Jêh ri Yôhan-Ƀaptem ŭch jan. ");
INSERT INTO cmo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jêh Brah Yêsu dơn ƀăptem yŭk ma dak, nôk Păng lôh bơh dak nây, dô ma say trôk pơk bŏng lahưr ma Păng, jêh ri Păng say Brah Huêng Ueh Kôranh Brah tâm ban ma plŭk jŭr drŏm ta Păng ri. ");
INSERT INTO cmo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dôl nây geh tăng nteh bŏr tă bơh kalơ trôk lah: “Dja Kon Gâp rŏng, Gâp răm rhơn ma Păng hô ngăn ngên.” ");
INSERT INTO cmo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jêh ri Brah Huêng Ueh leo Brah Yêsu hăn ta bri rdah, gay ma ăn Satăng i kôranh mpôl brah djơh ndơm Păng. ");
INSERT INTO cmo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Brah Yêsu ăt sông sa 40 năng 40 nar, bơh kơi nây Păng ji ngot ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jêh ri Satăng i bu kuăl lah ‘Kôranh ndơm’ đŏng, hăn dăch a Păng, lah ma Păng: “Lah May Kon Kôranh Brah ngăn ngên, lŏng May đă lŭ aƀă dja ăn jêng ndơ sông sa!” ");
INSERT INTO cmo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yơn ma Brah Yêsu ơh ma păng: “Mâu ôh. Lĕ bu nchih jêh ta Nau Kôranh Brah Ngơi: ‘Bunuyh mâu ôh rêh tă bơh ndơ sông sa dơm, Rêh tă bơh dâng lĕ nau ngơi lôh tă bơh mbung Kôranh Brah’.” ");
INSERT INTO cmo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jêh bơh nây kôranh mpôl brah djơh i nây leo Brah Yêsu lăp ta ƀon kuŏng Yêrusalem i ƀon kloh ueh, jêh ri ăn Păng ta kalơ chor nhih jan brah ma Kôranh Brah, ta ntŭk i dŭt prêh nây. ");
INSERT INTO cmo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Păng lah ma Brah Yêsu: “Lah May Kon Kôranh Brah ngăn ngên, lŏng May nsăt jât dŏng su, yorlah lĕ bu nchih jêh ta Nau Kôranh Brah Ngơi: ‘Kôranh Brah đă mpôl tông păr Păng nơm ăn kơl May’, geh nchih đŏng: ‘Ti tông păr drơ May, Mâu ôh ăn jŏng May geh nchĭnh ma lŭ’”. ");
INSERT INTO cmo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Brah Yêsu ơh ma păng: “Ta Nau Kôranh Brah Ngơi lĕ nchih kơt nđa: ‘Lơi ôh rlong nau dơi Kôranh Brah i brah khân ay may yơk mbah’.” ");
INSERT INTO cmo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jêh ri kôranh mpôl brah djơh i nây leo Brah Yêsu hao ta kalơ yôk dŭt prêh, nhhơ ăn Păng say dâng lĕ bri dak ta neh ntu dja, ndrel ma dâng lĕ ndơ khlay ta bri dak nây. ");
INSERT INTO cmo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Păng lah ma Brah Yêsu: “Lah May păn yơk mbah ma gâp, dâng lĕ ndơ i nây gâp ăn ma May mât uănh dadê!” ");
INSERT INTO cmo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Brah Yêsu lah: “Hơi Satăng, ăn may du hŏm! Yorlah ta Nau Kôranh Brah Ngơi lĕ nchih jêh: ‘Đă khân ay may yơk mbah ma Kôranh Brah i Brah khân ay may nơm, Jan kar iăt nau du huê Păng i nây dơm’.” ");
INSERT INTO cmo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jêh ri kôranh mpôl brah djơh i nây du bơh Brah Yêsu nây, dô ma geh phung tông păr Kôranh Brah văch ta Brah Yêsu, sơm kơl jan kar ăn ndơ sông sa ma Păng. ");
INSERT INTO cmo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tât Brah Yêsu gĭt Yôhan-Ƀaptem lĕ bu krŭng ta ndrung, jêh ri Păng lôh bơh bri Yuđa plơ̆ gŭ tay ta bri Galilê. ");
INSERT INTO cmo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Păng hăn ta ƀon Nasaret, jêh ri hăn gŭ ta ƀon Kapơnŭm i dăch kêng nglao kuŏng Galilê, ta n'hăr bri mpôl Sapulôn, đah ma bri mpôl Năptali. Bar mpôl i nây jêng mpôl Israel ta 12 mpôl khân păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Păng gŭ ta nây gay ma tâm di đah nau ngơi Êsai i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ nchih jêh: ");
INSERT INTO cmo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Ơ bri mpôl Sapulôn, ndrel ma bri mpôl Năptali I rŏ trong rŏ meng dak nglao kuŏng Galilê, ơ bri mpeh kăl ti dak rlai Yôrđăn, bri Galilê ntŭk ŏk phung i mâu di phung Israel gŭ! ");
INSERT INTO cmo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Phung ƀon lan ta nây khân păng tâm ban ma gŭ ta nau ngo, klach ma nau khât, mâu geh nau rnơm, Khân păng tâm ban ma say nau ang dŭt kuŏng, ang ngăn, ăn khân păng geh nau rnơm yor ma ndơ i geh ta bri khân păng’. ");
INSERT INTO cmo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ntơm bơh nôk nây Brah Yêsu mbơh nkoch: “Rgâl hŏm nuih n'hâm djơh khân ay may, yorlah nau Kôranh Brah mât uănh bơi ma tât ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Geh du nar ri Brah Yêsu hăn brô̆ rŏ meng dak nglao kuŏng Galilê, Păng say bar hê oh nô gŭ seng jal ta dak nây, Simôn i bu kuăl Pêtrôs đŏng, ndrel ma Ŏndrê. Bar hê khân păng i nây jêng bunuyh jan kar văng ka dơm. ");
INSERT INTO cmo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jêh ri Brah Yêsu lah ma khân păng: “Hơi oh nô, hô̆ tâng Gâp, Gâp ăn khân may hăn joi bunuyh iăt nau Gâp, tâm ban ma seng ka.” ");
INSERT INTO cmo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Dô ma bar hê khân păng ri ntlơi jal prŭng ta nây, jêh ri tâng Brah Yêsu ro. ");
INSERT INTO cmo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hăn tât a năp Brah Yêsu say bar hê oh nô a êng jât, Yakơ, ndrel ma Yôhan i kon Sêƀêđê. Khân păng dôl gŭ sŭl jal ta duk, ndrel ma i bơ̆ khân păng nơm. Brah Yêsu kuăl jă bar hê khân păng nây hăn ndrel Păng. ");
INSERT INTO cmo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jêh ri khân păng ntlơi duk, ntlơi bơ̆ khân păng nơm ta ri, hăn tâng Brah Yêsu ro. ");
INSERT INTO cmo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Brah Yêsu hăn lam bri Galilê, Păng nti phung ƀon lan ta nhih rƀŭn phung Israel khân păng nơm. Păng mbơh nkoch nau mhe mhan ueh ma nau Kôranh Brah mât uănh, jêh ri jan bah dâng lĕ nau ji ăp ntil. ");
INSERT INTO cmo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bu lư Brah Yêsu lam bri Siri đŏng i tâm dăch ma bri Galilê. Jêh ri bu njŭn leo dâng lĕ bunuyh i geh nau ji a Păng, bunuyh geh nau ji kuet ăp ntil, bunuyh brah djơh lơh, bunuyh brŭt, ndrel ma bunuyh rven jŏng rven ti, Păng jan bah dadê. ");
INSERT INTO cmo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jêh ri geh bunuyh phung ŏk tâng Păng, khân păng tă bơh bri Galilê, tă bơh bri Đêkapôlis, tă bơh ƀon kuŏng Yêrusalem, tă bơh bri Yuđa, ndrel ma tă bơh kăl ti dak rlai Yôrđăn. ");
INSERT INTO cmo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tât Brah Yêsu say phung ƀon lan ŏk, Păng hao ta meng yôk, gŭ rgơp ta nây. Mpôl oh mon Păng hăn a Păng, ");
INSERT INTO cmo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","jêh ri Brah Yêsu nti lah khân păng: ");
INSERT INTO cmo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ueh maak ngăn ma bu moh i lĕ gĭt jêh blao jan ndơ ueh lah Kôranh Brah kơl dơm, yorlah Kôranh Brah mât uănh khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ueh maak ngăn ma bu moh i geh nau nhŭm rngot, yorlah Kôranh Brah mra bonh leng khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ueh maak ngăn ma bu moh geh nuih n'hâm mleh, yorlah khân păng tay sŏ dơn dâng lĕ neh ntu. ");
INSERT INTO cmo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ueh maak ngăn ma bu moh nđơr joi nau sŏng tâm ban ma bunuyh ji ngot ji hir joi ndơ sông sa, yorlah Kôranh Brah mra ăn khân păng hơm ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ueh maak ngăn ma bu moh geh nau yô̆ ma bu, yorlah Kôranh Brah yô̆ ăn ma păng. ");
INSERT INTO cmo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ueh maak ngăn ma bu moh geh nuih n'hâm kloh, yorlah khân păng tay say Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ueh maak ngăn ma bu moh gĭt tâm kơl tâm rnglăp, yorlah khân păng bu kuăl tay jêng kon Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ueh maak ngăn ma bu moh bu jan jêr ach ma jan tâng nau sŏng, yorlah Kôranh Brah mât uănh khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ueh maak ngăn ma khân ay may, lah bu rak suai jan jêr, ndrel ma ngơi nchơt ăp ntil ma khân ay may, ach ma iăt tâng nau Gâp. ");
INSERT INTO cmo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Răm hŏm, maak răm hŏm, yorlah khân ay may tay geh ndơ nkhôm kuŏng ta ƀon ueh ta kalơ trôk. Ăn kah gĭt, bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh bu jan jêr kơt dja đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Khân ay may tâm ban ma boh ăn ma bunuyh ta neh ntu dja. Boh jêng du ntil ndơ tê̆ trao ma kah ngăn, lah boh i nây mâu hôm geh kah, mơm hôm blao jan gay ma ăn plơ̆ kah jât? Lah ndri bu mƀăr lơi bơh dih, jêh ri bu jot rƀlach dơm. ");
INSERT INTO cmo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Khân ay may tâm ban ma nau ang ma bunuyh ta neh ntu dja, tâm ban ma ƀon i bu jan ta kalơ yôk mâu ôh dơi pôn ndŏp. ");
INSERT INTO cmo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bu mâu vay ôh mpoh ŭnh sagêng, jêh ri kŭp lơi ma ndoh. Bu yông ŭnh sagêng i nây ta n'gŏng, gay ma ang dâng lĕ bunuyh ta trôm jay nây. ");
INSERT INTO cmo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lah ndri nau ang khân ay may ăn ngaang hŏm dâng lĕ bunuyh, gay ma ăn bu gĭt say nau ueh khân ay may jan, jêh ri bu rnê nau chrêk lơp Bơ̆ khân ay may nơm i gŭ ta kalơ trôk ri.” ");
INSERT INTO cmo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Dăn khân ay may lơi ta mân ôh Gâp dja văch, gay ma n'groh mƀăr lơi nau vay phung bân, mâu lah n'groh mƀăr lơi nau bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ geh lah. Gâp mâu geh ôh văch gay ma n'groh mƀăr lơi ndơ i nây, Gâp văch gay ma ăn nau i nây jêng ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, lah trôk, ndrel ma neh ntu ê hŏ lôch ôh, mâu geh ôh roh du rplây rso ta samƀŭt Nau Vay i nây, du ntil ta rplây rso dŭt jê̆ mâu roh đŏng, Nau Kôranh Brah Ngơi i nây hôm ƀaƀơ tât lôch dâng lĕ. ");
INSERT INTO cmo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bu moh i jan tih ma du ntil nau i dŭt jê̆ jê̆ ta nau vay i nây, jêh ri nti ăn ma bu jan tâng kơt đŏng, ta nau Kôranh Brah mât uănh tay bu kuăl păng jêng bunuyh jê̆ ta nâm bu. Yơn ma bu moh jan tâng nau vay i nây, jêh ri nti ăn ma bu jan tâng kơt đŏng, ta nau Kôranh Brah mât uănh tay bu kuăl păng jêng bunuyh kuŏng ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gâp lah ma khân ay may: Lah nau sŏng khân ay may mâu rlau ôh ma nau sŏng phung nơm nti nau vay phung bân, ndrel ma nau sŏng phung Pharisi, khân ay may mâu dơi ôh lăp ta nau Kôranh Brah mât uănh.” ");
INSERT INTO cmo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Khân ay may lĕ tăng bu lah ma phung u che kăl e nơh: ‘Lơi ôh nkhât bunuyh’. Lah bu moh nkhât bunuyh, păng i nây bu tê̆ dôih ma păng. ");
INSERT INTO cmo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yơn ma Gâp lah ma khân ay may kơt nđa: Bu moh i ji nuih đah ma oh nô păng dơm, păng i nây Kôranh Brah tê̆ dôih ma păng. Bu moh i ngơi djơh ma oh nô păng, păng i nây Kôranh Brah tê̆ dôih. Jêh ri bu moh i rak suai bu, păng i nây Kôranh Brah tê̆ dôih gŭ ta ndrung ŭnh n'ho ro. ");
INSERT INTO cmo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Lah ndri nôk khân ay may ndjôt ndơ nhhơr hăn ta nhih jan brah ma Kôranh Brah ta nsưng gŭch pur ndơ jan brah, tât ta nây lah khân ay may kah gĭt khân ay may geh jan tih ma oh nô khân ay may, ");
INSERT INTO cmo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ăn khân ay may prăp ndơ nhhơr i nây ta nây ƀŏt, jêh ri hăn dăn nau yô̆ lor đah oh nô khân ay may, ri mơ dâng khân ay may plơ̆ nhhơr tay ndơ i nây nơh. ");
INSERT INTO cmo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ăn khân ay may tâm dăn nau yô̆ hŏm đah bunuyh i geh nau đah khân ay may dôl khân ay may hôm hăn ndrel păng rŏ trong hăn ta kôranh phat dôih. Klach lah păng njŭn khân ay may ăn ma kôranh phat dôih, kôranh phat dôih njŭn khân ay may ăn ma kôranh ndrung, jêh ri kôranh ndrung krŭng khân ay may ta trôm ndrung ro. ");
INSERT INTO cmo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, lah khân ay may mâu râng ăn prăk ma bu, khân ay may mâu ôh dơi lôh bơh ntŭk nây, bol lah du sên mâu roh đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Khân ay may lĕ tăng ta nau vay bân lĕ nchih lah kơt nđa: ‘Lơi ta lŏm ur lŏm sai’. ");
INSERT INTO cmo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yơn ma Gâp lah ma khân ay may, lah bu moh uănh bu ur nđâp ma kơnh, lah ndri ta nuih n'hâm păng ri lĕ kơp lŏm ur đah bu ur i nây. ");
INSERT INTO cmo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Lah ndri lah trôm măt bơh ma khân ay may leo jan tih, ăn khân ay may rvek mƀăr lơi trôm măt i nây, yorlah ueh đê̆ lah dơn roh trôm măt du ding, ma đah dâng lĕ săk jăn khân ay may hôm râng, jêh ri hăn ta ndrung ŭnh n'ho ro. ");
INSERT INTO cmo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Lah ti bơh ma khân ay may leo jan tih, ăn khân ay may koh mƀăr lơi ti i nây, yorlah ueh đê̆ lah dơn roh ti du ding, ma đah dâng lĕ săk jăn khân ay may hôm râng, jêh ri hăn ta ndrung ŭnh n'ho ro.” ");
INSERT INTO cmo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ta nau vay bân lĕ nchih lah kơt nđa: ‘Bu moh i ŭch ntlơi ur păng nơm, ăn păng i nây jan samƀŭt tâm ntlơi dơm ăn ma ur păng, jêh ri dơi ntlơi i ur păng’. ");
INSERT INTO cmo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yơn ma Gâp lah ma khân ay may, lah bu ur i nây mâu geh ôh lŏm sai, tih ma sai păng ntlơi, sai i nây jan ăn ur păng jêng bunuyh lŏm sai. Jêh ri lah bu moh tâm nđăp đah bu ur sai ntlơi, păng jêng bunuyh lŏm ur đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Khân ay may lĕ tăng bu lah ma phung u che kăl e nơh: ‘Lơi ôh ton mƀrôh, ăn khân ay may jan râng dâng lĕ ndơ i khân ay may lĕ ton ma Kôranh Brah’. ");
INSERT INTO cmo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yơn ma Gâp lah ma khân ay may, lơi ôh ton đah trôk, yorlah trôk jêng rnơl Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Lơi đŏng ton đah neh ntu, yorlah neh ntu dja jêng rnơl săp jŏng Kôranh Brah. Đah ƀon kuŏng Yêrusalem mâu di đŏng, yorlah ƀon Yêrusalem ntŭk Kôranh Brah i kađăch kuŏng. ");
INSERT INTO cmo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Lơi ôh ton đah bôk khân ay may nơm, yorlah khân ay may mâu dơi ôh jan du mlŏm sŏk khân ay may nơm ăn jêng nglang, ăn jêng krăk. ");
INSERT INTO cmo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ăn khân ay may ngơi sŏng nâng hŏ ‘Ơ’, ăn gĭt lah ‘Ơ’, ‘Mâu’, ăn gĭt lah ‘Mâu’. Ndơ nau ngơi ntop jêng lôh tă bơh kôranh mpôl brah djơh dadê.” ");
INSERT INTO cmo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Khân ay may lĕ tăng ta nau vay bân lĕ nchih lah kơt nđa: ‘Lah roh măt du ding, plơng ăn roh măt du ding, lah deh du mlŏm sêk, plơng ăn deh du mlŏm sêk đŏng’. ");
INSERT INTO cmo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yơn ma Gâp lah ma khân ay may, lơi ôh tâm plơng đah ma bunuyh djơh. Lah bu tap tâm bom khân ay may du ding, ăn khân ay may rle du ding, ăn bu tap tay du ding jât. ");
INSERT INTO cmo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Lah bu ntôn khân ay may ta năp kôranh phat dôih gay ma kơnh geh ao gleh khân ay may, ăn bu sŏ nđâp ma ao jong đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Lah tahen nchâp khân ay may ăn anh ndơ brô̆ du nor yôk, ăn khân ay may brô̆ bar nor yôk ndrel bu dô. ");
INSERT INTO cmo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bu moh dăn ndơ khân ay may, khân ay may ăn dô, lơi ôh du krap lah bu hăn manh ndơ khân ay may.” ");
INSERT INTO cmo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Khân ay may lĕ tăng ta nau vay bân lĕ nchih lah kơt nđa: ‘Ăn khân ay may rŏng ma bu chiao meng, jêh ri biănh ma phung jan djơh đah khân ay may’. ");
INSERT INTO cmo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yơn ma Gâp lah ma khân ay may, ăn khân ay may rŏng ma phung jan djơh đah khân ay may, jêh ri mbơh sơm dăn Kôranh Brah ăn nau geh jêng ma bu moh jan jêr đah khân ay may, ");
INSERT INTO cmo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","gay ma khân ay may jêng kon ngăn ma Kôranh Brah bơ̆ khân ay may gŭ ta kalơ trôk ri. Yorlah Kôranh Brah ăn nar lôh ang, gay ma ngaang bunuyh ueh, nđâp ma bunuyh djơh, jêh ri Păng ăn dak mih ma bunuyh sŏng, nđâp ma bunuyh kue đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lah khân ay may dơn rŏng dơm ma bunuyh rŏng đah khân ay may, lah ndri mơm dâng Kôranh Brah rnê ăn nau nkhôm ma khân ay may? Yorlah bunuyh i bu kơp bunuyh tih kơt lah phung i kŏp sŏ prăk ƀon lan gay ma ăn kôranh mât uănh, khân păng hôm blao rŏng ma bunuyh i rŏng khân păng nơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Lah khân ay may dơn rom dơm ma oh nô khân ay may nơm, lah ndri mơm dâng khân ay may jan ndơ ueh rlau bu êng? Bol lah phung i mâu gĭt năl nau Kôranh Brah, khân păng vay jan kơt nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Lah ndri ăn khân ay may gŭ dŭt ueh hŏm, yorlah Bơ̆ khân ay may i gŭ ta kalơ trôk ri, Păng lĕ dŭt ueh ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ăn khân ay may njrăng, lơi ôh jan ndơ ueh ma bu ta năp băl phung gay ma ăn bu say. Lah jan kơt nây, khân ay may mâu geh ôh ndơ nkhôm tă bơh Kôranh Brah Bơ̆ khân ay may i gŭ ta kalơ trôk ri. ");
INSERT INTO cmo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nôk khân ay may ăn ndơ yô̆ ma phung o ach, lơi ôh mbơh ma dâng lĕ bunuyh ma ndơ khân ay may jan i nây tâm ban ma phung i nhhơ nau ueh ăn bu say ta kalơ ntô dơm vay jan ta nhih rƀŭn phung bân, mâu lah rŏ trong, gay ma ăn bu rnê. Gâp lah n'hêl nanê̆ ngăn ma khân ay may, phung i nhhơ nau ueh ăn bu say ta kalơ ntô dơm i nây lĕ geh bu rnê khân păng jêh, Kôranh Brah mâu hôm ôh ăn ndơ ueh ma khân păng jât. ");
INSERT INTO cmo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Yơn ma nôk khân ay may ăn ndơ yô̆, ăn khân ay may jan ntŭng mpôn hŏ, tâm ban ma lơi ăn ti bơh chiao gĭt i ti bơh ma jan, jêh ri Kôranh Brah Bơ̆ khân ay may i say dâng lĕ ndơ i bu jan ntŭng mpôn đŏng, tay Păng nkhôm ma khân ay may.” ");
INSERT INTO cmo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nôk khân ay may mbơh sơm, lơi ôh jan tâm ban ma phung i nhhơ nau ueh ăn bu say ta kalơ ntô dơm vay dâk mbơh sơm ta trôm nhih rƀŭn phung bân, ndrel ma ta meng trong, gay ma bu say. Gâp lah n'hêl nanê̆ ngăn ma khân ay may, phung i nây lĕ geh jêh ndơ nkhôm ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yơn ma khân ay may, nôk mbơh sơm, ăn khân ay may lăp ta trôm jrô ntâl mpông ăn nâp, jêh ri mbơh sơm dăn ma Kôranh Brah Bơ̆ khân ay may i bunuyh mâu blao say. Lah ndri Kôranh Brah Bơ̆ khân ay may i say dâng lĕ ndơ i geh ta ntŭk ndŏp đŏng, tay Păng nkhôm ma khân ay may. ");
INSERT INTO cmo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nôk khân ay may mbơh sơm, lơi lah jong rhêng kơt phung i mâu gĭt năl nau Kôranh Brah, nau i nây mâu geh ôh khlay. Khân păng mân lah Kôranh Brah iăt khân păng tă bơh nau ngơi ŏk. ");
INSERT INTO cmo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Lah ndri khân ay may lơi ôh jan kơt khân păng i nây, yorlah Kôranh Brah Bơ̆ khân ay may lĕ ơm gĭt lor moh ndơ khân ay may ŭch dăn tă bơh Păng. ");
INSERT INTO cmo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lah ndri ăn khân ay may mbơh sơm kơt nđa: ‘Ơ Kôranh Brah Bơ̆ hên gŭ ta kalơ trôk, Ăn dâng lĕ bunuyh yơk mbah ma May. ");
INSERT INTO cmo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ăn nau May mât uănh gơnh tât. Dăn dâng lĕ nau ta neh ntu dja tâng nau May ŭch, Tâm ban ma dâng lĕ nau ta kalơ trôk lĕ tâng nau May ŭch. ");
INSERT INTO cmo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ăn ndơ sông sa ma hên nar dja ăn tŏng. ");
INSERT INTO cmo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yô̆ nđach lơi hôm kơp nau tih hên, Tâm ban ma hên yô̆ nđach ma bunuyh jan tih ma hên, mâu hôm kơp nau tih păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kơl hên lơi ôh jan tih, nôk hên geh nau ndơm. Dăn rklaih hên bơh nau djơh mhĭk. May jêng kađăch, May geh nau brah, ndrel ma geh nau chrêk lơp ƀaƀơ n'ho ro. Ơ ăn geh kơt nđa ngăn ro.’ ");
INSERT INTO cmo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Lah khân ay may yô̆ bu mâu kơp nau tih i bu jan ma khân ay may, Kôranh Brah Bơ̆ khân ay may ta kalơ trôk yô̆ khân ay may mâu hôm kơp đŏng nau tih. ");
INSERT INTO cmo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tih ma lah khân ay may mâu geh nau yô̆, hôm kơp nau tih bu, Kôranh Brah Bơ̆ khân ay may i gŭ ta kalơ trôk mâu yô̆ đŏng hôm kơp nau tih ma khân ay may.” ");
INSERT INTO cmo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nôk khân ay may ăt sông gay ma mbơh sơm, lơi ôh jan muh măt rngot tâm ban ma phung i nhhơ nau ueh ăn bu say ta kalơ ntô dơm. Khân păng jan kơt nây, gay ma ăn bu gĭt lah khân păng ăt sông. Gâp lah n'hêl nanê̆ ngăn ma khân ay may, phung i nây lĕ geh jêh ndơ nkhôm ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yơn ma khân ay may, nôk khân ay may ăt sông, ăn khân ay may kât sŏk, jêh ri rpôh muh măt, ");
INSERT INTO cmo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","gay ma lơi ăn bu say khân ay may ăt sông. Ăn Kôranh Brah Bơ̆ khân ay may i bunuyh mâu blao say dơm hŏ say, lah ndri Kôranh Brah Bơ̆ khân ay may i say dâng lĕ ndơ i geh ta ntŭk ndŏp đŏng, tay Păng nkhôm ma khân ay may.” ");
INSERT INTO cmo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Lơi ôh rƀŭn drăp ndơ prăp ma săk khân ay may nơm ta neh ntu dja, jêng ntŭk ăch găm sa, ndrel ma tăpdâr grăch, jêh ri geh bunuyh ntŭng hăn lôk mpir gay ma ntŭng. ");
INSERT INTO cmo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ăn khân ay may rƀŭn drăp ndơ prăp ma săk khân ay may nơm ta ntŭk Kôranh Brah ta kalơ trôk ri hŏ, jêng ntŭk mâu geh ăch găm sa, ndrel ma mâu geh tăpdâr grăch, mâu geh đŏng bunuyh ntŭng hăn lôk mpir ma ntŭng. ");
INSERT INTO cmo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Njrăng hŏm, ndơ i khân ay may ntrŏng khlay rlau bu, jêng ndơ i khân ay may mân rvê rlau bu đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Trôm măt jêng tâm ban ma sagêng ma săk jăn, lah trôm măt khân ay may hôm ang ueh, lĕ săk jăn khân ay may hôm ang dadê. ");
INSERT INTO cmo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yơn ma lah măt khân ay may lĕ ngo, dâng lĕ săk jăn khân ay may ngo dadê đŏng. Lah nau ang ta săk khân ay may lĕ ngo, lah ndri nau ngo i nây lĕ hô ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Mâu geh ôh du huê bunuyh blao jan kar ăn ma bar hê kôranh, yorlah păng mra rŏng ma du huê kôranh, jêh ri biănh ma du huê kôranh, mâu lah tâng jât du huê, mưch i du huê ri. Kơt ndri khân ay may mâu dơi ôh gay geh nau rêh n'ho ro ta Kôranh Brah, gay geh nđâp ma drăp ndơ ta neh ntu đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kơt ndri dâng Gâp mbơh khân ay may, lơi rvê ôh ma ndơ sông sa ma ndơ nhêt ma siăm nau rêh, mâu lah bok ao ma nsoh n'gut săk jăn khân ay may. Geh ndơ êng jât ta nau rêh i geh nau khlay rlau ma ndơ sông sa, geh ndơ êng jât ma bunuyh i geh nau khlay rlau ma bok ao ma nsoh. ");
INSERT INTO cmo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lŏng uănh siŭm mpăr kalơ trôk, păng mâu geh ôh tuch tăm, mâu geh ôh kăch roih, mâu geh tôh ba ta trôm jay đŏng, yơn ma Kôranh Brah Bơ̆ khân ay may ta kalơ trôk mât siăm khân păng đŏng. Lah ndri ah khân ay may ơm mâu lah khlay rlau ma siŭm mpăr i nây jât ƀah? ");
INSERT INTO cmo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ta mpôl khân ay may i nây, bol lah khŏm rvê dŭt hô kađôi lĕ, kŏ mâu geh bunuyh ma dơi ntop nau rêh păng nơm ăn jong ôh, đê̆ kŏ mâu dơi đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mơm dâng khân ay may rvê ma ndơ nsoh n'gut? Lŏng khân ay may uănh kao si hon êng ta bri, păng mâu ôh rơah mâu ôh rgănh jan kar, mâu lah rui tanh gay ma ueh uănh. ");
INSERT INTO cmo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Gâp mbơh ma khân ay may, bol lah kađăch Salômôn kăl e nơh, nôk păng nkrơ̆ săk jăn soh n'gut kho ao khlay ueh, kŏ mâu dơi ban ueh kao si du nkong dja đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hơi bunuyh geh nau nsing đê̆ dơm, lah Kôranh Brah ăn jêh ma kao si i nây ueh ngăn uănh, nar dja păng dang, nar ôi tay bu su lơi păng ma ŭnh, lah ndri lơ rlau ma nây đŏng ƀah Kôranh Brah ndrăp kho ao ăn ma khân ay may? ");
INSERT INTO cmo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Lah ndri khân ay may lơi rvê ôh ma ndơ sông sa, ma ndơ nhêt, mâu lah ma ndơ nsoh n'gut. ");
INSERT INTO cmo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Geh phung i mâu gĭt năl Kôranh Brah khŏm nsrôyh joi dâng lĕ ndơ i nây. Lŏng i khân ay may nây Kôranh Brah Bơ̆ khân ay may nơm ta kalơ trôk ri, lĕ Păng gĭt dadê jêh moh ndơ i khân ay may ê hŏ tŏng. ");
INSERT INTO cmo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lah ndri nsrôyh joi, ndrel ma iăt lĕ ndơ i sŏng ta năp măt Kôranh Brah lor, ri mơ Păng ăn ntop dâng lĕ ndơ i nây ma khân ay may đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Khân ay may lơi ôh rvê ma nar ôi tay, yorlah nar ôi tay mra geh nau rvê ma nar i nây. Rvê ma nau jêr ta nar dja lĕ găp hơyh.” ");
INSERT INTO cmo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Khân ay may lơi ôh uănh nau tih bu, gay ma lơi ăn Kôranh Brah uănh nau tih khân ay may. ");
INSERT INTO cmo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lah khân ay may uănh nau tih bu, Kôranh Brah uănh nau tih khân ay may kơt nây đŏng. Kôranh Brah rnhueh ăn ma khân ay may, tâng khân ay may rnhueh ăn bu nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nau tih bunuyh jêng tâm ban ma ndơ ta trôm măt. Mơm khân ay may uănh say ndruyh ta trôm măt oh nô khân ay may dơm, tih ma uănh mâu ôh say mŏng rlat ta trôm măt khân ay may nơm? ");
INSERT INTO cmo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Lah geh mŏng rlat ta trôm măt khân ay may nơm, mơm dơi lah ma oh nô: ‘Ăn gâp nkhĕ ndruyh nây’? ");
INSERT INTO cmo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ơ bunuyh mƀrôh! Ăn sŏ rlat ta trôm măt khân ay may nơm nây lor ƀŏt, ri mơ say n'hêl ndruyh ta trôm măt oh nô, dâng blao nkhĕ ndruyh nây.” ");
INSERT INTO cmo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Lơi ôh mƀăr ndơ kloh ueh ăn ma so, mâu dơi mƀăr ăn ma sŭr đŏng, klach lah păng jot rƀlach, jêh ri rdôh plơ̆ kăp khân ay may nơm. Kơt ndri đŏng ăn gĭt mơm dâng nti nau Kôranh Brah ăn ma bunuyh i mâu ŭch iăt.” ");
INSERT INTO cmo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Dăn mro mrăng hŏm ma Kôranh Brah dâng Păng ăn ma khân ay may. Joi mro mrăng hŏm dâng say. Kuăl mro mrăng hŏm bơh dih mpông dâng Kôranh Brah pơk ăn ma khân ay may ro. ");
INSERT INTO cmo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yorlah bu moh dăn, mra geh, bu moh joi, mra say, jêh ri bu moh i kuăl bơh dih mpông, mra pơk ăn ma păng. ");
INSERT INTO cmo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ta mpôl khân ay may vay geh đŏng, lah kon dăn piăng ăn nkhơng lŭ ma păng chrao? ");
INSERT INTO cmo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Lah kon dăn ka, bơ̆ păng ăn nkhơng bêh geh kăch ma păng chrao bơh? ");
INSERT INTO cmo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bol lah khân ay may jêng bunuyh tih kađôi, khân ay may hôm blao ăn ndơ ueh ma kon khân ay may đŏng. Lah ndri Kôranh Brah Bơ̆ khân ay may i gŭ ta kalơ trôk rlau bơh nây ăn ndơ ueh ma bu moh dăn bơh Păng.” ");
INSERT INTO cmo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ta ăp ntil ndơ, moh nau ŭch ăn bu jan ma khân ay may, ăn khân ay may jan ma bu lor. Nau i nây jêng tâm di đah nau vay, ndrel ma nau bunuyh ntơyh nau ngơi Kôranh Brah lĕ nchih. ");
INSERT INTO cmo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ăn khân ay may lăp rŏ mpông mpêr huêt, yorlah mpông mpêr i hăn ta nau roh hêng huy, ndrel ma trong i njŭn ta nau roh hêng dơh ngăn ma hăn, geh ŏk bunuyh lăp rŏ mpông mpêr i nây. ");
INSERT INTO cmo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yơn ma mpông mpêr i hăn ta nau rêh n'ho ro huêt, ndrel ma trong i njŭn ta nau rêh n'ho ro jêr ma hăn, geh đê̆ dơm bunuyh joi say trong i nây.” ");
INSERT INTO cmo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ăn khân ay may njrăng hŏm ma bunuyh ntơyh nklă nau ngơi Kôranh Brah. Khân păng văch a khân ay may mleh, uănh tâm ban ma be biăp, yơn ma ta trôm nuih n'hâm khân păng ri janh tâm ban ma so bri ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Khân ay may gĭt năl khân păng tă bơh ndơ khân păng jan, tâm ban ma bu gĭt năl tơm si tă bơh play păng. Bu mâu prot ôh pĕ play yŭng yar ƀon, mâu lah pĕ play Rvi tă bơh pŭm lok đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lah ndri dâng lĕ tơm si ueh, play păng ueh, yơn ma tơm si djơh, play păng djơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mâu prot geh ôh lah tơm ueh i play djơh, tơm djơh i play ueh. ");
INSERT INTO cmo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Dâng lĕ tơm si play mâu ueh, bu kăl pur lơi ta ŭnh. ");
INSERT INTO cmo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Lah ndri dâng khân ay may dơi gĭt năl bunuyh ntơyh nklă, yor ma say ndơ păng jan.” ");
INSERT INTO cmo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Bunuyh dơi lăp ta nau Kôranh Brah mât uănh, mâu dơn kuăl Gâp ‘Ơ Kôranh, ơ Kôranh’ dơm ôh. Păng i jan tâng Kôranh Brah Bơ̆ Gâp gŭ ta kalơ trôk ŭch, păng i nây dơm dơi lăp. ");
INSERT INTO cmo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ta nar phat dôih dâng lĕ bunuyh, mra geh ŏk bunuyh lah ma Gâp: ‘Ơ Kôranh, ơ Kôranh, hên vay ntơyh nau ngơi May, hên vay mprơh brah djơh ma rnha săk May, ndrel ma ŏk ngăn hên jan nau khlay ma rnha săk May’. ");
INSERT INTO cmo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yơn ma ta nôk nar nây tay, Gâp lah ma bunuyh i nây: ‘Ơ phung kue phung djơh, du ngai hŏm bơh Gâp, Gâp mâu ôh gĭt năl khân ay may’.” ");
INSERT INTO cmo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Bu moh tăng nau Gâp ngơi dja, jêh ri jan tâng kơt, păng i nây jêng tâm ban ma bunuyh blao mân jan jay păng nơm tăm meh kuyh ntu ăn jru. ");
INSERT INTO cmo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bol lah geh mih kuŏng, geh dak kuŏng rlap hoch, ndrel ma geh sial khôm ăn n'gơ kađôi đŏng, jay i nây mâu ôh dơi rlŏm, yorlah meh păng lĕ bu tăm ăn nâp. ");
INSERT INTO cmo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yơn ma bu moh lĕ tăng jêh nau gâp ngơi dja, tih ma mâu ôh jan tâng kơt, păng i nây jêng tâm ban ma bunuyh mâl jan jay păng nơm n'gŏn dơm ta kalơ neh. ");
INSERT INTO cmo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lah geh mih kuŏng, geh dak rlap hoch, ndrel ma geh sial khôm ăn n'gơ kađôi đŏng, jay i nây rlŏm djơh lĕ phiao ro.” ");
INSERT INTO cmo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tât ma lĕ jêh Brah Yêsu ngơi dâng lĕ nau i nây, phung ƀon lan gŭ iăt ndrŏt hih rhŏl ngăn tăng nau Păng nti i nây, ");
INSERT INTO cmo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yorlah nau Păng nti nơh geh nau dơi ngăn, mâu geh ôh kơt nơm nti nau vay phung Israel khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nôk Brah Yêsu jŭr bơh kalơ yôk nây, geh ŏk bunuyh tâng Păng. ");
INSERT INTO cmo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ta nây geh du huê bunuyh phŭng sa chon kômŏk ta năp Brah Yêsu, păng lah: “Ơ Kôranh! Gâp gĭt May dơi jan săk gâp ăn kloh ăn bah ji, lah May ŭch.” ");
INSERT INTO cmo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Brah Yêsu pah ti ta săk păng ri, jêh ri lah ma bunuyh phŭng sa i nây: “Ơ, Gâp ŭch đŏng, bah hŏm!” Du ƀlât ta nây păng bah ro, mâu hôm phŭng sa ôh. ");
INSERT INTO cmo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jêh ri Brah Yêsu lah ma păng: “May lơi ôh mbơh nkoch nau i dja ăn bu gĭt, ăn may hăn brŏng nhhơ săk ma bunuyh jan brah ri, jêh ri nhhơr ndơ jan brah tâng nau vay Môsê đă ma bunuyh bah nau ji phŭng sa, gay ma bu gĭt n'hêl săk may lĕ kloh lĕ bah ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tât Brah Yêsu hăn lăp ta ƀon Kapơnŭm, geh du huê kôranh tahen Rôm hăn bonh Păng: ");
INSERT INTO cmo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ơ Kôranh, geh du huê bunuyh jan kar ma gâp bêch rkhuen ta gre ri, păng ji rven geh nau jêr dŭt hô ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Brah Yêsu lah ma păng: “Hô̆ Gâp hăn jan ăn păng bah.” ");
INSERT INTO cmo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kôranh tahen i nây lah ma Brah Yêsu: “Ơ Kôranh, mâu khăch ôh jă leo May lăp ta jay gâp, yorlah gâp mâu di phung Israel, ndri dâng mâu ôh di, lah gâp jă May lăp ta jay gâp, dăn May lah du tong bơh nây dơm, bunuyh jan kar ma gâp bah ji ro. ");
INSERT INTO cmo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gâp gŭ ta nâm bu, yơn ma geh ŏk kon tahen gŭ ta nâm gâp đŏng. Lah gâp đă du huê hăn, păng hăn ro, lah đă bunuyh a êng văch, păng văch ro. Lah gâp đă dâk gâp jan ndơ du ntil, păng jan ro. Lah ndri gâp gĭt lah May ngơi geh nau dơi kơt nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tât ma Brah Yêsu lĕ tăng nau nây, ta nuih n'hâm Păng ri ndrŏt hih rhŏl ngăn, Păng lah ma phung tâng Păng: “Gâp lah n'hêl nanê̆ ngăn ma khân ay may, ta phung Israel i kơp êng săk khân păng nơm lah lĕ gĭt năl Kôranh Brah, ê hŏ say geh du huê geh nau nsing kơt păng i nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Gâp mbơh ma khân ay may, mra geh ŏk bunuyh tă bơh lôh nar, ndrel ma tă bơh nhŏp nar, khân păng i mâu ôh di phung Israel, ta nau Kôranh Brah mât uănh, văch gum sông sa ndrel Abrahăm, Isăk, ndrel ma Yakôp i che phung bân. ");
INSERT INTO cmo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yơn ma phung Israel i ơm di lăp ta nau Kôranh Brah mât uănh, geh ŏk bu mƀăr lơi khân păng bơh dih ta ntŭk ngo, ta ntŭk nây geh nau nhhiăng nhŭm, ndrel ma rchiăt sêk.” ");
INSERT INTO cmo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jêh ri Brah Yêsu lah ma kôranh tahen Rôm i nây: “May hăn sât dô, ăn geh kơt nau nsing may nây ngăn.” Bunuyh jan kar ma păng bah nau ji mong nây ro. ");
INSERT INTO cmo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jêh ri Brah Yêsu hăn lăp ta jay Pêtrôs, Păng say mê̆ po Pêtrôs ji kop bêch ta gre ri. ");
INSERT INTO cmo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Brah Yêsu pah ta ti păng, păng bah ro, jêh ri păng jan piăng trao ma Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tât bri kêng măng bu njŭn bunuyh brah djơh lăp ŏk hăn a Brah Yêsu. Păng mprơh brah djơh i nây ma nau Păng ngơi, ndrel ma jan bah bunuyh ji kuet ăn bah dadê đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Păng jan kơt nây, gay ma tâm di đah nau Êsai i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ nchih jêh: ‘Păng i nây lĕ sŏ dơn dâng lĕ nau kuet rven bân ta Păng nơm, nau ji bân Păng tui đŏng’. ");
INSERT INTO cmo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tât Brah Yêsu say bu gŭ jŭm Păng ŏk ngo ngăn, Păng đă mpôl oh mon gay ma ncho duk hăn kăl ti dak nglao kuŏng Galilê. ");
INSERT INTO cmo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nôk nây geh du huê nơm nti nau vay phung Israel lah ma Brah Yêsu: “Ơ Kôranh, ah ntŭk May hăn, gâp hăn tâng May đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Brah Yêsu lah ma păng: “Lŏng srot geh trôm ntŭk păng gŭ, siŭm nar geh rsuăn đŏng, tih ma Gâp i Kon Bunuyh tă bơh Kôranh Brah mâu geh ôh ntŭk Gâp nơm ngăn ma dŏm bôk.” ");
INSERT INTO cmo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Geh du huê ta mpôl oh mon Brah Yêsu lah ma Păng: “Ơ Kôranh, ăn gâp kŏp bơ̆ gâp khât, ndrel ma tŏp păng ƀŏt.” ");
INSERT INTO cmo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Brah Yêsu lah ma păng: “Hăn tâng Gâp aƀaơ ri hŏm. Bunuyh mâu iăt nau Gâp tâm ban ma bunuyh lĕ khât, ăn khân păng tâm tŏp êng ndrăng khân păng nơm.” ");
INSERT INTO cmo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jêh ri Brah Yêsu jŭr ncho duk, phung oh mon Păng ncho ndrel Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Dô ma geh sial phŭt dŭt hô tât ma dak rbuh lăp ta trôm duk ri. Yơn ma Brah Yêsu lĕ hăk bêch. ");
INSERT INTO cmo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Phung oh mon rlay Păng: “Ơ Kôranh! Kơl rklaih hŏm hên, khât ro bân mê!” ");
INSERT INTO cmo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Brah Yêsu lah ma khân păng: “Ơ phung geh nau nsing đê̆ dơm, moh nau khân may klach hô ir?” Brah Yêsu dâk, Păng buay sial phŭt, ndrel ma dak, dak nchŏch rbuh rngŏn njŭp ro. ");
INSERT INTO cmo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nôk nây phung oh mon ndrŏt hih rhŏl, khân păng tâm lah: “Hay, bu moh Păng i nây hiah, dâng geh ma sial phŭt, ndrel ma dak nchŏch iăt Păng?” ");
INSERT INTO cmo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nôk Brah Yêsu, ndrel ma phung oh mon Păng tât kăl ti dak nglao kuŏng Galilê ta bri Garasin, ntŭk ƀon i nây bu mâu ôh tâng nau vay phung Israel, ta nây geh bar hê bu klô brah djơh lăp. Khân păng lôh bơh ntŭk môch ri, hăn ran a Brah Yêsu. Bar hê bu klô i nây janh janh ngăn, kơt ndri dâng bu mâu bănh hăn rŏ nây. ");
INSERT INTO cmo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bar hê bu klô i nây nter lah Brah Yêsu: “Ơ Kon Kôranh Brah, moh geh nau May ma hên hă? May hăn ta dja gay ma ŭch nkrit hên ê lor ma tât di nar Kôranh Brah lĕ ndrăp bơh?” ");
INSERT INTO cmo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ngai oi đah mpôl khân păng i nây, geh sŭr phung gŭ sa mpa ta ri. ");
INSERT INTO cmo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Phung brah djơh i nây bonh Brah Yêsu: “Ơ Kôranh, lah May mprơh hên, dăn May njuăl hên lăp ta sŭr phung i nây ơ.” ");
INSERT INTO cmo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Brah Yêsu lah: “Hăn hŏm!” Jêh ri phung brah djơh lôh bơh bar hê bu klô i nây lăp ta sŭr ri. Lŏng sŭr phung i ri nchuăt rbŭl jât sop rƀŏng jât dak nglao kuŏng khât rmok ta dak lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mpôl mât sŭr i nây leo băl nchuăt a ƀon, mbơh nkoch dâng lĕ nau i nây, nđâp ma mbơh nkoch ma bar hê bunuyh brah djơh lăp nây nơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dâng lĕ bunuyh ta ƀon nây ran hăn mâp Brah Yêsu dadê, tât ma lĕ say Brah Yêsu, khân păng bonh Brah Yêsu ăn Păng lôh bơh bri khân păng nây. ");
INSERT INTO cmo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jêh ri Brah Yêsu ncho duk plơ̆ sât ta ƀon Kapơnŭm ntŭk ƀon Păng gŭ. ");
INSERT INTO cmo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ta nây geh bu tung du huê bunuyh rven jŏng rven ti bêch ta nkŏ hăn ta Brah Yêsu. Păng say khân păng geh nau nsing, jêh ri lah ma bunuyh rven i nây: “Ơ oh, ăn may răm hŏm. Gâp lĕ yô̆ may, mâu hôm ôh kơp nau tih ta may.” ");
INSERT INTO cmo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ta nây geh phung nơm nti nau vay phung Israel aƀă lah êng ta nuih n'hâm khân păng nơm: “Mơm Păng ngơi kơt nây, Păng i nây mưch rmot Kôranh Brah ngăn hay!” ");
INSERT INTO cmo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Brah Yêsu lĕ say nau mân phung i nây, Păng lah: “Mơm dâng khân may geh nau mân djơh kơt nây? ");
INSERT INTO cmo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ăn khân may gĭt nau dja, lah Gâp lah ma bunuyh rven i nây: ‘Nau tih may lĕ Gâp yô̆ hơi’, mâu lah ‘May dâk brô̆ hŏm’, lah ndri moh nau lah i dơh rlau hă? ");
INSERT INTO cmo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Gâp ŭch ăn khân may gĭt say Gâp i Kon Bunuyh tă bơh Kôranh Brah dơi yô̆ nau tih bunuyh ta neh ntu dja.” Jêh ri Brah Yêsu uănh jât bunuyh rven i nây lah: “May dâk hŏm, ndjôt nkŏ may nây sât a jay may nơm ri.” ");
INSERT INTO cmo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jêh ri bunuyh rven i nây dâk ro, sât a jay păng nơm ri. ");
INSERT INTO cmo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Say kơt nây, phung ƀon lan ndrŏt hih rhŏl dadê, khân păng rnê Kôranh Brah, yorlah lĕ Păng ăn nau dơi kơt nây ma bunuyh ta neh ntu. ");
INSERT INTO cmo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jêh ri Brah Yêsu hăn bơh ntŭk nây, Păng say Mathay gŭ kŏp sŏ prăk ƀon lan ma ăn kôranh mât uănh. Brah Yêsu lah ma păng: “Hơi nô, hô̆ brô̆ tâng Gâp.” Păng dâk bơh nây, jêh ri tâng Brah Yêsu ro. ");
INSERT INTO cmo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ta nar nây Mathay jă Brah Yêsu sông sa ta jay păng nơm. Geh ŏk phung bunuyh kŏp sŏ prăk ƀon lan ma ăn kôranh mât uănh, nđâp ma phung bunuyh jan tih êng hăn gŭ sông sa ndrel Brah Yêsu, ndrel ma phung oh mon Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tât ma phung Pharisi say kơt nây, khân păng ôp phung oh mon Brah Yêsu: “Mơm dâng kôranh khân may gŭ sông sa ndrel bunuyh kŏp sŏ prăk ƀon lan, nđâp ma phung bunuyh jan tih êng kơt nây?” ");
INSERT INTO cmo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Brah Yêsu tăng kơt nây, jêh ri ôp khân păng: “Bunuyh geh săk jăn ueh mâu ŭch ôh ma kôranh dak si, bunuyh i geh nau ji dơm ŭch. ");
INSERT INTO cmo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ăn khân may vât ta trong lĕ nchih kơt nđa: ‘Gâp ŭch bunuyh blao yô̆ nđach, mâu ŭch ôh ma ndơ jan brah’. Gâp văch ta dja mâu ôh gay ma kuăl bunuyh sŏng, ŭch kuăl bunuyh tih, gay ma kơl khân păng.” ");
INSERT INTO cmo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nôk nây geh mpôl oh mon Yôhan-Ƀaptem hăn mâp Brah Yêsu, ôp Păng: “Hên, ndrel ma phung Pharisi geh nau vay ăt sông sa ŏk nar gay ma mbơh sơm, mơm dâng mpôl oh mon may mâu jan kơt nây?” ");
INSERT INTO cmo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Brah Yêsu ơh ma khân păng: “Nôk tâm nđăp ur sai, bu năch vay gŭ rngot ăt sông sa đŏng bơh? Mâu vay ôh. Gâp tâm ban ma bu klô nđăp ur sai. Tât di nar ri tay bu tâm nkhah Gâp đah mpôl oh mon Gâp, ri mơ khân păng ăt sông sa. ");
INSERT INTO cmo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Bu mâu vay ôh sŏ bok mhe ê hŏ pih mbôl ta ao lĕ sat. Lah jan kơt nây bok i sat ri lơ ma hô hêk rlau ơm ngăn, yor ma i bok mhe nây jêng rôt nôk jêh pih. ");
INSERT INTO cmo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kơt ndri đŏng, bu mâu vay ôh tê̆ ndrănh play yŭng yar ƀon mhe ta dŭng ntô ơm, lah jan kơt nây ndrănh play yŭng yar ƀon mhe jan ăn dŭng ntô i nây prek, ndrănh hŭk đŏng, jêh ri dŭng ntô i nây jêng sat đŏng, yorlah dŭng ntô ơm mâu hôm ôh toch. Bu tê̆ ndrănh play yŭng yar ƀon mhe ta dŭng ntô mhe, ndri ndơ bar ơ̆ nây hôm.” ");
INSERT INTO cmo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nôk Brah Yêsu hôm ngơi nau i nây, dô ma geh du huê kôranh nhih rƀŭn phung Israel hăn chon kômŏk bơh năp Brah Yêsu, lah ma Păng: “Kon bu ur gâp mhe khât ndơh nơh pơ. Dăn May hăn pah ti ta păng ơ, jêh ri păng dâk rêh ro.” ");
INSERT INTO cmo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Brah Yêsu dâk hăn ndrel păng, mpôl oh mon Brah Yêsu hăn đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Rŏ trong nây geh du huê bu ur ji rih lĕ jŏ 12 năm, păng lah êng ta săk păng nơm: “Lah geh pah ao Păng i nây, gâp bah ro.” Jêh ri păng tâng Brah Yêsu bơh kơi, pah ta chiăng ao Păng ri. ");
INSERT INTO cmo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Brah Yêsu n'gâl jât kơi, say bu ur i nây, jêh ri lah ma păng: “Ay răm hŏm ơ oh, nau ay nsing jan bah ay hơi.” Nau ji rih păng bah ta nây ro. ");
INSERT INTO cmo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jêh ri Brah Yêsu tât ta jay kôranh nhih rƀŭn nây, Păng say phung geh nau rngot ôh n'hôm ôh rlet grŭ gră yă yŏr ngăn ");
INSERT INTO cmo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Păng lah ma phung i nây: “Khân ay may du lôh a dih! Mâu khât ôh kon se bu ur dja, man ma hăk bêch dơm.” Dâng lĕ bu ta nây gơm mưch ma Brah Yêsu dadê. ");
INSERT INTO cmo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Tât lôh lĕ phiao phung i nây a dih, Brah Yêsu lăp ta trôm jay, nhŭp ti kon se bu ur i nây, jêh ri kon se i nây dâk ro. ");
INSERT INTO cmo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jêh ri nau i nây lư lam bri i nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nôk Brah Yêsu hăn bơh ntŭk nây, geh bar hê bunuyh cheh măt tâng bơh kơi Brah Yêsu, khân păng nter: “Ơ Kon Sau kađăch Đavid! Yô̆ nđach hên ƀă ơ!” ");
INSERT INTO cmo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tât Brah Yêsu lĕ lăp du mlŏm jay, bar hê bunuyh cheh măt nây hăn a Păng. Jêh ri Brah Yêsu ôp khân păng: “Ah khân may lĕ nsing ma Gâp đŏng, Gâp dơi jan trôm măt khân may ăn say ang?” Khân păng ơh: “Ơ, hên lĕ nsing, Kôranh.” ");
INSERT INTO cmo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jêh ri Brah Yêsu pah ta trôm măt khân păng ri lah: “Ăn geh ngăn, kơt nau khân may lĕ nsing.” ");
INSERT INTO cmo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jêh ri trôm măt khân păng say ang ngăn ro. Brah Yêsu buay dăng ngăn ma khân păng: “Lơi ôh ăn bu gĭt nau dja.” ");
INSERT INTO cmo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yơn ma bar hê khân păng i nây, hăn mbơh nkoch nau nây ma bu lam bri nây ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ndŭt sât bar hê khân păng nây, geh bu leo du huê bunuyh mlo brah djơh lăp hăn a Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tât Brah Yêsu lĕ mprơh brah djơh lĕ du lôh bơh bunuyh mlo i nây, bunuyh i nây blao ngơi ro. Lŏng phung ƀon lan i gŭ ta ri ndrŏt hih rhŏl lĕ nau ngăn, khân păng lah: “Ntơm bơh kăl e nơh mâu ôh prot say geh nau brah kơt nây ta bri Israel dja.” ");
INSERT INTO cmo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yơn ma phung Pharisi lah: “Dâng Păng dơi mprơh brah djơh nây, ach ma kôranh mpôl brah djơh ăn nau dơi ta Păng.” ");
INSERT INTO cmo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jêh ri Brah Yêsu hăn rŏ ƀon kuŏng ƀon jê̆, ntŭm nti bu ta nhih rƀŭn khân păng nơm, ndrel ma mbơh nkoch nau mhe mhan ueh ma nau Kôranh Brah mât uănh, nđâp ma jan bah dâng lĕ nau ji ăp ntil đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tât ma say phung ƀon lan, Brah Yêsu geh nau yô̆ nđach ma khân păng dŭt hô, yorlah khân păng rvê ta nuih n'hâm mâu hôm geh suan, tâm ban ma phung be biăp i mâu geh bunuyh mât uănh. ");
INSERT INTO cmo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jêh ri Brah Yêsu lah ma mpôl oh mon Păng: “Hơi oh mon, geh ŏk bunuyh ŭch iăt nau mhe mhan ueh, khân păng tâm ban ma ba lĕ dŭm i ŏk ngăn. Bunuyh mbơh nkoch nau mhe mhan ueh tâm ban ma bunuyh rek, tih ma bunuyh i nây đê̆ dơm. ");
INSERT INTO cmo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lah ndri dăn Kôranh Brah nơm i tơm ba nây njuăl bunuyh a êng jât, kơl rek ba dŭm i nây.” ");
INSERT INTO cmo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jêh ri Brah Yêsu kuăl 12 nuyh mpôl kôranh oh mon Păng, n'ho ma Păng ăn nau dơi ma khân păng, dơi mprơh brah djơh lôh bơh bunuyh, ndrel ma dơi jan bah dâng lĕ nau ji ăp ntil đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","12 nuyh mpôl kôranh oh mon nây, ta nây geh lor bu, Simôn i bu kuăl Pêtrôs đŏng, jêh ri geh oh păng Ŏndrê, geh Yakơ, ndrel ma oh păng Yôhan i kon Sêƀêđê, ");
INSERT INTO cmo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","geh Philip, geh Ƀartôlômê, geh Thômas, geh Mathay i bunuyh kŏp sŏ prăk ƀon lan ma ăn kôranh mât uănh, geh Yakơ i kon Alphai, geh Thađê, ");
INSERT INTO cmo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","geh Simôn i bunuyh phung Kanaan, ndrel ma geh Yuđas-Isakariyôt bunuyh i leo bu hăn nhŭp Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jêh ri Brah Yêsu đă 12 nuyh mpôl kôranh oh mon i nây hăn ta ƀon êng êng, n'ho ma ntĭnh ma khân păng: “Khân may lơi hăn ôh ta phung i mâu di phung Israel, lơi ôh lăp ta ƀon bri Samari, ");
INSERT INTO cmo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","yơn ma ăn khân may hăn ta phung Israel dơm, khân păng tâm ban ma phung be biăp lĕ hiơt. ");
INSERT INTO cmo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ăn khân may mbơh nkoch: ‘Nau Kôranh Brah mât uănh lĕ bơi tât’. ");
INSERT INTO cmo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ăn khân may jan bah bunuyh ji kuet, bunuyh khât jan ăn dâk rêh, bunuyh phŭng sa jan ăn bah ăn kloh, ndrel ma mprơh brah djơh ăn du lôh bơh bunuyh. Lơi ôh sŏ khlay bơh bu, yorlah nau dơi khân may nơh geh dơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mâu ăn ôh ndjôt prăk, bol lah đê̆ kađôi ta dŭng khân may. ");
INSERT INTO cmo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Lơi cheng dŭng dôl khân may brô̆ ƀon êng êng, lơi ôh ndjôt leo kho ao ntô jot a êng jât dơn i geh nsoh ta săk ri hŏ, lơi ndjôt mŏng jra. Yorlah di ma bunuyh i jan kar ma Kôranh Brah sŏ dơn ndơ ŭch ta nau rêh păng tă bơh bunuyh i păng kơl nây. ");
INSERT INTO cmo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nôk khân may lăp ta ƀon kuŏng, mâu lah ƀon jê̆, ăn khân may joi bunuyh i di ma khân may gŭ ndrel, jêh ri gŭ ta jay păng n'ho ma tât nar khân may lôh bơh ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nôk khân may lăp ta jay bunuyh i nây, ăn khân may lah: ‘Ăn geh nau đăp mpăn ma khân ay may’. ");
INSERT INTO cmo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Lah ta jay i nây di sŏ dơn nau đăp mpăn i nây, Kôranh Brah mra ăn kơt nây ngăn ro. Lah mâu di sŏ dơn, Kôranh Brah mâu ăn ôh, yơn ma khân may hôm geh nau đăp mpăn. ");
INSERT INTO cmo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Lah bu mâu ôh rom khân may, mâu iăt ôh nau khân may, nôk khân may lôh bơh ƀon bơh jay nây, ăn rtôh neh môi bơh jŏng khân may nơm, gay ma nhhơ lah bunuyh i nây Kôranh Brah tê̆ dôih. ");
INSERT INTO cmo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gâp lah n'hêl nanê̆ ngăn ma khân may, bunuyh ta bri ƀon Sôđŭm ƀon Kômôra, i jan tih dŭt hô kăl e nơh, ndri dâng Kôranh Brah de lơh hêng khân păng ma ŭnh bơh kalơ trôk, khân păng i nây hôm e geh dôih thơl ma đah bunuyh ta ƀon i nây, ta nar Kôranh Brah phat dôih lam neh ntu.” ");
INSERT INTO cmo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Gâp đă khân may hăn ta ƀon phung Israel tâm ban ma đă be biăp gŭ ta nklang phung so bri. Lah ndri ăn khân may blao njrăng tâm ban ma bêh, mleh tâm ban ma plŭk jêng siŭm du ntil i mâu jan tih. ");
INSERT INTO cmo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ăn blao njrăng ma bunuyh, yorlah bu mra nhŭp njŭn khân may ăn ma mpôl kôranh jan kar phung Israel, jêh ri bu mra rpăt khân may ma mŏng rse ta trôm nhih rƀŭn khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bu mra njŭn khân may ăn ma kôranh kuŏng, ndrel ma njŭn khân may ma kađăch, gay ma phat dôih khân may ach ma tâng Gâp. Jêh ri khân may dơi nkoch nau nsing ma Gâp ăn ma khân păng, ăn ma phung i mâu di phung Israel đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nôk bu nhŭp njŭn khân may, lơi ôh khân may rvê nau mbơh ngơi ma bu, yorlah Kôranh Brah sơm ăn nau mbơh ngơi ma khân may ta nôk nây. ");
INSERT INTO cmo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mâu di khân may nơm ôh mbơh ngơi, Brah Huêng Ueh i huêng Kôranh Brah Bơ̆ khân may nơm sơm ngơi ăn ma khân may. ");
INSERT INTO cmo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Oh ma nô, bơ̆ ma kon mra tâm rlăm nhŭp njŭn ăn bu nkhât, ndrel ma i kon kon leo băl tâm rdâng đah mê̆ bơ̆, n'ho ma njŭn ăn bu nkhât lơi đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yor ma khân may nsing ma Gâp, ndri dâng ŏk bunuyh mra biănh ma khân may. Yơn ma bu moh i dơi ăt n'ho ma tât lôch, Kôranh Brah mra rklaih păng i nây. ");
INSERT INTO cmo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lah bu jan jêr khân may ta du ƀon, ăn khân may nchuăt du ta ƀon êng jât. Gâp lah n'hêl nanê̆ ngăn ma khân may, khân may hăn ê hŏ ôh lam ƀon dâng lĕ ta bri Israel, Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ lĕ tât.” ");
INSERT INTO cmo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mâu geh ôh phung nti gĭt rlau ma nơm nti, mâu geh ôh dâk kuŏng rlau ma kôranh păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lah phung nti lĕ blao tâm ban ma nơm nti khân păng, lah dâk lĕ tâm ban ma kôranh păng nơm, lah ndri lĕ găp hơyh. Lah bunuyh tơm jay bu kuăl: ‘Ƀêlsêƀul’, lah ndri dâng lĕ bunuyh i gŭ ta jay păng nây, rlau ma nây jât djơh bu kuăl khân păng.” ");
INSERT INTO cmo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Lơi ôh klach phung i jan jêr nây, yorlah geh du nar jât năp tay Kôranh Brah mra ăn bu say dâng lĕ ndơ i bunuyh hôm mpôn. Kôranh Brah ăn bu gĭt dadê đŏng, dâng lĕ ndơ i bunuyh mâu ŭch ăn bu gĭt. ");
INSERT INTO cmo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lah ndri moh ndơ Gâp lah khân may ta ntŭk ngo, ăn khân may mbơh nkoch hŏm ta ntŭk ang. Moh ndơ Gâp ngơi suih ta tôr khân may, ăn mbơh nkoch hŏm ta kalơ chor jay gay ma ŏk bunuyh tăng. ");
INSERT INTO cmo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Lơi klach ôh ma nơm dơi nkhât rnglay săk dơm, yơn ma mâu dơi ôh nkhât huêng, ăn khân may klach Kôranh Brah hŏ, yorlah Păng dơi ăn huêng, ndrel ma rnglay săk lơh ndjơh ta ndrung ŭnh. ");
INSERT INTO cmo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bu vay tăch bar mlŏm siŭm rleo khlay du mlŏm kăk jê̆, yơn ma bol lah thok kơt nây, lah Kôranh Brah Bơ̆ khân may mâu ăn, mâu geh ôh du mlŏm siŭm rleo tŭp ta neh. ");
INSERT INTO cmo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Bol lah dâng lĕ sŏk ta bôk khân may nơm, Kôranh Brah lĕ jêh kơp dâng lĕ đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kơt ndri lơi klach ôh, yorlah Kôranh Brah kơp khân may khlay ngăn rlau ma siŭm rleo du phung jât.” ");
INSERT INTO cmo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Bu moh i mbơh ma bu lah păng tâng Gâp, Gâp mra mbơh păng i nây jêng oh mon Gâp ta bơh năp măt Bơ̆ Gâp ta kalơ trôk. ");
INSERT INTO cmo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yơn ma bu moh i rlăch ma bu lah mâu tâng Gâp, Gâp mâu đŏng mbơh păng i nây jêng oh mon Gâp ta bơh năp măt Bơ̆ Gâp ta kalơ trôk.” ");
INSERT INTO cmo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Lơi mân ôh Gâp văch ta neh ntu dja leo nau đăp mpăn. Gâp văch ta dja tâm ban ma ndjôt đao, leo nau tâm rdâng. ");
INSERT INTO cmo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Gâp văch ăn: ‘Kon bu klô tâm nkhah đah bơ̆ păng, Kon bu ur tâm nkhah đah mê̆ păng, Măn ăn tâm nkhah đah mê̆ po păng nơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bunuyh gŭ ndrel du jay, jêng tâm rlăng ndrăng khân păng nơm’.” ");
INSERT INTO cmo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Bu moh rŏng ma mê̆ bơ̆ păng nơm ŏk rlau ma rŏng Gâp, păng i nây mâu ôh di jêng oh mon Gâp. Bu moh rŏng ma kon bu ur kon bu klô păng nơm ŏk rlau ma rŏng Gâp, păng i nây mâu đŏng di jêng oh mon Gâp. ");
INSERT INTO cmo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bu moh mâu tui si tâm rkăng păng nơm brô̆ tâng Gâp, jêng geh nau khlay mâu iăt dâng lĕ nau Kôranh Brah đă, bol lah tât khât săk kađôi, păng i nây mâu ôh di jêng oh mon Gâp. ");
INSERT INTO cmo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jêh ri bu moh prăp rvan ma nau rêh săk păng nơm, păng tay khât n'ho ro, yơn ma bu moh khât ach ma tâng Gâp, păng tay rêh n'ho ro.” ");
INSERT INTO cmo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Bu moh rom khân may, tâm ban ma păng rom Gâp, bu moh rom Gâp tâm ban ma păng rom Kôranh Brah tơm njuăl Gâp đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bu moh rom du huê bunuyh ntơyh nau ngơi Kôranh Brah, ach ma păng jêng bunuyh ntơyh nau ngơi Kôranh Brah, bunuyh i nây geh ndơ nkhôm tâm ban ma bunuyh ntơyh nau ngơi Kôranh Brah đŏng. Bu moh rom du huê bunuyh sŏng, ach ma păng jêng bunuyh sŏng, bunuyh i nây geh ndơ nkhôm tâm ban ma bunuyh sŏng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Bu moh ăn dak nđik du keo ma du huê bu jê̆, ach ma bu jê̆ i nây jêng oh mon Gâp, Gâp lah n'hêl nanê̆ ngăn ma khân may, nau nkhôm ma bunuyh i nây mâu roh ôh.” ");
INSERT INTO cmo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jêh Brah Yêsu lah nau i nây ăn ma 12 nuyh mpôl kôranh oh mon Păng, jêh ri Păng lôh bơh ntŭk nây, gay ma hăn ntŭm nti bu rŏ ƀon êng êng. ");
INSERT INTO cmo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nôk nây Yôhan-Ƀaptem bu krŭng ta ndrung. Tât păng tăng lư bu mbơh nkoch dâng lĕ ndơ Brah Krist jan, păng đă mpôl oh mon păng hăn ôp Brah Yêsu kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Nôk kăl e nơh Kôranh Brah lĕ ton ma bunuyh ntơyh nau ngơi Kôranh Brah lah: Geh Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl jŭr văch tă bơh kalơ trôk ntŭk Kôranh Brah nơm. May dja Brah Krist i nây bơh, mâu lah ăn hên hôm kŏp du huê a êng jât?” ");
INSERT INTO cmo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Brah Yêsu ơh ma khân păng: “Khân may mbơh nkoch ma păng ri, dâng lĕ ndơ khân may tăng khân may say Gâp jan. ");
INSERT INTO cmo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bunuyh cheh măt uănh say, bunuyh kuet rven blao brô̆, bunuyh phŭng sa bah, kloh, bunuyh tâk tôr iăt tăng, bunuyh khât dâk rêh, nđâp ma bunuyh o ach tăng nau mhe mhan ueh. ");
INSERT INTO cmo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ueh maak ngăn ma bunuyh mâu mƀăr nau păng nsing ma Gâp, yor ma ndơ Gâp jan êng ngăn bơh nau mân păng ŭch!” ");
INSERT INTO cmo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ndŭt sât phung oh mon Yôhan-Ƀaptem, Brah Yêsu ntơm ngơi ma Yôhan-Ƀaptem ăn ma phung ƀon lan: “Moh bunuyh uănh khân ay may hăn ta bri rdah? Hăn uănh bunuyh i ngơi dah ma bunuyh êng êng ŭch tâm ban ma ja mpăt rngônh dah sial ma khôm bơh? Păng mâu di ôh. ");
INSERT INTO cmo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Moh bunuyh khân ay may hăn uănh? Uănh bunuyh nsoh bok ueh ao ueh bơh? Mâu ôh. Bunuyh nsoh bok ueh ao ueh, mpôl nây gŭ ta jay kađăch gŭ, mâu ôh gŭ ta bri rdah. ");
INSERT INTO cmo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lah ndri bu moh bunuyh khân ay may hăn uănh? Uănh bunuyh ntơyh nau ngơi Kôranh Brah bơh? Di ngăn. Yơn ma păng i nây rlau ma bunuyh ntơyh nau ngơi Kôranh Brah jât. ");
INSERT INTO cmo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yorlah ta Nau Kôranh Brah Ngơi lĕ geh nchih lah ma păng: ‘Kôranh Brah lah: ‘Lŏng Gâp njuăl bunuyh hăn lor May Gay ma ndrăp nuih n'hâm bunuyh ăn ma May tâm ban ma kuayh trong ăn ma May’’ Yôhan-Ƀaptem i nây i bunuyh hăn lor ta nau i nây. ");
INSERT INTO cmo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Khân ay may iăt nau Gâp n'hêl nanê̆ ngăn, dâng lĕ bunuyh i deh tă bơh bu ur ta neh ntu dja, mâu geh ôh du huê jêng kuŏng rlau Yôhan-Ƀaptem, yơn lah ta mpôl bunuyh i Kôranh Brah mât uănh, bunuyh i jê̆ ta nâm bu, bunuyh i nây jêng kuŏng rlau Yôhan-Ƀaptem ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ntơm bơh nar Yôhan-Ƀaptem jan ƀăptem tât ma aƀaơ dja, geh bunuyh nsrôyh mbơh nkoch ma nau Kôranh Brah mât uănh, jêh ri bunuyh i nsrôyh ngăn ri mơ geh lăp. ");
INSERT INTO cmo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Dâng lĕ bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, n'ho ma tât Yôhan-Ƀaptem, lĕ geh nkoch ma nau Kôranh Brah mât uănh, ndrel ma ta nau vay phung bân lĕ geh mbơh nkoch nau i nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ta nau vay bân lĕ geh mbơh nkoch jêh ma du huê bunuyh ntơyh nau ngơi Kôranh Brah i tâm ban ma Êliya păng mra văch, lah khân ay may ŭch iăt nau Gâp, Yôhan-Ƀaptem jêng bunuyh i nây. ");
INSERT INTO cmo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bu moh tăng nau Gâp ngơi dja, ăn păng mân êng ta săk! ");
INSERT INTO cmo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Lah ndri mơm Gâp tâm rđâl ma bunuyh aƀaơ dja? Khân păng jêng tâm ban ma kon se gŭ pâl ta jŏng gung ƀon, geh aƀă tâm nter ndrăng khân păng: ");
INSERT INTO cmo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Hên lĕ ôh n'hôm goh gŏr, tih ma khân ay may mâu pâl răm maak (rŏm), Jêh ri hên lĕ nđor ntŏng dŏng khât, tih ma khân ay may mâu ŭch nhŭm nđor đŏng’. ");
INSERT INTO cmo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ndri Yôhan-Ƀaptem păng ăt sông sa, ăt nhêt ndrănh, tih ma bu lah păng bunuyh brah djơh lăp. ");
INSERT INTO cmo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lŏng Gâp dja i Kon Bunuyh tă bơh Kôranh Brah geh nhêt geh sông, mâu ăt sông sa, bu lah Gâp: ‘Bunuyh hay nhêt hay sông, jan mât jăng đah bunuyh sŏ prăk ƀon lan gay ma ăn kôranh mât uănh, jêh ri gŭ ndrel bunuyh tih a êng jât’. Yơn ma bunuyh i tâng nau Kôranh Brah, nhhơ nau Kôranh Brah i nây jêng di ueh ngăn ta nau rêh păng.” ");
INSERT INTO cmo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jêh ri Brah Yêsu nduih ƀon i Păng lĕ jan nau khlay ŏk rlau bu, yor ma khân păng mâu ŭch rgâl nuih n'hâm djơh, Păng lah kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Rêh rnhăl ngăn ma bunuyh gŭ ta ƀon Khôrasin, ndrel ma ƀon Ƀêtsaida, yorlah khân păng lĕ say dâng lĕ ndơ ueh ndơ khlay Gâp jan, tih ma mâu ôh rgâl lơi nuih n'hâm djơh. Bunuyh ta ƀon Tirus, ndrel ma ta ƀon Siđôn jêng phung mâu gĭt năl Kôranh Brah, lah khân păng say nau khlay i nây, khân păng rgâl lơi nuih n'hâm djơh ro, jêh ri gay ma nhhơ nau khân păng lĕ rgâl lơi nuih n'hâm djơh, khân păng nsoh n'gut ƀao chiăt gŭ ta ŭnh buh. ");
INSERT INTO cmo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lah ndri Gâp mbơh nkoch ma khân ay may, ta nar Kôranh Brah phat dôih lam neh ntu tay, bunuyh ta ƀon Tirus, ndrel ma ta ƀon Siđôn, khân păng geh dôih thơl ta nâm bunuyh gŭ ta ƀon Khôrasin, ƀon Ƀêtsaida. ");
INSERT INTO cmo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bunuyh gŭ ta ƀon Kapơnŭm i ƀon Gâp gŭ jŏ khay, ndrel ma Gâp lĕ nti lĕ jan ndơ nau khlay Lơi ôh mân lah săk khân ay may nơm lĕ jêng bunuyh ueh hao ta ƀon ueh kalơ. Mâu ôh, khân ay may tay tŭp ta ntŭk rêh rnhăl ta ndrung ŭnh ro. Yorlah nau khlay i lĕ geh jêh ta nklang khân ay may, lah ƀon Sôđŭm i jan tih dŭt hô kăl e nơh, ndri dâng Kôranh Brah de lơh hêng khân păng ma ŭnh bơh kalơ trôk, khân păng say kơt nây, bunuyh ta ƀon nây mâu ôh geh roh, hôm tât ta nar aƀaơ dja. ");
INSERT INTO cmo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ndri dâng Gâp lah ma khân ay may, ta nar Kôranh Brah phat dôih dâng lĕ bunuyh ta neh ntu tay, bunuyh tă bơh bri ƀon Sôđŭm geh dôih thơl dơm ta nâm khân ay may.” ");
INSERT INTO cmo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jêh ri Brah Yêsu lah kơt nđa: “Hơi Bơ̆, i kôranh ma trôk, ndrel ma neh ntu, Gâp rnê May hô ngăn, yorlah May lĕ nhhơ nau May ntơm mât uănh bunuyh dja ăn ma bunuyh rluk mâl mâu vât tâm ban ma kon se, jêh ri pôn ndŏp lơi ndơ i nây ma bunuyh i kơp êng săk khân păng nơm jêng bunuyh gĭt bunuyh blao. ");
INSERT INTO cmo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hơi Bơ̆, nuih n'hâm May ŭch kơt nđa ro. ");
INSERT INTO cmo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dâng lĕ ntil ndơ, lĕ Bơ̆ jao ma Gâp dadê jêh. Mâu geh ôh bunuyh gĭt năl Gâp i Kon May, geh May i Bơ̆ Gâp nơm dơm gĭt năl. Mâu geh ôh bunuyh gĭt năl May i Bơ̆ Gâp, geh Gâp i kon May dơm gĭt năl, ndrel ma dâng lĕ bunuyh i Gâp ŭch ăn gĭt năl May, du ri dơm.” ");
INSERT INTO cmo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Bu moh geh nau lêt rgănh, ndrel ma anh jŏk, văch hŏm a Gâp, Gâp ăn khân ay may rlu. ");
INSERT INTO cmo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Sŏ hŏm ndơ mbăk Gâp, jêh ri nti tă bơh Gâp, nuih n'hâm khân ay may nđik rngêt ngăn ro, yorlah nuih n'hâm Gâp mleh, ndrel ma dêh rhêt. ");
INSERT INTO cmo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ndơ mbăk Gâp n'gơch, ndrel ma ndơ Gâp ăn khân ay may anh n'gơch đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Geh du nar Saƀăt i nar rlu phung Israel Brah Yêsu, ndrel ma phung oh mon Păng hăn glăt rŏ mir, phung oh mon ji ngot, khân păng roih Ba Prăng sa. ");
INSERT INTO cmo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Phung Pharisi say kơt nây, khân păng hăn lah Brah Yêsu: “Lŏng May uănh, moh si kô̆ mpôl oh mon May jan kar ta nar Saƀăt dja mêh? Bol lah khân păng roih đê̆ đê̆ kơt nây, hôm e kơp tih đah nau vay nar rlu phung bân đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Brah Yêsu lah ma phung Pharisi: “Lah ndri khân may lĕ chuêl ƀah, nau khân may vay rŏ ta Nau Kôranh Brah Ngơi? Nôk Đavid ê hŏ jêng kađăch, păng, ndrel ma bunuyh gŭ ndrel păng ji ngot, ");
INSERT INTO cmo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","jêh ri păng lăp ta trôm ntŭk chun Kôranh Brah i jan ma bok, sŏ sa nŭmpăng i bu tê̆ nhhơr ăn Kôranh Brah nây, n'ho ma pă bunuyh i gŭ ndrel păng nây sa đŏng. Bu mâu lah păng đŏng bol lah tâng ma nau vay geh mpôl jan brah dơm dơi sa nŭmpăng i nây. ");
INSERT INTO cmo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jêh ri khân may lĕ geh uănh đŏng ta samƀŭt Nau Vay bân lah phung bunuyh jan brah gŭ jan kar ta nhih jan brah, khân păng hôm jan kar ta nar Saƀăt, nau i nây mâu tâm di ma jan ta nar Saƀăt, yơn ma mâu ôh geh nau tih. ");
INSERT INTO cmo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ndri dâng Gâp lah ma khân may, ta dja geh du huê Gâp kuŏng rlau ma nhih jan brah i nây jât. ");
INSERT INTO cmo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Lah khân may lĕ vât ta nau lah i dja: ‘Gâp mâu ôh ŭch ma ndơ jan brah khân ay may, Gâp ŭch ma khân ay may geh nau yô̆ ma bu’, khân may mâu ôh nduih ma phung mâu geh nau tih. ");
INSERT INTO cmo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gâp i Kon Bunuyh tă bơh Kôranh Brah, Gâp jêng kôranh moh ndơ i dơi ăn bu jan, mâu lah mâu dơi ăn bu jan ta nar Saƀăt i nar rlu.” ");
INSERT INTO cmo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jêh ri Brah Yêsu lôh bơh ntŭk nây, hăn lăp ta nhih rƀŭn khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ta nhih rƀŭn nây geh du huê bunuyh siăr ti. Phung Pharisi ôp Brah Yêsu: “Tâng ma nau vay phung bân, ah di đŏng bơh, jan bah nau ji ta nar Saƀăt i nar gŭ rlu buay jan kar?” Khân păng ôp kơt nây, gay ma joi nau ma ntôn Brah Yêsu dơm. ");
INSERT INTO cmo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Brah Yêsu ơh ma khân păng: “Ta phung khân may, lah geh du huê geh du mlŏm be biăp păng tŭp ta ntu ta nar Saƀăt, ah păng mâu sŏ be biăp i nây lôh a kalơ dja? ");
INSERT INTO cmo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yơn ma bunuyh khlay rlau be biăp, lah ndri dơi jan ndơ ueh ta nar Saƀăt mâu ôh tih ma nau vay.” ");
INSERT INTO cmo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jêh ri Brah Yêsu lah ma bunuyh siăr ti nây: “Yơr hŏm ti may nây.” Păng yơr ro, jêh ri ti păng bah kơt ti du ding đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yơn ma phung Pharisi lôh a dih tâm nchră nau gay ma joi nau mơm dâng geh nkhât Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nôk Brah Yêsu gĭt nau i nây, jêh ri Păng lôh bơh ntŭk nây, geh ŏk phung ƀon lan tâng Păng đŏng, dâng lĕ nau ji khân păng, Păng jan bah dadê. ");
INSERT INTO cmo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Brah Yêsu buay khân păng, mâu ôh ăn khân păng mbơh nkoch ăn bu gĭt năl Păng. ");
INSERT INTO cmo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Păng jan kơt nây gay ma tâm di đah nau bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh Êsai lĕ nchih kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Kôranh Brah lah: ‘Bunuyh dja, bunuyh sơm kơl jan kar ma Gâp, lĕ Gâp kơih Păng, Gâp rŏng Păng hô ngăn, di nuih n'hâm Gâp klơ̆ ngăn. Gâp ăn Brah Huêng Ueh Gâp gŭ ta Păng Gay ma phat dôih phung i mâu di phung Israel ma nau sŏng. ");
INSERT INTO cmo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Păng mâu geh tâm rlăch đah bu, mâu geh ôh nter, Mâu geh đŏng bunuyh tăng bŏr Păng rŏ trong. ");
INSERT INTO cmo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Păng mâu ôh rtăch lơi ja lĕ deh, Păng mâu khôm lơi đŏng ŭnh sagêng lĕ bơi ma nhhŏt, geh nau yô̆ ma bunuyh i geh nau nsing đê̆, N'ho ma mâu ôh bah jan kar tât ma dơi đah dâng lĕ nau djơh. ");
INSERT INTO cmo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jêh ri dâng lĕ phung i mâu di phung Israel, bu rnơm ma Păng ngăn’’. ");
INSERT INTO cmo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jêh ri geh bu leo du huê bunuyh bu klô brah djơh lơh hăn a Brah Yêsu, bunuyh i nây mlo, ndrel ma cheh măt. Brah Yêsu jan ăn păng blao ngơi măt say ang đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Dâng lĕ bunuyh ta nây ndrŏt hih rhŏl ngăn, khân păng tâm lah: “Gĭt Păng i nây ƀah i kon sau kađăch Đavid i nơm rklaih Kôranh Brah de lĕ ton hăn ta dja?” ");
INSERT INTO cmo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Yơn ma tăng bu ngơi kơt nđay, phung Pharisi lah: “Ach ma Ƀêlsêƀul i kôranh mpôl brah djơh gŭ ta săk Păng dơm, dâng Păng dơi mprơh brah djơh kơt nây.” ");
INSERT INTO cmo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Brah Yêsu lĕ gĭt jêh nau mân khân păng, jêh ri Păng lah: “Dâng lĕ bri i geh nau tâm lŏk tâm janh chah chrai băl, bri i nây roh hêng ro, dâng lĕ ƀon dâng lĕ rnăk vâl i geh nau tâm lŏk tâm janh ndrăng nơm, ƀon rnăk i nây roh hêng mâu hôm geh đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Lah Gâp ntrŭt brah djơh tă bơh nau dơi Satăng i kôranh mpôl brah djơh, brah djơh geh nau tâm rdâng tâm janh chah chrai băl, lah ndri mơm dâng hôm geh Satăng mât uănh? ");
INSERT INTO cmo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Oh mon khân may ntrŭt brah djơh đŏng. Lah Gâp ntrŭt brah djơh yor ma nau dơi Satăng ngăn, khân may ơm mâu lah, lah khân păng ntrŭt brah djơh yor ma nau dơi Satăng? Lah ndri oh mon khân may nơm i nây mra tê̆ dôih khân may ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yơn ma lah nau dơi Gâp ntrŭt brah djơh tă bơh Brah Huêng Ueh Kôranh Brah, lah ndri nau Kôranh Brah mât uănh ma khân may lĕ tât jêh. ");
INSERT INTO cmo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mơm dâng bunuyh dơi hăn ta jay bunuyh dăng, jêh ri ntŭng drăp ndơ păng? Ăn nhŭp kât lor păng i nây ƀŏt, ri mơ dơi pit sŏ drăp ndơ dâng lĕ ta jay păng. ");
INSERT INTO cmo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Bu moh mâu gŭ mpeh bơh Gâp, păng i nây jêng tâm rlăng đah Gâp. Bu moh i mâu rgum ndrel Gâp, păng i nây jêng bunuyh tâm nkhah nhhing nhhang. ");
INSERT INTO cmo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kơt ndri dâng Gâp mbơh ăn ma khân ay may, dâng lĕ ndơ bunuyh jan tih, ndrel ma lah mưch rmot Kôranh Brah, Kôranh Brah hôm yô̆ mâu ôh kơp nau tih jât. Tih ma bu moh i lah mưch rmot Brah Huêng Ueh i ri, mâu ôh Kôranh Brah yô̆ ma păng. ");
INSERT INTO cmo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bu moh păng i ngơi tâm rdâng đah Gâp i bunuyh tă bơh Kôranh Brah, Kôranh Brah hôm yô̆ mâu ôh kơp nau tih păng, yơn ma bu moh păng i ngơi tâm rdâng đah Brah Huêng Ueh i kloh ueh, Kôranh Brah hôm kơp nau tih păng nanao, bol lah ta rnôk aƀaơ dja, mâu lah ta rnôk Kôranh Brah mât uănh dâng lĕ bunuyh ngăn tay kađôi.” ");
INSERT INTO cmo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Lah tơm ueh, play păng ueh đŏng, tih ma lah tơm mâu ueh, play păng mâu ueh đŏng, yorlah dâng bu gĭt năl tơm si tă bơh play păng. ");
INSERT INTO cmo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yê! Mpôl bunuyh djơh bunuyh janh tâm ban ma bêh ku! Mơm khân may blao ngơi nau ueh, lah săk khân may jêng bunuyh djơh? Yorlah bunuyh dâng lôh ngơi, tă bơh nau mân ŏk ngăn ta nuih n'hâm păng. ");
INSERT INTO cmo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bunuyh ueh ngơi ndơ ueh, yorlah ta săk păng ri geh nau mân ueh nâng, bunuyh djơh ngơi ndơ djơh, yorlah ta săk păng ri geh nau mân djơh nâng. ");
INSERT INTO cmo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Gâp lah ma khân may, ta nar Kôranh Brah phat dôih dâng lĕ bunuyh ta neh ntu tay, Păng phat dôih bunuyh ma dâng lĕ nau i bunuyh ngơi lă ngơi lêng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Păng lĕ kơp khân may sŏng mâu geh dôih, yorlah lôh nau khân may mbơh ngơi, mâu lah Păng kơp khân may geh dôih, yor lôh nau khân may mbơh ngơi đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nôk nây geh aƀă phung nơm nti nau vay phung Israel, ndrel ma phung Pharisi lah ma Brah Yêsu: “Ơ Nơm Nti, May jan du nau mbên ăn hên say ưh, gay ma nhhơ nau dơi May tă bơh Kôranh Brah.” ");
INSERT INTO cmo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yơn ma Brah Yêsu ơh ma khân păng: “Bunuyh ta rnôk aƀaơ dja hô ngăn djơh mhĭk, mâu ŭch jan tâng nau Kôranh Brah ŭch, ŭch say ma nau mbên dơm, yơn ma Kôranh Brah mâu ôh ăn nau mbên êng jât. Păng ăn du nau mbên tâm ban ma nau mbên Yônais i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh dơm. ");
INSERT INTO cmo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yorlah Yônais gŭ ta trôm ndŭl ka kuŏng pe năng pe nar, kơt nđay đŏng Gâp i Kon Bunuyh tă bơh Kôranh Brah tay gŭ ta trôm neh pe năng pe nar đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ta nar Kôranh Brah phat dôih dâng lĕ bunuyh ta neh ntu dja, bunuyh ta ƀon Ninivê mra tê̆ dôih bunuyh ta rnôk aƀaơ dja đŏng, yorlah rnôk kăl e nơh, jêh khân păng tăng nau Yônais mbơh, khân păng rgâl lơi nuih n'hâm djơh ro, khân păng nduih tôr lĕ lăn nau khân păng jan tih nơh. Yơn ma ta dja aƀaơ dja geh đŏng du huê bunuyh kuŏng rlau ma Yônais nây jât, tih ma khân may mâu ôh rgâl nuih n'hâm djơh. ");
INSERT INTO cmo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ta nar Kôranh Brah phat dôih dâng lĕ bunuyh ta neh ntu, geh kađăch bu ur rnha păng Sêƀa, păng mra tê̆ dôih ma bunuyh rnôk aƀaơ dja. Kăl e nơh păng kađăch ta bri êng ngai mpeh bơh dŏng bri Israel, bol lah păng gŭ ngai dŭt bri dŭt neh kađôi, păng hăn ta bri Israel gay ma iăt nau mân gĭt blao kađăch Salômôn ta bri dja. Yơn ma nar dja ta ntŭk dja geh du huê bunuyh nau ngơi Păng khlay rlau nau ngơi kađăch Salômôn, tih ma khân may mâu ôh ŭch iăt Păng.” ");
INSERT INTO cmo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Lah brah djơh lôh bơh du huê bunuyh, jêh ri păng brô̆ rŏ bri rdah, păng joi ntŭk ma gŭ mâu geh ôh. ");
INSERT INTO cmo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jêh ri păng mra lah êng kơt nđa: ‘Gâp plơ̆ gŭ ta jay ơm gâp, ntŭk gâp mhe lôh nơh ƀŏt’. Tât păng plơ̆ ta nây, say jay i nây lĕ nsoyh dadê mpêh ueh, ndrăp djahep, ");
INSERT INTO cmo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","jêh ri păng hăn jă pơh brah djơh a êng tay, brah djơh i nây janh janh rlau păng ngăn, hăn lăp gŭ ndrel ta nây đŏng, jan ăn bunuyh i nây geh nau jêr djơh rlau ơm nơh jât. Kơt ndri bunuyh djơh ta rnôk dja geh tâm ban kơt nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nôk Brah Yêsu hôm gŭ ngơi đah phung ƀon lan nây, geh mê̆ Păng ndrel mpôl oh bu klô Păng gŭ bơh dih ri, ŭch ngơi đah Păng. ");
INSERT INTO cmo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Geh du huê bunuyh hăn mbơh ma Păng: “Hơi Nơm Nti, mê̆ May, ndrel ma phung oh bu klô May gŭ bơh dih ri, khân păng ŭch ngơi đah May.” ");
INSERT INTO cmo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yơn ma Brah Yêsu ơh ma păng: “Bu moh mê̆ Gâp? Bu moh phung oh nô Gâp?” ");
INSERT INTO cmo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jêh ri Brah Yêsu nchŏng ti jât phung oh mon Păng, Păng lah: “Khân păng dja mê̆ Gâp, ndrel ma phung oh nô Gâp heh! ");
INSERT INTO cmo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yorlah bu moh i iăt tâng nau ŭch Bơ̆ Gâp gŭ ta kalơ trôk, păng i nây oh nô rôh klô Gâp, ndrel ma mê̆ Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nar nây đŏng Brah Yêsu lôh bơh jay, hăn gŭ rgơp ta meng dak nglao kuŏng Galilê. ");
INSERT INTO cmo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ta nây geh ŏk bunuyh hăn văch a Păng, ndri Păng hao gŭ rgơp ta kalơ du mlŏm duk, jêh ri nti bơh kalơ duk ri, phung ƀon lan gŭ rŏ meng dak. ");
INSERT INTO cmo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jêh ri Brah Yêsu nti lah ăn ma khân păng ŏk ma nau ngơi ntât, Păng lah kơt nđa: “Iăt hŏ! Geh du huê bunuyh bu klô hăn sui găr ntil ta mir. ");
INSERT INTO cmo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nôk păng sui nây aƀă tŭp rŏ trong, jêh ri siŭm chok lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Găr aƀă tŭp ta neh klêr, găr i nây gơnh hon pru yorlah neh n'hơ. ");
INSERT INTO cmo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Yơn ma tât dôh nar tơm i nây ndro ƀrŭng, yor ma reh păng hon mâu jru. ");
INSERT INTO cmo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Găr aƀă jât tŭp ta neh lok, jêh ri lok hon tŏl lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Lŏng găr i aƀă jât tŭp ta neh ueh, păng hon pru ueh jêng ngăn, n'ho ma tât geh play du găr geh 100, aƀă du găr geh 60, aƀă jât du găr geh 30. ");
INSERT INTO cmo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bu moh tăng nau Gâp ngơi dja, ăn păng nklŏn êng ta săk!” ");
INSERT INTO cmo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jêh ri phung oh mon hăn ôp Brah Yêsu: “Mơm dâng May ngơi đah phung ƀon lan ngơi ntât kơt nây?” ");
INSERT INTO cmo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Brah Yêsu ơh ma khân păng: “A lor nơh nau khlay Kôranh Brah mât uănh bunuyh hôm ndŏp mpôn, aƀaơ dja Kôranh Brah ăn ma khân ay may gĭt vât ndơ i nây. Lŏng khân păng Kôranh Brah mâu ăn. ");
INSERT INTO cmo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bu moh i lĕ geh, Kôranh Brah kơi ntop ăn ma păng jât, jêh ri bunuyh i nây geh ŏk rmeh ler, tih ma bu moh i mâu geh, Kôranh Brah sŏ rhuăt lơi dâng lĕ ndơ i păng lĕ geh, bol lah đê̆ kađôi. ");
INSERT INTO cmo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kơt ndri dâng Gâp ngơi ma khân păng ngơi ntât, kơt ndri bol lah khân păng uănh ndơ Gâp jan kŏ mâu vât ndơ khlay nau i nây, khân păng tăng nau Gâp ngơi kŏ mâu iăt mâu vât đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nau i dja jêng tâm di đah nau Êsai i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ lah ma khân păng: ‘Khân ay may tăng ngăn, tih ma mâu vât. Khân ay may uănh ngăn, tih ma mâu ôh say mâu ôh vât, ");
INSERT INTO cmo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yorlah nuih n'hâm phung ƀon lan dja dăng ko ngăn Tôr khân păng mbŏl. Khân păng nhêp lơi măt Mâu ăn say, Tôr mâu ăn tăng Nau mân gĭt blao mâu ăn vât, ndri khân păng mâu plơ̆ sât ma Gâp, Jêh ri Gâp mâu ŭch jan bah khân păng’. ");
INSERT INTO cmo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yơn ma ueh maak ngăn ma khân ay may, yorlah trôm măt khân ay may lĕ say, tôr khân ay may lĕ tăng. ");
INSERT INTO cmo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, geh ŏk bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, ndrel ma ŏk bunuyh sŏng kăl e nơh ŭch say ngăn dâng lĕ nau i khân ay may say aƀaơ dja, tih ma mâu ôh say, khân păng ŭch tăng ngăn nau i khân ay may tăng dja, tih ma mâu ôh tăng.” ");
INSERT INTO cmo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Lah ndri ăn khân ay may iăt hŏm, moh nau khlay ngơi ntât ma bunuyh sui găr ntil i nây. ");
INSERT INTO cmo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Lah geh bunuyh tăng nau nkoch ma nau Kôranh Brah ŭch mât uănh bunuyh, tih ma mâu vât ôh, i kôranh mpôl brah djơh hăn sŏ ntŭng dâng lĕ ndơ i lĕ geh lăp ta nuih n'hâm păng, nau i nây tâm ban ma găr tŭp ta trong. ");
INSERT INTO cmo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bunuyh i tâm ban ma găr tŭp ta neh lŭ, păng tăng nau Kôranh Brah, jêh ri iăt ro răm maak ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Hon ueh du ƀlât dơm, nau Kôranh Brah mâu ôh hon reh ta nuih n'hâm păng nơm, ndri tât geh nau jêr êng êng, mâu lah bu jan jêr yor ma nau Kôranh Brah, păng mƀăr ro nau nsing. ");
INSERT INTO cmo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bunuyh i tâm ban ma găr ntil tŭp ta neh lok, păng tăng nau ngơi Kôranh Brah, tih ma ta nuih n'hâm păng nklŏn rvê hô ngăn ma nau rêh ta neh ntu dja, ŭch rvan kơnh geh drăp ndơ, jêh ri nau i nây put ƀăr nau Kôranh Brah i nây mâu ăn tât play. ");
INSERT INTO cmo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Lŏng găr i tŭp ta neh ueh, tâm ban ma bunuyh tăng nau Kôranh Brah, n'ho ma vât nau khlay, jêh ri tât geh play, geh du huê bunuyh ri du găr jêng geh 100, du găr jêng geh 60, bunuyh aƀă ri jât du găr jêng geh 30 ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Brah Yêsu ngơi ntât du ntil nau jât ăn ma bu kơt nđa: “Nau Kôranh Brah mât uănh bunuyh, jêng tâm ban ma du huê bunuyh hăn sui găr ntil ba ueh ta mir păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yơn ma tât bu lĕ bêch, geh du huê bunuyh rlăng đah păng, hăn sui găr ntil ba brak ta mir i nây đŏng, jêh ri du roh klăk. ");
INSERT INTO cmo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tât ma ba lĕ hon lĕ jêng lôh mbôn, ba brak i nây hon đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jêh ri phung dâk i tơm mir i nây hăn mbơh a kôranh khân păng: ‘Ơ kôranh, nôk may sui găr ntil ta mir may nơh, găr ntil ba ueh. Lah ndri bơh tă lôh ba brak dja?’ ");
INSERT INTO cmo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kôranh i nây lah: ‘Geh bunuyh rlăng ro hăn sui i ri’. Phung dâk ơh ma păng: ‘Lah ndri may ŭch ăn hên rôk lơi bơh?’ ");
INSERT INTO cmo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kôranh păng ơh: ‘Mâu khăch ôh, lah khân may rôk, klach lah geh rôk nđâp ma ba. ");
INSERT INTO cmo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ŭch rong ăn păng hon ndrel hŏ, tât khay rek ri tay, gâp mra mbơh ma bunuyh rek, đă khân păng rek lor ba brak chăp rgum pur lơi ta ŭnh, jêh ri dâng rek rgum ba ngăn tôh prăp ta jay gâp nơm’.” ");
INSERT INTO cmo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Brah Yêsu ngơi ntât ăn ma khân păng du ntil nau jât: “Nau Kôranh Brah mât uănh bunuyh tâm ban ma geh du huê bunuyh hăn sui găr du ntil dŭt jê̆ ta mir păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bol lah găr ntil i nây jê̆ rlau bu ngăn đah ma dâng lĕ găr ntil êng êng, tât păng lĕ hon, păng kuŏng rlau tơm si êng êng ta mir, jêng du mlŏm tơm si kuŏng ngăn, geh siŭm drŏm gŭ jan rsuăn ta n'ging nthan păng.” ");
INSERT INTO cmo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Brah Yêsu ngơi ntât du ntil nau jât: “Nau Kôranh Brah mât uănh bunuyh jêng tâm ban ma ndrui i đê̆, du huê bu ur sŏ pot lai ndrel rnih Ba Prăng ŏk, păng tê̆ dak mpiăch ăn tâm lăp băl gay ma jan nŭmpăng. Tât jŏ du mong bar mong bơh kơi nây, bol lah păng tê̆ ndrui đê̆ kađôi, hôm dâng lĕ ndơ i nây lơ ma kuŏng lơ ma kuŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Dâng lĕ nau i nây Brah Yêsu ngơi ăn ma phung ƀon lan, Păng ngơi ntât dadê, Păng mâu geh ôh ngơi nau lah Păng mâu ngơi ntât. ");
INSERT INTO cmo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Păng ngơi kơt nây, gay ma tâm di đah nau mpôl bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ lah kơt nđa: ‘Gâp mra ngơi ma khân păng ma nau ngơi ntât, Gâp mbơh nkoch nau ndŏp mpôn bơh ntơm saơm ăn khân păng gĭt’. ");
INSERT INTO cmo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jêh ri Brah Yêsu sât bơh phung ƀon lan nây lăp ta du mlŏm jay, phung oh mon hăn ôp Păng: “Dăn May mbơh ăn hên, moh nau khlay ngơi ntât ma ba brak ta mir i nây?” ");
INSERT INTO cmo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Brah Yêsu mbơh ma khân păng: “Nơm i sui găr ntil ba ueh, ntât tâm ban ma Gâp i Kon Bunuyh tă bơh Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mir i nây ntât tâm ban ma neh ntu dja. Găr ntil ba ueh ntât tâm ban ma phung bunuyh i lĕ gŭ ta nau Kôranh Brah mât uănh. Ba brak i nây ntât tâm ban ma phung bunuyh i iăt nau kôranh mpôl brah djơh. ");
INSERT INTO cmo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Bunuyh rlăng sui ba brak i nây ntât tâm ban ma kôranh mpôl brah djơh. Khay rek ntât tâm ban ma nar n'glĕ dŭt neh ntu tay. Nơm năk rek ntât tâm ban ma phung tông păr. ");
INSERT INTO cmo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Bu rek ba brak su lơi ta ŭnh, lah ndri ta nar n'glĕ dŭt neh ntu tay păng geh tâm ban kơt nây đŏng: ");
INSERT INTO cmo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gâp i Kon Bunuyh tă bơh Kôranh Brah mra đă tông păr Gâp nơm hăn nhŭp dâng lĕ phung jan djơh, ndrel ma dâng lĕ phung leo bu jan tih, nglôh khân păng bơh nau Gâp mât uănh, ");
INSERT INTO cmo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","nklăch lơi khân păng ta ndrung ŭnh, ta ntŭk nây geh nau nhhiăng nhŭm, ndrel ma rchiăt sêk. ");
INSERT INTO cmo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yơn ma bunuyh sŏng geh nau chrat ang tâm ban ma nar ngăn, gŭ ndrel nau Kôranh Brah Bơ̆ khân păng nơm mât uănh. Bu moh tăng nau Gâp ngơi dja, ăn păng mân êng ta săk păng nơm.” ");
INSERT INTO cmo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Nau Kôranh Brah mât uănh ntât tâm ban ma bu tŏp ndŏp drăp ndơ khlay ta mir. Geh du huê bu klô say drăp ndơ khlay i nây, păng pôn ro, păng răm maak hô ngăn, jêh ri păng sât tăch dâng lĕ ndơ păng geh, gay ma sŏ prăk rvăt neh mir i nây.” ");
INSERT INTO cmo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nau Kôranh Brah mât uănh ntât tâm ban ma du huê bunuyh hăn joi rvăt pĭch mlŏm (lŭ glo) i khlay đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tât păng lĕ say pĭch du mlŏm (lŭ glo) dŭt khlay, păng sât tăch dâng lĕ ndơ păng geh, gay ma rvăt pĭch (lŭ glo) khlay i nây.” ");
INSERT INTO cmo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nau Kôranh Brah mât uănh bunuyh ntât tâm ban ma mong i bu drăng ta dak văch dak văr geh ka ăp ntil ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tât ma lĕ geh bêng mong ri, bu uih hao a kơh dja, jêh ri gŭ dônh ka i ueh ueh tê̆ ta trôm sah, ka i mâu ueh mƀăr lơi. ");
INSERT INTO cmo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ta nar n'glĕ dŭt neh ntu tay tâm ban ma kơt nây đŏng. Phung tông păr hăn tâm nkhah phung tih lôh bơh phung sŏng. ");
INSERT INTO cmo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jêh ri khân păng nklăch phung tih ta ndrung ŭnh, ta ntŭk nây geh nau nhhiăng nhŭm, ndrel ma rchiăt sêk.” ");
INSERT INTO cmo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Brah Yêsu ôp phung oh mon Păng: “Ah khân ay may gĭt vât đŏng nau dâng lĕ dja?” Khân păng ơh: “Vât.” ");
INSERT INTO cmo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Brah Yêsu lah tay ma khân păng: “Dâng lĕ phung nơm nti nau vay bân, i nti tâng nau Gâp nti ma nau Kôranh Brah mât uănh bunuyh, păng tâm ntât tâm ban ma du huê bunuyh tơm jay, păng nglôh dâng lĕ drăp ndơ khlay păng nơm bơh ntŭk păng prăp, nđâp ma ndơ ơm ndơ mhe.” ");
INSERT INTO cmo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jêh Brah Yêsu ngơi ntât kơt nây, jêh ri Păng du lôh bơh ntŭk nây, ");
INSERT INTO cmo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","hăn ta ƀon Nasaret i ƀon Păng nơm, Păng ntŭm nti bu ta nhih rƀŭn khân păng nơm. Dâng lĕ bunuyh geh nau ndrŏt hih rhŏl ngăn, jêh ri tâm lah ndrăng khân păng nơm: “Hay! Bơh tă geh nau mân gĭt blao Păng i nây, ndrel ma nau dơi, dơi jan nau khlay nây hay? ");
INSERT INTO cmo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Păng i nây i Kon bunuyh năk jan kar tơm si dơm, mê̆ Păng rnha Mari, oh bu klô Păng rnha Yakơ, Yôsep, Simôn, ndrel ma Yuđas, ");
INSERT INTO cmo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","dâng lĕ i oh oh bu ur Păng gŭ ndrel bân ta ƀon dja đŏng. Lah ndri bơh tă nau gĭt nau dơi Păng i nây?” ");
INSERT INTO cmo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ndri dâng khân păng ji nuih kŏ nuih kŏ n'hâm mâu ŭch iăt nau Păng. Brah Yêsu lah ma khân păng: “Di ngăn! Mpôl bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, bu yơk ta dâng lĕ ntŭk, yơn ma bu mưch khân păng ta bri khân păng nơm, ndrel ma ta jay khân păng nơm đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta ntŭk nây Brah Yêsu jan ndơ ueh ndơ khlay mâu ôh ŏk, yorlah bu mâu ôh nsing ma Păng. ");
INSERT INTO cmo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nôk nây Hêrôt-Ŏntipas i kôranh mât uănh bri Galilê tăng lư Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Păng lah ma phung kơl jan kar ma păng: “Bunuyh i nây Yôhan-Ƀaptem i gâp lĕ nkhât, păng lĕ dâk rêh tay, ndri dâng Păng i nây geh nau dơi jan lĕ nau kơt nây.” ");
INSERT INTO cmo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","A lor nơh Hêrôt pit sŏ ur i oh păng rnha Philip, jêh ri păng sŏ i ur Philip rnha Hêrôđias jan ur. Jêh gĭt ndri Yôhan-Ƀaptem lah Hêrôt: “Mâu ôh di đah nau vay bân, ver sŏ ur oh jan ur may.” Jêh ri Hêrôt đă tahen nhŭp Yôhan-Ƀaptem kât krŭng ta ndrung ri, gay ma i ur păng nây răm maak. ");
INSERT INTO cmo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kơt ndri dâng Hêrôt ŭch nkhât Yôhan-Ƀaptem, yơn ma păng mâu ôh bănh, klach phung ƀon lan, yor ma phung ƀon lan uănh Yôhan-Ƀaptem jêng bunuyh ntơyh nau ngơi Kôranh Brah, ndri dâng Hêrôt nhŭp nkrŭng păng dơm. ");
INSERT INTO cmo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ta nar nhêt ƀŭn kah gĭt nar deh Hêrôt, kon bu ur Hêrôđias lăp rŏm bơh năp phung bu năch gŭ rƀŭn ta nây, jan ăn Hêrôt răm ngăn, ");
INSERT INTO cmo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tât ma păng ton ăn ndơ ma kon bu ur i nây, moh ndơ kon bu ur i nây dăn, păng ăn dadê ro. ");
INSERT INTO cmo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kon bu ur i nây iăt nau mê̆ păng đă, păng dăn ma Hêrôt kơt nđa: “Gâp dăn bôk Yôhan-Ƀaptem ăn ma gâp, tê̆ ta kalơ ngan thang ta dja ro.” ");
INSERT INTO cmo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jêh tăng nau dăn i nây, Hêrôt nduih tôr hô ngăn, yơn ma păng đă bu jan kơt nau kon bu ur i nây dăn, yor ma kađăch lĕ lăn ton bơh năp phung bu năch i gŭ ta nây. ");
INSERT INTO cmo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Păng đă bu hăn koh tong ko Yôhan-Ƀaptem ta trôm ndrung ri. ");
INSERT INTO cmo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bu sŏ i bôk tê̆ kalơ ngan thang, jêh ri ndơ̆ ăn ma bu drôh nây, bu drôh i nây ndjôt ndơ̆ ăn ma i mê̆ păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jêh ri phung oh mon Yôhan-Ƀaptem hăn sŏ săk păng hăn tŏp, jêh ri hăn mbơh nkoch nau i nây ăn ma Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tât Brah Yêsu tăng nau i nây, jêh ri Păng lôh bơh ntŭk nây ncho duk ndrel mpôl oh mon Păng hăn ta du ntŭk ƀah ma bu. Yơn ma phung ƀon lan lĕ tăng, khân păng lôh tă bơh ƀon êng êng, hăn brô̆ tâng Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nôk Brah Yêsu jŭr bơh duk nây say phung ƀon lan ŏk mpưm ngăn. Păng geh nau yô̆ nđach ma khân păng ngăn, jêh ri Păng jan bah bunuyh geh nau ji kuet ta phung khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tât bơi ma dêh nar, mpôl oh mon Păng hăn mbơh ma Brah Yêsu lah: “Ta dja ntŭk rdah ngai bơh ƀon, mâu ôh geh ndơ sa, nar lĕ bơi nhŏp đŏng. May đă phung ƀon lan plơ̆ sât joi rvăt ndơ ma sông sa rŏ ƀon i dăch dăch oi ta dja.” ");
INSERT INTO cmo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yơn ma Brah Yêsu lah ma khân păng: “Mâu khăch ôh ăn bu joi rvăt ndơ, khân ay may ăn bu sông sa heh.” ");
INSERT INTO cmo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mpôl oh mon ơh ma Păng: “Hên geh prăm mlŏm nŭmpăng, ndrel ma bar mlŏm ka dơm.” ");
INSERT INTO cmo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Brah Yêsu lah ma khân păng: “Ndjôt leo nŭmpăng, ndrel ma ka i nây a Gâp dja.” ");
INSERT INTO cmo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jêh ri Brah Yêsu đă phung ƀon lan gŭ kalơ rêp nse, Păng sŏ prăm mlŏm nŭmpăng, ndrel ma bar mlŏm ka ri, Păng n'gơr măt jât lơ mbơh sơm ndơ sông sa i nây ma Kôranh Brah. Lôch jêh Păng gĭch nŭmpăng i nây ndơ̆ ăn oh mon, mpôl oh mon pă phung ƀon lan sa. ");
INSERT INTO cmo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jêh tâm pă ndơ sa i ri, dâng lĕ bunuyh gŭ sa ta nây hơm dadê, jêh ri mpôl oh mon rgum nŭmpăng, ndrel ma ka i hôm rmeh nây geh 12 sah. ");
INSERT INTO cmo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Phung ƀon lan i sa nây nơh kơp i bu klô dơm ŏk 5000 nuyh, mâu kơp ôh phung bu ur, ndrel ma kon se. ");
INSERT INTO cmo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Du ndŏm ta nây, Brah Yêsu đă mpôl oh mon Păng hăn lor ncho duk mpeh jât kăl ti ri, jêh ri Păng đă phung ƀon lan dâng lĕ i gŭ ta nây plơ̆ sât. ");
INSERT INTO cmo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jêh đă ndri, Brah Yêsu hao ta kalơ yôk du huê êng gay ma mbơh sơm. Tât bri lĕ măng Păng hôm gŭ du huê êng ta ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nôk nây duk lĕ ta nklang dak nglao kuŏng, ngai bơh kơh, geh dak rbuh dŭt dăng, yorlah khân păng hăn rlơ̆ bơh chông sial. ");
INSERT INTO cmo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tât ma lĕ du tơ̆ ndrau iăr, Brah Yêsu hăn tâng phung oh mon Păng, Păng brô̆ ta kalơ dak. ");
INSERT INTO cmo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tât ma say Păng brô̆ ta kalơ dak nglao nây, mpôl oh mon klach nsŏr ngăn, khân păng lah: “Chiak nhhu bân mê̆!” Khân păng nter drơu. ");
INSERT INTO cmo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yơn ma Brah Yêsu lah khân păng ro: “Lơi klach ôh, ăn nuih n'hâm bănh, Gâp ya!” ");
INSERT INTO cmo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pêtrôs lah ma Brah Yêsu: “Ơ Kôranh, lah May ngăn, ăn gâp brô̆ kalơ dak hăn a May nây.” ");
INSERT INTO cmo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Brah Yêsu lah ma păng: “Văch ta dja hŏm!” Jêh ri Pêtrôs jŭr bơh lơ duk, brô̆ kalơ dak hăn a Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yơn ma tât păng say sial hô ir, ntơm klach ngăn, păng ntơm ngŏm ta dak, n'ho ma nter kuăl Brah Yêsu: “Ơ Kôranh, kơl gâp ơ!” ");
INSERT INTO cmo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Brah Yêsu nta ti nhŭp ti păng ro, nđâp ma lah: “Ơ bunuyh geh nau nsing đê̆, mơm may mâu gŭ nâp ta nau nsing?” ");
INSERT INTO cmo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jêh ri Brah Yêsu, ndrel ma Pêtrôs hao ta kalơ duk, sial bah rngŏn ro. ");
INSERT INTO cmo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Phung gŭ ncho ta kalơ duk ri, yơk mbah Brah Yêsu, nđâp ma lah Păng: “May Kon Kôranh Brah ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jêh ri Brah Yêsu, ndrel ma mpôl oh mon Păng, hăn tât kăl ti dak, tât ta bri Gênêsaret. ");
INSERT INTO cmo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bunuyh ta bri nây năl Păng ro, jêh ri khân păng hăn mbơh nkoch rŏ jay lam bri nây. Dâng lĕ bunuyh i geh nau ji kuet, bu njŭn a Păng dadê. ");
INSERT INTO cmo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Khân păng bonh Brah Yêsu dăn pah Păng, bol lah pah ta chiăng ao Păng dơm kađôi, bu moh i geh pah bah dadê. ");
INSERT INTO cmo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jêh ri phung Pharisi, ndrel ma phung nơm nti nau vay phung Israel i tă bơh ƀon Yêrusalem, hăn ôp Brah Yêsu: ");
INSERT INTO cmo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Moh si kô̆ mpôl oh mon May mâu jan tâng nau vay ơm bơh kăl e, yorlah khân păng sông ê hŏ rao ti lor?” ");
INSERT INTO cmo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Brah Yêsu ơh ma khân păng: “Lah ndri khân may, moh si kô̆ mâu jan tâng nau Kôranh Brah đă, nkhơng ma jan tâng nau vay khân may nơm? ");
INSERT INTO cmo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yorlah Kôranh Brah lĕ lah kơt nđa: ‘Ăn khân ay may yơk hŏm ma mê̆ bơ̆’, jêh ri ‘Bu moh rak suai ma mê̆ bơ̆ păng nơm, păng i nây geh dôih tât bu nkhât ro’. ");
INSERT INTO cmo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yơn ma khân may lah, bu moh lah ma mê̆ bơ̆ păng nơm: ‘Dâng lĕ ndơ i di ma gâp ăn ma khân ay may, lĕ gâp ton nhhơr ma Kôranh Brah’. ");
INSERT INTO cmo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Lah ndri bunuyh i nây mâu hôm ôh khăch yơk ma mê̆ bơ̆ păng. Kơt ndri khân may n'groh lơi nau ngơi Kôranh Brah, ndjôt nkhơng nau vay khân may nơm chrao. ");
INSERT INTO cmo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Khân may bunuyh jan iăt nau Kôranh Brah dơm. Di ngăn nau Êsai i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ nchih lah ma khân may kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kôranh Brah lah: ‘Phung ƀon lan dja yơk mbah Gâp ma bŏr mbung dơm, Nuih n'hâm khân păng gŭ ngai đah Gâp. ");
INSERT INTO cmo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Khân păng yơk mbah Gâp mâu ôh geh ntil khlay Mâu ơm yor ma khân păng ntŭm nti sŏ nau vay tă bơh bunuyh dơm, yơn ma khân păng lah nau vay i nây tă bơh Gâp đă’’”. ");
INSERT INTO cmo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jêh ri Brah Yêsu kuăl phung ƀon lan văch a Păng, lah ma khân păng: “Ơ oh nô kônh va, iăt nau Gâp ler nger ƀŏt, ăn gĭt vât nau dja: ");
INSERT INTO cmo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mâu ôh di ndơ lăp rŏ mbung ăn bunuyh jêng mâu hôm kloh. Ndơ i ăn bunuyh jêng mâu hôm kloh, jêng ndơ i lôh tă bơh mbung chrao.” ");
INSERT INTO cmo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mpôl oh mon hăn a Brah Yêsu ôp Păng: “Ah May gĭt đŏng ƀah, phung Pharisi ji nuih ma May, tăng nau May ngơi kơt nây nơh?” ");
INSERT INTO cmo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Brah Yêsu ơh ma khân păng: “Dâng lĕ tơm si i mâu geh Bơ̆ Gâp i gŭ ta kalơ trôk tăm, bu rôk lơi. Bunuyh i ji nuih đah Gâp tâm ban ma tơm si i nây. ");
INSERT INTO cmo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Lơi dâng ôh rvê khân păng, khân păng i nây tâm ban ma bunuyh cheh măt tâm têk ndrăng bunuyh cheh măt. Lah ăn bunuyh cheh măt tâm têk ndrăng bunuyh cheh măt, lĕ bar hê khân păng tŭp ta ntu dadê ro.” ");
INSERT INTO cmo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pêtrôs lah ma Brah Yêsu: “Dăn May mbơh nau ngơi ntât i nây ăn hên vât.” ");
INSERT INTO cmo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Brah Yêsu lah: “Ah khân may ê hŏ đŏng gĭt vât? ");
INSERT INTO cmo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ndơ i lăp rŏ mbung bunuyh, păng n'hot lăp trôm ndŭl, jêh ri lôh ăch, ndri ƀah? ");
INSERT INTO cmo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yơn ma ndơ i lôh tă bơh mbung bunuyh, păng lôh tă bơh nuih n'hâm, ndơ i nây jan ăn bunuyh mâu hôm kloh: ");
INSERT INTO cmo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nau ŭch jan ndơ djơh, nau nkhât bu, nau tâm lŏm tâm rlau, nau tâm dŏng, nau ntŭng n'glănh, nau mƀrôh rlăm, nau ngơi nchơt, jêng lôh tă bơh nuih n'hâm bunuyh dadê. ");
INSERT INTO cmo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dâng lĕ ndơ i nây jan ăn bunuyh dâng geh jêng ƀơ̆ ƀơch, ăn Kôranh Brah mâu hôm rom. Sông mâu geh rao ti lor, mâu geh ôh ăn bunuyh mâu hôm kloh.” ");
INSERT INTO cmo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jêh ri Brah Yêsu lôh bơh ntŭk nây, hăn ta ntŭk dăch ta ƀon kuŏng Tirus, ndrel ma hăn dăch ta ƀon kuŏng Siđôn. ");
INSERT INTO cmo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ta bri nây geh du huê bu ur bri Kanaan i mâu di phung Israel păng hăn a Brah Yêsu, n'ho ma nter kuăl Brah Yêsu mâu bah ôh: “Ơ Kôranh! Ơ Kon Sau kađăch Đavid! Dăn May yô̆ nđach gâp ơ, kon bu ur gâp brah djơh lơh, păng geh nau rêh rnhăl hô ngăn!” ");
INSERT INTO cmo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yơn ma Brah Yêsu mâu ơh ôh, jêh ri mpôl oh mon hăn a Brah Yêsu, bonh Păng: “Dăn May đă bu ur i nây du bơh bân, yorlah hô ngăn păng nter tâng bơh kơi bân.” ");
INSERT INTO cmo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Brah Yêsu ơh: “Kôranh Brah đă Gâp hăn, ăn Gâp joi bunuyh ta phung Israel i mâu iăt nau Kôranh Brah dơm, khân păng tâm ban ma be biăp lĕ hiơt.” ");
INSERT INTO cmo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yơn ma bu ur i nây hăn dăch a Brah Yêsu chon kômŏk mbah bơh năp Păng ri, jêh ri lah: “Ơ Kôranh, dăn kơl gâp ơ.” ");
INSERT INTO cmo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Brah Yêsu ơh: “Mâu di ôh, lah sŏ ndơ sông sa bơh kon, jêh ri mƀăr ăn so sa.” ");
INSERT INTO cmo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Bu ur i nây ơh ma Brah Yêsu: “Di ngăn Kôranh, yơn ma so hôm sa ndơ ndăk trôh bơh kalơ gre kôranh păng đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Brah Yêsu lah ma păng: “Ơ yôh, nau nsing ay kuŏng ngăn, lah ndri ăn geh kơt nau ay lĕ ŭch ngăn ro!” Jêh ri kon bu ur păng dô ma bah nôk nây ro. ");
INSERT INTO cmo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Brah Yêsu lôh bơh ntŭk nây, hăn a dak nglao kuŏng Galilê, jêh ri hao a kalơ yôk gŭ rgơp ta nây. ");
INSERT INTO cmo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ŏk ngăn bunuyh hăn a Păng, nđâp ma leo bunuyh kuet rven, bunuyh siăr jŏng ti, bunuyh cheh măt, bunuyh mlo, ndrel ma bunuyh ji kuet êng êng. Bu ăn bêch bơh năp jŏng Brah Yêsu ri, jêh ri Păng jan bah dadê. ");
INSERT INTO cmo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dâng lĕ bunuyh say kơt nây geh nau ndrŏt hih rhŏl ngăn, say bunuyh mlo blao ngơi, bunuyh siăr jŏng ti jêng dăng, bunuyh kuet rven blao brô̆, bunuyh cheh măt uănh say. Dâng lĕ khân păng leo băl rnê Kôranh Brah i brah phung Israel dadê. ");
INSERT INTO cmo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Brah Yêsu kuăl mpôl oh mon Păng hăn a Păng, jêh ri lah ma khân păng: “Gâp yô̆ ngăn ma phung ƀon lan nây, khân păng gŭ ndrel Gâp lĕ pe nar hơi, ndơ ma sông sa mâu geh đŏng. Gâp mâu ŭch ăn khân păng plơ̆ sât ndŭl dơm, klach lah huăr rŏ trong.” ");
INSERT INTO cmo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mpôl oh mon lah ma Brah Yêsu: “Ta dja rngot rngăt, lah ndri ah ntŭk hên joi gay ma tŏng ăn phung bunuyh ŏk i nây sa?” ");
INSERT INTO cmo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Brah Yêsu ôp khân păng: “Lah ndri dah ŏk geh nŭmpăng khân may?” Khân păng ơh: “Hên geh pơh mlŏm, ndrel ma ka jê̆ đê̆ đă.” ");
INSERT INTO cmo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jêh ri Brah Yêsu đă phung ƀon lan gŭ rơp gơp ta neh ri. ");
INSERT INTO cmo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Păng sŏ pơh mlŏm nŭmpăng nây, ndrel ma ka i nây, mbơh sơm lah ueh ma Kôranh Brah, Păng gĭch ăn ma mpôl oh mon, jêh ri mpôl oh mon pă ma phung ƀon lan nây. ");
INSERT INTO cmo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dâng lĕ bu sa hơm dadê, jêh ri rgum nŭmpăng, ndrel ma ka i rmeh nây geh pơh sah. ");
INSERT INTO cmo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dâng lĕ bunuyh i gŭ sa ta nây geh 4000 nuyh bu klô, mâu kơp ôh phung bu ur, ndrel ma kon se. ");
INSERT INTO cmo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jêh Brah Yêsu ăn phung ƀon lan sât, jêh nây Păng ncho duk hăn ta ntŭk kuăl lah Makađan. ");
INSERT INTO cmo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nôk nây phung Pharisi, ndrel ma phung Sađôsi aƀă hăn ŭch rlong Brah Yêsu, đă Păng jan du nau mbên gay ma nhhơ nau dơi Păng tă bơh Kôranh Brah ri. ");
INSERT INTO cmo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yơn ma Brah Yêsu lah ma khân păng: “Trôk gŭr a ôi, khân may vay lah prăng. ");
INSERT INTO cmo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Trôk gŭr kêng măng, khân may vay lah nar ôi tay mih ro. Khân may blao mbên trôk, lah ndri mơm dâng mâu gĭt vât ndơ i Kôranh Brah jan ta rnôk aƀaơ dja? ");
INSERT INTO cmo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bunuyh ta rnôk aƀaơ dja hô ngăn djơh mhĭk jan tih ma nau ŭch Kôranh Brah, ŭch say ma nau mbên dơm, yơn ma Kôranh Brah mâu ôh ăn nau mbên êng jât, Păng ăn du nau mbên tâm ban ma nau mbên Yônais i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh dơm.” Jêh ri Brah Yêsu hăn ntlơi khân păng ta nây. ");
INSERT INTO cmo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nôk mpôl oh mon hăn glăt kăl ti dak nglao kuŏng Galilê, khân păng chuêl ndjôt nŭmpăng. ");
INSERT INTO cmo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Brah Yêsu lah ma khân păng: “Ăn khân ay may njrăng ngăn hŏm ndrui phung Pharisi, ndrel ma ndrui phung Sađôsi hŏ.” ");
INSERT INTO cmo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mpôl oh mon ngơi ndrăng khân păng nơm: “Păng ngơi kơt nây ach ma bân mâu geh ndjôt nŭmpăng dơm mâu, yor ma bu jan nŭmpăng ma ndrui!” ");
INSERT INTO cmo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Brah Yêsu gĭt nau khân păng ngơi, Păng lah: “Ơ phung geh nau nsing đê̆ dơm, moh ngơi khân mre nau mâu geh nŭmpăng nây? ");
INSERT INTO cmo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Khân ay may hôm mâu gĭt vât nau đŏng? Ah khân ay may mâu hôm kah gĭt nôk Gâp pă prăm mlŏm nŭmpăng ăn ma bunuyh 5000 nuyh nơh? Jêh ri khân ay may lĕ chuêl ƀah, nôk khân ay may rgum ndơ rmeh, dah ŏk sah? ");
INSERT INTO cmo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mâu lah pơh mlŏm nŭmpăng Gâp ăn bunuyh 4000 nuyh nơh, jêh ri khân ay may rgum ndơ rmeh dah ŏk sah hôm geh? ");
INSERT INTO cmo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mơm dâng khân ay may ê hŏ gĭt vât đŏng, Gâp mâu geh ôh ngơi ma nŭmpăng ngăn. Gâp ăn khân ay may njrăng ndrui phung Pharisi, ndrel ma ndrui phung Sađôsi.” ");
INSERT INTO cmo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jêh ri mơ dâng mpôl oh mon gĭt nau Brah Yêsu lah i nây ăn khân păng njrăng nau ntŭm nti phung Pharisi, ndrel ma phung Sađôsi, mâu ôh di ndrui tê̆ rnih ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nôk Brah Yêsu hăn ntŭk dăch ma ƀon Sêsara-Philip, Păng ôp mpôl oh mon Păng: “Tâng ma nau bu lah, bu moh Gâp i Kon Bunuyh tă bơh Kôranh Brah?” ");
INSERT INTO cmo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jêh ri khân păng ơh: “Bu aƀă lah May Yôhan-Ƀaptem i lĕ dâk rêh, bu aƀă lah May Êliya i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ plơ̆ ta dja, bu aƀă jât lah May Yêrêmi i bunuyh ntơyh nau ngơi Kôranh Brah i lĕ dâk rêh, mâu lah May du huê bunuyh êng jât ta mpôl bunuyh ntơyh nau ngơi Kôranh Brah i lĕ dâk rêh.” ");
INSERT INTO cmo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Brah Yêsu ôp khân păng: “Lah ndri khân ay may eh, Gâp bu moh khân ay may lah mêh?” ");
INSERT INTO cmo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simôn i bu kuăl Pêtrôs đŏng lah: “May Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl, i kon Kôranh Brah, Brah i rêh ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Brah Yêsu lah ma păng: “Ơ Simôn kon Yônais, răm maak ngăn ma May, yorlah Bơ̆ Gâp gŭ ta kalơ trôk ăn may gĭt Gâp Brah Krist. Nau i nây mâu geh ôh tă bơh nau gĭt blao bunuyh. ");
INSERT INTO cmo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Gâp mbơh ma may, may rnha Pêtrôs, rnha i nây geh nau khlay lah ‘Rlat lŭ’, jêh ri ta kalơ rlat lŭ dja Gâp ntăm i nhih brah Gâp i dâng lĕ mpôl bunuyh nsing ma Gâp. Nau khât mâu ôh dơi đah phung khân păng i nây. ");
INSERT INTO cmo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Gâp mra ăn may nau dơi ma ăn bunuyh lăp ta nau Kôranh Brah mât uănh, tâm ban ma ăn du mlŏm kon so mpông ma may. Jêh ri moh ndơ may buay mâu ăn bu jan ta neh ntu dja, Kôranh Brah i gŭ ta kalơ trôk ŭch kơt nđay. Moh ndơ may mâu buay ma bu jan ta neh ntu dja, Kôranh Brah i gŭ ta kalơ trôk ŭch kơt nđay đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jêh ri Păng buay hô ngăn mpôl oh mon Păng, lơi mbơh nkoch ăn bu gĭt ôh Păng Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl. ");
INSERT INTO cmo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ntơm bơh nôk nây, Brah Yêsu ntơm mbơh nkoch ăn ma mpôl oh mon Păng gĭt lah, iăt ma Păng hăn ta ƀon kuŏng Yêrusalem, n'ho ma ta ƀon nây Păng geh nau jêr jŏt dŭt hô ngăn tă bơh mpôl bu ranh, mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay phung Israel, n'ho ma nkhât lơi Ôbăl, yơn ma tât pe nar Păng dâk rêh đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jêh ri Pêtrôs jă Brah Yêsu hăn ntŭk êng ƀah ma bu, gay ma lah Păng: “Ơ Kôranh, ăn Kôranh Brah buay nau i nây, lơi ôh ăn nau i nây tât ma May.” ");
INSERT INTO cmo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yơn ma Brah Yêsu n'gâl jât Pêtrôs, jêh ri lah: “Hơi Satăng, may du ngai bơh Gâp hŏm, may ŭch nking lơi trong Gâp. Nau mân may mâu ôh di đah nau mân Kôranh Brah, nau mân nây tă bơh bunuyh dơm.” ");
INSERT INTO cmo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jêh ri Brah Yêsu lah ma mpôl oh mon Păng: “Bu moh păng i ŭch tâng Gâp, ăn mƀăr lơi ndơ săk păng nơm ŭch, jêh ri tui si tâm rkăng păng nơm, bol lah tât khât săk kađôi, ri mơ păng tâng Gâp ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Yorlah bu moh i ŭch prăp ma nau rêh păng nơm, păng i nây mâu ôh geh nau rêh n'ho ro, yơn ma bu moh khât yor ma tâng Gâp, păng i nây mra geh nau rêh n'ho ro ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Lah du huê bunuyh păng joi geh dâng lĕ neh ntu dja jêng drăp ndơ păng nơm dadê, tih ma săk păng nơm khât roh hêng, mâu ôh geh nau rêh n'ho ro, ndri moh geh nau khlay ma păng? Mâu lah bunuyh ơm dơi sŏ drăp ndơ rgâl ma nau rêh păng nơm n'ho ro đŏng bơh? ");
INSERT INTO cmo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nôk Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch nđâp ma nau chrêk lơp Bơ̆ Gâp nơm, ndrel ma phung tông păr Gâp, Gâp ndjôt ndơ nkhôm, mâu lah tê̆ dôih tâng nau jan kar du huê du huê săk. ");
INSERT INTO cmo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, bunuyh aƀă i gŭ ta dja mâu khât ôh ê lor ma say Gâp i Kon Bunuyh tă bơh Kôranh Brah jêng nơm mât uănh.” ");
INSERT INTO cmo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Geh prao nar bơh kơi nây Brah Yêsu jă Pêtrôs, Yakơ, ndrel ma Yôhan i oh Yakơ, hao kalơ yôk prêh, mâu ôh leo bu a êng hăn. ");
INSERT INTO cmo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ta nây săk jăn Păng rgâl bơh năp khân păng. Muh măt Păng ril ngăn tâm ban ma ang nar, i bok ao Păng jêng nglang, ang chrat ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Khân păng dô ma say bunuyh ntơyh nau ngơi Kôranh Brah bơh kăl e nơh rnha Êliya, ndrel ma kôranh phung Israel kăl e nơh rnha Môsê gŭ ngơi ndrel Brah Yêsu ta nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jêh say lĕ nau i nây, Pêtrôs lah ma Brah Yêsu: “Hơi Kôranh, bân gŭ ta dja ueh ngăn mê. Lah May ŭch, ăn gâp jan pe mlŏm chun, du mlŏm ăn ma May, du mlŏm ăn ma Môsê du mlŏm jât ăn ma Êliya.” ");
INSERT INTO cmo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nôk păng hôm ngơi, dô ma say geh tŭk nkŭm jŭm khân păng lĕ rngôch ang ral hô ngăn, tăng nteh ngơi tă bơh tŭk nây lah: “Păng dja Kon Gâp i Gâp rŏng hô ngăn. Hô ngăn Gâp răm Păng. Iăt nau Păng dô!” ");
INSERT INTO cmo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tât mpôl oh mon tăng kơt i nây, khân păng chôt chŭn muh măt a neh su dadê, klach hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yơn ma Brah Yêsu hăn pah khân păng lah: “Dâk hŏm, lơi ôh klach!” ");
INSERT INTO cmo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tât khân păng ngơk uănh, say du huê Brah Yêsu dơm, bunuyh aƀă êng mâu ôh say. ");
INSERT INTO cmo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jêh ri khân păng jŭr tă bơh yôk, Brah Yêsu buay khân păng kơt nđa: “Lơi ôh nkoch ăn bu gĭt ndơ i khân may say nây nơh, n'ho ma kŏp tât Gâp i Kon Bunuyh tă bơh Kôranh Brah khât dâk rêh ƀŏt.” ");
INSERT INTO cmo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jêh ri khân păng ôp Brah Yêsu: “Lah ndri moh nau dâng phung nơm nti nau vay phung bân nti lah Êliya iăt ma păng văch lor ta dja, Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl văch bơh kơi ro?” ");
INSERT INTO cmo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Brah Yêsu ơh ma khân păng: “Di ngăn nau pre lah. Êliya văch, gay ma kơi ndrăp ăn ăp dâng lĕ rngôch. ");
INSERT INTO cmo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yơn ma Gâp mbơh nkoch ma khân may, Êliya lĕ plơ̆ ngăn, jêh ri bu mâu ôh gĭt năl păng, hô ngăn bu jan jêr ma ôbăl dah dăng ŭch khân păng nơm. Kơt nđa đŏng Gâp i Kon Bunuyh tă bơh Kôranh Brah khân păng jan jêr đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nôk nây mpôl oh mon gĭt vât, Brah Yêsu ngơi ma Yôhan-Ƀaptem. ");
INSERT INTO cmo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nôk Brah Yêsu, ndrel ma pe nuyh mpôl oh mon Păng tât ta ntŭk bunuyh phung, geh du huê bu klô hăn chon kômŏk bơh năp Brah Yêsu ri ");
INSERT INTO cmo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","jêh ri lah: “Ơ Kôranh, dăn May yô̆ nđach kon bu klô gâp ơ! Păng khât brŭt mê, ta păng rêh rnhăl ngăn, ŏk tơ̆ păng vay chôt ta ŭnh, chôt ta dak mro. ");
INSERT INTO cmo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gâp lĕ leo păng a mpôl oh mon May, yơn ma khân păng jan mâu dơi ôh.” ");
INSERT INTO cmo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Brah Yêsu lah ma dâng lĕ bunuyh: “Hơi bunuyh djơh, bunuyh mâu iăt nau Kôranh Brah! Dah hôm jŏ ăn Gâp nsrôyh gŭ ndrel khân ay may? Dah hôm jŏ ăn Gâp nsrôyh ndrel khân ay may? Leo hŏm păng i nây a dja.” ");
INSERT INTO cmo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jêh ri Brah Yêsu mbram brah djơh i gŭ ta kon se ri, brah djơh lôh bơh kon se ro, ntơm bơh nôk nây ro kon se i nây bah. ");
INSERT INTO cmo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jêh ri mpôl oh mon hăn ôp êng Brah Yêsu: “Mơm dâng hên mâu dơi mprơh brah djơh ăn lôh hiah?” ");
INSERT INTO cmo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Brah Yêsu lah ma khân păng: “Ach ma nau nsing khân ay may đê̆ ir. Gâp lah n'hêl nanê̆ ngăn ma khân ay may, lah khân ay may geh nau nsing đê̆ tâm ban ma du ntil găr ntil dŭt jê̆, khân ay may dơi đă yôk: ‘Du hŏm bơh ntŭk dja, hăn gŭ ta ntŭk ri’, păng du ngăn ro, n'ho ma mâu geh ôh du ntil ndơ khân ay may mâu dơi jan. ");
INSERT INTO cmo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Dâng bu dơi mprơh ăn lôh ntil brah djơh i dja, yor ma nau mbơh sơm, ndrel ma ăt sông sa.” ");
INSERT INTO cmo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nôk gŭ ta bri Galilê, Brah Yêsu lah ma mpôl oh mon: “Gâp i Kon Bunuyh tă bơh Kôranh Brah, bu mra njŭn ăn ma bunuyh ");
INSERT INTO cmo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","i nkhât lơi Gâp, yơn ma tât pe nar Gâp dâk rêh đŏng.” Mpôl oh mon tăng kơt nây, khân păng rngot hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nôk Brah Yêsu, ndrel ma mpôl oh mon Păng tât ta ƀon Kapơnŭm, mpôl bunuyh i rgum prăk ma ăn nhih jan brah ma Kôranh Brah ta ƀon Yêrusalem, khân păng hăn mâp Pêtrôs, jêh ri ôp: “Ah nơm nti khân may ăn prăk ma nhih jan brah ma Kôranh Brah đŏng?” ");
INSERT INTO cmo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pêtrôs ơh: “Ơ, Păng ăn.” Nôk Pêtrôs lăp ta trôm jay, Brah Yêsu ôp păng lor: “Ơ Pêtrôs, tâng ma nau may mân, kađăch ta neh ntu dja bơh tă păng sŏ prăk mêh? Sŏ bơh oh kon păng nơm, mâu lah bơh bu êng?” ");
INSERT INTO cmo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pêtrôs ơh: “Sŏ bơh bu êng.” Brah Yêsu lah: “Lah ndri kon kađăch mâu khăch ăn ôh. ");
INSERT INTO cmo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yơn ma gay ma lơi ăn khân păng ji nuih, ăn may hăn tê̆ ndar a dak nglao kuŏng Galilê, may nkhak mbung ka i lor ƀoh ndar, ta trôm mbung ka i nây may say geh du mlŏm prăk kăk ma găp bar hê bân, jêh ri may sŏ prăk i nây ndơ̆ ăn bu, sơm ndơ̆ ăn ma Gâp, nđâp ma may nơm đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nôk nây mpôl oh mon hăn ôp Brah Yêsu: “Bu moh kuŏng rlau bu ta nau Kôranh Brah mât uănh?” ");
INSERT INTO cmo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Brah Yêsu kuăl du huê kon se jê̆ gŭ ta nklang phung khân păng ri, ");
INSERT INTO cmo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","jêh ri lah: “Gâp lah n'hêl nanê̆ ngăn ma khân ay may, lah khân ay may mâu rgâl nuih n'hâm ăn jêng tâm ban ma kon se jê̆, khân ay may mâu ôh dơi lăp ta nau Kôranh Brah mât uănh. ");
INSERT INTO cmo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bu moh i njŭr săk păng nơm jêng tâm ban ma kon se jê̆ dja, păng i nây jêng kuŏng rlau bu ta nau Kôranh Brah mât uănh. ");
INSERT INTO cmo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jêh ri bu moh rom du huê kon se jê̆ kơt nđa, yor ma kon se i nây nsing ma Gâp, păng i nây tâm ban ma rom Gâp đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Brah Yêsu lah jât: “Bu moh leo du huê kon se jê̆ i nsing ma Gâp jan nau tih, ndri ueh rlau lah bu sŏ mpăl lŭ kât ta tong ko păng nklăch ta dak văch dak văr, rmok ta dak văch dak văr jru ri, ma đah ăn păng rêh jan kơt nây. ");
INSERT INTO cmo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Rêh rnhăl ngăn ma bunuyh ta neh ntu, yor ma leo bu jan tih. Mra geh ngăn nau leo jan tih, yơn ma rêh rnhăl ngăn ro ma bu moh i leo ăn jan tih! ");
INSERT INTO cmo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Lah say ti mâu lah jŏng khân ay may leo jan nau tih, koh mƀăr lơi ti mâu lah jŏng i nây. Ueh rlau ma gŭ rêh jât năp tay rong du ding ti mâu lah du ding jŏng dơm, jêh ri dơn nau rêh n'ho ro, ma đah ti mâu lah jŏng bar đah, jêh ri gŭ ta ntŭk i geh ŭnh hit n'ho ro. ");
INSERT INTO cmo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Lah say trôm măt khân ay may leo jan nau tih, rvek mƀăr lơi trôm măt i nây. Ueh rlau ma rong du ding trôm măt dơn nau rêh n'ho ro, ma đah bar ding trôm măt, jêh ri Kôranh Brah nklăch ta ndrung ŭnh. ");
INSERT INTO cmo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ăn khân ay may njrăng hŏm, lơi ôh uănh mâu khlay ta kon se jê̆ kơt nây. Gâp mbơh ma khân ay may, ta ntŭk Kôranh Brah ta kalơ trôk phung tông păr i kơl njrăng kon se i nây gŭ nâng ta năp măt Bơ̆ Gâp. ");
INSERT INTO cmo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gâp i Kon Bunuyh tă bơh Kôranh Brah văch ta neh ntu dja, gay ma rklaih bunuyh tih i roh yot, bunuyh i nuih n'hâm ngai bơh Kôranh Brah tâm ban ma be biăp roh.” ");
INSERT INTO cmo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mơm khân ay may gĭt, mơm jan du huê bunuyh lah geh be biăp 100 yơn ma geh du mlŏm be biăp roh? Ơm mâu lah păng ntlơi be biăp i 99 ta kalơ yôk, jêh ri hăn joi be biăp i roh nây ro? ");
INSERT INTO cmo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, lah păng joi say be biăp i roh nây, păng răm rhơn ngăn ma be biăp i nây, rlau ma be biăp 99 i mâu roh jât. ");
INSERT INTO cmo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lah ndri tâm ban kơt nây đŏng Bơ̆ khân ay may i gŭ ta kalơ trôk, păng mâu ŭch ôh ăn du huê kon se jê̆ i dja roh khât n'ho ro.” ");
INSERT INTO cmo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Lah geh du huê bunuyh nsing ma Kôranh Brah jan tih đah khân ay may, ăn khân ay may hăn du huê êng mâp păng, ngơi đah păng. Lah păng iăt nau khân ay may, khân ay may geh tay nau đăp mpăn đah păng kơt ơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lah păng mâu ôh iăt khân ay may, ăn khân ay may jă du huê, mâu lah bar hê hăn ndrel khân ay may, gay ma gĭt tăng dâng lĕ ndơ i geh ngơi. ");
INSERT INTO cmo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lah păng hôm e mâu iăt đŏng phung khân ay may i nây, lah ndri mbơh nkoch nau i nây ăn ma phung nsing ma Kôranh Brah. Lah păng mâu ŭch iăt đŏng phung nsing i nây, lah ndri kơp păng jêng bunuyh i mâu nsing ma Kôranh Brah, mâu lah kơp păng jêng bunuyh jan tih a êng jât. ");
INSERT INTO cmo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, jêh ri moh ndơ khân ay may buay mâu ăn bu jan ta neh ntu dja, Kôranh Brah i gŭ ta kalơ trôk ŭch kơt nđay. Moh ndơ khân ay may mâu buay ma bu jan ta neh ntu dja, Kôranh Brah i gŭ ta kalơ trôk ŭch kơt nđay đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Du tơ̆ jât, Gâp lah n'hêl nanê̆ ngăn ma khân ay may, lah geh bar hê ta phung khân ay may ta neh ntu mbơh sơm du ntôr nau, moh ndơ khân păng dăn, Bơ̆ Gâp i gŭ ta kalơ trôk ăn ndơ i nây ma khân păng ro. ");
INSERT INTO cmo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yorlah plăng ntŭk geh bar pe nuyh gŭ rƀŭn yor ma khân păng nsing ma Gâp, Gâp gŭ ndrel ta nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jêh ri Pêtrôs hăn ôp Brah Yêsu: “Ơ Kôranh, lah geh du huê bunuyh nsing ma Kôranh Brah jan tih ma gâp, lah ndri dŭm bri tơ̆ gâp yô̆ nau tih ăn păng mêh? Tât ma pơh tơ̆ bơh?” ");
INSERT INTO cmo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Brah Yêsu ơh ma păng: “Mâu ôh dơn ma pơh tơ̆ dơm, yơn ma 70 tơ̆ pơh.” ");
INSERT INTO cmo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kơt ndri ta nau Kôranh Brah mât uănh, ntât tâm ban ma du huê kađăch ŭch tâng rnon mpôl bunuyh kơl jan kar i khan rnon đah păng. ");
INSERT INTO cmo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nôk kađăch nây ntơm jan, geh bu njŭn du huê bunuyh ma păng i hôm khan rnon ŏk rkeh. ");
INSERT INTO cmo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ach ma păng i nây mâu hôm dơi geh prăk ma tŏm rnon, kađăch đă bu tăch ur tăch kon, nđâp ma tăch săk păng nơm, ndrel ma tăch dâng lĕ drăp ndơ păng, gay ma tŏm rnon i nây. ");
INSERT INTO cmo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bunuyh kơl jan kar i nây păn mbah ta jŏng păng ri, jêh ri lah: ‘Ơ kôranh! Dăn may nsrôyh kŏp ƀŏt ơ, gâp mra tŏm râng ăn may’. ");
INSERT INTO cmo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kađăch yô̆ nđach ma păng hô ngăn, ăn păng sât, nkre ma n'groh lĕ i rnon păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Jêh ri bunuyh kơl jan kar i nây du sât bơh kađăch, păng tâm mâp đah du huê mât jăng vay kơl jan kar ndrel păng nơm. Ôbăl i nây khan rnon đah păng 100 prăk kăk, nhŭp mpet ôbăl ta tong ko, jêh ri lah: ‘Tŏm hŏm rnon gâp!’ ");
INSERT INTO cmo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","I mât jăng păng nây păn ta jŏng păng, bonh dăn păng: ‘Dăn may nsrôyh kŏp ƀŏt ơ, gâp mra tŏm râng ăn may’. ");
INSERT INTO cmo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yơn ma păng mâu ŭch iăt ôh, nhŭp krŭng ôbăl ta trôm ndrung, n'ho ma tât ôbăl tŏm râng rnon mơ. ");
INSERT INTO cmo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bunuyh kơl jan kar aƀă êng say kơt nây, khân păng rngot hô ngăn, mbơh nkoch dâng lĕ nau i nây ăn ma kađăch. ");
INSERT INTO cmo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kađăch đă bu hăn kuăl păng, jêh ri lah: ‘Hơi bunuyh djơh mhĭk! Dâng lĕ rnon may lĕ gâp n'groh lơi lĕ phiao, ach ma gâp say may dăn hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mơm dâng may mâu ŭch yô̆ ôh bunuyh kơl jan kar ndrel may nơm, kơt gâp lĕ yô̆ ma may?’ ");
INSERT INTO cmo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kađăch i nây ji nuih hô ngăn ma păng, jêh ri njŭn păng ma kôranh mât uănh ndrung gay ma nkrit păng, tê̆ păng ta trôm ndrung n'ho ma tât păng tŏm râng rnon. ");
INSERT INTO cmo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tâm ban đŏng ta phung khân ay may, lah khân ay may mâu ôh tâm yô̆ nau tih, mâu blao bah kơp nau tih ndrăng khân ay may nơm ăn lĕ bơh nuih n'hâm ngăn, Bơ̆ Gâp gŭ ta kalơ trôk Păng jan ma khân ay may kơt nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lôch jêh Brah Yêsu ngơi kơt nây, Păng lôh bơh bri Galilê, hăn jât bri Yuđa mpeh bơh kăl ti dak rlai Yôrđăn, jêng mpeh bơh lôh nar. ");
INSERT INTO cmo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Geh bunuyh ŏk ngăn tâng Păng, jêh ri Păng jan bah phung ji kuet ta nây. ");
INSERT INTO cmo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Geh phung Pharisi aƀă hăn a Brah Yêsu ôp rlong Păng: “Hơi nơm nti! Ah tâng ma nau vay phung bân, sai dơi ntlơi ur, moh nau aƀă êng dơi đŏng bơh?” ");
INSERT INTO cmo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Brah Yêsu ơh ma khân păng: “Khân may lĕ uănh ƀah ta Nau Kôranh Brah Ngơi, bơh ntơm saơm Kôranh Brah njêng bunuyh đŏng, geh bu klô, geh bu ur? ");
INSERT INTO cmo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jêh ri lah: ‘Ndri dâng geh bu klô lôh du bơh mê̆ bơ̆, hăn gŭ a ur, jêh ri bar hê khân păng jêng ur sai jêng du rnglay săk’ ");
INSERT INTO cmo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ndri khân păng mâu ôh hôm jêng bar hê tay, lĕ jêng du rnglay săk dơm. Lah ndri bar hê ur sai i Kôranh Brah de rnglăp nây lơi ôh ăn bunuyh tâm nkhah.” ");
INSERT INTO cmo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Phung Pharisi ôp Brah Yêsu: “Lah ndri mơm dâng Môsê đă i sai jan samƀŭt nau tâm ntlơi, jêh ri dơi mprơh i ur păng nơm?” ");
INSERT INTO cmo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Brah Yêsu lah khân păng: “Ach ma nuih n'hâm khân may dăng ko hô ir, ndri dâng Môsê đă khân may jan samƀŭt ntlơi ur. Yơn ma bơh ntơm nơh mâu ôh geh kơt nây. ");
INSERT INTO cmo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Gâp mbơh ma khân may, bu moh ntlơi ur păng nơm, yơn ma ur păng mâu geh ôh lŏm sai, jêh ri sŏ ur êng, bunuyh i nây kơp păng lĕ jêng bunuyh lŏm ur.” ");
INSERT INTO cmo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mpôl oh mon lah ma Păng: “Lah kơt ndri ngăn nau sŏ ur sai, ueh đê̆ lah mâu sŏ ur sŏ sai.” ");
INSERT INTO cmo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Brah Yêsu plơ̆ lah ma khân păng: “Mâu di ôh dâng lĕ bunuyh gĭt vât nau dja, geh bunuyh i Kôranh Brah ăn, păng i nây dơm dơi gĭt vât. ");
INSERT INTO cmo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Geh bunuyh aƀă n'ho ma mâu blao sŏ ur sŏ sai ntơm bơh deh, bunuyh aƀă lĕ bu char lơi, bunuyh aƀă jât mâu ŭch ôh sŏ ur sŏ sai yor ma ŭch kơl jan kar ta nau Kôranh Brah mât uănh. Lah ndri bu moh i blao gĭt vât nau ngơi i nây, ăn păng tâng kơt dô!” ");
INSERT INTO cmo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jêh ri geh bu leo kon se jê̆ jê̆ njŭn a Brah Yêsu, gay ma ăn Păng tê̆ ti mbơh sơm ma khân păng, yơn ma mpôl oh mon buay lơi khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yơn ma Brah Yêsu lah: “Ăn phung kon se văch ta Gâp, lơi ôh buay khân păng. Bunuyh i Kôranh Brah mât uănh, khân păng geh kơt ndri đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jêh Brah Yêsu tê̆ ti ta kon se ri, jêh ri Păng du lôh bơh ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nôk nây geh du huê bu klô hăn dăch a Brah Yêsu ôp Păng: “Ơ Nơm Nti, mơm gâp jan nau ueh gay ma geh nau rêh n'ho ro mêh?” ");
INSERT INTO cmo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Brah Yêsu lah ma păng: “Mơm may ôp Gâp ma nau ueh? Geh du huê Kôranh Brah dơm jêng ueh, jêh ri lah may ŭch geh nau rêh n'ho ro, ăn may ndjôt nau vay bân dô.” ");
INSERT INTO cmo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Păng ôp Brah Yêsu: “Moh nau vay aƀă mêh?” Brah Yêsu ơh ma păng: “Lơi nkhât bu, lơi lŏm ur lŏm sai, lơi ntŭng, lơi ngơi nchơt, ");
INSERT INTO cmo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","yơk ma mê̆ bơ̆ hŏ, jêh ri rŏng ma phung chiao meng tâm ban ma rŏng săk may nơm.” ");
INSERT INTO cmo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bu klô ndăm i nây lah ma Brah Yêsu: “Dâng lĕ nau vay i nây lĕ gâp ndjôt dadê, lah ndri moh ndơ ê hŏ geh đŏng?” ");
INSERT INTO cmo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Brah Yêsu lah ma păng: “Lah may ŭch jêng sŏng dŭt ueh ngăn, ăn may tăch hŏm dâng lĕ drăp ndơ may geh, pă ăn ma mpôl o ach, ndri mơ may geh ndơ khlay ta ƀon ueh ta kalơ, jêh ri hăn tâng Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tât bu klô ndăm i nây tăng nau ngơi kơt nây, păng du sât nđâp ma nau rngot, yorlah păng geh drăp ndơ dŭt ŏk. ");
INSERT INTO cmo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Brah Yêsu lah ma mpôl oh mon Păng: “Gâp lah n'hêl nanê̆ ngăn ma khân ay may, jêr ngăn ma bunuyh ndrŏng lăp ta nau Kôranh Brah mât uănh. ");
INSERT INTO cmo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gâp lah tay ma khân ay may, ma bunuyh ndrŏng lăp ta nau Kôranh Brah mât uănh, jêr rlau đah ăn seh samô lăp ta trôm nglai.” ");
INSERT INTO cmo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tât ma tăng nau ngơi kơt nây, mpôl oh mon mâu ôh gĭt vât, khân păng ndrŏt hih rhŏl ngăn, ôp Brah Yêsu: “Lah bunuyh ndrŏng lĕ geh jêr jêh lăp ta nau Kôranh Brah mât uănh, lah ndri bunuyh a êng hôm dơi lăp ta nau Kôranh Brah mât uănh đŏng lah mâu?” ");
INSERT INTO cmo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Brah Yêsu uănh jât khân păng lah: “Nau lăp i nây bunuyh jan mâu ôh dơi, yơn ma Kôranh Brah dơi jan dadê dâng lĕ ndơ.” ");
INSERT INTO cmo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jêh ri Pêtrôs ôp Brah Yêsu: “Lĕ May say hơyh hên, hên lĕ ntlơi ndoh ndơ hên nơm lĕ phiao, hăn tâng May. Lah ndri hên tay moh ndơ geh?” ");
INSERT INTO cmo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Brah Yêsu lah ma khân păng: “Gâp lah n'hêl nanê̆ ngăn ma khân may, nôk neh ntu rgâl mhe, nôk Gâp i Kon Bunuyh tă bơh Kôranh Brah gŭ ta rnơl kađăch Gâp i geh nau chrêk lơp, lah ndri khân may i lĕ tâng Gâp gŭ ta rnơl kađăch 12 ơ̆ đŏng, n'ho ma phat dôih lĕ bunuyh 12 mpôl rnoi deh phung Israel đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Lah ndri bu moh ntlơi nhih jay, mê̆ bơ̆, oh nô, oh nur, oh kon, mâu lah mir ba yor ma tâng Gâp, păng i nây geh du mlŏm jêng lôh 100 nđâp ma dơn nau rêh n'ho ro. ");
INSERT INTO cmo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Geh bunuyh ŏk ta neh ntu dja bu gĭt khân păng geh nau khlay ngăn, yơn ma ta jât năp tay mâu ôh geh nau khlay. Tih ma geh bunuyh ŏk êng jât ta neh ntu dja bu gĭt khân păng mâu ôh geh nau khlay, yơn ma ta jât năp tay ƀêng ma geh nau khlay.” ");
INSERT INTO cmo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Nau Kôranh Brah mât uănh bunuyh, tâm ban ma du huê bunuyh geh mir. Ơm ôi păng hăn, gay ma joi bunuyh jan kar ta mir play yŭng yar ƀon păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Păng lĕ tâm di jêh du ntôr nau ăn ma dâng lĕ bunuyh jan kar i nây du mlŏm prăk kăk du nar, jêh ri đă khân păng hăn jan kar ta mir păng ri. ");
INSERT INTO cmo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Klăp lah ta mong sân păng hăn tay đŏng, say bunuyh aƀă hôm gŭ dơm ta ntŭk tăch drăp, mâu geh ntŭk jan kar. ");
INSERT INTO cmo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Păng lah ma khân păng: ‘Ăn khân may hăn jan kar ta mir gâp ri, gâp mra nkhôm khân may ăn tâm di’. ");
INSERT INTO cmo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jêh ri phung i nây hăn ro. Tât n'gul nar, tât mong pe kêng măng, păng hăn đă tay bu a êng kơt nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tât lĕ mong prăm, păng hăn tay du tơ̆ jât, say bunuyh aƀă a êng jât hôm gŭ dơm ta ntŭk tăch drăp ri. Păng lah ma phung i nây: ‘Moh gŭ dơm khân may ta dja du nar rmăng nây?’ ");
INSERT INTO cmo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Khân păng ơh: ‘Yorlah mâu geh bunuyh ŭch joi hên jan kar’. Păng lah ma phung i nây: ‘Khân may hăn jan kar hŏm a mir gâp ri’. ");
INSERT INTO cmo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tât kêng măng, păng i tơm mir nây lah ma bunuyh ndjôt prăk: ‘Kuăl hŏm phung jan kar, ƀơk prăk ăn khân păng, ƀơk ntơm bơh n'glĕ dŭt bu, tât ma păng i lor bu’. ");
INSERT INTO cmo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tât phung jan kar i ntơm mong prăm, bu ƀơk ăn khân păng du huê du mlŏm prăk kăk. ");
INSERT INTO cmo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jêh ri tât phung jan kar i lor bu, khân păng nklŏn geh prăk ŏk rlau bu, yơn ma geh du mlŏm prăk kăk tâm ban dơm. ");
INSERT INTO cmo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jêh khân păng sŏ prăk i nây, khân păng ngơi ƀrôk ma bunuyh i tơm mir i nây: ");
INSERT INTO cmo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Phung i jan kar n'glĕ dŭt bơh kơi, jan du mong dơm. May ƀơk prăk ăn khân păng tâm ban ma hên jan kar gŭ thŏng ta dôh nar du nar rmăng đŏng!’ ");
INSERT INTO cmo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bunuyh i tơm mir nây lah ma du huê bunuyh ta khân păng i nây: ‘Ơ jăng, gâp mâu geh ôh mƀrôh may, yorlah may lĕ tâm di du ntôr nau ŭch jan kar ăn gâp du nar du mlŏm prăk kăk. ");
INSERT INTO cmo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Lah ndri sŏ prăk may nây hăn hŏm, bunuyh i jan kar bơh kơi may, gâp ŭch ăn tâm ban ma may đŏng, ");
INSERT INTO cmo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","yorlah prăk gâp nơm tâng nuih n'hâm gâp nơm ŭch dŏng. Mâu lah ach ma say gâp jan ueh, may tâm mâu nach ma khân păng?’ ");
INSERT INTO cmo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Geh bunuyh ta neh ntu dja bu gĭt khân păng geh nau khlay ngăn, yơn ma ta jât năp tay mâu ôh geh nau khlay. Tih ma geh bunuyh êng jât ta neh ntu dja bu gĭt khân păng mâu ôh geh nau khlay, yơn ma ta jât năp tay ƀêng ma geh nau khlay.” ");
INSERT INTO cmo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nôk Brah Yêsu hăn ta ƀon kuŏng Yêrusalem, Păng leo 12 nuyh mpôl kôranh oh mon Păng, hăn êng, nôk hôm hăn rŏ trong, Păng lah ma khân păng kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Aƀaơ dja bân hăn jât ƀon Yêrusalem. Gâp dja i Kon Bunuyh tă bơh Kôranh Brah, bu de njŭn ăn ma mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay phung bân. Jêh ri khân păng i nây tê̆ dôih Gâp tât khât. ");
INSERT INTO cmo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Khân păng i nây njŭn Gâp ma phung i mâu di phung Israel, ăn bu gơm n'grơh, rpăt ma mŏng rse, n'ho ma nkhât Gâp ta si tâm rkăng. Yơn ma tât pe nar Kôranh Brah ăn Gâp dâk rêh tay đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nôk nây i ur Sêƀêđê, leo bar hê kon păng nơm hăn chon kômŏk ta jŏng Brah Yêsu ri, ŭch dăn du ntil nau. ");
INSERT INTO cmo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Brah Yêsu ôp păng: “Moh nau ay ŭch?” Păng ơh: “Nôk May jêng kađăch ngăn ta nau may nơm mât uănh tay, ăn bar hê kon gâp dja jêng kuŏng rlau bu gŭ ta nâm May nơm, du huê gŭ bơh ma du huê gŭ bơh chiao May.” ");
INSERT INTO cmo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yơn ma Brah Yêsu ơh: “Khân ay may mâu gĭt vât ôh, moh ndơ khân ay may dăn. Lah ndri khân may dơi sŏ dơi nhêt đŏng ndrănh play yŭng yar ƀon ta kchok i Gâp be nhêt, geh nau khlay lah geh nau jêr jŏt kơt Gâp đŏng?” Yakơ, ndrel ma Yôhan ơh: “Ơ, hên dơi sŏ dơn.” ");
INSERT INTO cmo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Brah Yêsu lah ma khân păng: “Nau khân may sŏ dơn nhêt ndrănh play yŭng yar ƀon ta kchok i Gâp nhêt mra geh ngăn, tih ma i nau gŭ bơh ma bơh chiao ri, Gâp mâu ôh dơi rom, yor ma ntŭk i nây lĕ ndrăp ăn ma bunuyh i Bơ̆ Gâp nơm lĕ ŭch ăn dơm.” ");
INSERT INTO cmo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tât mpôl oh mon i jât nuyh nây tăng lah kơt nây, khân păng ji nuih ma bar hê khân păng i nây. ");
INSERT INTO cmo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jêh ri Brah Yêsu kuăl dâng lĕ mpôl oh mon Păng, jêh ri lah: “Khân may lĕ gĭt hơyh bunuyh i mât uănh ma phung bunuyh i mâu di phung Israel, khân păng i nây dah ŭch jan ma phung ƀon lan khân păng nơm, geh đŏng mpôl i têh kuŏng tŭn jot ma phung ƀon lan khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ta mpôl khân may tay mâu ôh geh kơt nây! Ta mpôl khân may lah geh du huê ŭch jan kuŏng, ăn păng i nây jêng bunuyh sơm kơl jan kar ma khân may. ");
INSERT INTO cmo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Lah geh du huê ŭch jan kuŏng rlau bu, iăt ma păng jan dâk ma khân may ƀŏt. ");
INSERT INTO cmo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tâm ban ma Gâp i Kon Bunuyh tă bơh Kôranh Brah văch ta neh ntu dja, mâu ôh Gâp đă bu sơm kơl jan kar ăn ma Gâp. Ƀêng ma Gâp chrao sơm kơl jan kar ăn ma bu, jêh ri Gâp jao săk Gâp nơm tât khât săk, gay ma chuai ŏk bunuyh.” ");
INSERT INTO cmo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nôk khân păng lôh bơh ƀon Yêrikhô, geh ŏk bunuyh tâng Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nôk nây geh bar hê bunuyh cheh măt gŭ ta meng trong ri. Tât khân păng tăng lah Brah Yêsu hăn rŏ trong nây, khân păng nter ro: “Ơ Kôranh i kon sau kađăch Đavid, yô̆ nđach hên ƀă ơ!” ");
INSERT INTO cmo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Geh bunuyh ŏk buay khân păng ăn gŭ iăt săk rklăk hŏ, yơn ma lơ hô khân păng nter: “Ơ Kôranh i kon sau kađăch Đavid, yô̆ nđach hên ơ!” ");
INSERT INTO cmo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Brah Yêsu nsrŭng, jêh ri kuăl bar hê bunuyh cheh măt i nây ôp: “Moh ndơ khân may ŭch ăn Gâp jan ma khân may?” ");
INSERT INTO cmo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Khân păng ơh: “Ơ Kôranh, ăn măt hên say ang.” ");
INSERT INTO cmo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Brah Yêsu yô̆ nđach khân păng hô ngăn, pah trôm măt khân păng, jêh ri trôm măt khân păng dô ma say ang ro, jêh ri khân păng tâng Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nôk Brah Yêsu hăn bơi ma tât ƀon kuŏng Yêrusalem, lĕ tât ta ƀon Ƀêtphasê ta yôk tơm Ôlive, Păng đă bar hê mpôl oh mon Păng hăn lor, ");
INSERT INTO cmo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Păng lah: “Ăn khân may hăn ta ƀon bơh năp ri, lăp ta ƀon nây khân may mra say du mlŏm me seh lia bu kât nđâp ma kon păng đŏng. Khân may droh têk lĕ bar a Gâp dja. ");
INSERT INTO cmo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Lah geh bu ôp khân may, khân may lah ma păng kơt nđa: ‘Kôranh ŭch dŏng păng dâng lĕ bar’, bu mra ăn khân may têk ro.” ");
INSERT INTO cmo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dâng lĕ nau dja geh, gay ma tâm di đah nau mpôl bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ nchih lah: ");
INSERT INTO cmo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Ăn mbơh nkoch hŏm ma phung ƀon lan ta ƀon Yêrusalem: ‘Lŏng uănh dja, kađăch khân ay may văch. Păng mleh hô ngăn, ncho ta kalơ seh lia, Ncho ta kon seh lia đŏng’’. ");
INSERT INTO cmo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jêh ri bar hê mpôl oh mon i nây hăn jan kơt nau Brah Yêsu đă. ");
INSERT INTO cmo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Khân păng têk me seh lia, nđâp ma i kon păng, jêh ri ntă ao kuŏng khân păng nơm ta kalơ lĕ bar mlŏm seh nây, ăn Brah Yêsu ncho lăp ta ƀon. ");
INSERT INTO cmo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Phung ƀon lan dŭt ŏk ngăn ta ƀon nây, khân păng droh ao kuŏng khân păng nơm lăk ta trong. Bunuyh aƀă te nthan si bơh mir lăk rŏ trong nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bunuyh ŏk ngăn brô̆ tâng Brah Yêsu bơh năp bơh kơi, leo băl nter drơu lah: “Rnê ma Kôranh Brah ăn ma i kon sau kađăch Đavid! Dăn Kôranh Brah ăn nau geh jêng ma Păng i Kôranh Brah de đă văch! Rnê ma Kôranh Brah i gŭ kalơ trôk dŭt prêh ri!” ");
INSERT INTO cmo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nôk Brah Yêsu lăp ta ƀon Yêrusalem, dâng lĕ bunuyh ta ƀon nây geh nau ndrŏt dŭt hô ngăn, khân păng mâu ôh vât, ôp: “Bu moh Păng i nây?” ");
INSERT INTO cmo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Phung bunuyh i tâng Brah Yêsu lah: “Păng dja Yêsu bunuyh ntơyh nau ngơi Kôranh Brah tă bơh ƀon Nasaret bri Galilê.” ");
INSERT INTO cmo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jêh ri Brah Yêsu ndrel mpôl oh mon Păng hăn lăp ta jŏng gung nhih jan brah. Phung i tăch rgâl ta nây Păng mprơh lĕ phiao. Păng nklơ̆ gre bu gŭ rgâl prăk, nđâp ma gre bu tăch plŭk. ");
INSERT INTO cmo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Brah Yêsu lah khân păng i nây: “Ta Nau Kôranh Brah Ngơi lĕ geh nchih kơt nđa: ‘Kôranh Brah lah: ‘Nhih Gâp jêng ntŭk ma mbơh sơm ma Gâp’’ Ƀêng ma khân may sŏ jan ntŭk gŭ rgum mpôl ntŭng chrao.” ");
INSERT INTO cmo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nôk nây geh bunuyh cheh măt, ndrel ma bunuyh kuet rven hăn a Brah Yêsu ta jŏng gung nhih jan brah ri, jêh ri Păng jan bah dadê. ");
INSERT INTO cmo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yơn ma mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay phung Israel, say Brah Yêsu jan ndơ i nây lĕ nau ngăn, jêh ri tăng phung kon se nter ta jŏng gung nhih jan brah lah: “Rnê ma Kôranh Brah ma i kon sau kađăch Đavid!” Khân păng ji nuih hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Khân păng ôp Brah Yêsu: “May tăng đŏng nau phung kon se nter nây?” Brah Yêsu ơh: “Tăng đŏng. Lah ndri khân may lĕ uănh đŏng ta Nau Kôranh Brah Ngơi nchih kơt nđa: ‘Ơ Kôranh Brah, May lĕ ndrăp ăn nau rnê ma May nơm Ta mbung kon se, ndrel ma ta oh bê hôm pu toh’.” ");
INSERT INTO cmo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jêh ri Brah Yêsu ntlơi khân păng gŭ ta nây. Păng lôh bơh ntŭk nây hăn ta ƀon Ƀêthani, gŭ ta ƀon nây du măng. ");
INSERT INTO cmo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tât ơm ôi, ôi tay Brah Yêsu plơ̆ tay ta ƀon Yêrusalem. Nôk nây Păng ji ngot. ");
INSERT INTO cmo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Păng say tơm play Rvi du tơm rŏ trong, jêh ri Păng hăn dăch tơm play i nây joi play, yơn ma mâu ôh geh play, geh n'ha dơm. Păng lah ma tơm play i nây: “Ntơm bơh nar dja, may tơm play i dja lơi hôm ôh geh play!” Jêh ri dô ma ndro ro tơm Rvi i nây. ");
INSERT INTO cmo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tât ma mpôl oh mon say kơt nây, khân păng ndrŏt hih rhŏl ngăn, khân păng ôp: “Mơm ndro ndal tơm Rvi i dja hiah?” ");
INSERT INTO cmo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Brah Yêsu lah ma khân păng: “Gâp lah n'hêl nanê̆ ngăn ma khân may, lah khân may lĕ geh nau nsing nâp mâu geh nau vĭ vĕ ta nuih n'hâm, mâu ôh dơn kơt ma Gâp jan tơm play Rvi dja dơm khân may dơi jan, yơn ma lah khân may đă yôk dja: ‘Du hŏm bơh ntŭk dja, ăn tŭp a dak văch dak văr ri’, păng geh kơt nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Moh ndơ khân may mbơh sơm dăn Kôranh Brah ma nuih n'hâm geh nau nsing, khân may geh ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jêh ri Brah Yêsu lăp ta jŏng gung nhih jan brah ma Kôranh Brah. Nôk Păng nti bu, geh mpôl kôranh jan brah, ndrel ma mpôl bu ranh phung ƀon lan hăn a Brah Yêsu ôp Păng: “Mbơh ăn ma hên gĭt, ndơ May jan dja bơh tă nau dơi? Bu moh ăn nau dơi i nây ma May mêh?” ");
INSERT INTO cmo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Brah Yêsu ơh: “Gâp ôp du nau ma khân may ƀŏt, lŏng khân may ơh ma Gâp đŏng, ndri mơ Gâp mra mbơh ma khân may, bơh tă nau dơi ma ndơ i Gâp jan. ");
INSERT INTO cmo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Lah ndri bu moh đă Yôhan-Ƀaptem jan ƀăptem yŭk ma dak? Tă bơh Kôranh Brah, mâu lah tă bơh bunuyh?” Khân păng tâm nchră êng: “Lah bân lah: ‘Tă bơh Kôranh Brah’, Păng mra lah bân: ‘Lah ndri mơm dâng khân may mâu iăt nau păng?’ ");
INSERT INTO cmo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Lah bân ơh: ‘Tă bơh bunuyh’, ndri bân klach phung ƀon lan ji nuih, yor ma ŏk bunuyh iăt nau Yôhan-Ƀaptem kơp păng jêng bunuyh ntơyh nau ngơi Kôranh Brah ro.” ");
INSERT INTO cmo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jêh ri khân păng ơh ma Brah Yêsu: “Hên mâu ôh gĭt!” Brah Yêsu lah ma khân păng: “Lah ndri Gâp mâu mbơh ăn ma khân may gĭt đŏng, bu moh ăn nau dơi Gâp jan dja.” ");
INSERT INTO cmo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mơm khân may vât ma nau ntât bar hê kon bu klô? Geh du huê bu klô geh bar hê kon bu klô, păng lah ma kon bôk dak: ‘Ơ nô, nar dja đă may hăn jan kar ta mir play yŭng yar ƀon ri’. ");
INSERT INTO cmo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","I kon păng ơh: ‘Gâp mâu ŭch hăn ôh!’, yơn ma bơh kơi nây păng rgâl nau mân, jêh ri hăn ta mir. ");
INSERT INTO cmo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jêh ri i bơ̆ ngơi kơt nây đŏng ma kon a êng, kon i nây ơh: ‘Ơ gâp hăn bơ̆!’, yơn ma păng mâu hăn ôh. ");
INSERT INTO cmo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Lah ndri dâng lĕ bar hê kon i nây, bu moh i iăt nau bơ̆ păng?” Khân păng ơh: “I nô.” Brah Yêsu lah ma khân păng: “Gâp lah n'hêl nanê̆ ngăn ma khân may, mpôl kŏp sŏ prăk phung ƀon lan gay ma ăn kôranh mât uănh, ndrel ma bu ur văng târ, khân păng i nây lăp ta nau Kôranh Brah mât uănh lor bơh năp khân may. ");
INSERT INTO cmo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yorlah Yôhan-Ƀaptem lĕ văch ntŭm nti nau gŭ rêh tâng nau Kôranh Brah ŭch ma khân may, tih ma khân may mâu ŭch ôh iăt păng. Mpôl kŏp sŏ prăk phung ƀon lan i nây, ndrel ma bu ur văng târ i nây, khân păng iăt nau păng. Lŏng khân may bol lah lĕ say dâng lĕ nau i nây kađôi, khân may hôm e mâu ŭch ôh rgâl nuih n'hâm gĭt mân ma păng, mâu ŭch nsing ma păng đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Dăn iăt du nau ngơi ntât êng jât. Geh du huê bu klô tăm du lôk mir tơm play yŭng yar ƀon. Păng jan n'gar jŭm mir nây, jan du ntŭk ma bu njot play i nây, ndrel ma jan du mlŏm chuanh nkơng đŏng gay ma njrăng. Jêh ri ăn bu mât mir i nây, đă bu pă play ma păng ăp năm. Păng nơm ri hăn gŭ bri êng. ");
INSERT INTO cmo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tât di khay dŭm play yŭng yar ƀon ri, păng đă dâk păng aƀă hăn tâm mâp ma mpôl mât mir i nây, gay ma sŏ play i bu pă nây. ");
INSERT INTO cmo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mpôl mât mir i nây nhŭp khân păng, i du huê mbang, i du huê nkhât lơi, jêh ri i du huê jât ntŭp ôbăl ma lŭ. ");
INSERT INTO cmo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jêh ri păng đă tay dâk păng a êng jât hăn, ŏk rlau dâk i bơh kơi nơh. Yơn ma mpôl mât mir lơh khân păng kơt dâk i bơh kơi nơh jât. ");
INSERT INTO cmo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kêng ma dŭt păng đă i kon bu klô păng nơm hăn bơh kơi bu, păng mân êng lah: ‘Bu klach yơk ma kon gâp ro’. ");
INSERT INTO cmo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yơn ma tât mpôl mât mir say păng, khân păng tâm lah: ‘Păng i nây ro ntrŏ ndơn mir i dja nar jât năp tay. Hăn bân nkhât lơi păng i nây dôh, sŏ mir i dja ma bân ro’. ");
INSERT INTO cmo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jêh ri bu de nhŭp i kon păng nơm i tơm mir nây, mƀăr ôbăl bơh dih mir i nây, nkhât lơi ôbăl. ");
INSERT INTO cmo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Lah tât păng nơm i tơm mir hăn, mơm păng jan ma mpôl mât mir i nây?” ");
INSERT INTO cmo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Khân păng ơh ma Păng: “Păng nkhât nkrit lơi mpôl djơh i nây ro, mâu ôh geh rong, jêh ri joi nkhôm ăn bu êng jât mât mir păng, mpôl i pă play ma păng tât di khay pĕ play.” ");
INSERT INTO cmo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Brah Yêsu lah ma khân păng: “Ndri khân may mâu geh rŏ samƀŭt Nau Kôranh Brah Ngơi lĕ geh nchih lah: ‘Bunuyh blao jan jay lŭ blon lĕ mƀăr lơi du mlŏm lŭ blon, Yơn ma lŭ blon i nây nkhơng ma jêng lŭ dŭt nâp khlay rlau bu ma jan jay. Kôranh Brah nơm jan nau i nây lĕ nau ngăn, Say kơt nây ăn bân ndrŏt hih rhŏl hô ngăn’. ");
INSERT INTO cmo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kơt ndri dâng Gâp lah ma khân may, Kôranh Brah sŏ lơi nau Păng nơm mât uănh tă bơh khân may ăn phung bunuyh êng i ăn geh play ma Păng. ");
INSERT INTO cmo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Lah ndri moh nau bu ntât dja? Lŭ blon i nây jêng ntât ma Gâp. Bu moh i chôt ta lŭ blon i nây, păng i nây lêk rhŏch ro. Jêh ri lah lŭ blon i nây tŭp kalơ du huê bunuyh, bunuyh i nây hăch lĕ phiao.” ");
INSERT INTO cmo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nôk mpôl kôranh jan brah, ndrel ma phung Pharisi tăng nau ntât kơt nây, khân păng gĭt lah Brah Yêsu lah ntrŏng jât khân păng ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Khân păng ŭch nhŭp Brah Yêsu, tih ma khân păng klach ma phung ƀon lan, yorlah phung ƀon lan kơp Păng jêng bunuyh ntơyh nau ngơi Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Brah Yêsu ngơi ntât ma khân păng du tơ̆ jât: ");
INSERT INTO cmo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ta nau Kôranh Brah mât uănh tâm ban ma du huê kađăch ndrăp nau nhêt sông kuŏng ma nđăp kon ndăm păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jêh ri păng đă phung dâk păng hăn kuăl bunuyh i lĕ păng jă lăp nhêt sông sa tâm nđăp i nây, yơn ma khân păng mâu ŭch ôh văch. ");
INSERT INTO cmo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Păng đă tay phung dâk a êng jât hăn, lah ma phung dâk i nây: ‘Ăn khân may mbơh ma bunuyh i lĕ jêh jă: ‘Gâp lĕ jêh ndrăp phiao piăng trao, gâp lĕ mbang ndrôk, ndrel ma mpômpa (siŭm) i gâp pêt, lah ndri hăn nhêt sông hŏm!’’ ");
INSERT INTO cmo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yơn ma bu mâu ôh geh dôh tôr, aƀă lôh a mir, aƀă hăn tăch drăp, ");
INSERT INTO cmo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","aƀă jât nhŭp lơh phung dâk păng, n'ho ma nkhât lơi khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kađăch ji nuih hô ngăn, jêh ri đă phung tahen hăn nkhât lơi phung i nkhât dâk păng nây, n'ho ma su ƀon khân păng lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jêh ri păng lah ma phung dâk păng: ‘Nau nhêt sông tâm nđăp bân ndrăp lĕ jêh phiao, yơn ma dâng lĕ phung i nây mâu geh ôh di lăp ta ntŭk dja. ");
INSERT INTO cmo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lah ndri khân may hăn hŏm rŏ meng trong, jă dâng lĕ bunuyh i khân may mâp ăn khân păng lăp nhêt sông sa ndrel ta dja dadê’. ");
INSERT INTO cmo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jêh ri phung dâk păng hăn rŏ trong, jă dâng lĕ bunuyh i khân păng mâp, nđâp ma bunuyh ueh bunuyh djơh, geh bêng jay (rông), tâm nđăp ri ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nôk kađăch lăp ta trôm jay tâm nđăp uănh bu năch gŭ sông sa ta nây, păng say geh du huê bu klô nsoh n'gut mâu ôh tâm di ma nau nhêt sông tâm nđăp. ");
INSERT INTO cmo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Păng lah ma bu klô i nây: ‘Ơ jăng! Mơm may lăp ta ntŭk dja nsoh n'gut mâu tâm di đah nau nhêt sông tâm nđăp?’ Bu klô i nây joi nau ma ơh mâu hôm ôh blao. ");
INSERT INTO cmo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kađăch lah ma phung kơl jan kar ma păng: ‘Nhŭp kât jŏng ti păng, mƀăr păng bơh dih ta ntŭk ngo, ta ntŭk nây geh nau nhhiăng nhŭm, ndrel ma rchiăt sêk’. ");
INSERT INTO cmo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bunuyh Kôranh Brah kuăl ŏk ngăn, yơn ma đê̆ dơm Păng kơih.” ");
INSERT INTO cmo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nôk nây phung Pharisi hăn tâm nchră băl, joi nhŭp nau tih ta nau Brah Yêsu ngơi. ");
INSERT INTO cmo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jêh ri khân păng đă mpôl oh mon khân păng, ndrel ma mpôl i tâng kôranh mât uănh Hêrôt-Ŏntipas hăn a Brah Yêsu. Tât ta nây khân păng ôp: “Hơi Nơm Nti! Hên gĭt May bunuyh sŏng ngăn, May nti nau Kôranh Brah ăn tâm di ngăn, May mâu ôh klach ma bunuyh, mâu ôh kơih bunuyh. ");
INSERT INTO cmo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lah ndri dăn May mbơh ăn hên, mơm nau May mân? Di đŏng tâng nau vay bân ăn prăk i kôranh kađăch ta ƀon kuŏng Rôm đă bân ăn ma păng nây mâu lah mâu?” ");
INSERT INTO cmo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Brah Yêsu lĕ gĭt nau mân djơh ta khân păng, ndri Păng lah: “Ơ phung jan iăt nau Kôranh Brah dơm! Moh nau khân may ŭch ôp rlong ma Gâp kơt nây mêh? ");
INSERT INTO cmo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nhhơ ntil prăk i bu ăn ma kôranh kađăch ri, ăn Gâp uănh!” Jêh ri khân păng sŏ prăk du mlŏm prăk kăk ntil i nây ndơ̆ ăn Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Brah Yêsu ôp khân păng: “Ndri ta kalơ prăk kăk dja bu moh rup? Bu moh rnha?” ");
INSERT INTO cmo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Khân păng ơh: “Rup, ndrel ma rnha kôranh kađăch ta ƀon Rôm!” Brah Yêsu lah ma khân păng: “Lah ndri, ndơ kôranh kađăch ta ƀon Rôm mplơ̆ ăn ma păng, ndơ Kôranh Brah mplơ̆ ăn ma Kôranh Brah nơm.” ");
INSERT INTO cmo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tât tăng nau Brah Yêsu ơh kơt nây, khân păng ndrŏt hih rhŏl ngăn, jêh ri du lôh bơh Brah Yêsu nây. ");
INSERT INTO cmo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nôk nar nây geh phung Sađôsi hăn a Brah Yêsu, phung i nây mâu iăt ôh lah bunuyh khât dâk rêh, khân păng ôp Brah Yêsu: ");
INSERT INTO cmo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Hơi nơm nti, Môsê kăl e nơh lĕ nchih jêh ta samƀŭt ăn ma bân phung Israel lah kơt nđa: ‘Lah bu klô sŏ ur, jêh ri păng khât, lah păng mâu geh kon, đă i oh nô păng ri ntrŏ sŏ ur păng, jêh ri kơp kon khân păng jêng kon ma păng i lĕ khât nây’. ");
INSERT INTO cmo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ntât lah ta phung hên geh oh nô pơh nuyh, i nô bôk dak sŏ ur, jêh ri khât mâu ôh geh kon, i ur nây ăn i oh păng trŏ sŏ. ");
INSERT INTO cmo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Oh tŏl nguai, oh tŏl bar, n'ho ma tât i oh mpŭt, khân păng nđăp đah bu ur i nây dadê, tih ma dâng lĕ khân păng nây khât mâu geh kon dadê. ");
INSERT INTO cmo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","N'glĕ dŭt n'glĕ dêl bu ur i nây khât đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lah ndri ta nar bunuyh khât dâk rêh tay, bu ur i nây bre moh ur? Yorlah dâng lĕ pơh nuyh khân păng lĕ sŏ păng dadê.” ");
INSERT INTO cmo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Brah Yêsu lah ma khân păng: “Khân may lĕ vât tih jêh, yorlah khân may mâu gĭt ôh ta Nau Kôranh Brah Ngơi, nđâp ma nau dơi Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nôk bunuyh lĕ khât, jêh ri dâk rêh tay, khân păng mâu hôm ôh sŏ ur sŏ sai jât. Khân păng jêng tâm ban ma tông păr Kôranh Brah gŭ ta ƀon ueh kalơ. ");
INSERT INTO cmo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Lŏng ma nau bunuyh khât dâk rêh tay, lĕ Kôranh Brah mbơh ma khân may ta nau Păng ngơi, Păng lah kơt nđa: ‘Gâp jêng Brah Abrahăm yơk mbah, jêng Brah Isăk yơk mbah, jêng Brah Yakôp yơk mbah’. Ah khân may geh rŏ uănh đŏng ƀah? Nôk Kôranh Brah ngơi nau i nây pe nuyh khân păng i nây lĕ khât ŏk năm jêh, yơn ma bơh Nau Kôranh Brah Ngơi i nây gĭt năl khân păng hôm rêh ma Kôranh Brah. Kôranh Brah mâu ôh di Brah ma bunuyh khât, Păng Brah ma bunuyh rêh.” ");
INSERT INTO cmo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Phung ƀon lan tăng nau Păng ntŭm nti kơt nây, khân păng geh nau ndrŏt hih rhŏl hô ngăn ta săk khân păng ri. ");
INSERT INTO cmo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nôk phung Pharisi gĭt Brah Yêsu dơi đah phung Sađôsi, khân păng rgum băl. ");
INSERT INTO cmo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jêh ri ta phung khân păng geh du huê bunuyh geh nau mân gĭt blao mpeh ma nau vay phung Israel, ôp rlong Brah Yêsu: ");
INSERT INTO cmo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ơ Nơm Nti! Ta nau vay bân moh ndơ i khlay rlau bu mêh?” ");
INSERT INTO cmo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Brah Yêsu ơh: “‘Ăn rŏng ma Kôranh Brah i Brah khân ay may nơm, ma lĕ nuih n'hâm, ma lĕ huêng, ndrel ma lĕ nau mân’. ");
INSERT INTO cmo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","I nây nau vay i dŭt kuŏng, nau vay khlay rlau bu ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nau vay bơh kơi nau vay i nây geh nau khlay tâm ban kơt nây đŏng: ‘Ăn rŏng ma bu chiao meng kơt rŏng ma săk khân ay may nơm đŏng’. ");
INSERT INTO cmo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yorlah dâng lĕ nau vay bân a êng, ndrel ma dâng lĕ nau i mpôl bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ nchih, jêng lôh tă bơh bar nau vay i nây.” ");
INSERT INTO cmo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nôk phung Pharisi hôm gŭ gum ta ri, Brah Yêsu ôp khân păng: ");
INSERT INTO cmo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mơm khân may gĭt Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl, Păng bu moh kon sau?” Khân păng ơh: “Păng kon sau kađăch Đavid.” ");
INSERT INTO cmo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Brah Yêsu ơh ma khân păng: “Lah Brah Krist i kon sau kađăch Đavid, mơm dâng kađăch Đavid ngơi ma Brah Huêng Ueh kuăl Brah Krist: ‘Kôranh’? ");
INSERT INTO cmo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Yorlah kađăch Đavid lĕ nchih kơt nđa: ‘Kôranh Brah lah ma kôranh gâp: ‘Gŭ mpeh bơh ma Gâp hŏm ta ntŭk bu lư, Kŏp tât Gâp ăn phung rlăng đah May mâu hôm geh nau dơi ăn gŭ ta nâm jŏng May ƀŏt’’. ");
INSERT INTO cmo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Lah lĕ kađăch Đavid nơm kuăl Brah Krist kôranh păng nơm kơt nây, yơn ma kon sau mâu geh kuŏng rlau ma u che, lah ndri Brah Krist mơm hôm blao jêng kon sau kađăch Đavid jât?” ");
INSERT INTO cmo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mâu geh ôh bunuyh dơi ơh ma Brah Yêsu, jêh ri ntơm bơh nôk nây mâu hôm ôh geh bunuyh a êng bănh ôp Păng. ");
INSERT INTO cmo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jêh ri Brah Yêsu lah ma phung bunuyh ŏk, ndrel ma mpôl oh mon Păng kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Phung nơm nti nau vay phung bân, ndrel ma phung Pharisi, khân păng tâm ban ma gŭ ta rnơl Môsê, yor ma khân păng nti nau vay păng. ");
INSERT INTO cmo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Dâng lĕ ndơ khân păng ntŭm nti ăn ma khân ay may, ăn khân ay may iăt, ndrel ma sŏ dơn. Yơn ma lơi ôh jan tâng khân păng jan, yorlah khân păng man ma lah dơm, săk khân păng nơm mâu ôh jan tâng. ");
INSERT INTO cmo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Khân păng njêng nau vay dŭt jêr dŭt jŏk ngăn ăn ma bunuyh ndjôt, yơn ma khân păng nơm mâu ŭch ôh pah, bol lah pah đê̆ mâu ŭch đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Dâng lĕ ndơ khân păng jan nây, gay ma ăn bu say, jêh ri ăn bu kơp khân păng jêng bunuyh i tâng nau Kôranh Brah rlau bu dơm. Ndri dâng khân păng lơ ma jan kuŏng dŭng i bân vay kât ta bôk, ndrel ma kât ta ti nôk mbơh sơm, ndrel ma jan chiăng ao lơ ma jong jât. ");
INSERT INTO cmo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Khân păng rŏng geh gŭ ta ntŭk bu yơk nôk nhêt sông kuŏng, jêh ri ta trôm nhih rƀŭn ŭch gŭ bơh năp bu ta ntŭk bu lư. ");
INSERT INTO cmo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Khân păng ŭch ăn bu mbah kŭnh bôk ma khân păng rŏ ntŭk bu tăch rgâl drăp ndơ, mâu lah rŏ trong kuŏng, ndrel ma ŭch ăn bu kuăl khân păng: ‘Nơm nti’. ");
INSERT INTO cmo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lŏng ma khân ay may nây, lơi ôh ăn bu kuăl khân ay may ‘Nơm nti’, yorlah geh du huê ‘Nơm nti’ dơm, jêh ri dâng lĕ rngôch khân ay may jêng oh nô ndrel dadê. ");
INSERT INTO cmo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Lơi ôh kuăl du huê bunuyh ta neh ntu dja ‘Bơ̆’, yorlah khân ay may lĕ geh du huê Bơ̆ i gŭ ta kalơ trôk. ");
INSERT INTO cmo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Lơi ôh kuăl săk khân ay may nơm ‘Nơm nti’, yorlah khân ay may geh du huê nơm nti: Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl. ");
INSERT INTO cmo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yơn ma bu moh păng i kuŏng rlau bu ta phung khân ay may, ăn păng jêng bunuyh i sơm kơl jan kar ăn ma khân ay may. ");
INSERT INTO cmo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bu moh i n'hao êng săk păng nơm, Kôranh Brah njŭr lơi, yơn ma bu moh i njŭr êng săk ŭch iăt păng, Kôranh Brah sơm n'hao păng.” ");
INSERT INTO cmo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ơ phung nơm nti nau vay phung bân, ndrel ma khân may i phung Pharisi! Khân may jan iăt nau Kôranh Brah dơm. Kôranh Brah mra ăn nau rêh rnhăl ngăn ma khân may, yorlah khân may nking lơi trong ta nau Kôranh Brah mât uănh. Khân may nơm mâu ŭch lăp, jêh ri bunuyh i ŭch lăp khân may nking lơi đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ơ phung nơm nti nau vay phung bân, ndrel ma khân may i phung Pharisi! Khân may jan iăt nau Kôranh Brah dơm. Kôranh Brah mra ăn nau rêh rnhăl ngăn ma khân may, yorlah khân may mƀrôh bu ur ndrô lĕ khât sai gay ma sŏ pit drăp ndơ nhih jay khân păng. Khân may jan mbơh sơm dŭt jŏ ngăn ăn bu êng tăng, gay ma nhhơ khân may nơm jêng bunuyh rŏng ma Kôranh Brah ngăn. Ndri dâng Kôranh Brah tê̆ dôih jru rlau bu êng ta nar jât năp tay.” ");
INSERT INTO cmo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ơ phung nơm nti nau vay phung bân, ndrel ma khân may i phung Pharisi! Khân may jan iăt nau Kôranh Brah dơm. Kôranh Brah mra ăn nau rêh rnhăl ngăn ma khân may, yorlah khân may hăn nsong dŭt ngai rŏ kalơ neh, rŏ dak văch dak văr, gay ma jă du huê bunuyh lăp tâng nau vay phung bân. Tât ma lĕ geh bu lăp jêh, khân may jan ăn bunuyh i nây lơ ma hô djơh dŭt hô ngăn, di ma tŭp ta ndrung ŭnh, djơh rlau bar tơ̆ khân may nơm jât.” ");
INSERT INTO cmo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kôranh Brah mra ăn nau rêh rnhăl ngăn ma khân may. Khân may bunuyh leo bu, yơn ma khân may nơm tâm ban ma bunuyh cheh măt, yorlah khân may ngơi kơt nđa: ‘Bu moh ton đah nhih jan brah ma Kôranh Brah, nau ton i nây mâu ôh geh nau khlay, yơn ma bu moh ton đah mayh ta nhih jan brah ma Kôranh Brah, ri mơ nau ton i nây geh nau khlay’. ");
INSERT INTO cmo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ơ mpôl bunuyh mblŭ, khân may tâm ban ma mpôl bunuyh cheh măt! Moh ndơ i geh nau khlay rlau? Mayh i geh ta nhih jan brah, mâu lah nhih jan brah i ăn mayh i nây jêng kloh ueh jêng ndơ Kôranh Brah nơm? ");
INSERT INTO cmo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Khân may lah đŏng: ‘Bu moh ton đah nsưng gŭch pur ndơ jan brah, nau ton i nây mâu ôh geh nau khlay, yơn ma bu moh ton đah ndơ jan brah ta kalơ ntŭk jan brah, ri mơ nau ton i nây dâng geh nau khlay’. ");
INSERT INTO cmo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ơ mpôl bunuyh cheh măt, moh ndơ i geh nau khlay rlau? Ndơ jan brah, mâu lah nsưng gŭch pur ndơ jan brah i ăn ndơ jan brah jêng kloh ueh jêng ndơ Kôranh Brah nơm? ");
INSERT INTO cmo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Lah ndri bu moh ton ma nsưng gŭch pur ndơ jan brah, păng ton ma nsưng gŭch pur ndơ jan brah, ndrel ma dâng lĕ ndơ jan brah i geh ta kalơ nây. ");
INSERT INTO cmo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jêh ri bu moh ton đah nhih jan brah ma Kôranh Brah, păng ton ma nhih i nây, ndrel ma ton đah ma Kôranh Brah i gŭ ta nhih jan brah nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Bu moh ton đah ntŭk Kôranh Brah ta kalơ trôk, păng i nây ton nđâp ma rnơl Kôranh Brah nơm, nđâp ma Kôranh Brah i gŭ ta rnơl i nây.” ");
INSERT INTO cmo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ơ phung nơm nti nau vay phung bân, ndrel ma khân may i phung Pharisi! Khân may jan iăt nau Kôranh Brah dơm. Kôranh Brah mra ăn nau rêh rnhăl ngăn ma khân may, yorlah khân may nơh sŏ ndơ geh jât ơ̆ rhuăt nguai nhhơr ma Kôranh Brah, kơt lah ndơ mâu khlay, klôyh, gir, ndrel ma ndơ ƀô aƀă êng đŏng. Nau i nhhơr jêng di, tih ma khân may mƀăr lơi ndơ i geh nau khlay rlau ma ndơ i nây ta nau vay bân, ndơ i geh nau khlay rlau nây: Nau sŏng, nau yô̆ nđach, ndrel ma nau nsing ma Kôranh Brah. Lah ndri ăn khân may nsrôyh jan nau sŏng, nau yô̆ nđach, ndrel ma nau nsing, jêh ri nhhơr kơt i nây ma Kôranh Brah đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Khân may bunuyh leo bu, yơn ma khân may nơm tâm ban ma bunuyh cheh măt. Khân may nkhĕ lơi rhuay bơh dak ta kchok khân may, gay ma lơi rnguăn, tih ma khân may tâm ban ma rnguăn du mlŏm seh samô!” ");
INSERT INTO cmo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ơ phung nơm nti nau vay phung bân, ndrel ma khân may i phung Pharisi! Khân may jan iăt nau Kôranh Brah dơm. Kôranh Brah mra ăn nau rêh rnhăl ngăn ma khân may, yorlah khân may jêng tâm ban ma bunuyh i rao ngan, rao yăng ta bơh dih dơm, yơn ma ta trôm hôm e uk rmao. Khân may rao ti tâng ma nau vay khân may, tih ma ta nuih n'hâm khân may ri hôm dŭt ŭch ma nau rvan kơnh geh ma drăp ndơ, ndrel ma nau sa nsiăn hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ơ phung Pharisi cheh măt, ăn rao keo rao ngan ta trôm lor ƀŏt, jêh ri rao bơh dih đŏng, ri mơ dâng lĕ kloh dadê.” ");
INSERT INTO cmo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ơ phung nơm nti nau vay phung bân, ndrel ma khân may i phung Pharisi! Khân may jan iăt nau Kôranh Brah dơm. Kôranh Brah mra ăn nau rêh rnhăl ngăn ma khân may, yorlah khân may tâm ban ma môch bu hâng ma dak si nglang, uănh bơh dih tâm ban ma ueh ngăn, tih ma ta trôm ri nting bunuyh khât, ndrel ma ndơ ƀơ̆ ăp ntil ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Khân may tâm ban ma kơt nây ngăn, bu uănh bơh dih jan tâm ban ma bunuyh sŏng, tih ma ta trôm ri nuih n'hâm ndŏp mpôn, ndrel ma mâu jan tâng nau Kôranh Brah ŭch.” ");
INSERT INTO cmo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ơ phung nơm nti nau vay phung bân, ndrel ma khân may i phung Pharisi! Khân may jan iăt nau Kôranh Brah dơm. Kôranh Brah mra ăn nau rêh rnhăl ngăn ma khân may, yorlah khân may jan ueh jay môch ma mpôl bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, ndrel ma nkrơ̆ ueh môch ma phung bunuyh sŏng, ");
INSERT INTO cmo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","jêh ri khân may lah: ‘Lah hên gŭ rêh rnôk phung u che i nây nơh, hên mâu ôh tâm di nau đah khân păng nkhât mpôl bunuyh ntơyh nau ngơi Kôranh Brah’. ");
INSERT INTO cmo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ndri nau khân may ngơi kơt nây, yơn ma khân may hôm kuăl bunuyh i nây u che khân may, kơt ndri khân may lĕ nhhơ nuih n'hâm khân may tâm di ma phung nkhât mpôl bunuyh ntơyh nau ngơi Kôranh Brah i nây. ");
INSERT INTO cmo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lah ndri ăn khân may hôm jan kơt phung u che khân may nây tât lôch hŏm!” ");
INSERT INTO cmo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Yê! Mpôl bunuyh djơh bunuyh janh tâm ban ma bêh ku! Mơm jan khân may hôm dơi klaih bơh Kôranh Brah tê̆ dôih ntŭp ta ndrung ŭnh? ");
INSERT INTO cmo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kơt ndri dâng Gâp njŭn tay mpôl bunuyh ntơyh nau ngơi Kôranh Brah, mpôl bunuyh gĭt blao, ndrel ma phung nơm nti ăn ma khân may, tih ma aƀă khân may nkhât lơi khân păng ta si tâm rkăng, aƀă jât khân may rpăt khân păng ma mŏng rse ta nhih rƀŭn khân may, ndrel ma khân may tâng joi khân păng rŏ ƀon dja ƀon ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lah ndri dâng lĕ mham mpôl bunuyh sŏng i nây krêp ta khân may dadê, jêng ntơm bơh kon Ađăm rnha păng Kain nkhât i oh păng rnha Abel, n'ho ma tât bu nkhât Sakari i kon Ƀarki i u che khân may nkhât păng ta vah vang nhih jan brah, ta nsưng gŭch pur ndơ jan brah ri. Bol lah dâng lĕ bunuyh i nây lĕ bu nkhât bơh kăl e nơh, dôih i nây hôm e tê̆ ma khân may đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gâp lah n'hêl nanê̆ ngăn ma khân may, dâng lĕ dôih dak i nây nsŭn ma bunuyh ta rnôk dja ro.” ");
INSERT INTO cmo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Hơi bunuyh ta ƀon Yêrusalem, bunuyh ta Yêrusalem, khân ay may lĕ nkhât jêh bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, sŏ lŭ ntŭp nkhât lơi i bunuyh Kôranh Brah đă hăn nti khân ay may. Yơn ma lĕ ƀaƀơ ngăn Gâp ŭch rgum khân ay may, tâm ban ma me iăr rtŭk kon ăn gŭ gum ta nâm nar păng. Tih ma khân ay may mâu ôh ŭch. ");
INSERT INTO cmo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lŏng uănh, ƀon khân ay may tay Kôranh Brah ntlơi ngăn, jêng rngol. ");
INSERT INTO cmo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gâp mbơh ma khân ay may, Gâp hăn a khân ay may hôm du tơ̆ dơm, jêh ri tay khân ay may mâu hôm ôh say Gâp jât, n'ho ma tât khân ay may lah: ‘Dăn Kôranh Brah ăn nau geh jêng ma du huê bunuyh dja i Kôranh Brah de đă văch’.” ");
INSERT INTO cmo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nôk Brah Yêsu lôh bơh jŏng gung nhih jan brah ma Kôranh Brah hăn a ri, mpôl oh mon nchŏng dâng lĕ ndơ geh ta nhih jan brah nây ăn Păng say. ");
INSERT INTO cmo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Brah Yêsu lah ma khân păng: “Gâp lah n'hêl nanê̆ ngăn ma khân ay may: Nar jât năp tay, lĕ ndơ i khân ay may say nây bu mra lơh rlŏm lĕ phiao ro, mâu hôm ôh geh du mlŏm lŭ blon tâm rdăp jât.” ");
INSERT INTO cmo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nôk Brah Yêsu gŭ ta yôk tơm Ôlive, mpôl oh mon hăn êng a Păng, ôp Păng: “Hơi Nơm Nti, lŏng May mbơh ăn ma hên gĭt đŏng, dah hôm jŏ nar tât nau i nây mêh? Lah ndri moh ndơ mbên ăn ma hên gĭt lah nar May plơ̆ văch, ndrel ma ta nar n'glĕ dŭt neh ntu tay?” ");
INSERT INTO cmo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Brah Yêsu lah ma khân păng: “Ăn khân ay may njrăng ngăn hŏ. Lơi dâng ôh ăn bu mƀrôh ndơm khân ay may nhhơt lă lêng. ");
INSERT INTO cmo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yor ma nar jât năp tay geh ŏk bu ntup rnha Gâp: ‘Gâp dja Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl heh!’, khân păng leo nhhơt bunuyh ŏk ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Khân ay may mra tăng nau mhe ma nau tâm lơh tâm sreh, ndrel ma tăng bu nkoch nchroh ma nau tâm lơh tâm sreh. Lơi ôh klach, yorlah lĕ nau i nây păng geh ngăn ro, yơn ma nar n'glĕ dŭt neh ntu ê hŏ ôh tât. ");
INSERT INTO cmo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Du mpôl tâm lơh đah du mpôl êng jât, du bri dak tâm lơh đah du bri dak jât. Geh nau ji sŏt ji ngot kuŏng, ndrel ma geh nau n'găr neh ta ntŭk êng êng. ");
INSERT INTO cmo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yơn ma nau jêr i nây jêng ntơm nau jêr dơm, tâm ban ma nau bu ur ntơm tât ji ndŭl gŭ oh. ");
INSERT INTO cmo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nôk nây bu njŭn khân ay may ăn bu nkrit jan jêr, ndrel ma bu nkhât lơi khân ay may. Dâng lĕ bunuyh ta bri dak ta neh ntu dja bu rngơ̆ biănh ngăn ma khân ay may ach ma tâng Gâp. ");
INSERT INTO cmo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ta nôk nây geh ŏk bunuyh mƀăr nau nsing ma Gâp, jêh ri tâm mƀrôh ndrăng nơm gay ma njŭn ăn bu jan jêr, ndrel ma tâm rngơ̆ biănh ndrăng nơm. ");
INSERT INTO cmo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mra geh ŏk bunuyh ntơyh nklă nau ngơi Kôranh Brah leo ŏk bunuyh hiơt. ");
INSERT INTO cmo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jêh ri yor ma nau jan tih ma nau Kôranh Brah ŭch lơ ma ŏk, nau rŏng bunuyh ŏk lơ ma roh. ");
INSERT INTO cmo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yơn ma bu moh i dơi nsrôyh n'ho ma tât lôch, Kôranh Brah mra rklaih păng i nây. ");
INSERT INTO cmo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nau mhe mhan ueh ma nau Kôranh Brah mât uănh dja bu mbơh nkoch lam neh ntu, gay ma dâng lĕ bunuyh dâng lĕ bri dak tăng nau khlay i nây, ri mơ nar n'glĕ dŭt neh ntu tât.” ");
INSERT INTO cmo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Tât khân ay may say ndơ dŭt ƀơ̆ ƀơch bu tê̆ ta ntŭk kloh ueh i bunuyh ntơyh nau ngơi Kôranh Brah rnha Daniel de lĕ mbơh nkoch kăl e nơh - bu moh i rŏ nau i nây ăn păng gĭt vât nau i nây - ");
INSERT INTO cmo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","jêh say ndơ i nây bunuyh i gŭ ta bri Yuđa ri ăn du nchuăt nde ta yôk. ");
INSERT INTO cmo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bu moh i gŭ kalơ chor jay lŏng, lơi hôm ôh jŭr lăp ta trôm sŏ drăp ndơ. ");
INSERT INTO cmo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bu moh i gŭ ta mir, lơi hôm đŏng plơ̆ ta jay sŏ ao kuŏng. ");
INSERT INTO cmo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nôk nây bu ur ntreo, bu ur mpu toh kon geh nau rêh rnhăl hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ăn khân ay may mbơh sơm dăn ma Kôranh Brah hŏm, gay ma lơi ôh geh nau nchuăt du i nây ta nôk khay ji kăt, mâu lah ta nar Saƀăt i nar rlu bân, ");
INSERT INTO cmo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","yorlah ta nôk nây geh nau jêr jŏt hô ngăn. Ntơm bơh rnôk ntơm geh neh ntu dja tât aƀaơ dja, n'ho ma nar n'glĕ dŭt neh ntu tay, mâu prot geh nau dŭt jêr kơt nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Lah Kôranh Brah mâu n'hŭch lơi dâng lĕ nar nây, ndri mâu hôm ôh geh du huê bunuyh rêh, khât lĕ phiao. Yơn ma Kôranh Brah n'hŭch lơi nar i nây, yor ma nau yô̆ mpôl i lĕ Păng kơih. ");
INSERT INTO cmo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ta nôk nây lah geh bu mbơh ma khân ay may: ‘Lŏng khân ay may uănh Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl gŭ ta dja!’, mâu lah ‘Gŭ ta to!’, lơi ôh iăt bu, ");
INSERT INTO cmo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","yor ma geh bunuyh ntup lah săk păng Brah Krist, ndrel ma geh bunuyh ntup lah săk păng bunuyh ntơyh nau ngơi Kôranh Brah. Khân păng i nây jan nau mbên i khlay kuŏng êng êng đŏng, gay ma leo bunuyh ăn nhhơt lă lêng, nkhêp lah dơi leo nhhơt phung i Kôranh Brah lĕ kơih đŏng, yơn ma mâu ôh dơi. ");
INSERT INTO cmo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ăn njrăng hŏ! Ndri dâng Gâp mbơh nkoch ăn khân ay may gĭt lor. ");
INSERT INTO cmo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Lah geh bu lah ma khân ay may: ‘Brah Krist gŭ ta bri rdah!’, khân ay may lơi ôh hăn uănh. Mâu lah, lah bu lah ma khân ay may: ‘Brah Krist gŭ krap ta trôm jrô!’, khân ay may lơi đŏng iăt nau bu. ");
INSERT INTO cmo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yorlah nar Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch, tâm ban ma lơp nglayh ang bơh jŏng trôk du ding tât ma jŏng trôk du ding. Kơt nây đŏng lam neh ntu mra gĭt say nar Gâp plơ̆ văch. ");
INSERT INTO cmo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ah ntŭk geh ndơ khât, grŏt mra rgum băl mpăr ndăch ta ntŭk i nây đŏng, kơt ndri ndơ i nây ăn mpơl ma bunuyh say bơh ngai.” ");
INSERT INTO cmo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Lôch jêh nar jêr jŏt i nây ro ‘Ta nôk nây nar jêng ngo, Khay mâu hôm ôh ang, Mănh mbing đuh bơh trôk, Lĕ ndơ i têh kuŏng kalơ trôk n'gơ dadê’. ");
INSERT INTO cmo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nôk nây ta trôk mpơl ndơ gĭt mbên Gâp i Kon Bunuyh tă bơh Kôranh Brah de njuăl. Jêh ri dâng lĕ mpôl bunuyh ta neh ntu dja nhŭm nđor. Khân păng mra say Gâp i Kon Bunuyh tă bơh Kôranh Brah de njuăl hăn rŏ ndŏr tŭk ta kalơ trôk, nđâp ma nau dơi, ndrel ma nau chrêk lơp dŭt hô. ");
INSERT INTO cmo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jêh ri Gâp njuăl phung tông păr Gâp hăn ăp puăn njônh bri lam neh ntu, ndrel ma ôh nŭng dŭt nteh, gay ma rgum lĕ mpôl i Kôranh Brah nơm lĕ kơih nơh bơh jŏng trôk du ding tât ma jŏng trôk du ding.” ");
INSERT INTO cmo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ăn khân ay may gĭt nklŏn dô nau ntât ma tơm Rvi dja: Lah n'ging păng geh chăt n'ha nse nđâr, khân ay may gĭt lah khay ta mih bơi tât hơyh. ");
INSERT INTO cmo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ndri lah khân ay may say dâng lĕ nau i nây lĕ tât, gĭt ro Gâp i Kon Bunuyh tă bơh Kôranh Brah bơi tât đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, lĕ nau dja păng tât dôl bunuyh ta rnôk aƀaơ dja hôm rêh. ");
INSERT INTO cmo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Trôk neh ntu mra roh lêk ro, yơn ma nau Gâp ngơi mâu ôh blao roh lêk, hôm geh dâng lĕ ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mong nar i nây mâu ôh geh du huê bunuyh dơi gĭt, bol lah tông păr ta kalơ trôk i ntŭk Kôranh Brah, mâu lah Gâp i Kon Kôranh Brah mâu dơi gĭt đŏng, geh du huê Bơ̆ Gâp dơm dơi gĭt. ");
INSERT INTO cmo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ta nôk Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch nây, jêng tâm ban ma rnôk Nôê kăl e nơh đŏng, ");
INSERT INTO cmo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ê lor ma geh dak lêng dak dơng kuŏng. Rnôk nây bunuyh gŭ nhêt sông sa, nđăp ur sai, lơh mir jan ba, n'ho ma tât nar Nôê lăp ta trôm duk kuŏng ri. ");
INSERT INTO cmo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Khân păng mâu gĭt ôh nar dak lêng dak dơng lĕ tât jêh, n'ho ma bŭk khân păng lĕ phiao. Ta nar Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch tay tâm ban kơt i nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nôk nây lah geh bar hê bunuyh gŭ ta mir, du huê Kôranh Brah sŏ ma ăn gŭ ta ƀon ueh ta kalơ, hôm rong du huê ma tê̆ dôih. ");
INSERT INTO cmo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Lah geh bar hê bu ur gŭ peh tâm răp, Kôranh Brah sŏ du huê ăn gŭ ta ƀon ueh ta kalơ, hôm rong du huê ma tê̆ dôih. ");
INSERT INTO cmo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lah ndri khân ay may gŭ njrăng nâng, yorlah mâu gĭt ôh moh mong Kôranh khân ay may văch. ");
INSERT INTO cmo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ăn khân ay may gĭt nau dja: Lah bunuyh tơm jay gĭt mong bu hăn ntŭng ta măng, păng rngeh mâu ôh ƀok gor ăn bunuyh ntŭng i nây lăp ta jay păng. ");
INSERT INTO cmo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Lah ndri ăn khân ay may gŭ njrăng tâm ban đŏng, yorlah Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch ta mong khân ay may mâu geh mân.” ");
INSERT INTO cmo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Bu moh i tâm ban ma du huê dâk i geh nuih n'hâm sŏng, ndrel ma lĕ blao ngăn? Kôranh jao păng mât uănh dâng lĕ dâk a êng ta jay, ndrel ma ăn păng pă ndơ sông sa tâm di mong ăn ma khân păng đŏng. Jêh ri kôranh păng hăn ta ntŭk ngai jŏ nar. ");
INSERT INTO cmo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nôk kôranh păng sât tât ta jay ri, hôm say păng jan kar kơt nây, dâk i nây geh nau ueh ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, kôranh i nây mra ăn dâk i nây mât uănh dâng lĕ ndơ păng geh. ");
INSERT INTO cmo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yơn ma lah dâk i nây djơh, păng geh lah êng ta nuih n'hâm păng nơm ri: ‘Kôranh gâp jŏ ngăn sât, mâu ôh gơnh sât’. ");
INSERT INTO cmo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jêh ri păng ntơm rpăt mbang dâk a êng, ndrel ma sông sa nhêt ndrănh ndrel bunuyh hay nhêt. ");
INSERT INTO cmo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jêh ri kôranh dâk i nây plơ̆ sât tât ta ri, ta nar dâk i nây mâu ôh geh njrăng, ta mong păng mâu đŏng geh gĭt lor. ");
INSERT INTO cmo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kôranh nkrit păng ro, ndrel ma ăn păng gŭ ta ntŭk phung jan iăt nau Kôranh Brah dơm đŏng. Ta ntŭk nây geh nhhiăng nhŭm, ndrel ma rchiăt sêk.” ");
INSERT INTO cmo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Nôk nây nau Kôranh Brah mât uănh tâm ban ma bu ur drôh jât nuyh hăn vơt sai mhe a măng. Khân păng ndjôt ŭnh sagêng ăp bunuyh. ");
INSERT INTO cmo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Geh prăm nuyh ta mpôl khân păng nây mâu geh ôh nau mân, yơn ma geh prăm nuyh geh nau mân. ");
INSERT INTO cmo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mpôl i mâu geh nau mân nây, ndjôt dơm dak pring ta sagêng, tih ma mâu geh ôh ndjôt rnă. ");
INSERT INTO cmo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yơn ma mpôl i geh nau mân, khân păng ndjôt dak pring ta sagêng, ndrel ma geh ndjôt rnă ta đop đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yor ma kŏp sai mhe i nây jŏ ngăn tât, khân păng ji bêch n'ho ma hăk lêr khêr. ");
INSERT INTO cmo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tât n'gul măng ri, tăng bu nter: ‘Sai mhe lĕ tât jêh! Ran vơt păng hŏm!’ ");
INSERT INTO cmo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dâng lĕ bu ur drôh i nây dâk, ndrăp sagêng bu ma he ro. ");
INSERT INTO cmo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mpôl i mâu geh nau mân lah ma mpôl i geh nau mân: ‘Dăn pă ăn hên ƀă dak pring ơ, yorlah ŭnh sagêng hên bơi ma nhhăt’. ");
INSERT INTO cmo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mpôl i geh nau mân ơh: ‘Mâu ôh, lah hên pă ăn khân ay, mă ma hên nơm, mă ma khân ay. Ăn khân ay hăn ta ntŭk bu tăch pring ri rvăt dô!’ ");
INSERT INTO cmo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yơn ma ndŭt khân păng hăn rvăt pring, sai mhe tât ro. Lŏng mpôl bu ur i lĕ gŭ ndrăp săk leo băl lăp rngăt ta trôm jay ntâl mpông, jêh ri sông sa. ");
INSERT INTO cmo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jŏ du ƀlât tât mpôl bu ur i mâu geh nau mân ri nter: ‘Ơ kôranh, ơ kôranh! Pơ̆ mpông ăn hên ơ!’ ");
INSERT INTO cmo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Yơn ma kôranh mâu ôh ăn lăp, păng ơh: ‘Gâp lah n'hêl nanê̆ ngăn ma khân ay, gâp mâu ôh gĭt năl khân ay’. ");
INSERT INTO cmo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Lah ndri ăn gŭ njrăng hŏm, yorlah khân ay may mâu gĭt ôh Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch moh mong, nar mâu gĭt đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Nau Kôranh Brah mât uănh tâm ban ma du huê bu klô, ê lor ma păng hăn ƀon ngai, păng kuăl phung dâk păng, jêh ri jao drăp ndơ ma khân păng ăn mât uănh. ");
INSERT INTO cmo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Du huê păng ăn 5000, du huê păng ăn 2000, du huê jât păng ăn 1000. Păng ăn du huê du huê tâng i nau khân păng blao. Jêh ri i păng nơm nây du lôh bơh ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nơm i dơn 5000 ri, păng sŏ prăk i nây hăn tăch rgâl ro, păng hao geh 5000 jât. ");
INSERT INTO cmo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nơm i dơn 2000 tâm ban kơt nây đŏng, păng sŏ prăk hăn tăch rgâl hao geh 2000 jât. ");
INSERT INTO cmo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lŏng nơm i dơn 1000 ri, păng kuyh ntu tŏp lơi prăk i kôranh păng ăn ri. ");
INSERT INTO cmo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tât jŏ nar bơh kơi sât i kôranh khân păng i nây bơh ri, păng ôp prăk tâng rnoh ŏk păng ăn ma khân păng ri nơh. ");
INSERT INTO cmo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nơm i dơn prăk 5000 ri nơh hăn ta bơh năp păng ri, ndjôt prăk i hao 5000 ri nơh jât, lah ma kôranh păng: ‘Ơ kôranh, may ăn prăk ma gâp nơh 5000, aƀaơ dja hao geh 5000 jât’. ");
INSERT INTO cmo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kôranh lah ma păng: ‘Ueh ngăn! Ơ dâk ueh geh nuih n'hâm răp jăp, ndơ jê̆ gâp ăn, may jan lĕ răp jăp. Gâp mra ăn may mât uănh ndơ kuŏng jât. Lăp hŏm gŭ maak ndrel gâp nơm’. ");
INSERT INTO cmo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nơm i dơn prăk 2000 ri nơh, ndjôt prăk i hao 2000 jât, hăn ndơ̆ a kôranh păng, lah kơt ndri đŏng: ‘Ơ kôranh! May ăn prăk ma gâp nơh 2000, aƀaơ dja hao geh 2000 jât’. ");
INSERT INTO cmo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kôranh păng ơh: ‘Ueh ngăn! Ơ bunuyh jan kar ueh geh nuih n'hâm sŏng, ndơ jê̆ gâp ăn, may jan lĕ sŏng. Gâp mra ăn may mât uănh ndơ kuŏng jât. Lăp hŏm gŭ maak ndrel gâp nơm’. ");
INSERT INTO cmo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jêh ri nơm i dơn prăk 1000 ri nơh hăn a kôranh păng đŏng, lah ma păng: ‘Ơ kôranh! Gâp gĭt may jêng bunuyh janh ngăn. Yorlah may kăch ta ntŭk may mâu prot tuch, jêh ri rek ta ntŭk mâu prot tăm. ");
INSERT INTO cmo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kơt ndri gâp sŏ prăk i may ăn ma gâp nơh tŏp lơi, yorlah gâp klach hô ir ngăn. Dja prăk may nơm sŏ hŏm’. ");
INSERT INTO cmo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Yơn ma kôranh păng ơh: ‘Ơ bunuyh jan kar djơh mhĭk, ndrel ma rleh ƀlao! May gĭt gâp kăch ta ntŭk gâp mâu prot tuch, jêh ri rek ta ntŭk mâu prot tăm. ");
INSERT INTO cmo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Lah ndri di lah ăn may sŏ prăk i nây ăn ta jay bu tăch rgâl, tât gâp plơ̆ sât, gâp geh prăk ơm, geh nđâp ma lôh kon păng đŏng! ");
INSERT INTO cmo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Lah ndri khân may sŏ hŏm prăk bơh păng dja ăn ma bunuyh i geh 10000. ");
INSERT INTO cmo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kơt ndri bu moh i lĕ geh, bu kơi ntop ăn tay, ăn geh ŏk rmeh jât. Yơn ma bu moh i mâu geh ôh, bu rhuăt lơi nđâp ma moh ndơ i păng lĕ geh đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Lŏng bunuyh i jan kar mâu geh nau khlay dja, nhŭp mƀăr lơi păng ta ntŭk ngo bơh dih, ta ntŭk nây nhhiăng nhŭm, ndrel ma rchiăt sêk!’” ");
INSERT INTO cmo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nôk Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch nđâp ma nau chrêk lơp Gâp, ndrel ma dâng lĕ phung tông păr, nôk nây Gâp gŭ ta rnơl kađăch chrêk lơp Gâp nơm. ");
INSERT INTO cmo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nôk nây dâng lĕ bunuyh dâng lĕ ndŭl mpôl văch gum ta Gâp dadê. Gâp tâm nkhah lơi khân păng, tâm ban ma bunuyh chiăp tâm nkhah be biăp đah be. ");
INSERT INTO cmo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Bunuyh i tâm ban ma be biăp Gâp ăn gŭ bơh ma, bunuyh i tâm ban ma be Gâp ăn gŭ bơh chiao. ");
INSERT INTO cmo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nôk nây Gâp i kađăch lah ma phung gŭ bơh ma Gâp ntŭk bu lư: ‘Ơ phung lĕ Bơ̆ Gâp ăn nau geh jêng jêh! Văch hŏm, lăp gŭ ta nau Kôranh Brah mât uănh i lĕ Păng ndrăp ăn ma khân ay may ntơm bơh njêng neh ntu nơh. ");
INSERT INTO cmo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yorlah nôk Gâp ji ngot khân ay may lĕ ăn ndơ sông sa ma Gâp, nôk Gâp ji hir khân ay may ăn dak Gâp nhêt, nôk Gâp jêng bu năch i khân ay may mâu gĭt năl, khân ay may hôm rom ăn gŭ, ");
INSERT INTO cmo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nôk Gâp gŭ săk kuh khân ay may ăn bok ao nsoh, nôk Gâp geh nau ji khân ay may hăn chop, nôk Gâp geh ndrung khân ay may hăn khŏl kơl Gâp đŏng’. ");
INSERT INTO cmo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jêh ri phung sŏng lah ma Gâp: ‘Ơ Kôranh! Hên mâu prot ôh say May ji ngot, jêh ri ăn May sông, mâu lah ji hir dak ăn dak May nhêt. ");
INSERT INTO cmo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hên mâu prot ôh say May jêng bu năch i hên mâu gĭt năl, jêh ri rom May lăp jay, mâu lah say May gŭ săk kuh hên ăn bok ao ma May. ");
INSERT INTO cmo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Hên mâu prot đŏng say May geh nau ji, mâu lah geh ndrung, jêh ri hăn chop khŏl kơl May’. ");
INSERT INTO cmo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jêh ri Gâp i kađăch lah ma khân păng: ‘Gâp lah n'hêl nanê̆ ngăn ma khân ay may, ăp tơ̆ khân ay may lĕ geh jan nau i nây ma du huê bunuyh i dŭt jê̆ ta nâm bu ta phung oh nô Gâp, tâm ban ma khân ay may lĕ geh jan ăn ma Gâp đŏng’. ");
INSERT INTO cmo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jêh ri Gâp lah ma phung i gŭ bơh chiao Gâp: ‘Ơ phung lĕ Kôranh Brah rak rtăp! Rŭch du ngai hŏm bơh Gâp hăn ta ndrung ŭnh hit mro mrăng, jêng ntŭk ndrăp ma tê̆ dôih Satăng i kôranh mpôl brah djơh, ndrel ma phung i tâng păng! ");
INSERT INTO cmo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yorlah nôk Gâp ji ngot khân ay may mâu ăn Gâp sông, nôk Gâp ji hir khân ay may mâu ăn dak Gâp nhêt, ");
INSERT INTO cmo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nôk Gâp jêng bu năch i khân ay may mâu gĭt năl, khân ay may mâu rom gŭ, nôk Gâp gŭ săk kuh khân ay may mâu ăn bok ao ma Gâp, Gâp geh nau ji, ndrel ma geh ndrung khân ay may mâu hăn khŏl kơl Gâp đŏng’. ");
INSERT INTO cmo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jêh ri phung i nây ơh ma Gâp: ‘Ơ Kôranh! Hên mâu prot ôh say May ji ngot, ji hir dak, jêng bu năch i hên mâu gĭt năl, gŭ săk kuh, geh nau ji, mâu lah geh ndrung, jêh ri mâu geh kơl May!’ ");
INSERT INTO cmo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jêh ri Gâp lah tay ma khân păng: ‘Gâp lah n'hêl nanê̆ ngăn ma khân ay may, ăp tơ̆ khân ay may mâu geh ôh jan nau i nây ma du huê bunuyh i dŭt jê̆ ta nâm bu ta phung oh nô Gâp, lah ndri jêng tâm ban ma khân ay may mâu geh đŏng jan ma Gâp’. ");
INSERT INTO cmo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Lŏng dâng lĕ phung i nây hăn ta ntŭk tê̆ dôih n'ho ro, yơn ma phung sŏng geh nau rêh n'ho ro.” ");
INSERT INTO cmo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jêh Brah Yêsu lah kơt nây, jêh ri Păng lah ma mpôl oh mon Păng: ");
INSERT INTO cmo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Khân may lĕ gĭt jêh hôm bar nar jât di nar nhêt ƀŭn n'hot, jêh ri bu nhŭp njŭn Gâp i Kon Bunuyh tă bơh Kôranh Brah ăn bu nkhât ta si tâm rkăng.” ");
INSERT INTO cmo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nôk nây mpôl kôranh jan brah, ndrel ma phung kôranh ƀon lan gŭ rƀŭn ta jay kôranh jan brah dŭt kuŏng, rnha păng Kaiphas, ");
INSERT INTO cmo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","jêh ri tâm nchră băl joi nau, mơm dâng geh nhŭp ntŭng Brah Yêsu nkhât lơi. ");
INSERT INTO cmo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yơn ma khân păng tâm nchră băl lah: “Lơi ôh bân nhŭp ta nôk jan ƀŭn, klach lah geh nau uh ah tah tŏr ma phung ƀon lan.” ");
INSERT INTO cmo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nôk Brah Yêsu gŭ ta ƀon Ƀêthani, Păng gŭ ta jay Simôn bunuyh tă phŭng sa. ");
INSERT INTO cmo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nôk Păng sông sa ndrel, geh du huê bu ur brô̆ tât lăp ta jay nây ndjôt du mlŏm đop lŭ. Ta trôm đop nây geh ngi ƀô kah i khlay ngăn. Jêh ri păng tŏ dak ngi ƀô kah ta bôk Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yơn ma mpôl oh mon say kơt nây ji nuih, khân păng lah: “Moh jan mpŭng mpăng kơt nây! ");
INSERT INTO cmo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Lah sŏ dak ngi i nây tăch geh prăk ŏk ngăn, jêh ri pă ăn bunuyh o ach!” ");
INSERT INTO cmo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yơn ma Brah Yêsu gĭt nau khân păng ngơi, Păng lah ma khân păng: “Mơm dâng khân may jan ăn bu ur i nây geh nau rngot kơt nây? Păng lĕ jan nau ueh ăn ma Gâp. ");
INSERT INTO cmo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bunuyh o ach hôm gŭ ndrel khân may mro, yơn ma Gâp dja mâu ôh gŭ ndrel khân may mro. ");
INSERT INTO cmo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yôh dja tŏ dak ngi ƀô kah ta săk Gâp, păng ndrăp tŏp Gâp ta môch. ");
INSERT INTO cmo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Gâp lah n'hêl nanê̆ ngăn ma khân may, ăp ntŭk bu hăn mbơh nkoch nau mhe mhan ueh dja lam n'gor bri ta neh ntu dja, bu nkoch ma nau i păng jan nơh đŏng, gay ma nkah tôr bu bah chuêl păng.” ");
INSERT INTO cmo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nôk nây geh du huê oh mon ta mpôl kôranh oh mon 12 nuyh ri, rnha păng Yuđas-Isakariyôt, păng hăn mâp mpôl kôranh jan brah, ôp khân păng: ");
INSERT INTO cmo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Moh ndơ khân may ăn ma gâp, lah gâp njŭn bunuyh i nây ma khân may?” Khân păng ăn prăk ma păng 30 kăk prăk. ");
INSERT INTO cmo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ntơm bơh nôk nây Yuđas-Isakariyôt joi mong i ueh, gay ma leo bu hăn nhŭp Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ta nar lăp nhêt ƀŭn nŭmpăng mâu geh ndrui, mpôl oh mon hăn a Brah Yêsu ôp Păng: “Hơi Kôranh, ah ntŭk May ŭch ăn hên ndrăp ma May nhêt sông ƀŭn n'hot dja mêh?” ");
INSERT INTO cmo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Brah Yêsu lah ma khân păng: “Khân may hăn ta ƀon kuŏng Yêrusalem ri, hăn ta du huê bu klô i nây, lah ma păng: ‘Nơm nti lah, nar nau jêr jŏt Gâp bơi tât jêh, Gâp ŭch ndrăp nhêt ƀŭn n'hot ndrel mpôl oh mon Gâp ta jay may’.” ");
INSERT INTO cmo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jêh ri mpôl oh mon jan tâng nau Brah Yêsu đă ma khân păng, n'ho ma khân păng ndrăp ndơ sông sa ma nau nhêt ƀŭn n'hot ta ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tât kêng măng Brah Yêsu gŭ ta nsưng ndrel 12 nuyh mpôl kôranh oh mon Păng. ");
INSERT INTO cmo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nôk gŭ sông sa Păng lah kơt nđa: “Gâp lah n'hêl nanê̆ ngăn ma khân may, ta mpôl khân may geh du huê leo bu hăn nhŭp Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Dâng lĕ mpôl kôranh oh mon rvê hô ngăn, khân păng ôp Brah Yêsu: “Ơ Kôranh! Gĭt gâp hơ?” ");
INSERT INTO cmo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Brah Yêsu lah ma khân păng: “Bu moh păng i lŭp nŭmpăng ta ngan ndrel Gâp, păng i nây leo bu hăn nhŭp Gâp. ");
INSERT INTO cmo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gâp i Kon Bunuyh tă bơh Kôranh Brah bu mra nkhât, tâng ma nau lĕ nchih lah ma nau Gâp. Tih ma păng i leo bu hăn nhŭp Gâp i Kon Bunuyh tă bơh Kôranh Brah nây, păng i nây geh nau rêh rnhăl ngăn ro, ueh rlau lơi dâng deh păng i nây nơh.” ");
INSERT INTO cmo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuđas-Isakariyôt i nơm leo bu hăn nhŭp Păng ri lah: “Ơ Nơm Nti! Gĭt gâp hơ?” Brah Yêsu lah ma păng: “Di kơt nau may lah nây ngăn!” ");
INSERT INTO cmo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Khân păng hôm gŭ sông sa, jêh ri Brah Yêsu sŏ du mlŏm nŭmpăng, lah ueh ma Kôranh Brah, jêh ri gĭch ăn mpôl oh mon sa, n'ho ma lah: “Khân may sŏ sa yơ̆, dja i săk jăn Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jêh ri Păng sŏ kchok ndrănh play yŭng yar ƀon lah ueh ma Kôranh Brah, Păng ndơ̆ ăn ma khân păng, jêh ri lah: “Nhêt dâng lĕ ma băl hŏm, ");
INSERT INTO cmo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","yorlah ndrănh play yŭng yar ƀon ta kchok dja i mham Gâp, i hoch bơh săk jăn Gâp nôk Gâp khât tay, gay ma yô̆ bunuyh mâu hôm ôh kơp nau tih khân păng. Ma mham i dja Kôranh Brah jan nau tâm rnglăp mhe. ");
INSERT INTO cmo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Gâp mbơh ăn ma khân may gĭt, Gâp mâu hôm ôh nhêt ndrănh play yŭng yar ƀon dja jât, n'ho ma tât nar Gâp nhêt ndrănh play yŭng yar ƀon mhe tât nau Bơ̆ Gâp mât uănh lĕ tât ngăn mơ.” ");
INSERT INTO cmo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jêh mprơ rnê, Brah Yêsu ndrel mpôl oh mon Păng lôh bơh nây hăn jât yôk tơm Ôlive. ");
INSERT INTO cmo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Brah Yêsu lah ma mpôl oh mon Păng: “Dâng lĕ khân may ntlơi Gâp ta măng dja, yor ma ta Nau Kôranh Brah Ngơi lĕ geh nchih: ‘Kôranh Brah lah: ‘Gâp mbang nkhât lơi nơm chiăp be biăp, Jêh ri phung be biăp du chah chrai lĕ’’. ");
INSERT INTO cmo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yơn ma jêh Gâp dâk rêh tay, Gâp hăn tât lor bơh năp khân may ta bri Galilê.” ");
INSERT INTO cmo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jêh tăng Brah Yêsu ngơi ndri Pêtrôs lah ma Păng: “Bol lah dâng lĕ khân păng ntlơi May kađôi, du njăr nau rêh gâp, gâp mâu ôh ntlơi May.” ");
INSERT INTO cmo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Brah Yêsu lah ma păng: “Gâp lah n'hêl nanê̆ ngăn ma may: Ta măng dja ro, ê lor ma iăr ndrau, may rlăch pe tơ̆ lah mâu gĭt năl Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pêtrôs lah ma Brah Yêsu: “Mâu ôh! Bol lah bu nkhât Gâp ndrel may kađôi, Gâp mâu geh ôh rlăch lah mâu gĭt năl may.” Dâng lĕ mpôl oh mon aƀă lah kơt păng dadê đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jêh ri Brah Yêsu, ndrel ma phung oh mon Păng hăn jât du ntŭk rnha Gêtsêmanê. Păng lah: “Khân may gŭ ta dja ƀŏt yơ̆. Gâp hăn mbơh sơm a to ƀŏt.” ");
INSERT INTO cmo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Brah Yêsu jă Pêtrôs, ndrel ma bar hê i kon Sêƀêđê hăn ndrel Păng. Nôk nây ta nuih n'hâm Brah Yêsu ntơm geh nau rngot, ndrel ma geh nau ôh nuih ôh n'hâm hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Păng lah ma pe nuyh khân păng nây: “Nuih n'hâm Gâp rngot hô ngăn ndă ma khât ro. Khân may hôm gŭ ta dja ƀŏt, gŭ rngeh njrăng ndrel Gâp hŏ.” ");
INSERT INTO cmo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jêh ri Brah Yêsu hăn jât năp đê̆, păn truyh a neh mbơh sơm dăn: “Ơ Bơ̆! Lah dơi, dăn May sŏ nau jêr jŏt dja ăn du ngai bơh Gâp, yơn ma lơi tâng nuih n'hâm Gâp ŭch ôh, ăn tâng nau May nơm ŭch hŏ.” ");
INSERT INTO cmo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jêh ri Păng plơ̆ jât mpôl oh mon nây, say khân păng hăk bêch, Păng lah ma Pêtrôs: “Mơm khân may gŭ rngeh ndrel Gâp du mong mâu dơi đŏng! ");
INSERT INTO cmo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Khân may njrăng hŏm n'ho ma mbơh sơm, gay ma mâu jan tih nôk geh nau ndơm. Nuih n'hâm bunuyh lĕ ŭch jan di ngăn, tih ma mâu ôh blao jan, yor ma hôm rdja.” ");
INSERT INTO cmo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jêh ri Păng plơ̆ mbơh sơm tay du tơ̆ jât: “Ơ Bơ̆! Lah nau jêr dja mâu ôh dơi ƀah ngai bơh Gâp, lah ndri tâng nau May nơm ŭch!” ");
INSERT INTO cmo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tât Brah Yêsu plơ̆ tay ta mpôl oh mon ri, say khân păng hôm hăk bêch dadê, lin măt mâu dơi. ");
INSERT INTO cmo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Păng hăn bơh ntŭk nây du tơ̆ jât, plơ̆ mbơh sơm ăp pe tơ̆, Păng mbơh sơm kơt nau ơm. ");
INSERT INTO cmo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jêh ri Păng plơ̆ tay ta phung oh mon ri, lah ma khân păng: “Khân may hôm bêch dah jŏ ma kah? Lŏng aƀaơ dja mong lĕ tât jêh, bu njŭn Gâp i Kon Bunuyh tă bơh Kôranh Brah ăn ma phung bunuyh tih. ");
INSERT INTO cmo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Dâk hŏm leo băl hăn, nơm i leo bu hăn nhŭp Gâp, lĕ bơi tât hơi!” ");
INSERT INTO cmo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Dôl Brah Yêsu hôm ngơi nây tât Yuđas-Isakariyôt i du huê bunuyh ta 12 nuyh mpôl kôranh oh mon nây. Geh du phung kuŏng hăn ndrel păng nây, ndjôt mŏng ndjôt đao. Khân păng i nây tă bơh mpôl kôranh jan brah, ndrel ma phung kôranh ƀon lan de đă. ");
INSERT INTO cmo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuđas-Isakariyôt i leo bu hăn nhŭp Brah Yêsu nây lĕ jêh mbơh du ntil nau ăn gĭt năl ma bu lah: “Bu moh i gâp chŭm, Păng i ri ro, ndri khân may nhŭp Păng dô.” ");
INSERT INTO cmo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yuđas-Isakariyôt tât ta ri, păng hăn jât Brah Yêsu, ôp Brah Yêsu: “Ueh lăng Nơm Nti!” Jêh ri chŭm Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Brah Yêsu ôp păng: “Ơ jăng! Moh ndơ may hăn ta dja ŭch jan, may jan hŏm!” Jêh ri bu nhŭp krŭp Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dô ma say geh du huê ta phung gŭ ndrel Brah Yêsu, tăk đao sreh tăch tôr du ding dâk kôranh jan brah dŭt kuŏng. ");
INSERT INTO cmo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Brah Yêsu lah ma păng i nây: “Ntrŭp hŏm đao may nây ta ndrôm, yorlah bu moh i dŏng đao, păng khât ma đao đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gĭt may nđôn lah Gâp mâu ôh dơi dăn ma Bơ̆ Gâp, jêh ri Păng njuăl phung tông păr rlau ma 12 phung, du phung geh 6000 nuyh hăn kơl Gâp ro? ");
INSERT INTO cmo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yơn ma lah jan kơt nây, mơm dâng geh ma di đah Nau Kôranh Brah Ngơi lĕ geh nchih ăn geh nau dja ngăn?” ");
INSERT INTO cmo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jêh ri Brah Yêsu lah ma phung i nây: “Moh brô̆ khân may ndjôt nđâp ma mŏng ma đao kơt nây, kơp Gâp jêng bunuyh ntŭng bơh? Ăp nar kăl dơ̆ nơh, Gâp gŭ ntŭm nti ta jŏng gung nhih jan brah. Khân may gŭ ta nây đŏng, mâu ôh say nhŭp Gâp. ");
INSERT INTO cmo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dâng lĕ nau dja geh ngăn, gay ma jêng di kơt nau mpôl bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ nchih ta Nau Kôranh Brah Ngơi.” Jêh ri mpôl oh mon nchuăt lĕ rngŏt, ntlơi Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Phung i nhŭp Brah Yêsu njŭn Păng hăn ta jay Kaiphas i kôranh jan brah dŭt kuŏng, jêng ntŭk mpôl nơm nti nau vay phung Israel, ndrel ma phung kôranh bri Yuđa gŭ rgum đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pêtrôs tâng Brah Yêsu brô̆ ndŏp bôk mpơl bôk, n'ho ma tât ta jŏng gung jay kôranh jan brah i nây. Păng lăp gŭ ndrel mpôl bunuyh kơl jan kar ta ntŭk nây, gay ma ŭch gĭt moh ndơ nau geh. ");
INSERT INTO cmo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mpôl kôranh jan brah, ndrel ma dâng lĕ phung kôranh jan kar phung Israel tâm nchră băl joi bunuyh ma tơm ntôn nklă Brah Yêsu gay ma tê̆ dôih nkhât lơi Păng. ");
INSERT INTO cmo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Joi mâu ôh dơi say, bol lah geh ŏk bunuyh ngơi nchơt ma Ôbăl kađôi đŏng. Jêh ri geh bar hê bunuyh lah: ");
INSERT INTO cmo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Bunuyh dja lĕ lah kơt nđa: ‘Gâp dơi rơih lơi nhih jan brah ma Kôranh Brah, jêh ri jan jêh tay pe nar dơm’.” ");
INSERT INTO cmo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jêh ri kôranh jan brah dŭt kuŏng dâk lah Brah Yêsu: “Mơm May mâu ơh nau bu ntôn May nây mêh?” ");
INSERT INTO cmo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yơn ma Brah Yêsu gŭ iăt săk rklăk. Jêh ri kôranh jan brah dŭt kuŏng nây ôp tay: “Gâp đă May mbơh ma hên ma nau ton ta bơh năp Kôranh Brah i rêh ngăn: May jêng Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl ngăn, i Kon Kôranh Brah ngăn ƀah?” ");
INSERT INTO cmo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Brah Yêsu ơh: “Nau may lah i ri di ngăn, yơn ma Gâp mbơh nkoch ma khân may Dâng lĕ khân may mra say Gâp i Kon Bunuyh tă bơh Kôranh Brah Gŭ bơh ma ti Kôranh Brah nơm i dŭt nau dơi, Jêh ri jŭr bơh trôk ri hăn rŏ ndŏr tŭk.” ");
INSERT INTO cmo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jêh tăng Păng ngơi kơt nây, kôranh jan brah dŭt kuŏng nây nkhêk chuik ao păng nơm, jêh ri lah: “Uănh lĕ Păng mưch rmot Kôranh Brah! Bân mâu hôm ôh khăch joi bunuyh tơm say tơm tăng a êng jât. Lĕ khân may tăng dadê jêh nau pre mưch rmot Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Lah ndri mơm khân may ŭch tê̆ dôih ma Păng?” Khân păng ơh: “Iăt ma tê̆ dôih nkhât Păng ro!” ");
INSERT INTO cmo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jêh ri bu soh dak diu ta muh măt Brah Yêsu, thŭk Păng thăk Păng, bunuyh aƀă tap Păng, ");
INSERT INTO cmo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nđâp ma lah Păng: “Ơ Brah Krist, lah May Brah Krist ngăn May gĭt dâng lĕ ndơ, lah ndri May mbơh ma hên bu moh thŭk May!” ");
INSERT INTO cmo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nôk nây Pêtrôs gŭ ta bơh dih jay ta jŏng gung. Geh du huê bu ur sơm kơl jan kar ta nây hăn dăch păng, jêh ri ôp: “Ngăn may băl mpôl đah Yêsu to i tă bơh bri Galilê đŏng!” ");
INSERT INTO cmo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pêtrôs rlăch lah: “Gâp mâu gĭt ôh moh nau ay re lah ri.” ");
INSERT INTO cmo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nôk Pêtrôs hăn gŭ a meng mpông, geh du huê bu ur a êng jât sơm kơl jan kar ta nây lah ma bu: “Păng dja đŏng gŭ ndrel Yêsu ƀon Nasaret!” ");
INSERT INTO cmo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pêtrôs rlăch tay du tơ̆ jât nđâp ma ton: “Gâp mâu ôh gĭt năl bunuyh i nây!” ");
INSERT INTO cmo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Du ƀlât jât phung i gŭ ta nây hăn a păng lah: “May dja băl mpôl bunuyh i nây ngăn ro, yorlah nau may ngơi tâm ban ma nau ngơi bunuyh gŭ ta bri Galilê!” ");
INSERT INTO cmo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pêtrôs lah: “Lah gâp mƀrôh gâp rtăp săk gâp nơm. Ăn Kôranh Brah tê̆ dôih ma gâp dôh. Gâp mâu gĭt năl bunuyh i nây.” Dô ma iăr ndrau. ");
INSERT INTO cmo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jêh ri Pêtrôs ntơm kah gĭt nau Brah Yêsu lah: “Ê lor ma iăr ndrau, may rlăch pe tơ̆ lah mâu gĭt năl Gâp.” Jêh ri păng lôh a dih nhŭm rngot hô ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tât a ôi mpôl kôranh jan brah, ndrel ma mpôl kôranh phung Israel, khân păng tâm di du ntôr nau ŭch nkhât lơi Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Khân păng kât Ôbăl leo njŭn a Pilat bunuyh ƀon Rôm, i kôranh kuŏng mât uănh bri Yuđa. ");
INSERT INTO cmo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nôk nây Yuđas-Isakariyôt i nơm leo bu hăn nhŭp Brah Yêsu nơh say bu tê̆ dôih Brah Yêsu, păng nduih tôr lăn ta nuih n'hâm. Păng sŏ prăk i 30 kăk ri nơh mplơ̆ ăn ma mpôl kôranh jan brah, ndrel ma phung kôranh phung Israel, ");
INSERT INTO cmo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","jêh ri lah ma khân păng: “Gâp lĕ tih njŭn bunuyh mâu geh nau tih ăn khân may nkhât păng.” Khân păng ơh: “Gĭt eh may! I nây jêng nau may nơm!” ");
INSERT INTO cmo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuđas-Isakariyôt mƀăr mbrach prăk i nây ta nhih jan brah, jêh ri du lôh bơh nây hăn nkhât yông ko săk păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mpôl kôranh jan brah dônh prăk i nây, jêh ri lah: “Prăk dja bân mâu ôh di tê̆ ta keh prăk Kôranh Brah, yorlah prăk khlay mham.” ");
INSERT INTO cmo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jêh khân păng tâm nchră ri, khân păng sŏ prăk i nây rvăt mir bunuyh mon glah ma ăn tŏp khât phung bu năch êng. ");
INSERT INTO cmo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kơt ndri dâng bu kuăl ntŭk i nây n'ho ma tât nar dja lah ‘Mir mham’. ");
INSERT INTO cmo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nau i nây jêng di đah nau bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh rnha Yêrêmi lĕ nchih: ‘Bu lĕ sŏ prăk 30 kăk i phung Israel lĕ lah khlay păng, ");
INSERT INTO cmo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","jêh ri bu sŏ prăk i nây rvăt neh bunuyh mon glah, kơt Kôranh Brah lĕ đă jêh ma gâp’. ");
INSERT INTO cmo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Brah Yêsu dâk bơh năp kôranh kuŏng Pilat, Pilat ôp Păng kơt nđa: “Ngăn lah May kađăch phung Israel ƀah?” Brah Yêsu ơh: “Ơ kơt nau may lah nau i nây.” ");
INSERT INTO cmo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yơn ma nôk mpôl kôranh jan brah, ndrel ma mpôl kôranh phung Israel ntôn Brah Yêsu, Păng mâu ơh ôh. ");
INSERT INTO cmo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilat lah Păng: “May mâu tăng ƀah, dâng lĕ nau khân păng ntôn May nây?” ");
INSERT INTO cmo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Păng mâu ơh ôh, du tong Păng mâu ơh đŏng, n'ho ma tât kôranh kuŏng nây ndrŏt hih rhŏl ngăn. ");
INSERT INTO cmo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tâm ăp năm nhêt ƀŭn n'hot, kôranh kuŏng i nây vay mƀơk du huê bunuyh dôih tâng phung ƀon lan dăn. ");
INSERT INTO cmo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nôk nây geh du huê bunuyh dôih bu lư gŭ ndrung, rnha păng Ƀaraƀas. ");
INSERT INTO cmo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jêh phung ƀon lan tâm rgum băl, Pilat ôp khân păng: “Bu moh khân ay may ŭch ăn gâp mƀơk? Mƀơk Ƀaraƀas, mâu lah Yêsu i bu kuăl Brah Krist?” ");
INSERT INTO cmo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Păng lah kơt nây, yor ma păng lĕ gĭt jêh nuih n'hâm mpôl kôranh jan brah mâu nach, ndri dâng khân păng njŭn Brah Yêsu ăn ma păng nây. ");
INSERT INTO cmo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nôk Pilat hôm gŭ ta ntŭk phat dôih nây, ur păng đă bu hăn mbơh ma păng: “Lơi ôh jan ma bunuyh i nây, Păng mâu ôh geh nau tih. Yor ma bunuyh i nây măng to nơh gâp mbơi djơh hô ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Yơn ma mpôl kôranh jan brah, ndrel ma mpôl kôranh phung Israel nchâp ƀon lan dăn mƀơk Ƀaraƀas, jêh ri dăn nkhât lơi Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kôranh kuŏng Pilat ôp khân păng du tơ̆ jât: “Bar hê khân păng dja, bu moh khân ay may ŭch ăn gâp mƀơk?” Khân păng ơh: “Ƀaraƀas!” ");
INSERT INTO cmo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat ôp tay khân păng: “Lah ndri Yêsu i bu kuăl Brah Krist dja, mơm khân ay may ŭch ăn gâp jan?” Dâng lĕ khân păng nter drơu: “Nkhât Păng ta si tâm rkăng!” ");
INSERT INTO cmo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat ôp tay lah: “Bunuyh dja moh nau djơh Păng lĕ jan?” Phung ƀon lan nter drơu lơ ma hô lah: “Đă bu nkhât Păng ta si tâm rkăng!” ");
INSERT INTO cmo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat gĭt păng nơm mâu hôm dơi, say ƀon lan uh ah lơ ma hô đŏng. Jêh ri păng sŏ dak rao ti ta năp phung bunuyh ŏk, n'ho ma lah: “Nau dja dŭt ta khân ay may nơm yơ̆, gâp mâu ôh geh dôih đah nkhât bunuyh dja.” ");
INSERT INTO cmo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dâng lĕ phung ƀon lan ơh drơu: “Lah Păng mâu geh nau tih, ăn dôih i nây tŭp ta hên nơm, ndrel ma kon sau hên nơm mham Păng i nây!” ");
INSERT INTO cmo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ach ma Pilat ŭch jan tâng nau phung ƀon lan dăn nơh, păng mƀơk lơi Ƀaraƀas. Jêh ri păng đă tahen rpăt Brah Yêsu ma mŏng rse, n'ho ma jao ăn tahen nkhât Ôbăl ta si tâm rkăng. ");
INSERT INTO cmo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Phung tahen kôranh kuŏng Pilat leo Brah Yêsu hăn lăp ta jŏng gung nhih kôranh kuŏng nây, jêh ri dâng lĕ tahen ta nây gŭ jŭm Păng. ");
INSERT INTO cmo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Khân păng droh lơi bok ao Ôbăl, jêh ri sŏ ao chăng kuŏng i tâm ban ma ao kađăch nsoh ta Ôbăl. ");
INSERT INTO cmo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Khân păng sŏ rtao lok ƀăr jan môk kađăch ndô ta bôk Brah Yêsu ri, ndrel ma sŏ mŏng jan mŏng kađăch ăn ti bơh ma Păng kuăn, jêh ri chon kômŏk mbah mưch rmot Ôbăl n'ho ma lah: “Hơi kađăch phung Israel! Hên yơk May!” ");
INSERT INTO cmo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Khân păng rsoh dak diu ta Ôbăl, ndrel ma sŏ mŏng i nây mbang bôk Ôbăl jât. ");
INSERT INTO cmo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jêh mưch rmot ma Ôbăl kơt ndri, jêh ri tahen droh lơi ao i nây bơh săk Păng, plơ̆ nsoh tay ao Păng nơm nơh, jêh ri têk leo Ôbăl a ntŭk si tâm rkăng. ");
INSERT INTO cmo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nôk lôh bơh ƀon, phung tahen mâp du huê bu klô rnha păng Simôn tă bơh ƀon kuŏng Kiren, bu đă ôbăl tui si tâm rkăng Brah Yêsu ");
INSERT INTO cmo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","tât ta du ntŭk rnha ‘Gôlgôtha’, rblang lah ‘Ntŭk nting bôk’. ");
INSERT INTO cmo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jêh ri bu sŏ ndrănh play yŭng yar ƀon lai đah dak play măt tăng ngăn ăn Brah Yêsu nhêt, jêh Păng chiăm đê̆, Păng mâu ŭch nhêt ôh. ");
INSERT INTO cmo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jêh bu pŏng Ôbăl ta si tâm rkăng, bu tâm pă bok ao Păng ma ndơ nchroh. ");
INSERT INTO cmo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Khân păng gŭ rơp gơp ta nây njrăng Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ta kalơ bôk Brah Yêsu ri, khân păng pla du rlat kađar nchih mbơh nkoch nau bu ntôn Păng, lah kơt nđa: ‘Dja rnha Yêsu, kađăch phung Israel’. ");
INSERT INTO cmo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nôk nây bu nkhât ndrel Brah Yêsu bar hê bunuyh ntŭng đŏng, i du huê ăn bơh ma Păng, du huê jât ăn bơh chiao. ");
INSERT INTO cmo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Lĕ bunuyh i brô̆ rŏ nây, n'grơh n'grăp rteh bôk rŭl dŭl mưch ma Ôbăl ");
INSERT INTO cmo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","n'ho ma lah: “Hơi Bunuyh i lah rơih lơi nhih jan brah ma Kôranh Brah, jan tay i mhe pe nar jêh. Lah ndri rklaih êng săk May nơm, lah May Kon Kôranh Brah ngăn, jŭr bơh si tâm rkăng nây hŏm!” ");
INSERT INTO cmo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mpôl kôranh jan brah, phung nơm nti nau vay phung Israel, ndrel ma mpôl kôranh phung Israel leo băl ngơi n'grơh ma Păng kơt nây đŏng, khân păng lah: ");
INSERT INTO cmo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Păng dơi kơl ŏk bu aƀă êng, tih ma mâu ôh dơi rklaih săk Păng nơm! Lah Păng i kađăch phung Israel ngăn, ăn Păng jŭr bơh si tâm rkăng aƀaơ dja, jêh ri hên iăt ma Păng đŏng! ");
INSERT INTO cmo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Păng lĕ nsing ma Kôranh Brah, lah Kôranh Brah ŭch, ăn Kôranh Brah rklaih Păng aƀaơ dja ro, yorlah Păng lah: ‘Gâp i Kon Kôranh Brah’.” ");
INSERT INTO cmo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bol lah bar hê bunuyh ntŭng i bu nkhât ndrel Brah Yêsu ta ri, mưch rmot Ôbăl kơt nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ntơm bơh nar nklang bôk lam bri dak i nây trôk geh ngo dadê, n'ho ma tât mong pe kêng măng. ");
INSERT INTO cmo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Klăp lah ta mong pe kêng măng, Brah Yêsu nter dŭt dăng ta nau ngơi Hêbrơ: “Êli! Êli! Lama Sapăch Thani?” Rblang nau nây: ‘Ơ Kôranh Brah Gâp ơi! Ơ Kôranh Brah Gâp ơi! Moh nau May ntlơi Gâp?’ ");
INSERT INTO cmo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bu ƀaƀă i gŭ ta nây tăng nau Păng nter nơh vât vĭ, bu lah: “Păng kuăl Êliya i bunuyh ntơyh nau ngơi Kôranh Brah bơh kăl e nơh.” ");
INSERT INTO cmo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dô ma geh du huê bunuyh ta phung khân păng nchuăt sŏ bok yŭk ta dak srat put ta chông mŏng ndơ̆ ăn Păng nhêt. ");
INSERT INTO cmo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yơn ma bunuyh aƀă lah: “Kŏp uănh ƀŏt, gĭt Êliya hăn rklaih Păng mâu lah mâu.” ");
INSERT INTO cmo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jêh ri Brah Yêsu nter tay dŭt dăng, n'ho ma roh n'hâm klŏk. ");
INSERT INTO cmo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ta mong nây bok i nching ta mpông jrô dŭt kloh ueh ta trôm nhih jan brah ma Kôranh Brah, dô ma hêk chuik jêng bar, ntơm bơh lơ n'ho ma tât a dŏng, neh ntu n'găr, lŭ klêr đang. ");
INSERT INTO cmo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ntu môch pơk bŏng rưk ƀưk, khât phung bunuyh kloh ueh ŏk i vay gŭ sŏng ta bơh năp Kôranh Brah dâk rêh. ");
INSERT INTO cmo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jêh Brah Yêsu dâk rêh, phung khân păng lôh bơh ntu môch, lăp ta ƀon Yêrusalem i ƀon kloh ueh, nhhơ ăn ŏk bunuyh say. ");
INSERT INTO cmo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nôk kôranh tahen Rôm, ndrel ma phung tahen kŏp njrăng Brah Yêsu ta nây, say n'găr neh ntu, ndrel ma say dâng lĕ nau geh kơt nây, khân păng klach nsŏr hô ngăn, jêh ri lah: “Bu klô dja i Kon Kôranh Brah ngăn ya!” ");
INSERT INTO cmo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ta ntŭk nây geh ŏk bu ur i tâng Brah Yêsu tă bơh bri Galilê, i kơl Păng đŏng, khân păng gŭ uănh Păng dâng lĕ nau i nây bơh ngai. ");
INSERT INTO cmo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ta nây geh Mari tă bơh ƀon Mađala, Mari i mê̆ Yakơ, Yôsep, jêh ri geh nđâp ma i mê̆ Yakôp, Yôhan đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tât kêng măng geh du huê bunuyh ndrŏng rnha păng Yôsep, tă bơh ƀon Arimathê, păng jêng mpôl oh mon Brah Yêsu đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Păng hăn mâp Pilat dăn sŏ săk jăn Brah Yêsu, Pilat đă bu ăn ma păng. ");
INSERT INTO cmo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jêh ri păng sŏ săk jăn Brah Yêsu put đah bok laih kloh nglang. ");
INSERT INTO cmo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Păng njor săk Brah Yêsu nây ta trôm ntu môch mhe, ntu i păng lĕ đă bu lôk ta lŭ klêr ma ndrăp ma săk păng nơm. Jêh ri păng rlă du mlŏm lŭ kuŏng rdŏl trôm môch ri, păng nơm sât yot klăk. ");
INSERT INTO cmo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari tă bơh ƀon Mađala, ndrel ma Mari du huê êng jât gŭ ta nây đŏng, khân păng gŭ tâm sŏng mpông môch ri. ");
INSERT INTO cmo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tât ôi tay ri, ta nar Saƀăt i nar rlu phung Israel, mpôl kôranh jan brah, ndrel ma phung Pharisi khân păng leo băl hăn mâp Pilat ");
INSERT INTO cmo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","mbơh ma păng: “Ơ kôranh, hên hôm kah gĭt nau Bunuyh mƀrôh i nây lah nôk Păng hôm rêh nơh: ‘Jêh Gâp khât, tât pe nar Gâp dâk rêh tay’. ");
INSERT INTO cmo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Lah ndri dăn kôranh đă tahen ăn njrăng ngăn môch i nây ăn lôch pe nar. Klach lah mpôl oh mon Păng hăn sŏ ntŭng săk Păng nây, jêh ri mbơh nkoch ma phung ƀon lan lah Păng lĕ dâk rêh. Lah ndri nau mƀrôh aƀaơ dja djơh rlau ma bơh kơi nơh jât.” ");
INSERT INTO cmo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat lah ma khân păng: “Khân may sŏ tahen, đă bu njrăng ngăn ăn dŭt ueh dô, dah ŭch khân may nơm!” ");
INSERT INTO cmo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jêh ri khân păng hăn a môch, njâr ntu môch pla ndơ ver kalơ jât gay ma lơi ăn bu lăp, ndrel ma ăn tahen gŭ njrăng. ");
INSERT INTO cmo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jêh nar Saƀăt i nar rlu phung Israel, ơm ôi nar nguai ta pơh i nây, Mari bơh ƀon Mađala, ndrel ma Mari i du huê êng jât, khân păng leo băl hăn a môch. ");
INSERT INTO cmo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nôk nây dô ma geh n'găr neh dŭt hô, yorlah geh tông păr Kôranh Brah jŭr tă bơh trôk i ntŭk Kôranh Brah nơm, nklơ̆ lơi lŭ bơh bŏr môch nây, jêh ri gŭ rgơp ta kalơ lŭ i nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Uănh păng ril tâm ban ma lơp nglayh, bok ao păng nglang tâm ban ma mli. ");
INSERT INTO cmo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Phung tahen i gŭ njrăng môch ta nây klach nsŏr hô ngăn, n'ho ma chôt khât yơh. ");
INSERT INTO cmo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yơn ma tông păr lah ma mpôl bu ur i ri: “Khân ay lơi klach ôh! Gâp lĕ gĭt jêh khân ay hăn joi Brah Yêsu i bu nkhât ta si tâm rkăng nơh. ");
INSERT INTO cmo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Păng mâu hôm ôh ta dja, yorlah Kôranh Brah rdŏk ăn dâk rêh tay, kơt nau Păng lĕ nkoch nơh. Hăn uănh hŏm ta ntŭk bu njor Păng, ");
INSERT INTO cmo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","jêh ri hăn gơnh a mpôl oh mon Păng ri, mbơh ăn khân păng gĭt Kôranh Brah lĕ rdŏk Păng ăn dâk rêh, aƀaơ dja Păng hăn lor khân ay may ta bri Galilê ri. Ta ntŭk nây khân ay may say Păng. Ndri nau gâp mbơh ma khân ay yơ̆!” ");
INSERT INTO cmo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jêh ri khân păng hăn ro tă bơh môch nây nđâp ma geh nau klach geh nau răm hô ngăn, khân păng nchuăt mbơh nkoch nau mhe mhan i nây ma mpôl oh mon Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Dô ma Brah Yêsu hăn mâp khân păng ôp khân păng: “Ueh lăng khân ay!” Jêh ri khân păng ran dăch Brah Yêsu păn ta neh kuăn ta jŏng Brah Yêsu ri, yơk mbah Păng. ");
INSERT INTO cmo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Brah Yêsu lah ma khân păng: “Lơi klach ôh! Khân ay hăn mbơh nkoch ma mpôl oh nô Gâp, ăn khân păng hăn ta bri Galilê ri, ta ntŭk nây khân păng say Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dôl phung bu ur nây hăn rŏ trong, geh phung tahen i njrăng môch nây nơh aƀă lăp ta ƀon, mbơh nkoch dâng lĕ nau geh i nây nơh ăn ma mpôl kôranh jan brah. ");
INSERT INTO cmo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mpôl kôranh jan brah, tâm mâp tâm nchră đah mpôl kôranh phung Israel, khân păng tâm di du ntôr nau ăn prăk ŏk ngăn ma phung tahen, ");
INSERT INTO cmo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","n'ho ma ntŭm khân păng kơt nđa: “Ăn khân may lah: ‘Ndŭt hên hăk bêch geh mpôl oh mon Păng hăn a măng sŏ ntŭng săk Păng’. ");
INSERT INTO cmo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Lah kôranh kuŏng Pilat gĭt nau dja, hên mra mbơh ma păng. Khân may mâu chrao ôh geh dôih.” ");
INSERT INTO cmo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jêh ri khân păng sŏ dơn prăk i nây, jan kơt nau bu đă ma khân păng. Nau i nây gĭt lư lam phung Israel, n'ho ma tât nar dja. ");
INSERT INTO cmo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jêh ri 11 nuyh mpôl kôranh oh mon hăn ta bri Galilê, tât ta yôk ntŭk Brah Yêsu lĕ mbơh ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tât khân păng say Brah Yêsu, khân păng yơk mbah ma Păng, yơn ma geh bunuyh aƀă hôm e vĭ vĕ ma Păng. ");
INSERT INTO cmo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Brah Yêsu hăn ta khân păng, jêh ri lah ma khân păng: “Lĕ nau dơi ta trôk, nđâp ma ta neh ntu lĕ Bơ̆ ăn jêh ma Gâp dadê. ");
INSERT INTO cmo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lah ndri hăn hŏm ăp ndŭl mpôl bunuyh ta neh ntu dja, njêng khân păng jêng oh mon Gâp, jêh ri jan ƀăptem yŭk khân păng ma dak, ta rnha Bơ̆, ta rnha Gâp i Kon Păng, ndrel ma ta rnha Brah Huêng Ueh i kloh ueh. ");
INSERT INTO cmo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jêh ri ntŭm nti ăn khân păng iăt dâng lĕ nau Gâp lĕ đă ma khân may nơh. Ăn hôm kah gĭt nâng: Gâp hôm e gŭ nâng ndrel khân may n'ho ma tât nar lôch neh ntu dja”.");
INSERT INTO cmo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dja ntơm nau mhe mhan ueh ma Brah Yêsu Krist i Kon Kôranh Brah nơm. ");
INSERT INTO cmo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ta samƀŭt bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, rnha Êsai lĕ nchih lah: ‘Kôranh Brah lah: ‘Uănh yơ̆, Gâp đă du huê bunuyh hăn lor ndrăp nuih n'hâm bunuyh ăn May Tâm ban bu kuayh trong, mbơh ma bu May hăn bơh kơi. ");
INSERT INTO cmo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Bunuyh i nây nter ta bri rdah lah: ‘Ndrăp hŏm nuih n'hâm ăn ma Kôranh Brah, tâm ban ma bunuyh kuayh trong, Nsŏng trong ăn ma kađăch hăn’’’. ");
INSERT INTO cmo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ndri nau nkoch i nây lĕ tât hơi, geh du huê bunuyh rnha Yôhan gŭ ta bri rdah, păng mbơh nkoch ma ƀon lan rgâl lơi nuih n'hâm djơh, n'ho ma dơn nau yŭk ma dak, i bu kuăl ‘Ƀăptem’, gay ma nhhơ khân păng ŭch tâng nau Kôranh Brah, ndri dâng Kôranh Brah yô̆ nđach mâu hôm ôh kơp nau tih khân păng. ");
INSERT INTO cmo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Geh ŏk bunuyh ta bri Yuđa, ndrel ma ta ƀon kuŏng Yêrusalem hăn ran a păng dadê. Khân păng gĭt săk khân păng nơm tih mbơh ro, jêh ri Yôhan jan ƀăptem yŭk khân păng ma dak ta dak rlai Yôrđăn ri. ");
INSERT INTO cmo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Lŏng Yôhan păng nsoh ao jong jan ma rsau seh samô, văn rse bŭt jan ma ntô, păng sa krah ndrach đah dak sŭt. ");
INSERT INTO cmo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Păng mbơh nkoch ma phung ƀon lan: “Geh du huê kôranh, Păng hăn bơh kơi gâp bơi ma tât jêh, Păng geh nau dơi rlau gâp ngăn. Ta năp Păng gâp jêng bunuyh jê̆ lê̆ dơm, bol lah gâp kŭnh sơm droh ntô jot Păng, hôm e mâu hŏ di đah nau jan kar Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Gâp jan ƀăptem ăn khân ay may yŭk ma dak dơm, lŏng Păng i nây jan ƀăptem ăn khân ay may ma Brah Huêng Ueh i kloh ueh.” ");
INSERT INTO cmo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tât nar bơh kơi Brah Yêsu i tă bơh ƀon Nasaret bri Galilê Păng hăn tât ta ntŭk Yôhan jan ƀăptem nây, jêh ri Yôhan jan ƀăptem ma Brah Yêsu yŭk ma dak ta dak rlai Yôrđăn. ");
INSERT INTO cmo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jêh yŭk Păng ta dak ri, lôh ƀlu bơh dak ri, Brah Yêsu say trôk pơk bŏng lahưr, jêh ri geh Brah Huêng Ueh jŭr drŏm ta Păng uănh tâm ban ma plŭk. ");
INSERT INTO cmo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Dôl nây geh tăng nteh bŏr tă bơh kalơ trôk lah: “May i Kon Gâp rŏng, Gâp răm rhơn May hô ngăn ngên.” ");
INSERT INTO cmo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jêh bơh nây Brah Huêng Ueh đă Brah Yêsu du hăn a bri rdah. ");
INSERT INTO cmo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Păng gŭ ta ntŭk nây 40 năng 40 nar, geh Satăng i kôranh mpôl brah djơh ndơm Păng đŏng. Păng gŭ ndrel mpômpa (siŭm) bri ta ntŭk nây, geh mpôl tông păr sơm kơl jan kar ma Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lĕ jêh bu nhŭp Yôhan-Ƀaptem krŭng ta ndrung, jêh ri Brah Yêsu hăn ta bri Galilê n'ho ma mbơh nkoch nau mhe mhan ueh Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Păng lah: “Mong lĕ tât jêh, nau Kôranh Brah mât uănh khân ay may lĕ dăch ngăn ro. Lah ndri rgâl hŏm nuih n'hâm djơh khân ay may, jêh ri nsing ma nau mhe mhan ueh dja dô!” ");
INSERT INTO cmo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Geh du nar ri Brah Yêsu hăn brô̆ rŏ meng dak nglao kuŏng Galilê, Păng say bar hê oh nô gŭ seng jal ta dak nây, i nô rnha Simôn, ndrel ma Ŏndrê i oh. Bar hê khân păng i nây jêng bunuyh jan kar văng ka dơm. ");
INSERT INTO cmo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jêh ri Brah Yêsu lah ma khân păng: “Hơi oh nô, hô̆ tâng Gâp, Gâp ăn khân may hăn joi bunuyh iăt nau Gâp, tâm ban ma seng ka.” ");
INSERT INTO cmo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Dô ma bar hê khân păng ri ntlơi jal prŭng ta nây, jêh ri tâng Brah Yêsu ro. ");
INSERT INTO cmo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jêh ri Brah Yêsu hăn jât năp, Păng say bar hê oh nô Yakơ, ndrel ma Yôhan gŭ sŭl jal ta duk ri, bar hê khân păng nây i kon Sêƀêđê. ");
INSERT INTO cmo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tât say khân păng ta ri, Brah Yêsu jă ro, jêh ri khân păng ntlơi i bơ̆, ndrel ma mpôl i păng nkhôm jan kar ma păng ta ri, hăn tâng Brah Yêsu ro. ");
INSERT INTO cmo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jêh ri Brah Yêsu, ndrel ma mpôl oh mon Păng hăn ta ƀon Kapơnŭm. Tât nar Saƀăt i nar rlu phung Israel Păng lăp ntŭm nti ta nhih rƀŭn phung Israel. ");
INSERT INTO cmo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bu ndrŏt nhhih ngăn tăng nau Păng nti i nây. Nau Păng nti nơh geh nau dơi, mâu ôh tâm ban ma phung nơm nti nau vay phung Israel. ");
INSERT INTO cmo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ta nhih rƀŭn nây, geh du huê bu klô lăp ta nây brah djơh gŭ ta săk păng đŏng, păng nter: ");
INSERT INTO cmo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ơ Yêsu tă bơh ƀon Nasaret! Lơi May rkhuak hên, May hăn ŭch lơh lơi hên bơh? Gâp năl May ngăn, May i nây i bunuyh kloh ueh tă bơh Kôranh Brah.” ");
INSERT INTO cmo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Brah Yêsu de mbram brah djơh i nây: “Lơi hôm ngơi, gŭ iăt săk rklăk hŏ, du lôh bơh bunuyh i nây hŏm!” ");
INSERT INTO cmo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jêh tăng Brah Yêsu lah ndri brah djơh lơh bunuyh i nây chôt dŭl nslŏng sŏng sa, nter lŭng loch ngăn lôh ƀhŭch brah djơh i nây. ");
INSERT INTO cmo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dâng lĕ bunuyh say kơt nây nơh, ndrŏt hih rhŏl dadê ngăn, jêh ri tâm ôp ndrăng khân păng nơm: “Yê! Lĕ nau ngăn hay! Nau ntŭm nti Păng i nây mhe ngăn hay, nđâp ma geh nau dơi đŏng. Bol lah brah djơh iăt nau Păng đă đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jêh ri gơnh ngăn bu lư Păng hô lam bri Galilê. ");
INSERT INTO cmo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jêh ri Brah Yêsu lôh bơh nhih rƀŭn i nây, hăn brŏng ta jay bar hê oh nô, Simôn, ndrel Ŏndrê. Yakơ, ndrel ma Yôhan hăn ndrel đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lŏng i mê̆ po Simôn ri ji kop bêch ta gre ri. Tât ta nây bu mbơh ma Brah Yêsu ro nau ji kop păng. ");
INSERT INTO cmo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Brah Yêsu hăn ran ta păng, nhŭp ti rdŏk păng. Nau ji kop bah ro, jêh ri păng jan piăng trao ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tât bri kêng măng nôk nar lĕ nhŏp, lĕ bunuyh geh nau ji, ndrel ma bunuyh brah djơh lăp, bu leo hăn a Brah Yêsu dadê. ");
INSERT INTO cmo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Geh ŏk ngăn bunuyh ta ƀon nây gŭ gum ta mpông jay ri dadê. ");
INSERT INTO cmo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jêh ri geh ŏk bunuyh Brah Yêsu jan bah ăp ntil nau ji ta khân păng, mprơh brah djơh du lôh bơh bunuyh đŏng. Păng buay brah djơh mâu ôh ăn ngơi, yorlah phung brah djơh lĕ năl Păng. ");
INSERT INTO cmo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kah ơm ôi bri hôm ngo, Brah Yêsu dâk bêch hăn du huê êng ta ntŭk bri rdah ngai đah bunuyh, jêh ri mbơh sơm ta ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simôn, ndrel ma mpôl i gŭ ndrel păng, hăn joi Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tât ma say Păng, khân păng lah: “Ŏk ngăn bunuyh ŭch joi May mê̆.” ");
INSERT INTO cmo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Brah Yêsu lah ma khân păng: “Hô̆ bân brô̆ rŏ ƀon i dăch dăch ta dja. Gâp be ma mbơh nkoch nau mhe mhan ueh ăn ma ƀon i nây, ndri dâng Gâp hăn tât ta dja.” ");
INSERT INTO cmo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jêh ri Brah Yêsu hăn mbơh nkoch nau mhe mhan ueh ta nhih rƀŭn phung Israel lam bri Galilê n'ho ma mprơh brah djơh du lôh bơh bunuyh ŏk đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Geh du huê bu klô phŭng sa hăn chon kômŏk bonh Brah Yêsu: “Dăn May yô̆ nđach ma gâp ơ! Gâp lĕ gĭt May dơi jan săk gâp ăn kloh ăn bah ji, lah May ŭch.” ");
INSERT INTO cmo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Brah Yêsu yô̆ nđach ma bu klô phŭng sa nây. Brah Yêsu nta ti pah ta săk păng ri, jêh ri lah ma bunuyh phŭng sa i nây: “Ơ, Gâp ŭch đŏng, bah hŏm!” ");
INSERT INTO cmo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jêh Brah Yêsu ngơi ri, bu klô phŭng sa i nây dô ma bah ueh kloh rngŭch ro. ");
INSERT INTO cmo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jêh ri Brah Yêsu đă păng sât, n'ho ma buay păng: ");
INSERT INTO cmo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“May lơi ôh mbơh nkoch nau i dja ăn bu gĭt, ăn may hăn brŏng nhhơ săk ma bunuyh jan brah ri, jêh ri nhhơr ndơ jan brah tâng nau vay Môsê đă ma bunuyh bah nau ji phŭng sa, gay ma bu gĭt n'hêl săk may lĕ kloh ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tih ma bu klô i nây mbung rƀơch hăn mbơh nkoch ma bu ro, păng mbơh nkoch nau i nây ăn bu gĭt lam ăp ntŭk ăp ntô. Ach ma nkoch ndri, Brah Yêsu der mâu hôm ôh dơi lăp ta ƀon kuŏng kơt a lor nơh, Păng gŭ bơh dih ƀon, jêh ri hôm geh bunuyh tă bơh ăp njônh ăp njănh hăn a Păng nây. ");
INSERT INTO cmo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tât jŏ bar pe nar ri, Brah Yêsu plơ̆ tay ta ƀon Kapơnŭm. Bunuyh ta ƀon nây tăng lư Păng lĕ plơ̆ sât tay gŭ ta jay. ");
INSERT INTO cmo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Geh bunuyh ran ta jay nây ŏk mpưm ngăn, joi ntŭk ma gŭ mâu geh ôh, bol lah bơh dih mpông mâu hôm geh đŏng. Jêh ri Brah Yêsu mbơh nkoch nau Kôranh Brah ăn ma khân păng ta nây. ");
INSERT INTO cmo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jêh ri geh bunuyh puăn nuyh hăn bơh kơi tung du huê bu klô rven jŏng rven ti, hăn a Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tât ta jay nây joi trong lăp hăn ta Brah Yêsu mâu say ôh, yor ma geh bunuyh ŏk ir. Kơt ndri khân păng lôk trôm kalơ chor jay tâm sŏng ntŭk Brah Yêsu gŭ, jêh ri njŭr bu klô rven i bêch ta mbêl nây rŏ trôm nây. ");
INSERT INTO cmo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Brah Yêsu say khân păng geh nau nsing Păng dơi jan bah nau ji kơt nây, Păng lah ma bunuyh rven i nây: “Hơi oh, Gâp lĕ yô̆ may, mâu hôm ôh kơp nau tih ta may.” ");
INSERT INTO cmo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ta nây geh phung nơm nti nau vay phung Israel aƀă nklŏn êng ta tôr: ");
INSERT INTO cmo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Hưh! Mơm dâng Păng bănh ngơi mưch rmot Kôranh Brah kơt ndri? Geh du huê Kôranh Brah dơm dơi yô̆ bunuyh, mâu hôm ôh kơp mâu hôm ôh klăp ndăng nau tih!” ");
INSERT INTO cmo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yơn ma Brah Yêsu gĭt ro lĕ nau khân păng nklŏn kơt nây, Păng lah ma khân păng: “Mơm dâng khân may geh nau mân kơt nđay? ");
INSERT INTO cmo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ăn khân may gĭt nau dja, lah Gâp lah ma bu klô rven nây ‘Nau tih may lĕ Gâp yô̆ hơi’, mâu lah ‘May dâk ndjôt mbêl brô̆ hŏm’, lah ndri moh nau lah i dơh rlau hă? ");
INSERT INTO cmo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Gâp ŭch ăn khân may gĭt say, Gâp i Kon Bunuyh tă bơh Kôranh Brah, ndri dâng Gâp dơi yô̆ nau tih bunuyh ta neh ntu dja.” Jêh ri Brah Yêsu lah ma bu klô rven i nây: ");
INSERT INTO cmo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“May dâk hŏm! May ndjôt mbêl may nây sât a jay may nơm ri.” ");
INSERT INTO cmo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Păng dâk đơp bơh mbêl nây ro, ndjôt mbêl păng nơm nây hăn sât lăp rŏ nklang phung băl ŏk. Lŏng lĕ bunuyh i gŭ ta nây geh nau ndrŏt hih rhŏl, khân păng rnê ma Kôranh Brah, n'ho ma lah: “Bân mâu ôh vay say nau dja kăl dơ̆ to!” ");
INSERT INTO cmo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jêh ri Brah Yêsu hăn rŏ meng dak nglao kuŏng Galilê du tơ̆ jât, phung ƀon lan ŏk ngăn hăn ta Păng, Păng ntŭm nti ăn ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jêh ntŭm nti nây Păng lôh bơh nây brô̆ tay jât năp, jêh ri say du huê bunuyh rnha Lêvi i kon Alphai gŭ kŏp sŏ prăk ƀon lan ma ăn kôranh mât uănh, păng gŭ ta ntŭk păng vay sŏ prăk. Brah Yêsu lah ma păng: “Hô̆ brô̆ tâng Gâp.” Păng dâk bơh nây, jêh ri tâng Brah Yêsu ro. ");
INSERT INTO cmo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ta nar nây Lêvi jă Brah Yêsu, ndrel ma mpôl oh mon hăn sông sa ta jay păng nơm. Ta jay nây geh bunuyh sŏ prăk ƀon lan, ndrel ma bunuyh tih aƀă êng geh ŏk gŭ sông sa ndrel đŏng. Geh bunuyh i kơt nây ŏk ngăn hăn tâng Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tât say Brah Yêsu gŭ sông sa ndrel phung bunuyh tih nây, phung nơm nti nau vay phung Israel jêng phung Pharisi đŏng, lah ma oh mon Păng: “Mơm dâng bunuyh i nây gŭ sông sa ndrel bunuyh sŏ prăk ƀon lan, ndrel ma bunuyh jan tih êng kơt nây?” ");
INSERT INTO cmo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jêh Brah Yêsu tăng khân păng lah kơt nây, Păng lah: “Bunuyh geh săk jăn ueh mâu ŭch ôh ma kôranh dak si, bunuyh i geh nau ji dơm ŭch. Ndri dâng Gâp văch ta dja mâu ôh gay ma kuăl bunuyh sŏng, ŭch kuăl bunuyh tih, gay ma kơl khân păng.” ");
INSERT INTO cmo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lŏng geh du nar mpôl oh mon Yôhan-Ƀaptem, ndrel ma mpôl Pharisi khân păng ăt sông sa. Jêh ri geh bu hăn ôp Brah Yêsu: “Mpôl oh mon Yôhan-Ƀaptem, ndrel ma mpôl oh mon phung Pharisi ăt sông sa, mơm dâng mpôl oh mon May mâu ăt?” ");
INSERT INTO cmo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Brah Yêsu lah ma khân păng: “Nôk tâm nđăp ur sai, bu năch vay ăt sông sa đŏng bơh? Mâu vay ôh. Iăt ma i sai mhe hôm gŭ ndrel ta ri, nau tâm nđăp nây ê hŏ lôch ôh. ");
INSERT INTO cmo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gâp tâm ban ma bu klô nđăp ur sai, tât di nar ri tay bu tâm nkhah Gâp đah mpôl oh mon Gâp, ta nar i nây khân păng ăt sông sa. ");
INSERT INTO cmo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Bu mâu vay ôh sŏ bok mhe ê hŏ pih mbôl ta ao lĕ sat. Lah jan kơt nây bok i sat ri lơ ma hô hêk rlau ơm ngăn, yor ma i bok mhe nây jêng rôt nôk jêh pih. ");
INSERT INTO cmo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kơt ndri đŏng, bu mâu vay ôh tê̆ ndrănh play yŭng yar ƀon mhe ta dŭng ntô ơm, lah jan kơt nây ndrănh play yŭng yar ƀon mhe jan ăn dŭng ntô i nây prek, ndrănh hŭk đŏng, jêh ri dŭng ntô i nây jêng sat đŏng, yorlah dŭng ntô ơm mâu hôm ôh toch. Bu tê̆ ndrănh play yŭng yar ƀon mhe ta dŭng ntô mhe.” ");
INSERT INTO cmo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Geh du nar Saƀăt i nar rlu phung Israel Brah Yêsu, ndrel oh mon Păng hăn glăt rŏ mir Ba Prăng, jêh ri mpôl oh mon Păng roih Ba Prăng gay ma sa. ");
INSERT INTO cmo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Geh phung Pharisi hăn bơh kơi lah Brah Yêsu: “Lŏng May uănh, moh si kô̆ mpôl oh mon May jan kar ta nar Saƀăt dja mêh? Bol lah khân păng roih đê̆ đê̆ kơt nây, hôm e kơp tih đah nau vay nar rlu phung bân đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Brah Yêsu ôp: “Lah ndri khân may lĕ chuêl ƀah, nau khân may vay rŏ ta Nau Kôranh Brah Ngơi? Bơh nôk Abiathar jan kôranh jan brah dŭt kuŏng, Đavid, ndrel ma bunuyh gŭ ndrel păng hô ngăn ji ngot, khân păng ŭch geh ndơ sông sa. Nôk nây Đavid ê hŏ jêng kađăch. Jêh ri Đavid lăp ta trôm ntŭk chun bok Kôranh Brah, păng sa nŭmpăng i bu tê̆ nhhơr ma Kôranh Brah nây, n'ho ma pă bunuyh i gŭ ndrel păng sa đŏng. Bu mâu lah păng đŏng bol lah tâng ma nau vay geh mpôl jan brah dơm dơi sa nŭmpăng i nây!” ");
INSERT INTO cmo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Brah Yêsu lah jât: “Kôranh Brah đă kon bunuyh rlu ta nar Saƀăt gay ma kơl kon bunuyh, mâu geh ôh Păng njêng kon bunuyh jan dâk ma nar Saƀăt! ");
INSERT INTO cmo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Gâp i Kon Bunuyh tă bơh Kôranh Brah, ndri dâng Gâp jêng kôranh moh ndơ i dơi ăn bu jan, mâu lah mâu dơi ăn bu jan ta nar Saƀăt i nar rlu.” ");
INSERT INTO cmo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jêh ri Brah Yêsu lăp ta nhih rƀŭn phung Israel du tơ̆ jât, ta nây geh du huê bu klô rven ti du ding. ");
INSERT INTO cmo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bu ŭch joi nau ma ntôn Brah Yêsu nkhêp lah Păng jan bah bunuyh ji ta nar Saƀăt, yorlah khân păng nti ta nau vay phung Israel mâu ăn ôh jan bah bunuyh ji ta nar Saƀăt, ndri dâng khân păng uănh jât Păng ler nger ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jêh ri Brah Yêsu lah ma bu klô i nây: “Hơi oh, may dâk hŏm, hăn dâk bơh năp bu to!” ");
INSERT INTO cmo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jêh ri Brah Yêsu lah ma mpôl i kŏp uănh Păng: “Gâp ôp khân may, tâng nau vay phung bân ta nar Saƀăt bunuyh dơi jan ndơ ueh mâu lah ndơ djơh? Dơi rklaih nau rêh bunuyh mâu lah nkhât păng?” Dâng lĕ khân păng gŭ iăt săk răk klăk. ");
INSERT INTO cmo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Brah Yêsu uănh dâng lĕ bunuyh i gŭ ta nây, Păng ji nuih rngot êng săk Păng nơm, say khân păng dăng ko mâu geh nau tâm yô̆. Jêh ri Păng lah ma bu klô i rven ti nây: “Lŏng may rok ti may nây hŏm!” Jêh ri păng rok ti păng bah kơt ơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jêh ri phung Pharisi i gŭ ta nây lôh rŭch plŭch bơh nhih rƀŭn nây, hăn brŏng tâm nchră đah băl mpôl Hêrôt-Ŏntipas ro, gay ma joi nau mơm dâng geh nkhât Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jêh ri Brah Yêsu lôh bơh ntŭk nây hăn ta nglao kuŏng Galilê ndrel mpôl oh mon Păng. Geh ŏk phung ƀon lan hăn tâng Păng, phung i nây tă bơh bri Galilê bơh bri Yuđa, ");
INSERT INTO cmo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","bơh ƀon kuŏng Yêrusalem, bơh bri Iđumê, bơh kăl ti dak rlai Yôrđăn, bơh ăp ntŭk jŭm ƀon kuŏng Tirus, ndrel ma bơh ăp ntŭk jŭm ƀon kuŏng Siđôn. Ndri dâng ŏk ngăn bunuyh hăn văch a Păng nây, yorlah tăng bu mbơh nkoch dâng lĕ nau Păng jan nơh. ");
INSERT INTO cmo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Say ŏk ir ƀon lan nây Brah Yêsu đă mpôl oh mon Păng ndrăp du mlŏm duk ăn ma Păng, klach lah phung ƀon lan rŭn mpet Păng. ");
INSERT INTO cmo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Lĕ jêh Păng jan bah bunuyh ji ŏk ngăn, ndri dâng bunuyh êng êng i geh nau ji nsrôyh chŭl hăn dăch dăch, ŭch pah Brah Yêsu gay ma bah nau ji khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tât phung bunuyh i geh brah djơh gŭ ta khân păng say Brah Yêsu, khân păng păn ta bơh năp Brah Yêsu ro, nđâp ma nter: “May i Kon Kôranh Brah!” ");
INSERT INTO cmo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jêh ri Brah Yêsu mbram, mâu ôh ăn khân păng mbơh nkoch ma bu gĭt năl Păng i Kon Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Brah Yêsu lĕ hao kalơ yôk, jêh ri Păng kuăl jă bunuyh i Păng ŭch hăn ndrel Păng, jêh ri khân păng i nây hăn tâng Păng ta ri. ");
INSERT INTO cmo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bơh mpôl i nây Păng kơih 12 nuyh, Păng kuăl khân păng ‘Kôranh oh mon’. Mpôl i nây gay ma gŭ ndrel Păng nơm, ăn khân păng mbơh nkoch nau Păng ăn ma bu, ");
INSERT INTO cmo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ndrel ma ăn khân păng geh nau dơi, dơi mprơh brah djơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mpôl 12 nuyh nây, ta nây geh Simôn i Brah Yêsu tê̆ rnha mhe păng Pêtrôs, ");
INSERT INTO cmo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","geh bar hê oh nô i kon Sêƀêđê rnha Yakơ, ndrel ma Yôhan. Bar hê khân păng i nây Brah Yêsu de tê̆ rnha ‘Ƀôanêrkê’ rblang nau i nây ‘Kon nteh ntŏr nglayh’. ");
INSERT INTO cmo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Geh rnha Ŏndrê, rnha Philip, rnha Ƀartôlômê, rnha Mathay, rnha Thômas, rnha Yakơ i kon Alphai, rnha Thađê, rnha Simôn i bu kuăl ‘gơyh’, ");
INSERT INTO cmo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ndrel ma rnha Yuđas-Isakariyôt i bunuyh leo bu hăn nhŭp Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jêh ri Brah Yêsu hăn gŭ ta du mlŏm jay, tât ta nây geh bunuyh văch tay ta ri, lơ ma ŏk lơ ma ŏk ngăn. Lŏng Păng, ndrel ma mpôl oh mon Păng mâu ôh hoch sông sa. ");
INSERT INTO cmo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jêh phung băl mpôl Păng tăng bu de nkoch nau i nây, bu lah đŏng: “Hưh, mâu hôm ôh gĭt săk Păng ri.” Ndri dâng khân păng jă băl hăn sŏ Păng. ");
INSERT INTO cmo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lŏng i phung nơm nti nau vay phung Israel i tă bơh ƀon Yêrusalem ri hăn tât ta nây, khân păng lah: “Bunuyh i nây geh brah djơh Ƀêlsêƀul gŭ ta săk Păng. Yorlah i kôranh mpôl brah djơh ăn nau dơi ta Păng, dâng Păng dơi mprơh brah djơh.” ");
INSERT INTO cmo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Brah Yêsu kuăl phung nơm nti nây hăn dăch a Păng, jêh ri lah ma nau ngơi ntât: “Mơm blao Satăng i kôranh mpôl brah djơh mprơh săk păng nơm? ");
INSERT INTO cmo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Lah ta du bri phung ƀon lan păng tâm lŏk tâm janh chah chrai băl, bri i nây mâu hôm ôh. ");
INSERT INTO cmo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mâu lah ta du rnăk vâl geh tâm lŏk tâm janh băl nâng neng, rnăk vâl i nây roh hêng mâu hôm đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Lah geh Satăng tâm lŏk tâm janh ndrăng păng nơm, păng mâu dơi ôh gŭ nâp, roh hêng ro. ");
INSERT INTO cmo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mâu geh ôh bunuyh dơi hăn ta jay bunuyh dăng, jêh ri ntŭng drăp ndơ păng. Ăn nhŭp kât lor bunuyh i nây ƀŏt, ri mơ dơi ntŭng dâng lĕ drăp ndơ ta jay păng. ");
INSERT INTO cmo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Gâp lah n'hêl nanê̆ ngăn ma khân may, dâng lĕ ndơ bunuyh jan tih, ndrel ma lah mưch rmot Kôranh Brah, Kôranh Brah hôm yô̆ dadê. ");
INSERT INTO cmo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tih ma bu moh i lah mưch rmot Brah Huêng Ueh i kloh ueh ri, mâu ôh Kôranh Brah yô̆ ma păng, păng i nây geh dôih n'ho ro mâu blao bah.” ");
INSERT INTO cmo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ndri dâng Brah Yêsu ngơi kơt nây, ach khân păng lah Păng geh brah djơh gŭ ta săk Păng. ");
INSERT INTO cmo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jêh ri mê̆ Brah Yêsu, ndrel ma oh bu klô Păng, hăn tât ta jay Brah Yêsu gŭ ntŭm nti nây. Khân păng gŭ bơh dih ri, jêh ri đă bu mbơh Păng hăn mâp khân păng. ");
INSERT INTO cmo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Phung ƀon lan i gŭ jŭm Brah Yêsu ri mbơh Păng: “Hơi Nơm Nti, mê̆ May, ndrel ma oh bu klô May gŭ kŏp bơh dih to, ŭch mâp May mê̆!” ");
INSERT INTO cmo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jêh ri Brah Yêsu ơh ma khân păng: “Bu moh mê̆ Gâp? Bu moh oh nô Gâp?” ");
INSERT INTO cmo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jêh ri Păng uănh bunuyh i gŭ jŭm Păng, Păng lah: “Bunuyh i gŭ ta dja Gâp kuăl mê̆ Gâp, oh nô Gâp. ");
INSERT INTO cmo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bu moh i iăt tâng nau Kôranh Brah ŭch, păng i nây oh nô Gâp, ndrel ma mê̆ Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Geh du nar ri Brah Yêsu gŭ nti phung ƀon lan rŏ meng dak nglao kuŏng Galilê du tơ̆ jât. Ta nây geh ŏk ngăn bunuyh hăn văch ta Păng, ndri Păng hao gŭ rgơp kalơ duk, jêh ri nti kalơ duk ri, phung ƀon lan gŭ bơh kơh dja, gŭ rŏ meng dak. ");
INSERT INTO cmo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Brah Yêsu ntŭm nti khân păng ŏk ngăn ma nau ngơi ntât kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Iăt hŏ, geh du huê bu klô hăn sui găr ntil. ");
INSERT INTO cmo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nôk păng sui nây aƀă tŭp rŏ trong, jêh ri siŭm chok lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Găr aƀă tŭp ta neh klêr, găr i nây gơnh hon pru yorlah neh n'hơ. ");
INSERT INTO cmo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tât dôh nar tơm i nây ndro ƀrŭng, yor ma reh păng hon mâu jru. ");
INSERT INTO cmo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Găr aƀă jât tŭp ta neh lok, jêh ri lok hon tŏl lĕ phiao, n'ho ma mâu ôh tât play. ");
INSERT INTO cmo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lŏng găr i aƀă jât tŭp ta neh ueh, păng hon pru ueh jêng, n'ho ma tât geh play du găr geh 30, aƀă du găr geh 60, aƀă jât du găr geh 100.” ");
INSERT INTO cmo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jêh ri Brah Yêsu lah tay: “Bu moh tăng nau Gâp ngơi dja, ăn păng nklŏn êng ta săk!” ");
INSERT INTO cmo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nôk Brah Yêsu gŭ ngai đah băl phung, ta nây geh 12 nuyh, mpôl oh mon, ndrel ma bu aƀă đŏng gŭ ndrel Păng, jêh ri khân păng ôp Păng: “May mbơh n'hêl nau ngơi ntât i nây ưh.” ");
INSERT INTO cmo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Brah Yêsu ơh lah: “A lor nơh nau khlay Kôranh Brah mât uănh bunuyh hôm ndŏp mpôn, aƀaơ ri Kôranh Brah ăn ma khân ay may gĭt vât ndơ i nây. Lŏng bunuyh aƀă jât, Gâp ngơi ntât ăn ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ndri tâm di đah Nau Kôranh Brah Ngơi kăl e nơh: ‘Bol lah khân păng uănh ndơ Gâp jan kŏ mâu vât ndơ khlay nau i nây. Khân păng tăng nau Gâp ngơi kŏ mâu vât đŏng. Lah khân păng vât, khân păng rgâl nuih n'hâm djơh, jêh ri Kôranh Brah yô̆ nđach mâu hôm kơp nau tih khân păng’.” ");
INSERT INTO cmo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Brah Yêsu lah tay ma khân păng: “Nau ngơi ntât dja lah khân ay may mâu vât đŏng, mơm khân ay may dơi vât nau ngơi ntât aƀă êng jât hă! ");
INSERT INTO cmo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bunuyh i sui găr ntil nây, kơt bunuyh i mbơh nkoch nau Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Găr ntil i tŭp rŏ trong, tâm ban ma bunuyh i iăt nau Kôranh Brah, jêh iăt dô ma Satăng i kôranh mpôl brah djơh pit lơi nau păng iăt nây ro. ");
INSERT INTO cmo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bunuyh i tâm ban ma găr ntil tŭp ta neh klêr tăng nau Kôranh Brah, khân păng iăt ro răm maak ngăn, ");
INSERT INTO cmo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","hon ueh du ƀlât dơm. Nau Kôranh Brah mâu ôh hon reh ta nuih n'hâm khân păng nơm, ndri tât geh nau jêr êng êng, mâu lah bu jan jêr yor ma nau Kôranh Brah, khân păng mƀăr ro nau nsing. ");
INSERT INTO cmo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bunuyh aƀă jât tâm ban ma găr ntil tŭp ta neh lok, khân păng iăt nau Kôranh Brah đŏng, ");
INSERT INTO cmo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tih ma ta trôm nuih n'hâm khân păng nklŏn rvê hô ngăn ma nau rêh ta neh ntu dja, ŭch rvan kơnh geh drăp ndơ, nđâp ma nuih n'hâm khân păng rŏng geh ma ndơ êng êng. Jêh ri put ƀăr nau Kôranh Brah i nây mâu ăn tât play. ");
INSERT INTO cmo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lŏng khân păng i tâm ban ma găr ntil tŭp ta neh ueh ri, jêh tăng nau Kôranh Brah păng iăt, n'ho ma tât geh play, geh bunuyh aƀă ri du găr jêng geh 30, du găr jêng geh 60, bunuyh aƀă ri jât du găr jêng geh 100 ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jêh ri Brah Yêsu lah ma phung ƀon lan: “Mâu vay say ôh bu mpêh ŭnh sagêng, jêh ri kŭp lơi ma sah, mâu lah tê̆ ta nâm gre. Bu vay yông ŭnh sagêng ăn prêh. ");
INSERT INTO cmo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dâng lĕ ndơ i mpôn mo, Kôranh Brah ăn bu gĭt dadê. Dâng lĕ ndơ i bu mâu say, Păng nhhơ ăn bu say kloh rah vah đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bu moh i tăng nau Gâp ngơi dja ăn păng mân êng ta săk!” ");
INSERT INTO cmo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Ăn khân ay may njrăng ngăn hŏm nau i khân ay may iăt i dja. Kôranh Brah rnhueh ăn ma khân ay may, tâng khân ay may rnhueh ăn ma bu đŏng, jêh ri Păng kơi ntop tay ma khân ay may ăn rlau i nây jât. ");
INSERT INTO cmo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bu moh i lĕ geh, Kôranh Brah kơi ntop ăn ma păng jât, tih ma bu moh i mâu geh, Kôranh Brah sŏ rhuăt lơi lĕ ndơ i păng gĭt lah lĕ geh”. ");
INSERT INTO cmo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Brah Yêsu lah tay: “Nau Kôranh Brah mât uănh bunuyh tâm ban ma du huê bu klô lôh tuch ba ta mir păng nơm, ");
INSERT INTO cmo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","jêh ri a măng bêch, a nar jan kar. Găr ba i nây hon, yơn ma păng mâu gĭt đŏng a mơm ntơm hon. ");
INSERT INTO cmo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Neh ăn găr ba i nây geh hon êng păng nơm. Bơh ntơm păng lôh n'ha, prêh đê̆ prêh đê̆ n'ho ma tât lôh tât mbôn, jêh ri mơ jêng play ba. ");
INSERT INTO cmo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tât ba lĕ dŭm, păng sŏ ndjeo hăn rek, yorlah lĕ di khay rek.” ");
INSERT INTO cmo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Brah Yêsu lah: “Ndri moh ndơ bân tâm rđâl ma nau Kôranh Brah mât uănh bunuyh? Moh nau ngơi ntât bân sŏ ma tâm rđâl đah nau Kôranh Brah mât uănh? ");
INSERT INTO cmo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nau Kôranh Brah mât uănh bunuyh, tâm ban ma du ntil găr si i bu sui ta neh, găr si i nây rhên rlau bu ngăn ma đah găr si dâng lĕ ta neh ntu dja. ");
INSERT INTO cmo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jêh bu sui păng ta neh ri, tât ma hon tơm i nây kuŏng rlau ma tơm aƀă êng jât, geh n'ging geh nthan n'hâm ngăn, n'ho ma geh siŭm gŭ jan rsuăn ta nây.” ");
INSERT INTO cmo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kơt ndri Brah Yêsu ntŭm nti nau Kôranh Brah, Păng dŏng nau ngơi ntât kơt nđa, tâng i ƀon lan dơi vât. ");
INSERT INTO cmo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ƀon lan tăng Păng ngơi nau ngơi ntât dơm, yơn ma nôk Păng gŭ êng, Păng rblang nau i nây ăn ma mpôl oh mon Păng. ");
INSERT INTO cmo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nôk nây Brah Yêsu hôm gŭ ta duk, tât kêng măng nar i nây đŏng, Păng lah ma mpôl oh mon Păng: “Hô̆, bân hăn jât kăl ti dak ri.” ");
INSERT INTO cmo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jêh ri khân păng ncho duk nây du bơh ƀon lan hăn jât kăl ti ri, geh duk aƀă đŏng hăn ndrel khân păng. ");
INSERT INTO cmo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jêh ri dô ma geh phŭt chuănh dŭt hô ngăn. Dak rbuh, lăp ta duk ri bơi ma bêng. ");
INSERT INTO cmo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lŏng Brah Yêsu ri Păng lĕ hăk bêch ta khanơi ta chiăng duk nây. Mpôl oh mon rlay Păng: “Hơi Nơm Nti, lĕ khât ngăn bân! Mơm bêch May thơ lavơ nây?” ");
INSERT INTO cmo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Brah Yêsu kah rngăl Păng dâk đơp, buay phŭt, ndrel ma dak rbuh nây: “Bah hŏm! Rngŏn hŏm!” Jêh ri phŭt bah sial mâu hôm, dak rbuh rngŏn njŭp đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Brah Yêsu lah khân păng: “Mơm dâng khân may klach hô ir kơt nây? Mơm dâng mâu hôm geh nau nsing ma Gâp?” ");
INSERT INTO cmo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ngăn khân păng ta nây klach nsŏr hô, jêh ri tâm lah ndrăng khân păng nơm: “Bu moh Păng i nây hiah, dâng geh ma phŭt, ndrel ma dak rbuh iăt nau Păng?” ");
INSERT INTO cmo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jêh ri Brah Yêsu, ndrel ma oh mon Păng tât kăl ti dak nglao kuŏng Galilê ri, dăch ntŭk ƀon Garasin. Ntŭk ƀon i nây bu mâu ôh tâng nau vay phung Israel. ");
INSERT INTO cmo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jêh Brah Yêsu jŭr bơh duk nây, du ƀlât ta nây geh du huê bu klô brah djơh gŭ ta săk păng, păng lôh bơh ntŭk môch ŭch hăn mâp Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Păng i nây gŭ ta ntŭk môch dơm, mâu geh ôh bunuyh dơi nhŭp dơi kât păng, kât đah rse rvăk kŏ mâu khan đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bol lah bu lĕ nkông jŏng ti, kât păng đah rse rvăk ŏk tơ̆, păng lơh nklah tăch lĕ phiao ndơ i bu nkông bu kât păng nây, mâu geh ôh bunuyh dơi đăp păng. ");
INSERT INTO cmo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dâng măng dâng nar păng gŭ rŏ môch rŏ yôk, nđâp ma nter, jêh ri sŏ lŭ mplônh tor êng săk păng nơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tât păng say Brah Yêsu bơh ngai, păng nchuăt ran chon kômŏk kŭnh bôk bơh năp Brah Yêsu ro, ");
INSERT INTO cmo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","păng nter dŭt nteh nteh ngăn: “Hơi Brah Yêsu kon Kôranh Brah dŭt prêh ta kalơ trôk, mơm May jan ma gâp mêh? Khât ôm lôm lă, ăn May ton ma gâp ta bơh năp Kôranh Brah, dăn May lơi ôh nkrit gâp!” ");
INSERT INTO cmo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Dâng brah djơh lah kơt nây, ach ma Brah Yêsu lĕ jêh lah păng: “Mpôl brah djơh, du hŏm bơh bunuyh dja!” ");
INSERT INTO cmo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jêh ri Brah Yêsu ôp păng: “Mơm rnha may mêh?” “Gâp rnha ‘Mpôl tahen ŏk rbăn’, yor ma băl hên ŏk ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Păng bonh Brah Yêsu hŏl rđŏk: “Lơi dâng mprơh hên du lôh bơh bri dja.” ");
INSERT INTO cmo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kêng ntŭk nây geh sŭr du phung kuŏng gŭ sa mpa rŏ njŏng yôk. ");
INSERT INTO cmo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Phung brah djơh i nây dăn tay dŭt hô ngăn: “Dăn May njuăl ăn hên lăp ta sŭr phung i ri ơ!” ");
INSERT INTO cmo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jêh ri Brah Yêsu ăn khân păng lăp ta sŭr ri. Jêh ri mpôl brah djơh i ri lôh bơh bunuyh i nây lăp gŭ ta sŭr ri lĕ rngŏt. Sŭr phung i nây klăp lah ŏk 2000 mlŏm, jêh ri nchuăt rbŭl jât sop rƀŏng jât dak nglao ri, lăp ta dak rmok khât lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jêh ri mpôl i chiăp sŭr nây, nchuăt mbơh nkoch nau i nây ma bu rŏ ƀon rŏ mir. Bu i tăng ran uănh nau tât i nây. ");
INSERT INTO cmo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Khân păng ran tât a Brah Yêsu, jêh ri say bunuyh i tă brah djơh lăp ŏk ngăn nơh gŭ ta ri, nsoh bok ao n'ho ma kah gĭt săk đŏng, jêh say lĕ nau nây khân păng klach dadê ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mpôl i say n'hêl ma măt lĕ nau tât i geh ta bu klô i nây, ndrel ma sŭr phung nây đŏng, khân păng mbơh nkoch ma phung ƀon lan ta nây ăn gĭt. ");
INSERT INTO cmo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jêh ri ƀon lan bonh Brah Yêsu đă Păng du bơh bri ƀon khân păng nây. ");
INSERT INTO cmo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jêh ri Brah Yêsu nchô ma hăn hao kalơ duk ri. Bu klô i brah djơh lăp a lor nơh dăn tâng Păng. ");
INSERT INTO cmo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yơn ma Brah Yêsu mâu rom ôh, ƀêng Păng ma đă: “Hăn may sât a jay may nơm ri, mbơh nkoch ma băl mpôl may lĕ nau i Kôranh Brah lĕ jan ma may nơh, ndrel ma nau i Kôranh Brah yô̆ nđach may.” ");
INSERT INTO cmo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jêh ri bu klô i nây hăn ro, ntơm mbơh ăn ma ƀon lan ta bri Đêkapôlis ăn khân păng gĭt dâng lĕ nau i Brah Yêsu jan ma păng. Jêh tăng nau păng mbơh nkoch nây ndrŏt hih rhŏl ngăn ƀon lan. ");
INSERT INTO cmo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jêh ri Brah Yêsu ncho duk tât kăl ti dak ri, Păng gŭ ta meng dak nglao kuŏng, ta nây geh ƀon lan ŏk mpưm ngăn hăn gŭ njueng jŭm Păng. ");
INSERT INTO cmo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jêh ri geh du huê bu klô rnha Jairus hăn ta nây đŏng, păng kôranh nhih rƀŭn phung Israel. Tât păng say Brah Yêsu păng ran păn ta jŏng, ");
INSERT INTO cmo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","păng bonh jă Brah Yêsu hô ngăn, păng lah: “Hơi Nơm Nti, kon bu ur gâp ji hô ngăn lĕ bơi khât mê. Dăn May hăn tê̆ ti ta păng ơ, ăn bah nau ji lơi ăn păng khât!” ");
INSERT INTO cmo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jêh ri Brah Yêsu hăn ndrel păng. Geh ŏk ngăn phung ƀon lan hăn tâng Păng đŏng, tât ma tâm mpet băl hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ta mpôl nây geh đŏng du huê bu ur ji rih lĕ jŏ 12 năm hơi. ");
INSERT INTO cmo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ndri păng nsrôyh ngăn ăt nau ji i ŏk phung nơm dak si de săm, tih ma mâu ôh dơi bah. Păng huach lĕ drăp ndơ păng, mâu say bah đê̆ ro, nau ji păng lơ ma hô lơ ma hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tât păng gĭt lư Brah Yêsu hăn ta nây, păng ran chŭl lăp ta nklang băl ŏk pah i ao kuŏng Brah Yêsu bơh kơi. ");
INSERT INTO cmo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Păng mân êng: “Lah gâp geh pah i ao Păng, nau ji gâp bah ro.” ");
INSERT INTO cmo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jêh păng pah ao Brah Yêsu nây, mham păng bah ndal ta nây ro, mâu hôm trôh ôh. Jêh ri păng gĭt êng ta săk nau ji păng lĕ bah ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nôk nây Brah Yêsu gĭt ro geh lôh nau brah tă bơh săk Păng, jêh ri Păng rle jât phung ƀon lan nây lah: “Bu moh pah ao Gâp hiah?” ");
INSERT INTO cmo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mpôl oh mon Păng ơh: “Hơi Kôranh, May say hơi geh bunuyh ŏk ngăn tâm mpet băl geh pah May dadê. Mơm dâng May ôp lah: Bu moh pah Gâp?” ");
INSERT INTO cmo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jêh ri Brah Yêsu uănh jŭm Păng nơm, ŭch gĭt bu moh i pah ao Păng a ndơh nơh. ");
INSERT INTO cmo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Bu ur i nây klach nsŏr ngăn, say nau dơi ta săk păng nơm, păng păn ta jŏng Brah Yêsu jêh ri mbơh lĕ nau i nây, mâu păng mo ôh. ");
INSERT INTO cmo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Brah Yêsu lah ma bu ur nây: “Hơi oh! Nau ay nsing ma Gâp jan bah ay hơi, sât ăn ueh lăng đăp mpăn yơ̆. Nau ji ay ăn bah đŏng!” ");
INSERT INTO cmo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nôk Brah Yêsu hôm e ngơi nây, geh bunuyh aƀă tă bơh jay Jairus mbơh lah: “Kon bu ur may lĕ khât mê. Moh nau hôm rkhuak Nơm Nti nây jât mêh?” ");
INSERT INTO cmo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Brah Yêsu tăng đŏng nau i bu mbơh nây, lơ Păng ma lah ma Jairus: “Lơi dâng klach ôh, ăn may nsing ma Gâp dơm.” ");
INSERT INTO cmo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jêh ri Brah Yêsu hăn, mâu ôh rom bu aƀă hăn tâng Păng. Păng rom pe nuyh Pêtrôs, Yakơ, ndrel ma Yôhan i oh Yakơ dơm. ");
INSERT INTO cmo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tât ta jay Jairus i kôranh nhih rƀŭn nây, Brah Yêsu tăng bu nhŭm vơl dŭt nteh uh ah gah gai ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Brah Yêsu lăp ta trôm jay lah ma khân păng: “Moh nau nhŭm khân ay may uh ah gah gai nây? Mâu khât ôh kon se dja, man ma hăk bêch dơm!” ");
INSERT INTO cmo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jêh tăng nau nây khân păng gơm mưch ma Brah Yêsu. Jêh ri Brah Yêsu mprơh khân păng lôh a dih lĕ rngôch, Păng jă i mê̆ bơ̆ kon se nây, ndrel ma pe nuyh mpôl oh mon Păng lăp ta trôm jrô ntŭk kon se bêch nây. ");
INSERT INTO cmo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jêh ri Păng nhŭp ti kon se nây, n'ho Păng lah: “Talitha kumi” - rblang lah ‘Hơi oh, ay dâk hŏm!’ ");
INSERT INTO cmo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Dô ma kon se bu ur nây dâk đơp, brô̆ ro. Bunuyh i gŭ ndrel ta nây ndrŏt hih rhŏl dŭt hô ngăn. Kon se nây lĕ geh 12 năm hơi. ");
INSERT INTO cmo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yơn ma Brah Yêsu buay khân păng, mâu ôh ăn mbơh nkoch ma bu gĭt nau dja, jêh ri đă khân păng sŏ ndơ ăn kon se nây sông sa. ");
INSERT INTO cmo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jêh ri Brah Yêsu lôh bơh ntŭk nây plơ̆ sât ta ƀon bri Păng nơm ta ƀon Nasaret, mpôl oh mon tâng Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tât nar Saƀăt i nar rlu phung Israel ri, Păng lăp ta trôm nhih rƀŭn ntŭm nti bu, geh ŏk bunuyh i tăng nau Păng ndrŏt hih rhŏl ngăn, khân păng ôp ndrăng khân păng lah: “Bơh tă gĭt nau Păng i nây hiah? Nau mân gĭt blao Păng nây bơh tă sŏ? Ndơ ueh ndơ khlay Păng dơi jan nơh bơh tă dơi? ");
INSERT INTO cmo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Păng nây mâu di i kon Mari jan kar tơm si, i nô Yakơ, Yôsep, Yuđas, ndrel ma Simôn ƀah? I oh bu ur Păng gŭ ta ƀon dja ndrel bân đŏng!” Ndri dâng khân păng ji nuih, kŏ nuih kŏ n'hâm mâu ŭch iăt nau Păng. ");
INSERT INTO cmo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jêh ri Brah Yêsu lah ma khân păng: “Bunuyh ntơyh nau ngơi Kôranh Brah i bu yơk, yơn ma bunuyh ta ƀon păng nơm, ta mpôl băl, ndrel ma ta jay păng nơm vay mưch rmot păng.” ");
INSERT INTO cmo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Lah ndri ta ƀon nây Păng mâu ôh dơi jan ndơ ueh ndơ khlay ŏk, man ma tê̆ ti kalơ bunuyh ji aƀă dơm gay ma ăn bah ji. ");
INSERT INTO cmo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Păng ndrŏt hih rhŏl ngăn yor ma mâu say khân păng geh nau nsing kơt nây. Jêh ri Brah Yêsu hăn rŏ ƀon êng êng, n'ho ma ntŭm nti ăn bu đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Păng kuăl 12 nuyh mpôl oh mon văch a Păng, jêh ri đă khân păng hăn bar hê bar hê rŏ ƀon êng êng, n'ho ma ăn nau dơi ta khân păng mprơh brah djơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Păng ntĭnh ma khân păng: “Hơi oh nô, lơi ôh ndjôt ndoh ndơ hăn trong, ndjôt mŏng jra hŏ, lơi ndjôt ndơ sông sa, dŭng cheng, mâu lah prăk rial nkăr săk, ");
INSERT INTO cmo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","hăn nsoh ntô jot, lơi ôh nsoh ao kuŏng bar blah.” ");
INSERT INTO cmo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Păng lah ma khân păng jât: “Moh jay khân may lăp nây, gŭ ta jay nây hŏ n'ho ma tât khân may lôh bơh ƀon i nây. ");
INSERT INTO cmo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Lah geh ƀon i mâu rom mâu iăt khân may, lôh bơh ƀon i nây, jêh ri rtôh neh môi bơh jŏng khân may nơm, gay ma nhhơ lah ƀon i nây Kôranh Brah tê̆ dôih.” ");
INSERT INTO cmo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jêh ri mpôl oh mon Păng lôh bơh nây hăn ntŭm nti đă bu rgâl nuih n'hâm djơh. ");
INSERT INTO cmo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mpôl khân păng dơi mprơh brah djơh ŏk lôh bơh bunuyh, n'ho ma tŏ dak ngi ta bunuyh ji ŏk ngăn ăn bah bơh nau ji. ");
INSERT INTO cmo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jêh ri kađăch Hêrôt-Ŏntipas gĭt ro nau Brah Yêsu jan, yor ma lư săk Brah Yêsu nây hô ngăn. Geh bu ƀaƀă ngơi lah: “Yôhan-Ƀaptem lĕ dâk rêh tay, ndri dâng Păng i nây geh nau dơi jan lĕ nau kơt nây.” ");
INSERT INTO cmo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bu aƀă êng lah: “Păng i nây i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh rnha Êliya.” Bu aƀă jât lah: “Păng i nây du huê bunuyh ntơyh nau ngơi Kôranh Brah tâm ban ma bunuyh ntơyh rnôk kăl e nơh đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lŏng kađăch Hêrôt ri, jêh păng gĭt lĕ nau i nây, păng lah: “Păng dja ngăn Yôhan i gâp đă tahen koh tong ko nơh, aƀaơ păng lĕ dâk rêh tay.” ");
INSERT INTO cmo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kađăch Hêrôt lah ndri, yorlah bơh ntơm nơh păng đă tahen nhŭp Yôhan kât krŭng ta ndrung ri, yor ma nau pit ur i oh păng rnha Philip, jêh ri kađăch Hêrôt sŏ ndă i ur Philip rnha Hêrôđias jan ur sai. ");
INSERT INTO cmo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jêh gĭt ndri Yôhan lĕ jêh lah kađăch Hêrôt: “Mâu ôh di đah nau vay may sŏ ur oh jan ur may.” ");
INSERT INTO cmo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jêh ri Hêrôđias ji nuih ŭch nkhât lơi Yôhan nây, mâu dơi ôh, yor ma kađăch Hêrôt mâu ăn. ");
INSERT INTO cmo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kađăch Hêrôt klach Yôhan-Ƀaptem, kơp păng bunuyh sŏng bunuyh kloh ueh. Ndri kađăch Hêrôt ŭch nking păng bơh Hêrôđias. Kađăch Hêrôt ŭch ngăn tăng nau păng ngơi, yơn ma nau ngơi i nây jan ăn ta nuih n'hâm kađăch Hêrôt geh nau mân rvê hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Geh du nar ri di nar kah gĭt nar deh kađăch Hêrôt, păng ndrăp nau nhêt sông kuŏng ngăn. Păng jă bunuyh i kơl păng mât uănh, jă kôranh tahen, ndrel ma bunuyh têh bunuyh ndrŏng i gŭ ta bri Galilê nây. Ta nar nây ro geh nau bu ur Hêrôđias dơi jan. ");
INSERT INTO cmo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jêh ri i kon drôh Hêrôđias lăp rŏm ta ntŭk nhêt sông nây, tât kađăch Hêrôt, ndrel ma dâng lĕ bu năch i gŭ ta nây say, khân păng răm ngăn, jêh ri kađăch lah ma păng: “Moh ndơ ay ŭch, dăn ma gâp dô, gâp ăn ma ay ro!” ");
INSERT INTO cmo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","N'ho ma ton lah: “Moh ntil ndơ ay dăn ma gâp, gâp ăn ma ay ro, bol lah plah du đah bri i gâp mât uănh kađôi.” ");
INSERT INTO cmo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bu drôh nây lôh ƀhŭch bơh ntŭk nây hăn ôp i mê̆ păng: “Hơi mê̆, moh ndơ gâp dăn êh?” I mê̆ păng ơh: “Dăn i bôk Yôhan-Ƀaptem!” ");
INSERT INTO cmo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jêh ri păng plơ̆ brŭl bơh nây mbơh ma kađăch nây ro: “Gâp ŭch dăn i bôk Yôhan-Ƀaptem tê̆ kalơ ngan thang aƀaơ ri ro!” ");
INSERT INTO cmo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jêh tăng nau dăn i nây kađăch nduih tôr hô ngăn, tih ma mâu rlăch ôh, yor ma kađăch lĕ jêh ton bơh năp phung bu năch i gŭ ta nây. ");
INSERT INTO cmo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kađăch đă ro du huê tahen hăn sŏ i bôk Yôhan. Tât ta ndrung ri, păng koh tong ko Yôhan, ");
INSERT INTO cmo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","sŏ i bôk tê̆ kalơ ngan thang, jêh ri ndơ̆ ăn ma bu drôh nây. Bu drôh i nây ndjôt ndơ̆ ăn ma i mê̆ păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tât mpôl oh mon Yôhan gĭt nau i nây, khân păng leo băl hăn sŏ i săk păng njor ta trôm môch lŭ. ");
INSERT INTO cmo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jêh mpôl kôranh oh mon Brah Yêsu plơ̆ sât bơh ntŭk êng êng, khân păng nkoch ma Brah Yêsu dâng lĕ ndơ i khân păng jan, ndrel ma nau khân păng geh ntŭm nti nơh. ");
INSERT INTO cmo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ta ntŭk nây geh ŏk bunuyh hăn lôh lăp, ndri Brah Yêsu, ndrel ma mpôl oh mon Păng gay ma sông sa mâu ôh dơi ru. Jêh ri Brah Yêsu đă mpôl oh mon Păng: “Hô̆ hăn leo băl joi ntŭk ƀah ngai ma phung ƀon lan, rlu du ndŏm ƀŏt.” ");
INSERT INTO cmo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jêh ri khân păng lôh bơh ntŭk nây jŭr ncho duk hăn jât ntŭk êng ƀah ma bu. ");
INSERT INTO cmo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Khân păng ncho duk rŏ dak nây geh ŏk bunuyh say gĭt năl khân păng i nây. Tât ƀon lan gĭt ntŭk Păng hăn ri, jêh ri leo băl lôh tă bơh ƀon êng êng, nchuăt grŭng lor bơh năp ri. ");
INSERT INTO cmo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nôk Brah Yêsu jŭr bơh duk nây say phung ƀon lan ŏk mpưm ngăn, Păng geh nau yô̆ nđach ma khân păng ngăn, say khân păng i nây tâm ban ma phung be biăp i mâu geh bunuyh mât uănh. Ndri Păng ntŭm nti ŏk ntil nau ăn ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tât nar lĕ dêh, mpôl oh mon hăn mbơh ma Brah Yêsu lah: “Ta dja ntŭk rdah ngai bơh ƀon mâu ôh geh ndơ sa, nar lĕ bơi nhŏp đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","May đă khân păng plơ̆ sât joi ndơ rvăt ma sông sa rŏ jay rŏ ƀon i dăch dăch oi ta dja.” ");
INSERT INTO cmo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Brah Yêsu ơh ma khân păng lah: “Khân may ăn bu sông sa heh!” Khân păng ơh lah: “Ndri hên sŏ prăk 200 prăk kăk, hăn rvăt nŭmpăng ăn ma phung ƀon lan de sa bơh?” ");
INSERT INTO cmo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Brah Yêsu lah ma khân păng: “Uănh ƀŏt heh, dah ŏk geh nŭmpăng khân may?” Tât ma gĭt nây khân păng mbơh ma Păng: “Geh prăm mlŏm nŭmpăng, bar mlŏm ka dơm.” ");
INSERT INTO cmo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jêh ri Brah Yêsu mbơh ma mpôl oh mon Păng, đă phung ƀon lan gŭ du mpôl du mpôl, kalơ rêp nse nây. ");
INSERT INTO cmo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ndri khân păng gŭ, mpôl aƀă geh 100 nuyh, mpôl aƀă geh 50 nuyh. ");
INSERT INTO cmo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jêh ri Brah Yêsu sŏ prăm mlŏm nŭmpăng, ndrel ma bar mlŏm ka ri, Păng n'gơr măt jât lơ mbơh sơm ndơ sông sa i nây ma Kôranh Brah. Lôch jêh Păng gĭch nŭmpăng i nây ndơ̆ ăn oh mon, đă khân păng pă ăn bu sa, n'ho ma pă ka i bar mlŏm nây ăn dâng lĕ bunuyh đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jêh tâm pă ndơ sa i ri, dâng lĕ bunuyh gŭ sa ta nây hơm dadê. ");
INSERT INTO cmo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jêh ri mpôl oh mon rgum nŭmpăng, ndrel ma ka i hôm rmeh nây geh 12 sah. ");
INSERT INTO cmo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Phung ƀon lan i sa nây nơh kơp i bu klô ŏk 5000 nuyh. ");
INSERT INTO cmo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Du ndŏm nây, Brah Yêsu đă mpôl oh mon Păng hăn lor ncho duk mpeh jât kăl ti dak ri, jât ƀon Ƀêtsaida ri, jêh ri Păng đă dâng lĕ phung ƀon lan i gŭ ta nây plơ̆ sât. ");
INSERT INTO cmo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jêh đă ndri Brah Yêsu lôh bơh nây hăn hao kalơ yôk mbơh sơm ta ri. ");
INSERT INTO cmo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tât nar lĕ nhŏp duk i oh mon ncho nây nchô ma ta nklang dak nglao kuŏng ri, i Brah Yêsu ri hôm gŭ êng kalơ kơh. ");
INSERT INTO cmo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Păng uănh say mpôl oh mon Păng vah duk ran huan jêr ngăn hăn rlơ̆ jât tơm sial. Tât bri lĕ bơi ang Brah Yêsu brô̆ kalơ dak nglao kuŏng ri brô̆ dăch kêng oh mon Păng, jêh ri Păng ŭch hăn n'hot. ");
INSERT INTO cmo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tât say Păng brô̆ kalơ dak nglao nây, khân păng nter drơu, nđôn lah chiak nhhu. ");
INSERT INTO cmo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Lĕ khân păng say dadê klach nsŏr ngăn, ndri Brah Yêsu ngơi ma khân păng ro: “Lơi klach ôh, ăn nuih n'hâm bănh, Gâp ya!” ");
INSERT INTO cmo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jêh ri Păng hao ncho duk ndrel khân păng, sial dô ma bah rngŏn njŭp ro. Ndrŏt hih rhŏl ngăn mpôl oh mon ta nây, ");
INSERT INTO cmo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","yorlah khân păng mâu hŏ ôh dơi gĭt nau nŭmpăng nơh, khân păng hôm dăng ko. ");
INSERT INTO cmo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jêh ri Brah Yêsu, ndrel ma oh mon tât mpeh kăl ti dak ri, ta bri Gênêsaret. Khân păng nsrŭng ta nây kât duk ta meng dak ri, ");
INSERT INTO cmo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","jêh ri khân păng hao kalơ kơh. Tât ma say, dâng lĕ bunuyh i gŭ ta nây gĭt năl Păng ro, ");
INSERT INTO cmo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ndri bu hăn nchuăt tă bơh ăp ntŭk ƀon, leo băl tung bunuyh ji hăn ta ntŭk i bu lư lah Păng gŭ ri. ");
INSERT INTO cmo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ăp ntŭk i Brah Yêsu hăn, bol lah ta bri ta ƀon, mâu lah ta ƀon kuŏng kađôi, bu leo bunuyh ji ăn gŭ ta ntŭk bu tăch drăp, jêh ri dăn bonh Păng sơm ma geh pah chiăng ao kuŏng Păng đê̆ đê̆ eng, ndri dâng lĕ bunuyh i geh pah ao kuŏng Păng bah dadê ro nau ji. ");
INSERT INTO cmo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Geh du nar ri phung Pharisi, ndrel ma nơm nti aƀă tă bơh ƀon kuŏng Yêrusalem hăn mâp Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tât ta nây khân păng say mpôl oh mon Brah Yêsu sông sa ma ti i khân păng kơp mâu kloh tâng ma nau vay ơm đă, yor ma mpôl oh mon i nây mâu rao ti lor sông sa. ");
INSERT INTO cmo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Phung Pharisi, ndrel ma phung Israel dâng lĕ ndjôt tâng nau vay ơm bơh bu ranh khân păng nơm kăl e nơh, ê lor ma sông sa khân păng rao ti, ri mơ sông sa. ");
INSERT INTO cmo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Geh đŏng sât tă bơh ntŭk bu tăch drăp, lah khân păng sông sa mâu geh rao tâng nau vay lor, ndri klach Kôranh Brah mâu sŏ dơn. Khân păng ndjôt mâu ntlơi nau vay êng êng ŏk đŏng, kơt ma rao keo rao ndoh rao glah jan ma kông rao gre đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ndri phung Pharisi, ndrel ma phung nơm nti ôp Brah Yêsu lah: “Moh nau mpôl oh mon May mâu ndjôt tâng nau vay ơm bu ranh, sông sa ma ti mâu kloh kơt nây?” ");
INSERT INTO cmo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Brah Yêsu lah ma khân păng: “Nau Êsai i bunuyh ntơyh nau ngơi Kôranh Brah lĕ nchih kăl e nơh, gâp lĕ say păng nchih tâm di đah khân may. Khân may jan iăt nau Kôranh Brah dơm, Êsai lĕ nchih lah: ‘Kôranh Brah lah: ‘Phung ƀon lan dja yơk mbah Gâp ma bŏr mbung dơm, Ta nuih n'hâm khân păng gŭ ngai đah Gâp. ");
INSERT INTO cmo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Khân păng yơk mbah ma Gâp mâu geh ôh ntil khlay, đê̆ mâu ơm, Yor ma khân păng ntŭm nti sŏ nau vay tă bơh bunuyh dơm. Tih ma khân păng lah mƀrôh nau vay i nây tă bơh Gâp đă’’. ");
INSERT INTO cmo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nau vay i tă bơh Kôranh Brah khân may mƀăr lơi, ƀêng ma ndjôt tâng nau vay bunuyh.” ");
INSERT INTO cmo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Păng lah jât: “Khân may blao ngăn tâng nau vay bunuyh n'ho ma mâu hôm iăt nau vay Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ntât lah Môsê lĕ nchih kăl e nơh lah: ‘Ăn khân ay may yơk mbah hŏm ma mê̆ bơ̆’, jêh ri ‘Bu moh rak suai ma mê̆ bơ̆ păng nơm, păng i nây geh dôih tât bu nkhât ro’. ");
INSERT INTO cmo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tih ma khân may lah nđa: ‘Lah du huê bunuyh ngơi ma i mê̆ bơ̆ lah, moh ndơ i gâp ŭch kơl ma mê̆ bơ̆, ndơ i nây lah lĕ Kôrƀăn’ - nau ‘Kôrƀăn’ dja rblang lah ‘Ndơ nhhơr ma Kôranh Brah’. ");
INSERT INTO cmo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jêh ri bunuyh i ngơi kơt nđay, khân may mâu hôm ôh ăn păng kơl ma mê̆ bơ̆. ");
INSERT INTO cmo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ndri dâng khân may jut lơi nau vay Kôranh Brah, nkhơng ma sŏ nau vay ơm bơh bu ranh. Khân may jan ndơ êng êng ŏk ngăn, kơt ndơ i nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jêh ri Brah Yêsu kuăl lĕ phung ƀon lan i gŭ dăch ta nây, lah ma khân păng: “Lĕ oh nô kônh va iăt nau Gâp ler nger ƀŏt ăn gĭt vât nau dja: ");
INSERT INTO cmo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Lĕ ndơ bơh dih i lăp ta trôm săk bunuyh, mâu dơi ôh jan ăn bunuyh jêng mâu kloh, lĕ ndơ i lôh bơh bunuyh, ndơ i nây dơi jan ăn jêng mâu kloh. ");
INSERT INTO cmo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Bu moh tăng nau Gâp ngơi dja, ăn păng mân êng ta săk!” ");
INSERT INTO cmo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jêh ri Brah Yêsu lôh bơh phung ƀon lan hăn lăp ta trôm jay, ta nây mpôl oh mon Păng leo băl ôp Păng ma nau nti i nây. ");
INSERT INTO cmo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Păng lah ma khân păng: “Ndri khân may mâu hŏ gĭt vât đŏng ƀah? Ăn khân may gĭt vât nau dja, lĕ ndơ tă bơh dih i lăp ta săk bunuyh mâu dơi ôh jan ăn bunuyh i nây jêng mâu kloh, ");
INSERT INTO cmo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","yor ma ndơ i nây mâu geh ôh lăp ta trôm nuih n'hâm, lăp ta trôm ndŭl dơm, jêh ri lôh lĕ phiao.” - Ndri Păng mbơh lah lĕ ndơ sông sa jêng di ma sa dadê ngăn. - ");
INSERT INTO cmo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Păng lah jât: “Geh ndơ i lôh bơh bunuyh dơm dơi jan ăn bu jêng mâu kloh, ");
INSERT INTO cmo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","yorlah dâng lĕ nau mân djơh djơt lôh tă bơh nuih n'hâm bunuyh, nau mân i nây leo jêng khơh kler, ntŭng bu, nkhât bu, ");
INSERT INTO cmo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lŏm ur lŏm sai, rvan kơnh geh ma drăp ndơ, jan ndơ djơh, mƀrôh bu, mâu geh nau đit, ŭch ma nau tâm pit, ngơi nchơt, nau hưn, ndrel ma nau mâu hôm ôh gĭt ndơ ueh ndơ djơh. ");
INSERT INTO cmo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Lĕ nau djơh i nây lôh tă bơh nuih n'hâm bunuyh, jan ăn jêng mâu kloh.” ");
INSERT INTO cmo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jêh ri Brah Yêsu, ndrel ma oh mon Păng lôh bơh ntŭk nây, hăn ta bri i dăch đah ƀon kuŏng Tirus ndrel ma ƀon kuŏng Siđôn ri. Tât ta du ƀon khân păng lăp gŭ ta du mlŏm jay, mâu ŭch ôh ăn bu gĭt lah Păng gŭ ta nây, tih ma mâu ôh dơi ndŏp. ");
INSERT INTO cmo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Du ndŏm geh du huê bu ur tăng bu nkoch Brah Yêsu gŭ ta nây. I kon bu ur păng ri brah djơh lăp, jêh ri păng hăn ta jay i nây păn ta jŏng Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Bu ur i nây mâu ôh di phung Israel, i ƀon tơm păng dăch ma ƀon Phênisi ta bri Siri. Jêh ri păng bonh đă Brah Yêsu mprơh brah djơh i nây ăn lôh bơh i kon păng ri. ");
INSERT INTO cmo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Brah Yêsu ngơi ntât ma păng: “Ăn oh kon sông sa hơm ƀŏt, mâu di ôh sŏ piăng trao oh kon mƀăr ăn so sa chrao.” ");
INSERT INTO cmo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bu ur i nây ơh lah: “Ngăn kôranh mê! Bol lah mâu mƀăr piăng trao kađôi, so hôm gŭ ta nâm gre ntêr sa piăng trao ndăk i oh kon geh tŭp nơh đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tât tăng nau bu ur lah nây Brah Yêsu lah ma păng: “Yor ma ay ngơi ndri, brah djơh lĕ lôh bơh kon ay hơi, ay plơ̆ sât a ri dôh.” ");
INSERT INTO cmo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Păng sât tât ta jay say i kon păng bêch ueh kalơ gre ri, brah djơh lĕ lôh bơh kon păng nây jêh. ");
INSERT INTO cmo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jêh ri Brah Yêsu lôh bơh bri i dăch đah ƀon kuŏng Tirus hăn glăt rŏ ƀon kuŏng Siđôn n'ho ma tât ta bri Đêkapôlis i dăch ma dak nglao kuŏng Galilê ri. ");
INSERT INTO cmo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jêh ri ta nây bu leo du huê bu klô tâk tôr hăn ta Brah Yêsu. Bu klô i nây mâu lăng blao ngơi đŏng. Bu bonh Păng đă tê̆ ti ta bu klô i tâk tôr nây, gay ma bah nau ji bu klô i nây. ");
INSERT INTO cmo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jêh ri Brah Yêsu leo bu klô i nây hăn gŭ ntŭk êng ƀah đê̆ ma phung ƀon lan, Păng lŏk lau ti ta trôm tôr bu klô i nây, soh dak diu ta lau ti Păng nơm tê̆ ta mpiăt bu klô i nây. ");
INSERT INTO cmo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jêh ri Brah Yêsu n'gơr kalơ trôk ri, nsôr n'hâm kuŏng djhut, Păng lah: “Ephatha” - rblang lah ‘Ăn pơk hŏm’. ");
INSERT INTO cmo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Du ndŏm dô ma tôr bu klô i nây iăt tăng ro, mpiăt blao rlăm n'ho ma ngơi kloh rah vah ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jêh ri Brah Yêsu buay khân păng lơi ôh nkoch nau dja ma bu. Păng buay lơi dâng nkoch nau i nây, yơn ma khân păng lơ ma hô ngăn nkoch nau i nây. ");
INSERT INTO cmo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Dâng lĕ bunuyh i tăng nau i nây ndrŏt hih rhŏl ngăn, jêh ri lah: “Lĕ ndơ i Păng jan nây jêng ueh dadê ngăn, bol lah bunuyh tâk tôr Păng jan ăn tăng, bunuyh mlo jêng blao ngơi đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nôk nây geh đŏng phung ƀon lan ŏk ngăn hăn gŭ rgum băl jât. Khân păng mâu geh ôh ndơ ma sông sa, ndri Brah Yêsu kuăl mpôl oh mon Păng, Păng lah: ");
INSERT INTO cmo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Gâp yô̆ ngăn ma phung ƀon lan nây, khân păng gŭ ndrel Gâp lĕ pe nar hơi, ndơ ma sông sa mâu geh đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Lah Gâp đă khân păng plơ̆ sât ndŭl dơm, rgănh chôt rŏ trong ro. Bu aƀă brô̆ tă bơh ƀon ngai ngai.” ");
INSERT INTO cmo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mpôl oh mon ơh lah: “Ta dja rngot rngăt, ah ntŭk joi ndơ ma ăn khân păng sông sa ma tŏng?” ");
INSERT INTO cmo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Brah Yêsu ôp khân păng: “Ndri khân may dah ŏk geh nŭmpăng hă?” “Geh pơh mlŏm.” ");
INSERT INTO cmo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jêh ri Brah Yêsu đă phung ƀon lan gŭ rơp gơp ta neh ri, Păng sŏ nŭmpăng pơh mlŏm nây, mbơh sơm lah ueh ma Kôranh Brah, Păng gĭch ăn ma mpôl oh mon pă ma phung ƀon lan nây, jêh ri khân păng jan kơt nây. ");
INSERT INTO cmo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Geh ka jê̆ aƀă đŏng, ndri Brah Yêsu mbơh sơm lah ueh ma Kôranh Brah, jêh ri đă mpôl oh mon pă ka i nây ăn ma phung ƀon lan. ");
INSERT INTO cmo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jêh jan ndri lĕ khân păng sa hơm rôch đhôch, jêh ri rgum nŭmpăng, ndrel ma ka i rmeh nây geh pơh sah. ");
INSERT INTO cmo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Dâng lĕ bunuyh ta nây nơh ŏk 4000 nuyh. Jêh bơh nây Brah Yêsu đă khân păng plơ̆ sât a jay ri. ");
INSERT INTO cmo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Du ndŏm bơh kơi nây, Păng ncho duk ndrel mpôl oh mon Păng hăn jât bri Đălmanutha. ");
INSERT INTO cmo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jêh khân păng tât ta ri, phung Pharisi leo băl mâp Brah Yêsu tâm rlăch ma Păng, đă Păng jan du nau mbên ueh ăn gĭt n'hêl lah Păng dơn nau dơi tă bơh Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jêh tăng nau khân păng đă nây, Brah Yêsu nsôr n'hâm kuŏng djhut, jêh ri lah: “Mơm dâng bunuyh ta rnôk aƀaơ dja ŭch gĭt say nau mbên kơt ri? Gâp lah n'hêl nanê̆ ngăn ma khân may, Kôranh Brah mâu ôh ăn say nau mbên ma bunuyh rnôk aƀaơ dja.” ");
INSERT INTO cmo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jêh ri Brah Yêsu du bơh khân păng nây, ncho duk hăn tay jât mpeh kăl ti ri. ");
INSERT INTO cmo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jêh ri mpôl oh mon lĕ chuêl ndjôt nŭmpăng, ta duk nây geh du mlŏm nŭmpăng dơm. ");
INSERT INTO cmo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jêh ri Brah Yêsu ngơi nkah ma khân păng: “Ăn khân may njrăng ngăn ma ndrui phung Pharisi, ndrel ma ndrui kôranh mât uănh Hêrôt-Ŏntipas đŏng”. ");
INSERT INTO cmo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mpôl oh mon ngơi ndrăng khân păng nơm: “Păng ngơi kơt nây ach bân mâu geh nŭmpăng dơm mâu?” ");
INSERT INTO cmo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Brah Yêsu gĭt nau khân păng ngơi, Păng lah: “Moh ngơi khân mre nau mâu geh nŭmpăng nây? Khân may mâu say iăt, mâu say gĭt vât nau đŏng? Khân may hôm dăng ko ƀah? ");
INSERT INTO cmo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Khân may geh dơm trôm măt uănh mâu say, geh dơm tôr iăt mâu tăng ƀah? Ndri khân may lĕ chuêl ƀah, ");
INSERT INTO cmo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","nôk Gâp gĭch prăm mlŏm nŭmpăng pă ăn ma bunuyh 5000 nuyh nơh? Jêh ri khân may rgum nŭmpăng i rmeh nơh dah ŏk hôm?” Khân păng ơh lah: “12 sah.” ");
INSERT INTO cmo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ndri nôk Gâp gĭch nŭmpăng pơh mlŏm pă ăn ma bunuyh 4000 nuyh nơh, khân may rgum dah ŏk hôm?” Khân păng ơh lah: “Hôm pơh sah.” ");
INSERT INTO cmo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jêh ri Brah Yêsu lah ma khân păng: “Mơm khân may ê hŏ gĭt vât đŏng?” ");
INSERT INTO cmo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jêh ri Brah Yêsu, ndrel ma mpôl oh mon tât ta ƀon Ƀêtsaida. Ta nây geh bu leo du huê bu klô cheh măt hăn ta Păng, jêh ri bonh đă Păng pah bu klô i nây, gay ma bah nau ji. ");
INSERT INTO cmo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jêh ri Păng têk ti bu klô i cheh măt nây, leo hăn lôh bơh dih ƀon, Păng soh dak diu mhâng kalơ trôm măt, n'ho ma tê̆ ti, jêh ri ôp păng: “May lĕ say ndơ bơh?” ");
INSERT INTO cmo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bu klô i nây ngơk uănh, mbơh lah: “Gâp say bunuyh brô̆ n'gui n'gai, uănh khân păng tâm ban ma tơm si.” ");
INSERT INTO cmo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Brah Yêsu tê̆ ti kalơ trôm măt păng du tơ̆ jât, jêh ri păng uănh say dâng lĕ ndơ kloh rah vah, trôm măt păng lĕ bah ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jêh ri Brah Yêsu đă păng: “May sât brŏng a jay may nơm ri, lơi dâng lăp rŏ ƀon yơ̆.” ");
INSERT INTO cmo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jêh ri Brah Yêsu, ndrel ma mpôl oh mon Păng lôh bơh nây, hăn ta ƀon êng êng dăch đah ƀon kuŏng Sêsara-Philip. Nôk hăn rŏ trong Păng ôp khân păng: “A mơm bu lah Gâp?” ");
INSERT INTO cmo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mpôl oh mon ơh lah: “Aƀă lah May jêng Yôhan-Ƀaptem i lĕ dâk rêh, aƀă lah jêng Êliya i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ plơ̆ ta dja, aƀă jât lah May jêng du huê bunuyh i êng nơm ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ dâk rêh.” ");
INSERT INTO cmo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jêh ri Brah Yêsu ôp ma khân păng nơm: “Ndri khân may lah Gâp bu moh hă?” Pêtrôs ơh ma Păng: “May i Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl ngăn!” ");
INSERT INTO cmo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jêh ri Brah Yêsu buay mpôl oh mon, mâu ôh ăn khân păng nkoch nau nây ma bu. ");
INSERT INTO cmo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jêh ri Brah Yêsu ntơm ntŭm nti ma mpôl oh mon Păng nây, Păng lah: “Gâp i Kon Bunuyh tă bơh Kôranh Brah, mâu ôh dơi klaih geh nau jêr jŏt dŭt hô ngăn. Mpôl bu ranh, mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay bân mƀăr lơi Gâp, n'ho ma nkhât Gâp đŏng, yơn ma tât pe nar bơh kơi Gâp dâk rêh tay.” ");
INSERT INTO cmo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Păng nkoch ma khân păng sŏng sŏng ngăn, mâu geh ôh pôn mo. Jêh ri Pêtrôs jă Brah Yêsu hăn ntŭk êng ƀah ma bu, jêh ri buay Păng lơi ta ngơi kơt nây. ");
INSERT INTO cmo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Brah Yêsu rle uănh jât mpôl oh mon, jêh ri Păng lah Pêtrôs: “Hơi Satăng, may du ngai bơh Gâp hŏm, nau mân may mâu di đah nau mân Kôranh Brah ôh, nau mân nây tă bơh bunuyh dơm.” ");
INSERT INTO cmo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jêh ri Brah Yêsu kuăl phung ƀon lan, ndrel ma mpôl oh mon, Păng lah ma khân păng: “Bu moh păng i ŭch tâng Gâp, ăn mƀăr lơi ndơ săk păng nơm ŭch, jêh ri tui si tâm rkăng păng nơm, jêng geh nau khlay iăt nau Gâp, bol lah tât khât săk kađôi, ri mơ dơi tâng Gâp ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yorlah bu moh i kơp êng nau rêh păng nơm khlay rlau, păng i nây mâu ôh geh nau rêh n'ho ro, yơn ma bu moh khât yor ma tâng Gâp, mâu lah yor ma nau mhe mhan ueh, păng i nây geh nau rêh n'ho ro ngăn ta nar jât năp tay. ");
INSERT INTO cmo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lah du huê bunuyh păng geh dâng lĕ neh ntu dja jêng drăp ndơ păng nơm dadê, tih ma săk păng nơm khât roh hêng, mâu ôh geh nau rêh n'ho ro, ndri moh geh nau khlay ma păng? ");
INSERT INTO cmo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bunuyh ơm dơi lah sŏ drăp ndơ ma rgâl nau rêh păng nơm n'ho ro? ");
INSERT INTO cmo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aƀaơ dja khân ay may gŭ ndrel bunuyh djơh bunuyh tih mâu iăt nau Kôranh Brah. Bu moh i đit prêng mâu bănh mbơh păng tâng Gâp, đit prêng tâng nau Gâp nti đŏng, lah ndri Gâp i Kon Bunuyh tă bơh Kôranh Brah đit prêng mâu gĭt năl păng i nây đŏng ta nar Gâp plơ̆ văch, nđâp ma geh nau ueh chrêk lơp Bơ̆ Gâp, ndrel ma phung tông păr kloh ueh.” ");
INSERT INTO cmo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jêh ri Brah Yêsu lah: “Gâp lah n'hêl nanê̆ ngăn ma khân ay may, bunuyh aƀă i gŭ ta dja mâu khât ôh, ê lor ma say nau dơi Kôranh Brah mât uănh.” ");
INSERT INTO cmo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Geh prao nar bơh kơi nây Brah Yêsu jă Pêtrôs, Yakơ, ndrel ma Yôhan hao kalơ yôk prêh, mâu ôh leo bu a êng hăn. Ta nây săk jăn Păng rgâl bơh năp khân păng, ");
INSERT INTO cmo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","i bok ao Păng jêng nglang ang chrat ngăn, mâu geh ôh bunuyh ta neh ntu dja dơi jan tâm ban kơt nây. ");
INSERT INTO cmo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ta nây pe nuyh mpôl oh mon dô ma say bunuyh bar hê i ntơyh nau ngơi Kôranh Brah bơh kăl e, rnha Êliya, ndrel ma Môsê gŭ ngơi ndrel Brah Yêsu ta nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jêh say lĕ nau i nây, Pêtrôs lah ma Brah Yêsu: “Hơi Nơm Nti! Bân gŭ ta dja ueh ngăn mê, ăn hên jan pe mlŏm chun, du mlŏm ăn ma May, du mlŏm ăn ma Môsê, du mlŏm jât ăn ma Êliya.” ");
INSERT INTO cmo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nau Pêtrôs ngơi kơt nây păng nơm mâu ôh gĭt săk, dah ma lôh mbung ngơi, yor ma khân păng klach hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jêh ri geh tŭk nkŭm kalơ khân păng lĕ rngôch, tăng nteh ngơi tă bơh tŭk nây lah: “Păng dja Kon Gâp i Gâp rŏng hô ngăn, iăt nau Păng dô!” ");
INSERT INTO cmo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Du ndŏm ta nây, mpôl oh mon uănh jŭm khân păng nơm ri, mâu hôm ôh say bunuyh, say du huê Brah Yêsu dơm gŭ ndrel khân păng ta nây. ");
INSERT INTO cmo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jêh ri Brah Yêsu, ndrel ma pe nuyh oh mon Păng jŭr tă bơh yôk, Păng buay khân păng mâu ôh ăn nkoch nau i khân păng say nơh ma bu, n'ho ma tât Păng i Kon Bunuyh tă bơh Kôranh Brah dâk rêh tay. ");
INSERT INTO cmo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ndri khân păng iăt tâng nau Păng lah, tâm ôp ndrăng khân păng nơm: “Ndri ‘Nau dâk rêh tay’, moh nau khlay hiah?” ");
INSERT INTO cmo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jêh ri khân păng ôp Brah Yêsu: “Moh nau dâng phung nơm nti nau vay phung bân nti lah Êliya iăt ma păng văch lor ta dja, Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl văch bơh kơi ro?” ");
INSERT INTO cmo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Păng ơh ma khân păng lah: “Di ngăn nau pre lah, Êliya văch lor, gay ma kơi ndrăp ăn ăp dâng lĕ rngôch, tih ma mơm dâng bu nchih ta trôm samƀŭt lah Gâp i Kon Bunuyh tă bơh Kôranh Brah geh nau jêr jŏt dŭt hô, bu mưch rmot đŏng? ");
INSERT INTO cmo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Gâp mbơh ma khân may, Êliya lĕ jêh văch gŭ ta neh ntu dja hơyh, lŏng bu aƀă jan jêr ma ôbăl i nây ăp mpơ̆ lơ̆ ntil, dah ŭch bu jan tâng ma nau bu geh nchih lor ma păng nơh.” ");
INSERT INTO cmo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jêh ri Brah Yêsu, ndrel ma pe nuyh oh mon ri plơ̆ tât ta ntŭk oh mon dâng lĕ i gŭ ta nây, say ŏk phung ƀon lan jŭm oh mon Păng nây, geh nơm nti nau vay phung Israel ƀaƀă tâm rlăch đah khân Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tât phung ƀon lan say Brah Yêsu dâng lĕ khân păng ndrŏt rôh prôh nchuăt ran ôp ueh lăng Păng. ");
INSERT INTO cmo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Păng ôp khân păng: “Moh nau tâm rlăch khân mre đah khân păng ndơh nơh?” ");
INSERT INTO cmo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jêh ri geh du huê bu klô ta phung ƀon lan nây ơh ma Păng: “Hơi Nơm Nti! Gâp leo kon bu klô gâp i brah djơh lăp ta săk păng, jan ăn păng mlo mâu blao ngơi. ");
INSERT INTO cmo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tât brah djơh i nây lơh ntơ̆ ntơ̆ kon gâp chôt ta neh dăng jŏng dăng ti, lôh mpŭnh dak diu, rchiăt sêk rchiăt neng, ndri mê̆. Gâp đă mpôl oh mon May mprơh đŏng, khân păng mprơh mâu ôh dơi lôh.” ");
INSERT INTO cmo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Brah Yêsu ơh ma khân păng: “Hơi phung bunuyh mâu geh nau nsing ma Kôranh Brah! Dah hôm jŏ ăn Gâp gŭ ndrel khân ay may hiah? Dah hôm jŏ ăn Gâp nsrôyh ndrel khân ay may? Leo kon se nây jât Gâp dja.” ");
INSERT INTO cmo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jêh ri bu leo păng hăn a Brah Yêsu. Tât say Brah Yêsu, brah djơh jan ăn kon se nây chôt nslŏng nslăng ro, rlĭ rlang ta neh n'ho ma lôh mpŭnh dak diu. ");
INSERT INTO cmo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Brah Yêsu ôp i bơ̆ păng: “Dah jŏ ntơm geh nau tât i nây ma păng?” “Ntơm bơh hôm jê̆ ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Brah djơh jan păng chôt ta ŭnh tŭp ta dak nâng ngăn, ŭch nkhât păng. Lah May dơi jan, dăn May kơl hên, yô̆ nđach ma hên ƀă ơ.” ");
INSERT INTO cmo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Brah Yêsu ơh lah ma păng: “Moh nau may lah ‘Lah May dơi jan’, kơt nây? Gâp dơi jan dâng lĕ ntil ndơ ăn ma bu moh i nsing ma Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jêh tăng lah ndri i bơ̆ kon se nây nter hor dak măt lah: “Gâp nsing hơyh! Dăn kơl gâp ăn geh nau nsing ngăn!” ");
INSERT INTO cmo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ta nây Brah Yêsu say phung ƀon lan nchuăt ran a Păng, ndri Păng r'ŏt brah djơh lah: “Hơi brah djơh i jan ăn kon se dja tâk tôr, mlo! Gâp đă may lôh bơh kon se dja hŏm, lơi hôm ôh lăp ta păng jât!” ");
INSERT INTO cmo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Brah djơh nây nter ro, jan ăn kon se nây nslŏng nslăng dŭt hô ngăn, jêh ri lôh ƀhŭch. Jêh nây kon se bêch la-or tâm ban ma bunuyh lĕ khât, ŏk bunuyh lah păng lĕ khât ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yơn ma Brah Yêsu nhŭp ti păng, rdŏk păng, kon se nây dâk đơp. ");
INSERT INTO cmo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jêh ri Brah Yêsu hăn lăp ta du mlŏm jay, mpôl oh mon ôp êng Păng: “Mơm dâng hên mâu dơi mprơh brah djơh ăn lôh hiah?” ");
INSERT INTO cmo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Brah Yêsu lah ma khân păng: “Gay ma dơi mprơh brah djơh kơt nây, mbơh sơm , ndrel ma ăt sông sa mơ pa heh.” ");
INSERT INTO cmo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jêh ri Brah Yêsu, ndrel ma mpôl oh mon Păng lôh bơh ntŭk nây, hăn glăt rŏ bri Galilê mâu ŭch ôh ăn bu gĭt ");
INSERT INTO cmo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Păng ntŭm nti ma mpôl oh mon Păng kơt nđa: “Gâp i Kon Bunuyh tă bơh Kôranh Brah, bu mra njŭn ăn ma bunuyh i nkhât lơi Gâp, yơn ma lôch pe nar bơh kơi jêh bu nkhât, Gâp dâk rêh tay.” ");
INSERT INTO cmo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mpôl oh mon Păng mâu vât ôh nau Păng ngơi, khân păng mâu bănh ôp Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jêh ri Brah Yêsu, ndrel ma mpôl oh mon hăn tât ta ƀon Kapơnŭm ta bri Galilê. Khân păng lăp ta du mlŏm jay, jêh ri Păng ôp ma mpôl oh mon: “Moh nau tâm nchră khân mre nôk hăn rŏ trong nơh?” ");
INSERT INTO cmo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Khân păng iăt săk răk klăk, yorlah nôk hăn rŏ trong nơh, khân păng tâm rlăch ŭch gĭt n'hêl ta mpôl khân păng, bu moh i kuŏng rlau bu. ");
INSERT INTO cmo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jêh ri Brah Yêsu gŭ n'guch, Păng kuăl lĕ 12 nuyh mpôl oh mon nây, Păng lah: “Bu moh i ŭch kuŏng rlau bu, păng i nây njŭr săk păng nơm ăn jê̆ ta nâm bu, n'ho ma jan dâk bu dâng lĕ đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Păng leo du huê kon se jê̆, ăn dâk ta nklang khân păng, Păng ut kon se i nây, lah ma mpôl oh mon: ");
INSERT INTO cmo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Bu moh i rom ma du huê kon se jê̆ kơt dja, yor ma ŭch iăt nau Gâp, păng tâm ban ma rom Gâp đŏng, jêh ri bu moh păng i rom Gâp, mâu ôh dơn rom ma du huê Gâp dơm, rom ma Kôranh Brah i tơm njuăl ăn Gâp jŭr ta dja đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jêh ri Yôhan mbơh ma Brah Yêsu lah: “Hơi Nơm Nti! Hên say du huê bunuyh mprơh brah djơh ma moh rnha May. Jêh ri hên buay păng, yorlah păng mâu geh ôh mpôl bân.” ");
INSERT INTO cmo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Brah Yêsu lah: “Lơi ôh buay păng. Mâu geh ôh bunuyh dơi jan nau dơi ma moh rnha Gâp, jêh ri ƀêng ma ngơi djơh ma Gâp. ");
INSERT INTO cmo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ndri bu moh mâu rdâng đah bân, păng i nây gŭ mpeh ma bân ro. ");
INSERT INTO cmo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jêh ri jât lah bu moh ăn dak du keo ma khân may, yor ma khân may jêng mpôl oh mon Gâp i Brah Krist, Gâp lah n'hêl nanê̆ ngăn ma khân may, păng i nây geh ndơ nkhôm ro.” ");
INSERT INTO cmo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Brah Yêsu lah jât: “Bu moh leo du huê kon se jê̆ i nsing ma Gâp jan nau tih, ndri ueh rlau lah bu sŏ mpăl lŭ kât ta tong ko păng, nklăch păng ta dak văch dak văr ri, ma đah ăn rong păng rêh. ");
INSERT INTO cmo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Lah say ti khân may leo jan nau tih koh mƀăr lơi ti i nây. Ueh rlau ma gŭ rêh jât năp tay rong du ding ti dơm, jêh ri dơn nau rêh n'ho ro, ma đah bar đah ti, jêh ri gŭ ta ntŭk i geh ŭnh hit mâu blao nhhŏt ");
INSERT INTO cmo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","jêng ntŭk i geh nau rêh rnhăl rhai sa săk bunuyh n'ho ro, ntŭk geh ŭnh hit mâu blao nhhŏt đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Lah say jŏng khân may leo jan nau tih, koh mƀăr lơi jŏng i nây. Ueh rlau ma gŭ rêh jât năp tay rong du ding jŏng dơm, jêh ri dơn nau rêh n'ho ro, ma đah bar đah jŏng, jêh ri Kôranh Brah nklăch ta ndrung ŭnh ");
INSERT INTO cmo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","jêng ntŭk i geh nau rêh rnhăl rhai sa săk bunuyh n'ho ro, ntŭk geh ŭnh hit mâu blao nhhŏt đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Lah say trôm măt khân may leo jan nau tih rvek mƀăr lơi trôm măt i nây. Ueh rlau ma rong du ding trôm măt lăp gŭ ta ƀon ueh Kôranh Brah, ma đah bar đah trôm măt, jêh ri Kôranh Brah nklăch ta ndrung ŭnh, ");
INSERT INTO cmo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","jêng ntŭk i geh nau rêh rnhăl rhai sa săk bunuyh n'ho ro, ntŭk geh ŭnh hit mâu blao nhhŏt đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kôranh Brah rlong dâng lĕ bunuyh ma nau jêr jŏt tâm ban ma lăp ta ŭnh hit. Ndơ i nây tâm ban ma nau nhhơr ma Kôranh Brah dâng lĕ geh pot lai ma boh. ");
INSERT INTO cmo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Boh jêng du ntil ndơ tê̆ trao ma kah ngăn, lah boh i nây mâu hôm geh kah, mơm hôm blao jan gay ma ăn plơ̆ kah jât? Ăn khân may gĭt ma nau khlay boh dja, jêh ri gŭ ndrel băl ăn geh nau ueh lăng đăp mpăn.” ");
INSERT INTO cmo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jêh ri Brah Yêsu lôh bơh ƀon nây, hăn jât bri Yuđa mpeh bơh kăl ti dak rlai Yôrđăn, jêng mpeh bơh lôh nar. Phung ƀon lan leo băl ran a Brah Yêsu du tơ̆ jât, jêh ri Păng ntŭm nti tay tâng ma nau vay Păng. ");
INSERT INTO cmo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Geh phung Pharisi aƀă hăn lăp gŭ dăch ŭch ôp rlong Păng, jêh ri khân păng ôp Păng: “Hơi Nơm Nti! Ah tâng ma nau vay phung bân, sai dơi ntlơi ur đŏng bơh?” ");
INSERT INTO cmo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Păng ơh lah: “Ndri mơm Môsê đă khân may ta nau vay păng?” ");
INSERT INTO cmo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Khân păng ơh: “Môsê nchih lah, ăn i sai jan samƀŭt nau tâm ntlơi, jêh ri dơi mprơh i ur păng nơm.” ");
INSERT INTO cmo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jêh ri Brah Yêsu lah ma khân păng: “Ach ma khân may dăng ko hô ir, dâng Môsê nchih nau vay kơt nây. ");
INSERT INTO cmo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bơh ntơm kăl e, Kôranh Brah de njêng dâng lĕ ta neh ntu dja, Păng njêng bunuyh đŏng, geh bu klô geh bu ur. ");
INSERT INTO cmo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Môsê nchih: ‘Ndri dâng geh bu klô lôh du bơh mê̆ bơ̆ hăn gŭ a ur, ");
INSERT INTO cmo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","jêh ri bar hê khân păng jêng ur sai jêng du rnglay săk’. Ndri khân păng mâu hôm ôh jêng bar hê tay, lĕ jêng du rnglay săk dơm. ");
INSERT INTO cmo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Lah ndri bar hê ur sai i Kôranh Brah de rnglăp nây lơi ăn ôh bunuyh tâm nkhah.” ");
INSERT INTO cmo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jêh ri tât sât gŭ ta du mlŏm jay, mpôl oh mon ôp Brah Yêsu ma nau i nây du tơ̆ jât. ");
INSERT INTO cmo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Păng lah ma khân păng: “Bu moh ntlơi ur, jêh ri sŏ tay ur êng jât, bu klô i nây jêng bunuyh lŏm ur. ");
INSERT INTO cmo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Lah bu ur i lĕ ntlơi sai, jêh ri sŏ sai êng jât, bu ur i nây jêng bunuyh lŏm sai.” ");
INSERT INTO cmo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Geh du nar ri bu leo kon se jê̆ jê̆, đă Brah Yêsu pah ăn nau geh jêng ma kon se i nây, tih ma mpôl oh mon lah buay khân păng. ");
INSERT INTO cmo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Brah Yêsu nuih mbu, tât say kơt nây, Păng lah: “Ăn phung kon se văch ta Gâp, lơi ôh buay khân păng, yorlah khân păng mâu ôh n'hao êng săk khân păng nơm, yơn ma nsing ma mê̆ bơ̆ hô ngăn. Bunuyh i Kôranh Brah ŭch mât uănh, khân păng geh kơt ndri đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, bu moh mâu rom nau Kôranh Brah mât uănh tâm ban ma kon se jê̆ rom, bunuyh i nây Kôranh Brah mâu rom đŏng, mâu ăn păng lăp ta nau Kôranh Brah nơm mât uănh đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jêh ri Brah Yêsu pư ut mpôl kon se nây, n'ho ma mbơh sơm tê̆ ti ăn nau geh jêng ma khân păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jêh ri Brah Yêsu ndrăp ma lôh bơh nây hăn rŏ trong, geh du huê bu klô nchuăt ran tât ta nây, chon kômŏk bơh năp Păng, n'ho ma ôp lah: “Hơi Nơm Nti ueh, mơm gâp jan mêh, gay ma geh nau rêh n'ho ro?” ");
INSERT INTO cmo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Brah Yêsu ơh lah: “Mơm dâng may kuăl Gâp ‘ueh’ kơt nây mêh? Mâu geh ôh du huê bunuyh ueh, geh du huê Kôranh Brah dơm ueh. ");
INSERT INTO cmo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","May lĕ gĭt jêh ta nau vay phung bân lah: ‘Lơi nkhât bu, lơi lŏm ur lŏm sai, lơi ntŭng, lơi ngơi nchơt, lơi mƀrôh gay ma sŏ drăp ndơ bu, jêh ri yơk ma mê̆ bơ̆ hŏ’.” ");
INSERT INTO cmo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bu klô i nây ơh ma Păng: “Hơi Nơm Nti! Dâng lĕ nau i nây gâp lĕ ndjôt ntơm bơh jê̆ ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jêh tăng păng ơh kơt ndri, Brah Yêsu uănh jât păng nây, rŏng ma bu klô nây, Brah Yêsu ngơi lah: “Hôm du ntil may mâu hŏ jan, tăch lĕ drăp ndơ may, pă ăn ma mpôl o ach, ri mơ may geh ndơ khlay ta ƀon ueh ta kalơ. Jêh ri hăn tâng Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jêh bu klô nây tăng lah kơt nây, muh măt păng sơh r'ơih, jêh ri plơ̆ sât, nuih n'hâm păng rvê nhhuach hô ngăn, yor ma dŭt ŏk drăp ndơ păng. ");
INSERT INTO cmo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Brah Yêsu uănh jŭm Păng nơm, jêh ri lah ma mpôl oh mon Păng: “Jêr ngăn ma bunuyh ndrŏng ăn Kôranh Brah mât uănh khân păng.” ");
INSERT INTO cmo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mpôl oh mon ndrŏt hih rhŏl hô ngăn ma nau Păng ngơi i nây. Jêh ri Brah Yêsu lah ma khân păng jât: “Hơi oh nô, nau Kôranh Brah mât uănh jêr ngăn lăp! ");
INSERT INTO cmo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ma bunuyh ndrŏng lăp ta nau Kôranh Brah mât uănh, jêr rlau đah ăn seh samô lăp ta trôm nglai.” ");
INSERT INTO cmo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mpôl oh mon ndrŏt hih rhŏl lơ hô jât, jêh ri ôp ndrăng khân păng nơm: “Lah bunuyh ndrŏng lĕ geh jêr jêh ma ăn Kôranh Brah mât uănh khân păng, lah ndri bunuyh a êng hôm dơi ăn Kôranh Brah mât uănh đŏng mâu lah mâu?” ");
INSERT INTO cmo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Brah Yêsu n'gâl uănh jât khân păng lah: “Nau dja bunuyh jan mâu ôh dơi, yơn ma Kôranh Brah hôm dơi jan, yorlah dâng lĕ ndơ Păng jan dơi dadê.” ");
INSERT INTO cmo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pêtrôs lah ma Brah Yêsu: “Lĕ May say jêh hên, hên lĕ ntlơi ndoh ndơ hên nơm lĕ phiao, hăn tâng May.” ");
INSERT INTO cmo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Brah Yêsu ơh lah: “Gâp lah n'hêl nanê̆ ngăn ma khân may, bu moh ntlơi nhih jay, oh nô, oh nur, mê̆ bơ̆, oh kon, mâu lah mir ba, yor ma tâng Gâp, ndrel ma tâng nau mhe mhan ueh, ");
INSERT INTO cmo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ndri dâng Kôranh Brah nkhôm ta nau rêh jêng păng i nây aƀaơ dja ăn ŏk ngăn ngên ma nhih jay, oh nô, oh nur, mê̆ bơ̆, oh kon, ndrel ma mir ba. Păng bu jan nau krit jêr đŏng, yơn ma nar jât năp tay păng dơn nau rêh n'ho ro. ");
INSERT INTO cmo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lŏng ŏk bunuyh i bơh năp plăch bơh kơi, bunuyh i bơh kơi plăch bơh năp chrao. Geh ŏk bunuyh ta neh ntu dja bu gĭt khân păng geh nau khlay ngăn, yơn ma jât năp tay mâu geh ôh nau khlay, tih ma geh ŏk bunuyh êng jât ta neh ntu dja bu gĭt khân păng mâu geh ôh nau khlay, yơn ma ta jât năp tay geh nau khlay chrao.” ");
INSERT INTO cmo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Brah Yêsu, ndrel ma mpôl oh mon Păng hăn hao jât ƀon kuŏng Yêrusalem. Păng hăn bơh năp bu, lŏng mpôl oh mon rvê rôt ôt ngăn, lĕ bu i hăn tâng bơh kơi klach đŏng. Jêh ri Brah Yêsu leo 12 nuyh mpôl kôranh oh mon nây hăn ntŭk êng ƀah ma bu, nkoch ma nau i geh tât ma săk Păng nơm tay: ");
INSERT INTO cmo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Aƀaơ dja bân hao jât ƀon kuŏng Yêrusalem. Gâp dja i Kon Bunuyh tă bơh Kôranh Brah, bu de njŭn ăn ma mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay phung bân. Jêh ri khân păng i nây tê̆ dôih Gâp tât khât, njŭn Gâp ma phung i mâu di phung Israel. ");
INSERT INTO cmo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Lĕ phung i nây gơm n'grơh Gâp, soh dak diu ta Gâp, rpăt Gâp ma mŏng rse, jêh ri nkhât lơi Gâp, yơn ma lôch pe nar bơh kơi nây Gâp dâk rêh tay.” ");
INSERT INTO cmo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jêh ri rŏ trong nây bar hê oh nô khân păng Yakơ, ndrel ma Yôhan i kon Sêƀêđê dăn ma Brah Yêsu: “Hơi Nơm Nti! Dăn May yô̆ ăn tâng nau hên dăn đŏng ơ.” ");
INSERT INTO cmo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Brah Yêsu ôp khân păng: “Moh ndơ ŭch Gâp jan ăn ma khân may mêh?” ");
INSERT INTO cmo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Khân păng ơh lah: “Nôk May jêng kađăch mât uănh bri Kôranh Brah tay, ăn hên gŭ kêng May nơm mât uănh ndrel May, du huê gŭ bơh ma, du huê gŭ bơh chiao ơ.” ");
INSERT INTO cmo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Brah Yêsu ơh nau ntât lah: “Bar hê khân may nây mâu gĭt ôh moh ndơ dăn. Ndri khân may dơi sŏ dơn nhêt ndrănh play yŭng yar ƀon ta kchok i Gâp be dơi đŏng? Khân may dơi dơn đŏng nau ƀăptem i Gâp dơn lah mâu?” ");
INSERT INTO cmo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Khân păng ơh: “Ơ, hên dơi sŏ dơn.” Brah Yêsu lah: “Khân may sŏ dơn nhêt ndrănh play yŭng yar ƀon ta kchok i Gâp nhêt, ndrel ma dơn nau ƀăptem i Gâp dơn tay ngăn đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tih ma i nau gŭ bơh ma bơh chiao ri, Gâp mâu ôh dơi rom, yor ma ntŭk i nây lĕ ndrăp ăn ma bunuyh i Kôranh Brah nơm ŭch ăn dơm.” ");
INSERT INTO cmo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tât ma mpôl oh mon i jât nuyh nây tăng lah kơt nây, khân păng ji nuih đah Yakơ, ndrel ma Yôhan. ");
INSERT INTO cmo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jêh ri Brah Yêsu kuăl lĕ rngôch mpôl oh mon Păng, Păng lah: “Khân may lĕ gĭt jêh bunuyh i jan kađăch ma phung bunuyh i mâu di phung Israel, khân păng i nây dah ŭch jan ma phung ƀon lan khân păng nơm. Geh đŏng mpôl i têh kuŏng tŭn jot phung ƀon lan khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ta mpôl khân may lơi ôh jan kơt nây! Ta mpôl khân may lah geh du huê ŭch jan kuŏng, ăn păng i nây jêng bunuyh sơm kơl jan kar ma khân may. ");
INSERT INTO cmo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Lah geh du huê ŭch jan kuŏng rlau bu, iăt ma păng jan dâk ma dâng lĕ bunuyh êng ƀŏt, ");
INSERT INTO cmo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","yor ma Gâp i Kon Bunuyh tă bơh Kôranh Brah jŭr ta neh ntu dja, mâu ôh Gâp đă bu sơm kơl jan kar ăn ma Gâp. Gâp chrao sơm kơl jan kar ăn ma bu, jêh ri Gâp sơm săk Gâp nơm tât khât săk, gay ma chuai dâng lĕ bunuyh.” ");
INSERT INTO cmo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jêh ri Brah Yêsu, ndrel ma mpôl oh mon hăn tât ta ƀon Yêrikhô. Nôk khân păng lôh bơh ƀon Yêrikhô nây, phung ƀon lan brô̆ ndrel drưm. Geh đŏng du huê bu klô cheh măt, rnha Ƀartimê i kon Timê gŭ kŏp dăn prăk bu ta meng trong ri. ");
INSERT INTO cmo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tât păng tăng bu lah: “Yêsu ƀon Nasaret brô̆ tât ta dja,” păng nter lah: “Hơi Kôranh Yêsu i kon sau kađăch Đavid! Dăn yô̆ nđach ma gâp ƀă ơ!” ");
INSERT INTO cmo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ŏk bunuyh lah păng gŭ rklăk hŏ lơi hôm nter, yơn ma păng nter lơ ma nteh nteh lah: “Hơi kon sau kađăch Đavid! Dăn yô̆ nđach ma gâp ƀă ơ!” ");
INSERT INTO cmo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jêh ri Brah Yêsu nsrŭng plơ̆ lah: “Đă păng hăn a dja.” Jêh ri bu đă bunuyh cheh măt nây lah: “Lơi hôm rvê, dâk hŏm, Păng kuăl may hơi.” ");
INSERT INTO cmo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bunuyh cheh măt i nây mƀăr chrŏp ao kuŏng, dâk đơp hăn ran dưh a Brah Yêsu ri. ");
INSERT INTO cmo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jêh ri Brah Yêsu ôp păng: “Moh ndơ ŭch Gâp jan ăn ma may mêh?” Bunuyh cheh măt i nây ơh lah: “Hơi Nơm Nti! Đă May jan trôm măt gâp ăn say ang ơ.” ");
INSERT INTO cmo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Brah Yêsu lah ma păng: “May hăn sât ăn ueh lăng yơ̆! Nau may nsing ma Gâp lĕ jan bah may jêh!” Dô ma uănh say ang ro, n'ho ma hăn tâng Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jêh ri Brah Yêsu hăn ndrel mpôl oh mon jât ƀon kuŏng Yêrusalem. Khân păng tât kêng ƀon Ƀêtphasê, ndrel ma ƀon Ƀêthani i gŭ ta yôk tơm Ôlive mâu hôm ngai ma ƀon Yêrusalem. Jêh ri Păng đă bar hê oh mon hăn lor, Păng lah: ");
INSERT INTO cmo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ăn khân may hăn ta ƀon bơh năp ri, lăp ta ƀon nây khân may mra say du mlŏm kon seh lia bu kât ta nây, seh lia i nây ê hŏ geh bu ncho ôh, ăn khân may drih têk păng bơh ri a dja. ");
INSERT INTO cmo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Lah geh bu ôp khân may: ‘Moh jan drih khân mre nây mêh?’, khân may ơh lah: ‘Kôranh ŭch ncho păng’. Jêh ri Păng đă têk mplơ̆ ta dja tay gơnh ro.” ");
INSERT INTO cmo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jêh ri khân păng hăn rŏng brŏng tât ta nây say du mlŏm kon seh lia, bu kât bơh dih mpông chuanh meng trong, jêh ri khân păng drih. ");
INSERT INTO cmo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ta nây geh bu ƀaƀă ôp ma khân păng: “Moh jan khân mre nây? Moh jan drih kon seh lia i nây mêh?” ");
INSERT INTO cmo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bar hê khân păng nây ơh ma bu tâng nau i Brah Yêsu de ntĭnh nơh, jêh ri bu ăn khân păng têk. ");
INSERT INTO cmo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Khân păng lôh bơh ƀon nây têk leo ăn ma Brah Yêsu, jêh ri lăk ao kuŏng khân păng nơm kalơ seh lia nây, ăn Brah Yêsu ncho hăn jât ƀon Yêrusalem. ");
INSERT INTO cmo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Geh ŏk bunuyh leo băl sŏ ao kuŏng khân păng nơm lăk rŏ trong bơh năp Brah Yêsu ri, lŏng bu ƀaƀă jât te nthan si bơh mir lăk rŏ trong nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dâng lĕ bunuyh i brô̆ tâng Brah Yêsu bơh năp bơh kơi, leo băl nter drơu lah: “Rnê ma Kôranh Brah! Dăn Kôranh Brah ăn nau geh jêng ma Păng i Kôranh Brah de đă văch! ");
INSERT INTO cmo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dăn Kôranh Brah ăn nau geh jêng ma nau Păng mât uănh i mra mât uănh hên tâm ban ma kađăch Đavid i che hên bơh kăl e nơh! Rnê ma Kôranh Brah! Rnê ma Kôranh Brah i gŭ kalơ trôk dŭt prêh ri!” ");
INSERT INTO cmo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Brah Yêsu lĕ tât ta ƀon kuŏng Yêrusalem, Păng hăn lăp ta jŏng gung nhih jan brah ma Kôranh Brah. Jêh uănh jŭm ăp phiao bri lĕ kêng măng jêh, ndri dâng Păng plơ̆ ta ƀon Ƀêthani ndrel 12 nuyh mpôl kôranh oh mon. ");
INSERT INTO cmo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kah ôi tay khân păng lôh bơh ƀon Ƀêthani nây hăn jât ƀon Yêrusalem, Brah Yêsu ji ngot ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Păng uănh bơh ngai say tơm Rvi du tơm geh n'ha nđâr rngât, Păng hăn uănh dăch nkhêp lah geh play. Tât ta tơm nây say dơm i n'ha, ê hŏ di khay play dŭm ôh. ");
INSERT INTO cmo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jêh ri Brah Yêsu lah ma tơm Rvi i nây: “Ntơm bơh nar dja mâu hôm geh ôh bunuyh sa play may!” Nau pre lah nây, mpôl oh mon Păng tăng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jêh ri Brah Yêsu ndrel mpôl oh mon Păng hăn tât ta ƀon kuŏng Yêrusalem. Păng hăn lăp ta jŏng gung nhih jan brah, phung i tăch rgâl ta nây Păng mprơh lĕ phiao. Păng nklơ̆ gre bu gŭ rgâl prăk, ndrel ma gre bu tăch plŭk. ");
INSERT INTO cmo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Păng mâu ôh ăn bu ndjôt leo ndoh ndơ lăp glăt rŏ jŏng gung nhih jan brah ma Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Brah Yêsu ntŭm nti ma bu lah: “Ta samƀŭt Nau Kôranh Brah Ngơi lĕ nchih lah: ‘Nhih Gâp jêng ntŭk ăn ma dâng lĕ bunuyh ăp bri dak mbơh sơm’ Ƀêng ma khân may sŏ jan ntŭk gŭ rgum mpôl ntŭng chrao.” ");
INSERT INTO cmo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tât mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay phung Israel gĭt nau i nây, khân păng leo băl gay ma joi nau mơm dâng geh nkhât lơi Brah Yêsu. Yơn ma khân păng klach Păng, yor ma phung ƀon lan ndrŏt hih rhŏl hô ngăn ma nau ntŭm nti Păng nây. ");
INSERT INTO cmo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tât kêng măng Brah Yêsu, ndrel ma mpôl oh mon Păng lôh bơh ƀon i nây plơ̆ tay ta ƀon Ƀêthani. ");
INSERT INTO cmo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kah ôi tay hăn rŏ trong, mpôl oh mon say tơm Rvi nơh, ndro ƀrŭng tât a reh su ro. ");
INSERT INTO cmo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jêh ri Pêtrôs kah gĭt nau i Brah Yêsu lah nơh, mbơh ma Păng lah: “Hơi Nơm Nti! Lŏng uănh dja, tơm Rvi i May rtăp nơh lĕ ndro ngăn mê!” ");
INSERT INTO cmo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Brah Yêsu lah ma khân păng: “Khân may nsing ma Kôranh Brah hŏm! ");
INSERT INTO cmo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gâp lah n'hêl nanê̆ ngăn ma khân may, lah geh du huê bunuyh lah ma yôk dja: ‘Hăn du bơh ntŭk dja tŭp a dak văch dak văr ri hŏm!’, lah bunuyh i nây mâu geh nau vĭ vĕ ta nuih n'hâm ma ndơ i nây, n'ho ma nsing ma ndơ i păng lah nây mra geh ngăn, ndri Kôranh Brah ăn nau dơi tâng nau păng lah nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ndri dâng Gâp mbơh ma khân may, moh ndơ i khân may mbơh sơm dăn, ăn khân may nsing geh ngăn, jêh ri Kôranh Brah ăn ma khân may geh ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jêh ri jât, nôk khân may mbơh sơm, lah khân may geh nau ji nuih đah bu, ăn khân may geh nau yô̆, lơi hôm ôh kơp nau tih bu, ndri Kôranh Brah Bơ̆ khân may i gŭ ta kalơ trôk lơ hô yô̆ nđach mâu hôm kơp nau tih khân may đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tih ma lah khân may mâu geh nau yô̆, hôm kơp nau tih bu, Kôranh Brah Bơ̆ khân may i gŭ ta kalơ trôk mâu yô̆, hôm kơp nau tih ma khân may đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Brah Yêsu hăn tât ta ƀon kuŏng Yêrusalem ndrel mpôl oh mon du tơ̆ jât. Nôk Păng brô̆ rsong ta jŏng gung nhih jan brah ma Kôranh Brah, tât brô̆ mpôl kôranh jan brah, phung nơm nti nau vay phung Israel, ndrel ma phung kôranh bri Yuđa mâp ôp Păng: ");
INSERT INTO cmo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Dăn mbơh ăn ma hên gĭt, ndơ May jan dja bơh tă nau dơi? Bu moh ăn nau dơi i nây ma May mêh?” ");
INSERT INTO cmo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Brah Yêsu ơh lah: “Gâp dăn ôp du nau ma khân may ƀŏt. Lŏng khân may ơh ma Gâp đŏng, ndri mơ Gâp mbơh ma khân may tay, bơh tă nau dơi Gâp jan dja. ");
INSERT INTO cmo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Dăn ơh ma Gâp, lah ndri bu moh đă Yôhan-Ƀaptem jan ƀăptem yŭk ma dak? Tă bơh Kôranh Brah, mâu lah tă bơh bunuyh?” ");
INSERT INTO cmo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Khân păng tâm nchră êng lah: “Lah bân lah: ‘Tă bơh Kôranh Brah’, Păng mra lah bân: ‘Lah ndri mơm dâng khân may mâu iăt nau păng?’ ");
INSERT INTO cmo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Lah bân ơh lah: ‘Tă bơh bunuyh’.” Ndri khân păng klach phung ƀon lan ji nuih, yor ma ŏk bunuyh iăt nau Yôhan-Ƀaptem, kơp păng jêng bunuyh ntơyh nau ngơi Kôranh Brah ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jêh ri khân păng ơh ma Brah Yêsu: “Hên mâu gĭt ôh!” Brah Yêsu lah ma khân păng: “Lah ndri Gâp mâu đŏng mbơh ăn ma khân may gĭt, bu moh ăn nau dơi Gâp jan dja.” ");
INSERT INTO cmo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jêh ri Brah Yêsu ngơi nau ntât ma khân păng lah: “Geh du huê bu klô tăm tơm play yŭng yar ƀon du lôk mir. Păng jan n'gar jŭm mir nây, jan du ntŭk ma bu njot play i nây, ndrel ma jan du mlŏm chuanh nkơng đŏng gay ma njrăng. Jêh ri ăn bu mât mir i nây, đă bu pă play ma păng ăp năm, i păng nơm ri hăn gŭ bri êng. ");
INSERT INTO cmo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tât di khay dŭm play yŭng yar ƀon ri, păng đă du huê dâk păng hăn tâm mâp ma mpôl mât mir i nây, gay ma sŏ play i bu pă nây. ");
INSERT INTO cmo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ƀêng ma bu de nhŭp lơh ôbăl, jêh ri mprơh ôbăl ăn sât dơm. ");
INSERT INTO cmo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Păng i nơm tơm mir nây, đă du huê dâk jât hăn đŏng, mpôl i mât mir nây mbang bôk ôbăl nây, n'ho ma rak suai ôbăl jât. ");
INSERT INTO cmo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jêh ri păng đă du huê dâk jât hăn. Mpôl i mât mir i nây nkhât ôbăl nây. Jêh ri dâk păng aƀă êng jât bu de lơh kơt nây đŏng, aƀă bu de mbang, aƀă bu de nkhât lơi. ");
INSERT INTO cmo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Păng i nơm tơm mir nây hôm geh du huê bunuyh êng jât gŭ ndrel păng, jêng du huê kon bu klô i păng nơm rŏng hô ngăn. Kêng ma dŭt păng đă i kon nây hăn bơh kơi bu, păng mân êng lah: ‘Bu klach yơk ma kon gâp ro’. ");
INSERT INTO cmo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tih ma mpôl i mât mir nây tâm lah ndrăng khân păng nơm: ‘Păng i nây ro ntrŏ ndơn mir i dja nar jât năp tay, hăn bân nkhât lơi păng i nây dôh, ndri mơ mir i dja n'ho geh ma bân ro’. ");
INSERT INTO cmo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jêh ri bu de nhŭp i kon păng nơm i tơm mir nây, nkhât lơi ôbăl mƀăr bơh dih mir i nây. ");
INSERT INTO cmo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ndri mơm păng i tơm mir nây jan? Păng hăn nkhât lơi mpôl i mât mir nây ro, jêh ri jao mir tơm play yŭng yar ƀon i nây ăn ma bu êng jât. ");
INSERT INTO cmo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ndri khân may mâu geh rŏ samƀŭt Nau Kôranh Brah Ngơi lĕ geh nchih lah: ‘Bunuyh blao jan jay lŭ blon lĕ mƀăr lơi du mlŏm lŭ blon, Yơn ma lŭ blon i nây jêng lŭ blon dŭt nâp khlay rlau bu chrao ma jan jay. ");
INSERT INTO cmo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kôranh Brah nơm jan nau i nây lĕ nau ngăn, Jan ăn bân ndrŏt nhhih hô ngăn’”. ");
INSERT INTO cmo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tât ma mpôl kôranh jan brah, phung nơm nti nau vay phung Israel, ndrel ma phung kôranh bri Yuđa gĭt lah păng ngơi ntât nau i nây lah ma săk khân păng nơm, jêh ri khân păng ŭch nhŭp Brah Yêsu, tih ma khân păng klach ma phung ƀon lan, ndri khân păng lôh du bơh Păng nây dơm. ");
INSERT INTO cmo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jêh ri khân păng đă phung Pharisi ƀaƀă, ndrel ma mpôl i tâng kôranh mât uănh Hêrôt-Ŏntipas hăn gŭ dăch kêng Brah Yêsu gay ma tăng nau Păng ngơi ndơ tih, ndri dâng khân păng joi nau ma ntôn Păng. ");
INSERT INTO cmo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jêh ri khân păng hăn tât ta nây ôp Păng: “Hơi Nơm Nti! Hên gĭt May bunuyh sŏng ngăn, May mâu ôh klach ma bunuyh, mâu ôh kơih bunuyh, May nti nau Kôranh Brah ăn di. Dăn mbơh ma hên tâng nau vay bân, di đŏng ăn prăk i kôranh kađăch ta ƀon Rôm đă bân ăn nây mâu lah mâu? ");
INSERT INTO cmo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Di ma bân ăn mâu lah mâu?” Yơn ma Brah Yêsu lĕ gĭt nuih n'hâm ndŏp mpôn khân păng, Păng lah: “Moh nau khân may ŭch ôp rlong ma Gâp kơt nây mêh? Lŏng sŏ prăk i ăn ma kađăch i nây du mlŏm ăn Gâp uănh.” ");
INSERT INTO cmo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jêh ri bu sŏ prăk du kăk ndơ̆ ăn Brah Yêsu. Păng ôp ma khân păng: “Ndri ta kalơ prăk kăk dja bu moh rup, bu moh rnha?” Khân păng ơh lah: “Rup, ndrel ma rnha kôranh kađăch ta ƀon Rôm!” ");
INSERT INTO cmo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Brah Yêsu lah ma khân păng: “Lah ndri ndơ kôranh kađăch ta ƀon Rôm mplơ̆ ăn ma păng, ndơ Kôranh Brah mplơ̆ ăn ma Kôranh Brah nơm.” Khân păng ndrŏt hih rhŏl hô ngăn ma nau Brah Yêsu ơh. ");
INSERT INTO cmo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jêh ri geh phung Sađôsi hăn mâp Păng, phung i nây jan kôranh ta bri Yuđa đŏng, tih ma khân păng mâu iăt ôh bunuyh lĕ khât hôm dâk rêh jât. Khân păng geh du nau ôp ma Brah Yêsu: ");
INSERT INTO cmo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Hơi Nơm Nti, Môsê kăl e nơh lĕ nchih jêh ta samƀŭt ăn ma bân phung Israel lah kơt nđa: ‘Lah bu klô sŏ ur, jêh ri păng khât, lah păng mâu geh kon, đă i oh oh păng ri ntrŏ sŏ ur păng gay ma geh kon ma păng’. ");
INSERT INTO cmo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ntât lah geh pơh nuyh oh nô bu klô. I nô bôk dak nây sŏ ur, jêh ri khât mâu bă kon ôh. ");
INSERT INTO cmo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jêh ri i oh groi bơh kơi păng nây ntrŏ sŏ i mi nây, jêh ri khât mâu bă kon đŏng. I oh tŏl pe bơh kơi sŏ i mi nây khât kơt ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Dâng lĕ pơh nuyh oh nô khân păng nây mâu bă kon dadê. Dŭt ma dêl bu ur i nây khât đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tât nar bunuyh dâk rêh tay, ndri bu moh ôp păng ‘Ur’? Yorlah lĕ pơh nuyh khân păng nơh lĕ tă sŏ păng dadê.” ");
INSERT INTO cmo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Brah Yêsu ơh ma khân păng: “Khân may mâu vât ôh Nau Kôranh Brah Ngơi, nđâp ma mâu vât đŏng nau dơi Kôranh Brah, ndri dâng nau mân khân may mâu di ôh. ");
INSERT INTO cmo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nôk bunuyh khât, jêh ri dâk rêh tay, khân păng mâu hôm ôh sŏ ur sŏ sai jât. Khân păng jêng tâm ban ma tông păr Kôranh Brah gŭ ta ƀon ueh kalơ.” ");
INSERT INTO cmo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Lŏng ma nau bunuyh khât dâk rêh tay, Môsê lĕ nchih lah ta plăng trong pŭm lok i geh hit ŭnh, ndri khân may vay rŏ đŏng lah mâu? Ta nây Kôranh Brah lah ma păng: ‘Gâp jêng Brah Abrahăm yơk mbah, jêng Brah Isăk yơk mbah, jêng Brah Yakôp yơk mbah’. ");
INSERT INTO cmo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nôk Kôranh Brah ngơi nau i nây, khân păng pe nuyh i nây lĕ khât ŏk năm jêh. Yơn ma bơh Nau Kôranh Brah Ngơi i nây gĭt năl khân păng hôm rêh ma Kôranh Brah. Kôranh Brah mâu ôh di Brah ma bunuyh khât, Păng Brah ma bunuyh rêh. Tih ngăn nau khân may mân nây!” ");
INSERT INTO cmo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jêh ri tât brô̆ du huê nơm nti nau vay phung Israel, tăng khân păng tâm rlăch đah Brah Yêsu, jêh ri tăng nau Brah Yêsu ơh nây di ngăn, păng hăn dăch ôp Brah Yêsu: “Dâng lĕ nau vay bân, moh nau vay i khlay rlau bu mêh?” ");
INSERT INTO cmo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Brah Yêsu ơh: “‘Hơi phung Israel iăt hŏm! Geh Kôranh Brah i Brah bân du huê dơm i Kôranh Brah ngăn ngên. ");
INSERT INTO cmo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ăn rŏng ma Kôranh Brah i Brah khân ay may nơm, ma lĕ nuih n'hâm, ma lĕ huêng, ma lĕ n'hâm suan, ndrel ma lĕ nau mân’, dja nau vay ntil nguai. ");
INSERT INTO cmo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nau vay ntil bar ‘Ăn rŏng ma bu chiao meng kơt rŏng ma săk khân ay may nơm đŏng’. Mâu geh ôh nau vay i khlay rlau ma bar ơ̆ nau vay dja.” ");
INSERT INTO cmo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nơm nti nau vay nây lah ma păng: “Ơ Nơm Nti, di ngăn nau May lah nây mêh. Geh du huê Kôranh Brah dơm, mâu hôm geh ôh brah êng jât. ");
INSERT INTO cmo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bân rŏng ma Păng ăn lĕ nuih n'hâm, ăn lĕ ma nau mân gĭt blao, ndrel ma ăn lĕ brăt suan, jêh ri rŏng ma bu chiao meng kơt rŏng ma săk bân nơm đŏng, nau i nây khlay rlau ngăn ma lĕ rngôch ndơ bu nhhơr, nđâp ma lĕ mpômpa (siŭm) gŭch ma jan brah i nây.” ");
INSERT INTO cmo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tât Brah Yêsu tăng păng ơh gĭt blao kơt nây, Brah Yêsu lah: “May mâu geh gŭ ngai đah nau Kôranh Brah mât uănh may.” Bơh kơi nây mâu hôm geh ôh du huê bunuyh bănh ôp Brah Yêsu nau êng jât. ");
INSERT INTO cmo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Brah Yêsu hôm ntŭm nti bu ta jŏng gung nhih jan brah, Păng lah: “Mơm dâng phung nơm nti nau vay phung bân kuăl Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl ri lah kon sau kađăch Đavid dơm? ");
INSERT INTO cmo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lŏng kađăch Đavid, Brah Huêng Ueh i kloh ueh ăn păng nkoch: ‘Kôranh Brah lah ma kôranh gâp: ‘Gŭ mpeh bơh ma Gâp hŏm Kŏp tât Gâp ăn phung rlăng đah May jêng ntŭk rkơl jŏng May ƀŏt’’. ");
INSERT INTO cmo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Lah lĕ kađăch Đavid nơm kuăl Brah Krist lah kôranh păng nơm kơt nây, yơn ma kon sau mâu geh kuŏng rlau ma u che, lah ndri Brah Krist mơm hôm blao kon sau Đavid jât?” Ŏk phung ƀon lan gŭ ta nây, khân păng geh nuih n'hâm răm hô ngăn tăng nau Brah Yêsu nti. ");
INSERT INTO cmo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Brah Yêsu ntŭm nti ma khân păng: “Ăn khân ay may njrăng đah phung nơm nti nau vay phung bân nây, yorlah khân păng ŭch nsoh ao jong i ueh, jêh ri brô̆ rsong, gay ma ăn bu gĭt lah khân păng geh nau khlay ngăn, ŭch ăn bu mbah kŭnh bôk ma khân păng rŏ ntŭk bu tăch rgâl drăp ndơ, mâu lah rŏ trong kuŏng. ");
INSERT INTO cmo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Khân păng ŭch gŭ bơh năp bu ta ntŭk bu lư ta nhih rƀŭn phung bân, jêh ri lah nhêt kuŏng sông kuŏng nây ŭch gŭ ta ntŭk bu yơk đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tih ma khân păng mƀrôh bu ur ndrô lĕ khât sai, gay ma sŏ pit drăp ndơ nhih jay khân păng. Jêh ri khân păng jan mbơh sơm dŭt jŏ ngăn ăn bu êng tăng, gay ma nhhơ khân păng nơm jêng bunuyh rŏng ma Kôranh Brah ngăn. Phung i nây Kôranh Brah tê̆ dôih dŭt jru ro ta nar jât năp tay.” ");
INSERT INTO cmo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jêh ri Brah Yêsu hăn gŭ bơh năp hŭp tê̆ nhhơr ma Kôranh Brah ta jŏng gung nhih jan brah, Păng uănh phung ƀon lan sŏ prăk tê̆ ta trôm hŭp nây. Păng say ŏk bunuyh ndrŏng tê̆ prăk ŏk ŏk ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jêh ri say du huê bu ur ndrô khât sai o ach. Tât ta nây bu ndrô i nây sŏ prăk bar mlŏm kăk jê̆ dơm i mâu lăng geh khlay ôh tê̆ ta trôm hŭp nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Brah Yêsu kuăl mpôl oh mon Păng, jêh ri lah ma khân păng: “Gâp lah n'hêl nanê̆ ngăn ma khân may, Kôranh Brah kơp bu ur ndrô o ach dja tê̆ prăk ŏk rlau dâng lĕ bu i tê̆ prăk ta hŭp dja, ");
INSERT INTO cmo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","yorlah dâng lĕ mpôl i nây, prăk i khân păng tê̆ ta trôm hŭp nơh, sŏ prăk rmeh bơh săk khân păng nơm. Lŏng i bu ur ndrô de nây, păng bunuyh o ach hô ngăn, bol lah prăk i nây gay ma siăm nau rêh păng nơm kađôi lĕ, păng hôm sŏ lĕ phiao tê̆ nhhơr ma Kôranh Brah đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nôk Brah Yêsu lôh bơh jŏng gung nhih jan brah ma Kôranh Brah, geh du huê oh mon mbơh ma Păng: “Hơi Nơm Nti, lŏng May uănh nhih jan brah to dŭt ueh dŭt kuŏng ngăn, i lŭ blon păng to kuŏng đŏng!” ");
INSERT INTO cmo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Brah Yêsu lah ma oh mon Păng nây: “Nar jât năp tay, lĕ jay kuŏng kuŏng i may say nây bu mra lơh rlŏm lĕ phiao ro, mâu hôm ôh geh du mlŏm lŭ blon tâm rdăp jât.” ");
INSERT INTO cmo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jêh ri Brah Yêsu gŭ ta yôk tơm Ôlive tâm sŏng ma nhih jan brah. Pêtrôs, Yakơ, Yôhan, ndrel ma Ŏndrê, gŭ ngai đah bu ôp êng Păng: ");
INSERT INTO cmo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Hơi Nơm Nti, lŏng May mbơh ăn ma hên gĭt đŏng, dah hôm jŏ nar tât nau i nây mêh? Lah ndri moh ndơ mbên ăn ma hên gĭt lah nau i nây lĕ bơi tât ngăn?” ");
INSERT INTO cmo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Brah Yêsu ơh ma khân păng: “Ăn khân may njrăng ngăn hŏ, lơi dâng ăn bu mƀrôh rlăm khân may ăn nhhơt lă lêng. ");
INSERT INTO cmo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yor ma nar jât năp tay geh ŏk bu ntup rnha Gâp lah: ‘Gâp dja Brah Krist heh!’, khân păng leo nhhơt bunuyh ŏk ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tât khân may tăng nau mhe ma nau tâm lơh tâm sreh, ndrel ma tăng bu nkoch nchroh ma nau tâm lơh tâm sreh, lơi ôh klach, yorlah lĕ nau i nây păng geh ngăn ro, yơn ma nar n'glĕ dŭt neh ntu ê hŏ tât ôh. ");
INSERT INTO cmo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Du mpôl tâm lơh đah du mpôl êng jât, du bri dak tâm lơh đah du bri dak êng jât, ntŭk ƀaƀă geh nau n'găr neh, ndrel ma geh nau ji sŏt ji ngot kuŏng ta ntŭk êng êng. Yơn ma nau jêr i nây jêng ntơm nau jêr dơm, tâm ban ma nau bu ur ntơm tât ji ndŭl gŭ oh. ");
INSERT INTO cmo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ndri khân may njrăng săk hŏm, yor ma bu njŭn khân may ta ntŭk tê̆ dôih, bu sŏ mŏng rpăt khân may ta trôm nhih rƀŭn phung bân, ndrel ma bu leo khân may bơh năp kôranh kuŏng, bơh năp kađăch đŏng, yor ma khân may tâng Gâp. Jêh ri khân may dơi nkoch nau nsing ma Gâp ăn bu gĭt bu tăng. ");
INSERT INTO cmo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ê lor ma nar n'glĕ dŭt geh bunuyh mbơh nau mhe mhan ueh ăn ma ƀon lan ăp n'gor bri tăng lor ƀŏt. ");
INSERT INTO cmo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tât bu nhŭp khân may njŭn ta ntŭk phat dôih, nôk nây lơi ôh rvê lor ma nau i khân may ngơi nây, ăn khân may ngơi tâng nau Brah Huêng Ueh ăn ma khân may, yor ma nau ngơi i nây mâu ôh lôh tă bơh săk khân may nơm, tă bơh Brah Huêng Ueh i kloh ueh ri. ");
INSERT INTO cmo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Oh ma nô, bơ̆ ma kon mra tâm rlăm nhŭp njŭn ăn bu nkhât, ndrel ma i kon kon leo băl tâm rdâng đah i mê̆ bơ̆, n'ho ma njŭn ăn bu nkhât lơi đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yor ma khân may nsing ma Gâp, ndri ŏk bu mra biănh ma khân may. Yơn ma bu moh i dơi ăt, n'ho ma tât lôch, Kôranh Brah mra rklaih păng i nây.” ");
INSERT INTO cmo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tât khân may say ndơ dŭt ƀơ̆ ƀơch bu tê̆ ta ntŭk kloh ueh i ntŭk bu mâu ăn tê̆ - bu moh i rŏ nau i nây ăn păng gĭt vât nau i nây - jêh say ndơ i nây bunuyh i gŭ ta bri Yuđa ri ăn du nchuăt nde ta yôk. ");
INSERT INTO cmo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bu moh i gŭ kalơ chor jay lŏng, lơi hôm ôh jŭr lăp ta trôm sŏ drăp ndơ. ");
INSERT INTO cmo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bu moh i gŭ ta mir, lơi hôm plơ̆ ta jay sŏ ao kuŏng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nôk nây bu ur ntreo, bu ur mpu toh kon geh nau rêh rnhăl hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mbơh sơm dăn ma Kôranh Brah hŏm, lơi ôh ăn geh nau tât dja ta khay ji kăt. ");
INSERT INTO cmo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ta nôk nây geh nau jêr jŏt hô ngăn. Ntơm bơh rnôk Kôranh Brah njêng dâng lĕ ntil ndơ tât aƀaơ dja, n'ho ma nar jât năp tay, mâu prot đŏng geh nau dŭt jêr kơt nây. ");
INSERT INTO cmo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lah Kôranh Brah mâu n'hŭch lơi dâng lĕ nar nây, ndri mâu hôm geh ôh du huê bunuyh rêh, khât lĕ phiao, yơn ma Kôranh Brah n'hŭch lơi nar i nây, yor ma Păng yô̆ mpôl i lĕ Păng kơih. ");
INSERT INTO cmo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ta nôk nây lah geh bu mbơh ma khân may: ‘Lŏng may uănh Brah Krist gŭ ta dja’, mâu lah ‘Gŭ ta to’, lơi ôh iăt bu. ");
INSERT INTO cmo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yor ma geh bunuyh ntup lah săk păng Brah Krist, ndrel ma geh bunuyh ntup lah săk păng bunuyh ntơyh nau ngơi Kôranh Brah. Khân păng i nây jan nau mbên i khlay êng êng đŏng, gay ma leo bunuyh ăn nhhơt lă lêng, nkhêp lah dơi leo nhhơt phung i Kôranh Brah lĕ kơih đŏng, yơn ma mâu dơi ôh. ");
INSERT INTO cmo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ăn njrăng ngăn hŏ! Gâp lĕ nkoch lor ăn ma khân may nau i nây.” ");
INSERT INTO cmo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Lôch jêh nar jêr jŏt i nây Ta nôk nây nar jêng ngo, Khay mâu hôm ôh ang, ");
INSERT INTO cmo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mănh mbing đuh bơh trôk, Lĕ ndơ i têh kuŏng kalơ trôk geh n'gơ dadê. ");
INSERT INTO cmo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nôk nây dâng lĕ bunuyh say Gâp i Kon Bunuyh tă bơh Kôranh Brah, hăn rŏ ndŏr tŭk nđâp ma geh nau dơi, ndrel ma nau chrêk lơp dŭt hô. ");
INSERT INTO cmo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jêh ri Gâp njuăl phung tông păr Gâp hăn ăp puăn njônh bri lam neh ntu, ntơm mpeh bơh lôh nar tât mpeh bơh nhŏp nar, gay ma rgum lĕ mpôl i Kôranh Brah nơm lĕ kơih nơh. ");
INSERT INTO cmo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ăn khân may nklŏn rvê dô, nau ntât ma tơm Rvi. Lah n'ging păng geh chăt n'ha nse nđâr, khân may gĭt lah khay ta mih bơi tât hơyh. ");
INSERT INTO cmo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ndri lah khân may say nau i nây lĕ tât, gĭt ro Gâp i Kon Bunuyh tă bơh Kôranh Brah bơi tât đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gâp lah n'hêl nanê̆ ngăn ma khân may, lĕ nau dja păng tât dôl bunuyh ta rnôk aƀaơ ri hôm rêh. ");
INSERT INTO cmo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Trôk neh ntu mra roh lêk ro, yơn ma nau Gâp ngơi mâu ôh blao roh lêk, hôm geh dâng lĕ ngăn.” ");
INSERT INTO cmo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Mong nar i nây mâu geh ôh du huê bunuyh dơi gĭt, bol lah tông păr i gŭ ta kalơ trôk i ntŭk Kôranh Brah, mâu lah Gâp i Kon Kôranh Brah mâu dơi gĭt đŏng, geh du huê Bơ̆ Gâp dơm dơi gĭt. ");
INSERT INTO cmo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Khân may mâu ôh dơi gĭt mong nar tât lor, ndri ăn njrăng săk jăn ngăn, ");
INSERT INTO cmo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","yor ma nôk mong nar i nây tât tâm ban ma du huê bu klô i lôh bơh jay hăn ntŭk êng. Păng đă mpôl dâk mât uănh jay, n'ho ma pă nau jan kar ăn ma du huê du huê, jêh ri păng đă bunuyh i chăm jay nây njrăng ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Lah ndri ăn khân may gŭ rngeh njrăng ngăn kơt nây đŏng, yorlah khân may mâu gĭt ôh mong nar i nây, tâm ban ma dâk i nây mâu gĭt ôh mong nar tơm jay nây plơ̆ sât, gĭt măng gĭt n'gul măng gĭt ndrau iăr, mâu lah ơm ôi. ");
INSERT INTO cmo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Klach lah tât păng plơ̆ sât mâu geh mbơh lor, jêh ri say khân may hăk bêch. ");
INSERT INTO cmo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nau i Gâp mbơh ma khân may dja, Gâp ŭch mbơh ma dâng lĕ bunuyh đŏng: Ăn gŭ rngeh njrăng săk!” ");
INSERT INTO cmo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jêh ri ƀŭn n'hot, ndrel ma ƀŭn nŭmpăng mâu geh ndrui hôm bar nar ma tât. Mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay phung Israel joi nau mơm dâng geh nhŭp ntŭng Brah Yêsu nkhât lơi. ");
INSERT INTO cmo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Khân păng tâm nchră băl lah: “Lơi ôh bân nhŭp ta nôk jan ƀŭn, klach geh nau uh ah tah tŏr ma phung ƀon lan.” ");
INSERT INTO cmo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jêh ri Brah Yêsu hăn ta ƀon Ƀêthani. Păng gŭ ta jay du huê bu klô rnha Simôn i tă geh phŭng sa. Nôk nây tâng ma nau vay phung ndrŏng khân păng sông sa gŭ bêch nkêng jât chiao, i jŏng rok jât kơi. Nôk Păng sông sa ndrel tât brô̆ du huê bu ur lăp ta jay nây ndjôt du mlŏm đop lŭ. Ta trôm đop nây geh ngi ƀô kah i khlay ngăn, i bu kuăl lah dak ngi ‘Nartu’. Jêh ri păng gĭch lơi bôk đop lŭ i nây tŏ ngi ƀô kah ta bôk Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Geh bu ƀaƀă i gŭ ta nây ji nuih, khân păng tâm lah ndrăng khân păng nơm: “Moh jan mpŭng mpăng ngi ƀô kah kơt nây! ");
INSERT INTO cmo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Lah sŏ pring i nây tăch geh prăk 300 prăk kăk rlau ro yă, jêh ri pă ma bunuyh o ach.” Jêh ri khân păng nduih ôbăl nây. ");
INSERT INTO cmo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lŏng Brah Yêsu de lah: “Ăn dah ma jan pre hŏ! Mơm dâng khân may jan ăn păng geh nau rngot kơt nây? Păng lĕ jan nau ueh ăn ma Gâp. ");
INSERT INTO cmo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Phung o ach hôm gŭ ndrel khân may mro. Khân may jan ueh ma phung i nây tâng nuih n'hâm khân may nơm ŭch, yơn ma Gâp dja mâu ôh gŭ ndrel khân may mro. ");
INSERT INTO cmo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yôh dja jan tâng nau dơi păng. Păng tŏ ngi ƀô kah ta săk jăn Gâp ê lor ma Gâp khât, jêng tâng nau vay phung bân jan ma ndrăp ê lor ma bu tŏp bunuyh khât ta môch. ");
INSERT INTO cmo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gâp lah n'hêl nanê̆ ngăn ma khân may, ăp ntŭk bu hăn mbơh nkoch nau mhe mhan ueh lam n'gor bri ta neh ntu dja, bu nkoch ma nau i păng jan nơh đŏng, gay ma nkah tôr bu bah chuêl păng.” ");
INSERT INTO cmo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jêh ri Yuđas-Isakariyôt du huê kôranh oh mon ta mpôl 12 nuyh, păng hăn mâp đah mpôl kôranh jan brah, gay ma tâm nchră băl leo bu nhŭp Brah Yêsu njŭn ăn ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jêh phung i nây tăng nau Yuđas-Isakariyôt ngơi nây, nuih n'hâm khân păng răm ngăn, khân păng ton nkhôm prăk ma păng. Ndri Yuđas-Isakariyôt ntơm joi moh nôk i ueh gay ma leo bu hăn nhŭp Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ta nar ntơm ndrăp nhêt ƀŭn nŭmpăng mâu geh ndrui, jêng nar bu nkhât kon be biăp ma jan brah gay ma nhêt ƀŭn n'hot, jêh ri mpôl oh mon ôp Brah Yêsu: “Hơi Kôranh, ah ntŭk May ŭch ăn hên ndrăp ma May nhêt sông ƀŭn n'hot dja mêh?” ");
INSERT INTO cmo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Brah Yêsu đă bar hê oh mon hăn joi ntŭk mbơh ma khân păng: “Khân may hăn ta ƀon kuŏng ri, khân may mâp du huê bu klô tê̆ dak yăng kalơ mlik. Ăn khân may hăn tâng păng. ");
INSERT INTO cmo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Moh jay păng lăp, ăn khân may ngơi ma nơm tơm jay nây: ‘Nơm Nti hên đă hên hăn ôp may, jrô ma Păng nhêt ƀŭn ndrel oh mon Păng ta nar nhêt ƀŭn n'hot dja, ah ntŭk mêh?’ ");
INSERT INTO cmo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bunuyh tơm jay nây leo ma khân may ro ta ntŭk kalơ ri jrô huy ngăn, lĕ ơm jêh ndrăp ăp lĕ phiao. Ăn khân may ndrăp nau nhêt sông ăn ma bân ta jrô nây ro.” ");
INSERT INTO cmo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jêh ri oh mon bar hê nây brô̆ drơn ro, tât ta ƀon kuŏng nây khân păng say kơt nau Brah Yêsu lah nơh, jêh ri khân păng ndrăp ndơ sông sa ma nau nhêt ƀŭn n'hot i nây. ");
INSERT INTO cmo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tât kêng măng Brah Yêsu truyh ta ntŭk nây ndrel 12 nuyh mpôl kôranh oh mon Păng. ");
INSERT INTO cmo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nôk Brah Yêsu gŭ sông sa ndrel mpôl oh mon, Păng mbơh: “Gâp lah n'hêl nanê̆ ngăn ma khân may, ta mpôl khân may geh du huê leo bu hăn nhŭp Gâp, păng i nây gŭ sông sa ndrel bân đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mpôl oh mon rvê hô ngăn, lĕ khân păng nây ôp Brah Yêsu: “Ndri gĭt Gâp hơ?” ");
INSERT INTO cmo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Brah Yêsu lah ma khân păng: “Păng i nây tă bơh 12 nuyh mpôl khân may, păng i lŭp nŭmpăng ta ngan ndrel Gâp aƀaơ dja. ");
INSERT INTO cmo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gâp i Kon Bunuyh tă bơh Kôranh Brah bu mra nkhât, tâng ma nau lĕ nchih lah ma Gâp. Tih ma păng i leo bu hăn nhŭp Gâp i Kon Bunuyh tă bơh Kôranh Brah nây, păng i nây geh nau rêh rnhăl ngăn ro. Ueh rlau lơi dâng deh păng i nây nơh.” ");
INSERT INTO cmo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Khân păng hôm gŭ sông sa, jêh ri Brah Yêsu sŏ du mlŏm nŭmpăng, lah ueh ma Kôranh Brah, jêh ri gĭch ăn ma khân păng sa, n'ho ma lah: “Khân may sŏ sa yơ̆, dja i săk jăn Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jêh ri păng sŏ kchok ndrănh play yŭng yar ƀon, lah ueh ma Kôranh Brah, jêh ri ăn ma khân păng nhêt lĕ ma băl. ");
INSERT INTO cmo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Păng lah ma khân păng: “Ndrănh play yŭng yar ƀon ta kchok dja i mham Gâp, i hoch bơh săk jăn Gâp nôk Gâp khât tay, gay ma rklaih ŏk bunuyh. Ma mham i dja Kôranh Brah jan nau tâm rnglăp mhe. ");
INSERT INTO cmo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gâp lah n'hêl nanê̆ ngăn ma khân may, Gâp mâu hôm ôh nhêt ndrănh play yŭng yar ƀon dja jât, n'ho ma tât nar Gâp nhêt tay ndrănh play yŭng yar ƀon tât Kôranh Brah mât uănh dâng lĕ bunuyh ngăn mơ.” ");
INSERT INTO cmo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jêh mprơ nau tâm rnê, Brah Yêsu, ndrel mpôl oh mon Păng lôh bơh nây hăn jât yôk tơm Ôlive. ");
INSERT INTO cmo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Brah Yêsu lah ma mpôl oh mon Păng: “Dâng lĕ khân may ntlơi Gâp, yor ma ta Nau Kôranh Brah Ngơi lĕ geh nchih: ‘Kôranh Brah lah: ‘Gâp mbang nkhât lơi nơm chiăp be biăp, Jêh ri phung be biăp du chah chrai lĕ’’. ");
INSERT INTO cmo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yơn ma jêh Gâp dâk rêh tay, Gâp hăn ta bri Galilê lor bơh năp khân may.” ");
INSERT INTO cmo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jêh tăng Brah Yêsu ngơi ndri Pêtrôs lah ma Păng: “Bol lah dâng lĕ khân păng ntlơi May kađôi, gâp mâu ôh ntlơi May.” ");
INSERT INTO cmo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Brah Yêsu lah ma păng: “Gâp lah n'hêl nanê̆ ngăn ma may, ta măng dja ro, ê lor ma iăr ndrau bar tơ̆, may rlăch pe tơ̆ lah mâu gĭt năl Gâp.” ");
INSERT INTO cmo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pêtrôs rlăch lơ ma hô: “Mâu ôh! Bol lah bu nkhât gâp ndrel May kađôi, gâp mâu geh ôh rlăch lah mâu gĭt năl May.” Dâng lĕ mpôl oh mon geh ngơi kơt nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jêh ri Brah Yêsu, ndrel ma mpôl oh mon Păng hăn jât ntŭk bu rnha Gêtsêmanê. Păng lah: “Khân may gŭ ta dja ƀŏt yơ̆, Gâp hăn mbơh sơm ƀŏt.” ");
INSERT INTO cmo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Păng jă Pêtrôs, Yakơ, ndrel ma Yôhan hăn ndrel. Nôk nây Păng ntơm geh nau rvê hô ngăn, nuih n'hâm mâu đăp mpăn, rngot hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Păng lah ma pe nuyh khân păng nây: “Nuih n'hâm Gâp rngot hô ngăn ndă ma khât ro. Khân may hôm gŭ ta dja ƀŏt, gŭ rngeh njrăng ngăn hŏ.” ");
INSERT INTO cmo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jêh ri Brah Yêsu hăn jât năp đê̆, păn truyh a neh mbơh sơm dăn lơi ta geh ôh nau jêr jŏt, lah dơi. ");
INSERT INTO cmo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Păng lah: “Aƀa ơ Bơ̆! Dah May nơm ŭch May dơi jan dâng lĕ ntil nau, dăn May sŏ nau jêr jŏt dja ăn du ngai bơh Gâp. Yơn ma lơi ôh tâng nuih n'hâm Gâp ŭch, ăn tâng nau May nơm ŭch hŏ.” ");
INSERT INTO cmo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jêh ri Păng plơ̆ jât mpôl oh mon nây, say khân păng hăk bêch, Păng lah ma Pêtrôs: “Hơi Simôn moh bêch may nây hiah? Moh may mâu dơi nsrôyh, man ma du mong mâu dơi đŏng? ");
INSERT INTO cmo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Khân may njrăng hŏm n'ho ma mbơh sơm, gay ma mâu jan tih nôk geh nau ndơm. Nuih n'hâm bunuyh lĕ ŭch jan di ngăn, tih ma mâu ôh blao jan, yor ma hôm rdja.” ");
INSERT INTO cmo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jêh ri Brah Yêsu du tay bơh khân păng, mbơh sơm kơt nau ơm nơh du tơ̆ đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jêh ri Păng plơ̆ sât hăn mâp ma mpôl oh mon jât, say khân păng hôm hăk bêch, lin măt mâu dơi, jêh ri joi nau ơh ma Păng mâu geh. ");
INSERT INTO cmo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Brah Yêsu hăn plơ̆ mâp tay khân păng lĕ pe tơ̆ jêh, Păng lah khân păng: “Khân may hôm bêch dah jŏ ma kah? Dah nây găp hơyh! Aƀaơ dja mong lĕ tât jêh, bu njŭn Gâp i Kon Bunuyh tă bơh Kôranh Brah ăn ma phung bunuyh tih. ");
INSERT INTO cmo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dâk hŏm leo băl hăn, păng i leo bu hăn nhŭp Gâp lĕ bơi tât hơi!” ");
INSERT INTO cmo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Brah Yêsu hôm e ngơi, dô ma tât Yuđas-Isakariyôt jêng du huê bunuyh ta 12 nuyh mpôl kôranh oh mon nây. Geh du phung hăn ndrel păng nây, ndjôt mŏng ndjôt đao. Khân păng i nây tă bơh mpôl kôranh jan brah, phung nơm nti nau vay phung Israel, ndrel ma phung kôranh bri Yuđa de đă. ");
INSERT INTO cmo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuđas-Isakariyôt i leo bu hăn nhŭp Brah Yêsu nây lĕ jêh mbơh du ndơ gĭt năl ma bu lah: “Bu moh i gâp chŭm, Păng i ri ro. Ndri khân may nhŭp leo Păng dô.” ");
INSERT INTO cmo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jêh ri Yuđas-Isakariyôt hăn tât ta Brah Yêsu ro, păng lah: “Hơi Nơm Nti!” Păng chŭm Brah Yêsu, ");
INSERT INTO cmo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","jêh ri bu nhŭp Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Geh du huê oh mon i gŭ dăch ta ri tăk đao chrip, sreh tôr i dâk kôranh jan brah dŭt kuŏng tăch du ding. ");
INSERT INTO cmo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jêh ri Brah Yêsu lah ma phung i nây: “Moh brô̆ khân may ndjôt nđâp ma mŏng ma đao gay ma nhŭp Gâp kơt nây, kơp Gâp jêng bunuyh ntŭng bơh? ");
INSERT INTO cmo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ăp nar kăl dơ̆ nơh, Gâp gŭ ntŭm nti ta jŏng gung nhih jan brah. Khân may gŭ ta nây đŏng, mâu ôh nhŭp Gâp. Iăt ma geh nau tât dja jêng di đah Nau Kôranh Brah Ngơi i bu lĕ nchih.” ");
INSERT INTO cmo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jêh ri mpôl oh mon nchuăt rngŏt lĕ phiao, ntlơi Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Geh du huê bu ndăm i tâng Păng, bu ndăm i nây geh bok du blah dơm ma n'gut săk jăn, bu de nhŭp ôbăl đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Păng mƀăr bok i nây, nchuăt săk kuh dơm. ");
INSERT INTO cmo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jêh ri bu leo Brah Yêsu a jay kôranh jan brah dŭt kuŏng. Lĕ mpôl kôranh jan brah, phung nơm nti nau vay phung Israel, ndrel ma phung kôranh bri Yuđa gŭ rgum ta ri dadê. ");
INSERT INTO cmo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Lŏng Pêtrôs ri tâng Brah Yêsu bơh kơi, brô̆ ndŏp bôk mpơl bôk, n'ho ma tât ta trôm jŏng gung jay kôranh jan brah dŭt kuŏng, jêh ri lăp gŭ njŏr ŭnh ndrel mpôl bunuyh kơl jan kar ta ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mpôl kôranh jan brah, ndrel ma dâng lĕ phung kôranh jan kar phung Israel tâm nchră băl joi nau ntôn Brah Yêsu gay ma tê̆ dôih nkhât lơi Păng, joi mâu ôh dơi say. ");
INSERT INTO cmo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Geh ŏk bunuyh ngơi nchơt ntôn Păng, yơn ma dâng lĕ nau khân păng ntôn nây mâu ôh tâm di băl. ");
INSERT INTO cmo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bu ƀaƀă dâk ngơi nchơt ntôn Brah Yêsu lah: ");
INSERT INTO cmo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hên tăng Păng ngơi lah: ‘Gâp rơih mƀăr lĕ nhih jan brah ma Kôranh Brah i ti bunuyh jan, jêh ri ta pe nar bơh kơi nây Gâp jan nhih jan brah du mlŏm êng jât, nhih jan brah i nây mâu geh ôh ti bunuyh jan’.” ");
INSERT INTO cmo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bol lah khân păng ntôn ma nau i nây kađôi, kŏ hôm mâu tâm di băl đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jêh ri dâk đưp i kôranh jan brah dŭt kuŏng nây, dâk bơh năp lĕ bunuyh i gŭ ta nây, păng ôp Brah Yêsu: “Mơm May mâu ơh nau bu ntôn May nây mêh?” ");
INSERT INTO cmo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Brah Yêsu gŭ iăt săk klăk mâu ơh đê̆ ro. Kôranh jan brah ôp tay Păng du tơ̆ jât: “Ndri May jêng Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl ngăn, i Kon Kôranh Brah ngăn ƀah?” ");
INSERT INTO cmo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Brah Yêsu ơh: “Ơ Gâp dja ngăn. Dâng lĕ khân may mra say Gâp i Kon Bunuyh tă bơh Kôranh Brah Gŭ bơh ma ti Kôranh Brah nơm i dŭt nau dơi gay ma mât uănh, Jêh ri jŭr bơh trôk ri hăn rŏ ndŏr tŭk.” ");
INSERT INTO cmo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jêh tăng Păng ngơi kơt nây, kôranh jan brah dŭt kuŏng nây nkhêk ao păng nơm chuik, jêh ri lah: “Bân mâu hôm khăch ôh joi bunuyh tơm say tơm tăng a êng jât. ");
INSERT INTO cmo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Lĕ khân may tăng dadê jêh nau pre mưch rmot Kôranh Brah. Ndri mơm khân may ŭch tê̆ dôih ma Păng?” Dâng lĕ bu lah tê̆ dôih nkhât lơi Păng. ");
INSERT INTO cmo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bu ƀaƀă leo băl soh dak diu ta Ôbăl, nkŭm măt thŭk Ôbăl, jêh ri ôp: “Lah May Brah Krist ngăn, mbơh ma hên bu moh thŭk May!” Jêh ri mpôl tahen njrăng nhih jan brah tap Ôbăl đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lŏng Pêtrôs ri păng hôm gŭ ta jŏng gung, jêh ri tât brô̆ du huê bu ur ta nây, păng jan kar ma kôranh jan brah dŭt kuŏng. ");
INSERT INTO cmo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tât say Pêtrôs gŭ njŏr ŭnh ta nây, păng uănh ăn n'hêl i muh măt, jêh ri lah: “Ngăn may jêng băl mpôl Yêsu to i tă bơh ƀon Nasaret!” ");
INSERT INTO cmo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pêtrôs rlăch lah: “Gâp mâu ôh gĭt vât moh nau ay re lah ri.” Jêh ri Pêtrôs du bơh ntŭk i nây hăn a mpông mpêr, nôk nây iăr lĕ ntơm ndrau. ");
INSERT INTO cmo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jêh ri bu ur i jan kar ta nây say Pêtrôs gŭ ta nây, păng mbơh lĕ bunuyh i gŭ ta ri du tơ̆ jât: “Păng i nây băl mpôl Bunuyh i bu nhŭp nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pêtrôs rlăch tay jât. Tât du ndŏm bơh kơi, mpôl bunuyh i gŭ ta nây ngơi ma Pêtrôs lah: “May dja băl mpôl Păng ngăn ro, rlau may bri Galilê tâm ban.” ");
INSERT INTO cmo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pêtrôs ngơi lah: “Lah gâp mƀrôh, gâp rtăp săk gâp nơm, dăn Kôranh Brah tê̆ dôih ma gâp dôh. Gâp mâu ôh gĭt năl Păng i khân ay may lah.” ");
INSERT INTO cmo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dô ma iăr ndrau du tơ̆ jât, jêh ri Pêtrôs ntơm kah gĭt nau Brah Yêsu lah nơh: “Ê lor ma iăr ndrau bar tơ̆ may rlăch pe tơ̆ lah mâu gĭt năl Gâp.” Jêh ri păng nhŭm rngot hô ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kah ôi tay ơm ôi mpôl kôranh jan brah, mpôl kôranh bri Yuđa, phung nơm nti nau vay phung Israel, ndrel ma phung kôranh jan kar phung bri Yuđa dâng lĕ tâm mâp băl tâm nchră nau, jêh ri đă bu chăp Brah Yêsu leo njŭn Păng ma kôranh kuŏng Pilat i bunuyh phung Rôm. ");
INSERT INTO cmo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat ôp Brah Yêsu: “Ngăn lah May kađăch phung Israel ƀah?” Brah Yêsu ơh ma păng lah: “Ơ, kơt nau may lah nau i nây.” ");
INSERT INTO cmo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mpôl kôranh jan brah ntôn Brah Yêsu jan tih ŏk ntil ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jêh ri Pilat ôp Păng du tơ̆ jât: “Lŏng khân păng ntôn May jan tih ŏk ntil ngăn, moh nau dâng May mâu ŭch ơh?” ");
INSERT INTO cmo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Brah Yêsu mâu ŭch ơh đê̆ ro, ndri dâng Pilat geh nau ndrŏt hih rhŏl. ");
INSERT INTO cmo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ăp năm ta nar nhêt ƀŭn n'hot, Pilat vay mƀơk du huê bunuyh dôih bu moh i phung ƀon lan de dăn. ");
INSERT INTO cmo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Geh du huê bu klô rnha Ƀaraƀas bu krŭng ta ndrung. Bu nhŭp păng ndrel mpôl bunuyh i lĕ tâm rdâng đah phung Rôm, ndrel ma lĕ nkhât bunuyh. ");
INSERT INTO cmo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Phung ƀon lan leo băl hăn mâp ma Pilat dăn păng ƀơk du huê bunuyh dôih tâng ma nau vay păng jan ăn ma ƀon lan. ");
INSERT INTO cmo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat ôp khân păng lah: “Ndri khân ay may ŭch ăn gâp ƀơk lơi i kađăch phung Israel bơh?” ");
INSERT INTO cmo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Păng lah kơt nây, yor ma păng lĕ gĭt jêh nuih n'hâm mpôl kôranh jan brah mâu nach, ndri dâng khân păng njŭn Brah Yêsu ăn ma păng nây. ");
INSERT INTO cmo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mpôl kôranh jan brah leo băl nsôch phung ƀon lan, nkhơng ma đă Pilat ƀơk lơi Ƀaraƀas. ");
INSERT INTO cmo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jêh ri Pilat lah ma phung i nây du tơ̆ jât: “Ndri a mơm khân ay may ăn gâp jan ma Bunuyh i khân ay may kuăl lah ‘Kađăch phung Israel’ dja?” ");
INSERT INTO cmo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bu nter drơu lah: “Nkhât Păng ta si tâm rkăng!” ");
INSERT INTO cmo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat ôp tay lah: “Bunuyh dja moh nau tih ta Păng?” Phung ƀon lan nter drơu lơ ma hô lah: “Nkhât Păng ta si tâm rkăng!” ");
INSERT INTO cmo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ach ma Pilat ŭch jan tâng nau phung ƀon lan dăn nơh, gay ma ăn khân păng răm maak, păng ƀơk lơi Ƀaraƀas. Jêh ri păng đă tahen rpăt Brah Yêsu ma mŏng rse, n'ho ma jao ăn tahen nkhât Ôbăl ta si tâm rkăng. ");
INSERT INTO cmo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jêh ri phung tahen têk leo Brah Yêsu hăn lăp ta jŏng gung nhih kôranh kuŏng. Tât ta nây kuăl lĕ phung tahen ăn tâm mâp băl. ");
INSERT INTO cmo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bu de sŏ ao jong chăng i tâm ban ma ao kađăch nsoh ăn Ôbăl nsoh, jêh ri sŏ rtao lok ƀăr jan môk kađăch ndô ta bôk Ôbăl ri. ");
INSERT INTO cmo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jêh ri tahen leo băl ngơi n'grơh n'grăp ma Ôbăl lah: “Hơi kađăch phung Israel! Hên yơk May.” ");
INSERT INTO cmo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jêh ri tahen de sŏ mŏng reh rpăt ta bôk Păng, soh dak diu ta Ôbăl n'ho ma jan lah chon kômŏk yơk mbah ma Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jêh n'grơh n'grăp ma Ôbăl kơt ndri, jêh ri tahen droh lơi ao chăng bơh săk Păng, plơ̆ nsoh tay ao Păng nơm nơh, jêh ri têk leo Ôbăl a ntŭk nkhât ta si tâm rkăng. ");
INSERT INTO cmo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Rŏ trong nây geh du huê bu klô i tă bơh ƀon Kiren păng tă bơh bri lăp a ƀon. Tahen de nchâp ôbăl tui si tâm rkăng Brah Yêsu. Păng i nây rnha Simôn i bơ̆ Alêksăntrus, ndrel ma i bơ̆ Ruphus. ");
INSERT INTO cmo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jêh ri tahen leo Brah Yêsu tât ta ntŭk i bu rnha ‘Gôlgôtha’, rblang lah ‘Ntŭk nting bôk’. ");
INSERT INTO cmo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bu sŏ ndrănh play yŭng yar ƀon lai đah dak si tăng du ntil i bu kuăl lah ‘Mâr’ ăn Păng nhêt, Păng mâu ŭch ôh nhêt. ");
INSERT INTO cmo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jêh ri tahen de nkhât Ôbăl ta si tâm rkăng, n'ho ma sŏ nhŭp ndơ nchroh gay ma tâm pă băl kho ao Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ta mong sân ôi tahen nkhât Păng ta si tâm rkăng. ");
INSERT INTO cmo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bu pla kađar du rlat nchih mbơh nau tih Păng lah: ‘Păng dja kađăch phung Israel’. ");
INSERT INTO cmo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ta nây geh đŏng bar hê bunuyh ntŭng, bu de nkhât ta si tâm rkăng kơt Brah Yêsu đŏng, i du huê ăn bơh ma Păng, du huê jât ăn bơh chiao. ");
INSERT INTO cmo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nau tât dja tâm di ma nau lĕ geh nchih ta Nau Kôranh Brah Ngơi lah: ‘Păng i nây bu kơp ndrel bunuyh tih’. ");
INSERT INTO cmo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lĕ bunuyh i brô̆ rŏ nây, n'grơh n'grăp rteh bôk ma Ôbăl, n'ho ma lah: “Hơi Bunuyh lah rơih lơi nhih jan brah ma Kôranh Brah, jan tay i mhe pe nar jêh. ");
INSERT INTO cmo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Lah ndri rklaih êng săk May nơm jŭr bơh si tâm rkăng nây hŏm!” ");
INSERT INTO cmo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay phung Israel leo băl ngơi n'grơh ma Păng kơt nây đŏng, khân păng lah: “Păng lĕ kơl ăn ma bu êng êng, tih ma săk Păng nơm mâu ôh dơi kơl. ");
INSERT INTO cmo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Păng i Brah Krist jêng bunuyh lĕ Kôranh Brah de kơih ngăn, Păng kađăch phung Israel, ăn Păng jŭr bơh si tâm rkăng aƀaơ ri, ăn hên say n'ho ma nsing đŏng!” Bunuyh i bu nkhât kêng Brah Yêsu nây, mưch rmot Ôbăl đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tât nar nklang bôk dô ma lam bri dak i nây trôk geh ngo dadê n'ho ma tât mong pe kêng măng. ");
INSERT INTO cmo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ta mong pe kêng măng, Brah Yêsu nter dŭt hô lah ta nau ngơi Hêbrơ: “Êloi, Êloi, Lama Sapăchthani?” Nau dja rblang lah ‘Ơ Kôranh Brah Gâp, ơ Kôranh Brah Gâp, moh nau May ntlơi Gâp?’ ");
INSERT INTO cmo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bu ƀaƀă i gŭ ta nây tăng nau Păng nter nơh vĭ iăt, bu lah: “Ô, Păng kuăl Êliya i bunuyh ntơyh nau ngơi Kôranh Brah bơh kăl e nơh.” ");
INSERT INTO cmo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Geh du huê bu klô hăn nchuăt sŏ bok yŭk ta dak srat put ta chông mŏng ndơ̆ ăn Păng nhêt, n'ho ma ngơi lah: “Kŏp uănh ƀŏt, gĭt Êliya hăn njŭr Păng bơh si tâm rkăng mâu lah mâu.” ");
INSERT INTO cmo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jêh ri Brah Yêsu nter dŭt hô, n'ho ma roh n'hâm klŏk. ");
INSERT INTO cmo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ta mong nây bok i nching ta jrô dŭt kloh ueh ta trôm nhih jan brah ma Kôranh Brah dô ma hêk chuik jêng bar, ntơm bơh lơ n'ho ma tât a dŏng. ");
INSERT INTO cmo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Du huê kôranh tahen Rôm i dâk bơh năp Brah Yêsu say Păng roh n'hâm kơt nây, kôranh tahen i nây ngơi lah: “Bu klô dja i Kon Kôranh Brah ngăn ya!” ");
INSERT INTO cmo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Geh mpôl bu ur ƀaƀă uănh bơh ngai. Ta mpôl bu ur i nây, geh Mari i tă bơh ƀon Mađala, geh Mari i mê̆ Yakơ jê̆, ndrel ma i mê̆ Yôsê, ndrel ma Salômê đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Lĕ bu ur i nây tâng kơl Brah Yêsu ntơm bơh Păng gŭ ta bri Galilê. Geh ŏk bu ur êng jât, khân păng lĕ rngôch tâng Păng tât ta ƀon kuŏng Yêrusalem. ");
INSERT INTO cmo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Lĕ nau i nây tât ta nar ndrăp i nar ê lor ma nar Saƀăt i nar rlu phung Israel. Lĕ tât kêng măng nar i nây jêh, ");
INSERT INTO cmo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","jêh ri geh du huê bu klô rnha Yôsep i tă bơh ƀon Arimathê, păng bunuyh lư kuŏng ta mpôl kôranh jan kar phung Israel. Păng hôm kŏp tât nau Kôranh Brah mât uănh lĕ bunuyh đŏng, ndri nuih n'hâm păng bănh ngăn hăn mâp Pilat dăn sŏ săk Brah Yêsu gay ma tŏp. ");
INSERT INTO cmo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tât păng mâp Pilat, Pilat geh nau mân ndrŏt hih rhŏl ngăn tăng nkoch lah Brah Yêsu lĕ khât hơyh kơt nây. Păng kuăl kôranh tahen i nkhât Brah Yêsu nây nơh, gay ma gĭt n'hêl lah Brah Yêsu lĕ khât ngăn mâu lah mâu. ");
INSERT INTO cmo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jêh păng tăng lĕ nau tahen nây nkoch, păng ăn Yôsep sŏ săk Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yôsep rvăt bok laih nglang, jêh ri păng njŭr săk Brah Yêsu bơh si tâm rkăng, njor put ma bok i nây tê̆ ta trôm môch lŭ du ntŭk i bu de lôk ta lŭ klêr ma jan trôm môch. Jêh ri păng rlă du mlŏm lŭ rdŏl trôm môch nây. ");
INSERT INTO cmo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari i tă bơh ƀon Mađala, ndrel ma Mari i mê̆ Yôsê lĕ gŭ ta nây đŏng, lĕ uănh say ntŭk bu tê̆ săk Brah Yêsu nơh. ");
INSERT INTO cmo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","A măng jêh lôch nar Saƀăt i nar rlu phung Israel mpôl bu ur Mari i tă bơh ƀon Mađala, Mari i mê̆ Yakơ, ndrel ma du huê bu ur êng jât rnha Salômê leo băl rvăt dak ngi ƀô kah gay ma ndjôt tŏ ta săk Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kah ơm ôi ta nar pơh, khân păng leo băl hăn a môch nôk bri lĕ ang nar lĕ lôh, ");
INSERT INTO cmo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ngơi ndrăng khân păng nơm lah: “Ndri bu moh sơm rlă lŭ i rdŏl trôm môch ăn ma bân hiah?” ");
INSERT INTO cmo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tât ta môch nây, khân păng ngơk uănh say lŭ lĕ ơm rlă jât meng trôm môch. Lŭ i nây kuŏng ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jêh khân păng lăp ta trôm môch nây, say du huê bu ndăm gŭ rgơp mpeh bơh ma, nsoh ao kuŏng nglang. Lŏng mpôl bu ur i nây klach nsŏr. ");
INSERT INTO cmo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bu ndăm i nây lah ma khân păng: “Lơi dâng klach ôh! Khân ay joi Brah Yêsu i tă bơh ƀon Nasaret i bu nkhât ta si tâm rkăng nơh. Lĕ Kôranh Brah rdŏk Păng ăn dâk rêh tay. Păng mâu hôm ôh gŭ ta dja, uănh eh, ta ntŭk dja bu njor săk Păng nơh. ");
INSERT INTO cmo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hăn khân ay sât mbơh mpôl oh mon Păng ri, n'ho ma mbơh Pêtrôs đŏng: ‘Păng hăn a bri Galilê lor bơh năp khân ay may, a ri tay khân ay may say Păng, tâm di kơt Păng lĕ jêh ntĭnh nơh’.” ");
INSERT INTO cmo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jêh ri mpôl bu ur nây du lôh bơh môch nchuăt rŏng brŏng nđâp ma nsŏr klach ndrŏt hih rhŏl ngăn. Khân păng mâu ôh mbơh nau i nây ăn ma bu, yor ma klach hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ta ôi nar pơh, Brah Yêsu dâk rêh tay, Păng nhhơ lor săk ăn ma Mari say, Mari i nây tă bơh ƀon Mađala. Păng Brah Yêsu lĕ mprơh pơh brah djơh lôh bơh săk păng nơh. ");
INSERT INTO cmo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jêh ri Mari hăn mbơh nau i nây ăn ma mpôl oh mon Păng, khân păng hôm e rngot rvê nhŭm vơl Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tât tăng Mari nkoch lah Păng lĕ dâk rêh tay, tăng nkoch đŏng lah Mari lĕ say Păng, mâu ôh khân păng ŭch iăt. ");
INSERT INTO cmo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jêh ri Brah Yêsu nhhơ săk ăn bar hê oh mon say, jêh khân păng lôh bơh ƀon Yêrusalem hăn rŏ trong. Nôk nây muh măt Brah Yêsu êng đah a lor nơh. ");
INSERT INTO cmo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jêh ri bar hê khân păng hăn plơ̆ jât kơi mbơh nau i nây ma mpôl oh mon a êng đŏng, tih ma khân păng mâu ŭch iăt đŏng. ");
INSERT INTO cmo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kêng ma dŭt nôk khân păng hôm gŭ sông sa, Brah Yêsu nhhơ săk ăn ma 11 nuyh mpôl kôranh oh mon say, jêh ri Brah Yêsu nduih khân păng, ach ma khân păng dăng ko mâu ŭch iăt lĕ nau i bu nkoch lah say Păng lĕ jêh dâk rêh tay nơh. ");
INSERT INTO cmo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Păng lah ma khân păng: “Khân may hăn ăn lam neh ntu dja, jêh ri mbơh nkoch nau mhe mhan ueh ăn ma dâng lĕ bunuyh dô. ");
INSERT INTO cmo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bu moh iăt nau nkoch i nây jêh ri dơn nau ƀăptem yŭk ma dak, păng i nây Kôranh Brah de rklaih. Bu moh i mâu iăt ôh păng i nây Kôranh Brah tê̆ dôih ma păng ro. ");
INSERT INTO cmo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bu moh i iăt nau i nây, khân păng jan nau mbên kơt nđa: mprơh brah djơh yor ma nau dơi Gâp, blao nau ngơi i khân păng mâu ôh prot ngơi. ");
INSERT INTO cmo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Lah khân păng nhŭp bêh geh kăch, mâu lah nhêt ndơ khêh, khân păng mâu geh nau tât đŏng. Lah khân păng tê̆ ti ta bunuyh ji, nau ji păng bah ro.” ");
INSERT INTO cmo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jêh kôranh Yêsu ngơi lĕ nau i nây, jêh ri Kôranh Brah sŏ n'hao Păng sât ta ƀon ueh kalơ trôk, ăn gŭ mpeh bơh ma ti Kôranh Brah nơm. ");
INSERT INTO cmo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jêh ri khân păng hăn mbơh nkoch nau mhe mhan ueh ăp ntŭk, n'ho ma Kôranh Brah kơl jan kar ndrel khân păng, ăn khân păng dơi jan nau mbên êng êng, gay ma ăn bu say nau i nây lĕ di ngăn.");
INSERT INTO cmo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Dăn kôh mbah lah ueh ma kôranh Thêôphil, ăn gĭt! Geh ŏk bunuyh i say ma măt ŏk ntil nau Brah Yêsu jan, ntơm Păng ntŭm nti ma bunuyh. Jêh ri bunuyh i nây n'ho ma jan kar mbơh nkoch nau Kôranh Brah. Geh ŏk bunuyh tăng nau khân păng mbơh nkoch nây, jêh ri nchih nau i nây ăn ma hên gĭt. ");
INSERT INTO cmo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Lŏng gâp mêt uănh dâng lĕ nau i nây dŭt n'hêl nanê̆ ngăn. Gâp gĭt nau dja di ngăn nchih ăn n'hêl ngăn gay ma njuăl ăn may đŏng, ");
INSERT INTO cmo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ŭch ăn may gĭt năl dâng lĕ nau i may lĕ tăng bu nti lah ma may nơh, nau i nây jêng di ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nôk Hêrôt jêng kađăch mât uănh ta bri Yuđa, nôk nây geh đŏng du huê bunuyh jan brah rnha păng Sakari, ur păng rnha Êlisabet, lĕ bar hê khân păng rnoi deh Arôn i bunuyh jêng kôranh jan brah lor bu ta phung Israel. Nôk nây mpôl jan brah geh 24 mpôl tâm pleh jan kar ta nhih jan brah ma Kôranh Brah ta ƀon kuŏng Yêrusalem, Sakari gŭ ta mpôl rnha Abia. ");
INSERT INTO cmo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Lĕ bar hê ur sai nây Kôranh Brah kơp khân păng jêng bunuyh sŏng srăng ngăn, ndjôt nâp dâng lĕ nau Kôranh Brah đă, jan di dadê mâu ôh du ntil tih. ");
INSERT INTO cmo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tih ma khân păng mâu geh kon, yorlah Êlisabet i bu ur mâu bă kon, săk jăn khân păng lĕ ranh đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tât di nar pleh mpôl jan brah mpôl Abia lăp jan kar ta jŏng gung nhih jan brah ma Kôranh Brah, nar nây Sakari bunuyh jan brah geh lăp jan kar ta nhih nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tâng nau vay jan mpôl jan brah, khân păng kơih du huê bunuyh ma ndơ nchroh, di ta plăng Sakari, jêh ri păng lăp su ndơ ƀô kah ta trôm nhih jan brah ri. ");
INSERT INTO cmo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jêh ri Sakari lăp ta trôm nây, su ndơ ƀô kah, bơh dih dja geh ŏk bunuyh gŭ mbơh sơm. ");
INSERT INTO cmo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Du n'hâm ta nây păng say du huê tông păr tă bơh Kôranh Brah, dâk bơh ma nsưng ma gŭch ndơ ƀô kah ri. ");
INSERT INTO cmo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tât ma say kơt nây, păng ndrŏt prôh, klach dŭt nsŏr ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jêh ri tông păr lah ma păng: “Hơi Sakari, lơi klach ôh! Kôranh Brah iăt kơt nau may lĕ jêh dăn, nar jât năp tay ur may geh du huê kon bu klô, ăn may tê̆ rnha kuăl păng ‘Yôhan’. ");
INSERT INTO cmo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kon i nây may răm rhơn hô ngăn, jêh ri geh ŏk bunuyh đŏng răm maak păng deh, ");
INSERT INTO cmo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","yorlah Kôranh Brah kơp kon i nây khlay hô ngăn ngên. Lơi ôh ăn păng nhêt ndrănh, mâu lah du ntil ndơ nhŭl, du tơ̆ mâu ăn đŏng. Brah Huêng Ueh i kloh ueh gŭ ta păng ntơm bơh ndŭl me ro. ");
INSERT INTO cmo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jêh ri păng leo ƀon lan Israel ŏk bunuyh rgâl lơi nuih n'hâm djơh plơ̆ sât ma Kôranh Brah i brah khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Păng văch lor bơh năp Kôranh Brah, n'ho ma geh Brah Huêng Ueh gŭ ta păng tâm ban ma bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, rnha Êliya, geh nau dăng tâm ban ma Êliya nây đŏng. Kon may i nây rplơ̆ nuih n'hâm bơ̆ ăn plơ̆ rŏng ma kon păng nơm, yor ma Brah Huêng Ueh gŭ ta păng. Geh ŏk bunuyh mâu iăt nau Kôranh Brah, kon may i nây rgâl nuih n'hâm djơh khân păng plơ̆ sât ma Kôranh Brah jêng bunuyh sŏng bunuyh ueh, kơt ndri păng ndrăp bunuyh du phung ăn ma vơt dơn Kôranh Brah đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakari ôp tông păr i nây lah: “Mơm jan hă, dâng gĭt nau nây hoch ngăn? Yorlah săk gâp dja lĕ ranh jêh, năm ur gâp lĕ ŏk đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tông păr plơ̆ ơh ma păng: “Gâp dja rnha Gabriel i kôranh tông păr kơl jan kar ma Kôranh Brah, Păng đă gâp leo nau ueh dja mbơh ăn may. ");
INSERT INTO cmo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nau dja geh ngăn tât di nar ri tay, tih ma may mâu iăt ôh nau gâp mbơh nkoch nơh. Uănh may tay jêng bunuyh mlo ngơi mâu blao ôh, n'ho ma tât ur may gŭ oh.” ");
INSERT INTO cmo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Bunuyh gŭ kŏp Sakari bơh dih ri, mâu vât ôh moh nau gŭ jŏ păng ta trôm nhih jan brah ri. ");
INSERT INTO cmo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jêh ri Sakari lôh a dih dja, păng ngơi đah bu mâu blao ôh. Păng nchŏng ma ti dơm gay ăn bu gĭt i nau păng say ri nơh. Tât say păng nchŏng ndri, khân păng gĭt vât ndơh nơh ta trôm nhih jan brah nây, Sakari geh say ndơ tă bơh Kôranh Brah ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Păng ê hŏ lĕ nar sât ôh, hôm gŭ jan kar ta nhih jan brah i nây jât, tât di lĕ nar bah jan kar, jêh ri păng plơ̆ sât a ƀon păng nơm ri. ");
INSERT INTO cmo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kah a kơi ri say ur păng ntreo, jêh ri i ur păng gŭ ngăn ta jay păng nơm ri jŏ prăm khay lĭch lôh dih ih nar ôh. Jêh ri păng lah: ");
INSERT INTO cmo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Nau ntreo gâp dja tă bơh Kôranh Brah dơm ăn ma gâp, Păng jan gâp, aƀaơ dja mâu hôm ôh đit prêng bu jât!” ");
INSERT INTO cmo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tât Êlisabet ntreo klăp geh prao khay, Kôranh Brah đă tông păr rnha Gabriel hăn ta ƀon Nasaret, bri Galilê, ");
INSERT INTO cmo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","gay ma mâp du huê bu drôh, rnha păng Mari. Bu drôh i nây păng lĕ jan ndrôi đah du huê bu ndăm, rnha păng Yôsep i che păng kăl e nơh kađăch Đavid đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jêh ri tông păr i nây lăp ta trôm jay Mari, păng lah: “Hơi yôh Mari, ueh lăng ay bơh! Kôranh Brah lĕ kơih du huê ay dơm, ăn nau geh jêng ma ay lơ ma kuŏng lơ ma prêh ngăn, Păng gŭ ndrel ay đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tât Mari tăng kơt nây păng mâu ôh gĭt vât, geh nau rvê ngăn, jêh ri nklŏn êng ta săk păng nơm: “Moh ƀă geh nau khlay ngơi pre i nây nơh?” ");
INSERT INTO cmo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jêh ri tông păr lah ma păng jât: “Ơi Mari, lơi ay klach ôh, Kôranh Brah kơih ay, gay ăn nau geh jêng kuŏng hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ay tay ntreo, jêh ri geh du huê Kon Bu Klô, ăn ay tê̆ rnha Păng kuăl ‘Yêsu’. ");
INSERT INTO cmo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kon dja geh nau khlay nau dơi hô ngăn ngên, bu kuăl Păng lah: ‘Kon Kôranh Brah i dŭt prêh’, jêh ri Kôranh Brah ăn Kon i nây jêng kađăch ma phung Israel tâm ban ma kađăch Đavid i che Păng kăl e nơh. ");
INSERT INTO cmo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yơn ma Păng tay jêng kôranh mât uănh ƀon lan Israel i kon sau rnoi deh Yakôp n'ho ro, Păng mât uănh mâu ôh blao lôch blao dŭt.” ");
INSERT INTO cmo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jêh ri Mari ôp tông păr i nây lah: “Mơm jan mêh dâng geh nau dja tât ngăn ro, yorlah gâp ê hŏ geh sai?” ");
INSERT INTO cmo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tông păr ơh: “Brah Huêng Ueh i kloh ueh văch gŭ ta ay, nau dơi Kôranh Brah i dŭt prêh nkŭm ăn n'hâm ma ay, ăn ay ntreo. Kơt ndri dâng Kon i nây kloh ueh, bu kuăl Păng ‘Kon Kôranh Brah’. ");
INSERT INTO cmo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Lŏng Êlisabet i ndŭl deh ay nơm, bol lah păng lĕ ranh, ndrel ma bu lah păng bu ur mâu bă kon kađôi lĕ, yơn ma aƀaơ dja păng lĕ ntreo kon bu klô klăp lah geh prao khay jêh, ");
INSERT INTO cmo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","yorlah mâu geh ôh du ntil ndơ Kôranh Brah mâu blao jan.” ");
INSERT INTO cmo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari ơh: “Gâp dja ŭch jan tâng dâng lĕ nau Kôranh Brah, ăn tât ngăn kơt nau i may lah ri!” Jêh ri tông păr du lôh bơh ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jêh ri Mari dâk ndal bơh ntŭk nây, hăn brŭl ro jât ƀon Sakari gŭ ri ta bri yôk, ntŭk bri Yuđa ri. ");
INSERT INTO cmo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tât ta jay Sakari ri păng ôp nau ueh lăng ma Êlisabet. ");
INSERT INTO cmo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tât tăng Mari ôp nây, dô ma mpŏt ro i kon ta trôm ndŭl Êlisabet ri. Jêh ri Brah Huêng Ueh i kloh ueh gŭ ngăn ta Êlisabet nây ro, ");
INSERT INTO cmo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ăn nau păng lah, jêh ri păng ngơi nteh nteh ngăn: “Kôranh Brah lĕ ăn nau geh jêng dŭt ueh ma ay ŏk rlau ma đah dâng lĕ bu ur êng jât, n'ho Păng ăn nau geh jêng ma Kon ta trôm ndŭl ay nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Moh geh nau khlay ta gâp dja hay, dâng geh ma bu ur i me kôranh gâp nơm hăn khŏl gâp! ");
INSERT INTO cmo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gâp gĭt năl ri nơh, yorlah kon ta trôm ndŭl gâp mpŏt răm maak ngăn ro, tât gâp tăng nau ay ôp ueh lăng nơh. ");
INSERT INTO cmo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ay lap ngăn yor ma iăt nau Kôranh Brah lah i nây tât ma ay ngăn ro, oh ê.” ");
INSERT INTO cmo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jêh ri Mari mprơ lah: “Nuih n'hâm gâp rnê ma Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Gâp răm maak hô ngăn ma Kôranh Brah i nơm rklaih gâp, ");
INSERT INTO cmo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yorlah Kôranh Brah hôm kơih gâp i bunuyh ƀon lan dơm kŏp iăt nau Kôranh Brah. Ntơm bơh dja jât năp tay ăp rnôk bunuyh, bu kuăl gâp i bu ur lap ngăn ngên, ");
INSERT INTO cmo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yorlah Kôranh Brah i geh nau dơi ăn ndơ nau khlay ngăn ma gâp. Kôranh Brah kloh ueh ngăn ngên, ");
INSERT INTO cmo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Păng yô̆ nđach ma bu moh i klach iăt nau Kôranh Brah N'ho ro tât ăp rnôk bunuyh, ");
INSERT INTO cmo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ndrel ma nhhơ nau dăng Păng, Ntrŭt lơi bunuyh i kơp êng săk păng nơm kuŏng. ");
INSERT INTO cmo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Păng nđuh lơi kađăch geh nau dơi ngăn ăn jêng bunuyh ƀon lan dơm, Jêh ri Păng n'hao bunuyh i ƀon lan. ");
INSERT INTO cmo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Păng ăn geh rmeh ler ma bunuyh ji ngot ji hir, Tih ma bunuyh ndrŏng kuŏng ăn sât dơm, tâng Kôranh Brah nơm ŭch. ");
INSERT INTO cmo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Păng kơl ƀon lan Israel i phung jan kar iăt nau Kôranh Brah nơm, Yor ma hôm kah gĭt nau yô̆ nđach Păng. ");
INSERT INTO cmo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Păng jan kơt nđa tâng nau Păng ton ma che Abrahăm kăl e nơh N'ho ma tât kon tât sau Abrahăm n'ho ro.” Ndri nau mprơ Mari. ");
INSERT INTO cmo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Păng gŭ ndrel Êlisabet klăp lah geh pe khay, ri mơ plơ̆ sât a jay păng nơm. ");
INSERT INTO cmo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tât Êlisabet ăp khay jêh, păng gŭ oh kon bu klô. ");
INSERT INTO cmo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bu nkoch đơn nau u lĕ ranh i nây hôm geh kon ăn lĕ mpôl chiao meng, ndrel ma băl mpôl păng nơh gĭt. Jêh tăng lư Kôranh Brah yô̆ nđach ma păng hô ngăn ngên kơt nđa, khân păng răm maak ndrel păng dadê. ");
INSERT INTO cmo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tât oh bê i nây lĕ geh pham nar, lĕ băl mpôl bar hê ur sai khân păng, ndrel ma bunuyh chiao meng hăn ran ta khân păng đŏng, tâng nau vay phung Israel, ăn bu koh ntô ma kon bê i nây, nkre ma ŭch tê̆ rnha păng, kuăl ‘Sakari’, kơt rnha i bơ̆ păng nơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tih ma i mê̆ ri lah: “Mâu ôh, ŭch tê̆ rnha păng, kuăl ‘Yôhan’.” ");
INSERT INTO cmo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bu plơ̆ ơh ma păng: “Tâng ma nau vay bân mâu di ôh, yorlah ta băl mpôl khân ay may mâu geh du huê rnha kơt ndri.” ");
INSERT INTO cmo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jêh ri bu ôp Sakari nchŏk ma ti, moh ŭch tê̆ rnha ăn ma kon păng nây. ");
INSERT INTO cmo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakari nchŏk đă khân păng sŏ rlat kađar, jêh ri nchih ta ri lah: “Kon dja tê̆ rnha păng, kuăl ‘Yôhan’.” Lĕ bu ta nây ndrŏt hih rhŏl dadê. ");
INSERT INTO cmo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Du n'hâm ta nây Sakari blao ngơi kơt ơm ro, jêh ri păng nteh bŏr ƀhŏng rnê Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bunuyh chiao meng klach dadê say nau dăng Kôranh Brah. Bu lư nau dja lam ntŭk ƀon rŏ yôk bri Yuđa nây. ");
INSERT INTO cmo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bu moh i tăng lư nau dja păng nklŏn êng ta nuih n'hâm hô ngăn, jêh ri ôp êng săk păng nơm lah: “Tât kon i nây lĕ kuŏng, mơm păng jêng?” Khân păng ngơi kơt ndri yorlah bu say nau dơi Kôranh Brah gŭ ta kon dja. ");
INSERT INTO cmo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jêh ri Sakari i bơ̆ oh bê ri, Brah Huêng Ueh i kloh ueh gŭ ta păng ngăn, đă păng ngơi, yor ri păng ngơi tă bơh Kôranh Brah, păng lah: ");
INSERT INTO cmo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Rnê ma Kôranh Brah i brah phung Israel yơk mbah, Yorlah Păng văch ŭch rklaih phung ƀon lan Păng nơm. ");
INSERT INTO cmo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kôranh Brah ăn du huê Bunuyh gay ma rklaih bân, Bunuyh i nây geh nau dơi ngăn, Păng rnoi deh kađăch Đavid i bunuyh jan kar iăt nau Kôranh Brah kăl e nơh, Păng i nây i bu kuăl Brah Krist đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kôranh Brah lĕ mbơh jêh nau dja ăn ma bunuyh ntơyh nau Păng ngơi kăl e nơh. ");
INSERT INTO cmo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nôk nây nơh Kôranh Brah lah, Păng mra rklaih bân bơh ti phung rlăng, ndrel ma ăn bân lôh bơh mpôl rngơ̆ mpôl biănh. ");
INSERT INTO cmo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Păng lĕ ton nau yô̆ nđach ma u che bân kăl e nơh. Nau tâm rnglăp kloh ueh Kôranh Brah Păng mâu chuêl ôh. ");
INSERT INTO cmo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Păng lĕ ton ngăn ma Abrahăm, che bân kăl e nơh, ");
INSERT INTO cmo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Păng tay rklaih bân bơh ti phung rlăng, Gay ma bân mâu hôm klach jan kar iăt nau Kôranh Brah, ");
INSERT INTO cmo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ndrel ma ăn bân jan kar nây sŏng srăng Tâm di đah nau Kôranh Brah ŭch n'ho ro ăp njăr nau rêh. ");
INSERT INTO cmo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lŏng kon gâp dja, bu tay lah păng jêng bunuyh ntơyh nau ngơi Kôranh Brah i brah dŭt prêh, Yorlah may hăn lor bơh năp Brah Krist, gay ma ndrăp nuih n'hâm bunuyh ăn ma Păng tâm ban ma bu kuayh trong ăn ma kađăch hăn. ");
INSERT INTO cmo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","May ăn ƀon lan Israel gĭt năl lah mơm Kôranh Brah rklaih khân păng lôh bơh nau tê̆ dôih, Mơm Kôranh Brah yô̆ mâu hôm ôh kơp mâu hôm ôh klăp ndăng nau tih khân păng. ");
INSERT INTO cmo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Păng yô̆ nđach bân hô ngăn, Ndri Păng ăn Brah Krist tă bơh kalơ trôk ntŭk Kôranh Brah ri jŭr văch ta bân, tâm ban ma ƀring lôh nar a ôi. ");
INSERT INTO cmo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Bunuyh i mâu gĭt năl Kôranh Brah, jêng tâm ban ma bunuyh i gŭ ta ntŭk ngo, bunuyh i klach khât đŏng, yơn ma Brah Krist văch ta dja jêng nau ang ma bunuyh i nây, Păng leo bân rŏ trong đăp mpăn.” Ndri nau Sakari ngơi. ");
INSERT INTO cmo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Lŏng Yôhan ri săk jăn păng lơ ma hao ndăm, nau mân gĭt blao păng lơ ma hô đŏng. Jêh ri păng gŭ rêh ta ntŭk bri rdah ngai bơh ƀon êng êng, n'ho ma tât nar păng nhhơ săk, jêh ri ntơm ntŭm nti ƀon lan Israel nây gĭt. ");
INSERT INTO cmo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nôk nây ta ƀon kuŏng Rôm, geh kôranh kađăch bu kuăl Sêsar, rnha păng Augus, păng lăp mât uănh kađăch ta bri êng êng. Geh du nar ri lôh nau tă bơh kôranh kađăch i nây đă ƀon lan dâng lĕ bri i păng mât, nchih săk kơp bunuyh tâng bri tâng ƀon u che khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nau nchih săk ƀon lan i nây bu jan bôk dak bu, dôl Kirinis jan kôranh kuŏng ta bri Siri. ");
INSERT INTO cmo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kơt ndri dâng lĕ bunuyh hăn grŭng nchih săk tâng ƀon u che khân păng nơm gŭ nơh. ");
INSERT INTO cmo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jêh ri Yôsep, lôh bơh ƀon Nasaret ta bri Galilê i ntŭk păng gŭ nây, brô̆ jât bri lơ jât ƀon Ƀêtlêhem, ta bri Yuđa i ri, i ntŭk ƀon deh kađăch Đavid kăl e nơh, yorlah Yôsep i nây păng rnoi deh kađăch Đavid. ");
INSERT INTO cmo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Păng brô̆ nchih săk ndrel Mari i bu ur bu gĭt lah ur păng, Mari i nây lĕ ntreo đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tât ta ƀon Ƀêtlêhem, Mari i nây lĕ ăp khay jêh. ");
INSERT INTO cmo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ta jay bu năch veh bêch lĕ bêng dadê. Jêh ri păng gŭ oh Kon Bu Klô, i nây Kon bôk dak. Mê̆ păng nkrum oh bê i nây ma bok, jêh ri tê̆ ta bong mpômpa (siŭm) nây. ");
INSERT INTO cmo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Măng i nây ta ƀon Ƀêtlêhem, geh mpôl chiăp gŭ rngeh kŏp uănh be biăp phung, be phung ta ndrĭch ri. ");
INSERT INTO cmo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jêh ri dô ma say du huê tông păr Kôranh Brah dâk kêng khân păng ri. Nau ueh chrêk ma lơp Kôranh Brah chrat dadê ngăn jŭm ntŭk nây, tât ma khân păng klach nsŏr săk jăn hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tông păr ri lah ma khân păng: “Lơi ta khân may klach ôh! Gâp leo mbơh nau mhe mhan ueh nkoch ăn ma khân may. Nau mhe mhan ueh dja ăn ma dâng lĕ bunuyh răm maak ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Măng dja ta ƀon Ƀêtlêhem i ƀon kađăch Đavid, geh du huê Kon Bu Klô mhe deh jêng nơm rklaih dâng lĕ bunuyh. Păng i nây bu lĕ mbơh lor kăl e nơh, Păng Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl, Păng kôranh khân may. ");
INSERT INTO cmo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Khân may gĭt năl Păng kơt dja, lah say du huê oh bê mhe deh bu put Păng ma bok, ăn bêch ta bong mpômpa (siŭm) nây.” ");
INSERT INTO cmo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jêh ri dô ma say đŏng phung tông păr dŭt ŏk ngăn, jŭr tă bơh kalơ trôk ntŭk Kôranh Brah ri, gŭ ndrel du huê tông păr i nây nơh, mprơ rnê ma Kôranh Brah lah: ");
INSERT INTO cmo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ăn rnê ma Kôranh Brah gŭ ta kalơ trôk dŭt prêh, Jêh ri ăn geh nau đăp mpăn ma bunuyh i Kôranh Brah rŏng ta neh ntu dja.” ");
INSERT INTO cmo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ndŭt tông păr hao sât a kalơ trôk lĕ rngŏt, khân păng tâm jă ndrăng khân păng nơm: “Hô̆! Lŏng bân hăn ta ƀon Ƀêtlêhem, uănh oh bê mhe deh ri, kơt nau Kôranh Brah mbơh ma bân ndơh nơh.” ");
INSERT INTO cmo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jêh ri khân păng dâk ndal tă bơh nây hăn joi ntŭk gŭ oh bê ri. Tât a ri say Mari, Yôsep, ndrel ma oh bê bêch ta bong mpômpa (siŭm) ri. ");
INSERT INTO cmo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jêh say oh bê i nây, khân păng mbơh nkoch nau tông păr lah ma oh bê i nây nơh. ");
INSERT INTO cmo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lĕ bunuyh i tăng nau mpôl chiăp be biăp chiăp be i nây nkoch, khân păng ndrŏt hih rhŏl ta nuih n'hâm. ");
INSERT INTO cmo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lŏng i Mari nây păng hôm prăp nklŏn nau i nây ta săk păng nơm. ");
INSERT INTO cmo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jêh ri mpôl chiăp be biăp i nây khân păng plơ̆ sât, n'ho ma mprơ rnê ma Kôranh Brah, yorlah măt lĕ say tôr lĕ tăng, lĕ ndơ tông păr mbơh ma khân păng nơh jêng di dadê, mâu geh ôh tih du ntil. ");
INSERT INTO cmo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tât pham nar jêh deh, mê̆ bơ̆ đă bu koh ntô ăn ma Oh Bê i nây tâng ma nau vay phung Israel ma kon bu klô, n'ho ma tê̆ rnha Păng, kuăl ‘Yêsu’, kơt tông păr mbơh ma Mari nôk păng ê hŏ ntreo nơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Jêh gŭ oh geh 40 nar, Mari tâng nau vay Môsê lĕ nchih kăl e nơh, păng nhhơr siŭm nar ma jan brah, gay ma rao săk păng nơm ăn kloh. Tât di nar nây păng, ndrel ma sai păng, leo Oh Bê jê̆ ri ta ƀon kuŏng Yêrusalem. Tât ta ƀon nây, khân păng lăp ta jŏng gung nhih jan brah ma Kôranh Brah nhhơr bar mlŏm siŭm nar ma jan brah tâm di đah nau vay Kôranh Brah lĕ đă nhhơr nơh. Ăp tơ̆ jêh gŭ oh, nau vay nây đă bu nhhơr “Bar mlŏm ntơp, mâu lah bar mlŏm plŭk rah.” Jêh ri mê̆ bơ̆ nhhơr oh bê ri ma Kôranh Brah đŏng, khân păng jan kơt ndri tâng nau vay Kôranh Brah lĕ đă bu nchih kăl e nơh lah: “Dâng lĕ kon bu klô bôk dak, nđâp ma kon mpômpa (siŭm) nkuŏng bôk dak, ăn nhhơr prăp ma Kôranh Brah.” ");
INSERT INTO cmo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ta ƀon kuŏng Yêrusalem ri geh du huê bunuyh rnha păng Simêôn, păng i bunuyh ueh sŏng srăng, iăt nau Kôranh Brah ngăn, păng gŭ kŏp rhơp Brah Krist i Kôranh Brah ton đă hăn rtŭk rthi n'ho ma rklaih ƀon lan Israel đŏng. Brah Huêng Ueh i kloh ueh jŭr gŭ ta păng, ");
INSERT INTO cmo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","mbơh ăn păng gĭt, păng mâu khât ôh lah mâu hŏ say Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl. ");
INSERT INTO cmo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kah du nar ri Brah Huêng Ueh đă Simêôn hăn ta jŏng gung nhih jan brah ma Kôranh Brah. Tât ta nây say Yôsep, ndrel ma Mari leo Oh Bê hăn ta jŏng gung nhih jan brah ri đŏng, gay ma nhhơr Oh Bê i nây ma Kôranh Brah kơt nau bu lĕ jêh nchih ta nau vay nây nơh. ");
INSERT INTO cmo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jêh Simêôn say Oh bê i ri, păng klu, jêh ri păng rnê ma Kôranh Brah: ");
INSERT INTO cmo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ơi Kôranh Brah! Gâp dja i bunuyh jan kar iăt nau May, aƀaơ dja lah gâp khât, gâp lĕ geh nau đăp mpăn jêh, Yor nau May ton ma gâp nơh jêng di ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Trôm măt gâp lĕ say nau rklaih May ăn jêh. ");
INSERT INTO cmo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nau rklaih i nây May lĕ ndrăp ăn ma lĕ mpôl bunuyh say, ");
INSERT INTO cmo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Păng jêng tâm ban nau ang gay ma ngaang lĕ mpôl bunuyh i mâu di phung Israel, yor ma Păng ăn khân păng nây gĭt năl Kôranh Brah, Jêh ri phung êng êng rnê rhơn phung Israel, yor ma Brah Krist tă bơh phung i nây.” ");
INSERT INTO cmo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mê̆ bơ̆ Oh Bê i nây ndrŏt hih rhŏl nau Simêôn lah ma Kon bê khân păng. ");
INSERT INTO cmo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simêôn mbơh nau geh jêng ma khân păng, jêh ri lah ma Mari: “Kôranh Brah lĕ ăn bunuyh ŏk ta phung Israel geh nau roh hêng yor ma khân păng mâu iăt ôh ma Kon bê dja, yơn ma geh ŏk jât geh nau rklaih yor ma khân păng iăt ma Kon bê dja. Kôranh Brah nơm lĕ njuăl jêh Kon bê dja văch ta dja, tih ma ŏk bunuyh hôm tâm rdâng đah Păng. ");
INSERT INTO cmo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ndri dâng bu say kloh rah vah nau mân bunuyh dŭt ndŏp, i ay nơm tay geh ji ôh êt ôh êl ngăn, n'hă ma geh đao ntŏp rho ta play nuih play n'hâm ay ngăn.” ");
INSERT INTO cmo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jêh ri geh du huê u ranh, bunuyh ntơyh nau ngơi Kôranh Brah, păng rnha An, i kon Phanuel ta mpôl Asơr. Păng nđăp lĕ geh pơh năm, jêh ri sai păng khât, ");
INSERT INTO cmo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","jêh sai păng khât nây, păng gŭ ndrô n'ho, nôk nây păng lĕ ranh 84 năm. Păng gŭ nkre ta jŏng gung nhih jan brah, păng yơk mbah ma Kôranh Brah dâng măng dâng nar, geh ŏk păng mbơh sơm ăt sông sa. ");
INSERT INTO cmo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nôk Simêôn hôm ngơi, u An truyh ta nây, tât say Oh Bê i nây, păng ran rnê ma Kôranh Brah, jêh ri păng mbơh nkoch ma Oh Bê jê̆ nây ăn ma bunuyh i gŭ kŏp rơp hơp Brah Krist i Kôranh Brah đă hăn gay ma rklaih ƀon lan Israel. ");
INSERT INTO cmo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jêh mê̆ bơ̆ Brah Yêsu jan lĕ phiao tâm di tâng nau vay Kôranh Brah, jêh ri khân păng plơ̆ sât ta ƀon khân păng nơm, ƀon Nasaret ta bri Galilê ri. ");
INSERT INTO cmo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jêh ri Brah Yêsu ntơm têh đê̆ kuŏng đê̆ săk jăn Păng dăng, geh nau mân gĭt blao ngăn, yor ma Kôranh Brah gŭ ndrel kơl ma Păng. ");
INSERT INTO cmo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ta ăp năm bu nhêt ƀŭn n'hot, mê̆ bơ̆ Brah Yêsu, ndrel ma phung ƀon lan Israel vay hăn ta ƀon kuŏng Yêrusalem đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tâng nau vay khân păng vay jan nơh, mê̆ bơ̆ Brah Yêsu hao lăp nhêt ƀŭn. Tât du năm Brah Yêsu lĕ geh 12 năm, jêh ri mê̆ bơ̆ leo Păng hăn ndrel đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tât lôch nhêt ƀŭn, i mê̆ bơ̆ ri sât grŭng. Mâu gĭt ôh lah Kon khân păng hôm gŭ ta ƀon Yêrusalem, ");
INSERT INTO cmo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","nđôn lah lĕ hăn ndrel bu. Tât hăn lĕ geh du nar rmăng, ri mơ khân păng ntơm joi Kon khân păng ta băl mpôl khân păng gĭt năl, ");
INSERT INTO cmo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","joi mâu say ôh, jêh ri khân păng plơ̆ tay ta ƀon Yêrusalem, gay ma joi Păng ta ri. ");
INSERT INTO cmo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Joi tât pe nar, khân păng say Păng gŭ ta jŏng gung nhih jan brah ma Kôranh Brah ndrel nơm nti nau vay phung Israel ta ri, Păng gŭ iăt nau bu ngơi, nkre ma ôp bu nau êng êng jât. ");
INSERT INTO cmo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bu moh i tăng nau Brah Yêsu ơh, bu ndrŏt hih rhŏl ngăn, mâu vât ôh nau Păng ơh i nây blao ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tât mê̆ bơ̆ say jêh i Kon nây, bar hê khân păng nây ndrŏt hih rhŏl ngăn. Mê̆ Păng ôp: “Hơi Nô! Mơm jan May kơt nđay nây hă? Hên rvê hô ngăn hăn joi May.” ");
INSERT INTO cmo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kon păng ơh: “Hơi mê̆ bơ̆, moh nau khân ay may joi Gâp? Gâp dja gŭ ta jay i Bơ̆ Gâp nơm heh.” ");
INSERT INTO cmo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tih ma mê̆ bơ̆ mâu vât ôh nau Kon păng ơh i nây. ");
INSERT INTO cmo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","I mê̆ Păng ri prăp lĕ nau i nây ta trôm săk păng nơm. Jêh ri i Kon nây plơ̆ sât a ƀon Nasaret ndrel mê̆ bơ̆, iăt nau i mê̆ bơ̆ Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Brah Yêsu lơ ma ndăm, lơ ma geh nau mân gĭt blao, di nuih di n'hâm Kôranh Brah ngăn, ndrel ma di nuih di n'hâm bunuyh đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nôk kôranh kađăch Sêsar rnha Tipêriah, păng mât uănh ta ƀon Rôm lĕ geh 15 năm, geh Pŭntês-Pilat jan kôranh kuŏng ta bri Yuđa, geh Hêrôt-Ŏntipas, păng mât uănh bri Galilê, geh Philip i nô Hêrôt ri, păng mât uănh bri Iturê, ndrel ma bri Trakhônit, geh Lisanês, păng mât uănh bri Apelen. ");
INSERT INTO cmo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jêh ri geh đŏng bar hê kôranh mpôl jan brah, rnha khân păng Anas, ndrel ma Kaiphas. Nôk nây Yôhan i kon Sakari gŭ ta bri rdah ngai bơh ƀon êng êng, jêh ri Kôranh Brah ntĭnh nau ma păng. ");
INSERT INTO cmo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jêh ri Yôhan brô̆ ăp ƀon rŏ dak rlai Yôrđăn, mbơh nkoch ma ƀon lan rgâl lơi nuih n'hâm djơh, jêh ri dơn nau yŭk ma dak, i bu kuăl ‘ƀăptem’, gay ma nhhơ khân păng ŭch tâng nau Kôranh Brah, ndri dâng Kôranh Brah yô̆ nđach mâu hôm ôh kơp nau tih khân păng. ");
INSERT INTO cmo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Păng jan kơt nây tâm di kơt nau bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, rnha Êsai, păng nchih lah: ‘Geh du huê bunuyh nter ta bri rdah lah: ‘Ndrăp hŏm nuih n'hâm ăn ma Kôranh Brah Tâm ban ma bunuyh kuayh trong nsŏng trong ăn ma kađăch hăn, ");
INSERT INTO cmo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tâm ban ma bunuyh brôi lơi ntŭk rlŭng ăn bêng, Yôk jê̆ kuŏng khân păng jan ăn lŏng Khân păng nsŏng ntŭk kue kuăch ăn sŏng Ntŭk ndôh ndăp khân păng brôi lơi ăn lŏng, tâm ban ma kuayh trong ăn ma kađăch brô̆. ");
INSERT INTO cmo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ndri dâng lĕ bunuyh gĭt say nơm rklaih i Kôranh Brah de njuăl’’. ");
INSERT INTO cmo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jêh tăng nau Yôhan mbơh nây nơh, khân păng brô̆ grŭng đă păng ƀăptem yŭk ma dak, geh ŏk bunuyh i hăn ƀăptem yŭk ma dak, yơn ma mâu ŭch ôh rgâl lơi nuih n'hâm djơh, Yôhan lah: “Yê! Mpôl bunuyh djơh bunuyh janh tâm ban ma bêh ku, bu moh mbơh ma khân ay may dâng geh ma nchuăt krap bơh nau tê̆ dôih Kôranh Brah i bơi ma tât dja? ");
INSERT INTO cmo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lah khân ay may mâu ŭch Kôranh Brah tê̆ dôih, lah ndri gŭ sŏng jan ueh hŏm, gay ma gĭt say nuih n'hâm khân ay may lĕ rgâl ngăn ro. Lơi hôm lah êng ta săk khân ay may nơm: ‘Gâp lĕ sau Abrahăm ngăn, ndri Kôranh Brah mâu hôm ôh tê̆ dôih’. Gâp lah ma khân ay may, jêng sau Abrahăm dơm mâu ôh geh nau khlay, lŭ dja Kôranh Brah sŏ jan sau Abrahăm jêng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aƀaơ dja Kôranh Brah ŭch tê̆ dôih ma lĕ bunuyh i mâu jan ueh, Păng tâm ban ma bunuyh ndrăp pêh thao ma kăl lơi tơm si mâu geh play, jêh ri su lơi ma ŭnh.” ");
INSERT INTO cmo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Phung i nây ôp Yôhan: “Mơm jan hă, gay ma rklaih bơh Kôranh Brah tê̆ dôih hên?” ");
INSERT INTO cmo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yôhan ơh ma khân păng: “Bu moh i geh bar blah ao, ăn păng pă du blah ma bunuyh mâu geh, bunuyh i geh ndơ sông sa, ăn păng pă ma bunuyh mâu geh.” ");
INSERT INTO cmo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Geh bunuyh aƀă tă bơh mpôl kŏp sŏ prăk bơh ƀon lan ma ăn kôranh mât uănh, brô̆ dăn Yôhan ƀăptem yŭk ma dak ta ri, ôp păng đŏng: “Hơi nơm nti, lah ndri hên dja mơm jan mêh?” ");
INSERT INTO cmo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yôhan ơh: “Lơi ôh r'ŏt lơi ôh mƀrôh bu gay ma sŏ prăk ŏk rlau keh.” ");
INSERT INTO cmo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Geh phung tahen aƀă ôp păng: “Lah ndri hên dja, mơm jan mêh?” Păng ơh: “Lơi dâng ntôn nchroh bu, lơi ôh tŭn jot bu gay ma sŏ prăk bu, ăn sŏp tŏng dơn ma prăk khay khân may nơm hŏ.” ");
INSERT INTO cmo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Phung ƀon lan Israel, khân păng hôm gŭ kŏp tât Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl ri văch. Bunuyh i tăng nau Yôhan lah, dâng lĕ khân păng i nây geh mân êng ta nuih n'hâm: “Păng i nây Brah Krist mâu lah mâu?” ");
INSERT INTO cmo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jêh ri Yôhan mbơh dâng lĕ bunuyh, păng lah: “Gâp jan ƀăptem ăn khân ay may yŭk ma dak dơm, yơn ma geh du huê kôranh bơi tât jêh, Păng geh nau dơi rlau gâp ngăn, ta năp Păng gâp jêng bunuyh jê̆ lê̆ dơm, bol lah gâp sơm droh ntô jot Păng, hôm e mâu hŏ di đŏng đah nau jan kar Păng. Păng ƀăptem ăn khân ay may ma Brah Huêng Ueh i kloh ueh, ndrel ma ŭnh. ");
INSERT INTO cmo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Păng tâm ban ma bunuyh ndjôt dông, gay ma rseng lĕ ba i geh ta ntŭk Păng plên nây, ba rnglay Păng sŏ tôh prăp ta jay ba Păng nơm, i nsiăp Păng su lơi ma ŭnh mâu ôh blao nhhŏt, kơt ndri Păng tâm nkhah lơi bunuyh ueh đah bunuyh djơh, jêh ri tê̆ dôih ma bunuyh djơh.” ");
INSERT INTO cmo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ndri Yôhan păng mbơh nau mhe mhan ueh i nây ma phung ƀon lan, ndrel ma ntŭm nti nau a êng ŏk jât gay ma ăn khân păng rgâl lơi nuih n'hâm djơh. ");
INSERT INTO cmo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jêh ri Yôhan nduih lah dŭt dăng ăn ma Hêrôt-Ŏntipas i kôranh mât uănh bri Galilê, yor ma păng sŏ pit ur i oh păng nơm, rnha bu ur i nây Hêrôđias, jêh ri păng sŏ jan ur. Yôhan lah Hêrôt i nây ma nau păng jan tih êng êng ŏk jât, mâu ôh dơn ma nau tih i nây dơm, ");
INSERT INTO cmo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","păng jan tih lơ ma hô jât tât păng nhŭp krŭng Yôhan tê̆ ta trôm ndrung đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nôk Yôhan hôm jan ƀăptem ma phung ƀon lan, tât brô̆ Brah Yêsu dơn nau yŭk ƀăptem đŏng, jêh ƀăptem Păng hôm mbơh sơm, dô ma trôk pơk bŏng lahưr. ");
INSERT INTO cmo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jêh ri Brah Huêng Ueh i kloh ueh, uănh tâm ban ma plŭk, jŭr drŏm ta Păng ri, dôl nây geh tăng nteh bŏr tă bơh kalơ trôk lah: “May i Kon Gâp rŏng, Gâp răm rhơn May hô ngăn ngên.” ");
INSERT INTO cmo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tât nar Brah Yêsu ntơm jan kar ma Kôranh Brah, năm păng klăp lah lĕ geh 30 năm. Tâng nau bu mân, Păng nơh i Kon Yôsep, Yôsep i kon Hêli, ");
INSERT INTO cmo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hêli i kon Mătthăt, Mătthăt i kon Lêvi, Lêvi i kon Mêlki, Mêlki i kon Yanai, Yanai i kon Yôsep, ");
INSERT INTO cmo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yôsep i kon Matathês, Matathês i kon Amôt, Amôt i kon Nahŭm, Nahŭm i kon Êsali, Êsali i kon Nagai, ");
INSERT INTO cmo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai i kon Mat, Mat i kon Matathês, Matathês i kon Sêmi, Sêmi i kon Yôsek, Yôsek i kon Yuđa, ");
INSERT INTO cmo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuđa i kon Yôanan, Yôanan i kon Rêsa, Rêsa i kon Sôrôƀaƀel, Sôrôƀaƀel i kon Salathil, Salathil i kon Nêri, ");
INSERT INTO cmo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nêri i kon Mêlki, Mêlki i kon Ađi, Ađi i kon Kôsan, Kôsan i kon Êlmađăm, Êlmađăm i kon Er, ");
INSERT INTO cmo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er i kon Yôsuê, Yôsuê i kon Êlêsar, Êlêsar i kon Yôrim, Yôrim i kon Mathat, Mathat i kon Lêvi, ");
INSERT INTO cmo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lêvi i kon Simêôn, Simêôn i kon Yuđa, Yuđa i kon Yôsep, Yôsep i kon Yônam, Yônam i kon Êliakim, ");
INSERT INTO cmo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Êliakim i kon Mêlêa, Mêlêa i kon Mêna, Mêna i kon Matatha, Matatha i kon Nathan, Nathan i kon kađăch Đavid, ");
INSERT INTO cmo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","kađăch Đavid i kon Yêsê, Yêsê i kon Ôƀêt, Ôƀêt i kon Bôas, Bôas i kon Salmôn, Salmôn i kon Nahsôn, ");
INSERT INTO cmo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahsôn i kon Aminađăp, Aminađăp i kon Aram, Aram i kon Hesrŭn, Hesrŭn i kon Pêrês, Pêrês i kon Yuđa, ");
INSERT INTO cmo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuđa i kon Yakôp, Yakôp i kon Isăk, Isăk i kon Abrahăm, Abrahăm i kon Thêra, Thêra i kon Nahôr, ");
INSERT INTO cmo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahôr i kon Sêruk, Sêruk i kon Rêu, Rêu i kon Phalêk, Phalêk i kon Êƀer, Êƀer i kon Sêlas, ");
INSERT INTO cmo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sêlas i kon Khainan, Khainan i kon Arpasat, Arpasat i kon Sĭm, Sĭm i kon Nôê, Nôê i kon Lamêk, ");
INSERT INTO cmo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamêk i kon Mâthusala, Mâthusala i kon Hênŏk, Hênŏk i kon Yarêt, Yarêt i kon Mahalêlêl, Mahalêlêl i kon Khainan, ");
INSERT INTO cmo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Khainan i kon Ênôs, Ênôs i kon Sêt, Sêt i kon Ađăm, Ađăm i ri i kon Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jêh ri Brah Yêsu lôh bơh dak rlai Yôrđăn n'ho ma Brah Huêng Ueh gŭ ta Păng ngăn, jêh ri Brah Huêng Ueh i kloh ueh leo Păng ta bri rdah ngai bơh ƀon ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ta ntŭk nây kôranh mpôl brah djơh ndơm Păng 40 năng 40 nar, nôk nây Păng mâu geh ôh lăp ndơ sông sa du rnglay ta săk. Jêh bơh nây Păng ji ngot ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jêh ri kôranh mpôl brah djơh lah ma Păng: “Lah May Kon Kôranh Brah ngăn ngên, lŏng May đă lŭ dja ăn jêng nŭmpăng.” ");
INSERT INTO cmo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Brah Yêsu ơh: “Mâu ôh, lĕ bu nchih jêh ta Nau Kôranh Brah Ngơi: ‘Bunuyh mâu ôh rêh tă bơh ndơ sông sa dơm’.” ");
INSERT INTO cmo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jêh ri kôranh mpôl brah djơh leo Brah Yêsu ta ntŭk prêh, nhhơ du ndŏm dơm ăn Păng say dâng lĕ bri dak ta neh ntu dja. ");
INSERT INTO cmo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jêh ri lah ma Brah Yêsu: “Gâp ăn nau dơi ma May mât uănh dâng lĕ bri dak i nây, ndrel ma lĕ drăp ndơ nau khlay geh ta bri dak i nây, gâp ăn ma May dadê, yorlah lĕ drăp ndơ i nây nơh jêng drăp ndơ gâp nơm dadê, bu moh gâp ŭch ăn dŭt ta gâp nơm dơm. ");
INSERT INTO cmo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Lah ndri May yơk mbah ma gâp dô, ndri mơ dâng lĕ drăp ndơ i nây jêng drăp ndơ May dadê ro.” ");
INSERT INTO cmo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Brah Yêsu lah ma păng: “Mâu ôh, lĕ bu nchih jêh ta Nau Kôranh Brah Ngơi kăl e nơh: ‘Đă khân ay may yơk mbah ma Kôranh Brah i brah khân ay may nơm dơm hŏ Jan kar iăt nau du huê Păng i nây dơm hŏ’.” ");
INSERT INTO cmo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jêh bơh nây păng leo Brah Yêsu lăp ta ƀon kuŏng Yêrusalem, jêh ri ăn Brah Yêsu dâk ta kalơ chor nhih jan brah ma Kôranh Brah, ta ntŭk i dŭt prêh nây, păng lah ma Brah Yêsu: “Lah May Kon Kôranh Brah ngăn ngên, lŏng May nsăt jât dŏng su, ");
INSERT INTO cmo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","yorlah lĕ bu nchih jêh ta Nau Kôranh Brah Ngơi: ‘Kôranh Brah đă tông păr Păng nơm hăn Mât njrăng May. ");
INSERT INTO cmo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ti Păng drơ May, Mâu ôh ăn jŏng May geh nchĭnh ma lŭ’.” ");
INSERT INTO cmo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Brah Yêsu ơh lah: “Lĕ bu nchih jêh ta Nau Kôranh Brah Ngơi lah: ‘Lơi ôh rlong nau dơi Kôranh Brah i brah may nơm’.” ");
INSERT INTO cmo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Lĕ jêh ăp phiao păng ndơm Brah Yêsu, jêh ri păng du tă bơh Brah Yêsu ri n'ho ma kŏp tât di nar jât. ");
INSERT INTO cmo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jêh ri Brah Yêsu plơ̆ sât ta bri Galilê. Nau dơi Brah Huêng Ueh gŭ ta Păng. Jêh ri bu lư săk Păng ăp ntŭk ta bri i nây. ");
INSERT INTO cmo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Păng gŭ ntŭm nti bu ăp ntŭk ta nhih rƀŭn khân păng nơm, ăp bunuyh rnê Păng dadê ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Geh du nar ri Brah Yêsu hăn ta ƀon Nasaret, ntŭk Păng gŭ bơh jê̆ nơh. Tâng ma nau vay Păng nơh, nar Saƀăt i nar rlu phung Israel Păng hăn ta nhih rƀŭn. Jêh ri Păng dâk gay ma ndrăp rŏ Nau Kôranh Brah Ngơi ăn bu iăt. ");
INSERT INTO cmo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jêh ri bu sŏ Nau Kôranh Brah Ngơi, samƀŭt Êsai nchih i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, ndơ̆ ăn Brah Yêsu. Jêh ri Păng pơk ling uănh ta plăng ntŭk Êsai nchih lah: ");
INSERT INTO cmo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘Brah Huêng Ueh gŭ ta Gâp, Păng lĕ kơih Gâp Gay ma Gâp leo nau mhe mhan ueh mbơh ma bunuyh o ach. Păng đă Gâp hăn mbơh nkoch nau rklaih ăn ma bunuyh i Satăng i kôranh mpôl brah djơh lĕ nhŭp kât, Kôranh Brah de drih ƀơk dadê. Păng đă Gâp hăn mbơh nkoch ma bunuyh cheh măt ăn say ang. Jêh ri đă Gâp rklaih bunuyh bu tŭn jot. ");
INSERT INTO cmo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","N'ho ma mbơh năm Kôranh Brah yô̆ nđach lĕ tât’. ");
INSERT INTO cmo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lôch jêh Brah Yêsu rŏ nau i nây, Păng klôn Nau Kôranh Brah Ngơi ndơ̆ ăn ma bunuyh mât nhih rƀŭn, jêh ri Păng gŭ nti nau i nây. Lĕ bunuyh gŭ ta trôm nhih i nây uănh phŏng rao lao jât Păng ri dadê. ");
INSERT INTO cmo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jêh ri Brah Yêsu lah: “Lĕ Nau Kôranh Brah Ngơi i khân ay may tăng ndơh nơh, nar dja lĕ tât ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bơh ntơm dâng lĕ bunuyh ta nây khân păng maak rnê ma bŏr mbung Păng dadê, tăng nau Păng nti nơh blao ueh ngăn. Jêh ri geh bunuyh tâm rlăch ma nau Păng mbơh i nây nơh, khân păng lah: “Hay! Mơm Păng bănh ngơi kơt nây? Yorlah Păng i nây Kon Yôsep dơm.” ");
INSERT INTO cmo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Brah Yêsu lah ma khân păng: “Ngăn ro, khân ay may sŏ nau ngơi ntât dja lah ma Gâp: ‘Hơi Kôranh dak si, săm bah săk may nơm lor ƀŏt’, geh nau khlay lah ‘Hên lư tăng nau May lĕ jan ta ƀon Kapơnŭm, lŏng jan tay nau i nây ta ƀon May nơm dja đŏng’.” ");
INSERT INTO cmo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Brah Yêsu lah tay ma khân păng: “Gâp lah n'hêl nanê̆ ngăn ma khân ay may, bunuyh ntơyh nau ngơi Kôranh Brah ta ƀon păng nơm mâu geh ôh bu iăt nau păng. ");
INSERT INTO cmo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, rnha păng Êliya, nôk nây geh năm phang jŏ pe năm n'gul, mâu geh ôh ndơ sông sa, geh nau ji sŏt ji ngot kuŏng lam bri. Geh ŏk đŏng bu ur ndrô ta bri Israel. ");
INSERT INTO cmo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yơn ma Kôranh Brah mâu ôh đă păng hăn kơl du huê bu ur ndrô i nây, Păng đă hăn kơl nkhơng du huê bu ur ndrô ta bri Siđôn, ƀon Sarĭpđa ri. ");
INSERT INTO cmo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Geh du huê jât bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, rnha păng Êlisê, geh ŏk bunuyh phŭng sa ta bri Israel, mâu ôh du huê bah, dơn bah du huê ta phung bri Siri dơm rnha păng Namăn.” ");
INSERT INTO cmo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tât ma tăng nau Brah Yêsu ngơi kơt ri, lĕ bunuyh gŭ iăt ji nuih ma Păng dadê ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jêh ri khân păng dâk drưm njôm jŭm Brah Yêsu têk nglôh Păng du lôh bơh ƀon bu jan ta kalơ yôk nây, leo Păng jât jreng yôk ri gay ma nklơ̆ jât dŏng su. ");
INSERT INTO cmo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yơn lah Brah Yêsu brô̆ rŏ vah vang bunuyh ŏk lôh bơh ntŭk nây. ");
INSERT INTO cmo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jêh ri Brah Yêsu hăn jât ƀon Kapơnŭm, ta bri Galilê. Ăp nar Saƀăt i nar rlu phung Israel, Brah Yêsu ntŭm nti bu ta nhih rƀŭn. ");
INSERT INTO cmo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bu ndrŏt hih rhŏl ngăn tăng nau Păng nti i nây, yorlah nau ngơi Păng geh nau dơi, tih băl đah nau bu êng êng nti. ");
INSERT INTO cmo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Geh du nar Saƀăt, ta nhih rƀŭn nây geh du huê bu klô brah djơh lăp ta săk păng, jan ăn nter dŭt dăng dăng lah: ");
INSERT INTO cmo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ơ Brah Yêsu tă bơh ƀon Nasaret! Lơi May rkhuak hên, May hăn ŭch lơh lơi hên bơh? Gâp năl May ngăn, May i nây i Bunuyh kloh ueh tă bơh Kôranh Brah.” ");
INSERT INTO cmo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Brah Yêsu de mbram brah djơh i nây: “Lơi hôm ngơi, gŭ iăt săk rklăk hŏ, du lôh hŏm bơh bunuyh i nây!” Brah djơh lơh bu klô i nây ăn păng chôt ta năp băl phung, jêh ri lôh ƀhŭch bơh bunuyh i nây, mâu ôh ăn ôbăl geh nau ji. ");
INSERT INTO cmo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Dâng lĕ bunuyh say kơt nây nơh, ndrŏt hih rhŏl dadê ngăn, jêh ri tâm lah ndrăng khân păng nơm: “Hay! Mơm nau ngơi Păng i nây dâng tam ngăn hiah, dơi đă brah djơh lôh, lôh ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bu lư rnha săk Brah Yêsu lam ntŭk ăp ƀon i nây ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jêh Brah Yêsu lôh bơh nhih rƀŭn nây, hăn jât jay Simôn, ta jay i nây mê̆ po Simôn geh nau ji, ta săk păng dôh hô ngăn, bu dăn Brah Yêsu jan ăn bah po păng i ri. ");
INSERT INTO cmo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jêh ri Brah Yêsu hăn ta bunuyh ji i nây, n'ho ma mbram nau ji i ri, nau ji bah ndal ro. Jêh ri păng dâk đưp jan kar ndrăp ndơ sông sa ăn ma bu năch i gŭ ta jay nây. ");
INSERT INTO cmo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tât kêng măng bunuyh ta ƀon i nây khân păng leo oh nô i geh nau ji êng êng ran mâp Brah Yêsu. Păng tê̆ ti kalơ săk phung bunuyh ji i nây ăp khân păng, jan khân păng bah ji dadê. ");
INSERT INTO cmo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Geh bunuyh ŏk brah djơh lôh bơh săk khân păng, n'ho ma nter lah: “May Kon Kôranh Brah!”, yorlah khân păng gĭt Brah Yêsu Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl. Tih ma Brah Yêsu mbram mpôl brah djơh mâu ăn ôh ngơi. ");
INSERT INTO cmo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tât ơm ôi ôi tay ri, Brah Yêsu lôh bơh ƀon i nây hăn du huê êng ta ntŭk rdah ngai đah bunuyh gay ma mbơh sơm. Yơn ma geh phung ƀon lan tâng joi Păng groch groch ngăn, tât say Brah Yêsu khân păng kŏn gŭ ndrel mâu ăn ôh Păng du bơh khân păng. ");
INSERT INTO cmo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Brah Yêsu lah ma khân păng: “Kôranh Brah đă Gâp mbơh nau mhe mhan ueh jêng Kôranh Brah ŭch mât uănh bunuyh, ăn ma ƀon êng êng jât, yor nau dja dâng Păng đă Gâp hăn ta dja.” ");
INSERT INTO cmo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jêh ri Brah Yêsu mbơh nkoch nau mhe mhan ueh ăp nhih rƀŭn phung Israel rŏ bri Galilê ri. ");
INSERT INTO cmo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Geh du nar ri Brah Yêsu dâk ta meng dak nglao kuŏng, rnha nglao i nây Gênêsaret, mâu lah rnha nglao Galilê. Nar nây geh ŏk bunuyh ran ta Păng tâm mpet ngăn, gay ma iăt Păng nti nau Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jêh ri Păng say bar mlŏm duk ta meng kơh ri, i săk khân păng nơm lĕ jŭr rao jal a dak su, khân păng i nây jêng bunuyh jan kar văng ka dơm. ");
INSERT INTO cmo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jêh ri Brah Yêsu ncho du mlŏm duk, bunuyh tơm duk i nây rnha păng Simôn, Brah Yêsu đă păng vah duk ngai bơh meng ri đê̆. Păng gŭ rgơp ta kalơ duk nti phung ƀon lan. ");
INSERT INTO cmo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lôch jêh Brah Yêsu nti phung ƀon lan, Păng lah ma Simôn: “Hơi oh, lŏng may vah duk hăn jât dak jru ri, jêh ri seng jal may nây a dak su.” ");
INSERT INTO cmo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simôn plơ̆ ơh ma Păng lah: “Ơi Kôranh, bơh bôk măng tŏng ang ngăn hên seng jal mâu ôh geh ka, yơn ma lah May đă ri, ndri gâp seng iăt nau May hơyh.” ");
INSERT INTO cmo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jêh ri khân păng seng jal, tât ma seng ri geh ka dŭt ŏk bơi ma plŭng jal ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Say ŏk geh ka nây, khân păng rvêh ti kuăl i băl ta duk êng jât jă kơl. Jêh ri khân păng tê̆ ka bêng lĕ bar mlŏm duk, geh ŏk ka i ri bơi ngŏm duk. ");
INSERT INTO cmo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Tât say geh ka ŏk ir ar i nây, bunuyh i gŭ ndrel ta nây ndrŏt hih rhŏl dadê ngăn. Nôk Simôn i bu kuăl Pêtrôs đŏng say nau dơi Kôranh Brah gŭ ta Brah Yêsu ri, păng păn mbah ta jŏng Brah Yêsu ri ro, jêh ri lah: “Hơi Kôranh, du ngai bơh gâp dja, yorlah gâp bunuyh geh nau tih.” ");
INSERT INTO cmo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yơn ma Brah Yêsu lah ma Simôn: “Hơi oh, may lơi klach ôh, nar bơh kơi nơh may joi geh ka, ntơm nar dja may hăn joi geh bunuyh iăt nau Gâp, tâm ban ma seng bunuyh.” Bunuyh văng ka ndrel Simôn, du huê rnha Yakơ, du huê rnha Yôhan, bar hê khân păng i nây kon Sêƀêđê, khân păng vay jan kar ndrel Simôn, khân păng ndrŏt hih rhŏl dadê đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jêh ri khân păng vah duk jât meng kơh, tât duk a meng kơh ti, khân păng ntlơi ndoh ndơ ta ri dadê, nkre ma leo băl brô̆ tâng Brah Yêsu ro. ");
INSERT INTO cmo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Geh du nar Brah Yêsu gŭ ta du ƀon, ta ƀon i nây geh du huê bunuyh phŭng sa bêng săk bêng jăn ngăn, tât say Brah Yêsu, păng ran păn mbah bơh năp Brah Yêsu ta neh ro, n'ho ma bonh Păng: “Ơ kôranh, dăn May yô̆ nđach ma gâp ơ, lah May ŭch, gâp năl May dơi jan săk gâp ăn kloh ăn bah ji.” ");
INSERT INTO cmo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tâng nau vay phung Israel bu mâu ôh bănh gŭ dăch mâu ôh bănh pah ma bunuyh phŭng sa, yơn ma Brah Yêsu pah ti ta săk păng ri chrao, jêh ri lah ma bunuyh phŭng sa i nây: “Ơ Gâp ŭch đŏng, bah hŏm!” Jêh ri bah ndal ro. ");
INSERT INTO cmo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Brah Yêsu buay păng lah: “Lơi may nkoch nau dja ma bu êng gĭt yơ̆, ăn may hăn brŏng nhhơ săk ma bunuyh jan brah ri, jêh ri nhhơr ndơ tâng nau vay Môsê đă ma bunuyh bah nau ji phŭng sa, gay ma bu gĭt n'hêl săk may lĕ kloh ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yơn ma bu lư Brah Yêsu lơ ma hô lơ ma hô ngăn. Ŏk bunuyh văch ran iăt nau Păng ngơi, n'ho ma đă Păng jan bah nau ji êng êng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yơn ma tâng nau vay Brah Yêsu, Păng hăn ta ntŭk rdah ngai đah bunuyh, gay ma mbơh sơm êng. ");
INSERT INTO cmo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Geh du nar jât dôl Brah Yêsu gŭ nti ta trôm nhih, geh phung Pharisi, ndrel ma phung nơm nti nau vay phung Israel, khân păng gŭ iăt ta nây đŏng. Phung i nây tă bơh ăp ƀon bri Galilê, ăp ƀon bri Yuđa, ndrel ma bơh ƀon kuŏng Yêrusalem. Brah Yêsu geh nau dơi Kôranh Brah gŭ ndrel Păng, gay ma jan bah bunuyh ji. ");
INSERT INTO cmo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nôk nây geh bu tung du huê bu klô rven jŏng rven ti ma nkŏ, khân păng joi trong ma leo bunuyh i nây hăn dăch Brah Yêsu gay ma tê̆ bơh năp Păng ri. ");
INSERT INTO cmo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tih ma joi trong mâu geh ôh, ŏk ir bunuyh, jêh ri hao rŏ gung kalơ chor nhih ri, chor nhih i nây lŏng, khân păng plôk chor i nây, njŭr bunuyh rven ri nđâp ma nkŏ păng nơm ta nklang bu băl, plăng bơh năp Brah Yêsu ri ro. ");
INSERT INTO cmo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Brah Yêsu say khân păng geh nau nsing Păng dơi jan bah nau ji kơt nây, Păng lah ma bunuyh rven i nây: “Hơi oh, Gâp lĕ yô̆ may, mâu hôm ôh kơp nau tih ta may.” ");
INSERT INTO cmo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tât tăng nau nây, phung nơm nti nau vay phung Israel, ndrel ma phung Pharisi, lah êng ta nuih n'hâm: “Bu moh Păng i nây hay? Dâng bănh ngơi mưch rmot Kôranh Brah kơt ndri! Geh du huê Kôranh Brah dơm dơi yô̆ nau tih bunuyh.” ");
INSERT INTO cmo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Brah Yêsu gĭt nau khân păng mân ta nuih n'hâm, jêh ri Păng ôp: “Mơm dâng khân may geh nau mân kơt nđay? ");
INSERT INTO cmo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ăn khân may gĭt nau dja, lah Gâp lah ma bunuyh rven i nây ‘Nau tih may lĕ Gâp yô̆ hơi’, mâu lah ‘May dâk brô̆ hŏm’, lah ndri moh nau lah i dơh rlau hă? Lĕ bar nau i nây bunuyh dơm mâu dơi jan. ");
INSERT INTO cmo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gâp ŭch ăn khân may gĭt say, Gâp i Kon Bunuyh tă bơh Kôranh Brah, ndri dâng Gâp dơi yô̆ nau tih bunuyh ta neh ntu dja.” Jêh ri Brah Yêsu uănh jât bunuyh rven i nây lah: “May dâk hŏm, ndjôt nkŏ may nây sât a jay may nơm ri.” ");
INSERT INTO cmo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jêh ri dô ma say bunuyh rven i nây dâk đưp ta năp bu băl, păng ndjôt nkŏ i bu tung păng nơh sât jât jay, n'ho ma rnê ma Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lĕ bunuyh i gŭ ta nây ndrŏt hih rhŏl dadê, rnê Kôranh Brah. Khân păng klach hô ngăn, n'ho ma lah: “Lĕ nau ngăn ndơ bân say nar dja.” ");
INSERT INTO cmo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jêh ri Brah Yêsu lôh bơh ƀon i nây hăn rŏ trong say du huê bu klô gŭ kŏp sŏ prăk bơh bu ma ăn kôranh mât uănh, rnha păng i nây Lêvi, păng gŭ ta ntŭk păng vay sŏ prăk. Brah Yêsu lah ma păng: “Hơi nô, hô̆ brô̆ tâng Gâp.” ");
INSERT INTO cmo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Păng ntlơi lĕ phiao ndoh ndơ ta ri, jêh ri tâng Brah Yêsu ro. ");
INSERT INTO cmo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jêh ri păng jă Brah Yêsu hăn ta jay păng nơm, păng ndrăp nau nhêt sa têh ăn ma Brah Yêsu, ndrel ma mpôl oh mon Brah Yêsu. Geh ŏk bunuyh hăn lăp sông sa ndrel ta ri đŏng, ta nây geh bunuyh kŏp sŏ prăk bơh bu ma ăn kôranh mât uănh, ndrel ma bunuyh aƀă êng jât. ");
INSERT INTO cmo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tât say kơt nây, phung Pharisi, ndrel ma phung nơm nti i tâng phung Pharisi i nây, ji nuih kŏ nuih kŏ n'hâm ngăn, khân păng lah mpôl oh mon Brah Yêsu: “Moh khân may sông ndrel bunuyh sŏ prăk bu, nhêt ndrel bunuyh tih?” ");
INSERT INTO cmo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Brah Yêsu ơh ma khân păng: “Bunuyh ueh săk lăng jăn mâu ŭch ôh ma kôranh dak si, bunuyh i geh nau ji dơm ŭch. ");
INSERT INTO cmo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ndri dâng Gâp văch ta dja mâu ôh gay ma kuăl bunuyh sŏng, ŭch kuăl bunuyh tih, gay ma păng rgâl lơi nuih n'hâm djơh ăn iăt tâng nau Kôranh Brah.” ");
INSERT INTO cmo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jêh ri phung Pharisi, ndrel ma phung nơm nti i tâng phung Pharisi i nây ôp Brah Yêsu: “Mpôl oh mon Yôhan-Ƀaptem, ăt sông sa, mbơh sơm ƀaƀơ, kơt mpôl oh mon Pharisi đŏng. Mơm dâng mpôl oh mon May gŭ nhêt gŭ sông kơt nđay chrao?” ");
INSERT INTO cmo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Brah Yêsu ơh: “Lah tâm nđăp ur sai, khân may vay buay bu năch mâu ăn sông sa đŏng bơh? Bu mâu vay ôh buay ndri. ");
INSERT INTO cmo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gâp tâm ban ma bu klô nđăp ur sai, tât di nar ri tay bu tâm nkhah Gâp đah mpôl oh mon Gâp, ri mơ khân păng ăt sông sa.” ");
INSERT INTO cmo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jêh ri Brah Yêsu ngơi nau ntât: “Bu mâu vay ôh nkhêk ao mhe, gay ma jâng mbôl ta ao sat, lah jan kơt nây ao mhe lĕ jêng sat, ndrel ma bok i nkhêk bơh ao mhe mbôl ta ao ơm păng mâu đŏng tâm di băl. ");
INSERT INTO cmo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bu mâu vay ôh tê̆ prăp ndrănh play yŭng yar ƀon mhe ta dŭng ntô ơm, lah jan kơt nây ndrănh play yŭng yar ƀon mhe jan ăn dŭng ntô i nây prek, ndrănh hŭk, jêh ri dŭng ntô i nây jêng sat đŏng, yorlah dŭng ntô ơm mâu hôm ôh toch. ");
INSERT INTO cmo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lah ndri bu tê̆ ndrănh play yŭng yar ƀon mhe ta dŭng ntô mhe, ri mơ dŭng, ndrel ma ndrănh hôm dadê. ");
INSERT INTO cmo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Lah lĕ jêh nhêt ndrănh play yŭng yar ƀon ơm, bu mâu hôm ôh ŭch nhêt i mhe jât, lah nhêt bu lah ‘I ơm kah rlau i mhe’.” ");
INSERT INTO cmo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Geh du nar Saƀăt i nar rlu phung Israel, Brah Yêsu ndrel oh mon Păng hăn glăt rŏ mir Ba Prăng, dôl brô̆ rŏ mir i nây mpôl oh mon Păng roih ba tro ma sa. ");
INSERT INTO cmo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jêh ri geh phung Pharisi aƀă say jan kơt nây, lah khân păng: “Moh kô̆ khân may jan kar ta nar Saƀăt nây mêh? Bol lah khân may roih đê̆ đê̆ kơt nây, hôm e kơp tih đah nau vay ma nar rlu phung bân đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Brah Yêsu ôp rlơ̆ khân păng: “Lah ndri khân may lĕ chuêl ƀah, nau khân may vay rŏ ta Nau Kôranh Brah Ngơi? Nôk Đavid ê hŏ jêng kađăch, păng, ndrel ma bunuyh gŭ ndrel păng ji ngot, ");
INSERT INTO cmo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","jêh ri păng lăp ta trôm ntŭk chun bok Kôranh Brah, sŏ sa nŭmpăng i bu tê̆ nhhơr ăn Kôranh Brah nây, n'ho ma pă bunuyh i gŭ ndrel păng nây sa đŏng. Bu mâu đŏng lah păng bol lah tâng ma nau vay geh mpôl jan brah dơm dơi sa nŭmpăng i nây.” ");
INSERT INTO cmo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Brah Yêsu lah tay: “Gâp i Kon Bunuyh tă bơh Kôranh Brah de njuăl, ndri dâng Gâp jêng kôranh ma nar Saƀăt i nar rlu moh ndơ i dơi ăn bu jan, mâu lah mâu dơi ăn bu jan ta nar i nây.” ");
INSERT INTO cmo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Geh du nar Saƀăt êng jât, Brah Yêsu lăp nti bu ta nhih rƀŭn phung Israel. Ta ntŭk nây geh du huê bu klô siăr ti bơh ma. ");
INSERT INTO cmo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Geh phung nơm nti nau vay phung Israel, ndrel ma phung Pharisi kŏp uănh Brah Yêsu. Phung i nây ŭch joi nau ma ntôn Brah Yêsu, nkhêp lah Păng jan bah bunuyh ji ta nar Saƀăt, yorlah khân păng nti ta nau vay phung Israel mâu ăn ôh jan bah bunuyh ji ta nar Saƀăt, ndri dâng khân păng uănh jât Păng ler nger ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yơn lah Brah Yêsu gĭt nuih n'hâm nau mân khân păng, jêh ri Păng lah ma bunuyh siăr ti nây: “Hơi oh, may dâk hăn ta nklang bu to!” Bunuyh siăr ti i nây dâk ro. ");
INSERT INTO cmo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jêh ri Brah Yêsu ôp khân păng: “Gâp ôp khân may, tâng nau vay phung bân ta nar Saƀăt bunuyh dơi jan ndơ ueh mâu lah ndơ djơh? Dơi rklaih nau rêh bunuyh mâu lah nkhât păng?” ");
INSERT INTO cmo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Brah Yêsu uănh jât dâng lĕ bunuyh i gŭ ta nây, yơn ma mâu geh ôh du huê ơh, jêh ri lah ma bunuyh rven ti nây: “Lŏng may rok ti may nây hŏm.” Jêh ri păng rok, ti păng bah kơt ơm ro. ");
INSERT INTO cmo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Phung i ŭch joi nau ma ntôn Brah Yêsu nây ji nuih dŭt hô, jêh ri tâm nchră băl gay ma lơh Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nôk nây Brah Yêsu hao kalơ yôk gay ma mbơh sơm. Păng mbơh sơm ma Kôranh Brah ta ntŭk nây du năng raang. ");
INSERT INTO cmo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kah ang ôi tay Păng kuăl rgum mpôl i vay tâng Păng văch ta ri, jêh ri kơih 12 nuyh bu klô, i Păng kuăl lah ‘kôranh oh mon’ Păng. ");
INSERT INTO cmo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ta nây geh rnha Simôn, jêh ri Brah Yêsu kuăl rnha mhe păng, Pêtrôs, ndrel ma i oh păng rnha Ŏndrê, jêh ri bunuyh aƀă êng jât rnha Yakơ, rnha Yôhan, rnha Philip, rnha Ƀartôlômê, ");
INSERT INTO cmo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","rnha Mathay, rnha Thômas, rnha Yakơ i kon Alphai, rnha Simôn i bu kuăl ‘gơyh’ ");
INSERT INTO cmo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","rnha Yuđas i kon Yakơ, ndrel ma rnha Yuđas-Isakariyôt, jêng bunuyh njŭn Brah Yêsu ăn ma phung rlăng Păng ta nar jât năp tay. ");
INSERT INTO cmo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jêh ri Brah Yêsu, ndrel ma mpôl oh mon Păng jŭr bơh lơ yôk nây, hăn tât ta ntŭk lŏng ri. Ta ntŭk nây geh ŏk mpôl oh mon iăt nau Păng, ndrel ma phung ƀon lan ŏk ngăn, khân păng tă bơh ƀon kuŏng Yêrusalem, ndrel ma bơh ƀon êng êng ta bri Yuđa, bơh bri rgŏ dak văch dak văr dăch kêng ƀon kuŏng Tirus ƀon kuŏng Siđôn. ");
INSERT INTO cmo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Khân păng văch gum ta ri ŏk ngăn, gay gŭ iăt nau Brah Yêsu nti, ndrel ma ăn Păng jan bah nau ji kuet khân păng nơm đŏng. Bunuyh i brah djơh lơh, kơt lah bunuyh brŭt ndrăng văch ta ri, jêh ri bah đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Lĕ bunuyh tâm mpet ngăn ran pah Brah Yêsu, jêh ri bu bah dadê, yorlah Păng geh nau brah ta săk Păng nơm. ");
INSERT INTO cmo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jêh ri Brah Yêsu uănh jât mpôl oh mon Păng, Păng lah: “Ueh maak ngăn ma khân ay may bunuyh kro o ach, Yorlah Kôranh Brah mât uănh khân ay may. ");
INSERT INTO cmo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ueh maak ngăn ma khân ay may aƀaơ dja gŭ ta nau ji ngot, Yorlah jât năp tay khân ay may hơm ngăn. Ueh maak ngăn ma khân ay may gŭ ta nau nhhiăng nhŭm aƀaơ dja, Yorlah jât năp tay khân ay may geh nau răm maak. ");
INSERT INTO cmo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ueh maak ngăn ma khân ay may, lah geh bu rngơ̆ bu biănh mâu rom khân ay may, mâu lah rak suai, ach ma khân ay may iăt tâng nau Gâp i Kon Bunuyh tă bơh Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nôk kăl e nơh tâm ban kơt nây đŏng, u che mpôl rngơ̆ biănh i nây jan djơh ma mpôl bunuyh ntơyh nau ngơi Kôranh Brah. Lah geh kơt ndri răm ntlô̆ hŏm, răm maak hŏm, yorlah jât năp tay khân ay may geh nau nkhôm kuŏng ngăn ro ta ƀon ueh ta kalơ. ");
INSERT INTO cmo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tih ma rêh rnhăl ngăn ma khân ay may i bunuyh lĕ ndrŏng kuŏng aƀaơ dja, Yorlah khân ay may aƀaơ dja lĕ geh jêh nau răm maak. ");
INSERT INTO cmo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Rêh rnhăl ngăn ma khân ay may aƀaơ dja lĕ hơm jêh, Khân ay may tay geh nau ji ngot ji hir ro. Rêh rnhăl ngăn ma khân ay may aƀaơ dja lĕ geh nau răm maak, Khân ay may tay geh nau nklŏn rngot rvê, jêh ri nau nhhiăng nhŭm ro. ");
INSERT INTO cmo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Rêh rnhăl ngăn ma khân ay may i geh ŏk bunuyh rnê, yor ma u che khân păng lĕ rnê ma bunuyh ntơyh nklă nau ngơi Kôranh Brah kăl e nơh đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jêh ri Brah Yêsu ngơi jât: “Lŏng dâng lĕ bunuyh i iăt nau Gâp, Gâp đă khân ay may rŏng ma bunuyh rlăng, jêh ri jan ueh ma bunuyh biănh đah khân ay may đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ăn khân ay may dăn Kôranh Brah ăn geh jêng ma bunuyh rak suai khân ay may, jêh ri mbơh sơm dăn Kôranh Brah jan ueh ma bunuyh i jan jêr ma khân ay may. ");
INSERT INTO cmo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Lah bu tap tâm bom khân ay may du ding, jêh ri rle ăn bu tap tay du ding jât. Lah bu sŏ ao kuŏng lơi ôh buay mâu ăn bu sŏ ao jê̆ jât. ");
INSERT INTO cmo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Moh ndơ bu dăn khân ay may, ăn ndơ i nây ma bu, lah geh bu sŏ ndoh ndơ khân ay may lơi hôm mplơ̆ ôh. ");
INSERT INTO cmo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Moh nau ŭch ăn bu jan ma khân ay may, ăn khân ay may jan ma bu lor. ");
INSERT INTO cmo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Lah khân ay may rŏng dơm ma bunuyh rŏng khân ay may lor, Kôranh Brah mâu ôh rnê khân ay may, yorlah bunuyh tih blao tâm rŏng ndrăng bunuyh tih đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Lah khân ay may jan ueh dơm ma bunuyh jan ueh đah khân ay may, Kôranh Brah mâu ôh rnê khân ay may, yorlah bunuyh tih blao jan ueh ndrăng bunuyh tih đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Lah khân ay may ăn bu manh drăp, mâu lah prăk ma bunuyh i dơi ntrŏ dơm, Kôranh Brah mâu ôh rnê khân ay may, yorlah bunuyh tih tâm ăn manh hôm tâm trŏ đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kơt ndri Gâp ŭch ăn khân ay may jan tih băl đah khân păng. Ăn khân ay may rŏng ma bunuyh rlăng, jan ueh ma păng, ndrel ma ăn păng manh drăp ndơ, jêh ri lơi hôm ôh nkah tôr ma drăp ndơ i nây. Lah jan ndri khân ay may tay geh nau nkhôm kuŏng, n'ho ma jêng kon Kôranh Brah nơm i brah dŭt kuŏng, yorlah Kôranh Brah jan ueh đŏng ma bunuyh mâu gĭt tôr ma Păng, ndrel ma bunuyh djơh. ");
INSERT INTO cmo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Lah ndri ăn khân ay may geh nau yô̆ nđach, tâm ban ma Kôranh Brah Bơ̆ khân ay may ta kalơ trôk Păng geh nau yô̆ nđach ma khân ay may.” ");
INSERT INTO cmo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Jêh ri lơi ôh uănh nau tih bu, gay ma lơi ăn Kôranh Brah uănh nau tih khân ay may. Lơi phat dôih bu, gay ma lơi ăn Kôranh Brah tê̆ dôih khân ay may. Ăn khân ay may yô̆ nđach nau tih bu, ndri dâng Kôranh Brah yô̆ nđach nau tih khân ay may đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ăn ndơ ma bu, jêh ri Kôranh Brah ăn ndơ ma khân ay may, Păng sŏl nsruh, jêh ri tê̆ bêng rmeh ma khân ay may đŏng, yorlah dah ŏk khân ay may ăn ma bu, Kôranh Brah ăn kơt nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Brah Yêsu ngơi nau ntât du nau êng jât ma khân păng đŏng: “Lah geh bar hê bunuyh cheh măt tâm têk ndrăng khân păng nơm, blao đŏng lah mâu? Păng tŭp ta trôm ntu lĕ bar hê ro. ");
INSERT INTO cmo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mâu geh ôh phung nti gĭt rlau ma nơm nti, yơn ma lah păng nti lĕ ăp phiao, păng jêng tâm ban ma nơm sơm nti păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nau tih bân jêng tâm ban ma ndơ ta trôm măt, mơm khân ay may uănh say ndruyh ta trôm măt oh nô khân ay may dơm, tih ma uănh mâu say mŏng rlat ta trôm măt khân ay may nơm? ");
INSERT INTO cmo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Lah mâu dơi say mŏng rlat ta trôm măt khân ay may nơm, mơm dơi lah ma oh nô: ‘Ăn gâp nkhĕ ndruyh nây’? Ơ bunuyh mƀrôh! Ăn sŏ rlat ta trôm măt khân ay may nơm nây lor ƀŏt, ri mơ say n'hêl ndruyh ta trôm măt oh nô, dâng blao nkhĕ ndruyh nây.” ");
INSERT INTO cmo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mâu prot ôh geh tơm si, i tơm ueh, i play mâu ueh, mâu lah i tơm mâu ueh, i play ueh. ");
INSERT INTO cmo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bu dơi gĭt năl tơm si yor ma play păng. Bu mâu prot pĕ play ngle bơh tơm rsŏp, play yŭng yar ƀon bơh tơm nam. ");
INSERT INTO cmo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bunuyh kơt ndri đŏng, bunuyh ueh păng jan moh ntil ndơ ueh, yorlah ta nuih n'hâm săk jăn păng nơh ueh, tih lah bunuyh djơh, păng jan ntil ndơ djơh, yorlah ta nuih n'hâm săk jăn păng nơh djơh, ndri dâng lĕ ntil bŏr mbung bunuyh ngơi, ndrel ma ndơ păng jan, lôh tă bơh nuih n'hâm săk jăn păng nơm.” ");
INSERT INTO cmo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mơm khân ay may kuăl Gâp ‘Ơ kôranh! Ơ kôranh!’, tih ma mâu jan tâng nau Gâp đă? ");
INSERT INTO cmo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Gâp mbơh ăn khân ay may: Bunuyh i brô̆ iăt nau Gâp ngơi, jêh ri jan tâng nau Gâp lah, bunuyh i nây mơm jêng tâm ban ma păng? ");
INSERT INTO cmo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bunuyh i nây jêng tâm ban ma bunuyh jan jay. Păng kuyh ntu jru, jêh ri păng tăm meh ta trôm ntu nây, lah geh dak kuŏng hoch thăng rŏ jay i nây kŏ mâu dơi rngônh đŏng, yorlah lĕ jan dŭt nâp. ");
INSERT INTO cmo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bunuyh i tăng nau Gâp, jêh ri mâu jan tâng nau Gâp lah, bunuyh i nây jêng tâm ban ma bunuyh jan jay n'gŏn dơm ta kalơ neh. Lah tât geh dak kuŏng hoch thăng rŏ nây, jay i nây rlŏm, n'ho ma djơh lĕ phiao ro.” ");
INSERT INTO cmo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jêh Brah Yêsu ngơi nau i nây ăn ma phung ƀon lan, jêh ri Păng hăn lăp ta ƀon Kapơnŭm bri Galilê, ndrel ma mpôl oh mon Păng. ");
INSERT INTO cmo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ta ƀon nây geh du huê bunuyh ji hô ngăn bơi ma khât, bunuyh i nây jêng dâk du huê kôranh tahen Rôm, kôranh rŏng ngăn ma păng. ");
INSERT INTO cmo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tât kôranh tahen i nây tăng lư bu nkoch Brah Yêsu, jêh ri păng đă mpôl kôranh Israel aƀă hăn jă Brah Yêsu, gay ma hăn jan bah dâk i nây. ");
INSERT INTO cmo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jêh ri mpôl kôranh i nây hăn mâp Brah Yêsu, tât ta Brah Yêsu ri khân păng bonh Păng hăn ndrel khân păng: “Ơi Kôranh, May yô̆ ma kôranh tahen Rôm i nây di mê̆, ");
INSERT INTO cmo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","yorlah păng rŏng ma ƀon lan bân, jêh ri păng sơm ăn prăk ma jan du mlŏm nhih rƀŭn jât ăn bân.” ");
INSERT INTO cmo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jêh ri Brah Yêsu hăn ndrel mpôl kôranh i nây. Tât bơi truyh a jay ri, kôranh tahen i nây đă mât jăng păng hăn chuă mbơh Brah Yêsu a trong ri: “Ơ kôranh! Mâu khăch ôh jă leo May lăp ta jay gâp, yorlah gâp mâu di phung Israel, ndri dâng mâu lăng di lah gâp jă May lăp ta jay gâp. ");
INSERT INTO cmo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ndri dâng gâp nơm mâu bănh hăn mâp May đŏng. Dăn May lah du tong bơh nây, dâk gâp bah ji ro. ");
INSERT INTO cmo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gâp gŭ ta nâm bu, yơn lah geh kon tahen ŏk gŭ ta nâm gâp đŏng. Lah gâp đă du huê hăn, păng hăn ro, lah đă bunuyh a êng văch, păng văch ro. Lah gâp đă dâk gâp jan du ntil ndơ, păng jan ro. Lah ndri, gâp gĭt lah May ngơi geh nau dơi kơt nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tât Brah Yêsu tăng nau kôranh tahen i nây, ta nuih n'hâm Păng ndrŏt nhhih ngăn. Jêh ri Păng rle jât bunuyh i brô̆ ndrel Păng, nkre ma lah: “Gâp mbơh ma khân ay may, bol lah ta phung Israel i kơp êng săk khân păng nơm lah lĕ gĭt năl Kôranh Brah, ê hŏ geh nau nsing kơt păng i nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jêh ri mât jăng i kôranh tahen đă hăn nây nơh, khân păng plơ̆ sât jât kơi, tât a jay say dâk păng i nây lĕ bah ji. ");
INSERT INTO cmo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jêh ri Brah Yêsu hăn jât ta du ƀon, rnha ƀon i nây Nain. Geh ŏk bunuyh hăn ndrel Păng, mpôl oh mon Păng nơm, ndrel ma bunuyh aƀă êng ŏk đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nôk khân păng bơi ma tât ta meng mpông mpêr ƀon i nây, say geh bunuyh brô̆ n'hoch tŏp khât. Bunuyh i khât nây kon bu klô, dơn geh du huê kon bu klô i nây dơm, i mê̆ ri ndrô khât sai jât. Jêh ri geh ŏk bunuyh ta ƀon i nây brô̆ ndrel păng. ");
INSERT INTO cmo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tât Brah Yêsu say bu ur ndrô khât sai i nây, Păng yô̆ nđach hô ngăn. Brah Yêsu lah ma păng: “Lơi hôm nhŭm.” ");
INSERT INTO cmo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jêh ri Brah Yêsu hăn dăch pah ta mŏng rnung nây, mpôl i tung ri nsrŭng đŏng, Păng lah ma bunuyh i khât nây: “Hơi oh, Gâp mbơh ma may dâk hŏm!” ");
INSERT INTO cmo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jêh ri bunuyh khât i nây dâk đơp gŭ ta ri ro, blao mbơh ngơi ƀhŏ. Jêh ri Brah Yêsu njŭn bu klô ndăm i nây a mê̆ păng nơm. ");
INSERT INTO cmo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Lĕ bunuyh i gŭ ta nây klach dadê ngăn, khân păng rnê ma Kôranh Brah: “Lĕ geh Bunuyh ntơyh nau ngơi Kôranh Brah dŭt kuŏng lĕ văch gŭ ndrel bân, Păng văch tâm ban ma Kôranh Brah văch kơl phung ƀon lan Păng nơm.” ");
INSERT INTO cmo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Khân păng mbơh nkoch Brah Yêsu nây lam bri Yuđa, ndrel ma lam bri chiao meng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mpôl oh mon Yôhan-Ƀaptem say dâng lĕ nây, jêh ri hăn mbơh dâng lĕ nau i nây ăn Yôhan-Ƀaptem gĭt. ");
INSERT INTO cmo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jêh ri Yôhan-Ƀaptem đă bar hê mpôl oh mon păng hăn mâp Brah Yêsu ôp Păng kơt nđa: “Nôk kăl e nơh Kôranh Brah lĕ ton ma bunuyh ntơyh nau ngơi Kôranh Brah lah, geh Brah Krist i nơm rklaih lĕ Kôranh Brah de kơih jŭr văch tă bơh kalơ trôk ntŭk Kôranh Brah nơm. May dja Brah Krist i nây bơh, mâu lah ăn hên hôm kŏp du huê êng jât?” ");
INSERT INTO cmo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jêh ri bar hê khân păng i nây hăn tât ta Brah Yêsu, ôp Păng: “Hơi Kôranh, hên dja Yôhan-Ƀaptem đă hăn ôp May, gĭt May dja ngăn Brah Krist i Kôranh Brah lĕ ton jŭr văch, mâu lah ăn hên hôm kŏp du huê êng jât?” ");
INSERT INTO cmo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nôk nây ŏk bunuyh Brah Yêsu lĕ jan ăn bah ji, bunuyh geh nau ji êng êng, bunuyh brah djơh lơh, jêh ri ŏk bunuyh cheh măt Păng jan ăn say ang đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Brah Yêsu lah ma mpôl oh mon Yôhan-Ƀaptem i nây: “Khân may mbơh nkoch ma păng ri, dâng lĕ ndơ khân may lĕ tăng, lĕ say Gâp jan. Bunuyh cheh măt uănh say, bunuyh tâk tôr iăt tăng, bunuyh kuet rven blao brô̆, bunuyh phŭng sa bah kloh, bunuyh khât dâk rêh, jêh ri bunuyh o ach tăng nau mhe mhan ueh. ");
INSERT INTO cmo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ueh maak ngăn ma bunuyh mâu mƀăr nau păng nsing ma Gâp, yor ma ndơ Gâp jan tih đah nau mân păng ŭch!” ");
INSERT INTO cmo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ndŭt khân păng plơ̆ sât, Brah Yêsu ntơm ngơi ma Yôhan-Ƀaptem ăn ma phung ƀon lan: “Moh bunuyh uănh khân ay may hăn ta bri rdah? Hăn uănh bunuyh i ngơi dah ma bunuyh êng êng ŭch, tâm ban ma ja mpăt rngônh dah sial ma khôm bơh? Păng mâu di ôh. ");
INSERT INTO cmo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Moh bunuyh khân ay may hăn uănh? Uănh bunuyh nsoh bok ueh ao ueh bơh? Mâu ôh. Bunuyh nsoh bok ueh ao ueh, sông sa piăng kah trao kah, mpôl nây gŭ ntŭk kađăch gŭ, mâu ôh gŭ ta bri rdah. ");
INSERT INTO cmo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Lah ndri bu moh bunuyh khân ay may hăn uănh? Uănh bunuyh ntơyh nau ngơi Kôranh Brah bơh? Di ngăn. Yơn ma păng i nây rlau ma bunuyh ntơyh nau ngơi Kôranh Brah jât, ");
INSERT INTO cmo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","yorlah ta Nau Kôranh Brah Ngơi lĕ geh nchih lah ma păng: ‘Lŏng Gâp njuăl bunuyh hăn lor May Gay ma ndrăp nuih n'hâm bunuyh tâm ban ma kuayh trong ăn ma May’. Yôhan-Ƀaptem i nây i bunuyh hăn lor ta nau i nây. ");
INSERT INTO cmo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Khân ay may iăt nau Gâp, dâng lĕ bunuyh i deh tă bơh bu ur ta neh ntu dja, mâu geh ôh du huê kuŏng rlau Yôhan-Ƀaptem, yơn lah ta mpôl bunuyh i Kôranh Brah mât uănh, bunuyh i jê̆ ta nâm bu, bunuyh i nây jêng kuŏng rlau păng ngăn.” ");
INSERT INTO cmo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Phung ƀon lan, ndrel ma bunuyh sŏ prăk ƀon lan gay ma ăn kôranh mât uănh, jêh khân păng iăt nau Yôhan-Ƀaptem, jêh ri khân păng ăn păng ƀăptem khân păng yŭk ma dak, ndri khân păng nhhơ khân păng gĭt Kôranh Brah jêng di ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tih ma phung Pharisi, ndrel ma phung nơm nti nau vay phung Israel, khân păng mâu ôh ăn păng ƀăptem yŭk khân păng ma dak, ndri khân păng dun lơi lĕ nau Kôranh Brah ŭch ăn ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jêh ri Brah Yêsu lah: “Lah ndri mơm Gâp tâm rđâl ma bunuyh aƀaơ dja? Păng mơm jêng? ");
INSERT INTO cmo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Păng jêng tâm ban ma kon se gŭ pâl ta jŏng gung ƀon, geh aƀă tâm nter ndrăng păng: ‘Hên lĕ ôh n'hôm goh gŏr, tih ma khân ay may mâu pâl răm maak, Jêh ri hên lĕ nđor ntŏng dŏng khât, tih ma khân ay may mâu ŭch nhŭm pâl đŏng’. ");
INSERT INTO cmo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Lah ndri Yôhan-Ƀaptem, ndrel ma Gâp jêng tâm ban ma phung kon se i nây, Yôhan-Ƀaptem ăt sông, mâu ôh nhêt ndrănh, tih ma khân ay may lah păng bunuyh brah djơh lăp.” ");
INSERT INTO cmo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","“Lŏng Gâp dja i Kon Bunuyh tă bơh Kôranh Brah geh nhêt geh sông, mâu ăt sông sa, khân ay may lah Gâp: ‘Bunuyh hay nhêt hay sông, jan mât jăng ndrel bunuyh sŏ prăk ƀon lan, jêh ri gŭ ndrel bunuyh tih a êng jât’. ");
INSERT INTO cmo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yơn lah bunuyh i tâng nau Kôranh Brah, nhhơ nau Kôranh Brah i nây jêng di ueh ngăn ta nau rêh păng.” ");
INSERT INTO cmo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Geh du nar geh du huê bunuyh ta phung Pharisi rnha păng Simôn, jă Brah Yêsu hăn sông sa ta jay păng nơm, jêh ri Brah Yêsu hăn gŭ sông sa ndrel ta jay păng nây. Nôk nây tâng ma nau vay phung ndrŏng khân păng sông sa gŭ bêch nkêng jât chiao, i jŏng rok jât kơi. ");
INSERT INTO cmo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ta ƀon nây đŏng geh du huê bu ur văng târ. Tât păng tăng geh Brah Yêsu gŭ sông sa ta jay Pharisi i nây, păng sŏ đop jê̆ bu jan ma lŭ, ta đop ri geh dak ngi ƀô kah khlay đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jêh ri păng hăn ta jay Simôn gŭ bơh kơi Brah Yêsu ri, păng nhŭm hor dak măt ta jŏng Brah Yêsu, yor ma păng rngot ma nau tih păng nơm, jêh ri sŏ sŏk păng nơm ri jut jŏng Brah Yêsu, jêh ri chŭm ta jŏng ri, jêh chŭm ri păng sŏ dak ngi ƀô kah tŏ ta jŏng Brah Yêsu ri jât. ");
INSERT INTO cmo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bunuyh i tơm jă Brah Yêsu sông ri nơh, păng say kơt nây, jêh ri mân êng ta săk ri: “Lah Păng jêng bunuyh ntơyh nau ngơi Kôranh Brah ngăn, Păng gĭt ro bu ur i pah Păng nây jêng bu ur tih.” ");
INSERT INTO cmo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jêh ri Brah Yêsu lah ma Simôn: “Hơi nô, Gâp ŭch nkoch bri ma may.” Păng ơh: “Ơ mâu chrao kôranh, neh May nkoch hŏm.” ");
INSERT INTO cmo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Brah Yêsu lah du nau ngơi ntât: “Geh bar hê bunuyh manh prăk bu, du huê manh 500 prăk kăk, du huê manh 50 prăk kăk. ");
INSERT INTO cmo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yor ma bar hê khân păng i nây mâu geh prăk tŏm, ndri dâng bunuyh i tơm ăn manh prăk nây mâu hôm đă tŏm. Lah ndri lĕ bar hê i nây, bu moh rŏng hô rlau ma tơm ăn manh prăk nây?” ");
INSERT INTO cmo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Păng ơh: “Gâp gĭt lah bunuyh i manh ŏk.” Brah Yêsu lah: “Di ngăn.” ");
INSERT INTO cmo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jêh ri Brah Yêsu uănh jât bu ur i nây, lah ma Simôn: “May say bu ur dja jan ƀah? Gâp lăp ta jay may, tâng ma nau vay bân di ma may sŏ dak Gâp be ma rao jŏng, tih ma may mâu ôh sŏ, lŏng păng, păng nhŭm hor dak măt ta jŏng Gâp bĕ lĕ phiao, jêh ri sŏ sŏk păng nơm jut jât. ");
INSERT INTO cmo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tâng ma nau vay bân may chŭm ta tâm bom Gâp, tih ma may mâu ôh chŭm, lŏng păng, chŭm jŏng Gâp mâu rlu, ntơm bơh Gâp truyh ta dja nơh ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tâng ma nau vay bân di ma may tŏ dak ngi ta bôk Gâp, tih ma may mâu ôh tŏ, lŏng păng, tŏ dak ngi ƀô kah jut ta jŏng Gâp. ");
INSERT INTO cmo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kơt ndri Gâp mbơh ma may, bu ur dja ŏk ngăn nau tih păng, Gâp lĕ yô̆ nđach jêh dâng lĕ nau tih păng, mâu hôm ôh kơp nau tih păng, ndri dâng păng geh nau rŏng hô ngăn. Tih ma bu moh i geh yô̆ nđach đê̆, nau rŏng păng geh đê̆ đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jêh ri Brah Yêsu lah jât bu ur ri: “Nau tih ay lĕ Gâp yô̆ jêh, Gâp mâu hôm ôh kơp nau tih.” ");
INSERT INTO cmo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lĕ bunuyh i gŭ ndrel ta nây mân êng ta săk ri: “Bu moh Păng i nây hiah, dâng bănh lah yô̆ nđach nau tih đŏng? Geh Kôranh Brah dơm dơi yô̆ nau tih.” ");
INSERT INTO cmo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jêh ri Brah Yêsu lah ma bu ur i nây: “Hơi oh, yor nau ay nsing ma Gâp, ay lĕ klaih jêh bơh nau Kôranh Brah tê̆ dôih, sât ăn ueh lăng đăp mpăn.” ");
INSERT INTO cmo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jêh ri Brah Yêsu, ndrel ma 12 kôranh oh mon Păng, hăn rŏ ƀon kuŏng ƀon jê̆ mbơh nkoch nau mhe mhan ueh i Kôranh Brah ŭch mât uănh bunuyh. ");
INSERT INTO cmo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Geh bu ur aƀă hăn ndrel đŏng, bu ur aƀă lĕ Brah Yêsu jan bah jêh nau ji, ndrel ma lĕ ntrŭt brah djơh ăn lôh, ta nây geh rnha Mari, tă bơh ƀon Mađala, bu ur i nây Brah Yêsu ntrŭt pơh brah djơh lôh bơh păng, ");
INSERT INTO cmo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","jêh ri bu ur rnha Yôănna, i ur Khusa bunuyh mât uănh mpôl jan kar ma Hêrôt-Ŏntipas i kôranh mât uănh bri Galilê, geh bu ur rnha Susan, ndrel ma bu ur aƀă êng ŏk đŏng, khân păng sŏ drăp ndơ khân păng nơm gay ma kơl Brah Yêsu, ndrel ma mpôl oh mon păng. ");
INSERT INTO cmo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Geh ŏk bunuyh tă bơh ƀon êng êng, hăn văch ta Brah Yêsu ri, jêh ri Păng ngơi nau ntât kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Geh du huê bu klô hăn sui găr ntil. Nôk păng sui nây aƀă tŭp rŏ trong, geh bunuyh jot, jêh ri siŭm chok lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Găr aƀă tŭp ta neh klêr, hon pru, jêh ri ndro lĕ rngôch, yorlah reh mâu jru mâu geh dak. ");
INSERT INTO cmo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Găr aƀă tŭp ta neh lok, lok hon ndrel, jêh ri lok tŏl lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Geh găr aƀă jât tŭp ta neh ueh, hon tât play, du găr jêng geh 100 rnglay ro.” Jêh Brah Yêsu ngơi nau nây, păng kuăl: “Bu moh tăng nau Gâp ngơi dja, ăn Păng mân êng ta săk!” ");
INSERT INTO cmo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jêh ri mpôl oh mon ôp Brah Yêsu: “Lah ndri moh nau khlay ta nau ngơi ntât i nây?” ");
INSERT INTO cmo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Păng ơh: “Kôranh Brah lĕ ăn jêh nau khlay nau i nây ma khân may gĭt vât, mpơl nau ndŏp a lor nơh, i nây jêng nau khlay Kôranh Brah mât uănh bunuyh. Lŏng bunuyh aƀă jât, Gâp ngơi ntât ăn ma khân păng. Kơt ndri bol lah ‘Khân păng uănh ndơ Gâp jan kŏ mâu vât ndơ khlay nau i nây, Khân păng tăng nau Gâp ngơi kŏ mâu vât đŏng’. ");
INSERT INTO cmo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Dja Gâp rblang nau ntât: Găr nơh jêng nau Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bunuyh aƀă tâm ban ma găr tŭp ta trong, tăng đŏng nau Kôranh Brah, tih ma Satăng i kôranh mpôl brah djơh pit lơi nau Kôranh Brah bơh nuih n'hâm khân păng, gay lơi ăn iăt, jêh ri lơi geh nau rklaih. ");
INSERT INTO cmo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bunuyh aƀă jât tâm ban ma găr tŭp ta neh klêr, tât tăng nau Kôranh Brah, khân păng iăt răm maak ngăn, tih ma khân păng iăt du ndŏm dơm, mâu ôh ăn nau Kôranh Brah i nây hon reh jru ta nuih n'hâm khân păng, lah geh nau jêr nau ndơm, khân păng ntlơi nau nsing ro. ");
INSERT INTO cmo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Găr tŭp ta neh lok, tâm ban ma bunuyh iăt nau Kôranh Brah, tih ma ta trôm nuih n'hâm ri rvê kơnh ma drăp ndơ hô ngăn gĭt ma nau maak dơm, nuih n'hâm ŭch ma geh, bunuyh kơt nây tâm ban ma lok ƀăr mâu ăn khân păng play truyh dŭm. ");
INSERT INTO cmo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lŏng găr i tŭp ta neh ueh ri, tâm ban ma bunuyh iăt nau Kôranh Brah, geh nuih n'hâm ueh, ndjôt nâp ta nuih n'hâm păng nơm nau i nây, n'ho ma tât geh play ŏk ngăn, yor ma nuih n'hâm nsrôyh.” ");
INSERT INTO cmo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Brah Yêsu lah jât: “Mâu geh ôh bunuyh mpêh ŭnh sagêng, jêh ri sŏ thŭng kŭp bơh lơ, mâu lah tê̆ ta nâm gre. Bu vay yông prêh, gay ma ang lĕ bunuyh i lăp ta trôm jay nây. ");
INSERT INTO cmo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dâng lĕ ndơ mpôn mo ma bu, Kôranh Brah ŭch bu gĭt n'hêl, jêh ri dâng lĕ ndơ ndŏp Păng ŭch bu say kloh rah vah ta ang. ");
INSERT INTO cmo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Lah ndri njrăng ngăn hŏm nau i khân may lĕ tăng, yorlah bu moh i lĕ geh, Kôranh Brah kơi ntop ăn ma păng jât, tih ma bu moh i mâu geh, Kôranh Brah sŏ rhuăt lơi lĕ ndơ i păng gĭt lah lĕ geh”. ");
INSERT INTO cmo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jêh ri i mê̆ Brah Yêsu, ndrel ma i oh bu klô Păng, hăn ta ƀon nây gay ma mâp Păng, tât ta nây mâu geh ôh trong lăp, yorlah bunuyh ŏk ir. ");
INSERT INTO cmo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jêh ri geh bu mbơh ma Brah Yêsu: “Mê̆ May, ndrel ma oh May gŭ bơh dih ri ŭch mâp May.” ");
INSERT INTO cmo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Brah Yêsu ơh: “Bu moh i gŭ iăt nau ngơi Kôranh Brah, jêh ri tâng jan, bunuyh i nây jêng mê̆, jêng oh nô Gâp.” ");
INSERT INTO cmo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Geh du nar Brah Yêsu jă mpôl oh mon Păng: “Hô̆, bân hăn jât kăl ti dak ti.” Jêh ri khân păng ncho duk hăn jât kăl ti dak nglao kuŏng Galilê ri. ");
INSERT INTO cmo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dôl khân păng ncho ri, Brah Yêsu hăk bêch, jêh ri dô ma geh phŭt chuănh dŭt hô rŏ dak nglao kuŏng ri, duk khân păng dak lăp bơi ma ngŏm, lĕ khân păng ta kalơ duk ri bơi ma khât ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jêh ri khân păng rlay Brah Yêsu: “Hơi Kôranh! Hơi Kôranh! Khât ro bân mê.” Brah Yêsu kah rngăl, văl phŭt chuănh, ndrel ma dak rbuh. Jêh ri phŭt chuănh, ndrel ma dak rbuh bah ro, dak rngŏn kơt ơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Brah Yêsu rngot, jêh ri lah mpôl oh mon Păng: “Ah ăn nau nsing khân may?” Mpôl oh mon klach nsŏr ngăn, ndrŏt hih rhŏl đŏng. Mpôl oh mon tâm lah ndrăng khân păng nơm: “Mơm dâng geh nau dơi kơt nây, dơi đă phŭt, đă dak, jêh ri phŭt ndrel dak iăt nau Păng bah phiao đŏng?” ");
INSERT INTO cmo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Brah Yêsu, ndrel oh mon Păng tât kăl ti dak nglao kuŏng Galilê, dăch ntŭk ƀon rnha Garasin ri, ntŭk ƀon i nây bu mâu ôh tâng nau vay phung Israel. ");
INSERT INTO cmo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nôk Brah Yêsu hao a kơh ti, geh du huê bu klô tă bơh ƀon nây ran jât Păng dja. Bunuyh i nây brah djơh lăp gŭ ta păng, ăn păng gŭ lahôk, mâu geh ôh gŭ ta jay, gŭ ta ntŭk môch dơm lĕ jŏ năm hơi. ");
INSERT INTO cmo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Geh ŏk tơ̆ brah djơh nhŭp păng, bol lah bu kât jŏng kât ti păng ma rse rvăk ăn gŭ du ntŭk hŏ, păng nklah lơi rse rvăk lĕ phiao, jêh ri brah djơh leo păng gŭ êng ta bri rdah ngai bơh bunuyh. Tât say Brah Yêsu ri, păng păn ta jŏng Brah Yêsu nây, jêh ri Brah Yêsu ntrŭt brah djơh đă păng lôh bơh bu klô i nây, yơn ma brah djơh ê hŏ lôh ôh, păng nter dŭt nteh nteh ngăn: “Hơi Brah Yêsu, Kon Kôranh Brah i dŭt prêh ta kalơ trôk, mơm May jan ma gâp mêh? Khât ôm lôm lă, lơi dâng nkrit gâp.” ");
INSERT INTO cmo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jêh ri Brah Yêsu ôp păng: “Mơm rnha may mêh?” Păng ơh: “Gâp rnha mpôl tahen ŏk rbăn.” Păng ơh kơt nây yorlah brah djơh ŏk ngăn gŭ ta săk păng ri. ");
INSERT INTO cmo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mpôl brah djơh i nây bonh Brah Yêsu, lơi ôh nklăch khân păng ta ntu brŏng i ntŭk tê̆ dôih ma brah djơh. ");
INSERT INTO cmo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Geh sŭr phung gŭ sa mpa rŏ yôk dăch ma ntŭk nây. Mpôl brah djơh i ri bonh Brah Yêsu ăn lăp gŭ ta sŭr i nây, jêh ri Brah Yêsu ăn păng lăp ta sŭr. ");
INSERT INTO cmo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jêh ri mpôl brah djơh i ri lôh bơh bunuyh i nây lăp gŭ ta sŭr ri lĕ rngŏt, jêh ri sŭr i nây nchuăt rbŭl jât sop rƀŏng jât dak nglao ri, lăp ta dak rmok khât lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jêh mpôl chiăp sŭr i nây say kơt nây, khân păng nchuăt mbơh ro ma bunuyh gŭ rŏ ƀon, rŏ mir. ");
INSERT INTO cmo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jêh ri bunuyh i tăng nau nây khân păng hăn uănh gay ma say n'hêl ndơ i nây. Tât ta Brah Yêsu khân păng klach dadê ngăn, say bu klô brah djơh lăp nơh gŭ ta năp Brah Yêsu ri, ndrel ma nsoh kho ao kah gĭt săk đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bunuyh i lĕ say ma măt nau nây, khân păng đơn nkoch ăn ma bu êng mơm ƀă Brah Yêsu jan bah ma bunuyh brah djơh lăp nây. ");
INSERT INTO cmo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lĕ bunuyh gŭ rŏ bri dăch ma ƀon Garasin klach nsŏr hô ngăn, khân păng bonh Brah Yêsu đă Păng du lôh bơh ntŭk nây, ndri dâng Brah Yêsu ncho duk sât, ndrel ma mpôl oh mon Păng. ");
INSERT INTO cmo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lŏng bunuyh i lĕ brah djơh lôh nây nơh, păng bonh dăn gŭ ndrel Brah Yêsu, tih ma Brah Yêsu mâu rom ôh, jêh ri lah ma păng: ");
INSERT INTO cmo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“May sât jât jay may nơm ri, mbơh lĕ nau Kôranh Brah jan ueh ma may nơh.” Jêh ri păng hăn lam ƀon kuŏng, mbơh lĕ nau Brah Yêsu jan ma săk păng nơm nơh ro. ");
INSERT INTO cmo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tât Brah Yêsu plơ̆ sât ta ri, ƀon lan rom Păng, bu ran chuă Păng, yorlah lĕ bu nơh uănh măt tơm trong dadê. ");
INSERT INTO cmo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ta nây geh du huê bu klô, păng rnha Jairus, păng kôranh nhih rƀŭn phung Israel ta nây, păng ran păn ta jŏng Brah Yêsu ri, bonh jă Brah Yêsu hăn a jay păng, ");
INSERT INTO cmo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","yorlah kon bu ur păng ji bơi khât. Păng geh du huê kon i nây dơm, klăp lah 12 năm. Jêh ri Brah Yêsu hăn jât jay păng, rŏ trong nây geh ŏk bunuyh tâm mpet ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ta mpôl nây geh đŏng du huê bu ur ji rih lĕ jŏ 12 năm hơi, păng huach lĕ drăp ndơ păng, gay ma ăn kôranh dak si, tih ma mâu geh ôh du huê bunuyh dơi jan bah păng. ");
INSERT INTO cmo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Păng i ri hăn bơh kơi Brah Yêsu, pah ta chiăng ao Brah Yêsu ri, jêh ri mham păng bah ndal ta nây ro mâu hôm ôh trôh. ");
INSERT INTO cmo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Brah Yêsu lah: “Bu moh pah Gâp?” Dâng lĕ bu ta nây, bu lah mâu pah ôh. Pêtrôs lah: “Hơi Kôranh, bunuyh jŭm May tâm mpet ngăn, dâng lĕ bu geh gŏ May dadê.” ");
INSERT INTO cmo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Brah Yêsu lah: “Geh du huê bunuyh pah Gâp ngăn ro, yorlah Gâp gĭt nau brah geh lôh tă bơh săk Gâp.” ");
INSERT INTO cmo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jêh ri bu ur i nây hăn ta năp Brah Yêsu ri nsŏr ngăn, păn ta jŏng Brah Yêsu ri, păng lĕ gĭt nau i nây pôn mâu ndŏp ôh. Păng nkoch ăn ma Brah Yêsu ta năp bu băl, moh yor dâng păng pah Brah Yêsu, mơm dâng păng bah ndal ro. ");
INSERT INTO cmo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Brah Yêsu lah ma păng: “Hơi oh, nau ay nsing jan bah ay hơi, sât ăn ueh lăng đăp mpăn yơ̆.” ");
INSERT INTO cmo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nôk Brah Yêsu hôm e ngơi nây, geh du huê bunuyh tă bơh jay Jairus ri mbơh ma Jairus i kôranh nhih rƀŭn: “Kon may lĕ khât mê, lơi hôm rkhuak Ôbăl.” ");
INSERT INTO cmo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tât Brah Yêsu tăng bu mbơh kơt nây, Păng lah ma Jairus: “Lơi dâng klach ôh, iăt ma may nsing ma Gâp, kon may rêh ro.” ");
INSERT INTO cmo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jêh ri Brah Yêsu hăn tât ta jay Jairus, Păng lăp ta trôm jay, bu aƀă êng mâu ôh ăn lăp, Păng ăn Pêtrôs, Yôhan, Yakơ, ndrel ma i mê̆ bơ̆ kon se i nây, du nây dơm ăn lăp. ");
INSERT INTO cmo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dâng lĕ bunuyh ta nây nhŭm vơl ma kon se i khât ri dadê, Brah Yêsu lah ma khân păng: “Lơi hôm nhŭm, păng mâu ôh khât, păng hăk bêch dơm.” ");
INSERT INTO cmo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mpôl i nây gơm mưch ma Brah Yêsu, yorlah khân păng lĕ gĭt jêh kon se i nây lĕ khât ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jêh ri Brah Yêsu nhŭp ti kon se i nây, lah ma păng: “Hơi oh, ay dâk hŏm!” ");
INSERT INTO cmo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nôk nây ro huêng păng plơ̆ sât ta păng nơm, jêh ri dâk rêh ro. Brah Yêsu đă bu sŏ ndơ ăn ma păng sa. ");
INSERT INTO cmo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mê̆ bơ̆ kon se i nây ndrŏt hih rhŏl ngăn mâu vât ôh, yơn ma Brah Yêsu buay mâu ôh ăn khân păng nkoch nau i nây ma bu êng gĭt. ");
INSERT INTO cmo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Geh du nar ri Brah Yêsu kuăl i 12 oh mon, jêh ri ăn nau dơi ma khân păng, dơi ntrŭt brah djơh, ndrel ma dơi jan bah bunuyh geh nau ji êng êng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Păng đă khân păng hăn mbơh ăn bu gĭt nau Kôranh Brah ŭch mât uănh bunuyh, ndrel ma jan bah nau ji kuet bu ăn bah đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Brah Yêsu lah ma khân păng: “Dôl khân may brô̆ ƀon êng êng, mâu ăn ôh leo ndjôt ndơ ta săk, bol lah mŏng jra, dŭng cheng, ndơ sa, prăk kayh, mâu lah kho ao. ");
INSERT INTO cmo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Moh jay khân may lăp, gŭ ta jay i nây hŏ, n'ho ma tât khân may lôh bơh ƀon i nây. ");
INSERT INTO cmo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Lah ƀon i nây mâu ôh rom khân may, ăn lôh bơh ntŭk nây hŏm, jêh ri rtôh neh môi bơh jŏng khân may nơm, gay ma nhhơ lah ƀon i nây Kôranh Brah tê̆ dôih.” ");
INSERT INTO cmo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jêh ri mpôl oh mon nây hăn mbơh nkoch nau mhe mhan ueh ŏk ƀon, ndrel ma jan bah bunuyh ji ăp ntŭk đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tât Hêrôt-Ŏntipas i kôranh mât uănh bri Galilê nây tăng lư dâng lĕ nau Brah Yêsu jan ri, păng iăt mâu gĭt, lĭch mâu gĭt, yorlah geh bunuyh aƀă nkoch lah: “Yôhan-Ƀaptem lĕ dâk rêh.” ");
INSERT INTO cmo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bu aƀă êng lah: “Bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, rnha păng Êliya, lĕ nhhơ săk ăn ma bu say.” Bu aƀă êng jât lah: “Geh du huê bunuyh ntơyh nau ngơi Kôranh Brah bơh kăl e nơh, lĕ dâk rêh jêh.” ");
INSERT INTO cmo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lŏng kađăch Hêrôt lah: “Lah Yôhan-Ƀaptem lĕ gâp koh tong ko păng jêh, lah ndri bu moh păng i jan nau i ri?” Jêh ri păng joi nau ŭch mâp Brah Yêsu đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jêh mpôl kôranh oh mon Păng sât tă bơh ntŭk êng êng, khân păng nkoch bri ăn ma Brah Yêsu dâng lĕ nau khân păng jan. Jêh ri Brah Yêsu jă êng khân păng hăn ta du ƀon, rnha ƀon Ƀêtsaida, ");
INSERT INTO cmo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","jêh ƀon lan lĕ gĭt, khân păng leo băl hăn tâng Brah Yêsu. Brah Yêsu rom khân păng i nây, jêh ri mbơh nkoch ăn khân păng iăt nau Kôranh Brah ŭch mât uănh bunuyh, ndrel ma jan ăn bah bunuyh geh nau ji kuet đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tât dêh nar 12 nuyh mpôl kôranh oh mon i nây hăn ta Brah Yêsu, lah ma Păng: “Hơi Kôranh, đă May mbơh ăn ƀon lan sât joi ntŭk bêch, joi ndơ sông sa rŏ jay rŏ ƀon dăch dăch oi ta dja, yorlah ta dja ntŭk rdah ngai bơh ƀon mâu geh ôh ndơ sa.” ");
INSERT INTO cmo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Brah Yêsu lah ma khân păng i nây: “Khân may ăn bu sông sa heh.” Mpôl kôranh oh mon ơh: “Hên geh prăm mlŏm nŭmpăng, ndrel ma bar mlŏm ka dơm, kôranh mê, ơm jêng tŏng lah? Lah ndri kơi rvăt mơ tŏng ma ăn khân păng i nây sa.” ");
INSERT INTO cmo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Khân păng ngơi ndri, yorlah ta ntŭk i nây klăp lah geh 5000 nuyh bu klô. Jêh ri Brah Yêsu lah ma oh mon: “Khân may đă bu gŭ du mpôl du mpôl ăn geh klăp lah 50 nuyh.” ");
INSERT INTO cmo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mpôl oh mon jan kơt nau Păng đă, jêh ri dâng lĕ bu gŭ dadê. ");
INSERT INTO cmo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jêh ri Brah Yêsu sŏ prăm mlŏm nŭmpăng, ndrel ma bar mlŏm ka ri, Păng n'gơr măt jât lơ trôk mbơh sơm ndơ sông sa i nây ma Kôranh Brah, lôch jêh Păng gĭch nŭmpăng i nây ndơ̆ ăn oh mon, đă khân păng pă ăn bu sa. ");
INSERT INTO cmo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jêh tâm pă ndơ sa i ri, dâng lĕ bunuyh gŭ sa ta nây hơm dadê, jêh ri rgum ndơ rmeh sa i nây hôm geh 12 sah. ");
INSERT INTO cmo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Geh du nar Brah Yêsu mbơh sơm êng, ta nây geh mpôl oh mon dơm gŭ ndrel Păng, phung ƀon lan mâu geh ôh. Brah Yêsu ôp mpôl oh mon i nây: “Lĕ phung ƀon lan lah Gâp bu moh?” ");
INSERT INTO cmo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mpôl oh mon ơh: “Aƀă lah May jêng Yôhan-Ƀaptem i lĕ dâk rêh, aƀă lah jêng Êliya i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ plơ̆ ta dja, aƀă jât lah May jêng du huê bunuyh i êng i ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ dâk rêh.” ");
INSERT INTO cmo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Brah Yêsu ôp jât: “Lah ndri khân may eh, Gâp bu moh khân may lah mêh?” Pêtrôs ơh: “May Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl.” ");
INSERT INTO cmo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Brah Yêsu buay, mâu ăn ôh khân păng nkoch nau nây ma bu. ");
INSERT INTO cmo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Păng lah: “Nar jât năp tay, bol lah Gâp i Kon Bunuyh tă bơh Kôranh Brah, Gâp mra geh nau jêr jŏt dŭt hô. Mpôl bu ranh, mpôl kôranh jan brah, phung nơm nti, mƀăr lơi Gâp, n'ho ma nkhât lơi. Yơn ma tât pe nar bơh kơi nây Gâp dâk rêh.” ");
INSERT INTO cmo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jêh ri Brah Yêsu lah ma dâng lĕ bunuyh: “Bu moh păng i ŭch tâng Gâp, ăn mƀăr lơi ndơ săk păng nơm ŭch, jêh ri tui si tâm rkăng păng nơm ăn ăp nar, jêng geh nau khlay iăt dâng lĕ nau Kôranh Brah đă, bol lah tât khât săk kađôi, ri mơ dơi tâng Gâp ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yorlah bu moh i ŭch prăp ma nau rêh păng nơm, păng i nây mâu geh ôh nau rêh n'ho ro, yơn ma bu moh khât yor ma tâng Gâp, păng i nây geh nau rêh n'ho ro ngăn ta nar jât năp tay. ");
INSERT INTO cmo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lah du huê bunuyh păng geh dâng lĕ neh ntu dja jêng drăp ndơ păng nơm dadê, tih ma săk păng nơm khât roh hêng mâu geh ôh nau rêh n'ho ro, lah ndri moh ndơ geh nau khlay ma păng? ");
INSERT INTO cmo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Lah bu moh i đit prêng mâu bănh mbơh tâng Gâp, đit prêng nau Gâp nti, lah ndri Gâp i Kon Bunuyh tă bơh Kôranh Brah đit prêng mâu gĭt năl ma păng i nây đŏng, ta nar Gâp plơ̆ văch geh nau ueh chrêk lơp Gâp nơm, geh nđâp ma nau ueh chrêk lơp Bơ̆ Gâp, ndrel ma nau ueh chrêk lơp phung tông păr kloh ueh. ");
INSERT INTO cmo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Gâp mbơh ăn ma khân ay may gĭt n'hêl nanê̆ ngăn, geh bunuyh aƀă ta dja păng mâu mra khât ôh, lor ma say Kôranh Brah mât uănh khân păng.” ");
INSERT INTO cmo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Klăp lah geh pham nar jêh Brah Yêsu ngơi nau i nây, jêh ri Păng leo Pêtrôs, leo Yôhan, ndrel ma Yakơ, hao kalơ yôk gay ma mbơh sơm. ");
INSERT INTO cmo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nôk Păng mbơh sơm, i muh măt Păng geh rgâl, ao Păng jêng nglang ang chrat ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Dô ma say đŏng geh bar hê bu klô ngơi ndrel Păng, Môsê, ndrel ma Êliya, khân păng i nây jêng bunuyh ntơyh nau ngơi Kôranh Brah bơh kăl e nơh. ");
INSERT INTO cmo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bar hê i nây geh nau ueh chrêk lơp ngăn ta khân păng, khân păng nkoch ma nau Brah Yêsu khât ta ƀon kuŏng Yêrusalem hôm đê̆ nar jât năp tay, khât tâng nau Kôranh Brah ŭch. ");
INSERT INTO cmo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lŏng Pêtrôs, ndrel ma bar hê băl păng nây hăk bêch dadê. Tât kah bêch ri khân păng say nau ueh nau chrêk lơp Brah Yêsu, ndrel ma say bar hê bunuyh gŭ ndrel Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tât ma Môsê, ndrel ma Êliya du lôh bơh Brah Yêsu ri, Pêtrôs ngơi ma Brah Yêsu: “Hơi Kôranh, bân gŭ ta dja ueh ngăn mê, ăn hên jan pe mlŏm chun, du mlŏm ăn ma May, du mlŏm ăn ma Môsê, du mlŏm jât ăn ma Êliya.” Nau Pêtrôs ngơi i nây păng nơm mâu ôh gĭt săk, păng dah ma ngơi dơm. ");
INSERT INTO cmo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nôk Pêtrôs hôm e ngơi nây, geh tŭk nkŭm bơh lơ khân păng ri, khân păng jêng lăp gŭ ta trôm tŭk jan ăn khân păng klach dadê ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jêh ri tăng nteh ngơi tă bơh tŭk nây: “Păng dja Kon Gâp, i Gâp lĕ kơih Păng, iăt nau Păng dô.” ");
INSERT INTO cmo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jêh tăng ngơi kơt nây say Brah Yêsu du huê êng dơm gŭ ta ri. Lĕ nau i say nây nơh, khân păng mâu ôh nkoch ăn ma bu êng gĭt, tât jŏ bơh năp mơ. ");
INSERT INTO cmo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tât ôi tay, Brah Yêsu, ndrel ma mpôl oh mon Păng jŭr bơh lơ yôk ri, ta nây geh ŏk bunuyh văch ran Păng. ");
INSERT INTO cmo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jêh ri geh du huê bu klô ta phung bunuyh ŏk i nây nter kuăl Brah Yêsu: “Hơi Nơm Nti! Dăn May yô̆ nđach ma kon gâp ơ, yorlah gâp geh du huê kon dja dơm mê. ");
INSERT INTO cmo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Geh brah djơh nguai lơh păng du tơ̆ du tơ̆, ăn păng nter mpŏt nslŏng nslăng ngăn, lôh mpŭnh dak diu ta mbung, săk jăn lôh bŭr lôh môr, tât ma păng lĕ huăr ngăn, ri mơ brah djơh i ri lôh du n'hâm mê. ");
INSERT INTO cmo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mpôl oh mon May lĕ gâp đă đŏng, khân păng ntrŭt mâu ôh dơi lôh.” ");
INSERT INTO cmo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Brah Yêsu lah ma dâng lĕ bunuyh: “Hơi bunuyh djơh, bunuyh mâu iăt! Dah hôm jŏ ăn Gâp nsrôyh gŭ ndrel khân ay may i bunuyh dăng ko? Leo hŏm kon may i nây a dja.” ");
INSERT INTO cmo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nôk kon păng brô̆ ê hŏ tât a Brah Yêsu, brah djơh nklơ̆ păng chôt nslŏng nslăng ro. Jêh ri Brah Yêsu mbram brah djơh ri, jan kon păng bah, leo păng ma bơ̆ păng nơm. ");
INSERT INTO cmo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lĕ bunuyh ta nây ndrŏt hih rhŏl dadê ngăn say nau dơi Kôranh Brah kơt nây. Dôl dâng lĕ khân păng ta nây hôm nklŏn êng ta săk ri dâng lĕ ndơ dơi i Brah Yêsu jan i nây, jêh ri Păng lah ma mpôl oh mon Păng: ");
INSERT INTO cmo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ăn khân ay may ndjôt iăt nau dja, nkah săk lơi chuêl ôh, bơi tât bu njŭn Gâp i Kon Bunuyh tă bơh Kôranh Brah ta ti bunuyh nhŭp.” ");
INSERT INTO cmo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jêh tăng nau Brah Yêsu ri nơh, mpôl oh mon mâu vât ôh nau Păng lah nây, yorlah Kôranh Brah ê hŏ ăn khân păng vât ôh, khân păng klach mâu bănh ôp đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Geh du nar mpôl oh mon gŭ tâm rlăch băl ma nau khân păng ŭch gĭt ma mpôl khân păng nơm, bu moh păng i kuŏng rlau bu. ");
INSERT INTO cmo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yơn ma Brah Yêsu lĕ gĭt nau khân păng mân nây, jêh ri Păng leo du huê kon se jê̆ gŭ dăch kêng Păng nơm. ");
INSERT INTO cmo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jêh ri Păng lah: “Bu moh rom du huê kon se jê̆ yor ma ŭch iăt nau Gâp, tâm ban ma rom Gâp nơm đŏng. Jêh ri bu moh păng i rom Gâp tâm ban ma rom Bơ̆ Gâp i tơm njuăl Gâp nơh đŏng. Bu moh păng i jê̆ ta nâm bu dâng lĕ ta mpôl khân ay may, păng i nây jêng kuŏng rlau bu.” ");
INSERT INTO cmo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jêh ri Yôhan mbơh ma Brah Yêsu: “Hơi Nơm Nti, hên say du huê bunuyh ntrŭt brah djơh ma moh rnha May. Jêh ri hên buay păng, yorlah păng mâu geh ôh mpôl bân.” ");
INSERT INTO cmo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Brah Yêsu lah ma păng: “Lơi buay păng ôh, bu moh păng i mâu tâm rdâng đah khân ay may, bunuyh i nây jêng mpôl băl mpeh ma khân ay may.” ");
INSERT INTO cmo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tât bơi di nar Brah Yêsu hao sât ta ntŭk Kôranh Brah ta kalơ, Păng nsrôyh hăn jât ƀon Yêrusalem. ");
INSERT INTO cmo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jêh ri Brah Yêsu hăn jât du ƀon ta bri Samari, Păng đă bunuyh aƀă hăn lor gay ma ndrăp ntŭk vơt dơn Păng. ");
INSERT INTO cmo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tih ma ta ƀon i nây bu mâu ôh rom Brah Yêsu gŭ ta ri, yorlah khân păng gĭt jêh Brah Yêsu ŭch hăn n'hot jât ƀon kuŏng Yêrusalem. ");
INSERT INTO cmo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tât khân păng say kơt nây, bar hê oh mon, Yakơ, ndrel ma Yôhan, khân păng lah: “Hơi Kôranh, May ŭch bơh, ăn hên kuăl ŭnh tă kalơ trôk tŭp ta ƀon dja, su lơi phung i nây, jan kơt Êliya păng jan kăl e nơh?” ");
INSERT INTO cmo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Brah Yêsu uănh jât khân păng n'ho ma r'ŏt khân păng: “Khân may mâu gĭt moh huêng gŭ ta trôm săk khân may, ");
INSERT INTO cmo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","yorlah Gâp i Kon Bunuyh, tă bơh Kôranh Brah văch, gay ma rklaih bunuyh, mâu ŭch ôh lơh hêng bunuyh.” Jêh ri leo băl n'hot jât ƀon êng jât. ");
INSERT INTO cmo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dôl Brah Yêsu brô̆ rŏ trong ri, geh du huê bu klô lah ma Păng: “Hơi Kôranh, ah ntŭk May hăn? Gâp hăn tâng May đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Brah Yêsu lah ma păng: “Lŏng srot geh trôm ntŭk păng gŭ, siŭm nar geh rsuăn đŏng, tih ma Gâp i Kon Bunuyh tă bơh Kôranh Brah mâu geh ôh ntŭk Gâp nơm ngăn ma dŏm bôk.” ");
INSERT INTO cmo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jêh ri Brah Yêsu lah ma du huê bunuyh êng jât: “Hô̆, hăn tâng Gâp!” Bunuyh i nây ơh: “Hơi Kôranh, ăn gâp kŏp bơ̆ gâp khât, ndrel ma tŏp păng ƀŏt.” ");
INSERT INTO cmo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Brah Yêsu lah ma păng: “Bunuyh mâu iăt nau Gâp tâm ban ma bunuyh lĕ khât, ăn khân păng tâm tŏp êng ndrăng khân păng nơm, may ma hăn mbơh nau Kôranh Brah ŭch mât uănh bunuyh.” ");
INSERT INTO cmo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Geh du huê bunuyh jât lah ma Păng đŏng: “Hơi Kôranh, gâp ŭch tâng May đŏng, yơn ma ăn gâp hăn ntĭnh rnăk vâl gâp ƀŏt.” ");
INSERT INTO cmo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Brah Yêsu lah ma păng: “Bu moh i kuăn n'gŏl chuŏr, jêh ri n'gâl jât kơi, bunuyh i nây mâu ôh ăn Kôranh Brah mât uănh ma păng.” ");
INSERT INTO cmo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jêh bơh kơi nây, Brah Yêsu kơih đŏng oh mon 72 nuyh jât, jêh ri đă khân păng hăn lor, hăn bar hê bar hê, ăp ƀon, ăp ntŭk i Brah Yêsu ŭch ndrăp hăn. ");
INSERT INTO cmo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Brah Yêsu lah ma khân păng: “Hơi oh mon, geh ŏk bunuyh ŭch iăt nau mhe mhan ueh, khân păng tâm ban ma ba lĕ dŭm i ŏk ngăn, bunuyh mbơh nkoch nau mhe mhan ueh tâm ban ma bunuyh rek, tih ma bunuyh i nây đê̆ dơm. Lah ndri dăn Kôranh Brah nơm i tơm ba nây njuăl bunuyh a êng jât, kơl rek ba dŭm i nây. ");
INSERT INTO cmo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ăn khân may hăn hŏm, Gâp đă khân may hăn tâm ban ma ăn kon be biăp gŭ ta nklang phung so bri. ");
INSERT INTO cmo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gâp đă khân may hăn săk dơm, lơi ndjôt prăk, lơi cheng dŭng, lơi ndjôt ntô jot, lah mâp bu rŏ trong lơi nkoch bri jŏ đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Moh jay i khân may lăp ri, ăn khân may lah kơt nđa lor: ‘Dăn Kôranh Brah ăn nau ueh lăng đăp mpăn ma bunuyh gŭ ta jay dja’. ");
INSERT INTO cmo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Lah bunuyh ta jay i nây rom khân may ŭch nau đăp mpăn, nau đăp mpăn i khân may dăn nơh gŭ ta jay păng nây ro. Lah păng mâu ŭch, nau đăp mpăn i nây mâu hôm ôh gŭ ta jay păng nây. ");
INSERT INTO cmo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jêh ri gŭ ta jay păng i nây hŏ, lơi ôh ntrơn jay êng. Nhêt sông lĕ ndơ i bu ăn ma khân may, yorlah ndơ i nây jêng ndơ bu nkhôm ma khân may, bunuyh ntŭm nti bu tâm ban ma geh jan kar ma bu đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Moh ƀon i khân may hăn nây, lah geh bu rom, lĕ ndơ i bu ăn sa, khân may sa ro, ");
INSERT INTO cmo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","n'ho ma jan bah nau ji bu. Jêh ri mbơh nkoch ma ƀon nây: ‘Nau Kôranh Brah mât uănh khân ay may lĕ dăch ma khân ay may ngăn ro’. ");
INSERT INTO cmo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lah bu mâu ôh rom, ƀon i khân may lăp ri, lôh hŏm bơh ntŭk nây, hăn rŏ ƀon khân may lah kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Bol lah geh neh môi ntŭk ƀon khân ay may krêp ta jŏng hên, hên rtôh lơi ma khân ay may nơm đŏng, yơn ma ăn khân ay may gĭt nau dja, nau Kôranh Brah mât uănh khân ay may lĕ dăch ngăn ro’. ");
INSERT INTO cmo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Khân may gŭ iăt nau Gâp ƀŏt, bunuyh ta ƀon Sôđŭm i jan tih dŭt hô kăl e nơh, ndri Kôranh Brah de lơh hêng khân păng ma ŭnh bơh kalơ trôk, khân păng i nây hôm e geh dôih thơl ma đah bunuyh ta ƀon i nây, ta nar Kôranh Brah phat dôih lam neh ntu.” ");
INSERT INTO cmo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jêh ri Brah Yêsu lah jât: “Rêh rnhăl ngăn ma bunuyh gŭ ta ƀon Khôrasin, ndrel ma ƀon Ƀêtsaida, yorlah khân păng lĕ say dâng lĕ ndơ ueh ndơ khlay Gâp jan, tih ma mâu ôh rgâl lơi nuih n'hâm djơh. Bunuyh ta ƀon Tirus, ndrel ma ta ƀon Siđôn jêng phung mâu gĭt năl Kôranh Brah, lah khân păng say nau khlay i nây, khân păng rgâl lơi nuih n'hâm djơh ro, jêh ri gay ma nhhơ nau khân păng lĕ rgâl lơi nuih n'hâm djơh, khân păng nsoh n'gut ƀao chiăt, gŭ ta ŭnh buh. ");
INSERT INTO cmo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ndri ta nar Kôranh Brah phat dôih lam neh ntu tay, bunuyh ta ƀon kuŏng Tirus, ndrel ma ta ƀon kuŏng Siđôn, khân păng geh dôih thơl ta nâm bunuyh gŭ ta ƀon Khôrasin, ƀon Ƀêtsaida. ");
INSERT INTO cmo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bunuyh gŭ ta ƀon Kapơnŭm i ƀon Gâp gŭ jŏ khay, ndrel ma Gâp lĕ nti lĕ jan ndơ nau khlay Lơi ôh nđôn lah săk khân ay may nơm lĕ jêng bunuyh ueh hao ta ƀon ueh kalơ, Mâu ôh, khân ay may tay tŭp ta ntŭk rêh rnhăl ta ndrung ŭnh ri ro.” ");
INSERT INTO cmo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jêh ri Brah Yêsu lah ma mpôl oh mon Păng đŏng: “Bu moh păng i iăt nau khân may, tâm ban ma iăt nau Gâp đŏng. Bu moh i mâu iăt ôh nau khân may, tâm ban ma mâu iăt nau Gâp đŏng, bu moh mâu iăt nau Gâp, tâm ban ma mâu iăt đŏng nau Kôranh Brah nơm i njuăl đă Gâp hăn ta dja nơh.” ");
INSERT INTO cmo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jêh ri mpôl oh mon i 72 nuyh nây plơ̆ sât bơh ri răm rhơn, khân păng nkoch nau ma Brah Yêsu: “Hơi Kôranh, yor ma moh rnha săk May, bol lah brah djơh iăt nau hên đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Brah Yêsu lah ma khân păng: “Gâp lĕ say Satăng i kôranh mpôl brah djơh tŭp tă bơh kalơ trôk tâm ban ma lơp nglayh ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Dja Gâp lĕ ăn nau dơi ma khân may, khân may dơi đah ma Satăng i kôranh mpôl brah djơh, ndrel ma lĕ mpôl djơh păng đŏng, dơi brô̆ jot bêh, ndrel ma ndơr ving, mâu geh ôh du ntil ndơ jan djơh ăn ma khân may. ");
INSERT INTO cmo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lơi ta răm ôh yor ma say brah djơh iăt nau khân may nây dơm, yơn ma ăn khân may răm maak Kôranh Brah lĕ geh nchih săk khân may ta kalơ trôk ntŭk Păng nơm gŭ ri hŏ, ndri nar jât năp tay khân may gŭ ndrel Kôranh Brah n'ho ro.” ");
INSERT INTO cmo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nôk nây Brah Huêng Ueh i kloh ueh jan ăn Brah Yêsu geh nuih n'hâm răm maak ngăn, Brah Yêsu lah kơt nđa: “Hơi Bơ̆, i Kôranh ma trôk, ndrel ma neh ntu, Gâp rnê May hô ngăn, yorlah May lĕ nhhơ nau May ntơm mât uănh bunuyh dja ăn ma bunuyh rluk mâl mâu vât tâm ban ma kon se, jêh ri pôn ndŏp lơi ndơ i nây ma bunuyh i kơp êng săk khân păng nơm jêng bunuyh gĭt bunuyh blao. Hơi Bơ̆, nuih n'hâm May ŭch kơt nđa ro.” ");
INSERT INTO cmo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jêh ri Păng lah jât: “Dâng lĕ ntil ndơ, lĕ Bơ̆ jao ma Gâp dadê jêh. Mâu geh ôh bunuyh gĭt năl Gâp lah i Kon Kôranh Brah, geh Bơ̆ Gâp nơm dơm gĭt năl, mâu geh ôh bunuyh gĭt năl Bơ̆ ngăn Gâp, geh Gâp i Kon Păng dơm gĭt năl, ndrel ma dâng lĕ bunuyh i Gâp ŭch ăn gĭt năl, du ri dơm.” ");
INSERT INTO cmo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nôk mâu geh ôh bunuyh a êng gŭ ta ri, Brah Yêsu ngơi đah mpôl oh mon dơm, Păng lah: “Ueh maak ngăn ma khân ay may, yorlah măt khân ay may say dâng lĕ nau Gâp lĕ jan. ");
INSERT INTO cmo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Gâp mbơh ma khân ay may, geh ŏk bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, ndrel ma ŏk kađăch phung Israel kăl e nơh ŭch say ngăn dâng lĕ nau i khân ay may lĕ say aƀaơ dja, tih ma mâu say ôh, khân păng ŭch tăng ngăn nau i khân ay may lĕ tăng dja, tih ma mâu tăng đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nôk nây geh du huê nơm nti nau vay phung Israel, păng dâk ŭch ôp rlong Brah Yêsu: “Hơi Nơm Nti, mơm ăn gâp jan gay ma geh nau rêh n'ho ro mêh?” ");
INSERT INTO cmo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Brah Yêsu ơh ma păng: “Moh ƀă geh nau Môsê nchih ta samƀŭt Nau Vay kăl e nây nơh? Dôl may uănh, moh ƀă may vât?” ");
INSERT INTO cmo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bunuyh i nây ơh ma Brah Yêsu: “‘Ăn rŏng ma Kôranh Brah i brah khân ay may nơm ma lĕ nuih n'hâm, ma lĕ huêng, ma lĕ n'hâm suan, ndrel ma lĕ nau mân’, jêh ri ‘Rŏng ma bu chiao meng kơt rŏng ma săk may nơm đŏng’.” ");
INSERT INTO cmo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Brah Yêsu lah ma păng: “Nau may ơh i nây jêng di ngăn, ăn may jan kơt nau nây ƀaƀơ, ndri mơ nar jât năp tay may mra geh nau rêh n'ho ro.” ");
INSERT INTO cmo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yơn ma bunuyh i nây ŭch nhhơ nau ôp păng nơm jêng nau ôp di, mâu ôh ôp rlong dơm, jêh ri ôp Brah Yêsu jât: “Lah ndri bu moh jêng bu chiao meng gâp mêh?” ");
INSERT INTO cmo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Brah Yêsu ơh ma păng ma nau ngơi ntât: “Geh du huê bu klô lôh bơh ƀon kuŏng Yêrusalem, hăn jât ƀon Yêrikhô ri. Rŏ trong nây păng mâp ma mpôl ntŭng, bu lơh păng tât khât yơh, sŏ lĕ drăp ndơ sŏ kho ao păng đŏng, jêh ri leo băl nchuăt lĕ rngăt, ntlơi êng ôbăl ta ri. ");
INSERT INTO cmo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jêh ri geh du huê ta mpôl jan brah hăn rŏ trong nây, mpôl i nây blao ngăn ta nau vay phung bân. Tât ma say bunuyh rmanh i nây, păng hăn der. ");
INSERT INTO cmo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jêh ri geh đŏng du huê mpôl Lêvi, mpôl i nây jêng nơm nti nau vay phung bân, păng hăn tât ta nây say bunuyh rmanh i nây, n'ho ma hăn der đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nkhêp ngăn geh du huê mpôl bri Samari hăn rŏ trong nây đŏng, jêng bunuyh i phung bân mưch rmot hô ngăn, mpôl păng mâu ôh blao ta nau vay phung bân. Tât ma say bunuyh rmanh i nây, hô ngăn păng geh nau yô̆ geh nau nđach ma bunuyh i nây. ");
INSERT INTO cmo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Păng hăn dăch jât bunuyh rmanh nây, păng sŏ dak ngi, sŏ ndrănh păng nơm bơh dja tŏ kalơ sôt bunuyh i nây, sơm put sôt păng ri, jêh ri pư tê̆ kalơ seh lia păng ncho ri, leo hăn ta jay veh bêch bu năch. Tât ta nây păng mât uănh bunuyh i nây jât. ");
INSERT INTO cmo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kah ôi tay păng ăn bar mlŏm prăk kăk ma tơm jay nây, nkre ma ntĭnh păng: ‘Đă may sơm mât săm bunuyh dja, lah lĕ dŏng rlau bơh prăk gâp ăn dja, tât gâp plơ̆ tay, gâp kơi ăn râng ma may’. ");
INSERT INTO cmo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Lah ndri lĕ pe nuyh khân păng i nây, bu moh may mân jêng bunuyh chiao meng đah ma bunuyh mpôl ntŭng nây lơh mêh?” ");
INSERT INTO cmo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nơm nti nây ơh: “Jêng bunuyh i geh nau yô̆ nđach ma păng i nây.” Brah Yêsu lah ma păng: “Ăn may hăn jan tâng kơt păng i du huê nây.” ");
INSERT INTO cmo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Jêh ri Brah Yêsu, ndrel ma oh mon Păng hăn jât, lăp ta du ƀon, ta ƀon nây geh bar hê oh nur rnha khân păng Matha, ndrel ma Mari, jêh ri Matha jă Brah Yêsu lăp gŭ ta jay păng. Tât ta jay nây Mari i oh ri gŭ iăt nau Brah Yêsu nti, păng gŭ kêng jŏng Brah Yêsu ri. ");
INSERT INTO cmo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lŏng Matha bŏp hô ngăn ma ndrăp piăng trao, jêh ri păng hăn mbơh ma Brah Yêsu: “Hơi Kôranh, May mâu gĭt bơh, oh gâp ƀŏng êng gâp jan kar du huê êng dơm? May mbơh đă păng kơl gâp ƀă heh.” ");
INSERT INTO cmo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Brah Yêsu ơh ma păng: “Ơ oh Matha, oh Matha ơi! Ay rngot rvê ma ndơ êng êng ŏk ngăn, ");
INSERT INTO cmo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","yơn ma geh du nau kar dơm geh nau khlay, oh ay lĕ kơih jêh kar nau khlay i nây, jêng păng iăt nau Gâp nti. Nau i nây bu mâu ôh blao sŏ bơh păng.” ");
INSERT INTO cmo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Geh du nar Brah Yêsu mbơh sơm ta du ntŭk. Jêh Păng mbơh sơm ri, geh du huê oh mon lah ma Păng: “Hơi Kôranh, đă May nti ăn hên blao mbơh sơm ƀă ơ, kơt Yôhan-Ƀaptem nti ma mpôl oh mon păng.” ");
INSERT INTO cmo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Brah Yêsu ơh ma khân păng: “Ăn khân ay may mbơh sơm kơt nđa: ‘Ơ Bơ̆ gŭ ta kalơ trôk, Ăn dâng lĕ bunuyh yơk mbah ma May dăn dâng lĕ nau ta neh ntu dja tâng nau May ŭch, tâm ban ma nau May nơm lĕ ŭch ta kalơ trôk đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ăn ndơ sông sa ma hên ăp nar ăn tŏng. ");
INSERT INTO cmo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yô̆ nđach lơi hôm kơp nau tih hên Tâm ban ma hên yô̆ nđach ma bunuyh jan tih ma hên, mâu hôm kơp nau tih păng đŏng. Kơl hên lơi ôh jan tih, nôk hên geh nau ndơm dăn rklaih hên bơh nau djơh mhĭk’.” ");
INSERT INTO cmo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jêh ri Brah Yêsu lah đŏng ma mpôl oh mon nây: “Ta mpôl khân ay may, lah geh du huê bunuyh brô̆ ta jay mât jăng n'gul phŭt n'gul măng, păng kuăl: ‘Hơi jăng, ăn gâp manh ndơ sông sa aƀă ƀŏt ơ, ");
INSERT INTO cmo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","yorlah gâp geh jăng mhe tât tă bơh ngai lah. Gâp mâu geh ndơ ma ăn păng sông sa mê’. ");
INSERT INTO cmo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Khân ay may lah, bunuyh ta trôm jay nây ơh ma păng kơt nđa ƀah?: ‘Lơi hôm rkhuak gâp hia, mpông lĕ jêh rđăng, oh kon gâp lĕ bêch đŏng, gâp mâu dơi dâk sŏ ăn ma may jăng mê’. ");
INSERT INTO cmo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mâu di ndri ôh. Gâp mbơh ma khân ay may, bunuyh tơm jay nây mra dâk ndơ̆ ro, ndrel ma ăn moh ndơ aƀă êng jât mât jăng păng ŭch. Păng dâk ndơ̆ nây, yorlah bunuyh i nây bănh rkhuak păng mâu blao dŭt, mâu ôh yor ma jêng mât jăng dơm. ");
INSERT INTO cmo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kơt ndri Gâp mbơh ma khân ay may, dăn mro mrăng hŏm ma Kôranh Brah dâng Păng ăn ma khân ay may, joi mro mrăng hŏm dâng say, kuăl mro mrăng hŏm bơh dih mpông dâng Kôranh Brah pơk ăn ma khân ay may ro. ");
INSERT INTO cmo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yorlah bu moh dăn mra geh, bu moh joi mra say, jêh ri bu moh i kuăl bơh dih mpông mra pơk ăn ma păng. ");
INSERT INTO cmo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ta mpôl khân ay may vay geh đŏng lah kon dăn piăng ăn nkhơng lŭ ma păng, lah kon dăn ka, bơ̆ păng ăn nkhơng bêh geh kăch ma păng bơh? ");
INSERT INTO cmo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mâu lah kon dăn tăp iăr ăn nkhơng ndơr ving ma păng? ");
INSERT INTO cmo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bol lah khân ay may jêng bunuyh tih kađôi, khân ay may hôm blao ăn ndơ ueh ma kon đŏng, lah ndri Bơ̆ gŭ ta kalơ trôk rlau bơh nây ăn Brah Huêng Ueh i kloh ueh ma bu moh dăn bơh Păng.” ");
INSERT INTO cmo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Geh du huê bu klô brah djơh lăp ăn păng mlo, tât du nar ri Brah Yêsu ntrŭt brah djơh i nây lôh bơh păng, jêh ri păng blao ngơi ro. Bunuyh gŭ ta nây ŏk ngăn. Tât say nau i nây dâng lĕ khân păng ndrŏt hih rhŏl dadê ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yơn ma geh bu aƀă lah: “Yorlah Satăng i kôranh mpôl brah djơh ăn nau dơi ta Păng, dâng Păng dơi ntrŭt brah djơh.” ");
INSERT INTO cmo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Geh bu aƀă jât ŭch rlong Brah Yêsu dơm, đă Păng jan du nau mbên gay ma nhhơ nau dơi Păng tă bơh Kôranh Brah ri. ");
INSERT INTO cmo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yơn ma Brah Yêsu lĕ gĭt jêh nau khân păng mân, jêh ri Păng lah: “Dâng lĕ bri i geh nau tâm lŏk tâm janh chah chrai băl, bri i nây roh hêng ro. Dâng lĕ rnăk i geh nau tâm lŏk tâm janh ndrăng nơm, rnăk i nây roh hêng mâu hôm geh đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Lah Gâp ntrŭt brah djơh tă bơh nau dơi Satăng i kôranh mpôl brah djơh, brah djơh geh nau tâm rlăch tâm janh chah chrai băl, lah ndri mơm dâng hôm geh bri jât? Gâp ngơi kơt nđa, yorlah khân may lah Gâp ntrŭt brah djơh yor ma Satăng ăn nau dơi ma Gâp. ");
INSERT INTO cmo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Lah Gâp ntrŭt brah djơh yor ma nau dơi Satăng ngăn, bơh tă nau dơi oh mon khân may ntrŭt brah djơh đŏng? Lah ndri oh mon khân may nơm i nây mra tê̆ dôih khân may ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yơn ma lah nau dơi Gâp ntrŭt brah djơh tă bơh Kôranh Brah, lah ndri nau Kôranh Brah mât uănh ma khân may lĕ tât jêh. ");
INSERT INTO cmo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Lah bunuyh dăng ndjôt tak ndjôt đao, gŭ njrăng nhih jay păng nơm, lah ndri drăp ndơ păng hôm kơn. ");
INSERT INTO cmo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yơn ma lah geh du huê bunuyh jât dăng rlau păng, tâm lơh dơi bu, bu mra sŏ tak đao păng i nây, ndrel ma sŏ drăp ndơ păng pă ăn ma bunuyh êng jât. ");
INSERT INTO cmo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Bu moh i mâu gŭ mpeh ma Gâp, bunuyh i nây tâm rdâng đah Gâp, bu moh i mâu gŭ gum ndrel Gâp, bunuyh i nây chah chrai nhhing nhhang.” ");
INSERT INTO cmo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Lah brah djơh lôh bơh du huê bunuyh, jêh ri păng brô̆ rŏ bri rdah, păng joi ntŭk ma gŭ mâu geh ôh, jêh ri păng mra lah êng kơt nđa: ‘Gâp plơ̆ gŭ ta jay ơm gâp ntŭk gâp mhe lôh nơh ƀŏt’. ");
INSERT INTO cmo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tât păng plơ̆ ta nây, say jay i nây lĕ mpêh ueh, ndrăp djahep, ");
INSERT INTO cmo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","jêh ri păng hăn jă brah djơh a êng pơh ơ̆ jât, brah djơh i nây janh rlau păng ngăn, hăn lăp gŭ ndrel ta nây đŏng, jan ăn bunuyh i nây geh nau jêr djơh rlau ơm nơh jât.” ");
INSERT INTO cmo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dôl Brah Yêsu hôm ngơi nau nây, geh du huê bu ur ta phung bunuyh ŏk nây lah: “Bu ur i deh May, i mpu May ma toh, bu ur i nây lap ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yơn ma Brah Yêsu ơh: “Bunuyh i iăt Nau Kôranh Brah Ngơi, n'ho ma tâng kơt, păng i nây lap ŏk rlau.” ");
INSERT INTO cmo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jêh ri bunuyh gŭ gum lơ ma ŏk ngăn, Brah Yêsu lah ma phung i nây: “Bunuyh ta rnôk aƀaơ ri djơh mhĭk hô ngăn, ŭch say ma nau mbên dơm, yơn ma Kôranh Brah mâu ôh ăn nau mbên êng jât, Păng ăn du nau mbên tâm ban ma nau mbên Yônais i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh dơm. ");
INSERT INTO cmo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yônais jêng nau mbên ma ƀon Ninivê say, ndri ta nar jât năp tay Gâp i Kon Bunuyh tă bơh Kôranh Brah jêng nau mbên ta rnôk aƀaơ dja đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ta nar Kôranh Brah phat dôih dâng lĕ bunuyh ta neh ntu, geh kađăch bu ur rnha păng Sêƀa, păng mra tê̆ dôih ma bunuyh rnôk aƀaơ dja. Kăl e nơh păng kađăch ta bri êng ngai mpeh bơh dŏng bri Israel, bol lah păng gŭ ngai dŭt bri dŭt neh kađôi, păng hăn ta bri Israel gay ma iăt nau mân gĭt blao kađăch Salômôn ta bri dja. Yơn ma nar dja ta ntŭk dja geh du huê Bunuyh nau ngơi Păng khlay rlau nau ngơi kađăch Salômôn, tih ma khân ay may mâu ŭch ôh iăt Păng. ");
INSERT INTO cmo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ta nar Kôranh Brah phat dôih dâng lĕ bunuyh ta neh ntu dja, bunuyh ƀon Ninivê mra tê̆ dôih bunuyh ta rnôk aƀaơ dja đŏng, yorlah rnôk kăl e nơh, jêh khân păng tăng nau Yônais mbơh, khân păng rgâl lơi nuih n'hâm djơh ro, khân păng rngot lĕ lăn nau khân păng jan tih nơh, yơn ma ta dja aƀaơ dja geh đŏng du huê Bunuyh kuŏng rlau ma Yônais nây jât.” ");
INSERT INTO cmo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Brah Yêsu nti jât: “Mâu geh ôh bunuyh mpêh ŭnh sagêng, jêh ri pôn ta kuâl, mâu lah kŭp lơi đah sah bơh lơ. Bu vay mpêh sagêng yông ta kalơ, gay ma ang lĕ bunuyh i lăp ta trôm jay nây. ");
INSERT INTO cmo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Trôm măt khân ay may jêng tâm ban ma sagêng ma săk jăn, lah trôm măt khân ay may hôm ang ueh, lĕ săk jăn khân ay may hôm ang dadê, yơn ma lah trôm măt khân ay may lĕ ngo jêh, lĕ săk jăn khân ay may jêng ngo dadê đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kơt nđay ăn khân ay may blao njrăng, lơi ăn khân ay may kơp êng nau ang, jêh ri bu mâu ôh say nau ang, say nau ngo chrao. ");
INSERT INTO cmo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lah lĕ săk jăn khân ay may hôm ang dadê, mâu ôh geh ntŭk ngo, lah ndri lĕ nau rêh khân ay may geh ang dadê, tâm ban ma ŭnh sagêng ngaang khân ay may nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jêh Brah Yêsu ngơi nây, geh du huê phung Pharisi jă Brah Yêsu hăn sông sa ta jay păng ri. Brah Yêsu hăn tât ta nây gŭ sông sa ndrel ta ri. ");
INSERT INTO cmo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bunuyh Pharisi i nây geh nau ndrŏt hih rhŏl ngăn say Brah Yêsu sông mâu geh rao ti lor. ");
INSERT INTO cmo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Lah ndri Brah Yêsu lah ma păng: “Hơi nô, phung Pharisi khân may jêng tâm ban ma bunuyh i rao ngan, rao yăng ta bơh dih dơm, yơn ma ta trôm hôm e uk rmao, khân may rao ti tâng ma nau vay khân may, tih ma ta nuih n'hâm khân may ri hôm dŭt ŭch ma nau sa nsiăn, ndrel ma nau mân djơh mhĭk hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hơi bunuyh mblŭ, lah Kôranh Brah lĕ njêng jêh ndơ bơh dih, ta trôm Păng njêng ndơ đŏng, lah ndri Păng ŭch ta nuih n'hâm khân may ăn kloh tâm ban ma săk jăn khân may đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lah ndri ăn ŏk ndơ ma bunuyh o ach, ri mơ khân may kloh ta nuih n'hâm đŏng, jêh ri khân may kloh bơh dih đŏng, kloh ta nuih n'hâm đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hơi phung Pharisi, rêh rnhăl ngăn ma khân may mê! Khân may nơh sŏ ndơ geh jât ơ̆ rhuăt nguai nhhơr ma Kôranh Brah, kơt lah ndơ mâu khlay, klôyh, gir, ndrel ma ndơ ƀô aƀă êng đŏng. Nau i nhhơr jêng di, tih ma khân may mƀăr lơi nau sŏng, ndrel ma nau rŏng Kôranh Brah i geh nau khlay rlau bu, lah ndri ăn khân may nsrôyh nhhơr kơt i nây ma Kôranh Brah đŏng, yơn ma lơi chuêl nau sŏng, ndrel ma nau rŏng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Hơi phung Pharisi, rêh rnhăl ngăn ma khân may mê! Yorlah ta ntŭk nhih rƀŭn phung bân khân may nơh ŭch gŭ bơh năp bu i ntŭk bu lư ngăn, ndrel ma ŭch hăn rŏ ntŭk bu tăch drăp, ŏk bunuyh bu kŭnh bôk mbah ma khân may. ");
INSERT INTO cmo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Rêh rnhăl ngăn ma khân may mê i phung Pharisi, ndrel ma i phung nơm nti nau vay phung bân, khân may mpôl nuih n'hâm ndŏp mpôn, yorlah khân may nơh jêng tâm ban ma ntu môch uănh mâu say, jêh ri bu de brô̆ jot kalơ mâu ôh gĭt săk, ndri păng mâu hôm kloh ôh. Kơt ndri đŏng khân may ueh ta bơh dih, tih ma ta nuih n'hâm ri djơh.” ");
INSERT INTO cmo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Geh du huê nơm nti nau vay phung Israel ơh ma Brah Yêsu, păng lah: “Hơi Nơm Nti, May ngơi kơt i nây, jêng May mưch nsot ma phung hên đŏng mê.” ");
INSERT INTO cmo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Brah Yêsu ơh ma păng: “Hơi phung nơm nti nau vay phung bân, rêh rnhăl ngăn ma khân may, yorlah khân may tê̆ nau vay dŭt jŏk ăn ma bunuyh jan, tih ma khân may nơm mâu geh ôh kơl jan nau i nây, đê̆ kŏ mâu geh đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Rêh rnhăl ngăn ma khân may, yor ma khân may jan ueh ngăn jay môch ma bunuyh ntơyh nau ngơi Kôranh Brah, i u che khân may lĕ nkhât lơi kăl e nơh, tih ma khân may mâu ôh jan tâng nau nti bunuyh ntơyh nau ngơi Kôranh Brah i nây. ");
INSERT INTO cmo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Khân may jan kơt nây, khân may tâm di du ntôr nau ndrel u che khân may nây đŏng, khân păng ma nkhât, khân may ma jan jay môch dơm. ");
INSERT INTO cmo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ndri Kôranh Brah i geh nau gĭt mân lah kơt nđa: ‘Gâp đă bunuyh ntơyh nau ngơi Gâp hăn a khân păng, ndrel ma kôranh oh mon đŏng, tih ma bunuyh i nây, aƀă khân păng nkhât lơi, aƀă jât khân păng jan jêr’. ");
INSERT INTO cmo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kơt ndri Gâp kơp bunuyh ta rnôk aƀaơ dja geh dôih nkhât bunuyh ntơyh nau ngơi Kôranh Brah ntơm bơh njêng neh ntu. Bol lah bunuyh ntơyh nau ngơi Kôranh Brah i nây lĕ bu nkhât bơh kăl e nơh, dôih i nây hôm tê̆ tât ma bunuyh ta rnôk aƀaơ dja đŏng, ");
INSERT INTO cmo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","jêng ntơm bơh kon Ađăm rnha păng Kain nkhât i oh păng rnha Abel, n'ho ma tât bu nkhât Sakari, i bu nkhât păng ta vah vang nsưng gŭch pur ndơ jan brah, ma nhih jan brah ri. Gâp mbơh ma khân may, mham khân păng i nây Kôranh Brah mra tê̆ dôih ta rnôk bunuyh aƀaơ dja. ");
INSERT INTO cmo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Hơi bunuyh nơm nti nau vay phung Israel, rêh rnhăl ngăn ma khân may mê, yorlah khân may mâu ăn bu gĭt năl nau ngăn Kôranh Brah. Nau i nây tâm ban ma rđăng lơi mpông bơh dih ma lăp nau Kôranh Brah mât uănh, săk khân may nơm lĕ mâu geh lăp ta mpông i nây, jêh ri khân may buay đŏng bu êng jât i ŭch lăp, mâu ăn lăp.” ");
INSERT INTO cmo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ntơm bơh Brah Yêsu lôh bơh ntŭk nây, phung nơm nti nau vay phung Israel, ndrel ma phung Pharisi, tâm rdâng đah Păng dŭt hô, jêh ri ôp mpet Păng ma nau êng êng ŏk. ");
INSERT INTO cmo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Khân păng jan kơt nây ŭch joi nau lah Brah Yêsu ơh tih, mâu lah ngơi tih, gay ma ntôn Păng ro. ");
INSERT INTO cmo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nôk nây geh bunuyh gŭ rƀŭn ŏk rbăn ngăn, gay ma mâp Brah Yêsu, tât ma tâm mpet tâm jot băl ngăn. Jêh ri Brah Yêsu lah ma mpôl oh mon Păng lor: “Ăn khân ay may njrăng nuih n'hâm ndŏp mpôn phung Pharisi, nau djơh nuih n'hâm ndŏp mpôn i nây lơ kuŏng lơ kuŏng, tâm ban ma ndrui đê̆ jan ăn piăng ndrănh ŏk jêng dang. ");
INSERT INTO cmo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Geh du nar jât năp tay Kôranh Brah mra ăn bu say dâng lĕ ndơ i bunuyh hôm mpôn, Kôranh Brah ăn bu gĭt dadê đŏng, dâng lĕ ndơ i bunuyh mâu ŭch ăn bu gĭt. ");
INSERT INTO cmo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kơt ndri dâng lĕ nau khân ay may ngơi ta ntŭk ngo, bu mra tăng ta ntŭk ang, lĕ nau khân ay may ngơi suih ta trôm tôr ta trôm jrô, bu mra mbơh nkoch nau i nây ta kalơ chor jay ro. ");
INSERT INTO cmo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Hơi mât jăng, khân ay may iăt nau Gâp, khân ay may lơi ôh klach bunuyh, khân păng geh nau dơi nkhât ta rnglay săk dơm, jêh ri jan mâu ôh hôm blao jât. ");
INSERT INTO cmo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Gâp mbơh ndơ i khân ay may di klach, klach ma Kôranh Brah hŏ, yorlah jêh Păng nkhât, jêh ri Păng geh nau dơi nklăch ta ndrung ŭnh jât. Ndri Gâp mbơh ma khân ay may, ăn khân ay may klach ma Păng. ");
INSERT INTO cmo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bu vay tăch prăm mlŏm siŭm rleo khlay bar mlŏm kăk jê̆ dơm, bol lah thok kơt nây kađôi lĕ, mâu geh ôh du mlŏm siŭm rleo Kôranh Brah chuêl. ");
INSERT INTO cmo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bol lah dâng lĕ sŏk ta bôk khân ay may nơm, Kôranh Brah lĕ jêh kơp đŏng. Kơt ndri lơi klach ôh, yorlah Kôranh Brah kơp khân ay may khlay ngăn rlau ma siŭm rleo du phung jât. ");
INSERT INTO cmo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Hơi khân ay may iăt hŏm, bu moh i bănh mbơh ma bu păng tâng Gâp, Gâp i Kon Bunuyh tă bơh Kôranh Brah mra mbơh păng i nây jêng oh mon Gâp ta bơh năp măt Kôranh Brah, ndrel ma ta bơh năp măt phung tông păr Kôranh Brah nơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yơn ma bu moh i mâu bănh mbơh ma bu păng tâng Gâp, Gâp mâu đŏng mbơh păng i nây jêng oh mon Gâp ta bơh năp măt Kôranh Brah, ndrel ma mpôl tông păr Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bu moh păng i ngơi tâm rdâng đah Gâp i Bunuyh tă bơh Kôranh Brah, Kôranh Brah hôm yô̆ mâu ôh kơp nau tih păng, yơn ma bu moh păng i ngơi tâm rdâng đah ma Brah Huêng Ueh i kloh ueh, Kôranh Brah hôm kơp nau tih păng nanao. ");
INSERT INTO cmo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Lah bu leo khân ay may hăn ta nhih rƀŭn phung bân gay ma phat dôih yor ma khân ay may tâng Gâp, mâu lah bu leo khân ay may hăn ta bơh năp măt kôranh mât uănh, mâu lah mpôl bu ranh, lơi ôh khân ay may rvê moh nau i khân ay may ŭch ngơi, mâu lah moh nau i khân ay may ŭch ơh ma nau khân păng ntôn. ");
INSERT INTO cmo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yorlah ta mong i nây Brah Huêng Ueh i kloh ueh mbơh ma khân ay may, moh nau i khân ay may ŭch ngơi.” ");
INSERT INTO cmo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Geh du huê bu klô ta phung bunuyh ŏk nây lah ma Brah Yêsu: “Hơi Nơm Nti, bơ̆ hên lĕ khât jêh, đă May mbơh ma nô gâp, đă păng pă drăp ndơ ndơn ăn ma gâp ƀă ơ.” ");
INSERT INTO cmo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Brah Yêsu ơh ma păng: “Bu moh đă Gâp jan kôranh phat dôih, mâu lah jêng bunuyh kơl pă drăp ndơ ăn ma khân may mêh?” ");
INSERT INTO cmo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jêh ri Brah Yêsu lah ma phung bunuyh nây: “Ăn njrăng hŏm, lơi ôh rvan kơnh geh ma drăp ndơ. Bol lah bunuyh geh drăp ndơ ŏk rmeh, nau rêh păng mâu ôh tă bơh drăp ndơ ŏk i nây.” ");
INSERT INTO cmo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jêh ri Brah Yêsu ngơi nau ntât ma khân păng, Păng lah: “Geh du huê bunuyh ndrŏng, ta mir păng ri geh ba jêng ueh ngăn, play rglet ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jêh ri păng mân êng ta săk păng nơm kơt nđa: ‘Mâu hôm geh ôh ntŭk ma dơ ba gâp i nây tay, lah ndri mơm gâp jan?’ ");
INSERT INTO cmo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Păng mân jât: ‘Gâp jan kơt nđa, rơih lơi jay ba ơm i nây, jêh ri kơi jan ăn huy ăn kuŏng ngăn, sŏ ba, ndrel ma drăp ndơ i gâp geh ri tôh bun ta ntŭk jay ba mhe i nây. ");
INSERT INTO cmo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jêh ri gâp lah êng ma săk gâp nơm, gâp geh jêh ba bêng ba rhiăng dŭt ŏk dja, ăn ma prăp sa jŏ năm jât năp, gâp gŭ dơm, jêh ri mân ma sa kah lah rnglay hŏ’. ");
INSERT INTO cmo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tih ma Kôranh Brah lah ma păng: ‘Hơi bunuyh rluk, ta măng dja ro, Gâp rhuăt lơi huêng may. Lah ndri lĕ drăp ndơ i may geh prăp i nây nơh, jêng bu moh ma ndơn?’ ");
INSERT INTO cmo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tâm ban kơt nây đŏng, lah bu moh joi prăk drăp ndơ prăp ma săk păng nơm dơm, tih ma mâu gĭt ma ndơ Kôranh Brah de đă.” ");
INSERT INTO cmo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jêh ri Brah Yêsu lah ma mpôl oh mon Păng: “Kơt ndri dâng Gâp mbơh khân ay may, lơi ôh rvê ma ndơ sông sa ma siăm nau rêh, mâu lah bok ao ma nsoh n'gut săk jăn khân ay may. ");
INSERT INTO cmo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Geh ndơ êng jât ta nau rêh i geh nau khlay rlau ma ndơ sông sa, geh ndơ êng jât ma săk jăn i geh nau khlay rlau ma bok ao ma nsoh. ");
INSERT INTO cmo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lŏng uănh nđak, păng mâu tuch tăm, mâu kăch roih, mâu ôh geh drŏng mâu ôh geh jay ba, yơn ma Kôranh Brah mât siăm păng đŏng. Lah ndri lŏng khân ay may i nây Kôranh Brah kơp geh nau khlay ŏk rlau ngăn ma đah siŭm och i nây. ");
INSERT INTO cmo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ta mpôl khân ay may i nây, bol lah khŏm rvê dŭt hô kađôi lĕ, kŏ mâu geh ôh bunuyh ma dơi ntop nau rêh păng nơm ăn jong, đê̆ kŏ mâu dơi đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Lah ndri nau i dŭt jê̆ i nây, lah khân ay may jan mâu dơi đŏng, mơm dâng hôm rvê ma nau aƀă êng jât? ");
INSERT INTO cmo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lŏng khân ay may uănh kao si hon êng ta bri, păng mâu ôh rơah mâu ôh rgănh jan kar, mâu lah rui tanh gay ma ueh uănh. Gâp mbơh ma khân ay may, bol lah kađăch Salômôn kăl e nơh, nôk păng nkrơ̆ săk jăn soh n'gut kho ao ueh, hôm mâu dơi ban ueh kao si du nkong dja đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hơi bunuyh geh nau nsing đê̆ dơm, lah Kôranh Brah ăn jêh ma kao si i nây ueh ngăn uănh, nar dja păng dang, nar ôi tay bu su lơi păng ma ŭnh, lah ndri Kôranh Brah ndrăp ăn kho ao ma khân ay may rlau bơh nây jât. ");
INSERT INTO cmo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kơt ndri khân ay may i nây lơi ôh mân rvê, lơi ôh joi ma ndơ sông sa ma ndơ nhêt dơm. ");
INSERT INTO cmo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Geh mpôl i mâu iăt ma Kôranh Brah khŏm nsrôyh joi dâng lĕ ndơ i nây. Lŏng i khân ay may nây Bơ̆ khân ay may nơm ta kalơ trôk ri, lĕ Păng gĭt dadê jêh moh ndơ i khân ay may ê hŏ tŏng. ");
INSERT INTO cmo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lah ndri nsrôyh joi, ndrel ma iăt lĕ ndơ Kôranh Brah ŭch lor, ri mơ Păng ăn ntop ndơ i nây ma khân ay may đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Hơi mpôl jê̆ Gâp, lơi klach ôh, Bơ̆ khân ay may nơm ta kalơ trôk ri maak ngăn mât uănh khân ay may. ");
INSERT INTO cmo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tăch hŏm drăp ndơ khân ay may geh, pă ăn ma mpôl o ach. Ndri mơ khân ay may jêng rƀŭn drăp ndơ i mâu blao ôm i mâu blao lĕ, rƀŭn drăp ndơ prăp ma khân ay may nơm ta ntŭk Kôranh Brah ta kalơ trôk ri, ntŭk i nây mâu ôh geh bunuyh ntŭng, mâu ôh geh nchiăr reh. ");
INSERT INTO cmo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Njrăng hŏm, ndơ i khân ay may ntrŏng khlay rlau bu, jêng ndơ i khân ay may mân rvê rlau bu đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Ăn khân ay may njrăng ƀaƀơ hŏm, kŏp Gâp plơ̆ tay ta dja, tâm ban ma dâk gŭ kŏp kôranh khân păng plơ̆ sât bơh sa nđăp nôk măng. Khân păng ndrăp săk jăn, ăn geh ŭnh sagêng hit du năng raang đŏng, gay ma dơh pơk mpông ma păng, ndrel ma gơnh jan kar ăn ma păng ro. ");
INSERT INTO cmo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tât kôranh sât ta ri, ueh ngăn ma dâk aƀă i păng say hôm gŭ rngeh kŏp ta ri. Gâp lah n'hêl nanê̆ ngăn ma khân ay may, i kôranh nây mra ăn dâk păng ri gŭ sông sa ta nsưng ro, i păng nơm ri ndrăp săk jăn ma plăch sơm kơl jan kar ăn khân păng i nây. ");
INSERT INTO cmo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bol lah i kôranh păng tât n'gul măng, mâu lah kêng ang kađôi, hôm say dâk păng hôm gŭ rngeh kŏp đŏng, dâk i nây geh nau ueh ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ăn khân ay may gĭt nau dja: Lah bunuyh tơm jay gĭt mong bu hăn ntŭng, păng mâu ôh ƀok gor ăn bunuyh ntŭng i nây lăp ta jay păng. ");
INSERT INTO cmo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Lah ndri ăn khân ay may gŭ njrăng tâm ban đŏng, yorlah Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch, ta mong ngơt rngơi khân ay may mâu geh mân.” ");
INSERT INTO cmo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pêtrôs ôp Brah Yêsu: “Hơi Kôranh, nau May ngơi ntât dja dơn lah ma hên dơm, mâu lah ŭch lah ma dâng lĕ ƀon lan đŏng?” ");
INSERT INTO cmo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Brah Yêsu ơh ma păng: “Gâp mbơh ma dâng lĕ bunuyh i tâm ban ma du huê dâk i geh nuih n'hâm sŏng, ndrel ma lĕ blao ngăn. Kôranh jao păng mât uănh dâk a êng ta jay nây, ndrel ma ăn păng pă ndơ sông sa tâm di mong ăn ma khân păng đŏng. Jêh ri kôranh hăn ta ntŭk ngai jŏ nar. ");
INSERT INTO cmo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nôk kôranh păng sât tât ta jay ri, hôm say păng jan kar kơt nây, dâk i nây geh nau ueh ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Gâp mbơh ngăn ma khân ay may, kôranh mra ăn dâk i nây mât uănh dâng lĕ ndơ kôranh geh. ");
INSERT INTO cmo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tih ma lah dâk i nây păng geh lah êng ta nuih n'hâm păng nơm ri: ‘Kôranh gâp jŏ ngăn sât, păng mâu ôh gơnh sât’. Jêh ri păng ntơm rpăt mbang dâk a êng, nđâp ma bu ur đŏng bu klô đŏng, ndrel ma sông sa nhêt ndrănh nhŭl blâk blek. ");
INSERT INTO cmo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Jêh ri i kôranh dâk i nây plơ̆ sât tât ta ri, ta nar nây dâk i nây mâu ôh geh njrăng, ta mong nây păng mâu geh gĭt đŏng. Kôranh nkrit păng ro, ndrel ma ăn păng gŭ ta ntŭk dâng lĕ bunuyh i mâu geh đŏng jan kar ăn sŏng. ");
INSERT INTO cmo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bu moh dâk i lĕ gĭt năl nuih n'hâm kôranh păng nơm ŭch, tih ma mâu ndrăp săk jăn, ndrel ma mâu jan tâng nuih n'hâm kôranh ŭch, dâk i nây mra mâp mŏng ŏk ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yơn ma dâk i mâu gĭt năl nuih n'hâm kôranh ri, păng geh jan tih đŏng, tih ma mâp mŏng đê̆ đă dơm. Yơn ma bu moh i bu ăn ndơ ŏk, bu mra dăn tă bơh bunuyh i nây ŏk đŏng. Bu moh i bu jao jan kar kuŏng, bu mra ôp bơh păng i nây lơ hô ŏk jât.” ");
INSERT INTO cmo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Brah Yêsu lah jât: “Gâp văch gay ma leo ŭnh dôh ta neh ntu. Gâp ŭch ngăn lah say ŭnh i nây lĕ hit. ");
INSERT INTO cmo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hôm đê̆ nar jât năp tay Gâp geh nau krit jêr hô ngăn, ndơ i nây jêng du ntil ƀăptem ma Gâp, ta nuih n'hâm Gâp rngot hô ngăn tât ma nau i dja jêh lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lơi ôh khân ay may mân Gâp văch gay ma leo nau đăp mpăn ta neh ntu dja, mâu di ôh, văch gay ma leo nau tâm nkhah mpôl. ");
INSERT INTO cmo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ntơm bơh nar dja jât năp, ntât lah geh du mlŏm jay, geh bunuyh prăm nuyh, bunuyh prăm nuyh i nây mra tâm nkhah mpôl, pe nuyh tâm nkhah mpôl đah ma bar hê, bar hê tâm nkhah mpôl đah ma pe nuyh ");
INSERT INTO cmo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","‘Bơ̆ tâm nkhah mpôl đah kon bu klô, Kon bu klô tâm nkhah mpôl đah bơ̆, Mê̆ tâm nkhah mpôl đah kon bu ur, Kon bu ur tâm nkhah mpôl đah mê̆, Po bu ur tâm nkhah mpôl đah măn, Măn tâm nkhah mpôl đah po bu ur’.” ");
INSERT INTO cmo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Brah Yêsu lah ma phung ƀon lan đŏng: “Dôl khân ay may say tŭk brô̆ mpeh bơh nhŏp nar ri, khân ay may lah ro: ‘Bơi ŭch mih jêh’, ndri geh mih ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Lah khân ay may say geh sial khôm tă mpeh bơh dŏng ri, khân ay may lah: ‘Nar dja hô dôh’, păng geh dôh ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hơi bunuyh jan iăt nau Kôranh Brah dơm, khân ay may blao mbên trôk, ndrel ma blao mbên neh, lah ndri mơm dâng mâu gĭt vât ndơ i Kôranh Brah jan ta nôk aƀaơ dja?” ");
INSERT INTO cmo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Jêh ri mơm dâng khân ay may mâu geh nklŏn êng ta săk khân ay may nơm, i nau khân ay may jan di? ");
INSERT INTO cmo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Lah khân ay may hăn jât nhih phat dôih ri, dôl khân ay may hăn rŏ trong ndrel bunuyh i khân ay may geh nau nây, ăn khân ay may tâm dăn nau yô̆ băl, klach lah bu njŭn khân ay may jât kôranh phat dôih, kôranh phat dôih i nây njŭn ma kôranh ndrung, jêh ri kôranh ndrung i nây krŭng khân ay may ta trôm ndrung ro. ");
INSERT INTO cmo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Gâp mbơh ma khân ay may, lah mâu râng jan dôih ăn bu, khân ay may mâu dơi ôh lôh bơh ntŭk nây.” ");
INSERT INTO cmo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ta ntŭk nây đŏng, geh bunuyh aƀă ta phung i nây mbơh ma Brah Yêsu ma nau kôranh Pilat de jan, khân păng lah: “Hơi Kôranh, geh mpôl Galilê Pilat de nkhât khân păng ta jŏng gung nhih jan brah ma Kôranh Brah, ta ntŭk nây khân păng hôm e jan brah, ndri mham khân păng hoch lai đah mham mpômpa (siŭm) i khân păng jan brah nơh.” ");
INSERT INTO cmo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Brah Yêsu ơh ma khân păng: “Ah khân ay may mân mpôl Galilê i nây geh nau tih ŏk rlau ma đah phung Galilê êng êng bơh, dâng geh ma khân păng khât djơh kơt nây? ");
INSERT INTO cmo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Gâp mbơh ma khân ay may, mâu di ôh! Lah khân ay may mâu geh rgâl lơi nuih n'hâm djơh, khân ay may mra roh hêng tâm ban ma khât bu i nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Lah ndri ăn khân ay may kah gĭt nôk du mlŏm jay prêh rnha Silom ta ƀon kuŏng Yêrusalem, jay i nây nklŏn bunuyh 18 nuyh khât. Ah khân ay may mân khân păng i nây yor ma geh nau tih ŏk rlau ma bunuyh aƀă êng ta ƀon Yêrusalem bơh? ");
INSERT INTO cmo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mâu di ôh! Gâp mbơh ma khân ay may, lah khân ay may mâu geh rgâl lơi nuih n'hâm djơh, khân ay may tay roh hêng đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jêh ri Brah Yêsu ngơi nau ntât dja lah: “Geh du huê bu klô tăm du tơm Rvi ta mir păng nơm. Ăp năm tât khay geh play bunuyh i tơm mir i nây gay ma pĕ play bơh tơm Rvi i nây mâu ôh say geh play. ");
INSERT INTO cmo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jêh ri păng lah ma bunuyh mât mir nây: ‘Hơi may, tơm Rvi dja lĕ pe năm jêh gâp gay ma pĕ play, mâu ôh say play. Kăl mƀăr lơi dôh, moh jan rong huach dơm neh!’ ");
INSERT INTO cmo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jêh ri bunuyh i mât mir nây lah: ‘Hơi kôranh, may rong păng hôm du năm jât, kŏp gâp nsơr neh, tê̆ ăch ndrôk ƀŏt. ");
INSERT INTO cmo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nkhêp lah năm bơh năp tay play. Lah mâu say play đŏng dâng geh ma kăl lơi păng!’” ");
INSERT INTO cmo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Geh du nar ri, jêng nar Saƀăt i nar phung Israel rlu buay jan kar, Brah Yêsu gŭ nti bu ta nhih rƀŭn phung Israel ri. ");
INSERT INTO cmo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ta ntŭk nây geh du huê bu ur brah djơh lơh păng, lĕ jŏ 18 năm hơi, chor kuyh păng đŭn, dâk sŏng mâu blao ôh. ");
INSERT INTO cmo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Dôl Brah Yêsu say bu ur i nây, Păng kuăl bu ur i nây văch dăch, jêh ri lah ma păng: “Nau đŭn chor kuyh ay lĕ bah jêh.” ");
INSERT INTO cmo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Brah Yêsu tê̆ ti kalơ săk păng ri, jêh ri bu ur i nây dâk sŏng bah ndal ta nây ro, nkre ma păng rnê ma Kôranh Brah đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tih ma bunuyh i mât uănh nhih rƀŭn nây, say Brah Yêsu jan bah bu ta nar Saƀăt, păng ji nuih ngăn. Păng lah ma phung ƀon lan i nây: “Geh prao nar dơi jan kar, lah ndri khân ay may hăn ta nar i nây dô, lah ŭch jan bah nau ji, lơi ôh hăn ta nar Saƀăt.” ");
INSERT INTO cmo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Brah Yêsu lah ma bunuyh i mât nhih rƀŭn nây: “Hơi bunuyh jan iăt nau Kôranh Brah dơm! Ah dâng lĕ khân may ơm mâu lah droh ndrôk, seh lia, bơh ndrung n'gar leo ăn păng nhêt dak ta nar Saƀăt heh? Ndơ i nây jan kar đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Bu ur dja kon sau Abrahăm i che phung bân đŏng. Satăng i kôranh mpôl brah djơh kât păng lĕ jŏ 18 năm ngăn, lah ndri Gâp rklaih păng ta nar Saƀăt ơm mâu di ƀah?” ");
INSERT INTO cmo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jêh Brah Yêsu ngơi nây, đit prêng dadê ngăn lĕ bunuyh i tâm rdâng đah Păng ri nơh. Lŏng i ƀon lan ri bu geh nau răm maak ngăn ma lĕ nau dơi nau ueh Brah Yêsu jan i nây. ");
INSERT INTO cmo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jêh ri Brah Yêsu lah: “Moh ndơ dơi tâm ntât ma nau Kôranh Brah mât uănh? Lah ndri moh ndơ Gâp jan gay ma dơi tâm rđâl ma nau Kôranh Brah mât uănh bunuyh nây? ");
INSERT INTO cmo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nau Kôranh Brah mât uănh bunuyh, jêng tâm ban ma găr si du ntil dŭt jê̆, geh du huê bu klô tăm ta mir păng nơm ri. Găr si i nây hon jêng tơm si dŭt kuŏng, jêh ri n'ho ma geh siŭm jan rsuăn ta n'ging nây đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Brah Yêsu lah jât: “Lah ndri moh ndơ êng jât Gâp ntât gay ma dơi tâm ban ma nau Kôranh Brah mât uănh nây? ");
INSERT INTO cmo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nau Kôranh Brah mât uănh bunuyh, jêng tâm ban ma ndrui du mlŏm, du huê bu ur sŏ pot lai ndrel rnih Ba Prăng, păng tê̆ dak mpiăch ăn tâm lăp băl gay ma jan nŭmpăng, tât jŏ du mong bar mong bơh kơi nây, dâng lĕ ndơ i nây lơ ma kuŏng lơ ma kuŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jêh ri Brah Yêsu hăn rƀŏng jât ƀon kuŏng Yêrusalem, Păng hăn glăt rŏ ƀon kuŏng, rŏ ƀon jê̆ êng êng, n'ho ma ntŭm nti bu đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ta du ƀon geh du huê bu klô ôp Păng: “Hơi Kôranh, bunuyh i geh nau rklaih geh đê̆ dơm ƀah?” Brah Yêsu ơh ma păng: ");
INSERT INTO cmo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Trong ta nau rklaih tâm ban ma mpông jay huêt, lah ndri ăn khân ay may nsrôyh lăp rŏ mpông jay huêt i nây. Gâp mbơh ma khân ay may, geh ŏk bunuyh ŭch lăp, tih ma mâu dơi ôh. ");
INSERT INTO cmo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Geh du huê tơm jay, tât du nar păng dâk rđăng lơi mpông, khân ay may gŭ bơh dih mpông ri, ntơm kuăl păng: ‘Hơi kôranh! Hơi kôranh! Pơ̆ mpông ma hên ƀă ơ’. Păng i tơm jay nây ơh ma khân ay may lah: ‘Mâu ôh, gâp mâu ôh gĭt năl khân ay may i nây bơh tă!’ ");
INSERT INTO cmo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jêh ri khân ay may mbơh tay ma păng đŏng: ‘Moh nơh! Hên vay gŭ sông sa ndrel may nơh hiơ, may vay ntŭm nti hên rŏ ƀon đŏng’. ");
INSERT INTO cmo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Păng lah ma khân ay may: ‘Hơi mpôl jan kar kue, du ngai bơh gâp hŏm! Gâp mâu ôh gĭt năl khân ay may i nây bơh tă!’, Gâp tâm ban ma tơm jay i nây. ");
INSERT INTO cmo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jêh ri khân ay may geh nau nhhiăng nhŭm, ndrel ma rchiăt sêk, dôl khân ay may say mpôl che khân ay may Abrahăm, Isăk, ndrel ma Yakôp, jêh ri ndrel ma bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh gŭ ta nau Kôranh Brah mât uănh nây, tih ma i khân ay may nây Kôranh Brah ntlơi lơi bơh dih ri. ");
INSERT INTO cmo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Geh bunuyh i tă bơh ăp njônh bri, khân păng mâu ôh di phung Israel, gŭ nhêt sông sa ndrel ta ntŭk bri kađăch Kôranh Brah ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Lŏng bunuyh i bơh kơi plăch bơh năp, bunuyh i bơh năp plăch bơh kơi chrao, geh bunuyh aƀă ta neh ntu dja bu gĭt khân păng geh nau khlay ngăn, yơn ma ta jât năp tay mâu ôh geh nau khlay, tih ma geh bunuyh aƀă êng jât ta neh ntu dja bu gĭt khân păng mâu ôh geh nau khlay, yơn ma ta jât năp tay nkhơng ma geh nau khlay.” ");
INSERT INTO cmo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ta nôk nây geh phung Pharisi aƀă hăn mâp Brah Yêsu, jêh ri lah ma Păng: “May du bơh ntŭk dja hŏm, kôranh mât uănh Hêrôt-Ŏntipas ŭch nkhât May.” ");
INSERT INTO cmo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Brah Yêsu lah ma phung i nây: “Păng mâu ôh geh nau dơi ma Gâp, hăn khân may mbơh ma păng i bunuyh tâm ban ma so bri i nây, nar dja, nar ôi tay, Gâp hôm ntrŭt brah djơh, ndrel ma jan bah bunuyh ji, tât nar ôi klak Gâp jan kar Gâp dja tât jêh. ");
INSERT INTO cmo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yơn ma nar dja, nar ôi tay, ndrel ma nar ôi klak, iăt ma Gâp hăn rŏ trong, Gâp hăn tât ta ƀon kuŏng Yêrusalem, yorlah mâu di ôh ma bunuyh ntơyh nau ngơi Kôranh Brah khât bơh dih ƀon i nây. ");
INSERT INTO cmo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Hơi bunuyh ta ƀon Yêrusalem, bunuyh ta ƀon Yêrusalem, khân ay may lĕ nkhât jêh bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, sŏ lŭ ntŭp nkhât lơi i bunuyh Kôranh Brah đă hăn nti khân ay may. Yơn ma lĕ ƀaƀơ ngăn Gâp ŭch rgum khân ay may, tâm ban ma me iăr rtŭk kon ăn gŭ gum ta nâm nar păng, tih ma khân ay may mâu ŭch ôh. ");
INSERT INTO cmo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Gâp mbơh ma khân ay may, Gâp hăn a khân ay may hôm du tơ̆ dơm, jêh ri tay khân ay may mâu hôm ôh say Gâp jât. Uănh ƀon khân ay may tay Kôranh Brah ntlơi ngăn, n'ho ma tât mong khân ay may lah ma Gâp: ‘Dăn Kôranh Brah ăn nau geh jêng ma Bunuyh dja, i Kôranh Brah de đă văch’.” ");
INSERT INTO cmo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Geh du nar jêng nar Saƀăt, Brah Yêsu hăn sông sa ta jay du huê kôranh phung Pharisi. Tât ta nây lĕ mpôl i gŭ ta jay nây kŏp rmiăng uănh Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ta nây say du huê bunuyh ji pŭk ji môr, gŭ bơh năp Brah Yêsu ri. ");
INSERT INTO cmo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jêh ri Brah Yêsu ôp phung nơm nti nau vay phung Israel, ndrel ma phung Pharisi: “Tâng ma nau vay phung bân, ah di đŏng bơh, jan bah bunuyh ji ta nar Saƀăt i nar gŭ rlu buay jan kar?” ");
INSERT INTO cmo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lĕ khân păng ri gŭ iăt săk răk klăk dơm, mâu ôh du huê ngơi, jêh ri Brah Yêsu kuăn bunuyh i nây jan bah nau ji, đă păng sât a ri. ");
INSERT INTO cmo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jêh ri Brah Yêsu lah ma khân păng i nây: “Ta phung khân may, lah geh kon bu klô, mâu lah ndrôk khân may tŭp ta trôm ntu dak ta nar Saƀăt, lah ndri ơm mâu lah khân may sŏ păng bơh? Ndơ i nây jêng jan kar đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Khân păng mâu ôh blao ơh nau i nây ma Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Brah Yêsu say mpôl bu năch kơih ntŭk gŭ bu lư, jêh ri Păng ngơi nau ntât ma mpôl i nây: ");
INSERT INTO cmo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Lah geh bu kuăl khân may lăp nhêt sông ta ntŭk tâm nđăp du ntŭk, lơi khân may gŭ ôh ta ntŭk bu rong ăn ma bu têh bu kuŏng, nkhêp lah geh păng kuăl đŏng bu i kuŏng rlau may. ");
INSERT INTO cmo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Lah bunuyh i tơm tâm nđăp nây, păng kuăl may, ndrel ma kuăl bunuyh i kuŏng rlau may đŏng, păng mra lah ma may: ‘Dăn ntŭk i dja ăn ma bunuyh i dja’ ro. Jêh ri may plăch gŭ bơh kơi dŭt bu ri, ta mong i nây may geh nau đit prêng bu dŭt hô. ");
INSERT INTO cmo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lah ndri, ăn khân may gŭ bơh kơi dŭt bu ri ƀŏt, kŏp păng nơm i tơm tâm nđăp nây lah: ‘Hơi jăng, hăn gŭ a ntŭk i ueh i bu lư a năp dja hŏm’, i nây jêng nau bu yơk ma may ma lĕ bu i gŭ sông sa ndrel ta nây. ");
INSERT INTO cmo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bu moh i n'hao êng săk păng nơm, Kôranh Brah njŭr lơi păng, yơn ma bu moh i njŭr êng săk ŭch iăt păng, Kôranh Brah sơm n'hao păng.” ");
INSERT INTO cmo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jêh ri Brah Yêsu lah ma bunuyh i tơm jă Păng nhêt sông i nây: “Lah may ndrăp nau nhêt sông, n'gul nar, mâu lah kêng măng, may lơi jă ôh mât jăng, oh nô, băl mpôl, mâu lah bunuyh chiao meng i geh drăp ndơ ŏk, yorlah mpôl i nây plơng jă may dơi, lah ndri lĕ geh bu trŏ ma may jêh. ");
INSERT INTO cmo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yơn ma lah may ndrăp nau nhêt sông, ăn may jă phung o ach, phung lŭt jŏng ti, phung kuet rven, ndrel ma phung cheh măt hŏ. ");
INSERT INTO cmo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kơt ndri Kôranh Brah ăn nau geh jêng ma may ro, yorlah dâng lĕ bunuyh i nây, khân păng mâu ôh dơi plơng jă may đŏng, yơn ma Kôranh Brah dơm sơm plơng trŏ ăn ma may, tât ma păng ăn bunuyh sŏng srăng dâk rêh tay.” ");
INSERT INTO cmo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jêh Brah Yêsu ngơi nây, du huê bu klô i gŭ sông sa ndrel, păng lah ma Brah Yêsu: “Ueh maak ngăn ma bunuyh i gŭ sông kuŏng nhêt kuŏng ndrel ta ƀon ueh Kôranh Brah.” ");
INSERT INTO cmo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yơn ma Brah Yêsu lah nau ngơi ntât ma păng: “Geh du huê bu klô ndrăp nau nhêt sông dŭt kuŏng, jêh ri păng jă bu năch ŏk ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tât di mong nhêt sông i nây, păng đă dâk păng ri hăn mbơh bu lah: ‘Hăn hŏm! Piăng trao ndrăp lĕ jêh lĕ phiao’. ");
INSERT INTO cmo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tih ma dâng lĕ bu năch i nây rlăch dadê, păng i bơh năp ri lah nđa: ‘Gâp mhe rvăt mir du lôk, aƀaơ ri gâp ŭch hăn uănh ngăn ro, gâp dăn dôih ma kôranh may hay’. ");
INSERT INTO cmo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Păng i du huê jât lah nđa: ‘Gâp mhe rvăt jât ơ̆ ndrôk nkuŏng, gâp ŭch rlong tê̆ păng, gâp dăn dôih ma kôranh may hay’. ");
INSERT INTO cmo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","I du huê ri jât lah nđa: ‘Gâp mhe nđăp mê, kơt ndri dâng gâp mâu geh hăn sông sa ndrel’. ");
INSERT INTO cmo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Dâk i nây plơ̆ mbơh ma kôranh ri tâng nau i nây. Jêh ri kôranh i nây ji nuih hô ngăn, lah ma dâk păng ri: ‘Brô̆ ăn gơnh hŏm, rŏ trong kuŏng trong jê̆, ta ƀon kuŏng dja, jă leo phung o ach, phung lŭt jŏng ti, phung kuet rven, phung cheh măt hăn nhêt sông ta dja’. ");
INSERT INTO cmo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jêh jan kơt nây, păng mbơh ma kôranh păng: ‘Hơi kôranh! Lĕ jêh gâp jan tâng nau may đă nây, yơn ma ntŭk hôm e rmeh đŏng’. ");
INSERT INTO cmo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","I kôranh nây đă jât: ‘Hăn brô̆ rŏ trong rŏ mir, nchâp đă bu hăn ăn bêng jay gâp. ");
INSERT INTO cmo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Khân ay may iăt nau gâp lah, lĕ bunuyh i lĕ jêh gâp jă nơh, gâp mâu hôm ôh ăn du huê chŏk piăng trao gâp!’” ");
INSERT INTO cmo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Geh ŏk bunuyh brô̆ tâng Brah Yêsu. Păng n'gâl jât phung i nây, jêh ri lah ma khân păng: ");
INSERT INTO cmo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Lah bu moh ŭch tâng Gâp, tih ma mâu rŏng Gâp rlau đah nau păng rŏng mê̆ bơ̆, ur kon, oh nô oh nur, bol lah đah nau rêh păng nơm kađôi, bunuyh i nây jan oh mon Gâp mâu dơi ôh. ");
INSERT INTO cmo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jêh ri bu moh i mâu tui si tâm rkăng păng nơm brô̆ tâng Gâp, jêng geh nau khlay mâu iăt dâng lĕ nau Kôranh Brah đă bol lah tât khât săk kađôi, bunuyh i nây mâu dơi jan oh mon Gâp đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Lah khân ay may ŭch tâng Gâp, ăn khân ay may gĭt n'hêl lor. Kơt ndri lah geh du huê bunuyh ŭch jan jay kuŏng, păng gŭ mân lor mơ, dah ŏk lĕ huach jan, dah ŏk geh prăk ta săk păng nơm ri gay ma gĭt jan jêh, mâu lah mâu jêh. ");
INSERT INTO cmo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Klach lah tê̆ meh jêh lĕ phiao, tih ma jan mâu dơi jêh. Kơt ndri bu moh i say, bu gơm mưch ");
INSERT INTO cmo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kơt nđa: ‘Păng dja jan jay, tih ma mâu dơi jêh hiah!’ ");
INSERT INTO cmo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mâu lah, lah geh du huê kađăch, jêh ri păng ŭch tâm lơh đah du huê kađăch êng, lah ndri kađăch i nây gŭ mân tâm nchră lor mơ, lah păng geh tahen 10000 nuyh dơm, dơi tâm rdâng đah kađăch i leo tahen 20000 nuyh nây lah mâu. ");
INSERT INTO cmo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Lah păng gĭt lah mâu dơi ro, păng đă bunuyh sơm ntang păng brô̆ ôp, mơm jan gay ma geh nau đăp mpăn, dôl kađăch i nây hôm e ngai. ");
INSERT INTO cmo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kơt ndri ta phung khân ay may nây, bu moh i mâu dơi ƀah ma dâng lĕ drăp ndơ păng nơm geh, bunuyh i nây mâu ôh dơi jan oh mon Gâp.” ");
INSERT INTO cmo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Boh jêng du ntil ndơ tê̆ trao ma kah ngăn, lah boh i nây mâu hôm geh kah, mơm hôm blao jan gay ma ăn plơ̆ kah jât? ");
INSERT INTO cmo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Păng mâu hôm ôh geh nau khlay jât, bol lah sŏ pot lai ma neh, mâu lah ma ăch ndrôk mâu hôm geh nau khlay đŏng, phalah ma nkhŭt mƀăr lơi bơh dih dơm. Bu moh geh tôr ma iăt, ăn iăt dô!” ");
INSERT INTO cmo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jêh ri geh du nar, geh mpôl kŏp sŏ prăk bơh bu ma ăn kôranh mât uănh, ndrel ma bunuyh i bu kơp jêng bunuyh tih, ran văch ta Brah Yêsu ri dadê, gay ma iăt nau Păng ngơi. ");
INSERT INTO cmo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jêh ri phung Pharisi, ndrel ma phung nơm nti nau vay phung Israel, khân păng ngơi ƀŭk ngơi suih lah: “Lŏng Păng i nây rom bunuyh tih, sông sa ndrel khân păng đŏng!” ");
INSERT INTO cmo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jêh ri Brah Yêsu lah ma khân păng ma nau ngơi ntât: ");
INSERT INTO cmo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ntât lah ta phung khân may, bu moh geh be biăp 100 jêh ri roh du mlŏm, păng mra ntlơi be biăp 99 i nây ta bri rdah, jêh ri hăn joi ngăn joi ngăn du mlŏm be biăp i roh nây ăn tât say ro. ");
INSERT INTO cmo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tât say ri, păng răm maak ngăn, pư be biăp i nây tê̆ ta mlik păng nơm ri, jêh ri plơ̆ sât tay ta ntŭk i nây. ");
INSERT INTO cmo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Sât tât a jay păng nơm ri, păng kuăl mât jăng păng, ndrel ma oh nô chiao meng, mbơh ma khân păng: ‘Hơi khân ay may kơl răm maak ndrel gâp hŏm, yorlah be biăp gâp i roh nơh lĕ say jêh’. ");
INSERT INTO cmo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Gâp mbơh ma khân may, geh nau răm maak hô ngăn ta kalơ trôk ta ntŭk Kôranh Brah nơm, ma du huê bunuyh tih rgâl lơi nuih n'hâm djơh, rlau ma bunuyh sŏng 99 i mâu hôm khăch rgâl nuih n'hâm djơh.” ");
INSERT INTO cmo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Brah Yêsu ngơi du nau ntât jât: “Ntât lah, lah geh du huê bu ur geh jât mlŏm prăk kăk, jêh ri roh du kăk, păng mra mpêh ndŏk mrŏm, mpêh ŭnh ngaang rŏ pŭng rŏ njônh joi rmiăng ăn tât say ro. ");
INSERT INTO cmo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tât ma say ri, păng kuăl mât jăng păng, ndrel ma oh nô chiao meng, mbơh ma khân păng: ‘Hơi khân ay may kơl răm maak ndrel gâp hŏm, yorlah prăk gâp i roh nơh lĕ say jêh’. ");
INSERT INTO cmo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Gâp mbơh ma khân may, tông păr Kôranh Brah geh nau răm maak dŭt hô, yorlah geh du huê dơm bunuyh tih lĕ rgâl lơi nuih n'hâm djơh.” ");
INSERT INTO cmo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Brah Yêsu lah jât: “Geh du huê bunuyh geh bar hê kon bu klô. ");
INSERT INTO cmo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Geh du nar, i kon mpŭt nây lah ma bơ̆ păng: ‘Hơi bơ̆, đă may pă drăp ndơ khlay i may ŭch pă ăn ma gâp nôk may khât, may pă hŏm ăn gâp aƀaơ dja ro. Gâp mâu ŭch ôh kŏp tât may khât’. Jêh ri i bơ̆ ri pă drăp ndơ khlay ăn ma lĕ bar hê kon nây ro. ");
INSERT INTO cmo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tât bar pe nar bơh kơi nây, i kon mpŭt ri păng tăch dâng lĕ drăp ndơ păng nơm, jêh ri ndjôt prăk hăn jât bri ngai. Ta bri i nây păng dơ̆ nhrih (mƀih mƀeh), prăk păng nơm tât lĕ. ");
INSERT INTO cmo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tât ma lĕ prăk ri, lŏng ta bri i nây ntơm geh nau ji sŏt ji ngot dŭt hô, i păng nơm ri lĕ o ach đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jêh ri păng hăn dăn gŭ jan kar bu du huê ta bri nây, bu đă păng mât sŭr phung rŏ mir. ");
INSERT INTO cmo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Păng ŭch ngăn ma mpa bu ăn sŭr sa gay ma bah ji ngot, tih ma mâu geh ôh bu ăn păng sa. ");
INSERT INTO cmo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tât du nar păng kah gĭt săk, păng mân êng ta săk păng nơm ri: ‘Dâng lĕ bunuyh jan kar ma bơ̆ gâp geh ndơ sông sa tŏng rmeh, lŏng gâp gŭ ta dja tăch proch ŭch ma khât ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Gâp plơ̆ sât ma bơ̆ hơyh, mbơh ma păng: ‘Hơi bơ̆, kon jan tih ma Kôranh Brah, jêh ri jan tih ma may đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Gâp dja mâu hôm ôh di may kuăl jêng kon may jât bơ̆, dăn may kơp gâp jêng bunuyh jan kar ma may dơm hŏ’’. ");
INSERT INTO cmo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jêh mân kơt nây păng dâk sât ma bơ̆ păng ro. Păng hăn rŏ trong bơ̆ păng say hôm ngai, tât ma say bơ̆ păng yô̆ nđach hô ngăn, nchuăt ran ut i kon ri. ");
INSERT INTO cmo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jêh ri i kon ri mbơh ma bơ̆: ‘Hơi bơ̆, kon jan tih ma Kôranh Brah, jêh ri jan tih ma bơ̆ đŏng, gâp dja mâu hôm ôh di may kuăl jêng kon may jât, bơ̆’. ");
INSERT INTO cmo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Jêh ri i bơ̆ nây mbơh ma dâk păng: ‘Hăn sŏ bok ao i dŭt ueh ăn gơnh, nsoh ăn ma kon gâp dja, jêh ri sŏ rgên, ndrel ma ntô jot sơm ntrŭp ăn păng đŏng, gay ma nhhơ păng jêng kon gâp ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jêh ri sŏ kon ndrôk i pêt êng nơh lăch gŭch nhêt sông sa ăn maak, ");
INSERT INTO cmo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","yorlah kon gâp nơh tâm ban ma khât, aƀaơ dja păng lĕ rêh jât, păng nơh roh, aƀaơ dja lĕ gâp say đŏng’. Jêh ri khân păng leo băl nhêt sông sa maak ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nôk nây i kon bôk dak ri gŭ a mir. Tât păng sât bơi tât a jay, tăng nteh gong gŏr, ndrel ma rŏm mprơ, ");
INSERT INTO cmo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","păng kuăl du huê dâk ôp: ‘Moh ndơ jan nây?’ ");
INSERT INTO cmo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Dâk i nây mbơh ma păng: ‘Oh may lĕ sât. Bơ̆ may đă bu lăch gŭch kon ndrôk i bân pêt nơh, yorlah kon păng plơ̆ sât geh nau ueh lăng’. ");
INSERT INTO cmo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kon bôk dak i nây ji nuih rmao ngăn, mâu ŭch ôh lăp trôm jay, jêh ri i bơ̆ ri lôh a dih dja bonh đă păng lăp. ");
INSERT INTO cmo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Păng ơh ma i bơ̆: ‘Gâp gŭ ndrel may lĕ jŏ năm ngăn, mâu ôh rlau bŏr mbung may, jêh ri bol lah i kon be may mâu ăn ma gâp, gâp be ma lăch gŭch nhêt sông sa ndrel mât jăng, du mlŏm mâu ơm. ");
INSERT INTO cmo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lŏng i kon may i nây, păng dơ̆ nhrih (mƀih mƀeh), lĕ drăp ndơ may, sŏ dŏng gŭ đah bu ur êng êng, yơn ma tât ma păng plơ̆ sât may lăch kon ndrôk i pêt ăn ma păng ro’. ");
INSERT INTO cmo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","I bơ̆ ơh ma păng: ‘Hơi nô, may gŭ ndrel gâp mro, lĕ ndơ gâp hôm geh nơh jêng ndơ may đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yorlah oh may i nây nơh tâm ban ma khât, aƀaơ dja lĕ rêh jât, păng nơh roh, aƀaơ dja lĕ bân say đŏng, lah ndri ăn bân nhêt sông sa maak’.” ");
INSERT INTO cmo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jêh ri Brah Yêsu lah ma mpôl oh mon Păng: “Geh du huê bunuyh ndrŏng, păng ăn du huê bunuyh jan kar mât uănh drăp ndơ păng. Jêh ri geh bu brô̆ mbơh ma bunuyh ndrŏng i nây lah, bunuyh i mât uănh i nây dơ̆ nhrih (mƀih mƀeh) drăp ndơ păng dŭt hô. ");
INSERT INTO cmo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jêh ri bunuyh i ndrŏng kuăl bunuyh i mât uănh i nây lah: ‘Lŏng may nkoch ma gâp i drăp ndơ gâp may mât uănh, moh ndơ lĕ geh aƀaơ dja? Yorlah lĕ nau gâp tăng bu nkoch ma may mâu ôh geh nau ueh, ndri may mâu hôm ôh mât uănh drăp ndơ gâp jât’. ");
INSERT INTO cmo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bunuyh i nây nklŏn êng ta săk păng nơm ri: ‘Bah kôranh mâu ôh ăn gâp mât uănh drăp ndơ păng jât. Lah ndri moh ndơ jan gâp i ri tay? Lah pŏk neh hŏ mâu dơi, lah dăn bu hŏ đit. ");
INSERT INTO cmo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ô! Gĭt hơyh, gâp mra jan kơt nđa, gay ma bu rom gâp gŭ ta jay khân păng, lah păng mâu hôm ăn gâp jan kar dja tay’. ");
INSERT INTO cmo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jêh ri păng kuăl dâng lĕ bunuyh i hôm rnon đah kôranh păng ri nơh, ăn lăp du huê du tơ̆, păng ôp bunuyh i bơh năp ri: ‘Dah ŏk may hôm rnon ma kôranh gâp mêh?’ ");
INSERT INTO cmo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bunuyh i nây mbơh ma păng: ‘Hôm ngi 100 yăng dŭng yăng kreng’. Păng lah ma bunuyh i nây: ‘Sŏ ngăch hŏm samƀŭt rnon may nchih tê̆ lah 50 yăng dŭng yăng kreng hŏ’. ");
INSERT INTO cmo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jêh ri păng ôp du huê bunuyh jât: ‘May dah ŏk hôm rnon ma kôranh gâp mêh?’, bunuyh i nây mbơh ma păng: ‘Hôm ba 100 sah’. Păng lah ma bunuyh i nây: ‘Sŏ samƀŭt rnon may hŏm nchih tê̆ lah 80 sah hŏ’. ");
INSERT INTO cmo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jêh ri i kôranh ri rnê ma bunuyh mât uănh kue i nây, yorlah păng blao gĭt mân ngăn. Ndri bunuyh mâu iăt nau Kôranh Brah blao rlau bunuyh iăt, yorlah khân păng blao joi sa, gay ma geh nau rêh ueh ta neh ntu dja. Yơn ma bunuyh iăt nau Kôranh Brah mâu ôh blao kơt khân păng gŭ rêh gĭt ma nau rêh ueh ta nar jât năp tay.” ");
INSERT INTO cmo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Gâp mbơh ma khân ay may, nôk khân ay may hôm gŭ ta neh ntu dja, pă drăp ndơ khân ay may nơm jan mât jăng ndrel bunuyh ŏk, gay ma tât khân ay may khât sât ƀon ueh ta kalơ trôk ri, mât jăng khân ay may nây rom gŭ ndrel n'ho ro. ");
INSERT INTO cmo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Bu moh sŏng ma jan ndơ jê̆, păng sŏng ma jan ndơ kuŏng đŏng. Bu moh kue ma jan ndơ jê̆, păng kue ma jan ndơ kuŏng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Lah ndri, lah khân ay may mâu sŏng ŭch sa nsiăn ma drăp ndơ khân ay may nơm ta neh ntu dja, Kôranh Brah mâu ôh ăn ma khân ay may drăp ndơ i geh nau khlay ngăn ta ƀon ueh ta kalơ. ");
INSERT INTO cmo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Lah khân ay may mâu sŏng ma drăp ndơ bu êng, mơm Kôranh Brah dơi ăn drăp ndơ ma khân ay may ta ƀon ueh ta kalơ? ");
INSERT INTO cmo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mâu geh ôh du huê bunuyh dơi jan kar ăn ma bar hê kôranh, yorlah păng mra rŏng ma du huê kôranh, jêh ri biănh ma du huê kôranh i êng, mâu lah tâng jât du huê, mưch i du huê i êng ri. Kơt ndri khân ay may yơk mbah ma Kôranh Brah đŏng, yơk mbah ma drăp ndơ ta neh ntu đŏng mâu dơi ôh.” ");
INSERT INTO cmo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Geh phung Pharisi tăng nau ngơi kơt nây, khân păng gơm mưch ma Brah Yêsu, yorlah khân păng nơh rŏng ma prăk ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Brah Yêsu lah ma khân păng: “Khân may jêng phung ŭch jan sŏng ăn măt bunuyh say, yơn ma Kôranh Brah lĕ gĭt jêh nuih n'hâm khân may. Geh ŏk ndơ i bunuyh kơp khlay, tih ma Kôranh Brah biănh ngăn ndơ i nây. ");
INSERT INTO cmo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Samƀŭt Nau Vay phung bân, ndrel ma samƀŭt bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, dâng lĕ ndơ lĕ geh nchih ta nây Kôranh Brah ăn phung bân iăt, n'ho ma tât Yôhan-Ƀaptem ntơm ntŭm nti bu. Tă bơh Yôhan-Ƀaptem i nây Gâp mbơh nkoch nti nau mhe mhan ueh ma nau Kôranh Brah ŭch mât uănh bunuyh. Ăn dâng lĕ bunuyh nsrôyh gay ma Kôranh Brah mât uănh ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yơn ma nau vay phung bân i Kôranh Brah ăn mâu ôh dơi rgâl. Trôk, ndrel ma neh ntu blao roh, yơn ma ta nau vay i nây bol lah ta nau i dŭt jê̆ kađôi mâu ôh blao roh. ");
INSERT INTO cmo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ntât lah bu moh ntlơi ur, jêh ri sŏ tay ur êng jât, bu klô i nây jêng bunuyh lŏm ur. Bu moh sŏ ur đah bu ur sai ntlơi, bu klô i nây jêng bunuyh lŏm ur đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jêh ri Brah Yêsu ngơi jât: “Geh du huê bu klô ndrŏng, păng nsoh n'gut ma bok ao i ueh ueh ngăn, sŏ bơh bok sut bok hul, păng gŭ rêh maak ngăn sông sa piăng trao kah ngăn ŏk rmeh ăp nar. ");
INSERT INTO cmo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Geh đŏng du huê bu klô o ach rnha păng Lasar, lam săk jăn păng geh sôt grayh dadê, bu leo păng ăn bêch ta bôk mpông jay bunuyh ndrŏng i nây. ");
INSERT INTO cmo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Păng ŭch ngăn sa piăng ndăk trao ndăk i trôh bơh lơ nsưng sông bunuyh ndrŏng i nây gay ma bah ji ngot, geh nđâp ma so hăn ler sôt grayh păng ta ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tât du nar bunuyh o ach i nây khât, jêh ri phung tông păr leo păng gŭ ndrel Abrahăm i che phung bân ta ƀon ueh ta kalơ gay ma gŭ rêh ueh ta ri. Bunuyh ndrŏng i nây khât đŏng, bu leo tŏp păng ta môch. ");
INSERT INTO cmo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jêh ri păng gŭ ta bri phan, ta bri phan ri geh nau rêh rnhăl krit jêr dŭt hô ngăn ma bunuyh ndrŏng i nây, păng n'gơr uănh say che Abrahăm bơh ngai, ndrel ma Lasar gŭ kêng păng ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bunuyh ndrŏng i nây nter kuăl che Abrahăm: ‘Hơi che! Dăn may yô̆ nđach ma gâp ƀă ơ. Sơm đă Lasar đă păng yŭk dak ma lau ti, jêh ri ntrôh ta mpiăt gâp dja ăn ma nđik oi, yorlah gŭ ta ŭnh dja geh nau rêh nji dŭt hô ngăn’. ");
INSERT INTO cmo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Che Abrahăm ơh ma păng: ‘Hơi sau! Ăn may kah gĭt, dôl may hôm rêh ta neh ntu nơh, may lĕ năl ma nau ueh ngăn, lŏng Lasar dja păng năl ma nau djơh dơm. Aƀaơ dja Lasar lĕ geh nau bonh ta dja hơi, i may nây may gŭ ta nau rêh nji dŭt hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Geh đŏng ntu brŏng dŭt huy vah vang hên ma may, kơt ndri dâng bu moh ŭch hăn bơh ntŭk dja jât ntŭk may nây, bơh ntŭk may jât ntŭk hên dja, suang mâu dơi ôh’. ");
INSERT INTO cmo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bunuyh ndrŏng i nây lah ma che Abrahăm: ‘Hơi che! Lah kơt ndri, khât ôm lôm lă, dăn may đă Lasar hăn ta jay bơ̆ gâp ri ơ, ");
INSERT INTO cmo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","yor ma gâp geh prăm nuyh oh nô bu klô lah. Đă păng mbơh ma khân păng, ăn khân păng kah gĭt njrăng săk, gay ma lơi ôh ăn hăn ta ntŭk nau rêh rnhăl dŭt hô dja’. ");
INSERT INTO cmo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Che Abrahăm ơh ma păng: ‘Oh nô may lĕ geh samƀŭt Môsê, ndrel ma samƀŭt bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh, lah ndri ăn khân păng iăt dâng lĕ ndơ i mpôl khân păng i nây geh nchih ta nây dô’. ");
INSERT INTO cmo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bunuyh ndrŏng jŏl ơh ma păng jât: ‘Mâu ôh! Hơi che, ăn geh du huê bunuyh i tă bơh khât hăn mbơh, ri mơ khân păng rgâl lơi nuih n'hâm djơh’. ");
INSERT INTO cmo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Che Abrahăm ơh ma păng: ‘Lah khân păng mâu iăt nau Môsê, ndrel ma nau bunuyh ntơyh nau ngơi Kôranh Brah lĕ geh nchih, bol lah geh bunuyh khât dâk rêh hăn mbơh ma khân păng, kŏ khân păng mâu iăt đŏng’.” ");
INSERT INTO cmo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Geh du nar Brah Yêsu lah ma mpôl oh mon Păng: “Geh ŏk ntil jan ăn bunuyh geh jan tih. Tih ma rêh rnhăl ngăn ma bu moh i leo bu jan tih, Kôranh Brah tê̆ dôih dŭt kuŏng ngăn ma bunuyh i nây. ");
INSERT INTO cmo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ueh rlau lah bu sŏ mpăl lŭ kât ta tong ko păng, jêh ri nklăch păng ta dak văch dak văr ri, ma đah ăn rong păng rêh leo du huê bunuyh nsing jê̆ jan tih. ");
INSERT INTO cmo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ăn khân ay may njrăng săk khân ay may nơm. Lah geh oh nô jan tih, ăn khân ay may lah ntŭm păng, lah păng rgâl lơi nuih n'hâm djơh, ăn khân ay may yô̆ ma păng. ");
INSERT INTO cmo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Lah păng jan tih ma khân ay may pơh tơ̆ ta du nar, jêh ri păng plơ̆ ngơi ma khân ay may pơh tơ̆ đŏng ta du nar, păng lah: ‘Lĕ lăn gâp jan tih nơh mê’, ăn khân ay may yô̆ ma păng ro.” ");
INSERT INTO cmo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mpôl kôranh oh mon lah ma Brah Yêsu: “Dăn May ăn nau nsing ma hên lơ ma jru jât ơ.” ");
INSERT INTO cmo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Brah Yêsu lah ma khân păng: “Lah khân may geh nau nsing jê̆ tâm ban ma du găr ntil dŭt jê̆, jêh ri khân may lah ma tơm si kuŏng dja: ‘Rôk ryeh may hon ta nklang dak văch dak văr ri’, păng mra iăt nau khân may ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ta mpôl khân may, lah geh du huê bunuyh păng geh dâk hăn jan kar ta mir, mâu lah chiăp be biăp, tât păng plơ̆ sât bơh mir ri, i kôranh ri ngơi ma dâk i nây: ‘Gŭ sông sa ƀŏt’, ndri bơh? ");
INSERT INTO cmo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mâu ndri ôh, kôranh i nây mra lah ma păng kơt nđa ro: ‘Ndrăp piăng trao ăn ma gâp, jêh ri may tơh kho ao răk ăn gâp sông, kŏp jêh gâp sông dâng may sông bơh kơi’. ");
INSERT INTO cmo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ah kôranh lah ueh ma dâk i nây bơh, say păng jan tâng nau kôranh đă? Mâu ôh! ");
INSERT INTO cmo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Khân may tâm ban đŏng, dôl khân may jan kar tâng nau Kôranh Brah đă ăp lĕ phiao jêh, ăn khân may lah: ‘Hên jêng dâk Kôranh Brah dơm, hên jan kar moh ndơ i hên di jan dơm’.” ");
INSERT INTO cmo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dôl Brah Yêsu hăn jât ƀon kuŏng Yêrusalem, păng hăn rŏ n'hăr bri Samari, đah bri Galilê. ");
INSERT INTO cmo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jêh ri Brah Yêsu hăn lăp rŏ du ƀon, geh mpôl phŭng sa jât nuyh hăn mâp păng. Tâng nau vay, buay khân păng mâu ăn gŭ dăch ma bunuyh êng, ndri dâng khân păng gŭ bơh ngai nter kuăl: ");
INSERT INTO cmo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Hơi Kôranh Yêsu, dăn yô̆ nđach jan bah ma hên ƀă ơ.” ");
INSERT INTO cmo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Brah Yêsu uănh jât khân păng, jêh ri lah: “Hăn nhhơ săk khân may nây ăn ma mpôl jan brah uănh a ri, gay ma gĭt năl bah nau ji.” Khân păng lôh bơh Brah Yêsu nây, dôl khân păng hăn rŏ trong, nau ji phŭng sa lĕ khân păng ri nơh dô ma bah kloh dadê ro. ");
INSERT INTO cmo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tât ma say săk khân păng nơm bah kloh lĕ phiao kơt nây, geh du huê ta mpôl i nây păng plơ̆ jât kơi dja, nkre ma rnê ma Kôranh Brah dŭt nteh nteh ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tât ta nây păng păn ta jŏng Brah Yêsu ri, kŭnh bôk jât neh, jêh ri lah ueh ma Kôranh Brah. Bunuyh i nây mpôl bri Samari, mâu ôh di phung Israel. ");
INSERT INTO cmo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jêh ri Brah Yêsu lah: “Mâu di mpôl i jât nuyh bah dadê, lah ndri mpôl i mbŏl tôr sân nuyh ah jât gŭ? ");
INSERT INTO cmo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Geh du huê mpôl bri êng dja dơm bơh, plơ̆ rnê ma Kôranh Brah?” ");
INSERT INTO cmo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jêh ri păng lah ma bunuyh i nây jât: “May dâk hăn ri hŏm, nau may nsing jan bah nau ji may.” ");
INSERT INTO cmo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Geh du nar phung Pharisi ôp Brah Yêsu, dah jŏ nau Kôranh Brah mât uănh văch. Brah Yêsu ơh ma khân păng: “Nau Kôranh Brah mât uănh văch mâu geh ôh nau say ma măt bunuyh. ");
INSERT INTO cmo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mâu geh ôh bunuyh dơi lah: ‘Nau Kôranh Brah mât uănh ta ntŭk dja’, mâu lah ‘Ta ntŭk ri’. Ăn khân may gĭt lah, nau Kôranh Brah mât uănh geh ta nuih n'hâm bunuyh.” ");
INSERT INTO cmo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Brah Yêsu lah ma oh mon Păng: “Jât năp tay, khân ay may ŭch say nar Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch, gay ma mât uănh khân ay may ta nau dơi Kôranh Brah, tih ma khân ay may mâu say ôh. ");
INSERT INTO cmo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nôk nây geh bu mbơh ma khân ay may lah: ‘Kôranh Brah ta ntŭk dja’, mâu lah ‘Ta ntŭk ri’, khân ay may lơi ôh iăt khân păng, lơi ôh hăn uănh. ");
INSERT INTO cmo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yorlah nar Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch, tâm ban ma lơp nglayh ang chrat bơh jŏng trôk du ding tât ma jŏng trôk du ding, kơt nây đŏng lam neh ntu mra gĭt say nar Gâp plơ̆ văch. ");
INSERT INTO cmo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yơn ma ê lor ma tât nar i nây nơh, Gâp i Kon Bunuyh tă bơh Kôranh Brah mra geh nau jêr jŏt dŭt hô lor, jêh ri bunuyh ta rnôk aƀaơ dja mƀăr lơi Gâp đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ta nôk Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch nây, jêng tâm ban ma rnôk Nôê kăl e nơh đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Rnôk nây bunuyh gŭ nhêt sông sa, nđăp ur sai lơh mir jan ba, bă oh bă kon, n'ho ma tât nar Nôê lăp ta trôm duk kuŏng ri, jêh ri dak lêng dak dơng bŭk lơh hêng khân păng lĕ phiao. ");
INSERT INTO cmo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nar Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch, jêng tâm ban ma rnôk Lŭt kăl e nơh đŏng. Rnôk nây bunuyh gŭ nhêt sông, tăch rgâl drăp ndơ, tuch tăm, ndrel ma jan nhih jan jay ăp nar ăp nar. ");
INSERT INTO cmo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","N'ho ma tât nar Lŭt du lôh bơh ƀon Sôđŭm nây, geh ŭnh, ndrel ma lŭ hit ŭnh tă bơh kalơ trôk ti tâm ban ma tŭp mih ngăn, jan hêng lĕ phiao bunuyh ta ƀon Sôđŭm i nây. ");
INSERT INTO cmo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nar Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch nsôh săk, jêng tâm ban ma kơt nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ta nar i nây, lah bu moh gŭ kalơ chor jay lŏng, lah păng geh drăp ndơ ta trôm jay lơi ôh jŭr lăp sŏ, ăn păng jŭr du nchuăt hŏ. Bu moh i gŭ ta mir tâm ban kơt nây đŏng, lơi ôh plơ̆ ta jay ma sŏ ndơ, ăn du nchuăt hŏ. ");
INSERT INTO cmo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ăn kah gĭt nau tât ma i ur Lŭt, păng khât yorlah păng n'gâl jât kơi nôk khân păng du bơh ƀon Sôđŭm. ");
INSERT INTO cmo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yorlah bu moh i ŭch prăp ma nau rêh păng nơm, păng i nây mâu ôh geh nau rêh n'ho ro, yơn ma bu moh roh nau rêh yor ma tâng Gâp, păng i nây geh nau rêh n'ho ro ngăn ta nar jât năp tay. ");
INSERT INTO cmo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Gâp mbơh ma khân ay may, ta nar nây lah geh bar hê bunuyh bêch ta du mlŏm gre dơm ta nôk măng, du huê Kôranh Brah sŏ ăn gŭ ta ƀon ueh ta kalơ, hôm rong du huê ma tê̆ dôih. ");
INSERT INTO cmo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Geh bar hê bu ur peh tâm răp, du huê Kôranh Brah sŏ ăn gŭ ta ƀon ueh ta kalơ, hôm rong du huê ma tê̆ dôih. ");
INSERT INTO cmo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Lah bar hê bu klô gŭ ta mir, du huê Kôranh Brah sŏ hôm rong du huê.” ");
INSERT INTO cmo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Oh mon ôp Brah Yêsu: “Hơi Kôranh, ah ntŭk geh nau i nây mêh?” Brah Yêsu ơh ma khân păng: “Ah ntŭk geh ndơ khât, grŏt mra rgum băl mpăr ndăch ta ntŭk i nây đŏng, kơt ndri ndơ i nây ăn mpơl ma bunuyh say bơh ngai.” ");
INSERT INTO cmo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jêh ri Brah Yêsu ntŭm nti mpôl oh mon Păng, ăn mbơh sơm ƀaƀơ, lơi ôh dâl nuih n'hâm. ");
INSERT INTO cmo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Păng ngơi ntât: “Ta du ƀon geh du huê kôranh phat dôih, păng bunuyh mâu ôh gĭt klach ma Kôranh Brah, mâu kă mâu rnam ma bunuyh đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ta ƀon nây geh đŏng du huê bu ur ndrô khât sai đă păng phat dôih ƀaƀơ ngăn. Bu ur ndrô i nây lah: ‘Hơi kôranh, đă may sơm phat dôih ma bunuyh i jan tih ma gâp ơ’. ");
INSERT INTO cmo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Păng rlăch mâu ŭch phat dôih ăn ma bu ur nây lĕ jŏ nar ngăn, yơn ma jât năp tay păng mân êng ta nuih n'hâm ri: ‘Bol lah gâp mâu gĭt klach ma Kôranh Brah, mâu gĭt srim mâu gĭt rmach ma bunuyh kađôi lĕ, ");
INSERT INTO cmo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","gâp hôm phat dôih ăn ma bu ur ndrô dja đŏng, yorlah păng brô̆ rkhuak gâp ƀaƀơ ngăn. Lah gâp mâu ôh phat dôih ăn ma păng, păng hôm đă gâp jŏl ko đŏng, ăn gâp dâl’.” ");
INSERT INTO cmo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Brah Yêsu lah jât: “Lŏng iăt moh nau kôranh phat dôih djơh dja păng ngơi nơh. ");
INSERT INTO cmo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kôranh Brah rlau ma nây, Păng sơm kơl ăn ma khân ay may i bunuyh lĕ Păng kơih, i joi kuăl Păng dâng măng dâng nar. Ah Păng jan mbrĕ mbrơi ma khân ay may bơh? ");
INSERT INTO cmo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mâu ôh, Gâp mbơh ma khân ay may, Kôranh Brah sơm kơl ăn ma Păng gơnh ro. Yơn ma dôl Gâp i Kon Bunuyh tă bơh Kôranh Brah plơ̆ văch ta neh ntu dja, hôm say bunuyh geh nau nsing kơt nđa đŏng lah mâu?” ");
INSERT INTO cmo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jêh ri Brah Yêsu ngơi du nau ntât jât ăn ma bunuyh i kơp êng săk păng nơm jêng bunuyh sŏng ta bơh năp Kôranh Brah, jêh ri mưch ma bu êng. ");
INSERT INTO cmo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Păng lah kơt nđa: “Geh bar hê bu klô hăn mbơh sơm ta jŏng gung nhih jan brah. Du huê phung Pharisi, du huê jât mpôl kŏp sŏ prăk bơh bu ma ăn kôranh mât uănh. ");
INSERT INTO cmo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Păng i Pharisi ri dâk du huê êng păng nơm mbơh sơm bơh dja lah: ‘Hơi Kôranh Brah, gâp lah ueh ma May, yorlah gâp mâu ôh kơt bunuyh aƀă êng, lĕ mpôl i nây jêng bunuyh ntŭng, bunuyh kue, bunuyh lŏm ur lŏm sai, jêh ri gâp mâu tâm ban ma bunuyh kŏp sŏ prăk bu i nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Lŏng gâp dja ăt sông sa rlau ma bunuyh êng du pơh ăt bar nar, jêh ri sŏ ndơ geh jât ơ̆ rhuăt nguai nhhơr ma Kôranh Brah lĕ ndơ gâp mhe geh đŏng’. ");
INSERT INTO cmo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Lŏng păng i kŏp sŏ prăk bu ri, dâk bơh ngai mâu bănh đŏng n'gơr măt jât lơ ma Kôranh Brah. Păng ntŭr ntang ntơh păng nơm yor ma păng rngot ma nau tih păng nơm, păng lah: ‘Hơi Kôranh Brah, dăn May yô̆ nđach ma gâp, gâp jêng bunuyh tih’. ");
INSERT INTO cmo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Gâp mbơh ma khân may, khân păng plơ̆ sât ta jay, Kôranh Brah kơp du huê bunuyh dja jêng bunuyh lĕ sŏng, lĕ yô̆ nau tih păng, tih ma du huê phung Pharisi i nây Kôranh Brah mâu ôh kơp jêng bunuyh sŏng, mâu ôh yô̆ nđach nau tih păng. Yorlah bu moh i n'hao êng săk păng nơm, Kôranh Brah njŭr lơi, bu moh i njŭr săk păng nơm, Kôranh Brah de n'hao păng.” ");
INSERT INTO cmo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Geh du nar bu leo kon se jê̆ jê̆ hăn ta Brah Yêsu, gay ma đă Păng pah ti ta kon se i nây ăn nau geh jêng ma khân păng. Tât ma mpôl oh mon say kơt nây, khân păng buay lơi hăn dăch a Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yơn ma Brah Yêsu kuăl mpôl kon se i nây hăn a Păng, jêh ri Păng lah ma mpôl oh mon Păng: “Ăn phung kon se văch ta Gâp, lơi ôh buay păng, yorlah khân păng mâu ôh n'hao êng săk khân păng nơm, yơn ma nsing ma mê̆ bơ̆ hô ngăn, bunuyh i Kôranh Brah ŭch mât uănh khân păng geh kơt ndri đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, bu moh mâu ôh tâm ban ma kon se jê̆ dja, mâu geh ôh Kôranh Brah rom păng ma mât uănh.” ");
INSERT INTO cmo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Geh du huê kôranh phung Israel ôp Brah Yêsu kơt nđa: “Hơi Nơm Nti ueh, mơm gâp jan mêh, gay ma geh nau rêh n'ho ro tay?” ");
INSERT INTO cmo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Brah Yêsu ơh ma păng: “Mơm dâng may kuăl Gâp ‘ueh’ kơt nây mêh? Mâu geh ôh du huê bunuyh ueh, geh du huê Kôranh Brah dơm ueh. ");
INSERT INTO cmo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","May lĕ gĭt jêh ta nau vay phung bân lah: ‘Lơi lŏm ur lŏm sai, lơi nkhât bu, lơi ntŭng, lơi ngơi nchơt, jêh ri yơk ma mê̆ bơ̆ hŏ’.” ");
INSERT INTO cmo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bu klô i nây ơh ma Brah Yêsu: “Dâng lĕ nau vay i nây gâp ndjôt ntơm bơh jê̆ ngăn.” ");
INSERT INTO cmo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tât Brah Yêsu tăng kơt nây, jêh ri Păng lah ma bu klô i nây: “Hôm du ntil may mâu hŏ jan, tăch lĕ drăp ndơ may, pă ăn ma mpôl o ach, ri mơ may geh ndơ khlay ta ƀon ueh ta kalơ, jêh ri dâng hăn tâng Gâp.” ");
INSERT INTO cmo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jêh tăng kơt nây, păng rvê nhhuach hô ngăn, yorlah păng jêng bunuyh ndrŏng geh drăp ndơ ŏk ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Dôl Brah Yêsu say bunuyh ndrŏng nây geh nuih n'hâm rvê, Păng lah: “Jêr ngăn ma bunuyh ndrŏng ăn Kôranh Brah mât uănh khân păng, ");
INSERT INTO cmo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","jêr rlau ma ăn seh samô lăp ta trôm nglai.” ");
INSERT INTO cmo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bunuyh i tăng nau Brah Yêsu lah nây, khân păng ôp: “Lah bunuyh ndrŏng lĕ geh jêr jêh ma ăn Kôranh Brah mât uănh khân păng, lah ndri bunuyh a êng hôm dơi ăn Kôranh Brah mât uănh đŏng lah mâu?” ");
INSERT INTO cmo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Brah Yêsu ơh ma khân păng: “Ndơ bunuyh jan mâu blao, Kôranh Brah jan hôm blao, bunuyh mâu ôh blao rklaih êng săk păng nơm, yơn ma Kôranh Brah hôm blao rklaih.” ");
INSERT INTO cmo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pêtrôs lah ma Brah Yêsu: “May lĕ say hên jêh, lĕ ndơ hên geh hên mƀăr lơi, jêh ri tâng May, lah ndri mơm hên mêh?” ");
INSERT INTO cmo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Brah Yêsu lah ma khân păng: “Gâp lah n'hêl nanê̆ ngăn ma khân ay may, bu moh mƀăr nhih jay, ur kon, mê̆ bơ̆, ndrel ma oh nô, yor ma ăn Kôranh Brah mât uănh ma păng, ");
INSERT INTO cmo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","bunuyh i nây păng dơn ndơ geh ŏk rlau i nây ta nôk aƀaơ dja, ndrel ma geh nau rêh n'ho ro đŏng ta nar jât năp tay.” ");
INSERT INTO cmo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Brah Yêsu leo lĕ 12 kôranh oh mon hăn ta ntŭk êng ndrel Păng nơm. Păng lah ma khân păng nây: “Aƀaơ dja bân hăn ta ƀon kuŏng Yêrusalem, yorlah lĕ nau bunuyh ntơyh nau ngơi Kôranh Brah lĕ nchih kăl e nơh nkoch ma Gâp i Kon Bunuyh tă bơh Kôranh Brah, nau i nây tât ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yorlah bu njŭn Gâp i Kon Bunuyh tă bơh Kôranh Brah ăn ma phung i mâu di phung bân. Phung i nây gơm n'grơh Gâp, rak suai, ndrel ma soh dak diu ta Gâp đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bu rpăt Gâp ma mŏng rse, jêh ri nkhât lơi Gâp, yơn ma pe nar bơh kơi nây Gâp dâk rêh jât.” ");
INSERT INTO cmo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lĕ mpôl kôranh oh mon mâu vât ôh nau Brah Yêsu ngơi i nây, khân păng mâu vât moh nau Păng ŭch lah, yorlah nau i nây hôm mo ma khân păng ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dôl Brah Yêsu hăn bơi tât ƀon Yêrikhô, geh du huê bunuyh cheh măt gŭ dăn bu ta meng trong ri. ");
INSERT INTO cmo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Dôl păng tăng nteh bunuyh phung hăn rŏ trong nây, păng ôp bu: “Moh geh nau hiah?” ");
INSERT INTO cmo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bu mbơh ma păng: “Nơm nti Yêsu tă bơh ƀon Nasaret, Păng hăn rŏ trong dja.” ");
INSERT INTO cmo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jêh ri bunuyh cheh măt ntơm nter: “Hơi Kôranh Yêsu kon sau kađăch Đavid! Yô̆ nđach ma gâp ƀă ơ!” ");
INSERT INTO cmo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bu i brô̆ bơh năp nây buay păng đă gŭ iăt săk hŏ, yơn ma păng lơ ma nter dŭt nteh nteh: “Hơi kon sau kađăch Đavid! Yô̆ nđach ma gâp ƀă ơ!” ");
INSERT INTO cmo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Brah Yêsu nsrŭng, jêh ri đă bu leo bunuyh nây a Păng. Bunuyh cheh măt nây hăn tât ta ri, jêh ri Brah Yêsu ôp: ");
INSERT INTO cmo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Moh may ŭch ăn Gâp jan ma may mêh?” Bunuyh cheh măt nây ơh: “Hơi Kôranh, ăn măt gâp say ang.” ");
INSERT INTO cmo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Brah Yêsu lah ma păng: “Ang hŏm, nau may nsing ma Gâp lĕ rklaih may jêh.” ");
INSERT INTO cmo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jêh ri măt păng dô ma say ang ro, păng tâng Brah Yêsu bơh kơi, nkre ma rnê ma Kôranh Brah. Lĕ bunuyh i say nau nây khân păng rnê ma Kôranh Brah dadê đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jêh ri Brah Yêsu lăp ta ƀon Yêrikhô ri, Păng hăn rŏ ƀon i nây. ");
INSERT INTO cmo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Geh du huê bu klô rnha Sakhê, păng jêng kôranh ma mpôl kŏp sŏ prăk bơh bu ma ăn kôranh mât uănh, păng ndrŏng geh drăp ndơ ŏk ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Păng ŭch ngăn say Brah Yêsu, tih ma săk păng nơh dêh, ndrel ma geh bunuyh ŏk ir, kơt ndri păng uănh Brah Yêsu mâu dơi say ôh. ");
INSERT INTO cmo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jêh ri păng nchuăt bơh năp ri, hao kalơ tơm Rvi, kŏp uănh Brah Yêsu hăn rŏ nây. ");
INSERT INTO cmo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Brah Yêsu brô̆ rŏ trong nây, tât ta tơm si nây Păng n'gơr uănh jât lơ, jêh ri lah ma Sakhê: “Hơi nô Sakhê, may jŭr hŏm, yorlah Kôranh Brah đă Gâp gŭ bêch ta jay may nar dja.” ");
INSERT INTO cmo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jêh ri păng jŭr ro, rom Brah Yêsu păng răm maak ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dôl say kơt nây, bu ŏk bâr njâr sêk ngăn, bu lah: “Yi! Uănh Păng i nây! Hăn ta jay bunuyh tih.” ");
INSERT INTO cmo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tât ta jay nây Sakhê dâk lah ma Brah Yêsu: “Hơi Kôranh, gâp pă drăp ndơ gâp n'gul ăn ma mpôl o ach, lah gâp lĕ sŏ prăk bu rlau keh nơh, gâp tŏm ma bu nguai lôh puăn.” ");
INSERT INTO cmo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Brah Yêsu lah ma păng: “Nar dja nau rklaih lĕ tât jêh ma bunuyh ta jay dja, yorlah may dja nsing ma Kôranh Brah, tâm ban ma che Abrahăm bân đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Gâp i Kon Bunuyh tă bơh Kôranh Brah de njuăl văch gay ma joi, ndrel ma rklaih bunuyh tih i roh yot nuih n'hâm ngai bơh Kôranh Brah tâm ban ma du mlŏm be biăp hiơt.” ");
INSERT INTO cmo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ta ntŭk khân păng gŭ nây mâu geh ngai bơh ƀon Yêrusalem. Jêh khân păng tăng Brah Yêsu ngơi kơt ndri, khân păng gĭt vĭ lah Brah Yêsu hăn jât ƀon i nây gay ma jêng kađăch. Ndri Brah Yêsu ngơi ntât du nau jât ");
INSERT INTO cmo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","lah: “Geh du huê bu klô jêng bunuyh ndrŏng, păng deh ta rnoi deh kađăch, păng ndrăp hăn ta bri ngai gay ma bu ntăm păng jêng kađăch ta bri păng nơm, tât ma lĕ jêng jêh, jêh ri tay păng plơ̆ sât đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ê lor păng ma hăn, păng kuăl dâk jât nuyh, jêh ri ăn prăk jât kăk kuŏng ma khân păng du huê du huê du kăk, păng lah: ‘Prăk dja ăn khân mre ma joi sa, n'ho ma tât gâp plơ̆ sât tay’. ");
INSERT INTO cmo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tih ma geh bunuyh ŏk ta bri i nây mâu ŭch ôh ma păng, jêh ri khân păng njuăl bunuyh a êng jât hăn tâng bơh kơi đă mbơh nau kơt nđa: ‘Hên mâu ŭch ôh ăn bunuyh dja jan kađăch ma hên’. ");
INSERT INTO cmo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tât păng lĕ geh jan kađăch, păng plơ̆ sât bơh ri, jêh ri păng kuăl lĕ dâk i păng ăn prăk nây nơh ôp, gay ma ŭch gĭt dah ŏk geh lôh kon prăk du huê du huê. ");
INSERT INTO cmo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dâk i lor bơh năp bu nây păng mbơh: ‘Hơi kôranh, prăk i may ăn ma gâp nơh, geh lôh kon jât kăk kuŏng jât’. ");
INSERT INTO cmo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jêh ri kađăch i nây lah ma păng: ‘May jan ueh ngăn, hơi dâk ueh, gâp mra ăn may mât uănh jât ơ̆ ƀon, yorlah nau kar jê̆ dja may jan răp jăp ngăn’. ");
INSERT INTO cmo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jêh ri dâk tŏl bar lah: ‘Hơi kôranh, prăk i may ăn ma gâp nơh, geh lôh kon prăk prăm kăk jât’. ");
INSERT INTO cmo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jêh ri kađăch nây lah ma păng: ‘Ndri gâp ăn may mât uănh prăm mlŏm ƀon’. ");
INSERT INTO cmo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jêh ri dâk i du huê ri jât hăn mbơh ma kađăch: ‘Hơi kôranh, dja prăk i may ăn ma gâp nơh hôm kơt ơm, gâp nklŏm prăp păng ma bok prăp ăn ueh dơm. ");
INSERT INTO cmo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Gâp klach may, yorlah may jêng bunuyh janh. May sŏ ndơ i mâu di ndơ may nơm, kăch ba i may nơm mâu geh tuch’. ");
INSERT INTO cmo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jêh ri păng lah ma dâk i nây: ‘Hơi dâk djơh! Gâp mra tê̆ dôih may tâng nau may lah nơh. May lĕ gĭt jêh gâp jêng bunuyh janh, gâp sŏ ndơ i mâu di ndơ gâp nơm, kăch ba i mâu geh gâp nơm tuch. ");
INSERT INTO cmo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Lah ndri khân may sŏ prăk gâp nây ăn ta ntŭk jay bu manh prăk, tât gâp sât bơh ri tay, bu trŏ prăk ơm, ndrel ma geh lôh kon prăk đŏng’. ");
INSERT INTO cmo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jêh ri păng lah ma mpôl i gŭ ta nây: ‘Sŏ lơi prăk i nây bơh păng, ăn ma bunuyh i geh jât kăk nây’. ");
INSERT INTO cmo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mpôl khân păng nây lah: ‘Hơi kôranh, păng lĕ geh jât kăk jêh’. ");
INSERT INTO cmo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Păng ơh: ‘Gâp mbơh ma khân ay may, bu moh jan răp jăp ma ndơ păng geh, bu mra ntop ăn ma păng, bu moh mâu jan răp jăp ma ndơ păng geh, bol lah ndơ i đê̆ păng geh bu mra sŏ lơi bơh păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jêh ri đŏng, mpôl i mâu ăn gâp jan kađăch nơh, ăn khân may nkhât lơi khân păng ăn lĕ phiao bơh năp măt gâp’.” ");
INSERT INTO cmo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Lôch jêh Brah Yêsu ngơi nau i nây, jêh ri Păng hăn jât, hao jât ƀon kuŏng Yêrusalem ri. ");
INSERT INTO cmo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bơi tât ƀon Ƀêtphasê, đah ma ƀon Ƀêthani, ta yôk i bu kuăl lah yôk tơm Ôlive ri, Brah Yêsu đă bar hê oh mon hăn lor, ");
INSERT INTO cmo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Păng lah ma khân păng: “Ăn khân may hăn ta ƀon bơh năp ri, lăp ta ƀon nây khân may mra say du mlŏm kon seh lia bu kât ta nây, seh lia i nây ê hŏ geh bu ncho ôh, ăn khân may drih têk păng bơh ri a dja. ");
INSERT INTO cmo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Lah geh bu ôp khân may: ‘Moh jan drih khân mre nây mêh?’, khân may ơh lah: ‘Kôranh ŭch ncho păng’.” ");
INSERT INTO cmo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jêh ri bar hê oh mon i nây hăn a ri, tât a ri say kơt nau Brah Yêsu mbơh nơh ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dôl bar hê oh mon i nây drih kon seh lia i nây, geh khân păng i tơm seh lia ri lah: “Moh jan drih khân mre nây mêh?” ");
INSERT INTO cmo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mpôl oh mon ơh: “Kôranh ŭch ncho păng.” Jêh ri khân păng i tơm seh lia nây ăn khân păng têk. ");
INSERT INTO cmo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jêh ri khân păng têk seh lia i nây ăn ma Brah Yêsu, lăk ao kuŏng khân păng nơm ta kalơ ndŭr kơi kon seh lia nây pư ăn Păng ncho. ");
INSERT INTO cmo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jêh ri Brah Yêsu ncho seh lia hăn rŏ trong nây, tât say Păng, bu droh ao kuŏng khân păng nơm lăk rŏ trong ri dadê. ");
INSERT INTO cmo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Brah Yêsu bơi tât ta ntŭk trong jŭr rŏ yôk tơm Ôlive, ta ntŭk nây geh phung oh mon ŏk ngăn răm maak rnê ma Kôranh Brah dŭt nteh nteh ngăn, yor ma lĕ ndơ ueh ndơ khlay khân păng lĕ say Brah Yêsu jan nơh. ");
INSERT INTO cmo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Khân păng lah: “Dăn Kôranh Brah ăn nau geh jêng ma Kađăch dja I Kôranh Brah de đă văch. Ăn geh nau đăp mpăn ma hên đah ma Kôranh Brah ta kalơ trôk. Rnê nau ueh reh ma Kôranh Brah gŭ ta kalơ trôk dŭt prêh ri!” ");
INSERT INTO cmo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Geh phung Pharisi aƀă gŭ ndrel ƀon lan nây lah ma Brah Yêsu: “Hơi Nơm Nti, buay oh mon May nây lơi ăn khân păng ngơi kơt ndri!” ");
INSERT INTO cmo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Brah Yêsu ơh ma phung Pharisi: “Gâp mbơh ma khân may, lah khân păng dja gŭ iăt săk răk klăk, lŭ dja mra nter rnê ma Gâp ro.” ");
INSERT INTO cmo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Brah Yêsu bơi tât ƀon kuŏng Yêrusalem, Păng uănh say ƀon i nây, jêh ri Păng nhŭm rngot ma ƀon i nây, ");
INSERT INTO cmo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Păng lah: “Hơi bunuyh ta Yêrusalem! Nhhuach ngăn, Gâp ŭch ngăn khân ay may vât nau đăp mpăn Kôranh Brah ŭch ăn ma khân ay may ta nar dja, tih ma aƀaơ dja nau khlay i nây nking ndŏp mâu ôh ăn khân ay may vât. ");
INSERT INTO cmo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nar jât năp tay mra geh phung rlăng gŭ njueng jŭm khân ay may, tôh n'hao neh ăn prêh gay ma hao kalơ mpêr ƀon, lơh khân ay may ăp njônh ăp njănh. ");
INSERT INTO cmo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bu lơh hêng khân ay may lĕ phiao, lĕ oh mon kon sau khân ay may. Mâu hôm ôh geh lŭ blon tâm rdăp kalơ lŭ blon ta ƀon dja jât, yorlah khân ay may mâu gĭt năl mong Kôranh Brah văch gay ma rklaih khân ay may.” ");
INSERT INTO cmo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Brah Yêsu tât ta ƀon Yêrusalem, jêh ri Păng lăp ta jŏng gung nhih jan brah ri, ta ntŭk nây Păng say bunuyh gŭ tăch rgâl drăp ndơ, jêh ri Păng ntrŭt phung i nây lôh bơh ntŭk nây ro, ");
INSERT INTO cmo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Păng lah: “Ta samƀŭt Nau Kôranh Brah Ngơi lĕ jêh nchih: ‘Nhih Gâp jêng ntŭk ăn ma mbơh sơm’. Tih ma khân ay may sŏ jan nkhơng ntŭk gŭ rgum mpôl ntŭng.” ");
INSERT INTO cmo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jêh ri Brah Yêsu gŭ nti bu ta jŏng gung nhih jan brah ăp nar ăp nar. Yơn ma mpôl kôranh jan brah, phung nơm nti nau vay phung Israel, ndrel ma mpôl kôranh ƀon lan aƀă êng jât, khân păng leo băl joi nau gay ma nhŭp nkhât lơi Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tih ma mâu blao ôh, khân păng klach phung ƀon lan tâm lơh đah khân păng, yorlah lĕ phung ƀon lan gŭ iăt nau Păng rơp hơp dadê ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Geh du nar Brah Yêsu gŭ nti ƀon lan ta jŏng gung nhih jan brah ma Kôranh Brah, ndrel ma mbơh nkoch nau mhe mhan ueh. Jêh ri geh mpôl kôranh jan brah, phung nơm nti nau vay phung Israel, ndrel ma kôranh aƀă êng jât, khân păng leo băl hăn ta nây đŏng, ");
INSERT INTO cmo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ôp Brah Yêsu ri: “Dăn mbơh ăn ma hên gĭt, ndơ May jan dja bơh tă nau dơi? Bu moh ăn nau dơi i nây ma May mêh?” ");
INSERT INTO cmo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Brah Yêsu ơh ma khân păng: “Gâp dăn ôp du nau ma khân may ƀŏt, lŏng khân may mbơh ma Gâp: ");
INSERT INTO cmo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Lah ndri bu moh đă Yôhan-Ƀaptem jan ƀăptem yŭk ma dak? Tă bơh Kôranh Brah, mâu lah tă bơh bunuyh?” ");
INSERT INTO cmo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mpôl i nây tâm nchră băl: “Lah bân lah: ‘Tă bơh Kôranh Brah’, Păng mra lah bân: ‘Lah ndri mơm dâng khân may mâu iăt nau păng?’ ");
INSERT INTO cmo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Lah bân lah: ‘Tă bơh bunuyh’, ƀon lan mra ntŭp bân ma lŭ ro, yorlah bu gĭt n'hêl Yôhan-Ƀaptem păng bunuyh ntơyh nau ngơi Kôranh Brah ngăn.” ");
INSERT INTO cmo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jêh ri khân păng ơh ma Brah Yêsu: “Hên mâu gĭt ôh, bu moh đă păng jan.” ");
INSERT INTO cmo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jêh ri Brah Yêsu ơh ma khân păng đŏng: “Lah ndri Gâp mâu đŏng mbơh ăn ma khân may gĭt, bu moh ăn nau dơi Gâp jan dja.” ");
INSERT INTO cmo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jêh ri Brah Yêsu ngơi ntât ăn ma phung ƀon lan: “Geh du huê bu klô tăm tơm play yŭng yar ƀon du lôk mir, jêh ri ăn bu mât mir i nây, đă bu pă play ma păng ăp năm. I păng nơm ri hăn gŭ jât bri êng jŏ ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tât di khay dŭm play yŭng yar ƀon ri, păng đă du huê dâk păng hăn tâm mâp ma mpôl mât mir i nây, gay ma sŏ play i bu pă nây. Tih ma lĕ mpôl i nây lơh ôbăl, jêh ri ntrŭt ôbăl ăn sât dơm. ");
INSERT INTO cmo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Păng đă tay du huê dâk jât hăn, mpôl mât mir i nây lơh ôbăl, rak suai, ntrŭt ôbăl ăn sât dơm đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jêh ri păng i tơm mir nây đă tay du huê dâk jât. Tât ta nây mpôl mât mir i nây lơh mbang ôbăl tât ma sôt rmanh, pư mƀăr ôbăl bơh dih mir ri. ");
INSERT INTO cmo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Jêh ri păng i tơm mir ri lah êng săk păng nơm: ‘Mơm gâp jan hay? Aƀaơ dja đă kon bu klô i gâp nơm rŏng hô ngăn dja, ăn păng hăn ƀŏt, lah khân păng say klăp lah khân păng iăt păng ro’. ");
INSERT INTO cmo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tât ma mpôl mât mir i nây say păng, jêh ri khân păng tâm lah ndrăng khân păng nơm: ‘Păng i nây ro ntrŏ ndơn mir dja nar jât năp tay, hăn bân nkhât lơi păng i nây dôh, mir dja n'ho geh ma bân ro’. ");
INSERT INTO cmo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jêh ri bu mƀăr ôbăl bơh dih mir ri, nkhât lơi ôbăl. Lah ndri păng i tơm mir i nây, mơm păng jan ma mpôl mât mir i nây? ");
INSERT INTO cmo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Păng mra hăn nkhât lơi khân păng, jêh ri ăn bu êng jât mât mir i nây.” Tât ma tăng nau i nây bu lah: “Mâu ôh! Lơi ôh ăn geh kơt i nây.” ");
INSERT INTO cmo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jêh ri Brah Yêsu uănh jât bu, Păng lah: “Ta samƀŭt Nau Kôranh Brah Ngơi lah: ‘Bunuyh blao jan jay lŭ blon lĕ mƀăr lơi du mlŏm lŭ blon, Yơn ma lŭ blon i nây jêng lŭ blon dŭt nâp khlay rlau bu ma jan jay’. ");
INSERT INTO cmo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Lah ndri moh nau bu ntât dja? Lŭ blon i nây jêng ntât ma Gâp. Jêh ri bu moh rlăch ma Gâp tâm ban ma bunuyh chôt ta kalơ lŭ i nây, jêh ri nau phat dôih Gâp ta jât năp tay, tâm ban ma lŭ tŭp ta kalơ bunuyh. Bu moh i chôt ta kalơ lŭ blon i nây, păng i nây lêk rhŏch ro. Jêh ri lah lŭ blon i nây tŭp kalơ du huê bunuyh, bunuyh i nây hăch lĕ phiao.” ");
INSERT INTO cmo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jêh khân păng tăng Brah Yêsu ngơi nau ntât nây, phung nơm nti nau vay phung Israel, ndrel ma mpôl kôranh jan brah, khân păng gĭt vât nau ngơi i nây lah ma săk khân păng ro, ndri dâng khân păng ŭch nhŭp Brah Yêsu ta nây ro, yơn ma klach phung ƀon lan lơh. ");
INSERT INTO cmo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ndri khân păng i nây kŏp uănh nđôi Brah Yêsu, jêh ri đă bu groi Păng. Mpôl i nây gŭ ngao jan kơt bunuyh sŏng, gay ma ndơm Păng nhŭp nau tih ta ndơ Păng mbơh nkoch. Khân păng ŭch geh nau ma njŭn Păng ta kôranh kuŏng Pilat ăn tê̆ dôih Păng. ");
INSERT INTO cmo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jêh ri mpôl i nây ôp Brah Yêsu: “Hơi Nơm Nti! Hên gĭt dâng lĕ nau May mbơh nti nây jêng di dadê ngăn. May mâu ôh klach ma bunuyh, mâu ôh kơih bunuyh, May nti nau Kôranh Brah ăn di. ");
INSERT INTO cmo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Dăn mbơh ma hên tâng nau vay bân, di đŏng ăn prăk i kôranh kađăch ta bri Rôm đă bân ăn nây mâu lah mâu?” ");
INSERT INTO cmo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yơn ma Brah Yêsu lĕ gĭt i nau khân păng ŭch ôp nây, jêng ôp rlong Păng, lah Păng lah di, phung ƀon lan mâu hôm rŏng ma Păng, yorlah khân păng biănh ăn prăk i nây. Lah Păng lah mâu di, khân păng ŭch ntôn Păng ta kôranh kuŏng Pilat, yorlah Păng ngơi tâm rdâng đah bri Rôm mâu ăn ƀon lan ăn prăk ma kôranh, tâng kađăch kuŏng ta bri i nây đă. Jêh ri Păng lah kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Lŏng nhhơ prăk i ăn ma kađăch i nây du mlŏm. Ta kalơ kăk nây bu moh rup, ndrel ma bu moh geh rnha?” Bu ơh ma Păng: “Geh rup, ndrel ma geh rnha kađăch kuŏng ta bri Rôm.” ");
INSERT INTO cmo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Brah Yêsu lah ma khân păng: “Lah ndri, ndơ kôranh kađăch ta bri Rôm mplơ̆ ăn ma păng, ndơ Kôranh Brah mplơ̆ ăn ma Kôranh Brah nơm.” ");
INSERT INTO cmo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ndri khân păng mâu ôh dơi nhŭp Brah Yêsu ta năp băl phung, yorlah ta nau Păng ngơi mâu ôh say geh tih. Khân păng ndrŏt hih rhŏl ngăn yor ma tăng nau Păng ơh blao ngăn, jêh ri khân păng gŭ iăt săk răk klăk dơm. ");
INSERT INTO cmo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jêh ri geh phung Sađôsi aƀă hăn ôp Brah Yêsu, phung i nây kôranh ta phung Israel đŏng, tih ma khân păng mâu iăt ôh bunuyh lĕ khât hôm dâk rêh jât. ");
INSERT INTO cmo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Khân păng ôp rlong: “Hơi Nơm Nti, Môsê kăl e nơh lĕ nchih jêh ta samƀŭt ăn ma bân i phung Israel lah kơt nđa: ‘Lah bu klô sŏ ur, jêh ri păng khât, lah păng mâu geh kon, đă i oh nô păng ri ntrŏ sŏ ur păng gay ma geh kon ma păng’. ");
INSERT INTO cmo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ntât lah, lah geh pơh nuyh oh nô, i nô bôk dak ri sŏ ur, jêh ri păng khât, păng mâu ôh geh kon. ");
INSERT INTO cmo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","I oh groi bơh kơi păng nây ntrŏ sŏ, khât mâu geh kon đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jêh ri i oh tŏl pe nây ntrŏ sŏ đŏng, n'ho ma lĕ pơh nuyh khân păng nây sŏ păng dadê, tih ma mâu ôh geh kon. ");
INSERT INTO cmo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kêng ma dŭt ma dêl bu ur i nây khât đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tât nar bunuyh dâk rêh tay, lah ndri bu moh sŏ bu ur i nây? Yorlah lĕ pơh nuyh khân păng nơh lĕ tă sŏ păng dadê.” ");
INSERT INTO cmo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Brah Yêsu ơh ma khân păng: “Bunuyh ta neh ntu dja vay sŏ ur sŏ sai. ");
INSERT INTO cmo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yơn ma nar jât năp tay, bu moh i Kôranh Brah de di ma rklaih bơh khât, khân păng dâk rêh gŭ ta ƀon ueh ta kalơ, bunuyh i nây mâu hôm ôh sŏ ur sŏ sai jât. ");
INSERT INTO cmo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Khân păng mâu hôm ôh blao khât jât, khân păng jêng tâm ban ma tông păr Kôranh Brah, khân păng lĕ jêng kon Kôranh Brah ngăn, yor ma khân păng lĕ dâk rêh jêh. ");
INSERT INTO cmo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Môsê lĕ nkoch jêh ma bunuyh khât dâk rêh, păng geh nchih lah ta plăng trong pŭm lok i geh hit ŭnh, ntŭk nây păng kuăl Kôranh Brah lah ‘Jêng Brah Abrahăm yơk mbah, jêng Brah Isăk yơk mbah, jêng Brah Yakôp yơk mbah’. ");
INSERT INTO cmo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nôk Môsê ngơi nau i nây lĕ pe nuyh khân păng i nây lĕ khât ŏk năm jêh, yơn ma bơh Nau Kôranh Brah Ngơi gĭt năl khân păng hôm rêh ma Kôranh Brah. Kôranh Brah mâu ôh di Brah ma bunuyh khât, Păng Brah ma bunuyh rêh.” ");
INSERT INTO cmo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jêh ri geh phung nơm nti nau vay phung Israel aƀă lah ma Brah Yêsu: “Hơi Nơm Nti! Nau May ơh i nây blao ueh ngăn.” ");
INSERT INTO cmo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jêh ri bu mâu hôm ôh bănh ôp Păng nau êng êng jât. ");
INSERT INTO cmo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jêh ri Brah Yêsu ôp bu: “Mơm dâng bu kuăl Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl ri lah kon sau kađăch Đavid dơm? ");
INSERT INTO cmo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yorlah ta samƀŭt Nau Mprơ Ơm kađăch Đavid geh nkoch lor ma Brah Krist păng lah: ‘Kôranh Brah lah ma Kôranh gâp: ‘Gŭ mpeh bơh ma Gâp hŏm, ta ntŭk bu yơk rlau bu. ");
INSERT INTO cmo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kŏp tât Gâp ăn phung rlăng đah May jêng ntŭk rkơl jŏng May ƀŏt’’. ");
INSERT INTO cmo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Lah lĕ kađăch Đavid nơm kuăl Brah Krist lah Kôranh păng nơm kơt nây, yơn ma kon sau mâu geh kuŏng rlau ma u che, lah ndri Brah Krist mơm hôm blao kon sau kađăch Đavid jât?” ");
INSERT INTO cmo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nôk ƀon lan hôm e gŭ iăt nau Brah Yêsu ngơi nây, jêh ri Păng lah ma mpôl oh mon Păng: ");
INSERT INTO cmo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ăn khân ay may njrăng ngăn đah ma phung nơm nti nau vay phung bân nây, yorlah khân păng ŭch nsoh ao jong i ueh, jêh ri brô̆ rsong, gay ma ăn bu gĭt lah khân păng geh nau khlay ngăn, ŭch ăn bu mbah kŭnh bôk ma khân păng rŏ ntŭk bu tăch rgâl drăp ndơ, mâu lah rŏ trong kuŏng, ndrel ma ŭch gŭ bơh năp bu ta ntŭk bu lư ta nhih rƀŭn phung bân, jêh ri lah nhêt kuŏng sông kuŏng nây ŭch gŭ ta ntŭk bu yơk đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tih ma khân păng mƀrôh rlăm bu ur ndrô lĕ khât sai gay ma sŏ pit drăp ndơ nhih jay bu ur ndrô i nây. Jêh ri khân păng jan mbơh sơm dŭt jŏ ngăn ăn bu êng tăng, gay ma nhhơ khân păng nơm jêng bunuyh rŏng ma Kôranh Brah ngăn. Phung i nây Kôranh Brah tê̆ dôih dŭt jru ro ta nar jât năp tay.” ");
INSERT INTO cmo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nôk Brah Yêsu gŭ ta jŏng gung nhih jan brah, Păng ngơk say mpôl ndrŏng tê̆ prăk ta trôm hŭp nhhơr ma Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jêh ri Păng say du huê bu ur ndrô khât sai o ach, hăn tê̆ prăk đê̆ dơm bar mlŏm kăk jê̆ ta trôm hŭp i nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Brah Yêsu lah: “Gâp mbơh n'hêl nanê̆ ngăn ma khân ay may, Kôranh Brah kơp bu ur ndrô o ach i dja tê̆ prăk ŏk rlau dâng lĕ bu, ");
INSERT INTO cmo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","yorlah dâng lĕ mpôl i nây, prăk i khân păng tê̆ ta trôm hŭp nơh, sŏ prăk rmeh bơh săk khân păng nơm. Lŏng i bu ur ndrô de nây, păng bunuyh o ach hô ngăn, bol lah prăk nây gay ma siăm nau rêh păng nơm kađôi lĕ, păng hôm sŏ lĕ phiao tê̆ nhhơr ma Kôranh Brah đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jêh ri geh bunuyh aƀă rnê ma nau ueh nhih jan brah, i bu jan ma lŭ ueh, ndrel ma pla ndơ êng êng i bu nhhơr ăn ma Kôranh Brah, Brah Yêsu lah: ");
INSERT INTO cmo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Lĕ ndơ lĕ jay i khân ay may say ta dja, ta nar jât năp tay bu mra lơh rlŏm lĕ phiao ro, mâu hôm ôh geh du mlŏm lŭ blon tâm rdăp jât.” ");
INSERT INTO cmo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bu ôp ma Brah Yêsu: “Hơi Nơm Nti! Dah hôm jŏ nar i nây mêh? Lah ndri moh ndơ mbên ăn ma hên gĭt lah nar i nây bơi tât?” ");
INSERT INTO cmo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Brah Yêsu ơh ma khân păng: “Njrăng ngăn hŏm, lơi ôh ăn bu ndơm ma khân ay may, yorlah nar jât năp tay geh ŏk bu ntup rnha Gâp, khân păng lah: ‘Gâp dja Brah Krist heh’. Mâu lah khân păng lah: ‘Nar n'glĕ dŭt bơi tât jêh’. Lơi ôh iăt mpôl i nây. ");
INSERT INTO cmo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Lah khân ay may tăng bu nkoch geh nau tâm lơh tâm sreh, mâu lah geh nau uh ah, lơi klach rvê ôh, yorlah lĕ nau i nây păng lor geh ngăn ro, yơn ma nar n'glĕ dŭt neh ntu ê hŏ tât gơnh ro ôh.” ");
INSERT INTO cmo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Brah Yêsu lah jât: “Ê lor ma nar i nây, du mpôl tâm lơh đah du mpôl êng jât, du bri dak tâm lơh đah du bri dak êng jât. ");
INSERT INTO cmo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ta ntŭk êng êng, geh n'găr neh ntu dŭt dăng, geh nau ji sŏt ji ngot kuŏng, geh nau ji khât rŭng khât rchă, nđâp ma geh nau tât êng êng jan ăn geh nau klach rvê, ndrel ma geh ndơ mbên kuŏng ngăn i bu mâu vay say ôh ta kalơ trôk ri. ");
INSERT INTO cmo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ê lor ma geh dâng lĕ nau i nây, geh bu jan jêr ma khân ay may, bu nhŭp, bu njŭn khân ay may ta nhih rƀŭn phung bân gay ma phat dôih, tê̆ khân ay may ta trôm ndrung. Bu njŭn khân ay may ma kađăch, ma kôranh kuŏng, gay ma tê̆ dôih khân ay may yor ma iăt tâng Gâp dơm. ");
INSERT INTO cmo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yơn ma nau i nây plăch ăn ma khân ay may geh mbơh nau mhe mhan ueh ma khân păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ăn khân ay may geh nuih n'hâm nâp hŏ, lơi ôh rvê nau lor gay ma tâm ơh đah nau khân păng ntôn. ");
INSERT INTO cmo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yor ma nôk nây Gâp ăn ma khân ay may geh nau ma ơh, ndrel ma geh nau mân gĭt blao, mâu ôh ăn dâng lĕ mpôl tâm rdâng dơi tâm ơh dơi tâm rlăch đah khân ay may. ");
INSERT INTO cmo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bol lah mê̆ bơ̆, oh nô, ndŭl mpôl, ndrel ma mât jăng khân ay may nơm kađôi lĕ, njŭn khân ay may ma khân păng, jêh ri khân ay may aƀă bu nkhât lơi đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nôk nây geh bunuyh ŏk ngăn biănh ma khân ay may ngăn, yor ma khân ay may tâng săk Gâp. ");
INSERT INTO cmo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yơn ma khân păng mâu geh nau dơi đah huêng khân ay may, mâu geh nau dơi đah nau rêh n'ho ro khân ay may. ");
INSERT INTO cmo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Lah khân ay may dăng ăt đah dâng lĕ ndơ i nây, mâu bah nsing ma Gâp, khân ay may mra geh nau rêh n'ho ro.” ");
INSERT INTO cmo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Lah khân ay may say tahen hăn njueng jŭm ƀon kuŏng Yêrusalem, ăn khân ay may gĭt lah ƀon i nây bơi ma hêng jêh. ");
INSERT INTO cmo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nôk nây ăn bunuyh i gŭ ta bri Yuđa du nchuăt krap ta yôk, bunuyh i gŭ ta ƀon Yêrusalem ri nchuăt lôh bơh ƀon nây, bunuyh i gŭ bơh dih ƀon nây lơi ôh hăn lăp ta trôm ƀon. ");
INSERT INTO cmo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yorlah nôk nây ro Kôranh Brah klăp ndăng tê̆ dôih ƀon lan Păng nơm, gay ma tâm di đah nau lĕ geh nchih ta samƀŭt Nau Kôranh Brah Ngơi. ");
INSERT INTO cmo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nôk nây đŏng bu ur ntreo, bu ur mpu toh kon geh nau rêh rnhăl hô ngăn, yorlah geh nau jêr rvê dŭt hô ngăn ta bri i nây, Kôranh Brah tê̆ dôih ma phung ƀon lan nây. ");
INSERT INTO cmo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Geh ŏk bunuyh chôt khât yor ma đao, ndrel ma geh ŏk bu veng gŭ jan dâk ta bri êng êng. Phung bri êng êng i mâu di phung bân ri jot mpet ƀon Yêrusalem, n'ho ma tât di nar Kôranh Brah ăn ma phung i nây.” ");
INSERT INTO cmo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nôk nây geh ndơ bu mâu vay say ta nar, ta khay, ndrel ma ta mănh mbing ri. Lĕ bunuyh ta neh ntu geh nau jêr rvê, mâu hôm ôh blao mân, tât ma tăng nteh rbuh dak văch dak văr, ndrel ma rbuh dŭt kuŏng ri. ");
INSERT INTO cmo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bunuyh ta neh ntu klach nsŏr, dôl gŭ mân nau tât ta neh ntu dja, lĕ ndơ ta kalơ trôk geh n'gơ đăt nhhing nhhang. ");
INSERT INTO cmo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nôk nây bu say Gâp i Kon Bunuyh tă bơh Kôranh Brah hăn rŏ ndŏr tŭk nđâp ma geh nau dơi, ndrel ma nau chrêk lơp dŭt hô. ");
INSERT INTO cmo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dôl nau i nây ntơm geh, ăn khân ay may dâk hŏm n'gơr uănh, ăn geh nuih n'hâm bănh, yorlah nôk Kôranh Brah rklaih khân ay may bơh dâng lĕ nau jêr nơh bơi ma tât ro.” ");
INSERT INTO cmo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jêh ri Brah Yêsu ngơi ntât ma tơm Rvi, Păng lah: “Ăn khân ay may uănh tơm Rvi, ndrel ma dâng lĕ tơm si. ");
INSERT INTO cmo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Lah khân ay may say n'ha păng ntơm chăt nkŭr, khân ay may gĭt lah khay mih bơi ma tât ro. ");
INSERT INTO cmo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tâm ban đŏng, dôl khân ay may say lĕ nau i nây lĕ tât, ăn khân ay may gĭt lah nôk Kôranh Brah mât uănh dâng lĕ bunuyh ngăn bơi ma tât ro. ");
INSERT INTO cmo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Gâp lah n'hêl nanê̆ ngăn ma khân ay may, lĕ nau dja păng tât dôl bunuyh ta rnôk aƀaơ dja hôm rêh dadê. ");
INSERT INTO cmo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Trôk neh ntu mra roh lêk ro, yơn ma nau Gâp ngơi mâu ôh blao roh lêk, hôm geh dâng lĕ ngăn.” ");
INSERT INTO cmo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ăn khân ay may gŭ njrăng! Lơi ôh ăn nuih n'hâm khân ay may pơh ma ndơ pâl răm maak, pơh ma nhŭl ndrănh, mâu lah pơh ma mân rvê ma nau rêh, klach lah nar Gâp plơ̆ văch nây khân ay may tâm ban ma geh dăk yor ma khân ay may mâu geh gŭ njrăng. ");
INSERT INTO cmo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nar Gâp plơ̆ văch ta dja, mâu geh ôh du huê bunuyh gĭt lor, dâng lĕ bunuyh lam neh ntu dja geh dăk dadê. ");
INSERT INTO cmo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Njrăng, ndrel ma mbơh sơm ƀaƀơ hŏm, gay ma geh suan dơi ăt ma lĕ nau tât i nây, ndrel ma dơi dâk nâp mâu geh klach ta năp Gâp i Kon Bunuyh tă bơh Kôranh Brah.” ");
INSERT INTO cmo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ăp nar Brah Yêsu gŭ nti bu ta jŏng gung nhih jan brah, ta măng Păng hăn gŭ ta yôk tơm Ôlive. ");
INSERT INTO cmo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ơm ôi phung ƀon lan hăn iăt nau Păng nti ta jŏng gung nhih jan brah. ");
INSERT INTO cmo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jêh ri ƀŭn nŭmpăng mâu geh ndrui, i bu kuăl lah ƀŭn n'hot đŏng, lĕ bơi ma tât jêh. ");
INSERT INTO cmo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay phung Israel, joi nau mơm jan gay ma nkhât lơi Brah Yêsu mâu ăn geh nau uh ah, yor ma khân păng klach phung ƀon lan nuih nôk nhŭp Păng. ");
INSERT INTO cmo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jêh ri Satăng i kôranh mpôl brah djơh lăp gŭ ta Yuđas, i bu kuăl Isakariyôt đŏng. Păng jêng du huê bunuyh ta 12 nuyh mpôl kôranh oh mon nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Păng hăn mâp ma mpôl kôranh jan brah, ndrel ma mpôl kôranh tahen nhih jan brah, gay ma nchră băl mơm joi nau gay ma geh njŭn Brah Yêsu ma khân păng. ");
INSERT INTO cmo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jêh nchră băl nau i nây, phung i nây răm ngăn, khân păng lĕ tâm di ton ăn prăk ma păng. ");
INSERT INTO cmo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuđas-Isakariyôt ŭch đŏng, jêh ri joi mong gay ma leo bu hăn nhŭp Brah Yêsu, nôk phung ƀon lan mâu geh gŭ ndrel Păng. ");
INSERT INTO cmo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jêh ri nar ndrăp nhêt ƀŭn nŭmpăng mâu geh ndrui lĕ tât jêh, jêng nar bu nkhât kon be biăp ma jan brah, ndrel ma nhêt ƀŭn n'hot. ");
INSERT INTO cmo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jêh ri Brah Yêsu đă bar hê kôranh oh mon Pêtrôs, ndrel Yôhan hăn lor, Păng lah ma khân păng: “Khân may hăn ndrăp nau nhêt ƀŭn n'hot dja bân de ma sông sa.” ");
INSERT INTO cmo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Khân păng ôp Brah Yêsu: “Hơi Kôranh, ah ntŭk May ŭch ăn hên ndrăp nau nhêt sông sa dja mêh?” ");
INSERT INTO cmo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Brah Yêsu ơh: “Iăt Gâp hŏm, tât lăp ta ƀon Yêrusalem ri tay, khân may say du huê bu klô tê̆ dak yăng ta mlik. Ăn khân may hăn tâng păng n'ho ma tât păng lăp ta trôm jay. ");
INSERT INTO cmo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jêh ri khân may ngơi đah ma tơm jay i nây lah: ‘Nơm Nti hên đă hên hăn ôp may, jrô ma Păng nhêt ƀŭn ndrel oh mon ta nar nhêt ƀŭn n'hot dja, ah ntŭk mêh?’ ");
INSERT INTO cmo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bunuyh tơm jay nây leo ma khân may ro ta ntŭk kalơ ri. Jrô huy ngăn, lĕ ơm jêh ndrăp phiao, ăn khân may ndrăp nau nhêt sông ăn ma bân ta jrô nây ro.” ");
INSERT INTO cmo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jêh ri bar hê khân păng nây brô̆ drơn ro, tât a ri say kơt nau Brah Yêsu lah nơh, jêh ri khân păng ndrăp ndơ sông sa ma nau nhêt ƀŭn n'hot i nây. ");
INSERT INTO cmo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tât di mong nây, Brah Yêsu gŭ sông sa ta nsưng ndrel mpôl kôranh oh mon, ");
INSERT INTO cmo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Păng lah: “Hơi oh mon, Gâp ŭch hô ngăn sông sa ndrel khân may ta nar nhêt ƀŭn n'hot dja, ê lor ma Gâp geh nau jêr jŏt. ");
INSERT INTO cmo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gâp mbơh ma khân may, Gâp mâu hôm ôh sông sa nhêt ƀŭn n'hot dja jât, n'ho ma tât nhêt ƀŭn dja geh nôk Kôranh Brah mât uănh dâng lĕ bunuyh ngăn ri mơ.” ");
INSERT INTO cmo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jêh ri Brah Yêsu sŏ kchok ndrănh play yŭng yar ƀon, lah ueh ma Kôranh Brah. Jêh lah ueh ri Păng lah: “Sŏ kchok dja tâm pă băl nhêt. ");
INSERT INTO cmo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gâp mbơh ma khân may, ntơm bơh aƀaơ dja Gâp mâu hôm ôh nhêt ndrănh play yŭng yar ƀon jât, n'ho ma tât Kôranh Brah mât uănh dâng lĕ bunuyh ngăn mơ.” ");
INSERT INTO cmo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jêh ri Păng sŏ đŏng nŭmpăng lah ueh ma Kôranh Brah, Păng gĭch nŭmpăng i nây ăn khân păng sa n'ho ma lah: “Dja jêng săk jăn Gâp, i Gâp ăn ma khân may tay, ăn khân may jan kơt nđa let jât năp tay, gay ma kah gĭt ma Gâp.” ");
INSERT INTO cmo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Lôch jêh nau nhêt sông nây, Brah Yêsu sŏ kchok ndrănh play yŭng yar ƀon jan kơt i nây đŏng, Păng lah: “Ndrănh play yŭng yar ƀon ta kchok dja jêng nau tâm rnglăp mhe Kôranh Brah ndrel khân may. Nau tâm rnglăp mhe i nây Gâp jan ma khân may ma mham Gâp i hoch bơh săk jăn Gâp nôk Gâp khât tay. ");
INSERT INTO cmo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lŏng bunuyh i njŭn Gâp ma phung rlăng đah Gâp, păng gŭ sông sa ndrel Gâp ta nsưng dja đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iăt ma Gâp i Kon Bunuyh tă bơh Kôranh Brah mra khât, tâng Kôranh Brah nơm lĕ ŭch, yơn ma bunuyh i njŭn Gâp geh nau rêh rnhăl ngăn ro ma păng.” ");
INSERT INTO cmo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jêh ri mpôl kôranh oh mon i nây tâm ôp ndrăng khân păng nơm, bu moh păng i jan nau i nây ta mpôl khân păng nơm ri. ");
INSERT INTO cmo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nôk nây mpôl kôranh oh mon geh nau tâm rlăch băl, bu moh păng i kuŏng rlau bu ta mpôl khân păng nơm. ");
INSERT INTO cmo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Brah Yêsu lah ma khân păng: “Dâng lĕ kađăch bri i mâu di phung bri bân, khân păng kuăn bôk phung ƀon lan khân păng nơm, jêh ri mpôl i geh nau dơi i nây lah êng săk khân păng nơm jêng bunuyh ueh. ");
INSERT INTO cmo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yơn ma ta mpôl khân may lơi ôh jan kơt nây. Bu moh păng i kuŏng rlau bu ăn jan tâm ban ma bunuyh jê̆ ta nâm bu. Bu moh i kôranh, ăn păng jan tâm ban ma bunuyh sơm kơl jan kar ma bu. ");
INSERT INTO cmo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yorlah bunuyh gŭ sông ta nsưng, đah ma bunuyh sơm sŏ piăng trao, bu moh lơ kuŏng? Bu vay lah kuŏng rlau jêng bunuyh i gŭ sông ta nsưng ri, ma đah bunuyh sơm sŏ piăng trao. Lŏng Gâp dja kôranh khân may gŭ ndrel khân may, Gâp jêng tâm ban ma bunuyh sơm kơl jan kar sơm sŏ piăng trao dơm. ");
INSERT INTO cmo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Khân may lĕ nsrôyh ndrel Gâp ta nau jêr Gâp đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kơt Bơ̆ Gâp lĕ ăn ma Gâp, kơt ndri dâng Gâp ăn ma khân may mât uănh phung nsing ma Gâp đŏng, ");
INSERT INTO cmo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","gay ma khân may gŭ sông sa ta nsưng ndrel Gâp nôk Gâp jêng kađăch ngăn. N'ho ma khân may gŭ ta rnơl kađăch, gay ma phat dôih lĕ bunuyh ta 12 mpôl rnoi deh bân nây.” ");
INSERT INTO cmo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Brah Yêsu lah: “Hơi Simôn, hơi Simôn, iăt Gâp hŏm! Lĕ Satăng i kôranh mpôl brah djơh dăn ma Kôranh Brah rlong khân may. Jêh ri Kôranh Brah ăn jan kơt ndri. Satăng ŭch ăn nau ndơm ma khân may, gay ma say bu moh i mâu nsing ngăn ma Gâp, păng jêng tâm ban ma bu rseng phe gay ma lôh lŏk. ");
INSERT INTO cmo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yơn ma lĕ Gâp mbơh sơm dăn ma Bơ̆, lơi ăn may bah nsing ma Gâp. Jêh ri tât may plơ̆ sât tay ma Gâp, nsing ma Gâp jât, ăn may kơl oh mon Gâp ăn khân păng nsing nâp ma Gâp.” ");
INSERT INTO cmo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simôn i bu kuăl Pêtrôs đŏng, păng ơh: “Hơi Kôranh! Gâp lĕ jêh ndrăp săk jăn, ah ntŭk May hăn, gâp tâng hăn đŏng, bol lah gŭ ndrung, mâu lah tât khât săk.” ");
INSERT INTO cmo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Brah Yêsu lah ma păng: “Hơi Pêtrôs! Gâp mbơh ma may, măng dja iăr ê hŏ ndrau, tât ma may rlăch pe tơ̆ lah mâu gĭt năl Gâp.” ");
INSERT INTO cmo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jêh ri Brah Yêsu lah ma khân păng: “Nôk Gâp đă khân may hăn gay ma mbơh nau mhe mhan ueh nơh, mâu geh prăk, mâu geh dŭng, mâu geh ndjôt ntô jot, lĕ râng bơh?” Oh mon ơh ma Păng: “Ơ, lĕ râng.” ");
INSERT INTO cmo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Brah Yêsu lah: “Aƀaơ dja, bu moh geh dŭng prăk, bu moh geh dŭng cheng, ăn păng ndjôt ta săk păng nơm. Bu moh i mâu geh đao, ăn păng tăch ao kuŏng păng nơm ma rvăt du n'gŏr đao. ");
INSERT INTO cmo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gâp mbơh ma khân may, ta samƀŭt Nau Kôranh Brah Ngơi lĕ nchih lah ma Gâp: ‘Bu kơp Păng jêng tâm ban ma bunuyh geh dôih’. Iăt ma ndơ dja jêng tât ngăn, yor ma iăt ma dâng lĕ ndơ i geh nchih ma Gâp jêng tât ngăn ro.” ");
INSERT INTO cmo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Oh mon ơh ma Păng: “Hơi Kôranh! Bân geh bar n'gŏr đao.” Brah Yêsu ơh: “Ơ, ngơi dah nây lĕ găp hơyh.” ");
INSERT INTO cmo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jêh ri Brah Yêsu lôh bơh jay nây, tâng ma nau vay Păng, Păng hăn ta yôk tơm Ôlive ri, mpôl oh mon leo băl hăn tâng Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tât ta ntŭk Păng vay hăn nây, Brah Yêsu lah ma khân păng: “Mbơh sơm hŏm, gay ma mâu jan tih nôk geh nau ndơm.” ");
INSERT INTO cmo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jêh ri Brah Yêsu hăn ƀah ngai bơh khân păng nây klăp lah truyh ntŭp lŭ. Tât ta ri Păng gŭ chon mon kômŏk, mbơh sơm kơt nđa: ");
INSERT INTO cmo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Hơi Bơ̆! Lah May ŭch, dăn May lơi ôh ăn geh nau jŏk jêr dja ma Gâp. Yơn ma lơi ôh tâng nuih n'hâm Gâp ŭch, ăn tâng nau May ŭch hŏ.” ");
INSERT INTO cmo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dôl nây geh say tông păr Kôranh Brah jŭr tă bơh kalơ trôk ntŭk Kôranh Brah, ăn Brah Yêsu geh n'hâm suan dăng. ");
INSERT INTO cmo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ta nây Păng geh nau rngot rvê dŭt hô, jêh ri Păng mbơh sơm lơ ma hô đŏng, lôh dak rhal Păng tâm ban ma hoch mham trôh klĭch ngăn ta neh ri. ");
INSERT INTO cmo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Brah Yêsu dâk bơh ntŭk mbơh sơm nây, hăn jât mpôl oh mon Păng, say mpôl oh mon nây hăk bêch dadê, khân păng rgănh yor ma rngot hô ir ta nuih n'hâm. ");
INSERT INTO cmo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Păng rlay khân păng lah: “Moh bêch khân may nây? Dâk mbơh sơm hŏm, gay ma mâu jan tih nôk geh nau ndơm.” ");
INSERT INTO cmo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Dôl Brah Yêsu hôm ngơi nây, dô ma tât Yuđas-Isakariyôt nđâp ma leo du mpôl bunuyh, păng hăn dăch Brah Yêsu, jêh ri chŭm ueh lăng Brah Yêsu tâng nau vay phung Israel, păng jêng oh mon ta mpôl 12 nuyh nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Brah Yêsu lah ma păng: “Hơi Yuđas, may jan chŭm du tong kơt nây gay ma njŭn Gâp i Kon Bunuyh tă bơh Kôranh Brah ndri bơh?” ");
INSERT INTO cmo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jêh ri mpôl i gŭ ndrel Brah Yêsu say nau i bơi ma tât, lah ma Brah Yêsu: “Hơi Kôranh! Ăn hên sŏ đao ma sreh bơh?” ");
INSERT INTO cmo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Geh du huê oh mon ri tăk đao sreh dâk kôranh jan brah dŭt kuŏng tăch tôr bơh ma. ");
INSERT INTO cmo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tih ma Brah Yêsu lah: “Lơi hôm!” Jêh ri Brah Yêsu nhŭp tôr bu klô i nây, jan tôr păng ăn bah kơt ơm. ");
INSERT INTO cmo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jêh ri Brah Yêsu lah ma mpôl kôranh jan brah, ma mpôl kôranh tahen nhih jan brah, ndrel ma mpôl kôranh êng jât i hăn nhŭp Păng nây: “Moh brô̆ khân may ndjôt nđâp ma mŏng ma đao kơt nây, kơp Gâp jêng bunuyh ntŭng bơh? ");
INSERT INTO cmo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nôk Gâp gŭ ta jŏng gung nhih jan brah ăp nar ndrel khân may, khân may mâu ôh nhŭp Gâp. Mong dja jêng mong Kôranh Brah ăn khân may jan nau i khân may ŭch, jêng mong i Kôranh Brah ăn Satăng i kôranh mpôl brah djơh mât uănh ta nau ngo ri jan nau i păng ŭch.” ");
INSERT INTO cmo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jêh ri bu nhŭp leo Brah Yêsu hăn ta jay kôranh jan brah ri. Lŏng Pêtrôs ri tâng bơh kơi brô̆ ndŏp bôk mpơl bôk. ");
INSERT INTO cmo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ta nklang jŏng gung jay nây bu de sŭnh ŭnh, jêh ri gŭ njŏr ŭnh i nây. I Pêtrôs ri gŭ ndrel bu ta nây đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Geh du huê dâk bu ur ta nây, say Pêtrôs ta ang ŭnh ri, păng uănh phŏng jât Pêtrôs ri lah: “Păng i nây mpôl Bunuyh i bu nhŭp nây đŏng!” ");
INSERT INTO cmo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pêtrôs rlăch: “Hơi yôh! Gâp mâu ôh gĭt năl Păng.” ");
INSERT INTO cmo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Du ndŏm bơh kơi nây, geh du huê bu klô êng say Pêtrôs, lah ma păng đŏng: “May băl mpôl Bunuyh i bu nhŭp nây đŏng!” Pêtrôs ơh: “Mâu ôh! Mâu di gâp ôh!” ");
INSERT INTO cmo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Klăp lah du mong bơh kơi nây, geh du huê bunuyh jât uănh jât Pêtrôs ri đŏng, jêh ri tâm lah ndrăng khân păng: “Bu klô i nây băl mpôl ndrel Bunuyh i bu nhŭp nây ngăn ro, yor ma păng phung Galilê đŏng, nau ngơi păng nau ngơi phung Galilê.” ");
INSERT INTO cmo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pêtrôs ơh lah: “Gâp mâu gĭt moh nau may ŭch lah.” Nôk păng hôm e ngơi nây, geh iăr ndrau ro. ");
INSERT INTO cmo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jêh ri Kôranh Yêsu n'gâl uănh jât Pêtrôs ri. Ta nây Pêtrôs kah gĭt nau Kôranh Yêsu lah ma păng nơh: “Măng dja, lor ma iăr ndrau, may rlăch pe tơ̆ lah mâu gĭt năl Gâp.” ");
INSERT INTO cmo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jêh ri Pêtrôs lôh a dih nhŭm rngot hô ngăn ro. ");
INSERT INTO cmo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mpôl i gŭ njrăng Brah Yêsu, ntơm gơm n'grơh ma Păng, lơh Păng, ");
INSERT INTO cmo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","sŏ bok put lơi trôm măt Păng, lơh tay Păng, jêh ri lah: “Lah May jêng bunuyh ntơyh nau ngơi Kôranh Brah ngăn, May lĕ gĭt jêh bu moh lơh May, lah ndri lŏng May mbơh ma hên!” ");
INSERT INTO cmo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jêh ri bu rak bu suai Păng hô jât. ");
INSERT INTO cmo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tât ang ôi, geh kôranh phung Israel ŏk tâm mâp băl, ta phung i nây geh mpôl kôranh jan brah đŏng, ndrel ma geh phung nơm nti nau vay phung Israel đŏng, đă bu leo Brah Yêsu hăn bơh năp khân păng i mpôl kôranh jan kar phung Israel. ");
INSERT INTO cmo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Jêh ri phung i nây ôp Brah Yêsu: “Lah May jêng Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl ngăn, lŏng May mbơh ma hên.” Brah Yêsu ơh: “Lah Gâp mbơh ma khân may, khân may mâu iăt Gâp đŏng, ");
INSERT INTO cmo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","jêh ri lah Gâp ôp khân may ma Brah Krist i nây, khân may mâu mbơh ma Gâp , mâu mƀơk Gâp đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yơn ma ntơm bơh dja jât năp, Gâp i Kon Bunuyh tă bơh Kôranh Brah gŭ bơh ma ti Kôranh Brah nơm i dŭt kuŏng gay ma mât uănh.” ");
INSERT INTO cmo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Lĕ phung i nây ôp Brah Yêsu: “Lah ndri May i Kon Kôranh Brah ƀah?” Brah Yêsu ơh: “Nau khân may lah i nây di ngăn, Gâp dja ro.” ");
INSERT INTO cmo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Khân păng tâm lah ndrăng khân păng nơm: “Bân mâu hôm khăch ôh ôp nau bơh bu êng jât gay ma phat dôih Păng, nau Păng ngơi i bân nơm lĕ tăng nây lĕ găp jêh. Yorlah Păng lah êng săk Păng nơm i kon Kôranh Brah, geh nau khlay Păng kơp êng Păng nơm tâm ban ma Kôranh Brah, nau i nây jêng geh dôih jru tât ma khât săk ngăn.” ");
INSERT INTO cmo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jêh ri lĕ mpôl i nây dâk njŭn Brah Yêsu ma kôranh kuŏng bri Yuđa, rnha păng Pilat, păng phung Rôm. ");
INSERT INTO cmo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tât ta nây khân păng lah ntôn Brah Yêsu: “Hơi kôranh, hên say bunuyh dja leo phung ƀon lan jan ndơ mâu ueh, nkhăng bu mâu ăn prăk ma kôranh kađăch ta ƀon kuŏng Rôm, ndrel ma kơp êng săk Păng nơm lah Brah Krist i nơm rklaih tă bơh Kôranh Brah de njuăl, jêh ri Brah Krist jêng kađăch đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kôranh Pilat ôp Brah Yêsu: “Ngăn lah May kađăch phung Israel ƀah?” Brah Yêsu ơh: “Ơ, kơt nau may lah nau i nây.” ");
INSERT INTO cmo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kôranh Pilat lah ma mpôl kôranh jan brah, ndrel ma phung ƀon lan: “Gâp mâu ôh say Bunuyh dja geh nau tih!” ");
INSERT INTO cmo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Khân păng lah lơ ma dăng: “Bunuyh dja leo nti phung ƀon lan jan nau uh ah lam bri Israel, ntơm bơh bri Galilê, tât ma ntŭk dja ro.” ");
INSERT INTO cmo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tât ma Pilat tăng kơt nây, păng ôp: “Lah ndri Păng Bunuyh bri Galilê bơh?” ");
INSERT INTO cmo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jêh Pilat gĭt lah Brah Yêsu bunuyh bri Galilê, njŭn Brah Yêsu ma Hêrôt-Ŏntipas, yorlah păng mât uănh bri nây, nôk nây păng geh gŭ ta ƀon kuŏng Yêrusalem đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tât păng say Brah Yêsu, păng răm ngăn, yor ma lĕ tăng nau bu nkoch ma Brah Yêsu, ndri păng ŭch mâp Brah Yêsu lĕ jŏ. Păng rnơm lah say Brah Yêsu jan du nau ueh nau khlay. ");
INSERT INTO cmo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Păng ôp Brah Yêsu ŏk ntil ngăn, yơn ma Brah Yêsu mâu ơh ôh. ");
INSERT INTO cmo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mpôl kôranh jan brah, ndrel ma phung nơm nti nau vay phung Israel, gŭ ta nây đŏng, lah ntôn Brah Yêsu dŭt dăng dăng ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hêrôt i nây, ndrel ma tahen păng gơm n'grơh mưch rmot Brah Yêsu. Păng sŏ ao ueh n'gut ta Brah Yêsu ri, jêh ri njŭn tay Păng ma kôranh Pilat. ");
INSERT INTO cmo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bơh ntơm Hêrôt i nây, đah Pilat bunuyh tâm rlăng băl, yơn ma ntơm nar nây bar hê khân păng jêng mât jăng ndrel. ");
INSERT INTO cmo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jêh ri Pilat kuăl mpôl kôranh jan brah, mpôl kôranh phung Israel a êng jât, ndrel ma lĕ phung ƀon lan văch ta păng. ");
INSERT INTO cmo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Păng lah: “Bunuyh i khân may njŭn ăn gâp phat dôih dja, khân may ntôn ma Păng lah jêng bunuyh leo phung ƀon lan tâm rdâng ma bri dak. Lĕ gâp ôp jêh Păng ta năp khân may nơm, yơn ma mâu ôh say geh nau tih kơt khân may ntôn nây. ");
INSERT INTO cmo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Bol lah Hêrôt uănh bunuyh dja mâu say geh nau tih đŏng, ndri păng plơ̆ njŭn tay Păng ta dja, n'hêl nanê̆ bunuyh i dja mâu ôh geh nau tih tât ma khât săk. ");
INSERT INTO cmo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Lah ndri gâp đă bu rpăt Păng ma rse, jêh ri ƀơk ăn Păng sât.” ");
INSERT INTO cmo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tâm ăp năm bu jan nhêt ƀŭn n'hot dja, Pilat vay ƀơk du huê bunuyh dôih ăn ma phung ƀon lan. ");
INSERT INTO cmo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Yơn ma geh dâng lĕ bunuyh nter drơu dŭt dăng lah: “Nkhât lơi Bunuyh dja, ƀơk Ƀaraƀas ma hên.” ");
INSERT INTO cmo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ƀaraƀas geh ndrung, yor ma păng jan nau uh ah ta ƀon Yêrusalem, ndrel ma nôk nây păng nkhât bunuyh đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat ŭch ƀơk Brah Yêsu, dâng geh ma păng ngơi ma phung i nây du tơ̆ jât. ");
INSERT INTO cmo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Yơn ma phung i nây hôm nter drơu lah: “Nkhât lơi Păng ta si tâm rkăng! Nkhât lơi Păng ta si tâm rkăng!” ");
INSERT INTO cmo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilat lah tay ma phung i nây du tơ̆ jât: “Bunuyh dja moh nau tih ta Păng? Gâp mâu ôh say Păng geh nau tih tât ma khât săk. Gâp man ma đă bu rpăt Păng ma rse, jêh ri ƀơk ăn Păng sât.” ");
INSERT INTO cmo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yơn ma phung i nây nter lơ ma dăng, jŏl dăn nkhât Brah Yêsu ta si tâm rkăng, ndri dâng nter phung ƀon lan ndrel ma mpôl kôranh jan brah nây dâng geh ma dơi. ");
INSERT INTO cmo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jêh ri Pilat tê̆ dôih jan tâng nau phung i nây dăn, ");
INSERT INTO cmo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","păng ƀơk Ƀaraƀas bơh ndrung. Ƀaraƀas i nây gŭ ndrung, yor ma jan nau uh ah, ndrel ma nkhât bunuyh đŏng. Lŏng i Brah Yêsu ri Pilat ăn Păng ma tahen, ăn jan tâng nau phung i nây dăn nơh. ");
INSERT INTO cmo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jêh ri tahen leo Brah Yêsu jât ntŭk nkhât Păng, dôl hăn rŏ trong nây, geh mâp ma du huê bu klô, rnha păng Simôn tă bơh ƀon kuŏng Kiren, păng sât tă bơh mir. Jêh ri tahen de nhŭp păng đă tui si tâm rkăng tâng bơh kơi Brah Yêsu. ");
INSERT INTO cmo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ŏk ngăn bunuyh hăn tâng Brah Yêsu, nđâp ma mpôl bu ur nhhiăng nhŭm ma Brah Yêsu ntŭr ntang ntơh khân păng nơm, yor ma khân păng rngot hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Brah Yêsu uănh jât mpôl bu ur i nây, lah ma khân păng: “Hơi bu ur Yêrusalem! Lơi ôh nhŭm rngot ma Gâp, ăn nhŭm rngot ma săk khân ay nơm, ndrel ma kon khân ay nơm hŏ. ");
INSERT INTO cmo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yorlah nar jât năp tay bu mra lah ro: ‘Ueh maak ngăn ma bu ur mâu bă kon, ma bu ur mâu gŭ oh, ndrel ma bu ur mâu geh mpu toh kon’. ");
INSERT INTO cmo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nôk nây tay bu lah ma yôk kuŏng: ‘Rlŏm hŏm ta kalơ săk hên dja’, lah ma yôk jê̆: ‘Dăn brôi kalơ hên dja hŏm’. Khân păng lah ndri yor ma mâu hôm ŭch ôh geh nau krit jât, nôk phung rlăng lơh hêng ƀon kuŏng dja. ");
INSERT INTO cmo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gâp mâu geh tih ôh, Gâp tâm ban ma si rêh i bu mâu ôh vay su ta ŭnh, tih ma bu hôm ŭch nkhât Gâp ta si tâm rkăng. Bunuyh ta ƀon Yêrusalem lĕ geh nau tih jêh, khân păng tâm ban ma si ndro ndrăp ma su lơi ta ŭnh. Lah si rêh lĕ dah dja jêh bu jan, lah ndri si ndro rlau ma dja ƀah bu jan.” ");
INSERT INTO cmo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Geh bar hê bunuyh dôih đŏng, tahen leo khân păng gay ma nkhât ndrel Brah Yêsu ri. ");
INSERT INTO cmo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tât ta ntŭk bu kuăl lah ‘Gôlgôtha’, geh nau khlay lah ‘Yôk nting bôk’, tahen pŏng Brah Yêsu ta si tâm rkăng ta ntŭk nây, ndrel ma bar hê bunuyh dôih đŏng, du huê bu pŏng bơh chiao, du huê bu pŏng bơh ma. ");
INSERT INTO cmo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jêh ri Brah Yêsu mbơh sơm: “Hơi Bơ̆! Yô̆ nđach ma khân păng ƀă, yorlah khân păng mâu gĭt ôh ndơ i khân păng jan dja.” I kho ao Brah Yêsu ri mpôl tahen i gŭ ta nây leo băl sŏ nhŭp ndơ nchroh, gay ma tâm pă băl kho ao i nây. ");
INSERT INTO cmo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Phung ƀon lan gŭ uănh ta nây đŏng, jêh ri mpôl kôranh phung Israel gơm n'grơh lah ma Brah Yêsu: “Lah Păng Brah Krist i kađăch lĕ Kôranh Brah de kơih ngăn, ăn Păng rklaih êng săk Păng nơm, yor ma Păng lĕ rklaih ma bunuyh êng êng jât.” ");
INSERT INTO cmo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mpôl tahen gơm n'grơh ma Brah Yêsu đŏng, khân păng sŏ dak srat ăn Brah Yêsu nhêt ");
INSERT INTO cmo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","n'ho ma lah: “Lah May Kađăch phung Israel ngăn, rklaih êng săk May nơm hŏm!” ");
INSERT INTO cmo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kalơ bôk Brah Yêsu ri geh bu pla du rlat kađar nchih lah: “Dja jêng Kađăch phung Israel.” Nau lah i dja geh nchih ma nau ngơi Grek, nau ngơi Latăng, nau ngơi Hêbrơ. ");
INSERT INTO cmo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Du huê bunuyh dôih i bu nkhât ndrel Brah Yêsu nây, păng gơm n'grơh lah Brah Yêsu kơt nđa: “May vay lah săk May nơm jêng Brah Krist, lah ndri sŏ nau dơi Brah Krist May nơm rklaih săk May nơm hŏm, jêh ri sơm rklaih hên ƀă đŏng.” ");
INSERT INTO cmo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yơn ma du huê bunuyh dôih i êng lah păng: “May bơi khât, hôm mâu klach Kôranh Brah tê̆ dôih ma may bơh? May bu tê̆ dôih kơt Păng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Bân dja bu tê̆ dôih lĕ di hơi, yorlah bân nơm lĕ jan tih. Lŏng Păng i nây mâu geh ôh jan tih.” ");
INSERT INTO cmo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jêh ri bunuyh nây lah ma Brah Yêsu: “Hơi Kôranh! Tât May jêng Kađăch ngăn ta bri May nơm, dăn May kah gĭt ma gâp ƀă.” ");
INSERT INTO cmo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Brah Yêsu lah ma păng: “Hơi oh, Gâp lah n'hêl nanê̆ ngăn ma may, nar dja ro may hăn gŭ ndrel Gâp ta ƀon ueh ta kalơ.” ");
INSERT INTO cmo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nôk nây klăp lah nar nklang bôk, jêh ri lam bri dak i nây trôk geh ngo dadê n'ho ma tât mong pe kêng măng. ");
INSERT INTO cmo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ta mong i nây nar jêng ngo, jêh ri bok nching ta trôm nhih jan brah ta bơh năp jrô dŭt kloh ueh, hêk chuik ta plăng nklang n'gul jêng bar blah bok. ");
INSERT INTO cmo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jêh ri Brah Yêsu nter dŭt dăng ngăn, Păng lah: “Hơi Bơ̆! Gâp njŭn huêng Gâp ma may.” Jêh ngơi kơt nây, Păng roh n'hâm klŏk. ");
INSERT INTO cmo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tât ma kôranh tahen i leo nkhât Brah Yêsu say nau kơt nây, păng rnê ma Kôranh Brah lah: “Bunuyh dja Păng sŏng ngăn, mâu geh tih ôh.” ");
INSERT INTO cmo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Lŏng lĕ bunuyh i văch gum ta nây, tât ma say nau kơt nây, khân păng leo băl sât a jay khân păng nơm ri ntŭr ntang ntơh khân păng nơm, yor ma rngot hô ngăn. ");
INSERT INTO cmo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dâng lĕ bunuyh i dêh dăch đah Brah Yêsu ri, ndrel ma mpôl bu ur i tâng Brah Yêsu tă bơh bri Galilê, khân păng gŭ uănh nau i nây bơh ngai. ");
INSERT INTO cmo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Geh du huê bunuyh ta mpôl kôranh jan kar phung Israel, rnha Yôsep, păng tă bơh ƀon Arimathê, ta bri Yuđa, păng jêng bunuyh sŏng ta bơh năp Kôranh Brah. ");
INSERT INTO cmo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Păng gŭ kŏp nau Kôranh Brah mât uănh đŏng. Păng mâu geh ôh tâm di nau đah mpôl kôranh jan kar phung Israel êng jât, mâu geh lăp ndrel khân păng ta nau nkhât Brah Yêsu đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jêh ri păng hăn mâp Pilat, dăn sŏ săk Brah Yêsu ma tŏp. Jêh Pilat ăn ");
INSERT INTO cmo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","păng hăn njŭr săk Brah Yêsu bơh si tâm rkăng, păng put ma bok laih nglang, jêh ri njor Brah Yêsu ta trôm môch lŭ klêr i lĕ jêh bu lôk. Trôm môch i nây ê hŏ geh ôh tê̆ bunuyh khât. ");
INSERT INTO cmo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nar nây jêng nar ndrăp ma nar Saƀăt i nar rlu phung Israel. Phung Israel kơp nar Saƀăt ntơm kêng măng nôk nar ntơm nhŏp, mong i nây lĕ bơi tât đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mpôl bu ur i tâng Brah Yêsu tă bơh bri Galilê nơh, khân păng hăn tâng Yôsep đŏng. Khân păng say môch i nây, ndrel ma say bu njor Brah Yêsu ta trôm ri đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jêh ri khân păng leo băl plơ̆ sât ta jay. Tât a jay ri khân păng ndrăp dak ngi ƀô kah, ndrel ma ndơ ƀô kah êng jât, gay ma hâng tê̆ ta săk Brah Yêsu. Lăp nar Saƀăt khân păng gŭ rlu tâng ma nau vay phung Israel. ");
INSERT INTO cmo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ta nar tŏl nguai pơh nây, ƀhit ang bri hôm ngo, mpôl bu ur i nây leo băl hăn ta môch, ndjôt ndơ ƀô kah ndơ i khân pre lĕ jêh ndrăp ri nơh ma tê̆ ta săk Brah Yêsu geh bunuyh aƀă hăn ndrel đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tât ta nây khân păng say lŭ i rdŏl ntu môch nơh lĕ rlă jêh. ");
INSERT INTO cmo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jêh ri khân păng lăp ta trôm ntu nây, uănh săk Brah Yêsu ta ri mâu hôm ôh say. ");
INSERT INTO cmo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dôl mpôl bu ur mân rvê ma nau nây, jêh ri dô ma say geh bar hê bunuyh nsoh n'gut ao nglang chrat ngăn, dâk ta meng khân păng ri. ");
INSERT INTO cmo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Khân păng klach nsŏr ngăn, gŭ kŭnh bôk jât neh su, jêh ri mpôl i bar hê nây lah ma khân păng: “Moh joi khân ay re Bunuyh rêh ta ntŭk bunuyh khât dja? ");
INSERT INTO cmo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Păng mâu hôm ôh ta dja, Păng lĕ dâk rêh jêh. Khân ay mâu kah gĭt nau Păng lĕ ngơi nôk gŭ ta bri Galilê nơh? ");
INSERT INTO cmo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Păng lah: ‘Gâp i Kon Bunuyh tă bơh Kôranh Brah, nau bu njŭn Gâp ta phung tih, nđâp ma nau bu nkhât Gâp ta si tâm rkăng iăt ma geh ngăn, yơn ma tât pe nar bơh kơi Gâp dâk rêh tay’.” ");
INSERT INTO cmo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jêh ri mpôl bu ur i nây kah gĭt ro nau Brah Yêsu ngơi nơh. ");
INSERT INTO cmo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Khân păng dâk sât bơh môch nây, mbơh nkoch nau i nây ăn ma 11 nuyh mpôl kôranh oh mon, ndrel ma dâng lĕ oh mon êng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bu ur i mbơh nkoch nau nây ăn ma mpôl kôranh oh mon, ta nây geh Mari tă bơh ƀon Mađala, geh Yôănna, ndrel ma Mari i mê̆ Yakơ, nđâp ma bu ur aƀă êng đŏng i hăn nây. ");
INSERT INTO cmo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mpôl kôranh oh mon mâu ôh iăt nau khân păng mbơh nkoch nây, khân păng lah mpôl nây ngơi nklă dơm. ");
INSERT INTO cmo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yơn ma Pêtrôs dâk bơh nây, păng nchuăt jât môch ri, tât ta ri păng kŭnh uănh ta trôm, say dơm bok bu put Brah Yêsu hôm ta ri, jêh ri păng plơ̆ sât jât jay dja, mân rvê ma nau i nây. ");
INSERT INTO cmo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ta nar nây đŏng, geh bar hê oh mon hăn jât ƀon Êmos, ngai 11 kilômet ma ƀon kuŏng Yêrusalem. ");
INSERT INTO cmo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Khân păng tâm nkoch bri i lĕ nau geh nây. ");
INSERT INTO cmo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Dôl khân păng tâm nkoch nau i nây, Brah Yêsu hăn dăch khân păng, brô̆ ndrel khân păng, ");
INSERT INTO cmo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","tih ma khân păng mâu ôh năl Păng, yorlah Kôranh Brah mâu ăn năl. ");
INSERT INTO cmo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Brah Yêsu ôp khân păng: “Moh nau nkoch khân mre dôl brô̆ rŏ trong ri hiah?” Jêh ri khân păng nsrŭng du ndŏm, muh măt sơh rơih ơyh. ");
INSERT INTO cmo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Geh du huê rnha Klêupas ơh lah: “Dâng lĕ bunuyh ta Yêrusalem, ndrel ma dâng lĕ bu năch i hăn nhêt ƀŭn n'hot ta Yêrusalem gĭt nau geh dja bar pe nar a lor nơh dadê, mơm dâng du huê May ri lĭch gĭt?” ");
INSERT INTO cmo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Brah Yêsu ôp: “Moh nau hă?” Păng ơh: “Nau Yêsu i tă bơh ƀon Nasaret nơh hiơ. Păng jêng bunuyh ntơyh nau ngơi Kôranh Brah, nau Păng nti geh nau dơi ngăn, ndrel ma jan ndơ ueh ndơ khlay kuŏng ta năp Kôranh Brah, ndrel ma ta bơh năp phung ƀon lan đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yơn ma mpôl kôranh jan brah, ndrel ma mpôl kôranh mât uănh hên, njŭn Păng ăn bu nkhât lơi Păng, nkhât Păng ta si tâm rkăng đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Lŏng hên de nană ma nơm Păng, hên vay nơm Păng ro jêng Nơm Rklaih dâng lĕ phung ƀon lan Israel bơh phung rlăng bân, aƀaơ dja geh nau kơt nây jât, ntơm bơh nar nây, lĕ geh pe nar ma nar dja jêh. ");
INSERT INTO cmo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ndrel ma geh bu ur mpôl hên aƀă, jan ăn hên geh nau ndrŏt dŭt hô đŏng, khân păng brô̆ ta môch ƀhit ang bri hôm ngo, ");
INSERT INTO cmo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","uănh săk Brah Yêsu ta ri mâu ôh say. Khân păng plơ̆ sât bơh ri mbơh nkoch ma hên lah say tông păr, jêh ri tông păr de mbơh lah Brah Yêsu rêh. ");
INSERT INTO cmo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jêh ri geh mpôl hên aƀă hăn ta môch ri đŏng, say tâm ban kơt nau mpôl bu ur mbơh nơh ngăn, tih ma mâu geh ôh bunuyh say Păng.” ");
INSERT INTO cmo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jêh ri Brah Yêsu lah ma khân păng: “Hơi bunuyh mâu geh nau mân! Khân may mâu dơh iăt ôh dâng lĕ nau bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh lĕ nchih jêh ma Brah Krist. ");
INSERT INTO cmo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Iăt ma Brah Krist i Nơm Rklaih tă bơh Kôranh Brah de njuăl dơn nau jêr jŏt nây lor ƀŏt, ri mơ dâng Kôranh Brah ăn Păng nau chrat ang, ăn Păng mât uănh dâng lĕ ndơ.” ");
INSERT INTO cmo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jêh ri Brah Yêsu rblang lĕ nau bu nchih ma săk Păng ta samƀŭt Nau Kôranh Brah Ngơi, ntơm bơh samƀŭt i Môsê nchih, tât ma dâng lĕ samƀŭt i bunuyh ntơyh nau ngơi Kôranh Brah kăl e nơh nchih đŏng. ");
INSERT INTO cmo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jêh ri ƀon i oh mon ŭch hăn nây lĕ bơi tât. Jêh ri Brah Yêsu ndra jan ŭch hăn n'hot jât năp jât. ");
INSERT INTO cmo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mpôl oh mon nây kŏn Păng, khân păng lah: “Gŭ bêch ndrel hên ta dja ƀŏt heh, nar lĕ dêh bri lĕ ŭch măng đŏng.” Jêh ri Brah Yêsu veh bêch ndrel khân păng ta ri. ");
INSERT INTO cmo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dôl Brah Yêsu gŭ sông sa ndrel khân păng ta nsưng ri, Păng sŏ nŭmpăng lah ueh ma Kôranh Brah, jêh ri gĭch pă ăn ma khân păng sa. ");
INSERT INTO cmo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nôk nây măt khân păng dô ma say ang ro, uănh năl Brah Yêsu, tih ma Brah Y