﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmnfeb_vpl;
CREATE TABLE cmnfeb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmnfeb_vpl WRITE;
INSERT INTO cmnfeb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","本书为亚伯拉罕和大卫的后代弥赛亚的记录。首先在此回述其家谱： ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","亚伯拉罕为以撒之父；以撒为雅各之父；雅各为犹大及其兄弟之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","犹大（妻为塔玛）为法勒斯和谢拉之父；法勒斯为希斯仑之父；希斯仑为亚兰之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","亚兰为亚米拿达之父；亚米拿达为拿顺之父，拿顺为撒门之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","撒门（妻为拉哈德）为波阿斯之父；波阿斯（妻为路得）为俄备得之父；俄备得为耶西之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","耶西为大卫王之父；大卫（娶乌利亚之妻）为所罗门之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","所罗门为罗波安之父；罗波安为亚比雅之父；亚比雅为亚撒之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","亚撒为约沙法之父；约沙法为约兰之父；约兰为乌西亚之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","乌西亚为约坦之父；约坦为亚哈斯之父；亚哈斯为希西加之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","希西加为玛拿西之父；玛拿西为亚门之父；亚门为约西亚之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","被流放巴比伦期间，约西亚诞下耶哥尼雅及其兄弟。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","结束巴比伦流放之后，耶哥尼雅诞下撒拉铁，撒拉铁为所罗巴伯之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","所罗巴伯为亚比玉之父，亚比玉为以利亚敬之父，以利亚敬为亚所之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","亚所为撒多之父；撒多为亚金之父；亚金为以律之父； ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","以律为以利亚撒之父，以利亚撒为马但之父；马但为雅各之父。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","雅各为约瑟之父，即玛利亚的丈夫。玛利亚所诞之子被称为弥赛亚，即耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","从亚伯拉罕到大卫共十四代人；从大卫到巴比伦流放之时亦为十四代人，从巴比伦流放到基督又为十四代人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","以下为弥赛亚——即耶稣基督降生的过程：他的母亲玛利亚被许配给约瑟，但在同房之前，玛利亚就因圣灵受孕。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","她的丈夫约瑟生性善良，不愿张扬此事让她受尽羞辱，于是打算暗地将她休掉。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","就在他思量此事之时，主派来天使进入他的梦境，对他说：“大卫之子约瑟，不要担心，迎娶你的妻子玛利亚，因她所孕育乃源于圣灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","她将诞下一子，请为其起名耶稣，他将会把苍生从罪恶之中拯救出来。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","(这一切印证了主通过先知给出的预言： ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","将有处女怀孕生子，世人将称他为马内利 即 “上帝与我们同在”之意)。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","约瑟醒来后，便遵从天使的嘱托， ");
INSERT INTO cmnfeb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","迎娶妻子过门，但在孩子出生前并未与她同房。玛利亚生下男婴后，约瑟为他起名耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","耶稣诞生在犹太的伯利恒，当时正是希律王执政时期。耶稣诞生后，几位智者从东方来到耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","他们说：“犹太之王已经诞生，他在哪里？我们看到他的明星显现于东方的夜空，特来拜访。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","希律王听闻此言颇感紧张，整个耶路撒冷城的民众也内心惴惴。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","希律召集所有的祭司长和民间的宗教老师，询问他们弥赛亚可能会诞生在何处。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","众人回答：“在犹太的伯利恒。因为先知曾写道： ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","犹大的伯利恒啊，你在犹大诸城中并非渺小，因为未来你们中将诞生一位领袖，他将带领以色列人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","听闻此言，希律私下叫来几位智者，仔细询问那颗星具体出现的时间。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","然后他派他们去伯利恒，还说：“你们到了那里后，仔细寻找那个孩子，找到后就来向我报告，我也会去拜见他。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","智者于是听从国王的旨意出发，他们之前看到的那颗星位于东方，一路指引着他们，最终停在孩子所在之处的上空。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","看到这颗星，智者们分外欢喜！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","他们随即走进房屋，看见孩子与其母亲玛利亚。于是他们伏拜在孩子面前，打开宝袋，将里面的黄金、乳香、没药作为礼物送给他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","由于主曾托梦警告他们，不要将眼前所见禀报希律王，于是他们便从另外一条道路回到了自己的国家。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","智者离开后，主的天使出现在约瑟的梦中，告诉他：“快起来！带着孩子和他的母亲逃到埃及并住下，等候我的指示。因为希律一定会想方设法找到这孩子并将他除掉。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","约瑟醒来后，立刻连夜带着孩子和妻子向埃及逃去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","此后便一直住在那里，直到希律王驾崩。这件事应验了主借先知所传达的预言：“我从埃及唤出我儿。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","希律发现智者欺骗了他，非常生气。根据从智者处打听的信息，他推测这个男孩应该不到两岁，于是立刻下令杀掉伯利恒城内及周边地区所有两岁以下男孩。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","这正应了先知耶利米的预言： ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","在拉玛传来可怕的痛哭与哀嚎，拉结为其子女哭泣，白发人送黑发人，这是任何安慰都无法抚平的悲伤。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","希律王驾崩之后，主派天使向住在埃及的约瑟托梦，告诉他： ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“出发吧！带着孩子和孩子的母亲去以色列，因为想要取这孩子性命的人已死去。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","约瑟醒来后，便带着孩子和孩子的母亲动身前往以色列。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","但当他听说希律之子亚基劳斯继位做了犹太王，便害怕回到以色列。由于在梦中获得警告，于是他便去了加利利， ");
INSERT INTO cmnfeb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","在一座名为拿撒勒的城市中安顿下来。这应验了先知的那句话：人们将称他为拿撒勒人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","之后，施洗者约翰出现，在犹太的荒野中传道。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","他说：“悔改吧，因为天国已降临。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","约翰便是以赛亚先知曾预言的那个人。预言曾说：在荒野一个声音在呼喊：“预备主的道，修直他的路！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","约翰身穿驼毛衣服，腰束皮带，以蝗虫和野蜜为食。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","人们从耶路撒冷、犹太全地和约旦河一带赶来，来到他的身边， ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","向他忏悔自己的罪，在约旦河中接受他的施洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","但约翰看见很多法利赛人和撒都该人也来此受洗，便对他们说：“你们乃毒蛇之子，谁告诉你们可以逃离那即将到来的审判？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","你们要拿出行动，证明真心悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","不要心中暗自产生傲慢的想法：‘亚伯拉罕就是我们的祖先。’我告诉你们，上帝可以用这些石头创造亚伯拉罕的后裔。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","事实上，砍树的斧子已经准备好，所有结不出好果子的树，都会被砍倒丢入火中。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","是的，我是用水为你们施洗，显示你们的悔改。但在我之后，还会出现一位比我更伟大之人，我甚至连替他提鞋的资格都没有，他将用圣灵和火为你们施洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","他手里拿着簸谷工具，他将清理打谷场，把麦子收进谷仓，然后用不灭之火把谷壳烧尽。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","这时，耶稣从加利利来到约旦河，走到约翰处准备接受他的施洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","约翰想要阻止他，说：“我本应由受你施洗，你却要让我来为你施洗吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","耶稣答道：“请这样做吧。我们应遵循上帝说是正确之事。”于是约翰便答应下来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","当耶稣受洗后从水中立起；忽然天空敞开，他看见上帝之灵降落，如鸽子般落在他身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","天空传来一个声音，说：“这是吾子，他让我欢喜。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","随后，圣灵引领耶稣来到荒野，接受魔鬼的试探。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","耶稣禁食四十昼夜，感到了饥饿。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","魔鬼便出现在他面前，诱惑他：“如果你真的是上帝之子，那就把这些石头变成食物吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","耶稣答道：“经书中写道：‘人活着并不只靠食物，更要依靠上帝所说的字字句句。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","随后，魔鬼带着耶稣走进圣城，让他站在圣殿的最高处。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","魔鬼对耶稣说：“你若是上帝之子，就从这里跳下去证明！因为经书中写道：上帝会命令天使拯救你，不受伤害。他们会托住你，免得你被石头绊倒。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","耶稣回答：“那经书也写着：不可试探吾主上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","然后，魔鬼带耶稣站上一座高山，向他展示世上所有王国的荣华。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","魔鬼说：“只要俯首拜我，我就把这一切送给你。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","“走开吧，撒旦！”耶稣道：“经书说：你只应拜吾主上帝，只侍奉他。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","魔鬼于是离开了，天使出现，看护耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","当耶稣听闻约翰被捕，便返回加利利。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","他离开拿撒勒，来自海边的迦百农并住下。这里位于西布伦和拿弗他利境内。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","这应验了以赛亚先知所述： ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“在西布伦地和拿弗他利之地，沿着海滨之路穿越约旦河，那就是异教徒所居的加利利！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","那里身处黑暗中的人民，看见了一道伟大之光；那黎明之光，照耀于被困在死亡幽暗之地的人民。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","从那时起，耶稣开始传递上帝的讯息。他说：“悔改吧，因为天国已降临。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","当耶稣走在加利利海边时，看见兄弟二人：西门（即彼得）和他的弟弟安得烈。他们是渔夫，正在向海中撒网。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","耶稣对他们说：“来跟随我吧，让我教你们如何捕捞人类。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","他们立刻撇下网，跟从耶稣而去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","耶稣继续向前，看见另一对兄弟：雅各和他的兄弟约翰。他们正和父亲西庇太一起，在船上整理鱼网。于是耶稣便召唤他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","兄弟二人立刻告别父亲，离开船跟随耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","耶稣走遍加利利，在各地的会堂中教导民众，宣讲天国的福音，治愈人们患有的所有疾病。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","他的名声传遍叙利亚省各地，于是人们将所有患者都带到他身边。无论是癫痫、魔鬼附体、精神疾病或者瘫痪，耶稣都能让他们痊愈。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","于是有大批民众从加利利、低加波利、耶路撒冷、犹太和约旦河东赶来，跟随耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","耶稣看见公众纷涌而至跟随他，于是走上山，与门徒们围在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","他开始教导他们： ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“认为自己心灵贫瘠之人有福了，因为天国是他们的。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","心中哀痛之人有福了，因他们必会获得安慰。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","善良之人有福了，因他们将拥有整个世界。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","期盼正确之人有福了，因他们的愿望必将获得满足。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","心怀悲悯之人有福了，因他们将获得上帝的怜悯。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","思想纯净之人有福了，因他们必将看到上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","致力于和平之人有福了，因他们将成为上帝之子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","因正确行事而遭迫害之人有福了，因为天国是他们的。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","如你们因我而受到辱骂，受到迫害，被各种捏造的毁谤所污蔑，你们有福了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","你们应当快乐，真正的欢喜，你们将收到上天极大的赏赐——因为他们也是这样逼迫在你们之前的先知。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","你们便是大地的食盐；如盐失了其咸味，怎么还能叫它再咸呢。它会毫无用处，唯有丢到外面任人践踏。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","你们便是这世上的光。城市立于山上，就无法隐藏。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","人们点灯，不会将其放在桶的下面，而是要放在灯台上，为房子中的每个人带来光亮。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","同样，你应该让你的光照于每个人面前，让他们看到你所做的善事并赞美你的天父。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","不要认为我来是要废除律法和先知之文，我来此不为废除它们，而是为了成就它们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","我向你们保证，纵使天地走到尽头，但只要一切尚未成就圆满，律法的字句就不会损失分毫。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","因此，无论是谁，即使废除诫命中最微不足道的一条，然后让其他人也这么做，那么他在天国中必然是最微小之人。但若有人遵行所有诫命，教导其他人也这样做，他在天国中必被成为伟大之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","我告诉你们，你们的正义 如果不能胜过宗教老师和法利赛人，便注定无法进入天国。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","你们听过古时候有这样的律法教诲众人：不可杀人，杀人者必被判罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","可我要说的是，向兄弟发怒的人也会被判有罪。一个人若称其兄弟愚蠢，必被公开审判；一个人或在言语上虐待其他人，必将难逃哥和拿之火。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","所以你在圣坛上献供物之时，如果想起你的兄弟对你不满， ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","那么请在圣坛前放下供物，先与兄弟和好，然后再来献供。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","如果你在去法庭的路上，赶快和告你的人和解。否则他会把你交给法官，法官把你交给警官，让你坐牢。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","实话告诉你们，直到你付掉最后一文钱，你都不能从那里出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","你们也听过律法这样的命令：不可奸淫。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","可我要告诉你们的是，若你在见到女性时心生淫念，你的心便已对她犯了奸淫之罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","若是你的右眼导致你犯罪，就把它挖出来丢掉；宁可失去一部分躯体，也好于全身被丢入哥和拿。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","若你的右手犯罪，就把它砍下来丢掉；宁可失去一部分躯体，也好于全身被丢入哥和拿。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","律法还规定：男人若休妻，应当给她出休书。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","但我要说的是，如不是因她不贞而休妻，就是让她去犯奸淫之罪；无论谁娶了被休的妇人，也是做出了奸淫行为。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","你还听说过很久以前有这样的律法：不可说违背心意之语。你承诺主的誓言必要兑现。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","可我要说，任何时候都不要发誓，不可指天发誓，因天为上帝的王座； ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","不可指地发誓，因为地是上帝的脚凳；不可指耶路撒冷发誓，因为它是伟大国王的城市； ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","不可指着自己的头发誓，因你无法让任何一根头发变白或变黑。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","只需回答‘是’或‘否’，再多说一句就来自恶魔。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","你们也听过这样的律法：以眼还眼，以牙还牙。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","可我要说，不要与恶人对抗，若有人打你右脸，将另一边转过来让他打； ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","若有人到法庭控告你，想拿走你的衣衫，那就把外套也给他好了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","若有人要强迫你走一里路，就陪他走两里。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","若有求你，就给他想要的；若有人想从你处借走什么，不要拒绝。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","你们听过这样的律法：爱你的邻居，憎恨你的仇敌。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","可是我要告诉你：要爱你的仇敌，为迫害你的人祈祷， ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","这样你才能成为天父的孩子。因天父让太阳照耀好人也照耀恶人；赐雨给正义之人，也给不义之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","如果只爱那些爱你之人，你又会得到什么好处？税吏不也是这样做的吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","如果你们只与家人温言细语，你和其他人又有何区别？任何异教徒都会这样做！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","所以你们要成长，成为真正值得信赖之人，一如你们的天父般值得信赖。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“不要将善事做在人的面前，叫别人看见，否则就得不到天父的赏赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","所以若你施舍穷人，不要像那些伪君子一样，在会堂和街头到处张扬，博取众人的称赞。实话告诉你们，他们已经得到了他们的赏赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","你施舍的时候，不要叫你的左手知道右手所做的。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","你的施舍应隐秘进行。因圣父在隐秘中观察，必将赏赐于你。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","当你们祈祷，不可如伪君子一般：他们只喜欢站在会堂和路口祈祷，只为让人看见。说实话，他们已经得到了他们的赏赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","至于你们，你们的祈祷应在密室中进行，关上门，向隐密中的圣父祈祷。因圣父在隐密中观察，必将赏赐于你。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","当你祈祷，不可如异教徒般反复念叨毫无意义的词语。他们误以为只要重复，上帝就可以听到。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","不可像他们那样，因为早在你们开口祈祷之前，圣父便已洞悉你们需要什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","所以要这样祈祷： 我们的天父，赞颂你的圣名。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","愿你的国度降临！愿你的意志在世间成真，一如在天国一般。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","今天请赐予我们需要的食物； ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","赦免我们的罪恶，一如我们饶恕了那些曾对我们犯下罪行之人； ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","请阻止我们深陷诱惑，拯救我们脱离邪恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","如果你们饶恕他人对你犯下的罪，天父自会饶恕你们的罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","如果你们不饶恕他人对你犯下的罪，天父也不会饶恕你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","当你们禁食，不可如伪君子般愁眉苦脸，他们只是装作难受的模样，向别人显示其正在禁食。实话告诉你们，他们已经得到了他们的赏赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","当你禁食，要梳洗得当， ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","不要叫外人看到你在禁食，因圣父在隐秘中正在观察你，必将与你予以赏赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","不可在这世界上堆积财富，因地上有虫蛀，有锈蚀，还有贼闯入偷窃。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","你应在天堂积聚财富，那里没有虫蛀锈蚀，没有盗贼偷窃。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","因为你最看重什么，就表明你是谁。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","你的眼，就是点亮身体的灯。若眼睛健康，整个身体就会亮起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","若眼睛邪恶，你的身体就会身处黑暗。如果你心中的‘光’成为黑暗，那才是真正的黑暗！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","一个人不能侍奉两主；你必会爱其中一人，恨另一人，或忠于其中一人，鄙视另一人；你无法同时服务于上帝和金钱。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","所以我要说的是，不必担心生命，忧虑衣食住行。难道生命不比食物重要？身体不比衣服更重要？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","看天空中的鸟：它们不播种、不收割、不存粮食，但天父仍喂养它们。难道你们不比它们更宝贵吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","你们谁又能通过忧虑，让寿命延长一分钟？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","何必为衣着忧虑？看看田野中那些美丽的鲜花，看看它们成长的方式：不必辛苦劳作，不必忙于纺织。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","但我想说的是，即使是所罗门最荣耀时刻的穿着，也比不上任何一朵野花。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","田野的草今天还在，明天就会被扔进炉火中，如果上帝这样装扮田野，你们这些缺乏信任的人，上帝又怎会为你们做更多？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","所以不要忧虑，不要想着：‘我们该吃什么？喝什么？穿什么？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","这些只是异教徒的追求，你们的天父知道你们需要的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","先求他的国度，求他正确的生活方式，一切都会赐给你。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","所以不要为明天忧虑，因为明天自有明天的担忧。每天邪恶的事情已经够多了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“不可判断其他人，否则你也会被判断。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","你们论断其他人的标准，其他人就会用这标准论断你，你们用什么标准衡量他人，他人也必同样衡量你。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","为什么你只看到兄弟眼中的木屑，却不理会自己眼中的梁木？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","若你自己眼中有梁木，怎能对兄弟说：‘让我除掉你眼中的木屑’呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","这就是伪君子的行为！要先拿走你眼中的梁木，才能看清楚，才有资格除掉兄弟眼中的木屑。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","不要把圣物丢给狗，也不要把你们的珍珠丢给猪，这样猪就不会将其践踏，狗就不会转过来攻击你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","如果你求，自会给你； 如果你寻找，就会找到； 如果你敲门，门就会为你打开。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","因为凡祈求必得到，寻找必寻见，敲门必开门。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","如果你的儿子向你要饼，你会给他石头吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","如果他要鱼，你会给他蛇吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","即使你们中的邪恶之人，尚且知道把好东西送给儿女，何况你们的天父，自然更会把好东西赐给祈求之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","所以，在对待其他人时，要用你希望他们对待你的方式，这就是律法和先知们的律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","进入必经窄门，只有通往灭亡之门才会大敞大开，道路宽阔，那是很多人都会走的路。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","但通往生命之门狭窄，道路难行，那是寥寥几人会走的路。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","小心假先知！他们披着羊皮出现，内心却是残暴的狼。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","通过果实就可以辨认它们：荆棘中如何摘到葡萄？蒺藜中如何看到无花果？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","所以，好树结好果，坏树结坏果； ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","好树不能结坏果，坏树也不能结好果。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","不结好果之树，必会被砍下丢在火中。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","因此你们凭其果子就可以认出他们来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","不是每个人喊我‘主啊，主啊！’，就都能进入天国，唯有遵行天父圣意，才能进入。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","到审判日那天，必有许多人对我说：‘主啊，主啊，难道我们没有以你的名预言，以你的名驱赶魔鬼，以你的名行神迹？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","但我会告诉他们：我从来不认识你们，你们这些作恶之人，走开吧！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","所以，凡听见我的话并遵行之人，才是聪明之人，他们会在结实的岩石上修建房屋。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","无论是倾盆大雨、大水泛滥、狂风呼啸，这房屋都不会倒塌，因为它稳稳修在结实的岩石之上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","凡听我这番言语却不遵行，就如将房屋盖在沙土上的愚人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","雨淋、水冲和风吹会摇撼他们的房屋，房子会倒塌，而且很彻底。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","耶稣讲完这番话，民众都惊奇他的训诫。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","因为耶稣教导他们的样子更像权威之人，而非他们熟悉的宗教老师。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","耶稣走下山，许多人跟随而行。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","有一个麻风病人前来跪拜，说：“主啊！如果你愿意，请治愈我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","耶稣伸出手触碰他，说：“我愿意，你治愈了！”那人的麻风病立刻治好了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","耶稣对他说：“不可告诉别人，去让祭司看你的样子，然后照着摩西所要求的献上供物，作为向大家展示的证明。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","耶稣进入迦百农后，一名百夫长前来恳求帮助。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","他说：“主啊！我的仆人瘫痪了，躺在家里非常痛苦。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","耶稣回答：“我去医治他。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","百夫长说：“主啊，让你来到我的舍下实在不敢当。只要你说一句话，我的仆人就能好了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","我本人是当权者的手下，也有士兵听我的指挥；我对这个说‘过去！’他就会过去；我对另一个说‘过来！’他就会过来；我对仆人说‘做这个！’他就遵命。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","耶稣听了这番话很惊讶。他对跟随的人说：“说实话，我在以色列从未见过如此有信心之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","我告诉你们，必有许多人从东方和西方赶来，与亚伯拉罕、以撒和雅各在天国里共同进餐。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","但王国的继承人将被扔入彻底的黑暗，在那里哭泣和咬紧牙关。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","然后耶稣对百夫长说：“回去吧！因为你信将要发生之事，所以你所求之事必会发生。”话音落地，他的仆人便痊愈了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","耶稣来到彼得家里，看见他的岳母躺在床上正在发烧。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","耶稣摸她的手，高烧便退去，她立刻起来为耶稣煮食。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","夜幕降临，有人带了许多魔鬼附体之人来见耶稣，他只用一句话就命令恶灵退去，医好了所有患病之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","这便应验了以赛亚先知所说：“他治愈我们的疾病，让我们于病患中解脱。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","耶稣看见许多人围着他，便指示他们到对岸去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","一位宗教老师前来对他说：“老师，你无论往何处去，我都将跟从于你！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","耶稣对他说：“狐狸有自己的洞穴，天空飞鸟有自己的窝，但人子却无处栖身。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","另一个门徒对耶稣说：“主啊！请先准我回去安葬我父。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","耶稣回道：“跟我来！让亡者去埋葬亡者。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","耶稣登上船，门徒们跟随他上船。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","忽然海上刮起狂风，浪涛几乎淹没整船，但耶稣却安然睡着。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","门徒们走来把他唤醒，说：“主啊！救救我们！我们要被淹死了！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","耶稣问他们：“你们为什么这么害怕？ 为什么这么不信任？” 然后他起身命令风浪停止，一切变得完全平静， ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","门徒们惊奇不已，说：“这到底是什么人，连狂风和海浪也听从于他？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","耶稣来到对岸，这里是加大拉人的地区，这时遇见两名魔鬼附身之人从墓里出来，向他走来。他们如此凶险，没有人敢走那条路。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","魔鬼附身之人喊叫：“上帝之子，你想拿我们怎么样？是我们时候未到，你就来这里折磨我们吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","远处有一大群猪正在进食。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","魔鬼祈求耶稣说：“如果你要赶我们从人体出来，就让我们附身猪群吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","耶稣对他们说：“去吧！”魔鬼便离开人身，附身猪群。那群猪沿着陡峭山崖跑下去，掉在海里淹死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","猪倌跑到了城里，把鬼附身之人的遭遇和所有发生的事情，都告诉了城里人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","全城居民都来到郊外去见耶稣。找到他之后，便求他离开这个地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","于是耶稣上了一艘船，渡过海来到他住过的城。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","城里有人将一个躺在垫子上的瘫痪之人带到耶稣面前，耶稣看到他们很相信他，就对床上的瘫痪之人说：“我的朋友，开心点！你的罪被饶恕了！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","有几位宗教老师对彼此说：“这人说的是亵渎上帝之语！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","耶稣看出他们的想法，于是询问道：“为什么你们心中存有恶念呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","说‘你的罪被原谅了’，或‘站起来行走吧’，哪一个更容易？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","但我想要让你们信服的是，人子也有宽恕罪的权利......”他对瘫痪之人说：“起来，拿起你的垫子回家去吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","那男人于是起身回家去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","民众看到眼前的一切，顿生敬畏之心，赞颂上帝能够赋予人类这样的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","耶稣随后继续走下去，看见一个名叫马太之人，坐在交税亭处，于是对他说：“跟我走吧！”马太于是起身跟随了耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","耶稣在马太家中吃饭的时候，很多税吏和罪人也前来，坐在桌前与他和门徒一起吃饭。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","法利赛人看到这一幕，就询问耶稣的门徒说：“你们的老师为什么跟税吏和罪人一起吃饭呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","耶稣听见这个问题就回答：“健康的人不需要医生，有病的人才需要， ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","去想想这是什么意思：我只希望你们能够悲悯，并非带给我献祭，我来此并非为了感召正道之人，而是为了感召罪人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","这时，约翰的门徒前来问耶稣：“我们和法利赛人常常禁食，你的门徒为什么不禁食呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","耶稣回答：“在婚礼中，宾客与新郎在一起时怎能面露哀伤呢？但如果到时候新郎被带走，他们就会禁食了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","没有人会拿一块新布补在旧衣服上，因为补丁会把衣服扯破，裂开更大的口子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","也没有人用旧的羊皮袋装新酒，因为皮袋会被胀破，酒漏出来，皮袋也损坏了。人们总是会把新酒装在新皮袋里，这样两样都可以保全。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","耶稣对他们说话的时候，有一位当地的官员走来跪在他面前说：“我的女儿刚刚死去了，能不能请你来将手放在她身上，我知道这样她一定会重获生命。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","于是耶稣和门徒起身跟着他走去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","这时人群中一个女人患血漏病已有十二年，她走到耶稣背后，摸他衣服的褶边。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","她在心里默念：“只要摸到他的衣服，我就会痊愈。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","耶稣转过身看着她，说：“开心起来！你对我的信心让你痊愈。”那女人便立刻好了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","耶稣向那官员的家走去，看见有吹笛的乐人和大声哭泣的民众。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","于是他对众人说：“请离开吧！这女孩并非死去，只是睡着了。”众人纷纷嘲笑他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","耶稣让众人离开后，进屋拉着女孩的手，女孩便苏醒并下了床。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","这消息传遍整个地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","耶稣随后继续前行，有两名盲人跟随他，喊着说：“大卫的子孙，可怜可怜我们吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","耶稣走进了他居住的房屋，盲人也走进去。 耶稣问他们：“你们相信我能这样做吗？” 他们回答：“主啊，是的。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","于是耶稣触摸他们的眼睛说：“有你们对我的信任，它就会发生。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","于是盲人就看见了。耶稣嘱咐他们：“千万不可告诉他人这件事。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","但他们却把耶稣的事迹传遍这片地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","耶稣和门徒们离开时，有人带着一个被魔鬼附体的哑巴见耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","耶稣赶走他身上的魔鬼，哑巴就说话了。众人都很惊奇，纷纷说：“在以色列从未发生过这样的事。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","但法利赛人说：“他不过是利用魔鬼之王的力量驱赶魔鬼而已。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","耶稣走遍各处，造访城镇乡村，在会堂里教导人，宣扬天国的福音，医治各种疾病。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","看见人群，耶稣感到深深的怜悯，因为他们困苦无依，一如没有牧羊人的羊群。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","他于是对门徒说：“收成多，工人少。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","所以你们应向丰收之上帝祈祷，派更多工人收割他的庄稼。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","耶稣叫了十二门徒来，赐给他们力量，可以赶出污灵和医治各种疾病、各种病症。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","十二门徒的名字如下：首先是西门（又名彼得）、西门的弟弟安得烈、西庇太的儿子雅各，雅各的弟弟约翰、 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","腓力、巴多罗迈、多马、税吏马太、亚勒腓的儿子雅各、达太、 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","激进派的西门和之后出卖耶稣的加略人犹大。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","耶稣让这十二个人出门，嘱咐他们：“不要去异教徒那里，撒玛利亚人的城市也要避开。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","你们要造访的，是以色列那些迷途之羊。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","你们要一边走一边宣扬：天国将近。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","要医治患者，让死人复活，治愈麻风病人，赶走魔鬼。你们免费获得这样的能力，也要免费送给别人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","你们的口袋中不要携带金、银、铜钱。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","一路不要带着行囊或两件披风，不要穿鞋或带手杖，因为劳作之人值得获得支持。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","无论走进哪座城市或乡村，都要问那里有谁遵循良善之道，然后住一段时间再离开。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","你走进这些人的房屋后，要向他们祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","如果这屋配得上，你们的平安就必将落入屋中；如果这屋配不上，你们的平安仍随你而行。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","如果有人不欢迎你们，不听你们的话，那就离开那个房子或那个城，一边走一边抖掉脚上的灰尘。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","实话告诉你，在审判日那天，索多玛和蛾摩拉也不会遭受这么多的痛苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","现在，我派你们出去，就好比羊走进狼群。所以你们要像蛇一样聪明，像鸽子一样无害。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","要小心，因为有人要把你们送到公议会，会在会堂中鞭打你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","因为我的缘故，你们还会被带到统治者和君主面前，向他们和异教徒作证。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","你们被捕之时，用不着担心说什么和怎么说，因为那时你们必会在恰当之时说出恰当之语。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","因为那时说话之人并非你们，而是你们的天父之灵，他通过你们在说话。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","兄弟会彼此背叛相残，父亲会出卖儿女，儿女要悖逆父母，害死他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","你们坚持到最后，所以会被众人恨恶，然而忍耐到最后必会得救。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","如果有人在城中迫害你们，就逃到其他城去。实话告诉你们，你们还没有走遍以色列各城之前，人子便已到来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","信徒不能比老师更伟大，奴仆也不能胜过主人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","学生若像老师，奴仆若像主人，就应该感到满足。如果一家之主被称为魔王别西卜，那么他的家人甚至可能会被称作更可怕的名字。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","所以不要怕他们。遮掩之事必会揭露，隐藏之事终将揭晓。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","我在暗处告诉你们这一切，你们要在光明之处宣讲。你们听见的是耳语，但要在房顶上大声宣扬。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","不要害怕那些在身体上杀死你、但不能在精神上的上杀死你的人。相反，要害怕那可以在哥和拿中摧毁你身体和精神上的的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","两只麻雀能卖一个铜钱，如果天父不知道，就不会有一只麻雀落在地上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","天父甚至知道你们有多少根头发。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","所以不要怕，你们比一堆麻雀贵重得多。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","凡在人前宣布承认我之人，我也会在天父面前承认他， ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","凡是在人前不认我的，我在天父面前也不会认他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","你们不要以为我的到来，是为大地带来和平，我并非带来和平，而是刀剑。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","我的到来会让父与子对立，女儿与母亲的对立，媳妇与婆婆作对。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","你的敌人将是你的家人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","若你爱父母胜于爱我，便不配属于我；若你爱儿女胜于爱我，便不配属于我； ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","如你不背起自己的十字架跟从我，便不配属于我。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","顾惜自己生命，必要失去生命；但为我牺牲生命，必得生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","人们欢迎你们，便是欢迎我，接待我之人，便是接待派我前来的天父。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","人们如果因为先知的身份而欢迎他们，将获得与先知相同的奖励。人们如果欢迎正道之人，将获得与正道之人相同的奖励。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","告诉你们实话，一个人如果给我的门徒一杯冰凉的水，即使是我最微不足道的那个门徒，也绝对获得他的赏赐。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","耶稣吩咐完十二门徒后就离开了，到附近各城教导传道。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","约翰被关在监牢中时，听到基督所做之事，便派他的门徒 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","以他的名义去询问耶稣：“你是我们期盼到来之人吗？还是我们必须继续寻找其他人？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","耶稣回答：“你们回去吧，把听见和看见的都告诉约翰， ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","盲者可见，瘸者可行，麻风患者治愈，聋者可以听见，亡者复活，贫苦者听到福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","不拒绝我者，必被祝福。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","他们继续前行，耶稣对众人讲起约翰。他说：“在荒野中时，你会期待什么？被风吹动的芦苇吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","你们到底想要看什么？身穿华服之人吗？衣着就像王宫中居住的人一样吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","那么，你们到那里想要看什么？先知吗？是的，但我要告诉你，他不只是一名先知。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","他便是经文中所写那人：‘我差遣使者到你前面，为你备好你的道路。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","告诉你们实话，在人类世界中，任何人都不如施洗者约翰伟大，但在天国中，他却是最微不足道的那一个。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","从施洗约翰之时到现在，天国不断遭受猛烈攻击，暴徒企图以武力将其占为己有。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","因为在约翰到来之前，所有的先知和律法都在讲述上帝之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","如果你们准备好相信，那么约翰就是你们应该期待的以利亚。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","如果你有耳朵，就要去听。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","我该把这代人比作什么？它就像小孩子坐在市场中，喊着彼此的名字说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘我们给你们吹笛子，你们却不跳舞，我们唱哀歌，你们也不哭泣。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","约翰前来，禁食禁水，人们说‘他是鬼附体！’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","另一方面，人子确实来了，并且吃了喝了，人们却说：‘你看，这人贪食好酒，与税吏和罪人为友。’但通过他的行为，显示出智慧即为正道。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","随后，耶稣开始批判他曾行过大多数上帝神迹的城，因为那里的人不肯悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“哥拉逊啊，你应感到羞愧！伯赛大啊，你应感到羞愧！在你们那里所行上帝神迹，如果出现在推罗和西顿，城中之人早已披麻蒙灰，想要悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","但告诉你吧，在审判日那天，推罗和西顿的情况会比你们更好。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","至于迦百农，你们会升入天堂吗？不，你们必会跌入冥府。在你们那里行过的上帝神迹，如果行在 索多玛，那座城还会存留到今天。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","但我告诉你们，在审判日那天，索多那城所受的惩罚可比你们轻。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","然后耶稣祈祷：“天父啊，天地之主，我赞美你，因你向智慧和聪明之人隐藏了这一切，却向普罗大众显明。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","天父啊，是的，这样做让你欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","天父已将这一切交给我，只有天父理解其子，只有天父之子及其选择进行启示之人，才理解天父。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","所有挣扎负重之人，到我这里来。我必让你们休息。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","接受我的轭，向我学习，我内心善良谦卑，从我这里你将获得需要的休息。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","我的轭很轻柔，我的负重很轻。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","安息日那天，耶稣走过麦田，门徒们饿了，就摘了些麦穗来吃。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","法利赛人看到便对耶稣说：“你看，你的门徒做了安息日不可做的事。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","但耶稣对他们说：“大卫和他的人在饥饿时做什么，你们没有念过吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","他走进上帝的上帝殿，吃下了只有祭司才能吃的圣饼，而他们其实并不允许这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","律法书中写道：‘在安息日，在殿里供职的祭司即使触犯了安息日规定，也不算有罪。’你们也没有读过吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","让我告诉你们，这里有一位比圣殿更伟大之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","经文中说：‘我要的是怜悯，不是献祭。’如果你明白这句话的意思，就不会认为无罪之人有罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","因为人子是安息日的主。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","然后耶稣离开，来到他们的会堂。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","会堂里有个人的一只手已经残疾。有人问耶稣：“在安息日治病可以吗？”但他这样问，只是想找理由控诉耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","耶稣回答：“假设你有一只羊，在安息日掉进坑里，你难道不把它抓住拉上来吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","难道你不觉得人比羊更贵重吗？所以，在安息日行善是允许的。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","然后他对那残疾之人说：“伸出手来！”手残之人一伸手就复原了，和另一只手别无二致。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","但法利赛人却走出去，开始密谋如何杀掉耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","耶稣知道了，就离开那里，大批民众都跟随他。他医好所有人， ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","但嘱咐他们不可张扬他所做的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","这就应验了以赛亚先知所说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“这便是上帝所选的仆人， 是我所爱之人，让我心生喜悦之人。 我会把我的灵赐给他， 他必向异教徒宣扬正道。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","他不争论，不喧嚷，街上无人能听见他的声音。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","他不会折断残破的芦苇， 不会吹灭将残的灯芯， 但他终会证明使他的审判为正道。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","异教徒都要对他寄以厚望。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","有人带来一个被鬼附体、又瞎又哑之人来到耶稣这里。耶稣医好他，让他能够说话，能够看到。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","众人都很惊奇地说：“难道他真的就是大卫的子孙？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","但法利赛人听说这一切，便说：“他不过是利用魔鬼之王的力量驱赶魔鬼而已。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","耶稣知道他们的心思，就对他们说：“如果一个国家四分五裂，必定毁灭，任何城镇或家庭若四分五裂，必会毁灭。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","如果让撒旦驱除撒旦，他就是在驱逐自己。他的王国又怎能存在？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","我若靠魔鬼之王的力量驱鬼，你们又以谁之名驱鬼呢？这样，你们就是自证错误。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","我若以上帝之灵驱鬼，这就代表天国已降临你们的身边！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","如果你闯进猛士家中，想要夺其财物，难道不是要先将其捆绑起来？只有这样做，你才能拿走他家中的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","未与我站在一起之人，即反对我，不与我聚在一起，即被散落孤立。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","所以让我告诉你们，人所犯的一切罪过和亵渎行为都可以赦免，但亵渎圣灵将无法被宽恕。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","你在说话间得罪人子可以赦免，但得罪圣灵，今生来世均无法得到赦免。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","种下好树便结好果子，种坏树便结坏果子，凭结果就能认出树的好坏。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","你是毒蛇的后代，你这邪恶之人又怎能口中良善？因为你心中所思，必会脱口而出。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","良善之人行善事就会带来良善，人行恶事就会带来邪恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","我告诉你们，在审判之日，人们必会对所说的无心之语负起责任。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","因为你所说之语将被证明为正义或有罪。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","这时，一些宗教老师和法利赛人对耶稣说：“老师，想请你显现一个上帝神迹给我们看看。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","但耶稣说：“只有不相信上帝的邪恶之人，才会想要寻找上帝的神迹，但他们只能看到约拿先知的上帝神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","就像约拿曾在大鱼腹中待上三日三夜，人子也要在土中待上三日三夜。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","待到审判日那天，尼尼微人将会崛起，与这代人一起判定这代人的罪，因为他们在听了约拿的传道后便悔改了。你看，这里有一位是比约拿更伟大之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","在审判日那天，南方女王要崛起，与这代人一起判定这个世界的罪，因为她来自大地的尽头，来此便是为聆听所罗门的智慧。你看，这里有一位是比所罗门更伟大之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","待一个邪灵离开人体，它会在荒芜之地游荡，寻找栖身之所，却遍寻不得。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","然后他说：‘我将回到之前离开的地方。’当它回来时，发现这个地方是空的，一切都很干净整洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","他于是带了另外七个比他更邪恶的恶灵来，全部住了进去。那人后来的情况比以前更糟糕。邪恶的世界必将如此。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","耶稣在对民众讲话的时候，他的母亲和弟弟站在外面，要和他对话。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","有人告诉耶稣：“你的母亲和弟弟站在外面，有话要跟你说。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","他回答那人：“谁是我的母亲？谁是我的兄弟？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","他伸手指着门徒说：“看啊，他们就是我的母亲，我的兄弟！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","凡是遵行天父旨意者，就是我的兄弟姐妹和母亲！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","那天晚些时候，耶稣走到屋外，坐在海边进行教导。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","很多人聚集到他那里，于是他登上船坐下来，但众人都站在岸上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","他以比喻的方式对众人讲了许多故事。 耶稣开始讲述：“一位农民出去播种， ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","有些种子落在路旁，被过来的小鸟吃掉。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","有些种子落在泥土稀薄的石地上，很快就发芽生长。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","但太阳一出来就把它晒干了，又因为根很浅，很快就枯萎了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","有的种子落在荆棘中，荆棘长大后把它挤到一边。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","有的落在肥沃土壤种，结出的果实比种子多了 30 倍、 60 倍、甚至 100 倍。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","如果你有耳朵，就要去听。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","门徒上前问耶稣：“你对他们讲解时，为什么用比喻的方式呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","耶稣回答：“你们有幸获得天国奥秘的显现，但他们没有获得这样的领悟。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","已拥有的，就会为其提供更多，充足有余，凡是没有的，现有的也会被夺走。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","因此，我会用比喻的方式和他们说话，因为他们看不见，听不到，也不明白。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","以赛亚的预言正在他们身上应验：‘即使你们听见了，却不明白，看到了，却不领悟。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","因为他们心思迟钝，不想倾听，闭上了双眼。如果不是这样，他们理当用双眼看见，用双耳倾听，用思想理解。然后他们才会回来找我，让我来医好他们。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","你们的双眼看到了，所以被祝福，你们的耳朵听见了，所以被祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","我告诉你们，曾经有许多先知和善人渴望看到你们所见，但却没有，想听你们所听见的，但却没有。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","所以你们要听这农夫撒种的比喻。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","如果有人听了天国之道却不明白，恶魔就会过来，将撒在其心中的种子夺去，就像撒在路旁的种子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","撒在石板路上的种子比喻的是：有的人在听道后立刻欢喜接受。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","但这只会持续一段时间，因为没有根，一旦出现问题或困难，就会迅速堕落。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","那撒进荆棘中的种子比喻的是：有的人虽然听到了讯息，但生活中的忧虑和财富的迷惑却把正道挤走，结不出果实。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","那撒在肥沃土壤里的种子比喻的是：有的人听了道便理解了，结出果实是撒下去的 30 倍、 60 倍、甚至 100 倍。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","耶稣又讲了另外一个比喻故事：“天国就像农场主把好种子撒在田里。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","但农夫们睡着时，他的仇敌过来，把野草种子撒在麦子中间就走了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","到了发苗吐穗的时候，野草也长出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","农夫们都前来问家主：‘主人，你不是把好种子撒在田里吗？那些野草是从哪里来的？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","农场主回答：‘这是仇敌所为。’仆人问：‘我们要去拔掉它吗？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","他说：‘不用，因为拔野草的时候，恐怕连麦子也会连根拔出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","收割前，先让它们一同生长。到了收割时，我会吩咐工人先拔掉野草，捆起来后焚烧，然后将麦子收进谷仓。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","耶稣又讲了另外一个比喻，说：“天国好像一粒芥菜种，农夫将它种在田里。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","尽管它是最小的种子，但最终却比其他的植物都大，最后长成一棵树，甚至天空的飞鸟都在它的枝头做窝。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","随后耶稣又讲了一个比喻：“天国好像酵母，女人把它放在很多面粉中，最终发酵成一个大面团。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","耶稣用比喻故事向民众解释了这一切，始终采用讲故事的方式。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","这恰巧应验了先知所说：“我要用故事来讲述，解读创世以来的隐秘。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","耶稣离开民众进到屋内，门徒前来问他：“请你解释一下田里杂草的比喻。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","他回答：“那撒好种子的便是人子， ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","田野为世界。好种子即天国之子，野草即邪恶之子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","撒野草的仇敌是魔鬼，收割即代表这个世界的终结，收割的农夫为天使。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","野草会被收割用火焚烧，这个世界也将以这种方式终结。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","届时，人子将差派其天使，所有会让人犯罪的事情和不法之徒，从其国中清除， ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","丢进火炉，他们将在那里哀哭切齿。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","然后，正道之人将如太阳，在天父之国闪耀。有耳者必要听之。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","天国如藏在田里的宝贝，有人发现后会把它藏起来，然后兴高采烈地变卖了自己的一切，买了那块田地。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","天国好像一个商人，搜罗宝贵的珍珠。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","他发现了一颗极贵重的珍珠，就跑去变卖了他的一切，买那颗珍珠。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","天国又好像一个网，撒在海里可网到各种各样的鱼。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","网里的鱼满了，人就把网拉上岸，坐下来拣出好鱼，收起来，不好的就丢在一边。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","这世界终结之时也是如此，天使将出去，把恶人从义人中区分出来， ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","然后丢进火炉，在那里必然会传来哀哭切齿。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","你们明白这一切了吗？” 他们回答：“明白了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","耶稣说：“所以，每一个从天国学习的宗教老师，就像一家之主从宝库中拿出新东西和旧东西。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","耶稣讲完了这些比喻，就离开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","他回到自己的家乡，在会堂里教导众人。众人都惊奇，说：“此人的智慧和奇迹来自何处？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","他不是木匠的儿子吗？母亲是玛利亚、弟弟不是雅各、约瑟、西门和犹大？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","他妹妹不是住在我们这里吗？他这一切从哪里来？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","他们便拒绝相信耶稣。 耶稣告诉他们：“先知处处受到尊重，但他的家园和家人却不会如此。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","因为他们不信，他并未在那里显现多少上帝神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","这时，君王希律听见耶稣所做的一切， ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","就对臣仆说：“这人是从死人中复活的施洗约翰，所以有这样的能力。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","希律曾因弟弟腓力的妻子希罗底的缘故，拘捕了约翰，把他捆绑后关在监里， ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","因为约翰多次对他说：“你和她结婚乃非法之举。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","他想杀掉约翰，但又害怕民众，因为他们都认为约翰是先知。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","到了希律生日的那天，希罗底的女儿在众人面前跳舞，希律非常高兴， ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","于是就向她承诺，无论她要求什么都能给她。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","她在母亲的怂恿下说：“请把施洗约翰的头放在盘子上送给我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","希律对自己刚才的承诺感到后悔了，但碍于在座宾客的面子，就下令满足她的愿望。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","他派人到监牢中砍下约翰的头， ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","把头放在盘子上送给那个女孩，女孩又带给母亲。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","约翰的门徒前来认领了尸体，把它埋葬，然后去告诉耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","耶稣听见后便独自坐船离开，想去一个清净之地独处。民众听说后，便从各个城镇徒步赶来追随他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","耶稣下了船便看见一大群人，心生怜悯，便医好了人群中的病患。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","黄昏时分，门徒前来对他说：“这是荒郊野岭，天色已晚，请让民众散开，让他们回自己的村子里买些吃食吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","耶稣回答：“他们无需离开，由你们给他们吃的就好！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","门徒说：“我们这里除了五块饼和两条鱼，什么也没有。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","耶稣说：“把它们拿过来给我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","他让众人坐在草地上，拿起那五块饼两条鱼，然后望着天，开始为众人祝福，随后把饼掰开，递给门徒，门徒又分给众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","大家最终都吃饱了，剩下的吃食被收集起来，装满了十二个篮子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","最终有五千名男子吃下了这些食物，还不包括妇女和孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","耶稣立刻催促门徒上船，叫他们先到对岸去，他留下来指示民众散开。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","解散了民众后，他独自上山去祷告。晚上降临，他一个人在那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","此时门徒的船已离岸数公里，因为逆风而受波浪侵袭。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","大约凌晨 3 点左右，耶稣在海面上走过来，赶上了他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","门徒见他在海面上行走，惊恐地大叫：“有鬼啊！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","耶稣立刻对他们说：“放心吧！是我！不要怕。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","彼得对他说：“主啊，如果是你，让我也在水面上走到你那里去。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","耶稣说：“来吧！”彼得就下了船，行于水面之上，向耶稣走去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","但他见到风浪就心生害怕，快要沉下去之时立刻呼叫：“主啊！救我！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","耶稣马上伸手拉住他，对他说：“你对我的信太少了，为什么疑惑？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","他们上了船，风停了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","船上的人都开始膜拜耶稣，说：“你真是上帝的儿子。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","他们来到对岸的革尼撒勒地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","当地人认出是耶稣，就把消息传遍整个地区。众人把一切病患都带了过来， ");
INSERT INTO cmnfeb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","他们求耶稣，让患者摸一摸他的衣服，摸着的人都痊愈了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","有法利赛人和宗教老师从耶路撒冷前来，问耶稣： ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“你的门徒为什么违背祖先的传统，在饭前不洗手？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","耶稣回答：“你们为什么因依据传统而违背上帝的诫命呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","上帝说：‘当孝敬父母，’又说：‘咒骂父母必被处死。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","你们却认为如果一个人对父母说：‘我把给你们的东西都献给了上帝，’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","所以这个人就可以不孝敬父母了。你们遵循了传统，却背弃了上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","这是伪君子的行为！以赛亚用来说你们的预言太对了： ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘这些人只把尊敬说在嘴上，思想却在远离我， ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","他们对我的敬拜并无意义，他们所授仅为人类的要求而已。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","耶稣叫来民众，对他们说：“你们要听，也要明白： ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","污秽之物并非口中所入，而是口中所出。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","门徒前来告诉他：“你知道吗，法利赛人对你所说的话很生气。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","耶稣说：“不是我天父栽种的植物，都要连根拔起。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","不用理会他们！他们只是瞎眼的向导。瞎子带瞎子走路，二人都会跌进坑中。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","然后彼得说：“请给我们解释这个比喻吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","耶稣说：“你们还是不明白吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","你没发现吗？入口之物会进入肠胃，然后作为废物排泄出去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","但从口里所出均发自内心，这才会让人污秽。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","因为由心而生的有恶念、凶杀、奸淫、淫乱、偷盗、伪证或诽谤， ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","这些才会使人污秽，不洗手吃饭却不会如此这样。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","耶稣离开那里，向推罗和西顿走去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","一个迦南妇人从那地方出来，喊着说：“主啊，大卫的子孙，可怜我吧！我的女儿被鬼附得很苦。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","耶稣并未回答。门徒上前求他说：“别让她再跟随我们了，她的喊叫很恼人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","耶稣对女人说：“我只是被派到以色列家迷失的羊那里。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","她便跪在耶稣面前说：“主啊，求你帮助我！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","耶稣回答：“把孩子的食物丢给狗吃可不好。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","她说：“主啊，是的，不过小狗也会吃主人桌子掉下的碎渣。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","于是耶稣对她说：“你对我的信心极大，那就让你如愿吧！”从那一刻起，她的女儿就好了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","耶稣在返途中经过加利利之海，便走到附近的山上，坐下。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","人潮不断涌向他这里，带来瘸腿、盲人、残废、哑巴和其他病患，放在他脚前，耶稣便医好他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","民众看见哑巴能说话，残废能复原，瘸腿能行走，盲人能看见，十分惊奇，开始颂赞以色列的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","耶稣唤来门徒，说：“我对这一群人感到很难过，他们与我在一起已有三天，没有进食；我不想叫他们饿着肚子回去，恐怕他们会在路上晕倒。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","门徒对他说：“这荒郊野外的，哪里有足够的食物给这么多人吃饱呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","耶稣问他们：“你们有多少饼？”他们说：“七块饼和几条小鱼。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","耶稣于是吩咐民众坐在地上， ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","然后拿起那七块饼和鱼，祝福这食物，然后掰开递给门徒，门徒又分给众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","所有人都有食物吃，并且吃得很饱。然后他们把剩下的食物收集起来，足足装满了七个大篮子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","吃的人，除了妇女和孩子，共四千人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","耶稣解散了民众后就登上船，来到马加丹地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","法利赛人和撒都该人前来试探耶稣，要求他显现上天的上帝神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","耶稣回答：“黄昏时你们会说：‘天色通红，明天一定是晴天。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","清晨时你们会说：‘天色阴沉暗红，今天一定有风雨。’你们知道如何分辨天色预测天气，却不能分辨时代的征兆吗！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","不信上帝的邪恶之人如寻奇迹之兆，除了约拿的上帝神迹之外，不会有任何上帝神迹显现。”说罢，耶稣就离开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","门徒到了对岸时，才发现忘记了带饼。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","耶稣对他们说：“你们要小心，提防法利赛人和撒都该人的酵母。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","门徒们彼此争论：“他这样说是因为我们没有带饼吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","耶稣知道他们在说什么：“你们对我的信任太少了，为什么你们要议论没有饼这件事呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","你们难道还不明白吗？还记得用五块饼分给五千人，又装满了多少个篮子呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","还记得用七块饼分给四千人，又装满了多少篮子？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","我说的并非关于饼，你们不明白吗？你们要提防法利赛人和撒都该人的酵母。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","这时门徒才领会，耶稣不是叫他们防备做饼用的酵母，而是提防法利赛人和撒都该人的教义。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","耶稣来到该撒利亚，这里属于腓立比的地区。他问自己的门徒：“民众认为人子是谁？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","他们回答：“有人说是施洗约翰，有人说是以利亚，也有人说是耶利米，或是某位先知。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","耶稣继续问门徒：“你们认为我是谁？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","西门（彼得）回答：“你是弥赛亚，是永生上帝之子。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","耶稣对他说：“约拿的儿子西门，你是真正有福之人，因为这启示并非源自凡人肉体，而是我的天父从天上赐予你。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","我还要告诉你：你是彼得，我要在这块岩石上创建我的教会，即使死亡的力量也不能胜过它。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","我要把天国的钥匙交给你，你在人间所禁止之事，也会在天国禁止，你在人间允许之事，也会在天国允许。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","于是耶稣吩咐门徒，不可对人说他就是基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","此后，耶稣开始向门徒解释：他必须去耶路撒冷，然后会受到长老、祭司长和宗教老师的折磨迫害，被杀，在死后第三天复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","彼得于是把耶稣拉到一边，责怪他说：“上帝不容，主啊，千万不可如此，这事怎能发生在你身上。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","耶稣转身对彼得说：“走开吧，撒旦！你是绊倒我的陷阱，因为你所思并非上帝之意，不过人类思想而已。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","随后耶稣对门徒说：“如果有人愿意跟从我，就当舍弃自己，背起你的十字架追随我。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","若你想拯救自己生命，必丧掉生命，但为我牺牲生命，必得生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","纵使抓住全世界，却赔上自己的生命，有何益处？人能用什么换回自己的生命呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","人子将在天父的荣耀中与众天使共同降临，届时他给每个人的，都是每个人行动应得的。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","和你们说实话，站在这里的人，有的人必会在有生之年看见人子携其国度降临人间。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","六天后，耶稣带着彼得、雅各和雅各的弟弟约翰，登上一处高山，只有他们几个。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","耶稣在他们面前变身，面孔如太阳一样照耀，衣服洁白如光。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","忽然，摩西和以利亚出现在他们面前，与耶稣说话。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","彼得对耶稣说：“主啊，在这里真好。如果你愿意，我就在这里搭三座棚，一间为你，一间为摩西，一间为以利亚。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","彼得说话的时候，一朵明亮的云彩笼罩他们，云中有声音说：“这是我所爱之子，他让我高兴，你们要听他的。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","门徒听见，便俯伏在地上，惊恐万分。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","耶稣前来，摸着他们说：“起来，不用怕。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","他们抬起头来，却只见耶稣自己，别无他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","下山的途中，耶稣吩咐他们：“人子从死亡中复活以前，不要把所见异象告诉其他人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","门徒就问他：“那为什么宗教老师会说，以利亚先来？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","耶稣回答：“以利亚定会出现，准备好一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","但我要说的是，以利亚已经降临，只是人们不认识他，随意待他。人子必会因他们遭受苦难。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","门徒方然领悟，耶稣所指为施洗约翰。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","耶稣和门徒来到民众处，一个人前来，跪在耶稣面前说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“主啊，可怜我的儿子吧，他患了失心疯，非常痛苦，经常会跌入水火之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","我带他去见你的门徒，但他们无法医好他。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","耶稣说：“你们不肯相信我，如此堕落！我要在这里与你们待到何时？我要忍受你们到何时？把孩子带到我这里。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","耶稣与恶鬼对峙，让那鬼离开了孩子，孩子马上就好了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","稍后，门徒悄悄来问耶稣：“为什么我们无法驱鬼？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","他说：“因为你们的信心不够。告诉你们吧。只要你们有信心，哪怕只像一粒芥菜种那么小，也能对这山说：‘从这里移到那里’，它也会移开，没有什么不可以。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","耶稣与门徒走过加利利的路上，耶稣对门徒说：“人子将被背叛，人将凌驾于他之上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","他们将杀害他，但第三天他会复活。”这话让门徒们心生悲伤。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","他们来到迦百农，负责收殿税的税吏前来对彼得说：“你们的老师不纳丁税吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","彼得说：“当然纳税。” 当他走进屋子里，耶稣已经预料到这段对话，于是说：“人间的君王向谁征收关税和殿税，向自己的孩子还是外人？你怎么看，西门？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","彼得回答：“外人。”耶稣对他说：“这样，他的孩子就可以免税了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","但我不想冒犯任何人。所以你要到海边去钓鱼，把钓上来的第一条鱼拿起来，掰开鱼嘴，就会找到一个大银币，可以拿去交给他们，做你我的殿税。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","这时门徒前来问耶稣：“天国里谁最伟大？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","耶稣叫来一个小孩子站在他们当中，说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“实话告诉你们，如果你们不改变思维方式，变成像小孩子一样，一定不能进天国。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","所以，凡谦卑如这小孩子，在天国里便最伟大。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","凡因我之名接受这样的小孩子，便是接受我。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","但任何人如让这信我的小孩犯罪，最好在他们的脖子上系一块大磨石，把他沉在深海。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","灾祸正在降临这个世界，因为这里有太多让人犯罪的诱惑。诱惑必然降临，但对于带来诱惑之人，这必是一场灾难！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","如果你的手或脚让你犯罪，就把它砍下丢掉。即使缺手缺脚，但你却可以获得永生，总好过手脚齐全坠入永不熄灭之火。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","如果你的一只眼睛让你犯罪，把它挖出来丢掉。一只眼睛进入永生，总比两眼齐全坠入哥和拿好。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","你们要小心，不要轻视任何小孩。我告诉你们，他们的天使在天上，常常见到天父的面。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","一个人有一百只羊，如果丢了一只，他会不把九十九只留在山上，去寻找迷失的那只？你们认为呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","告诉你吧，他若找到了丢失的羊，就只是为这一只羊欢喜，胜过那未迷路的九十九只。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","同理，你们的天父也不愿意丢失任何一个小孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","如果你的兄弟对你做出罪行，在与他单独相处时，要指出他的过失。如果他肯听，便还是你的兄弟。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","如果他不肯听，就再带一两个人，凭两三个证人之口，就会更加确认真相。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","如果他还是不听，就告诉教会，如果他连教会也不听，就把他看作异教徒和税吏吧。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","告诉你们实话吧，你们在地上禁止的，在天上也被禁止，你们在地上允许的，在天上也被允许。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","我还要告诉你们，人间若有两人同心祈求一件事，我的天父必为他们成全。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","因为无论在哪里，有两三个人以我之名相聚，我就与他们同在。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","这时彼得前来问耶稣：“主啊，如果我的兄弟得罪我，我可饶恕他多少次？七次吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","耶稣对他说：“不是七次，而是七次的七十倍。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","所以天国如一个国王，要和欠其钱财的仆人算账。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","当他开始清算时，一个仆人被带到他面前，此人欠下一万银币。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","他没有钱偿还，主人就下令叫人把他和妻小以及一切统统卖掉，用来偿还。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","那仆人就跪下拜他，说：‘请宽容我，我会把一切偿还于你。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","主人动了慈悲心，便把那仆人放了，免了他的债。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","但之后，这仆人遇到欠他一百个银币之人，就抓住对方并扼其喉咙，说：‘把你欠我的钱还给我。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","那人与他都是仆人，跪下求他说：‘请宽容我，我会还给你。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","他却不肯，反而把另一人押走并关进监牢，等他把所欠的钱财还清。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","其他的仆人见到此景非常沮丧，就去向主人报告这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","于是主人叫他来，对他说：‘你这个恶仆，你求我，我就免了你欠我的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","难道你不应像我怜悯你一样，怜悯你的同伴吗？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","主人大怒，把他送去服刑，等他把所欠的一切还清。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","如果你们不从心里饶恕你的兄弟，我的天父也必这样待你们。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","耶稣讲完这番话后就离开加利利，来到约旦河东的犹太境内。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","有许多人跟着他，他在那里医好了他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","法利赛人前来试探耶稣，说：“男人可以无论任何缘故休妻吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","耶稣回答：“难道你没读过，上帝起初造人，是造男造女的。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","他又说：‘所以男人要离开父母，与妻结合，二人成为一体’。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","这样他们便不再是两个人，而是一体。由上帝连接的关系，没有人可以将其分开。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","他们就问：“那为什么摩西却说男人若给了休书，就可以休妻, 让她离开？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","耶稣回答：“摩西这样说，是因为你们铁了心的态度，才准许你们休妻，但起初并非这样。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","我告诉你们，凡休妻另娶，如果不是因为妻子不贞，便是犯下奸淫罪。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","门徒对他说：“夫妻关系既然如此，倒不如不结婚。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","耶稣对他们说：“不是每个人都能接受这个教诲，只有向其赐予，才能领受。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","有些人是生来就不能结婚，有些人不能结婚是因为被人阉割，也有人是为了天国的原因。能接受者自会接受。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","这时，有人带了小孩子来到耶稣面前，求他为其祝福和祈祷，但门徒们不让他们这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","但耶稣说：“让小孩子到我这里来，不要禁止他们，因为天国就是属于这样的人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","于是他将手放在孩子身上, 为其祝福，然后就离开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","有一个人前来见耶稣说：“老师，我做什么善事才可以获得永生？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","耶稣说：“为什么问我关于善的事呢？善者只有一人。如果你想永生，就应当遵守诫命。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","那人问：“什么诫命？”耶稣回答：“不可杀人，不可奸淫，不可偷盗，不可做假证供， ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","当孝敬父母，当爱邻居如己。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","那青年对他说：“这一切我都遵守了，还缺少什么呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","耶稣对他说：“如果你想要圆满，就变卖你的所有分给穷人，你在天国便必有财宝，而且你要跟从我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","那青年听见这话，就满脸忧愁地离开了，原来他很富有。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","耶稣对门徒说：“告诉你们真相，有钱人很难进入天国。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","我还要告诉你们，骆驼穿过针眼，比有钱的人进上帝之国还容易！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","门徒听此甚为惊奇，于是询问：“如果这样，谁会被拯救呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","耶稣看着他们说：“从人的角度是不可能，但对上帝而言一切皆可实现。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","彼得回答：“你看，我们已舍弃一切跟随你，我们会得到什么回报？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","耶稣对他们说：“告诉你们真相，待万物重建，人子坐于其荣耀宝座，跟从我之人也会坐在十二个宝座上，审判以色列的十二个 支派。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","凡因为我而放弃房屋、兄弟、姊妹、父母、儿女或田地，到时候必得百倍，获得永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","有许多先来者将在后，很多后来者将在前。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","天国如一位家主，清早出去雇请工人到他的葡萄园工作。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","他和工人说定一天的工钱是一个银币，然后派他们去葡萄园。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","大约九点钟，他又出门看见还有人闲站在街市上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","于是就对他们说：‘你们也到葡萄园来吧，我会给你们合理的工钱。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","于是他们便去工作了。大概在正午和下午三点钟，他又出门做同样的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","下午五点钟左右，他再出去，看见还有人站着，就问他们：‘你们为什么整天站在这里不去工作？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","他们回答：‘没有人用我们。’他说：‘你们也到葡萄园来吧。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","到了黄昏，葡萄园主对工头说：‘把工人都叫来，给他们工钱，从最后来的开始，最先来的排在最后。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","那些下午五点钟才开始做工的人来了，每个人都领到一个银币。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","最先做工的人也来了，以为会多得一点，但每个人都领到一个银币。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","于是他们就埋怨家主，说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘我们一整天都在烈日之下劳作，这些后来人只工作了一个小时，却得到跟我们一样的工钱。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","家主回答他们说：‘朋友，我并没有亏待你。你我不是讲定了一个银币吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","拿你的工钱走吧！我给后来人的报酬和你们一样，我想这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","难道我不可以照自己的想法使用我的财物吗？还是因为我想做善事，你就不高兴呢？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","因此，先来者将在后，在后者将在前。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","耶稣去耶路撒冷的途中，把十二门徒带到一边，一边走一边说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“我们现在要去耶路撒冷，人子要被交给祭司长和宗教老师，他们会定他死罪， ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","把他交给异教徒凌辱鞭打，钉在十字架上。但他第三天就会复活。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","这时，西庇太之子的母亲带着她的两个儿子前来见耶稣，跪在耶稣面前求他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","耶稣问她：“你想要什么？”她说：“求你下令，让我这两个儿子进入你的王国，一个坐在你的右边，一个坐在你的左边。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","耶稣回答：“你们知道自己在求什么吗？我将要喝的东西，你们能喝吗？”他们回答：“能，我们能喝。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","他对他们说：“你们当然会喝我所喝之物，但坐在我左右的权利并非我所能赐予，我父决定赐给谁，就赐给谁。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","其他十个门徒听见了，对这兄弟二人很恼怒。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","耶稣把他们叫过来，说：“你们知道各国都有统治者管制，有强大领袖管辖。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","但你们不会如此。谁想在你们中间成为统治者，就会成为你们的奴仆。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","谁想在你们中间为首，就会变成奴隶。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","正如人子来，并非为了被他人服侍，而是为了服侍他人，以自己的生命，来赎众人之命。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","他们离开耶利哥的时候，许多人跟着耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","有两个盲人坐在路旁，听说耶稣经过就喊叫：“主啊，大卫的子孙，可怜一下我们吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","民众告诉他们不要出声，他们却愈加放声喊叫：“主啊，大卫的子孙，可怜我们吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","耶稣站住，叫他们过来，说：“要我为你们做什么呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","他们说：“主啊，求你让我们看见。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","耶稣怜悯他们，触摸他们的眼睛后，他们立刻看到，于是开始跟随耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","耶稣和门徒去了耶路撒冷，来到橄榄山的伯法其小村。耶稣派两个门徒出门， ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","对他们说：“到那个村子里去，在那里，你会看见一头驴被绳子拴在那里，它身边还有一头小驴。把它们解开，牵来给我。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","如果有人问你们，就要说：‘主需要它们。’他会立刻让你们牵走。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","这应验了先知所说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“告诉锡安子民，说：‘看哪，你的王来了，他生性谦卑，骑着一头驴，还带着那头驴的幼崽。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","这两位门徒照着耶稣的吩咐而行， ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","牵了母驴和小驴来，把衣服搭在驴身上，耶稣骑了上去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","人群中有很多人把自己的衣服铺在路上，也有人从树上把树枝砍下，铺在路上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","前呼后拥的民众喊叫着：“颂赞归于救世主，大卫的子孙，他奉主之名前来，有福了。高高在上和散那！。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","耶稣进了耶路撒冷，全城轰动，城中人问：“此人是谁？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","人群回答：“这就是先知耶稣，来自加利利的拿撒勒。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","耶稣进了圣殿，把殿里所有买卖人都赶走，推倒换钱的桌子和卖鸽子小贩的凳子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","他对他们说：“经书上写着：‘我的殿应为祷告的殿。’你们竟把它弄成贼窝了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","殿里的盲人和瘸腿之人都走过来，耶稣医好了他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","祭司长和宗教老师眼见耶稣所行奇事，又看见小孩子在殿中喊叫“救世主，大卫的子孙”，就很忿怒，对耶稣说：“你听见孩子们说什么吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","耶稣说：“我听见了。你没念过这段经文？‘你从小孩和婴儿的口中，听到赞美。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","耶稣于是离开他们出了城，来到伯大尼，在那里过了一夜。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","耶稣第二天清早回城的时候，觉得饿了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","他看见路旁有一棵无花果树，就走过去，但树上除了叶子什么也没有，于是它对树说：“你永远不会结果了。”那棵树就立刻枯萎。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","门徒看见了，十分惊奇，说：“这棵无花果树为什么立刻枯萎了？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","耶稣回答他们：“告诉你们实话，如果你们相信上帝，不怀疑，不但可以像我对无花果树所做的那样，还可以对这座山说‘移走吧，落入海中’。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","你们祷告，无论求什么，只要相信，必会心想事成。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","耶稣走进圣殿，他在教导众人的时候，祭司长和民间长老前来问他：“你凭什么权力做这些事？谁给你这权力？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","耶稣回答他们：“我也要问你们一句，如果你们回答我，我就告诉你们我凭什么权力行这些事。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","约翰的洗礼从何而来？从天上来，还是从人中来？”他们开始商讨：“如果我们说‘从天上来’，他会问我们‘那你们为什么不信他呢？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","如果我们说‘从人中来’，民众又会对付我们，因为他们会认为约翰就是先知。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","于是他们回答耶稣：“我们不知道。” 耶稣也对他们说：“那我也不会告诉你们，我凭什么权力行这些事。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","我来给你们一个比喻。一个人有两个儿子。他对大儿子说：‘孩子，你今天到葡萄园去工作吧。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","儿子回答：‘我不想去。’但后来他改变了主意，去了葡萄园。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","父亲同样吩咐小儿子。小儿子说：‘父亲，我会去的。’但却没有去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","你们说，这两个儿子，哪一个更听父亲的话？” 他们回答：“大儿子。” 耶稣对他们说：“我告诉你们实话，税吏和娼妓都会比你们先进入上帝之国。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","约翰前来指示你们上帝的正道之路，你们不信他，但税吏和娼妓却信他。你们看见后，仍未改变心意去信他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","这里还有一个比喻：有一位家主种了一个葡萄园，四面围上篱笆，在园子里挖了一个踩葡萄酿酒的池子，盖了一座瞭望台，然后把园子租给佃户，就远行去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","到了收获之时，园主派了仆人到佃户那里，去收属于他的葡萄。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","佃户却攻击仆人，打伤一人，杀了一人，又用石头砸死一人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","于是园主再派其他的仆人去，人数比前一次更多，但佃户用同样的方式对付他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","最后他派了自己的儿子去，说：‘他们必尊敬我的儿子。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","佃户看见他的儿子，就开始商量：‘这是继承产业之人，杀了他，我们就能占有他的产业！’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","于是他们抓住园主之子，把他推到葡萄园外杀了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","那么，如果葡萄园主前来，会怎样对待那些佃户？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","众人回答：“他会毫不留情地除掉那些恶人，把葡萄园租给按时缴纳葡萄的佃户。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","耶稣对他们说：“你可曾记得经上所说：‘建筑工人所弃的石头，成了房屋的奠基石，这是主所为，我们视为奇迹。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","所以我要告诉你们，上帝之国将从你们这里取走，赐给那结正道之果的异教徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","摔在这石头上的人，必会粉身碎骨，这石头掉在谁的身上，也必将其压得粉碎。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","祭司长和法利赛人听了耶稣这番比喻，知道这是暗指他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","他们想要逮捕耶稣，但又害怕民众，因为他们都认为耶稣是先知。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","耶稣又讲述了一个比喻： ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“天国好比一个王，为儿子摆设婚筵。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","他派仆人去请受邀之人来参加婚筵。但他们不肯来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","他再派另一些仆人去，对他们说：‘告诉那些受邀之人，我已经预备好了筵席，宰杀了公牛和肥畜，一切都预备妥当。来参加婚筵吧！’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","但那些人却不理会这番邀请，掉头走开，有的去耕田，有的去做买卖， ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","还有些人抓住王的仆人，凌辱他们，把他们杀了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","王怒火中烧，派兵消灭那些凶手，焚毁他们的城。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","然后对仆人说：‘婚筵已经预备好了，只是受邀之人不配来此。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","你们去大路口站着，邀请所有遇见之人来参加婚筵。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","那些仆人走到街上，把所有遇见之人，无论好坏，都招聚而来，很快婚筵就满座了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","王进来与赴筵之人见面，发现一人没有穿着婚筵的礼服， ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","于是王就对他说：‘朋友，你没有婚筵礼服，怎能进入这里？’那人无话可说。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","于是王对侍从说：‘把他的手脚都绑起来，丢到黑暗中，在那里必有哀哭切齿。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","因为受邀人很多，但很少是他选择之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","法利赛人离开了，聚在一起商量，怎样通过耶稣所说的话来陷害他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","他们派了自己的门徒和希律党的门徒一同去问耶稣：“老师，我们知道你为人诚实，你所传授上帝之道皆为真理。你不允许任何人影响你，不在乎头衔或地位。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","那么请说说你的看法：纳税给凯撒，可不可以？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","耶稣看出他们的恶意，就说：“虚伪的人，为什么试探我？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","把纳税的钱币给我看看。”他们拿了一个银币递给耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","耶稣问他们：“这上面是谁的头像，谁的名号？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","他们回答：“这是凯撒。” 他就对他们说：“凯撒的就应当归于凯撒，上帝的就应当归于上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","这话让他们分外震惊，于是就离开他走了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","撒都该人从来不相信复活。那天晚些时候，他们前来问耶稣： ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“老师，摩西说如果一个已婚男人死了，没有儿女，他的弟弟就应该娶他的妻子，为哥哥留后。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","以前我们这里有兄弟七人，老大结了婚，没有孩子就死了，留下妻子给他的弟弟。嫁给老二后，老二死了，嫁给老三，老三死了， ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","直到最后同样的事情又发生在老七身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","最后那女人也死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","那么复活的时候，她会是这七兄弟中哪人的妻子呢？因为他们都娶过她。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","耶稣回答：“你们错在不明白圣经，也不知道上帝的能力。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","复活之后，人们不娶也不嫁，就像天堂的天使一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","关于逝者复活之事，难道你们没读过上帝所说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘我是亚伯拉罕的上帝，以撒的上帝，雅各的上帝’，上帝并非死人之上帝，而是活人之上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","民众听了他所说的，对其教义感到很惊异。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","听说耶稣让撒都该人无言以对，一群法利赛人便跑来提出更多问题。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","其中有一个研究法律的专家，试探耶稣说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“老师，律法中哪一条诫命最重要？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","耶稣回答：“‘你要全心、全性、全意爱你的主，你的上帝。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","这是最重要的受要诫命。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","第二条与它相似，那就是：‘要爱人如己。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","全部律法和先知之书，均以这两条诫命为根据。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","法利赛人聚在一起之时，耶稣问他们： ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“你们对基督的看法如何？他是谁的子孙？”他们回答：“大卫的子孙。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","耶稣又问：“但受到感召后的大卫为何称他为主？他说 ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘主对我主说：你坐在我的右边，待我击败你所有敌人。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","大卫既然称他为主，他怎么又是大卫的子孙呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","无人能够回答。此后再也没有人敢向他提问。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","然后，耶稣对民众和门徒说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“宗教老师和法利赛人负责解读摩西的律法， ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","凡他们吩咐你们所做之事，你们都要遵行和谨守，但不可效法他们的行为，因为他们不会实践所宣扬的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","他们把重担捆起来，压在人的肩头，但自己却一个指头也不肯动。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","他们所做的一切都只是做给人看，把经文的匣子做大，把他们衣服的流苏做长， ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","他们喜欢筵席上的首位、会堂里的高位， ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","他们喜欢民众在市场向他们问安，称呼他们为‘拉比’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","然而不要让人们称你为‘拉比’，因为只有一人是你们的老师，其他人都是兄弟。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","不要称呼世上之人为父，因为只有一位为你们之父，就是天父。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","也不要让人们称你为老师，因为只有一位是你们之师，那就是弥赛亚。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","你们中间最伟大之人，必做你们的仆人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","凡自称伟大的人，必被看轻，凡自己谦卑者，必被称为伟大。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","虚伪的宗教老师和法利赛人呐，你们即将面临灾祸！你们在人面前关了天国之门，自己不进去，还拦着想要进去之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","虚伪的宗教老师和法利赛人呐，你们即将面临灾祸！你们走遍海洋陆地，只为让人入教。但当其他人入了教，你们却使他沦为哥和拿之子，比你们有过之而不及。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","你们说：‘凡指着圣殿起誓，皆无用处，凡指着圣殿的金子起誓，必须遵守。’这样说多么愚蠢，你们就是盲人啊！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","你们这些盲目的愚昧人，到底是金子伟大，还是赋予黄金神圣地位的圣殿伟大？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","你们又说：‘凡指着祭坛起誓，皆无用处，但指着坛上的祭物起誓，必须遵守。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","盲目之人呐！到底是祭物伟大，还是赋予祭物上帝圣的祭坛伟大？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","所以，凡指着祭坛起誓，他就是指着祭坛和其上的一切起誓； ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","指着圣殿起誓，就是指着圣殿和住在里面的上帝起誓； ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","指天起誓，就是指着上帝宝座和宝座上的上帝起誓。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","虚伪的宗教老师和法利赛人呐，你们即将面临灾祸！你们把十分之一的薄荷、茴香和孜然献祭，却忽略律法上更重要的内容：正义、怜悯和信任。固然献出十分之一的财富很重要，但你们忘记了其他事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","你们这些盲目的向导，你们滤掉了水中的蚊虫，却把骆驼吞下去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","虚伪的宗教老师和法利赛人呐，你们即将面临灾祸！你们清洗了杯子和盘子的外在，内在却满是贪婪和自我放纵。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","瞎眼的法利赛人呐，先把杯和盘的里面洗净，才能让外面也干净。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","虚伪的宗教老师和法利赛人呐，你们即将面临灾祸！你们就是这样， ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","外表看来像正人君子，内在却充满虚伪和邪恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","虚伪的宗教老师和法利赛人呐，你们即将面临灾祸！你建造坟墓纪念先知，装饰漂亮的坟墓。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","你们说：‘我们若活在祖先的时代，决不会和先知一样流血。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","但这样说，你们就是指证自己就是杀害先知之人的子孙。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","那么，用你们祖先的方法完成这一切吧！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","你们就是蛇，就是毒蛇所生，你们怎能逃脱定罪的审判呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","我派先知、智慧人和宗教老师到你们那里，但有的你们要杀害，钉在十字架上，有的你们要在会堂里鞭打，从这城追到那城。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","所有义人流在地上的血， 从义人亚伯到你们在圣殿和祭坛之间所杀的巴拉加的儿子赛迦利亚，都归到你们身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","告诉你们吧，这一切的后果必落在这代人的身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","耶路撒冷啊，耶路撒冷，你们杀害先知，又用石头把派过去的人杀害。我屡次想招聚你的民众，如母鸡将小鸡招到翅膀下，只是你们不愿意。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","你看，你们的家必成为一片荒芜，彻底空荡荡。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","我告诉你们，从今后你们一定见不到我，直到那一天你们说：‘愿上帝保佑那位以主的名义来的。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","耶稣出了圣殿，门徒走上前骄傲地把圣殿建筑指给他看。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","他对门徒说：“你们看这些建筑？告诉你们实话，未来这里将没有一块石头留下，所有的石头都将崩塌。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","耶稣坐在橄榄山上，门徒暗中前来询问：“请告诉我们，何时会出现此事？你的降临和这个世界的终结，会有什么预兆？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","耶稣回答他们：“你们要小心，不要被人迷惑。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","因为许多人会假冒我之名而来，说他就是基督，借此迷惑众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","你们将听见战争，还有关于战争的传言。要小心，但不要惊慌，因为这避免不了，但不是最终结局。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","一个民族要攻打另一个民族，一个国家要攻打另一个国家，处处都是饥荒和地震， ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","这一切不过是诞生之痛的开始。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","然后人们会抓住你们，折磨你们，杀害你们，你们要因我的名而被万民痛恨。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","届时会有许多人会失去信仰，彼此出卖，互相恨恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","也有许多假先知出现，迷惑众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","越来越多的邪恶出现，将人们的爱冷却， ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","唯有忍耐到底者方可得救。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","这王国的福音要传遍天下，向万民听到，然后最终结局才会来到。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","当你们看见那‘污秽的偶像崇拜’站在但以理先知所说圣地（读至此处应认真思考）， ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","那时，住在犹太的应当逃到山上， ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","站在房顶之人，不要下来拿家里的东西， ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","在田里的也不要回去取衣服。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","在那样的日子，对于怀孕的和哺乳孩子的母亲极为可怕！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","你们应当祈求，不要在冬季或安息日的时候逃难， ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","因为那时必有大灾难，这是从世界的开始到现在未曾有过的，以后也必不会再有。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","除非那样的日子变短，否则无人可以存活，但是为了天选之人，那些日子必会变短。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","届时，如果有人对你们说：‘看，基督在这里！’或说：‘他在那里！’你们不要信， ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","因为必有假弥赛亚和假先知出现，做出看似了不起的上帝神迹和奇事。如果可以，他们连天选之民也要迷惑。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","你们看！我已经提前告诉你们了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","如果他们对你们说：‘看！基督在荒野里。’你们不要出去；或说：‘看！他已悄悄降临。’也不要相信。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","似电光从东方闪出来，一直照到西方，人子降临之时也是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‘有尸身之处，必有秃鹫也聚于此’。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","当灾难刚刚过去，太阳黯然，月亮也不发光，众星从天坠落，天上万象震动。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","届时，人子的征兆就显在天上，地上的万族都要哀号，看见人子展示能力，载满荣耀，驾天上之云降临。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","当号角发出响声，他要差派天使，把他的选民从四方、从天和地的各处招聚而来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","这里有一个无花果树的比喻：树枝长出嫩芽生出叶子之时，你们便知道夏天将近。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","同样，当你们看见这一切，就知道人子将要降临你们中间。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","实话告诉你们，这一切必要发生，然后这世界才会过去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","天地都要过去，但我的言语决不会消失。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","至于具体的日期和时间，无人知晓，连天上的使者和人子也不知情，只有天父知道。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","诺亚时代的样子，即是人子降临时刻的样子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","洪水之前的时代，人们吃喝嫁娶，直到诺亚进入方舟的那一天。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","他们不知道会发生什么事，直到洪水来了，把他们全都冲走了。人子降临之时也将是这样。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","届时，有两人在田里工作，一个被带走，一个被留下。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","两个女人在磨坊推磨，一人被带走，一人被留下。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","因此你们要警惕，因为不知道你们的主何时会来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","但想想：家主若晓得窃贼晚上何时会来，自会提高警觉，不让窃贼闯入偷盗。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","所以你们也要准备妥当，因为人子会在想不到日子到来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","谁是忠心和考量周全的仆人？那就是被主人指派管理全家、按时分派粮食的仆人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","主人来到时如果看到他照做，那仆人就有福了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","告诉你们实话，主人将指派他管理自己的一切财产。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","如果他是个恶意仆人，心中暗想：‘我的主人不会那么快回来’， ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","于是就会动手打其他仆人，与醉汉们大吃大喝。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","但在他没有想到的日期和时辰，仆人的主人回来了， ");
INSERT INTO cmnfeb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","他被严厉处罚，一如对待其他虚伪之人那样被送到一个地方，那里必有哀哭切齿。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","天国如十名少女，提着灯出去迎接新郎。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","她们中间有五人蠢笨，五人聪明。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","愚蠢之人拿着灯，却没有带油， ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","聪明之人拿着灯，也把油装在罐里带来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","新郎很晚都没有到，她们打起了瞌睡，睡着了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","半夜时有人喊叫：‘新郎来了，快出来迎接。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","少女纷纷醒过来，整理她们的灯。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","愚蠢之人对聪明之人说：‘请把你们的油分一点给我们，我们的灯快要熄灭了。’聪明之人回答： ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘这些恐怕不够我们大家使用，不如你们自己到卖油之地去买吧！’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","她们去买油的时候，新郎来了，准备好了的少女便和他们进去参加婚筵，门关上了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","随后其余的少女也来到，说：‘主啊，主啊，给我们开门吧！’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","主却回答：‘告诉你们实话，我不认识你们。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","所以要警惕，因为你不知道具体的日期和时间。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","天国又像一个人要外出远行，唤自己的仆人来，把自己的家业交给他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","他按照各人的能力分发钱币：一人给了五袋银币，一人给两袋银币，一人给了一袋银币。然后主人便远行去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","领了五袋银币之人马上去做生意，又赚了五袋银币。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","领了两袋银币之人也是如此，赚了两袋银币。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","但那领了一袋银币之人却在地上挖了个洞，把主人的钱币藏起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","过了很久主人回来了，要和他们算算账目。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","领了五个袋银币的仆人带着赚来的五袋钱币前来，说：‘主人，你给了五袋银币，你看，我又赚了五袋。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","主人对他说：‘良善又忠心的仆人，你做得好！你在小事上证明了自己的忠心，我要派你管理更多事。欢喜吧，因为我真的对你很满意！’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","领了两袋银币也前来，说：‘主人，你给了两袋银币，你看，我又赚了两袋。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","主人对他说：‘良善又忠心的仆人，你做得好！你在小事上证明了自己的忠心，我要派你管理更多事。欢喜吧，因为我真的对你很满意！’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","领了一袋银币的也前来，说：‘主人，我知道你是个严厉之人，即使没有撒种的地方也要收割，即使没有播种的地方也要收获。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","因为我害怕你，于是把你的钱藏在地里。你看，你的钱还在这里。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","可是主人对他说：‘你这可恶又懒惰的仆人，你既然知道我会在没有撒种的地方也要收割，在没有播种的地方也要收获， ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","那你就应该把我的钱存入银行，待我回来的时候，可以连本带利收回。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","你们把他银币拿去，交给那拥有十袋银币之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","因为凡是拥有者，他就会得到更多；凡是一无所有，就算有也会被夺走。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","他将没有用的仆人丢在外面的黑暗里，在那里哀哭切齿。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","当人子携荣耀而来，带着所有的天使降临人间，他会坐在荣耀的宝座上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","所有人都聚集在他面前，他要把他们彼此分开，好像牧羊人把绵羊和山羊分开一样： ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","把绵羊放在右边，山羊放在左边。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","然后，王对右边的人说：‘蒙我父赐福的人，来承受创世以来为你们预备好的王国吧。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","因为我饿了，你们给我食物；我渴了，你们给我解渴；我是陌生人，你们接待我； ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","我赤身露体，你们给我衣服穿；我病了，你们照顾我；我被投入监牢，你们来看我。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","那些正确行事之人回答：‘主啊，我们什么时候见你饿了给你吃食，见你渴了给你解渴？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","什么时候见你陌生就接待你，赤身露体就给你衣服穿呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","什么时候见你病了，或到监牢里看你呢？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","王回答他们说：‘我告诉你们实话，你们这样对待我最微不足道的兄弟，也就是这样对待我。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","王对左边之人说：‘你们是被诅咒的，离开吧，到魔鬼和其使者准备的永恒之火中去吧！ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","因为我饿了，你们没有给我吃；我渴了，你们没有给我解渴； ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","我陌生，你们没有接待我；我赤身露体，你们没有给我衣服穿；我病了或者身处监牢，你们没有来看我。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","他们回答：‘主啊，我们什么时候见你饿了、渴了、陌生、赤身露体、病了或身处监牢，却没有服侍你呢？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","王回答他们：‘我告诉你们实话，你们这样对待我最微不足道的兄弟，也就是这样对待我’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","你们要进入永恒的谴责，良善之人却要进入永生。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","耶稣说完了这一切，就对门徒说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“你们知道两天之后就是逾越节，人子将要被交给其他人，钉在十字架上。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","届时，祭司长和民间的长老会聚集在大祭司该亚法的官邸处， ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","他们商议如何用虚假的借口逮捕耶稣，把他杀害。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","不过他们说：“不可在节日下手，免得引起民众暴动。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","在伯大尼期间，耶稣住在曾患麻风的西门家里， ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","有一个女人拿着一瓶珍贵的香膏前来，当耶稣坐着时，女人就把他倒在耶稣的头上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","门徒看见了就很生气，说：“为什么这样浪费呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","这香膏可以卖很多钱，接济穷人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","耶稣知道了，就说：“何必为难这个女人呢？她为我做了一件美好之事。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","你们常与穷苦人在一起，但你们不会常与我在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","她把这香膏浇在我身上，是为我的葬礼做准备。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","我告诉你们实话，这福音无论传到世界何处，这女人的行为都会被传讲，被后人所纪念。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","这时候，十二门徒中的一人，即加略人犹大，跑去见祭司长，说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“如果我把他交给你们，付我多少钱？”他们给了他三十个银币。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","从那时候起，他就一直在找机会把耶稣交给他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","除酵节的第一天，门徒前来问耶稣：“我们应该在哪里为你预备逾越节的晚餐，请吩咐。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","耶稣说：“你们到城里去见一个人，对他说，老师说：‘我的时候快到了，我将要在你的房子中，和我的门徒守逾越节。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","门徒照耶稣的指示去做，预备好了逾越节的晚餐。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","到了晚上，耶稣和十二门徒一同吃晚餐。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","用餐的过程中，耶稣说：“我告诉你们实话，你们中有一个人要出卖我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","众人非常沮丧，一个接一个地问他：“主啊，是我吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","他回答：“那和我一同把手蘸在盘子里的人，就是要出卖我之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","人子将如预言所述死去，他虽然会离世，但出卖人子的叛徒会面临祸端！这人如果没有生下来就好了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","出卖耶稣的犹大说：“拉比，是我吗？”他说：“这是你说的。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","大家开始吃东西了，耶稣拿起饼，祝福后将饼掰开，递给门徒，说：“你们拿去吃吧，这是我的身体。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","耶稣又拿起杯子，祝福后递给他们，说：“你们拿去喝吧， ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","这是我立约的血，血是为众人而流，让罪过得以救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","我告诉你们，从今以后我不会再喝这葡萄酒，直到我和你们在我父的国度中喝新酒的那一天。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","随后他们吟唱，然后离开去往橄榄山。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","这时候耶稣对他们说：“今天晚上，你们都会放弃我，因为经文上记着：‘我要击打牧人，羊群就彻底散了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","我复活以后，要比你们先到加利利去。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","彼得对他说：“就算所有人都放弃你，我也绝不会放弃。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","耶稣对他说：“我告诉你实话，今天晚上鸡叫以前，你会有三次不认我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","彼得对他说：“就算必须与你一同死，我也决不会不认你。”其他门徒也都这样说。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","耶稣和门徒来到一个名叫客西马尼的地方。他对门徒说：“你们坐在这里，我要到那边去祷告。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","他带了彼得和西庇太的两个儿子一起去，感到痛苦难过。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","他对他们说：“我感到非常悲哀，这感觉仿佛要杀了我，你们留在这里，和我一同守候。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","他稍往前走几步，把脸俯伏在地上，祷告说：“我的父啊！如果可能，求你让这痛苦离开我，但不要管我的想法，只要照你的旨意。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","耶稣回到门徒那里，看见他们都睡着了，就对彼得说：“你们难道不能保持清醒，等我哪怕一小时吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","清醒地进行祷告，以免被诱惑征服。你们心中虽然有意愿，但身体却是软弱的。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","他又再次走开，祷告说：“我父啊！如果这痛苦无法摆脱，一定要我饮下，就愿成全你的旨意。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","他再回来的时候，看见门徒睡着了，因为他们十分疲倦。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","他又离开他们，第三次去祷告，说了同样的话。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","然后他回到门徒那里，对他们说：“你们还在睡觉休息吗？看呐，时候到了，人子即将被交给罪人之手。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","起来，我们走吧！出卖我的人来了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","耶稣还在说话之时，十二门徒中的犹大，带着一大群手拿刀棒之人赶来，他们都是由祭司长和民间长老派来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","叛徒和他们约了一个暗号，说：“我亲吻谁，谁就是耶稣，你们可以抓住他了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","他立刻前来对耶稣说：“拉比，你好。”接着就亲吻他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","耶稣对他说：“朋友，你要做的事，就做吧！”于是那些人上前动手拿住耶稣，逮捕了他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","与耶稣同行的一人伸手拔出刀，砍了大祭司仆人一刀，削掉他的一只耳朵。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","耶稣对他说：“把你的刀收回原处！凡动刀者必死于刀下。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","你知道吗？我可以求我父，他马上就会给我派超过十二个团的天使下来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","但如果这样，经文上预言必然发生之事，就无法应验。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","这时，耶稣对众人说：“你们带着刀棒赶来，是把我当作危险的罪犯捉拿吗？我天天坐在殿里教导众人，你们却没有逮捕我。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","但这整件事却应验了先知书上所述。”之后，门徒都离开他逃跑了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","那些人逮捕了耶稣，把他押去见大祭司该亚法，宗教老师和长老都已经聚集在那里了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","彼得远远跟着耶稣，进入大祭司的官邸，然后和差役坐在一起，想看看事情怎样了结。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","祭司长和全体公议会成员都想找假证供来控告耶稣，想要把他处死。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","虽然有许多人前来作假证供，却找不着证据。最后有两个人前来说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“这人说过：‘我可以拆毁上帝的圣殿，三日之内又把它建造起来。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","大祭司便站起来，对耶稣说：“你为什么不回答？这些人的证词，你有什么好辩解的？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","耶稣沉默。大祭司又对他说：“以永生上帝之名，你要起誓，告诉我们你是不是弥赛亚，上帝的儿子？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","耶稣回答：“这只是你说的，我要告诉你们，从今以后，你们将看见人子，坐在至高者右边，驾着天上的云降临。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","大祭司撕开他的衣服，说：“他说了亵渎之语，我们还需要什么证人呢？你们现在听见了这亵渎之言。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","你们的裁定是什么？”他们回答：“他有罪，他该死。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","于是他们向他的脸上吐唾沫，用拳头打他，也有人用掌掴他， ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","说：“弥赛亚啊，向我们说预言吧！是谁打你呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","彼得坐在外面的院子里，有一个婢女走过来对他说：“你也是和加利利人耶稣一伙的。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","彼得却当众否认，说：“我不知道你说什么。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","他回到庭院的门口，又有一个婢女看见他，对里面的人说：“这人和拿撒勒人耶稣是一伙的。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","彼得再次否认，并且发誓说：“我不认识那个人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","过了一会，站在外面的一人走过来对他说：“你的确是他们中的一员，一听你的口音就认出来了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","彼得就发咒起誓说：“我不认识那个人。”此时忽然传来鸡叫。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","彼得想起耶稣所说的话：“今天晚上鸡叫以前，你会有三次不认我。”于是他就跑出去痛哭。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","清晨时分，所有的祭司长和民间长老都聚集在一起，商议怎样治死耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","他们把他绑起来，押去交给总督彼拉多。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","此刻，出卖耶稣的犹大见耶被稣定了罪，就后悔了，把那三十块银子还给祭司长和长老，说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“我有罪了！我出卖了无辜之人的血！”他们说：“这是你的问题，跟我们有什么关系？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","犹大把银子丢进圣殿，然后跑到一个地方吊死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","祭司长把银子拾起来，说：“这是带血的钱币，不可放在殿库里。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","他们商议之后，就用那些钱买了陶匠的田地，用作异教徒的坟地。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","那块田地被称为“血田。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","这应验了耶利米先知所说：“他们拿了三十个银币，这就以色列人给他估算的价钱， ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","他们用这三十个银币买下陶匠的田，正如主所传来的指示。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","耶稣站在总督面前，总督问他：“你是犹太人的王吗？”耶稣回答：“这是你说的。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","祭司长和长老控告他的时候，他却不回答。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","彼拉多又问他：“他们作证指控你那么多事，你没有听见吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","耶稣一句话也不回答他，令总督非常诧异。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","每逢这时候，总督都会一个惯例，让民众根据自己的意愿，决定释放一名囚犯。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","这时监狱中有个声名狼藉的囚犯，名叫巴拉巴。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","民众聚集的时候，彼拉多问他们：“你们要我释放谁？巴拉巴或是称为基督的耶稣呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","（他知道他们是因为嫉妒才把耶稣交上来。） ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","彼拉多坐在审判台上的时候，他的妻子派人来说：“你们不要对这无辜之人做任何事，因为今天我因为梦到他而受了很多的苦。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","祭司长和长老怂恿民众，叫他们去要求释放巴拉巴，将耶稣处死。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","总督问他们：“这两个人，你们要我释放哪一个？”他们说：“巴拉巴！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","彼拉多对他们说：“那么，我怎样处置那被称为弥赛亚的耶稣呢？”他们齐声说：“把他钉上十字架！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","彼拉多说：“为什么呢？他做了什么恶事呢？”众人更加大声喊叫：“把他钉上十字架！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","彼拉多见局势已定，民众正在酝酿骚动，就拿起水在民众面前洗手，说：“让此人流血与我无关，这是你们的决定。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","民众回答：“让他流血的责任，归在我们和我们子孙的身上吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","于是彼拉多释放了巴拉巴，鞭打了耶稣鞭，再把他送去钉上十字架。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","总督的士兵把耶稣带到军营，召集全队士兵来到他面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","他们脱去他的衣服，给他披上朱红色的外袍， ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","又用荆棘编成冠冕，戴在他的头上，把一根芦苇放在他的右手，跪在他面前戏弄他说：“犹太人之王万岁！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","随后士兵向他吐唾沫，又拿起芦苇抽他的头。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","戏弄完耶稣后，他们脱下他的外袍，给他穿回自己的衣服，带去钉十字架。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","他们出来的时候，遇见一个名叫西门的古利奈人，于是强迫他背上耶稣的十字架。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","一行人来到一个名叫各各他的地方，意为“髑髅地”， ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","把苦胆调和的酒给他喝，他尝了一口但没有喝。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","士兵把他钉上十字架，然后掷骰子分他的衣物。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","随后坐在那里看守他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","他们在耶稣头的上方钉了一块牌子，写着他的罪状：“这是犹太人的王——耶稣。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","同时钉上十字架的还有两个强盗，一个在右，一个在左。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","路过的人嘲笑他，摇着头说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“你不是承诺拆毁圣殿，然后在三日之内将其再建吗？救救自己吧！如果你是上帝的儿子，那就从十字架下来吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","祭司长、宗教老师和长老也同样讥笑他，说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“他救了别人，却不能救自己。如果他是以色列的王，现在从十字架走下来，我们就信他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","他如此笃定地信上帝。如果上帝想要他活着，就让上帝现在救他吧，因为他说自己是上帝的儿子。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","和他一同钉十字架的强盗也都这样侮辱他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","从正午到下午三点钟，黑暗开始笼罩世界。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","大约三点钟，耶稣大声呼叫：“以利，以利，拉马，撒巴各大尼？”（意思是“我的上帝，我的上帝，你为什么离弃我？”） ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","站在那里的几个人听见了就说：“这个人在呼叫以利亚呢。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","有一个人马上跑去拿海绵蘸满了酸酒，用芦苇递给他喝。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","但其他的人说：“别管他，我们看看以利亚来不来救他。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","耶稣再次大声呼叫，然后就吐出了最后一口气。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","忽然，圣殿里的幔子从上到下裂成两半，地动山摇，石头崩裂， ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","坟墓裂开，许多生前做善事的死人也复活了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","待到耶稣复活之后，他们从坟墓中走出，进入圣城，在众人面前显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","百夫长和一起看守耶稣的士兵们，看见地震和所发生的事情，十分惧怕，说：“这个人真是上帝之子。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","有许多妇女在远远观看，她们从加利利开始就跟随耶稣并侍奉他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","她们中间有抹大拉的玛利亚、雅各和约西的母亲玛利亚、以及西庇太儿子的母亲。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","到了晚上，有一个来自亚利马太的富人前来，他名叫约瑟，是耶稣的门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","这个人去见彼拉多，请求认领耶稣的身体，彼拉多同意了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","约瑟领了耶稣的身体，用干净的细麻布裹好， ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","放在他从岩石上为自己新凿出来的坟墓里，然后滚来一块大石头挡住墓门，随后才离开。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","抹大拉的玛利亚和另一位叫做玛利亚的女人都在那里，对着坟墓坐着。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","第二天，即过了“预备日”的那一天，祭司长和法利赛人去见彼拉多，说： ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“大人，我们想起那个骗子，生前说过：‘三天之后，我要复活。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","请你下令把坟墓严密看守，直到第三天，免得他的门徒把他偷去，然后骗民众说：‘他从死人中复活了。’这会导致日后出现比之前更大的骗局。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","彼拉多对他们说：“你们带着卫兵，尽可能严密看守吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","祭司长和法利赛人于是到墓前的石头封好，又派卫兵把守，严密守住坟墓。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","过了安息日，在下一周第一天天亮的时候，抹大拉的玛利亚和另一位玛利亚来看望坟墓。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","忽然地面剧烈震动起来，主的使者从天而降，把石头滚到一边，坐在上面。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","他的脸散发着亮光，衣服洁白如雪。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","看守之人因为害怕而浑身战抖，仿佛死了一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","使者对妇女们说：“你们不要怕，我知道你们在找被钉十字架的耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","他不在这里，已经照他所说复活了。你们来看安放他的地方吧。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","快去告诉他的门徒：他已经从死人中复活了。他会比你们先到加利利去，你们在那里必看见他。我保证。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","她们立刻离开坟墓，又害怕，又欢喜，跑去告诉耶稣的门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","忽然，耶稣向她们迎面而来，说：“你们好。”她们跑上前，抱住他的脚拜他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","耶稣对她们说：“不要怕，去告诉我的兄弟，叫他们到加利利去，他们在那里必会看见我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","她们去的时候，有些卫兵进了城，把发生的一切报告了祭司长。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","祭司长于是和长老聚集在一起商量出个计划，然后拿许多钱用于贿赂士兵， ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","说：“你们要这样说：‘他的门徒晚上过来，趁我们睡着的时候，把他偷走了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","如果总督知道了这件事，我们会说服他，你们不用担心。” ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","士兵收了钱，按照祭司长和长老的指使去做，犹太人至今都流传着这段故事。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","十一个门徒往加利利去，到了耶稣指定的山上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","他们看见耶稣就膜拜他，但仍然有些人怀疑。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","耶稣上前来，对他们说：“天上地上的一切权力都赐给我了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","你们要去让万国之民都做我的门徒，奉父子圣灵的名，给他们施洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","我向你们教导的一切，都要教导他们遵守。记住，我始终与你们同在，直到这世界的终结。”");
INSERT INTO cmnfeb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","这里讲述了上帝之子耶稣基督福音的初始。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","正如以赛亚先知所写：“我派遣使者提前来到，备好你要走的道路。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","在荒野中有人在呼喊：‘预备主的道，修直他的路！’” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","施洗约翰出现在荒野中，宣讲悔改的洗礼，因此救赎罪行。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","犹太和全耶路撒冷的人都来到他身边，承认自己的罪，在约旦河里接受他的洗礼。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","约翰身穿驼毛衣服，腰束皮带，以蝗虫和野蜜为食。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","他这样宣讲：“在我之后将有一人到来，能力远比我强大，我甚至连弯腰给他提鞋的资格都没有。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","我用水给你们施洗，他却会用圣灵给你们施洗。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","这时耶稣从加利利的拿撒勒前来，在约旦河里接受约翰的洗礼。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","他从水中出来的那一刻，天裂开了，圣灵如鸽子般落在他身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","天空传来一个声音：“你是我的爱子，你让我喜悦。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","圣灵随即将耶稣派到荒野。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","他在那里将待上四十天，受到撒旦的诱惑，身边是各种野兽，还有天使来看护他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","之后，耶稣在约翰被捕后来到加利利，宣讲上帝的福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","他说：“预言的时间已到，上帝之国已来临，要悔改并相信福音。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","耶稣沿着加利利海边行走，看见西门和他弟弟安得烈在海上撒网，他们靠打鱼过活。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","耶稣对他们说：“跟从我吧，我要让你们成为获得人的渔夫。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","他们立刻丢下渔网，跟从了他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","耶稣稍往前走了几步，看见西庇太的儿子雅各和弟弟约翰，正在船上整理渔网， ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","耶稣召唤他们，他们立刻离开父亲西庇太和雇工，跳下船跟从耶稣而去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","他们去往迦百农，耶稣随即在安息日进入会堂向民众宣讲。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","民众对他的教导感到惊讶万分，因为他宣讲的方式非常权威，不像是其他的宗教老师。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","忽然，会堂中一个被恶灵附体之人开始喊叫： ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“拿撒勒人耶稣，你为什么要来打扰我们？你是来毁灭我们的吗？我知道你是谁，你是上帝的圣者。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","耶稣打断恶灵的话：“住口！从他身上出来！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","恶灵尖叫着，使这个人陷入抽搐，并从他身上出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","众人都很惊讶，对彼此说：“这是什么？这新教义的权威太大了！即使恶灵也服从于他的命令！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","耶稣的名声立刻传遍加利利一带。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","他们走出会堂，与雅各和约翰一起去往西门和安得烈的家。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","西门的岳母此刻正发烧躺在床上，众人把这件事告诉了耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","耶稣走到她面前，拉着她的手，扶她起来，高烧立刻退去，于是她开始为众人做饭。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","黄昏过后，有人不断把生病和被鬼附体之人带到耶稣面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","全城的人都聚集在门外。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","耶稣医好了很多人的疾病，驱走很多恶鬼。他命令恶鬼不要说话，因为鬼知道他是谁。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","次日凌晨，天还没有亮，耶稣便起身来到荒郊野外进行祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","西门和其他人去寻找耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","找到他后就对他说：“大家都在找你呢！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","耶稣对他们说：“我们必须到附近的其他城镇去，这样我就可以在那里传授福音，我就是为此而来。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","于是他走遍加利利各地，在会堂里传道，进行驱鬼。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","有一个麻风病人前来寻求帮助。他跪在耶稣面前说：“主啊！如果你愿意，就能治愈我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","耶稣动了怜悯的心，便伸手摸他，说：“我愿意，你治愈了！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","这人的麻风病立刻消失了，他痊愈了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","在那人离开以前，耶稣认真地警告他说： ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“不要向任何人讲述这件事。去祭司那里，让他看看你的样子，然后按照摩西的要求，为这洁净献祭，向大家作证。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","但那人离开后仍然到处宣讲，把这事传开了，这也让耶稣无法再公开走进城市，只好留在外面的荒野。可仍有很多人从各处赶到他这里。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","几天后耶稣重返迦百农，关于他回到这里的消息立刻传遍各地。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","许多人纷纷聚集到他屋子里，甚至簇拥在门前。于是耶稣就对他们讲道。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","这时有四个人把一个瘫痪的男人带到耶稣那里， ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","但因为太拥挤，无法将他带到耶稣面前。于是他们跑到屋顶上，将屋顶拆下来，在耶稣上方的开口处，将瘫痪男人和他躺的垫子送了下去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","耶稣看见他们的信心，就对瘫痪之人说：“朋友，你的罪被宽恕了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","当时有几名宗教老师也坐在那里，心中暗自思量： ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“这个人为什么这样说话？他说的都是亵渎上帝之语。除了上帝以外，还有谁能赦免罪恶？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","耶稣很了解他们的想法，就对他们说：“你们为什么这么想这件事？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","说‘你的罪被救赎了’，或‘站起来行走吧’，哪一个更容易？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","但为了说服你们，相信人子也有宽恕罪的力量， ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","我要对你（瘫痪之人）说：‘起来吧，拿起你的垫子回家去吧。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","那人就起来，立刻拿着垫子当着大家的面离开了。众人颇感惊奇，开始颂赞上帝，说：“我们从来没有见过这样的事。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","耶稣走出去，来到加利利海边，众人都汇聚到他面前来，他开始教导民众。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","他继续往前走，看见亚勒腓的儿子利未坐在交税亭处，于是就对他说：“跟我来吧！” 利未就起来跟从了耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","后来耶稣在利未家里吃饭，有很多税吏和“罪人”过来和他和门徒一起吃饭；因为已经有很多人开始跟随耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","看见耶稣与罪人和税吏一起吃饭，法利赛派的宗教老师就对耶稣的门徒说：“他为什么和税吏和罪人一起吃饭？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","耶稣听言，对他们说：“健康人不需要医生，病患才需要，我来此并非召唤正义之人，而是要感召罪人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","此刻约翰的门徒和法利赛人正在禁食。于是有人过来问耶稣说：“为什么约翰和法利赛人的门徒常常禁食，你的门徒却不禁食？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","耶稣回答：“在婚礼中，宾客与新郎在一起时怎么能禁食呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","但等到新郎离开他们，他们就会禁食了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","没有人会用新布去缝补旧衣服，因为补丁会把衣服扯破，裂开更大的口子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","没有人会用旧羊皮袋装新酒，因为皮袋会被胀破，酒漏出来的同时皮袋也损坏了。人们总是会把新酒装在新皮袋里。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","安息日那天，耶稣走过麦田，门徒们饿了，于是摘了些麦穗充饥。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","法利赛人询问耶稣：“你看，你的门徒正在做安息日不允许的事情。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","但耶稣对他们说：“大卫和他的下属在饥饿时做了什么，你没有读过吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","他走进亚比亚他担任祭司的圣殿，吃下了只有祭司才能吃的圣饼，事实上他们并不允许这么做。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","耶稣又告诉他们：“安息日为人之益处而存在，而非人为安息日之益处而存在。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","因为人子是安息日的主。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","耶稣回到会堂，那里有个男人的一只手已经残疾。有人问耶稣：“在安息日可以治病吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","众人观察他会不会在安息日医治那个人，好去控告他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","耶稣对那残手之人说：“起来，站在大家面前！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","然后又对他们说：“在安息日能做哪件事，好事还是坏事？救命还是害命？”众人不发一声。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","耶稣怒目环视他们，为他们的铁石心肠感到难过。于是就对那人说：“伸出手来！”那人把手一伸，手就复原了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","法利赛人离开后，立刻与希律党人一起商量如何对付耶稣和除掉他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","耶稣和门徒回到海边，一大群人跟着他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","还有许多人听说了他所做的一切，纷纷从犹太、耶路撒冷、以土迈、约旦河外和推罗、西顿等地方前来跟随他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","因为人太多，耶稣就吩咐门徒为他准备一条小船，免得众人拥挤他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","他医好了许多人，所有病患都挤过来希望触摸他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","恶灵每次看到他，就仆倒在他面前，大声喊叫说：“你是上帝之子！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","但耶稣严厉要求他们，不要把他的身份张扬出去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","耶稣继续去往丘陵乡村，召唤那些他需要的人，那些人于是纷纷聚来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","他选择了十二个人，称他们为 使徒。他们与耶稣在一起，接受耶稣的派遣，宣传福音， ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","耶稣还赋予他们驱魔的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","他选择的十二个人是：西门（耶稣给他起名叫彼得）， ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","西庇太的大儿子雅各和他弟弟约翰（耶稣给约翰起名叫半尼其，即“雷之子”）， ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","安得烈、腓力、巴多罗迈、马太、多马、亚勒腓的儿子雅各、达太、激进派西门 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","以及后来出卖耶稣的加略人犹大。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","耶稣走进屋子，民众又聚过来，他们甚至没有时间吃饭。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","耶稣的家人听闻这一切，就跑过来想把他带走，说：“他疯了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","但来自耶路撒冷的宗教老师说：“别西卜附在他身上！”又说：“他靠魔鬼之王的力量驱除魔鬼。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","但耶稣把他们叫过来，讲了一个比喻：“撒旦怎能赶逐撒旦呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","一个国家若自相残杀，这个国家就无以为续， ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","一个家庭若内部纷争，这个家庭就会垮掉。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","如果撒旦分裂，哥和拿就不会持久，很快就会灭亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","很显然，一个人闯入壮汉的家想要抢东西，但必须先把壮汉捆绑起来，才可以如愿以偿。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","告诉你们实话，世人的一切罪行和亵渎之话，都可以得到赦免。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","但亵渎圣灵者，永世不得赦免，因为他们犯下永世罪过。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","（耶稣这样说是因为他们说他“有恶灵附体。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","耶稣的母亲和弟弟来了，站在外面向他传了个口信，叫他出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","人群围坐在耶稣身边，对他说：“你母亲和兄弟在外面找你。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","耶稣回答：“谁是我的母亲？谁是我的兄弟？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","他环顾身边围坐之人，说：“这就是我的母亲！我的兄弟！ ");
INSERT INTO cmnfeb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","凡遵行上帝旨意之人，就是我的母亲和兄弟姐妹。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","耶稣又在海边教导众人，很多人赶来聆听。他走上海中的一条船，坐下来，民众则都站在岸上聆听。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","他用了很多比喻故事进行讲授： ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","他说：“听着！有一个农夫要出去撒种， ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","有的种子落在路旁，被过来的小鸟吃掉了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","有的落在泥土稀薄、石头众多的土地上，在浅薄的土层上，种子很快发芽。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","但太阳一出来，就把它晒干了，因为没有实根而枯萎。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","有的种子落在荆棘丛，荆棘长出来后，把它挤住，它无法结出果实。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","那些落在肥沃土壤中的种子，就会繁茂成长，结出果实，是原来的 30 倍、 60 倍甚至 100 倍之多。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","你若有耳可聆听，就听听我所说的讲述。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","耶稣独自一人的时候，始终跟随他的十二门徒和其他人走过来，询问这些比喻的意义。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","耶稣对他们说：“上帝之国的奥秘，只给你们知道，但对于外人只会讲述比喻。因为 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","他们纵使看见了也不会领悟，听见了也不会明白。不然他们就会找到我，获得原谅。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","耶稣问他们：“你们理解这个故事吗？如果不理解，又如何明白其他故事呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","农夫所撒的种子就是福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","落在路旁的种子，就是人们在听福音，撒旦立刻出现，把撒在其心里的福音夺走。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","撒在石地上的种子，代表人听了福音后立刻欢喜接受， ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","但道并未在他们心中落根，只是暂时停留，一旦遇到患难和迫害，他们很快就会沦陷。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","撒在荆棘中的种子则指另一些人，他们虽然听了福音， ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","但现世的忧虑、对财富的迷恋和种种的欲望不断滋生，把福音挤出去，结不出果实。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","落在肥沃土壤里的种子，就是人在听到福音后真正接受它，就会结出比原来多 30 倍、 60 倍、甚至 100 倍之多的果实。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","耶稣又对他们说：“人们在点灯之后，不会将其放在水桶或床下，而是会将其放在灯台上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","所有隐藏之事最终都会显现，所有秘密都会被公开。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","有耳朵可以倾听之人，就要听我所说的讲述！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","耶稣又对他们说：“要留心你们听到的，因为你们用什么标准衡量别人，上帝就会用什么标准衡量你们，完全相同。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","如果你已经理解，就会得到更多，如果无法理解，现在拥有的也会失去。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","耶稣说：“上帝的王国就像一个人在地里撒种， ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","他夜里睡觉，白天醒来，日复一日，但并不知道种子如何发芽生长。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","大地生长作物是自然而为，先长苗，后吐穗，然后穗上结满了谷粒。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","谷粒成熟后就到了收获时节，农夫用镰刀将其割下。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","我们可以将上帝的王国比做什么？可以用什么比喻来形容它呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","它好像一粒芥菜种，比所有种子都小， ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","种子在种下后开始生长，长成的样子却比其他作物都大，它的大枝叶甚至吸引天空的飞鸟在它的树荫下栖息。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","耶稣用了许多这样的比喻，按照人们能够理解的方式讲述故事。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","事实上，他在公开讲道的时候仅使用比喻。只有单独和门徒在一起时，他才会把一切解释给他们听。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","当天黄昏，耶稣对门徒说：“我们到海那边去吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","门徒们离开民众，跟着耶稣走上船，还有其他的船跟随他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","忽然海上刮起狂风，波浪不断拍打船身，船上积满了水。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","耶稣却在船尾靠着垫子睡着了。门徒把他叫醒说：“老师，我们就要淹死了，你不担心吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","耶稣醒来，命令风停止；又对海浪说：“不要出声！安静吧！”风立刻停止，水面变得完全平静。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","然后耶稣问他们：“你们为什么如此害怕？怎么对我这么没有信心？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","门徒心生敬畏，彼此问到：“他到底是谁？连风和海浪都听他的！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","他们到了海的另一边，进入格拉森人的地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","耶稣下船时，就有一个恶灵附体之人，从墓地向着他们走来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","那人住在坟墓中间，从来没有人能束缚他，即使锁链也不行。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","人们经常用脚镣和锁链锁住他，但他会挣断锁链，弄碎脚镣，始终没有人能制伏他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","他昼夜不停地在坟墓里和山野间喊叫，用尖锐的石头割自己的身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","远远看见耶稣，他就跑过去跪在耶稣面前， ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","大声呼叫：“至高上帝之子耶稣，你又能拿我怎么办呢？向上帝发誓，你不会叫我受苦。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","耶稣命令恶灵离开那男人， ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","然后问他：“你叫什么名字？” 他回答：“我是‘群魔’，因为我们的数量众多。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","他再三央求耶稣，不要把他们从那地方赶走。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","附近的山坡上有一大群猪，大约有两千头，正在吃东西。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","恶灵求耶稣说：“把我们打发到猪群身上吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","耶稣答应了他的要求。将所有恶灵引出来，送到猪群里去。于是那群猪闯下山崖，掉在海里淹死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","猪倌跑开了，到城里和乡村奔走相告，人们纷纷过来查看发生了什么事。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","他们来到耶稣跟前，看见那曾被恶灵附体之人坐在那边。这个曾被众多恶灵附体之人已经穿上了衣服，神志清醒。眼前的一幕让大家害怕！ ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","有些人曾目睹这个恶灵附体之人的遭遇，也亲眼见到那群猪的下场，于是将其告诉新来的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","他们开始要求耶稣离开他们的地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","耶稣上船的时候，那个曾被魔鬼附体之人求他，希望一路跟随。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","但耶稣拒绝了，对他说：“回自己家吧，告诉大家主为你做了一件多么伟大的事，他如何怜悯你。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","于是那人走了，开始在低加波利地区讲述耶稣为他所做的伟大善行，众人纷纷称奇。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","耶稣又坐船返回，来到湖的另一侧，一大群人围拢过来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","这时来了一位名叫睚鲁的会堂主管，看见耶稣后，马上俯伏在他脚前， ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","恳求他说：“我的小女儿快要死了，请你来将手放在她身上，把她救活吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","耶稣和他一起走了，众人跟着他，簇拥着他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","有一个女人患了十二年的血漏病， ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","曾看过很多医生，受了许多苦，花光了所有积蓄，但仍毫无起色，甚至越来越严重。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","她听见耶稣的事，就从耶稣身后的人群中走出来，抚摸耶稣的衣服。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","她对自己说：“只要摸到他的衣服，我就必痊愈。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","于是她的血漏立刻停止，感觉自己的身体已经治愈。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","这个过程中，耶稣感到有一股力量从他身体流走，于是转过身问民众：“谁摸了我的衣服？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","门徒对他说：“看看这么多人簇拥你，你问‘谁触摸我’又是什么意思？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","耶稣环顾四周，看到了刚才触摸他衣服的女人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","那女人意识到自己身上发生的事情，于是走上前匍匐在耶稣面前，告诉他实情。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","耶稣对她说：“我的女儿，你对我的信心治愈了你，平安地回去吧，你的病已经完全好了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","耶稣说话的时候，有人从会堂主管的家赶来。他们说：“你的女儿已经死了，不必再麻烦老师了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","但耶稣并未在意这番话，就对会堂主管说：“不要怕！相信我好了！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","他向主管家中走去，但不许别人跟随，只带了彼得、雅各和雅各的弟弟约翰。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","他们来到会堂主管的家，耶稣看见许多人哭泣哀号，一片混乱， ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","他走进去对众人说：“为什么大哭大嚷呢？这小女孩没有死，只是睡着了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","众人嘲笑他。耶稣让众人离开，带着孩子的父母和三名门徒，进入孩子的房间。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","耶稣拉着小女孩的手，对她说：“大利大，古米！”（意为：小女孩，起来吧！） ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","这十二岁的女孩就立刻站起来开始行走，众人惊讶万分。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","耶稣严厉地嘱咐他们，不要让其他人知道这事，又告诉他们给女孩吃点东西。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","耶稣离开那里，与门徒一起回到自己位于拿撒勒的家乡。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","到了安息日那天，他开始在会堂里传道。很多人都来聆听，纷纷称奇：“他从哪里获得的这些思想？他获得了怎样的智慧？他从哪里获得实现奇迹的力量？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","他不是木匠的儿子吗？玛利亚的儿子，雅各、约西、犹大、西门的哥哥，他的妹妹们不是也住在这里？”他们被冒犯了，于是开始拒绝耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","耶稣对他们说：“先知在任何地方都受人尊敬，但在自己的家乡、在亲朋好友面前却不行。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","这让耶稣无法在那里行使神迹，只是给几个病人按手，医好了他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","他很诧异人们如此缺乏信心。随后，耶稣到周围的乡村继续去教导那里的民众。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","他叫来十二门徒，派他们两人一组出门，同时赐给他们战胜恶灵的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","他吩咐他们除了手杖不要带任何随身物品，不要带粮食或口袋，腰袋里不要带钱， ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","只穿一双鞋，不要带其他衣服。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","他对他们说：“无论到哪里，如果有人邀请你到家中，就住在那里，直到离开那个地方。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","如果人们不欢迎你们，不听你们的，离开那地方时，跺下脚上的灰尘，作为放弃他们的信号。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","门徒们开始四处传道，劝人悔改， ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","他们驱赶了许多恶灵，用油涂抹在很多病人的身上，将他们治愈。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","当时耶稣的名声传了出去，希律王也听到了。有人说：“这是施洗约翰，他从死人中复活了，所以会有行使神迹的能力。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","又有人说：“他是以利亚。”还有人说：“他是先知，就像古时的先知一样。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","但希律听到这一切，就说：“是约翰，我砍了他的头，他又活了！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","因为希律曾亲自派人捉拿约翰，把他丢进监狱。他之所以这样做，是因为他娶了弟弟菲力的妻子希罗底， ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","但约翰对希律说：“你娶兄弟的妻子，这不合律法。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","于是希罗底怀恨在心，想要杀他，但又找不到机会， ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","因为希律惧怕约翰，知道他是秉承正道的圣人，但也会保护约翰，虽然觉得他的话很不入耳，却仍然喜欢听。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","有一天希罗底的机会来了。在希律生日的那一天，他为大臣、千夫长和加利利的重要人物摆设了筵席。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","希罗底的女儿进来跳舞，希律和在座的宾客都很高兴。于是国王对女孩说： ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“你想要什么？只管向我求，我一定给你！”他甚至还发誓：“我甚至可以将我王国的一半送给你！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","于是女孩出去问母亲：“我该求什么呢？”希罗底告诉她：“施洗约翰的头！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","她急忙跑到国王面前，对王说：“我想要你立刻把施洗约翰的头放在盘子上，送给我！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","希律王非常烦恼，但因为这是他在众宾客面前说的誓言，所以无法拒绝她。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","希律王立刻差遣一个侍卫，让他把约翰的头拿来。侍卫便到监牢里斩了约翰的头， ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","然后把头放在盘子上，拿来交给那女孩子，女孩又交给她的母亲。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","约翰的门徒听闻，便前来领走了他的遗体，葬于坟墓中。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","门徒们回来后，聚在耶稣面前，把他们所做之事和所见到的一切告诉耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","耶稣对他们说：“你们跟我来，到一个安静的地方休息一下。”因为来往的人很多，他们甚至没有时间吃饭。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","于是他们上了船，去到一个可以独处的安静地点。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","民众看见他们离开，认出了他们。于是周边城市的人们都赶过来，比耶稣他们还先赶到。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","耶稣下船后看见众人，立刻心生怜悯，因为他们就像没有牧人的羊群。于是他开始教导他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","夜深了，门徒前来对耶稣说：“这里是荒郊野外，天色已晚， ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","你可以让众人散开，到周围的田舍村庄去给自己找点东西吃。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","但是耶稣回答：“你们给他们些吃的吧。”门徒说：“什么？如果给他们所有人准备饼，需要我们用六个月的薪水才行？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","耶稣问：“你们现在有多少饼？去看看。”门徒们跑去查看一番，然后对耶稣说“还有五块饼和几条鱼。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","耶稣让众人分组坐在草地上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","于是众人坐下来，有的一百人一组，有的五十人一组。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","耶稣拿起这五个饼和两条鱼，望着天，感谢天赐食物，然后把饼掰开递给门徒，让他们把饼送给民众，然后又把两条鱼也分给民众。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","众人最终都吃饱了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","他们把剩下的食物捡起来，装满了十二个篮子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","这晚共有五千名男人吃了食物，还有他们的家人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","随后，耶稣立刻让门徒回到船上，先到湖对岸的伯赛大去，他自己会叫众人散开。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","他和众人告别后，就上山祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","那天晚上，门徒的船还在湖中航行，耶稣独自在岸上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","由于不是顺风，他可以看到门徒们费力摇橹。凌晨时分，耶稣在水面上向门徒们走去，本来可以超过他们， ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","但门徒看见他在水面上走，以为是鬼怪。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","因为他们看见了他，感到非常恐惧，于是喊叫起来。耶稣立刻对他们说：“放心吧，是我，不要怕！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","然后他上了船与门徒们在一起，立刻风平浪静。门徒心里十分惊奇， ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","他们此刻仍然感到震惊，因为他们愚钝而坚硬的内心，还不明白这次分饼神迹的含义。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","他们渡过海，在革尼撒勒靠岸。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","下船后，众人立刻认出耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","他们走到大街小巷，把患者放在垫子上，听说耶稣出现在哪里，就把患者抬到哪里。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","无论耶稣在什么地方，无论是村庄、城市或乡野，众人都会把病患放在市场中，请求耶稣允许他们摸他衣服的褶子，摸一下病患就好了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","几个法利赛人和宗教老师从耶路撒冷来，与耶稣相见。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","他们看见他的门徒中，有人用不干净的手吃饭（饭前不洗手）。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","（法利赛人和所有犹太人都拘守祖先的传统，吃东西前必须认真洗手。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","同样，从集市回家后，若不洗手就不吃东西。他们还遵循其他传统，例如洗杯、洗罐、洗铜器等等。） ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","法利赛人和宗教老师问耶稣：“你的门徒为什么不遵行祖先的传统，要用不洁的手吃饭？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","耶稣对他们说：“以赛亚关于你们这群伪君子的预言太对了：‘这些人只把尊敬挂在嘴上，心却在远离我。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","他们只把律条当作人类规则讲述，所以拜我也是徒然。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","你们小心地遵循着人间的传统，却背弃了上帝的诫命。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","耶稣又对他们说：“你们为了坚守自己的传统，以取巧的方式违背了上帝的律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","摩西说：‘当孝敬父母’，还说：‘咒骂父母必被处死’。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","但也有人会说：‘我把应该给你们的供奉，都用做各耳板 (上帝供物）了， ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","所以就不必为父母做什么’。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","你们通过这种方式遵循传统，摒弃上帝的教诲。你们做的很多事情都是如此。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","于是耶稣又把民众叫过来，对他们说：“大家听我说，也要理解， ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","真正让你污秽的，不是从外界进入你身体的东西，而是从你身体出来的东西。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","然后耶稣离开民众，走进屋子，门徒过来问他这比喻是什么意思。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","他对他们说：“你们这也不明白吗？难道你们不知道？从外界进入体内的，不会让人感到污秽。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","因为外界之物不会进入你的思想，而是进入你的内脏，最后排泄到外面。所以从仪式的角度来讲，所有食物都是‘洁净的’”。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","接着他又说：“从你身上出来的东西才使你不洁净。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","因为从人的内在和思想所传出来的，可能是恶念、淫乱、偷盗、凶杀、 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","奸淫、贪心、邪恶、诡诈、放荡、嫉妒、毁谤、骄傲、愚妄。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","这一切恶事，都源于内在，让人污秽。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","随后耶稣动身去往推罗地区，住在那里的一所房子中，本来不想让人知道，但他的行踪却隐藏不住。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","一个女人的小女儿被恶灵附体，听说耶稣的事情后，就过来俯伏在他脚前。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","这女人是希腊人，生于叙利斐尼基。他求耶稣把鬼从她女儿身上赶出去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","耶稣对她说：“应该先让孩子吃饱。把喂孩子的饼丢给狗吃可不好。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","那女人回答他：“主啊，是的。但狗可以在桌子底下吃孩子们掉下来的碎渣。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","耶稣对她说：“就凭这个回答，你回去吧，鬼已经从你女儿身上出去了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","她回到家，看见女儿在床上躺着，恶灵已经离开她的身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","耶稣离开推罗，经过西顿回到低加波利地区的加利利海。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","有人带来一个聋哑人来到他面前，求耶稣触摸他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","耶稣把他从人群中带到一边，将手指伸入他的耳朵，用自己的唾沫抹在他的舌头上， ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","然后望着天叹了一口气，对他说：“以法大！”意为：“打开吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","那人的听力和说话的能力就恢复了，可以正常说话。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","耶稣嘱咐他们不要告诉其他人，但越是嘱咐，他们就越传扬这消息。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","众人非常惊讶地说：“他的所作所为都太惊人了，竟然能让聋人听见，让哑巴说话。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","这时候又有一大群人聚集过来，他们没有东西吃。耶稣叫来门徒说： ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“我同情这群人，他们和我在一起已有三天，没有任何食物可以吃。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","如果我叫他们散开，饿着肚子回家，他们会在路上晕倒，因为有人来自很远的地方。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","门徒回答：“在这荒野之地，哪里能找食物让所有人吃饱呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","耶稣问他们：“你们有多少饼？”他们说：“七块。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","耶稣吩咐民众坐在地上，然后拿起那七块饼，向天致谢，再递给门徒，叫他们把饼分给众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","他们还有几条小鱼，耶稣进行祈福后，又吩咐道：“把这些鱼拿去分给众人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","所有人都吃饱了，然后把剩下的零碎收拾起来，装满了七个大篮子。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","当晚大约有四千人吃了食物。随后，耶稣解散了民众， ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","然后立刻和门徒上了船，来到大玛努他地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","法利赛人来到耶稣面前，与他辩论。为了试探他，让他显现来自天堂的神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","耶稣内心深深地叹息，说：“你们这些人为什么总是寻求神迹？我告诉你们实话，我不会给你们显示任何神迹！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","于是他离开他们，上船去往对岸。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","门徒忘了带饼，船上除了一个饼，身边没有别的食物。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","耶稣嘱咐他们说：“你们要小心，提防法利赛人和希律的‘酵母’！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","门徒们彼此问：“他这么说，是因为我们没有饼吧？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","耶稣知道他们在说什么，就说：“为什么还在议论没有饼这件事呢？你们还不知道，还不明白吗？你们的心还这么迟钝吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","你们有眼不能看，有耳不能听吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","你们还记得吗？我掰开那五块饼给五千人吃，你们收拾的零碎装满了几个篮子？” 他们说：“十二个。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“那七个饼分给四千人吃，你们收拾的零碎装满了几个大篮子呢？” 他们说：“七个。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","耶稣问：“还不明白吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","他们随后到了伯赛大，有人带来一个盲人，求耶稣触摸并治愈他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","耶稣拉着他的手，领他到村外，在他的眼睛上吐了口唾沫，又用双手按在他的身上，问他：“能看见了吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","那人环顾四周，说：“我看见人了！但他们好像走动的树一样。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","于是耶稣再将手按在他的眼睛上，他立刻就能看得清楚了，他被治愈了，视力恢复了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","耶稣让他回家去，说：“回家的路上，不要穿越村庄。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","耶稣和门徒离开了，向腓立比附近的该撒利亚村庄走去。路上他问门徒：“人们认为我是谁？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","门徒回答：“有人说是施洗约翰，有人说是以利亚，还有人说是先知。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","他又问他们：“那么你们认为我是谁？” 彼得回答：“你就是弥赛亚！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","耶稣警告他们，不要把他的事情告诉其他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","然后开始教导他们，人子必然会受许多苦，被长老、祭司长和宗教老师所拒绝。他们会将他杀害，但他三天后会复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","耶稣很明确地做出了解释，彼得把他拉到一边，责怪他不该这么说。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","耶稣转过身来望着他的门徒，斥责彼得说：“撒旦，离我远点！因为你未想上帝所想，只想人之所想。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","耶稣唤来民众和门徒，对他们说：“如果有人愿意跟从我，就应当舍弃自己，背起他的十字架跟随我。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","如果你顾惜自己的生命，必丢掉性命，但为我和福音牺牲生命，必拯救生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","纵使获得全世界，却赔上自己的生命，又有何用？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","人拿什么换回自己的生命呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","在这不忠的罪恶人群中，如果你因为知晓我和我的传道而为耻，那么当人子在天父的荣耀中与圣天使一起降临之时，也必将以知晓你为耻。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","耶稣又对他们说：“告诉你们实话，站在这里的有些人，在死前必定会看见上帝的天国带着力量降临人间。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","六天后，耶稣带着彼得、雅各和约翰爬上高山，然后在他们面前改变了形象。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","他的衣服闪耀着洁白的光芒，人间任何漂白的布料都比不上这样的白色。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","然后以利亚和摩西现身在他们面前，跟耶稣谈话。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","彼得对耶稣说：“拉比，我们在这里太好了！我们可以搭三个庇护所，一个为你，一个为摩西，一个为以利亚。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","（彼得其实不知道该说什么，因为他们都非常害怕！） ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","有一片云朵飘到他们头顶，云中传来一个声音：“这是吾子，我之所爱，你们要听他。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","门徒们正在张望之际，忽然就看不见别的人了，只有耶稣和他们在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","他们下山的时候，耶稣吩咐他们，人子死而复生之前，不要将所见告诉其他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","门徒把这句话记在心里，但他们彼此争论死而复生是什么意思。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","他们就问耶稣：“宗教老师为什么说以利亚必须先来呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","耶稣说：“的确，以利亚要先来做好准备，但为什么经书中又说人子要受许多苦，被人侮辱呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","但我告诉你们，以利亚已降临，他们任意地虐待他，就像经书中记载的那样。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","他们回到其他门徒那里，看见一大群人围着他们，还有宗教老师在和他们辩论。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","众人看见了耶稣都很惊奇，就跑上前去向他问候。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","他问他们：“你们和他们辩论什么？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","民众当中有一人回答他：“老师，我把我的儿子带到你这里来，他被恶灵附体，无法说话。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","无论在哪里，恶灵都会抓住他，把他摔倒，让他口吐白沫、咬牙切齿、浑身僵硬。我请你的门徒把恶灵赶出去，他们却办不到。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","耶稣回答他们：“唉！这些没有信心的人啊！我在这里必须待到什么时候？我还要忍受你们多久？把他带到我这里来吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","他们把孩子带到他跟前。那恶灵一见耶稣，就立刻让孩子倒在地上抽搐，口吐白沫打滚。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","耶稣问他父亲：“他这样多久了？” 他说：“从小就是这样。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","恶灵经常把他扔在火中想要烧死他，把他扔在水中想要淹死他。如果你能，求你可怜我们，帮助我们。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","耶稣说：“为什么你要说‘如果你能？’有信心者必有力量！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","孩子的父亲立刻喊着说：“我真的信你！但我的信心不够，求你帮助我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","耶稣见民众围拢了来，开始斥责那恶灵说：“让人聋哑的恶灵，我命令你从他身上出来，不要再回去。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","那恶灵喊叫着，让这孩子陷入剧烈的抽搐，然后就从他身体里被驱赶出来。孩子仿佛已经死了，许多人都说：“他死了！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","但耶稣拉着男孩的手，扶他起来，他就站起来了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","然后耶稣走进屋子，门徒私下问他说：“为什么我们就无法驱赶那恶灵呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","耶稣对他们说：“如果不祈祷，这种恶灵无法驱赶。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","他们离开了，途经加利利。耶稣不想让任何人知道他们的行踪， ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","因为他正在教导门徒。他对他们说：“人子将遭到背叛，送到人类的官府，他们会杀害他，但他在死后三天就会复活。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","门徒不明白这话，又不敢询问。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","他们来到迦百农的一个房间内住下。耶稣问他们：“你们在路上讨论什么呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","门徒不说话，因为他们在路上争论谁最重要。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","耶稣坐下，唤来十二门徒，对他们说：“一个人如果想为首，就必在众人中成为最后，做众人的仆人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","耶稣拉过一个小孩子来，叫他站在门徒中间，然后把孩子抱起来拥抱着他，对门徒说： ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“凡因我之名迎接这样的小孩子，就是迎接我，这样的人并非在迎接我，而是迎接那派我过来的人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","约翰对耶稣说：“老师，我们看见有人以你之名驱鬼，我们想要制止他，因为他不是我们中的一员。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","耶稣说：“不要制止他，因为没有人能在以我之名行神迹的同时又诅咒我。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","不反对我们，就是支持我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","无论是谁，若以我之名给你一杯水，他这样做只因你属于基督，就不会失掉赏赐，相信我。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","但如果有人让这些信我的小孩子犯罪，最好就是在他的脖子上拴一块大磨石，让其淹没在海里。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","如果你的一只手让你犯罪，把它砍下来。残疾却能进永生，总好过双手下哥和拿，堕入不灭的哥和拿之火。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","如果你的一只脚让你犯罪，把它砍下来。瘸腿却能获得永生，总好过两脚齐全却被丢在哥和拿。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","如果你的一只眼睛让你犯罪，把它挖出来。一只眼睛进入上帝之国，总好过两眼齐全被丢进哥和拿， ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","哥和拿里的虫不死，火永不灭。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","每个人会像被‘盐腌’一样，被火灼烧。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","盐是好东西，但如果失去了它的味道，怎样才能让它恢复咸味呢？你们需要像盐一样，彼此和睦地生活。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","耶稣离开迦百农，动身去往约旦另一侧的犹太境内。许多人又聚集到他那里，他像平常一样教导他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","有几个法利赛人前来试探耶稣，问他：“休妻是否合法？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","耶稣回答：“摩西怎么对你们说的？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","他们说：“摩西准许男人写休书即可休妻。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","耶稣说：“正是因为你们的铁石心肠，摩西才为你们写了这条律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","但在创世之初，上帝创造了男人和女人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","所以男人要离开父母，通过婚姻与妻子结合， ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","二人便成为一体。不再是两个人，而成为一个人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","上帝结合为一体，任何人都不能将之分开。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","回到房间中，门徒们再次向耶稣询问此事。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","他对他们说：“休妻另娶者，便是对其妻子犯下奸淫之罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","如果妻子弃夫另嫁，也是犯了奸淫之罪。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","有人带着自己的孩子来到耶稣面前，求他祝福他们，但门徒想要把孩子们赶走。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","耶稣见此非常不快，对门徒说：“让小孩子到我这里来，不要制止他们，因为上帝之国就属于这些孩子一样的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","告诉你们实话，如果你无法像小孩子一样接受上帝之国，就绝对无法进入。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","于是耶稣把小孩子抱起来，把手放在他们身上进行祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","耶稣继续开始旅程。一个人跑过来跪在他面前，问到：“我的良善老师，我要怎样做才能获得永生？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","耶稣问他：“你为何称我良善？除了上帝以外，无人为良善。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","你知道那条诫命吗：不可杀人，不可奸淫，不可偷盗，不可做假证供，不可欺诈，当孝敬父母......” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","他对耶稣说：“老师，我从小便遵守这些诫命。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","耶稣用充满爱的眼神看着他说：“你还缺少一样：去变卖你所有的财富，将它们分给穷人，这会让你在天国拥有财富，然后你便可来跟从我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","那人听此脸色一变，满心郁闷地离开了，因为他非常富有。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","耶稣环顾四周，对门徒说：“富有之人要进上帝之国，谈何容易！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","这番话让门徒非常惊讶。耶稣又对他们说：“我的朋友们，要进上帝之国非常困难！ ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","有钱人想要进入上帝之国，比让骆驼穿过针眼还困难！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","门徒们更为困惑，对彼此说：“那么人间还有谁可以被拯救呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","耶稣看着他们说：“从人的角度来看不可能，但对上帝却不然，对于上帝而言，一切皆可能。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","彼得对他说：“我们已经舍弃了一切跟随你......” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","耶稣说：“告诉你们实话，如果你为了我和福音舍弃房屋、兄弟、姐妹、母亲、父亲、儿女、田地，好消息是， ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","你会在适当的时候得到一百倍的家庭、兄弟姐妹、孩子和土地。但也会面临困扰，在即将到来的世界中，他们将获得永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","但先来者会排在最后，后来者排在前。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","他们继续向耶路撒冷走去，耶稣走在前面，门徒们心有疑虑，其他追随者则感到害怕。耶稣把十二门徒叫到一边，把自己即将遭遇的事情告诉他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","他说：“我们现在要去耶路撒冷，人子将被交给祭司长和宗教老师，他们将认定他有罪，把他交给异教徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","他们将迫害他，向他吐唾沫，鞭打他，杀害他，但三天后他将复活。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","西庇太的儿子雅各和约翰来到耶稣跟前，对他说：“老师，请满足我们向你请求的愿望。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","耶稣说：“想要我为你们做什么？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","他们说：“当你终获荣耀，请让我们一个坐在你的右边，一个坐在你的左边。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","耶稣说：“你们知道自己在求什么吗？我从杯中喝下的痛苦，你们能喝吗？我受的洗，你们能受吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","他们说：“能。” 耶稣说：“你们会饮我从杯中喝下的痛苦，你们会受我的洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","但我无法决定谁会坐在我的左右。这是上帝的意愿，他准备将其赐予谁，就会赐给谁。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","其他十个门徒听见了，对雅各和约翰之举感到很生气。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","耶稣把他们叫过来说：“你们知道各国都有统治国家的人压迫其人民。这些统治者的行为就像暴君。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","但这对你们而言却并非如此，谁想成为你们中的统治者，就必然变成你们的侍从， ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","谁想成为你们之首，必做众人的奴隶。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","即使是人子来，也并非为了接受他人的服侍，而是为了服侍他人，以自己的生命赎很多人之命。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","耶稣和门徒穿过耶利哥，在离开城镇的时候，身边簇拥着大批民众，其中有一个名叫巴底摩斯的盲人坐在路旁。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","听见身边路过的是拿撒勒人耶稣，他就喊叫，说：“耶稣，大卫的子孙啊，可怜我吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","许多人斥责他，叫他不要出声。他却更高声喊叫：“耶稣，大卫的子孙啊，可怜我吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","耶稣站住，说：“把他叫过来。”大家把盲人唤来，对他说：“好消息！起来吧，他叫你过去了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","巴底摩斯跳起来，丢下自己的外衣匆匆忙忙来到耶稣身边。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","耶稣问他：“你要我为你做什么？”盲人说：“老师，我想要看见。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","耶稣说：“你可以走了，你对我的信心让你痊愈了。”巴底摩斯立刻看见了，于是便一路跟随耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","一行人向耶路撒冷走去，快走到伯法其和伯大尼的时候，经过橄榄山，耶稣于是派了两个门徒先行一步。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","他对他们说：“你们到前面的村子去，走进去会看见一头小驴拴在那里，没有人骑过它，把它解开，牵过来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","如果有人问你们在干嘛，你们就说：‘主需要它，很快就会送还。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","门徒听命去了村子，发现一头小驴拴在门外的街上，于是就把它解开。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","站在那里的人问他们：“你们为什么解开它？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","门徒照着耶稣所述回答他们，那些人就让他们牵走了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","门徒把小驴牵到耶稣那里，把自己的衣服搭在驴身上，耶稣骑了上去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","许多人把衣服铺在路上，还有人从田野里砍了些树枝也铺在路上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","人群前后簇拥着他，喊道：“和撒那！祝福那奉主之名前来之人！ ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","祝福我父大卫即将降临的王国！祝福最高天堂的救世主！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","耶稣进入耶路撒冷后走进圣殿，环顾四周观察一番。天时不早了，他便和十二门徒出城，去往伯大尼。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","第二天他们离开伯大尼时，耶稣感到饥饿。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","他看到远处有一棵长满叶子的无花果树，他走过去，看看能否在树上找些果子充饥。但到了树下才发现，除了叶子什么都没有，因为现在还不到无花果生长的季节。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","耶稣对树说：“永远也不会有人再吃你的果子了！”他的门徒也听见了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","他们返回耶路撒冷，耶稣走进圣殿后，把里面的生意人赶走，推倒兑换钱币的桌子，掀翻卖鸽子小贩的凳子， ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","制止了那些拿着物品打算穿过圣殿的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","随后他向众人解释道：“经文上写着：‘我的殿应被称为祷告之殿。’你们竟把它变成贼窝了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","祭司长和宗教老师听见这番话，就想找个办法除掉耶稣。却又害怕耶稣，因为民众对他的训导很佩服。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","夜晚时分，耶稣和师徒去往城外。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","第二天清晨，在返回的路上，他们看见那棵无花果树从根处枯萎了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","彼得想起耶稣之前所说，便说：“老师，看，你咒诅的那棵无花果树已经枯萎了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","耶稣回答：“相信上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","如果我说，只要你心中没有任何疑问，相信自己所说的一定变成现实，那么任何人都能对这座山说：‘挪到海里吧’，只要他心里不怀疑，就会变成现实。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","所以我告诉你们，凡是你们祷告和祈求的事情，只要相信能够得到，就必得到。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","在祈祷时，如果有谁得罪了你们，请饶恕他，这样你们的天父也会饶恕你们的罪过。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","他们返回耶路撒冷后，耶稣走进殿内，祭司长、宗教老师和长老来到他面前， ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","问他：“你做这一切使用了什么权力？谁给你的这个权力？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","耶稣对他们说：“让我问你一个问题，你们若能回答，我就告诉你们谁给了我做这些事的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","关于约翰的施洗，它来自天上还是人间？你们回答我吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","这些人开始议论：“如果我们说从天上来，他就会说‘那你们为什么不信他？’ ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","如果我们说来自人间……”但他们害怕民众，因为众人都认为约翰就是先知。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","于是他们回答耶稣：“我们不知道。”耶稣也对他们说： “那我为什么要告诉你们，谁给我权力做这一切呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","耶稣又开始用比喻故事向他们讲述：“一个人有个葡萄园，他在四面围上篱笆，挖了一个压酒池，盖了一座瞭望台，租给几名农户后就远行去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","丰收时节，这位园主派了一名仆人到农户那里，收取园子里的一部分葡萄。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","但农户却把这个仆人抓起来打了一顿，让他空手而归。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","园主又派一个仆人过去，农户们打伤了他的头，还侮辱他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","园主再派一人，这次农户直接把他杀死。之后派去了许多仆人，有的被他们打伤，有的被他们杀掉。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","最后，园主派自己的孩子过去，心想说：‘他们总是会尊敬我的儿子吧。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","但农户们却彼此商量：‘这人会继承园主的产业，如果我们杀了他，产业就是我们的了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","他们于是抓住园主的儿子把他杀掉，扔到葡萄园外。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","那么，葡萄园主该怎么办？他会跑来杀掉这些农户，把葡萄园租给别人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","你们应该念过那段经文：‘建筑工人丢弃的石头，会成为房子的基石。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","这来自于主，在我们看来就是奇迹！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","那几名犹太领袖知道，耶稣的比喻就是针对他们，于是想要捉拿他，但因为害怕民众，只好离开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","后来，他们派了几名法利赛人和希律的支持者到耶稣那里去，想从他的话语中找出把柄陷害他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","他们过来之后说：“老师，我们知道你为人诚实，从不在乎别人的认可，因为你无畏权势地位，只依据真理讲述上帝之道。那么请问，向凯撒纳税是否正确？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","我们是该交税呢还是拒绝？” 耶稣看出他们的虚伪，就对他们说：“为何要试探我？拿个银币给我，我来看看。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","于是他们拿来一个银币。耶稣问：“这上面是谁的头像，谁的刻字？”他们回答他：“凯撒。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","耶稣说：“是凯撒的就应属于凯撒，是上帝的就应属于上帝。”这番话让那些人感到很震惊。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","撒都该人向来不相信复活一事，他们来到耶稣那里，问他： ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“老师，摩西曾写道：如果一个男人死了，留下妻子，但没有儿女，他弟弟就应当娶他的妻子，为哥哥留后。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","从前有兄弟七人，老大娶了妻子后死了，没有留下子嗣； ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","老二娶了这寡妇，没等到生下孩子也死了；第三个也是这样。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","事实上，那七个兄弟都和她结过婚，但都没等留下孩子就死了，最后那女人也死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","到了复活之时，如果他们都复活，她算是谁的妻子呢？因为七个人都娶过她。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","耶稣对他们说：“你们错了，因为你们根本不理解经文的意思，也不知道上帝的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","因为人死后复活，将不娶不嫁，而是如天国的天使一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","关于死人复活的问题，摩西讲过一个关于荆棘的故事，上帝对摩西说：‘我是亚伯拉罕的上帝，以撒的上帝，雅各的上帝。’你们没看过这个故事吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","他不是死人的上帝，而是活人的上帝。你们真是大错特错！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","一个宗教老师走过来，听他们的辩论。他意识到耶稣给出了好的回答，于是就问：“诫命中哪一条最重要？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","耶稣回答：“最重要的是：‘以色列啊，请听好！主，我们的上帝，我们唯一的主。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","你要全心、全性、全意、全力地爱主，爱你的上帝。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","第二重要的是：‘要爱人如己’。再没有哪条诫命比这两条更重要。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","那位宗教老师对耶稣说：“老师，你说的很对，上帝是唯一的，除了他以外别无他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","我们要全心、全意、全力地爱他，要爱人如己，这比各种仪式和祭物好多了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","耶稣见他回答得很睿智，便说：“你距离上帝之国不远了。”从此之后，再也没有人敢向耶稣提问。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","耶稣在圣殿内讲道。他问：“宗教老师如何讲述基督是大卫的子孙呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","由于大卫曾被圣灵感召，他便声称，主对我主说：‘你坐在我的右边，等我把你的仇敌放在你的脚下。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","由于大卫让别人称其为主，他又怎么会是大卫的子孙呢？”民众对耶稣的这番话感到非常满意。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","耶稣继续教导大家，说：“你们要提防那些宗教老师，他们喜欢穿长袍走来走去，喜欢人们在集市中向他们问安， ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","喜欢在会堂中位于高位，喜欢成为筵席上的首座。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","他们欺骗寡妇的财产，进行冗长的祷告伪装自己。这些人在审判中必受更重的刑罚。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","耶稣坐在捐款箱面前，看着人们将钱币交上来。很多富人都交上来大量的钱财， ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","然后一个穷寡妇走来，投入两枚小钱。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","耶稣把门徒叫过来，对他们说：“告诉你们实话，这个可怜的寡妇投入的资金比其他所有人加起来都多。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","因为其他人都是拿出自己一部分财富，她却把自己赖以生存的钱都交上去了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","耶稣离开圣殿的时候，有一个门徒对他说：“老师，你看这些大石头，还有这些雄伟的建筑！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","耶稣说：“你看这些雄伟的建筑，将来不会哪块石头堆砌在其他石头上，因为一切都会倒塌。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","耶稣坐在橄榄山上，面向圣殿，彼得、雅各、约翰和安得烈私下问他： ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“请告诉我们，这一切什么时候会发生？这一切将要发生时，会有什么预兆？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","耶稣告诉他们：“你们要小心，不要被人迷惑。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","许多人会跑来假冒我的名，声称‘我就是基督’，迷惑众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","如果你们听说附近和远方有战争，不要担心，这些事情必然发生，但不是最终结局。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","一个民族要攻打另一个民族，一个国家要对抗另一个国家，到处有地震和饥荒，但这就是世界诞生所经历痛苦的开始。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","你们要小心！因为人们会把你们交给公议会，你们会在会堂中被鞭打，还因为我的缘故，必须站在总督和君王面前向他们作证。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","但必须先将福音传给每个城邦。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","当你们被抓并送去审判，无需担心该说什么，到时候你们听到告诉你的话，就说出来，因为说话的不是你们，而是圣灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","兄弟会彼此背叛丧命，父亲会背叛儿子，儿女会悖逆父母，甚至置他们于死地。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","因为我的原因，你们会被众人憎恨，但只要坚持忍耐到底，一定会获得救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","当你们看见那‘污秽的偶像崇拜’站在但以理先知所说圣地（读至此处应认真思考），这时候，住在犹太的应当逃到山上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","站在屋顶的人，不要跑回屋子里取东西， ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","如果你在田里，也不要回去取衣服。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","那样的日子，对于怀孕和哺乳婴儿的女人极为可怕！ ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","要去祈祷，不要让这一切发生在冬季。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","因为那时必有大灾难，这是从世界的开始到现在未曾有过的，以后也必不会再有。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","如果上帝不想尽快结束那些日子，将无人幸免，但为了上帝所选之人，那些日子必会变短。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","那时如果有人对你们说：‘看，基督在这里！看，基督在那里！’不要信。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","因为到时必有假弥赛亚和假先知出现，可能会做出神迹和奇事，如果如此，就连天选之子都会迷惑。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","所以务必小心！我已经提前把这一切都告诉你们了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","那些灾难过后会发生这样的事情：‘太阳会暗淡，月亮不再发光， ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","众星从天空陨落，天之力量被动摇。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","届时，他们将看到人子携伟大的力量和荣光，驾云降临。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","他会派出天使，把从极地到天涯的天选之子大批召集而来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","要学习无花果树，当树枝发出嫩芽并长出叶子，你们便知道夏天已来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","同样，当你们看到这些事发生，就知道必须发生的事情已经来到，就在你的门口！ ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","告诉你们实话，这一切必将发生，然后这个世界才会过去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","天地都将走向终结，但我的教诲不会消失。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","发生这种事情时，无人再知晓日子或是时间，甚至连天使或人子都不知情，只有天父知道。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","要小心！保持清醒！你们不知道那一天何时来临。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","这就像一个人要出外远行，唤自己的仆人来，把产业交给他们，告诉每个仆人该做什么，然后离开。他还提醒看门人要保持清醒。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","所以要警醒，因为你们不知道主人何时回来，也许黄昏、也许夜半、也许是黎明、也许清晨。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","你肯定不愿意在他忽然回来时，发现你们正在睡觉。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","我对你们所说的一切，也对众人说过，‘保持警惕！’” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","逾越节和除酵节前两天，祭司长和宗教老师想方设法用诡计逮捕耶稣，然后将其杀害。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","但他们暗想：“不可在节日期间下手，免得引发民众暴动。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","耶稣这段时间在伯大尼。一天他在麻风病人西门家里吃饭时，一个女人前来，拿着一瓶非常昂贵的甘松纯香膏。她打破瓶身，把香膏倒在耶稣的头上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","那里的人中，有人很生气地说：“为什么这样浪费香膏呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","这香膏的钱值一年的薪水，应该用来接济穷人。”他们对她感到很愤怒。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","但耶稣说：“让她这么做！她对我做了一件美好的事情，为何要批判她？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","你们常与穷苦人在一起，可以随时帮助他们。但你们不常和我在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","她已尽其所能在我被安葬之前，提前用香膏涂上我的身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","告诉你们实话，无论福音传到世界何处，人们世界都会记得她的所作所为。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","这时，十二门徒中的的加略人犹大跑去见祭司长，要把耶稣出卖给他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","他们听此甚是欢喜，就答应给他好处，于是犹大就开始寻找出卖耶稣的机会。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","除酵节的第一天，也是宰杀逾越节羊羔的那一天，门徒问耶稣：“你想要我们到哪里为你预备逾越节晚餐呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","耶稣派出两名门徒，对他们说：“你们去城里，看到一个拿着水瓶之人向你们迎面走来，就跟着他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","无论他进入谁家，就询问那家的主人，我和门徒应该在哪里庆祝逾越节。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","他必带你们去楼上一个大房间处，那里已经布置整齐，预备妥当，你们在那里为我们做准备就好了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","门徒离开了，他们进了城，果真遇到了耶稣所说之事，于是预备好了逾越节的晚餐。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","到了晚上，耶稣和十二门徒过来了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","在用餐的过程中，耶稣说：“告诉你们实话，你们中间有一个人要出卖我。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","门徒们都很震惊，纷纷询问：“是我吗，是吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","耶稣对他们说：“他是十二门徒里的一人，就是与我分享食物之人中的一个。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","正如经文所预言：“人子将逝，但出卖人子之人必有灾祸！而且那人如果没有降生才好。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","他们用餐时，耶稣拿起饼，祝福后把饼分给众人，说：“拿去吃吧，这是我的身体。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","他又拿起杯子，祝福后把它递给门徒，他们都喝了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","耶稣说：“这是我的血，为众人而流，用于立约。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","告诉你们实话，从今后我不再喝葡萄酒，直到我在上帝之国品尝新酒。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","他们吟唱完圣歌后开始向橄榄山而去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","耶稣告诉他们：“你们所有人都会放弃我，因为经文上记着：‘我要攻击牧人，羊群就彻底散了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","但在我复活后，要比你们先到加利利。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","彼得对他说：“就算所有的人都弃你而去，我也不会。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","耶稣对他说：“我告诉你实话，就在今天晚上，鸡叫两遍以前，你会有三次不肯认我的情况。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","彼得坚决地说：“就算必须与你同死，我也决不会不认你！”众人也这样说。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","他们来到一个名叫客西马尼的地方；耶稣对门徒说：“你们坐在这里，我去祷告了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","他带上彼得、雅各和约翰，这时开始感到心烦意乱，非常难过。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","耶稣对他们说：“这痛苦如此煎熬，我感到快死了一样。请留在这里，保持警醒。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","耶稣稍往前了几步，伏在地上祷告，请求如果可能，那必然发生的事情就不要发生。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","他说：“上帝啊，吾父，你无所不能，那么求你让这次的痛苦远离我。但这不应是我所求的，而是你所要的。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","耶稣回来后发现门徒睡着了，就对彼得说：“西门，你睡着了吗？难道你连一个小时也不能清醒吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","保持清醒进行祷告，以免被诱惑征服。你们精神虽然有意愿，但肉体却很软弱。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","耶稣再次离开去祷告，祷告的内容相同。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","他再回来的时候，看见门徒都睡着了，因为他们实在太疲倦了，也不知道该说些什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","耶稣第三次回来，对他们说：“你们还在睡觉吗？还在休息吗？那么现在就休息够了，因为时间到了！看，人子即将遭受背叛，将其交给一群罪人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","起来吧，我们走！出卖我的人来了。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","耶稣正说话之际，十二门徒中的犹大和一群手拿刀棒之人前来，这些人都是祭司长、宗教老师和长老所派。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","这个叛徒和他们约好一个暗号：“我亲吻谁，谁就是耶稣。抓住他，让士兵把他押走。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","犹大来了，对耶稣说：“拉比！”然后亲吻耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","其他人动手抓住耶稣，把他逮捕。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","但站在耶稣身边的一个人拔出自己的刀，砍了大祭司的仆人一刀，削掉他的一只耳朵。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","耶稣对他们说：“你们带着刀棒而来，是把我当作危险的罪犯捉拿吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","我每天在圣殿中教导众人，跟你们在一起，你们却没有捉拿我。这一切就是为了应验经文所述。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","这时候，所有门徒都逃跑了，弃他而去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","（有一个年轻的追随者，披着一块麻布。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","众人捉住他时，他丢掉麻布，赤身逃跑了。） ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","他们把耶稣押到大祭司那里，所有的祭司长、长老和宗教老师都聚集在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","彼得远远跟着耶稣，走进大祭司的官邸，和差役们一起火炉旁取暖。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","屋子内，祭司长和公议会的所有人都在试图找证据控告耶稣，要把他处死，但什么都没有找到。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","虽然有许多人作假证控告他，但他们的证供相互矛盾。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","有几个人站起来，作假证控告他说： ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“我们听他说过：‘我要拆毁这由人手所建之所，三日之内另建一座并非人手所造的圣殿。’” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","但就是这样的证词，也并不能自圆其说。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","大祭司站起来，走到议会面前，问耶稣：“这些人作证控告你的是什么？你没有什么想说的吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","耶稣沉默。大祭司又问他：“你是被祝福的圣子基督吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","耶稣说：“我是。你们会看到人子站在万能上帝的右边，驾天上云彩降临。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","大祭司于是撕开自己的衣服，说：“我们还要什么证人呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","你们都听见这亵渎之语了。你们认为如何？” 他们都认为他有罪，要求将其处决。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","于是有人开始向他吐唾沫，蒙住他的脸，用拳头打他，对他说：“现在你怎么不预言了，你这个‘预言家’！”士兵把他带到一旁，开始殴打他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","这时候，彼得坐在外面的院子里，大祭司的一个婢女走过来， ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","看见彼得在烤火，那婢女径直看着他说：“你也是那拿撒勒人耶稣一伙的！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","彼得却否认说：“我不知道你在说什么，不知道你什么意思！”他于是走到前院，这时鸡叫了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","那婢女看见他在那里，就又对旁边的人说：“这个人也是他们一伙的！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","彼得再次否认。过了一会，其他人对彼得说：“你真是他们一伙的，因为你也是加利利人。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","彼得就诅咒发誓说：“我不认得你们说的这个人！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","此刻听到公鸡第二次打鸣。彼得想起耶稣对他说过的话：“鸡叫两遍以前，你会有三次不肯认我的情况。”想到这里，他痛哭起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","第二天清晨，祭司长和长老、宗教老师以及公议会全体做出决定。他们把耶稣捆绑起来，送到彼拉多处。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","彼拉多问他：“你是犹太人之王？”耶稣回答：“这是你说的。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","祭司长对耶稣提起很多控告。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","彼拉多又问他：“你看，他们对你提出这么多控告，你不想为自己辩护吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","但耶稣仍一言不发，彼拉多很惊讶。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","每年这个时候，彼拉多都会照例按着众人的要求，特赦一名囚犯。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","有一名叫做巴拉巴的罪犯，是一个反叛组织的成员，曾杀过人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","民众来到彼拉多处，请他大赦巴拉巴。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","彼拉多回答他们：“那你们想不想让我释放这犹太人之王？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","他其实知道，祭司长是因为嫉妒才把耶稣交上来。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","祭司长却煽动民众，一定要总督赦免巴拉巴而非耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","彼拉多又问他们：“那么，对于这个被称为犹太人之王的人，你们想让我怎样处置？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","众人喊到：“把他钉上十字架！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","彼拉多说：“为什么呢？他做了什么恶事呢？”众人更大声地喊叫：“把他钉上十字架！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","彼拉多只想安抚愤怒的民众，于是释放了巴拉巴，但对耶稣进行了鞭打处罚，然后将他送走，准备钉上十字架。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","士兵把耶稣带进总督府的院子里，召集整个军队的士兵都在那里集合。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","他们给耶稣穿上紫色长袍，用荆棘编成冠冕戴在他头上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","然后向他敬礼，说：“犹太人之王万岁！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","接着就用芦苇反复打他的头，朝他吐唾沫还跪下来，仿佛膜拜他一般。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","嘲笑完后，士兵把他的紫色外袍脱下，让他穿回自己的衣服，然后准备将他送上十字架。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","有一个名叫西门的古利奈人从乡下来到城里，他是亚历山大和鲁孚的父亲。原本只是经过此地，士兵却强迫他背上耶稣的十字架。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","他们把耶稣带到一个名叫各各他的地方，意为髑髅地， ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","士兵拿出没药调配的酒给他喝，但耶稣没有喝。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","他们把耶稣钉上十字架，抽签分他的衣服，看谁能分到什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","他们钉他上十字架之时，是上午九点钟。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","耶稣的罪状牌上写着“犹太人之王。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","同时钉上十字架的还有两个强盗，一个在耶稣右侧，一个在左侧。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","路人讥笑他，摇着头说：“哼，就是你说要拆毁圣殿，然后在三日内再次建造它的吧？ ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","现在把自己从十字架上救下来吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","祭司长和宗教老师也同样讥笑他，彼此说：“他救得了别人，却不能救自己， ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","如果他真是基督，是以色列的王，现在就从十字架走下来，我们看见就会信你。”甚至连其他被钉上十字架的人都在侮辱他。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","正午时分，整个地区都陷入黑暗，直到下午三点钟。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","下午三点，耶稣大声呼叫：“以利，以利，拉马撒巴各大尼。”意思为：“我的上帝，我的上帝，你为什么抛弃我？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","站在旁边的几个人听见了就说：“看，他呼叫以利亚呢。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","有一个人跑去拿海绵浸满了酸酒，绑在芦苇上，递给耶稣喝，说：“等着瞧吧，看看以利亚来不来救他。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","耶稣痛苦地大叫一声死去。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","圣殿里的垂帘从上到下裂成两半。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","看见他这样死去，站在他对面的百夫长说：“这人真是上帝之子！” ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","有一些妇女在远处观看，她们中有抹大拉的玛利亚、小雅各和约西的母亲玛利亚以及撒罗米。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","耶稣在加利利期间，这些女人就一直跟随他、服侍他。此外，还有许多和他一同去过耶路撒冷的女人。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","这天是星期五，也是安息日的前一日，夜幕降临， ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","亚利马太的约瑟来了，他是公议会的成员，他在等待着神的国度的到来。他斗胆去见彼拉多，请求带回耶稣的身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","彼拉多惊讶耶稣已死，就把百夫长叫来，问耶稣是否已死。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","从百夫长那里确认后，彼拉多就把遗体交给约瑟。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","约瑟买了细麻布，把耶稣的躯体从十字架上取下，用细麻布裹好后，葬于一个他在岩石中凿出来的坟墓内，又用一块大石头挡住墓门。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","抹大拉的玛利亚和约西的母亲玛利亚亲眼看到安放他的地方。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","安息日结束后，抹大拉的玛利亚、雅各的母亲玛利亚和撒罗米买了香膏，打算涂抹在耶稣身体上。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","在一周第一天大清早，太阳刚刚升起，她们来到坟墓处， ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","彼此商量：“怎么才能把墓门的大石头挪开？” ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","但当她们来到这里再看，却发现石头已经挪开。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","她们走进坟墓，却看见一名身穿白袍的青年坐在右侧，她们甚是惊恐。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","那青年对她们说：“别怕！你们想找钉上十字架的拿撒勒人耶稣，他已经不在这里了，因为他已经复活了。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","看，这里就是他安葬的地方。去告诉他的门徒和彼得，耶稣要先你们一步去加利利，正如他之前所说，你们在那里就会看见他。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","她们从坟墓中跑出来，身体不停打颤，感到很困惑。由于害怕，她们没有对任何人说起这件事。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","在一周第一天的清晨，耶稣复活，先向抹大拉的玛利亚显现，耶稣曾从她身上驱赶了七个恶鬼。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","她将这个消息告诉一直追随耶稣的那些人，他们正在悲伤地哭泣。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","众人听玛利亚说耶稣复活，虽然是她亲眼所见，但却并不相信。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","随后，有两名门徒离开这里向村子走去，耶稣用另一个方式向他们显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","于是他们回来告诉其他人，但其他人也不相信。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","后来，当十一名门徒吃饭时，耶稣又向他们显现，责怪他们缺乏信心又顽固不化，因为他们不相信目睹他复活之人的话。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","他又对他们说：“到世界各地去，向所有人传递福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","信我者必会进行受洗，必会获得救赎，不信者必被定罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","信我者将有神迹相伴，以我之名赶走所有鬼怪，还会以其他语言交流， ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","能徒手握蛇，如果喝下毒药，也不会受到伤害，手触病患即可使其痊愈。” ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","主耶稣向门徒说完这一切，便被接到天上，落座于上帝的右边。 ");
INSERT INTO cmnfeb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","门徒们走向世界，到处传扬福音，主与他们同在，通过神迹证实他们所传之道为上帝的讯息。");
INSERT INTO cmnfeb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","如你所知，很多人都曾试图用文字记录我们参与的成就。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","他们所记录的证据，来自最早见证和传递上帝讯息之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","由于我从始至终都参与其中，所以应该可以准确无误地撰写所发生的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","敬爱的提阿非罗们，我之所以这么做，是为了让你们确认自己所学之道完全值得信赖。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","希律担任犹太王的那段时间，亚比雅班里有一位名叫撒迦利亚的祭司，他妻子以利沙伯是亚伦的后人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","他们的一举一动都遵循上帝正道，严格遵守主所立下的一切诫命规条。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","但他们没有孩子，因为以利沙伯无法生育，而且二人都年岁已高。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","有一天，撒迦利亚按照排班的时间履行作为上帝祭司的职责， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","照惯例抽签后，他被选中进入主的圣殿上香。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","在烧香的过程，众人都在外面祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","这时天使向撒迦利亚显现，立于香坛的右侧。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","撒迦利亚见状颇感惊慌，非常害怕。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","天使说：“撒迦利亚，别害怕，上帝听到了你的祈求。你妻子以利沙伯将为你生下一子，你将为他起名为约翰。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","这孩子会为你带来欢喜和快乐，许多人都会来庆祝他的降生。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","他将成为主面前的尊者。他将拒绝喝葡萄酒或其他酒精饮料。在他出生之前就被圣灵充满。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","他将带领众多以色列人，回到主、也就是他们的上帝身边。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","他将以以利亚的圣灵和力量走在前，劝说父亲们关爱自己的儿女，规劝悖逆之人走正道，让民众准备好迎接主。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","撒迦利亚问天使：“我要如何相信这一切？我老了，我妻子也是一把年纪。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","天使回答：“我是上帝面前的加百列，奉命向你传话，告诉你这个好消息。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","但你并不相信我所说的一切，所以你会失语，直到我所言之事成真，你才能开口说话。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","众人正在外面等候撒迦利亚，见他迟迟未从圣殿出来，很是奇怪。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","但他出来时却真的失语了，无法讲话，只能打手势。于是众人意识到刚才在圣殿中出现了神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","他完成自己的职责后便回了家。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","几天后，他妻子以利沙伯果真怀孕，在家中待了五个月。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","她说：“这一切是主的旨意，他这样待我，便是要让我不再在世人面前感到羞辱。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","在怀孕的第六个月，上帝派天使加百列来到加利利的拿撒勒镇，现身在一个名叫玛利亚的少女面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","玛利亚当时已与一位名叫约瑟的男人订婚。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","天使向她问候，然后对她说“你很幸运，主与你同在。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","玛利亚对此颇感困惑，不知道这问候到底意味着什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","天使说：“玛利亚，不要怕！因为上帝已对你施以恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","你将怀孕生子，那婴儿将起名叫耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","他将成为一位伟人，被称为至高上帝之子，上帝将把向其赐予祖先大卫的王位， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","他将永远统治雅各的家园，他的王国将永续存在。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","玛利亚问天使：“但这怎能可能？我还是处女。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","天使回答：“圣灵将降临于你，至高上帝将笼罩于你。那即将诞下的婴儿生而神圣，将被称为上帝之子。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","甚至连你的亲戚以利沙伯都怀孕了，人们说那女人无法生育，现在怀胎已有六个月。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","对于上帝而言，一切皆有可能。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","玛利亚说：“我听你的，随时准备服侍上帝，愿你所言的事情发生在我身上。”于是天使便离开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","稍后，玛利亚准备了一下便急忙赶去犹太山地的一座城市， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","来到撒迦利亚的家。她走进屋向以利沙伯问安。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","听见玛利亚的问候，以利沙伯腹中的婴儿立刻开始跳动，表达着喜悦。圣灵注入了以利沙伯的体内， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","于是她高声说：“你是一位如此有福的女人，你腹中的婴儿能由你诞下，也是一种福气！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","我太荣幸了，我主之母能够造访我的寒舍。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","听到你问候的那一刻，我腹中的婴儿就欢喜跳跃。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","你真荣幸，因为你已确信，主将把对你的承诺变为现实！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","玛利亚说：“赞美主！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","上帝救世主让我如此欢喜， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","因为我作为他的仆人，尽管身世卑微，他却决定垂青于我。今后万代都会认为我是获得赐福之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","全能上帝对我做出伟大之举，他的名字如此神圣。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","他的怜悯将在尊敬他的世界中传递。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","他凭借其力量，击败了那些自作聪明之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","他能够让位高权重之人跌落王位，让谦卑之人获得升华， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","他让饥肠辘辘之人饱餐美食，也让富足之人两手空空。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","在他的帮助下，他的仆人以色列将永记他的怜悯， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","正如他向我们先父、亚伯拉罕及其后裔所做的承诺。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","玛利亚和以利沙伯同住了三个月，然后便返回自己的家。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","以利沙伯终于诞下一名男婴。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","邻居和亲戚们得知主向她施以如此善意，便和她一同庆祝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","到了第八天，他们前来为孩子行割礼，打算让他随父亲的名字叫撒迦利亚。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","但以利沙伯说：“不要，他应该叫做约翰。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","众人回答：“但你的亲戚中并没有这样的名字。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","他们通过手势询问孩子的父亲撒迦利亚，询问他的意见。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","撒迦利亚示意要写字。令众人诧异的是，他写下的是：“他就叫约翰。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","忽然他再次开口说话了，开始赞美上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","这一切让住在周围的人心生敬畏，这个消息很快就传遍整个犹太山地。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","众人听闻此事便思量它的含义：“这孩子将会成为怎样的人？”因为很显然，他对上帝而言非常特别。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","婴儿的父亲撒迦利亚体内充满了圣灵，他预言道： ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“主就是以色列的上帝，他如此伟大，因为他降临到子民之中，为其赋予自由， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","他向其仆人大卫的家族赐予伟大的救赎， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","正如他自古以来借由其神圣先知所传达的预言。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","他承诺拯救我们摆脱敌人，远离那些憎恨我们的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","他怜悯我们的祖先，记得他的圣约， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","那是他向我们的祖先亚伯拉罕所发誓言。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","他让我们摆脱恐惧，从敌人手中拯救我们， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","这让我们可以毕生遵循正道并服侍于他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","尽管你现在只是一个婴儿，但却会被称为至高上帝的先知，因你将先于主之前，为他铺好道路， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","通过宽恕其子民的罪，传播救赎的讯息。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","蒙上帝对我们的关爱怜悯，天堂的黎明将降临照耀我们， ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","照亮那些活在黑暗中、笼罩在死亡阴影中的人，引导我们走上平安之路。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","这个叫做约翰的男孩逐渐长大，精神上的变得很强大。他一直住在荒野之中，等待在以色列人中公开露面的时机。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","一天，凯撒·奥古斯都颁发命令，要对罗马帝国所有民众进行一次人口登记。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","自从居里纽斯担任叙利亚总督以来，这还是首次人口普查。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","众人回到自己的城市进行登记。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","约瑟是大卫王的后人，于是他离开加利利的拿撒勒，前往犹太的大卫之城伯利恒。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","他与订立婚约的玛利亚一同前往，此时玛利亚即将分娩。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","他们来到目的地后，玛利亚的产期也到了， ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","诞下她的长子，但因为客栈中没有空房间，他们只能用布包好婴儿，放在马槽中。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","当晚在伯利恒附近，有几名牧羊人正在看守羊群。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","主派来的天使现身于他们面前，周身环绕着主的荣光，这让他们吓得魂飞魄散！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","天使说：“不要怕！看！我为你们带来了好消息，这也会让所有人感受到真正的喜悦。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","就在今天，在这大卫之城，你们的救世主已经诞生，他就是主基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","当你们在马槽内看到一个被布包裹的婴孩，就代表你们找到他了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","这时忽然出现了很多来自天堂的生命，开始赞美上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“赞颂天堂的上帝，人间令他喜悦之人都将获得安宁！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","众天使离开他们返回天堂。牧人彼此说：“我们去伯利恒吧，看看主所说的事情，哪些已经成真。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","于是他们匆忙赶去，找到了玛利亚、约瑟和放在马槽里的婴孩。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","在亲眼目睹这一切后，他们就将天使关于这婴儿的讲述告诉其他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","对牧羊人所说的这些事，所有人都感到惊奇万分。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","玛利亚将所发生的一切牢记心中，反复思量。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","牧羊人因亲眼见到天使所言成真，于是便赞美和感谢上帝，回去继续看管他们的羊群。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","婴儿诞生后第八天，需要进行割礼，将他起名为耶稣，这也是玛利亚尚未怀胎之时，天使为其提供的名字。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","当他们按照摩西的律法净化的时间结束后，约瑟和马利亚把他带到耶路撒冷，准备把他献给主。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","就像主的律法所述：“所有长子婴儿都应先献给主。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","随后他们进行了献祭，因为上帝的律法还说：应献祭“一对斑鸠或两只雏鸽。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","在耶路撒冷有一人名叫西门，时刻遵循正道行事，非常虔诚。他期待能看到以色列的希望，希望圣灵降临于他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","圣灵曾向他显现，告诉他在有生之年必会见到主的基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","他遵循圣灵的指引来到圣殿，这时耶稣的父母抱着孩子走进来，打算按照律法献上婴儿。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","西门用双臂抱住耶稣，一边感谢上帝，一边说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“主啊，我的主人，现在可以按照你的承诺，让你的仆人离开了！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","因为我已亲眼见到 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","你为所有人准备的救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","他就是将你显现给全世界的光，是你以色列子民的荣耀。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","西门的话让耶稣的父母很震惊。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","西门向他们祝福，对耶稣的母亲玛利亚说：“这孩子必定会让很多以色列人倒下，也让很多人崛起。他就是上帝的信号，但很多人都会反对他， ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","这也揭露了他们心中的想法。对你而言，这感觉就像被刀剑刺穿。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","亚拿是耶路撒冷的一位年事已高的女先知，是亚什部落法内利的女儿，曾有过一段七年的婚姻。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","丈夫去世后，她便独自寡居，如今已八十四岁，经常会到圣殿中膜拜、禁食和祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","此刻她刚好走近他们，于是开始赞美上帝，然后向所有期待上帝拯救耶路撒冷的众人，讲述耶稣的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","耶稣的父母完成了上帝律法要求的一切，于是就返回加利利，回到位于拿撒勒的家中。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","婴儿逐渐长大，愈发强壮和睿智，因为他已获得上帝的赐福。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","每年逾越节，耶稣的父母都会去耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","在他十二岁那年，他们按着惯例再次去参加这个节日。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","节日结束后本应该回家，但年幼的耶稣仍留在耶路撒冷，他父母却没有意识到这一点， ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","以为他在返回家园的人群之中。一天后，他们开始在亲戚朋友中寻找他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","但一直没有找到，于是就回到耶路撒冷继续寻找。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","三天后，才发现他在圣殿里，身边是几位宗教老师。他一面听他们说的话，一面向他们提出问题。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","所有听过他讲话的人，都对他深刻的理解和回答而惊讶万分。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","看到眼前这一切，他父母非常不解。他母亲说：“孩子，你怎么能这样对我们？你看，我和你父亲如此担心你，到处找你！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","耶稣回答：“你们为什么找我？难道你们不知道，我应该在这里，在我父的家中？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","但他父母并不理解他这番话。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","于是他就顺从父母之意回到拿撒勒，但他母亲把这一切都记在心上。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","耶稣的智慧和力量不断增长，上帝和民众都喜欢他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","现在是提庇留国王已执政的第十五年，本丢·彼拉多担任犹太总督，希律成为加利利的君王，他的兄弟腓力担任土利亚和特拉可尼地区的君王，吕撒尼亚则是亚比利尼的君王。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","亚那和该亚法担任大祭司。撒迦利亚的儿子约翰在这段时间仍生活在荒野中，由于听到了上帝的讯息， ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","他跑遍了整个约旦地区，向所有人宣告：他们需要进行洗礼，证明他们已经悔改，他们的罪才能被宽恕。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","正如以赛亚先知所写：“在荒野中有一个声音在呼喊：‘预备主的道，修直他的路！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","所有山谷都将填满，所有山峦丘陵都将成为平地！弯曲之路变得笔直，坑洼之地恢复平坦！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","所有人都将见到上帝的救赎。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","面对前来接受施洗的民众，约翰问到：“你们是毒蛇之子，谁允许你们逃离即将到来的审判？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","你们要拿出行动，证明真心悔改。不要心中暗自产生傲慢的想法：‘我们是亚伯拉罕的后代。’告诉你们，上帝用这些石头就可以创造亚伯拉罕的后裔。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","砍下树根的斧子已经准备好，所有结不出好果子的树，都会被砍倒丢入火中。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","民众问他：“那么我们该做什么呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","他回答：“如果你有两件衣服，就要分给没有衣服之人。如果你有食物，就要分给没有食物之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","有税吏前来受洗，问他：“老师，我们该做些什么？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","他说：“不可收取超过规定的税款。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","士兵也问他：“我们呢，我们又该怎么做？”他回答：“不要恐吓，不要敲诈，不要做出不实指控，要对自己的酬劳感到满意。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","众人充满期盼地等待着，心里暗自猜测，约翰会不会就是基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","约翰回答了众人的问题。他解释道：“是的，我是用水为你们施洗。但在我之后，还会出现一位能力比我更强大之人，我甚至连给他提鞋的资格都没有，他将用圣灵和火为你们施洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","他手里拿着谷叉，准备把打谷场的麦子和谷壳分开。然后把麦子放入他的谷仓，再用不灭之火把谷壳烧尽。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","他在向众人传播福音之时，还提出了很多这样的警告。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","君王希律因为娶了弟媳希罗底，加之曾做过的其他恶行，因此受到了约翰的谴责。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","希律将这些所谓罪行累计起来，将约翰关进了监牢。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","但在此前，众人已受洗，耶稣也受了洗。耶稣在祷告的时候，天空忽然打开， ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","他看见圣灵如鸽子般降落在他身上。有声音从天上来，说：“这是我所爱之子，他让我感到喜悦。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","耶稣在 30 岁左右开始其服事，人们都知道他是约瑟之子，约瑟是希里之子， ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","他的家谱依次往上推，父辈分别为玛塔、利未、麦基、雅拿、约瑟、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","玛他提亚、亚摩斯、拿鸿、以斯利、拿该、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","玛押、玛他提亚、西美、约瑟、约大、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","约哈难、利撒、所罗巴伯、撒拉铁、尼利、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","麦基、亚底、哥桑、以摩当、珥、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","耶书、以利以谢、约令、玛塔、利未、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","西缅、犹大、约瑟、约南、以利亚敬、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","米利亚、买拿、马达他、拿单、大卫、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","耶西、俄备得、波阿斯、撒门、拿顺、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","亚米拿达、亚兰、希斯仑、法勒斯、犹大、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","雅各、以撒、亚伯拉罕、他拉、拿鹤、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","西鹿、拉吴、法勒、希伯、沙拉、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","该南、亚法撒、闪、挪亚、拉麦、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","玛土撒拉、以诺、雅列、玛勒列、该南、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","以挪士、塞特以及上帝之子亚当。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","耶稣体内充满圣灵，从约旦河返回，圣灵带领他来到荒野， ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","接受四十天的魔鬼考验。这些日子里他一直在禁食，最后感到饥肠辘辘。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","魔鬼对他说：“如果你是上帝之子，那就把这些石头变成面包吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","耶稣回答：“上帝的经卷中写道：‘人活着并不只靠食物。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","魔鬼引他上到高处，将天下万国展示在他面前， ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","对他说：“我可以给你这一切的权力和地位，因为我已获得了这些权力，可以随意送给任何人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","只要你向我鞠躬，膜拜我，你就可以拥有这一切。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","耶稣回答：“那经文中也说了：‘你只应拜吾主上帝，只能侍奉他。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","魔鬼又带他到耶路撒冷，叫他站在圣殿的最高处，对他说：“你若是上帝之子，就从这里跳下去！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","因为那经文中写道：‘上帝会派天使照顾你， ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","托住你，免得你被石头绊倒。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","耶稣回道：“那经文也写着：‘不可试探你的主上帝。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","魔鬼用尽了它所有的诱惑，便暂时离开耶稣，伺机寻找其他机会。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","耶稣回到加利利时，体内注满了圣灵力量，他的名声传遍四面八方。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","他在会堂中教导民众，深受众人赞美。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","耶稣来到自己成长的家乡拿撒勒，在安息日那天照例进入会堂。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","有人把以赛亚先知的经书递给他，他展开书卷找到一处文字，上面写着： ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“主的灵降临我身上，因为他指派我向贫苦之人传播福音，宣告那些被监禁之人将得到释放，盲人会看见，受压迫之人会得到自由， ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","我还要宣告主赐福之刻的到来。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","他把经书卷好交给身边的人，然后坐下来，会堂里的众人都注视着他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","耶稣对大家说：“这段经文如今已经应验了！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","众人纷纷表示认可，惊讶他口中所说的恩典之语。然后说：“这真是约瑟的儿子吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","耶稣回答：“我就知道你们会向我重复这句话：‘医生，先治好你自己！’然后你们会问：‘你在迦百农所行之事，为什么不在你的故乡再做一次呢？’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","但我实话告诉你们，先知在自己的家乡都不受欢迎。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","在以利亚的时代，曾出现三年半不下雨的干旱，到处都是大饥荒，以色列出现了许多寡妇， ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","但以利亚并未被派向那里的任何一个人，而是被派到西顿撒勒法一个寡妇面前！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","在以利沙的时代，以色列有许多麻风患者，但只有叙利亚的乃缦被治愈了！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","会堂中的众人听到这番话，都感到非常愤怒。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","他们跳起来将耶稣赶出城，然后把他拖到城市所在的山顶上，要把他从悬崖上扔下去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","耶稣却穿过人群，走开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","耶稣下来后来到加利利的迦百农城，在安息日教导众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","他的教导让众人感到很惊奇，因为他的话语很有权威。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","会堂里有一人被恶鬼附体，他大声喊叫： ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“拿撒勒人耶稣，我们跟你有什么关系？你是来毁灭我们的吗？我知道你是谁，你是上帝的圣人！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","耶稣打断他：“住口！”然后命令恶鬼：“从他身上出来！”恶鬼当着众人的面把那人摔倒在地上，然后从他身上脱离出来，但没有伤害他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","众人都很惊讶，彼此询问：“这是怎么回事？他用权力命令恶灵，恶灵竟然出来了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","于是耶稣的名声传遍了周围各地。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","耶稣起身离开会堂，走进西门的家。西门的岳母正在发高烧，人们求耶稣救她。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","耶稣站在她旁边，命令高烧离开她，于是她立刻退烧了，开始就起身为众人准备饭菜。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","日落时分，人们把各种疾病的患者都带到耶稣这里，他将手放在他们身上，一一治好所有病患。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","他从很多人身上驱赶出恶鬼，恶鬼叫喊：“你是上帝之子。”耶稣打断了它们，不许它们说话，因为它们知道他是基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","第二天凌晨，耶稣离开众人，找到一处安静的地方。但众人纷纷出门寻找他，找到后又挽留他，希望他不要离开。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","他告诉众人：“我必须到其他城去，传播上帝之国的福音，因为这也是我被派到这里的使命。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","然后他开始到犹太的各个会堂去传道。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","有一天，耶稣站在革尼撒勒湖边，众人簇拥着他，希望聆听上帝之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","耶稣看见两只船停在湖边，渔夫离开船去洗网了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","他走上西门的那只船，请他撑船到离岸不远的水面，然后坐下，在船上教导众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","教导结束后，他对西门说：“把船划到水更深的地方，下网打鱼吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","西门说：“老师，我们整夜劳苦工作却一无所获，不过我愿听从你，我会撒网。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","西门撒网后捞上很多鱼，几乎将网撑裂。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","于是他叫来另外那只船上的同伴来帮忙，他们捞上来的鱼把两只船装满了，甚至压得船开始下沉。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","西门（彼得）看见这番情景，就跪在耶稣面前说：“主啊，你不能靠近我，因为我是个罪人。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","因为他和身边其他人一样，完全被刚才捕捞上来的鱼数量惊住了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","西庇太的儿子雅各和约翰是西门的打鱼同伴，他们也有同样的感觉。耶稣对西门说：“不要怕！从现在起，你就要成为收获人的渔夫了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","这几名渔夫把两只船靠上岸后，便放下一切跟随耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","有一次，耶稣来到一个城中，一名严重的麻风病人看到他，就伏倒将脸贴在地上，求他说：“主啊！如果你愿意，就治愈我。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","耶稣伸手触碰他，说：“我愿意，治愈吧！”于是这个人的麻风病立刻好了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","耶稣嘱咐他：“不要告诉其他人，去给祭司看看，然后照着摩西所说的，为你的治愈进行献祭，向大家作证。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","但关于耶稣的消息却传得越来越远，大量的民众来到这里聆听耶稣教导，希望他能治愈他们的疾病。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","但耶稣却经常躲到安静的地方祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","有一天，耶稣正在教导众人之时，人群中有法利赛人和宗教老师，他们来自加利利和犹太的乡村以及耶路撒冷。因为主的力量与耶稣同在，所以他可以治愈病患。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","几个人用床抬着一个瘫痪之人，想送他到耶稣跟前。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","但因为这里的人实在太多，无法挤进房间，于是他们爬上房顶，在屋瓦中挖了一个洞，将患者和垫子通过洞放了下来，正好落在人群中耶稣的面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","耶稣看出了他们对他的信任，于是说：“你们的罪被宽恕了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","于是宗教老师和法利赛人开始议论：“这人是谁？竟然会说如此亵渎上帝之语？除了上帝，谁能宽恕罪过？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","耶稣知道他们正在讨论这个问题，于是对他们说：“你们为什么会想到这样的问题？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","说‘你的罪已被宽恕’容易，还是说‘站起来走吧’容易？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","我想要向你们证明的是，人子在人间也有宽恕罪过的权力。”然后他对瘫痪之人说：“我现在对你说，站起来，拿着你的垫子回家去吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","那人立刻在众人面前站起来，拿起刚才躺着的垫子，赞美着上帝离开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","众人对眼前的一切感到震惊，在倍感敬畏之余也纷纷开始赞美上帝。他们说：“我们今天见证了令人惊讶的事情。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","稍后，耶稣离开了这个城镇，看见一位名叫利未的税吏坐在交税亭处，于是对他说：“跟随我吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","于是 利未站起来放下一切，决定跟随耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","利未在自己家中大摆宴席，客人中除了很多税吏，还有其他一些人。但法利赛人和宗教老师开始抱怨耶稣的门徒，说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","“你们为什么要跟税吏和那些罪人一起吃喝呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","耶稣回答：“健康之人不需要医生，病患才需要。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","我来这里并非感召正道之人，而是要召唤罪人。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","他们对耶稣说：“约翰的门徒经常禁食和祈祷，法利赛人的门徒也是，但你的门徒却大吃大喝。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","耶稣又问：“男傧相和新郎在一起时，怎么可以让男傧相禁食呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","时间一到，新郎要离开大家了，那一刻他们就要禁食了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","耶稣又讲了一个比喻：“没有人会从新衣服上撕下一块布，补在旧衣服上。如果这样，不但新衣服撕破了，新撕下来的布与旧衣服也不协调。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","没有人会把新酒装在旧皮袋中，否则新酒就会把皮袋胀破，不但酒漏掉了，皮袋也损坏了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","人们总是把新酒放在新皮袋里。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","人们喝了陈酿的酒，就不想喝新酒了，他们会说：‘陈酿的口味就是好。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","在一个安息日，耶稣和门徒经过一片麦田，他的门徒摘下麦穗，用手搓着吃下。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","有几个法利赛人质问耶稣：“你们怎么能这样呢？安息日不允许这样做。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","耶稣答道：“大卫和随从在饥饿时所做的事情，你没有读过吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","他难道不是走进上帝的圣殿，吃了圣饼，还把它分给他的随从？这饼只有祭司才能吃。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","他又对他们说：“人子是安息日的主。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","在另外一个安息日，耶稣走进会堂布道，那里有个人右手有残疾。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","宗教老师和法利赛人想看看耶稣会不会在安息日治病，希望找到借口控告他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","耶稣知道他们的想法，就对手残疾的人说：“起来吧，站在大家的面前！”那人就起身站在那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","然后耶稣转身对他们说：“问你们一个问题：在安息日做什么才对？是拯救生命，还是害人性命？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","他环视周围众人，然后对那个男人说：“伸出你的手来！”那人把手一伸，手就复原了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","但宗教老师和法利赛人却勃然大怒，商量着怎样对付耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","不久之后的一天，耶稣到山上去祷告，他整晚待在那里，向上帝祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","天亮之后，他把跟随他的人叫来，从中挑选了十二人，称他们为十二门徒，他们分别是： ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","西门（耶稣又称他为彼得）和他弟弟安得烈，以及雅各、约翰、腓力、巴多罗迈、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","马太、多马、亚勒腓的儿子雅各、激进派西门、 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","雅各的儿子犹大和出卖主的加略人犹大。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","耶稣和十二门徒下了山，站在一处平坦的地方，一大群信众和他的门徒都聚在这里，还有很多人从犹太全地、耶路撒冷和推罗以及西顿海边赶来，听耶稣讲道，也希望耶稣把他们的疾病医好。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","那些被恶灵附体之人也痊愈了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","每个人都想方设法触摸他，因为他身上传递出一股力量，可以治愈众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","耶稣看着门徒，对他们说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“你们贫穷之人有福了，因为上帝之国是你们的。你们饥饿之人有福了，因为你们会吃饱。你们哀哭之人有福了，因为你们将开怀大笑。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","如果因为我是人子的缘故，你们被憎恨、排斥、羞辱和诅咒，你们就有福了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","当那一天到来，欢喜吧，快乐地跳跃吧，因为你们在天堂获得了慷慨的赏赐，别忘了，他们的祖先就是这样对待先知的。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","但你们富有之人有祸了，因为你们已经得了奖励。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","你们饱足之人有祸了，因为你们将面临饥饿。你们正在欢笑的人有祸了，因为你们将要痛哭哀嚎。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","你们受众人夸赞之人有祸了，别忘了，你们的祖先也是这样夸赞假先知。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","但我想告诉那些聆听之人：要爱你们的敌人，善待憎恨你们的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","如果有人咒诅你，要为他们祝福；如果有人凌辱你，要为他们祷告； ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","有人打你一边的脸，转过另一边脸给他打；有人如果拿你的外衣，连里面的衣服也送给他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","别人想要你的东西，就给他；有人拿去你的东西，不必再要回来。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","想要其他人如何对待你们，你们就应当如何对待其他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","如果只爱那些爱你的人，你这样做又有什么不同呢？罪人也爱那些爱他们的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","如果只善待那些善待你的人，你这样做又有什么不同呢？罪人也会这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","如果你借人钱财，又指望别人偿还，你这样做又有什么不同呢？罪人借钱给其他罪人，也会要求如数归还。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","不能这样：要爱你们的敌人，善待他们。借出去的东西不要指望偿还，这样你们才能获得巨大恩赐。你们会成为至高上帝的儿子，因为上帝也会善待不懂得感恩之人和恶人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","你们要仁慈，就像你们天父一样仁慈。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","不可评判他人, 否则你也会被他人评判；不可决定他人的罪，否则你也会被定罪；饶恕他人，就会被人饶恕； ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","要给予，才会有慷慨回报，而且是加倍的回报。在衡量应该给你多少时，会将其压实，以便可以添加更多，能从顶部溢出，倒在你的腿上！因为你付出多少将决定你得到多少。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","耶稣又讲了一个比喻：“盲人怎能给盲人领路呢？两个人不都会掉在坑里吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","信徒的知识怎能多于老师？只有他们学会了所有知识，才能和老师一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","为什么你看得见兄弟眼中的灰尘，却看不到自己眼中的木头？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","你看不见自己眼中的木头，怎能对你的兄弟说：‘兄弟，让我来把你眼中的灰尘取走’？这是伪君子的行为！要先拿走自己眼中的木头，才能看得清楚，才能取走兄弟眼中的灰尘。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","因为好树不能结坏果，坏树不能结好果。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","你可以根据果子识别树木，不能从荆棘上采无花果，也不能从蒺藜中摘葡萄。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","良善之人因为心存善念而做善事，邪恶之人因为心存恶念而做坏事。因为心中所念，口中必言。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","为什么你们称我‘主啊！主啊！’却不遵行我的吩咐？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","让我举个例子：有一个人来到我面前，他听了我的指引并照做。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","这人就像在建造房屋，深挖地基，把地基建在牢固的岩石上。大水泛滥时，湍流冲刷房屋也不能让它倒塌，因为它建造得很牢固。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","但听到我的教导却不遵守，就好比在沙子上建屋，没有根基，急流一冲就会倒塌，彻底毁坏。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","耶稣向民众讲完这一切，就开始向迦百农走去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","那里的一位百夫长有一名十分器重的仆人，但这仆人快要死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","百夫长听见耶稣的事，就派来几位犹太人长老过来，求他去医治他的奴仆。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","长老们就来见耶稣，恳求他说：“请过来为他做这件事吧，因为他值得你的帮助。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","因为他爱我们的人民，给我们建造会堂。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","耶稣就和他们一同前去。在距离百夫长住宅不远的地方，百夫长派几个朋友来说：“主啊，有劳你大驾光临，实在不敢当， ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","我觉得自己实在没有资格去见你，但只要你说一句话，我的仆人就能治愈了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","我既听命于自己的长官，手下也有士兵。如果我对士兵说‘去吧！’他就会去；对另一个人说‘来吧！’他就会来；我对仆人说‘做这个吧！’他就会做。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","耶稣听见这些话，很是惊讶，转身对跟随的众人说：“告诉你们，我在以色列从未见过如此坚定的信心。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","百夫长的朋友回到家里，发现那奴仆已经痊愈了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","很快，耶稣开始向拿因城走去，身边跟着他的门徒和一大群民众。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","他走近城门的时候，看到另一条路上有个送葬的队伍，那是一家的独子，母亲是个寡妇。城里有一大群人陪着她。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","主看见她便心生怜悯，对她说：“不要哭！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","然后耶稣上前按着棺材，抬棺人站住。 耶稣说：“年轻人，我要对你说，起来吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","那死去之人就坐起来，开口说话，耶稣把他交给他母亲。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","众人都感到敬畏万分，纷纷颂赞上帝：“我们中间出现了伟大的先知！”又说：“上帝眷顾他的子民了！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","关于耶稣的消息传遍了犹太和周围各地。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","约翰的门徒把这一切都告诉约翰，约翰叫来他的两名门徒， ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","派他们去主那里，说：“你就是我们一直期待的人？还是我们需要继续等待其他人？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","两人来到耶稣跟前，说：“施洗约翰派我们来问你，‘你就是我们一直期待的人？还是我们需要继续等待其他人？’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","耶稣这时正在治愈众多患病、遭难、恶鬼附体之人，让盲人可以看到。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","耶稣回答约翰的门徒：“你们回去把所见所闻都告诉约翰。盲人可以看见，跛人可以走路，麻风患者被治愈，聋人可以听见，死人复活，穷人听到了福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","那些不会因我而感到冒犯的人，有福了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","约翰派来的人走了以后，耶稣开始对众人说：“关于约翰，你们到荒野去寻找他时，希望看到什么？风吹动的芦苇吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","身穿华服之人吗？不，那些衣着华丽、生活奢侈的人都生活在宫殿中。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","你们是在寻找先知吗？是的，约翰是先知。但我要说的是，他比先知重要得多了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","经文中记着：‘看啊，我派遣使者先你一步，预备你的道路’，说的就是他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","我告诉你们，女人所诞下的人类中，没有谁比约翰更伟大，但他在上帝之国中却是最不重要的那一个！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","经过约翰施洗的众人，甚至包括税吏，听到此言便纷纷决定追随上帝的善意正道。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","但法利赛人和研究法律的专家未受过约翰的洗礼，便拒绝上帝对他们的美意。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","耶稣又说：“这个世界的人可以比作什么呢？他们像什么呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","他们就像小孩子坐在巿中心，对彼此说：‘我们给你们吹笛子，你们却不跳舞，我们唱哀歌，你们也不痛哭。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","施洗约翰来了，不吃饭，不喝酒，你们就说他是恶魔附体。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","现在人子来了，看他吃喝你们又说：‘你看，这人又贪吃，又贪杯，还与税吏和罪人为伍。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","但上帝的智慧之道，已被他的所有追随者所证实！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","有一个法利赛人请耶稣同他一起用餐，于是他就到那位法利赛人家中赴宴。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","城里有一个女人，是个罪人。得知他在法利赛人家里吃饭，就拿着一瓶香膏来到这里。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","她跪在耶稣身边，眼泪沾湿了他的脚。于是她用自己的头发把泪水擦干，然后亲吻他的脚，抹上香膏。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","请耶稣吃饭的法利赛人看见她，心想：“这人若真的是先知，必定知道是谁在触摸他。这是怎样的女人，她是个罪人！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","于是耶稣开口说：“西门，我有话要对你说。”他说：“老师，请讲。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","耶稣说：“有两个人欠了一个债主的钱，一人欠 500 银币，一人欠 50 银币。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","他们都无力偿还，于是债主就免了两人的债务。这两个人哪一个人会更爱他？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","西门回答：“我想是那个欠债多的人会更爱他。”耶稣说：“你说对了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","于是他转身向着那女人，对西门说：“你看到这女人吗？我走进你家，你没有给我水洗脚，但她却用眼泪湿了我的脚，用头发擦干。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","你没有亲吻我，但这女人自我进来，就一直在亲吻我的脚。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","你没有在我的头上涂抹香膏，但这女人却用香膏抹我的脚。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","所以我告诉你，因为她的很多罪都被赦免了，所以她心中的爱多。如果被赦免的少，心中爱的也少。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","然后耶稣对女人说：“你的罪被赦免了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","一同进餐之人心里说：“这是谁啊？竟然可以宽恕罪过？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","耶稣对那女人说：“你的信任已经拯救了你，安心地去吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","不久之后，耶稣周游各城各村讲道，宣扬上帝之国的福音，十二门徒与他同行。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","同行的还有几名女人，都曾受耶稣驱赶恶鬼和治愈疾病。抹大拉的玛利亚就是其中之一，耶稣从她身上驱赶了七个恶鬼。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","还有约亚拿，她是希律的管家古撒的妻子。此外还有苏珊娜和其他女性，她们都在用自己的财物供养耶稣和门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","当时有许多人聚在一起，还有人从其他城市来到耶稣这里，于是耶稣就讲了一个比喻故事： ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“有一个农夫出去撒种，这个过程中，有的种子落在路旁，被人踩踏或被空中的飞鸟吃掉。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","有的种子落在石头地上，刚长出来就枯萎了，因为得不着滋润。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","有的落在荆棘丛中，荆棘生长的过程中，让种子无法长大。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","有的落在肥沃土壤里，于是就蓬勃生长，结出百倍的果实。”耶稣说完这番话，便大声说：“如果你有耳朵，就好好听着！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","但门徒还是问他：“这比喻是什么意思？。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","他说：“上帝之国的奥秘，只给你们知道。对其他人只能用比喻，‘让他们看，他们却看不见，让他们听，他们却听不懂。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","这比喻的含义是：种子是上帝之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","落在路旁的种子，意思是人们听到正道后，魔鬼随即来到，将真理从他们思想中夺走，因为魔鬼害怕他们因信任上帝而获得救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","落在石头地中的种子，意思是人们听到正道后高兴地接受，但是这道并未在思想中扎根，他们只是暂时相信，遭遇困难的时候就会放弃。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","落在荆棘中的种子，意思是人们听到了正道，但他们却被今世的忧虑、财富和欢喜所占据，无法产生任何结果。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","落在肥沃土壤里的种子，意思是那些为人诚实、行为正确的人，他们听到了真理的正道，然后始终坚守，熬过困难，直到结出果实。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","你点灯的时候不会用器皿将其盖上，也不会将灯放在床下，而是要放在灯台上，让进来的人都看得见光。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","因为隐藏之事最终会显现，遮蔽之事最终会暴露，为众人所知。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","所以应留心怎样‘听’。如果你已经被给予，就会被给予更多。如果你从未被给予，就连你自以为拥有的，也会被夺走！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","耶稣的母亲和弟弟来到他那里，因为人多，所以无法上前。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","有人转告耶稣：“你母亲和弟弟站在外面要见你。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","他回答：“听从上帝之道并遵守之人，才是我的母亲，我的兄弟。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","有一天，耶稣对他的门徒们说：“我们坐船到湖那边去吧。”于是他们就上船出发了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","在船航行的过程中，耶稣睡着了。湖上忽然刮起风暴，船体灌进大量的水，很可能会沉没。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","门徒叫醒耶稣，说：“主人！主人啊！我们要沉没了！”耶稣醒过来，命令风浪退去，于是风浪就停止了，一切归于平静。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","耶稣对他们说：“你们的信心到哪里去了？”他们又惧怕、又惊奇，对彼此说：“这到底是谁？他可以命令风浪，连风浪都听他的！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","一行人航行来到了加利利对面，这里是格拉森人的地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","耶稣一上岸，迎面就看到城里一个被恶鬼附体之人。很久以来，这个人都没有穿衣服，也没有住在自己的家中，只能栖身坟墓。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","他一见耶稣，就俯伏在耶稣脚边，大声说：“至高上帝之子耶稣，你想要我怎样呢？不要折磨我，求你！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","因为耶稣曾对这人驱赶过恶灵，但这恶灵总是附在他身上，人们不得不把他用铁链和脚炼捆住，再派人看管。但他总是能挣断锁链，在魔鬼的驱使下进入荒野。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","耶稣问他：“你叫什么名字？”他说：“众鬼。”因为有很多恶鬼附体在他的身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","众鬼求耶稣，不要赶它们进入无底深渊。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","附近山坡上有一大群猪正在吃东西。恶鬼们求耶稣准它们进入猪群。耶稣准许了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","恶鬼们就从那人身上出来，进入猪群，猪群闯下山崖，掉在海里淹死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","猪倌看见所发生的事就跑开了，到城市和乡村中讲述这件事。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","众人纷纷过来查看发生了什么事。来到耶稣那里，看见恶鬼已经被驱赶。那人已经身穿衣服，神志清醒，坐在耶稣脚前，众人感到害怕。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","当时目睹这一幕的众人，把鬼附体之人如何得到治愈的经过说给大家听。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","于是格拉森地区的人要求耶稣离开他们，因为他们感到特别恐惧。于是耶稣便上船返回。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","被驱魔的那人想要追随耶稣，于是就求耶稣。但耶稣让他回去，说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“你回家去吧，告诉众人上帝为你做了什么。”于是那人走遍全城，讲述耶稣为他所做的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","耶稣回来的时候，众人欢迎他，因为大家都在热切地等着他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","有一个名叫睚鲁的会堂主管，他俯伏在耶稣脚前，求耶稣去他家， ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","因为他大约 12 岁的独生女快要死了。在耶稣去往那人家中的路上，身边一直围绕着众多民众。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","人群中有一个女人患有十二年的血漏病，治病花光了她所有积蓄，却始终没能医好。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","她从人群后面挤上前来，摸着耶稣的斗篷，血立刻止住了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","耶稣问：“谁在触摸我？”众人都说不是自己。 彼得说：“主啊，众人都簇拥在你身边，他们推推搡搡会碰到你。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","耶稣回答：“一定是有人触摸我，我知道，因为一股力量从我身体流出去了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","那女人见不能隐瞒，就战战兢兢地走上前，俯伏在他面前，当着众人的面讲述触摸他的原因，以及如何立刻痊愈。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","耶稣对她说：“女儿，你的信任已经拯救了你，安心地去吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","耶稣说话的过程中，有人从会堂主管家里过来，说：“你的女儿死了，不必再劳烦老师了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","耶稣听见这句话，就对主管说：“不要怕，只要你有信心，她必会痊愈。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","到了主管的房子后，除了彼得、约翰、雅各和女孩的父母以外，他不准任何人与他走进屋子。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","众人都在为女孩痛哭哀号。 他说：“不要哭，她没有死，只是睡着了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","众人知道女孩已经死了，于是就嘲笑他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","他走进去拉着女孩的手，大声对她说：“孩子，起来！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","于是她就死而复生，立刻站起来。耶稣吩咐众人给她东西吃。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","她父母非常震惊。耶稣嘱咐他们不要把这件事告诉其他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","耶稣召齐十二门徒，赋予他们力量和权力，去制伏一切妖魔，医治各样的疾病。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","然后派遣他们去宣讲上帝之国和医治病人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","他对他们说：“你们路上什么都不用带，手杖、袋子、食物、银钱或是衣服都不需要。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","无论走进谁家，就住下，直到需要离开为止。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","如果那家人不接待你，在离开那座城的时候，就把脚上的灰尘跺下，以此警示他们。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","于是门徒们就出发走遍各乡，传讲福音，到处医治病人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","君王希律听到这一切，感到非常困惑，因为有人说：“约翰起死复生了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","又有人说：“以利亚显现了。”还有人说：“古时的一位先知复活了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","希律说：“毫无疑问我已经将约翰斩头，但他又是谁，我怎么会听到关于他的这些事呢？”于是他就设法要见耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","门徒们回来后把所做之事报告耶稣，于是他带着他们离开，去一个叫做伯赛大城的地方。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","民众知道后也跟了去。他接待他们，向他们讲述上帝之国，医好需要救治之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","天色将晚，十二门徒来到他跟前，说：“你让众人散了吧，让他们到附近的村庄和农场去，找地方住，找东西吃，因为这里是一片荒野。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","但耶稣说：“你们可以给他们吃的东西！”他们说：“我们只有五个饼和两条鱼，除非你想让我们去为所有人买食物。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","这里大概有五千名男人。他对门徒说：“让他们分组坐下，每组大概五十人。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","门徒就照他的话叫众人坐下。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","耶稣拿起这五个饼和两条鱼，望着天，为食物祝福。然后掰开饼，持续不断地递给门徒，与众人分享。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","所有人都吃饱了，把剩下的食物收拾起来，装满了十二个篮子。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","还有一次耶稣独自祈祷的时候，只有门徒和他在一起。他问他们：“所有这些民众是怎么看我的？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","他们回答：“有人说是你是施洗的约翰，有人说你是以利亚，还有人说你是古时的一位先知复活。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","他又问他们：“你们怎么看我？” 彼得回答：“你是上帝的基督。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","耶稣严厉地嘱咐他们，不要把这事告诉其他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","他说：“人子必须遭受许多苦难，被长老、祭司长和宗教老师拒绝，然后被杀害，但会在第三日复活。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","耶稣又对众人说：“如果有人愿意跟从我，就必须舍弃自己，天天背着自己的十字架跟从于我。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","如果你想拯救自己的生命，就必会丢掉生命。但如果你为我牺牲生命，必拯救生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","即使赢得全世界，但你最终却迷失或毁灭，又有什么好处呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","如果你因为我和我所授之道而感到耻辱，当人子带着荣耀以及天父和天使的荣耀降临时，也必把你视为耻辱。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","告诉你们真相，这里的人群中，有人在死亡之前就能看到上帝之国。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","在他说出这番话约八天后，耶稣带着彼得、约翰和雅各上山去祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","在祷告的过程中，他的面貌忽然改变，衣服散发着洁白的光芒。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","摩西和以利亚显现在荣光之中，开始与耶稣交流， ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","谈论他去世的事，这也是他在耶路撒冷需要完成的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","彼得和同伴都在打盹。醒过来之后，就看见他的荣光，也认出了与耶稣站在一起的那两个人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","那二人正要离开他的时候，彼得对耶稣说：“主啊，能来到这里太好了！我们可以搭三个庇护所，一个为你，一个为摩西，一个为以利亚。”但他其实并不知道自己在说什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","就在他说话的时候，有一片云笼罩在他们上方，这让门徒们很害怕。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","云里飘出来一个声音，说：“这是我的天选之子，你们要听从他！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","声音消失后，众人只看到耶稣自己。关于这一刻所见之事，门徒们没有说出去，没有告诉任何人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","他们下山后的第二天，有一大群人等在那里迎接耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","人群中有一个人喊着：“老师，求你看看我儿子吧，他是我的独子。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","一个恶灵附上了他的身体，他会忽然喊叫，身体抽搐，口吐白沫。恶灵会折磨糟践他，不肯放过他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","我求过你的门徒把他赶出去，他们却办不到。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","耶稣说：“唉！这没有信仰的腐朽世界啊！我还要和你们在一起多久，忍受你们到几时？把你儿子带到这里来吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","那孩子走过来的时候，恶鬼把他摔倒，让他不停抽搐。耶稣斥责那恶灵，然后把孩子医好，交给他父亲。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","众人都惊奇上帝的力量。就在大家还在惊讶耶稣所做的一切时，耶稣对门徒说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“仔细听好我将要说的话：人子将遭受人的背叛。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","门徒不明白，因为这话的真实意思被隐藏起来了，他们无法理解其隐喻之意，也不敢多问。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","后来，门徒之间开始争论谁最伟大。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","耶稣知道他们在争论什么，就找了一个小孩子过来，叫他站在自己旁边， ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","他对门徒们说：“凡以我之名接待这孩子，就是接待我，凡接待我者，就是接待派我来到这里的上帝。你们中间谁的年龄最小，谁就最伟大。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","约翰说：“主啊，我们看见有一个人以你的名驱鬼，我们就制止他，因为他不是我们中的一员。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","耶稣说：“不要制止他，因为没有人能以我之名行神迹，同时又诅咒我。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","耶稣升入天堂的日子即将来临，他决意去耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","他派信使先走一步，造访撒玛利亚的一个村庄，为他做准备。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","但那里的人不欢迎他，因为他决定去耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","他的门徒雅各和约翰看见了，就说：“主啊，你要我们呼唤从天而降的火烧死他们吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","但耶稣转过身斥责他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","然后一行人就开始去其他的村庄。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","在路上，有一个人对耶稣说：“你无论去哪里，我都要跟随你！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","耶稣对那人说：“狐狸有洞，飞鸟有窝，人子却没有栖身之地。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","他对另一个人说：“跟随我吧！”那人说：“主啊，先让我先回去安葬我的父亲吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","耶稣说：“让死人去埋葬他们的死人吧，你应该去传扬上帝之国。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","又有一个人说：“主啊，我要跟随你，但容我先回去与家人道别。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","耶稣说：“如果你已经开始耕犁，就不要向后看，否则就不适合进入上帝之国。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","这之后，主又另外指派了七十名门徒，派他们两人一组先行一步，去往他计划造访的所有城邦。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","耶稣对他们说：“需要收割的庄稼很多，但工人太少，这时候就要向收获之主祈祷，让他派工人去他的农田收割庄稼。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","所以去吧，我派你们出去，就像羊羔走进狼群。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","不要带钱袋、口袋和鞋，遇见其他人也不要闲聊。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","无论走进哪一栋房子，先说：‘愿平安降临这里！’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","那里若有平安之人，你们的平安就会降临于他们，否则，这平安仍为你们所有。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","你们要住在那人的家中，他们给你吃喝，因为工人就应该获得报酬，不必在各家之间搬来搬去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","无论你走进哪座城中，那里的人若欢迎你们，他们送上什么食物就吃什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","然后医治城中的病人，告诉他们：‘上帝之国已经降临。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","但无论你们进入哪座城，那里的人若不接待你们，就穿街过巷地告诉他们： ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘我们会把这城里沾在我们脚上的尘土拂去，以此表达对你们的失望。但你们应该意识到：上帝之国已经降临。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","我告诉你们，到了审判日那天，索多玛甚至都要比这座城更好。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","哥拉逊啊，你有祸了！伯赛大啊，你有祸了！因为在你们那里显现的神迹，如果换做是在推罗和西顿，城里的人早就披上粗布衣，坐在地上悔改了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","所以到了审判日那天，你们所受的苦，要比推罗和西顿还重。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","还有你，迦百农！你不会被高举到天堂，而是会坠入阴府。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","听从你们的人就是听从于我，拒绝你们的人就是拒绝我。但拒绝我，就是拒绝那派我来此之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","那七十名门徒回来的时候兴奋地说：“主啊，因你之名，即使是魔鬼也听从我们！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","耶稣说：“我看见撒旦像闪电一样从天空坠落。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","是的，我给了你们力量去毁灭蛇和蝎子，去战胜所有实力强大的仇敌。没有什么能伤害你们了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","但不要因鬼怪听从你们就欢喜。你们欢喜，应该是因为你们的名字被记录在天堂。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","就在这时，耶稣心中充满圣灵的喜悦。他说：“父啊，天地之主，我感谢你，因为你在智慧和聪明人面前隐藏起这一切，却将其显现给孩童。父啊，是的，这样做会让你感到欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","我父已经把一切交给我，除了我父没有人能理解人子。除了人子以及人子愿意向其显示之人，没有人能理解我父。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","当周围没有其他人时，耶稣转过身来对门徒说：“那些能见你们所见之人，真的是有福了！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","我告诉你们，曾有许多先知和君王，想看到你们所见的一切，却无法看到，想听你们所听的一切，却无法听到。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","曾有一个研究法律的专家站起来，试图用问题为难耶稣。他说：“老师，我要怎么做才可以获得永生呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","耶稣问他：“律法上是怎么写的？你看到了什么？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","那人回答：“你要全心、全性、全力、全意爱你的主上帝，要爱邻居如爱自己。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","耶稣说：“你说对了。这样做就会获得永生。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","但那人还想为自己的想法辩护，就问耶稣：“那么谁是我的邻居呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","耶稣回答：“一个人从耶路撒冷去往耶利哥，途中遇到强盗，他们剥去他的衣服，殴打他，然后把他丢在那里，让他等死。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","正好有一名祭司走过那条路，但看见他后，却绕道走开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","有一个利未人也路过，但走到这里看到这个男人，也绕道走开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","最后一个撒玛利亚人走来路过此地，看见这个男人，心生怜悯。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","于是走上前，用油和酒处理他的伤口，将他包扎好，扶上自己的驴子，带他住进一个客店，照顾他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","第二天，这个撒玛利亚人拿出两个银币交给店主，说：‘请你照顾他，如果有额外的花销，等我回来的时候会还给你。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","那么你认为，对于这个被强盗抢劫的人而言，这三个人中谁是他的邻居呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","研究法律的专家说：“就是那个表达善意的人。” 耶稣说：“那就去做同样的事情吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","耶稣和众人继续赶路，走进一个村庄。有一个名叫马大的女人，请耶稣到自己家里。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","她有一个妹妹名叫玛利亚，坐在主的面前听道。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","马大当时忙着准备饭菜，有很多需要做的事情，感到有些不快。于是就上前来说：“主人，我妹妹让我一个人做这些事情，请让她来帮帮我。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","主回答她：“马大啊，马大，你为所有这些事操心忙碌， ");
INSERT INTO cmnfeb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","但只有一件事是必做的，玛利亚选择了正确之事，这不能从她那里剥夺。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","有一天，耶稣在一个地方祈祷。祈祷结束后，有一个门徒问他说：“主啊，请教我们如何祈祷，就像约翰教导他的门徒一样。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","耶稣说：“你们祷告的时候，要说：‘父啊，愿你的名被尊为神圣，愿你的国降临， ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","请赐予我们每天需要的食物， ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","赦免我们的罪过，因为我们也宽恕了所有对我们犯下罪行之人，请保护我们不要被魔鬼试探。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","耶稣继续对他们说：“假设你半夜去找一个朋友，对他说‘请借给我三个饼， ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","因为我有一个朋友远行到此，我没有什么食物可以招待他。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","但屋子里的朋友却回应说‘别打扰我了，我已经关好了门，和孩子都躺下了，不能起床给你拿食物。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","我告诉你们吧，尽管他不愿起床给你拿食物，只要你不断坚持，即使你不是他的朋友，他最终也会起来，把你要的东西拿给你。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","告诉你们吧，你要去求，自会获得；要去找，自会找到；要去叩门，门自会开。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","因为只要祈求都可以获得，只要寻觅都可找到，只要叩门就会将门打开。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","如果你为人父，当你儿子想要鱼，你不可能给他蛇。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","如果儿子想要鸡蛋，你不可能给他蝎子。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","所以，即使你是邪恶的，如果你仍然知道给你的孩子好礼物，天父何况将圣灵赐给那些求他的人呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","耶稣从一个人身上驱走恶鬼。这个人之前还是个哑巴，但现在可以说话了，众人都感到惊讶万分。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","有人说耶稣：“他用的是魔鬼之王别西卜的力量驱鬼。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","又有人想要试探耶稣，要求他显现一个来自天堂的神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","耶稣知道他们在想什么，就对他们说：“如果一个国家内战不断，必会分崩离析，如果一个家庭彼此争斗，必然败落。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","如果撒旦内部彼此为敌，他的王国怎能持久？你们居然说我是靠撒旦的力量驱鬼。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","如果真是如此，给自己人驱鬼又要靠谁的力量呢？他们自己就会评判你是错误的。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","我若靠上帝的能力驱鬼，这就代表上帝之国已经降临，就在你们之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","一个壮汉全副武装地看守自己的房屋，让自己的家财保持安全。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","但如果来了比他更强的人，打败他，夺去他所依赖的武器，就会抢走他的所有财产。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","如果你没有与我站在一起，就是反对我。没有和我一起修建楼宇之人，楼宇就会倒塌。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","一个恶灵从人体中被驱赶出来，走遍沙漠，寻找栖身之所，却没有找到。于是就说：‘我要回到我之前离开的那房子。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","它回到老屋后，看见里面已经打扫干净，整整齐齐， ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","他于是又找了另外七个更邪恶的污灵，一起住进去。后来那个男人变得比以前更坏了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","耶稣正在说话之际，民众中有一个女人高喊：“孕育和哺育你的人有福了！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","但耶稣说：“但不如听到并遵守上帝之道的人有福。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","众人围坐在耶稣身边，耶稣就说：“这是个邪恶的世界，因为他们寻求神迹，可是除了约拿的神迹以外，他们看不到其他神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","约拿如何成为尼尼微人的神迹，人子就会怎样成为这个世界的神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","在审判中，南方女王将和这世界之人一起崛起，定众人的罪，因为她来自极地，想要听所罗门的智慧之语。但现在，这里有人比所罗门更伟大！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","在审判的时候，尼尼微人要和这世界之人一起崛起，定众人的罪，因为尼尼微人听了约拿说的讯息后就悔改了。但现在，这里有人比约拿更伟大。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","没有人在点灯后将它藏起来，或放在大碗下面。不，你应该把它放在灯台上，让进到屋内的人可以看得见光。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","你的眼睛就是身体的灯。眼睛健康，身体就充满光，眼睛不健康，身体就进入黑暗。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","所以如果你身体中其实是一片黑暗，不要误以为那是光让你身体的光成为一片黑暗。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","要让你充满了光，不会陷入黑暗。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","耶稣说完这番话，一个法利赛人请耶稣和他一起吃饭。于是他于是就坐下吃饭。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","这个法利赛人很惊讶地发现，耶稣吃饭前不洗手。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","主对他说：“你们法利赛人把杯盘的外面洗净，但里面却充满了贪念和邪恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","愚蠢的人啊，你们认为那创造外在的人，也会创造内在吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","当你对他人做出善举，只有发自内心，才能将你们的一切变得洁净。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","你们法利赛人有祸了！因为你们献上了十分之一的药草和植物，却忽视了公义和对上帝的爱。你们需要关注后者，但前者也不能疏忽。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","你们法利赛人有祸了！你们喜欢在犹太教堂里占据最好的座位，希望在市场中获得尊重。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","你们有祸了！因为你们就像没有刻字的坟墓，人们走在上面也不知情。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","研究法律的专家中有一个回答他：“老师，你这样说，也是在侮辱我们！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","耶稣回答：“你们研究法律的专家也有祸了！因为你们让其他人背上难以承受的重负，自己却连一个指头也不动。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","你们有祸了！你们建造纪念陵墓来纪念先知，但杀死他们的正是你们自己的父辈！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","你们这样做就等于成为证人，表明你们同意祖先的行为。他们杀害先知，然后又修造先知的坟墓。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","所以上帝很睿智地说：‘我要把先知和门徒派到他们中间，有的被他们杀害，有的被他们迫害。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","最终，创世以来众先知所流的血， ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","从亚伯开始，直到在祭坛和圣殿之间被害的撒迦利亚，都要向这世界追讨。是的，我告诉你们，这一切都要向这世界追讨。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","你们研究法律的专家有祸了！因为你们拿走了知识的钥匙，自己不进去，却又阻止其他人进去。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","耶稣离开的时候，宗教老师和法利赛人开始用言语激烈地攻击他，提出很多问题激怒他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","他们希望抓住他的漏洞，想从他的言语中找到可以攻击的地方。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","当时有成千上万的人聚在一起，甚至出现踩踏现象。耶稣就先对门徒说：“虚伪就像是法利赛人的‘酵母’，你们要提防。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","隐藏之事最终会显现，遮掩之事最终会暴露，为人所知。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","你们在暗处说的话，必会被明处之人听见。你们在内室低语交谈的内容，必会在房顶处宣扬出去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","我的朋友，告诉你们，一个人的身躯死掉了，不用害怕，因为人死后什么都做不了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","让我来告诉你们应当怕谁，如果一个人在杀了人之后，还有力量将这些死人投入哥和拿，这样的人才最可怕。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","五只麻雀只能卖两个小钱，但上帝不会忘记任何一只麻雀。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","你们的头发甚至都已被数的一清二楚。不要怕，你们可比很多麻雀贵重得多。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","我告诉你们实话，凡是公开承认跟随我的人，人子在上帝的天使面前也会承认他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","凡是拒绝我的人，在上帝的天使面前也会被拒绝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","说话得罪人子可以被赦免，但亵渎圣灵则不会得到赦免。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","如果有人把你们拉到会堂，在官长和当权者的面前，你们不要思虑怎样辩护自己或该说什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","到了时候，圣灵就会把当说的话教导你们。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","民众中有一个人问耶稣：“老师，请让我的兄弟和我分家产。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","耶稣说：“我的朋友，谁指认我做你们分家产的法官？”于是他对众人说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","“你们要小心，小心所有的贪念，因为一个人的生命并非由拥有的多少而决定。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","然后他又对他们讲了一个故事，说：“从前有一个富翁，拥有一片肥沃的土地。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","他对自己说：‘我该怎么办呢？没有足够的地方存放粮食。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","随后他决定了：‘我知道该做什么了，我要拆掉这些谷仓，建造更大的谷仓，就能存放我所有的粮食，还能放下我拥有的其他物品。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","然后我就可以对自己说：你所拥有的足够你享用很多年，所以活的轻松点，吃喝快乐，享受生活！’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","但上帝却对他说：‘你这愚蠢的人呐，你的生命今晚就会被夺走，你所存放的那些东西要给谁呢？’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","凡为自己积累财富、但在上帝面前并不富足的人，就会这样。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","耶稣又对门徒说：“所以我告诉你们，不要担心生命、担心吃什么或者穿什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","因为生命远比食物重要，身体远比衣服重要。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","看看乌鸦，它们不种粮也不收获，没有仓库或谷仓，上帝仍养活它们。你们比飞鸟贵重得多了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","担心生命，难道能给自己的寿命延长一小时吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","如果连这么小的事都做不好，为什么还担心其他的事呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","想想百合花和它们的生长方式，它们不工作也不纺布。但我告诉你们，即使是所罗门最荣耀之时的穿着，也比不上这花中的一朵呢。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","想想田野上的一切，今天生长，明天就被拿去扔进火里，烹煮食物。尽管如此，但上帝仍然用漂亮的花朵装饰田野，更何况你们呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","不用思量未来吃什么喝什么，完全不用担心。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","因为这只是世人所担心的事情。你们的天父知道你们需要这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","你们只需寻找上帝之国，上帝就会将这一切赐予你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","你们这群绵羊啊，不要怕，因为你们的天父愿意把王国赐给你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","你们应该卖掉自己的所有，把钱拿去施舍穷人，给自己找一个永远不会破损的钱包，在天堂继续使用不尽的财宝，那里没有贼人靠近，也没有虫蛀。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","因为你最在意的事情会显示出你是谁。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","穿好衣服做好准备，点上灯， ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","像仆人等候自己的主人从婚筵回来一样，在主人回来敲门时，可以立刻给他开门。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","主人回来时，如果看见仆人还在清醒看家，这些仆人就有福了。我告诉你们实话，主人必然会穿上盛装，请他们吃饭，也必然会亲自招待他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","即使主人在午夜或天亮之前回来，看见他们保持警惕并做好准备，这些仆人就有福了！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","但要记住，如果主人知道窃贼什么时候来，他就会保持警惕，不会让他闯进屋里。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","你们也必须做好准备，因为人子会在你想不到的时候到来。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","彼得问：“主啊，你说这故事，是只说给我们听还是说给所有人？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","主说：“主人指派家中的一个人作为管家，负责管理家里的事务，然后按时分发粮食，这样的管家是不是值得信赖又聪明？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","主人回来的时候，看见仆人能这样做，那仆人就有福了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","告诉你们实话，主人会指派他管理主人的一切财产。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","但如果那仆人对自己说：‘我的主人不会那么快回来’，然后动手打骂其他的仆人和使女，开始大吃大喝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","主人会在他想不到的日期和时间回来，严厉处罚他，将其视为完全不可信赖之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","仆人知道主人需要什么却不准备，不按照他的意思行事，必多受责打。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","但有的仆人虽然做了会遭受惩罚之事，但由于并不知情，所以责罚会轻一些。如果一个人给你很多，就会向你要求很多，如果一个人受你之托做了很多事，就会要求你做很多事。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","我来到这里，就是为了在大地上点起一把火，我非常希望它已经燃烧起来！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","但我还有必须进行的痛苦的洗礼，所以感觉很痛苦，希望它能尽快结束。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","你们认为我来此是给人间带来和平吗？不是的，我告诉你们，我带来的是纷争。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","从今以后，如果一个家庭有五口人，他们会分成两派产生纷争，三个反对两个，或者两个反对三个。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","他们将彼此对立：父亲反对儿子，儿子反对父亲，母亲反对女儿，女儿反对母亲，婆婆反对媳妇，媳妇反对婆婆。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","耶稣又对众人说：“你们看见西边有云彩升起，立刻就会说：‘要下大雨了’，事实果然如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","刮起南风，你们会说：‘天要热了’，真的就热了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","伪君子啊！你们知道如何识别天地气象，为什么不知道分辨这个时代？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","你们为什么自己不能判断对错呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","你和对手一起去法院，在路上应当尽力与他解决问题，否则他可能把你拉到法官面前，法官把你交给差役，把你关在监牢。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","告诉你吧，除非你还清最后一分钱，否则无法从监狱出来。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","就在这时候，有几个人向耶稣讲述了加利利人的事情，这几个人当时正在圣殿献祭，但彼拉多却将他们杀死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","耶稣问：“这些加利利人为什么遭受如此痛苦？是因为罪孽比其他加利利人更深重吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","告诉你们，并非如此。除非你们悔改，否则也将如此灭亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","当年西罗亚的高塔倒塌时压死了十八个人，难道这些人的罪行比所有耶路撒冷的居民更大吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","告诉你们，并非如此。除非你们悔改，否则也将如此灭亡。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","然后耶稣讲了一个故事：“有一个人在葡萄园里种了一棵无花果树。一天他来到无花果树那里找果子，但没有找到。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","于是他对看园人说：‘这三年来我一直在找这棵无花果树的果子，却总是找不到，把它砍了吧！不要让它白白占了空间。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","看园人说：‘主人，再多留它一年吧，我给它周围松松土，施施肥， ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","如果它结果了，那就太好了。如果没有结果，再砍它也不迟。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","安息日那天，耶稣在会堂向众人传道。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","一名恶灵附体的女人已经病了十八年，后背彻底弯曲，完全直不起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","耶稣看见她，便把她叫过来说：“你可以摆脱这疾病了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","然后耶稣双手按在她身上，她立刻直起腰，开始赞美上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","但因为今天是安息日，耶稣在这一天治病让会堂的主事很不高兴。他对民众说：“每星期有六天应当工作，你们可以在那六天求医，但安息日不行。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","但主回答：“你这伪君子，这一天你们还是要把牛或者驴子从畜栏里放出来，牵去喝水，不是吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","那么这女人作为亚伯拉罕的女儿，已经被撒旦困住十八年，难道不应当在安息日解开束缚，获得自由吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","听到这番话，反对耶稣的人都感到很羞愧，民众却因他的伟大之举而欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","耶稣说：“上帝之国像什么呢？我要把它比作什么呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","它就像一粒芥菜种子，一个人把它种在自己的园子里，长成一棵树，天空的飞鸟会在它的枝头栖息。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","他又问到：“我要把上帝之国比作什么呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","它就像酵母，女人把它与三碗面粉混在一起，等着它发酵。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","耶稣朝着耶路撒冷的方向走去，沿途穿乡过城，教化众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","有一个人问他：“主啊，是不是只有很少的人才会得到救赎？” 他对众人说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“要努力穿过这条窄门，我告诉你们，将来会有许多人想要进去，但却进不去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","等到房子的主人起来关上门，你们就会站在门外敲门说：‘主人啊，请开门吧！’但他的回答是：‘我不认识你们，也不知道你们从哪里来。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","这时候你们会说：‘但我们曾与你一起吃喝，你曾在我们的街道上教导我们。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","他会回复：‘告诉你们吧，我不认识你们，也不知道你们从何而来。你们这些作恶之人，从我这里离开！’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","当你们看见亚伯拉罕、以撒、雅各和众先知都已置身上帝之国，你们却被赶了出去，到时候必然有人痛苦不堪。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","人们从四面八方赶来，在上帝之国坐下来用餐。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","后来者会排在前面，先来者会排在后面。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","这时候，有几个法利赛人对耶稣说：“你应该离开这里，因为希律想要杀你。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","耶稣回答：“去告诉那个老狐狸，今天和明天我需要驱鬼治病，到了第三天，我就会完成来到这里的使命。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","但无论是今天、明天还是后天，我都必须前行，因为先知不能在耶路撒冷以外的地点死去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","耶路撒冷啊，耶路撒冷，你杀害先知，用石头把派给你的人砸死。我总是想把你的儿女召在一起，就像母鸡把小鸡聚在翅膀底下，只是你们不愿意。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","看吧，你们的家将变成荒芜。告诉你们，从今以后，你们再也不会看到我，除非你们说：‘祝福奉主之名前来之人。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","在一个安息日，耶稣来到一个法利赛人长官家里吃饭，期间众人都在仔细观察他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","他面前有一个人，双手双腿肿胀， ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","于是耶稣对研究法律的专家和法利赛人说：“律法是否允许在安息日治病？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","众人保持沉默。耶稣摸了那病人一下，把他治好就叫他走了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","然后耶稣对众人说：“如果安息日那天，你们的儿子或牛掉在井里，你们难道不会立刻把他或它拉上来吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","众人无法回答这个问题。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","耶稣发现他们都选择坐在主位，于是就讲了一个故事。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","他说：“当你受邀参加婚筵，不要坐上主位，因为受邀客人中，可能有人比你更尊贵。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","邀请你和那人过来的主人会对你说：‘请把位置给这个人。’这时候你就只能尴尬地坐到其他位置上。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","但如果在受邀后，一开始选择坐在末位，主人就会过来对你说：‘朋友，请上座。’这样你在同席众人面前才更有尊严。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","凡是高看自己一眼的人，必会被人看轻，凡谦卑之人，必会受到尊重。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","耶稣又对邀请他的人说：“当你在准备午餐或晚餐时，不要邀请你的亲朋好友或富有的邻居，因为他们会回请你，你就得到了报答。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","如果你摆宴席邀请穷人、残废人、瘸腿人和盲人， ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","你就有福了。因为他们没有什么可以报答你。待良善之人复活之时，你必定获得报答。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","宴会中一名客人听了这番话，就对耶稣说：“在上帝之国里用餐之人有福了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","耶稣回答：“一个人大摆宴席，请了许多客人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","到了开席的时候，他派仆人去通知受邀客人，‘来吧！宴席已经备好。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","但众人却都在推辞。第一个人说：‘我买了一块地，得去看一看，很抱歉。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","另一个说：‘我买了十头牛，要去试一试，太抱歉了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","还有一人说：‘我刚结婚，不能去。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","仆人回来把这些事告诉主人，主人很生气，对仆人说：‘快到城里的大街小巷，把穷人、残疾人、盲人和瘸腿之人都领到这里来。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","随后仆人说：‘主人，我已经按你的吩咐办好了，但还有空位。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","主人对仆人说：‘那就到乡间小路去，把人们都叫过来，我希望屋子坐满。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","告诉你吧，之前邀请的那些人，谁也别想尝到我宴席的滋味。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","一大群人与耶稣同行，他转身对他们说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“如果你们想跟随我，但对我的爱无法超过对父母、妻儿、兄弟姊妹、甚至自己生命的爱，就无法成为我的门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","如果你不能背负自己的十字架跟随我，也不能做我的门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","如果你想盖一座高塔，总是要坐下算算费用，看看能不能盖成，是不是？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","否则，如果在打好地基后却不能完工，人们得知这一切就会讥笑你， ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","说：‘看看这个人，开工了却完不成。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","或者一个国王与另一个国王开战，如果他只有一万兵马，而敌方却有两万兵马，他是不是要与军师们商议，看看能不能打赢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","如果不能，就要趁对方还未兵临城下，先派使者去讲和。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","同样，你们中间不论谁，如果无法撇下一切跟随我，就不能做我的门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","盐是个好东西，但如果失去了咸味，怎能让它再咸起来呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","它对田地没好处，也不能做肥料，你只能把它扔掉。如果你有耳朵，就要听一听。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","很多税吏和其他“罪人”经常来到耶稣那里，听他讲道。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","于是法利赛人和宗教老师抱怨到：“这个人欢迎罪人，还和他们一起吃饭。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","耶稣就对他们讲了一个故事，说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“如果你有一百只羊，失去一只，是不是会把剩下的九十九只留在开阔牧场，然后去寻找那丢失的羊，直到找到为止？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","如果你找着了，就会高兴地把羊扛在肩上， ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","回到家后招呼朋友和邻居来，对他们说：‘来和我一同庆祝吧，因为我找到了丢失的羊！’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","告诉你们，一个罪人若能悔改，天堂就会获得更多欢乐，甚至超过九十九个不用悔改的良善之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","假设一个女人有十枚银币，如果丢了一枚，是不是要点上灯，在整个屋子里细细寻找，直到找到？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","当她找到那枚银币，就会叫来亲朋好友，对他们说：‘来和我一同庆祝吧，因为我找到了丢失的银币！’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","我告诉你们，一个罪人若能悔改，上帝的天使也会感到欢乐。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","耶稣解释道：“从前有个人有两个儿子。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","小儿子对父亲说：‘爸爸，请把我应得的家产分给我。’于是父亲就把财产分给兄弟二人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","几天后，小儿子带上所有的家当去了远方，在那里过着放荡的生活，奢侈浪费。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","他花光了所有钱财，又恰逢当地遇上严重饥荒，他穷得肚子都吃不饱。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","于是他在当地一个农户那里找差事做。那人打发他到田里去放猪， ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","他太饿了，甚至愿意吃猪食，但即使这样也没有人愿意给他食物。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","他这时才幡然醒悟，于是对自己说：‘我父亲所有的工人都有丰盛的食物可以享用，为什么我却要在这里饿死？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","我要回家，到我父亲那里去！对他说：父亲，我的罪违背了天堂，也违背了你， ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","我不配再做你的儿子，请向对待雇工那样对待我吧。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","于是他动身回家去找他的父亲。 当他父亲看到他的身影，尽管还在远处，便动了恻隐之心，跑过去拥抱他，亲吻他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","儿子说：‘父亲，我违背了天堂也违背了你，不配再做你的儿子。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","但父亲却吩咐仆人说：‘快把那最好的长袍拿来给他穿，给他戴上戒指，穿上鞋。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","把我们养肥的牛犊宰了，我们要大吃一顿， ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","因为这可是我死而复活、失而复得的儿子。’于是他们开始庆祝起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","这时候大儿子正在田里干活。他朝着家的方向走去，听见音乐和跳舞的声音， ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","于是就找来一个仆人，询问发生了什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","仆人说：‘你弟弟回来了，你父亲因为他平安归来，就宰了那头肥牛犊。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","大儿子很生气，不肯走进屋子里，于是父亲出来劝他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","他对父亲说：‘你看，我照顾你这么多年，从来没有违背过你的命令，但你从未给我任何羊羔，让我可以和朋友们聚会。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","但你这个儿子，把你的钱都浪费在妓女身上，他一回来，你反倒为他宰杀肥牛犊！’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","父亲对他说：‘孩子，你总是跟我在一起，我的一切都是你的。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","但你这个弟弟是死而复活、失而复得，所以我们应该高兴，应该庆祝！’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","耶稣向门徒讲了一个故事：“从前有个财主，有人指控他的管家浪费主人的财物。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","主人把管家叫来，对他说：‘我听说了关于你的事情，怎么会这样？把你管的账目拿来，你不能再做管家了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","管家心想：‘主人不让我继续做管家，我又该做什么呢？去锄地没有力气！去讨饭又太羞耻了！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","对了，我知道该做什么了。这样做，如果我不再当管家，就会有人让我去他们家做工。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","于是他找来欠他主人债的人。他问第一个人：‘你欠我主人多少？’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","那人说：‘一百桶油。’管家说：‘那快坐下来，拿着你的欠条，把它改成五十桶。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","他又问另外一人：‘你欠多少？’那人说：‘一百包麦子。’管家说：‘给你欠条，改成八十包。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","他的主人夸奖了这位不诚实的管家，称他做事机警，因为现世之子在对待彼此的时候，比光之子更狡诈。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","我告诉你们，用现世的财富去结交你的朋友，这样当你失去钱财后，就可以进入永恒之家。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","如果你在极小的事情上可以获得信任，大事也是如此。如果你在极小的事情上不诚实，大事也会不诚实。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","如果你在现世财富方面不值得信任，谁还会把真实的财富托付给你们？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","如果你们对别人的东西不忠心，谁还把自己的东西交给你们呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","一个仆人不能服侍两个主人，他必会喜欢一人，讨厌另一人，或忠于一人而背离另一人。你们不能同时服侍上帝和金钱。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","视财如命的法利赛人听见这些话，便开始嘲笑耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","但耶稣对他们说：“你们在人前自称善人，上帝却知道你们在想什么。因为人所看中的，正是上帝所憎恶的。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","律法和先知所写的，持续到约翰为止。此后所传递的就是上帝之国的福音，人人都努力想要挤进上帝之国。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","但相比天地终会消散，律法文字中哪怕是最小的一个点，也更不容易消失。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","如果你休妻另娶，就犯了奸淫之罪。如果你娶了被休之妻，同样也是犯了奸淫之罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","从前有一个财主很富有，总是身穿紫袍和精致的麻衣，过着奢华无度的日子。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","有个满身长疮的乞丐名叫拉撒路，他经常坐在财主门口， ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","希望用财主饭桌上掉下的残渣充饥，甚至还有狗跑来舔他的疮。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","后来乞丐死了，天使们将他送到亚伯拉罕那里。财主也死了，被埋在土里。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","财主在阴间受尽折磨，于是向上望去，看到了亚伯拉罕和他身边的拉撒路。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","于是财主喊着说：‘我父亚伯拉罕啊，可怜可怜我吧！派拉撒路来用手指蘸点水，冰冰我的舌头！我在这火焰炙烤的太难熬了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","但亚伯拉罕回复道：‘我的孩子，想想你生前享过的福，那时拉撒路过着穷苦的生活。现在他在这里过得很舒适，你就要受苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","不仅如此，我们和你们之间还隔着一道深渊，从我这边根本无法去你那边，你们那边也无法到我们这边。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","财主说：‘我父啊，那么求你派拉撒路到我父亲的家里去， ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","因为我有五个兄弟，他可以警告他们，免得他们最终也到这痛苦之地。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","亚伯拉罕说：‘摩西和先知都在他们那边，你的兄弟应该听他们的。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","财主说：‘不行啊，我父亚伯拉罕。如果出现在他们面前的人是死而复生，他们必定会悔改！’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","亚伯拉罕对他说：‘如果他们不听从摩西和先知的话，就算有人死而复生，他们也不会信服。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","耶稣又对门徒说：“诱惑不可避免，但那些传递诱惑之人有祸了！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","对这种人，最好把一块大磨石拴在他的脖子上，将他沉在海里，总比让这些儿童犯罪要好。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","所以做每件事都要小心。如果你兄弟犯下罪行，要警告他。如果他幡然悔悟，要宽恕他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","就算他每天有七次用罪冒犯你，但又七次回来对你说：‘我真的很抱歉！’你也要宽恕他。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","门徒对主说：“请帮助我们获得更多信心。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","主回答：“即使你们的信心微小如一粒芥菜种，也能命令这棵桑树：‘把根拔起，自己栽到海里去！’它就会听你的命令。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","假设你有个仆人负责耕地或放羊，当他从田里回来，你是不是会对他说：‘快过来坐下吃饭’， ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","不，你会这样说：‘给我准备饭菜，穿戴整齐来服侍我，你等我用晚餐后才能吃饭。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","如果仆人做了主人吩咐的事，主人是否还要感谢他？不需要。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","同样，你做了别人吩咐你做的事，只需说：‘我们不是最好的仆人，只是做了分内之事。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","耶稣继续向耶路撒冷走去，途径撒玛利亚和加利利的边境。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","他走进一个村庄，遇到了十个麻风病人站在远处。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","他们大声喊：“耶稣，主啊，可怜可怜我们吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","耶稣看见他们就说：“去让祭司看看你们吧。”他们在见祭司的途中就痊愈了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","其中一个人见自己痊愈，就回到耶稣面前大声颂赞上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","这个撒玛利亚人伏倒在耶稣脚前，感谢耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","耶稣说：“十个人都治愈了吗？其他九人在哪里？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","除了这个异教徒，难道没有别人回来颂赞上帝吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","耶稣就对他说：“起来走吧，你的信任治愈了你。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","有一次，法利赛人过来问耶稣上帝之国何时降临。他回答：“上帝之国降临之时，不会有任何让你看到的迹象。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","人们不会说：‘看，在这里’，或说：‘看，在那里’，因为上帝之国就在你们之中。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","然后耶稣又对门徒说：“那个时刻快到了，就是你们渴望看到人子的日子，但你们其实看不到。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","有人会对你们说：‘看呐，他在那里。看呐，他在这里。’不要跑去追随他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","当人子到来之际，会如闪电发出光亮，从天空的一侧到另一侧闪过，将天空点亮。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","但首先他必须经受许多苦，被这个世界所抛弃。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","人子到来的时代，会像诺亚所面临的那一刻。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","当时人们都在吃吃喝喝，忙着嫁娶，直到诺亚进入方舟的那一天，洪水到来，摧毁了一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","那一刻就像罗得所面临的时代。当时众人忙着吃吃喝喝，做买卖、种地或者盖房子。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","在罗得离开索多玛的那一天，天空落下火与硫磺，摧毁了一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","人子出现的那一天就是这样。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","到了那一天，如果你站在房顶，家当都在屋里，不要跑下去拿。如果你在田里，不要回家。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","记着罗得妻子的教训。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","如果你想抓住生命，就会失去生命，如果你失去生命，就会拯救生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","告诉你们吧，在那个时刻，如果一张床上躺着两个人，一人会被接走，一个会被留下。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","如果有两个女人一起磨谷子，一个人会被接走，一个会被留下。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","门徒问耶稣：“主啊，它会在哪里发生？”耶稣回答：“哪里有尸首，哪里就会围着秃鹫。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","为了鼓励大家始终进行祈祷，不可灰心，耶稣对他们讲了一个故事。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","他说：“从前在一座城中有一个法官，不敬重上帝，也不关心其他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","城里有一个寡妇常常来到他那里，对他说：‘求你为我的敌人给出公正评判！’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","法官一开始并不想做这件事，但后来转念一想：‘虽然我不敬重上帝，也不关心其他人， ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","但这寡妇太烦人，我就给她想要的判决吧，这样她就不会不断地来烦我了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","主说：这是个不正义的法官，但听听他说的话。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","“你没发现吗？上帝所选的子民如果日夜向上帝哭求，上帝就会让其获得公道吗？上帝怎么会让他们等待呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","不会的，我告诉你们，他会很快主持正义。但人子到来之际，他在这世上还能找到信他的人吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","耶稣还向那些自诩正义、轻视他人的人讲了一个故事。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“有两个人到圣殿祷告，一个是法利赛人，一个是税吏。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","法利赛人站着为自己祷告：‘上帝啊，感谢你让我和其他人不一样，我不欺骗，不犯罪，不奸淫，甚至不像这个税吏。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","我一个星期禁食两次，将收入的十分之一奉献给你。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","但税吏站在远处，甚至不敢抬头看天，只是捶胸祷告：‘上帝啊，可怜我这个罪人！’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","我告诉你们吧，上帝会看到这税吏是正确的，但不会看到另一个人。因为高抬自己的人必会被贬低，保持谦卑的人必会被抬高。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","有人抱着婴孩来到耶稣面前，请他祝福。门徒见状就想要制止他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","耶稣却让他们把婴儿抱过来，说：“让小孩子到我这里来，不要制止他们，因为上帝之国就属于他们这样的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","实话告诉你们，如果不能像小孩子一样接受上帝之国，你就永远都无法走进。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","有一个长官来到耶稣面前，问他：“良善的老师，我做什么才可以获得永生？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","耶稣对他说：“你为何称我良善？除了上帝以外，无人为尊。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","你知道那条诫命讲着：不可奸淫，不可杀人，不可偷盗，不可作假证，当孝敬父母。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","那男人回答：“我从小就遵守这一切。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","耶稣听了便说：“但你还少做了一件事：把你拥有的一切都卖掉，分给穷人，你就会在天国拥有财富，然后来跟从我。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","但那人听了这番话，立刻感到情绪低落，因为他非常富有。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","耶稣见他这样的反应，就说：“富有之人要进上帝之国，很难！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","有钱人进上帝之国，要比让骆驼穿过针眼还困难。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","听到这番话，大家就问：“那谁可以获得拯救呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","耶稣说：“人类做不到的，上帝却能。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","彼得说：“我们已舍弃所有跟从你！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","耶稣说：“实话告诉你们，人为了上帝之国放弃房屋、妻子、兄弟、父母或儿女， ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","得到的要比今世多几倍，来世还会获得永生。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","耶稣把十二门徒带到一边，对他们说：“我们现在去耶路撒冷，先知所写的一切，即将在人子身上成真。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","他将被交给异族人，被嘲笑、被凌辱，人们会向他吐唾沫， ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","他们会鞭打他，然后杀害他，但他会在第三日复活。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","但门徒们并不明白耶稣这番话的意思，没有理解这句话的真意。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","耶稣快走到耶利哥的时候，一个盲人坐在路旁乞讨。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","听见人群经过，他便问发生了什么事。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","众人告诉他，“拿撒勒人耶稣正从这里走过。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","于是他喊道：“大卫的子孙耶稣啊，可怜可怜我吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","走在前面的人制止他喊叫，让他保持安静，但他更大声地喊叫：“大卫的子孙，可怜我吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","耶稣停下来，让他们把盲人带过来。待他走近，耶稣就问他： ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“你要我为你做什么？”盲人说：“主啊，求你让我看到！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","耶稣说：“那就看见！你对我的信任，让你痊愈了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","盲人立刻看见了，于是就跟随耶稣，赞颂上帝。众人见此也纷纷赞美上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","耶稣走进耶利哥城，穿城而过。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","有一个名叫撒该的税吏长，非常富有。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","他想看看耶稣到底是谁，但在人群中，身材矮小的他无法看见。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","于是他跑到前面，爬上一棵无花果树，想在耶稣经过的时候看看他的样子。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","耶稣走到这里后往上一看，对他说：“撒该，快下来，今天我要住在你家中。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","撒该马上爬下来，高兴地迎接耶稣到他家去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","众人见状议论纷纷：“他竟要住在这样的罪人家中！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","撒该站着对主说：“主啊，你看，我正在把一半的家财分给穷人，如果我曾欺骗谁，就会四倍奉还！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","耶稣说：“今天这栋房子迎来了救赎，他也是亚伯拉罕的子孙。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","因为人子来寻找和拯救的就是迷失之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","众人专心听着耶稣的话。由于这里接近耶路撒冷，加上民众都认为上帝之国即将出现，于是耶稣就讲了一个故事。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","他说：“从前有一个贵族，他离开家去远方接受王位加冕，然后再回到家。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","他叫了自己的十个仆人来，将钱平分给他们，然后说：‘你们用这钱去做投资，一直到我回来。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","但这国家的人都憎恨他，于是派一个代表跟过去，说：‘我们不想这个人做王统治我们。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","贵族获得王位后返回，然后将那些拿钱投资的仆人召来，询问他们做投资的收益情况。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","第一个仆人上前说：‘主人，你的钱已经赚了十倍。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","国王说：‘做得好，你是个好仆人，因为你证明了在小事上很忠心，我现在派你去管理十座城。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","第二个过来说：‘主人，你的钱已经赚了五倍。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","国王说：‘我派你去管理五座城。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","另一个仆人走进来说：‘主啊，你看，这是你的钱，现在还给你。我用布包着它，确保安全。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","你是个严厉的人，我很害怕你。我怕你会拿走不属于你的东西，会收走你没有种下的作物。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","国王回答：‘我要根据你这番话来审判你。你知道我很严厉，会拿走不属于我的东西，会收走我没有种下的作物。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","那你为什么不把我的钱存入银行，等我回来的时候，就可以连本带息取回来？’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","国王对身边站着的仆人说：‘把他的钱拿走，交给那赚了十倍的人。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","侍卫说：‘但主人，他已经有了十倍的钱了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","国王说：‘告诉你们吧，那些已经有的，还会有更多。没有的，现在有的也会被拿走。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","至于那些不愿意我做国王统治他们的敌人，现在把他们拉到这里来，当着我的面杀掉！’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","耶稣讲完这个故事，就继续向前朝着耶路撒冷走去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","快到伯法其和伯大尼时，他来到了橄榄山，在那里叫来两名门徒，对他们说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“你们到前面的村子去，进去后会看见有一个地方拴着一头从未有人骑过的小驴，解开它的绳子，把它牵来。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","如果有人问为什么解开它，你们就说：‘主需要它。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","两名门徒出发了，后来发生的一切与耶稣所说如出一辙。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","他们解开小驴的时候，驴主人问：“你们为什么解开它？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","他们说：“主需要它。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","门徒把小驴牵到耶稣那里，把自己的衣服搭在驴背上，耶稣坐在上面。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","耶稣骑驴前行，众人把自己的衣服铺在路上。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","当他走近耶路撒冷，这里也是橄榄山的下山路，门徒们因为看见了所有神迹，开始充满喜悦地大声赞美上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","他们大声喊：“奉主之名前来的王，赞颂你！愿和平降临天堂，愿荣耀降临至高天堂！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","民众中有几个法利赛人对他说：“老师，不要让你的门徒说这些！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","耶稣说：“我告诉你们，他们若保持沉默，石头就要呼喊了！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","耶路撒冷越来越近了，耶稣看见这座城，开始为之哭泣， ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","他说：“我真希望你们——就是你们啊，在今天能知道通往平安的路，但都隐藏起来了，你们看不到。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","时间一到，你们的仇敌就会包围过来，搭建斜坡攻击你们，把你们团团围住，困住你们， ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","他们会彻底摧毁你们，还有你们的孩子。所有的石头建筑都会轰然倒塌，因为你们在救赎到来之刻拒绝接受。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","耶稣走进圣殿，赶走做买卖之人， ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","他对他们说：“经文上记着：‘我的殿将用于祷告’。你们却把它变成贼窝了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","然后他每天都在圣殿里教导众人。祭司长、宗教老师和首领都想杀害他， ");
INSERT INTO cmnfeb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","但又不知道如何下手，因为众人都围着他并聆听。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","有一天，耶稣在殿里教导众人，告诉他们好消息。祭司长、宗教老师和长老走上前来， ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","他们对他说：“告诉我们，你凭着什么权力做这些事？谁给你的这权力？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","耶稣回答：“我也要问你们一个问题，告诉我， ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","约翰的洗礼是从天上来，还是从人间来？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","这些人开始议论：“如果我们说‘从天上来’，他就会说‘那你们为什么不信他？’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","如果我们说：‘从人间来’，众人会用石头打我们，因为他们认定约翰是先知。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","于是他们回答耶稣：“我们不知道从哪里来。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","耶稣说：“那我也不告诉你们，是谁给我权力做这一切。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","随后耶稣向众人讲了一个故事：“一个人有一个葡萄园，由于住在距离这里很远的另外一个乡村，他便将葡萄园租给了农户。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","到了收获的季节，园主派一个仆人到农户那里，收取葡萄园应该上交的水果。但农户却打了那个仆人，让他空手回去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","园主又派另一个仆人去，同样受到殴打和侮辱，空手而归。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","园主又派了第三人去，农户依旧把他打伤，然后把他赶走。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","园主暗自想：‘该怎么办？我知道了，派我的爱子去，也许这一次他们会尊敬他。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","农户一看见园主的儿子，立刻交头接耳说：‘这人会继承产业，我们杀了他，这产业就成为我们的了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","于是他们把园主之子推出葡萄园外杀了。那么主人会怎样对付他们呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","他会过来杀掉这些农户，把葡萄园租给别人。” 众人听了这个故事，就说：“希望这样的事情不要发生！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","但耶稣看着他们说：“那么经文中说：‘建筑工人弃用的石头，现在成了主要基石。’这是什么意思呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","任何人在那石头上摔倒，都会粉身碎骨，那石头落在任何人身上，都会砸着他们。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","宗教老师和祭司长知道这比喻针对他们，当时就想把耶稣抓起来，可是又害怕民众的反应。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","他们找了个机会，派几名奸细假装虔诚信徒去找耶稣，想找到耶稣说话的把柄，然后把他交给总督裁决。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","奸细问耶稣：“老师，我们知道，你所说所教都是正道，你绝不会因其他人的意见而动摇，你真的是在将上帝之道传授众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","那么，我们是否应该向凯撒纳税？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","耶稣看透了他们的诡计，于是说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“给我一个银币，上面是谁的形象？”他们回答：“凯撒。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","耶稣说：“那么，是凯撒的就应属于凯撒，是上帝的就应当属于上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","耶稣向众人所说的话，让他们无法抓住把柄，这番话也让他们很震惊，于是就沉默了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","几个撒都该人来到耶稣这里，他们从来都不相信人死会复活。他们问到， ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“老师，摩西在律法中写道：‘如果一个男人娶了妻子，但未留下一儿半女就死了，他弟弟就应当娶嫂子，为哥哥留后。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","从前有兄弟七人，老大娶了妻子后死了，没有留下后代， ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","随后老二, ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","老三一直到老七都娶了她，但都没有留下孩子就死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","最终那女人也死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","那么，这女人复活的时候，要做哪个兄弟的妻子呢？因为七个人都娶过她。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","耶稣说：“只有在这里的人才嫁娶。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","但对于那些有资格进入新世界的人，那些死而复生之人，不娶也不嫁。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","他们和天使一样不会死亡，因为他们是复活之子，也就是上帝的之子。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","至于死人复活的问题，摩西在关于荆棘的经文中写过，他口中的主是：亚伯拉罕的上帝、以撒的上帝、雅各的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","他不是死人的上帝，而是活人的上帝，因为在他那里的人都活着。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","几个宗教老师说：“老师，你说得好。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","然后他们就不敢再提出任何问题了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","耶稣问他们：“为什么说基督是大卫的子孙？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","因为大卫自己在《诗篇》中说：主对我的主说‘坐在我的右边， ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","我会让你的敌人变成你的脚凳。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","大卫称他为‘主’，所以他怎会是大卫的子孙呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","众人聚精会神地听着，耶稣对门徒说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“你们要小心宗教老师，他们喜欢穿长袍走来走去，喜欢人们在集市中向他们恭敬问安，喜欢坐会堂里的高位、宴席上的首座。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","他们骗光寡妇的财产，通过冗长的祈祷伪装自己。这些人在审判中必受到严重的责罚。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","耶稣环顾四周，看见有钱人把捐赠投入奉献箱。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","他又看见一个穷寡妇，在里面投入两个小钱。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","于是耶稣说：“实话告诉你们，穷寡妇所投入的要比其他所有人加一起还要多。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","因为其他人只是自己财富的一部分投进去，这寡妇虽然很穷，却献出了赖以为生的所有金钱。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","那里有人在讨论圣殿以及它精美的石艺和供物装饰。但耶稣说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“你们看见的这些......在那一刻到来之时，所有垒砌的石头都会倒塌，一切都会被摧毁。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","他们问他：“老师，这会在什么时候发生？发生的时候会有什么预兆？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","耶稣提醒他们说：“你们要小心，不要被人迷惑。因为会有很多人来假冒我的名，说‘我就是基督！’，还会说‘时候到了！’但不要跟随这些人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","当你们听到战乱和暴动，不要惊慌，因为这样的事情一定会先出现，但不会马上看到结局。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","耶稣对他们说：“民族之间要有战争，国家之间要有战争。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","到时候会有剧烈的大地震，处处是饥荒和瘟疫，天空显现可怕的恐怖预兆。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","但在这一切发生之前，他们会抓住你们，迫害你们，把你们拖到会堂前，扔进监狱里，甚至会押到国王和总督面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","但这会为你们提供一个机会，在他们面前代表我发言。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","所以，你们要提前坚定决心，不必提前思量如何进行自我辩护。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","因为我会让你们说出睿智之语，让所有的敌人都不能辩论或反驳。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","你们将会被父母、兄弟、亲戚和朋友出卖，你们中有的人会被他们害死。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","因为我，你们会被众人恨恶， ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","但你们却可以毫发无伤。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","只要坚定自己的立场，就会获得自己的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","但是，当你们看见耶路撒冷被军队团团围住，就知道它距离摧毁的日子已经不远了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","住在犹太的必须逃到山上；住在城里的必须离开；住在乡下的不要进城。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","因为这是惩罚的日子，经书上所写的一切都会变成现实。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","到那时，怀孕和哺乳婴儿的女人将会很艰难！因为可怕的灾难将降临这片土地，众人都将被惩罚。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","他们将被刀屠杀，俘虏到各国并被投入监狱，耶路撒冷必被异教徒践踏，直到异教徒占领的时间结束。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","日月星辰都会有预兆，世界的国家会因海洋的波涛汹涌而陷入苦难。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","天上的力量震撼世界，这个世界即将发生的事情让人们陷入恐惧，这恐惧会让人虚弱。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","到那时，他们会看见人子携力量和伟大荣耀，驾云降临。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","在发生这一切的时候，你们应当昂首挺立向上看，因为你们很快就会被救赎。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","然后耶稣举例讲了一个故事：“看看这无花果树或其他的树木。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","看到它们发芽，你就知道夏天将至。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","同样，当你们看到这些事情发生，无需别人告诉你，就知道上帝之国已近。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","我告诉你们真相，这一代人在有生之年定会看到这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","天地都将走向终结，但我的教诲不会消失。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","小心，不要因各种派对、贪图美酒和生活困苦分散了你的注意力，因为那一天会突然降临， ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","那一天会波及地球上的所有人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","你们要时刻警醒和祈祷，这样才有可能逃离这将要发生的事情，才可以站在人子面前。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","耶稣每天都在白天到殿里教导，晚上到橄榄山中过夜。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","群众清早起来上圣殿，到他那里听他讲道。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","人们即将迎来除酵节（又名逾越节）。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","祭司长和宗教老师惦记着如何杀掉耶稣，但他们惧怕民众的反应。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","这时，撒旦附身进入十二门徒之一，加略人犹大的身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","他去找祭司长和守殿官，商量如何背叛耶稣，把他交出去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","他们很高兴，许诺事成后要给他金钱。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","他答应了，然后打算趁民众不在那里的时候，找机会把耶稣交给他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","逾越节到了，这一天人们通常会宰杀羊羔作为献祭。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","耶稣找来彼得和约翰，说：“去准备逾越节的晚餐吧，让我们可以一起用餐。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","他们问：“你想让我们在哪里准备？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","耶稣说：“你们进城后，会遇到一个人顶着水罐，跟着他，在他走进一个房子后，跟进去。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","对那房子的主人说，我们老师问你：‘餐厅在哪里？他和门徒们想在那里举行逾越节晚餐。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","主人会带你们到楼上，那里有一间布置整齐的大房间，你们就在那里准备。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","两位门徒出发了，其后发生的一切与耶稣所说别无二致，他们就在那里准备好逾越节的晚餐。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","晚餐时候到了，耶稣和门徒一同进餐。他对众人说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","“我一直很想在我的痛苦开始前，与你们共进这逾越节的晚餐。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","我告诉你们，我以后绝不会再吃这样的晚餐了，直到上帝之国来临。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","耶稣拿起酒杯致谢，然后说：“拿着它，大家分着喝。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","告诉你们，从今以后，我决不再喝这葡萄酒，直到上帝之国来临。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","他拿起饼感谢大家，然后掰开饼递给众人说：“这是我的身体，现在也给了你们了。你们应当也这样做，以此记念我。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","饭后，他用同样的方式拿起酒杯说：“这酒杯里是以我的血写就的新契约，这血为你们而流。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","此外，出卖我的人此刻就和我在同一张桌子旁。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","因为人子身亡早已是定数，但出卖人子的叛徒却有祸了！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","门徒们彼此询问，想知道他们中到底谁能做这种事。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","与此同时，他们还争论另外一件事：他们中谁最重要。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","耶稣对他们说：“每个异国城邦都有君王统治，他们的掌权者被称为‘恩主’。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","但你们不能如此！你们中最高位置的那一个，应该表现得最谦卑，做首领的应该像奴仆。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","谁更伟大？是坐在桌子前用餐的，还是服侍人的那一位？难道不是坐着用餐的那一位吗？但我在你们中间就像一个侍者。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","在我接受磨炼的过程中，是你们伴在左右。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","我父如何把权力赐给我，我就怎样将它赐给你们， ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","这样你们就可以在我的国中，坐在我的桌前用餐，然后坐上王座审判以色列的十二部落。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“西门啊，西门，撒旦说过要抓住你，像筛麦子一样考验你。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","但我已经为你起祈祷，让你不会失去信任。当你返回的时候，要鼓励你的兄弟。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","彼得说：“主啊，我已经准备好要跟你一起进监牢，一同赴死！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","耶稣说：“彼得，告诉你吧，今天鸡叫以前，你会有三次说不认识我。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","耶稣又对他们说：“以往我派你们出去时，不让你们带钱袋，不要额外准备鞋子，你们可曾缺少什么？”他们说：“没有。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","耶稣说：“但现在，你们如果有钱，就留着它，有袋子也要留着。如果没有刀，把衣服卖掉去买刀。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","告诉你们，经文中说‘他被视为不法者’，这句关于我的预言将会变成现实。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","他们说：“主啊，请看，这里有两把刀。”耶稣说：“足够了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","耶稣照常去往橄榄山，门徒也跟着他同行。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","来到那里，他对门徒说：“祈祷吧，不要在诱惑面前屈服。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","于是耶稣离开他们，走到大约扔一块石头的距离，跪下祷告说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“父啊，如果你愿意，就把这痛苦之杯拿走。但我会做你想让我做的，而不是我想做的。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","这时有一位天使从天上显现，赐予他力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","耶稣非常痛苦，祷告得更加恳切，汗如血滴般滚落在地面。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","祷告完毕，他站起来向门徒们走去，看见他们因为忧愁过度而感到疲倦，所以都睡着了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","耶稣说：“你们为什么睡觉呢？起来祷告！免得陷入诱惑。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","耶稣说话的时候，十二门徒中的犹大带着一群人出现。看到耶稣，犹大就走上前来亲吻他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","耶稣对他说：“犹大，你用亲吻出卖人子吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","耶稣的追随者便问：“主啊，我们是否应该用刀攻击他们？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","一名追随者砍了大祭司的仆人一刀，削掉了他的右耳。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","耶稣说：“住手！别这样了！”然后摸了那人的耳朵，让他痊愈。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","面对前来捉拿他的祭司长、守殿官和长老，耶稣说：“你们带着刀棒前来，是想把我当作暴力罪犯捉拿吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","以前我每天都在圣殿中和你们在一起，你们却不下手，但现在你们的时候到了，到了黑暗掌权的时候了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","他们抓住耶稣，押到大祭司家里，彼得远远地跟在后面。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","他们在院内生了火，围坐在火堆旁，彼得也坐在他们中间。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","有一个侍女见他面向火光坐着，盯着他看了一会，说： ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","“这人是和他一伙的。”但彼得却否认，说：“你这女人，我不认识他！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","不久，另一个人又看见他，说：“你也是他们中的人。”彼得说：“不，我不是！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","大约过了一小时，又有一个人坚称：“这人真是和他一伙的，他也是加利利人。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","彼得说：“我不知道你在说什么！”说话间，他听到鸡叫。主转过身来，看着彼得。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","彼得想起主对他说过的话：“今天鸡叫以前，你会有三次说不认识我。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","于是就走出去开始痛哭。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","看守耶稣的守卫开始嘲笑他，殴打他， ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","他们蒙住他的眼睛问：“如果你能预言，那么说说看打你的是谁。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","此外还说了很多辱骂的话。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","天一亮，长老议会、祭司长和宗教老师聚集到一起，把耶稣带到他们的公议会，说到： ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“你若是基督，就告诉我们吧。” 耶稣说：“就算告诉你们，你们也决不相信。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","如果我问你们问题，你们也决不回答。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","但从今以后，人子将坐在上帝王座的右边。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","他们说：“那么你是上帝之子吗？”耶稣说：“那是你们说的。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","他们说：“我们还需要哪些见证呢？我们亲耳听见他所说的话。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","议会的所有成员都站起来，把耶稣押到彼拉多那里， ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","他们开始控告他：“我们查出这个人欺骗我们的同胞，鼓动人们不要向凯撒纳税，并且自称是基督，是王。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","彼拉多问他：“你是犹太人的王吗？”耶稣回答：“这是你说的。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","彼拉多对祭司长和众人说：“我在这人身上找不出什么罪。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","但那些人却坚持说：“从加利利到这里，他一直在犹太各地煽动群众造反。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","彼拉多听见这个控诉，就问耶稣是不是加利利人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","他发现耶稣来自希律的辖区，就把他送到希律那里，当时希律就在耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","希律很高兴看到耶稣，因为他曾经听过耶稣的事迹，早就想要见他，希望看他显示神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","于是他问了耶稣许多问题，但耶稣始终没有回答。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","祭司长和宗教老师站在那里，愤怒地控告他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","希律和他的侍卫很轻蔑地对待他，嘲笑他，给他穿上皇家长袍，把他送回彼拉多那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","希律和彼拉多之前一直都很敌对，在那一天就成了朋友。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","彼拉多召集了祭司长、官长和民众， ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","对他们说：“你们把这人押到我这里来，说他蛊惑群众叛乱，我已经在你们面前仔细审讯过，在他身上一点也找不到你们指控的罪状。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","希律也找不到，所以又把他送回我这里，可见他没有做过必须判死刑的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","所以我要做的就是鞭打他，然后把他释放。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","众人齐声喊叫：“杀了这个人，为我们释放巴拉巴！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","（巴拉巴是因为参加城里的叛乱和谋杀而判入狱。） ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","彼拉多再次向他们表明，他想要释放耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","但他们高声呼叫：“把他钉十字架！把他钉十字架！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","彼拉多第三次问他们：“但为什么呢？这人做过什么恶事？我在他身上找不到任何死罪的证据。所以我要鞭打他，然后把他放了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","但众人大声喊叫，坚持要把耶稣钉十字架，他们的高声喊叫最后奏效了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","彼拉多照他们的要求做出了审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","他把众人希望赦免的叛乱杀人犯释放了，然后把耶稣交出来，让他们随自己的意思将耶稣处死。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","把耶稣带走的时候，他们抓住一个从乡下来的古利奈人西门，把十字架放在他身上，叫他跟在耶稣后面。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","一大群人跟随耶稣身后，有些妇女为他捶胸痛哭。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","耶稣转过身来对她们说：“耶路撒冷的女儿啊，不要为我哭泣，要为你们自己和你们的儿女哭。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","当那一天到来之际，她们会说：‘没有生育、没有怀过胎、也没有哺养过婴儿的有福了。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","他们会对大山说：‘倒在我们身上！’对小山说：‘盖住我们吧！’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","如果他们可以对绿树这样做，又会怎样对待枯干的树呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","他们另外带来两个犯人，和耶稣一同等待处决， ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","随后来到一个名叫“髑髅”的地方，把耶稣钉在十字架上，将另外两个犯人也钉上十字架，分立于耶稣一左一右。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","耶稣说：“父啊，宽恕他们吧！因为他们不知道自己在做什么。”众人通过扔骰子的方式，分走了他的衣服。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","群众站着旁观。官长们嗤笑耶稣说：“如果他是基督，是天选之子，他救得了别人，也来救救自己吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","士兵也上前嘲笑他，拿醋酒给他喝， ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","说：“如果你是犹太人的王，救救你自己吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","在耶稣的头上有一个牌子，写着：“这是犹太人的王。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","吊在那里的一个犯人也侮辱他说：“你不是基督吗？救救你自己和我们吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","但另一个犯人没有这样做，而是和他争辩：“你也是受同样的刑罚，就不惧怕上帝吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","我们都是罪有应得。我们因为所作所为而受到相应的惩罚，但这个人并没有做什么不对的事。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","他又对耶稣说：“耶稣啊，你的王国降临之际，求你记住我。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","耶稣对他说：“我承诺你，到了那一天你就能和我一起置身乐园了。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","从大约正午直到下午三点钟，整个地区都陷入黑暗。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","太阳的光消失了，圣殿的垂缦裂成两半。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","耶稣大声呼叫：“父啊，我把自己交给你了。”话音刚落，他便气绝身亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","百夫长目睹了这一切，便开始颂赞上帝，说：“这个男人是最纯真之人！” ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","聚在旁边的群众看见所发生的事，都悲伤地离开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","但那些熟悉耶稣的人，包括从加利利跟随他而来的女人们，仍站在远处看着这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","有一个名叫约瑟的议员，为人善良诚实。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","他来自犹太地区的亚利马太城，一直都在等候上帝之国降临，从来不会进行任何阴谋诡计。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","这人去见彼拉多，恳求领走耶稣的身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","他把耶稣的身体取下来，用细麻布裹好，放在石头中凿出的坟墓里，这坟墓从来没有葬过其他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","那天是预备日，安息日即将开始， ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","从加利利一直跟随耶稣而来的妇女，也来到这里，亲眼看到了坟墓，目睹他的身躯被安葬， ");
INSERT INTO cmnfeb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","然后她们回去准备了香料和香膏。到了安息日，她们谨遵诫命休息。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","下一周第一天清晨，女人们带着准备好的香料来到耶稣的坟墓。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","但发现坟墓口的大石头已经滚到了一边， ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","她们走进去，却没有看到主耶稣的身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","正为此疑惑之际，眼前忽然出现两个人，身穿闪耀发光的衣服，站在她们旁边。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","女人们很害怕，把脸伏在地上。他们对女人说：“你们为什么要在死者中寻找一个还活着的人？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","他不在这里，而是已经复活了。你们应当记得他在加利利时说的话， ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","他说：‘人子必将被交到罪人手里，钉在十字架上，在第三日复活。’” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","她们想起了耶稣说的话， ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","于是就离开坟地，回去把这一切告诉了十一名门徒和其他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","那几名女性为：抹大拉的玛利亚，约亚拿和雅各的母亲玛利亚，以及其他跟随耶稣的妇女。她们把这些事告诉了众门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","但他们认为这是无稽之谈，根本不相信她们。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","但彼得还是跑到坟墓那里查看。他弯腰看进去，只看到了坟墓里的细麻布，于是就回去了，对这一切感到非常惊奇。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","同一天，两名门徒去往一个叫以马午斯的村子，距耶路撒冷大约十一公里。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","他们在路上谈论着所发生的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","正在交谈和争辩的时候，耶稣走上前，与他们同行。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","但他们却没有认出他。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","耶稣问到：“你们边走边聊什么呢？”他们就站住，面带愁容。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","一个名叫克利奥帕斯的门徒回答：“你造访耶路撒冷吗？关于那里发生的事情，你可能是唯一不知情的人。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","耶稣说：“什么事？”他们说：“就是拿撒勒人耶稣的事。他是先知，在上帝和众人面前显示出了伟大的奇迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","我们的祭司长和长官竟把他交了出去，把他判了死罪，钉在十字架上。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","我们一直盼望他就是救赎以色列的那个人。这些事发生到现在已经是第三天了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","但我们中有几名妇女却有了让我们惊讶的发现。她们凌晨到坟墓那里去， ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","却找不到他的身体。她们回来说看见天使显现，天使说他已经复活了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","我们又有几个人到坟墓那里去看，与妇女们所说的一样，没有看见他。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","耶稣说：“迟钝的人呐！对于先知所说的一切，你们信得太迟钝了！ ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","基督这样受迫害，后来不是迎来了他的荣耀吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","于是他从摩西和众先知说起，把所有关于他的经文解释了一遍。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","他们即将抵达要去的那个村子，耶稣表现得好像是要继续前行， ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","两名门徒特别想把他留住：“天晚了，太阳下山了，就住在这里吧。”于是耶稣就与他们住在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","吃饭的时候，他拿起饼，在感谢上帝后把饼掰开递给那两位门徒， ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","他们的眼睛此刻终于看清了，认出这是耶稣，但耶稣却从他们面前消失不见了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","他们彼此说：“一路上他和我们说话，给我们解释经文，那时候我们的思想仿佛被火烧灼。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","他们立刻站起来返回耶路撒冷。在那里遇见十一个门徒和其他聚在一起的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","这十一位门徒说：“主果然复活了，已经向西门显现。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","两个人就把在路上的事，以及掰开饼时如何认出耶稣的事情，讲述了一遍。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","他们正在交谈之际，耶稣现身站在他们当中，说：“愿你们平安。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","他们非常惊怕，以为看见了鬼。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","耶稣问到：“你们为什么惊恐？为什么心有疑惑？ ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","你们看我的手脚，就知道我是谁。摸摸我，你们就会更确认，因为鬼没有骨肉，但你们看，我有。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","说了这话，耶稣就把手脚给众人看。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","众人感到如此狂喜和惊讶，以至于仍然不敢相信这一切。耶稣说：“你们这里有什么食物吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","他们就给了他一片做好的鱼。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","他接过来，在他们面前吃了。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","然后耶稣对他们说：“我还和你们在一起时，就是这样对你们解释的：摩西律法、先知书籍和《诗篇》中记载了关于我的一切，都会成真。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","于是他打开他们的思想，让他们能够理解经书。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","他告诉他们：“经上记着‘基督将会受害，第三天死而复生。人们要奉他的名， ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","宣讲悔改与赦罪之道，从耶路撒冷开始，传遍世界各地。’ ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","你们就是这一切的见证。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","现在我要将天父所承诺的赋予你们。但你们需要在城里等候，直到获得来自天堂的力量。” ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","然后他带他们走出去，走到伯大尼附近时，抬手祝福众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","在祝福的同时离开了他们，被送上天堂。 ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","众人开始膜拜他，然后充满喜悦地回到耶路撒冷， ");
INSERT INTO cmnfeb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","此后，他们便始终都在圣殿中称颂上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","在世界之初，道即已存在。这是上帝之道，道即上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","在万物之初，这道便与上帝同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","万物皆为他所造，没有上帝就没有世上的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","他是生命之源，这生命就是人之光。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","光照亮黑暗，黑暗不能将光熄灭。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","上帝派一位叫做约翰的人前来， ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","证明和解释光，让众人通过他相信上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","约翰不是光，而是要来此为那光作见证。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","这真正的光来到世界，普照世人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","他在这个世界上，世界乃通过他创造而成，但世界却并不知晓他是谁。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","他来到自己的子民身边，但他们却不接受他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","但接受他就是相信他的人，他会赋予他们成为上帝儿女的权利。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","他们并非以人间方式诞生的儿女，不是人类欲望的结果或父亲做出的决定，而是由上帝诞生。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","道变身人类，生活在人类中间，我们可以看到他的荣光，这是天父唯一之子的荣光，满溢恩典和真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","约翰为他作见证，向民众高声呼喊：“他就是我之前所说的那个人：‘在我之后到来的人，远比我重要得多，因为他早在我之前就已存在。’” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","他生性慷慨，我们接受他的慷慨，不断获得恩典之礼。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","律法借由摩西颁布，恩典和真理却是通过耶稣基督而存在。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","从未有人见过唯一的上帝，只有距离天父最近之人，才能向我们展示何为上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","犹太人从耶路撒冷派祭司和利未人来到约翰这里，问他：“你是谁？”以下便是约翰做出的公开呈明。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","约翰明确而坦诚地说：“我不是基督。”没有一丝犹豫。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","他们问：“那么你是谁？是以利亚吗？” 他说：“不，我不是。” “是那位先知吗？” 他回答：“不是。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","他们再问：“那么你是谁？我们需要回复派我们前来之人。你认为你自己是谁？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","他说：“我就是荒野中的呼喊之声：‘修直主的路！’”他引用了以赛亚先知所说的一句话。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","这些由法利赛人派来的祭司和利未人 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","问约翰：“你既然不是基督、不是以利亚、也不是那位先知，那么你为什么施洗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","约翰回答：“我只是用水施洗，但你们中却有一个人，你们并不认识。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","他在我之后到来，我即使给他解鞋带都不配。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","约翰在约旦河施洗，这一切就发生在约旦河远处的伯大尼。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","第二天，约翰见耶稣向他走来，就说：“看，这是上帝的羔羊，他可以去除这世间的罪！ ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","这就是我说的那个人‘有一个人，在我之后到来，远比我重要的多，因为他早在我之前就已存在。’ ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","我本来不认识他。但为了让他可以显现给以色列人，我才来此用水施洗。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","约翰又给出关于耶稣的证明：“我曾看见圣灵如鸽子般从天上降落，停留在他的身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","我本来不认识他，但派我前来用水施洗的那个人对我说：‘如果你看见圣灵降下并停留在谁身上，谁就能用圣灵进行施洗。’ ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","我看到了所发生的一切，所以才能见证他就是上帝之子。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","第二天，约翰和他的两个门徒站在那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","约翰看见耶稣经过，就说：“看，这就是上帝的羔羊！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","那两个门徒听见他这番话，就开始跟随耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","耶稣转过身来，看见他们跟在身后，就问：“你们在寻找什么？”他们说：“拉比（意为‘老师’），你住在哪里？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","他说：“来看看吧。”于是他们就跟随他，看到他所住的地方。当时是下午四点，这一天剩下的时间，他们都和耶稣待在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","在听从约翰跟随耶稣的那两个人中，有一个人是西门（即彼得）的弟弟安得烈。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","他先找到自己的哥哥西门，告诉他：“我们遇见弥赛亚了！”（“弥赛亚”意为“基督。”） ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","然后他就带着西门去见耶稣。耶稣直接看着西门说：“你是约翰的儿子西门，但现在你叫做矶法。”（即“彼得。”） ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","第二天，耶稣决定去加利利。路上遇见了腓力，就对他说：“跟随我吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","腓力是伯赛大人，是安得烈和彼得的同乡。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","腓力找到拿但业，告诉他：“我们遇见了摩西在律法书上所写，众先知所记载的那个人，他就是约瑟的儿子，拿撒勒人耶稣。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","拿但业说：“拿撒勒？那里能出什么好事？”腓力说：“来看看就知道了！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","耶稣看见拿但业向他走过来，这样评价他：“看，这是一位真正的以色列人！没有任何污点和过错。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","拿但业问他：“你怎么知道我呢？”耶稣回答：“在腓力招呼你之前，我看到你站在无花果树下。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","拿但业欢呼道：“拉比，你是上帝之子，你是以色列的王！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","耶稣说：“你相信我，就是因为我说‘我看见你在无花果树下’这句话吗？你看到的会更多！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","然后耶稣说：“告诉你实话，你将看见天空开启，上帝的天使在人子处上上下下。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","两天后，耶稣的母亲参加了在加利利的迦拿举行的一场婚宴。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","耶稣和门徒们也受邀参加。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","席间的酒喝光了，耶稣的母亲对他说：“他们没有酒了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","耶稣说：“母亲，你为什么叫上我呢？我的时候还未到。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","他母亲告诉仆人：“他吩咐你什么，就做什么。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","附近有六口石罐，每口可盛 20 到 30 加仑的水，用于犹太人的洁净礼。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","耶稣吩咐仆人：“把罐子倒满水。”他们就在里面灌满水。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","耶稣又吩咐他们：“现在倒出来，送给宴席的主人。”他们就照做了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","但宴席主人不知道酒从哪里来的，只有仆人知道。当宴席主人发现所饮的不再是水，而是水变成的酒，于是就把新郎叫过来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","主人对他说：“人们都是先摆上好酒，等到客人喝够了，才摆上次等的酒，但你却把好酒留到最后。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","这是耶稣的第一件神迹，地点是加利利的迦拿行。他展露了自己的荣耀，这也让他的门徒开始相信他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","在这以后，耶稣和母亲、弟弟和门徒们去往迦百农，在那里住了几天。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","犹太人的逾越节将至，耶稣又去了耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","在圣殿中，他看到这里有卖牛、羊、鸽子的小贩，还有人坐在桌子前兑换银钱。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","于是他用绳索做了一条鞭子，将众人连羊带牛都赶出了殿外，倒掉兑换银钱之人的硬币，推翻他们的桌子。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","他命令卖鸽子的小贩：“把这些东西拿出去！不要把我父的圣殿变成巿场！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","他的门徒想起经文中所说：“我愿为你的圣殿奉献，这想法如火焰在我心中燃烧！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","几名犹太首领表示反对，问他：“你有什么权力这么做？你需要显示神迹证明你自己！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","耶稣回答：“如果拆毁这圣殿，我三天之内就能把它建造起来！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","犹太首领说：“这殿花了四十六年才建成，你三天内就能把它建好吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","但其实耶稣所说的圣殿就是他的身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","所以当耶稣死而复生，门徒们想起了他说过这话，也就相信了经文和耶稣所言的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","耶稣在耶路撒冷过逾越节期间，许多人看见他显现神迹，就纷纷相信了他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","但耶稣却不信任他们，因为他了解关于人类的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","他无需任何人告诉他什么是人性，他知道人类如何思考。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","有一位名叫尼哥德慕的法利赛人，是犹太统治委员会中的一名成员。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","一天晚上，他找到耶稣说：“拉比，我们知道你是从上帝那里来的老师，如果不是因为与上帝同在，就没有人可以像你一样显现神迹。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","耶稣回答：“说实话，只有当你重生之时，才能亲历上帝之国。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","尼哥德慕问到：“但人老了怎能重生呢？难道是回到母亲腹中再诞生一次吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","耶稣回答：“说实话，只有用水和圣灵诞下的人，才能进入上帝之国。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","身体而生即为身体，圣灵而生即为圣灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","如果我对你说‘你们必须重生。’不要感到惊讶。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","风随心所欲地吹拂，你听得到它的声音，却不知道它从何而来，又要到哪里去。对众人而言，圣灵而生的人也是如此。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","尼哥德慕说：“这怎么可能？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","耶稣说：“你是以色列有名的教师，却不明白这样的事情吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","说实话，我们只谈论自己知道之事，见证所见之事，但你们却不接受我们的见证。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","我告诉你们的只是人间之事，你们都不信，如果和你们讲述天国之事，你们又怎能信呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","除了从天而降的人子，没有人曾升入天国。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","就像摩西在旷野中举起蛇，人子也必会被高举入天， ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","让所有相信他的人获得永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","这就是上帝爱这世界的方式，上帝他把自己的独子赐给他们，让信他的人不会死去，而是获得永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","上帝派他的儿子来到人世间，不是为了谴责世人，而要让世人因他而获得救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","相信他的不会被定罪，至于不相信他的人，因为他们不相信上帝的独子，这本身就已经被谴责了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","做出这样的决定是因为光降临这个世界，但世人因作恶犯罪，不爱光反倒爱黑暗。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","作恶之人都恨光，不肯走到光下，生怕恶行暴露。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","行正道之人都愿意走进光中，显现上帝在它们身上达成的结果。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","在这之后，耶稣和门徒来到犹太地并在此住下，开始与民众在一起，为他们施洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","约翰施洗的地点位于撒冷附近的艾农，因为那里水很充足，众人纷纷前去接受他的施洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","（当时约翰尚未入狱。） ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","一天，约翰的门徒和一个犹太人在辩论洁净礼的问题。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","他们来到约翰面前，对他说：“拉比，你看，约旦河另一侧的那个人，就是你为其见证的那个人也在施洗，大家都到他那里去了！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","约翰回答：“人所获得的一切，均来自天赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","我曾说过：‘我不是基督，不过是奉命为他准备道路而已’你们对此可以证明。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","娶新娘的人是新郎！当新郎的好友站在那里，只要听到新郎的声音就会心生喜悦。我也有同样的欢喜，但现在这欢喜已经结束了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","他一定会变得更重要，我一定会变得更低微。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","从天而来一定比众人更伟大，来自大地的则属于大地，其所言也不过人间之事。只有从天而来才会比万物更伟大。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","他对在天上的所见所闻做出见证，却没有人相信他所说的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","接受他的见证，就代表你确认上帝的真实。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","上帝派来之人讲述上帝之道，因为上帝不会对圣灵做出限制。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","天父爱这人子，已经把一切都交在他的手中。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","相信人子方得永生，不信人子就无法亲历永生，而是会遭受上帝的谴责。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","耶稣意识到，法利赛人已经发现，他收门徒和施洗的人数已经超过了约翰， ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","（但进行施洗之人不是耶稣，而是他的门徒） ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","于是他离开犹太，返回加利利。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","途中需要经过撒玛利亚。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","随后他来到撒玛利亚一座名叫叙加的城邦，雅各送给他儿子约瑟的那块地就在这附近。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","雅各的井也在这里。正午时分，耶稣因为旅途疲倦，就坐在井旁。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","一个撒玛利亚妇人来此取水。耶稣对她说：“能不能给我点水喝。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","当时他的门徒都去城里买食物去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","撒玛利亚妇人对耶稣说：“你是犹太人，怎能向我这个撒玛利亚妇人要水喝呢？”因为犹太人与撒玛利亚人完全没有往来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","耶稣回答她：“但凡你意识到上帝的恩赐，知道是谁对你说‘能不能给我点水喝’，你一定会去求他了，他会赐给你生命之水。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","妇人说：“先生，你没有桶，井又深，又要到哪里获得生命之水呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","我们的先父雅各把这口井留给我们，他自己，他的子孙和他的牲畜都曾喝过井中之水，难道你比他还伟大吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","耶稣回答：“喝过这里的水，之后还是会感到口渴。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","但如果喝了我给的水，就永远不会渴。我所赐的水会在他们的体内成为流淌的泉，让他们获得永恒。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","妇人说：“先生，请赐我这样的水，让我不再口渴，无需再到这里打水！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","耶稣说：“去叫上你的丈夫，然后回到这里来。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","妇人回答：“我没有丈夫。”耶稣说：“你说你没有丈夫，的确如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","你曾有五位丈夫，现在和你生活在一起的人并不是你的丈夫。你说的是事实！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","妇人说：“先生，现在我可以看出来，你是先知。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","我们的祖先在这个山上敬拜上帝，但你们却说，必须在耶路撒冷敬拜。和我讲讲这个吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","耶稣回答：“相信我，你们膜拜天父的地点并非在这山上，也不在耶路撒冷。现在这个时刻将要来到。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","你们并不了解所膜拜的上帝，我们所膜拜的却是我们所知晓的上帝，因为救赎源自犹太人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","这样的时刻正在到来——事实上已经来到。真正膜拜天父之人，会遵循真理、在精神上的中膜拜。因为天父寻找的就是这样膜拜他的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","上帝就是灵，膜拜他的人必会在自己的灵中膜拜，遵循真理膜拜。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","妇人说：“我知道（那被称为基督的）弥赛亚即将到来，他来是为了把一切都告诉我们。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","耶稣说：“我是——现在与你说话的就是他。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","这时门徒们回来了，看到耶稣和一个妇人说话，他们感到很惊讶，但没有人问：“你在做什么？”或说：“你为什么与她说话？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","那妇人丢下自己的水罐，跑回城里，对众人说： ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“快来看看这个人，他把我所做的一切都说出来，这人会是基督吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","于是众人纷纷出城，要去看看耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","与此同时，门徒对耶稣说：“拉比，吃点东西吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","但耶稣说：“我有可以吃的东西，只是你们对此一无所知。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","门徒们询问彼此：“有人拿东西给他吃了吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","耶稣告诉他们：“遵循派我来此之人的旨意，完成他的工作，这就是我的食物。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","你们不是说‘距离收获还有四个月’？我告诉你们，睁开眼睛看看四周！田里的庄稼已经熟了，可以收获了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","收获庄稼的人能获得工资，也可以为永生储存粮食，让撒种之人和收割之人都感到快乐。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","俗话说‘你撒种，我收割’，的确如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","我派你们去收获的，并非是你们劳作的结果，别人劳苦工作，你们来收获他们工作的成果。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","由于那名妇人见证说：“他把我所做的一切都说出来”，城里就有许多撒玛利亚人开始相信耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","他们来到耶稣所在的地方，祈求能和他在一起，于是耶稣就在那里停留了两天。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","因耶稣所说的话，信他的人就更多了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","他们对那妇人说：“现在我们相信他，不再是因为你所说的，而是因为我们亲自听见了，确认他就是这世界的救世主。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","两天后，耶稣继续向加利利出发。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","耶稣自己就曾说过：“先知在自己的家乡不受尊敬。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","但耶稣抵达加利利后，那里的人都很欢迎他，因为他们曾到耶路撒冷过逾越节，见过他所做的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","耶稣又造访了加利利的迦拿，就是他把水变成酒的地方。那附近有一个叫做迦百农的城邦，一名皇家长官的儿子患上重病。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","他听说耶稣从犹太返回了加利利，就跑来求他去医治他的儿子，因为那孩子命不久矣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","耶稣对大家说：“如果看不见神迹和奇迹，你们就是不肯相信我。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","那位长官说：“主啊，趁我的孩子还没有死，求你去看看吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","耶稣告诉他：“回家吧，你儿子的病好了！” 那人相信了耶稣对他说的话，就回家了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","他在回家的路上遇到了仆人，仆人告诉他一个好消息：他的儿子活着，并且已经痊愈。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","他询问孩子痊愈的时间。他们告诉他：“昨天下午一点钟，高烧就退了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","这位父亲意识到，耶稣也是在那个时间告诉他“你儿子的病好了”，于是他自己和全家人都相信了耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","从犹太回到加利利后，这是耶稣所做的第二件神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","此后迎来了一个犹太人节日，耶稣开始向耶路撒冷出发。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","在耶路撒冷羊门附近一个的水池，希伯来语名字叫做毕士大，池边有五条游廊。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","那里躺着许多病患，有的人看不到，有的人瘸腿，有的人瘫痪， ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","其中一人已经病了三十八年。耶稣看到他便知道他病了很久，于是问他： ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","“你想要治愈吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","那病人回答：“先生，水被搅动的时候，没有人能把我放在池里，我试着到那边去，但总是给别人抢先。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","耶稣对他说：“站起来，拿着你的垫子，走吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","那人立刻痊愈，拿起垫子走动起来。 由于那天是安息日。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","犹太人就对那被治愈之人说：“今天是安息日！你拿着垫子违反了律法！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","那人回答：“将我治愈的那个人对我说：‘拿着你的垫子，你可以行走了’。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","犹太人就问：“让你拿着垫子行走的人是谁？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","那人不知道治愈他的人是谁，因为耶稣已经悄然躲进了周围的人群中。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","后来，耶稣在圣殿里看到这个男人，就对他说：“看，你已经痊愈了，所以不能再犯罪，否则会招来更大的灾祸。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","那人就跑去告诉犹太人，将他痊愈之人就是耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","因为耶稣会在安息日做这样的事情，犹太人便开始对耶稣群起而攻之。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","耶稣却对他们说：“我父现在仍然在工作，我也是。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","这话让犹太人更想杀了耶稣，因为他不但破坏安息日，还称上帝为自己的父亲，与上帝平起平坐。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","耶稣对他们解释到：“告诉你们实话，儿子凭自己什么都做不了，他只是做了曾目睹天父所做的事情，父行，子随。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","因为天父爱其儿子，于是把自己所做的一切展示给他看，还要向他展示更惊人的大事，足以让你们惊讶无比。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","因为天父让人死而复生，赋予其生命，儿子也以同样的方式，随其心意赋予死人以生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","天父不评判任何人，他将这评判的权力完全交给儿子， ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","所以，所有的人尊敬儿子一如尊敬天父。不尊敬儿子，就是不尊敬那派他前来的天父。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","告诉你实话，遵循我所言、相信派我来此的上帝，就会获得永生，不会被定罪，而是会死而复生。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","告诉你实话，那时刻将至——事实上它已经到来。死人将听见上帝之子的声音，听到即会复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","就如天父拥有赐予生命的力量，他也将这赐予生命的力量交给儿子。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","因为他是儿子，所以天父还把审判的权力赐给儿子。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","不要对此感到惊讶，因为那个时刻将至，届时所有坟墓里的死人都会听见他的声音， ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","然后再次复活。行善之人复活后会获得生命，作恶之人复活后会被定罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","我凭自己什么都做不了。我只是根据天父之言进行审判。我会进行公正的决定，因为我遵循的并非自己的意愿，而是派我前来之人的旨意。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","如果我自证，这样证明并不可信。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","但会有其他人为我作证，我知道他关于我的证言都是真实的。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","你们向约翰询问我的事情，他讲述了真相。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","我不需要人类的证明，但向你们解释这一切，只是为了我说这些事，是要你们得救。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","约翰就像一盏照耀的明灯，你们愿意在他的光中获得短暂的欢愉。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","但我所给予的证据远比约翰更强大，因为我所行之事乃奉天父之命， ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","这就是天父派我前来的证明。天父遣我来此，通过我传递讯息。你们从未听过他的声音，从未见过他的容貌， ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","也不接受他的讯息，因为你们不相信他派到这里之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","你们研究经文，认为可以通过经文获得永生，但这经文其实就证明了我！ ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","到我这里来，你们就会获得生命。可是你们并不想这么做。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","我不寻求人的认可。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","我知道你们心里并没有上帝的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","我代表天父来此，你们不接纳我，但如果有人以自己的名义前来，你们却接待他们！ ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","你们希望获得彼此的赞美，却不想从唯一真正的上帝那里获得赞美，这样你们怎么能信我呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","但不要以为我会向天父控诉你们。的确有人控诉你们，那就是你们如此信任的摩西。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","你们若信摩西，也应信我，因为他曾写到我。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","但你们不信他所写的，又怎能信我所说？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","在这之后，耶稣离开这里，去往加利利海（又名提比里亚海）的另外一边。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","由于目睹了他治愈病患的神迹，一大群人跟随他而行。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","耶稣走到山上，与门徒们坐在那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","此刻即将迎来犹太人的逾越节。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","耶稣环顾四周，看到大群人向他走来。于是他问腓力：“我们该到哪里买饼分给这些人？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","耶稣这样说只是想看看腓力的反应，其实他早知道该怎样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","腓力回答：“就算花二百银币买饼，也不够给每人分一小块。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","有个门徒是西门（彼得）的弟弟安得烈，他对耶稣说： ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“这里有个男孩，带着五块大麦饼和几条鱼。但这么多人，要怎么分才好呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","耶稣说：“让大家坐下吧。”这里的地上长着很多草，众人全部坐下，其中大约有五千名男子。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","耶稣拿起饼，感谢上帝后开始分给席地而坐的人群，然后以同样的方式分鱼，让所有人都获得了足够的食物。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","大家吃饱了之后，耶稣对门徒说：“把剩下的零碎收拾起来，免得浪费。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","门徒们开始收拾，五个大麦饼剩下的残渣，装满了十二个篮子。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","众人看见耶稣显现的神迹，就说：“这的确就是将要来到世上的先知。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","耶稣意识到群众想要推举他为王，于是便离开众人，独自退回山中。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","夜晚降临，他的门徒们下山到了海边， ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","然后上了船准备渡海去往迦百农。天色已黑，但耶稣并未来到他们身边。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","忽然海上刮起狂风，巨浪翻滚。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","门徒们摇桨前行了大概六公里，看到耶稣在海面上行走，朝着船的方向走来。这情景让他们十分害怕。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","耶稣对他们说：“别怕！是我。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","他们立刻高兴起来，把他接上船，众人立刻抵达目的地的海滩。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","第二天，站在海另一边的人群看到只有一只小船停在那里，意识到耶稣并没有和门徒一同上船，门徒离开的时候，耶稣并未同行。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","但就在主之前为众人分饼的地方，附近停着几只从提比里亚来的船。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","民众现在知道耶稣和门徒都不在那里，于是就上船去迦百农找耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","他们在对岸找到了耶稣，就问他：“拉比，你什么时候到这里来的？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","耶稣回答：“告诉你实话，你们找我，不是因为看见了神迹，而是因为你们吃到了足够的饼。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","食物必会腐烂，不要为此忧心忡忡，要关心人子赐给你们的永恒食物，它会带来永续生命，因为他已获得天父的批准。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","众人问他：“那我们该做什么才算是遵从上帝旨意呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","耶稣回答：“上帝想让你们做的，就是相信他派来之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","众人又问：“为了让我们信你，你要为我们显现什么神迹呢？你能做什么？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","我们的祖先在荒野中吃过吗哪，正如经上所记：‘他把来自天堂的食物赐给他们。’” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","耶稣回答道：“告诉你们实话，带给你们天堂食物之人并非摩西，而是我父，是他把真正的天堂食物赐给你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","因为上帝的食物就是来自那天堂、为世人赋予生命之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","众人说：“主啊，求你始终赐给我们这样的食物。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","耶稣说：“我就是生命的食物，到我这里来就不会再感到饥饿。信我之人，永远不会口渴。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","但就像我之前所说，你们虽然见了我，但还仍然不信我。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","天父赐给我之人必会走向我，我决不拒绝任何一人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","因为我从天国而降，并非来达成自己之愿，而是遵循派我前来之人的旨意。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","他赐予我的人，我一个也不丢失，在末日要将他们复活。这就是他的旨意。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","我父的旨意，就是让所有看到并相信人子之人实现永生，然后让我在末日之时鼓舞他们。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","因为耶稣说“我就是来自天堂的食物”，犹太人对此深感不满，于是议论纷纷。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","他们说：“这不是约瑟的儿子耶稣吗？我们认识他父母。现在他怎么能说‘我来自天堂’呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","耶稣说：“不必再议论了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","如果不是派我前来的天父吸引了众人，根本不会有人能到我这里，我会在末日之时鼓舞他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","先知书上记着：‘众人都必受上帝的教导。’聆听天父、遵其教诲的人，必会到我这里来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","从未有任何人见过天父，只有来自上帝的那个人才见过。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","告诉你们实话，信上帝，得永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","我就是生命的食物， ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","你们的祖先在旷野吃过吗哪，但仍然会死去。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","但这是从天上而降的食物，吃下它就不会死。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","我就是来自天堂、赋予生命的食物，吃下这食物就能获得永生。这食物即我的身体，为了让世人获得生命而赐。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","随后犹太人开始进行激烈的争论。他们不解的是：“这个人怎会把他的肉身给我们吃？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","耶稣告诉他们：“说实话，除非吃人子的肉、喝人子的血，否则就无法获得真正的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","食我肉、饮我血才能永生，我会在末日让他们复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","因为我的肉是真正的食物，我的血是真正的饮品。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","只有食我肉、饮我血之人，我才能与他们彼此同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","正如赐予生命的天父派我前来，我也因天父而活，食我肉身者即可因我而活。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","这就是来自天堂的食物，你们祖先吃下吗哪后仍然死了，但吃下天堂的食物必会永生。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","这番话，就是耶稣在迦百农会堂中对众人的教导。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","他的很多门徒听完这番话后说：“这番话难以接受！谁会真正遵循它？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","耶稣看到门徒对这番话的不解，于是便问：“这话让你们感觉受到冒犯吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","如果你们能目睹人子升入他原本所在的地方，又怎样呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","是灵魂赋予人生命，绝非肉体。我对你们所说的就是灵，是生命！ ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","但你们中却有人不信。”（耶稣从最开始就知道谁不信他，谁会背叛他）。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","耶稣补充道：“所以我要说的是，是他让这成为可能，否则没有人能到我这里来。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","此后，他的门徒中有许多人都放弃了，不再追随于他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","于是耶稣对十二门徒说：“你们呢？你们也想离去吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","西门（彼得）回答：“主啊，我们还能追随谁呢？你才是讲述永生之道的那个人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","我们相信你，我们确信你就是上帝的圣者。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","耶稣说：“我不是选出你们十二个人吗？但你们中间有一个是魔鬼。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","（耶稣所指为加略人西门的儿子犹大。虽然他是十二门徒之一，但后来背叛了耶稣。） ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","此后，耶稣便在加利利游历。他不想住在犹太，因为犹太人想要他死。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","但由于犹太人的住棚节即将到来， ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","耶稣的弟弟们对他说：“你应当离开这里去犹太，让你的追随者能够看到你可以显现的神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","想成名的人不会藏起来。既然你可显现神迹，就应该向世人展示自己！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","即使他的弟弟们也不相信他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","耶稣就对他们说：“我的时间还没有到，但你们可以去任何地方，因为对你们而言，任何时间都可以。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","世人没有理由恨你们，但却憎恨我，因为我表明他们的行为是邪恶的。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","你们去过节吧！我就不去这个节日了，因为我的时机还没到，还不成熟。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","说完这番话，他继续留在加利利。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","他的弟弟们去过节以后，耶稣也去了，但没有公开，而是躲开了众人的视线。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","在节日期间，犹太人的首领们四处寻找耶稣，不断问众人：“他在哪儿？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","人群中有很多人开始谈论耶稣，有的说：“他是好人。”有的说：“不，他就是个骗子。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","但没有人敢公开这样说，怕犹太人首领会对付他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","逾越节过半，耶稣来到圣殿，开始教导众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","犹太人首领对此颇感意外，于是询问道：“这人没有学过教育，为什么如此有学识？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","耶稣回答：“我的学识并非源于自己，而是来自派我到这里的那个人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","你若选择遵循上帝的意愿，就会知道我这学识是出于上帝，还是仅在讲述我个人的想法。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","如果你讲述的是自己的想法，就是想要荣耀自己。但如果你只是为了让派你前来之人获得荣耀，这才是真诚，才不会存在谎言。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","摩西给你们带来了律法，是不是？但你们没有一个人遵行这律法。你们为什么想要杀我？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","众人回答：“你是魔鬼附体！没人想要杀你！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","耶稣回答：“我显现了一个神迹，你们为止感到震惊。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","摩西告诉你们要进行割礼——其实这并非源自摩西，而是源自他之前的祖先。所以你们在安息日也会进行割礼。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","如果为了遵循摩西的律法，你们在安息日举行割礼，那么我在安息日让一个人痊愈，为什么会让你们怒火中烧呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","不要因外貌而判断别人，要做出正确的决定。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","这时，有几个来自耶路撒冷的人开始思量：“这就是他们想要杀的人吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","但你看他说话如此坦诚，他们却保持沉默，你觉得长官们真的相信这就是基督吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","那是不可能的，我们知道他从哪里来，而基督到来之际，没有人知道他从何而来。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","此刻耶稣正在殿里教导众人，他高声说：“你们以为认识我，知道我从何而来。但我来此并非出于我的意愿，那派我来此的人真实存在，你们不认识他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","但我认识他，因为我从他那里而来，也是受他派遣。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","于是犹太长官想要逮捕他，但没有人下手，因为他的时刻尚未到来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","但民众中有许多人相信他。他们说：“如果基督出现，难道会比这个人显现更多神迹吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","法利赛人听到民众低声议论耶稣，他们和祭司长就派差役去逮捕耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","这时候耶稣对众人说：“我和你们在一起的时间不多了，但我要回到派我前来之人那里去。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","你们会寻找我，但找不到，我将去的地方，你们无法进去。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","犹太人彼此谈论：“这人要去哪个我们找不到的地方呢？难道他去的地方在异教徒那里吗？他想去教导异教徒？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","他说‘你们会寻找我，但找不到。我将去的地方，你们无法进去’这话，是什么意思？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","在节日的最后一天、也是最隆重的那一天，耶稣站立高呼：“如果你渴了，到我这里来解渴！ ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","正如经文所说，信我者，身体将流淌赋予生命的溪流。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","他所指的是：相信他的人之后会获得圣灵，但因为耶稣尚未获得荣耀，所以圣灵还没有降临。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","人群中有人听到这番话，就说：“他真的是先知！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","有人说：“他是基督！”还有人说：“基督怎么能来自加利利呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","经文不是说基督是大卫的后裔，来自大卫的家乡伯利恒吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","众人因对他的看法完全不同而争论起来，。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","有人想逮捕耶稣，但没有人这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","卫兵随后回到祭司长和法利赛人那里。他们问卫兵：“为什么没有把他带来？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","卫兵回答：“从来没有人像他这样讲话。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","法利赛人说：“连你们也上当了？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","长官或法利赛人中有谁信他吗？没有！ ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","至于这群完全不懂律法之人，他们就是被咒诅的一群人！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","他们当中有一人叫做尼哥德慕，以前曾经去见过耶稣。他对他们说： ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“难道不该先审讯一下吗？查明他到底做了什么，否则我们的律法怎能给他定罪？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","他们回答：“那么你也是从加利利来的吗？去看看经文吧，你就知道先知并非来自加利利。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","然后众人都回家了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","但耶稣开始去往橄榄山。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","黎明时分，他返回圣殿，坐下来教导身边围坐的众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","宗教老师和法利赛人带来一个妇人，她在通奸之时被抓住，叫她站在众人面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","他们就对耶稣说：“老师，这妇人在通奸的时候被抓住。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","摩西在律法上的裁决是：我们应该用石头将这样的妇人打死，你觉得呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","他们这样说，其实是想找到耶稣言语中的把柄来控告他。但耶稣却弯下身，用手指在地上写字。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","他们不停地要求耶稣给出回答。耶稣直起身对他们说：“你们中谁没有罪，谁就可以先拿起石头打她。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","然后他又弯下身在地上写字。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","听到这番话，控诉者中从最年长的那个人开始一个接一个地离开了，，最后人群中只留下耶稣和站在原地的那位妇人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","耶稣站直身问她：“他们哪儿去了？没有人留下来定你的罪吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","她说：“先生，没有人。” 耶稣说：“我也不会定你的罪。走吧，不要再犯罪了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","耶稣又对众人说：“我就是这世界的光，如果你跟随我，就不会走进黑暗，因为你将拥有赐予你生命的光。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","法利赛人反驳：“你不能为自己作证！你所说的无法证明任何事！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","耶稣告诉他们：“即使我为自己作证，我的证言仍是真实。因为我知道我从哪里来，要到哪里去，但你们却不知道我从哪里来，要到哪里去。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","你们以人类最常见的方式做出判断，但我不会做出评判。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","即使我要做出评判，我的判断也是正确的，因为并非一个人在做这件事情，派我前来的天父与我同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","你们的律法上也写着：‘两个人的见证才有效。’ ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","我为自己作证，派我前来的天父也为我作证。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","他们问耶稣：“你的父在哪里？”耶稣回答：“你们不认识我或我的天父，如果你们认识我，就会认识我父。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","耶稣是在圣殿银库附近教导众人时，做出了这番解释。但没有人逮捕他，因为他的时候尚未到来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","耶稣又对他们说：“我要走了，你们将会寻找我，但你们会因自己的罪而死去，我要去的地方，你们无法抵达。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","犹太人思索着，然后大声说：“他要自杀吗？他说‘我要去的地方，你们无法抵达。’是这个意思吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","耶稣告诉他们：“你们来自人间，我来自天上。你们属于这个世界，我却不属于这世界。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","所以我对你们说，你们会因自己的罪而死去。因为如果你们不相信我即‘我是’，你们就会因自己的罪而死去。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","他们又问：“那你到底是谁？” 耶稣回答：“我从一开始就告诉你们的了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","关于你们，我有很多可以说的，我可以对你们大加谴责，但派我来此的天父讲述的却是真相，我在这个世界对你们所说的，就是从他那里听来的。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","他们不明白耶稣所说的就是天父。于是耶稣解释说： ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","“如果你们看到人子被高举，必定知道我即‘我是’，知道我的所作所为并非源于自己，我的言语都是遵循天父的教导。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","那派我来此之人与我同在，他未弃我，因为我的所行皆令其喜悦。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","很多人在听到耶稣的这番话后，便相信了他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","于是耶稣对信他的犹太人说：“你们若遵循我的道，就真正是我的门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","你们将知晓真理，真理会让你们自由。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","众人问到：“我们是亚伯拉罕的后裔，从未被奴役过，你说我们会自由，又是何意呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","耶稣答道：“说实话，每个罪人都是罪的奴隶。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","奴隶在家庭中无法拥有永远的地位，只有儿子才是家庭中永远的成员。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","当上帝之子让你自由，你就真正获得自由。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","我知道你们是亚伯拉罕的后裔，但你们不愿接收我的道，所以想杀我。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","我所说的一切皆为我父显示给我的，但你们只是遵循你们的父亲行事。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","他们说：“亚伯拉罕就是我们的父亲。” 耶稣说：“你们若真是亚伯拉罕的子孙，就必做亚伯拉罕所行之事。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","但现在，只因我讲述了从上帝那里听见的真理，你们便想杀我，亚伯拉罕绝不会这么做。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","你们只是遵循你们的父亲。” 他们回答：“我们不是非法子孙，上帝是我们唯一的父亲。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","耶稣说：“如果上帝真是你们的父亲，你们就该爱我，因我来自上帝，现在我就在这里。这不是我的决定，而是派我前来之人的决定。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","为什么你们无法理解我的话？因为你们不肯听我所传递的讯息！ ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","你们的父是魔鬼，你们也喜欢遵循其魔鬼的欲望行事。他从一开始就是杀人犯，不讲真理，因他心里没有真理。当他说谎时便显露了他的本性，因为他就是一个说谎者，是谎言之父。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","我说的都是真理，你们却因此而不相信我！ ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","你们中有谁能指证我有罪？我既然讲真理，你们为什么不信我？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","归属于上帝之人就会聆听上帝之语。你们不听，因为你们并不归属于上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","犹太人对耶稣说：“我们说你是魔鬼附体的撒玛利亚人，难道不对吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","耶稣回答：“我不是魔鬼附体。我尊敬我父，你们却侮辱我。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","我来此并非追求自己的荣耀，但确有一人为我寻求荣耀，来此对人做出审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","告诉你们实话，遵守我的教导将永远不会死去。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","犹太人对他说：“现在我们知道你的确是魔鬼附身。亚伯拉罕死了，先知们也死了，你居然还说‘遵守我的教导将永远不会死去’， ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","难道你比我们的祖先亚伯拉罕还伟大吗？他死了，先知们也死了，你把自己当做什么人呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","耶稣回答：“如果我只获得自己的荣耀，那荣耀就不值一提；让我荣耀之人是上帝，正如你们所说的‘他就是上帝’。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","你们不认识他，我却认识。如果我说不认识他，就会像你们一样说谎。但我的确认识他，也遵守他的道。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","你们的祖先亚伯拉罕，因为期待我降临的日子而充满喜悦。当看到指示便感到如此幸福。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","犹太人回答：“你还不到五十岁，怎会见过亚伯拉罕呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","耶稣说：“告诉你们实话，亚伯拉罕出生以前，我就已存在。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","于是他们捡起石头要去砸他。耶稣躲开他们，离开了圣殿。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","耶稣在路上行走的时候，看见一个与生俱来的盲人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","门徒问他：“拉比，为什么这人生下来就看不到？是他犯了什么罪吗，还是他的父母？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","耶稣回答：“不是他或他的父母犯了罪，而是要在他身上显示上帝的能力。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","在白天的时候，我们要做好自己的工作，这是派我前来此处之人让我做的。黑夜一到，就没有人能工作了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","只要我还在这世界，我就是这世界的光。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","说了这话，耶稣在地上吐了一口唾沫，将唾沫和泥混在一起，抹在瞎子的眼睛上， ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","然后对他说：“去西罗亚池洗一洗吧。”（西罗亚意为“派你去。”）。那人走开了，在水池中洗了洗，就看见了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","他的邻居和其他知道他是个乞丐的人说：“这不是那个曾坐着讨饭的人吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","有人说是他。其他人则说：“不是他，只是有点像而已。”但这个男人不断地说：“就是我！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","于是他们问他：“你怎么能看到的？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","他回答：“一个叫耶稣的人和了一点泥，抹在我的眼上，对我说：‘去西罗亚池洗一洗吧。’我就去洗了洗，然后就看见了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","众人问：“他在哪儿呢？” 他说：“我不知道。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","他们就把这位曾经的盲人带到法利赛人那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","耶稣和泥让他重见光明的那一天，正是安息日。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","法利赛人又问他是怎样看到的。他回答：“耶稣把泥抹在我的眼上，我洗了洗就看见了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","有几个法利赛人说：“做这件事的人不会来自上帝，因为他不守安息日的规矩。”但也有人质疑：“一个罪人怎能显现这样的神迹呢？”众人分成了两派意见。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","他们又对那重见光明的男人说：“既然他让你的眼睛能看到，你认为他是什么人？” 他说：“他肯定是个先知。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","犹太人的首领们仍拒绝相信他曾经是个盲人，只是现在才能看见，于是就把他的父母叫来， ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","他们问到：“这就是你们说生下来就看不见的儿子吗？现在他怎么又能看见呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","他的父母回答：“我们知道这就是我们的儿子，生下来就看不见。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","现在他为什么又能看到了，谁治好了他的眼睛，我们也不明白为什么。干嘛不问问他呢，他已经长大成人，可以表达自己的想法了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","他父母这样说，只是因为害怕犹太人首领。这些犹太人首领早就宣布，谁说耶稣就是基督，就会被赶出会堂。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","所以他的父母才说：“他已经长大成人，你们问他吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","于是法利赛人再次把这位曾经的盲人叫来，对他说：“荣耀应该归于上帝！我们知道这人是个罪人。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","那人回答：“他是不是罪人，我不知道。我只知道一件事：我本来看不到，现在能看见了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","他们又问：“他向你做了什么呢？怎么治好你的眼睛的？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","他回答：“我已经告诉你们了，你们没听到吗？现在怎么又想听了？你们也想成为他的门徒吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","他们开始斥责他，说：“你才是他的门徒，我们是摩西的门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","我们知道上帝曾对摩西说过什么。但这个人，我们甚至不知道他从何而来。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","那人答道：“真不可思议，他治好了我的眼睛，你们竟然不知道他从何而来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","我们都知道，上帝从不听罪人的祈求，只听那敬畏上帝、遵行他旨意的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","自古以来，从来就没听过有人生来就看不到，但有人可以让他们重见光明。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","这人如果不是来自上帝，就什么都做不了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","犹太人说：“你生下来就是个彻底的罪人，居然来教训我们！”就把他赶出会堂。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","耶稣听说他们把他赶了出来，于是就去找到这个男人，问他：“你相信人子吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","那男人说：“先生，告诉我他是谁，我会全信他。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","耶稣说：“你已经见过他了，他此刻正在和你说话。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","那人说：“主啊，我相信你。”于是向耶稣跪拜。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","耶稣对他说：“我到这世上就是为了带来评判，让盲人重见光明，让看得到的人成为盲人。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","耶稣身边的几名法利赛人听了这话，就说：“难道我们也看不到吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","耶稣回答：“如果你们看不到，就没有罪了，但现在你们说自己能看见，所以你们仍然有罪。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“告诉你们实话，如果一个人进羊圈没走门，而是用其他方式爬进去，那此人非贼即盗。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","从门进去的才是羊群的牧羊人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","看门人给他开门，羊能听到他的声音，他呼唤着每一只羊的名字，把它们带出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","他把自己的羊领出来以后，走在前面，羊跟着他，因为认得他的声音。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","羊群决不跟随陌生人，因为不认得陌生人的声音，它们会从他们那里跑开。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","对于耶稣所讲的这个比喻，大家并不理解它的含义。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","于是耶稣解释道：“说实话，我就是羊的门。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","在我之前进入的人非贼即盗，羊也不听从他们的。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","我就是门，如果有人穿我而入，就必定得救，还可以来去自由，可以找到自己需要的食物。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","贼来了，但他的目的是偷窃、杀害和毁坏。我来了，是为了让你们获得生命，更完整丰饶的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","我就是那善良的牧羊人，愿意为羊放弃自己的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","拿着工钱照看羊群的，不是牧羊人，羊不是他自己的，一见狼来，他就会丢下羊逃跑，狼就能攻击羊群，把羊群驱散了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","因为这人只是花钱雇来的工人，根本不在乎羊群。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","我就是那善良的牧羊人。我知道谁属于我，他们也认识我， ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","就像天父认识我，我也认识天父一样。我愿意为羊放弃自己的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","我还有其他的羊，但不在这个羊圈里，我必须把它们领来，它们将听到我的声音，聚成一群，只有一个牧羊人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","天父爱我，因为我愿意舍弃生命，只为重获生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","没有人能夺走我的生命，我自己选择舍弃。我有权舍弃生命，也有权把它夺回，这是天父给我的命令。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","听完这番话，犹太人再次分成了两派意见。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","很多人会说：“他是魔鬼附体，发疯了，为什么要听他的呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","还有人说：“魔鬼附体之人不可能说出这样的话。魔鬼怎能让盲人重见光明？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","在冬季的耶路撒冷，献殿节到了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","耶稣走在圣殿的所罗门廊中。犹太人围着他，向他提问： ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","“你还要让我们疑惑到什么时候？如果你是基督，就直接告诉我们吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","耶稣对他们说：“我已经告诉你们了，你们却不相信。我以天父之名所显现的奇迹，已经证明了我是谁。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","只是你们不信，因为你们不是我的羊。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","我的羊能认出我的声音，我也认识他们，他们会追随我。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","我赐给他们永生，他们永不灭亡，没有人能把他们从我手里夺去。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","把他们赐给我的天父比任何人都伟大，也没有人能把他们从他手中夺去。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","我与天父本为一体。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","犹太人再次拿起石头要打他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","耶稣对他们说：“我向你们展示从天父那里获得的善良行为，你们用石头砸我又是为何事？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","犹太人回答：“我们打你不是因为善事，而是因为你说了忤逆上帝之语；你不过凡人一个，竟敢自称上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","耶稣回答：“你们的律法上不是写着‘我说，你们是上帝’吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","他称那些人为‘上帝’，其实是上帝将道传授给他们，经文不能更改。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","天父特别选择了一人派到人间，你们却因为他说‘我是上帝之子’，就认为他忤逆上帝，这又是为什么？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","我若不做天父之事，那就不必信我。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","如果我正在做天父之事，你们即使是不相信我，但也应该相信这些事，因为这就是我所行之事的证据。这会让你们知道和理解天父与我同在，我与天父同在。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","他们又想要逮捕耶稣，但他却逃脱了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","耶稣穿过约旦河往回走，来到约翰开始施洗的地方，在这里住下。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","许多人都来到他那里，说：“约翰没有显现任何神迹，但约翰关于这个人的描述都成真了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","很多人在那里相信了耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","在伯大尼有一位名叫拉撒路的病人，与他的姐妹玛利亚和马大住在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","这就是那位后来在主头上抹香膏、用头发擦干主双脚的玛利亚，患病的拉撒路是她的兄弟。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","姐妹二人让其他人向耶稣捎去一个口信：“主啊，你的好朋友病了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","耶稣听见这个消息就说：“这病不至于死，通过他的病将显示上帝的荣光，让上帝之子获得荣耀。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","尽管耶稣喜爱马大、玛利亚和拉撒路， ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","但听说拉撒路病了，他没有马上过去，而是继续在当地住了两天。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","然后他对门徒说：“我们回到犹太去吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","门徒对他说：“拉比，几天前犹太人还想用石头打你，你真的想要现在就回去吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","耶稣回答：“白昼不是有十二小时吗？在白昼行走不会跌倒，因为这世界上有光。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","若在夜间行走就会跌倒，因为你没有光。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","耶稣说完这番话，继续说：“我们的朋友拉撒路睡着了，但我要去那里唤醒他！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","门徒们说：“主啊，既然他睡了，就会好过来的。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","其实耶稣在暗指拉撒路已死，门徒却以为他真的睡着了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","于是，耶稣明确地告诉他们：“拉撒路死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","因为你们的原因，我很高兴我当时不在那里，因为现在你们就可以相信我了。现在我们去看看他吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","孪生兄弟之一多马对其他门徒说：“我们也一起去吧，我们可以与他一同赴死。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","耶稣到了伯大尼，得知拉撒路四天前被安葬在坟墓里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","伯大尼与耶路撒冷相距约有三公里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","有许多犹太人来到马大和玛利亚那里，为拉撒路的死表示哀悼。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","马大听见耶稣来了，就去迎接他，玛利亚却仍然呆在家里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","马大对耶稣说：“主啊，如果你早在这里，我的兄弟就不会死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","就是现在，我确定无论你向上帝求什么，上帝必赐给你。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","耶稣对她说：“你的兄弟将会复活。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","马大回答：“我知道在末日重生之际，他必会再次站立起来。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","耶稣说：“我就是复活，我就是生命，信我之人可死而再次站立起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","所有活着又相信我之人，必定永远不死，你信这话吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","她说：“是的，主啊，我相信你就是基督，是上帝之子，是众人期盼降临这世界之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","马大说罢，就回去叫她的姐妹玛利亚，偷偷地说：“老师来了，他要见你。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","玛利亚听言急忙站起来去见耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","当时耶稣还没有进入村子，仍然站在马大与他相见的地点。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","有些犹太人在房子里安慰玛利亚，见她匆忙起身出门，于是就跟着她，以为她要到坟墓那边痛哭。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","玛利亚来到耶稣面前，见到就立刻伏倒在他脚前说：“主啊，如果你当时在这里，我的兄弟就不会死了！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","见到她和跟来的犹太人在面前哭泣，耶稣心中万分悲伤难过。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","他问到：“你们把他安葬在哪里？” 他们回答说：“主啊，快来看吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","耶稣也流下了眼泪。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","犹太人说：“你看，他多么爱这个人。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","但也有人说：“他既然能让盲人重见光明，难道不能让拉撒路不要死去吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","耶稣分外难过地来到坟墓前面，这是一个洞穴，洞口堵着一块石头。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","耶稣吩咐众人：“把这块石头挪开。” 但死者的姐妹马大说：“主啊，他已经死去四天了，味道一定特别难闻。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","耶稣说：“还记得我对你说过的吗？如果你相信我，就会看到上帝的荣耀。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","于是他们挪开石头。耶稣举目望天，说：“父啊，感谢你聆听我， ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","我知道你总是在聆听我，但我说这番话是为了站在这里的民众，为了让他们相信，是你派我而来。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","说罢，耶稣大喊：“拉撒路，出来吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","那死去的人便走出来，手脚都缠着布，脸上也裹着布。 耶稣说：“解开布吧，放他自由！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","到玛利亚那里奔丧的犹太人看到耶稣的所为，于是信了他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","但他们中间有些人还是去了法利赛人那里，讲述了耶稣的所作所为。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","于是祭司长和法利赛人召开公议会，说：“这个人显现了许多神迹，我们该怎么办？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","如果我们任由他继续，所有人都会信他，罗马人就会过来摧毁我们的圣殿，消灭我们的民族。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","该亚法是当年的大祭司，他说：“你们什么都不知道， ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","难道看不出来吗？让一个人代替民众而死，免得整个民族灭亡，这样做对你们更好。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","他这样说并非为了自己着想，而是因为他是那年的大祭司，所以预言耶稣要替这个民族死。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","这样做不只是为了犹太民族，还是为了散落各地的上帝之子，将他们聚在一起成为一体。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","从那天起，他们就开始密谋如何杀害耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","所以耶稣不再在犹太人中间公开活动，而是去了荒漠附近一个名叫以法莲的城市，与门徒一起住在那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","犹太人的逾越节快到了，许多人在节前从四乡八里来到耶路撒冷洁净自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","他们到处寻找耶稣，站在圣殿里彼此说：“你们觉得呢？他会来过节吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","祭司长和法利赛人早已下了命令：任何人知道耶稣在哪里，都应来此举报，他们将逮捕他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","逾越节前六天，耶稣去了伯大尼，也就是拉撒路起死回生的那个地方。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","为了感谢耶稣，那里安排了一场宴席。马大帮着准备食物，拉撒路在桌旁与耶稣和其他人共同用餐。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","玛利亚拿了一品脱纯正的哪哒香膏，抹在耶稣的脚上，然后用自己的头发擦拭，房间里散发出香膏的气息。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","但耶稣的一名门徒，也就是将要出卖他的加略人犹大说： ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“为什么不把这香膏卖了接济穷人，它值三百银币呢。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","他这样说并不是因为他关心穷人，只是因为他是个贼，负责管理门徒们的金钱，经常从里面拿走一些占为己有。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","耶稣就说：“别批评她。她这样做是为我的葬礼做准备。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","你们总是和穷人们在一起，却不总是与我在一起。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","一大群犹太人发现耶稣来到那里，于是也过来了，但他们不只是想看到耶稣，也是要看看耶稣让其死而复生的拉撒路。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","于是祭司长想把拉撒路也杀掉， ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","因为有许多犹太人因为拉撒路的缘故而不再追随犹太首领，而是相信了耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","第二天，来到这里过逾越节的民众听说耶稣要来耶路撒冷， ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","于是他们折下棕榈树枝去迎接他，欢呼说：“和散那，祝福奉主之名来此的以色列王！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","耶稣找到一头小驴，骑在上面，正如经书所记： ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“锡安的女儿啊，不要害怕。看，你们的王骑着小驴到来。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","这时候门徒并不理解这一切意味着什么，直到耶稣获得荣耀之后，他们才意识到先知曾预言了这一切，而且说的正是耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","人群中有很多人见过耶稣如何将拉撒路从坟墓中唤醒，让他复活。他们纷纷讲述着这个故事。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","所以才有这么多人到这里见耶稣，因为他们听说了这个奇迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","法利赛人彼此议论：“看，你们什么都做不了，大家都去跟随他了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","有些希腊人也来到逾越节做礼拜。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","他们来到加利利的伯赛大人腓力那里，说：“先生，我们想见耶稣。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","腓力去告诉安得烈，然后两人一起去告诉耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","耶稣对他们说：“人子获得荣耀的时刻已经来到。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","告诉你们实话吧，麦子种到泥土中才会死去，否则始终都只是一粒麦子而已。但如果它死了, 就会结出很多麦粒。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","如果你们爱惜自己的生命，就会失去生命。但如果你们不爱这世上的生命，就会获得永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","如果你们愿意服侍我，就要跟从我，我在哪里，服务我的人也会在哪里，我父必会让服侍我的人获得荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","我现在心里难过，该说些什么呢？说‘父啊，拯救我不要遭受那即将到来的苦难’？但我正是为此而来，我必须经历这样的痛苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","父啊，请显现你的荣耀吧。” 天堂传来一个声音，说：“我显现这荣耀，还将再次显现。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","站在那里的民众听到这一切，有人说这是雷声，有人说这是天使对他说话。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","耶稣告诉他们：“这声音不是为我而发，而是为了你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","现在就是这世界接受审判之刻，这世界的王将被赶走。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","但当我被高举，从这大地上升起，就会吸引所有生灵跟从我。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","（他这番话表明了他将以何种方式死去。） ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","于是群众对他说：“律法告诉我们，基督将永存，你怎么说‘人子将被从十字架上高举’呢？人子是谁？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","耶稣回答：“光还会在这里停留一段时间。你们应当趁着有光的时候行走，免得黑暗追上你们。行走在黑暗中，你就无法知道自己去向哪里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","趁着还有光，你们应该相信他，这样你们就会成为光明的儿女。”说罢，耶稣就离开并躲开了他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","虽然耶稣在他们面前显现了许多神迹，但是他们仍然不信他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","这也应验了以赛亚先知所说：“主啊，我们所说的有谁会信呢？主的力量要向谁显露呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","他们无法相信他，所以也验证了以赛亚的另一番预言： ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“他蒙蔽了他们的眼，让他们的心变得迟钝，这会让他们看不到也不会思考，他们也不会跟随我。但如果他们这样做，我就会治愈他们。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","以赛亚见过耶稣的荣耀，所以这番话就是在说耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","尽管很多首领其实已经相信了耶稣，但他们不敢公开承认这一点，怕被法利赛人赶出会堂。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","他们喜欢人的崇拜，甚至超过来自上帝的肯定。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","耶稣大声说：“如果你相信我，那你所相信的不只是我，还有派我来此的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","看到我，就是看见那派我来的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","我如光来此照亮这世界，所以信我者就不会生活在黑暗之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","即使你听到我的言语但不遵守，我也不会评判你，因为我来此并非评判世人，而是要拯救世人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","但如果你抛弃我又不接受我所言，最终必将像我所说的那样在末世受到审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","因为我所说并非为我自己，而是派我来此的天父下的命令，是他指引我说什么，如何说。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","我知道他告诉我通过道带给这世界永生。所以我所说的，正是天父吩咐要我说的。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","逾越节前一天，耶稣知道自己时候已到，将会离开这世界，回到天父那里去。他爱这世上追随他的人，现在他将显示对他们所有的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","吃晚饭的时候，魔鬼已经把出卖耶稣的念头植入西门的儿子——加略人犹大的心里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","耶稣知道天父的权力掌控了一切，他知道自己来自上帝，也将回到上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","于是他站起身，脱去外衣，在腰上扎了一条毛巾。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","然后倒了一盆水，开始给门徒们洗脚，用腰上的毛巾擦干。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","轮到彼得时，他问到：“主啊，你要给我洗脚吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","耶稣回答：“你现在并不知道我在为你做什么，但总有一天会明白。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","彼得说：“不！不要洗我的脚！”耶稣回答：“如果我不为你洗脚，你和我就没有任何关系了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","彼得说：“主啊，那就不要只是洗我的脚，连我的手和头也都洗吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","耶稣回答：“洗过澡的人只要洗脚就能获得全身的洁净。你们是洁净的，但并非人人如此。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","因为耶稣知道谁出卖了他，所以他说“但并非人人如此。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","耶稣洗完了门徒们的脚，穿上外衣回到座位上坐下，对他们说：“你们理解我为你们所做的一切吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","你们称呼我‘老师’和‘主’，这样称呼没错，我本来就是。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","如果作为主和你们的老师，仍然为你们洗脚，你们也应当为彼此洗脚。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","我为你们做出榜样，希望你们也能做我所做的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","实话实说，仆人不能高于主人，奉命行事之人不能高过派遣他之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","既然你们已经理解了这些事，付诸行动就会有福报。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","但我并不是说你们所有人，我知道自己选择的那些人，但是经文中说：‘与我一起用餐的人会背叛我’，这句话将会应验。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","我在事情还没有发生之前告诉你们，因为当它发生的时候，你们就会相信我是谁。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","告诉你们实话，迎接我所派遣的人，就是迎接我，迎接我，就是迎接派我来此之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","耶稣说完这番话，深感难过，于是大声说：“告诉你们实话，你们中间有一个人要出卖我。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","门徒们看着彼此，不知道他所指是谁。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","耶稣所爱的那名门徒坐在他身边，侧身靠近耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","彼得向他示意，让他询问耶稣这个叛徒到底是谁。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","于是那个门徒倾斜身体贴近耶稣，问到：“主啊，是谁呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","耶稣回答：“我蘸一小块饼，把它给谁就是那个人了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","于是他蘸了一小块饼，递给加略人西门的儿子犹大。犹大接过饼以后，撒旦就进入他的身体。耶稣对他说：“你想做什么，快去做吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","在座众人都不知道耶稣为什么这样对犹大说话。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","由于犹大负责管钱，所以有人以为耶稣是叫他去购买逾越节所需用品，或是拿点东西去接济穷人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","犹大吃了饼后立刻就离开，走进了一片黑夜。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","他离开后，耶稣就说：“现在人子已获得荣耀，上帝也通过人子获得荣耀， ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","上帝如果通过人子获得荣耀，也将会让人子获得荣耀，并且会立刻这么做。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","我的孩子们，我与你们在一起的时候不多了。你们会寻找我，但我要把对犹太人所说的告诉你们：‘我去的地方，你们不能去。’ ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","我现在要给你们一个新命令：要爱彼此，要像我爱你们的方式爱彼此。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","如果你们爱彼此，你就是向所有人证明，你们是我的门徒。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","彼得对耶稣说：“主啊，你要去哪里？”耶稣回答：“我去的地方，你现在无法跟随，但今后会跟上我。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","彼得说：“主啊，为什么我现在不能跟随你？为了你，要我放弃生命也可以！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","耶稣说：“你愿意为我放弃生命吗？告诉你实话，鸡叫之前，你一定会有三次不认我。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“别紧张，相信上帝，也要相信我。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","在天父的家里有许多房间，如果没有，我自会告诉你们，我要去为你们准备一个地方。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","我离开后，准备好了地方，会再来带你们回去，让你们也能到那里和我在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","你们知道我要走的那条路。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","多马说：“主啊，我们不知道你要去的地方，又怎么知道那条路呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","耶稣对他说：“我就是那条路，是真理，是生命，只有通过我才能去往天父那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","如果你们认识我，就必认识我父，从今以后，你们便认识他了，并且看见了他。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","腓力说：“主啊，请向我们显现天父吧，我们就会信服。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","耶稣说：“腓力，我跟你们在一起这么久了，你还不知道我吗？看见我便是看见天父，你怎么还说‘请向我们显现天父’呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","难道你不信我与天父彼此一体吗？我对你们所说的并非源于我，而是我体内的天父自己的言语。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","当我说我与天父一体，要相信我，至少也要因为我所做的一切而相信我，那些就是证明。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","告诉你们实话，信我之人也将像我一样做，并且会更伟大，因为我要去天父那里了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","无论你们以我的名义求什么，天父必会通过人子将其变为现实。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","你们以我的名义向我求什么，我一定会成全。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","如果你们爱我，就要遵守我的命令。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","我会请求父，他会赐给你们另一个保惠师， ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","这是真理的圣灵，他与你生活在一起，也会与你同在。这世界不会接受他，因为看不见他也不认识他。你们却认识他，因为他与你们生活在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","我不会丢下你们，让你们变成孤儿，我要再次回到你们身边。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","世人很快就不会再看见我，你们却能看见我，因为我活着，你们也会活着。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","在那一天，你们就知道我与天父一体，你们与我一体。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","愿意听从我的命令并且遵守的人，就是爱我的人，爱我的人，天父必定爱他，我也会爱他，会向他显现。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","犹大（非加略人犹大）对耶稣说：“主啊，你为什么要向我们显现，而不是向世人显现呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","耶稣回答：“若爱我之人就会遵守我所说的话，我父必定也爱他，我们就会来此，他们的家就是我们的家。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","若不爱我，就不会遵从我的话。你们所听之道并非源于我，而是源自派我来此的天父。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","我与你们在一起时解释这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","但当天父以我之名派来的圣灵保惠师， 会教导你们一切，提醒你们我对你们所说过的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","我为你们留下平安，我把自己的平安赐给你们。我给你们的平安与这世界给你的不同。不要紧张，也不要恐惧。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","你们听到我说过：‘我要走了，但还会回到你们这里来。’你们若真爱我，就要欢喜，因为我要到天父那里，天父比我更伟大。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","我提前把这一切解释给你们听，让你们在事情发生的时候可以信服。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","我不能再多说了，因为这世界的统治者就要到了，他的权力无法控制我， ");
INSERT INTO cmnfeb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","但我做了天父吩咐我做的事情，就是为了让世人知道我爱天父。现在站起来，我们走吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“我是真正的葡萄树，天父就是园丁。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","我的枝杈如果不结果子，他就会将其剪去，他修剪结果子的枝杈，让它结更多的果子。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","现在你们因我所言也被修剪过了，变得洁净。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","你们要与我同在，我就与你们同在。枝杈必须长在葡萄树上，凭它自己不能结出果实。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","我是葡萄树，你们是枝杈。与我一体，我也与他一体，这样就会结出丰盛的果实，因为离开了我，你们什么都做不了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","不与我同在，就像枝杈被丢弃，变得枯干，人们会把它们拾起来，丢在火里烧掉了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","你们若与我同在，我的言语也与你们同在，无论你们想要什么，祈求什么，都会给你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","因为你们结出丰盛果实，也是让天父获得荣耀，证明你们就是我的门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","天父怎样爱我，我也怎样爱你们。你们与我的爱同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","如果你们遵守我的命令，就会与我的爱同在，正像我遵守了我父的命令，便与他的爱同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","我把这事解释给你们听，是为了将欢喜留在你们心中，让你们的欢喜变得圆满。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","我命令你们：要彼此相爱，像我爱你们一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","人愿意舍命为朋友，人间没有比这更伟大的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","你们听从我的吩咐，就是我的朋友。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","我不再称你们为仆人，因为仆人不知道主人所做的事，我会称你们为朋友，因为我已把从天父那里听见的一切，都解释给了你们听。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","不是你们选择了我，而是我选择了你们，我赋予你们责任，去结出不朽的果实，这样你们以我之名所求的一切，天父都必将应允。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","这就是我的命令：彼此相爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","如果世人恨你们，记得他们在恨你们之前，就已经恨我了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","你们若属于这世界，这世界也会像爱自己一样爱你。但因为你们不属于这世界，而是我从世界中选出你们，所以世人就恨你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","你们要记住我对你们说过的话：‘仆人不能比主人更重要。’他们若迫害我，也必定迫害你们，他们若遵守我的话，也必定遵守你们的话。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","但他们对你们所做的一切都是因为我，因为他们不知晓派我前来的天父。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","如果我没有来，没有对他们说过什么，他们就意识不到自己的罪。但现在他们无法找到开罪的借口了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","恨我的人，也恨我的父。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","如果我没有通过其他人从未做过的事情，向他们进行显现，他们就不会意识到自己的罪，但尽管看到了这一切，他们仍然恨我和我父。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","这就应验了经书所说：‘他们无缘故地恨我。’ ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","但我会从天父那里向你们派来保惠师，他是来自天父的真理圣灵。当他来到，就会为我作见证。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","你们也要为我作证，因为你们从开始就和我在一起。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“我把这一切告诉了你们，让你们不会放弃对我的信任。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","人们会把你们赶出会堂，事实上时间已到，所有要杀害你们的人，都以为这样就是侍奉上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","他们这样做是因为他们不认识天父，也不认识我。我把一切告诉你们，以便在这一切发生的时候，你们会记得我所说的话。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","我无需在开始就告诉你们这一切，因为你们将跟随我。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","但现在我将要到派我来此的天父那里，但你们没有人问：‘你要到哪里去？’ ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","当然了，现在我把这一切都告诉了你们，你们便心生悲伤。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","但说实话，我的离开对你们更好。如果我不离开，保惠师就不会到来。我若离开，我就会派他来到你们身边。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","他到来的时候，就会说服世人，他们关于罪恶和正义的看法是错的，就会告诉他们什么是审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","关于罪，是因为他们不信我； ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","关于义，是因为我到父那里去，你们就再看不见我； ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","关于审判，是因为这世界的统治者已经受了审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","我还有许多事要告诉你们，可是你们现在无法承受； ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","只等真理圣灵来到，他会教导你们一切真理。他不是为自己说话，而是把他听见的都说出来，把将来的事告诉你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","他让我荣耀，因为他要把从我那里获得的都告诉你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","属于天父的一切也都属于我，所以我说，圣灵会把从我这里获得的告诉你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","不久后，你们不会再看见我，但再过一段时间，你们还要看见我。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","于是他的门徒中有几个彼此说：“他对我们说：‘不久后，你们就不会再看见我，但再过一段时间，你们还要看见我。’又说：‘因为我要到天父那里去。’这是什么意思呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","他们又说：“他所说的‘不久’，是什么意思呢？不理解他在讲什么。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","耶稣知道他们想问他，就说：“我所说的‘不久，你们不会看见我，但再过一段时间，你们还要看见我’，你们为了这话彼此议论吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","告诉你们实话，你们会痛哭哀号，世人却要欢喜，你们会忧愁，但你们的忧愁要变为欢乐。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","妇人生产的时候会痛苦，因为这是分娩的时候。但生了孩子以后，就不再记住那痛苦了，而是欢喜孩子的诞生。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","是的，现在你们也会悲伤，但我会与你们再次相见，你们的心就会欢喜，没有人能夺走你们的欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","到了那天，你们什么也不会问我了。告诉你们实话，以我的名向天父求的任何事，他必定给予你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","你们一直以来没有以我的名求什么，现在你们祈求就必然应验，让你们的欢喜圆满。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","我一直用比喻向你们讲述，但很快，我不会再使用比喻，而是把关于天父的事明明白白讲出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","到了那天，你们要以我的名祈求，我不是说我要以你们的名义请求天父， ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","因为天父爱你们，因为你们爱我，并且相信我来自上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","我离开天父来到这世界，现在我要离开这世界，到天父那里去。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","门徒说：“现在你就明说了，不再用比喻， ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","现在我们很确定你无所不知，为了知道人们在想什么问题，你不需要问他们。因此，我们信你来自上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","耶稣对他们说：“现在你们真信吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","时候要到了，其实已经到了，你们要分散到各自该去的地方，留我独自一个人。其实我不是独自一个人，因为有天父与我同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","我把这些事告诉你们，是要使你们因为与我一体而平安。 在世上你们会遭受苦难，但你们要勇敢，我已经胜过了这世界！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","耶稣讲完了这些话，就举目望天，说：“父啊，时候到了，求你让你的儿子获得荣耀，你的儿子就会让你获得荣耀， ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","正如你把管理全人类的权力给了他，让他可以将永生赐给你所给予他的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","知道你是独一的真上帝，并且认识你所派来的耶稣基督，这就是永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","现在我已在这世间给了你荣耀，完成了你交给我的任务。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","父啊，现在让我在你面前获得荣耀，就是在创世纪前我与你同享的荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","你从世上分别出来赐给我的人，我已经把你的身份显示给他们了。他们是你的，你把他们赐给了我，他们也遵守了你的道。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","现在他们知道，你给我的，无论是什么，都是从你那里来， ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","你赐给我的话，我已经给了他们，他们也领受了，确定知道我是从你那里来的，并且信你差了我来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","我为他们祈祷，我不为世人祈祷，而是为你赐给我的人祈祷，因为他们是你的。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","属于我的一切都属于你，你的一切也是我的，并且我因为他们获得了荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","我要离开这世界了，他们却仍留在这里，我要到你那里去了。圣父啊，求你凭着赐给我的名，保护他们，让他们成为一体，就像我们一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","我跟他们在一起的时候，因你赐给我的名，我看护他们，除了那‘迷失之子’以外，其他人都没有迷失，这就应验了经文上的话。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","现在我到你那里去，我在世上说这些话，就是要他们充分分享我的欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","我把你的道赐给他们，世人恨他们，因为他们不属于这世界，像我不属于这世界一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","我不求你让他们离开这个世界，只求你保护他们远离恶人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","他们不属于这世界，像我不属于这世界一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","求你用真理让他们变得神圣，你的道就是真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","就像你派我到这世上来，我也将同样派他们到世界各地。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","我为他们奉献自己，让他们能够真正成为神圣之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","我不但为他们祈求，也为那些因他们传递的福音而信我的人求， ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","祈求他们都能合而为一，就像天父你与我同在，我与你同在。求他们也与我们同在，让世人相信是你派我前来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","你赐给我的荣耀，我已经赐给了他们，使他们合而为一，像我们合而为一。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","我与他们同在，你与我同在，使他们完完全全合而为一，让世人知道你派我前来，知道你爱他们，好像爱我一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","父啊，我在哪里，希望你赐给我的那些人，也能到我所在的地方，让他们看见你赐给我的荣耀，因为在创立世界以前，你就已经爱我了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","善良的天父啊，世人虽然不认识你，我却认识你，与我一起的这些人也知道你派我前来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","我已经把你的性格显示给他们，还要再显示，让他们也能拥有你对我的爱，我将与他们同在。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","耶稣说完了这些话，就和门徒走过汲沦溪，走进那里的一个橄榄果园。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","出卖耶稣的犹大也知道那地方，因为耶稣和门徒常常在那里聚集。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","这时候，犹大带着一队士兵，还有祭司长和法利赛人的守卫，拿着灯笼、火把、武器，来到园子里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","耶稣知道将要发生在他身上的一切，就出来对他们说：“你们找谁？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","他们问到：“你是拿撒勒人耶稣吗？” 耶稣说：“我是。”出卖耶稣的犹大和他们站在那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","耶稣一说“我是”，他们就往后退，倒在地上。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","耶稣再问他们：“你们找谁？” 他们再次问：“你是拿撒勒人耶稣吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","耶稣回答：“我已经告诉你们，我是。如果你们来找我，就让这些人走吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","这应验了耶稣说过的话：“你赐给我的人，我一个也没有失落。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","西门（彼得）拔出一把刀，向大祭司的仆人马勒古砍去，削掉他的右耳。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","耶稣对彼得说：“把刀放下！难道你认为天父给我的杯，我能不喝吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","于是那一队士兵及其长官和犹太人的守卫，抓住耶稣把他绑起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","先他们把耶稣带到亚那面前，亚那是当年大祭司该亚法的岳父。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","该亚法就是曾向犹太人提议“一个人代替人民而死更有益”的那个人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","彼得和另一个门徒跟着耶稣。因为那位门徒与大祭司很熟，所以就能跟耶稣一起进入大祭司的院子， ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","彼得却站在门外。大祭司认识的那位门徒走出来，对看门的婢女说了一声，就带着彼得进去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","看门的婢女对彼得说：“你不也是这个人的门徒吗？”他说：“我？不，我不是。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","因为天气寒冷，仆人和差役就生了火，站着取暖，彼得走进去后也和他们站在一起取暖。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","这时，大祭司向耶稣质疑关于他的门徒和他教导的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","耶稣对大祭司说：“我向来对世人讲话都是公开的，我常常在会堂和圣殿里，就是在所有犹太人聚集的地方教导人，我并没有偷偷地讲什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","你为什么质疑我呢？问问那些听过我讲话的人吧，他们知道我讲过什么。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","耶稣说了这些话，站在旁边的一个差役打了他一巴掌，说：“你竟敢这样和大祭司说话？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","耶稣对他说：“如果我讲错了，告诉大家我错在哪里。如果我讲对了，你为什么打我呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","亚那仍然绑着耶稣，把他押到大祭司该亚法那里去。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","彼得仍然站在火旁取暖。有人问他：“你不也是他的门徒吗？”彼得否认说：“不，我不是。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","大祭司的仆人——就是耳朵被彼得削掉那人的亲戚，说：“我不是看见你跟他在园子里吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","彼得又否认，这时鸡叫了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","凌晨时分，他们把耶稣从该亚法那里押往罗马总督的官邸。犹太人首领们自己没有进到官邸里去，他们想吃逾越节的晚餐，怕违反礼仪的规定而变得不洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","于是彼拉多走到外面见他们，说：“你们控告这个人什么呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","他们回答：“如果这个人没有作恶，我们就不会把他交给你。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","彼拉多对他们说：“你们自己把他带去，按着你们的律法审问他吧。”犹太人说：“我们没有权处决任何人。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","这就应验了耶稣预言自己如何死去的那句话。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","彼拉多又进了官邸，把耶稣叫来，问他说：“你是犹太人的王吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","耶稣回答：“这话是你自己说的，还是别人对你说到我的呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","彼拉反问：“难道我是犹太人吗？你们自己人和祭司长把你交给我，你究竟做了什么事？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","耶稣回答：“我的国不属于这世界；如果我的国属于这世界，我的臣仆就要作战，不会把我交给犹太人。不过，我的国不是这世上的。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","于是彼拉多问他：“那么，你是王吗？” 耶稣说：“你说我是王。我要为真理作见证，我为此而生，也为此来到世上。凡是接受真理的人，都会聆听我所说的。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","彼拉多问他：“真理是什么？” 彼拉多说罢，又出来见犹太人，对他们说：“我不认为他有什么罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","你们有个惯例，每逢逾越节，就要我给你们释放一名囚犯。你们想让我释放这个犹太人的王吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","他们又喊叫说：“不要他！要巴拉巴！”这巴拉巴是个叛乱者。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","那时，彼拉多吩咐人把耶稣拉去鞭打。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","士兵用荆棘编成冠冕，戴在他的头上，又给他披上紫色的外袍， ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","然后一次又一次地来到他们面前，说：“犹太人的王万岁！”然后用手打他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","彼拉多再次来到外面，对犹太人说：“我把他带出来给你们，是让你们知道我不认为他有什么罪。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","于是耶稣出来，戴着荆棘的冠冕，披着紫色的外袍。彼拉多对他们说：“看，就是这个人。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","祭司长和差役看见耶稣，就喊叫说：“把他钉上十字架！把他钉上十字架！”彼拉多对他们说：“你们自己把他带去钉十字架吧，我不认为他有什么罪。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","犹太首领回答：“我们有律法，根据那律法，他是该死的，因为他自称为上帝之子。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","彼拉多听见这话，感到更害怕了， ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","于是回到他的官邸，问耶稣：“你是从哪里来的？”耶稣却不回答他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","彼拉多对他说：“你不想对我说话吗？难道你不知道，我有权释放你，也有权把你钉上十字架吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","耶稣说：“如果不是从上天给你的权力，你就无权惩办我，因此，把我交给你的那人，罪更重。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","听到这番话，彼拉多尝试想要释放耶稣。可是犹太人首领却喊叫说：“如果你释放这个人，就不是凯撒的朋友了。凡是自命为王的，就是与凯撒为敌。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","彼拉多听了这些话，就把耶稣带到外面，来到一个名叫“铺石地”（希伯来语为“加巴大”）的地方，坐在审判椅上开始进行审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","当时逾越节前一天正午的时候，彼拉多对犹太人说：“看，你们的王！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","他们就喊叫起来：“杀了他！杀了他！把他钉上十字架！” 彼拉多问他们：“你们想要把你们的王钉上十字架吗？” 祭司长回答：“除了凯撒，我们没有王！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","于是彼拉多把耶稣交给他们去钉上十字架。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","他们让耶稣自己背着十字架，把他带到了一个名叫“髑髅之地”的地方（希伯来语为“各各他”）。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","他们就在那里把耶稣钉在十字架上，和他一同钉十字架的，还有两个人，一边一个，耶稣在中间。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","彼拉多写了一个牌子，上面写着：“犹太人的王拿撒勒人耶稣。”，放在十字架上。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","很多人都看到了这个牌子，因为耶稣钉十字架的地方离城不远，而且那牌子是用希伯来文、拉丁文和希腊文写成。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","祭司长对彼拉多说：“不要写‘犹太人的王’，要写‘此人自称：我是犹太人的王’。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","彼拉多说：“我写的就已经写了！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","士兵把耶稣钉了十字架之后，就把他的衣服拿来，分成四份，每个兵一份。他们又拿他的袍子，这袍子没有缝，织成了一整件。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","因此，他们彼此说：“就别把它撕开了，我们来抽签，看看谁能拿到它。”这就应验了经上所说的：“他们分了我的外衣，又为我的衣而抽签。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","士兵果然这样做了。 在耶稣十字架旁边，站着他的母亲和他母亲的姐妹，还有高罗巴的妻子玛利亚和抹大拉的玛利亚。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","耶稣看见母亲，又看见他所爱的那门徒站在旁边，就对母亲说：“母亲，看！这是你的儿子。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","然后他对那门徒说：“这是你的母亲。”然后，那名门徒就把她接到了自己的家中。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","耶稣知道自己来此的一切目的都已经达成，为了要使经上的话应验，就说：“我渴了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","在那里有一个坛子，盛满了酸酒，他们就拿海绵浸了酸酒，绑在牛膝草的草茎上，送到他的口里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","耶稣尝了那酸酒，说：“完成了！”就低下头，断了气。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","因为那天是预备日，为了要避免尸体在安息日留在十字架上（事实上，这是一个特殊的安息日），于是犹太人首领就请求彼拉多打断那些被钉十字架的人的腿，防止他们的身体被移动。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","于是士兵就把和耶稣另外两个钉上十字架之人的腿都打断了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","他们来到耶稣那里，看见他已经死了，就没有打断他的腿。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","但是有一个士兵用枪刺入他的肋侧，立刻有血和水流出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","看见此事的人已经作证了，他的见证是真实的，他也知道自己所说的是真实的，所以你们也应该相信。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","这些事的发生，应验了经文所说“他的骨头，一根也不可折断。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","另有一处经文说：“他们要仰望自己所刺的人。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","在这之后，有一名亚利马太人约瑟来见彼拉多，请求领走耶稣的身体。他是耶稣的门徒，但因为怕犹太人，所以偷偷地进行。彼拉多批准了，他便把耶稣的身体领去。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","以前曾在夜晚去见耶稣的尼哥德慕也来了，带着没药和沉香混合的香料，约有三十四公斤。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","他们领走了耶稣的身体，照着犹太人的葬礼的规例，用细麻布和香料把他裹好。在耶稣钉上十字架的地方有一个园子， ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","园里有一个从未葬过人的新墓穴。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","因为那天是犹太人的预备日，又因为那墓穴就在附近，他们就把耶稣葬在那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","下一周第一天清晨，天还没有亮，抹大拉的玛利亚来到墓旁，看见墓口的石头已经移开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","她就跑去见彼得和耶稣所爱的那个门徒，对他们说：“有人把主从坟墓里搬走了，我们不知道他们把他放在哪里了。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","彼得和那门徒就向坟墓跑去。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","两个人一起跑，另一名门徒比彼得跑得快，先到了坟墓， ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","弯腰向里面观看，看见细麻布还在那里，但他却没有进去。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","彼得随后也到了，他进入坟墓，看见细麻布还放在那里， ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","还看见耶稣头部的那块布，但没有和细麻布放在一起，而是折叠放着。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","这时候，先到坟墓的门徒也走了进去。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","他四处张望，相信那句经文是正确的。在这之前，他们都没有理解经文中所说的：耶稣必须从死人中复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","于是两个门徒就回到他们的住所。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","但玛利亚站在坟墓外面哭泣。她一边哭，一边弯腰往里面观看， ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","却见到两名白衣天使，坐在曾安放耶稣身体的地方，一个坐在头的位置，一个在脚的位置。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","天使问她：“你为什么哭？” 她说：“有人把我的主搬走了，我不知道他们把他放在哪里。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","玛利亚说了这话，就转过身来，看见耶稣站在那里，但没有认出他就是耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","耶稣对她说：“你为什么哭？你找谁呢？”玛利亚以为耶稣是园丁，就对他说：“先生，如果是你把他搬走了，请告诉我你把他放在什么地方，我好去搬回来。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","耶稣对她说：“玛利亚！” 她转过身来看着耶稣，用希伯来语说了一句：“拉波尼！”（就是“老师”的意思。） ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","耶稣说：“你不要留住我，因为我还没有升上天去见天父，去找我的兄弟们，告诉他们我要上天去见我的父，也是你们的父。我的上帝，也是你们的上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","于是抹大拉的玛利亚就去告诉其他门徒：“我已经看见主了！”她又把主对她所说的话告诉他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","下一周第一天夜晚的时候，门徒聚在一起，因为怕犹太人，就把门户都关上。耶稣来了，站在他们中间，说：“愿你们平安。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","说了这话，就把手和肋旁给他们看。门徒看见主，就欢喜了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","耶稣又对他们说：“愿你们平安。天父怎样派我来，我也怎样派遣你们。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","说了这话，就向他们吹一口气，说：“领取圣灵吧！ ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","你们赦免谁的罪，谁的罪就得赦免，你们不赦免谁的罪，谁的罪就不得赦免。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","十二个门徒中，有一个称为“双生子”的多马。耶稣来的时候，他没有和门徒在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","其他的门徒对他说：“我们已经见过主了。” 多马对他们说：“除非我亲眼看见他手上的钉痕，用我的指头探入那钉痕，又用我的手探入他的肋旁，否则我决不相信。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","一星期之后，门徒又在屋子里，多马也和他们在一起。门户都关上了。耶稣到来，站在他们中间，说：“愿你们平安。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","然后对多马说：“把你的指头放在这里，看看我的手。伸出你的手，摸摸我的肋骨旁。不要疑惑，要相信！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","多马对他说：“我的主！我的上帝！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","耶稣说：“你因为看见我才信吗？那些没有看见就信的人，才是有福。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","耶稣在门徒面前还行了许多别的神迹，没有记在本书中。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","但记录这些事，是为了让你们信耶稣是基督，是上帝之子。你们信了，就可以因相信他而获得生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","在这之后，耶稣在提比里亚海边再次向门徒显现。他显现的经过是这样的： ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","当时彼得、“双生子”多马、加利利的迦拿人拿但业、西庇太的两个儿子，和另外两个门徒聚在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","彼得对他们说：“我要打鱼去。”他们说：“我们也跟你一起去。”于是他们出去上了船，可是那一夜他们并没有打到什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","黎明时分，耶稣站在岸边，门徒却不知道他就是耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","耶稣对他们说：“我的朋友们，打到鱼没有？”他们回答：“没有。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","耶稣说：“把网撒在船的右侧就可以打到鱼。”于是他们把网撒下去，但却拉不动，因为鱼太多。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","耶稣所爱的那名门徒对彼得说：“是主！”彼得一听见是主，就立刻穿上衣服（因为他当时没有穿衣服），纵身跳进海里。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","其他的门徒因为离岸不远（约有一百公尺），于是就跟着来到小船上，把那网鱼拖过来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","他们上了岸，就看见那里有一堆篝火，上面正在烹饪鱼，还有一些饼。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","耶稣对他们说：“把你们刚才打的鱼拿几条来。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","彼得上船把网拉到岸上，那网装满了大鱼，共有一百五十三条。鱼虽然这么多，网却没有破。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","耶稣对他们说：“来吃早饭吧。”门徒中没有一个人敢问他：“你是谁？”因为知道他是主。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","耶稣走过来，把饼递给他们，又把鱼递给他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","这是耶稣死而复生后，第三次向门徒显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","他们吃了早饭，耶稣问西门（彼得）：“约翰的儿子西门，你爱我比这些更深吗？” 他回答说：“是的，主啊，你知道我爱你。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","耶稣对他说：“照顾好我的羊羔。”耶稣第二次又问他：“约翰的儿子西门，你爱我吗？”他回答：“主啊，是的，你知道我爱你。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","耶稣说：“照顾好我的绵羊。”耶稣第三次问他：“约翰的儿子西门，你爱我吗？”彼得因为耶稣第三次问他“你爱我吗？”就有些难过。于是对耶稣说：“主啊，你是无所不知的，你知道我爱你。”耶稣说：“照顾好我的绵羊。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","告诉你实话，当你年轻的时候，你会打扮好去任何地方，但当你变老，就要伸出手来，让别人给你穿上衣服，带你到你不愿意去的地方。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","耶稣说这话，是在解释他死亡的方式如何让上帝获得荣耀。然后他对彼得说：“跟我来吧。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","彼得转过身来，看见耶稣所爱的那名门徒跟着他们，他在最后的晚餐时曾侧身问耶稣：“主啊，出卖你的是谁？。” ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","彼得看见他，就问耶稣：“主啊，他会怎么样呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","耶稣回答他：“如果我让他活到我到来之时，跟你有什么关系呢？你只管跟从我吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","这句话传到其他门徒那里，说那位门徒不会死。其实耶稣并没有对他说他不会死，只是说：“如果我让他活到我到来之时，跟你有什么关系呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","这位门徒确认发生过这件事，并且将其写了下来。我们知道他的见证是真实的。 ");
INSERT INTO cmnfeb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","耶稣还做过许多其他的事情，如果全部写下来，我怀疑整个世界能否容纳所有要写的书。");
INSERT INTO cmnfeb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","尊敬的提阿非罗先生：在上一本书中，我从最初开始讲述了耶稣所行之事和所授之道， ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","一直写到他通过圣灵向所选择的使徒发出指示，然后被带入天堂。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","在他受难以后的四十天中，他又向使徒们显现，以令人信服的证据证明他仍然活着，还向使徒们讲述了上帝之国的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","当他与使徒们同在人间时，曾吩咐他们：“不要离开耶路撒冷，要等候天父承诺给予你们的，正如你们从我这里听到的。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","约翰用水施洗，但在几天后，你们就会接受圣灵的施洗。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","所以当使徒们与复活后的耶稣相见时，便询问耶稣：“主啊，你打算现在就恢复以色列王国吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","耶稣回答：“只有天父有权决定这个日期和时间，你们不必知道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","但当圣灵降临在你们身上，你们就会获得力量，要在耶路撒冷、犹太全地、撒玛利亚乃至大地的极点，作我的见证人。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","说罢，他就在使徒们的目视下腾空而起，随后被一朵云遮住了踪迹，再也无法看到。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","正当使徒们专心地望着耶稣升天之时，忽然出现两名白衣之人，站在他们旁边， ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","他们问：“加利利人，你们为什么站在这里望天？这位离开你们去天堂的耶稣，将会以你们所目睹他进入天堂的方式，回到你们身边。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","后来，使徒们从橄榄山回到耶路撒冷，两者之间的距离大约是安息日步行那么远。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","来到目的地后，他们来到了下榻之所，需要通过楼梯来走到楼上。他们是：彼得、约翰、雅各、安得烈、腓力、多马、巴多罗迈、马太、亚勒腓的儿子雅各、激进派的西门、雅各的儿子犹大。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","使徒们开始进行祷告，与他们一起的还有几名女性以及耶稣的母亲玛利亚和他的兄弟们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","这时候大约有 120 名信徒聚在一起，彼得站起来向众人发言： ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“兄弟姐妹们，圣灵在经文上借大卫之口，讲述了犹大带人捉拿耶稣的事，一定会应验。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","他本是我们中间的一员，共同承担这份侍奉之责。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","（犹大用这笔不义之财买了一块田，后来在田间一头倒了下去，身体裂开，内脏全部流了出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","住在耶路撒冷的人都知道这件事，所以那块地也被称作“亚革大马”，当地语言的意思就是“血田”）。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","《诗篇》中曾写到：“让他的住处变为荒芜，无人居住。”还写到：“让别人取代他的侍奉之责。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“所以，我们必须再选择一名使徒，他全程一直与我们在一起， ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","从约翰施洗开始，直到耶稣离开我们升入天堂。我们必须选择这样一个人与我们一起，做为耶稣复活的见证人。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","于是他们选择了两个人：约瑟（又名巴撒巴）和马提亚， ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","然后众人开始共同祷告：“主啊！你知道每个人的想法, 请指示你希望从这两人中选择谁， ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","来承担这使徒的侍奉之责。犹大已放弃这责任，去了他该去的地方。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","他们开始抽签，结果抽中了马提亚，于是他加入了另外 11 名使徒之列。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","五旬节那天，使徒们聚集在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","忽然天上发出响动，仿佛强风填满了他们所在的整个房屋。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","他们又看到看似舌头一般的火焰，落在每个人的身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","圣灵充满每个人的身体，他们开始通晓不同国家的语言，这也是圣灵赋予他们的能力。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","当时，耶路撒冷住着很多来自不同国家的虔诚犹太人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","听到响动，众人便聚了过来。听见使徒能够讲述他们各自的母语，他们倍感困惑。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","他们万分惊讶地说：“看这些说话的人，他们都是加利利人，是不是？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","但我们怎么听见他们在讲我们的母语呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","我们来自帕提亚、玛代人、以拦、美索不达米亚、犹太、加帕多家、本都、亚西亚、 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","弗吕家、旁非利亚、埃及以及靠近古利奈的利比亚的各地，还有来自罗马的犹太人和归信犹太教之人， ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","以及克里特人和阿拉伯之人——但现在，我们听到他们用我们本地的语言，讲述上帝的伟大事迹。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","众人感到惊讶困扰，彼此询问：“这意味着什么？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","但也有人讥嘲笑道：“他们就是酒喝太多，醉了。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","彼得和另外 11 名使徒站起来，他高声对众人说：“犹太人和所有住在耶路撒冷的朋友啊，仔细听好了，我要向你们解释这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","这些人并非如你们所想喝醉了，现在只是上午九点钟而已。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","所发生的一切正如约珥先知所言： ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","上帝说：‘在末日到来的日子，我要将我的圣灵施与所有人，你们的儿女将会说出预言，你们的青年人将看到异象，你们的老年人将会梦到梦境。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","我将把我的圣灵施于我的仆人，无论男女，他们都将说出预言。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","我要在天堂和大地向你们显现神迹，有血、有火、有旋转的烟雾！ ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","在主的伟大荣耀之日降临之前，太阳将变得黑暗，月亮将变为血红。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","但只要呼唤主的名字，必会得救。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","以色列人，听好了：正如你们所知，上帝通过拿撒勒人耶稣在你们之中显现惊人的奇迹和神迹，证明他就是上帝所确定之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","上帝早已预知将会发生什么，他按照自己的计划，决定将耶稣交给你们。但你们却借由恶人之手，把他钉上了十字架。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","但上帝让他起死回生，无需遭受死亡的痛苦，因为死亡没有困住他的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","大卫这样说耶稣：‘我总是会看见主在我面前。因为他就在我身边，我必不会动摇。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","所以我才会如此快乐，所以我的言语中充满喜悦，所以我的身体充满希望。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","因你不会弃我于坟墓，也不会让圣者腐朽。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","你向我指引了生命之路，让我因你在身旁而充满欢喜。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","兄弟姐妹们，让我坦白地告诉你们，我们的祖先大卫已经死去并被埋葬，至今他的坟墓仍在人间。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","但他是先知，知晓上帝向他做出的誓言，要从他的后裔中选择一人接替他的王位。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","大卫已看见了即将发生的事，曾这样讲述基督的复活：‘基督不会被弃于坟墓，他的肉身也不腐朽。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","上帝让这位耶稣复活，我们都是这件事的见证人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","现在他已被高举到上帝的右边，获得天父承诺给予他的圣灵，在被施与圣灵后，你们所见所闻就会倾吐而出。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","大卫并没有升入天堂，但他却说：‘主对我主说：坐在我右边， ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","让我把你的仇敌成为你的脚凳。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","现在要让以色列所有人都确信：被你们钉上十字架上的这位耶稣，上帝已经让他成为主和基督！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","众人听到这一切，心中倍感痛苦。他们询问彼得和其他使徒说：“兄弟们，我们应该怎么办？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","彼得说：“悔改！所有人都要以耶稣基督之名受洗，以便你们的罪获得救赎，这样就能获得圣灵馈赠。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","这承诺给予你们、你们的儿女、以及所有远方之人，我们主上帝召来的所有人。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","彼得继续讲述，给出更多证明。他警告众人，说：“从这个扭曲的世界拯救自己吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","那些接受他这番话的人都受了洗，这一天内的门徒数量就增加了约三千人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","他们立下承诺要遵守门徒的教诲，对其他信徒也立下承诺，共同“分享饼”和共同祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","众人敬畏地看到使徒们做出的奇迹和神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","所有信徒都聚在一起，分享自己的所有。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","他们变卖房屋和财物，按照个人所需分享变卖所得。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","他们日夜持续地在圣殿中聚会，在家中共同进餐，以谦卑幸福的心情享用食物。他们赞美上帝，所有人都赞赏他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","他们的数量不断增加，因为主将所拯救之人带到这里。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","下午三点的祷告瞬间，彼得和约翰向圣殿走去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","有人将一个生来瘸腿之人抬来，每天放他在殿门口（这扇门名为“美”），向进殿之人乞讨。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","他看见彼得和约翰将要进殿，就向他们讨钱。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","彼得和约翰定睛看着他，彼得说：“看我们！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","那人就专注地看着他们，希望从他们那里得些什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","彼得却说：“我没有金银，只是把我有的给你。以拿撒勒人耶稣基督之名，让你行走！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","于是彼得拉着他的右手，扶他起来，他的脚和踝骨立刻变得有力， ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","他跳起来后开始行走，连走带跳，赞美上帝，同他们进入殿中。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","众人看见他一边走一边赞美上帝， ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","大家认出他就是平时坐在圣殿美门口的讨饭乞丐，对于他身上发生的事情惊讶不已。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","那人紧紧跟随着彼得和约翰，倍感惊奇的众人也跟着他们跑到了所罗门廊处。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","彼得借此机会对大家说：“以色列人，为什么要为这事惊讶呢？为什么盯着我们看，好像这人能够行走，都是我们凭借自己的能力和信仰达成？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","亚伯拉罕、以撒、雅各的上帝，也是我们祖先的上帝，他已经让其仆人耶稣获得了荣耀。就是那位你们把他送到官府的耶稣。彼拉多本来决定要释放他，你们却当着彼拉多的面拒绝了这个决定。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","你们拒绝接受一位善良的圣者，反倒要求释放一名杀人犯。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","你们杀死了这位生命的创造者，上帝却让他死而复生。我们亲眼见证了这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","这位男人因为相信耶稣之名，所以被耶稣所治愈。现在你们看到这个男人，你们都认识他。因为相信耶稣，他当着你们众人的面被治愈了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","兄弟姐妹们，现在我知道你们这样做是出于无知，你们的领导者也是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","但上帝却实现了他通过众先知之口所传递的信息：这位基督将会受害。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","所以你们应该忏悔，改邪归正，这样才能让你们的罪一笔勾销，主才能为你们送来治愈和恢复的机会， ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","才会将指定给你们的耶稣基督派来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","在世界万物修复之前，他一定会留在天堂，也就是上帝在很久以前通过圣先知之口宣布的讯息。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","摩西曾说：‘主上帝将从你们自己人中选择像我这样的先知，派遣给你们。无论他对你们说什么，你们都应当聆听。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","不聆听这位先知之人，必会在人类中彻底灭绝。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","从撒母耳起的所有先知，都曾经预言过这样的日子。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","你们是先知的子孙，也是上帝与你们祖先所立之约的后人。上帝曾对亚伯拉罕说：‘作为你后代的人间万众都会获得祝福。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","上帝为你们准备好了他的仆人，首先把他派来，通过纠正你们的邪恶之道为你们祝福。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","使徒们向群众宣讲的时候，祭司、圣殿的守卫长和撒都该人都来到了他们这里。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","看到使徒教导民众，讲述通过耶稣死而复生之事，他们非常愤怒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","于是他们逮捕了使徒，由于天色已晚，就决定把使徒拘留到第二天。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","但很多人都相信了这番宣讲，信徒的总人数已经增加到大约五千人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","第二天，犹太人的长官、长老和宗教老师都聚集在耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","加入其中的还有大祭司亚那和该亚法、约翰、亚历山大，以及大祭司的家人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","他们让彼得和约翰站在他们面前，问到：“你们凭什么能力或以谁的名义做这件事？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","身体充满圣灵的彼得对他们说：“民众的首领、长老， ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","我们今天受审，难道是因为我们对一名无法帮助他自己的人做出了善行？因为我们将他治愈？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","如果是，你们各位和以色列全民都应当知道，站在你们面前这人之所以彻底痊愈，是以拿撒勒人耶稣基督之名，就是你们把他钉死在十字架上，上帝却使他死而复生的耶稣基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘他是你们这些建筑工人丢弃的石头，但他其实是建筑的主要基石。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","任何其他人都无法拯救，在这天底下，无法以任何其他人类之名拯救我们。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","他们看到彼得和约翰的自信，也知道这两人只是没有受过教育的普通民众，便感到很惊讶，同时也认出他们是耶稣的同伴。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","那被治愈之人和他们站在一起，看到眼前的情景，他们也无话反驳。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","于是他们就让受审之人到公议会外面去，他们开始进行商议。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","他们说：“应该拿这几个人怎么办？他们的确显现了强大的神迹，而且所有住在耶路撒冷的人都知道了，我们无法否认。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","但为了避免这件事在民众中越传越广，我们应该警告他们，不许再奉此名向任何人传道。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","于是把彼得他们叫来，命令他们不得再以耶稣之名教导民众。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","但彼得和约翰回答：“无论这在上帝眼中是对是错，听从你们还是听从上帝，你们决定吧。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","我们无法对看到和听到的保持沉默！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","由于民众在看到这个神迹后都开始颂赞上帝，公议会无法找到惩罚他们的方法，于是在恐吓一番后就把他们放了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","那位因神迹而被治愈的男人已经四十多岁了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","使徒们被释放之后，来到其他信徒那里，讲述了祭司长和长老所说的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","众人听罢，一起向上帝祈祷：“主啊，你创造了天地、海洋和世间万物。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","你凭借圣灵通过我们的祖先和你的仆人大卫之口说：‘万国民众为什么如此愤怒？他们为什么以空谋妄想针对我？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","人间的君王准备开战，首领们聚在一起反对主，反对他们的天选之人。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","现在这一切就真实地发生在这座城市中！希律和本丢·彼拉多与异教徒和以色列民众，就在这城里聚集，反对你所膏立的圣仆耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","他们做出了你早已决定之事，因为你有这样做的权利和意愿。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","主啊，看看他们对我们的恐吓！帮帮你的仆人吧，让他们能够有胆量传讲你的道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","在你行使治愈力量之时，愿你能通过你的圣仆耶稣之名，实现神迹和奇迹。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","祷告完毕，他们聚会的建筑震动起来，圣灵充满所有人的身体，他们开始大胆传讲上帝之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","所有信徒同心同思，任何人都不会认为某些财物属于自己，他们彼此分享一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","使徒凭借强大的力量传递主耶稣复活的讯息，他们也获得了上帝的慷慨祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","没有哪个信徒感到匮乏，他们卖掉了所有的田地或财产， ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","把收入放在使徒面前，照着各人的需要进行分配。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","有一个叫做约瑟的利未人，生在塞浦路斯，使徒称他为巴拿巴（意为鼓励之子）。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","他也卖掉了自己的田地，把钱拿来放在使徒面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","有一个人名叫亚拿尼亚，和妻子撒非拉一起把田地都卖了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","但他悄悄留下了一部分收入，妻子也知晓这件事。他把其余的钱拿来放在使徒面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","彼得说：“亚拿尼亚，为什么你让撒旦充满你的心，说服你欺骗圣灵，私底下把卖地的钱留了一部分？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","田地还没有卖时，不就是你自己的吗？既然卖了，所得的收入不是由你做主吗？为什么决定这样做呢？你这不是欺骗人，而是欺骗上帝！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","亚拿尼亚听罢，立刻倒地断了气。所有听闻之人都十分害怕。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","有几个青年人过来用裹尸布把他包好，抬出去埋葬了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","大约三小时后，亚拿尼亚的妻子来到这里，还不知道发生了什么事。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","彼得问她：“告诉我，你们卖田地的钱就这么多吗？” 她说：“是的，就是这么多。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","彼得说：“你们为什么串通一气试探主的灵？你看，埋葬你丈夫的人刚刚回来，他们也会把你抬出去！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","她立刻倒在彼得脚边，断了气。那些青年人返回后发现她死了，便把她也抬出去，埋在她丈夫旁边。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","所有信徒和听闻此事之人，都感到万分恐惧。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","主通过使徒显现许多神迹和奇迹。所有信徒过去一直都聚集在所罗门廊下。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","其他人虽然很尊重他们，但都没有加入其中的胆量。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","但相信主的信男信女却越来越多， ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","甚至有人把病人放在床和垫子中，抬到街上，希望彼得在经过时，至少他的影子可以落在他们身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","耶路撒冷周围城市的人，也带着病人和恶灵附体之人蜂拥而来，所有病患全部被治愈。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","但这让大祭司和同伙的撒都该人非常嫉妒，决定插手迫害他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","他们捉拿了使徒，把他们押在公共拘留所里。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","但到了晚上，有一位主的天使打开监牢门，把他们放了出去，对他们说： ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“去圣殿那里，把新生命之道的一切告诉众人。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","使徒听从吩咐，在黎明时分走进圣殿教导众人。 与此同时，大祭司及其同党和以色列人众长老召开了公议会，派人到监牢把使徒带过来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","但差役在监牢里找不到使徒，于是回来报告说： ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“我们发现监牢门紧闭，狱卒也守在门外，但打开门后，里面一个人都找不到。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","圣殿的守卫和祭司长听到这个消息，觉得很困惑，不知道发生了什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","这时有人来报告说：“看啊，你们押在监牢里的那些人，正在圣殿里教导民众呢！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","于是守卫长和差役一起过去把使徒带过来，但没有用暴力，怕众民用石头打他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","使徒们被带过来后，站在公议会前。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","大祭司问他们：“我们难道没有吩咐过你们，不准再以此名教导民众吗？现在看看，你们让整个耶路撒冷都知道了你们的教导，你们还想把那人的死怪在我们头上！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","彼得和众使徒回答：“我们服从上帝必须高于服从人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","你们将其放上十字架杀害的耶稣，我们祖先的上帝已使他复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","上帝把他高举在自己的右边，获得首领和救世主的荣耀，以此让以色列人悔改，让他们的罪得以赦免。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","我们为所发生的这一切作证，上帝向顺从他之人赐予的圣灵也为这一切作证。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","公议会的人听闻此言非常恼怒，想要杀了他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","但公议会中有一个名叫迦玛列的法利赛人，是民众所尊敬的律法教师。他站起来吩咐差役把使徒暂时带出去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","然后他对大家说：“以色列人的首领们，你们在谋划处理这些人时应该小心。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","从前有个叫丢大的人想要扬名立万，大约有四百人跟随他。但他被杀后，跟随他的人便作鸟兽散，什么都没有剩下。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","在他之后，一个加利利人叫犹大，在人口普查的过程中也召集了众人跟从他。他死去后，那些听命于他的人也就消失了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","所以对于眼前的事情，劝你们不要管这些人，随他们吧！如果他们的计划或行动出于人意，必将失败。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","如果出于上帝，你们就不能打败他们，那样你们就是在对抗上帝了！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","他们接受了他的劝告，于是把使徒传进来，鞭打一顿并禁止他们以耶稣之名教导，然后就把他们释放了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","使徒高兴地从公议会出来，他们觉得为主之名受辱是一件值得的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","他们继续每天在圣殿中或走家串户地教导众人，昭告耶稣即基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","随着信徒的数量快速增加，说希腊语的信徒开始与说阿拉姆语的信徒争论起来，抱怨在日常食物分配的过程中歧视他们的寡妇。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","于是十二使徒召集众信徒，说：“我们要传讲上帝之道，让我们放弃这个使命去管理伙食，不太合适。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","兄弟们，从你们中间选出七个值得信赖、充满圣灵和智慧之人，我们会派他们负责此事。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","我们要专心祈祷，行使传道的侍奉之责。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","这个安排让所有人都很满意。他们选出司提芬（一位全心相信上帝，充满圣灵之人）以及还有腓利、伯罗哥罗、尼加挪、提门、巴米拿以及归信犹太教的安提阿人尼哥拉， ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","这几个人站在使徒面前，使徒在祷告结束后就对其按手祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","上帝之道继续传播，耶路撒冷的信徒人数大幅增加，很多祭司也选择坚信了耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","司提芬是一位满受恩惠、拥有上帝力量之人，在民众中施行很多惊人奇迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","但有人开始和他争论，其中有几人来自“自由”会堂，还有几名古利奈人、亚历山太人、基利家人和亚西亚人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","但司提芬所言有圣灵和智慧加持，众人无法占上风。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","于是他们唆使其他人，说：“我们听过他说过亵渎摩西和上帝的话！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","他们还煽动民众、长老、宗教老师，派人来捉拿司提芬，把他带到公议会， ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","然后提供假证供说：“这人总是在抨击圣殿和律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","我们听他说过：‘这拿撒勒人耶稣将破坏圣殿，改变摩西传给我们的律法。’” ");
INSERT INTO cmnfeb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","当时坐在公议会里的所有人都注视着他，他的面孔闪着光，如天使一般。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","大祭司问到：“这些指控是真的吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","司提芬说：“各位父老兄弟，听我说！我们的祖先亚伯拉罕当年还没有搬到哈兰时，曾住在美索不达米亚，荣耀的上帝就是在那个时候向他显现， ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","对他说：‘你要离开你的国家和民众，到我指示你的地方去。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","于是他离开迦勒底人的国家，搬到哈兰。他父亲去世后，上帝又叫他从那里迁到你们现在所住的地方。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","但上帝并没有在这里赐他产业，他甚至没有立足之地。但上帝承诺将赐予他和子孙田产，尽管那时他尚无子嗣。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","上帝还告诉他，他的后代将在异教徒国家居住，他们将会在那里被奴役、被虐待长达四百年。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","上帝说：‘我会惩罚那个奴役他们的国家，最终，他们会离开那里，来到这敬拜我。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","上帝还赐予他割礼之约。于是亚伯拉罕的儿子以撒在出生后第八天就行了割礼。随后，以撒诞下雅各，雅各是十二位族长的父亲。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","先人们因为妒忌约瑟，就把他卖到埃及为奴，但上帝与他同在， ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","救他于所有苦难之中，赋予他智慧，让他获得埃及王法老的偏爱。法老立他为主管，管理埃及和法老皇族的事务。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","后来埃及和迦南全境遭遇了一场大饥荒，先人没有办法获得食物。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","雅各听说埃及有粮食，于是派我们的祖先去，这也是他们的第一次造访。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","在第二次造访期间，约瑟向兄弟们表明了自己的身世，法老才了解了约瑟的家世。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","约瑟派人把自己的父亲雅各和所有亲戚接了过来，总计七十五人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","雅各来到埃及，然后和其他祖先一样，都在埃及去世。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","他们的遗体被运回示剑，埋葬在亚伯拉罕用银子从哈抹之子那里买来的墓地中。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","此刻已接近上帝对亚伯拉罕承诺的兑现时间，以色列人在埃及的人口越来越多。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","这时又一位新郡王开始统治埃及，他并不认识约瑟。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","他阴谋利用我们的同胞，虐待我们的祖先，逼他们拋弃自己的孩子，任由孩子死去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","就在那时候，摩西降生了。他生来俊美，在父亲家中被照顾了三个月。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","他被拋弃后，法老女儿把他捡了回去，当作儿子抚养。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","摩西接受了埃及人所有知识领域的教育，是一位强有力的演讲者和领袖。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","但到了四十岁那年，他决定去造访自己的同胞以色列人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","他看到一位同胞受到虐待，就跑过去为同胞伸张正义，打死了那个欺负人的埃及人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","摩西以为，他的以色列同胞们知道上帝将通过他拯救他们，但此时他们对此一无所知。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","第二天他来到这里时，看到两个以色列人在打架，便试图调和两人的争斗：‘嘿，你们是兄弟，为什么要攻击彼此呢？’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","但那挑起事端的男人把他推开，质问到：‘谁让你管我们的？怎么你成了我们的法官了？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","难道你想像昨天杀那个埃及人一样，杀了我吗？’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","听到这番话，摩西离开了此地，以流亡者的身份来到米甸地，在那里有两个儿子。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","四十年后在西奈山的荒野中，一位天使在燃烧的荆棘丛中向摩西显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","摩西见此非常惊讶，跑上前去想要仔细端详，这时就有主的声音说： ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘我是你祖先的上帝，就是亚伯拉罕、以撒、雅各的上帝。’摩西吓得战战兢兢，不敢抬头。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","主对他说：‘脱掉你的鞋，因为你站在圣地。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","我亲眼看到我的子民在埃及所受的痛苦，听到他们的悲鸣，现在我要到人间拯救他们。现在过来，我要派你到埃及去。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","就是这位摩西，当他们说：‘谁让你成为审判我们的领袖？’并因此而排斥他，上帝派天使在荆棘中向他显现，指定他成为领袖和救赎者。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","摩西在埃及和红海显现神迹后，便带领以色列人离开埃及，在随后的四十年中，又在荒野中继续显现神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","就是这位摩西，对以色列人承诺‘上帝要从你们中间选择一名像我这样的先知。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","当摩西和上帝召集的民众来到荒野中后，天使在西奈山上与他对话。就是在那里，他和祖先们一起亲自接受了上帝传递给我们的鲜活之语。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","就是这位摩西，我们的祖先不先信他，而是拒绝他，打算返回埃及。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","于是他们对亚伦说：‘为我们制作上帝的神像，因为我们不知道把我们从埃及领出来的摩西，到底发生了什么。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","然后他们制作了一个牛犊样子的神像，向其献祭，还因为自己做出来的东西而大肆庆祝！ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","于是上帝放弃了他们，任凭他们膜拜星辰，正如先知所写：‘以色列人啊，你们在荒野四十年中，可曾将祭牲和祭物献给我？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","没有，你们抬着摩洛的帐篷，还有理番之神的星星图像，你们把它们做出来然后膜拜它们。所以我要把你们放逐到巴比伦的另一边。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","我们的祖先在沙漠中有见证的帐幕。上帝谈话向摩西指示，如何按照上帝的计划行事。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","后来，我们的祖先与约书亚一起占领了这片土地，把帐幕也带到这里。在他们之前，上帝已将这片土地中的异教徒赶走。他们在这里一直居住到大卫的时代。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","大卫蒙受上帝的恩宠，请求为雅各的上帝找个居所。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","但为他修建圣殿的却是所罗门。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","但事实上，至高之神并没有住在我们为其建造的圣殿中，正如先知说： ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘主说：天是我的宝座，地是我的脚凳，你们又能为我建造怎样的居所呢？你为我造出的床，怎能让我安寝？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","这一切不都是出自我手吗？’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","你们这些心肠冰冷的傲慢之人呐！你们从不聆听！你们总是抗拒圣灵！你们的行为就和你们的祖先一模一样！ ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","哪位先知没有遭受你们祖先的迫害？先知预先告知那真正善良正义之人即将到来，于是就被杀害。现在，那善良正义之人又被你们背叛和谋杀。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","你们接受了由天使传达的律法，却不遵守。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","公议会的成员听闻此言，恼怒异常，咬牙切齿地向司提芬咆哮。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","但司提芬身体中充满圣灵，他目不转睛地望着天，看见上帝的荣耀，看见耶稣站在上帝的右边。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","他说：“看呐！我看见天已开启，人子站在上帝的右边。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","但众人却捂住了耳朵，大声喊叫着向他冲过去， ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","把他推出城外，用石头打他。那些谴责他的人把自己的衣服放在一个名叫扫罗的青年人脚前。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","司提芬在被他们用石头攻击时祈祷：“主耶稣啊，求你接收我的灵魂！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","然后跪下来大喊：“主啊，不要因这罪而惩罚他们！”说罢，他就死去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","扫罗也认可了对司提芬的杀戮。从那天起，耶路撒冷的教会受到严重迫害。除了使徒以外，其他信徒都散落到犹太和撒玛利亚各地。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","（有些虔诚之人怀着巨大的悲痛安葬了司提芬）。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","扫罗却开始残害教会，挨家挨户地将男男女女拖出去坐监。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","那些散落各地的信徒，会在所到之处传扬上帝之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","腓利来到了撒玛利亚城，向民众宣讲基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","群众听到腓利所讲，看见他所行神迹，于是便全心聆听他的一字一句。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","许多魔鬼附体之人得救了，他们身上的恶灵嚎叫着被驱赶出来，还有许多瘫痪和残疾之人都得到痊愈。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","城里的民众们欢天喜地。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","城里有一人名叫西门，善用邪术。他自称是一位重要的大人物，让撒玛利亚人为之而惊叹。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","城中之人无论高高在上还是卑微在下，都听从于他，说：“这就是那‘大能上帝’之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","因为他长久以来用邪术蒙蔽众人，让他们对之感到信服。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","腓利来此向他们传递上帝之国的福音，宣讲耶稣基督之名，于是众人相信了腓利，男女女女均受了洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","连西门自己也相信并受洗，然后跟随腓利，为所目睹的神迹和奇迹而惊叹不已。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","听说撒玛利亚的居民接受了上帝之道，耶路撒冷的使徒就派彼得和约翰到那里去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","二人赶到后就为改变信仰的信徒祷告，让他们接受圣灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","但圣灵尚未降在他们任何一个身上，他们只是以耶稣之名受了洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","使徒为他们行按手礼，他们便接受了圣灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","西门看见使徒按手后就有圣灵降临，就拿出钱给使徒， ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","他请求道：“把这力量也给我吧，让我为谁按手，谁就可以接受圣灵。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","彼得对他说：“让你的钱跟你一同灭亡吧！你居然以为上帝的恩赐可以用钱购买！ ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","你不属于这里，这里的一切也不属于你，因为在上帝眼中，你的态度大错特错。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","为自己的罪恶行径忏悔吧！祈求主，请求他原谅你这样的想法。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","我可以看出你心中满是强烈的嫉妒，被你的恶所捆绑。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","西门回答：“请为我求主，别让你们说的事情发生在我身上！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","使徒作了见证并宣讲了主的道，然后就返回耶路撒冷，沿途在撒玛利亚人的许多村庄里传扬福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","主的天使对腓利说：“准备好向南走，你要去耶路撒冷到迦萨的那条荒漠道路。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","于是腓利动身出发，路上遇到一名衣索匹亚人，是衣索匹亚女王干大基手下一名位高权重的官员，掌管女王全部国库。他去耶路撒冷去礼拜。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","在回来的路上，坐在马车上翻看以赛亚先知的书。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","圣灵对腓利说：“走过去，走近那车子。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","于是腓利跑过去，听见那官员在读以赛亚先知的书，就询问：“你明白自己看到的内容吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","那官员说：“没有人指导，我怎能明白呢？”于是就请腓利上车，坐在他身边。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","他当时在读的那段经文是：“他像绵羊一样被牵走宰杀，又像羔羊一样在剪羊毛之人面前沉默无声，他一句话也不说。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","他受尽屈辱，得不到公平的审判。没有人知道他的后裔会是谁，因为他的生命走向终点。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","那官员对腓利说：“请问先知这番话是在说谁？他自己？还是指别人？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","腓利开始解释，从这段经文开始，向他传讲耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","他们一路走下去，来到一处溪流，官员说：“你看，这里有水，为什么我不受洗呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","于是官员吩咐停车，腓利和他两人走到水中，腓利给他施洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","他们从水里出来时，主的圣灵就把腓利带走了，送到了亚锁都。官员再也没有见到他，但仍满心喜悦地继续旅程。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","腓利在亚锁都走遍各城，传讲福音，最终来到该撒利亚。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","与此同时，扫罗仍在暴力威胁着主的使徒，想要杀死他们。他到大祭司那里， ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","要大祭司提供授权函，扫罗想要送到大马士革的各会堂，在发现奉行此道之人后，无论男女，都准许扫罗将其缉拿，带回耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","快到大马士革的时候，他周围忽然被来自天堂的光照亮。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","他伏倒在地，听见有声音对他说：“扫罗啊，扫罗！你为什么迫害我？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","他说：“主啊，你是谁？” 主说：“我就是你所迫害的耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","起来吧，到城里去，会有人告诉你应当做什么。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","与扫罗同行的人听见了声音，却看不见人影，于是站在那里说不出话来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","扫罗从地上爬起来，睁开眼睛后却什么也看不见。随行的人牵着他的手，领他进入大马士革。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","随后三天，他什么也看不到，不吃不喝。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","大马士革有一名叫亚拿尼亚的使徒，主在异像中唤他：“亚拿尼亚！” 他说：“主啊，我在这里。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","主说：“起来到直街去，在犹大家里找一位来自大数的人。他叫扫罗，现在正在祷告， ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","他在异象中看见一位名叫亚拿尼亚的人，过去为他按手，让他可以再次看得见。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","但亚拿尼亚回答：“主啊，很多人都说起过这个人，他在耶路撒冷做了许多迫害你信徒的事， ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","祭司长还给了他权力，逮捕所有膜拜和追随你的人。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","但主对他说：“去吧，我已选中此人，把我的名传给异教徒、君王和以色列人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","我会向他显示，为了我之名，他不得不受苦。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","于是亚拿尼亚出发去了那栋房子，为扫罗按手，说：“扫罗兄弟，主耶稣在你来的路上已向你显现，他派我来让你可以重见光明，可以被圣灵充满。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","话音刚落，扫罗的眼里立刻掉下来鳞片一样的东西，然后他就恢复了视力，然后起身接受施洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","他还吃了些东西，感觉有些力气了，之后他和大马士革的使徒同住了几天。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","然后，他立刻在各会堂宣讲耶稣，说“耶稣是上帝之子。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","众人听此都感到很惊讶，说：“他不是在耶路撒冷迫害那些相信耶稣的人吗？他来这里，不是为了捉拿信徒，然后交给祭司长吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","但扫罗变得越来越有信心，以强有力的方式证明耶稣就是基督，住在大马士革的犹太人完全无法与他辩论。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","过了一段时间后，犹太人商议要杀掉他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","但扫罗知晓了他们的阴谋。犹太人在各城门处日夜把守，打算除掉他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","于是在一天晚上，他的门徒从城墙的一个开口处，用大篮子把他顺了下去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","扫罗来到耶路撒冷后想要见其他门徒，但大家都怕他，不相信他也是个门徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","但巴拿巴带着他去见其他门徒，还帮他解释了如何在路上看见主、主如何与他说话，以及扫罗如何在大马士革以耶稣之名传道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","于是扫罗与其他门徒待在一起，与他们走遍耶路撒冷， ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","以主之名勇敢讲道。他与说希腊语的犹太人讲述辩论，那些人却想杀了他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","他的兄弟们得知这件事，就把他带到该撒利亚，派他往大数去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","当时位于犹太、加利利、撒玛利亚各处的教会都太平无事。这些教会越来越强大，人数也越来越多，因为信徒们在圣灵的鼓励下，为主过着虔诚的生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","彼得周游各地过程中，去造访吕大的信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","在那里他遇见了以尼雅，此人瘫痪在床已经整整八年。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","彼得对他说：“以尼雅，耶稣基督让你痊愈了！起来，拿好你的垫子！”以尼雅立刻站起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","吕大和沙仑的所有居民看见以尼雅，于是就成为了主的信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","在约帕有一个名叫戴比莎（希腊语为多加）的女信徒，为人一向乐善好施。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","但在那时候她因病去世，人们把她洗净后安置在楼上。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","吕大与约帕距离不远，门徒们听说彼得在那边，就派两个人去求他，说：“请立刻到我们这边来。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","于是彼得动身跟他们前去。来到这里后，他们把他带上楼。所有寡妇都在那里哭泣，把多加在世时给她们做的衣服拿给彼得看。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","彼得让大家都出去，然后跪下来祷告，接着转过身对那具尸体说：“戴比莎，起来吧！”她睁开眼睛，看见彼得后就坐了起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","彼得伸手扶她起来，然后叫来信徒和寡妇，活生生的多加就出现在他们面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","这事传遍了约帕，很多人便信了主。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","彼得在约帕的制皮匠西门家里住了很久。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","在该撒利亚有一人名叫哥尼流，是意大利营的罗马百夫长。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","他为人虔诚，与全家人一起敬拜上帝，对穷人非常慷慨，经常向上帝祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","一天大约下午三点钟时候，他在异象中清楚看到上帝的一位天使来到他身边，呼唤他：“哥尼流！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","他很害怕地盯着天使看，然后问到：“主啊，你想要干嘛？”天使说：“上帝注意到你的祷告和善行，看到了你对穷人的慷慨。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","现在派人到约帕去，把一个叫做彼得的人带过来，他还有个名字叫西门。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","他在海边制皮匠西门的家里做客。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","待与他说话的天使走后，他就叫来两个家仆和他的一名私人护卫，也是一名虔诚的信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","他把一切解释给他们听，然后派他们到约帕去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","第二天，他们即将接近那座城的时候，彼得爬上屋顶去祷告。中午时分， ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","彼得觉得饿了，想要吃点东西。就在准备午餐的时候，他忽然感到一阵恍惚， ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","然后便看见天空开启，有什么东西降落在下面，仿佛是一大块四角绑住的布， ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","里面可以看到各种各样的动物、昆虫和飞鸟。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","一个声音对他说：“彼得，起来吧，把它们宰杀后食用！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","彼得说：“主啊，万万不可！我从不吃不纯不洁的食物。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","那声音又对他说：“上帝已让它洁净，不可称其不洁！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","这样的异象重复了三次，然后那块布立刻被收回天空。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","彼得感到很困惑，不知这异象到底意味着什么。此时哥尼流派来的人找到西门所在的房子，站在门口， ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","他们高喊，询问这里是否有一个名叫彼得或西门的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","彼得还在想着那异象，圣灵对他说：“看，有三个人来找你。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","起来，到楼下和他们走吧。完全不要担心，因为他们是我派来的。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","于是彼得下楼与他们相见，说：“我就是你们所要找的人。为什么你们会来这里？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","他们说：“百夫长哥尼流派我们前来。他是一位敬畏上帝的善良之人，犹太人民都很敬重他。一位圣天使给他指示，请你到他家中，让他聆听你的宣讲。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","彼得邀请他们进屋住下。 第二天，彼得和来自约帕的几名兄弟与他们一起离开。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","一行人在第二天来到该撒利亚，此时哥尼流已经找来亲朋好友迎接他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","彼得走进房屋后，哥尼流迎上来，俯伏在他脚前叩拜。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","彼得把他扶起，说：“起来，我不过是凡人而已！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","彼得和他说了几句话就走了进去，看见许多人聚集在那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","他对众人说：“你们当然知道，犹太人本来不准与异教徒有联系或彼此探访，但上帝已经指示我，不可把任何人视为不纯或不洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","所以我受邀后就立刻毫不推辞地来了。那么现在我想知道，你要我来所为何事？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","哥尼流说：“四天前下午三点钟，我在家里祷告时，忽然有一人站在我面前，身上的衣服发着明亮的光。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","那人对我说：‘哥尼流，上帝已听到你的祷告，他已看到你对穷人的慷慨。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","派人到约帕去找一位叫做彼得的人过来，他现在住在制皮匠西门位于海边的家中。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","所以我就立刻派人去请你过来，所以此刻我们都能在这里，在上帝面前相聚，准备聆听主吩咐你的一切。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","彼得回答：“我非常确信上帝从不偏袒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","无论哪个民族，只要尊重上帝，行事善良正义，就会被上帝所接纳。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","你们知道，上帝借耶稣基督，也就是万物之主，传播和平的福音，将这道传递给以色列人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","你们知道，约翰呼吁大家受洗之后，这道就从加利利传遍了犹太。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","这是关于拿撒勒人耶稣的道，讲述了上帝如何用圣灵和力量选定他，进行膏立。讲述了他如何四处行善，治愈所有被魔鬼控制之人，因为上帝与他同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","对于他在犹太人之地和耶路撒冷所行一切，我们就是见证人。他们把他钉上十字架，谋害了他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","但上帝让他在第三天复活并显现， ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","不过并非显现给所有的人，而是显现给上帝所选的见证人，包括我们这些在他死而复生后，与他一起吃喝之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","他让我们承担向民众传道的使命，证明他就是上帝选来审判活人和死人的主。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","他就是所有先知所言之人：信他之人的罪就会以他之名得到赦免。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","彼得说话的时候，圣灵降临到所有听道民众的身上， ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","与彼得一同前来的犹太人信徒非常震惊，因为异教徒也能获得圣灵之礼。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","他们能听懂用方言说的话，一起赞美上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","彼得问：“既然这些人已经和我们一样接受圣灵，谁又能阻止他们接受水的洗礼呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","然后，他就吩咐以耶稣基督之名为他们施洗。随后，众人请彼得在此再多住几天。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","其他门徒和住在犹太的兄弟们，也听说了异教徒接受上帝之道的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","彼得返回耶路撒冷后，那些信守割礼的人就此与他争论。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","他们说：“你竟然进入未受割礼之人的房屋，跟他们一起吃饭！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","彼得就把所发生的一切讲给他们听： ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“我在约帕城祷告的时候，恍惚间见到异象，天上降下一个东西，好像一块绑着四角的大布，落在我的面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","我看到布里面有动物、野兽、昆虫和飞鸟。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","我听见一个声音对我说：‘彼得，起来吧，把它们宰杀后食用！’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","我说：‘主啊，万万不可！我从不吃不纯不洁的食物。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","那天上的声音回答：‘上帝已让它洁净，不可称其不洁！’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","这异象重复了三次，然后所有一切就被收回天上。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","就在那时，该撒利亚派来找我的三个人，站在我住的房子门前。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","圣灵告诉我与他们同去，不要担心他们是谁。这六位兄弟也与我随行，我们到了哥尼流的家。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","他向我们解释如何看见天使站在他家里，对他说：‘派人到约帕去，请彼得前来， ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","他有话要告诉你，可以让你和全家获得救赎。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","当我开始讲话，圣灵便落在他们身上，与当初降在我们身上一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","于是我想起主所说的：‘约翰用水施洗，但你们要接受圣灵的施洗。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","我们相信主耶稣基督，所以上帝就像对我们一样恩赐他们，我又有何力量阻止上帝？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","众人听闻这番解释，无语辩驳，开始赞美上帝，说：“看来上帝也赐予异教徒悔改和永生的机会。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","司提芬被迫害而被处死后，受到影响的信徒逃亡到了腓尼基、塞浦路斯和安提阿，然后只向犹太人传道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","有些塞浦路斯人和古利奈人信徒逃到安提阿后，也开始对希腊人传讲主耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","主的力量与他们同在，所以信主和信他的人数量众多。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","这事传到耶路撒冷的教会，他们就派巴拿巴去安提阿。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","但当巴拿巴到了之后，看见上帝恩典的成果，倍感喜悦，于是鼓励众人用真心真意奉献主。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","巴拿巴是一位善良之人，充满圣灵和信心，于是许多人归信了主。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","后来他到大数去找扫罗， ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","在找到后就把他带到安提阿。在随后的一年中，他们一同在教会聚集众人，对他们进行教导。从安提阿开始，信徒们开始被成为“基督徒。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","就在这段时间，有几位先知从耶路撒冷来到安提阿。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","其中一位叫做亚迦布的先知站起来，借助圣灵给出警示预言：整个世界将出现一次严重的大饥荒，（这个预言在革老丢时期果然成真了。） ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","于是信徒们决定根据各人的力量捐款，帮助住在犹太的兄弟。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","他们在捐款后，让巴拿巴和扫罗把钱送到长老那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","当时君王希律开始迫害教会成员。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","他用剑处决了约翰的哥哥雅各， ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","由于此举受到了犹太人的支持，于是他又在除酵节期间捉拿彼得。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","他们逮捕了彼得后将其投入监牢，由四班士兵看守，每班四个人。君王希律打算逾越节过后，就对他进行公审。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","彼得在监牢期间，教会开始为他虔诚地祈求上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","就在希律打算将他公审的前一夜，彼得被安排睡在两名士兵中间，手腕上的两条锁链分别与两人栓在一起，还有卫兵守在门前。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","忽然，一名天使出现，光芒照亮了牢房。天使将彼得唤醒，说：“快点！起来吧！”于是彼得手上的锁链就脱落了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","天使对他说：“穿上衣服和鞋！”彼得照做了。天使又对他说：“披上外衣，跟我走！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","于是彼得就跟着天使走出去，但他只是以为看到了异象，没有意识到天使所做的一切都在真实发生。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","他们经过第一队和第二队守卫，来到通往城内的铁门，门便自动给他们打开。他们出来后沿着街道行走，天使忽然就离开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","彼得这时候才明白，说：“现在我知道怎么回事了！主派天使将我从希律的权势中拯救出来，让我躲过犹太人的阴谋。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","明白这一切，他就到约翰（又名马可）的母亲玛利亚家中，很多信徒聚在那里祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","彼得敲了敲大门，一位名叫罗大的侍女出来准备开门。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","但认出是彼得的声音后，她兴奋的顾不上开门就跑进屋，大声喊：“彼得就在门外！。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","大家说：“你疯了！”她却坚持地说这是真的。他们说：“那一定是他的天使！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","彼得继续敲门，他们最终打开了门，一见是他，非常惊讶。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","彼得向他们举起手示意安静，然后对他们解释主如何带他走出监牢。他又说：“把这事告诉雅各和众兄弟。”然后就离开去往别处了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","天亮的时候，士兵们惊慌不已，不知彼得去了哪里。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","希律开始四处搜索他，但始终没有找到。于是就审问卫兵，然后下令把他们处死。随后希律便离开犹太去往该撒利亚，在那里住下。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","此刻的希律对推罗和西顿人充满了愤怒。这两个地方的人派了一个联合代表团来见他，设法拉拢了国王的个人助理伯拉斯。这个代表团希望向希律求和，因为这两地在粮食供应商都依赖希律的国家。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","到了约定见面的日期，希律穿上国王的长袍，坐在王座上，向众人讲话。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","人群中有人大声说：“这是上帝的声音，不是人的声音！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","但由于他没有将荣耀归于上帝，主的使者将他击倒。 他被虫吃掉了，死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","但上帝之道却开始传播，信徒的数量越来越多。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","巴拿巴和扫罗完成了送捐款的任务，就带着约翰马可 从耶路撒冷返回。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","在安提阿教会中有几名先知和教师：巴拿巴、西门（尼结）、古利奈人路求、马念（君王希律儿时的伙伴）和扫罗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","他们在膜拜主并进行禁食的时候，圣灵说：“让巴拿巴和扫罗为我做事。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","教会成员禁食、祈祷并把手放在他们身上祝福之后，他们就送他们上路了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","巴拿巴和扫罗在圣灵的指引下去了西流基，从那里乘船去往塞浦路斯。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","来到撒拉米后，他们就在犹太人的会堂中宣讲上帝之道，约翰担任他们的助手。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","他们走遍整个岛屿，最终来到了帕弗，遇见一位自称巴·耶稣的犹太人术士，是个假先知。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","他与省长士求·保罗走的很近。这位省长非常睿智，特别邀请巴拿巴和扫罗来为他讲上帝之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","但这位术士（希腊名字叫做以吕马）不接受他们，试图让省长不要相信上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","但被注满圣灵的扫罗（又名保罗）定睛看着他， ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","说：“你这满心欺诈、万恶满盈之人，魔鬼之子，正义的敌人！你总是在阻碍主的真理之路，为什么你不肯放弃呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","看，主的惩罚已经到来，你将成为盲人，暂时看不见阳光。”黑暗和迷雾立刻笼罩着这位术士，他不得不找人牵他的手，给他领路。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","省长看见眼前的一切，便信了上帝，主的教导让他惊讶不已。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","然后保罗和同伴从帕弗乘船来到旁非利亚的别加，约翰则离开他们返回耶路撒冷去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","他们一路前行，经过别加后抵达彼西底的安提阿，在安息日这天进入会堂，然后坐下来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","他们朗读了律法和先知的书籍，会堂首领派人传来口信，说：“兄弟们，如果你们有什么鼓励之语，就说说吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","保罗站起来，伸手示意大家看过来，然后开始说：“以色列人和所有敬畏上帝之人，听我说。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","我们的祖先寄居在埃及的土地时，以色列人民的上帝选中了他们，凭其伟大力量带领他们走出埃及， ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","然后他在旷野耐心地照顾他们四十年。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","上帝在消灭了迦南七国后，就把那片土地分给以色列人的祖先，让他们代代继承，这样又过了 450 年。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","后来上帝又为他们派来首领，一直持续到撒母耳先知的时刻。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","人们请求上帝为他们送来国王，上帝就把便雅悯部落中一个人派来为王，他是基士的儿子扫罗，统治了四十年。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","之后上帝又废去扫罗，选择大卫为王。在为大卫作证时，上帝说：‘我找到耶西的儿子大卫，他符合我的心意，将遵行我的一切旨意。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","耶稣是大卫的后裔，是上帝之前承诺带给以色列的救世主。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","耶稣来临之前，约翰便昭告所有以色列人应该进行忏悔洗礼。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","约翰即将完成他的使命时说：‘你们以为我是谁？我不是你们所寻找的那个人。但在我之后来的那个人，我就是给他解鞋带都不配。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","兄弟们、亚伯拉罕的子孙以及敬畏上帝的众人，这救赎之道已传授给我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","住在耶路撒冷的众人和他们的长官，他们不认识基督，也不理解安息日所读的先知之语。事实上，他们为耶稣定罪恰好应验了先知的预言。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","尽管他们无法找到宣判他死刑的罪状，但还是要求彼拉多杀害他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","预言中关于他们会对耶稣所做的一切，都应验了。然后他们把耶稣从十字架上取下并埋葬在坟墓中。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","但上帝却使他死而复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","多日后，他显现在那些从加利利到耶路撒冷一路跟随他的人面前，那些人现在就成了他在民众面前的见证者。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","我们来此是向你们传递福音，通过耶稣的复活，上帝向我们祖先的承诺 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","都已向我们这些子孙应验了。就如《诗篇》第二篇所记：‘你是我子，今日我成为你父。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","上帝使他死而复生，不会再死去。他曾这样说：‘正如我向大卫所做的承诺，我所赐予你们的，神圣而值得相信。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","《诗篇》 还说：‘你不会允许圣者见到腐朽。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","但大卫在自己的世界中完成了上帝派给他的使命后，就死去了，与他的祖先葬在一起，躯体也腐朽了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","唯独上帝令其复活这一人，没有看到腐朽。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","兄弟们，我希望你们理解我们正在讲述的一切，通过这个人，罪已经得到了宽恕。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","通过这个人，所有信他之人都会远离错误，实现道德正义， 但凭着摩西的律法，你永远都无法达到这种正义。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","务必不能让先知在书上所说降临在你们身上： ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘傲慢的人呐！你们会惊奇地看到，然后死去！因为我在你们生命中所做的事情，即使有人向你讲述，你也永远都无法相信！’” ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","保罗和巴拿巴打算离开，众人请他们在下一个安息日再来讲述更多。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","这次会堂的聚会结束后，许多犹太人和归信犹太教的虔诚教徒，都跟随了保罗和巴拿巴。两人和他们交流，鼓励他们始终紧随上帝的恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","到了下一个安息日，几乎全城的人都赶来，希望聆听上帝之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","犹太人看见这攒动人群，感到异常嫉妒，于是开始驳斥保罗所讲之道，诅咒他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","保罗和巴拿巴却强有力地回应：“我们必须先向你们讲述上帝之道。既然你们拒绝这道，就代表你们觉得自己不配获得永生，所以我们现在要去异教徒那里去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","主吩咐过我们说：‘我让你们成为异教徒的光，你们将把拯救带到世界的尽头。’” ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","异教徒听见这个消息分外欢喜，赞美主之道，所有被选为永生之人都相信了上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","上帝之道就这样传遍那个地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","但犹太人教唆虔诚的尊贵女性和城中的首领，煽动大家迫害保罗和巴拿巴，把他们驱逐出境。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","于是两人当众跺掉脚上的尘土以示抗议，向以哥念走去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","而信徒们继续满心欢喜并被圣灵充满。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","在以哥念发生了相同的事情。保罗和巴拿巴来到犹太人的会堂讲道。他们的言语如此令人信服，很多犹太人和说希腊语的朝拜者都相信了耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","但那些拒绝相信耶稣的犹太人，却去煽动异教徒的情绪，毒害他们的心，让他们反对信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","但保罗和巴拿巴在那里停留了很久，以主为名勇敢传道，主也通过他们实现了神迹奇事，以此证实他的恩典之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","于是城里民众分成了两派，一派服从犹太人，一派支持使徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","但随后异教徒、犹太人以及他们的首领，决定攻击保罗和巴拿巴，用石头打他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","但两人发现了这个阴谋，于是逃到吕高尼地区，来到路司得和特庇这两座城， ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","在那里传递福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","路司得城有一个残疾人，双脚都动不了。他生下来就瘸腿，从未走过路。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","他坐在那里听保罗讲道。当保罗看向他，发现相信上帝可以将他治愈， ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","于是保罗大声说：“用你的双脚站起来吧！”那人就跳起来，开始行走。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","目睹保罗所为，众人用吕高尼语大声说：“上帝以人的样子降临到我们中间！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","于是他们称巴拿巴为希腊神宙斯，称保罗为赫米，因为大部分时候都是保罗在讲话。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","城门外一座宙斯庙的祭司，牵来几头公牛、手拿花环来到城门处，打算在众人面前进行献祭。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","但巴拿巴和保罗两个使徒听说这个消息，便撕开衣服，跳进民众中大喊： ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“各位，怎么能这么做呢？我们也是人，天性与你们一样，我们来此向你们传递福音，就是为了让你们远离这些毫无意义的事，归从永生的上帝，就是那位创造天地大海和世间万物的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","在过往的世界里，他允许各国各行其道， ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","尽管如此，他仍然通过行善事留下证明，向你们送来天堂之雨和四季的作物，为你们提供所需的食物，为你们心中带来快乐。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","这番话勉强说服了众人，不再向他们献祭。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","但有些来自安提阿和以哥念的犹太人，成功挑唆民众用石头打保罗，然后以为他死了，就把他拖到城外。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","但就在信徒们围着他时，他竟然站起来，走回了城里。第二天，他跟巴拿巴一同到特庇去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","他们在那里向众人传递福音，让许多人都成为信徒，然后他们又回到路司得、以哥念和安提阿。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","他们鼓励信徒坚定信念，守住心中对耶稣的信，他们说：“只有经历诸多苦难，我们才能进入上帝之国。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","两人为每个教会指派了长老，然后与众人一起祈祷和禁食，之后就将他们交给所信的主，受到主的关怀， ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","然后经过彼西底来到旁非利亚。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","在别加讲道以后，他们又继续去往亚大利， ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","从那里坐船返回安提阿，那里是他们旅程的起点，也是在那里受到上帝的恩典，致力于完成自己的使命，如今使命已经达成。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","他们抵达目的地后就召集教会的众人，讲述了上帝通过他们所做的一切，以及他如何向信他的异教徒敞开大门。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","随后两人与信徒们一起生活了很久。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","有几个来自犹太的人开始教授信徒。他们对信徒们说：“你们若不按照摩西定下的规矩行受割礼，就无法获得救赎。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","保罗和巴拿巴与他们进行了激烈的辩论，于是众人指派他们和其他几个人去耶路撒冷，向信徒和长老们讲述这个问题。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","教会为他们送行后，他们便上路了。途径腓尼基和撒玛利亚，讲述异教徒如何改变信仰，这让所有信徒都很高兴。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","来到耶路撒冷后，教会、信徒和长老们接待了他们，他们也报告了上帝通过他们所行的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","但有几名法利赛派的信徒却提出了反对意见，他们说：“这些归信上帝的异教徒必须行割礼，教导他们遵守摩西的律法。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","使徒和长老聚集在一起商讨此事。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","在进行了大量辩论后，彼得站起来对他们说：“兄弟们，你们知道过去上帝在你们中间选择了我，就是为了让异教徒可以听到福音之道，相信耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","那洞察我们思想的上帝也表明接受他们，就像对待我们一样向他们赐以圣灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","上帝绝不会将我们和他们区别对待。因为他们相信上帝，所以上帝洁净了他们的思想。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","现在你们为什么要反对上帝，把我们祖先和我们都无法承受的重负，放在这些信徒的身上？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","我们确信承蒙主耶稣的恩典获得救赎，与他们有着同样的方式。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","巴拿巴和保罗述说了上帝通过他们在异教徒中所行的神迹奇事，所有人都专心聆听。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","他们讲述完后，雅各说：“兄弟们，请听我说！ ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","刚才西门讲述了上帝如何显示他对异教徒的关心，从他们中间挑选一名鉴定信仰上帝之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","这符合了众先知所写下的问题，正如经上所记： ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘未来我要回归，重建大卫崩塌的宅邸，在废墟上将其重建，让它重新站立起来， ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","我这样做，是为了让剩下的人可以追随主，包括所有呼唤我名的异教徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","这就是主的真言，他很久以前就昭示了这一切。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","所以我认为，不应该为难那些归信上帝的异教徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","我们应该给他们写信，告诉他们不吃祭祀偶像的食物、不要淫乱、要避开勒死的牲畜和血。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","因为很久很久以来，各地都在教导摩西所写律法，每逢安息日，都会有人在会堂中诵读。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","使徒、长老和教会所有人都认可这个方法，于是他们决定选出几名代表，派他们和保罗、巴拿巴一同到安提阿去。最终选择的人是犹大（巴撒巴）和西拉，他们是信徒中的领袖。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","他们被派出去送信。信上说： “安提阿、叙利亚和基利家的非犹太异族兄弟们，这里是来自使徒、长老和信徒们的问候。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","听说我们中有些人在向你们讲道时，让你们感到困扰和不安，其实我们并没有吩咐他们这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","因此，我们一致同意选出几名代表，与我们挚爱的巴拿巴和保罗一起派去见你们， ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","这两个人曾为了主耶稣基督之名，置个人生死于不顾。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","我们派犹大和西拉同行，他们会亲口确认我们所说的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","圣灵和我们都认为，除了以下重要的要求，最好不要让你们承担更多重负。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","你们应该避免的是：不吃祭祀偶像的食物，要避开勒死的牲畜和血，不要淫乱。只要遵守这些要求就好了。上帝保佑你们！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","还有人被派到安提阿，在那里召集众人，交上这封书信。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","众人读罢，因信上的劝勉之语而感到欣慰。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","犹大和西拉也是先知，他们说了许多鼓励兄弟们的话，让他们获得了更大的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","住了一段时间后，他们打道回府，带走了众人向耶路撒冷信徒送去的祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","但保罗和巴拿巴却住在安提阿，与众人一起进行教导，传播主之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","过了一段时间，保罗对巴拿巴说：“我们回到曾经传道的那些城邦去吧，看看那里的信徒们现在如何了。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","巴拿巴打算带上约翰马可一同去， ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","但保罗认为带上他不合适，因为他当年在旁非利亚时曾经离开过他们，没有继续与他们一起完成自己的使命。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","两人为此大吵一架，于是分道扬镳。巴拿巴带上马可，乘船去塞浦路斯。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","保罗则选了西拉，当他们离开时，信徒们将他们交托给主的恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","保罗走遍了叙利亚和基利家，鼓舞那里的教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","保罗先去了特庇，然后又到了路司得。在那里有一位名叫提摩太的信徒，其母亲是犹太基督徒，父亲则是一名希腊人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","提摩太在路司得和以哥念的兄弟中名声很好， ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","保罗希望带上他一同旅行，但由于当地的犹太人都知道他父亲是希腊人，所以他给他行了割礼。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","他们随后便一起去往其他城市，向其他信徒们讲述耶路撒冷使徒和长老所定下的规矩。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","众教会更坚定地相信主，信徒的数量与日俱增。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","由于圣灵阻止他们在亚西亚传道，于是他们就走遍了弗吕家和加拉太地区。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","来到每西亚边境时，他们打算去庇推尼，但耶稣的圣灵不允许他们进入这座城市。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","于是他们经由每西亚来到特罗亚。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","保罗在夜里看到了一番异象，一名马其顿人站着恳求他说：“请到马其顿来帮帮我们！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","保罗见此异象后，我们认为上帝在召唤我们去那里传播福音，于是立刻安排了去往马其顿的行程。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","我们从特罗亚乘船直接去了撒摩特拉，第二天又赶往尼亚波利， ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","从那里去了腓立比，这也是马其顿最重要的城市，同时也是罗马的殖民地，然后在城里住了几天。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","安息日那天，由于考虑到人们会到河边祈祷，所以我们出了城去往河边，然后坐下，与聚集在那里的妇女交流。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","其中一位妇女名叫吕底亚，在推雅推拉城众售卖紫色布料，敬仰主的她专心聆听我们的话语。主开启她的心灵，让她留心保罗的言语，接受了他对她的教诲。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","她和家人受洗之后，就恳请我们：“你们如果认为我是对主一心一意，就请到我家来住吧。”她坚持邀请我们，直到我们答应了这个请求。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","有一天，我们正在去往祈祷的场所，路上遇到一名被恶灵附体的婢女。她因为擅长占卜，为她的主人们赚取丰厚收入。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","这婢女跟在我们身边，大声喊：“这些人是至高上帝的仆人，向你们宣讲如何获得救赎。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","她一连几天都这样做，保罗感到不胜其烦，于是转身对那恶鬼说：“以耶稣基督之名，命令你从她身上出来！”那恶鬼就离开了她的身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","但她的主人们看见自己的财路断了，就拉着保罗和西拉去见集市上的长官， ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","他们将两人带到裁判官面前，说：“这些犹太人人正在扰乱我们的城市。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","对于我们罗马人而言，接受或践行他们所鼓吹的事情，是不合法的。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","民众纷纷攻击他们，裁判官剥去他们的衣服，下令对他们施以棍刑。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","用棍子打了他们以后，就把他们投入监牢，吩咐狱卒看住他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","狱卒遵命把他们押入内部的牢房，将他们的两脚拴在木柱上。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","大约午夜时分，保罗和西拉向上帝祈祷并唱起颂歌，引来其他囚犯们侧耳听着。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","忽然发生了大地震，震撼了监牢的地基，所有的牢房门立刻打开，囚犯身上的锁链也脱落了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","狱卒醒来后发现牢门全开，以为囚犯都已逃脱了，便拔出刀来想要自刎。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","保罗大喊：“别伤害自己，我们都在这里！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","狱卒叫人拿来灯，然后冲了进去。看到保罗和西拉，便全身颤抖着俯伏在他们面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","随后他便护送二人出了监牢，问到：“先生们，我该怎样做才能得救？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","他们说：“相信主耶稣，你和全家人就会获得救赎。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","然后，他们就开始向他和全家人宣讲主之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","尽管当时已是深夜，狱卒还是为使徒清洗伤口，然后和家人一起受了洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","他将使徒们带回家中，为其准备饭菜，他和全家因相信上帝而获得极大的喜悦。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","第二天清晨，裁判官派法警来找狱卒，说：“放了那些人。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","狱卒对保罗说：“裁判官派人来释放你们，现在你们可以平安地离开了。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","但保罗对他们说：“我们是罗马人，但他们在没有审判的情况下就公开殴打我们，将我们投入监牢，现在又想让我们悄悄地走？不行！他们应当亲自来释放我们！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","法警回去报告，裁判官听说保罗和西拉是罗马人，感到很害怕， ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","于是跑来向他们道歉，亲自护送他们出了监牢，恳请他们离开这座城。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","两人离开监牢后去了吕底亚的家，在那里见到了其他信徒，鼓舞他们一番后便离开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","保罗和西拉沿途经过了暗非波里和亚波罗尼亚，来到帖撒罗尼迦，那里有犹太人的会堂。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","保罗按惯例走进会堂，一连三个安息日，都在这里根据圣经与他们进行辩论。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","他解释了经文的含义，证明基督必须先死去后，然后再死而复生。他对众人说：“我向你们讲述的这位耶稣，就是基督。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","有的人被保罗和西拉说服了，加入了他们的行列，此外还有很多说希腊语的朝拜者，以及城里位高权重的女性。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","但犹太人却因此而倍感嫉妒，于是从集市中找来一群流氓，凑成团伙在城里面闹事。他们冲进耶孙的家中，到处寻找保罗和西拉，要把他们交给民众。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","但由于找不到这两名使徒，他们就把耶孙和几名信徒带到地方长官那里，叫嚣着说：“这些人素有滋事的恶名，把这世界闹得天翻地覆。现在他们来到这里， ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","耶孙却在自己的家宅中招待这些人。他们都违背凯撒的法令，说另外还有一个王叫做耶稣，这就是叛国罪。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","民众和地方长官听到这番话，深感不安， ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","让耶孙和其余人交了保释金后，就放了他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","信徒们当晚就将保罗和西拉送走。二人去了比里亚，到达后便走进犹太人的会堂。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","这里的民众比帖撒罗尼迦人开明，他们很快就接受了主的道，每天研读圣经，确认他们所听到的是否正确。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","很多人因此成为信徒，包括地位高贵的希腊男性和女性。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","但帖撒罗尼迦的犹太人听说保罗又在比里亚宣讲上帝之道，便跑到那里煽动挑拨民众。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","信徒们立刻把保罗送到海边，西拉和提摩太仍然留在比里亚。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","护送保罗的人将他远远地带到雅典，保罗在他们返回的时候，给西拉和提摩太带去口信，让他们尽快赶去与他会和。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","保罗在雅典等他们的时候，看见满城都是宗教神像，心中感到非常不安。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","于是在会堂中与犹太人和其他崇拜上帝之人进行了辩论，此外还每天到集市中去，与所遇到的陌生人进行辩论。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","有些伊壁鸠鲁派和斯多亚派的哲学家也同他争论。他们想知道：“这个人到底想要干什么？”由于保罗谈论了耶稣和复活，所以还有人认为：“他似乎是在宣讲外族的神。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","于是他们把保罗带到亚略巴古，询问他：“请和我们讲讲你所宣扬的那个新教义？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","我们听说了你讲的那些事情，听起来太奇怪了，所以我们想知道那到底是什么意思。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","（所有雅典人和住在那里的异教徒，都非常喜欢谈论和打听新奇之事，以此打发时间）。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","保罗站上亚略巴古的中间，说：“各位雅典人，我发现你们对任何事情都抱有虔诚之心。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","我走路的时候曾留意你们的圣坛，曾有一个圣坛上写着‘献给未知的神’。我要向你们讲述的上帝，就是你们所膜拜的这个未知之神。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","上帝创造世界和世间万物，他是天地的主，并未生活在人类建造的庙宇之中， ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","他什么都不需要，也不需要我们的服务，因为他本身就是所有生灵的生命之源。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","他从一个最初的人创造了世界上的所有人，在之前就决定了他们应该生活在哪里，应该活多久。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","上帝想要的是他们能够追寻上帝，能够去寻找并找到他。但其实他离我们每个人都不遥远。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","我们在他的护翼下生存、活动和存在。正如你们的诗人写到：‘我们就是他的家人。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","正因为我们是他的家人，所以不应该将上帝想象成金银石头，然后由人类用手艺和思想将其塑造形象。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","上帝原谅了人类过往的无知，但现在，他吩咐各处的所有人都要悔改， ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","因为他已经定好时间，届时将由他指认的那个人，对世间进行正义审判。为了向众人证明他就是那个人，上帝会让那人死而复生。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","众人听到死人复活这句，便开始嘲笑他。但也有人说：“以后请回来，给我们多讲讲这件事。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","于是保罗就离开他们了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","有几个人跟随了他并且相信了上帝，包括亚略巴古的成员丢尼修、一位名叫戴马里的女子和很多其他人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","随后保罗离开雅典，来到哥林多， ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","在这里遇到一位老家在本都的犹太人亚居拉。由于革老丢命令所有犹太人离开罗马，所以他最近和妻子百基拉从意大利来到这里，于是保罗去见他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","由于他们和保罗一样都是以做帐棚为生，于是保罗在他们家住了下来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","每逢安息日，保罗都会到会堂进行辩论，劝导犹太人和希腊人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","西拉和提摩太从马其顿赶到这里与保罗会和，保罗就可以专心传扬主的道，向犹太人证明耶稣就是基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","当犹太人反对他、诅咒他时，他就会抖动衣服，对他们说：“你们的罪由你们自己承担，与我无关。从现在起，我要到异教徒那里去了。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","于是他离开那里，住到了敬拜上帝的提多·犹士都的家中，就在会堂的隔壁。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","会堂主管基利司布和全家人信了主，很多哥林多人也在听了道之后信了主，接受了施洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","夜里，主通过异象对保罗说：“不要怕，大胆宣讲，不要保持沉默！ ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","因为我与你同在，没有人会攻击你，因为在这座城里有许多人都追随我。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","保罗在那里住了一年零六个月，想向众人传授上帝之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","但在迦流担任亚该亚省长期间，犹太人一致起来攻击保罗，将他带到了法院， ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","说：“此人劝大家以违反律法的方式敬拜上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","保罗刚要开口为自己辩护，迦流就对犹太人说：“如果你们犹太人想要指控犯法或严重违法行为，我一定会听你们的讲述。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","但你们争论的只是文字、名字和你们的律法，那你们应当自己处理。我不会审判此类案子。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","说罢，迦流就把他们从法院赶了出去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","随后众人转向攻击会堂主管苏提尼，在法院门外殴打他，但迦流对此完全不予理会。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","保罗在这里住了一段时间后，便辞别了信徒，乘船去叙利亚，百基拉和亚居拉与他同行。因为他之前许下承诺，他就在坚革里剃光了头发。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","一行人抵达以弗所后，保罗离开众人自己去了会堂，在那里跟犹太人辩论。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","众人请他多住一段时间，但被他拒绝了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","他辞别众人，在以弗所乘船离开。临行前他告诉众人：“如果上帝允许，我还会回来。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","他在该撒利亚下船，与教会成员见了一面，然后启程去往安提阿。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","他在那里住了一段时间后，继续走遍加拉太地区和弗吕加的各个城镇，为众信徒带去鼓舞激励。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","与此同时，一位名叫亚波罗的犹太人来到以弗所。他老家在亚历山太，颇有口才，非常了解圣经。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","他曾接受主之道的教诲，内心充满热情，无论讲话还是授道，都能准确讲述耶稣，但他只知晓约翰施洗之事。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","他开始在会堂里公开讲道。百基拉和亚居拉听说了他，就邀请他加入，更全面地解读上帝之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","后来他决定去亚该亚，信徒们就鼓励他，还给那里的使徒写信，请他们接待他。抵达亚该亚后，在当地人蒙受恩典相信上帝的过程中，他起了很大的作用， ");
INSERT INTO cmnfeb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","因为他能在公开辩论种有力驳斥犹太人，通过圣经证明耶稣既是基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","亚波罗在哥林多期间，保罗从内陆抵达以弗所，在那里找到了若干信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","他问他们说：“当你们信了上帝的时候，是否领取了圣灵？”他们说：“没有，我们甚至都没听说过圣灵这件事情。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","保罗问：“那么你们接受的是何种施洗？” 他们说：“是约翰的施洗。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","保罗说：“约翰提供的是悔改施洗，他告诉众人应该相信在他之后到来的那个人，也就是他们应该相信耶稣。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","众人听罢，便以主耶稣之名进行受洗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","保罗为他们按手，圣灵就便降临在他们身上，他们开始用不同的语言说话，还可以进行预言。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","这些人总计大约十二人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","在三个月的时间内，保罗一直都在会堂里向那里的人大胆宣讲，与他们进行讨论，努力说服他们相信上帝之国。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","但有些人始终顽固不化，拒绝接受他的宣讲，还在众人面前毁谤道。所以保罗放弃了他们，离开了会堂，将信徒们也一并带走。之后，他每天都在推喇奴讲堂与大家进行讨论。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","就这样过了两年，所有亚西亚省的居民，无论犹太人或希腊人，都听到了主的道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","上帝通过保罗显现很多不同寻常的神迹。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","甚至有人会拿走保罗曾经触碰的手帕或围巾，去医治病患和赶走邪灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","几个犹太人打着耶稣的名号四处驱鬼，向身上附着之人说：“我以保罗所言耶稣之名，命令你们出来。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","一位名叫士基瓦的犹太人司长，他的七个儿子都在做这件事，一个是犹太人，一个是大祭司。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","但有一天当他们驱魔时，邪灵却回答到：“我认识耶稣，也认识保罗，但你们是谁？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","邪灵附体那人扑到他们身上将其制服，一番痛殴后，他们赤裸着身体从那房子逃了出来，满身是伤。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","所有住在以弗所的犹太人和希腊人都知道此事，纷纷表示敬畏，主耶稣之名获得了广泛尊重。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","也有许多信主之人前来忏悔他们的罪，公开坦诚他们曾经做过的恶行。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","其中有许多曾经施行巫术之人，把他们关于巫术的书堆在一起当众烧掉。他们估算了一下书价，总计五万银币。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","通过这种方式，主的道日益强大，广为传播。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","在这之后，保罗决定穿过马其顿和亚该亚去往耶路撒冷。他说：“我到了那边以后，必须去罗马看看。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","他派了两名帮手提摩太和以拉都两人去马其顿，自己则暂时留在亚西亚省。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","就在这期间，发生了很多关于道的骚乱， ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","有一位名叫低米丢的银匠，以制造亚底米女神的小银龛为生，这门手艺给他这样的工匠带来了不少生意。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","他把同行和相似行业的工人们聚起来，说：“工友们，你们知道，我们就是靠这门生意赚钱。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","毫无疑问，通过你们看见和听见的事情，你们也应该意识到这个叫保罗的人，不仅在以弗所、还几乎在整个亚西亚游说和误导众人，说人类所制造的都不是上帝的创造。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","这不仅导致我们这一行可能会受人鄙视，就连伟大女神亚底米的庙也会遭人摒弃，亚西亚和普天下所敬拜的女神将失去其威严。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","这话掀起了众人的怒火，他们高喊到：“以弗所人的亚底米，伟大的神！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","全城陷入大骚动，他们捉住了与保罗同行的马其顿人该犹和亚里达古，一起冲进了剧场。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","保罗想去直面暴徒，但其他信徒不让他这么做。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","保罗有几名省长官的朋友，也捎来口信，叮嘱他不要去剧场那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","但暴徒们并不知道聚集的原因，如一群无头苍蝇一般，口中胡乱喊叫着。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","人群中的犹太人把亚历山大推到前面，他做了个让大家安静的手势，想要解释给众人听。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","众人认出他是犹太人，便异口同声高喊：“以弗所人的亚底米，伟大的神！”足足喊了两个小时。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","后来书记官设法安抚了民众。他说：“以弗所人呐！你们的城是看守伟大亚底米的圣殿，也看守来自天堂的神像。这一点谁不知道呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","这些都是不可辩驳的事实，你们应当保持平静，不可冲动行事。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","你们抓到这里的两个人，既没有打劫庙宇，也没有亵渎我们的女神。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","如果低米丢和其他工匠想要控告谁，完全可以去找总督或提交法庭，可以在那里提交诉状。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","如果还有其他问题，就应该进行合法的集会予以解决。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","今天的骚乱毫无来由，我们实在无法评判，事实上，我们甚至可能需要为这件事情负责。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","说罢这番话，他就让暴徒们散去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","骚乱平息以后，保罗把信徒们召集在一起，鼓励他们一番后便辞行前往马其顿。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","他走遍该地区的各个角落，激励鼓舞那里的信徒，然后来到了希腊。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","他在那里住了三个月后，准备乘船去叙利亚。就在这时，他发现有些犹太人想要密谋对付他，于是他决定通过马其顿返回。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","与他同行的人有：比里亚人所巴特（毕罗斯之子）、帖撒罗尼迦人亚里达古和西公都，特庇人该犹和提摩太，亚西亚人推基古和特罗非摩。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","这些人先行，在特罗亚等候我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","我们则在除酵节后乘船从腓立比出发，五天后在特罗亚与他们会合，在那里停留了一个星期。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","星期日那天，我们聚在一起用餐。保罗计划第二天清晨离开，在当天一直讲道到午夜时分。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","（我们聚餐地点的楼上，点亮了许多灯火。） ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","有一个名叫犹推古的少年坐在窗台上，因为保罗讲道的时间很长，他越发困倦，于是便睡了过去，从三楼坠下去，待众人把他扶起来时，发现他已经死去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","保罗走下楼，趴在他身上把其抱住，说：“别担心，他还活着。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","随即他回到楼上，掰开饼与众人继续讲道，直到天明才离开。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","他们把已经活过来的少年带回家，对此事深表感激。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","我们上船后向亚朔出发，按计划我们需要在那里与保罗会和，因为他走的是陆路。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","我们在亚朔与他会合后，接他上船一同去往米推利尼。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","随后又乘船去了基阿，第二天在撒摩短暂停留，接下来到了米利都。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","保罗希望能在五旬节赶到耶路撒冷，所以决定不在以弗所停留，以免在亚西亚耽搁时间。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","在米利都，他派人给以弗所教会的长老捎去口信。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","他们抵达目的地后，保罗说：“你们知道从我们一起抵达亚西亚的第一天起，我的表现一直都很好。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","我以谦卑之心服侍主，经常泪流满面，还要忍受犹太人密谋带来的麻烦和压力。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","但我一直向你们讲述会对你们有益的事，毫无保留。在走街串巷的过程中，我公开向你们讲道。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","我向犹太人和希腊人都作过见证，想要他们悔改并归于上帝，相信我们的主耶稣，这一点很重要。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","现在，灵坚持让我去耶路撒冷，我不知道自己在那里会遭遇什么事， ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","只知道在我所造访的所有城中，圣灵都在警告我，将有监牢和苦难在等着我。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","但我并不吝惜自己的性命，只想完成自己的使命，达成主耶稣分派给我的职责，为上帝恩典的福音作见证。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","我与你们讲述了上帝之国。现在我确信，你们无法再见到我了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","所以我今天要向你们宣布，如果有人迷失，那不是我的责任。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","上帝想要你们知道的，我已经毫无保留地告诉了你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","请照顾好自己，也照顾好圣灵派你们看管的羊群。主用自己的鲜血建立的教会，你们要为之做出贡献。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","我知道在我离开之后，必有凶狠豺狼闯到你们中间，不肯放过你们所看守的羊群。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","你们中也会有人开始颠倒黑白，引诱信徒跟从他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","所以要小心，别忘记三年来，我日夜不停地教导你们，经常为你们泪流满面。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","现在我就要把你们交给上帝的关爱，交给他恩典之道，这道可以让你们成长，并为你提供属于所有遵守正道的人的遗产。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","我从未贪念任何人的金银或衣服。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","你们知道我凭借自己的双手行事，满足我自己和同伴们的需要。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","我凡事都以身作则，努力帮助那些软弱之人，牢记主耶稣的教会：‘给予远比获得更有福。’” ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","说罢这番话，他跪下来同大家一起祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","众人痛哭着抱住保罗，亲吻他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","保罗说他们不会再见他，这句话让他们伤心不已。随后，他们和他一起走到船上。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","在与他告别之后，我们也乘船直接去了哥士，第二天抵达罗底，然后从那里去往帕大拉。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","在帕大拉，我们看到一艘开往腓尼基的船，于是就上船继续前行。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","在旅途中，我们远远地在左手方向看见了塞浦路斯。继续航行到叙利亚后，我们在推罗上岸，因为船要在那里卸货。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","我们找到了一些信徒，在那里停留了七天。这些信徒曾通过圣灵告诉保罗，不要去耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","在那艘船准备再次起航时，我们回到船上继续旅程。在我们离开城市的时候，所有信徒都携妻带子给我们送行。大家一起跪在海滩上祷告，互相告别。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","随后我们就上了船返回家中。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","我们从推罗开始的那段旅程，终点是多利买。我们问候那里的信徒，然后住了一天。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","第二天我们便离开并去往该撒利亚，住在福音传播者腓利的家中，他也是七执事之一。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","他有四名尚未嫁人的女儿，都具有预言的能力。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","我们在那里住了几天之后，一位名叫亚迦布的先知从犹太赶来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","他找到我们，拿出保罗的腰带绑住他自己的手脚，然后说：“圣灵说，犹太人在耶路撒冷就是这样捆绑这腰带的主人，然后把他交给异教徒。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","听闻此话，我们就和那里的信徒央求保罗不要去耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","保罗却回答：“你们为什么要哭？这让我的心都碎了。以主耶稣之名，我们不仅准备好在耶路撒冷被捆绑，也准备好死在那里。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","由于他不听劝阻，我们只能对他说“愿主的意愿能够达成”，然后就放弃了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","几天后，我们收拾行装去耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","该撒利亚的几名信徒与我们同行，带着我们住进塞浦路斯人拿孙的家里，他很早就成为了上帝的信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","到了耶路撒冷后，那里的信徒们热情地接待我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","第二天，保罗和我们一同去见雅各，教会的长老们也都在那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","保罗向他们问候，然后就详细讲述了上帝如何通过他所履行的侍奉，在异教徒中所做的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","众人听罢纷纷赞美上帝，对保罗说：“兄弟，你看，犹太人信主的人有好几万，他们仍然小心地遵循着律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","但他们听说，你教导所有与异教徒生活在一起的犹太人不遵循摩西的律法，让他们不要给孩子行割礼，不要遵守我们的风俗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","他们肯定听说你已经来了，那我们应该怎么办呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","我们希望你能这么做：我们中有四人已经起誓发愿， ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","你和他们一起去行洁净礼，付钱让他们剃去头发，这样大家就知道，以往听说关于你的说法都不真实，你也是一名遵守律法、循规蹈矩之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","至于信主的异教徒，我们已经写信吩咐他们，不要吃献祭神像的食物，要避开血和勒死的牲畜，不要淫乱。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","于是保罗带走了那四个人，第二天和他们一起行洁净礼，然后去了圣殿，告知他们何时洁净期满以及每个人应该献祭的时间。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","在快到第七天的时候，亚西亚来的犹太人在圣殿中看见保罗，于是就煽动众人反对保罗并捉拿他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","他们高喊：“以色列人啊，快来帮忙！这个人到处唆使众人反对我们以色列人，反对律法和圣殿。他甚至还把希腊人带入圣殿，污染了这片圣地。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","（他们之所以这么说，是因为之前曾在城里看到他和弗所人特罗非摩在一起，所以就以为保罗带他进入了圣殿。） ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","全城都骚动起来，民众纷纷涌来抓住保罗，将他拖出殿外，殿门立刻关闭。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","他们正准备杀了保罗时，有人向罗马军营的千夫长报告，整个耶路撒冷都陷入了混乱。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","千夫长立刻带着百夫长和士兵，向暴乱地点赶来。暴徒们看到千夫长和士兵，便停止殴打保罗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","长官上前抓住保罗，命令用两条铁链把他捆住，然后询问他是谁，做过什么事。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","暴徒中有些人开始各执一词地胡乱叫喊，长千夫长也没办法找到真相，只好下令把保罗带到营地去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","保罗来到台阶处，由于周围的民众变得很暴力，士兵们不得不把保罗抬起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","人群中有一些跟上来的人高声喊叫：“干掉他！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","保罗快被带到军营的时候，保罗问千夫长说：“可以跟你说句话吗？” 千夫长说：“你懂希腊语？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","之前煽动骚乱、带领四千名杀手跑到荒野去的那个埃及人，不就是你吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","保罗说：“我是犹太人，来自基利家的重镇之一大数。请准我与民众说几句。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","千夫长批准了他的请求。于是保罗就站在台阶上，向民众做了一个安静的手势。待大家都平静下来后，他开始用阿拉姆语演讲。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","他说：“各位父老兄弟，请听我在你们面前的申辩。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","众人听到保罗用阿拉姆语说话，立刻变得非常安静。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","他开始讲述：“我是犹太人，生在基利家的大数。但其实我是在这座城里长大，在迦玛列门下接受教育。老师教育我要严格遵守祖先的律法，我满腔热情地对待上帝，就像今天这里的所有人一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","我也曾经迫害信奉此道之人，将他们处死，把男女信徒投入监狱。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","大祭司和公议会的长老都可以为我作证。我曾收到他们的授意信，要求处理在大马士革的犹太人信徒。于是我去了那里捉拿那些人，把他们带到耶路撒冷接受惩罚。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","那天大约中午时分，我正在去往大马士革的路上，即将抵达目的地时，忽然一束耀眼的光芒从天而降，环绕着我。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","我仆倒在地，只听见一个声音对我说：‘扫罗啊，扫罗，你为什么迫害我？’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","我答道：‘主啊，你是谁？’ 他说：‘我就是你迫害的拿撒勒人耶稣。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","与我同行之人只看见那束光，却听不到与我说话的声音。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","我说：‘主啊，我该怎么做？’ 主告诉我：‘站起来，进到大马士革城里，那里会有人告知安排你做的事情。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","那束光如此强烈，我的双眼便看不到了，我的同伴们牵着我的手走进了大马士革。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","有一个人名叫亚拿尼亚，是一名遵守律法的虔诚之人，当地所有犹太人都很敬重他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","他站在我旁边对我说：‘扫罗兄弟，你现在可以看见了。’就在那一刻，我又能看到了。我看到了他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","他对我说：‘我们祖先的上帝指认你来理解他的旨意，去见真正良善的正义之人，去听见他要对你所说的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","对于你的所见所闻，你将向所有人作证。所以你还在等什么呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","起来受洗去吧，呼唤他的名，洗净你的罪吧。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","我回到耶路撒冷后，有一次在殿里祷告时，忽然在恍惚间看到了异象。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","主在异象中对我说：‘快！你必须尽快离开耶路撒冷，因为他们无法接受你所讲述关于我的一切。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","我回答：‘主啊，他们肯定知道，我曾在很多会堂中拷打信你之人，将它们送进监牢， ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","司提芬因为为你作证而被杀害的时候，我就站在那里，而且完全支持那些杀死他的人，还为他们拿着衣服。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","主对我说：‘现在就离开吧，我要派你到远方异教徒那里去。’” ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","众人一直都在听他说的话，但听到这里，他们就高喊：“应该把这种人从世间除掉，他不配活着！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","他们喊叫着，扯开外衣，向空中扔撒尘土。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","就在这时，千夫长下令把保罗带到军营，命人用鞭刑拷问他，想要找出高声喊叫的民众反对他的原因。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","士兵将他四肢伸开，用皮带将其捆住，准备施以鞭刑。这时保罗对站在旁边的百夫长说：“你们鞭打一个还没有定罪的罗马公民，这合法吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","百夫长听言就去报告千夫长，说：“这个人是罗马公民，该怎么办？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","千夫长就过来问保罗：“告诉我，你真是罗马公民吗？”他说：“是的。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","千夫长说：“为了获得罗马公民的身份，我可是花了一大笔钱。”保罗说：“我生下来就是罗马公民。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","于是那些想要拷问他的人立刻走开了。得知他是罗马公民，又曾被捆绑起来，千夫长感到很害怕。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","第二天，千夫长想要了解为什么犹太人要控告保罗，于是就解开他身上的锁链，随后召集祭司长和公议会全体成员，将保罗带到众人面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","保罗毫不躲避地看着公议会成员，说：“各位兄弟，此前我一直都凭着良心在上帝面前行事。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","大祭司亚拿尼亚命令保罗身边的侍从，对他进行掌掴。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","保罗对他说：“你们这粉饰的墙啊，上帝会惩罚你们！你坐在那里按律法审判我，现在竟然违背律法命人打我吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","站在保罗身边的侍从说：“你胆敢辱骂上帝的大祭司吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","保罗说：“兄弟们，我不知道他是大祭司。因为经文中说：‘不可咒诅民众的统治者。’” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","保罗发现公议会中有撒都该人，还有法利赛人。于是就大声说：“兄弟们，我是法利赛人，也是法利赛人的子孙，我现在受审是因为我盼望死人能够复活！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","他说完这番话，法利赛人和撒都该人之间产生了分歧，公议会的意见分成了两派。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","（法利赛人相信死而复生、天使和灵，但撒都该人却完全不相信。） ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","现场出现了一阵骚乱，几名法利赛派的宗教老师站起来，激烈地辩论道：“我们看不出这人有罪，可能灵或天使真的和他说过话。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","争论越来越激烈，千夫长担心反对者可能会伤害保罗，于是就吩咐士兵去把他从人群中救出来，带到了军营中。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","当天晚上，主站在保罗身边，对他说：“保持这样的勇气！你在罗马为我作证的方式，要和你在耶路撒冷所做的一样。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","第二天，一些犹太人一起策划杀死保罗的计划。他们还发誓，不杀保罗，不吃不喝。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","共有四十多人参与了这项阴谋。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","他们来见祭司长和长老，说：“我们已经郑重发誓，不杀保罗，不吃不喝。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","你们和公议会应该给千夫长捎个口信，把保罗带到你们这里来。你们装作想要更详细地审问他，我们在路上会随时准备杀了他。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","但保罗的外甥（他姐妹的孩子）却听到了这次伏击的诡计，于是就跑到军营去告诉保罗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","保罗让人叫来一位百夫长，对他说：“请你带这位青年人去见千夫长，他有事禀报。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","百夫长带着保罗的外甥去见千夫长，说：“犯人保罗求我带这位青年人来见你，他有事禀报。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","千夫长拉着青年人的手走到一边，私下问他：“有什么事要报告？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","保罗外甥说：“犹太人已经密谋好了，明天会让你把保罗带到公议会，装作想要更详细地审问他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","别听他们的，因为有四十多人正准备偷袭保罗。他们已经发了誓，不杀保罗，不吃不喝。他们现在已经准备好了，就等你同意他们的要求了。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","千夫长嘱咐那青年人：“不要对别人说，你把这事告诉了我。”然后就让他走了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","千夫长叫来两名百夫长，说：“准备好两百名步兵、七十名骑兵和两百个长枪手，晚上九点钟去该撒利亚。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","还要为保罗准备可以骑的马匹，护送他安全到达腓力斯总督那里。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","千夫长写了一封信，大意如下： ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“尊敬的费利克斯总督，请接受克劳迪乌斯·莱修斯的问候！ ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","犹太人把这人捉住并打算杀害他，我听说他是罗马公民，就带领士兵把他救了出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","为了知晓犹太人控告他的原因，我就把他带到了公议会。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","我发现他被控告，是关于他们律法上的问题，但并没有应该判处死刑或入狱的罪名。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","后来我发现了有人想要密谋杀害他，就立刻把他送到你那里去，命令那些原告在你面前进行指控。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","于是士兵们听命把保罗带了出来，连夜带到安提帕底。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","第二天早晨，他们便派骑兵队把保罗送走，士兵就回了军营。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","骑兵队抵达该撒利亚后，把信和保罗都交给了总督。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","总督读罢信后问保罗来自哪个省。在得知他是基利家人后， ");
INSERT INTO cmnfeb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","就说：“等到原告到了之后，我就会审问你。”然后命令人把他拘禁在希律的王府中。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","五天后，大祭司亚拿尼亚、几名长老和一位名叫帖土罗的律师来到总督府，控告保罗。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","当保罗被传唤过来，帖土罗开始控诉他：“腓力斯大人，因为你的缘故，民众长久以来一直享受着太平。由于您的明智判断，为了国家的利益而进行了改革。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","全国人民都对你深表感激。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","但为了不烦扰你，我们只需要占用你一点时间。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","我们发现这个人就像瘟疫一样，他煽动普天下的犹太人叛乱，还是拿撒勒派的头目。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","因为他想要污损圣殿，所以我们将他逮捕。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","你只需亲自审问，就会清楚我们控告他的一切事实。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","犹太人也应声附和，证实事实的确如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","总督示意保罗回应。保罗开始申辩：“我知道你多年来一直担任本国的法官，我很乐意为自己辩护。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","有一点很容易证明，我是十二天前才抵达耶路撒冷进行礼拜， ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","无论在圣殿、会堂或城里，没有人看到我跟人辩论或是煽动群众作乱， ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","他们现在控告我的事，也没有人能向你证明。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","但我要向你明确一件事：我谨遵正道信仰伺奉我们祖先的上帝，但他们称之为邪教。无论是律法还是先知所记载的一切，我都相信。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","我和他们一样对上帝心存希望，相信无论是正义或不正义之人都会复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","因此，我在上帝和世人面前，努力保持无愧于心。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","我曾离开这里几年，在返回时带来了捐款支援穷苦人，也为上帝带来了祭物。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","他们在圣殿中找到我时，我正在完成洁净礼，没有和大群民众在一起，更没有骚乱， ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","当时只有几名来自亚西亚的犹太人而已。他们针对于我，今天就应该站在你面前控告我。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","这些人如果发现我有什么罪行，当我站在公议会面前受审时，就会说出来了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","如果有什么特别的，那可能就是我向他们喊的那句话：‘我今天在你们面前受审，就是因为我相信死人复活。’” ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","腓力斯本人非常熟悉道，于是就故意拖延审讯。他说：“等千夫长吕西亚过来的时候，我再来决定你的案子。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","他吩咐百夫长看守保罗，但要给他一些自由，不要阻止保罗的亲友前来照料。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","几天后，腓力斯把他的犹太妻子土西拉带来。他们召见保罗，听他讲述对耶稣基督的信仰。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","保罗简述了关于在生活中遵循正道、自我控制和即将到来的审判，这让腓力斯感到警觉，于是说：“你现在可以走了，有机会再叫你过来。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","此外，他也想让保罗向他行贿，所以后来又多次传见他，与他交流。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","两年过去了，非斯都接替了腓力斯的职务，腓力斯为了讨好犹太人，就将保罗继续关在监牢中。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","非斯都抵达这个省三天后，就从该撒利亚去了耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","祭司长和犹太人首领在他面前控告保罗， ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","请求他把保罗押到耶路撒冷，这样他们就能埋伏在路上杀死他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","但非斯都的回答是，保罗现在关押在该撒利亚，他马上要回到那里去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","他对众人说：“你们首领可以和我一起，如果这个人做错了什么, 可以控告他。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","非斯都在那里停留了十天八天后，就回到该撒利亚，然后在第二天开庭，吩咐把保罗带上来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","保罗刚走进来，从耶路撒冷来的犹太人就站在他周围，提出许多重罪指控，但却无法给出证据。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","保罗为自己辩护：“无论是从犹太人律法、圣殿或凯撒的角度来讲，我都没有犯下任何罪行。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","但非斯都为了满足犹太人的想法，就问保罗：“那你愿意去耶路撒冷，让我在那里审问这个案子吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","保罗回答：“此刻我站在凯撒的法庭面前，这里就是我应当受审的地点。你很清楚，我对犹太人并未做过错事。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","如果我犯下罪行，做过应该被判死罪的事情，我不会请求宽恕。但如果这些人对我的控告不属实，谁也别想把我送给他们。我要向凯撒上诉。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","非斯都与议会商量了一番后答复：“既然你想要向凯撒上诉，你应该这样做！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","几天后，亚基帕王和百尼基来到该撒利亚，然后到非斯都这里拜访。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","他们停留了一些时日，非斯都向国王讲述了保罗的案子。他说：“有个囚犯，是腓力斯在位时留下来的案子。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","我在耶路撒冷的时候，祭司长和犹太人长老控告他，要求对他定罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","我的答复是，被告还没有和原告当面对证，没有获得机会指控进行自我辩护，就不能把他送过去，这不符合罗马法律。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","所以当控告方抵达这里后，我马上就在第二天开庭，吩咐把那人提出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","但当原告发言的时候，他们的指控并非我所想的罪行。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","事实上，他们所进行的辩论都是宗教问题，还谈到了一位名叫耶稣的死人，但保罗却说他还活着。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","我不知道如何调查处理这样的事情，就问他是否愿意去耶路撒冷接受审问。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","但保罗要求他的案子应该由皇帝裁判，我就下令把他关起来，找机会把他送给凯撒。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","亚基帕对非斯都说：“我也想听听这人说些什么。”非斯都说：“那我安排你明天过来听。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","第二天，亚基帕和百尼基一起在盛大的仪式中抵达，与千夫长和城中的名人一起进了法庭。非斯都吩咐把保罗提出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","非斯都说：“亚基帕王和在座的各位，你们面前的这个人，耶路撒冷和本地的犹太人都向我情愿，表示应该对他处以死刑。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","但我发现他并没有犯下应处死之罪。他自己想要向皇帝上诉，我就决定把他押解过去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","但对于这个人，我实在没有什么明确的事情可以呈奏皇帝。所以我把他带到诸位面前，特别是亚基帕王面前，希望能够找到一些可以向皇帝陈述的内容。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","对我来说，在没有解释对他的指控的情况下就送囚犯似乎是不公平的。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","亚基帕对保罗说：“准许你为自己辩护。”于是保罗用手臂示意开始了自己的辩护： ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“亚基帕王，很荣幸今天能就犹太人控告我一事，在你面前进行自我辩护。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","尤其是你熟悉犹太人的所有规则和习俗，所以恳请你耐心听取我说的话。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","从我在祖国幼年时期的经历再到耶路撒冷的一切，所有犹太人都知道我的人生道路。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","他们一直以来都很了解我，如果他们肯作证，你就会知道，我一直严格遵循最严格的教派，忠于我的信仰。我按照法利赛人的方式生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","现在我之所以站在这里受审，就是因为上帝向祖先们承诺的希望。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","我们的十二族群始终虔诚地服侍上帝，都是盼望这希望可以实现。是的，国王陛下，犹太人控告我也是因为这希望。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","为什么你们认为，上帝让死人复活是不可思议的事情呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","我以前也真的相信，自己应该想方设法反对拿撒勒人耶稣之名。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","我在耶路撒冷就是这么做的。我在祭司长的授权下，把很多信徒扔进监牢，在他们被杀的时候，我也完全同意。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","我让他们在所有的犹太教堂受到惩罚，试图让他们放弃。 我非常反对他们，我到国外的城市去迫害他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","但有一天，我得到祭司长的授权和指令去往大马士革。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","国王陛下，就在那天中午，我在路上看见来自天上的一道光，比太阳更明亮，照耀着我和其他同伴。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","我们都伏倒在地，然后我听见有声音用希伯来语对我说：‘扫罗啊，扫罗！你为什么迫害我？你是很难对抗我的！’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","我问到：‘主啊，你是谁？’ 主说：‘我就是你所迫害的耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","但现在起来吧。我之所以要向你显现，是为了指认你为我的仆人，为我见证，告诉其他人你如何看到我，以及我向你显现的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","我要把你从同胞和异教徒那里拯救出来，现在我就派你到他们那里去， ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","开启他们的双眼，让他们从黑暗转向光明，从撒旦的控制转向上帝，这样他们的罪恶才会得到赦免，那些因信我而正确行事之人，才会被包含其中。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","亚基帕王啊，很显然，我没有违背这来自天堂的异象。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","我先在大马士革、耶路撒冷、犹太全地向众人宣讲这忏悔之道，然后又向异教徒宣讲：关于如何转信上帝，通过行动彰显他们的悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","犹太人就是因此在圣殿中捉拿我，想要杀我。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","但我获得了上帝的眷顾，所以今天还能站在众人面前，包括普通百姓和尊贵之人。我所言只是重复了摩西和先知所讲必然发生之事， ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","那就是基督必须受难，然后率先死而复生，向犹太人和异教徒宣告上帝的拯救之光。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","保罗的自我辩护说到这里，非斯都大声说：“保罗！你疯了！你的学问让你疯了！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","保罗回答：“非斯都大人，我没有疯，我说的都是真实，都是言之有理。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","国王意识到了这一点，我只是很坦白地解释而已。我相信他知道到底发生了什么，因为这种事情无法躲躲藏藏。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","亚基帕王啊，你相信先知所言吗？我知道你信！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","亚基帕问保罗说：“你认为自己能这么快就说服我变成基督徒吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","保罗回答：“无论时间长短，都没有关系。我不止为你向上帝祈祷，更包括今天希望像我一样的所有听众，只是不应该有这锁链。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","亚基帕王、总督、百尼基以及在座的所有人都站起来，然后离开了法庭， ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","召开了一次会议。他们的结论是：“这个人并没有犯下任何应处死或监禁的罪行。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","亚基帕对非斯都说：“如果他没有请求向凯撒上诉，就可以释放了。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","到了将我们押送到意大利的时候，帝国团中一位名叫犹流的百夫长负责看管保罗和其他囚犯。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","我们坐上一艘来自亚大米田的船，它将要开往亚西亚沿岸的海港。我们上船后就出发了，还有一人与我们同行：马其顿的帖撒罗尼迦人亚里达古。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","第二天我们在西顿短暂停留，犹流对保罗非常友好，允许他到岸上看朋友，接受他们的招待。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","随后我们又从那里继续出发，因为是逆风，船便向塞浦路斯的背风地点驶去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","船只直接穿过基利家和旁非利亚一带的水域，抵达了吕家的每拉港。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","在那里，百夫长找到一艘来自亚历山太，开往意大利的船只，于是安排我们上了这艘船。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","但这艘船在随后的几天行驶得都很缓慢，好不容抵达革尼土对面的海域。因为逆风的缘故，船只无法继续前行，只能在撒摩尼附近背风穿过克里特的海域。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","沿着海岸行驶的这段航程很困难，最终抵达了拉西亚城附近一个名叫美港的地方。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","这段旅程已经浪费了不少时间，未来的航程也很危险，此时都已过了禁食节。保罗警告他们说： ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“各位，我估计这次旅程会非常困难，而且会有损失，不只是货物和船只，连我们的性命也危在旦夕。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","但百夫长更相信船长和船主的建议，把保罗的警告当耳旁风。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","由于这个港口很小，无法在此过冬，所以大多数人主张继续航行，可以到非尼基去过冬——那是位于克里特的一个朝向西北和西南的港口。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","这时海上开始刮起和缓的南风，他们认为可以按计划进行，于是就起锚沿着克里特海滩接近海岸的路线航行。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","但很快，从陆地向海上刮起了一阵名为“东北风”的飓风。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","船只被困在海中，无法迎风前行，只好随风飘流。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","最终我们来到一个名为高达的小岛，这里可以背风行驶。我们还花了很大力气将救生艇拉住。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","水手把小艇吊起来，用缆索绕在船身将其捆好。他们担心船会在赛耳底的浅滩搁浅，于是放下船帆，任其飘流。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","船只在风浪中剧烈颠簸。第二天，船员们开始将货物拋在海里， ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","第三天，他们又将船上的设备扔掉。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","接连数天都看不见太阳或星辰，肆虐的暴风雨铺天盖地，看起来我们似乎没有一点生还的希望。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","船上的人已经很久没有进食了。保罗站在他们面前，说：“各位，你们本该听我的，不要离开克里特，那样就可以避开这样的灾难和损失了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","但现在我想说的是，鼓起勇气，因为除了这艘船被毁，你们所有人都不会丢掉性命。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","因为昨晚，我所侍奉的上帝派来天使站在我身边，对我说： ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘保罗，不要怕。你一定会站在凯撒面前接受审判。看，上帝慷慨地赐予你这些人，他们与你同船而行。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","所以各位，拿出勇气来。我相信上帝，我确信事情一定会像我说的那样。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","但是我们会在一个岛上失事。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","到了第十四天的午夜，我们还在亚得里亚海面被风吹着。水手感觉这里应该距离陆地不远了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","于是他们探测了一下水深， 40 米，继续往前再探测， 30 米。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","他们怕船只可能会在乱石上搁浅，于是就从船尾拋下四个锚，祈祷天亮。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","水手们想要弃船逃生，于是假装要从船头拋锚，其实是想把救生艇放在海面上。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","保罗对百夫长和士兵说：“水手如果不留在船上，你们必死无疑！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","于是士兵砍断拴着救生艇的绳子，任它消失在海中。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","天快亮的时候，保罗劝大家吃点东西。他说：“你们忧心忡忡地想着这件事，已经连续 14 天没有吃东西了！ ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","听我劝，吃点东西吧，这可以让你们有力气！因为你们所有人连一根头发都不会失去。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","保罗说完就拿起饼，在众人面前感谢上帝，然后把饼掰开吃。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","众人受到鼓舞，也开始进食。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","我们这艘船上的共有 276 人， ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","大家吃饱后，为了减轻船只的负荷，水手把船上的麦子拋在海里。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","黎明时分，他们来到一个不知名的海岸线，只看见一个海湾和一片海滩。他们计划在那里尝试将船搁浅。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","他们砍断拴着锚的绳子，将锚丢在海里，同时又松开舵绳，拉起前帆，顺着风向那片海滩驶去。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","但船还是卡在了沙洲处，船搁浅了，船头卡在沙滩上，一动不动。船尾则被大浪冲击，撞得粉碎。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","士兵想要杀了所有囚犯，防止有人游泳逃脱。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","但百夫长想要救保罗，就制止了他们的这个念头，吩咐会游泳的跳下水，先到岸上去， ");
INSERT INTO cmnfeb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","其余的人可以借助木板或船上的设备上岸。最终，所有人都安全登陆。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","我们终于安全上岸后，才知道这个岛叫做马尔他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","当地的人对我们很友好。由于下过一场雨，天气很冷，他们还生起火让我们取暖。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","保罗捡了一捆木柴，扔进火里。但木材里藏着一条毒蛇，但是因为高温, 他爬出来咬了保罗的手。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","当地人看见那条蛇悬在他手上，就对彼此说：“这人一定是个凶手，虽然从海里脱险，但正义也要取他的命！” ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","但保罗却把那条蛇抖在火里，自己毫发无损。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","当地人等着看他伤口肿胀或者倒地死去。但很久后他仍然平安无事，于是他们就改变了想法，认为他是一个神。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","附近的土地为岛上首领部百流所有。他很欢迎我们的到来，好心地招待了我们三天。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","当时部百流的父亲患了重病，躺在床上高烧不起，同时伴有痢疾。保罗走进去看望他，为他祈祷按手，将他医好。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","这之后，岛上其他病患都被送了过来，也被他治愈了。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","他们送给我们很多礼物。到了开船之时，又为我们准备了航程需要的所有补给。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","我们在岛上停留了三个月，然后上了一艘从亚历山太开来的船。它也在这个岛上过冬，船头装饰着宙斯双子的雕像。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","我们随船停在叙拉古，在那里逗留了三天。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","之后继续航行到利基翁，抵达之后的第二天刮起南风，所以我们用了一天的时间就到了达部丢利。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","在那里我们遇到一些信徒，邀请我们在那里住了七天。 最终，我们抵达了罗马。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","罗马的信徒听说我们到来，于是赶来在亚比乌和三馆迎接我们。看到他们，保罗便感谢上帝，心中感觉更受鼓舞。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","抵达罗马后，保罗被允许与一名士兵一起被软禁起来看管他。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","三天后，保罗请犹太人首领前来见面。所有人都到了之后，保罗说：“兄弟们，我没有做过任何违背人民或者祖先习俗的错事，却像囚犯一样被逮捕，被他们从耶路撒冷送到罗马人的手里。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","他们在审讯我之后，由于没有找到判处死刑的罪过，就想释放我。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","但犹太人首领却反对这么做，所以我迫不得已才要求向凯撒上诉，并非我想要对抗我的同胞。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","因此我请求与你们见面谈谈这件事情，因为我之所以像这样被捆绑起来，就是为了以色列的希望。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","众人对他说：“我们没有收到任何关于你的犹太来信，今天赶过来的这些人，也没有人想要指控你或说你的坏话。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","但我们想听听你相信什么，尤其是关于这教派的态度，要知道它在所有地方都受到了抵制。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","于是他们和保罗约了个见面的日子。在那天有很多人来到他的住所与他见面。他从早到晚不停地向众人讲解，告诉他们上帝之国的一切，通过引用摩西的律法和先知的预言，规劝他们信奉耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","对于他所说的一切，有人信服，也有人不愿相信。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","众人无法达成一致的意见，于是就纷纷离开了。在他们走之前，保罗这样说：“圣灵通过赛亚先知告诉你们祖先的话一点不错： ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘去民众那里告诉他们，尽管你们听到了，却从未理解，纵使看见了，却从未领悟。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","因为这些人的心灵顽固不化，有耳朵却无法听到，双眼紧闭，不想用双眼看见，用耳朵听到，用心理解。如果他们回到我身边，我会治愈他们。’ ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","所以你们应当知道，来自上帝的救赎已经赐予异教徒，他们将会仔细聆听。” ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","保罗在自己租的房子里住了整整两年，接待所有上门拜访之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","他放胆传讲神的国，教导有关主耶稣基督的事。 没有人阻止他。");
INSERT INTO cmnfeb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","此函来自基督耶稣的仆人保罗。我蒙受上帝的感召成为其使徒，上帝指派我传播福音， ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","上帝的众先知此前也曾在圣经中他的预言承诺这福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","这福音讲述的是上帝之子，其人类祖先为大卫。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","但他通过圣灵的力量死而复生，彰显他就是上帝之子。他就是耶稣基督，我们的主。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","我通过他获得了成为使徒的特权，呼吁万国顺服并相信他， ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","在受到召唤跟随耶稣基督的人中，也有你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","这封信写给所有住在罗马、为上帝所爱并受到召唤成为其特殊之人，愿你们获得来自天父上帝和主耶稣基督的恩典和平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","首先要说的是，我要透过耶稣基督为你们所有人感谢上帝，因为全世界都在讲述你们对上帝的信。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","我始终在为你们祈祷，上帝可鉴。我全心全意侍奉上帝，传播关于上帝之子的福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","我在祷告中总是在恳求，上帝能够让我最终与你们相见。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","我真心想要造访你们，与你们分享圣灵的祝福，为你们赋予力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","通过这种方式，我们可以鼓励彼此对上帝的信，包括你们的信和我的信。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","我的兄弟姐妹们，我一直在计划去拜访你们，但总是受到阻拦无法成行，现在终于如愿以偿。我想去见证圣灵在你们当中结出的善果，就像在其他国家中一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","无论是开化或未开化之人，无论是受教养或无教养之人，我都有服务你们的义务。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","所以，我非常想要去罗马，与你们分享福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","我当然不会以福音为耻，这福音彰显了上帝拯救信他之人的力量——先是犹太人，然后是其他所有人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","上帝通过这福音显示他的善良和正义，从始至终都值得信赖。正如经文所记：“那些与上帝保持一致之人因信上帝而活。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","如果你不信上帝、道德不义、被魔鬼所控压制真理，上帝对这一行为的反对必会从天堂显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","关于上帝，我们可知的已经显而易见，因为他已经向众人显明。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","自从创世以来，上帝隐形的一面，比如他的永恒能力和神性，都已通过他的造物显现。这样的人无法找到任何借口， ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","他们知道上帝，却不赞美或感谢上帝。相反，他们对上帝的看法显示出彻头彻尾的愚蠢，黑暗填满了他们的空虚之心。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","他们自诩聪明，却已变得蠢笨。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","他们以凡俗之人、飞鸟走兽和昆虫做神像，取代上帝的永恒荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","所以上帝已放弃他们，任由其堕落思想沉迷于邪恶的欲望，用可耻而低级的行径对待彼此。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","他们用谎言取代上帝的真理，膜拜和侍奉造物而非应该永远称颂的造物之主。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","因此，上帝抛弃了他们去追求邪恶的欲望。有的女人用正常之性进行堕落的交易。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","同样，男人也放弃了与女人之间的性爱，转而对彼此燃起欲火，男人与男人做出可耻行径。他们堕落的后果必会令其遭受苦痛折磨。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","既然他们认为不值得去认识上帝，上帝就放弃他们，任凭他们以无法被信任、毫无价值的方式思考，做出本不应该允许的行径。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","他们的内心已经彻底走入歧途，满是邪恶、贪婪、仇恨、嫉妒、谋杀、争吵、欺诈、怨恨和谗言。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","他们毁谤他人，憎恨上帝。他们自大傲慢，自吹自擂。他们会犯下新的罪恶。他们会忤逆父母。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","他们不愿意去理解真相，从不守信用，他们冷酷无情，没有恻隐之心。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","尽管他们对上帝的要求心知肚明，但行为却让他们走向死路。他们不仅自己这么做，也会唆使其他人这么做。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","无论你是谁，如果你评判他人，你就无法给自己找到借口。无论你以何种方式谴责他人，其实就是在评判自己，因为你也不过如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","我们知道，上帝根据真理审判做出此类行径之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","当你评判他人，你真的以为自己可以躲过上帝的审判吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","还是说，你们藐视上帝伟大的仁慈、宽容和忍耐，不知道上帝的仁慈是为了带领你悔改？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","因为你们的铁石心肠和不肯悔改，当上帝的审判彰显绝对良善正直的那一天，你们会让自己陷入更大的痛苦之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","上帝会根据每个人的所作所为，给予其应有的对待： ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","始终努力追求行善正义之人，将获得荣耀和尊贵，永生和不朽。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","但自私自利、拒绝真理、主动选择邪恶的人，将承受上帝之反对的惩罚。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","作恶之人将陷入痛苦和折磨，先是犹太人，然后是外族人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","但行善之人则会被赐予荣耀、尊贵与平安，先是犹太人，后是外族人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","因为上帝从不偏袒。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","犯下罪行之人，即使其罪行没有被写入摩西之律法，仍会迷失。如犯下律法所载之罪，将按律法接受审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","在上帝面前，只是聆听律法不代表你就是良善正直。只有在行为中践行律法，才是真正的正义。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","外族人没有成文的律法，但他们按照本能行事，即使没有书面文字，也能够遵守律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","他们以这种方式表明，律法早已刻在他们心中。他们会思考自己的所作所为，如果做错，他们会受到良知的审判，或以良知保护他们做出良善正义的行为。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","我将要宣讲的福音就是：上帝通过基督审判每个人的隐秘思想，这一天正在到来。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","你们自称犹太人又如何呢？你们依赖书面律法，夸口与上帝有着特别的关系。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","你们知晓他想要什么，通过律法的教诲做正确的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","你们如此确信可以成为盲人的向导，成为黑暗中的光。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","你们认为从律法中获得了所有真理，就可以开悟愚昧，成为“幼儿”的教师。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","既然你们忙于教导别人，为什么不教导自己？你告诉人们不可偷窃，为什么自己却偷窃？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","你们告诉人们不可奸淫，为什么自己却奸淫？你们告诉人们不要膜拜神像，为什么自己却亵渎圣殿？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","你们自诩拥有律法，为什么自己却因违背律法，扭曲上帝旨意？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","正如经文所说：“上帝的形象因你们而被外族人所诬蔑。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","你们只有遵行律法，割礼才会有益处。但如果你们违背律法，割礼就毫无意义，与没有割礼又有何区别。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","未受割礼之人如果谨遵律法，仍然可以被视为已经接受了割礼。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","即使你们有成文律法并进行了割礼，如果违背律法规定，也可以由未接受割礼却遵守律法的人进行审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","让你成为犹太人并非由外在条件决定，也不是割礼在身体上的标记所证明。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","只有内在实行了“心之割礼”，追寻圣灵而非律法的文字，才是真正的犹太人。这样的人寻求的是来自上帝而非人类的赞美，。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","那么犹太人有什么优势吗？割礼又有什么益处？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","是的，有很多益处！首先，这代表他们已接受了上帝之道的委托。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","即使有人不信上帝，又会怎样？难道他们不信，就可以证明上帝不可信吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","当然不是！即使所有人都被证明是在说谎，上帝始终在讲述真相，正如经文所记：“你所说的将被证明为公义，在你接受审判时将会获胜。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","但如果我们的过错可以彰显上帝的良善正直，我们又会得出怎样的结论呢？难道上帝对我们宣告审判是错的吗？（我是从人类的角度看待这个问题。） ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","当然不是！上帝又会用哪些其他的方法审判这个世界呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","有人可能会说：“如果因我的谎言证明了上帝的真相，难道不更加彰显他的荣耀吗？为什么我还要像罪人一样受审判？” ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","难道你是在说：“让我们的恶带来善？”当有人毁谤我们，有人会这么说。这种人就应该接受正义的审判！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","那么我们犹太人真的比其他人更优秀吗？当然不是！请记住，我们已经讨论过，犹太人或是外族人都在罪恶的控制之下。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","正如经文所说：“没有正确行事之人，一个都没有。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","没有人理解，没有人寻求上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","人人都背离了上帝，人人都在彻头彻尾地犯错。没有行善之人，一个都没有。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","他们的喉咙如敞开的坟墓，他们的口中满是诡诈，他们嘴唇流出的都是蛇的毒液， ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","他们满口恶毒和诅咒， ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","制造苦痛和死亡却速度飞快。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","他们的路通往灾难和不幸。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","他们不知道如何和平生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","他们完全不尊重上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","很显然，律法所述一切管辖律法之下生活的所有人，确保任何人都不会为自己寻求借口，确保全世界的所有人只回答上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","因为没有人能通过践行律法的要求，在上帝面前成就良善正直。律法只是帮助我们意识到什么才是罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","但现在，上帝已经显明了他的良善正直的形象。尽管有律法和先知的话可以证明，但上帝的良善正直并非因为遵守律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","上帝良善正直的形象，源自那些相信耶稣基督之人，来自那些对他有信心之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","我们都是罪人，我们远远达不到上帝荣耀的完美。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","但上帝通过其馈赠的恩典，通过基督耶稣让我们获得自由，进而让我们达到良善正直。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","上帝公开将耶稣作为馈赠，为信他之人、为他为之洒下鲜血之人带来和平。上帝这样做，是为了证明他才是真正的良善正直，因为之前他对罪行报以容忍并宽恕， ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","但现在，就在此时此刻，上帝证明了他的良善正直，做出良善正直之事，让信任耶稣之人成为良善正直之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","那么我们还有什么可夸耀的？绝对没有，没有任何解释的余地。那么为什么呢？难道是因为我们遵循了律法的要求？不是，是因为我们遵循了相信上帝的律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","我们可以确定的是，人通过相信上帝而变成良善正直之人，不是通过遵循律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","难道上帝只是犹太人的上帝？他不也是外族人的上帝吗？当然是！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","只有唯一的上帝，他通过我们对他的信而在道德上成为良善正直之人，无论你是谁，是犹太人或外族人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","是否这就意味着，信上帝就可以摒弃律法？当然不是！事实上，我们信上帝确定了律法的重要性。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","让我们以亚伯拉罕为例。从人类的角度来看，他是我们国家的祖先。那么问题是：他经历了什么？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","如果亚伯拉罕因其行为而被称为正义，他可能会因此而夸口，但决不能在上帝面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","经文是怎么说的？“亚伯拉罕相信上帝，所以就被视为正确行事的善良之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","做工的人会获得酬劳，但不算是恩赐，而是他们应得的。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","上帝让罪人转为正义，将他们视为正义之人，因为他们相信上帝，为上帝而工作。所以 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","大卫说过，上帝视为正义之人有福，并非是他们做工的一种交换！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“那些过错获得赦免、罪恶得到宽恕之人，如此有福， ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","主没有将其视为有罪，如此有福。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","那么这福气只属于犹太人吗？或者也属于其他人？我们刚刚说过，亚伯拉罕被视为善良正义，是因为他相信上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","那么，这又在何时发生呢？在亚伯拉是犹太人的时候，还是更早？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","其实是在他领受割礼之前，割礼确认了他对上帝的信任，这让他成为正义之人。这发生在他受割礼之前，所以他是所有相信上帝、被上帝视为正义之人的祖先，即使这些人没有受割礼成为犹太人也是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","他也是受割礼之人的父，不仅因为他们受割礼，还因为他们遵循我们祖先亚伯拉罕的例子，他在受割礼之前就信上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","上帝承诺亚伯拉罕和他的后裔：这个世界将属于他。但这个承诺并非因他遵循律法，而是因为他相信上帝而变成良善正直之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","如果这承诺的传承是根据律法而来，那么就无所谓相信上帝与否，承诺也就没有了意义。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","因为律法会带来惩罚。但如果没有律法，就谈不上违背律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","所以这承诺是基于对上帝的相信。上帝将其作为恩赐馈赠，是向所有亚伯拉罕的子孙做出的承诺，不只是那些遵循律法之人，还包括相信众人之父亚伯拉罕的所有人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","如经文所记：“我已立你为万国之父。”在上帝面前，亚伯拉罕相信上帝，那让人起死回生、造物于世的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","在没有希望的时候，亚伯拉罕仍心怀希望地相信上帝，这让他成为众人之父，正如上帝所承诺：“所以你将有众多的后裔！” ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","他近一百岁时，感到自己的身躯已行将朽木，撒拉也无法生育，但他对上帝的信丝毫未曾减弱， ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","他坚信上帝的承诺，从未有丝毫怀疑。相反，他更坚定地相信上帝，将荣耀给予上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","他完全确信上帝承诺之事，上帝必能成就。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","这就是为什么上帝将亚伯拉罕视为正义之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","“亚伯拉罕被视为正义之人”这句话，不只是为他而写， ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","也为我们而写，我们中会有人被上帝视为正义之人，因为我们相信上帝让主耶稣死而复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","耶稣因我们的罪而受到背叛并送死，又通过复活让我们成为良善正直之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","我们既然信任上帝而成为良善正直之人，就通过我们的主耶稣基督与上帝和平相处。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","通过耶稣、通过对他的信任，我们才能在所站之处获得恩典，期盼分享上帝荣耀所带来的福报和信心。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","不仅如此，我们还在困难来袭时保持自信，因为我们知道患难会带来精神上的上的持久力量， ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","精神上的上的持久力量会让我们拥有成熟的性格，成熟的性格会带来自信的希望。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","这希望让我们永远不会失望，因为上帝通过他赐予我们的圣灵，将他的爱灌注在我们的心中。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","当我们感到彻头彻尾的无助，耶稣便在恰好的时间，因不信上帝之人而赴死。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","谁能为其他人而死，为不正确行事之人而死？（有人可能愿意为他人舍生，但只是为真正善良之人而死） ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","基督为仍然是罪人的我们而放弃自己的生命，这就是上帝彰显他对我们的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","既然他的死让我们成为良善正直之人，就可以确定，我们将在即将到来的审判中，因他而获得拯救。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","我们以他为敌的时候，上帝通过上帝之子的死让我们成为他的朋友，可以确定的是，上帝将通过上帝之子的生命拯救我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","不仅如此，上帝通过主耶稣所行之事与我们和解，让我们成为他的朋友，我们现在就可以为之而庆贺。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","罪通过人进入这个世界，罪带来死亡。所以，所有人都会死，因为所有人都有罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","在律法被赋予人类以前，罪便已存于这世界，但因为当时没有律法，罪也不算罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","但从亚当到摩西的这段时间，死亡仍然无法躲避，即使那些没有以亚当犯罪的方式犯罪的人，他们仍然会死。 亚当预示了那即将到来之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","但耶稣的恩赐与亚当的罪截然不同。尽管很多人因一个人的罪而死，上帝会赐予更多恩典，通过耶稣基督让众多之人可以分享。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","这恩赐的结果与罪行结果完全不同，亚当之罪带来了审判和定罪，恩赐却会让我们因上帝而变得良善正直，无论我们有多少罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","因一个人的罪，死亡就会因此人而掌控这世界。但上帝的恩典如此伟大，他恩赐之礼让我们变得良善正确，因为每一位接受他之人，都会通过耶稣基督获得生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","一个罪让所有人都遭受审判，所有人都被定罪。同样，一个良善行为也会让所有人获得生而良善正义的机会。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","亚当的不顺从让众人变成了罪人。同样，耶稣的顺从会让众人与上帝和解。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","当律法被带到这个世界，罪就变得显而易见。但是，当罪变得更加显而易见，恩典同样也会变得显而易见！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","正如罪统治人间并带给我们死亡，如今恩典统治人间会让我们与上帝和解，通过我们的主耶稣基督带给我们永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","那么我们应该做出怎样的反应？难道是通过继续犯罪获得更多的恩典？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","当然不是！既然我们已经因罪而死，又怎能继续活在罪中？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","难道你们不知道吗？所有通过受洗而追随基督耶稣之人，都是受洗与他共同赴死？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","通过受洗，我们与他一同埋葬在死亡中，就像基督通过天父的荣耀死而复活，我们也可以获得新生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","如果我们像他一样死去，从而与他成为一体，我们也会像他一样死而复生。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","我们知道，死亡之前的“旧我”已经与耶稣一起钉上十字架，通过抛弃罪恶的死亡之躯，我们便不再被罪所奴役。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","因为死去之人已经从罪中获得自由。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","既然我们与基督共同赴死，我们就有信心必将与他同住， ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","因为我们知道，由于基督已经死而复生，即不会再受死亡掌控，因此获得永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","通过死亡，他带走了所有的罪，现在他复活，便为上帝而活！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","同样，你应该认为自己已因罪而死亡，通过基督耶稣因上帝而复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","不要让罪掌控你凡人之躯，不要屈服于它的诱惑， ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","不要将身体的某一部分成为罪的邪恶工具。而是要像那些因死而复生回归的一样，将自己奉献给上帝，将身体的全部作为工具，为上帝行善。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","罪无法掌控你，因你并非身处律法之下，而是置身恩典之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","那么，我们不在律法之下、而在恩典之中，是否就意味着我们应该做出有罪之事？当然不是！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","你难道没有意识到吗？如果你成为某人的奴隶，服从他们的命令，你就是向你发号施令之人的奴隶。如果你是罪的奴隶，结果就是死亡，如果你服从上帝，结果就是与他和解。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","感谢上帝，因为尽管你曾是罪的奴隶，但你全心全意选择遵循所学到的上帝真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","当你解脱了罪恶，就会成为只按道德正确行事的奴隶。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","我使用这个日常例子，是因为人类的思维具有局限性。正如你们曾为不道德的努力，罪行累累。现在你们必须成为纯洁和正义的奴隶。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","当你是罪的奴隶时，就不需要正确行事。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","但这样做的结果是什么？你难道不会为自己的所作所为感到羞耻吗？这样的行为会带你走向死亡！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","但当你已从罪中解脱，就成为上帝的奴隶，这会让你获得纯洁的生命——最终得到永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","死亡是罪的代价，但通过我们的主基督耶稣，上帝向我们馈赠了永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","兄弟姐妹们，（在此我想向知晓律法之人说几句），难道你们没有看到，律法只对活人有约束力吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","例如，已婚妇女在丈夫活着时受法律约束，但如果他死了，她就免除了对他的法律义务。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","因此，如果她在丈夫在世时与另一个男人住在一起，她就是犯下通奸之罪。但如果她的丈夫过世，她改嫁另一个男人，就不是通奸罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","同样，我的朋友们，通过基督之躯，我们对律法而言已经死去。所以现在你属于另一个人——基督，他死而复生，这样我们才能为上帝而过上有意义的生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","当我们被过往的旧天性所掌控，我们体内就充满了罪恶的欲望（如律法所揭示），导致死亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","但现在我们已经脱离了律法，对于束缚我们的枷锁而言，我们已经死去，所以我们可用全新的灵服侍上帝，而非在律法的旧文中行事。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","那么我们可以得出什么结论呢？律法是罪吗？当然不是！除非法律定义罪，否则我不会知道何为罪。如果律法没有说“不要渴望拥有属于别人的东西”，我就无法意识到想拥有他人之物为错。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","但是通过这条诫命，罪恶设法挑起我心中各种自私欲——没有律法，罪也死亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","我过去并未意识到律法到底意味着什么，但当我明白这条诫命的含义，罪复活，我死去。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","我发现，那条意为带来生命的诫命，反而带来了死亡， ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","因为罪通过诫命找到了欺骗我的方法，用诫命杀死了我！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","但律法本身是神圣的，诫命是神圣、正义和善良的。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","善良之事会杀了我吗？当然不是！但是我因良善而死去，这种行为让罪显示出来。因此，通过诫命的含义，它揭示了罪到底有多邪恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","我们意识到律法是有灵性的，但我太像人了，是罪的奴隶。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","我不明白自己在做什么，做着自己不想做和厌恶的事情，这就是我所做的！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","但如果我说自己违心做事，就表明我承认法律为善良正义。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","所以做事的并不是我，而是我内在的罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","因为我知自己的罪恶人性，所以我本不善良。即使我想做善事，也做不到。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","我想做善事，却无法做到，我不想做邪恶之事，最终却这么做了！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","但如果我所做并非出于本意，那这行为便源于我身体中的罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","这就是我发现的原则：如果我想做善事，邪恶也伴左右。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","我内心尊崇上帝的律法， ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","但我发现另一种律法在我心中作祟，它与我思想所遵循的律法相违背，我内在的罪恶律法将我困成它的囚徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","我如此痛苦！这身体带我走向死亡，谁能拯救我？感谢上帝，他通过我们的主耶稣基督达成我的愿望！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","现在的情况是：虽然我自己选择服从上帝的律法，但我的人性却服从了罪恶的律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","现在那些与基督耶稣一体之人不会被定罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","生命之灵的律法，通过基督耶稣让我脱离罪恶和死亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","因我们的罪恶天性，律法也无能为力的，但上帝却能做到！他派来自己的儿子，以人类之形解决了所有的罪恶问题，摧毁我们罪恶人性中罪的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","通过这种方式，我们可以追随圣灵而非罪恶人性，以此履行律法对善良的要求。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","那些追随罪恶人性之人，只专注于罪恶之事，那些追随圣灵之人，只专注于圣灵之事。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","罪恶的人心会走向死亡，但被圣灵引导之心会拥有生命与平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","罪恶人心与上帝为敌，因为它拒绝遵守上帝的律法。事实上，它永远无法遵守。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","追随其罪恶本性之人永远无法让上帝欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","不是追随你的罪恶天性，而是要追随圣灵——如果你心中有上帝之灵。但如果你心中没有基督之灵，你也就不是基督之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","但如果基督常驻你的心中，即使你的身体因罪恶而死去，这灵也会赐予你生命，因为上帝视你为正义。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","如果你心中有那让耶稣死而复生的灵，让耶稣死而复生的上帝就会通过这灵，为你的死亡之躯赋予生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","所以兄弟姐妹们，我们不必去追随那按照人类欲望操控我们的罪恶天性。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","如果你的生命被你的罪恶天性所控制，你就会死亡。但如果你追随圣灵之路，将你所做罪行处死，你就会活着。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","所有被上帝之灵引导的人都是上帝之子。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","赋予你的灵不会再次奴役你，恐吓你。不会。你所得到的灵，将让你成为上帝家园中的孩子。现在我们可以大声高呼：“上帝就是我们的父亲！” ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","圣灵也同意我们就是上帝之子。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","如果我们是他的孩子，便是他的继承人。我们是上帝的子孙，与基督一样的子孙。但如果你想分享基督的荣耀，就必须也分享他的痛苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","但我深信，相比未来将显示给我们的荣耀，我们现在所受之苦根本不值一提。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","由上帝创造的世间万物都在耐心等待，渴望上帝向他的孩子昭示。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","上帝允许造物的初衷被违背。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","万物满怀希望地期待那一刻，从腐朽奴役中解脱，分享身为上帝儿女的荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","我们深知，到目前为止，所有上帝的造物都在期待中痛苦呻吟，一如女人分娩遭受疼痛。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","不只是上帝造物，我们又何尝不是如此。虽然提前获得圣灵的恩赐，但在等待上帝“收养”我们、救赎我们身躯之时，我们的内心也在痛苦呻吟。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","我们因希望而获得拯救。但目前你们看到的根本不是希望。谁会希望拥有已经看到的东西？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","我们自然会期盼尚未看到之事，所以我们耐心地等待它。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","同样，圣灵会在我们软弱之时帮助我们。我们不知道如何向上帝表达，但通过我们无法用言语表达的悲叹，圣灵代替我们向上帝表达。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","那洞察所有人心的上帝深知圣灵的意图，知晓圣灵代表信徒向上帝祈求。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","我们知道，神在所有事情上都为爱他的人，那些被他召唤成为他计划一部分的人的利益而工作。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","上帝早已选择了这些人，如对待他儿子一般厚待他们，所以他的儿子乃众多兄弟姐妹中的第一人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","上帝召唤他所选择的众人，对于他所召唤之人，上帝让其良善正义，上帝让其良善正义之人，自会获得荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","那么我们对此应该怎么做？如果上帝垂青我们，又是谁反对我们？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","但上帝并未护住自己的儿子，而是为我们众人舍弃了他，难道他不会慷慨馈赠我们一切吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","上帝的特别子民不会因任何事而遭受控诉。是上帝让我们良善正义， ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","谁又能定我们的罪？受死之人乃基督耶稣，更重要的是，他死而复生，然后站在上帝的右边，替我们祈求。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","没有人能阻断我们获得基督之爱。压迫能吗？痛苦能吗？迫害能吗？饥饿、贫困、危险或暴力能吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","正如经文所言，“因为你的缘故，我们始终面临被杀害的危险之中。他们对待我们的方式如待宰绵羊。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","不会的。对于发生在我们身上的一切，爱我们的耶稣让我们可以战胜一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","我完全相信，无论生死、无论天使或魔鬼、无论现在或未来、无论任何力量， ");
INSERT INTO cmnfeb_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","无论高低，事实上，任何上帝造物都不能阻碍我们获得基督耶稣所获得的上帝之爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","我与基督同在，我所说为真相！我的良心和圣灵可以证明 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","我心中的彻骨悲伤，证明我心中从未终结的痛苦， ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","这苦痛是为了与我相同之人，我的兄弟姐妹。只要能够帮助他们，我宁愿自己被诅咒，宁愿与基督分离。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","他们就是我的以色列同胞，是上帝所选之人。上帝向他们彰显其荣耀，认可接纳他们，赐予他们律法、真正的敬拜和上帝的承诺。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","他们就是我们的祖先，从人类角度来说就是基督的祖先，是掌管一切、永远受祝福的上帝。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","上帝的承诺并未落空。因为并非每一位以色列人都是真正的以色列人， ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","并且所有亚伯拉罕的后裔都是他真正的孩子。正如经文所说：“以撒所生才算作你的后裔。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","所以并非亚伯拉罕的血缘之子即可被视为上帝之子，只有获得上帝承诺方为他的真正后裔。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","上帝如此承诺：“明年我会回归，撒拉必生一子。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","不仅如此，我们的祖先以撒也是利百加双胞胎儿子的父亲。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","但就在双胞胎出生之前，在他们做出任何正义或错误行为之前，（这样上帝的旨意才能延续，证明上帝并非根据人的行为而对其进行召唤） ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","她就已被告知，“哥哥将会为弟弟服务。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","正如经文所记：“我选择雅各，放弃以扫。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","那么我们应该得出怎样的结论？上帝不公？当然不是！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","正如上帝对摩西所说：“我应该向谁施以怜悯，我应该向谁施以慈悲，由我决定。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","因此，这并不取决于我们想要什么，也不取决于我们自身的努力，而是取决于上帝的慈悲本性。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","经文中记载上帝对法老说：“我将你置于这个地位自有原因，我通过你彰显我的力量，让我的名字传遍世界。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","所以，上帝以怜悯或强硬的态度对待谁，都是他想要这么做。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","你们可能会争辩：“那他为什么还要责怪我们？谁能抗拒上帝的旨意？” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","不能这么说，你又是谁？一介凡人而已，怎能反驳上帝？被创造的万物怎能对造物主说：“你为什么将我造成这个样子？” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","陶艺家用同一批粘土制作漂亮的碗和常用的锅，他难道没有权利使用吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","好比上帝要表明他反对罪恶，彰显他的能力，容忍这些“注定毁灭之罐”， ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","这样才能通过这些“怜悯之罐”彰显他的伟大荣耀，提前为荣耀做好准备。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","这就是我们——他所召唤之人，不仅来自犹太人，也来自外族人…… ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","上帝在《何西阿书》中说道：“他们并非我的子民，但我会称其为我的子民，他们并非蒙我所爱，我要称其为蒙我所爱。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","并且，“如果他们在身处之地被告知：‘你们并非我的子民，’就是在那里，他们将被称为永生上帝之子。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","以赛亚向以色列人呼喊：“尽管以色列子孙多如海沙，但得救者却只有少数。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","因为主将快速而彻底地完成他在人世的审判。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","正如以赛亚之前所说：“如果至高之主未给我们留下后裔，我们的结局就和所多玛和蛾摩拉别无二致。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","那么我们应该得出怎样的结论？外族人可能从未想过要正义行事，但却深知何为正义，然后通过他们对上帝的信任，做出道德正确之事。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","但以色列人却盯着律法行上帝之正义，却从未成功。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","为什么？因为他们只根据行为决定正义，而不是通过相信上帝。他们就像被绊脚石绊倒， ");
INSERT INTO cmnfeb_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","正如经文所预言：“看，我在锡安放了一块绊脚石，一块会绊倒世人的磐石。但相信他的人绝不会失望。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","我的兄弟姐妹们，我内心的渴望、我对上帝的祷告，就是要拯救以色列人！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","我可以证明他们对上帝的热情奉献，但这并未基于真正了解他。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","他们不理解上帝如何让我们变得良善正直，他们试图靠自己变得良善正直，不肯接受上帝让人类良善正直的方式。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","基督就是律法的执行，相信基督即为正义。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","摩西写道：“凡遵守律法的行善之人，都会活着去。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","但源于信的正义行事态度却会这样说：“不要问‘谁会上天堂？’（请求将基督带到人间），” ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","或“谁要到死人的地方去？”（请求让基督死而复生）。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","经文其实已经说了：“上帝之道与你非常近，它就是你口中所云、心中所想。”事实上，这道就是源自我们所展示的信任。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","如果你宣布接受耶稣为主，并且在内心确信上帝让耶稣死而复生，你就会获得救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","你对上帝的信任成就你的正义和善良，你宣布接受上帝将会拯救你。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","正如经文所说，“信他之人不会失望。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","犹太人和希腊人本无区别。因为这唯一的主是每个人的主，只要向他请求，他必慷慨赐予。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","因为“呼唤主之名的人必得救。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","但人们怎么能呼唤他们并不相信之人？怎么能相信从未听说之人？除非被告知，怎么能听到？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","除非被派遣，否则怎么能走出去告诉其他人？正如经文所说：“带来福音之人才会真正受到欢迎！” ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","但并不是每个人接受这福音。正如以赛亚所问：“主啊，从我们这里听到福音之人，谁会相信？” ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","信任上帝源于聆听——聆听基督之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","他们并不是没有听到。恰恰相反：“全世界都已听到传播上帝之道的声音，他们的讯息传遍了整个世界。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","所以我的问题是，“难道以色列不知道吗？”首先摩西说：“我会让你们嫉妒，嫉妒那些并非子民之人，我会让你们愤怒，因那些并不知情的外族人而愤怒！” ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","以赛亚甚至以更强烈的态度说到：“那些未寻找我的人，找到了我，那些未请求我的人，我向其显示。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","上帝对以色列人说：“我始终都向那些悖逆顽固之人伸出双手。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","但我要问：“上帝是否拒绝了他的子民？”当然不是！我就是以色列人，来自便雅悯支派。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","上帝不会弃绝他所选择的子民。还记得经文中如何描述以利亚吗？他向上帝抱怨以色列，说： ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“主啊，他们杀了你的先知，毁坏了你的祭坛。现在只剩我一人，他们也想杀了我！” ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","上帝如何回答他？“我还留有七千人没有向巴力膜拜。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","如今也是同样的情况：仍然有虔诚之人留下来，那是上帝恩典所选之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","由于是通过恩典所选，很显然这选择并非基于人们的所作作为，否则恩典便不会称为恩典！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","那么我们可以得出什么结论呢？以色列人并未达成他们为之奋斗的目标，只有被选中之人达成，其他人则变成铁石心肠。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","正如经文所说：“上帝让他们的思想麻木，所以直到今日，他们眼不能见，耳不能听。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","大卫补充道：“让他们的盛宴成为他们的陷阱，成为捕捉他们的网，那是带来惩罚的诱惑。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","让他们双眼失明无法看到，让他们始终因沮丧而弯腰驼背。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","但我并不是在说，他们会因跌倒而彻底倒下。绝非如此！但因为他们的错，救赎降临到其他国家，“让他们嫉妒。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","如果他们倒下会让世界受益，那他们所失去的会让外族人受益，如果他们完全达成了自己注定的成就，将会带来更多益处。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","现在我想和你们外族人说几句。我是向外族人传道的传教士，我宣讲自己所行之事， ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","这会让我的子民嫉妒，他们中的某些人也会因此获得救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","如果上帝拒绝他们会让世人成为上帝的朋友，那么上帝就会接纳他们，就像让死人复活！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","如果首先献祭的那部分面包圣洁，其他的面包也同样圣洁，如果树根圣洁，树枝也是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","如果有些枝条被折断，就会将你这根野橄榄枝接在树上，与其他树枝分享橄榄树根部的养分， ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","所以你不能看低其他树枝。如果你忍不住想要吹嘘，请记住并非你在滋养树根，而是树根在滋养你。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","你可以说：“树枝折断了，所以可以将我嫁接在上面了。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","但他们折断是因为不信上帝，但你因为相信上帝，才能留在树上。所以不要自视甚高，而是要心存尊重， ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","因为如果上帝无法饶恕树上原来生长的枝杈，也不会饶恕你。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","你要知道上帝既良善又强硬。他对堕落之人非常严厉，但只要你相信他的良善，他就会良善对你，否则也会将你折断。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","如果他们不再抗拒相信上帝，就会重新被嫁接到树上，上帝有能力这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","如果可以将你从一棵野橄榄树上砍下，然后嫁接到一棵人工栽培的橄榄树上，那么重新嫁接到他们原始生长的树，岂不是更容易？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","我的兄弟姐妹们，希望你们不要忽略这曾被隐藏的真理，否则你们就会变得自负。以色列人的心已经开始变得坚硬，直到接纳外族人的过程彻底完成。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","所有以色列人必须通过这种方式获得拯救。正如经文所说：“救世主将来自锡安，他会改变雅各，让他不再与上帝对立。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","我承诺他们，我会带走他们的罪。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","尽管他们是福音之敌，但这对你们有益。他们仍是天选子民，因其祖先而获得上帝的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","上帝不会收回他的恩赐和召唤。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","你曾经不服从上帝，但现在上帝因他们的不服从，而对你予以怜悯。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","他们现在就像你曾经那样不服从，最终他们也会像你一样获得怜悯。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","对于所有不服从之人，上帝都会将其视为囚徒，以此怜悯所有人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","上帝的富饶、智慧和知识如此深奥！他的决定令人难以置信，他的方法让人难以想象！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","谁能知晓上帝的想法？谁能给他建议？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","你给予上帝的，上帝难道必须偿还？ ");
INSERT INTO cmnfeb_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","世间一切都源于他，世间一切都因他而存在，世间一切都为他而存在。愿荣耀永远归给他，阿门！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","我的兄弟姐妹们，因为上帝同情你们，所以我鼓励你们把自己的肉体之躯献给上帝，作为圣洁和喜悦的活祭。这是顺理成章的敬拜方式。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","不要在这世上随波逐流，要通过思想的灵性新生而蜕变，这样就可以彰显上帝真正的旨意：善良、欢喜和完美。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","通过上帝赐予我的恩典，我要向你们所有人解释一点：每个人都有自己应该成为的样子，你不应自视甚高。你应该根据上帝给你的信的程度，理智地看待自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","正如人体有很多组成部分，但每个部分的作用不尽相同， ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","尽管我们人数众多，但我们的身体与基督相同，我们属于彼此。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","每个人都拥有不同的恩赐，因上帝赋予我们的恩典而异。如果这是在说上帝，就要根据你信的程度行事。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","如果应该服侍上帝，就去服侍；如果你应该进行教导，就去教导； ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","如果应该鼓励他人，就去鼓励；如果应该给予，就慷慨给予；如果应该引领，就应承诺予以引领；如果应该慈悲，那应该高兴地这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","爱必须真诚。憎恨一切邪恶，紧紧抓住善良。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","像爱你的家人一样对彼此奉献，重视他人胜过自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","不要因付出辛劳而不情愿，要以满腔热忱侍奉主。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","因你的希望而保持欢乐，接受那即将到来的困难，继续祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","通过给予满足上帝子民的需求，热情款待陌生人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","祝福迫害你的人——祝福他们，而不是诅咒。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","与快乐之人一起快乐，与哭泣之人一起哭泣。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","为彼此着想。不要认为自己比别人更重要，要谦逊，不要自负。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","不要以恶报恶。向所有人展示你正在行善， ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","在你力所能及的范围内，与所有人和平相处。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","亲爱的朋友们，不要想着报复，上帝自会审判。正如经文所说，“主说：‘我必伸张正义，我必报应。’” ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","如果你的仇敌饿了，给他们食物，如果他们渴了，给他们水，这样做就如同把火炭堆在他们头顶。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","不可被恶战胜，要以善胜恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","每个人都应该服从当权者，因为除非上帝许可，否则没有人拥有统治的权力，这些权力均由上帝赋予。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","抗拒这权力即对抗上帝的安排，抗拒者自会遭受相应的审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","因为统治者不会威慑正义之人，而是威慑错误之人。只有正义行事，你就不会害怕这权力，才会得到他们的认可。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","当权者即上帝的仆人，他们当权也是为了你好。如果你犯错就应该感到害怕。毫无疑问，当权者自有权力予以惩罚！他们是上帝用于惩罚罪人的仆人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","因此，遵从劝诫至关重要，不只是因为犯错可能会遭受惩罚，这也是为了遵循你的良心。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","所以你也必须纳税，因为当权者是上帝负责处理这种事情的仆人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","欠人钱就一定要还；该缴的税款一定要交；该付的费用一定要支付；尊重值得尊重之人，敬畏值得敬畏之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","不要亏欠任何人，除非是出于对彼此的爱——因为爱其邻里之人即成就了律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","“不可奸淫、不可杀人、不可偷盗、不可贪婪”——这些诫命的核心都在“爱人如己”这句话之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","爱不会伤害任何人，所以爱成就律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","你必须这样做，因为你应该意识到现在时间多么紧迫，现在应该从睡梦中醒来。因为相比我们最初信任上帝之时，现在的我们距离拯救更近。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","夜已深，白昼即将来临！让我们摆脱黑暗的行为，披上光明的盔甲。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","让我们以得体的举止表明，我们生活在光明之中。我们不应该将时间用来设宴买醉，或追求不道德的放荡纵欲、纷争嫉妒。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","我们应该紧随主耶稣基督，而非屈从于个人罪恶的欲望。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","如果一个人还在犹豫是否应该相信上帝，接受他们，不要为个人观点争论不休。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","有的人可能相信他们什么都能吃，但信任更弱之人只吃蔬菜。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","什么都能吃的人不能小看吃素之人，吃素之人也不要批评什么都能吃之人——因为他们都可以被上帝所接纳。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","你有什么权力评判别人的仆人？只有他的主人能决定他们的对错。在主的帮助下，他们能够选择坚守良善正直。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","有些日子对你可能特别重要，但对其他人而言，每一天都没有差别。每个人都应该坚守自己的想法。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","有些人因主更注重特殊的日子； 有些人从不因主而忧虑吃什么，因为他们感谢上帝； 而那些不吃某些东西的人是为主而吃的，他们也感谢上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","我们活着并非为自己，死亡也并非为自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","我们为主而活，为主而死——所以，无论生死，都是属于主。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","基督也是因此死而复生——这也让他成为活人和死人的主。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","那么你又怎能批评其他信徒？你为什么要鄙视其他信徒？因为我们所有人都会站在上帝的审判台前。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","正如经文所说：“主说：‘我确认万众将在我面前跪拜，齐声唤我上帝，正如我宣告自己的永生。’” ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","所以每个人都应向上帝解释自己的所作所为。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","我们不要彼此评判，而是要下定决心，不要在其他信徒的道路上设置障碍，不要让他们跌倒。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","在主耶稣的劝说下，我确信从礼仪的角度而言，任何食物都是洁净的。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","如果你因食物问题而让其他信徒受到伤害，你的行为就无法体现爱。不要因为你选择吃下的食物，而去摧毁那些基督为之而死的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","不要让你所做的善行被误传—— ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","因上帝之国并非关乎吃喝，而是关乎遵循正义生活，因圣灵带来平安和喜乐。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","任何以这种方式侍奉基督之人，都会让上帝感到喜悦，获得他人的赞许。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","所以让我们追求和平之路，努力互相鼓舞。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","不要因为食物争论不休，破坏上帝所做之事。万物皆洁净——错在因食物而冒犯别人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","最好不要做吃肉喝酒或是其他让信徒们跌倒的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","你个人的信，那是你和上帝之间的事情。那些采用自己认为正确的方式行事之人，这时候不去谴责才是有福！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","但如果你疑惑吃的食物是否对错，那就不应该吃，因为你无法确认它就是对的。你所做的任何事情如果缺乏坚定的信，便是罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","我们这样虔诚之人应该支持心灵软弱之人。而不只是取悦自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","我们应该鼓励他人去做道德正确之事，帮助他们变得强大。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","基督活着并非为了取悦自己，而是如经文所说，“虐待你之人应承受的侮辱，都由我承担。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","这段古老经文是为了帮助我们理解并鼓励我们，以便我们可以在希望中耐心等待。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","在追随基督耶稣的过程中，愿那赐予我们忍耐和鼓励的上帝帮助你们团结一心， ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","让你们同心同声赞颂主耶稣基督之父上帝的荣耀！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","所以要像基督接纳你们一样彼此接纳，把荣耀归给上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","我坚信基督作为犹太人的仆人来到世间，就是为了表明上帝所言均为真理，信守了他对他们祖先的承诺。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","他来此也是为了让外族人赞美神的慈悲，正经文所说：“所以我要在外族人中赞美你，歌颂你的名。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","还有那句：“外族人啊，与他的子民共同庆祝！” ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","“所有的外族人啊，赞美主，愿万民赞美他。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","以赛亚还说过：“耶西的后裔要统治世界，外族人要对他寄予厚望。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","愿希望之神因你对他的信，将所有喜悦与平安充满你的心，让你因圣灵的力量而充满希望！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","我的兄弟姐妹们，我深信你们满心善良，拥有渊博知识，所以能够彼此教导。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","这封信函中，我直言不讳地阐述了自己的某些观点，只是为了提醒你们。因为上帝赐予我恩典， ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","承担基督耶稣向外族人传道的使命，就像神父分享上帝的福音，让他们成为上帝接纳的敬献，通过圣灵实现圣洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","因此，侍奉上帝是一件引以为荣之事， ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","（因为这是基督通过我所行之事，否则我断然不敢妄言），我已通过教导和展示， ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","借着神迹和奇迹的力量以及圣灵的能力，引领外族人顺服上帝。从耶路撒冷一直到伊利里亚姆，我在所到之处传遍基督的福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","事实上，我盼望和在未听说基督之名的地方传播福音，这样我才不会在其他人所为的基础上传道。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","正如圣经所说：“未曾听闻福音之人将会知晓，未曾了解之人将会明白。” ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","这就是为什么我多次想要来探望你们，却始终受阻无法成行的原因。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","但是现在，由于我已在这里传遍了福音，加之多年来一直期待拜访你们， ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","所以希望在我去西班牙时能够与你们相见。当我们相见之时，也许你们可以为我的旅程提供一些帮助。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","此刻我正在去耶路撒冷的路上，那里的信徒需要帮助。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","因为马其顿和亚该亚的信徒认为，应该向耶路撒冷的贫困信徒送去捐赠。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","他们很愿意这么做，认为这是他们应尽的本分。因为外族人感受到了灵性的收获，所以也认为应该在物质上为犹太信徒提供帮助，表达感谢。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","当我完成这项工作，安全地将这笔捐款交给他们，就会在去西班牙的途中拜访你。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","我知道当我与你们见面时，基督一定会赐予我们满满的祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","我的兄弟姐妹们，我鼓励你们通过主耶稣基督和圣灵的爱，共同为我祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","祈祷我不会被犹太地不信上帝的众人所伤害，祈祷耶路撒冷的信徒会欢迎我的工作。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","祈祷我如上帝所愿，将喜悦带到你们身边，让我们能够因彼此的陪伴而欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","愿赐平安的上帝与你们众人同在。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","在此向你们推荐我们的姐妹非比，她是坚革里教会的执事。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","请以主之名，用合乎信徒身份的方式接待她。无论她需要什么，请帮助她，因为她曾帮助过许多人，也曾帮助我。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","请转达我对百基拉和亚居拉的问候，他们曾与我一起为耶稣基督工作， ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","曾为我冒着生命风险。不只是我很感谢他们，所有外族人的教会也都感激他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","我想要问候在他们家中的教会。问候亲爱的朋友以拜尼妥，他是亚西亚省第一位追随基督之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","问候马利亚，她一直在为你们辛勤付出。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","问候我的同乡安多尼古和犹尼亚，他们曾与我一起囚禁于监牢。他们在门徒中时很有威望，早在我之前就已追随基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","问候我亲爱的朋友暗伯利，他与主同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","问候与我共同侍奉基督的珥巴努以及亲爱的朋友士达古。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","问候追随基督、值得信赖的亚比利。问候亚里斯多博的家人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","问候我的同乡希罗天，以及拿其舒家中属于主的所有人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","问候为主辛劳工作的土非拿和土富撒，以及亲爱的彼息，她为主奉献了太多。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","问候主的优秀仆人鲁孚和他的母亲，我也将她视为我的母亲。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","问候亚逊其都、弗勒干、赫米、百罗巴、赫马和与他们同在的兄弟们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","问候非罗罗哥和犹利亚、尼利亚与他的姐妹阿林巴以及同他们在一起的众信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","热切地问候彼此，基督的众教会向你们致以问候。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","我亲爱的信徒朋友们，对于你们所学的教义，如果有人在你们中间制造纷争和困扰，奉劝你们要小心他们，一定要远离！ ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","这种人并不服侍我们的主基督，只服侍自己的欲望，只会用花言巧语欺蒙骗毫无戒心的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","人人都知道你们有多么忠诚，这让我满心欢喜。但我希望你们能知晓善良和纯洁，也能慧眼识别罪恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","和平的上帝很快就会战胜撒旦，让他臣服于你们。愿主耶稣的恩典与你们同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","我的同工提摩太和我的亲族路求、耶逊和所西巴德都问候你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","（我——代笔写这封信的德图——也与主问候你们。） ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","那接待我也接待全教会的该犹，问候你们。本城的司库以拉都和夸图的信徒问候你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","让我们向上帝致敬 通过我所传福音和耶稣基督之道，上帝让你们更强大。 如今这奥秘 已经显现， 这真理的奥秘曾不被世人所知， ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","但现在通过众先知之笔昭然于世， 遵循永恒上帝的谕旨， 展示在全世界所有人的面前， 让他们相信并顺服于上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","让我们借由耶稣基督， 向唯一睿智的上帝致敬， 祝他荣耀永存。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","此函来自教会兄弟保罗和苏提尼。保罗已奉上帝旨意召唤，成为基督耶稣的使徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","本函将送至哥林多的上帝教会，他们已凭耶稣基督成就良善正直，受到召唤成为圣徒。本函还将送至世界各地敬拜主耶稣基督之人。基督是他们的主，也是我们的主。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","愿你们获得来自天父和主耶稣基督的恩典与平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","上帝通过基督耶稣赐予你们的恩典，为此我始终都在感谢上帝， ");
INSERT INTO cmnfeb_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","你们因上帝而万事丰饶，因上帝而表达思想、知识渊博。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","事实上，你们的经历证明了基督的见证， ");
INSERT INTO cmnfeb_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","当你等待主耶稣基督到来之时，才不会错过任何圣灵的恩赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","他会让你坚强到底，让你们在主耶稣基督之日前始终坚守正义。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","上帝值得我们信赖，他呼唤你们，就是为了你与他的儿子、我们的主耶稣基督同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","兄弟姐妹们，以主耶稣基督之名，请大家同心同德，不要分裂，构筑一条心，遵循一个使命。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","我的兄弟姐妹们，几名革来氏人曾和我说起你们，讲述了你们内部的纷争。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","让我对我的意思予以解释：你们的引领者各不相同：“我追随保罗”、“我追随亚波罗”、“我追随矶法”或“我追随基督。” ");
INSERT INTO cmnfeb_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","难道基督是分裂的？为你们钉上十字架的是保罗？你是以保罗的名义受洗的吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","感谢上帝，除了基利司布和该犹以外，我未给你们任何人施洗， ");
INSERT INTO cmnfeb_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","所以请不要将施洗之名归于我。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","（对了，我还曾给司提芬一家人施洗；再无他人。） ");
INSERT INTO cmnfeb_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","基督派我前来并非为了施洗，而是要传播福音，但不能以人类的伶牙俐齿，否则基督的十字架将失去力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","十字架之道对于迷失之人而言毫无意义，但对于我们这些获得拯救之人，却体现了上帝的至高力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","正如经文所说：“我将摧毁智者的智慧，抹去聪明人的聪明。” ");
INSERT INTO cmnfeb_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","那么当代的智者、宗教老师和哲人又如何呢？上帝是将这世界的智慧变成愚蠢吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","既然上帝在他的智慧中允许世界在其智慧中不认识上帝，这是神的恩典计划，通过这愚昧的好消息，那些相信他的人将得到拯救。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","犹太人要求看到神迹，希腊人渴望获得智慧， ");
INSERT INTO cmnfeb_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","我们的道却在讲述钉在十字架上的基督——犹太人视其为冒犯，外族人视其为愚蠢。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","但对于上帝召唤之人，不论是犹太人或外族人，基督就是上帝的力量，上帝的智慧。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","因为即使是上帝的愚蠢也比人类智慧，即使是上帝的软弱也比人类坚强。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","兄弟姐妹们，不要忘记，在那些受到上帝召唤的人中，很少有人是世俗定义中的智慧、权威和尊贵之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","相反，上帝所选择的是世人视为愚笨之人，这足以让那些自认为智慧之人感到羞愧。他也选择了世人被视为软弱之人，足以让自认为强壮之人羞愧。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","他还挑选了被世人视为卑贱、被众人轻视之人，甚至还有被世人认为毫无价值之人， ");
INSERT INTO cmnfeb_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","让任何人都不能在上帝面前自吹自擂。 ");
INSERT INTO cmnfeb_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","因为上帝，你们才能与基督耶稣同存，基督就是上帝赐予我们的智慧。他让我们成为正义，保持正义，让我们获得自由， ");
INSERT INTO cmnfeb_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","正如经文所说：“想要吹嘘，也要吹嘘主。” ");
INSERT INTO cmnfeb_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","兄弟姐妹们，以前去拜访你们时，我讲述了上帝希望你们了解的正道，但并未试图用漂亮的辞藻或看似精妙的智慧来吸引你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","因为我决定，与你们在一起时，我只想关注耶稣基督和他钉上十字架之事。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","我以软弱、惧怕和战战兢兢的方式出现在你们面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","我并未用雄辩的智慧语言说服你们，只是通过证据和圣灵力量予以证明， ");
INSERT INTO cmnfeb_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","通过这种方式，你们才不会凭借人的智慧相信上帝，而是凭借上帝的能力。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","但当我们与精神上的成熟之人交流，变回使用智慧之语，但并非这世间的智慧，也不是人类统治者的智慧，这些统治者很快就会从世间消失。相反， ");
INSERT INTO cmnfeb_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","我们以奥秘解读上帝的智慧。上帝在创世之前便已为我们的荣耀立下这奥秘，曾一直被隐藏，如今已经显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","没有哪位人间当权者知晓这奥秘，如果他们知道，就不会把荣耀之主钉上十字架。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","正如经文所记：“上帝为爱他之人所准备的一切，乃眼不曾见过、双耳不曾听过、人思想未曾想过。” ");
INSERT INTO cmnfeb_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","但上帝却通过圣灵向我们显明这一切，因为圣灵能够参透上帝深邃的内在。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","除了真实的自己，还有谁了解你的想法？同样，除了上帝的灵，还有谁知晓上帝的想法？ ");
INSERT INTO cmnfeb_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","我们从上帝那里领取的不是人世之灵，而是来自上帝的灵，这样我们才能理解上帝的慷慨馈赠到底是什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","我们的言语也是如此，所使用的并非人类的智慧语言，而是圣灵传授的语言。我们以圣灵的语言，解释何为圣灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","当然了，心中没有圣灵之人，也不会接受来自上帝的灵。我们的言语对他们而言就是一派胡言，他们无法理解，因为圣灵之事需细细思量。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","与圣灵同在之人能看透万事，但却无人能看透他。 ");
INSERT INTO cmnfeb_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","因为“谁理解主的心意并思量着指教他？”但我们的确拥有了基督的心意。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","兄弟姐妹们，之前与你们交流之时，无法把你们当作圣灵信徒，只能将你们视为俗世中人，就像婴儿时的基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","我喂养你们的是牛奶，不是饭菜，因为那时你们还没有准备好。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","即使现在，你们仍然没有准备好，仍是俗世中人。因为你们仍然会嫉妒纷争，你们的行为就像普通人一样，难道不是说明，你们仍然是俗世中人吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","有人说“我追随保罗”，有人说“我追随亚波罗”，这正说明你们仍然是普通凡人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","亚波罗是谁？保罗是谁？我们不过是你所信仰之人的仆人，每个人都按照上帝的要求行事。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","我负责栽种，亚波罗负责浇灌，但只有上帝才能让它生长！ ");
INSERT INTO cmnfeb_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","所以，栽种和浇灌之人没什么了不起，真正了不起的，是让你成长的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","栽种的和浇灌之人都有着同样的目标，只是按照其付出的努力获得酬劳。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","我们是与上帝共同劳作的工人，你们是上帝的田地，上帝的房屋。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","通过上帝赐给我的恩典，我就像娴熟的建筑师打下根基，现在由其他人在上面建造。建造之人要小心自己的一举一动。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","因为除了已经打好的根基——即耶稣基督，任何人都不能立下其他根基。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","如果有人用金银、宝石、木头、枯草或稻秆在根基上建造， ");
INSERT INTO cmnfeb_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","所使用的材料早晚都会显露，因为当审判日到来，它们会在火焰中显现并经受考验。每个人的工作都会显现出它本来的样子。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","如果你的建筑经得起考验，就会得到赏赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","如果你的建筑被烧毁，就会遭受损失。他们仍然会获得拯救，但却像穿越火焰一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","难道你不知道吗？你就是上帝的圣殿，上帝之灵就在你们心中。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","毁坏上帝圣殿之人，上帝必摧之，因为上帝之殿为圣洁之地，这圣殿就是你。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","不要自欺欺人。如果你自诩拥有人间的智慧，就应该变为愚人，这样才是真正的智慧。 ");
INSERT INTO cmnfeb_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","因为对于上帝而言，人间的智慧都是愚蠢。正如经书所言：“他让智慧之人的聪明，让他们犯错。” ");
INSERT INTO cmnfeb_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","经书还说：“主知道智慧之人的辩论毫无意义。” ");
INSERT INTO cmnfeb_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","所以不要夸耀人，因为你们拥有一切， ");
INSERT INTO cmnfeb_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","无论是保罗、亚波罗或矶法，无论是世界、是生还是死，是现在或是将来，都是如此。你们拥有一切， ");
INSERT INTO cmnfeb_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","你们都为基督所有，基督则为上帝所有。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","所以，要把自己看作基督的仆人，为“上帝的奥秘”负责。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","不仅如此，承担这一职责之人，还必须值得信赖。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","无论你或其他人评判我，我都完全不介意。事实上，我甚至也不会评判自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","我不记得自己做过错事，但这并不代表我在道德上称得上良善正直，只有主才能评判我。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","所以，在恰当时机到来之前——即主降临之前，不要做出任何评判。他将照亮那被隐藏的、最黑暗的秘密，袒露人心里的动机。届时，上帝会给每个人应得的称赞。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","那么，兄弟姐妹们，我用我自己和亚波罗给你们做例子，让你们了解，不要超越经文所记内容，不要自高自大，不要偏爱任何人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","是什么让你如此特别？你拥有了什么，才让上帝不肯给予你？既然是来自上帝的给予，为什么要傲慢地否认这一点？ ");
INSERT INTO cmnfeb_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","你以为拥有了所需的一切。你以为自己如此富有。你以为自己是王，不再需要我们。我倒真的希望你就是国王，这样我们就可以与你共同为王！ ");
INSERT INTO cmnfeb_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","在我看来，上帝将我们这些使徒排在队列的最后，作为一种展示，尽管我们也会向其他人一样死去，但那只是我们在整个宇宙面前、在天使和人类面前，演了一场戏。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","我们是基督的愚人，但与上帝同在的你却如此智慧。我们软弱，你们强壮！你们受人尊敬，我们被瞧不起！ ");
INSERT INTO cmnfeb_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","即使是现在，我们仍然饥渴难耐、衣不蔽体、遭受殴打、无处安身。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","我们艰难辛苦地劳作。被人咒骂，我们会为其祝福；遭人迫害，我们会忍受； ");
INSERT INTO cmnfeb_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","被人毁谤，我们报以善意。直到现在，人们视我们为泥土、这世上最肮脏的垃圾。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","我写这番话并非让你们羞愧，而是把你们当作我最爱的孩子一样给出警告。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","纵然你们有成千上万的基督徒教师，但却没有多少人可以称其为父。因为基督耶稣的缘故，当我与你们分享福音，便可成为你们的父亲。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","所以我请求你们，一定要效法我。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","也正是因为这个原因，我派提摩太去拜访你们。他与主同在，是我最值得信赖、最喜爱的儿子。他将提醒你们我如何追随基督，就像我在各会堂中所作的教导。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","有人以为我不会到他们那里去，于是就变得骄傲自负。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","但只要是主的意愿，我很快就会去往那里。然后了解那些傲慢自负的人都说了什么，知晓他们的能力如何。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","因为上帝之国并不关注言语，而要看能力。 ");
INSERT INTO cmnfeb_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","那么你期待什么？让我带着棍子去殴打你，还是带着爱和温柔的灵出现？ ");
INSERT INTO cmnfeb_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","听说你们那里正发生淫乱之事，即使外族人也不会这么做，一个男人竟与他的继母同居。 ");
INSERT INTO cmnfeb_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","你们太自以为是了！难道你们不应该悲伤哭泣吗？然后驱逐做出这种事的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","我的身体不在你们那里，但心灵却与你们同在，就像我已审判了做出这种事的罪人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","当你们以主耶稣之名聚在一起，我的灵便与你们同在，与主耶稣的力量同在， ");
INSERT INTO cmnfeb_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","这种罪人应该交给撒旦，摧毁他的罪恶天性，然后在主来临之日获得救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","不要因此而感到骄傲。你们不知道吗？一点酵母就能让整个面团发酵。 ");
INSERT INTO cmnfeb_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","清除这些旧酵母，你们才能成为新面团，制作没有酵母的饼。耶稣基督作为逾越节的羊羔，已经被杀献祭。 ");
INSERT INTO cmnfeb_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","所以在庆祝这个节日时，不要使用旧酵母或邪恶的酵母，而要做出诚挚真实、没有酵母的饼。 ");
INSERT INTO cmnfeb_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","我以前曾写信告诉你们，不可与淫乱之人来往。 ");
INSERT INTO cmnfeb_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","我并非指这世上所有贪婪、欺诈或膜拜神像的不道德之人。否则，你们在这个世界就待不下去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","我在这封信中想要告诉你们，如果一个人自称基督徒，但却做出淫乱、贪婪、膜拜神像、辱骂、醉酒或勒索的行径，不可和他来往，甚至不应该与之共同用餐。 ");
INSERT INTO cmnfeb_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","我无权审判教外之人，但难道你不能审判教内之人吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","教外之人自有上帝来审判。“将邪恶之人从你们中间驱逐。” ");
INSERT INTO cmnfeb_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","你们如果与邻居起了纷争，为什么要向不义的法官提交诉状呢？你应该将这件事告知其他信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","难道你们不知道吗？基督信徒将审判世界。如果世界都由你们来审判，怎么就不配审判如此琐碎小事？ ");
INSERT INTO cmnfeb_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","你们不知道吗？我们将要审判天使，更何况今世所发生的这种人间之事？ ");
INSERT INTO cmnfeb_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","如果你需要评判今世之事，怎能让教会并不尊重的人做出审判？ ");
INSERT INTO cmnfeb_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","我说的这番话，就是要让你们羞愧。为什么？难道你们中间没有智慧之人，可以审判这样的纷争吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","相反，信徒会跑到法庭状告其他信徒兄弟，向不信上帝之人提交诉状？ ");
INSERT INTO cmnfeb_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","你们状告彼此，已经是一个彻头彻尾的灾难。接受这不公正不好吗？为什么不甘心受到欺骗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","你们的行为反倒会造成不公正，造成欺骗，而且是针对你们在教会中的信徒同伴。 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","你们难道不知道吗？不义之人将无法继承上帝之国，不要被蒙骗！那些淫乱、膜拜神像、奸淫、性变态、同性恋、 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","偷窃、贪婪、酗酒、辱骂人或勒索之人，都不能继承上帝之国。 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","你们有些人曾经如此，但借由主耶稣基督之名，凭着上帝之灵，你们变得洁净、圣洁和正义。 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","人们会说：“我有做事自由”，但任何事情都要适可而止。“我有做事的自由”，但绝不会受任何事的掌控！人们说 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","食物是为了肠胃，肠胃是为了食物，但上帝却会废掉这两者。同样，身体的存在不是为了淫乱，而是为了主而存在。同样，主也是为了身体而存在。 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","上帝凭借其力量让主复活，也要用同样的力量让我们复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","你们难道不知道吗？你们的身体就是基督身体的一部分，我们怎么能使用基督的身体，与娼妓的身体苟合？当然不可以！ ");
INSERT INTO cmnfeb_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","难道你不知道吗？与娼妓苟合，就是与她成为“一体。”记得经文所说：“两个人要成为一体。” ");
INSERT INTO cmnfeb_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","但与主结合，就代表与主的灵融为一体 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","行淫乱之事。人类所犯罪行都在身体之外，唯有淫乱是对自己身体犯下的罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","你们不知道吗？我们体内的圣灵，就住在身体这个圣灵之殿中，这圣灵是你从上帝那里领取的并不属于你自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","你并不属于自己，而是根据标价购买而来。所以要用你的身体为上帝带来荣耀！ ");
INSERT INTO cmnfeb_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","你们在信中提到： “不结婚最好。” ");
INSERT INTO cmnfeb_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","但为了避免淫乱的诱惑，男人应当有自己的妻子，女人应当有自己的丈夫。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","丈夫应该满足妻子的性需求，而妻子应该满足丈夫的性需求。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","妻子的身体不只属于她，还属于她的丈夫。同样，丈夫的身体不只属于他，还属于他的妻子。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","夫妻不可剥夺拥有彼此身体的权力，除非暂时达成共识，比如需要花时间祈祷。此后仍然要住在一起，否则撒旦会趁着你们缺乏自控的时候，诱惑你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","我这番话并非命令，而是妥协。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","我希望人人都像我一样。但各人都有自己从上帝那里获得的恩赐，这恩赐也各有不同。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","我想对未婚者和寡妇说，他们最好能始终像我这样。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","但如果你缺乏自控力，就应当结婚，因为结婚总比被欲望吞噬好。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","我还要劝诫已婚之人（此言并非出自我，而是主的吩咐）：妻子不可离开丈夫。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","（离开就不可再嫁，或只能与丈夫复合。）丈夫也不可离弃妻子。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","我还要对其他人说（此言是我的看法，并非来自主），倘若一名基督徒男人的妻子不信基督，但她愿意和他生活一起，他就不要离弃她。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","如果一位基督徒女子的丈夫不信基督，但他愿意和她生活在一起，她也不要离弃丈夫。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","因为不信基督的丈夫会因妻子而圣洁，不信的妻子会因丈夫而圣洁了。否则，你们的后代便不洁净，但现在他们都变得圣洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","但如果不信基督的一方要离去，就由其去吧。在这种情形之下，基督徒男女不要勉强，因为上帝让我们生于平和。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","做妻子的，你知道吗？你应该拯救你的丈夫！你做丈夫的，你知道吗？你应该拯救你的妻子！ ");
INSERT INTO cmnfeb_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","除了这样的例子，主怎样安排你，就保持下去。上帝怎样召唤你，就继续这样的生活。我也这样教导其他教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","如果转变信仰时已经受了割礼？那就成为已受割礼的信徒。如果你转变信仰时未受割礼，那就做未受割礼的信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","割礼不代表什么，未受割礼也不代表什么，最重要的是遵守上帝的命令。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","每个人受到上帝召唤时，都应当保持原来的状态。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","你被召唤时是奴仆？不要烦恼。但如果你获得自由的机会，就好好把握。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","因为奴仆接受主的召唤后，就是属于主的自由人，你就为基督服务。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","上帝已经买下了你们，所以不要做人的奴仆。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","兄弟姐妹们，你们听到上帝的召唤时，就保持原来的状态，与上帝同在即可。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","关于“未婚之人”，我并未从主那里获得这方面的指引。但我既然获得了主的怜悯，是他信赖之人，我就需要表明我的意见。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","鉴于目前的困难情况，我认为人最好就是保持现状。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","已经结婚？就不要尝试离婚。还没有结婚？不要想办法结婚。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","如果你已经结婚，这不是罪。如果处女出嫁，也不是罪。但在当今世界中，你可能会遇到很多困难，我不希望你们受这样的苦难。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","兄弟姐妹们，告诉你们吧，剩下的时间不多了。从今以后，结婚之人可能也像没有结婚， ");
INSERT INTO cmnfeb_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","哀哭之人不像在哀哭，快乐之人不像在快乐，买下东西的人仿佛从未拥有， ");
INSERT INTO cmnfeb_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","享用世界之人仿佛从未享用，因为这世界的秩序将会消失。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","我愿你们不会产生这样的忧愁。未结婚之人，应专注主最看重之事，要想着如何取悦主。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","但娶妻之人会关注人世间重要之事，想着如何取悦妻子， ");
INSERT INTO cmnfeb_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","这会让他的忠诚分心。同样，未婚妇女或少女要关注主最看重之事，好让身体和心灵都变得圣洁。但结婚的妇女就要为世上的事烦恼，想着如何取悦丈夫。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","我说这些都是为了你们好，我并非想要对你们指手画脚，而是告诉你们如何行事才恰如其分，以便你可以一心一意地对主忠诚。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","如果一个男人认为和订婚的女友做出越轨之事，如果他认为自己会被强烈的性欲望所控制，如果他认为自己应该结婚，这样的结婚并非罪过。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","但如果他心意坚决，没有一定结婚的义务，可以控制自己的感受，在女友面前始终守身如玉，他不结婚也是对的。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","所以，与女朋友结婚是对的，不结婚则更好。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","丈夫活着的时候，妻子需要受丈夫的约束。丈夫若死了，她就可以自由嫁人，嫁给信主之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","但我认为，她不改嫁就会更有福报。我想这话也是来自上帝之灵的传达。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","再来说说“祭奉神像的食物。”我们对这个主题“都有自己的见解。”但我们的看法会让我们傲慢，唯有爱心才能让我们强大。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","如果有人自以为知道些什么。那么，有些该知道的事情，他还并不知道。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","但爱上帝，上帝就会知道你。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","关于吃祭奉神像的食物，我们知道世上的神像不算什么，因为只有一个真正的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","但这世上有很多东西都被成为神，可能来自天空或大地，就好像有很多的神和主。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","然而我们只有一位上帝，那就是我们的天父。万物都因他而来，他就是我们活着的目标。我们只有一个主，那就是耶稣基督。万物都是因他而存在，我们也因他而存在。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","但并非所有人都有这种“知识”。有些人已经习惯了拜神像，所以当他们食用祭奉神像的食物时，他们软弱的良心就被污染了。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","其实食物无法让我们获得上帝的许可，不吃不会带来坏处，吃也不会带来好处。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","只是小心不要利用你的自由去吃祭祀偶像的食物和得罪态度较弱的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","如果有人看见你这“有知识”之人在神像的庙堂里吃喝，如果他的内心软弱，就会被说服，同样去吃那祭奉神像的食物。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","基督为之赴死的信徒，如果内心脆弱，就会因这“更好的知识”而被摧毁。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","你们这样就是对其他信徒犯下罪过，伤害他们软弱良心，就是对基督犯下罪行。 ");
INSERT INTO cmnfeb_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","所以，如果因吃祭奉神像的食物而对其他信徒犯下罪过，我宁愿永远不再吃肉，免得冒犯其他信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","我不自由吗？我不是使徒吗？我没有见过主耶稣吗？你们不是与主同在的结果吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","对别人来说我或许不是使徒，但对你们来说，我至少是使徒的一份子，你们就是我作为主使徒的证据。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","如果有人质疑我这一点，我会这样回答。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","难道我们没有权力吃喝吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","难道我们没有权利像其他使徒、主的兄弟和彼得一样，与基督徒的妻子相伴吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","难道只有我和巴拿巴必须靠工作养活自己吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","哪个士兵必须支付其薪水？哪个葡萄园主不允许吃自己园子里的葡萄？哪个牧羊人不允许喝自己羊群的羊奶呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","我这样说难道是人类的观点吗？律法不也是这样说？ ");
INSERT INTO cmnfeb_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","摩西的律法这样写道：“牛在踩踏去谷壳的时候，不可套住它的嘴。”难道上帝说的只是牛吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","他难道不是在指引我们吗？当然这就是说给我们听的，因为耕种之人应心存希望去耕种，收割之人应心存希望去分享收获。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","我们在你们中间播撒灵性的种子，如果我们想要从中收获一些物质好处，这算过分吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","如果别人对你们享有这种权利，我们不是更有权享有吗？尽管如此，我们从未使用过这种权利。相反，我们凡事忍耐，避免妨碍基督福音的传播。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","难道你们不知道吗？在圣殿供职之人会吃殿中的供物。侍候祭坛之人会领取他们应得的那份祭物。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","主也曾这样祝福传递福音之人，应该靠福音的支持者为生。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","但我从未使用过这种权利。我这样说并非希望别人应该如此待我，因为不去寻求这样的好处是我的荣耀，我宁愿舍弃性命也不愿丢了这荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","传播福音并没有任何可以夸耀支出，因为我无法不去这么做。如果不传播福音，对我将是一场灾难。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","如果我自己选择这样做，就会获得赏赐。即使不是我本意选择，这职责就是对我的托付。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","那么，我的赏赐是什么？那就是当我传播福音时，让大家免费获得福音，而不是要求享有传递福音应有的权力。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","我虽然自由，不服务于任何人，但我自愿成为众人的奴仆，只为让更多人听到福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","面对犹太人，我就像犹太人一样行事，以便可以说服犹太人。面对律法制约之人，虽然律法并不会管辖我，但我还是像受律法制约的人一样行事，以便说服他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","如果一个人没有根据律法行事，我就像不受律法制约之人一样（这样做并非不遵守上帝律法，而是遵守基督的律法），从而说服未受律法制约之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","对软弱的人，我就像他们一样软弱，以便说服软弱之人。最终我面对的人如何，我就成为怎样的人，想方设法说服一些人！ ");
INSERT INTO cmnfeb_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","我所作的一切都是为了福音，为了与他人同享福音的福报。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","难道你们不知道吗？赛跑比赛中有很多选手，虽然大家都跑，但却只有一人能获奖吗？你们应当尽全力奔跑，以便可以获奖。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","参加比赛的选手，需要严格遵循训练方法。他们这样做，不过是为了赢得最终会坏掉的冠冕，我们要的却是不朽的冠冕。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","所以我要向正确的方向奔跑，我要准确地击打，而不是击打空气。 ");
INSERT INTO cmnfeb_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","我严格对待自己的身体，让它听我的控制，因为我不想在与所有人分享福音后，自己却没有了传递福音的资格。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","兄弟姐妹们，让我来向你们解释这一点。我们的先祖都曾居于云下，都曾穿海而过。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","他们都曾在云中和海里由摩西受洗，这是一种象征性的仪式。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","他们享用着同样的灵性食粮， ");
INSERT INTO cmnfeb_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","都曾饮用同样的灵性之水，因为他们“饮用来自磐石之水。”这磐石与他们同在，这磐石就是基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","但他们中大多数人都无法获得上帝的喜悦，因此最终死于荒野。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","我们应该引以为戒，不要像他们那样贪恋恶行。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","你们也不可像他们中的某些人那样膜拜神像。正如经文所说：“民众大吃大喝，沉迷异教膜拜。” ");
INSERT INTO cmnfeb_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","我们不要像他们中的某些人那样行淫乱之事，这导致一天就有二万三千人死去。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","我们不要像他们中的某些人那样试探主，结果亡命于蛇口。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","我们不要像他们中的某些人那样埋怨上帝，最终亡于毁灭天使手中。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","所有发生在他们身上的事情都要作为我们的警示，要将其记下来，惊醒我们这些生于末世之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","所以如果你认为自己站得稳，要小心，免得跌倒！ ");
INSERT INTO cmnfeb_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","你们经历的试探不会超过任何其他人。上帝值得信赖，他不会允许超出你们承受能力的试探。在受试探的时候，他必定给你们打开一条出路，让你们可以保持强壮。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","所以我的朋友们，要远离神像膜拜。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","我与明白事理之人讲述，你们来决定我所说的是否是真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","我们感谢主在最后晚餐中所使用的酒杯，难道不是分享基督的血吗？当我们掰开饼分享的时候，难道不是共享基督的身体吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","通过共享一块饼，显示出尽管我们人数虽多，但我们分享一个身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","看看以色列人，那些吃下祭物的人，不就是一起在祭坛处分享吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","那么我要表达什么意思？我是说为神像牺牲会有意义？还是神像本体真实存在？当然不是！ ");
INSERT INTO cmnfeb_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","异教徒向魔鬼献祭，而非上帝，但我不想与魔鬼有任何关系。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","你们不能喝主的酒杯，又喝魔鬼的酒杯。你们不能参加主的宴席，又参加魔鬼的宴席。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","难道我们想要激起主的嫉妒吗？我们比他更强大吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","有人说：“我有做事的自由”，但不是每一件事都恰当！“我有做事的自由”，但不是每一件事都有益处。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","你不应只为自己着想，而是要为邻里着想。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","市场中卖什么就吃什么，不要为了良心的缘故问什么， ");
INSERT INTO cmnfeb_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","因为“大地和大地上的一切都属于上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","如果一个不信基督的人请你吃饭，你也应该愿意去，摆在你面前的，都可以享用，不要因为良心而问什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","但是如果有人告诉你们：“这是曾献祭的食物。”那么，为了告诫你的这个人着想，也为了良心的缘故，就不要吃。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","这里所说的，是他的良心。为什么我的自由要由别人的良心决定呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","我若以感恩之心吃下这食物，为什么要因我所感恩的食物而被其他人批判？ ");
INSERT INTO cmnfeb_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","所以，无论你吃喝什么，无论你做什么，一切都要以上帝的荣耀而行。 ");
INSERT INTO cmnfeb_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","无论是犹太人、希腊人或上帝的教会，不要让他们感到冒犯， ");
INSERT INTO cmnfeb_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","就像我努力让大家都获得喜悦。不是想什么对自己有好处，而是应该对别人有好处，以便他们可以获得拯救。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","你们应该效法我，一如我效法基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","我感谢你们时刻记得我，感谢你们始终遵循我向你们宣讲的教义。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","但是我希望你们理解，基督是男人的“头”，男人是女人的“头”，上帝是基督的“头。” ");
INSERT INTO cmnfeb_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","男人的首领在祈祷或讲道时如果蒙着头，就是羞辱自己的头。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","女人祷告或讲道时，如果不蒙着头，就是羞辱自己的头，因为这就好比剃发一般。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","女人如果没有蒙着头，就应当剪去头发。如果女人以为剪发或剃头很羞耻，就应当蒙着头。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","男人不应蒙头，因为他是上帝的形象和荣耀，女人是男人的荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","因为男人并非来自女人，但女人却来自男人， ");
INSERT INTO cmnfeb_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","男人并非为女人而创造，女人却是为了男人而创造。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","因此，为了尊重守护天使，女人应当在头上显示权权威记号。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","尽管如此，从主的角度来看，女人和男人一样重要，男人也和女人一样重要。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","正如女人来自男人，男人也来自女人。但更重要的是，万物皆来自上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","你们可以自己判断一下，女人不蒙住头向上帝祷告是否合适？ ");
INSERT INTO cmnfeb_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","男人留长发并非自然行为，是一种羞耻。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","但女人留长发却可以给她带来荣耀吗？因为头发就像她的盖头。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","如果有人想要争论这个问题，他们应该意识到，这是教会遵循的唯一习惯。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","我现在做的是指引你们，而非称赞你们，因为当你们聚集在一起，带来的坏处远多于好处。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","首先，我听说你们在聚会的时候起了纷争，我相信这情况属实。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","你们当然会出现分党结派之事，这样可以真正显示出，那些真诚之人可以真正证明他们自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","当你们聚集在一起，你们其实并不是在庆祝主的最后晚餐。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","有人想要先于其他人进餐，让其他人仍然感到饥饿，还有人会喝醉。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","难道你们没有自己的家供你们吃喝吗？还是说，你们藐视上帝的教会，羞辱穷人？我该怎么和你们说呢？夸奖你们做得好吗？你们这样做，我不可能予以称赞。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","我向你们讲述的这一切，都来自主：在主耶稣被出卖的那一夜，他拿起饼， ");
INSERT INTO cmnfeb_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","在感谢后便掰开饼，说：“这饼就是我的身体，将赐予你们，你们要这样做来记住我。” ");
INSERT INTO cmnfeb_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","当晚他拿起酒杯，说：“这杯是以我的血订立的新盟约，当你们饮酒的时候要记住我。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","每当你们吃这饼，喝这杯中酒，就是在讲述主的死，直到他回归。” ");
INSERT INTO cmnfeb_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","因此，任何人如果以不光彩的方式吃主的饼，喝主的杯中酒，就是错对主的身体和主的血，应该感到罪恶感。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","每个人在吃饼和饮这杯中酒时，都应该内省。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","因为吃喝之人如果没有意识到与主身体之间的关系，就会面临审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","也是因为这个原因，你们中间有许多人软弱、患病、甚至死去。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","但我们若认真内省，就不会像这样受到审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","但当我们接受审判时，就是在接受他的管教，以免和世人一起被定罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","所以我的兄弟姐妹们，你们聚集在一起吃下主的最后晚餐，要彼此等待。 ");
INSERT INTO cmnfeb_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","如果有人饥饿，应当在家里先吃，免得聚在一起时受到审判。我会在造访你们的时候，给予你们更多的指导。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","现在来说说“圣灵的恩赐”。我的兄弟姐妹们，让我来解释这个问题。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","你们知道，当你们还是异教徒的时候，你们总是受到欺骗，去膜拜那不能说话的神像。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","让我明确这一点：任何以上帝之灵说话的人，都不会说“诅咒耶稣。”但只有拥有圣灵，才能说出“耶稣是主。” ");
INSERT INTO cmnfeb_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","恩赐有许多种，但都来自同一个圣灵； ");
INSERT INTO cmnfeb_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","侍奉职责有很多种类，但都来自同一位主； ");
INSERT INTO cmnfeb_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","工作的方式也有许多种，但都来自同一位上帝，是他完成了所有这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","圣灵被赐予每一个人，为了所有人的益处而显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","圣灵赐予某些人说出智慧之语的能力。同样还是这圣灵，赐予其他人知识。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","这圣灵还让一些人对上帝产生了强烈的信仰，让有的人获得了治愈的恩赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","他让有些人可以行神迹，有的人可以预言，有的人可以辨别不同的灵，有人能说各地方言，还有人获得了翻译语言的能力。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","这一切都源自同一位圣灵，他按照自己的意思向每个人进行馈赠。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","正如人类的身体是一个整体，却包含很多器官。身体器官虽然很多，但却组合成一个身体，基督也是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","无论是犹太人或希腊人、奴隶或自由人，都在同一位圣灵那里受洗，最终成为一个身体。我们都被赐予同一个圣灵为饮。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","身体器官不止一个，而是有很多。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","如果脚说：“我不是手，所以我不属于这身体。”难道它真的就不属于这身体？ ");
INSERT INTO cmnfeb_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","假如耳朵说：“我不是眼睛，所以我不属于身体。”难道它真的就不属于这身体？ ");
INSERT INTO cmnfeb_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","如果整个身体只是一只眼睛，又怎能听到？假如整个身体只是一个耳朵，又怎能闻到味道？ ");
INSERT INTO cmnfeb_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","但上帝对这躯体中的每一个器官，都有自己的安排，根据他的心意放置它们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","假如这些器官都相同，身体又会怎样呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","尽管器官很多，它们组合在一起就成为身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","眼睛不能对手说：“我不需要你。”头也不能对脚说：“我不需要你们。” ");
INSERT INTO cmnfeb_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","相反，身体中那些看似微不足道的器官，更是不可缺少。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","事实上，那些被我们认为不够美观的器官，把它们遮盖起来，才会带给我们“荣耀。”对于那些不大美观的器官，我们应该更谦逊地对待它们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","那些美观的器官就不需要遮盖了。但上帝就是这样创造身体：为那些不太适合外露展示的器官，赋予了更多荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","这样做可以让身体内部不会发生冲突，那些不同的器官应该平等对待彼此。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","如果身体的一个器官遭受痛苦，所有其他器官也跟着一同受苦。如果善待一个器官，身体其他的器官都会感到快乐！ ");
INSERT INTO cmnfeb_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","你们就是基督的身体，每一个人都是这身体的一部分。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","在教会中，上帝首先为使徒进行安排，第二是先知，第三是教师，然后分别是行神迹者、医病治愈者、乐于助人者、优秀的长官和可说出多种语言的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","并非所有人都是使徒、先知或教师？不是所有人都能行神迹？ ");
INSERT INTO cmnfeb_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","不是所有人都有治愈的恩赐？都有能力说多种语言或翻译语言？ ");
INSERT INTO cmnfeb_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","你们应该追寻那最重要的馈赠。 所以现在我将向您展示一个更好的方法。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","如果我能熟练讲述这世间甚至是天使的语言，但没有爱，我的语言也不过就像发出回响的锣，或者发出碰撞声的钹。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","如果我可以说出预言，知晓所有奥秘和所有的知识，拥有可以移动山峦的信心，但没有爱，我就一无是处。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","我若把自己拥有的一切分给穷困之人，或如被焚烧的殉道者舍弃自己的生命，但没有爱，我什么也得不到。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","爱是耐心和善良。爱是不嫉妒、不吹嘘、不傲慢。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","爱是不做错误之举，不会固守自己的方式。爱是不会轻易动怒，对他人的过错不记仇。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","爱不会因罪恶而喜悦，只喜欢真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","爱是不放弃，是坚守信念，是保持信心，是时刻保持耐心。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","爱永生不息。预言终会结束，语言终将沉默，知识最终也会失去它的用途。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","我们对知识和语言的理解非常片面。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","等结束终将来临，这片面的理解也将消失。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","如果是孩子，其说话、思想和反应就要像个孩子。但孩子长大后，就要丢弃一切孩子气的行为。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","此刻我们就像窥视以免镜子模糊的反光，但很快，我们就要彼此相见了。我现在所知仅为一部分，到时候就会知晓一切，好像完全知道我一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","信任、希望和爱将永续存在，但最重要的仍然是爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","把爱作为你最重要的目标！ 但也要尽力获得属灵的恩赐，特别是说出神的信息的能力。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","那些讲述方言之人，他们讲述的对象不是人，而是上帝。因为没有人能听得懂，他们讲述的是圣灵深处的奥秘。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","但为上帝讲道之人却在成就人类，为他们提供鼓舞和安慰。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","说方言知识成就自己，传播上帝之道却是在成就教会。我希望你们都会说方言，但我更希望你们都能讲道。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","因为方言如果不翻译，就无法成就教会。相比之下，讲道之人更重要。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","兄弟姐妹们，如果我到你们那里时只说方言，而不是讲述启示、知识、预言或进行教导，那又能给你们带来什么益处？ ");
INSERT INTO cmnfeb_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","很多没有生命的物品也能发出声音，比如箫或琴。但如果它们无法发出清晰的音调，你又怎知它们弹奏的是什么？ ");
INSERT INTO cmnfeb_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","同理，如果军号无法发出清晰的声音，谁又能做好战斗的准备呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","你们的情况也是如此，如果口中说出无法听懂的语言，其他人又怎能理解你在说什么？你不过是向空气说话而已。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","世间有那么多种语言，任何一种都有它的意义。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","如果我不理解这种语言，就无法理解讲述语言之人，他们也无法理解我。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","你们也是如此。如果你们期待获得圣灵的恩赐，就应当设法拥有更多可以成就教会的恩赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","说方言之人应当祈求，让他的方言能够翻译出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","我若用方言祷告，那么就是我的灵在祷告，对我的理解毫无用处。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","那么我该怎么办呢？我要以灵祷告，也要用心智祷告。我要以灵歌唱，也要以心智歌唱。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","因为如果你只以灵赞美，普通人就无法知晓你在说什么，在你进行感恩祈祷后，也无法说“阿门。” ");
INSERT INTO cmnfeb_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","你可能进行了一次无以伦比的感恩祈祷，但对其他人却毫无帮助！ ");
INSERT INTO cmnfeb_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","感谢上帝，我擅长的方言比你们大家都多。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","但在教会中，我宁愿用大家都理解的五句话去教导人，胜过用方言说出的千言万语。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","兄弟姐妹们，不要像孩子一样思考。对于恶，你应该像婴儿般纯洁，但在思想上要成熟。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","正如律法所记：“主说：我要借助说其他语言之人、借助外族人的嘴对我的子民讲话，但尽管如此，他们仍然不肯听我。” ");
INSERT INTO cmnfeb_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","说方言即是一个信号，并非讲给信徒，而是讲给那些不信之人。但讲述上帝预言之道恰好相反：这个信号讲述的对象并非那些不信之人，而是信主之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","如果整个教会聚在一起，大家都说方言，如果这时又不明就里或不信上帝之人走进来，难道不会觉得你们疯了吗！ ");
INSERT INTO cmnfeb_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","如果大家都讲上帝之道，不相信上帝或不理解这一切的人走进来，就会被众人说服，承认自己的罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","他心里的隐秘会显露出来，他会跪倒敬拜上帝，确认上帝真正在你们之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","兄弟姐妹们，你们应该怎么办呢？当你们聚集在一起，各司其职，比如唱歌、教导、预言、以方言表达和进行翻译，这样就能做好一切，成就和鼓励教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","如果有人想说方言，那么只能有两个人这样做，或最多三人，并且要轮流说，还要有一个人翻译。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","如果没有人翻译，说方言之人就应该在教会中保持沉默，只对自己和上帝说好了。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","同理，也要有两三个人讲述预言，让其他人思考他们所讲的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","但如果聚会中有人获得特别的启示，之前发言之人就应该停下来，让那人讲述。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","你们可以轮流讲述上帝之道，以便大家可以学习，可以获得勉励。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","讲述上帝之道的人，需要控制他们的预言灵感， ");
INSERT INTO cmnfeb_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","因为上帝不会混乱，而是和平且安静。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","妇女在教会中应当保持沉默，不应发言。他们应该如律法所属，顺从这样的场合。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","如果她们希望学习，可以在家中询问自己的丈夫，因为女性不适合在教会中发言。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","为什么？难道上帝之道由你而起？难道只有你才被赐予这道吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","如果你认为自己是先知或拥有圣灵的馈赠，就应该意识到我写给你们的字字句句，都是主的命令。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","如果有人不理会，别人也不必理会他。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","所以我的兄弟姐妹们，要将讲述上帝之道作为你的目标，不要禁止以方言进行的表述。 ");
INSERT INTO cmnfeb_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","要确保一切都恰当而有序地进行。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","提醒一下：我之前向你们宣讲了福音，你们已经接受了，此后便始终坚守。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","如果你们坚守我所传给你们的福音，就会因这福音得救，否则你们所信的一切都是枉然。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","我将之前所获得的福音传递给你们，这是一条至关重要的讯息：如经文所述，耶稣已死，因我们的罪而死。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","他在被埋葬之后，又按照经文所述在第三天复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","他曾向彼得显现，然后又向十二使徒显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","之后他又向五百多名兄弟姐妹显现，这些人中，有的已经死去，但大多数人如今仍然活着。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","他还曾向雅各显现，再后又向所有使徒显现， ");
INSERT INTO cmnfeb_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","直到最后他才向我显现，好像我是一个未在预产期降生的婴儿。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","我原本是所有使徒中最微不足道的那一个，本无资格被称为使徒，因为我曾经迫害上帝的教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","但我能有今天全凭上帝的恩典，他赐予我的恩典也没有付诸东流。相反，我比其他使徒更辛苦地付出，但真正辛苦付出的不是我，而是我所获赐的上帝恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","因此，无论是我或是众使徒，我们都在与你们这些信奉上帝之人，分享这福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","那么，如果这福音宣布基督死而复生，为什么你们中间会有人说没有死而复生这种事？ ");
INSERT INTO cmnfeb_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","如果没有死人复活之事，基督也就没有死而复生。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","如果基督没有复活，我们向你们所传福音便毫无意义，你们的信也是毫无意义， ");
INSERT INTO cmnfeb_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","此外，当我们证明上帝让基督死而复生之时，还会被视为上帝的假证人。但如果上帝未让基督死而复生，那么是否根本就没有复活这种事？ ");
INSERT INTO cmnfeb_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","如果死人无法复活，基督也就无法复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","如果基督没有复活，你们的信仰就是徒然，你们仍是罪人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","那么也意味着因基督而死之人，也将消亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","如果我们心中的希望只为今生而立，我们便是最可怜之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","但基督的确已经死而复生，成为在死亡之人中所收获的初熟果实。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","正如死是借着一个人而来，死人的复活也是借着一个人而来。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","与亚当同在的众人都已死去，同理，与基督同在的众人都会复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","只是每个人都有自己复活的顺序：首先是基督这初熟的果实，然后才是他降临之时追随于他的众人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","之后便到了最后关头，基督毁灭了所有统治者、掌权者和力量，将这世间之国交给天父上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","基督必将为王，但在这之前，基督会将他的所有敌人置于他的脚下。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","最后被毁灭的敌人就是死亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","正如经文所说：“他让万物臣服于他脚下。”（当然了，这里所说的“万物”臣服于他，并不包括上帝，是上帝让万物服从于基督的权力。） ");
INSERT INTO cmnfeb_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","在万物服从于基督的权力之后，人子也要服从于上帝的权力。因为人子对万物的权力源自上帝，以此证明上帝的权力才是至高无上的。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","否则，为死人施洗又是为了什么？如果死人根本不会复活，为什么要为他们施洗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","至于我们，我们又何必时时刻刻身处险境？ ");
INSERT INTO cmnfeb_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","兄弟姐妹们，让我直言不讳地告诉你们，我每天都冒着死亡的风险，但我将其视为一种自豪，为耶稣基督为你们所做的一切而感到自豪。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","之前我曾在以弗所对抗那些人，他们对待我就如同一群野兽。如果从人类的角度来看，那对我又有何益处呢？如果死人不会复活，那么何不“大吃大喝吧，因为明天就要死去。” ");
INSERT INTO cmnfeb_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","不要再被欺骗了，“坏朋友会破坏好品德。” ");
INSERT INTO cmnfeb_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","你们要保持理智，不要犯罪！你们中有的人不认识上帝，我这样说就是为了让你们羞愧。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","当然了，有人会问：“死人又如何复活呢？他们复活后又有着怎样的身体呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","多么无知的问题！你种下的种子不会发芽生长，除非它们死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","但你种下种子的时候，并非为了它最终长成的样子。你种下的只是一粒种子而已，也许是麦子或其他种子。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","但上帝让这种子长成他所选择的形体，每一颗种子都长成不同形体的不同植物。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","用于创造所有生命体的物质也各有不同，人的躯体是一种，走兽、飞鸟和鱼是另外几种，每一种都不相同。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","有的躯体为天空之躯，有的为大地之躯。天空之躯自有一种美，大地之躯则是另一种美。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","太阳闪耀着一种光芒，月亮闪耀另一种光，星星也是各不相同，每一种都有自己光芒的方式。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","死人复活也是同样的道理。种下腐朽之躯，复活后即得永生； ");
INSERT INTO cmnfeb_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","如果种下的是卑微，复活后就会成为荣耀；种下的是软弱，复活后就是力量； ");
INSERT INTO cmnfeb_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","种下的是自然之躯，复活后就是灵性之躯。因为既有自然之躯，也有灵性之躯。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","正如经上如此记载：“亚当作为第一个人类，成为拥有生命的活人。但最后的亚当则变成了赋予人生命的灵。” ");
INSERT INTO cmnfeb_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","但先来到这世界的并非是灵，而是自然之躯，灵随后来到。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","第一个人来自大地的泥土，第二个人来自于天。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","来自于泥土的人类，都有着泥土造就人类的模样。来自于天的人类，都有着天造就的模样。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","我们都有着泥土人类的模样，未来也将拥有天造就的模样。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","但我的兄弟姐妹们，我告诉你们的是，我们现在的躯体无法继承上帝之国，这些必将腐朽的躯体无法继承不朽。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","听着，我要告诉你们一个奥秘：我们中不是所有人都会死去，但我们都会改变。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","在一剎那，在眨眼之间，在号角最后一次吹响之时。当号角吹响，死人就会复活成为不朽，我们将会改变。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","这必将腐朽之躯会实现不朽，这必死生命会获得永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","在拥有了不朽之衣后，这必将腐朽之躯就永远不会消亡。这必死生命在获得永生后，就应验了经文所记：“死亡已被彻底征服和消灭。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","死亡啊！你的胜利到哪里去了？死亡啊！你的毒刺到哪里去了？” ");
INSERT INTO cmnfeb_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","死亡的毒刺就是罪，罪的力量就是律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","感谢上帝，他通过主耶稣基督赐予我们胜利。 ");
INSERT INTO cmnfeb_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","所以我亲爱的兄弟姐妹们：要坚强，不可动摇，要尽你所能服务于主。要知道，你所做的一切，在主那里都不会付诸东流。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","让我们来说说“为信徒捐赠”的事情。我之前怎么嘱咐加拉太的众教会，现在就怎么嘱咐你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","在每星期的第一天，你们所有人都要将自己赚的钱留下一部分。我不希望当我去见你们时，你们还要临时筹措。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","当我抵达那里之后，会为你们选中的人写推荐信，让他们把你们的捐款送到耶路撒冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","如果我也应该去，他们就可以与我同去。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","我此行将路过马其顿，之后就会去拜访你们，这条路刚好经过马其顿。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","我也许会和你们同住一段时间，甚至会在那里过冬。之后你们就可以送我走，我将去往该去的地方。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","这一次我造访你们，打算多停留一段时间。如果主允许，我希望能多点时间和你们在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","我将在以弗所住到五旬节， ");
INSERT INTO cmnfeb_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","因为那里虽然仍有很多人反对我，但也有大量的机会之门向我敞开。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","如果提摩太抵达这里，务必不要让他因为与你们在一起而感到害怕，因为他和我一样都服务于主。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","不要让任何人低看他，要高高兴兴地送他走，让他可以到我这里来，我和这里的兄弟姐妹们都在等他到来。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","至于亚波罗兄弟，我曾再三劝他和其他信徒一起去见你们，但他目前还不是很愿意这么做。待等到机会后，他便会去造访你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","请保持警惕，要立场坚定地相信上帝。要勇敢，要坚强。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","你们所做的一切都出自于爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","知道吗？司提芬一家人是亚该亚第一批改变信仰的信徒之一，将自己奉献于帮助上帝的子民。我的兄弟姐妹们，劝你们 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","要尊重他们的引领，尊重在这份工作中以这种奉献精神提供帮助的所有人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","很高兴司提芬、福徒拿都和亚该古都到这里来了，因为他们能够弥补你们的不足， ");
INSERT INTO cmnfeb_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","他们让我备受鼓舞，你们也应该和我有同感。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","亚西亚的众教会问候你们。亚居拉和百基拉、以及他们家中与主同在的教会，也送去了他们最美好的祝愿。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","这里所有的兄弟姐妹们都送去问候。以最热情的方式问候彼此。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","撰写这封信的我、也就是保罗，也在此送去问候。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","不爱主之人应从教会中驱逐。主啊，请降临吧！ ");
INSERT INTO cmnfeb_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","愿主耶稣基督的恩典与你们同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","我以基督耶稣之名爱你们所有人。阿门。");
INSERT INTO cmnfeb_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","本函来自奉上帝旨意成为基督耶稣信徒的保罗，以及我们的教友提摩太兄弟。它将送给哥林多的上帝教会，以及和亚该亚地区的所有上帝子民。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","愿你们获得来自天父和主耶稣基督的恩典与平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","赞颂上帝、主耶稣基督的天父。他是充满怜悯的天父，是赐予所有抚慰的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","上帝在我们经历的所有苦难中抚慰我们，让我们可以用他所赐的抚慰，抚慰其他置身苦难之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","我们越多承受基督所受的痛苦，就会获得更多基督的抚慰。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","如果我们身处不幸，那是为了能获得抚慰和拯救。如果我们获得抚慰，你也会获得抚慰，让你能够耐心地熬过我们所受的痛苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","我们对你们充满信心，因为我们知道，你们承担了我们受的痛苦，但也必会获得我们的抚慰。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","兄弟姐妹们，我们要向你们讲述我们在亚西亚遭受的苦难。那苦难如此强烈，我们甚至担心没有足够的力量继续下去，甚至不知道能否活着结束这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","事实上，那就像我们内在已被判处了死刑。但也正因为如此，我们不再仅倚靠自己的力量，而是去相信可以让人死而复生的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","他将我们从可怕的死亡中拯救出来，他还会再次这样做。我们完全相信上帝会继续拯救我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","请为我们祈祷，这也是对我们的支持。通过这种方式让众人为我们感谢上帝，上帝将会根据众人的祈祷，赐予我们恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","我们始终以恰当的方式对待其他人，尤其是你们。我们的良心也证明了这一点，对此我们深感自豪。我们以圣洁和真诚遵循上帝的原则，不是依靠世俗的聪明，而是凭借上帝的恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","我们不会以复杂的语言撰写任何文字，因为我们希望你们能够读懂和理解。我希望你们最终能够理解， ");
INSERT INTO cmnfeb_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","即使你们现在并未全部理解，当主降临的时候，你们也会以我们为荣，就像我们也会以你们为荣。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","我非常确信你们对我的信念，所以计划首先造访你们，让你们可以再次获得恩惠。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","随后我将去马其顿，再从马其顿返回你们那里，你们将送我去犹太。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","我为什么要改变最初的计划？你们是否认为我总是轻易做决定？是否认为我如凡俗之人一般，在计划一切时总是似是而非？ ");
INSERT INTO cmnfeb_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","上帝是值得信赖的，我们向你们所传之道绝不是似是而非， ");
INSERT INTO cmnfeb_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","因为我、西拉和提摩太向你们宣扬耶稣基督、上帝之子的真理，不可能似是而非。以基督为名，所有的一切都是绝对的“是。” ");
INSERT INTO cmnfeb_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","对于上帝的所有承诺，基督的回答始终都为“是。”通过耶稣，我们也向上帝的荣耀说“是。” ");
INSERT INTO cmnfeb_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","上帝赐予你我所有人内在的力量，坚定地与基督同在。他已经指认了我们， ");
INSERT INTO cmnfeb_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","在我们身上盖下批准的印章，这也是圣灵可以说服我们的保证。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","我呼求上帝给我作证，我之所以没有到哥林多，就是为了避免为你们带来苦痛。 ");
INSERT INTO cmnfeb_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","我们不希望命令你们与上帝的信仰，而是希望帮助你们获得欢喜的体验，因为你们对上帝的信仰让你们更坚定。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","正因为如此，我决定还是不要造访你们，再一次为你们带来忧愁。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","如果我让你们忧愁，谁还能让我快乐呢？, 不会是那些我让他们忧愁之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","所以我撰写了这封信，免得那些本会让我快乐之人，带给我忧愁。我深信，你们所有人都会分享我的欢乐。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","在撰写这封信的时候，我曾多次留下泪水，内心充满苦痛和沉重。这并不是为了让你们悲伤，而是让你们知道我对你们的爱有多深。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","我并不想言过其实，但那个人带给你们所有人的痛苦，远远超过我。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","因你们中的绝大多数人，那个人遭受了足够的惩罚， ");
INSERT INTO cmnfeb_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","所以现在你们应该饶恕他，友善对待他，免得他陷入绝望。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","所以，希望你们要公开地向他表明你们的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","我正是出于这个原因才写了那封信，就是为了解你们的真实性格，是否会凡事顺从。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","你们宽恕谁，我就宽恕谁。无论我宽恕了什么，都已在基督面前为了你们而宽恕。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","这样做才能避免让撒旦有机可乘，我们太了解他的诡计了。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","当年我为传播基督福音到了特罗亚，主便为我开启一扇机会之门。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","但那时候的我因为找不到兄弟提多，心里无法感到安宁。于是我辞别众人去往马其顿。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","但赞美上帝，他总是在基督里带领我们进行胜利的游行。无论我们身在何处，都能通过我们传播上帝知识的芬芳气息。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","我们就像基督先给上帝的气息，从获得拯救以及正在消亡的人群中散发出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","对于死亡之人而言，这气息就是腐烂的气息，对于获得拯救的人而言，这气息就是生命的芬芳！ ");
INSERT INTO cmnfeb_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","我们不像大多数人那样，用上帝之道谋取利益。相反，我们真心诚意分享上帝之道，知晓上帝正在观察我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","我们这时开始自吹自擂了吗？或者我们像有些人那样，需要为你们提供推荐信，或者希望你们为我们写推荐信？ ");
INSERT INTO cmnfeb_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","你们就是我们的推荐信，以你们的经历写就，供所有人诵读和知晓。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","你们也彰显了自己就是来自基督的信函，通过我们传递给众人。这封信函并非用墨写就，而是用永续上帝之灵写成。它并非写在石板上，而是写在人类生命的经历之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","通过基督，我们在上帝面前才有这样的信心。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","我们并不认为凭借自己的力量这样做，是上帝给了我们这样的能力！ ");
INSERT INTO cmnfeb_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","他赋予我们为新约侍奉的责任，这新约并非来自律法文字，而是来自灵。律法的文字会杀戮，但灵赋予生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","以往人们会在石头上刻字，表达与上帝之间的关系。这种方式尽管表达了上帝的荣耀，但人仍不免一死，这荣耀也在慢慢暗淡。因此，以色列人甚至无法去正视摩西面庞散发的闪亮的光芒。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","那么，以经文的方式表达上帝的新方法，是否会有更大的荣耀？ ");
INSERT INTO cmnfeb_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","如果那定罪的古老方式仍然散发荣光，上帝成就我们良善正直的新方法就更有荣光！ ");
INSERT INTO cmnfeb_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","相比新方法无以伦比的荣光，曾经荣耀的旧方法就显得彻底黯淡无光。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","如果正在暗淡的旧方法尚有荣光，作为其后续的新方法就拥有更多的荣光。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","既然我们心怀自信的希望，我们就真正拥有了胆量。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","我们不必像摩西那样，在脸上蒙上面纱，避免色列人因他脸上的荣光而目眩。事实上，这荣光已经开始暗淡。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","尽管如此，他们的态度一直顽固不明、铁石心肠。因为即使是现在，当他们诵读旧约的时候，这“面纱”仍然存在，只有通过基督可以将其揭开。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","即使是现在，他们在诵读摩西之书的时候，心中仍然蒙着这样的面纱。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","但当他们转向并接受主，这层面纱就会去掉了。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","主就是灵，主的灵在哪里，哪里就有自由。 ");
INSERT INTO cmnfeb_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","我们所有人脸上的面纱都已经揭下，仿佛一面镜子体现了主的荣光。我们已经转化成与灵相同的镜像，他的荣光越来越闪亮，这都要感谢主之灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","那么，上帝凭借其悲悯给予我们新方法，与他建立联系，我们就不能放弃。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","但我们已经放弃了秘密的、可耻的行为。我们绝不欺骗，绝不曲解上帝之道。我们在上帝面前彰显真理，让每个人都可以凭借自己的良心做决定。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","尽管我们传播的福音蒙着面纱，但这只是在将死之人的眼中才是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","那些不信上帝的人，是因为俗世的神明蒙蔽了他们的心灵。基督就是上帝的形象，但他们无法看到基督荣耀的福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","我们并不是宣扬自己，而是在传播耶稣基督就是主，事实上，我们因耶稣的缘故成了你们的仆人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","因为上帝说“要有光从黑暗里照出来”，这光已经照在我们的心里，点亮耶稣基督脸庞的荣光，那是上帝知识的荣光。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","我们将这珍宝放在瓦罐中，显明这超强力量源自上帝而非我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","我们虽然遭受各方面的攻击，却没有破碎。我们也会对前路感到迷茫，却从不绝望。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","我们受到迫害，却上帝并未丢弃我们。我们被打倒了，却没有死亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","我们以肉体之躯体现耶稣之死，所以也能让这肉体之躯体现耶稣之生。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","当我们存活于世，因为耶稣的缘故常常遭受死亡的威胁，只有这样，我们必死之躯才能体现耶稣的生。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","通过这种方式，我们面临死亡，才能让你们拥有生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","我们拥有相同的信仰之灵，正如经文中所记：“我相信上帝，所以我说出来。”我们也信仰上帝，所以为他说出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","因为知道上帝让主耶稣死而复生，也必定让我们与耶稣一同复活，将我们和你们一起呈献在他的面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","这一切都是为了你们，让上帝的恩典惠及更多人，让对上帝的感恩更加强大，让荣耀归给上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","所以，我们不会放弃。尽管我们的肉体身躯逐渐朽坏，内在的自我却每日展露新颜。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","我们经历的苦难微不足道，只会短暂持续，只是为了让我们成就不断增强的荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","对于可见的一切，我们并不担心自身。因为我们期待的是不可见的一切。我们看到的都是短暂的，看不见的才是永远。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","我们知道，当我们所居住的人间“帐篷”被拆毁，我们就会获得上帝为我们准备的居所，并非人类建造，而是天上永存的居所。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","我们叹息着、如此迫切地渴望能够拥有那天上的住处，就像换上新衣服。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","当我们穿上这新衣服，就不会再赤身裸体。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","我们身处这“帐篷”中哀叹，被今生的苦压垮。与其说我们希望脱去今生之衣，倒不如说我们更期待将要穿上的新衣，这样就可以在这必死之躯中注入生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","上帝为我们准备了这一切，带来灵保证我们达成这目标。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","我们始终保持信心，但知晓一点：当我们安然生活在这肉体之躯中，就远离了主。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","(因为我们是靠信靠上帝而活，而不是靠看见他而活）。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","正如我所说，我们充满信心地期盼着远离这身躯，与主同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","因此我们立定志向，无论是否住在自己的身体中，都要让主欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","因为最终我们所有人都要现身基督的审判之座面前，然后根据每个人此生所做的一切，或善或恶，接受应得的结果。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","我们知道我们尊重主，以此劝勉众人。上帝非常了解我们是谁，我盼望你们的内心也能清楚地知晓自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","我们并不是再次向你们夸赞自己，只是给予你们让我们骄傲的机会，让你们可以应对那些只看外在、不关注内心之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","如果我们“疯狂”，那也是为了上帝。如果我们清醒，那是为了你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","基督的爱督促我们前进，因为我们确定他为众人而死，所以众人现在已经死去。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","基督为众人而死，就是为了让他们不再为自己而生，而是要为已经死去、并且死而复活的主而生。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","从今以后，我们不再从人的角度看待人。虽然我们曾经以人的角度看待基督，但现在已经不再如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","所以任何人如果与基督同在，就是一个全新的生命，旧人已去，新人已来！ ");
INSERT INTO cmnfeb_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","上帝通过基督改变了我们，让我们不再与他为敌，而是成为朋友。上帝给了我们同样的使命，将他的敌人转变成他的朋友。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","通过基督，上帝让这个世界不再与他为敌，而是成为朋友，不再追究他们的罪过，并且告诉了我们化敌为友的道理。 ");
INSERT INTO cmnfeb_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","因此，我们就是基督的使者，上帝通过我们劝告世人：“请求你们，难道不希望回归、与上帝为友吗？” ");
INSERT INTO cmnfeb_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","耶稣从未犯下任何罪过，上帝让无罪的他经历罪的后果，让我们可以获得善良正义的性格，因为上帝就是善良正义。 ");
INSERT INTO cmnfeb_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","我们是与上帝同在的工人，也劝你们不要毫无意义地接受上帝的恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","正如上帝所说：“我在恰当的时间听到了你们的声音，我将在救赎日拯救你们。”相信我，现在就是那最佳时机！现在就是救赎之日！ ");
INSERT INTO cmnfeb_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","我们从未阻碍并绊倒任何人，确保我们所做的一切不会受到谴责。 ");
INSERT INTO cmnfeb_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","相反，我们竭尽所能表明自己是上帝的好仆人。我们凭借持久的忍耐，忍受所有的苦难、艰辛和不幸。 ");
INSERT INTO cmnfeb_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","我们曾被殴打、监禁、攻击和围殴。我们曾拼命工作、夜不能眠、忍受饥饿。 ");
INSERT INTO cmnfeb_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","我们凭借对上帝的认知，以无可指责的方式生活着，保持耐心和善良，心中注满圣灵，显示诚挚的爱，以此展示我们是谁。 ");
INSERT INTO cmnfeb_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","我们只说真话，与上帝的力量同在。我们的武器就是真实和良善正直，我们用右手发动攻击，用左手保护自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","无论荣耀和羞辱、无论被诅咒还是赞美，我们都继续前行。人们将我们视为骗子，但我们讲述的都是真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","尽管我们的名字众人皆知，但却被众人所忽视。我们等待着死亡，但仍然活着；我们被鞭打，却没有被杀死； ");
INSERT INTO cmnfeb_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","我们看似忧愁，却始终欢喜；看似贫穷，却让很多人富有；看似一无所有，却拥有一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","哥林多人，我的朋友啊！我一直都直言不讳，用宽广的胸怀爱你们！ ");
INSERT INTO cmnfeb_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","我们从不吝惜对你们的爱，但你们却拒绝爱我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","请以同样的方式回应我们的爱，就像你们是我的孩子，要心胸宽广！ ");
INSERT INTO cmnfeb_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","不要与你们不信任的人同流合污，善良和卑劣怎能有相通之处？光明和黑暗又有何共同点？ ");
INSERT INTO cmnfeb_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","基督和撒旦怎能达成共识？信的和不信之人如何分享心得？ ");
INSERT INTO cmnfeb_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","上帝的圣殿与神像怎能协调？我们就是永生上帝的殿，正如上帝说：“我将住在他们中间，在他们中间来往。我将成为他们的上帝，他们将成为我的子民。” ");
INSERT INTO cmnfeb_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","所以，主说：“离开他们，把你们与他们区别开。不可触摸不洁净之物，我将接纳你们。” ");
INSERT INTO cmnfeb_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","全能的主说：“我要成为你们的父亲，你们要做我的儿女。” ");
INSERT INTO cmnfeb_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","亲爱的朋友们，由于我们做出了这样的承诺，就应该洁净自己，除去身体和心灵上的一切污秽，通过敬畏上帝达成圣洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","请接纳我们作为你们的朋友！我们未做过任何措施，没有让任何人堕落，也没有利用过谁。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","我这样说不是为了定你们的罪，正如我之前所说，你们对我们如此重要，我们与你们可以同生共死。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","我愿为你们振臂高呼，因为你们让我感到如此光荣。你们就是对我最大的激励，尽管我们经历各种患难，你们让我格外欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","我们抵达马其顿的时候，没有感到片刻的安宁。相反，我们受到了来自各方的攻击，外有争战，内有恐惧。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","尽管如此，上帝总能给沮丧之人带来鼓励。提多的到来就是我们最大的安慰。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","我们的安慰不仅因为他的到来，还因为你们给予他的鼓励。他告诉我们，你们渴望见到我，还因为我而感到难过和忧愁，这让我更加欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","尽管我写的那封信让你们忧伤，但我并不后悔——其实我曾经感到后悔，因为那封信伤害了你们，但只是很短的一段时间。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","现在我很快乐，不是因为伤害你们，而是因为这种痛苦让你们改变了心意。你们按照上帝的旨意感到难过，所以不会因为我们而受到任何伤害。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","上帝希望我们感受到的忧伤，让我们可以改变心意，获得救赎。这种忧伤不会留下遗憾，但世俗的忧伤却会招致死亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","当你们依照上帝的旨意感受到了这种忧伤，看看你们都发生了什么。还记得你们变得多么热情，渴望为自己辩护，对已经发生的事情感到愤怒，认真对待这一切，渴望做正确的事情，关注自己是谁，渴望实现正义。你们通过所有这些改变，表明你们多么诚心地渴望恢复良善正直。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","因此，以往我写信给你们，并未讨论谁做错事或被错误对待，而是表达了你们如何在上帝的面前为我们做出奉献。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","这让我们备受鼓舞。我们除了感受到鼓舞之外，还很高兴看到提多的欢喜，因为你们让他心安。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","我向他夸赞你们，你们没有让我失望。我对你们所说的都是真话，同样，我向提多夸赞你们也是出自真心。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","提多还记起你们如何按照他所说的行事，如何以尊重的方式迎接他。这让他更加关爱你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","很高兴我可以对你们怀有充分的信心。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","兄弟姐妹们，现在我想让你们知道上帝赐予马其顿教会的恩典， ");
INSERT INTO cmnfeb_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","尽管他们遭受了可怕的痛苦，他们心中仍然满溢着欢喜。尽管他们如此贫困，内心仍然充满了慷慨。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","我可以作证，他们已力所能及地给予，甚至超出了他们的能力！ ");
INSERT INTO cmnfeb_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","他们再三恳求我们，能够有此殊荣承担上帝之子的侍奉责任，这是他们自己的选择。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","他们不仅达成了我们对他们的希望，还按照上帝的旨意将自己献给主，然后献给我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","由于提多率先开始与你们一起工作，所以我们鼓励他回到你们那里，完成你们这光荣的侍奉职责。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","你们的一切都很丰饶，包括对上帝的信、口才、灵性知识、彻底的奉献要尊重他们的引领，尊重在这份工作中以这种奉献精神提供帮助的所有人。和对我们的爱。那么，在履行这光荣的侍奉职责时，也要展示你们的丰饶。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","我并不是在命令你们这样做，而是通过与其他人进行比较，证明你们的爱有多么诚挚。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","你们知道主耶稣基督的恩典。尽管他非常富足，却为你们选择贫穷，然后通过他的贫穷，让你们变得富足。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","我向你们提供一个建议：完成你们已经开始的工作，将对你们有益。在去年，你们不仅率先慷慨给予，也是率先产生这种想法。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","现在就去完成你们计划做的事情，像你们计划的那样热情地完成，在力所能及的范围内给予。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","只要有意愿，只需要力所能及地给予即可，而不是给出自己没有的东西。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","这样做不是为了让其他人更轻松，让你们更受累，而是要大家都均等。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","现在你们很富裕，完全可以满足他们的需要。反过来，当他们变得富裕，就可以满足你们的需要，这样就可以公平对待所有人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","正如经文所记：“拥有太多之人没有剩余，拥有太少之人并不缺乏。” ");
INSERT INTO cmnfeb_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","感谢上帝，他给了提多与我一样的对你的奉献。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","尽管提多愿意按照我们说的做，他去见你们却是他自己的想法，他已经决定这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","我们还派了一位兄弟和他同去，此人在传播福音方面的工作，获得了众教会的称赞。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","不但如此，众教会更指派他作我们的旅伴，将我们所拥有的慷慨馈赠出去。这样做是为了主的荣耀，也是为了展示我们渴望帮助其他人的热切心愿。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","有人批评我们使用这赠礼的方式，对此我想进行辩护。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","我们关注的是以正义方式正确行事，不仅在主的面前，还是要在所有人的面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","我们还派了另一位兄弟与他们同去，他经受住了我们的多次考验，值得信赖，也非常希望提供帮助。现在他对你们更有信心，因此也更热切地希望提供帮助。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","如果有人说起提多，我会说他是我的同伴。他为了你们而与我合作。其他的两位兄弟则是教会的代表，是基督的荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","所以，请在众教会面前欢迎他们，向他们证明你们的爱，证明你们的确值得我们骄傲。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","关于为圣徒提供帮助之事，我本不想提及。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","我知道你们热切地希望提供帮助。我曾向马其顿人称赞你们，说：“亚该亚人去年已经预备好了。”他们中很多人都受到你们热心的激励。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","我派了那几位兄弟造访，就是为了证明你们的确值得我的称赞，让你们可以按照我所说的准备妥当。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","这是为了防止如果马其顿人和我一同去你们那里，你们却没有准备好。如果这项任务失败了，我们会感到非常难堪，更不用说你们了！ ");
INSERT INTO cmnfeb_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","所以我才决定让几位兄弟提前造访你们，让你们提前筹足之前所答应的捐款。这样你们的帮助就是真正的馈赠，而非勉强而为之。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","我还想提醒你们这一点：种得少就收获少，种得多就收获的多。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","每个人都要按照自己已经决定的方式捐赠，不要为难，不必勉强，因为诚心捐赠之人才会获得上帝的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","上帝恩典你们一切，让你们始终富足，所以也就有足够的能力帮助别人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","正如经文所说：“他慷慨救济穷人，他的慷慨之情永不消逝。” ");
INSERT INTO cmnfeb_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","上帝为撒种者提供种子，为人类提供食物。他必将为你们加倍提供种子，让你们的慷慨之情收获更多。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","你们将万事富足，这样就可以始终慷慨给予，你们的慷慨将让其他人感谢上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","当你用这种方式提供服务，不仅满足了上帝使徒的需求，也让许多人感谢上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","你们的慷慨彰显了你们的真实天性，这份慷慨惠及的众人，将因你们的顺从感谢上帝。因为这体现了你们对基督福音的承诺，彰显出你们为他们和其他人的慷慨之心。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","他们会用无尽的爱为你们祈祷，因为上帝通过你们传递他的厚恩。 ");
INSERT INTO cmnfeb_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","感谢上帝的恩赐，这远非言语所能形容。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","我是保罗，当我与你们在一起时，我是“羞涩”的，但离开你们后，我又是“大胆”的。在此，我亲自以基督的善良和温柔恳请你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","恳请你们，让我下一次与你们相处之时，无需再强迫自己变得强硬，当有人认为我们以凡俗方式行事时，我也无需再壮着胆子予以回应。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","我们虽然生活在这个世界，但并未按照俗世的方式战斗。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","我们作战所用的兵器不是属于这个世界，而是上帝的强大力量，足以摧毁人类思想的堡垒，消灭误导人类的谬误。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","为了阻挡上帝的知识，人类用傲慢铸就巍峨高墙，但上帝的力量仍然会将其推倒。他会制止所有背叛想法，将其转化为对基督的服从认同。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","我们已经准备好，当你们完全顺服，就会去惩罚所有不顺从之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","看看是什么在盯着你的脸！如果有人认为自己属于基督，就要再想一想：他属于基督，同样我们也属于基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","尽管我可能略微夸大了我们的权力，但也不会感到难堪。主赐给我们这样的权力，就是为了成就你们，而非破坏你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","我写信的目的并不是为了惊吓你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","有人说：“他的信严厉又强硬，但他本人却其貌不扬，不善言辞。” ");
INSERT INTO cmnfeb_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","说这话的人应该知道，我们未与你们在一起时，会通过文字表达。我们与你们在一起时，就会采取行动。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","有的人只考虑自己，我们不会与之妄加比较。他们用自己衡量自己，用自己比较自己，这真的很愚蠢。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","但我们不会用无法衡量的夸张方式自我吹嘘，而是使用上帝赐给我们的量度，衡量我们的所作所为。这量度也适用于你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","我们这样说，并不是将自己的权力过度延伸到你们那里，好像我们从未到过你们那里去。事实上，我们早已将基督的福音传到你们那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","我们并未以无法衡量的夸张方式自吹自擂，将别人的功劳冠在自己的头上。相反，我们希望随着你们对上帝信仰的不断增加，为你们所做的工作也能大幅扩展。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","这样我们就能在你们以外的地点传递福音。对于其他人所完成的工作，我们不会拿来夸耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","“如果你想夸耀，就夸耀主。” ");
INSERT INTO cmnfeb_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","因为受尊敬的并非自我赞美之人，而是主所赞美的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","希望你们容忍我这一点点的蠢笨，其实你们一直都很容忍我。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","我把你们献给基督，就像把贞洁童女许配给一个丈夫。所以我对你们感到忧心忡忡，但这是一种神圣的嫉妒之情。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","我担心你们的思想受到引诱，不再真诚纯粹地承诺于主，就像蛇用诡计欺骗了夏娃。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","我担心如果有人来告诉你，除了我所讲述的耶稣以外，还有另一位耶稣，你们轻而易举地相信他们，接受另一个不同的灵，而非你们已经接受的那一个，或者听取另一个福音，并非你们相信的那一个。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","我认为自己并不比那些“超级使徒”低等。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","虽然我不善于辞令，但却了解自己在说什么，我们已经通过各种方式向你们清楚显明这一点。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","我保持谦卑，让你们提升，把上帝福音免费传给你们，这样做有罪吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","为了帮助你们，我接受了其他教会的酬劳，也可以说是剥削了其他教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","我在你们那里时，也曾遇到需要帮助的时候，但我没有连累任何人，因为从马其顿前来的信徒们，已经满足了我的需求。我坚决不成为你们的负担，我从未如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","我确认这一点，就像确认我心灵中的基督真理：在亚该亚一带没有人能阻止我这样夸赞！ ");
INSERT INTO cmnfeb_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","为什么？是我不爱你们吗？上帝知道是这样的。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","我曾做过的事情，未来还要继续做，防止有人借此机会吹嘘，声称他们的工作和我们一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","这样的人就是假使徒，是不诚实的工人，伪装成基督的使徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","但不必对之感到惊讶，因为撒旦也伪装成光明天使， ");
INSERT INTO cmnfeb_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","所以，如果撒旦的仆役装成良善的仆役，不必惊讶，但他们最终的解决办法还是会由其行为所决定。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","让我重复一下：请不要以为我很愚蠢，但如果你这么想，也要接纳我这愚蠢之人，让我可以稍微夸夸口。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","我所说的一切并非主会说的，不过是一些愚蠢的吹嘘。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","有许多人按着世俗的标准夸口，让我也来夸夸口。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","（你们如此聪慧，竟然乐意容忍愚蠢之人。） ");
INSERT INTO cmnfeb_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","有人奴役你们，拿走你们的一切、榨干你们、在你们面前趾高气扬、打你的脸，你也愚蠢地容忍他们！ ");
INSERT INTO cmnfeb_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","很遗憾我们太软弱了，无法像他们一样对待你们。但其他人夸口的所有事情，我们也敢开口。(在这里我又像个傻瓜一样说话了。) ");
INSERT INTO cmnfeb_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","他们是希伯来人？我也是。他们是以色列人？我也是。他们是亚伯拉罕的后裔？我也是。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","他们是基督的仆人？说句狂话，我更是。我受更多的劳苦，坐过更多的牢狱，受了过量的鞭打，常常有生命的危险。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","我被犹太人打过五次，每次四十下减去一下， ");
INSERT INTO cmnfeb_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","被棍打过三次，被石头打过一次，三次遇着船坏掉，在深海里漂了一昼一夜， ");
INSERT INTO cmnfeb_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","多次行远路，遇着江河的危险、强盗的危险、同族的危险、外族的危险、城中的危险、荒野的危险、海上的危险、假兄弟的危险， ");
INSERT INTO cmnfeb_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","劳碌辛苦，多次不得睡觉，又饥又渴，多次缺粮，赤身挨冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","除了这些外面的事，还有为各教会挂心的事，天天压在我的身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","有人软弱，我难道不软弱？有人陷在罪里，我难道不焦急？ ");
INSERT INTO cmnfeb_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","如果必须夸口，我就夸自己的弱点。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","主耶稣的父上帝是应当永远受称颂的，他知道我没有说谎。 ");
INSERT INTO cmnfeb_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","在大马士革，亚里达王手下的总督把守着大马士革城，要拘捕我， ");
INSERT INTO cmnfeb_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","我就被人放在一个大篮子里，从城墙的窗户缒下来，逃脱了他的控制。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","夸口固然无益，却也是必要的。现在我要说说主的异象和启示。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","我认识一个在基督里的人，他十四年前被提升到第三重天上去。（是带着身体被提的呢？我不知道，是离开了身体呢？我也不知道，只有上帝知道。） ");
INSERT INTO cmnfeb_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","我认识这个人，（是带着身体被提升，还是脱离身体提升，我都不知道，只有上帝知道。） ");
INSERT INTO cmnfeb_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","他被提升到乐园里去，听见了难以言喻的话，那是人不可以说的。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","为了这个人，我要夸口，但为了我自己，除了我的软弱以外，我没有可夸的。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","即使我想夸口，也不算愚妄，因为我要说的是真话。但我闭口不提，免得有人把我看得太高，超过他在我身上的所见所闻。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","又因为我所得的启示太大，恐怕会高抬自己，所以就有一根刺加在我的身上，让撒旦的差役来攻击我，免得我高抬自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","为了这事，我曾经三次求主，让这根刺离开我。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","他却对我说：“我的恩典够你用，因为我的能力在人的软弱面前会显得完整。”所以，我更喜欢夸自己的软弱，好让基督的能力临到我的身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","因此，我因为基督的缘故，就以软弱、凌辱、艰难、迫害、困苦为欢喜，因为我什么时候软弱，就在什么时候刚强。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","我成了愚妄的人，是你们逼的。其实你们应该称赞我，因为我虽然算不得什么，却没有一点比不上那些“超级使徒”。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","我在你们中间，以各种忍耐，用神迹、奇事和大能，作为使徒的凭据。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","除了我自己没有成为你们的重担以外，你们还有什么比不上别的教会呢？这一点委屈，请原谅我吧！ ");
INSERT INTO cmnfeb_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","好了，我打算第三次到你们那里去，这一次也不会成为你们的重担，因为我所要的不是你们的东西，而是你们自己。儿女不需要为父母积财，父母却应该为儿女积财。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","至于我，我甘心乐意为你们的灵魂付上一切，鞠躬尽瘁。难道我越爱你们，就越得不到你们的爱吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","好吧，即便如此，我也不是你的负担！也许我是个狡猾的人，会用诡计来陷害你！ ");
INSERT INTO cmnfeb_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","我派到你们那里去的人，我借着谁占过你们的便宜？ ");
INSERT INTO cmnfeb_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","我劝提多到你们那里去，又派了那位兄弟一同去。提多占过你们的便宜吗？我们行事，不是同一个心灵吗？不是同样的步伐吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","你们一直以为我们是在向你们申辩吗？我们与基督同在，在上帝面前说话。亲爱的你们，一切事都是为了成就你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","我怕我来的时候，看到你们不如我的预期，你们见我也不如你们的预期。我怕有纷争、嫉妒、恼怒、自私、毁谤、谗言、狂傲、混乱的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","怕我再来的时候，我的上帝让我在你们面前感到羞愧。并且我要为许多从前犯罪的人哀痛，因为他们行了污秽、奸淫、邪荡的事，却不肯悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","这是我第三次到你们那里去，“各样事情必须凭两三个证人的口，才能确定。” ");
INSERT INTO cmnfeb_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","尽管我不在那里，但还是要再次警告他们，还有你们所有人——当我造访时，会毫不犹豫地对他们采取行动， ");
INSERT INTO cmnfeb_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","因为你们在找基督借着我说话的凭据。基督对你们并非软弱，相反，他对你们是有能力的。 ");
INSERT INTO cmnfeb_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","他因软弱被钉死了，却靠着上帝的大能活着。我们在他里面也是软弱的，但靠着上帝向你们所显的大能，也必与他一同活着。 ");
INSERT INTO cmnfeb_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","你们应当察验自己是不是坚守信仰，也应当考验自己。难道不晓得基督耶稣就是与你们同在吗？（除非你们经不起考验。） ");
INSERT INTO cmnfeb_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","我盼望你们知晓，我们并非经不起考验的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","我们祈求上帝，让你们不要做什么恶事。这并不是要显示我们经得起考验，而是要你们行善。至于我们，就让我们做经不起考验的人好了！ ");
INSERT INTO cmnfeb_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","我们不能做什么违背真理的事，只能维护真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","当我们软弱、你们刚强的时候，我们就欢喜。我们所求的，就是要你们完整。 ");
INSERT INTO cmnfeb_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","因此，我趁着不在你们那里的时候，把这些话写给你们，这样当我去了你们那里，就不必凭着主所给我的权力严厉地对待你们。这权力不是为了拆毁你们，而是要建立你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","最后，兄弟姐妹们，你们要欢喜，要圆满，要获得安慰，要同心，要和睦。这样，恩典赐予平安的上帝必与你们同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","你们要用圣洁的亲吻彼此问安。 ");
INSERT INTO cmnfeb_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","众圣徒问候你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","愿主耶稣基督的恩惠，上帝的慈爱，圣灵的交流，常与你们众人同在。");
INSERT INTO cmnfeb_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","本信函来自保罗，我的使徒身份并非由人类组织或人类权力所指认，恰恰相反，我是由耶稣基督和让耶稣复活的天父上帝所指认。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","这封写给加拉太众教会的信函，由与我同在的所有兄弟姐妹共同写就。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","愿上帝天父以及主耶稣基督的恩惠和平安与你们同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","基督遵循我们天父上帝的旨意，因我们的罪而献出自己的生命，让我们脱离现在这个邪恶的时代。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","愿荣耀归给他，直到永远。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","让我震惊的是，你们借由耶稣恩惠的召唤信了上帝，却又如此快速将其放弃，转向其他福音， ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","而那根本不是福音，只是其他人用于迷惑你们，想要曲解基督的福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","但无论是谁，即使是我们自己或天堂的天使，如果所传“福音”并非我们之前传给你们的福音，就该受到谴责。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","我们想再重复这一点：如果有人所传并非我们之前传给你们的福音，就该受到谴责。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","你们认为我需要谁的认可？来自人或是来自上帝？你认为我试图取悦人？如果我想要取悦人，就不是基督的仆人。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","朋友们，让我明确地告诉你们，我所传的福音并非来自任何人类。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","因为我并非从人那里获得这福音，也并非由人教导，而是通过耶稣基督的启示获取。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","你们都听过，我过去曾是犹太宗教的追随者，听说过我如何疯狂迫害上帝的教会，残忍地想要破坏它。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","我在犹太宗教中的经历超过了许多同代人，因为我对祖先的传统格外热情。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","但当上帝在我出生时就让我与他人有所区别，他通过其恩典呼唤我，并很高兴地 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","将他的儿子向我显现，让我向所有国家宣扬福音，我便没有与任何人商量。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","我没有到耶路撒冷与先于我成为使徒的人谈话，而是去了阿拉伯，然后再回到大马士革。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","三年后我才上耶路撒冷去见彼得，和他住了两个星期。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","我也没有见其他的使徒，除了主的兄弟雅各。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","（在上帝面前，我向你们保证所写之事绝非谎言！） ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","后来我去了叙利亚和基利家。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","尽管如此，犹太教会中的众人并未见过我的面。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","他们只听人说“那个从前迫害我们的人，现在开始传播他曾经想要破坏的信仰！” ");
INSERT INTO cmnfeb_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","他们因我而颂赞上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","十四年之后，我与巴拿巴一起返回耶路撒冷，还带上提多与我同行。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","我去那里是顺应上帝的启示。在那里，我私下与有声望的教会领袖见面，解释我向异族人所传的福音。我不希望自己追随并为之奋斗的一切付诸东流。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","但事实证明，尽管与我一起的提多是希腊人，并没有人坚持他应该接受割礼。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","（之所以会出现这个问题，是因为一些假基督徒偷偷溜进来，窥探我们与基督耶稣同在所获得的自由，试图让我们成为奴隶。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","我们绝不屈服于他们，哪怕只是片刻。我们想确保为你们守住这福音的真相。） ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","但我并不想在此谈论那些被视为重要的人物。（我不关心他们是什么样的领袖，因为上帝不会像我们那样判断人。） ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","相反，一旦他们意识到，我被赋予与异族人分享福音的责任，就像彼得被赋予与犹太人分享福音的责任， ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","（这责任都来自于上帝，他通过彼得为使徒向犹太人传递福音，通过我为使徒向异族人传递福音）， ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","当他们意识到，我以及雅各、彼得和约翰都获得了恩典，承担了教会领导的职责，于是就握住我和巴拿巴的右手，表示接纳我们作为他们的一员。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","我们将为异族人工作，他们将为犹太人工作。他们唯一的指示就是记住要去照顾穷人，事实上我已经在努力这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","然而，当彼得来到安提阿时，我不得不直接批评他，因为很显然他的行为是错误的。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","在雅各的一些朋友来之前，彼得经常与异族人一起用餐。但是当这些人到来之后，他就不再这样做了，并且远离了异族人。他害怕那些坚持认为男人必须割礼的人批评他。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","和彼得一样，其他犹太基督徒也开始装假，甚至连巴拿巴也受了影响，跟着他们一起装假。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","我意识到他们并没有坚守福音的真相，于是就在所有人面前对彼得说：“如果你是犹太人，却像异族人而非犹太人那样生活，为什么要强迫异族人像犹太人一样生活？ ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","我们可能生来就是犹太人，而不是像异族人那样的‘罪人’， ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","但我们知道，任何人都不能通过遵守律法而被视为正直善良，只有通过相信耶稣基督才可以。我们已经相信基督耶稣，因此我们可以通过相信基督而非遵循律法成为正直善良之人，没有人通过遵守律法要求做到正直良善。” ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","正因为如此，如果我们希望在基督那里成为正义之人，但却自证为罪人，难道这意味着基督服务于罪？当然不是！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","因为如果我要重建被自己摧毁的东西，这只能证明我在违背律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","通过律法，我因律法而死，这是为了上帝而活。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","我已经与基督一起钉上十字架，所以活着的人不再是我，而是基督活在我的里。我在这个在我中拥有的生命，是因为信那爱我、且为我舍弃自己的上帝之子。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","我怎么能拒绝上帝的恩典？如果我们可以通过遵守律法而成为正直善良之人，那么基督之死就毫无意义！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","加拉太人，你们太愚蠢了！谁迷惑了你们？耶稣基督死于十字架，这样的事实已经清楚呈现给你们，只为让你们可以看到！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","所以告诉我——你们接受灵是通过遵守律法、还是相信你所听到的一切？ ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","你们真的是太愚蠢了！你们已经开始与灵同在。你们真的认为，现在可以通过人类的努力，让自己变得完美吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","你们受了这么多的苦，都是徒劳的吗？（这样做并非没有目的，是不是？） ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","让我问你们个问题：上帝赐给你们灵，在你们中显现那么多神迹，是因为你遵守律法？还是因为你们相信所听到的？ ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","就像“相信上帝，被视为正义”的亚伯拉罕。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","所以你们应该知道，那些相信上帝之人，就是亚伯拉罕的子孙。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","经文中预言到，上帝会让那些信他的异族人成为正直善良之人。已经提前通过这句话向亚伯拉罕展示福音：“所有国家都因你获得祝福。” ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","因此，信任上帝之人与信任上帝的亚伯拉罕一样获得祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","所有依靠遵循律法之人都受到了咒诅，因为正如圣经所说：“凡不认真遵循律法书所言之人，都会受咒诅。” ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","很显然，没有人会因试图遵守律法而被上帝视为正义，因为“那些正义之人将因信任上帝而活。” ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","遵守律法与信上帝没有关系。经文只是说：“遵守律法所要求的一切，你就会活着。” ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","为了拯救我们托利律法的诅咒，基督成为了我们的诅咒。正如经文所说，“凡悬挂在树上的，都会受咒诅”， ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","这样做的目的，是为了通过基督耶稣将亚伯拉罕的祝福传给异族人，我们也可以通过信任上帝而获得圣灵的承诺。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","兄弟姐妹们，这里有个日常的例子。如果一个合约已经起草、同意、签署和盖章，任何人都不能忽视它或在里面补充内容。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","现在承诺已赐给亚伯拉罕和他的儿子。这里的“儿子”并非多人，而是一个人。“你的儿子”就是在说基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","让我解释一下。上帝在订立之前的合约后四百三十年，颁布了律法，但这并未取消上帝的合约，承诺也没有被打破。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","如果这样的继承来自遵守律法，就不会再来自上帝的承诺。但上帝通过承诺，将它恩赐给亚伯拉罕。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","那么，律法的重点是什么？它的存在是为了表明什么是不法行为，直到承诺的儿子到来。律法是天使通过一位中间人传递而来。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","但如果只有一个人参与，就不需要中间人。上帝就是这个人！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","那么律法是否违背了上帝的承诺？当然不是！因为如果有哪个律法可以赋予生命，我们就可以通过遵守它而成为正义。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","但经文告诉我们，我们都是罪的囚徒。我们能接受上帝承诺的唯一方法，就是相信耶稣基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","在我们相信耶稣之前，一直都受到律法的监管，直到这种信任的方式得以显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","在基督来之前，律法是我们的​监护人，让我们可以因信任基督而成为正义。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","但如今我们已经有了信任耶稣的方式，就不再需要这样的监护了。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","因你们相信基督耶稣，你们都是上帝的孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","你们因受洗而归入基督，就如同穿了一件代表基督的服装。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","不再有犹太人或希腊人、奴隶或自由人、男人或女人——你们对于基督耶稣而言都是相同的。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","如果你属于基督，就是亚伯拉罕的孩子，就是承诺的继承人！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","让我解释一下自己所说的。尽管继承人可能拥有一切，但未成年的继承人与奴隶无异。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","继承人在父亲设定的时间前，需要受监护人和管理人的约束。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","我们也一样。当我们还是孩子时，就像受律法基本规则约束的奴隶。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","但在恰当的时间，上帝派他的儿子前来，一个女人根据律法规则将其诞生， ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","以便他可以拯救那些被律法束缚之人，让我们可以作为养子得到应得的遗产。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","为表明你是上帝的孩子，上帝差遣其子之灵来说服我们，让我们呼唤其“阿爸”，即“父亲。” ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","你们现在已经不再是奴隶，而是孩子。如果你是上帝的孩子，上帝就已经让你们成为他的继承人。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","你们还不知道上帝的时候，曾被这个世界上所谓的“神”所奴役。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","但现在你们知道了上帝——或者更好的表达是：上帝知道了你们。那你们怎么又会掉头去信那些无用和毫无价值的规则呢？你们想再次成为那些规则的奴隶吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","你们关注的是特殊的日子和月份、季节和年份。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","我担心为你们所做的一切，都白费了！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","朋友们，我恳求你们：要像我一样，因为我已经变得像你们一样。你们从未以不好的方式对待我。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","还记得我第一次造访、向你们分享福音吗？当时我生病了。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","尽管我的病对你们而言很麻烦，但你们并没有轻视或拒绝我——事实上，你们视我为上帝的天使，就像基督耶稣自己一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","那么你们的感激之情产生了什么结果？我告诉你，那时候如果要你们把眼睛掏出来给我，你们也会的！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","那么发生了什么事——我告诉你们真相，是不是成了你们的敌人？ ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","这些人渴望获得你们的支持，但可不是出于什么好理由。相反，他们想让你们远离我们，这样你们就会热情地支持他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","想做善事当然很好。但应该时刻做善事，而不是只在我与你们在一起的时候！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","我亲爱的朋友们，我想和你们一起工作，直到你们身上也拥有了基督的品格。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","我真心希望自己现在能和你在一起，这样我就可以改变我的语气......我很担心你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","你们这些想要按照律法生活的人，请回答我的这个问题：你们听到律法在说什么吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","正如经文所说，亚伯拉罕有两个儿子，一个是婢女所生，一个是自由之身的妇人所生。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","但婢女的儿子是按照人类的计划出生，自由女性的儿子诞生则是承诺的而生结果。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","这里有一个类比：这两位妇人代表了两个约定。一份约定来自西奈山，婢女夏甲生下了奴隶的孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","夏甲象征着阿拉伯的西奈山，即现在的耶路撒冷，因为她和她的孩子们都是奴隶。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","但天上的耶路撒冷却是自由的。她就是我们的母亲。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","正如经文所说：“如果你们没有孩子、没有生育过，你们应该感到欢喜！如果你们未曾分娩，那么欢呼吧，因为弃妇的孩子比有丈夫的女人还多！” ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","现在我的朋友们，我们就像以撒一样，是承诺生下的孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","然而，按照人的意愿出生的人，会迫害通过灵出生的人，今天也是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","经文怎么说的？“把婢女和她的儿子打发走，因为婢女的儿子不能和自由妇人的儿子一起成为继承人。” ");
INSERT INTO cmnfeb_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","因此，我的朋友们，我们不是婢女的孩子，而是自由女性的孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","基督让我们自由，所以我们可以拥有真正的自由。要站稳脚跟，不要再被奴役的枷锁压垮。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","我保罗在这里直截了当地告诉你：如果你们依靠割礼的方式，基督对你们绝对没有益处。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","让我再说一遍：每个受割礼的人都必须遵守全部律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","如果你们认为自己可以通过律法就能行正义，然后放弃基督——你们已经放弃了恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","因为我们通过灵表示相信，并满怀期待地等待灵让我们变得正直良善。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","因为对基督耶稣而言，受割礼或未受割礼都无济于事，只有通过爱表达的信任才最重要。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","你们过去做得很好！是谁妨碍并阻止你们相信真相？ ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","这种“说服”当然不是来自呼唤你们的那个人。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","你们只需要一点酵母就可以发酵整个面团。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","我相信主，你们不会改变自己的想法，让你们困惑的那个人，无论他是谁，必会面对后果。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","兄弟姐妹们，如果我仍然提倡割礼，为什么还要受压迫呢？如果那是真相，就不会再有如此冒犯众人的十字架问题。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","如果给你们带来麻烦的人能比割礼更进一步，去阉割自己就好了！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","我的兄弟姐妹们，呼唤你们追寻自由！但不要用自由为借口来放纵你们有罪的人性——而是要在爱中互相服务。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","因为有一条诫命概括了整个律法：“要爱人如己。” ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","但是如果你攻击并相互拉扯，注意不要完全摧毁自己！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","我建议你们跟随灵而行。不要满足你有罪的人性欲望。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","因为有罪的人性欲望与灵对立，灵的愿望与有罪人性相对立。他们相互争斗，所以你们不能做自己想做的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","但如果灵引导你，你们就不会承担律法的责任。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","罪人的本性很明显：淫乱、下流、放荡、 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","拜偶像、巫术、仇恨、对抗、嫉妒、愤怒、自私的野心、纷争、异端、 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","嫉妒、醉酒、大吃大喝等等。我之前警告过你们，现在再次警告：任何做出这种行为的人，都无法继承上帝之国。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","但灵会结下善果，比如仁爱、喜乐、和平、忍耐、恩慈、良善、信任、 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","温柔和克制等，而且没有任何律法禁止这些事情！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","那些属于基督耶稣的人，已经将他们有罪的人性以及全部有罪的激情和欲望钉在了十字架上。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","如果我们活在圣灵中，也应该在按圣灵行事。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","我们不要自吹自擂，不要互相激怒和嫉妒。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","我的朋友们，如果有人被罪引入歧途，拥有灵的你们应该以温柔的精神将它们引导回来。小心不要被诱惑。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","承担彼此的重负，这样你们就完成了基督的律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","有人认为自己非常重要——其实他们什么都不是——只是在自欺欺人。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","仔细检查您的行为。然后你就能对自己感到满意，无需和别人比较。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","我们必须对自己负责。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","受过圣经教导之人应该善待他们的老师，与老师分享一切良善。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","不要被愚弄，我们不能蔑视上帝，种瓜得瓜，种豆得豆。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","如果你通过有罪的人性播种，就会那种人性中收获自我毁灭。但如果你根据灵撒种，就会从灵获得永生。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","要永不厌倦、永不放弃地行善，最终会获得收获。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","因此，趁我们还有时间，让我们对所有人行善——尤其是对那些同属信仰大家庭的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","注意这些字母有多大，现在我是用自己的手写成！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","那些只想给人留下好印象的人，它们强迫你们受割礼，这样他们就不会因为基督的十字架而受到迫害。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","即使那些受割礼的人也不会遵守律法，但却希望你们能受割礼，以便他们可以夸赞你们，将你视为他们的追随者。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","希望我除了在我们主耶稣基督的十字架上以外，永不夸口。通过这个十字架，世界对我而言被钉死在十字架上，对世界而言，我已经被钉死在十字架上。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","割礼与否并不重要——重要的是我们已被全新创造！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","愿所有遵守此原则之人以及上帝的以色列人，获得平安和怜悯！ ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","请不要再有人来打扰我了，因为我身上有耶稣的伤疤。 ");
INSERT INTO cmnfeb_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","我的兄弟姐妹们，愿我们主耶稣基督的恩典与你们的灵同在。阿门。");
INSERT INTO cmnfeb_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","这封信来自按照上帝旨意成为基督耶稣使徒的保罗，写给以弗所的基督徒以及相信基督耶稣之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","愿你们获得来自我们父亲上帝以及主耶稣基督的恩惠与平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","赞美上帝，即我们主耶稣基督之父，他通过基督将天堂世界中的灵性善意赐予我们， ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","他在创世前拣选我们与他同在，让我们可以在爱中成为神圣，在他面前没有过错。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","他事先决定收养我们作为他的孩子，通过耶稣基督将我们带到他身边。他很高兴这样做，因为这就是他希望做的。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","因此我们赞美他的荣耀恩典，他通过其爱子如此仁慈地赐给我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","我们通过他的血获得救赎，通过他慷慨提供给我们的无价恩典 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","以及所有的智慧和理解，赦免了我们的罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","他向我们显示了他之前隐藏的意志，他愿意在恰当的时间实行他的计划， ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","以基督聚集所有人，包括天上的人和地上的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","通过他——我们被提前拣选出来。制定这计划之人，是根据上帝的意愿完成一切工作， ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","这样做的目的，是为了让我们这些最先对基督翘首以盼之人，能够赞美他的荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","通过他——你还听到了真理之语，这是你们获得拯救的福音。通过他——因为你信任他，你就被烙上了圣灵承诺的印记， ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","这是我们得到的第一笔继承，上帝在拿走那些为了自己——也为了我们保存完好的一切时, 会将这遗产交给我们，我们会赞美他，颂扬他的荣耀！ ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","我听说过你们对主耶稣的信任，以及你们对所有基督徒的爱，这就是原因。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","我从未停止为你感谢上帝，在我的祈祷中记住你。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","我祈求我主耶稣基督的上帝，荣耀的父，赐给你们智慧的灵，让你们看到并认识他真实的样子。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","愿你的心获得启迪，这样就能明白他召唤你们去拥有的希望——他承诺将这这些荣耀富有，交给他的神圣子民作为遗产。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","愿你们也理解上帝在让基督 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","死而复生所展现的惊人能力。上帝在天上将基督安置在他的右手边， ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","其地位远高于任何统治者、权威或领袖，或任何拥有头衔的领导者——不仅在现世，在来世也是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","上帝让万物服从于基督，授予他作为在教会中掌管一切的责任， ");
INSERT INTO cmnfeb_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","教会就是基督的身体，是基督为带来一切并实现圆满。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","你们因自己的罪和邪恶行为而死， ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","按照这个世界的方式、在魔鬼的控制下生活，魔鬼的灵会控制那些不服从上帝之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","我们所有人都曾经如此，我们的行为被我们罪恶的人性欲望和邪恶思维方式所决定。和其他人一样，我们曾经是天性愤怒的孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","但上帝有着慷慨的怜悯之心，因为对我们有着令人惊异的爱， ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","即使我们因罪而死，他也会让我们与基督一起活着。你因为相信上帝而获得拯救！ ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","他与基督一起让我们复活，因为基督耶稣而让我们与他一同坐于天堂。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","这让他就可以在通过基督耶稣，在永恒的未来向我们展示他令人惊讶的深厚恩典和善意。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","因信任上帝，你已蒙恩得救——这并非靠你自己，而是上帝的恩赐！ ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","这与人的努力无关，所以不要为自己感到骄傲。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","我们是上帝所为的造物，以基督耶稣为名创造我们是为了行善，上帝已经计划好我们应该这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","从人的角度而言，你们就是“异族人”，对于“已受割礼”之人而言，你们就是 “未受割礼”之人（但这只是一种人类做出的行为而已）。你们需要记住， ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","以往你不知耶稣，与基督没有任何关系，你作为异族人就不会被视为以色列的公民，对于上帝承诺的约定而言，你就是陌生人。你会没有希望，生活在没有上帝的世界上。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","但现在，通过基督耶稣，你们这些曾远离之人，如今被带到基督血的旁边。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","基督就是我们的平安。通过他的身体，他将两者合而为一，打破了曾分隔我们、充满敌意的墙壁， ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","将我们从律法的要求和规定中解放出来。他这样做是为了用自己的身体，从两者之中创造一个新的人，从而实现和平， ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","通过十字架让他们与上帝和好，就好像他们是一体，让我们对彼此不再有敌意。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","他来此的目的，是与那些曾经远离他的人分享和平的福音， ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","因为通过他，我们都可以借由同一个圣灵接近天父。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","这意味着你不再是陌生人和异族人；你们都是上帝子民的同胞，属于上帝的大家庭， ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","这个大家庭以基督耶稣为奠基石，以使徒和先知为地基。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","整座建筑因他而连为一体，逐渐成长为主的圣殿。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","你们也是因他而被建造出来，成为上帝通过圣灵存在之地。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","我——保罗，为了你们这些异族人而成为耶稣基督的囚犯，这里将讲述我如何 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","（我想你们可能听说过，上帝已经赋予我责任，要我与你们分享上帝的恩典）， ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","通过上帝向我显示的一切，将以往隐藏的奥秘清楚展露。之前我曾简短地写过这件事， ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","当你阅读本函，就能够了解我对基督奥秘的洞察。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","过去的世代没有人清楚这一点，但现在灵已经向上帝的圣使徒和先知做了启示， ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","证明异族人是共同的继承人，属于同一个身体，通过基督耶稣和福音分享上帝的承诺。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","上帝的恩典使我成为福音的传道者，我之所以能这么做，是上帝能力所赐予我的。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","在所有基督徒中，我是最微不足道的一位。但这恩典赐给了我，只为了与异族人分享基督那不可思议的非凡价值， ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","帮助每个人看到这奥秘的使命。从一开始，创造一切的上帝就隐藏着这奥秘。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","通过教会，上帝要向天堂的统治者和掌权者展示他在所有方面的智慧。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","通过我们的主基督耶稣，上帝也显示了这样的永恒旨意。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","因为他以及我们对他的信任，我们就能完全自由和自信地来到上帝面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","所以我希望你们不要因为我的痛苦而沮丧——这是为了你们，你们应该珍惜它！ ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","这就是为什么我跪在天父面前的原因。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","因为天上地上的每个家庭，其天性和品格都来自天父。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","我跪求从他丰饶的荣耀、通过他的灵，用他的能力强化你们内心深处的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","愿基督于你们同在，因为你们相信他。当你们深植于爱之中， ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","就有能力与所有上帝的子民一起，理解基督之爱的长度、广度、高度和深度。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","愿你们知晓基督超越知识的爱，让你们因上帝的丰饶而圆满完全。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","通过上帝影响我们的力量，愿他给予我们的，远超过我们所求、甚至我们所想的， ");
INSERT INTO cmnfeb_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","愿他在教会中能通过基督耶稣获得世代荣耀，直到永远。阿门 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","所以我——作为主的囚徒——鼓励你们按照蒙受召唤所遵守的原则生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","不要为自己而自豪，要温柔且有耐心，通过爱表达对彼此的宽容。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","通过将你们联系在一起的平安，尽其所能在灵里合而为一。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","因为只有一个身体，一个灵魂，正如你们被一个希望所召唤。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","主是唯一，我们对他的信任是唯一，洗礼也是唯一； ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","只有一个上帝，他是每个人的父亲。他在一切之上，通过一切，在一切之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","我们每个人所获得的恩典，都与基督的慷慨馈赠成正比。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","正如经文所说，“当他登上高处，带走了俘虏，将礼物送给了人类。” ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","（关于这一点：它说他已经上升，但这也意味着他之前曾降临我们这个卑微的世界。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","那降临之人也是升至最高天堂之人，他通过这种方式让整个宇宙变得完整。） ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","他所给予的恩赐，让有的人可以成为使徒、先知、福音传递者、牧师和教师， ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","这样做是为了让上帝的子民准备好帮助他人，帮助基督之躯的成长。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","我们一起成长，直到我们对上帝之子的相信和知识，让我们达成合一的状态，完全成长，通过基督获得真正完全的成熟。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","我们不应该再是小孩子，因教义吹来的每一道微风而摇摆，被人的诡计所迷惑，被狡猾之人引入歧途； ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","相反，要用爱心说实话，应该通过基督实现全面的成长，他就是我们的头。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","整个身体因为他而运作，每个关节都将它连接在一起，因为每个单独的部分都在各行其责，整个身体都在成长，在爱中构建自我。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","所以让我要对你们说——事实上，我通过主里坚持了这一点——你们不应该再像异族人那样过着空虚的生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","他们的思想处于一片黑暗。他们不明白，因为他们什么都不知道，他们固执地不想知道，所以与上帝的生命隔绝。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","因为不在乎，所以放纵肉欲，贪婪地做出各种令人作呕之事。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","但这并不是你们所知的基督！ ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","你们难道没听说过他吗？你们没有人教过你们他的事情吗？你们没有学到耶稣的真理吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","所以，要摆脱你们以往的生活方式，它通过具有欺骗性的欲望毁掉了你们陈旧的天性！ ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","要让自己在灵性和心智重生， ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","拥有上帝创造的新天性，这样你就会像他一样，获得真理的正义和圣洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","所以要拒绝谎言，彼此说真话——因为我们属于彼此。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","不要因生气而犯罪；不要在黑夜来临时仍然感到愤怒—— ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","不要给魔鬼任何机会。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","窃贼要停止偷窃，用双手诚实工作，带来成果，这样你就能拥有可以送给他人的东西，满足他人的需要。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","不要说脏话。根据需要说出鼓励他人的话，帮助那些倾听之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","你们属于圣灵，圣灵已对你们做出标记。在救赎之日到来之前，不要让圣灵感到失望。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","摆脱各种怨恨、暴躁、愤怒、谩骂、侮辱以及各种邪恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","善待彼此，彼此宽恕，就像上帝通过基督宽恕你们一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","所以要模仿上帝的行为，因为你们是他深爱的孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","要生活在爱中，就像基督爱你一样。他为我们将自己献给了上帝，正如芬芳的香水。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","你们应该远离任何不道德的性、下流或贪婪行径，因为上帝的子民不应该做这样的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","下流的谈吐、愚蠢的喋喋不休和粗俗的笑话不适合你们——你们应该感谢上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","你们知道，不道德、下流、贪婪或拜偶像的人，绝不可能会在基督和上帝的国度中获得任何继承。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","不要让任何人用谎言来愚弄你们，因为正是因为这样的事情，上帝才会对悖逆的孩子进行审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","所以在这方面，不要与他们为伍。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","你们曾经身处黑暗，但现在你们在主那里就是光。你们要像光的孩子一样生活 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","（光的果实就是一切美好、正确和真实的东西）， ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","要展示主真正欣赏的东西。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","要与滋生于黑暗、毫无意义的事情撇清关系——要去揭露它们。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","对于那些人私下所做的行径，即使是谈论它们也是一种羞辱。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","当一切都暴露在光之中，一切就显而易见。光显现了一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","这就是为什么有人说：“醒醒吧，你们这些睡着的人，从死亡中复生，基督会照耀你们。” ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","所以要小心你的生活方式，不要愚蠢，要变得明智； ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","要善用机会，因为每一天都充满邪恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","不要无知——要找出主的意愿是什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","不要酗酒，酒会毁了你的生活，要让灵充满你们的身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","要彼此分享，通过《诗篇》、吟唱和圣歌，用歌曲和音乐向主表达你的感受。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","奉我们主耶稣基督之名，感谢上帝天父所带来的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","如果其他人出于对基督的敬畏而让你去做一件事，每个人都应该欣然接受。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","妻子要服从丈夫让你做的事，如同这是来自主的吩咐。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","丈夫是妻子的头，就像基督是教会的头。教会是他的身体，他是教会的拯救者。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","就像教会遵循基督的吩咐，妻子也应该在所有事情上遵循丈夫的吩咐。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","丈夫应该爱自己的妻子，像基督爱教会并为教会舍弃自己的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","他让一切圣洁，他用道之水洁净一切， ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","他让教会成为自己的教会，没有瑕疵、缺陷或任何类型的过错，保持圣洁无瑕。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","丈夫应该这样爱妻子，就像爱自己的身体一样。一个爱妻子的男人也是在爱自己—— ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","因为没有人会恨自己的身体，而是要为身体提供营养并照料它，就像基督对待教会的方式， ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","因为我们是他身体的一部分。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","“这就是为什么男人要离开父母，与妻子结合，两者合而为一。” ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","这是一个深藏不露的真理，不过我所说的是基督和教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","然而，每个丈夫都应该像爱自己一样爱自己的妻子，妻子也应该尊重丈夫。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","孩子，你们要按照父母的吩咐行事，因为这才是正确的方式。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","“要孝敬你的父母。”这是第一条带有承诺的诫命： ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","“这样才可能让你一切顺利，让你可以在人间长寿。” ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","父亲们，不要让你们的孩子变得疯狂，而是要管教他们，教导他们认识上帝，用这种方式照顾他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","仆人，你们应该服从你们的人类主人，要表现处恰当的尊重和敬畏，做事要奔着真诚的动机，就像在侍奉基督一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","不要只在其他人看的时候，为了获得认可而好好工作。要像基督的仆人一样工作，诚实地遵行上帝的旨意， ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","快乐服侍主人，就好像你是在为主而非人做事。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","你们知道行善之人会得到主的奖赏，无论他是仆人还是自由人。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","主人应该以同样的方式对待你的仆人。不要威胁他们，记得天上的主是你的主人，也是他们的主人。他对人一视同仁，没有偏袒。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","最后，要通过主和他的能力保持强大。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","穿上上帝的所有盔甲，这样你们就可以抵挡魔鬼的所有攻击！ ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","我们不是在对抗人类的力量，而是在对抗超自然统治者和权力，它是这个世界的黑暗之主，是对抗天堂的邪恶精神力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","拿起上帝提供的所有武器，这样你就能在邪恶的岁月里站稳脚跟。在付出所有努力后，发现自己仍然屹立不倒！ ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","请站起来，把真理的腰带系在腰间，披上公正和正义的胸甲， ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","穿上准备就绪的鞋子，分享和平的福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","最重要的是，要拿起信任上帝的盾牌，这样你就可以挡住魔鬼发来的火焰之箭。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","戴上救赎的头盔，拿着圣灵的宝剑——灵就是上帝之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","当你这样做的时候，始终要以灵之名祷告。保持清醒，继续为所有上帝的子民祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","也请为我祈祷，让我始终可以讲出正义之语，让我能自信地解释福音中隐藏的真相。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","我就是为了福音而被囚禁的大使，所以请为我祈祷，让我以应该拥有的无畏发声。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","推基古是我们的好朋友和忠诚的传道人，他会将我所有的消息告诉你们并解释这一切，这样你们就会知道我在做什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","这就是我派他道你们那里的原因——他要把我们发生的事情告诉你们并鼓励你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","愿天父上帝和主耶稣基督，祝福你们那边的所有基督徒能够秉承爱和信任，获得平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","愿永远热爱我们主耶稣之人，都能获得恩惠。");
INSERT INTO cmnfeb_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","这封信来自基督耶稣的仆人保罗和提摩太，写给住在腓立比、所有与基督耶稣在一起的上帝子民，同时也写给所有的教会领袖和助手。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","愿我们的父上帝和主耶稣基督赐予你们恩典和平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","当我想起你们，就会感谢我的上帝， ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","总是很高兴地在祈祷中记住你们所有人， ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","因为自始至终，你们都在我一起传播福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","我非常相信，你们会继续努力工作，实现成功的结果，直到耶稣基督再次到来。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","我以这种方式思考你们所有人恰如其分，因为你们对我来说意义重大。无论在监狱里还是在外面宣讲福音，你们都与我一起分享上帝的恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","上帝是我的见证，见证我领受基督耶稣的关怀并对你们每一个人保持的深情。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","我祈祷你们会越来越热爱知识，更加深刻地理解， ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","这样就能弄清楚什么才是真正重要的。当基督再来时，你们就可以做到真诚无瑕， ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","通过耶稣基督让生命之果充满正直良善，将荣耀和赞美归于上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","我的兄弟姐妹们，我想让你们知道，我所经历的一切，都是在推动福音向前发展！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","所有人——包括所有禁卫军——现在都知道我为了基督而被锁链束缚； ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","因为我被锁链束缚，这里的大多数基督徒都获得鼓励, 勇敢无畏地说出上帝的话语！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","是的，有些人说话是出于嫉妒和竞争。但有些人说话却秉承良好的动机。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","他们的行为是出于爱，因为他们知道，我来此是为了给福音辩护。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","那些人因为自私的野心而使用欺骗性的方式介绍基督，试图为处于监禁中的我制造麻烦。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","那又怎样？我关心的就是基督以何种方式出现，无论来自假装还是真实的信念。这就是让我快乐的原因——我会继续快乐！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","为什么？因为我深信，通过你们为我祈祷，通过耶稣基督之灵的帮助，这将成为我的救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","因为我最大的希望和期待，就是不要做任何让我会感到羞耻的事情。相反，我会一如既往地大胆盼望，即使是现在也是如此，无论我是生是死，基督都会通过我实现极大荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","对我而言，活着是为基督而死，死了才会有收获。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","但如果我继续住在这里，这将是一项富有成效的工作，那么我真的不知道什么才是最好的选择！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","因为我处于两难境地——我真的想离开并与基督在一起，这会好得多， ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","就你而言，仍然留在这里更重要。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","既然我已经很确认，知道自己会留在这里，随着你们越来越相信上帝并感到喜乐，我会留在你们身边帮助你们， ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","以便当我再次见到你们时，你们会更因为我的原因，赞美基督耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","只要确保你的生活方式符合基督的福音，无论我是否去看你们，都能听到你们在做什么——我知道你们彼此完全一致，因相信福音而共同努力，精神上就实现了团结一致。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","不要让敌人吓到你们。要勇敢地向他们证明，他们将会迷失，但上帝会亲自来拯救你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","因为你们不仅拥有信耶稣的特权，也会为他受苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","你们正在经历的挣扎，就像你们所见我所经历的挣扎——你们现在也知道，我仍然在挣扎。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","那么，如果你们因基督而受到鼓励，如果你们因他的爱而获得安慰，如果你们分享灵，如果你们有同情心和怜悯心， ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","那么就可以用同样的方式思考，以同样的方式相爱，精神上达成团结，追求一个共同的目标，让我的快乐变得完整。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","不要出于自私或骄傲的原因去做事，要谦虚地为他人着想，而不是为自己着想。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","你们不应该只顾着自己的事情，还要为他人的利益着想。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","你们应该拥有和基督耶稣一样的态度。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","尽管他本来始终都是上帝，但他并不关注自己与上帝是否平等。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","他清空自己，保持仆人的本性，成为人。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","他以人形来到，谦卑自己，将自己交给死亡——甚至死在十字架上。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","这就是为什么上帝将他放在最尊贵、最有权力的地位，给他最尊贵的名字—— ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","以便每个人都为耶稣之名而鞠躬，无论是在天上、地上或地底， ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","所有人都会宣告耶稣基督是主，以此荣耀父上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","所以我的好朋友们，继续以完全敬畏和尊重上帝的方式，朝着救赎的目标努力，按照告诉你的方式去做——不仅当我和你们在一起的时候如此，现在我离开你们更要如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","因为在你们心中是上帝在起作用，他带来意志和能力，让你们去做他想让你们做的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","做每件事都不要抱怨或争论 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","这样你们才会真诚，不会有任何错误。在过着不诚实和腐败生活的民众中，成为上帝无可指责的孩子；在他们中间，像照亮世界的光一样闪耀， ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","向他们传授生命之道。只有这样，当基督再次来到，我会就会有一些值得骄傲的事情，证明我没有白白四处奔波和操劳！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","所以，即使我把自己的生命当作祭品和供品，只要能让你们信任上帝，我就会为此感到高兴。我和你们在一起很高兴， ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","就像你们有这样的欢喜，因为和我在一起而感到高兴。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","我希望，如果这是主耶稣的旨意，请尽快将提摩太派去见你们。只要我知道你们在做什么，我就会感到高兴。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","我不知道有谁像他那样真正关心你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","其他人只关心自己的利益，不关心耶稣基督的利益。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","但是你们已经知道他是谁了——就像一个孩子在帮助他的父亲，他和我一起工作来传播福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","我希望在了解自己的进展情况后，就立刻派他去。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","我相信主，很快我也能去。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","但我认为把以巴弗提送到你们那边很重要。他是我的兄弟、同事和战友。他是你们派来照顾我的人， ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","一直渴望见到你们。他担心你们，因为你们也听说了，他生病了。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","他确实生病了——差点死去——但上帝怜悯他。不仅怜悯他，也怜悯我，这样我就不会不断发生各种悲剧。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","正因如此，我才那么想派他去见你们。你们因为见到他而开心，我就不用那么心焦。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","所以，请心怀主并以极大的幸福欢迎他——让他这样的人感到荣耀， ");
INSERT INTO cmnfeb_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","因为他在为基督工作时几乎失去声明，冒着生命危险来弥补你们无法给我提供的帮助。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","总而言之：我亲爱的朋友们，以主为喜乐！向你重复这些话，对我来说不是负担，这是为了保护你的安全！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","小心那些狗！警惕那些做坏事的人！小心那些切割身体之人！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","因为我们真正行了割礼，我们借着神的灵敬拜, 将我们的信心寄托于耶稣基督。我们对人的能力没有信心—— ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","如果有一种方法可以去依靠人性，我自己就可以获得这样的信心！如果有人认为，他们有信心可以拥有这样的人性，那么我就可以超越他们： ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","我在第八天受了割礼，是便雅悯支派的以色列人，一个真正的希伯来人。在遵守律法方面，我是法利赛人； ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","说到宗教奉献，我曾是教会的破坏者；在依法行事上，我无可指责！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","但无论我以何种方式获得任何好处，我都认为这是基督的损失。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","确实，我把一切都视为损失，它让我通过认识我主基督耶稣获得令人难以置信的益处。我会为了他而丢掉这一切，把它们视为垃圾，我通过这种方式才拥有基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","我希望与他同在，并非因为我做了什么或律法所说的正确，而是通过相信基督而实现正直善良，通过对他的信任而被上帝视为正直善良。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","我想真正了解他，以及他死而复生的能力——体验他的苦难，在他的死亡中变得像他一样， ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","好让我经历最终的复活！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","并不是说​我已经拥有一切，或者我已经很完美——但我奔跑的目的，是为赢得基督耶稣为我获得的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","我的朋友们，我不认为我已经赢得，但这是我的一个目标：不顾身后发生什么，努力向前看。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","我奔向终点线，是为了赢得上帝通过基督耶稣邀请我进入天堂的奖品。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","灵性成熟的人应该这样想，如果你有什么不同的想法，上帝会向你展示这一点， ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","我们只需确保遵循所了解的一切即可。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","我的朋友们，像其他人一样，按照我的榜样行事，注意我们的行为方式，因为你们需要以我们为榜样。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","有些人因其生活方式而与基督的十字架为敌——正如我以前经常告诉你们的那样，在此我再重复一遍，尽管这让我非常痛苦，让我想要放声痛哭。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","他们最终会完全迷失，这些人的“上帝”只是其肉体欲望，本事应该让他们感到羞耻的事情，他们却引以为豪。他们只考虑今世的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","但我们的祖国是天堂，我们也在等待救世主——主耶稣基督，从那里降临。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","他会重新创造我们有缺陷的身体，让我们的身体像他那荣耀的身体一样，可以运用他那样掌控一切的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","我亲爱的朋友们，你们对我很重要，让我如此快乐，所以我们坚定不移地与主同在！对我来说，你们就是我最高的成就！我真的很爱你们，很想见到你们！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","尤迪亚和顺都基——建议你们解决彼此之间的分歧，在主面前达成一致。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","事实上，我忠实的同事们，请你们帮助这些妇女，因为她们都在与我一起传播福音——还有克莱门特和我的其他同事，她们的名字就记录在生活之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","永远因与主同在而感到快乐——再说一遍，要感到快乐！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","每个人都应该知道你们的好意。主很快就会降临。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","不要担心任何事情，要在祈祷中将一切交给上帝，向他解释你的需求，感谢他所做的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","那时候，就会获得超过你想象、上帝带给你的平安，保护你以正确的思想和态度与基督耶稣同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","最后，要去想那些真实的、尊贵的、正确的、纯洁的、美丽的、值得称道的事情，真正好的、值得表扬的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","践行从我这里学到的一切，践行从我这里得到的一切，践行你看到我做的一切，践行听到我说的一切。届时，赐予平安的上帝会与你同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","感谢主，真高兴你们终于想起我了——我知道你们以前曾经很关心我，但对此却无法提供帮助。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","我并非在谈论我自己的需求，因为我已经学会了在任何情况下都要让自己感到满足。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","我习惯了一无所有，也曾拥有很多。在每一种可能的情况下，我都学会了如何面对富足和饥饿。对于富有和贫困的生活，我有一个秘诀： ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","凭借那让我坚强之人，我无所不能！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","即便如此，在我遇到麻烦的时候，很高兴你们能与我分享事。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","腓立比人请记住，在我开始分享福音时，当我离开马其顿时，你们是唯一为我提供经济帮助的教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","我在帖撒罗尼迦的时候，你们也曾帮助过我两次。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","我并非在寻找捐赠，而是为你们的“账户”增加“利润。” ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","因为我所拥有的远超过自己需要的。很感激以巴弗提寄来的东西。它们就像是取悦上帝并获得其认可、散发扑鼻香气的祭品。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","上帝的荣耀财富就在耶稣基督之中，用你们需要的一切来满足你们！ ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","荣耀归于我父上帝，直至永远。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","问候每一位与基督耶稣同在的信徒。与我同在的耶稣基督的兄弟姐妹向你们问好。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","所有的信徒都向你们问好，尤其是凯撒宫里的人们。 ");
INSERT INTO cmnfeb_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","愿主耶稣基督的恩典与你们的灵同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","这封信函来自奉上帝旨意成为基督耶稣使徒的保罗以及提摩太兄弟， ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","写给歌罗西的信徒以及相信基督的所有人。愿你们获得来自上帝我父的恩典与平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","我们始终为你们感谢上帝，我主耶稣基督之父，为你祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","我们已听说你们对基督耶稣的信仰，以及你们对所有信徒的爱， ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","因为在天堂有希望在等着你们。你们已经在福音中听到这个信息， ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","这真理的信息传遍全世界，在广泛的传播中产生了效果。现在，它也传向了你们。自从你们听到它并意识到上帝恩典的本质后，它也对你们产生了同样的效果。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","我们亲爱的朋友和工友的以巴弗，他代表你们成为基督值得信赖的仆人，教授你们这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","他也将你们对灵的爱，明确告诉了我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","因此，我们从听到这些消息的那天起，就不停为你们祷告，祈求上帝让你们理解他对你们的要求，赋予你们一切属灵的智慧和悟性。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","通过这种方式，你们可以正直良善的方式代表主，让主喜悦；结下所有善果，更深刻地了解上帝； ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","希望你们借由他的非凡力量，可以更加强大，凡事宽容忍耐； ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","希望你们幸福地向父祈祷，他让我们可以获得生活于光明之中上帝子民的传承。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","他拯救我们脱离黑暗的统治，让我们迁入其爱子的王国。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","通过他的爱子，我们获得自由，罪得赦免。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","这位爱子是那不可见上帝的可见之形。他早在万物之前即已存在， ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","那天上地上的一切——可见和不可见、国王、统治者和掌权者，无不通过他而创造，为他而创造。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","他存在于万物之先，将万物凝聚在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","他是身体的头，这身体就是教会。他是源起，在死而复生之人中位居首位，因此超越一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","上帝很高兴其爱子拥有他的所有特征， ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","借由其子，将宇宙万物归于他身上，因为他通过在其十字架上所流的血成就了和平；他使地上和天上的每一个人都和好。。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","你们从前也与上帝是陌路人，你们的行为就是与他为敌。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","但现在，上帝通过他死亡的人类身体与你们和解，把你们带到他身边，在那里能够拥有圣洁、纯粹和 无瑕。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","但你们对他的信念，必须如磐石般持久，不动摇。不受动摇对福音希望。这福音你们已经听过，已传遍世界，这也是我保罗所做的工作。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","现在能为你们受苦，我感觉欢喜。因为通过我身体所发生的一切，成为基督受难的一部分。基督是为其身体——也就是教会而持续受难。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","上帝给了我关于你们的指示，我按照这个指示服务于教会，将上帝之语完整呈现给你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","这是很多岁月、很多世代隐藏的奥秘，但现在已经向上帝子民显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","上帝希望他们知道这个光荣奥秘财富对万国的意义：基督住在你里面是荣耀的盼望！ ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","我们向所有人讲述他，用我们知道的最佳方法指导和教导他们，让上帝面前的每个人都因基督而彻底圆满。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","这也是我竭尽全力工作的目的。通过上帝的力量，这力量也对我产生了强大的影响，我依赖这力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","我想让你们知道我是多么的努力工作，为了你们、为了老底嘉的人们，事实上还为那些不曾见过面的人们。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","我的努力是为了让你们能够受到鼓舞，让你们在爱中彼此联系，可以凭借领悟而感到完全的确信，以此获得巨大的益处，因为这才是上帝带来的真正知识。希望你们知道，上帝显现的奥秘，那就是耶稣！ ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","通过耶稣，你们可以发现一切智慧和知识。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","我说这些话，免得有人用花言巧语欺骗你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","我的身体虽然没有和你们在一起，灵却与你们同在。很高兴看见团结在一起，坚定地信基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","一如你们如何接受基督耶稣为主，就按照这种方式追随他， ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","以他为根基，以他进行修建。希望你们对他的信能继续变得更强壮，遵循一直向你们教导的，对上帝充满感激。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","要小心，不要哪些不遵循基督、而是按照人的传统和世俗言论，皆有其哲学和骗人的空谈，奴役你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","因为上帝神圣本性，以基督身体的形式完整存在， ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","你们也因他而完整。他远远高于所有执政掌权者。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","通过他，你们接受了“割礼”，但并非由人手进行，而是通过基督提供的割礼，从人类罪的天性中获得自由。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","你们在洗礼中已与他埋葬在一起，也因信上帝将基督从死人中复活的行为，与耶稣一同复活了。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","尽管你们因罪和肉体未受割礼而死亡，但上帝让你们与基督一起复活，上帝赦免了我们的一切罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","他根据那用于反对我们的律法，抹去了我们的债；他把这障碍钉在十字架上，以此将其移除。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","他废除了 很明显，这不是在谈论身体上的割礼，而是它在精神上的上的意义。统治者和掌权者的权利，将他们的真正的样子公开显示，用胜利彻底征服他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","所以不要让任何人因你们所选择遵循的饮食、宗教节日、新月或特殊安息日，而批评你们 你选择跟随。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","这些不过是即将到来之事的影子，因为那真正的现实就是基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","不要让人通过欺骗夺去你们的奖赏，他们坚持让你们故作谦卑或敬拜天使。他们说自己曾看到过异像，所以就认为自己好于任何人，他们的有罪思想也变得如此自负，令人可笑。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","这样的人并没有与自己的头连接，没有用头指导身体，没有通过身体的关节和筋络获得滋养，连接在一起。因为身体是连接在一起的，按照上帝希望它成长的方式成长。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","你们若与基督一同死去，摆脱世俗强加给你们的宗教要求，为什么好像仍然是这个世界的一部分，仍然要受这些要求的摆布， ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","比如“不可拿、不可尝、不可触”的要求？ ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","这些要求所指，是一经使用就会坏掉的东西。这些规条是照着人的要求和教训而定。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","对于那些以自我为中心敬拜之人、故作谦卑之人和“苦修身体”之人，这些规则似乎合情合理。但事实上，它们在应对所有罪恶欲望方面，没有任何帮助。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","所以，你们既然与基督共同复活，就应当寻求天上之事，在那里，基督坐在上帝的右边。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","要改变你们的想法，关注天上而非地上的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","你们已经死去，你们的生命与基督一起，与上帝同在，保持安全。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","基督就是你们的生命，当他显现，你们也会分享他所显现的荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","所以要清除你们在这世间的天性，比如性罪恶、不道德、淫念、恶欲和贪欲。这些都是在拜神像。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","因为这些事，忤逆之人会体验上帝的审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","你们曾经这样生活，遵循这样的行文， ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","但现在，你们应该摆脱忿怒、恼怒、恶毒、毁谤以及粗言秽语这样的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","不要彼此说谎，因为你们已经摆脱旧我和旧行， ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","换上新我，这新我更像是造物主，能够更好地认识主。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","在这种新情况下，不分希腊人和犹太人、受割礼的和未受割礼、外族人、野蛮人、奴隶或自由人，因为基督就是一切，也存在与我们所有人之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","因为你们是上帝的特殊子民，是圣洁、蒙爱之人，就要拥有怜悯的性情，恩慈、谦卑、温柔和忍耐。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","如果你对其他人有抱怨，要彼此宽容，互相饶恕；主怎样饶恕你们，你们也要怎样饶恕别人。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","最重要的是，要爱彼此，这是将你们团结在一起的最佳纽带。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","愿基督的平安指引你们的思考，因为你们受上帝蒙召成为一体，也要为此要感谢上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","让基督之道充分住在你们心里，遵循所有智慧之道，用诗章、圣诗、灵歌彼此教导，互相劝戒，怀着感恩和虔诚歌颂上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","你们所作的一切，无论是言语或行为，都要以主耶稣之名，借着他感谢父上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","你们做妻子的要尊重丈夫，这对主而言是正确的行为。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","你们作丈夫的要爱妻子，不可错误地对待她们。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","你们作儿女的凡事要听从父母，这会让主感到喜悦。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","你们作父亲的不要激怒儿女，免得他们丧失信心。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","你们作仆人的要凡事听从人类主人，做事不要只是为了让主人看，而是要真诚地尊重主。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","无论你们作什么，都要认真做，就像你在为主做这一切，而非为人。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","因为你们知道，主会给你们回报，让你们继承！你们服务于主耶稣！ ");
INSERT INTO cmnfeb_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","但那些不义的人，就会因其行为而遭受报应。主从不偏袒。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","你们作主人的要公平对待仆人，要知道你们也有一位天上的主人。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","记得始终要祷告，心存警醒和感恩的心祷告！ ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","也要为我们祷告，求上帝为我们打开传道之门，讲述基督所显现的奥秘，我也是因为这个原因，此刻被投入监牢。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","祈祷我能像我说的那样，把事情说明白。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","你们要把握时机，聪明地与外人来往。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","说话时始终要保持礼貌，要大方得体，要思考如何以最佳方式回答所有人。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","关于我所发生的一切，推基古会告诉你们。他是我心爱的兄弟，是值得新来的神职者，是与主同在的工友。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","我派他到你们那里去，就是为了一个理由：让你们知道我们的情况，让你们振作起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","与他同去的是欧尼西慕，这是一位值得信赖的亲爱兄弟，是你们的一份子。他们会把这里的一切告诉你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","与我一起被投入监牢的还有亚里达古, 以及巴拿巴的表弟马可，他们也向你们问候。（正如之前告诉你们的，如果马克拜访你们，请接待他。） ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","此外还有别号为优士都的耶稣，他们都是犹太的基督徒，在这里与我一起为上帝王国工作，对我的帮助很大。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","以巴弗也问候你们，他是你们那里的人，是基督耶稣的仆人。他祷告的时候，总是充满热情地为你们祈祷，希望你们作为成长的基督徒，可以稳稳站立，要对上帝希望我们所做的一切充满信念。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","我可以作证，为了你们以及在老底嘉和希拉波立的人，他做了很多事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","亲爱的路加医生和底马也问候你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","请问候在老底嘉的信徒和宁法，以及在她家家中聚会的教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","你们读完这封信以后，也要交给老底嘉的教会阅读；你们也要读老底嘉的那封信。 ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","告诉亚基布：“要留心你在主那里领受的职务，好好把它完成。” ");
INSERT INTO cmnfeb_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","我是保罗，亲笔写下这封信向你们问候。记得我正在监牢之中。愿恩惠与你们同在。");
INSERT INTO cmnfeb_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","这封信来自保罗、西拉和提摩太，写给帖撒罗尼迦属于父上帝和主耶稣基督里的教会。愿恩典平安与你们同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","我们始终因你们众人而感谢上帝，祷告的时候从未遗忘你们， ");
INSERT INTO cmnfeb_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","在我们的父上帝面前，我们记得如何在工作中，投入了你们对上帝的信，如何以爱辛勤工作、如何心怀希望耐心等待我们的主耶稣基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","兄弟姐妹们，我们已经知道上帝爱你们，你们对他而言很特别。 ");
INSERT INTO cmnfeb_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","我们传递给你们的福音，不只是言语，其中也有力量，因为圣灵彻底说服了你们。通过同样的方式，你们知道了我们是什么样的人，因为我们向你们显示出，我们是为你们而工作。 ");
INSERT INTO cmnfeb_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","当你们接收到这讯息，你们就效法我们，效法主。因为尽管经历苦难，你们仍然体会到圣灵带来的欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","因此，你们已经成为马其顿和希腊所有信徒的榜样！ ");
INSERT INTO cmnfeb_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","你们已经宣讲了上帝的信息，不止在马其顿和希腊，还包括听闻你们信上帝的所有人，所以我们不用再对任何人说什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","事实上，他们说起了你们如何热情地接待我们；如何摒弃神像、归向上帝；如何在侍奉这活着的真正上帝时， ");
INSERT INTO cmnfeb_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","等候其儿子从天降临——这就是耶稣，上帝使他从死人中复活，在即将到来的审判中拯救我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","兄弟姐妹们，你们都知道，我们的造访对你们意味着什么，那并不是浪费时间。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","你们应该记得，虽然我们在腓立比受了那么多苦和凌辱，面对强烈的反对，我们仍然通过上帝的帮助，与你们分享上帝的福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","因为我们所说的并非欺骗，不是污秽或诡诈。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","相反，我们所说的一切都获得了上帝的批准，他把福音委托给我们。我们的目的不是取悦人，而是取悦上帝，他在评判我们的动机。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","你们知道，我们从来不说奉承之语，也从不会故起贪婪自私之心，上帝可以作证。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","我们并非想要赢得其他人的赞美，不是你们，也不是任何人。作为基督的使者，我们本来会成为你们的“负担。” ");
INSERT INTO cmnfeb_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","但我们在你们中，我们却像母亲照顾自己的孩子一样善良行事。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","我们如此爱你们，不但原意把上帝的福音传给你们，甚至连我们自己也乐意给你们，因为我们爱你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","兄弟姐妹们，别忘记我们所有的辛劳，日夜不停地工作，就是为了在与你们分享上帝的福音时，不会成为你们的负担。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","我们以公正、无可指责的圣洁态度对待你们，我们的行为你们可以佐证，上帝也可以作证。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","你们知道我们如何关爱你们所有人，就像父亲对待儿女一样。我们鼓励你们、安慰你们、分享我们的经历， ");
INSERT INTO cmnfeb_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","让你们可以像上帝希望的那样生活，这上帝召唤你们走进他的王国和荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","此外：我们一直在感谢上帝，当你们听到并接受上帝之道，你们没有把它们当做人类之道，而是真正的上帝之道。相信上帝，就会产生这样的效果。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","兄弟姐妹们，你们的经历就像位于犹太地的上帝教会一样，这些教会属于耶稣基督。就像你们的犹太基督徒教友一样，他们遭受犹太领袖的迫害， ");
INSERT INTO cmnfeb_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","那些领袖杀了耶稣和众先知，又把我们赶出来。他们得不到上帝的喜悦，与所有的人作对， ");
INSERT INTO cmnfeb_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","试图阻挠我们向其他国家传道，不让他们得救。他们始终充满最大的恶，但所有的审判必将降临到他们身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","兄弟姐妹们，因为有一段时间没有见到你们，我们感觉好像经历了一次与家人的离别，但这离别只是身体离开，而不是精神。我们非常渴望再次亲自见到你们，这就是我们想要做的。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","我们非常想造访你们，我保罗试过很多次，只是撒旦阻挡了我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","但正是你们给了我们希望，让我们感到幸福，当主耶稣再次降临，当我们站在他面前，我们会因你们而感到骄傲！ ");
INSERT INTO cmnfeb_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","你们就是我们的荣耀和欢喜！ ");
INSERT INTO cmnfeb_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","我们再也忍受不下去了，于是我们决定留在雅典、 ");
INSERT INTO cmnfeb_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","派我们的兄弟提摩太去，这对我们最好了。在传递耶稣福音时，他是我们的兄弟，与上帝一起工作。我们把他派过去，是为了让你们更坚定地相信上帝，给你们勇气， ");
INSERT INTO cmnfeb_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","让你们任何人都不会因困难而沮丧。你们应该知道，这困难是预料之中的。 ");
INSERT INTO cmnfeb_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","即使与你们在一起的时候，我们就一直在警告，我们将会遭受困难。你们也知道，事实的确如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","这就是为什么当我无法在忍受时，就派人去看看你们是否仍然信上帝。我担心魔鬼成功地诱惑了你们，导致我们的努力都白费了！ ");
INSERT INTO cmnfeb_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","造访你们的提摩太刚刚返回，带给你们对上帝的信和你们的爱告诉我们，这是一个好消息。他还告诉我们，你们仍然会想起我们，希望见到我们，就像我们想见你们一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","兄弟姐妹们，当我们在经历苦痛时，得知你们仍然坚持对上帝的信，这消息真正地鼓励了我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","因为你们坚定地与主站在一起，对我们而言就值得继续活下去。 ");
INSERT INTO cmnfeb_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","你们给我们带来了快乐，当我们来到上帝面前，我们怎么能不为此感谢上帝呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","我们热切地日夜祈求，希望能再次与你们见面，帮助你们继续培养对上帝的信。 ");
INSERT INTO cmnfeb_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","愿我们的父上帝和我们的主耶稣，能让我们可以尽快到你们那里去。 ");
INSERT INTO cmnfeb_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","愿主增加你们的爱，让这爱可以溢出并彼此流淌，流淌到每个人那里，就像我们爱你们一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","通过这种方式，愿耶稣让你们坚定。在我们主耶稣和众圣徒到来的时候，你们能站在我们的父上帝面前，完全圣洁，无可指责。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","还有几件事：兄弟姐妹们，我们以主耶稣之名请求你们，就像我们所告诉你们的那样，以让上帝喜悦的方式行事。当然了你们已经这样做，只是要做得更多！ ");
INSERT INTO cmnfeb_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","我们以主耶稣之名传递的指示，你们要记住。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","上帝的旨意是要你们以圣洁方式生活；远离不道德的淫欲， ");
INSERT INTO cmnfeb_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","每个人都能以圣洁尊重的方式控制自己； ");
INSERT INTO cmnfeb_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","不要像那些不认识上帝的异族人一样放纵欲望； ");
INSERT INTO cmnfeb_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","在这些事情上，不要欺骗或利用其他基督徒。因为主在这样的事情上必会施以正义，我们已经清晰地向你们解释并警告过你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","上帝召唤我们，并非是让我们的生命玷污，而是要我们圣洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","所以拒绝这命令的人，并不是拒绝其他人嘞所说的，而是在拒绝将其圣灵赐给你们的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","关于爱其他的信徒，我们无需再写什么，因为上帝已经教你们如何彼此相爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","事实上，你们已经向全马其顿所有的信徒展示了这种爱。尽管如此，我们仍要鼓励各位兄弟姐妹们，要更加彼此相爱； ");
INSERT INTO cmnfeb_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","要试图过着安静的生活，关注自己的事情，亲手做自己的工作，正如我们之前解释过的。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","只有这样，你们的生活方式才可能受到非基督徒的尊重，你们不用以来其他人来提供你们所需。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","兄弟姐妹们，关于人们死去后发生什么，我们不想让你们感到困扰，所以你们不用向其他没有希望的人那样感到悲伤。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","因为我们确信，耶稣死后又复活，我们也确信上帝会通过耶稣，带来那些已死的信他之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","我们现在所讲的一切都来自主：我们这些还活着、仍然留在这里等待主来临的人，肯定不会站在已死之人的前面。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","因为主必亲自从天堂降临，发出号令，伴随天使长的呼叫，还有上帝号角的声音，那些因相信基督而死之人必先复活； ");
INSERT INTO cmnfeb_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","我们这些还活着、还留在这里的人，将与他们一起被提升到云中，在空中与主相会。这样，我们就能永远与主同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","所以，就用这些话互相鼓励吧。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","兄弟姐妹们，关于预言的时间和日期，我们无需用文字累述。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","因为你们很清楚，主的那一天必会到来，但会在一个意外的时间到来，就像夜晚出现盗贼一样让人意外。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","那时候，人们还在谈论和平和安全，忽然就会彻底毁灭，就像婴儿忽然出生，他们不会逃脱。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","但是你们，各位兄弟姐妹们，你们对之并非毫不知情，所以当审判日如贼一样忽然来临时，你们不会感到惊诧。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","因为你们都是光明之子，白昼之子；我们不是属于黑夜或黑暗。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","所以，我们不能像其他人一样沉睡，我们应该保持清醒，头脑清晰。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","因为人会在夜晚睡觉，在夜晚喝醉； ");
INSERT INTO cmnfeb_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","但我们属于白昼，所以应该保持头脑清醒。我们要披上信与爱的胸甲，戴上救赎希望的头盔。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","因为上帝并未决定要惩罚我们，而是通过我们的主耶稣基督，通过救赎拯救我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","基督为我们而死，让我们无论或者还是死去，都能与他一起活着。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","所以要彼此鼓励，赋予力量，正如你们一直在做的。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","兄弟姐妹们，请你们尊重那些与你们一起工作的人，他们引领你们走向主并教导你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","因为他们所做的事情，你们要用爱格外尊重他们。应当彼此和睦地生活在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","兄弟姐妹们，奉劝你们要警戒懒惰之人，要去勉励焦虑之人，帮助软弱之人，耐心对待每个人。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","任何人都不能以恶报恶，而是要始终对彼此、对所有其他人做善事。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","始终要保持欢喜， ");
INSERT INTO cmnfeb_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","不要停止祷告， ");
INSERT INTO cmnfeb_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","凡事都要心存感激，因为这是上帝通过基督耶稣给你们的旨意。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","不要遏制灵， ");
INSERT INTO cmnfeb_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","不要藐视先知之语。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","凡事都要仔细查验，坚守好事， ");
INSERT INTO cmnfeb_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","远离所有恶行。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","愿赐予平安的上帝让你们真正圣洁，愿主耶稣基督再次来临时，你们整个人——包括身体、精神和灵都无可指责。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","那召唤你们的是值得信任的，他必会这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","兄弟姐妹们，请为我们祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","热情地问候那边的所有信徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","我以主为名，请你们向所有信徒阅读这封信。 ");
INSERT INTO cmnfeb_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","愿我们主耶稣基督的恩典与你们同在。");
INSERT INTO cmnfeb_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","这封信函来自保罗、西拉和提摩太，写给帖撒罗尼迦、为我们父上帝和主耶稣基督所有的教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","愿你们获得来自天父和主耶稣基督的恩典与平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","兄弟姐妹们，我们始终都因你们而感谢上帝，我们衷心地感谢你们。因为你们对上帝的信正在快速增加，你们彼此相爱的心也在增加。 ");
INSERT INTO cmnfeb_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","因为你们在经受的所有迫害苦难中，仍然保持着勇气和信心，所以在上帝的众教会中，说到你们会让我们深感骄傲。 ");
INSERT INTO cmnfeb_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","这是上帝做出公正决定的证明，你们配得上他的王国，你们也是为此而受苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","因为上帝所做之事都是良善正直，他也会恰如其分地处理那些导致你们受苦之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","当耶稣基督与他强大的天使们在耀眼火焰中从天国降临，他会解救你们和我们于痛苦, ");
INSERT INTO cmnfeb_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","对那些拒绝上帝、不接受我们主基督福音之人，进行审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","他们要受到惩罚，永远离开上帝，无法见到主和他的光荣力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","当他要从其子民处获得荣耀的那一天，被所有信他之人所尊崇，你们也在其中，因为我们所说的一切，让你们信服。 ");
INSERT INTO cmnfeb_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","所以我们始终为你们祷告，愿我们上帝将你们变成的样子，值得他召唤我们所做的一切。如果你们想要行为正直良善，一举一动皆来自对他的信，愿上帝用强大的力量满足你们达成这个目标的每一个愿望。 ");
INSERT INTO cmnfeb_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","只有这样，我们主耶稣的名，才可能因你们的行为而获得荣耀，你们也会通过上帝和主耶稣基督的恩典，因他而荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","兄弟姐妹们，关于我们主耶稣基督的到来，以及我们如何为了他而聚集在一起， ");
INSERT INTO cmnfeb_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","如果有任何灵的显现或消息、或收到号称来自我们的信函，告诉你们主的日子已经来到，请不要沮丧或担心。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","不要让任何人用任何方法迷惑你们，因为在那之前，必先发生叛乱，无法之徒会露出原型，他的末日就是被摧毁。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","这样的人以上帝为敌，将自己抬高自己，高于被称为上帝和受人敬拜的一切。他甚至坐在上帝的宫殿中，自称为上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","还记得我和你们一起时，曾告诉过你们这一切？ ");
INSERT INTO cmnfeb_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","现在你们也知道，是什么让他一直没有行动，因为要等到他的恰当时刻才会显示出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","因为那无法的秘密已经在产生影响，只是他还在控制着，他也会一直这么做，直到那控制被解除。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","那时候，这无法之徒就会显现。主耶稣将把他除掉，把他吹跑，用其临时的光辉消灭他。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","他（无法之徒）的到来是为了行撒旦之事，拥有各种能力，显示奇迹，进行看似令人惊讶、其实是骗术的行为。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","在那些正在走向毁灭之路的人身上，行各种不义的欺诈之举，因为他们拒绝去爱真理并因此而得救。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","因此，上帝就送给他们一个令人相信的错觉，让他们相信谎言。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","这样的结果是，所有不信真理、喜欢邪恶之人都会被定罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","但主所爱的兄弟姐妹们，我们应该一直感谢上帝，因为上帝从最初就选择了你们，通过其灵拯救你们，让你们变得正直良善，相信正道。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","上帝就是通过我们向你们传的福音，召唤你们，让你们可以获得我们主耶稣基督的荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","所以兄弟姐妹们，要站稳。关于你们学到的，无论是我们口传或写于我们的信函，都要持守。 ");
INSERT INTO cmnfeb_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","愿我们的主耶稣基督以及父上帝(他通过其恩典给予我们永恒的心心和值得信赖的希望）， ");
INSERT INTO cmnfeb_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","可以鼓励你们，让你们变得强大，做出良善言行。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","最后，兄弟姐妹们，请为我们祷告，让主之道可以传开并被人们真正地接受，就像你们所做的那样。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","祈祷我们可以摆脱那些不道德的邪恶之人，因为不是所有人都信上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","但主值得信赖，他将让你们更有力量，保护你们脱离邪恶之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","以主为名，我们深信你们现在和未来，都会继续按照我们所说的做， ");
INSERT INTO cmnfeb_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","愿主引导你们，更深刻地理解上帝对你们的爱以及基督的忍耐。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","兄弟姐妹们，我们以主耶稣基督之名想要告诉你们，如果哪个信徒游手好闲，不按照我们所进行的教导行事，就应当远离他。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","你们当然知道应当以我们为榜样，因为我们与你们在一起时，我们没有游手好闲， ");
INSERT INTO cmnfeb_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","没有不付钱就吃其他人的食物。相反，我们辛苦劳碌，昼夜工作，免得加重你们任何一人的负担。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","这不是因为我们没有权利，而是要给你们作榜样，好让你们照着做。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","我们与你们在一起的时候，曾经给出严格的指示，如果有人不肯工作，就不可吃饭。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","但现在我们听说，你们中有人游手好闲，从不工作，却专管闲事。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","通过主耶稣基督，我们劝告这样的人要安静工作，自食其力。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","兄弟姐妹们，不要放弃行善。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","如果有人不听从我们这封信上的教导，要把那个人记下来，不可与他来往，让他自己觉得惭愧。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","但不要把他看作仇敌，要像劝兄弟姐妹一样劝他。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","愿赐平安的随时赐予你们平安。愿主与你们众人同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","这是我保罗亲手写下的信函，向你们问候。这是我所写信函的标志。 ");
INSERT INTO cmnfeb_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","愿我们主耶稣基督的恩典与你们众人同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","这封信来自保罗，我是耶稣基督以救世主上帝和我们的希望耶稣基督之权威，指定的使徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","本信函写给我们真正的儿子提摩太，因为你们相信上帝。愿你们拥有来自父上帝和我们主基督耶稣的恩惠、怜悯和平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","我在去马其顿的路上，曾劝你留在以弗所，这样就可以嘱咐某些人不要宣讲错误想法。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","也不要关心没有凭据的传说和无穷尽的家谱；这种事情只会引起争论，不会帮助我们理解我们所相信的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","我之所以坚持这一点，是因为这样我们可能会获得来自纯粹心灵的爱，来自干净良心和对上帝真诚的信。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","有些人偏离了这些事情，并最终开始胡说八道 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","他们野心勃勃地想要做律法教师，却不明白自己讲的是什么，大肆宣扬的又是什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","现在我们意识到，律法只要正确使用就是好的。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","我们也知道律法本来不是为良善正直的好人而设，而是为那些无法无天、忽视法律的人而设。它适用于那些不需要上帝、不虔诚、从不圣洁形式、完全不虔诚的人。它适用于那些弑父杀母的人、杀人犯、 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","淫乱的、亲男色的、拐带人口的、说谎的、做假见证的，以及反对正道的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","我们所称颂的上帝委托我宣讲的荣耀福音，决定了这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","我感谢赐我力量、我们的主基督耶稣，因为他认为我有值得信赖，派我服侍他。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","尽管我曾经亵渎上帝，迫害和虐待上帝的子民，但上帝仍然怜悯于我，因为我是在无知和不信的情况下才那样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","我们主的恩典充满我，随着基督耶稣里给我的信心和爱，这恩典满溢出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","你应该相信、所有人都应该接纳一句话。“基督耶稣降临世间，为了拯救罪人。”我就是其中最大的罪人。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","因为这个缘故，我蒙受怜悯, 让基督耶稣在我这最大罪人的身上，显示他无尽的耐心，为后来信他得永生的人作榜样。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","愿万世君王、不朽无形的唯一上帝，永远拥有尊贵荣耀。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","提摩太，我的儿子，这些是我想给你的指示，遵循那些让你走到现在的预言，这样你就能为良善而战斗。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","常保对上帝的信，要有干净的良心。有些人拒绝这样做，他们对上帝的信就彻底破坏了。 ");
INSERT INTO cmnfeb_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","许米乃和亚历山大就是这样的人，我已经“把他们交给撒旦”，让他们学会不要亵渎上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","首先，我想鼓励你为每个人祈祷：请求上帝，代表他们提出要求，表示感谢。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","为君王和所有类型的领袖也这样祷告，让我们可以过上平静祥和的生活，时刻想着上帝，认真对待生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","我们的救主上帝会认为这是好事情，可让他喜悦。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","他希望所有人都得救，真正理解真理是什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","因为只有一个上帝，在上帝和人类之间只有一个中间人，那就是降生为人的基督耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","他舍弃自己，以使我们都能被赢回，在恰当的时间显示证据。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","我受到指派分享这个讯息，成为信使，教授异族人，让他们相信上帝和真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","我真正希望的是所有地方的男人都没有愤怒或争论，能够虔诚地向上帝祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","照样，女人应该端庄、适度、恰如其分地装扮，她们的美不应来自其发型、佩戴的黄金和珍珠珠宝或昂贵的服装， ");
INSERT INTO cmnfeb_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","却要以善行为美，这才是愿意追随上帝的女性恰当的行为。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","女人应该学会保持安静，尊重她们所在的地位。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","我不允许女人成为引导者，或去控制男人；她们应该保持安静。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","因为先造了亚当，后造的夏娃； ");
INSERT INTO cmnfeb_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","并非亚当受到欺骗，而是夏娃被彻底欺骗，在罪中堕落。 ");
INSERT INTO cmnfeb_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","但女人仍然可以通过做母亲而获得救赎，只要他们始终保持信心、爱心、遵循圣洁而庄重的生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","下面这句话值得我们相信：“如果有人希望成为长者，这也是可以做的善行。” ");
INSERT INTO cmnfeb_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","一个长者必须无可指摘，只娶一名妻子，有节制，保持平衡、庄重、款待他人、善于教导。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","他应该不好酒、不暴力，而是要温和，与人无争或者不贪财， ");
INSERT INTO cmnfeb_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","他必须能管好自己的家，他让儿女做的事情，儿女必须敬重顺服。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","（因为一个男人如果不知如何管好自己的家，怎能管理上帝的教会？） ");
INSERT INTO cmnfeb_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","他不应该是一个新加入的信徒，否则他可能会骄傲，这就落入与魔鬼相同的惩罚之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","他在教会以外也应有个好名声，这样他就不会被人毁谤，从而落在魔鬼的陷阱。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","同样，执事也必须庄重、不伪善、不酗酒、不骗取不义之财。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","他们必须用纯粹的良心信上帝，坚持显示关于上帝真想。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","他们首先应去尝试一段时间，如果没有错误，然后才让他们担任执事。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","他们的妻子也要庄重，不应用闲话中伤他人，应该有节制，所做的一切都应该值得信任。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","执事只应娶一个妻子，善于管理儿女和自己的家。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","那些表现优秀的执事，为自己赢得好名声，也因相信基督耶稣而获得更多自信。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","尽管希望尽快见到你，我仍把这些写给你， ");
INSERT INTO cmnfeb_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","万一我拖延了，你也可以知道人们在上帝的家中应该做出怎样的行为。这是永生上帝的教会、真理的柱石和根基。 ");
INSERT INTO cmnfeb_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","关于上帝所显现的真相真惊人，这一点毫无疑问。他以人的形态让我们知道他，灵是他的证明，天使看到他，向各国宣布，世界相信他，他为此获得荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","但灵很明确地解释说，日后必有人放弃对上帝的信，听从邪灵和来自恶魔的信仰。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","这些虚伪的说谎者，他们的良心已被烧焦。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","他们让人们不要结婚，不要吃上帝所造的那些食物。那些食物，本应由相信和认识真理之人心存感激地领受。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","凡上帝所造即为好的，不应拒绝，而是要心存感激地领受； ");
INSERT INTO cmnfeb_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","因为它因上帝之道和祈祷者而变得圣洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","如果你向兄弟姐妹们指出这些事，你就是基督耶稣的好仆人。相信真想，相信你所遵从的善行教诲，会让你获得力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","拒绝不虔诚的事情，不要相信老妇的无稽之谈；要在精神上训练自己， ");
INSERT INTO cmnfeb_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","因为身体上的训练益处有限；但精神上的训练用处更大，因为“它拥有了今生和来世的承诺。” ");
INSERT INTO cmnfeb_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","你可以相信这句话，所有人都应该接纳它。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","我们工作和尽其所能的原因，就是因为我们的希望就在于永生的上帝。他是所有人的救世主，尤其对于那些相信他之人更是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","你应该这样教导其他人，告诉所有人遵从你的指导。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","不要因为你年轻而被其他人小看，要在你的言语、你的生活方式、你的爱心、信心和纯洁方面，为相信上帝的信徒做出榜样。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","在我抵达那里以前，你务必要向教会阅读经文，通过你的言语和教诲鼓励他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","不要忽略你所获得的恩赐之礼，就是教会长老们向你按手时，借预言赐给你的礼物。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","仔细思考这些事，彻底地将自己奉献给他们，让所有人可以看到你的长进。 ");
INSERT INTO cmnfeb_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","你的行为和你的讲授要谨慎。在这些事上要有恒心，因为你这样作不但能救自己，也能救那些听你的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","不要严厉责备比你年长之人，而是要像自己的父亲一样鼓励他；要像对待自己的兄弟一样，对待年轻人； ");
INSERT INTO cmnfeb_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","将比你年长的妇人视为母亲，将年轻女人视为姐妹，遵守最高的礼仪标准。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","帮助失去家庭的寡妇。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","如果寡妇有儿孙，应当让儿孙先在自己家里学习孝道，报答父母将其养大的恩情，因为这是基督徒的责任。这会让上帝感到喜悦。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","至于真正的寡妇，没有家庭，没有人帮助，孤身一人，她们寄希望于上帝，日夜不停地祷告。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","但寡妇若只想享乐，那么她即使身体活着，也已经死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","要向人们进行这样的指导，让其无可指摘。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","但人若不照顾自己的亲属，尤其是自己的家人，就等于背弃信仰，比不信之人更糟糕。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","只有年过六十、忠于自己丈夫的寡妇，才能被列入名单。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","这样的寡妇应有做善事的声誉：她是否好好地养育儿女？是否会招待客人？是否曾为圣徒洗脚，是否曾救济困苦之人？是否曾尽力行善？ ");
INSERT INTO cmnfeb_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","不能将年轻的寡妇列入这个名单，因为当身体的渴望让她们想要再嫁时，他们就会放弃对基督的献身。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","因此她们因丢弃最初的承诺而有罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","而且她们懒惰惯了，走家串户。不但懒惰，而且好说闲话，好管闲事，说不该说的话。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","因此，我非常建议年轻寡妇结婚，生儿育女，照顾家庭，不给敌人以批评的机会； ");
INSERT INTO cmnfeb_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","但有些人已经追随了撒旦。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","任何女基督徒的家中如果有寡妇，就应该救济她们，不要让教会因这责任而受累。这样，教会就可以救济那些真正有需要的寡妇了。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","那些引导教会的长老，他们的价值应该加倍，尤其是那些进行讲道和传授工作的长老 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","正如经文所说：“牛在踩谷子的时候，不要笼住它的嘴。”还说：“做工就应该获得工钱。” ");
INSERT INTO cmnfeb_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","如果有人控诉长老，除非有两三个证人，否则不要相信。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","要当众责备那些罪人，对其他人也是一个警示。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","在上帝和基督耶稣以及圣天使的面前，我指引你们要没有偏心地遵循这些指引，做任何事都不要采取偏袒的态度。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","不要匆忙地为别人按手，也不要陷入他人的罪之中，要保护自己的纯洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","如果你的胃不好，而且经常生病，不要只是喝水，可以稍微喝点酒。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","有些人的罪非常明显，他们的罪行很确凿；有些人的罪是则是后来才显露出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","同样，有些善行也很明显，即使有的善行隐藏起来，不久后也会显露出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","作为奴仆，应当知道其主人值得尊重，避免玷污上帝之名和基督徒的信仰。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","如果奴仆的主人是基督徒，不可因为他们是兄弟而不尊重主人；相反，要更加倍用心地服侍主人，因为被他们服侍而受益之人，是他们应该爱的信徒。传授这些教导，鼓励人们追随他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","有的人会传授不同的信仰，不听从善意建议，尤其是我们主耶稣基督纯之道，以及上帝的真正教诲。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","他们傲慢无礼，一无所知, 最喜欢猜测和进行理论争辩，由此产生妒忌、纷争、毁谤、恶毒的流言蜚语和邪恶的猜想。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","那些心思败坏、丧失真理的人不断争吵，他们将虔诚视为来财之道...... ");
INSERT INTO cmnfeb_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","但知晓并追随上帝是如此令人满足。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","因为我们没有将任何东西带到这世上，也不能带任何东西离开。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","只要我们有衣有食，就应当知足。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","但那些渴望发财之人，就会落入试探的陷阱；追随很多无知而有害的冲动。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","因为贪财是很多恶行的缘由。很多渴望钱财之人会偏离真理，伤害自己，经历许多的痛苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","但你是上帝之人，应该远离这些事，要追求做善良正直的事情，真正做到虔诚，相信上帝。要去爱，要忍耐和温柔。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","因你相信上帝，所以要为良善而战，坚定地相信永生，你就是因此而受到召唤，这也是你在许多见证人面前做出的承诺。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","在为万物赐予生命的上帝面前，在曾向本丢·彼拉多证实福音的耶稣基督面前，我嘱咐你， ");
INSERT INTO cmnfeb_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","要虔诚地遵循所教导你的一切，这样你就不会受到指责，直到我们的主耶稣基督显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","在适当的时候，那受到祝福的、唯一的全能者、万王之王、万主之主的耶稣，必将显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","只有他能够永生，住在不能靠近的光之中。没有人见过他，也无法看见他。愿荣耀和永恒的力量都归给他！阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","警告那些现世的富有之人，不要骄傲。告诉他们不要去信那并不可靠的财富，要信那赐予我们万物、供我们享用的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","嘱咐他们要行善，在善事上做到富有，准备好分享自己所拥有的，要慷慨好施。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","通过这种方式，他们就是在积累财富，为未来打下一个坚固的基础，让他们可以拥有真正的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","提摩太，要保护好交给你的一切，不要关注那些冒充“知识”毫无意义空谈和争辩。 ");
INSERT INTO cmnfeb_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","那些宣传这些想法的人，已经偏离了对上帝的信。愿恩典与你同在。");
INSERT INTO cmnfeb_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","本信函来自保罗，是上帝所选、耶稣基督的使徒。这封信函是为了讲述在基督耶稣的真正生命中所讲述的承诺。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","这封信写给我亲爱的儿子提摩太，愿你们拥有来自父上帝和我们主基督耶稣的恩惠、怜悯和平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","我如此感谢上帝，就像我的祖先一样，以干净的良心事奉他。我始终都在想着你，在祈祷中提到你。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","我记得你哭泣的样子，就更渴望见你，这会让我真正的感到幸福。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","我记得你对上帝真诚的信，你外祖母罗以和你母亲友尼基也有着同样的信，我知道这信也会在你心中延续。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","因此我想要提醒你，那时候我对你按手，你要把上帝借此赠给你的恩典礼物，赋予更多的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","因为上帝赐给我们的不是让我们胆怯的灵，而是有能力、爱心和理智的灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","所以，不要因向其他人讲述我们的主而感到羞愧，也不要因为我而感到羞愧。你要准备好为福音而受磨难，因为上帝给了你力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","他拯救了我们，呼唤我们过圣洁的生活，但不是通过我们的所作所为，而是通过上帝自己的计划，通过他的恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","早在开天辟地之时，他就通过基督耶稣将这恩典赐予我们，但直到现在才通过我们救世主基督耶稣的出现而显现。通过福音，他摧毁死亡，通过福音让生命和不朽变得无比清晰。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","我是指派讲作为这福音的讲述者、使徒和教师。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","我也因此而受到这些苦，但我不以为耻，因为我知道所信是谁，也深信他能呵护我对他的托付，直到他再来的那一天。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","你从我这里学到好的建议，以之为模范予以效仿，心怀信任和爱耶稣基督的态度。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","你应通过住在我们心中的圣灵，保护托付给你的真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","你已知道，所有亚西亚人都背弃了我，包括腓吉路和黑摩其尼。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","愿主怜悯阿尼色弗一家，因为他多次照顾我，也不因我关入监牢而为耻； ");
INSERT INTO cmnfeb_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","他在罗马时，排除万难寻找我，最终找到了。 ");
INSERT INTO cmnfeb_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","愿主在审判日为他赐福。(提摩太，你很清楚在以弗所时，他为我做了很多）。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","所以，我的儿子，你应当在基督耶稣的恩典中强大起来， ");
INSERT INTO cmnfeb_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","对于我在很多见证人面前所说的一切，你也应该听进去，分享给那些忠心又能够教导他人的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","你应当和我一起遭受磨难，就像基督耶稣的优秀士兵。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","士兵因其职责而不能被每天的琐事缠身，他想要让那招兵之人欢喜。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","同样，运动员如果不遵守规则，就不能获得奖励。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","辛苦工作的农夫理当先尝农作物的成果。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","想想我和你说的话，主将帮助你理解这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","你的思想要关注大卫的后裔、从死人中复活的耶稣基督，这就是我所传的福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","因为这福音，我被像犯人一样投入监牢，但上帝之道不会被困于牢狱。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","尽管如此，我原意为上帝子民而继续这样做，让他们也可以获得基督耶稣的救赎和永恒荣耀 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","下面这句话是可信的：“如果我们与基督同死，就必与他同活； ");
INSERT INTO cmnfeb_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","如果我们继续忍耐，就会与他一同为王；我们若不认他，他必不认我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","即使我们不值得信赖，他仍然值得信赖，因为他不能不真实地对待自己。” ");
INSERT INTO cmnfeb_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","你要提醒众人，在上帝面前告诉他们，不要作毫无意义的争辩，这只能伤害那些听众。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","务必要努力工作，这样你就可以在上帝面前展示自己，获得他的称许。要做一名无愧的工人，正确地讲解真理之道。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","远离毫无意义的闲聊，因为这样做会让人们远离上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","他们的讲述好像坏疽一样具有破坏力，会摧毁健康的身体；许米乃和腓理徒就是这样的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","他们偏离了真理，说复活之事是过去发生的事情，这破坏了一些人对上帝的信心。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","但上帝值得信赖的坚固基石非常稳固，上面刻着这样的字：“主认识属于他之人”和“凡称呼主名之人都应远离不义”。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","在庄严堂皇房子中，不能只有金子和银子做的杯碗，还应有木器、瓦器；有的是特殊用途，有的则是经常使用。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","因此，如果你远离邪恶，就会成为圣洁而特别的杯子或碗，供主使用，准备好做各种善事。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","应远离那些点燃年轻人欲望的事情，去追随正直良善、值得信赖的事情，与那些真正纯洁的基督徒一起追随爱与和平。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","拒绝愚蠢而幼稚的辩论；你知道它们只会引发争斗。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","但主的仆人决不能争斗，而是要温和对待所有人，能够教导，保持耐心， ");
INSERT INTO cmnfeb_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","温和地规劝对手。或许上帝可以帮助他们悔改，可以认识真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","这种方式，他们可能会恢复理智，逃离魔鬼的陷阱。魔鬼曾抓住他们，让他们去做魔鬼想做的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","你要意识到，在末日期间必有艰难的时期。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","那时人们只爱自己和钱财。他们会自夸、傲慢、亵渎、悖逆父母、忘恩负义、生活中不再有上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","他们内心无情、不肯宽恕，他们会恶言中伤、没有自律、性格凶残、痛恨良善、 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","背叛其他人、不考虑其他人/荒唐地只想着自己、追逐享乐胜于爱上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","他们外在表现得可能很虔诚，却其实并不相信虔诚的力量；要避开这样的人！ ");
INSERT INTO cmnfeb_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","他们这种人会偷偷潜入别人家中，操纵脆弱的妇女。这些妇女背负罪的负担，被各种私欲所累， ");
INSERT INTO cmnfeb_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","虽然常常学习，却始终无法明白真理！ ");
INSERT INTO cmnfeb_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","就像阎儡和阎悖如何反对摩西，这些人就是那样反对真理。他们的思想已经腐朽，认为对上帝的信是一个谎言。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","然而他们这样的状态不会太久，他们的愚昧会在所有人面前显露，好像阎儡和阎悖那两个人。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","但你了解我的教导和行为，了解我的生命目标，了解我对上帝的信和我的爱。了解我一直以来都在忍耐什么， ");
INSERT INTO cmnfeb_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","我受到的迫害和苦难。你了解我在安提阿、以哥念、路司得都遭遇了什么，我遇到的困境，以及主如何救我脱离这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","当然了，希望以基督耶稣献身于上帝的所有人，都必遭受迫害。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","与此同时，恶人和骗子则越来越坏，他们欺骗人，也欺骗自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","你必须坚守所学的、确信为真相的事情；你知道是谁教给你的。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","你从儿时起就知道神圣的经文，它让你能够拥有理解力，可以通过信基督耶稣获得救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","所有上帝启迪写下的经文，都有助于我们进行教导，纠正错误，让我们走正道，告诉我们何为良善正直。 ");
INSERT INTO cmnfeb_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","上帝就是通过这种方法，让那些为他工作、完成所有善行之人，做好万全准备。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","这就是我在上帝和耶稣基督面前，指导你要做的事情。当耶稣基督到来并建立他的王国，将对活人和死人进行审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","无论是否方便，都要讲述上帝之道；如果人们犯错，要告诉他们，警告他们，鼓励他们。当你这样做时，要用极大的耐心进行教导。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","因为人们即将不再听得下真正的教导，那个时刻很快就会到来。到时候，他们会好奇地想要听不一样的教导，他们身边的老师，会讲述他们爱听的东西。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","他们不再聆听真理，反倒流连于谬误。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","你要时刻保持明智，忍受磨难，进行传福音的工作，完成你的职责。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","我即将被牺牲；我离世的时候即将到来。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","我已进行了一场良善的战斗，已跑完比赛，已坚持对上帝的信。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","现在有一个奖励留给了我，那是因遵循好事和正直良善而获得的冠冕。主（他是总能正确行事的法官）会在那一天给我这个冠冕。不只是给我，也给渴望他到来的所有人。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","请尽快到我这边来。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","因为底马因贪恋现今的世界，已离开我去了帖撒罗尼迦。革勒士去了加拉太，提多去了达马太。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","现在只有路加在我这里。请把马可带来，他可以帮助我的工作。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","我已派推基古到以弗所去。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","你来的时候，请带上我在特罗亚时留在加布那里的外衣。还有那些书，特别是那些羊皮书，也要带来。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","铜匠亚历山大给我带来了很多麻烦，愿主根据他的行为审判他。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","你也要提防他，因为他极力反对我所说的话。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","我第一次辩护的时候，没有一个人支持我，反而离开我。但愿他们不会因此而受到责备。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","但主站在我身边，给我力量，让我可以宣讲所有的福音信息，让所有外族人都能听见；他将我从狮口中救出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","主必救我脱离一切邪恶之事，也必带我安全进入他在天上的王国。愿荣耀永远归给他。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","替我问候百基拉、亚居拉和阿尼色弗一家人。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","以拉都留在了哥林多。因为特罗非摩病了，我就留他在米利都。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","请尽可能在冬天前赶过来。友布罗、布田、利奴、革老底亚和所有兄弟姐妹都向你问候。 ");
INSERT INTO cmnfeb_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","主与你同在。愿他的恩典与你们同在。");
INSERT INTO cmnfeb_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","这封信来自上帝的仆人、耶稣基督的使徒保罗。我发送这封信，是为了建立上帝所选子民的信心，并分享可以让我们为上帝而活的真理知识。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","这给了他们永生的希望，这永生是从不说谎的上帝很久以前承诺的。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","在适当的时候，上帝就按照福音的宣讲，显现他的道。这宣讲也是我遵循主上帝的命令，在他的委托下讲述给你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","这封信是寄给提多的，他是我真正的儿子，通过我们共同对上帝的信任。愿你们拥有来自父上帝和救世主基督耶稣的恩惠和平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","我过去之所以把你留在克里特岛，是要你办好需要完成的事，照我所说的在各城任命长老。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","长老的人选必须拥有良好声誉，有一名妻子，儿女都信主，没有人控告其放荡或不服从。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","作为上帝的领导者，大长老必须拥有良好的声誉，不能傲慢自大、不能随便动怒、不好酒、不打人、不贪不义之财。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","他要热情好客, 喜爱好的事情，做良善正直的事情。他应为上帝而活，应该自我控制， ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","必须将自己奉献给那所传授的、值得信赖的道。这样他能以正确的教导鼓励他人，说服那些不同意的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","因为周围有很多背叛者，他们说了很多没有意义的欺骗之语，尤其是来自奉行割礼的那群人。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","他们的言论必须停止。这些人让整个家庭陷入混乱，为了赚钱而进行错误的传授。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","他们自己人中就有一个先知说过：“克里特人总爱说谎，他们就是懒惰而贪婪的恶兽。” ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","这说的是真的。因此，你要严厉地责备他们，让他们用健全的方式相信上帝， ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","不再理会犹太人的无稽之谈和偏离正道之人的说法。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","对于心灵洁净之人，一切都是洁净；但对于污秽和不信上帝的人，一切都不洁净，连他们的思想和良心都是污秽的。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","他们声称知道上帝，行为却显示并非如此。他们是可憎的、悖逆的，做任何善事都毫无用处。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","至于你，你应当进行符合正确信念的宣讲。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","让年老的男人不要饮酒，他们应该值得尊重，明白事理，以健全的方式相信上帝，有爱心，有耐心。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","同样，让年老的女人应该在行为中显示他们为上帝而活。他们不应该以言辞毁人的名声，并且不应该沉迷于葡萄酒。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","他们应该教导其他人什么是善行，教导年轻的妻子爱她们的丈夫和儿女， ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","要明白事理、贞洁、做好家务、做善事、聆听丈夫对她们所说的。只有这样，上帝之道才不会错误讲述。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","同样，让年轻的男子要明事理。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","你应该在生活的方方面面，显示你作为善行的榜样；在你教导的事情上，显示你的正直和认真， ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","分享无可指责的正确信念，通过这种方式，让那些反对的人对自己感到羞愧，不再说出任何诋毁我们的话语。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","告诉奴仆们凡事要遵从自己的主人，让主人欢喜，不要顶嘴。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","他们不应偷东西自己用，而是要显示出绝对的诚实，这样才能正确地代表我们救世主上帝所讲述的真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","上帝拯救所有人的恩典已经显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","它教导我们拒绝不虔诚的生活方式和这世间的欲望，而是要在这个世界，在上帝面前，过着考虑周详、自控的生活， ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","与此同时，期待伟大上帝和救主耶稣基督荣耀显现的美好希望。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","他舍身为我们，这样就能救赎我们脱离一切邪恶之事，让我们为他而变得洁净，成为属于他的子民，热心行善。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","这就是你要宣讲的事情，你有权力去鼓励其他人，在需要的时候纠正其他人。不要让任何人低看你。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","你要提醒他们，遵从掌权人让他们做的，服从权力。他们应该随时准备做任何善事。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","他们不应该毁谤其他人，不要与他人争论，要向所有人显示温柔和礼貌。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","曾几何时，我们也很无知、不顺服。我们受到蛊惑，成为各种私欲和享乐的奴隶，我们过着邪恶的生活，到处都是嫉妒和愤愤、彼此憎恨的人， ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","但当我们的救世主上帝显示其良善和慈爱，他拯救我们 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","不是因为我们做了什么善事，而是出于他的怜悯。他通过重生的洁净和全新的圣灵实现这一点， ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","通过我们的救世主耶稣基督，将圣灵大量倾注于我们身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","既然我们因他的恩典而变得良善正直，就可以凭着对永生的希望成为他的后代。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","你应该相信我说的这番话，希望你能强调这些指导，让那些相信上帝的人可以认真思考自己，认真做善事；这些都很重要，对所有人都有益。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","避免进行毫无意义的讨论，不要迷恋家谱, 不要争论，不要对犹太律法争吵，这都是毫无用处的，完全没有帮助。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","警告哪些曾造成不和的人，就像之前说的那样，之后就不要在关注他们了。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","要意识到，他们已经背道，是罪人，他们定了自己的罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","我派亚提马或推基古到你那里去时，你要赶快到尼哥波立来见我，因为我已决定在那里过冬。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","你要尽可能帮助西纳律师和亚波罗的旅程，让他们备好所有必须的物品。 ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","希望我们自己人可以学习做善事的习惯，满足他人的日常需要，他们需要做出贡献！ ");
INSERT INTO cmnfeb_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","和我在一起的所有人都向你问候。请把我最美好的祝福送给那些我们的人，那些相信上帝的人。愿恩典与你们所有人同在。");
INSERT INTO cmnfeb_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","这封信来自基督耶稣的囚徒保罗以及我们的提摩太兄弟，写给我们的好朋友和工友腓利门 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","以及我们姐妹亚腓亚，此外，还写给与我们并肩战斗的亚基布以及在你家中的教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","愿你们获得来自天父上帝和主耶稣基督的恩典和平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","我在祷告的时候始终会记得你们，因为你们而感谢我的上帝， ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","因为我听说了你们对主耶稣的信以及对众信徒的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","当你们意识到我们从基督那里分享的所有美好事物，我祈祷你们将对上帝的满怀信任付诸行动。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","我亲爱的兄弟，你的爱带给我更多的欢喜和安慰。你激励了我们所有这些有信仰的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","所以，尽管我因信基督而斗胆吩咐你履行职责， ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","但我宁愿因爱而请你们提供帮助。我已经老了，现在又成为基督耶稣的囚徒， ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","现在为我在囚禁时成为我养子的欧尼西慕求你。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","他从前对你并无用处，但现在对你我却都有用处。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","我现以我最诚挚的愿望，派他到你那里。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","我宁愿把他留在这里和我一起，这样他就可以在我因为讲述这个好消息而被关在枷锁里的时候代表你帮助我。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","但没得到你的同意，我决定什么也不做，不想让你们感觉被迫做好事，并非自愿这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","也许你暂时失去了他，这样你就可以永远拥有他了！ ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","不再是奴隶，而是高于奴隶。他是被特别爱护的兄弟。对我尤其如此，对你甚至更是如此，不论作为一个人还是相信主的信徒，都是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","所以，你们要是把我看作与你一起为上帝工作的同伴，就像迎接我一样迎接他。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","如果他做了什么错事或欠了你什么，都算在我头上。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","我保罗亲自在这里写下：我必偿还。当然我不会提到你欠我什么，包括你的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","是的，兄弟啊！让我在主那里获得你的帮助；请让我以在基督中感到幸福。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","我深信你会做我求你的事情——事实上，我知道你所做的将会超过我所说的，因此才写信给你。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","同时，还请你为我准备一个房间，因为我希望能借着你们的祷告，可以获得释放到你们那里去。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","以基督耶稣的缘故和我一同坐牢的以巴弗， ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","以及我的共有马可、亚里达古、底马、路加都在问候你。 ");
INSERT INTO cmnfeb_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","愿我们主耶稣基督的恩典与你们众人同在。");
INSERT INTO cmnfeb_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","很久以前，上帝曾多次通过不同的方式借由先知向我们的祖先说话； ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","在这最后的岁月中，上帝又通过他的儿子向我们说话。上帝指认他继承万物，借由他创造宇宙。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","他是上帝的荣耀之光，是上帝性格的显现表现，用其强大的号令支撑万物；当他完成清洁罪恶之事，就会坐在天堂至尊者的右边。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","他的名比天使更尊贵，所以地位高于天使。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","照样，基督也没有因成为大祭司而为荣。是哪——上帝曾对他说“你是我的儿子。今天我已成为你的父亲。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","上帝派其长子来到这世上，又说：“让上帝所有的天使都膜拜他。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","关于天使，他说：“上帝以他的天使为风，以他的仆役为火焰。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","但是说到他的儿子，他说：“上帝啊！你的宝座必将永恒存在，你王国的权杖是公平的权杖。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","你喜爱正义良善，憎恨不法。所以上帝，也就是你的上帝，会为你涂抹欢喜的油膏，以此让你高于其他人。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","“主啊！你最初铺设了大地的根基，天也是你双手的作品。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","它们都会终结，你却会长存；它们会像衣服一样逐渐破旧， ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","你却会把它们像外套一样卷起来。天地就像衣服一样会被更换；只有你永不改变，你的生命也没有穷尽。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","上帝可曾向哪个天使说：“你坐在我的右边，等我将你的仇敌放在你的脚下”？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","天使呢？天使都是仆从，被派出去为那些将要获得救赎的人效劳。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","因此，我们必须更密切地关注我们学到的一切，免得我们远离它们。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","如果天使所传递的信息都是值得相信的，那么所有罪行和不服从之举，就会得到应得的结果。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","如果我们忽略如此伟大的救赎，怎么又能逃罪呢？这救赎最初由主亲自宣讲，后来听见它的人又向我们证实。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","上帝又按照自己的选择，用神迹、奇事和各种异能以及圣灵之礼，作为见证。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","上帝并没有把我们所说“即将到来的世界”，交给天使管理； ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","但经文中说道：“人算甚么，你竟担心他们？人之子算甚么，你竟关心他？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","你让他比天使卑微一点；你赐给他荣耀尊贵, 将他置于万物之上。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","你让他拥有统治一切的权利。”上帝给了他统治万物的权利，就没有什么高于他了。然而，我们看到，并不是所有的东西都受制于他的权威，还不是。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","但我们看到耶稣，有一段时间被置于比天使低一点的位置，通过遭受死亡的痛苦，获得荣耀尊贵的冠冕。通过上帝的恩典，耶稣为众人体验死亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","那创造和保持一切的上帝，应该为他的很多儿子带来荣耀。引导人们获得救赎的耶稣是通过苦难完全准备好的。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","因为那让人变得神圣之人，以及那些变得神圣之人，都是一家人。所以他会毫不犹豫地称他们为兄弟。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","他说：“我要向他们宣扬你的名，我要在他们的聚会中赞美你。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","又说：“我要信任他。”；还说：“我来了，与上帝赐给我的孩子们一起。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","因为孩子们都有血肉之躯，他自己也同样拥有血肉之躯，这样就可以通过死亡，消灭那掌控死亡权力的魔鬼， ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","释放那些因为怕死而终身为奴仆之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","当然，他关心的并不是天使，他只关心亚伯拉罕的子孙。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","所以他必须在各方面与其兄弟们相同，这样就可以在上帝的事情中，成为仁慈忠信的大祭司，原谅其子民的罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","因为他自己已在试探中遭受苦难，能够帮助那些被试探的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","因此，为上帝而存在、共同听从天召的兄弟姐妹，我们需要认真思考耶稣——我们称之为上帝派来之人，大祭司。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","在他被选去做的事情中，他忠于上帝，就像摩西在上帝之家忠于上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","因为耶稣值得拥有比摩西更大的荣耀，就像建造房屋的人，比房屋本身值得拥有更大的尊贵。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","每一间房屋都有其建造者，上帝是万物的建造者。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","摩西作为仆人在上帝之家中效忠上帝。他提供了以后要宣布的证据。； ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","但是基督却是负责上帝之家的儿子。如果我们对所信仰的希望充满信心，我们就是神的家。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","所以，就像圣灵所说：“如果你们今天听到上帝对你说的， ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","就不要铁石心肠，比如在荒野试探他，反叛他； ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","你们的祖先曾通过这种方式试探我，在四十年中一直都看到我给他们的证据。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","那个世代的人让我发怒，于是我说：‘他们的思想总是出现错误，不知道我或我所做的事情。’ ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","于是我在沮丧中起誓：‘他们绝不可进进入我的安息。’” ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","兄弟姐妹们，你们要小心，免得你们中间有人存着邪恶之心，放弃了对永生上帝的信； ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","在你们还有“今天”的时候，要互相劝勉，免得有人受罪恶的诱惑，变得铁石心肠。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","如果我们把最初对上帝的信念坚持到底，我们就是基督的伙伴了。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","正如经文所说：“如果你们今天听到上帝对你说的，就不要铁石心肠，就像反抗他的那时候一样。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","那时候，听到上帝所说的话而反抗的谁呢？不就是摩西从埃及带出来的那些人吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","是谁让上帝在四十年内感到不快？不就是向那些在埋葬在荒野中的罪人吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","当上帝发誓他们不可进入他的安息，这又是向谁说的？难道不是向那些不遵从的人吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","所以我们会看到，他们因为不信而无法进入安息。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","尽管上帝给了我们进入其安息的承诺，我们就应该小心翼翼，任何人都不要错过了！ ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","因为我们就像他们一样也听到了福音，只是他们不接受也不相信听见的道，所以对他们没有益处。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","但我们相信上帝之人已经进入安息。正如上帝所说：“我在沮丧中起誓，‘他们绝不可进入我的安息。’”（尽管上帝在创立世界的那一刻就已完成其计划，但仍然如此。） ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","关于第七日，在经书中有一句说到：“在第七日，上帝停下了他的一切工作。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","但前文还有一句说：“他们绝不可进入我的安息。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","上帝的安息仍在那里，有的人可以进去，尽管那些先前听到好消息的人因为不顺从而没有进入。； ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","过了很久以后，就像他之前所做的那样，上帝通过大卫所说的“今天”再次定了一个日子：“如果你们今天听从他的声音，就不要铁石心肠。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","如果约书亚已让他们享受了安息，上帝后来就不会再提到其他日子。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","所以，为了上帝的子民，必定会有一个安息日的休息。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","因为进入上帝安息之人也歇了自己的工作，好像上帝歇了自己的工作一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","所以，我们应全力进入安息，免得有人因按照那不顺从的例子而跌落。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","因为上帝之道是活的，是有效的，比一切两刃剑更锋利，甚至可以刺入并剖开生命和呼吸，关节与骨髓，能够审判心中的思想和意念。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","一切生命在上帝面前都无处遁形。我们对他负有责任，一切在他面前都暴露在外，完全显露。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","我们既然有一位升入天堂的伟大祭司，也就是就是上帝之子耶稣，就应该确定和坚持我们的信仰。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","因为大祭司并非不同情我们的软弱，他像我们一样，也曾在各方面受过试探，只是他没有犯罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","所以，我们只需自信地来到上帝的恩典宝座面前，在我们真正需要帮助时获得怜悯，得到恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","每位大祭司都从人间挑选出来，受指派为上帝有关之人做事。他会向上帝献上他们的礼物和赎罪的祭物。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","大祭司理解那些无知和迷途之人的感受，因为他自己也曾体验那人类的软弱。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","因此，他必须为其罪献祭，为人们的罪献祭。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","没有人能为自己获得大祭司的地位，只有像亚伦一样被上帝选中才可以。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","照样，基督也没有因成为大祭司而为荣。是哪——上帝曾对他说“你是我的儿子。今天我已成为你的父亲。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","在另一处经文中，上帝说：“你是照着麦基洗德的等次永远为祭司。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","基督还以人形存在之时，曾经流泪大声祷告，恳求那能救他脱离死亡的上帝。因他对上帝的尊敬，上帝听到了他的祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","尽管他是上帝之子，耶稣还是通过苦难学会了何为顺从。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","他结束了自己的经历后，就成了所有顺从他之人获得永恒救赎的根源。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","他被上帝指定为按照麦基洗德的次序担任大祭司。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","说道耶稣，我们有很多话要说，这很难解释，因为你们似乎无法理解。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","到现在，你们应该已有足够的时间去成为老师了，但还需要别人教你们基本信息，那些都是上帝之道的基本道理。你们似乎变成只能吃奶、无法吃干粮的人！ ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","凡吃奶的都还是个婴孩，没有经历过正义良善之路； ");
INSERT INTO cmnfeb_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","只有长大成人才能吃干粮，始终使用其大脑学到的东西分辨是非。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","所以，不要困于关于基督的基本教义，而是要努力成长为更成熟的理解。不需要再去重温忏悔过去所作所为的想法、关于信上帝、 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","或关于洗礼、按手礼、死人复活和永远审判的教义。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","只要上帝允许，我们就这样作。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","因为一个人如果曾理解和经历上帝的天堂恩赐、曾分享过圣灵、 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","曾知晓上帝正直良善之道以及在来世的力量， ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","然后完全抛弃上帝， 就不可能再让他们重新悔改了，因为他们亲自把上帝之子再次钉在十字架上，公然羞辱他。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","这就像一块地，以雨水浇灌，为种植土地之人生出粮食，就是获得上帝的祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","但如果这块地只生出野草和荆棘，就没有价值了，几乎等于被定罪，最终能做的就是将其焚烧。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","但亲爱的朋友们，我们虽然这样说，却深信你们会做得更好，你们会得到救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","因为上帝并不是不公义，他没有忘记了你们做过的一切，以及你们以他之名所表现的爱心，以前服侍过信徒，现在仍在这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","我们希望你们每个人都表现同样的热诚，相信上帝的希望，直到它实现。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","在精神上不要懒惰，而是要效法那些通过信上帝和耐心、让上帝承诺变成现实的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","上帝承诺亚伯拉罕时，因为没有比他更伟大之人可以指着起誓，他就指着自己起誓， ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","说：“我必定赐福给你，必定让你后代满堂。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","于是亚伯拉罕耐心等待，这承诺终于办成现实。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","人都要指着比自己更伟大的发誓。如果他们中间有什么纠纷，这誓言就像是一锤定音，解决这些纠纷。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","上帝也是通过发誓，向那些获得承诺之人更清楚地表明，他的心意不会更改。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","所以这两件事是不能更改的，因为上帝是决不说谎。因此，我们这些为安全而逃亡之人，完全可以相信，抓紧上帝呈现给我们的希望。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","这希望就像灵魂的锚，又确定又坚固，引领我们穿越帐幔走到上帝面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","耶稣已代表我们去了那里，因为他已经按照麦基洗德的次序成为大祭司。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","麦基洗德曾是撒冷王，是至高上帝的祭司。亚伯拉罕战胜众王回来时，麦基洗德曾迎接他，并且给他祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","亚伯拉罕也把自己得来的一切，拿出十分之一来给他。麦基洗德的名字意思为“公正之王”；而撒冷王则是“平安之王”的意思。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","关于他的父亲、母亲或族谱，我们不得而知。也不知道他何时生死。就像上帝之子，他永远都是一名祭司。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","想想这个人多伟大，即使祖先亚伯拉罕也要从战利品中拿出十分之一给他。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","是的，利未的子孙也是祭司，奉命按照律法向人民——也就是自己的兄弟姐妹、亚伯拉罕的后裔们，收取十分之一。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","麦基洗德并非来自同一家族谱系，也收下了亚伯拉罕的十分之一，给这获得上帝承诺之人祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","更伟大之人向更渺小之人祝福，这一点毫无疑问。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","在这里，收取十分之一之人都是必死之人；一但在这种情况下，他们被一个据说是永远活着的人所接受 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","可以这样说，连那收取十分之一的利未，也通过亚伯拉罕缴纳了十分之一。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","因为麦基洗德迎接亚伯拉罕时，利未还未从其父那里诞生。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","如果借着利未人的祭司制度能达到完美（人民是在这制度下领受律法的），为什么还需要照着麦基洗德的体系，另外指认一位祭司，而不是按照亚伦的体系呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","如果祭司制度更改了，律法也必须更改。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","因为我们所指的那位，原属于另外一个支派的，这支派向来没有人在祭坛前供职。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","我们的主明明是犹大支派的后裔，关于这个支派，摩西并没有提及祭司。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","让人更清楚的是，当另一位与麦基洗德相似的祭司出现时。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","他成为祭司，并非按着律法上人类祖先的条例，却是按照不能终止生命的能量。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","所以他才会说：“你永远作祭司，按照麦基洗德的秩序。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","从前的条例因为没有力量，所以没有用处，就废弃了 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","（因为律法从来没有让任何事变得完美）。但它却带来了更美的希望，借着这希望，我们就可以亲近上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","这还要说道誓言，尽管那些人成为祭司并非通过誓言； ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","只有耶稣同时誓言确立，因为上帝对他说：“主已经庄严起誓，决不改变心意，你永远是祭司。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","耶稣既然是用誓言确立，就成了与上帝之间更美好约定关系的保证。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","从前那些作祭司的，因为死亡妨碍他们无法长久留任，所以人数众多。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","但由于耶稣永远长存，他的祭祀职位永不更改。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","因此，他能拯救那些通过他来到上帝面前之人；因为他永远活着，会为他们代求。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","我们就需要他这样的大祭司：圣洁，没有错误；纯洁，区别于罪人，在最高的天堂中有自己的位置。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","他不必像那些大祭司，天天先为自己的罪献祭，然后为人民的罪献祭；因为他献上了自己，就把这事一次而永远地做完了。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","律法所立的大祭司，都是不完美之人；但在律法以后，上帝用其誓言所立的儿子，却是永远完美。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","我们所讲论的重点，就是我们有这样的一位大祭司，他已经坐在众天之上至尊者的宝座右边， ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","他在圣所和真正的礼帐幕中供职；这真正的礼帐幕是主建造的，而非人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","因为所有大祭司都是为献礼和祭品而设立，所以这位大祭司必须也要有所献奉。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","如果他在人间，就不会作祭司，因为已经有按照律法献礼物的祭司了。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","这些祭司所供奉的地方，不过是天上的复制品和影像，就像摩西将要造礼拜堂的时候，上帝曾经警告他说：“你要留心，各样物件都要按山上指示你的那样去做。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","但是，耶稣被赋予了一个好得多的事奉，既然他是我们与上帝之间更美约定关系的中间人，这约定凭着更美的承诺而立。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","如果头一个约定很完美，就不必寻求另一个约定。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","但上帝指出他们的错误，说：“注意了，主说，因为那日子要到了，我要与以色列家和犹大家订立新约定。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","这新约定不像从前的约定，那时候我曾拉着他们祖先的手，领他们走出埃及。因为他们没有遵守我的约，我就放弃他们。这是主说的。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","我要与以色列家所立的约是这样：在那之后，主说，我要把我的律法放在他们心里，写在他们的心上。我要作他们的上帝，他们要作我的子民。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","每个人都不需要教导自己的邻居，也不需要教导自己的家庭成员，不要说：你要认识主。因为所有人，从最渺小到最伟大，都认识我。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","我将宽恕他们的错误，决不记着他们的罪恶。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","上帝既然说“一个新的约定关系”，就是把之前的约定废弃；那个约定已变成陈旧，即将消逝。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","之前的约定也有它敬拜的规例和现世的圣所。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","会幕的第一个房间里有烛台、桌子和圣饼。这被称为 “圣地。”。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","穿过圣幕的第二层帐幔进入的房间，叫作至圣所， ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","里面有金香坛，有全部包金的“约柜”，柜里有盛着吗哪的金罐、亚伦那曾发芽的手杖和两块石头约板。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","上面是荣耀的基路伯，罩着施恩座，关于这一切，现在不能一一细说了。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","这一切物件都这样预备好了，祭司会进入第一个圣幕房间，履行他的职责。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","至于第二个房间，只有大祭司每年独自进去一起，他的祭祀还要带着血，为自己和人民的无知之罪之罪，把血献上。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","圣灵借着这事表明，第一个圣地还存在的时候，进入至圣所的路，还没有显明出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","这是给我们现在人的一个例证，让我们看见所献的礼物和祭物不能让敬拜者的良心更清明。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","它们只是宗教规定--关于食物和饮料，以及涉及清洗的各种仪式--这些规定是在神的新方式与他建立关系之前制定的。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","基督已经来了，作了我们现在所拥有的美好事物的大祭司；他进入更伟大、更完备的礼拜堂，这并非人手所做，也是不属于这被创造的世界。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","他不是用山羊和牛犊的血进入，而是用自己的血。他只进入一次至圣所，就使我们永远自由。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","即使是山羊和公牛的血或母牛的灰，洒在不洁的人身上，尚且可以使他们成为圣洁，身体洁净， ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","何况基督的血呢？他借着永远的灵，把自己无罪的生命献给上帝，他的血不是更能洁净我们的良心，脱离过往罪行，这样我们就可以事奉永生的上帝了？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","因此，他作了新约定关系的中间人，借着他的死，救赎了人们在第一份约定关系中犯下的罪行，让那些蒙召之人，获得永远继承的承诺。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","凡要实施遗嘱，必须证实立遗嘱的人死了； ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","因为人死了，遗嘱才能确立，立遗嘱的人还活着的时候，遗嘱决不生效。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","因此，第一份约定才会用血立下： ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","摩西按照律法，向所有人民宣布了各种诫命，就曾用牛犊和山羊的血和水，朱红色羊毛与牛膝草，洒在律法书和人民身上， ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","他对他们说：“这就是上帝告诉你们，他想要与你们立约的血。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","他还把血洒在圣幕和各样敬拜使用的器皿上。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","按着仪式的律法，几乎一切都要用血来洁净，如果没有流血，仪式上就无法洗刷罪恶的污点。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","如果照着天堂的样子去做时必须这样洁净，天上的物体，就应该用更美的祭品去洁净。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","因为基督并未进如人手搭建的至圣所，那不过是原始建筑的模仿。基督进入了天堂，现在替我们说话，显露在上帝的面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","他不必多次献上自己，好像大祭司每年进入至圣所，但他献祭的血并不是他自己的血。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","如果这样，从创世以来，基督就该受过许多次苦了。并没有：就在这一次，在这当前时代的末期，他通过牺牲自己消除罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","正如人只死一次，然后被审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","基督也是如此。他曾为消除很多人的罪而牺牲一次，他会再来，不是为了消除罪，而是为了拯救那些等待他的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","律法只是即将到来之美好的影子，并非实物本身, 所以永远无法通过年复一年的反复献祭，让那些敬拜上帝之人实现正直良善。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","如果敬拜的人一次得洁净，良心就不再觉得有罪，那么，献祭的事不是早就停止了吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","可事实上，那些祭品却使人每年都想起罪来， ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","因为公牛和山羊的血不能清除罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","所以，基督到世上来的时候，会说：“祭品和礼物不是你所要的，你为我准备好身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","燔祭和赎罪祭不会让你喜悦； ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","那时我说：‘上帝！看啊，我来做你让我做的事情，就像经书上记载的那些关于我的事。’” ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","之前说道：“祭品和礼物，燔祭和赎罪祭，都不是你想要的，不会让你喜悦。”(尽管它们都是按照律法要求献祭的)。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","然后他又说：“看哪！我来了，是要做你想做的事情。”他废除了第一个约定，建立第二个。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","我们通过这约定，借着耶稣基督一次献上他的身体，就已获得神圣。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","所有祭司天天事奉，反复献上同样的祭品，那些祭品永远不能清除罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","唯有这个祭司，进行一次永远有效的赎罪献祭，然后就在上帝的右边坐下来。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","现在，他只需等待他的敌人被征服，让他们成为他的脚凳。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","因为他的一次献祭，就让那些圣洁之人永远成为正直良善。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","圣灵也告诉我们，他这样说： ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","“主说：‘今后，我与他们所立的约是这样的：要把我的律法放在他们的心里面，写在他们的心上。’”他又说： ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","“我不再记着他们的恶和不法行为。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","这一切被赦免后，就不需要为罪献祭了。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","所以，兄弟姐妹们，凭着耶稣的血，我们可以自信地进入至圣所。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","他通过其生死给我们开辟一条全新的、永生的道路，穿越帐幔来到上帝面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","我们有一位伟大的祭司管理上帝的家， ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","我们良心的邪恶既然被洒净，身体也用清水洗净了，那么，我们就应该怀着真诚的心和完备的信，走近上帝； ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","因此，让我们紧紧抓住对别人讲述的希望，不要犹豫，因为上帝的承诺值得信赖。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","让我们想想如何激励彼此，去爱，去做善事。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","我们不可放弃聚会，好像有些人的习惯一样；要互相劝勉。你们既然知道那日子临近，就更应该这样。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","如果我们领受了真理的知识，还是故意犯罪，就再没有留下赎罪的祭品了； ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","剩下的只有恐惧，等待即将到来的审判，以及毁灭敌视上帝之人的可怕火焰。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","如果有人违背摩西的律法，凭着两三个证人，他仍然得不到怜悯，需要去死； ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","何况是践踏上帝之子，无视那让他圣洁的立约之血，把它当作俗物，滥用恩典之灵，你们想想，他会遭受怎样的惩罚？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","我们知道上帝他说过：“我要确保正义得到伸张；我会给人们其应得的东西。”他还说：“主必审判他的子民。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","在永生神的大能下是很可怕的。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","回想从前的日子，那时，你们理解了真理后，忍受了许多痛苦； ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","有时会被侮辱和攻击, 又要与那些受苦的人团结地站在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","你们同情那些遭监禁的人；你们的家业被抢夺的时候，又以欢喜的心接受，因为知道自己有更美长存的家业。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","所以，你们不可丢弃坦然无惧的心，这样的心必有丰厚赏赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","你们还需要忍耐，好让你完成上帝的旨意，可以领受承诺的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","“还有一点点的时候，他会来，正如他所说的，不会迟延。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","那些做正确之事的人，会因信上帝而活着；如果他们背弃承诺，他们不会让我感到满意。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","但我们不是那种退缩并最终迷失的人， 而是那些相信上帝会拯救我们的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","我们对上帝的信，就是对所盼望之事的确定，是没有看见的事的明证。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","因着这对上帝的信，古人得到了上帝的称许。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","因着我们对上帝的信，我们明白整个宇宙是上帝命令建造的，也就是说，看得见的一切，可以看到的东西是由不能看到的东西构成的。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","亚伯因为相信上帝，献上了比该隐更美的祭品；借着这信心，他被上帝称许，认为他生活在正直良善之中。上帝通过接受他的献祭表明了这一点。尽管亚伯已死很久，仍然通过他的所作所为对我们说话。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","因为信上帝，以诺被带到天堂，让他不会死，人也找不着他，因为上帝把他带到天堂了。在发生这件事之前，他就被称为是让上帝喜悦之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","没有信，就不能得到上帝的喜悦；因为来到上帝面前的人，必须信上帝存在，并且信他会赏赐那些寻求他的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","诺亚信上帝，所以上帝向他警告一些之前从未发生过的事情。因为诺亚非常重视上帝的话，所以建造了一艘方舟拯救自己的家人。通过信上帝，诺亚表明世界是错的，作为奖励，上帝确认他正直良善。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","通过信靠上帝，当上帝呼唤亚伯拉罕去上帝将赐给他的土地时，亚伯拉罕听从了。他离开的时候，并不知道要去哪里。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","他信上帝，住在上帝承诺之地。作为一个外族人住在帐篷里，与他分享相同承诺的以撒和雅各一起生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","因为他等待那座有根基的城，就是上帝所设计所建造的城。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","因为信，撒拉虽然过了生育的年龄，还是能够怀孕，因为她认为承诺她的一切是值得信赖的。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","这就是为什么一个几乎快死之人，竟然生出许多子孙来，仿佛天上的星那么众多，海边的沙那么无数。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","他们都死了，但仍然信上帝。虽然他们没有得到上帝承诺的，但仍然在远处寻找并迎接，承认他们在这个世界上就是异族人，只是路人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","说这样话的人，表明他们在寻求一个自己的国家。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","如果他们怀念已经离开了的国家，还有可以回去的机会。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","但是现在他们所向往的，是一个更美、在天上的国家。所以上帝没有对他们失望，并且很高兴被称为他们的上帝，因为他为他们建造了一座城市。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","因为信，亚伯拉罕在受考验的时候，把以撒献上；这接受上帝承诺的人，仍然准备好向上帝献上了自己的独生子； ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","尽管曾有人告诉他：“以撒生的，才可以称为你的后裔。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","亚伯拉罕坚信，上帝可以让以撒死而复生。这件事在某种意义上而言确实成真了，亚伯拉罕的儿子死而复生, 形象地说。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","因为信上帝，以撒对未来将要发生的事情，祝福雅各和以扫。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","因为信上帝，雅各临死的时候，分别为约瑟的儿子祝福，并敬拜上帝，靠着他的杖。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","因为信上帝，约瑟临终的时候，提到以色列子民出埃及的事，并为自己的骸骨留下遗言。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","因为信上帝，摩西出生后，他的父母将他藏了三个月。他们意识到这是一个特殊的孩子，所以不害怕违背国王的命令。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","因为信上帝，摩西长大了以后，拒绝被称为法老女儿的儿子。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","他宁愿选择和上帝的子民一同受苦，也不肯享受罪恶中暂时的快乐。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","在他看来，为基督受的凌辱，比埃及的财富更宝贵，因为他关注未来的赏赐。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","因为信上帝，他离开了埃及，不怕法老的忿怒；他坚定不移，双眼关注的就是看不到的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","因为信上帝，他遵循逾越节和洒血的礼仪，以免毁灭天使触碰以色列人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","因为信上帝，他们走过了红海，好像走过旱地一样；埃及人也试着要过去，就被淹没了。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","因为信上帝，耶利哥的城墙被围绕了七天，就倒塌了。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","因为信上帝，妓女喇合以和平方式迎接以色列的侦察之人，没有和那些不顺从之人一起灭亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","我还要再说什么例子呢？如果再要述说基甸、巴拉、参孙、耶弗他、大卫、撒母耳和众先知的事，时间就不够了。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","他们凭借对上帝的信，战胜了敌国，伸张了正义，得到了上帝承诺，堵住了狮子的口， ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","消灭了烈火的威力，逃脱了刀剑的锋刃，软弱变成刚强，在战争中显出力量，把外国的军队击退。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","妇女死去的家人复活；但也有些人忍受了酷刑，不肯接受释放，为的是要得到更美的复活。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","又有些人遭受了戏弄、鞭打，甚至捆锁、监禁； ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","被石头打死，被切成碎片，被折磨，被刀杀死。他们穿着绵羊山羊的皮到处奔跑、受穷乏、遭患难、被虐待； ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","他们是这世界不配有之人，飘流无定，在荒野、山岭、石洞和地穴栖身。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","所有这些人都因信上帝获得许可，却还没有得着所承诺的一切； ");
INSERT INTO cmnfeb_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","因为上帝已经为我们预备了更美的事，使他们若不跟我们在一起，就不能完全。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","正因如此，既然我们身边有这么多人证明了他们对上帝的信任，让我们摆脱一切阻碍我们的东西，让我们摆脱诱惑的罪恶，让我们继续在眼前的道路上奔跑。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","我们应该继续仰望耶稣，他开始并完成了我们对上帝之信。因着他面前的喜乐，耶稣不顾耻辱背负十字架，最终坐在上帝宝座的右边。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","这位忍受罪人那样顶撞的耶稣，你们要仔细思想，免得疲倦灰心。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","你们与罪恶斗争，还没有对抗到流血的地步； ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","你们可曾忘记上帝好像劝自己孩子的话，说：“我的孩子！不可轻看主的管教，受责备的时候也不要灰心； ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","因为主只管教爱的人，会惩罚他的每一个儿子。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","受到上帝的管教时要有耐心，因为他把你当作他的孩子。哪个孩子没有经历过父亲的管教？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","作儿子的都受过管教。如果你们没有受管教，就是私生子，不是儿子了。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","因为如果我们尊重管教我们的人间父亲，不是更应该接受那引领至生命的灵之父管教吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","他们按自己认为合适的方式管教我们一段时间，但上帝这样做是为了我们的利益，让我们可以分享他的圣洁品格。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","被管教时，所有的纪律似乎都就很痛苦，而不值得高兴。但后来，这些管教让那些经历之人产生平安，这样他们就可以做善事和正确的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","所以，把下垂的手和发软的膝盖挺直起来； ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","要把你们的道路修直，让瘸子不会扭脚，而是得到复原。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","你们要竭力寻求与众人和睦，并且要竭力追求圣洁。如果没有圣洁，谁也不能见主。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","你们要小心，免得有人失去了上帝的恩典；免得苦之因长起来缠绕你们，污染众人； ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","确保没有人像以扫那样淫乱或不信教，为了一顿饭卖掉了与生俱来的权利。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","你们记得，后来以扫想要承受祝福，却被拒绝了；他虽然带着眼泪寻求，还是无法改变他所做的。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","你们还未来到那座可以触摸的、实在的山。那里有烈火、密云、幽暗、暴风、 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","号筒的响声和说话的声音；那些听见这声音的人，都请求上帝不要再向他们多说话； ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","因为他们承受不起那命令：“即使走兽挨近这山，也要用石头把它打死。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","当时显出的景象是那么可怕，连摩西都说：“我非常恐惧战兢。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","但你们却来到锡安山和永恒上帝的城，就是天上的耶路撒冷；在那里有千万的天使聚集， ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","你来到了名字登记在天堂的长子教会，来到了审判所有人的上帝面前，以及那些有着完整生命的良善之人面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","你已经来到建立新约定关系的中间人耶稣面前，还有他所洒的血。这血的意义比亚伯的血更大。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","不要拒绝那说话之人。如果他们因在人间拒绝上帝而无法逃走，可以肯定的是，如果我们背离从天上警告我们的神，我们也逃不掉！ ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","当时上帝的声音震动了大地；现在他承诺说：“我要再一次震动地，还要震动天。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","“再一次”表明那些被震动的一切，就会向被造之物一样被清除，让那些不被震动的一切可以留存， ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","因此，我们既然获得了不能震动的国，就应该感恩，按照让上帝喜悦的方式，用虔诚敬畏的心事奉他； ");
INSERT INTO cmnfeb_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","因为我们的上帝就是毁灭的烈火。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","1","愿兄弟姐妹之间的爱永远保持！ ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_2","088_13_2","HEB","13","2","2","不要忘记对陌生人也表达爱意，因为这样做，有些人就会在不知不觉间迎来了天使。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_3","088_13_3","HEB","13","3","3","记住那些被关在监狱里的人，就像你和他们一起关在里面一样。记住那些被虐待的人，就像你和他们一起遭受肉体的痛苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","人人都应该尊重婚姻，丈夫和妻子应该彼此忠诚。上帝会审判淫乱之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","不要贪钱；满足于自己所拥有的。 上帝自己说过：“我永远不会让你们失望；我永远不会放弃你们。” ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","所以我们可以自信地说：“主来帮助我，我决不害怕，别人能把我怎么样呢？” ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","记住那些向你解释上帝之道的领导者。再看看他们生命得到了，要效法他们对上帝的信任。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","耶稣基督昨天、今天、一直到永远都是一样的。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","不要被各种奇怪教义分心。心要被恩典说服，这样才是好的，不要被那些告诉我们吃什么的律法说服。遵守这些法律之人，不会得到任何好处。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","我们有一座祭坛，坛上的祭物，礼拜堂中的祭祀没有权利食用。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","那些祭牲的血，由大祭司带进圣幕进行赎罪献祭，祭牲的身体却要在营地外焚烧。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","耶稣同样也死在城门外，用自己的血让上帝的子民成变得圣洁。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","那么，让我们也出到城外他那里去，受他曾受过的凌辱。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","因为在这里我们没有永远的城，我们却是寻求那将要来的城。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","所以我们常常要借着耶稣，把颂赞的祭品献给上帝，这意味着说上帝的善语，宣扬他的品格。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","别忘记行善，与其他人分享你拥有的，因为这样的献祭会让上帝喜悦。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","遵从你的领导，按照他们的吩咐去做，因为他们关心你并为你负责。通过这种方式行事，让他们可以快乐——而不是悲伤地做这件事，因为这对你没有帮助！ ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","请为我们祷告，因为我们深信自己良心无愧，愿意凡事遵行正道。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","我真的希望你们为我们努力祷告，好使我们能够尽快看到你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","那赐平安的上帝，是他用永恒约定的血让我们的伟大牧羊人、主耶稣死而复生。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","愿上帝为你们带来一切美好的东西，让你们可以遵行他的旨意。愿他与我们同在，通过耶稣基督，一起做他喜欢的一切，愿荣耀归于他，直到永远。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","兄弟姐妹们，建议你们关注我在这封短信中所说的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","你们要知道，我们的兄弟提摩太已经释放了；如果他来得早，我就跟他一起去看你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","请问候你们的所有领导和所有信徒。在意大利的信徒来也问候你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","愿恩惠与你们同在。阿门。");
INSERT INTO cmnfeb_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","这封信来自上帝和主耶稣基督的仆人雅各，写给散落在各国的十二支派。在此向你们问候！ ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","我的朋友们，当你们遭遇各种困难时，请选择保持欢喜； ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","因为你们知道，这些都是挑战你对上帝的信心，这个过程会产生忍耐。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","希望你们的忍耐尽可能强大，让你们可以彻底成熟，没有任何匮乏。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","你们如有人需要智慧，就询问上帝，他慷慨厚赐众人，从无保留。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","但要凭着对他的信念祈求他，不要有疑惑。疑惑之人，正如被风吹拂翻腾的碎浪。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","那样的人别想从主那里获得什么—— ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","因为这样三心两意之人，在所有道路上都会摇摆不定。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","出身贫穷的信徒，应当以赐予他们的高位为荣； ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","富足之人也不应该以谦卑之位为辱；因为他们会向田野中的花，必会枯萎。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","太阳出来，热风一吹，草就会枯干，花必凋谢，它的美也会消散；富足之人也会以同样方式失去所获得的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","能忍受磨炼之人是有福的；因为在证明其值得信赖后，他们必会获得生命的王冠，这是主向爱他之人做出的承诺。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","一个人在被试探时不可说“上帝在试探我”；因为上帝无法被恶试探，他也不会试探任何人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","这试探来自我们自己的邪恶欲望，它让我们迷失，给我们设下陷阱。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","这样的欲望会生出罪；罪成长后就成为死亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","我亲爱的朋友们，不要被欺骗。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","所有的美好、所有完美的礼物，都是来自上面，并从创造太阳、月亮和星星的父那里下，与他们不同的是，他不会改变，他不会动摇或产生阴影。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","他选择通过真理之道给我们新生命，通过这种方式，在他所创造的万物中，我们对他才会如此特别。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","我亲爱的朋友们，请记住，人人都应该快速聆听，但要慢慢地说，慢一点动怒； ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","因为人的愤怒无法体现上帝的良善特征。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","所以要摆脱一切污秽和邪恶，谦卑地接受植入你们心中的道，因为这道能拯救你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","你们的行为应该遵守道的指示，不要只是听，不要自己欺骗自己； ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","如果你只去听道而不践行，就像盯着镜子中自己的脸。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","你看到了自己，但走开后，马上就忘记自己的样子。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","但如果你仔细研究那让人自由的完美律法，遵守它，不像有些人那样只是听听，然后就忘记了，而是要在行动中遵守它，这样你就会因自己的行为而受到祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","如果你认为自己很虔诚，却不约束自己的语言，就是自己欺骗自己，你的虔诚毫无用处。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","在我们的天父上帝眼中，纯洁而真诚的虔诚，就像去造访患难中的孤儿寡妇，要保护自己不被世俗所污染。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","我的朋友们，作为一名信徒，相信我们荣耀的主耶稣基督，就不应该以貌取人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","如果某人手戴金戒指、身穿华服走进你们的会堂；然后一个衣衫褴褛的穷人也走进去了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","如果你特别关注华服之人，说：“请坐上座。”然后对穷人说：“你站在那里。”或说：“坐在我的脚下方的地上。” ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","你不是再用恶意歧视和判断别人吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","我亲爱的朋友们，听我说：上帝不是选择了那些在世上被视为贫穷的人吗继承上帝承诺赐给爱他之人的天国？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","但你们却侮辱穷人。那些欺压你们、拉你们上法庭的难道不是富人吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","难道不是他们亵渎那个人的荣耀名字吗？是那个人向你们发出召唤，你们也属于他。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","如果你们遵守经书的尊贵法律：“要爱邻如己”，你们就做对了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","如果你们显示出偏向之心，那就是犯罪，律法就会裁定你们犯法。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","如果一个人遵守了律法的所有要求，但却违背了其中一条，就等于违反所有律法。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","上帝告诉你们不可奸淫，也告诉你们不可杀人；如果你不奸淫但却杀人，那就还是犯法。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","你们的语言和行为，应该像那些受自由律法审判之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","任何人如果没有怜悯之心，审判他的时候也就不会有怜悯；但怜悯胜过审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","我的朋友们，如果一个人说他有信心，却没有行动，有什么益处呢？这“信心”能救他吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","如果你的兄弟姐妹缺衣少食， ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","你对他们说：“祝福你们！愿你们吃得饱穿得暖！”，但却不给他们活下去所需要的，那有什么用处呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","如果你事实上没有做良善正确的事情，你对上帝信的本身也是死的，毫无价值的。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","有人会驳斥：“你有对上帝的信心，我做我的善行。”那么，请显示你对上帝有信心却没有善行，我会借着我的善行，将我的信心显示给你看。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","你相信只有一个上帝？非常好，但魔鬼也相信上帝，但他们却害怕上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","愚昧的人哪！你难道不知道，相信上帝却不做正义良善之事，并没有什么用处吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","我们的祖先亚伯拉罕将其子以撒献在祭坛上，不是因其行为而被视为正确吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","你看，他对上帝的信心与他的行为一致，他的信心因其行为而变得完整。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","正如经文所说：“亚伯拉罕相信上帝，这被视为他做出正义良善之事。”他也被称为上帝的朋友。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","因此一个人被称为正直良善，是因其行为，而非单纯因为对上帝的信。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","同样，妓女喇合照顾信使，从另一条路把他们送走，她难道不会因这一行为而被称为正义良善吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","身体没有灵即死；同样，信心没有行为也为死。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","我的朋友们，你们中不应有太多人去传授，因为你们知道，我们是谁做教师的人在审判的时候会承担更沉重的责任。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","我们在许多的事上都有过错，如有人在言语上没有过错，他就是真正的好人，也能够控制其整个身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","我们把嚼环放入马嘴，让它们驯服，借此驾驭它们的整个身体。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","再看看船，船只虽然很大，又会受到狂风摧残，但舵手只用小小的舵，就可以随意操纵船身。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","同理，舌头虽然只是身体的一个小器官，却会说出夸大之语。想想一个小小的火种，就可以烧毁整个森林； ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","舌头就是火！在身体的各个器官中，舌头就是那邪恶世界，它会让你整个人蒙羞，烧毁你整个生命，因为那是被哥和拿之火所点燃。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","人类可以驯服所有飞禽走兽、爬行动物和水生物， ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","但没有人能够驯服舌头；它是难以控制的恶物，充满了致命毒素。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","我们用它赞美我们的主和天父，也用它来咒诅按上帝形象造出的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","同一张嘴，又称颂主，又咒诅人，我的朋友们，这不应该！ ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","一个泉眼中能同时涌出甜水和苦水吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","我的朋友们，无花果树能结橄榄吗？葡萄树能长无花果吗？咸水也不能生出甜水！ ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","你们中间如有人有智慧、有见识，让他们用美好的生活展示自己的行为，用智慧的善良和周全的考量，做正义良善之事。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","如果你们心中有刻薄的嫉妒，还有自私的野心，就不能对其夸口，不可用说谎反对真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","这种“智慧”并非来自天上，而是人间的、非灵性的、恶魔的“智慧。” ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","凡有嫉妒和自私的地方，就必有纷扰和各种恶行。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","但来自天上的智慧，首先是纯洁的，可带来和平。它善良，接受合理的想法，里面满是恩慈和善果，真实而没有虚伪。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","那些种下和平之人，其真正的正直良善，也将让他收获和平果实。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","你们之间的争斗和吵闹从何而来？难道不是来自你们身体中彼此对抗的情感欲望吗？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","你们在欲望中燃烧，但却得不到想要的。为了追逐欲望，你们会杀人，但却无法得到自己所追求的。你们吵闹争斗，但什么都得不到，因为你们并没有为之祈祷； ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","你们祈祷了，但却什么也没得到。那是因为你们的动机错误，你们想要的，就是把所得的一切用于满足自己的私欲。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","淫乱的人哪！你们难道没意识到，与世俗为友就是与上帝为敌吗？与世俗为友之人，就成了上帝的敌人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","难道你不记得经文中说：“上帝放在我们身体中的灵，非常善妒”？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","但上帝给我们的恩典更大；所以经文说：“上帝抵挡骄傲之人，赐予谦卑之人恩典。” ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","所以请遵循上帝的指引，抵抗魔鬼，魔鬼就会从你们这里逃离。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","亲近上帝，上帝就亲近你们。罪人们啊，洗净你们的手；三心两意之人啊，净化你们的思想。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","表达你们的愁苦、悲哀和哭泣，把欢笑变为悲痛，把快乐变为忧愁。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","你们在主面前务必要谦卑，他就会让你们高升。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","朋友们，不要互相毁谤；一个人如果批判其他信徒，谴责他们，就等于批判和谴责律法。如果你批判律法，就不会遵守律法，因为你扮演了审判律法的角色。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","只有一个立法者和审判者——那就是可以拯救、也可以毁灭你的上帝。那么你审判邻居，你认为自己是谁？ ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","你们会说：“今天或明天，我们要到某个城市去，在那里住一年，做生意赚钱。” ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","其实你们并不知道明天会怎样。你们的生命像什么？它只是一团雾，出现一小会儿，然后就不见了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","你们倒不如说：“如果主愿意，我们就可以这样活着，计划做什么事。” ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","但现在你们竟然张狂自夸；这种自夸是邪恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","因为如果你明知道该行善，却没有这么做，就是你的罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","你们富人哪！你们应为将降临你们头上的灾祸哭泣哀号。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","你们的财富会腐朽，你们的衣服会被虫蛀。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","你们的金银会生锈，这腐蚀将成为控告你们的铁证，像火一样吞噬你们的肉体。你们竟然在这末日积敛财富。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","看哪，你们竟然克扣其工钱的农场工人，正在控诉你们；我们的万军之主已经听到了工人们的哭诉。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","你们在世上尽情享受奢华的生活，将自己变得肥胖，不过是等待屠宰之日的到来。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","你们把无辜之人定罪杀害，他们没有反抗。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","朋友们，耐心一些至主回归。想想农夫如何耐心等待田地中宝贵的收成，等着它们在秋霖春雨中生长。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","你们也应当忍耐，保持坚定，因为主回归不远了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","我的朋友们，不要彼此抱怨，免得你们受审判。看哪，审判者已站在门前了。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","朋友们，可以将先知作为一个例子，看看他们在苦难时如何以主之名发言，如何耐心等待。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","请注意，我们会称那些忍耐之人为有福之人。你们听过约伯的忍耐，看见了主赐给他的结果，因为主满心怜悯和仁慈。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","我的朋友们，最要紧的是不可发誓：不可指天发誓，不可指地发誓，不可说出任何誓言。只需在该说是时说是，该说不是时说不是；免得你们受到审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","你们中间有人在受苦吗？你应该祷告。有人心情愉快吗？你应该唱出赞美之歌。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","你们中间有人患病吗？那就请教会的长老来，让他们奉主的名为他抹油祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","这种信上帝的祈祷，可以让病人康复，主必叫他们好起来；如果他们犯了罪，也必蒙赦免。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","所以你们应当向彼此坦诚做过的错事，为彼此起到，这样你们就可以痊愈。过着正直良善生活的诚心之人，他的祈祷非常有效。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","以利亚与我们性情相同；他恳切祈求不要下雨，大地在三年半内就没有雨； ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","他再次祈祷，天就下起雨，大地迎来丰收。 ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","我的朋友们，你们中如有人偏离真理，如果有人带你回头， ");
INSERT INTO cmnfeb_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","让他们知道，凡是把罪人从错误的道路上救出来的，就能把他们从死亡中救出来，并能得到许多罪的赦免。");
INSERT INTO cmnfeb_vpl VALUES ("P11_1","090_1_1","1PE","1","1","1","这封信来自耶稣基督的使徒彼得，写给已被上帝选择之人：那些散落流放在本都、加拉太、加帕多家、亚西亚和庇推尼的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_2","090_1_2","1PE","1","2","2","你们被父上帝以其智慧而选中，是灵让你们圣洁，这样你们就可以听从耶稣基督，被他的血撒过。愿你们拥有更多的恩典与平安！ ");
INSERT INTO cmnfeb_vpl VALUES ("P11_3","090_1_3","1PE","1","3","3","赞美上帝，我们主耶稣基督之父！通过他伟大的怜悯，我们得以重生；借着耶稣基督死而复生我们被赋予永生的希望。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_4","090_1_4","1PE","1","4","4","这传承是永恒的，永远不会朽坏或消失，会为你们在天堂中安全地保留着。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_5","090_1_5","1PE","1","5","5","通过你们对上帝的信任，上帝会用他的能力保护你们，直到救赎到来——那是已经准备好在末日显现的救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_6","090_1_6","1PE","1","6","6","因此，你们要为之欢喜。但你们现今经历各种考验的时候，或许暂时会感到难过。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_7","090_1_7","1PE","1","7","7","这些都证明了你们对上帝的信任是真实的，就像用火来证明是否真金，但即使是金子也可以被摧毁，你们的信比金子更有价值！通过这种方式，你们对上帝的信任就会获得认可，当耶稣基督出现时，你们会得到赞美、光荣和尊崇。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_8","090_1_8","1PE","1","8","8","你们虽然没有见过他，却爱他；现在虽然不能看见他，却信他。所以，你们充满了无法形容、美妙的幸福。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_9","090_1_9","1PE","1","9","9","你们信他的奖励，就是将会得到拯救。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_10","090_1_10","1PE","1","10","10","先知们说道为你们准备的恩典时，他们寻找和研究的也正是这样的救赎。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_11","090_1_11","1PE","1","11","11","他们试图找出救赎将在何时以何种方式发生，因为他们中基督的灵，清楚讲述了基督将要遭受的苦难和获得的荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_12","090_1_12","1PE","1","12","12","他们听到的解释是：他们这样做并非为了自己，而是为了你们。因为他们所讲的，你现在已经从那些通过上天派来的圣灵与你分享好消息的人那里学到了。就连天使也急于知道这一切！ ");
INSERT INTO cmnfeb_vpl VALUES ("P11_13","090_1_13","1PE","1","13","13","你们的思想务必要准备好。保持头脑清醒。把希望完全寄托于你们在耶稣显现时将会获得的恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_14","090_1_14","1PE","1","14","14","像那些按照他们吩咐去做的孩子一样生活。当你不知道何为更好，不要让那时候的罪恶欲望左右你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_15","090_1_15","1PE","1","15","15","现在你们做的每一件事都要是圣洁的，就像那召唤你的人就是圣洁的。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_16","090_1_16","1PE","1","16","16","因为经书说：“你们要圣洁，因为我是圣洁的。” ");
INSERT INTO cmnfeb_vpl VALUES ("P11_17","090_1_17","1PE","1","17","17","既然你们称他为父，意识到他会根据每个人的所作所为公正评判每个人，请认真对待你们在地球上的时间，尊重他。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_18","090_1_18","1PE","1","18","18","你们已经知道，你们并没有摆脱从祖先那里继承的无意义生活方式，这些都是是没有持久价值的东西，比如金银。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_19","090_1_19","1PE","1","19","19","你们因基督宝贵的血而获得自由，他就像一只没有瑕疵或缺陷的羔羊。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_20","090_1_20","1PE","1","20","20","基督是在创世之前被上帝所挑选，却会在这末世为你们的好而显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_21","090_1_21","1PE","1","21","21","通过他，你们信那让基督死而复生并让他荣耀的上帝，这样你们就可以对上帝有信心，有希望。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_22","090_1_22","1PE","1","22","22","既然你们已经按照真理奉献了自己，那就像真正的家人一样真诚地相爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_23","090_1_23","1PE","1","23","23","你已经重生了，不是必死的 “种子” 的产物，而是不死的种子，通过神的活的、永恒的话语 ");
INSERT INTO cmnfeb_vpl VALUES ("P11_24","090_1_24","1PE","1","24","24","因为：“所有人皆如草，他们的荣光如野花；草必枯干，花必凋谢， ");
INSERT INTO cmnfeb_vpl VALUES ("P11_25","090_1_25","1PE","1","25","25","但只有主的道，永远长存。”这就是向你们解释的福音。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_1","090_2_1","1PE","2","1","1","所以要放弃你们做的所有邪恶之事：所有的不诚实、虚伪和嫉妒，所有你们诽谤别人的方式。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_2","090_2_2","1PE","2","2","2","你们应该变得像那只需要纯净灵奶的新生婴儿，这样才能在救赎中成长， ");
INSERT INTO cmnfeb_vpl VALUES ("P12_3","090_2_3","1PE","2","3","3","现在你们已经品尝到了主是多么的良善。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_4","090_2_4","1PE","2","4","4","因为你们来到他面前——他是曾被人们拒绝、视为无用的活石，但被上帝所选和珍视。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_5","090_2_5","1PE","2","5","5","你们也要变得像活石一样，被建造成一座灵的家。你们是神圣的祭司，通过耶稣基督向上帝献上他喜欢的灵之献祭。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_6","090_2_6","1PE","2","6","6","因为经书上说：“看哪！我在锡安放了一块特别选择、价值非凡的主基石。信他的人必不会失望。” ");
INSERT INTO cmnfeb_vpl VALUES ("P12_7","090_2_7","1PE","2","7","7","他对真信的你很有价值。但对于那些不信的人来说，“建造者拒绝的石头成为主要的基石”， ");
INSERT INTO cmnfeb_vpl VALUES ("P12_8","090_2_8","1PE","2","8","8","还说这是“绊倒你的石头和让你跌倒的石头。”人们因为拒绝接受这条信息而走得跌跌撞撞——这对他们来说，是完全可以预见的。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_9","090_2_9","1PE","2","9","9","恰恰相反，你们是一个特别选中的家庭，拥有皇家祭司的身份，是一个圣洁的国家，是属于上帝的子民。因此，你们可以显现上帝做过的神奇之事，将你们从黑暗中召唤到他神奇的光之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_10","090_2_10","1PE","2","10","10","过去你们是无名之辈，但现在你们是上帝的子民。过去你们未曾获得怜悯，但现在你们获得了怜悯。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_11","090_2_11","1PE","2","11","11","我的朋友们，作为这个世界上的外族人和陌生人，我恳求你们不要屈服于那与灵冲突的物质欲望。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_12","090_2_12","1PE","2","12","12","当你们与非基督徒在一起时，一定行动恰当。只有这样，即使他们指责你做错了，他们也会看到你所做的好事，在上帝来临时荣耀上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_13","090_2_13","1PE","2","13","13","你们为了主而顺从人的权威，无论是最高权威的君王， ");
INSERT INTO cmnfeb_vpl VALUES ("P12_14","090_2_14","1PE","2","14","14","还是上帝任命去惩罚罪恶之人，表扬善良的官员。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_15","090_2_15","1PE","2","15","15","通过做良善正确之事，上帝希望你们让那做出无知指控的愚昧之人闭嘴。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_16","090_2_16","1PE","2","16","16","是的，你们是自由的人，但不要用自由掩饰邪恶，要像上帝的仆人一样生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_17","090_2_17","1PE","2","17","17","要尊重众人，向信徒社区表达你的爱，要尊重上帝，尊敬君王。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_18","090_2_18","1PE","2","18","18","如果你是仆人，就要听从你的主人——不仅听从那良善的好主人，也要听从那些严厉的主人。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_19","090_2_19","1PE","2","19","19","因为这就是恩典：忍受生活的痛苦以及不公平带来的苦难，只关注上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_20","090_2_20","1PE","2","20","20","但是，如果你是因为做错事而受到惩罚，就没有任何功劳。如果你是做善事和正确的事而受苦，你忍受了它，那么上帝的恩典就与你同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_21","090_2_21","1PE","2","21","21","事实上，这是你被召唤要做的，因为基督为你们受苦，给你们竖立榜样，所以你们应该追随他的脚步。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_22","090_2_22","1PE","2","22","22","他从不犯罪，从不撒谎； ");
INSERT INTO cmnfeb_vpl VALUES ("P12_23","090_2_23","1PE","2","23","23","当他受到虐待时，没有反击。当他受苦时，并没有威胁要报复。他只是将自己放在那总能正确判断之人的手中。 ");
INSERT INTO cmnfeb_vpl VALUES ("P12_24","090_2_24","1PE","2","24","24","他在十字架上，以自己的身体承担了我们罪的后果，以便让我们对于罪而言已经死了，可以良善公正地活着。“因着他的伤，你们得到治愈。” ");
INSERT INTO cmnfeb_vpl VALUES ("P12_25","090_2_25","1PE","2","25","25","你们过去就像迷路的羊，但现在已经回到看官你们的牧人那里了。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_1","090_3_1","1PE","3","1","1","妻子们，你们要以同样的方式接受丈夫的权威，只有这样，如果有些丈夫拒绝接受这个词，你仍然可以用无言的行为说服他们， ");
INSERT INTO cmnfeb_vpl VALUES ("P13_2","090_3_2","1PE","3","2","2","让他们承认你的纯洁和虔诚行为。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_3","090_3_3","1PE","3","3","3","不要专注于外在的吸引力，比如发型、黄金首饰或时髦的衣服。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_4","090_3_4","1PE","3","4","4","要让你的吸引力来自内心，内在的温柔和平精神，具有持久吸引力。这也是上帝所看重的。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_5","090_3_5","1PE","3","5","5","过去信上帝的圣洁女性，就是通过这种方式让自己变得美丽，顺服丈夫 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_6","090_3_6","1PE","3","6","6","就像撒拉顺从亚伯拉罕，称他为“主。”如果你做正确的事而没有被吓倒，你就是她的女儿。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_7","090_3_7","1PE","3","7","7","丈夫们，同样当你和妻子生活在一起，要去体谅她们。虽然她可能没有你那么强有力，但应该尊重她，因为她将与你平等地继承上帝赐予的生命。一定要这样做，这样你在祈祷的时候就不会受到妨碍。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_8","090_3_8","1PE","3","8","8","最后，你们应该有同样的态度。要有同理心，彼此相爱。要有同情心，要谦虚。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_9","090_3_9","1PE","3","9","9","不要以恶报恶，也不要在被虐待时反击，而是应该祝福——因为这就是你蒙受召唤要做的，所以你可以自己得到祝福。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_10","090_3_10","1PE","3","10","10","记住：“那些希望热爱生命之人，想要看见好日子的人，就必须禁止说出恶语，不能说谎； ");
INSERT INTO cmnfeb_vpl VALUES ("P13_11","090_3_11","1PE","3","11","11","要远离邪恶，要做善事，寻找并追求和平。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_12","090_3_12","1PE","3","12","12","因为主只会看到那些正确做事的人，他的耳朵会听到他们的祈祷；但主会反对那些作恶之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("P13_13","090_3_13","1PE","3","13","13","如果你们热心行善，谁能伤害你们呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("P13_14","090_3_14","1PE","3","14","14","就算你们因做了正确之事而受苦，也是有福的。不要害怕别人的威胁，不要畏惧。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_15","090_3_15","1PE","3","15","15","你们的思想要专注于基督主。随时准备好，如果有人向你询问你所拥有的的希望，要向他们解释，以温和尊重的方式解释。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_16","090_3_16","1PE","3","16","16","你的良心务必要是清白的，这样如果有人指控你，就会感到尴尬，因为他们诽谤你在基督那里过着的好生活。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_17","090_3_17","1PE","3","17","17","因行善而受苦（如果这是上帝想要的）肯定比因做错而受苦更好！ ");
INSERT INTO cmnfeb_vpl VALUES ("P13_18","090_3_18","1PE","3","18","18","耶稣一次性地为罪而死，那完全真实的、良善的和正确的人，为那些坏人而死，这样他就可以把你带到上帝面前。他的身体被杀害了，但他却以灵死而复生。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_19","090_3_19","1PE","3","19","19","他去和那些 “被囚禁” 的人谈话 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_20","090_3_20","1PE","3","20","20","当上帝在诺亚时代耐心地等待着建造方舟的时候，那些拒绝相信的人。只有少数人--事实上是八个人-“通过水” 得救。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_21","090_3_21","1PE","3","21","21","现在正拯救你的洗礼，就是这水的象征。并非通过洗掉你身上的污垢，而是来自无愧的良心，是对上帝的积极回应。耶稣基督的复活，让你的救赎成为可能。 ");
INSERT INTO cmnfeb_vpl VALUES ("P13_22","090_3_22","1PE","3","22","22","基督升到天上后，站在上帝的右手边，天使、有权势之人和有能力之人，都服从他。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_1","090_4_1","1PE","4","1","1","既然基督身体受苦，你们必须用和他同样的态度，自己做好准备——因为那些肉体上受苦之人已经远离了罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_2","090_4_2","1PE","4","2","2","你不会凭着人的欲望度过余生，而是去做上帝想让你做的事。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_3","090_4_3","1PE","4","3","3","过去你已经用足够的时间追随世俗：不道德、性放纵、醉酒狂欢、聚会、酗酒和令人反感的偶像崇拜。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_4","090_4_4","1PE","4","4","4","你如果不加入他们野蛮而过分的生活方式，他们就会感到很奇怪，就会诅咒你。但以后，他们必须向那准备审判生者和死者的人，解释他们都做了什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_5","090_4_5","1PE","4","5","5","这就是为什么要把福音传给那些已经死去之人—— ");
INSERT INTO cmnfeb_vpl VALUES ("P14_6","090_4_6","1PE","4","6","6","这样虽然他们作为有罪之人受到正确的审判，但对上帝而言，他们可以活在灵中。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_7","090_4_7","1PE","4","7","7","一切即将结束！因此当你祈祷时，要清楚地思考并保持警觉。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_8","090_4_8","1PE","4","8","8","最重要的是，你们应该深深地爱着彼此，因为爱可以包容人们所做的许多错误之事。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_9","090_4_9","1PE","4","9","9","彼此热情对待，不要抱怨。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_10","090_4_10","1PE","4","10","10","无论你获得了什么礼物，都要与你们中的其他人分享，因为你明智地用各种不同的方式展示上帝的恩典。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_11","090_4_11","1PE","4","11","11","任何说话之人都应该这样做，就好像上帝正在通过他们说话一样。任何想帮助他人之人，都应该通过上帝赐予的力量帮助他人，这样就可以让上帝在每一件事上，都可以通过耶稣基督得到荣耀。愿荣耀和力量永永远远属于他。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_12","090_4_12","1PE","4","12","12","我的朋友们，不要对你正经历的“火的考验”感到惊慌，好像这考验乃意料之外。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_13","090_4_13","1PE","4","13","13","要快乐地分担基督的苦难，因为当他出现在其荣耀之中，你就会极其幸福！ ");
INSERT INTO cmnfeb_vpl VALUES ("P14_14","090_4_14","1PE","4","14","14","如果你因基督的名而受到咒诅，你就是被祝福的，因为上帝的荣耀之灵就在你身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("P14_15","090_4_15","1PE","4","15","15","如果你受苦，不应该是作为杀人犯、小偷、罪犯或说出流言蜚语而受苦， ");
INSERT INTO cmnfeb_vpl VALUES ("P14_16","090_4_16","1PE","4","16","16","而是应该是因为你是基督徒，所以你就不必感到羞耻。相反，要赞美神，因为你被这个名字所呼唤！ ");
INSERT INTO cmnfeb_vpl VALUES ("P14_17","090_4_17","1PE","4","17","17","因为当审判到来之际，就是先从上帝的家开始。如果从我们这里开始，拒绝上帝福音之人会有怎样的结局？ ");
INSERT INTO cmnfeb_vpl VALUES ("P14_18","090_4_18","1PE","4","18","18","“如果那些良善正直之人很难得救，反对上帝的罪人又会怎样？” ");
INSERT INTO cmnfeb_vpl VALUES ("P14_19","090_4_19","1PE","4","19","19","上帝是值得信赖的造物者，根据上帝的意愿受苦之人，应该确保自己做善事。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_1","090_5_1","1PE","5","1","1","我想鼓励你们中的长老们。我也是一名长老，是基督受难的见证人，那即将到来的荣耀将有我的一份。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_2","090_5_2","1PE","5","2","2","看好上帝赐予你、让你照顾的羊群，不是因为你被迫这样做，而是因为高兴，因为上帝希望你这样做。你要心甘情愿地这样做，而不是想从中获利。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_3","090_5_3","1PE","5","3","3","不要狂妄自大，凌驾于被你照顾之人之上，而是要成为羊群的榜样。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_4","090_5_4","1PE","5","4","4","当牧长显现之时，你将获得永不衰败的荣耀冠冕。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_5","090_5_5","1PE","5","5","5","年轻人，按照长老的吩咐去做。事实上，你们所有人都应该谦卑地为彼此服务，因为“上帝反对骄傲之人，偏爱谦卑之人。” ");
INSERT INTO cmnfeb_vpl VALUES ("P15_6","090_5_6","1PE","5","6","6","在上帝强大的手面前要谦卑，这样他就会在适当的时候把你举起来。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_7","090_5_7","1PE","5","7","7","把你所有的忧愁都交给他，因为他在乎你。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_8","090_5_8","1PE","5","8","8","要负责任，保持警惕。魔鬼是你的敌人，像咆哮的狮子一样四处游荡，寻找可以吞噬之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_9","090_5_9","1PE","5","9","9","要坚定地反对他，相信上帝。记住，世界各地其他和你一样的信徒，也正在经历类似的问题。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_10","090_5_10","1PE","5","10","10","你受苦一小段时间之后，那所有恩典的上帝，那曾召唤你、让你与基督一样走进其永恒荣耀的上帝，就会亲自将你恢复，支持你，给你力量，并给你一个坚实的基础。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_11","090_5_11","1PE","5","11","11","愿力量永永远远属于他！阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_12","090_5_12","1PE","5","12","12","我是在西尔瓦努斯的帮助下，将这封信寄给你们，他是我值得信赖的兄弟。通过我所写的这些文字，我想鼓励你们并见证这是上帝真正的恩典。要坚定地站在上帝的恩典中！ ");
INSERT INTO cmnfeb_vpl VALUES ("P15_13","090_5_13","1PE","5","13","13","在 “巴比伦”这里的信徒，和你一起被选中，向你问候，就像我的儿子马可一样。还有我的儿子马克也问候你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("P15_14","090_5_14","1PE","5","14","14","以爱的吻互相问候。愿你们所有与基督同在之人都能够平安。");
INSERT INTO cmnfeb_vpl VALUES ("P21_1","091_1_1","2PE","1","1","1","这封信函来自耶稣基督的仆人和使徒西门·彼得，写给与我们一样，对我们的上帝和救主耶稣基督有着无价信任、真正是良善正义之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_2","091_1_2","2PE","1","2","2","你们在上帝和我们的主耶稣的知识中成长过程中，愿你们获得更多恩典和平安。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_3","091_1_3","2PE","1","3","3","通过他的神圣力量，我们已获得重要的一切，过上以上帝为中心的生活。这是因为认识他，他以自己的荣耀和善良召唤我们。 通过这种方式，他为我们提供了神奇而无价的承诺。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_4","091_1_4","2PE","1","4","4","通过这些承诺，你可以分享这神圣的天性，摆脱这个世界邪恶欲望所产生的腐朽。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_5","091_1_5","2PE","1","5","5","正是因为这缘故，要尽你所能！你的善行加上你对上帝和信；你的知识加上你的善行； ");
INSERT INTO cmnfeb_vpl VALUES ("P21_6","091_1_6","2PE","1","6","6","你的自控能力加上你的知识；你的自控能力加上耐心；你的耐心加上敬畏； ");
INSERT INTO cmnfeb_vpl VALUES ("P21_7","091_1_7","2PE","1","7","7","你的敬畏会带来对信徒的爱；对信徒的爱，会带来爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_8","091_1_8","2PE","1","8","8","你越多地具备这样的品质，那么在认识我们的主耶稣基督时，他们就更不容易变得没有效果和毫无效率。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_9","091_1_9","2PE","1","9","9","因为没有这些品质的人，往往都目光短浅或非常盲目。他们忘记自己已经从过去的罪孽中被洗净。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_10","091_1_10","2PE","1","10","10","所以兄弟姐妹们，要更坚定地让自己真正“被召唤和被挑选。”你这样做就永远不会坠落。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_11","091_1_11","2PE","1","11","11","你将受到热烈欢迎，进入我们主和救世主耶稣基督的永恒国度。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_12","091_1_12","2PE","1","12","12","所以我总是提醒你们这些事情，即使你们已经了然并且坚持你所拥有的真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_13","091_1_13","2PE","1","13","13","但我仍然认为，趁我在世之时，通过提醒你们来鼓励你们，这是个好主意。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_14","091_1_14","2PE","1","14","14","我知道，我离开今生之日已经不远——我们的主耶稣基督已向我表明这一点。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_15","091_1_15","2PE","1","15","15","我会尽其所能，在我离开之后，你们还能时常回忆起这些事。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_16","091_1_16","2PE","1","16","16","当我们对你们说：我们主耶稣基督的大能即将到来，我们所说的并非虚构的神话，我们曾亲眼目睹他的威严。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_17","091_1_17","2PE","1","17","17","如果听到那庄严荣耀的声音说：“这是我的爱子，是真正令我喜悦的”，就代表从天父上帝那里获得威严荣耀。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_18","091_1_18","2PE","1","18","18","当我们在圣山与他一起时，亲耳听到从天上传来的这个声音。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_19","091_1_19","2PE","1","19","19","我们还有先知的确凿之语，绝对值得信赖，关注它一定会让你受益。它就像一盏灯，照亮黑暗之地，直到天亮；就像晨星，它的光照亮你的思想。 ");
INSERT INTO cmnfeb_vpl VALUES ("P21_20","091_1_20","2PE","1","20","20","最重要的是，你应该意识到，圣经中的任何预言都不能由个人的一时兴起来解释， ");
INSERT INTO cmnfeb_vpl VALUES ("P21_21","091_1_21","2PE","1","21","21","因为预言并非起源于人类，而是先知在圣灵的感应下，代表上帝说话。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_1","091_2_1","2PE","2","1","1","但正如那时在民众中会有假先知，你们中间也会有假教师。他们巧妙地讲述具有破坏性的虚假教义，甚至否认救赎他们的主，这会让他们自己迅速毁灭。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_2","091_2_2","2PE","2","2","2","许多人会追随他们不道德的错误行为；因为他们，人们会谴责真理之路。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_3","091_2_3","2PE","2","3","3","他们会贪婪地用虚假故事剥削你。但他们已被谴责：他们的审判已悬在其头上良久，他们的毁灭不会推迟。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_4","091_2_4","2PE","2","4","4","因为即使是天使犯罪，上帝也没有放过他们。他把它们扔进塔耳塔洛斯，关在黑坑之中，等待审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_5","091_2_5","2PE","2","5","5","上帝也没有放过远古世界，但他保护了诺亚，诺亚向人们讲述了那做出良善正直之事的上帝。当上帝向邪恶的世界发出洪水时，共救出八人，诺亚就是其中之一。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_6","091_2_6","2PE","2","6","6","上帝惩罚所多玛和蛾摩拉的城市，将其彻底毁灭，烧成灰烬。对于那些过着邪恶生活之人，这就是他们即将发生之事的例子。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_7","091_2_7","2PE","2","7","7","但上帝救了罗得，这个好人深深厌恶邻居们令人作呕的不道德行为。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_8","091_2_8","2PE","2","8","8","（罗得和他们住在一起，但他却做出良善正确的事。他目睹和听说了那些人日复一日的所作所为，他们的邪恶让他备受折磨。） ");
INSERT INTO cmnfeb_vpl VALUES ("P22_9","091_2_9","2PE","2","9","9","正如你看到的，对于尊重主的人，主能拯救他们于苦难；对于恶人，主会留着他们，直到他们的惩罚完毕时的审判日。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_10","091_2_10","2PE","2","10","10","对于那些追随腐败人类欲望、蔑视权威的人来说，尤其如此。他们狂妄自大，甚至不怕诋毁天人。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_11","091_2_11","2PE","2","11","11","即使那更强大、更有能力的天使，也不会在主面前贬低那些傲慢之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_12","091_2_12","2PE","2","12","12","这些人就像没有头脑的野兽，就像农场动物一样出生、被抓获和屠宰。他们会指责其一无所知的事情，会像动物一样被摧毁。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_13","091_2_13","2PE","2","13","13","他们将因其造成的伤害而受到伤害。他们的乐趣，就是在光天化日追寻其邪恶的欲望。他们就是你所在社区的污点和瑕疵。即使他们和你一起吃饭，也喜欢骗人并以此为乐。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_14","091_2_14","2PE","2","14","14","他们总是想要犯下淫荡之举——他们就是无法停止自己的罪。他们引诱脆弱之人，在贪婪中训练自己；他们是受诅咒的后代。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_15","091_2_15","2PE","2","15","15","他们偏离正道而误入歧途，追随比珥的儿子巴兰的道路。这个巴兰喜欢做恶事并获得酬劳。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_16","091_2_16","2PE","2","16","16","但他的恶行受到了斥责——一头哑巴驴子用人声说话，阻止了先知的愚蠢之举！ ");
INSERT INTO cmnfeb_vpl VALUES ("P22_17","091_2_17","2PE","2","17","17","这样的人如同无水之泉，如被风吹散的雾霭。他们注定要永恒进入最黑的黑暗。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_18","091_2_18","2PE","2","18","18","他们喜欢胡说八道，渴望满足感官的欲望，将那些刚刚脱离错误生活之人，重新带回不道德的行列。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_19","091_2_19","2PE","2","19","19","他们对那些人承诺自由，但其实他们自己就是堕落的奴隶。“你是那征服你之人的奴隶。” ");
INSERT INTO cmnfeb_vpl VALUES ("P22_20","091_2_20","2PE","2","20","20","你若因认识主和救世主耶稣基督，得以摆脱世间的邪恶影响，但又陷入罪中而被其打败，你的境遇就会比当初更糟糕。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_21","091_2_21","2PE","2","21","21","宁愿原本就不知道何为真理之道，也不要在知道后又背弃它们给予你的神圣指示。 ");
INSERT INTO cmnfeb_vpl VALUES ("P22_22","091_2_22","2PE","2","22","22","对你而言，那句谚语应验：“狗又吐了，洗过的猪又在泥里打滚了。” ");
INSERT INTO cmnfeb_vpl VALUES ("P23_1","091_3_1","2PE","3","1","1","朋友们，这是我写给你们的第二封信。在这两封信中，我都在试图激发你们，提醒你们用纯净的思想进行清晰的思考。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_2","091_3_2","2PE","3","2","2","记住以往圣先知们说的话，以及主和救世主通过你们的使徒做出的嘱咐。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_3","091_3_3","2PE","3","3","3","首先应该要知道：在末世必有讥讽之人，他们充满嘲讽之心，追随自己的邪恶欲望。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_4","091_3_4","2PE","3","4","4","“那么他要降临的承诺哪去了？”他们问。“从我们祖先去世的那一刻，一切都像从创世之日开始往常一样继续。” ");
INSERT INTO cmnfeb_vpl VALUES ("P23_5","091_3_5","2PE","3","5","5","但是他们故意忽略一个事实：天空是上帝下令在很久以前创造的。大地诞生于水，被水包围。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_6","091_3_6","2PE","3","6","6","水摧毁了当时存在的世界，那个世界被水淹没。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_7","091_3_7","2PE","3","7","7","但是通过同样的神圣命令，眼前存在的天地被保留下来，留待审判之日被火毁灭，那时恶人也会被毁灭。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_8","091_3_8","2PE","3","8","8","但我的朋友们，别忘记：对主而言一天就像一千年，一千年就像一天。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_9","091_3_9","2PE","3","9","9","主并没有像某些人以为的那样，将其承诺拖后，而是对你们非常耐心。他不希望任何人迷失，而是希望每个人都过来，都悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_10","091_3_10","2PE","3","10","10","但主的日子终将到来，就像盗贼一样出乎意料。天堂将在雷鸣般的轰鸣中爆炸，所有元素将被焚烧和毁灭。地球和大地上的一切都将消失。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_11","091_3_11","2PE","3","11","11","既然一切都将如此毁灭，你应该是哪种人？你应该过着纯洁的生活，献身于上帝， ");
INSERT INTO cmnfeb_vpl VALUES ("P23_12","091_3_12","2PE","3","12","12","期待并渴望上帝之日的到来。在那一天，天空会燃起大火并被毁灭，所有元素都会在高温中融化。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_13","091_3_13","2PE","3","13","13","但对我们而言，我们正在寻找上帝所承诺新天和新地，那里的一切都如此良善正直。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_14","091_3_14","2PE","3","14","14","所以我的朋友们，既然你已经预料到这一切，请确保在看到你时，你是纯洁而无可指责的，与上帝和平相处。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_15","091_3_15","2PE","3","15","15","请记住，是我们主的耐心给了我们救赎的机会。我们亲爱的兄弟保罗在他所有的书信中，曾用上帝赐予他的智慧向你解释了这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_16","091_3_16","2PE","3","16","16","他谈到了这些事情，尽管他所写的部分内容肯定很难理解。一些无知和不平衡之人歪曲他所写的内容，这让他们自己蒙受损失，正如他们歪曲其他经文。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_17","091_3_17","2PE","3","17","17","我的朋友们，既然你们已经知道了这些，就不要让恶人的错误引你们误入歧途，不要从自己牢固的位置上跌落。 ");
INSERT INTO cmnfeb_vpl VALUES ("P23_18","091_3_18","2PE","3","18","18","愿我们的主以及救世主耶稣基督的恩典和知识，愿你们获得成长。愿荣耀归于他，无论现在还是永远！阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","这封信所讲述的，伊始之际便存在的生命之道，我们曾听见、曾亲眼所看见、曾仔细观察、曾亲手触摸。 ");
INSERT INTO cmnfeb_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","这生命已向我们显现；我们曾见过，也曾对其进行见证, 并且向你们讲述过那曾与父同在、曾向我们显现的永恒生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","现在，我们把所见所闻向你们讲述，让你们也可以与我们分享这友谊——这是与父、与父之子耶稣基督的友谊。 ");
INSERT INTO cmnfeb_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","我们之所以写这些事，是为了让我们的幸福更加完整。 ");
INSERT INTO cmnfeb_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","上帝是光，在他那里完全没有黑暗。这就是我们从他那里获得的、现在向你们宣讲的信息。 ");
INSERT INTO cmnfeb_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","如果我们说自己与他享有友谊，但却生活在黑暗里，那就是我们在说谎，并非在实行真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","但如果我们生活在光中，就像他在光中，我们就彼此分享友谊，他儿子耶稣的血就会让我们洁净，脱离所有罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","如果我们说自己没有罪，那是自欺，就不是行真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","但如果我们承认自己的罪，上帝是值得信任的、是正直良善的，必定原谅我们的罪，让我们洁净，让我们脱离所有不义。 ");
INSERT INTO cmnfeb_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","如果我们声称自己没有罪，就是把上帝当作说谎者，他的道就不会在我们之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","我亲爱的孩子们，我写这封信给你们，是为了让你们不犯罪。但如果有人犯了罪，在父面前会有一人保护我们，那就是耶稣基督，他是真正的正直良善。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","通过他，我们的罪得到宽恕——不只是我们的罪，还包括全世界的罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","我们可以确定的是，如果我们遵循他的命令，就认识他。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","凡是说“我认识他”的人，如果不遵守他命令，就是在说谎。就不是遵循真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","但那些遵守上帝之道的人，他的爱便把他们的头脑充满。这样我们就知道，我们便与他同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","那些说自己与他同在的，行为就应该像耶稣基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","我的朋友们，我写给你们这封信，并不是要给出新命令，而是要说到你们从初始之刻就已有的旧命令。这旧命令就是你们听过的道。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","但从某种角度而言，我也在给你们一个新命令。黑暗即将结束，真正的光已在照耀，它的真理已在耶稣和你们身上显现。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","那些说自己身处光明之中、却憎恨其他基督徒的人，他们的内在还有黑暗。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","那些热爱其他基督徒的人，就是生活在光中，就不会让其他人变得有罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","那些憎恨其他基督徒的人，就是身处黑暗之中。他们在黑暗中跌跌撞撞。不知道要去哪里，因为黑暗弄瞎了他的眼睛。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","亲爱的朋友们，我写信给你们这些孩子，因为你们的罪已通过主的名得到赦免。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","我写信给你们这些父亲，因为你们知道自世界之初便已存在的那个人。我写信给青年们，因为你们已战胜了邪恶之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","我写信给你们这些孩子，因为你们认识父。我写信给你们这些父亲，因为你们认识自世界之初就已存在的那个人。我写信你们这些年轻人，因为你们很坚强。上帝之道就在你们之中，你已经打败邪恶之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","不要爱这个世界，不要爱这世上的一切。如果你爱这个世界，你就不会再有父的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","因为这世上的一切——我们的欲望之罪，渴望拥有所看到的一切，吹嘘我们今生所达成的一切，这些都不是出于父，而是出于这个世界。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","这世界和这是世上的邪恶欲望，即将走向尽头，但那遵行上帝之道的，却能永远生存。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","亲爱的朋友们，此刻就是末日。你们已经听到反基督力量的到来，很多反基督的力量已经到来；所以我们才知道，此刻就是末日。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","他们已经离开了我们，他们不再属于我们，当他们离开时，他们所有人就显示出不再属于我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","但你们已在圣灵的祝福中获得膏抹，你们所有人都知道这是真相。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","我写信给你们，不是因为你们不明白真相，而是因为你们知道，因为谎言绝不会出于真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","那么谁是在说谎？—— 就是那否认耶稣是基督的人。否认父和子，就是反基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","否认子，便没有父；承认子，便有父。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","至于你们，务必要始终生活在从最初便听到一切；如果你生活在从最初听见的一切，也就住在父和子之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","他已承诺给我们——永恒的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","我写信给你们这些，是想警醒你们那些想要带你们走入迷途之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","你们从他那里得到膏抹，就意味着圣灵住在你们之中，你们不需要被任何人教导。圣灵的恩膏教导你们一切。这是事实，不是谎言。所以活在基督之中，就像你已受到教导一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","我亲爱的孩子们，你们要住在主之中，以便在他出现时，我们就可以自信，不会在他到来的时候感到惭愧。 ");
INSERT INTO cmnfeb_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","如果你们知道他的良善和正直，就应当知道所有良善正直之人都是上帝所生。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","你们看，父赐给我们的爱是多么惊人！这就是为什么我们可以被称为上帝的孩子——因为我们的确如此！所以这个世界的人没有把我们看作上帝的孩子，是因为他们不认识父。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","我的朋友们，我们已经是上帝的孩子；但我们未来会怎样，还没有显明；我们知道，当他出现的时候，我们一定就会像他，因为我们一定会看见他本来的样子。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","凡对他们心存希望的人，务必要让自己纯粹，就像他一样纯粹。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","凡是有罪的，就是违反了法律，因为罪就是无法无天。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","但你们当然知道，主到来是除掉罪，他自己没有罪。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","凡是住在他里面的，就不会有罪；凡有罪的，就是未曾见过他，也不认识他。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","亲爱的孩子们，不要让任何人欺骗你们，那些遵循正义良善的人，才是正义良善，正如主也是正义良善。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","那些有罪的，都是源自魔鬼，因为魔鬼从最初就有罪。所以上帝之子才会出现，就是为了消灭魔鬼所做的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","所有源自上帝的人就不会有罪，因为上帝的天性就在他们之中；他们不能有罪，因为是上帝生了他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","所以通过这种方式，就可以分辨谁是上帝的孩子，谁是魔鬼的孩子。那些从不做正义良善之事的人，就不属于上帝；不爱其他基督徒的人也是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","你们从最初听见的讯息非常简单：我们应当彼此相爱， ");
INSERT INTO cmnfeb_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","我们不能像该隐那样，他属于邪恶之人，又杀了自己的弟弟。他为什么杀自己的弟弟？因为他做的是罪恶行为，他弟弟做出的是正义良善的行为。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","我的朋友们，如果世界恨你们，不要惊讶。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","我们之所以知道自己从死亡变成生命，是因为我们爱其他基督徒弟兄姐妹。 任何不爱的人仍然是死的。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","那些恨其他基督徒弟兄姐妹的人，就是在杀人。你们知道，杀人之人就不会生活在永恒生命之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","耶稣为我们舍弃自己的生命，我们是通过这种方式知道什么是爱；我们也应当为其他基督徒兄弟姐妹舍弃自己的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","如果你们有人在这世上生活的很富有，看见其他基督徒兄弟姐妹生活穷乏，却从未显示怜悯，又怎能说你心中有上帝的爱呢？ ");
INSERT INTO cmnfeb_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","亲爱的朋友们，不要只是说我们爱，而是要用行动、我们如何展示真理，以此显示我们的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","只有这样，我们才知道自己属于真理。但在上帝面前，我们仍然可以安心， ");
INSERT INTO cmnfeb_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","无论何时我们认为自己做错了，因为他比我们想的还要伟大，他知道一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","我亲爱的朋友，如果我们因为没有做错事而感到有信心，我们在上帝面前就可以坦然。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","我们向他求的一切，他都会给我们，因为我们遵从他的命令，作让他快乐的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","上帝的命令就是：我们应该相信他的儿子耶稣基督之名，按照他的吩咐彼此相爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","凡是遵从上帝命令的人，就会一直住在上帝里面，上帝也住在他之中。我们知道，上帝凭着赐给我们的灵，生活在我们之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","亲爱的朋友，不要相信所有灵，而是要对灵进行考验，看看这些灵是否出于上帝，因为已有许多假先知来到这世界。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","你们如何识别上帝的灵？凡是承认耶稣基督以人类的身形来到这世界，那灵就是来自上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","那些不接受耶稣的灵，就不是来自上帝。事实上，这样的灵是反基督的灵，你们听过他要来，现在他已经来到这世界。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","但你们属于上帝，并且已经胜过他们，因为在你们之中的那一位，远比已在这世上的那一位更伟大。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","他们属于这个世界，所以都用着这个世界的说话方式，这个世界也就听他们的。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","我们属于上帝，认识上帝的就会听我们的，不属于上帝的就不会听我们的。通过这种方式，我们就可以辨别真理的灵和谬误的灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","亲爱的朋友们，让我们继续彼此相爱，因为爱来自上帝。爱其他人，你就是上帝所生，就认识上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","不爱其他人，就不认识上帝，因为上帝就是爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","上帝如何向我们显明爱？上帝派他唯一的独子来到这个世界，要让我们可以借着他而活； ");
INSERT INTO cmnfeb_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","这就是爱！不是我们爱上帝，而是上帝爱我们，他派他的儿子成为我们的罪被赦免的手段。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","朋友们，如果上帝就是通过这种方式爱我们，我们也应当以这种方式彼此相爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","没有人曾见过上帝。但如果我们彼此相爱，上帝就住在我们之中，他的爱就会在我们中得以实现。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","我们如何知道我们住在他之中，他也住在我们之中？因为他给了我们通过他的灵去爱的能力。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","因为我们就是我们所见之事的见证人，见证父派子作为这世界的救世主。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","凡是宣称耶稣是上帝之子的人，上帝就住在他们之中，他们也住在上帝之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","我们已经经历并相信上帝对我们的爱。上帝就是爱，活在爱之中的人，活在上帝之中的人，上帝也活在他们之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","这就是爱让我们完整的方式，这样我们就可以在审判日充满信心：因为我们在这个世界上的生活，就像他一样。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","有爱的地方就没有恐惧。上帝给了我们全部的爱，这种爱驱散了我们所有恐惧。如果我们害怕，那是因为我们害怕受到惩罚，这表明我们还没有完全被上帝全部的爱所改造。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","我们爱，是因为上帝先爱我们。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","如果有人说“我爱上帝”，却恨其他基督徒兄弟姐妹，那这个人就是在说谎。如果不爱他们所看到的兄弟，就无法爱那看不见的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","爱上帝的人，也应当爱他的兄弟姐妹，这就是上帝给我们的命令。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","凡信耶稣就是基督的人，都是源自上帝；爱父亲的人，也必会爱他的孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","当我们爱上帝，遵守他的命令，就知道我们在爱上帝的孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","我们遵守上帝的命令，就是爱上帝；他的命令遵守起来并不困难， ");
INSERT INTO cmnfeb_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","因为源自上帝的人就会战胜这世界。想要获得胜利并战胜这世界，就要相信上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","只有那些相信耶稣、坚信他就是上帝之子的人，才能战胜这世界。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","那借由水和血而来的，就是耶稣基督。他不只是借由水而来，而是借由水和血而来。灵提供了证据来证实这一点，因为灵就是真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","所以这里有三个证据： ");
INSERT INTO cmnfeb_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","灵、水和血，这三样都是一致的。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","如果我们都能接受人类证人提供的证据，那么上帝提供的证据就更重要。上帝提供的证据，就是他对其子的见证。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","那些信上帝之子的人，已经接受并坚持这样的证据。那些不相信上帝的人，会认为上帝是个骗子，因为他们不相信上帝所提供关于其子的证据。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","这证据就是：上帝已将永恒生命赐给我们，我们则借由他的儿子拥有这生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","有上帝之子便有生命；没有上帝之儿子就没有生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","我写这封信，就是要告诉那些相信上帝儿子之名的人，让你们可以确定自己拥有永恒的生命。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","我们可以相信的是：只要我们根据他的意愿提出要求，他会听我们所说的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","如果我们知道他已听到我们的请求，就可以确定会得到所求的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","如果你看到其他基督徒兄弟姐妹犯下并不致命的罪，你应该祈祷，上帝会赐给有罪之人以生命。（但不能是致命的罪。有一种罪是致命的，我不是说人们应该这样祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","是的，所有不正直良善的都是罪，但也有不致命的罪。） ");
INSERT INTO cmnfeb_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","我们意识到，那些生自上帝的人不会持续犯罪。上帝的儿子保护他们，魔鬼不能伤害他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","我们知道我们属于上帝，以及世界处于恶者的权势之下。 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","我们也知道上帝的儿子已经到来，帮助我们理解，让我们意识到哪一位才是正确的。我们就活在真实的他中，在他儿子耶稣基督之中。他就是真正的上帝，是永恒的生命 ");
INSERT INTO cmnfeb_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","亲爱的朋友们，要远离那些神像崇拜。");
INSERT INTO cmnfeb_vpl VALUES ("J21_1","093_1_1","2JN","1","1","1","这封信来自长老，写给被选中的女士和她的儿女，都是我以真理所热爱的。不只是我，这封信也来自所有知道真理之人， ");
INSERT INTO cmnfeb_vpl VALUES ("J21_2","093_1_2","2JN","1","2","2","因为这真理就生活在我们中间，将于我们永远同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","愿在真理和爱中, 来自父上帝和其子耶稣基督的恩典、怜悯和平安，持续与我们同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","很高兴看到你的一些儿女，就像天父命令我们那样，追寻真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","亲爱的女士，现在我要告诉你：我们应该彼此相爱。这并非是一条新指令，而是我们应该从一开始就要遵守的。 ");
INSERT INTO cmnfeb_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","我们应该遵循上帝的命令，这就是爱。这命令正如你们最初听到的，你们应该生活在爱中。 ");
INSERT INTO cmnfeb_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","我告诉你们这些，是因为许多欺骗者已经离开，到外面的世界去了。他们不接受耶稣基督是以人的身份来的。任何像这样的人都是欺骗者和反基督者。 ");
INSERT INTO cmnfeb_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","你们要小心，不要丢掉我们如此努力完成的工作，也不要丢掉你应该得到的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","那些变得极端的人，不在继续遵守基督的教导，上帝不会与之同在。遵循基督的教导，上帝和上帝之子都会与他们同在。 ");
INSERT INTO cmnfeb_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","如果有人来到你面前，没有展示基督教导的证据，不要接纳他们，也不要问候他； ");
INSERT INTO cmnfeb_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","因为你鼓励他们，就是等于参与了邪恶的事情。 ");
INSERT INTO cmnfeb_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","我还有许多话想要说给你们听，但我不想用纸墨继续写下去，只是希望能造访你们，与你们当面谈谈，那样会让我们感到非常欢喜！ ");
INSERT INTO cmnfeb_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","你那被选中姐妹的儿女向你问候。");
INSERT INTO cmnfeb_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","这封信来自长老，写给我以真理热爱的朋友该犹。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","我的朋友，祝你们所做的一切都顺利，身体健壮，就像我所知你们健全的灵性。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","有些信徒来到这里，向我讲述你对真理的忠诚，以及你如何在生活中遵循真理，对此我非常高兴。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","听说我亲爱的朋友们遵循真理，没有什么比这更让我快乐了。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","我的朋友，你照顾各位兄弟，包括那些你不认识的人，这显示出你值得信赖。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","他们曾在教会面前充分说明了你的爱。请你照上帝所喜欢的方式，帮助他们继续其旅程， ");
INSERT INTO cmnfeb_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","因为他们为主之名旅行，没有从非信徒那里接受甚么。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","所以我们应当支持他们，好让我们可以在真理中分享。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","关于这件事，我曾写信给教会，但想作领袖的狄特腓并不接受我的权威。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","因此，如果我真的造访，要说清楚他都做了什么。他曾恶言中伤我们；不仅如此，他还拒绝欢迎其他兄弟。他也不让其他人欢迎他们，并把那些欢迎他们的人赶出了教会。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","我的朋友，不要模仿恶，要效法善。那些做善事的人属于上帝，作恶之人不知道上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","众人都说低米丢好，真相说明了一切。我们也赞扬他，你知道我们讲的都是真理。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","我还有许多话想要说给你听，但我不想用笔墨写给你。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","盼望很快就见到你，这样我们就可以见面谈。 ");
INSERT INTO cmnfeb_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","愿你平安！这里的朋友们向你问候。请替我向各位朋友一一问候。");
INSERT INTO cmnfeb_vpl VALUES ("JD1_1","095_1_1","JUD","1","1","1","这封信函来自耶稣基督的仆人、雅各的兄弟犹大，写给那些被蒙招之人，那些被父上帝所爱、由受耶稣基督保护之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_2","095_1_2","JUD","1","2","2","愿你们感受到上帝更多的怜悯、平安和慈爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_3","095_1_3","JUD","1","3","3","我的朋友们，我非常期待在信中讲述我们所分享的救赎。但现在我需要通过信函紧急告诉你们，鼓励你们大力捍卫关于上帝的真理，这些真理已经一次性且永远地全部赐给上帝的圣徒。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_4","095_1_4","JUD","1","4","4","因为有些人悄悄混入你们中间。很久以前就有人写到他们，对他们进行谴责，因为他们是邪恶之人，歪曲上帝的恩典，将其变成不道德的放纵行为，同时否认我们的主和主耶稣基督。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_5","095_1_5","JUD","1","5","5","尽管你们已经知道了，但我还是要提醒你们，主虽然把他的百姓从埃及的土地上救了出来，但后来他还是毁灭了那些不信之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_6","095_1_6","JUD","1","6","6","即使是那些不满足于上帝所赐地位、放弃其应有位置的天使，上帝也会将其置于永恒的黑暗锁链中，直到那伟大的审判日。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_7","095_1_7","JUD","1","7","7","同样，所多玛、蛾摩拉和附近那些追逐不道德和变态淫乱的城镇，也是将遭受永恒之火惩罚的例子。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_8","095_1_8","JUD","1","8","8","同样，这些梦想家污染了自己的身体藐视权威，毁谤神圣之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_9","095_1_9","JUD","1","9","9","即使是天使长米迦勒，当他为了摩西的尸体与魔鬼争论时，也不敢用毁谤的语言定他的罪，只说：“愿主责备你！” ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_10","095_1_10","JUD","1","10","10","但这些人嘲笑他们不理解的东西；而他们理解的东西却像不思考的动物一样本能地追随--这就是摧毁他们的原因。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_11","095_1_11","JUD","1","11","11","他们现在面对可怕的灾祸，因为他们走上了该隐的道路，就像巴兰和他的妄想，他们出于利益的动机而放弃了自己。就像可拉和他的叛乱，他们毁灭了自己。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_12","095_1_12","JUD","1","12","12","这些人破坏其他人的饭菜，因为他们是自私的牧羊人，没有丝毫羞耻心，只顾自己。他们是被风吹走的云，不会带来雨水。他们是光秃秃的树，不会结果——两次死亡，连根拔起。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_13","095_1_13","JUD","1","13","13","他们是汹涌的海浪，溅起耻辱的泡沫。他们是虚假的星辰，注定永远陷入黑暗。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_14","095_1_14","JUD","1","14","14","亚当第七世孙以诺也曾对这些人做出预言：“看！主正在与他千万圣者降临， ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_15","095_1_15","JUD","1","15","15","审判众人，揭露世人所做的一切恶事，以及敌对的罪人对其说的所有可怕之语。” ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_16","095_1_16","JUD","1","16","16","这样的人总是在发牢骚，总是在抱怨。他们追随自己的邪恶欲望，自吹自擂，通过奉承他人获得他们想要的东西。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_17","095_1_17","JUD","1","17","17","但你们呢，亲爱朋友们，请记住我们主耶稣基督的使徒从前所说的话。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_18","095_1_18","JUD","1","18","18","他们曾向你们解释：在末世，必有喜欢嘲弄之人，追随自己的邪恶欲望。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_19","095_1_19","JUD","1","19","19","这些人会分裂，他们是没有灵的世俗之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_20","095_1_20","JUD","1","20","20","但我的朋友们，你们要通过对上帝的信任来成就自己。以圣灵的名义进行祈祷， ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_21","095_1_21","JUD","1","21","21","在上帝的爱中保护自己，等候带来永生之主耶稣基督的怜悯。 ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_22","095_1_22","JUD","1","22","22","向心里疑惑之人予以怜悯； ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_23","095_1_23","JUD","1","23","23","在你力所能及的情况下，把他们从火中抢救出来。显示你的怜悯，但要非常小心，甚至要憎恨那些被罪恶人性污染的“衣服。” ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_24","095_1_24","JUD","1","24","24","现在，通过我们的主耶稣基督，愿那可以保护你们不会坠落的主，那能以无可挑剔的方式带来极大喜乐、将你们带到其荣耀之地的主， ");
INSERT INTO cmnfeb_vpl VALUES ("JD1_25","095_1_25","JUD","1","25","25","那唯一的上帝、我们的救世主， 愿他在过去、现在和未来，拥有所有荣耀、威严、能力和权威。 阿门。");
INSERT INTO cmnfeb_vpl VALUES ("RV1_1","096_1_1","REV","1","1","1","这是上帝赐予耶稣基督的启示，是为了向他的仆人们展示即将发生的事情。上帝派天使向其仆人约翰 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_2","096_1_2","REV","1","2","2","做出这一显示，约翰证实了他所看到的、关于上帝之道和耶稣基督见证的一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_3","096_1_3","REV","1","3","3","能读到这启示之人有福了， 还有那些听见这预言、专注于所写内容之人，都有福了！因为那个时间将至。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_4","096_1_4","REV","1","4","4","这封信来自约翰，写给亚西亚的七个教会。愿那位过去、现在和未来都会到来的那一位，还有他宝座前的七灵， ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_5","096_1_5","REV","1","5","5","以及那值得信赖的见证人、从死亡中首次诞生的、人间众君王的统治者耶稣基督，赐予你们恩典和平安。至爱我们的耶稣，用自己的血把我们从我们的罪中释放出来， ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_6","096_1_6","REV","1","6","6","又让我们成为他的国，作他父上帝的祭司。愿荣耀和权能都归给耶稣，直到永远。阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_7","096_1_7","REV","1","7","7","看，他在云朵围绕中来临，每个人都应看见他，包括那些杀死他的人。地上的所有人都因他而哭泣。但愿如此！阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_8","096_1_8","REV","1","8","8","那过去、现在和以后都会来的全能主上帝说：“我是始也是终，” ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_9","096_1_9","REV","1","9","9","我是约翰，你们的兄弟，在耶稣中与你们共同痛苦，分享这个国，一起忍耐。为了分享上帝的道以及耶稣显现的真理，我被关在一个叫做拔摩的海岛上。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_10","096_1_10","REV","1","10","10","在一个主日， 我被灵注满，听见在我后边发出很大的声音，像是号角， ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_11","096_1_11","REV","1","11","11","那声音告诉我：“把你所看到的写成书，寄给七个教会：以弗所、士每拿、别迦摩、推雅推拉、撒狄、非拉铁非和老底嘉。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_12","096_1_12","REV","1","12","12","我转过身，想去看看是谁；转过身，看见七个金灯台。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_13","096_1_13","REV","1","13","13","灯台中间好像有一个人，看起来像是人子，身上穿着直垂双脚的长袍，胸间束着金带。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_14","096_1_14","REV","1","14","14","他的头发像白羊毛、双眼好似燃烧的火焰。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_15","096_1_15","REV","1","15","15","他的双脚好像在活炉中炼过的亮光铜，声音好似震耳欲聋的瀑布。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_16","096_1_16","REV","1","16","16","他的右手拿着七颗星星，口中吐出双刃利剑，面孔发光，好似最亮的烈日。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_17","096_1_17","REV","1","17","17","我看到他便扑倒在他脚前，如死了一般。但他用右手按我并说：“不要怕！我是最初，我是最后， ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_18","096_1_18","REV","1","18","18","永远活着；我曾死过，但看哪！现在我是永生，并且拿着死亡和坟墓的钥匙。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_19","096_1_19","REV","1","19","19","所以，把你所看见、正在发生和未来将要发生的事情，都写下来。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV1_20","096_1_20","REV","1","20","20","你看我右手的七星和七个金灯台, 它的含义就是：七星是四个教会的七位天使，七个灯台就是七个教会。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_1","096_2_1","REV","2","1","1","“你要这样写给以弗所教会的天使：那右手拿着七星、行走于七个金灯台之中的人说： ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_2","096_2_2","REV","2","2","2","我知道你所成就的、你的劳苦和你的坚持，也知道你不肯容忍恶人，知道你曾经调查那些自称是使徒、但其实并非如此之人，发现他们是骗子。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_3","096_2_3","REV","2","3","3","我知道你的忍耐，知道你曾为我的名忍受过什么，但你并未放弃。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_4","096_2_4","REV","2","4","4","但有一件事我要责备你：你忽视了最初的爱。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_5","096_2_5","REV","2","5","5","所以，要记得你已坠落多远，要悔改，回到最初所作的事情。否则，我会来到你这里，把你的灯台从原处移去，除非你悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_6","096_2_6","REV","2","6","6","然而，你确实有这个功劳。：那就是你恨恶尼哥拉党的作为，这也是我所憎恨的。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_7","096_2_7","REV","2","7","7","如果你有耳朵，要聆听灵对教会所说的。那些得胜之人，我一定会把上帝乐园中生命树的果子赐给他吃。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_8","096_2_8","REV","2","8","8","你要写信给在士每拿教会的使者，说：那最初的和最终的、曾死去又复活的这样说： ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_9","096_2_9","REV","2","9","9","我知道你们经历的困苦和贫穷，但你们却是富足的。我也知道那些自称犹太人说出的毁谤，其实他们不是犹太人，而是撒旦的党羽。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_10","096_2_10","REV","2","10","10","不要害怕将要受到苦。是的！魔鬼将考验你们，把你们中的有些人投入监牢，你们要受患难十天。你们要保持忠诚，即使那意味着死亡，我就会把生命的冠冕赐给你。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_11","096_2_11","REV","2","11","11","如果你有耳朵，就要去听灵向众教会所说的话。那些获得胜利的人，决不会遭受第二次死亡的伤害。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_12","096_2_12","REV","2","12","12","你要这样写信给在别迦摩教会的天使：那持有双刃剑的这样说： ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_13","096_2_13","REV","2","13","13","我知道你住在撒旦王座所在的地方，一直忠心于我。就是在撒旦居住的地方，即使当我忠心的见证人安提帕在你们中被杀，你们仍然信我。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_14","096_2_14","REV","2","14","14","但有几件事我要责备你们：你们中有些人坚持巴兰的教义，这巴兰曾指使巴勒，让以色列的子孙吃祭过神像的食物，做淫乱之事，让他们掉入陷阱。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_15","096_2_15","REV","2","15","15","同样，你们中还有些人坚持尼哥拉党的教义。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_16","096_2_16","REV","2","16","16","所以你们要悔改，否则我就很快来到你们之中，用我口中的剑跟他们作战。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_17","096_2_17","REV","2","17","17","如果你有耳朵，就要去听灵向众教会所说的话。对于得胜之人，我会向其赐予那隐藏的吗哪，赐他一块白石，上面写着新的名字，除了获得这石头的人，别人都不知道这个名字是什么。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_18","096_2_18","REV","2","18","18","你这样写给推雅推拉教会的天使：那双眼似火焰、两脚如亮铜的上帝之子说： ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_19","096_2_19","REV","2","19","19","我知道你们成就了什么，知道你们的爱和信心、服侍和忍耐，也知道你们后来所作的事情，比第一次信的时候还要多。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_20","096_2_20","REV","2","20","20","但有件事我要责备你们：你们允许那自称是先知的妇人耶洗别，教导和引诱我的仆人们行淫乱，吃祭过神像的食物。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_21","096_2_21","REV","2","21","21","我曾给她时间悔改，她却不肯为其淫行悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_22","096_2_22","REV","2","22","22","所以我把她和那些与她行淫乱之人抛到一张床上，如果他们不悔改与她一起做出的行为，就会遭受可怕的痛苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_23","096_2_23","REV","2","23","23","我将让她的儿女死去；让所有教会都知道，我是来考察人的想法和动机，我要根据你们每个人所做的行为，给你们偿还。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_24","096_2_24","REV","2","24","24","对于你们在推雅推拉的其他人，你们这些不遵循这个教导的人，没有学会撒旦所谓的‘深恶痛绝’的人，我不会把别的重担放在你们身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_25","096_2_25","REV","2","25","25","但告诉你们：要恪守已经得到的，直到我来。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_26","096_2_26","REV","2","26","26","那些已获胜的、一直到最后都遵守我所说之人，我必赐予其统治国家的权力， ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_27","096_2_27","REV","2","27","27","他将用铁杖治理国家，好像打碎陶器一样粉碎他们。就像我从父那里获得的权力； ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_28","096_2_28","REV","2","28","28","我还要把晨星给他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV2_29","096_2_29","REV","2","29","29","如果你有耳朵，就要听圣灵对众教会所说的话。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_1","096_3_1","REV","3","1","1","“你要这样写信给撒狄教会的天使：那有着上帝七灵和七星的，这样说：我知道你所成就的，知道你看起来是活着的，其实你死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_2","096_3_2","REV","3","2","2","快醒醒，让那些剩下来的、将要死的恢复活力；因为我发现，从我上帝的角度来看，你所做的事情并不完全。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_3","096_3_3","REV","3","3","3","所以你应当提醒自己，想想这讯息如何抵达你那里，以及你听到的一切。遵守对你的教导，然后悔改。如果你不警醒，我就会像窃贼一样，我什么时候来到，你决不会知道。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_4","096_3_4","REV","3","4","4","但你们中间有一些在撒狄的人，些人尚未玷污自己衣服，他们要身穿白衣与我同行，因为他们配得上。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_5","096_3_5","REV","3","5","5","那些获胜的，也必会这样身穿白衣，他们的名决不会从生命册中除去，我还要在我父和他的众天使面前，说他的名。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_6","096_3_6","REV","3","6","6","如果你有耳朵，就要去听灵对众教会所说的。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_7","096_3_7","REV","3","7","7","要这样写给非拉铁非教会的天使：这些话，来自那圣洁而真实、拿着大卫钥匙的人，他打开的，没有人能关上；他关上的，没有人能打开。他这样说： ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_8","096_3_8","REV","3","8","8","我知道你们所成就的。看，我已经为你们打开一道门，没有人能关上。我知道你只有一点点力量，也遵守我所说的，没有否认我。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_9","096_3_9","REV","3","9","9","从撒旦的会堂里，我会把那些自称是犹太人之人（其实不是，他们是骗子）的人带到你们面前，在你的脚前敬拜，让他们知道我爱你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_10","096_3_10","REV","3","10","10","因为你们遵守了我所说的，我就会在世界即将到来的、生活在人间之人会遭受的考验中，保护你们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_11","096_3_11","REV","3","11","11","我很快就会到来！紧紧抓住你们现在所有的，不要让别人拿走你们的冠冕。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_12","096_3_12","REV","3","12","12","那些得胜的，我会让他们在我上帝的圣殿中作立柱，他们决不再离开，我还要在他们身上写下我上帝的名、我上帝之城的名，就是那从天上、从我上帝处降下来的新耶路撒冷，写下我的新名。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_13","096_3_13","REV","3","13","13","如果你有耳朵，就要去听灵对众教会所说的。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_14","096_3_14","REV","3","14","14","你要这样写给老底嘉教会的天使：那位阿门所说的、忠信真实的见证人，那上帝造物的最高统治者，这样说： ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_15","096_3_15","REV","3","15","15","我知道你们所成就的，你们即不冷，也不热；但我还是希望你们热或者冷。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_16","096_3_16","REV","3","16","16","因为你好像温水，不热也不冷，所以我要把你从我口中吐出去。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_17","096_3_17","REV","3","17","17","你们对自己说：我富足，我有财富，不需要任何东西。但你们不知道的是，你们其实是困苦、可怜、贫穷、瞎眼和赤裸。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_18","096_3_18","REV","3","18","18","我建议你们从我这里购买由火精炼过得金子，这样你们才可能富足；穿上白衣，这样就能恰当地穿衣，不会赤身和感到羞耻；用药膏抹你们的眼睛，让你们可以看见。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_19","096_3_19","REV","3","19","19","我会纠正和管教我所爱的；所以你们要诚心，要悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_20","096_3_20","REV","3","20","20","看，我站在门外敲门；如果有人听见我的声音后开门，我就会走进去与他们一起吃饭，他们与我在一起。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_21","096_3_21","REV","3","21","21","我会让那些获胜的人与我一起，坐在我的宝座旁边，就像我获胜后坐在我父宝座旁边。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV3_22","096_3_22","REV","3","22","22","如果你有耳朵，就要听圣灵对众教会所说的话。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_1","096_4_1","REV","4","1","1","这之后，我看到天上开了一道门，然后我听到了之前曾听到的声音，那号角一般的声音，对我说：“到这里来，我要把以后将发生的事指示你。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_2","096_4_2","REV","4","2","2","我立刻被注满灵，然后看到天上有一个宝座，有人坐在宝座上。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_3","096_4_3","REV","4","3","3","王座上的人仿佛宝石，就像碧玉和红宝石，又有彩虹围绕着宝座，闪耀如绿宝石。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_4","096_4_4","REV","4","4","4","宝座周围另有二十四个王座，上面坐着二十四位长老，身穿白衣，头戴金冠。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_5","096_4_5","REV","4","5","5","从这些宝座发出闪电和惊雷；又有七枝火炬在宝座前点着，这就是上帝的七灵。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_6","096_4_6","REV","4","6","6","在一个宝座前，伸出一片如水晶般清透的玻璃海。在宝座中间和周围有四个活物，前后长满了眼睛。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_7","096_4_7","REV","4","7","7","第一个活物看起来像狮子，第二个像牛犊，第三个有着人脸，第四个像飞鹰。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_8","096_4_8","REV","4","8","8","四个活物各长着六个翅膀，身上布满了眼睛。他们日夜不停地说：“圣哉！圣哉！神圣的全能主上帝，过去、现在和以后到来。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_9","096_4_9","REV","4","9","9","每当四个活物将荣耀、尊贵和感谢献给宝座上永生那位， ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_10","096_4_10","REV","4","10","10","二十四位长老便俯伏在宝座上那位面前，他们敬拜那永生的人，把他们的冠冕扔在宝座前，说： ");
INSERT INTO cmnfeb_vpl VALUES ("RV4_11","096_4_11","REV","4","11","11","“我们的主，我们的上帝，你值得获得荣耀、尊贵和权力，因为你创造了万物，你让万物得以存在。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_1","096_5_1","REV","5","1","1","我看见坐在宝座上那位，右手拿着书卷，书卷两面都写满了字，有七个封印。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_2","096_5_2","REV","5","2","2","我又看见一位力量强大的天使，大声喊道：“谁配展开这书卷并拆开它的封印？” ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_3","096_5_3","REV","5","3","3","在天上、地上和地底，没有人能够展开书卷阅读。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_4","096_5_4","REV","5","4","4","找不到配展开并阅读书卷的人，我为之大哭。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_5","096_5_5","REV","5","5","5","一位长老对我说：“不要哭！看，犹大部落的狮子、大卫的后裔，他已经赢得这场战斗，能够展开书卷，拆开它的七印。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_6","096_5_6","REV","5","6","6","我看见在宝座和四个活物中间，在众长老之中，有一个羊羔，好像被杀掉了，有七个羊角和七个眼睛，那是上帝的七灵，被派到世界各地。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_7","096_5_7","REV","5","7","7","羊羔走过去，从宝座上那位的右手拿了书卷。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_8","096_5_8","REV","5","8","8","拿到书卷后，四个活物和二十四位长老俯伏在羊羔前，各拿着琴和盛满了香的金炉，这香是众信徒的祈祷。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_9","096_5_9","REV","5","9","9","他们唱着一首新歌：“你配拿到书卷并拆开封印，因你曾被杀，用你的血从所有部落、语言、民族和国家处赎回上帝的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_10","096_5_10","REV","5","10","10","你让他们成为我们上帝的国和祭司，他们要在人间执掌王权。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_11","096_5_11","REV","5","11","11","我继续看着，听见千万天使的声音，他们都围在宝座、活物和长老的周围， ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_12","096_5_12","REV","5","12","12","大声说：“被杀的羊羔配得上获得权能、财富、智慧、力量、尊贵、荣耀和祝福！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_13","096_5_13","REV","5","13","13","我又听见在天上、地上、地底和海中的一切造物，以及天地间的万物都说：“愿祝福、尊贵、荣耀和权利，都归于坐在宝座上的那一位和羊羔，直到永远！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV5_14","096_5_14","REV","5","14","14","四个活物说：“阿门！”众长老也俯伏敬拜。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_1","096_6_1","REV","6","1","1","羊羔揭开七封印的第一个，我看着，然后听见四个活物中的一个发出雷鸣之声说：“来吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_2","096_6_2","REV","6","2","2","我看过去，见有一匹白马；骑马之人拿着弓，有冠冕赐给他，然后他骑着马离开，以便他可以获胜。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_3","096_6_3","REV","6","3","3","然后羊羔揭开第二个封印，我听见第二个活物说：“来吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_4","096_6_4","REV","6","4","4","一匹红马出来，骑马之人获得一把大刀，还有从地上夺去和平的权力，让人们互相残杀。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_5","096_6_5","REV","6","5","5","羊羔揭开了第三个封印，我听见第三个活物说：“来吧！”我看过去，见到一匹黑马；骑马之人手中拿着天平。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_6","096_6_6","REV","6","6","6","我听见四个活物中仿佛有声音说：“两磅小麦卖一天的工资，三磅大麦卖的价格相同，但油和酒也不可糟蹋。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_7","096_6_7","REV","6","7","7","第四个封印打开的时候，我听见第四个活物说：“来吧！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_8","096_6_8","REV","6","8","8","我看过去，看到一匹灰马；那骑士名为“死亡”，哈迪斯跟着他。他们获得的权力可以管辖地上的四分之一，用刀剑、饥荒、瘟疫和野兽去杀人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_9","096_6_9","REV","6","9","9","羊羔揭开第五个封印时，我看见祭坛下方，有人因献身上帝之道和他们的虔诚见证而被杀。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_10","096_6_10","REV","6","10","10","他们大声喊叫说：“圣洁真实的主啊！还要多久，你才能审判那些住在地上、泼洒我们血的人？” ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_11","096_6_11","REV","6","11","11","每个人都被赐予一个白袍，告诉他们要再等待一会儿，直到像他们一样被杀害的信徒和兄弟数量凑齐为止。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_12","096_6_12","REV","6","12","12","羊羔揭开第六个封印，发生了强烈的地震。太阳变黑，如粗糙的毛布；整个月亮变成血红； ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_13","096_6_13","REV","6","13","13","天上的星辰坠落到地上，如无花果树被大风晃动，落下未成熟的果子。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_14","096_6_14","REV","6","14","14","天空退却如一本书卷起来；山峦和岛屿从原处移动。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_15","096_6_15","REV","6","15","15","地上的君王、领袖、富人、权贵和所有奴隶或自由之人，都藏在洞穴以及山峦的岩石之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_16","096_6_16","REV","6","16","16","他们呼唤山岭和岩石，对它们说：“倒在我们身上吧！把我们藏起来，不要让坐在宝座上的那位看到，躲开羊羔的审判！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV6_17","096_6_17","REV","6","17","17","因为他们审判的可怕之日已经来到，谁能站立得住？” ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_1","096_7_1","REV","7","1","1","然后我看见四位天使站在地的四角，控制着四个方向的风，防止风吹在地面、海面和树上。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_2","096_7_2","REV","7","2","2","我又看见另外一位天使，从东方站起，拿着永活上帝的封印，向那四位得了权力、可以伤害地与海的天使，大声呼喊， ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_3","096_7_3","REV","7","3","3","他说：“你们不要伤害大地、海洋和树木，要等我们在上帝众信徒的额上先盖上印。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_4","096_7_4","REV","7","4","4","我听见被盖印的人数：以色列子孙各部落共十四万四千人：以色列子孙所有部落中被封印的： ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_5","096_7_5","REV","7","5","5","犹太部落一万二千人；流本部落一万二千人；迦得部落中一万二千人； ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_6","096_7_6","REV","7","6","6","亚设支部落一万二千人；拿弗他利部落一万二千人；玛拿西部落一万二千人； ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_7","096_7_7","REV","7","7","7","西缅部落一万二千人；利未部落一万二千人；以萨迦部落一万二千人； ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_8","096_7_8","REV","7","8","8","西布伦部落一万二千人；约瑟部落一万二千人；便雅悯部落一万二千人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_9","096_7_9","REV","7","9","9","之后我看到一大群人，没有人能数得过来他们的数量，来自所有国家、部落、民族和方言。他们站在宝座和羊羔面前，身穿白袍，手里拿着棕树枝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_10","096_7_10","REV","7","10","10","他们大声呼喊，说：“救赎来自那坐在宝座上我们的上帝，以及来自羊羔！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_11","096_7_11","REV","7","11","11","所有天使都围在宝座、众长老和四个活物的四 伏在宝座前，敬拜上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_12","096_7_12","REV","7","12","12","他们说：“阿门！愿祝福、荣耀、智慧、感谢、荣誉、权能和力量，都归给我们的上帝，直到永远。阿门！”阿门。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_13","096_7_13","REV","7","13","13","一位长老问我：“这些身穿白袍的是谁？他们从哪里来？” ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_14","096_7_14","REV","7","14","14","我回答：“我主啊，你知道答案。”他告诉我：“这些人经历过巨大的迫害。他们用羊羔的血，把自己的长袍洗白。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_15","096_7_15","REV","7","15","15","因此他们才能坐在上帝的宝座前，日夜在他的圣殿中事奉他。那坐在宝座上的，也会以其存在而保护他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_16","096_7_16","REV","7","16","16","他们不会再挨饿，不会再口渴；太阳不会炙烤他们，他们也不会因炎热而受苦， ");
INSERT INTO cmnfeb_vpl VALUES ("RV7_17","096_7_17","REV","7","17","17","因为在宝座中间的羊羔会成为他们的牧羊人，领他们到生命水泉，上帝也必抹去他们的一切眼泪。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_1","096_8_1","REV","8","1","1","当羔羊打开第七封印时，天堂里有大约半个小时的沉默。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_2","096_8_2","REV","8","2","2","我看见站在上帝面前的七位天使，被赐予七枝号角。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_3","096_8_3","REV","8","3","3","另一位天使来到，站在祭坛前，手拿金香炉。他被赐予许多香，加入所有圣徒的祈祷之中，放在宝座前的金坛上。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_4","096_8_4","REV","8","4","4","香散发的烟和众圣徒的祈祷，从天使手中一同升到上帝面前。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_5","096_8_5","REV","8","5","5","天使拿着香炉，用圣坛上的火把其填满，然后扔到大地；于是就有惊雷、闪电和可怕的地震。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_6","096_8_6","REV","8","6","6","然后拿着七枝号角的七位天使，做好吹号的准备。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_7","096_8_7","REV","8","7","7","第一位天使吹响他的号角，就有冰雹和混杂着血的火，投向大地。三分之一的大地被烧尽，三分之一的树被烧毁，所有的青草都被烧毁。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_8","096_8_8","REV","8","8","8","第二位天使也吹响号角，一座仿佛燃烧的大山被扔进大海，三分之一的海变成血。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_9","096_8_9","REV","8","9","9","海中三分之一造物死去，三分之一船只被毁。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_10","096_8_10","REV","8","10","10","第三位天使吹响号角，一颗燃烧的巨大星辰从天上落下来，落入三分之一的江河和水的泉源之中。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_11","096_8_11","REV","8","11","11","这星名叫“苦堇。”三分之一的水变苦，因水变苦，许多人因为这水而被毒死。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_12","096_8_12","REV","8","12","12","第四位天使吹响号角，三分之一太阳、三分之一月亮、三分之一星辰都遭受到打击，于是三分之一的日月星都变黑，三分之一的白昼没有了光，夜晚也是如此。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV8_13","096_8_13","REV","8","13","13","我看着，听见一只在天空中飞翔的鹰，大声说：“灾难！灾难！住在地上的人将迎来灾难！因为还有三位天使将要吹其他的号角。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_1","096_9_1","REV","9","1","1","第五位天使吹响号角，我看着一颗星从天上掉到地上。这颗星被赋予了打开深渊的钥匙。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_2","096_9_2","REV","9","2","2","他打开深渊，有烟从里面冒出来，就像一个巨大火炉飘出的烟，太阳和天空因这深渊的烟而变黑。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_3","096_9_3","REV","9","3","3","有蝗虫从烟中爬到地上；他们被赐予如地面蝎子一般的力量。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_4","096_9_4","REV","9","4","4","对他们的吩咐是，不可伤害地上的草和所有植物或树木，只可伤害那些额上没有上帝印记之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_5","096_9_5","REV","9","5","5","蝗虫没有杀戮的能力，只是让他们像被蝎子螫了一样痛苦五个月。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_6","096_9_6","REV","9","6","6","在那段时间，人们寻死却无法如愿；想要死亡，死亡却远离他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_7","096_9_7","REV","9","7","7","蝗虫的样子就像一匹匹战马，头上戴的仿佛金冠冕，脸像人的面孔， ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_8","096_9_8","REV","9","8","8","头发好像女人的长发，牙齿好像狮子； ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_9","096_9_9","REV","9","9","9","它们的胸甲如铁甲，翅膀的声音好像许多车马飞驰上战场的声音。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_10","096_9_10","REV","9","10","10","它们有着蝎子一样的尾巴和毒刺，尾巴对人的伤害能持续五个月。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_11","096_9_11","REV","9","11","11","它们的统治者是深渊的天使，希伯来语中名叫阿巴顿，希腊语名叫阿波伦。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_12","096_9_12","REV","9","12","12","第一场灾祸过去了。但还有两场灾祸即将到来！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_13","096_9_13","REV","9","13","13","第六位天使吹响号角，我听到上帝面前金坛的四角发出一个声音， ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_14","096_9_14","REV","9","14","14","对拿着号角的第六位天使说：“把捆绑在幼发拉底大河的那四位天使放了！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_15","096_9_15","REV","9","15","15","那四位天使于是被释放，他们已经做好准备，要在具体的某年某月某日某时，消灭三分之一的人类。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_16","096_9_16","REV","9","16","16","我听到马兵的数目是 2 亿人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_17","096_9_17","REV","9","17","17","在幻象中，我看到那些马和骑士是这样的：骑士身穿火红、深蓝和黄色的胸甲；马头好像狮子，马口喷出火、烟和硫磺。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_18","096_9_18","REV","9","18","18","马口喷出的火、烟和硫磺引发了三次瘟疫，杀死三分之一人类。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_19","096_9_19","REV","9","19","19","这些马的力量存在于它们的口中和尾巴上。他们的尾巴像蛇头，用来伤害人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_20","096_9_20","REV","9","20","20","那些未被瘟疫杀死的人类，仍然不为自己的所作所为而悔改，不肯停止崇拜魔鬼以及用金、银、铜、石头、木头做成的，不能看、不能听、也不能走路的神像。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV9_21","096_9_21","REV","9","21","21","他们也不会为自己的谋杀、邪术、淫乱和偷盗而悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_1","096_10_1","REV","10","1","1","我又看见一位力量强大的天使从天上而降，身披云彩，头上有彩虹，脸像太阳，两脚如火柱。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_2","096_10_2","REV","10","2","2","他手里拿着展开的小书卷，将右脚踏在海上，左脚踏在地上， ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_3","096_10_3","REV","10","3","3","他如狮子般大声呼叫。在呼喊的时候，有七个惊雷回应它。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_4","096_10_4","REV","10","4","4","七声惊雷响起时，我正要写下来，就听见天上传来一个声音说：“你要封印七雷所说的，不要写出来！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_5","096_10_5","REV","10","5","5","我看见那天使站在海上和地上，向天举起右手。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_6","096_10_6","REV","10","6","6","他凭着那创造天和天中万物、地和地中万物、海和海中万物，永生永世的主发了一个神圣的誓言。说：“不能再耽搁了！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_7","096_10_7","REV","10","7","7","但当第七位天使说话并吹响号角时，上帝的奥秘、他向其仆人和众先知们宣布的福音就要实现了。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_8","096_10_8","REV","10","8","8","然后我再次听到那天上传来的声音对我说：“去吧，去那站在海上和地上天使处，将他手中展开的书卷拿过来。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_9","096_10_9","REV","10","9","9","我走到天使那里，请他把小书卷给我。他对我说：“拿着吧，吃下去。它会让你的肠胃发酸，但是口里却好像蜜一样甘甜。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_10","096_10_10","REV","10","10","10","我把小书卷从天使手中拿过来，吃下去，口里甘甜如蜜，但吃下去却感觉肠胃发酸。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV10_11","096_10_11","REV","10","11","11","他又对我说：“关于众多民族、国家、语言和君王，你必须再次做出预言。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_1","096_11_1","REV","11","1","1","有人给我一根量尺，告诉我：“你起来量一量神的殿和祭坛，数一数在那里敬拜的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_2","096_11_2","REV","11","2","2","但不要量圣殿外面的院子，因为它已经交给异族人，他们要践踏圣城四十二个月。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_3","096_11_3","REV","11","3","3","我要将能力赐给穿著麻衣的两个人见证人，他们要持续预言一千二百六十天。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_4","096_11_4","REV","11","4","4","他们就是站在大地之主面前的两棵橄榄树和两个灯台。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_5","096_11_5","REV","11","5","5","如果有人想要伤害他们，就有火从他们口中喷出，烧死他们的敌人。凡是想要伤害他们的，都会被杀死。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_6","096_11_6","REV","11","6","6","他们有力量在其预言的时候关闭天空，不再下雨；有权力将水变成血，随时用各样灾难攻击大地，它们想要多少次都可以。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_7","096_11_7","REV","11","7","7","他们完成其见证时，那从深渊上来的野兽就会与他们作战，战胜他们并将其杀死。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_8","096_11_8","REV","11","8","8","他们的尸首会倒在大城市的开阔道路上。这些城在精神层面代表着所多玛和埃及，也是他们的主被钉上十字架的地方。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_9","096_11_9","REV","11","9","9","在三天半的时间中，来自各民族、部落、语言和国家的人会看着他们的尸首，但不许把尸首安葬在坟墓中。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_10","096_11_10","REV","11","10","10","地上居住的人因为他们之死而欢喜庆祝，彼此赠送礼物，因为这两位先知曾经让他们受痛苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_11","096_11_11","REV","11","11","11","但三天半后，上帝赋予生命的气息进入他们体内，他们就站立起来，看见这一切的人非常惧怕。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_12","096_11_12","REV","11","12","12","两位见证人听见从天上来的巨大声音，告诉他们：“上到这里来！”于是他们驾云上了天，他们的仇敌都看到了。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_13","096_11_13","REV","11","13","13","就在那时，大地震发生了，那座城倒塌了十分之一，因地震而死的有七千人，其他人都很害怕，把荣耀归于天上的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_14","096_11_14","REV","11","14","14","第二次灾祸过去了，第三次灾祸快要到了！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_15","096_11_15","REV","11","15","15","第七位天使吹响号角，天上传来巨大的声音说：“世上的国家成了我们主和基督所立的国，他要作王，直到永永远远！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_16","096_11_16","REV","11","16","16","那在上帝面前坐在自己座位上的二十四位长老，朝着向地面俯倒敬拜上帝， ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_17","096_11_17","REV","11","17","17","他们说：“过去和现在都存在的全能之主上帝，我们感谢你，因为你执掌了大权并成为统治者！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_18","096_11_18","REV","11","18","18","各国非常愤怒，但你的审判也来到了，这是死人受审判的时刻！你的仆人、先知、信徒只要尊重你的权威，无论虚弱或拥有全力，都要得赏赐！在此刻，你也将毁灭那些毁灭大地的人！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV11_19","096_11_19","REV","11","19","19","于是，上帝在天上的圣殿打开，他的约柜在圣殿中显现，随即出现闪电、雷鸣、地震、大冰雹。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_1","096_12_1","REV","12","1","1","这时天上出现了一个神奇景象：一个妇人身披太阳，脚踏月亮，头戴十二颗星的王冠。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_2","096_12_2","REV","12","2","2","她怀孕了，分娩的痛苦让它呼叫。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_3","096_12_3","REV","12","3","3","天上又出现了另一个景象。有一条巨大的七头十角红龙，头上戴着七个皇冠。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_4","096_12_4","REV","12","4","4","它的尾巴扫过天上三分之一的星辰，将它们摔在地上。这条龙就站在正在分娩的妇女面前，以便在她的孩子一出生时就能吃掉。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_5","096_12_5","REV","12","5","5","夫人生了一个男孩子，他将用铁杖治理列国，这孩子被提到天上，来到了上帝及其宝座处。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_6","096_12_6","REV","12","6","6","妇人逃到荒野，上帝为在那里为她准备了地方，她在那里会被照顾 1,260 天。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_7","096_12_7","REV","12","7","7","天上发生了战争：麦克和他的天使们与龙作战。龙和它的天使也前来应战， ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_8","096_12_8","REV","12","8","8","但龙的力量不够强大，他们再也无法留在天上。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_9","096_12_9","REV","12","9","9","于是那大龙被甩到了地球上，他的天使们也被摔了下来。这龙就是那被称作魔鬼的古蛇，又名撒旦，被派来迷惑全世界的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_10","096_12_10","REV","12","10","10","我又听见天上有很大的声音说：“现在我们上帝的救赎、权柄和他的王国已到，还有他基督的权力！因为那昼夜在上帝面前控告信徒的控告者，已经被摔了下来！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_11","096_12_11","REV","12","11","11","他们通过羊羔的血、通过他们个人的见证，战胜了它。他们并不爱惜自己的生命，所以愿意随时死去。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_12","096_12_12","REV","12","12","12","那就庆祝吧，天上和住在其中的所有人。悲痛吧，大地和海洋，因为魔鬼知道自己的时日无多，非常愤怒地跑到了你们那里。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_13","096_12_13","REV","12","13","13","那条龙意识到自己被摔在地球，于是就开始迫害那生了男婴的妇人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_14","096_12_14","REV","12","14","14","这妇人获得一个大鹰的两个翅，飞到荒野中自己的地方，她在那里受到照顾，持续半年、一年和更多年，保护她不受蛇的影响。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_15","096_12_15","REV","12","15","15","蛇在妇人身后，口中仿佛吐出江河一般的水，要把妇人冲去。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_16","096_12_16","REV","12","16","16","大地来帮助那妇人，张开口，把从龙口中吐出来的河水吞了下去。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV12_17","096_12_17","REV","12","17","17","龙于是向妇人发泄怒火，与她其余的子孙作战，也就是那些遵守上帝命令、做出耶稣见证的人作战。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_1","096_13_1","REV","13","1","1","龙站在海岸处，然后我又看见一个野兽从海里升起，他有十角七头，十角戴着十个皇冠，七头上显示亵渎的名字。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_2","096_13_2","REV","13","2","2","我所看见的野兽外表好似豹子，脚如熊，口像狮子。龙把自己的能力、王位和伟大权力都交给了它。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_3","096_13_3","REV","13","3","3","兽的七头中，有一个似乎受了致命伤，但那致命伤却医好了。地球上的每个人都对那野兽感到惊奇， ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_4","096_13_4","REV","13","4","4","于是纷纷膜拜那龙，因为他已经将其权力交给了野兽；于是他们膜拜野兽，询问：“有谁可以跟这兽相比？谁能战胜它？” ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_5","096_13_5","REV","13","5","5","他被赋予了大肆吹嘘和说亵渎话的能力，而且他还被授予了四十二个月个月的权力，可以这样做。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_6","096_13_6","REV","13","6","6","他一开口，就向上帝说出亵渎的话，侮辱了他的人格、他的圣殿以及那些住在天上的。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_7","096_13_7","REV","13","7","7","那野兽获得攻击信徒的权力，能够战胜他们；他也被赋予了对每个民族、部落、语言和国家的权柄。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_8","096_13_8","REV","13","8","8","所有住在地上的人都膜拜它，那些名字没有记录在生命书之中的人，这本书属于创世以来被杀的羊羔。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_9","096_13_9","REV","13","9","9","如果你有耳朵，就要听！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_10","096_13_10","REV","13","10","10","如果人应该被虏获，就一定会被虏获；如果有人会被刀杀，就一定会刀杀。在显示了上帝信徒的忍耐和信心！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_11","096_13_11","REV","13","11","11","我又看见另一只野兽从地里升起。它有两个角，好像羊羔，说话好像龙。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_12","096_13_12","REV","13","12","12","他在与第一头野兽一样，拥有相同的权力，可以让大地和住在地上的人，都去膜拜那受过致命伤、但已被医好的第一头野兽。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_13","096_13_13","REV","13","13","13","他做出了伟大的奇迹，甚至在人面前从天上呼唤火，降落地上。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_14","096_13_14","REV","13","14","14","他因为像第一头野兽那样可以做出神迹，于是迷惑了住在地上的人，便吩咐哪些人，要为受过刀伤、但死而复生的野兽做一个像。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_15","096_13_15","REV","13","15","15","他被允许将生命之气注入那野兽的像，让兽像能够说话，能够杀害那些不拜兽像之人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_16","096_13_16","REV","13","16","16","他又让每个人——无论虚弱强大、无论贫穷富有、无论自由或身为奴隶，在他们的右手或额头上得到一个标记。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_17","096_13_17","REV","13","17","17","这记号就是那野兽的名字或他名字的数字，除了有记号的人，谁也不能买，也不能卖。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV13_18","096_13_18","REV","13","18","18","这里需要智慧。能够理解之人，应该可以计算出野兽的数字，因为这是人的数字，它的数字是 666。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_1","096_14_1","REV","14","1","1","我又观看，见羊羔站在锡安山上，与他一起的还有十四万四千人，额上都写着他的名和他父的名。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_2","096_14_2","REV","14","2","2","我听见天上传来一个声音，听起来就像流淌的水和响雷，又像很多竖琴弹奏的琴声。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_3","096_14_3","REV","14","3","3","他们在宝座前、在四个活物和众长老面前，唱了一首新歌。除了十四万四千人，即那些从地上被赎回的人，没有人能够学会这首歌。没有人能学这歌。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_4","096_14_4","REV","14","4","4","这些人没有与妇女一起让自己玷污，他们在精神上是纯洁的。无论羊羔去哪里，他们都会跟随。这些人是从世人中兑换而来，作为初熟之果交给上帝和羊羔。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_5","096_14_5","REV","14","5","5","他们不说谎言；他们没有瑕疵。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_6","096_14_6","REV","14","6","6","我又看见另一位天使在天空飞翔，有永恒的福音要传给住在地上的人，提供给不同国家、部落、语言和民族的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_7","096_14_7","REV","14","7","7","他大声说：“应当敬畏上帝，把荣耀归给他！因为他审判的时候到了。应当敬拜创造天、地、海和水泉源的那一位！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_8","096_14_8","REV","14","8","8","又有第二位天使接着喊道：“伟大的巴比伦崩塌成废墟！她使所有的国家都喝了她的性罪之酒，使上帝愤怒地反对他们。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_9","096_14_9","REV","14","9","9","又有第三位天使，跟随前两个天使大声喊：“如果有人膜拜野兽和兽像，又在自己的额上或手上接受记号， ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_10","096_14_10","REV","14","10","10","他们将喝下上帝愤怒反对的酒，这酒未进行过滤就斟在上帝震怒的杯中，他必定在众天使和羊羔面前，在火与硫磺之中受痛 苦。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_11","096_14_11","REV","14","11","11","他们痛苦的烟向上冒，直到永远。那些膜拜野兽和兽像的，以及接受其名字记号的人，日夜得不到安宁。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_12","096_14_12","REV","14","12","12","这意味着，信徒必须耐心地忍耐，遵守上帝的诫命，信靠耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_13","096_14_13","REV","14","13","13","我听见天上有声音说：“你要写下来！从今以后，那些在主里死去的人有福了！”灵说：“是的，他们脱离自己的劳苦，他们所成就的也为他们佐证” ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_14","096_14_14","REV","14","14","14","我继续看。看到一朵白云，云上那位好似人子，头上戴着金冠，手里拿着锋利的镰刀。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_15","096_14_15","REV","14","15","15","另一位天使从圣殿出来，对坐在云上的那位大声呼喊：“伸出你的镰刀来收割吧！因为收割时间已到，地上的庄稼已熟透。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_16","096_14_16","REV","14","16","16","那坐在云上的向地上挥动镰刀，地上的庄稼就被收割了。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_17","096_14_17","REV","14","17","17","又有另一位天使从天上的圣殿出来，他也拿着一把锋利的镰刀。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_18","096_14_18","REV","14","18","18","他身后是一位天使，从祭坛处而来，拥有负责火的权力；他向那拿着锋利镰刀的天使大声说：“伸出你锋利镰刀，收获地上葡萄树累累硕果！因为葡萄已经熟透。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_19","096_14_19","REV","14","19","19","那天使便向地上挥动镰刀，收取地上的葡萄，把葡萄扔在上帝审判的压榨大酒池中。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV14_20","096_14_20","REV","14","20","20","那压榨酒池在城外被踹踏，就有血从压榨池中流出来，涨到马嚼环那么高，流到大约三百 公里那么远。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV15_1","096_15_1","REV","15","1","1","然后我看到天空中另外一个神奇重要的信号。七位天使拿着完成上帝审判的最后七个灾难。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV15_2","096_15_2","REV","15","2","2","我看到一个看起来像玻璃海的东西，混合着火。在玻璃海旁边站着那些打败这头野兽的人，还有他的形象以及他名字的编号。他们有上帝赐予的竖琴， ");
INSERT INTO cmnfeb_vpl VALUES ("RV15_3","096_15_3","REV","15","3","3","唱着上帝仆人摩西的歌和羔羊的歌：“你的所作所为伟大而奇妙，主神，全能者。万国之王，你的道路是正确和真实。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV15_4","096_15_4","REV","15","4","4","主啊！谁敢不敬畏你？谁敢不荣耀你的名？因为只有你是神圣的，万国都要来，在你面前下拜，因为你的正义作为已经显明。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV15_5","096_15_5","REV","15","5","5","在这之后，我看了看，“见证的帐幕” 的圣殿被打开了。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV15_6","096_15_6","REV","15","6","6","那掌管着末后七灾的七位天使，从圣殿出来，穿著清洁的白色麻衣，胸间束着金带。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV15_7","096_15_7","REV","15","7","7","四个活物之一，把盛满永恒上帝判决的七个金碗，交给那七位天使。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV15_8","096_15_8","REV","15","8","8","圣殿中充满了来自上帝荣耀和他力量的烟雾。直到七位天使的七灾结束前，都没有人能够进入圣殿。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_1","096_16_1","REV","16","1","1","我听见圣殿中传来巨大的声音，对七位天使说：“去吧，把上帝审判的七个碗倒在地上！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_2","096_16_2","REV","16","2","2","第一位天使去了，把碗倒在地上，于是在那些有兽记号和膜拜兽像的人身上，生出了可怕的恶性毒疮。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_3","096_16_3","REV","16","3","3","第二位天使把碗倒在海里，海水就变成好像死人的血，海中的所有生物都死了。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_4","096_16_4","REV","16","4","4","第三位天使把碗倒在江河和众水的泉源里，水就变成了血。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_5","096_16_5","REV","16","5","5","我听见掌管众水的天使说：“正如这审判所表明的那样，那过去和现在的胜者，真如审判所显示，你是真正的正确。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_6","096_16_6","REV","16","6","6","这些人曾流过信徒的血，现在你给他们血喝，这是他们该受的。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_7","096_16_7","REV","16","7","7","我又听见祭坛中有声音说：“是的，主啊！全能的上帝，你的审判是正义而公正的！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_8","096_16_8","REV","16","8","8","第四位天使把碗倒在太阳上，太阳就得到了能力，可以用火烤人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_9","096_16_9","REV","16","9","9","人被高热烧烤，亵渎那有权力掌管这些灾难的上帝之名，但他们并不悔改，不肯将荣耀归给他。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_10","096_16_10","REV","16","10","10","第五位天使把碗倒在野兽的王座上，野兽的王国就黑暗，人因为痛苦就咬自己的舌头。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_11","096_16_11","REV","16","11","11","他们因为所受的痛苦和所生的疮，亵渎天上的上帝，却并不为自己所作的悔改。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_12","096_16_12","REV","16","12","12","第六位天使把碗倒在幼发拉底大河上，河水干涸，为了要给那些从东方来的王预备道路。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_13","096_16_13","REV","16","13","13","我看见三个邪灵，好像青蛙从龙口、兽口和假先知的口中出来。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_14","096_16_14","REV","16","14","14","他们是魔鬼的灵，做出神奇之事，他们汇聚了普天下的众王，叫他们在全能上帝的伟大审判日中聚集作战。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_15","096_16_15","REV","16","15","15","（注意了！我会像贼一样到来！祝福那些保持警惕、衣服做好准备的人，让他们不至于赤身行走并感到耻辱。） ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_16","096_16_16","REV","16","16","16","邪灵就把众王聚集在一个地方，希伯来话叫哈米吉多顿。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_17","096_16_17","REV","16","17","17","第七位天使把碗倒在空中，此时从圣殿的宝座处传来很大的声音：“结束了！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_18","096_16_18","REV","16","18","18","于是出现闪电、雷轰和大地震，自从地面有人生活以来，从未发生过这么大的地震， ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_19","096_16_19","REV","16","19","19","那大城裂为三段，列国的城也都倒塌了。上帝想起巴比伦大城，好让她得到装满他敌意之酒的杯子。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_20","096_16_20","REV","16","20","20","各海岛都消失了，众山不见。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV16_21","096_16_21","REV","16","21","21","大冰雹从天而落，每块重约五十公斤，砸在人身上。由于这冰雹的灾，人们便诅咒上帝，因为这灾太严重了。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_1","096_17_1","REV","17","1","1","拿着七个碗的七位天使中，有一位来跟我说：“来这儿，我要把那坐在众水旁边恶名淫妇要受的审判告诉你。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_2","096_17_2","REV","17","2","2","地上的众王都曾与她行淫，住在地上的人也因喝她淫乱的酒而醉。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_3","096_17_3","REV","17","3","3","我在灵被天使带到荒野，看见一个妇人骑着鲜红色野兽，这野兽身上覆盖着亵渎的名字，有七头十角。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_4","096_17_4","REV","17","4","4","那妇人身穿紫色和朱红色衣服，佩戴金子、宝石和珍珠的珠宝，手里拿着金杯，盛满可憎的物品和她淫乱的污秽。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_5","096_17_5","REV","17","5","5","她额上写着一个名号：“奥秘，大巴比伦，地上淫妇和可憎物之母。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_6","096_17_6","REV","17","6","6","我又看见那妇人喝圣徒的血，还喝下耶稣见证人的血，喝醉了。看到她，我感到彻头彻尾的惊奇。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_7","096_17_7","REV","17","7","7","天使问我：“你为什么感到震惊？我要把这妇人的奥秘，以及她所骑七头十角兽的奥秘，都告诉你。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_8","096_17_8","REV","17","8","8","你看见的那个野兽，过去曾是从深渊上来，现在不是如此，但未来还将如此，然后就会走向灭亡。住在世上的人，凡是其名字在创世以来没有记在生命册上，在看见过去曾出现、现今不再出现、但将来还要出现的野兽，都会感到惊奇。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_9","096_17_9","REV","17","9","9","这里需要一个有理解力的头脑。七头就是那妇人所坐的七座小山， ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_10","096_17_10","REV","17","10","10","也就是那七位王：五位已经倒下，一位还在，另一位还没有来到——这位即将到来的，统治也会很短。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_11","096_17_11","REV","17","11","11","那曾经在、但如今不在的野兽，就是第八位王，是那七位中的一位，也会被彻底摧毁。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_12","096_17_12","REV","17","12","12","你看见的那十角就是十个尚未开始统治的王。他们会获得与兽一起作为王统治的权力，持续一小时。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_13","096_17_13","REV","17","13","13","他们有着共同的目标：把自己的力量和权力交给那野兽。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_14","096_17_14","REV","17","14","14","他们要跟羊羔作战，羊羔一定会战胜他们，因为他是万主之主，万王之王。已呼叫和选择了他的追随者，他们相信他” ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_15","096_17_15","REV","17","15","15","天使对我解释：“你所看见那淫妇坐着的水源，就是各种民族、人群、国家和方言的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_16","096_17_16","REV","17","16","16","你看见那十角和野兽会恨这淫妇，会对夺走她的一切，让她赤裸，又要吃她的肉，用火把她烧掉。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_17","096_17_17","REV","17","17","17","因为上帝把他想要做的事放在他们的脑海里，有一个商定的目的：那就是把自己的国家献给野兽，让上帝的话变成现实。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV17_18","096_17_18","REV","17","18","18","你看见的那妇人，就是统治地上众王的那座伟大城市。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_1","096_18_1","REV","18","1","1","这之后，我看见另一位天使从天而降，他拥有伟大的权力，他的荣耀照亮了大地。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_2","096_18_2","REV","18","2","2","他用强有力的声音呼喊：“伟大的巴比伦倾倒为废墟！她已成为恶魔的住处，各样污灵的庇护所，一和一切不洁可憎之鸟的栖息地。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_3","096_18_3","REV","18","3","3","因为各国都喝了她淫乱烈怒的酒，喝醉了；地上的君王与她行淫，世上的商人因她的挥霍发了财。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_4","096_18_4","REV","18","4","4","我听见天上传来另一个声音，说：“从那城出来吧，我的子民！免得她的罪你们也有分，受她所受的灾难； ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_5","096_18_5","REV","18","5","5","因为她罪恶滔天，上帝发现了她的邪恶。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_6","096_18_6","REV","18","6","6","她怎样待人，你们也要怎样待她；按照她的行为加倍报应她；按照她的酒杯，将加倍的痛苦调给她。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_7","096_18_7","REV","18","7","7","就像她对自己的吹嘘和放纵自己的欲望一样，给她的回报也是一样的痛苦和悲伤。她告诉自己：‘我如女王统治，我不是寡妇，决不会感到悲伤。’ ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_8","096_18_8","REV","18","8","8","因为只需一天，她的灾难必然来到，那就是死亡、悲哀和饥荒；她还要被火中摧毁，因为谴责她的主上帝是有着巨大的能力。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_9","096_18_9","REV","18","9","9","地上的众王跟她一同行邪淫, 骄奢无度，看见焚烧她的烟，就会为她痛哭捶胸。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_10","096_18_10","REV","18","10","10","他们害怕会遭受她所受的痛苦，所以远远站着，说：‘灾难！灾难！灾难降临这伟大的城市巴比伦。只需一小时，您的审判就实行了！’ ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_11","096_18_11","REV","18","11","11","地上的商人也为她悲哀痛哭，因为没有人再买他们的货物： ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_12","096_18_12","REV","18","12","12","金、银、宝石、珍珠；细麻布、紫色布、丝绸、红色材料；各样香木制品，各样象牙制品，各样贵重木器、铜器、铁器、大理石制品； ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_13","096_18_13","REV","18","13","13","肉桂、香料、焚香、乳香；酒、橄榄油、面粉、麦子；牛、羊、马、车、奴仆和囚犯。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_14","096_18_14","REV","18","14","14","你失去了最喜爱的甜蜜快乐！一切奢华闪亮的财富都从你那里消失，再也找不到了！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_15","096_18_15","REV","18","15","15","贩卖这些货物、借着她发财的商人，因为害怕会遭受她受的痛苦，就远远地站着。他们哭喊着、悲伤着，说 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_16","096_18_16","REV","18","16","16","‘灾难！灾难降临了这伟大城市！她穿着细麻布紫色长袍，佩戴金子、宝石和珍珠的珠宝， ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_17","096_18_17","REV","18","17","17","只一小时，所有这些财富竟荡然无存！’每个船长、每个海上旅客和水手、以及每个靠海谋生的，都远远地站着。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_18","096_18_18","REV","18","18","18","摧毁她的火焰飘出烟，他们看到了，就喊叫说：‘有哪座城能与这伟大的城相比？’ ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_19","096_18_19","REV","18","19","19","他们把尘土撒在自己头上，痛哭悲哀，喊着说：‘灾难！因为她的奢侈，灾难打击了这让船主富有的伟大城市！只一小时，她就被摧毁了！’ ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_20","096_18_20","REV","18","20","20","天堂、众信徒、众使徒和众先知，庆祝她所发生的事，因为上帝审判她的方式就像审判你一样。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_21","096_18_21","REV","18","21","21","一位强大的天使，把一块好像磨石一样的石头举起来，拋入海里，说：“伟大的巴比伦城也会被这暴力拋下去，再也不存在。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_22","096_18_22","REV","18","22","22","“你们再也不会听到音乐了，竖琴、歌手、长笛和号角。再也不会有任何行业的工匠在你这里工作。在你身上再也听不到磨坊磨出面粉的声音了。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_23","096_18_23","REV","18","23","23","你们再也不会有灯的亮光照耀了。你们再也听不到新郎新娘的声音了。你们这些商人领导这个世界，所有国家都因你们的邪术受了迷惑。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV18_24","096_18_24","REV","18","24","24","在这个城市中，能找到先知、信徒和地上一切被杀之人的血。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_1","096_19_1","REV","19","1","1","这之后，我听见天上好像有一大群人的喧闹声：“哈利路亚！救恩、荣耀、权能都属于我们的上帝， ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_2","096_19_2","REV","19","2","2","因为他的审判是真实正义的；因为他审判了那臭名昭著、以淫乱败坏世界的淫妇；并因为那淫妇谋害其仆人而对其进行判决。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_3","096_19_3","REV","19","3","3","他们又喊了一次：“哈利路亚！她的毁灭所产生的浓烟永远升腾。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_4","096_19_4","REV","19","4","4","那二十四位长老和四个活物，俯伏敬拜坐在宝座上的上帝，喊道：“阿门！哈利路亚！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_5","096_19_5","REV","19","5","5","接宝座传出声音，说：“所有上帝的仆人哪！凡是尊重他的，无论大小，都应当赞美我们的上帝！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_6","096_19_6","REV","19","6","6","又听见一个声音，好像是一大群人，如奔流的水，又像惊雷，说：“哈利路亚！因为主、我们全能的上帝统治了！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_7","096_19_7","REV","19","7","7","让我们欢喜庆祝，把荣耀归给他！因为羊羔的婚期到了；他的新娘也自己预备好了。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_8","096_19_8","REV","19","8","8","她得到了干净的白色细麻衣，（细麻衣代表着信徒的好工作） ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_9","096_19_9","REV","19","9","9","天使对我说：“写下来：‘受邀参加羊羔婚筵的人太幸福了！’”他又对我说：“这都是上帝真实说的话。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_10","096_19_10","REV","19","10","10","我就俯伏在天使脚前要拜他。但他对我说：“不可以这样！我和你以及那些接受耶稣作见证的人一样，都是上帝的仆人。敬拜上帝，因为耶稣的证言就是预言的灵。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_11","096_19_11","REV","19","11","11","我看着天打开了。有一匹白马站在那里，骑士叫做“忠信”和“真实”，当他审判，他是正义的；当他战斗，他是正义的。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_12","096_19_12","REV","19","12","12","他的眼睛好像火焰，头上戴着许多皇冠，身上写着一个名字除了他自己没有人认识。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_13","096_19_13","REV","19","13","13","他身穿一件浸过血的衣服，他的名字叫做“上帝之道。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_14","096_19_14","REV","19","14","14","天上的众军都骑着白马，穿著洁白的细麻衣，跟随他。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_15","096_19_15","REV","19","15","15","他口中吐出一把利剑，用于击打列国。他将用铁杖治理他们，他自己还要在全能上帝审判的压酒池踩葡萄。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_16","096_19_16","REV","19","16","16","在他的长袍和大腿上，写着“万王之王，万主之主”的名号。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_17","096_19_17","REV","19","17","17","我又看见一位天使站在太阳中，向高空所有的飞鸟大声呼喊：“来吧！聚集起来赴上帝的伟大宴席！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_18","096_19_18","REV","19","18","18","这里可以吃死人的肉：君王、领袖、壮士、还有马和骑士，以及无论是自由的、作奴隶的、伟大的、渺小的，吃所有人的肉。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_19","096_19_19","REV","19","19","19","我看见那野兽和地上的国王，还有他们的众军，都集合起来，要跟那马背骑士和他的军队作战。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_20","096_19_20","REV","19","20","20","那野兽被捉住了；连同在兽面前做出奇事的假先知（通过这种方式，他欺骗那些接受了野兽记号、膜拜野兽像的人）。他们都被活活拋在烧着硫磺的火湖里去。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV19_21","096_19_21","REV","19","21","21","其余的人都被那白马骑士口中吐出来的剑杀了，他们的肉让飞鸟吃饱了。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_1","096_20_1","REV","20","1","1","我又看见一位天使从天上降下来，手里拿着深渊的钥一条大锁炼。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_2","096_20_2","REV","20","2","2","他捉住了那龙，那古蛇，也就是魔鬼和撒旦，把它捆绑了一千年。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_3","096_20_3","REV","20","3","3","天使把它扔进深渊，关起来并封印，这样，他就不能再欺骗各国了，直到一千年结束。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_4","096_20_4","REV","20","4","4","我又看见一些宝座，有人坐在上面，获得了审判的权力。也看见那些因为替耶稣作见证，分享上帝的道而被斩首之人。他们没有膜拜野兽或兽像，也没有在额上或手上接受野兽的记号。他们都复活了，在一千年中与基督一同作王。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_5","096_20_5","REV","20","5","5","这是第一次复活。（其余的死人还没有复活，直到那一千结束。） ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_6","096_20_6","REV","20","6","6","在第一次复活中有份的人，得到了祝福，是圣洁的；第二次死亡不会对他们产生力量。他们还要作上帝和基督的祭司，与他一同作王一千年。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_7","096_20_7","REV","20","7","7","那一千年结束时，撒旦就要从监牢里被释放出来， ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_8","096_20_8","REV","20","8","8","迷惑地上四方的列国，以歌革和玛名为代表，将他们从世界的四面八方聚集在一起作战。他们的人数好像海边的沙那么多。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_9","096_20_9","REV","20","9","9","他们在地球上行进，围住了信徒的营地还有那被热爱的城市。但有火从天而降，毁灭了他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_10","096_20_10","REV","20","10","10","那迷惑他们的魔鬼，被拋在硫磺的火湖里，就是野兽和假先知所在质地。他们必昼夜受痛苦，直到永远。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_11","096_20_11","REV","20","11","11","然后我看到一个白色的大宝座，以及坐在上面的那位。天地都消失了，再也看不见了。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_12","096_20_12","REV","20","12","12","我看见死者，无论伟大或渺小，都站在宝座前。书都已打开。还有一本书，就是生命册，也展开了。死去的人都凭着这些书的所记载，照着他们曾经的行为接受审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_13","096_20_13","REV","20","13","13","于是大海把其中的死人交出来，死亡和阴间也把那里的死人交出来，按照他们曾经的行为接受审判。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_14","096_20_14","REV","20","14","14","死亡和阴间被拋在火湖里。这火湖就是第二次死亡。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV20_15","096_20_15","REV","20","15","15","名字没有记在生命册上的人，就被拋在火湖里。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_1","096_21_1","REV","21","1","1","我又看见一个新天、新地，因为第一个天和第一个地都过去了，海也不再存在了。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_2","096_21_2","REV","21","2","2","我看见圣城，新耶路撒冷，从天上上帝那里降下来，做好准备，仿佛打扮整齐等候丈夫的新娘。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_3","096_21_3","REV","21","3","3","我听见宝座那里传来巨大声音，说：“现在上帝的家与人类在一起，他将与他们一起生活，他们将成为他的子民。上帝要亲自与他们同在，作他们的上帝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_4","096_21_4","REV","21","4","4","他要从他们的眼中抹去一切眼泪，不再发生死亡，不再有悲哀、哭号或痛苦，因为之前的世界已不复存在。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_5","096_21_5","REV","21","5","5","坐在宝座上的那一位说：“我让一切都变成新的！”他告诉我：“写下来，因为这些话都是可信的、真实的。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_6","096_21_6","REV","21","6","6","他又对我说：“一切都完成了，我是阿拉法，我是欧米茄；我是初始，也是最终。我要把生命的泉水，免费送给那些口渴的人喝。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_7","096_21_7","REV","21","7","7","那些获胜的，要继承这一切。我要作他的上帝，他要作我的孩子。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_8","096_21_8","REV","21","8","8","但那些胆怯的、不信我的、做出可恶事情的、杀人的、淫乱的、行邪术的、拜神像的和所有说谎的人，他们选择的地点就是那烧着硫磺的火湖。这就是第二次的死亡。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_9","096_21_9","REV","21","9","9","拿个七碗的七位天使之一，走来对我说：“和我一起来！我像你展示这位新娘，羊羔的妻子。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_10","096_21_10","REV","21","10","10","在灵中，他带我来到一座很高山峰的顶端，向我展示上帝降下来的圣城耶路撒冷， ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_11","096_21_11","REV","21","11","11","上帝的荣光让它闪耀，城市的光辉好像极贵的宝石，又像晶莹的碧玉。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_12","096_21_12","REV","21","12","12","城墙高大厚实，有十二个门，门口有十二位天使，门上写着以色列十二部落的名字。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_13","096_21_13","REV","21","13","13","东边有三个门，南边有三个门，西边有三个门，北边有三个门。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_14","096_21_14","REV","21","14","14","城墙有十二个根基，根基上有羊羔的十二使徒名字。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_15","096_21_15","REV","21","15","15","对我说话的天使拿着一根黄金量尺，要丈量那城、城门和城墙。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_16","096_21_16","REV","21","16","16","城为四方形状，长宽相同。天使用芦苇丈量那城，共 12,000 弗隆，长、宽、高都一样； ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_17","096_21_17","REV","21","17","17","他又丈量了城墙，厚 144 腕尺。天使用的就是人类的度量衡。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_18","096_21_18","REV","21","18","18","城墙以碧玉制成，城用看起来像是玻璃的纯金打造。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_19","096_21_19","REV","21","19","19","城墙的根基点缀着各样宝石：第一座根基是碧玉，第二座是蓝宝石，第三座是玛瑙，第四座是绿宝石， ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_20","096_21_20","REV","21","20","20","第五座是红玛瑙，第六座是红宝石，第七座是黄璧玺，第八座是水苍玉，第九座是红璧玺，第十座是翡翠，第十一座是紫玛瑙，第十二座是紫晶。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_21","096_21_21","REV","21","21","21","十二个门由珍珠制成，每一个门都用一个珍珠打造。城里的街道是纯金的，好像透明的玻璃。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_22","096_21_22","REV","21","22","22","我在那里没有看见圣殿，因为主全能的上帝和羊羔就是城的圣殿。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_23","096_21_23","REV","21","23","23","这城不需要日月照明，因为有上帝的荣耀照明，而羊羔就是城市的灯。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_24","096_21_24","REV","21","24","24","所有国家要在它的光中行走，地上的国王要把他们的荣耀带到这城来。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_25","096_21_25","REV","21","25","25","城门白天决不关闭。在那里并没有黑夜。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_26","096_21_26","REV","21","26","26","所有国家的荣华尊贵都被带到这城。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV21_27","096_21_27","REV","21","27","27","不洁净的、拜神像的、说谎的，都不能进入——只有那些写在羔羊生命册上的才可以。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_1","096_22_1","REV","22","1","1","天使展示了生命水的河流，清澈透明，从上帝和羔羊的宝座流出来， ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_2","096_22_2","REV","22","2","2","就在城市主街的中央。河的两边是生命树，每月结果，共结十二次，树叶可以医治列国。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_3","096_22_3","REV","22","3","3","不再有任何咒诅。城里有上帝和羊羔的宝座，他的仆人都膜拜他。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_4","096_22_4","REV","22","4","4","他们会看到他的脸。他的名字会写在他们的额头。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_5","096_22_5","REV","22","5","5","不再有黑夜了，他们不再需要灯之光或太阳之光了，因为主上帝要光照他们，他们要作王，直到永远。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_6","096_22_6","REV","22","6","6","天使对我说：“这些话可信且真实。那将其灵给了众先知的主上帝，派来他的天使，把快发生的事，指示他的仆人。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_7","096_22_7","REV","22","7","7","“我马上到来！遵守这书上预言之人都会获得祝福！” ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_8","096_22_8","REV","22","8","8","我是约翰，听到并看到这一切。当我听到和看到他们时，就俯伏在天使面前膜拜他，因为他向我展示了这一切。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_9","096_22_9","REV","22","9","9","他对我说：“千万别这样！我和你、以及你的兄弟和众先知、以及那些遵守这书上文字的人，都是仆人。你应当膜拜上帝。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_10","096_22_10","REV","22","10","10","他又对我说：“不要封住这书上的预言，因为时间将至。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_11","096_22_11","REV","22","11","11","那些不做正确事情之人，让他们保持那样。那些不纯洁的人，让他们保持那样。那些做正确事情之人，让他们保持那样。那些圣洁的人，让他们保持那样。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_12","096_22_12","REV","22","12","12","“我马上到来！根据每个人的行为，将我的赏赐带给他们。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_13","096_22_13","REV","22","13","13","我是阿尔法和欧米茄，我是最初也是最后，是开始也是结束。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_14","096_22_14","REV","22","14","14","那些洗净自己长袍之人获得了祝福！他们可以有权到生命树那里，也可以从门走进城里。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_15","096_22_15","REV","22","15","15","城外的就是狗，行巫术的，淫乱的，杀人的，拜神像的，以及一切爱编造谎言的人。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_16","096_22_16","REV","22","16","16","我耶稣，派我的天使给你们这个见证，与众教会分享。我也是大卫的根和后裔，我是明亮的晨星。” ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_17","096_22_17","REV","22","17","17","圣灵和新娘说：“来吧！”听见的人也要说：“来吧！”口渴的人，来吧！愿意的人, 都可免费接受这生命的水！ ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_18","096_22_18","REV","22","18","18","我郑重地向所有听到这本预言书的人宣布，如果有在其中添加了什么，上帝就会把这本书中描述的灾难，添加在他们身上。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_19","096_22_19","REV","22","19","19","如果有人删减这书的预言，上帝必从这书中的生命树和圣城中，删去他那一部分。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_20","096_22_20","REV","22","20","20","确认这些事的那个人说：“是的，我马上到来！”阿门！来吧，主耶稣。 ");
INSERT INTO cmnfeb_vpl VALUES ("RV22_21","096_22_21","REV","22","21","21","愿主耶稣的恩典与所有信徒同在！阿门。 ");
ALTER TABLE cmnfeb_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
