﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmncbt_vpl;
CREATE TABLE cmncbt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmncbt_vpl WRITE;
INSERT INTO cmncbt_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","太初，上帝創造了天地。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","那時，大地空虛混沌，黑暗籠罩著深淵，上帝的靈運行在水面上。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","上帝說：「要有光！」就有了光。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","上帝看光是好的，就把光和黑暗分開。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","上帝稱光為晝，稱黑暗為夜。晚上過去，早晨到來，這是第一日。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","上帝說：「水與水之間要有穹蒼，把水分開。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","果然如此。上帝造了穹蒼，將穹蒼之下的水和穹蒼之上的水分開。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","上帝稱穹蒼為天空。晚上過去，早晨到來，這是第二日。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","上帝說：「天空下面的水要聚在一處，使乾地露出來。」果然如此。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","上帝稱乾地為陸地，稱匯聚的水為海洋。上帝看了，覺得美好。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","上帝說：「陸地要長出植物——各類結種子的菜蔬和結果子的樹木，果子內都有籽。」果然如此， ");
INSERT INTO cmncbt_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","陸地長出了植物——各類結種子的菜蔬和結果子的樹木，果子內都有籽。上帝看了，覺得美好。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","晚上過去，早晨到來，這是第三日。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","上帝說：「天空要有光體，以區分晝夜，作記號，定節令，計算年日， ");
INSERT INTO cmncbt_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","在天空發光，普照大地。」果然如此。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","上帝造了兩個大光體，大的管晝，小的管夜，又造了星辰。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","上帝把這些光體擺列在天空，讓它們發光普照大地， ");
INSERT INTO cmncbt_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","管理晝夜，分開光和黑暗。上帝看了，覺得美好。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","晚上過去，早晨到來，這是第四日。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","上帝說：「水中要充滿各種動物，空中要有禽鳥飛翔。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","上帝就創造了海中的大魚等各類水族和各類禽鳥。上帝看了，覺得美好。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","上帝賜福給這一切生物，說：「水族要多多地生養繁衍，充滿海洋，禽鳥也要在地上多多地繁衍。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","晚上過去，早晨到來，這是第五日。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","上帝說：「大地要繁衍各類動物——各類的牲畜、爬蟲和野獸。」果然如此。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","上帝造了地上的各類野獸、牲畜和爬蟲。上帝看了，覺得美好。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","上帝說：「我們要照著我們的形像，按著我們的樣式造人，讓他們管理海裡的魚、空中的鳥和地上的牲畜及一切爬蟲。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","上帝就照著自己的形像造了人，祂照著自己的形像造了男人和女人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","上帝賜福給他們，對他們說：「你們要生養眾多，遍滿地面，治理大地，管理海裡的魚、空中的鳥以及地上的各種動物。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","上帝說：「看啊，我把地上所有結種子的穀蔬和所有樹上有籽的果子，都賜給你們作食物。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","我把綠色植物賜給所有地上的走獸、空中的飛鳥，及地上的爬蟲等有氣息的動物作食物。」果然如此。 ");
INSERT INTO cmncbt_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","上帝看了祂所造的一切，覺得非常美好。晚上過去，早晨到來，這是第六日。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","天地萬物都造好了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","第七日，上帝完成了祂的創造之工，就在第七日歇了一切的工。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","上帝賜福給第七日，將其定為聖日，因為祂在這一日歇了祂一切的創造之工。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","這是有關創造天地的記載。 耶和華上帝創造天地的時候， ");
INSERT INTO cmncbt_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","地上還沒有草木，也沒有長出菜蔬，因為耶和華上帝還沒有降雨在地上，土地也沒有人耕作， ");
INSERT INTO cmncbt_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","但有水從地裡湧出，澆灌大地。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","耶和華上帝用地上的塵土造人，把生命的氣息吹進他的鼻孔裡，他就成了有生命的人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","耶和華上帝在東方的伊甸開闢了一個園子，把祂所造的人安置在裡面。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","耶和華上帝使地裡長出各種樹木，它們既好看又有好吃的果子。在園子的中間有生命樹和分別善惡的樹。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","有一條河從伊甸流出來灌溉那園子，又從那裡分成四條河流。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","第一條支流叫比遜河，它環繞著哈腓拉全境，那裡有金子， ");
INSERT INTO cmncbt_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","且是上好的金子，還有珍珠和紅瑪瑙。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","第二條支流叫基訓河，它環繞著古實全境。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","第三條支流叫底格里斯河，它流經亞述的東邊。第四條支流叫幼發拉底河。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","耶和華上帝把那人安置在伊甸的園子裡，讓他在那裡耕種、看管園子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","耶和華上帝吩咐那人說：「你可以隨意吃園中各種樹上的果子， ");
INSERT INTO cmncbt_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","只是不可吃那棵分別善惡樹的果子，因為你吃的日子必定死。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","耶和華上帝說：「那人獨自一人不好，我要為他造一個相配的幫手。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","耶和華上帝用塵土造了各種田野的走獸和空中的飛鳥，把牠們帶到那人跟前，看他怎麼叫牠們。他叫這些動物什麼，牠們的名字就是什麼。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","那人給所有的牲畜及空中的飛鳥和田野的走獸都起了名字。可是他找不到一個跟自己相配的幫手。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","耶和華上帝使那人沉睡，然後在他沉睡的時候從他身上取出一根肋骨，再把肉合起來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","耶和華上帝用那根肋骨造了一個女人，把她帶到那人跟前。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","那人說： 「這才是我骨中的骨， 肉中的肉， 要稱她為女人， 因為她是從男人身上取出來的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","因此，人要離開父母，與妻子結合，二人成為一體。 ");
INSERT INTO cmncbt_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","當時，他們夫婦二人都赤身露體，並不覺得羞恥。 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","在耶和華上帝所造的田野的各種動物中，蛇最狡猾。蛇對女人說：「上帝真的說過『你們不可吃園中任何樹上的果子』嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","女人回答說：「我們可以吃園中樹上的果子， ");
INSERT INTO cmncbt_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","只是上帝說過，『你們不可吃園子中間那棵樹的果子，也不可摸，免得死亡。』」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","蛇對女人說：「你們一定不會死！ ");
INSERT INTO cmncbt_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","上帝那樣說是因為祂知道，你們吃了那樹的果子以後，眼睛就會打開，像上帝一樣懂得分辨善惡。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","女人見那棵樹上的果子可口，悅人眼目，可使人有智慧，就摘下來吃了。她又把果子給跟她在一起的丈夫，他也吃了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","二人的眼睛就打開了，發覺自己原來赤身露體，便編起無花果樹的葉子來遮體。 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","天起涼風時，那人和他妻子聽見耶和華上帝在園中行走的聲音，就藏在園子的樹叢中，想躲避耶和華上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","耶和華上帝呼喚那人說：「你在哪裡？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","那人說：「我在園中聽見你的聲音，就害怕得躲了起來，因為我赤身露體！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","耶和華上帝問：「誰告訴你，說你赤身露體？難道你吃了我吩咐你不可吃的果子嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","那人說：「你賜給我作伴的女人把那樹上的果子給我，我就吃了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","耶和華上帝對女人說：「你這是做的什麼事？」女人說：「是蛇誘騙我，我才吃的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","耶和華上帝對蛇說： 「你既然做了這事， 你要比一切牲畜和野獸受更重的咒詛， 你要用肚子爬行， 一生都要吃塵土。 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","我要使你和女人結仇， 你的後裔和女人的後裔也要彼此為仇， 女人的後裔必傷你的頭， 你必傷他的腳跟。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","耶和華上帝對女人說： 「我必大大加重你懷孕的痛苦， 你分娩時必受痛苦。 你必戀慕自己的丈夫， 你的丈夫必管轄你。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","耶和華上帝又對亞當說： 「因為你聽從妻子的話， 吃了我吩咐你不可吃的那樹上的果子， 地必因你而受咒詛。 你必終生艱辛勞苦， 才能吃到地裡出產的食物。 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","地必給你長出荊棘和蒺藜， 你要吃田間長出來的菜蔬。 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","你必汗流滿面，才有飯吃， 一直到你歸回土地。 因為那是你的本源。 你本是塵土，也必歸回塵土。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","亞當給他的妻子取名叫夏娃，因為她是眾生之母。 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","耶和華上帝做了皮衣給他們夫婦穿上。 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","耶和華上帝說：「看啊，那人已經與我們相似，能分辨善惡。現在，恐怕他會伸手去摘生命樹的果子吃，就永遠活著。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","因此，耶和華上帝就把亞當趕出伊甸園，讓他去開墾土地——那是他的本源。 ");
INSERT INTO cmncbt_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","祂趕走了亞當以後，在伊甸園東邊安排基路伯天使和一把旋轉的火劍，守住通往生命樹的路。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","亞當和他妻子夏娃同房，夏娃便懷孕，生了該隱。她說：「耶和華讓我得了一個男孩。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","後來，夏娃又生了該隱的弟弟亞伯。亞伯做了牧羊人，該隱做了農夫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","過了些日子，該隱把地裡的出產當祭物獻給耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","亞伯也把羊群中頭生的羊及其最肥美的部分獻給耶和華。耶和華悅納亞伯和他的祭物， ");
INSERT INTO cmncbt_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","卻不悅納該隱和他的祭物。該隱便非常惱火，面色陰沉。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","耶和華問該隱：「你為什麼惱火？為什麼面色陰沉？ ");
INSERT INTO cmncbt_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","如果你做得對，難道不會蒙悅納嗎？如果你做得不對，罪就蹲伏在你的門口，要控制你，但你必須制伏罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","該隱對弟弟亞伯說：「我們去田間吧！」他們在田間的時候，該隱動手打亞伯，把他殺了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","後來，耶和華問該隱：「你弟弟亞伯在哪裡？」他說：「我不知道！難道我是我弟弟的看護人嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","耶和華說：「你做了什麼事？你弟弟的血從地裡向我哭訴。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","地張開口從你手上接受了你弟弟的血，現在你在地上必受咒詛。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","你種地，地卻不會再為你效力，你必在地上四處漂泊。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","該隱對耶和華說：「這懲罰太重！我承受不了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","今天你把我從此地趕出去，使我不能再見你的面。我在地上四處漂泊，見到我的人都會殺我。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","耶和華對他說：「不會的，因為凡殺你的，必遭受七倍的報應。」於是，耶和華在該隱身上留下一個記號，免得見到他的人殺他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","該隱離開耶和華，來到伊甸東邊的挪得住下來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","該隱和妻子同房，他的妻子就懷孕，生了以諾。該隱建了一座城，用他兒子的名字給這城取名叫以諾。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","以諾生以拿，以拿生米戶雅利，米戶雅利生瑪土撒利，瑪土撒利生拉麥。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","拉麥娶了兩個妻子，一個叫亞大，另一個叫洗拉。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","亞大生了雅八，雅八是遊牧民族的祖先， ");
INSERT INTO cmncbt_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","雅八的弟弟叫猶八，他是彈琴吹笛之人的鼻祖。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","洗拉生了土八·該隱，他是打造各種銅鐵器具的匠人，他的妹妹叫拿瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","拉麥對他的兩個妻子說： 「亞大，洗拉，你們聽我的聲音； 拉麥的妻子啊，側耳聽我的話， 有人傷我，我殺了他， 青年打我，我宰了他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","殺該隱的遭受七倍的報應， 殺拉麥的遭受七十七倍的報應。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","亞當又與妻子夏娃同房，夏娃生了一個兒子，取名叫塞特，因為她說：「上帝賜我另一個兒子來代替亞伯，因為該隱殺了他。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","塞特生了一個兒子，給他取名叫以挪士。那時候，人開始求告耶和華的名。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","以下是關於亞當後代的記載。 上帝造人的時候，是照祂自己的樣式造的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","祂造了男人和女人，又賜福給他們，並在造他們的那日稱他們為「人」。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","亞當一百三十歲時生了一子，樣式和形像與自己相似，就給他取名叫塞特。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","亞當生了塞特以後，又活了八百年，生兒育女， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","共活了九百三十歲才去世。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","塞特一百零五歲時生以挪士， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","之後又活了八百零七年，生兒育女， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","共活了九百一十二歲才去世。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","以挪士九十歲時生該南， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","之後又活了八百一十五年，生兒育女， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","共活了九百零五歲才去世。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","該南七十歲時生瑪勒列， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","之後又活了八百四十年，生兒育女， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","共活了九百一十歲才去世。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","瑪勒列六十五歲時生雅列， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","之後又活了八百三十年，生兒育女， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","共活了八百九十五歲才去世。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","雅列一百六十二歲時生以諾， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","之後又活了八百年，生兒育女， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","共活了九百六十二歲才去世。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","以諾六十五歲時生瑪土撒拉， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","之後與上帝親密同行三百年，生兒育女， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","共活了三百六十五歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","以諾與上帝親密同行，後來被上帝接去，不在世上了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","瑪土撒拉一百八十七歲時生拉麥， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","之後又活了七百八十二年，生兒育女， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","共活了九百六十九歲才去世。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","拉麥一百八十二歲時生了一個兒子， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","取名叫挪亞，他說：「耶和華咒詛了大地，這孩子必使我們從艱辛勞苦中得安慰。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","拉麥生挪亞之後，又活了五百九十五年，生兒育女， ");
INSERT INTO cmncbt_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","共活了七百七十七歲才去世。 ");
INSERT INTO cmncbt_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","挪亞五百歲後生閃、含和雅弗。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","當時，人類在地上開始逐漸增多，生了女兒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","上帝的兒子們看見人的女兒漂亮，就隨意選來做妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","耶和華說：「人既然是血肉之軀，我的靈不會永遠住在人的裡面，然而人還可以活一百二十年。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","從上帝的兒子和人的女兒交合生子起，地上出現了巨人，他們是上古英武有名的人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","耶和華看見人在地上罪惡深重，心裡終日思想的都是惡事， ");
INSERT INTO cmncbt_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","就後悔在地上造了人，心裡傷痛， ");
INSERT INTO cmncbt_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","說：「我要把所造的人，連同一切飛禽走獸和爬蟲從地上都毀滅，因為我後悔造了他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","只有挪亞在耶和華面前蒙恩。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","以下是有關挪亞的記載。 挪亞是個義人，在當時的世代是個純全無過的人，他與上帝同行。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","挪亞生了三個兒子：閃、含和雅弗。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","那時大地在上帝眼中敗壞了，充滿了暴行。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","上帝看見大地敗壞了，因為世人都行為敗壞。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","祂對挪亞說：「我決定消滅世人，因為他們使大地充滿暴行。我要把他們和大地一起毀滅。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","你要為自己用歌斐木建造一艘方舟，裡面要有艙房，內外都要塗上柏油。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","你建造的方舟要長一百三十五米，寬二十二米半，高十三米半。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","舟頂要有四十五釐米高的透光口，門開在方舟的側面，整艘方舟要分為上、中、下三層。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","看啊，我要使洪水在地上氾濫，毀滅天下一切有生命氣息的活物，地上的一切都要滅亡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","但我要和你立約，你與妻子、兒子和兒媳都可以進方舟。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","每樣動物你要帶兩隻進方舟，雌雄各一隻，好保存牠們的生命。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","各類飛禽走獸和爬蟲每樣一對都要到你那裡，好保全生命。 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","你要為自己和這些動物預備各種食物，貯存起來。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","挪亞就照著上帝的吩咐把事情都辦好了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","耶和華對挪亞說：「你和你全家都進入方舟，因為這個世代只有你在我眼中是義人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","潔淨的動物，你要每樣帶七公七母，不潔淨的動物每樣帶一公一母， ");
INSERT INTO cmncbt_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","飛鳥每樣帶七公七母，叫牠們以後可以在地上繁衍後代。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","因為七天之後，我要在地上降雨四十晝夜，從地上毀滅我所造的一切活物。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","凡耶和華所吩咐的，挪亞都照辦了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","洪水在大地上氾濫那年，挪亞六百歲了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","挪亞與妻子、兒子們和兒媳們都進了方舟，躲避洪水。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","潔淨的動物、不潔淨的動物、飛禽和地上的一切爬蟲， ");
INSERT INTO cmncbt_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","都一公一母成對地到挪亞那裡，進了方舟，正如上帝對挪亞的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","七天過後，洪水在地上氾濫起來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","挪亞六百歲那年的二月十七日，所有深淵的泉源都裂開了，天上的水閘也打開了， ");
INSERT INTO cmncbt_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","地上大雨降了四十晝夜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","就在那天，挪亞與他的兒子閃、含和雅弗，還有挪亞的妻子和三個兒媳婦都進了方舟。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","所有的野獸、牲畜、地上的爬蟲和飛鳥，都按種類進入方舟。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","一切有生命氣息的活物都成對地到挪亞那裡，進入方舟。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","所有進入方舟的動物都是一公一母，正如上帝對挪亞的吩咐。然後，耶和華關上了方舟的門。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","洪水在地上氾濫了四十天，水不斷往上漲，把方舟漂了起來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","洪水來勢洶洶，淹沒大地，方舟漂浮在水面上。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","水勢越來越大，把天下各處的高山都淹沒了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","水淹沒了群山，高出群山七米。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","地上所有的飛禽、走獸、牲畜、爬蟲等動物和人類都死了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","陸地上所有鼻孔有生命氣息的活物都死了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","地上的人類、飛禽走獸和爬蟲等一切活物都被毀滅了，只剩下挪亞和跟他同在方舟裡的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","洪水淹沒大地一百五十天。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","上帝眷顧挪亞及方舟裡的野獸和牲畜，就使風吹在大地上，水便開始消退。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","深淵的泉源和天上的水閘都關閉了，大雨也停了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","地上的洪水慢慢消退，過了一百五十天，水退下去了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","七月十七日，方舟停在亞拉臘山上。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","水繼續消退一直到十月，到十月一日，山頂都露出來了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","又過了四十天，挪亞打開他在方舟上所造的窗戶， ");
INSERT INTO cmncbt_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","放出一隻烏鴉。牠一直在空中飛來飛去，直到地上的水都乾了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","然後，挪亞放出一隻鴿子，以便瞭解地面的水是否已經消退。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","但遍地都是水，鴿子找不到歇腳的地方，就飛回了方舟，挪亞伸手把鴿子接進方舟裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","挪亞又等了七天，再把鴿子放出去。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","到了黃昏，鴿子飛回來，嘴裡啣著一片新擰下來的橄欖葉，挪亞便知道地上的水已經退了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","他又等了七天，再放出鴿子，這次鴿子沒有回來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","挪亞六百零一歲那年的一月一日，地上的水乾了。挪亞打開方舟的蓋觀望，看見地面都乾了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","到了二月二十七日，大地完全乾了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","上帝對挪亞說： ");
INSERT INTO cmncbt_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","「你與妻子、兒子和兒媳都要出方舟。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","你要把方舟裡的飛禽走獸及爬蟲等所有動物都帶出來，讓牠們在地上多多滋長，生養繁衍。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","於是，挪亞與妻子、兒子和兒媳都出了方舟。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","方舟裡的飛禽走獸和爬蟲等所有地上的動物，都按種類出了方舟。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","挪亞為耶和華築了一座壇，在上面焚燒各種潔淨的牲畜和飛鳥作為燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","耶和華聞到這燔祭的馨香，心想：「雖然人從小就心存惡念，但我再不會因為人的緣故而咒詛大地，再不會像這次一樣毀滅一切活物了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","只要大地尚存，播種收割、夏熱冬寒、白晝黑夜必不停息。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","上帝賜福給挪亞和他的兒子們，對他們說：「你們要生養眾多，遍佈地面。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","所有地上的走獸和爬蟲、空中的飛鳥及海裡的魚，都必懼怕你們，牠們都歸你們管理。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","凡是活的動物都可作你們的食物，就像綠色菜蔬一樣，我把一切都賜給你們了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","只是你們不可吃帶血的肉，因為血就是生命。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","凡是殺害你們的，無論人或獸，我必向他們追討血債。凡殺人的，我必追討他的血債。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","凡殺害人的，也必被人殺害，因為人是上帝照著自己的形像造的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","你們要生養眾多，使地上人口興旺。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","上帝又對挪亞和他身邊的兒子們說： ");
INSERT INTO cmncbt_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","「我要跟你們和你們的後代立約， ");
INSERT INTO cmncbt_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","包括所有和你們在一起的生物，就是那些和你們一起從方舟出來的飛禽走獸和牲畜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","我與你們立約，不再讓洪水滅絕一切生命，也不再讓洪水毀滅大地。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","上帝說：「我與你們及所有和你們在一起的生物立世代永存的約，這是我立約的記號。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","我把彩虹放在雲中，作為我跟大地立約的記號。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","我使雲彩覆蓋大地的時候，會有彩虹在雲中出現。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","這樣我會顧念我與你們及一切有血氣的生物所立的約，水就不會再氾濫、毀滅所有生命。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","當我看見彩虹在雲中出現的時候，就會顧念我與地上一切活物立的永遠之約。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","上帝對挪亞說：「這是我與地上一切生命立約的記號。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","與挪亞一起出方舟的有他的兒子閃、含、雅弗。含是迦南的父親。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","這是挪亞的三個兒子，他們的後代遍佈天下。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","挪亞做了農夫，他是第一個栽種葡萄園的人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","一天，他喝葡萄酒喝醉了，赤裸著身體躺在帳篷裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","迦南的父親含看見父親赤身露體，便去告訴外面的兩個弟兄。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","於是，閃和雅弗拿了一件衣服搭在肩上，倒退著走進帳篷，把衣服蓋在父親身上，他們背著臉不看父親赤裸的身體。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","挪亞酒醒後，知道了小兒子做的事， ");
INSERT INTO cmncbt_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","就說： 「迦南該受咒詛， 必做他弟兄的僕人的僕人。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","又說： 「閃的上帝耶和華當受稱頌！ 願迦南做閃的僕人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","願上帝擴張雅弗的疆界， 願他住在閃的帳篷裡， 願迦南做他的僕人。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","洪水以後，挪亞又活了三百五十年， ");
INSERT INTO cmncbt_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","共活了九百五十歲才去世。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","洪水以後，挪亞的兒子閃、含和雅弗都生了兒子，以下是他們的後代。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","雅弗的兒子是歌篾、瑪各、瑪代、雅完、土巴、米設、提拉。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","歌篾的兒子是亞實基拿、利法、陀迦瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","雅完的兒子是以利沙、他施、基提、多單。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","雅弗的這些後代各按宗族、語言和民族分散在沿海自己的國土上。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","含的兒子是古實、麥西、弗、迦南。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","古實的兒子是西巴、哈腓拉、撒弗他、拉瑪、撒弗提迦。拉瑪的兒子是示巴和底但。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","古實也是寧錄之父，寧錄是世上第一位勇士， ");
INSERT INTO cmncbt_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","在耶和華眼中是個孔武有力的獵人，因此有俗話說：「要像寧錄那樣在耶和華眼中是個孔武有力的獵人。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","他首先在示拿地區的巴別、以力、亞甲、甲尼各地建國， ");
INSERT INTO cmncbt_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","後來擴展到亞述，在那裡建立了尼尼微、利河伯、迦拉， ");
INSERT INTO cmncbt_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","以及尼尼微與迦拉之間的利鮮大城。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","麥西的後代有路低人、亞拿米人、利哈比人、拿弗土希人、 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","帕斯魯細人、迦斯路希人和迦斐托人。非利士人是迦斐托人的後代。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","迦南生長子西頓和次子赫， ");
INSERT INTO cmncbt_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","他的後代還有耶布斯人、亞摩利人、革迦撒人、 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","希未人、亞基人、西尼人、 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","亞瓦底人、洗瑪利人和哈馬人。後來迦南各宗族散居在各地。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","迦南的疆域從西頓向基拉耳延伸，遠至迦薩，再向所多瑪、蛾摩拉、押瑪、洗扁延伸，遠至拉沙。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","以上記載的都是含的子孫，他們根據自己的宗族、語言、國土和民族散居各處。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","雅弗的哥哥閃是希伯子孫的祖先，他也生了兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","閃的兒子是以攔、亞述、亞法撒、路德、亞蘭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","亞蘭的兒子是烏斯、戶勒、基帖、瑪施。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","亞法撒生沙拉，沙拉生希伯， ");
INSERT INTO cmncbt_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","希伯有兩個兒子，一個名叫法勒，因為那時人們分地而居。法勒的兄弟叫約坍。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","約坍生亞摩答、沙列、哈薩瑪非、耶拉、 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","哈多蘭、烏薩、德拉、 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","俄巴路、亞比瑪利、示巴、 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","阿斐、哈腓拉、約巴。這些都是約坍的兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","他們居住的地方，從米沙直到東邊的西發山區。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","以上記載的都是閃的子孫，他們按著自己的宗族、語言、國土和民族散居各處。 ");
INSERT INTO cmncbt_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","這些人都是洪水以後挪亞三個兒子所生的子孫，他們按著自己的民族和家系散居在各地，繁衍出地上各個民族。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","那時，天下人都用同一種語言，講同一種話。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","人們向東遷移時，在示拿地區找到一處平原，定居下來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","他們彼此商量說：「來呀，我們製作磚，把磚燒透吧。」他們用磚作石塊，用柏油作灰泥來造塔， ");
INSERT INTO cmncbt_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","說：「來吧，讓我們造一座城和一座高聳入雲的塔，這樣我們可以為自己揚名，不致分散在普天之下。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","耶和華下來察看人建造的城和塔。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","耶和華說：「看啊，他們同屬一個民族，都用同一種語言，現在就開始做這樣的事，如果繼續下去，他們會為所欲為。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","來吧，我們下去變亂他們的語言，使他們彼此言語不通。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","於是，耶和華把他們從那裡分散到普天之下，他們便停止建城了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","因此，人稱那城為巴別，因為耶和華在那裡變亂了世人的語言，把他們分散到普天之下。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","以下是閃的後代。 洪水過後兩年，閃一百歲時生亞法撒， ");
INSERT INTO cmncbt_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","之後又活了五百年，生兒育女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","亞法撒三十五歲時生沙拉， ");
INSERT INTO cmncbt_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","之後又活了四百零三年，生兒育女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","沙拉三十歲時生希伯， ");
INSERT INTO cmncbt_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","之後又活了四百零三年，生兒育女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","希伯三十四歲時生法勒， ");
INSERT INTO cmncbt_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","之後又活了四百三十年，生兒育女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","法勒三十歲時生拉吳， ");
INSERT INTO cmncbt_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","之後又活了二百零九年，生兒育女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","拉吳三十二歲時生西鹿， ");
INSERT INTO cmncbt_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","之後又活了二百零七年，生兒育女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","西鹿三十歲時生拿鶴， ");
INSERT INTO cmncbt_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","之後又活了二百年，生兒育女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","拿鶴二十九歲時生他拉， ");
INSERT INTO cmncbt_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","之後又活了一百一十九年，生兒育女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","他拉七十歲後，生了亞伯蘭、拿鶴和哈蘭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","以下是他拉的後代。 他拉生亞伯蘭、拿鶴和哈蘭，哈蘭生羅得。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","哈蘭比他父親他拉先去世，他死在自己的家鄉迦勒底的吾珥。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","亞伯蘭和拿鶴都娶了妻子，亞伯蘭的妻子名叫撒萊，拿鶴的妻子名叫密迦，是哈蘭的女兒。哈蘭是密迦和亦迦的父親。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","撒萊不能生育，沒有孩子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","他拉帶著兒子亞伯蘭、孫子——哈蘭的兒子羅得、兒媳婦——亞伯蘭的妻子撒萊，離開迦勒底的吾珥前往迦南，他們來到哈蘭，在那裡定居下來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","他拉在那裡去世，享年二百零五歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","耶和華對亞伯蘭說：「你要離開家鄉、親族和父親的家，到我要指示你的地方去。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","我必使你成為大國，我必賜福給你，使你聲名遠揚。你必成為別人的祝福。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","我必賜福給那些祝福你的人，咒詛那些咒詛你的人。世上萬族必因你而蒙福。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","亞伯蘭就照耶和華的吩咐離開哈蘭，侄兒羅得與他同行。那時亞伯蘭七十五歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","亞伯蘭帶著妻子撒萊、侄兒羅得以及在哈蘭積攢的財物和所得的奴僕，啟程來到迦南。到了迦南以後， ");
INSERT INTO cmncbt_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","亞伯蘭繼續前行，來到示劍的摩利橡樹那裡。當時迦南人住在那地方。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","耶和華向亞伯蘭顯現，對他說：「我要把這片土地賜給你的後裔。」亞伯蘭就在那裡為向他顯現的耶和華築了一座壇。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","然後，他們又啟程前往伯特利東面的山區，在那裡搭起帳篷。他們的西面是伯特利，東面是艾。亞伯蘭又在那裡築了一座壇，求告耶和華的名。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","之後，亞伯蘭繼續前往南地。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","那地方遭遇饑荒，災情非常嚴重，亞伯蘭便下到埃及暫住。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","快要到埃及的時候，他對妻子撒萊說：「我知道你是個美貌的女子， ");
INSERT INTO cmncbt_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","埃及人看見你，一定會因為你是我的妻子而殺了我，讓你活著。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","所以，請你說你是我的妹妹，這樣他們會因為你而善待我，留我一命。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","亞伯蘭一行到了埃及，撒萊的美貌引起了埃及人的注意。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","法老的官員見了撒萊，就在法老面前稱讚她的美貌，她便被帶進法老的王宮。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","因為撒萊的緣故，法老厚待亞伯蘭，賞給他許多牛、羊、驢、駱駝和僕婢。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","耶和華因亞伯蘭妻子撒萊的緣故，使法老和他全家患重病。 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","法老便召見亞伯蘭，說：「你對我做的是什麼事？為什麼不告訴我她是你妻子？ ");
INSERT INTO cmncbt_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","為什麼說她是你妹妹，以致我要娶她為妻呢？現在你妻子在這裡，帶她走吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","法老就吩咐人把亞伯蘭、他妻子以及他所有的一切都送走了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","亞伯蘭帶著妻子、侄兒羅得和所有的一切，離開埃及去南地。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","那時亞伯蘭已經擁有很多牲畜和金銀。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","他從南地漸漸遷移到伯特利，到了他從前在伯特利和艾中間搭帳篷和築壇的地方。他又在那裡求告耶和華的名。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","和亞伯蘭同行的羅得也有牛群、羊群和帳篷。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","他們的牲畜很多，那地方容納不下，他們無法住在一起。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","亞伯蘭的牧人和羅得的牧人之間起了紛爭。那時，迦南人和比利洗人也住在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","亞伯蘭對羅得說：「我們之間不該有紛爭，我們的牧人之間也不該有紛爭，因為我們是骨肉至親。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","整片土地不就在你面前嗎？我們分開吧。如果你往左邊去，我就往右邊走；如果你往右邊去，我就往左邊走。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","羅得舉目眺望，看見整個約旦河平原，遠至瑣珥，水源充足。在耶和華毀滅所多瑪和蛾摩拉之前，那地方就好像耶和華的園子，又像埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","於是，羅得選了整個約旦河平原，向東遷移，他們便分開了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","亞伯蘭住在迦南，羅得則住在平原的城邑裡，並漸漸把帳篷遷移到所多瑪附近。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","所多瑪人極其邪惡，在耶和華眼中罪惡滔天。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","羅得離開後，耶和華對亞伯蘭說：「從你站的地方向東西南北眺望， ");
INSERT INTO cmncbt_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","你所能看見的地方，我都要賜給你和你的後裔，直到永遠。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","我要使你的後裔多如地上的塵土，人若能數算地上的塵土，才能數算你的後裔。 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","你起來走遍這片土地，因為我要把這片土地賜給你。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","亞伯蘭就把帳篷遷移到希伯崙，在幔利的橡樹附近居住，在那裡為耶和華築了一座祭壇。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","那時，示拿王暗拉非、以拉撒王亞略、以攔王基大老瑪和戈印王提達聯合攻打以下五王：所多瑪王比拉、蛾摩拉王比沙、押瑪王示納、洗扁王善以別和比拉王，即瑣珥王。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","五王會師西訂谷，即鹽海。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","他們受基大老瑪統治十二年，在第十三年叛變了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","第十四年，基大老瑪聯合其他王在亞特律·加寧打敗利乏音人，在哈麥打敗蘇西人，在沙微·基列亭打敗以米人， ");
INSERT INTO cmncbt_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","在西珥山打敗住在那裡的何利人，直殺到靠近曠野的伊勒·巴蘭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","然後，他們返回安·密巴，即加低斯，征服了亞瑪力全境以及住在哈洗遜·他瑪的亞摩利人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","那時，所多瑪王、蛾摩拉王、押瑪王、洗扁王和比拉王，即瑣珥王出戰，在西訂谷擺開陣勢， ");
INSERT INTO cmncbt_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","抵抗以攔王基大老瑪、戈印王提達、示拿王暗拉非和以拉撒王亞略：四王跟五王交戰。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","西訂谷佈滿柏油坑，所多瑪王和蛾摩拉王敗走的時候，有些人掉進坑裡，其他人都往山上逃命。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","四王把所多瑪和蛾摩拉所有的財物和糧食洗劫一空，揚長而去， ");
INSERT INTO cmncbt_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","並劫走亞伯蘭的侄兒羅得和他的財物，那時羅得正住在所多瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","有一個逃出來的人把這件事情告訴了希伯來人亞伯蘭。那時，亞伯蘭住在亞摩利人幔利的橡樹那裡。幔利是以實各和亞乃的兄弟，三人都是亞伯蘭的盟友。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","亞伯蘭聽見侄兒被擄的消息，便率領家中三百一十八名訓練有素的壯丁去追趕他們，一直追到但。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","夜裡，亞伯蘭和他的隨從分頭出擊，大敗他們，一直追殺到大馬士革北面的何巴， ");
INSERT INTO cmncbt_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","奪回所有被劫的財物，並救出他侄兒羅得及其財物、婦女和其他人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","亞伯蘭大敗基大老瑪及其盟軍各王凱旋的時候，所多瑪王到沙微谷來迎接。沙微谷即王谷。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","撒冷王麥基洗德也帶著餅和酒出來相迎，他是至高上帝的祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","他祝福亞伯蘭說： 「願創造天地的主、至高的上帝賜福給亞伯蘭！ ");
INSERT INTO cmncbt_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","將敵人交在你手中的至高上帝當受稱頌！」 於是，亞伯蘭把所得財物的十分之一給了他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","所多瑪王對亞伯蘭說：「請把我的人民交還給我，你可以把財物拿去。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","亞伯蘭對他說：「我向創造天地的主、至高的上帝耶和華舉手起誓， ");
INSERT INTO cmncbt_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","凡是你的東西，就是一根線、一條鞋帶，我都不會拿，免得你說，『我使亞伯蘭發了財！』 ");
INSERT INTO cmncbt_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","除了我的隨從已經吃用的以外，我什麼也不要。至於我的盟友亞乃、以實各和幔利所當得之份，請讓他們拿去。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","這些事以後，耶和華在異象中對亞伯蘭說：「亞伯蘭，你不要害怕，我是你的盾牌，我要大大賞賜你。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","亞伯蘭說：「主耶和華啊，你要賜我什麼呢？我沒有兒子，繼承我家業的人是大馬士革人以利以謝。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","亞伯蘭又說：「你沒有賜我後裔，我家中的僕人將繼承我的產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","耶和華對他說：「這人不會成為你的繼承人，你親生的兒子才是你的繼承人。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","耶和華把亞伯蘭帶到外面，對他說：「你抬頭看看天空，數數繁星，你能數得盡嗎？」接著又對他說：「你的後裔必這麼多。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","亞伯蘭信耶和華，耶和華便算他為義人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","耶和華又對他說：「我是耶和華，我帶你離開了迦勒底的吾珥，為要把這片土地賜給你作產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","亞伯蘭說：「主耶和華啊，我怎麼知道我會得到這片土地呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","耶和華說：「你要給我預備三歲的母牛、母山羊和公綿羊各一頭，斑鳩和雛鴿各一隻。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","亞伯蘭一一照辦，把牲畜都劈成兩半，一半對著一半地擺列，但沒有劈開鳥。 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","有鷙鳥飛到那些屍體上，亞伯蘭趕走了牠們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","太陽下山的時候，亞伯蘭睡得很沉，忽然有可怕的黑暗籠罩著他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","耶和華對他說：「你要清楚知道，你的後裔必流落異鄉，被奴役和虐待四百年。 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","但我必懲罰那奴役他們的國家，之後他們必帶著大量財物離開那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","而你必享長壽，得到安葬，歸到列祖那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","到了第四代，你的子孫必重回此地，因為亞摩利人現在還沒有惡貫滿盈。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","太陽下山，夜幕降臨，突然有冒煙的火爐和點著的火炬在肉塊中經過。 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","就在那天，耶和華跟亞伯蘭立約，說：「我必將這片土地賜給你的後裔，從埃及河一直延伸到幼發拉底大河， ");
INSERT INTO cmncbt_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","就是基尼人、基尼洗人、甲摩尼人、 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","赫人、比利洗人、利乏音人、 ");
INSERT INTO cmncbt_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","亞摩利人、迦南人、革迦撒人和耶布斯人的土地。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","亞伯蘭的妻子撒萊沒有給他生孩子。撒萊有個婢女名叫夏甲，是埃及人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","撒萊對亞伯蘭說：「耶和華不讓我生育，請你與我的婢女同房，也許我可以藉著她得子立後。」亞伯蘭同意了撒萊的話。 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","於是，撒萊把埃及婢女夏甲給亞伯蘭做妾。那時亞伯蘭已經在迦南住了十年。 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","亞伯蘭與夏甲同房，她就懷了孕。夏甲知道自己懷了孕，就輕視女主人撒萊。 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","撒萊對亞伯蘭說：「我受氣都是因為你。我把婢女放在你懷裡，她仗著自己懷了孕就輕視我，願耶和華在你我之間主持公道。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","亞伯蘭對撒萊說：「婢女在你手中，隨你處置。」於是，撒萊苦待夏甲，夏甲就逃走了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","耶和華的天使在曠野中，通往書珥之路的水泉旁找到了夏甲， ");
INSERT INTO cmncbt_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","便問她：「撒萊的婢女夏甲，你從哪裡來？要到哪裡去？」她回答說：「我是從女主人撒萊那裡逃出來的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","耶和華的天使對她說：「你要回到女主人那裡順服她。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","又說：「我必使你的後裔多得不可勝數。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","接著又說：「你現在懷了孕，將來會生一個男孩，你要給他取名叫以實瑪利，因為耶和華已經聽見你痛苦的哀聲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","這孩子性情必像野驢，他要跟人作對，人也要跟他作對。他必與他所有的弟兄為敵。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","夏甲稱對她說話的耶和華為「看顧人的上帝」，她說：「我竟然在這裡看見了那位看顧我的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","因此，那口井被稱為庇耳·拉海·萊，位於加低斯和巴列之間。 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","後來夏甲為亞伯蘭生了一個兒子，亞伯蘭給他取名叫以實瑪利。 ");
INSERT INTO cmncbt_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","夏甲生以實瑪利時，亞伯蘭八十六歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","亞伯蘭九十九歲那年，耶和華向他顯現說：「我是全能的上帝。你要遵行我的旨意，做純全無過的人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","我要與你立約，我要使你子孫極其繁盛。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","亞伯蘭就俯伏在地，上帝又對他說： ");
INSERT INTO cmncbt_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","「我要與你立約，你必成為萬族之父。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","以後你的名字不再叫亞伯蘭，要改為亞伯拉罕，因為我已立你為萬族之父。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","我要使你生養眾多，民族必由你而生，君王必從你而出。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","我要和你並你的子子孫孫立永遠的約，我要做你和你子孫的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","我要把你現在寄居的整個迦南，賜給你和你的子孫永遠作產業，我也必做他們的上帝。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","上帝又對亞伯拉罕說：「你和你的子孫世世代代都要遵守我的約。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","你們所有的男子都要受割禮，這是我與你和你的子孫所立的約，你們要遵守。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","你們都要割包皮，作為我與你們立約的記號。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","你們世世代代的男子，在出生後的第八日都要接受割禮，包括在你家裡出生的和用錢從外族人那裡買來的奴僕。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","不論是在你家裡生的，還是你用錢買來的男子，都要接受割禮，這樣我的約就在你們的肉體上成為永遠的約。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","任何沒有接受割禮的男子，要將他從民中剷除，因為他違背了我的約。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","上帝對亞伯拉罕說：「你的妻子撒萊以後不要叫撒萊，她的名字要叫撒拉。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","我必賜福給她，讓她為你生一個兒子。我必賜福給她，讓她成為列國之母，列邦的君王必從她而出。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","亞伯拉罕就俯伏在地，笑了起來，心想：「一百歲的人還能有孩子嗎？撒拉已經九十歲了，還能生育嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","亞伯拉罕對上帝說：「願以實瑪利蒙你賜福。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","上帝說：「不，你妻子撒拉必為你生一個兒子，你要給他取名叫以撒，我必與他堅立我的約，作為他後代永遠的約。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","至於以實瑪利，我已聽見你的祈求，我必賜福給他，使他生養眾多、子孫極其繁盛。他必做十二個族長的父親，我必使他成為大國。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","撒拉必在明年這時候給你生以撒，我必向他堅守我的約。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","上帝說完以後，便離開亞伯拉罕上升而去。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","亞伯拉罕就在那天照著上帝的吩咐，為兒子以實瑪利和家中所有的男子，不論是在家中出生的，還是買回來的，都行了割禮。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","亞伯拉罕接受割禮的時候九十九歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","他的兒子以實瑪利接受割禮的時候十三歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","他們父子二人就在那天接受了割禮。 ");
INSERT INTO cmncbt_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","亞伯拉罕家裡所有的男子，包括家中出生的和買回來的，都一起接受了割禮。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","耶和華在幔利的橡樹那裡向亞伯拉罕顯現。那時天氣很熱，亞伯拉罕坐在帳篷口， ");
INSERT INTO cmncbt_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","抬頭看見三個人站在對面，就從帳篷口跑去迎接他們，俯伏在地， ");
INSERT INTO cmncbt_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","說：「我主，若我在你面前蒙恩，請不要從僕人這裡走過去。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","我讓人拿點水來，你們洗洗腳，在樹下歇一會兒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","你們既然路過僕人這裡，我拿點餅來，你們補充一下體力再上路吧。」他們說：「好，就照你說的做吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","於是，亞伯拉罕連忙進帳篷對撒拉說：「快準備三斗細麵粉，和麵烤餅。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","亞伯拉罕又跑到牛群中牽了一頭肥嫩的小牛，交給僕人趕快去準備。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","亞伯拉罕把奶、乳酪和準備好的牛肉擺在他們面前，自己在樹蔭下侍立一旁，伺候他們用餐。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","他們問亞伯拉罕：「你妻子撒拉在哪裡？」亞伯拉罕回答說：「在帳篷裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","其中一人說：「明年這時候，我必回到你這裡，撒拉必生一個兒子。」撒拉在那人後面的帳篷口聽見了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","亞伯拉罕和撒拉已經年紀老邁，撒拉早已絕經。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","撒拉暗自發笑，心想：「我已經老了，還會有這種福氣嗎？況且我的丈夫也老了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","耶和華問亞伯拉罕：「撒拉為什麼偷笑說，『我這把年紀還會有孩子嗎？』 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","什麼事能難得了耶和華呢？明年這時候，我必回到你這裡，撒拉必生一個兒子。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","撒拉聽見後非常害怕，連忙否認說：「我沒有笑！」但耶和華說：「不，你確實笑了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","那三個人起身朝所多瑪眺望，亞伯拉罕與他們同行，要送他們一程。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","耶和華說：「我要做的事怎麼可以瞞著亞伯拉罕呢？ ");
INSERT INTO cmncbt_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","亞伯拉罕必成為強盛的大國，天下萬國必因他而蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","我揀選了他，是要他教導自己的子孫後代持守我的道、秉公行義。這樣，我必實現對他的應許。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","耶和華說：「所多瑪和蛾摩拉罪惡深重，人們怨聲載道。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","我現在要下去看看他們的惡行是否如我聽到的控訴一樣，如果不是，我也會知道。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","其中二人轉身向所多瑪走去，亞伯拉罕卻仍舊站在耶和華面前。 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","亞伯拉罕上前說：「你要把義人和惡人一同毀滅嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","倘若城中有五十個義人，你還要毀滅那城嗎？你會不會為了五十個義人而饒恕那座城呢？ ");
INSERT INTO cmncbt_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","你絕不會黑白不分，把義人和惡人一同毀滅。你絕不會這麼做！你是普天下的審判者，難道不秉公行事嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","耶和華回答說：「我若在所多瑪城中找到五十個義人，就因他們的緣故饒恕全城。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","亞伯拉罕說：「主啊，我雖然渺小如灰塵，還斗膽問你， ");
INSERT INTO cmncbt_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","倘若只有四十五個義人，你會因為少了五個義人而毀滅全城嗎？」耶和華說：「我若在城裡找到四十五個義人，也不會毀滅那城。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","亞伯拉罕又說：「倘若在那裡找到四十個義人呢？」耶和華說：「為了那四十個人的緣故，我不會毀滅那城。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","亞伯拉罕說：「求主不要發怒，容許我再問一次，倘若在那裡只找到三十個義人呢？」耶和華說：「倘若在那裡只找到三十個，我也不會毀滅那城。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","亞伯拉罕說：「我大膽再問一次，倘若在那裡只找到二十個義人呢？」耶和華說：「為了那二十個人的緣故，我也不會毀滅那城。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","亞伯拉罕又說：「求主不要發怒，讓我問最後一次，倘若在那裡只找到十個義人呢？」耶和華說：「為了那十個人的緣故，我也不會毀滅那城。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","耶和華跟亞伯拉罕說完話便離開了，亞伯拉罕也回家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","那兩個天使在黃昏的時候來到所多瑪，羅得正坐在城門口，看見他們，便起來迎接，俯伏在地上說： ");
INSERT INTO cmncbt_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","「我主啊，請到僕人家洗洗腳，住一夜，早上再繼續趕路吧！」他們說：「不，我們要在街上過夜。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","羅得執意邀請他們，他們便跟著進了他家。羅得設宴款待他們，烤了無酵餅，他們就吃了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","他們正準備就寢的時候，所多瑪城的男人從老到少全都出來，團團圍住羅得的房子， ");
INSERT INTO cmncbt_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","對羅得大喊大叫：「今晚到你家中作客的人在哪裡？把他們交出來，我們要跟他們交合！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","羅得走出來，隨手關上門，到眾人面前， ");
INSERT INTO cmncbt_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","對他們說：「各位弟兄，請不要做這種邪惡的事！ ");
INSERT INTO cmncbt_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","我有兩個女兒，還是處女，我把她們交出來，任憑你們處置，只是請你們不要動這兩個人，因為他們到我舍下做客。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","他們對羅得說：「走開！」又說：「這個寄居的人竟當起審判官來啦！現在我們要用更狠的手段對付你。」眾人便推擠羅得，想要破門而入。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","那兩位天使伸手把羅得拉進屋裡，關上了門， ");
INSERT INTO cmncbt_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","並讓門外的人，不論老少都眼目昏迷，摸來摸去也找不著羅得家的門。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","天使對羅得說：「你這裡還有什麼人嗎？你要帶兒女、女婿和城裡其他親人離開這裡， ");
INSERT INTO cmncbt_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","因為我們就要毀滅這城了。耶和華已經聽見對城中百姓的極大控訴，祂差遣我們來毀滅這城。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","羅得聽了就去通知他女兒的未婚夫說：「趕快離開這地方！耶和華要毀滅這城了！」可是他們卻以為他是在開玩笑。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","天剛亮的時候，天使便催促羅得說：「趕快帶著你的妻子和這裡的兩個女兒離開，免得所多瑪城因罪惡受懲罰的時候，你也一起被毀滅。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","羅得卻猶豫不決，天使便拉著羅得及其妻子和兩個女兒的手出去，將他們帶出去，安置在城外，因為耶和華憐憫他們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","帶他們到了城外之後，其中一位說：「趕快逃命！不要回頭看，也不要留在平原，要往山上逃，免得你們被毀滅。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","羅得說：「我主啊，請不要這樣。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","僕人蒙你厚愛、施恩相救，但我無法逃到山上，要是這災難追上我，我就沒命了！ ");
INSERT INTO cmncbt_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","請看，那座城離這裡不遠，容易跑到，又是座小城，請讓我逃到那座小城活命吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","天使回答說：「好吧，我也答應你，不毀滅你說的那座城。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","你趕快逃去那裡吧，因為你到達那裡之前，我不能動手。」因此那城便叫瑣珥。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","羅得到達瑣珥的時候，太陽已經出來了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","耶和華親自從天上把燃燒的硫磺降在所多瑪和蛾摩拉兩地， ");
INSERT INTO cmncbt_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","毀滅了這些城和其中的居民，包括整個平原和地上的植物。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","羅得的妻子跟在他後面，她回頭一望，就變成了一根鹽柱。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","亞伯拉罕清早起來，到他從前站在耶和華面前的地方， ");
INSERT INTO cmncbt_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","向所多瑪、蛾摩拉和整個平原眺望，只見那裡濃煙滾滾，好像火窯的煙一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","這樣，上帝顧念亞伯拉罕，在毀滅平原各城的時候，讓羅得逃離所住的城市，免遭毀滅。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","羅得不敢住在瑣珥，便帶著兩個女兒來到山上，住在一個洞裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","他的大女兒對小女兒說：「我們的父親年紀大了，這裡又沒有男子可以照著世上的習俗娶我們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","來，我們灌醉父親，然後跟他睡覺，藉著他傳宗接代吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","於是，那晚她們灌醉了父親，大女兒進去和父親睡。她什麼時候躺下，什麼時候起來，羅得完全不知道。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","第二天，大女兒對妹妹說：「昨晚我已經和父親睡了，今晚我們再灌醉他，然後你進去和他睡。這樣，我們就可以藉著父親傳宗接代。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","當晚，她們又灌醉了父親，小女兒進去與他睡。她什麼時候躺下，什麼時候起來，羅得完全不知道。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","這樣，羅得的兩個女兒都從父親懷了孕。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","大女兒生了一個兒子，給他取名叫摩押，他是今天摩押人的祖先。 ");
INSERT INTO cmncbt_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","小女兒也生了一個兒子，給他取名叫便·亞米，他是今天亞捫人的祖先。 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","亞伯拉罕從那裡遷往南地，住在加低斯和書珥之間。在基拉耳寄居期間， ");
INSERT INTO cmncbt_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","他稱妻子撒拉是自己的妹妹。基拉耳王亞比米勒派人帶走了撒拉。 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","晚上，上帝在夢中對亞比米勒說：「你的死期到了，因為你帶來的那個女人是有夫之婦。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","亞比米勒還沒有親近撒拉，因此他說：「主啊，難道你要毀滅無辜的人民嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","豈不是那人親口對我說這女人是他妹妹嗎？她也說那人是她哥哥。我這樣做問心無愧，沒有過錯。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","上帝在夢中對他說：「我知道你問心無愧，所以我才阻止你，不讓你親近她，免得你得罪我。 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","現在你要把那人的妻子還給他，他是個先知，他會為你禱告，使你活命。要知道，如果你不這樣做，你和你的人民都必死。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","亞比米勒清早起來召來他的臣僕，把整件事情告訴他們，他們聽了都十分害怕。 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","亞比米勒召見亞伯拉罕，對他說：「你對我們做的是什麼事？我什麼地方得罪了你？你竟使我和我的人民陷入大罪！你對我們做了不該做的事。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","又說：「你為什麼這樣做？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","亞伯拉罕回答說：「我以為這裡的人不敬畏上帝，他們必殺掉我，奪走我妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","況且，她真是我的妹妹，與我同父異母，後來做了我的妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","上帝吩咐我離開家鄉到外面漂泊的時候，我對她說，『無論我們到哪裡，你都要說我是你哥哥，這就是你對我的恩情。』」 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","於是，亞比米勒帶來牛、羊和僕婢送給亞伯拉罕，並把他妻子撒拉還給他， ");
INSERT INTO cmncbt_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","又對他說：「我的土地就在你面前，你想住在哪裡都可以。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","亞比米勒對撒拉說：「我給你哥哥二百二十兩銀子，在你家人面前證明你清白無過。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","亞伯拉罕向上帝禱告，上帝就醫治了亞比米勒和他妻子及眾婢女，使她們能夠生育。 ");
INSERT INTO cmncbt_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","原來耶和華因為亞伯拉罕的妻子撒拉這件事，使亞比米勒宮中所有的婦女都不能生育。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","耶和華按著自己說過的話眷顧撒拉，成就給她的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","亞伯拉罕年老的時候，撒拉懷了孕，在上帝指定的日期為他生了一個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","亞伯拉罕為撒拉所生的兒子取名叫以撒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","以撒出生後第八天，亞伯拉罕就照著上帝的吩咐為他行了割禮。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","以撒出生時亞伯拉罕已經一百歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","撒拉說：「上帝使我歡笑，凡聽見這事的人也必跟我一同歡笑。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","誰會對亞伯拉罕說撒拉要哺養孩子呢？我竟然在他年老的時候給他生了兒子。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","以撒漸漸長大，亞伯拉罕在他斷奶的那天大擺宴席。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","撒拉見埃及人夏甲給亞伯拉罕生的兒子以實瑪利嘲笑以撒， ");
INSERT INTO cmncbt_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","就對亞伯拉罕說：「趕走這婢女和她的兒子，因為這婢女的兒子不可和我的兒子以撒一同承受產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","亞伯拉罕因兒子以實瑪利的事非常苦惱。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","上帝對亞伯拉罕說：「你不要再為這孩子和你的婢女苦惱，只管照撒拉的話做，因為以撒生的才可算為你的後裔。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","至於婢女的兒子以實瑪利，我也會使他自成一國，因為他也是你的後裔。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","第二天，亞伯拉罕清早起來，把食物和一皮袋水給了夏甲，放在她肩上，讓她和孩子離開。夏甲就走了，在別示巴的曠野流浪。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","皮袋的水喝光了，夏甲把兒子留在一叢灌木下， ");
INSERT INTO cmncbt_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","自己走到離孩子約一箭之遠的地方，對著孩子坐下，說：「我不忍心看著他死啊！」夏甲坐在那裡放聲大哭起來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","上帝聽見孩子的哭聲，就差遣天使從天上安慰夏甲說：「夏甲，你怎麼了？不要害怕，上帝已經聽見孩子的哭聲了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","你去扶他起來，用手攙著他，我必使他成為大國。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","上帝開了夏甲的眼睛，讓她看見一口水井，她就上前把皮袋裝滿水拿給兒子喝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","在上帝的看顧下，孩子漸漸長大。他住在曠野，成為一個射箭能手。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","他住在巴蘭曠野，他母親為他娶了一個埃及女子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","那時，亞比米勒和他的將領非各對亞伯拉罕說：「你做的一切都有上帝保佑。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","現在請你在這裡當著上帝的面向我起誓，你不會欺騙我和我的子孫後代。我怎樣善待你，請你也同樣善待我以及你所寄居之地的百姓。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","亞伯拉罕說：「我願起誓。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","由於亞比米勒的僕人霸佔了一口水井，亞伯拉罕就指責亞比米勒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","亞比米勒說：「我不知道是誰做的，你以前沒有告訴我，我今天才聽說這事。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","亞伯拉罕把牛羊送給亞比米勒，他們二人立了約。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","亞伯拉罕又從羊群中分出七隻母羊羔。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","亞比米勒問亞伯拉罕：「你分出七隻母羊羔是什麼意思？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","亞伯拉罕回答說：「你要從我手中接受這七隻母羊羔，以證明這口井是我挖的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","所以，那地方被稱為別示巴，因為他們二人在那裡起了誓。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","他們在別示巴立約以後，亞比米勒和他的將領非各便回非利士去了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","亞伯拉罕在別示巴栽了一棵柳樹，又在那裡呼求永恆上帝耶和華的名。 ");
INSERT INTO cmncbt_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","亞伯拉罕在非利士人那裡住了很長時間。 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","這些事以後，上帝要考驗亞伯拉罕，就呼喚他：「亞伯拉罕！」他回答說：「我在這裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","上帝說：「帶著你的兒子，你的獨生子，你疼愛的以撒前往摩利亞，在我指示你的山上把他獻為燔祭。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","亞伯拉罕清早起來，準備好驢，劈好獻燔祭用的柴，帶著兩個僕人和兒子以撒動身前往上帝指示他的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","到了第三天，亞伯拉罕抬頭遠遠看見那地方， ");
INSERT INTO cmncbt_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","就對僕人說：「你們和驢在這裡等著，我和孩子到那邊敬拜上帝，然後便回來。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","亞伯拉罕把獻燔祭用的柴放在兒子以撒肩上，自己手裡拿著火種和刀。父子二人一同向前走。 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","以撒說：「父親。」亞伯拉罕說：「兒子，什麼事？」以撒說：「你看，火種和柴都有了，但獻燔祭用的羊羔在哪裡呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","亞伯拉罕說：「兒子，上帝會親自預備獻燔祭的羊羔。」二人就一同向前走。 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","他們到了上帝指示的地方，亞伯拉罕就築起祭壇，把柴擺在上面，然後把以撒捆起來放在祭壇上面的柴上。 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","亞伯拉罕伸手拿起刀來，要殺他的兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","耶和華的天使從天上呼喚他說：「亞伯拉罕！亞伯拉罕！」他回答說：「我在這裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","天使說：「不可動孩子，不可傷害他！現在我知道你敬畏上帝，因為你不惜把你的兒子，你的獨生子獻給我。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","這時亞伯拉罕抬頭一看，見有一隻公綿羊兩角卡在稠密的樹叢中，於是把羊取來代替他的兒子獻為燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","亞伯拉罕稱那地方為「耶和華以勒」。直到今天人們還說：「在耶和華的山上必有預備。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","耶和華的天使再次從天上呼喚亞伯拉罕， ");
INSERT INTO cmncbt_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","對他說：「耶和華說，『你既然不惜獻上你的兒子，你的獨生子，我憑自己起誓， ");
INSERT INTO cmncbt_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","我必賜福給你，使你的後裔多如天上的星和海邊的沙。你的後裔必奪取仇敵的城池， ");
INSERT INTO cmncbt_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","天下萬國必因你的後裔而蒙福，因為你聽從了我的話。』」 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","於是，亞伯拉罕回到僕人那裡，他們一同返回亞伯拉罕居住的別示巴。 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","過了些日子，有人告訴亞伯拉罕：「密迦為你兄弟拿鶴生了幾個兒子， ");
INSERT INTO cmncbt_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","長子烏斯、烏斯的弟弟布斯、亞蘭的父親基姆利、 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","基薛、哈瑣、必達、益拉和彼土利。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","彼土利是利百加的父親。密迦為亞伯拉罕的兄弟拿鶴生了這八個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","拿鶴的妾流瑪生了提八、迦含、他轄和瑪迦。 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","撒拉享年一百二十七歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","她在迦南境內的基列·亞巴，即希伯崙去世。亞伯拉罕在那裡痛哭，哀悼她。 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","他從亡妻旁邊站起來對赫人說： ");
INSERT INTO cmncbt_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","「我在你們中間是異鄉客旅，請你們給我一塊墳地，我好埋葬我的亡妻。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","赫人答道： ");
INSERT INTO cmncbt_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","「我主，請聽我們說，你在我們中間是一位尊貴的王子，你可以選我們這裡最好的墳地，沒有人會反對你使用他的墳地埋葬你的妻子。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","亞伯拉罕就起身向當地的赫人下拜，說： ");
INSERT INTO cmncbt_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","「如果你們願意讓我安葬亡妻，就請答應我，代我求瑣轄的兒子以弗崙， ");
INSERT INTO cmncbt_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","把他地頭的麥比拉洞賣給我。請他當著你們的面按實價賣給我作墳地。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","當時以弗崙正坐在赫人當中，於是他當著所有出入城門口的赫人答覆亞伯拉罕說： ");
INSERT INTO cmncbt_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","「不可！我主，請聽我說，我當著族人的面，把那塊地和其中的山洞送給你。去安葬你的死者吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","亞伯拉罕向當地的人下拜， ");
INSERT INTO cmncbt_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","當眾對以弗崙說：「你若願意，請聽我說，我要把地錢給你，請你收下，好讓我在那裡安葬我的妻子。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","以弗崙回答說： ");
INSERT INTO cmncbt_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","「我主，請聽我說，九十兩銀子的地對你我來說算什麼呢？去安葬你的妻子吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","於是，亞伯拉罕聽了以弗崙的意思，就照當眾提出的價錢，按市價稱了九十兩銀子給他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","這樣，以弗崙在麥比拉、靠近幔利的那塊地和山洞及地界內所有的樹木， ");
INSERT INTO cmncbt_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","都歸了亞伯拉罕。這是在城門口的赫人面前買下的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","之後，亞伯拉罕把妻子撒拉安葬在迦南的幔利附近、麥比拉田間的洞裡。幔利就是希伯崙。 ");
INSERT INTO cmncbt_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","這塊赫人的地和其中的山洞從此成了亞伯拉罕家的墳地。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","亞伯拉罕已經年邁，耶和華在一切事上都賜福給他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","亞伯拉罕對負責他所有產業的老總管說：「請你把手放在我大腿底下， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","我要你憑掌管天地的上帝耶和華起誓，你不會找我所居之地的迦南女子做我兒子的妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","你要回到我的家鄉，在我的親族中為以撒物色妻子。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","老總管問他：「如果那女子不肯跟我到這裡來呢？我要把你兒子帶回你的家鄉嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","亞伯拉罕說：「你千萬不可帶我的兒子回那裡！ ");
INSERT INTO cmncbt_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","因為帶領我離開父家和本鄉的天上的上帝耶和華，曾經向我說話，起誓應許把這片土地賜給我的後裔。祂必派天使在你前面引路，好讓你在那裡為我兒子找到妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","如果那女子不肯跟你來，你也算履行了你向我起的誓，只是你不可帶我兒子回那裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","於是，老總管就把手放在他主人亞伯拉罕的大腿底下，為這事向他起誓。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","老總管帶著主人的十匹駱駝和各種上好的禮物，啟程前往美索不達米亞，來到拿鶴住的城。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","黃昏，婦女們出來打水的時候，他讓駱駝跪在城外的井旁， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","然後禱告說：「我主人亞伯拉罕的上帝耶和華啊，求你施恩給我家主人亞伯拉罕，讓事情今天能夠成就。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","現在，我站在這泉水旁，城裡的女子正出來打水。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","如果我對哪個少女說『請放下你的水罐，讓我喝點水』，如果她說『請喝，我也打水給你的駱駝喝』，願那女子做你為自己的僕人以撒選定的妻子。這樣，我就知道你施恩給我的主人了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","老總管的話還沒有說完，利百加肩上扛著水罐走出來。她是彼土利的女兒，彼土利是亞伯拉罕的兄弟拿鶴和密迦所生的兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","利百加長得非常美麗，是個處女，沒有男人親近過她。她下到井旁，把水罐盛滿了水後上來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","老總管跑上前去對她說：「求你給我一點水喝。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","她回答說：「我主，請喝！」說完，立刻放下水罐，托在手上讓他喝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","等他喝完以後，利百加又說：「我再為你的駱駝打水，讓牠們喝飽。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","於是，她迅速把水罐裡的水倒進水槽裡，又跑到井邊為所有的駱駝打水。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","老總管默不作聲地注視著利百加，要看看耶和華是否使他此行順利。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","駱駝喝過水以後，老總管拿出一隻約六克重的金環和一對約一百一十克重的金鐲給利百加， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","對她說：「請問你是誰的女兒？你父親家裡有地方讓我們住宿嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","利百加回答說：「我是彼土利的女兒，我父親是拿鶴和密迦的兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","我家裡有充足的糧草，也有地方讓你留宿。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","老總管聽了，就俯伏敬拜耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","說：「我主人亞伯拉罕的上帝耶和華當受稱頌，因為祂一直以慈愛和信實對待我的主人。耶和華也一路引導我走到我主人兄弟的家裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","利百加跑回家中，把這事告訴了母親家的人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","利百加有個哥哥名叫拉班。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","他看見妹妹的金環和手上的金鐲，聽了她敘述老總管的話，就跑到井旁，見老總管跟駱駝仍然站在那裡， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","便對他說：「你這蒙耶和華賜福的人，請到我家。為什麼站在外面呢？我已經為你預備好了房間，也為駱駝預備了地方。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","老總管就到了拉班的家裡，拉班卸下駱駝背上的東西，給駱駝餵上草料，打水給老總管和隨行的人洗腳。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","然後晚餐準備好了，老總管卻說：「不，等我說明來意後再吃。」拉班說：「請說。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","老總管說：「我是亞伯拉罕的僕人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","耶和華賜給我主人極大的福氣，使他非常富有。耶和華賜給他牛群、羊群、金子、銀子、僕婢、駱駝和驢。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","我主人的妻子撒拉在晚年生了一個兒子，主人把所有的財產都給了他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","主人要我起誓，他說，『你不可給我的兒子娶我居住的迦南當地女子為妻， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","你要到我家鄉的親族中為我兒子物色妻子。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","我問我的主人，『如果那女子不願意跟我回來怎麼辦？』 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","他說，『我忠心事奉的耶和華必派天使與你同行，使你一路順利，為我兒子在家鄉的親族中物色妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","你去我親族那裡就是履行了你向我起的誓，如果我的親族不肯把女子交給你，你也算履行了你向我起的誓。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","「今天我來到井旁時曾禱告說，『我主人亞伯拉罕的上帝耶和華啊，求你使我一路順利。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","我現在站在井旁，有女子出來打水的時候，我會對她說，請讓我喝一點你罐裡的水， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","如果她說，請喝，我也打水給你的駱駝喝，就讓她做你為我家主人的兒子預備的妻子吧。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","「我心中的話還沒有說完，就看見利百加肩上扛著水罐到井旁打水。我上前向她要水喝， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","她就連忙放下肩上的水罐，說，『請喝，我也打水飲你的駱駝。』我喝了，她又打水飲駱駝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","我問她是誰家的女兒，她說，『是拿鶴和密迦的兒子彼土利的女兒。』我就給她戴上金鼻環和金手鐲， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","然後俯伏敬拜、頌讚我主人亞伯拉罕的上帝耶和華，祂引導我走對路，使我找到了我主人兄弟的孫女給我主人的兒子做妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","現在，你們若願意以慈愛和信實對待我的主人，答應這門親事，請告訴我；如果不答應，也請告訴我，好讓我知道應該怎麼辦。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","拉班和彼土利回答說：「既然這是耶和華的安排，我們就無話可說了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","你看，利百加就在這裡，你可以照耶和華的話，把她帶回去給你主人的兒子做妻子。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","亞伯拉罕的老總管聽見這話，就俯伏在地上敬拜耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","然後拿出金銀首飾和衣裳送給利百加，又把貴重的禮物送給她的哥哥和母親。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","老總管和隨行的人用過晚飯以後，在那裡住了一夜。早晨，老總管說：「請讓我返回我主人那裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","但利百加的哥哥和母親說：「讓她和我們住上十來天再去吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","可是，老總管說：「既然耶和華已經使我一路順利，請你們不要挽留我，請讓我回到我主人那裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","他們說：「我們問問利百加的意見吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","他們就叫來利百加，問她：「你願意跟這個人同去嗎？」利百加說：「我願意！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","於是，他們讓妹妹利百加和她的奶媽跟老總管及隨行的人一同離去， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","並為利百加祝福，說： 「我們的妹妹啊， 願你成為千萬人之母！ 願你的後裔佔領敵城！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","於是，利百加和她的婢女們準備妥當，騎上駱駝，跟著老總管離去。老總管就這樣帶著利百加走了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","那時，以撒住在南地，他剛從庇耳·拉海·萊回來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","傍晚的時候，以撒來到田間默想，他抬頭一看，見一隊駱駝迎面而來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","利百加抬頭看見以撒，就從駱駝上下來， ");
INSERT INTO cmncbt_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","問老總管：「那從田間來迎接我們的是誰？」老總管說：「是我的主人！」利百加聽了就蒙上面紗。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","老總管向以撒講述整個事情的經過。 ");
INSERT INTO cmncbt_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","以撒就帶利百加進入他母親撒拉的帳篷，娶她為妻，並且愛她。自從母親去世後，以撒這才得到安慰。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","亞伯拉罕又娶了基土拉為妻。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","基土拉為亞伯拉罕生了心蘭、約珊、米但、米甸、伊施巴和書亞。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","約珊生了示巴和底但，底但的子孫是亞書利族、利都示族和利烏米族。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","米甸的兒子是以法、以弗、哈諾、亞比大和以勒大。這些都是基土拉的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","亞伯拉罕把所有的財產都給了以撒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","他趁自己還在世的時候，把一些財物送給他的妾所生的兒子們，讓他們離開他的兒子以撒到東方去。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","亞伯拉罕活了一百七十五歲， ");
INSERT INTO cmncbt_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","享盡天年，壽終正寢，歸到他祖先那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","他的兩個兒子以撒和以實瑪利把他安葬在麥比拉洞，那山洞在幔利附近、赫人瑣轄的兒子以弗崙的地裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","那塊地是亞伯拉罕向赫人買的，他和妻子撒拉都葬在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","亞伯拉罕去世以後，上帝賜福給他的兒子以撒。以撒住在庇耳·拉海·萊附近。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","以實瑪利是亞伯拉罕和撒拉的婢女埃及人夏甲所生的兒子，以下是以實瑪利的後代。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","以實瑪利的兒子按出生的次序名字如下：長子尼拜約，然後是基達、亞德別、米比衫、 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","米施瑪、度瑪、瑪撒、 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","哈大、提瑪、伊突、拿非施、基底瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","這些都是以實瑪利的兒子，他們按照其村莊和營寨分別作了十二個族的族長。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","以實瑪利活了一百三十七歲，壽終正寢，歸到他祖先那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","他子孫居住的地方從哈腓拉一直延伸到埃及東面、通往亞述方向的書珥，他們與其他親屬作對。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","以下是關於亞伯拉罕的兒子以撒的記載。 亞伯拉罕生以撒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","以撒四十歲娶利百加，利百加是巴旦·亞蘭的亞蘭人彼土利的女兒、拉班的妹妹。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","以撒因為利百加不生育，就為她祈求耶和華。耶和華應允了他的祈求，利百加就懷了孕。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","兩個胎兒在她腹中彼此相爭，她說：「怎麼會這樣？」於是，她去求問耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","耶和華對她說： 「你腹中有兩個國家， 兩族從你裡面分出， 一族要比另一族強大， 將來大的要服侍小的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","到了生產的時候，利百加果然生下雙胞胎。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","先出生的嬰兒身體通紅，渾身長毛，好像穿了皮衣，因此給他取名叫以掃。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","隨後出生的弟弟手抓著以掃的腳跟，因此給他取名叫雅各。那時以撒六十歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","孩子們漸漸長大，以掃擅長狩獵，常在田野活動；雅各性情安靜，喜歡待在家裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","以撒疼愛以掃，因為他喜歡吃以掃打的野味，利百加卻疼愛雅各。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","一天，雅各正在熬湯，以掃筋疲力盡地從田野回來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","以掃對雅各說：「我要累死了，給我一些紅湯喝吧！」因此，以掃又叫以東。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","雅各回答說：「你今天把長子的名分賣給我吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","以掃說：「我都快死了，長子的名分對我有什麼用呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","雅各說：「你現在向我起誓保證吧！」於是，以掃就起誓把長子的名分賣給了雅各。 ");
INSERT INTO cmncbt_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","雅各把餅和豆湯給以掃，以掃吃完喝完便起身走了。以掃就這樣輕看自己長子的名分。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","亞伯拉罕在世的時候，那地方鬧過一次饑荒，這時又遭遇饑荒。以撒就遷到基拉耳的非利士王亞比米勒那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","耶和華向以撒顯現說：「不要下埃及去，要住在我指示你住的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","你寄居在這裡，我必與你同在，賜福給你，因為我必把這些土地賜給你和你的後代，堅立我對你父親亞伯拉罕的誓約。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","我必使你的後代多如天上的繁星，將這些土地都賜給他們，天下萬國必因你的後裔而蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","因為亞伯拉罕聽從我的話，遵守我的吩咐、命令、典章和律法。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","於是，以撒就在基拉耳住下來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","那裡的人問起他的妻子時，他便說：「她是我妹妹。」他不敢說：「她是我妻子。」他擔心當地的人會因為利百加而殺害他，因為利百加長得非常美麗。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","以撒在那裡住了許久。一天，非利士王亞比米勒從窗口看見以撒在愛撫利百加， ");
INSERT INTO cmncbt_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","便召見以撒，問他：「她明明是你妻子，為什麼你說她是你妹妹呢？」以撒回答說：「我擔心別人為了她而殺害我！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","亞比米勒說：「你怎麼可以這樣對我們呢？萬一百姓中有人佔有了她，你就使我們陷入罪中了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","於是，亞比米勒下令全國：「凡傷害他們二人的，必被處死。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","以撒在那裡耕種，耶和華賜福給他，那一年他得了百倍的收成。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","他的財富越來越多，成了大富戶。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","他擁有很多的牛羊和僕婢，非利士人嫉妒他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","他父親亞伯拉罕生前派人挖的那些水井，全被非利士人用土塞住了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","亞比米勒對以撒說：「請你離開我們吧，因為你太強盛了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","以撒就離開那裡，把帳篷遷往基拉耳谷居住。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","他的父親亞伯拉罕生前挖的水井都被非利士人塞住了，以撒便重新挖開，並沿用父親生前給那些水井起的名字。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","以撒的牧人在谷中挖得一口活水井， ");
INSERT INTO cmncbt_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","基拉耳的牧人與以撒的牧人爭吵起來，都說：「這口井是我們的。」於是，以撒便稱那口井為埃色，因為他們與他相爭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","後來，以撒的僕人又挖了一口井，他們雙方又為那口井發生爭執，以撒便稱那口井為西提拿。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","以撒離開那裡，又挖了一口水井。這次，他們沒有為那口井爭吵。所以，以撒稱那口井為利河伯。以撒說：「如今耶和華給了我們一個寬闊的地方，我們可以在這裡繁榮興旺。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","以撒從那裡上別示巴去。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","當晚，耶和華向他顯現說：「我是你父親亞伯拉罕的上帝。你不要害怕，因為我與你同在。為了我僕人亞伯拉罕的緣故，我必賜福給你，使你人丁興旺。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","以撒在那裡築了一座壇求告耶和華的名，並且在那裡搭起帳篷住下來。他的僕人又在那裡挖了一口井。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","一天，亞比米勒帶著他的參謀亞戶撒、將領非各從基拉耳來見以撒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","以撒說：「你們既然憎恨我，把我趕走，為什麼又來找我？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","他們回答說：「我們清楚知道耶和華與你同在，我們雙方應該訂立誓約。我們要跟你立約， ");
INSERT INTO cmncbt_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","使你不傷害我們，就像我們沒有侵犯你，總是善待你，讓你平安地離開一樣。你是蒙耶和華賜福的人。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","於是，以撒為他們擺設宴席，一同吃喝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","第二天早晨，以撒和他們互相起誓之後，送他們平安地離去。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","當天，以撒的僕人將挖井的事告訴他，說：「我們找到水了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","以撒便稱那口井為示巴，因此那城叫別示巴，沿用至今。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","以掃四十歲時，娶了赫人比利的女兒猶蒂與赫人以倫的女兒巴實抹。 ");
INSERT INTO cmncbt_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","她們二人常使以撒和利百加傷心。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","以撒年老的時候，眼睛昏花，幾乎看不見。他把大兒子以掃叫來，說：「我兒啊！」以掃說：「我在這裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","以撒說：「我年老了，不知道還能活多久。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","現在，帶著你的弓箭去田野為我打些野味來， ");
INSERT INTO cmncbt_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","照我喜歡的口味，做成美食給我吃，以便我在死前給你祝福。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","利百加聽見了以撒跟兒子以掃說的話。以掃出去打獵後， ");
INSERT INTO cmncbt_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","利百加就對她兒子雅各說：「我聽見你父親對你哥哥以掃說， ");
INSERT INTO cmncbt_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","『你去打些野味回來，做成美食給我吃，以便我死之前在耶和華面前給你祝福。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","現在，我兒，你要聽我的話，照我的吩咐去做。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","你到羊群裡牽兩隻上好的山羊羔給我，我好照你父親喜愛的口味做成美食， ");
INSERT INTO cmncbt_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","由你拿去給他吃，讓他死前為你祝福。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","雅各對母親利百加說：「哥哥以掃渾身是毛，我的皮膚光滑。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","如果父親用手摸我，一定會發覺我騙他，那時候我不但得不到祝福，反會招來咒詛。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","他母親利百加對他說：「我兒啊，有咒詛，我來承擔。你只管聽我的話，把羊羔牽來。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","於是，雅各把羊牽來交給母親，他母親就照他父親喜愛的口味做成美食。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","利百加又拿了大兒子以掃留在家裡的最好的衣服，給小兒子雅各穿上， ");
INSERT INTO cmncbt_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","再用山羊皮把雅各的手和脖子的光滑處都包起來， ");
INSERT INTO cmncbt_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","然後把做好的美味和餅交給兒子雅各。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","雅各來到父親跟前，叫了一聲：「父親。」以撒回答說：「我在這裡，兒子，你是哪一個？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","雅各對父親說：「我是你的大兒子以掃，你吩咐我的事，我已經辦好了。請你坐起來，吃我打的野味，然後給我祝福。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","以撒對他說：「我兒，你怎麼這麼快就打到野味了？」雅各回答說：「因為你的上帝耶和華讓我碰見好機會。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","以撒對雅各說：「我兒，過來，讓我摸摸看你是不是我兒以掃。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","雅各挨到父親跟前，以撒摸著他說：「聲音是雅各的聲音，手卻是以掃的手。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","因為雅各手上有毛，與他哥哥以掃的手一樣，以撒分辨不出來，就給他祝福。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","以撒又問：「你真是我的兒子以掃嗎？」雅各回答說：「我是。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","以撒便說：「把你打的野味拿給我，我吃了好為你祝福。」雅各遞上野味，以撒吃了；雅各又拿酒給他喝，他也喝了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","父親以撒對他說：「我兒，你過來親吻我。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","雅各就挨上前去親了父親。以撒聞到他衣服上的香氣，就祝福他說： 「我兒子的香氣就像蒙耶和華賜福之田地的香氣。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","願上帝賜你天上的甘露、肥沃的土地並豐富的五穀和新酒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","願萬民都侍奉你， 萬國都向你下拜。 願你成為你弟兄的主人， 願你母親的兒子向你下拜。 咒詛你的，願他受咒詛； 祝福你的，願他蒙祝福。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","雅各接受了以撒的祝福才剛離開，他的哥哥以掃就打獵回來了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","以掃也作好美味，拿到父親跟前，說：「父親，請起來吃你兒子打的野味，好給我祝福。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","他父親以撒問道：「你是誰？」以掃回答說：「我是你的兒子，你的長子以掃。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","以撒驚得劇烈顫抖，說：「在你來之前拿野味給我吃的是誰呢？我已經吃了，也給那人祝福了，他將來必蒙祝福。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","以掃聽了放聲痛哭，說：「父親啊，求你也為我祝福！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","以撒說：「你弟弟已經用詭計把你的福分奪去了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","以掃說：「怪不得他叫雅各，他已經騙了我兩次，先前把我長子的名分奪去，現在又奪去我的福分！」接著他對父親說：「難道你沒有留下別的祝福可以給我嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","以撒對以掃說：「我已經立他做你的主人，使他的眾弟兄做他的僕人，並給他五穀和新酒。我兒啊，我還能為你做什麼呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","以掃對父親說：「父親啊，你只有一個祝福嗎？父親啊，求你也為我祝福！」以掃又放聲大哭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","以撒對他說： 「你住的地方必遠離肥沃的土地， 也不會有天上的甘霖。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","你必倚靠刀劍生活， 又必服侍你的弟弟。 到你無法忍受的時候， 必掙脫他放在你頸上的軛。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","以掃因為父親把祝福給了雅各，就對雅各懷恨在心，暗自思量說：「父親已經不久人世，我服完喪就把我弟弟雅各殺掉！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","大兒子以掃的計謀傳到利百加耳中。她就派人把小兒子雅各叫來，對他說：「你哥哥以掃想要殺你洩憤！ ");
INSERT INTO cmncbt_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","我兒，聽我的話，現在就逃到哈蘭我哥哥拉班那裡， ");
INSERT INTO cmncbt_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","與他住些日子，一直住到你哥哥的氣消了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","等他對你的氣消了，忘了你對他所做的事，我會派人接你回來。我何必在一天之內失去你們兩個呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","利百加對以撒說：「我被這些赫人女子煩死了。如果雅各也娶那些赫人女子為妻，我活著還有什麼意思呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","以撒把雅各叫來，給他祝福，又囑咐他說：「你不要娶迦南的女子為妻。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","馬上去巴旦·亞蘭，到你外祖父彼土利家，在你舅父拉班的女兒中選一個做妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","願全能的上帝賜福給你，使你生養眾多，人丁興旺，成為許多民族。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","願上帝把賜給亞伯拉罕的福氣賜給你和你的後代，讓你承受你寄居之地為產業，就是上帝賜給亞伯拉罕的土地。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","以撒讓雅各前往巴旦·亞蘭，去亞蘭人彼土利的兒子拉班那裡。拉班是雅各和以掃的舅父。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","以掃看見以撒給雅各祝福，讓他到巴旦·亞蘭娶妻，叮囑他不要娶迦南的女子， ");
INSERT INTO cmncbt_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","又看見雅各聽從父母到巴旦·亞蘭去了， ");
INSERT INTO cmncbt_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","就知道父親以撒不喜歡迦南的女子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","他便到亞伯拉罕的兒子以實瑪利那裡，娶了以實瑪利的女兒、尼拜約的妹妹瑪哈拉為妻。他娶瑪哈拉以前已經有兩個妻子了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","雅各離開別示巴，前往哈蘭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","到了一個地方，太陽已經下山，他便在那裡過夜。他就地取了一塊石頭枕在頭下睡覺， ");
INSERT INTO cmncbt_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","夢中看見有個梯子立在地上，直通到天上，梯子上有上帝的天使上上下下。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","耶和華站在梯子上面對雅各說：「我是耶和華，是你祖父亞伯拉罕的上帝，也是以撒的上帝。我要把你現在躺臥的地方賜給你和你的後代。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","你的後代必多如地上的塵土，遍佈四方，地上萬族必因你和你的後裔而蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","我與你同在，無論你去哪裡，我都會保護你，領你返回這片土地。我必實現對你的應許，決不離棄你。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","雅各一覺醒來，說：「耶和華誠然在這裡，我竟不知道。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","他就害怕起來，說：「這地方何等可畏！這裡正是上帝的殿，是通天的大門。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","雅各清早起來，把枕的那塊石頭立成柱子，在上面澆上油。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","他稱那地方為伯特利，那地方以前叫路斯。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","雅各許願說：「如果上帝與我同在，一路保護我，供給我衣食， ");
INSERT INTO cmncbt_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","帶領我平安地回到父親家，我就一定奉耶和華為我的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","我立為柱子的這塊石頭必成為上帝的殿。凡你賜給我的，我必把十分之一獻給你。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","雅各繼續前行，來到東方人住的地方， ");
INSERT INTO cmncbt_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","看見田間有一口井，有三群羊臥在井邊，因為當地人用那口井的水飲羊。井口封著一塊大石頭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","羊群聚集在井旁的時候，牧人就把井口的石頭滾開飲羊，隨後再把石頭放回原處。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","雅各問牧人：「弟兄們，你們是從哪裡來的？」他們說：「我們是從哈蘭來的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","雅各問道：「你們認識拿鶴的孫子拉班嗎？」他們說：「我們認識。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","雅各又問：「他好嗎？」他們回答說：「很好。你看，他的女兒拉結帶著羊群來了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","雅各對他們說：「太陽還高，不到把羊關起來的時候，你們飲了羊，再放牠們去吃草吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","他們說：「不行，要等所有的羊群到齊，把井口的石頭滾開後，才能飲羊。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","雅各還在跟他們說話的時候，拉結就帶著她父親的羊群來到井邊，她是個牧羊女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","雅各看見表妹拉結和舅父拉班的羊群來了，就上前把井口的石頭滾開，飲他舅父的羊。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","他親吻拉結，並放聲大哭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","雅各告訴拉結自己是她父親的外甥，是利百加的兒子。拉結便跑去告訴她父親。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","拉班聽見外甥雅各來了，就跑去迎接他，擁抱他，親吻他，然後把他接到自己家裡。雅各把事情的經過告訴他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","拉班說：「你真是我的骨肉至親啊！」雅各在拉班家裡住了一個月。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","一天，拉班對他說：「雖然我們是親戚，也不能讓你白白地替我工作。告訴我，你希望得到什麼報酬？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","拉班有兩個女兒，大的叫利亞，小的叫拉結。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","利亞兩眼無神，而拉結長得美麗多姿。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","雅各愛上了拉結，於是對拉班說：「我願意為你工作七年，請把你小女兒拉結許配給我。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","拉班說：「把她嫁給你比嫁給外人好，你就留下來吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","雅各為了拉結給拉班工作了七年。因為他深愛拉結，所以這七年在他眼中就像短短的幾天。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","一天，雅各對拉班說：「期限已經滿了，現在請把我妻子給我，我好和她同房。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","於是，拉班就擺設宴席款待當地的人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","到了晚上，拉班卻把女兒利亞交給雅各，雅各和她同房。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","拉班又把自己的婢女悉帕送給女兒利亞做婢女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","早上，雅各才發現娶的是利亞，就對拉班說：「你對我做的是什麼事啊！我服侍你不就是為了拉結嗎？你為什麼騙我？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","拉班說：「依照本地的習俗，妹妹不能比姐姐先出嫁。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","等這女兒七天的婚期過了，我就把那個女兒也許配給你，你再替我工作七年。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","雅各同意了。過了七天，拉班把女兒拉結嫁給雅各， ");
INSERT INTO cmncbt_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","又把自己的婢女辟拉送給拉結。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","雅各也和拉結同房，他深愛拉結勝過愛利亞。他又替拉班工作了七年。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","耶和華看見利亞失寵，就使利亞生育，但拉結卻不生育。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","利亞懷孕生了一個兒子，給孩子取名叫呂便。她說：「耶和華看見了我的痛苦，現在我丈夫一定會愛我。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","她又懷孕生了一個兒子，就說：「耶和華聽見我失寵，所以又給我這個兒子。」於是，她給孩子取名叫西緬。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","她又再度懷孕，生了一個兒子，就說：「這次我丈夫一定會依戀我，因為我給他生了三個兒子。」於是，他給孩子取名叫利未。 ");
INSERT INTO cmncbt_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","後來，利亞再次懷孕，生了一個兒子，她說：「這次我要讚美耶和華！」於是，她給孩子取名叫猶大。之後，利亞停止了生育。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","拉結見自己沒有給雅各生孩子，就嫉妒姐姐。她對雅各說：「你給我孩子，不然我還不如死了！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","雅各氣憤地說：「使你不能生育的是上帝，難道我能代替上帝嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","拉結說：「你去跟我的婢女辟拉同房吧，讓她替我生孩子，我也可以藉她留後。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","於是拉結把婢女辟拉給丈夫做妾，雅各和辟拉同房。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","辟拉懷了孕，為雅各生下一個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","拉結說：「上帝為我伸冤，也聽了我的懇求，賜給我一個兒子。」拉結就給孩子取名叫但。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","拉結的婢女辟拉又懷孕，為雅各生了第二個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","拉結說：「我跟姐姐激烈相爭，我得勝了。」她就給這孩子取名叫拿弗他利。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","利亞見自己不再生育，就把婢女悉帕給雅各做妾。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","利亞的婢女悉帕給雅各生了一個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","利亞說：「真幸運！」她便給孩子取名叫迦得。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","利亞的婢女悉帕又給雅各生了第二個兒子， ");
INSERT INTO cmncbt_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","利亞說：「我真有福啊！婦女們會說我有福！」她就為孩子取名叫亞設。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","在收麥子的季節，呂便在田間找到一些風茄，拿回家給母親利亞。拉結對利亞說：「請給我一些你兒子找到的風茄。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","利亞說：「你搶了我丈夫還不夠嗎？現在還要搶我兒子的風茄嗎？」拉結回答說：「你給我風茄，今夜雅各就跟你同房。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","那天晚上，雅各從田間回來，利亞就出來迎接他說：「你要來跟我同房，因為我已經用兒子的風茄把你雇下來了。」於是，那天晚上雅各便跟利亞同房。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","上帝答應利亞的祈求，使她懷孕，為雅各生了第五個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","利亞說：「我把婢女送給丈夫，現在上帝給我報酬了。」因此，她就為孩子取名叫以薩迦。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","後來，利亞又懷孕，給雅各生下第六個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","她說：「上帝賜給我珍貴的禮物，現在我丈夫會尊重我，因為我給他生了六個兒子。」於是，她就給這個兒子取名叫西布倫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","後來，利亞又生了一個女兒，給她取名叫底娜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","上帝眷顧拉結，聽了她的禱告，使她可以生育。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","她就懷孕，生了一個兒子，說：「上帝除去了我的羞辱。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","她給孩子取名叫約瑟，說：「願上帝再給我添一個兒子！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","拉結生約瑟以後，雅各對拉班說：「請讓我走吧！我好回故鄉， ");
INSERT INTO cmncbt_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","請把我的妻兒給我，我好離開。她們都是我替你工作得來的，你知道我怎樣努力為你工作。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","拉班卻挽留他，說：「如果你肯賞光，請你留下來！因為我占卜得知上帝為了你的緣故才賜福給我。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","你要多少酬勞，只管說出來，我一定會給你。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","雅各回答說：「你知道我怎樣努力地服侍你，照顧你的牲畜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","我來以前，你的財產很少。耶和華因為我的到來而賜福給你，使你財產大增。但我自己什麼時候才能興家立業呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","拉班問：「我該給你什麼呢？」雅各說：「你不用給我什麼，只要你答應一件事，我就繼續照料你的羊群。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","今天讓我走遍你的羊群，從中挑出有斑點的綿羊、黑色的小羊和有斑點的山羊作為我的薪酬。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","以後，如果你在給我作薪酬的羊群中查出沒有斑點的山羊或非黑色的綿羊，就算是我偷的。這樣你可以知道我是否誠實。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","拉班說：「好，就照你的話做！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","當天，拉班把有條紋或斑點的公山羊以及有斑點或夾雜白紋的母山羊，連同黑色的綿羊都挑出來，交給自己的兒子們看管。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","然後，他離開雅各，彼此相隔三天的路程。雅各繼續為他照料其餘的羊。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","雅各折下一些楊樹、杏樹和楓樹的嫩枝，削掉部分樹皮，露出白色的條紋， ");
INSERT INTO cmncbt_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","然後把這些嫩枝插在羊喝水的水槽和水溝裡。羊群來喝水時互相交配。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","牠們對著這些樹枝交配，就生下有條紋和有斑點的羊羔。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","雅各把這些羊羔分出來，又讓羊群對著拉班那些有條紋和黑色的羊。他把自己的羊安置在一處，不與拉班的羊摻雜在一起。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","每當肥壯的羊交配時，雅各就把有條紋的枝子插在水溝裡，使羊對著樹枝交配。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","但如果交配的羊是瘦弱的，他就不插枝子。這樣，瘦弱的羊歸拉班，肥壯的羊歸雅各。 ");
INSERT INTO cmncbt_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","因此，雅各變得極其富有，擁有很多羊、駱駝、驢和僕婢。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","雅各聽見拉班的兒子們說：「雅各奪去了我們父親的一切！他的財富都是從我們父親那裡得來的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","雅各發覺拉班對他的態度不如從前了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","這時，耶和華對雅各說：「回到你的家鄉和親族那裡吧！我必與你同在。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","於是，雅各就派人把拉結和利亞叫到放羊的地方， ");
INSERT INTO cmncbt_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","對她們說：「我感到你們父親對我不如從前了，但我父親的上帝常與我同在。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","你們知道我是怎樣盡心盡力地替你們父親工作， ");
INSERT INTO cmncbt_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","他卻欺騙我，把我的工酬更改了十次。然而，上帝不讓他苦待我。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","如果他說把有斑點的羊給我當酬勞，羊群生的就都是有斑點的；如果他說把有條紋的給我，羊群生的就都是有條紋的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","上帝就這樣把你們父親的牲畜奪過來給了我。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","「在羊群交配的季節，我在夢中抬頭看見和母羊交配的公羊都是有條紋或有斑點的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","在夢中，上帝的天使叫我，我說，『我在這裡。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","他說，『拉班對你的所作所為，我都看見了。現在你抬頭看看，與母羊交配的公羊都是有條紋或有斑點的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","我就是你在伯特利遇見的上帝。你在那裡用油澆過柱子，向我許過願。現在，你馬上離開這裡，回到你的家鄉。』」 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","拉結和利亞說：「父親的家產沒有我們的份兒， ");
INSERT INTO cmncbt_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","我們早就被當作外人了，他賣了我們，把我們的身價全部吞了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","上帝從我們父親那裡奪過來的一切財產，理當屬於我們和我們的兒女。現在你只管照上帝的吩咐做吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","雅各便起來讓兒女和妻子都騎上駱駝， ");
INSERT INTO cmncbt_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","帶著他在巴旦·亞蘭得到的所有牲畜和財物，啟程去迦南他父親以撒那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","那時拉班正在外面剪羊毛，拉結偷了父親家中的神像。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","雅各不辭而別，背著亞蘭人拉班偷偷地跑了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","他帶著所有的一切渡過幼發拉底河，逃往基列山區。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","到了第三天，拉班才得知雅各逃走了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","於是，他帶著族人去追趕，追了七天，在基列山區追上了雅各。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","當晚，上帝在夢中對亞蘭人拉班說：「你要當心，不可對雅各多說什麼。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","拉班追上了雅各，那時雅各在基列山搭起帳篷，拉班和他的族人也在那裡搭起帳篷。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","拉班對雅各說：「你做的是什麼？你欺瞞我，把我的女兒像戰俘一樣帶走。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","你為什麼要偷偷地逃跑？你為什麼不告訴我，我好擊鼓、彈琴、唱歌歡送你？ ");
INSERT INTO cmncbt_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","你甚至不讓我親吻外孫和女兒，與他們道別，你這樣做真愚蠢。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","我有能力傷害你，但你父親的上帝昨夜對我說，『你要小心，不可對雅各多說什麼。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","你思家心切，一定要走，但你為什麼要偷走我的神像呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","雅各對拉班說：「我逃跑是因為害怕，我以為你會從我身邊奪走你的女兒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","至於你的神像，你在誰身上搜出來，誰就是該死的。你可以當著眾弟兄的面察看，如果在我這裡有什麼物件是你的，你只管拿走。」雅各不知道拉結偷走了神像。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","拉班進入雅各、利亞和兩個婢女的帳篷搜查，卻搜不出什麼。拉班離開利亞的帳篷進入拉結的帳篷， ");
INSERT INTO cmncbt_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","那時拉結已經把神像藏在駱駝的鞍座裡，自己坐在上面。拉班搜遍了整個帳篷，什麼也找不到。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","拉結對父親說：「請我主別生氣，我有月事在身，不能起身。」結果，拉班搜來搜去找不到神像。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","雅各發怒，斥責拉班說：「我做錯了什麼、犯了什麼罪，以致你對我窮追不捨？ ");
INSERT INTO cmncbt_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","你搜遍我所有的東西，搜到了什麼？現在就當著眾弟兄的面拿出來，讓他們評評理吧！ ");
INSERT INTO cmncbt_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","我在你家這二十年，你的母綿羊、母山羊沒有掉過胎，我也沒有吃過你公羊的肉。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","我沒有把被野獸撕裂的羊帶來給你，而是自己賠上。無論在白晝或黑夜被偷去的，你都要我賠償。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","我白天受盡烈日煎熬，晚上飽嘗夜露寒霜，不得好睡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","這二十年來，我為了你的兩個女兒，替你工作了十四年，又用了六年才從你那裡得到這些羊，你把我的工錢更改了十次。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","如果不是我父親以撒敬畏的上帝，就是亞伯拉罕的上帝與我同在，你肯定會讓我兩手空空地回家。但上帝看見了我的難處和勞苦，所以在昨夜責備了你。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","拉班回答說：「女兒是我的，孩子是我的，羊群也是我的，你的一切都是我的，我又怎會傷害我的女兒和她們的孩子呢？ ");
INSERT INTO cmncbt_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","來吧，你我立約為證。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","於是，雅各拿來一塊石頭，立作柱子， ");
INSERT INTO cmncbt_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","又吩咐眾弟兄去收集石頭。他們把石頭堆成一堆，在旁邊吃喝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","拉班稱那石堆為伊迦爾·撒哈杜他，雅各卻稱那石堆為迦累得。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","拉班說：「今日，這石堆是你我之間的憑證。」因此，那地方名叫迦累得， ");
INSERT INTO cmncbt_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","又叫米斯巴，因為拉班說：「我們分手以後，願上帝親自鑒察我們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","倘若你虐待我的女兒，或在她們以外另娶妻子，即使沒人知道，也有上帝在你我之間作見證。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","拉班又說：「看我在你我之間立的這石堆和石柱。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","這石堆和石柱都是憑證，我不會越過石堆去害你，你也不可越過石堆和石柱來害我。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","願亞伯拉罕的上帝和拿鶴的上帝，就是他們父親的上帝，在你我之間判斷是非。」雅各便憑他父親以撒敬畏的上帝起誓， ");
INSERT INTO cmncbt_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","又在山上獻祭，請眾弟兄吃飯。飯後，他們一同在山上過夜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","拉班清早起來，親吻外孫和女兒，給他們祝福，然後回家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","雅各繼續前行，上帝的天使遇見了他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","雅各看見他們，就說：「這是上帝的軍隊！」於是稱那地方為瑪哈念。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","雅各先派使者到西珥，就是以東地區，去見他哥哥以掃， ");
INSERT INTO cmncbt_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","並吩咐他們：「你們要這樣對我主以掃說，『你僕人雅各說他一直寄居在拉班家裡， ");
INSERT INTO cmncbt_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","現在他帶了牛羊、驢和僕婢回來見我主，派我們來報信，希望在你面前蒙恩。』」 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","報信的人回到雅各那裡，說：「我們到了你哥哥以掃那裡，他正帶著四百人前來見你。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","雅各聽了非常害怕，憂心忡忡，便把隨從、牛群、羊群和駱駝分成兩隊， ");
INSERT INTO cmncbt_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","心想：「如果以掃來攻擊一隊，另一隊還可以逃生。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","他禱告說：「耶和華，我祖父亞伯拉罕和我父親以撒的上帝啊！你吩咐我回到家鄉和親族那裡，答應厚待我。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","我不配蒙你以慈愛和信實相待，我先前過約旦河的時候，手上只有一根杖，現在卻有兩隊人畜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","求你救我脫離我哥哥以掃的手，我怕他會來殺我和我的妻兒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","然而，你曾說，『我必厚待你，使你的後代多如海沙，不可勝數。』」 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","那天晚上，雅各就在那裡過夜，又從產業中挑選牲畜送給哥哥以掃作禮物： ");
INSERT INTO cmncbt_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","母山羊二百隻、公山羊二十隻、母綿羊二百隻、公綿羊二十隻、 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","哺乳的駱駝三十頭及其小駱駝、母牛四十頭、公牛十頭、母驢二十頭、公驢十頭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","雅各把牲畜每類分成一群，交給僕人看管，對他們說：「你們走在前頭，每群牲畜之間要保持一段距離！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","又吩咐走在最前面的僕人說：「我哥哥以掃遇到你的時候，如果問你是誰家的人？要到哪裡去？你前頭這些牲畜是誰的？ ");
INSERT INTO cmncbt_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","你就說，『是你僕人雅各的，是送給他主人以掃的禮物，他自己就在後面。』」 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","雅各又吩咐趕第二群、第三群及其餘牲畜的僕人遇見以掃時也要這樣回答， ");
INSERT INTO cmncbt_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","並且一定要說：「你僕人雅各就在後面。」雅各想先用禮物去化解以掃的怨恨，也許見面時以掃會善待他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","於是，他派人先把禮物送過去，自己則留在營裡過夜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","當夜，雅各起來帶著兩個妻子、兩個婢女和十一個兒子渡過雅博渡口。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","雅各把他們連同一切所有都送過河以後， ");
INSERT INTO cmncbt_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","自己獨自留下。有一個人來和他摔跤，直到黎明。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","那人見勝不過雅各，就在他的大腿窩摸了一下，他大腿的關節就脫臼了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","那人說：「天亮了，讓我走吧！」但雅各說：「你不祝福我，我就不讓你走。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","那人問道：「你叫什麼名字？」他說：「我叫雅各。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","那人說：「你以後不要再叫雅各了，你要叫以色列，因為你跟上帝和人角力都得勝了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","雅各說：「請你告訴我你的名字。」那人說：「你為什麼問我的名字？」他就在那裡給雅各祝福。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","雅各稱那地方為毗努伊勒，因為他說：「我面對面見過上帝，竟能活命。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","雅各經過毗努伊勒的時候，太陽出來了，那時他的大腿瘸了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","以色列人至今都不吃大腿窩的筋，因為那人摸過雅各大腿窩的筋。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","雅各抬頭看見以掃帶著四百人迎面而來，便把孩子們分別交給利亞、拉結和兩個婢女， ");
INSERT INTO cmncbt_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","又讓兩個婢女和她們的孩子走在前面，利亞和她的孩子跟在後面，拉結和約瑟走在最後。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","他自己則走在他們前面，接連俯伏下拜七次，直到他哥哥跟前。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","以掃跑上去迎接他，擁抱他，親吻他，二人抱頭痛哭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","以掃抬眼看見跟在雅各後面的婦女和孩子，就問：「這些和你同行的是誰？」雅各說：「這些孩子是上帝施恩賜給你僕人的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","雅各的兩個婢女和她們的孩子上前下拜， ");
INSERT INTO cmncbt_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","利亞和她的孩子也上前下拜，最後約瑟和拉結也上前向以掃下拜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","以掃說：「我在路上遇見的那一群群牲畜是怎麼回事？」雅各回答說：「我帶來這些是想在我主面前蒙恩。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","以掃說：「弟弟，我已經有很多了，你自己留著吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","雅各說：「不，你若賞臉，就請收下！我見了你的面就像見了上帝的面，因為你這樣善待我。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","請你收下我的禮物吧，因為上帝恩待了我，使我富足。」雅各再三懇求，以掃才收下。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","以掃說：「我們走吧！我陪你們走。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","雅各卻說：「我主知道孩子們還幼小，而且，我還要照料正在哺乳的牛羊，如果整天趕路，牛羊都會累死。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","請我主先走，我遷就牲畜和孩子的腳步慢慢走，我在西珥與我主會合。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","以掃說：「我給你留幾個隨從吧。」雅各說：「不用了，能得到我主的恩待就夠了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","於是，以掃在當天先回西珥去了， ");
INSERT INTO cmncbt_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","雅各卻去了疏割，在那裡為自己建造房屋，為牲畜搭起棚子。因此那地方叫疏割。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","這樣，雅各從巴旦·亞蘭平安地回到迦南的示劍城，在城外搭營居住。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","他搭營居住的這塊地是他用一百塊銀子向示劍的父親哈抹的子孫買的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","雅各在那裡築了一座壇，稱之為伊利·伊羅伊·以色列。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","一天，利亞給雅各所生的女兒底娜到外面去見當地的女子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","當地首領希未人哈抹的兒子示劍看到她，就抓住她，強行玷污了她。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","他戀慕雅各的女兒底娜，愛上了這個少女，就用甜言蜜語討她歡心。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","他求父親哈抹為他說親，把底娜娶過來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","底娜被玷污的消息傳到雅各耳中時，他的兒子們正在田野放牧。他只好忍氣吞聲，等兒子們回來再作打算。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","示劍的父親哈抹來和雅各商議。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","雅各的兒子們一聽說這事，就從田野趕回來。大家都非常憤怒，因為示劍玷污了雅各的女兒，對以色列家做了不該做的醜事。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","哈抹跟他們商議說：「我兒子示劍愛慕你們家的女兒，請你們把女兒嫁給他吧！ ");
INSERT INTO cmncbt_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","我們可以互相通婚，你們可以把女兒嫁給我們的兒子，也可以娶我們的女兒為妻。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","你們可以在我們這裡安頓下來，這片土地就在你們面前，住在這裡做買賣、置產業吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","示劍對底娜的父親和她的弟兄們說：「請你們恩待我，你們要什麼，我都給你們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","只要你們把這少女嫁給我，無論你們要多少聘金和禮物，我必如數奉上。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","雅各的兒子們因為示劍玷污了他們的妹妹底娜，就假意對示劍和他的父親哈抹說： ");
INSERT INTO cmncbt_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","「我們不能把妹妹嫁給沒有受過割禮的人，這對我們是一種羞辱。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","除非你們所有的男子都跟我們一樣受割禮，我們才會答應你們， ");
INSERT INTO cmncbt_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","我們才會和你們通婚，共同生活，結成一個民族。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","如果你們不肯這樣做，我們就把妹妹帶走。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","哈抹父子欣然答應。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","示劍毫不遲延地照辦，因為他熱戀底娜。在哈抹家族中，他最受人尊重。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","哈抹父子來到城門口，對那城的居民說： ");
INSERT INTO cmncbt_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","「這些人跟我們相處和睦，就讓他們在這裡定居、做買賣吧。我們這裡有足夠的地方可以容納他們，我們可以和他們通婚。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","可是，他們有一個條件，就是要我們所有的男子和他們一樣接受割禮，他們才答應和我們一起生活，結成一個民族。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","到時候，他們的財產和牛羊等所有牲畜不全歸我們了嗎？我們同意他們吧，這樣他們就會在我們這裡定居。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","在城門進出的人聽了哈抹父子的話，都表示贊同。於是，城裡的男子都接受了割禮。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","到了第三天，他們傷口正疼痛的時候，雅各的兩個兒子——底娜的哥哥西緬和利未拿著利劍，乘眾人沒有防備，進城殺掉了所有的男子， ");
INSERT INTO cmncbt_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","包括哈抹和示劍，從示劍家裡帶走了底娜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","雅各的眾子又到被殺之人的城裡擄掠，因為他們的妹妹在那裡被人玷污。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","他們搶走牛群、羊群、驢群和城裡城外所有的東西， ");
INSERT INTO cmncbt_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","並帶走所有財物、婦孺以及房屋裡的一切。 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","雅各責備西緬和利未說：「你們為什麼要給我惹麻煩，使我在當地的迦南人和比利洗人中留下臭名呢？我們人數很少，要是他們聯手來攻擊我們，我們全家必遭滅門之禍。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","他們說：「他怎麼能把我們的妹妹當妓女對待？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","上帝對雅各說：「你到伯特利去住，你要在那裡為上帝築一座壇，祂在你逃避你哥哥以掃時曾向你顯現。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","於是，雅各吩咐家人和所有的隨從：「你們要除掉你們當中的外族神像，潔淨自己，更換衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","我們要上伯特利去，在那裡為上帝築一座壇，祂在我遭遇患難時聽了我的禱告，一路都與我同在。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","他們把所有外族的神像和自己的耳環都交給雅各，雅各把這些東西埋在示劍的橡樹下。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","他們就出發了，上帝使恐懼籠罩周圍的城邑，沒有人敢追趕他們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","雅各和所有的隨從來到迦南的路斯，也就是伯特利。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","他在那裡建造了一座壇，稱那地方為伊勒·伯特利，因為在他逃避哥哥的時候，上帝曾在那裡向他顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","後來利百加的奶媽底波拉死了，葬在伯特利下面的橡樹下，那棵樹叫亞倫·巴古。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","雅各從巴旦·亞蘭回來後，上帝又向他顯現，賜福給他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","上帝對他說：「你叫雅各，但從今以後不要再叫雅各了，你要改名叫以色列。」這樣雅各改名為以色列。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","上帝又說：「我是全能的上帝，你要生養眾多，人丁興旺，一國，甚至多國必從你而出，許多君王必出自你的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","我要把賜給亞伯拉罕和以撒的土地賜給你和你的後代。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","上帝說完就離開雅各升上天去。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","雅各在上帝跟他說話的地方立了一根石柱，又在柱子上奠酒、澆油， ");
INSERT INTO cmncbt_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","稱那地方為伯特利。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","他們從伯特利繼續前行，離以法他還有一段路時，拉結要分娩，出現難產。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","接生婆對難產的她說：「不要害怕，你又添了一個兒子！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","拉結嚥氣前給兒子取名叫便·俄尼，雅各卻叫他便雅憫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","拉結死後就葬在通往以法他的路旁，以法他即伯利恆。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","雅各在她的墳上立了石碑，這碑至今還在。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","以色列繼續前行，在以得塔附近搭起了帳篷。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","以色列在那裡居住時，呂便和父親的妾辟拉通姦，以色列也知道這件事。 雅各有十二個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","利亞生了雅各的長子呂便，還有西緬、利未、猶大、以薩迦和西布倫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","拉結生了約瑟和便雅憫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","拉結的婢女辟拉生了但和拿弗他利。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","利亞的婢女悉帕生了迦得和亞設。他們都是雅各的兒子，是在巴旦·亞蘭出生的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","雅各來到他父親以撒住的幔利，即基列·亞巴，也就是亞伯拉罕和以撒寄居的地方。基列·亞巴就是希伯崙。 ");
INSERT INTO cmncbt_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","以撒享年一百八十歲， ");
INSERT INTO cmncbt_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","年紀老邁，壽終正寢，歸到他祖先那裡。他的兒子以掃和雅各把他安葬了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","以下是以掃的後代，以掃就是以東。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","以掃娶了迦南女子為妻，她們是赫人以倫的女兒亞大和希未人祭便的孫女、亞拿的女兒阿何利巴瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","他還娶了以實瑪利的女兒、尼拜約的妹妹巴實抹。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","亞大給以掃生了以利法，巴實抹生了流珥， ");
INSERT INTO cmncbt_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","阿何利巴瑪生了耶烏施、雅蘭和可拉。他們都是以掃的兒子，是在迦南出生的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","以掃帶著他在迦南所得的妻子、兒女和家中所有人員，以及所有的牛羊等牲畜和財產離開他弟弟雅各，遷往別處。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","因為以掃和雅各兩家的財產和牲畜太多，那地方不夠他們住， ");
INSERT INTO cmncbt_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","於是以掃，即以東，搬到了西珥山居住。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","以掃是西珥山區以東人的祖先，以下是他的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","以掃的妻子亞大生了以利法，他妻子巴實抹生了流珥。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","以利法的兒子是提幔、阿抹、洗玻、迦坦、基納斯， ");
INSERT INTO cmncbt_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","以利法的妾亭納為他生了亞瑪力，他們都是以掃妻子亞大的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","流珥的兒子是拿哈、謝拉、沙瑪和米撒，他們都是以掃妻子巴實抹的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","以掃的妻子阿何利巴瑪是祭便的孫女、亞拿的女兒，她給以掃生了耶烏施、雅蘭和可拉。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","以下是以掃子孫中的族長。 以掃的長子以利法的子孫中有提幔族長、阿抹族長、洗玻族長、基納斯族長、 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","可拉族長、迦坦族長、亞瑪力族長，他們都是以利法在以東的後代，即亞大的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","以掃的兒子流珥的子孫中有拿哈族長、謝拉族長、沙瑪族長、米撒族長，他們都是流珥在以東的後代，即以掃的妻子巴實抹的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","以掃的妻子阿何利巴瑪的子孫中有耶烏施族長、雅蘭族長和可拉族長。這些都是以掃的妻子、亞拿的女兒阿何利巴瑪子孫中的族長。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","這些族長都是以掃的子孫，以掃又名以東。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","以下是住在以東境內何利人西珥的兒子：羅坍、朔巴、祭便、亞拿、 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","底順、以察、底珊。這些西珥的兒子是以東境內何利人的族長。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","羅坍的兒子是何利和希幔，羅坍的妹妹是亭納。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","朔巴的兒子是亞勒文、瑪拿轄、以巴錄、示玻和阿南。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","祭便的兒子是埃亞和亞拿，在曠野為父親放驢時發現溫泉的就是亞拿。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","亞拿的兒子是底順、女兒名叫阿何利巴瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","底順的兒子是欣但、伊是班、益蘭和基蘭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","以察的兒子是辟罕、撒番和亞干。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","底珊的兒子是烏斯和亞蘭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","以下是何利人的族長：羅坍族長、朔巴族長、祭便族長、亞拿族長、 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","底順族長、以察族長、底珊族長。他們是西珥地區何利人各宗族的族長。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","以色列人有君王統治之前，在以東做王的人如下： ");
INSERT INTO cmncbt_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","比珥的兒子比拉在以東做王，定都亭哈巴。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","比拉死後，波斯拉人謝拉的兒子約巴繼位。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","約巴死後，提幔地區的戶珊繼位。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","戶珊死後，比達之子哈達繼位，定都亞未得，他曾在摩押平原擊敗米甸人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","哈達死後，瑪士利加人桑拉繼位。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","桑拉死後，大河邊的利河伯人掃羅繼位。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","掃羅死後，亞革波的兒子巴勒·哈南繼位。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","亞革波的兒子巴勒·哈南死後，哈達繼位，定都巴烏，他的妻子名叫米希她別，是米·薩合的孫女、瑪特列的女兒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","以下是按宗族在各地區做族長的以掃的後代：亭納、亞勒瓦、耶帖、 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","阿何利巴瑪、以拉、比嫩、 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","基納斯、提幔、米比薩、 ");
INSERT INTO cmncbt_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","瑪基疊、以蘭。這些人在所住的以東各地做族長。以掃是以東人的始祖。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","雅各住在他父親寄居的迦南， ");
INSERT INTO cmncbt_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","以下是有關雅各一家的記載。 十七歲的少年約瑟跟哥哥們，就是他父親雅各的妾辟拉和悉帕生的兒子們一同放羊。他向父親報告哥哥們做的壞事。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","約瑟是以色列年老時生的，眾子中以色列最愛他，為他做了一件彩衣。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","約瑟的哥哥們見父親偏愛他，就懷恨在心，對他惡言相向。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","約瑟做了一個夢，並告訴了哥哥們，他們更恨他了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","約瑟對哥哥們說：「你們聽聽我做的夢： ");
INSERT INTO cmncbt_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","我們在田裡捆莊稼，我捆的莊稼站立起來，你們捆的莊稼都圍著我捆的莊稼下拜。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","他的哥哥們回答說：「難道你真要做我們的王嗎？真要統治我們嗎？」因為約瑟的夢和他說的話，他們就更加恨他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","後來，約瑟又做了一個夢，他又去對哥哥們說：「你們聽聽我做的另一個夢，我夢見太陽、月亮和十一顆星星都向我下拜。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","約瑟把夢告訴了父親和哥哥們，他父親就責備他說：「你做的是什麼夢！難道你的父母弟兄真的都要來向你俯伏下拜嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","約瑟的哥哥們嫉恨他，他父親卻把這些話記在心裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","約瑟的哥哥們到示劍放父親的羊。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","以色列對約瑟說：「你哥哥們在示劍放羊，我要派你去他們那裡。」約瑟說：「好的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","以色列說：「你去看看你哥哥們以及羊群是否平安，然後回來告訴我。」於是，他派約瑟從希伯崙谷出發，前往示劍。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","有人見約瑟在田野走迷了路，就問他：「你在找什麼？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","約瑟回答說：「我在找我哥哥們，你知道他們在哪裡放羊嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","那人說：「他們已經走了，我聽他們說要到多坍去。」約瑟就趕往多坍，在那裡找到了他們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","約瑟的哥哥們遠遠看見他走來，趁他還沒有到跟前，就合謀要殺死他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","他們彼此商量說：「看！做夢的來了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","來吧！我們殺了他，把他扔在井裡，就說有野獸把他吃掉了，看他的夢怎麼實現。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","呂便聽後想救約瑟的性命，就說：「我們不要害他性命。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","他又說：「不要殺人流血，把他扔在這曠野的井裡吧，不要下手害他。」呂便想從他們手上救下約瑟，把他交回給父親。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","這時候，約瑟來到哥哥們那裡，他們就剝去他身上的彩衣， ");
INSERT INTO cmncbt_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","抓住他把他扔到井裡。當時，那口井是乾的，沒有水。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","他們坐下來吃飯的時候，抬頭看見一支從基列來的以實瑪利商隊用駱駝馱著香料、乳香、沒藥去埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","猶大對他的眾弟兄說：「我們殺死弟弟、掩蓋他的血跡有什麼益處呢？ ");
INSERT INTO cmncbt_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","不如把他賣給以實瑪利人，不要下手害他，他畢竟是我們的弟弟，我們的骨肉啊！」其他弟兄都贊成他的意見。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","於是，那些米甸商人經過的時候，他們就把約瑟從井裡拉上來，以四兩銀子的價錢把他賣給了以實瑪利人。這些商人把他帶到埃及去了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","呂便回到井邊發現約瑟不見了，就傷心地撕裂了身上的衣服， ");
INSERT INTO cmncbt_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","回到弟兄們那裡說：「那少年不見了，我現在怎麼辦？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","他們宰了一隻公山羊，把約瑟的彩衣拿來沾上血， ");
INSERT INTO cmncbt_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","拿去給父親，說：「我們撿到這件衣服，你看看是不是你兒子的？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","雅各認出那件彩衣，說：「這是我兒子的衣服，一定是野獸把他吃了，約瑟一定被撕碎了！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","雅各撕裂自己的衣服，腰間束上麻布，為約瑟哀傷了好多天。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","他的兒女都來安慰他，他卻不肯接受他們的安慰，說：「我一定會悲悲傷傷地下到陰間，去我兒子那裡。」約瑟的父親為他哀哭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","那些米甸人把約瑟帶到埃及後，賣給了法老的內臣護衛長波提乏。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","那時，猶大離開了他的兄弟們，到亞杜蘭人希拉的家裡住。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","他在那裡遇見了迦南人書亞的女兒，就娶她為妻，與她同房。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","她懷孕生了一個兒子，猶大給他取名叫珥。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","她又懷孕生了一個兒子，給他取名叫俄南。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","她再次懷孕生了一個兒子，給他取名叫示拉。示拉是在基悉出生的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","猶大給長子珥娶了她瑪為妻。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","耶和華見猶大的長子珥邪惡，就取走了他的性命。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","猶大對俄南說：「你要與嫂子她瑪同房，向她盡娶寡嫂的本分，好替你哥哥傳宗接代。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","俄南知道生了兒子也不歸自己，所以每次與她瑪同房都把精液遺在地上，以免給哥哥留後。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","耶和華見俄南行為邪惡，就取走了他的性命。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","猶大恐怕示拉會像他的兩個哥哥一樣死去，就對兒媳她瑪說：「示拉還沒有長大，你先回娘家守寡吧。」她瑪就回娘家去住了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","多年後，猶大的妻子，即書亞的女兒死了。喪期過後，猶大就和他的朋友亞杜蘭人希拉去亭拿，到給他剪羊毛的人那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","有人告訴她瑪說：「你公公上亭拿去剪羊毛了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","她瑪見示拉已經長大，卻仍然沒有娶她，就脫下寡婦的衣服，用帕子蒙上臉，換了裝束，坐在去亭拿路上的伊拿印城門口。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","猶大看見她蒙著臉，以為她是妓女， ");
INSERT INTO cmncbt_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","就走到路邊去找她，說：「你來陪我睡覺吧。」猶大不知道她是自己的兒媳婦。她瑪問道：「我陪你睡覺，你給我什麼呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","猶大回答說：「我會從羊群中取一隻山羊羔送給你。」她瑪問道：「羊還沒有送來以前，你給我什麼作抵押呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","猶大問：「你要什麼作抵押呢？」她瑪說：「我要你的印、印帶和你的手杖。」猶大給了她，然後跟她睡覺。她瑪就懷了孕。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","事後，她瑪起來走了。她拿掉蒙臉的帕子，仍舊穿上寡婦的裝束。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","猶大託他的朋友亞杜蘭人送去一隻山羊羔，要從那女人手中換回抵押物，卻找不到她。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","他的朋友就問當地的人：「伊拿印路旁的廟妓在哪裡？」他們回答說：「這裡沒有廟妓。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","他的朋友只好回去對猶大說：「我找不著她，當地人說那裡沒有廟妓。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","猶大說：「讓她留著我的東西吧，免得我們成為笑柄。反正我把羊送過去了，只是你找不到她。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","大約過了三個月，有人告訴猶大說：「你的兒媳婦她瑪不守婦道，並且懷孕了。」猶大說：「把她拉出來燒死！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","他們正要把她拉出來，她請人傳信給她公公，說：「這些東西的主人使我懷了孕，請你看看這印、印帶和杖是誰的？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","猶大認出是自己的東西，就說：「她比我更有理，因為我沒有讓兒子示拉娶她。」猶大沒有再與她睡覺。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","她瑪臨產的時候，才知道腹中是一對雙胞胎。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","生產的時候，一個嬰兒先伸出手來，接生婆就把一條紅線繫在他的手上，說：「他是先出生的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","可是那嬰兒隨後卻把手縮回去，他的胞兄先出生了，接生婆說：「你怎麼衝出來了！」因此，他的名字叫法勒斯。 ");
INSERT INTO cmncbt_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","後來，那個手上繫有紅線的孩子也出生了，給他取名叫謝拉。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","約瑟被以實瑪利商人帶到埃及，賣給了一個埃及人，他是法老的內臣護衛長波提乏。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","約瑟住在他的埃及主人家中，耶和華與他同在，使他凡事亨通。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","他主人看出耶和華與他同在，使他凡事亨通， ");
INSERT INTO cmncbt_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","就賞識他，讓他服侍自己，派他管理自己的家務及其一切所有。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","自從埃及人波提乏派約瑟管理自己家中一切事務以後，耶和華因為約瑟的緣故而賜福埃及人的家，使他家裡和田間的一切都蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","於是，波提乏把一切事都交給約瑟管理，除了自己要吃的食物以外，什麼也不管。 約瑟體格健壯，相貌英俊。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","後來，他主人的妻子看中了約瑟，向他眉目傳情，要引誘他上床。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","約瑟拒絕了她，說：「我主人信任我，家裡一切事務概不過問，都交給我管理。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","在這家裡，沒有人比我權力更大了，我主人把一切都交給了我，唯獨你除外，因為你是他的妻子。我怎能做如此惡事得罪上帝呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","但她還是每天勾引約瑟，約瑟不從，並儘量避開她。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","一天，約瑟進屋裡辦事，那時屋裡沒有其他人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","她抓住約瑟的外衣，硬要與他上床。約瑟丟下外衣，逃了出去。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","她見約瑟丟下外衣逃了出去， ");
INSERT INTO cmncbt_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","就叫來家裡的人，對他們說：「你們看，我丈夫帶回家的這個希伯來人戲弄我們！他進來要與我上床，我就大聲呼喊， ");
INSERT INTO cmncbt_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","他聽見我大聲喊叫，就把衣服丟在我這裡，逃了出去。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","她把約瑟的外衣留在身邊，等她丈夫回來後， ");
INSERT INTO cmncbt_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","就對他說：「你帶回來的那個希伯來奴隸進來要調戲我， ");
INSERT INTO cmncbt_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","我大聲喊叫，他就把衣服丟在我這裡，逃了出去。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","波提乏聽了妻子講述約瑟如何對待她之後，勃然大怒， ");
INSERT INTO cmncbt_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","把約瑟關進王囚禁犯人的監牢。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","約瑟坐牢的時候，耶和華與他同在，恩待他，使監獄長賞識他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","監獄長把獄中所有囚犯及一切事務都交給約瑟管理。 ");
INSERT INTO cmncbt_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","凡交到約瑟手中的事情，監獄長都很放心，因為耶和華與約瑟同在，使他凡事亨通。 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","後來，埃及王的酒侍和膳司得罪了他們的主人埃及王， ");
INSERT INTO cmncbt_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","法老對這兩個臣僕發怒， ");
INSERT INTO cmncbt_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","把他們囚禁在護衛長波提乏府內的監牢裡，也就是約瑟被囚的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","護衛長派約瑟去伺候他們。他們在監牢待了一段日子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","一天晚上，關在監獄中的埃及王的酒侍和膳司兩人都做了夢，他們的夢各有不同的意思。 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","第二天早上，約瑟過來見他們神情沮喪， ");
INSERT INTO cmncbt_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","就問這兩位同被關在他主人府內的法老臣僕：「你們今天為什麼滿面愁容？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","他們回答說：「我們都做了夢，可是沒有人能給我們解夢。」約瑟說：「解夢不是上帝的事嗎？請你們把夢告訴我。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","酒侍便把自己的夢告訴約瑟，說：「我夢見我前面有一棵葡萄樹， ");
INSERT INTO cmncbt_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","樹上有三根枝子，枝子發芽開花，結出串串成熟的葡萄。 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","我手上拿著法老的酒杯，摘下葡萄，把汁擠在酒杯中，然後遞到法老手中。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","約瑟說：「這夢的意思是，三根枝子代表三天， ");
INSERT INTO cmncbt_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","三天之內，法老必讓你出頭並官復原職。你仍要和從前一樣伺候法老飲酒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","當你再被重用的時候，請你記得恩待我，在法老面前提及我，救我出獄。 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","我是從希伯來人那裡被拐來的，無辜被囚在監牢。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","膳司見夢解得好，就對約瑟說：「我也做了個夢，我夢見自己頭上頂著三筐白餅， ");
INSERT INTO cmncbt_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","最上面的一筐裡放著為法老烤製的各種食物，有鳥來吃我頭上筐內的食物。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","約瑟說：「這夢的意思是，三筐就是三天， ");
INSERT INTO cmncbt_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","三天之內，法老必砍下你的頭，把你掛在木頭上，鳥要來吃你的肉。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","第三天是法老的生日，他宴請文武百官，把酒侍和膳司從監牢裡提出來， ");
INSERT INTO cmncbt_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","恢復了酒侍的職位，讓他仍舊伺候自己飲酒， ");
INSERT INTO cmncbt_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","卻將膳司掛在木頭上，正應驗了約瑟的話。 ");
INSERT INTO cmncbt_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","然而，法老的酒侍沒有記念約瑟，竟把他遺忘了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","兩年後，法老做了個夢，夢見自己站在尼羅河邊， ");
INSERT INTO cmncbt_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","有七頭肥美、健壯的母牛從河裡上來，在蘆葦叢中吃草。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","隨後又有七頭醜陋、瘦弱的母牛從河裡上來，與那七頭母牛一同站在河邊。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","後來，七頭醜陋、瘦弱的母牛吃掉了七頭肥美、健壯的母牛。這時，法老醒了過來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","之後，他又睡著了，又做了個夢。他夢見一株麥子上長了七個飽滿的穗子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","後來這株麥子上面又長了七個乾癟的穗子，它們被東風吹焦了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","七個乾癟的穗子吞食了七個飽滿的穗子。法老醒過來，原來是一場夢。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","早上法老心中不安，就派人召來埃及所有的術士和智者，把夢告訴他們，可是沒有一個人能為他解夢。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","這時酒侍對法老說：「我今天才想起我的罪過。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","我從前和膳司惹法老生氣，被他囚禁在護衛長府內的牢裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","一天晚上，我倆都做了夢，我們的夢各有不同的意思。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","當時有一個希伯來青年跟我們一起被囚在牢裡，他是護衛長的僕人。我們把夢告訴他，他就分別為我們解夢。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","後來，他為我們解的夢都應驗了，我恢復了原職，膳司被掛在木頭上處死了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","於是，法老派人去召約瑟，他們急忙從牢裡釋放約瑟。約瑟剃頭刮臉，更換衣服，去見法老。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","法老對約瑟說：「我做了一個夢，沒有人能為我解夢。我聽說你能解夢。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","約瑟回答說：「我自己不會解夢，但上帝卻能給王圓滿的解釋。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","法老對約瑟說：「我夢見自己站在尼羅河邊， ");
INSERT INTO cmncbt_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","有七頭肥美、健壯的母牛從河裡上來，在蘆葦叢中吃草。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","隨後又有七頭醜陋、瘦弱的母牛從河裡上來，我在全埃及從來沒有見過有這麼醜陋的牛。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","這些醜陋、瘦弱的母牛吃掉先前的七頭肥母牛。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","可是，牠們吃了以後就像沒吃一樣，仍然和以前一樣醜陋。這時，我就醒了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","後來我又夢見一株麥子，上面長了七個飽滿的穗子， ");
INSERT INTO cmncbt_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","接著又長出七個被東風吹焦的乾癟穗子， ");
INSERT INTO cmncbt_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","這些乾癟的穗子吞了那七個飽滿的穗子。我把夢告訴了術士，卻沒有人能為我解夢。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","約瑟對法老說：「王的夢都是同一個意思，上帝已經藉著夢把祂將要做的事指示王了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","七頭肥美的母牛和七個飽滿的穗子都代表七年，是同樣的意思。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","隨後上來的七頭瘦弱、醜陋的母牛和七個乾癟、被東風吹焦的穗子也代表七年，是七年饑荒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","正如我剛才說的，上帝已經把祂將要做的事向王顯明了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","埃及全境很快會有七年大豐收， ");
INSERT INTO cmncbt_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","隨後是七年饑荒肆虐全國，之前的豐收將被忘記。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","饑荒將非常嚴重，之前的豐收將蕩然無存。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","王的夢出現了兩次，表示上帝的心意已定，上帝必很快成就這事。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","王應該選一個精明聰慧的人，派他治理埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","王也應該在各地委派官員，在七年豐收期內徵收全國出產的五分之一， ");
INSERT INTO cmncbt_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","把在豐年收集的糧食儲存在各城，歸王管理。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","這些糧食要留到埃及七年饑荒時用，免得這片土地被饑荒毀滅。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","法老和他所有的臣僕都贊同約瑟的建議。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","法老對臣僕說：「我們哪裡找像這樣有上帝的靈同在的人呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","法老對約瑟說：「上帝既然把夢的意思指示給你，可見沒人有你這樣的見識和智慧。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","你要管理我家，我的人民都要遵從你的命令，只有我權力比你大。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","法老又說：「我現在派你治理埃及全國。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","於是，法老摘下手上用來蓋印的戒指，戴在約瑟的手上，給他穿上細麻袍，把金鏈戴在他頸上， ");
INSERT INTO cmncbt_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","讓他坐在自己的第二輛御車上，並有人在御車前高呼：「跪下！」這樣，法老派約瑟治理整個埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","法老對約瑟說：「我是法老，但沒有你的命令，埃及的任何人都不得擅自行事。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","法老賜給約瑟一個名字，叫撒發那忒·巴內亞，又把安城祭司波提非拉的女兒亞西納賜給他為妻。約瑟巡視了整個埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","約瑟三十歲開始為法老效勞，他離開法老去巡視埃及各地。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","七個豐年之內，埃及糧食大豐收， ");
INSERT INTO cmncbt_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","約瑟收集埃及七個豐年出產的所有糧食，儲藏進各城，每一座城附近出產的糧食都存放在本城。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","約瑟積存了大量五穀，多如海沙，不可勝數。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","荒年到來前，安城祭司波提非拉的女兒亞西納給約瑟生了兩個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","約瑟給長子取名叫瑪拿西，因為他說：「上帝使我忘記一切困苦和父親全家。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","約瑟給次子取名叫以法蓮，因為他說：「上帝使我在受苦之地昌盛。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","七個豐年結束後， ");
INSERT INTO cmncbt_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","七個荒年接踵而至，正如約瑟所言。各地都有饑荒，只有埃及全國有糧食。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","後來，埃及全國也遭遇饑荒，百姓就向法老求糧，法老對他們說：「你們去找約瑟吧，要照他的吩咐做。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","饑荒蔓延到整個埃及時，約瑟便開倉賣糧給埃及人。那時，埃及的饑荒非常嚴重。 ");
INSERT INTO cmncbt_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","各地的人都到埃及來向約瑟買糧，因為天下到處都是大饑荒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","雅各得知埃及有糧食，就對兒子們說：「你們為什麼還在這兒互相觀望呢？ ");
INSERT INTO cmncbt_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","我聽說埃及有糧食，你們快到埃及去買些糧食回來吧，我們好活命，不致餓死。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","於是，約瑟的十個哥哥下到埃及買糧。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","雅各沒有讓約瑟的弟弟便雅憫與他們同去，恐怕他會遭害。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","以色列的兒子們加入了買糧的行列，因為迦南也遭遇饑荒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","那時，約瑟治理埃及，負責賣糧給百姓。約瑟的哥哥們來到他面前，向他俯伏下拜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","約瑟一眼就認出了他們，卻不動聲色。他疾言厲色地問道：「你們從哪裡來？」他們回答說：「我們是從迦南來買糧食的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","約瑟認得他哥哥們，但他哥哥們卻認不出他來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","約瑟想起了自己從前做的兩個夢，就對他們說：「你們是奸細，是來探聽我們虛實的！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","他們說：「我主啊，不是的！僕人們是來買糧的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","僕人們都是一個父親所生，是誠實人，不是奸細。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","約瑟說：「不對，你們是來探聽我們虛實的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","他們說：「僕人們共有弟兄十二人，父親住在迦南，最小的弟弟在父親身邊，還有一個已經去世。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","約瑟說：「我說你們是奸細一點不錯。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","我以法老的性命起誓，你們最小的弟弟不來這裡，你們都不能走，這是對你們的驗證。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","你們派一個人回去把你們的弟弟帶來，其他人都要被囚禁在這裡，我要看看你們說的是真還是假。要是你們說的是假話，我以法老的性命起誓，你們一定是奸細。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","於是，約瑟把他們囚禁了三天。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","到了第三天，約瑟對他們說：「我是敬畏上帝的人，你們照我的話做就能活命。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","如果你們是誠實人，就把一個人留在監牢，其他人帶糧食回去接濟你們的家人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","但你們一定要帶你們最小的弟弟回來，以證實你們說的是實話，這樣你們就不會死。」他們同意了， ");
INSERT INTO cmncbt_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","彼此議論說：「我們一定是在遭報應。從前我們的弟弟苦苦地哀求我們，我們卻不理會，現在這場痛苦臨到我們了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","呂便說：「我不是勸你們不要犯罪害那孩子嗎？你們不聽，現在我們必須償還血債了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","他們不知道約瑟聽得懂他們的話，因為約瑟是通過翻譯跟他們談話。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","約瑟聽後轉身出去哭了，然後又回來跟他們談話，從他們中間選了西緬，當著他們的面把西緬捆綁起來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","約瑟又吩咐人把他們的袋子裝滿糧食，把各人買糧的錢放在他們的口袋中，還為他們預備了路上的食物。僕人一一辦妥了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","約瑟的哥哥們把糧食馱在驢上，啟程離去。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","他們來到一處住宿的地方，其中一人打開口袋拿飼料餵驢，卻發現自己的錢在裡面， ");
INSERT INTO cmncbt_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","就對其他弟兄說：「你們看，我的錢被退回來了，在我的口袋裡！」他們心驚膽戰地彼此議論說：「上帝這樣對待我們是什麼意思呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","他們回到他們在迦南的父親雅各那裡，把事情的經過告訴了他， ");
INSERT INTO cmncbt_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","說：「埃及的宰相對我們說話很兇，還把我們當成去那裡打探的奸細。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","我們對他說，『我們是誠實人，不是奸細。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","我們是一個父親所生的十二兄弟，其中有一個已經去世，年紀最小的跟父親留在迦南。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","那地的宰相卻對我們說，『我要看看你們是不是誠實人，你們把一個弟兄留在我這裡，其他人帶糧食回去接濟家人吧。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","但你們要把最小的弟弟帶來見我，這樣我便知道你們不是奸細，是誠實人。我就會釋放你們的弟兄，你們也可以在這裡自由地買賣。』」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","後來他們倒口袋時，發現每個人買糧的錢袋都在自己的口袋裡，他們和父親看見錢袋，都害怕起來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","他們的父親雅各說：「你們使我連連失去兒子，約瑟沒了，西緬沒了，你們還要帶走便雅憫！災禍都落在了我頭上！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","呂便對父親說：「要是我不把便雅憫帶回你身邊，你就殺了我的兩個兒子！請你把便雅憫交給我，我一定會把他帶回你身邊。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","雅各說：「我的兒子不可跟你們去。他哥哥已經死了，現在只剩下他。要是他在路上遇到什麼意外，你們會使我這白髮蒼蒼的老人淒淒慘慘地下陰間。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","那地方的饑荒仍然非常嚴重， ");
INSERT INTO cmncbt_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","他們從埃及帶回來的糧食吃完了，他們的父親對他們說：「你們再去買些糧食吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","猶大說：「那人嚴厲地警告我們，『不把你們的弟弟帶來，你們就不要再來見我。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","你若讓弟弟跟我們同去，我們就去給你買糧。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","你若不讓他跟我們同去，我們就不去給你買糧。因為那人說，『你們不把弟弟帶來，就不要再來見我。』」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","以色列說：「你們為什麼這樣害我，告訴他你們還有一個弟弟呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","他們回答說：「那人詳細詢問我們和我們家人的情況，問我們的父親是否在世，還有沒有弟兄。我們如實回答，怎會想到他非要我們把弟弟帶去呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","猶大對父親以色列說：「你就讓這孩子跟我同去吧，我們好立刻動身，這樣我們一家老小才能保住性命，不致餓死。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","我親自擔保他的安全，你可以向我要人。我若不把他帶回來見你，情願一生擔罪。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","我們若是沒有耽擱的話，現在已經往返兩趟了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","他們的父親以色列說：「事到如今，只好這樣了。你們袋子裡帶一些上好的乳香、蜂蜜、香料、沒藥、榧子和杏仁等土產，去送給那人作禮物吧。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","你們還要帶雙倍的錢，好歸還上次留在你們口袋中的錢，那次可能是弄錯了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","帶你們的弟弟去見那人吧！ ");
INSERT INTO cmncbt_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","願全能的上帝叫那人憐憫你們，讓西緬和便雅憫回來。我若喪子就喪子吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","於是，他們就帶著便雅憫、禮物和雙倍的錢去埃及見約瑟。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","約瑟看見便雅憫和他們同來，就對管家說：「你帶他們到我家裡去，宰殺牲畜，預備宴席，中午他們要跟我一起吃飯。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","管家照約瑟的吩咐，帶他們到約瑟家裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","他們被帶到約瑟家後非常害怕，說：「他把我們帶到這裡來，是因為上次放回我們口袋的錢。他想害我們，強迫我們做他的奴僕，搶我們的驢。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","他們走到約瑟的管家跟前，在房門口對他說： ");
INSERT INTO cmncbt_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","「主啊，我們上次曾來這裡買糧。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","但在回家的途中住宿時，我們打開口袋，發現我們帶來買糧的錢分毫不少地放在那裡。我們把這些錢帶回來了， ");
INSERT INTO cmncbt_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","又另外帶了一些錢來買糧。我們不知道誰把買糧的錢放進了我們的口袋。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","管家說：「你們放心，不要害怕，你們口袋裡的錢財是你們的上帝，你們父親的上帝賜給你們的。我已經收了你們買糧的錢。」他就把西緬帶出來見他們， ");
INSERT INTO cmncbt_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","接著帶他們進約瑟的家，給他們水洗腳，給他們的驢餵草料。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","他們知道要在那裡吃午餐，就預備好禮物，等約瑟中午回來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","約瑟回到家裡後，他們就把帶來的禮物獻給他，向他俯伏下拜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","約瑟向他們問好，然後說：「你們提起過你們的老父親，他安康嗎？還健在嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","他們回答說：「你僕人——我們的父親仍然健在，安康。」說完了，又向他下拜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","約瑟抬眼看見了自己的同胞弟弟便雅憫，就問道：「這就是你們所說那位最小的弟弟嗎？」他又對便雅憫說：「孩子，願上帝施恩給你。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","約瑟愛弟之心油然而生，急忙出去找哭的地方。他到自己的房間裡哭了一場。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","他洗過臉出來，控制著自己的感情，吩咐人擺飯。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","約瑟自己一桌，他的弟兄們一桌，那些和他們一起吃飯的埃及人一桌，因為埃及人厭惡希伯來人，不與他們同席。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","約瑟讓他的弟兄們按照長幼次序在他對面坐，他們面面相覷，非常驚訝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","約瑟吩咐人把自己面前的菜餚分給他們，便雅憫得的那份比其他弟兄多五倍。他們盡情地和約瑟一同吃喝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","約瑟吩咐管家說：「給他們的口袋裝滿糧食，他們能帶多少就裝多少，把各人的錢放回他們的口袋中， ");
INSERT INTO cmncbt_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","再把我的銀杯和買糧的錢一起放在最小的兄弟的口袋中。」管家遵命而行。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","清早，他們就牽著驢被送走了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","他們出城不久，約瑟對管家說：「你快去追他們，追上了就對他們說，『你們為什麼以惡報善？ ");
INSERT INTO cmncbt_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","為什麼偷我主人用來喝酒和占卜的銀杯？你們這是作惡！』」 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","於是，管家追上他們，按約瑟的話問他們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","他們回答說：「我主為什麼這樣說？我們絕不會做這種事。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","你看，我們把上次在口袋裡發現的錢都從迦南帶回來還你了，又怎麼會偷你主人家的金銀呢？ ");
INSERT INTO cmncbt_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","你若在僕人中任何人身上搜到銀杯，他就要死！我們也要做我主的奴僕。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","管家說：「好，就照你們的話做吧！銀杯從誰那裡搜出來，誰就做我的奴僕，其他人都沒有罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","於是，他們急忙把各自的口袋卸到地上打開。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","管家就從最年長的開始搜查，結果在最年幼的便雅憫口袋裡搜出了銀杯。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","他們傷心地撕裂衣服，把東西放回驢背上，返回城裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","猶大和他兄弟們回到約瑟家時，約瑟還在那裡，他們就俯伏在他面前。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","約瑟對他們說：「你們做的是什麼事？難道你們不知道像我這樣的人是懂得占卜的嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","猶大說：「我們能對我主說什麼呢？我們還有什麼話可說呢？我們如何洗脫罪名呢？上帝既然查出你僕人們的罪，我們跟那個手上被發現有銀杯的一起做我主的奴僕吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","約瑟回答說：「不！我決不會這樣做。從誰那裡搜出了銀杯，誰就做我的奴僕，其他人平安地回去見你們的父親吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","猶大近前來對他說：「我主啊，你就像法老一樣，求你容僕人說一句話，不要向僕人發怒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","我主曾經問僕人們是否有父親和弟兄， ");
INSERT INTO cmncbt_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","我們對我主說，『我們有年邁的老父，他在晚年得了一個兒子，這孩子的哥哥已經死了，他母親只剩下他這一個兒子，他父親很疼愛他。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","你吩咐僕人們把弟弟帶來給你親眼看看， ");
INSERT INTO cmncbt_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","我們對我主說，『這孩子不能離開他父親，他若離開，他父親一定會死。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","可是，你說如果僕人們不把最小的弟弟帶來，就不得再見你的面。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","我們回到你僕人——我們的父親那裡，把我主的話告訴了他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","「後來，他又吩咐僕人們回來買些糧， ");
INSERT INTO cmncbt_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","我們告訴他，我們不能來，只有我們最小的弟弟同來，我們才能來。否則，我們不能見你的面。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","你僕人——我的父親就對我們說，『你們知道，我妻子給我生了兩個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","其中一個離我而去，我想他一定被野獸撕碎了，我再沒有見過他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","要是你們把這個也帶走，遇上什麼意外的話，你們會使我這白髮蒼蒼的老人淒淒慘慘地下陰間。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","「我們父親的命與這孩子的命緊密相連，倘若我沒有把這孩子帶回到你僕人——我的父親身邊， ");
INSERT INTO cmncbt_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","他一看這孩子不在，一定會死。僕人們會使自己白髮蒼蒼的父親淒淒慘慘地下陰間。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","僕人曾經向父親擔保這孩子的安全，說我若不把這孩子帶回他身邊，情願一生擔罪。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","現在請准許僕人代替這孩子做我主的奴僕，讓他跟他哥哥們回去吧。 ");
INSERT INTO cmncbt_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","這孩子若不和我一同回去，我如何見我父親呢？我不願看到災難臨到我父親。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","約瑟在侍從面前再也控制不住自己，於是令所有侍從都出去。這樣，約瑟跟弟兄們相認時，沒有外人在場。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","約瑟放聲大哭，埃及人聽見了他的哭聲，法老家也聽到了消息。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","約瑟對他的弟兄們說：「我是約瑟！我的父親還健在嗎？」他的弟兄們嚇得說不出話來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","約瑟叫他們走近一點，等他們靠近了，便說：「我是被你們賣到埃及的弟弟約瑟！ ");
INSERT INTO cmncbt_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","現在，你們不要因為把我賣到這裡而自怨自責。上帝差我先來這裡，是為了保住大家的性命。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","地上的饑荒已經兩年了，我們還有五年不能種、不能收。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","上帝差我先來，是要為你們保留後代，又要大施拯救，保住你們的性命。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","這樣看來，不是你們，是上帝把我送到這裡的。祂使我成為法老的宰相，管理他的家和整個埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","你們快回去告訴我父親，他兒子約瑟說，『上帝已經使我管理整個埃及，請你立刻來我這裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","你可以帶著你的子孫、牛羊及一切所有住在歌珊。那裡離我很近， ");
INSERT INTO cmncbt_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","我可以奉養你，以免你和全家老少及僕婢牲畜都陷入絕境，因為還有五年的饑荒。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","你們和我弟弟便雅憫都親眼看見了，這是我親口對你們說的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","你們要把我在埃及享有的尊榮和你們見到的一切都告訴父親，儘快把他接來。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","約瑟和弟弟便雅憫抱頭痛哭， ");
INSERT INTO cmncbt_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","又親吻其他哥哥，抱著他們痛哭，然後弟兄們跟他交談起來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","約瑟的弟兄們到來的消息傳到法老的王宮，法老和他的臣僕都感到高興。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","法老對約瑟說：「你去吩咐你的弟兄給牲畜馱上貨物，返回迦南， ");
INSERT INTO cmncbt_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","把你們的父親和家眷都接到我這裡。我要把埃及最好的土地賜給他們，讓他們享受這裡肥美的物產。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","吩咐你的弟兄從埃及帶著車去把他們的妻子、兒女和你們的父親接來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","不要捨不得你們在迦南的財產，因為埃及全國的美物都是你們的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","以色列的兒子們就這樣做了。約瑟遵照法老的吩咐，為他的弟兄們預備好車輛和路上需用的糧食， ");
INSERT INTO cmncbt_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","又給他們每人一套新衣服，但給了便雅憫五套新衣服和三百塊銀子。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","約瑟送給父親十頭公驢，馱著埃及的美物，還送了十頭母驢，馱著糧食、餅和其他食物，讓父親路上用。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","約瑟送弟兄們回去，臨行前囑咐他們路上不要爭吵。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","於是，他們離開埃及，回到迦南的父親雅各那裡， ");
INSERT INTO cmncbt_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","對父親說：「約瑟還活著，並且做了埃及的宰相。」雅各驚呆了，不敢相信他們的話。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","雅各聽了他們轉述約瑟的話，又看見約瑟派來接他的車，才回過神來。 ");
INSERT INTO cmncbt_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","以色列說：「我信了！我兒約瑟還活著，我要在死之前去見他。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","以色列帶著他所有的一切來到別示巴，向他父親以撒的上帝獻祭。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","晚上，上帝在異象中對他說：「雅各！雅各！」他說：「我在這裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","上帝說：「我是上帝，是你父親的上帝，不要害怕下到埃及，因為我要使你在那裡成為大族。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","我必跟你一起下到埃及，也必帶領你回來，約瑟必為你送終。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","於是，雅各從別示巴啟程。以色列的兒子們帶著父親和妻兒，乘坐法老派來的車， ");
INSERT INTO cmncbt_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","帶著在迦南獲得的牲畜和財物前往埃及。這樣，雅各帶著他所有的子孫， ");
INSERT INTO cmncbt_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","就是他的兒子、孫子、女兒和孫女一起去了埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","以下是去埃及的以色列人，即雅各和他後代的名字。 雅各的長子是呂便， ");
INSERT INTO cmncbt_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","呂便的兒子是哈諾、法路、希斯倫和迦米。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","西緬的兒子是耶姆利、雅憫、阿轄、雅斤、瑣轄和迦南女子生的掃羅。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","利未的兒子是革順、哥轄和米拉利。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","猶大的兒子是珥、俄南、示拉、法勒斯和謝拉，珥和俄南死在了迦南，法勒斯的兒子是希斯崙和哈姆勒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","以薩迦的兒子是陀拉、普瓦、約伯和伸崙。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","西布倫的兒子是西烈、以倫和雅利。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","這些都是利亞在巴旦·亞蘭給雅各生的兒孫，加上女兒底娜共有三十三人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","迦得的兒子是洗非芸、哈基、書尼、以斯本、以利、亞羅底和亞列利。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","亞設的兒子是音拿、亦施瓦、亦施韋、比利亞和他們的妹妹西拉，比利亞的兒子是希別和瑪結。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","這些是悉帕給雅各生的兒孫，共有十六人，悉帕是拉班給女兒利亞的婢女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","雅各的妻子拉結生的兒子是約瑟和便雅憫。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","約瑟在埃及生的兒子是瑪拿西和以法蓮，他們的母親是安城祭司波提非拉的女兒亞西納。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","便雅憫的兒子是比拉、比結、亞實別、基拉、乃幔、以希、羅實、姆平、戶平和亞勒。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","這些是拉結給雅各生的兒孫，共有十四人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","但的兒子是戶伸。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","拿弗他利的兒子是雅薛、沽尼、耶色和示冷。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","這些是辟拉給雅各生的兒孫，共有七人，辟拉是拉班給女兒拉結的婢女。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","跟雅各一同到埃及去的兒孫共有六十六人，他的兒媳婦不算在內。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","加上約瑟在埃及生的兩個兒子，雅各一家來到埃及的共有七十人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","雅各派猶大先去見約瑟，請他派人引路到歌珊去。他們來到歌珊， ");
INSERT INTO cmncbt_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","約瑟備好車前去迎接父親以色列。父子重逢，約瑟抱住父親哭了很久。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","以色列對約瑟說：「我現在看到你還活著，就是死也安心了。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","約瑟對他的弟兄們和其他家人說：「我要上奏法老，『我在迦南的弟兄和父親全家已經來到我這裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","他們是牧人，以畜牧為業，已經把羊群、牛群和所有的一切都帶來了。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","等法老召見你們，問你們以什麼為業， ");
INSERT INTO cmncbt_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","你們要說，『僕人們跟我們的祖先一樣，從小以畜牧為業。』這樣，你們就可以住在歌珊，因為埃及人厭惡牧羊的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","約瑟來到法老面前，對他說：「我父親和我的弟兄們已經帶著他們的羊群、牛群和所有的一切從迦南來了，現在就在歌珊。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","約瑟從弟兄中帶了五個人去見法老。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","法老問他們：「你們做什麼工作？」他們回答說：「僕人們祖祖輩輩都是牧羊的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","迦南的饑荒很嚴重，羊群沒有草吃，所以我們到這裡來寄居，求你准許僕人們住在歌珊。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","法老對約瑟說：「你父親和弟兄們都來了， ");
INSERT INTO cmncbt_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","整個埃及就在你面前，儘管安排他們住在國中最好的地方。他們可以住在歌珊。如果你知道他們中間有能幹的人，可以派他們看管我的牲畜。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","約瑟又帶父親雅各去見法老，雅各就為法老祝福。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","法老問雅各：「你多大歲數了？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","雅各回答說：「我在世上寄居一百三十年了，我的日子又苦又短，不像我祖先當年那樣高壽。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","雅各為法老祝福後，就告退了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","約瑟遵照法老之命把埃及最好的地方蘭塞境內的土地給他父親和弟兄們居住，作他們的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","約瑟按各家人口供應糧食給父親、弟兄及其他家人。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","饑荒很嚴重，到處都缺糧，埃及和迦南都飽受饑荒之苦。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","約瑟把埃及人和迦南人向他買糧的銀子收集起來，存放在法老的庫房裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","埃及人和迦南人的銀子都用光了，埃及人就來見約瑟，對他說：「我們的錢財都用光了，求你給我們糧食，免得我們餓死在你面前。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","約瑟說：「你們的錢財如果用盡了，可以用你們的牲畜來交換糧食。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","於是，他們把牲畜趕到約瑟那裡，用他們的牛、羊、驢和馬跟約瑟換糧食。那一年，他們就依靠換來的糧食生活。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","到了第二年，他們又來見約瑟，對他說：「不瞞我主，我們的錢都用光了，牲畜也給我主了，除了我們自己和田地以外，我們一無所有。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","求你不要讓我們人死地荒。我們願意用自己和我們的田地來換糧食，我們和我們的田地都歸法老。求你給我們種子，我們好活下去，不致餓死，土地也不致荒廢。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","埃及人為饑荒所迫，紛紛賣掉自己的田地。約瑟替法老收購了埃及全國的田地，最後，所有的田地都歸法老了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","約瑟使埃及全境的人都成為法老的奴僕。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","約瑟唯獨沒有買祭司的田地，因為祭司吃法老的俸祿，有足夠的供給，不用賣地。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","約瑟對百姓說：「我為法老買了你們和你們的土地，這裡有種子，你們可以拿去耕種。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","但是你們在收成時要把五分之一給法老，其餘的，你們可以留下來作種子和全家人的口糧。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","他們說：「你救了我們的命，願你恩待我們，我們願做法老的奴僕。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","於是，約瑟立下一條關於埃及土地的法令，到今天還有效，就是埃及出產的五分之一歸給法老。只有祭司的田地不歸法老。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","以色列人住在埃及的歌珊，在那裡獲得了產業，人口興旺。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","雅各在埃及住了十七年，享年一百四十七歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","以色列快要離世的時候，把兒子約瑟叫來，說：「你如果恩待我，請把手放在我大腿底下起誓，你會以慈愛和信實待我，不把我葬在埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","我與祖先同眠後，你要把我帶出埃及，安葬在我祖先的墓地。」約瑟說：「我必照你說的做。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","他要約瑟起誓，約瑟就向他起誓。於是，以色列在床頭敬拜上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","後來，有人來通知約瑟，說他父親病了，約瑟就帶著兩個兒子瑪拿西和以法蓮去探望父親。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","雅各聽說他兒子約瑟來了，就強撐著從床上坐起來， ");
INSERT INTO cmncbt_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","對約瑟說：「全能的上帝曾經在迦南的路斯向我顯現，賜福給我。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","祂對我說，『我必使你生養眾多，人丁興旺，並把迦南賜給你的子孫永遠作產業。』 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","「我來之前，你在埃及生的兩個兒子以法蓮和瑪拿西都算我的，他們跟呂便和西緬一樣是我的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","除了他們以外，你其他子女仍然歸你，這些子女可以在他們弟兄的名下繼承產業。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","我從巴旦回來的路上，拉結死在了迦南，那地方離以法他還有一段路程，我把她葬在通往以法他的路旁。」以法他就是伯利恆。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","以色列看見約瑟的兩個兒子，就問：「他們是誰？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","約瑟說：「是上帝在這裡賜給我的兒子。」以色列說：「把他們帶過來，我要祝福他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","以色列年紀老邁，眼睛昏花，看不清楚。約瑟把兒子帶到他面前，他就親吻他們、擁抱他們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","以色列對約瑟說：「我以為再也見不到你了，上帝竟然還讓我見到了你的兒子！」 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","約瑟把兩個兒子從以色列的膝上領開，自己向父親俯伏下拜， ");
INSERT INTO cmncbt_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","隨後左手牽著瑪拿西，右手牽著以法蓮，把他們分別領到以色列的右邊和左邊。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","但以色列卻兩手交叉，把右手放在約瑟次子以法蓮的頭上，左手放在約瑟長子瑪拿西的頭上。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","他祝福約瑟說：「願我祖先亞伯拉罕和以撒敬拜的上帝，就是牧養我一生直到今天的上帝， ");
INSERT INTO cmncbt_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","救我脫離一切患難的天使，賜福這兩個孩子。願我和我祖先亞伯拉罕及以撒的名字藉著他們流傳。願他們在地上子孫興旺。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","約瑟見父親把右手放在以法蓮的頭上，感到不悅，就把父親的右手從以法蓮的頭上挪到瑪拿西頭上， ");
INSERT INTO cmncbt_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","對父親說：「父親，你弄錯了，這才是長子，你應該把右手按在他的頭上。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","他父親卻不同意，說：「我兒啊，我知道，我知道。他必發展成一個強大的民族，但他弟弟將比他更強大，他弟弟的後裔必成為多個民族。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","雅各那天祝福他們，說：「以色列人必引用你們的名祝福人，說，『願上帝使你們像以法蓮和瑪拿西一樣！』」他把以法蓮排在瑪拿西前面。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","以色列對約瑟說：「我快死了，但上帝必與你們同在，帶你們回到你們祖先的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","我要把我用刀和弓從亞摩利人手上奪來的那塊地留給你，讓你比其他弟兄多得一份。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","雅各把他的兒子們都叫來，對他們說：「你們到我身邊來，我要把你們將來的遭遇告訴你們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","「雅各的兒子們啊， 你們要聚在一起聽， 聽你們父親以色列的話。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","呂便啊，你是我的長子， 是我年輕力壯時生的， 卓有尊榮和力量。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","可是，你必不再居首位， 因為你放縱情慾， 如沸騰不止的水， 你上了你父親的床， 玷污了我的榻。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","「西緬和利未是兄弟， 他們依仗刀劍，殘暴不仁。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","我的靈不可與他們同謀。 我的心不可與他們聯合。 他們洩憤殺人， 隨意砍斷牛腿的筋。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","他們狂怒兇殘，該受咒詛！ 我要使他們分散在雅各的子孫中， 散居在以色列各地。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","「猶大啊，你的兄弟們必讚美你， 你的手必掐住仇敵的頸項， 你父親的兒子必向你下拜。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","我兒猶大是頭小獅子， 他獵食回來，躺臥如雄獅， 蹲伏如母獅，誰敢驚擾他？ ");
INSERT INTO cmncbt_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","權杖必不離猶大， 御杖必伴他左右， 直到執掌王權的那位來到， 萬民都必歸順他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","「他把小驢拴在葡萄樹旁， 把驢駒拴在上好的葡萄樹旁； 他在葡萄酒中洗衣服， 在葡萄汁中洗外袍。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","他的眼睛比酒烏潤， 他的牙齒比奶潔白。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","「西布倫必安居在海濱， 成為泊船的港口， 他的疆界必伸展到西頓。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","「以薩迦是頭壯驢， 臥在羊圈中。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","他見那地方好作安身之處， 地土肥美，就垂下肩頭， 做了苦役。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","「但必治理他的人民， 作以色列的一個支派。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","他必成為路邊的蛇， 道旁的毒蛇， 咬傷馬蹄，使騎馬的人墜落。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","「耶和華啊， 我切切等候你的拯救。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","「迦得必被強盜劫掠， 他卻要反敗為勝追趕他們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","「亞設必有豐美的出產和供君王享用的美味。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","「拿弗他利是頭自由的母鹿， 養育美麗的小鹿。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","「約瑟是多結果子的枝條， 長在水泉旁， 他的枝條探出牆外。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","弓箭手兇猛地攻擊他， 惡狠狠地射他。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","但他手持強弓， 雙臂穩健有力， 因為雅各的大能者出手相助， 祂是以色列的牧者和磐石。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","你父親的上帝必幫助你， 全能者必賜你天上的福氣、 地下深淵蘊藏的福氣， 使你子孫興旺、牛羊滿圈。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","你父親的祝福高過亙古的峰巒， 多如永存的群山， 願這一切祝福都臨到約瑟頭上， 臨到這超越眾弟兄的人身上。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","「便雅憫是匹貪婪的狼， 早晨吞吃獵物， 晚上瓜分戰利品。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","以上是以色列的十二支派，他們的父親按著他們不同的福分給他們祝福。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","雅各又囑咐他們說：「我要離世了，你們要把我葬在赫人以弗崙田間的洞裡，讓我與祖先在一起。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","那洞穴在迦南的幔利附近的麥比拉田間，是亞伯拉罕向赫人以弗崙買來作墳地的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","亞伯拉罕和他的妻子撒拉，以撒和他的妻子利百加都葬在那裡，我把利亞也葬在了那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","那塊田和田間的洞穴是向赫人買的。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","雅各囑咐完眾子，把腳收到床上，嚥了氣，歸到他祖先那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","約瑟伏在父親身上痛哭，親吻他， ");
INSERT INTO cmncbt_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","然後吩咐醫生用香料保存父親的遺體。醫生遵命而行， ");
INSERT INTO cmncbt_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","按照常例花了四十天用香料處理遺體。埃及人為他哀悼七十天。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","哀悼的日子完了，約瑟對法老宮中的人說：「如果你們恩待我， ");
INSERT INTO cmncbt_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","請告訴法老，我父親死前要我起誓把他葬在迦南他自己預備好的墳地。請准許我到迦南去安葬我父親，我辦完喪事就回來。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","法老說：「去按照你的誓言埋葬你父親吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","於是，約瑟啟程去埋葬他的父親，隨行的有法老所有的臣僕和埃及所有的達官顯貴， ");
INSERT INTO cmncbt_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","以及約瑟全家、他的眾弟兄和雅各的家眷，只有他們的孩子和牛羊仍然留在歌珊。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","隨行的還有大隊車輛和騎兵，人數眾多。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","他們來到約旦河附近的亞達麥場，在那裡痛哭哀悼。約瑟為父親哭喪七天。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","迦南人看見他們在亞達麥場痛哭，就說：「埃及人在痛哭哀悼。」因此，約旦河附近的那個地方叫亞伯·麥西。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","雅各的兒子們遵照父親的遺言， ");
INSERT INTO cmncbt_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","把父親的遺體帶回迦南，安葬在幔利附近、麥比拉田間的洞裡。洞和田地都是亞伯拉罕向赫人以弗崙買來作墳地的。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","葬禮之後，約瑟就跟眾弟兄和一切隨行的人返回埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","約瑟的哥哥們見父親死了，就說：「約瑟會不會懷恨在心，因我們以前惡待他而報復我們呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","於是，他們派人去對約瑟說：「你父親臨終時交待這樣的話給你， ");
INSERT INTO cmncbt_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","『從前你哥哥們惡待你，求你饒恕他們的罪惡和過犯。』我們是你父親的上帝的僕人，求你饒恕我們的罪惡。」約瑟聽見這些話，就哭了。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","約瑟的哥哥們來見他，俯伏在他面前，說：「我們是你的奴僕。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","約瑟對他們說：「你們不要害怕，我豈能代替上帝？ ");
INSERT INTO cmncbt_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","從前你們是要加害於我，但上帝有祂的美意，祂藉此保全許多人的性命，正如今日的光景。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","因此，你們不要害怕，我會照顧你們和你們的兒女。」約瑟好言好語地寬慰他們。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","約瑟和他父親全家住在埃及。約瑟享年一百一十歲。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","他看到了以法蓮的孫子，也曾把瑪拿西的兒子瑪吉剛出生的孩子抱在膝上。 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","一天，約瑟對他的弟兄們說：「我快要死了，但上帝必看顧你們，帶你們離開這裡，回到祂起誓應許給亞伯拉罕、以撒和雅各的地方。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","約瑟讓以色列的子孫起了誓，並說：「上帝必看顧你們，你們要把我的骸骨帶回迦南。」 ");
INSERT INTO cmncbt_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","約瑟享年一百一十歲。他們把他的遺體用香料保存好，放在棺材裡，停放在埃及。");
INSERT INTO cmncbt_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","以色列的眾子帶著家眷跟雅各一起去了埃及，以下是他們的名字： ");
INSERT INTO cmncbt_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","呂便、西緬、利未、猶大、 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","以薩迦、西布倫、便雅憫、 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","但、拿弗他利、迦得、亞設。 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","雅各的子孫總共有七十人。那時，約瑟已經住在埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","後來，約瑟和他的弟兄以及同輩的人都相繼去世。 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","以色列人生養眾多，人口大增，很快就遍佈埃及，成為一個強大的民族。 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","後來，埃及有一位不認識約瑟的新王登基， ");
INSERT INTO cmncbt_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","對他的百姓說：「你們看，以色列人比我們多，又比我們強。 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","來吧！我們要設法阻止他們人口增多，否則一遇到戰爭，他們便會加入我們敵人的陣營來攻打我們，然後一走了之。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","於是，埃及人派監工強迫以色列人服勞役，在比東和蘭塞兩地為法老興建儲貨城。 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","以色列人越受奴役，人口增長得越快，散居的範圍也越廣，令埃及人感到恐懼。 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","於是，埃及人殘酷地奴役他們， ");
INSERT INTO cmncbt_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","強迫他們和泥造磚，並做田間一切的苦工，使他們痛苦不堪。埃及人殘酷地奴役他們做苦工。 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","埃及王又命令兩個希伯來的接生婆施弗拉和普阿： ");
INSERT INTO cmncbt_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","「你們在替希伯來婦女接生的時候，如果看到生下的是男嬰，就把他殺掉；如果是女嬰，就讓她活下來。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","但這兩個接生婆敬畏上帝，沒有執行埃及王的命令，而是保留了男嬰的性命。 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","埃及王召見那兩個接生婆，質問她們：「你們為什麼這樣做？為什麼讓男嬰活著？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","她們回答說：「因為希伯來婦女跟埃及婦女不同。她們身體強壯，我們還沒有趕到，嬰兒就生下來了。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","因此，以色列人口繼續增加，更加繁盛。因為這兩個接生婆敬畏上帝，上帝便賜福給她們，使她們生兒育女。 ");
INSERT INTO cmncbt_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","後來，法老命令全埃及的人把以色列人生的所有男嬰都拋進尼羅河裡，只讓女嬰活著。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","有一個利未族的人跟他同族的女子結婚。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","那女子懷孕，生了一個男嬰。她看見孩子可愛，就把他藏了三個月。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","後來無法再藏下去，她就拿來一個蒲草籃子，外面塗上防水的瀝青和柏油，然後把嬰兒放在裡面，又把籃子放在尼羅河邊的蘆葦叢中。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","嬰兒的姐姐遠遠地站著，要看看她的弟弟究竟會怎樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","這時，法老的女兒來到河邊沐浴，宮女們在河邊行走。公主發現了蘆葦叢中的籃子，便吩咐一個婢女去把它取來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","公主打開一看，原來是一個男嬰。公主看見孩子在哭，就可憐他，說：「他是希伯來人的孩子。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","嬰兒的姐姐對公主說：「我去找一個希伯來婦女當奶媽，為你哺養他好嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","公主回答說：「好！」那女孩就跑去把嬰孩的母親帶來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","公主對那婦女說：「你把孩子抱去，替我哺養他，我會給你工錢。」她便把孩子抱去哺養。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","孩子漸漸長大，她便把他帶到公主那裡，孩子就做了公主的兒子。公主給孩子取名叫摩西，意思是「我把他從水中拉了上來」。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","後來，摩西長大了，他去看望做苦工的希伯來同胞，看見一個埃及人在毆打他的一個希伯來同胞。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","他左右觀望，見四下無人，便下手殺了那埃及人，把屍體埋藏在沙地裡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","第二天，他又出去，看見兩個希伯來人在打架，便過去對理虧的人說：「你為什麼打自己的同胞呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","那人說：「誰立你作我們的首領和審判官？難道你要殺我，像殺那個埃及人一樣嗎？」摩西聽了，害怕起來，心想：「我做的事一定被人知道了。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","法老聽說這件事後，便想殺死摩西。摩西為了躲避法老，就逃到米甸居住。一天他坐在一口井旁， ");
INSERT INTO cmncbt_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","米甸祭司的七個女兒來打水，要把水倒進槽裡飲她們父親的羊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","這時，來了另外一群牧人要把她們趕走。摩西便起來幫助她們，打水飲她們的羊群。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","她們回到父親流珥那裡，父親問道：「你們今天怎麼這麼快就回來了？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","她們答道：「有一個埃及人救我們免遭牧人的欺負，還幫我們打水飲羊群。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","他又問女兒們：「現在那人在哪裡？你們怎麼可以丟下他不管呢？去請他來吃點東西。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","後來，摩西同意住在那人家裡。那人把女兒西坡拉許配給他。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","後來，西坡拉生了一個兒子，摩西給他取名叫革舜，意思是「我成了在異鄉寄居的人」。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","過了多年，埃及王死了。以色列人受盡奴役，就哀歎呼求，聲音傳到上帝那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","上帝聽見他們的哀聲，顧念從前跟亞伯拉罕、以撒、雅各所立的約， ");
INSERT INTO cmncbt_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","就垂顧他們，體恤他們。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","摩西為岳父米甸祭司葉特羅放羊。一天他領著羊群穿越曠野，來到上帝的山——何烈山。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","忽然有耶和華的天使在荊棘的火焰中向他顯現。摩西看見荊棘雖然在燃燒，卻沒有被燒毀。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","摩西想：「我要過去看這個奇異的景象，荊棘為什麼沒有被燒掉呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","耶和華上帝見他要上前觀看，就從荊棘叢中呼喚他說：「摩西！摩西！」摩西說：「我在這裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","上帝說：「別再靠近，脫下你腳上的鞋，因為你所站的地方是聖地。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","又說：「我是你祖先的上帝，是亞伯拉罕的上帝，以撒的上帝，雅各的上帝。」摩西害怕看上帝，就把臉蒙起來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","耶和華說：「我已經看見我子民在埃及所受的苦難，聽見了他們因監工的壓迫而發出的呼求。我知道他們的痛苦。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","我下來是要從埃及人手中救他們，帶他們離開那裡，到一個遼闊肥沃的奶蜜之鄉，就是現在迦南人、赫人、亞摩利人、比利洗人、希未人和耶布斯人居住的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","現在，以色列人的呼求傳到我耳中，我也看到了埃及人怎樣壓迫他們。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","現在去吧，我要派你到法老那裡，帶我的以色列子民出埃及。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","但摩西對上帝說：「我是誰啊？怎麼能去見法老，帶以色列人出埃及呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","上帝說：「我必與你同在，你帶百姓出埃及後，你們必在這座山上事奉我——這將是我派你去的證據。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","摩西問上帝：「假如我到以色列人那裡，對他們說，『你們祖先的上帝派我來你們這裡。』他們如果問我，『祂叫什麼名字？』我該怎樣回答他們呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","上帝對摩西說：「我是自有永有者。你要這樣回答以色列人，『那位自有永有者派我到你們這裡。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","上帝又對摩西說：「你要告訴以色列人是我派遣你到他們那裡，我是他們祖先的上帝耶和華，是亞伯拉罕的上帝，以撒的上帝，雅各的上帝。耶和華是我的名字，直到永遠，世世代代的人都要這樣稱呼我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","你去招聚以色列的長老，對他們說，『你們祖先的上帝耶和華，就是亞伯拉罕、以撒、雅各的上帝向我顯現，說祂關切你們，知道你們在埃及的遭遇。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","祂應許要帶領你們脫離在埃及所受的苦難，到迦南人、赫人、亞摩利人、比利洗人，希未人和耶布斯人住的地方，那裡是奶蜜之鄉。』 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","以色列的長老們必定聽從你的話，你就跟他們一起去見埃及王，對他說，『希伯來人的上帝耶和華向我們顯現。現在請你容許我們走三天的路程，到曠野去，向我們的上帝耶和華獻祭。』 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","我也知道除非我用大能的手向他施壓，不然埃及王不會讓你們離開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","因此，我必伸手行各種神蹟攻擊埃及，之後他必讓你們離開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","我必使埃及人恩待你們，好叫你們不致空手離開埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","你們的婦女只管向埃及鄰居及住在鄰居家的婦女索取金器、銀器和衣服，給自己的兒女穿戴，你們必這樣奪取埃及人的財物。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","摩西回答說：「他們不會相信我，也不會聽我的話，他們會說，『耶和華根本沒有向你顯現。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","耶和華對摩西說：「你手裡拿的是什麼？」摩西說：「是一根手杖。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","耶和華說：「把它扔在地上！」於是，摩西把杖扔在地上，杖變成了一條蛇。摩西連忙跑開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","耶和華說：「你伸手抓住牠的尾巴！」摩西就伸手抓蛇的尾巴，蛇在他手中變回了杖。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","耶和華說：「這樣，他們就會相信他們祖先的上帝耶和華，就是亞伯拉罕、以撒和雅各的上帝，曾經向你顯現。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","耶和華又說：「把手放進懷裡。」摩西把手放進懷裡，手抽出來的時候，竟患了痲瘋病，像雪一樣白。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","耶和華說：「再把手放進懷裡。」摩西又把手放進懷裡，這次再抽出來的時候，手已經復原，跟其他地方的皮肉一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","耶和華說：「縱然他們不聽你的話，不信第一個神蹟，也必定相信第二個神蹟。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","如果他們兩個神蹟都不相信，還是不聽你的話，你就從尼羅河裡取些水來倒在旱地上，那水就會在旱地上變成血。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","摩西對耶和華說：「主啊！我向來不善言辭，即使你對僕人說話以後，我還是不善言辭，因為我是個拙口笨舌的人。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","耶和華對他說：「是誰造人的口舌？是誰使人啞巴或耳聾？是誰使人目明或眼瞎？豈不都是我耶和華嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","去吧！我必賜給你口才，指示你說什麼話。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","但是摩西說：「主啊，請派其他人去吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","耶和華向摩西發怒說：「利未人亞倫不是你哥哥嗎？我知道他是個能言善辯的人，正要來迎接你。他見到你一定很歡喜。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","你要把該說的話傳給他，我會賜你們口才，教你們如何行事。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","他要替你向百姓說話，做你的發言人，你對他來說就像上帝一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","你要把手杖帶在身邊，以便行神蹟。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","摩西回到家裡，對他的岳父葉特羅說：「求你讓我回埃及去探望我的親人，看看他們是否在世。」葉特羅說：「你平安地去吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","耶和華在米甸對摩西說：「你只管放心回埃及去，想害你性命的人都已經死了。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","於是，摩西拿著上帝的杖，帶著妻子和兒子騎驢返回埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","耶和華對摩西說：「你到了埃及，務要照我賜給你的能力在法老面前行神蹟。但我要使他的心剛硬，他必不讓百姓離開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","那時，你就告訴法老，『耶和華說，以色列是我的長子， ");
INSERT INTO cmncbt_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","我對你說過讓我的長子出去事奉我，但你執意不肯。看啊，我要殺你的長子。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","摩西在途中夜宿的時候，耶和華遇見摩西，想要殺他。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","他的妻子西坡拉拿起鋒利的火石，割下兒子的包皮，用它碰摩西的腳，說：「你真是我的血郎。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","這樣，耶和華才放過他。當時，西坡拉說「血郎」是指割禮一事。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","耶和華對亞倫說：「你到曠野去迎接摩西。」他就在上帝的山上遇見摩西，並親吻他。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","摩西把耶和華吩咐他的以及要他行的神蹟都告訴了亞倫。 ");
INSERT INTO cmncbt_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","摩西和亞倫一起回去招聚以色列的眾長老， ");
INSERT INTO cmncbt_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","亞倫把耶和華對摩西的吩咐詳細地告訴他們。摩西又在百姓面前行了那些神蹟， ");
INSERT INTO cmncbt_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","百姓相信了。以色列人聽見耶和華眷顧他們、看到了他們的苦難，都俯伏敬拜祂。 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","之後，摩西和亞倫去見法老，對他說：「以色列的上帝耶和華說，『放我的子民走，讓他們到曠野去為我守節期。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","法老說：「耶和華是誰？我憑什麼要聽從祂，放走以色列人？我不認識祂，也不會讓以色列人離開！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","摩西和亞倫說：「希伯來人的上帝向我們顯現了。求你容我們走三天的路程，到曠野去向我們的上帝耶和華獻祭，免得祂用瘟疫或刀劍來攻擊我們。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","埃及王說：「摩西、亞倫，你們為什麼讓百姓停工！快回去服勞役！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","法老又說：「這地方的以色列人如此多，你竟叫他們停工！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","當天，法老就對埃及監工和以色列人的工頭下令： ");
INSERT INTO cmncbt_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","「不許再供應草給他們製磚，叫他們自己去撿， ");
INSERT INTO cmncbt_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","但上交的磚的數量要和往常一樣，一塊也不可少。因為他們懶惰，所以才嚷著要去給他們的上帝獻祭。 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","你們要加重他們的工作，他們就無暇再聽那些蠱惑人心的話了！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","於是，那些監工和工頭就出來向百姓宣佈：「法老下令不再供應草給你們製磚。 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","你們要自己設法去找，但上交的磚一塊也不能少。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","百姓只好在埃及各地收集禾稭當草用。 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","監工催逼他們說：「你們要完成每天規定的數目，像從前有草時一樣。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","法老的監工又鞭打他們委派的以色列工頭，說：「你們這兩天為什麼沒有像從前一樣完成規定的磚數？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","以色列人的工頭來見法老，向他哀求說：「你為什麼要這樣對待僕人們？ ");
INSERT INTO cmncbt_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","監工不給僕人們草，卻命令我們製作磚，還打我們，其實是你百姓的錯。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","法老說：「你們是懶漢，懶漢！所以才嚷著要去給耶和華獻祭。 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","回去繼續做工！我不再供應草給你們，但磚要如數交齊。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","以色列人的工頭聽見每天做的磚數不可減少，就知道情況不妙。 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","他們從法老那裡出來的時候，遇見摩西和亞倫站在外面等候， ");
INSERT INTO cmncbt_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","便埋怨二人說：「願耶和華鑒察、懲罰你們！你們使我們在法老和他的臣僕面前有了臭名，無異於把刀遞到他們手中來殺我們。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","摩西回到耶和華那裡說：「主啊！你為什麼這樣苦待你的子民呢？為什麼要派我去呢？ ");
INSERT INTO cmncbt_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","自從我去法老那裡奉你的名說話後，他更加虐待你的子民，你卻根本沒有拯救他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","耶和華對摩西說：「你就要看見我怎樣用大能的手對付法老，那時他會讓以色列人走，甚至把他們趕出他的國土！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","上帝又對摩西說：「我是耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","我曾以全能上帝的身分向亞伯拉罕、以撒和雅各顯現，但沒有讓他們知道我的名字是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","我堅守與他們所立的約，要把他們寄居的迦南賜給他們。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","我已聽見以色列人因受埃及人的奴役而發出的哀聲，也顧念我的約。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","所以，你要轉告以色列人說，『我是耶和華。我要解救你們脫離埃及人的轄制，脫離他們的奴役，我要伸出臂膀大行審判，以救贖你們。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","我要接納你們做我的子民，我要做你們的上帝。這樣，你們就知道我是你們的上帝耶和華，曾救你們脫離埃及人的轄制。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","我必帶領你們進入我舉手起誓要給亞伯拉罕、以撒和雅各的那片土地，把它賜給你們作產業。我是耶和華。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","摩西把這番話轉告百姓，可是他們因為殘酷的勞役無比沮喪，不肯聽他的話。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","「你去告訴埃及王法老，讓以色列人離開他的土地。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","摩西卻說：「以色列人都不聽我的話，法老又怎麼肯聽我這拙口笨舌的人呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","耶和華吩咐摩西和亞倫回到以色列人和法老那裡，要他們領以色列人離開埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","以下是以色列各家族的族長： 以色列長子呂便的兒子是哈諾、法路、希斯倫和迦米。這些是呂便的宗族。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","西緬的兒子是耶姆利、雅憫、阿轄、雅斤、瑣轄和掃羅，掃羅的母親是迦南人。這些是西緬的各宗族。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","按照家譜的記載，利未的兒子是革順、哥轄和米拉利，利未享年一百三十七歲。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","革順的兒子是立尼和示每，二人各成宗族。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","哥轄的兒子是暗蘭、以斯哈、希伯倫和烏薛，哥轄享年一百三十三歲。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","米拉利的兒子是抹利和姆示。這些按家譜的記載是利未的各宗族。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","暗蘭娶了他父親的妹妹約基別，生了亞倫和摩西，暗蘭享年一百三十七歲。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","以斯哈的兒子是可拉、尼斐和細基利。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","烏薛的兒子是米沙利、以利撒反和西提利。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","亞倫娶了亞米拿達的女兒、拿順的妹妹以利沙巴，她生了拿答、亞比戶、以利亞撒和以他瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","可拉的兒子是亞惜、以利加拿和亞比亞撒，這些是可拉的各宗族。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","亞倫的兒子以利亞撒與普鐵的一個女兒結婚，生了非尼哈。以上是利未各宗族的族長。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","正是亞倫和摩西受耶和華之命，要按以色列人的隊伍把他們帶出埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","也是摩西和亞倫要求埃及王法老讓他們把以色列人帶出埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","那時，耶和華曾經在埃及對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","「我是耶和華，你要把我吩咐你的一切話告訴埃及王法老。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","摩西卻對耶和華說：「你看，我拙口笨舌，法老怎肯聽我的話？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","耶和華對摩西說：「我要使你在法老面前像上帝一樣，你哥哥亞倫是你的發言人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","你要傳達我吩咐你的一切話，你哥哥亞倫要求法老讓以色列人離開他的國家。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","可是，我要使法老的心剛硬，雖然我在埃及行許多神蹟奇事， ");
INSERT INTO cmncbt_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","他仍無動於衷。那時，我必伸手重重地懲罰埃及，然後領我大隊的以色列子民離開埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","我伸手攻擊他們，把以色列人帶出埃及之時，埃及人就會知道我是耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","摩西和亞倫便遵命而行。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","他們去見法老的時候，摩西八十歲，亞倫八十三歲。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","「倘若法老要你們行神蹟給他看，你就吩咐亞倫把手杖扔在法老面前，使杖變作蛇。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","摩西和亞倫照耶和華的吩咐來到法老面前。亞倫把手杖扔在法老和他的臣僕面前，杖就變作蛇。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","法老召智者和巫師前來，這些人是埃及的術士，他們也用邪術如法炮製。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","各人將自己的手杖扔在地上，杖就變作蛇，但亞倫的杖吞噬了他們的杖。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","法老卻仍然硬著心，不肯聽從摩西和亞倫，正如耶和華所言。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","耶和華對摩西說：「法老非常頑固，不肯放百姓走。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","明天早晨，法老會去尼羅河邊，你去河邊見他，要拿著曾變成蛇的手杖。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","你要對他說，『希伯來人的上帝耶和華差遣我來告訴你，要讓祂的子民到曠野去事奉祂，但到如今你還是不肯。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","所以祂說要用手杖擊打尼羅河水，使河水變成血，好叫你知道祂是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","河裡的魚會死，河水會發臭，埃及人不能再喝尼羅河的水。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","耶和華對摩西說：「你告訴亞倫，讓他向埃及境內的各江河、溪流、池塘伸杖，使水變成血。埃及境內，包括木頭和石頭器皿中將到處是血。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","摩西和亞倫就按著耶和華所吩咐的去做，亞倫在法老和他的眾臣僕面前舉杖擊打尼羅河水，河水都變成了血。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","河裡的魚都死了，河水臭得不能飲用。埃及遍地都是血。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","可是，埃及的巫師用邪術同樣使水變成血。法老仍然硬著心，不肯聽從摩西和亞倫的話，正如耶和華所言。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","法老若無其事地轉身回宮去了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","因為河水不能飲用，埃及人就在尼羅河兩岸掘井取水飲用。 ");
INSERT INTO cmncbt_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","耶和華擊打河水後，七天過去了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","耶和華對摩西說：「你去告訴法老，『耶和華說，放我的子民離開，他們好事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","如果你不肯讓他們去，我就使青蛙來毀壞你的全境。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","尼羅河將充滿青蛙，牠們要跳到你的宮裡、臥室和床鋪上，跳到你的臣僕和百姓家裡，跳到你的爐灶和揉麵盆裡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","青蛙還會跳到你和你的百姓及眾臣僕身上。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","耶和華對摩西說：「你叫亞倫向埃及各地的江河、溪流和池塘伸杖，使青蛙遍佈埃及。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","亞倫就向水伸杖，青蛙就遍佈了埃及全境。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","巫師也行邪術如法炮製，使青蛙遍佈埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","法老召摩西和亞倫進宮，對他們說：「你們要祈求耶和華，使這些青蛙離開我和我的百姓，我便讓你們的百姓去獻祭給耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","摩西對法老說：「好吧，你要我在什麼時候為你以及你的臣僕和百姓禱告，叫這些青蛙離開你和你的宮殿，只留在河裡呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","法老說：「明天。」摩西說：「就照你說的，這樣你就知道我們的上帝耶和華獨一無二。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","青蛙會離開你、你的宮殿、你的臣僕和百姓，只留在河裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","摩西和亞倫離開法老後，摩西就為法老所受的蛙災一事向耶和華呼求。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","耶和華答應了摩西的祈求。在房屋內、院子裡和田野中的青蛙都死了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","百姓把青蛙的屍體堆積起來，埃及全境都充滿了死青蛙的腐臭氣味。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","法老看見災難緩解，便又硬著心，不肯聽從摩西和亞倫的話，正如耶和華所言。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","耶和華對摩西說：「你吩咐亞倫伸出他的杖擊打地上的塵土，使埃及境內的塵土變成蝨子。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","他們就照上帝的吩咐去做，亞倫伸杖擊打地上的塵土，蝨子就跑到人和牲畜身上，全埃及的塵土都變成了蝨子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","巫師們也試圖用邪術變出蝨子來，卻無法成功。埃及的百姓和牲畜身上長滿了蝨子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","巫師們對法老說：「這是上帝的作為。」法老仍然硬著心，不肯答應摩西和亞倫的要求，正如耶和華所言。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","耶和華對摩西說：「明天清早，你趁法老去河邊時去見他，告訴他，『耶和華說，放我的子民走，他們好事奉我， ");
INSERT INTO cmncbt_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","不然我就叫成群的蒼蠅飛到你、你的臣僕和百姓身上，進到你們各自的家中，使埃及遍地佈滿蒼蠅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","但那天，我必把我子民居住的歌珊分別出來，那裡必沒有成群的蒼蠅，這樣你就知道我耶和華主宰天下。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","我要把我的子民跟你的百姓分開，明天我必行這神蹟。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","耶和華果然這樣行。密密麻麻的蒼蠅飛進法老的王宮和他臣僕的家裡，埃及全國都受到蒼蠅的毀壞。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","法老召見摩西和亞倫，對他們說：「去吧，就在此地給你們的上帝獻祭吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","摩西說：「這怎麼行？我們獻給我們的上帝耶和華的祭物會令埃及人厭惡。如果我們在埃及人面前獻令他們厭惡的祭物，他們豈不會拿石頭打死我們？ ");
INSERT INTO cmncbt_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","我們要照我們上帝耶和華的吩咐離開這裡，走三天的路程到曠野去獻祭給祂。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","法老說：「我讓你們去曠野獻祭給你們的上帝耶和華，只是不要走得太遠。你們要為我祈求。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","摩西說：「我離開這裡就去祈求耶和華，使成群的蒼蠅明天就離開你及你的臣僕和百姓，但這次你不可再食言，阻止以色列人去向耶和華獻祭。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","摩西說完以後，便離開王宮，去祈求耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","耶和華就照摩西的祈求，使成群的蒼蠅離開法老及其臣僕和百姓，一隻也沒有留下。 ");
INSERT INTO cmncbt_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","這一次，法老又硬著心，不肯讓百姓離開埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","耶和華對摩西說：「你去見法老，告訴他，『希伯來人的上帝耶和華說：放我的子民走，他們好事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","如果你不讓他們走，繼續扣留他們， ");
INSERT INTO cmncbt_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","我必出手使你田間所有的牲畜，包括馬、驢、駱駝和牛羊，都染上嚴重的瘟疫。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","但我要把埃及和以色列的牲畜分開，以色列人的牲畜必絲毫無損。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","耶和華定了日期，說：「明天耶和華必在此地行這事。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","第二天，耶和華就行了這事，埃及人的牲畜都死了，但以色列人的牲畜一頭也沒死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","法老派人去探查，發現以色列人的牲畜一頭也沒死。可是，他仍然心裡頑固，不肯讓以色列人離開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","耶和華對摩西和亞倫說：「你們去取幾把窯裡的灰，摩西要在法老面前把灰拋向空中。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","這灰要變成塵土，散佈在埃及全境，落在人或牲畜身上，就會起皰長瘡。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","摩西和亞倫便取了一些窯裡的灰，站在法老面前，摩西把灰拋向空中，埃及人和牲畜身上就開始起皰長瘡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","埃及的巫師無法與摩西對抗，因為他們及所有埃及人身上都長了膿瘡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","耶和華使法老的心剛硬，他就不聽他們的話，正如耶和華對摩西說的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","耶和華對摩西說：「明天一早你再去見法老，對他說，『希伯來人的上帝耶和華這樣說，你要放我的子民走，他們好事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","這一次，我要降下大災禍在你及你的臣僕和百姓身上，好叫你知道普天之下我獨一無二。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","我若用瘟疫攻擊你和你的百姓，你們早就滅亡了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","我讓你活到現在，是為了向你彰顯我的權能，使我的名傳遍天下。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","但你竟然在我的子民面前狂傲自大，不讓他們離開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","明天大約這時候，我要使天上降下大冰雹，是你們埃及立國以來從沒有見過的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","現在，你要叫人到田間把牲畜和屬於你的一切都帶到安全的地方。凡留在田間的人或牲畜都會被冰雹打死。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","有些法老的臣僕聽了耶和華的話就很害怕，趕忙把在田間的僕人和牲畜都召回屋裡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","但那些不把耶和華的話放在心上的，仍把他們的奴僕和牲畜留在田間。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","耶和華對摩西說：「你向天伸杖，天就會降下冰雹，落在埃及的一切人畜身上，摧毀田間的一切農作物。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","摩西向天伸出手杖，耶和華就發出雷電和冰雹，火光飛向大地。耶和華在埃及降下冰雹。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","那時冰雹夾雜著火降下來，極為嚴重，在埃及史無前例。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","冰雹摧毀了埃及境內田間的一切人、牲畜和作物，打斷了所有的樹木， ");
INSERT INTO cmncbt_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","只有以色列人所住的歌珊沒有冰雹。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","法老派人召來摩西和亞倫，對他們說：「這次我犯罪了，耶和華是對的，我和我的百姓錯了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","請你們向耶和華祈求，我們已經受夠了雷電和冰雹。我准許以色列人出去，你們不必再留在這裡了。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","摩西回答說：「我一出城，就向耶和華舉手禱告，雷電和冰雹必立刻停止，這樣你就知道普天下都屬於耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","但我知道你和你的臣僕還是不敬畏上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","這場冰雹打壞了大麥和亞麻，因為正是大麥吐穗和亞麻開花的時候。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","小麥和粗麥尚未長成，沒有被冰雹打壞。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","摩西離開法老，走出城外向耶和華舉手禱告，雷和冰雹便停了，雨也不下了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","法老看見雨、雷和冰雹停止了，就又犯罪，他和他的臣僕都心裡頑固。 ");
INSERT INTO cmncbt_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","法老硬著心，不讓以色列人離開，正如耶和華藉摩西所言。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","耶和華對摩西說：「你去見法老，我已使他和他臣僕的心剛硬，好在他們當中行我這些神蹟。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","這樣，你就可以把我如何嚴懲埃及人以及我在他們當中所行的神蹟告訴你的子孫，好叫你們知道我是耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","摩西和亞倫便去見法老，對他說：「希伯來人的上帝耶和華說，『你要到什麼時候才肯在我面前謙卑下來？放我的子民走，他們好事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","你若再不答應，明天我要使蝗蟲飛入你的國境。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","牠們鋪天蓋地，要吃光冰雹過後田間所剩的，包括一切樹木。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","你的王宮及臣僕和所有埃及人的房屋都要佈滿蝗蟲，這是你祖祖輩輩從未見過的蝗災。』」摩西說完，便轉身離開法老。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","臣僕對法老說：「這個人害我們要到什麼時候呢？讓他們離開去事奉他們的上帝耶和華吧！埃及快被毀滅了，你不知道嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","法老便召回摩西和亞倫，對他們說：「你們去事奉你們的上帝耶和華吧！但你們誰要去呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","摩西回答說：「我們男女老幼都要去，還有我們的牛群和羊群，因為我們要去守耶和華的節期。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","法老聽後，說：「我若讓你們帶走婦女和孩子，最好耶和華能保護你們！你們真是居心叵測。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","不行！只有男子可以去事奉耶和華，這是你們一直要求的。」法老說完，便下令把他們趕出去。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","耶和華對摩西說：「你向埃及伸杖，使蝗蟲飛來吃盡冰雹過後田野剩下的一切植物。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","摩西就向埃及伸杖。耶和華使東風在埃及境內颳了整整一天一夜，到早晨，東風帶來了蝗蟲。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","埃及到處都佈滿了蝗蟲，數目之多實在是空前絕後。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","蝗蟲遍佈整個埃及，地上一片黑暗。這些蝗蟲吃盡了冰雹過後剩下的農作物和樹上的果子，沒有留下一點青綠。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","法老急忙召見摩西和亞倫，對他們說：「我得罪了你們的上帝耶和華，又得罪了你們。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","現在求你饒恕我的罪，就這一次，為我祈求你們的上帝耶和華撤去這場死亡之災吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","摩西就離開法老出去祈求耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","耶和華就把風向倒轉，變成猛烈的西風，把蝗蟲颳走，吹進紅海。埃及境內一隻蝗蟲也沒留下。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","可是，耶和華又使法老心硬，他不讓以色列人離開埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","耶和華對摩西說：「你向天伸杖，使埃及全境漆黑一片，那黑暗濃得甚至可以摸到。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","摩西向天伸杖，埃及全境便漆黑了三天之久。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","埃及人彼此看不見，誰也不敢移動半步。可是，以色列人住的地方卻有光。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","法老把摩西召來，對他說：「去事奉耶和華吧，你們的婦女和孩子也可以去，但你們要把牛羊留下。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","摩西回答說：「你得允許我們有祭物和燔祭牲獻給我們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","我們要帶走所有的牲畜，一隻蹄子也不留下，因為我們要從其中選一些來獻給我們的上帝耶和華。我們抵達目的地前，還不知道把哪些獻給祂。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","但耶和華使法老的心剛硬，他不肯讓以色列百姓離開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","法老對摩西說：「給我退下！不要再讓我見到你，因為你再見我面之日必死。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","摩西回答說：「你說得好，我必不再見你的面。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","耶和華對摩西說：「我給法老和埃及再降下一場災難，之後他必放你們走，甚至是把你們徹底趕走。 ");
INSERT INTO cmncbt_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","你要告訴以色列人，不論男女，去向鄰近的埃及人索取金器銀器。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","耶和華使埃及人恩待以色列人，法老的臣僕和百姓極其尊重摩西。 ");
INSERT INTO cmncbt_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","摩西說：「耶和華這樣說，『今晚半夜，我要走遍埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","埃及境內，從坐王位的法老的長子到推磨女奴的長子，以及所有頭生的牲畜，都必死亡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","那時整個埃及必充滿哭號聲，慘況空前絕後。 ");
INSERT INTO cmncbt_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","但在以色列人中，連狗也不會向人或牲畜吠叫，這樣你們就知道耶和華把埃及人和以色列人區分開了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","到那時，你所有的臣僕都要來向我下拜，求我和跟隨我的百姓離開這裡。然後我才會離開。』」摩西說完便怒氣沖沖地離開法老。 ");
INSERT INTO cmncbt_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","耶和華曾對摩西說：「法老一定不肯聽你的話，因此我要在埃及多行神蹟。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","摩西和亞倫在法老面前行了這一切神蹟，但耶和華使法老的心剛硬，他不讓以色列人離開他的國土。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","耶和華在埃及對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","「你們要以這個月為一月，為一年之首。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","你要向以色列全體會眾宣佈，本月的第十日，每家都要預備一隻羊羔，一家一隻。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","倘若家人太少，吃不了一隻，可以跟最近的鄰居共享一隻，你們要按人數和各人的食量預備羊羔。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","羊羔必須是毫無殘疾、一歲的公綿羊或公山羊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","以色列全體會眾要把羊留到本月十四日，在黃昏時分宰殺， ");
INSERT INTO cmncbt_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","然後取點血塗在房子的門框和門楣上，他們要在房子裡吃羊肉。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","當晚，你們要用火把羊肉烤熟，與無酵餅和苦菜一起吃。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","不可吃生羊肉，也不可煮著吃，要把整隻羊，連頭帶腿和內臟一併烤著吃。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","不可把肉留到早晨，留到早晨的肉要燒掉。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","你們吃的時候，要束腰、穿鞋、手中拿杖，要趕快吃，這是耶和華的逾越節。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","「因為那一夜我要巡遍埃及，把境內所有長子和頭生的牲畜全都殺掉，也要嚴懲埃及所有的神明。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","塗在你們房屋上的血是一個記號，我見到這血就會越過你們。我擊打埃及的時候，那災禍不會落到你們身上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","你們要記住這一天，守為耶和華的節期，作為世代不變的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","「七天之內你們都要吃無酵餅。第一天，要清除家中所有的酵。任何人若在這七天當中吃有酵的食物，要將他從以色列人中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","在節期的第一天和第七天，你們都要舉行聖會。這兩天所有人都不得工作，除了預備各人要吃的以外，不可做任何工。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","你們要守這除酵節，因為我在這天把你們的大軍從埃及領了出來。你們要守這節期，作為世代不變的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","從一月十四日傍晚開始，直到二十一日傍晚，你們都要吃無酵餅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","在這七天內，你們屋裡不能有酵。任何人若吃了有酵的東西，不論他是寄居者還是本地人，都要將他從以色列會眾中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","無論你們住在哪裡都要吃無酵餅，不能吃任何有酵的食物。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","於是，摩西召集以色列的眾長老，對他們說：「你們家家戶戶都要挑選羔羊，把這逾越節的羔羊宰了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","拿一把牛膝草蘸盆裡的血，把血塗在門楣和兩邊的門框上。天亮前，你們不可踏出門外。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","因為耶和華要巡行各地，擊殺埃及人，祂看見你們的門框和門楣上有血，就必越過你們的家門，不讓滅命者進你們家殺人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","這是你們及後代永遠當守的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","你們進入耶和華應許給你們的地方以後，要守這逾越節。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","當你們的兒女問你們守這節期的意義時， ");
INSERT INTO cmncbt_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","你們就說，『這是獻給耶和華逾越節的祭，因為我們從前在埃及時，祂擊殺埃及人，卻越過以色列人所住的房子，救了我們各家。』」百姓聽了摩西這番話，都俯伏敬拜。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","耶和華怎麼吩咐摩西和亞倫，以色列人就照樣遵行。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","到了半夜，耶和華把所有埃及人的長子都殺了，包括坐王位的法老的長子、牢中囚犯的長子和一切頭生的牲畜。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","當晚，法老及其臣僕和所有埃及人都驚醒了，到處都是哭號聲，因為沒有一家不死人的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","法老連夜召見摩西和亞倫，對他們說：「你們和以色列人起來走吧，離開我的人民。就照你們的要求，去事奉耶和華吧！ ");
INSERT INTO cmncbt_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","照你們的要求，把所有的牛羊都帶走吧！也要為我祝福。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","埃及人催促以色列人趕快離開埃及，因為他們說：「我們都要死了。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","於是，以色列百姓就把沒有酵的麵團放在揉麵盆裡，用衣服包起來扛在肩上， ");
INSERT INTO cmncbt_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","又遵照摩西的吩咐向埃及人索取金器、銀器和衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","耶和華使埃及人恩待以色列人，他們要什麼，埃及人就給什麼。這樣，以色列人奪取了埃及人的財富。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","以色列百姓從埃及的蘭塞啟行，前往疏割，婦女孩童不算在內，單是步行的男子就有六十萬， ");
INSERT INTO cmncbt_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","同行的還有許多外族人和大群的牛羊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","他們用從埃及帶出來的麵團烤成無酵餅，麵團沒有酵，因為他們被催促離開埃及，沒有時間準備食物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","以色列人在埃及共住了四百三十年， ");
INSERT INTO cmncbt_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","正好滿了四百三十年的那一天，耶和華帶領全軍離開了埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","那天晚上是耶和華把祂的子民帶出埃及之夜，因此以後世世代代的以色列人都要在那日守夜，以尊崇耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","耶和華對摩西和亞倫說：「以下是逾越節的條例。 「所有外族人都不可吃逾越節的羊羔， ");
INSERT INTO cmncbt_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","但那些買來的奴隸若接受了割禮，就可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","寄居的外族人和雇工不可吃。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","你們吃的時候，應當在房子裡吃，不得把肉帶到外面去，也不可折斷羊羔的一根骨頭。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","以色列全體會眾都要守這節期。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","跟你們住在一起的外族人如果想為耶和華守逾越節，他全家的男子都必須接受割禮，這樣才可以像以色列人一樣守逾越節，但沒有接受割禮的人絕不可吃逾越節的羊羔。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","本地人和在你們中間寄居的外族人都要遵守這規矩。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","耶和華怎樣吩咐摩西和亞倫，以色列百姓都遵命而行。 ");
INSERT INTO cmncbt_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","就在那一天，耶和華帶領以色列大軍離開了埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","「要把以色列人中的長子和頭生的牲畜分別出來，使之聖潔，歸給我。他們都是我的。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","摩西對百姓說：「你們要記住離開埃及的這一天，因為耶和華用大能的手把你們從受奴役之地解救出來。不可吃帶酵的食物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","你們是在亞筆月的這一天從埃及出來的， ");
INSERT INTO cmncbt_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","將來耶和華帶領你們進入迦南人、赫人、亞摩利人、希未人和耶布斯人居住的土地以後，你們每逢此月都要為祂守節期。那是耶和華向你們祖先起誓，應許賜給你們那奶蜜之鄉。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","在七天的節期內，你們要吃無酵餅，到了第七天，你們要為耶和華守節期。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","七天之內要吃無酵餅，你們境內不得有酵或是帶酵的東西。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","那時，要告訴你們的子孫，『這節期是紀念我們出埃及時，耶和華為我們所做的一切。』 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","這節期對你們而言，就像你們手上的記號和額上的提醒，叫你們記得耶和華的律法，祂曾經用大能的手帶你們出埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","因此，每一年你們都要按時守這節期。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","「耶和華成就祂起誓給你們和你們祖先的應許，領你們進入迦南人的土地，把那裡賜給你們以後， ");
INSERT INTO cmncbt_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","你們要把所有長子和頭生的公畜歸給祂。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","所有頭生的公驢必須用羊羔贖回，不然就要打斷牠們的脖子。要贖回你們所有的長子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","將來你們的子孫問起這件事的意義，你們就回答，『耶和華曾經用大能的手把我們從受奴役之地埃及帶出來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","當時法老硬著心不肯放我們走，所以耶和華就把埃及人的長子和頭生的牲畜全都殺了。因此，我們把所有頭生的公畜當作祭牲獻給耶和華，把所有長子都贖回來。』 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","這事就像你們手上的記號和額上的標記，以牢記耶和華曾用大能的手帶我們出埃及。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","法老讓以色列人離開埃及後，上帝沒有帶領他們穿越非利士地區，雖然那是條捷徑。因為上帝說：「如果他們遇上戰爭，就會改變主意，返回埃及。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","所以，上帝領他們繞道前行，走曠野的路，前往紅海。以色列人離開埃及時都帶著兵器。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","摩西把約瑟的骸骨一起帶走，因為約瑟曾叫以色列人鄭重發誓，對他們說：「上帝必眷顧你們，那時你們要把我的骸骨也一起帶走。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","以色列人從疏割啟程，來到曠野邊緣的以倘安營。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","耶和華走在他們前面，白天用雲柱為他們指示道路，晚上用火柱照亮他們，這樣他們可以日夜趕路。 ");
INSERT INTO cmncbt_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","白天的雲柱和晚上的火柱總不從他們前面離開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","「你吩咐以色列人改變方向，在比·哈希錄附近的海邊紮營，在紅海和密奪之間，對面是巴力·洗分。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","法老必定以為以色列人走迷了路，被困在曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","我要使法老的心剛硬，使他派兵追趕他們。我要在法老和埃及軍兵身上得榮耀，好叫埃及人知道我是耶和華。」於是，以色列人遵命而行。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","有人向埃及王報信，說以色列百姓逃走了。法老和他的臣僕便改變主意，說：「我們怎麼可以讓以色列人就這樣離開我們，不再服侍我們呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","法老便吩咐人預備戰車，他親自領軍， ");
INSERT INTO cmncbt_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","率領埃及所有的戰車，包括六百輛最精銳的戰車，每輛車上都有戰車長。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","耶和華使埃及王法老的心剛硬，法老就追趕毫無懼色地離開埃及的以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","埃及大軍的戰車騎兵傾巢而出，在巴力·洗分對面、比·哈希錄附近的海邊，追上了安營的以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","法老漸漸逼近，以色列人抬頭看見埃及人追了上來，非常害怕，便呼求耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","他們對摩西說：「難道埃及沒有墳地，要你帶我們出來死在曠野嗎？為什麼要帶我們出埃及呢？ ");
INSERT INTO cmncbt_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","我們在埃及豈不是對你說過，別管我們，就讓我們服侍埃及人嗎？服侍埃及人總比死在曠野好啊！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","摩西對百姓說：「你們不要害怕，站穩了，看耶和華今天怎樣解救你們。你們再也看不到你們今天看到的埃及人了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","耶和華必為你們爭戰，你們要保持安靜。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","耶和華對摩西說：「為什麼向我呼求呢？吩咐以色列人往前走吧。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","你舉手向海伸出手杖，把海水分開，以色列人可以從中間的乾地走過去。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","我要使埃及人的心剛硬，他們會尾隨你們下到海中。我要在法老及其大軍、戰車和騎兵身上得榮耀。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","當我在法老及其戰車和騎兵身上得到榮耀時，埃及人就知道我是耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","這時，在以色列隊伍前面領路的上帝的天使，轉到百姓後面，雲柱也隨著移到後面立住。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","雲柱停在埃及隊伍和以色列隊伍的中間，埃及人這邊一片黑暗，以色列人那邊卻有光，彼此整夜都無法接近對方。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","摩西向海伸出手，耶和華便整夜用強勁的東風吹退海水，將海底變成乾地。海水分開後， ");
INSERT INTO cmncbt_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","以色列人踏著乾地走入海中，海水在他們左右形成水牆。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","法老的軍兵車馬緊追不捨，都跟著下到海中。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","到了破曉時分，耶和華從雲柱火柱中俯視埃及軍隊，使他們陷入混亂。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","祂使他們戰車的輪子脫落，難以前行。於是，埃及人說：「我們逃命吧，因為耶和華在幫助以色列人攻擊我們！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","耶和華對摩西說：「你向海伸出手，使海水回流，淹沒埃及人及其戰車和馬兵。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","天剛亮的時候，摩西向海伸出手，海水便恢復原狀。埃及人紛紛向岸上逃命，耶和華卻使大水把他們捲回海中。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","海水回流，法老的戰車和人馬都淹沒在大海之中，全軍覆沒。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","以色列人卻在乾地上走過紅海，海水在他們左右形成水牆。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","那天，耶和華就這樣從埃及人手中拯救了以色列人。以色列人看見埃及人的屍體橫在海邊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","以色列百姓親眼看見耶和華怎樣以大能對付埃及人，他們就敬畏耶和華，又信服祂和祂的僕人摩西。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","那時，摩西和以色列人便歌頌耶和華，說： 「我要歌頌耶和華， 因祂大獲全勝， 祂把戰馬和騎兵都拋進海中。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","耶和華是我的力量，我的詩歌， 也成了我的拯救； 祂是我的上帝，我要讚美祂； 祂是我父親的上帝，我要尊崇祂。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","耶和華是戰士， 祂名叫耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","祂把法老的戰車軍兵都拋進海中， 法老的強將都葬身於紅海， ");
INSERT INTO cmncbt_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","大水淹沒他們， 他們如同石塊沉入深海。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","耶和華啊，你的右手用大能彰顯威榮； 耶和華啊，你的右手擊碎仇敵。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","你大顯威嚴，擊倒那些起來對抗你的人； 你大發雷霆，他們便像枯草遇火， 一燒而盡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","你的鼻孔一呼氣，海水便堆聚起來， 洪濤便堆起水牆，海底深處也都凝固。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","敵人說，『追啊，追上他們， 瓜分他們的財物，盡情擄掠他們， 拔出刀來把他們斬盡殺絕。』 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","你叫風一吹，海水就淹沒他們， 他們好像鉛塊一樣沉沒在怒海中。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","耶和華啊，萬神之中，誰能像你？ 誰能像你——威嚴神聖， 可頌可畏，廣行神蹟？ ");
INSERT INTO cmncbt_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","你伸出右手，大地便吞滅他們。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","你以不變的愛引領你所救贖的子民， 以大能帶他們進入你的聖所。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","各邦聽見這些事就發抖， 非利士人痛苦不堪， ");
INSERT INTO cmncbt_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","以東的族長惶恐不安， 摩押的英雄瑟瑟發抖， 迦南的居民膽戰心驚。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","驚駭恐懼籠罩著他們。 耶和華啊， 你臂膀的大能嚇得他們僵立如石， 直到你的子民都安然走過， 直到你買贖的子民都安然走過。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","耶和華啊， 你要帶領他們到你產業的山上安居， 到你為自己所造的住處， 主啊，到你親手建的聖所。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","「耶和華必做王，直到永永遠遠。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","法老的軍兵車馬追到海中，耶和華使海水回流淹沒他們，以色列人卻踏著乾地走在海中。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","亞倫的姐姐米利暗先知手拿小鼓，帶領眾婦女擊鼓跳舞， ");
INSERT INTO cmncbt_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","唱和道：「要歌頌耶和華，因祂大獲全勝，祂把戰馬和騎兵都拋進海中。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","摩西帶領以色列人離開紅海，來到書珥曠野，走了三天仍然找不到水喝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","到了瑪拉，那裡的水卻是苦的，不能喝。因此那地方叫瑪拉。 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","百姓就埋怨摩西說：「我們喝什麼呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","摩西向耶和華呼求，耶和華就指示他一棵樹，他把樹扔在水中，水就變甘甜了。耶和華又在瑪拉給百姓定下律例和法令，並在那裡試驗他們， ");
INSERT INTO cmncbt_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","說：「你們若留心聽你們上帝耶和華的話，做我視為正的事，聽從我的命令，遵守我的一切律例，我就不把降在埃及的疾病加在你們身上，因為我是醫治你們的耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","到了以琳，那裡有十二股水泉和七十棵棕樹，他們就在水邊安營。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","以色列全體會眾從以琳出發，來到以琳和西奈中間的汛曠野，時值他們離開埃及後的第二個月的十五日。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","以色列全體會眾在曠野向摩西和亞倫發怨言說： ");
INSERT INTO cmncbt_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","「我們還不如當初在埃及就死在耶和華手中。在那裡，我們至少可以圍在肉鍋旁吃個飽。現在，你把我們帶到曠野來，是要叫全體會眾餓死在這裡嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","耶和華對摩西說：「我要從天上降下食物給你們。百姓可以每天出去拾取他們當天所需的分量，這樣我就可以試驗他們是否遵行我的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","到第六天，他們要比平時多拾取一倍的分量。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","摩西和亞倫對以色列百姓說：「今晚你們就知道把你們從埃及領出來的是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","早上，你們會看見祂的榮耀，因為祂聽見了你們向祂所發的怨言。我們算什麼，你們竟埋怨我們？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","摩西又說：「耶和華聽見你們發的怨言了，晚上祂必給你們肉吃，早晨再給你們餅吃個飽。我們算什麼？你們埋怨的其實不是我們，而是耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","摩西對亞倫說：「你去叫以色列全體會眾到耶和華面前來，因為祂已聽見他們的怨言。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","亞倫對以色列全體會眾說話的時候，他們向曠野遠望，果然看見耶和華的榮光在雲彩中顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","「我已經聽見以色列人的怨言。你告訴他們，『到了黃昏，你們就會有肉吃，早晨就會有餅可以吃飽，這樣你們就知道我是你們的上帝耶和華。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","到了傍晚，有許多鵪鶉飛來，把營地都遮蓋了。到了早晨，營區四周的地上佈滿露水， ");
INSERT INTO cmncbt_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","露水蒸發以後，曠野便出現一層薄薄的、像白霜的東西。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","以色列人見了，不知道是何物，便彼此議論說：「這是什麼？」摩西對他們說：「這就是耶和華給你們的食物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","耶和華吩咐你們要按自己和家人的食量來拾取，每人拾取兩升。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","於是，以色列人遵命而行，有人拾的多，有人拾的少。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","後來，他們用升斗量的時候，就發現多拾的沒有剩餘，少拾的也沒有缺乏，剛好是每人所需要的量。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","摩西又吩咐他們說：「你們所拾取的，不可留到早晨！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","可是，有的人不聽，留了一些。到了早上，食物已腐爛生蟲，發出惡臭，摩西就向他們發怒。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","百姓每天早晨出營拾取食物，各人按著所需分量拾取，到太陽升起後，食物就融化了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","到第六天，他們就拾取雙倍的分量，也就是每人四升。會眾的首領來稟告摩西， ");
INSERT INTO cmncbt_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","摩西對他們說：「耶和華說，『明天是安息日，是向耶和華守的聖安息日。你們要把一切食物預備好，或烤或煮，吃剩的可以留到早晨。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","百姓就照摩西的吩咐，把吃剩的食物留到早晨，食物沒有發臭生蟲。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","摩西對他們說：「你們今天就吃這些吧，因為今天是耶和華的安息日，你們在野外找不到食物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","你們有六天可以拾取食物，但第七天是安息日，沒有食物可以拾取。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","到了第七天早晨，有些人仍然出去要拾取食物，結果什麼也找不到。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","耶和華對摩西說：「你們到什麼時候才肯遵行我的誡命和吩咐呢？ ");
INSERT INTO cmncbt_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","要知道，耶和華已將安息日賜給你們，所以第六天我會賜你們雙倍的食物。第七天，人人都要留在營中，不許外出。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","於是，百姓在第七天休息。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","以色列人稱這種食物為嗎哪，它形狀像芫荽的種子，白色，味道像蜜製薄餅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","摩西說：「以下是耶和華的吩咐，『把兩升的嗎哪保存起來，直到世世代代，以便你們的子子孫孫可以看見上帝帶你們離開埃及時，在曠野賜給你們的食物。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","於是，摩西吩咐亞倫：「拿個罐子盛滿兩升的嗎哪，放在耶和華面前，留到世世代代。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","亞倫便照耶和華給摩西的吩咐，把嗎哪放在約櫃前保存起來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","以色列百姓就在曠野吃了四十年的嗎哪，直到他們到達有人煙的地方，到迦南的邊境為止。 ");
INSERT INTO cmncbt_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","當時一俄梅珥等於十分之一伊法。 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","以色列全體會眾按照耶和華的吩咐，從汛曠野啟程，一程一程往前行，來到利非訂安營，可是那裡沒有水喝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","百姓便跟摩西吵鬧，說：「給我們水喝！」摩西便對他們說：「你們為什麼跟我吵鬧？為什麼試探耶和華？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","百姓非常口渴，他們向摩西抱怨說：「你為什麼帶我們出埃及，讓我們一家大小和牲畜都渴死？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","摩西就呼求耶和華說：「我拿這些百姓怎麼辦？他們準備拿石塊打死我！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","耶和華對摩西說：「你帶著之前擊打尼羅河水的杖，率領以色列的幾個長老走在眾人前面。 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","我必在何烈的磐石那裡站在你們面前，你用杖擊打磐石，磐石必流出水來給眾人喝。」摩西便當著以色列長老的面這樣做了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","摩西稱那地方為瑪撒和米利巴，因為以色列人在那裡吵鬧，又試探耶和華，說：「耶和華是否在我們當中？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","後來，亞瑪力人到利非訂攻打以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","摩西對約書亞說：「選一些人出去迎戰亞瑪力人。明天，我會帶著上帝的杖站在山頂上。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","約書亞便遵照摩西的吩咐迎戰亞瑪力人，摩西、亞倫和戶珥上到山頂。 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","摩西什麼時候舉手，以色列人就佔上風；他的手什麼時候垂下，亞瑪力人就佔上風。 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","不久，摩西的手疲倦發軟，亞倫和戶珥就抬來一塊石頭讓摩西坐下，然後站在他的兩邊扶著他的手，他就穩穩地舉著手，直到日落。 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","這樣，約書亞用刀殺敗了亞瑪力人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","耶和華對摩西說：「我要完全抹去世人對亞瑪力人的記憶。你要把這話寫在書卷上作紀念，也要把這話告訴約書亞。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","摩西在那裡築了一座壇，取名叫「耶和華尼西」。 ");
INSERT INTO cmncbt_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","摩西說：「耶和華已經起誓要世代與亞瑪力人爭戰。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","摩西的岳父米甸的祭司葉特羅，聽說上帝為摩西和祂的子民以色列人所做的一切事及如何帶他們出埃及後， ");
INSERT INTO cmncbt_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","就帶著女兒西坡拉和兩個外孫去見摩西。西坡拉是摩西的妻子，摩西曾讓她回娘家暫時居住。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","摩西的兩個兒子一個叫革舜，因為摩西說：「我成了在異鄉寄居的人」； ");
INSERT INTO cmncbt_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","一個叫以利以謝，因為摩西說：「我父親的上帝幫助我，從法老的刀下拯救了我。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","摩西的岳父葉特羅帶著摩西的妻子和兩個兒子來到上帝的山見摩西，就是摩西在曠野安營的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","葉特羅事先差人，把他帶著摩西的妻子和兩個兒子要來的消息通知摩西。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","摩西出去迎接岳父，向他下拜，與他親吻，彼此問安，然後大家都進了帳篷。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","摩西把耶和華為拯救以色列人而向法老和埃及人所行的事，以及怎樣救百姓脫離路上遇見的種種困難，都告訴了葉特羅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","葉特羅為耶和華恩待以色列人、把他們救出埃及而高興， ");
INSERT INTO cmncbt_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","便說：「耶和華當受稱頌，因為祂從埃及人和法老手中拯救了你們，把這百姓從埃及人手中拯救了出來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","我現在知道，耶和華比一切神明都偉大，因為祂懲治了虐待這些百姓的狂妄之徒。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","摩西的岳父葉特羅說完，便向上帝獻燔祭及其他祭物。亞倫和以色列的長老都來與他一起在上帝面前吃飯。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","第二天，摩西坐著審理百姓的糾紛，百姓從早到晚都站在摩西周圍。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","摩西的岳父葉特羅看見摩西對百姓所行的一切，就對摩西說：「你為什麼這樣處理百姓的事？為什麼你獨自坐著，眾百姓從早到晚都站在你周圍？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","摩西對岳父說：「因為他們來我這裡求問上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","他們有糾紛就來我這裡，我為雙方定奪是非，教他們認識上帝的律例和法度。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","摩西的岳父葉特羅勸摩西說：「這不是好方法， ");
INSERT INTO cmncbt_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","你和這些百姓都會疲憊不堪，你一個人無法擔當如此繁重的工作。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","你要聽我的勸告，願上帝與你同在。你要做百姓的代表，把案件奏明上帝， ");
INSERT INTO cmncbt_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","又要教導他們律例和法度，指示他們當行的道、當做的事。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","此外，你要在民中挑選一些敬畏上帝、有才幹、誠實、正直、憎惡不義之財的人，派他們做千夫長、百夫長、五十夫長和十夫長，管理百姓。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","讓他們隨時為百姓判案，處理小糾紛，遇到大事才由你審理。有他們分擔你的責任，你會更輕省。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","如果你這樣做，並且上帝也這樣吩咐你，你就能承受得住，百姓也可以平安地回家。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","於是，摩西接納了岳父的建議，依言而行， ");
INSERT INTO cmncbt_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","從百姓中挑選有才幹的人，委派他們做百姓的領袖，擔任千夫長、百夫長、五十夫長和十夫長。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","他們負責隨時審理百姓的事，遇到難斷的案件就呈到摩西那裡，自己則審理普通的事。 ");
INSERT INTO cmncbt_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","之後，摩西為岳父送行，葉特羅就返回了家鄉。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","以色列人離開埃及滿三個月的那一天，他們來到西奈曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","他們離開利非訂，來到西奈曠野，在那裡的山下安營。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","摩西上山到上帝那裡，耶和華從山上呼喚他說：「你告訴雅各家，告訴以色列人， ");
INSERT INTO cmncbt_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","『我怎樣對付埃及人，怎樣像鷹一樣把你們背在翅膀上帶來歸屬我，你們都看見了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","現在，你們若真心聽從我的話，遵守我的約，就必在萬民中做我寶貴的產業，因為普天下都是我的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","你們要歸於我，作祭司之國、聖潔之邦。這些話你要告訴以色列人。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","摩西召集以色列的長老，把耶和華對他的一切吩咐都轉告他們。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","百姓都齊聲回答說：「凡耶和華所吩咐的，我們都願意遵從。」 摩西便把他們的話回報耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","耶和華對摩西說：「我會在密雲中臨到你那裡，使百姓也可以親耳聽見我與你說話的聲音，這樣他們就會永遠信賴你。」摩西把以色列人的話回報耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","耶和華對摩西說：「你現在回到他們那裡，吩咐他們今天和明天要潔淨自己，洗淨衣服， ");
INSERT INTO cmncbt_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","到後天都要預備好，因為這一天耶和華要在百姓眼前降臨在西奈山上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","此外，你要在山的四圍劃定界限，吩咐百姓不得上山或觸碰山的邊界，觸碰者必被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","你們不可用手碰違例者，要用石頭打死他或用箭射死他，無論人畜，都不可存活。等到角聲長鳴時，百姓才可上山。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","於是，摩西下山回到百姓那裡，吩咐他們各人潔淨自己，洗淨衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","又吩咐他們說：「到後天一切都要準備好，這期間你們不可親近女人。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","到了第三天早晨，山上雷電大作，烏雲密佈，又有嘹亮的號角聲，營中的百姓都膽戰心驚。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","摩西率領百姓出營迎接上帝，他們都站在山腳下。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","因為耶和華在火中降臨到西奈山，山上瀰漫著濃煙，滾滾上騰，好像一個大火窯，整座山劇烈震動。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","號角聲越來越嘹亮。摩西說話，上帝用雷鳴回應他。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","耶和華降臨在西奈山頂，召摩西到山頂，摩西就上去了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","耶和華對摩西說：「你下去警告百姓不可闖過界限到我這裡觀看，以免很多人死亡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","吩咐到我面前來的祭司要潔淨自己，免得我忽然出來擊殺他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","摩西對耶和華說：「百姓不能上西奈山，因為你已經吩咐我們要在山的四圍劃定界限，使這山聖潔。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","耶和華對他說：「你下去把亞倫一起帶來，祭司和百姓仍要留在原來的地方，不得亂闖到我面前，免得我忽然出來擊殺他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","摩西就下去，把耶和華的話轉告給百姓。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","以下是上帝的訓示： ");
INSERT INTO cmncbt_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","「我是你的上帝耶和華，曾把你從受奴役之地埃及領出來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","「除我以外，你不可有別的神明。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","不可為自己雕刻神像，不可仿照天上、地上和地底下水中的任何形像造神像， ");
INSERT INTO cmncbt_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","不可跪拜它們，也不可供奉它們，因為我——你的上帝耶和華痛恨不貞，我必追討背棄我之人的罪，從父到子直到三四代。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","但那些愛我、遵守我誡命的人，我必以慈愛待他們，直到千代。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","不可妄用你上帝耶和華的名，違者必被耶和華定罪。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","要謹記安息日，守為聖日。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","你一週可勞碌工作六天， ");
INSERT INTO cmncbt_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","但第七天是你的上帝耶和華的安息日，這一天你和兒女、僕婢、牲畜及你那裡的外族人不可做任何工。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","因為耶和華用六天創造了天地、海洋和其中的萬物，第七天便休息了，所以耶和華賜福安息日，把它定為聖日。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","要孝敬父母，以便在你的上帝耶和華要賜給你的土地上享長壽。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","不可殺人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","不可通姦。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","不可偷盜。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","不可作偽證陷害人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","不可貪戀別人的房屋，不可貪戀別人的妻子、僕婢、牛驢或其他任何物品。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","那時雷電交加，號角嘹亮，山上冒煙，百姓見此情景，都嚇得渾身顫抖，不敢挨近。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","他們對摩西說：「求你跟我們說話，我們必聽從。不要讓上帝直接跟我們說話，恐怕我們會喪命！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","摩西對百姓說：「不要害怕，上帝降臨是要試驗你們，好讓你們時時敬畏祂，不致犯罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","百姓都站得遠遠的，摩西獨自走進上帝所在的密雲中。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","耶和華吩咐摩西對以色列百姓說：「既然你們已經親眼看見我從天上向你們說話， ");
INSERT INTO cmncbt_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","你們不可製造神像與我並立，不可為自己製造金銀神像。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","你們要為我築一座土壇，把你們的牛羊獻在壇上作燔祭和平安祭。凡是我使自己的名被尊崇的地方，我會親臨那裡賜福給你們。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","你們若為我築石壇，不可用鑿刻的石頭，因為用工具鑿刻的石頭會玷污祭壇。 ");
INSERT INTO cmncbt_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","不可踩著臺階登我的祭壇，免得露出你們的下體。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","「你要向百姓頒佈下列法令。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","你若買一個希伯來人當奴僕，他必須服侍你六年，到第七年便可以獲得自由，不用支付任何贖金。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","他來的時候若是單身，就可以單身離開。他來的時候若有妻子，就可以帶妻子一起離開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","倘若主人給他娶了妻，妻子生了兒女，那麼期滿的時候，他只能單獨離開，他的妻兒要歸主人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","倘若奴僕說，『我愛我的主人和我的妻子兒女，我不願意離去做自由人。』 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","主人就要帶他到審判官面前，讓他靠著門或門框，用錐子為他穿耳洞。這樣，他就要永遠服侍主人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","倘若有人把女兒賣為婢女，她不可像男僕那樣離開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","倘若買她的主人本想把她留給自己，後來卻不喜歡她，就必須讓她贖身。主人無權把她轉賣給外族人，因為是主人對她不守信用。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","倘若是買來給自己的兒子，就要把她當作自己的女兒一般看待。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","倘若有人娶了婢女為妻，後來又另娶，他還是要照常供給她飯食和衣服，並履行同房的義務。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","倘若主人不履行以上的三個條件，婢女就可以隨時離開，不用繳付任何贖金。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","「打人致死的，必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","倘若不是故意殺人，而是上帝許可那人死在他手裡，他就可以逃往我指定的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","倘若是蓄意殺人，就算他逃到我的祭壇那裡，也要把他拉出來處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","毆打父母的，必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","綁架他人販賣或自用的，必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","咒罵父母的，必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","倘若吵架時一方用拳頭或石塊致另一方受傷、躺臥在床，但不至於死， ");
INSERT INTO cmncbt_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","日後能起床扶著拐杖到戶外走，傷人者便不算有罪，但要賠償受傷者停工期間的損失，並要負責治好他。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","「倘若有人用棍子打他的僕婢，導致僕婢當場死亡，他必須受懲罰。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","倘若傷者過了一兩天才死去，主人就可免刑，因為死者是他的財產。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","倘若有人彼此鬥毆，傷了孕婦，導致早產，但未造成其他傷害，傷人者要按她丈夫所要求的金額，經審判官判定以後，如數賠償。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","倘若還有其他傷害，傷人者就要以命償命， ");
INSERT INTO cmncbt_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","以眼還眼，以牙還牙，以手還手，以腳還腳， ");
INSERT INTO cmncbt_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","以燒傷還燒傷，以創傷還創傷，以毆打還毆打。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","「主人若打壞僕婢的一隻眼睛，就要因此讓僕婢自由離去。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","同樣，倘若他打掉了僕婢的一顆牙齒，也要因此而釋放僕婢。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","「倘若有牛牴死了人，要用石頭打死那頭牛，並且不可吃牠的肉，牛的主人可算無罪。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","但倘若牛常常用角牴人，並且已經有人向牛的主人投訴，他卻不拴好牛，以致牛牴死了人，就要用石塊打死牛，並處死主人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","若判他以錢贖命，不論金額多少，他都得照付。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","牛若牴死了別人的兒女，也要照以上的條例辦理。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","牛若牴死了別人的僕婢，牛的主人要賠七兩銀子給那僕婢的主人，並要用石頭打死牛。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","倘若有人打開井蓋或挖了井後不把井口蓋好，以致有牛或驢掉進井裡， ");
INSERT INTO cmncbt_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","井的主人就要賠償牲畜的主人，死牲畜則歸井的主人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","倘若某人的牛牴死了別人的牛，兩家的主人就要賣掉活牛，平分所得，同時也要平分那頭死掉的牛。 ");
INSERT INTO cmncbt_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","倘若素知牛好牴，主人卻沒有拴好牠，他就要以牛還牛，死牛則歸他。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","「倘若有人偷了別人的牛羊，然後宰了或賣了，他要用五頭牛抵償一頭牛，四隻羊抵償一隻羊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","倘若有人打死正入屋偷竊的賊，這人不算犯殺人罪。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","倘若事情發生在白天，家主就犯了殺人罪。倘若盜賊被擒，他就要賠償家主，若他一無所有，就要把他賣為奴隸作賠償。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","倘若他偷的牲畜如牛、羊或驢在他手上還活著，他要償還失主雙倍。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","「倘若有人在田野或葡萄園裡牧放牲畜，任由牲畜吃別人田裡的農作物或葡萄，他必須拿自己田裡最好的農作物或葡萄作賠償。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","倘若田間起火，燒著荊棘，以致燒掉了別人的莊稼、禾捆或整個田園，那點火的人就要賠償一切損失。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","「倘若有人把金錢或物件交給鄰居保管，結果在鄰居家遭盜，盜賊被緝拿歸案後要賠償雙倍； ");
INSERT INTO cmncbt_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","倘若沒捉到盜賊，鄰居就要到審判官那裡證明自己沒有偷拿。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","倘若二人之間有什麼糾紛，無論是為了牛、驢、羊、衣服或任何失物，爭執的雙方要把案件呈報審判官，審判官判誰敗訴，誰就要賠償雙倍。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","倘若有人把驢、牛、羊或別的牲畜交給鄰居看管，牲畜死傷或被人搶走，並且無人看見， ");
INSERT INTO cmncbt_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","看守的人就要在耶和華面前起誓沒有動鄰居的東西，這樣失主就應當作罷，看守的人不用賠償。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","但倘若牲畜是被人偷去的，受託人就要賠償失主。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","倘若牲畜被野獸撕碎，受託人要把殘骸帶來當證據，無需賠償被撕碎的牲畜。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","倘若有人向鄰居借牲畜，牲畜受傷或死掉，而當時物主不在場，借的人就要賠償。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","倘若物主當時在場，借的人就不用賠償。倘若牲畜是租來的，租的人只需付租金不用賠償。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","「倘若有人誘姦了尚未許配的處女，他就要交出聘禮，娶她為妻； ");
INSERT INTO cmncbt_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","倘若女方家長反對婚事，男方要付出與聘禮等額的金錢給女方家長。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","「凡行邪術的女人，必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","「與動物性交的人，必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","「獻祭給耶和華以外的其他任何神明的人，必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","「不可欺壓在你們中間寄居的人，因為你們在埃及也做過寄居的人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","「不可虧待寡婦和孤兒， ");
INSERT INTO cmncbt_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","倘若你們虧待他們，他們向我呼求，我必聽他們的呼求， ");
INSERT INTO cmncbt_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","向你們發怒，用刀殺掉你們，使你們的妻子變為寡婦，兒女成為孤兒。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","「倘若有貧苦的同胞向你借錢，你不可像放債的一樣收取利息。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","倘若你的鄰居把衣服給你作抵押，你要在日落之前把衣服還給他。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","因為他只有這件蔽體的衣服，若是沒有，他晚上如何睡覺？他若呼求我，我必垂聽，因為我是仁慈的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","不可褻瀆上帝，也不可咒詛百姓的官長。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","你們要向我獻上五穀和新酒，不可遲延。要把你們的長子獻給我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","也要獻上頭生的牛羊，牠們生下來後可以留在母親身邊七天，第八天要獻給我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","你們要做我聖潔的子民，不可吃田野間被野獸咬死的牲畜，要把牠丟給狗吃。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","「不可散佈謠言，也不可與惡人聯手作偽證。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","不可隨眾行惡。在法庭作證時不可附和多數人，顛倒是非。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","在訴訟的事上不可偏袒窮人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","「倘若看見仇人的牛或驢走迷了路，總要牽回去交給他。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","倘若遇見仇人的驢被馱的重物壓倒，不可逕自走開，總要幫助仇人抬開重物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","「不可在訴訟案中冤枉窮人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","不可誣告別人，不可殺害正直無辜的人，因為我必懲罰作惡之人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","不可收受賄賂，因為賄賂蒙蔽人的眼目，使人顛倒是非。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","不可欺凌在你們中間寄居的人，因為你們也曾經在埃及寄居，知道寄居他鄉的滋味。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","「六年之內你要耕種收割， ");
INSERT INTO cmncbt_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","第七年要讓土地休息，不耕不種，你們當中的窮人可以吃田中長出來的，剩下的可以留給動物吃。你也要這樣處理葡萄園和橄欖園。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","六天之內，你要工作，但第七天要休息。這樣，牛、驢可以歇息，你家裡的奴僕和寄居的也可以休息。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","你們要謹慎遵從我對你們說的話。不可提其他神明的名字，不可從你口中聽到它們的名字。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","「你每年要向我守三個節期。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","要守除酵節，照我的吩咐在每年亞筆月所定的日期連續吃七天的無酵餅，因為你是在這個月離開了埃及。誰也不可空手朝見我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","要在耕種後收取初熟之物的時候守收獲節。要在年終從田間收取勞動成果時守收藏節。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","所有的男子都要在這三個節期朝見主耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","「不可把祭牲的血和有酵的餅一起獻給我，也不可把節期祭牲的脂肪留到早晨。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","要把田中最好的初熟之物送到你們的上帝耶和華的殿中。不可用母山羊的奶煮牠的小羊羔。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","「看啊，我要差遣天使走在你前面，在路上保護你，帶領你到達我所預備的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","他是奉我的名來的，你們要謹遵他的話，不可悖逆，不然他必不赦免你們的過犯。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","「你若認真聽從他的吩咐，遵行我的話，我就與你的仇敵為敵，與你的對頭作對。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","我的天使要走在你前面，帶領你去亞摩利人、赫人、比利洗人、迦南人、希未人和耶布斯人所住的地方，我會把他們全部消滅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","不可叩拜他們的神明，不可供奉它們，也不可效法他們的行為，要徹底拆毀神像，打碎他們的神柱。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","你們要事奉你們的上帝耶和華，我必賜給你食物和水，使疾病遠離你們， ");
INSERT INTO cmncbt_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","在你境內必沒有人流產或不育，我會使你享盡天年。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","你所到之處，我必使那裡的人惶恐不安，使你一切的仇敵都在你面前轉身逃跑。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","我要派黃蜂做你的先鋒，趕走那些希未人、迦南人和赫人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","我不會在一年之內把這些人全部趕走，免得土地荒涼，野獸氾濫。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","我會逐漸地趕走他們，直到你們人丁興旺，可以佔據那片土地。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","我給你定下國界，從紅海到非利士海岸，從曠野到幼發拉底河。我要把其中所有的居民都交在你手中，你要把他們全部趕出去。 ");
INSERT INTO cmncbt_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","不可跟這些民族及其神明立約， ");
INSERT INTO cmncbt_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","也不可讓這些民族住在你的土地上，免得他們使你得罪我，你若供奉他們的神明，必因此而陷入網羅。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","耶和華又指示摩西說：「你和亞倫、拿答、亞比戶及以色列的七十位長老上我這裡來，遠遠地敬拜我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","只有你可以靠近我，其他百姓都不得與你一同走近。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","摩西下山把耶和華的話和法令都告訴百姓，百姓齊聲回答：「我們願意遵行耶和華的一切吩咐。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","摩西把耶和華的這些話記錄下來。他清早起來，在山腳築了一座壇，立了十二根柱子，代表以色列的十二支派。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","他又吩咐以色列的青年去給耶和華獻燔祭，又獻上公牛作平安祭。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","摩西把祭牲的血一半放在盆裡，一半灑在壇上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","他又把約書念給百姓聽，百姓聽了都說：「我們願意遵行耶和華的一切吩咐，我們願意順服。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","摩西便把盆中的血灑在百姓身上，說：「這是立約的血，是耶和華按所說的話與你們立約的憑據。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","之後，摩西、亞倫、拿答、亞比戶及以色列的七十位長老便上了山。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","他們都看見了以色列的上帝，祂的腳下好像是一片藍寶石，像天一樣明淨。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","上帝沒有伸手殺這些以色列的首領，允許他們看見祂，在祂面前吃喝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","耶和華對摩西說：「你上山到我這裡來，留在這裡，我要把寫著律法和誡命的石版賜給你，你可以用來教導百姓。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","於是，摩西帶著他的助手約書亞動身上了上帝的山。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","離開之前，摩西吩咐長老說：「你們在這裡等候我們回來。亞倫和戶珥跟你們在一起，民中有什麼訴訟的事情，可以去找他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","摩西上了山，密雲遮蓋著整座山。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","耶和華的榮耀停留在西奈山上，密雲遮蓋了山六天。第七天，耶和華在雲中召喚摩西。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","在以色列人眼中，耶和華的榮耀在山上好像烈火。 ");
INSERT INTO cmncbt_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","摩西上到山上，走進雲中，在那裡停留了四十晝夜。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","「你去吩咐以色列百姓要獻禮物給我。你們要為我收下所有甘心樂意獻上的禮物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","你們要收的禮物是金、銀、銅， ");
INSERT INTO cmncbt_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","藍色、紫色和朱紅色毛線，細麻，山羊毛， ");
INSERT INTO cmncbt_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","染成紅色的公羊皮，海狗皮，皂莢木， ");
INSERT INTO cmncbt_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","燈油，製作膏油和香的香料， ");
INSERT INTO cmncbt_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","鑲嵌在以弗得和胸牌上的紅瑪瑙及其他寶石。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","他們要為我造一座聖所，我好住在他們中間。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","你們要完全照我指示的樣式造聖幕和裡面的各樣器具。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","「要用皂莢木做一個櫃，長一米一，寬七十釐米，高七十釐米， ");
INSERT INTO cmncbt_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","裡外都要包上純金，要用金子鑲櫃邊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","再鑄造四個金環，安在櫃的四個腳上，每邊兩個環。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","用皂莢木造兩根橫槓，包上金， ");
INSERT INTO cmncbt_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","然後把橫槓穿過櫃兩邊的金環，便於抬櫃。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","橫槓穿進櫃環以後，不可再抽出來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","把我將要賜給你的兩塊約版放在櫃裡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","要用純金造一個施恩座，長一米一，寬七十釐米。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","用金子在施恩座的兩端打造兩個基路伯天使， ");
INSERT INTO cmncbt_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","跟施恩座連在一起，一端一個。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","兩個基路伯天使要面對面朝向施恩座，向上展開翅膀，遮蓋施恩座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","要把施恩座放在櫃上面，把我要賜給你的約版放在櫃裡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","我就在那裡跟你會面，從約櫃上面兩個基路伯天使中間的施恩座上，把要傳給以色列百姓的一切誡命告訴你。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","「要用皂莢木造一張桌子，長九十釐米，寬四十五釐米，高七十釐米。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","整張桌子都要包上純金，四周鑲上金邊， ");
INSERT INTO cmncbt_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","在桌子四周造一個八釐米寬的外框，外框鑲上金邊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","要造四個金環，安在桌子四角的桌腿上， ");
INSERT INTO cmncbt_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","金環要靠近外框，以便穿橫槓抬桌子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","兩根橫槓要用皂莢木製作，外面包金，用來抬桌子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","你們要用純金造桌子上的盤、碟和獻酒用的瓶和杯。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","桌子上要一直擺著供餅，獻在我面前。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","「要用純金造一個燈臺，燈臺的燈座、燈柱、油杯、花萼和花瓣要用一塊純金打造。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","燈臺兩邊要各伸出三個分枝，共六個分枝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","每個分枝上要有三個杏花形狀、有花瓣和花萼的杯，六個分枝都是這樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","燈臺上要有四個杏花形狀、有花瓣和花萼的杯。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","燈臺上每一對分枝的相連處要有花萼，三對都是這樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","整座燈臺，包括花萼和分枝，都要用一塊純金打造。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","此外，要為燈臺造七個燈盞，放在燈臺上面，照亮前面的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","燈臺用的燈剪和燈花盤都要用純金造。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","造整座燈臺和燈臺的器具要用六百八十兩純金。 ");
INSERT INTO cmncbt_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","你務要照著在山上指示你的樣式造各樣器具。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","「要用十幅幔子做聖幕，幔子要用細麻和藍色、紫色、朱紅色毛線織成，上面要精工繡製基路伯天使。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","每幅幔子的尺寸都一樣，長十二米半、寬一米八。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","每五幅連在一起，形成兩幅大幔子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","要在每幅大幔子末幅的邊緣釘上藍色的扣環， ");
INSERT INTO cmncbt_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","每幅大幔子釘五十個，扣環要兩兩相對， ");
INSERT INTO cmncbt_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","再做五十個金鉤，把兩幅大幔子連在一起，成為一個完整的聖幕。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","「要用山羊毛織十一幅幔子作聖幕的罩棚， ");
INSERT INTO cmncbt_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","每幅長十三米半、寬一米八。十一幅幔子的尺寸都要一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","然後，你們要把五幅連成一大幅，其餘六幅連成一大幅，第六幅要在罩棚前疊起來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","要在這兩幅大幔子末幅的邊緣各釘上五十個扣環， ");
INSERT INTO cmncbt_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","再做五十個銅鉤，把這兩幅大幔子扣在一起，成為一個完整的罩棚。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","鋪罩棚所剩下來的半幅幔子要垂到聖幕後面。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","兩旁餘下的幔子可垂在聖幕的兩邊，每邊長四十五釐米，蓋著聖幕。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","罩棚上面要蓋一層染成紅色的公羊皮，再蓋一層海狗皮做頂蓋。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","「要用皂莢木做支聖幕的木板， ");
INSERT INTO cmncbt_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","每塊木板長四米半，寬七十釐米。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","每塊木板要有兩個接榫，用來銜接。聖幕的所有木板都要這樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","聖幕的南面要有二十塊木板， ");
INSERT INTO cmncbt_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","在這些木板下面要造四十個帶凹槽的銀底座，每塊木板下面有兩個，套在木板的兩個接榫上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","聖幕北面也要有二十塊木板， ");
INSERT INTO cmncbt_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","木板下面同樣有四十個帶凹槽的銀底座，每塊木板下面有兩個銀底座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","聖幕後面，就是西面，要有六塊木板。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","聖幕後面的兩個拐角要各有一塊木板， ");
INSERT INTO cmncbt_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","木板的下端連於底座，頂端用一個環固定。兩個拐角都要這樣做。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","這樣，後面共有八塊木板，每塊木板下面各有兩個帶凹槽的銀底座，一共有十六個銀底座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","「要用皂莢木做橫閂，聖幕左右兩邊和後面的牆板上要各有五根橫閂， ");
INSERT INTO cmncbt_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","攔腰固定牆板的那根橫閂要從這端貫穿到那端。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","所有的木板和橫閂都要包上金，並要在木板上造金環，用來穿橫閂。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","要照著我在山上所指示你的樣式，把聖幕支搭起來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","「要用細麻和藍色、紫色、朱紅色毛線織成一幅幔子，上面精工繡上基路伯天使。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","要把這幅幔子掛在四根包金的皂莢木柱上，木柱上有金鉤，木柱立在四個帶凹槽的銀底座上面。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","要把整幅幔子掛在木柱的金鉤上，把約櫃抬進幔子裡。這幔子把聖幕分為兩個部分，幔子裡面是至聖所，外面是聖所。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","要把施恩座放在至聖所裡面的約櫃上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","桌子要放在幔子的外面、聖幕的北面，燈臺放在南面，跟桌子相對。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","要用細麻和藍色、紫色、朱紅色毛線繡製聖幕的門簾。 ");
INSERT INTO cmncbt_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","要用皂莢木做五根掛門簾的柱子，柱子包上金，上面要有金鉤，並要為柱子鑄造五個帶凹槽的銅底座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","「要用皂莢木造一個方形的祭壇，長寬各兩米二，高一米三。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","要在壇的四角造四個凸起的角，與壇連成一體，壇外面要包上銅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","用銅造盛壇灰的盆和其他祭壇用具，即鏟、碗、肉叉、火鼎。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","要造一個銅網，在銅網的四角造四個銅環。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","銅網在祭壇圍邊的下方，向下伸展到祭壇的腰部。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","要用皂莢木為祭壇造兩根橫槓，包上銅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","要將兩根橫槓穿在壇兩旁的銅環裡，以便抬壇。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","整座壇都用木板製作，壇是中空的。一切都要照我在山上給你的指示去做。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","「要為聖幕圍出一個院子。院子南面的帷幔要用細麻織成，長四十五米， ");
INSERT INTO cmncbt_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","帷幔有二十根柱子，二十個帶凹槽的銅底座，柱子上的鉤和箍都是銀的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","北面的帷幔也是長四十五米，柱子、銅底座、鉤和箍的樣式都與南面的一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","院子西面的帷幔寬二十二米半，有十根柱子和十個帶凹槽的底座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","院子東面的帷幔也是寬二十二米半。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","入口兩邊的帷幔都是寬七米，各有三根柱子和三個帶凹槽的底座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","院子的入口要有門簾，長九米，用細麻和藍色、紫色、朱紅色毛線繡製，還有四根柱子和四個帶凹槽的底座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","院子四圍的柱子都要有銀箍，所有的鉤子都要用銀製作，帶凹槽的底座要用銅製作。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","整個院子長四十五米，寬二十二米半，高兩米二，所有的帷幔都要用細麻精工製作，帶凹槽的底座要用銅製作。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","聖幕裡其他一切器具以及聖幕、院子所用的橛子都要用銅製作。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","「你要吩咐以色列人把榨的純橄欖油給你拿來點燈，使燈常明。 ");
INSERT INTO cmncbt_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","亞倫和他的子孫要負責照看會幕內遮掩約櫃的幔子外的燈，使燈從晚上到早晨一直在耶和華面前亮著。這是以色列百姓世代當守的永久律例。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","「你要從以色列民中把你的哥哥亞倫和他四個兒子拿答、亞比戶、以利亞撒和以他瑪帶到你身邊，立他們為祭司事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","你要為你哥哥亞倫做聖衣，顯明他職位的榮耀和尊貴。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","你要吩咐所有我賦予智慧的巧手裁縫師為亞倫縫製衣服，使他分別出來，做聖潔的祭司事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","他們要做的聖衣包括胸牌、以弗得、外袍、雜色的內袍、禮冠和腰帶。要為你哥哥亞倫及其眾子做這樣的聖衣，好讓他們做祭司事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","要用金線、細麻及藍色、紫色、朱紅色毛線製作聖衣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","「以弗得要用金線、細麻及藍色、紫色、朱紅色毛線精工製作。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","要在以弗得兩邊用兩條肩帶縫合起來。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","用金線、細麻及藍色、紫色、朱紅色毛線精工製作腰帶，縫在以弗得上，連成一整件。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","「你要拿兩塊紅瑪瑙，刻上以色列十二個兒子的名字， ");
INSERT INTO cmncbt_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","按他們的長幼次序，每一塊寶石刻上六個名字。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","要用工匠刻圖章的方法將他們的名字刻在兩塊寶石上，把寶石鑲在兩個金框裡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","然後將鑲著金框的寶石縫在以弗得的兩條肩帶上，作以色列人的紀念石。亞倫要把他們的名字帶在肩上，在耶和華面前作紀念。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","要做兩個金框， ");
INSERT INTO cmncbt_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","並像搓繩子一樣用純金搓成兩條金鏈，把鏈子連接在鑲寶石的金框上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","「要精工製作一個用來明白上帝旨意的胸牌，製作的方法和造以弗得一樣，用金線、細麻及藍色、紫色、朱紅色毛線製作。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","胸牌是方形的，長寬各二十二釐米，分成上下兩層。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","上面要鑲上四行寶石：第一行是紅寶石、黃玉和翠玉； ");
INSERT INTO cmncbt_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","第二行是綠寶石、藍寶石和金剛石； ");
INSERT INTO cmncbt_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","第三行是紫瑪瑙、白瑪瑙和紫晶； ");
INSERT INTO cmncbt_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","第四行是水蒼玉、紅瑪瑙和碧玉。這些寶石都要鑲在金框上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","要用刻圖章的方法在每一顆寶石上刻一個以色列兒子的名字，十二顆寶石代表十二支派。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","「要用純金擰成兩條像繩子一樣的鏈子，連在胸牌上， ");
INSERT INTO cmncbt_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","造兩個金環安在胸牌兩端， ");
INSERT INTO cmncbt_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","把兩條金鏈分別繫在胸牌兩端的金環上， ");
INSERT INTO cmncbt_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","再把金鏈的另兩端接在兩個金框上，安在以弗得前面的肩帶上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","造兩個金環，安在靠近以弗得內邊的胸牌下兩端。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","再造兩個金環，安在以弗得前面兩條肩帶下端，靠近精緻的以弗得腰帶上方的接縫處。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","再用一條藍色的帶子繫住以弗得和胸牌上面的金環，使胸牌貼在精工織成的以弗得腰帶上，不會從以弗得上鬆脫。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","亞倫進聖所時，要佩戴這塊刻著以色列眾子名字、用來做判斷的胸牌，在耶和華面前常作紀念。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","又要把烏陵和土明放在胸牌裡面，亞倫到耶和華面前的時候，要佩帶這胸牌，以便明白上帝的旨意，為以色列人做決定。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","「也要縫製一件藍色的以弗得的外袍， ");
INSERT INTO cmncbt_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","袍上要留領口，領口周圍要織領邊，就像鎧甲的領口，免得領口破裂。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","外袍的底邊要另外用藍色、紫色、朱紅色毛線做成石榴狀的飾物，石榴間要掛金鈴鐺。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","一個石榴一個金鈴鐺，相間排列，圍在外袍的底邊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","亞倫事奉的時候，要穿上這外袍，以便他進聖所到耶和華面前和出聖所的時候，鈴鐺會發出響聲，他就不至於死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","「你也要用純金造一塊牌子，以刻印章的方法刻上『耶和華的聖物』的字樣， ");
INSERT INTO cmncbt_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","再拿一條藍色帶子，把它繫在禮冠前面。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","亞倫要把這金牌戴在額上，表示他承擔以色列人獻聖物時的過犯，這聖物是以色列百姓特別獻上的禮物。這金牌要常常留在亞倫的額上，好使百姓蒙耶和華悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","「要用細麻布縫製祭司的內袍，用細麻布做禮冠，腰帶上要有刺繡， ");
INSERT INTO cmncbt_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","也要為亞倫的兒子們縫製內袍、腰帶、頭巾，顯明他們職位的榮耀和尊貴。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","給你哥哥亞倫及其眾子穿上這些衣服後，你要用油膏立他們，使他們分別出來，做聖潔的祭司事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","「要用細麻布為他們做褲子，以遮蓋下體，褲子要從腰部到大腿。 ");
INSERT INTO cmncbt_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","亞倫父子們進會幕或走近祭壇到聖所事奉的時候，都要穿上褲子，免得擔負罪責而死亡。這是亞倫及其子孫永遠當守的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","「你要使亞倫父子們分別出來，做聖潔的祭司事奉我。做法如下：你要選一頭公牛犢和兩隻毫無殘疾的公綿羊， ");
INSERT INTO cmncbt_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","用細麵粉預備無酵餅、調上油的無酵餅和塗上油的無酵薄餅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","所有的餅都要用一個籃子盛，連同公牛和綿羊一起帶到會幕那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","你要把亞倫父子們帶到會幕門口，用水洗他們， ");
INSERT INTO cmncbt_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","然後給亞倫穿上內袍、以弗得和以弗得的外袍，戴上胸牌，束上精緻的以弗得帶子， ");
INSERT INTO cmncbt_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","戴上禮冠，把聖冠繫在禮冠上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","之後，把膏油倒在他頭上，立他為祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","接著輪到亞倫的兒子們，要給他們穿上內袍， ");
INSERT INTO cmncbt_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","為他們束上腰帶，戴上頭巾，他們就按永遠的律例得到祭司的職分。你要這樣把聖職授予他們。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","「你要把公牛牽到會幕前面，亞倫父子們要把手按在公牛頭上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","你要在會幕門前，在耶和華面前宰公牛。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","要取些公牛的血帶到祭壇那裡，用手指把血抹在祭壇凸起的四角上，再把剩下的血倒在壇腳。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","再把包裹內臟的脂肪、肝葉、兩個腎臟和腎臟上的脂肪都放在祭壇上燒掉。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","但公牛的皮、肉和糞要拿到營外焚燒。這是贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","「要把一隻公綿羊牽來，亞倫父子們要把手按在羊頭上， ");
INSERT INTO cmncbt_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","然後你要宰羊，把血灑在祭壇四周。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","再把羊切成塊狀，用水洗淨所有的內臟和腿，跟肉塊和頭放在一起。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","然後，把整隻羊放在祭壇上焚燒，這是獻給耶和華的燔祭，是蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","「你要把另一隻公綿羊牽來，亞倫父子們要把手按在羊頭上， ");
INSERT INTO cmncbt_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","然後你要宰羊，取一點血塗在亞倫和他兒子們的右耳垂、右手大拇指和右腳大腳趾上，剩下的血就灑在祭壇四周。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","再從祭壇上取些血，與膏油一起灑在亞倫父子及其衣服上。這樣，他們和他們的衣服就會變得聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","「你要取出羊的脂肪、肥尾巴、包裹內臟的脂肪、肝葉、兩個腎臟、腎臟上的脂肪和右腿，因為這是授聖職時所獻的羊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","再從耶和華面前裝無酵餅的籃子裡取一個餅、一個油餅和一個薄餅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","把這些都放在亞倫父子們手中，作為搖祭在耶和華面前搖一搖。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","然後，你要把這些祭物接過來，放在祭壇的燔祭上焚燒獻給耶和華，成為蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","你要拿起亞倫承受聖職時所獻的那只公綿羊的胸肉，作為搖祭在耶和華面前搖一搖。之後，這份祭肉就歸你。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","「你要將屬於亞倫父子們、授聖職時所獻公綿羊的搖祭胸肉和舉祭腿肉分別出來，使之聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","這些祭物要從以色列人所獻的平安祭中取出來，歸給亞倫父子們，作為永遠的定例。這是以色列人當向耶和華獻的祭物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","「亞倫的聖衣要留給他的子孫，他們可以穿上這聖衣受膏，承受聖職。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","接替亞倫做祭司的那位後裔，每次進會幕的聖所供職時，都要一連七天穿著聖衣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","「你要在聖潔的地方煮授聖職時所用的公綿羊肉。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","亞倫父子們可以在會幕的門前吃這公綿羊祭肉和籃內的餅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","他們要吃這些在授聖職時用來贖罪、使他們聖潔的祭物。但祭司以外的人不能吃，因為這些是聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","若有授聖職時所獻的肉或餅留到早晨，就要燒掉，不可再吃，因為這些都是聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","「你要照我的吩咐，為亞倫父子們舉行授聖職禮，歷時七天。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","每天要獻一頭公牛作贖罪祭，來潔淨祭壇，然後用膏油抹祭壇，使祭壇聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","連續七天都要這樣做，使祭壇完全聖潔，凡是碰到祭壇的都變得聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","「你每天要在祭壇上獻兩隻一歲的公羊羔， ");
INSERT INTO cmncbt_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","早晨和黃昏各獻一隻。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","要用一公斤細麵粉調一升橄欖油做成素祭，與早晨獻的羊羔一同獻上，再獻上一升酒作奠祭。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","黃昏獻第二隻羊時，也要跟早晨一樣同時獻上素祭和奠祭，作為蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","「你們世世代代要不斷地在我面前獻上燔祭，祭禮要在會幕門前舉行，這會幕就是我跟你們會面交談的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","我要在那裡和以色列人相會，我的榮耀將使會幕聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","「我要使會幕和祭壇聖潔，也要使亞倫父子們聖潔，做祭司事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","我要住在以色列人中間，做他們的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","他們必知道我是他們的上帝耶和華。我帶領他們離開埃及，就是為了要住在他們中間。我是他們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","「你要用皂莢木造一座燒香用的壇。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","壇是四方形的，長寬各四十五釐米，高九十釐米，壇上面凸起的四角與壇連成一體。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","壇頂、壇的四面和壇上凸起的角要包上純金，四周鑲上金邊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","要在壇兩側的金邊下面安兩個金環，使橫槓穿過金環，以便抬香壇。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","要用皂莢木造橫槓，包上金。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","要把香壇放在約櫃前幔子的外面，對著約櫃上的施恩座，就是我要跟你會面的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","「亞倫每天早上料理燈臺的時候，要在這壇上燒芬芳的香。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","黃昏點燈的時候，他也要在耶和華面前燒香，世世代代都要如此。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","不可在這香壇上燒別的香料，不可用這壇來獻燔祭或素祭，也不可在上面澆奠祭。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","亞倫每年要用贖罪祭牲的血在壇的角上行一次贖罪禮，世代如此。這是耶和華至聖的壇。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","「你統計以色列人口的時候，每一個被統計的男子都要繳付贖價給耶和華，贖回自己的性命，免得在統計人口期間發生災禍。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","凡被統計的人都要付六克銀子，即十季拉，以聖所的秤為準，作為獻給耶和華的禮物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","凡被統計的，年齡在二十歲以上的男子都要獻此禮物給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","富有的不用多繳，貧窮的也不可少付，每個人都要獻六克銀子給耶和華，用來贖自己的性命。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","要向以色列人收贖命的款項，供會幕使用，可以使以色列人在耶和華面前蒙眷顧，贖性命。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","「你用銅造一個洗濯盆和盆座，放在會幕和祭壇之間，盆裡盛著水， ");
INSERT INTO cmncbt_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","供亞倫父子們洗手洗腳， ");
INSERT INTO cmncbt_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","他們進會幕或到壇前給耶和華獻火祭之前，一定要用水洗濯才可以供職，免得死亡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","他們要洗手洗腳，免得死亡，這是亞倫及其子孫世代當守的永久律例。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","「要用上等的香料，就是沒藥汁六公斤、香肉桂和菖蒲各三公斤、 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","肉桂皮六公斤，都按聖所的秤為準，再加上橄欖油四升， ");
INSERT INTO cmncbt_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","按著調製香料的方法製作聖膏油。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","要用這些膏油來抹會幕、約櫃、 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","桌子和桌上所有的器具、燈臺和燈臺上的器具、香壇、 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","燔祭壇和壇上所有的器具、洗濯盆和盆座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","你要使這一切聖潔，成為至聖之物。凡碰到它們的都會聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","「你也要用這油來膏亞倫父子們，使他們分別出來，做聖潔的祭司事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","你要把我的話告訴以色列百姓，『我要世世代代以這油為聖膏油。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","不要把這膏油用在普通人身上，也不可仿製，因為這是聖膏油，你們也要視之為聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","任何人若仿製或用這油抹祭司以外的人，要將他從民中剷除。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","耶和華對摩西說：「要取各種芬芳的香料，就是蘇合香、香螺、白松香和純乳香，分量相同， ");
INSERT INTO cmncbt_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","用調製香料的方法調製，加上鹽，做成純淨聖潔的香。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","你們要把一些香搗成極細的粉末，放在會幕內的約櫃前面，就是我與你會面的地方，你們要視這香為至聖之物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","你們不可用同樣的配方為自己做香，要視它為耶和華的聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","任何人若仿製這香，自己拿來私用，必從民中被剷除。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","「看啊，我已經親自在猶大支派中選出戶珥的孫子、烏利的兒子比撒列， ");
INSERT INTO cmncbt_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","用我的靈充滿他，使他有聰明智慧，精於各種技能和手藝， ");
INSERT INTO cmncbt_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","能用金、銀和銅製造精巧的器具， ");
INSERT INTO cmncbt_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","又能雕刻和鑲嵌寶石，精通木工和各種手藝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","我委派但支派亞希撒抹的兒子亞何利亞伯做他的助手。至於其他能工巧匠，我已賜給他們智慧，好照我對你的吩咐製造一切器具， ");
INSERT INTO cmncbt_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","即會幕、約櫃和約櫃上面的施恩座、會幕裡面所有的器具、 ");
INSERT INTO cmncbt_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","桌子和桌上的器具、純金的燈臺和燈臺的一切器具、香壇、 ");
INSERT INTO cmncbt_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","燔祭壇和壇上的一切器具、洗濯盆和盆座， ");
INSERT INTO cmncbt_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","還有精工製作的禮服，即亞倫祭司的聖衣及其眾子供祭司之職時穿的禮服， ");
INSERT INTO cmncbt_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","以及膏油和聖所使用的芬芳的香。他們要照我對你的吩咐去做。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","「你要吩咐以色列百姓務必守我的安息日，因為這是我與你們之間世世代代的記號，叫你們知道使你們聖潔的是我耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","你們要守安息日，以它為聖日。凡不守這日的，必被處死。凡在這天工作的，必從民中被剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","一週要工作六天，第七天是完全休息的安息日，是耶和華的聖日。凡在安息日做工的，必被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","因此，以色列人世世代代都要守安息日，作為永久的約， ");
INSERT INTO cmncbt_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","這是我和以色列人之間永久的記號。因為耶和華用六天的時間創造天地，在第七天停工休息。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","耶和華在西奈山對摩西說完這些話以後，就把自己用指頭刻上誡命的兩塊石版交給摩西。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","百姓見摩西遲遲沒有下山，就聚集到亞倫那裡，對他說：「帶我們出埃及的那個摩西不知怎樣了，你給我們造神像來帶領我們吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","亞倫對他們說：「你們去摘下妻子、兒女的金耳環，拿來給我。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","百姓就都摘下金耳環交給亞倫。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","亞倫接過這些金耳環，用它們鑄造了一頭牛犢。他們說：「以色列人啊，這就是帶你們出埃及的神明。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","亞倫見狀便在牛犢前面築了一座壇，然後宣告說：「明天是耶和華定的節期。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","第二天清晨，百姓都上前來獻燔祭和平安祭，獻完祭後就坐下吃喝，起來狂歡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","耶和華對摩西說：「你下山吧，你的百姓，就是你從埃及領出來的那些人已經敗壞了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","他們這麼快就偏離了我吩咐他們走的道路，為自己造了一頭牛犢來叩拜獻祭，說，『以色列人啊，這就是帶你們出埃及的神明。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","耶和華又說：「我看到了，這些百姓真是頑固不化。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","你不要阻止我，我要向他們發烈怒，毀滅他們。我要使你成為大國。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","摩西懇求他的上帝耶和華說：「耶和華啊，你為什麼要向你的子民發烈怒呢？這些子民是你親自用神蹟和大能從埃及領出來的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","難道你要讓埃及人議論說你領他們出來是出於惡意，是為了在山野之間殺掉他們，從地上滅絕他們嗎？求你息怒，施憐憫，不要降禍給你的子民。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","求你顧念你的僕人亞伯拉罕、以撒和以色列，你曾憑自己向他們起誓說，『我必使你們的後代像天上的星星那麼多。我應許給你們後代的這整片土地，我必賜給他們作永遠的產業。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","耶和華聽了摩西的話，就施憐憫，不把所說的災禍降在百姓身上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","摩西轉身下山，手裡拿著兩塊約版，約版的正反兩面都有字。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","石版是上帝做的，字是上帝刻的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","約書亞聽見山下百姓嘈雜的喊叫聲，便對摩西說：「營地裡有打仗的聲音。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","摩西對他說：「這不是打勝仗的聲音，也不是打敗仗的聲音，而是歌唱的聲音。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","摩西走近營地的時候，看見牛犢，又看見百姓在跳舞，心中大怒，便把手上的兩塊石版摔碎在山腳下， ");
INSERT INTO cmncbt_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","又焚燒他們鑄造的牛犢，把它磨成粉末撒在水面上，叫以色列百姓喝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","摩西對亞倫說：「這些百姓對你做了什麼？你竟使他們陷入大罪中！」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","亞倫回答說：「求我主不要動怒，你知道這些人專門作惡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","他們對我說，『為我們造神明來帶領我們吧，因為帶我們出埃及的那個摩西不知怎樣了。』 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","於是，我吩咐他們摘下金耳環給我，我把這些金耳環扔進火裡，這頭牛犢就出來了。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","摩西見百姓放肆，亞倫縱容他們，使他們成為敵人的笑柄， ");
INSERT INTO cmncbt_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","便站在營門口對會眾說：「凡跟從耶和華的，都站到我這邊來。」所有的利未人都聚集到摩西身邊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","摩西對他們說：「以色列的上帝耶和華這樣說，『你們各人帶著刀，從這個門到那個門，走遍整個營，不論遇見的是兄弟、夥伴還是鄰居，只管殺他們。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","利未人便照摩西的話去做。那一天，約有三千人被殺。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","摩西對利未人說：「今天你們已經把自己奉獻給耶和華了，因為你們大義滅親，祂今天必賜福給你們。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","第二天，摩西對百姓說：「你們犯了大罪，我現在要到耶和華那裡，也許可以為你們贖罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","摩西回到耶和華那裡，說：「唉，百姓犯了大罪，用金子為自己造了神像。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","懇求你赦免他們的罪，不然請你從你的冊子上抹掉我的名字吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","耶和華對摩西說：「誰得罪我，我就從我的冊子上抹掉誰的名字。 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","你現在回去帶領這些百姓，往我指示你的地方去，我的天使必在你前面引路。只是到我懲罰的日子，我必因他們的罪懲罰他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","耶和華擊殺百姓，是因為他們曾與亞倫一起造牛犢。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","耶和華對摩西說：「現在你和你從埃及領出來的百姓要離開這裡，去我向亞伯拉罕、以撒和雅各起誓要賜給他們後代的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","我必差遣天使走在你們前面，趕出當地的迦南人、亞摩利人、赫人、比利洗人、希未人和耶布斯人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","你們要去那奶蜜之鄉。但我不會跟你們一起去，免得我在途中就把你們滅絕了，因為你們是頑固不化的百姓。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","百姓聽見這壞消息，都非常哀傷，不再佩戴飾物了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","耶和華對摩西說：「你去向以色列百姓宣佈，『你們這些頑固不化的人，我就是跟你們在一起待一刻，都恐怕會滅絕你們。現在你們要摘下自己身上的飾物，我再決定怎樣處置你們。』」 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","因此，以色列百姓從何烈山開始就不再佩戴飾物了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","摩西通常把帳幕支搭在營外離百姓較遠的地方，摩西稱帳幕為會幕。凡求問耶和華的，都會去那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","當摩西離營去會幕的時候，百姓就都一同起來，各人站在自己的帳篷門口目送摩西走進會幕。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","摩西進入會幕後，便有雲柱降下來，停在會幕門口，耶和華就跟摩西說話。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","百姓一看見雲柱停在會幕門口，就都站在自己的帳篷門口敬拜。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","耶和華跟摩西面對面說話，好像兩個朋友談話一樣。然後，摩西返回營中，但他的年輕助手、嫩的兒子約書亞仍然留在會幕。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","摩西對耶和華說：「你吩咐我帶領這些百姓，卻沒有告訴我你將要派誰與我同去，只說，『我憑名字認識你，你在我面前蒙了恩。』 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","我若已經在你面前蒙恩，就求你把你的道路指示我，好讓我認識你，繼續在你面前蒙恩。求你顧念這民族是你的子民。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","耶和華回答他說：「我必親自與你同去，使你平安穩妥。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","摩西說：「你若不與我們同去，就不要帶我們離開這裡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","你若不與我們同去，誰會知道我和你的子民在你面前蒙了恩呢？豈不是因為你的同在，才使我們不同於地上其他民族嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","耶和華回答說：「我答應你的請求，因為你在我面前蒙了恩，我憑名字認識你。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","摩西說：「求你向我彰顯你的榮耀。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","耶和華說：「我必叫你看見我一切的美善，我要在你面前宣告我的名耶和華，我要恩待誰就恩待誰，我要憐憫誰就憐憫誰。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","但你不能看我的臉，因為凡看見的人，都不能存活。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","你要站在我旁邊的磐石上， ");
INSERT INTO cmncbt_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","我的榮耀經過你面前的時候，我會先把你安置在石縫裡，用我的手遮掩你，直到我從你面前走過。 ");
INSERT INTO cmncbt_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","然後我會收回我的手，你就可以看見我的背，但看不到我的臉。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","耶和華對摩西說：「你要鑿出兩塊石版，跟你之前摔碎的兩塊一樣，我要把前兩塊石版上的字刻在上面。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","明天清早你要預備好，你要上西奈山頂來見我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","誰也不可與你同來，整座山上都不可有人，就是牛羊也不得在山前吃草。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","於是，摩西鑿出兩塊石版，與前兩塊一樣。他清早起來，照著耶和華的吩咐拿著兩塊石版上了西奈山。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","耶和華在雲中降臨和摩西一同站在那裡，宣告祂的名耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","耶和華在摩西面前經過，並且宣告說：「我是耶和華，我是耶和華，是有憐憫和恩典的上帝，不輕易發怒，充滿慈愛，無比信實， ");
INSERT INTO cmncbt_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","向千萬代彰顯慈愛，赦免罪愆、過犯和罪惡，但決不免除罪責，必向子孫追討父輩的罪債，直到三四代。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","摩西急忙俯伏在地上敬拜， ");
INSERT INTO cmncbt_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","說：「主啊，如果我在你面前蒙了恩，求你與我們同行。雖然百姓頑固不化，求你赦免我們的過犯和罪惡，接納我們做你的產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","耶和華說：「我要與你立約，我要在你所有的百姓面前行奇事，是天下萬國從未有過的奇事，你周圍的外族人必看見我為你做的可畏之事。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","你要遵行我今天的吩咐。我必從你面前趕走亞摩利人、迦南人、赫人、比利洗人、希未人和耶布斯人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","你要謹慎，到了目的地後，不可與當地的居民立約，免得因此而陷入網羅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","相反，要拆掉他們的祭壇，打碎他們的神柱，砍下他們的亞舍拉神像。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","不可拜別的神明，因為耶和華是痛恨不貞的上帝，祂名為『痛恨不貞』。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","「不可與當地的居民立約，免得他們與自己的神明苟合獻祭時邀請你，你就吃他們的祭物， ");
INSERT INTO cmncbt_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","給兒子娶他們的女兒為妻，以致她們與自己的神明苟合時誘使你的兒子犯同樣的罪。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","「不可為自己鑄造神像。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","「要守除酵節，照我的吩咐在亞筆月所定的時間吃七天的無酵餅，因為你是在亞筆月離開埃及的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","「凡是頭胎生的都屬於我，包括牲畜中一切頭胎生的公牛和公羊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","頭胎生的驢要用羊贖回，如果不用羊贖回，就要打斷牠的脖子。凡頭胎生的男嬰，都要贖回他的性命。誰也不可空手來朝見我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","「一週工作六天，第七天要休息，就是耕種和收割時也要休息。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","「在收割初熟麥子的時候，要守七七收獲節，年底要守收藏節。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","所有的男子都要每年三次朝見主耶和華——以色列的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","我要從你面前趕走外族人，擴張你的領土。你一年三次朝見你的上帝耶和華時，必沒有人貪戀你的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","「不可把祭牲的血和有酵的餅一起獻給我，也不可把逾越節的祭物留到早晨。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","「要把田中最好的初熟之物送到你們的上帝耶和華的殿中。 「不可用母山羊的奶煮牠的小羊羔。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","耶和華又對摩西說：「你要把我說的這些話記錄下來，因為我要按這些話跟你和以色列人立約。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","摩西在耶和華那裡待了四十晝夜，不吃也不喝。耶和華把約的內容，就是十條誡命，寫在石版上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","摩西手裡拿著兩塊約版下西奈山，他不知道自己因為曾與耶和華說話而臉上發光。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","亞倫和所有的以色列百姓看見摩西臉上發光，都不敢走近他。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","摩西召他們過來，亞倫和會眾的首領便上前來。摩西與他們說話。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","之後，所有的以色列人都來到他面前，他就把耶和華在西奈山上的吩咐都告訴他們。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","說完之後，他就用帕子遮住自己的臉。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","他每次進到會幕跟耶和華說話時，就揭開帕子，出來後便把耶和華的吩咐告訴以色列百姓。 ");
INSERT INTO cmncbt_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","百姓看到他臉上發光，他就再用帕子遮住臉，直到下次進去與耶和華說話的時候才揭開。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","摩西招聚以色列全體會眾，對他們宣佈說：「以下是耶和華吩咐你們遵守的事。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","一週可以工作六天，但第七天是你們為耶和華守的聖日，是完全休息的安息日。凡在這一天工作的，必被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","在安息日，你們的任何住處都不可生火。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","摩西對以色列全體會眾說：「以下是耶和華給你們的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","「你們要獻物品給耶和華。凡慷慨樂捐的，都可以把下列物品獻給耶和華為禮物，即金、銀、銅， ");
INSERT INTO cmncbt_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","藍色、紫色和朱紅色毛線，細麻，山羊毛， ");
INSERT INTO cmncbt_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","染成紅色的公羊皮，海狗皮，皂莢木， ");
INSERT INTO cmncbt_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","燈油，製作膏油和香的香料， ");
INSERT INTO cmncbt_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","鑲嵌在以弗得和胸牌上的紅瑪瑙及其他寶石。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","「你們當中的能工巧匠都要來建造耶和華所吩咐的物件， ");
INSERT INTO cmncbt_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","即聖幕和聖幕的罩棚、頂蓋、鉤子、木板、橫閂、柱子和帶凹槽的底座； ");
INSERT INTO cmncbt_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","約櫃和抬約櫃的橫槓、施恩座和遮掩約櫃的幔子； ");
INSERT INTO cmncbt_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","桌子和抬桌子的橫槓、桌上的一切器具和供餅； ");
INSERT INTO cmncbt_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","燈臺和燈臺用的器具、燈盞和燈油； ");
INSERT INTO cmncbt_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","香壇和抬香壇的橫槓、膏油和芬芳的香；聖幕門口的簾子； ");
INSERT INTO cmncbt_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","燔祭壇、祭壇的銅網、抬祭壇的橫槓、祭壇用的一切器具、洗濯盆和盆座； ");
INSERT INTO cmncbt_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","院子的帷幔、懸掛幔子的柱子和底座、院子入口的門簾； ");
INSERT INTO cmncbt_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","聖幕及院子用的橛子和繩子； ");
INSERT INTO cmncbt_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","在聖所供職時穿的精製禮服、亞倫祭司的聖衣及其眾子供祭司之職時穿的衣服。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","之後，以色列全體會眾便從摩西面前退去。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","凡心裡有感動又甘願奉獻的，都把禮物拿來獻給耶和華，作會幕、會幕中的一切器具及聖衣之用。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","凡甘心奉獻的，不論男女，都把別針、耳環、戒指、項鏈等各樣金飾拿來獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","凡有藍色、紫色和朱紅色毛線，細麻，山羊毛，染成紅色的公羊皮，海狗皮的，都把它們拿來了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","凡奉獻銀器和銅器的，都拿來獻給耶和華。凡有皂莢木的，只要用得上，都拿來奉獻。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","凡善於紡線的婦女，都把親手紡成的細麻和藍色、紫色、朱紅色毛線拿來奉獻。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","凡心裡受感動又善於紡織的婦女都來紡山羊毛。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","眾首領奉獻了紅瑪瑙和其他寶石，用來鑲嵌在以弗得和胸牌上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","他們又獻出香料和油，用來做香、點燈、做膏油。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","以色列人，不論男女、凡是甘心樂意奉獻的，都把禮物帶來獻給耶和華，好完成耶和華藉摩西吩咐他們的一切工作。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","摩西對以色列人說：「看啊，耶和華已經親自在猶大支派中選出戶珥的孫子、烏利的兒子比撒列， ");
INSERT INTO cmncbt_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","上帝的靈已經充滿他，使他有聰明智慧，精於各種技能和手藝， ");
INSERT INTO cmncbt_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","能用金、銀和銅製造精巧的器具， ");
INSERT INTO cmncbt_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","又能雕刻和鑲嵌寶石，精通木工和各種手藝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","耶和華又使他與但支派亞希撒抹的兒子亞何利亞伯有能力教授別人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","耶和華使他們成為能工巧匠，精通各樣技藝，包括雕刻、圖案設計、紡織，以及用細麻和藍色、紫色、朱紅色毛線刺繡。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","摩西說：「比撒列、亞何利亞伯以及所有蒙耶和華賜智慧聰明、有技能、懂得如何建造聖所的人，都要按照耶和華的吩咐去做。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","於是，摩西召來比撒列、亞何利亞伯和所有蒙耶和華賜智慧、有技能、願意參與建造的人。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","他們從摩西那裡領取了以色列百姓奉獻出來建造聖所的一切禮物。每天早上，百姓仍然甘心樂意地來奉獻禮物， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","以致所有建造聖所的能工巧匠都放下自己的工作， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","前來對摩西說：「百姓的奉獻太多了，我們建造耶和華吩咐的聖所用不了。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","於是，摩西傳令全營：「男女都不用再為聖所奉獻禮物了。」百姓這才停止奉獻。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","因為所獻的材料已經足夠建造聖所，而且綽綽有餘。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","工人中的能工巧匠用十幅幔子做成了聖幕，幔子用細麻和藍色、紫色、朱紅色毛線織成，上面精工繡製了基路伯天使。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","每幅幔子的尺寸都一樣，長十二米半、寬一米八。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","又把每五幅幔子連在一起，共連成兩幅大幔子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","然後在每幅大幔子末幅的邊緣釘上了藍色的扣環， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","每幅大幔子各釘上五十個扣環，都是兩兩相對。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","又做了五十個金鉤，把兩幅大幔子連在一起，成為一個完整的聖幕。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","比撒列用山羊毛織成十一幅幔子，作聖幕的罩棚， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","每幅長十三米半、寬一米八。十一幅幔子的尺寸都一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","然後把五幅連成一大幅，其餘六幅連成一大幅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","又在這兩幅大幔子邊緣各釘上五十個對稱的扣環， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","再用五十個銅鉤，把兩幅大幔子連在一起，成為一個完整的罩棚， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","並在罩棚上面蓋一層染成紅色的公羊皮，再蓋一層海狗皮做頂蓋。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","他用皂莢木做支聖幕的木板， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","每塊木板長四米半，寬七十釐米， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","上面都有兩個接榫，用來銜接。聖幕的所有木板都這樣做。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","聖幕的南面立二十塊木板， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","在這些木板下面又造了四十個帶凹槽的銀底座，每塊木板下面有兩個，套在木板的兩個接榫上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","聖幕北面也立二十塊木板， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","木板下面同樣有四十個帶凹槽的銀底座，每塊木板下面有兩個銀底座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","聖幕後面，就是西面，立六塊木板， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","聖幕後面的兩個拐角各有一塊木板， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","木板的下端連於底座，頂端用一個環固定。兩個拐角都這樣做。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","這樣，後面共有八塊木板，每塊木板下面各有兩個帶凹槽的銀底座，一共有十六個銀底座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","他用皂莢木做橫閂，聖幕左右兩邊和後面的牆板上各有五根橫閂， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","攔腰固定牆板的那根橫閂從這端貫穿到那端。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","所有的木板和橫閂都包上金，並在木板上造金環，用來穿橫閂。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","他用細麻和藍色、紫色、朱紅色毛線織成一幅幔子，上面精工繡上基路伯天使， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","把這幅幔子掛在四根包金的皂莢木柱上，木柱上有金鉤，四根柱子下面有四個銀底座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","他又用細麻和藍色、紫色、朱紅色毛線繡製聖幕的門簾， ");
INSERT INTO cmncbt_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","用皂莢木做五根掛門簾的柱子，上面有金鉤，柱頂和箍包上金。柱子的五個帶凹槽的底座是銅造的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","比撒列用皂莢木造了一個櫃，長一米一，寬七十釐米，高七十釐米。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","這櫃子裡外都包上純金，還鑲了一圈金邊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","他造了四個金環，安在櫃的四個腳上，每邊兩個環， ");
INSERT INTO cmncbt_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","又用皂莢木造了兩根橫槓，包上金， ");
INSERT INTO cmncbt_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","然後把橫槓穿過櫃兩邊的金環，便於抬櫃。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","他用純金造了一個施恩座，長一米一，寬七十釐米。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","又用金子在施恩座的兩端打造兩個基路伯天使。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","這兩個基路伯天使跟施恩座連在一起，在施恩座的兩端， ");
INSERT INTO cmncbt_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","面對面朝向施恩座，向上展開翅膀遮蓋施恩座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","他用皂莢木造了一張桌子，長九十釐米，寬四十五釐米，高七十釐米。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","整張桌子都包上純金，四周鑲上金邊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","在桌子四周造一個八釐米寬的外框，外框鑲上金邊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","他又造四個金環，安在桌子四角的桌腿上， ");
INSERT INTO cmncbt_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","金環靠近外框，以便穿橫槓抬桌子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","他用皂莢木造兩根橫槓，外面包金，用來抬桌子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","又用純金造桌子上的器具，就是盤、碟及獻酒用的杯和瓶。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","他用純金造了一座燈臺，燈臺的燈座、燈柱、油杯、花瓣和花萼都是用一塊純金打成的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","燈臺兩邊各伸出三個分枝，共六個分枝。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","每個分枝上都有三個杏花形狀、有花瓣和花萼的杯，六個分枝都是這樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","燈臺上有四個杏花形狀、有花瓣和花萼的杯。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","燈臺上每一對分枝的相連處有花萼，三對分枝都是這樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","整座燈臺，包括花萼和分枝，都是用一塊純金打成的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","他又用純金為這座燈臺造了七個燈盞，以及燈剪和燈花盤。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","造整座燈臺和燈臺的器具共用了六百八十兩純金。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","他又用皂莢木造了一座方形的香壇，長寬各四十五釐米，高九十釐米，壇上面凸起的四角與壇連成一體， ");
INSERT INTO cmncbt_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","壇頂、壇的四面和壇上凸起的角包上純金，四周鑲上金邊。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","他造了兩個金環，安在壇兩側的金邊下面， ");
INSERT INTO cmncbt_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","又用皂莢木造橫槓，包上金，穿在兩個環裡，用來抬香壇。 ");
INSERT INTO cmncbt_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","他又用調製香料的方法製作聖膏油和純淨芬芳的香。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","比撒列用皂莢木造了方形的燔祭壇，長寬各兩米二，高一米三， ");
INSERT INTO cmncbt_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","在壇的四角造四個凸起的角，與壇連成一體，壇外面包上銅。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","他用銅造祭壇用的一切器具，就是鍋、鏟、碗、肉叉、火鼎。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","又造了一個銅網，銅網在祭壇圍邊的下方，向下伸展到祭壇的腰部， ");
INSERT INTO cmncbt_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","在銅網的四角鑄四個銅環，以便穿橫槓。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","他用皂莢木做橫槓，包上銅， ");
INSERT INTO cmncbt_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","把橫槓穿在壇兩旁的銅環裡，以便抬壇。壇是中空的，用木板製作。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","他用在會幕門口服侍的婦女們的銅鏡造銅盆和盆座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","他用帷幔圍成院子，院子南面的帷幔用細麻織成，長四十五米。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","帷幔有二十根柱子，二十個帶凹槽的銅底座，柱子上的鉤和箍都是銀的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","北面的帷幔也是長四十五米，柱子、銅底座、鉤和箍的樣式都與南面的一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","西面的帷幔寬二十二米半，有十根柱子和十個帶凹槽的底座，鉤和箍都是銀的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","東面的帷幔也是寬二十二米半。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","入口兩邊的帷幔都是寬七米，各有三根柱子和三個帶凹槽的底座。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","院子四面的帷幔都用細麻織成。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","柱子帶凹槽的底座是銅的，柱子上面的鉤和箍是銀的，柱頂包銀，院子所有的柱子都有銀箍。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","院子入口的門簾用細麻和藍色、紫色、朱紅色毛線繡製，長九米、高兩米二，與院子帷幔的高度一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","門簾有四根柱子和四個帶凹槽的銅底座，柱子上的鉤和箍都是銀的，柱頂包銀。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","聖幕和院子四圍所有的橛子都是銅的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","以上是安放約櫃的聖幕中所用的物品，是照摩西的吩咐，由亞倫祭司的兒子以他瑪指揮利未人清點的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","猶大支派戶珥的孫子、烏利的兒子比撒列做好了耶和華吩咐摩西預備的一切物品。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","他的助手是但支派亞希撒抹的兒子亞何利亞伯，是雕刻家和設計師，並善用細麻和藍色、紫色、朱紅色毛線刺繡。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","按聖所的秤計算，建造聖所共用了奉獻的金子兩萬兩。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","按聖所的秤計算，從登記的人口所收到的銀子是六萬八千四百兩。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","這是所有登記的、年齡在二十歲以上的人所繳納的銀子，共有六十萬三千五百五十人，每人交六克銀子，以聖所的秤為準。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","鑄造聖所帶凹槽的底座和帷幔柱子帶凹槽的底座，共用了六萬八千兩銀子，共鑄造了一百個底座，每個底座用了六百八十兩銀子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","剩下的四百兩銀子用來製造柱子上的鉤和箍以及包柱頂。 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","百姓奉獻的銅共有兩千四百公斤， ");
INSERT INTO cmncbt_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","用來製造會幕入口帶凹槽的底座、祭壇、壇上的銅網及一切器具、 ");
INSERT INTO cmncbt_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","院子周圍和院子入口帶凹槽的底座以及聖幕、院子周圍所有的橛子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","比撒列等人按照耶和華對摩西的吩咐，用藍色、紫色、朱紅色毛線精工製作在聖所供職時穿的禮服，又為亞倫做聖衣。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","他們用金線、細麻及藍色、紫色、朱紅色毛線精工製作以弗得， ");
INSERT INTO cmncbt_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","把金子打成薄片，剪成細線，與細麻和藍色、紫色、朱紅色毛線巧妙地織在一起。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","他們做了兩條肩帶，固定在以弗得兩邊，用來連接以弗得。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","又按耶和華對摩西的吩咐，照以弗得的做法用金線、細麻及藍色、紫色、朱紅色毛線精工製作腰帶，縫在以弗得上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","他們選了兩塊紅瑪瑙，用刻圖章的方法刻上以色列十二個兒子的名字，鑲在兩個金框裡， ");
INSERT INTO cmncbt_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","再縫在以弗得的兩條肩帶上，作以色列人的紀念石。這些都是照耶和華對摩西的吩咐做的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","他們精工製作胸牌，像造以弗得一樣用金線、細麻及藍色、紫色、朱紅色毛線製作。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","胸牌是方形的，疊成兩層，長寬各二十二釐米。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","上面鑲上四行寶石：第一行是紅寶石、黃玉和翠玉； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","第二行是綠寶石、藍寶石和金剛石； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","第三行是紫瑪瑙、白瑪瑙和紫晶； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","第四行是水蒼玉、紅瑪瑙和碧玉。這些寶石都鑲在胸牌的金框上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","他們用刻圖章的方法，在每一顆寶石上刻一個以色列兒子的名字，十二顆寶石代表以色列十二支派。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","他們用純金擰成兩條像繩子一樣的鏈子，連在胸牌上， ");
INSERT INTO cmncbt_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","又造兩個金框和兩個金環，把金環安在胸牌兩端。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","把兩條金鏈分別繫在胸牌兩端的金環上， ");
INSERT INTO cmncbt_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","又把兩條金鏈的另兩端接在兩個金框上，安在以弗得前面的肩帶上。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","又造了兩個金環，安在靠近以弗得內邊的胸牌下兩端。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","又造了兩個金環，安在以弗得前面兩條肩帶下端，靠近精緻的以弗得腰帶上方的接縫處。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","用一條藍色的帶子繫住以弗得和胸牌上面的金環，使胸牌貼在精工織成的以弗得腰帶上，不會從以弗得上鬆脫。這些都是照耶和華對摩西的吩咐做的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","以弗得的外袍用純藍色的線織成， ");
INSERT INTO cmncbt_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","上面有領口，領口周圍織領邊，就像鎧甲上的領口，免得領口破裂。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","外袍的底邊用細麻和藍色、紫色、朱紅色毛線做成石榴狀的飾物， ");
INSERT INTO cmncbt_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","又造純金的鈴鐺掛在外袍底邊的石榴間， ");
INSERT INTO cmncbt_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","一個石榴一個金鈴鐺，相間排列，圍在外袍的底邊。這件外袍是祭司供職時穿的，正如耶和華對摩西的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","他們用細麻布為亞倫父子們縫製內袍、 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","禮冠、頭巾和褲子， ");
INSERT INTO cmncbt_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","還用細麻和藍色、紫色、朱紅色毛線繡製腰帶。這是照耶和華對摩西的吩咐做的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","又用純金造了牌子，就是聖冠，上面用刻印章的方法刻上「耶和華的聖物」的字樣， ");
INSERT INTO cmncbt_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","然後用一條藍色帶子把它繫在禮冠上。這些都是照耶和華對摩西的吩咐做的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","聖幕，就是會幕的工作就這樣全部完成了，都是以色列人照耶和華對摩西的吩咐做的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","他們把聖幕和聖幕的各樣器具都送到摩西那裡，即鉤子、木板、橫閂、柱子和帶凹槽的底座； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","海狗皮頂蓋、遮掩約櫃的幔子、染成紅色的公羊皮蓋； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","約櫃、抬約櫃的橫槓、施恩座； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","桌子、桌上的一切器具和供餅； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","純金的燈臺、燈盞、燈臺的一切器具、燈油； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","金壇、膏油、芬芳的香；會幕的門簾； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","銅祭壇、祭壇的銅網、抬祭壇的橫槓、祭壇用的一切器具、洗濯盆和盆座； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","院子的帷幔、柱子、帶凹槽的底座、院子入口的門簾、繩子、橛子和會幕，即聖幕所需的一切器具； ");
INSERT INTO cmncbt_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","在聖所供職時穿的精製禮服、亞倫祭司的聖衣及其眾子供祭司之職時穿的衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","這一切都是以色列人照耶和華對摩西的吩咐做的。 ");
INSERT INTO cmncbt_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","摩西察看這一切工作，見他們都是按照耶和華的吩咐做的，就給他們祝福。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","「你要在一月一日支起聖幕，即會幕， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","把約櫃安置在裡面，用幔子遮掩。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","把桌子搬進去，擺好桌上的器具，再把燈臺搬進去，點上燈， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","把燒香的金香壇放在約櫃前面，掛上聖幕入口的簾子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","要把燔祭壇放在聖幕門口前面， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","洗濯盆放在會幕和祭壇中間，盆裡要有水。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","用帷幔在聖幕四周圍成院子，在院子的入口掛上簾子。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","你要用膏油抹聖幕和裡面所有的器具，使它們分別出來，成為聖潔之物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","要抹燔祭壇和壇上所有器具，使燔祭壇分別出來，成為至聖之物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","要抹洗濯盆和盆座，使它們分別出來，成為聖潔之物。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","要把亞倫父子們叫到會幕入口，用水為他們沐浴， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","給亞倫穿上聖衣並膏立他，使他分別出來，做聖潔的祭司事奉我。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","也要把他的兒子們叫來，給他們穿上內袍， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","用同樣的儀式膏立他們，使他們做祭司事奉我。他們的受膏將使他們永遠做祭司，世代相傳。」 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","摩西照耶和華的吩咐把事情都辦好了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","第二年一月一日，聖幕支起來了。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","摩西支起聖幕，裝上帶凹槽的底座，豎起木板，插上橫閂，立起柱子， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","在聖幕上面搭起罩棚，鋪上頂蓋，都遵照耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","摩西把約版放在約櫃裡，橫槓穿在約櫃的兩旁，施恩座放在約櫃上， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","把約櫃抬進聖幕，掛起幔子遮掩約櫃，都遵照耶和華對他的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","他把桌子放在會幕內、遮掩約櫃的幔子外面、聖幕的北側， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","將獻給耶和華的供餅放在桌上，都遵照耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","他把燈臺放在會幕內的桌子對面，在聖幕的南側， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","然後在耶和華面前點燈，都遵照耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","他把金壇放在會幕裡、遮掩約櫃的幔子前面， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","在壇上點燃芬芳的香，都遵照耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","他掛上聖幕入口的簾子， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","在會幕，即聖幕入口前面設立燔祭壇，在壇上獻燔祭和素祭，都遵照耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","他把洗濯盆放在會幕和祭壇之間，盆裡盛水，供洗濯用。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","摩西、亞倫及其眾子都在盆裡清洗手腳， ");
INSERT INTO cmncbt_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","他們進會幕或走近祭壇的時候，都要先清洗，都遵照耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","摩西又在聖幕和祭壇的四周用帷幔圍成院子，然後在院子入口掛上簾子。這樣，摩西完成了工作。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","那時，有雲彩遮蓋會幕，耶和華的榮光充滿了聖幕。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","摩西不能進會幕，因為雲彩停在上面，耶和華的榮光充滿了聖幕。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","一路上，雲彩從聖幕上升起，他們就出發。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","雲彩不升起，他們就不出發，一直等到雲彩升起。 ");
INSERT INTO cmncbt_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","一路上，白天有耶和華的雲彩停留在聖幕上面，夜間雲中有火光照在以色列百姓眼前。");
INSERT INTO cmncbt_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","耶和華在會幕裡呼喚摩西，對他說： ");
INSERT INTO cmncbt_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","「你把以下條例告訴以色列人。 「如果你們有人獻祭給耶和華，要用牛羊作祭物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","如果用牛作燔祭，必須用毫無殘疾的公牛，在會幕門口獻上，便可蒙耶和華悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","獻祭者要把手放在燔祭牲的頭上，所獻的燔祭便蒙悅納，為他贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","他要在耶和華面前宰牛，然後做祭司的亞倫子孫，要把牛血灑在會幕門口的祭壇四周。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","獻祭者要剝掉燔祭牲的皮，把它切成塊。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","做祭司的亞倫子孫要在祭壇上生火，把木柴擺在火上， ");
INSERT INTO cmncbt_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","然後將肉塊、頭和脂肪都擺在祭壇燃燒的木柴上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","獻祭者要用水洗淨牛的內臟和腿。祭司要把這一切都放在壇上焚燒。這是燔祭，是蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","「如果用綿羊或山羊作燔祭，必須用毫無殘疾的公羊。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","獻祭者要在祭壇北面，在耶和華面前宰羊。做祭司的亞倫子孫要把羊血灑在祭壇四周。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","獻祭者將羊切成塊後，祭司要把肉塊、頭和脂肪擺在祭壇燃燒的木柴上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","獻祭者要用水洗淨羊的內臟和腿。祭司要把這一切都放在壇上焚燒。這是燔祭，是蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","「如果有人用鳥作燔祭獻給耶和華，要用斑鳩或雛鴿。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","祭司要把鳥帶到祭壇前，擰下鳥頭，放在祭壇上焚燒；要在祭壇旁放盡鳥血； ");
INSERT INTO cmncbt_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","要除掉鳥的嗉子和羽毛，扔在祭壇東邊倒灰的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","祭司要抓著兩個翅膀把鳥撕開，但不可撕斷，然後把鳥放在祭壇燃燒的木柴上焚燒。這是燔祭，是蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","「如果有人獻素祭給耶和華，要用細麵粉作祭物。要在細麵粉上澆油、加乳香， ");
INSERT INTO cmncbt_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","帶到做祭司的亞倫子孫那裡。祭司要抓一把澆了油的細麵粉，連同所有乳香放在壇上焚燒，作為象徵。這是蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","剩下的素祭要歸亞倫及其子孫，這在獻給耶和華的火祭中是至聖之物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","「如果獻用爐子烤的素祭，要獻調油的無酵細麵餅，或塗油的無酵薄餅。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","「如果獻用平底鍋烤的素祭，要獻調油的無酵細麵餅。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","要把餅掰成碎塊，澆上油。這是素祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","「如果獻用煎鍋煎的素祭，要獻用細麵粉和油做的祭物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","「要把這樣做好的素祭帶到耶和華面前，交給祭司獻在祭壇上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","祭司要從中取出一部分，作為象徵放在祭壇上焚燒。這是蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","剩下的素祭要歸亞倫及其子孫。這在獻給耶和華的火祭中是至聖之物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","「獻給耶和華的任何素祭都不可含酵，因為你們不可把酵或蜜當作火祭獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","你們可以把酵和蜜作為初熟之祭獻給耶和華，但不可作為馨香之祭獻在祭壇上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","所有素祭都要用鹽調味，不可少了你們與上帝立約的鹽。所有祭物中都要放鹽。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","「如果將初熟的穀物獻給耶和華作素祭，要用烘好後壓碎的新麥穗， ");
INSERT INTO cmncbt_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","加上油和乳香。這是素祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","祭司要將一些壓碎的麥穗、油及所有乳香作為象徵焚燒。這是獻給耶和華的火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","「如果有人用牛獻作平安祭，必須在耶和華面前獻上毫無殘疾的公牛或母牛。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","獻祭者要把手放在祭牲的頭上，在會幕門口宰殺。做祭司的亞倫子孫要把牛血灑在祭壇四周。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","獻祭者要從平安祭中獻上火祭給耶和華。他要取出包裹內臟的脂肪和內臟上的脂肪、 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","兩個腎臟和腎臟上靠近腰部的脂肪以及肝葉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","亞倫的子孫要把這一切放在祭壇燃燒的木柴上和燔祭一起焚燒，作為蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","「如果用羊作祭物向耶和華獻平安祭，必須獻毫無殘疾的公羊或母羊。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","如果獻的是綿羊羔，獻祭者要把羊羔帶到耶和華面前， ");
INSERT INTO cmncbt_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","將手放在祭牲的頭上，在會幕前宰殺。亞倫的子孫要把羊羔的血灑在祭壇四周。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","獻祭者要從平安祭中取出脂肪作為火祭獻給耶和華。他要從靠近脊椎骨處取下整條肥尾巴、包裹內臟的脂肪、內臟上的脂肪、 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","兩個腎臟和腎臟上靠近腰部的脂肪以及肝葉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","祭司要把這一切放在祭壇上焚燒，作為獻給耶和華的火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","「如果獻的是山羊，獻祭者要把山羊帶到耶和華面前， ");
INSERT INTO cmncbt_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","將手放在羊頭上，在會幕門口宰殺。亞倫的子孫要把羊血灑在祭壇四周。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","15","獻祭者要取出包裹內臟的脂肪和內臟上的脂肪、兩個腎臟和腎臟上靠近腰部的脂肪以及肝葉，作為火祭獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","祭司要把這一切放在祭壇上焚燒，作為蒙耶和華悅納的馨香火祭。所有的脂肪都屬於耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","你們無論住在哪裡，都不可吃脂肪和血，這是你們世代當守的永久律例。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","「你把以下條例告訴以色列人。 「如果有人無意中犯罪，觸犯耶和華的任何誡命，要按以下方式獻贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","「若大祭司犯罪，禍及眾民，他必須獻給耶和華一頭毫無殘疾的公牛犢作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","他要把公牛犢牽到會幕門口，將手放在牛頭上，在耶和華面前宰牛。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","他要取一些公牛的血帶進會幕裡， ");
INSERT INTO cmncbt_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","在耶和華面前用手指蘸血向聖所的幔子彈灑七次， ");
INSERT INTO cmncbt_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","也要把一些公牛的血抹在耶和華面前的香壇凸起的四角上，再把剩下的血倒在會幕門口的燔祭壇腳。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","他要取出作贖罪祭的公牛犢的所有脂肪，即包裹內臟的脂肪和內臟上的脂肪、 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","兩個腎臟和腎臟上靠近腰部的脂肪以及肝葉， ");
INSERT INTO cmncbt_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","正如取出平安祭牲的脂肪一樣。他要將這一切放在燔祭壇上焚燒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","至於公牛剩下的部分，即皮、所有的肉、頭、腿、內臟和糞便，他要帶到營外潔淨之處，就是倒壇灰的地方，放在柴上焚燒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","「以色列全體會眾若無意中觸犯耶和華的任何誡命，即使沒有意識到，也是犯罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","他們察覺自己犯罪後，必須獻上一頭公牛犢作贖罪祭。要將公牛犢帶到會幕前， ");
INSERT INTO cmncbt_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","會眾的長老要把手放在公牛的頭上，在耶和華面前宰牛。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","大祭司要帶一些牛血進入會幕， ");
INSERT INTO cmncbt_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","在耶和華面前用手指蘸血向幔子彈灑七次， ");
INSERT INTO cmncbt_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","也要把一些血抹在耶和華面前的香壇凸起的四角上，再把剩下的血倒在會幕門前的燔祭壇腳。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","他要取出公牛犢的所有脂肪，放在祭壇上焚燒， ");
INSERT INTO cmncbt_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","正如取出贖罪祭牲的脂肪一樣。這樣，祭司為全體會眾贖了罪，他們就會得到赦免。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","他要把這公牛犢剩下的部分拿到營外焚燒，像焚燒前一頭公牛犢一樣。這是為全體會眾所獻的贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","「首領若無意中觸犯他上帝耶和華的任何誡命，也是犯罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","他察覺自己犯罪後，必須獻上一隻毫無殘疾的公山羊作祭物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","他要把手放在羊頭上，在殺燔祭牲的地方，在耶和華面前宰羊。這是他的贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","祭司要用手指蘸一些贖罪祭牲的血抹在燔祭壇凸起的四角上，再把剩下的血倒在燔祭壇腳。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","要像焚燒平安祭牲的脂肪一樣，把羊的所有脂肪都放在壇上焚燒。這樣，祭司為他贖了罪，他就會得到赦免。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","「平民若無意中觸犯耶和華的任何誡命，也是犯罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","他察覺自己犯罪後，必須獻上一隻毫無殘疾的母山羊作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","他要把手放在贖罪祭牲的頭上，在殺燔祭牲的地方宰羊。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","祭司要用手指蘸一些羊血抹在燔祭壇凸起的四角上，再把剩下的血倒在燔祭壇腳。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","獻祭者要像取出平安祭牲的脂肪一樣，取出母山羊的所有脂肪。祭司要把這一切放在壇上焚燒，作為蒙耶和華悅納的馨香之祭。這樣，祭司為他贖了罪，他就會得到赦免。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","「他若獻綿羊作贖罪祭，必須獻一隻毫無殘疾的母綿羊。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","他要把手放在羊頭上，在殺燔祭牲的地方宰羊。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","祭司要用手指蘸一些羊血抹在燔祭壇凸起的四角上，再把剩下的血倒在燔祭壇腳。 ");
INSERT INTO cmncbt_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","獻祭者要像取出平安祭牲的脂肪一樣，取出母綿羊的所有脂肪。祭司要把這一切放在壇上，與獻給耶和華的祭物一起焚燒。這樣，祭司為他贖了罪，他就會得到赦免。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","「如果有人當庭作證，卻不肯把自己所知所見的說出來，就是犯罪，要擔負罪責。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","如果有人接觸了不潔淨之物，如不潔淨的野獸的屍體、家畜的屍體或爬蟲的屍體，即使沒有察覺也已不潔淨，是有罪的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","如果有人無意中接觸了別人的不潔之物，當他意識到後，就有罪了。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","如果有人草率起誓，不論出於善意還是惡意，即使當初沒有察覺，後來才意識到，也是有罪的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","如果有人意識到自己犯了以上任何一種罪，就必須認罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","為了贖過，他必須獻給耶和華一隻母綿羊或母山羊作贖罪祭。祭司要為他贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","「他若獻不起羊，就要獻給耶和華兩隻斑鳩或兩隻雛鴿，一隻作贖罪祭，一隻作燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","他要把牠們帶到祭司那裡，祭司要先用一隻鳥獻贖罪祭，要扭斷鳥脖子，但不可扯掉頭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","要把一些鳥血灑在祭壇邊，再把剩下的血倒在壇腳。這是贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","祭司要依照獻燔祭的條例獻上另一隻鳥。這樣，祭司為他贖了罪，他就會得到赦免。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","「他若獻不起兩隻斑鳩或雛鴿，就要獻一公斤細麵粉作贖罪祭。細麵粉中不可澆油或加乳香，因為這是贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","他要把細麵粉帶到祭司那裡，祭司要從中取出一把作為象徵放在壇上，與獻給耶和華的火祭一起焚燒。這是贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","這樣，祭司為他贖了罪，他就會得到赦免。剩下的細麵粉要歸祭司，像獻素祭一樣。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","「如果有人無意中干犯了耶和華聖物的條例，為了贖過，他要從羊群中選一隻毫無殘疾的公綿羊獻給耶和華，或按聖所的秤獻上同等價值的銀子。這是贖過祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","他要賠償所造成的損失，並加賠五分之一，要把這些都交給祭司。祭司要為他獻上公綿羊作贖過祭，為他贖罪，他就會得到赦免。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","「如果有人觸犯耶和華的任何誡命，即使他不知道，也是犯罪，必須擔當罪責。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","他要從羊群中選一隻毫無殘疾的公綿羊，或把同等價值的銀子帶到祭司那裡作贖過祭。祭司要為他的無心之過贖罪，他就會得到赦免。 ");
INSERT INTO cmncbt_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","這是贖過祭，因為他在耶和華面前確實有罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","3","「如果有人拒絕歸還同胞委託他保管的物品或抵押品，或搶掠同胞，或欺騙同胞，或撿到失物卻矢口否認，或起假誓，或犯其他類似的罪，因而失信於耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","一旦他意識到自己犯了罪，必須歸還一切靠偷盜、欺詐、侵佔、拾遺、 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","或起假誓得來的東西，他必須在獻贖過祭那天如數歸還物主，並加賠五分之一。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","他要從羊群中選一隻毫無殘疾的公綿羊，或把同等價值的銀子帶到祭司那裡，獻給耶和華作贖過祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","祭司要在耶和華面前為他贖罪，他的過犯就會得到赦免。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","「你要吩咐亞倫及其子孫遵行以下獻燔祭的條例。 「燔祭要整夜留在祭壇上，壇上的火要不停地燃燒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","早晨，祭司要穿上細麻衣袍和內衣，將燔祭壇上的灰燼清理好，放在祭壇旁邊。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","然後，他要更換衣服，把灰燼拿到營外潔淨的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","祭壇上的火要不斷燃燒，不能熄滅。祭司每天早上要在壇上加柴，擺上燔祭，在上面燒平安祭牲的脂肪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","壇上的火必須不斷燃燒，不可熄滅。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","「以下是獻素祭的條例。 「亞倫的子孫要在祭壇前向耶和華獻素祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","祭司要從素祭中拿一把調油的細麵粉和所有的乳香，作為象徵放在壇上焚燒，作蒙耶和華悅納的馨香之祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","亞倫及其子孫要吃剩下的祭物，要在會幕院子裡的聖潔之處做無酵餅吃。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","做餅時不可加酵。這些祭物是我從獻給我的火祭中賜給他們的，像贖罪祭和贖過祭一樣是至聖之物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","亞倫的子孫中，男子都可以吃耶和華的火祭。這是他們世世代代應得之份。凡接觸到這些祭物的都會變得聖潔。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","「亞倫及其子孫受膏那天，要獻給耶和華一公斤細麵粉作為日常獻的素祭，早晚各獻一半。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","要把這些細麵粉調上油，用煎鍋做餅，切成塊獻上，作為蒙耶和華悅納的馨香素祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","亞倫子孫中繼任大祭司的，受膏時要獻上素祭。這種祭物必須全部燒掉獻給耶和華，這是永遠的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","祭司獻的這種素祭不可吃，要全部燒掉。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","「你把以下贖罪祭的條例告訴亞倫及其子孫。 「贖罪祭是至聖的，要在殺燔祭牲的地方，在耶和華面前宰祭牲。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","獻贖罪祭的祭司要在會幕院子裡的聖潔之處吃這祭牲。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","凡接觸到這些祭肉的，都會變得聖潔。如果衣服被濺上血，則要在聖潔之處把衣服洗淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","用來煮祭肉的瓦鍋，用後都要打碎。如果用的是銅鍋，要擦乾淨並用水沖洗。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","這些祭肉是至聖之物，祭司家族中的男子都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","如果贖罪祭牲的血被帶進會幕，在聖所內進行贖罪，就不可吃祭肉，必須全部燒掉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","「以下是獻贖過祭的條例。 「贖過祭是至聖的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","要在殺燔祭牲的地方宰贖過祭祭牲，祭牲的血要灑在祭壇周圍。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","要獻上祭牲的所有脂肪，包括肥尾巴、包裹內臟的脂肪、 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","兩個腎臟和腎臟上靠近腰部的脂肪以及肝葉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","祭司要在壇上焚燒這一切，作為獻給耶和華的火祭。這是贖過祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","祭司家的任何男子都可以吃剩下的祭肉，但要在聖潔之處吃，因為這是至聖之物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","祭物要歸主持祭禮的祭司，這一條例也適用於贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","燔祭牲的皮要歸主持祭禮的祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","至於素祭，不論是用爐烤的，還是用平底鍋或煎鍋做的，都要歸主持祭禮的祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","但調油的或乾的素祭要歸亞倫的子孫，由他們均分。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","「以下是向耶和華獻平安祭的條例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","「有人若為感謝耶和華而獻平安祭，除了獻祭牲以外，要一同獻上調油的無酵餅、塗油的無酵薄餅及調油的細麵餅， ");
INSERT INTO cmncbt_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","也要一同獻上有酵餅。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","他要從每種餅中各取一個，作為舉祭獻給耶和華。舉祭歸灑平安祭祭牲血的祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","至於為感恩而獻的平安祭祭肉，要在獻祭的當天吃完，不可留到次日早晨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","如果是自願獻的或為了還願而獻的祭物，要在獻祭當天吃祭肉，剩下的可以留到第二天吃。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","但到第三天，必須燒掉剩下的祭肉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","如果第三天仍然吃祭肉，所獻的祭便不蒙悅納，毫無價值，是不潔淨的。吃的人要自擔罪責。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","「祭肉如果接觸到任何不潔之物，都不可吃，要燒掉。潔淨的人都可以吃祭肉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","如果有人不潔淨，卻吃獻給耶和華的平安祭祭肉，要將他從民中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","如果有人接觸到人或獸的不潔之物，或任何不潔的可憎之物，又吃獻給耶和華的平安祭祭肉，要將他從民中剷除。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","「你把以下條例告訴以色列人。 「你們不可吃牛、綿羊或山羊的脂肪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","自然死亡或被野獸咬死的動物的脂肪也不可吃，但可以作其他用途。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","無論誰吃了獻給耶和華的火祭祭牲的脂肪，都要將他從民中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","你們無論住在哪裡，都不可吃鳥和獸的血。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","凡吃血的，要將他從民中剷除。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","「你把以下條例告訴以色列人。 「凡向耶和華獻平安祭的，都要從平安祭中取出一份獻給耶和華作禮物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","他要親手將這獻給耶和華的火祭帶來，將祭牲的脂肪和胸肉帶來，在耶和華面前將胸肉搖一搖，當作搖祭獻上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","祭司要把脂肪放在壇上焚燒，胸肉歸亞倫及其子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","你們要把平安祭牲的右腿獻為舉祭，歸給祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","要把右腿歸給亞倫子孫中獻平安祭的血和脂肪的那位祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","因為耶和華已經從以色列人獻的平安祭中，把作搖祭的胸肉和作舉祭的腿肉，賜給祭司亞倫及其子孫，這是他們在以色列人中永遠當得的份。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","從亞倫及其子孫受膏為祭司事奉耶和華開始，在獻給耶和華的火祭中，這是他們應得之份。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","祭司受膏之日，耶和華就命令以色列人把這部分祭肉分給他們，這是他們世世代代應得之份。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","以上是獻燔祭、素祭、贖罪祭、贖過祭、平安祭和授聖職時所獻之祭的條例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","這些條例是耶和華在西奈山上吩咐摩西的。當天，摩西命令以色列人在西奈曠野向耶和華獻祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","「你把亞倫父子們帶來，也要帶聖衣、膏油、一頭作贖罪祭的公牛、兩隻公綿羊和一籃無酵餅， ");
INSERT INTO cmncbt_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","然後把全體會眾招聚到會幕門前。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","摩西按照耶和華的指示行事，會眾都聚集在會幕門前。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","摩西告訴會眾：「這是耶和華吩咐我做的事。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","他把亞倫父子們帶來，用水洗他們。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","摩西給亞倫穿上內袍，束上腰帶，穿上外袍，套上以弗得，用精巧的帶子把以弗得繫在亞倫身上， ");
INSERT INTO cmncbt_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","然後給他戴上胸牌，把烏陵和土明放在胸牌內， ");
INSERT INTO cmncbt_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","再把禮冠戴在他頭上，在禮冠前繫上金牌，即聖冠，都遵照耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","摩西拿膏油抹聖幕和聖幕裡的一切物件，使它們聖潔； ");
INSERT INTO cmncbt_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","再用膏油在祭壇上灑七次，又抹祭壇和祭壇上的器具、洗濯盆和盆座，使它們聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","然後，摩西把膏油倒在亞倫頭上膏立他，使他聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","摩西又把亞倫的兒子們帶來，給他們穿上內袍，束上腰帶，戴上頭巾，都遵照耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","摩西牽來那頭作贖罪祭的公牛，亞倫父子們把手按在牛頭上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","摩西宰了牛，用手指蘸一些牛血抹在祭壇凸起的四角上，以潔淨祭壇，再把剩下的血倒在壇腳，使祭壇聖潔，為祭壇贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","他取出內臟上的脂肪、肝葉、兩個腎臟和腎臟上的脂肪，放在祭壇上燒掉， ");
INSERT INTO cmncbt_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","又照耶和華的吩咐，把公牛的皮、肉和糞便帶到營外燒掉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","然後，摩西獻上作燔祭的公綿羊，亞倫父子們把手按在羊頭上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","摩西宰了那隻羊，把血灑在祭壇四周； ");
INSERT INTO cmncbt_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","把羊切成塊，焚燒羊頭、肉塊和脂肪； ");
INSERT INTO cmncbt_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","用水洗淨羊的內臟和腿，把整隻羊放在祭壇上焚燒，這是燔祭，作蒙耶和華悅納的馨香火祭，都遵照耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","摩西獻上另一隻為授聖職而獻的公綿羊。亞倫父子們把手按在羊頭上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","摩西宰了羊，將一些羊血抹在亞倫的右耳垂、右手大拇指和右腳大腳趾上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","他又把亞倫的兒子們帶來，將一些血抹在他們的右耳垂、右手大拇指和右腳大腳趾上，然後把剩下的血都灑在祭壇四周。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","他取下羊的脂肪、肥尾巴、內臟上的脂肪、肝葉、兩個腎臟、腎臟上的脂肪和右腿， ");
INSERT INTO cmncbt_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","又從放在耶和華面前盛無酵餅的籃子裡取一個無酵餅、一個油餅和一個薄餅，放在羊的右腿和脂肪上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","他把這些都放在亞倫父子們手中，作為搖祭在耶和華面前搖一搖。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","隨後，他從他們手上拿過這些祭物，放在祭壇的燔祭上焚燒，作為授聖職時獻的祭。這是蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","摩西又把公綿羊的胸肉作為搖祭，在耶和華面前搖一搖，這是他授聖職時所應得之份，都遵照耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","摩西拿了一些膏油和壇上的血，灑在亞倫和他的衣服上，也灑在他兒子們和他們的衣服上，使亞倫父子們和他們的衣服聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","摩西對亞倫父子們說：「你們要照我的吩咐在會幕門口煮祭肉吃，也要吃籃子裡為授聖職而獻的餅。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","吃剩的肉和餅，你們要燒掉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","你們的授聖職禮歷時七天，這七天之內，你們不可離開會幕門口。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","今天所做的這一切都是耶和華吩咐的，是為你們贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","七天之內，你們必須日夜待在會幕門口，要遵守耶和華的吩咐，免得你們死亡。這是耶和華對我的吩咐。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","於是，亞倫父子們遵行了耶和華藉摩西吩咐的一切。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","到了第八天，摩西召來亞倫父子們和以色列的眾長老。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","他對亞倫說：「你要在耶和華面前獻上一頭公牛犢作贖罪祭、一隻公綿羊作燔祭，這些祭牲都要毫無殘疾。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","然後，你要告訴以色列人，『你們要取一隻公山羊作贖罪祭、毫無殘疾的一頭一歲牛犢和一隻一歲羊羔作燔祭、 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","一頭公牛和一隻公綿羊作平安祭，連同調油的素祭一起獻給耶和華，因為今天耶和華要向你們顯現。』」 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","於是，以色列人遵照摩西的吩咐，把祭物帶到會幕前。全體會眾都聚集到那裡，站在耶和華面前。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","摩西對他們說：「耶和華吩咐你們這樣做，是為了向你們顯出祂的榮耀。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","隨後，摩西對亞倫說：「你要到壇前來，獻上你的贖罪祭和燔祭，為自己和民眾贖罪。也要按照耶和華的吩咐，為百姓獻上他們的祭物，為他們贖罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","於是，亞倫走到壇前，宰殺為他作贖罪祭的牛犢。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","他兒子們把牛犢的血遞給他，他用手指蘸血抹在祭壇凸起的四角上，再把剩下的血倒在壇腳。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","他照耶和華對摩西的吩咐，在壇上焚燒贖罪祭牲的脂肪、腎臟和肝葉， ");
INSERT INTO cmncbt_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","把皮和肉帶到營外焚燒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","亞倫宰了燔祭祭牲，他兒子們把祭牲的血遞給他，他把血灑在祭壇四周。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","他們將祭牲一塊一塊地連頭一起交給亞倫獻在壇上焚燒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","亞倫洗淨祭牲的內臟和腿，放在祭壇的燔祭上焚燒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","隨後，亞倫為民眾獻祭。他牽來那隻為民眾作贖罪祭的公山羊，宰殺後，像剛才為自己獻贖罪祭一樣為他們獻上贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","他又牽來燔祭祭牲，依照條例獻上燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","除了早晨的燔祭，亞倫又取來素祭，從中拿了一把獻在壇上焚燒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","然後，他宰了公牛和公綿羊，為民眾獻平安祭。他兒子們把祭牲的血遞給他，他把血灑在祭壇四周。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","他們把公牛和公綿羊的脂肪、肥尾巴、包裹內臟的脂肪、腎臟和肝葉， ");
INSERT INTO cmncbt_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","放在祭牲的胸脯上，然後亞倫把那些脂肪放在壇上焚燒， ");
INSERT INTO cmncbt_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","將胸肉和右腿肉作為搖祭在耶和華面前搖一搖，都遵照摩西的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","亞倫舉手為民眾祝福，他獻完贖罪祭、燔祭和平安祭後走下祭壇。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","之後，摩西和亞倫走進會幕，又出來為民眾祝福。這時，耶和華的榮耀向所有民眾顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","有火從耶和華那裡降下來，燒盡祭壇上的燔祭和脂肪。民眾看見這景象，都歡呼起來，俯伏在地。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","亞倫的兒子拿答和亞比戶各拿自己的香爐，點火加香，在耶和華面前獻上凡火。他們這樣做不合耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","於是，有火從耶和華面前出來吞噬了他們，他們就死在耶和華面前。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","摩西告訴亞倫：「耶和華曾說過，『我要在事奉我的人中顯明我的聖潔，在所有子民面前彰顯我的榮耀。』」亞倫默默無言。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","摩西叫來亞倫的叔父烏薛的兒子米沙利和以利撒反，對他們說：「過來，把你們弟兄的屍體從聖所前抬到營外去。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","他們就遵照摩西的吩咐，把仍穿著內袍的屍體抬到營外。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","摩西對亞倫和他剩下的兩個兒子以利亞撒和以他瑪說：「你們不要蓬頭散髮，也不要撕裂衣服，免得你們死亡，也免得耶和華向全體會眾發怒。不過，你們的所有以色列同胞都可以為耶和華用火燒死的人哀傷。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","你們不可走出會幕門口，免得你們死亡，因為耶和華的膏油在你們身上。」他們就遵照摩西的話去做。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","耶和華對亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","「你和你兒子們進會幕前，淡酒烈酒都不可喝，免得你們死亡。這是你們世代當守的永久律例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","你們必須區分什麼是聖潔的、什麼是世俗的，什麼是潔淨的、什麼是不潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","你們必須將我藉摩西賜給以色列人的一切律例教導他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","摩西對亞倫及其兩個兒子以利亞撒和以他瑪說：「你們要把獻給耶和華的火祭中剩下的素祭做成無酵餅，在壇邊吃，因為這是至聖之物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","你們要在聖潔之處吃，因為在獻給耶和華的火祭中，這是你們和你們的子孫應得之份。這是耶和華對我的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","至於作搖祭的胸肉和作舉祭的腿肉，你們和你們的子孫可以在潔淨的地方吃。因為在以色列人所獻的平安祭中，這是你們應得之份。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","在獻火祭的脂肪時，要把作舉祭的腿肉和作搖祭的胸肉，一起帶到耶和華面前作為搖祭搖一搖，這些永遠是你們和你們的子孫應得之份，正如耶和華的吩咐。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","摩西到處尋找那隻作贖罪祭的公山羊，卻發現那隻羊已經被焚燒了。他憤怒地對亞倫剩下的兩個兒子以利亞撒和以他瑪說： ");
INSERT INTO cmncbt_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","「你們為什麼不在聖潔之處吃這贖罪祭？這是至聖之物，耶和華賜給你們是要叫你們為會眾擔罪，在耶和華面前為他們贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","既然這祭牲的血沒有被帶進聖所，你們本應按照我的吩咐在聖潔之處吃這祭肉。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","亞倫對摩西說：「看啊，他們今天向耶和華獻贖罪祭和燔祭，卻有這樣的災禍發生在我身上。今天我如果吃了這贖罪祭的祭肉，耶和華會悅納嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","摩西聽了亞倫的回答，感到滿意。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","「你們把以下條例告訴以色列人。 「地上的動物， ");
INSERT INTO cmncbt_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","凡蹄子分瓣且反芻的動物，你們都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","但你們不可吃只是蹄子分瓣或只反芻的動物。駱駝不潔淨，因為牠雖反芻但蹄子不分瓣； ");
INSERT INTO cmncbt_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","石獾不潔淨，因為牠雖反芻但蹄子不分瓣； ");
INSERT INTO cmncbt_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","野兔不潔淨，因為牠雖反芻但蹄子不分瓣； ");
INSERT INTO cmncbt_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","豬不潔淨，因為牠雖蹄子分瓣但不反芻。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","你們不可吃牠們的肉，也不可摸牠們的屍體，因為牠們對你們來說不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","「海洋與河流裡的動物，凡有鰭有鱗的，你們都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","但海洋與河流裡無鰭無鱗的動物，你們要憎惡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","牠們都是可憎之物，你們不可吃牠們的肉，也不可摸牠們的屍體。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","水中任何無鰭無鱗的動物，你們都要視為可憎之物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","「你們不可吃以下鳥類，要視為可憎之物。牠們是鵰、胡兀鷲、黑禿鷲、 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","鳶、隼類、 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","烏鴉類、 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","鴕鳥、夜鷹、海鷗、鷹類、 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","小鴞、鸕鷀、大鴞、 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","倉鴞、鵜鶘、魚鷹、 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","鸛、鷺鳥類、戴鵀和蝙蝠。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","「你們要憎惡會飛的四足爬行昆蟲， ");
INSERT INTO cmncbt_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","但可以吃其中會飛會跳的昆蟲， ");
INSERT INTO cmncbt_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","包括蝗蟲類、蟋蟀類和蚱蜢類。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","你們要憎惡所有會飛的四足爬行昆蟲。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","「以下的動物會使你們不潔淨。任何人接觸到牠們的屍體，都不潔淨，要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","任何人拿牠們的屍體，都必須洗淨所穿的衣服，要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","蹄子不分瓣或不反芻的動物，你們要視為不潔淨，碰到牠們的人都不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","所有以腳掌走路的四足動物，你們要視為不潔淨，碰到牠們屍體的人都不潔淨，要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","凡拿牠們屍體的人都必須洗淨所穿的衣服，要等到傍晚才能潔淨。你們要視牠們為不潔淨的動物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","「地上不潔淨的動物有鼬鼠、老鼠、大蜥蜴類、 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","壁虎、巨蜥、小蜥蜴和變色龍。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","這些爬蟲都是不潔淨的。任何人碰到牠們的屍體，都不潔淨，要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","如果牠們的屍體掉在什麼東西上，不管是木器、衣物、皮件還是袋子，不管作何用途，都會變得不潔淨。要把那東西放在水中，一直到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","如果牠們的屍體掉在陶器裡，陶器裡盛的東西都不潔淨。你們必須打碎那陶器。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","陶器裡的水如果滴到食物上，食物就不潔淨；如果滴到盛飲品的器皿裡，飲品也不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","牠們的屍體無論掉在什麼東西上，那東西都不潔淨，無論是爐是鍋都要打碎。它們不潔淨，也理當被你們視為不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","如果牠們的屍體掉進水泉或儲水池裡，水泉和儲水池仍然是潔淨的，但碰到屍體的人是不潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","如果牠們的屍體接觸到將要播撒的種子，種子仍是潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","但如果牠們的屍體碰到泡過水的種子，種子就不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","「一隻可以食用的動物死後，任何人如果碰到牠的屍體，都不潔淨，要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","任何人如果吃牠的肉，或拿牠的屍體，都必須洗淨衣服，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","「地上所有的爬蟲都是可憎的，你們不可吃。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","你們不可吃用肚子、四腳或多腳爬行的動物，這些都是可憎的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","不可讓這些動物使你們成為可憎的，不可因它們而玷污自己，使自己不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","我是你們的上帝耶和華。你們要分別出來做聖潔的人，因為我是聖潔的。不可讓地上的爬蟲玷污你們。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","我是耶和華，我帶你們出埃及，為要做你們的上帝。你們要聖潔，因為我是聖潔的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","「以上是有關飛禽走獸、水族和地上一切爬蟲的條例， ");
INSERT INTO cmncbt_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","使你們可以區分什麼是潔淨的、什麼是不潔淨的、什麼是可吃的、什麼是不可吃的。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","「你把以下條例告訴以色列人。 「如果有婦人生了男嬰，她就要不潔淨七天，像在經期內不潔淨一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","第八天，嬰兒要接受割禮。 ");
INSERT INTO cmncbt_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","婦人因產後流血，要等三十三天才能潔淨。其間，不可接觸任何聖物，也不可進入聖所。 ");
INSERT INTO cmncbt_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","如果婦人生的是女嬰，她就要不潔淨十四天，像在經期內不潔淨一樣。她因產後流血，要等六十六天才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","她不論生男生女，潔淨期滿後，都要預備一隻一歲的羊羔作燔祭、一隻雛鴿或斑鳩作贖罪祭，帶到會幕門口交給祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","祭司要在耶和華面前獻祭，為她贖罪，她的流血狀況才算潔淨。這是有關產婦生男生女的條例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","她若負擔不起一隻羊羔，可以帶兩隻斑鳩或雛鴿來，一隻作燔祭，一隻作贖罪祭。祭司為她贖罪後，她就潔淨了。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","「如果有人皮膚上長腫包、皮疹或白斑，出現痲瘋病症狀，要將他帶到祭司亞倫或亞倫做祭司的子孫那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","祭司要檢查患處，如果病灶深入皮下，患處的毛髮變白，就是痲瘋病。祭司檢查後，要宣佈他是不潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","如果那人的患處有白斑，但病灶沒有深入皮下，患處的毛髮也沒有變白，祭司要把他隔離七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","第七天，祭司要再次檢查患處，如果病灶沒有惡化，沒有在皮膚上擴散，祭司要把他再隔離七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","第七天，祭司要再次檢查，如果患處顏色變淡，也沒有擴散，祭司要宣佈他是潔淨的。他患的不過是皮疹，他要洗淨衣物，便會潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","如果祭司已查看並宣佈他是潔淨的，但皮疹又擴散，他必須再去見祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","祭司檢查時，如果發現皮疹已擴散，就要宣佈他是不潔淨的，患了痲瘋病。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","「如果有人患痲瘋病，必須將他帶到祭司面前。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","祭司檢查時，如果發現他皮膚上有白色腫包，毛髮變白，患處長出新肉， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","他就是患了慢性痲瘋病，祭司要宣佈他是不潔淨的。他無須被隔離，因他已經不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","如果他的痲瘋病已擴散，頭上腳上到處可見， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","祭司就要檢查。如果發現痲瘋病已擴散到他全身，全身的皮膚變白，祭司就要宣佈他是潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","一旦他身上出現新長的肉，他便不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","祭司看到他身上新長的肉，就要宣佈他是不潔淨的，因為新長的肉是不潔淨的，表明他患了痲瘋病。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","如果新長的肉變白了，他就要去見祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","祭司檢查時，若發現患處確已變白，就要宣佈他是潔淨的，他便潔淨了。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","「如果有人皮膚上長瘡，又痊癒了， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","但原患處出現白色腫包或白裡帶紅的斑，他就要去讓祭司檢查。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","祭司檢查時，若發現病灶深入皮下，患處的毛髮變白，就要宣佈他是不潔淨的。這是瘡變成了痲瘋病。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","但祭司檢查時，若發現患處沒有白毛，病灶也沒有深入皮下，且顏色變淡，就要把他隔離七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","隔離期間，若病灶在皮膚上擴散，祭司要宣佈他是不潔淨的，是患了痲瘋病。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","如果患處的斑保持原樣，沒有擴散，便是瘡疤，祭司要宣佈他是潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","「如果有人被火燒傷，傷處變白或白中帶紅， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","祭司要檢查他的傷處。如果傷處毛髮變白，且深入皮下，就是燒傷已變成痲瘋病，祭司要宣佈他是不潔淨的，因為他患了痲瘋病。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","祭司檢查時，若發現傷處沒有白毛，也沒有深入皮下，且顏色變淡，就要把他隔離七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","第七天，祭司要再次檢查，若發現傷處擴散，就要宣佈他是不潔淨的，因為他患了痲瘋病。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","如果傷處保持原樣，沒有擴散，且顏色變淡，就是燒傷引起的腫包，祭司要宣佈他是潔淨的，因為那不過是燒傷的疤痕。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","「如果有男女頭上或下巴長瘡， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","祭司要檢查患處，若發現患處病灶深入皮下，上面有黃色細毛，就要宣佈那人是不潔淨的，因為那是疥癬，是痲瘋病。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","祭司檢查時，若發現病灶沒有深入皮下，也沒有黑毛，就要將那人隔離七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","第七天，祭司要檢查患處，若發現疥癬沒有擴散，上面沒有黃毛，也沒有深入皮下， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","那人要剃去頭髮和鬍鬚，但不可剃患處的毛髮。祭司要將他再隔離七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","第七天，祭司要再次檢查，若發現疥癬沒有在皮膚上擴散，也沒有深入皮下，就要宣佈那人是潔淨的。那人要洗淨衣服，便潔淨了。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","那人潔淨以後，疥癬若再次擴散， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","祭司就要再次檢查。如果疥癬確已擴散，祭司不必再找黃毛，那人是不潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","如果祭司看到疥癬原樣未變，患處長出黑毛，那人就已經痊癒，是潔淨的。祭司要宣佈那人是潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","「如果有男女身上長白斑， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","祭司要檢查患處，若發現斑呈灰白色，就是皮疹，那人是潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","「如果有人脫髮，成了禿頭，他是潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","如果有人前額脫髮，他只是前額光禿，仍是潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","如果在光禿的頭上或前額上長出白裡帶紅的瘡，那就是痲瘋病。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","祭司要檢查患處，若發現瘡周圍腫脹、白中帶紅，看起來像痲瘋病， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","就是得了痲瘋病，那人是不潔淨的。祭司要因那人頭上的瘡而宣佈他是不潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","「患痲瘋病的人必須撕裂衣服，披頭散髮，遮住臉的下半部，高喊『不潔淨！不潔淨！』 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","只要病不痊癒，他就不潔淨，要獨自住在營外。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","「如果衣物出現黴斑，不論是羊毛衣、細麻衣、 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","羊毛織品、細麻織品，還是皮革或皮革製品， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","只要發現黴斑是綠色或紅色的，那就是黴變，要拿給祭司檢查。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","祭司檢查後，要把那衣物隔離七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","第七天，祭司要再次檢查，若發現衣物、編織品或皮革上的黴斑蔓延，就是惡性黴變，那衣物就不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","不論那是衣服、羊毛或細麻織品，還是皮革製品，祭司都必須把它燒掉，因為那是惡性黴變，必須燒掉黴變的衣物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","如果祭司發現衣服、編織品或皮革上的黴斑沒有蔓延， ");
INSERT INTO cmncbt_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","就要吩咐人洗淨衣物，再隔離七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","之後，祭司要再次檢查洗過的衣物，若發現黴斑原樣未變，即使沒有蔓延，那衣物也是不潔淨的。無論衣物裡面還是外面黴變，都必須把它燒掉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","如果祭司發現洗過後黴斑退色，就要把黴變的部分從衣服、皮革、編織品上撕下來。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","以後衣物、編織品或皮革上若再次出現黴斑，便是舊患復發，要把它燒掉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","如果洗過衣服、編織品或皮革後，黴斑消失了，要再洗一次就潔淨了。 ");
INSERT INTO cmncbt_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","「羊毛衣、細麻衣、編織品或皮革製品出現黴變時，以上條例可用來鑒定這些衣物是否潔淨。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","「以下是有關痲瘋病患者的潔淨條例。 「痲瘋病患者痊癒後，要被帶到祭司那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","祭司要到營外去檢查，如果發現他的病已痊癒， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","要吩咐人為他拿來兩隻潔淨的活鳥、香柏木、朱紅色線和牛膝草。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","祭司要吩咐人在一個盛清水的陶器上宰殺一隻鳥， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","然後祭司要把另一隻鳥，連同香柏木、朱紅色線和牛膝草一起蘸在摻了清水的鳥血裡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","祭司要用鳥血在他身上灑七次，宣佈他是潔淨的，然後放走那隻活鳥，讓牠飛向田野。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","他要洗淨衣服，剃去所有毛髮，沐浴之後便潔淨了，可以回到營內，但要住在自己的帳篷外七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","第七天，他要再次剃掉頭髮、鬍鬚和眉毛等各處毛髮，並洗衣、沐浴，之後便潔淨了。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","「第八天，他要帶來兩隻毫無殘疾的公羊羔、一隻毫無殘疾的一歲母羊羔、三公斤作素祭的調油的細麵粉和一杯油。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","主持潔淨禮的祭司要把他及其祭物帶到會幕門口、耶和華面前， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","並獻上一隻公羊羔和一杯油作贖過祭，作為搖祭在耶和華面前搖一搖。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","他要在殺贖罪祭牲和燔祭牲的聖潔之處宰公羊羔。贖過祭的祭物要歸祭司，像贖罪祭一樣，這是至聖之物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","祭司要拿一些贖過祭祭牲的血抹在求潔淨者的右耳垂、右手大拇指和右腳大腳趾上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","祭司要拿那杯油，倒一些在自己左手掌中， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","用右手手指蘸左手掌裡的油，在耶和華面前彈灑七次， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","然後用手掌中剩下的油抹求潔淨者的右耳垂、右手大拇指和右腳大腳趾，就是抹了贖過祭祭牲血的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","祭司要把手掌裡剩下的油抹在求潔淨者的頭上。這樣，祭司在耶和華面前為他贖了罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","祭司要獻上贖罪祭，為求潔淨者贖罪。然後，祭司要宰殺燔祭牲， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","在祭壇上獻燔祭和素祭，為他贖罪，他就潔淨了。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","「他如果貧窮，獻不起那麼多祭物，可以獻一隻公羊羔作贖過祭，用搖祭的方式贖罪；也要獻一公斤作素祭的調油的細麵粉和一杯油； ");
INSERT INTO cmncbt_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","還要按自己的能力獻兩隻斑鳩或雛鴿，一隻作贖罪祭，一隻作燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","第八天，他必須把這些祭物帶到會幕門口，在耶和華面前交給祭司，好使自己潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","祭司要用作贖過祭的羊羔和一杯油作搖祭，在耶和華面前搖一搖。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","接著，祭司要宰殺作贖過祭的羊羔，拿一些羊血抹在求潔淨者的右耳垂、右手大拇指和右腳大腳趾上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","祭司也要把一些油倒在自己左手掌中， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","用一根右手指蘸左手掌中的油，在耶和華面前彈灑七次， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","然後把手掌中的一些油抹在求潔淨者的右耳垂、右手大拇指和右腳大腳趾上，就是抹了贖過祭祭牲血的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","祭司要把手掌裡剩下的油抹在求潔淨者的頭上，在耶和華面前為他贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","然後獻上那人按自己能力帶來的兩隻斑鳩或雛鴿， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","一隻作贖罪祭，一隻作燔祭，和素祭一起獻上。這樣，祭司在耶和華面前為求潔淨者贖了罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","這是獻不起潔淨禮所需祭物的痲瘋病患者應當遵守的條例。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","「你們到了我賜給你們作產業的迦南以後，如果我使那裡的房屋中有發黴現象， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","屋主必須去告訴祭司，『我的房子裡好像有發黴現象。』 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","祭司進去檢查前，要吩咐人把房子騰空，免得房子裡的一切都變得不潔淨。之後，祭司要進去檢查， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","如發現牆壁上出現紅色或綠色黴斑，並且侵入牆中， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","祭司就要從房門出來，把房子封閉七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","第七天，祭司要回去檢查。若發現牆壁上的黴斑蔓延， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","就要下令拆掉有黴斑的石塊，丟到城外不潔淨的地方， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","然後命人刮掉屋內牆壁上的灰泥，倒在城外不潔淨的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","要另找石塊補被拆掉的地方，並用灰泥重新粉刷房子。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","「如果拆掉石塊、刮掉灰泥、重新粉刷以後，房子再度出現黴斑， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","祭司要去檢查，若發現黴斑已蔓延，就是惡性黴變，那房子就不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","房主要拆掉房子，把石塊、木料和所有灰泥都丟到城外不潔淨的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","房子封閉期間，任何人進去，都不潔淨，要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","凡在房內睡覺或吃飯的人，都必須洗淨衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","「祭司檢查粉刷後的房子，若發現房內沒有再度出現黴斑，就要宣佈房子是潔淨的，因為黴斑已消失。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","為潔淨房子，祭司要取兩隻鳥、香柏木、朱紅色線和牛膝草， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","在一個盛清水的陶器上宰殺一隻鳥， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","然後用香柏木、牛膝草、朱紅色線和另一隻活鳥，蘸摻了清水的鳥血，向房子灑七次。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","祭司用鳥血、清水、活鳥、香柏木、牛膝草和朱紅色線潔淨那房子後， ");
INSERT INTO cmncbt_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","要放走那隻活鳥，讓牠飛到城外的田野。這樣，祭司為那房子贖了罪，房子就潔淨了。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","以上條例是有關痲瘋病、疥癬、 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","衣物或房子發黴、 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","腫包、皮疹或白斑的條例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","根據這些條例，可以分辨有關的人或物何時潔淨、何時不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","「你們把以下條例告訴以色列人。 「如果有男人患了漏症，他下體的排洩物是不潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","不論他下體的排洩物止住與否，他都是不潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","他睡過的床或坐過的東西都不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","凡碰到他睡過的床的人都不潔淨，必須洗衣、沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","凡坐他坐過之物的人都不潔淨，必須洗衣、沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","凡碰到他的人都不潔淨，必須洗衣、沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","如果他吐唾沫在一個潔淨的人身上，那人便不潔淨，必須洗衣、沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","他騎過的鞍子是不潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","凡碰到他坐過之物的人都不潔淨，要等到傍晚才能潔淨。碰到這些東西的人都不潔淨，必須洗衣、沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","如果他沒有洗手就碰到別人，那人便不潔淨，必須洗衣、沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","必須打碎他摸過的陶器，用水清洗他摸過的木器。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","他病癒後，必須經過七天的潔淨期，要洗淨衣服，用清水沐浴，這樣就潔淨了。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","第八天，他要把兩隻斑鳩或雛鴿帶到會幕門前，在耶和華面前交給祭司獻祭， ");
INSERT INTO cmncbt_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","一隻作贖罪祭，一隻作燔祭。這樣，祭司便在耶和華面前為他的漏症贖了罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","「男人若遺精，便不潔淨，必須沐浴全身，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","沾了精液的衣物或皮革都不潔淨，必須用水清洗，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","如果男女同房，二人都不潔淨，必須沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","「女人在月經期間，要不潔淨七天。凡碰到她的人都不潔淨，要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","月經期間，她躺過或坐過的東西都不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","凡碰過她床的人都不潔淨，必須洗衣、沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","人若碰到她坐過的地方，也不潔淨，必須洗衣、沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","不論是她的床，還是她坐的東西，碰到的人都不潔淨，要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","男人若與她同房，沾染了她的經血，就要不潔淨七天，他躺過的床也不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","「女人若在經期以外多日血漏或經期過長，在此期間便不潔淨，像在經期內一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","在血漏期間，她躺的床或坐的東西都不潔淨，像在經期內一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","凡碰到這些東西的人都不潔淨，必須洗衣、沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","血漏停止後，她要等七天才潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","第八天，她要把兩隻斑鳩或雛鴿帶到會幕門口，交給祭司獻祭， ");
INSERT INTO cmncbt_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","一隻作贖罪祭，一隻作燔祭。這樣，祭司便在耶和華面前為她贖了血漏的不潔之罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","你們要使以色列人遠離不潔之物，免得他們因不潔而玷污我設在他們中間的聖幕，以致死亡。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","以上條例是為患漏症的人，包括遺精、 ");
INSERT INTO cmncbt_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","行經的女人、患漏症的男女、與不潔淨女人同房的男人所設立的條例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","亞倫的兩個兒子死在耶和華面前以後， ");
INSERT INTO cmncbt_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","耶和華對摩西說：「告訴你哥哥亞倫，他不可隨意進入幔子裡面的至聖所，到約櫃上的施恩座前，免得死亡，因為我要在施恩座之上的雲彩中顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","亞倫進入聖所時，要帶一頭作贖罪祭的公牛犢和一隻作燔祭的公綿羊。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","他要穿上聖潔的細麻內袍和細麻褲子，束上細麻腰帶，戴上細麻禮冠。這些是聖潔的衣物，他必須沐浴後才可穿戴。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","他要從以色列會眾那裡取兩隻公山羊作贖罪祭，一隻公綿羊作燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","亞倫要先獻上那頭公牛犢作贖罪祭，為自己和全家贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","然後，他要把兩隻公山羊帶到會幕門口，放在耶和華面前。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","他要為這兩隻羊抽籤，決定哪隻歸耶和華，哪隻歸阿撒瀉勒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","亞倫要獻上那隻歸耶和華的公山羊作贖罪祭， ");
INSERT INTO cmncbt_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","要將那隻歸阿撒瀉勒的公山羊活著獻給耶和華，用來贖罪，然後把牠放到曠野歸阿撒瀉勒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","「亞倫要把那頭為他作贖罪祭的公牛犢牽來宰殺，為自己和全家贖罪， ");
INSERT INTO cmncbt_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","然後拿一個香爐，盛滿從耶和華面前的祭壇上取的火炭，再拿兩把磨細的香帶進幔子裡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","他要在耶和華面前燒香，使香的煙籠罩約櫃上的施恩座，免得他死亡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","他要取一些公牛的血，用手指彈灑在施恩座的東面，並在施恩座前用手指彈灑七次。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","然後，亞倫要出去宰殺那隻為民眾作贖罪祭的公山羊，把羊血帶進幔子裡，像灑公牛的血一樣灑在施恩座的上面和前面。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","因以色列人的污穢、叛逆和罪惡，他要這樣為至聖所贖罪。他也要同樣為會幕贖罪，因為會幕座落在以色列人中間，處在他們的污穢中。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","從他進入聖所為自己、家人和以色列全體會眾贖罪開始，直到他贖完罪出來為止，任何人都不可待在會幕裡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","之後，他要來到耶和華面前的祭壇那裡，為祭壇贖罪。他要取一些牛血和羊血，抹在祭壇凸起的四角上， ");
INSERT INTO cmncbt_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","然後用手指向祭壇灑血七次，除掉以色列人的污穢，使祭壇聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","「他為至聖所、會幕和祭壇贖罪後，要牽來那隻活山羊， ");
INSERT INTO cmncbt_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","把雙手放在羊頭上，承認以色列人的所有過犯、叛逆和罪惡，將這一切罪歸到公山羊的頭上，然後派人把牠送到曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","這隻羊要把他們一切的罪過帶到偏遠的地方，那人要把羊留在曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","「亞倫要走進會幕，脫下他進至聖所時穿的細麻衣服，放在會幕裡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","他要在聖潔之處沐浴，穿上平時的衣服出去為自己和民眾獻燔祭，為自己和民眾贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","他要將贖罪祭牲的脂肪焚燒在祭壇上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","把羊送交阿撒瀉勒的人要洗衣、沐浴，然後才可回到營裡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","作贖罪祭的公牛和公山羊的血被帶進聖所用來贖罪後，要把公牛和公山羊帶到營外，用火焚燒牠們的皮、肉和糞。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","負責焚燒的人要洗衣、沐浴，然後才可回到營裡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","「每年七月十日，不論是你們，還是寄居在你們中間的外族人，都要禁食，停止所有工作。這是你們永遠當守的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","因為在這一天要為你們贖罪，使你們在耶和華面前潔淨，脫離一切的罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","這天是你們完全休息的安息日，你們要禁食。這是一條永遠不變的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","那受膏、接替父親擔任聖職的大祭司要行贖罪禮。他要穿上聖潔的細麻衣， ");
INSERT INTO cmncbt_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","為至聖所、會幕和祭壇贖罪，也要為祭司和全體會眾贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","這是你們當守的永久律例：每年一次為以色列人贖罪。」 於是，摩西遵行了耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","「你要告訴亞倫父子們及全體以色列人，以下是耶和華的吩咐： ");
INSERT INTO cmncbt_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","任何在營內或營外宰殺公牛、綿羊或山羊的以色列人， ");
INSERT INTO cmncbt_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","若沒有把牲畜帶到會幕門口，在耶和華的聖幕前獻給耶和華，便是犯了流血之罪，要將他從民中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","這是為了讓以色列人把祭牲帶到會幕門口交給祭司，獻給耶和華作平安祭，而非在野外殺祭牲獻祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","祭司要將祭牲的血灑在會幕門口耶和華的祭壇上，把脂肪焚燒獻給耶和華作馨香之祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","他們不可再獻祭物給山羊神，與其苟合。這是他們世代當守的永久律例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","「你要告訴他們：不論是以色列人，還是寄居在以色列人中間的外族人，獻燔祭或其他祭物時， ");
INSERT INTO cmncbt_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","如果沒把祭物帶到會幕門口獻給耶和華，要將他從民中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","「任何以色列人或寄居在以色列人中間的外族人若吃血，耶和華必嚴懲，把他從民中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","因為肉體的生命在血中，耶和華把血賜給你們，使你們可以用血在祭壇上為自己贖罪。血可以為人的生命贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","所以耶和華吩咐以色列人和寄居在以色列人中間的外族人不可吃血。 ");
INSERT INTO cmncbt_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","以色列人或寄居在以色列人中間的外族人如果捕到可吃的鳥或獸，必須放盡牠的血，用土掩埋， ");
INSERT INTO cmncbt_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","因為所有動物的生命都在血中。因此，耶和華吩咐以色列人不可吃任何動物的血，因為血就是生命。凡吃血的都要被剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","不論以色列人還是外族人，若吃了自然死亡或被野獸撕裂的動物，就不潔淨。他必須洗衣、沐浴，等到傍晚才能潔淨， ");
INSERT INTO cmncbt_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","否則他要承擔罪責。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","「你要告訴以色列人：我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","你們曾經住在埃及，但不可效法埃及人的行為。我要把你們帶到迦南，但你們不可效法迦南人的行為，不可隨從他們的風俗。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","你們必須遵行我的典章，持守我的律例。我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","你們要遵守我的典章和律例，遵行的人必因此而活。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","「你們任何人不可與近親亂倫。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","不可與你母親亂倫而羞辱你父親。她是你的母親，不可與她亂倫。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","不可與你父親的妻妾亂倫，那會羞辱你的父親。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","不可與你的姊妹亂倫。不論是同父異母的，還是同母異父的，生長在同一家庭的，還是不同家庭的，都不可與她亂倫。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","不可與孫女或外孫女亂倫，那會自取羞辱。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","不可與你父親妻妾的女兒亂倫。她是你的姊妹，不可與她亂倫。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","不可與姑母亂倫，她是你父親的至親。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","不可與姨母亂倫，她是你母親的至親。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","不可與伯母或嬸母亂倫而羞辱你伯父或叔父，她是你的伯母或嬸母。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","不可與兒媳亂倫。她是你兒子的妻子，不可與她亂倫。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","不可與兄嫂或弟媳亂倫，她是你兄弟的妻子，那會羞辱你的兄弟。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","「不可與一個女人性交，又與她女兒性交，也不可與她孫女或外孫女性交。她們是她的近親。這都是邪惡行為。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","妻子還在世時，不可娶她姊妹並與她性交，使她們彼此作對。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","女人在月經期間不潔淨，不可與她性交。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","不可與鄰居的妻子性交，那會玷污自己。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","不可把兒女當作祭物獻給假神摩洛，不可褻瀆你上帝的名。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","男人不可與男人同寢，像和女人同寢一樣，這是可憎的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","不可與獸類交合，玷污自己。女人也不可與獸類交合。這是變態行為。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","「你們不可做這些事玷污自己，因為我要在你們面前趕走的各國，正是因為這些行為而玷污了自己。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","他們居住的土地也都被玷污了，所以我因他們的罪惡而懲罰那片土地，我要使那片土地吐出其中的居民。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","你們必須遵守我的律例和典章。不論你們還是寄居在你們中間的外族人，都不可做這些可憎之事。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","因為在你們之前居住在那裡的人做了這些可憎之事，玷污了那片土地。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","如果你們玷污了那片土地，它也會像吐出從前的居民一樣把你們吐出去。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","凡做這些可憎之事的，要將他從民中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","你們要遵守我的命令，不要效法那片土地上居民的惡俗，以致玷污自己。我是你們的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","「你要告訴以色列全體會眾，『你們要聖潔，因為我——你們的上帝耶和華是聖潔的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","你們每個人都必須孝敬父母，遵守我的安息日。我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","不要祭拜虛無的神明，也不要為自己鑄造神像。我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","你們獻平安祭給我時，要使你們所獻的蒙悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","要在獻祭當天或第二天吃完祭物。如果第三天還有剩餘，都要燒掉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","如果有人第三天還吃那些祭物，祭物就不潔淨，我不會悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","那人要自擔罪責，因為他褻瀆了我的聖物。要將他從民中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","「『你們收割的時候，不要割淨田角地邊的莊稼，也不要撿那些掉在田裡的穗子。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","不要摘淨葡萄園裡的葡萄，也不要撿掉在地上的葡萄。要把這些留給窮人和寄居在你們中間的外族人。我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","不可偷盜，不可撒謊，不可互相欺騙。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","不可奉我的名起假誓，從而褻瀆你們上帝的名。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","不可欺壓鄰居，也不可搶奪他的東西。要當天支付雇工的工錢，不可拖到第二天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","不可咒罵耳聾的，也不可把絆腳石放在盲人面前，應當敬畏你們的上帝。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","不可徇私枉法，不可偏袒窮人，不可諂媚權貴之人，要秉公審判。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","不可到處搬弄是非，不可危害鄰居的生命安全。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","對同胞不可心中懷恨。同胞有錯，要當面指正，免得自己因他而擔罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","不可報復，不可埋怨同胞，要愛鄰如己。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","「『你們要遵守我的律例。不可讓牲畜雜交；不可在同一塊田播撒兩種不同的種子；不可穿兩種材料織成的衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","「『一個已經許配人的婢女尚未被贖或未獲自由時，如果有人與她同寢，就要受到處罰，但不可處死他們，因為那婢女還未獲自由。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","和她同寢的人要把一隻公綿羊牽到會幕門口，作為贖過祭獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","祭司要用作贖過祭的公綿羊在耶和華面前為那人贖罪，他犯的罪便得到赦免。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","「『你們到了迦南，在那裡栽種各樣果樹後，前三年不可吃樹上的果子，要視它們是不潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","第四年，樹上的所有果子都是聖潔的，要獻給耶和華作頌讚之祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","第五年，你們可以吃樹上的果子。你們這樣做，果樹會為你們結出更多果子。我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","「『不可吃帶血的肉，不可占卜或行巫術。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","不可修剪鬢角或鬍鬚。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","不可因哀悼死人而割傷身體，也不可紋身。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","不可辱沒自己的女兒，使她淪為娼妓，免得你們居住的地方充滿淫亂和邪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","要遵守我的安息日，敬畏我的聖所。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","不可求問靈媒或巫師，玷污自己。我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","「『在年長者面前，要恭敬站立，要敬重年長者。要敬畏你們的上帝。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","不可欺負住在你們境內的外族人， ");
INSERT INTO cmncbt_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","要視他們如同胞，愛他們如愛自己，因為你們也曾經寄居埃及。我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","在稱重和度量時，不可欺詐。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","要使用準確的秤、尺子和升斗。我是你們的上帝耶和華，曾帶領你們離開埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","你們要遵行我的一切律例和典章。我是耶和華。』」 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","「你要告訴以色列人：在你們或寄居在你們中間的外族人中，如果有人把子女獻給假神摩洛，必須處死他，當地的人要用石頭打死他。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","我也必嚴懲那人，將他從民中剷除。因為他把子女獻給摩洛，玷污我的聖所，褻瀆我的聖名。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","如果那地方的人對此置之不理，沒有處死那人， ");
INSERT INTO cmncbt_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","我必嚴懲那人及其家人，從民中剷除他和那些追隨他與摩洛苟合的人。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","如果有人求問靈媒或巫師，與他們苟合，我必嚴懲，將他從民中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","你們要分別出來，做聖潔的人，因為我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","你們要遵行我的律例。我是使你們聖潔的耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","「咒罵父母的，必被處死。他咒罵父母，罪有應得。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","如果有人與別人的妻子通姦，姦夫淫婦必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","如果有人與父親的妻妾同寢，就是羞辱他的父親。要把二人處死，他們罪有應得。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","如果有人與兒媳同寢，二人都必須被處死。他們亂倫，罪有應得。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","如果男人與男人同寢，好像男人與女人同寢一樣，他們的行為可憎，必須被處死。他們罪有應得。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","如果有人娶妻，又娶岳母，便是大惡。要把他們三人燒死，使你們杜絕這種敗壞之事。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","如果有男人與獸類交合，他和獸都要被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","如果有女人與獸類交合，女人和獸都要被處死。他們必須被處死，他們罪有應得。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","「如果有人娶了同父異母或同母異父的姊妹，這是可恥之事，必須公開剷除他們。他與自己的姊妹亂倫，羞辱了她，要承擔自己的罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","如果有人與經期的女人同寢，他就暴露了女人的血泉，女人也自露血泉。要將他們二人從民中剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","不可與姨母或姑母亂倫，因為這是羞辱自己的親人。二人要承擔自己的罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","如果有人與伯母或嬸母同寢，就是羞辱他的伯父或叔父。二人要承擔自己的罪，必無子女而死。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","如果有人娶兄嫂或弟媳，這是污穢行為，羞辱了自己的兄弟。二人必無兒無女。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","「你們要遵行我的一切律例和典章，免得我要帶你們去居住的那片土地把你們吐出去。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","我要在你們面前趕走那片土地上的各族，你們不要隨從他們的習俗。他們做了以上那些事，所以我厭惡他們。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","我曾說你們必佔據他們的土地，我要把那片奶蜜之鄉賜給你們作產業。我是你們的上帝耶和華，我已經把你們從萬族中分別出來。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","所以，你們要區分潔淨和不潔淨的獸類與鳥類。不可吃那些我視為不潔淨的飛禽、走獸和爬蟲，以免玷污自己。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","你們要聖潔，因為我耶和華是聖潔的。我把你們從萬族中分別出來，使你們做我的子民。 ");
INSERT INTO cmncbt_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","如果有人做靈媒或巫師，不論男女，都必須被處死。你們要用石頭打死他們，他們罪有應得。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","耶和華對摩西說：「你要告訴做祭司的亞倫子孫：祭司不可因接觸死去的族人而使自己不潔淨， ");
INSERT INTO cmncbt_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","但骨肉至親，如父母、兒女、兄弟， ");
INSERT INTO cmncbt_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","以及未出嫁仍是處女的姊妹例外。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","祭司不可因姻親的關係而玷污自己。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","祭司不可剃光頭、修剪鬍鬚或割傷身體。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","他們要做上帝的聖潔之民，不可褻瀆我的名。因為他們負責獻我的火祭，即我的食物，所以要保持聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","他們不可娶妓女或被休的女人為妻，因為祭司要向上帝保持聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","要視祭司為聖潔的，因為他們負責獻你們上帝的食物。要視他們為聖潔的，因為使你們聖潔的我耶和華是聖潔的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","如果有祭司的女兒做妓女，辱沒自己，她就是辱沒自己的父親，必須燒死她。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","「大祭司在眾祭司中職分最高，頭上澆過膏油，已經承受聖職、穿上聖衣，他不可披頭散髮、撕裂衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","他不可接近死者，即使是父母也不可，以免玷污自己。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","他不可走出他上帝的聖所，以免褻瀆聖所，因為我的膏油已經使他聖潔。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","他必須娶處女為妻， ");
INSERT INTO cmncbt_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","不可娶寡婦、被休的女人或被玷污的妓女，只可娶本族中的處女為妻， ");
INSERT INTO cmncbt_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","以免在民中玷污自己的子孫，因為我是使他們聖潔的耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","「你告訴亞倫：你世世代代的子孫中，任何有殘疾的人都不可前來向他的上帝獻食物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","任何殘疾的人，如瞎眼的、瘸腿的、五官不正的、畸形的、 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","四肢傷殘的、 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","駝背的、侏儒、患眼疾的、長疥癬的或睪丸受損的，都不可近前來獻祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","亞倫祭司的子孫中有殘疾的都不可向耶和華獻火祭。他們既然有殘疾，就不可近前來獻耶和華的食物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","他們可以吃上帝的食物，聖的和至聖的都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","但他們不可走近幔子或祭壇，因為他們有殘疾。這樣做是為了避免他們褻瀆我的聖所。我是使聖所聖潔的耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","摩西把這些條例告訴了亞倫父子們和所有的以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","「你告訴亞倫父子們要謹慎處理以色列人獻給我的聖物，免得褻瀆我的聖名。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","「你告訴他們：你們世世代代的子孫中，如果有人不潔淨，卻接近以色列人分別出來獻給我的聖物，必須把他從我面前剷除。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","亞倫的子孫中若有人患了痲瘋病或漏症，在他潔淨之前，不可吃聖物。如果有人遺精，或碰到因接觸屍體而不潔淨之物， ");
INSERT INTO cmncbt_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","或碰到不潔淨的爬蟲，或碰到任何使他不潔淨的爬蟲或人， ");
INSERT INTO cmncbt_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","這人就不潔淨，要到傍晚之後才能潔淨。他要沐浴後才可吃聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","日落之後，他就潔淨了，可以吃聖物，因為那是他應得的食物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","他不可吃自然死亡或被野獸撕裂的動物，免得因此而不潔淨。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","他們要遵守我的命令，免得他們犯罪，因褻瀆我的命令而死亡。我是使他們聖潔的耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","「祭司家以外的人不可吃聖物，在祭司家中寄居的或做雇工的都不可吃， ");
INSERT INTO cmncbt_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","但出生在祭司家裡或祭司用錢買來的奴隸都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","如果祭司的女兒嫁給本族以外的人，她便不可再吃聖潔的舉祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","如果祭司的女兒守寡或被休，無兒無女，又像年輕時回到父親家居住，便可以吃父親的食物。除此以外，不屬於祭司家的人都不可吃。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","任何人如果誤吃聖物，就要如數償還給祭司，並加賠五分之一。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","祭司不可褻瀆以色列民眾獻給耶和華的聖物， ");
INSERT INTO cmncbt_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","以免因擅自吃聖物而擔罪、受罰。我是使他們聖潔的耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","「你要告訴亞倫父子們及所有以色列人：任何以色列人或寄居在以色列的外族人，若向耶和華獻燔祭，無論是為了還願還是出於自願， ");
INSERT INTO cmncbt_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","都必須獻毫無殘疾的公牛、公綿羊或公山羊才能蒙悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","不可獻有殘疾的，因為不蒙悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","如果有人為了還願或自願獻牛羊作平安祭給耶和華，必須獻毫無殘疾的牛羊才能蒙悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","不可獻給耶和華瞎眼的、傷殘的、斷肢的、長疥癬的牲畜，也不可把這些牲畜獻給耶和華作火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","至於畸形或發育不全的公牛或綿羊羔，可以用作自願獻的祭，但用作還願祭將不蒙悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","不可獻給耶和華睪丸受損、被壓碎、破裂或被閹割的牲畜。在你們境內不可做這樣的事， ");
INSERT INTO cmncbt_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","也不可從外族人手中接受這類牲畜，來獻給你們的上帝作食物。因為這些牲畜是畸形的、殘疾的，不蒙悅納。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","「剛出生的牛、綿羊或山羊，前七天要與母親在一起。從第八天起，把牠們獻給我作火祭必蒙悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","不可在同一天內宰殺母牛和小牛或母羊和小羊。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","你們獻感恩祭給耶和華時，要使你們所獻的蒙悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","要當天吃完祭物，不可留到早晨。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","你們要遵行我的一切誡命。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","不可褻瀆我的聖名，我要在以色列人中被尊為聖，我是使你們聖潔的耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","我領你們離開埃及，是要做你們的上帝。我是耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","「你要告訴以色列人，以下是耶和華所定的節期，你們要宣佈這些節期為舉行聖會的日子。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","「你們一週可以工作六天，但第七天是完全休息的安息日，你們要舉行聖會。不可做任何工，無論你們住在哪裡，都要守耶和華的安息日。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","「以下是耶和華所定的節期，你們要在這些日子召開聖會。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","「從一月十四日傍晚開始是耶和華的逾越節。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","從一月十五日開始是耶和華的除酵節，你們要連續七天吃無酵餅。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","在除酵節的第一天，你們要舉行聖會，不可做日常工作。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","一連七天你們要獻火祭給耶和華。第七天，你們要舉行聖會，不可做日常工作。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","「你把以下條例告訴以色列人。 「你們進入耶和華將要賜給你們的那片土地以後，每逢收割莊稼之時，你們要帶一捆初熟的穀物交給祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","祭司要在安息日後第一天把那捆穀物在耶和華面前搖一搖，你們所獻的就會得到悅納。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","在獻穀物那天，你們要獻給耶和華一隻毫無殘疾、一歲的公羊羔作燔祭， ");
INSERT INTO cmncbt_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","同時要把兩公斤調油的細麵粉作素祭，一起獻給耶和華作馨香的火祭，也要獻一升酒作奠祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","你們必須先將這些供物獻給你們的上帝後，才可以吃餅、烘烤的穀物和新鮮穗子。不論住在哪裡，這是你們世代當守的永久律例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","「從安息日後第一天，即你們獻上搖祭的那天算起，你們要數整整七週， ");
INSERT INTO cmncbt_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","一直數到第七個安息日後的第一天，共五十天。到那天，你們要把新收的穀物作為素祭獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","你們要用兩公斤細麵粉加上酵，烤成兩個餅作搖祭，從你們居住的地方帶來獻給耶和華作初熟之祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","你們要把七隻毫無殘疾的一歲公羊羔、一頭公牛犢、兩隻公綿羊和那兩個餅，一起獻給耶和華作燔祭。這些一起獻上的燔祭、素祭和奠祭，是蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","你們也要獻一隻公山羊作贖罪祭，兩隻一歲的公綿羊作平安祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","祭司要把這兩隻公綿羊和初熟之物做的餅作為搖祭，在耶和華面前搖一搖。這些是獻給耶和華的聖物，歸祭司所有。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","你們要在那天召開聖會，不可做日常工作。不論住在哪裡，這是你們世代當守的永久律例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","你們收割時，不可割盡田角地邊的莊稼，也不可撿落在地裡的，要把這些留給窮人和外族人。我是你們的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","「你告訴以色列人：你們要在七月一日完全休息，要吹號作紀念，召開聖會。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","你們不可做日常工作，要獻火祭給耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","「七月十日是贖罪日，你們要舉行聖會，禁食，獻火祭給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","那是在你們的上帝耶和華面前為自己贖罪的日子，你們不可工作。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","那天，凡不禁食的，要將他從民中剷除； ");
INSERT INTO cmncbt_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","凡在那天工作的，耶和華要毀滅他。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","你們不可做任何工作。不論住在哪裡，這是你們世代當守的永久律例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","那是你們完全休息的安息日。從七月九日傍晚至次日傍晚，你們必須禁食。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","「你把以下條例告訴以色列人。 「從七月十五日開始，你們要一連七天向耶和華守住棚節。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","第一天，你們要舉行聖會，不可做日常工作。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","一連七天你們要獻火祭給耶和華。第八天要舉行聖會，獻火祭給耶和華。這是莊嚴的聚會，你們不可做日常工作。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","「以上是耶和華所定的節期。在這些節期裡，你們要召開聖會，按規定的日子獻給耶和華燔祭、素祭、奠祭和其他祭物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","除了守安息日並向耶和華獻供物、還願祭和自願獻的祭以外，你們還要守這些節期。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","「你們收割完後，從七月十五日起，要一連七天慶祝耶和華的節期，第一天和第八天是完全休息的安息日。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","第一天，你們要摘下樹上結的上好果子，折下棕樹枝、葉子濃密的樹枝與河邊的柳枝，在你們的上帝耶和華面前歡慶七天。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","在每年七月的這七天，你們要向耶和華守這節期。這是你們世代當守的永久律例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","你們要搭棚居住七天，所有以色列人都要住在棚裡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","這樣，你們的後代就會知道，我帶領以色列人離開埃及後，曾讓他們住在棚裡。我是你們的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","於是，摩西向以色列人宣佈了耶和華所定的這些節期。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","「你要吩咐以色列人把榨的純橄欖油給你拿來點燈，使燈常明。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","亞倫要負責照看會幕內遮掩約櫃的幔子外的燈，使燈從晚上到早晨一直在耶和華面前亮著。這是你們世代當守的永久律例。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","亞倫要在耶和華面前常常照看這些放在純金燈臺上的燈。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","「你要用細麵粉烤十二個餅，每個餅用兩公斤細麵粉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","你要把餅擺成兩行，放在耶和華面前的純金桌子上，每行六個， ");
INSERT INTO cmncbt_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","每行餅上放一些純乳香，象徵這些餅是獻給耶和華的火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","每逢安息日，要定期把餅擺在耶和華面前。這是以色列人要永遠遵守的約。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","這些餅要歸亞倫及其子孫。他們要在聖潔之處吃，因為在獻給耶和華的火祭中，這是至聖之物，要永遠歸祭司所有。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","有一個人，母親是以色列人，父親是埃及人，他在營中與一個以色列人打起架來。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","他說咒詛的話，褻瀆了上帝的名，他們把他帶到摩西那裡。他母親叫示羅密，是但支派底伯利的女兒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","他們把他關押起來，等候耶和華的指示。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","「把那褻瀆聖名的人帶到營外，所有聽見的人都把手放在他頭上，然後全體會眾要用石頭打死他。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","你要告訴以色列人，誰咒詛上帝，誰就要承擔自己的罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","凡褻瀆耶和華聖名的，必須被處死，全體會眾要用石頭打死他。不論是外族人還是以色列人，凡褻瀆聖名的，都必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","凡殺人的，必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","打死別人牲畜的，必須賠償牲畜，以命還命。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","傷害鄰舍的，必須受同樣的傷害， ");
INSERT INTO cmncbt_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","要以傷還傷，以眼還眼，以牙還牙。他怎樣傷害別人，也要怎樣傷害他。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","打死別人牲畜的，必須賠償牲畜；殺人的，必須償命。 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","不論是以色列人還是外族人，都要遵守這些律法。我是你們的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","於是，摩西把這些話告訴以色列人，他們就按照耶和華對摩西的吩咐，把那褻瀆聖名的人帶到營外，用石頭打死了。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","耶和華在西奈山上對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","「你要告訴以色列人：你們到了我將要賜給你們的土地後，要讓土地在耶和華面前守安息。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","六年之內，你們可以耕種田地，修整葡萄園，收穫出產。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","但第七年是要向耶和華守的安息年，土地要完全休息。你們不可耕種，不可修整葡萄園。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","不可收割自生自長的莊稼，也不可摘未經修剪而結的葡萄。這一年土地要完全休耕。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","但安息年間土地裡自生自長的，你們和你們的僕婢、雇工與住在你們中間的外族人都可以吃， ");
INSERT INTO cmncbt_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","你們的牲畜和境內的野獸也可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","「你們要計算七個安息年，即七個七年，共四十九年。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","第五十年的七月十日贖罪日那天，你們要在境內各地吹號。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","你們要以這一年為聖年，向境內所有居民宣告自由。這一年將成為你們的禧年。你們要各歸祖業，各回本家。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","第五十年是你們的禧年。這一年你們不可耕種，不可收割自生自長的莊稼，也不可摘未經修剪而結的葡萄。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","這是禧年，是你們的聖年，你們可以吃土地裡自生自長的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","在禧年，各人要回到祖業。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","因此，你們和同胞買賣田地時，不可彼此虧負。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","買賣雙方要按照距下個禧年的年數和收成的年數定價。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","距下個禧年的年數多，價錢就高；年數少，價錢就低。因為賣的是田地收成的次數。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","要敬畏你們的上帝，不可彼此虧負。我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","你們要遵行我的律例，持守我的典章，就可以在那片土地上安居。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","土地會出產豐富，使你們豐衣足食、安然居住。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","你們可能會問，『第七年不種不收，我們吃什麼？』 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","我要在第六年賜福給你們，使田地的出產夠你們吃三年。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","第八年開始耕種時，你們仍會吃陳糧，一直吃到第九年的收割季節。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","「你們不可永遠賣掉土地，因為土地是我的，你們只不過是寄居在那片土地上的過客。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","你們購買每一塊土地時，都必須讓原主保留贖回的權利。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","如果有人因貧窮而賣掉土地，他的近親要把賣掉的土地贖回來。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","如果無人為他贖回，而他自己漸漸富裕起來，有能力贖回， ");
INSERT INTO cmncbt_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","他要計算賣掉土地的年數，退還距下個禧年所剩年數的地價，便可以贖回自己的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","如果他沒有能力贖回，所賣的土地在禧年之前要屬於買主。到了禧年，買主必須把土地歸還原主。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","「如果有人賣掉自己城裡的房子，要保留一年贖回權。賣掉房子的一年之內，他可以贖回。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","如果一年之內他沒有贖回，房子便永遠歸買主所有，就是到了禧年也不用歸還。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","如果房子在四圍無牆的鄉村，要視房子為鄉下的土地，原主可以贖回；到了禧年，買主必須將房子歸還。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","在利未人的城邑裡，利未人永遠有權贖回所賣的房子。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","如果他們沒有贖回，到了禧年要把房子歸還他們，因為在利未人的城裡，利未人的房屋是他們在以色列人中所擁有的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","但不可出賣利未人城郊的草場，那是他們永遠擁有的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","「如果你們的同胞生活日益貧窮，難以維生，你們要像照顧外族人和寄居者一樣照顧他的生活，讓他住在你們當中。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","不可向他放債取利，要敬畏你們的上帝，讓他住在你們當中。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","你們借錢給他，不可收取利息；借糧給他，不可謀利。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","我是你們的上帝耶和華。我曾經帶領你們離開埃及，為要把迦南賜給你們，並做你們的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","「如果你們的同胞窮得把自己賣給你們，不可把他當作奴隸， ");
INSERT INTO cmncbt_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","要待他像雇工和寄居者一樣。他要為你工作到禧年。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","到了禧年，他和孩子們便可以離開你們，回到自己的宗族和祖業。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","因為以色列人是我的僕人，是我從埃及帶出來的，所以他們不可賣身為奴。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","你們也不可苛待他們，要敬畏你們的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","你們可以從鄰國購買奴隸， ");
INSERT INTO cmncbt_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","也可以買居住或出生在你們境內的外族人。這些人可以作你們的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","你們可以將他們作為產業傳給你們的子孫，使他們終身做奴隸。但你們不可苛待自己的同胞。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","「如果你們中間的外族人漸漸富裕，你們同胞中卻有人日益貧窮，把自己賣給外族人或他們的族人， ");
INSERT INTO cmncbt_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","他可以保留贖身的權利。他的兄弟、 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","叔伯、堂兄弟或其他近親都可以贖回他。如果他富裕起來，也可以贖回自己。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","他要和買主計算從自己賣身為奴到下個禧年之間的年數，然後按雇工的工價，照年數計算贖價。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","如果離禧年還有很多年，他就要按年數和當初賣價的比例償還贖價。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","如果離禧年只有不多的幾年，他就要按年數償還贖身費。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","買主要待他如按年雇用的工人。你們要確保買主不會苛待他。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","如果禧年來臨前他沒有被贖回，到了禧年他和孩子們都要獲得自由。 ");
INSERT INTO cmncbt_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","因為以色列人是我的僕人，是我從埃及領出來的僕人。我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","「你們不可為自己製造偶像，不可豎立神像和神柱，也不可在你們境內安放祭拜用的石像。我是你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","你們要守我的安息日，敬畏我的聖所。我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","如果你們遵行我的律例，謹守我的誡命， ");
INSERT INTO cmncbt_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","我就按時降雨給你們，使土地長出莊稼、田間果樹結出果實。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","你們要打糧食打到摘葡萄的時候，摘葡萄摘到播種的時候。你們必豐衣足食，安然居住。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","「我要使你們境內太平，安枕無憂。我要除掉你們境內的猛獸，也要使你們免遭刀劍之災。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","你們將追趕仇敵，使他們倒在你們刀下。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","你們五人要追趕一百人，一百人要追趕一萬人，他們必死在你們刀下。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","我要眷顧你們，使你們生養眾多，人丁興旺，也要堅守與你們所立的約。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","你們存糧充足，甚至要搬出陳糧來儲存新糧。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","我要住在你們中間，我必不厭棄你們。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","我要走在你們中間。我要做你們的上帝，你們要做我的子民。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","我是你們的上帝耶和華。我曾帶領你們離開埃及，使你們不再做埃及人的奴隸。我打碎了你們身上的重軛，使你們昂首前行。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","「如果你們不聽從我，不遵行我的這一切誡命； ");
INSERT INTO cmncbt_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","如果你們棄絕我的律例，厭棄我的典章，不聽從我的命令，破壞我與你們所立的約， ");
INSERT INTO cmncbt_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","我要懲罰你們，使你們陷入恐慌、患癆病和熱症，使你們眼睛昏花、心力衰竭。你們撒種卻一無所獲，因為敵人要吃盡你們所種的。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","我要嚴懲你們，使你們敗在敵人手下；你們要被那些恨你們的人統治，即使沒有人追趕，你們也要逃命。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","「如果你們經歷這些後，仍然不聽從我，我要使你為罪多受七倍的懲罰。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","我要重挫你們的傲氣，使你們頭上的天如鐵，腳下的地如銅。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","你們勞作也是徒然，因為你們的土地必不長莊稼，果樹也不結果實。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","「如果你們仍然與我作對，不肯聽從我，我要用七倍的災難懲治你們的罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","我要讓野獸攻擊你們，殘害你們的子女，吞噬你們的牲畜，使你們人口銳減，道路荒涼。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","「如果你們還是不服管教，繼續與我作對， ");
INSERT INTO cmncbt_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","我也要與你們作對，用七倍的災難懲治你們的罪。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","因為你們毀約，我要用戰禍報應你們。你們躲進各城的時候，我要在你們中間降下瘟疫，使你們落在敵人手裡。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","我要斷絕你們的糧源。那時候，十個婦女將用一個烤爐烤餅，按定量分餅給你們，你們吃卻吃不飽。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","「如果你們仍然不肯聽從我，繼續與我作對， ");
INSERT INTO cmncbt_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","我也要與你們作對，向你們發烈怒，把比先前嚴厲七倍的懲罰加在你們身上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","你們要吃自己兒女的肉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","我要毀滅你們的邱壇，拆掉你們的香壇，把你們的屍體堆在你們的死偶像上。我必厭惡你們。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","我要使你們的城邑淪為廢墟，使你們的敬拜場所荒涼，也不再悅納你們的馨香之祭。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","我要使你們的土地荒廢，連佔據那裡的敵人也為此而震驚。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","我要把你們驅散到各國，還要拔刀追殺你們。你們的土地將荒廢，城邑將淪為廢墟。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","你們被擄到敵國的時候，你們的土地將荒廢，享受安息。那時土地必休息，享受安息。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","你們住在那裡的時候，沒有在安息年讓土地安息，因此土地在荒廢的日子裡將享受安息。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","「我要使你們當中的那些倖存者在敵國心驚膽戰，過著風聲鶴唳、惶恐不安的生活。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","即使無人追趕，他們也將倉皇逃命，互相絆倒，如同躲避刀劍一樣。你們必無力抵擋敵人。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","你們將葬身列國，死在敵人的土地上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","你們當中的倖存者將因自己的罪和祖先的罪而消亡在敵人的土地上。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","「如果他們承認自己和祖先的罪，就是背叛我、與我作對的惡行， ");
INSERT INTO cmncbt_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","以致我與他們作對，把他們流放到敵國；如果他們頑固的心謙卑下來，甘願為罪受罰， ");
INSERT INTO cmncbt_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","我便顧念我與亞伯拉罕、以撒和雅各所立的約，眷顧那片土地。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","土地被他們離棄，荒無人煙，得享安息。他們卻要因拒絕遵守我的典章、厭棄我的律例而飽受懲罰。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","然而，他們流落敵國的時候，我不會棄絕他們，不會因厭惡而毀滅他們，也不會違背我與他們所立的約。我是他們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","為了他們的緣故，我必顧念我與他們祖先所立的約。我曾在列國面前帶領他們的祖先離開埃及，為要做他們的上帝。我是耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","以上是耶和華藉摩西在西奈山上頒佈給以色列人的律例、典章和法度。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","「你要告訴以色列人：如果有人許下特別的願，以付身價的方式奉獻一個人給耶和華，就要為被奉獻者估定身價。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","以聖所的秤為準，要為二十至六十歲的男子估價十兩銀子， ");
INSERT INTO cmncbt_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","女子則估價七兩銀子； ");
INSERT INTO cmncbt_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","五至二十歲的男子估價四兩銀子，女子則估價二兩銀子； ");
INSERT INTO cmncbt_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","滿月至五歲的男子估價一兩銀子，女子則估價半兩多銀子； ");
INSERT INTO cmncbt_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","六十歲以上的男子估價三兩銀子，女子則估價二兩銀子。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","如果許願的人因貧窮而負擔不起，就要把他帶到祭司面前，祭司要按他的能力另行估價。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","「如果有人許願獻牲畜給耶和華作供物，所獻的牲畜就會成為聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","不可更換所獻的牲畜，不可以壞換好，也不可以好換壞。如果更換，兩頭牲畜都會成為聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","如果許願獻的是不潔淨的牲畜，即不能獻給耶和華作供物的牲畜，那人就要把牲畜帶到祭司面前， ");
INSERT INTO cmncbt_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","由祭司評定牠的好壞，祭司估價多少就是多少。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","那人如果有意贖回，必須支付祭司估定的價值，再加付五分之一。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","「如果有人把房子分別出來獻給耶和華，祭司就要評定房子的好壞，祭司估價多少就是多少。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","那人如果想贖回房子，必須支付祭司估定的價值，再加付五分之一，房子便仍歸他所有。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","「如果有人把自己繼承的部分土地分別出來獻給耶和華，祭司就要按照土地的播種量來估價，撒二百升大麥種子的土地值十兩銀子。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","如果有人在禧年奉獻土地，所估的價便是定價。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","如果是在禧年以後獻的，祭司要按照距下個禧年的年數來估價，估價要逐年減低。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","如果那人想贖回所獻的土地，要在估價的基礎上加付五分之一，土地便仍歸他所有。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","他如果沒有贖回土地，而是賣給別人，便再也不能贖回。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","到了禧年，那土地要像永遠獻給耶和華的土地一樣歸耶和華，成為祭司的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","「如果獻給耶和華的土地不是自己的產業，而是買來的， ");
INSERT INTO cmncbt_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","祭司就要按照距下個禧年的年數來估價。那人要當天付清地價，地價歸耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","到了禧年，他要把所獻的土地歸還給賣主，就是土地的原主。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","所有價銀的稱量要以聖所的秤為準，即二十季拉為一舍客勒。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","「潔淨牲畜的頭胎，無論是牛是羊，已經屬於耶和華，任何人不可再把牠獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","如果是不潔淨牲畜的頭胎，他可以在祭司的估價基礎上，加付五分之一把牠贖回；如果不贖回，就要按估價把牠賣掉。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","凡永遠獻上的，不論是人、牲畜或是田產，都不可賣掉，也不可贖回，因為這一切都是耶和華的至聖之物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","凡永遠獻上的人不可被贖回，必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","「土地的所有出產中，不論是穀物還是樹上的果實，十分之一屬於耶和華，是耶和華的聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","如果有人想從那十分之一中贖回一部分，他要加付估價的五分之一。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","至於牛羊，要讓牠們從牧人的杖下經過，每十隻的第十隻要歸耶和華作聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","不論是好是壞，不可挑揀，不可更換。如果更換，兩隻都要作聖物，不可贖回。」 ");
INSERT INTO cmncbt_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","以上是耶和華在西奈山上藉摩西向以色列人頒佈的誡命。");
INSERT INTO cmncbt_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","以色列人離開埃及後第二年的二月一日，耶和華在西奈曠野的會幕中對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","「你要按以色列人的宗族和家系統計全體會眾，登記所有男子的名字。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","你和亞倫要一隊一隊地統計以色列人中所有二十歲以上、有作戰能力的男子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","每一支派要有一個人來協助你們。他們都是各宗族的族長， ");
INSERT INTO cmncbt_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","名單如下： 「呂便支派示丟珥的兒子以利蘇、 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","西緬支派蘇利沙代的兒子示路蔑、 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","猶大支派亞米拿達的兒子拿順、 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","以薩迦支派蘇押的兒子拿坦業、 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","西布倫支派希倫的兒子以利押、 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","約瑟的後裔——以法蓮支派亞米忽的兒子以利沙瑪和瑪拿西支派比大蘇的兒子迦瑪列、 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","便雅憫支派基多尼的兒子亞比但、 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","但支派亞米沙代的兒子亞希以謝、 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","亞設支派俄蘭的兒子帕結、 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","迦得支派丟珥的兒子以利雅薩、 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","拿弗他利支派以南的兒子亞希拉。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","他們都是從會眾中選出來的，是各支派的首領，也是以色列的將領。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","摩西和亞倫帶著這些被點名的人， ");
INSERT INTO cmncbt_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","在二月一日招聚全體會眾，按照宗族和家系統計人口，一一登記所有二十歲以上的男子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","摩西照耶和華的吩咐在西奈曠野統計人口。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","以色列的長子呂便支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有四萬六千五百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","西緬支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有五萬九千三百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","迦得支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有四萬五千六百五十人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","猶大支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有七萬四千六百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","以薩迦支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有五萬四千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","西布倫支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有五萬七千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","約瑟的後裔中，以法蓮支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有四萬零五百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","瑪拿西支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有三萬二千二百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","便雅憫支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有三萬五千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","但支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有六萬二千七百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","亞設支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有四萬一千五百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","拿弗他利支派中，二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來，共有五萬三千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","以上就是摩西、亞倫和各代表自己族系的十二位以色列首領所統計的男子人數。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","這樣，以色列人中二十歲以上、有作戰能力的男子按宗族、家系和名字一一被登記下來， ");
INSERT INTO cmncbt_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","共有六十萬三千五百五十人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","然而，利未人沒有按祖先的支派列在其中， ");
INSERT INTO cmncbt_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","因為耶和華曾經對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","「你不可統計利未支派的人數，不可把他們的人數算在以色列人中。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","你要派利未人管理、搬運和照料放約櫃的聖幕及其所有器具和附屬物，他們要在聖幕四圍紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","在遷移的時候，利未人要負責拆卸和支搭聖幕。外人若近前來，必被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","以色列人要按照他們的隊伍各自紮營，各歸本旗。 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","但利未人要在安放約櫃的聖幕四周紮營，以免以色列人觸怒耶和華。利未人負責看守放約櫃的聖幕。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","以色列人就按耶和華對摩西的吩咐行了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","「以色列人要各歸本旗，按本族的旗號，在會幕四圍稍遠的地方安營。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","東邊，即日出的方向，是猶大營區及其旗號。猶大人的首領是亞米拿達的兒子拿順， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","他的隊伍有七萬四千六百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","在猶大支派旁邊安營的是以薩迦支派，以薩迦人的首領是蘇押的兒子拿坦業， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","他的隊伍有五萬四千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","然後是西布倫支派，西布倫人的首領是希倫的兒子以利押， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","他的隊伍有五萬七千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","猶大營區的隊伍共計十八萬六千四百人，他們是前隊。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","南邊是呂便營區及其旗號。呂便人的首領是示丟珥的兒子以利蘇， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","他的隊伍有四萬六千五百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","在呂便支派旁邊安營的是西緬支派，西緬人的首領是蘇利沙代的兒子示路蔑， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","他的隊伍有五萬九千三百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","然後是迦得支派，迦得人的首領是丟珥的兒子以利雅薩， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","他的隊伍有四萬五千六百五十人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","呂便營區的隊伍共計十五萬一千四百五十人，他們是第二隊。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","隨後是會幕和利未人的營區，在其他各營中間。他們各就各位，各歸本旗，照安營時的次序出發。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","西邊是以法蓮營區及其旗號。以法蓮人的首領是亞米忽的兒子以利沙瑪， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","他的隊伍有四萬零五百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","以法蓮支派旁邊是瑪拿西支派，瑪拿西人的首領是比大蘇的兒子迦瑪列， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","他的隊伍有三萬二千二百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","然後是便雅憫支派，便雅憫人的首領是基多尼的兒子亞比但， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","他的隊伍有三萬五千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","以法蓮營區的隊伍共計十萬八千一百人，他們是第三隊。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","北邊是但營區及其旗號。但人的首領是亞米沙代的兒子亞希以謝， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","他的隊伍有六萬二千七百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","在但支派旁邊安營的是亞設支派，亞設人的首領是俄蘭的兒子帕結， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","他的隊伍有四萬一千五百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","然後是拿弗他利支派，拿弗他利人的首領是以南的兒子亞希拉， ");
INSERT INTO cmncbt_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","他的隊伍有五萬三千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","但營區的隊伍共計十五萬七千六百人，他們是後隊。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","以上是照家係和隊伍統計的各營中的以色列人，共六十萬三千五百五十名。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","照耶和華對摩西的吩咐，利未人沒被統計在以色列人中。 ");
INSERT INTO cmncbt_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","於是，以色列人照耶和華對摩西的吩咐，各按自己的旗號安營，各按自己的宗族和家係啟行。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","以下是耶和華在西奈山與摩西說話期間亞倫和摩西的後代。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","亞倫的長子是拿答，其他兒子是亞比戶、以利亞撒和以他瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","亞倫的兒子都是受膏的祭司，由摩西授予他們聖職做祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","拿答和亞比戶在西奈曠野用凡火向耶和華獻祭時死在祂面前，沒有留下兒子，因而只剩下以利亞撒和以他瑪在父親亞倫身邊擔任祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","「你去叫利未支派來協助亞倫祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","他們要為亞倫和全體會眾在會幕司職，辦理聖幕的事務， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","也要負責看守會幕裡面的所有器具，為以色列人辦理聖幕的事務。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","你要把利未人交給亞倫父子們，因為他們是從以色列人中選出來單單協助亞倫的。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","你要指派亞倫父子們盡祭司的職分，外人若近前來，必被處死。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","耶和華又對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","「我從以色列人中揀選利未人代替以色列人所有的長子。利未人要屬於我， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","因為所有頭生的都屬於我。我殺死埃及人所有的長子和頭生的牲畜那天，已把以色列人所有的長子和頭生的牲畜都分別出來，使之聖潔，歸給我。我是耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","耶和華在西奈曠野對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","「你要按利未人的宗族和家系統計他們的人口，登記所有年齡在一個月以上的男性。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","於是，摩西照耶和華的吩咐統計利未人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","利未的兒子是革順、哥轄和米拉利。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","按照宗族，革順的兒子是立尼和示每。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","按照宗族，哥轄的兒子是暗蘭、以斯哈、希伯倫和烏薛。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","按照宗族，米拉利的兒子是抹利和姆示。他們按家系都屬於利未人的宗族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","革順宗族有立尼和示每兩個家族， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","其中年齡在一個月以上的男性共七千五百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","革順宗族要在聖幕後面，即西面安營， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","家族首領是拉伊勒的兒子以利雅薩。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","革順人負責看守會幕，即聖幕、聖幕的罩棚、頂蓋和門簾、 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","圍繞聖幕和祭壇的院子的帷幔、門簾、繩索及一切相關的物品。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","哥轄宗族有暗蘭家族、以斯哈家族、希伯崙家族和烏薛家族， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","其中年齡在一個月以上的男性共有八千六百人，他們負責看守聖所。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","哥轄宗族要在聖幕南面安營， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","家族首領是烏薛的兒子以利撒反。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","他們負責照管約櫃、桌子、燈臺、兩座壇、聖所內用的器具、幔子及一切物品。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","亞倫祭司的兒子以利亞撒是利未人的最高首領，負責監督那些照料聖所的人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","米拉利宗族有抹利和姆示兩個家族， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","其中年齡在一個月以上的男性共六千二百人， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","家族領袖是亞比亥的兒子蘇列。他們要在聖幕的北面安營。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","米拉利人負責照管聖幕的木板、橫閂、柱子、帶凹槽的底座、聖幕的一切器具和所有相關事務， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","還有院子四周的柱子及其帶凹槽的底座、橛子和繩索。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","摩西、亞倫和亞倫的兒子們要在聖幕東面、朝日出的方向安營，替以色列人在聖所司職。外人若近前來，必被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","摩西和亞倫照耶和華的吩咐，按宗族統計利未人，年齡在一個月以上的男性共兩萬二千人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","耶和華對摩西說：「你要統計以色列人中年齡在一個月以上的長子，登記他們的名字。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","我是耶和華，你要把利未人歸給我，代替以色列人所有的長子，也要把利未人的牲畜獻給我，代替以色列人所有頭生的牲畜。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","摩西就照耶和華的吩咐，統計了以色列人的所有長子， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","年齡在一個月以上的共兩萬二千二百七十三人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","耶和華又對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","「你要用利未人代替以色列人所有的長子，用利未人的牲畜代替以色列人所有頭生的牲畜。利未人是屬於我的，我是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","以色列人所有長子的人數比利未人總數多二百七十三人，這些多出來的人需要被贖回， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","每人一兩銀子，要以聖所的秤為準，即一舍客勒是二十季拉。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","要把多出來之人的贖銀交給亞倫父子們。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","摩西就收取了利未人所贖人數之外那些多出來之人的贖銀， ");
INSERT INTO cmncbt_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","以聖所的秤計算，共從以色列人的長子收取了二百七十三兩銀子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","他照耶和華的吩咐，將贖銀交給亞倫父子們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","「你要按宗族和家系統計利未人中哥轄子孫的人數， ");
INSERT INTO cmncbt_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","登記所有可在會幕司職的三十歲到五十歲的男子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","他們在會幕裡的職責是照料至聖之物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","「拔營出發的時候，亞倫父子們要進會幕解下聖所和至聖所之間的幔子，用它遮蓋約櫃， ");
INSERT INTO cmncbt_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","再在上面依次蓋上海狗皮和純藍色的布，然後穿上抬約櫃的橫槓。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","「要在擺放供餅的桌子上鋪一塊藍布，把盤、碟及獻酒用的杯和瓶擺在上面。桌上要有常供的餅。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","這些東西上面要蓋朱紅色的布，再蓋上海狗皮，然後穿上抬桌子的橫槓。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","「要用藍布把燈臺、燈盞、燈剪、燈盤和盛油的器皿全遮蓋起來， ");
INSERT INTO cmncbt_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","再在上面蓋上海狗皮，然後放在抬架上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","「金壇上面要蓋藍色布，再蓋上海狗皮，穿上抬金壇的橫槓。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","「聖所裡面供職用的一切器皿都要用藍色布包好，蓋上海狗皮，放在抬架上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","「要清除祭壇上的灰燼，鋪上紫色布， ");
INSERT INTO cmncbt_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","然後把供職用的火鼎、肉叉、鏟、碗等所有的祭壇器具都放在上面，再蓋上海狗皮，穿上抬祭壇的橫槓。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","「拔營出發時，要等到亞倫父子們把聖所和聖所的所有器具都蓋好後，哥轄的子孫才可以來抬。他們負責抬這些會幕的器具，但不可觸摸這些聖物，免得死亡。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","亞倫祭司的兒子以利亞撒負責管理整個聖幕，以及裡面的燈油、香料、日常獻的素祭、膏油及一切器具和物品。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","「不可讓哥轄宗族在利未人中滅絕。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","他們走近至聖之物以前，亞倫父子們要先進去指派他們做什麼、抬什麼，以免他們死亡。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","他們不可進去看聖物，一刻都不可，免得死亡。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","「你要按宗族和家系統計革順子孫的人數， ");
INSERT INTO cmncbt_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","登記所有可在會幕司職的三十歲到五十歲的男子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","以下是革順宗族負責的搬運工作及其他事務： ");
INSERT INTO cmncbt_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","「他們要抬聖幕的幔子、會幕、會幕頂蓋、頂蓋上的海狗皮、會幕門簾、 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","圍繞聖幕和祭壇的院子的帷幔、院門門簾、繩索及司職用的一切器具，還負責其他相關事務。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","你們要把抬的任務分配給革順的子孫，他們要遵照亞倫父子們的吩咐司職。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","這是革順宗族的人在會幕裡的職責，他們要按祭司亞倫的兒子以他瑪的吩咐司職。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","「你要按宗族和家系統計米拉利子孫的人數， ");
INSERT INTO cmncbt_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","登記所有可在會幕司職的三十歲到五十歲的男子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","他們在會幕裡負責抬聖幕的木板、橫閂、柱子、帶凹槽的底座， ");
INSERT INTO cmncbt_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","院子四周的柱子及其帶凹槽的底座、橛子、繩索和其他相關器具。你們要把當抬的物件一一指派給他們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","這是米拉利宗族的人在會幕的職責，由祭司亞倫的兒子以他瑪監督。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","於是，摩西、亞倫和會眾的首領按宗族和家系統計哥轄的子孫， ");
INSERT INTO cmncbt_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","登記了所有可在會幕司職的三十歲到五十歲的男子， ");
INSERT INTO cmncbt_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","共兩千七百五十人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","這是哥轄宗族在會幕司職的人數，是摩西和亞倫照耶和華的吩咐統計的。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","40","按宗族和家系統計，革順的子孫中三十歲到五十歲、可在會幕司職的共兩千六百三十人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","這是革順宗族在會幕司職的人數，是摩西和亞倫照耶和華的吩咐統計的。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","44","按宗族和家系統計，米拉利的子孫中三十歲到五十歲、可在會幕司職的共三千二百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","這是米拉利宗族的人數，是摩西和亞倫照耶和華的吩咐統計的。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","摩西、亞倫和以色列人的首領按宗族和家系統計了利未人的人數， ");
INSERT INTO cmncbt_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","48","三十歲到五十歲、可司職和搬運會幕器具的利未人，共八千五百八十人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","照耶和華對摩西的吩咐，每個人都被統計在內，都有指定的職責和當抬的器具。這樣，照耶和華對摩西的吩咐，人口統計完畢。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","「你吩咐以色列人把所有患痲瘋病、漏症和因碰過死屍而不潔淨的人， ");
INSERT INTO cmncbt_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","無論男女，都送到營外，免得他們玷污了營地，因為我住在其中。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","以色列人遵命而行，照耶和華對摩西的吩咐，把這些人送到營外。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","「你把以下條例告訴以色列人：無論男女，若虧負別人，以致失信於耶和華，就是犯罪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","那人必須認罪，賠償受害人全部損失，並加賠五分之一。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","如果受害人已死，又沒有可以接受賠償的近親，賠償就屬於耶和華，要歸祭司所有。那人還要再獻上一隻公綿羊為自己贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","以色列人帶來奉獻的一切聖物都要歸祭司所有。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","各人奉獻的聖物，無論是什麼，都要歸祭司所有。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","14","「你把以下條例告訴以色列人：若有人懷疑妻子出軌，暗中與人通姦，玷污了自己，卻沒有證人，也沒有當場抓住她，在無法確定是自己疑心還是妻子不貞的情況下， ");
INSERT INTO cmncbt_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","他要帶妻子到祭司那裡，同時為妻子帶去一公斤大麥麵粉作為供物。不可在上面澆油或加乳香，因為這是因疑心而獻上的素祭，是讓人回憶過犯的素祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","「祭司要把那婦人帶到耶和華面前， ");
INSERT INTO cmncbt_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","用陶器盛一些聖水，從聖幕的地上取一些塵土撒在水中， ");
INSERT INTO cmncbt_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","然後讓那婦人站在耶和華面前，解開她的頭髮，把回憶過犯的素祭，就是因疑心而獻的素祭放在她手裡。祭司要拿著帶給罪人咒詛的苦水， ");
INSERT INTO cmncbt_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","叫她發誓。祭司要對她說，『如果你沒有背著丈夫與人通姦，沒有因出軌而玷污自己，就不會被這苦水所害。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","如果你曾出軌，背著丈夫與人通姦，以致玷污自己， ");
INSERT INTO cmncbt_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","願耶和華使你大腿消瘦、肚腹腫脹，使你在同胞中成為咒詛。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","願這可帶來咒詛的苦水進入你體內，使你肚腹腫脹、大腿消瘦。』她要說，『阿們！阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","祭司要把這咒詛寫在書卷上，再放在苦水裡把字洗掉。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","祭司要讓婦人喝這可帶來咒詛的苦水，不忠的婦人喝下後，肚子會感到劇痛。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","祭司要從婦人手中接過她丈夫因疑心而獻的素祭，在耶和華面前搖一搖，然後帶到祭壇那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","他要從素祭中取出一把麵粉，作為象徵放在祭壇上焚燒，然後叫那婦人喝下苦水。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","如果她曾玷污自己，背叛了丈夫，這可帶來咒詛的苦水進入她體內後，會引起劇痛，使她肚腹腫脹、大腿消瘦，她將在同胞中成為咒詛。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","但如果她是貞潔的，沒有玷污自己，就不會受傷害，仍能生育。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","「這就是處理丈夫懷疑妻子不貞的條例。遇到妻子背著丈夫與人通姦， ");
INSERT INTO cmncbt_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","或是丈夫懷疑妻子不貞，就要讓妻子站在耶和華面前，由祭司對她執行這條例。 ");
INSERT INTO cmncbt_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","無論結果怎樣，丈夫都無罪，但妻子若有罪，必承擔罪責。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","「你把以下條例告訴以色列人：無論男女，如果許願做拿細耳人，把自己獻給耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","就要禁戒淡酒和烈酒、淡酒或烈酒做的醋、葡萄汁、葡萄和葡萄乾。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","在做拿細耳人期間，葡萄樹所結的，包括葡萄核和葡萄皮，都不可吃。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","在許願做拿細耳人期間，不可用剃刀剃頭，要任由頭髮生長，要保持聖潔，一直到獻給耶和華的日期滿了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","在獻給耶和華期間，不可挨近死屍， ");
INSERT INTO cmncbt_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","即使父母或是兄弟姊妹死了，也不可挨近，以免沾染不潔，因為他頭上有將自己奉獻給上帝的記號。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","在做拿細耳人期間，他是奉獻給耶和華的人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","如果有人在他身邊暴斃，使他的頭髮沾染不潔，他要在第七天潔淨的日子剃掉頭髮。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","第八天，他要帶兩隻斑鳩或雛鴿到會幕門口交給祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","祭司要獻一隻作贖罪祭，另一隻作燔祭，為他碰過死屍贖罪。他要在當日使頭聖潔， ");
INSERT INTO cmncbt_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","重新開始過奉獻給耶和華的日子，還要帶一隻一歲的公羊羔作贖過祭。他以前做拿細耳人的日子無效，因為他沾染了不潔之物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","「獻給耶和華的日子期滿後，拿細耳人要遵行以下條例。他要被帶到會幕門口， ");
INSERT INTO cmncbt_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","在那裡獻給耶和華一隻毫無殘疾、一歲的公羊羔作燔祭，一隻毫無殘疾、一歲母羊羔作贖罪祭，一隻毫無殘疾的公綿羊作平安祭， ");
INSERT INTO cmncbt_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","一籃調油的無酵細麵餅和塗油的無酵薄餅，以及素祭和奠祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","祭司要把這些祭物帶到耶和華面前，為他獻上贖罪祭和燔祭， ");
INSERT INTO cmncbt_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","然後把公綿羊和那籃無酵餅獻給耶和華作平安祭，再獻上素祭和奠祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","拿細耳人要在會幕門口剃掉作為奉獻記號的頭髮，把頭髮放在平安祭下面的火裡燒掉。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","拿細耳人剃頭以後，祭司要取出一條煮好的公綿羊前腿，再從籃中拿出一塊無酵餅和一塊無酵薄餅，放在拿細耳人手中。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","然後，祭司要把這些祭物作為搖祭，在耶和華面前搖一搖。這些祭物與作搖祭的胸肉和作舉祭的腿肉一樣，都是歸給祭司的聖物。此後，拿細耳人便可以喝酒。 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","「以上是許願獻供物給耶和華的拿細耳人當守的條例和當獻的祭物。但如果他額外許願獻上力所能及之物，就必須還所許的願。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","「你告訴亞倫父子們要這樣為以色列人祝福， ");
INSERT INTO cmncbt_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","『願耶和華賜福給你，保護你； ");
INSERT INTO cmncbt_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","願耶和華以祂的容光照耀你，施恩給你； ");
INSERT INTO cmncbt_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","願耶和華笑顏垂顧你，賜你平安。』 ");
INSERT INTO cmncbt_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","他們要奉我的名為以色列人祝福，我必賜福給他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","摩西支好聖幕後，便用膏油抹聖幕和其中的所有器具、祭壇和壇上的所有器具，使它們聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","然後，以色列各支派的首領，就是負責統計人口的各族長，都來奉獻。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","他們把供物帶到聖幕前獻給耶和華：每兩位首領奉獻一輛篷車，每位首領奉獻一頭公牛，共六輛篷車和十二頭公牛。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","「你要收下他們的這些供物，按利未人的工作分配給他們，好用在會幕的工作中。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","於是，摩西收下車和牛，交給利未人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","他按照革順子孫的工作需要，分給他們兩輛車和四頭牛， ");
INSERT INTO cmncbt_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","按照米拉利子孫的工作需要，分給他們四輛車和八頭牛。他們都在祭司亞倫的兒子以他瑪的領導下任職。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","摩西沒有把供物分給哥轄的子孫，因為他們要用肩扛所負責的聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","膏抹祭壇時，各首領都為獻壇之禮帶來供物，獻在祭壇前。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","耶和華對摩西說：「每天要有一位首領為獻壇之禮獻上供物。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","第一天來獻供物的是猶大支派亞米拿達的兒子拿順。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是亞米拿達的兒子拿順的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","第二天來獻供物的是以薩迦支派的首領、蘇押的兒子拿坦業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是蘇押的兒子拿坦業的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","第三天來獻供物的是西布倫支派的首領、希倫的兒子以利押。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","一隻作贖罪祭的公山羊， ");
INSERT INTO cmncbt_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是希倫的兒子以利押的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","第四天來獻供物的是呂便支派的首領、示丟珥的兒子以利蘇。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是示丟珥的兒子以利蘇的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","第五天來獻供物的是西緬支派的首領、蘇利沙代的兒子示路蔑。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是蘇利沙代的兒子示路蔑的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","第六天來獻供物的是迦得支派的首領、丟珥的兒子以利雅薩。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是丟珥的兒子以利雅薩的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","第七天來獻供物的是以法蓮支派的首領、亞米忽的兒子以利沙瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是亞米忽的兒子以利沙瑪的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","第八天來獻供物的是瑪拿西支派的首領、比大蘇的兒子迦瑪列。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是比大蘇的兒子迦瑪列的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","第九天來獻供物的是便雅憫支派的首領、基多尼的兒子亞比但。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是基多尼的兒子亞比但的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","第十天來獻供物的是但支派的首領、亞米沙代的兒子亞希以謝。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是亞米沙代的兒子亞希以謝的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","第十一天來獻供物的是亞設支派的首領、俄蘭的兒子帕結。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是俄蘭的兒子帕結的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","第十二天來獻供物的是拿弗他利支派的首領、以南的兒子亞希拉。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","他的供物是一個重一公斤半的銀盤，一個重八百克的銀碗，重量都以聖所的秤為準，都盛滿作素祭的調了油的細麵粉； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","一個重一百一十克盛滿香的金碟子； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","作燔祭的一頭公牛犢、一隻公綿羊和一隻一歲的公羊羔； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","一隻作贖罪祭的公山羊； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","作平安祭的兩頭公牛、五隻公綿羊、五隻公山羊和五隻一歲的公羊羔。這是以南的兒子亞希拉的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","以上是膏抹祭壇時，以色列各首領為獻壇之禮所獻的供物，共計有銀盤、銀碗和金碟子各十二個， ");
INSERT INTO cmncbt_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","以聖所的秤為準，每個銀盤重一公斤半，每個銀碗重八百克，共重二十七公斤半； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","以聖所的秤為準，盛滿香的十二個金碟子每個重一百一十克，共重一千三百二十克； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","作燔祭的牲畜共有公牛犢十二頭，公綿羊和一歲的公羊羔各十二隻，還有一起獻上的素祭以及作贖罪祭的公山羊十二隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","作平安祭的牲畜共有公牛二十四頭，公綿羊、公山羊、一歲的公羊羔各六十隻。 以上是在膏抹祭壇後所獻的供物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","摩西進入會幕要與耶和華說話時，聽見耶和華從約櫃的施恩座上、兩個基路伯天使中間對他說話。耶和華就這樣和他說話。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","「你告訴亞倫，『你安放燈的時候，七盞燈都要照在燈臺前面。』」 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","亞倫就照耶和華對摩西的吩咐把燈放好，使燈照亮燈台前面。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","整座燈臺，從燈座到花朵，都是照耶和華指示摩西的樣式用金子錘製而成的。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","「你要把利未人從其他以色列人中分別出來，潔淨他們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","要用以下的方法潔淨他們，把潔淨水灑在他們身上，叫他們用剃刀剃淨全身，洗淨衣服，這樣他們就潔淨了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","然後叫他們帶來一頭公牛犢及作素祭的調了油的細麵粉，你要另獻一頭公牛犢作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","你要招聚以色列全體會眾，將利未人帶到會幕前， ");
INSERT INTO cmncbt_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","帶到耶和華面前，會眾要把手按在他們身上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","亞倫要把他們獻給耶和華，作為以色列人獻的搖祭，使他們可以事奉耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","利未人要把手按在那兩頭公牛的頭上，然後你要把一頭作為贖罪祭，一頭作為燔祭獻給耶和華，好為利未人贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","你要讓利未人站在亞倫父子們面前，把他們當作搖祭獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","這樣，你就把利未人從其他以色列人中分別出來，使他們歸給我。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","利未人被潔淨、當作搖祭獻上以後，就可以進會幕司職， ");
INSERT INTO cmncbt_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","因為在以色列人中，他們完全屬於我，我揀選他們歸我所有，以代替以色列人所有的長子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","以色列人所有的長子和頭生的牲畜都屬於我。我擊殺埃及人所有的長子和頭生的牲畜那天，已把以色列人所有的長子和頭生的牲畜都分別出來，使之聖潔，歸給我。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","我現在已揀選利未人代替以色列人所有的長子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","我從以色列人中把利未人作為禮物交給亞倫父子們，替以色列人在會幕中司職，為以色列人贖罪，免得以色列人因接近聖所而遭禍。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","摩西、亞倫和以色列全體會眾，就按照耶和華對摩西的吩咐把利未人獻上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","利未人自潔、洗淨衣服後，亞倫把他們當作搖祭獻給耶和華，又為他們贖罪，使他們潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","之後，利未人便進入會幕，在亞倫父子們的監督下司職。以色列人照耶和華對摩西的吩咐奉獻了利未人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","「二十五歲以上的利未人都要到會幕司職， ");
INSERT INTO cmncbt_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","五十歲時退休，不再司職。 ");
INSERT INTO cmncbt_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","退休之後，他們可以協助本族弟兄看守會幕，不用再司職。你要這樣給他們分派工作。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","以色列人離開埃及後第二年的一月，耶和華在西奈曠野對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","「以色列人要在指定的時間守逾越節， ");
INSERT INTO cmncbt_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","就是在一月十四日黃昏，按照相關律例和典章守逾越節。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","於是，摩西吩咐以色列人守逾越節。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","一月十四日黃昏，以色列人在西奈曠野守逾越節。以色列人遵行了耶和華對摩西的一切吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","可是，有幾個人因碰到死屍而不潔淨，不能在那天守逾越節，他們就來見摩西和亞倫， ");
INSERT INTO cmncbt_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","說：「我們因碰到死屍而不潔淨，為什麼不准我們跟其他以色列人一起在指定的時間向耶和華獻供物？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","摩西說：「你們等一下，我要去聽聽耶和華對你們有什麼吩咐。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","「你告訴以色列人： 「你們或你們的子孫中，若有人因為碰了死屍而不潔淨，或是出了遠門，他們仍然要為耶和華守逾越節。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","他們可以在二月十四日黃昏守逾越節，要配無酵餅和苦菜一起吃逾越節的羊羔。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","食物不可留到早晨，也不可折斷羊羔的一根骨頭。要按照一切律例守逾越節。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","如果有人是潔淨的，又沒有出遠門，卻不守逾越節，要將他從民中剷除。因為他沒有在指定的時間向耶和華獻供物，就必須自負罪責。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","如果寄居在你們中間的外族人也想為耶和華守逾越節，他們也要按照這些律例和典章守逾越節。不論是外族人還是本地人，都要遵守同樣的律例。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","安放約櫃的聖幕支起來那天，雲彩遮蓋了它。整個晚上，雲彩在聖幕上方像火焰一般。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","之後，總是如此：白天雲彩遮蓋聖幕，晚上雲彩像火。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","雲彩什麼時候從聖幕上升起，以色列人就啟行；雲彩在哪裡停下來，以色列人就在哪裡安營。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","他們無論啟行還是安營，都遵照耶和華的吩咐。雲彩在聖幕上停留多久，他們就安營多久。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","有時雲彩在聖幕上停留多日，他們就遵照耶和華的吩咐安營多日。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","有時雲彩在聖幕上只停留幾天，他們就遵照耶和華的吩咐只安營幾天。隨後再照耶和華的吩咐啟行。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","有時雲彩整夜停留在聖幕上，到早晨才升起，他們就早晨才啟行。不管白天黑夜，雲彩一升起，他們就啟行。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","不管是兩天、一個月或是一年，只要雲彩停留在聖幕上，以色列人就安營不動；雲彩一升起，他們就啟行。 ");
INSERT INTO cmncbt_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","他們遵照耶和華的吩咐安營，也遵照耶和華的吩咐啟行。他們遵行耶和華藉摩西吩咐的話。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","「你要用銀子打造兩支號，用來招聚會眾和發出拔營的號令。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","吹響兩支號時，全體會眾要在會幕門口聚集到你面前。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","如果只吹響一支號，擔任首領的以色列各族長要聚集到你面前。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","如果吹響拔營的號令，在東面紮營的就要啟行； ");
INSERT INTO cmncbt_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","第二次吹響拔營號令時，在南面紮營的就要啟行。拔營號令是啟行的信號。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","但吹號招聚會眾時，不要用拔營號令。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","做祭司的亞倫子孫要負責吹號，這是你們世代當守的永久律例。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","當你們在自己的土地上跟來犯之敵作戰時，要吹響兩支號，你們的上帝耶和華必眷顧你們，救你們脫離敵人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","在節期和朔日這些歡樂的日子獻燔祭和平安祭的時候，你們要吹號，好在你們的上帝面前蒙眷顧。我是你們的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","第二年的二月二十日，雲彩從安放約櫃的聖幕上升起， ");
INSERT INTO cmncbt_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","以色列人就從西奈曠野啟行，直到雲彩停在巴蘭曠野時才停下來。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","這是他們初次照耶和華藉摩西的吩咐啟行。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","猶大旗下的營隊率先出發，率領猶大支派的是亞米拿達的兒子拿順， ");
INSERT INTO cmncbt_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","率領以薩迦支派的是蘇押的兒子拿坦業， ");
INSERT INTO cmncbt_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","率領西布倫支派的是希倫的兒子以利押。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","然後，聖幕被拆卸，革順和米拉利的子孫抬著聖幕出發。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","隨後出發的是呂便旗下的營隊，率領呂便支派的是示丟珥的兒子以利蘇， ");
INSERT INTO cmncbt_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","率領西緬支派的是蘇利沙代的兒子示路蔑， ");
INSERT INTO cmncbt_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","率領迦得支派的是丟珥的兒子以利雅薩。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","隨後出發的是哥轄人，他們抬著聖物前行。在他們到達之前，聖幕應已支好。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","隨後出發的是以法蓮旗下的營隊，率領以法蓮支派的是亞米忽的兒子以利沙瑪， ");
INSERT INTO cmncbt_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","率領瑪拿西支派的是比大蘇的兒子迦瑪列， ");
INSERT INTO cmncbt_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","率領便雅憫支派的是基多尼的兒子亞比但。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","殿後的是但旗下的營隊，率領但支派的是亞米沙代的兒子亞希以謝， ");
INSERT INTO cmncbt_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","率領亞設支派的是俄蘭的兒子帕結， ");
INSERT INTO cmncbt_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","率領拿弗他利支派的是以南的兒子亞希拉。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","這是以色列各營隊拔營前行的次序。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","摩西對岳父米甸人流珥之子何巴說：「我們就要動身前往耶和華應許給我們的地方，祂曾說要把那地方賜給我們。請你跟我們一起去吧，我們必厚待你，耶和華已經應許要賜福給以色列人。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","何巴說：「我不去了，我要回到我的家鄉和親族那裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","摩西說：「請不要離開我們。你熟悉曠野，可以做我們的嚮導，告訴我們在哪裡紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","如果你跟我們同去，我們一定與你分享耶和華賜給我們的福氣。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","以色列人離開耶和華的山，走了三天的路程，期間耶和華的約櫃一直在隊伍的前頭，為他們尋找安歇之地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","他們拔營前行的時候，白天總有耶和華的雲彩在他們上面。 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","每當約櫃出發的時候，摩西就說：「耶和華啊，求你興起，擊潰你的仇敵，使恨你的人從你面前逃竄。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","約櫃停下來的時候，他就說：「耶和華啊，求你回到以色列的千萬人中。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","民眾因為困難而發怨言，傳到耶和華耳中。耶和華聽見後便向他們發怒，使火在他們中間燃燒，燒毀了營地的邊緣部分。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","民眾呼求摩西，摩西便向耶和華禱告，火就熄了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","那地方叫他備拉，因為耶和華的火曾在他們中間燃燒。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","他們中間有一群烏合之眾貪戀美食，以色列人也哭著說：「要是有肉吃多好啊！ ");
INSERT INTO cmncbt_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","還記得在埃及的時候，我們不花錢就可以吃魚，還有黃瓜、西瓜、韭菜、蔥和蒜。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","我們現在毫無胃口，眼前除了嗎哪外，什麼都沒有。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","嗎哪的形狀像芫荽籽，又像珍珠。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","每天晚上露水降在營地上時，嗎哪也隨著降下來。早晨民眾到四周撿嗎哪，把嗎哪用磨磨碎或在臼中搗碎後，放在鍋裡煮，再做成餅，味道就像油餅。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","摩西感到難過，因為他聽見民眾都在自己帳篷門口哭泣，以致耶和華大發烈怒。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","他對耶和華說：「你為什麼苦待僕人？我做了什麼令你不悅的事，你竟把管理這些民眾的重擔放在我身上？ ");
INSERT INTO cmncbt_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","難道是我孕育生養了他們嗎？為什麼你要我像父親呵護吃奶的嬰兒一樣，把他們抱到你應許給他們祖先的地方呢？ ");
INSERT INTO cmncbt_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","他們都哭著向我要肉吃，我去哪裡找肉給他們吃呢？ ");
INSERT INTO cmncbt_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","管理民眾的責任實在是太重了，我一個人擔當不起啊！ ");
INSERT INTO cmncbt_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","你既然這樣對待我，求你施恩殺了我吧，別讓我受苦了！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","耶和華對摩西說：「你給我招聚七十個以色列人的長老，就是你所瞭解的長老和首領，把他們帶到會幕，讓他們站在你身邊。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","我要在那裡降臨，對你說話，把降在你身上的靈也賜給他們，讓他們為你分擔管理民眾的責任，免得你獨自承擔。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","你要叫民眾潔淨自己，明天就會有肉吃。因為我聽見了他們哭著要肉吃、說埃及的日子更好，我必給他們肉吃。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","他們將不止吃一天、兩天、五天、十天或二十天， ");
INSERT INTO cmncbt_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","而是要吃整整一個月，直到肉從他們鼻孔裡噴出來，令他們厭膩。因為他們厭棄住在他們中間的我，在我面前哭訴，後悔離開埃及。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","摩西說：「和我同行的，僅男子就有六十萬，你還說要讓他們吃整整一個月的肉！ ");
INSERT INTO cmncbt_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","就是把牛羊都宰了，夠他們吃嗎？就是把海裡的魚都捕來，夠他們吃嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","耶和華說：「難道我的臂膀短小無力嗎？你很快將看見我的話會不會應驗。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","摩西就出去把耶和華的話轉告民眾，又召集了七十位長老，叫他們站在會幕周圍。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","耶和華在雲中降臨，對摩西說話，把降在摩西身上的靈也賜給七十位長老。靈一降在他們身上，他們就說起預言來，但只說了這一次。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","七十位長老中的伊利達和米達沒有到會幕去，但耶和華的靈也降在他們身上，他們就在營中說起預言來。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","有一個青年跑去稟告摩西說：「伊利達和米達正在營中說預言。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","摩西揀選的助手嫩的兒子約書亞就說：「我主摩西，請你禁止他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","摩西說：「你是為我的緣故而嫉妒嗎？願耶和華的子民都成為先知！願耶和華把祂的靈降在他們身上！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","之後，摩西和以色列的長老都返回營中。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","耶和華颳起一陣風，把鵪鶉從海面颳到營地四周，約一米厚，方圓數公里。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","民眾花了兩天一夜的時間去捕捉鵪鶉，每人至少捉了一噸半。他們把鵪鶉攤在營地的周圍。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","他們口中的肉還沒嚼爛，耶和華的怒氣就已向他們發作，降下了大災。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","因此，那地方叫基博羅·哈他瓦，因為那些貪食之徒埋葬在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","民眾從基博羅·哈他瓦前往哈洗錄，在哈洗錄住了下來。 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","米利暗和亞倫因摩西娶了一個古實的女子而批評他，說： ");
INSERT INTO cmncbt_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","「難道耶和華只藉著摩西說話嗎？祂不也藉著我們說話嗎？」耶和華聽見了這話。 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","其實摩西為人十分謙和，比世上任何人都謙和。 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","耶和華突然對摩西、亞倫和米利暗說：「你們三人都出來到會幕去。」他們就去了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","耶和華在雲柱中降臨，站在會幕門口呼喚亞倫和米利暗，二人就走到前面。 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","耶和華說：「你們聽我說，你們中間若有先知，我耶和華必在異象中向他顯現，在夢中跟他說話。 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","但我不是這樣對待我的僕人摩西，他在我家裡忠信可靠， ");
INSERT INTO cmncbt_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","我跟他面對面說話，清清楚楚，不用謎語，他看得見我的形像。你們怎敢批評我的僕人摩西？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","耶和華向他們發怒，然後離去。 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","雲彩從會幕上離開的時候，米利暗身上患了痲瘋病，像雪一樣白。亞倫見狀， ");
INSERT INTO cmncbt_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","便對摩西說：「我主啊，求你不要因我們愚昧犯罪而懲罰我們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","求你不要讓她像那一出母腹便半身腐爛的死胎。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","於是，摩西呼求耶和華：「上帝啊，求你醫治她！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","耶和華對摩西說：「如果她父親在她臉上吐唾沫，她豈不也要蒙羞七天嗎？現在把她關在營外，七天後再讓她回來。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","於是，米利暗被關在營外七天，民眾等她回營後才繼續前行。 ");
INSERT INTO cmncbt_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","他們離開哈洗錄，到巴蘭曠野安營。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","「你要派十二位首領，每個支派一位，去打探我要賜給以色列人的迦南。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","摩西就按耶和華的吩咐，從巴蘭曠野派出了以色列人的十二位首領。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","他們的名字如下：呂便支派撒刻的兒子沙姆亞， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","西緬支派何利的兒子沙法， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","猶大支派耶孚尼的兒子迦勒， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","以薩迦支派約色的兒子以迦， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","以法蓮支派嫩的兒子何西阿， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","便雅憫支派拉孚的兒子帕提， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","西布倫支派梭底的兒子迦疊， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","約瑟的子孫、瑪拿西支派穌西的兒子迦底， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","但支派基瑪利的兒子亞米利， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","亞設支派米迦勒的兒子西帖， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","拿弗他利支派縛西的兒子拿比， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","迦得支派瑪基的兒子臼利。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","以上是摩西派去打探迦南的人，他稱嫩的兒子何西阿為約書亞。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","摩西派他們去打探迦南，並囑咐說：「你們先去南地，然後再進山區， ");
INSERT INTO cmncbt_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","察看那地方，看看那裡的居民是強是弱，是多是少； ");
INSERT INTO cmncbt_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","他們住的地方是好是壞，人們住的是堅固的城池還是不設防的營地； ");
INSERT INTO cmncbt_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","土地是肥沃還是貧瘠，有沒有樹木。儘力帶些當地的果子回來。」當時是葡萄初熟的季節。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","於是，他們從荀曠野一直打探到哈馬口附近的利合。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","他們經南地到達希伯崙。希伯崙城比埃及的瑣安城還要早建七年，那裡住著亞衲人的子孫亞希幔、示篩和撻買。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","他們來到以實各谷，在那裡砍下一根葡萄枝，上面有一串葡萄，由兩個人用槓子抬著，又採了一些石榴和無花果。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","因為他們在那裡砍了一串葡萄，所以就稱那地方為以實各谷。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","過了四十天，他們打探完畢，返回營地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","他們來到巴蘭曠野的加低斯向摩西、亞倫和以色列全體會眾彙報，把當地的果子給大家看。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","他們對摩西說：「我們到了你派我們去的那地方，果然是奶蜜之鄉，這些都是那裡的果子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","但那裡的居民很強悍，城邑高大堅固。我們在那裡還見到亞衲人的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","亞瑪力人住在南地，赫人、耶布斯人和亞摩利人住在山區，迦南人住在海邊和約旦河沿岸。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","迦勒讓站在摩西面前的民眾安靜，然後說：「我們立刻上去佔領那地方吧！我們必能取勝。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","跟他一起去打探的人卻說：「我們不能上去攻打那些人，他們比我們強大。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","他們還危言聳聽，說：「我們去打探的地方是吞吃居民之地，我們看見的人個個身材高大。 ");
INSERT INTO cmncbt_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","我們在那裡看見了亞衲人的子孫，他們是巨人的後裔，我們跟他們相比就像蚱蜢，他們看我們也像蚱蜢。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","當晚，全體會眾放聲大哭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","全體以色列會眾埋怨摩西和亞倫說：「我們還不如死在埃及或曠野！ ");
INSERT INTO cmncbt_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","耶和華為什麼把我們領到這裡來，讓我們死於刀下？我們的妻兒必被擄去。我們還不如返回埃及。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","他們彼此議論說：「我們選一位首領帶我們回埃及吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","摩西和亞倫俯伏在以色列全體會眾面前。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","打探迦南的人中，嫩的兒子約書亞和耶孚尼的兒子迦勒撕裂衣服， ");
INSERT INTO cmncbt_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","對以色列全體會眾說：「我們去打探的地方極其美好。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","如果耶和華喜悅我們，祂必把我們帶到那片土地，將那奶蜜之鄉賜給我們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","你們不要背叛耶和華，也不要害怕那裡的人，他們不過是我們的獵物，他們已失去庇護。耶和華與我們同在，不要怕他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","但全體會眾威脅要用石頭打死他們二人。這時耶和華的榮光在會幕中向全體以色列人顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","耶和華對摩西說：「這些人藐視我要到何時呢？我在他們中間行了這麼多神蹟，他們還要不信我到何時呢？ ");
INSERT INTO cmncbt_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","我要用瘟疫毀滅他們，不讓他們承受那片土地。但我要使你成為大國，比他們更強盛。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","摩西對耶和華說：「你曾經用大能把以色列人從埃及領出來，埃及人聽說這事後， ");
INSERT INTO cmncbt_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","一定會告訴迦南的居民。那裡的居民早已聽說你耶和華與以色列人同在，你面對面向他們顯現，你的雲彩停留在他們上面，你白天用雲柱、黑夜用火柱引導他們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","如果你把他們全部消滅，那些聽過你威名的列國就會議論說， ");
INSERT INTO cmncbt_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","『耶和華無法把以色列人領到祂起誓要賜給他們的地方，所以在曠野把他們殺了。』 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","因此，求主彰顯偉大的權能，正如你所宣告的， ");
INSERT INTO cmncbt_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","『耶和華不輕易發怒，充滿慈愛；祂赦免罪惡和過犯，但決不免除罪責，必向子孫追討父輩的罪債，直到三四代。』 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","從他們離開埃及直到現在，你一直在饒恕他們，求你以偉大的慈愛再次赦免這些人的罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","耶和華說：「我聽你的祈求，赦免他們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","但我憑我的永恆起誓，正如大地充滿我的榮耀一樣確實， ");
INSERT INTO cmncbt_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","他們絕對一個也看不到我起誓要賜給他們祖先的土地，藐視我的人都看不到那片土地。這些人見過我的榮耀，見過我在埃及和曠野所行的神蹟，卻仍然不聽我的話，試探我十次之多。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","但我的僕人迦勒力排眾議，全心跟從我，所以我必帶他進入那片他去過的土地，讓他的子孫擁有那片產業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","由於亞瑪力人和迦南人住在山谷中，明天你們要轉回，沿紅海的路前往曠野。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","「這邪惡的會眾向我發怨言要到何時呢？我已聽見以色列人對我的埋怨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","你們去把我的話告訴他們，『以色列人啊，我憑我的永恆起誓，我必照你們所說的對待你們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","你們當中凡登記在冊、二十歲以上向我發怨言的人，必倒斃在這曠野中， ");
INSERT INTO cmncbt_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","除耶孚尼的兒子迦勒和嫩的兒子約書亞之外，你們無人能進入我向你們起誓應許之地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","你們說你們的兒女會被擄去，但我要把他們帶到那裡，讓他們享有那片你們厭棄的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","而你們必死在這曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","你們的兒女要在曠野飄泊四十年，為你們的不忠而受苦，直到你們都死在曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","你們打探了那地方四十天，你們要為自己的罪受苦四十年，一年頂一天。那時，你們就知道與我為敵的後果。』 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","我耶和華已經說過，我必這樣對付這群集合起來與我為敵的邪惡會眾。他們必死在曠野，全部喪命。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","摩西派去打探迦南的人回來以後危言聳聽，以致全體會眾向摩西發怨言。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","這些危言聳聽的人因而染上瘟疫，死在耶和華面前。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","前去打探的人中只有嫩的兒子約書亞和耶孚尼的兒子迦勒得以倖存。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","摩西傳達完耶和華的話後，以色列人非常悲傷。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","他們清早起來上到山頂，說：「我們知罪了，現在我們要去耶和華應許的地方。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","摩西說：「你們為什麼要違背耶和華的命令？你們不會成功的。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","不要上去！因為耶和華不與你們同在，你們會被敵人打敗。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","你們會遇見亞瑪力人和迦南人，並喪身在他們刀下，因為你們離棄耶和華，祂不再與你們同在。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","儘管耶和華的約櫃和摩西都沒有出營，他們卻擅自上山頂去。 ");
INSERT INTO cmncbt_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","住在山區的亞瑪力人和迦南人下來擊潰了他們，一路追殺他們到何珥瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","「你把以下條例告訴以色列人。 「你們進入耶和華賜給你們的家園後， ");
INSERT INTO cmncbt_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","要用牛羊作火祭獻給耶和華，作蒙耶和華悅納的馨香之祭。不管是獻燔祭、還願祭、自願獻的祭還是節期的祭，都當如此。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","獻祭者要同時將一公斤細麵粉調上一升油作素祭獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","無論燔祭還是別的祭，每獻一隻羊羔，要同時獻上一升酒作奠祭； ");
INSERT INTO cmncbt_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","每獻一隻公綿羊，要同時將兩公斤細麵粉調上一升半油作素祭獻上， ");
INSERT INTO cmncbt_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","還要獻一升半酒作奠祭。這是蒙耶和華悅納的馨香之祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","如果用公牛獻給耶和華作燔祭、還願祭或平安祭， ");
INSERT INTO cmncbt_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","就要將三公斤細麵粉調上兩升油作素祭和公牛一同獻上， ");
INSERT INTO cmncbt_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","還要獻上兩升酒作奠祭。這是蒙耶和華悅納的馨香之祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","「獻公牛、公綿羊、綿羊羔或山羊羔時，都要這樣辦理。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","無論獻多少牲畜，每隻都要這樣辦理。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","凡以色列人獻上蒙耶和華悅納的馨香火祭時，都要這樣辦理。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","住在你們中間的外族人，不管是暫住還是世代居住的，若願意獻上蒙耶和華悅納的馨香火祭，也要這樣辦理。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","以色列人和寄居的外族人都要遵守一樣的條例，永世不變。你們在耶和華面前怎樣做，外族人也要怎樣做。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","你們和寄居在你們那裡的外族人要遵行一樣的條例和規定。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","「你把以下條例告訴以色列人。 「你們到達耶和華領你們去的地方， ");
INSERT INTO cmncbt_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","吃當地的出產時，要拿出一份作舉祭獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","你們要用初熟的麥子磨麵做餅，當作舉祭獻上，好像獻麥場的舉祭一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","你們世世代代都要用初熟的麥子磨麵，當作舉祭獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","「如果你們無意間違背了耶和華藉摩西吩咐你們遵守的命令， ");
INSERT INTO cmncbt_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","就是吩咐你們從祂頒佈之日起，要世世代代遵守的命令， ");
INSERT INTO cmncbt_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","如果是因會眾的無知而造成無心之過，全體會眾就要獻上一頭公牛犢作燔祭，作蒙耶和華悅納的馨香之祭，同時按規定獻上素祭和奠祭，外加一隻公山羊作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","祭司要為以色列全體會眾贖罪，這樣他們就得到了赦免，因為是無心之過，並且他們已經向耶和華獻上火祭和贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","這樣，以色列全體會眾和寄居的外族人都必蒙赦免，因為無心之過牽涉到所有人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","「倘若是個人無意間犯了罪，他就要獻上一隻一歲的母山羊作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","祭司要為這無意間犯罪的人在耶和華面前贖罪，使他獲得赦免。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","無論是以色列人或是寄居的外族人，凡是犯無心之過的都要按這規條辦理。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","但不管是以色列人還是外族人，若任意妄為，褻瀆了耶和華，都要從民中被剷除， ");
INSERT INTO cmncbt_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","因為他藐視耶和華的話，違背耶和華的命令，必須被剷除，罪責自負。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","以色列人在曠野的時候，發現有人在安息日撿柴， ");
INSERT INTO cmncbt_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","他們就把撿柴的人帶到摩西、亞倫和全體會眾那裡， ");
INSERT INTO cmncbt_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","把他關起來，因為不知道如何處置他。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","耶和華對摩西說：「必須處死那人，全體會眾要在營外用石頭打死他。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","於是，全體會眾照耶和華對摩西的吩咐，把他拉到營外，用石頭打死了他。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","「你要吩咐以色列人世世代代在衣角縫上穗子，穗子上繫一條藍色細帶。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","穗子是用來提醒他們，要遵行我的一切命令，不要隨從自己心中和眼目的情慾而背信棄義。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","這樣，你們就會記得遵守我的一切命令，做你們上帝的聖潔之民。 ");
INSERT INTO cmncbt_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","我是你們的上帝耶和華，我把你們從埃及領出來，是要做你們的上帝。我是你們的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","可拉是利未的曾孫、哥轄的孫子、以斯哈的兒子。他跟呂便支派以利押的兩個兒子大坍和亞比蘭，以及比勒的兒子安， ");
INSERT INTO cmncbt_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","聯合二百五十名在以色列會眾中有聲望的首領反叛摩西， ");
INSERT INTO cmncbt_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","一起攻擊摩西和亞倫，說：「你們太過分了！全體會眾都是聖潔的，有耶和華住在他們當中，你們憑什麼將自己置於耶和華的會眾之上？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","摩西聽了這話，就俯伏在地， ");
INSERT INTO cmncbt_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","對可拉一夥人說：「到了明天早上，耶和華必顯明誰是屬於祂的，誰是聖潔的。祂必讓祂所揀選的人到祂面前。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","可拉啊，你們要這樣做，你和你的同夥明天帶香爐來， ");
INSERT INTO cmncbt_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","在耶和華面前點火添香。耶和華揀選誰，誰就是聖潔的。你們利未人太過分了！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","摩西又對可拉說：「利未人啊，你們聽我說！ ");
INSERT INTO cmncbt_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","以色列的上帝把你們從以色列會眾中分別出來，使你們可以到祂面前，在祂的聖幕裡司職，替會眾辦事，你們還不滿足嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","可拉啊，耶和華使你和其他利未人事奉祂，你們還要貪求祭司的職分嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","其實你和你的同夥合謀反叛的是耶和華。亞倫是何人，你們竟埋怨他？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","摩西派人去召以利押的兒子大坍和亞比蘭，他們卻說：「我們不去！ ");
INSERT INTO cmncbt_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","你帶我們離開奶蜜之鄉，要讓我們死在曠野，這還不夠嗎？你還想自立為王管轄我們嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","你並沒有領我們到奶蜜之鄉，也沒有給我們田地和葡萄園作產業，你還想繼續矇騙我們嗎？我們不去！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","摩西非常憤怒，就對耶和華說：「求你不要接納他們的祭物。我沒有取過他們一頭驢，也沒有害過他們任何人。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","摩西對可拉說：「明天你和你的同夥要跟亞倫一起站在耶和華面前。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","每人要拿自己的香爐，放上香，帶到耶和華面前，共二百五十個。你和亞倫也要各拿自己的香爐。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","於是，他們都拿著香爐，盛著火和香，跟摩西和亞倫一起站在會幕門口。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","可拉把全體會眾招聚到會幕門口，要對付摩西和亞倫。這時，耶和華的榮光向全體會眾顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","「你們離開這些會眾，我好在頃刻之間消滅他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","摩西和亞倫就伏在地上說：「上帝啊，賜人生命氣息的上帝啊！一人犯罪，你就要向全體會眾發怒嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","「你叫會眾離可拉、大坍和亞比蘭的帳篷遠一點。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","於是，摩西起來去大坍和亞比蘭那裡，以色列的長老也跟著他。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","他對會眾說：「你們離這些惡人的帳篷遠一點，不要碰他們的任何東西，免得你們因他們的罪而受牽連，同遭毀滅。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","會眾便離開可拉、大坍和亞比蘭的帳篷。大坍和亞比蘭帶著妻小出來，站在自己的帳篷門口。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","摩西對會眾說：「你們很快就知道，我所做的事都是奉耶和華之命而行，並非出於私意。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","如果這些人像常人一樣死去，遭遇跟世人無異，我就不是耶和華派來的。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","但如果耶和華做一件前所未有的事，使地裂開，吞下他們和屬於他們的一切，使他們活生生地墜入陰間，你們就知道這些人藐視耶和華了。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","摩西的話剛說完，這些人腳下的地就裂開， ");
INSERT INTO cmncbt_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","吞下了他們和他們的家眷，以及所有可拉一夥的人和財物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","他們和屬於他們的一切，就這樣活活地墜入陰間，地在他們上面合攏起來，他們就從會眾中滅亡了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","他們四圍的以色列人聽到他們的喊叫聲，紛紛逃跑，生怕自己也被地吞下去。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","耶和華又降下烈火，燒死了那二百五十個獻香的人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","「你叫亞倫祭司的兒子以利亞撒，去從火中把香爐撿起來，把炭火撒在遠處，因為那些香爐是聖潔的。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","要把那些因犯罪而喪命之人的香爐打成薄片，用來包祭壇，因為那些香爐曾被獻在耶和華面前，是聖潔的，並且可讓以色列人引以為戒。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","於是，以利亞撒祭司取來被燒死之人所獻的銅香爐，叫人打成薄片用來包祭壇， ");
INSERT INTO cmncbt_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","讓以色列人引以為戒，使亞倫子孫以外的人不致到耶和華面前燒香，以免像可拉及其同夥一樣滅亡。這是按照耶和華藉摩西的吩咐做的。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","第二天，以色列全體會眾都埋怨摩西和亞倫說：「你們害死了耶和華的子民。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","會眾聚集起來反對摩西和亞倫，他們向會幕觀看，忽然有雲彩遮蓋了會幕，耶和華的榮光顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","摩西和亞倫來到會幕前， ");
INSERT INTO cmncbt_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","「你們離開這些會眾，我好在頃刻之間消滅他們。」他們二人就俯伏在地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","摩西對亞倫說：「取香爐來，裡面放些祭壇上的火，添上香，趕快帶到會眾那裡為他們贖罪，因為耶和華發怒了，瘟疫已經開始。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","亞倫就照著摩西的吩咐取來香爐，跑到會眾當中。那時瘟疫已經在人群中蔓延起來。他就在爐中放上香為民眾贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","他站在活人和死人之間，瘟疫就止住了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","除了在可拉事件中死亡的人以外，有一萬四千七百人死於瘟疫。 ");
INSERT INTO cmncbt_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","瘟疫止住後，亞倫便回到在會幕門口的摩西那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","「你要吩咐以色列人從每個支派的首領那裡拿一根杖來，共十二根，你要在上面寫上他們各人的名字。 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","你要把亞倫的名字寫在利未支派的杖上，每個支派的首領都要有一根杖。 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","你要把這些杖放在會幕內的約櫃前，就是我跟你會面的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","誰的杖發芽，誰就是我所揀選的人。這樣，我必消除以色列人對你們的埋怨。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","於是，摩西吩咐以色列每個支派的首領把杖都交給他，共十二根，亞倫的杖也在其中。 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","摩西把杖放在放約櫃的聖幕裡、耶和華面前。 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","第二天，摩西進入約櫃所在的聖幕裡，看見利未支派亞倫的杖不單發了芽，長了花蕾，還開了花，結出熟杏。 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","摩西就從耶和華面前拿出所有的杖，給以色列人看。他們看後，各位首領便取回自己的杖。 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","耶和華對摩西說：「把亞倫的杖放回約櫃前，讓叛逆之徒引以為戒。這樣，你就可以平息他們對我的怨言，使他們不致滅亡。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","摩西照耶和華的吩咐行了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","以色列人對摩西說：「完了！我們死定了！我們全死定了！ ");
INSERT INTO cmncbt_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","凡走近耶和華聖幕的都要死。我們全都要滅亡嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","耶和華對亞倫說：「你和你的兒子及親族要承擔觸犯聖所的罪責；你和你兒子也要承擔觸犯祭司職務的罪責。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","你和你兒子在安放約櫃的聖幕前供職時，要把你們利未支派的親族也一同帶去，讓他們協助你。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","他們要遵守你的吩咐，看守整個聖幕，但不可接近聖所的器具和祭壇，以免他們和你們都死亡。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","他們要和你一起負責看守聖幕，辦理聖幕的一切事務。外人不可靠近。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","你們要看守聖所和祭壇，以免我的憤怒再臨到以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","我已從以色列人中選出你們的利未親族歸給我，協助你們在會幕中司職。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","你和你兒子要盡祭司的本分，負責祭壇和至聖所的一切事務。祭司的職分是我賞賜給你們的，外人若近前來，必被處死。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","耶和華對亞倫說：「你看！我讓你照管以色列人獻給我的舉祭，把一切聖物賜給你和你的子孫，作為你們永遠當得的份。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","以色列人獻給我的至聖之物素祭、贖罪祭和贖過祭中留下不燒的部分，都歸你和你的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","你們男子都可以吃這些聖物，要在極其聖潔的地方吃。要把這些視為聖物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","以色列人獻的舉祭和搖祭也都歸你，我已把它們賜給你和你的兒女，作為你們永遠當得的份。你家中所有潔淨的人都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","我把以色列人獻給耶和華的初熟之物——最好的新油、新酒和五穀都賜給你。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","他們獻給耶和華的一切初熟之物都歸你，你家中潔淨的人都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","以色列人永遠獻上的一切都要歸你。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","奉獻給耶和華的長子和頭生的牲畜都歸你，但要贖出長子和不潔淨的頭生牲畜。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","他們要在滿月的時候被贖回，以聖所的秤為準，即一舍客勒是二十季拉，贖價是一兩銀子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","頭生的牛、綿羊和山羊不用贖出來，牠們都是聖物。你要把牠們的血灑在祭壇上，把脂肪燒掉，作為獻給耶和華的馨香火祭； ");
INSERT INTO cmncbt_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","牠們的肉要歸你，正如搖祭的胸肉和舉祭的右腿肉一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","以色列人獻給耶和華的聖物中，我把舉祭賜給你和你的兒女，作為你們永遠當得的份，這是我與你及你的後代所立的永世之約。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","耶和華對亞倫說：「你在以色列人的土地上不可有產業，在他們的財物上不可有份，因為我是你在以色列人中的所得之份，是你的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","「我要把以色列人出產的十分之一賜給利未人作產業，作為他們在會幕司職的酬勞。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","今後以色列人不可走近會幕，以免因犯罪而死。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","只有利未人可在會幕司職，他們要擔負觸犯聖幕的罪責，這是你們世代當守的永久律例。利未人在以色列人中不可有產業， ");
INSERT INTO cmncbt_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","因為我已經把以色列人獻給耶和華的十分之一舉祭賜給他們作產業。因此，我吩咐他們不可在以色列人中有產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","「你把以下條例告訴利未人。 「你們從以色列人手中得到我賜給你們作產業的十分之一後，要從中取出十分之一，作為舉祭獻給耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","這就算作你們獻上了麥場的五穀和榨酒池的酒。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","這樣，你們要從以色列人給你們的十分之一中，拿出一部分獻給耶和華作舉祭，將這舉祭歸給亞倫祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","你們要把所得之物中至聖至好的獻給耶和華作舉祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","「你要告訴利未人，『你們奉獻了最好的以後，其餘的算作你們麥場上的五穀和榨酒池的酒， ");
INSERT INTO cmncbt_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","你們和家人可以在任何地方吃，因為這些是你們在會幕司職的酬勞。 ");
INSERT INTO cmncbt_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","你們獻上最好的以後，享用這些就不會獲罪了。你們不可褻瀆以色列人獻上的聖物，免得死亡。』」 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","「要吩咐以色列人遵行我頒佈的以下律法條例。 「以色列人要牽來一頭毫無殘疾、從未負過軛的紅母牛。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","你們要把牛交給以利亞撒祭司，然後牽到營外，當著他的面把牛宰了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","以利亞撒祭司要用指頭蘸牛血，向會幕前面彈七次。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","然後，要當著他的面焚燒紅母牛，牛的皮、肉、血和糞都要燒掉。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","祭司要把香柏木、牛膝草、朱紅色線扔進燒牛的火裡。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","之後，祭司要洗衣沐浴，才能回營，但要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","負責燒牛的人也要洗衣、沐浴，並且要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","要由一個潔淨的人把紅母牛灰收起來，放在營外潔淨的地方，留給以色列會眾作除穢水，作除罪之用。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","收起母牛灰的人也要洗淨衣服，等到傍晚才能潔淨。這是以色列人和在他們中間寄居的外族人永遠當守的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","「碰過屍體的人，七天不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","他要在第三天和第七天用除穢水自潔，才能潔淨，否則就不能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","若有人碰過屍體卻不自潔，他就玷污了耶和華的聖幕，要將他從以色列人中剷除，因為除穢水沒有灑在他身上，他不潔淨，污穢還留在他身上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","若有人死在帳篷裡，就要遵守這樣的條例：當時走進帳篷的或在場的人都七天不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","帳篷裡沒有蓋的敞口器皿都不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","人若在野外碰過被殺或自然死亡之人的屍體，或碰過死人的骸骨或墳墓，就七天不潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","要為不潔淨的人拿些除罪用的紅母牛灰，放在器皿裡，倒上清水， ");
INSERT INTO cmncbt_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","然後由一個潔淨的人拿牛膝草蘸這水灑在帳篷及裡面所有人和器具上，也要灑在碰過骸骨、墳墓、被殺者屍體，或自然死亡者屍體的人身上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","要由潔淨的人在第三天和第七天把水灑在不潔淨的人身上，並在第七天潔淨他們。接受潔淨禮的人要洗衣、沐浴，等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","若有人沾了污穢卻沒有用除穢水自潔，他就不潔淨，要將他從會眾中剷除，因為他玷污了耶和華的聖所。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","這是你們永遠當守的律例。灑除穢水的人要洗淨衣服。碰過除穢水的人要等到傍晚才能潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","不潔淨的人碰過的東西都不潔淨，碰過這些東西的人傍晚之前都不潔淨。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","一月，以色列全體會眾抵達荀曠野，在加低斯安營。米利暗離世，葬在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","會眾沒有水喝，就聚集起來反對摩西和亞倫， ");
INSERT INTO cmncbt_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","他們跟摩西吵鬧說：「還不如當初跟我們的弟兄一起死在耶和華面前！ ");
INSERT INTO cmncbt_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","你們為什麼領耶和華的會眾到這曠野來，要叫我們和牲畜都死在這裡嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","你們為什麼帶我們出埃及，到這不毛之地？這裡沒有五穀、無花果樹、葡萄樹和石榴樹，甚至沒有水喝。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","摩西和亞倫離開會眾到會幕門口，俯伏在地。耶和華的榮光向他們顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","「你拿著杖和你哥哥亞倫招聚會眾，當著他們的面吩咐磐石流出水來，水就會從磐石流出，供會眾和牲畜喝。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","摩西遵命而行，從耶和華面前取了杖， ");
INSERT INTO cmncbt_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","然後和亞倫把會眾招聚到磐石前，說：「你們這些叛逆之徒聽著，非要我們叫磐石給你們流出水來嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","接著，摩西舉起手中的杖擊打磐石兩下，水便噴湧而出，會眾和牲畜都喝了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","耶和華對摩西和亞倫說：「你們對我沒有足夠的信心，沒有當著以色列人的面尊我為聖，所以你們不得帶領會眾進入我所賜之地。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","這地方叫米利巴泉，因為以色列人在那裡與耶和華爭鬧，耶和華就向他們彰顯了祂的聖潔。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","摩西從加低斯派使者去見以東王，說：「你的弟兄以色列人說，你知道我們遭遇的種種困難。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","我們祖先到埃及寄居多年，我們世代受埃及人虐待。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","但我們呼求耶和華，祂就垂聽了我們的聲音，差遣天使帶我們出埃及。現在我們來到你邊境的加低斯城， ");
INSERT INTO cmncbt_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","求你容我們借道貴國。我們不會踏入田地和葡萄園，也不會喝井裡的水，只走王的大路，不會偏離左右，直到走出貴國。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","以東王卻說：「你們不可從我這裡經過，否則我必兵戎相見。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","以色列人說：「我們只走大路，倘若我們和牲畜喝了你的水，我們會付錢。我們別無他求，只求步行穿過貴國。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","但以東王仍然不准，還率領大軍嚴陣以待。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","由於以東王不讓以色列人穿過他的領土，以色列人只好繞道。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","以色列全體會眾從加低斯出發，來到何珥山。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","耶和華在位於以東邊界的何珥山對摩西和亞倫說： ");
INSERT INTO cmncbt_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","「亞倫要歸到他祖先那裡，他不能進入我賜給以色列人的土地，因為你們在米利巴泉違背了我的命令。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","你要帶亞倫和他兒子以利亞撒上何珥山， ");
INSERT INTO cmncbt_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","把亞倫的聖衣脫下來給他兒子以利亞撒穿上，因為亞倫將歸到他祖先那裡，死在山上。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","摩西遵命而行。他們三人就當著全體會眾的面上了何珥山。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","摩西把亞倫的聖衣脫下，給他兒子以利亞撒穿上。隨後亞倫在山頂離世。摩西和以利亞撒便下了山。 ");
INSERT INTO cmncbt_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","以色列全體會眾得知亞倫離世，就為他哀悼了三十天。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","住在南地的迦南人亞拉得王聽說以色列人取道亞他林而來，就攻打他們，俘虜了一些人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","以色列人向耶和華許願說：「要是你將這些人交在我們手中，我們必徹底摧毀他們的城邑。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","耶和華答應了他們的祈求，把迦南人交在他們手中，使他們徹底毀滅了迦南人及其城邑。從此，那地方叫何珥瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","以色列人為了繞過以東，便從何珥山出發，沿通往紅海的路行進。途中，民眾心裡煩躁， ");
INSERT INTO cmncbt_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","埋怨上帝和摩西說：「你們為什麼帶我們出埃及，叫我們死在曠野呢？這裡無糧無水，我們厭惡這難吃的東西！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","於是，耶和華派毒蛇進入以色列人中，咬死了許多人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","他們來找摩西，說：「我們埋怨耶和華和你，犯了罪，求你向耶和華禱告，好叫蛇離開我們。」摩西就為他們禱告。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","耶和華對摩西說：「你去造一條毒蛇掛在桿子上，凡被咬的一望這蛇，就可活命。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","摩西就造了一條銅蛇，掛在桿子上。被蛇咬的人一望銅蛇，就保住了性命。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","以色列人繼續前行，在阿伯安營； ");
INSERT INTO cmncbt_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","又從阿伯動身，走到摩押東邊的曠野，在以耶·亞巴琳安營； ");
INSERT INTO cmncbt_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","又從那裡前行，走到撒烈谷安營； ");
INSERT INTO cmncbt_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","又從那裡出發，走到亞嫩河北岸的曠野安營。那裡毗鄰亞摩利人的邊境，亞嫩河是摩押和亞摩利人之間的疆界。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","因此，《耶和華的戰記》上說：「蘇法的哇哈伯，亞嫩河谷， ");
INSERT INTO cmncbt_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","以及靠近摩押邊界並延伸到亞珥城的河谷的斜坡。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","以色列人又往前走，來到比珥。耶和華曾在那裡對摩西說：「把民眾招聚起來，我要給他們水喝。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","當時，以色列人唱了這首歌： 「井啊，湧出水來！ 你們要歌唱這口井， ");
INSERT INTO cmncbt_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","它是首領挖的， 是民中的貴族掘的， 用令牌和權杖挖掘的。」 他們從曠野前往瑪他拿， ");
INSERT INTO cmncbt_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","從瑪他拿前往拿哈列，從拿哈列前往巴末， ");
INSERT INTO cmncbt_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","從巴末前往摩押的谷地，從那裡的毗斯迦山頂可以俯視曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","以色列人派使者去見亞摩利王西宏，說： ");
INSERT INTO cmncbt_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","「請允許我們從貴國經過，我們只走王的大路，不會踏入田地和葡萄園，也不會喝井裡的水，直到走出貴國的土地。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","但西宏不讓以色列人經過他的領土，還招聚軍隊到曠野攻擊他們。他們來到雅雜與以色列人交戰。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","以色列人用刀殺了西宏，佔領了他的土地——從亞嫩河到雅博河，遠至防守嚴密的亞捫人邊界。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","以色列人攻佔了亞摩利人的所有城邑，包括希實本及其周圍的村莊，住在其中。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","希實本是亞摩利王西宏的都城。西宏曾與摩押的先王交戰，佔領了他所有的領土，遠至亞嫩河。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","因此有人作詩說： 「來希實本吧！ 願西宏的城被修建起來。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","希實本烈焰熊熊， 西宏的城火光沖天， 燒毀摩押的亞珥， 吞噬亞嫩河的高崗。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","摩押啊，你大禍臨頭了！ 拜基抹神明的人啊， 你們要滅亡了！ 基抹任由自己的兒子逃亡、 女兒被亞摩利王西宏擄走。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","但我們擊潰了亞摩利人， 從希實本一直到底本都被摧毀， 從挪法到米底巴都淪為廢墟。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","於是，以色列人住在亞摩利境內。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","摩西派人去雅謝打探，然後出兵攻佔了雅謝及其周圍的村莊，趕走那裡的亞摩利人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","以色列人回師前往巴珊，巴珊王噩率全軍出動，在以得來迎戰以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","耶和華對摩西說：「不要怕他，因為我已把他及其眾民和土地交在你手中。你要像從前對付希實本的亞摩利王西宏一樣對付他。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","於是，以色列人殺了噩及其兒子和人民，一個不留，並奪取了他的國土。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","以色列人繼續前行，抵達約旦河東岸的摩押平原，在耶利哥對面安營。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","西撥的兒子摩押王巴勒得知以色列人對亞摩利人的所作所為， ");
INSERT INTO cmncbt_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","又見他們人多勢眾，就驚恐萬狀。摩押人被以色列人嚇壞了， ");
INSERT INTO cmncbt_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","就對米甸的長老說：「這群人將吞掉我們周圍的一切，如同牛吃光田間的草一樣。」那時，西撥的兒子巴勒做摩押王。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","他差遣使者去幼發拉底河附近，到比珥的兒子巴蘭的家鄉毗奪，去召巴蘭，說：「有一個民族從埃及鋪天蓋地而來，就住在我對面。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","他們比我強大，求你為我咒詛他們。這樣，我也許就能擊敗他們，把他們趕走。我知道你祝福誰，誰就蒙福；你咒詛誰，誰就遭禍。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","摩押和米甸的長老們帶著占卜的禮金去見巴蘭，把巴勒的話轉告他。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","巴蘭說：「你們今夜住在這裡，我必照耶和華的旨意回覆你們。」摩押的官長就在巴蘭那裡住下。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","晚上，上帝來問巴蘭：「住在你這裡的是誰？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","巴蘭回答說：「他們是摩押王西撥的兒子巴勒派來的， ");
INSERT INTO cmncbt_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","說，『有一個民族從埃及鋪天蓋地而來。請你來咒詛那民族，這樣我或許能擊敗他們，把他們趕走。』」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","上帝對巴蘭說：「你不可跟他們去，也不可咒詛那民族，因為那民族是蒙福的。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","巴蘭清早起來，對巴勒的官長說：「你們回去吧，耶和華不准我跟你們去。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","摩押的官長回去對巴勒說：「巴蘭不肯跟我們來。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","巴勒又派去更多、更尊貴的官長。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","他們到了巴蘭那裡，對他說：「西撥的兒子巴勒請你務必去一趟， ");
INSERT INTO cmncbt_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","他必有重賞。你要什麼都可以，只求你去為他咒詛那民族。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","巴蘭回答說：「巴勒就是把他滿屋的金銀都給我，我也不能在任何事上違背我的上帝耶和華的命令。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","請你們在這裡過夜，我好看看耶和華對我還有什麼吩咐。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","當夜，上帝來對巴蘭說：「這些人既然來請你，你就跟他們去吧，但你只可照我說的做。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","巴蘭清早起來，備好驢，跟摩押的官長去了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","巴蘭這一去，激怒了上帝。巴蘭騎著驢，帶著兩個僕人正走在途中，耶和華的天使攔住他的去路。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","驢看見耶和華的天使拔刀攔在路上，就離開大路，跑進田間。巴蘭打驢，要牠回到路上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","耶和華的天使又站在葡萄園之間的一條窄路上，兩邊都是牆。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","驢看見耶和華的天使，就靠著牆邊走，將巴蘭的腳擠在牆上了。巴蘭又打牠。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","耶和華的天使又走到前面，站在狹窄之處，兩邊都無側身通過的餘地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","巴蘭身下的驢看見耶和華的天使，就臥在地上，巴蘭大怒，便用杖打牠。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","耶和華使驢開口對巴蘭說：「我做錯了什麼，你竟打我三次？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","巴蘭說：「因為你戲弄我。如果我手中有刀，早就把你宰了！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","驢對巴蘭說：「我不是你從小就騎的驢嗎？我可曾這樣對你？」巴蘭說：「沒有。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","那時，耶和華開了巴蘭的眼，他才看見耶和華的天使拔刀攔在路上，便俯身下拜。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","耶和華的天使對他說：「你為何三次打你的驢？我來阻擋你，因為你走的路在我眼中是邪路。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","你的驢看見我，一連躲避了三次，驢若沒有躲開，我早已殺了你，只放過驢。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","巴蘭對耶和華的天使說：「我有罪了，我不知道是你攔在路上。現在你如果反對我去，我就回去。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","耶和華的天使說：「跟這些人去吧，但你只許按我的指示說話。」於是，巴蘭跟巴勒的官長去了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","巴勒聽見巴蘭來了，就來到邊界盡頭、亞嫩河邊的摩押城迎接他。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","巴勒對巴蘭說：「上次派人請你，你為何不肯來？難道我不能給你重賞嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","巴蘭對巴勒說：「現在我已經來了，但我不能隨便發言，我只能按上帝的指示說話。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","巴蘭和巴勒一同來到基列·胡瑣。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","巴勒宰牛殺羊賞給巴蘭和隨行的官長。 ");
INSERT INTO cmncbt_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","次日清晨，巴勒領巴蘭上到巴末·巴力，從那裡可以看到一部分以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","巴蘭對巴勒說：「你在這裡為我築七座祭壇，預備七頭公牛和七隻公綿羊。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","巴勒就照巴蘭的話做了。他們二人在每座壇上獻上一頭公牛和一隻公綿羊， ");
INSERT INTO cmncbt_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","巴蘭對巴勒說：「你留在燔祭旁邊，我到前面去，也許耶和華會向我顯現。無論祂有什麼指示，我必告訴你。」巴蘭就上到一處光禿禿的高地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","上帝向巴蘭顯現。巴蘭對上帝說：「我已經預備了七座祭壇，每座祭壇上獻了一頭公牛和一隻公綿羊。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","耶和華告訴他當說的話，命他回去轉告巴勒。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","巴蘭就回到巴勒那裡，看見他和摩押的官長都站在燔祭旁邊。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","巴蘭吟詩預言說： 「巴勒領我出亞蘭， 摩押王請我出東山， 說，『來為我咒詛雅各， 來斥責以色列！』 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","上帝沒有咒詛的， 我怎能咒詛？ 耶和華沒有斥責的， 我怎能斥責？ ");
INSERT INTO cmncbt_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","我從峰頂觀看他們， 從高崗眺望他們， 這獨居一方之民， 不與萬國同列。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","雅各的子孫多如塵土， 誰能數得清？ 誰能數清以色列人的四分之一？ 我願像義人一樣死去， 如義人般終此一生。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","巴勒對巴蘭說：「你這是做什麼？我請你來咒詛我的仇敵，你竟祝福他們！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","巴蘭說：「耶和華讓我說的話，我豈能不說？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","巴勒說：「請你跟我去另一個地方，那裡看不見全部以色列人，只能看見一部分，你要在那裡為我咒詛他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","他領巴蘭上到毗斯迦山頂的瑣腓田，在那裡築了七座祭壇，每座壇上都獻了一頭公牛和一隻公綿羊。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","巴蘭對巴勒說：「你留在這些燔祭旁邊，我到那邊去見耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","耶和華向巴蘭顯現，告訴他當說的話，讓他轉告巴勒。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","巴蘭回到巴勒那裡，看見他和摩押的官長都站在燔祭旁邊。巴勒問道：「耶和華說了什麼？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","巴蘭吟詩預言說： 「巴勒啊，要留心聽！ 西撥的兒子啊，請聽我言。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","上帝並非世人，祂不撒謊； 上帝不是凡人，祂不反悔。 祂言出必行，信守承諾。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","我奉命祝福，祂已賜福， 我不能改變。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","雅各的子孫中未見有罪惡， 以色列人中看不見有禍患。 他們的上帝耶和華與他們同在， 他們向自己的君王歡呼。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","上帝帶他們出埃及， 祂的力量如野牛之角。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","沒有邪術能害雅各， 沒有咒語可傷以色列。 時候一到，人們必談論雅各， 談論以色列，說，『看啊， 上帝的作為何等偉大！』 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","看啊，這民族挺身如母獅， 躍起像雄獅， 不吞食獵物、 不喝獵物的血不躺臥。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","巴勒對巴蘭說：「你可以不咒詛他們，但也不該為他們祝福啊！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","巴蘭回答說：「我不是說過，我必須按耶和華的指示做嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","巴勒說：「來吧，我帶你去另一個地方，也許上帝會同意你在那裡為我咒詛他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","他領著巴蘭登上俯瞰曠野的毗珥山頂。 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","巴蘭對巴勒說：「你在這裡為我築七座祭壇，預備七頭公牛和七隻公綿羊。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","巴勒就照巴蘭的話，在每座祭壇上獻了一頭公牛和一隻公綿羊。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","巴蘭見耶和華樂意賜福給以色列人，就不再像先前兩次那樣去求兆頭，而是轉向曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","他舉目眺望，看見以色列人按支派紮營。上帝的靈降在他身上， ");
INSERT INTO cmncbt_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","他便吟詩預言說： 「比珥之子巴蘭的預言， 是眼睛明亮者的話， ");
INSERT INTO cmncbt_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","他得聽上帝之言， 俯伏在地，眼目睜開 得見全能者的異象。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","雅各啊， 你的帳篷何等華美！ 以色列啊， 你的居所何等佳美！ ");
INSERT INTO cmncbt_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","像連綿的山谷， 如河畔的園子； 像耶和華栽種的沉香， 如水邊的香柏樹。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","他們沐浴充沛的甘霖， 撒種於濕潤的沃土。 他們的君王高過亞甲， 國度名震四方。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","上帝帶他們出埃及， 祂的力量如野牛之角。 他們要吞滅敵國， 打碎敵人的骨頭， 用利箭射穿仇敵。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","他們蹲伏如雄獅， 躺臥如母獅，誰敢招惹？ 願祝福他們的人蒙祝福！ 願咒詛他們的人受咒詛！」 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","巴勒聽了大怒，用力擊掌，對巴蘭說：「我請你來咒詛我的仇敵，你竟三次祝福他們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","現在快回家去吧！我說過要給你重賞，但耶和華不讓你得到。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","巴蘭說：「我不是對你派來的使臣說過嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","就是你把滿屋的金銀都給我，我也不能違背耶和華的命令、憑自己的意思行事——無論好事壞事。我只能說耶和華讓我說的話。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","現在我要回本族去了。但我要告訴你日後以色列人會怎樣對待你的人民。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","巴蘭吟詩預言說： 「比珥之子巴蘭的預言， 是眼睛明亮者的話， ");
INSERT INTO cmncbt_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","他得聽上帝之言， 明白至高者的旨意， 俯伏在地，眼目睜開， 得見全能者的異象。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","我所見的尚未發生， 我目睹的關乎將來。 一顆星要從雅各家升起， 一位君王要從以色列興起。 他要打爛摩押的前額， 擊碎塞特人的頭顱。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","他必征服以東， 佔領敵疆西珥， 以色列必勇往直前。 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","雅各的後裔必掌權， 消滅城中的餘民。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","巴蘭觀看亞瑪力人，並以詩歌預言說： 「亞瑪力原是列國之首， 但他的結局卻是滅亡。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","巴蘭又觀看基尼人，並以詩歌預言說： 「雖然你的居所堅固， 你的巢築在峭壁， ");
INSERT INTO cmncbt_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","但你必遭滅頂， 被亞述擄去。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","巴蘭又以詩歌預言說： 「唉！若上帝做這事， 誰能存活呢？ ");
INSERT INTO cmncbt_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","船隻從基提駛來， 征服亞述和希伯， 但他也要滅亡。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","說完，巴蘭動身返回家鄉，巴勒也回去了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","以色列人駐紮在什亭期間，有些人與摩押女子行淫。 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","那些女子邀這些人祭祀她們的神明，他們吃了祭物，並跪拜她們的神明。 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","結果以色列與巴力·毗珥苟合。耶和華大怒， ");
INSERT INTO cmncbt_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","對摩西說：「把為首的人都抓起來，當著我的面在大白天處死他們，以消除我對以色列人的怒氣。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","於是，摩西對以色列的審判官說：「你們各自把手下與巴力·毗珥苟合的人處死。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","摩西和以色列全體會眾正在會幕門口痛哭的時候，有個以色列人當著他們的面，把一個米甸女子帶進自家的帳篷。 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","亞倫祭司的孫子、以利亞撒的兒子非尼哈看見了，便起身離開會眾，拿著矛槍， ");
INSERT INTO cmncbt_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","跟著進入那人的帳篷，用槍刺透那對男女的腹部。以色列人當中的瘟疫馬上止住了， ");
INSERT INTO cmncbt_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","但已有兩萬四千人死於瘟疫。 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","「亞倫祭司的孫子、以利亞撒的兒子非尼哈，消了我對以色列人的怒氣。因為在會眾中他與我一樣痛恨不貞，我才沒有憤然消滅他們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","你告訴他，我要賜給他平安的約， ");
INSERT INTO cmncbt_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","使他和他的後代憑此約可以永遠做祭司，因為他為我除掉了不貞之人，為以色列人贖了罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","與米甸女子一同被殺的以色列人名叫心利，是撒路的兒子，是西緬支派的一個族長。 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","被殺的米甸女子名叫哥斯比，她父親蘇珥是米甸人的一個族長。 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","「你要攻打米甸人，擊殺他們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","因為他們心存惡意，在毗珥陷害你們，他們的姊妹——米甸首領的女兒哥斯比誘惑你們，她在毗珥事件招來瘟疫之日被殺。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","瘟疫過後，耶和華對摩西和亞倫祭司的兒子以利亞撒說： ");
INSERT INTO cmncbt_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","「你們要統計以色列全體會眾的人數，按家係登記所有二十歲以上、有作戰能力的男子。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","摩西和以利亞撒祭司就在約旦河邊、耶利哥對面的摩押平原對以色列人說： ");
INSERT INTO cmncbt_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","「你們要按照耶和華對摩西的吩咐，統計二十歲以上的男子。」 以下是從埃及出來的以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","以色列的長子是呂便，呂便的子孫有哈諾族、法路族、 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","希斯倫族和迦米族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","這些是呂便的各宗族，共登記了四萬三千七百三十人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","法路的兒子是以利押， ");
INSERT INTO cmncbt_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","以利押的兒子是尼姆利、大坍和亞比蘭。大坍、亞比蘭原是會眾所推選的首領，他們與可拉一夥，一起反叛摩西和亞倫，反叛耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","以致大地裂開，將他們全部吞了下去，當時大火還燒滅了二百五十人。他們成了後人的警戒。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","然而，可拉的子孫沒有被滅絕。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","按著宗族，西緬的子孫有尼姆利族、雅憫族、雅斤族、 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","謝拉族和掃羅族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","這些是西緬的各宗族，共登記了兩萬二千二百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","按著宗族，迦得的子孫有洗分族、哈基族、書尼族、 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","阿斯尼族、以利族、 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","亞律族和亞列利族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","這些是迦得的各宗族，共登記了四萬零五百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","珥和俄南是猶大的兒子，他們死在了迦南。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","按著宗族，猶大的子孫有示拉族、法勒斯族、謝拉族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","法勒斯的子孫有希斯崙族和哈姆勒族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","這些是猶大的各宗族，共登記了七萬六千五百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","按著宗族，以薩迦的子孫有陀拉族、普瓦族、 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","雅述族和伸崙族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","這些是以薩迦各宗族，共登記了六萬四千三百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","按著宗族，西布倫的子孫有西烈族、以倫族和雅利族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","這些是西布倫的各宗族，共登記了六萬零五百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","按著宗族，約瑟的兒子有瑪拿西和以法蓮。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","瑪拿西的子孫有瑪吉族和基列族。基列是瑪吉的兒子。基列族來自基列。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","基列的子孫有伊以謝族、希勒族、 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","亞斯烈族、示劍族、 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","示米大族和希弗族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","希弗的兒子西羅非哈沒有兒子，只有女兒瑪拉、挪阿、曷拉、密迦和得撒。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","這些是瑪拿西的各宗族，共登記了五萬二千七百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","按著宗族，以法蓮的子孫有書提拉族、比結族和他罕族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","書提拉的子孫有以蘭族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","這些是以法蓮各宗族，共登記了三萬二千五百人，他們按宗族都是約瑟的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","按著宗族，便雅憫的子孫有比拉族、亞實別族、亞希蘭族、 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","書反族和戶反族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","比拉的子孫有亞勒族和乃幔族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","這些是便雅憫的各宗族，共登記了四萬五千六百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","按著宗族，但的子孫有書含族，書含族來自書含，這些是但的宗族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","書含族共登記了六萬四千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","按著宗族，亞設的子孫有音拿族、亦施韋族和比利亞族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","比利亞的子孫有希別族和瑪結族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","亞設的女兒名叫西拉。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","這些是亞設的各宗族，共登記了五萬三千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","按著宗族，拿弗他利的子孫有雅薛族、沽尼族、 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","耶色族和示冷族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","這些是拿弗他利的各宗族，共登記了四萬五千四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","登記的以色列男子共有六十萬一千七百三十人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","「你要按著各支派登記的人數，把土地分給他們作產業； ");
INSERT INTO cmncbt_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","人數多的多分產業，人數少的少分產業，要按登記的人數分配。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","以色列人要按各自的支派抽籤分地，承受產業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","無論大小支派，都要用抽籤的方法分配產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","按著宗族，利未的子孫有革順族、哥轄族和米拉利族。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","立尼族、希伯倫族、瑪利族、姆示族和可拉族也是利未的子孫。哥轄生暗蘭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","暗蘭的妻子叫約基別，是利未女子，出生在埃及。她給暗蘭生了亞倫、摩西和他們的姐姐米利暗。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","亞倫生拿答、亞比戶、以利亞撒和以他瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","拿答和亞比戶在用凡火向耶和華獻祭時死去了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","利未人中一個月以上的男性共登記了兩萬三千人，他們的人數沒有登記在以色列人中，因為他們在以色列人中不分產業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","以上是摩西和以利亞撒祭司在約旦河邊、耶利哥對面的摩押平原統計的以色列人數， ");
INSERT INTO cmncbt_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","其中沒有一個是摩西和祭司亞倫從前在西奈曠野登記的以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","因為耶和華說過，那批人都要死在曠野。所以，除了耶孚尼的兒子迦勒和嫩的兒子約書亞以外，上次登記的人無一存活。 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","西羅非哈是約瑟之子瑪拿西的玄孫、瑪吉的曾孫、基列的孫子、希弗的兒子。他的女兒是瑪拉、挪阿、曷拉、密迦和得撒。她們前來， ");
INSERT INTO cmncbt_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","站在會幕門口對摩西、以利亞撒祭司、眾首領和全體會眾說： ");
INSERT INTO cmncbt_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","「我們的父親死在曠野，他並沒有跟可拉一夥一起反叛耶和華，而是因自己的罪而死，沒有留下兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","難道因為他沒有兒子，他的名字就要從族中消失嗎？請讓我們在父親的家族中分一份產業吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","摩西就把她們的請求呈到耶和華面前。 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","「西羅非哈的女兒說得有理。你要從她們父親的家族中分一份產業給她們，讓她們繼承父親的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","你要告訴以色列人，『人死後如果沒有兒子，就由女兒繼承產業； ");
INSERT INTO cmncbt_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","如果沒有女兒，就由其兄弟繼承； ");
INSERT INTO cmncbt_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","如果沒有兄弟，就由其父的兄弟繼承； ");
INSERT INTO cmncbt_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","如果其父沒有兄弟，就由其族中最近的親屬繼承。』」這是耶和華吩咐摩西頒佈給以色列人的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","耶和華對摩西說：「你上這亞巴琳山去看看我賜給以色列人的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","看了以後，你就要像你哥哥亞倫一樣歸到祖先那裡了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","因為會眾在荀曠野反叛我的時候，你們二人違背我的命令，在取水的事上沒有在他們面前尊我為聖。」這是指米利巴泉事件，發生在荀曠野的加低斯。 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","摩西對耶和華說： ");
INSERT INTO cmncbt_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","「耶和華啊，你是賜人生命的上帝，求你立一個人做會眾的首領， ");
INSERT INTO cmncbt_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","在前面帶領他們或進或退，免得你的會眾像沒有牧人的羊群。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","耶和華對摩西說：「嫩的兒子約書亞心裡有聖靈，你把他召來，把手按在他身上， ");
INSERT INTO cmncbt_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","讓他站在以利亞撒祭司和全體會眾面前，當著他們的面任命他做首領， ");
INSERT INTO cmncbt_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","把你的權柄賜給他，使以色列全體會眾都聽從他。 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","他要去以利亞撒祭司那裡，讓祭司藉著烏陵為他求問我。他和全體會眾或進或出，都要聽從以利亞撒的指示。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","摩西遵命而行，把約書亞召來，讓他站在以利亞撒祭司和全體會眾面前， ");
INSERT INTO cmncbt_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","然後照耶和華對摩西的吩咐把手按在他頭上，任命他做首領。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","「你要吩咐以色列人，在規定的時間獻上蒙我悅納的馨香火祭，作為我的食物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","以下是他們要獻給耶和華的火祭：每天兩隻毫無殘疾、一歲的公羊羔作日常燔祭， ");
INSERT INTO cmncbt_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","早晨和黃昏各獻一隻， ");
INSERT INTO cmncbt_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","同時獻上一公斤細麵粉，並調上一升橄欖油作素祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","這是在西奈山上規定的日常燔祭，是獻給耶和華的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","與每隻羊羔一同獻上的還有一升酒，要將酒灑在聖所，作為獻給耶和華的奠祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","黃昏獻第二隻羊羔時，也要跟早晨一樣同時獻上素祭和奠祭，作為蒙耶和華悅納的馨香火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","「安息日，要獻兩隻毫無殘疾、一歲的公羊羔，同時獻上奠祭以及兩公斤調油的細麵粉作素祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","這是在日常燔祭和奠祭以外安息日所獻的燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","「在朔日，要給耶和華獻燔祭——兩頭公牛犢、一隻公綿羊和七隻一歲公羊羔，都要毫無殘疾。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","同時要獻上調了油的細麵粉作素祭，每頭公牛需獻三公斤素祭，每隻公綿羊需獻兩公斤素祭， ");
INSERT INTO cmncbt_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","每隻公羊羔需獻一公斤素祭。這馨香的燔祭是獻給耶和華的火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","獻燔祭時要同時獻上奠祭，每頭公牛需獻二升奠酒，每隻公綿羊需獻一升半奠酒，每隻羊羔需獻一升奠酒。這是朔日要獻的燔祭，一年之中月月如此。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","除了日常的燔祭和奠祭以外，還要把一隻公山羊獻給耶和華作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","「一月十四日是耶和華的逾越節， ");
INSERT INTO cmncbt_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","十五日開始節慶，你們要連續七天吃無酵餅。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","第一天要舉行聖會，不可做日常工作。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","你們要把毫無殘疾的兩頭公牛犢、一隻公綿羊和七隻一歲的公羊羔，獻給耶和華作燔祭； ");
INSERT INTO cmncbt_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","同時要獻上調了油的細麵粉作素祭，每頭公牛需獻三公斤素祭，每隻公綿羊需獻兩公斤素祭， ");
INSERT INTO cmncbt_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","每隻公羊羔需獻一公斤素祭； ");
INSERT INTO cmncbt_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","同時還要獻一隻公山羊作贖罪祭，為你們贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","除了早晨獻的日常燔祭以外，要獻上這些祭物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","接連七天，除了日常的燔祭和同獻的奠祭以外，還要照上面的規定給耶和華獻上馨香的火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","第七天，你們要舉行聖會，不可做日常工作。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","「七七收穫節莊稼初熟之日，就是你們把新素祭獻給耶和華的日子，要召開聖會，不可做日常工作。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","你們要把兩頭公牛犢、一隻公綿羊和七隻一歲的公羊羔，獻給耶和華作馨香的燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","同時要獻上調了油的細麵粉作素祭，每頭公牛需獻三公斤素祭，每隻公綿羊需獻兩公斤素祭， ");
INSERT INTO cmncbt_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","每隻公羊羔需獻一公斤素祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","此外，還要獻上一隻公山羊作贖罪祭，為你們贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","除了日常的燔祭和同獻的素祭以外，還要獻上奠祭。祭牲不可有殘疾。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","「七月一日，你們要舉行聖會，吹響號角，不可做日常工作。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","你們要把馨香的燔祭獻給耶和華，即毫無殘疾的公牛犢一頭、公綿羊一隻和一歲的公羊羔七隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","同時要獻上調了油的細麵粉作素祭，每頭公牛犢需獻三公斤素祭，每隻公綿羊需獻兩公斤素祭， ");
INSERT INTO cmncbt_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","每隻公羊羔需獻一公斤素祭； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","還要獻上一隻公山羊作贖罪祭，為你們贖罪。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","此外，要照常獻上朔日和日常應獻的燔祭、素祭和奠祭，給耶和華作馨香的火祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","「七月十日，你們要舉行聖會，禁食，不可工作。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","你們要給耶和華獻上馨香的燔祭，即毫無殘疾的公牛犢一頭、公綿羊一隻和一歲的公羊羔七隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","同時要獻上調了油的細麵粉作素祭，每頭公牛犢需獻三公斤素祭，每隻公綿羊需獻兩公斤素祭， ");
INSERT INTO cmncbt_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","每隻公羊羔需獻一公斤素祭； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","還要獻上一隻公山羊作贖罪祭。此外，要照常獻上贖罪祭和日常獻的燔祭、素祭和奠祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","「在七月十五日那一天，你們要舉行聖會，不可做日常工作，為耶和華守節期七天。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","你們要給耶和華獻上馨香的燔祭作火祭，即毫無殘疾的公牛犢十三頭、公綿羊兩隻和一歲的公羊羔十四隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","同時要獻上調了油的細麵粉作素祭，每頭公牛犢需獻三公斤素祭，每隻公綿羊需獻兩公斤素祭， ");
INSERT INTO cmncbt_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","每隻公羊羔需獻一公斤素祭； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","除了日常獻的燔祭、素祭和奠祭以外，還要獻上一隻公山羊作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","「節期的第二天，你們要獻上毫無殘疾的公牛犢十二頭、公綿羊兩隻和一歲的公羊羔十四隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","同時要按規定的量把素祭和奠祭與公牛、公綿羊和公羊羔一起獻上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","除了日常獻的燔祭、素祭和奠祭以外，還要獻上一隻公山羊作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","「節期的第三天，你們要獻上毫無殘疾的公牛十一頭、公綿羊兩隻和一歲的公羊羔十四隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","同時要按規定的量把素祭和奠祭與公牛、公綿羊和公羊羔一起獻上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","除了日常獻的燔祭、素祭和奠祭以外，還要獻上一隻公山羊作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","「節期的第四天，你們要獻上毫無殘疾的公牛十頭、公綿羊兩隻和一歲的公羊羔十四隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","同時要按規定的量把素祭和奠祭與公牛、公綿羊和公羊羔一起獻上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","除了日常獻的燔祭、素祭和奠祭以外，還要獻上一隻公山羊作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","「節期的第五天，你們要獻上毫無殘疾的公牛九頭、公綿羊兩隻和一歲的公羊羔十四隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","同時要按規定的量把素祭和奠祭與公牛、公綿羊和公羊羔一起獻上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","除了日常獻的燔祭、素祭和奠祭以外，還要獻上一隻公山羊作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","「節期的第六天，你們要獻上毫無殘疾的公牛八頭、公綿羊兩隻和一歲的公羊羔十四隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","同時要按規定的量把素祭和奠祭與公牛、公綿羊和公羊羔一起獻上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","除了日常獻的燔祭、素祭和奠祭以外，還要獻上一隻公山羊作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","「節期的第七天，你們要獻上毫無殘疾的公牛七頭、公綿羊兩隻和一歲的公羊羔十四隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","同時要按規定的量把素祭和奠祭與公牛、公綿羊和公羊羔一起獻上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","除了日常獻的燔祭、素祭和奠祭以外，還要獻上一隻公山羊作為贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","「節期的第八天，你們不可做日常工作，要舉行莊嚴的聚會。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","你們要給耶和華獻上馨香的燔祭作火祭，即毫無殘疾的公牛一頭、公綿羊一隻和一歲的公羊羔七隻； ");
INSERT INTO cmncbt_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","同時要按規定的量把素祭和奠祭與公牛、公綿羊和公羊羔一起獻上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","除了日常獻的燔祭、素祭和奠祭以外，還要獻上一隻公山羊作贖罪祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","「這些是你們在節期內要獻給耶和華的祭物，此外還有你們許願和自願獻的燔祭、素祭、奠祭和平安祭。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","摩西把耶和華的一切吩咐傳達給以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","摩西對以色列各支派的首領說：「以下是耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","「人若在什麼事上向耶和華許願或起誓，就不可食言，必須履行諾言。 ");
INSERT INTO cmncbt_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","倘若未出嫁的少女在什麼事上向耶和華許願或起誓， ");
INSERT INTO cmncbt_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","她父親得知她許的願或起的誓後沒有反對，她許的願和起的誓就都有效； ");
INSERT INTO cmncbt_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","倘若她父親得知後加以反對，她許的願和起的誓就無效。耶和華必不追究她，因為她父親反對。 ");
INSERT INTO cmncbt_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","「倘若有女子出嫁前許了願或信口起了誓， ");
INSERT INTO cmncbt_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","她丈夫得知後沒有反對，她許的願和起的誓就都有效； ");
INSERT INTO cmncbt_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","倘若她丈夫得知後加以反對，她許的願和起的誓就無效，耶和華必不追究她。 ");
INSERT INTO cmncbt_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","寡婦或被休的婦人若在什麼事上許願或起誓，就必須履行誓言。 ");
INSERT INTO cmncbt_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","「倘若已婚婦女在夫家許願或起誓， ");
INSERT INTO cmncbt_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","她丈夫得知後沒有反對，她許的願和起的誓就都有效； ");
INSERT INTO cmncbt_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","倘若她丈夫在得知當天加以否定，她口中許的願和起的誓就無效。她丈夫已經使之無效，耶和華必不追究她。 ");
INSERT INTO cmncbt_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","丈夫有權贊同或否定妻子禁食所許的願或起的誓。 ");
INSERT INTO cmncbt_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","倘若丈夫得知妻子許願或起誓當天一直沒有反對，她就必須履行誓言，因為丈夫當天默認了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","倘若丈夫當天默認了，後來又加以反對，他就要承擔妻子的罪責。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","以上是耶和華藉摩西頒佈的有關丈夫和妻子、父親和未出嫁的女兒要遵守的條例。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","「你要為以色列人向米甸人報仇，之後你將歸到祖先那裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","於是，摩西對民眾說：「你們的人要拿起兵器去攻打米甸，為耶和華報仇。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","以色列的每個支派要派一千人出戰。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","於是，他們從以色列每個支派選出一千人，武裝了一萬二千軍兵。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","每個支派選出的一千軍兵由摩西派遣出戰，以利亞撒祭司的兒子非尼哈拿著聖所的器具和號角隨行。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","他們照耶和華對摩西的吩咐，去攻打米甸人，殺死了米甸的所有男子， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","包括以未、利金、蘇珥、戶珥和利巴五個米甸的王，還殺了比珥的兒子巴蘭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","以色列人擄獲了米甸的婦女、孩子、所有牛羊和財物， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","將他們的城邑營寨付之一炬， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","帶走了擄掠的人畜等戰利品。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","他們來到耶利哥對面、約旦河邊的摩押平原，把戰利品交給摩西、以利亞撒祭司和以色列全體會眾。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","摩西、以利亞撒祭司以及所有民眾的首領，都到營外迎接他們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","摩西對出征回來的千夫長和百夫長等將領發怒， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","說：「你們為什麼讓這些婦女活著？ ");
INSERT INTO cmncbt_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","就是她們聽了巴蘭的指使，在毗珥引誘以色列人背叛耶和華，以致瘟疫降在耶和華的會眾身上。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","現在，你們要殺掉所有的男孩，以及與男人發生過關係的女子， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","但可以留下那些處女。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","你們凡殺了人和碰過死人的，都要在營外待七天。在第三天和第七天，你們要潔淨自己及擄來的人， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","也要潔淨自己所有的衣服、皮具、山羊毛製品和木器。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","以利亞撒祭司對打仗回來的軍兵說：「以下是耶和華藉摩西頒佈的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","金、銀、銅、鐵、錫、鉛， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","凡耐火之物都要用火來潔淨，還要用除穢水加以潔淨；不耐火之物要用水來潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","第七天，你們洗完衣服後就潔淨了，可以回營。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","「你和以利亞撒祭司以及會眾的各族長，要統計俘虜和牲畜的數目， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","然後把這些戰利品分成兩份，一份給出征的戰士，一份給其餘會眾。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","要從戰士分得的俘虜、牛、驢和羊群中抽出五百分之一，獻給耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","要把那五百分之一交給以利亞撒祭司，獻給耶和華作舉祭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","要從以色列人分得的俘虜和牛、驢、羊等牲畜中抽出五十分之一，交給在我聖幕司職的利未人。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","摩西和以利亞撒祭司遵命而行。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","戰士擄獲的戰利品中有六十七萬五千隻羊， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","七萬二千頭牛， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","六萬一千頭驢， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","三萬二千名處女。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","戰士分得的戰利品有三十三萬七千五百隻羊， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","其中六百七十五隻獻給耶和華； ");
INSERT INTO cmncbt_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","三萬六千頭牛，其中七十二頭獻給耶和華； ");
INSERT INTO cmncbt_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","三萬零五百頭驢，其中六十一頭獻給耶和華； ");
INSERT INTO cmncbt_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","一萬六千名處女，其中三十二人獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","摩西照耶和華的吩咐，把獻給耶和華的舉祭交給以利亞撒祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","以色列會眾分得的那一半戰利品，即摩西從出征之人的戰利品中分出來給他們的， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","有三十三萬七千五百隻羊、 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","三萬六千頭牛、 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","三萬零五百頭驢、 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","一萬六千名處女。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","摩西照耶和華的吩咐，從中抽出五十分之一，交給在聖幕裡司職的利未人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","統領軍隊的千夫長和百夫長來見摩西， ");
INSERT INTO cmncbt_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","說：「僕人們統計了手下出征的戰士，未失一兵一卒。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","現在我們把各自擄獲的臂環、鐲子、圖章戒指、耳環、項鏈等金器，都帶來獻給耶和華，在祂面前為我們贖罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","摩西和以利亞撒祭司收了他們所獻的各種金製品。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","千夫長和百夫長獻給耶和華作舉祭的金子共三千八百兩。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","戰士則保留了自己擄獲的財物。 ");
INSERT INTO cmncbt_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","摩西和以利亞撒祭司就把千夫長和百夫長獻的金子帶進會幕，在耶和華面前作以色列人的紀念。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","呂便和迦得的子孫有許多牲畜，他們見雅謝和基列適於放牧， ");
INSERT INTO cmncbt_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","就來見摩西、以利亞撒祭司和會眾的首領，說： ");
INSERT INTO cmncbt_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","「亞他錄、底本、雅謝、寧拉、希實本、以利亞利、示班、尼波和比穩—— ");
INSERT INTO cmncbt_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","這些耶和華為以色列會眾攻取的地方適於放牧，而僕人們有許多牲畜。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","如果你們恩待我們，請將這些地方賜給我們作產業，別讓我們過約旦河了。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","摩西對他們說：「難道你們的同胞去打仗，你們卻坐在這裡嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","你們為何使以色列人軍心動搖，不敢進入耶和華所賜之地？ ");
INSERT INTO cmncbt_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","從前我在加低斯·巴尼亞派你們的祖先去打探那地方的時候，他們就是這樣。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","他們到以實各谷打探那地方，回來後竟動搖軍心，使以色列人不敢進入耶和華所賜之地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","那天耶和華發怒，起誓說， ");
INSERT INTO cmncbt_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","『從埃及出來、二十歲以上的人都看不到我起誓要賜給亞伯拉罕、以撒和雅各的土地，因為他們沒有一心追隨我； ");
INSERT INTO cmncbt_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","只有基尼洗族耶孚尼的兒子迦勒和嫩的兒子約書亞可以看到，因為他們一心追隨我。』 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","耶和華向以色列人發怒，使他們在曠野漂泊了四十年，直到在耶和華面前作惡的那一代都死了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","「現在，你們這群罪人的後代竟然重蹈前人的覆轍，加劇耶和華向以色列所發的怒氣。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","如果你們離棄祂，祂必再次把以色列人丟棄在曠野，這樣你們就毀了整個民族。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","他們上前對摩西說：「我們要在這裡為牲畜建棚圈，為家小築城邑， ");
INSERT INTO cmncbt_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","讓他們留在堅固的城內，免受當地居民的威脅。然後我們必拿起兵器率先上陣，直到幫其他以色列同胞奪取他們的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","在其他同胞佔領各自的產業之前，我們決不回家。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","但我們不會跟他們在約旦河西岸分土地，我們已經得到約旦河東邊作產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","摩西說：「如果你們信守承諾，拿起兵器在耶和華面前出戰， ");
INSERT INTO cmncbt_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","你們全軍就要在耶和華面前渡過約旦河，直到祂趕走祂面前的仇敵， ");
INSERT INTO cmncbt_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","征服那地方。之後，你們才可以回家，才算在耶和華和以色列人面前盡了自己的責任，這地方就在耶和華面前歸給你們作產業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","但你們如果不這樣做，就是得罪耶和華，必難逃罪責。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","你們現在去為家小築城邑，為牛羊建棚圈吧，但別忘了信守承諾。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","迦得和呂便的子孫對摩西說：「僕人們一定遵命而行。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","我們的妻子、孩子、牛羊等牲畜都會留在基列的各城。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","僕人當中所有能上陣打仗的人都會照你的吩咐在耶和華面前過河作戰。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","於是，摩西對以利亞撒祭司、嫩的兒子約書亞和以色列各支派的族長說： ");
INSERT INTO cmncbt_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","「如果迦得和呂便子孫中所有能上陣打仗的人，在耶和華面前跟你們一同過河作戰，你們征服那片土地以後，就要把基列給他們作產業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","如果他們不帶著兵器跟你們一起過河作戰，就只能在迦南與你們同分產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","迦得和呂便的子孫再次說：「凡耶和華所吩咐的，僕人們一定照辦。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","我們一定帶著兵器在耶和華面前過河，進入迦南，但我們要擁有約旦河東邊作產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","摩西就把亞摩利王西宏和巴珊王噩的國土及周圍的城邑，都給了迦得的子孫、呂便的子孫和約瑟兒子瑪拿西的半個支派。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","迦得的子孫重建了底本、亞他錄、亞羅珥、 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","亞他錄·朔反、雅謝、約比哈、 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","伯·寧拉和伯·哈蘭，使之成為堅固的城池，並建了羊圈。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","呂便的子孫重建了希實本、以利亞利、基列亭、 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","尼波、巴力·免和西比瑪。他們為重建的城邑起了新名字，如尼波和巴力·免。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","瑪拿西之子瑪吉的子孫佔領了基列，趕走了那裡的亞摩利人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","摩西就把基列賜給瑪拿西的兒子瑪吉，他便住在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","瑪拿西的子孫雅珥佔領了基列的村莊，將它們改名為哈倭特·雅珥。 ");
INSERT INTO cmncbt_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","挪巴佔領了基納及其周圍的村莊，就按自己的名字稱基納為挪巴。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","以下是以色列人在摩西和亞倫的領導下離開埃及列隊行軍的路線。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","摩西遵照耶和華的吩咐記錄啟行的地點，以下是他們停留過的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","一月十五日，即逾越節的第二天，埃及人眼睜睜地看著以色列人昂首挺胸地離開了蘭塞。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","當時埃及人正埋葬他們的長子，耶和華擊殺了他們當中的長子，並懲罰了他們的眾神明。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","以色列人從蘭塞啟行，至疏割紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","從疏割啟行，至曠野邊界的以倘紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","從以倘啟行，又轉到巴力·洗分對面的比哈·希錄，在密奪附近紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","從比哈·希錄啟行，經過紅海到書珥曠野，在伊坦曠野走了三天，至瑪拉紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","從瑪拉啟行，至以琳紮營，那裡有十二股水泉和七十棵棕樹； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","從以琳啟行，至紅海岸邊紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","從紅海啟行，至汛曠野紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","從汛曠野啟行，至脫加紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","從脫加啟行，至亞錄紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","從亞錄啟行，至利非訂紮營，在那裡民眾沒有水喝； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","從利非訂啟行，至西奈曠野紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","從西奈曠野啟行，至基博羅·哈他瓦紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","從基博羅·哈他瓦啟行，至哈洗錄紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","從哈洗錄啟行，至利提瑪紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","從利提瑪啟行，至臨門·帕烈紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","從臨門·帕烈啟行，至立拿紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","從立拿啟行，至勒撒紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","從勒撒啟行，至基希拉他紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","從基希拉他啟行，至沙斐山紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","從沙斐山啟行，至哈拉大紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","從哈拉大啟行，至瑪吉希錄紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","從瑪吉希錄啟行，至他哈紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","從他哈啟行，至他拉紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","從他拉啟行，至密加紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","從密加啟行，至哈摩拿紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","從哈摩拿啟行，至摩西錄紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","從摩西錄啟行，至比尼·亞干紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","從比尼·亞干啟行，至曷·哈吉甲紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","從曷·哈吉甲啟行，至約巴他紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","從約巴他啟行，至阿博拿紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","從阿博拿啟行，至以旬·迦別紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","從以旬·迦別啟行，至荀曠野的加低斯紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","從加低斯啟行，至以東邊界的何珥山紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","以色列人離開埃及後的第四十年五月一日，亞倫祭司遵照耶和華的吩咐上了何珥山，並在那裡離世， ");
INSERT INTO cmncbt_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","享年一百二十三歲。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","在南地的迦南人亞拉得王得知了以色列人要來的消息。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","以色列人從何珥山啟行，至撒摩拿紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","從撒摩拿啟行，至普嫩紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","從普嫩啟行，至阿伯紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","從阿伯啟行，至摩押邊境的以耶·亞巴琳紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","從以耶·亞巴琳啟行，至底本·迦得紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","從底本·迦得啟行，至亞門·低比拉太音紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","從亞門·低比拉太音啟行，至尼波對面的亞巴琳山紮營； ");
INSERT INTO cmncbt_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","從亞巴琳山啟行，至耶利哥對面、約旦河邊的摩押平原紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","他們沿著約旦河在摩押平原紮營，營地從伯·耶施末一直延伸到亞伯·什亭。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","耶和華在耶利哥對面、約旦河邊的摩押平原對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","「你告訴以色列人，『你們過約旦河進了迦南以後， ");
INSERT INTO cmncbt_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","一定要趕走當地的居民，毀掉他們一切的石像和鑄像，拆毀他們所有的邱壇。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","你們要佔領那片土地，住在那裡，因為我已經把那裡賜給你們作產業了。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","你們要按宗族抽籤分配土地，人口多的多分，人口少的少分，抽到哪塊地就得哪塊地。你們要按照支派分配土地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","如果你們不趕走那裡的居民，留下來的人必成為你們眼裡的刺和肋旁的荊棘，在你們所居之地攪擾你們， ");
INSERT INTO cmncbt_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","我也會用預備對付他們的方法來對付你們。』」 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","「你把以下指示告訴以色列人。 「你們進入賜給你們作產業的迦南後，你們四境的疆界如下： ");
INSERT INTO cmncbt_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","「南部疆界從荀曠野沿著以東邊界延伸，東起死海的盡頭， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","往南至亞克拉濱坡南面，經荀直到加低斯·巴尼亞南面，再延伸至哈薩·亞達，經押們， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","轉向埃及河，直到地中海。 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","「西部以地中海為界，這是你們西部的邊界。 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","「北部疆界從地中海開始直到何珥山， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","從何珥山再到哈馬口，經西達達、 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","西斐崙直到哈薩·以難。 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","「東部疆界從哈薩·以難一直劃到示番， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","從示番往南到亞延東面的利比拉，再往南到基尼烈湖東岸。 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","然後沿約旦河南下直到死海。這是你們國土四面的疆界。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","摩西又對以色列人說：「這就是耶和華吩咐用抽籤的方式分給你們九個半支派的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","呂便支派和迦得支派已經按著家係得到了他們的產業，瑪拿西半個支派也得到了他們的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","這兩個半支派的產業在耶利哥對面的約旦河東岸。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","「負責給你們分地的是以利亞撒祭司和嫩的兒子約書亞。 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","每支派要選出一位首領來協助分地。 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","「以下是這些首領的名字： 猶大支派耶孚尼的兒子迦勒， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","西緬支派亞米忽的兒子示姆利， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","便雅憫支派基斯倫的兒子以利達， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","但支派約利的兒子布基， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","約瑟之子瑪拿西支派以弗的兒子漢聶， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","以法蓮支派拾弗但的兒子基姆利， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","西布倫支派帕納的兒子以利撒番， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","以薩迦支派阿散的兒子帕鐵， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","亞設支派示羅米的兒子亞希忽， ");
INSERT INTO cmncbt_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","拿弗他利支派亞米忽的兒子比達黑。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","這些是奉耶和華之命在迦南給以色列人分產業的首領。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","在耶利哥對面、約旦河邊的摩押平原，耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","「你告訴以色列人，要從分得的產業中把一些城邑及其周圍的草場分給利未人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","城邑供他們居住，草場供他們牧放牛羊等牲畜。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","劃分給利未人的草場是從城牆往外延伸四百五十米， ");
INSERT INTO cmncbt_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","要以城為中心，東南西北四郊每邊向外量九百米，作利未人的草場。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","要分給利未人四十二座城邑，另外再加六座供誤殺人者逃命的避難城， ");
INSERT INTO cmncbt_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","共分給利未人四十八座城邑，包括城周圍的草場。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","以色列各支派要按比例從自己承受的產業中分一些城邑給利未人，人多的支派多給，人少的支派少給。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","「你要告訴以色列人，『你們過了約旦河進入迦南以後， ");
INSERT INTO cmncbt_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","要選一些城邑作為你們的避難城，供誤殺人者逃去避難， ");
INSERT INTO cmncbt_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","躲避復仇的人，以免誤殺人者未在會眾面前受審，便被殺死。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","你們要選六座城作為避難城， ");
INSERT INTO cmncbt_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","三座在約旦河東岸，三座在迦南。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","凡誤殺人的，無論是以色列人，還是在他們當中寄居的外族人，都可以逃到這些城避難。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","「『倘若有人用鐵器打人致死，他就是故意殺人，殺人犯必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","倘若有人用足以致命的石頭打人致死，他就是故意殺人，殺人犯必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","倘若有人用足以致命的木器打人致死，他就是故意殺人，殺人犯必須被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","報血仇的人要親自處死故意殺人者，一找到他就要處死他。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","倘若有人因仇恨把人推倒致死，或故意扔東西砸人致死， ");
INSERT INTO cmncbt_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","或因仇恨徒手傷人致死，他就是故意殺人，殺人犯必須被處死，報血仇的人一找到他就要處死他。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","「『倘若有人並非出於懷恨，而是偶然推倒人致死，或無意間扔東西砸人致死， ");
INSERT INTO cmncbt_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","或因沒有看見而扔石頭砸人致死，鑒於他與對方並非仇人，也無意加害對方， ");
INSERT INTO cmncbt_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","會眾就要照這些律例在誤殺人者與報血仇者之間做出判決。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","會眾要把誤殺人者從報血仇者手裡救出來，讓他回到他原先逃往的避難城。他要住在那裡，一直住到受聖油膏立的大祭司逝世。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","但倘若誤殺人者離開避難城， ");
INSERT INTO cmncbt_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","報血仇的人在城外找到他，將他殺死也不用擔血債。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","因為誤殺人者必須留在避難城內，等到大祭司逝世之後，才可返回家園。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","這是你們世世代代無論住在哪裡都要遵守的律例。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","「『倘若有人被控謀殺，必須有幾個人作證才可以處死他，不可憑一個人的證詞處死他。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","犯了死罪的殺人犯必須償命，不可讓他付贖金免死。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","不可收逃進避難城之人的贖金，讓他在大祭司逝世前返回家園。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","這樣，你們就不致玷污你們所居住的土地，因為血會玷污土地。除非用兇手的血作抵償，否則被血玷污的土地無法得到潔淨。 ");
INSERT INTO cmncbt_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","不可玷污你們所居住的土地，那也是我居住的地方，因為我耶和華住在以色列人中間。』」 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","基列是約瑟之子瑪拿西的孫子，瑪吉的兒子。他宗族中的各族長來見摩西和做以色列人首領的各族長，說： ");
INSERT INTO cmncbt_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","「耶和華曾吩咐我主用抽籤的方式把土地分給以色列人，還吩咐我主將我們兄弟西羅非哈的產業分給他的女兒們。 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","但如果她們嫁給以色列其他支派的人，從我們祖業中分給她們的產業就會歸入她們夫家的支派。這樣的話，我們抽籤分到的土地就會減少。 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","到了以色列人的禧年，她們所得的產業就會歸給她們丈夫的支派，我們支派的祖業就會失去她們那份產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","摩西照耶和華的話吩咐以色列人說：「約瑟支派的人說的對。 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","關於西羅非哈的女兒們，耶和華說她們可以自由嫁人，但必須嫁給本支派的人。 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","以色列人的產業不可從一個支派轉到另一個支派，各支派必須守住本支派的祖業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","在以色列各支派中繼承了產業的女子必須嫁給本支派的人，以便以色列人都能守住自己的祖業。 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","以色列人的產業不可從一個支派轉到另一個支派，以色列各支派必須守住本支派的產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","於是，西羅非哈的女兒們遵行了耶和華對摩西的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","瑪拉、得撒、曷拉、密迦和挪阿都嫁給了她們叔伯的兒子， ");
INSERT INTO cmncbt_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","即約瑟之子瑪拿西支派的人。這樣，她們的產業仍留在本支派中。 ");
INSERT INTO cmncbt_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","以上是在耶利哥對面、約旦河邊的摩押平原，耶和華藉摩西頒佈給以色列人的命令和律例。");
INSERT INTO cmncbt_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","以下是摩西對以色列人說的話。當時以色列人在約旦河東的曠野、疏弗對面的亞拉巴，即巴蘭、陀弗、拉班、哈洗錄和底撒哈之間。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","從何烈山取道西珥山到加低斯·巴尼亞，需十一天。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","在離開埃及後第四十年的十一月一日，摩西把耶和華的一切吩咐告訴了以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","那時，他已經打敗了希實本的亞摩利王西宏，以及盤踞在以得來和亞斯她錄的巴珊王噩。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","摩西在約旦河東的摩押講解律法，說： ");
INSERT INTO cmncbt_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","「我們的上帝耶和華在何烈山對我們說，『你們在這山上已經住了足夠時日， ");
INSERT INTO cmncbt_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","現在該啟程前往亞摩利人的山區、亞拉巴地區、山地、丘陵、南地、沿海一帶、迦南人之地和黎巴嫩，直到幼發拉底大河。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","看啊，我把那片土地賜給你們了，你們去佔領吧，那是耶和華起誓要賜給你們祖先亞伯拉罕、以撒、雅各和他們後裔的地方。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","「那時，我對你們說，『我無法獨自承擔管理你們的重任， ");
INSERT INTO cmncbt_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","因為你們的上帝耶和華使你們人丁興旺，以致今天人數多如天上的星星。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","願你們祖先的上帝耶和華使你們人數更增千倍，照祂的應許賜福給你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","但我怎能獨自擔當解決你們問題和爭端的重任呢？ ");
INSERT INTO cmncbt_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","你們要從各支派中選出有智慧、有見識、受尊重的人，我要立他們做你們的首領。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","你們都同意這樣的做法。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","於是，我把各支派中有智慧和受敬重的人立為你們的首領，即千夫長、百夫長、五十夫長、十夫長和其他官長，治理你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","我吩咐這些官員要聆聽案件，公正地審理同胞之間，或與外族人之間的訴訟， ");
INSERT INTO cmncbt_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","不可偏私，不分貴賤，不懼情面，因為判決來自上帝。如果案件太難，可以交給我處理。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","那時，我把一切當行之事都告訴了你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","「我們照我們上帝耶和華的吩咐，從何烈山出發，走過你們所見的那大而可怕的曠野，前往亞摩利山區，來到加低斯·巴尼亞。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","我對你們說，『我們的上帝耶和華賜給我們的亞摩利山區到了。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","看啊，你們祖先的上帝耶和華已把那片土地賜給你們，你們要照著祂的應許去佔領那裡，不要驚慌害怕。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","你們都來對我說，『我們要先派人去打探那地方，回來好告訴我們當走哪條路，當佔哪些城。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","我同意你們的建議，便從你們當中選出十二人，每支派選一人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","他們前往山區，到了以實各谷，打探那地方。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","他們帶回來一些那裡的果子，稟告說，『我們的上帝耶和華賜給我們的地方很好。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","「但你們卻違背你們上帝耶和華的命令，不肯上去。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","你們在帳篷中埋怨說，『耶和華憎恨我們，所以才領我們離開埃及，要把我們交在亞摩利人手裡，讓他們消滅我們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","我們能上哪里去呢？我們弟兄的報告讓我們膽戰心驚，他們說那裡的人比我們高大，城邑雄偉，城牆高達雲霄，還有亞衲人在那裡。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","我對你們說，『不要驚慌，不要怕他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","你們的上帝耶和華必帶領你們，為你們爭戰，正如祂當著你們的面在埃及所行的一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","你們在曠野曾目睹你們的上帝耶和華像父親抱兒子一樣，一路把你們抱到這地方。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","33","祂為你們開路，為你們找安營的地方，夜間用火柱、白天用雲柱為你們引路。儘管如此，你們還是不信靠你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","「你們的埋怨惹耶和華發怒，祂起誓說， ");
INSERT INTO cmncbt_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","『這邪惡的一代沒有一人能看見我起誓要賜給他們祖先的佳美之地， ");
INSERT INTO cmncbt_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","只有耶孚尼的兒子迦勒能看見，我必把他所踏之地賜給他和他的子孫，因為他一心追隨我。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","因為你們的緣故，耶和華也向我發怒，說，『你也不能進入那片土地， ");
INSERT INTO cmncbt_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","但你的助手、嫩的兒子約書亞可以進入。你要鼓勵他，因為他將帶領以色列承受那片土地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","你們說你們的子女會被擄去，但這些還不知善惡的孩子都將進入那片土地，我要把那裡賜給他們，他們將佔領那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","而你們要掉頭，沿紅海的路回到曠野。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","「於是，你們對我說，『我們得罪了耶和華，現在我們願意遵從我們的上帝耶和華的吩咐，上去作戰。』你們便各自拿起兵器，以為可以輕易攻佔山區。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","但耶和華讓我告訴你們，『不要上去作戰，以免被敵人打敗，因為我不與你們同在。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","我把耶和華的話轉告了你們，但你們不聽，竟違背耶和華的命令，擅自前往山區。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","住在山區的亞摩利人蜂擁出擊，打敗了你們，從西珥追殺你們，一直追到何珥瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","你們回來在耶和華面前哭泣，但耶和華不理會你們的哭聲。 ");
INSERT INTO cmncbt_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","因此，你們在加低斯住了很久。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","「之後，我們遵照耶和華的吩咐掉轉頭，沿紅海的路前往曠野，在西珥山區繞行了很久。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","後來，耶和華對我說， ");
INSERT INTO cmncbt_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","『你們在這山區繞行的日子夠了，現在轉向北方吧。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","你要吩咐民眾：你們將經過西珥，那裡住著你們的親屬以掃的子孫。他們懼怕你們，所以你們要格外謹慎， ");
INSERT INTO cmncbt_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","不可挑起戰爭，因為我已把西珥山賜給以掃作產業，他們的土地，我一寸也不會賜給你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","你們吃的、喝的，都要花錢向他們買。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","你們的上帝耶和華使你們凡事蒙福，看顧著你們走過這遼闊的曠野，四十年來與你們同在，使你們一無所缺。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","「於是，我們繞過我們親屬以掃的子孫所住的西珥，沿亞拉巴的路，經過以拉他、以旬·迦別，向摩押曠野走去。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","耶和華對我說，『不可騷擾摩押人，不可挑起戰爭，因為我不會把他們的土地賜給你，我已把亞珥賜給羅得的子孫為業。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","「從前以米人住在亞珥，他們人數眾多，像亞衲人一樣身材高大。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","以米人同亞衲人一樣也被稱為利乏音人，但摩押人稱他們為以米人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","以前，何利人也住在西珥，但以掃的子孫消滅了他們，佔領了他們的土地，住在那裡，正如後來以色列人佔領了耶和華賜給他們的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","耶和華又說，『現在，你們要動身過撒烈溪。』於是，我們過了撒烈溪。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","我們從離開加低斯·巴尼亞到穿過撒烈溪，用了三十八年。期間，那一代戰士都死光了，正如耶和華的誓言。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","其實是耶和華的手攻擊他們，直到把他們從營中全部消滅。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","「民中所有的戰士都死後， ");
INSERT INTO cmncbt_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","耶和華對我說， ");
INSERT INTO cmncbt_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","『今天你要經過摩押邊境亞珥。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","到亞捫人之地後，不可騷擾他們，不可挑起戰爭，因為我不會把他們的土地賜給你們，我已把那裡賜給羅得的子孫作產業。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","那裡以前也是利乏音人住的地方，亞捫人稱利乏音人為散送冥， ");
INSERT INTO cmncbt_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","利乏音族人數眾多，像亞衲人一樣身材高大。耶和華在亞捫人面前消滅了他們，讓亞捫人佔領他們的土地，住在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","耶和華也曾為以掃的子孫消滅住在西珥的何利人，讓他們佔據何利人的土地，住在那裡，直到今日。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","同樣，來自克里特的迦斐托人消滅了迦薩附近鄉村的亞衛人，住在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","耶和華說，『起來穿過亞嫩谷。看啊，我已將亞摩利人希實本王西宏和他的土地交在你手中，你要攻打他，佔領他的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","從今天起，我要使天下萬民在你面前驚恐萬狀，一聽到你的名字就嚇得發抖。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","「於是，我從基底莫曠野派使者去見希實本王西宏，提出和平的建議，說， ");
INSERT INTO cmncbt_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","『請允許我們從貴國經過，我們只走大路，不會偏離。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","我們吃的喝的，都會花錢向你買，只求讓我們步行經過， ");
INSERT INTO cmncbt_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","就像西珥的以東人和亞珥的摩押人那樣對待我們，直到我們越過約旦河，進入我們的上帝耶和華所賜之地。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","希實本王西宏卻拒絕我們的請求，因為我們的上帝耶和華使他心靈剛硬、頑固不化，好讓我們擊敗他，正如今日的情形。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","耶和華對我說，『看啊，我已把西宏和他的土地交給你了，去佔領他的土地吧。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","西宏率領全軍在雅雜與我們交戰。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","我們的上帝耶和華使西宏父子及其軍隊敗在我們手下，全軍覆沒。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","我們攻佔了西宏的所有城邑，將其夷為平地，殺光城中的男女老幼，一個不留， ");
INSERT INTO cmncbt_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","只留下牲畜和財物作戰利品。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","從亞嫩谷邊的亞羅珥和谷中的城，直到基列的所有城邑全被我們攻克，我們的上帝耶和華把這一切都交給了我們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","我們遵照我們的上帝耶和華的吩咐，沒有進犯亞捫人的土地，即雅博河一帶和山區的城邑。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","「之後，我們前往巴珊，巴珊王噩率全軍在以得來迎戰我們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","耶和華對我說，『不要怕他，因為我已把他及其眾民和土地交在你手中，你要像從前對付希實本的亞摩利王西宏一樣對付他。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","「我們的上帝耶和華把巴珊王噩及其眾民交在我們手中，我們殺了他們，一個不留。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","我們佔領了亞珥歌伯全境，即巴珊王噩的所有城邑，共六十座。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","這些城邑圍牆高聳，門閂牢固。我們還佔領了許多沒有城牆的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","像對付希實本王西宏一樣，我們將這些城邑夷為平地，城中的男女老幼一個不留， ");
INSERT INTO cmncbt_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","只留下牲畜和財物作戰利品。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","於是，我們攻佔了約旦河東兩個亞摩利王的土地，從亞嫩谷一直到黑門山—— ");
INSERT INTO cmncbt_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","西頓人稱黑門山為西連，亞摩利人稱之為示尼珥—— ");
INSERT INTO cmncbt_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","我們攻佔了高原的城邑、整個基列和巴珊，遠至巴珊王噩的城邑撒迦和以得來。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","巴珊王噩是最後一個利乏音人。他的床是鐵做的，存放在亞捫人的拉巴城，長四米，寬一米八。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","「我們佔領了這片土地後，我把亞嫩谷邊的亞羅珥以北地區和基列山區的一半及其城邑，分給呂便支派和迦得支派， ");
INSERT INTO cmncbt_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","把基列山區的另一半，以及噩的王國巴珊全境——整個亞珥歌伯分給瑪拿西半個支派。巴珊地區又被稱為利乏音人之地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","瑪拿西的子孫雅珥得到亞珥歌伯全境，遠至基述人和瑪迦人的邊界。他按自己的名字給巴珊取名叫哈倭特·雅珥，沿用至今。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","我又把基列分給瑪吉， ");
INSERT INTO cmncbt_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","把從基列到亞嫩谷，以谷中央為界，遠至亞捫人的邊界雅博河地區，分給呂便支派和迦得支派。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","我還把亞拉巴，就是以約旦河為界，從基尼烈直到東面毗斯迦山腳的亞拉巴海，即鹽海地區給了他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","「那時我吩咐他們說，『你們的上帝耶和華已經把這些地方賜給你們，但你們所有的戰士必須帶著兵器過河，做以色列同胞的先鋒。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","我知道你們有許多牲畜，你們的妻子、兒女和牲畜可以留在我分給你們的城邑。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","等你們的上帝耶和華使其他以色列人和你們一樣有了安身之所，佔領了耶和華賜給他們的約旦河西之地後，你們才可以返回我分給你們的家園。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","那時我吩咐約書亞說，『你們的上帝耶和華怎樣對付那兩個王，你都親眼看見了。耶和華必以同樣的方式對付你將去攻佔的各國。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","不要怕他們，因為你的上帝耶和華將為你們爭戰。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","「那時，我懇求耶和華，說， ");
INSERT INTO cmncbt_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","『主耶和華啊，你已向僕人彰顯你的偉大和權能，天上地下沒有神明可與你的大能作為相比！ ");
INSERT INTO cmncbt_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","求你讓我過去看看約旦河那邊的佳美之地，那美好的山區和黎巴嫩。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","但因你們的緣故，耶和華向我發怒，不聽我的懇求，祂對我說，『夠了，不要再跟我提這件事。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","你可以上毗斯迦山頂，向東南西北眺望，親眼看看那片土地，因為你不可過約旦河。 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","你要委任約書亞，勉勵他，支持他，因為他必帶領以色列人過河，使他們承受你眺望的那片土地。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","當時，我們駐紮在伯·毗珥對面的谷中。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","「以色列人啊，要聆聽我傳授給你們的律例和典章，要切實遵行，以便你們可以存活，並進去佔據你們祖先的上帝耶和華賜給你們的那片土地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","我吩咐你們的，你們不可做任何增減，你們要遵守你們的上帝耶和華的命令。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","你們親眼看見耶和華在巴力·毗珥事件中的作為，你們的上帝耶和華毀滅了你們中間所有拜巴力·毗珥的人， ");
INSERT INTO cmncbt_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","但你們這些信靠你們的上帝耶和華的人至今都還活著。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","看啊，遵照我的上帝耶和華的吩咐，我把律例和典章傳授給你們，好讓你們在將要進去佔領的土地上遵守。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","你們要謹遵這些律例和典章，因為這樣就會讓外族人看見你們的智慧和聰明。他們聽見這些律例後，必說，『這偉大的民族真有智慧和聰明！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","我們的上帝耶和華與我們如此親近，隨時垂聽我們的呼求，有哪個偉大民族的神明能與之相比？ ");
INSERT INTO cmncbt_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","有哪個偉大的民族擁有我今天所傳授給你們的如此公義的律例和典章？ ");
INSERT INTO cmncbt_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","「要謹慎、小心，不可忘記親眼所見的事，要一生銘記在心，並且告訴子子孫孫。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","那天，你們在何烈山站在你們的上帝耶和華面前，耶和華對我說，『把民眾招聚起來，讓他們聽我的教誨，學習一生敬畏我，並傳授給自己的兒女。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","你們來到山腳下，站在那裡，山上烈焰沖天、烏雲密佈、極其幽暗。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","耶和華在火焰中對你們說話，你們只聽見祂的聲音，卻看不見祂的形像。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","祂向你們宣告祂的約，就是祂吩咐你們遵守的十誡，並寫在兩塊石版上。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","那時，耶和華吩咐我把律例和典章傳授給你們，好讓你們在將要佔領的土地上遵守。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","「你們要格外小心，耶和華在何烈山的火焰中對你們說話時，你們沒有看見任何形像， ");
INSERT INTO cmncbt_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","所以不可墮落，去為自己製造任何形狀的神像——男人、女人、 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","飛禽走獸、 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","爬蟲或魚類的像。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","當你們舉目觀看你們的上帝耶和華賜給天下萬民的日、月、星辰等天上萬象時，不要受誘惑去跪拜、供奉它們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","耶和華拯救你們脫離埃及那座鐵熔爐，讓你們做祂自己的子民，正如今日的情形。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","因你們的緣故，耶和華向我發怒，起誓不讓我過約旦河、進入祂賜給你們作產業的那片佳美之地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","我將死在約旦河這邊，過不了約旦河。但你們必過去得到那片佳美之地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","你們要謹慎，不可忘記你們的上帝耶和華與你們所立的約，不可違背你們上帝耶和華的禁令，去製造任何形狀的神像。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","因為你們的上帝耶和華是烈火，是痛恨不貞的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","「將來，即使你們在那裡安頓已久、子孫滿堂，也不可墮落、製造任何形狀的神像，不可做你們的上帝耶和華視為邪惡的事，惹祂發怒。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","否則，今天我叫天地作證，你們必很快從約旦河對面將要佔領的土地上滅亡，你們必被徹底消滅，不得在那裡長久居住。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","耶和華必把你們驅散到列邦，使你們在列邦中的人數所剩無幾。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","你們必在那裡供奉人用木石造的不會看、不會聽、不會吃、不會聞的神像。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","但你們若在那裡尋求你們的上帝耶和華，全心全意地尋求祂，就必尋見。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","日後，當你們遭遇這些事，受盡苦難的時候，必歸向你們的上帝耶和華，聽從祂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","因為你們的上帝耶和華充滿憐憫，祂不會拋棄你們，滅絕你們，也不會忘記祂與你們祖先所立的誓約。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","「你們可以查考歷史，自上帝在世上造人以來，這樣的奇事，天地之間何曾有過？誰曾聽聞？ ");
INSERT INTO cmncbt_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","有哪個民族像你們一樣，聽見了上帝在火中說話，還活了下來？ ");
INSERT INTO cmncbt_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","有哪個神明像你們的上帝耶和華那樣在埃及當著你們的面降災禍、行神蹟奇事、發起戰爭、伸出臂膀、施展大能的手、以偉大而可畏的作為拯救一族脫離異邦？ ");
INSERT INTO cmncbt_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","耶和華行這樣的事，是要叫你們知道祂是上帝，除祂以外，別無他神。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","祂讓你們聽見祂從天上來的聲音，好教導你們，又在地上讓你們看見祂的烈火，並聽見祂在烈火中說的話。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","因為祂愛你們的祖先，所以揀選他們的子孫，親自用大能帶你們出埃及， ");
INSERT INTO cmncbt_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","趕走比你們強大的民族，領你們進入他們的土地，把他們的土地賜給你們作產業，正如今日的情形。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","所以，今天你們要知道並謹記，耶和華是天上地下的上帝，此外別無他神。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","我今天將祂的律例和誡命傳授給你們，你們要遵守，以便你們及子孫都蒙福，在你們上帝耶和華所賜的土地上得享長壽。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","那時，摩西在約旦河東劃出三座城作避難城， ");
INSERT INTO cmncbt_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","供素無冤仇卻誤殺他人者逃往避難。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","三座城分別是供呂便人避難的比悉，在曠野高原；供迦得人避難的拉末，在基列；供瑪拿西人避難的哥蘭，在巴珊。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","以下是摩西頒佈給以色列人的律法， ");
INSERT INTO cmncbt_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","即在離開埃及後傳授給他們的法度、律例和典章。 ");
INSERT INTO cmncbt_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","當時他們在約旦河以東伯·毗珥對面的山谷，那裡原屬於希實本的亞摩利王西宏。摩西領以色列人離開埃及後消滅了西宏， ");
INSERT INTO cmncbt_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","佔領了他的土地，還佔領了巴珊王噩的土地。西宏和噩是約旦河東亞摩利人的兩個王， ");
INSERT INTO cmncbt_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","其國土從亞嫩谷邊的亞羅珥一直到西雲山，即黑門山， ");
INSERT INTO cmncbt_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","包括約旦河東的整個亞拉巴，遠至毗斯迦山腳的亞拉巴海。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","摩西把所有的以色列人召來，對他們說：「以色列人啊，要留心聽我今天對你們宣講的律例和典章，要學習並謹慎遵行。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","我們的上帝耶和華曾在何烈山與我們立約， ");
INSERT INTO cmncbt_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","這約不是與我們祖先立的，而是與我們今天還活著的人立的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","耶和華在山上的烈火中面對面跟你們說話。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","那時，因為你們害怕那烈火，沒有到山上去，我就站在耶和華和你們中間，把耶和華的話傳給你們。耶和華說： ");
INSERT INTO cmncbt_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","「『我是你的上帝耶和華，曾把你從受奴役之地埃及領出來。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","除我以外，你不可有別的神明。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","不可為自己雕刻神像，不可仿照天上、地上和地底下水中的任何形像造神像， ");
INSERT INTO cmncbt_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","不可跪拜它們，也不可供奉它們，因為我——你的上帝耶和華痛恨不貞，我必追討背棄我之人的罪，從父到子直到三四代。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","但那些愛我、遵守我誡命的人，我必以慈愛待他們，直到千代。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","不可妄用你上帝耶和華的名，違者必被耶和華定罪。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","要遵照你的上帝耶和華的吩咐守安息日為聖日。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","你一週可勞碌工作六天， ");
INSERT INTO cmncbt_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","但第七天是你的上帝耶和華的安息日，這一天你和兒女、僕婢、牛驢等牲畜及你那裡的外族人不可做任何工，好讓僕婢和你一樣得到休息。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","要記住，你曾在埃及做奴隸，你的上帝耶和華伸出臂膀，用大能的手把你從那裡領出來。因此，你的上帝耶和華吩咐你守安息日。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","要遵照你的上帝耶和華的吩咐孝敬父母，以便在你的上帝耶和華要賜給你的土地上享長壽，蒙祝福。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","不可殺人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","不可通姦。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","不可偷盜。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","不可作偽證陷害人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","不可貪戀別人的妻子，不可貪圖別人的房屋、田地、僕婢、牛驢，或其他任何物品。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","「這是耶和華在山上的烈火、烏雲和幽暗中高聲頒佈給你們全體會眾的誡命。此外，祂沒有說別的。祂把這些話寫在兩塊石版上交給我。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","當時，山上燃燒著烈焰，你們聽見聲音從黑暗中傳來。你們各支派的首領和長老都到我跟前， ");
INSERT INTO cmncbt_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","說，『看啊，我們的上帝耶和華向我們彰顯了祂的榮耀和威嚴，我們聽見了祂從火中發出的聲音。今天我們已經看見，人聽見上帝說話後還能活著。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","但我們何必冒死，被這烈火吞噬呢？我們若再次聽到我們的上帝耶和華的聲音，必然喪命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","世上有誰像我們一樣，聽見永活上帝從火中說話後還能活著呢？ ");
INSERT INTO cmncbt_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","你近前聽我們上帝耶和華所說的話，然後回來把祂的話告訴我們，我們必聽從、遵行。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","「耶和華聽見了你們的話，就對我說，『我聽見了民眾對你說的話，他們所說的都對。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","但願他們常常敬畏我，遵從我的一切誡命，以便他們和他們的子孫世世代代可以蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","你吩咐他們回到自己的帳篷， ");
INSERT INTO cmncbt_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","但你要留在我這裡，我要把所有的誡命、律例和典章都賜給你，你要把這些傳授給眾人，使他們可以在我要賜給他們的土地上遵行。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","所以，你們要謹遵你們上帝耶和華的吩咐，不可偏離左右。 ");
INSERT INTO cmncbt_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","你們要遵行你們上帝耶和華的一切吩咐，就可以在你們將要佔領的土地上存活、亨通、長久。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","「你們的上帝耶和華吩咐我教導你們以下的誡命、律例和典章，以便你們在將要佔領的土地上遵行。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","這樣，你們就會得享長壽，你們及子孫就會終生敬畏你們的上帝耶和華，遵守祂藉我吩咐你們的一切律例和誡命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","以色列人啊，你們要留心聽，謹慎遵行，以便你們在那奶蜜之鄉可以凡事順利、人口極其繁盛，正如你們祖先的上帝耶和華給你們的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","聽啊，以色列人，耶和華是我們的上帝，耶和華是獨一的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","你們要全心、全意、全力愛你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","要將我今天吩咐你們的話牢記在心， ");
INSERT INTO cmncbt_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","並教導你們的兒女，無論坐在家裡或行在路上，或起或臥，都要講論這些律例和誡命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","要把它們繫在手上、戴在額上作記號， ");
INSERT INTO cmncbt_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","要寫在城門上和自家的門框上。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","「你們的上帝耶和華將帶你們進入祂向你們祖先亞伯拉罕、以撒和雅各起誓要賜給你們的土地。那裡宏偉壯觀的城邑不是你們建造的， ");
INSERT INTO cmncbt_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","滿屋的美物不是你們積攢的，井不是你們挖掘的，葡萄園和橄欖樹也不是你們栽種的。你們在那裡吃飽喝足之後， ");
INSERT INTO cmncbt_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","要小心，不可忘記把你們從受奴役之地埃及救出來的耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","要敬畏你們的上帝耶和華，事奉祂，憑祂的名起誓。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","不可隨從周圍各族的神明， ");
INSERT INTO cmncbt_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","免得你們的上帝耶和華向你們發怒，把你們從世上消滅；因為祂住在你們當中，祂痛恨不貞。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","「不可像在瑪撒那樣試探你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","要謹遵你們的上帝耶和華吩咐你們的誡命、法度和律例。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","你們要做耶和華視為正與善的事，以便凡事順利，得到耶和華起誓要賜給你們祖先的佳美之地， ");
INSERT INTO cmncbt_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","從你們面前趕出所有敵人，正如耶和華所言。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","「將來你們的子孫會問，『我們的上帝耶和華給你們頒佈這些法度、律例和典章是什麼意思？』 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","你們要告訴他們，『我們曾在埃及做法老的奴隸，耶和華用大能的手帶我們出埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","我們親眼看見耶和華行偉大而可畏的神蹟奇事，懲罰埃及和法老全家。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","祂帶領我們離開埃及，為要把我們帶進祂起誓要賜給我們祖先的這片土地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","我們的上帝耶和華吩咐我們遵守這一切律例、敬畏祂，以便我們可以終生受益，生命無憂，正如今日的情形。 ");
INSERT INTO cmncbt_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","我們若按照我們的上帝耶和華的吩咐，在祂面前謹遵這一切誡命，便被算為義人。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","「你們的上帝耶和華帶領你們進入將要佔領的土地時，必從你們面前趕走赫人、革迦撒人、亞摩利人、迦南人、比利洗人、希未人和耶布斯人這七個比你們強大的民族。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","當你們的上帝耶和華把他們交在你們手裡、使你們打敗他們後，你們必須徹底毀滅他們。不可與他們立約，不可憐憫他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","不可與他們通婚，不可讓你們的兒女與他們的兒女通婚， ");
INSERT INTO cmncbt_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","因為他們會讓你們的兒女離棄耶和華去拜其他神明，以致耶和華向你們發怒，迅速毀滅你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","你們要這樣對待他們：拆毀他們的祭壇，打碎他們的神柱，砍下他們的亞舍拉神像，焚燒他們的偶像。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","因為你們是你們的上帝耶和華的聖民，祂從天下萬族中揀選你們做祂寶貴的子民。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","「耶和華喜愛你們、揀選你們，不是因為你們的人口比別的民族多——其實你們在萬族中是最小的—— ");
INSERT INTO cmncbt_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","而是因為祂愛你們，遵守祂向你們祖先所起的誓。因此，祂用大能的手把你們從受奴役之地領出來，從埃及王法老手中救贖了你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","所以你們要知道，你們的上帝耶和華是上帝，是信實的上帝，祂向愛祂、遵守祂誡命的人守約、施慈愛直到千代。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","但祂必毫不遲延地當面報應、毀滅那些恨祂的人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","所以，你們要謹遵我今天吩咐你們的誡命、律例和典章。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","「如果你們聽從並謹遵這些典章，你們的上帝耶和華就會信守祂給你們祖先的誓約，以慈愛待你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","祂會愛你們，賜福給你們，使你們在祂向你們祖先起誓要賜給你們的土地上人丁興旺，牛羊成群，收穫豐富的穀物、新酒和油。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","天下萬族之中，你們是最蒙福的，你們的男人、女人和牲畜沒有不能生育的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","耶和華要使你們免患疾病，免遭你們在埃及所見的惡疾，祂要把那些惡疾降在一切憎惡你們的人身上。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","你們必須滅絕你們的上帝耶和華交在你們手裡的各族，不可憐憫他們，不可供奉他們的神明，因為那樣會使你們陷入網羅。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","「也許你們心裡會說，『這些民族都比我們強大，我們怎能趕走他們呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","不要怕他們，要牢記你們的上帝耶和華曾如何對付法老和整個埃及， ");
INSERT INTO cmncbt_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","你們親眼目睹祂如何降下大災難、行神蹟奇事、伸出臂膀和大能的手領你們離開埃及，祂也要這樣對付你們所懼怕的各族。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","你們的上帝耶和華還要派黃蜂去攻擊他們，直到躲藏起來的殘存者也全部滅亡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","不要懼怕他們，因為你們的上帝耶和華住在你們當中，祂是偉大而可畏的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","你們的上帝耶和華將在你們前面逐漸趕走那些民族，你們不可急速地滅盡他們，否則你們周圍的野獸會大增，危害你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","你們的上帝耶和華要將他們交給你們，使他們驚恐萬狀，直到被滅絕。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","祂要將他們的王交在你們手中，無人能抵擋你們，你們要毀滅他們，使他們的名字從世上絕跡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","你們要燒毀他們的神像，不可貪圖神像上的金銀，不可將那些金銀據為己有，免得你們因此陷入網羅；因為那是你們的上帝耶和華所憎惡的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","不可把可憎之物帶到家裡，否則你們會像它們一樣被毀滅。你們要極其憎惡、厭棄它們，因為它們是當毀滅之物。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","「你們要謹遵我今日吩咐你們的一切誡命，以便能夠存活，人丁興旺，進入並得到耶和華起誓要賜給你們祖先的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","要記住這四十年來，你們的上帝耶和華怎樣在曠野一路引領你們，祂磨煉你們、考驗你們，好知道你們的心意如何、肯不肯遵守祂的誡命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","祂讓你們忍饑挨餓，然後賜給你們祖祖輩輩從未見過的嗎哪吃，為了使你們明白人活著不是單靠食物，而是靠耶和華口中的每一句話。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","這四十年來，你們的衣服沒有穿破，雙腳也沒有走腫。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","你們心裡要明白，你們的上帝耶和華管教你們，如同父親管教兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","「所以，你們要遵守你們的上帝耶和華的誡命，行祂的道，敬畏祂， ");
INSERT INTO cmncbt_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","因為祂要帶你們到一個佳美之地。那裡的谷中和山間流淌著條條溪流、股股清泉； ");
INSERT INTO cmncbt_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","那裡盛產大麥、小麥、葡萄、無花果、石榴、橄欖油和蜂蜜； ");
INSERT INTO cmncbt_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","那裡食物充足，一無所缺；那裡礦產資源豐富，石頭就是鐵，山中可以採銅。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","你們吃飽喝足後，要讚美你們的上帝耶和華，因為祂賜給你們那佳美之地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","「你們要謹慎，免得忘記你們的上帝耶和華，不遵守我今天吩咐你們的誡命、典章和律例。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","否則，當你們豐衣足食、居室華美、 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","牛羊成群、金銀財物增多的時候， ");
INSERT INTO cmncbt_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","切勿心驕氣傲，忘記你們的上帝耶和華。祂把你們從受奴役之地埃及救出來， ");
INSERT INTO cmncbt_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","帶領你們走過乾旱、可怕、毒蛇和蠍子出沒的大曠野。祂使堅硬的磐石流出水來給你們喝， ");
INSERT INTO cmncbt_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","在曠野中把你們祖先從未見過的嗎哪賜給你們吃，為要磨煉你們、考驗你們，使你們最終得到益處。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","你們切勿以為是憑自己的雙手和能力致富的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","要記住，是你們的上帝耶和華賜給你們致富的能力，為要堅立祂給你們祖先的誓約，正如今日的情形。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","「我今天警告你們，如果你們忘記你們的上帝耶和華，去追隨、供奉、祭拜其他神明，你們必滅亡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","如果你們不聽從你們的上帝耶和華，你們必滅亡，正如祂使列國在你們面前滅亡一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","「以色列人啊，你們要聽！今天你們要過約旦河，去趕出那些比你們強大的民族。他們住在城牆高聳入雲的大城裡， ");
INSERT INTO cmncbt_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","是長得高大威猛的亞衲人。你們瞭解他們，也聽人說過，『誰能抵擋亞衲人呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","但今天你們要知道，你們的上帝耶和華要走在你們前面，像烈火一樣吞噬他們。祂要制伏他們，使你們迅速趕走他們，毀滅他們，正如祂對你們的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","「你們的上帝耶和華從你們面前趕走他們以後，你們心裡不要以為耶和華帶領你們佔領那片土地是因為你們公義，其實是因為那裡的民族邪惡，耶和華才將他們從你們面前趕走。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","你們能佔領他們的土地並非因為你們公義、行為正直。你們的上帝耶和華從你們面前趕走那些民族，是因為他們邪惡，也是為了實現祂給你們祖先亞伯拉罕、以撒和雅各的誓言。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","你們要知道，耶和華賜給你們那佳美之地不是因為你們公義。其實你們是頑固不化的人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","「要牢記你們在曠野怎樣觸怒你們的上帝耶和華。從你們離開埃及那天來到這裡，你們屢屢背叛耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","在何烈山，你們觸怒了耶和華，以致祂要毀滅你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","那時，我上山去接受耶和華與你們立約的石版，在山上待了四十晝夜，沒吃也沒喝。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","耶和華把兩塊立約的石版交給我，上面刻著那天你們聚會時祂在山上的火焰中對你們說的話，是祂用手指刻上去的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","四十晝夜後，耶和華把那兩塊刻著約的石版交給我， ");
INSERT INTO cmncbt_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","對我說，『快下山吧，因為你從埃及領出來的百姓已經敗壞了。他們這麼快就偏離了我吩咐他們走的道，為自己鑄造了神像。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","「耶和華又對我說，『我已看出，這是頑固不化的百姓。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","不要攔我，我要毀滅他們，從世上抹去他們的名字。我要使你成為一個比他們更強大的民族。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","我雙手拿著那兩塊約版，轉身從烈火熊熊的山上下來， ");
INSERT INTO cmncbt_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","看見你們為自己鑄造了牛犢像，得罪了你們的上帝耶和華，這麼快就偏離了耶和華吩咐你們走的道， ");
INSERT INTO cmncbt_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","就當著你們的面摔碎了那兩塊石版。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","「我又俯伏在耶和華面前，四十晝夜不吃不喝，因為你們犯了大罪，做耶和華憎惡的事，惹祂發怒。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","耶和華向你們發烈怒，要毀滅你們，我非常懼怕。但耶和華再次垂聽了我的祈求。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","耶和華對亞倫非常憤怒，以致要殺掉他，於是我也為他祈求。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","我焚燒了你們鑄造的罪惡之物牛犢像，把它打碎、磨成粉末，撒在從山上流下來的溪水中。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","「你們在他備拉、瑪撒和基博羅·哈他瓦三番四次地觸怒耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","你們的上帝耶和華吩咐你們離開加低斯·巴尼亞，去佔領祂賜給你們的土地，你們卻違背祂的命令，不信靠祂，也不聽從祂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","自從我認識你們以來，你們就不斷地背叛耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","「因為耶和華說要毀滅你們，我就俯伏在耶和華面前四十晝夜， ");
INSERT INTO cmncbt_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","向祂祈求說，『主耶和華啊，求你不要毀滅你的子民！他們是你的產業，是你用大能的手從埃及救贖並帶出來的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","求你看在你僕人亞伯拉罕、以撒和雅各的份上，不要計較這個民族的頑固、邪惡和罪過， ");
INSERT INTO cmncbt_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","免得你帶領我們離開之地的人說，你不能把他們領到你應許給他們的地方，你憎惡他們，所以把他們帶到曠野殺了。 ");
INSERT INTO cmncbt_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","他們畢竟是你的子民，你的產業，是你伸出大能的臂膀從埃及帶出來的。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","「當時耶和華對我說，『你要鑿出兩塊石版，與前兩塊一樣，也要做一個木櫃，然後上山來見我。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","我要把你摔碎的那兩塊石版上的話重新寫在你鑿的石版上。你要把它們放在櫃子裡。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","於是，我用皂莢木做了一個櫃子，又鑿出兩塊石版，與前兩塊一樣，然後帶著石版上了山。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","耶和華把你們在山腳下聚會時，祂在山上的火焰中向你們頒佈的十條誡命，重新刻在石版上，並把石版交給我。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","我下山後，遵照耶和華的吩咐把石版放在我做的櫃子裡。現在石版仍放在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","「我們從亞干人的井出發，來到摩西拉。亞倫死在那裡，並葬在那裡，他兒子以利亞撒接替他做大祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","我們從那裡走到谷歌大，又走到溪流之鄉約巴他。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","那時，耶和華把利未支派分別出來，派他們抬祂的約櫃，侍立在祂面前事奉祂，奉祂的名祝福，至今未變。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","因此，利未人在眾支派中沒有分到土地作產業，耶和華是他們的產業，這是你們的上帝耶和華對他們的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","「和前一次一樣，我又在山上待了四十晝夜，耶和華又聽了我的祈求，答應不毀滅你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","耶和華對我說，『起來，帶民眾走吧，去佔領我起誓要賜給他們祖先的土地。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","「以色列人啊，你們的上帝耶和華對你們有何要求？無非要你們敬畏祂，遵行祂的旨意，愛祂，全心全意地事奉祂， ");
INSERT INTO cmncbt_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","遵守祂的誡命和律例。我今天把這些誡命和律例賜給你們，是為了你們的益處。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","看啊，天和天上的天、大地和地上的萬物，都屬於你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","但耶和華只喜愛你們的祖先，從萬族中揀選了他們的後裔——你們，正如今日的情形。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","所以，你們要洗心革面，不可再頑固不化。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","你們的上帝耶和華是萬神之神、萬主之主，是偉大、全能、可畏的上帝。祂不徇情面，不受賄賂； ");
INSERT INTO cmncbt_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","祂為孤兒寡婦主持公道，關愛寄居者，供給他們衣食。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","所以，你們要愛寄居者，因為你們也曾寄居埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","你們要敬畏你們的上帝耶和華，事奉祂，倚靠祂，憑祂的名起誓。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","你們要讚美祂，祂是你們的上帝，你們親眼目睹了祂為你們做的偉大而可畏的事。 ");
INSERT INTO cmncbt_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","當年你們祖先下埃及時，只有七十人，現在你們的上帝耶和華使你們多如天上的星辰。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","「你們要愛你們的上帝耶和華，時刻遵守祂的吩咐、律例、典章和誡命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","要記住，我現在是對你們，而不是對你們的孩子說話。他們沒有親身經歷、親眼見過你們上帝耶和華的管教、威嚴、大能的手和伸出的臂膀； ");
INSERT INTO cmncbt_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","祂怎樣在埃及行神蹟奇事對付埃及王法老及其整個國家； ");
INSERT INTO cmncbt_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","怎樣使紅海淹沒追趕你們的埃及軍隊和車馬，將他們永遠毀滅； ");
INSERT INTO cmncbt_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","怎樣在曠野一路看顧你們，一直來到這裡； ");
INSERT INTO cmncbt_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","怎樣對付呂便人以利押的兒子大坍和亞比蘭，使大地在以色列人當中裂開，吞沒了他們及其家人、帳篷和所有隨從。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","你們親眼目睹了耶和華的這些偉大作為。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","「因此，你們要遵守我今天吩咐你們的誡命，以便有力量過河，攻取你們將要攻取的土地， ");
INSERT INTO cmncbt_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","長久居住在耶和華起誓要賜給你們祖先及其後裔的奶蜜之鄉。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","你們將要攻取的那片土地不像你們離開的埃及。在埃及你們撒種後，要像澆菜園一樣辛勤灌溉。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","而你們將要佔領的那片土地卻有山有谷，雨水充足， ");
INSERT INTO cmncbt_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","你們的上帝耶和華從歲首到年終時時看顧那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","「如果你們謹遵我今天吩咐你們的誡命，全心全意地愛你們的上帝耶和華，事奉祂， ");
INSERT INTO cmncbt_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","祂就會按時給你們的土地降下秋雨和春雨，使你們收穫穀物、新酒和油， ");
INSERT INTO cmncbt_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","有草場飼養牲畜，豐衣足食。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","你們要謹慎，免得被迷惑，轉而供奉、祭拜其他神明。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","否則，耶和華必向你們發怒，使天不下雨、地無出產，以致你們在祂賜給你們的佳美之地上迅速滅亡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","「所以，你們要把我的這些吩咐銘記在心，繫在手上，戴在額上作記號； ");
INSERT INTO cmncbt_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","要用這些話教導你們的兒女，無論坐在家裡或行在路上，或起或臥，都要講論； ");
INSERT INTO cmncbt_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","也要寫在城門上和自家的門框上。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","這樣，你們及子孫就可以生活在耶和華起誓要賜給你們祖先的土地上，與天地同長。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","如果你們謹遵我吩咐你們的這一切誡命——愛你們的上帝耶和華，遵行祂的旨意，依靠祂， ");
INSERT INTO cmncbt_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","耶和華就會為你們趕走那些比你們強大的民族，你們也必佔領他們的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","你們腳掌踏過的地方都要歸你們。你們的疆界南到曠野，北到黎巴嫩，東到幼發拉底大河，西到地中海。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","所到之處無人能抵擋你們，因為你們的上帝耶和華會使那些地方的人對你們充滿懼怕，正如祂對你們的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","「看啊，我今天把祝福和咒詛擺在你們面前。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","你們若遵行我今天吩咐你們的誡命，就會蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","你們若不遵行你們的上帝耶和華的誡命，偏離我今天吩咐你們當走的道路，隨從不認識的其他神明，必受咒詛。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","你們的上帝耶和華帶領你們進入並佔領那片土地時，你們要在基利心山上宣告祝福，在以巴路山上宣告咒詛。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","基利心山和以巴路山屬於住在亞拉巴的迦南人，位於約旦河西岸的日落之處，在吉甲對面，靠近摩利橡樹。 ");
INSERT INTO cmncbt_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","你們就要穿過約旦河，佔領耶和華賜給你們的土地了。你們佔領那裡並定居下來以後， ");
INSERT INTO cmncbt_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","要謹遵我今天頒佈給你們的一切律例和典章。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","「只要你們生活在你們祖先的上帝耶和華賜給你們的土地上，就要謹遵以下律例和典章。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","「你們趕走那裡的列邦後，要徹底摧毀他們在高山上、丘陵上、綠樹下供奉其神明的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","你們要拆毀他們的祭壇，打碎他們的神柱，焚燒他們的亞舍拉神像，砍倒他們神明的雕像，使他們的名字從那裡消失。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","你們不可按照他們的方式敬拜你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","你們的上帝耶和華要在你們眾支派中選一個地方作祂的居所，你們要去那裡敬拜祂， ");
INSERT INTO cmncbt_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","把你們的燔祭及其他祭物、十一奉獻、舉祭、還願祭、自願獻的祭和頭生的牛羊帶到那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","你們和家人要在那裡，在你們的上帝耶和華面前吃喝；要為你們所做的一切蒙祂賜福而歡喜快樂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","「你們不可再像今日這樣各行其是， ");
INSERT INTO cmncbt_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","因為到如今你們還沒有進入你們的上帝耶和華賜給你們作產業的安歇之地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","但不久你們將渡過約旦河，定居在那片土地上。你們的上帝耶和華將使你們四境太平，安然居住， ");
INSERT INTO cmncbt_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","你們要把我吩咐你們獻的燔祭、各種牲祭、十一奉獻、舉祭和一切還願祭，帶到你們的上帝耶和華選定的敬拜場所。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","在那裡，你們和兒女、僕婢及同城中沒有分到土地作產業的利未人，要一起在你們的上帝耶和華面前歡喜快樂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","你們切不可隨處向耶和華獻燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","耶和華會在你們的一個支派中選定敬拜的場所，你們只可以在那裡獻燔祭，做我吩咐你們的一切事。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","「你們可以隨意在居住的各城宰殺牲畜吃，享受你們的上帝耶和華所賜的福，像吃羚羊和鹿一樣。潔淨的人和不潔淨的人都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","但你們不可吃血。要把血倒在地上，像倒水一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","不可在你們的城裡吃十一奉獻的穀物、新酒和油、頭生的牛羊、還願祭、自願獻的祭和舉祭； ");
INSERT INTO cmncbt_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","要在你們的上帝耶和華選定的地方，與兒女、僕婢及同城的利未人一起在你們的上帝耶和華面前吃。要為你們所做的一切，在你們的上帝耶和華面前歡喜快樂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","切記，只要你們還住在自己的土地上，就不可忘記利未人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","「你們的上帝耶和華按照祂的應許擴展你們的疆域後，你們若想吃肉，隨時都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","如果你們的上帝耶和華選定的敬拜場所離你們太遠，你們可以在自己的城裡，按照我的吩咐，隨時宰殺耶和華賜給你們的牛羊吃， ");
INSERT INTO cmncbt_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","就像你們吃羚羊和鹿一樣。潔淨的人和不潔淨的人都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","但你們切不可吃血，因為血就是生命；你們不可把生命和肉一起吃。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","你們切不可吃血，要把血倒在地上，像倒水一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","你們要做耶和華視為正的事——不可吃血，以便你們及子孫凡事順利。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","你們要把聖物和還願祭帶到耶和華選定的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","你們要在你們的上帝耶和華的祭壇上獻燔祭，連肉帶血都要獻上。要把其他祭牲的血倒在壇上，但可以吃祭肉。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","你們要認真聽從我給你們的這些吩咐，做你們的上帝耶和華視為正與善的事，以便你們及子孫凡事順利，直到永遠。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","「你們的上帝耶和華將為你們剷除列國。你們要趕走他們，住在他們的土地上。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","他們從你們面前被毀滅之後，你們要謹慎，不可受誘惑去效法他們的習俗，不可打聽他們神明的事，說，『這些民族怎樣供奉他們的神明呢？我也要效法。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","你們不可按照他們的方式敬拜你們的上帝耶和華。他們祭拜自己神明的種種行為令耶和華憎惡，他們甚至焚燒自己的兒女獻給他們的神明。 ");
INSERT INTO cmncbt_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","「你們要謹遵我的一切吩咐，不可增添，也不可刪減。 ");
INSERT INTO cmncbt_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","「如果你們中間出現了先知或解夢的人，要顯神蹟奇事給你們看， ");
INSERT INTO cmncbt_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","勸你們隨從、供奉不認識的其他神明，即使他們顯的神蹟奇事應驗了， ");
INSERT INTO cmncbt_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","你們也不可聽從他們。因為這是你們的上帝耶和華在試驗你們，要看看你們是否全心全意地愛祂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","你們要跟從你們的上帝耶和華，敬畏祂，遵守祂的誡命，聽從祂的話，事奉祂，倚靠祂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","必須處死那些先知或解夢的人，因為他們慫恿你們背叛你們的上帝耶和華、偏離祂吩咐你們當走的道路。你們的上帝耶和華曾帶你們離開埃及，救贖你們脫離奴役。你們必須清除你們當中的邪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","「如果你們的親兄弟、兒女、愛妻或摯友暗中引誘你們去拜你們和你們祖先都不認識的其他神明， ");
INSERT INTO cmncbt_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","引誘你們去拜你們周圍各族的神明，或在附近或遠在天邊， ");
INSERT INTO cmncbt_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","你們不可遷就、聽從他們，不可憐惜他們，不可放過或包庇他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","必須處死他們。你們要首先下手，然後眾人一起打死他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","你們要用石頭打死他們，因為他們企圖使你們背棄你們的上帝耶和華，祂曾把你們從受奴役之地埃及領出來。 ");
INSERT INTO cmncbt_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","這樣，所有以色列人聽了就會害怕，必無人再敢在你們中間做這種惡事。 ");
INSERT INTO cmncbt_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","13","「在你們的上帝耶和華將要賜給你們居住的各城中，如果你們聽說某城裡有惡人引誘城中的居民偏離正路，唆使他們去供奉你們不認識的其他神明， ");
INSERT INTO cmncbt_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","你們要認真查明真相。如果傳聞屬實，你們當中確有此惡行， ");
INSERT INTO cmncbt_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","你們一定要用刀殺光那城中的居民和牲畜。 ");
INSERT INTO cmncbt_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","你們要把城中的財物堆在廣場中心，然後放火焚燒那城和城中的財物，作為燔祭獻給你們的上帝耶和華。城要永遠荒廢，不可重建。 ");
INSERT INTO cmncbt_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","18","你們不可保留任何應當被毀滅的東西，這樣耶和華就不再向你們發怒，轉而施恩憐憫你們。 「只要你們遵守我今天吩咐你們的一切誡命，做耶和華視為正的事，祂必按照祂對你們祖先所起的誓，憐憫你們，使你們人丁興旺。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","「你們是你們上帝耶和華的兒女，不可為死人割傷自己或剃光前額。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","因為你們是你們的上帝耶和華的聖民，祂從天下萬族中揀選你們作祂寶貴的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","「你們不可吃任何可憎之物。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","但你們可以吃牛、綿羊、山羊、 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","鹿、羚羊、麅子、野山羊、瞪羚、黃羊和野綿羊。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","凡蹄子分瓣且反芻的動物，你們都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","在那些只反芻或只是蹄子分瓣的動物中，你們不可吃駱駝、野兔和石獾，因為牠們雖反芻但蹄子不分瓣，是不潔淨的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","你們也不可吃豬，因為豬雖蹄子分瓣但不反芻，是不潔淨的。你們不可吃這些動物的肉，也不可摸牠們的屍體。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","「水族中，凡有鰭有鱗的，你們都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","凡無鰭無鱗的都不潔淨，你們不可吃。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","「你們可以吃潔淨的鳥類。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","不可吃的鳥類有鵰、胡兀鷲、黑禿鷲、 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","鳶、隼類、 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","烏鴉類、 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","鴕鳥、夜鷹、海鷗、鷹類、 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","小鴞、大鴞、倉鴞、 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","鵜鶘、魚鷹、鸕鷀、 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","鸛、鷺鳥類、戴鵀和蝙蝠。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","「凡有翅膀、會爬的昆蟲都不潔淨，你們不可吃。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","凡有翅膀的潔淨之物，你們都可以吃。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","「你們不可吃死掉的動物，但可以送給住在你們城裡的外族人吃，或賣給其他外族人。因為你們是你們的上帝耶和華的聖民。你們不可用母山羊的奶煮牠的羊羔。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","「你們每年要獻出收成的十分之一； ");
INSERT INTO cmncbt_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","要在你們的上帝耶和華選定的敬拜場所，在祂面前吃所獻的十分之一的穀物、新酒、油以及頭生的牛羊。這是為了讓你們學習一生敬畏你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","如果你們的上帝耶和華賜福你們，使你們豐收，而你們住的地方離祂選定的敬拜場所太遠，以致不能把收成的十分之一送去， ");
INSERT INTO cmncbt_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","就可以把那些收成換成銀錢，帶到你們的上帝耶和華選定的場所。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","在那裡，你們可以隨意買牛、羊、淡酒或烈酒，然後一家人在你們的上帝耶和華面前吃喝快樂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","不可忘記住在你們城裡的利未人，因為利未人沒有分到土地作產業。 ");
INSERT INTO cmncbt_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","「每逢第三年末，你們要把那年所有出產的十分之一拿出來，存放在你們的城裡， ");
INSERT INTO cmncbt_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","讓你們城中沒有土地的利未人、寄居者和孤兒寡婦都可以來吃飽。這樣，你們的上帝耶和華必使你們凡事蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","「每逢第七年末，你們要免除他人的債務。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","你們要這樣做，所有債主都要免除同胞所欠的債務，不可向他們追討，因為宣佈免除債務的是耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","你們可以向外族人討債，但無論同胞欠你什麼債務，都要免除。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","5","只要你們留心聽從你們上帝耶和華的話，謹遵我今天吩咐你們的誡命，祂必使你們在祂賜給你們作產業的土地上蒙福，你們中間不會有窮人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","你們的上帝耶和華必照祂的應許賜福給你們，你們必借貸給多國，卻不需要向他們借貸。你們必統治多國，卻不被他們統治。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","「在進入你們的上帝耶和華將要賜給你們的土地後，如果你們居住的城中有貧窮的同胞，你們不可硬著心腸拒施援手。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","你們要伸出援手，按他們的所需慷慨地借給他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","你們要謹慎，不可因為免除債務的第七年將近，就心懷惡念，對貧窮同胞冷眼相待，拒施援手。否則，他們會向耶和華控訴你們，那時你們便有罪了。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","你們要慷慨給予，並且無怨無悔，因為你們的上帝耶和華必在你們所做的一切事上賜福給你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","你們居住的地方總會有窮人，所以我吩咐你們要慷慨地幫助貧窮和有需要的同胞。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","「如果你們的希伯來同胞，不論男女，賣身給你們為奴，他們要服侍你們六年，到第七年，你們要給他們自由。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","你們釋放他們時，不可讓他們空手離去， ");
INSERT INTO cmncbt_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","要慷慨地把你們的上帝耶和華賜給你們的羊、五穀和酒分給他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","要記住，你們曾在埃及做奴隸，你們的上帝耶和華救贖了你們。所以，我今天吩咐你們這樣做。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","如果你們的奴僕因為愛你們和你們的家人，與你們相處融洽，不願意離去， ");
INSERT INTO cmncbt_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","你們就要讓他靠在門上，用錐子在他耳朵上扎個洞，他便終身成為你們的奴僕。對待婢女也要這樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","你們釋放奴僕時，不要不情願，因為他們服侍你們六年，所做的是普通雇工的兩倍。而且，你們的上帝耶和華也會在你們所做的一切事上賜福給你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","「你們要把頭生的公牛和公羊分別出來，獻給你們的上帝耶和華。不可用頭生的公牛耕田，也不要剪頭生公羊的毛。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","每年，你們全家要去你們的上帝耶和華選定的地方，在祂面前吃這些頭生的牛羊。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","如果這些牛羊有什麼殘疾，如瘸腿、瞎眼或其他缺陷，就不可獻給你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","要在你們的城裡吃這些牛羊。潔淨的人和不潔淨的人都可以吃，就像吃羚羊和鹿一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","但不可吃牠們的血，要把血倒在地上，像倒水一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","「你們要在亞筆月為你們的上帝耶和華守逾越節，因為祂在這個月的一個晚上帶你們出了埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","你們要在你們的上帝耶和華為祂的名選定的居所，把牛羊作為逾越節的祭牲獻給祂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","吃祭牲的時候，不可吃有酵的餅，七天之內要吃無酵餅，即憶苦餅，以便你們一生謹記離開埃及的日子，因為當時你們離開得很倉促。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","那七天之內，你們境內不可有酵母。第一天傍晚獻的祭肉不可留到早晨。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","在你們的上帝耶和華將要賜給你們的各城中，你們不可獻逾越節的祭牲， ");
INSERT INTO cmncbt_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","而是要在傍晚日落時分，即你們離開埃及的時候，到你們的上帝耶和華為祂的名選定的居所獻逾越節的祭牲。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","你們要在那裡煮祭肉吃，第二天早晨可以返回自己的帳篷。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","在隨後的六天之內，你們要吃無酵餅。第七天，要舉行莊嚴的聚會，敬拜你們的上帝耶和華。那一天你們不可做工。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","「從收割那天開始算起，你們要算出七週的時間。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","七週後，要為你們的上帝耶和華守七七收穫節。那時，你們要按照你們的上帝耶和華所賜的福分，甘心樂意地獻上祭物。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","你們要和兒女、僕婢、同城的利未人、寄居者及孤兒寡婦，在你們的上帝耶和華為祂的名選定的居所，在祂面前一起歡喜快樂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","你們要記住自己曾在埃及做過奴隸，因此要謹遵這些律例。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","「在收藏好穀物和新酒後，你們要守七天的住棚節。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","住棚節期間，你們要和兒女、僕婢、同城的利未人、寄居者及孤兒寡婦一起歡慶。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","要在你們的上帝耶和華選定的地方，為祂守住棚節七天；要滿心歡喜，因為你們的上帝耶和華賜福你們，使你們的出產豐富、凡事順利。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","「你們所有男子要每年三次，即在除酵節、七七收穫節和住棚節，在你們的上帝耶和華指定的地方朝見祂。你們不可空手朝見耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","各人要按祂賜的福分，盡自己的能力獻上禮物。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","「要在你們的上帝耶和華將要賜給你們的各城中，按支派委任審判官及其他官員。官員們要秉公審判， ");
INSERT INTO cmncbt_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","不可徇私枉法、偏心待人，收受賄賂，因為賄賂蒙蔽智者的眼睛，使正直人顛倒是非。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","你們要追求公正公義，以便存活，承受你們的上帝耶和華賜給你們的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","「在為你們的上帝耶和華建造的祭壇旁，你們不可豎立亞舍拉木神像， ");
INSERT INTO cmncbt_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","也不可豎立神柱，因為這些是你們的上帝耶和華所憎惡的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","「不可把有缺陷或殘疾的牛羊獻給你們的上帝耶和華，因為這是祂所憎惡的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","「如果有人在你們的上帝耶和華賜給你們的各城鎮做祂視為惡的事，違背祂的約， ");
INSERT INTO cmncbt_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","不遵守祂的禁令，去供奉和祭拜其他神明，祭拜日、月或星辰， ");
INSERT INTO cmncbt_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","你們得知後，必須徹底調查。如果屬實，在以色列確實有人做這種可憎之事， ");
INSERT INTO cmncbt_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","就要把那人帶到城門口，用石頭打死他。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","但你們不可單憑一個證人便處死那人，要有兩三個證人方可處死他。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","證人要先扔石頭，眾人隨後，這樣就除掉了你們中間的罪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","「如果案件複雜，難以決斷，如謀殺、訴訟、人身傷害等，就要把案件帶到你們的上帝耶和華選定的地方， ");
INSERT INTO cmncbt_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","交給當值的利未祭司和審判官去審理，他們要向你們宣告判決。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","你們必須執行他們在耶和華所選擇的地方宣告的判決，你們要謹遵他們的一切指示。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","他們教導你們律法，宣佈判決後，你們必須完全執行，絲毫不可偏離。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","如果有人膽敢違抗事奉你們上帝耶和華的祭司和審判官的判決，就必須處死他。如此，你們便從以色列除掉了罪惡， ");
INSERT INTO cmncbt_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","使眾人得知後心中害怕，不敢再任意妄為。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","「你們進入並佔領你們的上帝耶和華將要賜給你們的土地，安頓下來後，就會想立自己的王，像周圍的國家一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","那麼，你們一定要立你們的上帝耶和華揀選的人；必須立你們的以色列同胞為王，不可立外族人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","王不可擁有大量馬匹，也不可派人到埃及去購買馬匹，因為耶和華已經告訴你們不可回埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","他不可擁有許多妃嬪，恐怕他的心會偏離耶和華，也不可為自己積蓄大量金銀。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","他登基後，要按照利未祭司的律法書為自己抄錄一份， ");
INSERT INTO cmncbt_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","把它放在身邊，一生誦讀，以便學習敬畏他的上帝耶和華，遵守律法書上的一切誡命和律例。 ");
INSERT INTO cmncbt_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","這樣，他就不會妄自尊大，違背誡命，他和他的子孫就可以長久統治以色列。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","「利未祭司及其他利未支派的人在以色列不可擁有土地。他們吃的是獻給耶和華的火祭，那是他們的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","他們在眾支派中沒有自己的產業，因為耶和華是他們的產業，這是祂的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","眾人所獻的牛羊的前腿、腮頰和胃應歸祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","你們要給祭司初收的五穀、新酒、新油和初剪的羊毛。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","因為你們的上帝耶和華從各支派中揀選了利未人，讓他們世代奉祂的名侍立供職。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","「以色列境內任何地方的利未人若願意離開自己所住的城，一心要去耶和華選定的地方， ");
INSERT INTO cmncbt_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","他可以像在耶和華面前事奉的其他利未人一樣，在那裡奉他的上帝耶和華之名事奉。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","除了變賣產業所得之外，他還可以分到與其他祭司同等分量的祭物。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","「你們進入你們的上帝耶和華將要賜給你們的土地後，不可仿效當地民族的可憎行徑。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","你們當中不可有人焚燒自己的子女作祭物，不可有人占卜、算命、作法、行邪術、 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","念咒、做靈媒、行巫術或求問亡靈。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","凡做這些事的人都是耶和華所憎惡的。正是因為當地的民族做這些可憎之事，你們的上帝耶和華才要當著你們的面把他們趕走。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","你們要在你們的上帝耶和華面前純全無過。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","「你們將要趕走的那些民族聽信術士和巫師，但你們的上帝耶和華不准你們仿效他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","你們的上帝耶和華要在你們中間興起一位像我一樣的先知，你們要聽從他。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","這正是你們在何烈山聚會時向你們的上帝耶和華所求的，當時你們說，『不要讓我們再聽見我們上帝耶和華的聲音，也不要讓我們再看見這烈火，免得我們死亡。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","於是，耶和華對我說，『他們說的對。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","我要在他們當中選立一位像你一樣的先知，我會告訴他該說的話，他要把我的一切吩咐告訴他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","如果有人不聽從他奉我的名所說的話，我必親自懲罰那人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","若有先知冒我的名說我未曾吩咐他的話，或以其他神明的名義說話，必須處死他。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","你們也許心裡會問，『我們如何知道是否是耶和華說的話呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","如果先知奉耶和華的名說的話沒有應驗，他的話就不是耶和華說的。他是妄自說預言，你們不用怕他。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","「你們的上帝耶和華毀滅那些民族，把他們的土地賜給你們，使你們趕走他們，住進他們的城邑和房屋後， ");
INSERT INTO cmncbt_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","3","你們要把你們的上帝耶和華賜給你們的土地劃分為三個地區，在每個地區設立一座避難城，修好通往這三座城的道路，以便誤殺人者可以逃往最近的避難城。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","「如果有人無意間殺了素無冤仇的同伴，他可以逃往避難城，以保住性命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","例如，有人和朋友去森林砍樹，砍伐時斧頭脫柄，誤殺了朋友，他就可以逃往其中一座避難城，以保住性命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","否則，如果避難城離誤殺人者太遠，怒火中燒的報血仇者就會追上去殺死他。其實他是不該死的，因為他與被誤殺的人素無冤仇。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","因此，我吩咐你們要設立三座避難城。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","9","「如果你們謹遵我今天吩咐你們的這一切誡命，愛你們的上帝耶和華，一生遵行祂的旨意，祂就會按照祂對你們祖先所起的誓，擴張你們的疆域，把應許給你們祖先的土地都賜給你們。那時，你們要再設三座避難城， ");
INSERT INTO cmncbt_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","免得無辜人的血流在你們的上帝耶和華賜給你們作產業之地，以致你們擔當枉殺無辜的罪。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","「如果有人因憎恨鄰居而暗中埋伏，攻擊並殺了鄰居，然後逃到其中一座避難城， ");
INSERT INTO cmncbt_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","他本城的長老要派人去把他帶回來，交給報血仇的人，將他處死。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","不可憐憫他，要從以色列除掉這種濫殺無辜的罪，這樣你們才會順利。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","「在你們的上帝耶和華將要賜給你們作產業之地，你們不可挪動鄰居的界石，因為那是先人立的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","「無論是什麼罪或過失，不可憑一個證人就定人的罪，必須有兩三個證人作證才能定案。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","如果有人作偽證誣陷別人， ");
INSERT INTO cmncbt_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","訴訟雙方要站在耶和華面前，讓當值的祭司和審判官定奪。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","審判官要仔細審查案件，如果發現那人作偽證誣陷同胞， ");
INSERT INTO cmncbt_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","就要按照他企圖加給被誣告者的傷害處罰他。這樣，就從你們當中除掉了罪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","其他人聽說後，都會害怕，不敢再做這種惡事。 ");
INSERT INTO cmncbt_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","你們對惡人不可心軟，要以命償命，以眼還眼，以牙還牙，以手還手，以腳還腳。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","「你們和敵人交戰時，面對比你們強大的軍隊及戰車戰馬，不要害怕，因為你們的上帝耶和華與你們同在，祂曾帶你們出埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","你們出戰之前，祭司要上前鼓舞士氣， ");
INSERT INTO cmncbt_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","說，『以色列人啊，聽著！今天你們要和敵人交戰，不要膽小害怕，也不要驚慌失措。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","因為你們的上帝耶和華要與你們同去，為你們爭戰，使你們戰勝仇敵。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","官長要對士兵說，『你們誰建了新房子還沒有舉行奉獻禮？他可以回家去，以免他陣亡了，別人為他的房子舉行奉獻禮。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","誰栽種了葡萄園還沒有享受過園中的果子？他可以回家去，以免他陣亡了，別人享受他園中的果子。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","誰訂了親還沒有迎娶？他可以回家去，以免他陣亡了，別人娶他的未婚妻。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","官長也要告訴士兵，『有沒有膽怯、害怕的？他可以回家去，免得影響他人士氣。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","他們講完後，就要委派將領率軍出戰。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","「你們進攻一座城之前，要先給城中居民求和的機會。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","如果他們開城求和，城裡所有人都要做你們的奴隸，為你們服勞役。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","如果他們不肯求和，要交戰，你們就要圍攻那城。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","你們的上帝耶和華把城交給你們時，你們要用刀殺光城裡所有的男子， ");
INSERT INTO cmncbt_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","但可以留下城中的婦女、孩童、牲畜及其他一切作戰利品。你們可以享用仇敵的財物，那是你們的上帝耶和華賜給你們的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","上述做法只適用於離你們很遙遠的城邑，你們附近各族的城邑除外。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","你們的上帝耶和華將把你們附近各族的城邑賜給你們作產業，你們要將裡面有氣息的全部消滅。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","要遵照你們的上帝耶和華的吩咐，徹底滅絕赫人、亞摩利人、迦南人、比利洗人、希未人和耶布斯人， ");
INSERT INTO cmncbt_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","免得他們將祭拜自己神明的可憎習俗傳給你們，以致你們得罪你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","「你們圍攻一座城久攻不下時，不可用斧頭砍掉那裡的樹木，因為你們可以吃樹上的果子。田間的樹木豈是人，讓你們圍攻嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","但你們可以砍那些不結果子的樹來建圍城的工事，直到攻陷為止。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","「在你們的上帝耶和華將要賜給你們的土地上，如果發現有人被殺，陳屍野外，卻不知道兇手是誰， ");
INSERT INTO cmncbt_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","當地的長老和審判官就要去測量一下屍體距附近各城邑的距離。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","距離屍體最近的那城的長老們要牽一頭從未負過軛、從未耕過地的小母牛， ");
INSERT INTO cmncbt_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","去有溪流但無人耕種過的山谷，在那裡把牠的頸項打斷。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","利未祭司也要去，因為你們的上帝耶和華揀選他們在祂面前事奉、奉祂的名為人祝福，並審理各種糾紛及人身傷害的事。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","那城的長老們要在被打斷頸項的小母牛上方洗手， ");
INSERT INTO cmncbt_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","然後禱告說，『我們的手沒有殺這人，我們的眼也沒有看見誰殺了他。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","耶和華啊，求你赦免你已經救贖的以色列子民，不要把殺害這無辜之人的罪算在你的子民身上。』這樣，殺人的罪便可得到赦免。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","你們做耶和華視為正的事，就可以從你們中間除去殺害無辜之人的罪。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","「你們和敵人交戰時，你們的上帝耶和華會把敵人交給你們，使他們成為你們的俘虜。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","如果你們有人在俘虜中看見美麗的女子，被她吸引，想娶她為妻， ");
INSERT INTO cmncbt_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","就可以帶她回家，讓她剃去頭髮，修剪指甲， ");
INSERT INTO cmncbt_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","換掉被俘時所穿的衣服，住在那人家中為她父母哀悼一個月。之後，那人便可以和她結為夫妻。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","如果那人不喜歡她，則要讓她自由離去，絕不可賣掉她，也不可奴役她，因為他已經羞辱了她。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","「如果一個人有兩個妻子，一個受他寵愛，一個不受他寵愛，二人都給他生了兒子，但長子是不受寵愛的妻子生的， ");
INSERT INTO cmncbt_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","分產業的時候，他不可廢長立幼，把長子的權利給他所愛之妻生的兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","他必須承認他不愛之妻所生的長子的名分，分給他雙份產業，因為長子是他壯年時所生的兒子，應享有長子的權利。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","「如果一個人的兒子冥頑不靈、悖逆父母、屢教不改， ");
INSERT INTO cmncbt_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","他父母要抓住他，把他帶到城門口去見本城的長老，對他們說， ");
INSERT INTO cmncbt_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","『我們這個兒子冥頑不靈、悖逆成性，不肯聽從我們，是個貪吃好酒之徒。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","全城的人都要用石頭打死他，從你們中間除掉這種罪惡。所有以色列人聽說後，都會感到害怕。 ");
INSERT INTO cmncbt_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","「如果有人犯了死罪，被處死後掛在木頭上， ");
INSERT INTO cmncbt_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","不可讓屍體在木頭上過夜，必須當天埋葬，因為凡掛在木頭上的人都是上帝所咒詛的。你們不可玷污你們的上帝耶和華將要賜給你們的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","「如果你們看見同胞的牛或羊走迷了路，不可視而不見，要把牠帶回去交給失主。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","如果失主離你們很遠，或者你們不知道失主是誰，就要把牠牽回家，等失主來找時再還給他。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","見到同胞遺失的驢、衣物或其他東西，都要這樣處理，不可視而不見。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","如果在路上看見同胞的牛或驢倒在地上，不可視而不見，要幫忙把牠扶起來。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","「女人不可穿戴男人的衣物，男人也不可穿戴女人的衣物，因為這是你們的上帝耶和華所憎惡的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","「如果你們在路邊的樹上或地上看見鳥巢，裡面有雛鳥或蛋，並有母鳥伏在上面，不可把母鳥和雛鳥一起取走。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","你們可以取走雛鳥，但一定要放走母鳥。這樣，你們就會凡事順利，得享長壽。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","「建造新房時，要在房頂上安設圍欄，免得有人從房頂上掉下來，由你們家承擔流血之罪。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","「你們不可在葡萄園裡種別的作物，否則你們的收成和園中的果子都要充公。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","不可讓牛和驢同負一軛耕地。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","不可穿由羊毛和細麻合織的衣物。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","「要在外袍的四角綴上穗子。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","「如果有人娶了妻子，與她同房後卻不喜歡她， ");
INSERT INTO cmncbt_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","誹謗她，說，『我娶了她，與她親近時發現她已經不是處女』， ");
INSERT INTO cmncbt_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","女方父母就要把憑據拿到城門口的長老們面前，證明女兒的貞潔。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","女方的父親要對他們說，『我把女兒嫁給這個人，現在他不喜歡我女兒， ");
INSERT INTO cmncbt_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","誹謗她，聲稱她結婚時已經不是處女，但這裡有我女兒貞潔的憑據。』女方父母要把女兒新婚之夜用過的床單在本城的長老們面前展開。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","長老們就必須抓住那人懲處他， ");
INSERT INTO cmncbt_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","罰他賠償二十兩銀子給女方的父親，因為他誹謗了一個以色列的處女。那女子仍要做他妻子，丈夫終生不可休她。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","「但如果那人的指控屬實，沒有找到那女子貞潔的憑據， ");
INSERT INTO cmncbt_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","就要把她帶到她父親的家門前，由本城的人用石頭打死她。因為她婚前淫亂，在以色列做了可恥的事。你們必須除掉你們中間的罪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","「如果有人與有夫之婦通姦，必須處死姦夫和淫婦，這樣就從以色列除掉了罪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","「如果有人在城中遇見已經訂婚的女子，與她行淫， ");
INSERT INTO cmncbt_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","你們必須把二人帶到城門口，用石頭打死他們。那女子該死，因為她在城中卻沒有高聲呼救；那男子該死，因為他姦污了別人的妻子。你們必須除去你們中間的罪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","「如果有人在野外遇見已經訂婚的女子，強姦了她，必須處死那男子。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","但不可處死那女子，因為她沒有犯該死的罪，她像被攻擊、殺害的人一樣是無辜的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","因為她是在野外被強姦，即使呼救也無人救她。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","「如果有人遇見未訂婚的處女，強姦了她，被發現後， ");
INSERT INTO cmncbt_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","這人要付給女方的父親十兩銀子，並娶她為妻，終生不可休她，因為他姦污了她。 ");
INSERT INTO cmncbt_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","「人不可娶他父親的妻妾，因為這是對他父親的羞辱。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","「凡睪丸受損或被閹割的，不可加入耶和華的會眾。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","「私生子及其十代以內的子孫都不可加入耶和華的會眾。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","「亞捫人或摩押人不可加入耶和華的會眾，他們的子孫就是到了第十代也不可加入。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","因為在你們離開埃及的途中，他們沒有用水和食物款待你們，還雇用美索不達米亞的毗奪人比珥的兒子巴蘭咒詛你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","但你們的上帝耶和華不聽巴蘭的話，反而把咒詛變為祝福，因為祂愛你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","你們一生一世永不可為他們謀求平安和好處。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","「不可憎惡以東人，因為他們是你們的弟兄；也不可憎惡埃及人，因為你們曾經在埃及寄居。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","他們的第三代子孫可以加入耶和華的會眾。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","「你們出兵征戰時，一定要遠離惡事。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","如果有人因夢遺而不潔淨，他就要離開營地，住在營外。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","傍晚他要沐浴，日落才可以回營。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","要在營外指定一個地方作方便之處。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","你們每人要裝備一把鏟子，便溺時要挖個洞，事後要掩埋。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","因為你們的上帝耶和華常在營中巡視，要保護你們，擊敗你們的仇敵。軍營必須保持聖潔，免得祂在你們中間看到任何污穢之事，便離開你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","「如果有奴隸逃到你們那裡避難，不可把逃亡的奴隸送交他們的主人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","要讓他們在你們當中選擇他們喜歡的城邑與你們同住，不可壓迫他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","「任何以色列人，不論男女，都不可做廟妓。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","不可把男女廟妓的收入帶到你們上帝耶和華的殿還願，因為兩者都是你們的上帝耶和華所憎惡的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","「你們借給同胞錢、糧食或其他任何東西，都不可收取利息。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","你們可以向外族人收取利息，但不可向同胞收取。這樣，在你們將要佔領的土地上，你們的上帝耶和華必使你們凡事蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","「如果你們向你們的上帝耶和華許願，不可遲遲不還願，因為你們的上帝耶和華必追討許願不還的罪。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","如果你們不許願，反倒無罪。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","但如果你們親口向你們的上帝耶和華許了願，一定要履行諾言。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","「如果你們進了鄰居的葡萄園，可以隨意吃，但不可把葡萄放在籃子裡帶走。 ");
INSERT INTO cmncbt_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","如果你們進了鄰居的麥田，可以用手摘麥穗，但不可用鐮刀割麥子。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","「如果有人娶妻後，發覺妻子行為不檢，因而嫌棄她，他可以寫休書給她，讓她離開夫家。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","她離開後，可以自由再婚。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","如果她的後夫也嫌棄她，寫休書給她，讓她離開夫家，或者後夫死了， ");
INSERT INTO cmncbt_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","前夫不可再娶這已被玷污的女子，因為那是耶和華所憎惡的。你們不可把這種罪惡帶到你們的上帝耶和華將要賜給你們的土地上。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","「不可叫新婚的人從軍出征或辦理公務。他可以留在家裡一年，使新婚的妻子快樂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","「不可拿別人的磨或磨的上盤作抵押品，因為這等於拿他們的生命作抵押。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","「如果有人綁架自己的同胞，奴役他或賣掉他，必須處死綁架者，除掉你們中間的罪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","「遇到痲瘋病，你們要謹遵利未祭司的指示。你們要謹遵我對他們的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","要記住你們離開埃及後，你們的上帝耶和華在米利暗身上的作為。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","「如果你們借貸給同胞，不可走進他家裡索取抵押物； ");
INSERT INTO cmncbt_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","要站在外面，等他把抵押物拿出來。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","如果他是窮人，用自己的外袍作抵押，你們不可把他的外袍留到第二天， ");
INSERT INTO cmncbt_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","要在當天日落之前還給他，好讓他蓋著外袍睡覺。他會因此祝福你們，你們的上帝耶和華也會將此視為你們的義行。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","「不可欺壓窮苦的雇工，不論他們是你們的同胞，還是住在你們城中的外族人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","你們要在每天日落前付給他們工錢，因為他們窮苦，靠工錢維生；否則他們向耶和華控訴你們，你們就有罪了。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","「不可因孩子犯罪而處死父親，也不可因父親犯罪而處死孩子。各人要自負罪責。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","「你們要公正地對待寄居者和孤兒，不可拿寡婦的衣物作抵押。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","要記住，你們曾在埃及做過奴隸，你們的上帝耶和華救贖了你們。所以，我吩咐你們這樣行。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","「你們在田間收割莊稼時若遺落了一捆，不可回去取，要留給孤兒寡婦和寄居者。這樣，你們的上帝耶和華必使你們凡事蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","你們打橄欖時，打過一次後不可再打，要把剩下的留給孤兒寡婦和寄居者。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","你們摘葡萄時，摘過一次後不可再摘，要把剩下的留給孤兒寡婦和寄居者。 ");
INSERT INTO cmncbt_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","要記住，你們曾在埃及做過奴隸。所以，我吩咐你們這樣行。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","「如果發生糾紛，雙方告上法庭，審判官要判明是非。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","如果有罪的一方被判受鞭打，審判官要命令他當場伏在地上，按罪行輕重量刑。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","最多可以鞭打他四十下。如果超過四十下，你們就是在公開羞辱自己的同胞。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","「牛在踩穀時，不可籠住牠的嘴。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","「如果兄弟們住在一起，其中一個沒有兒子便死了，死者的妻子不可改嫁外人。死者的兄弟要盡兄弟的責任娶她為妻。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","她生的第一個兒子要算為死者的兒子，免得死者在以色列無法留名。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","如果死者的兄弟不願娶那寡婦，她要到城門口見長老們，告訴他們，『我丈夫的兄弟不肯盡兄弟的責任娶我，不肯為我丈夫在以色列留名。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","本城的長老們要把死者的兄弟召來，與他商談。如果他執意不肯， ");
INSERT INTO cmncbt_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","那寡婦要當著眾長老的面，上前脫下他的鞋，吐唾沫在他臉上，說，『這就是不肯為兄弟留後之人的下場。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","從此以後，他的家在以色列要被稱為『被脫鞋者之家』。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","「如果兩個男人打架，其中一人的妻子為幫助丈夫而伸手抓住另外一人的下體， ");
INSERT INTO cmncbt_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","就要砍掉她的手，不可憐憫她。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","「你們做買賣時，口袋裡不可有一大一小兩種砝碼， ");
INSERT INTO cmncbt_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","家裡也不可用一大一小兩種量器。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","你們必須使用準確公正的砝碼和量器，以便在你們的上帝耶和華要賜給你們的土地上得享長壽。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","因為你們的上帝耶和華憎惡行事詭詐的人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","「你們要記住，你們從埃及出來的路上，亞瑪力人是怎樣對待你們的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","他們趁你們疲憊不堪時，襲擊你們當中掉隊的人，毫不敬畏上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","所以，當你們的上帝耶和華賜給你們那片土地作產業、使你們四境安寧時，要滅絕亞瑪力人，抹去世人對他們的記憶。你們要切記！ ");
INSERT INTO cmncbt_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","「你們進入你們的上帝耶和華將要賜給你們作產業的土地，佔領那裡，安居下來以後， ");
INSERT INTO cmncbt_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","要把在那裡收穫的各種初熟的物產放在籃子裡，帶到你們的上帝耶和華為祂的名選定的居所。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","你們要對當值的祭司說，『今天我要向我們的上帝耶和華宣告，我已經進入祂向我們祖先起誓要賜給我們的土地。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","祭司要從你們手中接過籃子，放在你們的上帝耶和華的祭壇前。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","你們要在你們的上帝耶和華面前宣告，『我們的祖先原是漂泊的亞蘭人。他下到埃及寄居時，家中人丁稀少，後來成為人口眾多的強大民族。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","埃及人苦待我們，壓迫我們，強迫我們做苦工。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","於是，我們呼求我們祖先的上帝耶和華。祂聽見我們的呼求，看見我們的痛苦、艱辛和所受的壓迫， ");
INSERT INTO cmncbt_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","就伸出臂膀，用大能的手行神蹟奇事，以偉大而可畏的作為帶我們出埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","祂帶領我們來到這個地方，把這奶蜜之鄉賜給我們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","耶和華啊，現在我從你賜給我的土地上帶來初熟的物產。』你們要把籃子放在你們的上帝耶和華面前，敬拜祂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","你們和利未人以及住在你們中間的外族人，都要因你們的上帝耶和華賜給你們和你們家人的福祉而歡喜快樂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","「每逢第三年是十一奉獻年。你們應當把自己所有出產的十分之一拿出來分給利未人、寄居者和孤兒寡婦，使他們在你們居住的城邑吃飽喝足。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","然後，你們要在你們的上帝耶和華面前宣告，『我已經按照你的誡命，從家裡拿出聖物分給利未人、寄居者和孤兒寡婦。我沒有觸犯也沒有忘記你的任何誡命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","這些聖物，我守喪期間沒有吃過，不潔淨時沒有拿過，也沒有獻給死人。我聽從我的上帝耶和華，遵行你的一切吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","求你從天上聖潔的居所垂看，賜福給你的以色列子民和你賜給我們的土地，就是你向我們祖先起誓應許的奶蜜之鄉。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","「你們的上帝耶和華今天吩咐你們遵守這些律例和典章，你們要全心全意地謹慎遵守。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","你們今天已經宣佈耶和華是你們的上帝，並願意遵行祂的道，謹守祂的一切律例、誡命和典章，聽從祂的話語。 ");
INSERT INTO cmncbt_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","耶和華今天已經照祂的應許宣佈你們是祂的子民，是祂寶貴的產業。因此，你們要遵守祂的一切誡命， ");
INSERT INTO cmncbt_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","這樣祂必使你們備受讚譽和尊崇，超越祂所造的萬國，並照著祂的應許使你們做祂的聖民。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","摩西和以色列眾長老吩咐民眾說：「你們要遵守我今天吩咐你們的一切誡命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","你們渡過約旦河、進入你們的上帝耶和華賜給你們的土地那天，要豎立幾塊大石，塗上石灰。 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","你們渡過約旦河，進入你們祖先的上帝耶和華應許要賜給你們的奶蜜之鄉後，要把這律法一字不漏地寫在大石上。 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","你們渡過約旦河後，要照我今日的吩咐，在以巴路山上豎立這些石頭，塗上石灰。 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","要在那裡為你們的上帝耶和華築一座石壇，不要用鐵器鑿刻石頭。 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","要用未鑿過的石頭為你們的上帝耶和華築一座壇，在上面獻燔祭給祂； ");
INSERT INTO cmncbt_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","又要獻上平安祭，在祂面前吃喝快樂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","你們要把這律法一字不漏、清清楚楚地寫在那幾塊大石上。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","摩西和利未祭司對全體以色列人說：「以色列人啊，要肅靜聆聽！你們今天已成為你們上帝耶和華的子民。 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","你們要聽從祂，遵守祂的誡命和律例，就是我今天吩咐你們的。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","那天，摩西吩咐民眾說： ");
INSERT INTO cmncbt_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","「你們渡過約旦河後，西緬、利未、猶大、以薩迦、約瑟和便雅憫各支派要站在基利心山上為民眾祝福； ");
INSERT INTO cmncbt_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","呂便、迦得、亞設、西布倫、但和拿弗他利各支派要站在以巴路山上宣告咒詛。 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","利未人要對所有以色列人高聲說： ");
INSERT INTO cmncbt_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","「『凡雕刻或鑄造耶和華所憎惡的神像，就是匠人製作的，並偷偷供奉的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","「『凡不尊敬父母的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","「『凡挪移鄰居界石的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","「『凡故意帶領盲人走錯路的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","「『凡不為寄居者和孤兒寡婦伸張正義的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","「『凡與父親的妻妾亂倫的必受咒詛，因為他羞辱了父親！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","「『凡與獸交合的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","「『凡與同父異母或同母異父的姊妹亂倫的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","「『凡與岳母亂倫的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","「『凡暗殺鄰居的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","「『凡因收受賄賂而殺害無辜的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","「『凡不遵行這律法的必受咒詛！』 全體民眾要回答說，『阿們！』 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","「你們若全心順服你們的上帝耶和華，謹遵祂今天藉我吩咐你們的一切誡命，祂必使你們超越天下萬國。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","你們若聽從你們的上帝耶和華的話，以下這些福氣必臨到你們，追隨你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","「無論你們在城裡還是鄉間，都必蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","「你們必子孫昌盛，五穀豐登，牛羊成群。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","「你們的籃子和揉麵盆都必蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","「你們出入都必蒙福。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","「耶和華必使來犯之敵敗在你們面前、潰不成軍、四散逃命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","「耶和華必使你們凡事蒙福、五穀滿倉。你們的上帝耶和華必在祂賜給你們的土地上賜福你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","「你們若遵守你們上帝耶和華的誡命，遵行祂的旨意，祂必按自己的誓言立你們作祂聖潔的子民。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","天下萬民將看出你們是耶和華名下的子民，並懼怕你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","「在耶和華向你們祖先起誓要賜給你們的土地上，祂必使你們子孫昌盛、牛羊成群、五穀豐登。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","耶和華要為你們打開天上的寶庫，使你們風調雨順、凡事蒙福。你們必借貸給多國，卻無需向別國借貸。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","14","你們若聽從你們的上帝耶和華藉我今天吩咐你們的誡命，謹慎遵行，毫不偏離，也不隨從、供奉其他神明，祂必使你們做首不做尾，居上不居下。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","「你們若不聽從你們的上帝耶和華，不謹遵祂今天藉我吩咐你們的一切誡命和律例，祂必使以下的咒詛臨到你們，追隨你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","「無論你們在城裡還是鄉間，都必受咒詛。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","「你們的籃子和揉麵盆都必受咒詛。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","「婦女所生的，土地所產的，牛羊所生的都必受咒詛。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","「你們出入都必受咒詛。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","「因為你們作惡、背棄耶和華，祂要使你們凡事受咒詛、混亂不堪、飽受責罰，直到你們被毀滅，迅速滅亡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","「耶和華要使瘟疫緊緊跟隨你們，直到你們在將要佔領的土地上被滅絕。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","「耶和華要使你們遭受癆病、熱症、炎症、炙熱、刀劍、乾旱和黴爛之災。這些要危害你們，直到你們滅亡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","「耶和華要使你們頭頂的天如銅，腳下的地如鐵。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","「耶和華要使雨水變為塵土，降在你們身上，直到你們滅亡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","「耶和華要使你們被敵人擊敗、潰不成軍、四散逃命，下場令天下萬國驚懼。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","你們的屍體要成為飛禽走獸的食物，必無人趕走牠們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","「耶和華要使你們患埃及的膿瘡、腫瘤和癬疥，無藥可治。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","「耶和華要使你們發瘋、瞎眼、心智錯亂。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","「你們必在大白天摸索，就像盲人在黑暗中摸索一樣，你們的道路必不得亨通，你們要終日受人欺壓搶掠，無人搭救。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","「你們聘了妻子，別人必佔有她們；你們蓋了房屋，必不能住在裡面；你們栽種葡萄園，必吃不到園中的出產。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","「你們必看著自己的牛被宰殺卻吃不到肉，自己的驢被搶走後一去不還，自己的羊被敵人擄走卻無人搭救， ");
INSERT INTO cmncbt_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","自己的兒女被外族人擄走，你們終日望眼欲穿，卻無能為力。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","「與你們素不相識的民族必吃光你們土地的出產和勞碌所得，你們必常受欺壓， ");
INSERT INTO cmncbt_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","以致眼前的一切令你們發瘋。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","「耶和華要使你們從頭到腳長滿毒瘡，無藥可治。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","「耶和華要帶你們和你們立的王，到一個你們和你們祖先都不知道的國家，你們要在那裡供奉木石神像。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","「在耶和華驅逐你們去的列國，你們的下場令人驚駭，被人嘲笑和譏諷。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","「你們種的多，卻收的少，因為莊稼必被蝗蟲吃掉。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","「你們栽種、修剪葡萄園，卻吃不到葡萄，也喝不到葡萄酒，因為葡萄必被蟲子吃掉。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","「你們境內長滿橄欖樹，卻沒有橄欖油抹身，因為橄欖必未熟先落。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","「你們生兒育女，卻留不住一個，因為他們必被擄走。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","「蝗蟲要吃光你們的樹木和地上的出產。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","「你們中間的外族人要日益興旺，你們卻要日漸衰微。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","「他們要借貸給你們，你們卻不能借貸給他們。他們要做首，你們要做尾。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","「因為你們不聽從你們上帝耶和華的話，不遵守祂吩咐你們的誡命和律例，這些咒詛都必臨到你們、追趕你們，直到毀滅你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","這些咒詛要永遠作為你們和你們子孫的神蹟奇事。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","因為你們在富足時不心甘情願地事奉你們的上帝耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","所以你們必饑餓乾渴、赤身裸體、一無所有地侍奉耶和華派來攻擊你們的敵人。祂要把鐵軛加在你們的頸上，直到消滅你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","「耶和華要使一國從遙遠的地極興起，他們要如鷹飛來襲擊你們。你們不懂他們的語言。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","他們面目猙獰，不尊重年老的，也不憐憫年少的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","他們要吃光你們的牛羊、五穀、新酒和油，直到消滅你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","在你們的上帝耶和華所賜給你們的整片土地上，他們要把你們圍困在各個城邑中，直到你們所依賴的高大堅固的城牆都倒塌。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","「當你們被敵人圍困、陷入絕境時，你們必吃自己的親生骨肉，就是你們的上帝耶和華賜給你們的兒女。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","55","你們被敵人圍困在各城中，陷入絕境時，連你們中間最溫柔體貼的男人也要獨自吞吃子女的肉，不肯分給自己的兄弟、愛妻和剩下的兒女，因為他別無所有。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","57","你們被敵人困在各城中，陷入絕境時，連你們中間最溫柔、嬌嫩得連腳也不肯踏在地上的婦女，都要偷偷吃掉自己生的嬰兒和胎胞，不肯分給所愛的丈夫和子女。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","「如果你們不謹遵這書上所寫的一切律法，不敬畏你們的上帝耶和華那榮耀、可畏的名， ");
INSERT INTO cmncbt_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","祂必使你們及子孫遭遇嚴重而長久的災難和疾病， ");
INSERT INTO cmncbt_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","使你們所懼怕的埃及人的一切疾病都降在你們身上，纏住你們， ");
INSERT INTO cmncbt_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","還使各種未記在這律法書上的疾病和災難降在你們身上，直到消滅你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","因為你們不聽從你們的上帝耶和華的話，即使你們的人數多如天上的星，也將所剩無幾。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","正如耶和華喜歡賜福你們，使你們人丁興旺，祂也同樣會不惜消滅你們，使你們在將要佔領的土地上被剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","「耶和華要把你們分散到天下萬邦，你們要在那裡供奉祖祖輩輩素不認識的木石神像。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","你們在萬邦中將不得安寧，沒有落腳之地，耶和華必使你們膽戰心驚、目光呆滯、精神頹廢。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","你們必惴惴不安，晝夜恐懼，生死難料。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","你們必看見可怕之事，以致心中充滿恐懼，早上盼望天黑，晚上盼望天亮。 ");
INSERT INTO cmncbt_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","耶和華必沿著我曾說你們再不會走的路線，用船把你們送回埃及。你們將在那裡賣身做敵人的僕婢，卻無人買。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","耶和華除了與以色列人在何烈山立約外，還在摩押吩咐摩西與以色列人立以下的約。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","摩西召來所有以色列人，對他們說：「你們曾親眼見過耶和華在埃及怎樣對付法老及其臣僕和國民， ");
INSERT INTO cmncbt_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","親眼看見祂怎樣降下巨大的災難，行偉大的神蹟奇事。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","但耶和華至今還沒有賜給你們能明白的心、能看見的眼、能聽清的耳。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","四十年來，耶和華領你們走過曠野，你們身上的衣服沒有穿破，腳上的鞋沒有穿壞； ");
INSERT INTO cmncbt_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","你們沒有吃餅，也沒有喝淡酒和烈酒。這是為了讓你們知道耶和華是你們的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","我們來到這裡的時候，希實本王西宏和巴珊王噩都出來攻擊我們，我們擊敗了他們， ");
INSERT INTO cmncbt_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","並將佔領的土地分給呂便支派、迦得支派和瑪拿西半個支派作產業。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","所以，你們要謹遵這約上的話，以便凡事順利。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","「今天，你們全都站在你們的上帝耶和華面前，包括你們的族長、長老、官員、所有以色列男子、 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","你們的孩子、妻子和寄居在你們營中為你們砍柴挑水的外族人， ");
INSERT INTO cmncbt_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","為要接受你們的上帝耶和華今天與你們立的誓約。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","這樣，祂今天將確立你們作祂的子民、祂作你們的上帝，正如祂對你們的應許和對你們祖先亞伯拉罕、以撒和雅各的誓言。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","耶和華的這誓約不僅是與你們立的， ");
INSERT INTO cmncbt_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","也是與今天一同站在我們的上帝耶和華面前的人，以及今天不在這裡的人立的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","「你們知道我們如何在埃及生活，也知道我們如何穿越列國來到這裡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","你們也見過他們可憎的木、石、金、銀偶像。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","你們中間，不論男人或女人，家族或支派，切不可有人背棄我們的上帝耶和華，去祭拜列國的神明，你們中間切不可有殘根長出苦毒的果實， ");
INSERT INTO cmncbt_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","免得有人聽了這誓言後，心存僥倖地說，『即使我一意孤行，連累他人，也必平安無事。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","耶和華絕不會赦免這樣的人，祂必向這樣的人發烈怒和義憤，使記在這書上的一切咒詛臨到他身上，從世上抹去他的名字。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","耶和華必把他從以色列各支派中隔離出來，使他按律法書上約中的一切咒詛受懲罰。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","「你們的子孫後代和從遠方來的外族人，必看見耶和華降在這地方的災禍和疾病。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","遍地將是硫磺和鹽，無法耕種，寸草不生，如同耶和華盛怒之下毀滅的所多瑪、蛾摩拉、押瑪和洗扁。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","萬國必問，『耶和華為什麼要這樣對待這地方？祂為什麼大發烈怒？』 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","必有人回答說，『因為這地方的人背棄了他們祖先的上帝耶和華領他們出埃及時與他們所立的約， ");
INSERT INTO cmncbt_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","去供奉其他神明，祭拜他們不認識、也非耶和華分派給他們的神明。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","因此，耶和華向這片土地發怒，把這書上寫的一切咒詛都降在這裡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","耶和華在怒氣、義憤和烈怒中把他們從這地方連根拔起，扔到別的地方，正如今日的情形。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","「奧秘的事屬於我們的上帝耶和華，只有顯明的事永遠屬於我們和我們的子孫，以便我們可以遵守這律法上的一切話。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","「當我向你們陳明的這些祝福和咒詛都應驗在你們身上時，如果你們在你們的上帝耶和華驅逐你們去的各國中回想這些話， ");
INSERT INTO cmncbt_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","歸向你們的上帝耶和華，你們及子孫照我今天的吩咐，全心全意地聽從祂的話， ");
INSERT INTO cmncbt_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","祂必改變你們被擄的境遇，憐憫你們，把你們從祂驅逐你們去的列國招聚回來。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","即使你們被驅逐到天涯，你們的上帝耶和華也會召集你們，帶你們回來， ");
INSERT INTO cmncbt_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","帶到你們祖先的土地上，使你們擁有那片土地，比你們祖先更加人丁興旺、繁榮昌盛。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","你們的上帝耶和華要潔淨你們和你們子孫的心，好讓你們全心全意地愛祂，並且存活。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","你們的上帝耶和華要把所有的咒詛加在你們的仇敵及憎惡你們、迫害你們的人身上。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","你們必再次聽從耶和華，遵行今天祂藉我吩咐你們的一切誡命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","10","倘若你們聽從你們的上帝耶和華的話，遵守這律法書上的誡命和律例，全心全意地歸向祂，祂必使你們凡事蒙福、兒女眾多、牛羊成群、五穀豐登。因為祂必樂意再次賜福你們，像從前賜福你們祖先一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","「我今天頒佈給你們的誡命，對你們來說不難，也非遙不可及。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","這誡命並非在天上，以致你們說，『誰替我們上天取下來，講給我們聽，讓我們遵行呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","這誡命也不在海的彼岸，以致你們說，『誰替我們過海取來，講給我們聽，好讓我們遵行呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","這話語近在咫尺，就在你口裡，在你心中，好讓你遵行。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","「看啊，今天我把生死禍福擺在你們面前。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","我今天吩咐你們要愛你們的上帝耶和華，遵行祂的旨意，遵守祂的誡命、律例和典章，以便你們可以存活，人丁興旺，在你們將要佔領的土地上蒙祂賜福。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","但倘若你們心中偏離，不肯聽從，被引誘去祭拜、供奉其他神明， ");
INSERT INTO cmncbt_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","我今天警告你們，你們必定滅亡，在約旦河西岸你們將要去佔領的土地上無法長久。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","今天，我叫天地為你們作證，我已把生死禍福擺在你們面前。選擇生命吧，以便你們及子孫可以存活。 ");
INSERT INTO cmncbt_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","要愛你們的上帝耶和華，聽從祂的話，倚靠祂，因為祂是你們的生命，祂必使你們長久住在祂起誓要賜給你們祖先亞伯拉罕、以撒和雅各的土地上。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","摩西繼續對以色列人說： ");
INSERT INTO cmncbt_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","「我現在已經一百二十歲了，無法再繼續帶領你們，耶和華曾說我不得過約旦河。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","你們的上帝耶和華要親自帶領你們過河，在你們面前消滅那裡的各族，使你們佔領他們的土地。約書亞將帶領你們過河，正如耶和華所言。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","耶和華要毀滅那裡的各族，像毀滅亞摩利二王西宏和噩及其國家一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","耶和華要把他們交給你們，你們要照我的一切吩咐處置他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","你們要剛強勇敢，不要懼怕他們，因為你們的上帝耶和華與你們同行，祂不會撇下你們，也不會離棄你們。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","摩西把約書亞叫來，當著全體以色列人的面對他說：「你要剛強勇敢！因為你要與百姓一同進入耶和華起誓要賜給他們祖先的土地，把土地分給他們作產業。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","耶和華必帶領你，與你同在。祂不會撇下你，也不會離棄你。不要驚慌害怕。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","摩西把這律法寫好，交給抬耶和華約櫃的利未祭司和以色列的眾長老。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","摩西吩咐他們說：「每逢免除債務的第七年的住棚節， ");
INSERT INTO cmncbt_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","所有以色列人到你們的上帝耶和華選定的地方朝見祂時，你們要當眾大聲宣讀這律法。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","要招聚所有男女、孩童以及住在你們中間的外族人，讓他們聆聽這律法，學習敬畏你們的上帝耶和華，謹遵律法上的一切話。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","這樣，他們那些還不知道這律法的孩子便有機會聽到律法，在你們將要佔領的約旦河西岸的土地上，學習終生敬畏你們的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","耶和華對摩西說：「你快要離世了。叫約書亞與你一起到會幕，我要委派他。」摩西和約書亞就來到會幕。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","有雲柱停在會幕入口的上方，耶和華在雲柱中向他們顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","耶和華對摩西說：「你快要與祖先同眠了。這些百姓將很快在要佔領的土地上與外族人的神明苟合，背棄我，違背我與他們所立的約。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","那時，我要向他們發怒，離棄他們，掩面不理他們。他們將被吞滅，遭遇許多禍患和災難，以致他們會說，『這些禍患臨到我們，豈不是因為上帝不在我們中間了嗎？』 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","那時，我必掩面不理他們，因為他們祭拜其他神明，行為邪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","「現在，你要寫一首歌，教導以色列人，讓他們吟唱，作為我指控他們的證據。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","因為當我把他們帶到我起誓應許他們祖先的奶蜜之鄉後，當他們在那裡吃飽喝足後，就會嫌棄我，違背我與他們所立的約，去供奉其他神明。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","當許多禍患和災難臨到他們的時候，這首歌就要成為指控他們的證據，因為這首歌要在他們的子孫中世代流傳。雖然我還沒有帶領他們進入我起誓應許之地，我已經知道他們的心思意念。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","當天，摩西就寫下這首歌，傳授給以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","耶和華囑咐嫩的兒子約書亞：「你要剛強勇敢，因為你要帶領以色列人進入我起誓應許他們的土地，我必與你同在。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","摩西把這律法都寫在書上以後， ");
INSERT INTO cmncbt_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","就吩咐抬耶和華約櫃的利未人： ");
INSERT INTO cmncbt_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","「把這律法書放在你們的上帝耶和華的約櫃旁，作為指控你們的證據。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","因為我知道你們悖逆、頑固不化，我還活在你們中間的時候，你們尚且背叛上帝，何況我死後呢？ ");
INSERT INTO cmncbt_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","把你們各支派的長老和首領招聚來，我要把這些話告訴他們，叫天地作證來指控他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","我知道，我死後你們會徹底墮落，偏離我吩咐你們行的道，做耶和華視為惡的事，惹祂發怒，將來禍患必臨到你們。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","然後，摩西把這首詩歌從頭到尾讀給以色列全體會眾聽。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","「諸天啊，請聽我說； 大地啊，請聽我言。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","願我的教導如雨降下， 願我的話語如露滴落， 像水滴滋潤嫩草， 像甘霖澆灌草木。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","我要宣揚耶和華的名， 你們要頌讚我們上帝的偉大。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","「祂是磐石， 祂的作為完美， 祂按公義行事， 祂信實可靠，公平正直。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","狡詐、墮落的一代啊， 你們卻對祂不忠，行事敗壞， 不配做祂的兒女。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","愚昧無知的人啊， 你們就這樣報答耶和華嗎？ 祂是你們的父，你們的創造主， 祂創造了你們，塑造了你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","「要回顧往昔，追溯歷史； 問你們的父親， 他們必回答你們； 問你們的長者， 他們必告訴你們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","當初，至高者賜萬國產業， 把人類分開， 祂依照天使的數目， 為萬族定疆界。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","但以色列人屬於耶和華， 雅各是祂的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","「在荒涼的曠野， 在野獸吼叫的荒野， 耶和華找到他們， 庇護他們，看顧他們， 保護他們如同保護眼中的瞳人， ");
INSERT INTO cmncbt_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","又如老鷹攪動窩巢， 盤旋在雛鷹之上， 展開雙翼接住牠們， 背著他們飛翔。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","耶和華獨自帶領他們， 沒有外族神明同在。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","耶和華使他們馳騁在大地的高處， 吃田間的五穀， 磐石中的蜂蜜， 石頭地產的油； ");
INSERT INTO cmncbt_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","吃牛酪和羊奶， 肥美的羔羊， 巴珊的綿羊和山羊， 上好的麥子； 喝葡萄汁釀的酒。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","「但耶書崙吃飽喝足， 養肥長壯後，就得意忘形， 背棄造他們的上帝， 藐視救他們的磐石。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","他們拜外族的神明，令祂憤恨； 行可憎之事，惹祂發怒。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","他們祭拜的不是真神， 而是鬼魔， 是他們素不認識的新神明， 是他們祖先所不敬畏的。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","他們輕視生他們的磐石， 忘記養他們的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","「耶和華看見祂兒女的惡行， 就憤然厭棄他們， ");
INSERT INTO cmncbt_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","說，『這墮落的子民， 不忠的兒女！ 我要掩面不理他們， 看他們的結局如何。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","他們拜假神，讓我憤恨； 供虛無之物，惹我發怒。 我要藉無名之民挑起他們的嫉妒， 用愚昧的國民激起他們的怒氣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","我的怒火已經點燃， 要燒到陰間的盡頭， 吞滅大地及其出產， 甚至燒毀山的根基。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","「『我要使災禍連連臨到他們， 我的箭都射向他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","他們必飽受饑荒之苦， 被瘟疫和災禍吞噬， 被猛獸和毒蛇襲擊。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","外有刀劍殺戮， 內有恐懼籠罩， 男女老幼無不喪命。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","我本要消滅他們， 使世人忘記他們； ");
INSERT INTO cmncbt_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","但我怕敵人誇口， 誤以為這是他們的勝利， 而非我的作為。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","「以色列人愚昧無知，毫無見識。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","如果他們有智慧， 就能明白這一切， 知道自己的結局。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","若不是他們的磐石賣掉他們， 若不是耶和華拋棄他們， 一人怎能趕散他們千人？ 二人怎能擊潰他們萬人？ ");
INSERT INTO cmncbt_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","我們的敵人也承認他們的磐石不如我們的磐石。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","他們猶如來自所多瑪、 長在蛾摩拉的葡萄樹， 結的葡萄粒粒有毒，串串苦澀； ");
INSERT INTO cmncbt_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","釀的酒如蛇的毒液， 如眼鏡蛇的毒液。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","「祂說，『我把這一切積存起來， 封在我的倉庫裡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","伸冤在我，我必報應， 到時候他們必站不住腳， 他們遭禍的日子近了， 他們的末日快要來了。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","「耶和華見自己的子民力量衰竭， 奴隸和自由人所剩無幾， 必為他們主持公道， 憐憫祂的僕人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","祂必說，『你們的神明在哪裡？ 庇護你們的磐石在哪裡？ ");
INSERT INTO cmncbt_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","它們吃你們祭牲的脂肪， 喝你們的奠酒。 讓它們起來幫助你們， 庇護你們吧！ ");
INSERT INTO cmncbt_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","「『你們現今要知道， 唯有我是上帝； 除我之外，別無他神。 我掌管生死，我打傷、我醫治； 無人能逃出我的掌心。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","我向天伸手， 憑我的永恆起誓， ");
INSERT INTO cmncbt_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","我要磨快閃亮的劍， 主持公道，報應仇敵， 懲罰恨我的人。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","我要使我的箭飽飲鮮血， 就是被殺被擄之人的血； 我的劍要吞噬人肉， 就是敵人將領的肉。』 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","「列邦啊， 你們當與祂的子民一同歡樂！ 因為祂要為自己的僕人報血仇， 報應祂的仇敵， 潔淨祂的土地和子民。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","摩西和嫩的兒子約書亞把這首詩歌讀給會眾聽。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","讀完後，摩西又對以色列人說： ");
INSERT INTO cmncbt_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","「要謹記我今天警告你們的話，要吩咐你們的子孫謹遵這律法上的一切話。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","這律法不是空話，而是你們的生命。你們若遵守這律法，就必長住在約旦河西岸你們將要佔領的土地上。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","當天，耶和華對摩西說： ");
INSERT INTO cmncbt_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","「你去耶利哥對面的摩押，登上亞巴琳山區的尼波山，觀看我要賜給以色列人作產業的迦南。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","之後，你會死在那山上，歸到你祖先那裡，如你哥哥亞倫在何珥山離世歸祖一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","因為在荀曠野，在加低斯的米利巴泉旁，你和亞倫對我不忠，沒有在以色列人中尊我為聖。 ");
INSERT INTO cmncbt_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","所以，你只能遠遠地觀看我要賜給以色列人的土地，卻不能進去。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","以下是上帝的僕人摩西臨終時給以色列人的祝福： ");
INSERT INTO cmncbt_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","「耶和華從西奈山來， 從西珥山向我們顯現， 祂從巴蘭山發出光輝； 祂帶著千萬聖者來臨， 祂右邊有閃耀的光芒。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","祂深愛自己的子民， 眾聖者都聽命於祂， 伏在祂的腳前， 領受祂的訓誨。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","摩西將律法頒佈給我們， 作為雅各子孫的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","百姓的眾首領齊聚， 以色列各支派集合之時， 耶和華在耶書崙做王。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","摩西祝福呂便支派說： 「儘管呂便人數稀少， 願他存活，不致滅沒。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","摩西祝福猶大支派說： 「耶和華啊， 求你聽猶大人的呼求， 帶他們回歸本族， 出手為他們爭戰， 幫他們對抗仇敵。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","摩西祝福利未支派說： 「耶和華啊， 求你把土明和烏陵賜給虔誠的利未人， 你曾經在瑪撒試驗他們， 在米利巴泉邊與他們爭論。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","為了聽從你的話，遵守你的約， 他們不顧父母， 捨棄弟兄，拋下兒女。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","他們把你的典章傳授給雅各， 把你的律法傳授給以色列； 他們要把香獻在你面前， 把全牲燔祭獻在你的壇上。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","耶和華啊， 求你賜他們力量， 悅納他們的工作， 擊碎仇敵的腰桿， 使敵人一蹶不振。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","摩西祝福便雅憫支派說： 「耶和華所愛的人， 安居在祂身邊， 安居在祂懷中， 終日蒙祂庇護。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","摩西祝福約瑟家族說： 「願他們的土地蒙耶和華賜福， 得天上的甘霖， 及地下的泉源； ");
INSERT INTO cmncbt_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","得日月之輝，物產豐美； ");
INSERT INTO cmncbt_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","得古老群山之精華， 永存丘陵之富饒； ");
INSERT INTO cmncbt_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","得大地的豐肥， 蒙荊棘火中之上帝的恩寵。 願這些福氣落在約瑟頭上， 臨到弟兄中的王者身上。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","約瑟威武如頭生的公牛， 有野牛的角， 他用角牴萬邦， 直到地極。 他的兩角是數以萬計的以法蓮人和數以千計的瑪拿西人。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","摩西祝福西布倫和以薩迦支派說： 「願西布倫人欣然外出， 願以薩迦人在帳篷中歡喜。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","他們要招聚眾人上山， 一同獻上公義的祭； 他們汲取海裡的財富和沙中的寶藏。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","摩西祝福迦得支派說： 「擴張迦得疆界的那位當受稱頌！ 迦得蹲伏如母獅， 撕碎頭顱和臂膀。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","他為自己選了最好的土地， 是留給首領的那份。 他與眾首領同行， 施行耶和華的公義和祂給以色列的典章。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","摩西祝福但支派說： 「但像一隻從巴珊躍出的幼獅。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","摩西祝福拿弗他利支派說： 「拿弗他利人啊， 你們飽嘗耶和華的恩寵， 滿得祂的賜福， 擁有西方和南方的土地。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","摩西祝福亞設支派說： 「願亞設在眾子中最蒙福， 受眾弟兄的恩待， 雙腳沐浴橄欖油， ");
INSERT INTO cmncbt_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","城門有銅鎖鐵閂， 一生都充滿力量。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","「耶書崙啊， 上帝獨一無二， 祂馳騁諸天，前來助你， 穿越長空，充滿威嚴。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","亙古的上帝是你的庇護， 祂永恆的臂膀是你的依託。 祂趕走你面前的仇敵， 下令毀滅他們。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","以色列安然居住， 雅各獨居一處， 那裡盛產五穀新酒， 有天上的雨露滋潤。 ");
INSERT INTO cmncbt_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","以色列啊，你多麼有福！ 蒙耶和華拯救之人啊，誰能像你？ 祂是你的盾牌，你得勝的寶劍。 敵人要向你屈服，被你踐踏。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","摩西從摩押平原登上尼波山，上到耶利哥對面的毗斯迦山頂。耶和華把整片土地指給他看，從基列一直到但， ");
INSERT INTO cmncbt_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","拿弗他利全境，以法蓮和瑪拿西地區，遠至地中海的猶大全境， ");
INSERT INTO cmncbt_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","南地和棕櫚城耶利哥的谷地，遠至瑣珥。 ");
INSERT INTO cmncbt_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","耶和華對摩西說：「這便是我向亞伯拉罕、以撒和雅各起誓要賜給他們子孫的土地。現在我讓你親眼看到了，但你不能進入。」 ");
INSERT INTO cmncbt_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","於是，耶和華的僕人摩西死在摩押，正如耶和華所言。 ");
INSERT INTO cmncbt_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","耶和華把他安葬在摩押境內伯·毗珥對面的山谷，至今無人知道摩西的墳墓在哪裡。 ");
INSERT INTO cmncbt_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","摩西去世時一百二十歲，眼睛沒有昏花，精力沒有衰敗。 ");
INSERT INTO cmncbt_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","以色列人在摩押平原為摩西致哀三十天，服喪的日子才結束。 ");
INSERT INTO cmncbt_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","嫩的兒子約書亞充滿了智慧之靈，因為摩西曾把手按在他身上。以色列人都聽從他，遵守耶和華對摩西的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","此後，以色列再也沒有出現像摩西那樣的先知，他曾面見耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","奉耶和華的命令在埃及行神蹟奇事，懲罰法老及其臣僕和國民， ");
INSERT INTO cmncbt_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","在以色列人面前行偉大而可畏的事。");
INSERT INTO cmncbt_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","耶和華的僕人摩西死了以後，耶和華對摩西的助手——嫩的兒子約書亞說： ");
INSERT INTO cmncbt_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","「我的僕人摩西已經死了，你和全體以色列人現在要準備渡過約旦河，到我要賜給你們的地方去。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","我已把你們腳掌將踏之地都賜給了你們，正如我對摩西的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","從南部的曠野直到北部的黎巴嫩，從東部的幼發拉底大河直到西部的地中海，包括赫人居住的全境，都將是你們的領土。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","在你有生之年，沒有人能夠抵擋你。過去我怎樣與摩西同在，也必照樣與你同在，我必不離開你，也不丟棄你。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","你要剛強勇敢，因為你要帶領這些人佔領我起誓要賜給他們祖先的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","你只要剛強勇敢，謹遵我僕人摩西所吩咐你的一切律法，毫不偏離，就可以無往不利。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","你要常常誦讀這律法書，晝夜不斷地思想，以便謹遵律法書上的一切指示。這樣，你必亨通、順利。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","我再次吩咐你，要剛強勇敢！不要驚慌害怕，因為你無論走到哪裡，你的上帝耶和華必與你同在。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","於是，約書亞吩咐民眾的首領說： ");
INSERT INTO cmncbt_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","「你們要走遍全營，吩咐民眾預備好食物。因為三天之內，你們就要過約旦河，去佔領你們的上帝耶和華賜給你們的土地。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","約書亞又對呂便支派、迦得支派和瑪拿西半個支派的人說： ");
INSERT INTO cmncbt_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","「你們要牢記耶和華的僕人摩西吩咐你們的話，他說你們的上帝耶和華要把這片土地賜給你們，讓你們安居。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","你們的妻子兒女和牲畜可以留在約旦河東岸、摩西分給你們的土地上，但你們當中所有的勇士要帶著兵器先過約旦河，幫助你們的弟兄。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","要等到你們的上帝耶和華使你們的弟兄像你們一樣得到祂所賜的土地，安居以後，你們才可以回到約旦河東日出之地，在耶和華的僕人摩西分給你們的土地上定居。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","他們回答約書亞說：「凡你命令我們的，我們一定遵行。無論你派我們去哪裡，我們一定去。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","我們在一切事上怎樣服從摩西，也必照樣服從你，唯願你的上帝耶和華與你同在，像與摩西同在一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","任何人違抗你的命令，不悉數遵行你的吩咐，都要被處死。你要剛強勇敢！」 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","嫩的兒子約書亞暗中從什亭派出兩個探子，去偵察那片土地，特別是耶利哥的情況。他們進到一個名叫喇合的妓女家中，就住在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","有人告訴耶利哥王說：「今晚有以色列人來這裡刺探。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","耶利哥王便派人到喇合那裡，對她說：「把來到你家裡的人交出來，因為他們是來刺探這地方的。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","但喇合已經把二人藏起來了，她答道：「不錯，他們來過，可是我不知他們是從哪裡來的。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","天黑要關城門的時候，他們就離開了，我不知道他們去哪裡了。你們快去追吧，還可以追上。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","其實喇合已經把二人帶到屋頂上，藏在那裡的麻稈堆裡了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","追捕的人便沿著通往約旦河渡口的路追去，他們一出城，城門便關閉了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","在兩個探子睡覺前，喇合上到屋頂對他們說： ");
INSERT INTO cmncbt_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","「我知道耶和華已經把這地方賜給你們，我們對你們充滿恐懼。這裡所有的居民都嚇得膽戰心驚。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","因為你們離開埃及過紅海的時候，耶和華怎樣使紅海在你們面前成為乾地，你們怎樣對付約旦河東的兩個亞摩利王西宏和噩，把他們徹底消滅，我們都聽說了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","我們聽了這些事，感到心驚膽戰、勇氣盡失。你們的上帝耶和華是天地萬物的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","我既然恩待了你們，現在請你們憑耶和華向我起誓，你們同樣會恩待我家，並且給我一個可靠的憑據， ");
INSERT INTO cmncbt_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","保證放過我的父母、兄弟、姊妹和他們所有的親人，救我們脫離死亡。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","二人便對她說：「只要你不洩露我們的事，我們願意用性命擔保，當耶和華把這地方賜給我們的時候，我們一定守信善待你。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","喇合的房子就在城牆邊，她就住在城牆上，於是她用繩子把二人從窗口縋下去， ");
INSERT INTO cmncbt_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","並對他們說：「你們往山上去，免得被追捕的人發現。你們要在那裡躲三天，等追捕的人回城後再走。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","二人對她說：「要讓我們信守誓言，你必須這樣做： ");
INSERT INTO cmncbt_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","我們來攻佔這座城的時候，你要把這條朱紅色繩子繫在縋我們下去的窗戶上，並且把你的父母、兄弟、姊妹和他們的親人都召集到你家裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","倘若有人離開這房子跑到街上遭遇不測，我們不負任何責任。我們一定保證屋內所有人的性命安全。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","如果你洩露我們的事，你要我們起的誓也就作廢了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","喇合說：「一言為定！」於是她送走他們，把朱紅色的繩子繫在窗戶上。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","二人到山上躲藏了三天，等追捕的人回去。追捕的人沿途搜索，毫無所獲，便回去了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","二人便下山，過河回到嫩的兒子約書亞那裡，向他稟告整個經過， ");
INSERT INTO cmncbt_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","又說：「耶和華確實將那整片土地交給我們了，那裡的居民聽到我們的消息，都嚇得膽戰心驚。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","約書亞清早起來，率領全體以色列人離開什亭，來到約旦河邊安營，等候過河。 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","過了三天，官長走遍各營，吩咐民眾說： ");
INSERT INTO cmncbt_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","「你們看見做祭司的利未人抬著你們上帝耶和華的約櫃出發時，就要起身跟在後面。 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","這樣，你們就會知道路，因為你們從來沒有走過這條路。但你們要跟約櫃保持九百米的距離，不要走近約櫃。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","約書亞又對民眾說：「你們要潔淨自己，因為明天耶和華要在你們當中行奇事。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","約書亞又對祭司說：「抬起約櫃，率領民眾過河吧！」他們就抬起約櫃，走在民眾前面。 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","耶和華對約書亞說：「從今天開始，我要使你在以色列人面前得到尊榮，讓他們知道我與你同在，正如從前我跟摩西同在一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","你要吩咐抬約櫃的祭司走到約旦河邊，站在水中。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","約書亞對以色列人說：「你們要來聽你們的上帝耶和華的話。 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","今天你們會明白永活的上帝就在你們當中，祂必在你們面前趕走迦南人、赫人、希未人、比利洗人、革迦撒人、亞摩利人和耶布斯人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","看啊，天下之主的約櫃要在你們前面過約旦河。 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","現在，你們要從以色列的十二支派中選出十二個人來，每支派選一人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","當祭司抬著天下之主耶和華的約櫃一踏進約旦河，往下流的河水必止住，形成一道水堤。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","那時是收割的季節，河水高漲，淹沒兩岸。民眾拔營準備過河，抬約櫃的祭司走在前頭。祭司的腳剛一踏進河水， ");
INSERT INTO cmncbt_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","往下流的水立刻止住了，在很遠的撒拉但附近的亞當城那裡漲成一道水牆。流入亞拉巴海，即鹽海的水完全被截斷了，民眾便走到對面的耶利哥。 ");
INSERT INTO cmncbt_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","以色列人過河的時候，抬耶和華約櫃的祭司站在河中間的乾地上，直到所有人都從乾地上過了約旦河。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","民眾都過河之後，耶和華對約書亞說： ");
INSERT INTO cmncbt_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","「你去從民眾中選出十二個人，每支派選一人， ");
INSERT INTO cmncbt_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","吩咐他們從約旦河床祭司站立的地方取十二塊石頭，放在你們今晚住宿的地方。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","約書亞便召來他從以色列人中選的十二個人，每支派一人，對他們說： ");
INSERT INTO cmncbt_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","「從你們上帝耶和華的約櫃前過去，到約旦河中間，以色列每個支派中有一人扛一塊石頭回來，一共十二塊， ");
INSERT INTO cmncbt_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","留在你們中間作記號。以後，倘若你們的子孫問你們，『這些石頭是什麼意思？』 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","你們就告訴他們，『約旦河水在耶和華的約櫃前曾經被截斷，當約櫃過河的時候，河水被截斷了。這些石頭要在以色列人當中作為永久的紀念。』」 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","以色列人遵行了約書亞的吩咐。他們按以色列人支派的數目，從約旦河中取了十二塊石頭，搬來放在住宿的地方，正如耶和華對約書亞的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","約書亞又在約旦河床抬約櫃的祭司站立的地方立了十二塊石頭。石頭至今還在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","抬約櫃的祭司站在約旦河中間，一直站到耶和華吩咐約書亞交待民眾做的每一件事都完成了，正如摩西對約書亞的吩咐。民眾迅速過了河。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","所有人都過河以後，祭司才抬著耶和華的約櫃在民眾注視下過了河。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","呂便支派、迦得支派和瑪拿西半個支派的人照摩西從前的囑咐，帶著兵器走在以色列人前面。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","大約有四萬武裝好的以色列人在耶和華面前過了河，前往耶利哥平原，準備作戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","那一天，耶和華在以色列眾人面前提升約書亞，在他有生之年，他們像敬畏摩西一樣敬畏他。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","耶和華對約書亞說： ");
INSERT INTO cmncbt_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","「你去吩咐抬約櫃的祭司從約旦河裡上來。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","約書亞便吩咐他們從約旦河裡上來。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","抬耶和華約櫃的祭司從河床上來，腳剛一踏上岸，約旦河的水立刻恢復原狀，像以往一樣漲過兩岸。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","那天是一月十日。以色列人從約旦河上來後，就在耶利哥東邊的吉甲紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","約書亞把從約旦河取來的十二塊石頭立在吉甲， ");
INSERT INTO cmncbt_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","並對以色列人說：「以後，你們的子孫問你們這堆石頭是什麼意思， ");
INSERT INTO cmncbt_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","你們就告訴他們，『這是代表以色列人曾走乾地穿過約旦河。』 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","因為你們的上帝耶和華使約旦河成為乾地、讓你們穿過，就像祂從前使紅海成為乾地、讓我們穿過一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","這是要讓天下萬民都知道耶和華的手大有能力，要讓你們永遠敬畏你們的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","在約旦河西岸一帶的亞摩利眾王和沿海一帶的迦南眾王，聽說耶和華使約旦河成為乾地、讓以色列人穿過，都嚇得膽戰心驚，勇氣盡失。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","那時，耶和華對約書亞說：「你要製作火石刀，再次給以色列人行割禮。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","約書亞便製作火石刀，在割禮山給以色列人行了割禮。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","約書亞給他們舉行割禮，是因為所有從埃及出來、能夠作戰的男子之後都死在曠野的路上。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","從埃及出來的男子都受過割禮，而後來在曠野的路上出生的以色列人都沒有受過割禮。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","以色列人在曠野飄泊了四十年，直到從埃及出來可以作戰的男子都死了為止，因為他們不聽從耶和華的話。耶和華曾向他們祖先起誓，要把奶蜜之鄉賜給他們，但後來祂向他們起誓，不讓他們看見那片土地。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","耶和華立他們的子孫代替他們。這些人沒有受過割禮，因為在路上沒有為他們行過割禮，約書亞就為他們行了割禮。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","全體民眾受了割禮後，都留在自己的營內，直到康復為止。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","耶和華對約書亞說：「今天我除去了你們在埃及受的羞辱。」因此，那地方叫吉甲，沿用至今。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","以色列人都在耶利哥平原上的吉甲紮營，並於一月十四日傍晚在那裡守逾越節。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","逾越節次日他們就吃當地的出產，包括無酵餅和烤麥穗。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","他們吃了當地出產後的第二天，嗎哪便不再降下，以色列人再沒有嗎哪吃了。那一年他們開始吃迦南的出產。 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","約書亞走近耶利哥，舉目看見一個人站在他面前，手裡拿著拔出來的劍。約書亞上前去問道：「你是來幫助我們的，還是來幫助我們敵人的？」 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","那人答道：「都不是，我來是做耶和華軍隊的統帥。」約書亞就俯伏下拜說：「我主，有什麼話要吩咐僕人？」 ");
INSERT INTO cmncbt_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","耶和華軍隊的統帥對約書亞說：「把你腳上的鞋脫下！因為你站的地方是聖潔的。」約書亞便把鞋脫下來。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","因為害怕以色列人，耶利哥城門緊閉，無人出入。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","耶和華對約書亞說：「看啊，我已經把耶利哥及其王和英勇的戰士都交在你手中了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","所有軍隊要每天繞城一圈，連續六天， ");
INSERT INTO cmncbt_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","讓七個祭司拿著七個羊角號走在約櫃前面。到了第七天，你們要繞城七圈，祭司要吹響號角。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","當你們聽到號角長鳴時，所有人都要高聲吶喊，城牆就會坍塌，眾人便可以直衝上去。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","嫩的兒子約書亞便召來祭司，對他們說：「你們抬起約櫃，派七位祭司拿著七個羊角號走在耶和華的約櫃前面。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","他又對民眾說：「你們要前去繞著城牆走，軍隊要走在耶和華的約櫃前面。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","約書亞吩咐完畢，七個祭司便在耶和華面前拿著羊角號邊走邊吹，耶和華的約櫃就跟在他們後面， ");
INSERT INTO cmncbt_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","軍隊走在吹號的祭司前面，殿後軍隊跟在約櫃後面。祭司一路上吹著號角。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","約書亞吩咐民眾：「我哪天叫你們吶喊，你們再吶喊。在此之前，不許作聲，一句話也不許說。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","這樣，約書亞讓人抬著耶和華的約櫃繞城一圈，然後眾人各自回營過夜。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","第二天，約書亞一早起來，祭司又抬起耶和華的約櫃。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","七個祭司拿著七個羊角號走在耶和華的約櫃前面，一邊走一邊吹號。軍隊走在祭司前面，殿後軍隊跟在耶和華的約櫃後面，伴隨著持續不斷的號角聲。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","這一天他們又繞城一圈，然後各自回營。六天都是這樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","第七天黎明時分，他們起來照樣繞城，只是這一天他們繞城七次。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","繞到第七次，祭司吹響了號角，約書亞吩咐民眾說：「吶喊吧！因為耶和華已經將這城交給你們了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","要把這座城和城裡所有的東西毀滅，作為獻給耶和華之物。只有妓女喇合和她家中所有的人可以活命，因為她曾把我們派去的探子隱藏起來。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","你們要小心，不可私拿任何應當毀滅的東西，免得你們自取滅亡，並使以色列全營遭受滅頂之災。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","所有金銀和銅鐵器皿都是耶和華的聖物，要放進耶和華的庫房。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","於是，民眾吶喊，號角響起，當民眾伴隨著號角聲高聲吶喊時，城牆坍塌了。民眾便一擁而上，佔領了耶利哥城， ");
INSERT INTO cmncbt_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","用刀殺了城裡所有的男女老少、牛羊和驢。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","約書亞對那兩個探子說：「你們到那個妓女家裡，照著你們向她起過的誓，把她和她的家人都帶出來。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","於是，那兩個年輕探子便進去，把喇合和她的父母、兄弟及所有的親人都帶出來，安置在以色列人的營外。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","以色列人燒毀全城和城內的一切，只把金銀和銅鐵器皿放在耶和華的庫房裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","約書亞因為妓女喇合把兩個派到耶利哥的探子隱藏起來，就饒了她和她一家人的性命。他們至今仍住在以色列人當中。 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","之後，約書亞起誓說： 「重建耶利哥城的人必定在耶和華面前受咒詛， 他立地基的時候必死長子， 建城門的時候必喪幼子。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","耶和華與約書亞同在，他的聲名傳遍整個地方。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","以色列人在當毀滅之物的事上犯了罪。因為猶大支派中謝拉的曾孫、撒底的孫子、迦米的兒子亞干拿了一些本該毀滅之物，耶和華便向以色列人發怒。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","當時，約書亞從耶利哥派人去伯特利東邊靠近伯·亞文的艾城，並吩咐道：「你們去偵察那地方。」那些人便上去偵察艾城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","他們偵察回來後對約書亞說：「那裡的居民很少，我們不必全軍出動，只要派兩三千人上去便可以攻取艾城，不必勞師動眾。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","於是，大約有三千以色列人去攻打艾城，不料卻被艾城人擊潰。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","艾城的人殺了他們三十六人，從城門前追殺他們，一直到示巴琳，在下坡處殺敗他們。以色列人嚇得心驚膽戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","約書亞和以色列的長老便撕裂衣服，把灰撒在頭上，俯伏在耶和華的約櫃面前，直到晚上。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","約書亞說：「唉！主耶和華啊，你為什麼把我們帶過約旦河，交給亞摩利人毀滅呢？倒不如讓我們住在約旦河東岸！ ");
INSERT INTO cmncbt_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","主啊，現在以色列人被仇敵打敗，我還有什麼話可說呢？ ");
INSERT INTO cmncbt_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","迦南人和這一帶的人聽到這消息以後，必從四面八方來圍攻我們，將我們從地上斬盡殺絕。那時候，你的大名怎麼辦呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","耶和華對約書亞說：「起來吧！你為何俯伏在地？ ");
INSERT INTO cmncbt_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","以色列人犯了罪，違背了我吩咐他們應守的約，拿了本該毀滅之物放在自己的行囊裡，又偷竊又撒謊。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","所以，以色列人無法抵擋敵人，掉頭敗逃，因為他們已成當毀之物。你必須將那些本該毀滅之物從你們中間除掉，不然我就不再與你們同在。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","起來吧！去吩咐民眾潔淨自己，讓他們為明天潔淨自己，因為以色列的上帝耶和華這樣說，『以色列啊！你們中間有當毀之物，你們不除掉它們就無法抵擋敵人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","明天早上，你們要按支派一個一個前來，耶和華指出哪個支派，哪支派的各宗族便要前來。耶和華指出哪個宗族，哪宗族的各家族便要前來。耶和華指出哪個家族，哪家族的各成員便要前來。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","哪個人被指出拿了本該毀滅之物，哪個人及其所有的東西就要被火焚燒。因為他違背了耶和華的約，在以色列人中做了可恥的事。』」 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","第二天清早，約書亞按照支派召來以色列人，結果抽中猶大支派； ");
INSERT INTO cmncbt_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","他讓猶大支派各宗族前來，結果抽中謝拉宗族；他讓謝拉宗族前來，結果抽中撒底家族； ");
INSERT INTO cmncbt_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","他讓撒底家族的人一個一個前來，結果抽中猶大支派中謝拉的曾孫、撒底的孫子、迦米的兒子亞干。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","約書亞對亞干說：「孩子啊，我勸你把榮耀歸給以色列的上帝耶和華，向祂認罪，把你所做的事告訴我，不要隱瞞。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","亞干答道：「我的確得罪了以色列的上帝耶和華。事情是這樣的， ");
INSERT INTO cmncbt_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","在奪得的財物中，我看上了一件漂亮的示拿外衣、四十五兩銀子和十兩金子，我一時貪心便拿去了，藏在我帳篷的地底下，銀子就放在衣服下面。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","約書亞派人跑到他帳篷裡，果然那件外衣藏在他帳篷裡，銀子在衣服下面。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","他們從帳篷裡取出這些東西，將它們帶到約書亞和全體民眾那裡，擺在耶和華面前。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","約書亞和全體以色列人把謝拉家族的亞干、那些銀子、衣服和金子及其兒女、牛、驢、羊、帳篷和一切所有都帶到亞割谷。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","約書亞對亞干說：「你為什麼給我們惹禍呢？耶和華今天要降禍給你。」於是，以色列人便拿石頭打死了他及其一切，將他們燒毀。 ");
INSERT INTO cmncbt_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","他們在亞干身上堆起一大堆石頭，那些石頭今天還在。耶和華這才息怒，因此那地方至今還叫亞割谷。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","耶和華對約書亞說：「不要驚慌害怕。只管率領全軍去攻打艾城，我已經將艾城的王、他的人民、城池和土地都交在你手裡了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","你怎樣對待耶利哥和耶利哥王，也要照樣對待艾城和艾城的王。不過你們可以拿城中的財物和牲畜。你要在城後設下伏兵。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","於是，約書亞率領全軍前往艾城。他挑選了三萬精兵，派他們在黑夜出發， ");
INSERT INTO cmncbt_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","並吩咐他們說：「你們要在城後埋伏，不可離城太遠，全體保持戒備。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","我會率領軍隊正面攻城，當敵人像上次那樣出城應戰時，我們便逃跑。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","他們必定乘勝追擊，我們便引他們離城，因為敵人一定會以為我們又像上次一樣臨陣逃跑。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","那時，你們便從埋伏的地方衝出來攻佔艾城，你們的上帝耶和華一定會把艾城交在你們手裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","你們攻陷艾城後，要照耶和華的話放火焚城。這是我的命令。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","於是，約書亞派遣他們出去。他們去埋伏在伯特利和艾城之間，就是艾城的西面。那一夜，約書亞住在民眾當中。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","清早，約書亞召集民眾，與以色列的眾首領率全軍前往艾城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","隨他同去的軍隊都向前推進，來到城外，在城的北面紮營，與艾城相隔一個山谷。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","約書亞選了五千人，讓他們埋伏在艾城和伯特利之間，就是艾城的西面。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","於是，城北的主力軍隊和城西的伏兵都部署好了。當晚，約書亞在山谷裡過夜。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","艾城的王見以色列人兵臨城下，清早便急忙和全城的人起來出城迎戰，在亞拉巴谷附近跟以色列軍交鋒，他不知道城後有伏兵。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","約書亞帶領以色列軍詐敗，沿著通往曠野的路逃跑。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","艾城的人都被召去追趕以色列人，他們追擊約書亞，被誘出城來。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","這樣，伯特利和艾城的人傾巢而出，追殺以色列人，他們的城門大開。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","耶和華對約書亞說：「把你手中的矛指向艾城，因為我要將這城交在你手裡。」約書亞就把手中的矛指向艾城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","他一伸手，城後的伏兵立即行動，迅速衝進城去，一舉佔領艾城，隨即放火燒城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","艾城的人回頭發現城內煙氣沖天，卻無路可逃，因為那些逃往曠野的以色列人已掉頭攻擊他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","約書亞和以色列全軍見伏兵已經佔領艾城，城中濃煙滾滾，便掉頭攻擊艾城的人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","伏兵也出城追擊艾城的人。以色列軍前後夾攻，把敵人圍困在中間全部殲滅，無一漏網。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","他們生擒了艾城的王，將他押到約書亞那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","以色列軍在田間和曠野用刀殺盡了追趕他們的艾城人後，又進城殺了留在城裡的人， ");
INSERT INTO cmncbt_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","當天被殺的艾城人男男女女共有一萬二千人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","一直到艾城所有的人都被殺光了，約書亞才收回手中的矛。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","以色列人照耶和華對約書亞的吩咐，只帶走了城中的牲畜和財物。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","約書亞燒毀全城，使城永遠成為一堆廢墟，至今仍一片荒涼。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","約書亞又將艾城王的屍體掛在樹上示眾。黃昏時，他才吩咐人把屍體取下來扔在城門口，又在屍體上堆了一大堆石頭。石堆至今還在。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","31","約書亞照耶和華的僕人摩西對以色列人的吩咐，在以巴路山上為以色列的上帝耶和華築了一座祭壇。這壇是按照摩西律法書的記載，用未經鐵器鑿過的原石築的。以色列人就在這壇上把燔祭和平安祭獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","約書亞又在眾人面前，將摩西所寫的律法刻在石頭上。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","所有以色列人與他們的長老、官員和審判官都站在耶和華的約櫃兩旁，面對著抬約櫃的利未祭司，寄居的外族人和本族人都在場。他們一半人站在基利心山前，一半人站在以巴路山前，正如耶和華的僕人摩西從前祝福他們時所吩咐的。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","隨後，約書亞按照摩西律法書的記載，向民眾宣讀一切祝福和咒詛的話。 ");
INSERT INTO cmncbt_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","他在全體會眾，包括婦女、小孩以及住在他們中間的外族人面前，一字不漏地宣讀摩西的一切吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","住在約旦河西的山區、丘陵以及地中海沿岸、遠至黎巴嫩的諸王，就是那些赫人、亞摩利人、迦南人、比利洗人、希未人和耶布斯人的王聽說這件事， ");
INSERT INTO cmncbt_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","就聯合起來對抗約書亞和以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","基遍的居民聽說約書亞在耶利哥和艾城所做的事， ");
INSERT INTO cmncbt_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","便想出一個詭計來。他們裝作特使，把舊皮袋和縫補過的酒囊馱在驢背上， ");
INSERT INTO cmncbt_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","穿著縫補過的舊鞋和破爛衣服，帶著又乾又發黴的餅， ");
INSERT INTO cmncbt_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","到吉甲營去見約書亞。他們對約書亞和以色列人說：「我們從很遠的地方來，求你們跟我們締結盟約。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","以色列人對這些希未人說：「你們也許就住在附近。我們怎麼能跟你們締結盟約呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","他們對約書亞說：「我們是你的奴僕。」約書亞說：「你們是什麼人？從哪裡來？」 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","他們答道：「僕人們因為你的上帝耶和華的大名，才從很遠的地方來。我們聽說了祂在埃及的一切作為， ");
INSERT INTO cmncbt_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","以及祂怎樣對付約旦河東的兩個亞摩利王——希實本王西宏和亞斯她錄的巴珊王噩。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","我們的長老和民眾就派我們帶著乾糧來迎接你們，甘做你們的僕人，希望跟你們締結盟約。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","我們出來的時候帶的餅是熱的，看啊，現在又乾又發黴了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","這些皮酒囊原來也是新的，但現在已經破了。因為長途跋涉，我們的衣服和鞋也都破舊不堪了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","以色列人接受了他們的食物，卻沒有求問耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","約書亞與他們立了和平盟約，容他們存活，會眾的首領也向他們起誓守約。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","立約三天後，以色列人才得知他們原來是鄰居，就住在附近。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","以色列人啟程，走了三天來到他們居住的基遍、基非拉、比錄和基列·耶琳各城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","會眾的首領曾憑以色列的上帝耶和華向他們起過誓，所以不能殺他們。全體會眾因此向首領大發怨言。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","首領便對全體會眾說：「我們曾憑以色列的上帝耶和華向他們起誓，我們現在不能動他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","我們要容他們存活，免得我們因違背誓言而惹耶和華發怒。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","首領又說：「就容他們存活吧。」首領就叫他們為全體會眾劈柴挑水。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","於是，約書亞召來他們，對他們說：「你們為什麼要欺騙我們，說你們住得很遠？其實你們就住在附近。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","因此，你們是受咒詛的。你們要永遠做奴僕，為我上帝的殿劈柴挑水。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","他們答道：「僕人們這樣做是因為害怕喪命。我們確實聽說你的上帝耶和華曾經應許祂僕人摩西，要把這整片土地都賜給你們，並從你們面前將這裡的居民殺盡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","現在我們既然落在你的手中，你們想怎樣對待我們就怎樣對待吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","約書亞不讓以色列人加害他們，因此他們沒有被殺死。 ");
INSERT INTO cmncbt_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","那天，約書亞讓他們在耶和華指定的地方，為會眾和耶和華的祭壇劈柴挑水。他們至今仍做這樣的工作。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","耶路撒冷王亞多尼·洗德聽說約書亞奪取並毀滅了艾城，像對付耶利哥和耶利哥王一樣對付艾城和艾城的王，又聽說基遍人已經跟以色列人締結盟約，住在他們中間， ");
INSERT INTO cmncbt_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","便大為驚恐。因為基遍是一座大城，宏偉得像座都城，比艾城更大，城中的人都驍勇善戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","耶路撒冷王亞多尼·洗德便派遣使者去見希伯崙王何咸、耶末王毗蘭、拉吉王雅非亞和伊磯倫王底璧，說： ");
INSERT INTO cmncbt_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","「求你們上來幫助我攻打基遍，因為這城已經與約書亞和以色列人締結盟約。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","於是，五位亞摩利王，就是耶路撒冷王、希伯崙王、耶末王、拉吉王和伊磯倫王，便聯合起來，率領他們所有的軍隊在基遍附近紮營，攻打基遍。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","基遍人派人去吉甲告訴約書亞說：「住在山區的亞摩利眾王正聯合起來攻打我們，求你趕快來救我們！不要不顧你的僕人。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","於是，約書亞便率領全軍，包括所有精兵，從吉甲上去。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","耶和華對約書亞說：「不要害怕，我已經把他們交在你手中，他們沒有一人能抵擋你。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","約書亞從吉甲出發，連夜趕路，突襲敵人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","耶和華使亞摩利聯軍陣腳大亂，以色列人就在基遍大敗敵軍，在去伯·和崙的上坡路上追殺他們，一直追到亞西加和瑪基大。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","敵人在從伯·和崙到亞西加的下坡路上逃竄的時候，耶和華降下大冰雹，被冰雹砸死的人比以色列人用刀殺死的還要多。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","耶和華將亞摩利人交在以色列人手中，那天約書亞當眾向耶和華禱告： 「太陽啊，停在基遍！ 月亮啊，停在亞雅崙谷！」 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","果然太陽停住了， 月亮也不動了， 直到以色列人殺敗敵人。 《雅煞珥書》記載了這事。約有一天的時間，太陽停留在天空，沒有西沉。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","耶和華這樣垂聽一個人的祈求是空前絕後的，這是因為耶和華要為以色列爭戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","後來，約書亞率領以色列軍返回了吉甲的營地。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","那五王逃進瑪基大的山洞裡，躲藏起來。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","有人告訴約書亞那五個王藏在瑪基大的山洞裡， ");
INSERT INTO cmncbt_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","約書亞便下令說：「滾幾塊大石頭堵住洞口，派人看守。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","你們不可停下來，要繼續追殺敵人，不要讓他們逃回城，你們的上帝耶和華已經把他們交在你們手中了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","約書亞和以色列人把敵人殺得大敗，幾乎全軍覆沒，一些殘餘都逃進了堅固的城壘。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","以色列人都安然無恙地回到約書亞駐紮的瑪基大營。再也沒有人敢威脅以色列人了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","約書亞說：「打開洞口，把裡面的五個王押出來見我。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","眾人便把耶路撒冷王、希伯崙王、耶末王、拉吉王、伊磯倫王從洞裡押出來，帶到約書亞面前。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","約書亞召來全體以色列人，然後對那些跟他一起出征的將領說：「你們上前來，用腳踏在這些王的脖子上。」各將領便照著約書亞的吩咐做了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","約書亞對他們說：「你們不要驚慌害怕，要剛強勇敢，因為耶和華要使你們攻打的所有仇敵都落此下場。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","隨後約書亞將這五個王殺死，把屍體分別掛在五棵樹上，直到傍晚。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","日落時，約書亞才下令把屍體放下，扔在他們先前躲藏的山洞裡，用大石頭堵住洞口，石頭至今還在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","約書亞在當天佔領了瑪基大，把瑪基大王和所有的居民都用刀殺了，一個沒留。他對待瑪基大王跟以前對待耶利哥王一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","約書亞和以色列軍又從瑪基大出發，去攻打立拿。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","耶和華將立拿城和立拿王交在以色列人手中，他們用刀殺了全城的人，一個沒留。他們對待立拿王跟以前對待耶利哥王一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","約書亞和以色列軍從立拿前往拉吉，他們在城外紮營，攻打拉吉。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","耶和華將拉吉交在以色列人手中，第二天約書亞便攻佔了拉吉，用刀殺了全城的人，就像在立拿所行的一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","基色王何蘭前來支持拉吉，結果也被約書亞殺得一個不剩。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","約書亞又率領以色列全軍從拉吉前往伊磯倫，在城外紮營，攻打伊磯倫。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","他們當天就攻陷該城，用刀殺了城內所有的人，就像在拉吉所行的一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","約書亞和全體以色列人又從伊磯倫去攻打希伯崙。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","他們攻陷該城及其附屬城邑，用刀殺了希伯崙王和城邑中的居民，一個沒留，就像在伊磯倫所行的一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","然後，約書亞和全體以色列人再回兵攻打底璧， ");
INSERT INTO cmncbt_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","攻取了該城及其附屬城邑，擒獲底璧王，用刀殺了城中所有的人，一個沒留，就像對待希伯崙、立拿和立拿王一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","這樣，約書亞征服了整個地區，包括山區、南地、丘陵和山坡及那裡的眾王。他按照以色列的上帝耶和華的吩咐，消滅了一切有生命氣息的，一個沒留。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","約書亞征服了各地，從加低斯·巴尼亞到迦薩，歌珊全境，直到基遍。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","約書亞能一鼓作氣殺敗諸王，征服他們的土地，都是因為有以色列的上帝耶和華為以色列人爭戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","之後，約書亞率領以色列人回到吉甲的營地。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","夏瑣王耶賓聽見這些消息，就派人去見瑪頓王約巴、伸崙王、押煞王， ");
INSERT INTO cmncbt_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","還有北方山區、基尼烈南面的亞拉巴、西部丘陵和多珥高原的各王， ");
INSERT INTO cmncbt_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","以及東西兩面的迦南人、山區的亞摩利人、赫人、比利洗人、耶布斯人和黑門山麓米斯巴地區的希未人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","這些王便率領自己的軍隊，帶著許多馬匹和戰車傾巢出動，人數多如海邊的沙。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","他們在米倫河會師，一同紮營，要跟以色列人交戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","耶和華對約書亞說：「你不要怕他們。明天這個時候，我必把他們全部交給以色列人殺滅，你要砍斷他們馬匹的蹄筋，燒毀他們的戰車。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","於是，約書亞率領所有的軍兵在米倫河邊突襲敵軍。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","耶和華把敵軍交在以色列人手中，以色列人打敗了他們，追殺他們直到西頓大城、米斯利弗·瑪音和東面的米斯巴谷，全部消滅了他們，一個沒留。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","約書亞照耶和華的吩咐，砍斷他們馬匹的蹄筋，燒毀他們的戰車。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","然後，約書亞回師攻陷夏瑣，用刀殺了夏瑣王。夏瑣曾經在諸國中為首。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","以色列人用刀殺了城內的人，一個沒留。約書亞放火燒了夏瑣。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","約書亞攻佔了諸王所有的城池，擒獲諸王。他照耶和華的僕人摩西的吩咐，用刀殺死諸王，毀掉城池。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","以色列人只燒毀了夏瑣，沒有燒建在山丘上的其他城池。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","他們用刀殺掉城內所有的居民，一個沒留，擄掠了城內所有的財物和牲畜。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","耶和華怎樣吩咐祂的僕人摩西，摩西也怎樣吩咐約書亞，約書亞都一一照辦，沒有遺漏任何耶和華吩咐摩西的事。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","約書亞佔領了整個地區，包括山區、南地、歌珊全境、丘陵、亞拉巴和以色列山區及平原， ");
INSERT INTO cmncbt_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","從哈拉山起到西珥，直到黑門山山麓黎巴嫩山谷的巴力·迦得城。約書亞擒獲了各城的王，殺死了他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","約書亞跟這些地區的諸王爭戰了很久。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","除了基遍的希未人以外，其他沒有一城向以色列人求和，以色列人全部攻佔這些城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","原來耶和華使他們的心剛硬，跟以色列人作戰，好讓他們遭受無情的毀滅，正如耶和華對摩西的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","那時，約書亞又出兵把希伯崙、底璧、亞拿伯、以色列和猶大各山區的亞衲人和他們的城邑全部毀滅。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","除了在迦薩、迦特和亞實突有一些殘餘之外，以色列境內沒有亞衲人了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","約書亞照耶和華對摩西的指示，奪取整個地區，把土地按照支派分給以色列人作產業。於是境內國泰民安，沒有戰事了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","以色列人在約旦河東岸殺死了兩個王，佔據了他們的領土：自亞嫩谷直到黑門山，包括東面的整個亞拉巴。 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","這兩個王一個是住在希實本的亞摩利王西宏。他統轄的地區從亞嫩谷旁的亞羅珥，包括山谷中部和基列的一半，直到亞捫人邊境的雅博河。 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","他的領土還包括約旦河谷東部：從加利利湖至亞拉巴海，也就是鹽海，到伯·耶施末，直到毗斯迦的山麓。 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","另一個王是巴珊王噩，他原是利乏音的遺民，住在亞斯她錄和以得來。 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","他所統轄的地區包括黑門山、撒迦、整個巴珊，直到基述人和瑪迦人的邊境，還包括基列的另一半，直到希實本王西宏的國界。 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","耶和華的僕人摩西帶領以色列人征服了這兩個王，並把他們的土地分給呂便支派、迦得支派和瑪拿西半個支派的人作產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","約書亞帶領以色列人征服了約旦河西的諸王，佔領的土地包括從黎巴嫩谷地的巴力·迦得直到西珥的哈拉山。約書亞按以色列的支派把這些土地分給以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","那裡有山區、丘陵、河谷、山坡、曠野和南地，就是赫人、亞摩利人、迦南人、比利洗人、希未人、耶布斯人住的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","這些王是耶利哥王、伯特利附近的艾王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","耶路撒冷王、希伯崙王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","耶末王、拉吉王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","伊磯倫王、基色王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","底璧王、基德王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","何珥瑪王、亞拉得王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","立拿王、亞杜蘭王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","瑪基大王、伯特利王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","他普亞王、希弗王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","亞弗王、拉沙崙王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","瑪頓王、夏瑣王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","伸崙·米崙王、押煞王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","他納王、米吉多王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","基低斯王、迦密附近的約念王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","多珥山上的多珥王、吉甲的戈印王、 ");
INSERT INTO cmncbt_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","得撒王，共三十一個王。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","約書亞年事已高，耶和華對他說：「你年紀大了，但還有許多地方有待征服， ");
INSERT INTO cmncbt_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","就是非利士人和基述人的全境， ");
INSERT INTO cmncbt_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","即從埃及東面的西曷河直到北面以革倫的邊境，這一帶都算是迦南，是統治迦薩人、亞實突人、亞實基倫人、迦特人、以革倫人的五個非利士王的地方；南方亞衛人的地方； ");
INSERT INTO cmncbt_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","整個迦南人的地方，從西頓人的米亞拉直到亞摩利人邊境的亞弗； ");
INSERT INTO cmncbt_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","迦巴勒人的地方；東部從黑門山山麓的巴力·迦得直到哈馬口的整個黎巴嫩。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","我必為以色列人趕走從黎巴嫩到米斯利弗·瑪音一帶山區的所有西頓人。你只管照我的吩咐，把這些土地分給以色列人作產業， ");
INSERT INTO cmncbt_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","分給其他九個支派和瑪拿西半個支派作產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","瑪拿西半個支派和呂便、迦得兩支派已經得到耶和華的僕人摩西在約旦河東分給他們的產業： ");
INSERT INTO cmncbt_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","從亞嫩谷旁的亞羅珥起，包括谷中的城，直到底本的整個米底巴平原， ");
INSERT INTO cmncbt_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","以及希實本的亞摩利王西宏統治的各城，直到亞捫的邊境。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","此外，還包括基列、基述人和瑪迦人的疆域、整個黑門山和直到撒迦的整個巴珊地， ");
INSERT INTO cmncbt_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","以及巴珊王噩的國土。噩曾經在亞斯她錄和以得來做王，是僅存的利乏音人。摩西打敗了這些人，趕走了他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","以色列人卻沒有趕走基述人和瑪迦人，他們到今天還住在以色列人當中。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","摩西並沒有把土地分給利未支派作產業，因為獻給以色列的上帝耶和華的火祭就是他們的產業，正如耶和華對他們的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","以下是摩西按宗族分給呂便支派的產業： ");
INSERT INTO cmncbt_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","從亞嫩谷旁邊的亞羅珥城、谷中的城和米底巴附近的整個平原， ");
INSERT INTO cmncbt_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","到希實本城和希實本平原的所有城邑，即底本、巴末·巴力、伯·巴力·勉、 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","雅雜、基底莫、米法押、 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","基列亭、西比瑪、谷中山丘上的細列·沙轄、 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","伯毗珥、毗斯迦山坡和伯·耶施末， ");
INSERT INTO cmncbt_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","平原的各城邑和亞摩利王西宏的國土。西宏曾在希實本做王，摩西打敗了他和他的米甸首領以未、利金、蘇珥、戶珥和利巴。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","以色列人用刀所殺的人中有比珥的兒子術士巴蘭。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","呂便支派的土地以約旦河為界。以上是呂便支派按宗族分到的城邑和村莊。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","以下是摩西按宗族分給迦得支派的土地： ");
INSERT INTO cmncbt_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","雅謝和基列境內所有的城邑；亞捫人的一半領土，直到拉巴附近的亞羅珥； ");
INSERT INTO cmncbt_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","從希實本直到拉抹·米斯巴和比多寧，從瑪哈念到底璧的邊境； ");
INSERT INTO cmncbt_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","還有谷中的伯亞蘭、伯·寧拉、疏割、撒分，就是希實本王西宏國中其餘的土地，以約旦河為界，沿東岸直到加利利湖的頂端。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","以上這些城邑、村莊便是迦得支派按宗族所分到的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","以下是摩西按宗族分給瑪拿西半個支派的土地： ");
INSERT INTO cmncbt_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","從瑪哈念開始，包括整個巴珊，就是巴珊王噩的國土及其境內雅珥的六十座城邑， ");
INSERT INTO cmncbt_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","還有基列的一半和巴珊王噩的兩座城亞斯她錄和以得來。瑪拿西的兒子瑪吉的一半子孫按宗族分到這些土地。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","以上是摩西在耶利哥對面約旦河東的摩押平原分給以色列人的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","摩西並沒有分給利未支派任何產業，因為以色列的上帝耶和華就是他們的產業，正如耶和華對他們的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","以下是祭司以利亞撒、嫩的兒子約書亞和以色列各支派的首領，在迦南分給以色列人的產業， ");
INSERT INTO cmncbt_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","是照耶和華藉摩西所指示的，用抽籤的方式分給九個半支派的。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","摩西在約旦河東已經把產業分給了呂便、迦得支派和瑪拿西半個支派，只是沒有把產業分給利未人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","約瑟的子孫已分為瑪拿西和以法蓮兩個支派。利未人沒有分到地，但有城邑居住，還有草場可以牧養牲畜，安置財物。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","以色列人照耶和華給摩西的指示分配這些土地。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","那時，猶大支派的人來到吉甲見約書亞，基尼洗族耶孚尼的兒子迦勒對約書亞說：「你知道耶和華在加低斯·巴尼亞跟上帝的僕人摩西提到關於你和我的事。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","我四十歲那年，耶和華的僕人摩西從加低斯·巴尼亞派我來偵察這地方，我如實稟告他。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","與我同去的弟兄的稟告讓以色列人膽戰心驚，但我一心追隨我的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","所以，當日摩西就向我起誓，『你腳踏過的地方必永遠歸你和你的子孫作產業，因為你一心追隨我的上帝耶和華。』 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","耶和華照祂的應許，讓我又活了四十五年。當年耶和華對摩西說這話時，以色列人還在曠野漂流。看！我現在已經八十五歲了， ");
INSERT INTO cmncbt_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","仍像當年摩西派我出去時那樣身強力壯，跟當年一樣能征善戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","現在，求你照耶和華當日向我應許的，把這山區賜給我。你當日親耳聽到那裡有亞衲人，他們的城池高大堅固。但只要耶和華與我同在，我必照著祂的應許把這些人趕走。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","於是，約書亞便祝福耶孚尼的兒子迦勒，把希伯崙給他，作為他的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","所以，希伯崙至今仍是基尼洗族耶孚尼的兒子迦勒的產業，因為他一心追隨以色列的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","希伯崙從前名叫基列·亞巴，亞巴原是亞衲族中最偉大的人。從此，境內太平，沒有戰爭。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","猶大支派按宗族抽籤分到的土地，南到以東的邊界，到最南端的荀曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","南面的邊界始於鹽海南端的海灣， ");
INSERT INTO cmncbt_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","沿亞克拉濱山坡南面，經荀，北上至加低斯·巴尼亞南面，經過希斯崙到亞達珥，再繞到甲加， ");
INSERT INTO cmncbt_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","經過押們、順著埃及小河直到地中海。這是猶大支派的南部邊界。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","東面以鹽海到約旦河口為邊界。 北界從約旦河口的海灣開始， ");
INSERT INTO cmncbt_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","到伯·曷拉，經過伯·亞拉巴北面，直到呂便的兒子波罕所立的大石； ");
INSERT INTO cmncbt_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","從亞割谷往北到底璧，到谷南亞都冥隘口對面的吉甲，經隱·示麥泉，直到隱·羅結； ");
INSERT INTO cmncbt_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","然後再沿著欣嫩子谷而上，直到耶布斯，即耶路撒冷的南面，再到欣嫩谷西面、利乏音谷北端的山頂； ");
INSERT INTO cmncbt_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","從山頂到尼弗多亞泉，到以弗崙山的各城，直到巴拉，即基列·耶琳； ");
INSERT INTO cmncbt_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","從巴拉向西繞到西珥山，到耶琳山北坡，即基撒崙，到伯·示麥，經亭拿， ");
INSERT INTO cmncbt_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","再到以革倫北坡，轉向施基崙，經巴拉山和雅比聶，直到地中海。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","西面的邊界是地中海沿岸。以上是猶大人根據宗族所得地業的四界。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","約書亞又照耶和華的吩咐，在猶大支派所分到的土地之中劃出基列·亞巴，即希伯崙，分給耶孚尼的兒子迦勒。亞巴是亞衲人的祖先。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","迦勒趕走了住在那裡的亞衲族的三個族長，即示篩、亞希幔和撻買， ");
INSERT INTO cmncbt_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","再從那裡出兵攻打底璧，底璧從前叫基列·西弗。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","迦勒說：「誰攻取基列·西弗，我就把女兒押撒嫁給他。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","迦勒的弟弟基納斯的兒子俄陀聶攻取了那城，迦勒便把女兒押撒嫁給他。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","押撒出嫁的時候，勸丈夫向她父親要一塊田。她剛下驢，迦勒便問她：「你想要什麼？」 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","押撒答道：「求你賜福給我，你既然把南地賜給我，求你也把水泉賜給我吧。」迦勒就把上泉和下泉都給了她。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","以下是猶大支派按宗族所得的產業： ");
INSERT INTO cmncbt_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","在最南面靠近以東的城邑有甲薛、以得、雅姑珥、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","基拿、底摩拿、亞大達、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","基低斯、夏瑣、以提楠、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","西弗、提鏈、比亞綠、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","夏瑣·哈大他、加略·希斯崙，即夏瑣、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","亞曼、示瑪、摩拉大、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","哈薩·迦大、黑實門、伯·帕列、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","哈薩·書亞、別示巴、比斯約他、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","巴拉、以因、以森、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","伊勒多臘、基失、何珥瑪、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","洗革拉、麥瑪拿、三撒拿、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","利巴勿、實忻、亞因和臨門，共二十九座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","在丘陵地帶有以實陶、瑣拉、亞實拿、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","撒挪亞、隱·干寧、他普亞、以楠、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","耶末、亞杜蘭、梭哥、亞西加、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","沙拉音、亞底他音、基底拉和基底羅他音，共十四座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","還有洗楠、哈大沙、麥大·迦得、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","底連、米斯巴、約帖、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","拉吉、波斯加、伊磯倫、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","迦本、拉幔、基提利、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","基低羅、伯·大袞、拿瑪、瑪基大，共十六座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","還有立拿、以帖、亞珊、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","益弗他、亞實拿、尼悉、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","基伊拉、亞革悉、瑪利沙，共九座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","還有以革倫及其附近的城邑和鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","還有以革倫到地中海一帶所有靠近亞實突的城邑和鄉村， ");
INSERT INTO cmncbt_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","亞實突及其附近的城邑和鄉村，迦薩及其附近的城邑和鄉村，直到埃及小河和地中海沿岸。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","在山區有沙密、雅提珥、梭哥、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","達拿、基列·薩拿，即底璧、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","亞拿伯、以實提莫、亞念、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","歌珊、何崙、基羅，共十一座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","還有亞拉、度瑪、以珊、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","雅農、伯·他普亞、亞非加、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","宏他、基列·亞巴，即希伯崙、洗珥，共九座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","還有瑪雲、迦密、西弗、淤他、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","耶斯列、約甸、撒挪亞、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","該隱、基比亞、亭拿，共十座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","還有哈忽、伯·夙、基突、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","瑪臘、伯·亞諾、伊勒提君，共六座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","還有基列·巴力，即基列·耶琳、拉巴兩座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","在曠野有伯·亞拉巴、密丁、西迦迦、 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","匿珊、鹽城、隱·基底，共六座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","猶大人沒能把住在耶路撒冷的耶布斯人趕出去，他們至今仍然跟猶大人一同居住。 ");
INSERT INTO cmncbt_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","約瑟的子孫抽籤所得的地方是從耶利哥附近的約旦河，就是耶利哥水泉的東面開始，穿過曠野，直到伯特利山區； ");
INSERT INTO cmncbt_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","又從伯特利，即路斯，延至亞基人的疆土亞他綠， ");
INSERT INTO cmncbt_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","然後西下至押利提人的疆土，遠至下伯·和崙地區，經基色直到地中海。 ");
INSERT INTO cmncbt_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","約瑟的兒子瑪拿西和以法蓮得了自己的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","以下是以法蓮的子孫按宗族分到的土地：東面從亞他錄·亞達到上伯·和崙， ");
INSERT INTO cmncbt_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","直到地中海；北面從密米他向東繞到他納·示羅，到雅挪哈東部， ");
INSERT INTO cmncbt_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","再到亞他錄、拿拉，經耶利哥直到約旦河； ");
INSERT INTO cmncbt_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","又從他普亞往西到加拿河，直到地中海。這就是以法蓮的子孫按宗族所分的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","此外，他們又從瑪拿西人的產業中，分到部分城邑及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","他們沒有趕走住在基色的迦南人，迦南人至今還住在以法蓮人當中，為他們服勞役。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","以下是約瑟的長子瑪拿西支派分到的土地：瑪拿西的長子、基列的父親瑪吉是個戰士，因此分到了基列和巴珊兩地。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","瑪拿西其他子孫也按宗族分到了土地，他們屬於亞比以謝、希勒、亞斯烈、示劍、希弗和示米大宗族。這些男子按宗族都是約瑟的兒子瑪拿西的後代。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","瑪拿西的玄孫、瑪吉的曾孫、基列的孫子、希弗的兒子西羅非哈沒有兒子，只有五個女兒，名叫瑪拉、挪阿、曷拉、密迦、得撒。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","她們來見祭司以利亞撒、嫩的兒子約書亞和各首領，說：「耶和華曾經吩咐摩西在我們親族中分給我們產業。」約書亞便照耶和華的吩咐，讓她們在叔伯中也分到產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","除了約旦河東的基列和巴珊兩地以外，瑪拿西人還分到十塊土地， ");
INSERT INTO cmncbt_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","因為在瑪拿西的後代中，女性也分到了產業。瑪拿西其他子孫分到基列地區。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","瑪拿西支派分到的土地從亞設開始，到示劍東面的密米他，再向南到隱·他普亞人居住的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","他普亞地屬於瑪拿西，但在瑪拿西邊界上的他普亞城屬於以法蓮的子孫。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","邊界繼續向南到加拿河，在河南側瑪拿西境內的城邑都歸以法蓮。瑪拿西的邊界沿著加拿河北側直到地中海。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","這樣，南面歸以法蓮，北面歸瑪拿西，西部邊界是地中海，北接亞設，東鄰以薩迦。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","在以薩迦和亞設境內，瑪拿西擁有伯·善、以伯蓮、多珥、隱·多珥、他納和米吉多及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","可是，瑪拿西人沒能把這些城邑的迦南人趕走，因為他們執意不肯離開。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","以色列人國勢強盛的時候，就讓迦南人服勞役，但始終沒有把他們完全趕走。 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","約瑟的子孫對約書亞說：「耶和華賜福給我們，使我們人口眾多，為什麼你只讓我們抽一支籤，分一份產業呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","約書亞對他們說：「你們如果人口眾多，認為以法蓮山區窄小，可以到比利洗人和利乏音人居住的地方開闢林區。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","他們答道：「那些山區不夠我們住，況且住在伯·善一帶和耶斯列平原的迦南人都有鐵戰車。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","約書亞對約瑟的子孫以法蓮人和瑪拿西人說：「你們人口眾多，勢力強大，不應只得一籤之地， ");
INSERT INTO cmncbt_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","山區也要分給你們，雖然全是森林，但可以開闢土地，使整個地區歸你們。雖然迦南人強盛，有鐵戰車，但你們必能趕走他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","征服了這些地方以後，以色列全體會眾都聚集在示羅，把會幕設立在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","這時，以色列還有七個支派沒有分到產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","約書亞對他們說：「你們等到什麼時候，才去佔領你們祖先的上帝耶和華賜給你們的土地呢？ ");
INSERT INTO cmncbt_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","你們每支派要派出三個人，我要差他們走遍那地，按各支派應得的土地繪製地圖，然後回來稟告我。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","他們要把土地劃分作七份。猶大要留在南部自己的領土上，約瑟家族要留在北部自己的領土上。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","你們把這七份土地繪成地圖交給我，我要在我們的上帝耶和華面前為你們抽籤。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","你們當中的利未人沒有份，因為做耶和華的祭司這職任就是他們的產業。至於迦得支派、呂便支派和瑪拿西半個支派，耶和華的僕人摩西已把約旦河東的土地分給他們了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","那些畫地圖的人啟程出發的時候，約書亞囑咐他們說：「你們要走遍那裡，繪製地圖，然後回來稟告我，我要在示羅，在耶和華面前為你們抽籤。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","於是，他們走遍那裡，把所有城邑分作七份，繪在冊上，然後回到示羅見約書亞。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","約書亞便在示羅按照以色列的支派，在耶和華面前為他們抽籤分地。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","便雅憫支派按宗族抽籤分到的領土，座落在猶大和約瑟支派的領土之間。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","他們北部的邊界從約旦河起，沿耶利哥北面的山坡直上，往西穿過山區，直到伯·亞文的曠野； ");
INSERT INTO cmncbt_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","從那裡經路斯，即伯特利南面山坡到下伯·和崙南面山區的亞他錄·亞達。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","西面的邊界自伯·和崙對面山的西側，向南直到猶大人的基列·巴力城，即基列·耶琳。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","南部邊界從基列·耶琳的邊界開始，向西直到尼弗多亞的水泉， ");
INSERT INTO cmncbt_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","又往下到欣嫩子谷對面的山麓，也就是利乏音谷北邊，然後往南，經欣嫩谷到耶布斯的南坡，直到隱·羅結； ");
INSERT INTO cmncbt_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","然後，向北先後到隱·示麥，亞都冥山坡對面的基利綠，呂便的兒子波罕所立的大石， ");
INSERT INTO cmncbt_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","以及亞拉巴的對面，再往北下到亞拉巴； ");
INSERT INTO cmncbt_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","又沿著伯·曷拉的北面直到鹽海的北岸，也就是約旦河的南部河口。這是南部的邊界。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","東面以約旦河為界。這是便雅憫人按宗族分到的土地四周的邊界。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","以下是便雅憫支派按宗族分到的城邑：耶利哥、伯·曷拉、伊麥·基悉、 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","伯·亞拉巴、西瑪蓮、伯特利、 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","亞文、巴拉、俄弗拉、 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","基法·阿摩尼、俄弗尼、迦巴，共十二座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","還有基遍、拉瑪、比錄、 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","米斯巴、基非拉、摩撒、 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","利堅、伊利毗勒、他拉拉、 ");
INSERT INTO cmncbt_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","洗拉、以利弗、耶布斯，即耶路撒冷、基比亞、基列，共十四座城及其附近的鄉村。 這就是便雅憫各宗族所分到的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","西緬支派按宗族得到第二籤，所得的產業在猶大人的疆界內， ");
INSERT INTO cmncbt_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","有別示巴，又名示巴、摩拉大、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","哈薩·書亞、巴拉、以森、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","伊勒多臘、比土力、何珥瑪、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","洗革拉、伯·瑪加博、哈薩·蘇撒、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","伯·利巴勿、沙魯險共十三座城及其附近的鄉村， ");
INSERT INTO cmncbt_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","還有亞因、利門、以帖、亞珊四座城及其村莊， ");
INSERT INTO cmncbt_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","包括周圍所有的村莊，遠至巴拉·比珥，即南地的拉瑪。這些都是西緬支派按宗族所得的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","西緬人的產業是從猶大人的產業中撥出來的，因為猶大支派所分到的地區過於廣大，所以要撥出一部分來分給西緬人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","西布倫人按宗族得了第三籤，他們分到的土地遠至撒立。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","從撒立向西到瑪拉拉、大巴設，直到約念東邊的小河； ");
INSERT INTO cmncbt_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","從撒立向東朝日出方向到吉斯綠·他泊的邊界，經大比拉、直到雅非亞； ");
INSERT INTO cmncbt_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","再往東，經迦特·希弗、以特·加汛、臨門，直到尼亞； ");
INSERT INTO cmncbt_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","北上轉向哈拿頓，直到伊弗他·伊勒山谷。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","還有加他、拿哈拉、伸崙、以大拉、伯利恆，共十二座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","以上這些城邑和鄉村是西布倫人按宗族所得的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","以薩迦人按宗族得了第四籤， ");
INSERT INTO cmncbt_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","他們的土地包括耶斯列、基蘇律、書念、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","哈弗連、示按、亞拿哈拉、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","拉璧、基善、亞別、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","利篾、隱·干寧、隱·哈大、伯·帕薛、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","他泊、沙哈洗瑪、伯·示麥，直到約旦河，共十六座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","這些城邑和鄉村都是以薩迦支派按宗族分到的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","亞設支派按宗族得了第五籤， ");
INSERT INTO cmncbt_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","他們得到的土地包括黑甲、哈利、比田、押煞、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","亞拉米勒、亞末和米沙勒，西至迦密和希曷·立納， ");
INSERT INTO cmncbt_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","然後向東到伯·大袞，挨著西布倫和伊弗他·伊勒谷，經伯·以墨和尼業向北到迦步勒； ");
INSERT INTO cmncbt_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","再經義伯崙、利合、哈們、加拿直到西頓大城； ");
INSERT INTO cmncbt_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","再轉到拉瑪、堅固的泰爾城，然後轉到何薩，直到亞革悉一帶的地中海。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","還有烏瑪、亞弗和利合，共二十二座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","這些城邑和鄉村都是亞設支派按宗族分到的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","拿弗他利人按宗族得了第六籤， ");
INSERT INTO cmncbt_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","他們的土地從希利弗、撒拿音的橡樹、亞大米·尼吉和雅比聶到拉共，再到約旦河； ");
INSERT INTO cmncbt_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","又向西到亞斯納·他泊、戶割，南接西布倫，西接亞設，東接約旦河。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","還包括以下堅城：西丁、側耳、哈末、拉甲、基尼烈、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","亞大瑪、拉瑪、夏瑣、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","基低斯、以得來、隱·夏瑣、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","以利隱、密大·伊勒、和璉、伯·亞納、伯‧示麥，共十九座城及其附近的鄉村。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","這些城邑和鄉村都是拿弗他利支派按宗族分到的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","但支派按宗族得了第七籤， ");
INSERT INTO cmncbt_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","他們的土地包括瑣拉、以實陶、伊珥·示麥、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","沙拉賓、亞雅崙、伊提拉、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","以倫、亭拿他、以革倫、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","伊利提基、基比頓、巴拉、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","伊胡得、比尼·比拉、迦特·臨門、 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","美·耶昆、拉昆和約帕對面的一帶。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","但支派無法奪取他們的土地，於是就去攻打利善城，用刀殺了城內的居民，佔據了這座城，用他們祖先的名字把城改名為但， ");
INSERT INTO cmncbt_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","這些城邑和村莊都是但支派按宗族得到的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","以色列人把地分配完畢以後，又從中劃出土地給嫩的兒子約書亞。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","以色列人遵從耶和華的吩咐，把約書亞想要的以法蓮山區的亭拿·西拉城分給他。約書亞重修那城，住在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","以上是祭司以利亞撒、嫩的兒子約書亞和以色列各支派的首領，在示羅的會幕門口，在耶和華面前抽籤所分配的土地。至此，他們把地分完了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","耶和華對約書亞說： ");
INSERT INTO cmncbt_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","「你吩咐以色列人，照我以前藉摩西所吩咐你們的，設立一些城邑作為避難城， ");
INSERT INTO cmncbt_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","好讓誤殺人的可以逃到那裡，躲避報血仇的人追殺。 ");
INSERT INTO cmncbt_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","他要逃到避難城，站在城門口向城中的長老們陳明事情的經過，長老們就把他收容到城裡，給他提供住處，讓他留在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","如果報血仇的人追到，長老們不可把他交出來，因為他是無意殺的，跟被殺者無冤無仇。 ");
INSERT INTO cmncbt_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","他要住在城內，直到在會眾面前受了審訊，並且還要等到在任的大祭司死後，才可離城回鄉。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","於是，民眾便設立拿弗他利山區加利利境內的基低斯、以法蓮山區的示劍和猶大山區的基列·亞巴，即希伯崙作為避難城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","他們又在約旦河東岸、耶利哥東面空曠的平原上設立呂便支派的比悉，迦得支派基列境內的拉末和瑪拿西支派巴珊境內的哥蘭作為避難城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","這是為以色列人和那些從外地來寄居的人所設立的避難城，誤殺了人的可以逃到那裡，不致未在會眾面前受審便死在報血仇的人手裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","2","利未人的眾族長到迦南的示羅見祭司以利亞撒、嫩的兒子約書亞和以色列各支派的首領，說：「耶和華藉著摩西曾吩咐你們把一些城邑分給我們住，並把城郊的草場給我們牧養牲畜。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","以色列人便按照耶和華的吩咐，從他們的產業中把以下的城邑及其草場分給了利未人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","首先哥轄宗族抽了籤。利未人哥轄宗族中大祭司亞倫的子孫從猶大、西緬和便雅憫支派的產業中抽籤得了十三座城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","哥轄宗族中其他人也從以法蓮、但和瑪拿西半個支派的產業中抽籤得了十座城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","革順的子孫從以薩迦、亞設、拿弗他利和在巴珊的瑪拿西半個支派的產業中抽籤得了十三座城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","米拉利的子孫按宗族從呂便、迦得和西布倫支派的產業中抽籤得了十二座城。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","以色列人照耶和華對摩西的吩咐，把這些城邑及其草場用抽籤的方式分給利未人。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","10","因為利未支派哥轄宗族中亞倫的子孫抽到第一籤，以色列人就從猶大和西緬兩支派的產業中點名划出以下城邑分給他們： ");
INSERT INTO cmncbt_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","猶大山區的基列·亞巴及其草場，亞巴原是亞衲人的祖先，基列·亞巴就是希伯崙。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","而城周圍的田地和鄉村已經分給耶孚尼的兒子迦勒作產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","以色列人把避難城希伯崙分給祭司亞倫的子孫，並把立拿、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","雅提珥、以實提莫、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","何崙、底璧、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","亞因、淤他、伯·示麥共九座城及其草場分給了他們。這都是從猶大和西緬兩支派分出來的。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","從便雅憫支派的產業中分給他們的城有：基遍、迦巴、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","亞拿突、亞勒們四座城及其草場。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","做祭司的亞倫子孫共分到十三座城邑及其草場。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","利未人哥轄宗族其他子孫從以法蓮支派的產業中抽籤分到的城邑有： ");
INSERT INTO cmncbt_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","以法蓮山區的避難城示劍、基色、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","基伯先和伯·和崙共四座城及其草場。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","從但支派的產業中分給他們的城邑有：伊利提基、基比頓、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","亞雅崙和迦特·臨門四座城及其草場。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","他們從瑪拿西半個支派的產業中分到他納和迦特·臨門兩座城及其草場。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","以上是哥轄其他子孫所分到的十座城及其草場。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","以色列人分給利未支派中革順子孫的城邑有：瑪拿西半個支派中巴珊的哥蘭避難城和比·施提拉兩座城及其草場； ");
INSERT INTO cmncbt_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","以薩迦支派的基善、大比拉、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","耶末、隱·干寧四座城及其草場； ");
INSERT INTO cmncbt_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","亞設支派的米沙勒、押頓、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","黑甲、利合四座城及其草場； ");
INSERT INTO cmncbt_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","拿弗他利支派的哈末·多珥、加珥坦和加利利的避難城基低斯三座城及其草場。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","革順人按宗族共分到十三座城邑及其草場。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","其餘的利未人，就是米拉利的子孫所分到的城邑有：西布倫支派的約念、加珥他、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","丁拿、拿哈拉四座城及其草場； ");
INSERT INTO cmncbt_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","呂便支派的比悉、雅雜、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","基底莫、米法押四座城及其草場； ");
INSERT INTO cmncbt_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","迦得支派的瑪哈念、基列的避難城拉末、 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","希實本、雅謝四座城及其草場。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","利未人中米拉利的子孫按宗族所分到的城邑共有十二座。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","利未人從以色列各支派共分到四十八座城及其草場， ");
INSERT INTO cmncbt_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","這些城周圍都有草場，城城如此。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","這樣，耶和華把從前起誓要賜給以色列人祖先的整個地區，都賜給了以色列人，以色列人都分到土地，住了下來。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","耶和華照著給他們祖先的應許，使他們四境安寧，沒有仇敵能抵擋他們。耶和華將所有仇敵都交在了他們手中。 ");
INSERT INTO cmncbt_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","耶和華給以色列人的美好應許沒有一句落空，全部實現了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","約書亞召來了呂便、迦得和瑪拿西半個支派的人來， ");
INSERT INTO cmncbt_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","對他們說：「你們都遵守了耶和華的僕人摩西的一切吩咐，也聽從了我的一切吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","這些日子以來，你們從沒有離棄自己的弟兄，遵守了你們的上帝耶和華的吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","現在你們的上帝耶和華已經照祂的應許，使你們的弟兄安居，你們可以回到約旦河東，到摩西賜給你們作產業的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","不過，你們要謹遵耶和華的僕人摩西吩咐你們的誡命和律法，要愛你們的上帝耶和華，遵行祂的旨意，聽從祂的命令，依靠祂，全心全意地事奉祂。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","於是，約書亞為他們祝福，送他們回去，他們就各自返回家園去了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","摩西已經在巴珊把土地分給了瑪拿西半個支派，約書亞把約旦河西的土地分給了瑪拿西另外的半個支派及其他支派。約書亞派他們回家的時候，為他們祝福， ");
INSERT INTO cmncbt_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","說：「現在你們帶著大量財物、牲畜、金銀、銅、鐵和衣物返回家園，要把從敵人那裡得來的財物分給你們的弟兄。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","於是，呂便、迦得和瑪拿西半個支派的人，便離開在迦南的示羅的以色列人，返回耶和華藉摩西分配給他們的基列。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","他們來到約旦河附近的迦南境內，就在約旦河邊築了一座高大的祭壇。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","以色列人聽見呂便、迦得和瑪拿西半個支派的人，在約旦河西的迦南境內築起了一座祭壇， ");
INSERT INTO cmncbt_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","便全部聚集在示羅，要討伐他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","以色列人派祭司以利亞撒的兒子非尼哈去基列見他們， ");
INSERT INTO cmncbt_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","又從每支派差遣一位族長，共十位隨行。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","他們來到基列的呂便、迦得和瑪拿西半個支派的人那裡，對他們說： ");
INSERT INTO cmncbt_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","「耶和華的全體會眾問你們，你們怎能這樣背叛以色列的上帝，離棄耶和華，為自己另建祭壇呢？ ");
INSERT INTO cmncbt_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","從前拜毗珥的罪惡不夠大嗎？那一次，瘟疫降到耶和華的會眾身上，直到今日我們還沒有洗淨這罪。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","你們今日要離棄耶和華嗎？今日你們背叛耶和華，明日祂必向以色列全體會眾發怒。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","你們如果認為自己的土地不潔淨，可以搬到耶和華的土地上跟我們一起居住，這裡有耶和華的聖幕。只是不可在耶和華的祭壇以外，為自己另築祭壇，以致背叛耶和華，背叛我們。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","從前謝拉的曾孫亞干私自留下那些耶和華吩咐要毀滅之物，耶和華的烈怒難道沒有臨到以色列全體會眾嗎？因他的罪而死的不只他一個人！」 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","呂便、迦得和瑪拿西半個支派的人便回答這些以色列的族長說： ");
INSERT INTO cmncbt_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","「大能的上帝耶和華，大能的上帝耶和華，祂知道一切！以色列人也當知道！如果我們悖逆或干犯耶和華，願祂今天就不放過我們！ ");
INSERT INTO cmncbt_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","如果我們離棄耶和華，為自己造祭壇，或在壇上獻燔祭、素祭和平安祭，願耶和華親自懲罰我們。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","我們這樣做是怕以後你們的子孫可能會對我們的子孫說，『你們和以色列的上帝耶和華有什麼關係？ ");
INSERT INTO cmncbt_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","耶和華把約旦河定為我們跟你們呂便人和迦得人的邊界，你們與耶和華一點關係也沒有。』這樣，恐怕你們的子孫會使我們的子孫不再敬畏耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","因此，我們便商議在這裡築一座祭壇，這壇不是用來獻燔祭或別的祭， ");
INSERT INTO cmncbt_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","只是在你們和我們之間，也在彼此的後人之間立個證據，證明我們也獻燔祭、平安祭及其他祭事奉耶和華，免得日後你們的子孫對我們的子孫說，『你們與耶和華一點關係也沒有。』 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","我們商議，萬一你們對我們或我們的子孫這樣說，我們可以回答說，『你們看我們祖先築的這座祭壇跟耶和華的祭壇一模一樣，只是這座壇不是用來獻燔祭或別的祭，而是作為你們和我們之間的證據！』 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","我們根本無意背叛、離棄我們的上帝耶和華，在祂聖幕前的祭壇以外另築祭壇來獻燔祭、素祭和別的祭。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","祭司非尼哈和以色列會眾的族長聽了他們的解釋，都很滿意。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","以利亞撒的兒子祭司非尼哈對他們說：「今日我們知道耶和華在我們當中，因為你們沒有對耶和華不忠，現在你們使以色列人免遭耶和華的懲罰了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","以利亞撒的兒子非尼哈祭司和眾族長便離開呂便人和迦得人，從基列回到迦南向以色列人報告這事。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","眾人聽後，都很滿意，便頌讚耶和華，打消了出兵討伐呂便人和迦得人、毀滅他們家園的念頭。 ");
INSERT INTO cmncbt_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","呂便人和迦得人給那座祭壇取名叫「證壇」，意思是這壇在我們中間證明耶和華是上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","此後很長時間，耶和華使以色列人四境太平，沒有戰事。約書亞年事已高， ");
INSERT INTO cmncbt_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","他召來全體以色列人，包括長老、族長、審判官和官長，對他們說：「我已經老了， ");
INSERT INTO cmncbt_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","你們都親眼看見你們的上帝耶和華怎樣為了你們而對付列邦，親自為你們爭戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","從約旦河到西邊地中海的這片土地，無論是已征服的還是沒有征服的，我已經用抽籤的方式分給你們各支派作產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","你們的上帝耶和華必把列邦從你們面前驅離趕走，讓你們佔據他們的土地，正如你們的上帝耶和華的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","所以，你們要剛強，謹遵摩西律法書上所記載的一切，不可有半點偏離。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","不可與你們中間剩下的異族混雜，不可提他們的神明或憑它們起誓，不可供奉和祭拜他們的神明。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","你們要一如既往地倚靠你們的上帝耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","因為祂為你們趕走了強大的外族人，至今無人敵得過你們。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","你們一個人能打敗他們一千人，因為你們的上帝耶和華照著祂的應許為你們爭戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","所以你們要特別謹慎，愛你們的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","如果你們悖逆，跟你們當中剩下的異族人聯合，通婚往來， ");
INSERT INTO cmncbt_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","毫無疑問，你們的上帝耶和華必不再為你們趕走他們。相反，他們還要成為設在你們當中的圈套和陷阱，你們的肉中刺、眼中釘，直到你們在你們的上帝耶和華所賜給你們的這塊美好的土地上滅亡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","「我快要走完人世的路程了。你們深知你們的上帝耶和華賜給你們的一切美好應許，沒有一句落空，都已經應驗了。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","正如你們的上帝耶和華已成就祂應許給你們的一切福氣，祂也會照樣降各樣災禍給你們，直到把你們從祂所賜的這美好土地上毀滅。 ");
INSERT INTO cmncbt_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","你們如果違背你們的上帝耶和華吩咐你們遵守的約，去供奉、祭拜其他神明，祂必向你們發怒，使你們在祂所賜的這美好土地上迅速滅亡。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","約書亞在示劍招聚以色列各支派，他召來以色列的長老、族長、審判官和官長。他們一同站在上帝面前。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","約書亞對全體民眾說：「以色列的上帝耶和華這樣說，『從前你們的祖先，包括亞伯拉罕和拿鶴二人的父親他拉，住在幼發拉底河那邊拜其他神明。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","我把你們的祖先亞伯拉罕從幼發拉底河那邊帶出來，領他走遍迦南，使他人丁興旺。我把以撒賜給他， ");
INSERT INTO cmncbt_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","把雅各和以掃賜給以撒，把西珥山賜給以掃作產業，雅各和他的子孫則去了埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","後來，我差遣了摩西和亞倫，並用災禍攻擊埃及人，把你們領出來。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","我帶你們的祖先出埃及，到達紅海，埃及人帶領戰車騎兵追了上來。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","你們的祖先大聲呼求我，我就降下黑暗，把你們和埃及人分開，又用海水淹沒埃及人。你們親眼見過我在埃及的作為。後來，你們在曠野住了很長時間。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","我領你們來到約旦河東邊亞摩利人居住的地方。他們跟你們爭戰，我把他們交在你們手中，使你們佔領他們的土地作自己的產業。我把他們從你們面前全部消滅。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","那時，摩押王西撥的兒子巴勒起兵攻打你們，並派人去召比珥的兒子巴蘭來咒詛你們。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","但我不聽巴蘭的話，反而使他為你們連連祝福。這樣，我從巴勒手中救了你們。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","你們過了約旦河來到耶利哥。耶利哥人、亞摩利人、比利洗人、迦南人、赫人、革迦撒人、希未人和耶布斯人都跟你們交戰，但我把他們交在你們手中。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","我差黃蜂飛在你們前面，把亞摩利的兩個王從你們面前趕走，沒有動用你們一刀一弓。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","你們沒有開墾土地，也沒有建造城邑，但我賜給你們土地和城邑，使你們住在其中，享用別人栽種的葡萄園和橄欖園的果子。』 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","「所以，你們要敬畏耶和華，誠心誠意地事奉祂，棄絕你們祖先在幼發拉底河那邊和在埃及所拜的神明，專心事奉耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","你們如果不願事奉耶和華，今天就選擇你們的神明吧，或大河那邊你們祖先事奉的神明，或你們這裡亞摩利人的神明。至於我和我全家，我們必事奉耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","民眾答道：「我們決不背棄耶和華去事奉其他神明， ");
INSERT INTO cmncbt_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","因為我們的上帝耶和華曾領我們和我們的祖先脫離埃及人的奴役，在我們眼前行大神蹟，一路保護我們安然經過列邦。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","耶和華把這地方的亞摩利人等外族人從我們面前趕走了，我們必事奉祂，因為祂是我們的上帝。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","約書亞說：「你們不能事奉耶和華，祂是聖潔的上帝，祂痛恨不貞，必不赦免你們的過犯和罪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","如果你們背棄耶和華，去拜外族的神明，祂雖然恩待了你們，也必轉而降禍給你們，毀滅你們。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","民眾答道：「不，我們一定要事奉耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","約書亞說：「現在你們自己作證，你們已選擇事奉耶和華。」民眾答道：「我們願意自己作證。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","約書亞說：「這樣，你們現在就要棄絕你們中間的外族神明，專心歸向以色列的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","民眾答道：「我們必事奉我們的上帝耶和華，聽從祂的話。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","當天約書亞與民眾立約，在示劍為他們訂立律例和典章。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","約書亞把這些話都寫在上帝的律法書上，又把一塊大石頭豎立在耶和華聖所旁邊的橡樹下。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","然後，他對民眾說：「看啊，這塊石頭可以為我們作證，它聽到了耶和華所吩咐我們的話。如果你們背棄上帝，它必作證。」 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","於是，約書亞命民眾各自返回自己的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","後來，耶和華的僕人、嫩的兒子約書亞去世了，享年一百一十歲。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","以色列人把他葬在他的土地上，就是在迦實山北邊、以法蓮山區的亭拿·西拉。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","約書亞在世的時候，以色列人都事奉耶和華。他死後，在那些經歷過耶和華奇妙作為的長老還健在期間，以色列人仍事奉耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","以色列人把從埃及帶出來的約瑟的骸骨葬在示劍，在從前雅各用一百塊銀子向哈抹的子孫買的那塊地裡。哈抹是示劍的父親。後來那塊地成了約瑟子孫的產業。 ");
INSERT INTO cmncbt_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","亞倫的兒子以利亞撒也死了，他們把他葬在他兒子非尼哈分到的以法蓮山區的基比亞。");
INSERT INTO cmncbt_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","約書亞去世以後，以色列人求問耶和華：「我們哪一個支派先上去攻打迦南人呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","耶和華說：「猶大支派先去，我已把那片土地交在他們手中了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","猶大人對同胞西緬人說：「請跟我們一同到我們分得的地方攻打迦南人，我們也會同樣幫助你們。」於是，西緬人便與猶大人同去。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","猶大人上去攻打迦南人和比利洗人，耶和華使他們得勝，在比色殺了一萬敵軍。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","他們又在那裡遇見亞多尼·比色，與他交戰，打敗了他帶領的迦南人和比利洗人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","亞多尼·比色逃跑，他們追上去擒住他，砍掉他的大拇指和大腳趾。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","亞多尼·比色說：「從前七十個王被我砍掉大拇指和大腳趾，在我桌下撿食物碎屑，現在上帝照我的行為報應我了。」他們把他帶到耶路撒冷，他就死在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","猶大人攻陷耶路撒冷，用刀殺了城內的所有居民，並放火焚城。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","隨後，他們下去攻打住在山區、南地和丘陵的迦南人， ");
INSERT INTO cmncbt_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","又進攻住在希伯崙的迦南人，殺了示篩、亞希幔和撻買。希伯崙從前叫基列·亞巴。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","他們從那裡出兵攻打底璧，底璧從前叫基列·西弗。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","迦勒說：「誰攻取基列·西弗，我就把女兒押撒嫁給他。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","迦勒的弟弟基納斯的兒子俄陀聶攻取了那城，迦勒便把女兒押撒嫁給他。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","押撒出嫁的時候，勸丈夫向她父親要一塊田。她剛下驢，迦勒便問她：「你想要什麼？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","她回答說：「求你賜福給我，你既然把南地賜給我，求你也把水泉給我吧。」迦勒就把上泉和下泉都給了她。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","摩西岳父的後代基尼人和猶大人一同離開棕樹城，到猶大南部曠野的亞拉得附近，跟當地人一起居住。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","之後，猶大人隨同胞西緬人一起攻打洗法城內的迦南人，徹底毀滅了那城。因此那城叫何珥瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","猶大人又奪取了迦薩、亞實基倫和以革倫三座城邑及周圍地區。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","耶和華與猶大人同在。他們攻佔了山區，卻沒能趕走平原的居民，因為那裡的人有鐵戰車。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","照摩西的吩咐，迦勒得到了希伯崙。他把亞衲三族的人從那裡趕走。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","便雅憫人沒有趕走居住在耶路撒冷的耶布斯人，耶布斯人至今仍和他們住在一起。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","約瑟家族也上去攻打伯特利，耶和華與他們同在。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","他們先派人去打探伯特利，那裡從前名叫路斯。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","探子看見一個人從城裡出來，就對他說：「請你告訴我們進城的路，我們必善待你。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","那人便告訴他們進城的路，他們用刀殺了城內所有的居民，只放走了那人及其全家。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","後來，那人搬到赫人的地方，築了一座城，稱之為路斯，沿用至今。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","瑪拿西人沒有趕走伯·善、他納、多珥、以伯蓮和米吉多眾城邑及其周圍村莊的居民，因為這些迦南人執意住在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","以色列人強盛時，就強迫他們服勞役，卻沒有全部趕走他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","以法蓮人沒有趕走住在基色的迦南人，這些迦南人仍然住在他們當中。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","西布倫人沒有趕走基倫和拿哈拉的居民，這些迦南人仍然住在他們當中，為他們服勞役。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","亞設人沒有趕走亞柯、西頓、亞黑拉、亞革悉、黑巴、亞弗革和利合的居民。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","亞設人因為沒有趕出當地的迦南人，就住在他們當中。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","拿弗他利人沒有趕走伯·示麥和伯·亞納的居民，於是就住在這些迦南人當中，強迫他們服勞役。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","亞摩利人強迫但人住在山區，不准他們下到平原。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","亞摩利人執意住在希烈山、亞雅崙和沙賓，但約瑟家族強盛時，就強迫他們服勞役。 ");
INSERT INTO cmncbt_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","亞摩利人的邊界從亞克拉濱山坡起，一直到西拉以北。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","耶和華的天使從吉甲來到波金，對以色列人說：「我帶你們出埃及，領你們來到我起誓要賜給你們祖先的土地。我說，『我永不廢棄跟你們立的約， ");
INSERT INTO cmncbt_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","你們不可跟這裡的居民立約，要毀掉他們的祭壇。』可是你們為什麼不聽呢？ ");
INSERT INTO cmncbt_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","因此，我告訴你們，我必不趕走這裡的居民，他們必成為你們肋旁的刺，他們的神明必成為你們的網羅。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","耶和華的天使說完這些話，以色列人放聲大哭， ");
INSERT INTO cmncbt_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","他們稱那地方為波金，在那裡向耶和華獻祭。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","約書亞遣散以色列人後，他們便各自去攻佔所分得的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","約書亞在世的時候，以色列人都事奉耶和華。他死後，那些目睹耶和華為以色列人行大事的長老還在世的時候，以色列人仍事奉耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","耶和華的僕人、嫩的兒子約書亞去世時一百一十歲。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","以色列人把他葬在他自己的土地上，在迦實山以北、以法蓮山區的亭拿·希烈。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","那一代人都去世後，新一代不認識耶和華，也不知道耶和華為以色列人所行的事。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","以色列人做耶和華視為惡的事，祭拜巴力。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","他們背棄了領他們祖先離開埃及的上帝耶和華，追隨、祭拜鄰邦的各種神明，因而惹耶和華發怒。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","他們背棄耶和華，去祭拜巴力和亞斯她錄。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","耶和華向他們發怒，使他們受到掠奪者的攻擊和四周仇敵的壓制，毫無抵抗之力。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","他們每次出戰，耶和華都出手與他們為敵，使他們戰敗，正如祂的誓言。他們苦不堪言。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","後來，耶和華使士師興起，從掠奪者手中拯救他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","但他們不聽從士師的話，與其他神明苟合，祭拜它們，很快偏離他們祖先的道路，沒有像他們的祖先那樣遵行耶和華的命令。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","耶和華見他們因敵人的壓迫和苦待而哀號，就憐憫他們，使士師陸續興起，並與每位士師同在。士師在世之日，耶和華從仇敵手中拯救他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","士師去世以後，他們又故態復萌，追隨、祭拜其他神明，比他們的祖先更敗壞。他們執迷不悟，怙惡不悛。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","耶和華向他們發怒，說：「這百姓違背了我跟他們祖先所立的約，不聽從我的話。 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","因此，我不再逐出約書亞去世時還沒有趕走的外族人， ");
INSERT INTO cmncbt_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","我要藉此試驗以色列人，看他們是否像他們祖先一樣謹遵我的道。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","這就是為什麼耶和華留下那些外族人，沒有立刻把他們趕走，也沒有把他們交在約書亞手中。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","2","耶和華為了考驗那些沒有經歷過迦南戰事的以色列人，讓他們學習作戰，就留下了以下各族： ");
INSERT INTO cmncbt_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","五個非利士王、所有的迦南人、西頓人和住在巴力·黑門山到哈馬口一帶的黎巴嫩山區的希未人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","耶和華留下這幾個外族是要考驗以色列人，看他們是否願意遵從祂藉摩西向他們祖先頒佈的誡命。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","以色列人住在這些迦南人、赫人、亞摩利人、比利洗人、希未人和耶布斯人當中， ");
INSERT INTO cmncbt_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","跟他們通婚，祭拜他們的神明。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","以色列人做耶和華視為惡的事，忘記他們的上帝耶和華，祭拜假神巴力和亞舍拉。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","耶和華向他們發怒，把他們交在美索不達米亞王古珊·利薩田的手中，受古珊·利薩田統治八年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","他們向耶和華呼求，耶和華就使一位名叫俄陀聶的拯救者興起，他是迦勒弟弟基納斯的兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","耶和華的靈降在俄陀聶身上，他就做了以色列的士師，領兵出戰。耶和華將美索不達米亞王古珊·利薩田交在他手中，他便戰勝了古珊·利薩田。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","此後，國內安享太平四十年，直到俄陀聶去世。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","之後，以色列人又做耶和華視為惡的事，耶和華就使摩押王伊磯倫強盛起來，攻打以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","伊磯倫聯合亞捫人和亞瑪力人進攻以色列人，佔據了棕樹城， ");
INSERT INTO cmncbt_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","以色列人受摩押王伊磯倫統治十八年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","他們呼求耶和華，耶和華就使一位名叫以笏的拯救者興起。他是便雅憫人基拉的兒子，善用左手。以色列人派他去向摩押王伊磯倫進貢。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","他造了一把約半米長的兩刃利劍，綁在右腿的衣服裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","他帶著貢物去見極其肥胖的摩押王伊磯倫。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","以笏獻上了貢物之後，便讓抬貢物的人先回去。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","他自己從吉甲附近的石雕神像處折回王宮，對王說：「王啊，我有機密稟告。」王就命左右侍從迴避，眾人便都退去。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","當時王獨自坐在樓上的房間乘涼，以笏近前說：「我有從上帝而來的訊息要稟告。」王從座位上站起來的時候， ");
INSERT INTO cmncbt_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","以笏左手拔出藏在右腿上的劍刺進王的肚腹， ");
INSERT INTO cmncbt_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","連劍柄也刺了進去，深深嵌入肥肉。以笏沒有拔劍， ");
INSERT INTO cmncbt_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","便走出房間，把門都關上，鎖好。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","以笏走後，王的僕人過來，見房門緊鎖，以為王在大解。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","等了很久，門還沒開，他們很焦急，就拿鑰匙開門，發現他們的主人已經倒斃在地上。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","他們等待的時候，以笏已經逃走了。他經過石雕神像處，逃往西伊拉。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","到了那裡，他就在以法蓮的山區吹響號角，召集以色列人。眾人跟隨以笏下山， ");
INSERT INTO cmncbt_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","以笏對他們說：「跟我來！耶和華已經把仇敵摩押人交在你們手中了。」於是，眾人跟著他下去佔領了通往摩押的約旦河各渡口，不許任何人渡河。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","當時他們殺了約一萬名強悍善戰的摩押勇士，沒有一人逃脫。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","這樣，以色列人征服了摩押人，國中安享太平八十年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","以笏之後，亞拿的兒子珊迦拯救了以色列人。他曾用一根趕牛棍殺了六百名非利士人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","以笏死後，以色列人又做耶和華視為惡的事。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","耶和華把他們交在統治夏瑣的迦南王耶賓手中。耶賓王的將軍叫西西拉，住在夏羅設。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","耶賓王擁有九百輛鐵戰車，他殘暴地壓迫以色列人二十年。以色列人向耶和華呼求。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","當時做以色列士師的是女先知底波拉，她是拉比多的妻子， ");
INSERT INTO cmncbt_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","經常坐在以法蓮山區拉瑪和伯特利之間的底波拉棕樹下，審理以色列人的糾紛。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","她派人去拿弗他利的基低斯召來亞比挪庵的兒子巴拉，對他說：「以色列的上帝耶和華命你率領一萬拿弗他利人和西布倫人上他泊山。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","祂必使耶賓的將軍西西拉率領全軍和戰車到基順河與你交戰，祂必把西西拉交在你手中。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","巴拉回答說：「你跟我去，我就去；你不跟我去，我就不去。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","底波拉說：「好，我一定與你同去。不過，你這次出征一定得不到榮耀，因為耶和華要把西西拉交在一名婦人手上。」於是，底波拉起身與巴拉一同前往基低斯。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","巴拉招聚了一萬名拿弗他利人和西布倫人，底波拉與他一起出征。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","摩西的岳父何巴的後人基尼人希百離開自己的族人，在基低斯附近撒拿音的橡樹旁搭帳篷居住。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","西西拉得知亞比挪庵的兒子巴拉已經上了他泊山， ");
INSERT INTO cmncbt_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","便召集全軍和九百輛鐵戰車離開夏羅設，向基順河進軍。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","底波拉對巴拉說：「出擊吧！今天耶和華要把西西拉交在你手中。看啊，耶和華已經率先出戰了！」於是，巴拉率領一萬人下了他泊山， ");
INSERT INTO cmncbt_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","進攻西西拉。耶和華使西西拉的戰車和軍隊潰亂，敗在巴拉刀下。西西拉棄車徒步逃跑， ");
INSERT INTO cmncbt_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","巴拉追擊他的戰車和軍隊，直到夏羅設。西西拉全軍都死於刀下，無一逃脫。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","只有西西拉一人徒步逃到基尼人希百的妻子雅億的帳篷，因為夏瑣王耶賓和希百家向來友好。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","雅億出來迎接西西拉，對他說：「我主，請進，不用怕！」西西拉便走進帳篷，雅億為他蓋上毯子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","西西拉說：「我口渴，請給我一點水吧。」雅億打開皮袋給他奶喝，然後又給他蓋上毯子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","西西拉又說：「請你守著門口，倘若有人查問，你就說沒人來過這裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","西西拉因疲勞過度，沉沉入睡。雅億乘機拿起錘子和一根帳篷的橛子，悄悄地走到他身旁，把橛子釘進他的太陽穴，直插到地裡。西西拉就這樣死了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","巴拉追來了，雅億出來迎接他，對他說：「你找的人在這裡，進來看看吧。」巴拉和她進了帳篷，見西西拉死在那裡，太陽穴上還插著橛子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","那天，上帝使以色列人戰勝了迦南王耶賓。 ");
INSERT INTO cmncbt_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","以色列人越戰越勇，最終消滅了迦南王耶賓。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","那一天，底波拉和亞比挪庵的兒子巴拉高唱凱歌： ");
INSERT INTO cmncbt_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","「以色列的首領身先士卒， 民眾前仆後繼， 你們要讚美耶和華！ ");
INSERT INTO cmncbt_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","君王啊，請聽！首領啊，請側耳聽！ 我要向耶和華歌唱， 我要歌頌以色列的上帝耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","耶和華啊，當你從西珥出來， 走過以東時， 大地震動， 天上下雨， 雲降雨水。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","在西奈山的耶和華面前， 在以色列的上帝耶和華面前， 群山震動。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","在亞拿的兒子珊迦與雅億的時代， 大路行人絕跡， 旅客繞道前行。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","我底波拉做以色列之母以前， 以色列的鄉村杳無人煙。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","以色列人選擇新的神明， 便戰禍臨門， 四萬以色列人中找不到一矛一盾。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","我的心追隨以色列的首領， 追隨民中踴躍出征的人。 你們要讚美耶和華！ ");
INSERT INTO cmncbt_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","「你們騎白驢的、坐繡花毯子的、步行的， 都要傾聽。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","歌樂手聚集在井旁， 傳揚耶和華和祂以色列子民的勝利。 耶和華的子民都來到城門口。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","「底波拉啊，來吧，來吧， 歌唱吧！ 亞比挪庵的兒子巴拉啊，來吧， 帶走你的戰俘吧！ ");
INSERT INTO cmncbt_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","倖存的以色列人響應他們的首領， 耶和華的子民為我攻擊勇士。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","他們有些來自原屬亞瑪力人的以法蓮， 有些來自便雅憫， 統領出自瑪吉， 將官出自西布倫。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","以薩迦的首領與底波拉同往， 以薩迦人隨巴拉同去， 眾人一起衝進山谷， 呂便人卻猶豫不決。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","呂便人為什麼坐在羊圈中聽悠悠笛聲？ 他們舉棋不定。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","基列人留在約旦河東岸。 但人為什麼停留在船上？ 亞設人在海岸靜坐， 在港口逗留。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","但西布倫人捨生忘死， 拿弗他利人拼死鏖戰沙場。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","「迦南諸王來戰， 來到米吉多河邊的他納交戰， 卻沒有掠走金銀。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","星辰從天上爭戰， 從它們的軌道攻擊西西拉。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","古老的基順河沖走了敵人。 我的心啊，要奮勇向前！ ");
INSERT INTO cmncbt_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","蹄聲隆隆， 駿馬疾馳！ ");
INSERT INTO cmncbt_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","「耶和華的天使說， 『要咒詛米羅斯， 要重重地咒詛米羅斯的居民， 因為他們沒有幫助耶和華， 沒有幫助耶和華攻擊強敵。』 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","「基尼人希百的妻子雅億是婦人中最有福的， 是住帳篷的婦人中最有福的。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","西西拉求水， 雅億給他奶喝， 用珍貴的碗盛上乳酪。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","雅億左手拿起橛子， 右手拿起工匠的錘子， 猛擊西西拉， 打碎了他的頭， 刺透了他的太陽穴。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","西西拉屈身倒下， 死在她腳前， 一動不動地躺在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","「西西拉的母親憑窗遠眺， 隔著窗櫺喊道， 『為什麼他的戰車遲遲不回？ 為什麼還聽不到車輪聲？』 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","聰明的宮女安慰她， 她卻依然自言自語， ");
INSERT INTO cmncbt_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","『莫非他們在搜索、瓜分戰利品？ 每人得到一兩個少女， 西西拉分得繡花彩巾， 繡花的彩色圍巾作戰利品。』 ");
INSERT INTO cmncbt_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","耶和華啊， 願你的敵人都像西西拉一樣滅亡！ 願愛你的人都如升起的太陽， 光輝熠熠！」 此後，以色列安享太平四十年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","後來，以色列人又做耶和華視為惡的事，耶和華就把他們交在米甸人手下七年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","米甸人勢力強盛，以色列人只好躲進山裡，藏在洞穴和營寨中。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","每當他們撒種的時候，米甸人、亞瑪力人及東方人就前來進犯， ");
INSERT INTO cmncbt_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","在他們境內安營，摧毀他們遠至迦薩一帶的莊稼，不給他們留下任何糧食，也不留下一隻羊、一頭牛或驢。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","入侵者帶著牲畜和帳篷像蝗蟲一樣湧來，人和駱駝不計其數，摧毀了整個地區。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","以色列人因米甸人的入侵而極其貧乏，就呼求耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","當以色列人因米甸人的入侵而呼求耶和華的時候， ");
INSERT INTO cmncbt_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","耶和華就差遣先知對他們說：「以色列的上帝耶和華說，『我曾把你們從受奴役之地埃及領出來， ");
INSERT INTO cmncbt_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","將你們從埃及人及一切欺壓者的手中拯救出來，從你們面前趕走他們，把他們的土地賜給你們。』 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","我曾對你們說，『我是你們的上帝耶和華。你們雖然住在亞摩利人的地方，但不可祭拜他們的神明。』你們卻充耳不聞。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","一天，耶和華的天使來到俄弗拉，坐在亞比以謝族人約阿施的橡樹下。約阿施的兒子基甸因為要躲避米甸人，正躲在榨酒池裡打麥子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","耶和華的天使向基甸顯現，對他說：「英勇的戰士啊，耶和華與你同在。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","基甸說：「我主啊，如果耶和華與我們同在，我們怎會有這些遭遇？我們的祖先說耶和華曾帶他們出埃及，但如今祂那些奇妙的作為在哪裡呢？現在祂已經丟棄我們，把我們交在米甸人手裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","耶和華轉向他，說：「你盡自己的力量去從米甸人手中拯救以色列人吧，我現在派你去。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","基甸說：「主啊，我出身於瑪拿西支派最弱小的家族，在家裡最微不足道，我怎能拯救以色列人呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","耶和華說：「我必與你同在，你必如擊打一人一樣擊打米甸人。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","基甸說：「如果我在你面前蒙恩，求你給我一個憑據，使我知道與我說話的真是你耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","請你在這裡等一等，讓我回去拿禮物獻給你。」耶和華說：「我必等你回來。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","基甸回家預備了一隻山羊羔，用十公斤麵粉做了無酵餅，把肉放進籃子，把湯盛在壺中，然後拿到橡樹下獻上。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","上帝的天使對基甸說：「把肉和無酵餅放在這磐石上，把湯倒在上面。」他一一照做。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","耶和華的天使伸出手中的杖碰了一下餅和肉，火就從磐石中噴出來燒盡了它們。耶和華的天使也不見了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","基甸發現他果然是耶和華的天使，便說：「唉！主耶和華啊，不好了，我面對面見了你的天使。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","耶和華對他說：「放心吧，不要害怕，你不會死。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","基甸在那裡為耶和華築了一座壇，稱之為「耶和華賜平安」。這壇如今仍在亞比以謝族的俄弗拉。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","那天晚上，耶和華吩咐基甸：「牽來你父親的第二頭牛，就是那頭七歲的公牛，拆毀你父親為巴力築的祭壇，砍倒壇旁的亞舍拉神像。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","然後，在這座山頂上把石頭堆放整齊，為你的上帝耶和華築一座祭壇，用砍倒的亞舍拉神像作柴，把那頭公牛獻作燔祭。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","於是，基甸帶了十個僕人遵命而行。不過，他因為害怕家人和城中的人，不敢在白天行動，便在夜間行動。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","清早，城裡的人起來後，發現巴力的祭壇已經被人拆毀，壇旁的亞舍拉神像被砍倒，第二頭公牛被獻在新建的祭壇上。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","他們彼此議論說：「這是誰幹的？」他們仔細調查後得知是約阿施的兒子基甸所為， ");
INSERT INTO cmncbt_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","便對約阿施說：「把你兒子交出來！他拆毀了巴力的祭壇，砍倒了壇旁的亞舍拉神像，我們要處死他！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","約阿施對氣勢洶洶的人群說：「你們這樣做是要為巴力辯護嗎？是要救它嗎？誰為巴力辯護，今天早晨就處死誰。有人拆毀巴力的祭壇，如果它是神明，就讓它為自己辯護吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","因此，那天他們稱基甸為耶路·巴力，意思是「讓巴力為自己辯護」，因為他拆毀了巴力的祭壇。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","那時，米甸人、亞瑪力人及東方人會合在一起，過了約旦河，在耶斯列的平原安營。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","耶和華的靈降在基甸身上，他就吹響號角，號召亞比以謝族的人跟從他。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","他派人走遍瑪拿西、亞設、西布倫和拿弗他利各支派召集軍隊，人們紛紛前來會合。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","基甸對上帝說：「若如你所言，你要用我去拯救以色列人， ");
INSERT INTO cmncbt_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","求你給個憑據。我把一團羊毛放在麥場上，若明天早晨只是羊毛上有露水，地面卻是乾的，我就知道，如你所言，你要用我去拯救以色列人。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","果然如此，基甸一早醒來，從羊毛中擠出滿滿一碗露水。 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","基甸又對上帝說：「求你不要發怒，容許我再試一次，這次讓羊毛是乾的，地面有露水。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","那天晚上，上帝就照他所求使地面佈滿露水，唯獨羊毛是乾的。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","耶路·巴力，也就是基甸，清早起來，率領眾人在哈律泉旁紮營，米甸人的軍營在他們北邊靠近摩利山的谷中。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","耶和華對基甸說：「你的人太多了，我不能把米甸人交在你們手中，免得以色列人以為是靠自己的力量救了自己。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","你要向他們宣佈，膽小害怕的人可以離開基列山回家。」結果兩萬二千人離去，只剩下一萬人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","但耶和華對基甸說：「人還是太多，你帶他們到下面的泉水邊，我會在那裡為你挑選人員，我說誰跟你去誰就去，我說誰不能去誰就不要去。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","於是，基甸把他們帶到泉水邊，耶和華對他說：「把像狗一樣用舌頭舔水喝的和跪著喝水的分開。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","那時有三百人捧水舔著喝，其餘的都跪著喝。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","耶和華對基甸說：「我要用這三百舔水喝的人拯救你們，我要把米甸人交在你手中。讓其餘的人都回家吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","於是，基甸留下這三百人，把其餘人的食物和號角收集起來，讓他們回家。米甸人的軍營就在他們下面的山谷裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","當晚，耶和華吩咐基甸說：「起來，下去攻打敵營吧！我已把敵人交在你手中了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","你如果害怕，可以和你的僕人普拉一起下到敵營， ");
INSERT INTO cmncbt_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","聽聽他們說什麼，你就有膽量攻打敵營了。」於是，基甸就帶著僕人普拉下到敵營旁。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","米甸人、亞瑪力人及東方人像蝗蟲一樣佈滿山谷，他們的駱駝如海邊的沙一樣不計其數。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","基甸到了那裡，聽見一個人對同伴說：「我做了個夢，夢見一個大麥餅滾進米甸營中，把一個帳篷撞翻在地。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","他的同伴說：「那不是別的，正是以色列人約阿施的兒子基甸的刀，上帝把米甸人和整個軍營都交在他手中了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","基甸聽了這夢和夢的解釋，就俯伏敬拜上帝。他回到以色列人的營中，大聲喊道：「起來吧，耶和華已經把米甸軍營交在你們手中了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","基甸把三百人分成三隊，分給他們號角和藏有火把的瓦瓶， ");
INSERT INTO cmncbt_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","對他們說：「你們要看我的行動，當我們走到敵營旁邊時，我怎麼做，你們也要怎麼做。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","我們這隊吹響號角時，你們也要在敵營四周吹響號角，高喊，『為了耶和華！為了基甸！』」 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","午夜初，守衛剛換班，基甸帶著一百人來到米甸營旁。他們吹響號角，打破手中的瓦瓶。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","其餘的二百人也吹響號角，打破瓦瓶。他們左手舉著火把，右手拿著號角，高喊：「為耶和華和基甸而戰！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","他們在敵營周圍各守其位，米甸全軍邊喊邊逃。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","基甸的三百人一起吹響號角時，耶和華使米甸人自相殘殺。他們逃往西利拉的伯·哈示他，一直逃到靠近他巴的亞伯·米何拉的邊境。 ");
INSERT INTO cmncbt_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","基甸號召拿弗他利、亞設和瑪拿西的以色列人追殺米甸敗軍， ");
INSERT INTO cmncbt_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","又派人到整個以法蓮山區，吩咐當地人攻打米甸人，佔據遠至伯·巴拉一帶的約旦河渡口。以法蓮人都遵命而行， ");
INSERT INTO cmncbt_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","還生擒了米甸人的兩名首領俄立和西伊伯。他們在俄立磐石上殺死了俄立，在西伊伯榨酒池殺了西伊伯。他們繼續追殺米甸人，並帶著俄立和西伊伯的人頭穿過約旦河，交給基甸。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","後來，以法蓮人對基甸說：「你攻打米甸人時為什麼不召我們去？你為什麼這樣對待我們？」他們與他激烈地爭論起來。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","基甸說：「我怎能比得上你們呢？以法蓮人摘剩的葡萄豈不比我們亞比以謝族收穫的葡萄更好嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","上帝把兩名米甸人的首領俄立和西伊伯交在了你們手中，我所做的怎能跟你們相比呢？」基甸這麼一說，他們的怒氣就平息了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","基甸率領他的三百人渡過約旦河，雖然疲憊不堪，仍緊追敵人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","基甸對疏割的人說：「我們在追趕西巴和撒慕拿兩個米甸王，十分疲憊，請給我的軍隊一些餅吃。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","疏割的首領卻說：「你還沒有抓到西巴和撒慕拿，我們憑什麼給你的軍隊餅吃？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","基甸說：「好吧，耶和華把西巴和撒慕拿交在我們手中後，我必回來用荒野的荊棘抽打你們。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","基甸又去毗努伊勒提出同樣的請求，他們的答復跟疏割人一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","基甸對那裡的人說：「我平安歸來時，必拆毀你們的這座城樓。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","那時，西巴和撒慕拿率領東方各族的殘餘軍隊一萬五千人駐紮在加各，因為已經有十二萬刀兵被殺。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","基甸取道挪巴和約比哈東邊遊牧者走的路，出其不意地突襲米甸人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","米甸二王西巴和撒慕拿逃跑，基甸追上去擒住他們，擊潰他們全軍。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","約阿施的兒子基甸從戰場返回，經過希列斯山坡時， ");
INSERT INTO cmncbt_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","抓住一個疏割的青年，問他疏割的首領和長老是誰，他就寫下疏割七十七位首領和長老的名字。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","基甸到了疏割，對那裡的人說：「你們曾經譏笑我說，『你還沒有抓到西巴和撒慕拿，我們憑什麼給你疲憊的軍隊餅吃？』看！西巴和撒慕拿在這裡！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","說完，就捉住城中的長老，用荒野的荊棘抽打他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","他又去拆毀毗努伊勒的城樓，殺了城裡的人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","基甸問西巴和撒慕拿：「你們在他泊山殺的人是什麼樣子？」他們回答說：「他們長得像你，都像王子一樣。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","基甸說：「他們是我同母所生的兄弟，我憑永活的耶和華起誓，如果你們當初不殺他們，今天我就不殺你們了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","於是，基甸對長子益帖說：「你殺死他們。」但益帖年紀小，心中害怕，不敢動手。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","西巴和撒慕拿對基甸說：「你親自動手吧！這是男子漢做的事。」基甸便親手殺了他們，拿走了他們駱駝頸上的月牙飾物。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","以色列人對基甸說：「你從米甸人手中救了我們，請你和你的子孫統治我們。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","基甸回答說：「我和我子孫都不統治你們，統治你們的是耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","他又說道：「我有一個要求，請你們把搶來的耳環都給我。」原來米甸人屬於以實瑪利族，都戴金耳環。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","他們欣然同意，便鋪開一件外衣，各自把搶來的金耳環都放在上面， ");
INSERT INTO cmncbt_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","重約二十公斤。此外，還有米甸王的月牙飾物、耳墜、紫袍以及駱駝頸上的金鏈。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","基甸用這些金子造了一件以弗得聖衣，放在自己的家鄉俄弗拉。後來，以色列人拜那件以弗得，玷污自己，使基甸及其全家陷入網羅。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","這樣，米甸人被以色列人征服了，從此一蹶不振。基甸在世之日，以色列境內安享太平四十年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","約阿施的兒子耶路·巴力返回家鄉居住。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","他有許多妻子，生了七十個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","他的妾住在示劍，也給他生了一個兒子，他給孩子取名叫亞比米勒。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","約阿施的兒子基甸年高壽終，葬在亞比以謝族的俄弗拉，在他父親約阿施的墳墓裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","基甸剛去世，以色列人便又與巴力苟合，奉巴力·比利土為他們的神明， ");
INSERT INTO cmncbt_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","忘記了他們的上帝耶和華曾經從四圍的仇敵手中拯救他們， ");
INSERT INTO cmncbt_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","也沒有因耶路·巴力，就是基甸的功績而厚待他的家人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","耶路·巴力的兒子亞比米勒去示劍的舅舅家，對外祖父全家說： ");
INSERT INTO cmncbt_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","「請你們去問示劍人，耶路·巴力的七十個兒子統治他們好呢，還是一個人統治他們好呢？別忘記我是你們的骨肉至親。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","他們便將他的話轉告示劍人。示劍人因為亞比米勒是他們的親戚，都擁護他， ");
INSERT INTO cmncbt_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","從巴力·比利土的廟裡拿了七十塊銀子給他。他用這些錢收買了一班無賴做隨從。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","他前往俄弗拉，來到他父親家，在一塊磐石上殺死了他七十個同父異母的兄弟，只有耶路·巴力的小兒子約坦躲了起來，倖免於難。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","示劍和米羅的人都聚集到示劍石柱旁的橡樹下，擁立亞比米勒為王。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","約坦聽見這消息，便上到基利心山頂，高喊：「示劍人啊，你們要聽我說，這樣上帝也會聽你們說。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","從前，樹木要選一個王，它們對橄欖樹說，『你來做我們的王。』 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","橄欖樹說，『我怎能因為貪圖淩駕於眾樹之上而停止出產用來尊崇神明與人的橄欖油呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","樹木對無花果樹說，『你來做我們的王。』 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","無花果樹說，『我怎能因為貪圖淩駕於眾樹之上而停止出產甜美的果子呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","於是，樹木對葡萄樹說，『你來做我們的王。』 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","葡萄樹說，『我怎能因為貪圖淩駕於眾樹之上而停止出產令神明和世人都快樂的美酒呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","最後，所有的樹木都對荊棘說，『你來做我們的王。』 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","荊棘回答說，『你們如果誠心立我為你們的王，就投靠在我的蔭下吧；不然，願火從荊棘中冒出來吞噬黎巴嫩的香柏樹。』 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","「現在你們立亞比米勒為王，光明正大嗎？你們有沒有善待耶路·巴力和他一家？有沒有按他的功績對待他？ ");
INSERT INTO cmncbt_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","你們想想，從前我父親為你們出生入死，從米甸人手中拯救你們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","現在你們卻背叛我父親家，在一塊磐石上殺死他七十個兒子。因為他婢女的兒子亞比米勒是你們的親戚，你們就立亞比米勒為示劍居民的王。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","如果你們光明正大地對待了耶路·巴力一家，願你們給亞比米勒帶來快樂，也願亞比米勒給你們帶來快樂。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","否則，願亞比米勒燒滅你們示劍人和米羅人，也願你們示劍人和米羅人燒滅亞比米勒。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","約坦因懼怕他的兄弟亞比米勒，就逃往比珥居住。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","亞比米勒治理以色列三年後， ");
INSERT INTO cmncbt_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","上帝派遣一個邪靈挑起亞比米勒和示劍人之間的爭端，示劍人用詭詐的手段對待亞比米勒。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","這是要懲罰亞比米勒和幫他殘殺耶路·巴力七十個兒子的示劍人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","示劍人在山頂設下埋伏，等候亞比米勒，他們搶劫所有過路的行人。有人把這事告訴了亞比米勒。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","以別的兒子迦勒和他的弟兄來到示劍，示劍人都信任他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","示劍人出城到田間採摘葡萄，踩榨葡萄汁，然後在他們的神廟中歡宴，盡情吃喝，咒詛亞比米勒。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","以別的兒子迦勒說：「亞比米勒是誰？我們示劍人是誰，竟要服侍他？他不就是耶路·巴力的兒子嗎？他的幫手不就是西布勒嗎？我們為什麼要服侍他？你們要服侍示劍人祖先哈抹的後代。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","要是這百姓歸我領導就好了！我會除掉亞比米勒，我會挑戰他召集全軍來戰。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","示劍城的官長西布勒聽見以別的兒子迦勒的話，勃然大怒， ");
INSERT INTO cmncbt_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","暗中派人對亞比米勒說：「以別的兒子迦勒和他的弟兄已經到了示劍，正在煽動全城反對你。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","請你晚上帶著部下埋伏在田間， ");
INSERT INTO cmncbt_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","清晨日出時攻城。迦勒帶著部下出來應戰時，你便可以見機行事。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","於是，亞比米勒帶領軍隊夜間出發，兵分四路埋伏在示劍城外。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","早晨，以別的兒子迦勒出來站在城門口時，亞比米勒帶領部下從埋伏的地方衝了出來。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","迦勒看見他們，便對西布勒說：「看！有人正從山頂下來。」西布勒說：「你把山影看成人了吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","迦勒說：「看！有人正從山上下來，還有一隊人正從占卜橡樹那邊的路上奔來。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","西布勒說：「你的豪氣哪裡去了？你曾說，『亞比米勒是誰，我們竟要服侍他？』這些不就是你譏笑的人嗎？出去迎戰吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","於是，迦勒率領示劍人出城迎戰亞比米勒。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","迦勒敗逃，亞比米勒緊追不捨，沿途有許多人受傷倒在地上，一直到城門口。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","之後，亞比米勒住在亞魯瑪，西布勒把迦勒和他的弟兄逐出示劍。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","第二天，示劍人出城來到田間。亞比米勒得知後， ");
INSERT INTO cmncbt_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","把部下兵分三隊，埋伏在田間，等城裡的人出來時，伏擊他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","亞比米勒率領一隊人衝到示劍的城門口，截斷示劍人的退路，其他兩隊擊殺田間的示劍人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","亞比米勒鏖戰一天，攻陷了示劍城，殺了城內的居民，把整座城夷為平地，還撒上了鹽。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","示劍樓的人聽到風聲，躲進了伊勒·比利土神廟的內堂。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","亞比米勒得知他們都聚在那裡後， ");
INSERT INTO cmncbt_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","便領兵上撒們山用斧頭砍下樹枝，扛在肩上，並命令部下趕緊照做。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","他們都砍下樹枝，跟著亞比米勒把樹枝堆在神廟內堂的四周，放火燒死了示劍樓裡所有的人，男女約一千人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","隨後，亞比米勒去圍攻提備斯，佔領了該城。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","全城的人連男帶女都逃進城中一座堅固的城樓內，鎖上大門，爬上樓頂。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","亞比米勒攻打城樓，走到城樓門口正準備放火時， ");
INSERT INTO cmncbt_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","有個婦人扔下一塊磨石，砸爛了他的頭。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","亞比米勒連忙對為他拿兵器的年輕人說：「拔刀殺了我吧，免得人們說，『一位婦人殺了他。』」於是，那年輕人刺死了他。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","以色列人見亞比米勒已死，便各自回家了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","上帝就這樣使亞比米勒得到了報應，因為他殘殺了自己的七十個兄弟， ");
INSERT INTO cmncbt_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","上帝也讓示劍人因自己的一切惡行而得到了報應。耶路·巴力的兒子約坦的咒詛臨到了他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","亞比米勒死後，以薩迦人陀拉拯救了以色列人。他住在以法蓮山區的沙密，祖父是朵多，父親是普瓦。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","陀拉做以色列的士師二十三年，死後葬在沙密。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","之後，基列人雅珥做以色列的士師二十二年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","他有三十個兒子，每人騎一頭驢。他們在基列擁有三十座城，那些城到現在還叫「雅珥之城」。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","雅珥死後，葬在加們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","後來，以色列人又做耶和華視為惡的事，祭拜巴力和亞斯她錄，又拜亞蘭、西頓、摩押、亞捫和非利士的神明。他們背棄耶和華，不再事奉祂。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","耶和華向他們發怒，把他們交在非利士人和亞捫人手中。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","那年，非利士人和亞捫人擊垮了以色列人，壓迫基列地區、約旦河東亞摩利境內的以色列人達十八年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","亞捫人還渡過約旦河攻擊猶大、便雅憫和以法蓮支派，使以色列人苦不堪言。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","於是，他們呼求耶和華說：「我們背棄我們的上帝去祭拜巴力，我們得罪了你。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","耶和華對他們說：「你們受埃及人、亞摩利人、亞捫人、非利士人、 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","西頓人、亞瑪力人和馬雲人的壓迫，就呼求我，我豈沒有拯救你們嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","但你們竟背棄我，去事奉其他神明，所以我不再救你們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","你們去呼求自己選擇的神明吧！你們有難，讓他們救你們吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","他們對耶和華說：「我們犯了罪，任你處置我們，只求你今天拯救我們。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","以色列人除掉了他們的外邦神像，轉而事奉耶和華。耶和華不忍再看以色列人受苦。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","當時，亞捫人整裝備戰，在基列安營；以色列人也集合起來，在米斯巴安營。 ");
INSERT INTO cmncbt_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","基列的首領們彼此商議說：「誰先攻打亞捫人，誰就做所有基列人的首領。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","基列人耶弗他是個英勇的戰士，他父親名叫基列，母親是個妓女。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","基列的妻子還生了幾個兒子，他們長大後，便把耶弗他趕出家門，說：「你是別的女人生的，你休想繼承我們父親的任何產業。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","耶弗他只好逃走，住在陀伯地區。有一群匪徒聚集到他身邊，跟隨了他。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","後來，亞捫人攻打以色列， ");
INSERT INTO cmncbt_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","基列的眾長老就去陀伯請耶弗他， ");
INSERT INTO cmncbt_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","對他說：「請你回來做統帥帶領我們對抗亞捫人。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","耶弗他說：「從前你們不是厭惡我，把我從父親家趕走的嗎？現在你們遭難，為什麼來找我？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","基列的眾長老說：「我們現在是來請你跟我們一起回去抵抗亞捫人，你可以做所有基列人的首領。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","耶弗他說：「如果你們請我回去與亞捫人作戰，耶和華讓我打敗他們，我就真的可以做你們的首領嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","基列的首領們說：「我們必聽從你的吩咐，有耶和華為我們作證。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","於是，耶弗他便跟他們一起回去。民眾擁立他做他們的首領和元帥。耶弗他在米斯巴將之前所說的話在耶和華面前重申一遍。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","然後，他派遣使者去問亞捫王：「你與我有什麼相干？為什麼要攻打我的領土？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","亞捫王對他的使者說：「因為以色列人從埃及出來的時候佔據了我們的土地，從亞嫩河到雅博河，一直到約旦河。現在你們要和平地歸還我們。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","耶弗他再差遣使者去見亞捫王， ");
INSERT INTO cmncbt_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","對他說：「以色列人並沒有佔據摩押和亞捫的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","當年以色列人離開埃及，經曠野渡過紅海來到加低斯， ");
INSERT INTO cmncbt_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","然後派遣使者去見以東王，說，『求你讓我們經過你的領土。』以東王卻不答應。他們又派遣使者去見摩押王，摩押王也不答應。於是，以色列人就住在加低斯。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","後來，他們走過曠野，繞過以東和摩押，到了摩押的東邊，在摩押的邊界亞嫩河東岸紮營，並沒有進入摩押境內。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","以色列人派遣使者去見希實本的亞摩利王西宏，對他說，『求讓我們經過你的領土前往我們自己的土地。』 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","但西宏不信任以色列人，拒絕了他們的請求，並招聚全軍駐紮在雅雜，攻打他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","但以色列的上帝耶和華幫助以色列人戰勝西宏和他的軍隊，佔領了亞摩利人所有的土地， ");
INSERT INTO cmncbt_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","從亞嫩河直到雅博河，從曠野直到約旦河。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","既然是以色列的上帝耶和華為祂的以色列子民趕走了亞摩利人，你憑什麼要奪取這塊土地？ ");
INSERT INTO cmncbt_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","你擁有你們的神明基抹給你們的土地，我們也要擁有我們的上帝耶和華賜給我們的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","難道你比摩押王西撥的兒子巴勒更強嗎？他從未挑戰過以色列人，也未和以色列人交過戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","三百年來，以色列人一直住在希實本及其周圍的鄉村、亞羅珥及其周圍的鄉村和亞嫩河沿岸一帶的城邑。在這期間，你們為什麼不收回這些土地呢？ ");
INSERT INTO cmncbt_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","我們沒有得罪你們，你們卻攻打我們。願審判者耶和華今天在以色列人和亞捫人之間主持公道。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","可是，亞捫王不理會耶弗他派使者所傳的話。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","那時，耶和華的靈降在耶弗他身上，他便經過基列和瑪拿西，來到基列的米斯巴，然後從那裡去迎戰亞捫人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","他向耶和華許願說：「如果你把亞捫人交在我手中， ");
INSERT INTO cmncbt_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","讓我平安歸來，第一個從我家門出來迎接我的人必歸給你，我必把他獻給你作燔祭。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","於是，耶弗他率軍與亞捫人作戰，耶和華把敵人交在他手中， ");
INSERT INTO cmncbt_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","他大敗敵軍，摧毀了從亞羅珥到米匿、遠至亞備勒·基拉明的二十座城。這樣，以色列人征服了亞捫人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","耶弗他返回自己在米斯巴的家，他的獨生女兒敲著鼓、跳著舞出來迎接他。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","他一見自己的女兒，便撕裂衣服，說：「唉，我的女兒啊，你真讓我傷心欲絕，禍患臨頭！我向耶和華許了願，不能收回了！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","他女兒說：「父親啊，你既然向耶和華許了願，就照你許的願對待我吧！因為耶和華幫你打敗了敵軍亞捫人，為你報了仇。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","但求你先給我兩個月的時間，讓我和同伴到山上去為我終身未嫁哀哭。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","耶弗他答應了，給了她兩個月的時間。於是，她便和同伴到山上為自己終身未嫁哀哭。 ");
INSERT INTO cmncbt_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","兩個月後，她回到父親那裡。她父親履行了自己所許的願。她從未與男人同房。自此以後，在以色列有個習俗： ");
INSERT INTO cmncbt_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","每年以色列的女子都去為基列人耶弗他的女兒哀哭四天。 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","後來，以法蓮人召集軍隊，渡過約旦河來到撒分。他們對耶弗他說：「你為什麼不召我們一起去攻打亞捫人呢？我們要把你和你的房子一起燒掉。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","耶弗他說：「我和我的人民與亞捫人激戰時，我曾召你們參戰，你們卻不肯來援救我們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","我見你們不來援救，只好冒死去迎戰亞捫人，耶和華把敵人交在了我手中。你們今天為什麼來攻打我呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","以法蓮人說：「你們這些在以法蓮和瑪拿西境內的基列人不過是以法蓮的逃兵。」於是，耶弗他號召基列人起來迎戰以法蓮人，打敗了他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","基列人佔據約旦河各渡口，不讓以法蓮人過去。如果有以法蓮的逃兵請求過河，基列人便問他：「你是以法蓮人嗎？」如果他否認， ");
INSERT INTO cmncbt_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","他們就讓他說「示播列」。以法蓮人因為咬字不清，會把「示播列」說成「西播列」，基列人便抓住他，在約旦河渡口處死他。那時，有四萬二千名以法蓮人被殺。 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","基列人耶弗他做以色列的士師六年，死後葬在基列的一座城裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","耶弗他死後，伯利恆人以比贊做以色列的士師。 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","他有三十個兒子、三十個女兒，他從別的宗族給兒子們娶來三十個媳婦，又把女兒都嫁到別的宗族。他做以色列的士師七年， ");
INSERT INTO cmncbt_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","死後葬在伯利恆。 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","以比贊死後，西布倫人以倫做以色列的士師十年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","他死後葬在西布倫的亞雅崙。 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","以倫死後，比拉頓人希列的兒子押頓做以色列的士師。 ");
INSERT INTO cmncbt_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","他有四十個兒子、三十個孫子，他的兒孫每人騎一頭驢。押頓做以色列的士師八年， ");
INSERT INTO cmncbt_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","他死後葬在以法蓮的比拉頓，在亞瑪力人的山區。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","以色列人又做耶和華視為惡的事，耶和華就把他們交在非利士人手中四十年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","瑣拉城住了一個但支派的人，名叫瑪挪亞。他妻子不能生育，沒有孩子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","耶和華的天使向那婦人顯現，對她說：「你雖然不生育，但不久你必懷孕生一個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","現在，你要留心，不可喝淡酒和烈酒，不可吃任何不潔之物。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","你必懷孕生一個兒子，你不可為他剃頭，因為他一出生就要歸給上帝做拿細耳人。他要從非利士人手中拯救以色列人。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","婦人就去對丈夫說：「有一位上帝的僕人向我顯現，他的容貌像上帝的天使，非常可畏。我沒有問他從哪裡來，他也沒有把名字告訴我。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","他對我說，『你必懷孕生一個兒子，現在不可喝淡酒和烈酒，不可吃任何不潔之物，因為孩子一出生就要獻給耶和華，終生做拿細耳人。』」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","瑪挪亞向耶和華祈求說：「主啊，求你再派你的僕人到這裡來，教我們怎樣照顧要出生的孩子。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","上帝應允了他的祈求。他妻子正坐在田間的時候，上帝的天使再次向她顯現。當時她丈夫瑪挪亞不在場。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","她趕忙跑去告訴她丈夫說：「那天來的那人又向我顯現了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","瑪挪亞起來跟隨妻子來到那人面前，問他：「跟我妻子說話的就是你嗎？」他答道：「是我。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","瑪挪亞問道：「你的話應驗以後，我們應該怎樣撫養這孩子？他該做什麼？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","耶和華的天使說：「你的妻子必須謹記我的一切吩咐。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","她不可吃葡萄樹所結的果實，淡酒和烈酒都不可喝，不可吃任何不潔之物。她必須遵行我的一切吩咐。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","瑪挪亞說：「請你留下來，我們要預備一隻山羊羔給你吃。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","當時，瑪挪亞仍然不知道那人是耶和華的天使。天使說：「我就是留下來也不會吃你預備的食物。你如果預備燔祭，就把它獻給耶和華吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","瑪挪亞說：「請告訴我你的名字，當一切應驗的時候，我們好向你表達敬意。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","耶和華的天使說：「何必問我的名字呢？我的名字奇妙難測。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","於是，瑪挪亞就把一隻山羊羔和素祭放在磐石上，獻給耶和華。就在這時候，天使在瑪挪亞夫婦面前行了一件奇妙的事： ");
INSERT INTO cmncbt_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","火焰從祭壇上升起的時候，耶和華的天使也在祭壇的火焰中升上去了。瑪挪亞夫婦見狀便俯伏在地。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","耶和華的天使後來沒再向瑪挪亞夫婦子顯現，瑪挪亞才知道他是耶和華的天使。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","瑪挪亞對妻子說：「我們必死無疑，因為我們看見了上帝。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","他妻子卻說：「耶和華如果要殺我們，就不會接受我們的燔祭和素祭了，也不會讓我們看見這些事，更不會這時候跟我們說這些話。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","後來瑪挪亞的妻子生了個兒子，她給孩子取名叫參孫。這孩子漸漸長大，耶和華賜福給他。 ");
INSERT INTO cmncbt_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","當他在瑣拉和以實陶之間的瑪哈尼·但的時候，耶和華的靈開始感動他。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","參孫下到亭拿，在那裡看中了一個非利士女子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","他回到家裡便對父母說：「我在亭拿看中一個非利士女子，把她給我娶來做妻子吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","他父母說：「難道我們的親族和同胞中沒有合適的女子嗎？你為什麼要娶未受割禮的非利士人的女子呢？」參孫卻說：「我很喜歡她，請給我把她娶過來吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","他的父母不知道這事是出於耶和華的旨意，祂要找機會對付非利士人。那時，非利士人統治著以色列。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","參孫跟父母一起去亭拿，走到亭拿的葡萄園時，有一頭猛獅吼叫著撲向他。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","耶和華的靈突然降在參孫身上，他雖然手無寸鐵，竟撕裂了那頭獅子，就像撕裂一隻山羊羔一樣。他沒有把這事告訴父母。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","到了亭拿，參孫跟那女子交談，很喜歡她。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","過了些日子，參孫下去迎娶她，途中他順便去看那隻死獅子，見死獅子體內有一群蜜蜂和一些蜂蜜， ");
INSERT INTO cmncbt_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","就用手取了一些蜜，邊走邊吃。到了父母那裡，他給了他們一些，他們也吃了。但他沒有告訴父母蜂蜜是從死獅子體內取的。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","參孫的父親去那女子家，參孫按習俗擺設宴席。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","眾人看見參孫，就安排了三十個人陪他。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","參孫對他們說：「我出一個謎語，如果你們可以在這七天的婚宴期間猜出來，我就送你們三十件細麻衣和三十件外袍。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","如果猜不中，你們就要給我三十件細麻衣和三十件外袍。」他們說：「請你出謎語吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","參孫說： 「食物出自食者， 甜物出自強者。」 三天過後，他們仍然猜不出來。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","到了第四天，他們對參孫的妻子說：「你要哄你的丈夫把謎底說出來，不然我們就把你和你父親一家全燒死。你們邀請我們來，難道是要奪取我們的家產嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","於是，參孫的妻子向他哭訴說：「你是恨我，不是愛我。你給我的族人出了謎語，卻沒有告訴我謎底。」參孫回答說：「我連父母都沒有告訴，又怎能告訴你呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","在七天的婚宴期間，她一直在丈夫跟前哭哭啼啼。到了第七天，參孫經不住妻子的催逼就把謎底告訴了她。她把謎底告訴了她的族人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","在第七天日落之前，城裡的人對參孫說： 「有什麼比蜂蜜更甜？ 有什麼比獅子更強？」 參孫說： 「你們若不是利用我的小母牛耕田， 肯定猜不出來。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","耶和華的靈突然降在參孫身上，他便去亞實基倫殺了三十個人，取走他們的衣服，交給猜中謎語的那些人，然後怒氣沖沖地回父親家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","參孫的妻子後來歸了他的伴郎。 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","過了些日子，在割麥的時候，參孫帶著一隻山羊羔去探望他妻子。他說：「我要進內室見我妻子。」他岳父卻不讓他進去， ");
INSERT INTO cmncbt_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","並對他說：「我以為你非常恨她，所以我把她改嫁給你的伴郎了。她妹子不是比她更美嗎？你可以娶來代替她。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","參孫說：「這次我要加害非利士人，可不能怪我了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","於是，他出去捉了三百隻狐狸，把牠們的尾巴一對一對綁起來，將火把綁在兩條尾巴中間， ");
INSERT INTO cmncbt_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","然後點燃火把，把狐狸放進非利士人的麥田裡，將割好的麥捆和未割的麥子、葡萄園和橄欖園都燒毀了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","非利士人問：「這是誰幹的？」有人回答說：「是亭拿人的女婿參孫幹的，因為他岳父把他的妻子嫁給了他的伴郎。」非利士人就去放火燒死了參孫的妻子和岳父。 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","參孫說：「你們既然這樣做，我不向你們報仇誓不甘休。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","參孫大肆擊殺他們，殺死了很多人。事後，他下到以坦，住在那裡的巖洞裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","非利士人進犯猶大，在利希一帶紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","猶大人問他們：「你們為什麼來攻打我們？」非利士人回答說：「我們來捉拿參孫，向他以報還報。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","於是，有三千猶大人去以坦的巖洞找參孫，對他說：「難道你不知道非利士人是我們的統治者嗎？你為什麼連累我們？」參孫回答說：「我只是以牙還牙。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","猶大人說：「我們來是要捉拿你，把你交給非利士人。」參孫說：「你們要起誓不會親手殺我。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","他們說：「我們不會殺你，只將你綁起來交給非利士人。」於是，他們用兩根新繩子把參孫捆綁起來帶出巖洞。 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","參孫來到利希，非利士人就吶喊著迎了上去。耶和華的靈突然降在參孫身上，綁在他手臂上的繩子就像被火燒的麻線一樣脫落下來。 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","他看到一塊還沒有乾的驢腮骨，就撿起來用它殺了一千個非利士人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","參孫說： 「用這驢腮骨，我殺人成堆； 用這驢腮骨，我殺死千人。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","說完，他扔掉了手中的驢腮骨。因此，那地方叫拉末·利希。 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","參孫覺得非常口渴，便向耶和華呼求說：「你既然藉著僕人的手大敗敵人，難道你會讓我渴死、落在這些未受割禮的人手中嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","於是，上帝使利希的一處窪地裂開，湧出水來。參孫喝後恢復了精神。因此，那水泉叫隱·哈歌利。那水泉今天還在利希。 ");
INSERT INTO cmncbt_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","在非利士人統治期間，參孫做以色列的士師二十年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","一天，參孫去迦薩，看見一個妓女，就與她親近。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","迦薩人得知參孫來了，便包圍那地方，整夜埋伏在城門口，沒有動手，心想：「等天一亮，我們就殺掉他。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","可是，參孫睡到半夜就起來，把城門的門扇連門框和門閂一同拆下，扛到希伯崙對面的山頂上。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","後來，參孫在梭烈谷愛上一位名叫大利拉的女子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","非利士人的首領就上去見這女子，對她說：「請你哄參孫說出他為何有這麼大力氣，我們怎樣才能制伏他，把他綁起來。事後，我們每人會給你一千一百塊銀子。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","於是，大利拉問參孫：「求你告訴我，你為什麼有這麼大力氣？用什麼辦法才能把你綁起來制伏你？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","參孫說：「如果他們用七根還沒乾的青繩子綁住我，我就會像普通人一樣軟弱。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","非利士人的首領便把七根還沒乾的青繩子交給大利拉，她用那些繩子把參孫綁起來。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","有人已預先埋伏在她的內室，於是她喊道：「參孫，非利士人來捉你了！」但參孫掙斷了繩子，就像掙斷火燒過的麻線一樣。因此，仍然沒有人知道他為何力氣過人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","大利拉對參孫說：「你說謊捉弄我。現在請你告訴我，用什麼方法才能綁住你？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","參孫回答說：「如果他們用從未用過的新繩子綁住我，我就會像普通人一樣軟弱。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","於是，大利拉讓人埋伏在內室，她用七根新繩子綁住參孫，然後喊道：「參孫，非利士人來捉你了！」結果，參孫掙斷了手臂上的繩子，就像掙斷一根線一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","大利拉對參孫說：「到現在你還是說謊捉弄我。請你告訴我，用什麼方法才能綁住你？」參孫說：「你把我的七根髮辮和織布機的線編在一起，用梭子扎緊，我就會像普通人一樣軟弱。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","於是，大利拉把他的髮辮和織布機的線編在一起，用梭子扎緊，然後喊道：「參孫，非利士人來捉你了！」參孫醒來，掙脫了織布機的梭子和線。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","大利拉對參孫說：「你既然不跟我說真心話，還說什麼愛我！你捉弄了我三次，沒告訴我你為何力氣過人。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","大利拉天天在他跟前嘮叨不停，以致他煩得要死， ");
INSERT INTO cmncbt_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","就把秘密告訴了她。他說：「我從不剃髮，因為我一出生就獻給上帝做拿細耳人了。如果剃掉我的頭髮，我就會失去力氣，像普通人一樣軟弱。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","大利拉見他說出了心中的秘密，就派人去通知非利士人的首領，說：「你們再來一次吧，他已經把秘密告訴我了。」於是，他們帶著銀子去了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","大利拉哄參孫枕著她的腿睡覺，然後叫人來剃掉他的七根髮辮，使他力氣盡失，無力反抗。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","她喊道：「參孫，非利士人來捉你了！」參孫醒來，心想：「我要像前幾次一樣掙脫捆綁。」他卻不知道耶和華已經離開他了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","非利士人拿住他，剜了他的眼睛，把他帶到迦薩，用銅鏈鎖住他，讓他在監牢裡推磨。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","後來，他的頭髮又漸漸長出來了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","非利士人的首領聚在一起向他們的神明大袞獻大祭，歡呼說：「我們的神把仇敵參孫交在我們手中了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","眾人看見參孫，就讚美他們的神明，說：「我們的神把仇敵交在我們手中了，他曾毀壞我們的田地，殺死我們許多人。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","他們都興高采烈，並喊道：「把參孫帶來讓我們消遣消遣。」於是，有人把參孫從監牢裡提出來供他們消遣，他們讓他站在兩根柱子中間。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","參孫對拉著他手的童僕說：「帶我到支撐這廟宇的柱子那裡，我想靠一靠。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","那時，廟裡擠滿了男男女女，非利士人的首領們都在場，房頂上還有三千男女看參孫的熱鬧。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","參孫呼求耶和華，說：「主耶和華啊，求你眷顧我！上帝啊，求你再賜給我一次力量，使我向非利士人報剜眼之仇。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","參孫就抱住廟宇中央的兩根柱子，一手抱一根， ");
INSERT INTO cmncbt_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","然後喊道：「我要跟非利士人同歸於盡！」於是，他用盡全力推柱子，廟宇倒塌，壓住裡面的首領和民眾。參孫死時殺的人比他活著時殺的還多。 ");
INSERT INTO cmncbt_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","參孫的兄弟和家人取走他的屍體，葬在瑣拉和以實陶之間他父親瑪挪亞的墓地裡。參孫做以色列的士師二十年。 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","以法蓮山區住了一個名叫米迦的人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","他對母親說：「你那一千一百塊銀子被拿走了，你因此說了咒詛的話，我都聽見了。看啊，銀子在我這裡，是我拿去的。」他母親說：「我兒啊，願耶和華賜福給你！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","米迦把一千一百塊銀子還給母親。他母親說：「我要為我兒把這些銀子獻給耶和華，用來雕刻、鑄造神像。我會把銀子交還給你。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","米迦把銀子還給母親後，他母親拿出二百塊銀子交給銀匠雕刻、鑄造神像，放在米迦的房子裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","米迦有一個神廟，他製造了一件以弗得和一些家庭神像，並指派他的一個兒子做祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","那時，以色列沒有王，人人各行其是。 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","猶大的伯利恆住著一個年輕的利未人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","他離開伯利恆想到別的地方居住，一路走到以法蓮山區米迦的家。 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","米迦問他：「你從哪裡來？」他回答說：「我是從猶大的伯利恆來的利未人，要找一個住的地方。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","米迦說：「你就住在我這裡吧，做我的師父和祭司。我每年給你十塊銀子，還為你提供衣服和飲食。」利未人就進了米迦的家， ");
INSERT INTO cmncbt_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","住了下來。米迦待他就像待自己的兒子一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","這樣，米迦派他做祭司，讓他住在自己家裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","米迦說：「現在我有一個利未人做我的祭司，我知道耶和華一定會恩待我。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","那時以色列沒有王。但支派的人正在尋找可以居住的地方，因為他們在以色列各支派中還沒有得到屬於自己的土地。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","但支派的人從瑣拉和以實陶派本族的五名勇士去打探、察看那個地方，並吩咐說：「你們去察看那個地方。」他們到了以法蓮山區，在米迦家裡借宿。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","他們到了米迦家，聽出那利未青年的口音，就轉身進去問他：「誰帶你來這裡的？你在這裡做什麼？你為什麼在這裡？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","那青年便把米迦聘他做祭司的事告訴了他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","他們說：「請你求問上帝，看看我們是否一路順利。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","祭司說：「你們安心去吧，耶和華會一路眷顧你們。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","五人啟程來到拉億，發現當地人像西頓人一樣無憂無慮，生活安寧，毫無防範，繁榮富足。他們離西頓很遠，與外界沒有來往。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","五人回到瑣拉和以實陶後，族人問他們：「你們有什麼發現嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","他們回答說：「我們前去攻取那地方吧！我們已經打探清楚了，那地方非常好。你們還等什麼？要趕快去佔領那地方。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","你們到了那裡，會看見當地的居民毫無防範，那裡地大物博，一無所缺。上帝已經把那地方賜給我們了。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","但支派便從瑣拉和以實陶派出六百個帶兵器的人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","他們來到猶大的基列·耶琳的西邊安營。因此，那地方至今仍叫瑪哈尼·但。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","然後，他們去以法蓮山區，來到米迦的家。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","偵察過拉億的五個人對其餘的人說：「你們知道嗎？這家有以弗得、一些家庭神像、一個雕刻的偶像和一個金屬鑄像。想一想我們該怎麼辦。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","那五個人就進入米迦的家裡，到年輕的利未人房間向他問安， ");
INSERT INTO cmncbt_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","隨行的六百人帶著兵器留在門口。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","當時祭司也和那六百個帶兵器的人站在門口。那五個人進去拿走了雕刻的偶像、以弗得、家庭神像及金屬鑄像。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","祭司見那五人進入米迦家拿走雕刻的偶像、以弗得、家庭神像及金屬鑄像，就問他們：「你們在做什麼？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","他們說：「安靜，別作聲，跟我們來，做我們的師父和祭司吧。做以色列一個支派、一個宗族的祭司難道不比做一家人的祭司更好嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","祭司聽了非常高興，就帶著以弗得、家庭神像及雕刻的偶像跟隨了他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","他們轉身離去，兒女、牲畜和財物在隊伍前面。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","他們離開米迦的家一段路後，米迦召集鄰居趕了上來， ");
INSERT INTO cmncbt_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","向他們大喊。但支派的人轉身問米迦：「你們召集這麼多人來做什麼？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","米迦說：「你們帶走了我的神像和祭司，把我洗劫一空，還問我想做什麼！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","但支派的人說：「別再多說了，不然我們當中性情暴躁的人會攻擊你們，使你全家喪命。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","但支派的人繼續趕路。米迦見對方人多勢眾，就回家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","但支派的人帶著米迦的神像和他的祭司來到拉億，那裡的人生活安寧，毫無防範。他們用刀殺掉當地的居民，放火燒了城。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","拉億離西頓很遠，當地的居民與外界沒有來往，以致孤立無援。這城位於伯·利合附近的山谷中，但支派的人重建該城，住在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","這座城原來叫拉億，他們用祖先以色列的兒子但的名字為該城重新命名。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","但支派的人把神像豎立起來，又指派摩西的孫子、革舜的兒子約拿單及其子孫做但支派的祭司，直到該地遭受擄掠為止。 ");
INSERT INTO cmncbt_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","上帝的會幕設立在示羅期間，米迦的神像一直豎立在但。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","那時候，以色列沒有王。有一個利未人住在以法蓮山區的偏遠地帶，他娶了猶大的伯利恆的一個女子為妾。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","那女子不忠，離開丈夫回到猶大的伯利恆的父親家，住了四個月。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","後來，她丈夫帶著一個僕人和兩頭驢去見她，用好話勸她回去。那女子帶他去見自己的父親。她父親看見女婿來了，便熱情地接待他， ");
INSERT INTO cmncbt_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","留他在家裡小住。他便在那裡住了三天，一起吃住。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","第四天，他清早起來準備回家，岳父對他說：「吃點東西補充體力後再走吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","於是，二人坐下來一起吃喝。岳父對他說：「再住一夜，高興高興吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","他不肯答應，起來要走，但岳父一再挽留，他就又住了一夜。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","第五天清早起來，他準備回家，岳父對他說：「吃點東西補充體力，太陽偏西再走吧。」於是，二人一同吃飯。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","他帶著妾和僕人起來要走的時候，岳父對他說：「看啊，太陽偏西了，天色已晚，再住一夜高興高興，明天一早再走吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","可是，他不願意再留一夜，就備好兩頭驢，帶著他的妾走了，來到耶布斯附近。耶布斯就是耶路撒冷。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","他們臨近耶布斯時，天快黑了，僕人對主人說：「我們不如就在耶布斯人的城裡住宿吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","主人說：「我們不可在非以色列人的外邦城邑住宿，不如趕到基比亞。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","他又說：「我們前往基比亞或拉瑪住宿吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","於是，他們繼續前行，到便雅憫境內的基比亞時，天已經黑了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","他們決定在那裡過夜。因為沒有人接待他們，他們只好在城中的廣場露宿。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","那時，有一個老人從田間工作回來，經過那裡。他本來是以法蓮山區的人，現在住在便雅憫境內的基比亞。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","他看見有人在城中的廣場露宿，就問：「你們從哪裡來，要到哪裡去？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","利未人回答說：「我們從猶大的伯利恆來，正要回家去。我住在以法蓮山區的偏遠地帶。我現在要去耶和華的殿。這裡沒有人接待我。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","其實我有糧草餵驢，我和我的妾及僕人也有餅和酒，什麼也不缺。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","那老人說：「歡迎到我家來，我會供應你們的需要，千萬不可在街頭露宿。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","於是，那老人帶他們回家，餵他們的驢。他們洗完腳後，便一起吃喝。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","他們正歡樂的時候，城裡的一群無賴前來圍住房子，連連叩門，對年長的家主說：「把你家裡的客人交出來，我們要跟他交合。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","老人出去對他們說：「弟兄們啊，不要做這種惡事！這人是我的客人，不要幹這種卑鄙的事！ ");
INSERT INTO cmncbt_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","我有個女兒，仍是處女，還有這人的妾，我把她們交出來，任你們玩弄，只是不要對這人幹這種卑鄙的事。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","他們卻不肯聽。利未人就把自己的妾推出去交給他們。他們強暴她，終夜凌辱她，直到天快亮才放她走。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","天亮時她回到丈夫住宿的房子門前，就仆倒在地。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","早晨，她丈夫起來打開房門要上路，發現她倒臥在門前，雙手搭在門檻上， ");
INSERT INTO cmncbt_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","就對她說：「起來，我們走吧！」她卻沒有反應。於是，他就把她的屍體放在驢背上啟程回家。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","回到家裡，他用刀把屍體切成十二塊，派人送往以色列全境。 ");
INSERT INTO cmncbt_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","看見的人都說：「自從以色列人離開埃及以來，這種事從未發生過，也從未見過。我們必須商量一下，看看該怎麼辦。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","於是，從但到別示巴以及基列的全體以色列人齊心來到米斯巴，聚集在耶和華面前。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","以色列各支派的首領都參加了這次上帝子民的聚會，當時有四十萬持刀的步兵。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","便雅憫人也聽見以色列人聚集在米斯巴的消息。以色列人問那個利未人：「請告訴我們，這件邪惡的事是怎麼發生的？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","那利未人，就是被害女子的丈夫說：「我和我的妾到便雅憫的基比亞住宿。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","那天晚上，基比亞人攻擊我，包圍我們住宿的房子，要殺死我。他們把我的妾蹂躪致死。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","我就把她的屍體切成塊，送到以色列的各個地區，因為基比亞人做了邪惡、無恥的事。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","以色列人啊，你們看該怎麼處理吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","眾人起來異口同聲地說：「我們誰也不回帳篷，誰也不回家。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","現在我們要抽籤去攻打基比亞。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","我們要從各支派中抽出十分之一的人負責運糧，等軍隊到達便雅憫的基比亞後，就可以討伐在以色列做出這種卑鄙之事的基比亞人。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","於是，以色列人團結一致，一起去攻打那城。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","以色列各支派差人去對便雅憫各地的人說：「你們中間怎麼發生了這種邪惡的事！ ");
INSERT INTO cmncbt_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","現在把那些基比亞的無賴交出來，我們要處死他們，從以色列剷除罪惡。」便雅憫人卻充耳不聞， ");
INSERT INTO cmncbt_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","還從各城聚集到基比亞，要跟以色列人打仗。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","便雅憫人從各城召集了兩萬六千刀兵，還從基比亞召集了七百精兵。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","軍中有七百精兵善用左手甩石，毫髮不差。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","其他十一個以色列支派則召集了四十萬刀兵，個個善戰。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","以色列人到伯特利去求問上帝，說：「我們當中哪個支派應當先去攻打便雅憫人呢？」耶和華說：「猶大支派。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","第二天清早，以色列人起來在基比亞附近安營， ");
INSERT INTO cmncbt_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","朝著便雅憫人擺開陣勢，準備攻打他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","便雅憫人從基比亞出來，當天殺了以色列軍兩萬二千人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","以色列人重整士氣，仍在前一天列陣的地方列陣。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","列陣之前，他們在耶和華面前一直哀哭到晚上。他們求問耶和華，說：「我們應該再上去攻打我們的同胞便雅憫人嗎？」耶和華說：「要上去攻打他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","第二天，以色列人前去攻打便雅憫人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","便雅憫人從基比亞出來迎戰，又殺了以色列軍一萬八千刀兵。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","以色列全軍來到伯特利，坐在耶和華面前哀哭，那天他們一直禁食到晚上，又在耶和華面前獻上燔祭和平安祭。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","28","那時，上帝的約櫃就在那裡，亞倫的孫子、以利亞撒的兒子非尼哈任祭司。以色列人求問耶和華，說：「我們應該再去攻打我們的同胞便雅憫人嗎？還是退兵？」耶和華說：「去攻打吧，因為明天我必把他們交在你們手中。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","以色列人在基比亞周圍設下伏兵。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","第三天，以色列人又像前兩次一樣在基比亞列陣，攻打便雅憫人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","便雅憫人前來迎戰，被以色列人誘到城外。他們又像前兩次一樣擊殺以色列人，大約三十名以色列人死在通往基比亞和伯特利的兩條路上。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","便雅憫人說：「我們又像以前一樣打敗他們了。」但以色列人已經商議好，用詐敗的方法誘敵離城到大路上來。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","以色列全軍在巴力·他瑪列陣反攻，埋伏在基比亞西面的以色列人也衝了出來。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","有一萬以色列精兵從正面攻打基比亞，戰事非常激烈。便雅憫人大禍臨頭了仍懵然不知。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","耶和華幫助以色列人戰勝了便雅憫人。那天，以色列人殺了便雅憫兩萬五千一百刀兵。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","便雅憫人這才意識到自己戰敗了。 原來以色列人在便雅憫人面前詐敗，因為他們仰仗在基比亞附近設下的伏兵。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","那些伏兵迅速衝進基比亞，用刀殺了全城的人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","以色列人和伏兵已有約定，伏兵在城內點起一股濃煙時， ");
INSERT INTO cmncbt_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","以色列人便轉身殺回。便雅憫人殺了詐敗的以色列軍大約三十人，以為像以前一樣打敗了他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","這時基比亞城已濃煙滾滾，便雅憫人回頭觀望，只見全城濃煙四起。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","以色列人轉身殺了回來，便雅憫人大驚失色，知道大禍臨頭了。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","他們從以色列人面前轉身逃往曠野，卻無法逃脫。以色列人從各城出來夾攻他們。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","以色列人圍攻便雅憫人，一路追殺他們直到基比亞的東邊。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","便雅憫人共死了一萬八千名勇士。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","餘下的人都逃往曠野的臨門巖，沿途有五千人被殺。以色列人追殺他們，一直追到基頓，又消滅了他們兩千人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","那天，便雅憫人共死了兩萬五千名英勇的刀兵， ");
INSERT INTO cmncbt_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","只有六百人逃到了臨門巖，在那裡住了四個月。 ");
INSERT INTO cmncbt_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","以色列人回師便雅憫境內，用刀將各城的男女老少以及牲畜全部殺死，又放火燒毀所有的城邑。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","以色列人曾在米斯巴起誓不把女兒嫁給便雅憫人。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","他們來到伯特利，坐在上帝面前放聲痛哭，直到黃昏。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","他們說：「以色列的上帝耶和華啊，以色列現今為何少了一個支派呢？為何發生了這樣的事呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","第二天，眾人清早起來在那裡築了一座祭壇，獻上燔祭和平安祭。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","他們彼此議論說：「我們到米斯巴聚集在耶和華面前的時候，各支派中誰沒有來呢？」原來，他們曾經起誓說：凡不到米斯巴聚集在耶和華面前的人都要被處死。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","以色列人為他們的同胞便雅憫人難過，說：「如今以色列絕了一個支派。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","我們曾經在耶和華面前起誓，決不把女兒嫁給便雅憫人，現在我們應該怎麼辦，才能使他們剩下來的人得到妻子呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","他們又查問各支派中誰沒有到米斯巴聚集在耶和華面前，結果發現基列·雅比人缺席， ");
INSERT INTO cmncbt_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","因為點兵的時候，沒有一個基列·雅比人在場。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","於是，會眾派出一萬二千精兵，命令他們用刀殺掉基列·雅比人及其婦女和孩子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","他們對精兵說：「你們所要做的就是消滅所有的男子和已婚婦女。」 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","他們在基列·雅比的居民中找到四百名處女，把她們帶回迦南的示羅營地。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","全體會眾又派人到臨門巖去跟便雅憫人講和。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","於是，便雅憫人返回了家鄉，以色列人把從基列·雅比居民中留下來的四百個處女給他們做妻子，但還是不夠。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","眾人為便雅憫支派難過，因為耶和華使以色列少了一個支派。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","會眾的長老說：「便雅憫支派的女子都死了，我們應該怎麼辦才能使餘下的人有妻子呢？ ");
INSERT INTO cmncbt_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","便雅憫的餘民必須成家立後，以免以色列失去一個支派。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","可是我們又不能把女兒嫁給他們，因為我們曾經起誓，『把女兒嫁給便雅憫人的必受咒詛。』」 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","有人想起在示羅每年都有耶和華的節期。示羅在利波拿以南、伯特利以北至示劍的大路東面。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","於是，他們對便雅憫人說：「你們去埋伏在葡萄園裡， ");
INSERT INTO cmncbt_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","見到示羅的女子出來跳舞時，就衝出去各自搶一個，帶回便雅憫做妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","倘若她們的父親或弟兄前來抱怨，我們會說，『求你們看在我們的情面上恩待他們，因為我們從戰場上帶回的女子不夠分給他們做妻子。何況又不是你們把女兒嫁給他們的，所以罪不在你們。』」 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","便雅憫人就依計行事，從跳舞的女子中各自搶了一個，帶回自己的家鄉做妻子。他們重建城邑，住在其中。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","於是，以色列人離開那裡，各回自己的支派、宗族和家園。 ");
INSERT INTO cmncbt_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","那時，以色列沒有王，人人各行其是。");
INSERT INTO cmncbt_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","在士師執政的時代，猶大發生了饑荒。有一個人帶著妻子和兩個兒子從猶大的伯利恆遷到摩押境內寄居。 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","這個人名叫以利米勒，妻子叫拿俄米，兩個兒子分別叫瑪倫和基連。他們都是猶大 伯利恆的以法他人。他們來到摩押，就在那裡住了下來。 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","後來，拿俄米的丈夫以利米勒去世了，留下她和兩個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","這兩個兒子都娶了摩押的女子為妻，一個名叫俄珥巴，一個名叫路得。在那裡住了大約十年後， ");
INSERT INTO cmncbt_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","瑪倫和基連二人都去世了，只剩下拿俄米，沒有了丈夫，也沒有了兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","後來，拿俄米在摩押聽說耶和華眷顧祂的子民，使他們五穀豐登，就帶著兩個兒媳婦準備回故鄉。 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","她們離開所居住的地方，動身返回猶大。 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","拿俄米對兩個兒媳婦說：「你們還是各回娘家去吧！願耶和華恩待你們，就好像你們恩待死去的丈夫和我一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","願耶和華使你們都有機會再嫁，找到好歸宿。」拿俄米說完了，就親吻她們。她們都放聲大哭， ");
INSERT INTO cmncbt_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","說：「不！我們要跟你一起回你的家鄉。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","拿俄米說：「我的女兒啊，回娘家去吧！為什麼要跟我去呢？難道我還能生兒子做你們的丈夫嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","回去吧！我的女兒啊，走吧！我已經老了，不可能再嫁人了。就算我還有指望，今晚能再結婚生子， ");
INSERT INTO cmncbt_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","難道你們能一直不嫁，等到他們長大嗎？不要這樣，我的女兒啊！這樣你們會很苦，我就更苦了，因為耶和華伸手懲罰我。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","她們又放聲大哭，俄珥巴就親吻婆婆，向她道別，但路得卻依依不捨，不肯離去。 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","拿俄米說：「你看，你嫂嫂已經回她家鄉和她拜的神明那裡去了，你也跟著嫂嫂回去吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","路得說：「不要逼我撇你而去。你往哪裡去，我也要往哪裡去；你住在哪裡，我也要住在哪裡；你的同胞就是我的同胞，你的上帝就是我的上帝； ");
INSERT INTO cmncbt_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","你死在哪裡，我也死在哪裡、葬在哪裡。只有死才能把我們分開。否則，願耶和華重重地懲罰我！」 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","拿俄米見路得堅決要跟她走，就不再勸阻她了。 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","於是，二人便一同回到伯利恆。她們進了伯利恆，全城轟動。婦女們問：「這不是拿俄米嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","拿俄米對她們說：「不要再叫我拿俄米了，叫我瑪拉吧！因為全能者叫我過得好苦啊！ ");
INSERT INTO cmncbt_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","我曾滿滿地離開這裡，現在耶和華卻使我空空地回來。既然耶和華叫我受苦，全能者使我遭難，為何還叫我拿俄米呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","拿俄米帶著她的兒媳婦摩押女子路得從摩押回到了伯利恆，那時正是開始收割大麥的季節。 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","拿俄米的丈夫以利米勒有個親戚，名叫波阿斯，是個有名望的財主。 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","摩押女子路得對拿俄米說：「讓我到田裡去，跟在那些願意恩待我的人後面，撿些麥穗回來。」拿俄米說：「去吧，我的女兒！」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","於是，路得便去了。她恰巧來到以利米勒的親戚波阿斯的田裡，跟在收割的人後面撿麥穗。 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","當時，波阿斯剛好從伯利恆來到田間，向那些收割的工人問安說：「願耶和華與你們同在。」他們回答說：「願耶和華賜福給你。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","波阿斯問負責收割的工頭說：「那是誰家的女子？」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","工頭回答說：「她是摩押女子，跟拿俄米剛從摩押回來。 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","她求我讓她跟在收割的人後面，撿工人紮捆時遺落的麥穗。她一大早就來到這裡，一直撿到現在，除了在涼棚裡稍微坐了一會兒之外，幾乎沒有休息。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","波阿斯對路得說：「姑娘，聽我說，你不用到別人的田裡去拾麥穗了，也不必離開這裡，只管留下來跟我的女工在一起。 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","你看我的工人在哪一塊田裡收割，就跟著我的女工去，我已經吩咐工人不可欺負你。要是你渴了，就去水罐那裡喝工人打回來的水。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","路得就俯伏在地叩謝他，說：「我不過是個外族人，你為什麼這樣恩待我、體恤我？」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","波阿斯說：「自從你丈夫過世之後，你怎樣善待婆婆，怎樣離開父母和家鄉來到素不相識的人當中，我都聽說了。 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","願耶和華照你所行的獎賞你！你來投靠在以色列的上帝耶和華的翅膀下，願祂厚厚地賞賜你。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","路得說：「我主啊！我真是在你面前蒙恩，雖然我連你的婢女都不如，你還好言安慰我。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","吃飯的時候，波阿斯對路得說：「來，吃一點餅吧，可以蘸著醋吃。」路得便坐在那些收割工人旁邊。波阿斯遞給她一些烤好的麥穗。她吃飽了，還有剩餘的。 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","當她起來又要去撿麥穗的時候，波阿斯就吩咐他的工人說：「你們要任由她撿，就算她從麥捆中撿麥穗，你們也不要為難她。 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","甚至要從麥捆中抽一些出來讓她撿，不要責罵她。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","於是，路得便在田間繼續撿麥穗，到了黃昏，她把撿到的麥穗打了，大約有十公斤大麥。 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","她把撿來的麥子帶回城裡給婆婆拿俄米看，又把剩下來的食物給婆婆。 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","婆婆問她：「你今天在哪裡拾麥穗？在哪裡做工？願那善待你的人蒙福！」她就告訴婆婆說：「今天我在一個名叫波阿斯的人那裡工作。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","拿俄米說：「願耶和華賜福給他，他對活著的和過世的都是那麼有情有義。」拿俄米又對路得說：「這人是我們的近親，有為我們贖業的責任。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","摩押女子路得說：「他還對我說，『你可以跟在我的工人後面撿麥穗，直到他們把我的莊稼都收完為止。』」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","拿俄米對兒媳路得說：「我的女兒啊，你就跟他的女工一起到田裡去，免得去別人的田裡被欺負。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","因此，路得便常跟波阿斯的女工在一起撿麥穗，直到大麥小麥都收割完畢。路得就這樣陪伴婆婆過日子。 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","一天，路得的婆婆拿俄米對她說：「我的女兒啊，我實在應該為你找個好歸宿，使你生活幸福。 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","波阿斯不是我們的親戚嗎？而且你又常與他的女工在一起。今晚他會在麥場簸大麥。 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","你要梳洗打扮、抹上香膏、換件衣服，然後去麥場，但不要讓他認出你是誰。等他吃飽喝足， ");
INSERT INTO cmncbt_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","躺下睡覺的時候，你看準他躺臥的地方，去掀開蓋在他腳上的被，躺在那裡，到時他必定會告訴你該怎樣做。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","路得說：「好，我一定照你的吩咐去做。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","於是，路得就到麥場去，照她婆婆吩咐的去做。 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","波阿斯吃過晚飯，心裡舒暢，便躺在麥堆旁邊睡著了。路得悄悄過去掀起蓋在他腳上的被，躺在他腳旁。 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","到了半夜，波阿斯忽然驚醒，翻過身來，發現一個女子躺在他的腳旁， ");
INSERT INTO cmncbt_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","便問道：「你是誰？」她答道：「我是你的婢女路得，請用你的衣襟遮蓋我，因為你是我的近親。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","波阿斯說：「姑娘，願耶和華賜福給你，因為你一直對婆家情深義重，現在更是如此。你本來可以找一個富有或貧窮的年輕丈夫，然而你卻沒有這樣做。 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","姑娘，不要害怕，你所說的一切，我都會去為你安排，城裡所有的人都知道你是個賢德的女子。 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","不錯，我是你的近親，可是有一個人比我更近。 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","你今晚就留在這裡，明天早上，如果他答應盡親屬的義務，就由他照顧你；如果他不肯，我憑永活的耶和華起誓，我會盡我的本分。現在你只管安心睡到天亮。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","路得就躺在波阿斯的腳旁。天未亮，還看不清人的時候，路得就起來了。因為波阿斯曾對她說：「不可讓別人知道有女人來過麥場。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","離開的時候，波阿斯對她說：「把你的外衣拿來鋪開。」路得就照做了。他用路得的外衣包了六簸箕大麥，幫她扛在肩上，她便回城了。 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","回到家中，婆婆問她：「女兒啊，怎麼樣了？」路得便將事情的經過都告訴了婆婆。 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","她又說：「那個人給了我六簸箕大麥，對我說，『不要空手回去見你婆婆。』」 ");
INSERT INTO cmncbt_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","拿俄米說：「女兒啊！你只管安靜等候，看這事怎樣發展，因為那人今天不把事情辦妥，是絕不會休息的。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","波阿斯來到城門口，坐在那裡，恰巧看見他所說的那位至親經過，便招呼他說：「某人啊，請過來坐一坐。」那人便走過來坐下。 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","波阿斯又邀請了城裡的十位長老，對他們說：「請過來坐一坐。」他們都坐下以後， ");
INSERT INTO cmncbt_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","波阿斯便對那位至親說：「拿俄米從摩押回來了，現在要賣我們族兄以利米勒的那塊地， ");
INSERT INTO cmncbt_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","我想應該讓你知道這件事。你最有權贖那塊地，其次才是我，此外再沒有別人了。如果你願意贖回那塊地，請你當著在座各位長老的面表明。如果不願意，請你讓我知道。」那人說：「我願意贖。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","波阿斯說：「那麼，你從拿俄米手中買地的那天，也要娶已死之人的妻子摩押女子路得，好讓死者繼續在產業上留名。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","那位至親說：「那我就不能贖了，免得損害到我的產業。你來贖吧，我不能贖。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","從前在以色列，買贖或交易有這樣的規矩：一旦成交，一方要把鞋脫下來交給另一方，以色列人以此為成交的憑據。 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","那位至親對波阿斯說：「你自己買吧！」他就把鞋脫了下來。 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","波阿斯向長老和所有在場的人說：「請各位今天為我作證，所有屬於以利米勒、基連和瑪倫的產業，我都從拿俄米手上買了。 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","同時，我要娶瑪倫的遺孀摩押女子路得為妻，好使死者繼續在產業上留名，免得他的名在本族本鄉中消失。今天，請各位作證。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","聚集在城門口的眾人和長老都說：「我們願意作證。願耶和華使要進你家門的這女子，像建立以色列家的拉結和利亞一樣。願你在以法他家業興隆，在伯利恆聲名遠揚。 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","願耶和華藉著這年輕女子賜你後裔，使你家像先祖猶大和她瑪的兒子法勒斯家一樣。」 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","這樣，波阿斯便娶了路得為妻，與她同房。耶和華使她懷孕生了一個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","婦女們對拿俄米說：「耶和華當受稱頌！因為今日祂賜給你一位至親，使你後繼有人，願這孩子在以色列得享盛名！ ");
INSERT INTO cmncbt_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","他必讓你的生命重新得力，奉養你，使你安度晚年，因為他是愛你的兒媳婦所生的。有這兒媳婦比有七個兒子還要好！」 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","拿俄米接過嬰孩抱在懷中，照顧他。 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","鄰居的婦女們說：「拿俄米有孩子了！」她們給孩子取名叫俄備得，這俄備得就是耶西的父親，耶西是大衛的父親。 ");
INSERT INTO cmncbt_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","以下是法勒斯的家譜：法勒斯生希斯崙， ");
INSERT INTO cmncbt_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","希斯崙生蘭，蘭生亞米拿達， ");
INSERT INTO cmncbt_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","亞米拿達生拿順，拿順生撒門， ");
INSERT INTO cmncbt_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","撒門生波阿斯，波阿斯生俄備得， ");
INSERT INTO cmncbt_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","俄備得生耶西，耶西生大衛。");
INSERT INTO cmncbt_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","有一個以法蓮人名叫以利加拿，住在以法蓮山區的拉瑪·瑣非城。他是蘇弗的玄孫、托戶的曾孫、以利戶的孫子、耶羅罕的兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","他有兩個妻子，一個叫哈娜，一個叫毗尼娜。毗尼娜有兒有女，哈娜卻無兒無女。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","以利加拿每年都從家鄉到示羅去敬拜萬軍之耶和華，獻上祭物。當時以利的兩個兒子何弗尼和非尼哈在那裡做耶和華的祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","每逢獻祭的日子，以利加拿就會把祭肉分給毗尼娜和她的兒女。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","但他會給哈娜雙份祭肉，因為他愛哈娜，雖然耶和華使她不能生育。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","毗尼娜見耶和華使她不能生育，便常常刺激她、氣她。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","年復一年都是這樣。每年來到耶和華的殿時，毗尼娜總是惹她傷心哭泣，以致她吃不下飯。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","她的丈夫以利加拿對她說：「哈娜，你為什麼哭？為什麼不吃飯？為什麼心裡難過？有我不是比有十個兒子更好嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","一天，他們在示羅吃完飯後，哈娜站起來。當時，祭司以利正坐在耶和華殿門口的座位上。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","哈娜心中愁苦，一邊向耶和華禱告一邊傷心地哭泣。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","她向上帝許願說：「萬軍之耶和華啊，如果你眷顧婢女的痛苦，不忘記婢女，賜給婢女一個兒子，我必讓他終生事奉你，永不剃他的頭。」 ");
INSERT INTO cmncbt_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","哈娜在耶和華面前不住地禱告，以利注視著她的嘴唇。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","哈娜在心中默禱，只動嘴唇，不出聲音，以利以為她喝醉了， ");
INSERT INTO cmncbt_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","便對她說：「你要醉到什麼時候呢？醒醒酒吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","哈娜答道：「我主啊，我沒有喝醉，我淡酒和烈酒都沒有喝。我是心裡非常愁苦，在耶和華面前傾訴心事。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","請不要以為我是墮落的女人，我充滿悲傷和痛苦，所以一直在禱告。」 ");
INSERT INTO cmncbt_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","以利說：「你安心地回去吧，願以色列的上帝答應你的祈求。」 ");
INSERT INTO cmncbt_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","哈娜說：「願婢女在你面前蒙恩。」於是，她就去吃飯，不再愁容滿面了。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","第二天，以利加拿一家清早起來敬拜耶和華，然後回到自己的家鄉拉瑪。以利加拿與哈娜同房，耶和華顧念哈娜， ");
INSERT INTO cmncbt_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","使她懷孕。她後來生了一個兒子，給孩子取名叫撒母耳，因為她說：「他是我向耶和華求來的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","第二年，以利加拿帶全家人前往示羅，向耶和華獻年祭並還所許的願。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","哈娜沒有跟他們同去，她告訴丈夫說：「孩子斷奶以後，我會把他帶去獻給耶和華，讓他永遠住在那裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","以利加拿說：「就依你的意思吧。可以等孩子斷了奶再去。願耶和華成就祂的應許。」於是，她就留在家中哺養孩子，直到孩子斷奶。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","孩子斷奶以後，她就把年幼的孩子帶到示羅耶和華的殿，並帶去三頭公牛、十公斤麵粉和一袋酒。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","他們宰了一頭公牛後，就把孩子帶到以利面前。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","哈娜說：「我主啊，我敢在你面前起誓，我就是那一次站在你這裡向耶和華祈求的婦人。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","我求耶和華賜給我這個孩子，祂應允了我的祈求。 ");
INSERT INTO cmncbt_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","現在，我將他獻給耶和華，讓他終身事奉耶和華。」 他便在那裡敬拜耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","哈娜禱告說： 「我的心因耶和華而歡喜， 我的角因耶和華而高舉， 我的口向敵人誇耀， 我因耶和華的拯救而快樂。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","「耶和華聖潔無比， 獨一無二， 沒有磐石像我們的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","不要再驕橫傲慢、口出狂言， 因為耶和華是無所不知的上帝， 祂衡量人的一切行為。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","勇士的弓被折斷， 軟弱的卻有力量。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","素來豐衣足食的為糊口而當雇工， 本來食不果腹的卻不再挨餓。 不育的婦人現在生了七個孩子， 兒女成群的婦人卻孤獨憔悴。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","耶和華掌管生死， 祂使人下到陰間，也使人起死回生。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","貧窮富足在於祂， 卑微高貴也在於祂。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","祂從灰塵中提拔窮苦的人， 從糞堆裡提升貧賤的人， 使他們與王子同坐， 得享尊榮。 大地的根基屬於耶和華， 祂在上面建立了世界。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","祂看顧祂聖民的腳步， 使惡人在黑暗中滅亡， 因為得勝不是靠人的勇力。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","跟耶和華對抗的人必被擊潰， 祂必從天上用雷擊打他。 祂必審判天下， 賜力量給祂所立的君王， 使受膏者的角高舉。」 ");
INSERT INTO cmncbt_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","以利加拿返回了拉瑪，小撒母耳卻留在了示羅，在祭司以利的帶領下事奉耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","以利的兩個兒子為人邪惡，不認識耶和華， ");
INSERT INTO cmncbt_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","對民眾不守自己做祭司的職分。每當民眾來獻祭，還在煮祭肉的時候，他們的僕人便拿著三齒叉來， ");
INSERT INTO cmncbt_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","從罐裡、鼎裡、釜裡或鍋裡插肉，把插上來的祭肉據為己有。他們這樣對待所有到示羅來的以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","甚至在焚燒脂肪之前，祭司的僕人就來對獻祭的人說：「把肉給祭司烤吧！他不要煮過的，只要生的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","如果獻祭的人答道：「要先焚燒脂肪，之後你可以隨便拿，」僕人便會說：「不，你現在就給我，不然我就要搶了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","在耶和華的眼中，這兩個青年罪惡深重，因為他們輕視獻給耶和華的祭物。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","那時年少的撒母耳穿著細麻布的以弗得，在耶和華面前事奉。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","他母親每年都為他縫一件小外衣，在她和丈夫來獻年祭時帶給他。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","以利祝福以利加拿和他妻子，對他說：「願耶和華讓你妻子再給你生兒育女，代替她求來並獻給耶和華的孩子。」他們就回家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","耶和華眷顧哈娜，她又生了三個兒子和兩個女兒。年少的撒母耳在耶和華面前漸漸長大。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","以利年事已高，他聽說兩個兒子對待以色列人的惡行，以及他們與在會幕門口服侍的婦女行淫的事後， ");
INSERT INTO cmncbt_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","就對他們說：「你們為什麼做這樣的事？我從百姓口中聽說了有關你們的惡行。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","我兒啊，不可這樣，我聽到在耶和華的子民中流傳著你們的壞名聲。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","人若得罪了別人，有上帝為他調解。但人若得罪了耶和華，誰能為他求情呢？」然而，他們不肯聽從父親的話，因為耶和華決意要殺他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","小撒母耳漸漸長大，日益受到耶和華和民眾的喜愛。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","有一個上帝的僕人來見以利，對他說：「耶和華說，『你的祖先在埃及被法老奴役的時候，我向他們顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","我在以色列各支派中選出你的祖先做我的祭司，在我的祭壇上獻祭燒香，穿著以弗得事奉我。我把以色列人獻的所有火祭都賜給你祖先家。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","你們為什麼蔑視獻給我的祭物和供物？你為什麼把你的兒子看得比我還重要，拿我以色列子民所獻的上好祭物來養肥自己？』 ");
INSERT INTO cmncbt_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","「所以，以色列的上帝耶和華宣告說，『我曾經應許讓你家族永遠做我的祭司。』但現在耶和華宣佈，『這絕不可能了。尊重我的，我必尊重他；藐視我的，必遭藐視。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","看啊，時候將到，我要切斷你和你家族的力量，你家族必沒有一個老人。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","你在困苦中必以羨慕的眼光看著我賜福以色列人，你家中卻永遠沒有一個老人。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","我不會把你家中的人從我壇前滅絕，但留下來的人必使你哭瞎雙眼、傷心欲絕。你的子孫必盛年早逝。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","你的兩個兒子何弗尼和非尼哈必死在同一天，這就是我言出必行的記號。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","我要為自己立一位忠心的祭司，他必照我的心意行事。我要使他的家族堅立，他必永遠服侍我膏立的王。 ");
INSERT INTO cmncbt_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","那時，你家存留下來的人要在他面前下拜，乞討銀子和餅，並懇求說，請給我一個祭司的職位以便糊口！』」 ");
INSERT INTO cmncbt_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","小撒母耳跟著以利事奉耶和華。那時候，耶和華的話語稀少，異象也不多。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","一天晚上，老眼昏花的以利正睡在自己的房裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","上帝的燈還沒有熄滅，撒母耳睡在耶和華的殿內，那裡有上帝的約櫃。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","耶和華呼喚撒母耳，撒母耳答道：「我在這裡！」 ");
INSERT INTO cmncbt_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","他跑到以利跟前，說：「我來了，你叫我嗎？」以利說：「我沒有叫你，你去睡吧。」於是，他就回去睡覺。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","耶和華又呼喚撒母耳，撒母耳起來到以利跟前，說：「我來了，你叫我嗎？」以利答道：「孩子，我沒有叫你，回去睡吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","那時，撒母耳還不認識耶和華，耶和華的話還沒有向他顯明。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","耶和華第三次呼喚他，撒母耳起來，到以利面前，說：「我來了，你叫我嗎？」這時候，以利才明白原來是耶和華在呼喚這孩子。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","他就吩咐撒母耳說：「你回去睡吧，要是再呼喚你，你就說，『耶和華啊，請吩咐，僕人恭聽。』」於是，撒母耳就回去睡下。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","耶和華來站在那裡，再次像剛才一樣呼喚：「撒母耳！撒母耳！」撒母耳答道：「請吩咐，僕人恭聽。」 ");
INSERT INTO cmncbt_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","耶和華對撒母耳說：「我要在以色列做一件令人震驚的事。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","到時候，我要應驗我說的有關以利家的一切預言。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","我對以利說過我要永遠懲罰他家，因為他知道自己的兒子褻瀆我，卻沒有約束他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","所以，我向以利家起誓說，『靠祭物或禮物絕不能贖去以利家的罪惡。』」 ");
INSERT INTO cmncbt_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","撒母耳在床上躺到天亮，然後起來打開耶和華的殿門。他不敢把異象告訴以利。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","以利叫他：「撒母耳，我的孩子。」撒母耳答道：「我在這裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","以利說：「耶和華對你說了什麼？你不要向我隱瞞。如果你隱瞞一句，願上帝重重地懲罰你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","撒母耳就一五一十地告訴了他。以利說：「祂是耶和華，祂看怎樣好，就怎樣行吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","撒母耳漸漸長大，耶和華與他同在，使他所說的話沒有一句落空。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","從但到別示巴，全以色列的人都知道撒母耳被立為耶和華的先知。 ");
INSERT INTO cmncbt_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","耶和華繼續在示羅顯現，用自己的話啟示撒母耳。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","撒母耳把耶和華的話傳遍了以色列。 那時，以色列人去迎戰非利士人，他們在以便以謝紮營，非利士人在亞弗紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","非利士人列陣與以色列人交戰，大敗以色列人，殺了他們約四千人。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","軍隊回營後，以色列的長老說：「耶和華今天為什麼使我們敗在非利士人手下？我們從示羅把耶和華的約櫃抬來吧，讓它與我們同去，好從仇敵手中救我們。」 ");
INSERT INTO cmncbt_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","於是，他們派人去示羅，把那坐在基路伯天使上的萬軍之耶和華的約櫃抬來。以利的兩個兒子何弗尼和非尼哈也隨上帝的約櫃同來。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","以色列人看見耶和華的約櫃到了營中，就高聲歡呼，聲音震動大地。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","非利士人聽見了歡呼聲就說：「希伯來人在營中歡呼什麼？」後來他們知道是耶和華的約櫃到了營中， ");
INSERT INTO cmncbt_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","就害怕起來，說：「有神明到了他們營中，我們大禍臨頭了，我們從來沒有遇過這種事情！ ");
INSERT INTO cmncbt_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","我們大禍臨頭了！誰能從這些大能的神明手中救我們？在曠野用各種災禍毀滅埃及人的就是這些神明。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","非利士人啊，要剛強，做大丈夫。不然，我們就會成為希伯來人的奴隸，像他們做我們的奴隸一樣。我們要做大丈夫，奮力征戰。」 ");
INSERT INTO cmncbt_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","非利士人和以色列人交戰，以色列人落敗，紛紛逃回家中。他們傷亡慘重，損失了三萬步兵。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","上帝的約櫃被擄走了，以利的兩個兒子何弗尼和非尼哈被殺身亡。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","當天有一個便雅憫人逃出了戰場，他撕裂衣服，頭蒙灰塵，來到示羅。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","以利正坐在路旁的座位上觀望，因為他心裡為上帝的約櫃擔憂。那個從戰場回來的人進城報信後，全城的人都放聲大哭。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","以利聽見哭喊聲，就問：「人們為何喊叫？」那人趕忙告訴他。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","那時，以利已經九十八歲，眼睛因為年老而失明。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","報信的人對以利說：「我今天是從戰場逃回來的。」以利問：「我的孩子，情況怎麼樣？」 ");
INSERT INTO cmncbt_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","報信的答道：「以色列人被非利士人擊潰，傷亡慘重，你的兩個兒子何弗尼和非尼哈都死了，上帝的約櫃也被擄走了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","以利年老體胖，聽到上帝的約櫃被擄去，就從門邊的座位上向後跌倒，頸斷身亡。他做以色列的士師四十年。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","以利的兒媳婦、非尼哈的妻子當時懷孕在身，接近產期。她聽說上帝的約櫃被擄、公公和丈夫都死了，就突然陣痛，生下了孩子。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","在她彌留之際，身旁的婦人對她說：「不要怕，你生了一個男孩。」但她既不理會，也不回答。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","她給孩子取名叫以迦博，意思是：「榮耀離開以色列了。」這是因為上帝的約櫃被擄走，她的公公和丈夫都死了。 ");
INSERT INTO cmncbt_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","她說：「榮耀離開了以色列，因為上帝的約櫃已經被擄走了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","非利士人將擄來的上帝的約櫃從以便以謝抬到亞實突城， ");
INSERT INTO cmncbt_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","把它抬進大袞廟，放在大袞神像旁邊。 ");
INSERT INTO cmncbt_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","第二天早上，亞實突人起來，發現大袞神像倒在耶和華的約櫃前，面伏於地，他們就把大袞神像扶起來，放回原處。 ");
INSERT INTO cmncbt_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","次日早上起來，他們又發現大袞神像倒在耶和華的約櫃前，面伏於地，頭和雙手都在門檻處折斷了，只剩下軀幹。 ");
INSERT INTO cmncbt_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","因此，大袞的祭司和所有進亞實突的大袞廟的人，至今都不踏廟的門檻。 ");
INSERT INTO cmncbt_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","耶和華出手重重地懲罰亞實突及附近村莊的居民，使他們恐懼，都患上毒瘡。 ");
INSERT INTO cmncbt_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","亞實突人見此情形，就說：「以色列上帝的約櫃不能留在我們這裡，因為上帝重重地懲罰我們和我們的大袞神。」 ");
INSERT INTO cmncbt_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","亞實突人派人召集非利士所有的首領，問他們：「我們如何處理以色列上帝的約櫃？」他們答道：「把它送到迦特去。」於是，眾人把以色列上帝的約櫃送到迦特。 ");
INSERT INTO cmncbt_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","約櫃抵達迦特後，耶和華出手攻擊那城，使那裡的男女老少都患了毒瘡，全城驚恐不已。 ");
INSERT INTO cmncbt_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","於是，他們把約櫃送往以革倫。以革倫人看見上帝的約櫃到了，就驚叫道：「他們把以色列上帝的約櫃帶來，是要害死我們和我們的人民！」 ");
INSERT INTO cmncbt_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","他們派人召集非利士的首領，說：「把以色列上帝的約櫃送回原處吧，免得它殺害我們和我們的人民。」因為上帝重重地懲罰他們，全城都籠罩在死亡的恐懼中。 ");
INSERT INTO cmncbt_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","那些沒有死的人都飽受毒瘡的折磨，城中的哭喊聲上達於天。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","耶和華的約櫃在非利士人的地方停留了七個月。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","非利士人叫來他們的祭司和占卜者，問道：「我們該怎樣處理耶和華的約櫃呢？請告訴我們怎樣把它送回原處？」 ");
INSERT INTO cmncbt_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","他們答道：「你們若把以色列上帝的約櫃送回去，不可空手送去，一定要向祂獻上賠罪的禮物，這樣你們就可以得到醫治，也可以知道祂為什麼懲罰你們。」 ");
INSERT INTO cmncbt_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","非利士人問：「我們該送什麼作賠罪的禮物呢？」他們答道：「你們要按非利士首領的數目，送五個金毒瘡和五隻金鼠，因為你們和你們的首領都遭受了同樣的災難。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","所以，你們要製作金毒瘡和毀壞田地的老鼠的像，尊崇以色列的上帝，也許祂會放過你們、你們的神明及田地。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","你們為什麼像法老和埃及人那樣心裡頑固呢？當上帝嚴厲地對待他們時，他們豈沒有讓以色列人離開埃及嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","現在，你們快去準備一輛新車，把兩頭還在哺養小牛、從未負過軛的母牛套在車上，然後把小牛帶回牛圈裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","你們要把耶和華的約櫃放在車上，旁邊放箱子，裡面裝賠罪的金物，然後送這輛車上路。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","你們要留意觀察，如果車朝以色列邊境的伯·示麥去，這大災難就是耶和華降給我們的。如果不朝那方向走，我們就知道不是祂懲罰我們，是偶然發生的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","於是，非利士人一一照做，他們牽來兩頭還在哺養小牛的母牛，把牠們套在車上，把小牛關在圈裡， ");
INSERT INTO cmncbt_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","然後把耶和華的約櫃和裝金鼠以及金毒瘡的箱子放在車上。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","母牛邊走邊叫，不偏不離，徑直朝伯·示麥走去。非利士的首領跟著牠們一直來到伯·示麥的邊界。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","當時，伯·示麥人正在山谷裡收割麥子。他們抬頭看見約櫃，非常高興。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","車子來到伯·示麥人約書亞的田間，在一塊巨石旁邊停下來。民眾劈開車子，把兩頭母牛獻給耶和華作燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","利未人抬下耶和華的約櫃和裝著金物的箱子，把它們放在巨石上。那天，伯·示麥人向耶和華獻上了燔祭和其他祭物。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","那五個非利士首領看見了這一切後，就在當天回以革倫去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","非利士人獻給耶和華的金毒瘡是分別為亞實突、迦薩、亞實基倫、迦特和以革倫賠罪的。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","那五隻金鼠是按著非利士五個首領的堅固城邑和村莊的數目獻上的。那塊安放耶和華約櫃的巨石至今還在伯·示麥人約書亞的田間。 ");
INSERT INTO cmncbt_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","那一天，耶和華擊殺了七十個伯·示麥人，因為他們擅自觀看約櫃裡面。民眾為此哀慟不已， ");
INSERT INTO cmncbt_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","伯·示麥人說：「誰能站立在這位聖潔的上帝耶和華面前呢？該把約櫃送到誰那裡呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","後來，他們就派使者到基列·耶琳的居民那裡，說：「非利士人已經把耶和華的約櫃送回來了，你們下來把它接到你們那裡吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","基列·耶琳人就下來把耶和華的約櫃抬到山上，放在亞比拿達的家裡，特派他的兒子以利亞撒看守耶和華的約櫃。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","約櫃在基列·耶琳停留了二十年。那時，全體以色列人都痛悔地尋求耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","撒母耳對他們說：「如果你們全心歸向耶和華，就要除掉你們中間那些外族的神明和亞斯她錄神像，一心歸向耶和華，單單事奉祂，祂必從非利士人手中救你們。」 ");
INSERT INTO cmncbt_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","於是，他們除掉了巴力和亞斯她錄神像，單單事奉耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","撒母耳又說：「你們全體以色列人到米斯巴來，我會為你們向耶和華祈求。」 ");
INSERT INTO cmncbt_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","他們就在那裡聚集，打水倒在耶和華面前，並在當天禁食。他們說：「我們得罪了耶和華。」於是，撒母耳在米斯巴做以色列人的士師。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","非利士人聽說以色列人在米斯巴聚集，他們的首領就率領軍隊來攻打以色列人。以色列人聽見消息後，非常害怕。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","他們對撒母耳說：「請你為我們不停地呼求我們的上帝耶和華，求祂從非利士人手中拯救我們。」 ");
INSERT INTO cmncbt_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","撒母耳把一隻還在吃奶的羊羔獻給耶和華作全牲燔祭。他為以色列人呼求耶和華，耶和華垂聽了他的祈求。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","撒母耳正在獻燔祭的時候，非利士人前來攻打以色列人。那天，耶和華向非利士人發出雷霆之聲，使他們陷入恐慌，敗在了以色列人手下。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","以色列人從米斯巴一路追殺他們，直到伯·甲附近。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","撒母耳拿了一塊石頭放在米斯巴和善的中間，稱之為以便以謝，說：「耶和華到如今都幫助我們。」 ");
INSERT INTO cmncbt_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","這樣非利士人被征服了，沒有再侵犯以色列邊境。在撒母耳有生之年，耶和華一直出手對付非利士人。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","以色列人收復了從以革倫到迦特之間被非利士人奪去的城邑，並奪回了這些城邑的周邊地區。那時以色列人與亞摩利人和平共處。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","撒母耳一生做以色列人的士師。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","他每年都到伯特利、吉甲、米斯巴各地巡迴，審理以色列人的案件。 ");
INSERT INTO cmncbt_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","之後，他才回到拉瑪自己的家中，也在那裡審理以色列人的案件，並為耶和華築了一座祭壇。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","撒母耳在年老的時候立了他的兒子做以色列人的士師。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","他的長子是約珥，次子是亞比亞，他們在別示巴做士師。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","然而，他們沒有效法自己的父親，反而愛慕不義之財，貪贓枉法。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","於是，以色列的長老一起到拉瑪去見撒母耳， ");
INSERT INTO cmncbt_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","說：「你年紀大了，你的兒子不效法你。現在求你為我們立一個王治理我們，像其他國家一樣。」 ");
INSERT INTO cmncbt_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","撒母耳聽到他們要求立一個王治理他們，心中不悅，就向耶和華禱告。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","耶和華對撒母耳說：「你照他們所說的去做吧，因為他們不是拒絕你，而是拒絕我做他們的王。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","自從我帶他們出埃及那天一直到今日，他們常常背棄我，去供奉其他神明。現在，他們也這樣對待你。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","你就照他們所求的去做吧！但你要嚴厲地警告他們，讓他們知道將來王會怎樣管轄他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","撒母耳就把耶和華的話轉告給那些請求他立王的民眾，說： ");
INSERT INTO cmncbt_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","「將來管轄你們的王會徵用你們的兒子做他的戰車兵、騎兵，要他們跑在他的戰車前面。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","他會派一些人做千夫長、五十夫長，一些人為他耕種田地、收割莊稼，一些人製造兵器和戰車的裝備。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","他會把你們的女兒帶走，要她們給他造香膏、煮飯和烤餅。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","他會奪去你們最好的田地、葡萄園和橄欖園，送給他的臣僕。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","他會從你們的糧食和葡萄園的出產中收取十分之一，送給他的官員和臣僕。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","他會徵用你們的僕婢及最好的牛和驢來為他效勞。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","他會拿去你們羊群的十分之一，你們必做他的奴僕。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","那時你們會因所選之王的壓迫而呼求耶和華，耶和華卻不會垂聽。」 ");
INSERT INTO cmncbt_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","民眾卻不肯聽從撒母耳的話。他們說：「不，我們想要一個王治理我們， ");
INSERT INTO cmncbt_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","這樣我們就會像其他國家一樣，有王來統治我們，率領我們，為我們作戰。」 ");
INSERT INTO cmncbt_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","撒母耳聽後，就把民眾這些話轉告耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","耶和華對撒母耳說：「照他們說的去為他們立一個王吧。」於是，撒母耳對以色列人說：「你們各人回自己的城去吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","有一個便雅憫人名叫基士，很有威望，是亞斐亞的玄孫、比歌拉的曾孫、洗羅的孫子、亞別的兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","他的兒子掃羅年輕英俊，在以色列人中無人能比，高出其他人一個頭。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","一天，基士丟失了幾頭驢，他就對兒子掃羅說：「你帶一個僕人去找驢吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","他們找遍了以法蓮的山區、沙利沙地區、沙琳地區和便雅憫地區，都找不著。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","最後，他們來到蘇弗，掃羅對僕人說：「我們還是回家去吧，恐怕我父親不再為驢擔心，反而為我們擔心。」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","但僕人答道：「且慢，這城裡有一位上帝的僕人，很受人敬重，他所說的都會應驗。我們去找他吧，也許他會告訴我們該到哪裡去找驢。」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","掃羅答道：「如果去的話，我們有什麼可以送給他呢？我們袋裡的食物也吃完了，我們還有什麼可以送給上帝的僕人呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","僕人說：「我這裡還有三克銀子，我們可以送給上帝的僕人，請他告訴我們去哪裡找驢。」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","從前在以色列，如果人們要求問上帝，他們會說：「讓我們去找先見吧。」當時「先知」被稱為「先見」。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","掃羅說：「好主意，我們去吧。」於是，他們前往上帝僕人住的城。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","他們走上山坡，正要進城的時候，遇見一些少女出來打水，就問：「先見在這裡嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","她們答道：「他在這裡，就在你們前面。你們快去吧，他今天剛到城裡來，因為今天人們在邱壇獻祭。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","你們一進城，就會在他上邱壇吃祭物之前遇見他。因為他不來，人們不能吃，他要先為祭物祝謝後，人們才可以吃。你們現在上去吧，一定會遇見他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","他們就趕往城內，剛走進城，就看見撒母耳迎面而來，要上邱壇去。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","在掃羅來的前一天，耶和華已經啟示撒母耳說： ");
INSERT INTO cmncbt_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","「明天這個時候，我會從便雅憫境內差遣一個人到你這裡，你要膏立他做我以色列子民的首領，他會從非利士人手中把我的子民拯救出來，因為我已聽到我子民的呼求，我要施恩給他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","撒母耳看見掃羅的時候，耶和華就對他說：「這就是我對你說的那個人，他將統治我的子民。」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","掃羅來到在城門口的撒母耳面前，問道：「請你告訴我先見住在哪裡？」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","撒母耳答道：「我就是先見。你先上邱壇去，今天你要和我一起吃飯。明天早上我會送你上路，並把你想知道的事都告訴你。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","不要再掛念三天前丟失的驢了，已經找到了。以色列人所仰慕的人是誰呢？不是你和你父親全家嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","掃羅答道：「我來自以色列最小的便雅憫支派，我的家族在便雅憫支派中最小，你何出此言？」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","撒母耳帶著掃羅和他的僕人來到一個大廳，讓他們在請來的三十位客人中坐上座。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","撒母耳對廚師說：「把我交給你的那份祭肉拿來。」 ");
INSERT INTO cmncbt_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","廚師就拿來那塊腿肉，擺在掃羅面前。撒母耳說：「這是為你留的，請吃吧。這是我在請客人時特意為你留的。」於是，掃羅和撒母耳一起吃飯。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","他們從邱壇下來，回到城裡後，撒母耳把掃羅帶到屋頂上談話。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","黎明時分，撒母耳呼喚屋頂上的掃羅：「起來吧，我該送你上路了。」於是掃羅起床後，與撒母耳一起往外走。 ");
INSERT INTO cmncbt_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","他們來到城邊的時候，撒母耳讓掃羅吩咐僕人先走。僕人離去後，他對掃羅說：「你在這裡留一會兒，我要把上帝的話告訴你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","撒母耳把一瓶膏油倒在掃羅的頭上，親吻他，說：「耶和華已經膏立你做祂子民的首領。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","你今天離開我以後，會在便雅憫境內的謝撒、靠近拉結的墓旁遇見兩個人。他們會告訴你，你要找的驢已經找到，現在你父親不再為驢擔心，反為你擔心，說，『我該怎樣找到我的兒子呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","你繼續往前走，會在他泊的橡樹那裡遇見三個人。他們要到伯特利去敬拜上帝，一個牽著三隻山羊羔，一個帶著三個餅，一個拿著一皮袋酒。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","他們會問候你，送你兩個餅，你要把餅收下。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","此後，你會去上帝的山，那裡有非利士人的駐軍。你一進城，就會遇見一群先知從邱壇下來，前面有人鼓瑟、敲鼓、吹笛、彈琴，先知們會說預言。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","耶和華的靈會突然降在你身上，你就會跟他們一起說預言，那時，你會變成另一個人。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","這些兆頭臨到你的時候，你就要見機行事，因為上帝與你同在。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","你先到吉甲去，在那裡等我七天，我會到那裡獻燔祭和平安祭。我到了以後會告訴你怎麼做。」 ");
INSERT INTO cmncbt_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","掃羅轉身離開撒母耳，上帝使他心靈煥然一新。撒母耳所說的兆頭那天都應驗了。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","掃羅和他的僕人來到上帝的山，遇見了一群先知。上帝的靈突然降在掃羅身上，他就在他們中間說起預言來。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","以前認識掃羅的人看見他跟先知一起說預言，就議論說：「基士的兒子怎麼了？掃羅也做了先知嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","當地的一個人說：「他們的父親是誰？」自此以後，「掃羅也做了先知嗎」就成為一句諺語。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","掃羅說完預言以後，就去了邱壇。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","掃羅的叔叔問他和他的僕人：「你們到哪裡去了？」掃羅答道：「我們去找驢，沒找著，就去見撒母耳。」 ");
INSERT INTO cmncbt_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","掃羅的叔叔說：「請把撒母耳對你們說的話告訴我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","掃羅答道：「他肯定地告訴我們驢已經找到了。」但掃羅沒有把撒母耳提到的立王之事告訴叔叔。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","撒母耳把以色列人招聚到米斯巴耶和華那裡， ");
INSERT INTO cmncbt_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","對他們說：「以色列的上帝耶和華這樣說，『我帶你們出開埃及，從埃及人和壓迫你們的各國之人手中救出你們。』 ");
INSERT INTO cmncbt_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","但你們現在卻背棄了拯救你們脫離一切災難和困苦的上帝，竟然對祂說，『我們要你立一位王來統治我們。』所以你們現在就按著支派宗族站在耶和華面前吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","撒母耳讓以色列各支派來抽籤，結果抽中了便雅憫支派。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","然後撒母耳讓便雅憫支派的各宗族來抽，結果抽中了瑪特利家族，最後又抽中了基士的兒子掃羅。眾人找掃羅，卻找不到他。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","他們便求問耶和華，說：「這人來了嗎？」耶和華說：「他來了，躲在物品堆中。」 ");
INSERT INTO cmncbt_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","他們就跑去把掃羅請來。掃羅站在百姓當中，高出眾人一頭。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","撒母耳對百姓說：「這就是耶和華為你們選的人。在以色列沒有人能比得上他。」眾人高呼：「願王萬歲！」 ");
INSERT INTO cmncbt_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","撒母耳向百姓說明做君王的權利和責任，又把這些都記在冊子上，放在耶和華面前，然後讓百姓各自回家。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","掃羅返回基比亞自己的家時，有一群被上帝感動的勇士跟隨他。 ");
INSERT INTO cmncbt_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","但有一些市井之徒說：「這人怎能救我們？」就鄙視他，沒有送禮物給他，但掃羅沒有說什麼。 ");
INSERT INTO cmncbt_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","亞捫人拿轄率軍上來圍困基列·雅比，城內的居民對拿轄說：「你與我們立約吧！我們願意服侍你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","亞捫人拿轄說：「好，但有一個條件，我要挖去你們每一個人的右眼，作為對全體以色列人的羞辱。」 ");
INSERT INTO cmncbt_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","雅比的長老說：「請寬限我們七天，我們好派遣使者去以色列全境。要是沒有人來營救我們，我們就向你投降。」 ");
INSERT INTO cmncbt_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","雅比的使者來到掃羅的家鄉基比亞，把他們的情況告訴眾人，眾人聽了放聲大哭。 ");
INSERT INTO cmncbt_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","那時掃羅剛好趕著牛從田間回來，便問道：「發生了什麼事？為什麼眾人都在哭？」百姓把雅比的情況告訴了他。 ");
INSERT INTO cmncbt_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","掃羅聽後，上帝的靈便突然降在他身上，他勃然大怒， ");
INSERT INTO cmncbt_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","牽來兩頭牛，把牠們切成碎塊，然後派使者把碎塊分發到以色列全境，並且宣佈：「誰拒絕跟隨掃羅和撒母耳出戰，他的牛就要被砍成這樣。」耶和華使百姓充滿恐懼，他們都同心合意地響應。 ");
INSERT INTO cmncbt_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","掃羅在比色統計以色列人，共有三十萬，從猶大來的有三萬。 ");
INSERT INTO cmncbt_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","他們讓雅比的使者回去告訴基列·雅比人，說：「明天中午，你們必得拯救。」使者回去告訴雅比人，他們非常歡喜， ");
INSERT INTO cmncbt_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","便對亞捫人說：「明天我們會出來歸順你們，你們怎樣對待我們都可以。」 ");
INSERT INTO cmncbt_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","第二天，掃羅把以色列人分成三隊，在黎明時分突襲亞捫人的軍營，把他們殺得大敗，直到中午才收兵。亞捫人的殘兵四散奔逃，沒有二人在一處的。 ");
INSERT INTO cmncbt_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","以色列人對撒母耳說：「是誰說掃羅不該做王？把他們帶來，我們要處死他們。」 ");
INSERT INTO cmncbt_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","掃羅卻說：「今天不可殺人，因為今天耶和華拯救了以色列。」 ");
INSERT INTO cmncbt_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","撒母耳對民眾說：「來吧，我們到吉甲去，在那裡重新立國。」 ");
INSERT INTO cmncbt_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","於是，他們來到吉甲，在耶和華面前立掃羅為王，又向耶和華獻上平安祭。掃羅和全體以色列人都非常歡喜。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","撒母耳對以色列人說：「看啊，我已照你們的要求為你們立了一個王。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","你們已經有君王了。我自幼帶領你們，現在已年老髮白，我的兒子也都在你們這裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","如今我站在這裡，你們只管在耶和華和祂膏立的王面前為我作證，我奪過誰的牛？搶過誰的驢？欺騙過誰？壓迫過誰？收過誰的賄賂而徇私枉法？如果有的話，我一定償還。」 ");
INSERT INTO cmncbt_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","他們答道：「你沒有欺騙、壓迫過我們，也沒有拿過任何人的東西。」 ");
INSERT INTO cmncbt_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","撒母耳對他們說：「耶和華和祂所膏立的王今天為我作證，我沒有拿過你們任何人的東西。」他們說：「是的，耶和華為證。」 ");
INSERT INTO cmncbt_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","撒母耳繼續說：「是耶和華派摩西和亞倫帶領你們的祖先離開埃及。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","現在，你們都要站在耶和華面前，讓我來提醒你們有關耶和華為你們和你們祖先所行的一切公義之事。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","從前，雅各曾遷到埃及，你們的祖先受到埃及人的壓迫，向耶和華呼求，耶和華就差遣摩西和亞倫帶他們出埃及，到這裡居住。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","他們卻忘記了他們的上帝耶和華，於是耶和華讓他們落入夏瑣的將軍西西拉、非利士人和摩押王的手中，這些人便攻擊他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","他們就向耶和華呼求，『耶和華啊，我們犯了罪，我們背棄了你去供奉巴力和亞斯她錄，現在求你從仇敵手中救我們，我們必事奉你。』 ");
INSERT INTO cmncbt_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","耶和華就派耶路·巴力、比但、耶弗他和撒母耳從周圍的敵人手中救你們，使你們安然居住。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","可是你們看到亞捫王拿轄來攻擊你們，就對我說，『不行，我們要有一個王來統治我們。』其實你們的上帝耶和華就是你們的王。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","現在，你們所求所選的王在這裡，耶和華為你們立了一位王。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","如果你們敬畏耶和華，事奉祂，聽從祂的吩咐，不違背祂的命令，你們和統治你們的王都願意跟從祂，一切都會順利。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","如果你們不聽從耶和華的話，違背祂的命令，祂就會像從前懲罰你們的祖先一樣出手懲罰你們。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","現在你們站著留心看，耶和華就要在你們面前行一件大事。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","你們都知道收割麥子的時候不會下雨。現在，我要向耶和華禱告，求祂打雷降雨，好讓你們知道，你們要求立王在耶和華眼中是多麼大的罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","於是，撒母耳向耶和華呼求，耶和華便在當天打雷降雨，民眾非常害怕耶和華和撒母耳。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","他們求撒母耳，說：「求你為僕人們向你的上帝耶和華祈禱，免得我們死亡！因為我們要求立王是罪上加罪。」 ");
INSERT INTO cmncbt_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","撒母耳說：「不要害怕，你們雖然做了這惡事，但不可離開耶和華，要全心全意地事奉祂。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","不要去追求其他虛無的假神，它們對你們毫無益處，也不能拯救你們。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","耶和華不會丟棄祂的子民，使自己的大名受損，祂樂意使你們做祂的子民。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","至於我，我會不斷地為你們祈禱，免得我得罪耶和華。我會教導你們行善道、走正路。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","你們要單單敬畏耶和華，全心全意地事奉祂，想想祂為你們做了何等偉大的事。 ");
INSERT INTO cmncbt_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","可是，如果你們仍然繼續行惡，你們和你們的王都必滅亡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","掃羅四十歲登基。他在統治以色列的第二年， ");
INSERT INTO cmncbt_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","從以色列人中選出三千人，親自帶領其中的兩千人到密抹和伯特利山，另外一千人和約拿單留在便雅憫境內的基比亞。他把其餘的人遣散回家。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","約拿單攻打迦巴的非利士駐軍，非利士人聽到了這消息。於是，掃羅在各地吹響號角，通告希伯來人。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","以色列眾人聽說掃羅攻打非利士人的駐軍，並聽說非利士人對以色列人恨之入骨，便響應掃羅的號召，聚集在吉甲。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","非利士人調兵遣將，要攻打以色列。他們有三萬輛戰車和六千騎兵，步兵多如海邊的沙。大軍來到伯·亞文以東的密抹，駐紮在那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","以色列人看見敵軍壓境，情勢危急，紛紛躲進山洞、叢林、石穴、地洞和坑裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","有些希伯來人過了約旦河，逃到迦得和基列。但掃羅仍然留在吉甲，跟隨他的人都害怕得發抖。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","掃羅按著撒母耳所定的日期在吉甲等了七天，可是撒母耳還沒有來。掃羅的軍兵開始散去。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","於是，掃羅說：「你們把燔祭和平安祭帶到我這裡來。」他就獻上了燔祭。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","掃羅剛把燔祭獻完，撒母耳就來了，掃羅出去迎接他，向他問安。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","撒母耳對掃羅說：「你做的是什麼事？」掃羅答道：「我看見民眾不斷離我而去，你到了約定的時候還沒有來，而且非利士人就聚集在密抹。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","我想非利士人就要到吉甲來攻打我了，但我還沒有向耶和華求助，我迫不得已，就獻上燔祭了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","撒母耳說：「你真糊塗！你違背了你的上帝耶和華的命令。祂本來要使你的王位在以色列永遠堅立， ");
INSERT INTO cmncbt_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","但現在你的王位不能長久了，耶和華已經找到一個合祂心意的人，要立他做百姓的君王。因為你沒有遵守耶和華的命令。」 ");
INSERT INTO cmncbt_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","撒母耳離開吉甲去便雅憫境內的基比亞。掃羅數了一下跟隨他的人，約有六百人。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","掃羅和兒子約拿單及隨從留在便雅憫境內的迦巴，非利士人則在密抹紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","非利士人分成三隊施行突襲，一隊前往書亞境內的俄弗拉， ");
INSERT INTO cmncbt_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","一隊前往伯·和崙，一隊前往邊境地區，那裡可以俯瞰曠野附近的洗波音谷。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","那時，以色列全境找不到一個鐵匠，這是因為非利士人的禁令，防止希伯來人製造刀槍。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","以色列人都要到非利士的鐵匠那裡去磨鋤、犁、斧和鏟。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","磨鋤或犁要花八克銀子，磨三齒叉、斧頭或趕畜棒要花四克銀子。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","所以在交戰的日子，除了掃羅和約拿單外，其他隨從手上都沒有刀槍。 ");
INSERT INTO cmncbt_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","當時非利士的一隊防兵前往密抹的隘口駐守。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","一天，掃羅的兒子約拿單對為他拿兵器的年輕人說：「來吧，我們去非利士的駐軍那裡。」但他沒有告訴父親。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","那時掃羅正待在基比亞邊界米磯崙的石榴樹下，跟隨他的大約有六百人， ");
INSERT INTO cmncbt_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","其中有穿著以弗得的祭司亞希亞，即亞希突的兒子。亞希突是示羅耶和華祭司以利的孫子，非尼哈的兒子，以迦博的哥哥。沒有人留意到約拿單出去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","約拿單到非利士駐軍那裡需要經過一個隘口，隘口兩邊的山峰一個叫播薛，一個叫西尼， ");
INSERT INTO cmncbt_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","北面的山峰面對密抹，南面的山峰面對迦巴。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","約拿單對拿兵器的年輕人說：「我們去那些未受割禮之人的軍營，也許耶和華會幫助我們。祂使人得勝不在於人數多少。」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","拿兵器的人答道：「就照你的意思，我會一心追隨你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","約拿單說：「我們去他們那邊，故意讓他們發現。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","如果他們說，『站住，等我們去你們那裡！』我們就待在原地，不去他們那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","但如果他們說，『你們來我們這裡！』我們就去，因為那表示耶和華已經把他們交在我們手裡了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","非利士的駐軍看見二人走近，就說：「看！希伯來人從躲藏的洞裡爬出來了！」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","駐軍對約拿單和拿兵器的人大喊：「上來，我們要教訓教訓你們。」約拿單就對拿兵器的人說：「跟著我爬上去，耶和華已經把他們交在以色列人手裡了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","於是，約拿單就爬上去擊殺非利士人，拿兵器的人緊隨其後，一同擊殺非利士人。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","他們首次出擊，在半畝大小的區域殺了約二十個非利士人。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","營房、田野的所有非利士人，包括駐軍和突擊隊都非常恐慌。大地震動，眾人恐懼萬分。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","掃羅在便雅憫境內基比亞的哨兵看見非利士軍隊四散奔逃，潰不成軍。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","掃羅對跟隨他的人說：「你們查一查，看誰離開了軍營？」結果發現約拿單和為他拿兵器的人不見了。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","掃羅對亞希亞說：「把上帝的約櫃抬來。」那時上帝的約櫃在以色列人那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","掃羅和祭司說話的時候，非利士人營裡越來越混亂。掃羅對祭司說：「停手吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","他和跟隨他的人聚集起來，衝入戰場，發現非利士人正互相殘殺，亂作一團。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","從前加入非利士軍隊的希伯來人，現在也倒戈加入掃羅和約拿單的以色列軍隊。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","那些躲在以法蓮山區的以色列人聽說非利士人潰逃，都出來緊緊地追殺他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","耶和華在那天拯救了以色列人，戰事一直蔓延到伯·亞文。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","那一天，以色列人很困乏，因為掃羅叫他們起誓：「誰在黃昏前，就是在向敵人報完仇以前吃任何東西，誰就要受咒詛。」於是，以色列人整天都沒有進食。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","眾人進入樹林，見地上有蜂蜜。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","他們在樹林中雖然看見有蜂蜜正在滴落，但沒有人敢伸手取蜂蜜吃，因為他們都怕違背誓言。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","約拿單沒有聽見他父親叫以色列人起誓，他伸出手中的杖蘸蜂房的蜜吃，立刻精神大振。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","有個士兵告訴約拿單，說：「你父親曾叫眾人鄭重起誓，『今天吃東西的人必受咒詛。』所以眾人很疲憊。」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","約拿單說：「我父親使大家受苦了。你們看，我只吃了少許蜂蜜，就精神大振， ");
INSERT INTO cmncbt_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","如果大家吃了從敵人那裡奪來的食物，我們就會殲滅更多非利士人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","那天，以色列人追殺非利士人，從密抹一直追殺到亞雅崙，眾人疲憊不堪。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","他們匆匆把奪來的牛、羊和牛犢在地上宰了，肉還帶血就吃了。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","有人告訴掃羅，說：「眾人吃了帶血的肉，得罪耶和華了。」掃羅說：「你們犯罪了！現在把一塊大石頭滾到我這裡來， ");
INSERT INTO cmncbt_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","再去吩咐大家把牛羊都帶到這裡來宰了吃，不可吃帶血的肉得罪耶和華。」當晚，眾人都把自己的牛羊帶到那裡宰殺。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","掃羅為耶和華築了一座祭壇，這是他第一次為耶和華築壇。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","他對以色列人說：「讓我們連夜追趕非利士人，搶奪他們的財物，直到天亮，把他們全部殲滅。」眾人答道：「就照你的意思。」但祭司說：「讓我們先來求問上帝吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","於是，掃羅求問上帝，說：「我可以去追殺非利士人嗎？你會把他們交在以色列人手裡嗎？」但耶和華那日沒有回答他。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","掃羅說：「你們這些百姓的首領到這裡來，我們要查出今天究竟誰犯了罪， ");
INSERT INTO cmncbt_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","我憑拯救以色列的永活的耶和華起誓，就是我兒子約拿單犯了罪，他也要死！」眾人都默不作聲。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","掃羅對以色列眾人說：「你們站在這邊，我和我的兒子約拿單站在那邊。」眾人答道：「就照你的意思。」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","掃羅向以色列的上帝耶和華禱告說：「請你把實情告訴我吧。」抽籤的結果是約拿單和掃羅犯了罪，民眾都是無辜的。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","掃羅和約拿單二人再抽籤，結果抽出了約拿單。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","掃羅對約拿單說：「告訴我，你做了什麼事？」約拿單說：「我確實用手中的杖蘸了一點蜂蜜吃，這樣我就要死嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","掃羅說：「約拿單啊，你必須死。否則，願上帝重重地懲罰我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","但眾人對掃羅說：「今天約拿單給以色列人帶來這麼大的勝利，難道要他死嗎？絕不可以！我們憑永活的耶和華起誓，絕不可動他一根頭髮，因為他今天的行動有上帝的幫助。」眾人就這樣救了約拿單的性命。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","掃羅便停止了追擊，非利士人也回本地去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","掃羅統治以色列後，常常攻打四圍的摩押人、亞捫人、以東人、瑣巴的諸王和非利士人等仇敵，無往而不勝。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","他奮勇殺敵，打敗了亞瑪力人，從掠奪者手中救出以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","他的兒子是約拿單、亦施韋和麥基舒亞，長女叫米拉，次女叫米甲。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","他的妻子名叫亞希暖，是亞希瑪斯的女兒。掃羅軍隊的元帥叫押尼珥，是他叔叔尼珥的兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","掃羅的父親基士和押尼珥的父親尼珥都是亞別的兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","掃羅一生常和非利士人激烈交戰。他遇見英勇的壯士，都會徵募到自己麾下。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","一天，撒母耳對掃羅說：「耶和華差遣我膏立你做祂以色列子民的王，所以你要聽從祂的話。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","萬軍之耶和華說，『我要懲罰亞瑪力人，因為在以色列人離開埃及的時候，他們與以色列人為敵。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","你現在要去攻打他們，徹底消滅他們和他們擁有的一切，把男女老幼、牛羊駱駝和驢全部殺掉，一個不留。』」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","於是，掃羅在提拉因召集了二十萬步兵，另有從猶大來的一萬人。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","掃羅來到亞瑪力的城池，在山谷裡埋伏起來。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","他對基尼人說：「你們離開亞瑪力人吧，免得我把你們也一起消滅，因為在以色列人離開埃及的時候，你們曾善待他們。」於是，基尼人離開了亞瑪力人。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","掃羅攻打亞瑪力人，從哈腓拉直打到埃及東面的書珥， ");
INSERT INTO cmncbt_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","生擒了亞瑪力王亞甲，用刀殺盡了亞瑪力人。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","掃羅和他的士兵卻留下了亞甲和那些上好的牛羊、肥壯的牛犢和羊羔及一切美物，只毀滅了那些瘦弱無用的牲畜。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","那時，耶和華對撒母耳說： ");
INSERT INTO cmncbt_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","「我後悔立掃羅為王，因為他離棄了我，不遵守我的命令。」撒母耳很氣憤，整夜呼求耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","清早，撒母耳起來去見掃羅，有人告訴他掃羅已前往迦密山，在那裡為自己立了紀念碑，然後去了吉甲。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","撒母耳到了掃羅那裡後，掃羅說：「願耶和華賜福給你，我已經遵守了耶和華的命令。」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","撒母耳說：「那麼，我現在聽見的牛羊叫聲是從哪裡來的？」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","掃羅答道：「這是眾人從亞瑪力人那裡帶回來的，他們留下了這些上好的牛羊要獻給你的上帝耶和華，我們毀滅了其餘的一切。」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","撒母耳對掃羅說：「住口！讓我告訴你耶和華昨天晚上對我說的話。」掃羅答道：「請說。」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","撒母耳說：「你雖然從前覺得自己微不足道，但現在卻做了以色列各支派的首領。耶和華膏立你做以色列的王。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","祂差遣你去攻打那些罪惡的亞瑪力人，命你把他們全部消滅。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","你為何不聽從祂的命令？你為何急於掠奪財物，做耶和華視為邪惡的事呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","掃羅答道：「我的確服從了耶和華的命令，照著耶和華的吩咐做了。我把亞瑪力王亞甲帶了回來，殺盡了其餘的亞瑪力人。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","士兵們卻從本該毀滅的戰利品中取了上好的牛羊，準備在吉甲奉獻給你的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","撒母耳說： 「耶和華喜歡燔祭和其他祭物， 豈如喜歡人們聽從祂的話？ 順服勝於獻祭， 聽從耶和華勝過向祂獻上公羊的脂肪。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","叛逆不亞於行巫術的罪， 頑固不化無異於拜偶像。 你拒絕耶和華的命令， 祂也拒絕你做王。」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","掃羅對撒母耳說：「我犯罪了！我違背了耶和華的命令和你的指示。我因懼怕百姓，就聽從了他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","現在求你赦免我的罪，跟我一起回去，我好敬拜耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","但撒母耳說：「我不會跟你回去，你既然拒絕遵行耶和華的命令，祂也拒絕你做以色列的王。」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","撒母耳轉身離去，掃羅就抓住他外袍的衣邊，結果衣邊被撕下來了。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","撒母耳對他說：「耶和華今天已經從你身上撕下以色列國，賜給了一個比你好的人。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","以色列榮耀的上帝不說謊、也不改變心意，因為祂不是反復無常的世人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","掃羅說：「我犯了罪，但求你在以色列的長老和百姓面前尊重我，求你跟我回去，我好敬拜你的上帝耶和華。」 ");
INSERT INTO cmncbt_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","於是，撒母耳跟掃羅一起回去，掃羅就敬拜耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","撒母耳說：「把亞瑪力王亞甲帶到我這裡來。」亞甲若無其事地來到他面前，心想自己一定逃過一死了。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","但撒母耳對他說：「你的刀怎樣使婦人失去兒女，你的母親也要怎樣失去她的兒子。」於是，撒母耳就在吉甲，在耶和華面前把亞甲殺死了。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","事後，撒母耳回到拉瑪，掃羅也返回基比亞自己的家。 ");
INSERT INTO cmncbt_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","撒母耳一直到死沒有再見掃羅，但他為掃羅哀傷。耶和華後悔立掃羅做以色列王。 ");
INSERT INTO cmncbt_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","耶和華對撒母耳說：「我已經拒絕讓掃羅做以色列王了，你還要為他哀傷多久呢？把你的角盛滿膏油，我要差遣你到伯利恆的耶西那裡，我已選了他的一個兒子做王。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","撒母耳說：「我怎麼可以去呢？掃羅知道了，一定會殺掉我。」耶和華說：「你帶一頭牛犢去，就說，『我是來向耶和華獻祭的。』 ");
INSERT INTO cmncbt_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","你要請耶西參加獻祭，我會告訴你怎麼做，我把誰指示給你，你就要為我膏立誰。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","撒母耳遵行耶和華的吩咐，他來到伯利恆，那城的長老都戰戰兢兢地出來迎接他，問道：「你是為平安而來嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","撒母耳答道：「是的，為平安而來，我是來向耶和華獻祭的。你們要潔淨自己，然後來和我一起獻祭。」撒母耳為耶西及其眾子行過潔淨禮後，便邀請他們參加獻祭。 ");
INSERT INTO cmncbt_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","耶西及其眾子來了，撒母耳看見以利押，心裡想：「這位肯定是耶和華要膏立的人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","但耶和華對撒母耳說：「不要看他相貌堂堂、身材高大，我要選的不是他。耶和華不像世人那樣看人，人看外表，耶和華看內心。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","耶西吩咐他的兒子亞比拿達從撒母耳面前走過，但撒母耳說：「這也不是耶和華揀選的人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","耶西又叫沙瑪從撒母耳面前走過，但撒母耳說：「這也不是耶和華揀選的人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","耶西叫七個兒子一個一個從撒母耳面前走過，但撒母耳說他們都不是耶和華揀選的人。 ");
INSERT INTO cmncbt_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","撒母耳問耶西：「你的兒子全都到齊了嗎？」耶西答道：「還有一個最小的，他正在田間放羊。」撒母耳對耶西說：「派人叫他回來，他不來，我們就不入座。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","耶西就派人去叫他回來。他面色紅潤，眉清目秀，相貌英俊。耶和華說：「就是他，起來膏立他吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","撒母耳就拿出盛膏油的角，當著他哥哥們的面膏立他。從那天起，耶和華的靈突然降在大衛身上。事後，撒母耳回拉瑪去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","耶和華的靈離開了掃羅，有個邪靈從耶和華那裡來折磨他。 ");
INSERT INTO cmncbt_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","掃羅的臣僕對他說：「現在有個邪靈從上帝那裡來折磨你， ");
INSERT INTO cmncbt_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","你可以吩咐跟前的臣僕去找一個善於彈琴的人來。邪靈從上帝那裡來到你身上的時候，他為你彈琴，你就舒暢了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","掃羅說：「你們就為我找一個善於彈琴的人，帶他到我這裡來。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","其中有一個僕人說：「我見過伯利恆的耶西的一個兒子，他善於彈琴，英勇善戰，談吐合宜，相貌英俊，並且耶和華與他同在。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","掃羅便差遣使者去見耶西，說：「請讓你放羊的兒子大衛到我這裡來。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","耶西就把一些餅、一皮袋酒和一隻山羊羔馱在驢背上，讓兒子大衛帶去送給掃羅。 ");
INSERT INTO cmncbt_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","大衛到了掃羅那裡，做了他身邊的侍臣。掃羅非常喜歡大衛，讓大衛為他拿兵器。 ");
INSERT INTO cmncbt_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","掃羅派人去見耶西，說：「你就讓大衛留在我的身邊吧，因為我喜歡他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","每當有邪靈從上帝那裡來到掃羅身上的時候，大衛就為他彈琴，掃羅便覺得舒暢，邪靈也離開了他。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","非利士人在猶大的梭哥招聚軍隊，準備作戰。他們在梭哥和亞西加之間的以弗·大憫紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","掃羅和以色列人也聚集起來在以拉谷安營，擺好陣勢準備迎戰。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","雙方的軍隊各佔一座山對峙，中間隔著山谷。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","非利士營中有個名叫歌利亞的巨人出來討戰。他來自迦特，身高三米， ");
INSERT INTO cmncbt_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","頭戴銅盔，身穿重達五十七公斤的鎧甲， ");
INSERT INTO cmncbt_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","腿上有銅護膝，肩背銅戟。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","戟柄粗如織布機的軸，鐵戟頭重七公斤。有衛士拿著他的盾牌走在前面。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","他站在那裡挑戰以色列人，高喊：「你們為什麼列陣打仗呢？我是非利士人，你們是掃羅的僕人，你們選一個人下來跟我一比高下。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","如果他打得過我，將我殺了，我們就做你們的奴隸。但如果我戰勝他，把他殺了，你們就要做我們的奴隸，服侍我們。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","我今天向以色列軍隊罵陣，你們找一個人出來跟我一決高下吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","掃羅和所有以色列人聽了非利士人的這些話，都嚇得驚恐不已。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","大衛是以法他人耶西的兒子。掃羅執政期間，耶西已經年紀老邁，住在猶大的伯利恆，有八個兒子。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","他的三個兒子已經跟隨掃羅去打仗了，他們是長子以利押、次子亞比拿達和三子沙瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","大衛年紀最小，他的三個哥哥跟隨掃羅期間， ");
INSERT INTO cmncbt_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","他有時去掃羅的軍營，有時回伯利恆為他父親放羊。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","這非利士人早晚都出來罵陣，長達四十天。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","一天，耶西對大衛說：「你帶上十公斤烤麥和十個餅，趕快到軍營中送給你的哥哥們。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","再帶十塊奶餅送給他們的千夫長，看望一下他們，帶個信兒回來。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","他們跟隨掃羅率領的以色列軍在以拉谷跟非利士人打仗。」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","大衛清早起來把羊交給一個牧人看顧，然後照父親的吩咐帶著食物出發了。他來到軍營的時候，大軍正吶喊著出戰。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","以色列人與非利士人擺好陣勢，兩軍對壘。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","大衛把帶來的東西交給負責看守的人保管，自己跑到陣中去問候哥哥們。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","他們正在交談的時候，非利士軍中的迦特人歌利亞出來，像往常一樣向以色列軍罵陣，大衛都聽見了。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","以色列人一看見歌利亞都競相奔逃，極其害怕。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","以色列人彼此議論說：「看那個人！他是來向以色列軍罵陣的。誰要能殺死他，王必有重賞，還會把女兒嫁給他為妻，並免去他父親家在以色列應繳的賦稅。」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","大衛問站在旁邊的人：「如果有人殺了這非利士人，洗掉以色列人的羞辱，他會得到什麼呢？這個未受割禮的非利士人是誰？竟敢向永活上帝的軍隊罵陣！」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","他們就把剛才的話一一告訴大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","大衛的長兄以利押聽見他跟人說話，就憤怒地對他說：「你來這裡做什麼？你把曠野的那幾隻羊交給誰了？我知道你驕傲自大，心懷惡意，你來只是想看打仗。」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","大衛說：「我做錯了什麼？我問一下都不行嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","他又去問其他人同樣的問題，得到了同樣的答覆。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","有人聽見了大衛的話，就去告訴掃羅，掃羅便派人來召大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","大衛對掃羅說：「大家不要因這個非利士人而喪膽，讓僕人去戰他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","掃羅說：「你不能去，你年紀還小，他卻是一個久經沙場的戰士。」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","大衛說：「我一直替父親放羊，有時候獅子或熊會從羊群中叼走羊， ");
INSERT INTO cmncbt_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","我會去追打牠，把羊從牠口中救出來。如果牠起來攻擊我，我就揪著牠的鬍子把牠打死。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","我曾打死過獅子和熊。這未受割禮的非利士人竟敢向永活上帝的軍隊罵陣，他的下場也必像獅子和熊一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","耶和華曾經從獅子和熊的利爪下拯救我，祂也必從這非利士人手中拯救我。」掃羅對大衛說：「去吧，願耶和華與你同在。」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","掃羅把自己的戰袍給大衛穿上，又給他戴上自己的頭盔，穿上自己的鎧甲。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","大衛把刀挎在戰袍上，試著走了幾步，卻不習慣這種裝束，就對掃羅說：「我穿著這些無法走路，因為我不習慣。」他便摘下頭盔，卸下鎧甲， ");
INSERT INTO cmncbt_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","然後拿著杖，在溪裡撿了五塊光滑的石頭放進牧人用的袋子，拿著投石器向歌利亞走去。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","歌利亞也迎著大衛走來，衛士拿著他的盾牌走在前面。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","歌利亞見大衛是個面色紅潤、相貌英俊的少年，就藐視他。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","他對大衛說：「你拿著棍子來戰我，難道我是一條狗嗎？」他就憑自己的神明咒詛大衛， ");
INSERT INTO cmncbt_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","又說：「你過來，我要把你的肉丟給天上的飛禽和地上的走獸。」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","大衛答道：「你是靠刀槍劍戟來攻擊我，我是靠萬軍之耶和華的名，就是你所蔑視的以色列軍隊的上帝來迎戰你。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","今天，耶和華必把你交在我手中，我必殺死你，砍掉你的頭，用非利士軍兵的屍體餵飛禽走獸，使普天下都知道以色列有上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","這裡所有的人都必知道耶和華拯救人不靠刀槍，因為祂掌管戰爭的勝負。祂必把你們交在我們手中。」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","歌利亞迎面走來的時候，大衛就飛快地跑上去應戰， ");
INSERT INTO cmncbt_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","他從袋裡拿出一塊石子用投石器猛力拋去，石子擊中歌利亞的額頭，嵌了進去，他迎面栽倒在地。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","大衛就這樣不用刀劍，只用投石器和一塊石子戰勝了那個非利士人，殺死了他。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","大衛跑到那非利士人身邊，從他刀鞘裡拔出刀殺了他，並割下他的頭顱。非利士人看見自己的英雄死了，紛紛逃跑。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","以色列人和猶大人乘勢吶喊，追殺非利士人，直追到迦特和以革倫的城門。通往迦特和以革倫的沙拉音大道上到處是非利士人的屍體。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","以色列軍隊追殺非利士人回來，又擄掠了他們的營地。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","大衛把那非利士人的頭顱帶到耶路撒冷，把那人的兵器存放在自己的帳篷中。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","掃羅看見大衛出去迎戰歌利亞，就問押尼珥元帥：「押尼珥啊，那少年是誰的兒子？」押尼珥答道：「王啊，我向你發誓，我真的不知道。」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","掃羅王說：「你去查查他是誰的兒子。」 ");
INSERT INTO cmncbt_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","大衛殺了歌利亞回來，押尼珥就把他帶到掃羅那裡，他手上還拿著那非利士人的頭顱。 ");
INSERT INTO cmncbt_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","掃羅問他：「年輕人，你是誰的兒子？」大衛答道：「我是你僕人伯利恆人耶西的兒子。」 ");
INSERT INTO cmncbt_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","大衛與掃羅說完話後，約拿單與大衛情投意合，他像愛自己一樣愛大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","從那天起，掃羅把大衛留在身邊，不讓他再回父親那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","約拿單像愛自己一樣愛大衛，他與大衛立了盟約， ");
INSERT INTO cmncbt_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","並把身上的外袍、戰衣、刀、弓和腰帶都送給大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","無論掃羅派大衛辦什麼事，他都表現出色。掃羅派他做軍隊的將領，民眾和掃羅的臣僕都非常滿意。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","大衛殺死了非利士人歌利亞，與眾人歸來時，婦女們擊鼓彈琴、載歌載舞地從以色列各城出來迎接掃羅王。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","她們跳舞歌唱：「掃羅殺死千千，大衛殺死萬萬。」 ");
INSERT INTO cmncbt_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","掃羅聽了非常憤怒，對這話很反感，就說：「她們將萬萬歸功給大衛，將千千歸功給我，只剩我的王位沒有給他了！」 ");
INSERT INTO cmncbt_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","掃羅從此對大衛起了嫉妒之心。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","第二天，從上帝那裡來的邪靈突然降在掃羅身上，他就在屋子裡叫鬧不停，大衛照常為他彈琴。掃羅當時手上拿著矛， ");
INSERT INTO cmncbt_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","他突然把矛投向大衛，心想：「我要把他刺透，釘在牆上。」他投了兩次，大衛都躲過了。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","耶和華離開了掃羅與大衛同在，所以掃羅忌憚大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","他把大衛調離自己身邊，立為千夫長，讓他領兵作戰。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","耶和華與大衛同在，因此他事事成功。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","掃羅看見大衛做事精明，就忌憚他。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","以色列人和猶大人都愛戴他，因為他帶領他們作戰。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","掃羅對大衛說：「我要把大女兒米拉嫁給你，但你要英勇作戰，效忠於我，為耶和華爭戰。」掃羅心裡想：「我不要親自動手，我要藉非利士人的手殺他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","大衛說：「我算什麼？我的家族在以色列那麼卑微，我怎麼配做王的女婿呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","到了與大衛成婚的日子，掃羅卻把米拉嫁給了米何拉人亞得列。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","掃羅的次女米甲愛上了大衛，掃羅知道了非常高興。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","他心裡想：「我把這個女兒給大衛，讓他中圈套，好藉非利士人的手殺掉他。」於是，他對大衛說：「你現在還有一次機會做我的女婿。」 ");
INSERT INTO cmncbt_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","他又吩咐臣僕，說：「你們私底下告訴大衛，說王很欣賞他，群臣都愛戴他，勸他做王的女婿。」 ");
INSERT INTO cmncbt_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","掃羅的臣僕把這話告訴了大衛，大衛卻說：「做王的女婿豈是一件小事呢？我不過是個貧窮卑微的人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","臣僕把大衛這番話回報掃羅， ");
INSERT INTO cmncbt_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","掃羅說：「你們去告訴大衛，就說王只需要一百個非利士人的包皮作聘禮，好向他的敵人報仇。」掃羅想讓大衛死在非利士人的手上。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","臣僕把這番話告訴了大衛，大衛欣然答應做王的女婿。期限到來之前， ");
INSERT INTO cmncbt_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","大衛和部下出去殺了二百個非利士人，把他們的包皮全部獻給掃羅，好做王的女婿。掃羅便把女兒米甲嫁給了大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","掃羅知道耶和華與大衛同在，自己的女兒米甲也愛他， ");
INSERT INTO cmncbt_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","就更加忌憚大衛，終生與大衛為敵。 ");
INSERT INTO cmncbt_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","非利士人的將領常來進犯，大衛每次作戰總比掃羅的其他臣僕出色，因而倍受尊重。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","掃羅吩咐他兒子約拿單和眾臣僕去殺掉大衛。但約拿單非常喜愛大衛， ");
INSERT INTO cmncbt_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","便告訴他，說：「我父親要殺你，明天早上你要小心，找個僻靜的地方躲起來。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","我會出去和父親站在你藏身的田間，跟他提你的事，然後把消息告訴你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","約拿單就在父親面前替大衛說好話，他說：「王不要傷害大衛，他從來沒有對不起王，他所做的使王大受益處。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","他冒著生命危險去殺非利士人，耶和華使以色列人大獲全勝，當時你看見了，非常歡喜，現在為什麼要犯罪，枉殺無辜的大衛呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","掃羅聽了約拿單的話，就憑永活的耶和華起誓說：「我不殺大衛。」 ");
INSERT INTO cmncbt_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","約拿單叫來大衛，把經過告訴他，帶他去見掃羅，大衛又像以前一樣伺候掃羅。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","後來，戰事再度爆發，大衛領兵與非利士人交戰，大敗敵人，殺得他們四散潰逃。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","一天，掃羅手裡拿著矛正坐在家中，從耶和華那裡來的邪靈降臨在掃羅身上。大衛正在彈琴， ");
INSERT INTO cmncbt_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","掃羅想用矛把大衛刺透，釘在牆上，大衛躲開了，矛插在了牆上。大衛當晚逃走了。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","掃羅派人去監視大衛的家，要在早上殺死他。大衛的妻子米甲警告他說：「你如果今晚不逃命，明早必死無疑。」 ");
INSERT INTO cmncbt_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","於是，她從窗口把大衛縋下去，讓他逃走了。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","然後她把家中的神像放在床上，頭枕在山羊毛的枕頭上，蓋上衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","掃羅派人來捉拿大衛的時候，米甲說他病了。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","掃羅又派人去見大衛，並吩咐說：「把他連床一起抬來，我好殺他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","眾人進去發現躺在床上的是一個神像，頭枕在山羊毛的枕頭上。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","掃羅問米甲：「你為什麼欺騙我，讓我的敵人逃走？」米甲答道：「他說如果我不讓他逃走，就殺了我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","大衛逃到住在拉瑪的撒母耳那裡，把掃羅的所作所為告訴他。後來，他和撒母耳去拿約住了下來。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","掃羅聽說大衛在拉瑪的拿約， ");
INSERT INTO cmncbt_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","就派人去捉拿他。掃羅的人看到一群先知在說預言，撒母耳在當中帶領他們。上帝的靈也臨到掃羅的人，他們也說起預言來。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","掃羅聽說後又派人去，派去的人也說起預言來。掃羅第三次派人去，派去的人同樣說起預言來。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","最後掃羅親自前往拉瑪，走到西沽的大井，問撒母耳和大衛在哪裡，有人說在拉瑪的拿約。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","掃羅便去拉瑪的拿約。上帝的靈臨到掃羅，他就一邊走一邊說起預言來，一直到拉瑪的拿約。 ");
INSERT INTO cmncbt_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","他脫下自己的衣服，在撒母耳面前說起預言來。他赤身躺了一天一夜。因此有句俗語說：「掃羅也在先知當中嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","大衛從拉瑪的拿約逃出來去見約拿單，問他：「我做了什麼？犯了什麼罪？我什麼地方對不起你父親，他竟追殺我？」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","約拿單答道：「絕無此事，你不會死的！我父親事無大小都會告訴我的，他不會瞞著我這件事，不會的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","大衛發誓說：「你父親深知你恩待我，他為了不使你傷心，才瞞著你。但我憑永活的耶和華和你的性命起誓，我離死亡僅一步之遙！」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","約拿單說：「你有什麼需要？我一定相助。」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","大衛答道：「明天是初一，我本該跟王一起用餐，請讓我躲到田間，直到第三天晚上。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","如果你父親問起我，你就說我懇求你允許我回到故鄉伯利恆，因為我全家正在那裡獻年祭。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","如果你父親說『好吧』，僕人就平安無事了。如果他發怒，就表示他決意要殺我。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","請你善待僕人，因你與我在耶和華面前立了盟約。如果我有罪，就請你親手殺了我，何必把我交給你父親呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","約拿單答道：「我決不會這樣做。我如果知道父親決意要殺你，怎能不通知你呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","大衛說：「你父親如果向你發怒，誰來告訴我呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","約拿單說：「我們一起到田野去吧。」於是，二人一起去了田野。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","約拿單對大衛說：「願以色列的上帝耶和華作證，明天或後天這個時侯我就會打探到我父親的意思，如果他善意待你，我會派人通知你。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","如果他有意殺你，而我卻不告訴你讓你安然逃走，願耶和華重重地懲罰我。願耶和華與你同在，像從前與我父親同在一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","在我有生之年，請你照耶和華的慈愛恩待我，免我一死。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","在我死後，即使耶和華把你所有的仇敵都毀滅了，請你仍舊恩待我的後人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","於是，約拿單與大衛家立下盟約，說：「如果大衛不守盟約，願耶和華藉著仇敵懲罰他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","約拿單因為像愛自己一樣愛大衛，便叫他再次起誓。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","約拿單說：「明天是初一，人們會注意到你缺席。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","到了後天，你要趕快去上次出事時躲藏的以色磐石那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","我會朝磐石的旁邊射三箭，好像射靶子。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","然後，我會叫一個少年把箭拾回來。如果你聽到我對他說，『箭就在你旁邊，把箭拾回來。』那就表示你可以回來了，我憑永活的耶和華起誓，你必平安無事。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","但如果我對少年說，『箭就在你前面。』你就要離開，因為是耶和華要你離開。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","至於我們之間所立的約，耶和華永遠為我們作證。」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","於是，大衛就躲到田野。初一到了，掃羅王入席吃飯， ");
INSERT INTO cmncbt_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","他照常坐在靠牆的位置，約拿單坐在對面，押尼珥坐在王的身邊，大衛的位子空著。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","那一天，掃羅並沒有說什麼，他以為大衛可能遇到了使自己不潔淨的事，不能赴宴。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","可是到了第二天，就是初二，大衛的座位還是空的，掃羅就問兒子約拿單：「耶西的兒子為什麼這兩天都不來赴宴呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","約拿單答道：「大衛懇求我讓他回到伯利恆， ");
INSERT INTO cmncbt_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","因為他家要在城中獻祭，他的哥哥要他去。他求我恩准他去見他的哥哥們。所以，他沒有來參加王的宴席。」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","掃羅向約拿單發怒，對他說：「你這邪逆婦人養的！難道我不知道你是站在耶西的兒子那邊嗎？你這樣做不但自取其辱，也使你母親蒙羞。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","只要耶西的兒子活在世上，你和你的王位就不得安穩。你派人把他抓到我這裡，他非死不可。」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","約拿單問：「為什麼要殺他？他做了什麼？」 ");
INSERT INTO cmncbt_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","掃羅氣得把矛擲向約拿單，想要殺他。約拿單知道父親決意要殺大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","他怒氣沖沖地離席，整天不肯進食，因為他看見父親如此卑劣地對待大衛，心裡非常難過。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","第二天早晨，約拿單按照和大衛的約定帶著一個少年來到田野。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","約拿單對少年說：「你跑去把我射的箭拾回來。」少年就向前跑去，約拿單把箭射在他前面。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","少年跑到落箭之處的時候，約拿單就大聲叫道：「箭不是在你前面嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","快快去，不要耽延。」少年連忙把箭拾起來，回到主人那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","他不知道主人的用意，只有約拿單和大衛知道。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","約拿單把弓箭交給那少年，吩咐他帶回城中。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","少年離開以後，大衛就從磐石南面出來，伏地拜了三拜。二人彼此親吻，抱頭痛哭，大衛更是泣不成聲。 ");
INSERT INTO cmncbt_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","約拿單說：「我們已憑耶和華的名起誓，有耶和華在你我和你我的子孫之間永遠為我們的盟約作證，你就安心去吧。」大衛便起身離開，約拿單也回城去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","大衛來到挪伯的祭司亞希米勒那裡。亞希米勒戰戰兢兢地出來迎接他，問道：「你為什麼獨自一人，沒有隨從呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","大衛答道：「王差遣我來辦一件事，他吩咐我不可把事情洩露給任何人。我已經吩咐部下在某處跟我會合。 ");
INSERT INTO cmncbt_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","現在你這裡有什麼吃的嗎？請給我五個餅，或別的什麼吃的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","祭司答道：「我們沒有普通的餅，只有聖餅，你的部下如果沒有親近過女色，就可以吃。」 ");
INSERT INTO cmncbt_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","大衛答道：「當然沒有親近過女色。每逢我們出來辦事，即使是平常的任務，我的部下總是保持聖潔，何況這次是特別的任務。」 ");
INSERT INTO cmncbt_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","於是，祭司把聖餅給他，因為那裡沒有別的餅，只有從耶和華的會幕裡更換下來的供餅。 ");
INSERT INTO cmncbt_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","那天，掃羅的司牧長以東人多益碰巧在耶和華的會幕。 ");
INSERT INTO cmncbt_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","大衛問亞希米勒：「你這裡有沒有刀槍？因為王的事緊急，倉促間我連兵器也沒有帶。」 ");
INSERT INTO cmncbt_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","祭司答道：「你在以拉谷殺的非利士人歌利亞的刀在這裡，用布包著放在以弗得後面。你要就拿去吧，這裡沒有別的刀了。」大衛答道：「這刀再好不過了，把它給我吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","那日，大衛為了躲避掃羅，逃往迦特王亞吉那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","亞吉的臣僕對亞吉說：「這個大衛不是以色列的王嗎？民眾跳舞歌唱『掃羅殺死千千，大衛殺死萬萬』，歌頌的不是他嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","大衛聽到這些話，擔心迦特王亞吉會加害於他， ");
INSERT INTO cmncbt_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","就在他們面前裝作瘋子，在城門上胡亂塗畫，任由唾沫沿著鬍子流下來。 ");
INSERT INTO cmncbt_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","亞吉對臣僕說：「你們看，這是個瘋子，為什麼把他帶到我這裡來？ ");
INSERT INTO cmncbt_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","我這裡缺少瘋子嗎？你們怎麼可以把這個傢伙帶到我家裡，在我面前瘋瘋癲癲呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","大衛離開迦特，逃到亞杜蘭洞。他的兄弟和親屬知道後，都來到他那裡， ");
INSERT INTO cmncbt_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","所有受壓迫的、負債的和心懷不滿的人都紛紛來投奔他。大衛就做了他們的首領，跟隨他的約有四百人。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","後來，大衛到摩押的米斯巴去，請求摩押王收留他的父母，直到他明白上帝給他的安排為止。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","大衛把父母留在了摩押王那裡。在大衛住堡壘期間，他的父母一直住在摩押。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","迦得先知吩咐大衛離開堡壘回猶大去，大衛就動身前往哈列的樹林。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","當時，掃羅正在基比亞的拉瑪，坐在柳樹下，手中拿著矛，臣僕侍立在左右。他得知大衛一行人的行蹤後， ");
INSERT INTO cmncbt_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","就對左右的臣僕說：「便雅憫人啊，你們聽著！難道耶西的兒子會給你們田地和葡萄園嗎？他能立你們做千夫長和百夫長嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","為什麼你們一同謀害我？我的兒子跟耶西的兒子立約，沒有人告訴我。就是今天我的兒子鼓動我的臣僕來謀害我，也沒有人關心我，告訴我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","以東人多益正站在掃羅的臣僕中，他說：「我在挪伯親眼看見耶西的兒子到了亞希突的兒子亞希米勒那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","亞希米勒為他求問耶和華，給他食物，還把非利士人歌利亞的刀給了他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","於是，掃羅派人把挪伯的祭司——亞希突的兒子亞希米勒及其家人都召來。他們都來到王面前。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","掃羅說：「亞希突的兒子，聽著！」亞希米勒答道：「我主啊，我在這裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","掃羅說：「你為什麼和耶西的兒子一同謀害我？你為什麼把食物和刀給他，又為他求問耶和華，使他像今天這樣背叛我，伺機害我呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","亞希米勒答道：「王的臣僕中有誰像大衛那樣忠心呢？他是王的女婿，又是王的護衛長，在王室中受尊重。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","那也不是我第一次為他求問耶和華，求王不要因這事加罪於我或我的家人，因為僕人我對這事一無所知。」 ");
INSERT INTO cmncbt_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","王卻說：「亞希米勒啊，你和你全家都必死無疑！」 ");
INSERT INTO cmncbt_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","他就命令身旁的護衛，說：「把這些耶和華的祭司殺掉，因為他們跟大衛同謀，明知道大衛在潛逃，卻不來告訴我。」掃羅的臣僕不願意下手殺害耶和華的祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","掃羅就對多益說：「你去把祭司殺掉！」以東人多益就殺了他們。那天，他下手殺了八十五個穿細麻布以弗得的祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","他又把祭司城挪伯的男女老少、牛羊和驢全部用刀殺掉。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","但是，亞希突之子亞希米勒有個兒子亞比亞他逃出去，投奔了大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","亞比亞他把掃羅屠殺耶和華祭司的事告訴了大衛， ");
INSERT INTO cmncbt_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","大衛說：「那天我見以東人多益在那裡，就知道他一定會告訴掃羅。是我連累了你父親一家。 ");
INSERT INTO cmncbt_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","你就放心留在我這裡，不要害怕，想殺你的人，也想要殺我。你在我這裡很安全。」 ");
INSERT INTO cmncbt_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","一天，大衛得知非利士人正在攻打基伊拉，搶掠麥場， ");
INSERT INTO cmncbt_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","便求問耶和華：「我可以去攻打非利士人嗎？」耶和華答道：「你可以去攻打非利士人，營救基伊拉。」 ");
INSERT INTO cmncbt_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","大衛的部下卻對他說：「我們在猶大這裡尚且膽戰心驚，何況去基伊拉攻打非利士軍隊呢！」 ");
INSERT INTO cmncbt_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","大衛再求問耶和華，耶和華答道：「到基伊拉去吧，我一定把非利士人交在你手裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","於是，大衛和部下到基伊拉去攻打非利士人，大敗敵人，奪取了他們的牲畜，救出基伊拉人。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","亞希米勒的兒子祭司亞比亞他到基伊拉投奔大衛時，把以弗得也帶了去。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","掃羅得知大衛在基伊拉，就說：「這一次是上帝把他交在我手中了，因為他竟然自投網羅，進入有門有閂的城。」 ");
INSERT INTO cmncbt_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","掃羅召集全軍準備攻打基伊拉，圍困大衛和他的部下。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","大衛知道了掃羅的計謀，便吩咐祭司亞比亞他把以弗得帶來， ");
INSERT INTO cmncbt_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","然後說：「耶和華，以色列的上帝啊，僕人聽說掃羅要來毀滅基伊拉城，因為我在這裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","基伊拉的人會不會把我交給掃羅呢？掃羅是不是像我聽說的那樣要來這裡呢？耶和華，以色列的上帝啊，求你告訴我。」耶和華說：「掃羅一定會來。」 ");
INSERT INTO cmncbt_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","大衛又問耶和華：「基伊拉的人會不會把我和我的部下交給掃羅呢？」耶和華說：「他們一定會。」 ");
INSERT INTO cmncbt_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","於是，大衛率領自己的六百部下離開基伊拉，到處流浪。掃羅得知大衛已經離開基伊拉，就不去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","大衛住在曠野的堡壘或西弗曠野的山區。掃羅天天搜捕大衛，但上帝沒有把大衛交在他的手中。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","大衛在西弗曠野的何利沙得知掃羅要來殺他。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","掃羅的兒子約拿單去何利沙見大衛，鼓勵大衛堅定地信靠上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","他對大衛說：「不要害怕，我父親掃羅害不了你。你將做以色列的王，我將做你的宰相。我父親也明白這一點。」 ");
INSERT INTO cmncbt_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","二人在耶和華面前立了約。之後，大衛仍留在何利沙，約拿單則回家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","西弗人去基比亞見掃羅，說：「大衛就躲在我們那裡，在曠野南面哈基拉山上何利沙的堡壘裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","王啊，你隨時都可以下來，我們一定把他交在王的手裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","掃羅說：「願耶和華賜福給你們！因為你們體恤我。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","我聽說他非常狡猾，你們再回去弄清楚他的行蹤及誰在那裡見過他， ");
INSERT INTO cmncbt_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","查明他的藏身之處，回來如實告訴我，然後我會與你們同去。如果他在猶大境內，我要搜遍千家萬戶，找到他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","於是，西弗人先回去了。當時大衛和他的部下在曠野南面的亞拉巴，即瑪雲曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","大衛聽說掃羅和手下正在搜尋他，便率領部下前往瑪雲曠野的磐石，住在那裡。掃羅得知後，便去瑪雲曠野追趕大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","掃羅在山這邊走，大衛和他的部下在山那邊走，急急忙忙地躲避掃羅。掃羅和他的手下四面包圍過來，眼看就要抓住他們了。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","這時，掃羅的信使前來稟報，說非利士人前來犯境，請王速回。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","掃羅只好放棄追趕大衛，回師迎戰非利士人。因此，那地方叫「脫險巖」。 ");
INSERT INTO cmncbt_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","後來，大衛從那裡轉移到隱·基底的堡壘裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","掃羅追擊非利士人回來，得知大衛在隱·基底的曠野， ");
INSERT INTO cmncbt_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","就率領三千以色列精兵去野羊巖附近搜索大衛和他的部下。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","他們來到路旁的一處羊圈，那裡有一個山洞，掃羅進去大解。大衛和他的部下就躲在洞的深處。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","大衛的部下對大衛說：「耶和華說過要把你的仇敵交在你手中，任你處置，今天機會來了。」大衛就爬過去，偷偷割了掃羅外袍的一角。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","事後，大衛心裡不安， ");
INSERT INTO cmncbt_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","他對部下說：「我不該做這樣的事，我主是耶和華所膏立的王，我絕不出手傷害他，因為他是耶和華所膏立的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","大衛用這些話攔住他的部下，不讓他們殺掃羅。 掃羅起來離開山洞走了， ");
INSERT INTO cmncbt_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","大衛隨後也來到洞外，在後面喊掃羅：「我主我王啊！」掃羅回頭一看，見大衛俯伏在地，向他下拜。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","大衛對掃羅說：「你為什麼聽信讒言，認為我要謀害你呢？ ");
INSERT INTO cmncbt_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","你現在親眼看見了，剛才在山洞裡，耶和華把你交在我手中，有人叫我殺你，我卻不肯，因為你是耶和華所膏立的王，我不會動手傷害你。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","我父請看，你的這塊袍子在我手中。我割下了你的袍角，沒有殺你，現在你應該明白我並未圖謀背叛你。我沒有對不起你，你卻要置我於死地。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","願耶和華在你我之間判定是非，替我伸冤，我卻不會動手傷害你。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","俗語說，『惡事出於惡人』，所以我不會動手傷害你。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","以色列王出來要捉拿誰呢？一條死狗嗎？一隻跳蚤嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","願耶和華做我們的審判官，在你我之間判定是非。願耶和華鑒察，為我伸冤，從你手中拯救我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","大衛說完了，掃羅問道：「我兒大衛啊！是你嗎？」便放聲大哭起來。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","掃羅對大衛說：「你比我公義，因為你善待我，我卻惡待你。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","你今天使我明白你善待了我，耶和華把我交在你手中，你卻沒有下手殺我。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","有誰會讓自己手中的仇敵平安離去呢？願耶和華因你今日善待我而賜福你。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","我知道你必做王，以色列國必在你手中得到堅固。 ");
INSERT INTO cmncbt_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","現在請你憑耶和華向我起誓，你不會殺害我的子孫，滅絕我的後代。」 ");
INSERT INTO cmncbt_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","大衛便向掃羅起誓。之後，掃羅回家了，大衛和部下也回堡壘去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","撒母耳死了，以色列人都聚在一起哀悼他，把他安葬在拉瑪他自己的墳地裡。之後，大衛到了巴蘭的曠野。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","瑪雲有個富翁擁有三千隻綿羊和一千隻山羊，他的產業在迦密。當時他正在迦密剪羊毛。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","他名叫拿八，是迦勒族人，妻子名叫亞比該，既聰慧又漂亮。拿八粗暴兇惡。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","大衛在曠野得知拿八正在剪羊毛， ");
INSERT INTO cmncbt_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","就派十個部下到迦密去見拿八，吩咐他們以他的名義向拿八問安， ");
INSERT INTO cmncbt_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","對拿八說：「願你和你全家平安，願你一切順利！ ");
INSERT INTO cmncbt_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","我聽說你正在剪羊毛。你的牧人與我們在迦密的時候，我們沒有欺負過他們，他們沒有丟過任何東西。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","你問問你的僕人就知道了。請你恩待我的部下，因為今天是好日子，求你隨手賞一點東西給僕人們和晚輩我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","大衛的部下就去把大衛的話告訴拿八，等候他的答覆。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","拿八說：「大衛是誰？耶西的兒子是誰？這些日子有很多僕人逃離主人， ");
INSERT INTO cmncbt_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","我怎能把餅、水和為剪羊毛者預備的肉分給一群來歷不明的人呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","大衛的部下回去把拿八的話稟告大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","大衛聽了，就吩咐眾人備刀，他自己也帶了刀去拿八那裡。大衛帶了四百人去，留下二百人看守輜重。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","拿八的一個僕人告訴拿八的妻子亞比該說：「大衛從曠野派人來向我們主人問安，主人卻辱罵他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","那些人對我們很好，從來不欺負我們。我們跟他們一起在田野的時候，從來沒有丟過任何東西。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","我們在他們附近牧羊的時候，他們晝夜不斷地保護我們。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","所以，請你趕快想個法子，不然主人和他全家恐怕都會大難臨頭。主人是個兇暴的人，沒有人敢跟他說話。」 ");
INSERT INTO cmncbt_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","亞比該連忙用驢馱上二百塊餅、兩皮袋酒、五隻宰好了的羊、三十七升烤麥、一百塊葡萄餅和二百塊無花果餅， ");
INSERT INTO cmncbt_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","又吩咐僕人說：「你們先去吧！我隨後就來。」她沒有把這事告訴丈夫拿八。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","她騎著驢下山的時候，就看見大衛和他的部下迎面而來。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","大衛曾說：「我在曠野保護這人的羊群，使牠們不致丟失，真是枉費功夫。他竟以怨報德。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","如果我讓他家裡一個男子活到明早，願上帝重重地懲罰我！」 ");
INSERT INTO cmncbt_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","亞比該看見大衛，連忙下驢俯伏下拜。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","她俯伏在大衛腳前說：「我主啊，我願意承擔一切罪過，請聽婢女說。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","請不要理會拿八那個惡徒，他人如其名，是個名符其實的蠢人。當時婢女沒有見到你派來的使者。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","我主啊，既然耶和華阻止你親手殺人報仇，我就憑永活的耶和華和你的性命起誓，願你的仇敵和傷害你的人都像拿八一樣沒有好下場。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","現在，請把婢女帶來的禮物分給你的部下吧。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","請饒恕婢女的罪過，耶和華必使你的子孫世代做王，因為你是在為耶和華而戰，願你一生沒有過錯。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","你就是被人追殺，也會在你的上帝耶和華的保護下安然無恙。你敵人的性命卻要像石頭一樣被耶和華用投石器拋出去。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_30","010_25_30","1SA","25","30","31","如果你現在沒有殺人報仇，傷害無辜，到了耶和華照應許賜福給你、立你做以色列王的時候，你就不會心裡不安了。我主啊，耶和華賜福給你的時候，求你不要忘了婢女。」 ");
INSERT INTO cmncbt_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","大衛對亞比該說：「以色列的上帝耶和華當受稱頌！祂今天派你來見我。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","你很有見識，你今天攔阻我親手殺人復仇，值得稱讚。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","我憑阻止我殺你的以色列的上帝——永活的耶和華起誓，若不是你趕來迎接我，拿八家中不會有一個男子活到明天早上。」 ");
INSERT INTO cmncbt_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","大衛接受了亞比該的禮物，對她說：「安心回家吧，我答應你的請求。」 ");
INSERT INTO cmncbt_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","她回到家時，拿八正在大擺宴席，排場如御宴。她見拿八心情愉快，喝得酩酊大醉，就什麼也沒告訴他，等第二天早上再說。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","次日清晨，拿八酒醒以後，他妻子把發生的一切告訴他，他嚇得昏死過去，身體僵硬如石。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","過了十天，耶和華擊打拿八，他就死了。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","大衛聽見拿八的死訊，就說：「讚美耶和華！拿八羞辱我，祂為我伸了冤，又阻止僕人行惡。祂使拿八得到了報應。」後來，大衛差遣使者去向亞比該求婚。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","他的使者就啟程到迦密去向亞比該傳達大衛的心意。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","亞比該聽了，立刻俯伏在地上說：「婢女願意效勞，為我主的僕人洗腳。」 ");
INSERT INTO cmncbt_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","她連忙騎上驢，帶了五個侍女，跟隨大衛的使者前去，做了大衛的妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","大衛已經娶了耶斯列人亞希暖，她們二人就同做大衛的妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","掃羅已經把自己的女兒、大衛的妻子米甲嫁給了迦琳人拉億的兒子帕提。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","西弗人到基比亞見掃羅，說：「大衛正躲在曠野附近的哈基拉山中。」 ");
INSERT INTO cmncbt_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","掃羅就帶領三千以色列精兵到西弗的曠野去追捕大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","他們在曠野附近路邊的哈基拉山上紮營。大衛在曠野聽說掃羅追來了， ");
INSERT INTO cmncbt_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","就派人去打探消息，得知掃羅的追兵果然已到。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","大衛來到掃羅的營地，看見了他和他的元帥尼珥的兒子押尼珥睡覺的地方，他睡在軍營中間，其他人圍繞著他紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","大衛問赫人亞希米勒和洗魯雅的兒子約押的兄弟亞比篩：「誰願意跟我到掃羅的營裡？」亞比篩答道：「我願意。」 ");
INSERT INTO cmncbt_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","大衛和亞比篩就趁夜間走進掃羅的軍營，發現掃羅正在熟睡，他的矛插在地上，靠近他的頭，押尼珥和其他人睡在他周圍。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","亞比篩對大衛說：「現在上帝把你的敵人交在你手中了，讓我一矛把他釘在地上，決不用刺第二下。」 ");
INSERT INTO cmncbt_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","大衛卻說：「不要殺他，誰殺害耶和華所膏立的王，都難逃罪責。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","我憑永活的耶和華起誓，耶和華必親手擊殺他。他要麼壽終而死，要麼命喪沙場。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","我在耶和華面前絕不敢出手傷害祂所膏立的王。我們拿走他旁邊的矛和水瓶吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","大衛拿上掃羅的矛和水瓶便同亞比篩離開了，沒有人看見，沒有人知道，他們都在沉睡，沒有人醒來，因為耶和華使他們都熟睡了。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","大衛爬上營地對面的山坡，遠遠地站在山頂上，與他們相距很遠。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","他呼喊掃羅的士兵和尼珥的兒子押尼珥：「押尼珥，你回答我！」押尼珥問道：「你是誰，竟敢在王面前喊叫？」 ");
INSERT INTO cmncbt_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","大衛說：「你不是勇士嗎？在以色列有誰比得上你呢？有人來刺殺你的王你的主，你為何沒有保護他呢？ ");
INSERT INTO cmncbt_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","你失職了。我憑永活的耶和華起誓，你們都該死。因為你們沒有保護你們的主——耶和華所膏立的王。你看看王頭旁的矛和水瓶在哪裡？」 ");
INSERT INTO cmncbt_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","掃羅聽出是大衛的聲音，就說：「我兒大衛！是你嗎？」大衛答道：「我主我王啊，是我。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","我主為什麼又要追殺僕人呢？我做錯了什麼，犯了什麼罪？ ");
INSERT INTO cmncbt_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","我主我王，請聽僕人說，如果是耶和華使你與我作對，願祂悅納我獻上的祭物；如果這是出於人的主意，願他們在耶和華面前受咒詛。因為他們趕我離開耶和華所賜的產業，叫我去供奉其他神明。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","求你不要讓我死在遠離耶和華的異鄉！以色列王為何要像在山上獵殺鷓鴣一樣追捕一隻跳蚤呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","掃羅說：「我犯罪了。我兒大衛，你回來吧，我不會再傷害你，因為你今日保存了我的性命。我真是糊塗，犯了大錯。」 ");
INSERT INTO cmncbt_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","大衛答道：「王的矛在這裡，請派一個人來拿回去吧。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","耶和華獎賞公義、信實的人。今天耶和華把你交在我手中，但我不願下手傷害耶和華所膏立的王。 ");
INSERT INTO cmncbt_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","我今天保存了你的性命，願耶和華也保存我的性命，救我脫離一切患難。」 ");
INSERT INTO cmncbt_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","掃羅對大衛說：「我兒大衛，願你蒙福。你一定能建功立業，戰勝仇敵。」於是，大衛起身離開，掃羅也回家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","大衛心裡想：「終有一天，我會死在掃羅手裡，我最好逃到非利士人那裡。這樣，掃羅就不會在以色列到處追捕我了，我便可以逃離他的手。」 ");
INSERT INTO cmncbt_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","於是，大衛率領他的六百個隨從去投靠瑪俄的兒子迦特王亞吉。 ");
INSERT INTO cmncbt_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","他部下的家眷和他的兩位妻子耶斯列人亞希暖和拿八的遺孀迦密人亞比該也跟他一同住在迦特王亞吉那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","掃羅聽到這個消息，就不再追捕他了。 ");
INSERT INTO cmncbt_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","大衛對亞吉說：「如果你開恩，就讓我到郊野的一個城邑去住吧，何必讓僕人與王一同住在都城呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","亞吉當天把洗革拉賜給他，因此那地方至今仍屬猶大王。 ");
INSERT INTO cmncbt_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","大衛在非利士人的地方共住了一年零四個月。 ");
INSERT INTO cmncbt_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","他率領部下襲擊基述人、基色人和亞瑪力人，這些人自古以來就住在遠至書珥和埃及一帶的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","大衛攻打那一帶，殺死所有的人，搶走牛、羊、驢、駱駝和衣物，回去見亞吉。 ");
INSERT INTO cmncbt_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","當亞吉問：「你們今天攻打了哪裡？」大衛會說：「攻打了猶大南部」，或說：「攻打了耶拉篾南部」，或說：「攻打了基尼南部。」 ");
INSERT INTO cmncbt_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","大衛把那地方的人都殺掉，一個也不帶到迦特，因為他害怕他們會洩露真相。大衛在非利士人那裡居住的時候，常常這樣做。 ");
INSERT INTO cmncbt_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","亞吉相信了大衛的話，心裡想：「以色列人恨透了大衛，他必永遠做我的僕人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","非利士人召集大軍與以色列人交戰。亞吉對大衛說：「你應該明白，你和部下要隨我一起出戰。」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","大衛答道：「僕人願意效勞。」亞吉說：「很好！你就終生做我的護衛吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","那時撒母耳已經死了，以色列舉國都為他哀悼，把他葬在他的家鄉拉瑪。當時，掃羅已把所有占卜和行巫術的都逐出了以色列。 ");
INSERT INTO cmncbt_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","非利士人集合起來，在書念紮營，掃羅率領以色列軍隊在基利波紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","掃羅看見非利士軍隊聲勢浩大，嚇得膽戰心驚， ");
INSERT INTO cmncbt_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","就求問耶和華，但耶和華沒有藉著夢、烏陵或先知回答他。 ");
INSERT INTO cmncbt_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","於是，掃羅命令臣僕找一個巫婆來，好求問她。臣僕在隱·多珥找到一個巫婆。 ");
INSERT INTO cmncbt_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","掃羅喬裝打扮，由兩個人陪同乘夜趕到那婦人家裡，說：「請你用法術把我要求問的亡靈招上來吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","婦人對他說：「你知道掃羅剷除了國內占卜的和行巫術的，你為何來陷害我，置我於死地？」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","掃羅憑耶和華向婦人起誓，說：「我憑永活的耶和華起誓，你必不會因為此事而受到懲罰。」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","婦人問道：「你想讓我招誰上來呢？」掃羅答道：「招撒母耳上來。」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","婦人看見了撒母耳，就驚叫起來，對掃羅說：「你是掃羅，你為什麼騙我呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","掃羅王對她說：「不要害怕，你看見什麼了？」婦人說：「我看見一個靈從地裡上來。」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","掃羅說：「他是什麼模樣？」婦人說：「是個身披長袍的老人。」掃羅知道是撒母耳，便俯伏在地，向他下拜。 ");
INSERT INTO cmncbt_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","撒母耳對掃羅說：「你為什麼打擾我，招我上來呢？」掃羅答道：「我深陷困境，非利士人與我們交戰，上帝也撇棄了我，不再藉著先知或夢來回答我。因此，我只好招你上來，好告訴我該怎麼辦。」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","撒母耳說：「既然耶和華已經離棄了你，與你為敵，你為什麼還來問我？ ");
INSERT INTO cmncbt_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","耶和華應驗了祂藉著我所說的預言，祂已把你的國權奪去，交給了你的同胞大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","耶和華今天這樣對待你，是因為你沒有聽從祂的吩咐，沒有把祂憎惡的亞瑪力人滅絕。 ");
INSERT INTO cmncbt_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","耶和華必把你和以色列人交在非利士人手裡，明天你和你的兒子們必跟我在一起了。耶和華必把以色列的軍隊交在非利士人手裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","掃羅聽了撒母耳的話，頓時嚇得渾身僵直，倒在地上。他因一天一夜沒有進食，已經毫無力氣。 ");
INSERT INTO cmncbt_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","婦人到掃羅跟前，看見他驚恐萬分，就對他說：「婢女冒著生命危險服從你的命令，照你的吩咐做了。 ");
INSERT INTO cmncbt_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","現在，請你聽婢女的話，讓我給你一些食物吃，你好有體力趕路。」 ");
INSERT INTO cmncbt_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","掃羅不肯，說：「我不吃。」他的隨從和婦人再三勸告，他才同意了，從地上起來坐到床上。 ");
INSERT INTO cmncbt_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","婦人連忙宰了家中一隻小肥牛，又和麵烤了無酵餅， ");
INSERT INTO cmncbt_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","擺在掃羅和他的隨從面前，他們吃完後，當晚就離開了。 ");
INSERT INTO cmncbt_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","非利士人把全部軍隊聚集在亞弗，以色列軍則在耶斯列水泉旁紮營。 ");
INSERT INTO cmncbt_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","非利士首領統率以百人和千人為單位的士兵向前推進，大衛和他的部下跟著亞吉走在隊伍後面。 ");
INSERT INTO cmncbt_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","非利士人的官長說：「這些希伯來人在這裡做什麼？」亞吉告訴他們說：「這是以色列王掃羅的臣僕大衛，他追隨我有一段日子了，自從他投奔我以來，我沒發現他有什麼過錯。」 ");
INSERT INTO cmncbt_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","他們卻生氣地說：「請送這個人回到你安置他的地方，他不可和我們一起去打仗，免得他在戰場上倒戈。他提著我們的腦袋去重投故主豈不是最好的方法嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","以前婦女們跳舞歌唱『掃羅殺死千千，大衛殺死萬萬』，歌頌的不就是這個大衛嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","亞吉便叫大衛過來，對他說：「我憑永活的耶和華起誓，你一向忠心耿耿，自從你投奔我以來，我沒發現你有什麼過錯，我很願意你與我一同作戰，只是眾首領不贊成。 ");
INSERT INTO cmncbt_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","你安心地回去吧，免得他們不悅。」 ");
INSERT INTO cmncbt_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","大衛說：「我究竟做錯了什麼？自從僕人投奔你以來，你發現僕人有什麼過錯？為什麼不讓我為我主我王殺敵呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","亞吉說：「你在我眼中就像上帝的天使一樣好，只是非利士眾官長反對你與我們一起出戰。 ");
INSERT INTO cmncbt_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","明天一早，你就和從掃羅手下投奔你的人啟程回去吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","於是，大衛和部下清早起來返回非利士，非利士軍則前往耶斯列。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","第三天，大衛率領部下回到洗革拉的時候，發現亞瑪力人襲擊了南地和洗革拉，攻破了洗革拉城，把全城燒毀， ");
INSERT INTO cmncbt_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","並擄走了城內的婦女及所有老少，沒有殺任何人。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","大衛和部下來到洗革拉城，看到城被燒毀，妻子兒女都被擄走了， ");
INSERT INTO cmncbt_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","便放聲大哭，直哭得精疲力盡。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","大衛的兩個妻子耶斯列人亞希暖和拿八的遺孀迦密人亞比該也一起被擄走了。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","跟隨大衛的人因自己的兒女被擄去，心裡很痛苦，商議要用石頭打死大衛。大衛深陷困境，但他靠著他的上帝耶和華得到了力量。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","大衛吩咐亞希米勒的兒子亞比亞他祭司把以弗得拿來，亞比亞他就拿給他。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","大衛求問耶和華，說：「我該追趕敵人嗎？我能追上他們嗎？」耶和華答道：「追趕他們吧，你必能追上他們，救回一切。」 ");
INSERT INTO cmncbt_vpl VALUES ("S130_9","010_30_9","1SA","30","9","10","於是，大衛率領六百名部下前去追趕，到了比梭溪，有二百人因為太累而不能過溪，就留在那裡。大衛率領其餘的四百人繼續追趕。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","他們在田野遇見一個埃及人，就把他帶到大衛那裡。他們給他餅吃，給他水喝， ");
INSERT INTO cmncbt_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","還給他一塊無花果餅和兩個葡萄餅。他吃完後，恢復了體力，因為這人已經三天三夜沒吃沒喝了。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","大衛問他：「你是誰的僕人？你從哪裡來？」他答道：「我是埃及人，是亞瑪力人的奴僕。三天前，主人因為我患病把我撇棄了。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","我們襲擊了基利提的南方，猶大地區和迦勒南部，還燒毀了洗革拉。」 ");
INSERT INTO cmncbt_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","大衛又問他：「你可以領我去這些襲擊者那裡嗎？」他答道：「你先憑上帝向我起誓，你不殺我，也不把我交給我的主人，我就帶你去。」 ");
INSERT INTO cmncbt_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","他帶著大衛找到那裡，見亞瑪力人正散佈在各處吃喝狂歡，因為他們從非利士和猶大搶奪了很多財物。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","大衛率領部下從黎明攻打他們，直到次日黃昏。除了四百個青年騎駱駝逃脫外，亞瑪力人全軍覆沒。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","大衛奪回亞瑪力人擄去的一切，包括他的兩個妻子。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","他盡數奪回了被擄去的男女老少和財物， ");
INSERT INTO cmncbt_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","也奪了所有的牛羊。他的部下把這些牛羊趕到自己的牲畜前面，說：「這是大衛的戰利品。」 ");
INSERT INTO cmncbt_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","大衛回到留在比梭溪的那二百名因為太疲乏而沒有同去的人那裡，他們出來迎接大衛和眾隨從，大衛也上前問候他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","大衛隨從中那些惡徒和無賴說：「他們沒有跟我們一起去打仗，我們搶回來的東西不應分給他們，只讓他們帶走自己的妻子和兒女就好了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","大衛說：「弟兄們，這一切是耶和華賜給我們的，我們不可不分給他們，因為是耶和華保護我們，把敵人交在了我們手裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","誰能接受你們的說法呢？上陣打仗的和看守裝備的應該得到一樣的待遇。」 ");
INSERT INTO cmncbt_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","從那天開始，大衛就把這原則定為以色列的律例和典章，沿用至今。 ");
INSERT INTO cmncbt_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","大衛來到洗革拉，把部分戰利品送給他的朋友猶大的長老們，說：「這些禮物是從耶和華的敵人那裡奪來送給你們的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","大衛把禮物送給住在伯特利、南地的拉末、雅提珥、 ");
INSERT INTO cmncbt_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","亞羅珥、息末、以實提莫、 ");
INSERT INTO cmncbt_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","拉哈勒、耶拉篾和基尼各城、 ");
INSERT INTO cmncbt_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","何珥瑪、歌拉珊、亞撻、 ");
INSERT INTO cmncbt_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","希伯崙以及他和部下所到之處的人。 ");
INSERT INTO cmncbt_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","非利士人與以色列人交戰，以色列人敗逃，許多人在基利波山被殺。 ");
INSERT INTO cmncbt_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","非利士人窮追掃羅及其眾子，殺了掃羅的兒子約拿單、亞比拿達和麥基舒亞。 ");
INSERT INTO cmncbt_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","掃羅周圍戰事激烈，他被弓箭手發現後射成重傷， ");
INSERT INTO cmncbt_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","就對為他拿兵器的人說：「拔出你的刀來刺死我吧，免得那些未受割禮的人來刺殺和凌辱我。」但拿兵器的人非常害怕，不敢動手，掃羅就拿起刀來，伏刀自盡了。 ");
INSERT INTO cmncbt_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","拿兵器的人看見掃羅已死，也伏刀自盡了。 ");
INSERT INTO cmncbt_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","那一天，掃羅和他三個兒子，以及為他拿兵器的人和他的軍隊都死了。 ");
INSERT INTO cmncbt_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","平原一帶和約旦河對面的以色列人見以色列軍敗逃、掃羅及其眾子已死，都棄城而逃。於是，非利士人佔據了那些城邑。 ");
INSERT INTO cmncbt_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","次日，非利士人來剝陣亡者的衣物，發現掃羅和他的三個兒子橫屍基利波山， ");
INSERT INTO cmncbt_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","就割下掃羅的頭顱，剝下他的盔甲，並派人去非利士全境，在他們偶像的廟裡及民眾中通告消息。 ");
INSERT INTO cmncbt_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","非利士人把掃羅的盔甲放在亞斯她錄神廟裡，把他的屍體釘在伯·珊城牆上。 ");
INSERT INTO cmncbt_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","基列·雅比人聽見非利士人對掃羅的所作所為， ");
INSERT INTO cmncbt_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","他們所有的勇士就連夜趕到伯·珊，從牆上取下掃羅和他兒子們的屍體，運到雅比火化， ");
INSERT INTO cmncbt_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","把骨灰葬在雅比的柳樹下，又為他們禁食了七天。");
INSERT INTO cmncbt_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","大衛戰勝了亞瑪力人之後便回到洗革拉，在那裡住了兩天。那時掃羅已經死了。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","第三天，有一個衣服撕裂、頭蒙灰塵的人從掃羅軍營中跑到大衛面前，俯伏下拜。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","大衛問他：「你從哪裡來？」那人答道：「我是從以色列軍營逃出來的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","大衛說：「請告訴我那邊的情況。」他說：「以色列軍潰逃，傷亡慘重，就連掃羅和他兒子約拿單都死了！」 ");
INSERT INTO cmncbt_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","大衛又問報信的青年：「你怎麼知道掃羅和他兒子約拿單死了？」 ");
INSERT INTO cmncbt_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","青年說：「我偶然到基利波山，看見掃羅在那裡倚槍而立，敵人的戰車騎兵緊緊追來。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","他回頭看到我，便呼喚我。我說，『我在這裡。』 ");
INSERT INTO cmncbt_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","他問我是什麼人。我告訴他我是亞瑪力人。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","掃羅說他痛苦不堪，卻又死不掉，要我殺了他。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","我知道他身受重傷，必死無疑，就把他殺了，並取下他頭上的王冠和臂上的鐲子帶來獻給我主。」 ");
INSERT INTO cmncbt_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","大衛就撕裂衣服，他的隨從也撕裂衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","他們因掃羅、他的兒子約拿單和耶和華的子民以色列同胞陣亡而悲哀痛哭，禁食直到黃昏。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","大衛又問報信的青年：「你是哪裡的人？」他答道：「我是寄居在以色列的亞瑪力人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","大衛說：「你怎麼敢下手殺耶和華所膏立的王？ ");
INSERT INTO cmncbt_vpl VALUES ("S21_15","011_1_15","2SA","1","15","16","你是咎由自取！因為你親口承認自己殺了耶和華所膏立的王。」大衛隨即命令一個年輕的隨從殺死他，隨從便殺死了他。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","大衛作了一首輓歌哀悼掃羅和他兒子約拿單， ");
INSERT INTO cmncbt_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","並吩咐人教導猶大人唱這首弓歌。這首歌記在《雅煞珥書》上，歌詞說： ");
INSERT INTO cmncbt_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","「以色列啊， 你榮耀的王伏屍山上， 勇士竟然倒下！ ");
INSERT INTO cmncbt_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","不要在迦特宣告， 不要在亞實基倫的街上傳揚， 免得非利士的婦女幸災樂禍， 免得未受割禮之人的女子歡喜雀躍。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","「基利波山啊，願你沒有雨露， 你的田地不長獻祭用的五穀， 因為那裡有勇士鏽污的盾牌， 掃羅的盾牌沒有抹油。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","「約拿單的弓射敵無數， 掃羅的劍不殺強敵不收回。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","「掃羅和約拿單深受愛戴， 生死不分離。 他們比鷹更敏捷， 比獅子還強壯。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","「以色列的女子啊， 為掃羅哀哭吧！ 他曾使你們衣服華美， 穿金戴銀。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","「勇士竟戰死沙場！ 約拿單竟伏屍山上！ ");
INSERT INTO cmncbt_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","我的兄弟約拿單啊， 我為你悲傷， 你對我情深義重， 你對我的愛勝過女人的戀情。 ");
INSERT INTO cmncbt_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","「勇士竟然倒下！ 兵器竟然耗損！」 ");
INSERT INTO cmncbt_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","這事以後，大衛求問耶和華：「我可以回到猶大的城邑嗎？」耶和華說：「可以。」大衛又問：「我應該回到哪一座城呢？」耶和華說：「希伯崙。」 ");
INSERT INTO cmncbt_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","大衛就帶著他的兩個妻子耶斯列人亞希暖和迦密人拿八的遺孀亞比該，一起上到希伯崙。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","他還把部下和他們的家屬一起帶去，住在希伯崙地區的城邑。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","猶大人到希伯崙膏立大衛做猶大支派的王。 大衛聽說是基列·雅比人埋葬了掃羅， ");
INSERT INTO cmncbt_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","就派使者去告訴他們：「你們這樣厚待你們的主人掃羅，把他安葬，願耶和華賜福給你們！ ");
INSERT INTO cmncbt_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","願耶和華以慈愛和信實待你們，我也會厚待你們，因為你們做了這事。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","現在你們的主掃羅已經死了，猶大支派已經膏立我做他們的王，你們要剛強勇敢。」 ");
INSERT INTO cmncbt_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","那時，掃羅的元帥——尼珥的兒子押尼珥帶著掃羅的兒子伊施·波設過河來到瑪哈念， ");
INSERT INTO cmncbt_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","立他為王統治基列、亞書利、耶斯列、以法蓮、便雅憫和以色列其餘的地方。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","掃羅的兒子伊施·波設四十歲登基，統治以色列兩年。猶大支派則跟隨大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","大衛在希伯崙做王統治猶大支派七年半。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","有一次，尼珥的兒子押尼珥帶領掃羅的兒子伊施·波設的軍隊，從瑪哈念前往基遍。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","洗魯雅的兒子約押帶領大衛的軍隊出來，在基遍池與他們相遇。一方坐在池這邊，一方坐在池那邊。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","押尼珥對約押說：「讓雙方的青年起來，在我們面前較量一下吧。」約押說：「好啊。」 ");
INSERT INTO cmncbt_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","於是，伊施·波設的便雅憫人和大衛的僕人雙方都起身選了十二人出來， ");
INSERT INTO cmncbt_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","他們各自抓住對方的頭髮，用刀刺對方的肋旁，同歸於盡。於是基遍的那個地方叫「刀田」。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","那天，兩軍惡戰，押尼珥和以色列人被大衛的人馬殺敗。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","當時，洗魯雅的三個兒子約押、亞比篩和亞撒黑都在場。亞撒黑跑得飛快如田野的鹿， ");
INSERT INTO cmncbt_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","他跟在押尼珥後面，不偏不離，窮追不捨。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","押尼珥回頭問道：「你是亞撒黑嗎？」亞撒黑說：「正是。」 ");
INSERT INTO cmncbt_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","押尼珥說：「你離開我，去追趕別人，奪取他的兵器吧。」但亞撒黑還是窮追不捨。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","押尼珥又對他說：「別追我了，非逼我殺你嗎？我若殺了你，還有何顏面見你哥哥約押呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","但亞撒黑還是不肯甘休。押尼珥就用槍柄刺入他的肚腹，穿透了他的後背，他便倒地身亡。眾人趕到那裡，都停了下來。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","但約押和亞比篩卻繼續追趕押尼珥。太陽落山時，他們追到了基亞附近的亞瑪山，通往基遍曠野的路旁。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","便雅憫人在押尼珥的帶領下聚集在一個山頭上。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","押尼珥向約押喊道：「我們非要無休止地殺下去嗎？難道你不知道這樣下去必有苦果嗎？你什麼時候才命令你的人停止追殺自己的同胞呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","約押說：「我憑永活的上帝起誓，你要是不這樣說，我們會一直追到天亮。」 ");
INSERT INTO cmncbt_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","於是，約押吹響號角，所有的人便停止了戰鬥，不再追擊以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","押尼珥和隨從連夜趕路，穿過了亞拉巴，過了約旦河，第二天又馬不停蹄地走了一個上午，回到瑪哈念。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","約押追趕押尼珥回來後細點人數，發現除亞撒黑外大衛的軍隊還損失了十九個人。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","大衛的軍隊殺了三百六十個跟隨押尼珥的便雅憫人。 ");
INSERT INTO cmncbt_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","約押和他的隨從把亞撒黑送到伯利恆，葬在他父親的墳墓裡。然後，他們整夜趕路，黎明的時候回到了希伯崙。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","掃羅和大衛兩家長期爭戰，大衛家的勢力越來越強，掃羅家卻日益衰微。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","大衛在希伯崙生的兒子有耶斯列人亞希暖所生的長子暗嫩， ");
INSERT INTO cmncbt_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","迦密人拿八的遺孀亞比該所生的次子基利押，基述王達買的女兒瑪迦所生的三子押沙龍， ");
INSERT INTO cmncbt_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","哈及所生的四子亞多尼雅，亞比她所生的五子示法提雅， ");
INSERT INTO cmncbt_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","大衛的妻子以格拉所生的六子以特念。大衛的這些兒子都是在希伯崙生的。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","在掃羅和大衛兩家爭戰期間，押尼珥在掃羅家權勢日增。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","他跟掃羅的一個妃嬪、愛亞的女兒利斯巴通姦，伊施·波設問他：「你為什麼睡我父親的妃嬪呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","押尼珥聽了非常憤怒，說：「難道我是猶大的走狗嗎？我至今還這樣厚待你父親掃羅家和他的親戚朋友，沒有把你交給大衛，今天你竟為了這個女人來責備我！ ");
INSERT INTO cmncbt_vpl VALUES ("S23_9","011_3_9","2SA","3","9","10","倘若我不照著耶和華應許大衛的誓言，把掃羅的江山奪過來交給大衛，讓他統治全以色列和猶大，從但到別示巴，願耶和華重重地懲罰我！」 ");
INSERT INTO cmncbt_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","伊施·波設一句話也不敢答，因為他害怕押尼珥。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","押尼珥派使者送信給大衛，說：「這是誰的土地呢？如果你與我立約，我必幫助你統一以色列。」 ");
INSERT INTO cmncbt_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","大衛回答說：「好，我與你立約，但有一個要求：你一定要把掃羅的女兒米甲帶來才能見我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","於是，大衛派使者去見掃羅的兒子伊施·波設說：「請把我的妻子米甲送回來，因為她是我用一百個非利士人的包皮作聘禮娶來的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","伊施·波設就派人把米甲從她丈夫、拉億的兒子帕鐵那裡接回來。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","帕鐵一路跟著米甲，邊走邊哭，一直到巴戶琳。押尼珥對他說：「你回去吧！」他就回去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","押尼珥和以色列的長老商量說：「你們以前一直都希望大衛做你們的王， ");
INSERT INTO cmncbt_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","現在是時候了，因為耶和華曾說要藉著祂僕人大衛的手，從非利士人和其他所有敵人手中拯救祂的以色列子民。」 ");
INSERT INTO cmncbt_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","押尼珥也跟便雅憫人商談，然後到希伯崙把以色列人和便雅憫人的願望告訴大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","當時，他帶了二十個人前往希伯崙見大衛，大衛就設宴款待他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","押尼珥對大衛說：「我要去招聚所有以色列人到我主我王這裡，好跟你立約，你便可以如願以償，統治全以色列。」於是大衛為他送行，他就平安地回去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","大衛送押尼珥平安離開後不久，約押就率領大衛的軍隊襲敵歸來，並帶回許多戰利品。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","約押率領全軍回來後，有人告訴他：「尼珥的兒子押尼珥剛才來朝見王，王送他平安地離去了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","約押聽後，就去見王，說：「你這做的是什麼事？押尼珥來見你，你為什麼放他走呢？ ");
INSERT INTO cmncbt_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","你要知道，尼珥的兒子押尼珥想來騙你，探聽你的虛實。」 ");
INSERT INTO cmncbt_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","約押從大衛那裡出來，派使者去追押尼珥，他們在西拉井追上了他，把他帶了回來。大衛對這件事一無所知。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","押尼珥回到希伯崙的時候，約押就把他帶到城門的甕洞，裝作與他密談，乘機用短劍刺入他的肚子，把他殺死了，為他兄弟亞撒黑報了仇。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","後來，大衛聽到消息就說：「我和我的國在耶和華面前永遠跟尼珥的兒子押尼珥的死無關。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","約押和他全家要承擔這罪，願他的後代永遠有長瘡的、患皮膚病的、拄拐杖的、被刀劍所殺的或挨餓的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","約押和他兄弟亞比篩之所以殺押尼珥，是因為押尼珥在基遍殺了他們的兄弟亞撒黑。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","大衛對約押和部下說：「你們要撕裂衣服，腰束麻布，在押尼珥棺前哭喪！」大衛王也跟在棺後送葬。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","他們就把押尼珥葬在希伯崙。大衛王和眾人在墓旁大哭一場。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","大衛王哀悼押尼珥，說： 「押尼珥啊！ 你怎能死得糊里糊塗呢？ ");
INSERT INTO cmncbt_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","你的手沒有被捆， 你的腳沒有被鎖， 你是死在奸惡之人的手裡啊！」 於是眾人都為押尼珥哀哭。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","大衛整天沒有進食，眾人來勸他吃一點東西，但他起誓說：「我若在日落以前吃任何東西，願上帝重重地懲罰我！」 ");
INSERT INTO cmncbt_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","眾人聽見了，都很喜悅，王做的每一件事都令他們喜悅。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","那天全以色列的人都看出尼珥的兒子押尼珥的死與大衛無關。 ");
INSERT INTO cmncbt_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","大衛王對他的隨從說：「你們難道不知道今天以色列損失了一位偉大的將領嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","今天我雖然是被膏立的王，但仍勢單力薄，無法對付洗魯雅的兩個兒子，願耶和華報應他們的惡行。」 ");
INSERT INTO cmncbt_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","掃羅的兒子伊施·波設聽到押尼珥死在希伯崙，嚇得手腳發軟，整個以色列都震驚不已。 ");
INSERT INTO cmncbt_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","那時，掃羅的兒子有兩個帶兵的將領，一個叫巴拿，一個叫利甲，他們是來自比錄的便雅憫人臨門的兒子，比錄被認為屬於便雅憫支派。 ");
INSERT INTO cmncbt_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","原來的比錄人逃到基他音，寄居在那裡，直到今日。 ");
INSERT INTO cmncbt_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","掃羅的兒子約拿單有個兒子叫米非波設，雙腿是瘸的。掃羅和約拿單在耶斯列陣亡的消息傳來時，他才五歲。乳娘抱著他倉皇逃命，不慎把他掉在地上，摔瘸了腿。 ");
INSERT INTO cmncbt_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","一天，伊施·波設正在午睡，比錄人臨門的兩個兒子利甲和巴拿來到他家。 ");
INSERT INTO cmncbt_vpl VALUES ("S24_6","011_4_6","2SA","4","6","7","他們裝作是來取麥子，進入伊施·波設的寢室，趁他正躺在床上熟睡，用刀刺透他的肚子殺了他，割下他的首級，拿著連夜穿過亞拉巴逃跑了。 ");
INSERT INTO cmncbt_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","他們把伊施·波設的首級帶到希伯崙獻給大衛王，說：「這便是掃羅的兒子伊施·波設的首級。掃羅是你的仇敵，曾試圖殺害你，今天耶和華為我主我王懲罰了掃羅和他的子孫。」 ");
INSERT INTO cmncbt_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","大衛對比錄人臨門的兒子利甲及其兄弟巴拿說：「我憑救我脫離一切危難的永活的耶和華起誓， ");
INSERT INTO cmncbt_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","在洗革拉曾有人向我報信說掃羅死了，他以為是來報喜訊，我抓住他，把他殺了。那就是我給他的報酬。 ");
INSERT INTO cmncbt_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","更何況你們這些惡徒在這個無辜人的家裡把他殺死在床上，我怎能不向你們討這血債，把你們從世上除掉？」 ");
INSERT INTO cmncbt_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","於是，大衛命令部下殺了他們，斬斷他們的手腳，把屍體掛在希伯崙的池旁。他們把伊施·波設的頭顱葬在希伯崙的押尼珥的墳墓裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","以色列各支派都來希伯崙見大衛，對他說：「看啊，我們是你的骨肉同胞。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","從前掃羅做王的時候，率領以色列人出征打仗的是你，耶和華也曾應許讓你做祂以色列子民的牧者和首領。」 ");
INSERT INTO cmncbt_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","以色列的長老都到希伯崙見大衛王，大衛與他們在耶和華面前立約，他們膏立大衛做以色列的王。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","大衛三十歲登基，執政共四十年。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","他在希伯崙統治猶大七年半，在耶路撒冷統治以色列和猶大三十三年。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","大衛率領軍隊來到耶路撒冷，要攻打那裡的耶布斯人。耶布斯人對大衛說：「你攻不進來，就連我們這裡瞎眼的和瘸腿的都可以把你趕走。」他們以為大衛攻不進去。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","然而，大衛攻取了錫安的堡壘，即後來的大衛城。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","那天，大衛下令軍隊從地下水道爬進城去，攻打那些「瞎眼的和瘸腿的」，他憎惡這些耶布斯人。後來便有一句俗語：「瞎眼的和瘸腿的不得進殿！」 ");
INSERT INTO cmncbt_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","大衛住在錫安的堡壘裡，並稱之為大衛城，他又從米羅向內興建環城圍牆。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","大衛日漸強盛，因為萬軍之上帝耶和華與他同在。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","泰爾王希蘭差遣使者帶著香柏木、木匠和石匠去為大衛建造宮殿。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","那時，大衛知道耶和華已立他做以色列王，並因祂以色列子民的緣故而使他國家興旺。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","大衛從希伯崙遷到耶路撒冷以後，又選立妃嬪，生了更多兒女。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","他在耶路撒冷生的孩子有沙姆亞、朔罷、拿單、所羅門、 ");
INSERT INTO cmncbt_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","益轄、以利書亞、尼斐、雅非亞、 ");
INSERT INTO cmncbt_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","以利沙瑪、以利雅大和以利法列。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","非利士人聽說大衛已被膏立為以色列王，就全軍出動，搜尋大衛。大衛聽說後，便退到堡壘裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","非利士人大軍壓境，散佈在利乏音谷。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","大衛求問耶和華：「我可以去迎戰非利士人嗎？你會把他們交在我手裡嗎？」耶和華說：「去吧，我必把他們交在你手裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","大衛前往巴力·毗拉心，在那裡打敗了他們。他說：「耶和華像洪水決堤一樣為我沖垮了仇敵。」因此那地方叫巴力·毗拉心。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","大衛和他的軍隊帶走了非利士人所丟棄的神像。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","後來非利士人又捲土重來，散佈在利乏音谷。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","大衛又求問耶和華，耶和華說：「你不要正面出擊，要繞到他們後面，從桑林對面攻打他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","當你聽見桑樹梢上響起腳步聲時，就要快速進攻，因為那表示耶和華已在你前頭去攻擊非利士的軍隊了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","大衛遵命而行，打敗非利士人，從迦巴一直殺到基色。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","大衛又召集了三萬名以色列精兵， ");
INSERT INTO cmncbt_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","率領他們到猶大的巴拉去接上帝的約櫃。這約櫃以坐在基路伯天使之間的萬軍之耶和華的名字命名。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","他們把上帝的約櫃從座落在山上的亞比拿達家抬出來，放在一輛新車上，由亞比拿達的兩個兒子烏撒和亞希約趕車， ");
INSERT INTO cmncbt_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","亞希約走在約櫃前面。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","大衛和全體以色列人在耶和華面前用琴、瑟、鼓、鈸和鑼奏樂，盡情歌舞。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","他們走到拿肯的麥場時，拉車的牛失蹄，烏撒就伸手去扶上帝的約櫃。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","耶和華上帝便向他發怒，因他的不敬而擊殺了他。他死在了約櫃旁邊。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","大衛因耶和華擊殺烏撒而煩惱，就稱那地方為毗列斯·烏撒，沿用至今。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","那天，大衛懼怕耶和華，就說：「耶和華的約櫃怎能運到我這裡？」 ");
INSERT INTO cmncbt_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","他不願把耶和華的約櫃運進大衛城，而是把它運到迦特人俄別·以東家。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","耶和華的約櫃在俄別·以東家存放了三個月，耶和華賜福給俄別·以東和他全家。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","大衛聽說耶和華因為約櫃而賜福給俄別·以東全家及其一切所有，就歡歡喜喜地去把上帝的約櫃從俄別·以東家接進大衛城。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","這一次，抬耶和華約櫃的人走了六步，大衛就獻上公牛和肥犢為祭。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","大衛穿著細麻布的以弗得，在耶和華面前盡情跳舞。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","大衛和全體以色列人在歡呼聲和號角聲中把耶和華的約櫃迎進大衛城。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","耶和華的約櫃進大衛城的時候，掃羅的女兒米甲從窗戶往外觀看，見大衛在耶和華面前又跳又舞，心裡就輕視他。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","眾人把耶和華的約櫃抬進去，安放在大衛所搭的帳幕裡。大衛在耶和華面前獻上燔祭和平安祭， ");
INSERT INTO cmncbt_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","然後奉萬軍之耶和華的名給民眾祝福， ");
INSERT INTO cmncbt_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","還分給所有以色列人，不論男女，每人一個餅、一塊肉和一個葡萄餅。眾人就各自回家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","大衛回到家為自己的家人祝福，米甲出來迎接他，說：「今天以色列王好光彩呀！居然像個粗俗之人，在臣僕和婢女面前露體！」 ");
INSERT INTO cmncbt_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","大衛對她說：「我是在耶和華面前跳舞。祂不用你父親和你父親家裡的人，而是選立我來治理祂的以色列子民，所以我要在祂面前歡慶。 ");
INSERT INTO cmncbt_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","我要讓自己更卑微，自視低賤，但你說的那些婢女會尊重我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","掃羅的女兒米甲終生都沒有生育。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","大衛住在王宮裡，耶和華使他安享太平，不受四圍的仇敵侵擾。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","一天，王對拿單先知說：「你看，我住在香柏木建的王宮中，上帝的約櫃卻還在帳幕裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","拿單答道：「你有什麼想法，就去做吧，因為耶和華與你同在。」 ");
INSERT INTO cmncbt_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","當晚耶和華對拿單說： ");
INSERT INTO cmncbt_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","「你去告訴我的僕人大衛，『耶和華說，你要建造殿宇給我居住嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","從我把以色列人帶出埃及那天起，直到今天，我從未住過殿宇，一路上都住在帳幕裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","在我與以色列人同行的日子，我從未責問任何我委派牧養我子民的士師，你為何不為我建香柏木的殿宇呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","「現在你要告訴我的僕人大衛，萬軍之耶和華說，『你原本在草場牧羊，我召你來做我以色列子民的首領。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","無論你去哪裡，我都與你同在，為你剷除所有仇敵。現在我要使你聲名遠揚，與世上的偉人齊名。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","我必為我的以色列子民預備一個地方，栽培他們，使他們住在自己的家園，不再受驚擾，不會像從前我設立士師治理他們的時候那樣受惡人壓迫。我必使你安定，免受仇敵的侵擾。我耶和華向你宣告，我必為你建立王朝。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","你離世與祖先同眠時，我必興起你親生的後裔接替你，使他的國穩固。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","他必為我的名建造殿宇，我必使他的國度王位永固。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","我要作他的父親，他要作我的兒子。如果他犯了罪，我必用人的杖、世人的鞭子來懲治他， ");
INSERT INTO cmncbt_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","我的慈愛曾離開從你面前被廢的掃羅，但我的慈愛必不離開他。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","你的家和你的國必在我面前永遠堅立，你的王位必永遠穩固。』」 ");
INSERT INTO cmncbt_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","拿單就把所聽到的啟示全部告訴大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","於是，大衛王進去，在耶和華面前坐下，說：「主耶和華啊，我是誰？我的家算什麼？你竟這樣厚待我。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","主耶和華啊，在你眼中這還不夠，你還說到僕人家的將來。主耶和華啊，你竟這樣恩待世人！ ");
INSERT INTO cmncbt_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","主耶和華啊，大衛還能對你說什麼呢？因為你深知你的僕人。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","你讓僕人知道你憑自己的應許、按自己的心意成就這大事。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","主耶和華啊，你真偉大！我們從未聽過有誰能與你相比，你是獨一無二的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","世上哪個民族比得上你的以色列子民呢？你從埃及救贖他們，讓他們做你的子民，又彰顯你的大名，行偉大而可畏的事，把列國及其神明從你的以色列子民面前趕走。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","你讓以色列人永遠做你的子民，你耶和華做他們的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","「耶和華上帝啊，求你永遠信守你對僕人和僕人家的應許，求你成就你的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","這樣，你的名必永遠被尊崇，人們必說，『萬軍之耶和華是以色列的上帝。』你僕人大衛的家必在你面前堅立。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","以色列的上帝——萬軍之耶和華啊，因為你曾啟示僕人，說要為僕人建立王朝，僕人才敢這樣向你祈禱。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","主耶和華啊，唯有你是上帝，你的話真實可靠，你給了僕人美好的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","現在求你賜福給僕人家，使僕人家在你面前永續不斷。主耶和華啊，這些都是你的應許，願你永遠賜福給僕人家。」 ");
INSERT INTO cmncbt_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","後來大衛打敗並征服了非利士人，奪取了他們的都城。 ");
INSERT INTO cmncbt_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","他又打敗了摩押人，讓他們並排躺在地上，然後用繩子去量，每兩繩之內的人都要被殺掉，第三繩的人留下性命。從此，摩押人臣服於大衛，向他進貢。 ");
INSERT INTO cmncbt_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","利合的兒子瑣巴王哈大底謝出來，要恢復他在幼發拉底河一帶的勢力，大衛打敗了他， ");
INSERT INTO cmncbt_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","俘獲一千七百名騎兵和兩萬名步兵，砍斷拉戰車的馬匹的蹄筋，只留下夠拉一百輛戰車的馬匹。 ");
INSERT INTO cmncbt_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","大馬士革的亞蘭人前來支援瑣巴王哈大底謝，大衛殺了他們兩萬二千人， ");
INSERT INTO cmncbt_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","還在大馬士革的亞蘭境內駐軍，亞蘭人臣服於大衛，向他進貢。耶和華使大衛無往而不勝。 ");
INSERT INTO cmncbt_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","大衛奪走哈大底謝侍從的金盾牌，帶回耶路撒冷， ");
INSERT INTO cmncbt_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","又從哈大底謝統治的比他和比羅他兩座城中奪走大量的銅。 ");
INSERT INTO cmncbt_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","哈馬王陀以聽說大衛打敗哈大底謝全軍， ");
INSERT INTO cmncbt_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","就派兒子約蘭帶著許多金銀銅器去朝見大衛王，向他請安，祝賀他打敗了哈大底謝。因為陀以常常和哈大底謝交戰。 ");
INSERT INTO cmncbt_vpl VALUES ("S28_11","011_8_11","2SA","8","11","12","大衛王把這些器皿和他征服亞蘭人、摩押人、亞捫人、非利士人、亞瑪力人，以及利合的兒子瑣巴王哈大底謝時所得的金銀都分別出來，奉獻給耶和華。 ");
INSERT INTO cmncbt_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","大衛在鹽谷殺了一萬八千亞蘭人歸來後，聲威大振。 ");
INSERT INTO cmncbt_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","他又在以東全境駐軍，以東人都臣服於他。耶和華使他無往而不勝。 ");
INSERT INTO cmncbt_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","大衛治理全以色列，對百姓秉公行義。 ");
INSERT INTO cmncbt_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","那時，洗魯雅的兒子約押做元帥；亞希律的兒子約沙法做史官； ");
INSERT INTO cmncbt_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","亞希突的兒子撒督和亞比亞他的兒子亞希米勒做祭司長；西萊雅做書記； ");
INSERT INTO cmncbt_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","耶何耶大的兒子比拿雅統管基利提人和比利提人。大衛的眾子都做祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","大衛問：「掃羅一家還有什麼人嗎？我要因約拿單的緣故恩待他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","有人就去叫掃羅家一個名叫洗巴的僕人來見大衛，王問他：「你就是洗巴嗎？」他說：「僕人正是洗巴。」 ");
INSERT INTO cmncbt_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","王說：「掃羅家中還有什麼人？我要以上帝的慈愛來待他。」洗巴答道：「約拿單還有一個兒子，是雙腳殘疾的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","王說：「他在哪裡？」洗巴答道：「他住在羅·底巴，在亞米利的兒子瑪吉家裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","於是，大衛王派人去羅·底巴把他從亞米利的兒子瑪吉家裡接來。 ");
INSERT INTO cmncbt_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","掃羅的孫子、約拿單的兒子米非波設來到大衛面前，向他俯伏叩拜。大衛說：「米非波設！」米非波設答道：「僕人在這裡。」 ");
INSERT INTO cmncbt_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","大衛說：「你不要害怕，我要因你父親約拿單的緣故而恩待你。我要把你祖父掃羅所有的田地歸還給你，你要常與我同席吃飯。」 ");
INSERT INTO cmncbt_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","米非波設再次叩拜，說：「僕人算什麼？不過像一條死狗罷了，你竟這樣眷顧我！」 ");
INSERT INTO cmncbt_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","王又把掃羅的僕人洗巴召來，對他說：「我已把掃羅全家的產業都賜給了你主人的孫子米非波設。 ");
INSERT INTO cmncbt_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","你和你的兒子及僕人要為米非波設種田，把出產拿來供養他。他還要常常與我同席吃飯。」洗巴有十五個兒子，二十個僕人。 ");
INSERT INTO cmncbt_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","洗巴對王說：「僕人必遵行我主我王的一切吩咐。」於是，米非波設像王子一樣常與大衛同席吃飯。 ");
INSERT INTO cmncbt_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","米非波設有一個小兒子名叫米迦。洗巴家中的人都做了米非波設的僕人。 ");
INSERT INTO cmncbt_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","從此，雙腳殘廢的米非波設就住在耶路撒冷，常常與王同席吃飯。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","後來，亞捫王死了，他兒子哈嫩繼位。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","大衛說：「我要恩待拿轄的兒子哈嫩，就像他父親曾經恩待我一樣。」他便派臣僕去安慰喪父的哈嫩。大衛的臣僕來到亞捫境內， ");
INSERT INTO cmncbt_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","亞捫的官長卻對哈嫩說：「大衛派人來安慰你，你以為他是來弔唁你父親嗎？他派臣僕來見你，不過是要探聽虛實，想摧毀這城。」 ");
INSERT INTO cmncbt_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","哈嫩便把大衛的臣僕抓起來，剃去他們一半鬍鬚，從臀部割去他們下半身的衣服，然後放走他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","消息傳到大衛那裡，他就派人去迎接他們，因為他們倍受羞辱。王告訴他們留在耶利哥，等鬍鬚長好了再回來。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","亞捫人知道得罪了大衛，便派人到伯·利合和瑣巴招募了兩萬名亞蘭步兵、瑪迦王的一千人和一萬二千名陀伯人。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","大衛聽見消息後，就派約押率領全體勇士出戰。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","亞捫人在城門前列陣，瑣巴和利合的亞蘭人、陀伯人以及瑪迦人在郊野列陣。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","約押見自己腹背受敵，就從以色列軍中挑選一些精兵列陣迎戰亞蘭人， ");
INSERT INTO cmncbt_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","把餘下的軍兵交給他的兄弟亞比篩帶領，列陣迎戰亞捫人。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","他對亞比篩說：「倘若我勝不過亞蘭人，你便過來支援我；倘若你勝不過亞捫人，我便過去支援你。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","你要剛強，我們要為我們的人民和我們上帝的城邑奮勇作戰。願耶和華成全祂自己的旨意！」 ");
INSERT INTO cmncbt_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","於是，約押率領軍兵進攻亞蘭人，亞蘭人敗逃。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","亞捫人見亞蘭人敗逃，便也從亞比篩面前逃回城去。約押就離開亞捫人，回師耶路撒冷。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","亞蘭人見自己敗給以色列人，便再次聚集起來。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","哈大底謝派人把幼發拉底河那邊的亞蘭人調到希蘭來，由他的將軍朔法率領。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","大衛聽到消息後，就召集以色列全軍，渡過約旦河，來到希蘭。亞蘭人列陣迎戰大衛， ");
INSERT INTO cmncbt_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","結果又在以色列人面前敗逃。大衛殺了七百名戰車兵、四萬騎兵，還殺了他們的將軍朔法。 ");
INSERT INTO cmncbt_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","哈大底謝屬下的諸王見自己敗給以色列人，便向以色列人求和，臣服於他們。從此，亞蘭人不敢再支援亞捫人了。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","第二年春天，諸王又要發動戰爭。大衛差遣約押率領眾將領和以色列大軍出征，自己卻留在耶路撒冷。他們打敗了亞捫人之後又圍攻拉巴。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","一天黃昏，大衛從床上起來在王宮頂上散步，看見一個長得非常漂亮的女人在沐浴。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","大衛就派人去打聽這個女人是誰，得知她是以連的女兒、赫人烏利亞的妻子拔示巴。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","大衛派使者把她接來，她來了，大衛就與她同寢，那時她的月經剛潔淨。事後，她便回家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","拔示巴懷孕了，就派人去告訴大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","大衛便傳信給約押，說：「你派赫人烏利亞來見我。」約押就派烏利亞去見大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","烏利亞來了，大衛問他有關約押、士兵和戰爭的情況， ");
INSERT INTO cmncbt_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","然後吩咐他回家休息。烏利亞離開王宮後，收到王送的一份禮物。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","但他跟王的其他僕人一同睡在王宮門口，沒有回家。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","大衛得知烏利亞沒有回家，便對他說：「你遠道而來，為什麼不回家休息呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","烏利亞答道：「約櫃、以色列人和猶大人都在帳篷裡，而我主約押及其軍隊也在田間紮營，我怎麼可以回家吃喝，與妻子同房呢？我以王的性命起誓，我決不做這樣的事！」 ");
INSERT INTO cmncbt_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","大衛對烏利亞說：「你再住一天，明天我會派你回去。」於是烏利亞那日就留在耶路撒冷。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","第二天，大衛邀請他一同吃飯，把他灌醉了。可是到了晚上，烏利亞還是不肯回家，仍然跟王的其他士兵一同住宿。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","第二天早上，大衛給約押寫了一封信，要烏利亞帶去。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","大衛在信上吩咐約押：「你把烏利亞派到前線最險惡的地方，到時其他人都要撤退，好讓敵人殺死他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","於是約押圍攻城池時，便派烏利亞到他知道的最強悍的敵人那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","敵人出來迎戰約押，大衛的軍中有幾位陣亡，赫人烏利亞也死了。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","約押就派人去向大衛稟告戰爭的詳情， ");
INSERT INTO cmncbt_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","並叮囑信使：「你向王稟告戰情後， ");
INSERT INTO cmncbt_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","他若發怒責問你，『為什麼還冒死逼近城池呢？你們難道不知道敵人會從城牆上射箭嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","難道你們不知道耶路·比設的兒子亞比米勒是誰殺的嗎？一個婦人從城牆上扔下一塊磨石，把他砸死在提備斯。你們為什麼還要逼近城牆呢？』你就對王說，『你的僕人赫人烏利亞也死了。』」 ");
INSERT INTO cmncbt_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","於是，信使前來見大衛，照約押的吩咐向大衛稟告。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","他說：「敵軍勢力強大，在城外跟我們交戰，但我們把他們追到城門口。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","敵軍的弓箭手從城牆上射死了王的幾個士兵，赫人烏利亞也死了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","大衛便對信使說：「你去告訴約押不要為這事難過，因為刀劍無情。讓他只管竭力攻陷城池。要這樣勉勵約押。」 ");
INSERT INTO cmncbt_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","拔示巴聽到丈夫烏利亞的死訊之後就為他哭喪。 ");
INSERT INTO cmncbt_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","喪期過後，大衛便派人把她接進宮裡，她就做了大衛的妻子，並給他生了個兒子。然而，大衛的所作所為令耶和華十分不悅。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","耶和華派拿單先知去見大衛。拿單對大衛說：「一座城裡有兩個人，一個富有，一個貧窮。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","富人擁有許多牛羊， ");
INSERT INTO cmncbt_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","窮人除了自己買來養活的一隻母羊羔外，什麼也沒有。他讓牠跟自己的兒女一起長大。他吃什麼，羊也吃什麼，他喝什麼，羊也喝什麼，甚至讓牠睡在自己懷裡，就像他女兒一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","一天，富人家中來了客人，他捨不得拿自己的牛羊款待客人，卻宰了窮人的羊給客人吃。」 ");
INSERT INTO cmncbt_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","大衛聽後非常憤怒，對拿單說：「我憑永活的耶和華起誓，做這事的人實在該死！ ");
INSERT INTO cmncbt_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","他這樣做真是沒有半點憐憫之心，他必須償還那窮人四倍！」 ");
INSERT INTO cmncbt_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","拿單對大衛說：「那人就是你！以色列的上帝耶和華這樣說，『我膏立你做以色列的王，從掃羅手中救你， ");
INSERT INTO cmncbt_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","將你主人的家業和妻妾交給你，把以色列和猶大的國權賜給你。倘若還不夠，我會再加倍地賜給你。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","你為什麼蔑視我的命令，做出我視為可憎的事呢？你藉亞捫人的刀殺了赫人烏利亞，把他的妻子據為己有。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","因為你藐視我，把赫人烏利亞的妻子據為己有，從今以後，殺戮流血的事必永不離開你的家。』 ");
INSERT INTO cmncbt_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","耶和華說，『我要在你家中降下災禍，我要當著你的面把你的妻妾交給你的近臣，他必在光天化日之下與她們行淫。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","你在暗地裡做這惡事，我要讓這樣的惡事當著以色列人的面在光天化日之下臨到你。』」 ");
INSERT INTO cmncbt_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","大衛對拿單說：「我得罪了耶和華。」拿單說：「耶和華已經赦免了你的罪，使你不致死亡。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","但你做的醜事給了仇敵大肆褻瀆耶和華的機會，所以你這個孩子必定死。」 ");
INSERT INTO cmncbt_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","拿單說完，便回家去了。 耶和華擊打烏利亞的妻子給大衛生的孩子，使他患重病。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","大衛為這孩子向上帝哀求，並且禁食，他進到裡面，整夜躺在地上。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","宮裡的老臣在旁邊伺候，想要扶他起來，他卻不肯，也不肯與他們一同吃飯。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","到了第七日，孩子死了。大衛的臣僕都不敢把這消息告訴他，因為他們心裡想：「孩子還活著的時候，我們勸他，他尚且不聽，若告訴他孩子死了，他會怎樣折磨自己呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","大衛看見他們交頭接耳，知道孩子死了，便問他們：「孩子死了？」他們答道：「是的，他死了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","大衛聽後，便從地上起來，沐浴更衣，抹上香膏，然後到耶和華的殿去敬拜。他回宮以後，吩咐人擺上食物，自己開始用膳。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","他的臣僕詫異地問他：「你這是什麼意思？孩子還活著的時候，你禁食、哀哭。孩子死了，你反倒起來進食。」 ");
INSERT INTO cmncbt_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","大衛說：「不錯，孩子活著的時候我禁食、哀哭，因為我想也許耶和華會向我開恩，讓他活命。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","但現在他既然死了，我禁食又有什麼用呢？能讓他起死回生嗎？我必去他那裡，他卻不能返回我這裡了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","大衛安慰妻子拔示巴，與她同房，她便生了一個兒子。大衛給孩子取名叫所羅門。耶和華喜愛這孩子， ");
INSERT INTO cmncbt_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","祂差遣拿單先知去賜給他一個名字，叫耶底底亞，意思是耶和華喜愛他。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","那時，約押正攻打亞捫人的拉巴，佔領了王城。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","他派使者去向大衛稟告說：「我攻打拉巴，已經佔領了城的水源。 ");
INSERT INTO cmncbt_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","請你趕快帶領其餘的兵馬前來圍攻並佔領這城，免得我攻取這城以後，人們用我的名字為這城命名。」 ");
INSERT INTO cmncbt_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","於是，大衛便召集了所有的人去攻打拉巴，攻陷了那城， ");
INSERT INTO cmncbt_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","奪取了亞捫王頭上的金冠。這金冠重達三十四公斤，上面還鑲著寶石，人們將它戴在大衛頭上。大衛從城裡獲得許多戰利品， ");
INSERT INTO cmncbt_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","又把城裡的人帶出來，讓他們從事鋸木、耕田、砍樹的工作，還讓他們製作磚。他用同樣的方式對待亞捫其他城邑的居民。之後，大衛和全軍返回耶路撒冷。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","後來，大衛的兒子暗嫩愛上了美麗的她瑪，她瑪是大衛的兒子押沙龍的妹妹。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","她仍是處女，住在深宮裡，暗嫩無法接近她，相思成病。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","暗嫩有一個朋友名叫約拿達，是大衛長兄示米亞的兒子，生性狡猾。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","他問暗嫩：「王子，你為什麼一天比一天消沉？能告訴我嗎？」暗嫩答道：「我愛上了我兄弟押沙龍的妹妹她瑪。」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","約拿達說：「你回去躺在床上裝病，你父親來探望你的時候，你就請求他叫你妹妹她瑪來，在你面前預備食物，請她親手遞給你吃。」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","暗嫩就躺在床上裝病。王來看他的時候，他便對王說：「請你叫我妹妹她瑪來這裡，在我面前做兩個餅，請她親自遞給我吃。」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","大衛便派人進宮對她瑪說：「你去你哥哥暗嫩房裡為他預備食物吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","她瑪到了哥哥暗嫩的家，暗嫩正躺在床上裝病。她拿了麵團在他面前揉麵做餅，把餅烤熟了。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","她拿著鍋在他面前把餅倒出來，但暗嫩卻不肯吃。暗嫩命令僕人：「你們全都出去吧！」僕人就都退下了。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","暗嫩對她瑪說：「你把食物拿到我的臥房來，親手遞給我吃。」她瑪便拿著餅進了她哥哥暗嫩的臥房裡， ");
INSERT INTO cmncbt_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","上前給他吃，暗嫩卻抓住她，說：「妹妹，與我同寢吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","她瑪說：「哥哥，不要，不要玷污我！在以色列不應當發生這種事，不要做這種惡事。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","你這樣叫我怎麼見人呢？你在以色列也必遭人唾棄。你可以請求王，他會同意把我許配給你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","暗嫩卻充耳不聞，因為他力氣比她瑪大，就把她強姦了。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","事後暗嫩非常憎恨她瑪，對她的恨比以前對她的愛還強烈。他對她瑪說：「你起來走吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","她瑪哀求道：「不要這樣對我！你趕我走是更大的惡行。」暗嫩卻不聽， ");
INSERT INTO cmncbt_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","他吩咐隨從：「把這女人趕出去，隨後鎖上門。」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","他的隨從就把她瑪趕出去，隨後鎖上了門。那時，她瑪穿著彩色的長衣，沒有出嫁的公主都穿這種衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","她瑪把灰塵撒在頭上，撕破身上的彩衣，雙手抱著頭，一面走一面哭。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","她的哥哥押沙龍問她：「是不是你哥哥暗嫩污辱了你？妹妹，不要聲張，他是你哥哥，不要把這件事放在心上。」於是她瑪就憂憂鬱鬱地住在押沙龍家裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","大衛王聽見了這件事以後，非常生氣。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","押沙龍好話壞話都沒有對暗嫩說一句話，只是心裡暗暗地恨他，因為他玷污了妹妹她瑪。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","兩年後，押沙龍的工人在以法蓮附近的巴力·夏瑣剪羊毛，押沙龍邀請王的眾子去那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","他去見王，說：「工人正在為僕人剪羊毛，請王和眾臣僕跟僕人一起去吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","王說：「我兒，我們不必都去打擾你。」押沙龍再三邀請，王還是推辭了，但他為押沙龍祝福。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","押沙龍說：「王若不去，請讓我兄弟暗嫩跟我們去吧。」大衛說：「何必要他同去呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","但押沙龍再三懇求，王就讓暗嫩和其他王子一同去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","押沙龍吩咐僕人說：「你們要留意，當暗嫩喝得正高興的時候，我叫你們動手，你們就要殺他。不要害怕，要剛強勇敢！因為這是我的命令。」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","押沙龍的僕人就照命令把暗嫩殺了。王的眾子都起來騎上騾子逃走了。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","他們還在路上的時候，有人稟告大衛說：「押沙龍把王子都殺了，無一倖免！」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","王便站起來撕裂衣服，躺在地上。眾臣僕也都撕裂衣服，站在旁邊。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","大衛的長兄示米亞的兒子約拿達說：「我主不要以為所有的王子都被殺了，其實只有暗嫩一人死了。自從暗嫩姦污押沙龍的妹妹她瑪以來，押沙龍便決定要報仇了。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","所以，我主我王啊，不要相信這消息，不是所有的王子都死了，只有暗嫩一人死了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","此時，押沙龍已經逃走了。守望的人舉目瞭望，見有一大群人從西面山坡的路上下來。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","約拿達對王說：「請看，王子們都回來了！正如僕人所言。」 ");
INSERT INTO cmncbt_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","話剛說完，眾王子已經來到他們跟前放聲大哭，王和眾臣僕也哀痛不已。 ");
INSERT INTO cmncbt_vpl VALUES ("S213_37","011_13_37","2SA","13","37","38","押沙龍逃到了亞米忽的兒子基述王達買那裡，在那裡住了三年。大衛王天天為他兒子暗嫩悲傷， ");
INSERT INTO cmncbt_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","後來心情恢復平靜，開始想念押沙龍。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","洗魯雅的兒子約押知道王想念押沙龍， ");
INSERT INTO cmncbt_vpl VALUES ("S214_2","011_14_2","2SA","14","2","2","就派人到提哥亞去召來一個聰明的婦人，對她說：「你假扮哀悼的人，穿上喪服，不要用油抹身，要裝成為死者哀悼很久的婦人， ");
INSERT INTO cmncbt_vpl VALUES ("S214_3","011_14_3","2SA","14","3","3","然後到王那裡，對他這樣這樣說。」約押把應該說的話都告訴婦人。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_4","011_14_4","2SA","14","4","4","提哥亞婦人來到王面前，俯伏在地上說：「王啊，求你救救我吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_5","011_14_5","2SA","14","5","5","王問她：「你有什麼事？」婦人說：「婢女是個寡婦，丈夫死了。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_6","011_14_6","2SA","14","6","6","我本來有兩個兒子，有一次他們在田間發生爭執，當時沒有人勸解，其中一個兒子被打死了。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_7","011_14_7","2SA","14","7","7","現在整個家族都起來反對婢女，說，『把那打死親兄弟的兇手交出來，我們要他以命償命，除掉這個繼承人。』他們要讓我家斷子絕孫，使婢女的丈夫既不能留名，也不能留後。」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_8","011_14_8","2SA","14","8","8","王說：「你回家去吧！我會為你作主。」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_9","011_14_9","2SA","14","9","9","提哥亞婦人說：「我主我王，願罪過都落在婢女和婢女家族，跟王和王位無關。」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_10","011_14_10","2SA","14","10","10","王說：「若有人為難你，你就把他帶來，他必不敢再找你的麻煩。」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_11","011_14_11","2SA","14","11","11","婦人說：「求王憑你的上帝耶和華起誓，不許報血仇者殺人，留我兒一命。」王說：「我憑永活的耶和華起誓，你的兒子必毫髮無損。」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_12","011_14_12","2SA","14","12","12","婦人說：「求我主我王再容婢女說一句。」王說：「說吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_13","011_14_13","2SA","14","13","13","婦人說：「王怎麼想出這樣的事來針對上帝的子民呢？王剛才所說的話正表明王的不是了，因為王不讓被流放的兒子回來。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_14","011_14_14","2SA","14","14","14","人都難免一死，就像覆水難收。然而，上帝不是要奪取人的性命，而是要設法使流亡的人重新回來。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_15","011_14_15","2SA","14","15","15","我向我主我王說出這番話，是因為人們恐嚇我。我想，不如向王請命，也許王會成全婢女的心願。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_16","011_14_16","2SA","14","16","16","有人要害我和我兒子的性命，叫我們不得承受上帝所賜的產業，也許王能從這人手中救我們。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_17","011_14_17","2SA","14","17","17","婢女想，我主我王的話必能安慰我，因為我主我王就像上帝的天使一樣能明辨是非。願王的上帝耶和華常與王同在！」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_18","011_14_18","2SA","14","18","18","王對婦人說：「我有一件事要問你，你要實實在在地回答我。」婦人說：「我主我王請說。」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_19","011_14_19","2SA","14","19","19","王說：「這是不是約押的主意？」婦人說：「我憑我主我王的性命起誓，王所說的一點不錯，這些話是你臣僕約押吩咐婢女說的。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_20","011_14_20","2SA","14","20","20","他這樣做是希望扭轉局面。我主如上帝的天使一樣有智慧，洞悉天下之事。」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","於是，王對約押說：「我答應你的請求，你去把年輕的押沙龍帶回來吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","約押俯伏在地，叩謝王恩，說：「今天僕人在我主我王面前蒙了恩，因為王應允了僕人的請求。」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","約押便到基述把押沙龍接回耶路撒冷。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","王說：「讓押沙龍回自己的家，不要讓他來見我！」押沙龍便返回自己家中，沒有朝見王。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","在整個以色列，沒有人像押沙龍那樣因相貌英俊而為人稱道，他從頭到腳毫無瑕疵。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","他的頭髮濃密，每年年終會很沉重，需要剪髮，剪下的頭髮按王的重量標準約重兩公斤。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","押沙龍有三兒一女，女兒名叫她瑪，長得非常美麗。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","押沙龍在耶路撒冷住了兩年，沒有跟王見過面。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","他派人去請約押來，託他去求見王，但約押不肯來。第二次再請，他還是不肯來。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","押沙龍就吩咐僕人：「你們看，約押的田就在我的田旁邊，他種了大麥，你們去放火把它燒了。」押沙龍的僕人便把麥田燒了。 ");
INSERT INTO cmncbt_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","約押便來到押沙龍家裡，問他：「你為什麼叫僕人放火燒我的田？」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","押沙龍答道：「我派人請你來，希望你替我去問王，『我為什麼要從基述回來呢？倒不如仍然留在那裡。』現在我要見王，如果我有什麼罪過，就讓他殺了我吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","約押就去見王，把押沙龍的話告訴他，王便召見押沙龍。押沙龍來到王面前俯首叩拜，王就親吻他。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","後來，押沙龍為自己備了車馬，又派五十個人在他前面開道。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","他常常清早起來，站在城門的通道旁邊。每當有人來找王審理爭訟時，押沙龍便問他是從哪一座城來的，那人就會報上自己所屬的支派。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","押沙龍會對他說：「你的申訴合情合理，可惜王沒有派人來聽你申訴。」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","他接著會說：「要是我被立為國中的審判官就好了！那樣，任何人有爭訟都可以來找我，我一定會為他主持公道。」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","每當有人要向他叩拜，他都伸手扶他，親吻他。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","押沙龍這樣對待每一個來向王申訴的以色列人，贏得了民心。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","過了四年，押沙龍對王說：「請讓我到希伯崙去還我向耶和華許下的願吧。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","僕人住在亞蘭的基述時曾許願，如果耶和華帶領我回到耶路撒冷，我必在希伯崙敬拜祂。」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","王說：「你平安地去吧！」押沙龍就去了希伯崙。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","他派密使通知以色列各支派一聽見號角的響聲，便喊：「押沙龍在希伯崙做王了！」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","有二百人應邀隨同押沙龍一起從耶路撒冷去希伯崙，他們對內情一無所知。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","押沙龍獻祭的時候，還派人去把大衛的謀士亞希多弗從他的故鄉基羅請來。反叛的勢力大增，擁護押沙龍的民眾越來越多。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","有人來稟告大衛：「以色列的民心都歸向押沙龍了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","大衛便對在耶路撒冷跟隨他的臣僕說：「我們趕快逃命吧！否則，我們都難逃押沙龍的追捕。我們要馬上離開！免得他趕到殘害我們，屠殺全城。」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","臣僕對王說：「臣等謹遵我主我王的決定。」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","於是王就帶著全家逃命，只留下十個妃嬪看守宮殿。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","大衛王帶著眾民離開耶路撒冷，走到最後的那座房子時，停了下來。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","他的臣僕都從他身邊過去了，包括基利提人、比利提人以及從迦特來的六百個隨從。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","王問迦特人以太說：「你為什麼要跟我們一起逃難呢？回去留在新王那裡吧！你是流亡到這裡的外族人。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","你剛來不久，我怎麼可以叫你跟我們一同四處飄流呢？我甚至不知道往何處去。你還是和你的弟兄回去吧，願耶和華以慈愛和信實待你！」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","以太卻答道：「我憑永活的耶和華和我主我王的性命起誓，不管我王去哪裡，僕人都要誓死追隨到底！」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","大衛便對以太說：「那就繼續前行吧！」於是，迦特人以太帶著他的人及所有的家眷繼續前行。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","眾人離開時，當地的百姓都放聲大哭。王帶著所有的人過了汲淪溪，向曠野走去。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","祭司撒督、亞比亞他和抬上帝約櫃的利未人都來了，他們把約櫃放下，讓城裡出來的人先走過去。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","王對撒督說：「你把上帝的約櫃抬回城去吧。耶和華若恩待我，必使我重返家園，重見約櫃和會幕； ");
INSERT INTO cmncbt_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","但我若使祂不悅，也甘願聽憑祂的處置。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","你是個有先見之明的人，安心帶著你的兒子亞希瑪斯和亞比亞他的兒子約拿單回城吧。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","我會在曠野渡口那裡等你們的消息。」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","於是，撒督和亞比亞他便把上帝的約櫃抬回耶路撒冷，留了下來。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","大衛蒙著頭，赤著腳登上橄欖山，邊走邊哭，他的隨從也蒙著頭，哭著走上山。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","有人告訴大衛，亞希多弗也叛變，投奔了押沙龍，大衛就禱告說：「耶和華啊，求你使亞希多弗的謀算都變得愚不可及。」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","大衛來到山頂敬拜上帝的地方，看見亞基人戶篩撕破了衣服，頭蒙灰塵前來迎接他。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","大衛對他說：「你跟我一同逃命，只會給我帶來不便。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","你若回到城中，告訴押沙龍你願意做他的臣僕，就像以前做我的臣僕一樣，就可以幫我破壞亞希多弗的計謀。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","祭司撒督和亞比亞他都在那裡，你在宮內聽到什麼消息就告訴他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","撒督的兒子亞希瑪斯和亞比亞他的兒子約拿單也在那裡，你聽到什麼消息，可以派他們傳信給我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","於是，大衛的朋友戶篩便回到城裡。那時，押沙龍也進了耶路撒冷。 ");
INSERT INTO cmncbt_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","大衛剛越過了山頂，就看見米非波設的僕人洗巴牽著兩頭驢，驢背上馱著二百個麵餅、一百個葡萄餅、一百個夏天的果餅和一皮袋酒來迎接他。 ");
INSERT INTO cmncbt_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","王問洗巴說：「你帶這些來做什麼？」洗巴說：「驢是給王的家眷騎的，餅和夏天的水果是給你的隨從吃的，酒是供他們在曠野疲憊時喝的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","王又問他：「你主人的孫子米非波設在哪裡？」洗巴說：「他在耶路撒冷，因為他相信現在以色列人會把他祖父的國歸還給他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","王就對洗巴說：「米非波設的一切現在都歸你了。」洗巴說：「我叩拜我主我王，願我在你面前蒙恩。」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","大衛王來到巴戶琳時，掃羅家族基拉的兒子示每出來向著大衛邊走邊罵， ");
INSERT INTO cmncbt_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","還朝大衛和他的臣僕扔石頭，無視大衛身邊的眾多隨從和勇士。 ");
INSERT INTO cmncbt_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","示每罵大衛：「滾吧！滾吧！你這個殺人兇手，你這個敗類！ ");
INSERT INTO cmncbt_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","你殺掃羅的家人，奪他的王位，耶和華報應了你，把江山交給了你兒子押沙龍。你這殺人兇手是自食惡果！」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","洗魯雅的兒子亞比篩對王說：「這死狗竟敢咒罵我主我王，讓我過去砍掉他的頭！」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","王卻說：「洗魯雅的兒子啊，不要管我的事。如果是耶和華叫他來咒罵我，誰能干涉他呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","大衛對亞比篩和他所有臣僕說：「我的親生兒子尚且要取我的命，何況這個便雅憫人呢？由他去吧！讓他咒罵吧！因為這是耶和華的意思。 ");
INSERT INTO cmncbt_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","也許耶和華會體察我的困苦，因我今天所受的咒罵而賜福給我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","於是，大衛和隨從繼續趕路，示每也沿著對面的山坡邊走邊罵，向他們扔石頭，撒灰塵。 ");
INSERT INTO cmncbt_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","王和眾人來到約旦河邊時，疲憊不堪，便在那裡歇息。 ");
INSERT INTO cmncbt_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","押沙龍和以色列眾人進了耶路撒冷，亞希多弗也和他在一起。 ");
INSERT INTO cmncbt_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","大衛的朋友亞基人戶篩去見押沙龍，對他說：「願王萬歲！願王萬歲！」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","押沙龍問戶篩說：「這就是你對朋友的忠誠嗎？你為什麼不跟你的朋友去呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","戶篩說：「我不去，誰是耶和華和全體以色列人民所揀選的，我就歸屬誰，留在誰那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","再說，我應該服侍誰呢？難道不該服侍王的兒子嗎？我要像服侍你父親一樣服侍你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","押沙龍問亞希多弗下一步應該怎麼辦。 ");
INSERT INTO cmncbt_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","亞希多弗說：「你父親留下幾個妃嬪看守宮殿，你要跟她們同寢，叫所有的以色列人知道你與父親誓不兩立，這樣支持你的人會更堅定。」 ");
INSERT INTO cmncbt_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","於是，他們便為押沙龍在殿頂蓋了一座帳篷，他就當著所有以色列人的面與父親的妃嬪同寢。 ");
INSERT INTO cmncbt_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","那時，亞希多弗出的主意如同是來自上帝的話，大衛曾對他言聽計從，現在押沙龍也是一樣。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","亞希多弗對押沙龍說：「請讓我挑選一萬二千人，今夜啟程追趕大衛， ");
INSERT INTO cmncbt_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","趁他疲憊無力的時候襲擊他，使他驚慌失措，他的隨從必逃命。我只把王一個人殺掉， ");
INSERT INTO cmncbt_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","把他的部下全都帶來歸順你。你尋索的人既然死了，跟隨他的人必然會歸順你。這樣，大家就平安無事了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","押沙龍和以色列的長老都贊成這個提議。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","押沙龍說：「召亞基人戶篩進來，我們也聽聽他的意見。」 ");
INSERT INTO cmncbt_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","戶篩來了，押沙龍就把亞希多弗的建議告訴他，問他：「我們應該照亞希多弗的提議去做嗎？如果不可行，說說你的看法吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","戶篩答道：「亞希多弗這次的主意不好！ ");
INSERT INTO cmncbt_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","你知道你父親和他的部下，他們都是勇士，現在他們就像丟了熊崽的母熊一樣兇猛。況且你父親是個身經百戰的人，他一定不會跟部下睡在一處。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","他現在可能藏在山洞或某個地方。要是他襲擊我們的人馬，聽見的人會說押沙龍的軍隊慘敗了。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","那時候，你手下的人再膽量過人，也會膽戰心驚。因為全以色列都知道你父親是英雄，他的部下都是勇士。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","因此，我認為你應該把從但到別示巴的那多如海沙的以色列人都聚集起來，然後你親自率領他們出征。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","這樣不管在哪裡找到大衛，我們就像露水一樣鋪天蓋地地襲擊他，讓他全軍覆沒。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","如果大衛退進一座城裡，我們以色列全軍就拿繩索把那城拉到河谷，連一塊石頭都不留。」 ");
INSERT INTO cmncbt_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","押沙龍和以色列眾人都說：「亞基人戶篩的主意比亞希多弗的好！」其實是耶和華決定破壞亞希多弗的巧計，好把災禍降在押沙龍身上。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","戶篩把亞希多弗和自己為押沙龍及以色列長老所提的建議告訴祭司撒督和亞比亞他， ");
INSERT INTO cmncbt_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","並說：「你們現在快派人去通知大衛，告訴他今晚不可在曠野的渡口過夜，務必要渡過約旦河，免得他和隨從全軍覆沒。」 ");
INSERT INTO cmncbt_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","當時，約拿單和亞希瑪斯待在隱·羅結，不敢進城，怕被人看見。有一個婢女從城中出來給他們報信，他們便去通知大衛王。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","不料，有一個少年發現了他們，就去告訴押沙龍。他們二人急忙逃走，來到巴戶琳的一戶人家，藏到那家院子裡的一口井內， ");
INSERT INTO cmncbt_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","那家的婦人用蓋子蓋上井口，然後在上面撒了一些麥子，沒有人知道這件事。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","押沙龍的部下來到婦人家查問約拿單和亞希瑪斯的下落，婦人說他們已經過河了。押沙龍的部下就去搜索，結果一無所獲，就返回耶路撒冷。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","押沙龍的部下離開後，約拿單和亞希瑪斯便從井裡爬出來，去向大衛王報信，把亞希多弗的計謀告訴他，請他趕快渡過約旦河。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","大衛王和部下就動身過約旦河，在黎明之前，所有的人都過去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","亞希多弗見自己的提議不被接納，便備上驢，啟程回鄉，安頓好家事以後，就自縊身亡了。他被安葬在他父親的墓穴裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","大衛來到瑪哈念，押沙龍也率領以色列全軍渡過了約旦河。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","押沙龍任命亞瑪撒為元帥，代替約押的位置。亞瑪撒是以實瑪利人以特拉的兒子，他母親是拿轄的女兒亞比該。亞比該與約押的母親洗魯雅是姊妹。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","押沙龍和以色列人在基列地區安營。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","大衛來到瑪哈念後，得到亞捫族拉巴人拿轄的兒子朔比、羅·底巴人亞米利的兒子瑪吉和基列的羅基琳人巴西萊的款待。 ");
INSERT INTO cmncbt_vpl VALUES ("S217_28","011_17_28","2SA","17","28","28","他們帶來被褥、碗盆、瓦器、小麥、大麥、麵粉、炒麥、豆子、扁豆、 ");
INSERT INTO cmncbt_vpl VALUES ("S217_29","011_17_29","2SA","17","29","29","蜂蜜、奶油、綿羊和乳酪，送給大衛和跟隨他的人，因為他們想：「眾人在曠野一定饑渴疲乏了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","大衛召集軍隊，設立了千夫長和百夫長率領他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","他兵分三隊，一隊由約押率領，一隊由洗魯雅的兒子、約押的兄弟亞比篩率領，一隊由迦特人以太率領。大衛對部下說：「我必與你們一同出戰。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","他們卻說：「你不要出戰。因為如果我們敗逃，敵方不會放在心上；即使我們一半人陣亡，敵方也不會放在心上。你一人比我們一萬人更寶貴。你還是留在城中支援我們吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","王說：「你們認為怎樣好，我就怎樣做。」於是，大衛王站在城門旁邊，軍兵百人一隊、千人一隊地出城了。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","大衛王吩咐約押、亞比篩和以太說：「你們要看在我的份上對年輕的押沙龍手下留情。」全體的軍兵都聽見了大衛吩咐眾將領的話。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","大衛的軍隊在以法蓮的樹林裡跟以色列人交戰。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","以色列人被大衛的部下打敗，傷亡慘重，有兩萬人陣亡。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","戰事蔓延到整個郊野，那天死在樹林裡的人比死在刀下的人還多。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","押沙龍碰巧遇見大衛的部下。他騎著騾子逃走，騾子從一棵大橡樹的茂密枝條下經過，押沙龍的頭髮被樹枝纏住，整個人吊在半空中，胯下的騾子也跑了。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","大衛的一個部下看見，就向約押稟告說：「我看見押沙龍正吊在橡樹上。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","約押對那報信的說：「什麼！你看見他吊在樹上，為什麼不把他殺掉呢？要是你把他殺了，我會賞你十塊銀子和一條腰帶。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","他卻答道：「就是你賞我一千塊銀子，我也不敢加害王的兒子啊！我們曾聽見王吩咐你、亞比篩和以太不可傷害年輕的押沙龍。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","如果我膽敢殺死押沙龍，王遲早會查出真相，到時你就撒手不管了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","約押說：「我不跟你浪費時間。」趁著押沙龍還吊在橡樹上，他拿起三桿矛槍剌入了他的心臟。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","十個為約押拿兵器的年輕人圍上去將押沙龍殺死。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","隨後，約押吹起收兵的號角，軍兵便停止追趕以色列人。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","他們把押沙龍的屍體扔在林中的一個坑裡，在上面堆了一大堆石頭。以色列人都各自逃回家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","押沙龍生前沒有兒子為他留名，所以他曾在王谷立了一根石柱，以自己的名字命名，稱為「押沙龍柱」，沿用至今。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","撒督的兒子亞希瑪斯對約押說：「請讓我跑回去向王稟告，讓王知道耶和華已從仇敵手中救了他。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","但約押對他說：「你今天不要去報信，改天再報吧。你今天不要去，因為王的兒子死了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","約押吩咐一個古實人：「你去把所看見的稟報給王。」那人就拜別了約押，馬上跑回去報信。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","撒督的兒子亞希瑪斯再次對約押說：「無論怎樣，求你讓我與古實人一同去吧！」約押說：「我的孩子，你何必要去呢？你報這個消息是不會得到賞賜的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","他說：「無論怎樣，我想跑去報信。」約押答應了。亞希瑪斯沿平原的路跑，跑到了古實人的前面。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","那時，大衛正坐在內城門和外城門中間。有一個守望者爬上城門樓頂觀望，看見一個人獨自跑來。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","守望者就大聲向王稟告。王說：「他若是獨自一人，帶來的一定是好消息。」那人越來越近了。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","這時候，守望者又看見另一個人跑來，就大聲對守城門的說：「又有一個人獨自跑來了！」王說：「他也一定是傳好消息的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","守望者又說：「從跑的姿勢看，那跑在前面的人好像撒督的兒子亞希瑪斯。」王說：「他是個好人，他一定帶來了好消息。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","亞希瑪斯高聲對王說：「一切平安！」他在王面前俯伏叩拜，說：「你的上帝耶和華當受稱頌，祂已經消滅了那些攻擊我主我王的敵人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","王問道：「年輕的押沙龍平安嗎？」亞希瑪斯答道：「約押派僕人來的時候，僕人看見一陣大騷動，但不知道是什麼事。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","王說：「你先退到一邊去。」亞希瑪斯就退下，站在一邊。 ");
INSERT INTO cmncbt_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","這時，古實人也到了，他說：「我有好消息向我主我王稟告，今日耶和華已經從一切反叛之人手中救了我主我王。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","王問古實人：「年輕的押沙龍平安嗎？」古實人答道：「願我主我王的仇敵和一切要加害我王的人，下場都與那青年一樣。」 ");
INSERT INTO cmncbt_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","王聽了十分難過，就走上城門樓去痛哭，邊走邊說：「我兒押沙龍啊！我兒，我兒押沙龍啊！我恨不得可以替你死！押沙龍，我兒啊！我兒！」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","有人告訴約押，說：「王在為押沙龍哀傷痛哭。」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","士兵們聽說王為押沙龍哀痛，勝利的歡騰頓時變為一片哀愁。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","那一天，眾人都靜悄悄地回城去，好像敗兵一樣羞愧。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","王仍掩面痛哭：「我兒押沙龍啊！押沙龍！我兒！我兒啊！」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","約押就進到屋裡，對王說：「你的僕人們救了你和你妻妾兒女的性命，你今天卻使他們感到羞愧。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","仇視你的人，你倒去愛他；那些愛你的人，你反憎惡他們。這表明我王的心中根本沒有我們這些將領和部下。如今我明白了，要是死去的不是押沙龍而是我們，你就高興了。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","你現在應該出去安撫士兵們。我憑耶和華起誓，如果你不這樣做，今晚必無一人再追隨你。那將是你一生所遭遇的最大災難！」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","於是王出去坐在城門口，眾人聽說後，都來到他面前。這時，跟隨押沙龍的以色列人都各自逃回家去了。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","以色列各支派的人都在紛紛議論：「王曾把我們從眾仇敵和非利士人手中救出來。如今他為了躲避押沙龍而逃離本國。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","我們膏立為王的押沙龍已經死了，為什麼無人說請王回來呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","大衛王派人去對祭司撒督和亞比亞他說：「你們去問猶大的長老，『全以色列已經準備迎接王回宮，你們為什麼遲遲沒有反應？ ");
INSERT INTO cmncbt_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","你們是王的弟兄，是王的骨肉，為什麼遲遲沒有迎接王回宮？』 ");
INSERT INTO cmncbt_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","你們也要對亞瑪撒說，『你是我的骨肉，要是我不立你為元帥取代約押，願上帝重重地處罰我。』」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","王的這番話打動了所有猶大人的心，他們派人去請王和王的臣僕回來。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","王便啟程回宮。他來到約旦河時，猶大人都到吉甲來迎接他，要護送他過河。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","來自巴戶琳的便雅憫人基拉的兒子示每也急忙跟著猶大人趕來迎接大衛王， ");
INSERT INTO cmncbt_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","有一千便雅憫人跟示每一起去迎接大衛王。掃羅的僕人洗巴帶著十五個兒子和二十個僕人也趕到約旦河。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","他們渡到河對面幫助王的家眷過河，為王效勞。王正要過河的時候，基拉的兒子示每就俯伏在他面前， ");
INSERT INTO cmncbt_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","說：「求我主饒恕僕人的罪過！僕人在我主我王離開耶路撒冷時所犯的罪，求我王不要記在心上。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","僕人自知有罪，所以今天我是整個約瑟家族中第一個迎接我主我王的人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","洗魯雅的兒子亞比篩說：「示每曾經咒罵耶和華所膏立的君王，難道不應該處死他嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","大衛說：「洗魯雅的兒子，不要管我的事。你今天是在跟我作對。今天在以色列怎麼可以處死人呢？難道我不知道今天我是以色列的王嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","於是大衛起誓不殺示每。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","掃羅的孫子米非波設也來迎接王。從王離開那天，直到大衛平安回來之日，他沒有修過腳，沒有剃過鬍子，也沒有洗過衣服。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","他到耶路撒冷來迎接王，王問他：「米非波設，當時你為什麼不跟我一起走呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","米非波設答道：「我主我王，我是瘸腿的，我本想預備一頭驢騎著與我王同去，是我的僕人洗巴欺騙了我。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","他在我主我王面前譭謗我。我主我王就像上帝的天使，請王定奪。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","我父全家在我主我王面前都是該死的，但王卻讓我與王同席吃飯，我還能向王要求什麼呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","王對他說：「不要再提這事了，我決定讓你和洗巴平分土地。」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","米非波設說：「把土地都給他吧，我主我王平安地回來就好了。」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","基列人巴西萊也從羅基琳下來護送王過約旦河，然後送王上路。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","那時，巴西萊已經是八十高齡了。王留在瑪哈念的時候，他曾供應王食物，因為他非常富有。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","王對巴西萊說：「你跟我一同回耶路撒冷，我會照顧你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","巴西萊說：「我何必跟王一同去耶路撒冷呢？我還能活多久呢？ ");
INSERT INTO cmncbt_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","我已經八十歲了，美醜難分，食不知味，樂不辨音，何必為我主我王添麻煩呢？ ");
INSERT INTO cmncbt_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","僕人只不過是陪王過約旦河，王何必給我這麼大的賞賜呢？ ");
INSERT INTO cmncbt_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","請准我回去，我好死在故鄉，葬在父母的墓旁。這裡有王的僕人金罕，讓他跟我主我王一起去。你看怎麼好，就怎麼對待他吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","王說：「金罕可以跟我去，我會照你的心願待他。無論你有什麼要求，我都會答應你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","王和眾人過了約旦河以後，就親吻巴西萊，為他祝福。巴西萊返回了家鄉。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","王過河後，來到吉甲，金罕跟隨著他。護送王的有猶大的士兵和半數的以色列士兵。 ");
INSERT INTO cmncbt_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","後來，所有的以色列人來見王，說：「為什麼我們的弟兄猶大人偷偷地送王、王的家眷和王的部下渡河？」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","猶大人答道：「我們這樣做是因為王是我們的親族。你們為什麼生氣呢？難道我們吃了王的供應，得了什麼禮物嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","以色列人說：「但我們和王有十份的情分，我們在大衛身上比你們更有份。你們為什麼輕視我們？難道不是我們首先提出要請王回來的嗎？」 但猶大人的態度比以色列人還要強硬。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_1","011_20_1","2SA","20","1","1","有一個無賴名叫示巴，是便雅憫人比基利的兒子，當時剛好在吉甲。他吹響號角，大喊：「我們與大衛毫無關係，耶西兒子的產業沒有我們的份。以色列人啊，各自回家去吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S220_2","011_20_2","2SA","20","2","2","於是，以色列人都離開了大衛，跟隨了比基利的兒子示巴。但猶大人仍然緊緊跟隨他們的王，從約旦河一直來到耶路撒冷。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_3","011_20_3","2SA","20","3","3","大衛回到耶路撒冷的宮裡，把從前留下來看守王宮的十個妃嬪關進冷宮，供養她們，卻不再和她們同房。她們像寡婦一樣在軟禁中度過餘生。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_4","011_20_4","2SA","20","4","4","王對亞瑪撒說：「你要在三天內招聚猶大人，跟他們一起來見我。」 ");
INSERT INTO cmncbt_vpl VALUES ("S220_5","011_20_5","2SA","20","5","5","亞瑪撒就去招聚猶大人，但他超過了王所定的期限。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_6","011_20_6","2SA","20","6","6","大衛對亞比篩說：「現在比基利的兒子示巴給我們帶來的危害恐怕比押沙龍還要大。你帶領我的部下去捉拿他，免得他佔據了堅固的城池，得以逃脫。」 ");
INSERT INTO cmncbt_vpl VALUES ("S220_7","011_20_7","2SA","20","7","7","於是，約押的部下和基利提人、比利提人，以及所有的勇士都跟隨亞比篩離開耶路撒冷，去追趕比基利的兒子示巴。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_8","011_20_8","2SA","20","8","8","他們來到基遍的巨石旁，見亞瑪撒迎面而來。約押當時身穿戰袍，腰間佩刀，他迎上去的時候，刀從鞘中滑落出來。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_9","011_20_9","2SA","20","9","9","約押對亞瑪撒說：「兄弟，你好嗎？」他用右手抓住亞瑪撒的鬍子，親吻他。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_10","011_20_10","2SA","20","10","10","亞瑪撒毫無防備，被約押一刀刺入肚子，肚破腸流而死。然後，約押和他兄弟亞比篩繼續追趕比基利的兒子示巴。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_11","011_20_11","2SA","20","11","11","約押的一個部下站在亞瑪撒的屍體旁邊說：「擁護約押和大衛的人來跟隨約押吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S220_12","011_20_12","2SA","20","12","12","亞瑪撒的屍體倒在路中間的血泊中。那人見眾人駐足圍觀，便把屍體從路上拖到田裡，扔了一件衣服蓋上。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_13","011_20_13","2SA","20","13","13","屍體搬走以後，眾人都跟隨約押去追比基利的兒子示巴。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_14","011_20_14","2SA","20","14","14","示巴走遍以色列各支派，一直到伯·瑪迦的亞比拉城。他的本族比利人都聚集起來跟隨他。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_15","011_20_15","2SA","20","15","15","約押率大軍來到伯·瑪迦，把示巴圍困在亞比拉城內，他們修築攻城的高臺，撞擊城牆，要摧毀它。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_16","011_20_16","2SA","20","16","16","有一個聰明的婦人從城上喊：「請聽我說！請聽我說！請約押到這邊來，我有話要對他說。」 ");
INSERT INTO cmncbt_vpl VALUES ("S220_17","011_20_17","2SA","20","17","17","約押就走上前去，那婦人問道：「你是約押嗎？」約押答道：「我就是。」婦人說：「請聽婢女說幾句。」約押說：「你說吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("S220_18","011_20_18","2SA","20","18","18","婦人說：「古時候人們常說，『有事到亞比拉去請教，問題都會解決。』 ");
INSERT INTO cmncbt_vpl VALUES ("S220_19","011_20_19","2SA","20","19","19","我們這座城的人在以色列素來熱愛和平、忠心耿耿，你卻要毀滅這座大城。你為什麼要吞掉耶和華的產業？」 ");
INSERT INTO cmncbt_vpl VALUES ("S220_20","011_20_20","2SA","20","20","20","約押答道：「我根本不想吞掉或毀滅這城。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_21","011_20_21","2SA","20","21","21","事情不是這樣。以法蓮山區比基利的兒子示巴背叛大衛王，你們只要把他交出來，我就撤退。」那婦人說：「我們一定把他的首級從城上拋下來給你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S220_22","011_20_22","2SA","20","22","22","婦人把自己的良策告訴眾人，他們便把比基利的兒子示巴的頭割下來，拋給約押。約押就吹響號角令軍隊各自回家，自己回耶路撒冷見王。 ");
INSERT INTO cmncbt_vpl VALUES ("S220_23","011_20_23","2SA","20","23","23","約押負責統率以色列全軍；耶何耶大的兒子比拿雅統管基利提人和比利提人； ");
INSERT INTO cmncbt_vpl VALUES ("S220_24","011_20_24","2SA","20","24","24","亞多蘭管理服勞役的；亞希律的兒子約沙法做史官； ");
INSERT INTO cmncbt_vpl VALUES ("S220_25","011_20_25","2SA","20","25","25","示法做書記；撒督和亞比亞他做祭司； ");
INSERT INTO cmncbt_vpl VALUES ("S220_26","011_20_26","2SA","20","26","26","雅珥人以拉做大衛的祭司。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_1","011_21_1","2SA","21","1","1","在大衛執政期間，連續有三年饑荒，大衛就求問耶和華。耶和華說：「發生這饑荒是因為掃羅一家人的血債，他們殺害了基遍人。」 ");
INSERT INTO cmncbt_vpl VALUES ("S221_2","011_21_2","2SA","21","2","2","原來基遍人不是以色列人，他們是亞摩利人的遺民。以色列人曾起誓不傷害他們，但掃羅為以色列人和猶大人發熱心，試圖剷除基遍人。大衛就召來基遍人， ");
INSERT INTO cmncbt_vpl VALUES ("S221_3","011_21_3","2SA","21","3","3","問他們：「我可以為你們做些什麼？我該怎樣贖罪，你們才願意祝福耶和華的子民呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S221_4","011_21_4","2SA","21","4","4","基遍人答道：「金銀不能解決我們和掃羅一家人的問題，我們也不想處死任何以色列人。」大衛說：「你們要我怎麼辦？」 ");
INSERT INTO cmncbt_vpl VALUES ("S221_5","011_21_5","2SA","21","5","5","他們說：「掃羅曾試圖滅絕我們，把我們從以色列境內剷除。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_6","011_21_6","2SA","21","6","6","請把他的七個子孫交給我們，我們好在耶和華面前把他們吊死在基比亞，就是耶和華選立掃羅的地方。」王說：「我必把他們交給你們。」 ");
INSERT INTO cmncbt_vpl VALUES ("S221_7","011_21_7","2SA","21","7","7","大衛王因為與掃羅的兒子約拿單在耶和華面前起過誓，就沒有把掃羅的孫子、約拿單的兒子米非波設交出來。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_8","011_21_8","2SA","21","8","8","他把愛亞的女兒利斯巴為掃羅所生的兩個兒子亞摩尼、米非波設，以及掃羅女兒米拉為米何拉人巴西萊的兒子亞得列所生的五個兒子交給基遍人。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_9","011_21_9","2SA","21","9","9","基遍人在耶和華面前把他們七人吊死在山上。他們都一同死去，那時正好是收割大麥的時候。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_10","011_21_10","2SA","21","10","10","愛亞的女兒利斯巴取麻布為自己鋪在磐石上。她白天不讓飛鳥靠近，夜間不容野獸走近，從開始收割大麥，一直守到降下雨來。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_11","011_21_11","2SA","21","11","11","大衛知道掃羅的嬪妃——愛亞的女兒利斯巴的事以後， ");
INSERT INTO cmncbt_vpl VALUES ("S221_12","011_21_12","2SA","21","12","12","就去基列·雅比人那裡把掃羅和約拿單的骸骨運來。從前非利士人在基利波殺死掃羅和約拿單，把他們的屍體掛在伯·珊的廣場，後來基列·雅比人把屍體偷走了。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_13","011_21_13","2SA","21","13","13","大衛運回掃羅和約拿單的骸骨，又收殮了掃羅那七個子孫的骸骨。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_14","011_21_14","2SA","21","14","14","眾人按照大衛的吩咐，把掃羅和約拿單的骸骨埋葬在掃羅父親基士的墓裡，在便雅憫境內的洗拉。此後，上帝垂聽了人們為國家的禱告。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_15","011_21_15","2SA","21","15","15","非利士人又和以色列人交戰，大衛親自出征。在他十分疲倦的時候， ");
INSERT INTO cmncbt_vpl VALUES ("S221_16","011_21_16","2SA","21","16","16","一個名叫以實·比諾的巨人佩戴新刀，手拿三公斤半重的銅矛，衝上來要殺他。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_17","011_21_17","2SA","21","17","17","洗魯雅的兒子亞比篩趕來救駕，殺死了非利士巨人。這事以後，大衛的部下向他起誓說：「你絕不可再跟我們一起出戰，免得以色列的燈熄滅。」 ");
INSERT INTO cmncbt_vpl VALUES ("S221_18","011_21_18","2SA","21","18","18","後來，以色列人與非利士人在歌伯交戰，戶沙人西比該殺了另一個非利士巨人撒弗。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_19","011_21_19","2SA","21","19","19","在歌伯與非利士人的另一次交戰中，伯利恆人雅雷·俄珥金的兒子伊勒哈難殺了迦特人歌利亞。歌利亞的槍桿粗如織布機的軸。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_20","011_21_20","2SA","21","20","20","在迦特的一次交戰中，有一個非利士巨人每隻手和腳各有六個手指和腳趾，共二十四個手指和腳趾。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_21","011_21_21","2SA","21","21","21","他向以色列人罵陣，大衛的哥哥示米亞的兒子約拿單殺了他。 ");
INSERT INTO cmncbt_vpl VALUES ("S221_22","011_21_22","2SA","21","22","22","這四個迦特巨人的後裔都死在大衛和他的部下手裡。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","耶和華從掃羅及所有仇敵手中拯救大衛那天，他向耶和華吟唱此詩： ");
INSERT INTO cmncbt_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","「耶和華是我的磐石， 我的堡壘，我的拯救者； ");
INSERT INTO cmncbt_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","我的上帝是庇護我的磐石， 是我的盾牌，是拯救我的力量， 是我的堅壘，我的避難所， 我的救主。 你救我脫離殘暴之徒。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","我求告當受頌讚的耶和華， 祂便救我脫離仇敵。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","「死亡的波濤環繞我， 毀滅的狂流淹沒我。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","陰間的繩索捆綁我， 死亡的網羅籠罩我。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","「我在苦難中呼求耶和華， 向我的上帝求助， 祂從殿中垂聽我的呼求， 我的聲音達到祂耳中。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_8","011_22_8","2SA","22","8","8","「祂一發怒，大地震動顫抖， 穹蒼的根基搖晃。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_9","011_22_9","2SA","22","9","9","祂的鼻孔冒煙， 口噴烈焰和火炭。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_10","011_22_10","2SA","22","10","10","祂使穹蒼低垂，親自降臨， 腳下踩著密雲。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_11","011_22_11","2SA","22","11","11","祂乘著基路伯天使飛翔， 在風的翅膀上顯現。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_12","011_22_12","2SA","22","12","12","祂藏身於黑暗中， 四圍以密雲作幔幕。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_13","011_22_13","2SA","22","13","13","祂面前的榮光中發出道道閃電。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_14","011_22_14","2SA","22","14","14","耶和華在天上打雷， 至高者發出聲音。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_15","011_22_15","2SA","22","15","15","祂射出利箭驅散仇敵， 發出閃電擊潰他們。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_16","011_22_16","2SA","22","16","16","耶和華斥責一聲， 祂的鼻孔一吹氣， 海底就顯現， 大地也露出根基。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_17","011_22_17","2SA","22","17","17","「祂從高天伸手抓住我， 從大水中把我拉上來。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_18","011_22_18","2SA","22","18","18","祂救我脫離強敵， 脫離我無法戰勝的仇敵。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_19","011_22_19","2SA","22","19","19","他們在我危難之時攻擊我， 但耶和華扶持我。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_20","011_22_20","2SA","22","20","20","祂領我到寬闊之地； 祂搭救我，因為祂喜悅我。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","「耶和華因我公義而善待我， 因我清白而賞賜我。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","因為我遵行祂的道， 沒有作惡背棄我的上帝。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","「我遵守祂的一切法令， 沒有把祂的律例棄置一旁。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","我在祂面前純全無過， 沒有沾染罪惡。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","耶和華按我的公義， 照我在祂面前的清白獎賞我。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","「仁慈的人，你以仁慈待他； 純全的人，你以純全待他。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","純潔的人，你以純潔待他； 乖謬的人，你以計謀待他。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","你拯救謙卑的人， 鑒察、貶抑高傲的人。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","耶和華啊！你是我的明燈， 你使我的黑暗變為光明。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_30","011_22_30","2SA","22","30","30","我靠著你迎戰敵軍， 靠著我的上帝躍過牆垣。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","「上帝的道完美， 耶和華的話純全， 祂是一切投靠祂之人的盾牌。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","除了耶和華，誰是上帝呢？ 除了我們的上帝，誰是磐石呢？ ");
INSERT INTO cmncbt_vpl VALUES ("S222_33","011_22_33","2SA","22","33","33","上帝是我的堅固堡壘， 祂使我行為純全。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_34","011_22_34","2SA","22","34","34","祂使我的腳如母鹿的蹄， 穩踏在高處。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_35","011_22_35","2SA","22","35","35","祂訓練我的手如何爭戰， 使我的臂膀能拉開銅弓。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","你是拯救我的盾牌， 你的垂顧使我強大。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_37","011_22_37","2SA","22","37","37","你使我腳下的道路寬闊， 不致滑倒。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_38","011_22_38","2SA","22","38","38","我追趕仇敵，擊潰他們， 不消滅他們決不回頭。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_39","011_22_39","2SA","22","39","39","我打垮他們， 使他們倒在我的腳下， 再也站不起來。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_40","011_22_40","2SA","22","40","40","你賜我征戰的能力， 使我的仇敵降服在我腳下。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_41","011_22_41","2SA","22","41","41","你使我的仇敵敗逃， 我殲滅了恨我的人。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_42","011_22_42","2SA","22","42","42","他們呼救，卻無人拯救。 他們呼求耶和華，祂也不應允。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_43","011_22_43","2SA","22","43","43","我把他們打得粉碎，如同地上的灰塵， 壓碎並踐踏他們，如同街上的泥土。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_44","011_22_44","2SA","22","44","44","你救我脫離我百姓的攻擊， 立我做列國的元首， 素不相識的民族也服侍我。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_45","011_22_45","2SA","22","45","45","外族人望風而降，對我俯首稱臣。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_46","011_22_46","2SA","22","46","46","他們聞風喪膽， 戰戰兢兢地走出他們的城池。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_47","011_22_47","2SA","22","47","47","「耶和華永遠活著， 我的磐石當受頌讚， 拯救我的磐石，我的上帝當受尊崇。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_48","011_22_48","2SA","22","48","48","祂是為我伸冤的上帝， 祂使列邦臣服於我。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_49","011_22_49","2SA","22","49","49","祂救我脫離仇敵， 使我勝過強敵， 救我脫離殘暴之徒。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_50","011_22_50","2SA","22","50","50","因此，耶和華啊， 我要在列邦中讚美你， 歌頌你的名。 ");
INSERT INTO cmncbt_vpl VALUES ("S222_51","011_22_51","2SA","22","51","51","你使你立的王大獲全勝， 向你膏立的大衛及其後代廣施慈愛， 直到永遠。」 ");
INSERT INTO cmncbt_vpl VALUES ("S223_1","011_23_1","2SA","23","1","1","耶西的兒子大衛是雅各的上帝膏立的王，他身居高位，在以色列能歌善詠。以下是他的遺言： ");
INSERT INTO cmncbt_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","「耶和華的靈藉著我說話， 祂的言語在我口中。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_3","011_23_3","2SA","23","3","3","以色列的上帝告訴我， 以色列的磐石對我說， 『以公義治理人民， 敬畏上帝的君王， ");
INSERT INTO cmncbt_vpl VALUES ("S223_4","011_23_4","2SA","23","4","4","就像旭日的光輝、 晴朗的早晨， 又像雨後的光芒， 使大地長出青草。』 ");
INSERT INTO cmncbt_vpl VALUES ("S223_5","011_23_5","2SA","23","5","5","我的家在上帝面前不正是如此嗎？ 上帝與我立下永遠的約， 這約穩妥可靠。 祂必拯救我，成全我的願望。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_6","011_23_6","2SA","23","6","6","但惡人要像荊棘一樣被丟棄， 沒人用手拿起他們， ");
INSERT INTO cmncbt_vpl VALUES ("S223_7","011_23_7","2SA","23","7","7","人要拿鐵器和長矛把他們收集起來焚毀。」 ");
INSERT INTO cmncbt_vpl VALUES ("S223_8","011_23_8","2SA","23","8","8","以下是大衛的勇士：他革捫人約設·巴設，又稱伊斯尼人亞底挪，是三勇士之首，曾在一次交戰中殺掉八百敵人。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_9","011_23_9","2SA","23","9","9","其次是亞哈希人朵多的兒子以利亞撒，他是三勇士之一。有一次，以色列人和非利士人打仗，他跟隨大衛向非利士人罵陣。以色列人都撤退了， ");
INSERT INTO cmncbt_vpl VALUES ("S223_10","011_23_10","2SA","23","10","10","他卻堅守陣地，奮勇殺敵，直到手臂發麻，握刀的手無法鬆開。那天，耶和華使以色列人大獲全勝。以色列軍隊回到以利亞撒那裡來撿死人的財物。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_11","011_23_11","2SA","23","11","11","第三位勇士是哈拉人亞基的兒子沙瑪。有一次非利士人聚集在一塊長滿扁豆的田中和以色列人打仗，以色列人都逃跑了， ");
INSERT INTO cmncbt_vpl VALUES ("S223_12","011_23_12","2SA","23","12","12","沙瑪卻站在田中間堅守麥田，擊殺非利士人。耶和華使以色列人大獲全勝。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_13","011_23_13","2SA","23","13","13","在收割的時候，非利士軍隊在利乏音谷紮營，三十位統領中有三位到亞杜蘭洞見大衛。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_14","011_23_14","2SA","23","14","14","那時大衛留守在堡壘裡，非利士人的駐軍在伯利恆。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_15","011_23_15","2SA","23","15","15","大衛渴了，說：「但願有人給我打些伯利恆城門旁的井水喝！」 ");
INSERT INTO cmncbt_vpl VALUES ("S223_16","011_23_16","2SA","23","16","16","這三位勇士就衝過非利士人的營地，到伯利恆城門旁的井打水，帶回來給大衛。大衛卻不肯喝，他把水澆奠在耶和華面前， ");
INSERT INTO cmncbt_vpl VALUES ("S223_17","011_23_17","2SA","23","17","17","說：「耶和華啊！這三人冒死去打水，這些水就像是他們的血，我決不能喝！」因此，大衛不肯喝。這是三勇士的事蹟。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_18","011_23_18","2SA","23","18","18","洗魯雅的兒子、約押的兄弟亞比篩是這三位勇士的統領，他曾揮矛刺死三百人，在三勇士中出了名， ");
INSERT INTO cmncbt_vpl VALUES ("S223_19","011_23_19","2SA","23","19","19","最有聲望，因此做了他們的統領，只是不及前三位勇士。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_20","011_23_20","2SA","23","20","20","甲薛人耶何耶大的兒子比拿雅是位勇士，做過非凡的事。他曾殺死摩押的兩個勇猛戰士，也曾在下雪天跳進坑中殺死一頭獅子， ");
INSERT INTO cmncbt_vpl VALUES ("S223_21","011_23_21","2SA","23","21","21","還殺死了一個埃及勇士。當時埃及人拿著長矛，比拿雅拿著棍子迎戰，他奪了對方的長矛，用那矛刺死了對方。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_22","011_23_22","2SA","23","22","22","這是耶何耶大的兒子比拿雅的事蹟，他像那三位勇士一樣贏得了名聲。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_23","011_23_23","2SA","23","23","23","他比那三十勇士更有聲望，只是不及前三位勇士。大衛派他作護衛長。 ");
INSERT INTO cmncbt_vpl VALUES ("S223_24","011_23_24","2SA","23","24","24","三十位勇士中有：約押的兄弟亞撒黑、伯利恆人朵多的兒子伊勒哈難、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_25","011_23_25","2SA","23","25","25","哈律人沙瑪、哈律人以利加、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_26","011_23_26","2SA","23","26","26","帕勒提人希利斯、提哥亞人益吉的兒子以拉、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_27","011_23_27","2SA","23","27","27","亞拿突人亞比以謝、戶沙人米本乃、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_28","011_23_28","2SA","23","28","28","亞哈希人撒們、尼陀法人瑪哈萊、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_29","011_23_29","2SA","23","29","29","尼陀法人巴拿的兒子希立、便雅憫支派基比亞人利拜的兒子以太、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_30","011_23_30","2SA","23","30","30","比拉頓人比拿雅、迦實溪人希太、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_31","011_23_31","2SA","23","31","31","伯·亞拉巴人亞比亞本、巴魯米人押斯瑪弗、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_32","011_23_32","2SA","23","32","32","沙本人以利雅哈巴、雅善的兒子們、哈拉人沙瑪的兒子約拿單、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_33","011_23_33","2SA","23","33","33","哈拉人沙拉的兒子亞希暗、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_34","011_23_34","2SA","23","34","34","瑪迦人亞哈拜的兒子以利法列、基羅人亞希多弗的兒子以連、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_35","011_23_35","2SA","23","35","35","迦密人希斯萊、亞巴人帕萊、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_36","011_23_36","2SA","23","36","36","瑣巴人拿單的兒子以甲、迦得人巴尼、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_37","011_23_37","2SA","23","37","37","亞捫人洗勒、為洗魯雅的兒子約押拿兵器的比錄人拿哈萊、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_38","011_23_38","2SA","23","38","38","以帖人以拉、以帖人迦立、 ");
INSERT INTO cmncbt_vpl VALUES ("S223_39","011_23_39","2SA","23","39","39","赫人烏利亞，共三十七名勇士。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_1","011_24_1","2SA","24","1","1","耶和華又向以色列人發怒，祂促使大衛來對付他們，讓大衛統計以色列和猶大的人口。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_2","011_24_2","2SA","24","2","2","大衛對統領軍隊的約押說：「你去走遍以色列各支派，從但到別示巴，統計以色列和猶大的人口，讓我知道國民的數目。」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_3","011_24_3","2SA","24","3","3","約押說：「我主我王，願你的上帝耶和華使國民的人數比現在增加百倍，讓你親眼看到。但我主我王為什麼要做這事呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_4","011_24_4","2SA","24","4","4","但大衛不聽約押和其他將領的規勸。他們只好去統計以色列的人數。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_5","011_24_5","2SA","24","5","5","他們過了約旦河，在谷中亞羅珥城南面安營，又經過迦得前往雅謝。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_6","011_24_6","2SA","24","6","6","然後，他們到基列、他停·合示地區、但·雅安，繞到西頓， ");
INSERT INTO cmncbt_vpl VALUES ("S224_7","011_24_7","2SA","24","7","7","再去泰爾的堡壘及希未人和迦南人的城邑。最後，他們到了猶大南部的別示巴。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_8","011_24_8","2SA","24","8","8","他們花了九個月零二十天的時間，走遍全國，最後回到耶路撒冷。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_9","011_24_9","2SA","24","9","9","約押把統計的人數奏告王：「以色列有八十萬英勇的刀兵，猶大有五十萬。」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_10","011_24_10","2SA","24","10","10","大衛統計了人口以後，內心不安，就對耶和華說：「我做這事犯了大罪。耶和華啊，求你赦免僕人的罪，我做了極其愚昧的事。」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_11","011_24_11","2SA","24","11","11","大衛第二天早上起來，耶和華對大衛的先見迦得先知說： ");
INSERT INTO cmncbt_vpl VALUES ("S224_12","011_24_12","2SA","24","12","12","「你去告訴大衛，耶和華說，『我有三樣災禍，你可以選擇讓我降哪一樣給你。』」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_13","011_24_13","2SA","24","13","13","迦得就來見大衛，對他說：「你願意國內有七年饑荒呢？還是被敵人追殺三個月呢？還是國內發生三天瘟疫呢？請你考慮好後告訴我，我好回覆那差我來的。」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_14","011_24_14","2SA","24","14","14","大衛說：「我實在為難！不過我寧願落在耶和華的手中，也不願落在人的手中，因為耶和華有極大的憐憫。」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_15","011_24_15","2SA","24","15","15","於是，耶和華在以色列降下瘟疫，從那天早晨一直持續到所定的時間，從但到別示巴共有七萬人死亡。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_16","011_24_16","2SA","24","16","16","當天使準備伸手毀滅耶路撒冷的時候，耶和華心生憐憫，就對滅命天使說：「夠了，住手吧！」當時，耶和華的天使正站在耶布斯人亞勞拿的麥場上。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_17","011_24_17","2SA","24","17","17","大衛看見滅命天使，就對耶和華說：「是我犯了罪，做了惡事，這些百姓有什麼過錯呢？願你的手懲罰我和我的家族。」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_18","011_24_18","2SA","24","18","18","就在那天，迦得來見大衛，對他說：「你要去耶布斯人亞勞拿的麥場，在那裡為耶和華建一座壇。」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_19","011_24_19","2SA","24","19","19","大衛就照耶和華藉迦得所說的話去了麥場。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_20","011_24_20","2SA","24","20","20","亞勞拿看見王及他的臣僕來了，就上前俯伏在地，向王下拜， ");
INSERT INTO cmncbt_vpl VALUES ("S224_21","011_24_21","2SA","24","21","21","說：「我主我王到僕人這裡有什麼事？」大衛說：「我要買你的麥場，好在這裡為耶和華築一座壇，使民中的瘟疫止息。」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_22","011_24_22","2SA","24","22","22","亞勞拿說：「我主我王喜歡什麼，就拿去獻祭吧。這裡有牛可以作燔祭，還有打麥的器具和牛軛可以作柴。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_23","011_24_23","2SA","24","23","23","王啊，僕人亞勞拿願意把這一切都獻給你，願你的上帝耶和華悅納你。」 ");
INSERT INTO cmncbt_vpl VALUES ("S224_24","011_24_24","2SA","24","24","24","王卻說：「不可，我一定要出錢買，我不要用白白得來之物作為燔祭獻給我的上帝耶和華。」大衛就用十兩銀子買了亞勞拿的麥場和牛。 ");
INSERT INTO cmncbt_vpl VALUES ("S224_25","011_24_25","2SA","24","25","25","大衛在那裡為耶和華建了一座壇，獻上燔祭和平安祭，耶和華垂聽了他的禱告，瘟疫就在以色列止住了。");
INSERT INTO cmncbt_vpl VALUES ("K11_1","012_1_1","1KI","1","1","1","大衛王年紀老邁，雖然蓋了幾層被子，仍然覺得冷。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_2","012_1_2","1KI","1","2","2","他的臣僕建議：「不如選一位少女進宮伺候、照顧我主我王，讓她睡在王懷中給王取暖。」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_3","012_1_3","1KI","1","3","3","於是，他們在以色列全國尋找美貌女子，找到了一位名叫雅比莎的書念少女，把她帶到王那裡。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_4","012_1_4","1KI","1","4","4","這女子長得非常美麗，她照顧、伺候王，但王沒有與她同房。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_5","012_1_5","1KI","1","5","5","那時，哈及的兒子亞多尼雅妄自尊大，說：「我必做王。」他為自己製備了車輛和騎兵，派五十人在前面開路。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_6","012_1_6","1KI","1","6","6","他父親從不責問他：「你這是做什麼？」他是押沙龍的弟弟，長得英俊非凡。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_7","012_1_7","1KI","1","7","7","亞多尼雅與洗魯雅的兒子約押及祭司亞比亞他商議，二人都答應支持他。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_8","012_1_8","1KI","1","8","8","不過，撒督祭司、耶何耶大的兒子比拿雅、拿單先知、示每、利以和大衛的勇士卻沒有跟隨他。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_9","012_1_9","1KI","1","9","9","一天，亞多尼雅在隱·羅結附近的瑣希列磐石那裡宰了牛羊和肥牛犢獻祭，並邀請了眾王子和猶大的群臣。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_10","012_1_10","1KI","1","10","10","可是他沒有邀請拿單先知、比拿雅、大衛的勇士和他的兄弟所羅門。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_11","012_1_11","1KI","1","11","11","拿單對所羅門的母親拔示巴說：「你沒有聽說嗎？哈及的兒子亞多尼雅做王了，我們的主大衛還不知道。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_12","012_1_12","1KI","1","12","12","事到如今，我有一個主意，可以保住你和你兒子所羅門的性命。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_13","012_1_13","1KI","1","13","13","你去見大衛王，對他說，『我主我王啊，你不是起誓說讓臣妾的兒子所羅門繼承王位，坐你的寶座嗎？怎麼現在亞多尼雅做了王呢？』 ");
INSERT INTO cmncbt_vpl VALUES ("K11_14","012_1_14","1KI","1","14","14","你跟王還在說話的時候，我會進去證實你的話。」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_15","012_1_15","1KI","1","15","15","拔示巴就進內室去見年邁的王，書念的少女雅比莎正在伺候他。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_16","012_1_16","1KI","1","16","16","拔示巴向王屈身下拜。王問道：「你有什麼事嗎？」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_17","012_1_17","1KI","1","17","17","拔示巴回答說：「我主啊，你曾經憑你的上帝耶和華起誓說讓臣妾的兒子所羅門繼承你的王位，坐你的寶座。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_18","012_1_18","1KI","1","18","18","但現在亞多尼雅已經稱王了，我主我王還不知道。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_19","012_1_19","1KI","1","19","19","他宰了許多牛羊和肥牛犢獻祭，邀請眾王子、亞比亞他祭司和約押元帥，卻沒有邀請你的僕人所羅門。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_20","012_1_20","1KI","1","20","20","我主我王啊！以色列舉國拭目以待，等你來指定誰坐在我主我王的寶座上繼承王位。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_21","012_1_21","1KI","1","21","21","不然，到我主我王與祖先同眠之後，我和我兒所羅門必被定為罪人。」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_22","012_1_22","1KI","1","22","22","她與王正說話間，拿單先知進宮來了。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_23","012_1_23","1KI","1","23","23","有人奏告王，說：「拿單先知來了。」拿單來到王面前，俯伏在地， ");
INSERT INTO cmncbt_vpl VALUES ("K11_24","012_1_24","1KI","1","24","24","說：「我主我王啊，你已經宣佈讓亞多尼雅繼承你的王位，坐你的寶座嗎？ ");
INSERT INTO cmncbt_vpl VALUES ("K11_25","012_1_25","1KI","1","25","25","他今天宰了許多牛羊和肥犢獻祭，宴請眾王子、將領和亞比亞他祭司，他們正在他那裡一邊吃喝一邊說，『亞多尼雅王萬歲！』 ");
INSERT INTO cmncbt_vpl VALUES ("K11_26","012_1_26","1KI","1","26","26","但他沒有邀請臣僕我、撒督祭司、耶何耶大的兒子比拿雅和你的僕人所羅門。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_27","012_1_27","1KI","1","27","27","這是我主我王的旨意嗎？王還沒有對臣僕們說過誰坐在我主我王的寶座上繼承王位。」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_28","012_1_28","1KI","1","28","28","於是，大衛王召見拔示巴。拔示巴立刻晉見，侍立在王面前。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_29","012_1_29","1KI","1","29","29","王起誓說：「我憑救我脫離一切苦難的永活的耶和華起誓， ");
INSERT INTO cmncbt_vpl VALUES ("K11_30","012_1_30","1KI","1","30","30","我今天必實現我憑以色列的上帝耶和華向你起的誓。你的兒子所羅門必繼承王位，坐在我的寶座上。」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_31","012_1_31","1KI","1","31","31","拔示巴就向王俯伏下拜說：「我主大衛王萬歲！」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_32","012_1_32","1KI","1","32","32","大衛王又召見撒督祭司、拿單先知和耶何耶大的兒子比拿雅。他們都來到王面前。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_33","012_1_33","1KI","1","33","33","王囑咐道：「你們要率領我的隨從，讓我兒所羅門騎上我的騾子，護送他下到基訓。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_34","012_1_34","1KI","1","34","34","撒督祭司和拿單先知要在那裡膏立他為以色列王。你們要吹響號角，高喊，『所羅門王萬歲！』 ");
INSERT INTO cmncbt_vpl VALUES ("K11_35","012_1_35","1KI","1","35","35","然後，你們要隨他回來，他要登基，繼承我的王位。我已立他做以色列和猶大的君王了。」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_36","012_1_36","1KI","1","36","36","耶何耶大的兒子比拿雅說：「遵命！願我主我王的上帝耶和華成全這事。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_37","012_1_37","1KI","1","37","37","耶和華怎樣與我主我王同在，願祂也照樣與所羅門同在，使他的王權比我主大衛王的更強大。」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_38","012_1_38","1KI","1","38","38","於是，撒督祭司、拿單先知、耶何耶大的兒子比拿雅，以及基利提人和比利提人請所羅門騎上大衛王的騾子，護送他前往基訓。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_39","012_1_39","1KI","1","39","39","撒督祭司從聖幕裡拿來盛膏油的角，膏立所羅門為王。他們吹響號角，民眾高聲歡呼：「所羅門王萬歲！」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_40","012_1_40","1KI","1","40","40","眾人浩浩蕩蕩地隨著所羅門回京，一路上吹笛歡呼，聲音震動大地。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_41","012_1_41","1KI","1","41","41","亞多尼雅和他的眾賓客剛剛飲宴完畢，聽見了這聲音。約押聽見號角聲，便問：「城裡為什麼如此喧鬧？」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_42","012_1_42","1KI","1","42","42","就在這時候，亞比亞他祭司的兒子約拿單來了，亞多尼雅說：「進來！你是個忠勇的人，一定帶來了好消息。」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_43","012_1_43","1KI","1","43","43","約拿單說：「我們的主大衛王已經立所羅門為王了。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_44","012_1_44","1KI","1","44","44","王派撒督祭司、拿單先知、耶何耶大的兒子比拿雅，以及基利提人和比利提人護送所羅門騎上王的騾子。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_45","012_1_45","1KI","1","45","45","撒督祭司和拿單先知在基訓膏立他為王，他們一路上歡呼著回來了，全城轟動。你們聽到的就是他們的聲音。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_46","012_1_46","1KI","1","46","46","所羅門已經登基掌權， ");
INSERT INTO cmncbt_vpl VALUES ("K11_47","012_1_47","1KI","1","47","47","王的臣僕也來向我們的主大衛王道喜說，『願你的上帝使所羅門比你名聲更大，使他的王權比你的更強大。』王在床上俯伏敬拜， ");
INSERT INTO cmncbt_vpl VALUES ("K11_48","012_1_48","1KI","1","48","48","說，『以色列的上帝耶和華當受稱頌，因為祂讓我親眼看見我的繼承人今天登基。』」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_49","012_1_49","1KI","1","49","49","亞多尼雅的眾賓客聽後，嚇得四散而去。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_50","012_1_50","1KI","1","50","50","亞多尼雅懼怕所羅門，就去抓住祭壇的角。 ");
INSERT INTO cmncbt_vpl VALUES ("K11_51","012_1_51","1KI","1","51","51","有人告訴所羅門：「亞多尼雅懼怕王，現在正抓住祭壇的角，要王今天起誓不要殺他。」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_52","012_1_52","1KI","1","52","52","所羅門說：「他若作個忠義的人，必毫髮無損；他若作惡，必死無疑。」 ");
INSERT INTO cmncbt_vpl VALUES ("K11_53","012_1_53","1KI","1","53","53","於是，所羅門王便派人去把亞多尼雅從祭壇上帶下來。亞多尼雅前來向所羅門王俯伏下拜，所羅門對他說：「你回家去吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","大衛臨終時，叮囑他兒子所羅門說： ");
INSERT INTO cmncbt_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","「我要走世人都必走的那條路了。你要剛強，做大丈夫。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","你要遵從你的上帝耶和華的吩咐，遵行祂的道，照摩西的律法遵守上帝的律例、誡命、典章和法度。這樣，你無論做什麼、去哪裡都必亨通， ");
INSERT INTO cmncbt_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","耶和華必成就給我的應許，祂對我說，『如果你的子孫謹慎自守，全心全意地在我面前盡忠，你的以色列王朝必世代相傳。』 ");
INSERT INTO cmncbt_vpl VALUES ("K12_5","012_2_5","1KI","2","5","5","「你知道洗魯雅的兒子約押怎樣對我，他殺了以色列的兩名元帥尼珥的兒子押尼珥和益帖的兒子亞瑪撒。他在太平的時候把他們當作戰場的敵手殺害，腰帶和鞋上沾滿了他們的血。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_6","012_2_6","1KI","2","6","6","你要用智慧處置他，不可讓他安享天年。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_7","012_2_7","1KI","2","7","7","「你要恩待基列人巴西萊的眾子，讓他們成為你的座上賓，因為我逃避你哥哥押沙龍的時候，他們曾接待我。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_8","012_2_8","1KI","2","8","8","「別放過巴戶琳的便雅憫人基拉的兒子示每。我逃亡到瑪哈念的時候，他曾用惡毒的話咒罵我。後來他到約旦河迎接我的時候，我曾憑耶和華起誓不殺他。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_9","012_2_9","1KI","2","9","9","但你不要放過他。你是個聰明人，知道該怎樣處置他。你要讓他白頭落地，不得善終。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","大衛與祖先同眠後，葬在大衛城。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","他統治以色列四十年，他在希伯崙執政七年，在耶路撒冷執政三十三年。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","所羅門繼承大衛的王位，江山穩固。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_13","012_2_13","1KI","2","13","13","一天，哈及的兒子亞多尼雅來見所羅門的母親拔示巴，拔示巴問他：「你是為平安而來嗎？」亞多尼雅說：「是為平安而來。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_14","012_2_14","1KI","2","14","14","又說：「我有事稟告。」拔示巴說：「你說吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_15","012_2_15","1KI","2","15","15","亞多尼雅說：「你知道，王位本該是我的，整個以色列原指望我做王。不料，王位歸了我兄弟，因為這是上帝的旨意。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_16","012_2_16","1KI","2","16","16","現在我有一個請求，請你不要推辭。」拔示巴說：「你說吧。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_17","012_2_17","1KI","2","17","17","他說：「請你求所羅門王將那書念女子雅比莎賜我為妻，他不會拒絕你。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_18","012_2_18","1KI","2","18","18","拔示巴說：「好吧，我會為你向王請求。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_19","012_2_19","1KI","2","19","19","拔示巴就為亞多尼雅的事去見所羅門王，王離座迎接，向她下拜，然後坐回位上，命人在自己右邊為她擺設座位。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_20","012_2_20","1KI","2","20","20","拔示巴說：「我有一件小事求你，請你不要推辭。」王說：「母親請說，我必不推辭。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_21","012_2_21","1KI","2","21","21","拔示巴說：「請將書念女子雅比莎賜給你哥哥亞多尼雅為妻。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_22","012_2_22","1KI","2","22","22","所羅門王回答說：「為何只為亞多尼雅求書念女子雅比莎呢？你也為他求這國家吧！他是我哥哥，又有亞比亞他祭司和洗魯雅的兒子約押支持。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_23","012_2_23","1KI","2","23","23","所羅門王就憑耶和華起誓說：「亞多尼雅若不為他這樣的要求付出性命，願上帝重重地懲罰我。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_24","012_2_24","1KI","2","24","24","耶和華讓我穩穩地坐在父親大衛的寶座上，照祂的應許為我建立了王朝，我憑永活的耶和華起誓，亞多尼雅今天必被處死。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_25","012_2_25","1KI","2","25","25","於是，所羅門王命令耶何耶大的兒子比拿雅殺死亞多尼雅。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_26","012_2_26","1KI","2","26","26","王對亞比亞他祭司說：「你回亞拿突的老家去吧。你本是該死的，但我念你在我父大衛面前抬過主耶和華的約櫃，曾經與我父親患難與共，才饒你一命。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_27","012_2_27","1KI","2","27","27","所羅門就罷免了亞比亞他的職位，不許他再做耶和華的祭司。這事應驗了耶和華在示羅所說的有關以利家的預言。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_28","012_2_28","1KI","2","28","28","約押雖然沒有支持押沙龍，但卻支持了亞多尼雅。他聽見風聲，就逃進聖幕，抓住祭壇的角。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_29","012_2_29","1KI","2","29","29","有人把這消息告訴所羅門王，說約押已經逃進聖幕，躲在祭壇旁邊。所羅門就派耶何耶大的兒子比拿雅去殺他。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_30","012_2_30","1KI","2","30","30","比拿雅來到耶和華的聖幕，對約押說：「王吩咐你出來！」約押卻回答說：「不，我要死在這裡。」比拿雅回去稟告王。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_31","012_2_31","1KI","2","31","31","王說：「你就照他的話成全他，埋葬他，把他濫殺無辜的罪從我和我父親家清除。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_32","012_2_32","1KI","2","32","32","耶和華要讓他血債血還。因為他背著我父親殺了兩名比他良善正直的人，即尼珥的兒子以色列元帥押尼珥和益帖的兒子猶大元帥亞瑪撒。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_33","012_2_33","1KI","2","33","33","所以，殺這二人的血債必永遠歸到約押和他後代身上。願耶和華的平安永遠伴隨大衛和他的後代、他的家、他的王位。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_34","012_2_34","1KI","2","34","34","耶何耶大的兒子比拿雅就去把約押殺死，葬在曠野約押自己的墓地。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_35","012_2_35","1KI","2","35","35","王委派耶何耶大的兒子比拿雅替代約押為元帥，命撒督祭司代替亞比亞他。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_36","012_2_36","1KI","2","36","36","王又派人將示每召來，對他說：「你要在耶路撒冷建屋居住，不得出城去其他地方。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_37","012_2_37","1KI","2","37","37","你哪天越過汲淪溪，哪天必死無疑，你的死是咎由自取。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_38","012_2_38","1KI","2","38","38","示每說：「好，僕人必照我主我王說的做。」示每就一直住在耶路撒冷。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_39","012_2_39","1KI","2","39","39","過了三年，示每的兩個僕人逃到迦特王瑪迦的兒子亞吉那裡。示每知道後， ");
INSERT INTO cmncbt_vpl VALUES ("K12_40","012_2_40","1KI","2","40","40","就備上驢到迦特的亞吉那裡找他的僕人，並把他們帶了回來。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_41","012_2_41","1KI","2","41","41","所羅門聽說示每從耶路撒冷前往迦特，已經返回， ");
INSERT INTO cmncbt_vpl VALUES ("K12_42","012_2_42","1KI","2","42","42","就派人召來示每，問道：「我不是叫你憑耶和華起誓不離開耶路撒冷嗎？我警告過你，你哪天離開這裡，哪天必死無疑。當時你也同意。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_43","012_2_43","1KI","2","43","43","現在你為何不守你向耶和華起的誓，不遵行我的命令？」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_44","012_2_44","1KI","2","44","44","王又說：「你以前如何惡待我父大衛，你自己心裡明白，現在耶和華要追究你的罪行了。 ");
INSERT INTO cmncbt_vpl VALUES ("K12_45","012_2_45","1KI","2","45","45","但所羅門王必蒙祝福，大衛的王位必在耶和華面前必永遠穩固。」 ");
INSERT INTO cmncbt_vpl VALUES ("K12_46","012_2_46","1KI","2","46","46","於是，王命令耶何耶大的兒子比拿雅殺死示每。這樣所羅門的江山得以穩固。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_1","012_3_1","1KI","3","1","1","所羅門娶了埃及法老的女兒，與法老聯姻。他在自己的王宮、耶和華的殿和耶路撒冷的城牆完工之前，讓她一直住在大衛城。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_2","012_3_2","1KI","3","2","2","那時候，用來尊崇耶和華之名的殿還沒有建成，以色列人仍然在邱壇獻祭。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","所羅門愛耶和華，遵行他父親大衛的律例，只是仍然在邱壇獻祭燒香。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","有一次，所羅門王上基遍獻了一千頭祭牲作燔祭，因為那裡有最重要的邱壇。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","在基遍，耶和華晚上在夢中向所羅門顯現，對他說：「你想要什麼，只管向我求。」 ");
INSERT INTO cmncbt_vpl VALUES ("K13_6","012_3_6","1KI","3","6","6","所羅門說：「你的僕人——我父大衛本著誠實、公義、正直的心在你面前行事，你就向他大施恩慈，並且一如既往地以厚恩待他，讓他兒子今天繼承他的王位。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","我的上帝耶和華啊，你讓僕人繼承我父大衛的王位，但僕人還年幼無知，不懂得如何治理國家。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","僕人住在你所揀選的子民中，這些子民多得不可勝數。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","求你賜我智慧治理你的子民，並能辨別是非；不然，誰能治理你這眾多的子民呢？」 ");
INSERT INTO cmncbt_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","主喜悅所羅門的祈求， ");
INSERT INTO cmncbt_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","對他說：「既然你不為自己求壽、求財富，也不求滅絕仇敵，只求有智慧秉公治理我的子民， ");
INSERT INTO cmncbt_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","我必應允你，賜給你空前絕後的智慧和悟性。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","你沒有求富貴和尊榮，但我會一併賜給你，使你有生之年在列王中無人能比。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","你若像你父親大衛一樣遵行我的道，遵守我的律例和誡命，我必使你長壽。」 ");
INSERT INTO cmncbt_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","所羅門醒來，發現是做了一個夢。他回到耶路撒冷，站在耶和華的約櫃前獻上燔祭和平安祭，又宴請群臣。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","一天，兩個妓女到王面前告狀。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","其中一個說：「我主啊，我跟這女人同住，我生了一個男孩，當時她也在場。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","我生產三天後，她也生了一個男孩。我們住在一起，除了我們二人，屋裡沒有別人。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","一天晚上，她不小心壓死了自己的孩子。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","她半夜起來，趁我熟睡的時候抱走了我身邊的孩子，放在她懷中，把她的死孩子放在我懷中。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","天快亮的時候，我起來給孩子餵奶，發現孩子死了。天亮後，我仔細察看孩子，發現孩子不是我生的。」 ");
INSERT INTO cmncbt_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","另一個女人說：「不對！活孩子是我的，死孩子是你的。」第一個女人說：「不對！死孩子是你的，活孩子是我的。」兩個女人在王面前爭吵起來。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","王見她們二人都說活孩子是自己的，死孩子是對方的， ");
INSERT INTO cmncbt_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","就命人拿刀來。侍從把刀拿來後， ");
INSERT INTO cmncbt_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","王下令將那活孩子劈成兩半，讓她們各得一半。 ");
INSERT INTO cmncbt_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","活孩子的母親心疼自己的孩子，就說：「我主啊，把孩子給她吧，千萬不要殺他！」但另一個女人卻說：「孩子不歸我，也不歸你，把他劈開吧！」 ");
INSERT INTO cmncbt_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","王說：「不可殺這孩子，把他交給剛才為孩子求情的女人吧！她是孩子的母親。」 ");
INSERT INTO cmncbt_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","以色列人聽見王這樣斷案，都敬畏他，因為他們知道他有上帝所賜的智慧，能夠秉公斷案。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_1","012_4_1","1KI","4","1","1","所羅門王統治以色列， ");
INSERT INTO cmncbt_vpl VALUES ("K14_2","012_4_2","1KI","4","2","2","以下是他的眾臣僕：撒督的兒子亞撒利雅做祭司； ");
INSERT INTO cmncbt_vpl VALUES ("K14_3","012_4_3","1KI","4","3","3","示沙的兒子以利何烈和亞希亞做書記；亞希律的兒子約沙法做史官； ");
INSERT INTO cmncbt_vpl VALUES ("K14_4","012_4_4","1KI","4","4","4","耶何耶大的兒子比拿雅做元帥；撒督和亞比亞他做祭司長； ");
INSERT INTO cmncbt_vpl VALUES ("K14_5","012_4_5","1KI","4","5","5","拿單的兒子亞撒利雅掌管吏部；拿單的兒子撒布得祭司做所羅門王的顧問； ");
INSERT INTO cmncbt_vpl VALUES ("K14_6","012_4_6","1KI","4","6","6","亞希煞總管宮廷事務；亞比大的兒子亞多尼蘭總管做勞役的。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_7","012_4_7","1KI","4","7","7","所羅門在以色列全國設立了十二個地方官，負責供給王及王室的需用，每年每人負責一個月。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_8","012_4_8","1KI","4","8","8","這十二個地方官是：便·戶珥，負責以法蓮山區； ");
INSERT INTO cmncbt_vpl VALUES ("K14_9","012_4_9","1KI","4","9","9","便·底甲，負責瑪迦斯、沙賓、伯·示麥、以倫·伯·哈南； ");
INSERT INTO cmncbt_vpl VALUES ("K14_10","012_4_10","1KI","4","10","10","便·希悉，負責亞魯泊，包括梭哥和希弗全境； ");
INSERT INTO cmncbt_vpl VALUES ("K14_11","012_4_11","1KI","4","11","11","所羅門女兒她法的丈夫便·亞比拿達，負責多珥高原； ");
INSERT INTO cmncbt_vpl VALUES ("K14_12","012_4_12","1KI","4","12","12","亞希律的兒子巴拿，負責他納和米吉多，靠近撒拉他拿、耶斯列下邊的伯·善全境，以及從伯·善到亞伯·米何拉，遠至約緬； ");
INSERT INTO cmncbt_vpl VALUES ("K14_13","012_4_13","1KI","4","13","13","便·基別，負責基列的拉末和瑪拿西子孫雅珥在基列的城邑，以及巴珊的亞珥歌伯地區有城牆和銅閂的大城六十座； ");
INSERT INTO cmncbt_vpl VALUES ("K14_14","012_4_14","1KI","4","14","14","易多的兒子亞希拿達，負責瑪哈念； ");
INSERT INTO cmncbt_vpl VALUES ("K14_15","012_4_15","1KI","4","15","15","所羅門的另一個女兒巴實抹的丈夫亞希瑪斯，負責拿弗他利； ");
INSERT INTO cmncbt_vpl VALUES ("K14_16","012_4_16","1KI","4","16","16","戶篩的兒子巴拿，負責亞設和亞祿； ");
INSERT INTO cmncbt_vpl VALUES ("K14_17","012_4_17","1KI","4","17","17","帕路亞的兒子約沙法，負責以薩迦； ");
INSERT INTO cmncbt_vpl VALUES ("K14_18","012_4_18","1KI","4","18","18","以拉的兒子示每，負責便雅憫； ");
INSERT INTO cmncbt_vpl VALUES ("K14_19","012_4_19","1KI","4","19","19","烏利的兒子基別，獨自負責從前屬亞摩利王西宏和巴珊王噩的基列地區。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","猶大人和以色列人多如海沙，豐衣足食，生活幸福。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_21","012_4_21","1KI","4","21","21","所羅門統管列國，從幼發拉底河至非利士，直到埃及邊界。所羅門在世的日子，列國都年年進貢稱臣。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_22","012_4_22","1KI","4","22","22","所羅門每天的膳食用三千公斤細麵粉、六千公斤粗麵粉、 ");
INSERT INTO cmncbt_vpl VALUES ("K14_23","012_4_23","1KI","4","23","23","十頭肥牛、二十頭草場的牛、一百隻羊，此外還有鹿、羚羊、麅子及肥禽。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_24","012_4_24","1KI","4","24","24","所羅門統治幼發拉底河西面所有的國家，從提弗薩直到迦薩，四境安寧。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_25","012_4_25","1KI","4","25","25","所羅門在世的時候，從但到別示巴的猶大人和以色列人都在自己的葡萄樹和無花果樹下安居。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_26","012_4_26","1KI","4","26","26","所羅門有四萬個安置拉戰車馬匹的馬廄和一萬二千名騎兵。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_27","012_4_27","1KI","4","27","27","十二個地方官按月供給所羅門王及王室的需用，使他們一無所缺。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_28","012_4_28","1KI","4","28","28","他們也各按其份提供餵戰車馬等馬匹用的大麥和乾草。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_29","012_4_29","1KI","4","29","29","上帝賜予所羅門極大的智慧和悟性，以及如海邊的沙一樣浩博的學識。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_30","012_4_30","1KI","4","30","30","他的智慧高過東方人和埃及人的一切智慧， ");
INSERT INTO cmncbt_vpl VALUES ("K14_31","012_4_31","1KI","4","31","31","無人能比，勝過以斯拉人以探和瑪曷的兒子希幔、甲各、達大的智慧。他名揚四周列國。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_32","012_4_32","1KI","4","32","32","所羅門寫下箴言三千句，作詩歌一千零五首。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_33","012_4_33","1KI","4","33","33","他對飛禽走獸、草木魚蟲，從黎巴嫩的香柏樹到長在牆上的牛膝草，都無所不知。 ");
INSERT INTO cmncbt_vpl VALUES ("K14_34","012_4_34","1KI","4","34","34","天下列王風聞所羅門的智慧，都紛紛遣使來求教。 ");
INSERT INTO cmncbt_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","泰爾王希蘭素來與大衛修好，他聽說以色列人膏立了所羅門繼承大衛的王位，就派使者來見所羅門。 ");
INSERT INTO cmncbt_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","所羅門也傳信給希蘭，說： ");
INSERT INTO cmncbt_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","「你知道，我父大衛因周圍戰事連連，未能為他的上帝耶和華的名建殿，要等到耶和華使仇敵伏在他腳下後再建。 ");
INSERT INTO cmncbt_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","現在我的上帝耶和華使我四境太平，內外無患， ");
INSERT INTO cmncbt_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","我想為我的上帝耶和華建殿，因為耶和華曾對我父大衛說，『我必使你的兒子繼承你的王位，他必為我的名建殿。』 ");
INSERT INTO cmncbt_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","請你命人為我砍伐黎巴嫩的香柏木。我會派人幫助你的人，並按你的要求付你的人工錢。因為你知道，我們沒有人像西頓人那樣善於砍伐樹木。」 ");
INSERT INTO cmncbt_vpl VALUES ("K15_7","012_5_7","1KI","5","7","7","希蘭聽了所羅門的話後，非常高興，說：「今天當讚美耶和華！祂賜給大衛一個有智慧的兒子治理這偉大的民族。」 ");
INSERT INTO cmncbt_vpl VALUES ("K15_8","012_5_8","1KI","5","8","8","他派人回覆所羅門說：「我已收到你派人帶來的口信。我一定會照你的心願提供香柏木和松木。 ");
INSERT INTO cmncbt_vpl VALUES ("K15_9","012_5_9","1KI","5","9","9","我的工人會將這些木料從黎巴嫩運到海邊，紮成木筏，經海道運到你指定的地點。木筏拆散以後，你就可以點收了。你也要成全我的心願，供應我家食糧。」 ");
INSERT INTO cmncbt_vpl VALUES ("K15_10","012_5_10","1KI","5","10","10","於是，希蘭供應所羅門需用的香柏木和松木， ");
INSERT INTO cmncbt_vpl VALUES ("K15_11","012_5_11","1KI","5","11","11","所羅門每年供應希蘭四百四十萬升麥子和四十四萬升橄欖油。 ");
INSERT INTO cmncbt_vpl VALUES ("K15_12","012_5_12","1KI","5","12","12","耶和華照著應許賜給所羅門智慧。他跟希蘭修好，締結盟約。 ");
INSERT INTO cmncbt_vpl VALUES ("K15_13","012_5_13","1KI","5","13","13","所羅門王從以色列徵集了三萬勞工， ");
INSERT INTO cmncbt_vpl VALUES ("K15_14","012_5_14","1KI","5","14","14","派他們每月輪班到黎巴嫩工作，每班一萬人，在黎巴嫩一個月，在家兩個月。亞多尼蘭做他們的總管。 ");
INSERT INTO cmncbt_vpl VALUES ("K15_15","012_5_15","1KI","5","15","15","所羅門又徵用了七萬名搬運工，八萬名在山上鑿石的匠人。 ");
INSERT INTO cmncbt_vpl VALUES ("K15_16","012_5_16","1KI","5","16","16","此外，他還派了三千三百名監工，監督工人做工。 ");
INSERT INTO cmncbt_vpl VALUES ("K15_17","012_5_17","1KI","5","17","17","他們按照王的命令在山上鑿出珍貴的巨石，用來作殿的根基。 ");
INSERT INTO cmncbt_vpl VALUES ("K15_18","012_5_18","1KI","5","18","18","於是，所羅門和希蘭的工匠及迦巴勒人鑿好石頭，備好木料，準備建殿。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","所羅門在做以色列王的第四年二月，即西弗月，開始為耶和華建殿。那時正是以色列人離開埃及後第四百八十年。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_2","012_6_2","1KI","6","2","2","所羅門王為耶和華建造的殿長二十七米，寬九米，高十三米半。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_3","012_6_3","1KI","6","3","3","殿前的門廊和殿一樣寬九米，進深四米半。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_4","012_6_4","1KI","6","4","4","殿有格子窗戶。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_5","012_6_5","1KI","6","5","5","靠殿牆、圍著外殿和內殿又造了三層廂房， ");
INSERT INTO cmncbt_vpl VALUES ("K16_6","012_6_6","1KI","6","6","6","底層寬兩米二，中層寬兩米七，上層寬三米一。廂房的橫梁都搭在殿牆突出的地方，免得插入殿牆。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_7","012_6_7","1KI","6","7","7","建殿的石頭都在採石場鑿好了，建殿的時候聽不到錘子、斧頭或其他鐵器的響聲。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_8","012_6_8","1KI","6","8","8","底層廂房的進口在殿的南面，沿著一道螺旋樓梯可以通到第二層和第三層。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_9","012_6_9","1KI","6","9","9","殿建成後，殿頂裝上香柏木的梁木和木板。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_10","012_6_10","1KI","6","10","10","靠著殿牆所造的廂房每一層高兩米二，用香柏木的梁木與殿牆接連起來。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","耶和華對所羅門說： ");
INSERT INTO cmncbt_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","「關於你所建的這殿，若你遵行我的律例，順從我的典章，謹守我的一切誡命，我必實現我對你父親大衛的應許。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","我必住在以色列人當中，不拋棄我的以色列子民。」 ");
INSERT INTO cmncbt_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","所羅門建造的殿落成了。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_15","012_6_15","1KI","6","15","15","殿裡的牆壁和天花板都鋪上了香柏木，地面都鋪上了松木板。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_16","012_6_16","1KI","6","16","16","在殿的後部，從地面至天花板用香柏木板隔出長九米的內殿，就是至聖所。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_17","012_6_17","1KI","6","17","17","在至聖所外面是外殿，長十八米。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_18","012_6_18","1KI","6","18","18","殿內全部鋪上香柏木，不露一點石頭，香柏木上刻著野瓜和花朵的圖案。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_19","012_6_19","1KI","6","19","19","殿的至聖所用來安放耶和華的約櫃。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_20","012_6_20","1KI","6","20","20","至聖所長、寬和高都是九米，裡面全貼上純金，香柏木造的祭壇也包上純金。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_21","012_6_21","1KI","6","21","21","殿內全部貼上純金，至聖所前面有金鏈攔著，至聖所內也都貼上純金。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_22","012_6_22","1KI","6","22","22","殿內都貼上純金，至聖所內的祭壇也都包上純金。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_23","012_6_23","1KI","6","23","23","至聖所裡面放著兩個橄欖木造的基路伯天使，各高四米半， ");
INSERT INTO cmncbt_vpl VALUES ("K16_24","012_6_24","1KI","6","24","24","各有兩個兩米二長的翅膀，雙翅展開，兩翅尖相距四米半。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_25","012_6_25","1KI","6","25","25","兩個基路伯的大小和形狀一模一樣， ");
INSERT INTO cmncbt_vpl VALUES ("K16_26","012_6_26","1KI","6","26","26","高度都是四米半。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_27","012_6_27","1KI","6","27","27","他將兩個基路伯安在至聖所內，兩個基路伯展開翅膀，各有一個翅膀在至聖所的中央相接，另一個翅膀的尖端觸到牆壁。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_28","012_6_28","1KI","6","28","28","這兩個基路伯天使也包上金。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_29","012_6_29","1KI","6","29","29","內殿和外殿的牆壁都刻上基路伯天使、棕樹和花朵的圖案， ");
INSERT INTO cmncbt_vpl VALUES ("K16_30","012_6_30","1KI","6","30","30","地板是鋪金的。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_31","012_6_31","1KI","6","31","31","至聖所的門、門楣和門柱都是橄欖木造的，門柱呈五角形。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_32","012_6_32","1KI","6","32","32","兩扇用橄欖木造的門上都刻著基路伯天使、棕樹和花朵的圖案，並包上金。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_33","012_6_33","1KI","6","33","33","外殿的四角形門柱也是用橄欖木造的， ");
INSERT INTO cmncbt_vpl VALUES ("K16_34","012_6_34","1KI","6","34","34","兩扇門是松木造的，每一扇門都分為可折疊的兩片， ");
INSERT INTO cmncbt_vpl VALUES ("K16_35","012_6_35","1KI","6","35","35","上面刻著基路伯天使、棕樹和花朵的圖案，並均勻地包上金。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_36","012_6_36","1KI","6","36","36","內院的牆是由三層鑿好的石頭和一層香柏木建的。 ");
INSERT INTO cmncbt_vpl VALUES ("K16_37","012_6_37","1KI","6","37","37","耶和華的殿在所羅門執政第四年的西弗月奠基， ");
INSERT INTO cmncbt_vpl VALUES ("K16_38","012_6_38","1KI","6","38","38","在他執政的第十一年的布勒月，即八月全部按規格建成，歷經七年。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_1","012_7_1","1KI","7","1","1","所羅門用了十三年的時間為自己興建王宮。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_2","012_7_2","1KI","7","2","2","他建造的黎巴嫩林宮長四十五米，寬二十二米半，高十三米半，有四行香柏木柱，柱子支撐著香柏木橫梁。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_3","012_7_3","1KI","7","3","3","每一行木柱有十五根，共四十五根。殿頂鋪香柏木板。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_4","012_7_4","1KI","7","4","4","宮殿有三排窗戶，窗與窗相對； ");
INSERT INTO cmncbt_vpl VALUES ("K17_5","012_7_5","1KI","7","5","5","宮殿的門框和窗戶都是方形的，三排窗戶彼此相對。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_6","012_7_6","1KI","7","6","6","他又建了一座有柱子的廊子，長二十二米半，寬十三米半，前面還有帶柱子的門廊和篷子。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_7","012_7_7","1KI","7","7","7","此外，他又建造了一個判案的公堂。堂內從地板到天花板都鋪上了香柏木。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_8","012_7_8","1KI","7","8","8","所羅門的寢宮就在公堂後面的院內，建築樣式和公堂相同。所羅門又為所娶的法老之女造了一座與公堂相同的宮室。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_9","012_7_9","1KI","7","9","9","這些宮殿，從根基到牆頂，從外院到內殿用的都是上等的石頭，按規格裡外用鋸切割整齊。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_10","012_7_10","1KI","7","10","10","根基用的是非常珍貴的石頭，它們的體積巨大，有些甚至是長達三米半至四米半的巨石， ");
INSERT INTO cmncbt_vpl VALUES ("K17_11","012_7_11","1KI","7","11","11","上面是按照規格鑿好的上等石頭以及香柏木。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_12","012_7_12","1KI","7","12","12","大院周圍的牆由三層鑿好的石頭和一層香柏木建成，正如耶和華殿的內院和殿廊的牆。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_13","012_7_13","1KI","7","13","13","所羅門王派人從泰爾把戶蘭召來。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_14","012_7_14","1KI","7","14","14","戶蘭是拿弗他利支派一個寡婦的兒子，父親是泰爾的銅匠。戶蘭聰明伶俐，技術高超，擅長製造各種銅器。他前來朝見所羅門王，領命負責一切銅器工程。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_15","012_7_15","1KI","7","15","15","他鑄造了兩根銅柱，每根高八米，周長五米四， ");
INSERT INTO cmncbt_vpl VALUES ("K17_16","012_7_16","1KI","7","16","16","然後用銅鑄造了兩個高兩米二的柱冠，安在柱頂上。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_17","012_7_17","1KI","7","17","17","每一個柱冠上裝飾著七條鏈子織成的網， ");
INSERT INTO cmncbt_vpl VALUES ("K17_18","012_7_18","1KI","7","18","18","網周圍環繞著兩行石榴，用來遮蓋柱冠。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_19","012_7_19","1KI","7","19","19","門廊的柱冠高一米八，形狀像百合花。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_20","012_7_20","1KI","7","20","20","在每個柱冠靠近網子鼓起來的地方圍著兩行石榴，共二百個。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_21","012_7_21","1KI","7","21","21","他把兩根柱子立在殿廊前，南邊那根稱為雅斤，北邊那根稱為波阿斯。 ");
INSERT INTO cmncbt_vpl VALUES ("K17_22","012_7_22","1KI"