﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmncbs_vpl;
CREATE TABLE cmncbs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmncbs_vpl WRITE;
INSERT INTO cmncbs_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","太初，上帝创造了天地。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","那时，大地空虚混沌，黑暗笼罩着深渊，上帝的灵运行在水面上。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","上帝说：“要有光！”就有了光。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","上帝看光是好的，就把光和黑暗分开。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","上帝称光为昼，称黑暗为夜。晚上过去，早晨到来，这是第一日。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","上帝说：“水与水之间要有穹苍，把水分开。” ");
INSERT INTO cmncbs_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","果然如此。上帝造了穹苍，将穹苍之下的水和穹苍之上的水分开。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","上帝称穹苍为天空。晚上过去，早晨到来，这是第二日。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","上帝说：“天空下面的水要聚在一处，使干地露出来。”果然如此。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","上帝称干地为陆地，称汇聚的水为海洋。上帝看了，觉得美好。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","上帝说：“陆地要长出植物——各类结种子的菜蔬和结果子的树木，果子内都有籽。”果然如此， ");
INSERT INTO cmncbs_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","陆地长出了植物——各类结种子的菜蔬和结果子的树木，果子内都有籽。上帝看了，觉得美好。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","晚上过去，早晨到来，这是第三日。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","上帝说：“天空要有光体，以区分昼夜，作记号，定节令，计算年日， ");
INSERT INTO cmncbs_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","在天空发光，普照大地。”果然如此。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","上帝造了两个大光体，大的管昼，小的管夜，又造了星辰。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","上帝把这些光体摆列在天空，让它们发光普照大地， ");
INSERT INTO cmncbs_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","管理昼夜，分开光和黑暗。上帝看了，觉得美好。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","晚上过去，早晨到来，这是第四日。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","上帝说：“水中要充满各种动物，空中要有禽鸟飞翔。” ");
INSERT INTO cmncbs_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","上帝就创造了海中的大鱼等各类水族和各类禽鸟。上帝看了，觉得美好。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","上帝赐福给这一切生物，说：“水族要多多地生养繁衍，充满海洋，禽鸟也要在地上多多地繁衍。” ");
INSERT INTO cmncbs_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","晚上过去，早晨到来，这是第五日。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","上帝说：“大地要繁衍各类动物——各类的牲畜、爬虫和野兽。”果然如此。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","上帝造了地上的各类野兽、牲畜和爬虫。上帝看了，觉得美好。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","上帝说：“我们要照着我们的形象，按着我们的样式造人，让他们管理海里的鱼、空中的鸟和地上的牲畜及一切爬虫。” ");
INSERT INTO cmncbs_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","上帝就照着自己的形象造了人，祂照着自己的形象造了男人和女人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","上帝赐福给他们，对他们说：“你们要生养众多，遍满地面，治理大地，管理海里的鱼、空中的鸟以及地上的各种动物。” ");
INSERT INTO cmncbs_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","上帝说：“看啊，我把地上所有结种子的谷蔬和所有树上有籽的果子都赐给你们作食物。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","我把绿色植物赐给所有地上的走兽、空中的飞鸟及地上的爬虫等有气息的动物作食物。”果然如此。 ");
INSERT INTO cmncbs_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","上帝看了祂所造的一切，觉得非常美好。晚上过去，早晨到来，这是第六日。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","天地万物都造好了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","第七日，上帝完成了祂的创造之工，就在第七日歇了一切的工。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","上帝赐福给第七日，将其定为圣日，因为祂在这一日歇了祂一切的创造之工。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","这是有关创造天地的记载。 耶和华上帝创造天地的时候， ");
INSERT INTO cmncbs_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","地上还没有草木，也没有长出菜蔬，因为耶和华上帝还没有降雨在地上，土地也没有人耕作， ");
INSERT INTO cmncbs_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","但有水从地里涌出，浇灌大地。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","耶和华上帝用地上的尘土造人，把生命的气息吹进他的鼻孔里，他就成了有生命的人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","耶和华上帝在东方的伊甸开辟了一个园子，把祂所造的人安置在里面。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","耶和华上帝使地里长出各种树木，它们既好看又有好吃的果子。在园子的中间有生命树和分别善恶的树。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","有一条河从伊甸流出来灌溉那园子，又从那里分成四条河流。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","第一条支流叫比逊河，它环绕着哈腓拉全境，那里有金子， ");
INSERT INTO cmncbs_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","且是上好的金子，还有珍珠和红玛瑙。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","第二条支流叫基训河，它环绕着古实全境。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","第三条支流叫底格里斯河，它流经亚述的东边。第四条支流叫幼发拉底河。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","耶和华上帝把那人安置在伊甸的园子里，让他在那里耕种、看管园子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","耶和华上帝吩咐那人说：“你可以随意吃园中各种树上的果子， ");
INSERT INTO cmncbs_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","只是不可吃那棵分别善恶树的果子，因为你吃的日子必定死。” ");
INSERT INTO cmncbs_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","耶和华上帝说：“那人独自一人不好，我要为他造一个相配的帮手。” ");
INSERT INTO cmncbs_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","耶和华上帝用尘土造了各种田野的走兽和空中的飞鸟，把它们带到那人跟前，看他怎么叫它们。他叫这些动物什么，它们的名字就是什么。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","那人给所有的牲畜及空中的飞鸟和田野的走兽都起了名字。可是他找不到一个跟自己相配的帮手。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","耶和华上帝使那人沉睡，然后在他沉睡的时候从他身上取出一根肋骨，再把肉合起来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","耶和华上帝用那根肋骨造了一个女人，把她带到那人跟前。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","那人说： “这才是我骨中的骨， 肉中的肉， 要称她为女人， 因为她是从男人身上取出来的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","因此，人要离开父母，与妻子结合，二人成为一体。 ");
INSERT INTO cmncbs_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","当时，他们夫妇二人都赤身露体，并不觉得羞耻。 ");
INSERT INTO cmncbs_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","在耶和华上帝所造的田野的各种动物中，蛇最狡猾。蛇对女人说：“上帝真的说过‘你们不可吃园中任何树上的果子’吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","女人回答说：“我们可以吃园中树上的果子， ");
INSERT INTO cmncbs_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","只是上帝说过，‘你们不可吃园子中间那棵树的果子，也不可摸，免得死亡。’” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","蛇对女人说：“你们一定不会死！ ");
INSERT INTO cmncbs_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","上帝那样说是因为祂知道你们吃了那树的果子以后，眼睛就会打开，像上帝一样懂得分辨善恶。” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","女人见那棵树上的果子可口，悦人眼目，可使人有智慧，就摘下来吃了。她又把果子给跟她在一起的丈夫，他也吃了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","二人的眼睛就打开了，发觉自己原来赤身露体，便编起无花果树的叶子来遮体。 ");
INSERT INTO cmncbs_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","天起凉风时，那人和他妻子听见耶和华上帝在园中行走的声音，就藏在园子的树丛中，想躲避耶和华上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","耶和华上帝呼唤那人说：“你在哪里？” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","那人说：“我在园中听见你的声音，就害怕得躲了起来，因为我赤身露体！” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","耶和华上帝问：“谁告诉你，说你赤身露体？难道你吃了我吩咐你不可吃的果子吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","那人说：“你赐给我作伴的女人把那树上的果子给我，我就吃了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","耶和华上帝对女人说：“你这是做的什么事？”女人说：“是蛇诱骗我，我才吃的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","耶和华上帝对蛇说： “你既然做了这事， 你要比一切牲畜和野兽受更重的咒诅， 你要用肚子爬行， 一生都要吃尘土。 ");
INSERT INTO cmncbs_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","我要使你和女人结仇， 你的后裔和女人的后裔也要彼此为仇， 女人的后裔必伤你的头， 你必伤他的脚跟。” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","耶和华上帝对女人说： “我必大大加重你怀孕的痛苦， 你分娩时必受痛苦。 你必恋慕自己的丈夫， 你的丈夫必管辖你。” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","耶和华上帝又对亚当说： “因为你听从妻子的话， 吃了我吩咐你不可吃的那树上的果子， 地必因你而受咒诅。 你必终生艰辛劳苦， 才能吃到地里出产的食物。 ");
INSERT INTO cmncbs_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","地必给你长出荆棘和蒺藜， 你要吃田间长出来的菜蔬。 ");
INSERT INTO cmncbs_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","你必汗流满面，才有饭吃， 一直到你归回土地。 因为那是你的本源。 你本是尘土，也必归回尘土。” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","亚当给他的妻子取名叫夏娃，因为她是众生之母。 ");
INSERT INTO cmncbs_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","耶和华上帝做了皮衣给他们夫妇穿上。 ");
INSERT INTO cmncbs_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","耶和华上帝说：“看啊，那人已经与我们相似，能分辨善恶。现在，恐怕他会伸手去摘生命树的果子吃，就永远活着。” ");
INSERT INTO cmncbs_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","因此，耶和华上帝就把亚当赶出伊甸园，让他去开垦土地——那是他的本源。 ");
INSERT INTO cmncbs_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","祂赶走了亚当以后，在伊甸园东边安排基路伯天使和一把旋转的火剑，守住通往生命树的路。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","亚当和他妻子夏娃同房，夏娃便怀孕，生了该隐。她说：“耶和华让我得了一个男孩。” ");
INSERT INTO cmncbs_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","后来，夏娃又生了该隐的弟弟亚伯。亚伯做了牧羊人，该隐做了农夫。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","过了些日子，该隐把地里的出产当祭物献给耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","亚伯也把羊群中头生的羊及其最肥美的部分献给耶和华。耶和华悦纳亚伯和他的祭物， ");
INSERT INTO cmncbs_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","却不悦纳该隐和他的祭物。该隐便非常恼火，面色阴沉。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","耶和华问该隐：“你为什么恼火？为什么面色阴沉？ ");
INSERT INTO cmncbs_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","如果你做得对，难道不会蒙悦纳吗？如果你做得不对，罪就蹲伏在你的门口，要控制你，但你必须制服罪。” ");
INSERT INTO cmncbs_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","该隐对弟弟亚伯说：“我们去田间吧！”他们在田间的时候，该隐动手打亚伯，把他杀了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","后来，耶和华问该隐：“你弟弟亚伯在哪里？”他说：“我不知道！难道我是我弟弟的看护人吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","耶和华说：“你做了什么事？你弟弟的血从地里向我哭诉。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","地张开口从你手上接受了你弟弟的血，现在你在地上必受咒诅。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","你种地，地却不会再为你效力，你必在地上四处漂泊。” ");
INSERT INTO cmncbs_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","该隐对耶和华说：“这惩罚太重！我承受不了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","今天你把我从此地赶出去，使我不能再见你的面。我在地上四处漂泊，见到我的人都会杀我。” ");
INSERT INTO cmncbs_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","耶和华对他说：“不会的，因为凡杀你的，必遭受七倍的报应。”于是，耶和华在该隐身上留下一个记号，免得见到他的人杀他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","该隐离开耶和华，来到伊甸东边的挪得住下来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","该隐和妻子同房，他的妻子就怀孕，生了以诺。该隐建了一座城，用他儿子的名字给这城取名叫以诺。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","以诺生以拿，以拿生米户雅利，米户雅利生玛土撒利，玛土撒利生拉麦。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","拉麦娶了两个妻子，一个叫亚大，另一个叫洗拉。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","亚大生了雅八，雅八是游牧民族的祖先， ");
INSERT INTO cmncbs_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","雅八的弟弟叫犹八，他是弹琴吹笛之人的鼻祖。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","洗拉生了土八·该隐，他是打造各种铜铁器具的匠人，他的妹妹叫拿玛。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","拉麦对他的两个妻子说： “亚大，洗拉，你们听我的声音； 拉麦的妻子啊，侧耳听我的话， 有人伤我，我杀了他， 青年打我，我宰了他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","杀该隐的遭受七倍的报应， 杀拉麦的遭受七十七倍的报应。” ");
INSERT INTO cmncbs_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","亚当又与妻子夏娃同房，夏娃生了一个儿子，取名叫塞特，因为她说：“上帝赐我另一个儿子来代替亚伯，因为该隐杀了他。” ");
INSERT INTO cmncbs_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","塞特生了一个儿子，给他取名叫以挪士。那时候，人开始求告耶和华的名。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","以下是关于亚当后代的记载。 上帝造人的时候，是照祂自己的样式造的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","祂造了男人和女人，又赐福给他们，并在造他们的那日称他们为“人”。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","亚当一百三十岁时生了一子，样式和形象与自己相似，就给他取名叫塞特。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","亚当生了塞特以后，又活了八百年，生儿育女， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","共活了九百三十岁才去世。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","塞特一百零五岁时生以挪士， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","之后又活了八百零七年，生儿育女， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","共活了九百一十二岁才去世。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","以挪士九十岁时生该南， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","之后又活了八百一十五年，生儿育女， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","共活了九百零五岁才去世。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","该南七十岁时生玛勒列， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","之后又活了八百四十年，生儿育女， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","共活了九百一十岁才去世。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","玛勒列六十五岁时生雅列， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","之后又活了八百三十年，生儿育女， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","共活了八百九十五岁才去世。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","雅列一百六十二岁时生以诺， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","之后又活了八百年，生儿育女， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","共活了九百六十二岁才去世。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","以诺六十五岁时生玛土撒拉， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","之后与上帝亲密同行三百年，生儿育女， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","共活了三百六十五岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","以诺与上帝亲密同行，后来被上帝接去，不在世上了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","玛土撒拉一百八十七岁时生拉麦， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","之后又活了七百八十二年，生儿育女， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","共活了九百六十九岁才去世。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","拉麦一百八十二岁时生了一个儿子， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","取名叫挪亚，他说：“耶和华咒诅了大地，这孩子必使我们从艰辛劳苦中得安慰。” ");
INSERT INTO cmncbs_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","拉麦生挪亚之后，又活了五百九十五年，生儿育女， ");
INSERT INTO cmncbs_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","共活了七百七十七岁才去世。 ");
INSERT INTO cmncbs_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","挪亚五百岁后生闪、含和雅弗。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","当时，人类在地上开始逐渐增多，生了女儿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","上帝的儿子们看见人的女儿漂亮，就随意选来做妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","耶和华说：“人既然是血肉之躯，我的灵不会永远住在人的里面，然而人还可以活一百二十年。” ");
INSERT INTO cmncbs_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","从上帝的儿子和人的女儿交合生子起，地上出现了巨人，他们是上古英武有名的人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","耶和华看见人在地上罪恶深重，心里终日思想的都是恶事， ");
INSERT INTO cmncbs_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","就后悔在地上造了人，心里伤痛， ");
INSERT INTO cmncbs_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","说：“我要把所造的人，连同一切飞禽走兽和爬虫从地上都毁灭，因为我后悔造了他们。” ");
INSERT INTO cmncbs_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","只有挪亚在耶和华面前蒙恩。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","以下是有关挪亚的记载。 挪亚是个义人，在当时的世代是个纯全无过的人，他与上帝同行。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","挪亚生了三个儿子：闪、含和雅弗。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","那时大地在上帝眼中败坏了，充满了暴行。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","上帝看见大地败坏了，因为世人都行为败坏。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","祂对挪亚说：“我决定消灭世人，因为他们使大地充满暴行。我要把他们和大地一起毁灭。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","你要为自己用歌斐木建造一艘方舟，里面要有舱房，内外都要涂上柏油。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","你建造的方舟要长一百三十五米，宽二十二米半，高十三米半。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","舟顶要有四十五厘米高的透光口，门开在方舟的侧面，整艘方舟要分为上、中、下三层。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","看啊，我要使洪水在地上泛滥，毁灭天下一切有生命气息的活物，地上的一切都要灭亡。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","但我要和你立约，你与妻子、儿子和儿媳都可以进方舟。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","每样动物你要带两只进方舟，雌雄各一只，好保存它们的生命。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","各类飞禽走兽和爬虫每样一对都要到你那里，好保全生命。 ");
INSERT INTO cmncbs_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","你要为自己和这些动物预备各种食物，贮存起来。” ");
INSERT INTO cmncbs_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","挪亚就照着上帝的吩咐把事情都办好了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","耶和华对挪亚说：“你和你全家都进入方舟，因为这个世代只有你在我眼中是义人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","洁净的动物，你要每样带七公七母，不洁净的动物每样带一公一母， ");
INSERT INTO cmncbs_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","飞鸟每样带七公七母，叫它们以后可以在地上繁衍后代。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","因为七天之后，我要在地上降雨四十昼夜，从地上毁灭我所造的一切活物。” ");
INSERT INTO cmncbs_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","凡耶和华所吩咐的，挪亚都照办了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","洪水在大地上泛滥那年，挪亚六百岁了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","挪亚与妻子、儿子们和儿媳们都进了方舟，躲避洪水。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","洁净的动物、不洁净的动物、飞禽和地上的一切爬虫， ");
INSERT INTO cmncbs_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","都一公一母成对地到挪亚那里，进了方舟，正如上帝对挪亚的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","七天过后，洪水在地上泛滥起来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","挪亚六百岁那年的二月十七日，所有深渊的泉源都裂开了，天上的水闸也打开了， ");
INSERT INTO cmncbs_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","地上大雨降了四十昼夜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","就在那天，挪亚与他的儿子闪、含和雅弗，还有挪亚的妻子和三个儿媳妇都进了方舟。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","所有的野兽、牲畜、地上的爬虫和飞鸟都按种类进入方舟。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","一切有生命气息的活物都成对地到挪亚那里，进入方舟。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","所有进入方舟的动物都是一公一母，正如上帝对挪亚的吩咐。然后，耶和华关上了方舟的门。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","洪水在地上泛滥了四十天，水不断往上涨，把方舟漂了起来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","洪水来势汹汹，淹没大地，方舟漂浮在水面上。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","水势越来越大，把天下各处的高山都淹没了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","水淹没了群山，高出群山七米。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","地上所有的飞禽、走兽、牲畜、爬虫等动物和人类都死了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","陆地上所有鼻孔有生命气息的活物都死了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","地上的人类、飞禽走兽和爬虫等一切活物都被毁灭了，只剩下挪亚和跟他同在方舟里的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","洪水淹没大地一百五十天。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","上帝眷顾挪亚及方舟里的野兽和牲畜，就使风吹在大地上，水便开始消退。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","深渊的泉源和天上的水闸都关闭了，大雨也停了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","地上的洪水慢慢消退，过了一百五十天，水退下去了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","七月十七日，方舟停在亚拉腊山上。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","水继续消退一直到十月，到十月一日，山顶都露出来了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","又过了四十天，挪亚打开他在方舟上所造的窗户， ");
INSERT INTO cmncbs_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","放出一只乌鸦。它一直在空中飞来飞去，直到地上的水都干了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","然后，挪亚放出一只鸽子，以便了解地面的水是否已经消退。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","但遍地都是水，鸽子找不到歇脚的地方，就飞回了方舟，挪亚伸手把鸽子接进方舟里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","挪亚又等了七天，再把鸽子放出去。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","到了黄昏，鸽子飞回来，嘴里衔着一片新拧下来的橄榄叶，挪亚便知道地上的水已经退了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","他又等了七天，再放出鸽子，这次鸽子没有回来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","挪亚六百零一岁那年的一月一日，地上的水干了。挪亚打开方舟的盖观望，看见地面都干了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","到了二月二十七日，大地完全干了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","上帝对挪亚说： ");
INSERT INTO cmncbs_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“你与妻子、儿子和儿媳都要出方舟。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","你要把方舟里的飞禽走兽及爬虫等所有动物都带出来，让它们在地上多多滋长，生养繁衍。” ");
INSERT INTO cmncbs_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","于是，挪亚与妻子、儿子和儿媳都出了方舟。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","方舟里的飞禽走兽和爬虫等所有地上的动物，都按种类出了方舟。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","挪亚为耶和华筑了一座坛，在上面焚烧各种洁净的牲畜和飞鸟作为燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","耶和华闻到这燔祭的馨香，心想：“虽然人从小就心存恶念，但我再不会因为人的缘故而咒诅大地，再不会像这次一样毁灭一切活物了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","只要大地尚存，播种收割、夏热冬寒、白昼黑夜必不停息。” ");
INSERT INTO cmncbs_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","上帝赐福给挪亚和他的儿子们，对他们说：“你们要生养众多，遍布地面。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","所有地上的走兽和爬虫、空中的飞鸟及海里的鱼都必惧怕你们，它们都归你们管理。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","凡是活的动物都可作你们的食物，就像绿色菜蔬一样，我把一切都赐给你们了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","只是你们不可吃带血的肉，因为血就是生命。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","凡是杀害你们的，无论人或兽，我必向他们追讨血债。凡杀人的，我必追讨他的血债。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","凡杀害人的，也必被人杀害，因为人是上帝照着自己的形象造的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","你们要生养众多，使地上人口兴旺。” ");
INSERT INTO cmncbs_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","上帝又对挪亚和他身边的儿子们说： ");
INSERT INTO cmncbs_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“我要跟你们和你们的后代立约， ");
INSERT INTO cmncbs_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","包括所有和你们在一起的生物，就是那些和你们一起从方舟出来的飞禽走兽和牲畜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","我与你们立约，不再让洪水灭绝一切生命，也不再让洪水毁灭大地。” ");
INSERT INTO cmncbs_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","上帝说：“我与你们及所有和你们在一起的生物立世代永存的约，这是我立约的记号。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","我把彩虹放在云中，作为我跟大地立约的记号。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","我使云彩覆盖大地的时候，会有彩虹在云中出现。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","这样我会顾念我与你们及一切有血气的生物所立的约，水就不会再泛滥、毁灭所有生命。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","当我看见彩虹在云中出现的时候，就会顾念我与地上一切活物立的永远之约。” ");
INSERT INTO cmncbs_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","上帝对挪亚说：“这是我与地上一切生命立约的记号。” ");
INSERT INTO cmncbs_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","与挪亚一起出方舟的有他的儿子闪、含、雅弗。含是迦南的父亲。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","这是挪亚的三个儿子，他们的后代遍布天下。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","挪亚做了农夫，他是第一个栽种葡萄园的人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","一天，他喝葡萄酒喝醉了，赤裸着身体躺在帐篷里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","迦南的父亲含看见父亲赤身露体，便去告诉外面的两个弟兄。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","于是，闪和雅弗拿了一件衣服搭在肩上，倒退着走进帐篷，把衣服盖在父亲身上，他们背着脸不看父亲赤裸的身体。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","挪亚酒醒后，知道了小儿子做的事， ");
INSERT INTO cmncbs_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","就说： “迦南该受咒诅， 必做他弟兄的仆人的仆人。” ");
INSERT INTO cmncbs_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","又说： “闪的上帝耶和华当受称颂！ 愿迦南做闪的仆人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","愿上帝扩张雅弗的疆界， 愿他住在闪的帐篷里， 愿迦南做他的仆人。” ");
INSERT INTO cmncbs_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","洪水以后，挪亚又活了三百五十年， ");
INSERT INTO cmncbs_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","共活了九百五十岁才去世。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","洪水以后，挪亚的儿子闪、含和雅弗都生了儿子，以下是他们的后代。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","雅弗的儿子是歌篾、玛各、玛代、雅完、土巴、米设、提拉。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","歌篾的儿子是亚实基拿、利法、陀迦玛。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","雅完的儿子是以利沙、他施、基提、多单。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","雅弗的这些后代各按宗族、语言和民族分散在沿海自己的国土上。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","含的儿子是古实、麦西、弗、迦南。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","古实的儿子是西巴、哈腓拉、撒弗他、拉玛、撒弗提迦。拉玛的儿子是示巴和底但。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","古实也是宁录之父，宁录是世上第一位勇士， ");
INSERT INTO cmncbs_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","在耶和华眼中是个孔武有力的猎人，因此有俗话说：“要像宁录那样在耶和华眼中是个孔武有力的猎人。” ");
INSERT INTO cmncbs_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","他首先在示拿地区的巴别、以力、亚甲、甲尼各地建国， ");
INSERT INTO cmncbs_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","后来扩展到亚述，在那里建立了尼尼微、利河伯、迦拉， ");
INSERT INTO cmncbs_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","以及尼尼微与迦拉之间的利鲜大城。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","麦西的后代有路低人、亚拿米人、利哈比人、拿弗土希人、 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","帕斯鲁细人、迦斯路希人和迦斐托人。非利士人是迦斐托人的后代。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","迦南生长子西顿和次子赫， ");
INSERT INTO cmncbs_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","他的后代还有耶布斯人、亚摩利人、革迦撒人、 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","希未人、亚基人、西尼人、 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","亚瓦底人、洗玛利人和哈马人。后来迦南各宗族散居在各地。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","迦南的疆域从西顿向基拉耳延伸，远至迦萨，再向所多玛、蛾摩拉、押玛、洗扁延伸，远至拉沙。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","以上记载的都是含的子孙，他们根据自己的宗族、语言、国土和民族散居各处。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","雅弗的哥哥闪是希伯子孙的祖先，他也生了儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","闪的儿子是以拦、亚述、亚法撒、路德、亚兰。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","亚兰的儿子是乌斯、户勒、基帖、玛施。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","亚法撒生沙拉，沙拉生希伯， ");
INSERT INTO cmncbs_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","希伯有两个儿子，一个名叫法勒，因为那时人们分地而居。法勒的兄弟叫约坍。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","约坍生亚摩答、沙列、哈萨玛非、耶拉、 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","哈多兰、乌萨、德拉、 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","俄巴路、亚比玛利、示巴、 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","阿斐、哈腓拉、约巴。这些都是约坍的儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","他们居住的地方，从米沙直到东边的西发山区。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","以上记载的都是闪的子孙，他们按着自己的宗族、语言、国土和民族散居各处。 ");
INSERT INTO cmncbs_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","这些人都是洪水以后挪亚三个儿子所生的子孙，他们按着自己的民族和家系散居在各地，繁衍出地上各个民族。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","那时，天下人都用同一种语言，讲同一种话。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","人们向东迁移时，在示拿地区找到一处平原，定居下来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","他们彼此商量说：“来呀，我们制作砖，把砖烧透吧。”他们用砖作石块，用柏油作灰泥来造塔， ");
INSERT INTO cmncbs_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","说：“来吧，让我们造一座城和一座高耸入云的塔，这样我们可以为自己扬名，不致分散在普天之下。” ");
INSERT INTO cmncbs_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","耶和华下来察看人建造的城和塔。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","耶和华说：“看啊，他们同属一个民族，都用同一种语言，现在就开始做这样的事，如果继续下去，他们会为所欲为。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","来吧，我们下去变乱他们的语言，使他们彼此言语不通。” ");
INSERT INTO cmncbs_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","于是，耶和华把他们从那里分散到普天之下，他们便停止建城了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","因此，人称那城为巴别，因为耶和华在那里变乱了世人的语言，把他们分散到普天之下。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","以下是闪的后代。 洪水过后两年，闪一百岁时生亚法撒， ");
INSERT INTO cmncbs_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","之后又活了五百年，生儿育女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","亚法撒三十五岁时生沙拉， ");
INSERT INTO cmncbs_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","之后又活了四百零三年，生儿育女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","沙拉三十岁时生希伯， ");
INSERT INTO cmncbs_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","之后又活了四百零三年，生儿育女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","希伯三十四岁时生法勒， ");
INSERT INTO cmncbs_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","之后又活了四百三十年，生儿育女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","法勒三十岁时生拉吴， ");
INSERT INTO cmncbs_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","之后又活了二百零九年，生儿育女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","拉吴三十二岁时生西鹿， ");
INSERT INTO cmncbs_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","之后又活了二百零七年，生儿育女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","西鹿三十岁时生拿鹤， ");
INSERT INTO cmncbs_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","之后又活了二百年，生儿育女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","拿鹤二十九岁时生他拉， ");
INSERT INTO cmncbs_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","之后又活了一百一十九年，生儿育女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","他拉七十岁后，生了亚伯兰、拿鹤和哈兰。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","以下是他拉的后代。 他拉生亚伯兰、拿鹤和哈兰，哈兰生罗得。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","哈兰比他父亲他拉先去世，他死在自己的家乡迦勒底的吾珥。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","亚伯兰和拿鹤都娶了妻子，亚伯兰的妻子名叫撒莱，拿鹤的妻子名叫密迦，是哈兰的女儿。哈兰是密迦和亦迦的父亲。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","撒莱不能生育，没有孩子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","他拉带着儿子亚伯兰、孙子——哈兰的儿子罗得、儿媳妇——亚伯兰的妻子撒莱，离开迦勒底的吾珥前往迦南，他们来到哈兰，在那里定居下来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","他拉在那里去世，享年二百零五岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","耶和华对亚伯兰说：“你要离开家乡、亲族和父亲的家，到我要指示你的地方去。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","我必使你成为大国，我必赐福给你，使你声名远扬。你必成为别人的祝福。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","我必赐福给那些祝福你的人，咒诅那些咒诅你的人。世上万族必因你而蒙福。” ");
INSERT INTO cmncbs_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","亚伯兰就照耶和华的吩咐离开哈兰，侄儿罗得与他同行。那时亚伯兰七十五岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","亚伯兰带着妻子撒莱、侄儿罗得以及在哈兰积攒的财物和所得的奴仆，启程来到迦南。到了迦南以后， ");
INSERT INTO cmncbs_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","亚伯兰继续前行，来到示剑的摩利橡树那里。当时迦南人住在那地方。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","耶和华向亚伯兰显现，对他说：“我要把这片土地赐给你的后裔。”亚伯兰就在那里为向他显现的耶和华筑了一座坛。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","然后，他们又启程前往伯特利东面的山区，在那里搭起帐篷。他们的西面是伯特利，东面是艾。亚伯兰又在那里筑了一座坛，求告耶和华的名。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","之后，亚伯兰继续前往南地。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","那地方遭遇饥荒，灾情非常严重，亚伯兰便下到埃及暂住。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","快要到埃及的时候，他对妻子撒莱说：“我知道你是个美貌的女子， ");
INSERT INTO cmncbs_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","埃及人看见你，一定会因为你是我的妻子而杀了我，让你活着。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","所以，请你说你是我的妹妹，这样他们会因为你而善待我，留我一命。” ");
INSERT INTO cmncbs_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","亚伯兰一行到了埃及，撒莱的美貌引起了埃及人的注意。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","法老的官员见了撒莱，就在法老面前称赞她的美貌，她便被带进法老的王宫。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","因为撒莱的缘故，法老厚待亚伯兰，赏给他许多牛、羊、驴、骆驼和仆婢。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","耶和华因亚伯兰妻子撒莱的缘故，使法老和他全家患重病。 ");
INSERT INTO cmncbs_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","法老便召见亚伯兰，说：“你对我做的是什么事？为什么不告诉我她是你妻子？ ");
INSERT INTO cmncbs_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","为什么说她是你妹妹，以致我要娶她为妻呢？现在你妻子在这里，带她走吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","法老就吩咐人把亚伯兰、他妻子以及他所有的一切都送走了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","亚伯兰带着妻子、侄儿罗得和所有的一切，离开埃及去南地。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","那时亚伯兰已经拥有很多牲畜和金银。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","他从南地渐渐迁移到伯特利，到了他从前在伯特利和艾中间搭帐篷和筑坛的地方。他又在那里求告耶和华的名。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","和亚伯兰同行的罗得也有牛群、羊群和帐篷。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","他们的牲畜很多，那地方容纳不下，他们无法住在一起。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","亚伯兰的牧人和罗得的牧人之间起了纷争。那时，迦南人和比利洗人也住在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","亚伯兰对罗得说：“我们之间不该有纷争，我们的牧人之间也不该有纷争，因为我们是骨肉至亲。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","整片土地不就在你面前吗？我们分开吧。如果你往左边去，我就往右边走；如果你往右边去，我就往左边走。” ");
INSERT INTO cmncbs_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","罗得举目眺望，看见整个约旦河平原，远至琐珥，水源充足。在耶和华毁灭所多玛和蛾摩拉之前，那地方就好像耶和华的园子，又像埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","于是，罗得选了整个约旦河平原，向东迁移，他们便分开了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","亚伯兰住在迦南，罗得则住在平原的城邑里，并渐渐把帐篷迁移到所多玛附近。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","所多玛人极其邪恶，在耶和华眼中罪恶滔天。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","罗得离开后，耶和华对亚伯兰说：“从你站的地方向东西南北眺望， ");
INSERT INTO cmncbs_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","你所能看见的地方，我都要赐给你和你的后裔，直到永远。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","我要使你的后裔多如地上的尘土，人若能数算地上的尘土，才能数算你的后裔。 ");
INSERT INTO cmncbs_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","你起来走遍这片土地，因为我要把这片土地赐给你。” ");
INSERT INTO cmncbs_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","亚伯兰就把帐篷迁移到希伯仑，在幔利的橡树附近居住，在那里为耶和华筑了一座祭坛。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","那时，示拿王暗拉非、以拉撒王亚略、以拦王基大老玛和戈印王提达联合攻打以下五王：所多玛王比拉、蛾摩拉王比沙、押玛王示纳、洗扁王善以别和比拉王，即琐珥王。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","五王会师西订谷，即盐海。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","他们受基大老玛统治十二年，在第十三年叛变了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","第十四年，基大老玛联合其他王在亚特律·加宁打败利乏音人，在哈麦打败苏西人，在沙微·基列亭打败以米人， ");
INSERT INTO cmncbs_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","在西珥山打败住在那里的何利人，直杀到靠近旷野的伊勒·巴兰。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","然后，他们返回安·密巴，即加低斯，征服了亚玛力全境以及住在哈洗逊·他玛的亚摩利人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","那时，所多玛王、蛾摩拉王、押玛王、洗扁王和比拉王，即琐珥王出战，在西订谷摆开阵势， ");
INSERT INTO cmncbs_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","抵抗以拦王基大老玛、戈印王提达、示拿王暗拉非和以拉撒王亚略：四王跟五王交战。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","西订谷布满柏油坑，所多玛王和蛾摩拉王败走的时候，有些人掉进坑里，其他人都往山上逃命。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","四王把所多玛和蛾摩拉所有的财物和粮食洗劫一空，扬长而去， ");
INSERT INTO cmncbs_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","并劫走亚伯兰的侄儿罗得和他的财物，那时罗得正住在所多玛。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","有一个逃出来的人把这件事情告诉了希伯来人亚伯兰。那时，亚伯兰住在亚摩利人幔利的橡树那里。幔利是以实各和亚乃的兄弟，三人都是亚伯兰的盟友。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","亚伯兰听见侄儿被掳的消息，便率领家中三百一十八名训练有素的壮丁去追赶他们，一直追到但。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","夜里，亚伯兰和他的随从分头出击，大败他们，一直追杀到大马士革北面的何巴， ");
INSERT INTO cmncbs_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","夺回所有被劫的财物，并救出他侄儿罗得及其财物、妇女和其他人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","亚伯兰大败基大老玛及其盟军各王凯旋的时候，所多玛王到沙微谷来迎接。沙微谷即王谷。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","撒冷王麦基洗德也带着饼和酒出来相迎，他是至高上帝的祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","他祝福亚伯兰说： “愿创造天地的主、至高的上帝赐福给亚伯兰！ ");
INSERT INTO cmncbs_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","将敌人交在你手中的至高上帝当受称颂！” 于是，亚伯兰把所得财物的十分之一给了他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","所多玛王对亚伯兰说：“请把我的人民交还给我，你可以把财物拿去。” ");
INSERT INTO cmncbs_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","亚伯兰对他说：“我向创造天地的主、至高的上帝耶和华举手起誓， ");
INSERT INTO cmncbs_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","凡是你的东西，就是一根线、一条鞋带，我都不会拿，免得你说，‘我使亚伯兰发了财！’ ");
INSERT INTO cmncbs_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","除了我的随从已经吃用的以外，我什么也不要。至于我的盟友亚乃、以实各和幔利所当得之份，请让他们拿去。” ");
INSERT INTO cmncbs_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","这些事以后，耶和华在异象中对亚伯兰说：“亚伯兰，你不要害怕，我是你的盾牌，我要大大赏赐你。” ");
INSERT INTO cmncbs_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","亚伯兰说：“主耶和华啊，你要赐我什么呢？我没有儿子，继承我家业的人是大马士革人以利以谢。” ");
INSERT INTO cmncbs_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","亚伯兰又说：“你没有赐我后裔，我家中的仆人将继承我的产业。” ");
INSERT INTO cmncbs_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","耶和华对他说：“这人不会成为你的继承人，你亲生的儿子才是你的继承人。” ");
INSERT INTO cmncbs_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","耶和华把亚伯兰带到外面，对他说：“你抬头看看天空，数数繁星，你能数得尽吗？”接着又对他说：“你的后裔必这么多。” ");
INSERT INTO cmncbs_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","亚伯兰信耶和华，耶和华便算他为义人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","耶和华又对他说：“我是耶和华，我带你离开了迦勒底的吾珥，为要把这片土地赐给你作产业。” ");
INSERT INTO cmncbs_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","亚伯兰说：“主耶和华啊，我怎么知道我会得到这片土地呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","耶和华说：“你要给我预备三岁的母牛、母山羊和公绵羊各一头，斑鸠和雏鸽各一只。” ");
INSERT INTO cmncbs_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","亚伯兰一一照办，把牲畜都劈成两半，一半对着一半地摆列，但没有劈开鸟。 ");
INSERT INTO cmncbs_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","有鸷鸟飞到那些尸体上，亚伯兰赶走了它们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","太阳下山的时候，亚伯兰睡得很沉，忽然有可怕的黑暗笼罩着他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","耶和华对他说：“你要清楚知道，你的后裔必流落异乡，被奴役和虐待四百年。 ");
INSERT INTO cmncbs_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","但我必惩罚那奴役他们的国家，之后他们必带着大量财物离开那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","而你必享长寿，得到安葬，归到列祖那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","到了第四代，你的子孙必重回此地，因为亚摩利人现在还没有恶贯满盈。” ");
INSERT INTO cmncbs_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","太阳下山，夜幕降临，突然有冒烟的火炉和点着的火炬在肉块中经过。 ");
INSERT INTO cmncbs_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","就在那天，耶和华跟亚伯兰立约，说：“我必将这片土地赐给你的后裔，从埃及河一直延伸到幼发拉底大河， ");
INSERT INTO cmncbs_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","就是基尼人、基尼洗人、甲摩尼人、 ");
INSERT INTO cmncbs_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","赫人、比利洗人、利乏音人、 ");
INSERT INTO cmncbs_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","亚摩利人、迦南人、革迦撒人和耶布斯人的土地。” ");
INSERT INTO cmncbs_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","亚伯兰的妻子撒莱没有给他生孩子。撒莱有个婢女名叫夏甲，是埃及人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","撒莱对亚伯兰说：“耶和华不让我生育，请你与我的婢女同房，也许我可以借着她得子立后。”亚伯兰同意了撒莱的话。 ");
INSERT INTO cmncbs_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","于是，撒莱把埃及婢女夏甲给亚伯兰做妾。那时亚伯兰已经在迦南住了十年。 ");
INSERT INTO cmncbs_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","亚伯兰与夏甲同房，她就怀了孕。夏甲知道自己怀了孕，就轻视女主人撒莱。 ");
INSERT INTO cmncbs_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","撒莱对亚伯兰说：“我受气都是因为你。我把婢女放在你怀里，她仗着自己怀了孕就轻视我，愿耶和华在你我之间主持公道。” ");
INSERT INTO cmncbs_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","亚伯兰对撒莱说：“婢女在你手中，随你处置。”于是，撒莱苦待夏甲，夏甲就逃走了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","耶和华的天使在旷野中，通往书珥之路的水泉旁找到了夏甲， ");
INSERT INTO cmncbs_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","便问她：“撒莱的婢女夏甲，你从哪里来？要到哪里去？”她回答说：“我是从女主人撒莱那里逃出来的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","耶和华的天使对她说：“你要回到女主人那里顺服她。” ");
INSERT INTO cmncbs_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","又说：“我必使你的后裔多得不可胜数。” ");
INSERT INTO cmncbs_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","接着又说：“你现在怀了孕，将来会生一个男孩，你要给他取名叫以实玛利，因为耶和华已经听见你痛苦的哀声。 ");
INSERT INTO cmncbs_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","这孩子性情必像野驴，他要跟人作对，人也要跟他作对。他必与他所有的弟兄为敌。” ");
INSERT INTO cmncbs_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","夏甲称对她说话的耶和华为“看顾人的上帝”，她说：“我竟然在这里看见了那位看顾我的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","因此，那口井被称为庇耳·拉海·莱，位于加低斯和巴列之间。 ");
INSERT INTO cmncbs_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","后来夏甲为亚伯兰生了一个儿子，亚伯兰给他取名叫以实玛利。 ");
INSERT INTO cmncbs_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","夏甲生以实玛利时，亚伯兰八十六岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","亚伯兰九十九岁那年，耶和华向他显现说：“我是全能的上帝。你要遵行我的旨意，做纯全无过的人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","我要与你立约，我要使你子孙极其繁盛。” ");
INSERT INTO cmncbs_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","亚伯兰就俯伏在地，上帝又对他说： ");
INSERT INTO cmncbs_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“我要与你立约，你必成为万族之父。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","以后你的名字不再叫亚伯兰，要改为亚伯拉罕，因为我已立你为万族之父。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","我要使你生养众多，民族必由你而生，君王必从你而出。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","我要和你并你的子子孙孙立永远的约，我要做你和你子孙的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","我要把你现在寄居的整个迦南赐给你和你的子孙永远作产业，我也必做他们的上帝。” ");
INSERT INTO cmncbs_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","上帝又对亚伯拉罕说：“你和你的子孙世世代代都要遵守我的约。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","你们所有的男子都要受割礼，这是我与你和你的子孙所立的约，你们要遵守。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","你们都要割包皮，作为我与你们立约的记号。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","你们世世代代的男子在出生后的第八日都要接受割礼，包括在你家里出生的和用钱从外族人那里买来的奴仆。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","不论是在你家里生的，还是你用钱买来的男子，都要接受割礼，这样我的约就在你们的肉体上成为永远的约。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","任何没有接受割礼的男子，要将他从民中铲除，因为他违背了我的约。” ");
INSERT INTO cmncbs_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","上帝对亚伯拉罕说：“你的妻子撒莱以后不要叫撒莱，她的名字要叫撒拉。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","我必赐福给她，让她为你生一个儿子。我必赐福给她，让她成为列国之母，列邦的君王必从她而出。” ");
INSERT INTO cmncbs_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","亚伯拉罕就俯伏在地，笑了起来，心想：“一百岁的人还能有孩子吗？撒拉已经九十岁了，还能生育吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","亚伯拉罕对上帝说：“愿以实玛利蒙你赐福。” ");
INSERT INTO cmncbs_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","上帝说：“不，你妻子撒拉必为你生一个儿子，你要给他取名叫以撒，我必与他坚立我的约，作为他后代永远的约。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","至于以实玛利，我已听见你的祈求，我必赐福给他，使他生养众多、子孙极其繁盛。他必做十二个族长的父亲，我必使他成为大国。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","撒拉必在明年这时候给你生以撒，我必向他坚守我的约。” ");
INSERT INTO cmncbs_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","上帝说完以后，便离开亚伯拉罕上升而去。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","亚伯拉罕就在那天照着上帝的吩咐，为儿子以实玛利和家中所有的男子，不论是在家中出生的，还是买回来的，都行了割礼。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","亚伯拉罕接受割礼的时候九十九岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","他的儿子以实玛利接受割礼的时候十三岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","他们父子二人就在那天接受了割礼。 ");
INSERT INTO cmncbs_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","亚伯拉罕家里所有的男子，包括家中出生的和买回来的，都一起接受了割礼。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","耶和华在幔利的橡树那里向亚伯拉罕显现。那时天气很热，亚伯拉罕坐在帐篷口， ");
INSERT INTO cmncbs_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","抬头看见三个人站在对面，就从帐篷口跑去迎接他们，俯伏在地， ");
INSERT INTO cmncbs_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","说：“我主，若我在你面前蒙恩，请不要从仆人这里走过去。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","我让人拿点水来，你们洗洗脚，在树下歇一会儿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","你们既然路过仆人这里，我拿点饼来，你们补充一下体力再上路吧。”他们说：“好，就照你说的做吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","于是，亚伯拉罕连忙进帐篷对撒拉说：“快准备三斗细面粉，和面烤饼。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","亚伯拉罕又跑到牛群中牵了一头肥嫩的小牛，交给仆人赶快去准备。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","亚伯拉罕把奶、奶酪和准备好的牛肉摆在他们面前，自己在树荫下侍立一旁，伺候他们用餐。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","他们问亚伯拉罕：“你妻子撒拉在哪里？”亚伯拉罕回答说：“在帐篷里。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","其中一人说：“明年这时候，我必回到你这里，撒拉必生一个儿子。”撒拉在那人后面的帐篷口听见了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","亚伯拉罕和撒拉已经年纪老迈，撒拉早已绝经。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","撒拉暗自发笑，心想：“我已经老了，还会有这种福气吗？况且我的丈夫也老了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","耶和华问亚伯拉罕：“撒拉为什么偷笑说，‘我这把年纪还会有孩子吗？’ ");
INSERT INTO cmncbs_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","什么事能难得了耶和华呢？明年这时候，我必回到你这里，撒拉必生一个儿子。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","撒拉听见后非常害怕，连忙否认说：“我没有笑！”但耶和华说：“不，你确实笑了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","那三个人起身朝所多玛眺望，亚伯拉罕与他们同行，要送他们一程。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","耶和华说：“我要做的事怎么可以瞒着亚伯拉罕呢？ ");
INSERT INTO cmncbs_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","亚伯拉罕必成为强盛的大国，天下万国必因他而蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","我拣选了他，是要他教导自己的子孙后代持守我的道、秉公行义。这样，我必实现对他的应许。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","耶和华说：“所多玛和蛾摩拉罪恶深重，人们怨声载道。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","我现在要下去看看他们的恶行是否如我听到的控诉一样，如果不是，我也会知道。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","其中二人转身向所多玛走去，亚伯拉罕却仍旧站在耶和华面前。 ");
INSERT INTO cmncbs_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","亚伯拉罕上前说：“你要把义人和恶人一同毁灭吗？ ");
INSERT INTO cmncbs_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","倘若城中有五十个义人，你还要毁灭那城吗？你会不会为了五十个义人而饶恕那座城呢？ ");
INSERT INTO cmncbs_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","你绝不会黑白不分，把义人和恶人一同毁灭。你绝不会这么做！你是普天下的审判者，难道不秉公行事吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","耶和华回答说：“我若在所多玛城中找到五十个义人，就因他们的缘故饶恕全城。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","亚伯拉罕说：“主啊，我虽然渺小如灰尘，还斗胆问你， ");
INSERT INTO cmncbs_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","倘若只有四十五个义人，你会因为少了五个义人而毁灭全城吗？”耶和华说：“我若在城里找到四十五个义人，也不会毁灭那城。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","亚伯拉罕又说：“倘若在那里找到四十个义人呢？”耶和华说：“为了那四十个人的缘故，我不会毁灭那城。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","亚伯拉罕说：“求主不要发怒，容许我再问一次，倘若在那里只找到三十个义人呢？”耶和华说：“倘若在那里只找到三十个，我也不会毁灭那城。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","亚伯拉罕说：“我大胆再问一次，倘若在那里只找到二十个义人呢？”耶和华说：“为了那二十个人的缘故，我也不会毁灭那城。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","亚伯拉罕又说：“求主不要发怒，让我问最后一次，倘若在那里只找到十个义人呢？”耶和华说：“为了那十个人的缘故，我也不会毁灭那城。” ");
INSERT INTO cmncbs_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","耶和华跟亚伯拉罕说完话便离开了，亚伯拉罕也回家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","那两个天使在黄昏的时候来到所多玛，罗得正坐在城门口，看见他们，便起来迎接，俯伏在地上说： ");
INSERT INTO cmncbs_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“我主啊，请到仆人家洗洗脚，住一夜，早上再继续赶路吧！”他们说：“不，我们要在街上过夜。” ");
INSERT INTO cmncbs_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","罗得执意邀请他们，他们便跟着进了他家。罗得设宴款待他们，烤了无酵饼，他们就吃了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","他们正准备就寝的时候，所多玛城的男人从老到少全都出来，团团围住罗得的房子， ");
INSERT INTO cmncbs_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","对罗得大喊大叫：“今晚到你家中作客的人在哪里？把他们交出来，我们要跟他们交合！” ");
INSERT INTO cmncbs_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","罗得走出来，随手关上门，到众人面前， ");
INSERT INTO cmncbs_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","对他们说：“各位弟兄，请不要做这种邪恶的事！ ");
INSERT INTO cmncbs_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","我有两个女儿，还是处女，我把她们交出来，任凭你们处置，只是请你们不要动这两个人，因为他们到我舍下做客。” ");
INSERT INTO cmncbs_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","他们对罗得说：“走开！”又说：“这个寄居的人竟当起审判官来啦！现在我们要用更狠的手段对付你。”众人便推挤罗得，想要破门而入。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","那两位天使伸手把罗得拉进屋里，关上了门， ");
INSERT INTO cmncbs_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","并让门外的人，不论老少都眼目昏迷，摸来摸去也找不着罗得家的门。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","天使对罗得说：“你这里还有什么人吗？你要带儿女、女婿和城里其他亲人离开这里， ");
INSERT INTO cmncbs_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","因为我们就要毁灭这城了。耶和华已经听见对城中百姓的极大控诉，祂差遣我们来毁灭这城。” ");
INSERT INTO cmncbs_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","罗得听了就去通知他女儿的未婚夫说：“赶快离开这地方！耶和华要毁灭这城了！”可是他们却以为他是在开玩笑。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","天刚亮的时候，天使便催促罗得说：“赶快带着你的妻子和这里的两个女儿离开，免得所多玛城因罪恶受惩罚的时候，你也一起被毁灭。” ");
INSERT INTO cmncbs_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","罗得却犹豫不决，天使便拉着罗得及其妻子和两个女儿的手出去，将他们带出去，安置在城外，因为耶和华怜悯他们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","带他们到了城外之后，其中一位说：“赶快逃命！不要回头看，也不要留在平原，要往山上逃，免得你们被毁灭。” ");
INSERT INTO cmncbs_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","罗得说：“我主啊，请不要这样。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","仆人蒙你厚爱、施恩相救，但我无法逃到山上，要是这灾难追上我，我就没命了！ ");
INSERT INTO cmncbs_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","请看，那座城离这里不远，容易跑到，又是座小城，请让我逃到那座小城活命吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","天使回答说：“好吧，我也答应你，不毁灭你说的那座城。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","你赶快逃去那里吧，因为你到达那里之前，我不能动手。”因此那城便叫琐珥。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","罗得到达琐珥的时候，太阳已经出来了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","耶和华亲自从天上把燃烧的硫磺降在所多玛和蛾摩拉两地， ");
INSERT INTO cmncbs_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","毁灭了这些城和其中的居民，包括整个平原和地上的植物。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","罗得的妻子跟在他后面，她回头一望，就变成了一根盐柱。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","亚伯拉罕清早起来，到他从前站在耶和华面前的地方， ");
INSERT INTO cmncbs_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","向所多玛、蛾摩拉和整个平原眺望，只见那里浓烟滚滚，好像火窑的烟一样。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","这样，上帝顾念亚伯拉罕，在毁灭平原各城的时候，让罗得逃离所住的城市，免遭毁灭。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","罗得不敢住在琐珥，便带着两个女儿来到山上，住在一个洞里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","他的大女儿对小女儿说：“我们的父亲年纪大了，这里又没有男子可以照着世上的习俗娶我们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","来，我们灌醉父亲，然后跟他睡觉，借着他传宗接代吧。” ");
INSERT INTO cmncbs_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","于是，那晚她们灌醉了父亲，大女儿进去和父亲睡。她什么时候躺下，什么时候起来，罗得完全不知道。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","第二天，大女儿对妹妹说：“昨晚我已经和父亲睡了，今晚我们再灌醉他，然后你进去和他睡。这样，我们就可以借着父亲传宗接代。” ");
INSERT INTO cmncbs_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","当晚，她们又灌醉了父亲，小女儿进去与他睡。她什么时候躺下，什么时候起来，罗得完全不知道。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","这样，罗得的两个女儿都从父亲怀了孕。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","大女儿生了一个儿子，给他取名叫摩押，他是今天摩押人的祖先。 ");
INSERT INTO cmncbs_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","小女儿也生了一个儿子，给他取名叫便·亚米，他是今天亚扪人的祖先。 ");
INSERT INTO cmncbs_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","亚伯拉罕从那里迁往南地，住在加低斯和书珥之间。在基拉耳寄居期间， ");
INSERT INTO cmncbs_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","他称妻子撒拉是自己的妹妹。基拉耳王亚比米勒派人带走了撒拉。 ");
INSERT INTO cmncbs_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","晚上，上帝在梦中对亚比米勒说：“你的死期到了，因为你带来的那个女人是有夫之妇。” ");
INSERT INTO cmncbs_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","亚比米勒还没有亲近撒拉，因此他说：“主啊，难道你要毁灭无辜的人民吗？ ");
INSERT INTO cmncbs_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","岂不是那人亲口对我说这女人是他妹妹吗？她也说那人是她哥哥。我这样做问心无愧，没有过错。” ");
INSERT INTO cmncbs_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","上帝在梦中对他说：“我知道你问心无愧，所以我才阻止你，不让你亲近她，免得你得罪我。 ");
INSERT INTO cmncbs_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","现在你要把那人的妻子还给他，他是个先知，他会为你祷告，使你活命。要知道，如果你不这样做，你和你的人民都必死。” ");
INSERT INTO cmncbs_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","亚比米勒清早起来召来他的臣仆，把整件事情告诉他们，他们听了都十分害怕。 ");
INSERT INTO cmncbs_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","亚比米勒召见亚伯拉罕，对他说：“你对我们做的是什么事？我什么地方得罪了你？你竟使我和我的人民陷入大罪！你对我们做了不该做的事。” ");
INSERT INTO cmncbs_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","又说：“你为什么这样做？” ");
INSERT INTO cmncbs_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","亚伯拉罕回答说：“我以为这里的人不敬畏上帝，他们必杀掉我，夺走我妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","况且，她真是我的妹妹，与我同父异母，后来做了我的妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","上帝吩咐我离开家乡到外面漂泊的时候，我对她说，‘无论我们到哪里，你都要说我是你哥哥，这就是你对我的恩情。’” ");
INSERT INTO cmncbs_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","于是，亚比米勒带来牛、羊和仆婢送给亚伯拉罕，并把他妻子撒拉还给他， ");
INSERT INTO cmncbs_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","又对他说：“我的土地就在你面前，你想住在哪里都可以。” ");
INSERT INTO cmncbs_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","亚比米勒对撒拉说：“我给你哥哥二百二十两银子，在你家人面前证明你清白无过。” ");
INSERT INTO cmncbs_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","亚伯拉罕向上帝祷告，上帝就医治了亚比米勒和他妻子及众婢女，使她们能够生育。 ");
INSERT INTO cmncbs_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","原来耶和华因为亚伯拉罕的妻子撒拉这件事，使亚比米勒宫中所有的妇女都不能生育。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","耶和华按着自己说过的话眷顾撒拉，成就给她的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","亚伯拉罕年老的时候，撒拉怀了孕，在上帝指定的日期为他生了一个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","亚伯拉罕为撒拉所生的儿子取名叫以撒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","以撒出生后第八天，亚伯拉罕就照着上帝的吩咐为他行了割礼。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","以撒出生时亚伯拉罕已经一百岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","撒拉说：“上帝使我欢笑，凡听见这事的人也必跟我一同欢笑。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","谁会对亚伯拉罕说撒拉要哺养孩子呢？我竟然在他年老的时候给他生了儿子。” ");
INSERT INTO cmncbs_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","以撒渐渐长大，亚伯拉罕在他断奶的那天大摆宴席。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","撒拉见埃及人夏甲给亚伯拉罕生的儿子以实玛利嘲笑以撒， ");
INSERT INTO cmncbs_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","就对亚伯拉罕说：“赶走这婢女和她的儿子，因为这婢女的儿子不可和我的儿子以撒一同承受产业。” ");
INSERT INTO cmncbs_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","亚伯拉罕因儿子以实玛利的事非常苦恼。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","上帝对亚伯拉罕说：“你不要再为这孩子和你的婢女苦恼，只管照撒拉的话做，因为以撒生的才可算为你的后裔。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","至于婢女的儿子以实玛利，我也会使他自成一国，因为他也是你的后裔。” ");
INSERT INTO cmncbs_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","第二天，亚伯拉罕清早起来，把食物和一皮袋水给了夏甲，放在她肩上，让她和孩子离开。夏甲就走了，在别示巴的旷野流浪。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","皮袋的水喝光了，夏甲把儿子留在一丛灌木下， ");
INSERT INTO cmncbs_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","自己走到离孩子约一箭之远的地方，对着孩子坐下，说：“我不忍心看着他死啊！”夏甲坐在那里放声大哭起来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","上帝听见孩子的哭声，就差遣天使从天上安慰夏甲说：“夏甲，你怎么了？不要害怕，上帝已经听见孩子的哭声了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","你去扶他起来，用手搀着他，我必使他成为大国。” ");
INSERT INTO cmncbs_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","上帝开了夏甲的眼睛，让她看见一口水井，她就上前把皮袋装满水拿给儿子喝。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","在上帝的看顾下，孩子渐渐长大。他住在旷野，成为一个射箭能手。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","他住在巴兰旷野，他母亲为他娶了一个埃及女子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","那时，亚比米勒和他的将领非各对亚伯拉罕说：“你做的一切都有上帝保佑。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","现在请你在这里当着上帝的面向我起誓，你不会欺骗我和我的子孙后代。我怎样善待你，请你也同样善待我以及你所寄居之地的百姓。” ");
INSERT INTO cmncbs_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","亚伯拉罕说：“我愿起誓。” ");
INSERT INTO cmncbs_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","由于亚比米勒的仆人霸占了一口水井，亚伯拉罕就指责亚比米勒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","亚比米勒说：“我不知道是谁做的，你以前没有告诉我，我今天才听说这事。” ");
INSERT INTO cmncbs_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","亚伯拉罕把牛羊送给亚比米勒，他们二人立了约。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","亚伯拉罕又从羊群中分出七只母羊羔。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","亚比米勒问亚伯拉罕：“你分出七只母羊羔是什么意思？” ");
INSERT INTO cmncbs_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","亚伯拉罕回答说：“你要从我手中接受这七只母羊羔，以证明这口井是我挖的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","所以，那地方被称为别示巴，因为他们二人在那里起了誓。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","他们在别示巴立约以后，亚比米勒和他的将领非各便回非利士去了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","亚伯拉罕在别示巴栽了一棵柳树，又在那里呼求永恒上帝耶和华的名。 ");
INSERT INTO cmncbs_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","亚伯拉罕在非利士人那里住了很长时间。 ");
INSERT INTO cmncbs_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","这些事以后，上帝要考验亚伯拉罕，就呼唤他：“亚伯拉罕！”他回答说：“我在这里。” ");
INSERT INTO cmncbs_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","上帝说：“带着你的儿子，你的独生子，你疼爱的以撒前往摩利亚，在我指示你的山上把他献为燔祭。” ");
INSERT INTO cmncbs_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","亚伯拉罕清早起来，准备好驴，劈好献燔祭用的柴，带着两个仆人和儿子以撒动身前往上帝指示他的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","到了第三天，亚伯拉罕抬头远远看见那地方， ");
INSERT INTO cmncbs_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","就对仆人说：“你们和驴在这里等着，我和孩子到那边敬拜上帝，然后便回来。” ");
INSERT INTO cmncbs_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","亚伯拉罕把献燔祭用的柴放在儿子以撒肩上，自己手里拿着火种和刀。父子二人一同向前走。 ");
INSERT INTO cmncbs_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","以撒说：“父亲。”亚伯拉罕说：“儿子，什么事？”以撒说：“你看，火种和柴都有了，但献燔祭用的羊羔在哪里呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","亚伯拉罕说：“儿子，上帝会亲自预备献燔祭的羊羔。”二人就一同向前走。 ");
INSERT INTO cmncbs_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","他们到了上帝指示的地方，亚伯拉罕就筑起祭坛，把柴摆在上面，然后把以撒捆起来放在祭坛上面的柴上。 ");
INSERT INTO cmncbs_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","亚伯拉罕伸手拿起刀来，要杀他的儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","耶和华的天使从天上呼唤他说：“亚伯拉罕！亚伯拉罕！”他回答说：“我在这里。” ");
INSERT INTO cmncbs_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","天使说：“不可动孩子，不可伤害他！现在我知道你敬畏上帝，因为你不惜把你的儿子，你的独生子献给我。” ");
INSERT INTO cmncbs_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","这时亚伯拉罕抬头一看，见有一只公绵羊两角卡在稠密的树丛中，于是把羊取来代替他的儿子献为燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","亚伯拉罕称那地方为“耶和华以勒”。直到今天人们还说：“在耶和华的山上必有预备。” ");
INSERT INTO cmncbs_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","耶和华的天使再次从天上呼唤亚伯拉罕， ");
INSERT INTO cmncbs_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","对他说：“耶和华说，‘你既然不惜献上你的儿子，你的独生子，我凭自己起誓， ");
INSERT INTO cmncbs_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","我必赐福给你，使你的后裔多如天上的星和海边的沙。你的后裔必夺取仇敌的城池， ");
INSERT INTO cmncbs_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","天下万国必因你的后裔而蒙福，因为你听从了我的话。’” ");
INSERT INTO cmncbs_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","于是，亚伯拉罕回到仆人那里，他们一同返回亚伯拉罕居住的别示巴。 ");
INSERT INTO cmncbs_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","过了些日子，有人告诉亚伯拉罕：“密迦为你兄弟拿鹤生了几个儿子， ");
INSERT INTO cmncbs_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","长子乌斯、乌斯的弟弟布斯、亚兰的父亲基姆利、 ");
INSERT INTO cmncbs_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","基薛、哈琐、必达、益拉和彼土利。” ");
INSERT INTO cmncbs_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","彼土利是利百加的父亲。密迦为亚伯拉罕的兄弟拿鹤生了这八个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","拿鹤的妾流玛生了提八、迦含、他辖和玛迦。 ");
INSERT INTO cmncbs_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","撒拉享年一百二十七岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","她在迦南境内的基列·亚巴，即希伯仑去世。亚伯拉罕在那里痛哭，哀悼她。 ");
INSERT INTO cmncbs_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","他从亡妻旁边站起来对赫人说： ");
INSERT INTO cmncbs_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“我在你们中间是异乡客旅，请你们给我一块坟地，我好埋葬我的亡妻。” ");
INSERT INTO cmncbs_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","赫人答道： ");
INSERT INTO cmncbs_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“我主，请听我们说，你在我们中间是一位尊贵的王子，你可以选我们这里最好的坟地，没有人会反对你使用他的坟地埋葬你的妻子。” ");
INSERT INTO cmncbs_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","亚伯拉罕就起身向当地的赫人下拜，说： ");
INSERT INTO cmncbs_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“如果你们愿意让我安葬亡妻，就请答应我，代我求琐辖的儿子以弗仑， ");
INSERT INTO cmncbs_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","把他地头的麦比拉洞卖给我。请他当着你们的面按实价卖给我作坟地。” ");
INSERT INTO cmncbs_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","当时以弗仑正坐在赫人当中，于是他当着所有出入城门口的赫人答复亚伯拉罕说： ");
INSERT INTO cmncbs_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“不可！我主，请听我说，我当着族人的面，把那块地和其中的山洞送给你。去安葬你的死者吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","亚伯拉罕向当地的人下拜， ");
INSERT INTO cmncbs_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","当众对以弗仑说：“你若愿意，请听我说，我要把地钱给你，请你收下，好让我在那里安葬我的妻子。” ");
INSERT INTO cmncbs_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","以弗仑回答说： ");
INSERT INTO cmncbs_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“我主，请听我说，九十两银子的地对你我来说算什么呢？去安葬你的妻子吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","于是，亚伯拉罕听了以弗仑的意思，就照当众提出的价钱，按市价秤了九十两银子给他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","这样，以弗仑在麦比拉、靠近幔利的那块地和山洞及地界内所有的树木， ");
INSERT INTO cmncbs_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","都归了亚伯拉罕。这是在城门口的赫人面前买下的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","之后，亚伯拉罕把妻子撒拉安葬在迦南的幔利附近、麦比拉田间的洞里。幔利就是希伯仑。 ");
INSERT INTO cmncbs_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","这块赫人的地和其中的山洞从此成了亚伯拉罕家的坟地。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","亚伯拉罕已经年迈，耶和华在一切事上都赐福给他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","亚伯拉罕对负责他所有产业的老总管说：“请你把手放在我大腿底下， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","我要你凭掌管天地的上帝耶和华起誓，你不会找我所居之地的迦南女子做我儿子的妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","你要回到我的家乡，在我的亲族中为以撒物色妻子。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","老总管问他：“如果那女子不肯跟我到这里来呢？我要把你儿子带回你的家乡吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","亚伯拉罕说：“你千万不可带我的儿子回那里！ ");
INSERT INTO cmncbs_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","因为带领我离开父家和本乡的天上的上帝耶和华，曾经向我说话，起誓应许把这片土地赐给我的后裔。祂必派天使在你前面引路，好让你在那里为我儿子找到妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","如果那女子不肯跟你来，你也算履行了你向我起的誓，只是你不可带我儿子回那里。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","于是，老总管就把手放在他主人亚伯拉罕的大腿底下，为这事向他起誓。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","老总管带着主人的十匹骆驼和各种上好的礼物，启程前往美索不达米亚，来到拿鹤住的城。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","黄昏，妇女们出来打水的时候，他让骆驼跪在城外的井旁， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","然后祷告说：“我主人亚伯拉罕的上帝耶和华啊，求你施恩给我家主人亚伯拉罕，让事情今天能够成就。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","现在，我站在这泉水旁，城里的女子正出来打水。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","如果我对哪个少女说‘请放下你的水罐，让我喝点水’，如果她说‘请喝，我也打水给你的骆驼喝’，愿那女子做你为自己的仆人以撒选定的妻子。这样，我就知道你施恩给我的主人了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","老总管的话还没有说完，利百加肩上扛着水罐走出来。她是彼土利的女儿，彼土利是亚伯拉罕的兄弟拿鹤和密迦所生的儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","利百加长得非常美丽，是个处女，没有男人亲近过她。她下到井旁，把水罐盛满了水后上来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","老总管跑上前去对她说：“求你给我一点水喝。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","她回答说：“我主，请喝！”说完，立刻放下水罐，托在手上让他喝。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","等他喝完以后，利百加又说：“我再为你的骆驼打水，让它们喝饱。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","于是，她迅速把水罐里的水倒进水槽里，又跑到井边为所有的骆驼打水。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","老总管默不作声地注视着利百加，要看看耶和华是否使他此行顺利。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","骆驼喝过水以后，老总管拿出一只约六克重的金环和一对约一百一十克重的金镯给利百加， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","对她说：“请问你是谁的女儿？你父亲家里有地方让我们住宿吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","利百加回答说：“我是彼土利的女儿，我父亲是拿鹤和密迦的儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","我家里有充足的粮草，也有地方让你留宿。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","老总管听了，就俯伏敬拜耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","说：“我主人亚伯拉罕的上帝耶和华当受称颂，因为祂一直以慈爱和信实对待我的主人。耶和华也一路引导我走到我主人兄弟的家里。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","利百加跑回家中，把这事告诉了母亲家的人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","利百加有个哥哥名叫拉班。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","他看见妹妹的金环和手上的金镯，听了她叙述老总管的话，就跑到井旁，见老总管跟骆驼仍然站在那里， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","便对他说：“你这蒙耶和华赐福的人，请到我家。为什么站在外面呢？我已经为你预备好了房间，也为骆驼预备了地方。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","老总管就到了拉班的家里，拉班卸下骆驼背上的东西，给骆驼喂上草料，打水给老总管和随行的人洗脚。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","然后晚餐准备好了，老总管却说：“不，等我说明来意后再吃。”拉班说：“请说。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","老总管说：“我是亚伯拉罕的仆人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","耶和华赐给我主人极大的福气，使他非常富有。耶和华赐给他牛群、羊群、金子、银子、仆婢、骆驼和驴。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","我主人的妻子撒拉在晚年生了一个儿子，主人把所有的财产都给了他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","主人要我起誓，他说，‘你不可给我的儿子娶我居住的迦南当地女子为妻， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","你要到我家乡的亲族中为我儿子物色妻子。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","我问我的主人，‘如果那女子不愿意跟我回来怎么办？’ ");
INSERT INTO cmncbs_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","他说，‘我忠心事奉的耶和华必派天使与你同行，使你一路顺利，为我儿子在家乡的亲族中物色妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","你去我亲族那里就是履行了你向我起的誓，如果我的亲族不肯把女子交给你，你也算履行了你向我起的誓。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“今天我来到井旁时曾祷告说，‘我主人亚伯拉罕的上帝耶和华啊，求你使我一路顺利。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","我现在站在井旁，有女子出来打水的时候，我会对她说，请让我喝一点你罐里的水， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","如果她说，请喝，我也打水给你的骆驼喝，就让她做你为我家主人的儿子预备的妻子吧。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“我心中的话还没有说完，就看见利百加肩上扛着水罐到井旁打水。我上前向她要水喝， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","她就连忙放下肩上的水罐，说，‘请喝，我也打水饮你的骆驼。’我喝了，她又打水饮骆驼。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","我问她是谁家的女儿，她说，‘是拿鹤和密迦的儿子彼土利的女儿。’我就给她戴上金鼻环和金手镯， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","然后俯伏敬拜、颂赞我主人亚伯拉罕的上帝耶和华，祂引导我走对路，使我找到了我主人兄弟的孙女给我主人的儿子做妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","现在，你们若愿意以慈爱和信实对待我的主人，答应这门亲事，请告诉我；如果不答应，也请告诉我，好让我知道应该怎么办。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","拉班和彼土利回答说：“既然这是耶和华的安排，我们就无话可说了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","你看，利百加就在这里，你可以照耶和华的话，把她带回去给你主人的儿子做妻子。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","亚伯拉罕的老总管听见这话，就俯伏在地上敬拜耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","然后拿出金银首饰和衣裳送给利百加，又把贵重的礼物送给她的哥哥和母亲。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","老总管和随行的人用过晚饭以后，在那里住了一夜。早晨，老总管说：“请让我返回我主人那里。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","但利百加的哥哥和母亲说：“让她和我们住上十来天再去吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","可是，老总管说：“既然耶和华已经使我一路顺利，请你们不要挽留我，请让我回到我主人那里。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","他们说：“我们问问利百加的意见吧。” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","他们就叫来利百加，问她：“你愿意跟这个人同去吗？”利百加说：“我愿意！” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","于是，他们让妹妹利百加和她的奶妈跟老总管及随行的人一同离去， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","并为利百加祝福，说： “我们的妹妹啊， 愿你成为千万人之母！ 愿你的后裔占领敌城！” ");
INSERT INTO cmncbs_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","于是，利百加和她的婢女们准备妥当，骑上骆驼，跟着老总管离去。老总管就这样带着利百加走了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","那时，以撒住在南地，他刚从庇耳·拉海·莱回来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","傍晚的时候，以撒来到田间默想，他抬头一看，见一队骆驼迎面而来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","利百加抬头看见以撒，就从骆驼上下来， ");
INSERT INTO cmncbs_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","问老总管：“那从田间来迎接我们的是谁？”老总管说：“是我的主人！”利百加听了就蒙上面纱。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","老总管向以撒讲述整个事情的经过。 ");
INSERT INTO cmncbs_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","以撒就带利百加进入他母亲撒拉的帐篷，娶她为妻，并且爱她。自从母亲去世后，以撒这才得到安慰。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","亚伯拉罕又娶了基土拉为妻。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","基土拉为亚伯拉罕生了心兰、约珊、米但、米甸、伊施巴和书亚。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","约珊生了示巴和底但，底但的子孙是亚书利族、利都示族和利乌米族。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","米甸的儿子是以法、以弗、哈诺、亚比大和以勒大。这些都是基土拉的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","亚伯拉罕把所有的财产都给了以撒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","他趁自己还在世的时候，把一些财物送给他的妾所生的儿子们，让他们离开他的儿子以撒到东方去。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","亚伯拉罕活了一百七十五岁， ");
INSERT INTO cmncbs_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","享尽天年，寿终正寝，归到他祖先那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","他的两个儿子以撒和以实玛利把他安葬在麦比拉洞，那山洞在幔利附近、赫人琐辖的儿子以弗仑的地里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","那块地是亚伯拉罕向赫人买的，他和妻子撒拉都葬在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","亚伯拉罕去世以后，上帝赐福给他的儿子以撒。以撒住在庇耳·拉海·莱附近。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","以实玛利是亚伯拉罕和撒拉的婢女埃及人夏甲所生的儿子，以下是以实玛利的后代。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","以实玛利的儿子按出生的次序名字如下：长子尼拜约，然后是基达、亚德别、米比衫、 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","米施玛、度玛、玛撒、 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","哈大、提玛、伊突、拿非施、基底玛。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","这些都是以实玛利的儿子，他们按照其村庄和营寨分别做了十二个族的族长。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","以实玛利活了一百三十七岁，寿终正寝，归到他祖先那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","他子孙居住的地方从哈腓拉一直延伸到埃及东面、通往亚述方向的书珥，他们与其他亲属作对。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","以下是关于亚伯拉罕的儿子以撒的记载。 亚伯拉罕生以撒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","以撒四十岁娶利百加，利百加是巴旦·亚兰的亚兰人彼土利的女儿、拉班的妹妹。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","以撒因为利百加不生育，就为她祈求耶和华。耶和华应允了他的祈求，利百加就怀了孕。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","两个胎儿在她腹中彼此相争，她说：“怎么会这样？”于是，她去求问耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","耶和华对她说： “你腹中有两个国家， 两族从你里面分出， 一族要比另一族强大， 将来大的要服侍小的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","到了生产的时候，利百加果然生下双胞胎。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","先出生的婴儿身体通红，浑身长毛，好像穿了皮衣，因此给他取名叫以扫。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","随后出生的弟弟手抓着以扫的脚跟，因此给他取名叫雅各。那时以撒六十岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","孩子们渐渐长大，以扫擅长狩猎，常在田野活动；雅各性情安静，喜欢待在家里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","以撒疼爱以扫，因为他喜欢吃以扫打的野味，利百加却疼爱雅各。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","一天，雅各正在熬汤，以扫筋疲力尽地从田野回来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","以扫对雅各说：“我要累死了，给我一些红汤喝吧！”因此，以扫又叫以东。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","雅各回答说：“你今天把长子的名分卖给我吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","以扫说：“我都快死了，长子的名分对我有什么用呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","雅各说：“你现在向我起誓保证吧！”于是，以扫就起誓把长子的名分卖给了雅各。 ");
INSERT INTO cmncbs_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","雅各把饼和豆汤给以扫，以扫吃完喝完便起身走了。以扫就这样轻看自己长子的名分。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","亚伯拉罕在世的时候，那地方闹过一次饥荒，这时又遭遇饥荒。以撒就迁到基拉耳的非利士王亚比米勒那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","耶和华向以撒显现说：“不要下埃及去，要住在我指示你住的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","你寄居在这里，我必与你同在，赐福给你，因为我必把这些土地赐给你和你的后代，坚立我对你父亲亚伯拉罕的誓约。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","我必使你的后代多如天上的繁星，将这些土地都赐给他们，天下万国必因你的后裔而蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","因为亚伯拉罕听从我的话，遵守我的吩咐、命令、典章和律法。” ");
INSERT INTO cmncbs_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","于是，以撒就在基拉耳住下来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","那里的人问起他的妻子时，他便说：“她是我妹妹。”他不敢说：“她是我妻子。”他担心当地的人会因为利百加而杀害他，因为利百加长得非常美丽。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","以撒在那里住了许久。一天，非利士王亚比米勒从窗口看见以撒在爱抚利百加， ");
INSERT INTO cmncbs_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","便召见以撒，问他：“她明明是你妻子，为什么你说她是你妹妹呢？”以撒回答说：“我担心别人为了她而杀害我！” ");
INSERT INTO cmncbs_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","亚比米勒说：“你怎么可以这样对我们呢？万一百姓中有人占有了她，你就使我们陷入罪中了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","于是，亚比米勒下令全国：“凡伤害他们二人的，必被处死。” ");
INSERT INTO cmncbs_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","以撒在那里耕种，耶和华赐福给他，那一年他得了百倍的收成。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","他的财富越来越多，成了大富户。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","他拥有很多的牛羊和仆婢，非利士人嫉妒他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","他父亲亚伯拉罕生前派人挖的那些水井，全被非利士人用土塞住了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","亚比米勒对以撒说：“请你离开我们吧，因为你太强盛了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","以撒就离开那里，把帐篷迁往基拉耳谷居住。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","他的父亲亚伯拉罕生前挖的水井都被非利士人塞住了，以撒便重新挖开，并沿用父亲生前给那些水井起的名字。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","以撒的牧人在谷中挖得一口活水井， ");
INSERT INTO cmncbs_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","基拉耳的牧人与以撒的牧人争吵起来，都说：“这口井是我们的。”于是，以撒便称那口井为埃色，因为他们与他相争。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","后来，以撒的仆人又挖了一口井，他们双方又为那口井发生争执，以撒便称那口井为西提拿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","以撒离开那里，又挖了一口水井。这次，他们没有为那口井争吵。所以，以撒称那口井为利河伯。以撒说：“如今耶和华给了我们一个宽阔的地方，我们可以在这里繁荣兴旺。” ");
INSERT INTO cmncbs_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","以撒从那里上别示巴去。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","当晚，耶和华向他显现说：“我是你父亲亚伯拉罕的上帝。你不要害怕，因为我与你同在。为了我仆人亚伯拉罕的缘故，我必赐福给你，使你人丁兴旺。” ");
INSERT INTO cmncbs_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","以撒在那里筑了一座坛求告耶和华的名，并且在那里搭起帐篷住下来。他的仆人又在那里挖了一口井。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","一天，亚比米勒带着他的参谋亚户撒、将领非各从基拉耳来见以撒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","以撒说：“你们既然憎恨我，把我赶走，为什么又来找我？” ");
INSERT INTO cmncbs_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","他们回答说：“我们清楚知道耶和华与你同在，我们双方应该订立誓约。我们要跟你立约， ");
INSERT INTO cmncbs_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","使你不伤害我们，就像我们没有侵犯你，总是善待你，让你平安地离开一样。你是蒙耶和华赐福的人。” ");
INSERT INTO cmncbs_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","于是，以撒为他们摆设宴席，一同吃喝。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","第二天早晨，以撒和他们互相起誓之后，送他们平安地离去。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","当天，以撒的仆人将挖井的事告诉他，说：“我们找到水了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","以撒便称那口井为示巴，因此那城叫别示巴，沿用至今。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","以扫四十岁时，娶了赫人比利的女儿犹蒂与赫人以伦的女儿巴实抹。 ");
INSERT INTO cmncbs_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","她们二人常使以撒和利百加伤心。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","以撒年老的时候，眼睛昏花，几乎看不见。他把大儿子以扫叫来，说：“我儿啊！”以扫说：“我在这里。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","以撒说：“我年老了，不知道还能活多久。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","现在，带着你的弓箭去田野为我打些野味来， ");
INSERT INTO cmncbs_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","照我喜欢的口味，做成美食给我吃，以便我在死前给你祝福。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","利百加听见了以撒跟儿子以扫说的话。以扫出去打猎后， ");
INSERT INTO cmncbs_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","利百加就对她儿子雅各说：“我听见你父亲对你哥哥以扫说， ");
INSERT INTO cmncbs_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘你去打些野味回来，做成美食给我吃，以便我死之前在耶和华面前给你祝福。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","现在，我儿，你要听我的话，照我的吩咐去做。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","你到羊群里牵两只上好的山羊羔给我，我好照你父亲喜爱的口味做成美食， ");
INSERT INTO cmncbs_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","由你拿去给他吃，让他死前为你祝福。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","雅各对母亲利百加说：“哥哥以扫浑身是毛，我的皮肤光滑。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","如果父亲用手摸我，一定会发觉我骗他，那时候我不但得不到祝福，反会招来咒诅。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","他母亲利百加对他说：“我儿啊，有咒诅，我来承担。你只管听我的话，把羊羔牵来。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","于是，雅各把羊牵来交给母亲，他母亲就照他父亲喜爱的口味做成美食。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","利百加又拿了大儿子以扫留在家里的最好的衣服，给小儿子雅各穿上， ");
INSERT INTO cmncbs_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","再用山羊皮把雅各的手和脖子的光滑处都包起来， ");
INSERT INTO cmncbs_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","然后把做好的美味和饼交给儿子雅各。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","雅各来到父亲跟前，叫了一声：“父亲。”以撒回答说：“我在这里，儿子，你是哪一个？” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","雅各对父亲说：“我是你的大儿子以扫，你吩咐我的事，我已经办好了。请你坐起来，吃我打的野味，然后给我祝福。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","以撒对他说：“我儿，你怎么这么快就打到野味了？”雅各回答说：“因为你的上帝耶和华让我碰见好机会。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","以撒对雅各说：“我儿，过来，让我摸摸看你是不是我儿以扫。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","雅各挨到父亲跟前，以撒摸着他说：“声音是雅各的声音，手却是以扫的手。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","因为雅各手上有毛，与他哥哥以扫的手一样，以撒分辨不出来，就给他祝福。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","以撒又问：“你真是我的儿子以扫吗？”雅各回答说：“我是。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","以撒便说：“把你打的野味拿给我，我吃了好为你祝福。”雅各递上野味，以撒吃了；雅各又拿酒给他喝，他也喝了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","父亲以撒对他说：“我儿，你过来亲吻我。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","雅各就挨上前去亲了父亲。以撒闻到他衣服上的香气，就祝福他说： “我儿子的香气就像蒙耶和华赐福之田地的香气。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","愿上帝赐你天上的甘露、肥沃的土地并丰富的五谷和新酒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","愿万民都侍奉你， 万国都向你下拜。 愿你成为你弟兄的主人， 愿你母亲的儿子向你下拜。 咒诅你的，愿他受咒诅； 祝福你的，愿他蒙祝福。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","雅各接受了以撒的祝福才刚离开，他的哥哥以扫就打猎回来了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","以扫也做好美味，拿到父亲跟前，说：“父亲，请起来吃你儿子打的野味，好给我祝福。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","他父亲以撒问道：“你是谁？”以扫回答说：“我是你的儿子，你的长子以扫。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","以撒惊得剧烈颤抖，说：“在你来之前拿野味给我吃的是谁呢？我已经吃了，也给那人祝福了，他将来必蒙祝福。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","以扫听了放声痛哭，说：“父亲啊，求你也为我祝福！” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","以撒说：“你弟弟已经用诡计把你的福分夺去了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","以扫说：“怪不得他叫雅各，他已经骗了我两次，先前把我长子的名分夺去，现在又夺去我的福分！”接着他对父亲说：“难道你没有留下别的祝福可以给我吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","以撒对以扫说：“我已经立他做你的主人，使他的众弟兄做他的仆人，并给他五谷和新酒。我儿啊，我还能为你做什么呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","以扫对父亲说：“父亲啊，你只有一个祝福吗？父亲啊，求你也为我祝福！”以扫又放声大哭。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","以撒对他说： “你住的地方必远离肥沃的土地， 也不会有天上的甘霖。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","你必倚靠刀剑生活， 又必服侍你的弟弟。 到你无法忍受的时候， 必挣脱他放在你颈上的轭。” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","以扫因为父亲把祝福给了雅各，就对雅各怀恨在心，暗自思量说：“父亲已经不久人世，我服完丧就把我弟弟雅各杀掉！” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","大儿子以扫的计谋传到利百加耳中。她就派人把小儿子雅各叫来，对他说：“你哥哥以扫想要杀你泄愤！ ");
INSERT INTO cmncbs_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","我儿，听我的话，现在就逃到哈兰我哥哥拉班那里， ");
INSERT INTO cmncbs_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","与他住些日子，一直住到你哥哥的气消了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","等他对你的气消了，忘了你对他所做的事，我会派人接你回来。我何必在一天之内失去你们两个呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","利百加对以撒说：“我被这些赫人女子烦死了。如果雅各也娶那些赫人女子为妻，我活着还有什么意思呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","以撒把雅各叫来，给他祝福，又嘱咐他说：“你不要娶迦南的女子为妻。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","马上去巴旦·亚兰，到你外祖父彼土利家，在你舅父拉班的女儿中选一个做妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","愿全能的上帝赐福给你，使你生养众多，人丁兴旺，成为许多民族。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","愿上帝把赐给亚伯拉罕的福气赐给你和你的后代，让你承受你寄居之地为产业，就是上帝赐给亚伯拉罕的土地。” ");
INSERT INTO cmncbs_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","以撒让雅各前往巴旦·亚兰，去亚兰人彼土利的儿子拉班那里。拉班是雅各和以扫的舅父。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","以扫看见以撒给雅各祝福，让他到巴旦·亚兰娶妻，叮嘱他不要娶迦南的女子， ");
INSERT INTO cmncbs_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","又看见雅各听从父母到巴旦·亚兰去了， ");
INSERT INTO cmncbs_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","就知道父亲以撒不喜欢迦南的女子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","他便到亚伯拉罕的儿子以实玛利那里，娶了以实玛利的女儿、尼拜约的妹妹玛哈拉为妻。他娶玛哈拉以前已经有两个妻子了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","雅各离开别示巴，前往哈兰。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","到了一个地方，太阳已经下山，他便在那里过夜。他就地取了一块石头枕在头下睡觉， ");
INSERT INTO cmncbs_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","梦中看见有个梯子立在地上，直通到天上，梯子上有上帝的天使上上下下。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","耶和华站在梯子上面对雅各说：“我是耶和华，是你祖父亚伯拉罕的上帝，也是以撒的上帝。我要把你现在躺卧的地方赐给你和你的后代。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","你的后代必多如地上的尘土，遍布四方，地上万族必因你和你的后裔而蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","我与你同在，无论你去哪里，我都会保护你，领你返回这片土地。我必实现对你的应许，决不离弃你。” ");
INSERT INTO cmncbs_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","雅各一觉醒来，说：“耶和华诚然在这里，我竟不知道。” ");
INSERT INTO cmncbs_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","他就害怕起来，说：“这地方何等可畏！这里正是上帝的殿，是通天的大门。” ");
INSERT INTO cmncbs_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","雅各清早起来，把枕的那块石头立成柱子，在上面浇上油。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","他称那地方为伯特利，那地方以前叫路斯。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","雅各许愿说：“如果上帝与我同在，一路保护我，供给我衣食， ");
INSERT INTO cmncbs_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","带领我平安地回到父亲家，我就一定奉耶和华为我的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","我立为柱子的这块石头必成为上帝的殿。凡你赐给我的，我必把十分之一献给你。” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","雅各继续前行，来到东方人住的地方， ");
INSERT INTO cmncbs_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","看见田间有一口井，有三群羊卧在井边，因为当地人用那口井的水饮羊。井口封着一块大石头。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","羊群聚集在井旁的时候，牧人就把井口的石头滚开饮羊，随后再把石头放回原处。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","雅各问牧人：“弟兄们，你们是从哪里来的？”他们说：“我们是从哈兰来的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","雅各问道：“你们认识拿鹤的孙子拉班吗？”他们说：“我们认识。” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","雅各又问：“他好吗？”他们回答说：“很好。你看，他的女儿拉结带着羊群来了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","雅各对他们说：“太阳还高，不到把羊关起来的时候，你们饮了羊，再放它们去吃草吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","他们说：“不行，要等所有的羊群到齐，把井口的石头滚开后，才能饮羊。” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","雅各还在跟他们说话的时候，拉结就带着她父亲的羊群来到井边，她是个牧羊女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","雅各看见表妹拉结和舅父拉班的羊群来了，就上前把井口的石头滚开，饮他舅父的羊。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","他亲吻拉结，并放声大哭。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","雅各告诉拉结自己是她父亲的外甥，是利百加的儿子。拉结便跑去告诉她父亲。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","拉班听见外甥雅各来了，就跑去迎接他，拥抱他，亲吻他，然后把他接到自己家里。雅各把事情的经过告诉他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","拉班说：“你真是我的骨肉至亲啊！”雅各在拉班家里住了一个月。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","一天，拉班对他说：“虽然我们是亲戚，也不能让你白白地替我工作。告诉我，你希望得到什么报酬？” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","拉班有两个女儿，大的叫利亚，小的叫拉结。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","利亚两眼无神，而拉结长得美丽多姿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","雅各爱上了拉结，于是对拉班说：“我愿意为你工作七年，请把你小女儿拉结许配给我。” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","拉班说：“把她嫁给你比嫁给外人好，你就留下来吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","雅各为了拉结给拉班工作了七年。因为他深爱拉结，所以这七年在他眼中就像短短的几天。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","一天，雅各对拉班说：“期限已经满了，现在请把我妻子给我，我好和她同房。” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","于是，拉班就摆设宴席款待当地的人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","到了晚上，拉班却把女儿利亚交给雅各，雅各和她同房。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","拉班又把自己的婢女悉帕送给女儿利亚做婢女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","早上，雅各才发现娶的是利亚，就对拉班说：“你对我做的是什么事啊！我服侍你不就是为了拉结吗？你为什么骗我？” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","拉班说：“依照本地的习俗，妹妹不能比姐姐先出嫁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","等这女儿七天的婚期过了，我就把那个女儿也许配给你，你再替我工作七年。” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","雅各同意了。过了七天，拉班把女儿拉结嫁给雅各， ");
INSERT INTO cmncbs_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","又把自己的婢女辟拉送给拉结。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","雅各也和拉结同房，他深爱拉结胜过爱利亚。他又替拉班工作了七年。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","耶和华看见利亚失宠，就使利亚生育，但拉结却不生育。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","利亚怀孕生了一个儿子，给孩子取名叫吕便。她说：“耶和华看见了我的痛苦，现在我丈夫一定会爱我。” ");
INSERT INTO cmncbs_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","她又怀孕生了一个儿子，就说：“耶和华听见我失宠，所以又给我这个儿子。”于是，她给孩子取名叫西缅。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","她又再度怀孕，生了一个儿子，就说：“这次我丈夫一定会依恋我，因为我给他生了三个儿子。”于是，他给孩子取名叫利未。 ");
INSERT INTO cmncbs_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","后来，利亚再次怀孕，生了一个儿子，她说：“这次我要赞美耶和华！”于是，她给孩子取名叫犹大。之后，利亚停止了生育。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","拉结见自己没有给雅各生孩子，就嫉妒姐姐。她对雅各说：“你给我孩子，不然我还不如死了！” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","雅各气愤地说：“使你不能生育的是上帝，难道我能代替上帝吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","拉结说：“你去跟我的婢女辟拉同房吧，让她替我生孩子，我也可以借她留后。” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","于是拉结把婢女辟拉给丈夫做妾，雅各和辟拉同房。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","辟拉怀了孕，为雅各生下一个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","拉结说：“上帝为我申冤，也听了我的恳求，赐给我一个儿子。”拉结就给孩子取名叫但。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","拉结的婢女辟拉又怀孕，为雅各生了第二个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","拉结说：“我跟姐姐激烈相争，我得胜了。”她就给这孩子取名叫拿弗他利。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","利亚见自己不再生育，就把婢女悉帕给雅各做妾。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","利亚的婢女悉帕给雅各生了一个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","利亚说：“真幸运！”她便给孩子取名叫迦得。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","利亚的婢女悉帕又给雅各生了第二个儿子， ");
INSERT INTO cmncbs_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","利亚说：“我真有福啊！妇女们会说我有福！”她就为孩子取名叫亚设。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","在收麦子的季节，吕便在田间找到一些风茄，拿回家给母亲利亚。拉结对利亚说：“请给我一些你儿子找到的风茄。” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","利亚说：“你抢了我丈夫还不够吗？现在还要抢我儿子的风茄吗？”拉结回答说：“你给我风茄，今夜雅各就跟你同房。” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","那天晚上，雅各从田间回来，利亚就出来迎接他说：“你要来跟我同房，因为我已经用儿子的风茄把你雇下来了。”于是，那天晚上雅各便跟利亚同房。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","上帝答应利亚的祈求，使她怀孕，为雅各生了第五个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","利亚说：“我把婢女送给丈夫，现在上帝给我报酬了。”因此，她就为孩子取名叫以萨迦。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","后来，利亚又怀孕，给雅各生下第六个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","她说：“上帝赐给我珍贵的礼物，现在我丈夫会尊重我，因为我给他生了六个儿子。”于是，她就给这个儿子取名叫西布伦。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","后来，利亚又生了一个女儿，给她取名叫底娜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","上帝眷顾拉结，听了她的祷告，使她可以生育。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","她就怀孕，生了一个儿子，说：“上帝除去了我的羞辱。” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","她给孩子取名叫约瑟，说：“愿上帝再给我添一个儿子！” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","拉结生约瑟以后，雅各对拉班说：“请让我走吧！我好回故乡， ");
INSERT INTO cmncbs_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","请把我的妻儿给我，我好离开。她们都是我替你工作得来的，你知道我怎样努力为你工作。” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","拉班却挽留他，说：“如果你肯赏光，请你留下来！因为我占卜得知上帝为了你的缘故才赐福给我。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","你要多少酬劳，只管说出来，我一定会给你。” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","雅各回答说：“你知道我怎样努力地服侍你，照顾你的牲畜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","我来以前，你的财产很少。耶和华因为我的到来而赐福给你，使你财产大增。但我自己什么时候才能兴家立业呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","拉班问：“我该给你什么呢？”雅各说：“你不用给我什么，只要你答应一件事，我就继续照料你的羊群。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","今天让我走遍你的羊群，从中挑出有斑点的绵羊、黑色的小羊和有斑点的山羊作为我的薪酬。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","以后，如果你在给我作薪酬的羊群中查出没有斑点的山羊或非黑色的绵羊，就算是我偷的。这样你可以知道我是否诚实。” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","拉班说：“好，就照你的话做！” ");
INSERT INTO cmncbs_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","当天，拉班把有条纹或斑点的公山羊以及有斑点或夹杂白纹的母山羊，连同黑色的绵羊都挑出来，交给自己的儿子们看管。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","然后，他离开雅各，彼此相隔三天的路程。雅各继续为他照料其余的羊。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","雅各折下一些杨树、杏树和枫树的嫩枝，削掉部分树皮，露出白色的条纹， ");
INSERT INTO cmncbs_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","然后把这些嫩枝插在羊喝水的水槽和水沟里。羊群来喝水时互相交配。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","它们对着这些树枝交配，就生下有条纹和有斑点的羊羔。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","雅各把这些羊羔分出来，又让羊群对着拉班那些有条纹和黑色的羊。他把自己的羊安置在一处，不与拉班的羊掺杂在一起。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","每当肥壮的羊交配时，雅各就把有条纹的枝子插在水沟里，使羊对着树枝交配。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","但如果交配的羊是瘦弱的，他就不插枝子。这样，瘦弱的羊归拉班，肥壮的羊归雅各。 ");
INSERT INTO cmncbs_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","因此，雅各变得极其富有，拥有很多羊、骆驼、驴和仆婢。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","雅各听见拉班的儿子们说：“雅各夺去了我们父亲的一切！他的财富都是从我们父亲那里得来的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","雅各发觉拉班对他的态度不如从前了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","这时，耶和华对雅各说：“回到你的家乡和亲族那里吧！我必与你同在。” ");
INSERT INTO cmncbs_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","于是，雅各就派人把拉结和利亚叫到放羊的地方， ");
INSERT INTO cmncbs_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","对她们说：“我感到你们父亲对我不如从前了，但我父亲的上帝常与我同在。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","你们知道我是怎样尽心尽力地替你们父亲工作， ");
INSERT INTO cmncbs_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","他却欺骗我，把我的工酬更改了十次。然而，上帝不让他苦待我。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","如果他说把有斑点的羊给我当酬劳，羊群生的就都是有斑点的；如果他说把有条纹的给我，羊群生的就都是有条纹的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","上帝就这样把你们父亲的牲畜夺过来给了我。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“在羊群交配的季节，我在梦中抬头看见和母羊交配的公羊都是有条纹或有斑点的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","在梦中，上帝的天使叫我，我说，‘我在这里。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","他说，‘拉班对你的所作所为，我都看见了。现在你抬头看看，与母羊交配的公羊都是有条纹或有斑点的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","我就是你在伯特利遇见的上帝。你在那里用油浇过柱子，向我许过愿。现在，你马上离开这里，回到你的家乡。’” ");
INSERT INTO cmncbs_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","拉结和利亚说：“父亲的家产没有我们的份儿， ");
INSERT INTO cmncbs_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","我们早就被当作外人了，他卖了我们，把我们的身价全部吞了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","上帝从我们父亲那里夺过来的一切财产，理当属于我们和我们的儿女。现在你只管照上帝的吩咐做吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","雅各便起来让儿女和妻子都骑上骆驼， ");
INSERT INTO cmncbs_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","带着他在巴旦·亚兰得到的所有牲畜和财物，启程去迦南他父亲以撒那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","那时拉班正在外面剪羊毛，拉结偷了父亲家中的神像。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","雅各不辞而别，背着亚兰人拉班偷偷地跑了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","他带着所有的一切渡过幼发拉底河，逃往基列山区。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","到了第三天，拉班才得知雅各逃走了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","于是，他带着族人去追赶，追了七天，在基列山区追上了雅各。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","当晚，上帝在梦中对亚兰人拉班说：“你要当心，不可对雅各多说什么。” ");
INSERT INTO cmncbs_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","拉班追上了雅各，那时雅各在基列山搭起帐篷，拉班和他的族人也在那里搭起帐篷。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","拉班对雅各说：“你做的是什么？你欺瞒我，把我的女儿像战俘一样带走。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","你为什么要偷偷地逃跑？你为什么不告诉我，我好击鼓、弹琴、唱歌欢送你？ ");
INSERT INTO cmncbs_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","你甚至不让我亲吻外孙和女儿，与他们道别，你这样做真愚蠢。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","我有能力伤害你，但你父亲的上帝昨夜对我说，‘你要小心，不可对雅各多说什么。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","你思家心切，一定要走，但你为什么要偷走我的神像呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","雅各对拉班说：“我逃跑是因为害怕，我以为你会从我身边夺走你的女儿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","至于你的神像，你在谁身上搜出来，谁就是该死的。你可以当着众弟兄的面察看，如果在我这里有什么物件是你的，你只管拿走。”雅各不知道拉结偷走了神像。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","拉班进入雅各、利亚和两个婢女的帐篷搜查，却搜不出什么。拉班离开利亚的帐篷进入拉结的帐篷， ");
INSERT INTO cmncbs_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","那时拉结已经把神像藏在骆驼的鞍座里，自己坐在上面。拉班搜遍了整个帐篷，什么也找不到。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","拉结对父亲说：“请我主别生气，我有月事在身，不能起身。”结果，拉班搜来搜去找不到神像。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","雅各发怒，斥责拉班说：“我做错了什么、犯了什么罪，以致你对我穷追不舍？ ");
INSERT INTO cmncbs_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","你搜遍我所有的东西，搜到了什么？现在就当着众弟兄的面拿出来，让他们评评理吧！ ");
INSERT INTO cmncbs_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","我在你家这二十年，你的母绵羊、母山羊没有掉过胎，我也没有吃过你公羊的肉。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","我没有把被野兽撕裂的羊带来给你，而是自己赔上。无论在白昼或黑夜被偷去的，你都要我赔偿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","我白天受尽烈日煎熬，晚上饱尝夜露寒霜，不得好睡。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","这二十年来，我为了你的两个女儿，替你工作了十四年，又用了六年才从你那里得到这些羊，你把我的工钱更改了十次。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","如果不是我父亲以撒敬畏的上帝，就是亚伯拉罕的上帝与我同在，你肯定会让我两手空空地回家。但上帝看见了我的难处和劳苦，所以在昨夜责备了你。” ");
INSERT INTO cmncbs_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","拉班回答说：“女儿是我的，孩子是我的，羊群也是我的，你的一切都是我的，我又怎会伤害我的女儿和她们的孩子呢？ ");
INSERT INTO cmncbs_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","来吧，你我立约为证。” ");
INSERT INTO cmncbs_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","于是，雅各拿来一块石头，立作柱子， ");
INSERT INTO cmncbs_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","又吩咐众弟兄去收集石头。他们把石头堆成一堆，在旁边吃喝。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","拉班称那石堆为伊迦尔·撒哈杜他，雅各却称那石堆为迦累得。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","拉班说：“今日，这石堆是你我之间的凭证。”因此，那地方名叫迦累得， ");
INSERT INTO cmncbs_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","又叫米斯巴，因为拉班说：“我们分手以后，愿上帝亲自鉴察我们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","倘若你虐待我的女儿，或在她们以外另娶妻子，即使没人知道，也有上帝在你我之间做见证。” ");
INSERT INTO cmncbs_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","拉班又说：“看我在你我之间立的这石堆和石柱。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","这石堆和石柱都是凭证，我不会越过石堆去害你，你也不可越过石堆和石柱来害我。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","愿亚伯拉罕的上帝和拿鹤的上帝，就是他们父亲的上帝，在你我之间判断是非。”雅各便凭他父亲以撒敬畏的上帝起誓， ");
INSERT INTO cmncbs_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","又在山上献祭，请众弟兄吃饭。饭后，他们一同在山上过夜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","拉班清早起来，亲吻外孙和女儿，给他们祝福，然后回家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","雅各继续前行，上帝的天使遇见了他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","雅各看见他们，就说：“这是上帝的军队！”于是称那地方为玛哈念。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","雅各先派使者到西珥，就是以东地区，去见他哥哥以扫， ");
INSERT INTO cmncbs_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","并吩咐他们：“你们要这样对我主以扫说，‘你仆人雅各说他一直寄居在拉班家里， ");
INSERT INTO cmncbs_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","现在他带了牛羊、驴和仆婢回来见我主，派我们来报信，希望在你面前蒙恩。’” ");
INSERT INTO cmncbs_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","报信的人回到雅各那里，说：“我们到了你哥哥以扫那里，他正带着四百人前来见你。” ");
INSERT INTO cmncbs_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","雅各听了非常害怕，忧心忡忡，便把随从、牛群、羊群和骆驼分成两队， ");
INSERT INTO cmncbs_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","心想：“如果以扫来攻击一队，另一队还可以逃生。” ");
INSERT INTO cmncbs_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","他祷告说：“耶和华，我祖父亚伯拉罕和我父亲以撒的上帝啊！你吩咐我回到家乡和亲族那里，答应厚待我。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","我不配蒙你以慈爱和信实相待，我先前过约旦河的时候，手上只有一根杖，现在却有两队人畜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","求你救我脱离我哥哥以扫的手，我怕他会来杀我和我的妻儿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","然而，你曾说，‘我必厚待你，使你的后代多如海沙，不可胜数。’” ");
INSERT INTO cmncbs_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","那天晚上，雅各就在那里过夜，又从产业中挑选牲畜送给哥哥以扫作礼物： ");
INSERT INTO cmncbs_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","母山羊二百只、公山羊二十只、母绵羊二百只、公绵羊二十只、 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","哺乳的骆驼三十头及其小骆驼、母牛四十头、公牛十头、母驴二十头、公驴十头。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","雅各把牲畜每类分成一群，交给仆人看管，对他们说：“你们走在前头，每群牲畜之间要保持一段距离！” ");
INSERT INTO cmncbs_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","又吩咐走在最前面的仆人说：“我哥哥以扫遇到你的时候，如果问你是谁家的人？要到哪里去？你前头这些牲畜是谁的？ ");
INSERT INTO cmncbs_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","你就说，‘是你仆人雅各的，是送给他主人以扫的礼物，他自己就在后面。’” ");
INSERT INTO cmncbs_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","雅各又吩咐赶第二群、第三群及其余牲畜的仆人遇见以扫时也要这样回答， ");
INSERT INTO cmncbs_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","并且一定要说：“你仆人雅各就在后面。”雅各想先用礼物去化解以扫的怨恨，也许见面时以扫会善待他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","于是，他派人先把礼物送过去，自己则留在营里过夜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","当夜，雅各起来带着两个妻子、两个婢女和十一个儿子渡过雅博渡口。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","雅各把他们连同一切所有都送过河以后， ");
INSERT INTO cmncbs_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","自己独自留下。有一个人来和他摔跤，直到黎明。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","那人见胜不过雅各，就在他的大腿窝摸了一下，他大腿的关节就脱臼了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","那人说：“天亮了，让我走吧！”但雅各说：“你不祝福我，我就不让你走。” ");
INSERT INTO cmncbs_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","那人问道：“你叫什么名字？”他说：“我叫雅各。” ");
INSERT INTO cmncbs_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","那人说：“你以后不要再叫雅各了，你要叫以色列，因为你跟上帝和人角力都得胜了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","雅各说：“请你告诉我你的名字。”那人说：“你为什么问我的名字？”他就在那里给雅各祝福。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","雅各称那地方为毗努伊勒，因为他说：“我面对面见过上帝，竟能活命。” ");
INSERT INTO cmncbs_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","雅各经过毗努伊勒的时候，太阳出来了，那时他的大腿瘸了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","以色列人至今都不吃大腿窝的筋，因为那人摸过雅各大腿窝的筋。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","雅各抬头看见以扫带着四百人迎面而来，便把孩子们分别交给利亚、拉结和两个婢女， ");
INSERT INTO cmncbs_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","又让两个婢女和她们的孩子走在前面，利亚和她的孩子跟在后面，拉结和约瑟走在最后。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","他自己则走在他们前面，接连俯伏下拜七次，直到他哥哥跟前。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","以扫跑上去迎接他，拥抱他，亲吻他，二人抱头痛哭。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","以扫抬眼看见跟在雅各后面的妇女和孩子，就问：“这些和你同行的是谁？”雅各说：“这些孩子是上帝施恩赐给你仆人的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","雅各的两个婢女和她们的孩子上前下拜， ");
INSERT INTO cmncbs_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","利亚和她的孩子也上前下拜，最后约瑟和拉结也上前向以扫下拜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","以扫说：“我在路上遇见的那一群群牲畜是怎么回事？”雅各回答说：“我带来这些是想在我主面前蒙恩。” ");
INSERT INTO cmncbs_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","以扫说：“弟弟，我已经有很多了，你自己留着吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","雅各说：“不，你若赏脸，就请收下！我见了你的面就像见了上帝的面，因为你这样善待我。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","请你收下我的礼物吧，因为上帝恩待了我，使我富足。”雅各再三恳求，以扫才收下。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","以扫说：“我们走吧！我陪你们走。” ");
INSERT INTO cmncbs_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","雅各却说：“我主知道孩子们还幼小，而且，我还要照料正在哺乳的牛羊，如果整天赶路，牛羊都会累死。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","请我主先走，我迁就牲畜和孩子的脚步慢慢走，我在西珥与我主会合。” ");
INSERT INTO cmncbs_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","以扫说：“我给你留几个随从吧。”雅各说：“不用了，能得到我主的恩待就够了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","于是，以扫在当天先回西珥去了， ");
INSERT INTO cmncbs_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","雅各却去了疏割，在那里为自己建造房屋，为牲畜搭起棚子。因此那地方叫疏割。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","这样，雅各从巴旦·亚兰平安地回到迦南的示剑城，在城外搭营居住。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","他搭营居住的这块地是他用一百块银子向示剑的父亲哈抹的子孙买的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","雅各在那里筑了一座坛，称之为伊利·伊罗伊·以色列。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","一天，利亚给雅各所生的女儿底娜到外面去见当地的女子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","当地首领希未人哈抹的儿子示剑看到她，就抓住她，强行玷污了她。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","他恋慕雅各的女儿底娜，爱上了这个少女，就用甜言蜜语讨她欢心。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","他求父亲哈抹为他说亲，把底娜娶过来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","底娜被玷污的消息传到雅各耳中时，他的儿子们正在田野放牧。他只好忍气吞声，等儿子们回来再作打算。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","示剑的父亲哈抹来和雅各商议。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","雅各的儿子们一听说这事，就从田野赶回来。大家都非常愤怒，因为示剑玷污了雅各的女儿，对以色列家做了不该做的丑事。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","哈抹跟他们商议说：“我儿子示剑爱慕你们家的女儿，请你们把女儿嫁给他吧！ ");
INSERT INTO cmncbs_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","我们可以互相通婚，你们可以把女儿嫁给我们的儿子，也可以娶我们的女儿为妻。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","你们可以在我们这里安顿下来，这片土地就在你们面前，住在这里做买卖、置产业吧。” ");
INSERT INTO cmncbs_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","示剑对底娜的父亲和她的弟兄们说：“请你们恩待我，你们要什么，我都给你们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","只要你们把这少女嫁给我，无论你们要多少聘金和礼物，我必如数奉上。” ");
INSERT INTO cmncbs_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","雅各的儿子们因为示剑玷污了他们的妹妹底娜，就假意对示剑和他的父亲哈抹说： ");
INSERT INTO cmncbs_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“我们不能把妹妹嫁给没有受过割礼的人，这对我们是一种羞辱。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","除非你们所有的男子都跟我们一样受割礼，我们才会答应你们， ");
INSERT INTO cmncbs_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","我们才会和你们通婚，共同生活，结成一个民族。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","如果你们不肯这样做，我们就把妹妹带走。” ");
INSERT INTO cmncbs_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","哈抹父子欣然答应。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","示剑毫不迟延地照办，因为他热恋底娜。在哈抹家族中，他最受人尊重。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","哈抹父子来到城门口，对那城的居民说： ");
INSERT INTO cmncbs_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“这些人跟我们相处和睦，就让他们在这里定居、做买卖吧。我们这里有足够的地方可以容纳他们，我们可以和他们通婚。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","可是，他们有一个条件，就是要我们所有的男子和他们一样接受割礼，他们才答应和我们一起生活，结成一个民族。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","到时候，他们的财产和牛羊等所有牲畜不全归我们了吗？我们同意他们吧，这样他们就会在我们这里定居。” ");
INSERT INTO cmncbs_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","在城门进出的人听了哈抹父子的话，都表示赞同。于是，城里的男子都接受了割礼。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","到了第三天，他们伤口正疼痛的时候，雅各的两个儿子——底娜的哥哥西缅和利未拿着利剑，乘众人没有防备，进城杀掉了所有的男子， ");
INSERT INTO cmncbs_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","包括哈抹和示剑，从示剑家里带走了底娜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","雅各的众子又到被杀之人的城里掳掠，因为他们的妹妹在那里被人玷污。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","他们抢走牛群、羊群、驴群和城里城外所有的东西， ");
INSERT INTO cmncbs_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","并带走所有财物、妇孺以及房屋里的一切。 ");
INSERT INTO cmncbs_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","雅各责备西缅和利未说：“你们为什么要给我惹麻烦，使我在当地的迦南人和比利洗人中留下臭名呢？我们人数很少，要是他们联手来攻击我们，我们全家必遭灭门之祸。” ");
INSERT INTO cmncbs_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","他们说：“他怎么能把我们的妹妹当妓女对待？” ");
INSERT INTO cmncbs_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","上帝对雅各说：“你到伯特利去住，你要在那里为上帝筑一座坛，祂在你逃避你哥哥以扫时曾向你显现。” ");
INSERT INTO cmncbs_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","于是，雅各吩咐家人和所有的随从：“你们要除掉你们当中的外族神像，洁净自己，更换衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","我们要上伯特利去，在那里为上帝筑一座坛，祂在我遭遇患难时听了我的祷告，一路都与我同在。” ");
INSERT INTO cmncbs_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","他们把所有外族的神像和自己的耳环都交给雅各，雅各把这些东西埋在示剑的橡树下。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","他们就出发了，上帝使恐惧笼罩周围的城邑，没有人敢追赶他们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","雅各和所有的随从来到迦南的路斯，也就是伯特利。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","他在那里建造了一座坛，称那地方为伊勒·伯特利，因为在他逃避哥哥的时候，上帝曾在那里向他显现。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","后来利百加的奶妈底波拉死了，葬在伯特利下面的橡树下，那棵树叫亚伦·巴古。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","雅各从巴旦·亚兰回来后，上帝又向他显现，赐福给他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","上帝对他说：“你叫雅各，但从今以后不要再叫雅各了，你要改名叫以色列。”这样雅各改名为以色列。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","上帝又说：“我是全能的上帝，你要生养众多，人丁兴旺，一国，甚至多国必从你而出，许多君王必出自你的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","我要把赐给亚伯拉罕和以撒的土地赐给你和你的后代。” ");
INSERT INTO cmncbs_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","上帝说完就离开雅各升上天去。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","雅各在上帝跟他说话的地方立了一根石柱，又在柱子上奠酒、浇油， ");
INSERT INTO cmncbs_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","称那地方为伯特利。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","他们从伯特利继续前行，离以法他还有一段路时，拉结要分娩，出现难产。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","接生婆对难产的她说：“不要害怕，你又添了一个儿子！” ");
INSERT INTO cmncbs_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","拉结咽气前给儿子取名叫便·俄尼，雅各却叫他便雅悯。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","拉结死后就葬在通往以法他的路旁，以法他即伯利恒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","雅各在她的坟上立了石碑，这碑至今还在。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","以色列继续前行，在以得塔附近搭起了帐篷。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","以色列在那里居住时，吕便和父亲的妾辟拉通奸，以色列也知道这件事。 雅各有十二个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","利亚生了雅各的长子吕便，还有西缅、利未、犹大、以萨迦和西布伦。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","拉结生了约瑟和便雅悯。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","拉结的婢女辟拉生了但和拿弗他利。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","利亚的婢女悉帕生了迦得和亚设。他们都是雅各的儿子，是在巴旦·亚兰出生的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","雅各来到他父亲以撒住的幔利，即基列·亚巴，也就是亚伯拉罕和以撒寄居的地方。基列·亚巴就是希伯仑。 ");
INSERT INTO cmncbs_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","以撒享年一百八十岁， ");
INSERT INTO cmncbs_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","年纪老迈，寿终正寝，归到他祖先那里。他的儿子以扫和雅各把他安葬了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","以下是以扫的后代，以扫就是以东。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","以扫娶了迦南女子为妻，她们是赫人以伦的女儿亚大和希未人祭便的孙女、亚拿的女儿阿何利巴玛。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","他还娶了以实玛利的女儿、尼拜约的妹妹巴实抹。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","亚大给以扫生了以利法，巴实抹生了流珥， ");
INSERT INTO cmncbs_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","阿何利巴玛生了耶乌施、雅兰和可拉。他们都是以扫的儿子，是在迦南出生的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","以扫带着他在迦南所得的妻子、儿女和家中所有人员，以及所有的牛羊等牲畜和财产离开他弟弟雅各，迁往别处。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","因为以扫和雅各两家的财产和牲畜太多，那地方不够他们住， ");
INSERT INTO cmncbs_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","于是以扫，即以东，搬到了西珥山居住。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","以扫是西珥山区以东人的祖先，以下是他的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","以扫的妻子亚大生了以利法，他妻子巴实抹生了流珥。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","以利法的儿子是提幔、阿抹、洗玻、迦坦、基纳斯， ");
INSERT INTO cmncbs_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","以利法的妾亭纳为他生了亚玛力，他们都是以扫妻子亚大的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","流珥的儿子是拿哈、谢拉、沙玛和米撒，他们都是以扫妻子巴实抹的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","以扫的妻子阿何利巴玛是祭便的孙女、亚拿的女儿，她给以扫生了耶乌施、雅兰和可拉。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","以下是以扫子孙中的族长。 以扫的长子以利法的子孙中有提幔族长、阿抹族长、洗玻族长、基纳斯族长、 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","可拉族长、迦坦族长、亚玛力族长，他们都是以利法在以东的后代，即亚大的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","以扫的儿子流珥的子孙中有拿哈族长、谢拉族长、沙玛族长、米撒族长，他们都是流珥在以东的后代，即以扫的妻子巴实抹的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","以扫的妻子阿何利巴玛的子孙中有耶乌施族长、雅兰族长和可拉族长。这些都是以扫的妻子、亚拿的女儿阿何利巴玛子孙中的族长。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","这些族长都是以扫的子孙，以扫又名以东。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","以下是住在以东境内何利人西珥的儿子：罗坍、朔巴、祭便、亚拿、 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","底顺、以察、底珊。这些西珥的儿子是以东境内何利人的族长。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","罗坍的儿子是何利和希幔，罗坍的妹妹是亭纳。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","朔巴的儿子是亚勒文、玛拿辖、以巴录、示玻和阿南。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","祭便的儿子是埃亚和亚拿，在旷野为父亲放驴时发现温泉的就是亚拿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","亚拿的儿子是底顺、女儿名叫阿何利巴玛。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","底顺的儿子是欣但、伊是班、益兰和基兰。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","以察的儿子是辟罕、撒番和亚干。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","底珊的儿子是乌斯和亚兰。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","以下是何利人的族长：罗坍族长、朔巴族长、祭便族长、亚拿族长、 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","底顺族长、以察族长、底珊族长。他们是西珥地区何利人各宗族的族长。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","以色列人有君王统治之前，在以东做王的人如下： ");
INSERT INTO cmncbs_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","比珥的儿子比拉在以东做王，定都亭哈巴。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","比拉死后，波斯拉人谢拉的儿子约巴继位。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","约巴死后，提幔地区的户珊继位。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","户珊死后，比达之子哈达继位，定都亚未得，他曾在摩押平原击败米甸人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","哈达死后，玛士利加人桑拉继位。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","桑拉死后，大河边的利河伯人扫罗继位。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","扫罗死后，亚革波的儿子巴勒·哈南继位。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","亚革波的儿子巴勒·哈南死后，哈达继位，定都巴乌，他的妻子名叫米希她别，是米·萨合的孙女、玛特列的女儿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","以下是按宗族在各地区做族长的以扫的后代：亭纳、亚勒瓦、耶帖、 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","阿何利巴玛、以拉、比嫩、 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","基纳斯、提幔、米比萨、 ");
INSERT INTO cmncbs_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","玛基叠、以兰。这些人在所住的以东各地做族长。以扫是以东人的始祖。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","雅各住在他父亲寄居的迦南， ");
INSERT INTO cmncbs_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","以下是有关雅各一家的记载。 十七岁的少年约瑟跟哥哥们，就是他父亲雅各的妾辟拉和悉帕生的儿子们一同放羊。他向父亲报告哥哥们做的坏事。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","约瑟是以色列年老时生的，众子中以色列最爱他，为他做了一件彩衣。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","约瑟的哥哥们见父亲偏爱他，就怀恨在心，对他恶言相向。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","约瑟做了一个梦，并告诉了哥哥们，他们更恨他了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","约瑟对哥哥们说：“你们听听我做的梦： ");
INSERT INTO cmncbs_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","我们在田里捆庄稼，我捆的庄稼站立起来，你们捆的庄稼都围着我捆的庄稼下拜。” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","他的哥哥们回答说：“难道你真要做我们的王吗？真要统治我们吗？”因为约瑟的梦和他说的话，他们就更加恨他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","后来，约瑟又做了一个梦，他又去对哥哥们说：“你们听听我做的另一个梦，我梦见太阳、月亮和十一颗星星都向我下拜。” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","约瑟把梦告诉了父亲和哥哥们，他父亲就责备他说：“你做的是什么梦！难道你的父母弟兄真的都要来向你俯伏下拜吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","约瑟的哥哥们嫉恨他，他父亲却把这些话记在心里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","约瑟的哥哥们到示剑放父亲的羊。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","以色列对约瑟说：“你哥哥们在示剑放羊，我要派你去他们那里。”约瑟说：“好的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","以色列说：“你去看看你哥哥们以及羊群是否平安，然后回来告诉我。”于是，他派约瑟从希伯仑谷出发，前往示剑。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","有人见约瑟在田野走迷了路，就问他：“你在找什么？” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","约瑟回答说：“我在找我哥哥们，你知道他们在哪里放羊吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","那人说：“他们已经走了，我听他们说要到多坍去。”约瑟就赶往多坍，在那里找到了他们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","约瑟的哥哥们远远看见他走来，趁他还没有到跟前，就合谋要杀死他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","他们彼此商量说：“看！做梦的来了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","来吧！我们杀了他，把他扔在井里，就说有野兽把他吃掉了，看他的梦怎么实现。” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","吕便听后想救约瑟的性命，就说：“我们不要害他性命。” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","他又说：“不要杀人流血，把他扔在这旷野的井里吧，不要下手害他。”吕便想从他们手上救下约瑟，把他交回给父亲。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","这时候，约瑟来到哥哥们那里，他们就剥去他身上的彩衣， ");
INSERT INTO cmncbs_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","抓住他把他扔到井里。当时，那口井是干的，没有水。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","他们坐下来吃饭的时候，抬头看见一支从基列来的以实玛利商队用骆驼驮着香料、乳香、没药去埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","犹大对他的众弟兄说：“我们杀死弟弟、掩盖他的血迹有什么益处呢？ ");
INSERT INTO cmncbs_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","不如把他卖给以实玛利人，不要下手害他，他毕竟是我们的弟弟，我们的骨肉啊！”其他弟兄都赞成他的意见。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","于是，那些米甸商人经过的时候，他们就把约瑟从井里拉上来，以四两银子的价钱把他卖给了以实玛利人。这些商人把他带到埃及去了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","吕便回到井边发现约瑟不见了，就伤心地撕裂了身上的衣服， ");
INSERT INTO cmncbs_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","回到弟兄们那里说：“那少年不见了，我现在怎么办？” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","他们宰了一只公山羊，把约瑟的彩衣拿来沾上血， ");
INSERT INTO cmncbs_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","拿去给父亲，说：“我们捡到这件衣服，你看看是不是你儿子的？” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","雅各认出那件彩衣，说：“这是我儿子的衣服，一定是野兽把他吃了，约瑟一定被撕碎了！” ");
INSERT INTO cmncbs_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","雅各撕裂自己的衣服，腰间束上麻布，为约瑟哀伤了好多天。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","他的儿女都来安慰他，他却不肯接受他们的安慰，说：“我一定会悲悲伤伤地下到阴间，去我儿子那里。”约瑟的父亲为他哀哭。 ");
INSERT INTO cmncbs_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","那些米甸人把约瑟带到埃及后，卖给了法老的内臣护卫长波提乏。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","那时，犹大离开了他的兄弟们，到亚杜兰人希拉的家里住。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","他在那里遇见了迦南人书亚的女儿，就娶她为妻，与她同房。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","她怀孕生了一个儿子，犹大给他取名叫珥。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","她又怀孕生了一个儿子，给他取名叫俄南。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","她再次怀孕生了一个儿子，给他取名叫示拉。示拉是在基悉出生的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","犹大给长子珥娶了她玛为妻。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","耶和华见犹大的长子珥邪恶，就取走了他的性命。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","犹大对俄南说：“你要与嫂子她玛同房，向她尽娶寡嫂的本分，好替你哥哥传宗接代。” ");
INSERT INTO cmncbs_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","俄南知道生了儿子也不归自己，所以每次与她玛同房都把精液遗在地上，以免给哥哥留后。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","耶和华见俄南行为邪恶，就取走了他的性命。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","犹大恐怕示拉会像他的两个哥哥一样死去，就对儿媳她玛说：“示拉还没有长大，你先回娘家守寡吧。”她玛就回娘家去住了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","多年后，犹大的妻子，即书亚的女儿死了。丧期过后，犹大就和他的朋友亚杜兰人希拉去亭拿，到给他剪羊毛的人那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","有人告诉她玛说：“你公公上亭拿去剪羊毛了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","她玛见示拉已经长大，却仍然没有娶她，就脱下寡妇的衣服，用帕子蒙上脸，换了装束，坐在去亭拿路上的伊拿印城门口。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","犹大看见她蒙着脸，以为她是妓女， ");
INSERT INTO cmncbs_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","就走到路边去找她，说：“你来陪我睡觉吧。”犹大不知道她是自己的儿媳妇。她玛问道：“我陪你睡觉，你给我什么呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","犹大回答说：“我会从羊群中取一只山羊羔送给你。”她玛问道：“羊还没有送来以前，你给我什么作抵押呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","犹大问：“你要什么作抵押呢？”她玛说：“我要你的印、印带和你的手杖。”犹大给了她，然后跟她睡觉。她玛就怀了孕。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","事后，她玛起来走了。她拿掉蒙脸的帕子，仍旧穿上寡妇的装束。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","犹大托他的朋友亚杜兰人送去一只山羊羔，要从那女人手中换回抵押物，却找不到她。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","他的朋友就问当地的人：“伊拿印路旁的庙妓在哪里？”他们回答说：“这里没有庙妓。” ");
INSERT INTO cmncbs_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","他的朋友只好回去对犹大说：“我找不着她，当地人说那里没有庙妓。” ");
INSERT INTO cmncbs_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","犹大说：“让她留着我的东西吧，免得我们成为笑柄。反正我把羊送过去了，只是你找不到她。” ");
INSERT INTO cmncbs_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","大约过了三个月，有人告诉犹大说：“你的儿媳妇她玛不守妇道，并且怀孕了。”犹大说：“把她拉出来烧死！” ");
INSERT INTO cmncbs_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","他们正要把她拉出来，她请人传信给她公公，说：“这些东西的主人使我怀了孕，请你看看这印、印带和杖是谁的？” ");
INSERT INTO cmncbs_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","犹大认出是自己的东西，就说：“她比我更有理，因为我没有让儿子示拉娶她。”犹大没有再与她睡觉。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","她玛临产的时候，才知道腹中是一对双胞胎。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","生产的时候，一个婴儿先伸出手来，接生婆就把一条红线系在他的手上，说：“他是先出生的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","可是那婴儿随后却把手缩回去，他的胞兄先出生了，接生婆说：“你怎么冲出来了！”因此，他的名字叫法勒斯。 ");
INSERT INTO cmncbs_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","后来，那个手上系有红线的孩子也出生了，给他取名叫谢拉。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","约瑟被以实玛利商人带到埃及，卖给了一个埃及人，他是法老的内臣护卫长波提乏。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","约瑟住在他的埃及主人家中，耶和华与他同在，使他凡事亨通。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","他主人看出耶和华与他同在，使他凡事亨通， ");
INSERT INTO cmncbs_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","就赏识他，让他服侍自己，派他管理自己的家务及其一切所有。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","自从埃及人波提乏派约瑟管理自己家中一切事务以后，耶和华因为约瑟的缘故而赐福埃及人的家，使他家里和田间的一切都蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","于是，波提乏把一切事都交给约瑟管理，除了自己要吃的食物以外，什么也不管。 约瑟体格健壮，相貌英俊。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","后来，他主人的妻子看中了约瑟，向他眉目传情，要引诱他上床。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","约瑟拒绝了她，说：“我主人信任我，家里一切事务概不过问，都交给我管理。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","在这家里，没有人比我权力更大了，我主人把一切都交给了我，唯独你除外，因为你是他的妻子。我怎能做如此恶事得罪上帝呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","但她还是每天勾引约瑟，约瑟不从，并尽量避开她。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","一天，约瑟进屋里办事，那时屋里没有其他人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","她抓住约瑟的外衣，硬要与他上床。约瑟丢下外衣，逃了出去。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","她见约瑟丢下外衣逃了出去， ");
INSERT INTO cmncbs_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","就叫来家里的人，对他们说：“你们看，我丈夫带回家的这个希伯来人戏弄我们！他进来要与我上床，我就大声呼喊， ");
INSERT INTO cmncbs_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","他听见我大声喊叫，就把衣服丢在我这里，逃了出去。” ");
INSERT INTO cmncbs_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","她把约瑟的外衣留在身边，等她丈夫回来后， ");
INSERT INTO cmncbs_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","就对他说：“你带回来的那个希伯来奴隶进来要调戏我， ");
INSERT INTO cmncbs_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","我大声喊叫，他就把衣服丢在我这里，逃了出去。” ");
INSERT INTO cmncbs_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","波提乏听了妻子讲述约瑟如何对待她之后，勃然大怒， ");
INSERT INTO cmncbs_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","把约瑟关进王囚禁犯人的监牢。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","约瑟坐牢的时候，耶和华与他同在，恩待他，使监狱长赏识他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","监狱长把狱中所有囚犯及一切事务都交给约瑟管理。 ");
INSERT INTO cmncbs_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","凡交到约瑟手中的事情，监狱长都很放心，因为耶和华与约瑟同在，使他凡事亨通。 ");
INSERT INTO cmncbs_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","后来，埃及王的酒侍和膳司得罪了他们的主人埃及王， ");
INSERT INTO cmncbs_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","法老对这两个臣仆发怒， ");
INSERT INTO cmncbs_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","把他们囚禁在护卫长波提乏府内的监牢里，也就是约瑟被囚的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","护卫长派约瑟去伺候他们。他们在监牢待了一段日子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","一天晚上，关在监狱中的埃及王的酒侍和膳司两人都做了梦，他们的梦各有不同的意思。 ");
INSERT INTO cmncbs_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","第二天早上，约瑟过来见他们神情沮丧， ");
INSERT INTO cmncbs_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","就问这两位同被关在他主人府内的法老臣仆：“你们今天为什么满面愁容？” ");
INSERT INTO cmncbs_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","他们回答说：“我们都做了梦，可是没有人能给我们解梦。”约瑟说：“解梦不是上帝的事吗？请你们把梦告诉我。” ");
INSERT INTO cmncbs_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","酒侍便把自己的梦告诉约瑟，说：“我梦见我前面有一棵葡萄树， ");
INSERT INTO cmncbs_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","树上有三根枝子，枝子发芽开花，结出串串成熟的葡萄。 ");
INSERT INTO cmncbs_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","我手上拿着法老的酒杯，摘下葡萄，把汁挤在酒杯中，然后递到法老手中。” ");
INSERT INTO cmncbs_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","约瑟说：“这梦的意思是，三根枝子代表三天， ");
INSERT INTO cmncbs_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","三天之内，法老必让你出头并官复原职。你仍要和从前一样伺候法老饮酒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","当你再被重用的时候，请你记得恩待我，在法老面前提及我，救我出狱。 ");
INSERT INTO cmncbs_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","我是从希伯来人那里被拐来的，无辜被囚在监牢。” ");
INSERT INTO cmncbs_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","膳司见梦解得好，就对约瑟说：“我也做了个梦，我梦见自己头上顶着三筐白饼， ");
INSERT INTO cmncbs_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","最上面的一筐里放着为法老烤制的各种食物，有鸟来吃我头上筐内的食物。” ");
INSERT INTO cmncbs_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","约瑟说：“这梦的意思是，三筐就是三天， ");
INSERT INTO cmncbs_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","三天之内，法老必砍下你的头，把你挂在木头上，鸟要来吃你的肉。” ");
INSERT INTO cmncbs_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","第三天是法老的生日，他宴请文武百官，把酒侍和膳司从监牢里提出来， ");
INSERT INTO cmncbs_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","恢复了酒侍的职位，让他仍旧伺候自己饮酒， ");
INSERT INTO cmncbs_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","却将膳司挂在木头上，正应验了约瑟的话。 ");
INSERT INTO cmncbs_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","然而，法老的酒侍没有记念约瑟，竟把他遗忘了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","两年后，法老做了个梦，梦见自己站在尼罗河边， ");
INSERT INTO cmncbs_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","有七头肥美、健壮的母牛从河里上来，在芦苇丛中吃草。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","随后又有七头丑陋、瘦弱的母牛从河里上来，与那七头母牛一同站在河边。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","后来，七头丑陋、瘦弱的母牛吃掉了七头肥美、健壮的母牛。这时，法老醒了过来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","之后，他又睡着了，又做了个梦。他梦见一株麦子上长了七个饱满的穗子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","后来这株麦子上面又长了七个干瘪的穗子，它们被东风吹焦了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","七个干瘪的穗子吞食了七个饱满的穗子。法老醒过来，原来是一场梦。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","早上法老心中不安，就派人召来埃及所有的术士和智者，把梦告诉他们，可是没有一个人能为他解梦。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","这时酒侍对法老说：“我今天才想起我的罪过。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","我从前和膳司惹法老生气，被他囚禁在护卫长府内的牢里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","一天晚上，我俩都做了梦，我们的梦各有不同的意思。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","当时有一个希伯来青年跟我们一起被囚在牢里，他是护卫长的仆人。我们把梦告诉他，他就分别为我们解梦。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","后来，他为我们解的梦都应验了，我恢复了原职，膳司被挂在木头上处死了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","于是，法老派人去召约瑟，他们急忙从牢里释放约瑟。约瑟剃头刮脸，更换衣服，去见法老。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","法老对约瑟说：“我做了一个梦，没有人能为我解梦。我听说你能解梦。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","约瑟回答说：“我自己不会解梦，但上帝却能给王圆满的解释。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","法老对约瑟说：“我梦见自己站在尼罗河边， ");
INSERT INTO cmncbs_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","有七头肥美、健壮的母牛从河里上来，在芦苇丛中吃草。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","随后又有七头丑陋、瘦弱的母牛从河里上来，我在全埃及从来没有见过有这么丑陋的牛。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","这些丑陋、瘦弱的母牛吃掉先前的七头肥母牛。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","可是，它们吃了以后就像没吃一样，仍然和以前一样丑陋。这时，我就醒了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","后来我又梦见一株麦子，上面长了七个饱满的穗子， ");
INSERT INTO cmncbs_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","接着又长出七个被东风吹焦的干瘪穗子， ");
INSERT INTO cmncbs_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","这些干瘪的穗子吞了那七个饱满的穗子。我把梦告诉了术士，却没有人能为我解梦。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","约瑟对法老说：“王的梦都是同一个意思，上帝已经借着梦把祂将要做的事指示王了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","七头肥美的母牛和七个饱满的穗子都代表七年，是同样的意思。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","随后上来的七头瘦弱、丑陋的母牛和七个干瘪、被东风吹焦的穗子也代表七年，是七年饥荒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","正如我刚才说的，上帝已经把祂将要做的事向王显明了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","埃及全境很快会有七年大丰收， ");
INSERT INTO cmncbs_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","随后是七年饥荒肆虐全国，之前的丰收将被忘记。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","饥荒将非常严重，之前的丰收将荡然无存。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","王的梦出现了两次，表示上帝的心意已定，上帝必很快成就这事。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","王应该选一个精明聪慧的人，派他治理埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","王也应该在各地委派官员，在七年丰收期内征收全国出产的五分之一， ");
INSERT INTO cmncbs_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","把在丰年收集的粮食储存在各城，归王管理。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","这些粮食要留到埃及七年饥荒时用，免得这片土地被饥荒毁灭。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","法老和他所有的臣仆都赞同约瑟的建议。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","法老对臣仆说：“我们哪里找像这样有上帝的灵同在的人呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","法老对约瑟说：“上帝既然把梦的意思指示给你，可见没人有你这样的见识和智慧。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","你要管理我家，我的人民都要遵从你的命令，只有我权力比你大。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","法老又说：“我现在派你治理埃及全国。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","于是，法老摘下手上用来盖印的戒指，戴在约瑟的手上，给他穿上细麻袍，把金链戴在他颈上， ");
INSERT INTO cmncbs_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","让他坐在自己的第二辆御车上，并有人在御车前高呼：“跪下！”这样，法老派约瑟治理整个埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","法老对约瑟说：“我是法老，但没有你的命令，埃及的任何人都不得擅自行事。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","法老赐给约瑟一个名字，叫撒发那忒·巴内亚，又把安城祭司波提非拉的女儿亚西纳赐给他为妻。约瑟巡视了整个埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","约瑟三十岁开始为法老效劳，他离开法老去巡视埃及各地。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","七个丰年之内，埃及粮食大丰收， ");
INSERT INTO cmncbs_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","约瑟收集埃及七个丰年出产的所有粮食，储藏进各城，每一座城附近出产的粮食都存放在本城。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","约瑟积存了大量五谷，多如海沙，不可胜数。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","荒年到来前，安城祭司波提非拉的女儿亚西纳给约瑟生了两个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","约瑟给长子取名叫玛拿西，因为他说：“上帝使我忘记一切困苦和父亲全家。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","约瑟给次子取名叫以法莲，因为他说：“上帝使我在受苦之地昌盛。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","七个丰年结束后， ");
INSERT INTO cmncbs_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","七个荒年接踵而至，正如约瑟所言。各地都有饥荒，只有埃及全国有粮食。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","后来，埃及全国也遭遇饥荒，百姓就向法老求粮，法老对他们说：“你们去找约瑟吧，要照他的吩咐做。” ");
INSERT INTO cmncbs_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","饥荒蔓延到整个埃及时，约瑟便开仓卖粮给埃及人。那时，埃及的饥荒非常严重。 ");
INSERT INTO cmncbs_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","各地的人都到埃及来向约瑟买粮，因为天下到处都是大饥荒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","雅各得知埃及有粮食，就对儿子们说：“你们为什么还在这儿互相观望呢？ ");
INSERT INTO cmncbs_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","我听说埃及有粮食，你们快到埃及去买些粮食回来吧，我们好活命，不致饿死。” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","于是，约瑟的十个哥哥下到埃及买粮。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","雅各没有让约瑟的弟弟便雅悯与他们同去，恐怕他会遭害。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","以色列的儿子们加入了买粮的行列，因为迦南也遭遇饥荒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","那时，约瑟治理埃及，负责卖粮给百姓。约瑟的哥哥们来到他面前，向他俯伏下拜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","约瑟一眼就认出了他们，却不动声色。他疾言厉色地问道：“你们从哪里来？”他们回答说：“我们是从迦南来买粮食的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","约瑟认得他哥哥们，但他哥哥们却认不出他来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","约瑟想起了自己从前做的两个梦，就对他们说：“你们是奸细，是来探听我们虚实的！” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","他们说：“我主啊，不是的！仆人们是来买粮的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","仆人们都是一个父亲所生，是诚实人，不是奸细。” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","约瑟说：“不对，你们是来探听我们虚实的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","他们说：“仆人们共有弟兄十二人，父亲住在迦南，最小的弟弟在父亲身边，还有一个已经去世。” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","约瑟说：“我说你们是奸细一点不错。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","我以法老的性命起誓，你们最小的弟弟不来这里，你们都不能走，这是对你们的验证。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","你们派一个人回去把你们的弟弟带来，其他人都要被囚禁在这里，我要看看你们说的是真还是假。要是你们说的是假话，我以法老的性命起誓，你们一定是奸细。” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","于是，约瑟把他们囚禁了三天。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","到了第三天，约瑟对他们说：“我是敬畏上帝的人，你们照我的话做就能活命。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","如果你们是诚实人，就把一个人留在监牢，其他人带粮食回去接济你们的家人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","但你们一定要带你们最小的弟弟回来，以证实你们说的是实话，这样你们就不会死。”他们同意了， ");
INSERT INTO cmncbs_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","彼此议论说：“我们一定是在遭报应。从前我们的弟弟苦苦地哀求我们，我们却不理会，现在这场痛苦临到我们了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","吕便说：“我不是劝你们不要犯罪害那孩子吗？你们不听，现在我们必须偿还血债了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","他们不知道约瑟听得懂他们的话，因为约瑟是通过翻译跟他们谈话。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","约瑟听后转身出去哭了，然后又回来跟他们谈话，从他们中间选了西缅，当着他们的面把西缅捆绑起来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","约瑟又吩咐人把他们的袋子装满粮食，把各人买粮的钱放在他们的口袋中，还为他们预备了路上的食物。仆人一一办妥了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","约瑟的哥哥们把粮食驮在驴上，启程离去。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","他们来到一处住宿的地方，其中一人打开口袋拿饲料喂驴，却发现自己的钱在里面， ");
INSERT INTO cmncbs_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","就对其他弟兄说：“你们看，我的钱被退回来了，在我的口袋里！”他们心惊胆战地彼此议论说：“上帝这样对待我们是什么意思呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","他们回到他们在迦南的父亲雅各那里，把事情的经过告诉了他， ");
INSERT INTO cmncbs_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","说：“埃及的宰相对我们说话很凶，还把我们当成去那里打探的奸细。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","我们对他说，‘我们是诚实人，不是奸细。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","我们是一个父亲所生的十二兄弟，其中有一个已经去世，年纪最小的跟父亲留在迦南。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","那地的宰相却对我们说，‘我要看看你们是不是诚实人，你们把一个弟兄留在我这里，其他人带粮食回去接济家人吧。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","但你们要把最小的弟弟带来见我，这样我便知道你们不是奸细，是诚实人。我就会释放你们的弟兄，你们也可以在这里自由地买卖。’” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","后来他们倒口袋时，发现每个人买粮的钱袋都在自己的口袋里，他们和父亲看见钱袋，都害怕起来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","他们的父亲雅各说：“你们使我连连失去儿子，约瑟没了，西缅没了，你们还要带走便雅悯！灾祸都落在了我头上！” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","吕便对父亲说：“要是我不把便雅悯带回你身边，你就杀了我的两个儿子！请你把便雅悯交给我，我一定会把他带回你身边。” ");
INSERT INTO cmncbs_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","雅各说：“我的儿子不可跟你们去。他哥哥已经死了，现在只剩下他。要是他在路上遇到什么意外，你们会使我这白发苍苍的老人凄凄惨惨地下阴间。” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","那地方的饥荒仍然非常严重， ");
INSERT INTO cmncbs_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","他们从埃及带回来的粮食吃完了，他们的父亲对他们说：“你们再去买些粮食吧。” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","犹大说：“那人严厉地警告我们，‘不把你们的弟弟带来，你们就不要再来见我。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","你若让弟弟跟我们同去，我们就去给你买粮。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","你若不让他跟我们同去，我们就不去给你买粮。因为那人说，‘你们不把弟弟带来，就不要再来见我。’” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","以色列说：“你们为什么这样害我，告诉他你们还有一个弟弟呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","他们回答说：“那人详细询问我们和我们家人的情况，问我们的父亲是否在世，还有没有弟兄。我们如实回答，怎会想到他非要我们把弟弟带去呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","犹大对父亲以色列说：“你就让这孩子跟我同去吧，我们好立刻动身，这样我们一家老小才能保住性命，不致饿死。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","我亲自担保他的安全，你可以向我要人。我若不把他带回来见你，情愿一生担罪。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","我们若是没有耽搁的话，现在已经往返两趟了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","他们的父亲以色列说：“事到如今，只好这样了。你们袋子里带一些上好的乳香、蜂蜜、香料、没药、榧子和杏仁等土产，去送给那人作礼物吧。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","你们还要带双倍的钱，好归还上次留在你们口袋中的钱，那次可能是弄错了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","带你们的弟弟去见那人吧！ ");
INSERT INTO cmncbs_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","愿全能的上帝叫那人怜悯你们，让西缅和便雅悯回来。我若丧子就丧子吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","于是，他们就带着便雅悯、礼物和双倍的钱去埃及见约瑟。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","约瑟看见便雅悯和他们同来，就对管家说：“你带他们到我家里去，宰杀牲畜，预备宴席，中午他们要跟我一起吃饭。” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","管家照约瑟的吩咐，带他们到约瑟家里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","他们被带到约瑟家后非常害怕，说：“他把我们带到这里来，是因为上次放回我们口袋的钱。他想害我们，强迫我们做他的奴仆，抢我们的驴。” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","他们走到约瑟的管家跟前，在房门口对他说： ");
INSERT INTO cmncbs_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“主啊，我们上次曾来这里买粮。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","但在回家的途中住宿时，我们打开口袋，发现我们带来买粮的钱分毫不少地放在那里。我们把这些钱带回来了， ");
INSERT INTO cmncbs_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","又另外带了一些钱来买粮。我们不知道谁把买粮的钱放进了我们的口袋。” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","管家说：“你们放心，不要害怕，你们口袋里的钱财是你们的上帝，你们父亲的上帝赐给你们的。我已经收了你们买粮的钱。”他就把西缅带出来见他们， ");
INSERT INTO cmncbs_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","接着带他们进约瑟的家，给他们水洗脚，给他们的驴喂草料。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","他们知道要在那里吃午餐，就预备好礼物，等约瑟中午回来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","约瑟回到家里后，他们就把带来的礼物献给他，向他俯伏下拜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","约瑟向他们问好，然后说：“你们提起过你们的老父亲，他安康吗？还健在吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","他们回答说：“你仆人——我们的父亲仍然健在，安康。”说完了，又向他下拜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","约瑟抬眼看见了自己的同胞弟弟便雅悯，就问道：“这就是你们所说那位最小的弟弟吗？”他又对便雅悯说：“孩子，愿上帝施恩给你。” ");
INSERT INTO cmncbs_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","约瑟爱弟之心油然而生，急忙出去找哭的地方。他到自己的房间里哭了一场。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","他洗过脸出来，控制着自己的感情，吩咐人摆饭。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","约瑟自己一桌，他的弟兄们一桌，那些和他们一起吃饭的埃及人一桌，因为埃及人厌恶希伯来人，不与他们同席。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","约瑟让他的弟兄们按照长幼次序在他对面坐，他们面面相觑，非常惊讶。 ");
INSERT INTO cmncbs_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","约瑟吩咐人把自己面前的菜肴分给他们，便雅悯得的那份比其他弟兄多五倍。他们尽情地和约瑟一同吃喝。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","约瑟吩咐管家说：“给他们的口袋装满粮食，他们能带多少就装多少，把各人的钱放回他们的口袋中， ");
INSERT INTO cmncbs_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","再把我的银杯和买粮的钱一起放在最小的兄弟的口袋中。”管家遵命而行。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","清早，他们就牵着驴被送走了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","他们出城不久，约瑟对管家说：“你快去追他们，追上了就对他们说，‘你们为什么以恶报善？ ");
INSERT INTO cmncbs_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","为什么偷我主人用来喝酒和占卜的银杯？你们这是作恶！’” ");
INSERT INTO cmncbs_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","于是，管家追上他们，按约瑟的话问他们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","他们回答说：“我主为什么这样说？我们绝不会做这种事。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","你看，我们把上次在口袋里发现的钱都从迦南带回来还你了，又怎么会偷你主人家的金银呢？ ");
INSERT INTO cmncbs_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","你若在仆人中任何人身上搜到银杯，他就要死！我们也要做我主的奴仆。” ");
INSERT INTO cmncbs_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","管家说：“好，就照你们的话做吧！银杯从谁那里搜出来，谁就做我的奴仆，其他人都没有罪。” ");
INSERT INTO cmncbs_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","于是，他们急忙把各自的口袋卸到地上打开。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","管家就从最年长的开始搜查，结果在最年幼的便雅悯口袋里搜出了银杯。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","他们伤心地撕裂衣服，把东西放回驴背上，返回城里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","犹大和他兄弟们回到约瑟家时，约瑟还在那里，他们就俯伏在他面前。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","约瑟对他们说：“你们做的是什么事？难道你们不知道像我这样的人是懂得占卜的吗？” ");
INSERT INTO cmncbs_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","犹大说：“我们能对我主说什么呢？我们还有什么话可说呢？我们如何洗脱罪名呢？上帝既然查出你仆人们的罪，我们跟那个手上被发现有银杯的一起做我主的奴仆吧！” ");
INSERT INTO cmncbs_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","约瑟回答说：“不！我决不会这样做。从谁那里搜出了银杯，谁就做我的奴仆，其他人平安地回去见你们的父亲吧。” ");
INSERT INTO cmncbs_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","犹大近前来对他说：“我主啊，你就像法老一样，求你容仆人说一句话，不要向仆人发怒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","我主曾经问仆人们是否有父亲和弟兄， ");
INSERT INTO cmncbs_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","我们对我主说，‘我们有年迈的老父，他在晚年得了一个儿子，这孩子的哥哥已经死了，他母亲只剩下他这一个儿子，他父亲很疼爱他。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","你吩咐仆人们把弟弟带来给你亲眼看看， ");
INSERT INTO cmncbs_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","我们对我主说，‘这孩子不能离开他父亲，他若离开，他父亲一定会死。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","可是，你说如果仆人们不把最小的弟弟带来，就不得再见你的面。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","我们回到你仆人——我们的父亲那里，把我主的话告诉了他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“后来，他又吩咐仆人们回来买些粮， ");
INSERT INTO cmncbs_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","我们告诉他，我们不能来，只有我们最小的弟弟同来，我们才能来。否则，我们不能见你的面。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","你仆人——我的父亲就对我们说，‘你们知道，我妻子给我生了两个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","其中一个离我而去，我想他一定被野兽撕碎了，我再没有见过他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","要是你们把这个也带走，遇上什么意外的话，你们会使我这白发苍苍的老人凄凄惨惨地下阴间。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“我们父亲的命与这孩子的命紧密相连，倘若我没有把这孩子带回到你仆人——我的父亲身边， ");
INSERT INTO cmncbs_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","他一看这孩子不在，一定会死。仆人们会使自己白发苍苍的父亲凄凄惨惨地下阴间。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","仆人曾经向父亲担保这孩子的安全，说我若不把这孩子带回他身边，情愿一生担罪。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","现在请准许仆人代替这孩子做我主的奴仆，让他跟他哥哥们回去吧。 ");
INSERT INTO cmncbs_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","这孩子若不和我一同回去，我如何见我父亲呢？我不愿看到灾难临到我父亲。” ");
INSERT INTO cmncbs_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","约瑟在侍从面前再也控制不住自己，于是令所有侍从都出去。这样，约瑟跟弟兄们相认时，没有外人在场。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","约瑟放声大哭，埃及人听见了他的哭声，法老家也听到了消息。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","约瑟对他的弟兄们说：“我是约瑟！我的父亲还健在吗？”他的弟兄们吓得说不出话来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","约瑟叫他们走近一点，等他们靠近了，便说：“我是被你们卖到埃及的弟弟约瑟！ ");
INSERT INTO cmncbs_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","现在，你们不要因为把我卖到这里而自怨自责。上帝差我先来这里，是为了保住大家的性命。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","地上的饥荒已经两年了，我们还有五年不能种、不能收。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","上帝差我先来，是要为你们保留后代，又要大施拯救，保住你们的性命。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","这样看来，不是你们，是上帝把我送到这里的。祂使我成为法老的宰相，管理他的家和整个埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","你们快回去告诉我父亲，他儿子约瑟说，‘上帝已经使我管理整个埃及，请你立刻来我这里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","你可以带着你的子孙、牛羊及一切所有住在歌珊。那里离我很近， ");
INSERT INTO cmncbs_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","我可以奉养你，以免你和全家老少及仆婢牲畜都陷入绝境，因为还有五年的饥荒。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","你们和我弟弟便雅悯都亲眼看见了，这是我亲口对你们说的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","你们要把我在埃及享有的尊荣和你们见到的一切都告诉父亲，尽快把他接来。” ");
INSERT INTO cmncbs_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","约瑟和弟弟便雅悯抱头痛哭， ");
INSERT INTO cmncbs_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","又亲吻其他哥哥，抱着他们痛哭，然后弟兄们跟他交谈起来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","约瑟的弟兄们到来的消息传到法老的王宫，法老和他的臣仆都感到高兴。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","法老对约瑟说：“你去吩咐你的弟兄给牲畜驮上货物，返回迦南， ");
INSERT INTO cmncbs_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","把你们的父亲和家眷都接到我这里。我要把埃及最好的土地赐给他们，让他们享受这里肥美的物产。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","吩咐你的弟兄从埃及带着车去把他们的妻子、儿女和你们的父亲接来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","不要舍不得你们在迦南的财产，因为埃及全国的美物都是你们的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","以色列的儿子们就这样做了。约瑟遵照法老的吩咐，为他的弟兄们预备好车辆和路上需用的粮食， ");
INSERT INTO cmncbs_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","又给他们每人一套新衣服，但给了便雅悯五套新衣服和三百块银子。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","约瑟送给父亲十头公驴，驮着埃及的美物，还送了十头母驴，驮着粮食、饼和其他食物，让父亲路上用。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","约瑟送弟兄们回去，临行前嘱咐他们路上不要争吵。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","于是，他们离开埃及，回到迦南的父亲雅各那里， ");
INSERT INTO cmncbs_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","对父亲说：“约瑟还活着，并且做了埃及的宰相。”雅各惊呆了，不敢相信他们的话。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","雅各听了他们转述约瑟的话，又看见约瑟派来接他的车，才回过神来。 ");
INSERT INTO cmncbs_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","以色列说：“我信了！我儿约瑟还活着，我要在死之前去见他。” ");
INSERT INTO cmncbs_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","以色列带着他所有的一切来到别示巴，向他父亲以撒的上帝献祭。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","晚上，上帝在异象中对他说：“雅各！雅各！”他说：“我在这里。” ");
INSERT INTO cmncbs_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","上帝说：“我是上帝，是你父亲的上帝，不要害怕下到埃及，因为我要使你在那里成为大族。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","我必跟你一起下到埃及，也必带领你回来，约瑟必为你送终。” ");
INSERT INTO cmncbs_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","于是，雅各从别示巴启程。以色列的儿子们带着父亲和妻儿，乘坐法老派来的车， ");
INSERT INTO cmncbs_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","带着在迦南获得的牲畜和财物前往埃及。这样，雅各带着他所有的子孙， ");
INSERT INTO cmncbs_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","就是他的儿子、孙子、女儿和孙女一起去了埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","以下是去埃及的以色列人，即雅各和他后代的名字。 雅各的长子是吕便， ");
INSERT INTO cmncbs_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","吕便的儿子是哈诺、法路、希斯伦和迦米。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","西缅的儿子是耶姆利、雅悯、阿辖、雅斤、琐辖和迦南女子生的扫罗。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","利未的儿子是革顺、哥辖和米拉利。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","犹大的儿子是珥、俄南、示拉、法勒斯和谢拉，珥和俄南死在了迦南，法勒斯的儿子是希斯仑和哈姆勒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","以萨迦的儿子是陀拉、普瓦、约伯和伸仑。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","西布伦的儿子是西烈、以伦和雅利。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","这些都是利亚在巴旦·亚兰给雅各生的儿孙，加上女儿底娜共有三十三人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","迦得的儿子是洗非芸、哈基、书尼、以斯本、以利、亚罗底和亚列利。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","亚设的儿子是音拿、亦施瓦、亦施韦、比利亚和他们的妹妹西拉，比利亚的儿子是希别和玛结。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","这些是悉帕给雅各生的儿孙，共有十六人，悉帕是拉班给女儿利亚的婢女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","雅各的妻子拉结生的儿子是约瑟和便雅悯。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","约瑟在埃及生的儿子是玛拿西和以法莲，他们的母亲是安城祭司波提非拉的女儿亚西纳。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","便雅悯的儿子是比拉、比结、亚实别、基拉、乃幔、以希、罗实、姆平、户平和亚勒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","这些是拉结给雅各生的儿孙，共有十四人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","但的儿子是户伸。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","拿弗他利的儿子是雅薛、沽尼、耶色和示冷。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","这些是辟拉给雅各生的儿孙，共有七人，辟拉是拉班给女儿拉结的婢女。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","跟雅各一同到埃及去的儿孙共有六十六人，他的儿媳妇不算在内。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","加上约瑟在埃及生的两个儿子，雅各一家来到埃及的共有七十人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","雅各派犹大先去见约瑟，请他派人引路到歌珊去。他们来到歌珊， ");
INSERT INTO cmncbs_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","约瑟备好车前去迎接父亲以色列。父子重逢，约瑟抱住父亲哭了很久。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","以色列对约瑟说：“我现在看到你还活着，就是死也安心了。” ");
INSERT INTO cmncbs_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","约瑟对他的弟兄们和其他家人说：“我要上奏法老，‘我在迦南的弟兄和父亲全家已经来到我这里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","他们是牧人，以畜牧为业，已经把羊群、牛群和所有的一切都带来了。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","等法老召见你们，问你们以什么为业， ");
INSERT INTO cmncbs_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","你们要说，‘仆人们跟我们的祖先一样，从小以畜牧为业。’这样，你们就可以住在歌珊，因为埃及人厌恶牧羊的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","约瑟来到法老面前，对他说：“我父亲和我的弟兄们已经带着他们的羊群、牛群和所有的一切从迦南来了，现在就在歌珊。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","约瑟从弟兄中带了五个人去见法老。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","法老问他们：“你们做什么工作？”他们回答说：“仆人们祖祖辈辈都是牧羊的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","迦南的饥荒很严重，羊群没有草吃，所以我们到这里来寄居，求你准许仆人们住在歌珊。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","法老对约瑟说：“你父亲和弟兄们都来了， ");
INSERT INTO cmncbs_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","整个埃及就在你面前，尽管安排他们住在国中最好的地方。他们可以住在歌珊。如果你知道他们中间有能干的人，可以派他们看管我的牲畜。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","约瑟又带父亲雅各去见法老，雅各就为法老祝福。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","法老问雅各：“你多大岁数了？” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","雅各回答说：“我在世上寄居一百三十年了，我的日子又苦又短，不像我祖先当年那样高寿。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","雅各为法老祝福后，就告退了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","约瑟遵照法老之命把埃及最好的地方兰塞境内的土地给他父亲和弟兄们居住，作他们的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","约瑟按各家人口供应粮食给父亲、弟兄及其他家人。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","饥荒很严重，到处都缺粮，埃及和迦南都饱受饥荒之苦。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","约瑟把埃及人和迦南人向他买粮的银子收集起来，存放在法老的库房里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","埃及人和迦南人的银子都用光了，埃及人就来见约瑟，对他说：“我们的钱财都用光了，求你给我们粮食，免得我们饿死在你面前。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","约瑟说：“你们的钱财如果用尽了，可以用你们的牲畜来交换粮食。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","于是，他们把牲畜赶到约瑟那里，用他们的牛、羊、驴和马跟约瑟换粮食。那一年，他们就依靠换来的粮食生活。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","到了第二年，他们又来见约瑟，对他说：“不瞒我主，我们的钱都用光了，牲畜也给我主了，除了我们自己和田地以外，我们一无所有。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","求你不要让我们人死地荒。我们愿意用自己和我们的田地来换粮食，我们和我们的田地都归法老。求你给我们种子，我们好活下去，不致饿死，土地也不致荒废。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","埃及人为饥荒所迫，纷纷卖掉自己的田地。约瑟替法老收购了埃及全国的田地，最后，所有的田地都归法老了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","约瑟使埃及全境的人都成为法老的奴仆。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","约瑟唯独没有买祭司的田地，因为祭司吃法老的俸禄，有足够的供给，不用卖地。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","约瑟对百姓说：“我为法老买了你们和你们的土地，这里有种子，你们可以拿去耕种。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","但是你们在收成时要把五分之一给法老，其余的，你们可以留下来作种子和全家人的口粮。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","他们说：“你救了我们的命，愿你恩待我们，我们愿做法老的奴仆。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","于是，约瑟立下一条关于埃及土地的法令，到今天还有效，就是埃及出产的五分之一归给法老。只有祭司的田地不归法老。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","以色列人住在埃及的歌珊，在那里获得了产业，人口兴旺。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","雅各在埃及住了十七年，享年一百四十七岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","以色列快要离世的时候，把儿子约瑟叫来，说：“你如果恩待我，请把手放在我大腿底下起誓，你会以慈爱和信实待我，不把我葬在埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","我与祖先同眠后，你要把我带出埃及，安葬在我祖先的墓地。”约瑟说：“我必照你说的做。” ");
INSERT INTO cmncbs_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","他要约瑟起誓，约瑟就向他起誓。于是，以色列在床头敬拜上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","后来，有人来通知约瑟，说他父亲病了，约瑟就带着两个儿子玛拿西和以法莲去探望父亲。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","雅各听说他儿子约瑟来了，就强撑着从床上坐起来， ");
INSERT INTO cmncbs_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","对约瑟说：“全能的上帝曾经在迦南的路斯向我显现，赐福给我。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","祂对我说，‘我必使你生养众多，人丁兴旺，并把迦南赐给你的子孙永远作产业。’ ");
INSERT INTO cmncbs_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“我来之前，你在埃及生的两个儿子以法莲和玛拿西都算我的，他们跟吕便和西缅一样是我的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","除了他们以外，你其他子女仍然归你，这些子女可以在他们弟兄的名下继承产业。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","我从巴旦回来的路上，拉结死在了迦南，那地方离以法他还有一段路程，我把她葬在通往以法他的路旁。”以法他就是伯利恒。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","以色列看见约瑟的两个儿子，就问：“他们是谁？” ");
INSERT INTO cmncbs_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","约瑟说：“是上帝在这里赐给我的儿子。”以色列说：“把他们带过来，我要祝福他们。” ");
INSERT INTO cmncbs_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","以色列年纪老迈，眼睛昏花，看不清楚。约瑟把儿子带到他面前，他就亲吻他们、拥抱他们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","以色列对约瑟说：“我以为再也见不到你了，上帝竟然还让我见到了你的儿子！” ");
INSERT INTO cmncbs_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","约瑟把两个儿子从以色列的膝上领开，自己向父亲俯伏下拜， ");
INSERT INTO cmncbs_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","随后左手牵着玛拿西，右手牵着以法莲，把他们分别领到以色列的右边和左边。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","但以色列却两手交叉，把右手放在约瑟次子以法莲的头上，左手放在约瑟长子玛拿西的头上。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","他祝福约瑟说：“愿我祖先亚伯拉罕和以撒敬拜的上帝，就是牧养我一生直到今天的上帝， ");
INSERT INTO cmncbs_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","救我脱离一切患难的天使，赐福这两个孩子。愿我和我祖先亚伯拉罕及以撒的名字借着他们流传。愿他们在地上子孙兴旺。” ");
INSERT INTO cmncbs_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","约瑟见父亲把右手放在以法莲的头上，感到不悦，就把父亲的右手从以法莲的头上挪到玛拿西头上， ");
INSERT INTO cmncbs_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","对父亲说：“父亲，你弄错了，这才是长子，你应该把右手按在他的头上。” ");
INSERT INTO cmncbs_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","他父亲却不同意，说：“我儿啊，我知道，我知道。他必发展成一个强大的民族，但他弟弟将比他更强大，他弟弟的后裔必成为多个民族。” ");
INSERT INTO cmncbs_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","雅各那天祝福他们，说：“以色列人必引用你们的名祝福人，说，‘愿上帝使你们像以法莲和玛拿西一样！’”他把以法莲排在玛拿西前面。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","以色列对约瑟说：“我快死了，但上帝必与你们同在，带你们回到你们祖先的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","我要把我用刀和弓从亚摩利人手上夺来的那块地留给你，让你比其他弟兄多得一份。” ");
INSERT INTO cmncbs_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","雅各把他的儿子们都叫来，对他们说：“你们到我身边来，我要把你们将来的遭遇告诉你们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“雅各的儿子们啊， 你们要聚在一起听， 听你们父亲以色列的话。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","吕便啊，你是我的长子， 是我年轻力壮时生的， 卓有尊荣和力量。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","可是，你必不再居首位， 因为你放纵情欲， 如沸腾不止的水， 你上了你父亲的床， 玷污了我的榻。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“西缅和利未是兄弟， 他们依仗刀剑，残暴不仁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","我的灵不可与他们同谋。 我的心不可与他们联合。 他们泄愤杀人， 随意砍断牛腿的筋。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","他们狂怒凶残，该受咒诅！ 我要使他们分散在雅各的子孙中， 散居在以色列各地。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“犹大啊，你的兄弟们必赞美你， 你的手必掐住仇敌的颈项， 你父亲的儿子必向你下拜。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","我儿犹大是头小狮子， 他猎食回来，躺卧如雄狮， 蹲伏如母狮，谁敢惊扰他？ ");
INSERT INTO cmncbs_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","权杖必不离犹大， 御杖必伴他左右， 直到执掌王权的那位来到， 万民都必归顺他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","“他把小驴拴在葡萄树旁， 把驴驹拴在上好的葡萄树旁； 他在葡萄酒中洗衣服， 在葡萄汁中洗外袍。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","他的眼睛比酒乌润， 他的牙齿比奶洁白。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“西布伦必安居在海滨， 成为泊船的港口， 他的疆界必伸展到西顿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“以萨迦是头壮驴， 卧在羊圈中。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","他见那地方好作安身之处， 地土肥美，就垂下肩头， 做了苦役。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“但必治理他的人民， 作以色列的一个支派。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","他必成为路边的蛇， 道旁的毒蛇， 咬伤马蹄，使骑马的人坠落。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“耶和华啊， 我切切等候你的拯救。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“迦得必被强盗劫掠， 他却要反败为胜追赶他们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“亚设必有丰美的出产和供君王享用的美味。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“拿弗他利是头自由的母鹿， 养育美丽的小鹿。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“约瑟是多结果子的枝条， 长在水泉旁， 他的枝条探出墙外。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","弓箭手凶猛地攻击他， 恶狠狠地射他。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","但他手持强弓， 双臂稳健有力， 因为雅各的大能者出手相助， 祂是以色列的牧者和磐石。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","你父亲的上帝必帮助你， 全能者必赐你天上的福气、 地下深渊蕴藏的福气， 使你子孙兴旺、牛羊满圈。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","你父亲的祝福高过亘古的峰峦， 多如永存的群山， 愿这一切祝福都临到约瑟头上， 临到这超越众弟兄的人身上。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“便雅悯是匹贪婪的狼， 早晨吞吃猎物， 晚上瓜分战利品。” ");
INSERT INTO cmncbs_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","以上是以色列的十二支派，他们的父亲按着他们不同的福分给他们祝福。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","雅各又嘱咐他们说：“我要离世了，你们要把我葬在赫人以弗仑田间的洞里，让我与祖先在一起。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","那洞穴在迦南的幔利附近的麦比拉田间，是亚伯拉罕向赫人以弗仑买来作坟地的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","亚伯拉罕和他的妻子撒拉，以撒和他的妻子利百加都葬在那里，我把利亚也葬在了那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","那块田和田间的洞穴是向赫人买的。” ");
INSERT INTO cmncbs_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","雅各嘱咐完众子，把脚收到床上，咽了气，归到他祖先那里。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","约瑟伏在父亲身上痛哭，亲吻他， ");
INSERT INTO cmncbs_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","然后吩咐医生用香料保存父亲的遗体。医生遵命而行， ");
INSERT INTO cmncbs_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","按照常例花了四十天用香料处理遗体。埃及人为他哀悼七十天。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","哀悼的日子完了，约瑟对法老宫中的人说：“如果你们恩待我， ");
INSERT INTO cmncbs_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","请告诉法老，我父亲死前要我起誓把他葬在迦南他自己预备好的坟地。请准许我到迦南去安葬我父亲，我办完丧事就回来。” ");
INSERT INTO cmncbs_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","法老说：“去按照你的誓言埋葬你父亲吧。” ");
INSERT INTO cmncbs_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","于是，约瑟启程去埋葬他的父亲，随行的有法老所有的臣仆和埃及所有的达官显贵， ");
INSERT INTO cmncbs_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","以及约瑟全家、他的众弟兄和雅各的家眷，只有他们的孩子和牛羊仍然留在歌珊。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","随行的还有大队车辆和骑兵，人数众多。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","他们来到约旦河附近的亚达麦场，在那里痛哭哀悼。约瑟为父亲哭丧七天。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","迦南人看见他们在亚达麦场痛哭，就说：“埃及人在痛哭哀悼。”因此，约旦河附近的那个地方叫亚伯·麦西。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","雅各的儿子们遵照父亲的遗言， ");
INSERT INTO cmncbs_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","把父亲的遗体带回迦南，安葬在幔利附近、麦比拉田间的洞里。洞和田地都是亚伯拉罕向赫人以弗仑买来作坟地的。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","葬礼之后，约瑟就跟众弟兄和一切随行的人返回埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","约瑟的哥哥们见父亲死了，就说：“约瑟会不会怀恨在心，因我们以前恶待他而报复我们呢？” ");
INSERT INTO cmncbs_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","于是，他们派人去对约瑟说：“你父亲临终时交待这样的话给你， ");
INSERT INTO cmncbs_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘从前你哥哥们恶待你，求你饶恕他们的罪恶和过犯。’我们是你父亲的上帝的仆人，求你饶恕我们的罪恶。”约瑟听见这些话，就哭了。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","约瑟的哥哥们来见他，俯伏在他面前，说：“我们是你的奴仆。” ");
INSERT INTO cmncbs_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","约瑟对他们说：“你们不要害怕，我岂能代替上帝？ ");
INSERT INTO cmncbs_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","从前你们是要加害于我，但上帝有祂的美意，祂借此保全许多人的性命，正如今日的光景。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","因此，你们不要害怕，我会照顾你们和你们的儿女。”约瑟好言好语地宽慰他们。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","约瑟和他父亲全家住在埃及。约瑟享年一百一十岁。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","他看到了以法莲的孙子，也曾把玛拿西的儿子玛吉刚出生的孩子抱在膝上。 ");
INSERT INTO cmncbs_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","一天，约瑟对他的弟兄们说：“我快要死了，但上帝必看顾你们，带你们离开这里，回到祂起誓应许给亚伯拉罕、以撒和雅各的地方。” ");
INSERT INTO cmncbs_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","约瑟让以色列的子孙起了誓，并说：“上帝必看顾你们，你们要把我的骸骨带回迦南。” ");
INSERT INTO cmncbs_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","约瑟享年一百一十岁。他们把他的遗体用香料保存好，放在棺材里，停放在埃及。");
INSERT INTO cmncbs_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","以色列的众子带着家眷跟雅各一起去了埃及，以下是他们的名字： ");
INSERT INTO cmncbs_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","吕便、西缅、利未、犹大、 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","以萨迦、西布伦、便雅悯、 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","但、拿弗他利、迦得、亚设。 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","雅各的子孙总共有七十人。那时，约瑟已经住在埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","后来，约瑟和他的弟兄以及同辈的人都相继去世。 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","以色列人生养众多，人口大增，很快就遍布埃及，成为一个强大的民族。 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","后来，埃及有一位不认识约瑟的新王登基， ");
INSERT INTO cmncbs_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","对他的百姓说：“你们看，以色列人比我们多，又比我们强。 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","来吧！我们要设法阻止他们人口增多，否则一遇到战争，他们便会加入我们敌人的阵营来攻打我们，然后一走了之。” ");
INSERT INTO cmncbs_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","于是，埃及人派监工强迫以色列人服劳役，在比东和兰塞两地为法老兴建储货城。 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","以色列人越受奴役，人口增长得越快，散居的范围也越广，令埃及人感到恐惧。 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","于是，埃及人残酷地奴役他们， ");
INSERT INTO cmncbs_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","强迫他们和泥造砖，并做田间一切的苦工，使他们痛苦不堪。埃及人残酷地奴役他们做苦工。 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","埃及王又命令两个希伯来的接生婆施弗拉和普阿： ");
INSERT INTO cmncbs_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“你们在替希伯来妇女接生的时候，如果看到生下的是男婴，就把他杀掉；如果是女婴，就让她活下来。” ");
INSERT INTO cmncbs_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","但这两个接生婆敬畏上帝，没有执行埃及王的命令，而是保留了男婴的性命。 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","埃及王召见那两个接生婆，质问她们：“你们为什么这样做？为什么让男婴活着？” ");
INSERT INTO cmncbs_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","她们回答说：“因为希伯来妇女跟埃及妇女不同。她们身体强壮，我们还没有赶到，婴儿就生下来了。” ");
INSERT INTO cmncbs_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","因此，以色列人口继续增加，更加繁盛。因为这两个接生婆敬畏上帝，上帝便赐福给她们，使她们生儿育女。 ");
INSERT INTO cmncbs_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","后来，法老命令全埃及的人把以色列人生的所有男婴都抛进尼罗河里，只让女婴活着。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","有一个利未族的人跟他同族的女子结婚。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","那女子怀孕，生了一个男婴。她看见孩子可爱，就把他藏了三个月。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","后来无法再藏下去，她就拿来一个蒲草篮子，外面涂上防水的沥青和柏油，然后把婴儿放在里面，又把篮子放在尼罗河边的芦苇丛中。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","婴儿的姐姐远远地站着，要看看她的弟弟究竟会怎样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","这时，法老的女儿来到河边沐浴，宫女们在河边行走。公主发现了芦苇丛中的篮子，便吩咐一个婢女去把它取来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","公主打开一看，原来是一个男婴。公主看见孩子在哭，就可怜他，说：“他是希伯来人的孩子。” ");
INSERT INTO cmncbs_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","婴儿的姐姐对公主说：“我去找一个希伯来妇女当奶妈，为你哺养他好吗？” ");
INSERT INTO cmncbs_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","公主回答说：“好！”那女孩就跑去把婴孩的母亲带来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","公主对那妇女说：“你把孩子抱去，替我哺养他，我会给你工钱。”她便把孩子抱去哺养。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","孩子渐渐长大，她便把他带到公主那里，孩子就做了公主的儿子。公主给孩子取名叫摩西，意思是“我把他从水中拉了上来”。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","后来，摩西长大了，他去看望做苦工的希伯来同胞，看见一个埃及人在殴打他的一个希伯来同胞。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","他左右观望，见四下无人，便下手杀了那埃及人，把尸体埋藏在沙地里。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","第二天，他又出去，看见两个希伯来人在打架，便过去对理亏的人说：“你为什么打自己的同胞呢？” ");
INSERT INTO cmncbs_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","那人说：“谁立你做我们的首领和审判官？难道你要杀我，像杀那个埃及人一样吗？”摩西听了，害怕起来，心想：“我做的事一定被人知道了。” ");
INSERT INTO cmncbs_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","法老听说这件事后，便想杀死摩西。摩西为了躲避法老，就逃到米甸居住。一天他坐在一口井旁， ");
INSERT INTO cmncbs_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","米甸祭司的七个女儿来打水，要把水倒进槽里饮她们父亲的羊。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","这时，来了另外一群牧人要把她们赶走。摩西便起来帮助她们，打水饮她们的羊群。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","她们回到父亲流珥那里，父亲问道：“你们今天怎么这么快就回来了？” ");
INSERT INTO cmncbs_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","她们答道：“有一个埃及人救我们免遭牧人的欺负，还帮我们打水饮羊群。” ");
INSERT INTO cmncbs_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","他又问女儿们：“现在那人在哪里？你们怎么可以丢下他不管呢？去请他来吃点东西。” ");
INSERT INTO cmncbs_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","后来，摩西同意住在那人家里。那人把女儿西坡拉许配给他。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","后来，西坡拉生了一个儿子，摩西给他取名叫革舜，意思是“我成了在异乡寄居的人”。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","过了多年，埃及王死了。以色列人受尽奴役，就哀叹呼求，声音传到上帝那里。 ");
INSERT INTO cmncbs_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","上帝听见他们的哀声，顾念从前跟亚伯拉罕、以撒、雅各所立的约， ");
INSERT INTO cmncbs_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","就垂顾他们，体恤他们。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","摩西为岳父米甸祭司叶特罗放羊。一天他领着羊群穿越旷野，来到上帝的山——何烈山。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","忽然有耶和华的天使在荆棘的火焰中向他显现。摩西看见荆棘虽然在燃烧，却没有被烧毁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","摩西想：“我要过去看这个奇异的景象，荆棘为什么没有被烧掉呢？” ");
INSERT INTO cmncbs_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","耶和华上帝见他要上前观看，就从荆棘丛中呼唤他说：“摩西！摩西！”摩西说：“我在这里。” ");
INSERT INTO cmncbs_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","上帝说：“别再靠近，脱下你脚上的鞋，因为你所站的地方是圣地。” ");
INSERT INTO cmncbs_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","又说：“我是你祖先的上帝，是亚伯拉罕的上帝，以撒的上帝，雅各的上帝。”摩西害怕看上帝，就把脸蒙起来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","耶和华说：“我已经看见我子民在埃及所受的苦难，听见了他们因监工的压迫而发出的呼求。我知道他们的痛苦。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","我下来是要从埃及人手中救他们，带他们离开那里，到一个辽阔肥沃的奶蜜之乡，就是现在迦南人、赫人、亚摩利人、比利洗人、希未人和耶布斯人居住的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","现在，以色列人的呼求传到我耳中，我也看到了埃及人怎样压迫他们。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","现在去吧，我要派你到法老那里，带我的以色列子民出埃及。” ");
INSERT INTO cmncbs_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","但摩西对上帝说：“我是谁啊？怎么能去见法老，带以色列人出埃及呢？” ");
INSERT INTO cmncbs_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","上帝说：“我必与你同在，你带百姓出埃及后，你们必在这座山上事奉我——这将是我派你去的证据。” ");
INSERT INTO cmncbs_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","摩西问上帝：“假如我到以色列人那里，对他们说，‘你们祖先的上帝派我来你们这里。’他们如果问我，‘祂叫什么名字？’我该怎样回答他们呢？” ");
INSERT INTO cmncbs_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","上帝对摩西说：“我是自有永有者。你要这样回答以色列人，‘那位自有永有者派我到你们这里。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","上帝又对摩西说：“你要告诉以色列人是我派遣你到他们那里，我是他们祖先的上帝耶和华，是亚伯拉罕的上帝，以撒的上帝，雅各的上帝。耶和华是我的名字，直到永远，世世代代的人都要这样称呼我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","你去招聚以色列的长老，对他们说，‘你们祖先的上帝耶和华，就是亚伯拉罕、以撒、雅各的上帝向我显现，说祂关切你们，知道你们在埃及的遭遇。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","祂应许要带领你们脱离在埃及所受的苦难，到迦南人、赫人、亚摩利人、比利洗人，希未人和耶布斯人住的地方，那里是奶蜜之乡。’ ");
INSERT INTO cmncbs_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","以色列的长老们必定听从你的话，你就跟他们一起去见埃及王，对他说，‘希伯来人的上帝耶和华向我们显现。现在请你容许我们走三天的路程，到旷野去，向我们的上帝耶和华献祭。’ ");
INSERT INTO cmncbs_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","我也知道除非我用大能的手向他施压，不然埃及王不会让你们离开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","因此，我必伸手行各种神迹攻击埃及，之后他必让你们离开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","我必使埃及人恩待你们，好叫你们不致空手离开埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","你们的妇女只管向埃及邻居及住在邻居家的妇女索取金器、银器和衣服，给自己的儿女穿戴，你们必这样夺取埃及人的财物。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","摩西回答说：“他们不会相信我，也不会听我的话，他们会说，‘耶和华根本没有向你显现。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","耶和华对摩西说：“你手里拿的是什么？”摩西说：“是一根手杖。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","耶和华说：“把它扔在地上！”于是，摩西把杖扔在地上，杖变成了一条蛇。摩西连忙跑开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","耶和华说：“你伸手抓住它的尾巴！”摩西就伸手抓蛇的尾巴，蛇在他手中变回了杖。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","耶和华说：“这样，他们就会相信他们祖先的上帝耶和华，就是亚伯拉罕、以撒和雅各的上帝，曾经向你显现。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","耶和华又说：“把手放进怀里。”摩西把手放进怀里，手抽出来的时候，竟患了麻风病，像雪一样白。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","耶和华说：“再把手放进怀里。”摩西又把手放进怀里，这次再抽出来的时候，手已经复原，跟其他地方的皮肉一样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","耶和华说：“纵然他们不听你的话，不信第一个神迹，也必定相信第二个神迹。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","如果他们两个神迹都不相信，还是不听你的话，你就从尼罗河里取些水来倒在旱地上，那水就会在旱地上变成血。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","摩西对耶和华说：“主啊！我向来不善言辞，即使你对仆人说话以后，我还是不善言辞，因为我是个拙口笨舌的人。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","耶和华对他说：“是谁造人的口舌？是谁使人哑巴或耳聋？是谁使人目明或眼瞎？岂不都是我耶和华吗？ ");
INSERT INTO cmncbs_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","去吧！我必赐给你口才，指示你说什么话。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","但是摩西说：“主啊，请派其他人去吧。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","耶和华向摩西发怒说：“利未人亚伦不是你哥哥吗？我知道他是个能言善辩的人，正要来迎接你。他见到你一定很欢喜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","你要把该说的话传给他，我会赐你们口才，教你们如何行事。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","他要替你向百姓说话，做你的发言人，你对他来说就像上帝一样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","你要把手杖带在身边，以便行神迹。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","摩西回到家里，对他的岳父叶特罗说：“求你让我回埃及去探望我的亲人，看看他们是否在世。”叶特罗说：“你平安地去吧。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","耶和华在米甸对摩西说：“你只管放心回埃及去，想害你性命的人都已经死了。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","于是，摩西拿着上帝的杖，带着妻子和儿子骑驴返回埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","耶和华对摩西说：“你到了埃及，务要照我赐给你的能力在法老面前行神迹。但我要使他的心刚硬，他必不让百姓离开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","那时，你就告诉法老，‘耶和华说，以色列是我的长子， ");
INSERT INTO cmncbs_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","我对你说过让我的长子出去事奉我，但你执意不肯。看啊，我要杀你的长子。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","摩西在途中夜宿的时候，耶和华遇见摩西，想要杀他。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","他的妻子西坡拉拿起锋利的火石，割下儿子的包皮，用它碰摩西的脚，说：“你真是我的血郎。” ");
INSERT INTO cmncbs_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","这样，耶和华才放过他。当时，西坡拉说“血郎”是指割礼一事。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","耶和华对亚伦说：“你到旷野去迎接摩西。”他就在上帝的山上遇见摩西，并亲吻他。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","摩西把耶和华吩咐他的以及要他行的神迹都告诉了亚伦。 ");
INSERT INTO cmncbs_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","摩西和亚伦一起回去招聚以色列的众长老， ");
INSERT INTO cmncbs_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","亚伦把耶和华对摩西的吩咐详细地告诉他们。摩西又在百姓面前行了那些神迹， ");
INSERT INTO cmncbs_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","百姓相信了。以色列人听见耶和华眷顾他们、看到了他们的苦难，都俯伏敬拜祂。 ");
INSERT INTO cmncbs_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","之后，摩西和亚伦去见法老，对他说：“以色列的上帝耶和华说，‘放我的子民走，让他们到旷野去为我守节期。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","法老说：“耶和华是谁？我凭什么要听从祂，放走以色列人？我不认识祂，也不会让以色列人离开！” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","摩西和亚伦说：“希伯来人的上帝向我们显现了。求你容我们走三天的路程，到旷野去向我们的上帝耶和华献祭，免得祂用瘟疫或刀剑来攻击我们。” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","埃及王说：“摩西、亚伦，你们为什么让百姓停工！快回去服劳役！” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","法老又说：“这地方的以色列人如此多，你竟叫他们停工！” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","当天，法老就对埃及监工和以色列人的工头下令： ");
INSERT INTO cmncbs_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“不许再供应草给他们制砖，叫他们自己去捡， ");
INSERT INTO cmncbs_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","但上交的砖的数量要和往常一样，一块也不可少。因为他们懒惰，所以才嚷着要去给他们的上帝献祭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","你们要加重他们的工作，他们就无暇再听那些蛊惑人心的话了！” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","于是，那些监工和工头就出来向百姓宣布：“法老下令不再供应草给你们制砖。 ");
INSERT INTO cmncbs_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","你们要自己设法去找，但上交的砖一块也不能少。” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","百姓只好在埃及各地收集禾秸当草用。 ");
INSERT INTO cmncbs_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","监工催逼他们说：“你们要完成每天规定的数目，像从前有草时一样。” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","法老的监工又鞭打他们委派的以色列工头，说：“你们这两天为什么没有像从前一样完成规定的砖数？” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","以色列人的工头来见法老，向他哀求说：“你为什么要这样对待仆人们？ ");
INSERT INTO cmncbs_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","监工不给仆人们草，却命令我们制作砖，还打我们，其实是你百姓的错。” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","法老说：“你们是懒汉，懒汉！所以才嚷着要去给耶和华献祭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","回去继续做工！我不再供应草给你们，但砖要如数交齐。” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","以色列人的工头听见每天做的砖数不可减少，就知道情况不妙。 ");
INSERT INTO cmncbs_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","他们从法老那里出来的时候，遇见摩西和亚伦站在外面等候， ");
INSERT INTO cmncbs_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","便埋怨二人说：“愿耶和华鉴察、惩罚你们！你们使我们在法老和他的臣仆面前有了臭名，无异于把刀递到他们手中来杀我们。” ");
INSERT INTO cmncbs_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","摩西回到耶和华那里说：“主啊！你为什么这样苦待你的子民呢？为什么要派我去呢？ ");
INSERT INTO cmncbs_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","自从我去法老那里奉你的名说话后，他更加虐待你的子民，你却根本没有拯救他们。” ");
INSERT INTO cmncbs_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","耶和华对摩西说：“你就要看见我怎样用大能的手对付法老，那时他会让以色列人走，甚至把他们赶出他的国土！” ");
INSERT INTO cmncbs_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","上帝又对摩西说：“我是耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","我曾以全能上帝的身份向亚伯拉罕、以撒和雅各显现，但没有让他们知道我的名字是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","我坚守与他们所立的约，要把他们寄居的迦南赐给他们。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","我已听见以色列人因受埃及人的奴役而发出的哀声，也顾念我的约。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","所以，你要转告以色列人说，‘我是耶和华。我要解救你们脱离埃及人的辖制，脱离他们的奴役，我要伸出臂膀大行审判，以救赎你们。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","我要接纳你们做我的子民，我要做你们的上帝。这样，你们就知道我是你们的上帝耶和华，曾救你们脱离埃及人的辖制。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","我必带领你们进入我举手起誓要给亚伯拉罕、以撒和雅各的那片土地，把它赐给你们作产业。我是耶和华。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","摩西把这番话转告百姓，可是他们因为残酷的劳役无比沮丧，不肯听他的话。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“你去告诉埃及王法老，让以色列人离开他的土地。” ");
INSERT INTO cmncbs_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","摩西却说：“以色列人都不听我的话，法老又怎么肯听我这拙口笨舌的人呢？” ");
INSERT INTO cmncbs_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","耶和华吩咐摩西和亚伦回到以色列人和法老那里，要他们领以色列人离开埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","以下是以色列各家族的族长： 以色列长子吕便的儿子是哈诺、法路、希斯伦和迦米。这些是吕便的宗族。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","西缅的儿子是耶姆利、雅悯、阿辖、雅斤、琐辖和扫罗，扫罗的母亲是迦南人。这些是西缅的各宗族。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","按照家谱的记载，利未的儿子是革顺、哥辖和米拉利，利未享年一百三十七岁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","革顺的儿子是立尼和示每，二人各成宗族。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","哥辖的儿子是暗兰、以斯哈、希伯仑和乌薛，哥辖享年一百三十三岁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","米拉利的儿子是抹利和姆示。这些按家谱的记载是利未的各宗族。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","暗兰娶了他父亲的妹妹约基别，生了亚伦和摩西，暗兰享年一百三十七岁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","以斯哈的儿子是可拉、尼斐和细基利。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","乌薛的儿子是米沙利、以利撒反和西提利。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","亚伦娶了亚米拿达的女儿、拿顺的妹妹以利沙巴，她生了拿答、亚比户、以利亚撒和以他玛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","可拉的儿子是亚惜、以利加拿和亚比亚撒，这些是可拉的各宗族。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","亚伦的儿子以利亚撒与普铁的一个女儿结婚，生了非尼哈。以上是利未各宗族的族长。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","正是亚伦和摩西受耶和华之命，要按以色列人的队伍把他们带出埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","也是摩西和亚伦要求埃及王法老让他们把以色列人带出埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","那时，耶和华曾经在埃及对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“我是耶和华，你要把我吩咐你的一切话告诉埃及王法老。” ");
INSERT INTO cmncbs_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","摩西却对耶和华说：“你看，我拙口笨舌，法老怎肯听我的话？” ");
INSERT INTO cmncbs_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","耶和华对摩西说：“我要使你在法老面前像上帝一样，你哥哥亚伦是你的发言人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","你要传达我吩咐你的一切话，你哥哥亚伦要求法老让以色列人离开他的国家。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","可是，我要使法老的心刚硬，虽然我在埃及行许多神迹奇事， ");
INSERT INTO cmncbs_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","他仍无动于衷。那时，我必伸手重重地惩罚埃及，然后领我大队的以色列子民离开埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","我伸手攻击他们，把以色列人带出埃及之时，埃及人就会知道我是耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","摩西和亚伦便遵命而行。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","他们去见法老的时候，摩西八十岁，亚伦八十三岁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“倘若法老要你们行神迹给他看，你就吩咐亚伦把手杖扔在法老面前，使杖变作蛇。” ");
INSERT INTO cmncbs_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","摩西和亚伦照耶和华的吩咐来到法老面前。亚伦把手杖扔在法老和他的臣仆面前，杖就变作蛇。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","法老召智者和巫师前来，这些人是埃及的术士，他们也用邪术如法炮制。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","各人将自己的手杖扔在地上，杖就变作蛇，但亚伦的杖吞噬了他们的杖。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","法老却仍然硬着心，不肯听从摩西和亚伦，正如耶和华所言。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","耶和华对摩西说：“法老非常顽固，不肯放百姓走。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","明天早晨，法老会去尼罗河边，你去河边见他，要拿着曾变成蛇的手杖。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","你要对他说，‘希伯来人的上帝耶和华差遣我来告诉你，要让祂的子民到旷野去事奉祂，但到如今你还是不肯。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","所以祂说要用手杖击打尼罗河水，使河水变成血，好叫你知道祂是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","河里的鱼会死，河水会发臭，埃及人不能再喝尼罗河的水。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","耶和华对摩西说：“你告诉亚伦，让他向埃及境内的各江河、溪流、池塘伸杖，使水变成血。埃及境内，包括木头和石头器皿中将到处是血。” ");
INSERT INTO cmncbs_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","摩西和亚伦就按着耶和华所吩咐的去做，亚伦在法老和他的众臣仆面前举杖击打尼罗河水，河水都变成了血。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","河里的鱼都死了，河水臭得不能饮用。埃及遍地都是血。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","可是，埃及的巫师用邪术同样使水变成血。法老仍然硬着心，不肯听从摩西和亚伦的话，正如耶和华所言。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","法老若无其事地转身回宫去了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","因为河水不能饮用，埃及人就在尼罗河两岸掘井取水饮用。 ");
INSERT INTO cmncbs_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","耶和华击打河水后，七天过去了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","耶和华对摩西说：“你去告诉法老，‘耶和华说，放我的子民离开，他们好事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","如果你不肯让他们去，我就使青蛙来毁坏你的全境。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","尼罗河将充满青蛙，它们要跳到你的宫里、卧室和床铺上，跳到你的臣仆和百姓家里，跳到你的炉灶和揉面盆里。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","青蛙还会跳到你和你的百姓及众臣仆身上。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","耶和华对摩西说：“你叫亚伦向埃及各地的江河、溪流和池塘伸杖，使青蛙遍布埃及。” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","亚伦就向水伸杖，青蛙就遍布了埃及全境。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","巫师也行邪术如法炮制，使青蛙遍布埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","法老召摩西和亚伦进宫，对他们说：“你们要祈求耶和华，使这些青蛙离开我和我的百姓，我便让你们的百姓去献祭给耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","摩西对法老说：“好吧，你要我在什么时候为你以及你的臣仆和百姓祷告，叫这些青蛙离开你和你的宫殿，只留在河里呢？” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","法老说：“明天。”摩西说：“就照你说的，这样你就知道我们的上帝耶和华独一无二。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","青蛙会离开你、你的宫殿、你的臣仆和百姓，只留在河里。” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","摩西和亚伦离开法老后，摩西就为法老所受的蛙灾一事向耶和华呼求。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","耶和华答应了摩西的祈求。在房屋内、院子里和田野中的青蛙都死了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","百姓把青蛙的尸体堆积起来，埃及全境都充满了死青蛙的腐臭气味。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","法老看见灾难缓解，便又硬着心，不肯听从摩西和亚伦的话，正如耶和华所言。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","耶和华对摩西说：“你吩咐亚伦伸出他的杖击打地上的尘土，使埃及境内的尘土变成虱子。” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","他们就照上帝的吩咐去做，亚伦伸杖击打地上的尘土，虱子就跑到人和牲畜身上，全埃及的尘土都变成了虱子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","巫师们也试图用邪术变出虱子来，却无法成功。埃及的百姓和牲畜身上长满了虱子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","巫师们对法老说：“这是上帝的作为。”法老仍然硬着心，不肯答应摩西和亚伦的要求，正如耶和华所言。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","耶和华对摩西说：“明天清早，你趁法老去河边时去见他，告诉他，‘耶和华说，放我的子民走，他们好事奉我， ");
INSERT INTO cmncbs_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","不然我就叫成群的苍蝇飞到你、你的臣仆和百姓身上，进到你们各自的家中，使埃及遍地布满苍蝇。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","但那天，我必把我子民居住的歌珊分别出来，那里必没有成群的苍蝇，这样你就知道我耶和华主宰天下。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","我要把我的子民跟你的百姓分开，明天我必行这神迹。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","耶和华果然这样行。密密麻麻的苍蝇飞进法老的王宫和他臣仆的家里，埃及全国都受到苍蝇的毁坏。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","法老召见摩西和亚伦，对他们说：“去吧，就在此地给你们的上帝献祭吧。” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","摩西说：“这怎么行？我们献给我们的上帝耶和华的祭物会令埃及人厌恶。如果我们在埃及人面前献令他们厌恶的祭物，他们岂不会拿石头打死我们？ ");
INSERT INTO cmncbs_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","我们要照我们上帝耶和华的吩咐离开这里，走三天的路程到旷野去献祭给祂。” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","法老说：“我让你们去旷野献祭给你们的上帝耶和华，只是不要走得太远。你们要为我祈求。” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","摩西说：“我离开这里就去祈求耶和华，使成群的苍蝇明天就离开你及你的臣仆和百姓，但这次你不可再食言，阻止以色列人去向耶和华献祭。” ");
INSERT INTO cmncbs_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","摩西说完以后，便离开王宫，去祈求耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","耶和华就照摩西的祈求，使成群的苍蝇离开法老及其臣仆和百姓，一只也没有留下。 ");
INSERT INTO cmncbs_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","这一次，法老又硬着心，不肯让百姓离开埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","耶和华对摩西说：“你去见法老，告诉他，‘希伯来人的上帝耶和华说：放我的子民走，他们好事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","如果你不让他们走，继续扣留他们， ");
INSERT INTO cmncbs_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","我必出手使你田间所有的牲畜，包括马、驴、骆驼和牛羊，都染上严重的瘟疫。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","但我要把埃及和以色列的牲畜分开，以色列人的牲畜必丝毫无损。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","耶和华定了日期，说：“明天耶和华必在此地行这事。” ");
INSERT INTO cmncbs_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","第二天，耶和华就行了这事，埃及人的牲畜都死了，但以色列人的牲畜一头也没死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","法老派人去探查，发现以色列人的牲畜一头也没死。可是，他仍然心里顽固，不肯让以色列人离开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","耶和华对摩西和亚伦说：“你们去取几把窑里的灰，摩西要在法老面前把灰抛向空中。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","这灰要变成尘土，散布在埃及全境，落在人或牲畜身上，就会起疱长疮。” ");
INSERT INTO cmncbs_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","摩西和亚伦便取了一些窑里的灰，站在法老面前，摩西把灰抛向空中，埃及人和牲畜身上就开始起疱长疮。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","埃及的巫师无法与摩西对抗，因为他们及所有埃及人身上都长了脓疮。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","耶和华使法老的心刚硬，他就不听他们的话，正如耶和华对摩西说的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","耶和华对摩西说：“明天一早你再去见法老，对他说，‘希伯来人的上帝耶和华这样说，你要放我的子民走，他们好事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","这一次，我要降下大灾祸在你及你的臣仆和百姓身上，好叫你知道普天之下我独一无二。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","我若用瘟疫攻击你和你的百姓，你们早就灭亡了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","我让你活到现在，是为了向你彰显我的权能，使我的名传遍天下。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","但你竟然在我的子民面前狂傲自大，不让他们离开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","明天大约这时候，我要使天上降下大冰雹，是你们埃及立国以来从没有见过的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","现在，你要叫人到田间把牲畜和属于你的一切都带到安全的地方。凡留在田间的人或牲畜都会被冰雹打死。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","有些法老的臣仆听了耶和华的话就很害怕，赶忙把在田间的仆人和牲畜都召回屋里。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","但那些不把耶和华的话放在心上的，仍把他们的奴仆和牲畜留在田间。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","耶和华对摩西说：“你向天伸杖，天就会降下冰雹，落在埃及的一切人畜身上，摧毁田间的一切农作物。” ");
INSERT INTO cmncbs_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","摩西向天伸出手杖，耶和华就发出雷电和冰雹，火光飞向大地。耶和华在埃及降下冰雹。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","那时冰雹夹杂着火降下来，极为严重，在埃及史无前例。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","冰雹摧毁了埃及境内田间的一切人、牲畜和作物，打断了所有的树木， ");
INSERT INTO cmncbs_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","只有以色列人所住的歌珊没有冰雹。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","法老派人召来摩西和亚伦，对他们说：“这次我犯罪了，耶和华是对的，我和我的百姓错了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","请你们向耶和华祈求，我们已经受够了雷电和冰雹。我准许以色列人出去，你们不必再留在这里了。” ");
INSERT INTO cmncbs_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","摩西回答说：“我一出城，就向耶和华举手祷告，雷电和冰雹必立刻停止，这样你就知道普天下都属于耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","但我知道你和你的臣仆还是不敬畏上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","这场冰雹打坏了大麦和亚麻，因为正是大麦吐穗和亚麻开花的时候。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","小麦和粗麦尚未长成，没有被冰雹打坏。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","摩西离开法老，走出城外向耶和华举手祷告，雷和冰雹便停了，雨也不下了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","法老看见雨、雷和冰雹停止了，就又犯罪，他和他的臣仆都心里顽固。 ");
INSERT INTO cmncbs_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","法老硬着心，不让以色列人离开，正如耶和华借摩西所言。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","耶和华对摩西说：“你去见法老，我已使他和他臣仆的心刚硬，好在他们当中行我这些神迹。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","这样，你就可以把我如何严惩埃及人以及我在他们当中所行的神迹告诉你的子孙，好叫你们知道我是耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","摩西和亚伦便去见法老，对他说：“希伯来人的上帝耶和华说，‘你要到什么时候才肯在我面前谦卑下来？放我的子民走，他们好事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","你若再不答应，明天我要使蝗虫飞入你的国境。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","它们铺天盖地，要吃光冰雹过后田间所剩的，包括一切树木。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","你的王宫及臣仆和所有埃及人的房屋都要布满蝗虫，这是你祖祖辈辈从未见过的蝗灾。’”摩西说完，便转身离开法老。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","臣仆对法老说：“这个人害我们要到什么时候呢？让他们离开去事奉他们的上帝耶和华吧！埃及快被毁灭了，你不知道吗？” ");
INSERT INTO cmncbs_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","法老便召回摩西和亚伦，对他们说：“你们去事奉你们的上帝耶和华吧！但你们谁要去呢？” ");
INSERT INTO cmncbs_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","摩西回答说：“我们男女老幼都要去，还有我们的牛群和羊群，因为我们要去守耶和华的节期。” ");
INSERT INTO cmncbs_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","法老听后，说：“我若让你们带走妇女和孩子，最好耶和华能保护你们！你们真是居心叵测。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","不行！只有男子可以去事奉耶和华，这是你们一直要求的。”法老说完，便下令把他们赶出去。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","耶和华对摩西说：“你向埃及伸杖，使蝗虫飞来吃尽冰雹过后田野剩下的一切植物。” ");
INSERT INTO cmncbs_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","摩西就向埃及伸杖。耶和华使东风在埃及境内刮了整整一天一夜，到早晨，东风带来了蝗虫。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","埃及到处都布满了蝗虫，数目之多实在是空前绝后。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","蝗虫遍布整个埃及，地上一片黑暗。这些蝗虫吃尽了冰雹过后剩下的农作物和树上的果子，没有留下一点青绿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","法老急忙召见摩西和亚伦，对他们说：“我得罪了你们的上帝耶和华，又得罪了你们。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","现在求你饶恕我的罪，就这一次，为我祈求你们的上帝耶和华撤去这场死亡之灾吧！” ");
INSERT INTO cmncbs_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","摩西就离开法老出去祈求耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","耶和华就把风向倒转，变成猛烈的西风，把蝗虫刮走，吹进红海。埃及境内一只蝗虫也没留下。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","可是，耶和华又使法老心硬，他不让以色列人离开埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","耶和华对摩西说：“你向天伸杖，使埃及全境漆黑一片，那黑暗浓得甚至可以摸到。” ");
INSERT INTO cmncbs_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","摩西向天伸杖，埃及全境便漆黑了三天之久。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","埃及人彼此看不见，谁也不敢移动半步。可是，以色列人住的地方却有光。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","法老把摩西召来，对他说：“去事奉耶和华吧，你们的妇女和孩子也可以去，但你们要把牛羊留下。” ");
INSERT INTO cmncbs_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","摩西回答说：“你得允许我们有祭物和燔祭牲献给我们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","我们要带走所有的牲畜，一只蹄子也不留下，因为我们要从其中选一些来献给我们的上帝耶和华。我们抵达目的地前，还不知道把哪些献给祂。” ");
INSERT INTO cmncbs_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","但耶和华使法老的心刚硬，他不肯让以色列百姓离开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","法老对摩西说：“给我退下！不要再让我见到你，因为你再见我面之日必死。” ");
INSERT INTO cmncbs_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","摩西回答说：“你说得好，我必不再见你的面。” ");
INSERT INTO cmncbs_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","耶和华对摩西说：“我给法老和埃及再降下一场灾难，之后他必放你们走，甚至是把你们彻底赶走。 ");
INSERT INTO cmncbs_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","你要告诉以色列人，不论男女，去向邻近的埃及人索取金器银器。” ");
INSERT INTO cmncbs_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","耶和华使埃及人恩待以色列人，法老的臣仆和百姓极其尊重摩西。 ");
INSERT INTO cmncbs_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","摩西说：“耶和华这样说，‘今晚半夜，我要走遍埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","埃及境内，从坐王位的法老的长子到推磨女奴的长子，以及所有头生的牲畜，都必死亡。 ");
INSERT INTO cmncbs_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","那时整个埃及必充满哭号声，惨况空前绝后。 ");
INSERT INTO cmncbs_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","但在以色列人中，连狗也不会向人或牲畜吠叫，这样你们就知道耶和华把埃及人和以色列人区分开了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","到那时，你所有的臣仆都要来向我下拜，求我和跟随我的百姓离开这里。然后我才会离开。’”摩西说完便怒气冲冲地离开法老。 ");
INSERT INTO cmncbs_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","耶和华曾对摩西说：“法老一定不肯听你的话，因此我要在埃及多行神迹。” ");
INSERT INTO cmncbs_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","摩西和亚伦在法老面前行了这一切神迹，但耶和华使法老的心刚硬，他不让以色列人离开他的国土。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","耶和华在埃及对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“你们要以这个月为一月，为一年之首。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","你要向以色列全体会众宣布，本月的第十日，每家都要预备一只羊羔，一家一只。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","倘若家人太少，吃不了一只，可以跟最近的邻居共享一只，你们要按人数和各人的食量预备羊羔。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","羊羔必须是毫无残疾、一岁的公绵羊或公山羊。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","以色列全体会众要把羊留到本月十四日，在黄昏时分宰杀， ");
INSERT INTO cmncbs_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","然后取点血涂在房子的门框和门楣上，他们要在房子里吃羊肉。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","当晚，你们要用火把羊肉烤熟，与无酵饼和苦菜一起吃。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","不可吃生羊肉，也不可煮着吃，要把整只羊，连头带腿和内脏一并烤着吃。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","不可把肉留到早晨，留到早晨的肉要烧掉。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","你们吃的时候，要束腰、穿鞋、手中拿杖，要赶快吃，这是耶和华的逾越节。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“因为那一夜我要巡遍埃及，把境内所有长子和头生的牲畜全都杀掉，也要严惩埃及所有的神明。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","涂在你们房屋上的血是一个记号，我见到这血就会越过你们。我击打埃及的时候，那灾祸不会落到你们身上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","你们要记住这一天，守为耶和华的节期，作为世代不变的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“七天之内你们都要吃无酵饼。第一天，要清除家中所有的酵。任何人若在这七天当中吃有酵的食物，要将他从以色列人中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","在节期的第一天和第七天，你们都要举行圣会。这两天所有人都不得工作，除了预备各人要吃的以外，不可做任何工。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","你们要守这除酵节，因为我在这天把你们的大军从埃及领了出来。你们要守这节期，作为世代不变的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","从一月十四日傍晚开始，直到二十一日傍晚，你们都要吃无酵饼。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","在这七天内，你们屋里不能有酵。任何人若吃了有酵的东西，不论他是寄居者还是本地人，都要将他从以色列会众中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","无论你们住在哪里都要吃无酵饼，不能吃任何有酵的食物。” ");
INSERT INTO cmncbs_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","于是，摩西召集以色列的众长老，对他们说：“你们家家户户都要挑选羔羊，把这逾越节的羔羊宰了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","拿一把牛膝草蘸盆里的血，把血涂在门楣和两边的门框上。天亮前，你们不可踏出门外。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","因为耶和华要巡行各地，击杀埃及人，祂看见你们的门框和门楣上有血，就必越过你们的家门，不让灭命者进你们家杀人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","这是你们及后代永远当守的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","你们进入耶和华应许给你们的地方以后，要守这逾越节。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","当你们的儿女问你们守这节期的意义时， ");
INSERT INTO cmncbs_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","你们就说，‘这是献给耶和华逾越节的祭，因为我们从前在埃及时，祂击杀埃及人，却越过以色列人所住的房子，救了我们各家。’”百姓听了摩西这番话，都俯伏敬拜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","耶和华怎么吩咐摩西和亚伦，以色列人就照样遵行。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","到了半夜，耶和华把所有埃及人的长子都杀了，包括坐王位的法老的长子、牢中囚犯的长子和一切头生的牲畜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","当晚，法老及其臣仆和所有埃及人都惊醒了，到处都是哭号声，因为没有一家不死人的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","法老连夜召见摩西和亚伦，对他们说：“你们和以色列人起来走吧，离开我的人民。就照你们的要求，去事奉耶和华吧！ ");
INSERT INTO cmncbs_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","照你们的要求，把所有的牛羊都带走吧！也要为我祝福。” ");
INSERT INTO cmncbs_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","埃及人催促以色列人赶快离开埃及，因为他们说：“我们都要死了。” ");
INSERT INTO cmncbs_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","于是，以色列百姓就把没有酵的面团放在揉面盆里，用衣服包起来扛在肩上， ");
INSERT INTO cmncbs_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","又遵照摩西的吩咐向埃及人索取金器、银器和衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","耶和华使埃及人恩待以色列人，他们要什么，埃及人就给什么。这样，以色列人夺取了埃及人的财富。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","以色列百姓从埃及的兰塞启行，前往疏割，妇女孩童不算在内，单是步行的男子就有六十万， ");
INSERT INTO cmncbs_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","同行的还有许多外族人和大群的牛羊。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","他们用从埃及带出来的面团烤成无酵饼，面团没有酵，因为他们被催促离开埃及，没有时间准备食物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","以色列人在埃及共住了四百三十年， ");
INSERT INTO cmncbs_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","正好满了四百三十年的那一天，耶和华带领全军离开了埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","那天晚上是耶和华把祂的子民带出埃及之夜，因此以后世世代代的以色列人都要在那日守夜，以尊崇耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","耶和华对摩西和亚伦说：“以下是逾越节的条例。 “所有外族人都不可吃逾越节的羊羔， ");
INSERT INTO cmncbs_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","但那些买来的奴隶若接受了割礼，就可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","寄居的外族人和雇工不可吃。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","你们吃的时候，应当在房子里吃，不得把肉带到外面去，也不可折断羊羔的一根骨头。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","以色列全体会众都要守这节期。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","跟你们住在一起的外族人如果想为耶和华守逾越节，他全家的男子都必须接受割礼，这样才可以像以色列人一样守逾越节，但没有接受割礼的人绝不可吃逾越节的羊羔。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","本地人和在你们中间寄居的外族人都要遵守这规矩。” ");
INSERT INTO cmncbs_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","耶和华怎样吩咐摩西和亚伦，以色列百姓都遵命而行。 ");
INSERT INTO cmncbs_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","就在那一天，耶和华带领以色列大军离开了埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“要把以色列人中的长子和头生的牲畜分别出来，使之圣洁，归给我。他们都是我的。” ");
INSERT INTO cmncbs_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","摩西对百姓说：“你们要记住离开埃及的这一天，因为耶和华用大能的手把你们从受奴役之地解救出来。不可吃带酵的食物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","你们是在亚笔月的这一天从埃及出来的， ");
INSERT INTO cmncbs_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","将来耶和华带领你们进入迦南人、赫人、亚摩利人、希未人和耶布斯人居住的土地以后，你们每逢此月都要为祂守节期。那是耶和华向你们祖先起誓，应许赐给你们那奶蜜之乡。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","在七天的节期内，你们要吃无酵饼，到了第七天，你们要为耶和华守节期。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","七天之内要吃无酵饼，你们境内不得有酵或是带酵的东西。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","那时，要告诉你们的子孙，‘这节期是纪念我们出埃及时，耶和华为我们所做的一切。’ ");
INSERT INTO cmncbs_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","这节期对你们而言，就像你们手上的记号和额上的提醒，叫你们记得耶和华的律法，祂曾经用大能的手带你们出埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","因此，每一年你们都要按时守这节期。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“耶和华成就祂起誓给你们和你们祖先的应许，领你们进入迦南人的土地，把那里赐给你们以后， ");
INSERT INTO cmncbs_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","你们要把所有长子和头生的公畜归给祂。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","所有头生的公驴必须用羊羔赎回，不然就要打断它们的脖子。要赎回你们所有的长子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","将来你们的子孙问起这件事的意义，你们就回答，‘耶和华曾经用大能的手把我们从受奴役之地埃及带出来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","当时法老硬着心不肯放我们走，所以耶和华就把埃及人的长子和头生的牲畜全都杀了。因此，我们把所有头生的公畜当作祭牲献给耶和华，把所有长子都赎回来。’ ");
INSERT INTO cmncbs_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","这事就像你们手上的记号和额上的标记，以牢记耶和华曾用大能的手带我们出埃及。” ");
INSERT INTO cmncbs_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","法老让以色列人离开埃及后，上帝没有带领他们穿越非利士地区，虽然那是条捷径。因为上帝说：“如果他们遇上战争，就会改变主意，返回埃及。” ");
INSERT INTO cmncbs_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","所以，上帝领他们绕道前行，走旷野的路，前往红海。以色列人离开埃及时都带着兵器。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","摩西把约瑟的骸骨一起带走，因为约瑟曾叫以色列人郑重发誓，对他们说：“上帝必眷顾你们，那时你们要把我的骸骨也一起带走。” ");
INSERT INTO cmncbs_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","以色列人从疏割启程，来到旷野边缘的以倘安营。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","耶和华走在他们前面，白天用云柱为他们指示道路，晚上用火柱照亮他们，这样他们可以日夜赶路。 ");
INSERT INTO cmncbs_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","白天的云柱和晚上的火柱总不从他们前面离开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“你吩咐以色列人改变方向，在比·哈希录附近的海边扎营，在红海和密夺之间，对面是巴力·洗分。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","法老必定以为以色列人走迷了路，被困在旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","我要使法老的心刚硬，使他派兵追赶他们。我要在法老和埃及军兵身上得荣耀，好叫埃及人知道我是耶和华。”于是，以色列人遵命而行。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","有人向埃及王报信，说以色列百姓逃走了。法老和他的臣仆便改变主意，说：“我们怎么可以让以色列人就这样离开我们，不再服侍我们呢？” ");
INSERT INTO cmncbs_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","法老便吩咐人预备战车，他亲自领军， ");
INSERT INTO cmncbs_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","率领埃及所有的战车，包括六百辆最精锐的战车，每辆车上都有战车长。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","耶和华使埃及王法老的心刚硬，法老就追赶毫无惧色地离开埃及的以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","埃及大军的战车骑兵倾巢而出，在巴力·洗分对面、比·哈希录附近的海边追上了安营的以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","法老渐渐逼近，以色列人抬头看见埃及人追了上来，非常害怕，便呼求耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","他们对摩西说：“难道埃及没有坟地，要你带我们出来死在旷野吗？为什么要带我们出埃及呢？ ");
INSERT INTO cmncbs_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","我们在埃及岂不是对你说过，别管我们，就让我们服侍埃及人吗？服侍埃及人总比死在旷野好啊！” ");
INSERT INTO cmncbs_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","摩西对百姓说：“你们不要害怕，站稳了，看耶和华今天怎样解救你们。你们再也看不到你们今天看到的埃及人了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","耶和华必为你们争战，你们要保持安静。” ");
INSERT INTO cmncbs_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","耶和华对摩西说：“为什么向我呼求呢？吩咐以色列人往前走吧。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","你举手向海伸出手杖，把海水分开，以色列人可以从中间的干地走过去。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","我要使埃及人的心刚硬，他们会尾随你们下到海中。我要在法老及其大军、战车和骑兵身上得荣耀。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","当我在法老及其战车和骑兵身上得到荣耀时，埃及人就知道我是耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","这时，在以色列队伍前面领路的上帝的天使，转到百姓后面，云柱也随着移到后面立住。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","云柱停在埃及队伍和以色列队伍的中间，埃及人这边一片黑暗，以色列人那边却有光，彼此整夜都无法接近对方。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","摩西向海伸出手，耶和华便整夜用强劲的东风吹退海水，将海底变成干地。海水分开后， ");
INSERT INTO cmncbs_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","以色列人踏着干地走入海中，海水在他们左右形成水墙。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","法老的军兵车马紧追不舍，都跟着下到海中。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","到了破晓时分，耶和华从云柱火柱中俯视埃及军队，使他们陷入混乱。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","祂使他们战车的轮子脱落，难以前行。于是，埃及人说：“我们逃命吧，因为耶和华在帮助以色列人攻击我们！” ");
INSERT INTO cmncbs_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","耶和华对摩西说：“你向海伸出手，使海水回流，淹没埃及人及其战车和马兵。” ");
INSERT INTO cmncbs_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","天刚亮的时候，摩西向海伸出手，海水便恢复原状。埃及人纷纷向岸上逃命，耶和华却使大水把他们卷回海中。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","海水回流，法老的战车和人马都淹没在大海之中，全军覆没。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","以色列人却在干地上走过红海，海水在他们左右形成水墙。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","那天，耶和华就这样从埃及人手中拯救了以色列人。以色列人看见埃及人的尸体横在海边。 ");
INSERT INTO cmncbs_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","以色列百姓亲眼看见耶和华怎样以大能对付埃及人，他们就敬畏耶和华，又信服祂和祂的仆人摩西。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","那时，摩西和以色列人便歌颂耶和华，说： “我要歌颂耶和华， 因祂大获全胜， 祂把战马和骑兵都抛进海中。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","耶和华是我的力量，我的诗歌， 也成了我的拯救； 祂是我的上帝，我要赞美祂； 祂是我父亲的上帝，我要尊崇祂。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","耶和华是战士， 祂名叫耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","祂把法老的战车军兵都抛进海中， 法老的强将都葬身于红海， ");
INSERT INTO cmncbs_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","大水淹没他们， 他们如同石块沉入深海。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","耶和华啊，你的右手用大能彰显威荣； 耶和华啊，你的右手击碎仇敌。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","你大显威严，击倒那些起来对抗你的人； 你大发雷霆，他们便像枯草遇火， 一烧而尽。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","你的鼻孔一呼气，海水便堆聚起来， 洪涛便堆起水墙，海底深处也都凝固。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","敌人说，‘追啊，追上他们， 瓜分他们的财物，尽情掳掠他们， 拔出刀来把他们斩尽杀绝。’ ");
INSERT INTO cmncbs_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","你叫风一吹，海水就淹没他们， 他们好像铅块一样沉没在怒海中。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","耶和华啊，万神之中，谁能像你？ 谁能像你——威严神圣， 可颂可畏，广行神迹？ ");
INSERT INTO cmncbs_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","你伸出右手，大地便吞灭他们。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","你以不变的爱引领你所救赎的子民， 以大能带他们进入你的圣所。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","各邦听见这些事就发抖， 非利士人痛苦不堪， ");
INSERT INTO cmncbs_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","以东的族长惶恐不安， 摩押的英雄瑟瑟发抖， 迦南的居民胆战心惊。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","惊骇恐惧笼罩着他们。 耶和华啊， 你臂膀的大能吓得他们僵立如石， 直到你的子民都安然走过， 直到你买赎的子民都安然走过。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","耶和华啊， 你要带领他们到你产业的山上安居， 到你为自己所造的住处， 主啊，到你亲手建的圣所。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“耶和华必做王，直到永永远远。” ");
INSERT INTO cmncbs_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","法老的军兵车马追到海中，耶和华使海水回流淹没他们，以色列人却踏着干地走在海中。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","亚伦的姐姐米利暗先知手拿小鼓，带领众妇女击鼓跳舞， ");
INSERT INTO cmncbs_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","唱和道：“要歌颂耶和华，因祂大获全胜，祂把战马和骑兵都抛进海中。” ");
INSERT INTO cmncbs_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","摩西带领以色列人离开红海，来到书珥旷野，走了三天仍然找不到水喝。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","到了玛拉，那里的水却是苦的，不能喝。因此那地方叫玛拉。 ");
INSERT INTO cmncbs_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","百姓就埋怨摩西说：“我们喝什么呢？” ");
INSERT INTO cmncbs_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","摩西向耶和华呼求，耶和华就指示他一棵树，他把树扔在水中，水就变甘甜了。耶和华又在玛拉给百姓定下律例和法令，并在那里试验他们， ");
INSERT INTO cmncbs_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","说：“你们若留心听你们上帝耶和华的话，做我视为正的事，听从我的命令，遵守我的一切律例，我就不把降在埃及的疾病加在你们身上，因为我是医治你们的耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","到了以琳，那里有十二股水泉和七十棵棕树，他们就在水边安营。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","以色列全体会众从以琳出发，来到以琳和西奈中间的汛旷野，时值他们离开埃及后的第二个月的十五日。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","以色列全体会众在旷野向摩西和亚伦发怨言说： ");
INSERT INTO cmncbs_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“我们还不如当初在埃及就死在耶和华手中。在那里，我们至少可以围在肉锅旁吃个饱。现在，你把我们带到旷野来，是要叫全体会众饿死在这里吗？” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","耶和华对摩西说：“我要从天上降下食物给你们。百姓可以每天出去拾取他们当天所需的分量，这样我就可以试验他们是否遵行我的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","到第六天，他们要比平时多拾取一倍的分量。” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","摩西和亚伦对以色列百姓说：“今晚你们就知道把你们从埃及领出来的是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","早上，你们会看见祂的荣耀，因为祂听见了你们向祂所发的怨言。我们算什么，你们竟埋怨我们？” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","摩西又说：“耶和华听见你们发的怨言了，晚上祂必给你们肉吃，早晨再给你们饼吃个饱。我们算什么？你们埋怨的其实不是我们，而是耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","摩西对亚伦说：“你去叫以色列全体会众到耶和华面前来，因为祂已听见他们的怨言。” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","亚伦对以色列全体会众说话的时候，他们向旷野远望，果然看见耶和华的荣光在云彩中显现。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“我已经听见以色列人的怨言。你告诉他们，‘到了黄昏，你们就会有肉吃，早晨就会有饼可以吃饱，这样你们就知道我是你们的上帝耶和华。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","到了傍晚，有许多鹌鹑飞来，把营地都遮盖了。到了早晨，营区四周的地上布满露水， ");
INSERT INTO cmncbs_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","露水蒸发以后，旷野便出现一层薄薄的、像白霜的东西。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","以色列人见了，不知道是何物，便彼此议论说：“这是什么？”摩西对他们说：“这就是耶和华给你们的食物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","耶和华吩咐你们要按自己和家人的食量来拾取，每人拾取两升。” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","于是，以色列人遵命而行，有人拾的多，有人拾的少。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","后来，他们用升斗量的时候，就发现多拾的没有剩余，少拾的也没有缺乏，刚好是每人所需要的量。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","摩西又吩咐他们说：“你们所拾取的，不可留到早晨！” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","可是，有的人不听，留了一些。到了早上，食物已腐烂生虫，发出恶臭，摩西就向他们发怒。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","百姓每天早晨出营拾取食物，各人按着所需分量拾取，到太阳升起后，食物就融化了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","到第六天，他们就拾取双倍的分量，也就是每人四升。会众的首领来禀告摩西， ");
INSERT INTO cmncbs_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","摩西对他们说：“耶和华说，‘明天是安息日，是向耶和华守的圣安息日。你们要把一切食物预备好，或烤或煮，吃剩的可以留到早晨。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","百姓就照摩西的吩咐，把吃剩的食物留到早晨，食物没有发臭生虫。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","摩西对他们说：“你们今天就吃这些吧，因为今天是耶和华的安息日，你们在野外找不到食物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","你们有六天可以拾取食物，但第七天是安息日，没有食物可以拾取。” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","到了第七天早晨，有些人仍然出去要拾取食物，结果什么也找不到。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","耶和华对摩西说：“你们到什么时候才肯遵行我的诫命和吩咐呢？ ");
INSERT INTO cmncbs_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","要知道，耶和华已将安息日赐给你们，所以第六天我会赐你们双倍的食物。第七天，人人都要留在营中，不许外出。” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","于是，百姓在第七天休息。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","以色列人称这种食物为吗哪，它形状像芫荽的种子，白色，味道像蜜制薄饼。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","摩西说：“以下是耶和华的吩咐，‘把两升的吗哪保存起来，直到世世代代，以便你们的子子孙孙可以看见上帝带你们离开埃及时，在旷野赐给你们的食物。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","于是，摩西吩咐亚伦：“拿个罐子盛满两升的吗哪，放在耶和华面前，留到世世代代。” ");
INSERT INTO cmncbs_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","亚伦便照耶和华给摩西的吩咐，把吗哪放在约柜前保存起来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","以色列百姓就在旷野吃了四十年的吗哪，直到他们到达有人烟的地方，到迦南的边境为止。 ");
INSERT INTO cmncbs_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","当时一俄梅珥等于十分之一伊法。 ");
INSERT INTO cmncbs_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","以色列全体会众按照耶和华的吩咐，从汛旷野启程，一程一程往前行，来到利非订安营，可是那里没有水喝。 ");
INSERT INTO cmncbs_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","百姓便跟摩西吵闹，说：“给我们水喝。”摩西便对他们说：“你们为什么跟我吵闹？为什么试探耶和华？” ");
INSERT INTO cmncbs_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","百姓非常口渴，他们向摩西抱怨说：“你为什么带我们出埃及，让我们一家大小和牲畜都渴死？” ");
INSERT INTO cmncbs_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","摩西就呼求耶和华说：“我拿这些百姓怎么办？他们准备拿石块打死我！” ");
INSERT INTO cmncbs_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","耶和华对摩西说：“你带着之前击打尼罗河水的杖，率领以色列的几个长老走在众人前面。 ");
INSERT INTO cmncbs_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","我必在何烈的磐石那里站在你们面前，你用杖击打磐石，磐石必流出水来给众人喝。”摩西便当着以色列长老的面这样做了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","摩西称那地方为玛撒和米利巴，因为以色列人在那里吵闹，又试探耶和华，说：“耶和华是否在我们当中？” ");
INSERT INTO cmncbs_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","后来，亚玛力人到利非订攻打以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","摩西对约书亚说：“选一些人出去迎战亚玛力人。明天，我会带着上帝的杖站在山顶上。” ");
INSERT INTO cmncbs_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","约书亚便遵照摩西的吩咐迎战亚玛力人，摩西、亚伦和户珥上到山顶。 ");
INSERT INTO cmncbs_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","摩西什么时候举手，以色列人就占上风；他的手什么时候垂下，亚玛力人就占上风。 ");
INSERT INTO cmncbs_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","不久，摩西的手疲倦发软，亚伦和户珥就抬来一块石头让摩西坐下，然后站在他的两边扶着他的手，他就稳稳地举着手，直到日落。 ");
INSERT INTO cmncbs_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","这样，约书亚用刀杀败了亚玛力人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","耶和华对摩西说：“我要完全抹去世人对亚玛力人的记忆。你要把这话写在书卷上作纪念，也要把这话告诉约书亚。” ");
INSERT INTO cmncbs_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","摩西在那里筑了一座坛，取名叫“耶和华尼西”。 ");
INSERT INTO cmncbs_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","摩西说：“耶和华已经起誓要世代与亚玛力人争战。” ");
INSERT INTO cmncbs_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","摩西的岳父米甸的祭司叶特罗，听说上帝为摩西和祂的子民以色列人所做的一切事及如何带他们出埃及后， ");
INSERT INTO cmncbs_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","就带着女儿西坡拉和两个外孙去见摩西。西坡拉是摩西的妻子，摩西曾让她回娘家暂时居住。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","摩西的两个儿子一个叫革舜，因为摩西说：“我成了在异乡寄居的人”； ");
INSERT INTO cmncbs_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","一个叫以利以谢，因为摩西说：“我父亲的上帝帮助我，从法老的刀下拯救了我。” ");
INSERT INTO cmncbs_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","摩西的岳父叶特罗带着摩西的妻子和两个儿子来到上帝的山见摩西，就是摩西在旷野安营的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","叶特罗事先差人把他带着摩西的妻子和两个儿子要来的消息通知摩西。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","摩西出去迎接岳父，向他下拜，与他亲吻，彼此问安，然后大家都进了帐篷。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","摩西把耶和华为拯救以色列人而向法老和埃及人所行的事，以及怎样救百姓脱离路上遇见的种种困难，都告诉了叶特罗。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","叶特罗为耶和华恩待以色列人、把他们救出埃及而高兴， ");
INSERT INTO cmncbs_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","便说：“耶和华当受称颂，因为祂从埃及人和法老手中拯救了你们，把这百姓从埃及人手中拯救了出来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","我现在知道，耶和华比一切神明都伟大，因为祂惩治了虐待这些百姓的狂妄之徒。” ");
INSERT INTO cmncbs_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","摩西的岳父叶特罗说完，便向上帝献燔祭及其他祭物。亚伦和以色列的长老都来与他一起在上帝面前吃饭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","第二天，摩西坐着审理百姓的纠纷，百姓从早到晚都站在摩西周围。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","摩西的岳父叶特罗看见摩西对百姓所行的一切，就对摩西说：“你为什么这样处理百姓的事？为什么你独自坐着，众百姓从早到晚都站在你周围？” ");
INSERT INTO cmncbs_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","摩西对岳父说：“因为他们来我这里求问上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","他们有纠纷就来我这里，我为双方定夺是非，教他们认识上帝的律例和法度。” ");
INSERT INTO cmncbs_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","摩西的岳父叶特罗劝摩西说：“这不是好方法， ");
INSERT INTO cmncbs_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","你和这些百姓都会疲惫不堪，你一个人无法担当如此繁重的工作。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","你要听我的劝告，愿上帝与你同在。你要做百姓的代表，把案件奏明上帝， ");
INSERT INTO cmncbs_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","又要教导他们律例和法度，指示他们当行的道、当做的事。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","此外，你要在民中挑选一些敬畏上帝、有才干、诚实、正直、憎恶不义之财的人，派他们做千夫长、百夫长、五十夫长和十夫长，管理百姓。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","让他们随时为百姓判案，处理小纠纷，遇到大事才由你审理。有他们分担你的责任，你会更轻省。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","如果你这样做，并且上帝也这样吩咐你，你就能承受得住，百姓也可以平安地回家。” ");
INSERT INTO cmncbs_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","于是，摩西接纳了岳父的建议，依言而行， ");
INSERT INTO cmncbs_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","从百姓中挑选有才干的人，委派他们做百姓的领袖，担任千夫长、百夫长、五十夫长和十夫长。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","他们负责随时审理百姓的事，遇到难断的案件就呈到摩西那里，自己则审理普通的事。 ");
INSERT INTO cmncbs_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","之后，摩西为岳父送行，叶特罗就返回了家乡。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","以色列人离开埃及满三个月的那一天，他们来到西奈旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","他们离开利非订，来到西奈旷野，在那里的山下安营。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","摩西上山到上帝那里，耶和华从山上呼唤他说：“你告诉雅各家，告诉以色列人， ");
INSERT INTO cmncbs_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘我怎样对付埃及人，怎样像鹰一样把你们背在翅膀上带来归属我，你们都看见了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","现在，你们若真心听从我的话，遵守我的约，就必在万民中做我宝贵的产业，因为普天下都是我的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","你们要归于我，作祭司之国、圣洁之邦。这些话你要告诉以色列人。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","摩西召集以色列的长老，把耶和华对他的一切吩咐都转告他们。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","百姓都齐声回答说：“凡耶和华所吩咐的，我们都愿意遵从。” 摩西便把他们的话回报耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","耶和华对摩西说：“我会在密云中临到你那里，使百姓也可以亲耳听见我与你说话的声音，这样他们就会永远信赖你。”摩西把以色列人的话回报耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","耶和华对摩西说：“你现在回到他们那里，吩咐他们今天和明天要洁净自己，洗净衣服， ");
INSERT INTO cmncbs_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","到后天都要预备好，因为这一天耶和华要在百姓眼前降临在西奈山上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","此外，你要在山的四围划定界限，吩咐百姓不得上山或触碰山的边界，触碰者必被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","你们不可用手碰违例者，要用石头打死他或用箭射死他，无论人畜，都不可存活。等到角声长鸣时，百姓才可上山。” ");
INSERT INTO cmncbs_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","于是，摩西下山回到百姓那里，吩咐他们各人洁净自己，洗净衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","又吩咐他们说：“到后天一切都要准备好，这期间你们不可亲近女人。” ");
INSERT INTO cmncbs_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","到了第三天早晨，山上雷电大作，乌云密布，又有嘹亮的号角声，营中的百姓都胆战心惊。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","摩西率领百姓出营迎接上帝，他们都站在山脚下。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","因为耶和华在火中降临到西奈山，山上弥漫着浓烟，滚滚上腾，好像一个大火窑，整座山剧烈震动。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","号角声越来越嘹亮。摩西说话，上帝用雷鸣回应他。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","耶和华降临在西奈山顶，召摩西到山顶，摩西就上去了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","耶和华对摩西说：“你下去警告百姓不可闯过界限到我这里观看，以免很多人死亡。 ");
INSERT INTO cmncbs_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","吩咐到我面前来的祭司要洁净自己，免得我忽然出来击杀他们。” ");
INSERT INTO cmncbs_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","摩西对耶和华说：“百姓不能上西奈山，因为你已经吩咐我们要在山的四围划定界限，使这山圣洁。” ");
INSERT INTO cmncbs_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","耶和华对他说：“你下去把亚伦一起带来，祭司和百姓仍要留在原来的地方，不得乱闯到我面前，免得我忽然出来击杀他们。” ");
INSERT INTO cmncbs_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","摩西就下去，把耶和华的话转告给百姓。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","以下是上帝的训示： ");
INSERT INTO cmncbs_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“我是你的上帝耶和华，曾把你从受奴役之地埃及领出来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“除我以外，你不可有别的神明。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","不可为自己雕刻神像，不可仿照天上、地上和地底下水中的任何形象造神像， ");
INSERT INTO cmncbs_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","不可跪拜它们，也不可供奉它们，因为我——你的上帝耶和华痛恨不贞，我必追讨背弃我之人的罪，从父到子直到三四代。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","但那些爱我、遵守我诫命的人，我必以慈爱待他们，直到千代。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","不可妄用你上帝耶和华的名，违者必被耶和华定罪。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","要谨记安息日，守为圣日。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","你一周可劳碌工作六天， ");
INSERT INTO cmncbs_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","但第七天是你的上帝耶和华的安息日，这一天你和儿女、仆婢、牲畜及你那里的外族人不可做任何工。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","因为耶和华用六天创造了天地、海洋和其中的万物，第七天便休息了，所以耶和华赐福安息日，把它定为圣日。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","要孝敬父母，以便在你的上帝耶和华要赐给你的土地上享长寿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","不可杀人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","不可通奸。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","不可偷盗。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","不可作伪证陷害人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","不可贪恋别人的房屋，不可贪恋别人的妻子、仆婢、牛驴或其他任何物品。” ");
INSERT INTO cmncbs_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","那时雷电交加，号角嘹亮，山上冒烟，百姓见此情景，都吓得浑身颤抖，不敢挨近。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","他们对摩西说：“求你跟我们说话，我们必听从。不要让上帝直接跟我们说话，恐怕我们会丧命！” ");
INSERT INTO cmncbs_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","摩西对百姓说：“不要害怕，上帝降临是要试验你们，好让你们时时敬畏祂，不致犯罪。” ");
INSERT INTO cmncbs_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","百姓都站得远远的，摩西独自走进上帝所在的密云中。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","耶和华吩咐摩西对以色列百姓说：“既然你们已经亲眼看见我从天上向你们说话， ");
INSERT INTO cmncbs_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","你们不可制造神像与我并立，不可为自己制造金银神像。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","你们要为我筑一座土坛，把你们的牛羊献在坛上作燔祭和平安祭。凡是我使自己的名被尊崇的地方，我会亲临那里赐福给你们。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","你们若为我筑石坛，不可用凿刻的石头，因为用工具凿刻的石头会玷污祭坛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","不可踩着台阶登我的祭坛，免得露出你们的下体。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“你要向百姓颁布下列法令。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","你若买一个希伯来人当奴仆，他必须服侍你六年，到第七年便可以获得自由，不用支付任何赎金。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","他来的时候若是单身，就可以单身离开。他来的时候若有妻子，就可以带妻子一起离开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","倘若主人给他娶了妻，妻子生了儿女，那么期满的时候，他只能单独离开，他的妻儿要归主人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","倘若奴仆说，‘我爱我的主人和我的妻子儿女，我不愿意离去做自由人。’ ");
INSERT INTO cmncbs_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","主人就要带他到审判官面前，让他靠着门或门框，用锥子为他穿耳洞。这样，他就要永远服侍主人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","倘若有人把女儿卖为婢女，她不可像男仆那样离开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","倘若买她的主人本想把她留给自己，后来却不喜欢她，就必须让她赎身。主人无权把她转卖给外族人，因为是主人对她不守信用。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","倘若是买来给自己的儿子，就要把她当作自己的女儿一般看待。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","倘若有人娶了婢女为妻，后来又另娶，他还是要照常供给她饭食和衣服，并履行同房的义务。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","倘若主人不履行以上的三个条件，婢女就可以随时离开，不用缴付任何赎金。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“打人致死的，必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","倘若不是故意杀人，而是上帝许可那人死在他手里，他就可以逃往我指定的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","倘若是蓄意杀人，就算他逃到我的祭坛那里，也要把他拉出来处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","殴打父母的，必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","绑架他人贩卖或自用的，必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","咒骂父母的，必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","倘若吵架时一方用拳头或石块致另一方受伤、躺卧在床，但不至于死， ");
INSERT INTO cmncbs_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","日后能起床扶着拐杖到户外走，伤人者便不算有罪，但要赔偿受伤者停工期间的损失，并要负责治好他。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“倘若有人用棍子打他的仆婢，导致仆婢当场死亡，他必须受惩罚。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","倘若伤者过了一两天才死去，主人就可免刑，因为死者是他的财产。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","倘若有人彼此斗殴，伤了孕妇，导致早产，但未造成其他伤害，伤人者要按她丈夫所要求的金额，经审判官判定以后，如数赔偿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","倘若还有其他伤害，伤人者就要以命偿命， ");
INSERT INTO cmncbs_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","以眼还眼，以牙还牙，以手还手，以脚还脚， ");
INSERT INTO cmncbs_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","以烧伤还烧伤，以创伤还创伤，以殴打还殴打。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“主人若打坏仆婢的一只眼睛，就要因此让仆婢自由离去。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","同样，倘若他打掉了仆婢的一颗牙齿，也要因此而释放仆婢。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“倘若有牛抵死了人，要用石头打死那头牛，并且不可吃它的肉，牛的主人可算无罪。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","但倘若牛常常用角抵人，并且已经有人向牛的主人投诉，他却不拴好牛，以致牛抵死了人，就要用石块打死牛，并处死主人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","若判他以钱赎命，不论金额多少，他都得照付。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","牛若抵死了别人的儿女，也要照以上的条例办理。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","牛若抵死了别人的仆婢，牛的主人要赔七两银子给那仆婢的主人，并要用石头打死牛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","倘若有人打开井盖或挖了井后不把井口盖好，以致有牛或驴掉进井里， ");
INSERT INTO cmncbs_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","井的主人就要赔偿牲畜的主人，死牲畜则归井的主人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","倘若某人的牛抵死了别人的牛，两家的主人就要卖掉活牛，平分所得，同时也要平分那头死掉的牛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","倘若素知牛好抵，主人却没有拴好它，他就要以牛还牛，死牛则归他。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“倘若有人偷了别人的牛羊，然后宰了或卖了，他要用五头牛抵偿一头牛，四只羊抵偿一只羊。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","倘若有人打死正入屋偷窃的贼，这人不算犯杀人罪。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","倘若事情发生在白天，家主就犯了杀人罪。倘若盗贼被擒，他就要赔偿家主，若他一无所有，就要把他卖为奴隶作赔偿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","倘若他偷的牲畜如牛、羊或驴在他手上还活着，他要偿还失主双倍。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“倘若有人在田野或葡萄园里牧放牲畜，任由牲畜吃别人田里的农作物或葡萄，他必须拿自己田里最好的农作物或葡萄作赔偿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","倘若田间起火，烧着荆棘，以致烧掉了别人的庄稼、禾捆或整个田园，那点火的人就要赔偿一切损失。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“倘若有人把金钱或物件交给邻居保管，结果在邻居家遭盗，盗贼被缉拿归案后要赔偿双倍； ");
INSERT INTO cmncbs_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","倘若没捉到盗贼，邻居就要到审判官那里证明自己没有偷拿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","倘若二人之间有什么纠纷，无论是为了牛、驴、羊、衣服或任何失物，争执的双方要把案件呈报审判官，审判官判谁败诉，谁就要赔偿双倍。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","倘若有人把驴、牛、羊或别的牲畜交给邻居看管，牲畜死伤或被人抢走，并且无人看见， ");
INSERT INTO cmncbs_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","看守的人就要在耶和华面前起誓没有动邻居的东西，这样失主就应当作罢，看守的人不用赔偿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","但倘若牲畜是被人偷去的，受托人就要赔偿失主。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","倘若牲畜被野兽撕碎，受托人要把残骸带来当证据，无需赔偿被撕碎的牲畜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","倘若有人向邻居借牲畜，牲畜受伤或死掉，而当时物主不在场，借的人就要赔偿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","倘若物主当时在场，借的人就不用赔偿。倘若牲畜是租来的，租的人只需付租金不用赔偿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“倘若有人诱奸了尚未许配的处女，他就要交出聘礼，娶她为妻； ");
INSERT INTO cmncbs_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","倘若女方家长反对婚事，男方要付出与聘礼等额的金钱给女方家长。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“凡行邪术的女人，必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“与动物性交的人，必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“献祭给耶和华以外的其他任何神明的人，必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“不可欺压在你们中间寄居的人，因为你们在埃及也做过寄居的人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“不可亏待寡妇和孤儿， ");
INSERT INTO cmncbs_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","倘若你们亏待他们，他们向我呼求，我必听他们的呼求， ");
INSERT INTO cmncbs_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","向你们发怒，用刀杀掉你们，使你们的妻子变为寡妇，儿女成为孤儿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“倘若有贫苦的同胞向你借钱，你不可像放债的一样收取利息。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","倘若你的邻居把衣服给你作抵押，你要在日落之前把衣服还给他。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","因为他只有这件蔽体的衣服，若是没有，他晚上如何睡觉？他若呼求我，我必垂听，因为我是仁慈的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","不可亵渎上帝，也不可咒诅百姓的官长。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","你们要向我献上五谷和新酒，不可迟延。要把你们的长子献给我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","也要献上头生的牛羊，它们生下来后可以留在母亲身边七天，第八天要献给我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","你们要做我圣洁的子民，不可吃田野间被野兽咬死的牲畜，要把它丢给狗吃。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“不可散布谣言，也不可与恶人联手作伪证。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","不可随众行恶。在法庭作证时不可附和多数人，颠倒是非。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","在诉讼的事上不可偏袒穷人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“倘若看见仇人的牛或驴走迷了路，总要牵回去交给他。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","倘若遇见仇人的驴被驮的重物压倒，不可径自走开，总要帮助仇人抬开重物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“不可在诉讼案中冤枉穷人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","不可诬告别人，不可杀害正直无辜的人，因为我必惩罚作恶之人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","不可收受贿赂，因为贿赂蒙蔽人的眼目，使人颠倒是非。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","不可欺凌在你们中间寄居的人，因为你们也曾经在埃及寄居，知道寄居他乡的滋味。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“六年之内你要耕种收割， ");
INSERT INTO cmncbs_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","第七年要让土地休息，不耕不种，你们当中的穷人可以吃田中长出来的，剩下的可以留给动物吃。你也要这样处理葡萄园和橄榄园。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","六天之内，你要工作，但第七天要休息。这样，牛、驴可以歇息，你家里的奴仆和寄居的也可以休息。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","你们要谨慎遵从我对你们说的话。不可提其他神明的名字，不可从你口中听到它们的名字。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“你每年要向我守三个节期。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","要守除酵节，照我的吩咐在每年亚笔月所定的日期连续吃七天的无酵饼，因为你是在这个月离开了埃及。谁也不可空手朝见我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","要在耕种后收取初熟之物的时候守收获节。要在年终从田间收取劳动成果时守收藏节。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","所有的男子都要在这三个节期朝见主耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“不可把祭牲的血和有酵的饼一起献给我，也不可把节期祭牲的脂肪留到早晨。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","要把田中最好的初熟之物送到你们的上帝耶和华的殿中。不可用母山羊的奶煮它的小羊羔。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“看啊，我要差遣天使走在你前面，在路上保护你，带领你到达我所预备的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","他是奉我的名来的，你们要谨遵他的话，不可悖逆，不然他必不赦免你们的过犯。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“你若认真听从他的吩咐，遵行我的话，我就与你的仇敌为敌，与你的对头作对。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","我的天使要走在你前面，带领你去亚摩利人、赫人、比利洗人、迦南人、希未人和耶布斯人所住的地方，我会把他们全部消灭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","不可叩拜他们的神明，不可供奉它们，也不可效法他们的行为，要彻底拆毁神像，打碎他们的神柱。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","你们要事奉你们的上帝耶和华，我必赐给你食物和水，使疾病远离你们， ");
INSERT INTO cmncbs_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","在你境内必没有人流产或不育，我会使你享尽天年。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","你所到之处，我必使那里的人惶恐不安，使你一切的仇敌都在你面前转身逃跑。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","我要派黄蜂做你的先锋，赶走那些希未人、迦南人和赫人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","我不会在一年之内把这些人全部赶走，免得土地荒凉，野兽泛滥。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","我会逐渐地赶走他们，直到你们人丁兴旺，可以占据那片土地。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","我给你定下国界，从红海到非利士海岸，从旷野到幼发拉底河。我要把其中所有的居民都交在你手中，你要把他们全部赶出去。 ");
INSERT INTO cmncbs_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","不可跟这些民族及其神明立约， ");
INSERT INTO cmncbs_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","也不可让这些民族住在你的土地上，免得他们使你得罪我，你若供奉他们的神明，必因此而陷入网罗。” ");
INSERT INTO cmncbs_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","耶和华又指示摩西说：“你和亚伦、拿答、亚比户及以色列的七十位长老上我这里来，远远地敬拜我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","只有你可以靠近我，其他百姓都不得与你一同走近。” ");
INSERT INTO cmncbs_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","摩西下山把耶和华的话和法令都告诉百姓，百姓齐声回答：“我们愿意遵行耶和华的一切吩咐。” ");
INSERT INTO cmncbs_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","摩西把耶和华的这些话记录下来。他清早起来，在山脚筑了一座坛，立了十二根柱子，代表以色列的十二支派。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","他又吩咐以色列的青年去给耶和华献燔祭，又献上公牛作平安祭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","摩西把祭牲的血一半放在盆里，一半洒在坛上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","他又把约书念给百姓听，百姓听了都说：“我们愿意遵行耶和华的一切吩咐，我们愿意顺服。” ");
INSERT INTO cmncbs_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","摩西便把盆中的血洒在百姓身上，说：“这是立约的血，是耶和华按所说的话与你们立约的凭据。” ");
INSERT INTO cmncbs_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","之后，摩西、亚伦、拿答、亚比户及以色列的七十位长老便上了山。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","他们都看见了以色列的上帝，祂的脚下好像是一片蓝宝石，像天一样明净。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","上帝没有伸手杀这些以色列的首领，允许他们看见祂，在祂面前吃喝。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","耶和华对摩西说：“你上山到我这里来，留在这里，我要把写着律法和诫命的石版赐给你，你可以用来教导百姓。” ");
INSERT INTO cmncbs_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","于是，摩西带着他的助手约书亚动身上了上帝的山。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","离开之前，摩西吩咐长老说：“你们在这里等候我们回来。亚伦和户珥跟你们在一起，民中有什么诉讼的事情，可以去找他们。” ");
INSERT INTO cmncbs_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","摩西上了山，密云遮盖着整座山。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","耶和华的荣耀停留在西奈山上，密云遮盖了山六天。第七天，耶和华在云中召唤摩西。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","在以色列人眼中，耶和华的荣耀在山上好像烈火。 ");
INSERT INTO cmncbs_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","摩西上到山上，走进云中，在那里停留了四十昼夜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“你去吩咐以色列百姓要献礼物给我。你们要为我收下所有甘心乐意献上的礼物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","你们要收的礼物是金、银、铜， ");
INSERT INTO cmncbs_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","蓝色、紫色和朱红色毛线，细麻，山羊毛， ");
INSERT INTO cmncbs_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","染成红色的公羊皮，海狗皮，皂荚木， ");
INSERT INTO cmncbs_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","灯油，制作膏油和香的香料， ");
INSERT INTO cmncbs_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","镶嵌在以弗得和胸牌上的红玛瑙及其他宝石。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","他们要为我造一座圣所，我好住在他们中间。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","你们要完全照我指示的样式造圣幕和里面的各样器具。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“要用皂荚木做一个柜，长一米一，宽七十厘米，高七十厘米， ");
INSERT INTO cmncbs_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","里外都要包上纯金，要用金子镶柜边。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","再铸造四个金环，安在柜的四个脚上，每边两个环。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","用皂荚木造两根横杠，包上金， ");
INSERT INTO cmncbs_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","然后把横杠穿过柜两边的金环，便于抬柜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","横杠穿进柜环以后，不可再抽出来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","把我将要赐给你的两块约版放在柜里。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","要用纯金造一个施恩座，长一米一，宽七十厘米。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","用金子在施恩座的两端打造两个基路伯天使， ");
INSERT INTO cmncbs_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","跟施恩座连在一起，一端一个。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","两个基路伯天使要面对面朝向施恩座，向上展开翅膀，遮盖施恩座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","要把施恩座放在柜上面，把我要赐给你的约版放在柜里。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","我就在那里跟你会面，从约柜上面两个基路伯天使中间的施恩座上，把要传给以色列百姓的一切诫命告诉你。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“要用皂荚木造一张桌子，长九十厘米，宽四十五厘米，高七十厘米。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","整张桌子都要包上纯金，四周镶上金边， ");
INSERT INTO cmncbs_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","在桌子四周造一个八厘米宽的外框，外框镶上金边。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","要造四个金环，安在桌子四角的桌腿上， ");
INSERT INTO cmncbs_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","金环要靠近外框，以便穿横杠抬桌子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","两根横杠要用皂荚木制作，外面包金，用来抬桌子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","你们要用纯金造桌子上的盘、碟和献酒用的瓶和杯。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","桌子上要一直摆着供饼，献在我面前。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“要用纯金造一个灯台，灯台的灯座、灯柱、油杯、花萼和花瓣要用一块纯金打造。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","灯台两边要各伸出三个分枝，共六个分枝。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","每个分枝上要有三个杏花形状、有花瓣和花萼的杯，六个分枝都是这样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","灯台上要有四个杏花形状、有花瓣和花萼的杯。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","灯台上每一对分枝的相连处要有花萼，三对都是这样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","整座灯台，包括花萼和分枝，都要用一块纯金打造。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","此外，要为灯台造七个灯盏，放在灯台上面，照亮前面的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","灯台用的灯剪和灯花盘都要用纯金造。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","造整座灯台和灯台的器具要用六百八十两纯金。 ");
INSERT INTO cmncbs_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","你务要照着在山上指示你的样式造各样器具。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“要用十幅幔子做圣幕，幔子要用细麻和蓝色、紫色、朱红色毛线织成，上面要精工绣制基路伯天使。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","每幅幔子的尺寸都一样，长十二米半、宽一米八。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","每五幅连在一起，形成两幅大幔子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","要在每幅大幔子末幅的边缘钉上蓝色的扣环， ");
INSERT INTO cmncbs_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","每幅大幔子钉五十个，扣环要两两相对， ");
INSERT INTO cmncbs_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","再做五十个金钩，把两幅大幔子连在一起，成为一个完整的圣幕。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“要用山羊毛织十一幅幔子作圣幕的罩棚， ");
INSERT INTO cmncbs_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","每幅长十三米半、宽一米八。十一幅幔子的尺寸都要一样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","然后，你们要把五幅连成一大幅，其余六幅连成一大幅，第六幅要在罩棚前叠起来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","要在这两幅大幔子末幅的边缘各钉上五十个扣环， ");
INSERT INTO cmncbs_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","再做五十个铜钩，把这两幅大幔子扣在一起，成为一个完整的罩棚。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","铺罩棚所剩下来的半幅幔子要垂到圣幕后面。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","两旁余下的幔子可垂在圣幕的两边，每边长四十五厘米，盖着圣幕。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","罩棚上面要盖一层染成红色的公羊皮，再盖一层海狗皮做顶盖。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“要用皂荚木做支圣幕的木板， ");
INSERT INTO cmncbs_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","每块木板长四米半，宽七十厘米。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","每块木板要有两个接榫，用来衔接。圣幕的所有木板都要这样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","圣幕的南面要有二十块木板， ");
INSERT INTO cmncbs_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","在这些木板下面要造四十个带凹槽的银底座，每块木板下面有两个，套在木板的两个接榫上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","圣幕北面也要有二十块木板， ");
INSERT INTO cmncbs_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","木板下面同样有四十个带凹槽的银底座，每块木板下面有两个银底座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","圣幕后面，就是西面，要有六块木板。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","圣幕后面的两个拐角要各有一块木板， ");
INSERT INTO cmncbs_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","木板的下端连于底座，顶端用一个环固定。两个拐角都要这样做。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","这样，后面共有八块木板，每块木板下面各有两个带凹槽的银底座，一共有十六个银底座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","“要用皂荚木做横闩，圣幕左右两边和后面的墙板上要各有五根横闩， ");
INSERT INTO cmncbs_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","拦腰固定墙板的那根横闩要从这端贯穿到那端。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","所有的木板和横闩都要包上金，并要在木板上造金环，用来穿横闩。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","要照着我在山上所指示你的样式，把圣幕支搭起来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“要用细麻和蓝色、紫色、朱红色毛线织成一幅幔子，上面精工绣上基路伯天使。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","要把这幅幔子挂在四根包金的皂荚木柱上，木柱上有金钩，木柱立在四个带凹槽的银底座上面。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","要把整幅幔子挂在木柱的金钩上，把约柜抬进幔子里。这幔子把圣幕分为两个部分，幔子里面是至圣所，外面是圣所。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","要把施恩座放在至圣所里面的约柜上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","桌子要放在幔子的外面、圣幕的北面，灯台放在南面，跟桌子相对。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","要用细麻和蓝色、紫色、朱红色毛线绣制圣幕的门帘。 ");
INSERT INTO cmncbs_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","要用皂荚木做五根挂门帘的柱子，柱子包上金，上面要有金钩，并要为柱子铸造五个带凹槽的铜底座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“要用皂荚木造一个方形的祭坛，长宽各两米二，高一米三。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","要在坛的四角造四个凸起的角，与坛连成一体，坛外面要包上铜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","用铜造盛坛灰的盆和其他祭坛用具，即铲、碗、肉叉、火鼎。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","要造一个铜网，在铜网的四角造四个铜环。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","铜网在祭坛围边的下方，向下伸展到祭坛的腰部。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","要用皂荚木为祭坛造两根横杠，包上铜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","要将两根横杠穿在坛两旁的铜环里，以便抬坛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","整座坛都用木板制作，坛是中空的。一切都要照我在山上给你的指示去做。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“要为圣幕围出一个院子。院子南面的帷幔要用细麻织成，长四十五米， ");
INSERT INTO cmncbs_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","帷幔有二十根柱子，二十个带凹槽的铜底座，柱子上的钩和箍都是银的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","北面的帷幔也是长四十五米，柱子、铜底座、钩和箍的样式都与南面的一样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","院子西面的帷幔宽二十二米半，有十根柱子和十个带凹槽的底座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","院子东面的帷幔也是宽二十二米半。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","入口两边的帷幔都是宽七米，各有三根柱子和三个带凹槽的底座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","院子的入口要有门帘，长九米，用细麻和蓝色、紫色、朱红色毛线绣制，还有四根柱子和四个带凹槽的底座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","院子四围的柱子都要有银箍，所有的钩子都要用银制作，带凹槽的底座要用铜制作。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","整个院子长四十五米，宽二十二米半，高两米二，所有的帷幔都要用细麻精工制作，带凹槽的底座要用铜制作。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","圣幕里其他一切器具以及圣幕、院子所用的橛子都要用铜制作。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“你要吩咐以色列人把榨的纯橄榄油给你拿来点灯，使灯常明。 ");
INSERT INTO cmncbs_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","亚伦和他的子孙要负责照看会幕内遮掩约柜的幔子外的灯，使灯从晚上到早晨一直在耶和华面前亮着。这是以色列百姓世代当守的永久律例。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“你要从以色列民中把你的哥哥亚伦和他四个儿子拿答、亚比户、以利亚撒和以他玛带到你身边，立他们为祭司事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","你要为你哥哥亚伦做圣衣，显明他职位的荣耀和尊贵。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","你要吩咐所有我赋予智慧的巧手裁缝师为亚伦缝制衣服，使他分别出来，做圣洁的祭司事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","他们要做的圣衣包括胸牌、以弗得、外袍、杂色的内袍、礼冠和腰带。要为你哥哥亚伦及其众子做这样的圣衣，好让他们做祭司事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","要用金线、细麻及蓝色、紫色、朱红色毛线制作圣衣。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“以弗得要用金线、细麻及蓝色、紫色、朱红色毛线精工制作。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","要在以弗得两边用两条肩带缝合起来。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","用金线、细麻及蓝色、紫色、朱红色毛线精工制作腰带，缝在以弗得上，连成一整件。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“你要拿两块红玛瑙，刻上以色列十二个儿子的名字， ");
INSERT INTO cmncbs_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","按他们的长幼次序，每一块宝石刻上六个名字。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","要用工匠刻图章的方法将他们的名字刻在两块宝石上，把宝石镶在两个金框里。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","然后将镶着金框的宝石缝在以弗得的两条肩带上，作以色列人的纪念石。亚伦要把他们的名字带在肩上，在耶和华面前作纪念。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","要做两个金框， ");
INSERT INTO cmncbs_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","并像搓绳子一样用纯金搓成两条金链，把链子连接在镶宝石的金框上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“要精工制作一个用来明白上帝旨意的胸牌，制作的方法和造以弗得一样，用金线、细麻及蓝色、紫色、朱红色毛线制作。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","胸牌是方形的，长宽各二十二厘米，分成上下两层。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","上面要镶上四行宝石：第一行是红宝石、黄玉和翠玉； ");
INSERT INTO cmncbs_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","第二行是绿宝石、蓝宝石和金刚石； ");
INSERT INTO cmncbs_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","第三行是紫玛瑙、白玛瑙和紫晶； ");
INSERT INTO cmncbs_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","第四行是水苍玉、红玛瑙和碧玉。这些宝石都要镶在金框上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","要用刻图章的方法在每一颗宝石上刻一个以色列儿子的名字，十二颗宝石代表十二支派。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“要用纯金拧成两条像绳子一样的链子，连在胸牌上， ");
INSERT INTO cmncbs_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","造两个金环安在胸牌两端， ");
INSERT INTO cmncbs_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","把两条金链分别系在胸牌两端的金环上， ");
INSERT INTO cmncbs_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","再把金链的另两端接在两个金框上，安在以弗得前面的肩带上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","造两个金环，安在靠近以弗得内边的胸牌下两端。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","再造两个金环，安在以弗得前面两条肩带下端，靠近精致的以弗得腰带上方的接缝处。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","再用一条蓝色的带子系住以弗得和胸牌上面的金环，使胸牌贴在精工织成的以弗得腰带上，不会从以弗得上松脱。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","亚伦进圣所时，要佩戴这块刻着以色列众子名字、用来做判断的胸牌，在耶和华面前常作纪念。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","又要把乌陵和土明放在胸牌里面，亚伦到耶和华面前的时候，要佩带这胸牌，以便明白上帝的旨意，为以色列人做决定。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“也要缝制一件蓝色的以弗得的外袍， ");
INSERT INTO cmncbs_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","袍上要留领口，领口周围要织领边，就像铠甲的领口，免得领口破裂。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","外袍的底边要另外用蓝色、紫色、朱红色毛线做成石榴状的饰物，石榴间要挂金铃铛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","一个石榴一个金铃铛，相间排列，围在外袍的底边。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","亚伦事奉的时候，要穿上这外袍，以便他进圣所到耶和华面前和出圣所的时候，铃铛会发出响声，他就不至于死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“你也要用纯金造一块牌子，以刻印章的方法刻上‘耶和华的圣物’的字样， ");
INSERT INTO cmncbs_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","再拿一条蓝色带子，把它系在礼冠前面。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","亚伦要把这金牌戴在额上，表示他承担以色列人献圣物时的过犯，这圣物是以色列百姓特别献上的礼物。这金牌要常常留在亚伦的额上，好使百姓蒙耶和华悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“要用细麻布缝制祭司的内袍，用细麻布做礼冠，腰带上要有刺绣， ");
INSERT INTO cmncbs_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","也要为亚伦的儿子们缝制内袍、腰带、头巾，显明他们职位的荣耀和尊贵。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","给你哥哥亚伦及其众子穿上这些衣服后，你要用油膏立他们，使他们分别出来，做圣洁的祭司事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“要用细麻布为他们做裤子，以遮盖下体，裤子要从腰部到大腿。 ");
INSERT INTO cmncbs_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","亚伦父子们进会幕或走近祭坛到圣所事奉的时候，都要穿上裤子，免得担负罪责而死亡。这是亚伦及其子孙永远当守的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“你要使亚伦父子们分别出来，做圣洁的祭司事奉我。做法如下：你要选一头公牛犊和两只毫无残疾的公绵羊， ");
INSERT INTO cmncbs_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","用细面粉预备无酵饼、调上油的无酵饼和涂上油的无酵薄饼。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","所有的饼都要用一个篮子盛，连同公牛和绵羊一起带到会幕那里。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","你要把亚伦父子们带到会幕门口，用水洗他们， ");
INSERT INTO cmncbs_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","然后给亚伦穿上内袍、以弗得和以弗得的外袍，戴上胸牌，束上精致的以弗得带子， ");
INSERT INTO cmncbs_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","戴上礼冠，把圣冠系在礼冠上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","之后，把膏油倒在他头上，立他为祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","接着轮到亚伦的儿子们，要给他们穿上内袍， ");
INSERT INTO cmncbs_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","为他们束上腰带，戴上头巾，他们就按永远的律例得到祭司的职分。你要这样把圣职授予他们。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“你要把公牛牵到会幕前面，亚伦父子们要把手按在公牛头上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","你要在会幕门前，在耶和华面前宰公牛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","要取些公牛的血带到祭坛那里，用手指把血抹在祭坛凸起的四角上，再把剩下的血倒在坛脚。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","再把包裹内脏的脂肪、肝叶、两个肾脏和肾脏上的脂肪都放在祭坛上烧掉。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","但公牛的皮、肉和粪要拿到营外焚烧。这是赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“要把一只公绵羊牵来，亚伦父子们要把手按在羊头上， ");
INSERT INTO cmncbs_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","然后你要宰羊，把血洒在祭坛四周。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","再把羊切成块状，用水洗净所有的内脏和腿，跟肉块和头放在一起。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","然后，把整只羊放在祭坛上焚烧，这是献给耶和华的燔祭，是蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“你要把另一只公绵羊牵来，亚伦父子们要把手按在羊头上， ");
INSERT INTO cmncbs_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","然后你要宰羊，取一点血涂在亚伦和他儿子们的右耳垂、右手大拇指和右脚大脚趾上，剩下的血就洒在祭坛四周。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","再从祭坛上取些血，与膏油一起洒在亚伦父子及其衣服上。这样，他们和他们的衣服就会变得圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“你要取出羊的脂肪、肥尾巴、包裹内脏的脂肪、肝叶、两个肾脏、肾脏上的脂肪和右腿，因为这是授圣职时所献的羊。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","再从耶和华面前装无酵饼的篮子里取一个饼、一个油饼和一个薄饼。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","把这些都放在亚伦父子们手中，作为摇祭在耶和华面前摇一摇。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","然后，你要把这些祭物接过来，放在祭坛的燔祭上焚烧献给耶和华，成为蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","你要拿起亚伦承受圣职时所献的那只公绵羊的胸肉，作为摇祭在耶和华面前摇一摇。之后，这份祭肉就归你。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“你要将属于亚伦父子们、授圣职时所献公绵羊的摇祭胸肉和举祭腿肉分别出来，使之圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","这些祭物要从以色列人所献的平安祭中取出来，归给亚伦父子们，作为永远的定例。这是以色列人当向耶和华献的祭物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“亚伦的圣衣要留给他的子孙，他们可以穿上这圣衣受膏，承受圣职。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","接替亚伦做祭司的那位后裔，每次进会幕的圣所供职时，都要一连七天穿着圣衣。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“你要在圣洁的地方煮授圣职时所用的公绵羊肉。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","亚伦父子们可以在会幕的门前吃这公绵羊祭肉和篮内的饼。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","他们要吃这些在授圣职时用来赎罪、使他们圣洁的祭物。但祭司以外的人不能吃，因为这些是圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","若有授圣职时所献的肉或饼留到早晨，就要烧掉，不可再吃，因为这些都是圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“你要照我的吩咐，为亚伦父子们举行授圣职礼，历时七天。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","每天要献一头公牛作赎罪祭，来洁净祭坛，然后用膏油抹祭坛，使祭坛圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","连续七天都要这样做，使祭坛完全圣洁，凡是碰到祭坛的都变得圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“你每天要在祭坛上献两只一岁的公羊羔， ");
INSERT INTO cmncbs_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","早晨和黄昏各献一只。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","要用一公斤细面粉调一升橄榄油做成素祭，与早晨献的羊羔一同献上，再献上一升酒作奠祭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","黄昏献第二只羊时，也要跟早晨一样同时献上素祭和奠祭，作为蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“你们世世代代要不断地在我面前献上燔祭，祭礼要在会幕门前举行，这会幕就是我跟你们会面交谈的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","我要在那里和以色列人相会，我的荣耀将使会幕圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“我要使会幕和祭坛圣洁，也要使亚伦父子们圣洁，做祭司事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","我要住在以色列人中间，做他们的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","他们必知道我是他们的上帝耶和华。我带领他们离开埃及，就是为了要住在他们中间。我是他们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“你要用皂荚木造一座烧香用的坛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","坛是四方形的，长宽各四十五厘米，高九十厘米，坛上面凸起的四角与坛连成一体。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","坛顶、坛的四面和坛上凸起的角要包上纯金，四周镶上金边。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","要在坛两侧的金边下面安两个金环，使横杠穿过金环，以便抬香坛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","要用皂荚木造横杠，包上金。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","要把香坛放在约柜前幔子的外面，对着约柜上的施恩座，就是我要跟你会面的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“亚伦每天早上料理灯台的时候，要在这坛上烧芬芳的香。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","黄昏点灯的时候，他也要在耶和华面前烧香，世世代代都要如此。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","不可在这香坛上烧别的香料，不可用这坛来献燔祭或素祭，也不可在上面浇奠祭。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","亚伦每年要用赎罪祭牲的血在坛的角上行一次赎罪礼，世代如此。这是耶和华至圣的坛。” ");
INSERT INTO cmncbs_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“你统计以色列人口的时候，每一个被统计的男子都要缴付赎价给耶和华，赎回自己的性命，免得在统计人口期间发生灾祸。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","凡被统计的人都要付六克银子，即十季拉，以圣所的秤为准，作为献给耶和华的礼物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","凡被统计的，年龄在二十岁以上的男子都要献此礼物给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","富有的不用多缴，贫穷的也不可少付，每个人都要献六克银子给耶和华，用来赎自己的性命。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","要向以色列人收赎命的款项，供会幕使用，可以使以色列人在耶和华面前蒙眷顾，赎性命。” ");
INSERT INTO cmncbs_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“你用铜造一个洗濯盆和盆座，放在会幕和祭坛之间，盆里盛着水， ");
INSERT INTO cmncbs_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","供亚伦父子们洗手洗脚， ");
INSERT INTO cmncbs_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","他们进会幕或到坛前给耶和华献火祭之前，一定要用水洗濯才可以供职，免得死亡。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","他们要洗手洗脚，免得死亡，这是亚伦及其子孙世代当守的永久律例。” ");
INSERT INTO cmncbs_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“要用上等的香料，就是没药汁六公斤、香肉桂和菖蒲各三公斤、 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","肉桂皮六公斤，都按圣所的秤为准，再加上橄榄油四升， ");
INSERT INTO cmncbs_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","按着调制香料的方法制作圣膏油。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","要用这些膏油来抹会幕、约柜、 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","桌子和桌上所有的器具、灯台和灯台上的器具、香坛、 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","燔祭坛和坛上所有的器具、洗濯盆和盆座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","你要使这一切圣洁，成为至圣之物。凡碰到它们的都会圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“你也要用这油来膏亚伦父子们，使他们分别出来，做圣洁的祭司事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","你要把我的话告诉以色列百姓，‘我要世世代代以这油为圣膏油。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","不要把这膏油用在普通人身上，也不可仿制，因为这是圣膏油，你们也要视之为圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","任何人若仿制或用这油抹祭司以外的人，要将他从民中铲除。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","耶和华对摩西说：“要取各种芬芳的香料，就是苏合香、香螺、白松香和纯乳香，分量相同， ");
INSERT INTO cmncbs_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","用调制香料的方法调制，加上盐，做成纯净圣洁的香。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","你们要把一些香捣成极细的粉末，放在会幕内的约柜前面，就是我与你会面的地方，你们要视这香为至圣之物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","你们不可用同样的配方为自己做香，要视它为耶和华的圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","任何人若仿制这香，自己拿来私用，必从民中被铲除。” ");
INSERT INTO cmncbs_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“看啊，我已经亲自在犹大支派中选出户珥的孙子、乌利的儿子比撒列， ");
INSERT INTO cmncbs_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","用我的灵充满他，使他有聪明智慧，精于各种技能和手艺， ");
INSERT INTO cmncbs_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","能用金、银和铜制造精巧的器具， ");
INSERT INTO cmncbs_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","又能雕刻和镶嵌宝石，精通木工和各种手艺。 ");
INSERT INTO cmncbs_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","我委派但支派亚希撒抹的儿子亚何利亚伯做他的助手。至于其他能工巧匠，我已赐给他们智慧，好照我对你的吩咐制造一切器具， ");
INSERT INTO cmncbs_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","即会幕、约柜和约柜上面的施恩座、会幕里面所有的器具、 ");
INSERT INTO cmncbs_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","桌子和桌上的器具、纯金的灯台和灯台的一切器具、香坛、 ");
INSERT INTO cmncbs_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","燔祭坛和坛上的一切器具、洗濯盆和盆座， ");
INSERT INTO cmncbs_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","还有精工制作的礼服，即亚伦祭司的圣衣及其众子供祭司之职时穿的礼服， ");
INSERT INTO cmncbs_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","以及膏油和圣所使用的芬芳的香。他们要照我对你的吩咐去做。” ");
INSERT INTO cmncbs_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“你要吩咐以色列百姓务必守我的安息日，因为这是我与你们之间世世代代的记号，叫你们知道使你们圣洁的是我耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","你们要守安息日，以它为圣日。凡不守这日的，必被处死。凡在这天工作的，必从民中被铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","一周要工作六天，第七天是完全休息的安息日，是耶和华的圣日。凡在安息日做工的，必被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","因此，以色列人世世代代都要守安息日，作为永久的约， ");
INSERT INTO cmncbs_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","这是我和以色列人之间永久的记号。因为耶和华用六天的时间创造天地，在第七天停工休息。” ");
INSERT INTO cmncbs_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","耶和华在西奈山对摩西说完这些话以后，就把自己用指头刻上诫命的两块石版交给摩西。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","百姓见摩西迟迟没有下山，就聚集到亚伦那里，对他说：“带我们出埃及的那个摩西不知怎样了，你给我们造神像来带领我们吧。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","亚伦对他们说：“你们去摘下妻子、儿女的金耳环，拿来给我。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","百姓就都摘下金耳环交给亚伦。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","亚伦接过这些金耳环，用它们铸造了一头牛犊。他们说：“以色列人啊，这就是带你们出埃及的神明。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","亚伦见状便在牛犊前面筑了一座坛，然后宣告说：“明天是耶和华定的节期。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","第二天清晨，百姓都上前来献燔祭和平安祭，献完祭后就坐下吃喝，起来狂欢。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","耶和华对摩西说：“你下山吧，你的百姓，就是你从埃及领出来的那些人已经败坏了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","他们这么快就偏离了我吩咐他们走的道路，为自己造了一头牛犊来叩拜献祭，说，‘以色列人啊，这就是带你们出埃及的神明。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","耶和华又说：“我看到了，这些百姓真是顽固不化。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","你不要阻止我，我要向他们发烈怒，毁灭他们。我要使你成为大国。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","摩西恳求他的上帝耶和华说：“耶和华啊，你为什么要向你的子民发烈怒呢？这些子民是你亲自用神迹和大能从埃及领出来的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","难道你要让埃及人议论说你领他们出来是出于恶意，是为了在山野之间杀掉他们，从地上灭绝他们吗？求你息怒，施怜悯，不要降祸给你的子民。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","求你顾念你的仆人亚伯拉罕、以撒和以色列，你曾凭自己向他们起誓说，‘我必使你们的后代像天上的星星那么多。我应许给你们后代的这整片土地，我必赐给他们作永远的产业。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","耶和华听了摩西的话，就施怜悯，不把所说的灾祸降在百姓身上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","摩西转身下山，手里拿着两块约版，约版的正反两面都有字。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","石版是上帝做的，字是上帝刻的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","约书亚听见山下百姓嘈杂的喊叫声，便对摩西说：“营地里有打仗的声音。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","摩西对他说：“这不是打胜仗的声音，也不是打败仗的声音，而是歌唱的声音。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","摩西走近营地的时候，看见牛犊，又看见百姓在跳舞，心中大怒，便把手上的两块石版摔碎在山脚下， ");
INSERT INTO cmncbs_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","又焚烧他们铸造的牛犊，把它磨成粉末撒在水面上，叫以色列百姓喝。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","摩西对亚伦说：“这些百姓对你做了什么？你竟使他们陷入大罪中！” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","亚伦回答说：“求我主不要动怒，你知道这些人专门作恶。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","他们对我说，‘为我们造神明来带领我们吧，因为带我们出埃及的那个摩西不知怎样了。’ ");
INSERT INTO cmncbs_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","于是，我吩咐他们摘下金耳环给我，我把这些金耳环扔进火里，这头牛犊就出来了。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","摩西见百姓放肆，亚伦纵容他们，使他们成为敌人的笑柄， ");
INSERT INTO cmncbs_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","便站在营门口对会众说：“凡跟从耶和华的，都站到我这边来。”所有的利未人都聚集到摩西身边。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","摩西对他们说：“以色列的上帝耶和华这样说，‘你们各人带着刀，从这个门到那个门，走遍整个营，不论遇见的是兄弟、伙伴还是邻居，只管杀他们。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","利未人便照摩西的话去做。那一天，约有三千人被杀。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","摩西对利未人说：“今天你们已经把自己奉献给耶和华了，因为你们大义灭亲，祂今天必赐福给你们。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","第二天，摩西对百姓说：“你们犯了大罪，我现在要到耶和华那里，也许可以为你们赎罪。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","摩西回到耶和华那里，说：“唉，百姓犯了大罪，用金子为自己造了神像。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","恳求你赦免他们的罪，不然请你从你的册子上抹掉我的名字吧。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","耶和华对摩西说：“谁得罪我，我就从我的册子上抹掉谁的名字。 ");
INSERT INTO cmncbs_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","你现在回去带领这些百姓，往我指示你的地方去，我的天使必在你前面引路。只是到我惩罚的日子，我必因他们的罪惩罚他们。” ");
INSERT INTO cmncbs_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","耶和华击杀百姓，是因为他们曾与亚伦一起造牛犊。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","耶和华对摩西说：“现在你和你从埃及领出来的百姓要离开这里，去我向亚伯拉罕、以撒和雅各起誓要赐给他们后代的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","我必差遣天使走在你们前面，赶出当地的迦南人、亚摩利人、赫人、比利洗人、希未人和耶布斯人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","你们要去那奶蜜之乡。但我不会跟你们一起去，免得我在途中就把你们灭绝了，因为你们是顽固不化的百姓。” ");
INSERT INTO cmncbs_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","百姓听见这坏消息，都非常哀伤，不再佩戴饰物了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","耶和华对摩西说：“你去向以色列百姓宣布，‘你们这些顽固不化的人，我就是跟你们在一起待一刻，都恐怕会灭绝你们。现在你们要摘下自己身上的饰物，我再决定怎样处置你们。’” ");
INSERT INTO cmncbs_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","因此，以色列百姓从何烈山开始就不再佩戴饰物了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","摩西通常把帐幕支搭在营外离百姓较远的地方，摩西称帐幕为会幕。凡求问耶和华的，都会去那里。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","当摩西离营去会幕的时候，百姓就都一同起来，各人站在自己的帐篷门口目送摩西走进会幕。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","摩西进入会幕后，便有云柱降下来，停在会幕门口，耶和华就跟摩西说话。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","百姓一看见云柱停在会幕门口，就都站在自己的帐篷门口敬拜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","耶和华跟摩西面对面说话，好像两个朋友谈话一样。然后，摩西返回营中，但他的年轻助手、嫩的儿子约书亚仍然留在会幕。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","摩西对耶和华说：“你吩咐我带领这些百姓，却没有告诉我你将要派谁与我同去，只说，‘我凭名字认识你，你在我面前蒙了恩。’ ");
INSERT INTO cmncbs_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","我若已经在你面前蒙恩，就求你把你的道路指示我，好让我认识你，继续在你面前蒙恩。求你顾念这民族是你的子民。” ");
INSERT INTO cmncbs_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","耶和华回答他说：“我必亲自与你同去，使你平安稳妥。” ");
INSERT INTO cmncbs_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","摩西说：“你若不与我们同去，就不要带我们离开这里。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","你若不与我们同去，谁会知道我和你的子民在你面前蒙了恩呢？岂不是因为你的同在，才使我们不同于地上其他民族吗？” ");
INSERT INTO cmncbs_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","耶和华回答说：“我答应你的请求，因为你在我面前蒙了恩，我凭名字认识你。” ");
INSERT INTO cmncbs_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","摩西说：“求你向我彰显你的荣耀。” ");
INSERT INTO cmncbs_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","耶和华说：“我必叫你看见我一切的美善，我要在你面前宣告我的名耶和华，我要恩待谁就恩待谁，我要怜悯谁就怜悯谁。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","但你不能看我的脸，因为凡看见的人，都不能存活。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","你要站在我旁边的磐石上， ");
INSERT INTO cmncbs_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","我的荣耀经过你面前的时候，我会先把你安置在石缝里，用我的手遮掩你，直到我从你面前走过。 ");
INSERT INTO cmncbs_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","然后我会收回我的手，你就可以看见我的背，但看不到我的脸。” ");
INSERT INTO cmncbs_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","耶和华对摩西说：“你要凿出两块石版，跟你之前摔碎的两块一样，我要把前两块石版上的字刻在上面。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","明天清早你要预备好，你要上西奈山顶来见我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","谁也不可与你同来，整座山上都不可有人，就是牛羊也不得在山前吃草。” ");
INSERT INTO cmncbs_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","于是，摩西凿出两块石版，与前两块一样。他清早起来，照着耶和华的吩咐拿着两块石版上了西奈山。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","耶和华在云中降临和摩西一同站在那里，宣告祂的名耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","耶和华在摩西面前经过，并且宣告说：“我是耶和华，我是耶和华，是有怜悯和恩典的上帝，不轻易发怒，充满慈爱，无比信实， ");
INSERT INTO cmncbs_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","向千万代彰显慈爱，赦免罪愆、过犯和罪恶，但决不免除罪责，必向子孙追讨父辈的罪债，直到三四代。” ");
INSERT INTO cmncbs_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","摩西急忙俯伏在地上敬拜， ");
INSERT INTO cmncbs_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","说：“主啊，如果我在你面前蒙了恩，求你与我们同行。虽然百姓顽固不化，求你赦免我们的过犯和罪恶，接纳我们做你的产业。” ");
INSERT INTO cmncbs_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","耶和华说：“我要与你立约，我要在你所有的百姓面前行奇事，是天下万国从未有过的奇事，你周围的外族人必看见我为你做的可畏之事。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","你要遵行我今天的吩咐。我必从你面前赶走亚摩利人、迦南人、赫人、比利洗人、希未人和耶布斯人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","你要谨慎，到了目的地后，不可与当地的居民立约，免得因此而陷入网罗。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","相反，要拆掉他们的祭坛，打碎他们的神柱，砍下他们的亚舍拉神像。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","不可拜别的神明，因为耶和华是痛恨不贞的上帝，祂名为‘痛恨不贞’。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“不可与当地的居民立约，免得他们与自己的神明苟合献祭时邀请你，你就吃他们的祭物， ");
INSERT INTO cmncbs_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","给儿子娶他们的女儿为妻，以致她们与自己的神明苟合时诱使你的儿子犯同样的罪。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“不可为自己铸造神像。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“要守除酵节，照我的吩咐在亚笔月所定的时间吃七天的无酵饼，因为你是在亚笔月离开埃及的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“凡是头胎生的都属于我，包括牲畜中一切头胎生的公牛和公羊。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","头胎生的驴要用羊赎回，如果不用羊赎回，就要打断它的脖子。凡头胎生的男婴，都要赎回他的性命。谁也不可空手来朝见我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“一周工作六天，第七天要休息，就是耕种和收割时也要休息。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“在收割初熟麦子的时候，要守七七收获节，年底要守收藏节。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","所有的男子都要每年三次朝见主耶和华——以色列的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","我要从你面前赶走外族人，扩张你的领土。你一年三次朝见你的上帝耶和华时，必没有人贪恋你的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“不可把祭牲的血和有酵的饼一起献给我，也不可把逾越节的祭物留到早晨。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“要把田中最好的初熟之物送到你们的上帝耶和华的殿中。 “不可用母山羊的奶煮它的小羊羔。” ");
INSERT INTO cmncbs_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","耶和华又对摩西说：“你要把我说的这些话记录下来，因为我要按这些话跟你和以色列人立约。” ");
INSERT INTO cmncbs_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","摩西在耶和华那里待了四十昼夜，不吃也不喝。耶和华把约的内容，就是十条诫命，写在石版上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","摩西手里拿着两块约版下西奈山，他不知道自己因为曾与耶和华说话而脸上发光。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","亚伦和所有的以色列百姓看见摩西脸上发光，都不敢走近他。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","摩西召他们过来，亚伦和会众的首领便上前来。摩西与他们说话。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","之后，所有的以色列人都来到他面前，他就把耶和华在西奈山上的吩咐都告诉他们。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","说完之后，他就用帕子遮住自己的脸。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","他每次进到会幕跟耶和华说话时，就揭开帕子，出来后便把耶和华的吩咐告诉以色列百姓。 ");
INSERT INTO cmncbs_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","百姓看到他脸上发光，他就再用帕子遮住脸，直到下次进去与耶和华说话的时候才揭开。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","摩西招聚以色列全体会众，对他们宣布说：“以下是耶和华吩咐你们遵守的事。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","一周可以工作六天，但第七天是你们为耶和华守的圣日，是完全休息的安息日。凡在这一天工作的，必被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","在安息日，你们的任何住处都不可生火。” ");
INSERT INTO cmncbs_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","摩西对以色列全体会众说：“以下是耶和华给你们的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","“你们要献物品给耶和华。凡慷慨乐捐的，都可以把下列物品献给耶和华为礼物，即金、银、铜， ");
INSERT INTO cmncbs_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","蓝色、紫色和朱红色毛线，细麻，山羊毛， ");
INSERT INTO cmncbs_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","染成红色的公羊皮，海狗皮，皂荚木， ");
INSERT INTO cmncbs_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","灯油，制作膏油和香的香料， ");
INSERT INTO cmncbs_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","镶嵌在以弗得和胸牌上的红玛瑙及其他宝石。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“你们当中的能工巧匠都要来建造耶和华所吩咐的物件， ");
INSERT INTO cmncbs_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","即圣幕和圣幕的罩棚、顶盖、钩子、木板、横闩、柱子和带凹槽的底座； ");
INSERT INTO cmncbs_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","约柜和抬约柜的横杠、施恩座和遮掩约柜的幔子； ");
INSERT INTO cmncbs_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","桌子和抬桌子的横杠、桌上的一切器具和供饼； ");
INSERT INTO cmncbs_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","灯台和灯台用的器具、灯盏和灯油； ");
INSERT INTO cmncbs_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","香坛和抬香坛的横杠、膏油和芬芳的香；圣幕门口的帘子； ");
INSERT INTO cmncbs_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","燔祭坛、祭坛的铜网、抬祭坛的横杠、祭坛用的一切器具、洗濯盆和盆座； ");
INSERT INTO cmncbs_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","院子的帷幔、悬挂幔子的柱子和底座、院子入口的门帘； ");
INSERT INTO cmncbs_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","圣幕及院子用的橛子和绳子； ");
INSERT INTO cmncbs_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","在圣所供职时穿的精制礼服、亚伦祭司的圣衣及其众子供祭司之职时穿的衣服。” ");
INSERT INTO cmncbs_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","之后，以色列全体会众便从摩西面前退去。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","凡心里有感动又甘愿奉献的，都把礼物拿来献给耶和华，作会幕、会幕中的一切器具及圣衣之用。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","凡甘心奉献的，不论男女，都把别针、耳环、戒指、项链等各样金饰拿来献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","凡有蓝色、紫色和朱红色毛线，细麻，山羊毛，染成红色的公羊皮，海狗皮的，都把它们拿来了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","凡奉献银器和铜器的，都拿来献给耶和华。凡有皂荚木的，只要用得上，都拿来奉献。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","凡善于纺线的妇女，都把亲手纺成的细麻和蓝色、紫色、朱红色毛线拿来奉献。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","凡心里受感动又善于纺织的妇女都来纺山羊毛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","众首领奉献了红玛瑙和其他宝石，用来镶嵌在以弗得和胸牌上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","他们又献出香料和油，用来做香、点灯、做膏油。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","以色列人，不论男女、凡是甘心乐意奉献的，都把礼物带来献给耶和华，好完成耶和华借摩西吩咐他们的一切工作。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","摩西对以色列人说：“看啊，耶和华已经亲自在犹大支派中选出户珥的孙子、乌利的儿子比撒列， ");
INSERT INTO cmncbs_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","上帝的灵已经充满他，使他有聪明智慧，精于各种技能和手艺， ");
INSERT INTO cmncbs_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","能用金、银和铜制造精巧的器具， ");
INSERT INTO cmncbs_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","又能雕刻和镶嵌宝石，精通木工和各种手艺。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","耶和华又使他与但支派亚希撒抹的儿子亚何利亚伯有能力教授别人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","耶和华使他们成为能工巧匠，精通各样技艺，包括雕刻、图案设计、纺织，以及用细麻和蓝色、紫色、朱红色毛线刺绣。” ");
INSERT INTO cmncbs_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","摩西说：“比撒列、亚何利亚伯以及所有蒙耶和华赐智慧聪明、有技能、懂得如何建造圣所的人，都要按照耶和华的吩咐去做。” ");
INSERT INTO cmncbs_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","于是，摩西召来比撒列、亚何利亚伯和所有蒙耶和华赐智慧、有技能、愿意参与建造的人。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","他们从摩西那里领取了以色列百姓奉献出来建造圣所的一切礼物。每天早上，百姓仍然甘心乐意地来奉献礼物， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","以致所有建造圣所的能工巧匠都放下自己的工作， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","前来对摩西说：“百姓的奉献太多了，我们建造耶和华吩咐的圣所用不了。” ");
INSERT INTO cmncbs_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","于是，摩西传令全营：“男女都不用再为圣所奉献礼物了。”百姓这才停止奉献。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","因为所献的材料已经足够建造圣所，而且绰绰有余。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","工人中的能工巧匠用十幅幔子做成了圣幕，幔子用细麻和蓝色、紫色、朱红色毛线织成，上面精工绣制了基路伯天使。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","每幅幔子的尺寸都一样，长十二米半、宽一米八。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","又把每五幅幔子连在一起，共连成两幅大幔子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","然后在每幅大幔子末幅的边缘钉上了蓝色的扣环， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","每幅大幔子各钉上五十个扣环，都是两两相对。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","又做了五十个金钩，把两幅大幔子连在一起，成为一个完整的圣幕。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","比撒列用山羊毛织成十一幅幔子，做圣幕的罩棚， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","每幅长十三米半、宽一米八。十一幅幔子的尺寸都一样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","然后把五幅连成一大幅，其余六幅连成一大幅。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","又在这两幅大幔子边缘各钉上五十个对称的扣环， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","再用五十个铜钩，把两幅大幔子连在一起，成为一个完整的罩棚， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","并在罩棚上面盖一层染成红色的公羊皮，再盖一层海狗皮做顶盖。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","他用皂荚木做支圣幕的木板， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","每块木板长四米半，宽七十厘米， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","上面都有两个接榫，用来衔接。圣幕的所有木板都这样做。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","圣幕的南面立二十块木板， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","在这些木板下面又造了四十个带凹槽的银底座，每块木板下面有两个，套在木板的两个接榫上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","圣幕北面也立二十块木板， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","木板下面同样有四十个带凹槽的银底座，每块木板下面有两个银底座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","圣幕后面，就是西面，立六块木板， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","圣幕后面的两个拐角各有一块木板， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","木板的下端连于底座，顶端用一个环固定。两个拐角都这样做。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","这样，后面共有八块木板，每块木板下面各有两个带凹槽的银底座，一共有十六个银底座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","他用皂荚木做横闩，圣幕左右两边和后面的墙板上各有五根横闩， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","拦腰固定墙板的那根横闩从这端贯穿到那端。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","所有的木板和横闩都包上金，并在木板上造金环，用来穿横闩。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","他用细麻和蓝色、紫色、朱红色毛线织成一幅幔子，上面精工绣上基路伯天使， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","把这幅幔子挂在四根包金的皂荚木柱上，木柱上有金钩，四根柱子下面有四个银底座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","他又用细麻和蓝色、紫色、朱红色毛线绣制圣幕的门帘， ");
INSERT INTO cmncbs_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","用皂荚木做五根挂门帘的柱子，上面有金钩，柱顶和箍包上金。柱子的五个带凹槽的底座是铜造的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","比撒列用皂荚木造了一个柜，长一米一，宽七十厘米，高七十厘米。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","这柜子里外都包上纯金，还镶了一圈金边。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","他造了四个金环，安在柜的四个脚上，每边两个环， ");
INSERT INTO cmncbs_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","又用皂荚木造了两根横杠，包上金， ");
INSERT INTO cmncbs_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","然后把横杠穿过柜两边的金环，便于抬柜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","他用纯金造了一个施恩座，长一米一，宽七十厘米。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","又用金子在施恩座的两端打造两个基路伯天使。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","这两个基路伯天使跟施恩座连在一起，在施恩座的两端， ");
INSERT INTO cmncbs_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","面对面朝向施恩座，向上展开翅膀遮盖施恩座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","他用皂荚木造了一张桌子，长九十厘米，宽四十五厘米，高七十厘米。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","整张桌子都包上纯金，四周镶上金边。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","在桌子四周造一个八厘米宽的外框，外框镶上金边。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","他又造四个金环，安在桌子四角的桌腿上， ");
INSERT INTO cmncbs_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","金环靠近外框，以便穿横杠抬桌子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","他用皂荚木造两根横杠，外面包金，用来抬桌子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","又用纯金造桌子上的器具，就是盘、碟及献酒用的杯和瓶。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","他用纯金造了一座灯台，灯台的灯座、灯柱、油杯、花瓣和花萼都是用一块纯金打成的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","灯台两边各伸出三个分枝，共六个分枝。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","每个分枝上都有三个杏花形状、有花瓣和花萼的杯，六个分枝都是这样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","灯台上有四个杏花形状、有花瓣和花萼的杯。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","灯台上每一对分枝的相连处有花萼，三对分枝都是这样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","整座灯台，包括花萼和分枝，都是用一块纯金打成的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","他又用纯金为这座灯台造了七个灯盏，以及灯剪和灯花盘。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","造整座灯台和灯台的器具共用了六百八十两纯金。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","他又用皂荚木造了一座方形的香坛，长宽各四十五厘米，高九十厘米，坛上面凸起的四角与坛连成一体， ");
INSERT INTO cmncbs_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","坛顶、坛的四面和坛上凸起的角包上纯金，四周镶上金边。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","他造了两个金环，安在坛两侧的金边下面， ");
INSERT INTO cmncbs_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","又用皂荚木造横杠，包上金，穿在两个环里，用来抬香坛。 ");
INSERT INTO cmncbs_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","他又用调制香料的方法制作圣膏油和纯净芬芳的香。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","比撒列用皂荚木造了方形的燔祭坛，长宽各两米二，高一米三， ");
INSERT INTO cmncbs_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","在坛的四角造四个凸起的角，与坛连成一体，坛外面包上铜。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","他用铜造祭坛用的一切器具，就是锅、铲、碗、肉叉、火鼎。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","又造了一个铜网，铜网在祭坛围边的下方，向下伸展到祭坛的腰部， ");
INSERT INTO cmncbs_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","在铜网的四角铸四个铜环，以便穿横杠。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","他用皂荚木做横杠，包上铜， ");
INSERT INTO cmncbs_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","把横杠穿在坛两旁的铜环里，以便抬坛。坛是中空的，用木板制作。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","他用在会幕门口服侍的妇女们的铜镜造铜盆和盆座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","他用帷幔围成院子，院子南面的帷幔用细麻织成，长四十五米。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","帷幔有二十根柱子，二十个带凹槽的铜底座，柱子上的钩和箍都是银的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","北面的帷幔也是长四十五米，柱子、铜底座、钩和箍的样式都与南面的一样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","西面的帷幔宽二十二米半，有十根柱子和十个带凹槽的底座，钩和箍都是银的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","东面的帷幔也是宽二十二米半。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","入口两边的帷幔都是宽七米，各有三根柱子和三个带凹槽的底座。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","院子四面的帷幔都用细麻织成。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","柱子带凹槽的底座是铜的，柱子上面的钩和箍是银的，柱顶包银，院子所有的柱子都有银箍。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","院子入口的门帘用细麻和蓝色、紫色、朱红色毛线绣制，长九米、高两米二，与院子帷幔的高度一样。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","门帘有四根柱子和四个带凹槽的铜底座，柱子上的钩和箍都是银的，柱顶包银。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","圣幕和院子四围所有的橛子都是铜的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","以上是安放约柜的圣幕中所用的物品，是照摩西的吩咐，由亚伦祭司的儿子以他玛指挥利未人清点的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","犹大支派户珥的孙子、乌利的儿子比撒列做好了耶和华吩咐摩西预备的一切物品。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","他的助手是但支派亚希撒抹的儿子亚何利亚伯，是雕刻家和设计师，并善用细麻和蓝色、紫色、朱红色毛线刺绣。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","按圣所的秤计算，建造圣所共用了奉献的金子两万两。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","按圣所的秤计算，从登记的人口所收到的银子是六万八千四百两。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","这是所有登记的、年龄在二十岁以上的人所缴纳的银子，共有六十万三千五百五十人，每人交六克银子，以圣所的秤为准。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","铸造圣所带凹槽的底座和帷幔柱子带凹槽的底座共用了六万八千两银子，共铸造了一百个底座，每个底座用了六百八十两银子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","剩下的四百两银子用来制造柱子上的钩和箍以及包柱顶。 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","百姓奉献的铜共有两千四百公斤， ");
INSERT INTO cmncbs_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","用来制造会幕入口带凹槽的底座、祭坛、坛上的铜网及一切器具、 ");
INSERT INTO cmncbs_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","院子周围和院子入口带凹槽的底座以及圣幕、院子周围所有的橛子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","比撒列等人按照耶和华对摩西的吩咐，用蓝色、紫色、朱红色毛线精工制作在圣所供职时穿的礼服，又为亚伦做圣衣。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","他们用金线、细麻及蓝色、紫色、朱红色毛线精工制作以弗得， ");
INSERT INTO cmncbs_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","把金子打成薄片，剪成细线，与细麻和蓝色、紫色、朱红色毛线巧妙地织在一起。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","他们做了两条肩带，固定在以弗得两边，用来连接以弗得。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","又按耶和华对摩西的吩咐，照以弗得的做法用金线、细麻及蓝色、紫色、朱红色毛线精工制作腰带，缝在以弗得上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","他们选了两块红玛瑙，用刻图章的方法刻上以色列十二个儿子的名字，镶在两个金框里， ");
INSERT INTO cmncbs_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","再缝在以弗得的两条肩带上，作以色列人的纪念石。这些都是照耶和华对摩西的吩咐做的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","他们精工制作胸牌，像造以弗得一样用金线、细麻及蓝色、紫色、朱红色毛线制作。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","胸牌是方形的，叠成两层，长宽各二十二厘米。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","上面镶上四行宝石：第一行是红宝石、黄玉和翠玉； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","第二行是绿宝石、蓝宝石和金刚石； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","第三行是紫玛瑙、白玛瑙和紫晶； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","第四行是水苍玉、红玛瑙和碧玉。这些宝石都镶在胸牌的金框上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","他们用刻图章的方法在每一颗宝石上刻一个以色列儿子的名字，十二颗宝石代表以色列十二支派。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","他们用纯金拧成两条像绳子一样的链子，连在胸牌上， ");
INSERT INTO cmncbs_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","又造两个金框和两个金环，把金环安在胸牌两端。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","把两条金链分别系在胸牌两端的金环上， ");
INSERT INTO cmncbs_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","又把两条金链的另两端接在两个金框上，安在以弗得前面的肩带上。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","又造了两个金环，安在靠近以弗得内边的胸牌下两端。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","又造了两个金环，安在以弗得前面两条肩带下端，靠近精致的以弗得腰带上方的接缝处。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","用一条蓝色的带子系住以弗得和胸牌上面的金环，使胸牌贴在精工织成的以弗得腰带上，不会从以弗得上松脱。这些都是照耶和华对摩西的吩咐做的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","以弗得的外袍用纯蓝色的线织成， ");
INSERT INTO cmncbs_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","上面有领口，领口周围织领边，就像铠甲上的领口，免得领口破裂。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","外袍的底边用细麻和蓝色、紫色、朱红色毛线做成石榴状的饰物， ");
INSERT INTO cmncbs_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","又造纯金的铃铛挂在外袍底边的石榴间， ");
INSERT INTO cmncbs_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","一个石榴一个金铃铛，相间排列，围在外袍的底边。这件外袍是祭司供职时穿的，正如耶和华对摩西的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","他们用细麻布为亚伦父子们缝制内袍、 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","礼冠、头巾和裤子， ");
INSERT INTO cmncbs_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","还用细麻和蓝色、紫色、朱红色毛线绣制腰带。这是照耶和华对摩西的吩咐做的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","又用纯金造了牌子，就是圣冠，上面用刻印章的方法刻上“耶和华的圣物”的字样， ");
INSERT INTO cmncbs_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","然后用一条蓝色带子把它系在礼冠上。这些都是照耶和华对摩西的吩咐做的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","圣幕，就是会幕的工作就这样全部完成了，都是以色列人照耶和华对摩西的吩咐做的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","他们把圣幕和圣幕的各样器具都送到摩西那里，即钩子、木板、横闩、柱子和带凹槽的底座； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","海狗皮顶盖、遮掩约柜的幔子、染成红色的公羊皮盖； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","约柜、抬约柜的横杠、施恩座； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","桌子、桌上的一切器具和供饼； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","纯金的灯台、灯盏、灯台的一切器具、灯油； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","金坛、膏油、芬芳的香；会幕的门帘； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","铜祭坛、祭坛的铜网、抬祭坛的横杠、祭坛用的一切器具、洗濯盆和盆座； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","院子的帷幔、柱子、带凹槽的底座、院子入口的门帘、绳子、橛子和会幕，即圣幕所需的一切器具； ");
INSERT INTO cmncbs_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","在圣所供职时穿的精制礼服、亚伦祭司的圣衣及其众子供祭司之职时穿的衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","这一切都是以色列人照耶和华对摩西的吩咐做的。 ");
INSERT INTO cmncbs_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","摩西察看这一切工作，见他们都是按照耶和华的吩咐做的，就给他们祝福。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“你要在一月一日支起圣幕，即会幕， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","把约柜安置在里面，用幔子遮掩。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","把桌子搬进去，摆好桌上的器具，再把灯台搬进去，点上灯， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","把烧香的金香坛放在约柜前面，挂上圣幕入口的帘子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","要把燔祭坛放在圣幕门口前面， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","洗濯盆放在会幕和祭坛中间，盆里要有水。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","用帷幔在圣幕四周围成院子，在院子的入口挂上帘子。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","你要用膏油抹圣幕和里面所有的器具，使它们分别出来，成为圣洁之物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","要抹燔祭坛和坛上所有器具，使燔祭坛分别出来，成为至圣之物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","要抹洗濯盆和盆座，使它们分别出来，成为圣洁之物。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","要把亚伦父子们叫到会幕入口，用水为他们沐浴， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","给亚伦穿上圣衣并膏立他，使他分别出来，做圣洁的祭司事奉我。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","也要把他的儿子们叫来，给他们穿上内袍， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","用同样的仪式膏立他们，使他们做祭司事奉我。他们的受膏将使他们永远做祭司，世代相传。” ");
INSERT INTO cmncbs_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","摩西照耶和华的吩咐把事情都办好了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","第二年一月一日，圣幕支起来了。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","摩西支起圣幕，装上带凹槽的底座，竖起木板，插上横闩，立起柱子， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","在圣幕上面搭起罩棚，铺上顶盖，都遵照耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","摩西把约版放在约柜里，横杠穿在约柜的两旁，施恩座放在约柜上， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","把约柜抬进圣幕，挂起幔子遮掩约柜，都遵照耶和华对他的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","他把桌子放在会幕内、遮掩约柜的幔子外面、圣幕的北侧， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","将献给耶和华的供饼放在桌上，都遵照耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","他把灯台放在会幕内的桌子对面，在圣幕的南侧， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","然后在耶和华面前点灯，都遵照耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","他把金坛放在会幕里、遮掩约柜的幔子前面， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","在坛上点燃芬芳的香，都遵照耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","他挂上圣幕入口的帘子， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","在会幕，即圣幕入口前面设立燔祭坛，在坛上献燔祭和素祭，都遵照耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","他把洗濯盆放在会幕和祭坛之间，盆里盛水，供洗濯用。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","摩西、亚伦及其众子都在盆里清洗手脚， ");
INSERT INTO cmncbs_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","他们进会幕或走近祭坛的时候，都要先清洗，都遵照耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","摩西又在圣幕和祭坛的四周用帷幔围成院子，然后在院子入口挂上帘子。这样，摩西完成了工作。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","那时，有云彩遮盖会幕，耶和华的荣光充满了圣幕。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","摩西不能进会幕，因为云彩停在上面，耶和华的荣光充满了圣幕。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","一路上，云彩从圣幕上升起，他们就出发。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","云彩不升起，他们就不出发，一直等到云彩升起。 ");
INSERT INTO cmncbs_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","一路上，白天有耶和华的云彩停留在圣幕上面，夜间云中有火光照在以色列百姓眼前。");
INSERT INTO cmncbs_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","耶和华在会幕里呼唤摩西，对他说： ");
INSERT INTO cmncbs_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“你把以下条例告诉以色列人。 “如果你们有人献祭给耶和华，要用牛羊作祭物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","如果用牛作燔祭，必须用毫无残疾的公牛，在会幕门口献上，便可蒙耶和华悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","献祭者要把手放在燔祭牲的头上，所献的燔祭便蒙悦纳，为他赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","他要在耶和华面前宰牛，然后做祭司的亚伦子孙要把牛血洒在会幕门口的祭坛四周。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","献祭者要剥掉燔祭牲的皮，把它切成块。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","做祭司的亚伦子孙要在祭坛上生火，把木柴摆在火上， ");
INSERT INTO cmncbs_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","然后将肉块、头和脂肪都摆在祭坛燃烧的木柴上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","献祭者要用水洗净牛的内脏和腿。祭司要把这一切都放在坛上焚烧。这是燔祭，是蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“如果用绵羊或山羊作燔祭，必须用毫无残疾的公羊。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","献祭者要在祭坛北面，在耶和华面前宰羊。做祭司的亚伦子孙要把羊血洒在祭坛四周。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","献祭者将羊切成块后，祭司要把肉块、头和脂肪摆在祭坛燃烧的木柴上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","献祭者要用水洗净羊的内脏和腿。祭司要把这一切都放在坛上焚烧。这是燔祭，是蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“如果有人用鸟作燔祭献给耶和华，要用斑鸠或雏鸽。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","祭司要把鸟带到祭坛前，拧下鸟头，放在祭坛上焚烧；要在祭坛旁放尽鸟血； ");
INSERT INTO cmncbs_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","要除掉鸟的嗉子和羽毛，扔在祭坛东边倒灰的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","祭司要抓着两个翅膀把鸟撕开，但不可撕断，然后把鸟放在祭坛燃烧的木柴上焚烧。这是燔祭，是蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“如果有人献素祭给耶和华，要用细面粉作祭物。要在细面粉上浇油、加乳香， ");
INSERT INTO cmncbs_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","带到做祭司的亚伦子孙那里。祭司要抓一把浇了油的细面粉，连同所有乳香放在坛上焚烧，作为象征。这是蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","剩下的素祭要归亚伦及其子孙，这在献给耶和华的火祭中是至圣之物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“如果献用炉子烤的素祭，要献调油的无酵细面饼，或涂油的无酵薄饼。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“如果献用平底锅烤的素祭，要献调油的无酵细面饼。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","要把饼掰成碎块，浇上油。这是素祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“如果献用煎锅煎的素祭，要献用细面粉和油做的祭物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“要把这样做好的素祭带到耶和华面前，交给祭司献在祭坛上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","祭司要从中取出一部分，作为象征放在祭坛上焚烧。这是蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","剩下的素祭要归亚伦及其子孙。这在献给耶和华的火祭中是至圣之物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“献给耶和华的任何素祭都不可含酵，因为你们不可把酵或蜜当作火祭献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","你们可以把酵和蜜作为初熟之祭献给耶和华，但不可作为馨香之祭献在祭坛上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","所有素祭都要用盐调味，不可少了你们与上帝立约的盐。所有祭物中都要放盐。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“如果将初熟的谷物献给耶和华作素祭，要用烘好后压碎的新麦穗， ");
INSERT INTO cmncbs_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","加上油和乳香。这是素祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","祭司要将一些压碎的麦穗、油及所有乳香作为象征焚烧。这是献给耶和华的火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“如果有人用牛献作平安祭，必须在耶和华面前献上毫无残疾的公牛或母牛。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","献祭者要把手放在祭牲的头上，在会幕门口宰杀。做祭司的亚伦子孙要把牛血洒在祭坛四周。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","献祭者要从平安祭中献上火祭给耶和华。他要取出包裹内脏的脂肪和内脏上的脂肪、 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","两个肾脏和肾脏上靠近腰部的脂肪以及肝叶。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","亚伦的子孙要把这一切放在祭坛燃烧的木柴上和燔祭一起焚烧，作为蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“如果用羊作祭物向耶和华献平安祭，必须献毫无残疾的公羊或母羊。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","如果献的是绵羊羔，献祭者要把羊羔带到耶和华面前， ");
INSERT INTO cmncbs_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","将手放在祭牲的头上，在会幕前宰杀。亚伦的子孙要把羊羔的血洒在祭坛四周。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","献祭者要从平安祭中取出脂肪作为火祭献给耶和华。他要从靠近脊椎骨处取下整条肥尾巴、包裹内脏的脂肪、内脏上的脂肪、 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","两个肾脏和肾脏上靠近腰部的脂肪以及肝叶。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","祭司要把这一切放在祭坛上焚烧，作为献给耶和华的火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“如果献的是山羊，献祭者要把山羊带到耶和华面前， ");
INSERT INTO cmncbs_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","将手放在羊头上，在会幕门口宰杀。亚伦的子孙要把羊血洒在祭坛四周。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","15","献祭者要取出包裹内脏的脂肪和内脏上的脂肪、两个肾脏和肾脏上靠近腰部的脂肪以及肝叶，作为火祭献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","祭司要把这一切放在祭坛上焚烧，作为蒙耶和华悦纳的馨香火祭。所有的脂肪都属于耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","你们无论住在哪里，都不可吃脂肪和血，这是你们世代当守的永久律例。” ");
INSERT INTO cmncbs_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“你把以下条例告诉以色列人。 “如果有人无意中犯罪，触犯耶和华的任何诫命，要按以下方式献赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“若大祭司犯罪，祸及众民，他必须献给耶和华一头毫无残疾的公牛犊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","他要把公牛犊牵到会幕门口，将手放在牛头上，在耶和华面前宰牛。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","他要取一些公牛的血带进会幕里， ");
INSERT INTO cmncbs_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","在耶和华面前用手指蘸血向圣所的幔子弹洒七次， ");
INSERT INTO cmncbs_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","也要把一些公牛的血抹在耶和华面前的香坛凸起的四角上，再把剩下的血倒在会幕门口的燔祭坛脚。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","他要取出作赎罪祭的公牛犊的所有脂肪，即包裹内脏的脂肪和内脏上的脂肪、 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","两个肾脏和肾脏上靠近腰部的脂肪以及肝叶， ");
INSERT INTO cmncbs_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","正如取出平安祭牲的脂肪一样。他要将这一切放在燔祭坛上焚烧。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","至于公牛剩下的部分，即皮、所有的肉、头、腿、内脏和粪便，他要带到营外洁净之处，就是倒坛灰的地方，放在柴上焚烧。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“以色列全体会众若无意中触犯耶和华的任何诫命，即使没有意识到，也是犯罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","他们察觉自己犯罪后，必须献上一头公牛犊作赎罪祭。要将公牛犊带到会幕前， ");
INSERT INTO cmncbs_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","会众的长老要把手放在公牛的头上，在耶和华面前宰牛。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","大祭司要带一些牛血进入会幕， ");
INSERT INTO cmncbs_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","在耶和华面前用手指蘸血向幔子弹洒七次， ");
INSERT INTO cmncbs_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","也要把一些血抹在耶和华面前的香坛凸起的四角上，再把剩下的血倒在会幕门前的燔祭坛脚。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","他要取出公牛犊的所有脂肪，放在祭坛上焚烧， ");
INSERT INTO cmncbs_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","正如取出赎罪祭牲的脂肪一样。这样，祭司为全体会众赎了罪，他们就会得到赦免。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","他要把这公牛犊剩下的部分拿到营外焚烧，像焚烧前一头公牛犊一样。这是为全体会众所献的赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“首领若无意中触犯他上帝耶和华的任何诫命，也是犯罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","他察觉自己犯罪后，必须献上一只毫无残疾的公山羊作祭物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","他要把手放在羊头上，在杀燔祭牲的地方，在耶和华面前宰羊。这是他的赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","祭司要用手指蘸一些赎罪祭牲的血抹在燔祭坛凸起的四角上，再把剩下的血倒在燔祭坛脚。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","要像焚烧平安祭牲的脂肪一样，把羊的所有脂肪都放在坛上焚烧。这样，祭司为他赎了罪，他就会得到赦免。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“平民若无意中触犯耶和华的任何诫命，也是犯罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","他察觉自己犯罪后，必须献上一只毫无残疾的母山羊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","他要把手放在赎罪祭牲的头上，在杀燔祭牲的地方宰羊。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","祭司要用手指蘸一些羊血抹在燔祭坛凸起的四角上，再把剩下的血倒在燔祭坛脚。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","献祭者要像取出平安祭牲的脂肪一样，取出母山羊的所有脂肪。祭司要把这一切放在坛上焚烧，作为蒙耶和华悦纳的馨香之祭。这样，祭司为他赎了罪，他就会得到赦免。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“他若献绵羊作赎罪祭，必须献一只毫无残疾的母绵羊。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","他要把手放在羊头上，在杀燔祭牲的地方宰羊。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","祭司要用手指蘸一些羊血抹在燔祭坛凸起的四角上，再把剩下的血倒在燔祭坛脚。 ");
INSERT INTO cmncbs_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","献祭者要像取出平安祭牲的脂肪一样，取出母绵羊的所有脂肪。祭司要把这一切放在坛上，与献给耶和华的祭物一起焚烧。这样，祭司为他赎了罪，他就会得到赦免。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“如果有人当庭作证，却不肯把自己所知所见的说出来，就是犯罪，要担负罪责。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","如果有人接触了不洁净之物，如不洁净的野兽的尸体、家畜的尸体或爬虫的尸体，即使没有察觉也已不洁净，是有罪的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","如果有人无意中接触了别人的不洁之物，当他意识到后，就有罪了。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","如果有人草率起誓，不论出于善意还是恶意，即使当初没有察觉，后来才意识到，也是有罪的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","如果有人意识到自己犯了以上任何一种罪，就必须认罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","为了赎过，他必须献给耶和华一只母绵羊或母山羊作赎罪祭。祭司要为他赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“他若献不起羊，就要献给耶和华两只斑鸠或两只雏鸽，一只作赎罪祭，一只作燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","他要把它们带到祭司那里，祭司要先用一只鸟献赎罪祭，要扭断鸟脖子，但不可扯掉头。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","要把一些鸟血洒在祭坛边，再把剩下的血倒在坛脚。这是赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","祭司要依照献燔祭的条例献上另一只鸟。这样，祭司为他赎了罪，他就会得到赦免。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“他若献不起两只斑鸠或雏鸽，就要献一公斤细面粉作赎罪祭。细面粉中不可浇油或加乳香，因为这是赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","他要把细面粉带到祭司那里，祭司要从中取出一把作为象征放在坛上，与献给耶和华的火祭一起焚烧。这是赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","这样，祭司为他赎了罪，他就会得到赦免。剩下的细面粉要归祭司，像献素祭一样。” ");
INSERT INTO cmncbs_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“如果有人无意中干犯了耶和华圣物的条例，为了赎过，他要从羊群中选一只毫无残疾的公绵羊献给耶和华，或按圣所的秤献上同等价值的银子。这是赎过祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","他要赔偿所造成的损失，并加赔五分之一，要把这些都交给祭司。祭司要为他献上公绵羊作赎过祭，为他赎罪，他就会得到赦免。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“如果有人触犯耶和华的任何诫命，即使他不知道，也是犯罪，必须担当罪责。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","他要从羊群中选一只毫无残疾的公绵羊，或把同等价值的银子带到祭司那里作赎过祭。祭司要为他的无心之过赎罪，他就会得到赦免。 ");
INSERT INTO cmncbs_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","这是赎过祭，因为他在耶和华面前确实有罪。” ");
INSERT INTO cmncbs_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","3","“如果有人拒绝归还同胞委托他保管的物品或抵押品，或抢掠同胞，或欺骗同胞，或捡到失物却矢口否认，或起假誓，或犯其他类似的罪，因而失信于耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","一旦他意识到自己犯了罪，必须归还一切靠偷盗、欺诈、侵占、拾遗、 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","或起假誓得来的东西，他必须在献赎过祭那天如数归还物主，并加赔五分之一。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","他要从羊群中选一只毫无残疾的公绵羊，或把同等价值的银子带到祭司那里，献给耶和华作赎过祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","祭司要在耶和华面前为他赎罪，他的过犯就会得到赦免。” ");
INSERT INTO cmncbs_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“你要吩咐亚伦及其子孙遵行以下献燔祭的条例。 “燔祭要整夜留在祭坛上，坛上的火要不停地燃烧。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","早晨，祭司要穿上细麻衣袍和内衣，将燔祭坛上的灰烬清理好，放在祭坛旁边。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","然后，他要更换衣服，把灰烬拿到营外洁净的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","祭坛上的火要不断燃烧，不能熄灭。祭司每天早上要在坛上加柴，摆上燔祭，在上面烧平安祭牲的脂肪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","坛上的火必须不断燃烧，不可熄灭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“以下是献素祭的条例。 “亚伦的子孙要在祭坛前向耶和华献素祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","祭司要从素祭中拿一把调油的细面粉和所有的乳香，作为象征放在坛上焚烧，作蒙耶和华悦纳的馨香之祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","亚伦及其子孙要吃剩下的祭物，要在会幕院子里的圣洁之处做无酵饼吃。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","做饼时不可加酵。这些祭物是我从献给我的火祭中赐给他们的，像赎罪祭和赎过祭一样是至圣之物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","亚伦的子孙中，男子都可以吃耶和华的火祭。这是他们世世代代应得之份。凡接触到这些祭物的都会变得圣洁。” ");
INSERT INTO cmncbs_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“亚伦及其子孙受膏那天，要献给耶和华一公斤细面粉作为日常献的素祭，早晚各献一半。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","要把这些细面粉调上油，用煎锅做饼，切成块献上，作为蒙耶和华悦纳的馨香素祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","亚伦子孙中继任大祭司的，受膏时要献上素祭。这种祭物必须全部烧掉献给耶和华，这是永远的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","祭司献的这种素祭不可吃，要全部烧掉。” ");
INSERT INTO cmncbs_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“你把以下赎罪祭的条例告诉亚伦及其子孙。 “赎罪祭是至圣的，要在杀燔祭牲的地方，在耶和华面前宰祭牲。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","献赎罪祭的祭司要在会幕院子里的圣洁之处吃这祭牲。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","凡接触到这些祭肉的，都会变得圣洁。如果衣服被溅上血，则要在圣洁之处把衣服洗净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","用来煮祭肉的瓦锅，用后都要打碎。如果用的是铜锅，要擦干净并用水冲洗。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","这些祭肉是至圣之物，祭司家族中的男子都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","如果赎罪祭牲的血被带进会幕，在圣所内进行赎罪，就不可吃祭肉，必须全部烧掉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“以下是献赎过祭的条例。 “赎过祭是至圣的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","要在杀燔祭牲的地方宰赎过祭祭牲，祭牲的血要洒在祭坛周围。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","要献上祭牲的所有脂肪，包括肥尾巴、包裹内脏的脂肪、 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","两个肾脏和肾脏上靠近腰部的脂肪以及肝叶。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","祭司要在坛上焚烧这一切，作为献给耶和华的火祭。这是赎过祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","祭司家的任何男子都可以吃剩下的祭肉，但要在圣洁之处吃，因为这是至圣之物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","祭物要归主持祭礼的祭司，这一条例也适用于赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","燔祭牲的皮要归主持祭礼的祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","至于素祭，不论是用炉烤的，还是用平底锅或煎锅做的，都要归主持祭礼的祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","但调油的或干的素祭要归亚伦的子孙，由他们均分。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“以下是向耶和华献平安祭的条例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“有人若为感谢耶和华而献平安祭，除了献祭牲以外，要一同献上调油的无酵饼、涂油的无酵薄饼及调油的细面饼， ");
INSERT INTO cmncbs_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","也要一同献上有酵饼。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","他要从每种饼中各取一个，作为举祭献给耶和华。举祭归洒平安祭祭牲血的祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","至于为感恩而献的平安祭祭肉，要在献祭的当天吃完，不可留到次日早晨。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","如果是自愿献的或为了还愿而献的祭物，要在献祭当天吃祭肉，剩下的可以留到第二天吃。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","但到第三天，必须烧掉剩下的祭肉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","如果第三天仍然吃祭肉，所献的祭便不蒙悦纳，毫无价值，是不洁净的。吃的人要自担罪责。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“祭肉如果接触到任何不洁之物，都不可吃，要烧掉。洁净的人都可以吃祭肉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","如果有人不洁净，却吃献给耶和华的平安祭祭肉，要将他从民中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","如果有人接触到人或兽的不洁之物，或任何不洁的可憎之物，又吃献给耶和华的平安祭祭肉，要将他从民中铲除。” ");
INSERT INTO cmncbs_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“你把以下条例告诉以色列人。 “你们不可吃牛、绵羊或山羊的脂肪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","自然死亡或被野兽咬死的动物的脂肪也不可吃，但可以作其他用途。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","无论谁吃了献给耶和华的火祭祭牲的脂肪，都要将他从民中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","你们无论住在哪里，都不可吃鸟和兽的血。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","凡吃血的，要将他从民中铲除。” ");
INSERT INTO cmncbs_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“你把以下条例告诉以色列人。 “凡向耶和华献平安祭的，都要从平安祭中取出一份献给耶和华作礼物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","他要亲手将这献给耶和华的火祭带来，将祭牲的脂肪和胸肉带来，在耶和华面前将胸肉摇一摇，当作摇祭献上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","祭司要把脂肪放在坛上焚烧，胸肉归亚伦及其子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","你们要把平安祭牲的右腿献为举祭，归给祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","要把右腿归给亚伦子孙中献平安祭的血和脂肪的那位祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","因为耶和华已经从以色列人献的平安祭中，把作摇祭的胸肉和作举祭的腿肉赐给祭司亚伦及其子孙，这是他们在以色列人中永远当得的份。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","从亚伦及其子孙受膏为祭司事奉耶和华开始，在献给耶和华的火祭中，这是他们应得之份。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","祭司受膏之日，耶和华就命令以色列人把这部分祭肉分给他们，这是他们世世代代应得之份。” ");
INSERT INTO cmncbs_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","以上是献燔祭、素祭、赎罪祭、赎过祭、平安祭和授圣职时所献之祭的条例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","这些条例是耶和华在西奈山上吩咐摩西的。当天，摩西命令以色列人在西奈旷野向耶和华献祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“你把亚伦父子们带来，也要带圣衣、膏油、一头作赎罪祭的公牛、两只公绵羊和一篮无酵饼， ");
INSERT INTO cmncbs_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","然后把全体会众招聚到会幕门前。” ");
INSERT INTO cmncbs_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","摩西按照耶和华的指示行事，会众都聚集在会幕门前。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","摩西告诉会众：“这是耶和华吩咐我做的事。” ");
INSERT INTO cmncbs_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","他把亚伦父子们带来，用水洗他们。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","摩西给亚伦穿上内袍，束上腰带，穿上外袍，套上以弗得，用精巧的带子把以弗得系在亚伦身上， ");
INSERT INTO cmncbs_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","然后给他戴上胸牌，把乌陵和土明放在胸牌内， ");
INSERT INTO cmncbs_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","再把礼冠戴在他头上，在礼冠前系上金牌，即圣冠，都遵照耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","摩西拿膏油抹圣幕和圣幕里的一切物件，使它们圣洁； ");
INSERT INTO cmncbs_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","再用膏油在祭坛上洒七次，又抹祭坛和祭坛上的器具、洗濯盆和盆座，使它们圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","然后，摩西把膏油倒在亚伦头上膏立他，使他圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","摩西又把亚伦的儿子们带来，给他们穿上内袍，束上腰带，戴上头巾，都遵照耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","摩西牵来那头作赎罪祭的公牛，亚伦父子们把手按在牛头上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","摩西宰了牛，用手指蘸一些牛血抹在祭坛凸起的四角上，以洁净祭坛，再把剩下的血倒在坛脚，使祭坛圣洁，为祭坛赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","他取出内脏上的脂肪、肝叶、两个肾脏和肾脏上的脂肪，放在祭坛上烧掉， ");
INSERT INTO cmncbs_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","又照耶和华的吩咐，把公牛的皮、肉和粪便带到营外烧掉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","然后，摩西献上作燔祭的公绵羊，亚伦父子们把手按在羊头上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","摩西宰了那只羊，把血洒在祭坛四周； ");
INSERT INTO cmncbs_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","把羊切成块，焚烧羊头、肉块和脂肪； ");
INSERT INTO cmncbs_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","用水洗净羊的内脏和腿，把整只羊放在祭坛上焚烧，这是燔祭，作蒙耶和华悦纳的馨香火祭，都遵照耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","摩西献上另一只为授圣职而献的公绵羊。亚伦父子们把手按在羊头上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","摩西宰了羊，将一些羊血抹在亚伦的右耳垂、右手大拇指和右脚大脚趾上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","他又把亚伦的儿子们带来，将一些血抹在他们的右耳垂、右手大拇指和右脚大脚趾上，然后把剩下的血都洒在祭坛四周。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","他取下羊的脂肪、肥尾巴、内脏上的脂肪、肝叶、两个肾脏、肾脏上的脂肪和右腿， ");
INSERT INTO cmncbs_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","又从放在耶和华面前盛无酵饼的篮子里取一个无酵饼、一个油饼和一个薄饼，放在羊的右腿和脂肪上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","他把这些都放在亚伦父子们手中，作为摇祭在耶和华面前摇一摇。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","随后，他从他们手上拿过这些祭物，放在祭坛的燔祭上焚烧，作为授圣职时献的祭。这是蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","摩西又把公绵羊的胸肉作为摇祭在耶和华面前摇一摇，这是他授圣职时所应得之份，都遵照耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","摩西拿了一些膏油和坛上的血，洒在亚伦和他的衣服上，也洒在他儿子们和他们的衣服上，使亚伦父子们和他们的衣服圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","摩西对亚伦父子们说：“你们要照我的吩咐在会幕门口煮祭肉吃，也要吃篮子里为授圣职而献的饼。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","吃剩的肉和饼，你们要烧掉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","你们的授圣职礼历时七天，这七天之内，你们不可离开会幕门口。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","今天所做的这一切都是耶和华吩咐的，是为你们赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","七天之内，你们必须日夜待在会幕门口，要遵守耶和华的吩咐，免得你们死亡。这是耶和华对我的吩咐。” ");
INSERT INTO cmncbs_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","于是，亚伦父子们遵行了耶和华借摩西吩咐的一切。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","到了第八天，摩西召来亚伦父子们和以色列的众长老。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","他对亚伦说：“你要在耶和华面前献上一头公牛犊作赎罪祭、一只公绵羊作燔祭，这些祭牲都要毫无残疾。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","然后，你要告诉以色列人，‘你们要取一只公山羊作赎罪祭、毫无残疾的一头一岁牛犊和一只一岁羊羔作燔祭、 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","一头公牛和一只公绵羊作平安祭，连同调油的素祭一起献给耶和华，因为今天耶和华要向你们显现。’” ");
INSERT INTO cmncbs_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","于是，以色列人遵照摩西的吩咐，把祭物带到会幕前。全体会众都聚集到那里，站在耶和华面前。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","摩西对他们说：“耶和华吩咐你们这样做，是为了向你们显出祂的荣耀。” ");
INSERT INTO cmncbs_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","随后，摩西对亚伦说：“你要到坛前来，献上你的赎罪祭和燔祭，为自己和民众赎罪。也要按照耶和华的吩咐，为百姓献上他们的祭物，为他们赎罪。” ");
INSERT INTO cmncbs_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","于是，亚伦走到坛前，宰杀为他作赎罪祭的牛犊。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","他儿子们把牛犊的血递给他，他用手指蘸血抹在祭坛凸起的四角上，再把剩下的血倒在坛脚。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","他照耶和华对摩西的吩咐，在坛上焚烧赎罪祭牲的脂肪、肾脏和肝叶， ");
INSERT INTO cmncbs_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","把皮和肉带到营外焚烧。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","亚伦宰了燔祭祭牲，他儿子们把祭牲的血递给他，他把血洒在祭坛四周。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","他们将祭牲一块一块地连头一起交给亚伦献在坛上焚烧。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","亚伦洗净祭牲的内脏和腿，放在祭坛的燔祭上焚烧。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","随后，亚伦为民众献祭。他牵来那只为民众作赎罪祭的公山羊，宰杀后，像刚才为自己献赎罪祭一样为他们献上赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","他又牵来燔祭祭牲，依照条例献上燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","除了早晨的燔祭，亚伦又取来素祭，从中拿了一把献在坛上焚烧。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","然后，他宰了公牛和公绵羊，为民众献平安祭。他儿子们把祭牲的血递给他，他把血洒在祭坛四周。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","他们把公牛和公绵羊的脂肪、肥尾巴、包裹内脏的脂肪、肾脏和肝叶， ");
INSERT INTO cmncbs_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","放在祭牲的胸脯上，然后亚伦把那些脂肪放在坛上焚烧， ");
INSERT INTO cmncbs_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","将胸肉和右腿肉作为摇祭在耶和华面前摇一摇，都遵照摩西的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","亚伦举手为民众祝福，他献完赎罪祭、燔祭和平安祭后走下祭坛。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","之后，摩西和亚伦走进会幕，又出来为民众祝福。这时，耶和华的荣耀向所有民众显现。 ");
INSERT INTO cmncbs_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","有火从耶和华那里降下来，烧尽祭坛上的燔祭和脂肪。民众看见这景象，都欢呼起来，俯伏在地。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","亚伦的儿子拿答和亚比户各拿自己的香炉，点火加香，在耶和华面前献上凡火。他们这样做不合耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","于是，有火从耶和华面前出来吞噬了他们，他们就死在耶和华面前。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","摩西告诉亚伦：“耶和华曾说过，‘我要在事奉我的人中显明我的圣洁，在所有子民面前彰显我的荣耀。’”亚伦默默无言。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","摩西叫来亚伦的叔父乌薛的儿子米沙利和以利撒反，对他们说：“过来，把你们弟兄的尸体从圣所前抬到营外去。” ");
INSERT INTO cmncbs_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","他们就遵照摩西的吩咐，把仍穿着内袍的尸体抬到营外。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","摩西对亚伦和他剩下的两个儿子以利亚撒和以他玛说：“你们不要蓬头散发，也不要撕裂衣服，免得你们死亡，也免得耶和华向全体会众发怒。不过，你们的所有以色列同胞都可以为耶和华用火烧死的人哀伤。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","你们不可走出会幕门口，免得你们死亡，因为耶和华的膏油在你们身上。”他们就遵照摩西的话去做。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","耶和华对亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“你和你儿子们进会幕前，淡酒烈酒都不可喝，免得你们死亡。这是你们世代当守的永久律例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","你们必须区分什么是圣洁的、什么是世俗的，什么是洁净的、什么是不洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","你们必须将我借摩西赐给以色列人的一切律例教导他们。” ");
INSERT INTO cmncbs_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","摩西对亚伦及其两个儿子以利亚撒和以他玛说：“你们要把献给耶和华的火祭中剩下的素祭做成无酵饼，在坛边吃，因为这是至圣之物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","你们要在圣洁之处吃，因为在献给耶和华的火祭中，这是你们和你们的子孙应得之份。这是耶和华对我的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","至于作摇祭的胸肉和作举祭的腿肉，你们和你们的子孙可以在洁净的地方吃。因为在以色列人所献的平安祭中，这是你们应得之份。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","在献火祭的脂肪时，要把作举祭的腿肉和作摇祭的胸肉，一起带到耶和华面前作为摇祭摇一摇，这些永远是你们和你们的子孙应得之份，正如耶和华的吩咐。” ");
INSERT INTO cmncbs_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","摩西到处寻找那只作赎罪祭的公山羊，却发现那只羊已经被焚烧了。他愤怒地对亚伦剩下的两个儿子以利亚撒和以他玛说： ");
INSERT INTO cmncbs_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“你们为什么不在圣洁之处吃这赎罪祭？这是至圣之物，耶和华赐给你们是要叫你们为会众担罪，在耶和华面前为他们赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","既然这祭牲的血没有被带进圣所，你们本应按照我的吩咐在圣洁之处吃这祭肉。” ");
INSERT INTO cmncbs_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","亚伦对摩西说：“看啊，他们今天向耶和华献赎罪祭和燔祭，却有这样的灾祸发生在我身上。今天我如果吃了这赎罪祭的祭肉，耶和华会悦纳吗？” ");
INSERT INTO cmncbs_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","摩西听了亚伦的回答，感到满意。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“你们把以下条例告诉以色列人。 “地上的动物， ");
INSERT INTO cmncbs_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","凡蹄子分瓣且反刍的动物，你们都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","但你们不可吃只是蹄子分瓣或只反刍的动物。骆驼不洁净，因为它虽反刍但蹄子不分瓣； ");
INSERT INTO cmncbs_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","石獾不洁净，因为它虽反刍但蹄子不分瓣； ");
INSERT INTO cmncbs_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","野兔不洁净，因为它虽反刍但蹄子不分瓣； ");
INSERT INTO cmncbs_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","猪不洁净，因为它虽蹄子分瓣但不反刍。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","你们不可吃它们的肉，也不可摸它们的尸体，因为它们对你们来说不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“海洋与河流里的动物，凡有鳍有鳞的，你们都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","但海洋与河流里无鳍无鳞的动物，你们要憎恶。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","它们都是可憎之物，你们不可吃它们的肉，也不可摸它们的尸体。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","水中任何无鳍无鳞的动物，你们都要视为可憎之物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“你们不可吃以下鸟类，要视为可憎之物。它们是雕、胡兀鹫、黑秃鹫、 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","鸢、隼类、 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","乌鸦类、 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","鸵鸟、夜鹰、海鸥、鹰类、 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","小鸮、鸬鹚、大鸮、 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","仓鸮、鹈鹕、鱼鹰、 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","鹳、鹭鸟类、戴胜和蝙蝠。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“你们要憎恶会飞的四足爬行昆虫， ");
INSERT INTO cmncbs_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","但可以吃其中会飞会跳的昆虫， ");
INSERT INTO cmncbs_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","包括蝗虫类、蟋蟀类和蚱蜢类。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","你们要憎恶所有会飞的四足爬行昆虫。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“以下的动物会使你们不洁净。任何人接触到它们的尸体，都不洁净，要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","任何人拿它们的尸体，都必须洗净所穿的衣服，要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","蹄子不分瓣或不反刍的动物，你们要视为不洁净，碰到它们的人都不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","所有以脚掌走路的四足动物，你们要视为不洁净，碰到它们尸体的人都不洁净，要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","凡拿它们尸体的人都必须洗净所穿的衣服，要等到傍晚才能洁净。你们要视它们为不洁净的动物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“地上不洁净的动物有鼬鼠、老鼠、大蜥蜴类、 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","壁虎、巨蜥、小蜥蜴和变色龙。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","这些爬虫都是不洁净的。任何人碰到它们的尸体，都不洁净，要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","如果它们的尸体掉在什么东西上，不管是木器、衣物、皮件还是袋子，不管作何用途，都会变得不洁净。要把那东西放在水中，一直到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","如果它们的尸体掉在陶器里，陶器里盛的东西都不洁净。你们必须打碎那陶器。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","陶器里的水如果滴到食物上，食物就不洁净；如果滴到盛饮品的器皿里，饮品也不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","它们的尸体无论掉在什么东西上，那东西都不洁净，无论是炉是锅都要打碎。它们不洁净，也理当被你们视为不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","如果它们的尸体掉进水泉或储水池里，水泉和储水池仍然是洁净的，但碰到尸体的人是不洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","如果它们的尸体接触到将要播撒的种子，种子仍是洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","但如果它们的尸体碰到泡过水的种子，种子就不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“一只可以食用的动物死后，任何人如果碰到它的尸体，都不洁净，要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","任何人如果吃它的肉，或拿它的尸体，都必须洗净衣服，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“地上所有的爬虫都是可憎的，你们不可吃。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","你们不可吃用肚子、四脚或多脚爬行的动物，这些都是可憎的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","不可让这些动物使你们成为可憎的，不可因它们而玷污自己，使自己不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","我是你们的上帝耶和华。你们要分别出来做圣洁的人，因为我是圣洁的。不可让地上的爬虫玷污你们。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","我是耶和华，我带你们出埃及，为要做你们的上帝。你们要圣洁，因为我是圣洁的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“以上是有关飞禽走兽、水族和地上一切爬虫的条例， ");
INSERT INTO cmncbs_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","使你们可以区分什么是洁净的、什么是不洁净的、什么是可吃的、什么是不可吃的。” ");
INSERT INTO cmncbs_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“你把以下条例告诉以色列人。 “如果有妇人生了男婴，她就要不洁净七天，像在经期内不洁净一样。 ");
INSERT INTO cmncbs_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","第八天，婴儿要接受割礼。 ");
INSERT INTO cmncbs_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","妇人因产后流血，要等三十三天才能洁净。其间，不可接触任何圣物，也不可进入圣所。 ");
INSERT INTO cmncbs_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","如果妇人生的是女婴，她就要不洁净十四天，像在经期内不洁净一样。她因产后流血，要等六十六天才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","她不论生男生女，洁净期满后，都要预备一只一岁的羊羔作燔祭、一只雏鸽或斑鸠作赎罪祭，带到会幕门口交给祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","祭司要在耶和华面前献祭，为她赎罪，她的流血状况才算洁净。这是有关产妇生男生女的条例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","她若负担不起一只羊羔，可以带两只斑鸠或雏鸽来，一只作燔祭，一只作赎罪祭。祭司为她赎罪后，她就洁净了。” ");
INSERT INTO cmncbs_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“如果有人皮肤上长肿包、皮疹或白斑，出现麻风病症状，要将他带到祭司亚伦或亚伦做祭司的子孙那里。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","祭司要检查患处，如果病灶深入皮下，患处的毛发变白，就是麻风病。祭司检查后，要宣布他是不洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","如果那人的患处有白斑，但病灶没有深入皮下，患处的毛发也没有变白，祭司要把他隔离七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","第七天，祭司要再次检查患处，如果病灶没有恶化，没有在皮肤上扩散，祭司要把他再隔离七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","第七天，祭司要再次检查，如果患处颜色变淡，也没有扩散，祭司要宣布他是洁净的。他患的不过是皮疹，他要洗净衣物，便会洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","如果祭司已查看并宣布他是洁净的，但皮疹又扩散，他必须再去见祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","祭司检查时，如果发现皮疹已扩散，就要宣布他是不洁净的，患了麻风病。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“如果有人患麻风病，必须将他带到祭司面前。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","祭司检查时，如果发现他皮肤上有白色肿包，毛发变白，患处长出新肉， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","他就是患了慢性麻风病，祭司要宣布他是不洁净的。他无须被隔离，因他已经不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","如果他的麻风病已扩散，头上脚上到处可见， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","祭司就要检查。如果发现麻风病已扩散到他全身，全身的皮肤变白，祭司就要宣布他是洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","一旦他身上出现新长的肉，他便不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","祭司看到他身上新长的肉，就要宣布他是不洁净的，因为新长的肉是不洁净的，表明他患了麻风病。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","如果新长的肉变白了，他就要去见祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","祭司检查时，若发现患处确已变白，就要宣布他是洁净的，他便洁净了。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“如果有人皮肤上长疮，又痊愈了， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","但原患处出现白色肿包或白里带红的斑，他就要去让祭司检查。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","祭司检查时，若发现病灶深入皮下，患处的毛发变白，就要宣布他是不洁净的。这是疮变成了麻风病。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","但祭司检查时，若发现患处没有白毛，病灶也没有深入皮下，且颜色变淡，就要把他隔离七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","隔离期间，若病灶在皮肤上扩散，祭司要宣布他是不洁净的，是患了麻风病。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","如果患处的斑保持原样，没有扩散，便是疮疤，祭司要宣布他是洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“如果有人被火烧伤，伤处变白或白中带红， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","祭司要检查他的伤处。如果伤处毛发变白，且深入皮下，就是烧伤已变成麻风病，祭司要宣布他是不洁净的，因为他患了麻风病。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","祭司检查时，若发现伤处没有白毛，也没有深入皮下，且颜色变淡，就要把他隔离七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","第七天，祭司要再次检查，若发现伤处扩散，就要宣布他是不洁净的，因为他患了麻风病。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","如果伤处保持原样，没有扩散，且颜色变淡，就是烧伤引起的肿包，祭司要宣布他是洁净的，因为那不过是烧伤的疤痕。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“如果有男女头上或下巴长疮， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","祭司要检查患处，若发现患处病灶深入皮下，上面有黄色细毛，就要宣布那人是不洁净的，因为那是疥癣，是麻风病。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","祭司检查时，若发现病灶没有深入皮下，也没有黑毛，就要将那人隔离七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","第七天，祭司要检查患处，若发现疥癣没有扩散，上面没有黄毛，也没有深入皮下， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","那人要剃去头发和胡须，但不可剃患处的毛发。祭司要将他再隔离七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","第七天，祭司要再次检查，若发现疥癣没有在皮肤上扩散，也没有深入皮下，就要宣布那人是洁净的。那人要洗净衣服，便洁净了。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","那人洁净以后，疥癣若再次扩散， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","祭司就要再次检查。如果疥癣确已扩散，祭司不必再找黄毛，那人是不洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","如果祭司看到疥癣原样未变，患处长出黑毛，那人就已经痊愈，是洁净的。祭司要宣布那人是洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“如果有男女身上长白斑， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","祭司要检查患处，若发现斑呈灰白色，就是皮疹，那人是洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“如果有人脱发，成了秃头，他是洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","如果有人前额脱发，他只是前额光秃，仍是洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","如果在光秃的头上或前额上长出白里带红的疮，那就是麻风病。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","祭司要检查患处，若发现疮周围肿胀、白中带红，看起来像麻风病， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","就是得了麻风病，那人是不洁净的。祭司要因那人头上的疮而宣布他是不洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“患麻风病的人必须撕裂衣服，披头散发，遮住脸的下半部，高喊‘不洁净！不洁净！’ ");
INSERT INTO cmncbs_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","只要病不痊愈，他就不洁净，要独自住在营外。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“如果衣物出现霉斑，不论是羊毛衣、细麻衣、 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","羊毛织品、细麻织品，还是皮革或皮革制品， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","只要发现霉斑是绿色或红色的，那就是霉变，要拿给祭司检查。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","祭司检查后，要把那衣物隔离七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","第七天，祭司要再次检查，若发现衣物、编织品或皮革上的霉斑蔓延，就是恶性霉变，那衣物就不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","不论那是衣服、羊毛或细麻织品，还是皮革制品，祭司都必须把它烧掉，因为那是恶性霉变，必须烧掉霉变的衣物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","如果祭司发现衣服、编织品或皮革上的霉斑没有蔓延， ");
INSERT INTO cmncbs_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","就要吩咐人洗净衣物，再隔离七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","之后，祭司要再次检查洗过的衣物，若发现霉斑原样未变，即使没有蔓延，那衣物也是不洁净的。无论衣物里面还是外面霉变，都必须把它烧掉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","如果祭司发现洗过后霉斑退色，就要把霉变的部分从衣服、皮革、编织品上撕下来。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","以后衣物、编织品或皮革上若再次出现霉斑，便是旧患复发，要把它烧掉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","如果洗过衣服、编织品或皮革后，霉斑消失了，要再洗一次就洁净了。 ");
INSERT INTO cmncbs_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“羊毛衣、细麻衣、编织品或皮革制品出现霉变时，以上条例可用来鉴定这些衣物是否洁净。” ");
INSERT INTO cmncbs_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“以下是有关麻风病患者的洁净条例。 “麻风病患者痊愈后，要被带到祭司那里。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","祭司要到营外去检查，如果发现他的病已痊愈， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","要吩咐人为他拿来两只洁净的活鸟、香柏木、朱红色线和牛膝草。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","祭司要吩咐人在一个盛清水的陶器上宰杀一只鸟， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","然后祭司要把另一只鸟，连同香柏木、朱红色线和牛膝草一起蘸在掺了清水的鸟血里。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","祭司要用鸟血在他身上洒七次，宣布他是洁净的，然后放走那只活鸟，让它飞向田野。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","他要洗净衣服，剃去所有毛发，沐浴之后便洁净了，可以回到营内，但要住在自己的帐篷外七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","第七天，他要再次剃掉头发、胡须和眉毛等各处毛发，并洗衣、沐浴，之后便洁净了。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“第八天，他要带来两只毫无残疾的公羊羔、一只毫无残疾的一岁母羊羔、三公斤作素祭的调油的细面粉和一杯油。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","主持洁净礼的祭司要把他及其祭物带到会幕门口、耶和华面前， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","并献上一只公羊羔和一杯油作赎过祭，作为摇祭在耶和华面前摇一摇。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","他要在杀赎罪祭牲和燔祭牲的圣洁之处宰公羊羔。赎过祭的祭物要归祭司，像赎罪祭一样，这是至圣之物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","祭司要拿一些赎过祭祭牲的血抹在求洁净者的右耳垂、右手大拇指和右脚大脚趾上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","祭司要拿那杯油，倒一些在自己左手掌中， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","用右手手指蘸左手掌里的油，在耶和华面前弹洒七次， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","然后用手掌中剩下的油抹求洁净者的右耳垂、右手大拇指和右脚大脚趾，就是抹了赎过祭祭牲血的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","祭司要把手掌里剩下的油抹在求洁净者的头上。这样，祭司在耶和华面前为他赎了罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","祭司要献上赎罪祭，为求洁净者赎罪。然后，祭司要宰杀燔祭牲， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","在祭坛上献燔祭和素祭，为他赎罪，他就洁净了。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“他如果贫穷，献不起那么多祭物，可以献一只公羊羔作赎过祭，用摇祭的方式赎罪；也要献一公斤作素祭的调油的细面粉和一杯油； ");
INSERT INTO cmncbs_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","还要按自己的能力献两只斑鸠或雏鸽，一只作赎罪祭，一只作燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","第八天，他必须把这些祭物带到会幕门口，在耶和华面前交给祭司，好使自己洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","祭司要用作赎过祭的羊羔和一杯油作摇祭，在耶和华面前摇一摇。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","接着，祭司要宰杀作赎过祭的羊羔，拿一些羊血抹在求洁净者的右耳垂、右手大拇指和右脚大脚趾上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","祭司也要把一些油倒在自己左手掌中， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","用一根右手指蘸左手掌中的油，在耶和华面前弹洒七次， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","然后把手掌中的一些油抹在求洁净者的右耳垂、右手大拇指和右脚大脚趾上，就是抹了赎过祭祭牲血的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","祭司要把手掌里剩下的油抹在求洁净者的头上，在耶和华面前为他赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","然后献上那人按自己能力带来的两只斑鸠或雏鸽， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","一只作赎罪祭，一只作燔祭，和素祭一起献上。这样，祭司在耶和华面前为求洁净者赎了罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","这是献不起洁净礼所需祭物的麻风病患者应当遵守的条例。” ");
INSERT INTO cmncbs_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“你们到了我赐给你们作产业的迦南以后，如果我使那里的房屋中有发霉现象， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","屋主必须去告诉祭司，‘我的房子里好像有发霉现象。’ ");
INSERT INTO cmncbs_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","祭司进去检查前，要吩咐人把房子腾空，免得房子里的一切都变得不洁净。之后，祭司要进去检查， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","如发现墙壁上出现红色或绿色霉斑，并且侵入墙中， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","祭司就要从房门出来，把房子封闭七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","第七天，祭司要回去检查。若发现墙壁上的霉斑蔓延， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","就要下令拆掉有霉斑的石块，丢到城外不洁净的地方， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","然后命人刮掉屋内墙壁上的灰泥，倒在城外不洁净的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","要另找石块补被拆掉的地方，并用灰泥重新粉刷房子。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“如果拆掉石块、刮掉灰泥、重新粉刷以后，房子再度出现霉斑， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","祭司要去检查，若发现霉斑已蔓延，就是恶性霉变，那房子就不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","房主要拆掉房子，把石块、木料和所有灰泥都丢到城外不洁净的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","房子封闭期间，任何人进去，都不洁净，要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","凡在房内睡觉或吃饭的人，都必须洗净衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“祭司检查粉刷后的房子，若发现房内没有再度出现霉斑，就要宣布房子是洁净的，因为霉斑已消失。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","为洁净房子，祭司要取两只鸟、香柏木、朱红色线和牛膝草， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","在一个盛清水的陶器上宰杀一只鸟， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","然后用香柏木、牛膝草、朱红色线和另一只活鸟，蘸掺了清水的鸟血，向房子洒七次。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","祭司用鸟血、清水、活鸟、香柏木、牛膝草和朱红色线洁净那房子后， ");
INSERT INTO cmncbs_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","要放走那只活鸟，让它飞到城外的田野。这样，祭司为那房子赎了罪，房子就洁净了。” ");
INSERT INTO cmncbs_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","以上条例是有关麻风病、疥癣、 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","衣物或房子发霉、 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","肿包、皮疹或白斑的条例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","根据这些条例，可以分辨有关的人或物何时洁净、何时不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“你们把以下条例告诉以色列人。 “如果有男人患了漏症，他下体的排泄物是不洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","不论他下体的排泄物止住与否，他都是不洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","他睡过的床或坐过的东西都不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","凡碰到他睡过的床的人都不洁净，必须洗衣、沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","凡坐他坐过之物的人都不洁净，必须洗衣、沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","凡碰到他的人都不洁净，必须洗衣、沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","如果他吐唾沫在一个洁净的人身上，那人便不洁净，必须洗衣、沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","他骑过的鞍子是不洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","凡碰到他坐过之物的人都不洁净，要等到傍晚才能洁净。碰到这些东西的人都不洁净，必须洗衣、沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","如果他没有洗手就碰到别人，那人便不洁净，必须洗衣、沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","必须打碎他摸过的陶器，用水清洗他摸过的木器。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","他病愈后，必须经过七天的洁净期，要洗净衣服，用清水沐浴，这样就洁净了。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","第八天，他要把两只斑鸠或雏鸽带到会幕门前，在耶和华面前交给祭司献祭， ");
INSERT INTO cmncbs_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","一只作赎罪祭，一只作燔祭。这样，祭司便在耶和华面前为他的漏症赎了罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“男人若遗精，便不洁净，必须沐浴全身，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","沾了精液的衣物或皮革都不洁净，必须用水清洗，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","如果男女同房，二人都不洁净，必须沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“女人在月经期间，要不洁净七天。凡碰到她的人都不洁净，要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","月经期间，她躺过或坐过的东西都不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","凡碰过她床的人都不洁净，必须洗衣、沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","人若碰到她坐过的地方，也不洁净，必须洗衣、沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","不论是她的床，还是她坐的东西，碰到的人都不洁净，要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","男人若与她同房，沾染了她的经血，就要不洁净七天，他躺过的床也不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“女人若在经期以外多日血漏或经期过长，在此期间便不洁净，像在经期内一样。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","在血漏期间，她躺的床或坐的东西都不洁净，像在经期内一样。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","凡碰到这些东西的人都不洁净，必须洗衣、沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","血漏停止后，她要等七天才洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","第八天，她要把两只斑鸠或雏鸽带到会幕门口，交给祭司献祭， ");
INSERT INTO cmncbs_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","一只作赎罪祭，一只作燔祭。这样，祭司便在耶和华面前为她赎了血漏的不洁之罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","你们要使以色列人远离不洁之物，免得他们因不洁而玷污我设在他们中间的圣幕，以致死亡。” ");
INSERT INTO cmncbs_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","以上条例是为患漏症的人，包括遗精、 ");
INSERT INTO cmncbs_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","行经的女人、患漏症的男女、与不洁净女人同房的男人所设立的条例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","亚伦的两个儿子死在耶和华面前以后， ");
INSERT INTO cmncbs_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","耶和华对摩西说：“告诉你哥哥亚伦，他不可随意进入幔子里面的至圣所，到约柜上的施恩座前，免得死亡，因为我要在施恩座之上的云彩中显现。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","亚伦进入圣所时，要带一头作赎罪祭的公牛犊和一只作燔祭的公绵羊。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","他要穿上圣洁的细麻内袍和细麻裤子，束上细麻腰带，戴上细麻礼冠。这些是圣洁的衣物，他必须沐浴后才可穿戴。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","他要从以色列会众那里取两只公山羊作赎罪祭，一只公绵羊作燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","亚伦要先献上那头公牛犊作赎罪祭，为自己和全家赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","然后，他要把两只公山羊带到会幕门口，放在耶和华面前。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","他要为这两只羊抽签，决定哪只归耶和华，哪只归阿撒泻勒。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","亚伦要献上那只归耶和华的公山羊作赎罪祭， ");
INSERT INTO cmncbs_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","要将那只归阿撒泻勒的公山羊活着献给耶和华，用来赎罪，然后把它放到旷野归阿撒泻勒。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“亚伦要把那头为他作赎罪祭的公牛犊牵来宰杀，为自己和全家赎罪， ");
INSERT INTO cmncbs_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","然后拿一个香炉，盛满从耶和华面前的祭坛上取的火炭，再拿两把磨细的香带进幔子里。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","他要在耶和华面前烧香，使香的烟笼罩约柜上的施恩座，免得他死亡。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","他要取一些公牛的血，用手指弹洒在施恩座的东面，并在施恩座前用手指弹洒七次。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","然后，亚伦要出去宰杀那只为民众作赎罪祭的公山羊，把羊血带进幔子里，像洒公牛的血一样洒在施恩座的上面和前面。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","因以色列人的污秽、叛逆和罪恶，他要这样为至圣所赎罪。他也要同样为会幕赎罪，因为会幕坐落在以色列人中间，处在他们的污秽中。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","从他进入圣所为自己、家人和以色列全体会众赎罪开始，直到他赎完罪出来为止，任何人都不可待在会幕里。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","之后，他要来到耶和华面前的祭坛那里，为祭坛赎罪。他要取一些牛血和羊血，抹在祭坛凸起的四角上， ");
INSERT INTO cmncbs_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","然后用手指向祭坛洒血七次，除掉以色列人的污秽，使祭坛圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“他为至圣所、会幕和祭坛赎罪后，要牵来那只活山羊， ");
INSERT INTO cmncbs_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","把双手放在羊头上，承认以色列人的所有过犯、叛逆和罪恶，将这一切罪归到公山羊的头上，然后派人把它送到旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","这只羊要把他们一切的罪过带到偏远的地方，那人要把羊留在旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“亚伦要走进会幕，脱下他进至圣所时穿的细麻衣服，放在会幕里。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","他要在圣洁之处沐浴，穿上平时的衣服出去为自己和民众献燔祭，为自己和民众赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","他要将赎罪祭牲的脂肪焚烧在祭坛上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","把羊送交阿撒泻勒的人要洗衣、沐浴，然后才可回到营里。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","作赎罪祭的公牛和公山羊的血被带进圣所用来赎罪后，要把公牛和公山羊带到营外，用火焚烧它们的皮、肉和粪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","负责焚烧的人要洗衣、沐浴，然后才可回到营里。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“每年七月十日，不论是你们，还是寄居在你们中间的外族人，都要禁食，停止所有工作。这是你们永远当守的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","因为在这一天要为你们赎罪，使你们在耶和华面前洁净，脱离一切的罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","这天是你们完全休息的安息日，你们要禁食。这是一条永远不变的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","那受膏、接替父亲担任圣职的大祭司要行赎罪礼。他要穿上圣洁的细麻衣， ");
INSERT INTO cmncbs_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","为至圣所、会幕和祭坛赎罪，也要为祭司和全体会众赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","这是你们当守的永久律例：每年一次为以色列人赎罪。” 于是，摩西遵行了耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“你要告诉亚伦父子们及全体以色列人，以下是耶和华的吩咐： ");
INSERT INTO cmncbs_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","任何在营内或营外宰杀公牛、绵羊或山羊的以色列人， ");
INSERT INTO cmncbs_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","若没有把牲畜带到会幕门口，在耶和华的圣幕前献给耶和华，便是犯了流血之罪，要将他从民中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","这是为了让以色列人把祭牲带到会幕门口交给祭司，献给耶和华作平安祭，而非在野外杀祭牲献祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","祭司要将祭牲的血洒在会幕门口耶和华的祭坛上，把脂肪焚烧献给耶和华作馨香之祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","他们不可再献祭物给山羊神，与其苟合。这是他们世代当守的永久律例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“你要告诉他们：不论是以色列人，还是寄居在以色列人中间的外族人，献燔祭或其他祭物时， ");
INSERT INTO cmncbs_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","如果没把祭物带到会幕门口献给耶和华，要将他从民中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“任何以色列人或寄居在以色列人中间的外族人若吃血，耶和华必严惩，把他从民中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","因为肉体的生命在血中，耶和华把血赐给你们，使你们可以用血在祭坛上为自己赎罪。血可以为人的生命赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","所以耶和华吩咐以色列人和寄居在以色列人中间的外族人不可吃血。 ");
INSERT INTO cmncbs_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","以色列人或寄居在以色列人中间的外族人如果捕到可吃的鸟或兽，必须放尽它的血，用土掩埋， ");
INSERT INTO cmncbs_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","因为所有动物的生命都在血中。因此，耶和华吩咐以色列人不可吃任何动物的血，因为血就是生命。凡吃血的都要被铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","不论以色列人还是外族人，若吃了自然死亡或被野兽撕裂的动物，就不洁净。他必须洗衣、沐浴，等到傍晚才能洁净， ");
INSERT INTO cmncbs_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","否则他要承担罪责。” ");
INSERT INTO cmncbs_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“你要告诉以色列人：我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","你们曾经住在埃及，但不可效法埃及人的行为。我要把你们带到迦南，但你们不可效法迦南人的行为，不可随从他们的风俗。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","你们必须遵行我的典章，持守我的律例。我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","你们要遵守我的典章和律例，遵行的人必因此而活。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“你们任何人不可与近亲乱伦。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","不可与你母亲乱伦而羞辱你父亲。她是你的母亲，不可与她乱伦。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","不可与你父亲的妻妾乱伦，那会羞辱你的父亲。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","不可与你的姊妹乱伦。不论是同父异母的，还是同母异父的，生长在同一家庭的，还是不同家庭的，都不可与她乱伦。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","不可与孙女或外孙女乱伦，那会自取羞辱。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","不可与你父亲妻妾的女儿乱伦。她是你的姊妹，不可与她乱伦。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","不可与姑母乱伦，她是你父亲的至亲。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","不可与姨母乱伦，她是你母亲的至亲。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","不可与伯母或婶母乱伦而羞辱你伯父或叔父，她是你的伯母或婶母。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","不可与儿媳乱伦。她是你儿子的妻子，不可与她乱伦。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","不可与兄嫂或弟媳乱伦，她是你兄弟的妻子，那会羞辱你的兄弟。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“不可与一个女人性交，又与她女儿性交，也不可与她孙女或外孙女性交。她们是她的近亲。这都是邪恶行为。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","妻子还在世时，不可娶她姊妹并与她性交，使她们彼此作对。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","女人在月经期间不洁净，不可与她性交。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","不可与邻居的妻子性交，那会玷污自己。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","不可把儿女当作祭物献给假神摩洛，不可亵渎你上帝的名。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","男人不可与男人同寝，像和女人同寝一样，这是可憎的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","不可与兽类交合，玷污自己。女人也不可与兽类交合。这是变态行为。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“你们不可做这些事玷污自己，因为我要在你们面前赶走的各国，正是因为这些行为而玷污了自己。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","他们居住的土地也都被玷污了，所以我因他们的罪恶而惩罚那片土地，我要使那片土地吐出其中的居民。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","你们必须遵守我的律例和典章。不论你们还是寄居在你们中间的外族人，都不可做这些可憎之事。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","因为在你们之前居住在那里的人做了这些可憎之事，玷污了那片土地。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","如果你们玷污了那片土地，它也会像吐出从前的居民一样把你们吐出去。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","凡做这些可憎之事的，要将他从民中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","你们要遵守我的命令，不要效法那片土地上居民的恶俗，以致玷污自己。我是你们的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“你要告诉以色列全体会众，‘你们要圣洁，因为我——你们的上帝耶和华是圣洁的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","你们每个人都必须孝敬父母，遵守我的安息日。我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","不要祭拜虚无的神明，也不要为自己铸造神像。我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","你们献平安祭给我时，要使你们所献的蒙悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","要在献祭当天或第二天吃完祭物。如果第三天还有剩余，都要烧掉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","如果有人第三天还吃那些祭物，祭物就不洁净，我不会悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","那人要自担罪责，因为他亵渎了我的圣物。要将他从民中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“‘你们收割的时候，不要割净田角地边的庄稼，也不要捡那些掉在田里的穗子。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","不要摘净葡萄园里的葡萄，也不要捡掉在地上的葡萄。要把这些留给穷人和寄居在你们中间的外族人。我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","不可偷盗，不可撒谎，不可互相欺骗。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","不可奉我的名起假誓，从而亵渎你们上帝的名。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","不可欺压邻居，也不可抢夺他的东西。要当天支付雇工的工钱，不可拖到第二天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","不可咒骂耳聋的，也不可把绊脚石放在盲人面前，应当敬畏你们的上帝。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","不可徇私枉法，不可偏袒穷人，不可谄媚权贵之人，要秉公审判。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","不可到处搬弄是非，不可危害邻居的生命安全。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","对同胞不可心中怀恨。同胞有错，要当面指正，免得自己因他而担罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","不可报复，不可埋怨同胞，要爱邻如己。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“‘你们要遵守我的律例。不可让牲畜杂交；不可在同一块田播撒两种不同的种子；不可穿两种材料织成的衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“‘一个已经许配人的婢女尚未被赎或未获自由时，如果有人与她同寝，就要受到处罚，但不可处死他们，因为那婢女还未获自由。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","和她同寝的人要把一只公绵羊牵到会幕门口，作为赎过祭献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","祭司要用作赎过祭的公绵羊在耶和华面前为那人赎罪，他犯的罪便得到赦免。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“‘你们到了迦南，在那里栽种各样果树后，前三年不可吃树上的果子，要视它们是不洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","第四年，树上的所有果子都是圣洁的，要献给耶和华作颂赞之祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","第五年，你们可以吃树上的果子。你们这样做，果树会为你们结出更多果子。我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“‘不可吃带血的肉，不可占卜或行巫术。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","不可修剪鬓角或胡须。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","不可因哀悼死人而割伤身体，也不可纹身。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","不可辱没自己的女儿，使她沦为娼妓，免得你们居住的地方充满淫乱和邪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","要遵守我的安息日，敬畏我的圣所。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","不可求问灵媒或巫师，玷污自己。我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“‘在年长者面前，要恭敬站立，要敬重年长者。要敬畏你们的上帝。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","不可欺负住在你们境内的外族人， ");
INSERT INTO cmncbs_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","要视他们如同胞，爱他们如爱自己，因为你们也曾经寄居埃及。我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","在称重和度量时，不可欺诈。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","要使用准确的秤、尺子和升斗。我是你们的上帝耶和华，曾带领你们离开埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","你们要遵行我的一切律例和典章。我是耶和华。’” ");
INSERT INTO cmncbs_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“你要告诉以色列人：在你们或寄居在你们中间的外族人中，如果有人把子女献给假神摩洛，必须处死他，当地的人要用石头打死他。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","我也必严惩那人，将他从民中铲除。因为他把子女献给摩洛，玷污我的圣所，亵渎我的圣名。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","如果那地方的人对此置之不理，没有处死那人， ");
INSERT INTO cmncbs_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","我必严惩那人及其家人，从民中铲除他和那些追随他与摩洛苟合的人。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","如果有人求问灵媒或巫师，与他们苟合，我必严惩，将他从民中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","你们要分别出来，做圣洁的人，因为我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","你们要遵行我的律例。我是使你们圣洁的耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“咒骂父母的，必被处死。他咒骂父母，罪有应得。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","如果有人与别人的妻子通奸，奸夫淫妇必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","如果有人与父亲的妻妾同寝，就是羞辱他的父亲。要把二人处死，他们罪有应得。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","如果有人与儿媳同寝，二人都必须被处死。他们乱伦，罪有应得。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","如果男人与男人同寝，好像男人与女人同寝一样，他们的行为可憎，必须被处死。他们罪有应得。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","如果有人娶妻，又娶岳母，便是大恶。要把他们三人烧死，使你们杜绝这种败坏之事。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","如果有男人与兽类交合，他和兽都要被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","如果有女人与兽类交合，女人和兽都要被处死。他们必须被处死，他们罪有应得。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“如果有人娶了同父异母或同母异父的姊妹，这是可耻之事，必须公开铲除他们。他与自己的姊妹乱伦，羞辱了她，要承担自己的罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","如果有人与经期的女人同寝，他就暴露了女人的血泉，女人也自露血泉。要将他们二人从民中铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","不可与姨母或姑母乱伦，因为这是羞辱自己的亲人。二人要承担自己的罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","如果有人与伯母或婶母同寝，就是羞辱他的伯父或叔父。二人要承担自己的罪，必无子女而死。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","如果有人娶兄嫂或弟媳，这是污秽行为，羞辱了自己的兄弟。二人必无儿无女。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“你们要遵行我的一切律例和典章，免得我要带你们去居住的那片土地把你们吐出去。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","我要在你们面前赶走那片土地上的各族，你们不要随从他们的习俗。他们做了以上那些事，所以我厌恶他们。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","我曾说你们必占据他们的土地，我要把那片奶蜜之乡赐给你们作产业。我是你们的上帝耶和华，我已经把你们从万族中分别出来。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","所以，你们要区分洁净和不洁净的兽类与鸟类。不可吃那些我视为不洁净的飞禽、走兽和爬虫，以免玷污自己。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","你们要圣洁，因为我耶和华是圣洁的。我把你们从万族中分别出来，使你们做我的子民。 ");
INSERT INTO cmncbs_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","如果有人做灵媒或巫师，不论男女，都必须被处死。你们要用石头打死他们，他们罪有应得。” ");
INSERT INTO cmncbs_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","耶和华对摩西说：“你要告诉做祭司的亚伦子孙：祭司不可因接触死去的族人而使自己不洁净， ");
INSERT INTO cmncbs_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","但骨肉至亲，如父母、儿女、兄弟， ");
INSERT INTO cmncbs_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","以及未出嫁仍是处女的姊妹例外。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","祭司不可因姻亲的关系而玷污自己。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","祭司不可剃光头、修剪胡须或割伤身体。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","他们要做上帝的圣洁之民，不可亵渎我的名。因为他们负责献我的火祭，即我的食物，所以要保持圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","他们不可娶妓女或被休的女人为妻，因为祭司要向上帝保持圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","要视祭司为圣洁的，因为他们负责献你们上帝的食物。要视他们为圣洁的，因为使你们圣洁的我耶和华是圣洁的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","如果有祭司的女儿做妓女，辱没自己，她就是辱没自己的父亲，必须烧死她。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“大祭司在众祭司中职分最高，头上浇过膏油，已经承受圣职、穿上圣衣，他不可披头散发、撕裂衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","他不可接近死者，即使是父母也不可，以免玷污自己。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","他不可走出他上帝的圣所，以免亵渎圣所，因为我的膏油已经使他圣洁。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","他必须娶处女为妻， ");
INSERT INTO cmncbs_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","不可娶寡妇、被休的女人或被玷污的妓女，只可娶本族中的处女为妻， ");
INSERT INTO cmncbs_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","以免在民中玷污自己的子孙，因为我是使他们圣洁的耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“你告诉亚伦：你世世代代的子孙中，任何有残疾的人都不可前来向他的上帝献食物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","任何残疾的人，如瞎眼的、瘸腿的、五官不正的、畸形的、 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","四肢伤残的、 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","驼背的、侏儒、患眼疾的、长疥癣的或睪丸受损的，都不可近前来献祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","亚伦祭司的子孙中有残疾的都不可向耶和华献火祭。他们既然有残疾，就不可近前来献耶和华的食物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","他们可以吃上帝的食物，圣的和至圣的都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","但他们不可走近幔子或祭坛，因为他们有残疾。这样做是为了避免他们亵渎我的圣所。我是使圣所圣洁的耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","摩西把这些条例告诉了亚伦父子们和所有的以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“你告诉亚伦父子们要谨慎处理以色列人献给我的圣物，免得亵渎我的圣名。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“你告诉他们：你们世世代代的子孙中，如果有人不洁净，却接近以色列人分别出来献给我的圣物，必须把他从我面前铲除。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","亚伦的子孙中若有人患了麻风病或漏症，在他洁净之前，不可吃圣物。如果有人遗精，或碰到因接触尸体而不洁净之物， ");
INSERT INTO cmncbs_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","或碰到不洁净的爬虫，或碰到任何使他不洁净的爬虫或人， ");
INSERT INTO cmncbs_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","这人就不洁净，要到傍晚之后才能洁净。他要沐浴后才可吃圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","日落之后，他就洁净了，可以吃圣物，因为那是他应得的食物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","他不可吃自然死亡或被野兽撕裂的动物，免得因此而不洁净。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","他们要遵守我的命令，免得他们犯罪，因亵渎我的命令而死亡。我是使他们圣洁的耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“祭司家以外的人不可吃圣物，在祭司家中寄居的或做雇工的都不可吃， ");
INSERT INTO cmncbs_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","但出生在祭司家里或祭司用钱买来的奴隶都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","如果祭司的女儿嫁给本族以外的人，她便不可再吃圣洁的举祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","如果祭司的女儿守寡或被休，无儿无女，又像年轻时回到父亲家居住，便可以吃父亲的食物。除此以外，不属于祭司家的人都不可吃。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","任何人如果误吃圣物，就要如数偿还给祭司，并加赔五分之一。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","祭司不可亵渎以色列民众献给耶和华的圣物， ");
INSERT INTO cmncbs_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","以免因擅自吃圣物而担罪、受罚。我是使他们圣洁的耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“你要告诉亚伦父子们及所有以色列人：任何以色列人或寄居在以色列的外族人，若向耶和华献燔祭，无论是为了还愿还是出于自愿， ");
INSERT INTO cmncbs_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","都必须献毫无残疾的公牛、公绵羊或公山羊才能蒙悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","不可献有残疾的，因为不蒙悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","如果有人为了还愿或自愿献牛羊作平安祭给耶和华，必须献毫无残疾的牛羊才能蒙悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","不可献给耶和华瞎眼的、伤残的、断肢的、长疥癣的牲畜，也不可把这些牲畜献给耶和华作火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","至于畸形或发育不全的公牛或绵羊羔，可以用作自愿献的祭，但用作还愿祭将不蒙悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","不可献给耶和华睪丸受损、被压碎、破裂或被阉割的牲畜。在你们境内不可做这样的事， ");
INSERT INTO cmncbs_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","也不可从外族人手中接受这类牲畜，来献给你们的上帝作食物。因为这些牲畜是畸形的、残疾的，不蒙悦纳。” ");
INSERT INTO cmncbs_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“刚出生的牛、绵羊或山羊，前七天要与母亲在一起。从第八天起，把它们献给我作火祭必蒙悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","不可在同一天内宰杀母牛和小牛或母羊和小羊。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","你们献感恩祭给耶和华时，要使你们所献的蒙悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","要当天吃完祭物，不可留到早晨。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","你们要遵行我的一切诫命。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","不可亵渎我的圣名，我要在以色列人中被尊为圣，我是使你们圣洁的耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","我领你们离开埃及，是要做你们的上帝。我是耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“你要告诉以色列人，以下是耶和华所定的节期，你们要宣布这些节期为举行圣会的日子。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“你们一周可以工作六天，但第七天是完全休息的安息日，你们要举行圣会。不可做任何工，无论你们住在哪里，都要守耶和华的安息日。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“以下是耶和华所定的节期，你们要在这些日子召开圣会。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“从一月十四日傍晚开始是耶和华的逾越节。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","从一月十五日开始是耶和华的除酵节，你们要连续七天吃无酵饼。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","在除酵节的第一天，你们要举行圣会，不可做日常工作。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","一连七天你们要献火祭给耶和华。第七天，你们要举行圣会，不可做日常工作。” ");
INSERT INTO cmncbs_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“你把以下条例告诉以色列人。 “你们进入耶和华将要赐给你们的那片土地以后，每逢收割庄稼之时，你们要带一捆初熟的谷物交给祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","祭司要在安息日后第一天把那捆谷物在耶和华面前摇一摇，你们所献的就会得到悦纳。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","在献谷物那天，你们要献给耶和华一只毫无残疾、一岁的公羊羔作燔祭， ");
INSERT INTO cmncbs_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","同时要把两公斤调油的细面粉作素祭，一起献给耶和华作馨香的火祭，也要献一升酒作奠祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","你们必须先将这些供物献给你们的上帝后，才可以吃饼、烘烤的谷物和新鲜穗子。不论住在哪里，这是你们世代当守的永久律例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“从安息日后第一天，即你们献上摇祭的那天算起，你们要数整整七周， ");
INSERT INTO cmncbs_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","一直数到第七个安息日后的第一天，共五十天。到那天，你们要把新收的谷物作为素祭献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","你们要用两公斤细面粉加上酵，烤成两个饼作摇祭，从你们居住的地方带来献给耶和华作初熟之祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","你们要把七只毫无残疾的一岁公羊羔、一头公牛犊、两只公绵羊和那两个饼，一起献给耶和华作燔祭。这些一起献上的燔祭、素祭和奠祭，是蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","你们也要献一只公山羊作赎罪祭，两只一岁的公绵羊作平安祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","祭司要把这两只公绵羊和初熟之物做的饼作为摇祭，在耶和华面前摇一摇。这些是献给耶和华的圣物，归祭司所有。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","你们要在那天召开圣会，不可做日常工作。不论住在哪里，这是你们世代当守的永久律例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","你们收割时，不可割尽田角地边的庄稼，也不可捡落在地里的，要把这些留给穷人和外族人。我是你们的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“你告诉以色列人：你们要在七月一日完全休息，要吹号作纪念，召开圣会。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","你们不可做日常工作，要献火祭给耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“七月十日是赎罪日，你们要举行圣会，禁食，献火祭给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","那是在你们的上帝耶和华面前为自己赎罪的日子，你们不可工作。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","那天，凡不禁食的，要将他从民中铲除； ");
INSERT INTO cmncbs_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","凡在那天工作的，耶和华要毁灭他。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","你们不可做任何工作。不论住在哪里，这是你们世代当守的永久律例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","那是你们完全休息的安息日。从七月九日傍晚至次日傍晚，你们必须禁食。” ");
INSERT INTO cmncbs_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“你把以下条例告诉以色列人。 “从七月十五日开始，你们要一连七天向耶和华守住棚节。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","第一天，你们要举行圣会，不可做日常工作。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","一连七天你们要献火祭给耶和华。第八天要举行圣会，献火祭给耶和华。这是庄严的聚会，你们不可做日常工作。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“以上是耶和华所定的节期。在这些节期里，你们要召开圣会，按规定的日子献给耶和华燔祭、素祭、奠祭和其他祭物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","除了守安息日并向耶和华献供物、还愿祭和自愿献的祭以外，你们还要守这些节期。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“你们收割完后，从七月十五日起，要一连七天庆祝耶和华的节期，第一天和第八天是完全休息的安息日。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","第一天，你们要摘下树上结的上好果子，折下棕树枝、叶子浓密的树枝与河边的柳枝，在你们的上帝耶和华面前欢庆七天。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","在每年七月的这七天，你们要向耶和华守这节期。这是你们世代当守的永久律例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","你们要搭棚居住七天，所有以色列人都要住在棚里。 ");
INSERT INTO cmncbs_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","这样，你们的后代就会知道，我带领以色列人离开埃及后，曾让他们住在棚里。我是你们的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","于是，摩西向以色列人宣布了耶和华所定的这些节期。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“你要吩咐以色列人把榨的纯橄榄油给你拿来点灯，使灯常明。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","亚伦要负责照看会幕内遮掩约柜的幔子外的灯，使灯从晚上到早晨一直在耶和华面前亮着。这是你们世代当守的永久律例。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","亚伦要在耶和华面前常常照看这些放在纯金灯台上的灯。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“你要用细面粉烤十二个饼，每个饼用两公斤细面粉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","你要把饼摆成两行，放在耶和华面前的纯金桌子上，每行六个， ");
INSERT INTO cmncbs_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","每行饼上放一些纯乳香，象征这些饼是献给耶和华的火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","每逢安息日，要定期把饼摆在耶和华面前。这是以色列人要永远遵守的约。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","这些饼要归亚伦及其子孙。他们要在圣洁之处吃，因为在献给耶和华的火祭中，这是至圣之物，要永远归祭司所有。” ");
INSERT INTO cmncbs_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","有一个人，母亲是以色列人，父亲是埃及人，他在营中与一个以色列人打起架来。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","他说咒诅的话，亵渎了上帝的名，他们把他带到摩西那里。他母亲叫示罗密，是但支派底伯利的女儿。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","他们把他关押起来，等候耶和华的指示。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“把那亵渎圣名的人带到营外，所有听见的人都把手放在他头上，然后全体会众要用石头打死他。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","你要告诉以色列人，谁咒诅上帝，谁就要承担自己的罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","凡亵渎耶和华圣名的，必须被处死，全体会众要用石头打死他。不论是外族人还是以色列人，凡亵渎圣名的，都必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","凡杀人的，必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","打死别人牲畜的，必须赔偿牲畜，以命还命。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","伤害邻舍的，必须受同样的伤害， ");
INSERT INTO cmncbs_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","要以伤还伤，以眼还眼，以牙还牙。他怎样伤害别人，也要怎样伤害他。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","打死别人牲畜的，必须赔偿牲畜；杀人的，必须偿命。 ");
INSERT INTO cmncbs_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","不论是以色列人还是外族人，都要遵守这些律法。我是你们的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","于是，摩西把这些话告诉以色列人，他们就按照耶和华对摩西的吩咐，把那亵渎圣名的人带到营外，用石头打死了。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","耶和华在西奈山上对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“你要告诉以色列人：你们到了我将要赐给你们的土地后，要让土地在耶和华面前守安息。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","六年之内，你们可以耕种田地，修整葡萄园，收获出产。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","但第七年是要向耶和华守的安息年，土地要完全休息。你们不可耕种，不可修整葡萄园。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","不可收割自生自长的庄稼，也不可摘未经修剪而结的葡萄。这一年土地要完全休耕。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","但安息年间土地里自生自长的，你们和你们的仆婢、雇工与住在你们中间的外族人都可以吃， ");
INSERT INTO cmncbs_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","你们的牲畜和境内的野兽也可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“你们要计算七个安息年，即七个七年，共四十九年。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","第五十年的七月十日赎罪日那天，你们要在境内各地吹号。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","你们要以这一年为圣年，向境内所有居民宣告自由。这一年将成为你们的禧年。你们要各归祖业，各回本家。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","第五十年是你们的禧年。这一年你们不可耕种，不可收割自生自长的庄稼，也不可摘未经修剪而结的葡萄。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","这是禧年，是你们的圣年，你们可以吃土地里自生自长的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","在禧年，各人要回到祖业。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","因此，你们和同胞买卖田地时，不可彼此亏负。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","买卖双方要按照距下个禧年的年数和收成的年数定价。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","距下个禧年的年数多，价钱就高；年数少，价钱就低。因为卖的是田地收成的次数。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","要敬畏你们的上帝，不可彼此亏负。我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","你们要遵行我的律例，持守我的典章，就可以在那片土地上安居。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","土地会出产丰富，使你们丰衣足食、安然居住。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","你们可能会问，‘第七年不种不收，我们吃什么？’ ");
INSERT INTO cmncbs_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","我要在第六年赐福给你们，使田地的出产够你们吃三年。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","第八年开始耕种时，你们仍会吃陈粮，一直吃到第九年的收割季节。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“你们不可永远卖掉土地，因为土地是我的，你们只不过是寄居在那片土地上的过客。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","你们购买每一块土地时，都必须让原主保留赎回的权利。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","如果有人因贫穷而卖掉土地，他的近亲要把卖掉的土地赎回来。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","如果无人为他赎回，而他自己渐渐富裕起来，有能力赎回， ");
INSERT INTO cmncbs_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","他要计算卖掉土地的年数，退还距下个禧年所剩年数的地价，便可以赎回自己的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","如果他没有能力赎回，所卖的土地在禧年之前要属于买主。到了禧年，买主必须把土地归还原主。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“如果有人卖掉自己城里的房子，要保留一年赎回权。卖掉房子的一年之内，他可以赎回。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","如果一年之内他没有赎回，房子便永远归买主所有，就是到了禧年也不用归还。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","如果房子在四围无墙的乡村，要视房子为乡下的土地，原主可以赎回；到了禧年，买主必须将房子归还。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","在利未人的城邑里，利未人永远有权赎回所卖的房子。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","如果他们没有赎回，到了禧年要把房子归还他们，因为在利未人的城里，利未人的房屋是他们在以色列人中所拥有的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","但不可出卖利未人城郊的草场，那是他们永远拥有的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“如果你们的同胞生活日益贫穷，难以维生，你们要像照顾外族人和寄居者一样照顾他的生活，让他住在你们当中。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","不可向他放债取利，要敬畏你们的上帝，让他住在你们当中。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","你们借钱给他，不可收取利息；借粮给他，不可谋利。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","我是你们的上帝耶和华。我曾经带领你们离开埃及，为要把迦南赐给你们，并做你们的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“如果你们的同胞穷得把自己卖给你们，不可把他当作奴隶， ");
INSERT INTO cmncbs_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","要待他像雇工和寄居者一样。他要为你工作到禧年。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","到了禧年，他和孩子们便可以离开你们，回到自己的宗族和祖业。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","因为以色列人是我的仆人，是我从埃及带出来的，所以他们不可卖身为奴。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","你们也不可苛待他们，要敬畏你们的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","你们可以从邻国购买奴隶， ");
INSERT INTO cmncbs_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","也可以买居住或出生在你们境内的外族人。这些人可以作你们的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","你们可以将他们作为产业传给你们的子孙，使他们终身做奴隶。但你们不可苛待自己的同胞。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“如果你们中间的外族人渐渐富裕，你们同胞中却有人日益贫穷，把自己卖给外族人或他们的族人， ");
INSERT INTO cmncbs_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","他可以保留赎身的权利。他的兄弟、 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","叔伯、堂兄弟或其他近亲都可以赎回他。如果他富裕起来，也可以赎回自己。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","他要和买主计算从自己卖身为奴到下个禧年之间的年数，然后按雇工的工价，照年数计算赎价。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","如果离禧年还有很多年，他就要按年数和当初卖价的比例偿还赎价。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","如果离禧年只有不多的几年，他就要按年数偿还赎身费。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","买主要待他如按年雇用的工人。你们要确保买主不会苛待他。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","如果禧年来临前他没有被赎回，到了禧年他和孩子们都要获得自由。 ");
INSERT INTO cmncbs_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","因为以色列人是我的仆人，是我从埃及领出来的仆人。我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“你们不可为自己制造偶像，不可竖立神像和神柱，也不可在你们境内安放祭拜用的石像。我是你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","你们要守我的安息日，敬畏我的圣所。我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","如果你们遵行我的律例，谨守我的诫命， ");
INSERT INTO cmncbs_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","我就按时降雨给你们，使土地长出庄稼、田间果树结出果实。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","你们要打粮食打到摘葡萄的时候，摘葡萄摘到播种的时候。你们必丰衣足食，安然居住。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“我要使你们境内太平，安枕无忧。我要除掉你们境内的猛兽，也要使你们免遭刀剑之灾。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","你们将追赶仇敌，使他们倒在你们刀下。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","你们五人要追赶一百人，一百人要追赶一万人，他们必死在你们刀下。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","我要眷顾你们，使你们生养众多，人丁兴旺，也要坚守与你们所立的约。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","你们存粮充足，甚至要搬出陈粮来储存新粮。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","我要住在你们中间，我必不厌弃你们。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","我要走在你们中间。我要做你们的上帝，你们要做我的子民。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","我是你们的上帝耶和华。我曾带领你们离开埃及，使你们不再做埃及人的奴隶。我打碎了你们身上的重轭，使你们昂首前行。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“如果你们不听从我，不遵行我的这一切诫命； ");
INSERT INTO cmncbs_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","如果你们弃绝我的律例，厌弃我的典章，不听从我的命令，破坏我与你们所立的约， ");
INSERT INTO cmncbs_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","我要惩罚你们，使你们陷入恐慌、患痨病和热症，使你们眼睛昏花、心力衰竭。你们撒种却一无所获，因为敌人要吃尽你们所种的。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","我要严惩你们，使你们败在敌人手下；你们要被那些恨你们的人统治，即使没有人追赶，你们也要逃命。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“如果你们经历这些后，仍然不听从我，我要使你为罪多受七倍的惩罚。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","我要重挫你们的傲气，使你们头上的天如铁，脚下的地如铜。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","你们劳作也是徒然，因为你们的土地必不长庄稼，果树也不结果实。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“如果你们仍然与我作对，不肯听从我，我要用七倍的灾难惩治你们的罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","我要让野兽攻击你们，残害你们的子女，吞噬你们的牲畜，使你们人口锐减，道路荒凉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“如果你们还是不服管教，继续与我作对， ");
INSERT INTO cmncbs_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","我也要与你们作对，用七倍的灾难惩治你们的罪。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","因为你们毁约，我要用战祸报应你们。你们躲进各城的时候，我要在你们中间降下瘟疫，使你们落在敌人手里。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","我要断绝你们的粮源。那时候，十个妇女将用一个烤炉烤饼，按定量分饼给你们，你们吃却吃不饱。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“如果你们仍然不肯听从我，继续与我作对， ");
INSERT INTO cmncbs_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","我也要与你们作对，向你们发烈怒，把比先前严厉七倍的惩罚加在你们身上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","你们要吃自己儿女的肉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","我要毁灭你们的丘坛，拆掉你们的香坛，把你们的尸体堆在你们的死偶像上。我必厌恶你们。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","我要使你们的城邑沦为废墟，使你们的敬拜场所荒凉，也不再悦纳你们的馨香之祭。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","我要使你们的土地荒废，连占据那里的敌人也为此而震惊。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","我要把你们驱散到各国，还要拔刀追杀你们。你们的土地将荒废，城邑将沦为废墟。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","你们被掳到敌国的时候，你们的土地将荒废，享受安息。那时土地必休息，享受安息。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","你们住在那里的时候，没有在安息年让土地安息，因此土地在荒废的日子里将享受安息。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“我要使你们当中的那些幸存者在敌国心惊胆战，过着风声鹤唳、惶恐不安的生活。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","即使无人追赶，他们也将仓皇逃命，互相绊倒，如同躲避刀剑一样。你们必无力抵挡敌人。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","你们将葬身列国，死在敌人的土地上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","你们当中的幸存者将因自己的罪和祖先的罪而消亡在敌人的土地上。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“如果他们承认自己和祖先的罪，就是背叛我、与我作对的恶行， ");
INSERT INTO cmncbs_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","以致我与他们作对，把他们流放到敌国；如果他们顽固的心谦卑下来，甘愿为罪受罚， ");
INSERT INTO cmncbs_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","我便顾念我与亚伯拉罕、以撒和雅各所立的约，眷顾那片土地。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","土地被他们离弃，荒无人烟，得享安息。他们却要因拒绝遵守我的典章、厌弃我的律例而饱受惩罚。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","然而，他们流落敌国的时候，我不会弃绝他们，不会因厌恶而毁灭他们，也不会违背我与他们所立的约。我是他们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","为了他们的缘故，我必顾念我与他们祖先所立的约。我曾在列国面前带领他们的祖先离开埃及，为要做他们的上帝。我是耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","以上是耶和华借摩西在西奈山上颁布给以色列人的律例、典章和法度。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“你要告诉以色列人：如果有人许下特别的愿，以付身价的方式奉献一个人给耶和华，就要为被奉献者估定身价。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","以圣所的秤为准，要为二十至六十岁的男子估价十两银子， ");
INSERT INTO cmncbs_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","女子则估价七两银子； ");
INSERT INTO cmncbs_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","五至二十岁的男子估价四两银子，女子则估价二两银子； ");
INSERT INTO cmncbs_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","满月至五岁的男子估价一两银子，女子则估价半两多银子； ");
INSERT INTO cmncbs_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","六十岁以上的男子估价三两银子，女子则估价二两银子。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","如果许愿的人因贫穷而负担不起，就要把他带到祭司面前，祭司要按他的能力另行估价。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“如果有人许愿献牲畜给耶和华作供物，所献的牲畜就会成为圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","不可更换所献的牲畜，不可以坏换好，也不可以好换坏。如果更换，两头牲畜都会成为圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","如果许愿献的是不洁净的牲畜，即不能献给耶和华作供物的牲畜，那人就要把牲畜带到祭司面前， ");
INSERT INTO cmncbs_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","由祭司评定它的好坏，祭司估价多少就是多少。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","那人如果有意赎回，必须支付祭司估定的价值，再加付五分之一。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“如果有人把房子分别出来献给耶和华，祭司就要评定房子的好坏，祭司估价多少就是多少。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","那人如果想赎回房子，必须支付祭司估定的价值，再加付五分之一，房子便仍归他所有。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“如果有人把自己继承的部分土地分别出来献给耶和华，祭司就要按照土地的播种量来估价，撒二百升大麦种子的土地值十两银子。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","如果有人在禧年奉献土地，所估的价便是定价。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","如果是在禧年以后献的，祭司要按照距下个禧年的年数来估价，估价要逐年减低。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","如果那人想赎回所献的土地，要在估价的基础上加付五分之一，土地便仍归他所有。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","他如果没有赎回土地，而是卖给别人，便再也不能赎回。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","到了禧年，那土地要像永远献给耶和华的土地一样归耶和华，成为祭司的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“如果献给耶和华的土地不是自己的产业，而是买来的， ");
INSERT INTO cmncbs_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","祭司就要按照距下个禧年的年数来估价。那人要当天付清地价，地价归耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","到了禧年，他要把所献的土地归还给卖主，就是土地的原主。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","所有价银的称量要以圣所的秤为准，即二十季拉为一舍客勒。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“洁净牲畜的头胎，无论是牛是羊，已经属于耶和华，任何人不可再把它献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","如果是不洁净牲畜的头胎，他可以在祭司的估价基础上，加付五分之一把它赎回；如果不赎回，就要按估价把它卖掉。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","凡永远献上的，不论是人、牲畜或是田产，都不可卖掉，也不可赎回，因为这一切都是耶和华的至圣之物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","凡永远献上的人不可被赎回，必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“土地的所有出产中，不论是谷物还是树上的果实，十分之一属于耶和华，是耶和华的圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","如果有人想从那十分之一中赎回一部分，他要加付估价的五分之一。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","至于牛羊，要让它们从牧人的杖下经过，每十只的第十只要归耶和华作圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","不论是好是坏，不可挑拣，不可更换。如果更换，两只都要作圣物，不可赎回。” ");
INSERT INTO cmncbs_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","以上是耶和华在西奈山上借摩西向以色列人颁布的诫命。");
INSERT INTO cmncbs_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","以色列人离开埃及后第二年的二月一日，耶和华在西奈旷野的会幕中对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“你要按以色列人的宗族和家系统计全体会众，登记所有男子的名字。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","你和亚伦要一队一队地统计以色列人中所有二十岁以上、有作战能力的男子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","每一支派要有一个人来协助你们。他们都是各宗族的族长， ");
INSERT INTO cmncbs_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","名单如下： “吕便支派示丢珥的儿子以利苏、 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","西缅支派苏利沙代的儿子示路蔑、 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","犹大支派亚米拿达的儿子拿顺、 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","以萨迦支派苏押的儿子拿坦业、 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","西布伦支派希伦的儿子以利押、 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","约瑟的后裔——以法莲支派亚米忽的儿子以利沙玛和玛拿西支派比大苏的儿子迦玛列、 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","便雅悯支派基多尼的儿子亚比但、 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","但支派亚米沙代的儿子亚希以谢、 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","亚设支派俄兰的儿子帕结、 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","迦得支派丢珥的儿子以利雅萨、 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","拿弗他利支派以南的儿子亚希拉。” ");
INSERT INTO cmncbs_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","他们都是从会众中选出来的，是各支派的首领，也是以色列的将领。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","摩西和亚伦带着这些被点名的人， ");
INSERT INTO cmncbs_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","在二月一日招聚全体会众，按照宗族和家系统计人口，一一登记所有二十岁以上的男子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","摩西照耶和华的吩咐在西奈旷野统计人口。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","以色列的长子吕便支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有四万六千五百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","西缅支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有五万九千三百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","迦得支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有四万五千六百五十人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","犹大支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有七万四千六百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","以萨迦支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有五万四千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","西布伦支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有五万七千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","约瑟的后裔中，以法莲支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有四万零五百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","玛拿西支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有三万二千二百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","便雅悯支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有三万五千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","但支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有六万二千七百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","亚设支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有四万一千五百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","拿弗他利支派中，二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来，共有五万三千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","以上就是摩西、亚伦和各代表自己族系的十二位以色列首领所统计的男子人数。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","这样，以色列人中二十岁以上、有作战能力的男子按宗族、家系和名字一一被登记下来， ");
INSERT INTO cmncbs_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","共有六十万三千五百五十人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","然而，利未人没有按祖先的支派列在其中， ");
INSERT INTO cmncbs_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","因为耶和华曾经对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“你不可统计利未支派的人数，不可把他们的人数算在以色列人中。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","你要派利未人管理、搬运和照料放约柜的圣幕及其所有器具和附属物，他们要在圣幕四围扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","在迁移的时候，利未人要负责拆卸和支搭圣幕。外人若近前来，必被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","以色列人要按照他们的队伍各自扎营，各归本旗。 ");
INSERT INTO cmncbs_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","但利未人要在安放约柜的圣幕四周扎营，以免以色列人触怒耶和华。利未人负责看守放约柜的圣幕。” ");
INSERT INTO cmncbs_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","以色列人就按耶和华对摩西的吩咐行了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“以色列人要各归本旗，按本族的旗号，在会幕四围稍远的地方安营。” ");
INSERT INTO cmncbs_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","东边，即日出的方向，是犹大营区及其旗号。犹大人的首领是亚米拿达的儿子拿顺， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","他的队伍有七万四千六百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","在犹大支派旁边安营的是以萨迦支派，以萨迦人的首领是苏押的儿子拿坦业， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","他的队伍有五万四千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","然后是西布伦支派，西布伦人的首领是希伦的儿子以利押， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","他的队伍有五万七千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","犹大营区的队伍共计十八万六千四百人，他们是前队。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","南边是吕便营区及其旗号。吕便人的首领是示丢珥的儿子以利苏， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","他的队伍有四万六千五百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","在吕便支派旁边安营的是西缅支派，西缅人的首领是苏利沙代的儿子示路蔑， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","他的队伍有五万九千三百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","然后是迦得支派，迦得人的首领是丢珥的儿子以利雅萨， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","他的队伍有四万五千六百五十人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","吕便营区的队伍共计十五万一千四百五十人，他们是第二队。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","随后是会幕和利未人的营区，在其他各营中间。他们各就各位，各归本旗，照安营时的次序出发。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","西边是以法莲营区及其旗号。以法莲人的首领是亚米忽的儿子以利沙玛， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","他的队伍有四万零五百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","以法莲支派旁边是玛拿西支派，玛拿西人的首领是比大苏的儿子迦玛列， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","他的队伍有三万二千二百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","然后是便雅悯支派，便雅悯人的首领是基多尼的儿子亚比但， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","他的队伍有三万五千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","以法莲营区的队伍共计十万八千一百人，他们是第三队。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","北边是但营区及其旗号。但人的首领是亚米沙代的儿子亚希以谢， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","他的队伍有六万二千七百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","在但支派旁边安营的是亚设支派，亚设人的首领是俄兰的儿子帕结， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","他的队伍有四万一千五百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","然后是拿弗他利支派，拿弗他利人的首领是以南的儿子亚希拉， ");
INSERT INTO cmncbs_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","他的队伍有五万三千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","但营区的队伍共计十五万七千六百人，他们是后队。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","以上是照家系和队伍统计的各营中的以色列人，共六十万三千五百五十名。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","照耶和华对摩西的吩咐，利未人没被统计在以色列人中。 ");
INSERT INTO cmncbs_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","于是，以色列人照耶和华对摩西的吩咐，各按自己的旗号安营，各按自己的宗族和家系启行。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","以下是耶和华在西奈山与摩西说话期间亚伦和摩西的后代。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","亚伦的长子是拿答，其他儿子是亚比户、以利亚撒和以他玛。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","亚伦的儿子都是受膏的祭司，由摩西授予他们圣职做祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","拿答和亚比户在西奈旷野用凡火向耶和华献祭时死在祂面前，没有留下儿子，因而只剩下以利亚撒和以他玛在父亲亚伦身边担任祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“你去叫利未支派来协助亚伦祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","他们要为亚伦和全体会众在会幕司职，办理圣幕的事务， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","也要负责看守会幕里面的所有器具，为以色列人办理圣幕的事务。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","你要把利未人交给亚伦父子们，因为他们是从以色列人中选出来单单协助亚伦的。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","你要指派亚伦父子们尽祭司的职分，外人若近前来，必被处死。” ");
INSERT INTO cmncbs_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","耶和华又对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“我从以色列人中拣选利未人代替以色列人所有的长子。利未人要属于我， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","因为所有头生的都属于我。我杀死埃及人所有的长子和头生的牲畜那天，已把以色列人所有的长子和头生的牲畜都分别出来，使之圣洁，归给我。我是耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","耶和华在西奈旷野对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“你要按利未人的宗族和家系统计他们的人口，登记所有年龄在一个月以上的男性。” ");
INSERT INTO cmncbs_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","于是，摩西照耶和华的吩咐统计利未人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","利未的儿子是革顺、哥辖和米拉利。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","按照宗族，革顺的儿子是立尼和示每。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","按照宗族，哥辖的儿子是暗兰、以斯哈、希伯仑和乌薛。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","按照宗族，米拉利的儿子是抹利和姆示。他们按家系都属于利未人的宗族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","革顺宗族有立尼和示每两个家族， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","其中年龄在一个月以上的男性共七千五百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","革顺宗族要在圣幕后面，即西面安营， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","家族首领是拉伊勒的儿子以利雅萨。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","革顺人负责看守会幕，即圣幕、圣幕的罩棚、顶盖和门帘、 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","围绕圣幕和祭坛的院子的帷幔、门帘、绳索及一切相关的物品。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","哥辖宗族有暗兰家族、以斯哈家族、希伯仑家族和乌薛家族， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","其中年龄在一个月以上的男性共有八千六百人，他们负责看守圣所。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","哥辖宗族要在圣幕南面安营， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","家族首领是乌薛的儿子以利撒反。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","他们负责照管约柜、桌子、灯台、两座坛、圣所内用的器具、幔子及一切物品。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","亚伦祭司的儿子以利亚撒是利未人的最高首领，负责监督那些照料圣所的人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","米拉利宗族有抹利和姆示两个家族， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","其中年龄在一个月以上的男性共六千二百人， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","家族领袖是亚比亥的儿子苏列。他们要在圣幕的北面安营。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","米拉利人负责照管圣幕的木板、横闩、柱子、带凹槽的底座、圣幕的一切器具和所有相关事务， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","还有院子四周的柱子及其带凹槽的底座、橛子和绳索。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","摩西、亚伦和亚伦的儿子们要在圣幕东面、朝日出的方向安营，替以色列人在圣所司职。外人若近前来，必被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","摩西和亚伦照耶和华的吩咐，按宗族统计利未人，年龄在一个月以上的男性共两万二千人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","耶和华对摩西说：“你要统计以色列人中年龄在一个月以上的长子，登记他们的名字。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","我是耶和华，你要把利未人归给我，代替以色列人所有的长子，也要把利未人的牲畜献给我，代替以色列人所有头生的牲畜。” ");
INSERT INTO cmncbs_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","摩西就照耶和华的吩咐，统计了以色列人的所有长子， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","年龄在一个月以上的共两万二千二百七十三人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","耶和华又对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“你要用利未人代替以色列人所有的长子，用利未人的牲畜代替以色列人所有头生的牲畜。利未人是属于我的，我是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","以色列人所有长子的人数比利未人总数多二百七十三人，这些多出来的人需要被赎回， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","每人一两银子，要以圣所的秤为准，即一舍客勒是二十季拉。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","要把多出来之人的赎银交给亚伦父子们。” ");
INSERT INTO cmncbs_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","摩西就收取了利未人所赎人数之外那些多出来之人的赎银， ");
INSERT INTO cmncbs_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","以圣所的秤计算，共从以色列人的长子收取了二百七十三两银子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","他照耶和华的吩咐，将赎银交给亚伦父子们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“你要按宗族和家系统计利未人中哥辖子孙的人数， ");
INSERT INTO cmncbs_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","登记所有可在会幕司职的三十岁到五十岁的男子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","他们在会幕里的职责是照料至圣之物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“拔营出发的时候，亚伦父子们要进会幕解下圣所和至圣所之间的幔子，用它遮盖约柜， ");
INSERT INTO cmncbs_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","再在上面依次盖上海狗皮和纯蓝色的布，然后穿上抬约柜的横杠。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“要在摆放供饼的桌子上铺一块蓝布，把盘、碟及献酒用的杯和瓶摆在上面。桌上要有常供的饼。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","这些东西上面要盖朱红色的布，再盖上海狗皮，然后穿上抬桌子的横杠。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“要用蓝布把灯台、灯盏、灯剪、灯盘和盛油的器皿全遮盖起来， ");
INSERT INTO cmncbs_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","再在上面盖上海狗皮，然后放在抬架上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“金坛上面要盖蓝色布，再盖上海狗皮，穿上抬金坛的横杠。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“圣所里面供职用的一切器皿都要用蓝色布包好，盖上海狗皮，放在抬架上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“要清除祭坛上的灰烬，铺上紫色布， ");
INSERT INTO cmncbs_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","然后把供职用的火鼎、肉叉、铲、碗等所有的祭坛器具都放在上面，再盖上海狗皮，穿上抬祭坛的横杠。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“拔营出发时，要等到亚伦父子们把圣所和圣所的所有器具都盖好后，哥辖的子孙才可以来抬。他们负责抬这些会幕的器具，但不可触摸这些圣物，免得死亡。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","亚伦祭司的儿子以利亚撒负责管理整个圣幕，以及里面的灯油、香料、日常献的素祭、膏油及一切器具和物品。” ");
INSERT INTO cmncbs_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“不可让哥辖宗族在利未人中灭绝。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","他们走近至圣之物以前，亚伦父子们要先进去指派他们做什么、抬什么，以免他们死亡。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","他们不可进去看圣物，一刻都不可，免得死亡。” ");
INSERT INTO cmncbs_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“你要按宗族和家系统计革顺子孙的人数， ");
INSERT INTO cmncbs_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","登记所有可在会幕司职的三十岁到五十岁的男子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","以下是革顺宗族负责的搬运工作及其他事务： ");
INSERT INTO cmncbs_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","“他们要抬圣幕的幔子、会幕、会幕顶盖、顶盖上的海狗皮、会幕门帘、 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","围绕圣幕和祭坛的院子的帷幔、院门门帘、绳索及司职用的一切器具，还负责其他相关事务。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","你们要把抬的任务分配给革顺的子孙，他们要遵照亚伦父子们的吩咐司职。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","这是革顺宗族的人在会幕里的职责，他们要按祭司亚伦的儿子以他玛的吩咐司职。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“你要按宗族和家系统计米拉利子孙的人数， ");
INSERT INTO cmncbs_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","登记所有可在会幕司职的三十岁到五十岁的男子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","他们在会幕里负责抬圣幕的木板、横闩、柱子、带凹槽的底座， ");
INSERT INTO cmncbs_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","院子四周的柱子及其带凹槽的底座、橛子、绳索和其他相关器具。你们要把当抬的物件一一指派给他们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","这是米拉利宗族的人在会幕的职责，由祭司亚伦的儿子以他玛监督。” ");
INSERT INTO cmncbs_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","于是，摩西、亚伦和会众的首领按宗族和家系统计哥辖的子孙， ");
INSERT INTO cmncbs_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","登记了所有可在会幕司职的三十岁到五十岁的男子， ");
INSERT INTO cmncbs_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","共两千七百五十人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","这是哥辖宗族在会幕司职的人数，是摩西和亚伦照耶和华的吩咐统计的。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","40","按宗族和家系统计，革顺的子孙中三十岁到五十岁、可在会幕司职的共两千六百三十人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","这是革顺宗族在会幕司职的人数，是摩西和亚伦照耶和华的吩咐统计的。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","44","按宗族和家系统计，米拉利的子孙中三十岁到五十岁、可在会幕司职的共三千二百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","这是米拉利宗族的人数，是摩西和亚伦照耶和华的吩咐统计的。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","摩西、亚伦和以色列人的首领按宗族和家系统计了利未人的人数， ");
INSERT INTO cmncbs_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","48","三十岁到五十岁、可司职和搬运会幕器具的利未人，共八千五百八十人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","照耶和华对摩西的吩咐，每个人都被统计在内，都有指定的职责和当抬的器具。这样，照耶和华对摩西的吩咐，人口统计完毕。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“你吩咐以色列人把所有患麻风病、漏症和因碰过死尸而不洁净的人， ");
INSERT INTO cmncbs_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","无论男女，都送到营外，免得他们玷污了营地，因为我住在其中。” ");
INSERT INTO cmncbs_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","以色列人遵命而行，照耶和华对摩西的吩咐，把这些人送到营外。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“你把以下条例告诉以色列人：无论男女，若亏负别人，以致失信于耶和华，就是犯罪。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","那人必须认罪，赔偿受害人全部损失，并加赔五分之一。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","如果受害人已死，又没有可以接受赔偿的近亲，赔偿就属于耶和华，要归祭司所有。那人还要再献上一只公绵羊为自己赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","以色列人带来奉献的一切圣物都要归祭司所有。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","各人奉献的圣物，无论是什么，都要归祭司所有。” ");
INSERT INTO cmncbs_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","14","“你把以下条例告诉以色列人：若有人怀疑妻子出轨，暗中与人通奸，玷污了自己，却没有证人，也没有当场抓住她，在无法确定是自己疑心还是妻子不贞的情况下， ");
INSERT INTO cmncbs_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","他要带妻子到祭司那里，同时为妻子带去一公斤大麦面粉作为供物。不可在上面浇油或加乳香，因为这是因疑心而献上的素祭，是让人回忆过犯的素祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“祭司要把那妇人带到耶和华面前， ");
INSERT INTO cmncbs_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","用陶器盛一些圣水，从圣幕的地上取一些尘土撒在水中， ");
INSERT INTO cmncbs_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","然后让那妇人站在耶和华面前，解开她的头发，把回忆过犯的素祭，就是因疑心而献的素祭放在她手里。祭司要拿着带给罪人咒诅的苦水， ");
INSERT INTO cmncbs_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","叫她发誓。祭司要对她说，‘如果你没有背着丈夫与人通奸，没有因出轨而玷污自己，就不会被这苦水所害。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","如果你曾出轨，背着丈夫与人通奸，以致玷污自己， ");
INSERT INTO cmncbs_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","愿耶和华使你大腿消瘦、肚腹肿胀，使你在同胞中成为咒诅。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","愿这可带来咒诅的苦水进入你体内，使你肚腹肿胀、大腿消瘦。’她要说，‘阿们！阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","祭司要把这咒诅写在书卷上，再放在苦水里把字洗掉。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","祭司要让妇人喝这可带来咒诅的苦水，不忠的妇人喝下后，肚子会感到剧痛。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","祭司要从妇人手中接过她丈夫因疑心而献的素祭，在耶和华面前摇一摇，然后带到祭坛那里。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","他要从素祭中取出一把面粉，作为象征放在祭坛上焚烧，然后叫那妇人喝下苦水。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","如果她曾玷污自己，背叛了丈夫，这可带来咒诅的苦水进入她体内后，会引起剧痛，使她肚腹肿胀、大腿消瘦，她将在同胞中成为咒诅。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","但如果她是贞洁的，没有玷污自己，就不会受伤害，仍能生育。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“这就是处理丈夫怀疑妻子不贞的条例。遇到妻子背着丈夫与人通奸， ");
INSERT INTO cmncbs_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","或是丈夫怀疑妻子不贞，就要让妻子站在耶和华面前，由祭司对她执行这条例。 ");
INSERT INTO cmncbs_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","无论结果怎样，丈夫都无罪，但妻子若有罪，必承担罪责。” ");
INSERT INTO cmncbs_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“你把以下条例告诉以色列人：无论男女，如果许愿做拿细耳人，把自己献给耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","就要禁戒淡酒和烈酒、淡酒或烈酒做的醋、葡萄汁、葡萄和葡萄干。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","在做拿细耳人期间，葡萄树所结的，包括葡萄核和葡萄皮，都不可吃。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","在许愿做拿细耳人期间，不可用剃刀剃头，要任由头发生长，要保持圣洁，一直到献给耶和华的日期满了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","在献给耶和华期间，不可挨近死尸， ");
INSERT INTO cmncbs_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","即使父母或是兄弟姊妹死了，也不可挨近，以免沾染不洁，因为他头上有将自己奉献给上帝的记号。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","在做拿细耳人期间，他是奉献给耶和华的人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","如果有人在他身边暴毙，使他的头发沾染不洁，他要在第七天洁净的日子剃掉头发。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","第八天，他要带两只斑鸠或雏鸽到会幕门口交给祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","祭司要献一只作赎罪祭，另一只作燔祭，为他碰过死尸赎罪。他要在当日使头圣洁， ");
INSERT INTO cmncbs_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","重新开始过奉献给耶和华的日子，还要带一只一岁的公羊羔作赎过祭。他以前做拿细耳人的日子无效，因为他沾染了不洁之物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“献给耶和华的日子期满后，拿细耳人要遵行以下条例。他要被带到会幕门口， ");
INSERT INTO cmncbs_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","在那里献给耶和华一只毫无残疾、一岁的公羊羔作燔祭，一只毫无残疾、一岁母羊羔作赎罪祭，一只毫无残疾的公绵羊作平安祭， ");
INSERT INTO cmncbs_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","一篮调油的无酵细面饼和涂油的无酵薄饼，以及素祭和奠祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","祭司要把这些祭物带到耶和华面前，为他献上赎罪祭和燔祭， ");
INSERT INTO cmncbs_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","然后把公绵羊和那篮无酵饼献给耶和华作平安祭，再献上素祭和奠祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","拿细耳人要在会幕门口剃掉作为奉献记号的头发，把头发放在平安祭下面的火里烧掉。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","拿细耳人剃头以后，祭司要取出一条煮好的公绵羊前腿，再从篮中拿出一块无酵饼和一块无酵薄饼，放在拿细耳人手中。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","然后，祭司要把这些祭物作为摇祭在耶和华面前摇一摇。这些祭物与作摇祭的胸肉和作举祭的腿肉一样，都是归给祭司的圣物。此后，拿细耳人便可以喝酒。 ");
INSERT INTO cmncbs_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“以上是许愿献供物给耶和华的拿细耳人当守的条例和当献的祭物。但如果他额外许愿献上力所能及之物，就必须还所许的愿。” ");
INSERT INTO cmncbs_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“你告诉亚伦父子们要这样为以色列人祝福， ");
INSERT INTO cmncbs_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘愿耶和华赐福给你，保护你； ");
INSERT INTO cmncbs_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","愿耶和华以祂的容光照耀你，施恩给你； ");
INSERT INTO cmncbs_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","愿耶和华笑颜垂顾你，赐你平安。’ ");
INSERT INTO cmncbs_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","他们要奉我的名为以色列人祝福，我必赐福给他们。” ");
INSERT INTO cmncbs_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","摩西支好圣幕后，便用膏油抹圣幕和其中的所有器具、祭坛和坛上的所有器具，使它们圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","然后，以色列各支派的首领，就是负责统计人口的各族长，都来奉献。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","他们把供物带到圣幕前献给耶和华：每两位首领奉献一辆篷车，每位首领奉献一头公牛，共六辆篷车和十二头公牛。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“你要收下他们的这些供物，按利未人的工作分配给他们，好用在会幕的工作中。” ");
INSERT INTO cmncbs_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","于是，摩西收下车和牛，交给利未人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","他按照革顺子孙的工作需要，分给他们两辆车和四头牛， ");
INSERT INTO cmncbs_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","按照米拉利子孙的工作需要，分给他们四辆车和八头牛。他们都在祭司亚伦的儿子以他玛的领导下任职。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","摩西没有把供物分给哥辖的子孙，因为他们要用肩扛所负责的圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","膏抹祭坛时，各首领都为献坛之礼带来供物，献在祭坛前。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","耶和华对摩西说：“每天要有一位首领为献坛之礼献上供物。” ");
INSERT INTO cmncbs_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","第一天来献供物的是犹大支派亚米拿达的儿子拿顺。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是亚米拿达的儿子拿顺的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","第二天来献供物的是以萨迦支派的首领、苏押的儿子拿坦业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是苏押的儿子拿坦业的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","第三天来献供物的是西布伦支派的首领、希伦的儿子以利押。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","一只作赎罪祭的公山羊， ");
INSERT INTO cmncbs_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是希伦的儿子以利押的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","第四天来献供物的是吕便支派的首领、示丢珥的儿子以利苏。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是示丢珥的儿子以利苏的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","第五天来献供物的是西缅支派的首领、苏利沙代的儿子示路蔑。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是苏利沙代的儿子示路蔑的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","第六天来献供物的是迦得支派的首领、丢珥的儿子以利雅萨。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是丢珥的儿子以利雅萨的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","第七天来献供物的是以法莲支派的首领、亚米忽的儿子以利沙玛。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是亚米忽的儿子以利沙玛的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","第八天来献供物的是玛拿西支派的首领、比大苏的儿子迦玛列。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是比大苏的儿子迦玛列的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","第九天来献供物的是便雅悯支派的首领、基多尼的儿子亚比但。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是基多尼的儿子亚比但的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","第十天来献供物的是但支派的首领、亚米沙代的儿子亚希以谢。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是亚米沙代的儿子亚希以谢的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","第十一天来献供物的是亚设支派的首领、俄兰的儿子帕结。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是俄兰的儿子帕结的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","第十二天来献供物的是拿弗他利支派的首领、以南的儿子亚希拉。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","他的供物是一个重一公斤半的银盘，一个重八百克的银碗，重量都以圣所的秤为准，都盛满作素祭的调了油的细面粉； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","一个重一百一十克盛满香的金碟子； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","作燔祭的一头公牛犊、一只公绵羊和一只一岁的公羊羔； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","一只作赎罪祭的公山羊； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","作平安祭的两头公牛、五只公绵羊、五只公山羊和五只一岁的公羊羔。这是以南的儿子亚希拉的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","以上是膏抹祭坛时，以色列各首领为献坛之礼所献的供物，共计有银盘、银碗和金碟子各十二个， ");
INSERT INTO cmncbs_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","以圣所的秤为准，每个银盘重一公斤半，每个银碗重八百克，共重二十七公斤半； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","以圣所的秤为准，盛满香的十二个金碟子每个重一百一十克，共重一千三百二十克； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","作燔祭的牲畜共有公牛犊十二头，公绵羊和一岁的公羊羔各十二只，还有一起献上的素祭以及作赎罪祭的公山羊十二只； ");
INSERT INTO cmncbs_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","作平安祭的牲畜共有公牛二十四头，公绵羊、公山羊、一岁的公羊羔各六十只。 以上是在膏抹祭坛后所献的供物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","摩西进入会幕要与耶和华说话时，听见耶和华从约柜的施恩座上、两个基路伯天使中间对他说话。耶和华就这样和他说话。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“你告诉亚伦，‘你安放灯的时候，七盏灯都要照在灯台前面。’” ");
INSERT INTO cmncbs_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","亚伦就照耶和华对摩西的吩咐把灯放好，使灯照亮灯台前面。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","整座灯台，从灯座到花朵，都是照耶和华指示摩西的样式用金子锤制而成的。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“你要把利未人从其他以色列人中分别出来，洁净他们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","要用以下的方法洁净他们，把洁净水洒在他们身上，叫他们用剃刀剃净全身，洗净衣服，这样他们就洁净了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","然后叫他们带来一头公牛犊及作素祭的调了油的细面粉，你要另献一头公牛犊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","你要招聚以色列全体会众，将利未人带到会幕前， ");
INSERT INTO cmncbs_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","带到耶和华面前，会众要把手按在他们身上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","亚伦要把他们献给耶和华，作为以色列人献的摇祭，使他们可以事奉耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","利未人要把手按在那两头公牛的头上，然后你要把一头作为赎罪祭，一头作为燔祭献给耶和华，好为利未人赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","你要让利未人站在亚伦父子们面前，把他们当作摇祭献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","这样，你就把利未人从其他以色列人中分别出来，使他们归给我。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","利未人被洁净、当作摇祭献上以后，就可以进会幕司职， ");
INSERT INTO cmncbs_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","因为在以色列人中，他们完全属于我，我拣选他们归我所有，以代替以色列人所有的长子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","以色列人所有的长子和头生的牲畜都属于我。我击杀埃及人所有的长子和头生的牲畜那天，已把以色列人所有的长子和头生的牲畜都分别出来，使之圣洁，归给我。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","我现在已拣选利未人代替以色列人所有的长子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","我从以色列人中把利未人作为礼物交给亚伦父子们，替以色列人在会幕中司职，为以色列人赎罪，免得以色列人因接近圣所而遭祸。” ");
INSERT INTO cmncbs_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","摩西、亚伦和以色列全体会众，就按照耶和华对摩西的吩咐把利未人献上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","利未人自洁、洗净衣服后，亚伦把他们当作摇祭献给耶和华，又为他们赎罪，使他们洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","之后，利未人便进入会幕，在亚伦父子们的监督下司职。以色列人照耶和华对摩西的吩咐奉献了利未人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“二十五岁以上的利未人都要到会幕司职， ");
INSERT INTO cmncbs_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","五十岁时退休，不再司职。 ");
INSERT INTO cmncbs_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","退休之后，他们可以协助本族弟兄看守会幕，不用再司职。你要这样给他们分派工作。” ");
INSERT INTO cmncbs_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","以色列人离开埃及后第二年的一月，耶和华在西奈旷野对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“以色列人要在指定的时间守逾越节， ");
INSERT INTO cmncbs_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","就是在一月十四日黄昏，按照相关律例和典章守逾越节。” ");
INSERT INTO cmncbs_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","于是，摩西吩咐以色列人守逾越节。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","一月十四日黄昏，以色列人在西奈旷野守逾越节。以色列人遵行了耶和华对摩西的一切吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","可是，有几个人因碰到死尸而不洁净，不能在那天守逾越节，他们就来见摩西和亚伦， ");
INSERT INTO cmncbs_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","说：“我们因碰到死尸而不洁净，为什么不准我们跟其他以色列人一起在指定的时间向耶和华献供物？” ");
INSERT INTO cmncbs_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","摩西说：“你们等一下，我要去听听耶和华对你们有什么吩咐。” ");
INSERT INTO cmncbs_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“你告诉以色列人： “你们或你们的子孙中，若有人因为碰了死尸而不洁净，或是出了远门，他们仍然要为耶和华守逾越节。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","他们可以在二月十四日黄昏守逾越节，要配无酵饼和苦菜一起吃逾越节的羊羔。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","食物不可留到早晨，也不可折断羊羔的一根骨头。要按照一切律例守逾越节。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","如果有人是洁净的，又没有出远门，却不守逾越节，要将他从民中铲除。因为他没有在指定的时间向耶和华献供物，就必须自负罪责。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","如果寄居在你们中间的外族人也想为耶和华守逾越节，他们也要按照这些律例和典章守逾越节。不论是外族人还是本地人，都要遵守同样的律例。” ");
INSERT INTO cmncbs_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","安放约柜的圣幕支起来那天，云彩遮盖了它。整个晚上，云彩在圣幕上方像火焰一般。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","之后，总是如此：白天云彩遮盖圣幕，晚上云彩像火。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","云彩什么时候从圣幕上升起，以色列人就启行；云彩在哪里停下来，以色列人就在哪里安营。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","他们无论启行还是安营，都遵照耶和华的吩咐。云彩在圣幕上停留多久，他们就安营多久。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","有时云彩在圣幕上停留多日，他们就遵照耶和华的吩咐安营多日。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","有时云彩在圣幕上只停留几天，他们就遵照耶和华的吩咐只安营几天。随后再照耶和华的吩咐启行。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","有时云彩整夜停留在圣幕上，到早晨才升起，他们就早晨才启行。不管白天黑夜，云彩一升起，他们就启行。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","不管是两天、一个月或是一年，只要云彩停留在圣幕上，以色列人就安营不动；云彩一升起，他们就启行。 ");
INSERT INTO cmncbs_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","他们遵照耶和华的吩咐安营，也遵照耶和华的吩咐启行。他们遵行耶和华借摩西吩咐的话。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“你要用银子打造两支号，用来招聚会众和发出拔营的号令。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","吹响两支号时，全体会众要在会幕门口聚集到你面前。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","如果只吹响一支号，担任首领的以色列各族长要聚集到你面前。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","如果吹响拔营的号令，在东面扎营的就要启行； ");
INSERT INTO cmncbs_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","第二次吹响拔营号令时，在南面扎营的就要启行。拔营号令是启行的信号。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","但吹号招聚会众时，不要用拔营号令。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","做祭司的亚伦子孙要负责吹号，这是你们世代当守的永久律例。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","当你们在自己的土地上跟来犯之敌作战时，要吹响两支号，你们的上帝耶和华必眷顾你们，救你们脱离敌人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","在节期和朔日这些欢乐的日子献燔祭和平安祭的时候，你们要吹号，好在你们的上帝面前蒙眷顾。我是你们的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","第二年的二月二十日，云彩从安放约柜的圣幕上升起， ");
INSERT INTO cmncbs_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","以色列人就从西奈旷野启行，直到云彩停在巴兰旷野时才停下来。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","这是他们初次照耶和华借摩西的吩咐启行。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","犹大旗下的营队率先出发，率领犹大支派的是亚米拿达的儿子拿顺， ");
INSERT INTO cmncbs_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","率领以萨迦支派的是苏押的儿子拿坦业， ");
INSERT INTO cmncbs_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","率领西布伦支派的是希伦的儿子以利押。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","然后，圣幕被拆卸，革顺和米拉利的子孙抬着圣幕出发。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","随后出发的是吕便旗下的营队，率领吕便支派的是示丢珥的儿子以利苏， ");
INSERT INTO cmncbs_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","率领西缅支派的是苏利沙代的儿子示路蔑， ");
INSERT INTO cmncbs_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","率领迦得支派的是丢珥的儿子以利雅萨。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","随后出发的是哥辖人，他们抬着圣物前行。在他们到达之前，圣幕应已支好。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","随后出发的是以法莲旗下的营队，率领以法莲支派的是亚米忽的儿子以利沙玛， ");
INSERT INTO cmncbs_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","率领玛拿西支派的是比大苏的儿子迦玛列， ");
INSERT INTO cmncbs_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","率领便雅悯支派的是基多尼的儿子亚比但。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","殿后的是但旗下的营队，率领但支派的是亚米沙代的儿子亚希以谢， ");
INSERT INTO cmncbs_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","率领亚设支派的是俄兰的儿子帕结， ");
INSERT INTO cmncbs_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","率领拿弗他利支派的是以南的儿子亚希拉。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","这是以色列各营队拔营前行的次序。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","摩西对岳父米甸人流珥之子何巴说：“我们就要动身前往耶和华应许给我们的地方，祂曾说要把那地方赐给我们。请你跟我们一起去吧，我们必厚待你，耶和华已经应许要赐福给以色列人。” ");
INSERT INTO cmncbs_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","何巴说：“我不去了，我要回到我的家乡和亲族那里。” ");
INSERT INTO cmncbs_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","摩西说：“请不要离开我们。你熟悉旷野，可以做我们的向导，告诉我们在哪里扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","如果你跟我们同去，我们一定与你分享耶和华赐给我们的福气。” ");
INSERT INTO cmncbs_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","以色列人离开耶和华的山，走了三天的路程，期间耶和华的约柜一直在队伍的前头，为他们寻找安歇之地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","他们拔营前行的时候，白天总有耶和华的云彩在他们上面。 ");
INSERT INTO cmncbs_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","每当约柜出发的时候，摩西就说：“耶和华啊，求你兴起，击溃你的仇敌，使恨你的人从你面前逃窜。” ");
INSERT INTO cmncbs_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","约柜停下来的时候，他就说：“耶和华啊，求你回到以色列的千万人中。” ");
INSERT INTO cmncbs_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","民众因为困难而发怨言，传到耶和华耳中。耶和华听见后便向他们发怒，使火在他们中间燃烧，烧毁了营地的边缘部分。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","民众呼求摩西，摩西便向耶和华祷告，火就熄了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","那地方叫他备拉，因为耶和华的火曾在他们中间燃烧。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","他们中间有一群乌合之众贪恋美食，以色列人也哭着说：“要是有肉吃多好啊！ ");
INSERT INTO cmncbs_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","还记得在埃及的时候，我们不花钱就可以吃鱼，还有黄瓜、西瓜、韭菜、葱和蒜。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","我们现在毫无胃口，眼前除了吗哪外，什么都没有。” ");
INSERT INTO cmncbs_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","吗哪的形状像芫荽籽，又像珍珠。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","每天晚上露水降在营地上时，吗哪也随着降下来。早晨民众到四周捡吗哪，把吗哪用磨磨碎或在臼中捣碎后，放在锅里煮，再做成饼，味道就像油饼。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","摩西感到难过，因为他听见民众都在自己帐篷门口哭泣，以致耶和华大发烈怒。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","他对耶和华说：“你为什么苦待仆人？我做了什么令你不悦的事，你竟把管理这些民众的重担放在我身上？ ");
INSERT INTO cmncbs_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","难道是我孕育生养了他们吗？为什么你要我像父亲呵护吃奶的婴儿一样，把他们抱到你应许给他们祖先的地方呢？ ");
INSERT INTO cmncbs_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","他们都哭着向我要肉吃，我去哪里找肉给他们吃呢？ ");
INSERT INTO cmncbs_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","管理民众的责任实在是太重了，我一个人担当不起啊！ ");
INSERT INTO cmncbs_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","你既然这样对待我，求你施恩杀了我吧，别让我受苦了！” ");
INSERT INTO cmncbs_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","耶和华对摩西说：“你给我招聚七十个以色列人的长老，就是你所了解的长老和首领，把他们带到会幕，让他们站在你身边。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","我要在那里降临，对你说话，把降在你身上的灵也赐给他们，让他们为你分担管理民众的责任，免得你独自承担。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","你要叫民众洁净自己，明天就会有肉吃。因为我听见了他们哭着要肉吃、说埃及的日子更好，我必给他们肉吃。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","他们将不止吃一天、两天、五天、十天或二十天， ");
INSERT INTO cmncbs_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","而是要吃整整一个月，直到肉从他们鼻孔里喷出来，令他们厌腻。因为他们厌弃住在他们中间的我，在我面前哭诉，后悔离开埃及。” ");
INSERT INTO cmncbs_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","摩西说：“和我同行的，仅男子就有六十万，你还说要让他们吃整整一个月的肉！ ");
INSERT INTO cmncbs_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","就是把牛羊都宰了，够他们吃吗？就是把海里的鱼都捕来，够他们吃吗？” ");
INSERT INTO cmncbs_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","耶和华说：“难道我的臂膀短小无力吗？你很快将看见我的话会不会应验。” ");
INSERT INTO cmncbs_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","摩西就出去把耶和华的话转告民众，又召集了七十位长老，叫他们站在会幕周围。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","耶和华在云中降临，对摩西说话，把降在摩西身上的灵也赐给七十位长老。灵一降在他们身上，他们就说起预言来，但只说了这一次。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","七十位长老中的伊利达和米达没有到会幕去，但耶和华的灵也降在他们身上，他们就在营中说起预言来。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","有一个青年跑去禀告摩西说：“伊利达和米达正在营中说预言。” ");
INSERT INTO cmncbs_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","摩西拣选的助手嫩的儿子约书亚就说：“我主摩西，请你禁止他们。” ");
INSERT INTO cmncbs_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","摩西说：“你是为我的缘故而嫉妒吗？愿耶和华的子民都成为先知！愿耶和华把祂的灵降在他们身上！” ");
INSERT INTO cmncbs_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","之后，摩西和以色列的长老都返回营中。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","耶和华刮起一阵风，把鹌鹑从海面刮到营地四周，约一米厚，方圆数公里。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","民众花了两天一夜的时间去捕捉鹌鹑，每人至少捉了一吨半。他们把鹌鹑摊在营地的周围。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","他们口中的肉还没嚼烂，耶和华的怒气就已向他们发作，降下了大灾。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","因此，那地方叫基博罗·哈他瓦，因为那些贪食之徒埋葬在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","民众从基博罗·哈他瓦前往哈洗录，在哈洗录住了下来。 ");
INSERT INTO cmncbs_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","米利暗和亚伦因摩西娶了一个古实的女子而批评他，说： ");
INSERT INTO cmncbs_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“难道耶和华只借着摩西说话吗？祂不也借着我们说话吗？”耶和华听见了这话。 ");
INSERT INTO cmncbs_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","其实摩西为人十分谦和，比世上任何人都谦和。 ");
INSERT INTO cmncbs_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","耶和华突然对摩西、亚伦和米利暗说：“你们三人都出来到会幕去。”他们就去了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","耶和华在云柱中降临，站在会幕门口呼唤亚伦和米利暗，二人就走到前面。 ");
INSERT INTO cmncbs_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","耶和华说：“你们听我说，你们中间若有先知，我耶和华必在异象中向他显现，在梦中跟他说话。 ");
INSERT INTO cmncbs_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","但我不是这样对待我的仆人摩西，他在我家里忠信可靠， ");
INSERT INTO cmncbs_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","我跟他面对面说话，清清楚楚，不用谜语，他看得见我的形象。你们怎敢批评我的仆人摩西？” ");
INSERT INTO cmncbs_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","耶和华向他们发怒，然后离去。 ");
INSERT INTO cmncbs_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","云彩从会幕上离开的时候，米利暗身上患了麻风病，像雪一样白。亚伦见状， ");
INSERT INTO cmncbs_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","便对摩西说：“我主啊，求你不要因我们愚昧犯罪而惩罚我们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","求你不要让她像那一出母腹便半身腐烂的死胎。” ");
INSERT INTO cmncbs_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","于是，摩西呼求耶和华：“上帝啊，求你医治她！” ");
INSERT INTO cmncbs_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","耶和华对摩西说：“如果她父亲在她脸上吐唾沫，她岂不也要蒙羞七天吗？现在把她关在营外，七天后再让她回来。” ");
INSERT INTO cmncbs_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","于是，米利暗被关在营外七天，民众等她回营后才继续前行。 ");
INSERT INTO cmncbs_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","他们离开哈洗录，到巴兰旷野安营。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“你要派十二位首领，每个支派一位，去打探我要赐给以色列人的迦南。” ");
INSERT INTO cmncbs_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","摩西就按耶和华的吩咐，从巴兰旷野派出了以色列人的十二位首领。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","他们的名字如下：吕便支派撒刻的儿子沙姆亚， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","西缅支派何利的儿子沙法， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","犹大支派耶孚尼的儿子迦勒， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","以萨迦支派约色的儿子以迦， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","以法莲支派嫩的儿子何西阿， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","便雅悯支派拉孚的儿子帕提， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","西布伦支派梭底的儿子迦叠， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","约瑟的子孙、玛拿西支派稣西的儿子迦底， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","但支派基玛利的儿子亚米利， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","亚设支派米迦勒的儿子西帖， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","拿弗他利支派缚西的儿子拿比， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","迦得支派玛基的儿子臼利。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","以上是摩西派去打探迦南的人，他称嫩的儿子何西阿为约书亚。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","摩西派他们去打探迦南，并嘱咐说：“你们先去南地，然后再进山区， ");
INSERT INTO cmncbs_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","察看那地方，看看那里的居民是强是弱，是多是少； ");
INSERT INTO cmncbs_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","他们住的地方是好是坏，人们住的是坚固的城池还是不设防的营地； ");
INSERT INTO cmncbs_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","土地是肥沃还是贫瘠，有没有树木。尽力带些当地的果子回来。”当时是葡萄初熟的季节。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","于是，他们从荀旷野一直打探到哈马口附近的利合。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","他们经南地到达希伯仑。希伯仑城比埃及的琐安城还要早建七年，那里住着亚衲人的子孙亚希幔、示筛和挞买。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","他们来到以实各谷，在那里砍下一根葡萄枝，上面有一串葡萄，由两个人用杠子抬着，又采了一些石榴和无花果。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","因为他们在那里砍了一串葡萄，所以就称那地方为以实各谷。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","过了四十天，他们打探完毕，返回营地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","他们来到巴兰旷野的加低斯向摩西、亚伦和以色列全体会众汇报，把当地的果子给大家看。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","他们对摩西说：“我们到了你派我们去的那地方，果然是奶蜜之乡，这些都是那里的果子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","但那里的居民很强悍，城邑高大坚固。我们在那里还见到亚衲人的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","亚玛力人住在南地，赫人、耶布斯人和亚摩利人住在山区，迦南人住在海边和约旦河沿岸。” ");
INSERT INTO cmncbs_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","迦勒让站在摩西面前的民众安静，然后说：“我们立刻上去占领那地方吧！我们必能取胜。” ");
INSERT INTO cmncbs_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","跟他一起去打探的人却说：“我们不能上去攻打那些人，他们比我们强大。” ");
INSERT INTO cmncbs_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","他们还危言耸听，说：“我们去打探的地方是吞吃居民之地，我们看见的人个个身材高大。 ");
INSERT INTO cmncbs_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","我们在那里看见了亚衲人的子孙，他们是巨人的后裔，我们跟他们相比就像蚱蜢，他们看我们也像蚱蜢。” ");
INSERT INTO cmncbs_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","当晚，全体会众放声大哭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","全体以色列会众埋怨摩西和亚伦说：“我们还不如死在埃及或旷野！ ");
INSERT INTO cmncbs_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","耶和华为什么把我们领到这里来，让我们死于刀下？我们的妻儿必被掳去。我们还不如返回埃及。” ");
INSERT INTO cmncbs_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","他们彼此议论说：“我们选一位首领带我们回埃及吧！” ");
INSERT INTO cmncbs_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","摩西和亚伦俯伏在以色列全体会众面前。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","打探迦南的人中，嫩的儿子约书亚和耶孚尼的儿子迦勒撕裂衣服， ");
INSERT INTO cmncbs_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","对以色列全体会众说：“我们去打探的地方极其美好。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","如果耶和华喜悦我们，祂必把我们带到那片土地，将那奶蜜之乡赐给我们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","你们不要背叛耶和华，也不要害怕那里的人，他们不过是我们的猎物，他们已失去庇护。耶和华与我们同在，不要怕他们。” ");
INSERT INTO cmncbs_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","但全体会众威胁要用石头打死他们二人。这时耶和华的荣光在会幕中向全体以色列人显现。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","耶和华对摩西说：“这些人藐视我要到何时呢？我在他们中间行了这么多神迹，他们还要不信我到何时呢？ ");
INSERT INTO cmncbs_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","我要用瘟疫毁灭他们，不让他们承受那片土地。但我要使你成为大国，比他们更强盛。” ");
INSERT INTO cmncbs_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","摩西对耶和华说：“你曾经用大能把以色列人从埃及领出来，埃及人听说这事后， ");
INSERT INTO cmncbs_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","一定会告诉迦南的居民。那里的居民早已听说你耶和华与以色列人同在，你面对面向他们显现，你的云彩停留在他们上面，你白天用云柱、黑夜用火柱引导他们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","如果你把他们全部消灭，那些听过你威名的列国就会议论说， ");
INSERT INTO cmncbs_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘耶和华无法把以色列人领到祂起誓要赐给他们的地方，所以在旷野把他们杀了。’ ");
INSERT INTO cmncbs_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","因此，求主彰显伟大的权能，正如你所宣告的， ");
INSERT INTO cmncbs_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘耶和华不轻易发怒，充满慈爱；祂赦免罪恶和过犯，但决不免除罪责，必向子孙追讨父辈的罪债，直到三四代。’ ");
INSERT INTO cmncbs_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","从他们离开埃及直到现在，你一直在饶恕他们，求你以伟大的慈爱再次赦免这些人的罪。” ");
INSERT INTO cmncbs_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","耶和华说：“我听你的祈求，赦免他们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","但我凭我的永恒起誓，正如大地充满我的荣耀一样确实， ");
INSERT INTO cmncbs_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","他们绝对一个也看不到我起誓要赐给他们祖先的土地，藐视我的人都看不到那片土地。这些人见过我的荣耀，见过我在埃及和旷野所行的神迹，却仍然不听我的话，试探我十次之多。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","但我的仆人迦勒力排众议，全心跟从我，所以我必带他进入那片他去过的土地，让他的子孙拥有那片产业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","由于亚玛力人和迦南人住在山谷中，明天你们要转回，沿红海的路前往旷野。” ");
INSERT INTO cmncbs_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“这邪恶的会众向我发怨言要到何时呢？我已听见以色列人对我的埋怨。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","你们去把我的话告诉他们，‘以色列人啊，我凭我的永恒起誓，我必照你们所说的对待你们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","你们当中凡登记在册、二十岁以上向我发怨言的人，必倒毙在这旷野中， ");
INSERT INTO cmncbs_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","除耶孚尼的儿子迦勒和嫩的儿子约书亚之外，你们无人能进入我向你们起誓应许之地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","你们说你们的儿女会被掳去，但我要把他们带到那里，让他们享有那片你们厌弃的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","而你们必死在这旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","你们的儿女要在旷野飘泊四十年，为你们的不忠而受苦，直到你们都死在旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","你们打探了那地方四十天，你们要为自己的罪受苦四十年，一年顶一天。那时，你们就知道与我为敌的后果。’ ");
INSERT INTO cmncbs_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","我耶和华已经说过，我必这样对付这群集合起来与我为敌的邪恶会众。他们必死在旷野，全部丧命。” ");
INSERT INTO cmncbs_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","摩西派去打探迦南的人回来以后危言耸听，以致全体会众向摩西发怨言。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","这些危言耸听的人因而染上瘟疫，死在耶和华面前。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","前去打探的人中只有嫩的儿子约书亚和耶孚尼的儿子迦勒得以幸存。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","摩西传达完耶和华的话后，以色列人非常悲伤。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","他们清早起来上到山顶，说：“我们知罪了，现在我们要去耶和华应许的地方。” ");
INSERT INTO cmncbs_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","摩西说：“你们为什么要违背耶和华的命令？你们不会成功的。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","不要上去！因为耶和华不与你们同在，你们会被敌人打败。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","你们会遇见亚玛力人和迦南人，并丧身在他们刀下，因为你们离弃耶和华，祂不再与你们同在。” ");
INSERT INTO cmncbs_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","尽管耶和华的约柜和摩西都没有出营，他们却擅自上山顶去。 ");
INSERT INTO cmncbs_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","住在山区的亚玛力人和迦南人下来击溃了他们，一路追杀他们到何珥玛。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“你把以下条例告诉以色列人。 “你们进入耶和华赐给你们的家园后， ");
INSERT INTO cmncbs_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","要用牛羊作火祭献给耶和华，作蒙耶和华悦纳的馨香之祭。不管是献燔祭、还愿祭、自愿献的祭还是节期的祭，都当如此。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","献祭者要同时将一公斤细面粉调上一升油，作素祭献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","无论燔祭还是别的祭，每献一只羊羔，要同时献上一升酒作奠祭； ");
INSERT INTO cmncbs_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","每献一只公绵羊，要同时将两公斤细面粉调上一升半油作素祭献上， ");
INSERT INTO cmncbs_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","还要献一升半酒作奠祭。这是蒙耶和华悦纳的馨香之祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","如果用公牛献给耶和华作燔祭、还愿祭或平安祭， ");
INSERT INTO cmncbs_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","就要将三公斤细面粉调上两升油作素祭和公牛一同献上， ");
INSERT INTO cmncbs_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","还要献上两升酒作奠祭。这是蒙耶和华悦纳的馨香之祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“献公牛、公绵羊、绵羊羔或山羊羔时，都要这样办理。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","无论献多少牲畜，每只都要这样办理。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","凡以色列人献上蒙耶和华悦纳的馨香火祭时，都要这样办理。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","住在你们中间的外族人，不管是暂住还是世代居住的，若愿意献上蒙耶和华悦纳的馨香火祭，也要这样办理。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","以色列人和寄居的外族人都要遵守一样的条例，永世不变。你们在耶和华面前怎样做，外族人也要怎样做。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","你们和寄居在你们那里的外族人要遵行一样的条例和规定。” ");
INSERT INTO cmncbs_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“你把以下条例告诉以色列人。 “你们到达耶和华领你们去的地方， ");
INSERT INTO cmncbs_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","吃当地的出产时，要拿出一份作举祭献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","你们要用初熟的麦子磨面做饼，当作举祭献上，好像献麦场的举祭一样。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","你们世世代代都要用初熟的麦子磨面，当作举祭献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“如果你们无意间违背了耶和华借摩西吩咐你们遵守的命令， ");
INSERT INTO cmncbs_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","就是吩咐你们从祂颁布之日起，要世世代代遵守的命令， ");
INSERT INTO cmncbs_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","如果是因会众的无知而造成无心之过，全体会众就要献上一头公牛犊作燔祭，作蒙耶和华悦纳的馨香之祭，同时按规定献上素祭和奠祭，外加一只公山羊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","祭司要为以色列全体会众赎罪，这样他们就得到了赦免，因为是无心之过，并且他们已经向耶和华献上火祭和赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","这样，以色列全体会众和寄居的外族人都必蒙赦免，因为无心之过牵涉到所有人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“倘若是个人无意间犯了罪，他就要献上一只一岁的母山羊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","祭司要为这无意间犯罪的人在耶和华面前赎罪，使他获得赦免。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","无论是以色列人或是寄居的外族人，凡是犯无心之过的都要按这规条办理。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","但不管是以色列人还是外族人，若任意妄为，亵渎了耶和华，都要从民中被铲除， ");
INSERT INTO cmncbs_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","因为他藐视耶和华的话，违背耶和华的命令，必须被铲除，罪责自负。” ");
INSERT INTO cmncbs_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","以色列人在旷野的时候，发现有人在安息日捡柴， ");
INSERT INTO cmncbs_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","他们就把捡柴的人带到摩西、亚伦和全体会众那里， ");
INSERT INTO cmncbs_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","把他关起来，因为不知道如何处置他。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","耶和华对摩西说：“必须处死那人，全体会众要在营外用石头打死他。” ");
INSERT INTO cmncbs_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","于是，全体会众照耶和华对摩西的吩咐，把他拉到营外，用石头打死了他。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“你要吩咐以色列人世世代代在衣角缝上穗子，穗子上系一条蓝色细带。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","穗子是用来提醒他们，要遵行我的一切命令，不要随从自己心中和眼目的情欲而背信弃义。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","这样，你们就会记得遵守我的一切命令，做你们上帝的圣洁之民。 ");
INSERT INTO cmncbs_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","我是你们的上帝耶和华，我把你们从埃及领出来，是要做你们的上帝。我是你们的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","可拉是利未的曾孙、哥辖的孙子、以斯哈的儿子。他跟吕便支派以利押的两个儿子大坍和亚比兰，以及比勒的儿子安， ");
INSERT INTO cmncbs_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","联合二百五十名在以色列会众中有声望的首领反叛摩西， ");
INSERT INTO cmncbs_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","一起攻击摩西和亚伦，说：“你们太过分了！全体会众都是圣洁的，有耶和华住在他们当中，你们凭什么将自己置于耶和华的会众之上？” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","摩西听了这话，就俯伏在地， ");
INSERT INTO cmncbs_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","对可拉一伙人说：“到了明天早上，耶和华必显明谁是属于祂的，谁是圣洁的。祂必让祂所拣选的人到祂面前。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","可拉啊，你们要这样做，你和你的同伙明天带香炉来， ");
INSERT INTO cmncbs_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","在耶和华面前点火添香。耶和华拣选谁，谁就是圣洁的。你们利未人太过分了！” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","摩西又对可拉说：“利未人啊，你们听我说！ ");
INSERT INTO cmncbs_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","以色列的上帝把你们从以色列会众中分别出来，使你们可以到祂面前，在祂的圣幕里司职，替会众办事，你们还不满足吗？ ");
INSERT INTO cmncbs_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","可拉啊，耶和华使你和其他利未人事奉祂，你们还要贪求祭司的职分吗？ ");
INSERT INTO cmncbs_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","其实你和你的同伙合谋反叛的是耶和华。亚伦是何人，你们竟埋怨他？” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","摩西派人去召以利押的儿子大坍和亚比兰，他们却说：“我们不去！ ");
INSERT INTO cmncbs_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","你带我们离开奶蜜之乡，要让我们死在旷野，这还不够吗？你还想自立为王管辖我们吗？ ");
INSERT INTO cmncbs_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","你并没有领我们到奶蜜之乡，也没有给我们田地和葡萄园作产业，你还想继续蒙骗我们吗？我们不去！” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","摩西非常愤怒，就对耶和华说：“求你不要接纳他们的祭物。我没有取过他们一头驴，也没有害过他们任何人。” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","摩西对可拉说：“明天你和你的同伙要跟亚伦一起站在耶和华面前。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","每人要拿自己的香炉，放上香，带到耶和华面前，共二百五十个。你和亚伦也要各拿自己的香炉。” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","于是，他们都拿着香炉，盛着火和香，跟摩西和亚伦一起站在会幕门口。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","可拉把全体会众招聚到会幕门口，要对付摩西和亚伦。这时，耶和华的荣光向全体会众显现。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“你们离开这些会众，我好在顷刻之间消灭他们。” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","摩西和亚伦就伏在地上说：“上帝啊，赐人生命气息的上帝啊！一人犯罪，你就要向全体会众发怒吗？” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“你叫会众离可拉、大坍和亚比兰的帐篷远一点。” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","于是，摩西起来去大坍和亚比兰那里，以色列的长老也跟着他。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","他对会众说：“你们离这些恶人的帐篷远一点，不要碰他们的任何东西，免得你们因他们的罪而受牵连，同遭毁灭。” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","会众便离开可拉、大坍和亚比兰的帐篷。大坍和亚比兰带着妻小出来，站在自己的帐篷门口。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","摩西对会众说：“你们很快就知道，我所做的事都是奉耶和华之命而行，并非出于私意。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","如果这些人像常人一样死去，遭遇跟世人无异，我就不是耶和华派来的。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","但如果耶和华做一件前所未有的事，使地裂开，吞下他们和属于他们的一切，使他们活生生地坠入阴间，你们就知道这些人藐视耶和华了。” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","摩西的话刚说完，这些人脚下的地就裂开， ");
INSERT INTO cmncbs_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","吞下了他们和他们的家眷，以及所有可拉一伙的人和财物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","他们和属于他们的一切就这样活活地坠入阴间，地在他们上面合拢起来，他们就从会众中灭亡了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","他们四围的以色列人听到他们的喊叫声，纷纷逃跑，生怕自己也被地吞下去。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","耶和华又降下烈火，烧死了那二百五十个献香的人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“你叫亚伦祭司的儿子以利亚撒去从火中把香炉捡起来，把炭火撒在远处，因为那些香炉是圣洁的。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","要把那些因犯罪而丧命之人的香炉打成薄片，用来包祭坛，因为那些香炉曾被献在耶和华面前，是圣洁的，并且可让以色列人引以为戒。” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","于是，以利亚撒祭司取来被烧死之人所献的铜香炉，叫人打成薄片用来包祭坛， ");
INSERT INTO cmncbs_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","让以色列人引以为戒，使亚伦子孙以外的人不致到耶和华面前烧香，以免像可拉及其同伙一样灭亡。这是按照耶和华借摩西的吩咐做的。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","第二天，以色列全体会众都埋怨摩西和亚伦说：“你们害死了耶和华的子民。” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","会众聚集起来反对摩西和亚伦，他们向会幕观看，忽然有云彩遮盖了会幕，耶和华的荣光显现。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","摩西和亚伦来到会幕前， ");
INSERT INTO cmncbs_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“你们离开这些会众，我好在顷刻之间消灭他们。”他们二人就俯伏在地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","摩西对亚伦说：“取香炉来，里面放些祭坛上的火，添上香，赶快带到会众那里为他们赎罪，因为耶和华发怒了，瘟疫已经开始。” ");
INSERT INTO cmncbs_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","亚伦就照着摩西的吩咐取来香炉，跑到会众当中。那时瘟疫已经在人群中蔓延起来。他就在炉中放上香为民众赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","他站在活人和死人之间，瘟疫就止住了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","除了在可拉事件中死亡的人以外，有一万四千七百人死于瘟疫。 ");
INSERT INTO cmncbs_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","瘟疫止住后，亚伦便回到在会幕门口的摩西那里。 ");
INSERT INTO cmncbs_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“你要吩咐以色列人从每个支派的首领那里拿一根杖来，共十二根，你要在上面写上他们各人的名字。 ");
INSERT INTO cmncbs_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","你要把亚伦的名字写在利未支派的杖上，每个支派的首领都要有一根杖。 ");
INSERT INTO cmncbs_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","你要把这些杖放在会幕内的约柜前，就是我跟你会面的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","谁的杖发芽，谁就是我所拣选的人。这样，我必消除以色列人对你们的埋怨。” ");
INSERT INTO cmncbs_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","于是，摩西吩咐以色列每个支派的首领把杖都交给他，共十二根，亚伦的杖也在其中。 ");
INSERT INTO cmncbs_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","摩西把杖放在放约柜的圣幕里、耶和华面前。 ");
INSERT INTO cmncbs_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","第二天，摩西进入约柜所在的圣幕里，看见利未支派亚伦的杖不单发了芽，长了花蕾，还开了花，结出熟杏。 ");
INSERT INTO cmncbs_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","摩西就从耶和华面前拿出所有的杖，给以色列人看。他们看后，各位首领便取回自己的杖。 ");
INSERT INTO cmncbs_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","耶和华对摩西说：“把亚伦的杖放回约柜前，让叛逆之徒引以为戒。这样，你就可以平息他们对我的怨言，使他们不致灭亡。” ");
INSERT INTO cmncbs_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","摩西照耶和华的吩咐行了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","以色列人对摩西说：“完了！我们死定了！我们全死定了！ ");
INSERT INTO cmncbs_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","凡走近耶和华圣幕的都要死。我们全都要灭亡吗？” ");
INSERT INTO cmncbs_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","耶和华对亚伦说：“你和你的儿子及亲族要承担触犯圣所的罪责；你和你儿子也要承担触犯祭司职务的罪责。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","你和你儿子在安放约柜的圣幕前供职时，要把你们利未支派的亲族也一同带去，让他们协助你。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","他们要遵守你的吩咐，看守整个圣幕，但不可接近圣所的器具和祭坛，以免他们和你们都死亡。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","他们要和你一起负责看守圣幕，办理圣幕的一切事务。外人不可靠近。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","你们要看守圣所和祭坛，以免我的愤怒再临到以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","我已从以色列人中选出你们的利未亲族归给我，协助你们在会幕中司职。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","你和你儿子要尽祭司的本分，负责祭坛和至圣所的一切事务。祭司的职分是我赏赐给你们的，外人若近前来，必被处死。” ");
INSERT INTO cmncbs_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","耶和华对亚伦说：“你看！我让你照管以色列人献给我的举祭，把一切圣物赐给你和你的子孙，作为你们永远当得的份。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","以色列人献给我的至圣之物素祭、赎罪祭和赎过祭中留下不烧的部分，都归你和你的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","你们男子都可以吃这些圣物，要在极其圣洁的地方吃。要把这些视为圣物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","以色列人献的举祭和摇祭也都归你，我已把它们赐给你和你的儿女，作为你们永远当得的份。你家中所有洁净的人都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","我把以色列人献给耶和华的初熟之物——最好的新油、新酒和五谷都赐给你。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","他们献给耶和华的一切初熟之物都归你，你家中洁净的人都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","以色列人永远献上的一切都要归你。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","奉献给耶和华的长子和头生的牲畜都归你，但要赎出长子和不洁净的头生牲畜。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","他们要在满月的时候被赎回，以圣所的秤为准，即一舍客勒是二十季拉，赎价是一两银子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","头生的牛、绵羊和山羊不用赎出来，它们都是圣物。你要把它们的血洒在祭坛上，把脂肪烧掉，作为献给耶和华的馨香火祭； ");
INSERT INTO cmncbs_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","它们的肉要归你，正如摇祭的胸肉和举祭的右腿肉一样。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","以色列人献给耶和华的圣物中，我把举祭赐给你和你的儿女，作为你们永远当得的份，这是我与你及你的后代所立的永世之约。” ");
INSERT INTO cmncbs_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","耶和华对亚伦说：“你在以色列人的土地上不可有产业，在他们的财物上不可有份，因为我是你在以色列人中的所得之份，是你的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“我要把以色列人出产的十分之一赐给利未人作产业，作为他们在会幕司职的酬劳。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","今后以色列人不可走近会幕，以免因犯罪而死。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","只有利未人可在会幕司职，他们要担负触犯圣幕的罪责，这是你们世代当守的永久律例。利未人在以色列人中不可有产业， ");
INSERT INTO cmncbs_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","因为我已经把以色列人献给耶和华的十分之一举祭赐给他们作产业。因此，我吩咐他们不可在以色列人中有产业。” ");
INSERT INTO cmncbs_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“你把以下条例告诉利未人。 “你们从以色列人手中得到我赐给你们作产业的十分之一后，要从中取出十分之一，作为举祭献给耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","这就算作你们献上了麦场的五谷和榨酒池的酒。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","这样，你们要从以色列人给你们的十分之一中，拿出一部分献给耶和华作举祭，将这举祭归给亚伦祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","你们要把所得之物中至圣至好的献给耶和华作举祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“你要告诉利未人，‘你们奉献了最好的以后，其余的算作你们麦场上的五谷和榨酒池的酒， ");
INSERT INTO cmncbs_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","你们和家人可以在任何地方吃，因为这些是你们在会幕司职的酬劳。 ");
INSERT INTO cmncbs_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","你们献上最好的以后，享用这些就不会获罪了。你们不可亵渎以色列人献上的圣物，免得死亡。’” ");
INSERT INTO cmncbs_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","耶和华对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“要吩咐以色列人遵行我颁布的以下律法条例。 “以色列人要牵来一头毫无残疾、从未负过轭的红母牛。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","你们要把牛交给以利亚撒祭司，然后牵到营外，当着他的面把牛宰了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","以利亚撒祭司要用指头蘸牛血，向会幕前面弹七次。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","然后，要当着他的面焚烧红母牛，牛的皮、肉、血和粪都要烧掉。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","祭司要把香柏木、牛膝草、朱红色线扔进烧牛的火里。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","之后，祭司要洗衣沐浴，才能回营，但要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","负责烧牛的人也要洗衣、沐浴，并且要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","要由一个洁净的人把红母牛灰收起来，放在营外洁净的地方，留给以色列会众作除秽水，作除罪之用。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","收起母牛灰的人也要洗净衣服，等到傍晚才能洁净。这是以色列人和在他们中间寄居的外族人永远当守的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“碰过尸体的人，七天不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","他要在第三天和第七天用除秽水自洁，才能洁净，否则就不能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","若有人碰过尸体却不自洁，他就玷污了耶和华的圣幕，要将他从以色列人中铲除，因为除秽水没有洒在他身上，他不洁净，污秽还留在他身上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","若有人死在帐篷里，就要遵守这样的条例：当时走进帐篷的或在场的人都七天不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","帐篷里没有盖的敞口器皿都不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","人若在野外碰过被杀或自然死亡之人的尸体，或碰过死人的骸骨或坟墓，就七天不洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","要为不洁净的人拿些除罪用的红母牛灰，放在器皿里，倒上清水， ");
INSERT INTO cmncbs_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","然后由一个洁净的人拿牛膝草蘸这水洒在帐篷及里面所有人和器具上，也要洒在碰过骸骨、坟墓、被杀者尸体，或自然死亡者尸体的人身上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","要由洁净的人在第三天和第七天把水洒在不洁净的人身上，并在第七天洁净他们。接受洁净礼的人要洗衣、沐浴，等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","若有人沾了污秽却没有用除秽水自洁，他就不洁净，要将他从会众中铲除，因为他玷污了耶和华的圣所。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","这是你们永远当守的律例。洒除秽水的人要洗净衣服。碰过除秽水的人要等到傍晚才能洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","不洁净的人碰过的东西都不洁净，碰过这些东西的人傍晚之前都不洁净。” ");
INSERT INTO cmncbs_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","一月，以色列全体会众抵达荀旷野，在加低斯安营。米利暗离世，葬在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","会众没有水喝，就聚集起来反对摩西和亚伦， ");
INSERT INTO cmncbs_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","他们跟摩西吵闹说：“还不如当初跟我们的弟兄一起死在耶和华面前！ ");
INSERT INTO cmncbs_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","你们为什么领耶和华的会众到这旷野来，要叫我们和牲畜都死在这里吗？ ");
INSERT INTO cmncbs_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","你们为什么带我们出埃及，到这不毛之地？这里没有五谷、无花果树、葡萄树和石榴树，甚至没有水喝。” ");
INSERT INTO cmncbs_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","摩西和亚伦离开会众到会幕门口，俯伏在地。耶和华的荣光向他们显现。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“你拿着杖和你哥哥亚伦招聚会众，当着他们的面吩咐磐石流出水来，水就会从磐石流出，供会众和牲畜喝。” ");
INSERT INTO cmncbs_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","摩西遵命而行，从耶和华面前取了杖， ");
INSERT INTO cmncbs_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","然后和亚伦把会众招聚到磐石前，说：“你们这些叛逆之徒听着，非要我们叫磐石给你们流出水来吗？” ");
INSERT INTO cmncbs_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","接着，摩西举起手中的杖击打磐石两下，水便喷涌而出，会众和牲畜都喝了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","耶和华对摩西和亚伦说：“你们对我没有足够的信心，没有当着以色列人的面尊我为圣，所以你们不得带领会众进入我所赐之地。” ");
INSERT INTO cmncbs_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","这地方叫米利巴泉，因为以色列人在那里与耶和华争闹，耶和华就向他们彰显了祂的圣洁。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","摩西从加低斯派使者去见以东王，说：“你的弟兄以色列人说，你知道我们遭遇的种种困难。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","我们祖先到埃及寄居多年，我们世代受埃及人虐待。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","但我们呼求耶和华，祂就垂听了我们的声音，差遣天使带我们出埃及。现在我们来到你边境的加低斯城， ");
INSERT INTO cmncbs_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","求你容我们借道贵国。我们不会踏入田地和葡萄园，也不会喝井里的水，只走王的大路，不会偏离左右，直到走出贵国。” ");
INSERT INTO cmncbs_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","以东王却说：“你们不可从我这里经过，否则我必兵戎相见。” ");
INSERT INTO cmncbs_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","以色列人说：“我们只走大路，倘若我们和牲畜喝了你的水，我们会付钱。我们别无他求，只求步行穿过贵国。” ");
INSERT INTO cmncbs_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","但以东王仍然不准，还率领大军严阵以待。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","由于以东王不让以色列人穿过他的领土，以色列人只好绕道。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","以色列全体会众从加低斯出发，来到何珥山。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","耶和华在位于以东边界的何珥山对摩西和亚伦说： ");
INSERT INTO cmncbs_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“亚伦要归到他祖先那里，他不能进入我赐给以色列人的土地，因为你们在米利巴泉违背了我的命令。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","你要带亚伦和他儿子以利亚撒上何珥山， ");
INSERT INTO cmncbs_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","把亚伦的圣衣脱下来给他儿子以利亚撒穿上，因为亚伦将归到他祖先那里，死在山上。” ");
INSERT INTO cmncbs_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","摩西遵命而行。他们三人就当着全体会众的面上了何珥山。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","摩西把亚伦的圣衣脱下，给他儿子以利亚撒穿上。随后亚伦在山顶离世。摩西和以利亚撒便下了山。 ");
INSERT INTO cmncbs_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","以色列全体会众得知亚伦离世，就为他哀悼了三十天。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","住在南地的迦南人亚拉得王听说以色列人取道亚他林而来，就攻打他们，俘虏了一些人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","以色列人向耶和华许愿说：“要是你将这些人交在我们手中，我们必彻底摧毁他们的城邑。” ");
INSERT INTO cmncbs_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","耶和华答应了他们的祈求，把迦南人交在他们手中，使他们彻底毁灭了迦南人及其城邑。从此，那地方叫何珥玛。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","以色列人为了绕过以东，便从何珥山出发，沿通往红海的路行进。途中，民众心里烦躁， ");
INSERT INTO cmncbs_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","埋怨上帝和摩西说：“你们为什么带我们出埃及，叫我们死在旷野呢？这里无粮无水，我们厌恶这难吃的东西！” ");
INSERT INTO cmncbs_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","于是，耶和华派毒蛇进入以色列人中，咬死了许多人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","他们来找摩西，说：“我们埋怨耶和华和你，犯了罪，求你向耶和华祷告，好叫蛇离开我们。”摩西就为他们祷告。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","耶和华对摩西说：“你去造一条毒蛇挂在杆子上，凡被咬的一望这蛇，就可活命。” ");
INSERT INTO cmncbs_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","摩西就造了一条铜蛇，挂在杆子上。被蛇咬的人一望铜蛇，就保住了性命。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","以色列人继续前行，在阿伯安营； ");
INSERT INTO cmncbs_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","又从阿伯动身，走到摩押东边的旷野，在以耶·亚巴琳安营； ");
INSERT INTO cmncbs_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","又从那里前行，走到撒烈谷安营； ");
INSERT INTO cmncbs_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","又从那里出发，走到亚嫩河北岸的旷野安营。那里毗邻亚摩利人的边境，亚嫩河是摩押和亚摩利人之间的疆界。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","因此，《耶和华的战记》上说：“苏法的哇哈伯，亚嫩河谷， ");
INSERT INTO cmncbs_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","以及靠近摩押边界并延伸到亚珥城的河谷的斜坡。” ");
INSERT INTO cmncbs_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","以色列人又往前走，来到比珥。耶和华曾在那里对摩西说：“把民众招聚起来，我要给他们水喝。” ");
INSERT INTO cmncbs_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","当时，以色列人唱了这首歌： “井啊，涌出水来！ 你们要歌唱这口井， ");
INSERT INTO cmncbs_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","它是首领挖的， 是民中的贵族掘的， 用令牌和权杖挖掘的。” 他们从旷野前往玛他拿， ");
INSERT INTO cmncbs_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","从玛他拿前往拿哈列，从拿哈列前往巴末， ");
INSERT INTO cmncbs_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","从巴末前往摩押的谷地，从那里的毗斯迦山顶可以俯视旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","以色列人派使者去见亚摩利王西宏，说： ");
INSERT INTO cmncbs_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“请允许我们从贵国经过，我们只走王的大路，不会踏入田地和葡萄园，也不会喝井里的水，直到走出贵国的土地。” ");
INSERT INTO cmncbs_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","但西宏不让以色列人经过他的领土，还招聚军队到旷野攻击他们。他们来到雅杂与以色列人交战。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","以色列人用刀杀了西宏，占领了他的土地——从亚嫩河到雅博河，远至防守严密的亚扪人边界。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","以色列人攻占了亚摩利人的所有城邑，包括希实本及其周围的村庄，住在其中。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","希实本是亚摩利王西宏的都城。西宏曾与摩押的先王交战，占领了他所有的领土，远至亚嫩河。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","因此有人作诗说： “来希实本吧！ 愿西宏的城被修建起来。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","希实本烈焰熊熊， 西宏的城火光冲天， 烧毁摩押的亚珥， 吞噬亚嫩河的高岗。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","摩押啊，你大祸临头了！ 拜基抹神明的人啊， 你们要灭亡了！ 基抹任由自己的儿子逃亡、 女儿被亚摩利王西宏掳走。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","但我们击溃了亚摩利人， 从希实本一直到底本都被摧毁， 从挪法到米底巴都沦为废墟。” ");
INSERT INTO cmncbs_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","于是，以色列人住在亚摩利境内。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","摩西派人去雅谢打探，然后出兵攻占了雅谢及其周围的村庄，赶走那里的亚摩利人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","以色列人回师前往巴珊，巴珊王噩率全军出动，在以得来迎战以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","耶和华对摩西说：“不要怕他，因为我已把他及其众民和土地交在你手中。你要像从前对付希实本的亚摩利王西宏一样对付他。” ");
INSERT INTO cmncbs_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","于是，以色列人杀了噩及其儿子和人民，一个不留，并夺取了他的国土。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","以色列人继续前行，抵达约旦河东岸的摩押平原，在耶利哥对面安营。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","西拨的儿子摩押王巴勒得知以色列人对亚摩利人的所作所为， ");
INSERT INTO cmncbs_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","又见他们人多势众，就惊恐万状。摩押人被以色列人吓坏了， ");
INSERT INTO cmncbs_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","就对米甸的长老说：“这群人将吞掉我们周围的一切，如同牛吃光田间的草一样。”那时，西拨的儿子巴勒做摩押王。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","他差遣使者去幼发拉底河附近，到比珥的儿子巴兰的家乡毗夺，去召巴兰，说：“有一个民族从埃及铺天盖地而来，就住在我对面。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","他们比我强大，求你为我咒诅他们。这样，我也许就能击败他们，把他们赶走。我知道你祝福谁，谁就蒙福；你咒诅谁，谁就遭祸。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","摩押和米甸的长老们带着占卜的礼金去见巴兰，把巴勒的话转告他。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","巴兰说：“你们今夜住在这里，我必照耶和华的旨意回复你们。”摩押的官长就在巴兰那里住下。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","晚上，上帝来问巴兰：“住在你这里的是谁？” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","巴兰回答说：“他们是摩押王西拨的儿子巴勒派来的， ");
INSERT INTO cmncbs_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","说，‘有一个民族从埃及铺天盖地而来。请你来咒诅那民族，这样我或许能击败他们，把他们赶走。’” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","上帝对巴兰说：“你不可跟他们去，也不可咒诅那民族，因为那民族是蒙福的。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","巴兰清早起来，对巴勒的官长说：“你们回去吧，耶和华不准我跟你们去。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","摩押的官长回去对巴勒说：“巴兰不肯跟我们来。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","巴勒又派去更多、更尊贵的官长。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","他们到了巴兰那里，对他说：“西拨的儿子巴勒请你务必去一趟， ");
INSERT INTO cmncbs_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","他必有重赏。你要什么都可以，只求你去为他咒诅那民族。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","巴兰回答说：“巴勒就是把他满屋的金银都给我，我也不能在任何事上违背我的上帝耶和华的命令。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","请你们在这里过夜，我好看看耶和华对我还有什么吩咐。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","当夜，上帝来对巴兰说：“这些人既然来请你，你就跟他们去吧，但你只可照我说的做。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","巴兰清早起来，备好驴，跟摩押的官长去了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","巴兰这一去，激怒了上帝。巴兰骑着驴，带着两个仆人正走在途中，耶和华的天使拦住他的去路。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","驴看见耶和华的天使拔刀拦在路上，就离开大路，跑进田间。巴兰打驴，要它回到路上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","耶和华的天使又站在葡萄园之间的一条窄路上，两边都是墙。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","驴看见耶和华的天使，就靠着墙边走，将巴兰的脚挤在墙上了。巴兰又打它。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","耶和华的天使又走到前面，站在狭窄之处，两边都无侧身通过的余地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","巴兰身下的驴看见耶和华的天使，就卧在地上，巴兰大怒，便用杖打它。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","耶和华使驴开口对巴兰说：“我做错了什么，你竟打我三次？” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","巴兰说：“因为你戏弄我。如果我手中有刀，早就把你宰了！” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","驴对巴兰说：“我不是你从小就骑的驴吗？我可曾这样对你？”巴兰说：“没有。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","那时，耶和华开了巴兰的眼，他才看见耶和华的天使拔刀拦在路上，便俯身下拜。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","耶和华的天使对他说：“你为何三次打你的驴？我来阻挡你，因为你走的路在我眼中是邪路。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","你的驴看见我，一连躲避了三次，驴若没有躲开，我早已杀了你，只放过驴。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","巴兰对耶和华的天使说：“我有罪了，我不知道是你拦在路上。现在你如果反对我去，我就回去。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","耶和华的天使说：“跟这些人去吧，但你只许按我的指示说话。”于是，巴兰跟巴勒的官长去了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","巴勒听见巴兰来了，就来到边界尽头、亚嫩河边的摩押城迎接他。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","巴勒对巴兰说：“上次派人请你，你为何不肯来？难道我不能给你重赏吗？” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","巴兰对巴勒说：“现在我已经来了，但我不能随便发言，我只能按上帝的指示说话。” ");
INSERT INTO cmncbs_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","巴兰和巴勒一同来到基列·胡琐。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","巴勒宰牛杀羊赏给巴兰和随行的官长。 ");
INSERT INTO cmncbs_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","次日清晨，巴勒领巴兰上到巴末·巴力，从那里可以看到一部分以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","巴兰对巴勒说：“你在这里为我筑七座祭坛，预备七头公牛和七只公绵羊。” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","巴勒就照巴兰的话做了。他们二人在每座坛上献上一头公牛和一只公绵羊， ");
INSERT INTO cmncbs_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","巴兰对巴勒说：“你留在燔祭旁边，我到前面去，也许耶和华会向我显现。无论祂有什么指示，我必告诉你。”巴兰就上到一处光秃秃的高地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","上帝向巴兰显现。巴兰对上帝说：“我已经预备了七座祭坛，每座祭坛上献了一头公牛和一只公绵羊。” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","耶和华告诉他当说的话，命他回去转告巴勒。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","巴兰就回到巴勒那里，看见他和摩押的官长都站在燔祭旁边。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","巴兰吟诗预言说： “巴勒领我出亚兰， 摩押王请我出东山， 说，‘来为我咒诅雅各， 来斥责以色列！’ ");
INSERT INTO cmncbs_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","上帝没有咒诅的， 我怎能咒诅？ 耶和华没有斥责的， 我怎能斥责？ ");
INSERT INTO cmncbs_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","我从峰顶观看他们， 从高岗眺望他们， 这独居一方之民， 不与万国同列。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","雅各的子孙多如尘土， 谁能数得清？ 谁能数清以色列人的四分之一？ 我愿像义人一样死去， 如义人般终此一生。” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","巴勒对巴兰说：“你这是做什么？我请你来咒诅我的仇敌，你竟祝福他们！” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","巴兰说：“耶和华让我说的话，我岂能不说？” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","巴勒说：“请你跟我去另一个地方，那里看不见全部以色列人，只能看见一部分，你要在那里为我咒诅他们。” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","他领巴兰上到毗斯迦山顶的琐腓田，在那里筑了七座祭坛，每座坛上都献了一头公牛和一只公绵羊。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","巴兰对巴勒说：“你留在这些燔祭旁边，我到那边去见耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","耶和华向巴兰显现，告诉他当说的话，让他转告巴勒。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","巴兰回到巴勒那里，看见他和摩押的官长都站在燔祭旁边。巴勒问道：“耶和华说了什么？” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","巴兰吟诗预言说： “巴勒啊，要留心听！ 西拨的儿子啊，请听我言。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","上帝并非世人，祂不撒谎； 上帝不是凡人，祂不反悔。 祂言出必行，信守承诺。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","我奉命祝福，祂已赐福， 我不能改变。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","雅各的子孙中未见有罪恶， 以色列人中看不见有祸患。 他们的上帝耶和华与他们同在， 他们向自己的君王欢呼。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","上帝带他们出埃及， 祂的力量如野牛之角。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","没有邪术能害雅各， 没有咒语可伤以色列。 时候一到，人们必谈论雅各， 谈论以色列，说，‘看啊， 上帝的作为何等伟大！’ ");
INSERT INTO cmncbs_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","看啊，这民族挺身如母狮， 跃起像雄狮， 不吞食猎物、 不喝猎物的血不躺卧。” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","巴勒对巴兰说：“你可以不咒诅他们，但也不该为他们祝福啊！” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","巴兰回答说：“我不是说过，我必须按耶和华的指示做吗？” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","巴勒说：“来吧，我带你去另一个地方，也许上帝会同意你在那里为我咒诅他们。” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","他领着巴兰登上俯瞰旷野的毗珥山顶。 ");
INSERT INTO cmncbs_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","巴兰对巴勒说：“你在这里为我筑七座祭坛，预备七头公牛和七只公绵羊。” ");
INSERT INTO cmncbs_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","巴勒就照巴兰的话，在每座祭坛上献了一头公牛和一只公绵羊。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","巴兰见耶和华乐意赐福给以色列人，就不再像先前两次那样去求兆头，而是转向旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","他举目眺望，看见以色列人按支派扎营。上帝的灵降在他身上， ");
INSERT INTO cmncbs_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","他便吟诗预言说： “比珥之子巴兰的预言， 是眼睛明亮者的话， ");
INSERT INTO cmncbs_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","他得听上帝之言， 俯伏在地，眼目睁开 得见全能者的异象。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","雅各啊， 你的帐篷何等华美！ 以色列啊， 你的居所何等佳美！ ");
INSERT INTO cmncbs_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","像连绵的山谷， 如河畔的园子； 像耶和华栽种的沉香， 如水边的香柏树。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","他们沐浴充沛的甘霖， 撒种于湿润的沃土。 他们的君王高过亚甲， 国度名震四方。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","上帝带他们出埃及， 祂的力量如野牛之角。 他们要吞灭敌国， 打碎敌人的骨头， 用利箭射穿仇敌。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","他们蹲伏如雄狮， 躺卧如母狮，谁敢招惹？ 愿祝福他们的人蒙祝福！ 愿咒诅他们的人受咒诅！” ");
INSERT INTO cmncbs_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","巴勒听了大怒，用力击掌，对巴兰说：“我请你来咒诅我的仇敌，你竟三次祝福他们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","现在快回家去吧！我说过要给你重赏，但耶和华不让你得到。” ");
INSERT INTO cmncbs_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","巴兰说：“我不是对你派来的使臣说过吗？ ");
INSERT INTO cmncbs_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","就是你把满屋的金银都给我，我也不能违背耶和华的命令、凭自己的意思行事——无论好事坏事。我只能说耶和华让我说的话。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","现在我要回本族去了。但我要告诉你日后以色列人会怎样对待你的人民。” ");
INSERT INTO cmncbs_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","巴兰吟诗预言说： “比珥之子巴兰的预言， 是眼睛明亮者的话， ");
INSERT INTO cmncbs_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","他得听上帝之言， 明白至高者的旨意， 俯伏在地，眼目睁开， 得见全能者的异象。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","我所见的尚未发生， 我目睹的关乎将来。 一颗星要从雅各家升起， 一位君王要从以色列兴起。 他要打烂摩押的前额， 击碎塞特人的头颅。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","他必征服以东， 占领敌疆西珥， 以色列必勇往直前。 ");
INSERT INTO cmncbs_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","雅各的后裔必掌权， 消灭城中的余民。” ");
INSERT INTO cmncbs_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","巴兰观看亚玛力人，并以诗歌预言说： “亚玛力原是列国之首， 但他的结局却是灭亡。” ");
INSERT INTO cmncbs_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","巴兰又观看基尼人，并以诗歌预言说： “虽然你的居所坚固， 你的巢筑在峭壁， ");
INSERT INTO cmncbs_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","但你必遭灭顶， 被亚述掳去。” ");
INSERT INTO cmncbs_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","巴兰又以诗歌预言说： “唉！若上帝做这事， 谁能存活呢？ ");
INSERT INTO cmncbs_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","船只从基提驶来， 征服亚述和希伯， 但他也要灭亡。” ");
INSERT INTO cmncbs_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","说完，巴兰动身返回家乡，巴勒也回去了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","以色列人驻扎在什亭期间，有些人与摩押女子行淫。 ");
INSERT INTO cmncbs_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","那些女子邀这些人祭祀她们的神明，他们吃了祭物，并跪拜她们的神明。 ");
INSERT INTO cmncbs_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","结果以色列与巴力·毗珥苟合。耶和华大怒， ");
INSERT INTO cmncbs_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","对摩西说：“把为首的人都抓起来，当着我的面在大白天处死他们，以消除我对以色列人的怒气。” ");
INSERT INTO cmncbs_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","于是，摩西对以色列的审判官说：“你们各自把手下与巴力·毗珥苟合的人处死。” ");
INSERT INTO cmncbs_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","摩西和以色列全体会众正在会幕门口痛哭的时候，有个以色列人当着他们的面，把一个米甸女子带进自家的帐篷。 ");
INSERT INTO cmncbs_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","亚伦祭司的孙子、以利亚撒的儿子非尼哈看见了，便起身离开会众，拿着矛枪， ");
INSERT INTO cmncbs_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","跟着进入那人的帐篷，用枪刺透那对男女的腹部。以色列人当中的瘟疫马上止住了， ");
INSERT INTO cmncbs_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","但已有两万四千人死于瘟疫。 ");
INSERT INTO cmncbs_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“亚伦祭司的孙子、以利亚撒的儿子非尼哈，消了我对以色列人的怒气。因为在会众中他与我一样痛恨不贞，我才没有愤然消灭他们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","你告诉他，我要赐给他平安的约， ");
INSERT INTO cmncbs_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","使他和他的后代凭此约可以永远做祭司，因为他为我除掉了不贞之人，为以色列人赎了罪。” ");
INSERT INTO cmncbs_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","与米甸女子一同被杀的以色列人名叫心利，是撒路的儿子，是西缅支派的一个族长。 ");
INSERT INTO cmncbs_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","被杀的米甸女子名叫哥斯比，她父亲苏珥是米甸人的一个族长。 ");
INSERT INTO cmncbs_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“你要攻打米甸人，击杀他们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","因为他们心存恶意，在毗珥陷害你们，他们的姊妹——米甸首领的女儿哥斯比诱惑你们，她在毗珥事件招来瘟疫之日被杀。” ");
INSERT INTO cmncbs_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","瘟疫过后，耶和华对摩西和亚伦祭司的儿子以利亚撒说： ");
INSERT INTO cmncbs_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“你们要统计以色列全体会众的人数，按家系登记所有二十岁以上、有作战能力的男子。” ");
INSERT INTO cmncbs_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","摩西和以利亚撒祭司就在约旦河边、耶利哥对面的摩押平原对以色列人说： ");
INSERT INTO cmncbs_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“你们要按照耶和华对摩西的吩咐，统计二十岁以上的男子。” 以下是从埃及出来的以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","以色列的长子是吕便，吕便的子孙有哈诺族、法路族、 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","希斯伦族和迦米族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","这些是吕便的各宗族，共登记了四万三千七百三十人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","法路的儿子是以利押， ");
INSERT INTO cmncbs_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","以利押的儿子是尼姆利、大坍和亚比兰。大坍、亚比兰原是会众所推选的首领，他们与可拉一伙，一起反叛摩西和亚伦，反叛耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","以致大地裂开，将他们全部吞了下去，当时大火还烧灭了二百五十人。他们成了后人的警戒。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","然而，可拉的子孙没有被灭绝。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","按着宗族，西缅的子孙有尼姆利族、雅悯族、雅斤族、 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","谢拉族和扫罗族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","这些是西缅的各宗族，共登记了两万二千二百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","按着宗族，迦得的子孙有洗分族、哈基族、书尼族、 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","阿斯尼族、以利族、 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","亚律族和亚列利族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","这些是迦得的各宗族，共登记了四万零五百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","珥和俄南是犹大的儿子，他们死在了迦南。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","按着宗族，犹大的子孙有示拉族、法勒斯族、谢拉族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","法勒斯的子孙有希斯仑族和哈姆勒族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","这些是犹大的各宗族，共登记了七万六千五百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","按着宗族，以萨迦的子孙有陀拉族、普瓦族、 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","雅述族和伸仑族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","这些是以萨迦各宗族，共登记了六万四千三百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","按着宗族，西布伦的子孙有西烈族、以伦族和雅利族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","这些是西布伦的各宗族，共登记了六万零五百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","按着宗族，约瑟的儿子有玛拿西和以法莲。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","玛拿西的子孙有玛吉族和基列族。基列是玛吉的儿子。基列族来自基列。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","基列的子孙有伊以谢族、希勒族、 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","亚斯烈族、示剑族、 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","示米大族和希弗族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","希弗的儿子西罗非哈没有儿子，只有女儿玛拉、挪阿、曷拉、密迦和得撒。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","这些是玛拿西的各宗族，共登记了五万二千七百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","按着宗族，以法莲的子孙有书提拉族、比结族和他罕族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","书提拉的子孙有以兰族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","这些是以法莲各宗族，共登记了三万二千五百人，他们按宗族都是约瑟的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","按着宗族，便雅悯的子孙有比拉族、亚实别族、亚希兰族、 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","书反族和户反族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","比拉的子孙有亚勒族和乃幔族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","这些是便雅悯的各宗族，共登记了四万五千六百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","按着宗族，但的子孙有书含族，书含族来自书含，这些是但的宗族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","书含族共登记了六万四千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","按着宗族，亚设的子孙有音拿族、亦施韦族和比利亚族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","比利亚的子孙有希别族和玛结族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","亚设的女儿名叫西拉。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","这些是亚设的各宗族，共登记了五万三千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","按着宗族，拿弗他利的子孙有雅薛族、沽尼族、 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","耶色族和示冷族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","这些是拿弗他利的各宗族，共登记了四万五千四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","登记的以色列男子共有六十万一千七百三十人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“你要按着各支派登记的人数，把土地分给他们作产业； ");
INSERT INTO cmncbs_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","人数多的多分产业，人数少的少分产业，要按登记的人数分配。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","以色列人要按各自的支派抽签分地，承受产业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","无论大小支派，都要用抽签的方法分配产业。” ");
INSERT INTO cmncbs_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","按着宗族，利未的子孙有革顺族、哥辖族和米拉利族。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","立尼族、希伯伦族、玛利族、姆示族和可拉族也是利未的子孙。哥辖生暗兰。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","暗兰的妻子叫约基别，是利未女子，出生在埃及。她给暗兰生了亚伦、摩西和他们的姐姐米利暗。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","亚伦生拿答、亚比户、以利亚撒和以他玛。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","拿答和亚比户在用凡火向耶和华献祭时死去了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","利未人中一个月以上的男性共登记了两万三千人，他们的人数没有登记在以色列人中，因为他们在以色列人中不分产业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","以上是摩西和以利亚撒祭司在约旦河边、耶利哥对面的摩押平原统计的以色列人数， ");
INSERT INTO cmncbs_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","其中没有一个是摩西和祭司亚伦从前在西奈旷野登记的以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","因为耶和华说过，那批人都要死在旷野。所以，除了耶孚尼的儿子迦勒和嫩的儿子约书亚以外，上次登记的人无一存活。 ");
INSERT INTO cmncbs_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","西罗非哈是约瑟之子玛拿西的玄孙、玛吉的曾孙、基列的孙子、希弗的儿子。他的女儿是玛拉、挪阿、曷拉、密迦和得撒。她们前来， ");
INSERT INTO cmncbs_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","站在会幕门口对摩西、以利亚撒祭司、众首领和全体会众说： ");
INSERT INTO cmncbs_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“我们的父亲死在旷野，他并没有跟可拉一伙一起反叛耶和华，而是因自己的罪而死，没有留下儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","难道因为他没有儿子，他的名字就要从族中消失吗？请让我们在父亲的家族中分一份产业吧。” ");
INSERT INTO cmncbs_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","摩西就把她们的请求呈到耶和华面前。 ");
INSERT INTO cmncbs_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“西罗非哈的女儿说得有理。你要从她们父亲的家族中分一份产业给她们，让她们继承父亲的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","你要告诉以色列人，‘人死后如果没有儿子，就由女儿继承产业； ");
INSERT INTO cmncbs_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","如果没有女儿，就由其兄弟继承； ");
INSERT INTO cmncbs_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","如果没有兄弟，就由其父的兄弟继承； ");
INSERT INTO cmncbs_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","如果其父没有兄弟，就由其族中最近的亲属继承。’”这是耶和华吩咐摩西颁布给以色列人的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","耶和华对摩西说：“你上这亚巴琳山去看看我赐给以色列人的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","看了以后，你就要像你哥哥亚伦一样归到祖先那里了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","因为会众在荀旷野反叛我的时候，你们二人违背我的命令，在取水的事上没有在他们面前尊我为圣。”这是指米利巴泉事件，发生在荀旷野的加低斯。 ");
INSERT INTO cmncbs_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","摩西对耶和华说： ");
INSERT INTO cmncbs_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“耶和华啊，你是赐人生命的上帝，求你立一个人做会众的首领， ");
INSERT INTO cmncbs_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","在前面带领他们或进或退，免得你的会众像没有牧人的羊群。” ");
INSERT INTO cmncbs_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","耶和华对摩西说：“嫩的儿子约书亚心里有圣灵，你把他召来，把手按在他身上， ");
INSERT INTO cmncbs_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","让他站在以利亚撒祭司和全体会众面前，当着他们的面任命他做首领， ");
INSERT INTO cmncbs_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","把你的权柄赐给他，使以色列全体会众都听从他。 ");
INSERT INTO cmncbs_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","他要去以利亚撒祭司那里，让祭司借着乌陵为他求问我。他和全体会众或进或出，都要听从以利亚撒的指示。” ");
INSERT INTO cmncbs_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","摩西遵命而行，把约书亚召来，让他站在以利亚撒祭司和全体会众面前， ");
INSERT INTO cmncbs_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","然后照耶和华对摩西的吩咐把手按在他头上，任命他做首领。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“你要吩咐以色列人，在规定的时间献上蒙我悦纳的馨香火祭，作为我的食物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","以下是他们要献给耶和华的火祭：每天两只毫无残疾、一岁的公羊羔作日常燔祭， ");
INSERT INTO cmncbs_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","早晨和黄昏各献一只， ");
INSERT INTO cmncbs_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","同时献上一公斤细面粉，并调上一升橄榄油作素祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","这是在西奈山上规定的日常燔祭，是献给耶和华的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","与每只羊羔一同献上的还有一升酒，要将酒洒在圣所，作为献给耶和华的奠祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","黄昏献第二只羊羔时，也要跟早晨一样同时献上素祭和奠祭，作为蒙耶和华悦纳的馨香火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“安息日，要献两只毫无残疾、一岁的公羊羔，同时献上奠祭以及两公斤调油的细面粉作素祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","这是在日常燔祭和奠祭以外安息日所献的燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“在朔日，要给耶和华献燔祭——两头公牛犊、一只公绵羊和七只一岁公羊羔，都要毫无残疾。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","同时要献上调了油的细面粉作素祭，每头公牛需献三公斤素祭，每只公绵羊需献两公斤素祭， ");
INSERT INTO cmncbs_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","每只公羊羔需献一公斤素祭。这馨香的燔祭是献给耶和华的火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","献燔祭时要同时献上奠祭，每头公牛需献二升奠酒，每只公绵羊需献一升半奠酒，每只羊羔需献一升奠酒。这是朔日要献的燔祭，一年之中月月如此。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","除了日常的燔祭和奠祭以外，还要把一只公山羊献给耶和华作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“一月十四日是耶和华的逾越节， ");
INSERT INTO cmncbs_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","十五日开始节庆，你们要连续七天吃无酵饼。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","第一天要举行圣会，不可做日常工作。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","你们要把毫无残疾的两头公牛犊、一只公绵羊和七只一岁的公羊羔，献给耶和华作燔祭； ");
INSERT INTO cmncbs_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","同时要献上调了油的细面粉作素祭，每头公牛需献三公斤素祭，每只公绵羊需献两公斤素祭， ");
INSERT INTO cmncbs_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","每只公羊羔需献一公斤素祭； ");
INSERT INTO cmncbs_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","同时还要献一只公山羊作赎罪祭，为你们赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","除了早晨献的日常燔祭以外，要献上这些祭物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","接连七天，除了日常的燔祭和同献的奠祭以外，还要照上面的规定给耶和华献上馨香的火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","第七天，你们要举行圣会，不可做日常工作。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“七七收获节庄稼初熟之日，就是你们把新素祭献给耶和华的日子，要召开圣会，不可做日常工作。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","你们要把两头公牛犊、一只公绵羊和七只一岁的公羊羔，献给耶和华作馨香的燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","同时要献上调了油的细面粉作素祭，每头公牛需献三公斤素祭，每只公绵羊需献两公斤素祭， ");
INSERT INTO cmncbs_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","每只公羊羔需献一公斤素祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","此外，还要献上一只公山羊作赎罪祭，为你们赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","除了日常的燔祭和同献的素祭以外，还要献上奠祭。祭牲不可有残疾。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“七月一日，你们要举行圣会，吹响号角，不可做日常工作。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","你们要把馨香的燔祭献给耶和华，即毫无残疾的公牛犊一头、公绵羊一只和一岁的公羊羔七只； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","同时要献上调了油的细面粉作素祭，每头公牛犊需献三公斤素祭，每只公绵羊需献两公斤素祭， ");
INSERT INTO cmncbs_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","每只公羊羔需献一公斤素祭； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","还要献上一只公山羊作赎罪祭，为你们赎罪。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","此外，要照常献上朔日和日常应献的燔祭、素祭和奠祭，给耶和华作馨香的火祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“七月十日，你们要举行圣会，禁食，不可工作。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","你们要给耶和华献上馨香的燔祭，即毫无残疾的公牛犊一头、公绵羊一只和一岁的公羊羔七只； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","同时要献上调了油的细面粉作素祭，每头公牛犊需献三公斤素祭，每只公绵羊需献两公斤素祭， ");
INSERT INTO cmncbs_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","每只公羊羔需献一公斤素祭； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","还要献上一只公山羊作赎罪祭。此外，要照常献上赎罪祭和日常献的燔祭、素祭和奠祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“在七月十五日那一天，你们要举行圣会，不可做日常工作，为耶和华守节期七天。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","你们要给耶和华献上馨香的燔祭作火祭，即毫无残疾的公牛犊十三头、公绵羊两只和一岁的公羊羔十四只； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","同时要献上调了油的细面粉作素祭，每头公牛犊需献三公斤素祭，每只公绵羊需献两公斤素祭， ");
INSERT INTO cmncbs_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","每只公羊羔需献一公斤素祭； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","除了日常献的燔祭、素祭和奠祭以外，还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“节期的第二天，你们要献上毫无残疾的公牛犊十二头、公绵羊两只和一岁的公羊羔十四只； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","同时要按规定的量把素祭和奠祭与公牛、公绵羊和公羊羔一起献上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","除了日常献的燔祭、素祭和奠祭以外，还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“节期的第三天，你们要献上毫无残疾的公牛十一头、公绵羊两只和一岁的公羊羔十四只； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","同时要按规定的量把素祭和奠祭与公牛、公绵羊和公羊羔一起献上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","除了日常献的燔祭、素祭和奠祭以外，还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“节期的第四天，你们要献上毫无残疾的公牛十头、公绵羊两只和一岁的公羊羔十四只； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","同时要按规定的量把素祭和奠祭与公牛、公绵羊和公羊羔一起献上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","除了日常献的燔祭、素祭和奠祭以外，还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“节期的第五天，你们要献上毫无残疾的公牛九头、公绵羊两只和一岁的公羊羔十四只； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","同时要按规定的量把素祭和奠祭与公牛、公绵羊和公羊羔一起献上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","除了日常献的燔祭、素祭和奠祭以外，还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“节期的第六天，你们要献上毫无残疾的公牛八头、公绵羊两只和一岁的公羊羔十四只； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","同时要按规定的量把素祭和奠祭与公牛、公绵羊和公羊羔一起献上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","除了日常献的燔祭、素祭和奠祭以外，还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“节期的第七天，你们要献上毫无残疾的公牛七头、公绵羊两只和一岁的公羊羔十四只； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","同时要按规定的量把素祭和奠祭与公牛、公绵羊和公羊羔一起献上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","除了日常献的燔祭、素祭和奠祭以外，还要献上一只公山羊作为赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“节期的第八天，你们不可做日常工作，要举行庄严的聚会。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","你们要给耶和华献上馨香的燔祭作火祭，即毫无残疾的公牛一头、公绵羊一只和一岁的公羊羔七只； ");
INSERT INTO cmncbs_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","同时要按规定的量把素祭和奠祭与公牛、公绵羊和公羊羔一起献上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","除了日常献的燔祭、素祭和奠祭以外，还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“这些是你们在节期内要献给耶和华的祭物，此外还有你们许愿和自愿献的燔祭、素祭、奠祭和平安祭。” ");
INSERT INTO cmncbs_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","摩西把耶和华的一切吩咐传达给以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","摩西对以色列各支派的首领说：“以下是耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“人若在什么事上向耶和华许愿或起誓，就不可食言，必须履行诺言。 ");
INSERT INTO cmncbs_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","倘若未出嫁的少女在什么事上向耶和华许愿或起誓， ");
INSERT INTO cmncbs_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","她父亲得知她许的愿或起的誓后没有反对，她许的愿和起的誓就都有效； ");
INSERT INTO cmncbs_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","倘若她父亲得知后加以反对，她许的愿和起的誓就无效。耶和华必不追究她，因为她父亲反对。 ");
INSERT INTO cmncbs_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“倘若有女子出嫁前许了愿或信口起了誓， ");
INSERT INTO cmncbs_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","她丈夫得知后没有反对，她许的愿和起的誓就都有效； ");
INSERT INTO cmncbs_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","倘若她丈夫得知后加以反对，她许的愿和起的誓就无效，耶和华必不追究她。 ");
INSERT INTO cmncbs_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","寡妇或被休的妇人若在什么事上许愿或起誓，就必须履行誓言。 ");
INSERT INTO cmncbs_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“倘若已婚妇女在夫家许愿或起誓， ");
INSERT INTO cmncbs_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","她丈夫得知后没有反对，她许的愿和起的誓就都有效； ");
INSERT INTO cmncbs_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","倘若她丈夫在得知当天加以否定，她口中许的愿和起的誓就无效。她丈夫已经使之无效，耶和华必不追究她。 ");
INSERT INTO cmncbs_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","丈夫有权赞同或否定妻子禁食所许的愿或起的誓。 ");
INSERT INTO cmncbs_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","倘若丈夫得知妻子许愿或起誓当天一直没有反对，她就必须履行誓言，因为丈夫当天默认了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","倘若丈夫当天默认了，后来又加以反对，他就要承担妻子的罪责。” ");
INSERT INTO cmncbs_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","以上是耶和华借摩西颁布的有关丈夫和妻子、父亲和未出嫁的女儿要遵守的条例。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“你要为以色列人向米甸人报仇，之后你将归到祖先那里。” ");
INSERT INTO cmncbs_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","于是，摩西对民众说：“你们的人要拿起兵器去攻打米甸，为耶和华报仇。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","以色列的每个支派要派一千人出战。” ");
INSERT INTO cmncbs_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","于是，他们从以色列每个支派选出一千人，武装了一万二千军兵。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","每个支派选出的一千军兵由摩西派遣出战，以利亚撒祭司的儿子非尼哈拿着圣所的器具和号角随行。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","他们照耶和华对摩西的吩咐，去攻打米甸人，杀死了米甸的所有男子， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","包括以未、利金、苏珥、户珥和利巴五个米甸的王，还杀了比珥的儿子巴兰。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","以色列人掳获了米甸的妇女、孩子、所有牛羊和财物， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","将他们的城邑营寨付之一炬， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","带走了掳掠的人畜等战利品。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","他们来到耶利哥对面、约旦河边的摩押平原，把战利品交给摩西、以利亚撒祭司和以色列全体会众。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","摩西、以利亚撒祭司以及所有民众的首领都到营外迎接他们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","摩西对出征回来的千夫长和百夫长等将领发怒， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","说：“你们为什么让这些妇女活着？ ");
INSERT INTO cmncbs_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","就是她们听了巴兰的指使，在毗珥引诱以色列人背叛耶和华，以致瘟疫降在耶和华的会众身上。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","现在，你们要杀掉所有的男孩，以及与男人发生过关系的女子， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","但可以留下那些处女。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","你们凡杀了人和碰过死人的都要在营外待七天。在第三天和第七天，你们要洁净自己及掳来的人， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","也要洁净自己所有的衣服、皮具、山羊毛制品和木器。” ");
INSERT INTO cmncbs_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","以利亚撒祭司对打仗回来的军兵说：“以下是耶和华借摩西颁布的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","金、银、铜、铁、锡、铅， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","凡耐火之物都要用火来洁净，还要用除秽水加以洁净；不耐火之物要用水来洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","第七天，你们洗完衣服后就洁净了，可以回营。” ");
INSERT INTO cmncbs_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“你和以利亚撒祭司以及会众的各族长，要统计俘虏和牲畜的数目， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","然后把这些战利品分成两份，一份给出征的战士，一份给其余会众。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","要从战士分得的俘虏、牛、驴和羊群中抽出五百分之一，献给耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","要把那五百分之一交给以利亚撒祭司，献给耶和华作举祭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","要从以色列人分得的俘虏和牛、驴、羊等牲畜中抽出五十分之一，交给在我圣幕司职的利未人。” ");
INSERT INTO cmncbs_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","摩西和以利亚撒祭司遵命而行。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","战士掳获的战利品中有六十七万五千只羊， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","七万二千头牛， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","六万一千头驴， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","三万二千名处女。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","战士分得的战利品有三十三万七千五百只羊， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","其中六百七十五只献给耶和华； ");
INSERT INTO cmncbs_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","三万六千头牛，其中七十二头献给耶和华； ");
INSERT INTO cmncbs_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","三万零五百头驴，其中六十一头献给耶和华； ");
INSERT INTO cmncbs_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","一万六千名处女，其中三十二人献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","摩西照耶和华的吩咐，把献给耶和华的举祭交给以利亚撒祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","以色列会众分得的那一半战利品，即摩西从出征之人的战利品中分出来给他们的， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","有三十三万七千五百只羊、 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","三万六千头牛、 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","三万零五百头驴、 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","一万六千名处女。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","摩西照耶和华的吩咐，从中抽出五十分之一，交给在圣幕里司职的利未人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","统领军队的千夫长和百夫长来见摩西， ");
INSERT INTO cmncbs_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","说：“仆人们统计了手下出征的战士，未失一兵一卒。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","现在我们把各自掳获的臂环、镯子、图章戒指、耳环、项链等金器都带来献给耶和华，在祂面前为我们赎罪。” ");
INSERT INTO cmncbs_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","摩西和以利亚撒祭司收了他们所献的各种金制品。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","千夫长和百夫长献给耶和华作举祭的金子共三千八百两。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","战士则保留了自己掳获的财物。 ");
INSERT INTO cmncbs_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","摩西和以利亚撒祭司就把千夫长和百夫长献的金子带进会幕，在耶和华面前作以色列人的纪念。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","吕便和迦得的子孙有许多牲畜，他们见雅谢和基列适于放牧， ");
INSERT INTO cmncbs_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","就来见摩西、以利亚撒祭司和会众的首领，说： ");
INSERT INTO cmncbs_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“亚他录、底本、雅谢、宁拉、希实本、以利亚利、示班、尼波和比稳—— ");
INSERT INTO cmncbs_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","这些耶和华为以色列会众攻取的地方适于放牧，而仆人们有许多牲畜。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","如果你们恩待我们，请将这些地方赐给我们作产业，别让我们过约旦河了。” ");
INSERT INTO cmncbs_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","摩西对他们说：“难道你们的同胞去打仗，你们却坐在这里吗？ ");
INSERT INTO cmncbs_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","你们为何使以色列人军心动摇，不敢进入耶和华所赐之地？ ");
INSERT INTO cmncbs_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","从前我在加低斯·巴尼亚派你们的祖先去打探那地方的时候，他们就是这样。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","他们到以实各谷打探那地方，回来后竟动摇军心，使以色列人不敢进入耶和华所赐之地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","那天耶和华发怒，起誓说， ");
INSERT INTO cmncbs_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘从埃及出来、二十岁以上的人都看不到我起誓要赐给亚伯拉罕、以撒和雅各的土地，因为他们没有一心追随我； ");
INSERT INTO cmncbs_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","只有基尼洗族耶孚尼的儿子迦勒和嫩的儿子约书亚可以看到，因为他们一心追随我。’ ");
INSERT INTO cmncbs_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","耶和华向以色列人发怒，使他们在旷野漂泊了四十年，直到在耶和华面前作恶的那一代都死了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“现在，你们这群罪人的后代竟然重蹈前人的覆辙，加剧耶和华向以色列所发的怒气。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","如果你们离弃祂，祂必再次把以色列人丢弃在旷野，这样你们就毁了整个民族。” ");
INSERT INTO cmncbs_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","他们上前对摩西说：“我们要在这里为牲畜建棚圈，为家小筑城邑， ");
INSERT INTO cmncbs_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","让他们留在坚固的城内，免受当地居民的威胁。然后我们必拿起兵器率先上阵，直到帮其他以色列同胞夺取他们的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","在其他同胞占领各自的产业之前，我们决不回家。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","但我们不会跟他们在约旦河西岸分土地，我们已经得到约旦河东边作产业。” ");
INSERT INTO cmncbs_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","摩西说：“如果你们信守承诺，拿起兵器在耶和华面前出战， ");
INSERT INTO cmncbs_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","你们全军就要在耶和华面前渡过约旦河，直到祂赶走祂面前的仇敌， ");
INSERT INTO cmncbs_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","征服那地方。之后，你们才可以回家，才算在耶和华和以色列人面前尽了自己的责任，这地方就在耶和华面前归给你们作产业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","但你们如果不这样做，就是得罪耶和华，必难逃罪责。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","你们现在去为家小筑城邑，为牛羊建棚圈吧，但别忘了信守承诺。” ");
INSERT INTO cmncbs_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","迦得和吕便的子孙对摩西说：“仆人们一定遵命而行。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","我们的妻子、孩子、牛羊等牲畜都会留在基列的各城。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","仆人当中所有能上阵打仗的人都会照你的吩咐在耶和华面前过河作战。” ");
INSERT INTO cmncbs_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","于是，摩西对以利亚撒祭司、嫩的儿子约书亚和以色列各支派的族长说： ");
INSERT INTO cmncbs_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“如果迦得和吕便子孙中所有能上阵打仗的人，在耶和华面前跟你们一同过河作战，你们征服那片土地以后，就要把基列给他们作产业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","如果他们不带着兵器跟你们一起过河作战，就只能在迦南与你们同分产业。” ");
INSERT INTO cmncbs_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","迦得和吕便的子孙再次说：“凡耶和华所吩咐的，仆人们一定照办。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","我们一定带着兵器在耶和华面前过河，进入迦南，但我们要拥有约旦河东边作产业。” ");
INSERT INTO cmncbs_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","摩西就把亚摩利王西宏和巴珊王噩的国土及周围的城邑，都给了迦得的子孙、吕便的子孙和约瑟儿子玛拿西的半个支派。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","迦得的子孙重建了底本、亚他录、亚罗珥、 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","亚他录·朔反、雅谢、约比哈、 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","伯·宁拉和伯·哈兰，使之成为坚固的城池，并建了羊圈。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","吕便的子孙重建了希实本、以利亚利、基列亭、 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","尼波、巴力·免和西比玛。他们为重建的城邑起了新名字，如尼波和巴力·免。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","玛拿西之子玛吉的子孙占领了基列，赶走了那里的亚摩利人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","摩西就把基列赐给玛拿西的儿子玛吉，他便住在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","玛拿西的子孙雅珥占领了基列的村庄，将它们改名为哈倭特·雅珥。 ");
INSERT INTO cmncbs_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","挪巴占领了基纳及其周围的村庄，就按自己的名字称基纳为挪巴。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","以下是以色列人在摩西和亚伦的领导下离开埃及列队行军的路线。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","摩西遵照耶和华的吩咐记录启行的地点，以下是他们停留过的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","一月十五日，即逾越节的第二天，埃及人眼睁睁地看着以色列人昂首挺胸地离开了兰塞。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","当时埃及人正埋葬他们的长子，耶和华击杀了他们当中的长子，并惩罚了他们的众神明。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","以色列人从兰塞启行，至疏割扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","从疏割启行，至旷野边界的以倘扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","从以倘启行，又转到巴力·洗分对面的比哈·希录，在密夺附近扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","从比哈·希录启行，经过红海到书珥旷野，在伊坦旷野走了三天，至玛拉扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","从玛拉启行，至以琳扎营，那里有十二股水泉和七十棵棕树； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","从以琳启行，至红海岸边扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","从红海启行，至汛旷野扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","从汛旷野启行，至脱加扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","从脱加启行，至亚录扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","从亚录启行，至利非订扎营，在那里民众没有水喝； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","从利非订启行，至西奈旷野扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","从西奈旷野启行，至基博罗·哈他瓦扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","从基博罗·哈他瓦启行，至哈洗录扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","从哈洗录启行，至利提玛扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","从利提玛启行，至临门·帕烈扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","从临门·帕烈启行，至立拿扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","从立拿启行，至勒撒扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","从勒撒启行，至基希拉他扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","从基希拉他启行，至沙斐山扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","从沙斐山启行，至哈拉大扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","从哈拉大启行，至玛吉希录扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","从玛吉希录启行，至他哈扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","从他哈启行，至他拉扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","从他拉启行，至密加扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","从密加启行，至哈摩拿扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","从哈摩拿启行，至摩西录扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","从摩西录启行，至比尼·亚干扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","从比尼·亚干启行，至曷·哈吉甲扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","从曷·哈吉甲启行，至约巴他扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","从约巴他启行，至阿博拿扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","从阿博拿启行，至以旬·迦别扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","从以旬·迦别启行，至荀旷野的加低斯扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","从加低斯启行，至以东边界的何珥山扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","以色列人离开埃及后的第四十年五月一日，亚伦祭司遵照耶和华的吩咐上了何珥山，并在那里离世， ");
INSERT INTO cmncbs_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","享年一百二十三岁。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","在南地的迦南人亚拉得王得知了以色列人要来的消息。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","以色列人从何珥山启行，至撒摩拿扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","从撒摩拿启行，至普嫩扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","从普嫩启行，至阿伯扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","从阿伯启行，至摩押边境的以耶·亚巴琳扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","从以耶·亚巴琳启行，至底本·迦得扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","从底本·迦得启行，至亚门·低比拉太音扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","从亚门·低比拉太音启行，至尼波对面的亚巴琳山扎营； ");
INSERT INTO cmncbs_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","从亚巴琳山启行，至耶利哥对面、约旦河边的摩押平原扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","他们沿着约旦河在摩押平原扎营，营地从伯·耶施末一直延伸到亚伯·什亭。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","耶和华在耶利哥对面、约旦河边的摩押平原对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“你告诉以色列人，‘你们过约旦河进了迦南以后， ");
INSERT INTO cmncbs_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","一定要赶走当地的居民，毁掉他们一切的石像和铸像，拆毁他们所有的丘坛。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","你们要占领那片土地，住在那里，因为我已经把那里赐给你们作产业了。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","你们要按宗族抽签分配土地，人口多的多分，人口少的少分，抽到哪块地就得哪块地。你们要按照支派分配土地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","如果你们不赶走那里的居民，留下来的人必成为你们眼里的刺和肋旁的荆棘，在你们所居之地搅扰你们， ");
INSERT INTO cmncbs_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","我也会用预备对付他们的方法来对付你们。’” ");
INSERT INTO cmncbs_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“你把以下指示告诉以色列人。 “你们进入赐给你们作产业的迦南后，你们四境的疆界如下： ");
INSERT INTO cmncbs_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“南部疆界从荀旷野沿着以东边界延伸，东起死海的尽头， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","往南至亚克拉滨坡南面，经荀直到加低斯·巴尼亚南面，再延伸至哈萨·亚达，经押们， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","转向埃及河，直到地中海。 ");
INSERT INTO cmncbs_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“西部以地中海为界，这是你们西部的边界。 ");
INSERT INTO cmncbs_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“北部疆界从地中海开始直到何珥山， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","从何珥山再到哈马口，经西达达、 ");
INSERT INTO cmncbs_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","西斐仑直到哈萨·以难。 ");
INSERT INTO cmncbs_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“东部疆界从哈萨·以难一直划到示番， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","从示番往南到亚延东面的利比拉，再往南到基尼烈湖东岸。 ");
INSERT INTO cmncbs_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","然后沿约旦河南下直到死海。这是你们国土四面的疆界。” ");
INSERT INTO cmncbs_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","摩西又对以色列人说：“这就是耶和华吩咐用抽签的方式分给你们九个半支派的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","吕便支派和迦得支派已经按着家系得到了他们的产业，玛拿西半个支派也得到了他们的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","这两个半支派的产业在耶利哥对面的约旦河东岸。” ");
INSERT INTO cmncbs_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“负责给你们分地的是以利亚撒祭司和嫩的儿子约书亚。 ");
INSERT INTO cmncbs_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","每支派要选出一位首领来协助分地。 ");
INSERT INTO cmncbs_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“以下是这些首领的名字： 犹大支派耶孚尼的儿子迦勒， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","西缅支派亚米忽的儿子示姆利， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","便雅悯支派基斯伦的儿子以利达， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","但支派约利的儿子布基， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","约瑟之子玛拿西支派以弗的儿子汉聂， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","以法莲支派拾弗但的儿子基姆利， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","西布伦支派帕纳的儿子以利撒番， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","以萨迦支派阿散的儿子帕铁， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","亚设支派示罗米的儿子亚希忽， ");
INSERT INTO cmncbs_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","拿弗他利支派亚米忽的儿子比达黑。” ");
INSERT INTO cmncbs_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","这些是奉耶和华之命在迦南给以色列人分产业的首领。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","在耶利哥对面、约旦河边的摩押平原，耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“你告诉以色列人，要从分得的产业中把一些城邑及其周围的草场分给利未人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","城邑供他们居住，草场供他们牧放牛羊等牲畜。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","划分给利未人的草场是从城墙往外延伸四百五十米， ");
INSERT INTO cmncbs_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","要以城为中心，东南西北四郊每边向外量九百米，作利未人的草场。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","要分给利未人四十二座城邑，另外再加六座供误杀人者逃命的避难城， ");
INSERT INTO cmncbs_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","共分给利未人四十八座城邑，包括城周围的草场。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","以色列各支派要按比例从自己承受的产业中分一些城邑给利未人，人多的支派多给，人少的支派少给。” ");
INSERT INTO cmncbs_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“你要告诉以色列人，‘你们过了约旦河进入迦南以后， ");
INSERT INTO cmncbs_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","要选一些城邑作为你们的避难城，供误杀人者逃去避难， ");
INSERT INTO cmncbs_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","躲避复仇的人，以免误杀人者未在会众面前受审，便被杀死。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","你们要选六座城作为避难城， ");
INSERT INTO cmncbs_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","三座在约旦河东岸，三座在迦南。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","凡误杀人的，无论是以色列人，还是在他们当中寄居的外族人，都可以逃到这些城避难。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“‘倘若有人用铁器打人致死，他就是故意杀人，杀人犯必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","倘若有人用足以致命的石头打人致死，他就是故意杀人，杀人犯必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","倘若有人用足以致命的木器打人致死，他就是故意杀人，杀人犯必须被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","报血仇的人要亲自处死故意杀人者，一找到他就要处死他。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","倘若有人因仇恨把人推倒致死，或故意扔东西砸人致死， ");
INSERT INTO cmncbs_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","或因仇恨徒手伤人致死，他就是故意杀人，杀人犯必须被处死，报血仇的人一找到他就要处死他。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“‘倘若有人并非出于怀恨，而是偶然推倒人致死，或无意间扔东西砸人致死， ");
INSERT INTO cmncbs_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","或因没有看见而扔石头砸人致死，鉴于他与对方并非仇人，也无意加害对方， ");
INSERT INTO cmncbs_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","会众就要照这些律例在误杀人者与报血仇者之间做出判决。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","会众要把误杀人者从报血仇者手里救出来，让他回到他原先逃往的避难城。他要住在那里，一直住到受圣油膏立的大祭司逝世。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","但倘若误杀人者离开避难城， ");
INSERT INTO cmncbs_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","报血仇的人在城外找到他，将他杀死也不用担血债。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","因为误杀人者必须留在避难城内，等到大祭司逝世之后，才可返回家园。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","这是你们世世代代无论住在哪里都要遵守的律例。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“‘倘若有人被控谋杀，必须有几个人作证才可以处死他，不可凭一个人的证词处死他。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","犯了死罪的杀人犯必须偿命，不可让他付赎金免死。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","不可收逃进避难城之人的赎金，让他在大祭司逝世前返回家园。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","这样，你们就不致玷污你们所居住的土地，因为血会玷污土地。除非用凶手的血作抵偿，否则被血玷污的土地无法得到洁净。 ");
INSERT INTO cmncbs_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","不可玷污你们所居住的土地，那也是我居住的地方，因为我耶和华住在以色列人中间。’” ");
INSERT INTO cmncbs_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","基列是约瑟之子玛拿西的孙子，玛吉的儿子。他宗族中的各族长来见摩西和做以色列人首领的各族长，说： ");
INSERT INTO cmncbs_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“耶和华曾吩咐我主用抽签的方式把土地分给以色列人，还吩咐我主将我们兄弟西罗非哈的产业分给他的女儿们。 ");
INSERT INTO cmncbs_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","但如果她们嫁给以色列其他支派的人，从我们祖业中分给她们的产业就会归入她们夫家的支派。这样的话，我们抽签分到的土地就会减少。 ");
INSERT INTO cmncbs_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","到了以色列人的禧年，她们所得的产业就会归给她们丈夫的支派，我们支派的祖业就会失去她们那份产业。” ");
INSERT INTO cmncbs_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","摩西照耶和华的话吩咐以色列人说：“约瑟支派的人说的对。 ");
INSERT INTO cmncbs_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","关于西罗非哈的女儿们，耶和华说她们可以自由嫁人，但必须嫁给本支派的人。 ");
INSERT INTO cmncbs_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","以色列人的产业不可从一个支派转到另一个支派，各支派必须守住本支派的祖业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","在以色列各支派中继承了产业的女子必须嫁给本支派的人，以便以色列人都能守住自己的祖业。 ");
INSERT INTO cmncbs_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","以色列人的产业不可从一个支派转到另一个支派，以色列各支派必须守住本支派的产业。” ");
INSERT INTO cmncbs_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","于是，西罗非哈的女儿们遵行了耶和华对摩西的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","玛拉、得撒、曷拉、密迦和挪阿都嫁给了她们叔伯的儿子， ");
INSERT INTO cmncbs_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","即约瑟之子玛拿西支派的人。这样，她们的产业仍留在本支派中。 ");
INSERT INTO cmncbs_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","以上是在耶利哥对面、约旦河边的摩押平原，耶和华借摩西颁布给以色列人的命令和律例。");
INSERT INTO cmncbs_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","以下是摩西对以色列人说的话。当时以色列人在约旦河东的旷野、疏弗对面的亚拉巴，即巴兰、陀弗、拉班、哈洗录和底撒哈之间。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","从何烈山取道西珥山到加低斯·巴尼亚，需十一天。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","在离开埃及后第四十年的十一月一日，摩西把耶和华的一切吩咐告诉了以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","那时，他已经打败了希实本的亚摩利王西宏，以及盘踞在以得来和亚斯她录的巴珊王噩。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","摩西在约旦河东的摩押讲解律法，说： ");
INSERT INTO cmncbs_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“我们的上帝耶和华在何烈山对我们说，‘你们在这山上已经住了足够时日， ");
INSERT INTO cmncbs_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","现在该启程前往亚摩利人的山区、亚拉巴地区、山地、丘陵、南地、沿海一带、迦南人之地和黎巴嫩，直到幼发拉底大河。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","看啊，我把那片土地赐给你们了，你们去占领吧，那是耶和华起誓要赐给你们祖先亚伯拉罕、以撒、雅各和他们后裔的地方。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“那时，我对你们说，‘我无法独自承担管理你们的重任， ");
INSERT INTO cmncbs_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","因为你们的上帝耶和华使你们人丁兴旺，以致今天人数多如天上的星星。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","愿你们祖先的上帝耶和华使你们人数更增千倍，照祂的应许赐福给你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","但我怎能独自担当解决你们问题和争端的重任呢？ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","你们要从各支派中选出有智慧、有见识、受尊重的人，我要立他们做你们的首领。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","你们都同意这样的做法。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","于是，我把各支派中有智慧和受敬重的人立为你们的首领，即千夫长、百夫长、五十夫长、十夫长和其他官长，治理你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","我吩咐这些官员要聆听案件，公正地审理同胞之间，或与外族人之间的诉讼， ");
INSERT INTO cmncbs_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","不可偏私，不分贵贱，不惧情面，因为判决来自上帝。如果案件太难，可以交给我处理。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","那时，我把一切当行之事都告诉了你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“我们照我们上帝耶和华的吩咐，从何烈山出发，走过你们所见的那大而可怕的旷野，前往亚摩利山区，来到加低斯·巴尼亚。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","我对你们说，‘我们的上帝耶和华赐给我们的亚摩利山区到了。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","看啊，你们祖先的上帝耶和华已把那片土地赐给你们，你们要照着祂的应许去占领那里，不要惊慌害怕。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","你们都来对我说，‘我们要先派人去打探那地方，回来好告诉我们当走哪条路，当占哪些城。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","我同意你们的建议，便从你们当中选出十二人，每支派选一人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","他们前往山区，到了以实各谷，打探那地方。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","他们带回来一些那里的果子，禀告说，‘我们的上帝耶和华赐给我们的地方很好。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“但你们却违背你们上帝耶和华的命令，不肯上去。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","你们在帐篷中埋怨说，‘耶和华憎恨我们，所以才领我们离开埃及，要把我们交在亚摩利人手里，让他们消灭我们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","我们能上哪里去呢？我们弟兄的报告让我们胆战心惊，他们说那里的人比我们高大，城邑雄伟，城墙高达云霄，还有亚衲人在那里。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","我对你们说，‘不要惊慌，不要怕他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","你们的上帝耶和华必带领你们，为你们争战，正如祂当着你们的面在埃及所行的一样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","你们在旷野曾目睹你们的上帝耶和华像父亲抱儿子一样，一路把你们抱到这地方。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","33","祂为你们开路，为你们找安营的地方，夜间用火柱、白天用云柱为你们引路。尽管如此，你们还是不信靠你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“你们的埋怨惹耶和华发怒，祂起誓说， ");
INSERT INTO cmncbs_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘这邪恶的一代没有一人能看见我起誓要赐给他们祖先的佳美之地， ");
INSERT INTO cmncbs_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","只有耶孚尼的儿子迦勒能看见，我必把他所踏之地赐给他和他的子孙，因为他一心追随我。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","因为你们的缘故，耶和华也向我发怒，说，‘你也不能进入那片土地， ");
INSERT INTO cmncbs_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","但你的助手、嫩的儿子约书亚可以进入。你要鼓励他，因为他将带领以色列承受那片土地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","你们说你们的子女会被掳去，但这些还不知善恶的孩子都将进入那片土地，我要把那里赐给他们，他们将占领那里。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","而你们要掉头，沿红海的路回到旷野。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“于是，你们对我说，‘我们得罪了耶和华，现在我们愿意遵从我们的上帝耶和华的吩咐，上去作战。’你们便各自拿起兵器，以为可以轻易攻占山区。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","但耶和华让我告诉你们，‘不要上去作战，以免被敌人打败，因为我不与你们同在。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","我把耶和华的话转告了你们，但你们不听，竟违背耶和华的命令，擅自前往山区。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","住在山区的亚摩利人蜂拥出击，打败了你们，从西珥追杀你们，一直追到何珥玛。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","你们回来在耶和华面前哭泣，但耶和华不理会你们的哭声。 ");
INSERT INTO cmncbs_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","因此，你们在加低斯住了很久。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“之后，我们遵照耶和华的吩咐掉转头，沿红海的路前往旷野，在西珥山区绕行了很久。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","后来，耶和华对我说， ");
INSERT INTO cmncbs_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘你们在这山区绕行的日子够了，现在转向北方吧。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","你要吩咐民众：你们将经过西珥，那里住着你们的亲属以扫的子孙。他们惧怕你们，所以你们要格外谨慎， ");
INSERT INTO cmncbs_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","不可挑起战争，因为我已把西珥山赐给以扫作产业，他们的土地，我一寸也不会赐给你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","你们吃的、喝的，都要花钱向他们买。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","你们的上帝耶和华使你们凡事蒙福，看顾着你们走过这辽阔的旷野，四十年来与你们同在，使你们一无所缺。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“于是，我们绕过我们亲属以扫的子孙所住的西珥，沿亚拉巴的路，经过以拉他、以旬·迦别，向摩押旷野走去。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","耶和华对我说，‘不可骚扰摩押人，不可挑起战争，因为我不会把他们的土地赐给你，我已把亚珥赐给罗得的子孙为业。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","“从前以米人住在亚珥，他们人数众多，像亚衲人一样身材高大。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","以米人同亚衲人一样也被称为利乏音人，但摩押人称他们为以米人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","以前，何利人也住在西珥，但以扫的子孙消灭了他们，占领了他们的土地，住在那里，正如后来以色列人占领了耶和华赐给他们的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","耶和华又说，‘现在，你们要动身过撒烈溪。’于是，我们过了撒烈溪。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","我们从离开加低斯·巴尼亚到穿过撒烈溪，用了三十八年。期间，那一代战士都死光了，正如耶和华的誓言。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","其实是耶和华的手攻击他们，直到把他们从营中全部消灭。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“民中所有的战士都死后， ");
INSERT INTO cmncbs_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","耶和华对我说， ");
INSERT INTO cmncbs_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘今天你要经过摩押边境亚珥。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","到亚扪人之地后，不可骚扰他们，不可挑起战争，因为我不会把他们的土地赐给你们，我已把那里赐给罗得的子孙作产业。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","那里以前也是利乏音人住的地方，亚扪人称利乏音人为散送冥， ");
INSERT INTO cmncbs_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","利乏音族人数众多，像亚衲人一样身材高大。耶和华在亚扪人面前消灭了他们，让亚扪人占领他们的土地，住在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","耶和华也曾为以扫的子孙消灭住在西珥的何利人，让他们占据何利人的土地，住在那里，直到今日。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","同样，来自克里特的迦斐托人消灭了迦萨附近乡村的亚卫人，住在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","耶和华说，‘起来穿过亚嫩谷。看啊，我已将亚摩利人希实本王西宏和他的土地交在你手中，你要攻打他，占领他的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","从今天起，我要使天下万民在你面前惊恐万状，一听到你的名字就吓得发抖。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“于是，我从基底莫旷野派使者去见希实本王西宏，提出和平的建议，说， ");
INSERT INTO cmncbs_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘请允许我们从贵国经过，我们只走大路，不会偏离。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","我们吃的喝的，都会花钱向你买，只求让我们步行经过， ");
INSERT INTO cmncbs_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","就像西珥的以东人和亚珥的摩押人那样对待我们，直到我们越过约旦河，进入我们的上帝耶和华所赐之地。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","希实本王西宏却拒绝我们的请求，因为我们的上帝耶和华使他心灵刚硬、顽固不化，好让我们击败他，正如今日的情形。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","耶和华对我说，‘看啊，我已把西宏和他的土地交给你了，去占领他的土地吧。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","西宏率领全军在雅杂与我们交战。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","我们的上帝耶和华使西宏父子及其军队败在我们手下，全军覆没。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","我们攻占了西宏的所有城邑，将其夷为平地，杀光城中的男女老幼，一个不留， ");
INSERT INTO cmncbs_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","只留下牲畜和财物作战利品。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","从亚嫩谷边的亚罗珥和谷中的城，直到基列的所有城邑全被我们攻克，我们的上帝耶和华把这一切都交给了我们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","我们遵照我们的上帝耶和华的吩咐，没有进犯亚扪人的土地，即雅博河一带和山区的城邑。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“之后，我们前往巴珊，巴珊王噩率全军在以得来迎战我们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","耶和华对我说，‘不要怕他，因为我已把他及其众民和土地交在你手中，你要像从前对付希实本的亚摩利王西宏一样对付他。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“我们的上帝耶和华把巴珊王噩及其众民交在我们手中，我们杀了他们，一个不留。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","我们占领了亚珥歌伯全境，即巴珊王噩的所有城邑，共六十座。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","这些城邑围墙高耸，门闩牢固。我们还占领了许多没有城墙的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","像对付希实本王西宏一样，我们将这些城邑夷为平地，城中的男女老幼一个不留， ");
INSERT INTO cmncbs_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","只留下牲畜和财物作战利品。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","于是，我们攻占了约旦河东两个亚摩利王的土地，从亚嫩谷一直到黑门山—— ");
INSERT INTO cmncbs_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","西顿人称黑门山为西连，亚摩利人称之为示尼珥—— ");
INSERT INTO cmncbs_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","我们攻占了高原的城邑、整个基列和巴珊，远至巴珊王噩的城邑撒迦和以得来。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","巴珊王噩是最后一个利乏音人。他的床是铁做的，存放在亚扪人的拉巴城，长四米，宽一米八。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“我们占领了这片土地后，我把亚嫩谷边的亚罗珥以北地区和基列山区的一半及其城邑，分给吕便支派和迦得支派， ");
INSERT INTO cmncbs_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","把基列山区的另一半，以及噩的王国巴珊全境——整个亚珥歌伯分给玛拿西半个支派。巴珊地区又被称为利乏音人之地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","玛拿西的子孙雅珥得到亚珥歌伯全境，远至基述人和玛迦人的边界。他按自己的名字给巴珊取名叫哈倭特·雅珥，沿用至今。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","我又把基列分给玛吉， ");
INSERT INTO cmncbs_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","把从基列到亚嫩谷，以谷中央为界，远至亚扪人的边界雅博河地区，分给吕便支派和迦得支派。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","我还把亚拉巴，就是以约旦河为界，从基尼烈直到东面毗斯迦山脚的亚拉巴海，即盐海地区给了他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“那时我吩咐他们说，‘你们的上帝耶和华已经把这些地方赐给你们，但你们所有的战士必须带着兵器过河，做以色列同胞的先锋。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","我知道你们有许多牲畜，你们的妻子、儿女和牲畜可以留在我分给你们的城邑。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","等你们的上帝耶和华使其他以色列人和你们一样有了安身之所，占领了耶和华赐给他们的约旦河西之地后，你们才可以返回我分给你们的家园。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","那时我吩咐约书亚说，‘你们的上帝耶和华怎样对付那两个王，你都亲眼看见了。耶和华必以同样的方式对付你将去攻占的各国。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","不要怕他们，因为你的上帝耶和华将为你们争战。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“那时，我恳求耶和华，说， ");
INSERT INTO cmncbs_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘主耶和华啊，你已向仆人彰显你的伟大和权能，天上地下没有神明可与你的大能作为相比！ ");
INSERT INTO cmncbs_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","求你让我过去看看约旦河那边的佳美之地，那美好的山区和黎巴嫩。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","但因你们的缘故，耶和华向我发怒，不听我的恳求，祂对我说，‘够了，不要再跟我提这件事。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","你可以上毗斯迦山顶，向东南西北眺望，亲眼看看那片土地，因为你不可过约旦河。 ");
INSERT INTO cmncbs_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","你要委任约书亚，勉励他，支持他，因为他必带领以色列人过河，使他们承受你眺望的那片土地。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","当时，我们驻扎在伯·毗珥对面的谷中。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“以色列人啊，要聆听我传授给你们的律例和典章，要切实遵行，以便你们可以存活，并进去占据你们祖先的上帝耶和华赐给你们的那片土地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","我吩咐你们的，你们不可做任何增减，你们要遵守你们的上帝耶和华的命令。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","你们亲眼看见耶和华在巴力·毗珥事件中的作为，你们的上帝耶和华毁灭了你们中间所有拜巴力·毗珥的人， ");
INSERT INTO cmncbs_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","但你们这些信靠你们的上帝耶和华的人至今都还活着。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","看啊，遵照我的上帝耶和华的吩咐，我把律例和典章传授给你们，好让你们在将要进去占领的土地上遵守。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","你们要谨遵这些律例和典章，因为这样就会让外族人看见你们的智慧和聪明。他们听见这些律例后，必说，‘这伟大的民族真有智慧和聪明！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","我们的上帝耶和华与我们如此亲近，随时垂听我们的呼求，有哪个伟大民族的神明能与之相比？ ");
INSERT INTO cmncbs_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","有哪个伟大的民族拥有我今天所传授给你们的如此公义的律例和典章？ ");
INSERT INTO cmncbs_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“要谨慎、小心，不可忘记亲眼所见的事，要一生铭记在心，并且告诉子子孙孙。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","那天，你们在何烈山站在你们的上帝耶和华面前，耶和华对我说，‘把民众招聚起来，让他们听我的教诲，学习一生敬畏我，并传授给自己的儿女。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","你们来到山脚下，站在那里，山上烈焰冲天、乌云密布、极其幽暗。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","耶和华在火焰中对你们说话，你们只听见祂的声音，却看不见祂的形象。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","祂向你们宣告祂的约，就是祂吩咐你们遵守的十诫，并写在两块石版上。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","那时，耶和华吩咐我把律例和典章传授给你们，好让你们在将要占领的土地上遵守。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“你们要格外小心，耶和华在何烈山的火焰中对你们说话时，你们没有看见任何形象， ");
INSERT INTO cmncbs_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","所以不可堕落，去为自己制造任何形状的神像——男人、女人、 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","飞禽走兽、 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","爬虫或鱼类的像。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","当你们举目观看你们的上帝耶和华赐给天下万民的日、月、星辰等天上万象时，不要受诱惑去跪拜、供奉它们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","耶和华拯救你们脱离埃及那座铁熔炉，让你们做祂自己的子民，正如今日的情形。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","因你们的缘故，耶和华向我发怒，起誓不让我过约旦河、进入祂赐给你们作产业的那片佳美之地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","我将死在约旦河这边，过不了约旦河。但你们必过去得到那片佳美之地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","你们要谨慎，不可忘记你们的上帝耶和华与你们所立的约，不可违背你们上帝耶和华的禁令，去制造任何形状的神像。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","因为你们的上帝耶和华是烈火，是痛恨不贞的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“将来，即使你们在那里安顿已久、子孙满堂，也不可堕落、制造任何形状的神像，不可做你们的上帝耶和华视为邪恶的事，惹祂发怒。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","否则，今天我叫天地作证，你们必很快从约旦河对面将要占领的土地上灭亡，你们必被彻底消灭，不得在那里长久居住。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","耶和华必把你们驱散到列邦，使你们在列邦中的人数所剩无几。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","你们必在那里供奉人用木石造的不会看、不会听、不会吃、不会闻的神像。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","但你们若在那里寻求你们的上帝耶和华，全心全意地寻求祂，就必寻见。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","日后，当你们遭遇这些事，受尽苦难的时候，必归向你们的上帝耶和华，听从祂。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","因为你们的上帝耶和华充满怜悯，祂不会抛弃你们，灭绝你们，也不会忘记祂与你们祖先所立的誓约。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“你们可以查考历史，自上帝在世上造人以来，这样的奇事，天地之间何曾有过？谁曾听闻？ ");
INSERT INTO cmncbs_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","有哪个民族像你们一样，听见了上帝在火中说话，还活了下来？ ");
INSERT INTO cmncbs_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","有哪个神明像你们的上帝耶和华那样在埃及当着你们的面降灾祸、行神迹奇事、发起战争、伸出臂膀、施展大能的手、以伟大而可畏的作为拯救一族脱离异邦？ ");
INSERT INTO cmncbs_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","耶和华行这样的事，是要叫你们知道祂是上帝，除祂以外，别无他神。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","祂让你们听见祂从天上来的声音，好教导你们，又在地上让你们看见祂的烈火，并听见祂在烈火中说的话。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","因为祂爱你们的祖先，所以拣选他们的子孙，亲自用大能带你们出埃及， ");
INSERT INTO cmncbs_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","赶走比你们强大的民族，领你们进入他们的土地，把他们的土地赐给你们作产业，正如今日的情形。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","所以，今天你们要知道并谨记，耶和华是天上地下的上帝，此外别无他神。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","我今天将祂的律例和诫命传授给你们，你们要遵守，以便你们及子孙都蒙福，在你们上帝耶和华所赐的土地上得享长寿。” ");
INSERT INTO cmncbs_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","那时，摩西在约旦河东划出三座城作避难城， ");
INSERT INTO cmncbs_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","供素无冤仇却误杀他人者逃往避难。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","三座城分别是供吕便人避难的比悉，在旷野高原；供迦得人避难的拉末，在基列；供玛拿西人避难的哥兰，在巴珊。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","以下是摩西颁布给以色列人的律法， ");
INSERT INTO cmncbs_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","即在离开埃及后传授给他们的法度、律例和典章。 ");
INSERT INTO cmncbs_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","当时他们在约旦河以东伯·毗珥对面的山谷，那里原属于希实本的亚摩利王西宏。摩西领以色列人离开埃及后消灭了西宏， ");
INSERT INTO cmncbs_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","占领了他的土地，还占领了巴珊王噩的土地。西宏和噩是约旦河东亚摩利人的两个王， ");
INSERT INTO cmncbs_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","其国土从亚嫩谷边的亚罗珥一直到西云山，即黑门山， ");
INSERT INTO cmncbs_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","包括约旦河东的整个亚拉巴，远至毗斯迦山脚的亚拉巴海。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","摩西把所有的以色列人召来，对他们说：“以色列人啊，要留心听我今天对你们宣讲的律例和典章，要学习并谨慎遵行。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","我们的上帝耶和华曾在何烈山与我们立约， ");
INSERT INTO cmncbs_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","这约不是与我们祖先立的，而是与我们今天还活着的人立的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","耶和华在山上的烈火中面对面跟你们说话。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","那时，因为你们害怕那烈火，没有到山上去，我就站在耶和华和你们中间，把耶和华的话传给你们。耶和华说： ");
INSERT INTO cmncbs_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“‘我是你的上帝耶和华，曾把你从受奴役之地埃及领出来。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","除我以外，你不可有别的神明。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","不可为自己雕刻神像，不可仿照天上、地上和地底下水中的任何形象造神像， ");
INSERT INTO cmncbs_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","不可跪拜它们，也不可供奉它们，因为我——你的上帝耶和华痛恨不贞，我必追讨背弃我之人的罪，从父到子直到三四代。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","但那些爱我、遵守我诫命的人，我必以慈爱待他们，直到千代。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","不可妄用你上帝耶和华的名，违者必被耶和华定罪。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","要遵照你的上帝耶和华的吩咐守安息日为圣日。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","你一周可劳碌工作六天， ");
INSERT INTO cmncbs_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","但第七天是你的上帝耶和华的安息日，这一天你和儿女、仆婢、牛驴等牲畜及你那里的外族人不可做任何工，好让仆婢和你一样得到休息。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","要记住，你曾在埃及做奴隶，你的上帝耶和华伸出臂膀，用大能的手把你从那里领出来。因此，你的上帝耶和华吩咐你守安息日。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","要遵照你的上帝耶和华的吩咐孝敬父母，以便在你的上帝耶和华要赐给你的土地上享长寿，蒙祝福。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","不可杀人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","不可通奸。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","不可偷盗。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","不可作伪证陷害人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","不可贪恋别人的妻子，不可贪图别人的房屋、田地、仆婢、牛驴，或其他任何物品。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“这是耶和华在山上的烈火、乌云和幽暗中高声颁布给你们全体会众的诫命。此外，祂没有说别的。祂把这些话写在两块石版上交给我。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","当时，山上燃烧着烈焰，你们听见声音从黑暗中传来。你们各支派的首领和长老都到我跟前， ");
INSERT INTO cmncbs_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","说，‘看啊，我们的上帝耶和华向我们彰显了祂的荣耀和威严，我们听见了祂从火中发出的声音。今天我们已经看见，人听见上帝说话后还能活着。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","但我们何必冒死，被这烈火吞噬呢？我们若再次听到我们的上帝耶和华的声音，必然丧命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","世上有谁像我们一样，听见永活上帝从火中说话后还能活着呢？ ");
INSERT INTO cmncbs_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","你近前听我们上帝耶和华所说的话，然后回来把祂的话告诉我们，我们必听从、遵行。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“耶和华听见了你们的话，就对我说，‘我听见了民众对你说的话，他们所说的都对。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","但愿他们常常敬畏我，遵从我的一切诫命，以便他们和他们的子孙世世代代可以蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","你吩咐他们回到自己的帐篷， ");
INSERT INTO cmncbs_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","但你要留在我这里，我要把所有的诫命、律例和典章都赐给你，你要把这些传授给众人，使他们可以在我要赐给他们的土地上遵行。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","所以，你们要谨遵你们上帝耶和华的吩咐，不可偏离左右。 ");
INSERT INTO cmncbs_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","你们要遵行你们上帝耶和华的一切吩咐，就可以在你们将要占领的土地上存活、亨通、长久。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“你们的上帝耶和华吩咐我教导你们以下的诫命、律例和典章，以便你们在将要占领的土地上遵行。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","这样，你们就会得享长寿，你们及子孙就会终生敬畏你们的上帝耶和华，遵守祂借我吩咐你们的一切律例和诫命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","以色列人啊，你们要留心听，谨慎遵行，以便你们在那奶蜜之乡可以凡事顺利、人口极其繁盛，正如你们祖先的上帝耶和华给你们的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","听啊，以色列人，耶和华是我们的上帝，耶和华是独一的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","你们要全心、全意、全力爱你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","要将我今天吩咐你们的话牢记在心， ");
INSERT INTO cmncbs_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","并教导你们的儿女，无论坐在家里或行在路上，或起或卧，都要讲论这些律例和诫命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","要把它们系在手上、戴在额上作记号， ");
INSERT INTO cmncbs_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","要写在城门上和自家的门框上。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“你们的上帝耶和华将带你们进入祂向你们祖先亚伯拉罕、以撒和雅各起誓要赐给你们的土地。那里宏伟壮观的城邑不是你们建造的， ");
INSERT INTO cmncbs_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","满屋的美物不是你们积攒的，井不是你们挖掘的，葡萄园和橄榄树也不是你们栽种的。你们在那里吃饱喝足之后， ");
INSERT INTO cmncbs_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","要小心，不可忘记把你们从受奴役之地埃及救出来的耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","要敬畏你们的上帝耶和华，事奉祂，凭祂的名起誓。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","不可随从周围各族的神明， ");
INSERT INTO cmncbs_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","免得你们的上帝耶和华向你们发怒，把你们从世上消灭；因为祂住在你们当中，祂痛恨不贞。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“不可像在玛撒那样试探你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","要谨遵你们的上帝耶和华吩咐你们的诫命、法度和律例。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","你们要做耶和华视为正与善的事，以便凡事顺利，得到耶和华起誓要赐给你们祖先的佳美之地， ");
INSERT INTO cmncbs_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","从你们面前赶出所有敌人，正如耶和华所言。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“将来你们的子孙会问，‘我们的上帝耶和华给你们颁布这些法度、律例和典章是什么意思？’ ");
INSERT INTO cmncbs_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","你们要告诉他们，‘我们曾在埃及做法老的奴隶，耶和华用大能的手带我们出埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","我们亲眼看见耶和华行伟大而可畏的神迹奇事，惩罚埃及和法老全家。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","祂带领我们离开埃及，为要把我们带进祂起誓要赐给我们祖先的这片土地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","我们的上帝耶和华吩咐我们遵守这一切律例、敬畏祂，以便我们可以终生受益，生命无忧，正如今日的情形。 ");
INSERT INTO cmncbs_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","我们若按照我们的上帝耶和华的吩咐，在祂面前谨遵这一切诫命，便被算为义人。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“你们的上帝耶和华带领你们进入将要占领的土地时，必从你们面前赶走赫人、革迦撒人、亚摩利人、迦南人、比利洗人、希未人和耶布斯人这七个比你们强大的民族。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","当你们的上帝耶和华把他们交在你们手里、使你们打败他们后，你们必须彻底毁灭他们。不可与他们立约，不可怜悯他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","不可与他们通婚，不可让你们的儿女与他们的儿女通婚， ");
INSERT INTO cmncbs_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","因为他们会让你们的儿女离弃耶和华去拜其他神明，以致耶和华向你们发怒，迅速毁灭你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","你们要这样对待他们：拆毁他们的祭坛，打碎他们的神柱，砍下他们的亚舍拉神像，焚烧他们的偶像。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","因为你们是你们的上帝耶和华的圣民，祂从天下万族中拣选你们做祂宝贵的子民。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“耶和华喜爱你们、拣选你们，不是因为你们的人口比别的民族多——其实你们在万族中是最小的—— ");
INSERT INTO cmncbs_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","而是因为祂爱你们，遵守祂向你们祖先所起的誓。因此，祂用大能的手把你们从受奴役之地领出来，从埃及王法老手中救赎了你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","所以你们要知道，你们的上帝耶和华是上帝，是信实的上帝，祂向爱祂、遵守祂诫命的人守约、施慈爱直到千代。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","但祂必毫不迟延地当面报应、毁灭那些恨祂的人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","所以，你们要谨遵我今天吩咐你们的诫命、律例和典章。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“如果你们听从并谨遵这些典章，你们的上帝耶和华就会信守祂给你们祖先的誓约，以慈爱待你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","祂会爱你们，赐福给你们，使你们在祂向你们祖先起誓要赐给你们的土地上人丁兴旺，牛羊成群，收获丰富的谷物、新酒和油。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","天下万族之中，你们是最蒙福的，你们的男人、女人和牲畜没有不能生育的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","耶和华要使你们免患疾病，免遭你们在埃及所见的恶疾，祂要把那些恶疾降在一切憎恶你们的人身上。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","你们必须灭绝你们的上帝耶和华交在你们手里的各族，不可怜悯他们，不可供奉他们的神明，因为那样会使你们陷入网罗。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“也许你们心里会说，‘这些民族都比我们强大，我们怎能赶走他们呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","不要怕他们，要牢记你们的上帝耶和华曾如何对付法老和整个埃及， ");
INSERT INTO cmncbs_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","你们亲眼目睹祂如何降下大灾难、行神迹奇事、伸出臂膀和大能的手领你们离开埃及，祂也要这样对付你们所惧怕的各族。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","你们的上帝耶和华还要派黄蜂去攻击他们，直到躲藏起来的残存者也全部灭亡。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","不要惧怕他们，因为你们的上帝耶和华住在你们当中，祂是伟大而可畏的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","你们的上帝耶和华将在你们前面逐渐赶走那些民族，你们不可急速地灭尽他们，否则你们周围的野兽会大增，危害你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","你们的上帝耶和华要将他们交给你们，使他们惊恐万状，直到被灭绝。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","祂要将他们的王交在你们手中，无人能抵挡你们，你们要毁灭他们，使他们的名字从世上绝迹。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","你们要烧毁他们的神像，不可贪图神像上的金银，不可将那些金银据为己有，免得你们因此陷入网罗；因为那是你们的上帝耶和华所憎恶的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","不可把可憎之物带到家里，否则你们会像它们一样被毁灭。你们要极其憎恶、厌弃它们，因为它们是当毁灭之物。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“你们要谨遵我今日吩咐你们的一切诫命，以便能够存活，人丁兴旺，进入并得到耶和华起誓要赐给你们祖先的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","要记住这四十年来，你们的上帝耶和华怎样在旷野一路引领你们，祂磨炼你们、考验你们，好知道你们的心意如何、肯不肯遵守祂的诫命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","祂让你们忍饥挨饿，然后赐给你们祖祖辈辈从未见过的吗哪吃，为了使你们明白人活着不是单靠食物，而是靠耶和华口中的每一句话。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","这四十年来，你们的衣服没有穿破，双脚也没有走肿。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","你们心里要明白，你们的上帝耶和华管教你们，如同父亲管教儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","“所以，你们要遵守你们的上帝耶和华的诫命，行祂的道，敬畏祂， ");
INSERT INTO cmncbs_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","因为祂要带你们到一个佳美之地。那里的谷中和山间流淌着条条溪流、股股清泉； ");
INSERT INTO cmncbs_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","那里盛产大麦、小麦、葡萄、无花果、石榴、橄榄油和蜂蜜； ");
INSERT INTO cmncbs_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","那里食物充足，一无所缺；那里矿产资源丰富，石头就是铁，山中可以采铜。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","你们吃饱喝足后，要赞美你们的上帝耶和华，因为祂赐给你们那佳美之地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“你们要谨慎，免得忘记你们的上帝耶和华，不遵守我今天吩咐你们的诫命、典章和律例。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","否则，当你们丰衣足食、居室华美、 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","牛羊成群、金银财物增多的时候， ");
INSERT INTO cmncbs_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","切勿心骄气傲，忘记你们的上帝耶和华。祂把你们从受奴役之地埃及救出来， ");
INSERT INTO cmncbs_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","带领你们走过干旱、可怕、毒蛇和蝎子出没的大旷野。祂使坚硬的磐石流出水来给你们喝， ");
INSERT INTO cmncbs_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","在旷野中把你们祖先从未见过的吗哪赐给你们吃，为要磨炼你们、考验你们，使你们最终得到益处。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","你们切勿以为是凭自己的双手和能力致富的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","要记住，是你们的上帝耶和华赐给你们致富的能力，为要坚立祂给你们祖先的誓约，正如今日的情形。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","“我今天警告你们，如果你们忘记你们的上帝耶和华，去追随、供奉、祭拜其他神明，你们必灭亡。 ");
INSERT INTO cmncbs_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","如果你们不听从你们的上帝耶和华，你们必灭亡，正如祂使列国在你们面前灭亡一样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","“以色列人啊，你们要听！今天你们要过约旦河，去赶出那些比你们强大的民族。他们住在城墙高耸入云的大城里， ");
INSERT INTO cmncbs_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","是长得高大威猛的亚衲人。你们了解他们，也听人说过，‘谁能抵挡亚衲人呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","但今天你们要知道，你们的上帝耶和华要走在你们前面，像烈火一样吞噬他们。祂要制服他们，使你们迅速赶走他们，毁灭他们，正如祂对你们的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“你们的上帝耶和华从你们面前赶走他们以后，你们心里不要以为耶和华带领你们占领那片土地是因为你们公义，其实是因为那里的民族邪恶，耶和华才将他们从你们面前赶走。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","你们能占领他们的土地并非因为你们公义、行为正直。你们的上帝耶和华从你们面前赶走那些民族，是因为他们邪恶，也是为了实现祂给你们祖先亚伯拉罕、以撒和雅各的誓言。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","你们要知道，耶和华赐给你们那佳美之地不是因为你们公义。其实你们是顽固不化的人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“要牢记你们在旷野怎样触怒你们的上帝耶和华。从你们离开埃及那天来到这里，你们屡屡背叛耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","在何烈山，你们触怒了耶和华，以致祂要毁灭你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","那时，我上山去接受耶和华与你们立约的石版，在山上待了四十昼夜，没吃也没喝。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","耶和华把两块立约的石版交给我，上面刻着那天你们聚会时祂在山上的火焰中对你们说的话，是祂用手指刻上去的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","四十昼夜后，耶和华把那两块刻着约的石版交给我， ");
INSERT INTO cmncbs_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","对我说，‘快下山吧，因为你从埃及领出来的百姓已经败坏了。他们这么快就偏离了我吩咐他们走的道，为自己铸造了神像。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","“耶和华又对我说，‘我已看出，这是顽固不化的百姓。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","不要拦我，我要毁灭他们，从世上抹去他们的名字。我要使你成为一个比他们更强大的民族。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","我双手拿着那两块约版，转身从烈火熊熊的山上下来， ");
INSERT INTO cmncbs_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","看见你们为自己铸造了牛犊像，得罪了你们的上帝耶和华，这么快就偏离了耶和华吩咐你们走的道， ");
INSERT INTO cmncbs_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","就当着你们的面摔碎了那两块石版。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","“我又俯伏在耶和华面前，四十昼夜不吃不喝，因为你们犯了大罪，做耶和华憎恶的事，惹祂发怒。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","耶和华向你们发烈怒，要毁灭你们，我非常惧怕。但耶和华再次垂听了我的祈求。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","耶和华对亚伦非常愤怒，以致要杀掉他，于是我也为他祈求。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","我焚烧了你们铸造的罪恶之物牛犊像，把它打碎、磨成粉末，撒在从山上流下来的溪水中。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","“你们在他备拉、玛撒和基博罗·哈他瓦三番四次地触怒耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","你们的上帝耶和华吩咐你们离开加低斯·巴尼亚，去占领祂赐给你们的土地，你们却违背祂的命令，不信靠祂，也不听从祂。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","自从我认识你们以来，你们就不断地背叛耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","“因为耶和华说要毁灭你们，我就俯伏在耶和华面前四十昼夜， ");
INSERT INTO cmncbs_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","向祂祈求说，‘主耶和华啊，求你不要毁灭你的子民！他们是你的产业，是你用大能的手从埃及救赎并带出来的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","求你看在你仆人亚伯拉罕、以撒和雅各的份上，不要计较这个民族的顽固、邪恶和罪过， ");
INSERT INTO cmncbs_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","免得你带领我们离开之地的人说，你不能把他们领到你应许给他们的地方，你憎恶他们，所以把他们带到旷野杀了。 ");
INSERT INTO cmncbs_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","他们毕竟是你的子民，你的产业，是你伸出大能的臂膀从埃及带出来的。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","“当时耶和华对我说，‘你要凿出两块石版，与前两块一样，也要做一个木柜，然后上山来见我。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","我要把你摔碎的那两块石版上的话重新写在你凿的石版上。你要把它们放在柜子里。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","于是，我用皂荚木做了一个柜子，又凿出两块石版，与前两块一样，然后带着石版上了山。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","耶和华把你们在山脚下聚会时，祂在山上的火焰中向你们颁布的十条诫命，重新刻在石版上，并把石版交给我。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","我下山后，遵照耶和华的吩咐把石版放在我做的柜子里。现在石版仍放在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","“我们从亚干人的井出发，来到摩西拉。亚伦死在那里，并葬在那里，他儿子以利亚撒接替他做大祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","我们从那里走到谷歌大，又走到溪流之乡约巴他。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","那时，耶和华把利未支派分别出来，派他们抬祂的约柜，侍立在祂面前事奉祂，奉祂的名祝福，至今未变。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","因此，利未人在众支派中没有分到土地作产业，耶和华是他们的产业，这是你们的上帝耶和华对他们的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","“和前一次一样，我又在山上待了四十昼夜，耶和华又听了我的祈求，答应不毁灭你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","耶和华对我说，‘起来，带民众走吧，去占领我起誓要赐给他们祖先的土地。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“以色列人啊，你们的上帝耶和华对你们有何要求？无非要你们敬畏祂，遵行祂的旨意，爱祂，全心全意地事奉祂， ");
INSERT INTO cmncbs_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","遵守祂的诫命和律例。我今天把这些诫命和律例赐给你们，是为了你们的益处。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","看啊，天和天上的天、大地和地上的万物，都属于你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","但耶和华只喜爱你们的祖先，从万族中拣选了他们的后裔——你们，正如今日的情形。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","所以，你们要洗心革面，不可再顽固不化。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","你们的上帝耶和华是万神之神、万主之主，是伟大、全能、可畏的上帝。祂不徇情面，不受贿赂； ");
INSERT INTO cmncbs_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","祂为孤儿寡妇主持公道，关爱寄居者，供给他们衣食。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","所以，你们要爱寄居者，因为你们也曾寄居埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","你们要敬畏你们的上帝耶和华，事奉祂，倚靠祂，凭祂的名起誓。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","你们要赞美祂，祂是你们的上帝，你们亲眼目睹了祂为你们做的伟大而可畏的事。 ");
INSERT INTO cmncbs_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","当年你们祖先下埃及时，只有七十人，现在你们的上帝耶和华使你们多如天上的星辰。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","“你们要爱你们的上帝耶和华，时刻遵守祂的吩咐、律例、典章和诫命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","要记住，我现在是对你们，而不是对你们的孩子说话。他们没有亲身经历、亲眼见过你们上帝耶和华的管教、威严、大能的手和伸出的臂膀； ");
INSERT INTO cmncbs_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","祂怎样在埃及行神迹奇事对付埃及王法老及其整个国家； ");
INSERT INTO cmncbs_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","怎样使红海淹没追赶你们的埃及军队和车马，将他们永远毁灭； ");
INSERT INTO cmncbs_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","怎样在旷野一路看顾你们，一直来到这里； ");
INSERT INTO cmncbs_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","怎样对付吕便人以利押的儿子大坍和亚比兰，使大地在以色列人当中裂开，吞没了他们及其家人、帐篷和所有随从。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","你们亲眼目睹了耶和华的这些伟大作为。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","“因此，你们要遵守我今天吩咐你们的诫命，以便有力量过河，攻取你们将要攻取的土地， ");
INSERT INTO cmncbs_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","长久居住在耶和华起誓要赐给你们祖先及其后裔的奶蜜之乡。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","你们将要攻取的那片土地不像你们离开的埃及。在埃及你们撒种后，要像浇菜园一样辛勤灌溉。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","而你们将要占领的那片土地却有山有谷，雨水充足， ");
INSERT INTO cmncbs_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","你们的上帝耶和华从岁首到年终时时看顾那里。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","“如果你们谨遵我今天吩咐你们的诫命，全心全意地爱你们的上帝耶和华，事奉祂， ");
INSERT INTO cmncbs_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","祂就会按时给你们的土地降下秋雨和春雨，使你们收获谷物、新酒和油， ");
INSERT INTO cmncbs_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","有草场饲养牲畜，丰衣足食。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","你们要谨慎，免得被迷惑，转而供奉、祭拜其他神明。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","否则，耶和华必向你们发怒，使天不下雨、地无出产，以致你们在祂赐给你们的佳美之地上迅速灭亡。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","“所以，你们要把我的这些吩咐铭记在心，系在手上，戴在额上作记号； ");
INSERT INTO cmncbs_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","要用这些话教导你们的儿女，无论坐在家里或行在路上，或起或卧，都要讲论； ");
INSERT INTO cmncbs_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","也要写在城门上和自家的门框上。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","这样，你们及子孙就可以生活在耶和华起誓要赐给你们祖先的土地上，与天地同长。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","如果你们谨遵我吩咐你们的这一切诫命——爱你们的上帝耶和华，遵行祂的旨意，依靠祂， ");
INSERT INTO cmncbs_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","耶和华就会为你们赶走那些比你们强大的民族，你们也必占领他们的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","你们脚掌踏过的地方都要归你们。你们的疆界南到旷野，北到黎巴嫩，东到幼发拉底大河，西到地中海。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","所到之处无人能抵挡你们，因为你们的上帝耶和华会使那些地方的人对你们充满惧怕，正如祂对你们的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“看啊，我今天把祝福和咒诅摆在你们面前。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","你们若遵行我今天吩咐你们的诫命，就会蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","你们若不遵行你们的上帝耶和华的诫命，偏离我今天吩咐你们当走的道路，随从不认识的其他神明，必受咒诅。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","你们的上帝耶和华带领你们进入并占领那片土地时，你们要在基利心山上宣告祝福，在以巴路山上宣告咒诅。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","基利心山和以巴路山属于住在亚拉巴的迦南人，位于约旦河西岸的日落之处，在吉甲对面，靠近摩利橡树。 ");
INSERT INTO cmncbs_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","你们就要穿过约旦河，占领耶和华赐给你们的土地了。你们占领那里并定居下来以后， ");
INSERT INTO cmncbs_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","要谨遵我今天颁布给你们的一切律例和典章。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","“只要你们生活在你们祖先的上帝耶和华赐给你们的土地上，就要谨遵以下律例和典章。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","“你们赶走那里的列邦后，要彻底摧毁他们在高山上、丘陵上、绿树下供奉其神明的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","你们要拆毁他们的祭坛，打碎他们的神柱，焚烧他们的亚舍拉神像，砍倒他们神明的雕像，使他们的名字从那里消失。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","你们不可按照他们的方式敬拜你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","你们的上帝耶和华要在你们众支派中选一个地方作祂的居所，你们要去那里敬拜祂， ");
INSERT INTO cmncbs_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","把你们的燔祭及其他祭物、十一奉献、举祭、还愿祭、自愿献的祭和头生的牛羊带到那里。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","你们和家人要在那里，在你们的上帝耶和华面前吃喝；要为你们所做的一切蒙祂赐福而欢喜快乐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","“你们不可再像今日这样各行其是， ");
INSERT INTO cmncbs_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","因为到如今你们还没有进入你们的上帝耶和华赐给你们作产业的安歇之地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","但不久你们将渡过约旦河，定居在那片土地上。你们的上帝耶和华将使你们四境太平，安然居住， ");
INSERT INTO cmncbs_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","你们要把我吩咐你们献的燔祭、各种牲祭、十一奉献、举祭和一切还愿祭，带到你们的上帝耶和华选定的敬拜场所。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","在那里，你们和儿女、仆婢及同城中没有分到土地作产业的利未人，要一起在你们的上帝耶和华面前欢喜快乐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","你们切不可随处向耶和华献燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","耶和华会在你们的一个支派中选定敬拜的场所，你们只可以在那里献燔祭，做我吩咐你们的一切事。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","“你们可以随意在居住的各城宰杀牲畜吃，享受你们的上帝耶和华所赐的福，像吃羚羊和鹿一样。洁净的人和不洁净的人都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","但你们不可吃血。要把血倒在地上，像倒水一样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","不可在你们的城里吃十一奉献的谷物、新酒和油、头生的牛羊、还愿祭、自愿献的祭和举祭； ");
INSERT INTO cmncbs_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","要在你们的上帝耶和华选定的地方，与儿女、仆婢及同城的利未人一起在你们的上帝耶和华面前吃。要为你们所做的一切，在你们的上帝耶和华面前欢喜快乐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","切记，只要你们还住在自己的土地上，就不可忘记利未人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","“你们的上帝耶和华按照祂的应许扩展你们的疆域后，你们若想吃肉，随时都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","如果你们的上帝耶和华选定的敬拜场所离你们太远，你们可以在自己的城里，按照我的吩咐，随时宰杀耶和华赐给你们的牛羊吃， ");
INSERT INTO cmncbs_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","就像你们吃羚羊和鹿一样。洁净的人和不洁净的人都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","但你们切不可吃血，因为血就是生命；你们不可把生命和肉一起吃。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","你们切不可吃血，要把血倒在地上，像倒水一样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","你们要做耶和华视为正的事——不可吃血，以便你们及子孙凡事顺利。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","你们要把圣物和还愿祭带到耶和华选定的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","你们要在你们的上帝耶和华的祭坛上献燔祭，连肉带血都要献上。要把其他祭牲的血倒在坛上，但可以吃祭肉。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","你们要认真听从我给你们的这些吩咐，做你们的上帝耶和华视为正与善的事，以便你们及子孙凡事顺利，直到永远。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","“你们的上帝耶和华将为你们铲除列国。你们要赶走他们，住在他们的土地上。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","他们从你们面前被毁灭之后，你们要谨慎，不可受诱惑去效法他们的习俗，不可打听他们神明的事，说，‘这些民族怎样供奉他们的神明呢？我也要效法。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","你们不可按照他们的方式敬拜你们的上帝耶和华。他们祭拜自己神明的种种行为令耶和华憎恶，他们甚至焚烧自己的儿女献给他们的神明。 ");
INSERT INTO cmncbs_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","“你们要谨遵我的一切吩咐，不可增添，也不可删减。 ");
INSERT INTO cmncbs_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","“如果你们中间出现了先知或解梦的人，要显神迹奇事给你们看， ");
INSERT INTO cmncbs_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","劝你们随从、供奉不认识的其他神明，即使他们显的神迹奇事应验了， ");
INSERT INTO cmncbs_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","你们也不可听从他们。因为这是你们的上帝耶和华在试验你们，要看看你们是否全心全意地爱祂。 ");
INSERT INTO cmncbs_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","你们要跟从你们的上帝耶和华，敬畏祂，遵守祂的诫命，听从祂的话，事奉祂，倚靠祂。 ");
INSERT INTO cmncbs_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","必须处死那些先知或解梦的人，因为他们怂恿你们背叛你们的上帝耶和华、偏离祂吩咐你们当走的道路。你们的上帝耶和华曾带你们离开埃及，救赎你们脱离奴役。你们必须清除你们当中的邪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","“如果你们的亲兄弟、儿女、爱妻或挚友暗中引诱你们去拜你们和你们祖先都不认识的其他神明， ");
INSERT INTO cmncbs_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","引诱你们去拜你们周围各族的神明，或在附近或远在天边， ");
INSERT INTO cmncbs_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","你们不可迁就、听从他们，不可怜惜他们，不可放过或包庇他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","必须处死他们。你们要首先下手，然后众人一起打死他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","你们要用石头打死他们，因为他们企图使你们背弃你们的上帝耶和华，祂曾把你们从受奴役之地埃及领出来。 ");
INSERT INTO cmncbs_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","这样，所有以色列人听了就会害怕，必无人再敢在你们中间做这种恶事。 ");
INSERT INTO cmncbs_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","13","“在你们的上帝耶和华将要赐给你们居住的各城中，如果你们听说某城里有恶人引诱城中的居民偏离正路，唆使他们去供奉你们不认识的其他神明， ");
INSERT INTO cmncbs_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","你们要认真查明真相。如果传闻属实，你们当中确有此恶行， ");
INSERT INTO cmncbs_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","你们一定要用刀杀光那城中的居民和牲畜。 ");
INSERT INTO cmncbs_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","你们要把城中的财物堆在广场中心，然后放火焚烧那城和城中的财物，作为燔祭献给你们的上帝耶和华。城要永远荒废，不可重建。 ");
INSERT INTO cmncbs_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","18","你们不可保留任何应当被毁灭的东西，这样耶和华就不再向你们发怒，转而施恩怜悯你们。 “只要你们遵守我今天吩咐你们的一切诫命，做耶和华视为正的事，祂必按照祂对你们祖先所起的誓，怜悯你们，使你们人丁兴旺。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","“你们是你们上帝耶和华的儿女，不可为死人割伤自己或剃光前额。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","因为你们是你们的上帝耶和华的圣民，祂从天下万族中拣选你们作祂宝贵的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","“你们不可吃任何可憎之物。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","但你们可以吃牛、绵羊、山羊、 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","鹿、羚羊、狍子、野山羊、瞪羚、黄羊和野绵羊。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","凡蹄子分瓣且反刍的动物，你们都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","在那些只反刍或只是蹄子分瓣的动物中，你们不可吃骆驼、野兔和石獾，因为它们虽反刍但蹄子不分瓣，是不洁净的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","你们也不可吃猪，因为猪虽蹄子分瓣但不反刍，是不洁净的。你们不可吃这些动物的肉，也不可摸它们的尸体。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","“水族中，凡有鳍有鳞的，你们都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","凡无鳍无鳞的都不洁净，你们不可吃。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","“你们可以吃洁净的鸟类。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","不可吃的鸟类有雕、胡兀鹫、黑秃鹫、 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","鸢、隼类、 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","乌鸦类、 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","鸵鸟、夜鹰、海鸥、鹰类、 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","小鸮、大鸮、仓鸮、 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","鹈鹕、鱼鹰、鸬鹚、 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","鹳、鹭鸟类、戴胜和蝙蝠。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","“凡有翅膀、会爬的昆虫都不洁净，你们不可吃。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","凡有翅膀的洁净之物，你们都可以吃。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","“你们不可吃死掉的动物，但可以送给住在你们城里的外族人吃，或卖给其他外族人。因为你们是你们的上帝耶和华的圣民。你们不可用母山羊的奶煮它的羊羔。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","“你们每年要献出收成的十分之一； ");
INSERT INTO cmncbs_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","要在你们的上帝耶和华选定的敬拜场所，在祂面前吃所献的十分之一的谷物、新酒、油以及头生的牛羊。这是为了让你们学习一生敬畏你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","如果你们的上帝耶和华赐福你们，使你们丰收，而你们住的地方离祂选定的敬拜场所太远，以致不能把收成的十分之一送去， ");
INSERT INTO cmncbs_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","就可以把那些收成换成银钱，带到你们的上帝耶和华选定的场所。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","在那里，你们可以随意买牛、羊、淡酒或烈酒，然后一家人在你们的上帝耶和华面前吃喝快乐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","不可忘记住在你们城里的利未人，因为利未人没有分到土地作产业。 ");
INSERT INTO cmncbs_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","“每逢第三年末，你们要把那年所有出产的十分之一拿出来，存放在你们的城里， ");
INSERT INTO cmncbs_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","让你们城中没有土地的利未人、寄居者和孤儿寡妇都可以来吃饱。这样，你们的上帝耶和华必使你们凡事蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","“每逢第七年末，你们要免除他人的债务。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","你们要这样做，所有债主都要免除同胞所欠的债务，不可向他们追讨，因为宣布免除债务的是耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","你们可以向外族人讨债，但无论同胞欠你什么债务，都要免除。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","5","只要你们留心听从你们上帝耶和华的话，谨遵我今天吩咐你们的诫命，祂必使你们在祂赐给你们作产业的土地上蒙福，你们中间不会有穷人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","你们的上帝耶和华必照祂的应许赐福给你们，你们必借贷给多国，却不需要向他们借贷。你们必统治多国，却不被他们统治。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","“在进入你们的上帝耶和华将要赐给你们的土地后，如果你们居住的城中有贫穷的同胞，你们不可硬着心肠拒施援手。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","你们要伸出援手，按他们的所需慷慨地借给他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","你们要谨慎，不可因为免除债务的第七年将近，就心怀恶念，对贫穷同胞冷眼相待，拒施援手。否则，他们会向耶和华控诉你们，那时你们便有罪了。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","你们要慷慨给予，并且无怨无悔，因为你们的上帝耶和华必在你们所做的一切事上赐福给你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","你们居住的地方总会有穷人，所以我吩咐你们要慷慨地帮助贫穷和有需要的同胞。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","“如果你们的希伯来同胞，不论男女，卖身给你们为奴，他们要服侍你们六年，到第七年，你们要给他们自由。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","你们释放他们时，不可让他们空手离去， ");
INSERT INTO cmncbs_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","要慷慨地把你们的上帝耶和华赐给你们的羊、五谷和酒分给他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","要记住，你们曾在埃及做奴隶，你们的上帝耶和华救赎了你们。所以，我今天吩咐你们这样做。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","如果你们的奴仆因为爱你们和你们的家人，与你们相处融洽，不愿意离去， ");
INSERT INTO cmncbs_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","你们就要让他靠在门上，用锥子在他耳朵上扎个洞，他便终身成为你们的奴仆。对待婢女也要这样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","你们释放奴仆时，不要不情愿，因为他们服侍你们六年，所做的是普通雇工的两倍。而且，你们的上帝耶和华也会在你们所做的一切事上赐福给你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","“你们要把头生的公牛和公羊分别出来，献给你们的上帝耶和华。不可用头生的公牛耕田，也不要剪头生公羊的毛。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","每年，你们全家要去你们的上帝耶和华选定的地方，在祂面前吃这些头生的牛羊。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","如果这些牛羊有什么残疾，如瘸腿、瞎眼或其他缺陷，就不可献给你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","要在你们的城里吃这些牛羊。洁净的人和不洁净的人都可以吃，就像吃羚羊和鹿一样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","但不可吃它们的血，要把血倒在地上，像倒水一样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","“你们要在亚笔月为你们的上帝耶和华守逾越节，因为祂在这个月的一个晚上带你们出了埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","你们要在你们的上帝耶和华为祂的名选定的居所，把牛羊作为逾越节的祭牲献给祂。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","吃祭牲的时候，不可吃有酵的饼，七天之内要吃无酵饼，即忆苦饼，以便你们一生谨记离开埃及的日子，因为当时你们离开得很仓促。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","那七天之内，你们境内不可有酵母。第一天傍晚献的祭肉不可留到早晨。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","在你们的上帝耶和华将要赐给你们的各城中，你们不可献逾越节的祭牲， ");
INSERT INTO cmncbs_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","而是要在傍晚日落时分，即你们离开埃及的时候，到你们的上帝耶和华为祂的名选定的居所献逾越节的祭牲。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","你们要在那里煮祭肉吃，第二天早晨可以返回自己的帐篷。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","在随后的六天之内，你们要吃无酵饼。第七天，要举行庄严的聚会，敬拜你们的上帝耶和华。那一天你们不可做工。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","“从收割那天开始算起，你们要算出七周的时间。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","七周后，要为你们的上帝耶和华守七七收获节。那时，你们要按照你们的上帝耶和华所赐的福分，甘心乐意地献上祭物。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","你们要和儿女、仆婢、同城的利未人、寄居者及孤儿寡妇，在你们的上帝耶和华为祂的名选定的居所，在祂面前一起欢喜快乐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","你们要记住自己曾在埃及做过奴隶，因此要谨遵这些律例。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","“在收藏好谷物和新酒后，你们要守七天的住棚节。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","住棚节期间，你们要和儿女、仆婢、同城的利未人、寄居者及孤儿寡妇一起欢庆。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","要在你们的上帝耶和华选定的地方，为祂守住棚节七天；要满心欢喜，因为你们的上帝耶和华赐福你们，使你们的出产丰富、凡事顺利。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","“你们所有男子要每年三次，即在除酵节、七七收获节和住棚节，在你们的上帝耶和华指定的地方朝见祂。你们不可空手朝见耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","各人要按祂赐的福分，尽自己的能力献上礼物。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","“要在你们的上帝耶和华将要赐给你们的各城中，按支派委任审判官及其他官员。官员们要秉公审判， ");
INSERT INTO cmncbs_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","不可徇私枉法、偏心待人，收受贿赂，因为贿赂蒙蔽智者的眼睛，使正直人颠倒是非。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","你们要追求公正公义，以便存活，承受你们的上帝耶和华赐给你们的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","“在为你们的上帝耶和华建造的祭坛旁，你们不可竖立亚舍拉木神像， ");
INSERT INTO cmncbs_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","也不可竖立神柱，因为这些是你们的上帝耶和华所憎恶的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","“不可把有缺陷或残疾的牛羊献给你们的上帝耶和华，因为这是祂所憎恶的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","“如果有人在你们的上帝耶和华赐给你们的各城镇做祂视为恶的事，违背祂的约， ");
INSERT INTO cmncbs_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","不遵守祂的禁令，去供奉和祭拜其他神明，祭拜日、月或星辰， ");
INSERT INTO cmncbs_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","你们得知后，必须彻底调查。如果属实，在以色列确实有人做这种可憎之事， ");
INSERT INTO cmncbs_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","就要把那人带到城门口，用石头打死他。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","但你们不可单凭一个证人便处死那人，要有两三个证人方可处死他。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","证人要先扔石头，众人随后，这样就除掉了你们中间的罪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","“如果案件复杂，难以决断，如谋杀、诉讼、人身伤害等，就要把案件带到你们的上帝耶和华选定的地方， ");
INSERT INTO cmncbs_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","交给当值的利未祭司和审判官去审理，他们要向你们宣告判决。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","你们必须执行他们在耶和华所选择的地方宣告的判决，你们要谨遵他们的一切指示。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","他们教导你们律法，宣布判决后，你们必须完全执行，丝毫不可偏离。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","如果有人胆敢违抗事奉你们上帝耶和华的祭司和审判官的判决，就必须处死他。如此，你们便从以色列除掉了罪恶， ");
INSERT INTO cmncbs_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","使众人得知后心中害怕，不敢再任意妄为。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","“你们进入并占领你们的上帝耶和华将要赐给你们的土地，安顿下来后，就会想立自己的王，像周围的国家一样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","那么，你们一定要立你们的上帝耶和华拣选的人；必须立你们的以色列同胞为王，不可立外族人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","王不可拥有大量马匹，也不可派人到埃及去购买马匹，因为耶和华已经告诉你们不可回埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","他不可拥有许多妃嫔，恐怕他的心会偏离耶和华，也不可为自己积蓄大量金银。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","他登基后，要按照利未祭司的律法书为自己抄录一份， ");
INSERT INTO cmncbs_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","把它放在身边，一生诵读，以便学习敬畏他的上帝耶和华，遵守律法书上的一切诫命和律例。 ");
INSERT INTO cmncbs_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","这样，他就不会妄自尊大，违背诫命，他和他的子孙就可以长久统治以色列。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","“利未祭司及其他利未支派的人在以色列不可拥有土地。他们吃的是献给耶和华的火祭，那是他们的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","他们在众支派中没有自己的产业，因为耶和华是他们的产业，这是祂的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","众人所献的牛羊的前腿、腮颊和胃应归祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","你们要给祭司初收的五谷、新酒、新油和初剪的羊毛。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","因为你们的上帝耶和华从各支派中拣选了利未人，让他们世代奉祂的名侍立供职。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","“以色列境内任何地方的利未人若愿意离开自己所住的城，一心要去耶和华选定的地方， ");
INSERT INTO cmncbs_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","他可以像在耶和华面前事奉的其他利未人一样，在那里奉他的上帝耶和华之名事奉。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","除了变卖产业所得之外，他还可以分到与其他祭司同等分量的祭物。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“你们进入你们的上帝耶和华将要赐给你们的土地后，不可仿效当地民族的可憎行径。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","你们当中不可有人焚烧自己的子女作祭物，不可有人占卜、算命、作法、行邪术、 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","念咒、做灵媒、行巫术或求问亡灵。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","凡做这些事的人都是耶和华所憎恶的。正是因为当地的民族做这些可憎之事，你们的上帝耶和华才要当着你们的面把他们赶走。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","你们要在你们的上帝耶和华面前纯全无过。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","“你们将要赶走的那些民族听信术士和巫师，但你们的上帝耶和华不准你们仿效他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","你们的上帝耶和华要在你们中间兴起一位像我一样的先知，你们要听从他。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","这正是你们在何烈山聚会时向你们的上帝耶和华所求的，当时你们说，‘不要让我们再听见我们上帝耶和华的声音，也不要让我们再看见这烈火，免得我们死亡。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","于是，耶和华对我说，‘他们说的对。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","我要在他们当中选立一位像你一样的先知，我会告诉他该说的话，他要把我的一切吩咐告诉他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","如果有人不听从他奉我的名所说的话，我必亲自惩罚那人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","若有先知冒我的名说我未曾吩咐他的话，或以其他神明的名义说话，必须处死他。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","你们也许心里会问，‘我们如何知道是否是耶和华说的话呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","如果先知奉耶和华的名说的话没有应验，他的话就不是耶和华说的。他是妄自说预言，你们不用怕他。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","“你们的上帝耶和华毁灭那些民族，把他们的土地赐给你们，使你们赶走他们，住进他们的城邑和房屋后， ");
INSERT INTO cmncbs_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","3","你们要把你们的上帝耶和华赐给你们的土地划分为三个地区，在每个地区设立一座避难城，修好通往这三座城的道路，以便误杀人者可以逃往最近的避难城。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","“如果有人无意间杀了素无冤仇的同伴，他可以逃往避难城，以保住性命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","例如，有人和朋友去森林砍树，砍伐时斧头脱柄，误杀了朋友，他就可以逃往其中一座避难城，以保住性命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","否则，如果避难城离误杀人者太远，怒火中烧的报血仇者就会追上去杀死他。其实他是不该死的，因为他与被误杀的人素无冤仇。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","因此，我吩咐你们要设立三座避难城。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","9","“如果你们谨遵我今天吩咐你们的这一切诫命，爱你们的上帝耶和华，一生遵行祂的旨意，祂就会按照祂对你们祖先所起的誓，扩张你们的疆域，把应许给你们祖先的土地都赐给你们。那时，你们要再设三座避难城， ");
INSERT INTO cmncbs_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","免得无辜人的血流在你们的上帝耶和华赐给你们作产业之地，以致你们担当枉杀无辜的罪。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","“如果有人因憎恨邻居而暗中埋伏，攻击并杀了邻居，然后逃到其中一座避难城， ");
INSERT INTO cmncbs_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","他本城的长老要派人去把他带回来，交给报血仇的人，将他处死。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","不可怜悯他，要从以色列除掉这种滥杀无辜的罪，这样你们才会顺利。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","“在你们的上帝耶和华将要赐给你们作产业之地，你们不可挪动邻居的界石，因为那是先人立的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","“无论是什么罪或过失，不可凭一个证人就定人的罪，必须有两三个证人作证才能定案。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","如果有人作伪证诬陷别人， ");
INSERT INTO cmncbs_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","诉讼双方要站在耶和华面前，让当值的祭司和审判官定夺。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","审判官要仔细审查案件，如果发现那人作伪证诬陷同胞， ");
INSERT INTO cmncbs_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","就要按照他企图加给被诬告者的伤害处罚他。这样，就从你们当中除掉了罪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","其他人听说后，都会害怕，不敢再做这种恶事。 ");
INSERT INTO cmncbs_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","你们对恶人不可心软，要以命偿命，以眼还眼，以牙还牙，以手还手，以脚还脚。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","“你们和敌人交战时，面对比你们强大的军队及战车战马，不要害怕，因为你们的上帝耶和华与你们同在，祂曾带你们出埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","你们出战之前，祭司要上前鼓舞士气， ");
INSERT INTO cmncbs_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","说，‘以色列人啊，听着！今天你们要和敌人交战，不要胆小害怕，也不要惊慌失措。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","因为你们的上帝耶和华要与你们同去，为你们争战，使你们战胜仇敌。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","官长要对士兵说，‘你们谁建了新房子还没有举行奉献礼？他可以回家去，以免他阵亡了，别人为他的房子举行奉献礼。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","谁栽种了葡萄园还没有享受过园中的果子？他可以回家去，以免他阵亡了，别人享受他园中的果子。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","谁订了亲还没有迎娶？他可以回家去，以免他阵亡了，别人娶他的未婚妻。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","官长也要告诉士兵，‘有没有胆怯、害怕的？他可以回家去，免得影响他人士气。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","他们讲完后，就要委派将领率军出战。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","“你们进攻一座城之前，要先给城中居民求和的机会。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","如果他们开城求和，城里所有人都要做你们的奴隶，为你们服劳役。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","如果他们不肯求和，要交战，你们就要围攻那城。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","你们的上帝耶和华把城交给你们时，你们要用刀杀光城里所有的男子， ");
INSERT INTO cmncbs_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","但可以留下城中的妇女、孩童、牲畜及其他一切作战利品。你们可以享用仇敌的财物，那是你们的上帝耶和华赐给你们的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","上述做法只适用于离你们很遥远的城邑，你们附近各族的城邑除外。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","你们的上帝耶和华将把你们附近各族的城邑赐给你们作产业，你们要将里面有气息的全部消灭。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","要遵照你们的上帝耶和华的吩咐，彻底灭绝赫人、亚摩利人、迦南人、比利洗人、希未人和耶布斯人， ");
INSERT INTO cmncbs_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","免得他们将祭拜自己神明的可憎习俗传给你们，以致你们得罪你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","“你们围攻一座城久攻不下时，不可用斧头砍掉那里的树木，因为你们可以吃树上的果子。田间的树木岂是人，让你们围攻吗？ ");
INSERT INTO cmncbs_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","但你们可以砍那些不结果子的树来建围城的工事，直到攻陷为止。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","“在你们的上帝耶和华将要赐给你们的土地上，如果发现有人被杀，陈尸野外，却不知道凶手是谁， ");
INSERT INTO cmncbs_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","当地的长老和审判官就要去测量一下尸体距附近各城邑的距离。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","距离尸体最近的那城的长老们要牵一头从未负过轭、从未耕过地的小母牛， ");
INSERT INTO cmncbs_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","去有溪流但无人耕种过的山谷，在那里把它的颈项打断。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","利未祭司也要去，因为你们的上帝耶和华拣选他们在祂面前事奉、奉祂的名为人祝福，并审理各种纠纷及人身伤害的事。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","那城的长老们要在被打断颈项的小母牛上方洗手， ");
INSERT INTO cmncbs_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","然后祷告说，‘我们的手没有杀这人，我们的眼也没有看见谁杀了他。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","耶和华啊，求你赦免你已经救赎的以色列子民，不要把杀害这无辜之人的罪算在你的子民身上。’这样，杀人的罪便可得到赦免。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","你们做耶和华视为正的事，就可以从你们中间除去杀害无辜之人的罪。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","“你们和敌人交战时，你们的上帝耶和华会把敌人交给你们，使他们成为你们的俘虏。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","如果你们有人在俘虏中看见美丽的女子，被她吸引，想娶她为妻， ");
INSERT INTO cmncbs_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","就可以带她回家，让她剃去头发，修剪指甲， ");
INSERT INTO cmncbs_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","换掉被俘时所穿的衣服，住在那人家中为她父母哀悼一个月。之后，那人便可以和她结为夫妻。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","如果那人不喜欢她，则要让她自由离去，绝不可卖掉她，也不可奴役她，因为他已经羞辱了她。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","“如果一个人有两个妻子，一个受他宠爱，一个不受他宠爱，二人都给他生了儿子，但长子是不受宠爱的妻子生的， ");
INSERT INTO cmncbs_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","分产业的时候，他不可废长立幼，把长子的权利给他所爱之妻生的儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","他必须承认他不爱之妻所生的长子的名分，分给他双份产业，因为长子是他壮年时所生的儿子，应享有长子的权利。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","“如果一个人的儿子冥顽不灵、悖逆父母、屡教不改， ");
INSERT INTO cmncbs_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","他父母要抓住他，把他带到城门口去见本城的长老，对他们说， ");
INSERT INTO cmncbs_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","‘我们这个儿子冥顽不灵、悖逆成性，不肯听从我们，是个贪吃好酒之徒。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","全城的人都要用石头打死他，从你们中间除掉这种罪恶。所有以色列人听说后，都会感到害怕。 ");
INSERT INTO cmncbs_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","“如果有人犯了死罪，被处死后挂在木头上， ");
INSERT INTO cmncbs_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","不可让尸体在木头上过夜，必须当天埋葬，因为凡挂在木头上的人都是上帝所咒诅的。你们不可玷污你们的上帝耶和华将要赐给你们的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","“如果你们看见同胞的牛或羊走迷了路，不可视而不见，要把它带回去交给失主。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","如果失主离你们很远，或者你们不知道失主是谁，就要把它牵回家，等失主来找时再还给他。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","见到同胞遗失的驴、衣物或其他东西，都要这样处理，不可视而不见。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","如果在路上看见同胞的牛或驴倒在地上，不可视而不见，要帮忙把它扶起来。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","“女人不可穿戴男人的衣物，男人也不可穿戴女人的衣物，因为这是你们的上帝耶和华所憎恶的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","“如果你们在路边的树上或地上看见鸟巢，里面有雏鸟或蛋，并有母鸟伏在上面，不可把母鸟和雏鸟一起取走。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","你们可以取走雏鸟，但一定要放走母鸟。这样，你们就会凡事顺利，得享长寿。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","“建造新房时，要在房顶上安设围栏，免得有人从房顶上掉下来，由你们家承担流血之罪。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","“你们不可在葡萄园里种别的作物，否则你们的收成和园中的果子都要充公。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","不可让牛和驴同负一轭耕地。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","不可穿由羊毛和细麻合织的衣物。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","“要在外袍的四角缀上穗子。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","“如果有人娶了妻子，与她同房后却不喜欢她， ");
INSERT INTO cmncbs_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","诽谤她，说，‘我娶了她，与她亲近时发现她已经不是处女’， ");
INSERT INTO cmncbs_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","女方父母就要把凭据拿到城门口的长老们面前，证明女儿的贞洁。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","女方的父亲要对他们说，‘我把女儿嫁给这个人，现在他不喜欢我女儿， ");
INSERT INTO cmncbs_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","诽谤她，声称她结婚时已经不是处女，但这里有我女儿贞洁的凭据。’女方父母要把女儿新婚之夜用过的床单在本城的长老们面前展开。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","长老们就必须抓住那人惩处他， ");
INSERT INTO cmncbs_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","罚他赔偿二十两银子给女方的父亲，因为他诽谤了一个以色列的处女。那女子仍要做他妻子，丈夫终生不可休她。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","“但如果那人的指控属实，没有找到那女子贞洁的凭据， ");
INSERT INTO cmncbs_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","就要把她带到她父亲的家门前，由本城的人用石头打死她。因为她婚前淫乱，在以色列做了可耻的事。你们必须除掉你们中间的罪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","“如果有人与有夫之妇通奸，必须处死奸夫和淫妇，这样就从以色列除掉了罪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","“如果有人在城中遇见已经订婚的女子，与她行淫， ");
INSERT INTO cmncbs_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","你们必须把二人带到城门口，用石头打死他们。那女子该死，因为她在城中却没有高声呼救；那男子该死，因为他奸污了别人的妻子。你们必须除去你们中间的罪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","“如果有人在野外遇见已经订婚的女子，强奸了她，必须处死那男子。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","但不可处死那女子，因为她没有犯该死的罪，她像被攻击、杀害的人一样是无辜的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","因为她是在野外被强奸，即使呼救也无人救她。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","“如果有人遇见未订婚的处女，强奸了她，被发现后， ");
INSERT INTO cmncbs_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","这人要付给女方的父亲十两银子，并娶她为妻，终生不可休她，因为他奸污了她。 ");
INSERT INTO cmncbs_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","“人不可娶他父亲的妻妾，因为这是对他父亲的羞辱。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","“凡睪丸受损或被阉割的，不可加入耶和华的会众。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","“私生子及其十代以内的子孙都不可加入耶和华的会众。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","“亚扪人或摩押人不可加入耶和华的会众，他们的子孙就是到了第十代也不可加入。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","因为在你们离开埃及的途中，他们没有用水和食物款待你们，还雇用美索不达米亚的毗夺人比珥的儿子巴兰咒诅你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","但你们的上帝耶和华不听巴兰的话，反而把咒诅变为祝福，因为祂爱你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","你们一生一世永不可为他们谋求平安和好处。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","“不可憎恶以东人，因为他们是你们的弟兄；也不可憎恶埃及人，因为你们曾经在埃及寄居。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","他们的第三代子孙可以加入耶和华的会众。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","“你们出兵征战时，一定要远离恶事。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","如果有人因梦遗而不洁净，他就要离开营地，住在营外。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","傍晚他要沐浴，日落才可以回营。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","要在营外指定一个地方作方便之处。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","你们每人要装备一把铲子，便溺时要挖个洞，事后要掩埋。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","因为你们的上帝耶和华常在营中巡视，要保护你们，击败你们的仇敌。军营必须保持圣洁，免得祂在你们中间看到任何污秽之事，便离开你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","“如果有奴隶逃到你们那里避难，不可把逃亡的奴隶送交他们的主人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","要让他们在你们当中选择他们喜欢的城邑与你们同住，不可压迫他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","“任何以色列人，不论男女，都不可做庙妓。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","不可把男女庙妓的收入带到你们上帝耶和华的殿还愿，因为两者都是你们的上帝耶和华所憎恶的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","“你们借给同胞钱、粮食或其他任何东西，都不可收取利息。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","你们可以向外族人收取利息，但不可向同胞收取。这样，在你们将要占领的土地上，你们的上帝耶和华必使你们凡事蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","“如果你们向你们的上帝耶和华许愿，不可迟迟不还愿，因为你们的上帝耶和华必追讨许愿不还的罪。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","如果你们不许愿，反倒无罪。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","但如果你们亲口向你们的上帝耶和华许了愿，一定要履行诺言。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","“如果你们进了邻居的葡萄园，可以随意吃，但不可把葡萄放在篮子里带走。 ");
INSERT INTO cmncbs_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","如果你们进了邻居的麦田，可以用手摘麦穗，但不可用镰刀割麦子。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","“如果有人娶妻后，发觉妻子行为不检，因而嫌弃她，他可以写休书给她，让她离开夫家。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","她离开后，可以自由再婚。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","如果她的后夫也嫌弃她，写休书给她，让她离开夫家，或者后夫死了， ");
INSERT INTO cmncbs_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","前夫不可再娶这已被玷污的女子，因为那是耶和华所憎恶的。你们不可把这种罪恶带到你们的上帝耶和华将要赐给你们的土地上。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","“不可叫新婚的人从军出征或办理公务。他可以留在家里一年，使新婚的妻子快乐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","“不可拿别人的磨或磨的上盘作抵押品，因为这等于拿他们的生命作抵押。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","“如果有人绑架自己的同胞，奴役他或卖掉他，必须处死绑架者，除掉你们中间的罪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","“遇到麻风病，你们要谨遵利未祭司的指示。你们要谨遵我对他们的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","要记住你们离开埃及后，你们的上帝耶和华在米利暗身上的作为。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","“如果你们借贷给同胞，不可走进他家里索取抵押物； ");
INSERT INTO cmncbs_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","要站在外面，等他把抵押物拿出来。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","如果他是穷人，用自己的外袍作抵押，你们不可把他的外袍留到第二天， ");
INSERT INTO cmncbs_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","要在当天日落之前还给他，好让他盖着外袍睡觉。他会因此祝福你们，你们的上帝耶和华也会将此视为你们的义行。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","“不可欺压穷苦的雇工，不论他们是你们的同胞，还是住在你们城中的外族人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","你们要在每天日落前付给他们工钱，因为他们穷苦，靠工钱维生；否则他们向耶和华控诉你们，你们就有罪了。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","“不可因孩子犯罪而处死父亲，也不可因父亲犯罪而处死孩子。各人要自负罪责。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","“你们要公正地对待寄居者和孤儿，不可拿寡妇的衣物作抵押。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","要记住，你们曾在埃及做过奴隶，你们的上帝耶和华救赎了你们。所以，我吩咐你们这样行。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","“你们在田间收割庄稼时若遗落了一捆，不可回去取，要留给孤儿寡妇和寄居者。这样，你们的上帝耶和华必使你们凡事蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","你们打橄榄时，打过一次后不可再打，要把剩下的留给孤儿寡妇和寄居者。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","你们摘葡萄时，摘过一次后不可再摘，要把剩下的留给孤儿寡妇和寄居者。 ");
INSERT INTO cmncbs_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","要记住，你们曾在埃及做过奴隶。所以，我吩咐你们这样行。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","“如果发生纠纷，双方告上法庭，审判官要判明是非。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","如果有罪的一方被判受鞭打，审判官要命令他当场伏在地上，按罪行轻重量刑。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","最多可以鞭打他四十下。如果超过四十下，你们就是在公开羞辱自己的同胞。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","“牛在踩谷时，不可笼住它的嘴。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","“如果兄弟们住在一起，其中一个没有儿子便死了，死者的妻子不可改嫁外人。死者的兄弟要尽兄弟的责任娶她为妻。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","她生的第一个儿子要算为死者的儿子，免得死者在以色列无法留名。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","如果死者的兄弟不愿娶那寡妇，她要到城门口见长老们，告诉他们，‘我丈夫的兄弟不肯尽兄弟的责任娶我，不肯为我丈夫在以色列留名。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","本城的长老们要把死者的兄弟召来，与他商谈。如果他执意不肯， ");
INSERT INTO cmncbs_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","那寡妇要当着众长老的面，上前脱下他的鞋，吐唾沫在他脸上，说，‘这就是不肯为兄弟留后之人的下场。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","从此以后，他的家在以色列要被称为‘被脱鞋者之家’。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","“如果两个男人打架，其中一人的妻子为帮助丈夫而伸手抓住另外一人的下体， ");
INSERT INTO cmncbs_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","就要砍掉她的手，不可怜悯她。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","“你们做买卖时，口袋里不可有一大一小两种砝码， ");
INSERT INTO cmncbs_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","家里也不可用一大一小两种量器。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","你们必须使用准确公正的砝码和量器，以便在你们的上帝耶和华要赐给你们的土地上得享长寿。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","因为你们的上帝耶和华憎恶行事诡诈的人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","“你们要记住，你们从埃及出来的路上，亚玛力人是怎样对待你们的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","他们趁你们疲惫不堪时，袭击你们当中掉队的人，毫不敬畏上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","所以，当你们的上帝耶和华赐给你们那片土地作产业、使你们四境安宁时，要灭绝亚玛力人，抹去世人对他们的记忆。你们要切记！ ");
INSERT INTO cmncbs_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","“你们进入你们的上帝耶和华将要赐给你们作产业的土地，占领那里，安居下来以后， ");
INSERT INTO cmncbs_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","要把在那里收获的各种初熟的物产放在篮子里，带到你们的上帝耶和华为祂的名选定的居所。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","你们要对当值的祭司说，‘今天我要向我们的上帝耶和华宣告，我已经进入祂向我们祖先起誓要赐给我们的土地。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","祭司要从你们手中接过篮子，放在你们的上帝耶和华的祭坛前。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","你们要在你们的上帝耶和华面前宣告，‘我们的祖先原是漂泊的亚兰人。他下到埃及寄居时，家中人丁稀少，后来成为人口众多的强大民族。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","埃及人苦待我们，压迫我们，强迫我们做苦工。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","于是，我们呼求我们祖先的上帝耶和华。祂听见我们的呼求，看见我们的痛苦、艰辛和所受的压迫， ");
INSERT INTO cmncbs_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","就伸出臂膀，用大能的手行神迹奇事，以伟大而可畏的作为带我们出埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","祂带领我们来到这个地方，把这奶蜜之乡赐给我们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","耶和华啊，现在我从你赐给我的土地上带来初熟的物产。’你们要把篮子放在你们的上帝耶和华面前，敬拜祂。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","你们和利未人以及住在你们中间的外族人，都要因你们的上帝耶和华赐给你们和你们家人的福祉而欢喜快乐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","“每逢第三年是十一奉献年。你们应当把自己所有出产的十分之一拿出来分给利未人、寄居者和孤儿寡妇，使他们在你们居住的城邑吃饱喝足。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","然后，你们要在你们的上帝耶和华面前宣告，‘我已经按照你的诫命，从家里拿出圣物分给利未人、寄居者和孤儿寡妇。我没有触犯也没有忘记你的任何诫命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","这些圣物，我守丧期间没有吃过，不洁净时没有拿过，也没有献给死人。我听从我的上帝耶和华，遵行你的一切吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","求你从天上圣洁的居所垂看，赐福给你的以色列子民和你赐给我们的土地，就是你向我们祖先起誓应许的奶蜜之乡。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","“你们的上帝耶和华今天吩咐你们遵守这些律例和典章，你们要全心全意地谨慎遵守。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","你们今天已经宣布耶和华是你们的上帝，并愿意遵行祂的道，谨守祂的一切律例、诫命和典章，听从祂的话语。 ");
INSERT INTO cmncbs_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","耶和华今天已经照祂的应许宣布你们是祂的子民，是祂宝贵的产业。因此，你们要遵守祂的一切诫命， ");
INSERT INTO cmncbs_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","这样祂必使你们备受赞誉和尊崇，超越祂所造的万国，并照着祂的应许使你们做祂的圣民。” ");
INSERT INTO cmncbs_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","摩西和以色列众长老吩咐民众说：“你们要遵守我今天吩咐你们的一切诫命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","你们渡过约旦河、进入你们的上帝耶和华赐给你们的土地那天，要竖立几块大石，涂上石灰。 ");
INSERT INTO cmncbs_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","你们渡过约旦河，进入你们祖先的上帝耶和华应许要赐给你们的奶蜜之乡后，要把这律法一字不漏地写在大石上。 ");
INSERT INTO cmncbs_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","你们渡过约旦河后，要照我今日的吩咐，在以巴路山上竖立这些石头，涂上石灰。 ");
INSERT INTO cmncbs_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","要在那里为你们的上帝耶和华筑一座石坛，不要用铁器凿刻石头。 ");
INSERT INTO cmncbs_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","要用未凿过的石头为你们的上帝耶和华筑一座坛，在上面献燔祭给祂； ");
INSERT INTO cmncbs_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","又要献上平安祭，在祂面前吃喝快乐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","你们要把这律法一字不漏、清清楚楚地写在那几块大石上。” ");
INSERT INTO cmncbs_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","摩西和利未祭司对全体以色列人说：“以色列人啊，要肃静聆听！你们今天已成为你们上帝耶和华的子民。 ");
INSERT INTO cmncbs_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","你们要听从祂，遵守祂的诫命和律例，就是我今天吩咐你们的。” ");
INSERT INTO cmncbs_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","那天，摩西吩咐民众说： ");
INSERT INTO cmncbs_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","“你们渡过约旦河后，西缅、利未、犹大、以萨迦、约瑟和便雅悯各支派要站在基利心山上为民众祝福； ");
INSERT INTO cmncbs_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","吕便、迦得、亚设、西布伦、但和拿弗他利各支派要站在以巴路山上宣告咒诅。 ");
INSERT INTO cmncbs_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","利未人要对所有以色列人高声说： ");
INSERT INTO cmncbs_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","“‘凡雕刻或铸造耶和华所憎恶的神像，就是匠人制作的，并偷偷供奉的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“‘凡不尊敬父母的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“‘凡挪移邻居界石的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“‘凡故意带领盲人走错路的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“‘凡不为寄居者和孤儿寡妇伸张正义的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“‘凡与父亲的妻妾乱伦的必受咒诅，因为他羞辱了父亲！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“‘凡与兽交合的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“‘凡与同父异母或同母异父的姊妹乱伦的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“‘凡与岳母乱伦的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“‘凡暗杀邻居的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“‘凡因收受贿赂而杀害无辜的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","“‘凡不遵行这律法的必受咒诅！’ 全体民众要回答说，‘阿们！’ ");
INSERT INTO cmncbs_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","“你们若全心顺服你们的上帝耶和华，谨遵祂今天借我吩咐你们的一切诫命，祂必使你们超越天下万国。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","你们若听从你们的上帝耶和华的话，以下这些福气必临到你们，追随你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","“无论你们在城里还是乡间，都必蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","“你们必子孙昌盛，五谷丰登，牛羊成群。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","“你们的篮子和揉面盆都必蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","“你们出入都必蒙福。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","“耶和华必使来犯之敌败在你们面前、溃不成军、四散逃命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","“耶和华必使你们凡事蒙福、五谷满仓。你们的上帝耶和华必在祂赐给你们的土地上赐福你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","“你们若遵守你们上帝耶和华的诫命，遵行祂的旨意，祂必按自己的誓言立你们作祂圣洁的子民。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","天下万民将看出你们是耶和华名下的子民，并惧怕你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","“在耶和华向你们祖先起誓要赐给你们的土地上，祂必使你们子孙昌盛、牛羊成群、五谷丰登。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","耶和华要为你们打开天上的宝库，使你们风调雨顺、凡事蒙福。你们必借贷给多国，却无需向别国借贷。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","14","你们若听从你们的上帝耶和华借我今天吩咐你们的诫命，谨慎遵行，毫不偏离，也不随从、供奉其他神明，祂必使你们做首不做尾，居上不居下。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","“你们若不听从你们的上帝耶和华，不谨遵祂今天借我吩咐你们的一切诫命和律例，祂必使以下的咒诅临到你们，追随你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","“无论你们在城里还是乡间，都必受咒诅。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","“你们的篮子和揉面盆都必受咒诅。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","“妇女所生的，土地所产的，牛羊所生的都必受咒诅。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","“你们出入都必受咒诅。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","“因为你们作恶、背弃耶和华，祂要使你们凡事受咒诅、混乱不堪、饱受责罚，直到你们被毁灭，迅速灭亡。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","“耶和华要使瘟疫紧紧跟随你们，直到你们在将要占领的土地上被灭绝。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","“耶和华要使你们遭受痨病、热症、炎症、炙热、刀剑、干旱和霉烂之灾。这些要危害你们，直到你们灭亡。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","“耶和华要使你们头顶的天如铜，脚下的地如铁。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","“耶和华要使雨水变为尘土，降在你们身上，直到你们灭亡。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","“耶和华要使你们被敌人击败、溃不成军、四散逃命，下场令天下万国惊惧。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","你们的尸体要成为飞禽走兽的食物，必无人赶走它们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","“耶和华要使你们患埃及的脓疮、肿瘤和癣疥，无药可治。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","“耶和华要使你们发疯、瞎眼、心智错乱。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","“你们必在大白天摸索，就像盲人在黑暗中摸索一样，你们的道路必不得亨通，你们要终日受人欺压抢掠，无人搭救。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","“你们聘了妻子，别人必占有她们；你们盖了房屋，必不能住在里面；你们栽种葡萄园，必吃不到园中的出产。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","“你们必看着自己的牛被宰杀却吃不到肉，自己的驴被抢走后一去不还，自己的羊被敌人掳走却无人搭救， ");
INSERT INTO cmncbs_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","自己的儿女被外族人掳走，你们终日望眼欲穿，却无能为力。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","“与你们素不相识的民族必吃光你们土地的出产和劳碌所得，你们必常受欺压， ");
INSERT INTO cmncbs_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","以致眼前的一切令你们发疯。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","“耶和华要使你们从头到脚长满毒疮，无药可治。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","“耶和华要带你们和你们立的王，到一个你们和你们祖先都不知道的国家，你们要在那里供奉木石神像。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","“在耶和华驱逐你们去的列国，你们的下场令人惊骇，被人嘲笑和讥讽。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","“你们种的多，却收的少，因为庄稼必被蝗虫吃掉。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","“你们栽种、修剪葡萄园，却吃不到葡萄，也喝不到葡萄酒，因为葡萄必被虫子吃掉。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","“你们境内长满橄榄树，却没有橄榄油抹身，因为橄榄必未熟先落。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","“你们生儿育女，却留不住一个，因为他们必被掳走。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","“蝗虫要吃光你们的树木和地上的出产。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","“你们中间的外族人要日益兴旺，你们却要日渐衰微。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","“他们要借贷给你们，你们却不能借贷给他们。他们要做首，你们要做尾。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","“因为你们不听从你们上帝耶和华的话，不遵守祂吩咐你们的诫命和律例，这些咒诅都必临到你们、追赶你们，直到毁灭你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","这些咒诅要永远作为你们和你们子孙的神迹奇事。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","因为你们在富足时不心甘情愿地事奉你们的上帝耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","所以你们必饥饿干渴、赤身裸体、一无所有地侍奉耶和华派来攻击你们的敌人。祂要把铁轭加在你们的颈上，直到消灭你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","“耶和华要使一国从遥远的地极兴起，他们要如鹰飞来袭击你们。你们不懂他们的语言。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","他们面目狰狞，不尊重年老的，也不怜悯年少的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","他们要吃光你们的牛羊、五谷、新酒和油，直到消灭你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","在你们的上帝耶和华所赐给你们的整片土地上，他们要把你们围困在各个城邑中，直到你们所依赖的高大坚固的城墙都倒塌。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","“当你们被敌人围困、陷入绝境时，你们必吃自己的亲生骨肉，就是你们的上帝耶和华赐给你们的儿女。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","55","你们被敌人围困在各城中，陷入绝境时，连你们中间最温柔体贴的男人也要独自吞吃子女的肉，不肯分给自己的兄弟、爱妻和剩下的儿女，因为他别无所有。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","57","你们被敌人困在各城中，陷入绝境时，连你们中间最温柔、娇嫩得连脚也不肯踏在地上的妇女，都要偷偷吃掉自己生的婴儿和胎胞，不肯分给所爱的丈夫和子女。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","“如果你们不谨遵这书上所写的一切律法，不敬畏你们的上帝耶和华那荣耀、可畏的名， ");
INSERT INTO cmncbs_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","祂必使你们及子孙遭遇严重而长久的灾难和疾病， ");
INSERT INTO cmncbs_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","使你们所惧怕的埃及人的一切疾病都降在你们身上，缠住你们， ");
INSERT INTO cmncbs_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","还使各种未记在这律法书上的疾病和灾难降在你们身上，直到消灭你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","因为你们不听从你们的上帝耶和华的话，即使你们的人数多如天上的星，也将所剩无几。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","正如耶和华喜欢赐福你们，使你们人丁兴旺，祂也同样会不惜消灭你们，使你们在将要占领的土地上被铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","“耶和华要把你们分散到天下万邦，你们要在那里供奉祖祖辈辈素不认识的木石神像。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","你们在万邦中将不得安宁，没有落脚之地，耶和华必使你们胆战心惊、目光呆滞、精神颓废。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","你们必惴惴不安，昼夜恐惧，生死难料。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","你们必看见可怕之事，以致心中充满恐惧，早上盼望天黑，晚上盼望天亮。 ");
INSERT INTO cmncbs_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","耶和华必沿着我曾说你们再不会走的路线，用船把你们送回埃及。你们将在那里卖身做敌人的仆婢，却无人买。” ");
INSERT INTO cmncbs_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","耶和华除了与以色列人在何烈山立约外，还在摩押吩咐摩西与以色列人立以下的约。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","摩西召来所有以色列人，对他们说：“你们曾亲眼见过耶和华在埃及怎样对付法老及其臣仆和国民， ");
INSERT INTO cmncbs_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","亲眼看见祂怎样降下巨大的灾难，行伟大的神迹奇事。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","但耶和华至今还没有赐给你们能明白的心、能看见的眼、能听清的耳。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","四十年来，耶和华领你们走过旷野，你们身上的衣服没有穿破，脚上的鞋没有穿坏； ");
INSERT INTO cmncbs_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","你们没有吃饼，也没有喝淡酒和烈酒。这是为了让你们知道耶和华是你们的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","我们来到这里的时候，希实本王西宏和巴珊王噩都出来攻击我们，我们击败了他们， ");
INSERT INTO cmncbs_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","并将占领的土地分给吕便支派、迦得支派和玛拿西半个支派作产业。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","所以，你们要谨遵这约上的话，以便凡事顺利。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","“今天，你们全都站在你们的上帝耶和华面前，包括你们的族长、长老、官员、所有以色列男子、 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","你们的孩子、妻子和寄居在你们营中为你们砍柴挑水的外族人， ");
INSERT INTO cmncbs_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","为要接受你们的上帝耶和华今天与你们立的誓约。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","这样，祂今天将确立你们作祂的子民、祂作你们的上帝，正如祂对你们的应许和对你们祖先亚伯拉罕、以撒和雅各的誓言。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","耶和华的这誓约不仅是与你们立的， ");
INSERT INTO cmncbs_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","也是与今天一同站在我们的上帝耶和华面前的人，以及今天不在这里的人立的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","“你们知道我们如何在埃及生活，也知道我们如何穿越列国来到这里。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","你们也见过他们可憎的木、石、金、银偶像。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","你们中间，不论男人或女人，家族或支派，切不可有人背弃我们的上帝耶和华，去祭拜列国的神明，你们中间切不可有残根长出苦毒的果实， ");
INSERT INTO cmncbs_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","免得有人听了这誓言后，心存侥幸地说，‘即使我一意孤行，连累他人，也必平安无事。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","耶和华绝不会赦免这样的人，祂必向这样的人发烈怒和义愤，使记在这书上的一切咒诅临到他身上，从世上抹去他的名字。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","耶和华必把他从以色列各支派中隔离出来，使他按律法书上约中的一切咒诅受惩罚。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","“你们的子孙后代和从远方来的外族人，必看见耶和华降在这地方的灾祸和疾病。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","遍地将是硫磺和盐，无法耕种，寸草不生，如同耶和华盛怒之下毁灭的所多玛、蛾摩拉、押玛和洗扁。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","万国必问，‘耶和华为什么要这样对待这地方？祂为什么大发烈怒？’ ");
INSERT INTO cmncbs_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","必有人回答说，‘因为这地方的人背弃了他们祖先的上帝耶和华领他们出埃及时与他们所立的约， ");
INSERT INTO cmncbs_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","去供奉其他神明，祭拜他们不认识、也非耶和华分派给他们的神明。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","因此，耶和华向这片土地发怒，把这书上写的一切咒诅都降在这里。 ");
INSERT INTO cmncbs_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","耶和华在怒气、义愤和烈怒中把他们从这地方连根拔起，扔到别的地方，正如今日的情形。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","“奥秘的事属于我们的上帝耶和华，只有显明的事永远属于我们和我们的子孙，以便我们可以遵守这律法上的一切话。” ");
INSERT INTO cmncbs_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","“当我向你们陈明的这些祝福和咒诅都应验在你们身上时，如果你们在你们的上帝耶和华驱逐你们去的各国中回想这些话， ");
INSERT INTO cmncbs_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","归向你们的上帝耶和华，你们及子孙照我今天的吩咐，全心全意地听从祂的话， ");
INSERT INTO cmncbs_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","祂必改变你们被掳的境遇，怜悯你们，把你们从祂驱逐你们去的列国招聚回来。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","即使你们被驱逐到天涯，你们的上帝耶和华也会召集你们，带你们回来， ");
INSERT INTO cmncbs_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","带到你们祖先的土地上，使你们拥有那片土地，比你们祖先更加人丁兴旺、繁荣昌盛。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","你们的上帝耶和华要洁净你们和你们子孙的心，好让你们全心全意地爱祂，并且存活。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","你们的上帝耶和华要把所有的咒诅加在你们的仇敌及憎恶你们、迫害你们的人身上。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","你们必再次听从耶和华，遵行今天祂借我吩咐你们的一切诫命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","10","倘若你们听从你们的上帝耶和华的话，遵守这律法书上的诫命和律例，全心全意地归向祂，祂必使你们凡事蒙福、儿女众多、牛羊成群、五谷丰登。因为祂必乐意再次赐福你们，像从前赐福你们祖先一样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","“我今天颁布给你们的诫命，对你们来说不难，也非遥不可及。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","这诫命并非在天上，以致你们说，‘谁替我们上天取下来，讲给我们听，让我们遵行呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","这诫命也不在海的彼岸，以致你们说，‘谁替我们过海取来，讲给我们听，好让我们遵行呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","这话语近在咫尺，就在你口里，在你心中，好让你遵行。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“看啊，今天我把生死祸福摆在你们面前。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","我今天吩咐你们要爱你们的上帝耶和华，遵行祂的旨意，遵守祂的诫命、律例和典章，以便你们可以存活，人丁兴旺，在你们将要占领的土地上蒙祂赐福。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","但倘若你们心中偏离，不肯听从，被引诱去祭拜、供奉其他神明， ");
INSERT INTO cmncbs_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","我今天警告你们，你们必定灭亡，在约旦河西岸你们将要去占领的土地上无法长久。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","今天，我叫天地为你们作证，我已把生死祸福摆在你们面前。选择生命吧，以便你们及子孙可以存活。 ");
INSERT INTO cmncbs_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","要爱你们的上帝耶和华，听从祂的话，倚靠祂，因为祂是你们的生命，祂必使你们长久住在祂起誓要赐给你们祖先亚伯拉罕、以撒和雅各的土地上。” ");
INSERT INTO cmncbs_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","摩西继续对以色列人说： ");
INSERT INTO cmncbs_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“我现在已经一百二十岁了，无法再继续带领你们，耶和华曾说我不得过约旦河。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","你们的上帝耶和华要亲自带领你们过河，在你们面前消灭那里的各族，使你们占领他们的土地。约书亚将带领你们过河，正如耶和华所言。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","耶和华要毁灭那里的各族，像毁灭亚摩利二王西宏和噩及其国家一样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","耶和华要把他们交给你们，你们要照我的一切吩咐处置他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","你们要刚强勇敢，不要惧怕他们，因为你们的上帝耶和华与你们同行，祂不会撇下你们，也不会离弃你们。” ");
INSERT INTO cmncbs_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","摩西把约书亚叫来，当着全体以色列人的面对他说：“你要刚强勇敢！因为你要与百姓一同进入耶和华起誓要赐给他们祖先的土地，把土地分给他们作产业。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","耶和华必带领你，与你同在。祂不会撇下你，也不会离弃你。不要惊慌害怕。” ");
INSERT INTO cmncbs_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","摩西把这律法写好，交给抬耶和华约柜的利未祭司和以色列的众长老。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","摩西吩咐他们说：“每逢免除债务的第七年的住棚节， ");
INSERT INTO cmncbs_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","所有以色列人到你们的上帝耶和华选定的地方朝见祂时，你们要当众大声宣读这律法。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","要招聚所有男女、孩童以及住在你们中间的外族人，让他们聆听这律法，学习敬畏你们的上帝耶和华，谨遵律法上的一切话。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","这样，他们那些还不知道这律法的孩子便有机会听到律法，在你们将要占领的约旦河西岸的土地上，学习终生敬畏你们的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","耶和华对摩西说：“你快要离世了。叫约书亚与你一起到会幕，我要委派他。”摩西和约书亚就来到会幕。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","有云柱停在会幕入口的上方，耶和华在云柱中向他们显现。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","耶和华对摩西说：“你快要与祖先同眠了。这些百姓将很快在要占领的土地上与外族人的神明苟合，背弃我，违背我与他们所立的约。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","那时，我要向他们发怒，离弃他们，掩面不理他们。他们将被吞灭，遭遇许多祸患和灾难，以致他们会说，‘这些祸患临到我们，岂不是因为上帝不在我们中间了吗？’ ");
INSERT INTO cmncbs_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","那时，我必掩面不理他们，因为他们祭拜其他神明，行为邪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","“现在，你要写一首歌，教导以色列人，让他们吟唱，作为我指控他们的证据。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","因为当我把他们带到我起誓应许他们祖先的奶蜜之乡后，当他们在那里吃饱喝足后，就会嫌弃我，违背我与他们所立的约，去供奉其他神明。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","当许多祸患和灾难临到他们的时候，这首歌就要成为指控他们的证据，因为这首歌要在他们的子孙中世代流传。虽然我还没有带领他们进入我起誓应许之地，我已经知道他们的心思意念。” ");
INSERT INTO cmncbs_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","当天，摩西就写下这首歌，传授给以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","耶和华嘱咐嫩的儿子约书亚：“你要刚强勇敢，因为你要带领以色列人进入我起誓应许他们的土地，我必与你同在。” ");
INSERT INTO cmncbs_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","摩西把这律法都写在书上以后， ");
INSERT INTO cmncbs_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","就吩咐抬耶和华约柜的利未人： ");
INSERT INTO cmncbs_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“把这律法书放在你们的上帝耶和华的约柜旁，作为指控你们的证据。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","因为我知道你们悖逆、顽固不化，我还活在你们中间的时候，你们尚且背叛上帝，何况我死后呢？ ");
INSERT INTO cmncbs_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","把你们各支派的长老和首领招聚来，我要把这些话告诉他们，叫天地作证来指控他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","我知道，我死后你们会彻底堕落，偏离我吩咐你们行的道，做耶和华视为恶的事，惹祂发怒，将来祸患必临到你们。” ");
INSERT INTO cmncbs_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","然后，摩西把这首诗歌从头到尾读给以色列全体会众听。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","“诸天啊，请听我说； 大地啊，请听我言。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","愿我的教导如雨降下， 愿我的话语如露滴落， 像水滴滋润嫩草， 像甘霖浇灌草木。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","我要宣扬耶和华的名， 你们要颂赞我们上帝的伟大。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","“祂是磐石， 祂的作为完美， 祂按公义行事， 祂信实可靠，公平正直。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","狡诈、堕落的一代啊， 你们却对祂不忠，行事败坏， 不配做祂的儿女。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","愚昧无知的人啊， 你们就这样报答耶和华吗？ 祂是你们的父，你们的创造主， 祂创造了你们，塑造了你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","“要回顾往昔，追溯历史； 问你们的父亲， 他们必回答你们； 问你们的长者， 他们必告诉你们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","当初，至高者赐万国产业， 把人类分开， 祂依照天使的数目， 为万族定疆界。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","但以色列人属于耶和华， 雅各是祂的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","“在荒凉的旷野， 在野兽吼叫的荒野， 耶和华找到他们， 庇护他们，看顾他们， 保护他们如同保护眼中的瞳仁， ");
INSERT INTO cmncbs_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","又如老鹰搅动窝巢， 盘旋在雏鹰之上， 展开双翼接住它们， 背着他们飞翔。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","耶和华独自带领他们， 没有外族神明同在。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","耶和华使他们驰骋在大地的高处， 吃田间的五谷， 磐石中的蜂蜜， 石头地产的油； ");
INSERT INTO cmncbs_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","吃牛酪和羊奶， 肥美的羔羊， 巴珊的绵羊和山羊， 上好的麦子； 喝葡萄汁酿的酒。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","“但耶书仑吃饱喝足， 养肥长壮后，就得意忘形， 背弃造他们的上帝， 藐视救他们的磐石。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","他们拜外族的神明，令祂愤恨； 行可憎之事，惹祂发怒。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","他们祭拜的不是真神， 而是鬼魔， 是他们素不认识的新神明， 是他们祖先所不敬畏的。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","他们轻视生他们的磐石， 忘记养他们的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","“耶和华看见祂儿女的恶行， 就愤然厌弃他们， ");
INSERT INTO cmncbs_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","说，‘这堕落的子民， 不忠的儿女！ 我要掩面不理他们， 看他们的结局如何。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","他们拜假神，让我愤恨； 供虚无之物，惹我发怒。 我要借无名之民挑起他们的嫉妒， 用愚昧的国民激起他们的怒气。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","我的怒火已经点燃， 要烧到阴间的尽头， 吞灭大地及其出产， 甚至烧毁山的根基。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","“‘我要使灾祸连连临到他们， 我的箭都射向他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","他们必饱受饥荒之苦， 被瘟疫和灾祸吞噬， 被猛兽和毒蛇袭击。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","外有刀剑杀戮， 内有恐惧笼罩， 男女老幼无不丧命。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","我本要消灭他们， 使世人忘记他们； ");
INSERT INTO cmncbs_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","但我怕敌人夸口， 误以为这是他们的胜利， 而非我的作为。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","“以色列人愚昧无知，毫无见识。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","如果他们有智慧， 就能明白这一切， 知道自己的结局。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","若不是他们的磐石卖掉他们， 若不是耶和华抛弃他们， 一人怎能赶散他们千人？ 二人怎能击溃他们万人？ ");
INSERT INTO cmncbs_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","我们的敌人也承认他们的磐石不如我们的磐石。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","他们犹如来自所多玛、 长在蛾摩拉的葡萄树， 结的葡萄粒粒有毒，串串苦涩； ");
INSERT INTO cmncbs_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","酿的酒如蛇的毒液， 如眼镜蛇的毒液。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","“祂说，‘我把这一切积存起来， 封在我的仓库里。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","申冤在我，我必报应， 到时候他们必站不住脚， 他们遭祸的日子近了， 他们的末日快要来了。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","“耶和华见自己的子民力量衰竭， 奴隶和自由人所剩无几， 必为他们主持公道， 怜悯祂的仆人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","祂必说，‘你们的神明在哪里？ 庇护你们的磐石在哪里？ ");
INSERT INTO cmncbs_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","它们吃你们祭牲的脂肪， 喝你们的奠酒。 让它们起来帮助你们， 庇护你们吧！ ");
INSERT INTO cmncbs_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","“‘你们现今要知道， 唯有我是上帝； 除我之外，别无他神。 我掌管生死，我打伤、我医治； 无人能逃出我的掌心。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","我向天伸手， 凭我的永恒起誓， ");
INSERT INTO cmncbs_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","我要磨快闪亮的剑， 主持公道，报应仇敌， 惩罚恨我的人。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","我要使我的箭饱饮鲜血， 就是被杀被掳之人的血； 我的剑要吞噬人肉， 就是敌人将领的肉。’ ");
INSERT INTO cmncbs_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","“列邦啊， 你们当与祂的子民一同欢乐！ 因为祂要为自己的仆人报血仇， 报应祂的仇敌， 洁净祂的土地和子民。” ");
INSERT INTO cmncbs_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","摩西和嫩的儿子约书亚把这首诗歌读给会众听。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","读完后，摩西又对以色列人说： ");
INSERT INTO cmncbs_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","“要谨记我今天警告你们的话，要吩咐你们的子孙谨遵这律法上的一切话。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","这律法不是空话，而是你们的生命。你们若遵守这律法，就必长住在约旦河西岸你们将要占领的土地上。” ");
INSERT INTO cmncbs_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","当天，耶和华对摩西说： ");
INSERT INTO cmncbs_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“你去耶利哥对面的摩押，登上亚巴琳山区的尼波山，观看我要赐给以色列人作产业的迦南。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","之后，你会死在那山上，归到你祖先那里，如你哥哥亚伦在何珥山离世归祖一样。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","因为在荀旷野，在加低斯的米利巴泉旁，你和亚伦对我不忠，没有在以色列人中尊我为圣。 ");
INSERT INTO cmncbs_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","所以，你只能远远地观看我要赐给以色列人的土地，却不能进去。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","以下是上帝的仆人摩西临终时给以色列人的祝福： ");
INSERT INTO cmncbs_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","“耶和华从西奈山来， 从西珥山向我们显现， 祂从巴兰山发出光辉； 祂带着千万圣者来临， 祂右边有闪耀的光芒。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","祂深爱自己的子民， 众圣者都听命于祂， 伏在祂的脚前， 领受祂的训诲。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","摩西将律法颁布给我们， 作为雅各子孙的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","百姓的众首领齐聚， 以色列各支派集合之时， 耶和华在耶书仑做王。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","摩西祝福吕便支派说： “尽管吕便人数稀少， 愿他存活，不致灭没。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","摩西祝福犹大支派说： “耶和华啊， 求你听犹大人的呼求， 带他们回归本族， 出手为他们争战， 帮他们对抗仇敌。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","摩西祝福利未支派说： “耶和华啊， 求你把土明和乌陵赐给虔诚的利未人， 你曾经在玛撒试验他们， 在米利巴泉边与他们争论。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","为了听从你的话，遵守你的约， 他们不顾父母， 舍弃弟兄，抛下儿女。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","他们把你的典章传授给雅各， 把你的律法传授给以色列； 他们要把香献在你面前， 把全牲燔祭献在你的坛上。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","耶和华啊， 求你赐他们力量， 悦纳他们的工作， 击碎仇敌的腰杆， 使敌人一蹶不振。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","摩西祝福便雅悯支派说： “耶和华所爱的人， 安居在祂身边， 安居在祂怀中， 终日蒙祂庇护。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","摩西祝福约瑟家族说： “愿他们的土地蒙耶和华赐福， 得天上的甘霖， 及地下的泉源； ");
INSERT INTO cmncbs_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","得日月之辉，物产丰美； ");
INSERT INTO cmncbs_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","得古老群山之精华， 永存丘陵之富饶； ");
INSERT INTO cmncbs_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","得大地的丰肥， 蒙荆棘火中之上帝的恩宠。 愿这些福气落在约瑟头上， 临到弟兄中的王者身上。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","约瑟威武如头生的公牛， 有野牛的角， 他用角抵万邦， 直到地极。 他的两角是数以万计的以法莲人和数以千计的玛拿西人。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","摩西祝福西布伦和以萨迦支派说： “愿西布伦人欣然外出， 愿以萨迦人在帐篷中欢喜。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","他们要招聚众人上山， 一同献上公义的祭； 他们汲取海里的财富和沙中的宝藏。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","摩西祝福迦得支派说： “扩张迦得疆界的那位当受称颂！ 迦得蹲伏如母狮， 撕碎头颅和臂膀。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","他为自己选了最好的土地， 是留给首领的那份。 他与众首领同行， 施行耶和华的公义和祂给以色列的典章。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","摩西祝福但支派说： “但像一只从巴珊跃出的幼狮。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","摩西祝福拿弗他利支派说： “拿弗他利人啊， 你们饱尝耶和华的恩宠， 满得祂的赐福， 拥有西方和南方的土地。” ");
INSERT INTO cmncbs_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","摩西祝福亚设支派说： “愿亚设在众子中最蒙福， 受众弟兄的恩待， 双脚沐浴橄榄油， ");
INSERT INTO cmncbs_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","城门有铜锁铁闩， 一生都充满力量。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","“耶书仑啊， 上帝独一无二， 祂驰骋诸天，前来助你， 穿越长空，充满威严。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","亘古的上帝是你的庇护， 祂永恒的臂膀是你的依托。 祂赶走你面前的仇敌， 下令毁灭他们。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","以色列安然居住， 雅各独居一处， 那里盛产五谷新酒， 有天上的雨露滋润。 ");
INSERT INTO cmncbs_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","以色列啊，你多么有福！ 蒙耶和华拯救之人啊，谁能像你？ 祂是你的盾牌，你得胜的宝剑。 敌人要向你屈服，被你践踏。” ");
INSERT INTO cmncbs_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","摩西从摩押平原登上尼波山，上到耶利哥对面的毗斯迦山顶。耶和华把整片土地指给他看，从基列一直到但， ");
INSERT INTO cmncbs_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","拿弗他利全境，以法莲和玛拿西地区，远至地中海的犹大全境， ");
INSERT INTO cmncbs_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","南地和棕榈城耶利哥的谷地，远至琐珥。 ");
INSERT INTO cmncbs_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","耶和华对摩西说：“这便是我向亚伯拉罕、以撒和雅各起誓要赐给他们子孙的土地。现在我让你亲眼看到了，但你不能进入。” ");
INSERT INTO cmncbs_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","于是，耶和华的仆人摩西死在摩押，正如耶和华所言。 ");
INSERT INTO cmncbs_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","耶和华把他安葬在摩押境内伯·毗珥对面的山谷，至今无人知道摩西的坟墓在哪里。 ");
INSERT INTO cmncbs_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","摩西去世时一百二十岁，眼睛没有昏花，精力没有衰败。 ");
INSERT INTO cmncbs_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","以色列人在摩押平原为摩西致哀三十天，服丧的日子才结束。 ");
INSERT INTO cmncbs_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","嫩的儿子约书亚充满了智慧之灵，因为摩西曾把手按在他身上。以色列人都听从他，遵守耶和华对摩西的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","此后，以色列再也没有出现像摩西那样的先知，他曾面见耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","奉耶和华的命令在埃及行神迹奇事，惩罚法老及其臣仆和国民， ");
INSERT INTO cmncbs_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","在以色列人面前行伟大而可畏的事。");
INSERT INTO cmncbs_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","耶和华的仆人摩西死了以后，耶和华对摩西的助手——嫩的儿子约书亚说： ");
INSERT INTO cmncbs_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“我的仆人摩西已经死了，你和全体以色列人现在要准备渡过约旦河，到我要赐给你们的地方去。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","我已把你们脚掌将踏之地都赐给了你们，正如我对摩西的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","从南部的旷野直到北部的黎巴嫩，从东部的幼发拉底大河直到西部的地中海，包括赫人居住的全境，都将是你们的领土。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","在你有生之年，没有人能够抵挡你。过去我怎样与摩西同在，也必照样与你同在，我必不离开你，也不丢弃你。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","你要刚强勇敢，因为你要带领这些人占领我起誓要赐给他们祖先的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","你只要刚强勇敢，谨遵我仆人摩西所吩咐你的一切律法，毫不偏离，就可以无往不利。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","你要常常诵读这律法书，昼夜不断地思想，以便谨遵律法书上的一切指示。这样，你必亨通、顺利。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","我再次吩咐你，要刚强勇敢！不要惊慌害怕，因为你无论走到哪里，你的上帝耶和华必与你同在。” ");
INSERT INTO cmncbs_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","于是，约书亚吩咐民众的首领说： ");
INSERT INTO cmncbs_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“你们要走遍全营，吩咐民众预备好食物。因为三天之内，你们就要过约旦河，去占领你们的上帝耶和华赐给你们的土地。” ");
INSERT INTO cmncbs_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","约书亚又对吕便支派、迦得支派和玛拿西半个支派的人说： ");
INSERT INTO cmncbs_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“你们要牢记耶和华的仆人摩西吩咐你们的话，他说你们的上帝耶和华要把这片土地赐给你们，让你们安居。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","你们的妻子儿女和牲畜可以留在约旦河东岸摩西分给你们的土地上，但你们当中所有的勇士要带着兵器先过约旦河，帮助你们的弟兄。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","要等到你们的上帝耶和华使你们的弟兄像你们一样得到祂所赐的土地，安居以后，你们才可以回到约旦河东日出之地，在耶和华的仆人摩西分给你们的土地上定居。” ");
INSERT INTO cmncbs_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","他们回答约书亚说：“凡你命令我们的，我们一定遵行。无论你派我们去哪里，我们一定去。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","我们在一切事上怎样服从摩西，也必照样服从你，唯愿你的上帝耶和华与你同在，像与摩西同在一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","任何人违抗你的命令，不悉数遵行你的吩咐，都要被处死。你要刚强勇敢！” ");
INSERT INTO cmncbs_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","嫩的儿子约书亚暗中从什亭派出两个探子，去侦察那片土地，特别是耶利哥的情况。他们进到一个名叫喇合的妓女家中，就住在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","有人告诉耶利哥王说：“今晚有以色列人来这里刺探。” ");
INSERT INTO cmncbs_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","耶利哥王便派人到喇合那里，对她说：“把来到你家里的人交出来，因为他们是来刺探这地方的。” ");
INSERT INTO cmncbs_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","但喇合已经把二人藏起来了，她答道：“不错，他们来过，可是我不知他们是从哪里来的。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","天黑要关城门的时候，他们就离开了，我不知道他们去哪里了。你们快去追吧，还可以追上。” ");
INSERT INTO cmncbs_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","其实喇合已经把二人带到屋顶上，藏在那里的麻秆堆里了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","追捕的人便沿着通往约旦河渡口的路追去，他们一出城，城门便关闭了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","在两个探子睡觉前，喇合上到屋顶对他们说： ");
INSERT INTO cmncbs_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","“我知道耶和华已经把这地方赐给你们，我们对你们充满恐惧。这里所有的居民都吓得胆战心惊。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","因为你们离开埃及过红海的时候，耶和华怎样使红海在你们面前成为干地，你们怎样对付约旦河东的两个亚摩利王西宏和噩，把他们彻底消灭，我们都听说了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","我们听了这些事，感到心惊胆战、勇气尽失。你们的上帝耶和华是天地万物的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","我既然恩待了你们，现在请你们凭耶和华向我起誓，你们同样会恩待我家，并且给我一个可靠的凭据， ");
INSERT INTO cmncbs_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","保证放过我的父母、兄弟、姊妹和他们所有的亲人，救我们脱离死亡。” ");
INSERT INTO cmncbs_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","二人便对她说：“只要你不泄露我们的事，我们愿意用性命担保，当耶和华把这地方赐给我们的时候，我们一定守信善待你。” ");
INSERT INTO cmncbs_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","喇合的房子就在城墙边，她就住在城墙上，于是她用绳子把二人从窗口缒下去， ");
INSERT INTO cmncbs_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","并对他们说：“你们往山上去，免得被追捕的人发现。你们要在那里躲三天，等追捕的人回城后再走。” ");
INSERT INTO cmncbs_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","二人对她说：“要让我们信守誓言，你必须这样做： ");
INSERT INTO cmncbs_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","我们来攻占这座城的时候，你要把这条朱红色绳子系在缒我们下去的窗户上，并且把你的父母、兄弟、姊妹和他们的亲人都召集到你家里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","倘若有人离开这房子跑到街上遭遇不测，我们不负任何责任。我们一定保证屋内所有人的性命安全。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","如果你泄露我们的事，你要我们起的誓也就作废了。” ");
INSERT INTO cmncbs_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","喇合说：“一言为定！”于是她送走他们，把朱红色的绳子系在窗户上。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","二人到山上躲藏了三天，等追捕的人回去。追捕的人沿途搜索，毫无所获，便回去了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","二人便下山，过河回到嫩的儿子约书亚那里，向他禀告整个经过， ");
INSERT INTO cmncbs_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","又说：“耶和华确实将那整片土地交给我们了，那里的居民听到我们的消息，都吓得胆战心惊。” ");
INSERT INTO cmncbs_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","约书亚清早起来，率领全体以色列人离开什亭，来到约旦河边安营，等候过河。 ");
INSERT INTO cmncbs_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","过了三天，官长走遍各营，吩咐民众说： ");
INSERT INTO cmncbs_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","“你们看见做祭司的利未人抬着你们上帝耶和华的约柜出发时，就要起身跟在后面。 ");
INSERT INTO cmncbs_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","这样，你们就会知道路，因为你们从来没有走过这条路。但你们要跟约柜保持九百米的距离，不要走近约柜。” ");
INSERT INTO cmncbs_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","约书亚又对民众说：“你们要洁净自己，因为明天耶和华要在你们当中行奇事。” ");
INSERT INTO cmncbs_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","约书亚又对祭司说：“抬起约柜，率领民众过河吧！”他们就抬起约柜，走在民众前面。 ");
INSERT INTO cmncbs_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","耶和华对约书亚说：“从今天开始，我要使你在以色列人面前得到尊荣，让他们知道我与你同在，正如从前我跟摩西同在一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","你要吩咐抬约柜的祭司走到约旦河边，站在水中。” ");
INSERT INTO cmncbs_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","约书亚对以色列人说：“你们要来听你们的上帝耶和华的话。 ");
INSERT INTO cmncbs_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","今天你们会明白永活的上帝就在你们当中，祂必在你们面前赶走迦南人、赫人、希未人、比利洗人、革迦撒人、亚摩利人和耶布斯人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","看啊，天下之主的约柜要在你们前面过约旦河。 ");
INSERT INTO cmncbs_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","现在，你们要从以色列的十二支派中选出十二个人来，每支派选一人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","当祭司抬着天下之主耶和华的约柜一踏进约旦河，往下流的河水必止住，形成一道水堤。” ");
INSERT INTO cmncbs_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","那时是收割的季节，河水高涨，淹没两岸。民众拔营准备过河，抬约柜的祭司走在前头。祭司的脚刚一踏进河水， ");
INSERT INTO cmncbs_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","往下流的水立刻止住了，在很远的撒拉但附近的亚当城那里涨成一道水墙。流入亚拉巴海，即盐海的水完全被截断了，民众便走到对面的耶利哥。 ");
INSERT INTO cmncbs_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","以色列人过河的时候，抬耶和华约柜的祭司站在河中间的干地上，直到所有人都从干地上过了约旦河。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","民众都过河之后，耶和华对约书亚说： ");
INSERT INTO cmncbs_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“你去从民众中选出十二个人，每支派选一人， ");
INSERT INTO cmncbs_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","吩咐他们从约旦河床祭司站立的地方取十二块石头，放在你们今晚住宿的地方。” ");
INSERT INTO cmncbs_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","约书亚便召来他从以色列人中选的十二个人，每支派一人，对他们说： ");
INSERT INTO cmncbs_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","“从你们上帝耶和华的约柜前过去，到约旦河中间，以色列每个支派中有一人扛一块石头回来，一共十二块， ");
INSERT INTO cmncbs_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","留在你们中间作记号。以后，倘若你们的子孙问你们，‘这些石头是什么意思？’ ");
INSERT INTO cmncbs_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","你们就告诉他们，‘约旦河水在耶和华的约柜前曾经被截断，当约柜过河的时候，河水被截断了。这些石头要在以色列人当中作为永久的纪念。’” ");
INSERT INTO cmncbs_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","以色列人遵行了约书亚的吩咐。他们按以色列人支派的数目，从约旦河中取了十二块石头，搬来放在住宿的地方，正如耶和华对约书亚的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","约书亚又在约旦河床抬约柜的祭司站立的地方立了十二块石头。石头至今还在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","抬约柜的祭司站在约旦河中间，一直站到耶和华吩咐约书亚交待民众做的每一件事都完成了，正如摩西对约书亚的吩咐。民众迅速过了河。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","所有人都过河以后，祭司才抬着耶和华的约柜在民众注视下过了河。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","吕便支派、迦得支派和玛拿西半个支派的人照摩西从前的嘱咐，带着兵器走在以色列人前面。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","大约有四万武装好的以色列人在耶和华面前过了河，前往耶利哥平原，准备作战。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","那一天，耶和华在以色列众人面前提升约书亚，在他有生之年，他们像敬畏摩西一样敬畏他。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","耶和华对约书亚说： ");
INSERT INTO cmncbs_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“你去吩咐抬约柜的祭司从约旦河里上来。” ");
INSERT INTO cmncbs_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","约书亚便吩咐他们从约旦河里上来。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","抬耶和华约柜的祭司从河床上来，脚刚一踏上岸，约旦河的水立刻恢复原状，像以往一样涨过两岸。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","那天是一月十日。以色列人从约旦河上来后，就在耶利哥东边的吉甲扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","约书亚把从约旦河取来的十二块石头立在吉甲， ");
INSERT INTO cmncbs_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","并对以色列人说：“以后，你们的子孙问你们这堆石头是什么意思， ");
INSERT INTO cmncbs_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","你们就告诉他们，‘这是代表以色列人曾走干地穿过约旦河。’ ");
INSERT INTO cmncbs_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","因为你们的上帝耶和华使约旦河成为干地、让你们穿过，就像祂从前使红海成为干地、让我们穿过一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","这是要让天下万民都知道耶和华的手大有能力，要让你们永远敬畏你们的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","在约旦河西岸一带的亚摩利众王和沿海一带的迦南众王，听说耶和华使约旦河成为干地、让以色列人穿过，都吓得胆战心惊，勇气尽失。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","那时，耶和华对约书亚说：“你要制作火石刀，再次给以色列人行割礼。” ");
INSERT INTO cmncbs_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","约书亚便制作火石刀，在割礼山给以色列人行了割礼。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","约书亚给他们举行割礼，是因为所有从埃及出来、能够作战的男子之后都死在旷野的路上。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","从埃及出来的男子都受过割礼，而后来在旷野的路上出生的以色列人都没有受过割礼。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","以色列人在旷野飘泊了四十年，直到从埃及出来可以作战的男子都死了为止，因为他们不听从耶和华的话。耶和华曾向他们祖先起誓，要把奶蜜之乡赐给他们，但后来祂向他们起誓，不让他们看见那片土地。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","耶和华立他们的子孙代替他们。这些人没有受过割礼，因为在路上没有为他们行过割礼，约书亚就为他们行了割礼。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","全体民众受了割礼后，都留在自己的营内，直到康复为止。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","耶和华对约书亚说：“今天我除去了你们在埃及受的羞辱。”因此，那地方叫吉甲，沿用至今。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","以色列人都在耶利哥平原上的吉甲扎营，并于一月十四日傍晚在那里守逾越节。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","逾越节次日他们就吃当地的出产，包括无酵饼和烤麦穗。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","他们吃了当地出产后的第二天，吗哪便不再降下，以色列人再没有吗哪吃了。那一年他们开始吃迦南的出产。 ");
INSERT INTO cmncbs_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","约书亚走近耶利哥，举目看见一个人站在他面前，手里拿着拔出来的剑。约书亚上前去问道：“你是来帮助我们的，还是来帮助我们敌人的？” ");
INSERT INTO cmncbs_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","那人答道：“都不是，我来是做耶和华军队的统帅。”约书亚就俯伏下拜说：“我主，有什么话要吩咐仆人？” ");
INSERT INTO cmncbs_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","耶和华军队的统帅对约书亚说：“把你脚上的鞋脱下！因为你站的地方是圣洁的。”约书亚便把鞋脱下来。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","因为害怕以色列人，耶利哥城门紧闭，无人出入。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","耶和华对约书亚说：“看啊，我已经把耶利哥及其王和英勇的战士都交在你手中了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","所有军队要每天绕城一圈，连续六天， ");
INSERT INTO cmncbs_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","让七个祭司拿着七个羊角号走在约柜前面。到了第七天，你们要绕城七圈，祭司要吹响号角。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","当你们听到号角长鸣时，所有人都要高声呐喊，城墙就会坍塌，众人便可以直冲上去。” ");
INSERT INTO cmncbs_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","嫩的儿子约书亚便召来祭司，对他们说：“你们抬起约柜，派七位祭司拿着七个羊角号走在耶和华的约柜前面。” ");
INSERT INTO cmncbs_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","他又对民众说：“你们要前去绕着城墙走，军队要走在耶和华的约柜前面。” ");
INSERT INTO cmncbs_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","约书亚吩咐完毕，七个祭司便在耶和华面前拿着羊角号边走边吹，耶和华的约柜就跟在他们后面， ");
INSERT INTO cmncbs_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","军队走在吹号的祭司前面，殿后军队跟在约柜后面。祭司一路上吹着号角。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","约书亚吩咐民众：“我哪天叫你们呐喊，你们再呐喊。在此之前，不许作声，一句话也不许说。” ");
INSERT INTO cmncbs_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","这样，约书亚让人抬着耶和华的约柜绕城一圈，然后众人各自回营过夜。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","第二天，约书亚一早起来，祭司又抬起耶和华的约柜。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","七个祭司拿着七个羊角号走在耶和华的约柜前面，一边走一边吹号。军队走在祭司前面，殿后军队跟在耶和华的约柜后面，伴随着持续不断的号角声。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","这一天他们又绕城一圈，然后各自回营。六天都是这样。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","第七天黎明时分，他们起来照样绕城，只是这一天他们绕城七次。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","绕到第七次，祭司吹响了号角，约书亚吩咐民众说：“呐喊吧！因为耶和华已经将这城交给你们了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","要把这座城和城里所有的东西毁灭，作为献给耶和华之物。只有妓女喇合和她家中所有的人可以活命，因为她曾把我们派去的探子隐藏起来。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","你们要小心，不可私拿任何应当毁灭的东西，免得你们自取灭亡，并使以色列全营遭受灭顶之灾。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","所有金银和铜铁器皿都是耶和华的圣物，要放进耶和华的库房。” ");
INSERT INTO cmncbs_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","于是，民众呐喊，号角响起，当民众伴随着号角声高声呐喊时，城墙坍塌了。民众便一拥而上，占领了耶利哥城， ");
INSERT INTO cmncbs_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","用刀杀了城里所有的男女老少、牛羊和驴。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","约书亚对那两个探子说：“你们到那个妓女家里，照着你们向她起过的誓，把她和她的家人都带出来。” ");
INSERT INTO cmncbs_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","于是，那两个年轻探子便进去，把喇合和她的父母、兄弟及所有的亲人都带出来，安置在以色列人的营外。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","以色列人烧毁全城和城内的一切，只把金银和铜铁器皿放在耶和华的库房里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","约书亚因为妓女喇合把两个派到耶利哥的探子隐藏起来，就饶了她和她一家人的性命。他们至今仍住在以色列人当中。 ");
INSERT INTO cmncbs_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","之后，约书亚起誓说： “重建耶利哥城的人必定在耶和华面前受咒诅， 他立地基的时候必死长子， 建城门的时候必丧幼子。” ");
INSERT INTO cmncbs_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","耶和华与约书亚同在，他的声名传遍整个地方。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","以色列人在当毁灭之物的事上犯了罪。因为犹大支派中谢拉的曾孙、撒底的孙子、迦米的儿子亚干拿了一些本该毁灭之物，耶和华便向以色列人发怒。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","当时，约书亚从耶利哥派人去伯特利东边靠近伯·亚文的艾城，并吩咐道：“你们去侦察那地方。”那些人便上去侦察艾城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","他们侦察回来后对约书亚说：“那里的居民很少，我们不必全军出动，只要派两三千人上去便可以攻取艾城，不必劳师动众。” ");
INSERT INTO cmncbs_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","于是，大约有三千以色列人去攻打艾城，不料却被艾城人击溃。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","艾城的人杀了他们三十六人，从城门前追杀他们，一直到示巴琳，在下坡处杀败他们。以色列人吓得心惊胆战。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","约书亚和以色列的长老便撕裂衣服，把灰撒在头上，俯伏在耶和华的约柜面前，直到晚上。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","约书亚说：“唉！主耶和华啊，你为什么把我们带过约旦河，交给亚摩利人毁灭呢？倒不如让我们住在约旦河东岸！ ");
INSERT INTO cmncbs_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","主啊，现在以色列人被仇敌打败，我还有什么话可说呢？ ");
INSERT INTO cmncbs_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","迦南人和这一带的人听到这消息以后，必从四面八方来围攻我们，将我们从地上斩尽杀绝。那时候，你的大名怎么办呢？” ");
INSERT INTO cmncbs_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","耶和华对约书亚说：“起来吧！你为何俯伏在地？ ");
INSERT INTO cmncbs_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","以色列人犯了罪，违背了我吩咐他们应守的约，拿了本该毁灭之物放在自己的行囊里，又偷窃又撒谎。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","所以，以色列人无法抵挡敌人，掉头败逃，因为他们已成当毁之物。你必须将那些本该毁灭之物从你们中间除掉，不然我就不再与你们同在。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","起来吧！去吩咐民众洁净自己，让他们为明天洁净自己，因为以色列的上帝耶和华这样说，‘以色列啊！你们中间有当毁之物，你们不除掉它们就无法抵挡敌人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","明天早上，你们要按支派一个一个前来，耶和华指出哪个支派，哪支派的各宗族便要前来。耶和华指出哪个宗族，哪宗族的各家族便要前来。耶和华指出哪个家族，哪家族的各成员便要前来。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","哪个人被指出拿了本该毁灭之物，哪个人及其所有的东西就要被火焚烧。因为他违背了耶和华的约，在以色列人中做了可耻的事。’” ");
INSERT INTO cmncbs_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","第二天清早，约书亚按照支派召来以色列人，结果抽中犹大支派； ");
INSERT INTO cmncbs_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","他让犹大支派各宗族前来，结果抽中谢拉宗族；他让谢拉宗族前来，结果抽中撒底家族； ");
INSERT INTO cmncbs_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","他让撒底家族的人一个一个前来，结果抽中犹大支派中谢拉的曾孙、撒底的孙子、迦米的儿子亚干。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","约书亚对亚干说：“孩子啊，我劝你把荣耀归给以色列的上帝耶和华，向祂认罪，把你所做的事告诉我，不要隐瞒。” ");
INSERT INTO cmncbs_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","亚干答道：“我的确得罪了以色列的上帝耶和华。事情是这样的， ");
INSERT INTO cmncbs_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","在夺得的财物中，我看上了一件漂亮的示拿外衣、四十五两银子和十两金子，我一时贪心便拿去了，藏在我帐篷的地底下，银子就放在衣服下面。” ");
INSERT INTO cmncbs_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","约书亚派人跑到他帐篷里，果然那件外衣藏在他帐篷里，银子在衣服下面。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","他们从帐篷里取出这些东西，将它们带到约书亚和全体民众那里，摆在耶和华面前。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","约书亚和全体以色列人把谢拉家族的亚干、那些银子、衣服和金子及其儿女、牛、驴、羊、帐篷和一切所有都带到亚割谷。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","约书亚对亚干说：“你为什么给我们惹祸呢？耶和华今天要降祸给你。”于是，以色列人便拿石头打死了他及其一切，将他们烧毁。 ");
INSERT INTO cmncbs_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","他们在亚干身上堆起一大堆石头，那些石头今天还在。耶和华这才息怒，因此那地方至今还叫亚割谷。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","耶和华对约书亚说：“不要惊慌害怕。只管率领全军去攻打艾城，我已经将艾城的王、他的人民、城池和土地都交在你手里了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","你怎样对待耶利哥和耶利哥王，也要照样对待艾城和艾城的王。不过你们可以拿城中的财物和牲畜。你要在城后设下伏兵。” ");
INSERT INTO cmncbs_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","于是，约书亚率领全军前往艾城。他挑选了三万精兵，派他们在黑夜出发， ");
INSERT INTO cmncbs_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","并吩咐他们说：“你们要在城后埋伏，不可离城太远，全体保持戒备。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","我会率领军队正面攻城，当敌人像上次那样出城应战时，我们便逃跑。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","他们必定乘胜追击，我们便引他们离城，因为敌人一定会以为我们又像上次一样临阵逃跑。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","那时，你们便从埋伏的地方冲出来攻占艾城，你们的上帝耶和华一定会把艾城交在你们手里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","你们攻陷艾城后，要照耶和华的话放火焚城。这是我的命令。” ");
INSERT INTO cmncbs_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","于是，约书亚派遣他们出去。他们去埋伏在伯特利和艾城之间，就是艾城的西面。那一夜，约书亚住在民众当中。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","清早，约书亚召集民众，与以色列的众首领率全军前往艾城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","随他同去的军队都向前推进，来到城外，在城的北面扎营，与艾城相隔一个山谷。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","约书亚选了五千人，让他们埋伏在艾城和伯特利之间，就是艾城的西面。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","于是，城北的主力军队和城西的伏兵都部署好了。当晚，约书亚在山谷里过夜。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","艾城的王见以色列人兵临城下，清早便急忙和全城的人起来出城迎战，在亚拉巴谷附近跟以色列军交锋，他不知道城后有伏兵。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","约书亚带领以色列军诈败，沿着通往旷野的路逃跑。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","艾城的人都被召去追赶以色列人，他们追击约书亚，被诱出城来。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","这样，伯特利和艾城的人倾巢而出，追杀以色列人，他们的城门大开。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","耶和华对约书亚说：“把你手中的矛指向艾城，因为我要将这城交在你手里。”约书亚就把手中的矛指向艾城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","他一伸手，城后的伏兵立即行动，迅速冲进城去，一举占领艾城，随即放火烧城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","艾城的人回头发现城内烟气冲天，却无路可逃，因为那些逃往旷野的以色列人已掉头攻击他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","约书亚和以色列全军见伏兵已经占领艾城，城中浓烟滚滚，便掉头攻击艾城的人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","伏兵也出城追击艾城的人。以色列军前后夹攻，把敌人围困在中间全部歼灭，无一漏网。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","他们生擒了艾城的王，将他押到约书亚那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","以色列军在田间和旷野用刀杀尽了追赶他们的艾城人后，又进城杀了留在城里的人， ");
INSERT INTO cmncbs_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","当天被杀的艾城人男男女女共有一万二千人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","一直到艾城所有的人都被杀光了，约书亚才收回手中的矛。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","以色列人照耶和华对约书亚的吩咐，只带走了城中的牲畜和财物。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","约书亚烧毁全城，使城永远成为一堆废墟，至今仍一片荒凉。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","约书亚又将艾城王的尸体挂在树上示众。黄昏时，他才吩咐人把尸体取下来扔在城门口，又在尸体上堆了一大堆石头。石堆至今还在。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","31","约书亚照耶和华的仆人摩西对以色列人的吩咐，在以巴路山上为以色列的上帝耶和华筑了一座祭坛。这坛是按照摩西律法书的记载，用未经铁器凿过的原石筑的。以色列人就在这坛上把燔祭和平安祭献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","约书亚又在众人面前，将摩西所写的律法刻在石头上。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","所有以色列人与他们的长老、官员和审判官都站在耶和华的约柜两旁，面对着抬约柜的利未祭司，寄居的外族人和本族人都在场。他们一半人站在基利心山前，一半人站在以巴路山前，正如耶和华的仆人摩西从前祝福他们时所吩咐的。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","随后，约书亚按照摩西律法书的记载，向民众宣读一切祝福和咒诅的话。 ");
INSERT INTO cmncbs_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","他在全体会众，包括妇女、小孩以及住在他们中间的外族人面前，一字不漏地宣读摩西的一切吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","住在约旦河西的山区、丘陵以及地中海沿岸、远至黎巴嫩的诸王，就是那些赫人、亚摩利人、迦南人、比利洗人、希未人和耶布斯人的王听说这件事， ");
INSERT INTO cmncbs_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","就联合起来对抗约书亚和以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","基遍的居民听说约书亚在耶利哥和艾城所做的事， ");
INSERT INTO cmncbs_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","便想出一个诡计来。他们装作特使，把旧皮袋和缝补过的酒囊驮在驴背上， ");
INSERT INTO cmncbs_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","穿着缝补过的旧鞋和破烂衣服，带着又干又发霉的饼， ");
INSERT INTO cmncbs_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","到吉甲营去见约书亚。他们对约书亚和以色列人说：“我们从很远的地方来，求你们跟我们缔结盟约。” ");
INSERT INTO cmncbs_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","以色列人对这些希未人说：“你们也许就住在附近。我们怎么能跟你们缔结盟约呢？” ");
INSERT INTO cmncbs_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","他们对约书亚说：“我们是你的奴仆。”约书亚说：“你们是什么人？从哪里来？” ");
INSERT INTO cmncbs_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","他们答道：“仆人们因为你的上帝耶和华的大名，才从很远的地方来。我们听说了祂在埃及的一切作为， ");
INSERT INTO cmncbs_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","以及祂怎样对付约旦河东的两个亚摩利王——希实本王西宏和亚斯她录的巴珊王噩。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","我们的长老和民众就派我们带着干粮来迎接你们，甘做你们的仆人，希望跟你们缔结盟约。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","我们出来的时候带的饼是热的，看啊，现在又干又发霉了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","这些皮酒囊原来也是新的，但现在已经破了。因为长途跋涉，我们的衣服和鞋也都破旧不堪了。” ");
INSERT INTO cmncbs_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","以色列人接受了他们的食物，却没有求问耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","约书亚与他们立了和平盟约，容他们存活，会众的首领也向他们起誓守约。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","立约三天后，以色列人才得知他们原来是邻居，就住在附近。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","以色列人启程，走了三天来到他们居住的基遍、基非拉、比录和基列·耶琳各城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","会众的首领曾凭以色列的上帝耶和华向他们起过誓，所以不能杀他们。全体会众因此向首领大发怨言。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","首领便对全体会众说：“我们曾凭以色列的上帝耶和华向他们起誓，我们现在不能动他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","我们要容他们存活，免得我们因违背誓言而惹耶和华发怒。” ");
INSERT INTO cmncbs_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","首领又说：“就容他们存活吧。”首领就叫他们为全体会众劈柴挑水。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","于是，约书亚召来他们，对他们说：“你们为什么要欺骗我们，说你们住得很远？其实你们就住在附近。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","因此，你们是受咒诅的。你们要永远做奴仆，为我上帝的殿劈柴挑水。” ");
INSERT INTO cmncbs_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","他们答道：“仆人们这样做是因为害怕丧命。我们确实听说你的上帝耶和华曾经应许祂仆人摩西，要把这整片土地都赐给你们，并从你们面前将这里的居民杀尽。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","现在我们既然落在你的手中，你们想怎样对待我们就怎样对待吧。” ");
INSERT INTO cmncbs_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","约书亚不让以色列人加害他们，因此他们没有被杀死。 ");
INSERT INTO cmncbs_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","那天，约书亚让他们在耶和华指定的地方，为会众和耶和华的祭坛劈柴挑水。他们至今仍做这样的工作。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","耶路撒冷王亚多尼·洗德听说约书亚夺取并毁灭了艾城，像对付耶利哥和耶利哥王一样对付艾城和艾城的王，又听说基遍人已经跟以色列人缔结盟约，住在他们中间， ");
INSERT INTO cmncbs_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","便大为惊恐。因为基遍是一座大城，宏伟得像座都城，比艾城更大，城中的人都骁勇善战。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","耶路撒冷王亚多尼·洗德便派遣使者去见希伯仑王何咸、耶末王毗兰、拉吉王雅非亚和伊矶伦王底璧，说： ");
INSERT INTO cmncbs_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“求你们上来帮助我攻打基遍，因为这城已经与约书亚和以色列人缔结盟约。” ");
INSERT INTO cmncbs_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","于是，五位亚摩利王，就是耶路撒冷王、希伯仑王、耶末王、拉吉王和伊矶伦王，便联合起来，率领他们所有的军队在基遍附近扎营，攻打基遍。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","基遍人派人去吉甲告诉约书亚说：“住在山区的亚摩利众王正联合起来攻打我们，求你赶快来救我们！不要不顾你的仆人。” ");
INSERT INTO cmncbs_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","于是，约书亚便率领全军，包括所有精兵，从吉甲上去。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","耶和华对约书亚说：“不要害怕，我已经把他们交在你手中，他们没有一人能抵挡你。” ");
INSERT INTO cmncbs_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","约书亚从吉甲出发，连夜赶路，突袭敌人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","耶和华使亚摩利联军阵脚大乱，以色列人就在基遍大败敌军，在去伯·和仑的上坡路上追杀他们，一直追到亚西加和玛基大。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","敌人在从伯·和仑到亚西加的下坡路上逃窜的时候，耶和华降下大冰雹，被冰雹砸死的人比以色列人用刀杀死的还要多。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","耶和华将亚摩利人交在以色列人手中，那天约书亚当众向耶和华祷告： “太阳啊，停在基遍！ 月亮啊，停在亚雅仑谷！” ");
INSERT INTO cmncbs_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","果然太阳停住了， 月亮也不动了， 直到以色列人杀败敌人。 《雅煞珥书》记载了这事。约有一天的时间，太阳停留在天空，没有西沉。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","耶和华这样垂听一个人的祈求是空前绝后的，这是因为耶和华要为以色列争战。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","后来，约书亚率领以色列军返回了吉甲的营地。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","那五王逃进玛基大的山洞里，躲藏起来。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","有人告诉约书亚那五个王藏在玛基大的山洞里， ");
INSERT INTO cmncbs_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","约书亚便下令说：“滚几块大石头堵住洞口，派人看守。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","你们不可停下来，要继续追杀敌人，不要让他们逃回城，你们的上帝耶和华已经把他们交在你们手中了。” ");
INSERT INTO cmncbs_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","约书亚和以色列人把敌人杀得大败，几乎全军覆没，一些残余都逃进了坚固的城垒。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","以色列人都安然无恙地回到约书亚驻扎的玛基大营。再也没有人敢威胁以色列人了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","约书亚说：“打开洞口，把里面的五个王押出来见我。” ");
INSERT INTO cmncbs_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","众人便把耶路撒冷王、希伯仑王、耶末王、拉吉王、伊矶伦王从洞里押出来，带到约书亚面前。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","约书亚召来全体以色列人，然后对那些跟他一起出征的将领说：“你们上前来，用脚踏在这些王的脖子上。”各将领便照着约书亚的吩咐做了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","约书亚对他们说：“你们不要惊慌害怕，要刚强勇敢，因为耶和华要使你们攻打的所有仇敌都落此下场。” ");
INSERT INTO cmncbs_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","随后约书亚将这五个王杀死，把尸体分别挂在五棵树上，直到傍晚。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","日落时，约书亚才下令把尸体放下，扔在他们先前躲藏的山洞里，用大石头堵住洞口，石头至今还在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","约书亚在当天占领了玛基大，把玛基大王和所有的居民都用刀杀了，一个没留。他对待玛基大王跟以前对待耶利哥王一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","约书亚和以色列军又从玛基大出发，去攻打立拿。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","耶和华将立拿城和立拿王交在以色列人手中，他们用刀杀了全城的人，一个没留。他们对待立拿王跟以前对待耶利哥王一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","约书亚和以色列军从立拿前往拉吉，他们在城外扎营，攻打拉吉。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","耶和华将拉吉交在以色列人手中，第二天约书亚便攻占了拉吉，用刀杀了全城的人，就像在立拿所行的一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","基色王何兰前来支持拉吉，结果也被约书亚杀得一个不剩。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","约书亚又率领以色列全军从拉吉前往伊矶伦，在城外扎营，攻打伊矶伦。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","他们当天就攻陷该城，用刀杀了城内所有的人，就像在拉吉所行的一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","约书亚和全体以色列人又从伊矶伦去攻打希伯仑。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","他们攻陷该城及其附属城邑，用刀杀了希伯仑王和城邑中的居民，一个没留，就像在伊矶伦所行的一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","然后，约书亚和全体以色列人再回兵攻打底璧， ");
INSERT INTO cmncbs_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","攻取了该城及其附属城邑，擒获底璧王，用刀杀了城中所有的人，一个没留，就像对待希伯仑、立拿和立拿王一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","这样，约书亚征服了整个地区，包括山区、南地、丘陵和山坡及那里的众王。他按照以色列的上帝耶和华的吩咐，消灭了一切有生命气息的，一个没留。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","约书亚征服了各地，从加低斯·巴尼亚到迦萨，歌珊全境，直到基遍。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","约书亚能一鼓作气杀败诸王，征服他们的土地，都是因为有以色列的上帝耶和华为以色列人争战。 ");
INSERT INTO cmncbs_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","之后，约书亚率领以色列人回到吉甲的营地。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","夏琐王耶宾听见这些消息，就派人去见玛顿王约巴、伸仑王、押煞王， ");
INSERT INTO cmncbs_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","还有北方山区、基尼烈南面的亚拉巴、西部丘陵和多珥高原的各王， ");
INSERT INTO cmncbs_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","以及东西两面的迦南人、山区的亚摩利人、赫人、比利洗人、耶布斯人和黑门山麓米斯巴地区的希未人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","这些王便率领自己的军队，带着许多马匹和战车倾巢出动，人数多如海边的沙。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","他们在米伦河会师，一同扎营，要跟以色列人交战。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","耶和华对约书亚说：“你不要怕他们。明天这个时候，我必把他们全部交给以色列人杀灭，你要砍断他们马匹的蹄筋，烧毁他们的战车。” ");
INSERT INTO cmncbs_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","于是，约书亚率领所有的军兵在米伦河边突袭敌军。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","耶和华把敌军交在以色列人手中，以色列人打败了他们，追杀他们直到西顿大城、米斯利弗·玛音和东面的米斯巴谷，全部消灭了他们，一个没留。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","约书亚照耶和华的吩咐，砍断他们马匹的蹄筋，烧毁他们的战车。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","然后，约书亚回师攻陷夏琐，用刀杀了夏琐王。夏琐曾经在诸国中为首。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","以色列人用刀杀了城内的人，一个没留。约书亚放火烧了夏琐。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","约书亚攻占了诸王所有的城池，擒获诸王。他照耶和华的仆人摩西的吩咐，用刀杀死诸王，毁掉城池。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","以色列人只烧毁了夏琐，没有烧建在山丘上的其他城池。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","他们用刀杀掉城内所有的居民，一个没留，掳掠了城内所有的财物和牲畜。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","耶和华怎样吩咐祂的仆人摩西，摩西也怎样吩咐约书亚，约书亚都一一照办，没有遗漏任何耶和华吩咐摩西的事。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","约书亚占领了整个地区，包括山区、南地、歌珊全境、丘陵、亚拉巴和以色列山区及平原， ");
INSERT INTO cmncbs_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","从哈拉山起到西珥，直到黑门山山麓黎巴嫩山谷的巴力·迦得城。约书亚擒获了各城的王，杀死了他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","约书亚跟这些地区的诸王争战了很久。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","除了基遍的希未人以外，其他没有一城向以色列人求和，以色列人全部攻占这些城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","原来耶和华使他们的心刚硬，跟以色列人作战，好让他们遭受无情的毁灭，正如耶和华对摩西的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","那时，约书亚又出兵把希伯仑、底璧、亚拿伯、以色列和犹大各山区的亚衲人和他们的城邑全部毁灭。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","除了在迦萨、迦特和亚实突有一些残余之外，以色列境内没有亚衲人了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","约书亚照耶和华对摩西的指示，夺取整个地区，把土地按照支派分给以色列人作产业。于是境内国泰民安，没有战事了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","以色列人在约旦河东岸杀死了两个王，占据了他们的领土：自亚嫩谷直到黑门山，包括东面的整个亚拉巴。 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","这两个王一个是住在希实本的亚摩利王西宏。他统辖的地区从亚嫩谷旁的亚罗珥，包括山谷中部和基列的一半，直到亚扪人边境的雅博河。 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","他的领土还包括约旦河谷东部：从加利利湖至亚拉巴海，也就是盐海，到伯·耶施末，直到毗斯迦的山麓。 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","另一个王是巴珊王噩，他原是利乏音的遗民，住在亚斯她录和以得来。 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","他所统辖的地区包括黑门山、撒迦、整个巴珊，直到基述人和玛迦人的边境，还包括基列的另一半，直到希实本王西宏的国界。 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","耶和华的仆人摩西带领以色列人征服了这两个王，并把他们的土地分给吕便支派、迦得支派和玛拿西半个支派的人作产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","约书亚带领以色列人征服了约旦河西的诸王，占领的土地包括从黎巴嫩谷地的巴力·迦得直到西珥的哈拉山。约书亚按以色列的支派把这些土地分给以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","那里有山区、丘陵、河谷、山坡、旷野和南地，就是赫人、亚摩利人、迦南人、比利洗人、希未人、耶布斯人住的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","这些王是耶利哥王、伯特利附近的艾王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","耶路撒冷王、希伯仑王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","耶末王、拉吉王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","伊矶伦王、基色王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","底璧王、基德王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","何珥玛王、亚拉得王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","立拿王、亚杜兰王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","玛基大王、伯特利王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","他普亚王、希弗王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","亚弗王、拉沙仑王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","玛顿王、夏琐王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","伸仑·米仑王、押煞王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","他纳王、米吉多王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","基低斯王、迦密附近的约念王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","多珥山上的多珥王、吉甲的戈印王、 ");
INSERT INTO cmncbs_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","得撒王，共三十一个王。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","约书亚年事已高，耶和华对他说：“你年纪大了，但还有许多地方有待征服， ");
INSERT INTO cmncbs_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","就是非利士人和基述人的全境， ");
INSERT INTO cmncbs_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","即从埃及东面的西曷河直到北面以革伦的边境，这一带都算是迦南，是统治迦萨人、亚实突人、亚实基伦人、迦特人、以革伦人的五个非利士王的地方；南方亚卫人的地方； ");
INSERT INTO cmncbs_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","整个迦南人的地方，从西顿人的米亚拉直到亚摩利人边境的亚弗； ");
INSERT INTO cmncbs_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","迦巴勒人的地方；东部从黑门山山麓的巴力·迦得直到哈马口的整个黎巴嫩。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","我必为以色列人赶走从黎巴嫩到米斯利弗·玛音一带山区的所有西顿人。你只管照我的吩咐，把这些土地分给以色列人作产业， ");
INSERT INTO cmncbs_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","分给其他九个支派和玛拿西半个支派作产业。” ");
INSERT INTO cmncbs_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","玛拿西半个支派和吕便、迦得两支派已经得到耶和华的仆人摩西在约旦河东分给他们的产业： ");
INSERT INTO cmncbs_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","从亚嫩谷旁的亚罗珥起，包括谷中的城，直到底本的整个米底巴平原， ");
INSERT INTO cmncbs_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","以及希实本的亚摩利王西宏统治的各城，直到亚扪的边境。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","此外，还包括基列、基述人和玛迦人的疆域、整个黑门山和直到撒迦的整个巴珊地， ");
INSERT INTO cmncbs_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","以及巴珊王噩的国土。噩曾经在亚斯她录和以得来做王，是仅存的利乏音人。摩西打败了这些人，赶走了他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","以色列人却没有赶走基述人和玛迦人，他们到今天还住在以色列人当中。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","摩西并没有把土地分给利未支派作产业，因为献给以色列的上帝耶和华的火祭就是他们的产业，正如耶和华对他们的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","以下是摩西按宗族分给吕便支派的产业： ");
INSERT INTO cmncbs_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","从亚嫩谷旁边的亚罗珥城、谷中的城和米底巴附近的整个平原， ");
INSERT INTO cmncbs_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","到希实本城和希实本平原的所有城邑，即底本、巴末·巴力、伯·巴力·勉、 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","雅杂、基底莫、米法押、 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","基列亭、西比玛、谷中山丘上的细列·沙辖、 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","伯毗珥、毗斯迦山坡和伯·耶施末， ");
INSERT INTO cmncbs_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","平原的各城邑和亚摩利王西宏的国土。西宏曾在希实本做王，摩西打败了他和他的米甸首领以未、利金、苏珥、户珥和利巴。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","以色列人用刀所杀的人中有比珥的儿子术士巴兰。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","吕便支派的土地以约旦河为界。以上是吕便支派按宗族分到的城邑和村庄。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","以下是摩西按宗族分给迦得支派的土地： ");
INSERT INTO cmncbs_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","雅谢和基列境内所有的城邑；亚扪人的一半领土，直到拉巴附近的亚罗珥； ");
INSERT INTO cmncbs_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","从希实本直到拉抹·米斯巴和比多宁，从玛哈念到底璧的边境； ");
INSERT INTO cmncbs_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","还有谷中的伯亚兰、伯·宁拉、疏割、撒分，就是希实本王西宏国中其余的土地，以约旦河为界，沿东岸直到加利利湖的顶端。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","以上这些城邑、村庄便是迦得支派按宗族所分到的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","以下是摩西按宗族分给玛拿西半个支派的土地： ");
INSERT INTO cmncbs_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","从玛哈念开始，包括整个巴珊，就是巴珊王噩的国土及其境内雅珥的六十座城邑， ");
INSERT INTO cmncbs_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","还有基列的一半和巴珊王噩的两座城亚斯她录和以得来。玛拿西的儿子玛吉的一半子孙按宗族分到这些土地。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","以上是摩西在耶利哥对面约旦河东的摩押平原分给以色列人的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","摩西并没有分给利未支派任何产业，因为以色列的上帝耶和华就是他们的产业，正如耶和华对他们的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","以下是祭司以利亚撒、嫩的儿子约书亚和以色列各支派的首领在迦南分给以色列人的产业， ");
INSERT INTO cmncbs_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","是照耶和华借摩西所指示的，用抽签的方式分给九个半支派的。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","摩西在约旦河东已经把产业分给了吕便、迦得支派和玛拿西半个支派，只是没有把产业分给利未人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","约瑟的子孙已分为玛拿西和以法莲两个支派。利未人没有分到地，但有城邑居住，还有草场可以牧养牲畜，安置财物。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","以色列人照耶和华给摩西的指示分配这些土地。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","那时，犹大支派的人来到吉甲见约书亚，基尼洗族耶孚尼的儿子迦勒对约书亚说：“你知道耶和华在加低斯·巴尼亚跟上帝的仆人摩西提到关于你和我的事。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","我四十岁那年，耶和华的仆人摩西从加低斯·巴尼亚派我来侦察这地方，我如实禀告他。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","与我同去的弟兄的禀告让以色列人胆战心惊，但我一心追随我的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","所以，当日摩西就向我起誓，‘你脚踏过的地方必永远归你和你的子孙作产业，因为你一心追随我的上帝耶和华。’ ");
INSERT INTO cmncbs_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","耶和华照祂的应许，让我又活了四十五年。当年耶和华对摩西说这话时，以色列人还在旷野漂流。看！我现在已经八十五岁了， ");
INSERT INTO cmncbs_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","仍像当年摩西派我出去时那样身强力壮，跟当年一样能征善战。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","现在，求你照耶和华当日向我应许的，把这山区赐给我。你当日亲耳听到那里有亚衲人，他们的城池高大坚固。但只要耶和华与我同在，我必照着祂的应许把这些人赶走。” ");
INSERT INTO cmncbs_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","于是，约书亚便祝福耶孚尼的儿子迦勒，把希伯仑给他，作为他的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","所以，希伯仑至今仍是基尼洗族耶孚尼的儿子迦勒的产业，因为他一心追随以色列的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","希伯仑从前名叫基列·亚巴，亚巴原是亚衲族中最伟大的人。从此，境内太平，没有战争。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","犹大支派按宗族抽签分到的土地，南到以东的边界，到最南端的荀旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","南面的边界始于盐海南端的海湾， ");
INSERT INTO cmncbs_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","沿亚克拉滨山坡南面，经荀，北上至加低斯·巴尼亚南面，经过希斯仑到亚达珥，再绕到甲加， ");
INSERT INTO cmncbs_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","经过押们、顺着埃及小河直到地中海。这是犹大支派的南部边界。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","东面以盐海到约旦河口为边界。 北界从约旦河口的海湾开始， ");
INSERT INTO cmncbs_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","到伯·曷拉，经过伯·亚拉巴北面，直到吕便的儿子波罕所立的大石； ");
INSERT INTO cmncbs_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","从亚割谷往北到底璧，到谷南亚都冥隘口对面的吉甲，经隐·示麦泉，直到隐·罗结； ");
INSERT INTO cmncbs_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","然后再沿着欣嫩子谷而上，直到耶布斯，即耶路撒冷的南面，再到欣嫩谷西面、利乏音谷北端的山顶； ");
INSERT INTO cmncbs_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","从山顶到尼弗多亚泉，到以弗仑山的各城，直到巴拉，即基列·耶琳； ");
INSERT INTO cmncbs_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","从巴拉向西绕到西珥山，到耶琳山北坡，即基撒仑，到伯·示麦，经亭拿， ");
INSERT INTO cmncbs_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","再到以革伦北坡，转向施基仑，经巴拉山和雅比聂，直到地中海。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","西面的边界是地中海沿岸。以上是犹大人根据宗族所得地业的四界。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","约书亚又照耶和华的吩咐，在犹大支派所分到的土地之中划出基列·亚巴，即希伯仑，分给耶孚尼的儿子迦勒。亚巴是亚衲人的祖先。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","迦勒赶走了住在那里的亚衲族的三个族长，即示筛、亚希幔和挞买， ");
INSERT INTO cmncbs_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","再从那里出兵攻打底璧，底璧从前叫基列·西弗。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","迦勒说：“谁攻取基列·西弗，我就把女儿押撒嫁给他。” ");
INSERT INTO cmncbs_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","迦勒的弟弟基纳斯的儿子俄陀聂攻取了那城，迦勒便把女儿押撒嫁给他。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","押撒出嫁的时候，劝丈夫向她父亲要一块田。她刚下驴，迦勒便问她：“你想要什么？” ");
INSERT INTO cmncbs_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","押撒答道：“求你赐福给我，你既然把南地赐给我，求你也把水泉赐给我吧。”迦勒就把上泉和下泉都给了她。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","以下是犹大支派按宗族所得的产业： ");
INSERT INTO cmncbs_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","在最南面靠近以东的城邑有甲薛、以得、雅姑珥、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","基拿、底摩拿、亚大达、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","基低斯、夏琐、以提楠、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","西弗、提链、比亚绿、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","夏琐·哈大他、加略·希斯仑，即夏琐、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","亚曼、示玛、摩拉大、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","哈萨·迦大、黑实门、伯·帕列、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","哈萨·书亚、别示巴、比斯约他、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","巴拉、以因、以森、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","伊勒多腊、基失、何珥玛、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","洗革拉、麦玛拿、三撒拿、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","利巴勿、实忻、亚因和临门，共二十九座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","在丘陵地带有以实陶、琐拉、亚实拿、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","撒挪亚、隐·干宁、他普亚、以楠、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","耶末、亚杜兰、梭哥、亚西加、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","沙拉音、亚底他音、基底拉和基底罗他音，共十四座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","还有洗楠、哈大沙、麦大·迦得、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","底连、米斯巴、约帖、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","拉吉、波斯加、伊矶伦、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","迦本、拉幔、基提利、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","基低罗、伯·大衮、拿玛、玛基大，共十六座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","还有立拿、以帖、亚珊、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","益弗他、亚实拿、尼悉、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","基伊拉、亚革悉、玛利沙，共九座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","还有以革伦及其附近的城邑和乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","还有以革伦到地中海一带所有靠近亚实突的城邑和乡村， ");
INSERT INTO cmncbs_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","亚实突及其附近的城邑和乡村，迦萨及其附近的城邑和乡村，直到埃及小河和地中海沿岸。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","在山区有沙密、雅提珥、梭哥、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","达拿、基列·萨拿，即底璧、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","亚拿伯、以实提莫、亚念、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","歌珊、何仑、基罗，共十一座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","还有亚拉、度玛、以珊、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","雅农、伯·他普亚、亚非加、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","宏他、基列·亚巴，即希伯仑、洗珥，共九座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","还有玛云、迦密、西弗、淤他、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","耶斯列、约甸、撒挪亚、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","该隐、基比亚、亭拿，共十座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","还有哈忽、伯·夙、基突、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","玛腊、伯·亚诺、伊勒提君，共六座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","还有基列·巴力，即基列·耶琳、拉巴两座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","在旷野有伯·亚拉巴、密丁、西迦迦、 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","匿珊、盐城、隐·基底，共六座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","犹大人没能把住在耶路撒冷的耶布斯人赶出去，他们至今仍然跟犹大人一同居住。 ");
INSERT INTO cmncbs_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","约瑟的子孙抽签所得的地方是从耶利哥附近的约旦河，就是耶利哥水泉的东面开始，穿过旷野，直到伯特利山区； ");
INSERT INTO cmncbs_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","又从伯特利，即路斯，延至亚基人的疆土亚他绿， ");
INSERT INTO cmncbs_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","然后西下至押利提人的疆土，远至下伯·和仑地区，经基色直到地中海。 ");
INSERT INTO cmncbs_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","约瑟的儿子玛拿西和以法莲得了自己的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","以下是以法莲的子孙按宗族分到的土地：东面从亚他录·亚达到上伯·和仑， ");
INSERT INTO cmncbs_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","直到地中海；北面从密米他向东绕到他纳·示罗，到雅挪哈东部， ");
INSERT INTO cmncbs_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","再到亚他录、拿拉，经耶利哥直到约旦河； ");
INSERT INTO cmncbs_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","又从他普亚往西到加拿河，直到地中海。这就是以法莲的子孙按宗族所分的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","此外，他们又从玛拿西人的产业中，分到部分城邑及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","他们没有赶走住在基色的迦南人，迦南人至今还住在以法莲人当中，为他们服劳役。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","以下是约瑟的长子玛拿西支派分到的土地：玛拿西的长子、基列的父亲玛吉是个战士，因此分到了基列和巴珊两地。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","玛拿西其他子孙也按宗族分到了土地，他们属于亚比以谢、希勒、亚斯烈、示剑、希弗和示米大宗族。这些男子按宗族都是约瑟的儿子玛拿西的后代。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","玛拿西的玄孙、玛吉的曾孙、基列的孙子、希弗的儿子西罗非哈没有儿子，只有五个女儿，名叫玛拉、挪阿、曷拉、密迦、得撒。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","她们来见祭司以利亚撒、嫩的儿子约书亚和各首领，说：“耶和华曾经吩咐摩西在我们亲族中分给我们产业。”约书亚便照耶和华的吩咐，让她们在叔伯中也分到产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","除了约旦河东的基列和巴珊两地以外，玛拿西人还分到十块土地， ");
INSERT INTO cmncbs_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","因为在玛拿西的后代中，女性也分到了产业。玛拿西其他子孙分到基列地区。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","玛拿西支派分到的土地从亚设开始，到示剑东面的密米他，再向南到隐·他普亚人居住的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","他普亚地属于玛拿西，但在玛拿西边界上的他普亚城属于以法莲的子孙。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","边界继续向南到加拿河，在河南侧玛拿西境内的城邑都归以法莲。玛拿西的边界沿着加拿河北侧直到地中海。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","这样，南面归以法莲，北面归玛拿西，西部边界是地中海，北接亚设，东邻以萨迦。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","在以萨迦和亚设境内，玛拿西拥有伯·善、以伯莲、多珥、隐·多珥、他纳和米吉多及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","可是，玛拿西人没能把这些城邑的迦南人赶走，因为他们执意不肯离开。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","以色列人国势强盛的时候，就让迦南人服劳役，但始终没有把他们完全赶走。 ");
INSERT INTO cmncbs_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","约瑟的子孙对约书亚说：“耶和华赐福给我们，使我们人口众多，为什么你只让我们抽一支签，分一份产业呢？” ");
INSERT INTO cmncbs_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","约书亚对他们说：“你们如果人口众多，认为以法莲山区窄小，可以到比利洗人和利乏音人居住的地方开辟林区。” ");
INSERT INTO cmncbs_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","他们答道：“那些山区不够我们住，况且住在伯·善一带和耶斯列平原的迦南人都有铁战车。” ");
INSERT INTO cmncbs_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","约书亚对约瑟的子孙以法莲人和玛拿西人说：“你们人口众多，势力强大，不应只得一签之地， ");
INSERT INTO cmncbs_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","山区也要分给你们，虽然全是森林，但可以开辟土地，使整个地区归你们。虽然迦南人强盛，有铁战车，但你们必能赶走他们。” ");
INSERT INTO cmncbs_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","征服了这些地方以后，以色列全体会众都聚集在示罗，把会幕设立在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","这时，以色列还有七个支派没有分到产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","约书亚对他们说：“你们等到什么时候才去占领你们祖先的上帝耶和华赐给你们的土地呢？ ");
INSERT INTO cmncbs_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","你们每支派要派出三个人，我要差他们走遍那地，按各支派应得的土地绘制地图，然后回来禀告我。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","他们要把土地划分作七份。犹大要留在南部自己的领土上，约瑟家族要留在北部自己的领土上。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","你们把这七份土地绘成地图交给我，我要在我们的上帝耶和华面前为你们抽签。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","你们当中的利未人没有份，因为做耶和华的祭司这职任就是他们的产业。至于迦得支派、吕便支派和玛拿西半个支派，耶和华的仆人摩西已把约旦河东的土地分给他们了。” ");
INSERT INTO cmncbs_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","那些画地图的人启程出发的时候，约书亚嘱咐他们说：“你们要走遍那里，绘制地图，然后回来禀告我，我要在示罗，在耶和华面前为你们抽签。” ");
INSERT INTO cmncbs_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","于是，他们走遍那里，把所有城邑分作七份，绘在册上，然后回到示罗见约书亚。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","约书亚便在示罗按照以色列的支派，在耶和华面前为他们抽签分地。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","便雅悯支派按宗族抽签分到的领土，坐落在犹大和约瑟支派的领土之间。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","他们北部的边界从约旦河起，沿耶利哥北面的山坡直上，往西穿过山区，直到伯·亚文的旷野； ");
INSERT INTO cmncbs_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","从那里经路斯，即伯特利南面山坡到下伯·和仑南面山区的亚他录·亚达。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","西面的边界自伯·和仑对面山的西侧，向南直到犹大人的基列·巴力城，即基列·耶琳。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","南部边界从基列·耶琳的边界开始，向西直到尼弗多亚的水泉， ");
INSERT INTO cmncbs_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","又往下到欣嫩子谷对面的山麓，也就是利乏音谷北边，然后往南，经欣嫩谷到耶布斯的南坡，直到隐·罗结； ");
INSERT INTO cmncbs_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","然后，向北先后到隐·示麦，亚都冥山坡对面的基利绿，吕便的儿子波罕所立的大石， ");
INSERT INTO cmncbs_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","以及亚拉巴的对面，再往北下到亚拉巴； ");
INSERT INTO cmncbs_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","又沿着伯·曷拉的北面直到盐海的北岸，也就是约旦河的南部河口。这是南部的边界。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","东面以约旦河为界。这是便雅悯人按宗族分到的土地四周的边界。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","以下是便雅悯支派按宗族分到的城邑：耶利哥、伯·曷拉、伊麦·基悉、 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","伯·亚拉巴、西玛莲、伯特利、 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","亚文、巴拉、俄弗拉、 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","基法·阿摩尼、俄弗尼、迦巴，共十二座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","还有基遍、拉玛、比录、 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","米斯巴、基非拉、摩撒、 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","利坚、伊利毗勒、他拉拉、 ");
INSERT INTO cmncbs_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","洗拉、以利弗、耶布斯，即耶路撒冷、基比亚、基列，共十四座城及其附近的乡村。 这就是便雅悯各宗族所分到的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","西缅支派按宗族得到第二签，所得的产业在犹大人的疆界内， ");
INSERT INTO cmncbs_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","有别示巴，又名示巴、摩拉大、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","哈萨·书亚、巴拉、以森、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","伊勒多腊、比土力、何珥玛、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","洗革拉、伯·玛加博、哈萨·苏撒、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","伯·利巴勿、沙鲁险共十三座城及其附近的乡村， ");
INSERT INTO cmncbs_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","还有亚因、利门、以帖、亚珊四座城及其村庄， ");
INSERT INTO cmncbs_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","包括周围所有的村庄，远至巴拉·比珥，即南地的拉玛。这些都是西缅支派按宗族所得的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","西缅人的产业是从犹大人的产业中拨出来的，因为犹大支派所分到的地区过于广大，所以要拨出一部分来分给西缅人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","西布伦人按宗族得了第三签，他们分到的土地远至撒立。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","从撒立向西到玛拉拉、大巴设，直到约念东边的小河； ");
INSERT INTO cmncbs_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","从撒立向东朝日出方向到吉斯绿·他泊的边界，经大比拉、直到雅非亚； ");
INSERT INTO cmncbs_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","再往东，经迦特·希弗、以特·加汛、临门，直到尼亚； ");
INSERT INTO cmncbs_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","北上转向哈拿顿，直到伊弗他·伊勒山谷。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","还有加他、拿哈拉、伸仑、以大拉、伯利恒，共十二座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","以上这些城邑和乡村是西布伦人按宗族所得的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","以萨迦人按宗族得了第四签， ");
INSERT INTO cmncbs_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","他们的土地包括耶斯列、基苏律、书念、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","哈弗连、示按、亚拿哈拉、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","拉璧、基善、亚别、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","利篾、隐·干宁、隐·哈大、伯·帕薛、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","他泊、沙哈洗玛、伯·示麦，直到约旦河，共十六座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","这些城邑和乡村都是以萨迦支派按宗族分到的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","亚设支派按宗族得了第五签， ");
INSERT INTO cmncbs_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","他们得到的土地包括黑甲、哈利、比田、押煞、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","亚拉米勒、亚末和米沙勒，西至迦密和希曷·立纳， ");
INSERT INTO cmncbs_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","然后向东到伯·大衮，挨着西布伦和伊弗他·伊勒谷，经伯·以墨和尼业向北到迦步勒； ");
INSERT INTO cmncbs_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","再经义伯仑、利合、哈们、加拿直到西顿大城； ");
INSERT INTO cmncbs_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","再转到拉玛、坚固的泰尔城，然后转到何萨，直到亚革悉一带的地中海。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","还有乌玛、亚弗和利合，共二十二座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","这些城邑和乡村都是亚设支派按宗族分到的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","拿弗他利人按宗族得了第六签， ");
INSERT INTO cmncbs_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","他们的土地从希利弗、撒拿音的橡树、亚大米·尼吉和雅比聂到拉共，再到约旦河； ");
INSERT INTO cmncbs_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","又向西到亚斯纳·他泊、户割，南接西布伦，西接亚设，东接约旦河。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","还包括以下坚城：西丁、侧耳、哈末、拉甲、基尼烈、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","亚大玛、拉玛、夏琐、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","基低斯、以得来、隐·夏琐、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","以利隐、密大·伊勒、和琏、伯·亚纳、伯‧示麦，共十九座城及其附近的乡村。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","这些城邑和乡村都是拿弗他利支派按宗族分到的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","但支派按宗族得了第七签， ");
INSERT INTO cmncbs_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","他们的土地包括琐拉、以实陶、伊珥·示麦、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","沙拉宾、亚雅仑、伊提拉、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","以伦、亭拿他、以革伦、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","伊利提基、基比顿、巴拉、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","伊胡得、比尼·比拉、迦特·临门、 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","美·耶昆、拉昆和约帕对面的一带。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","但支派无法夺取他们的土地，于是就去攻打利善城，用刀杀了城内的居民，占据了这座城，用他们祖先的名字把城改名为但， ");
INSERT INTO cmncbs_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","这些城邑和村庄都是但支派按宗族得到的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","以色列人把地分配完毕以后，又从中划出土地给嫩的儿子约书亚。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","以色列人遵从耶和华的吩咐，把约书亚想要的以法莲山区的亭拿·西拉城分给他。约书亚重修那城，住在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","以上是祭司以利亚撒、嫩的儿子约书亚和以色列各支派的首领，在示罗的会幕门口，在耶和华面前抽签所分配的土地。至此，他们把地分完了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","耶和华对约书亚说： ");
INSERT INTO cmncbs_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“你吩咐以色列人，照我以前借摩西所吩咐你们的，设立一些城邑作为避难城， ");
INSERT INTO cmncbs_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","好让误杀人的可以逃到那里，躲避报血仇的人追杀。 ");
INSERT INTO cmncbs_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","他要逃到避难城，站在城门口向城中的长老们陈明事情的经过，长老们就把他收容到城里，给他提供住处，让他留在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","如果报血仇的人追到，长老们不可把他交出来，因为他是无意杀的，跟被杀者无冤无仇。 ");
INSERT INTO cmncbs_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","他要住在城内，直到在会众面前受了审讯，并且还要等到在任的大祭司死后，才可离城回乡。” ");
INSERT INTO cmncbs_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","于是，民众便设立拿弗他利山区加利利境内的基低斯、以法莲山区的示剑和犹大山区的基列·亚巴，即希伯仑作为避难城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","他们又在约旦河东岸、耶利哥东面空旷的平原上设立吕便支派的比悉，迦得支派基列境内的拉末和玛拿西支派巴珊境内的哥兰作为避难城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","这是为以色列人和那些从外地来寄居的人所设立的避难城，误杀了人的可以逃到那里，不致未在会众面前受审便死在报血仇的人手里。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","2","利未人的众族长到迦南的示罗见祭司以利亚撒、嫩的儿子约书亚和以色列各支派的首领，说：“耶和华借着摩西曾吩咐你们把一些城邑分给我们住，并把城郊的草场给我们牧养牲畜。” ");
INSERT INTO cmncbs_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","以色列人便按照耶和华的吩咐，从他们的产业中把以下的城邑及其草场分给了利未人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","首先哥辖宗族抽了签。利未人哥辖宗族中大祭司亚伦的子孙从犹大、西缅和便雅悯支派的产业中，抽签得了十三座城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","哥辖宗族中其他人也从以法莲、但和玛拿西半个支派的产业中，抽签得了十座城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","革顺的子孙从以萨迦、亚设、拿弗他利和在巴珊的玛拿西半个支派的产业中，抽签得了十三座城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","米拉利的子孙按宗族从吕便、迦得和西布伦支派的产业中，抽签得了十二座城。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","以色列人照耶和华对摩西的吩咐，把这些城邑及其草场用抽签的方式分给利未人。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","10","因为利未支派哥辖宗族中亚伦的子孙抽到第一签，以色列人就从犹大和西缅两支派的产业中点名划出以下城邑分给他们： ");
INSERT INTO cmncbs_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","犹大山区的基列·亚巴及其草场，亚巴原是亚衲人的祖先，基列·亚巴就是希伯仑。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","而城周围的田地和乡村已经分给耶孚尼的儿子迦勒作产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","以色列人把避难城希伯仑分给祭司亚伦的子孙，并把立拿、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","雅提珥、以实提莫、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","何仑、底璧、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","亚因、淤他、伯·示麦共九座城及其草场分给了他们。这都是从犹大和西缅两支派分出来的。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","从便雅悯支派的产业中分给他们的城有：基遍、迦巴、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","亚拿突、亚勒们四座城及其草场。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","做祭司的亚伦子孙共分到十三座城邑及其草场。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","利未人哥辖宗族其他子孙从以法莲支派的产业中抽签分到的城邑有： ");
INSERT INTO cmncbs_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","以法莲山区的避难城示剑、基色、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","基伯先和伯·和仑共四座城及其草场。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","从但支派的产业中分给他们的城邑有：伊利提基、基比顿、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","亚雅仑和迦特·临门四座城及其草场。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","他们从玛拿西半个支派的产业中分到他纳和迦特·临门两座城及其草场。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","以上是哥辖其他子孙所分到的十座城及其草场。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","以色列人分给利未支派中革顺子孙的城邑有：玛拿西半个支派中巴珊的哥兰避难城和比·施提拉两座城及其草场； ");
INSERT INTO cmncbs_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","以萨迦支派的基善、大比拉、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","耶末、隐·干宁四座城及其草场； ");
INSERT INTO cmncbs_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","亚设支派的米沙勒、押顿、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","黑甲、利合四座城及其草场； ");
INSERT INTO cmncbs_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","拿弗他利支派的哈末·多珥、加珥坦和加利利的避难城基低斯三座城及其草场。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","革顺人按宗族共分到十三座城邑及其草场。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","其余的利未人，就是米拉利的子孙所分到的城邑有：西布伦支派的约念、加珥他、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","丁拿、拿哈拉四座城及其草场； ");
INSERT INTO cmncbs_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","吕便支派的比悉、雅杂、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","基底莫、米法押四座城及其草场； ");
INSERT INTO cmncbs_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","迦得支派的玛哈念、基列的避难城拉末、 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","希实本、雅谢四座城及其草场。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","利未人中米拉利的子孙按宗族所分到的城邑共有十二座。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","利未人从以色列各支派共分到四十八座城及其草场， ");
INSERT INTO cmncbs_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","这些城周围都有草场，城城如此。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","这样，耶和华把从前起誓要赐给以色列人祖先的整个地区，都赐给了以色列人，以色列人都分到土地，住了下来。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","耶和华照着给他们祖先的应许，使他们四境安宁，没有仇敌能抵挡他们。耶和华将所有仇敌都交在了他们手中。 ");
INSERT INTO cmncbs_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","耶和华给以色列人的美好应许没有一句落空，全部实现了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","约书亚召来了吕便、迦得和玛拿西半个支派的人来， ");
INSERT INTO cmncbs_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","对他们说：“你们都遵守了耶和华的仆人摩西的一切吩咐，也听从了我的一切吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","这些日子以来，你们从没有离弃自己的弟兄，遵守了你们的上帝耶和华的吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","现在你们的上帝耶和华已经照祂的应许使你们的弟兄安居，你们可以回到约旦河东，到摩西赐给你们作产业的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","不过，你们要谨遵耶和华的仆人摩西吩咐你们的诫命和律法，要爱你们的上帝耶和华，遵行祂的旨意，听从祂的命令，依靠祂，全心全意地事奉祂。” ");
INSERT INTO cmncbs_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","于是，约书亚为他们祝福，送他们回去，他们就各自返回家园去了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","摩西已经在巴珊把土地分给了玛拿西半个支派，约书亚把约旦河西的土地分给了玛拿西另外的半个支派及其他支派。约书亚派他们回家的时候，为他们祝福， ");
INSERT INTO cmncbs_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","说：“现在你们带着大量财物、牲畜、金银、铜、铁和衣物返回家园，要把从敌人那里得来的财物分给你们的弟兄。” ");
INSERT INTO cmncbs_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","于是，吕便、迦得和玛拿西半个支派的人便离开在迦南的示罗的以色列人，返回耶和华借摩西分配给他们的基列。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","他们来到约旦河附近的迦南境内，就在约旦河边筑了一座高大的祭坛。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","以色列人听见吕便、迦得和玛拿西半个支派的人在约旦河西的迦南境内筑起了一座祭坛， ");
INSERT INTO cmncbs_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","便全部聚集在示罗，要讨伐他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","以色列人派祭司以利亚撒的儿子非尼哈去基列见他们， ");
INSERT INTO cmncbs_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","又从每支派差遣一位族长，共十位随行。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","他们来到基列的吕便、迦得和玛拿西半个支派的人那里，对他们说： ");
INSERT INTO cmncbs_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“耶和华的全体会众问你们，你们怎能这样背叛以色列的上帝，离弃耶和华，为自己另建祭坛呢？ ");
INSERT INTO cmncbs_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","从前拜毗珥的罪恶不够大吗？那一次，瘟疫降到耶和华的会众身上，直到今日我们还没有洗净这罪。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","你们今日要离弃耶和华吗？今日你们背叛耶和华，明日祂必向以色列全体会众发怒。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","你们如果认为自己的土地不洁净，可以搬到耶和华的土地上跟我们一起居住，这里有耶和华的圣幕。只是不可在耶和华的祭坛以外，为自己另筑祭坛，以致背叛耶和华，背叛我们。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","从前谢拉的曾孙亚干私自留下那些耶和华吩咐要毁灭之物，耶和华的烈怒难道没有临到以色列全体会众吗？因他的罪而死的不只他一个人！” ");
INSERT INTO cmncbs_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","吕便、迦得和玛拿西半个支派的人便回答这些以色列的族长说： ");
INSERT INTO cmncbs_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“大能的上帝耶和华，大能的上帝耶和华，祂知道一切！以色列人也当知道！如果我们悖逆或干犯耶和华，愿祂今天就不放过我们！ ");
INSERT INTO cmncbs_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","如果我们离弃耶和华，为自己造祭坛，或在坛上献燔祭、素祭和平安祭，愿耶和华亲自惩罚我们。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","我们这样做是怕以后你们的子孙可能会对我们的子孙说，‘你们和以色列的上帝耶和华有什么关系？ ");
INSERT INTO cmncbs_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","耶和华把约旦河定为我们跟你们吕便人和迦得人的边界，你们与耶和华一点关系也没有。’这样，恐怕你们的子孙会使我们的子孙不再敬畏耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","因此，我们便商议在这里筑一座祭坛，这坛不是用来献燔祭或别的祭， ");
INSERT INTO cmncbs_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","只是在你们和我们之间，也在彼此的后人之间立个证据，证明我们也献燔祭、平安祭及其他祭事奉耶和华，免得日后你们的子孙对我们的子孙说，‘你们与耶和华一点关系也没有。’ ");
INSERT INTO cmncbs_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","我们商议，万一你们对我们或我们的子孙这样说，我们可以回答说，‘你们看我们祖先筑的这座祭坛跟耶和华的祭坛一模一样，只是这座坛不是用来献燔祭或别的祭，而是作为你们和我们之间的证据！’ ");
INSERT INTO cmncbs_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","我们根本无意背叛、离弃我们的上帝耶和华，在祂圣幕前的祭坛以外另筑祭坛来献燔祭、素祭和别的祭。” ");
INSERT INTO cmncbs_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","祭司非尼哈和以色列会众的族长听了他们的解释，都很满意。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","以利亚撒的儿子祭司非尼哈对他们说：“今日我们知道耶和华在我们当中，因为你们没有对耶和华不忠，现在你们使以色列人免遭耶和华的惩罚了。” ");
INSERT INTO cmncbs_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","以利亚撒的儿子非尼哈祭司和众族长便离开吕便人和迦得人，从基列回到迦南向以色列人报告这事。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","众人听后，都很满意，便颂赞耶和华，打消了出兵讨伐吕便人和迦得人、毁灭他们家园的念头。 ");
INSERT INTO cmncbs_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","吕便人和迦得人给那座祭坛取名叫“证坛”，意思是这坛在我们中间证明耶和华是上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","此后很长时间，耶和华使以色列人四境太平，没有战事。约书亚年事已高， ");
INSERT INTO cmncbs_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","他召来全体以色列人，包括长老、族长、审判官和官长，对他们说：“我已经老了， ");
INSERT INTO cmncbs_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","你们都亲眼看见你们的上帝耶和华怎样为了你们而对付列邦，亲自为你们争战。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","从约旦河到西边地中海的这片土地，无论是已征服的还是没有征服的，我已经用抽签的方式分给你们各支派作产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","你们的上帝耶和华必把列邦从你们面前驱离赶走，让你们占据他们的土地，正如你们的上帝耶和华的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","所以，你们要刚强，谨遵摩西律法书上所记载的一切，不可有半点偏离。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","不可与你们中间剩下的异族混杂，不可提他们的神明或凭它们起誓，不可供奉和祭拜他们的神明。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","你们要一如既往地倚靠你们的上帝耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","因为祂为你们赶走了强大的外族人，至今无人敌得过你们。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","你们一个人能打败他们一千人，因为你们的上帝耶和华照着祂的应许为你们争战。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","所以你们要特别谨慎，爱你们的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","如果你们悖逆，跟你们当中剩下的异族人联合，通婚往来， ");
INSERT INTO cmncbs_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","毫无疑问，你们的上帝耶和华必不再为你们赶走他们。相反，他们还要成为设在你们当中的圈套和陷阱，你们的肉中刺、眼中钉，直到你们在你们的上帝耶和华所赐给你们的这块美好的土地上灭亡。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“我快要走完人世的路程了。你们深知你们的上帝耶和华赐给你们的一切美好应许没有一句落空，都已经应验了。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","正如你们的上帝耶和华已成就祂应许给你们的一切福气，祂也会照样降各样灾祸给你们，直到把你们从祂所赐的这美好土地上毁灭。 ");
INSERT INTO cmncbs_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","你们如果违背你们的上帝耶和华吩咐你们遵守的约，去供奉、祭拜其他神明，祂必向你们发怒，使你们在祂所赐的这美好土地上迅速灭亡。” ");
INSERT INTO cmncbs_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","约书亚在示剑招聚以色列各支派，他召来以色列的长老、族长、审判官和官长。他们一同站在上帝面前。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","约书亚对全体民众说：“以色列的上帝耶和华这样说，‘从前你们的祖先，包括亚伯拉罕和拿鹤二人的父亲他拉，住在幼发拉底河那边拜其他神明。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","我把你们的祖先亚伯拉罕从幼发拉底河那边带出来，领他走遍迦南，使他人丁兴旺。我把以撒赐给他， ");
INSERT INTO cmncbs_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","把雅各和以扫赐给以撒，把西珥山赐给以扫作产业，雅各和他的子孙则去了埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","后来，我差遣了摩西和亚伦，并用灾祸攻击埃及人，把你们领出来。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","我带你们的祖先出埃及，到达红海，埃及人带领战车骑兵追了上来。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","你们的祖先大声呼求我，我就降下黑暗，把你们和埃及人分开，又用海水淹没埃及人。你们亲眼见过我在埃及的作为。后来，你们在旷野住了很长时间。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","我领你们来到约旦河东边亚摩利人居住的地方。他们跟你们争战，我把他们交在你们手中，使你们占领他们的土地作自己的产业。我把他们从你们面前全部消灭。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","那时，摩押王西拨的儿子巴勒起兵攻打你们，并派人去召比珥的儿子巴兰来咒诅你们。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","但我不听巴兰的话，反而使他为你们连连祝福。这样，我从巴勒手中救了你们。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","你们过了约旦河来到耶利哥。耶利哥人、亚摩利人、比利洗人、迦南人、赫人、革迦撒人、希未人和耶布斯人都跟你们交战，但我把他们交在你们手中。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","我差黄蜂飞在你们前面，把亚摩利的两个王从你们面前赶走，没有动用你们一刀一弓。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","你们没有开垦土地，也没有建造城邑，但我赐给你们土地和城邑，使你们住在其中，享用别人栽种的葡萄园和橄榄园的果子。’ ");
INSERT INTO cmncbs_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“所以，你们要敬畏耶和华，诚心诚意地事奉祂，弃绝你们祖先在幼发拉底河那边和在埃及所拜的神明，专心事奉耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","你们如果不愿事奉耶和华，今天就选择你们的神明吧，或大河那边你们祖先事奉的神明，或你们这里亚摩利人的神明。至于我和我全家，我们必事奉耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","民众答道：“我们决不背弃耶和华去事奉其他神明， ");
INSERT INTO cmncbs_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","因为我们的上帝耶和华曾领我们和我们的祖先脱离埃及人的奴役，在我们眼前行大神迹，一路保护我们安然经过列邦。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","耶和华把这地方的亚摩利人等外族人从我们面前赶走了，我们必事奉祂，因为祂是我们的上帝。” ");
INSERT INTO cmncbs_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","约书亚说：“你们不能事奉耶和华，祂是圣洁的上帝，祂痛恨不贞，必不赦免你们的过犯和罪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","如果你们背弃耶和华，去拜外族的神明，祂虽然恩待了你们，也必转而降祸给你们，毁灭你们。” ");
INSERT INTO cmncbs_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","民众答道：“不，我们一定要事奉耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","约书亚说：“现在你们自己作证，你们已选择事奉耶和华。”民众答道：“我们愿意自己作证。” ");
INSERT INTO cmncbs_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","约书亚说：“这样，你们现在就要弃绝你们中间的外族神明，专心归向以色列的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","民众答道：“我们必事奉我们的上帝耶和华，听从祂的话。” ");
INSERT INTO cmncbs_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","当天约书亚与民众立约，在示剑为他们订立律例和典章。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","约书亚把这些话都写在上帝的律法书上，又把一块大石头竖立在耶和华圣所旁边的橡树下。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","然后，他对民众说：“看啊，这块石头可以为我们作证，它听到了耶和华所吩咐我们的话。如果你们背弃上帝，它必作证。” ");
INSERT INTO cmncbs_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","于是，约书亚命民众各自返回自己的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","后来，耶和华的仆人、嫩的儿子约书亚去世了，享年一百一十岁。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","以色列人把他葬在他的土地上，就是在迦实山北边、以法莲山区的亭拿·西拉。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","约书亚在世的时候，以色列人都事奉耶和华。他死后，在那些经历过耶和华奇妙作为的长老还健在期间，以色列人仍事奉耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","以色列人把从埃及带出来的约瑟的骸骨葬在示剑，在从前雅各用一百块银子向哈抹的子孙买的那块地里。哈抹是示剑的父亲。后来那块地成了约瑟子孙的产业。 ");
INSERT INTO cmncbs_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","亚伦的儿子以利亚撒也死了，他们把他葬在他儿子非尼哈分到的以法莲山区的基比亚。");
INSERT INTO cmncbs_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","约书亚去世以后，以色列人求问耶和华：“我们哪一个支派先上去攻打迦南人呢？” ");
INSERT INTO cmncbs_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","耶和华说：“犹大支派先去，我已把那片土地交在他们手中了。” ");
INSERT INTO cmncbs_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","犹大人对同胞西缅人说：“请跟我们一同到我们分得的地方攻打迦南人，我们也会同样帮助你们。”于是，西缅人便与犹大人同去。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","犹大人上去攻打迦南人和比利洗人，耶和华使他们得胜，在比色杀了一万敌军。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","他们又在那里遇见亚多尼·比色，与他交战，打败了他带领的迦南人和比利洗人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","亚多尼·比色逃跑，他们追上去擒住他，砍掉他的大拇指和大脚趾。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","亚多尼·比色说：“从前七十个王被我砍掉大拇指和大脚趾，在我桌下捡食物碎屑，现在上帝照我的行为报应我了。”他们把他带到耶路撒冷，他就死在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","犹大人攻陷耶路撒冷，用刀杀了城内的所有居民，并放火焚城。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","随后，他们下去攻打住在山区、南地和丘陵的迦南人， ");
INSERT INTO cmncbs_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","又进攻住在希伯仑的迦南人，杀了示筛、亚希幔和挞买。希伯仑从前叫基列·亚巴。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","他们从那里出兵攻打底璧，底璧从前叫基列·西弗。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","迦勒说：“谁攻取基列·西弗，我就把女儿押撒嫁给他。” ");
INSERT INTO cmncbs_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","迦勒的弟弟基纳斯的儿子俄陀聂攻取了那城，迦勒便把女儿押撒嫁给他。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","押撒出嫁的时候，劝丈夫向她父亲要一块田。她刚下驴，迦勒便问她：“你想要什么？” ");
INSERT INTO cmncbs_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","她回答说：“求你赐福给我，你既然把南地赐给我，求你也把水泉给我吧。”迦勒就把上泉和下泉都给了她。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","摩西岳父的后代基尼人和犹大人一同离开棕树城，到犹大南部旷野的亚拉得附近，跟当地人一起居住。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","之后，犹大人随同胞西缅人一起攻打洗法城内的迦南人，彻底毁灭了那城。因此那城叫何珥玛。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","犹大人又夺取了迦萨、亚实基伦和以革伦三座城邑及周围地区。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","耶和华与犹大人同在。他们攻占了山区，却没能赶走平原的居民，因为那里的人有铁战车。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","照摩西的吩咐，迦勒得到了希伯仑。他把亚衲三族的人从那里赶走。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","便雅悯人没有赶走居住在耶路撒冷的耶布斯人，耶布斯人至今仍和他们住在一起。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","约瑟家族也上去攻打伯特利，耶和华与他们同在。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","他们先派人去打探伯特利，那里从前名叫路斯。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","探子看见一个人从城里出来，就对他说：“请你告诉我们进城的路，我们必善待你。” ");
INSERT INTO cmncbs_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","那人便告诉他们进城的路，他们用刀杀了城内所有的居民，只放走了那人及其全家。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","后来，那人搬到赫人的地方，筑了一座城，称之为路斯，沿用至今。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","玛拿西人没有赶走伯·善、他纳、多珥、以伯莲和米吉多众城邑及其周围村庄的居民，因为这些迦南人执意住在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","以色列人强盛时，就强迫他们服劳役，却没有全部赶走他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","以法莲人没有赶走住在基色的迦南人，这些迦南人仍然住在他们当中。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","西布伦人没有赶走基伦和拿哈拉的居民，这些迦南人仍然住在他们当中，为他们服劳役。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","亚设人没有赶走亚柯、西顿、亚黑拉、亚革悉、黑巴、亚弗革和利合的居民。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","亚设人因为没有赶出当地的迦南人，就住在他们当中。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","拿弗他利人没有赶走伯·示麦和伯·亚纳的居民，于是就住在这些迦南人当中，强迫他们服劳役。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","亚摩利人强迫但人住在山区，不准他们下到平原。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","亚摩利人执意住在希烈山、亚雅仑和沙宾，但约瑟家族强盛时，就强迫他们服劳役。 ");
INSERT INTO cmncbs_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","亚摩利人的边界从亚克拉滨山坡起，一直到西拉以北。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","耶和华的天使从吉甲来到波金，对以色列人说：“我带你们出埃及，领你们来到我起誓要赐给你们祖先的土地。我说，‘我永不废弃跟你们立的约， ");
INSERT INTO cmncbs_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","你们不可跟这里的居民立约，要毁掉他们的祭坛。’可是你们为什么不听呢？ ");
INSERT INTO cmncbs_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","因此，我告诉你们，我必不赶走这里的居民，他们必成为你们肋旁的刺，他们的神明必成为你们的网罗。” ");
INSERT INTO cmncbs_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","耶和华的天使说完这些话，以色列人放声大哭， ");
INSERT INTO cmncbs_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","他们称那地方为波金，在那里向耶和华献祭。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","约书亚遣散以色列人后，他们便各自去攻占所分得的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","约书亚在世的时候，以色列人都事奉耶和华。他死后，那些目睹耶和华为以色列人行大事的长老还在世的时候，以色列人仍事奉耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","耶和华的仆人、嫩的儿子约书亚去世时一百一十岁。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","以色列人把他葬在他自己的土地上，在迦实山以北、以法莲山区的亭拿·希烈。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","那一代人都去世后，新一代不认识耶和华，也不知道耶和华为以色列人所行的事。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","以色列人做耶和华视为恶的事，祭拜巴力。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","他们背弃了领他们祖先离开埃及的上帝耶和华，追随、祭拜邻邦的各种神明，因而惹耶和华发怒。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","他们背弃耶和华，去祭拜巴力和亚斯她录。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","耶和华向他们发怒，使他们受到掠夺者的攻击和四周仇敌的压制，毫无抵抗之力。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","他们每次出战，耶和华都出手与他们为敌，使他们战败，正如祂的誓言。他们苦不堪言。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","后来，耶和华使士师兴起，从掠夺者手中拯救他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","但他们不听从士师的话，与其他神明苟合，祭拜它们，很快偏离他们祖先的道路，没有像他们的祖先那样遵行耶和华的命令。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","耶和华见他们因敌人的压迫和苦待而哀号，就怜悯他们，使士师陆续兴起，并与每位士师同在。士师在世之日，耶和华从仇敌手中拯救他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","士师去世以后，他们又故态复萌，追随、祭拜其他神明，比他们的祖先更败坏。他们执迷不悟，怙恶不悛。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","耶和华向他们发怒，说：“这百姓违背了我跟他们祖先所立的约，不听从我的话。 ");
INSERT INTO cmncbs_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","因此，我不再逐出约书亚去世时还没有赶走的外族人， ");
INSERT INTO cmncbs_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","我要借此试验以色列人，看他们是否像他们祖先一样谨遵我的道。” ");
INSERT INTO cmncbs_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","这就是为什么耶和华留下那些外族人，没有立刻把他们赶走，也没有把他们交在约书亚手中。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","2","耶和华为了考验那些没有经历过迦南战事的以色列人，让他们学习作战，就留下了以下各族： ");
INSERT INTO cmncbs_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","五个非利士王、所有的迦南人、西顿人和住在巴力·黑门山到哈马口一带的黎巴嫩山区的希未人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","耶和华留下这几个外族是要考验以色列人，看他们是否愿意遵从祂借摩西向他们祖先颁布的诫命。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","以色列人住在这些迦南人、赫人、亚摩利人、比利洗人、希未人和耶布斯人当中， ");
INSERT INTO cmncbs_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","跟他们通婚，祭拜他们的神明。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","以色列人做耶和华视为恶的事，忘记他们的上帝耶和华，祭拜假神巴力和亚舍拉。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","耶和华向他们发怒，把他们交在美索不达米亚王古珊·利萨田的手中，受古珊·利萨田统治八年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","他们向耶和华呼求，耶和华就使一位名叫俄陀聂的拯救者兴起，他是迦勒弟弟基纳斯的儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","耶和华的灵降在俄陀聂身上，他就做了以色列的士师，领兵出战。耶和华将美索不达米亚王古珊·利萨田交在他手中，他便战胜了古珊·利萨田。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","此后，国内安享太平四十年，直到俄陀聂去世。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","之后，以色列人又做耶和华视为恶的事，耶和华就使摩押王伊矶伦强盛起来，攻打以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","伊矶伦联合亚扪人和亚玛力人进攻以色列人，占据了棕树城， ");
INSERT INTO cmncbs_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","以色列人受摩押王伊矶伦统治十八年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","他们呼求耶和华，耶和华就使一位名叫以笏的拯救者兴起。他是便雅悯人基拉的儿子，善用左手。以色列人派他去向摩押王伊矶伦进贡。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","他造了一把约半米长的两刃利剑，绑在右腿的衣服里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","他带着贡物去见极其肥胖的摩押王伊矶伦。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","以笏献上了贡物之后，便让抬贡物的人先回去。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","他自己从吉甲附近的石雕神像处折回王宫，对王说：“王啊，我有机密禀告。”王就命左右侍从回避，众人便都退去。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","当时王独自坐在楼上的房间乘凉，以笏近前说：“我有从上帝而来的讯息要禀告。”王从座位上站起来的时候， ");
INSERT INTO cmncbs_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","以笏左手拔出藏在右腿上的剑刺进王的肚腹， ");
INSERT INTO cmncbs_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","连剑柄也刺了进去，深深嵌入肥肉。以笏没有拔剑， ");
INSERT INTO cmncbs_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","便走出房间，把门都关上，锁好。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","以笏走后，王的仆人过来，见房门紧锁，以为王在大解。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","等了很久，门还没开，他们很焦急，就拿钥匙开门，发现他们的主人已经倒毙在地上。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","他们等待的时候，以笏已经逃走了。他经过石雕神像处，逃往西伊拉。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","到了那里，他就在以法莲的山区吹响号角，召集以色列人。众人跟随以笏下山， ");
INSERT INTO cmncbs_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","以笏对他们说：“跟我来！耶和华已经把仇敌摩押人交在你们手中了。”于是，众人跟着他下去占领了通往摩押的约旦河各渡口，不许任何人渡河。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","当时他们杀了约一万名强悍善战的摩押勇士，没有一人逃脱。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","这样，以色列人征服了摩押人，国中安享太平八十年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","以笏之后，亚拿的儿子珊迦拯救了以色列人。他曾用一根赶牛棍杀了六百名非利士人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","以笏死后，以色列人又做耶和华视为恶的事。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","耶和华把他们交在统治夏琐的迦南王耶宾手中。耶宾王的将军叫西西拉，住在夏罗设。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","耶宾王拥有九百辆铁战车，他残暴地压迫以色列人二十年。以色列人向耶和华呼求。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","当时做以色列士师的是女先知底波拉，她是拉比多的妻子， ");
INSERT INTO cmncbs_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","经常坐在以法莲山区拉玛和伯特利之间的底波拉棕树下，审理以色列人的纠纷。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","她派人去拿弗他利的基低斯召来亚比挪庵的儿子巴拉，对他说：“以色列的上帝耶和华命你率领一万拿弗他利人和西布伦人上他泊山。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","祂必使耶宾的将军西西拉率领全军和战车到基顺河与你交战，祂必把西西拉交在你手中。” ");
INSERT INTO cmncbs_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","巴拉回答说：“你跟我去，我就去；你不跟我去，我就不去。” ");
INSERT INTO cmncbs_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","底波拉说：“好，我一定与你同去。不过，你这次出征一定得不到荣耀，因为耶和华要把西西拉交在一名妇人手上。”于是，底波拉起身与巴拉一同前往基低斯。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","巴拉招聚了一万名拿弗他利人和西布伦人，底波拉与他一起出征。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","摩西的岳父何巴的后人基尼人希百离开自己的族人，在基低斯附近撒拿音的橡树旁搭帐篷居住。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","西西拉得知亚比挪庵的儿子巴拉已经上了他泊山， ");
INSERT INTO cmncbs_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","便召集全军和九百辆铁战车离开夏罗设，向基顺河进军。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","底波拉对巴拉说：“出击吧！今天耶和华要把西西拉交在你手中。看啊，耶和华已经率先出战了！”于是，巴拉率领一万人下了他泊山， ");
INSERT INTO cmncbs_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","进攻西西拉。耶和华使西西拉的战车和军队溃乱，败在巴拉刀下。西西拉弃车徒步逃跑， ");
INSERT INTO cmncbs_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","巴拉追击他的战车和军队，直到夏罗设。西西拉全军都死于刀下，无一逃脱。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","只有西西拉一人徒步逃到基尼人希百的妻子雅亿的帐篷，因为夏琐王耶宾和希百家向来友好。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","雅亿出来迎接西西拉，对他说：“我主，请进，不用怕！”西西拉便走进帐篷，雅亿为他盖上毯子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","西西拉说：“我口渴，请给我一点水吧。”雅亿打开皮袋给他奶喝，然后又给他盖上毯子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","西西拉又说：“请你守着门口，倘若有人查问，你就说没人来过这里。” ");
INSERT INTO cmncbs_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","西西拉因疲劳过度，沉沉入睡。雅亿乘机拿起锤子和一根帐篷的橛子，悄悄地走到他身旁，把橛子钉进他的太阳穴，直插到地里。西西拉就这样死了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","巴拉追来了，雅亿出来迎接他，对他说：“你找的人在这里，进来看看吧。”巴拉和她进了帐篷，见西西拉死在那里，太阳穴上还插着橛子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","那天，上帝使以色列人战胜了迦南王耶宾。 ");
INSERT INTO cmncbs_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","以色列人越战越勇，最终消灭了迦南王耶宾。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","那一天，底波拉和亚比挪庵的儿子巴拉高唱凯歌： ");
INSERT INTO cmncbs_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","“以色列的首领身先士卒， 民众前仆后继， 你们要赞美耶和华！ ");
INSERT INTO cmncbs_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","君王啊，请听！首领啊，请侧耳听！ 我要向耶和华歌唱， 我要歌颂以色列的上帝耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","耶和华啊，当你从西珥出来， 走过以东时， 大地震动， 天上下雨， 云降雨水。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","在西奈山的耶和华面前， 在以色列的上帝耶和华面前， 群山震动。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","在亚拿的儿子珊迦与雅亿的时代， 大路行人绝迹， 旅客绕道前行。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","我底波拉做以色列之母以前， 以色列的乡村杳无人烟。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","以色列人选择新的神明， 便战祸临门， 四万以色列人中找不到一矛一盾。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","我的心追随以色列的首领， 追随民中踊跃出征的人。 你们要赞美耶和华！ ");
INSERT INTO cmncbs_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","“你们骑白驴的、坐绣花毯子的、步行的， 都要倾听。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","歌乐手聚集在井旁， 传扬耶和华和祂以色列子民的胜利。 耶和华的子民都来到城门口。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","“底波拉啊，来吧，来吧， 歌唱吧！ 亚比挪庵的儿子巴拉啊，来吧， 带走你的战俘吧！ ");
INSERT INTO cmncbs_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","幸存的以色列人响应他们的首领， 耶和华的子民为我攻击勇士。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","他们有些来自原属亚玛力人的以法莲， 有些来自便雅悯， 统领出自玛吉， 将官出自西布伦。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","以萨迦的首领与底波拉同往， 以萨迦人随巴拉同去， 众人一起冲进山谷， 吕便人却犹豫不决。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","吕便人为什么坐在羊圈中听悠悠笛声？ 他们举棋不定。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","基列人留在约旦河东岸。 但人为什么停留在船上？ 亚设人在海岸静坐， 在港口逗留。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","但西布伦人舍生忘死， 拿弗他利人拼死鏖战沙场。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","“迦南诸王来战， 来到米吉多河边的他纳交战， 却没有掠走金银。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","星辰从天上争战， 从它们的轨道攻击西西拉。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","古老的基顺河冲走了敌人。 我的心啊，要奋勇向前！ ");
INSERT INTO cmncbs_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","蹄声隆隆， 骏马疾驰！ ");
INSERT INTO cmncbs_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","“耶和华的天使说， ‘要咒诅米罗斯， 要重重地咒诅米罗斯的居民， 因为他们没有帮助耶和华， 没有帮助耶和华攻击强敌。’ ");
INSERT INTO cmncbs_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","“基尼人希百的妻子雅亿是妇人中最有福的， 是住帐篷的妇人中最有福的。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","西西拉求水， 雅亿给他奶喝， 用珍贵的碗盛上奶酪。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","雅亿左手拿起橛子， 右手拿起工匠的锤子， 猛击西西拉， 打碎了他的头， 刺透了他的太阳穴。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","西西拉屈身倒下， 死在她脚前， 一动不动地躺在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","“西西拉的母亲凭窗远眺， 隔着窗棂喊道， ‘为什么他的战车迟迟不回？ 为什么还听不到车轮声？’ ");
INSERT INTO cmncbs_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","聪明的宫女安慰她， 她却依然自言自语， ");
INSERT INTO cmncbs_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","‘莫非他们在搜索、瓜分战利品？ 每人得到一两个少女， 西西拉分得绣花彩巾， 绣花的彩色围巾作战利品。’ ");
INSERT INTO cmncbs_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","耶和华啊， 愿你的敌人都像西西拉一样灭亡！ 愿爱你的人都如升起的太阳， 光辉熠熠！” 此后，以色列安享太平四十年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","后来，以色列人又做耶和华视为恶的事，耶和华就把他们交在米甸人手下七年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","米甸人势力强盛，以色列人只好躲进山里，藏在洞穴和营寨中。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","每当他们撒种的时候，米甸人、亚玛力人及东方人就前来进犯， ");
INSERT INTO cmncbs_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","在他们境内安营，摧毁他们远至迦萨一带的庄稼，不给他们留下任何粮食，也不留下一只羊、一头牛或驴。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","入侵者带着牲畜和帐篷像蝗虫一样涌来，人和骆驼不计其数，摧毁了整个地区。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","以色列人因米甸人的入侵而极其贫乏，就呼求耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","当以色列人因米甸人的入侵而呼求耶和华的时候， ");
INSERT INTO cmncbs_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","耶和华就差遣先知对他们说：“以色列的上帝耶和华说，‘我曾把你们从受奴役之地埃及领出来， ");
INSERT INTO cmncbs_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","将你们从埃及人及一切欺压者的手中拯救出来，从你们面前赶走他们，把他们的土地赐给你们。’ ");
INSERT INTO cmncbs_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","我曾对你们说，‘我是你们的上帝耶和华。你们虽然住在亚摩利人的地方，但不可祭拜他们的神明。’你们却充耳不闻。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","一天，耶和华的天使来到俄弗拉，坐在亚比以谢族人约阿施的橡树下。约阿施的儿子基甸因为要躲避米甸人，正躲在榨酒池里打麦子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","耶和华的天使向基甸显现，对他说：“英勇的战士啊，耶和华与你同在。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","基甸说：“我主啊，如果耶和华与我们同在，我们怎会有这些遭遇？我们的祖先说耶和华曾带他们出埃及，但如今祂那些奇妙的作为在哪里呢？现在祂已经丢弃我们，把我们交在米甸人手里。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","耶和华转向他，说：“你尽自己的力量去从米甸人手中拯救以色列人吧，我现在派你去。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","基甸说：“主啊，我出身于玛拿西支派最弱小的家族，在家里最微不足道，我怎能拯救以色列人呢？” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","耶和华说：“我必与你同在，你必如击打一人一样击打米甸人。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","基甸说：“如果我在你面前蒙恩，求你给我一个凭据，使我知道与我说话的真是你耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","请你在这里等一等，让我回去拿礼物献给你。”耶和华说：“我必等你回来。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","基甸回家预备了一只山羊羔，用十公斤面粉做了无酵饼，把肉放进篮子，把汤盛在壶中，然后拿到橡树下献上。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","上帝的天使对基甸说：“把肉和无酵饼放在这磐石上，把汤倒在上面。”他一一照做。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","耶和华的天使伸出手中的杖碰了一下饼和肉，火就从磐石中喷出来烧尽了它们。耶和华的天使也不见了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","基甸发现他果然是耶和华的天使，便说：“唉！主耶和华啊，不好了，我面对面见了你的天使。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","耶和华对他说：“放心吧，不要害怕，你不会死。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","基甸在那里为耶和华筑了一座坛，称之为“耶和华赐平安”。这坛如今仍在亚比以谢族的俄弗拉。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","那天晚上，耶和华吩咐基甸：“牵来你父亲的第二头牛，就是那头七岁的公牛，拆毁你父亲为巴力筑的祭坛，砍倒坛旁的亚舍拉神像。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","然后，在这座山顶上把石头堆放整齐，为你的上帝耶和华筑一座祭坛，用砍倒的亚舍拉神像作柴，把那头公牛献作燔祭。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","于是，基甸带了十个仆人遵命而行。不过，他因为害怕家人和城中的人，不敢在白天行动，便在夜间行动。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","清早，城里的人起来后，发现巴力的祭坛已经被人拆毁，坛旁的亚舍拉神像被砍倒，第二头公牛被献在新建的祭坛上。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","他们彼此议论说：“这是谁干的？”他们仔细调查后得知是约阿施的儿子基甸所为， ");
INSERT INTO cmncbs_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","便对约阿施说：“把你儿子交出来！他拆毁了巴力的祭坛，砍倒了坛旁的亚舍拉神像，我们要处死他！” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","约阿施对气势汹汹的人群说：“你们这样做是要为巴力辩护吗？是要救它吗？谁为巴力辩护，今天早晨就处死谁。有人拆毁巴力的祭坛，如果它是神明，就让它为自己辩护吧！” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","因此，那天他们称基甸为耶路·巴力，意思是“让巴力为自己辩护”，因为他拆毁了巴力的祭坛。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","那时，米甸人、亚玛力人及东方人会合在一起，过了约旦河，在耶斯列的平原安营。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","耶和华的灵降在基甸身上，他就吹响号角，号召亚比以谢族的人跟从他。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","他派人走遍玛拿西、亚设、西布伦和拿弗他利各支派召集军队，人们纷纷前来会合。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","基甸对上帝说：“若如你所言，你要用我去拯救以色列人， ");
INSERT INTO cmncbs_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","求你给个凭据。我把一团羊毛放在麦场上，若明天早晨只是羊毛上有露水，地面却是干的，我就知道，如你所言，你要用我去拯救以色列人。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","果然如此，基甸一早醒来，从羊毛中挤出满满一碗露水。 ");
INSERT INTO cmncbs_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","基甸又对上帝说：“求你不要发怒，容许我再试一次，这次让羊毛是干的，地面有露水。” ");
INSERT INTO cmncbs_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","那天晚上，上帝就照他所求使地面布满露水，唯独羊毛是干的。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","耶路·巴力，也就是基甸，清早起来，率领众人在哈律泉旁扎营，米甸人的军营在他们北边靠近摩利山的谷中。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","耶和华对基甸说：“你的人太多了，我不能把米甸人交在你们手中，免得以色列人以为是靠自己的力量救了自己。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","你要向他们宣布，胆小害怕的人可以离开基列山回家。”结果两万二千人离去，只剩下一万人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","但耶和华对基甸说：“人还是太多，你带他们到下面的泉水边，我会在那里为你挑选人员，我说谁跟你去谁就去，我说谁不能去谁就不要去。” ");
INSERT INTO cmncbs_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","于是，基甸把他们带到泉水边，耶和华对他说：“把像狗一样用舌头舔水喝的和跪着喝水的分开。” ");
INSERT INTO cmncbs_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","那时有三百人捧水舔着喝，其余的都跪着喝。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","耶和华对基甸说：“我要用这三百舔水喝的人拯救你们，我要把米甸人交在你手中。让其余的人都回家吧。” ");
INSERT INTO cmncbs_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","于是，基甸留下这三百人，把其余人的食物和号角收集起来，让他们回家。米甸人的军营就在他们下面的山谷里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","当晚，耶和华吩咐基甸说：“起来，下去攻打敌营吧！我已把敌人交在你手中了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","你如果害怕，可以和你的仆人普拉一起下到敌营， ");
INSERT INTO cmncbs_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","听听他们说什么，你就有胆量攻打敌营了。”于是，基甸就带着仆人普拉下到敌营旁。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","米甸人、亚玛力人及东方人像蝗虫一样布满山谷，他们的骆驼如海边的沙一样不计其数。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","基甸到了那里，听见一个人对同伴说：“我做了个梦，梦见一个大麦饼滚进米甸营中，把一个帐篷撞翻在地。” ");
INSERT INTO cmncbs_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","他的同伴说：“那不是别的，正是以色列人约阿施的儿子基甸的刀，上帝把米甸人和整个军营都交在他手中了。” ");
INSERT INTO cmncbs_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","基甸听了这梦和梦的解释，就俯伏敬拜上帝。他回到以色列人的营中，大声喊道：“起来吧，耶和华已经把米甸军营交在你们手中了。” ");
INSERT INTO cmncbs_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","基甸把三百人分成三队，分给他们号角和藏有火把的瓦瓶， ");
INSERT INTO cmncbs_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","对他们说：“你们要看我的行动，当我们走到敌营旁边时，我怎么做，你们也要怎么做。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","我们这队吹响号角时，你们也要在敌营四周吹响号角，高喊，‘为了耶和华！为了基甸！’” ");
INSERT INTO cmncbs_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","午夜初，守卫刚换班，基甸带着一百人来到米甸营旁。他们吹响号角，打破手中的瓦瓶。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","其余的二百人也吹响号角，打破瓦瓶。他们左手举着火把，右手拿着号角，高喊：“为耶和华和基甸而战！” ");
INSERT INTO cmncbs_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","他们在敌营周围各守其位，米甸全军边喊边逃。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","基甸的三百人一起吹响号角时，耶和华使米甸人自相残杀。他们逃往西利拉的伯·哈示他，一直逃到靠近他巴的亚伯·米何拉的边境。 ");
INSERT INTO cmncbs_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","基甸号召拿弗他利、亚设和玛拿西的以色列人追杀米甸败军， ");
INSERT INTO cmncbs_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","又派人到整个以法莲山区，吩咐当地人攻打米甸人，占据远至伯·巴拉一带的约旦河渡口。以法莲人都遵命而行， ");
INSERT INTO cmncbs_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","还生擒了米甸人的两名首领俄立和西伊伯。他们在俄立磐石上杀死了俄立，在西伊伯榨酒池杀了西伊伯。他们继续追杀米甸人，并带着俄立和西伊伯的人头穿过约旦河，交给基甸。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","后来，以法莲人对基甸说：“你攻打米甸人时为什么不召我们去？你为什么这样对待我们？”他们与他激烈地争论起来。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","基甸说：“我怎能比得上你们呢？以法莲人摘剩的葡萄岂不比我们亚比以谢族收获的葡萄更好吗？ ");
INSERT INTO cmncbs_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","上帝把两名米甸人的首领俄立和西伊伯交在了你们手中，我所做的怎能跟你们相比呢？”基甸这么一说，他们的怒气就平息了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","基甸率领他的三百人渡过约旦河，虽然疲惫不堪，仍紧追敌人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","基甸对疏割的人说：“我们在追赶西巴和撒慕拿两个米甸王，十分疲惫，请给我的军队一些饼吃。” ");
INSERT INTO cmncbs_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","疏割的首领却说：“你还没有抓到西巴和撒慕拿，我们凭什么给你的军队饼吃？” ");
INSERT INTO cmncbs_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","基甸说：“好吧，耶和华把西巴和撒慕拿交在我们手中后，我必回来用荒野的荆棘抽打你们。” ");
INSERT INTO cmncbs_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","基甸又去毗努伊勒提出同样的请求，他们的答复跟疏割人一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","基甸对那里的人说：“我平安归来时，必拆毁你们的这座城楼。” ");
INSERT INTO cmncbs_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","那时，西巴和撒慕拿率领东方各族的残余军队一万五千人驻扎在加各，因为已经有十二万刀兵被杀。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","基甸取道挪巴和约比哈东边游牧者走的路，出其不意地突袭米甸人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","米甸二王西巴和撒慕拿逃跑，基甸追上去擒住他们，击溃他们全军。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","约阿施的儿子基甸从战场返回，经过希列斯山坡时， ");
INSERT INTO cmncbs_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","抓住一个疏割的青年，问他疏割的首领和长老是谁，他就写下疏割七十七位首领和长老的名字。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","基甸到了疏割，对那里的人说：“你们曾经讥笑我说，‘你还没有抓到西巴和撒慕拿，我们凭什么给你疲惫的军队饼吃？’看！西巴和撒慕拿在这里！” ");
INSERT INTO cmncbs_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","说完，就捉住城中的长老，用荒野的荆棘抽打他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","他又去拆毁毗努伊勒的城楼，杀了城里的人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","基甸问西巴和撒慕拿：“你们在他泊山杀的人是什么样子？”他们回答说：“他们长得像你，都像王子一样。” ");
INSERT INTO cmncbs_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","基甸说：“他们是我同母所生的兄弟，我凭永活的耶和华起誓，如果你们当初不杀他们，今天我就不杀你们了。” ");
INSERT INTO cmncbs_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","于是，基甸对长子益帖说：“你杀死他们。”但益帖年纪小，心中害怕，不敢动手。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","西巴和撒慕拿对基甸说：“你亲自动手吧！这是男子汉做的事。”基甸便亲手杀了他们，拿走了他们骆驼颈上的月牙饰物。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","以色列人对基甸说：“你从米甸人手中救了我们，请你和你的子孙统治我们。” ");
INSERT INTO cmncbs_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","基甸回答说：“我和我子孙都不统治你们，统治你们的是耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","他又说道：“我有一个要求，请你们把抢来的耳环都给我。”原来米甸人属于以实玛利族，都戴金耳环。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","他们欣然同意，便铺开一件外衣，各自把抢来的金耳环都放在上面， ");
INSERT INTO cmncbs_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","重约二十公斤。此外，还有米甸王的月牙饰物、耳坠、紫袍以及骆驼颈上的金链。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","基甸用这些金子造了一件以弗得圣衣，放在自己的家乡俄弗拉。后来，以色列人拜那件以弗得，玷污自己，使基甸及其全家陷入网罗。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","这样，米甸人被以色列人征服了，从此一蹶不振。基甸在世之日，以色列境内安享太平四十年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","约阿施的儿子耶路·巴力返回家乡居住。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","他有许多妻子，生了七十个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","他的妾住在示剑，也给他生了一个儿子，他给孩子取名叫亚比米勒。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","约阿施的儿子基甸年高寿终，葬在亚比以谢族的俄弗拉，在他父亲约阿施的坟墓里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","基甸刚去世，以色列人便又与巴力苟合，奉巴力·比利土为他们的神明， ");
INSERT INTO cmncbs_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","忘记了他们的上帝耶和华曾经从四围的仇敌手中拯救他们， ");
INSERT INTO cmncbs_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","也没有因耶路·巴力，就是基甸的功绩而厚待他的家人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","耶路·巴力的儿子亚比米勒去示剑的舅舅家，对外祖父全家说： ");
INSERT INTO cmncbs_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","“请你们去问示剑人，耶路·巴力的七十个儿子统治他们好呢，还是一个人统治他们好呢？别忘记我是你们的骨肉至亲。” ");
INSERT INTO cmncbs_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","他们便将他的话转告示剑人。示剑人因为亚比米勒是他们的亲戚，都拥护他， ");
INSERT INTO cmncbs_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","从巴力·比利土的庙里拿了七十块银子给他。他用这些钱收买了一班无赖做随从。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","他前往俄弗拉，来到他父亲家，在一块磐石上杀死了他七十个同父异母的兄弟，只有耶路·巴力的小儿子约坦躲了起来，幸免于难。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","示剑和米罗的人都聚集到示剑石柱旁的橡树下，拥立亚比米勒为王。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","约坦听见这消息，便上到基利心山顶，高喊：“示剑人啊，你们要听我说，这样上帝也会听你们说。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","从前，树木要选一个王，它们对橄榄树说，‘你来做我们的王。’ ");
INSERT INTO cmncbs_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","橄榄树说，‘我怎能因为贪图凌驾于众树之上而停止出产用来尊崇神明与人的橄榄油呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","树木对无花果树说，‘你来做我们的王。’ ");
INSERT INTO cmncbs_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","无花果树说，‘我怎能因为贪图凌驾于众树之上而停止出产甜美的果子呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","于是，树木对葡萄树说，‘你来做我们的王。’ ");
INSERT INTO cmncbs_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","葡萄树说，‘我怎能因为贪图凌驾于众树之上而停止出产令神明和世人都快乐的美酒呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","最后，所有的树木都对荆棘说，‘你来做我们的王。’ ");
INSERT INTO cmncbs_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","荆棘回答说，‘你们如果诚心立我为你们的王，就投靠在我的荫下吧；不然，愿火从荆棘中冒出来吞噬黎巴嫩的香柏树。’ ");
INSERT INTO cmncbs_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","“现在你们立亚比米勒为王，光明正大吗？你们有没有善待耶路·巴力和他一家？有没有按他的功绩对待他？ ");
INSERT INTO cmncbs_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","你们想想，从前我父亲为你们出生入死，从米甸人手中拯救你们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","现在你们却背叛我父亲家，在一块磐石上杀死他七十个儿子。因为他婢女的儿子亚比米勒是你们的亲戚，你们就立亚比米勒为示剑居民的王。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","如果你们光明正大地对待了耶路·巴力一家，愿你们给亚比米勒带来快乐，也愿亚比米勒给你们带来快乐。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","否则，愿亚比米勒烧灭你们示剑人和米罗人，也愿你们示剑人和米罗人烧灭亚比米勒。” ");
INSERT INTO cmncbs_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","约坦因惧怕他的兄弟亚比米勒，就逃往比珥居住。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","亚比米勒治理以色列三年后， ");
INSERT INTO cmncbs_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","上帝派遣一个邪灵挑起亚比米勒和示剑人之间的争端，示剑人用诡诈的手段对待亚比米勒。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","这是要惩罚亚比米勒和帮他残杀耶路·巴力七十个儿子的示剑人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","示剑人在山顶设下埋伏，等候亚比米勒，他们抢劫所有过路的行人。有人把这事告诉了亚比米勒。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","以别的儿子迦勒和他的弟兄来到示剑，示剑人都信任他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","示剑人出城到田间采摘葡萄，踩榨葡萄汁，然后在他们的神庙中欢宴，尽情吃喝，咒诅亚比米勒。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","以别的儿子迦勒说：“亚比米勒是谁？我们示剑人是谁，竟要服侍他？他不就是耶路·巴力的儿子吗？他的帮手不就是西布勒吗？我们为什么要服侍他？你们要服侍示剑人祖先哈抹的后代。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","要是这百姓归我领导就好了！我会除掉亚比米勒，我会挑战他召集全军来战。” ");
INSERT INTO cmncbs_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","示剑城的官长西布勒听见以别的儿子迦勒的话，勃然大怒， ");
INSERT INTO cmncbs_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","暗中派人对亚比米勒说：“以别的儿子迦勒和他的弟兄已经到了示剑，正在煽动全城反对你。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","请你晚上带着部下埋伏在田间， ");
INSERT INTO cmncbs_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","清晨日出时攻城。迦勒带着部下出来应战时，你便可以见机行事。” ");
INSERT INTO cmncbs_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","于是，亚比米勒带领军队夜间出发，兵分四路埋伏在示剑城外。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","早晨，以别的儿子迦勒出来站在城门口时，亚比米勒带领部下从埋伏的地方冲了出来。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","迦勒看见他们，便对西布勒说：“看！有人正从山顶下来。”西布勒说：“你把山影看成人了吧。” ");
INSERT INTO cmncbs_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","迦勒说：“看！有人正从山上下来，还有一队人正从占卜橡树那边的路上奔来。” ");
INSERT INTO cmncbs_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","西布勒说：“你的豪气哪里去了？你曾说，‘亚比米勒是谁，我们竟要服侍他？’这些不就是你讥笑的人吗？出去迎战吧！” ");
INSERT INTO cmncbs_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","于是，迦勒率领示剑人出城迎战亚比米勒。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","迦勒败逃，亚比米勒紧追不舍，沿途有许多人受伤倒在地上，一直到城门口。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","之后，亚比米勒住在亚鲁玛，西布勒把迦勒和他的弟兄逐出示剑。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","第二天，示剑人出城来到田间。亚比米勒得知后， ");
INSERT INTO cmncbs_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","把部下兵分三队，埋伏在田间，等城里的人出来时，伏击他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","亚比米勒率领一队人冲到示剑的城门口，截断示剑人的退路，其他两队击杀田间的示剑人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","亚比米勒鏖战一天，攻陷了示剑城，杀了城内的居民，把整座城夷为平地，还撒上了盐。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","示剑楼的人听到风声，躲进了伊勒·比利土神庙的内堂。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","亚比米勒得知他们都聚在那里后， ");
INSERT INTO cmncbs_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","便领兵上撒们山用斧头砍下树枝，扛在肩上，并命令部下赶紧照做。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","他们都砍下树枝，跟着亚比米勒把树枝堆在神庙内堂的四周，放火烧死了示剑楼里所有的人，男女约一千人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","随后，亚比米勒去围攻提备斯，占领了该城。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","全城的人连男带女都逃进城中一座坚固的城楼内，锁上大门，爬上楼顶。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","亚比米勒攻打城楼，走到城楼门口正准备放火时， ");
INSERT INTO cmncbs_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","有个妇人扔下一块磨石，砸烂了他的头。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","亚比米勒连忙对为他拿兵器的年轻人说：“拔刀杀了我吧，免得人们说，‘一位妇人杀了他。’”于是，那年轻人刺死了他。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","以色列人见亚比米勒已死，便各自回家了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","上帝就这样使亚比米勒得到了报应，因为他残杀了自己的七十个兄弟， ");
INSERT INTO cmncbs_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","上帝也让示剑人因自己的一切恶行而得到了报应。耶路·巴力的儿子约坦的咒诅临到了他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","亚比米勒死后，以萨迦人陀拉拯救了以色列人。他住在以法莲山区的沙密，祖父是朵多，父亲是普瓦。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","陀拉做以色列的士师二十三年，死后葬在沙密。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","之后，基列人雅珥做以色列的士师二十二年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","他有三十个儿子，每人骑一头驴。他们在基列拥有三十座城，那些城到现在还叫“雅珥之城”。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","雅珥死后，葬在加们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","后来，以色列人又做耶和华视为恶的事，祭拜巴力和亚斯她录，又拜亚兰、西顿、摩押、亚扪和非利士的神明。他们背弃耶和华，不再事奉祂。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","耶和华向他们发怒，把他们交在非利士人和亚扪人手中。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","那年，非利士人和亚扪人击垮了以色列人，压迫基列地区、约旦河东亚摩利境内的以色列人达十八年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","亚扪人还渡过约旦河攻击犹大、便雅悯和以法莲支派，使以色列人苦不堪言。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","于是，他们呼求耶和华说：“我们背弃我们的上帝去祭拜巴力，我们得罪了你。” ");
INSERT INTO cmncbs_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","耶和华对他们说：“你们受埃及人、亚摩利人、亚扪人、非利士人、 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","西顿人、亚玛力人和马云人的压迫，就呼求我，我岂没有拯救你们吗？ ");
INSERT INTO cmncbs_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","但你们竟背弃我，去事奉其他神明，所以我不再救你们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","你们去呼求自己选择的神明吧！你们有难，让他们救你们吧！” ");
INSERT INTO cmncbs_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","他们对耶和华说：“我们犯了罪，任你处置我们，只求你今天拯救我们。” ");
INSERT INTO cmncbs_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","以色列人除掉了他们的外邦神像，转而事奉耶和华。耶和华不忍再看以色列人受苦。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","当时，亚扪人整装备战，在基列安营；以色列人也集合起来，在米斯巴安营。 ");
INSERT INTO cmncbs_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","基列的首领们彼此商议说：“谁先攻打亚扪人，谁就做所有基列人的首领。” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","基列人耶弗他是个英勇的战士，他父亲名叫基列，母亲是个妓女。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","基列的妻子还生了几个儿子，他们长大后，便把耶弗他赶出家门，说：“你是别的女人生的，你休想继承我们父亲的任何产业。” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","耶弗他只好逃走，住在陀伯地区。有一群匪徒聚集到他身边，跟随了他。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","后来，亚扪人攻打以色列， ");
INSERT INTO cmncbs_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","基列的众长老就去陀伯请耶弗他， ");
INSERT INTO cmncbs_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","对他说：“请你回来做统帅带领我们对抗亚扪人。” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","耶弗他说：“从前你们不是厌恶我，把我从父亲家赶走的吗？现在你们遭难，为什么来找我？” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","基列的众长老说：“我们现在是来请你跟我们一起回去抵抗亚扪人，你可以做所有基列人的首领。” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","耶弗他说：“如果你们请我回去与亚扪人作战，耶和华让我打败他们，我就真的可以做你们的首领吗？” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","基列的首领们说：“我们必听从你的吩咐，有耶和华为我们作证。” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","于是，耶弗他便跟他们一起回去。民众拥立他做他们的首领和元帅。耶弗他在米斯巴将之前所说的话在耶和华面前重申一遍。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","然后，他派遣使者去问亚扪王：“你与我有什么相干？为什么要攻打我的领土？” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","亚扪王对他的使者说：“因为以色列人从埃及出来的时候占据了我们的土地，从亚嫩河到雅博河，一直到约旦河。现在你们要和平地归还我们。” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","耶弗他再差遣使者去见亚扪王， ");
INSERT INTO cmncbs_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","对他说：“以色列人并没有占据摩押和亚扪的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","当年以色列人离开埃及，经旷野渡过红海来到加低斯， ");
INSERT INTO cmncbs_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","然后派遣使者去见以东王，说，‘求你让我们经过你的领土。’以东王却不答应。他们又派遣使者去见摩押王，摩押王也不答应。于是，以色列人就住在加低斯。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","后来，他们走过旷野，绕过以东和摩押，到了摩押的东边，在摩押的边界亚嫩河东岸扎营，并没有进入摩押境内。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","以色列人派遣使者去见希实本的亚摩利王西宏，对他说，‘求让我们经过你的领土前往我们自己的土地。’ ");
INSERT INTO cmncbs_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","但西宏不信任以色列人，拒绝了他们的请求，并招聚全军驻扎在雅杂，攻打他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","但以色列的上帝耶和华帮助以色列人战胜西宏和他的军队，占领了亚摩利人所有的土地， ");
INSERT INTO cmncbs_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","从亚嫩河直到雅博河，从旷野直到约旦河。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","既然是以色列的上帝耶和华为祂的以色列子民赶走了亚摩利人，你凭什么要夺取这块土地？ ");
INSERT INTO cmncbs_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","你拥有你们的神明基抹给你们的土地，我们也要拥有我们的上帝耶和华赐给我们的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","难道你比摩押王西拨的儿子巴勒更强吗？他从未挑战过以色列人，也未和以色列人交过战。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","三百年来，以色列人一直住在希实本及其周围的乡村、亚罗珥及其周围的乡村和亚嫩河沿岸一带的城邑。在这期间，你们为什么不收回这些土地呢？ ");
INSERT INTO cmncbs_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","我们没有得罪你们，你们却攻打我们。愿审判者耶和华今天在以色列人和亚扪人之间主持公道。” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","可是，亚扪王不理会耶弗他派使者所传的话。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","那时，耶和华的灵降在耶弗他身上，他便经过基列和玛拿西，来到基列的米斯巴，然后从那里去迎战亚扪人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","他向耶和华许愿说：“如果你把亚扪人交在我手中， ");
INSERT INTO cmncbs_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","让我平安归来，第一个从我家门出来迎接我的人必归给你，我必把他献给你作燔祭。” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","于是，耶弗他率军与亚扪人作战，耶和华把敌人交在他手中， ");
INSERT INTO cmncbs_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","他大败敌军，摧毁了从亚罗珥到米匿、远至亚备勒·基拉明的二十座城。这样，以色列人征服了亚扪人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","耶弗他返回自己在米斯巴的家，他的独生女儿敲着鼓、跳着舞出来迎接他。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","他一见自己的女儿，便撕裂衣服，说：“唉，我的女儿啊，你真让我伤心欲绝，祸患临头！我向耶和华许了愿，不能收回了！” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","他女儿说：“父亲啊，你既然向耶和华许了愿，就照你许的愿对待我吧！因为耶和华帮你打败了敌军亚扪人，为你报了仇。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","但求你先给我两个月的时间，让我和同伴到山上去为我终身未嫁哀哭。” ");
INSERT INTO cmncbs_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","耶弗他答应了，给了她两个月的时间。于是，她便和同伴到山上为自己终身未嫁哀哭。 ");
INSERT INTO cmncbs_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","两个月后，她回到父亲那里。她父亲履行了自己所许的愿。她从未与男人同房。自此以后，在以色列有个习俗： ");
INSERT INTO cmncbs_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","每年以色列的女子都去为基列人耶弗他的女儿哀哭四天。 ");
INSERT INTO cmncbs_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","后来，以法莲人召集军队，渡过约旦河来到撒分。他们对耶弗他说：“你为什么不召我们一起去攻打亚扪人呢？我们要把你和你的房子一起烧掉。” ");
INSERT INTO cmncbs_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","耶弗他说：“我和我的人民与亚扪人激战时，我曾召你们参战，你们却不肯来援救我们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","我见你们不来援救，只好冒死去迎战亚扪人，耶和华把敌人交在了我手中。你们今天为什么来攻打我呢？” ");
INSERT INTO cmncbs_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","以法莲人说：“你们这些在以法莲和玛拿西境内的基列人不过是以法莲的逃兵。”于是，耶弗他号召基列人起来迎战以法莲人，打败了他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","基列人占据约旦河各渡口，不让以法莲人过去。如果有以法莲的逃兵请求过河，基列人便问他：“你是以法莲人吗？”如果他否认， ");
INSERT INTO cmncbs_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","他们就让他说“示播列”。以法莲人因为咬字不清，会把“示播列”说成“西播列”，基列人便抓住他，在约旦河渡口处死他。那时，有四万二千名以法莲人被杀。 ");
INSERT INTO cmncbs_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","基列人耶弗他做以色列的士师六年，死后葬在基列的一座城里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","耶弗他死后，伯利恒人以比赞做以色列的士师。 ");
INSERT INTO cmncbs_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","他有三十个儿子、三十个女儿，他从别的宗族给儿子们娶来三十个媳妇，又把女儿都嫁到别的宗族。他做以色列的士师七年， ");
INSERT INTO cmncbs_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","死后葬在伯利恒。 ");
INSERT INTO cmncbs_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","以比赞死后，西布伦人以伦做以色列的士师十年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","他死后葬在西布伦的亚雅仑。 ");
INSERT INTO cmncbs_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","以伦死后，比拉顿人希列的儿子押顿做以色列的士师。 ");
INSERT INTO cmncbs_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","他有四十个儿子、三十个孙子，他的儿孙每人骑一头驴。押顿做以色列的士师八年， ");
INSERT INTO cmncbs_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","他死后葬在以法莲的比拉顿，在亚玛力人的山区。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","以色列人又做耶和华视为恶的事，耶和华就把他们交在非利士人手中四十年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","琐拉城住了一个但支派的人，名叫玛挪亚。他妻子不能生育，没有孩子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","耶和华的天使向那妇人显现，对她说：“你虽然不生育，但不久你必怀孕生一个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","现在，你要留心，不可喝淡酒和烈酒，不可吃任何不洁之物。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","你必怀孕生一个儿子，你不可为他剃头，因为他一出生就要归给上帝做拿细耳人。他要从非利士人手中拯救以色列人。” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","妇人就去对丈夫说：“有一位上帝的仆人向我显现，他的容貌像上帝的天使，非常可畏。我没有问他从哪里来，他也没有把名字告诉我。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","他对我说，‘你必怀孕生一个儿子，现在不可喝淡酒和烈酒，不可吃任何不洁之物，因为孩子一出生就要献给耶和华，终生做拿细耳人。’” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","玛挪亚向耶和华祈求说：“主啊，求你再派你的仆人到这里来，教我们怎样照顾要出生的孩子。” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","上帝应允了他的祈求。他妻子正坐在田间的时候，上帝的天使再次向她显现。当时她丈夫玛挪亚不在场。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","她赶忙跑去告诉她丈夫说：“那天来的那人又向我显现了。” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","玛挪亚起来跟随妻子来到那人面前，问他：“跟我妻子说话的就是你吗？”他答道：“是我。” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","玛挪亚问道：“你的话应验以后，我们应该怎样抚养这孩子？他该做什么？” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","耶和华的天使说：“你的妻子必须谨记我的一切吩咐。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","她不可吃葡萄树所结的果实，淡酒和烈酒都不可喝，不可吃任何不洁之物。她必须遵行我的一切吩咐。” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","玛挪亚说：“请你留下来，我们要预备一只山羊羔给你吃。” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","当时，玛挪亚仍然不知道那人是耶和华的天使。天使说：“我就是留下来也不会吃你预备的食物。你如果预备燔祭，就把它献给耶和华吧！” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","玛挪亚说：“请告诉我你的名字，当一切应验的时候，我们好向你表达敬意。” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","耶和华的天使说：“何必问我的名字呢？我的名字奇妙难测。” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","于是，玛挪亚就把一只山羊羔和素祭放在磐石上，献给耶和华。就在这时候，天使在玛挪亚夫妇面前行了一件奇妙的事： ");
INSERT INTO cmncbs_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","火焰从祭坛上升起的时候，耶和华的天使也在祭坛的火焰中升上去了。玛挪亚夫妇见状便俯伏在地。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","耶和华的天使后来没再向玛挪亚夫妇显现，玛挪亚才知道他是耶和华的天使。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","玛挪亚对妻子说：“我们必死无疑，因为我们看见了上帝。” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","他妻子却说：“耶和华如果要杀我们，就不会接受我们的燔祭和素祭了，也不会让我们看见这些事，更不会这时候跟我们说这些话。” ");
INSERT INTO cmncbs_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","后来玛挪亚的妻子生了个儿子，她给孩子取名叫参孙。这孩子渐渐长大，耶和华赐福给他。 ");
INSERT INTO cmncbs_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","当他在琐拉和以实陶之间的玛哈尼·但的时候，耶和华的灵开始感动他。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","参孙下到亭拿，在那里看中了一个非利士女子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","他回到家里便对父母说：“我在亭拿看中一个非利士女子，把她给我娶来做妻子吧！” ");
INSERT INTO cmncbs_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","他父母说：“难道我们的亲族和同胞中没有合适的女子吗？你为什么要娶未受割礼的非利士人的女子呢？”参孙却说：“我很喜欢她，请给我把她娶过来吧！” ");
INSERT INTO cmncbs_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","他的父母不知道这事是出于耶和华的旨意，祂要找机会对付非利士人。那时，非利士人统治着以色列。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","参孙跟父母一起去亭拿，走到亭拿的葡萄园时，有一头猛狮吼叫着扑向他。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","耶和华的灵突然降在参孙身上，他虽然手无寸铁，竟撕裂了那头狮子，就像撕裂一只山羊羔一样。他没有把这事告诉父母。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","到了亭拿，参孙跟那女子交谈，很喜欢她。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","过了些日子，参孙下去迎娶她，途中他顺便去看那只死狮子，见死狮子体内有一群蜜蜂和一些蜂蜜， ");
INSERT INTO cmncbs_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","就用手取了一些蜜，边走边吃。到了父母那里，他给了他们一些，他们也吃了。但他没有告诉父母蜂蜜是从死狮子体内取的。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","参孙的父亲去那女子家，参孙按习俗摆设宴席。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","众人看见参孙，就安排了三十个人陪他。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","参孙对他们说：“我出一个谜语，如果你们可以在这七天的婚宴期间猜出来，我就送你们三十件细麻衣和三十件外袍。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","如果猜不中，你们就要给我三十件细麻衣和三十件外袍。”他们说：“请你出谜语吧！” ");
INSERT INTO cmncbs_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","参孙说： “食物出自食者， 甜物出自强者。” 三天过后，他们仍然猜不出来。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","到了第四天，他们对参孙的妻子说：“你要哄你的丈夫把谜底说出来，不然我们就把你和你父亲一家全烧死。你们邀请我们来，难道是要夺取我们的家产吗？” ");
INSERT INTO cmncbs_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","于是，参孙的妻子向他哭诉说：“你是恨我，不是爱我。你给我的族人出了谜语，却没有告诉我谜底。”参孙回答说：“我连父母都没有告诉，又怎能告诉你呢？” ");
INSERT INTO cmncbs_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","在七天的婚宴期间，她一直在丈夫跟前哭哭啼啼。到了第七天，参孙经不住妻子的催逼就把谜底告诉了她。她把谜底告诉了她的族人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","在第七天日落之前，城里的人对参孙说： “有什么比蜂蜜更甜？ 有什么比狮子更强？” 参孙说： “你们若不是利用我的小母牛耕田， 肯定猜不出来。” ");
INSERT INTO cmncbs_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","耶和华的灵突然降在参孙身上，他便去亚实基伦杀了三十个人，取走他们的衣服，交给猜中谜语的那些人，然后怒气冲冲地回父亲家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","参孙的妻子后来归了他的伴郎。 ");
INSERT INTO cmncbs_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","过了些日子，在割麦的时候，参孙带着一只山羊羔去探望他妻子。他说：“我要进内室见我妻子。”他岳父却不让他进去， ");
INSERT INTO cmncbs_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","并对他说：“我以为你非常恨她，所以我把她改嫁给你的伴郎了。她妹子不是比她更美吗？你可以娶来代替她。” ");
INSERT INTO cmncbs_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","参孙说：“这次我要加害非利士人，可不能怪我了。” ");
INSERT INTO cmncbs_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","于是，他出去捉了三百只狐狸，把它们的尾巴一对一对绑起来，将火把绑在两条尾巴中间， ");
INSERT INTO cmncbs_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","然后点燃火把，把狐狸放进非利士人的麦田里，将割好的麦捆和未割的麦子、葡萄园和橄榄园都烧毁了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","非利士人问：“这是谁干的？”有人回答说：“是亭拿人的女婿参孙干的，因为他岳父把他的妻子嫁给了他的伴郎。”非利士人就去放火烧死了参孙的妻子和岳父。 ");
INSERT INTO cmncbs_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","参孙说：“你们既然这样做，我不向你们报仇誓不罢休。” ");
INSERT INTO cmncbs_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","参孙大肆击杀他们，杀死了很多人。事后，他下到以坦，住在那里的岩洞里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","非利士人进犯犹大，在利希一带扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","犹大人问他们：“你们为什么来攻打我们？”非利士人回答说：“我们来捉拿参孙，向他以报还报。” ");
INSERT INTO cmncbs_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","于是，有三千犹大人去以坦的岩洞找参孙，对他说：“难道你不知道非利士人是我们的统治者吗？你为什么连累我们？”参孙回答说：“我只是以牙还牙。” ");
INSERT INTO cmncbs_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","犹大人说：“我们来是要捉拿你，把你交给非利士人。”参孙说：“你们要起誓不会亲手杀我。” ");
INSERT INTO cmncbs_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","他们说：“我们不会杀你，只将你绑起来交给非利士人。”于是，他们用两根新绳子把参孙捆绑起来带出岩洞。 ");
INSERT INTO cmncbs_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","参孙来到利希，非利士人就呐喊着迎了上去。耶和华的灵突然降在参孙身上，绑在他手臂上的绳子就像被火烧的麻线一样脱落下来。 ");
INSERT INTO cmncbs_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","他看到一块还没有干的驴腮骨，就捡起来用它杀了一千个非利士人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","参孙说： “用这驴腮骨，我杀人成堆； 用这驴腮骨，我杀死千人。” ");
INSERT INTO cmncbs_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","说完，他扔掉了手中的驴腮骨。因此，那地方叫拉末·利希。 ");
INSERT INTO cmncbs_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","参孙觉得非常口渴，便向耶和华呼求说：“你既然借着仆人的手大败敌人，难道你会让我渴死、落在这些未受割礼的人手中吗？” ");
INSERT INTO cmncbs_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","于是，上帝使利希的一处洼地裂开，涌出水来。参孙喝后恢复了精神。因此，那水泉叫隐·哈歌利。那水泉今天还在利希。 ");
INSERT INTO cmncbs_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","在非利士人统治期间，参孙做以色列的士师二十年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","一天，参孙去迦萨，看见一个妓女，就与她亲近。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","迦萨人得知参孙来了，便包围那地方，整夜埋伏在城门口，没有动手，心想：“等天一亮，我们就杀掉他。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","可是，参孙睡到半夜就起来，把城门的门扇连门框和门闩一同拆下，扛到希伯仑对面的山顶上。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","后来，参孙在梭烈谷爱上一位名叫大利拉的女子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","非利士人的首领就上去见这女子，对她说：“请你哄参孙说出他为何有这么大力气，我们怎样才能制服他，把他绑起来。事后，我们每人会给你一千一百块银子。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","于是，大利拉问参孙：“求你告诉我，你为什么有这么大力气？用什么办法才能把你绑起来制服你？” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","参孙说：“如果他们用七根还没干的青绳子绑住我，我就会像普通人一样软弱。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","非利士人的首领便把七根还没干的青绳子交给大利拉，她用那些绳子把参孙绑起来。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","有人已预先埋伏在她的内室，于是她喊道：“参孙，非利士人来捉你了！”但参孙挣断了绳子，就像挣断火烧过的麻线一样。因此，仍然没有人知道他为何力气过人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","大利拉对参孙说：“你说谎捉弄我。现在请你告诉我，用什么方法才能绑住你？” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","参孙回答说：“如果他们用从未用过的新绳子绑住我，我就会像普通人一样软弱。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","于是，大利拉让人埋伏在内室，她用七根新绳子绑住参孙，然后喊道：“参孙，非利士人来捉你了！”结果，参孙挣断了手臂上的绳子，就像挣断一根线一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","大利拉对参孙说：“到现在你还是说谎捉弄我。请你告诉我，用什么方法才能绑住你？”参孙说：“你把我的七根发辫和织布机的线编在一起，用梭子扎紧，我就会像普通人一样软弱。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","于是，大利拉把他的发辫和织布机的线编在一起，用梭子扎紧，然后喊道：“参孙，非利士人来捉你了！”参孙醒来，挣脱了织布机的梭子和线。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","大利拉对参孙说：“你既然不跟我说真心话，还说什么爱我！你捉弄了我三次，没告诉我你为何力气过人。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","大利拉天天在他跟前唠叨不停，以致他烦得要死， ");
INSERT INTO cmncbs_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","就把秘密告诉了她。他说：“我从不剃发，因为我一出生就献给上帝做拿细耳人了。如果剃掉我的头发，我就会失去力气，像普通人一样软弱。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","大利拉见他说出了心中的秘密，就派人去通知非利士人的首领，说：“你们再来一次吧，他已经把秘密告诉我了。”于是，他们带着银子去了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","大利拉哄参孙枕着她的腿睡觉，然后叫人来剃掉他的七根发辫，使他力气尽失，无力反抗。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","她喊道：“参孙，非利士人来捉你了！”参孙醒来，心想：“我要像前几次一样挣脱捆绑。”他却不知道耶和华已经离开他了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","非利士人拿住他，剜了他的眼睛，把他带到迦萨，用铜链锁住他，让他在监牢里推磨。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","后来，他的头发又渐渐长出来了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","非利士人的首领聚在一起向他们的神明大衮献大祭，欢呼说：“我们的神把仇敌参孙交在我们手中了。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","众人看见参孙，就赞美他们的神明，说：“我们的神把仇敌交在我们手中了，他曾毁坏我们的田地，杀死我们许多人。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","他们都兴高采烈，并喊道：“把参孙带来让我们消遣消遣。”于是，有人把参孙从监牢里提出来供他们消遣，他们让他站在两根柱子中间。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","参孙对拉着他手的童仆说：“带我到支撑这庙宇的柱子那里，我想靠一靠。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","那时，庙里挤满了男男女女，非利士人的首领们都在场，房顶上还有三千男女看参孙的热闹。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","参孙呼求耶和华，说：“主耶和华啊，求你眷顾我！上帝啊，求你再赐给我一次力量，使我向非利士人报剜眼之仇。” ");
INSERT INTO cmncbs_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","参孙就抱住庙宇中央的两根柱子，一手抱一根， ");
INSERT INTO cmncbs_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","然后喊道：“我要跟非利士人同归于尽！”于是，他用尽全力推柱子，庙宇倒塌，压住里面的首领和民众。参孙死时杀的人比他活着时杀的还多。 ");
INSERT INTO cmncbs_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","参孙的兄弟和家人取走他的尸体，葬在琐拉和以实陶之间他父亲玛挪亚的墓地里。参孙做以色列的士师二十年。 ");
INSERT INTO cmncbs_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","以法莲山区住了一个名叫米迦的人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","他对母亲说：“你那一千一百块银子被拿走了，你因此说了咒诅的话，我都听见了。看啊，银子在我这里，是我拿去的。”他母亲说：“我儿啊，愿耶和华赐福给你！” ");
INSERT INTO cmncbs_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","米迦把一千一百块银子还给母亲。他母亲说：“我要为我儿把这些银子献给耶和华，用来雕刻、铸造神像。我会把银子交还给你。” ");
INSERT INTO cmncbs_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","米迦把银子还给母亲后，他母亲拿出二百块银子交给银匠雕刻、铸造神像，放在米迦的房子里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","米迦有一个神庙，他制造了一件以弗得和一些家庭神像，并指派他的一个儿子做祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","那时，以色列没有王，人人各行其是。 ");
INSERT INTO cmncbs_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","犹大的伯利恒住着一个年轻的利未人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","他离开伯利恒想到别的地方居住，一路走到以法莲山区米迦的家。 ");
INSERT INTO cmncbs_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","米迦问他：“你从哪里来？”他回答说：“我是从犹大的伯利恒来的利未人，要找一个住的地方。” ");
INSERT INTO cmncbs_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","米迦说：“你就住在我这里吧，做我的师父和祭司。我每年给你十块银子，还为你提供衣服和饮食。”利未人就进了米迦的家， ");
INSERT INTO cmncbs_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","住了下来。米迦待他就像待自己的儿子一样。 ");
INSERT INTO cmncbs_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","这样，米迦派他做祭司，让他住在自己家里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","米迦说：“现在我有一个利未人做我的祭司，我知道耶和华一定会恩待我。” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","那时以色列没有王。但支派的人正在寻找可以居住的地方，因为他们在以色列各支派中还没有得到属于自己的土地。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","但支派的人从琐拉和以实陶派本族的五名勇士去打探、察看那个地方，并吩咐说：“你们去察看那个地方。”他们到了以法莲山区，在米迦家里借宿。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","他们到了米迦家，听出那利未青年的口音，就转身进去问他：“谁带你来这里的？你在这里做什么？你为什么在这里？” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","那青年便把米迦聘他做祭司的事告诉了他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","他们说：“请你求问上帝，看看我们是否一路顺利。” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","祭司说：“你们安心去吧，耶和华会一路眷顾你们。” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","五人启程来到拉亿，发现当地人像西顿人一样无忧无虑，生活安宁，毫无防范，繁荣富足。他们离西顿很远，与外界没有来往。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","五人回到琐拉和以实陶后，族人问他们：“你们有什么发现吗？” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","他们回答说：“我们前去攻取那地方吧！我们已经打探清楚了，那地方非常好。你们还等什么？要赶快去占领那地方。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","你们到了那里，会看见当地的居民毫无防范，那里地大物博，一无所缺。上帝已经把那地方赐给我们了。” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","但支派便从琐拉和以实陶派出六百个带兵器的人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","他们来到犹大的基列·耶琳的西边安营。因此，那地方至今仍叫玛哈尼·但。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","然后，他们去以法莲山区，来到米迦的家。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","侦察过拉亿的五个人对其余的人说：“你们知道吗？这家有以弗得、一些家庭神像、一个雕刻的偶像和一个金属铸像。想一想我们该怎么办。” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","那五个人就进入米迦的家里，到年轻的利未人房间向他问安， ");
INSERT INTO cmncbs_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","随行的六百人带着兵器留在门口。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","当时祭司也和那六百个带兵器的人站在门口。那五个人进去拿走了雕刻的偶像、以弗得、家庭神像及金属铸像。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","祭司见那五人进入米迦家拿走雕刻的偶像、以弗得、家庭神像及金属铸像，就问他们：“你们在做什么？” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","他们说：“安静，别作声，跟我们来，做我们的师父和祭司吧。做以色列一个支派、一个宗族的祭司难道不比做一家人的祭司更好吗？” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","祭司听了非常高兴，就带着以弗得、家庭神像及雕刻的偶像跟随了他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","他们转身离去，儿女、牲畜和财物在队伍前面。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","他们离开米迦的家一段路后，米迦召集邻居赶了上来， ");
INSERT INTO cmncbs_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","向他们大喊。但支派的人转身问米迦：“你们召集这么多人来做什么？” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","米迦说：“你们带走了我的神像和祭司，把我洗劫一空，还问我想做什么！” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","但支派的人说：“别再多说了，不然我们当中性情暴躁的人会攻击你们，使你全家丧命。” ");
INSERT INTO cmncbs_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","但支派的人继续赶路。米迦见对方人多势众，就回家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","但支派的人带着米迦的神像和他的祭司来到拉亿，那里的人生活安宁，毫无防范。他们用刀杀掉当地的居民，放火烧了城。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","拉亿离西顿很远，当地的居民与外界没有来往，以致孤立无援。这城位于伯·利合附近的山谷中，但支派的人重建该城，住在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","这座城原来叫拉亿，他们用祖先以色列的儿子但的名字为该城重新命名。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","但支派的人把神像竖立起来，又指派摩西的孙子、革舜的儿子约拿单及其子孙做但支派的祭司，直到该地遭受掳掠为止。 ");
INSERT INTO cmncbs_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","上帝的会幕设立在示罗期间，米迦的神像一直竖立在但。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","那时候，以色列没有王。有一个利未人住在以法莲山区的偏远地带，他娶了犹大的伯利恒的一个女子为妾。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","那女子不忠，离开丈夫回到犹大的伯利恒的父亲家，住了四个月。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","后来，她丈夫带着一个仆人和两头驴去见她，用好话劝她回去。那女子带他去见自己的父亲。她父亲看见女婿来了，便热情地接待他， ");
INSERT INTO cmncbs_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","留他在家里小住。他便在那里住了三天，一起吃住。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","第四天，他清早起来准备回家，岳父对他说：“吃点东西补充体力后再走吧。” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","于是，二人坐下来一起吃喝。岳父对他说：“再住一夜，高兴高兴吧。” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","他不肯答应，起来要走，但岳父一再挽留，他就又住了一夜。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","第五天清早起来，他准备回家，岳父对他说：“吃点东西补充体力，太阳偏西再走吧。”于是，二人一同吃饭。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","他带着妾和仆人起来要走的时候，岳父对他说：“看啊，太阳偏西了，天色已晚，再住一夜高兴高兴，明天一早再走吧。” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","可是，他不愿意再留一夜，就备好两头驴，带着他的妾走了，来到耶布斯附近。耶布斯就是耶路撒冷。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","他们临近耶布斯时，天快黑了，仆人对主人说：“我们不如就在耶布斯人的城里住宿吧。” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","主人说：“我们不可在非以色列人的外邦城邑住宿，不如赶到基比亚。” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","他又说：“我们前往基比亚或拉玛住宿吧。” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","于是，他们继续前行，到便雅悯境内的基比亚时，天已经黑了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","他们决定在那里过夜。因为没有人接待他们，他们只好在城中的广场露宿。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","那时，有一个老人从田间工作回来，经过那里。他本来是以法莲山区的人，现在住在便雅悯境内的基比亚。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","他看见有人在城中的广场露宿，就问：“你们从哪里来，要到哪里去？” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","利未人回答说：“我们从犹大的伯利恒来，正要回家去。我住在以法莲山区的偏远地带。我现在要去耶和华的殿。这里没有人接待我。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","其实我有粮草喂驴，我和我的妾及仆人也有饼和酒，什么也不缺。” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","那老人说：“欢迎到我家来，我会供应你们的需要，千万不可在街头露宿。” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","于是，那老人带他们回家，喂他们的驴。他们洗完脚后，便一起吃喝。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","他们正欢乐的时候，城里的一群无赖前来围住房子，连连叩门，对年长的家主说：“把你家里的客人交出来，我们要跟他交合。” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","老人出去对他们说：“弟兄们啊，不要做这种恶事！这人是我的客人，不要干这种卑鄙的事！ ");
INSERT INTO cmncbs_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","我有个女儿，仍是处女，还有这人的妾，我把她们交出来，任你们玩弄，只是不要对这人干这种卑鄙的事。” ");
INSERT INTO cmncbs_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","他们却不肯听。利未人就把自己的妾推出去交给他们。他们强暴她，终夜凌辱她，直到天快亮才放她走。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","天亮时她回到丈夫住宿的房子门前，就仆倒在地。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","早晨，她丈夫起来打开房门要上路，发现她倒卧在门前，双手搭在门槛上， ");
INSERT INTO cmncbs_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","就对她说：“起来，我们走吧！”她却没有反应。于是，他就把她的尸体放在驴背上启程回家。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","回到家里，他用刀把尸体切成十二块，派人送往以色列全境。 ");
INSERT INTO cmncbs_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","看见的人都说：“自从以色列人离开埃及以来，这种事从未发生过，也从未见过。我们必须商量一下，看看该怎么办。” ");
INSERT INTO cmncbs_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","于是，从但到别示巴以及基列的全体以色列人齐心来到米斯巴，聚集在耶和华面前。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","以色列各支派的首领都参加了这次上帝子民的聚会，当时有四十万持刀的步兵。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","便雅悯人也听见以色列人聚集在米斯巴的消息。以色列人问那个利未人：“请告诉我们，这件邪恶的事是怎么发生的？” ");
INSERT INTO cmncbs_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","那利未人，就是被害女子的丈夫说：“我和我的妾到便雅悯的基比亚住宿。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","那天晚上，基比亚人攻击我，包围我们住宿的房子，要杀死我。他们把我的妾蹂躏致死。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","我就把她的尸体切成块，送到以色列的各个地区，因为基比亚人做了邪恶、无耻的事。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","以色列人啊，你们看该怎么处理吧！” ");
INSERT INTO cmncbs_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","众人起来异口同声地说：“我们谁也不回帐篷，谁也不回家。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","现在我们要抽签去攻打基比亚。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","我们要从各支派中抽出十分之一的人负责运粮，等军队到达便雅悯的基比亚后，就可以讨伐在以色列做出这种卑鄙之事的基比亚人。” ");
INSERT INTO cmncbs_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","于是，以色列人团结一致，一起去攻打那城。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","以色列各支派差人去对便雅悯各地的人说：“你们中间怎么发生了这种邪恶的事！ ");
INSERT INTO cmncbs_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","现在把那些基比亚的无赖交出来，我们要处死他们，从以色列铲除罪恶。”便雅悯人却充耳不闻， ");
INSERT INTO cmncbs_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","还从各城聚集到基比亚，要跟以色列人打仗。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","便雅悯人从各城召集了两万六千刀兵，还从基比亚召集了七百精兵。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","军中有七百精兵善用左手甩石，毫发不差。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","其他十一个以色列支派则召集了四十万刀兵，个个善战。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","以色列人到伯特利去求问上帝，说：“我们当中哪个支派应当先去攻打便雅悯人呢？”耶和华说：“犹大支派。” ");
INSERT INTO cmncbs_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","第二天清早，以色列人起来在基比亚附近安营， ");
INSERT INTO cmncbs_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","朝着便雅悯人摆开阵势，准备攻打他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","便雅悯人从基比亚出来，当天杀了以色列军两万二千人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","以色列人重整士气，仍在前一天列阵的地方列阵。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","列阵之前，他们在耶和华面前一直哀哭到晚上。他们求问耶和华，说：“我们应该再上去攻打我们的同胞便雅悯人吗？”耶和华说：“要上去攻打他们。” ");
INSERT INTO cmncbs_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","第二天，以色列人前去攻打便雅悯人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","便雅悯人从基比亚出来迎战，又杀了以色列军一万八千刀兵。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","以色列全军来到伯特利，坐在耶和华面前哀哭，那天他们一直禁食到晚上，又在耶和华面前献上燔祭和平安祭。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","28","那时，上帝的约柜就在那里，亚伦的孙子、以利亚撒的儿子非尼哈任祭司。以色列人求问耶和华，说：“我们应该再去攻打我们的同胞便雅悯人吗？还是退兵？”耶和华说：“去攻打吧，因为明天我必把他们交在你们手中。” ");
INSERT INTO cmncbs_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","以色列人在基比亚周围设下伏兵。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","第三天，以色列人又像前两次一样在基比亚列阵，攻打便雅悯人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","便雅悯人前来迎战，被以色列人诱到城外。他们又像前两次一样击杀以色列人，大约三十名以色列人死在通往基比亚和伯特利的两条路上。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","便雅悯人说：“我们又像以前一样打败他们了。”但以色列人已经商议好，用诈败的方法诱敌离城到大路上来。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","以色列全军在巴力·他玛列阵反攻，埋伏在基比亚西面的以色列人也冲了出来。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","有一万以色列精兵从正面攻打基比亚，战事非常激烈。便雅悯人大祸临头了仍懵然不知。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","耶和华帮助以色列人战胜了便雅悯人。那天，以色列人杀了便雅悯两万五千一百刀兵。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","便雅悯人这才意识到自己战败了。 原来以色列人在便雅悯人面前诈败，因为他们仰仗在基比亚附近设下的伏兵。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","那些伏兵迅速冲进基比亚，用刀杀了全城的人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","以色列人和伏兵已有约定，伏兵在城内点起一股浓烟时， ");
INSERT INTO cmncbs_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","以色列人便转身杀回。便雅悯人杀了诈败的以色列军大约三十人，以为像以前一样打败了他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","这时基比亚城已浓烟滚滚，便雅悯人回头观望，只见全城浓烟四起。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","以色列人转身杀了回来，便雅悯人大惊失色，知道大祸临头了。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","他们从以色列人面前转身逃往旷野，却无法逃脱。以色列人从各城出来夹攻他们。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","以色列人围攻便雅悯人，一路追杀他们直到基比亚的东边。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","便雅悯人共死了一万八千名勇士。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","余下的人都逃往旷野的临门岩，沿途有五千人被杀。以色列人追杀他们，一直追到基顿，又消灭了他们两千人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","那天，便雅悯人共死了两万五千名英勇的刀兵， ");
INSERT INTO cmncbs_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","只有六百人逃到了临门岩，在那里住了四个月。 ");
INSERT INTO cmncbs_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","以色列人回师便雅悯境内，用刀将各城的男女老少以及牲畜全部杀死，又放火烧毁所有的城邑。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","以色列人曾在米斯巴起誓不把女儿嫁给便雅悯人。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","他们来到伯特利，坐在上帝面前放声痛哭，直到黄昏。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","他们说：“以色列的上帝耶和华啊，以色列现今为何少了一个支派呢？为何发生了这样的事呢？” ");
INSERT INTO cmncbs_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","第二天，众人清早起来在那里筑了一座祭坛，献上燔祭和平安祭。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","他们彼此议论说：“我们到米斯巴聚集在耶和华面前的时候，各支派中谁没有来呢？”原来，他们曾经起誓说：凡不到米斯巴聚集在耶和华面前的人都要被处死。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","以色列人为他们的同胞便雅悯人难过，说：“如今以色列绝了一个支派。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","我们曾经在耶和华面前起誓，决不把女儿嫁给便雅悯人，现在我们应该怎么办，才能使他们剩下来的人得到妻子呢？” ");
INSERT INTO cmncbs_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","他们又查问各支派中谁没有到米斯巴聚集在耶和华面前，结果发现基列·雅比人缺席， ");
INSERT INTO cmncbs_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","因为点兵的时候，没有一个基列·雅比人在场。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","于是，会众派出一万二千精兵，命令他们用刀杀掉基列·雅比人及其妇女和孩子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","他们对精兵说：“你们所要做的就是消灭所有的男子和已婚妇女。” ");
INSERT INTO cmncbs_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","他们在基列·雅比的居民中找到四百名处女，把她们带回迦南的示罗营地。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","全体会众又派人到临门岩去跟便雅悯人讲和。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","于是，便雅悯人返回了家乡，以色列人把从基列·雅比居民中留下来的四百个处女给他们做妻子，但还是不够。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","众人为便雅悯支派难过，因为耶和华使以色列少了一个支派。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","会众的长老说：“便雅悯支派的女子都死了，我们应该怎么办才能使余下的人有妻子呢？ ");
INSERT INTO cmncbs_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","便雅悯的余民必须成家立后，以免以色列失去一个支派。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","可是我们又不能把女儿嫁给他们，因为我们曾经起誓，‘把女儿嫁给便雅悯人的必受咒诅。’” ");
INSERT INTO cmncbs_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","有人想起在示罗每年都有耶和华的节期。示罗在利波拿以南、伯特利以北至示剑的大路东面。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","于是，他们对便雅悯人说：“你们去埋伏在葡萄园里， ");
INSERT INTO cmncbs_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","见到示罗的女子出来跳舞时，就冲出去各自抢一个，带回便雅悯做妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","倘若她们的父亲或弟兄前来抱怨，我们会说，‘求你们看在我们的情面上恩待他们，因为我们从战场上带回的女子不够分给他们做妻子。何况又不是你们把女儿嫁给他们的，所以罪不在你们。’” ");
INSERT INTO cmncbs_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","便雅悯人就依计行事，从跳舞的女子中各自抢了一个，带回自己的家乡做妻子。他们重建城邑，住在其中。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","于是，以色列人离开那里，各回自己的支派、宗族和家园。 ");
INSERT INTO cmncbs_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","那时，以色列没有王，人人各行其是。");
INSERT INTO cmncbs_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","在士师执政的时代，犹大发生了饥荒。有一个人带着妻子和两个儿子从犹大的伯利恒迁到摩押境内寄居。 ");
INSERT INTO cmncbs_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","这个人名叫以利米勒，妻子叫拿俄米，两个儿子分别叫玛伦和基连。他们都是犹大 伯利恒的以法他人。他们来到摩押，就在那里住了下来。 ");
INSERT INTO cmncbs_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","后来，拿俄米的丈夫以利米勒去世了，留下她和两个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","这两个儿子都娶了摩押的女子为妻，一个名叫俄珥巴，一个名叫路得。在那里住了大约十年后， ");
INSERT INTO cmncbs_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","玛伦和基连二人都去世了，只剩下拿俄米，没有了丈夫，也没有了儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","后来，拿俄米在摩押听说耶和华眷顾祂的子民，使他们五谷丰登，就带着两个儿媳妇准备回故乡。 ");
INSERT INTO cmncbs_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","她们离开所居住的地方，动身返回犹大。 ");
INSERT INTO cmncbs_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","拿俄米对两个儿媳妇说：“你们还是各回娘家去吧！愿耶和华恩待你们，就好像你们恩待死去的丈夫和我一样。 ");
INSERT INTO cmncbs_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","愿耶和华使你们都有机会再嫁，找到好归宿。”拿俄米说完了，就亲吻她们。她们都放声大哭， ");
INSERT INTO cmncbs_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","说：“不！我们要跟你一起回你的家乡。” ");
INSERT INTO cmncbs_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","拿俄米说：“我的女儿啊，回娘家去吧！为什么要跟我去呢？难道我还能生儿子做你们的丈夫吗？ ");
INSERT INTO cmncbs_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","回去吧！我的女儿啊，走吧！我已经老了，不可能再嫁人了。就算我还有指望，今晚能再结婚生子， ");
INSERT INTO cmncbs_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","难道你们能一直不嫁，等到他们长大吗？不要这样，我的女儿啊！这样你们会很苦，我就更苦了，因为耶和华伸手惩罚我。” ");
INSERT INTO cmncbs_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","她们又放声大哭，俄珥巴就亲吻婆婆，向她道别，但路得却依依不舍，不肯离去。 ");
INSERT INTO cmncbs_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","拿俄米说：“你看，你嫂嫂已经回她家乡和她拜的神明那里去了，你也跟着嫂嫂回去吧！” ");
INSERT INTO cmncbs_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","路得说：“不要逼我撇你而去。你往哪里去，我也要往哪里去；你住在哪里，我也要住在哪里；你的同胞就是我的同胞，你的上帝就是我的上帝； ");
INSERT INTO cmncbs_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","你死在哪里，我也死在哪里、葬在哪里。只有死才能把我们分开。否则，愿耶和华重重地惩罚我！” ");
INSERT INTO cmncbs_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","拿俄米见路得坚决要跟她走，就不再劝阻她了。 ");
INSERT INTO cmncbs_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","于是，二人便一同回到伯利恒。她们进了伯利恒，全城轰动。妇女们问：“这不是拿俄米吗？” ");
INSERT INTO cmncbs_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","拿俄米对她们说：“不要再叫我拿俄米了，叫我玛拉吧！因为全能者叫我过得好苦啊！ ");
INSERT INTO cmncbs_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","我曾满满地离开这里，现在耶和华却使我空空地回来。既然耶和华叫我受苦，全能者使我遭难，为何还叫我拿俄米呢？” ");
INSERT INTO cmncbs_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","拿俄米带着她的儿媳妇摩押女子路得从摩押回到了伯利恒，那时正是开始收割大麦的季节。 ");
INSERT INTO cmncbs_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","拿俄米的丈夫以利米勒有个亲戚，名叫波阿斯，是个有名望的财主。 ");
INSERT INTO cmncbs_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","摩押女子路得对拿俄米说：“让我到田里去，跟在那些愿意恩待我的人后面，捡些麦穗回来。”拿俄米说：“去吧，我的女儿！” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","于是，路得便去了。她恰巧来到以利米勒的亲戚波阿斯的田里，跟在收割的人后面捡麦穗。 ");
INSERT INTO cmncbs_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","当时，波阿斯刚好从伯利恒来到田间，向那些收割的工人问安说：“愿耶和华与你们同在。”他们回答说：“愿耶和华赐福给你。” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","波阿斯问负责收割的工头说：“那是谁家的女子？” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","工头回答说：“她是摩押女子，跟拿俄米刚从摩押回来。 ");
INSERT INTO cmncbs_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","她求我让她跟在收割的人后面，捡工人扎捆时遗落的麦穗。她一大早就来到这里，一直捡到现在，除了在凉棚里稍微坐了一会儿之外，几乎没有休息。” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","波阿斯对路得说：“姑娘，听我说，你不用到别人的田里去拾麦穗了，也不必离开这里，只管留下来跟我的女工在一起。 ");
INSERT INTO cmncbs_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","你看我的工人在哪一块田里收割，就跟着我的女工去，我已经吩咐工人不可欺负你。要是你渴了，就去水罐那里喝工人打回来的水。” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","路得就俯伏在地叩谢他，说：“我不过是个外族人，你为什么这样恩待我、体恤我？” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","波阿斯说：“自从你丈夫过世之后，你怎样善待婆婆，怎样离开父母和家乡来到素不相识的人当中，我都听说了。 ");
INSERT INTO cmncbs_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","愿耶和华照你所行的奖赏你！你来投靠在以色列的上帝耶和华的翅膀下，愿祂厚厚地赏赐你。” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","路得说：“我主啊！我真是在你面前蒙恩，虽然我连你的婢女都不如，你还好言安慰我。” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","吃饭的时候，波阿斯对路得说：“来，吃一点饼吧，可以蘸着醋吃。”路得便坐在那些收割工人旁边。波阿斯递给她一些烤好的麦穗。她吃饱了，还有剩余的。 ");
INSERT INTO cmncbs_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","当她起来又要去捡麦穗的时候，波阿斯就吩咐他的工人说：“你们要任由她捡，就算她从麦捆中捡麦穗，你们也不要为难她。 ");
INSERT INTO cmncbs_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","甚至要从麦捆中抽一些出来让她捡，不要责骂她。” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","于是，路得便在田间继续捡麦穗，到了黄昏，她把捡到的麦穗打了，大约有十公斤大麦。 ");
INSERT INTO cmncbs_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","她把捡来的麦子带回城里给婆婆拿俄米看，又把剩下来的食物给婆婆。 ");
INSERT INTO cmncbs_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","婆婆问她：“你今天在哪里拾麦穗？在哪里做工？愿那善待你的人蒙福！”她就告诉婆婆说：“今天我在一个名叫波阿斯的人那里工作。” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","拿俄米说：“愿耶和华赐福给他，他对活着的和过世的都是那么有情有义。”拿俄米又对路得说：“这人是我们的近亲，有为我们赎业的责任。” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","摩押女子路得说：“他还对我说，‘你可以跟在我的工人后面捡麦穗，直到他们把我的庄稼都收完为止。’” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","拿俄米对儿媳路得说：“我的女儿啊，你就跟他的女工一起到田里去，免得去别人的田里被欺负。” ");
INSERT INTO cmncbs_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","因此，路得便常跟波阿斯的女工在一起捡麦穗，直到大麦小麦都收割完毕。路得就这样陪伴婆婆过日子。 ");
INSERT INTO cmncbs_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","一天，路得的婆婆拿俄米对她说：“我的女儿啊，我实在应该为你找个好归宿，使你生活幸福。 ");
INSERT INTO cmncbs_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","波阿斯不是我们的亲戚吗？而且你又常与他的女工在一起。今晚他会在麦场簸大麦。 ");
INSERT INTO cmncbs_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","你要梳洗打扮、抹上香膏、换件衣服，然后去麦场，但不要让他认出你是谁。等他吃饱喝足， ");
INSERT INTO cmncbs_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","躺下睡觉的时候，你看准他躺卧的地方，去掀开盖在他脚上的被，躺在那里，到时他必定会告诉你该怎样做。” ");
INSERT INTO cmncbs_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","路得说：“好，我一定照你的吩咐去做。” ");
INSERT INTO cmncbs_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","于是，路得就到麦场去，照她婆婆吩咐的去做。 ");
INSERT INTO cmncbs_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","波阿斯吃过晚饭，心里舒畅，便躺在麦堆旁边睡着了。路得悄悄过去掀起盖在他脚上的被，躺在他脚旁。 ");
INSERT INTO cmncbs_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","到了半夜，波阿斯忽然惊醒，翻过身来，发现一个女子躺在他的脚旁， ");
INSERT INTO cmncbs_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","便问道：“你是谁？”她答道：“我是你的婢女路得，请用你的衣襟遮盖我，因为你是我的近亲。” ");
INSERT INTO cmncbs_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","波阿斯说：“姑娘，愿耶和华赐福给你，因为你一直对婆家情深义重，现在更是如此。你本来可以找一个富有或贫穷的年轻丈夫，然而你却没有这样做。 ");
INSERT INTO cmncbs_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","姑娘，不要害怕，你所说的一切，我都会去为你安排，城里所有的人都知道你是个贤德的女子。 ");
INSERT INTO cmncbs_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","不错，我是你的近亲，可是有一个人比我更近。 ");
INSERT INTO cmncbs_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","你今晚就留在这里，明天早上，如果他答应尽亲属的义务，就由他照顾你；如果他不肯，我凭永活的耶和华起誓，我会尽我的本分。现在你只管安心睡到天亮。” ");
INSERT INTO cmncbs_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","路得就躺在波阿斯的脚旁。天未亮，还看不清人的时候，路得就起来了。因为波阿斯曾对她说：“不可让别人知道有女人来过麦场。” ");
INSERT INTO cmncbs_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","离开的时候，波阿斯对她说：“把你的外衣拿来铺开。”路得就照做了。他用路得的外衣包了六簸箕大麦，帮她扛在肩上，她便回城了。 ");
INSERT INTO cmncbs_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","回到家中，婆婆问她：“女儿啊，怎么样了？”路得便将事情的经过都告诉了婆婆。 ");
INSERT INTO cmncbs_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","她又说：“那个人给了我六簸箕大麦，对我说，‘不要空手回去见你婆婆。’” ");
INSERT INTO cmncbs_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","拿俄米说：“女儿啊！你只管安静等候，看这事怎样发展，因为那人今天不把事情办妥，是绝不会休息的。” ");
INSERT INTO cmncbs_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","波阿斯来到城门口，坐在那里，恰巧看见他所说的那位至亲经过，便招呼他说：“某人啊，请过来坐一坐。”那人便走过来坐下。 ");
INSERT INTO cmncbs_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","波阿斯又邀请了城里的十位长老，对他们说：“请过来坐一坐。”他们都坐下以后， ");
INSERT INTO cmncbs_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","波阿斯便对那位至亲说：“拿俄米从摩押回来了，现在要卖我们族兄以利米勒的那块地， ");
INSERT INTO cmncbs_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","我想应该让你知道这件事。你最有权赎那块地，其次才是我，此外再没有别人了。如果你愿意赎回那块地，请你当着在座各位长老的面表明。如果不愿意，请你让我知道。”那人说：“我愿意赎。” ");
INSERT INTO cmncbs_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","波阿斯说：“那么，你从拿俄米手中买地的那天，也要娶已死之人的妻子摩押女子路得，好让死者继续在产业上留名。” ");
INSERT INTO cmncbs_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","那位至亲说：“那我就不能赎了，免得损害到我的产业。你来赎吧，我不能赎。” ");
INSERT INTO cmncbs_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","从前在以色列，买赎或交易有这样的规矩：一旦成交，一方要把鞋脱下来交给另一方，以色列人以此为成交的凭据。 ");
INSERT INTO cmncbs_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","那位至亲对波阿斯说：“你自己买吧！”他就把鞋脱了下来。 ");
INSERT INTO cmncbs_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","波阿斯向长老和所有在场的人说：“请各位今天为我作证，所有属于以利米勒、基连和玛伦的产业，我都从拿俄米手上买了。 ");
INSERT INTO cmncbs_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","同时，我要娶玛伦的遗孀摩押女子路得为妻，好使死者继续在产业上留名，免得他的名在本族本乡中消失。今天，请各位作证。” ");
INSERT INTO cmncbs_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","聚集在城门口的众人和长老都说：“我们愿意作证。愿耶和华使要进你家门的这女子，像建立以色列家的拉结和利亚一样。愿你在以法他家业兴隆，在伯利恒声名远扬。 ");
INSERT INTO cmncbs_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","愿耶和华借着这年轻女子赐你后裔，使你家像先祖犹大和她玛的儿子法勒斯家一样。” ");
INSERT INTO cmncbs_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","这样，波阿斯便娶了路得为妻，与她同房。耶和华使她怀孕生了一个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","妇女们对拿俄米说：“耶和华当受称颂！因为今日祂赐给你一位至亲，使你后继有人，愿这孩子在以色列得享盛名！ ");
INSERT INTO cmncbs_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","他必让你的生命重新得力，奉养你，使你安度晚年，因为他是爱你的儿媳妇所生的。有这儿媳妇比有七个儿子还要好！” ");
INSERT INTO cmncbs_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","拿俄米接过婴孩抱在怀中，照顾他。 ");
INSERT INTO cmncbs_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","邻居的妇女们说：“拿俄米有孩子了！”她们给孩子取名叫俄备得，这俄备得就是耶西的父亲，耶西是大卫的父亲。 ");
INSERT INTO cmncbs_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","以下是法勒斯的家谱：法勒斯生希斯仑， ");
INSERT INTO cmncbs_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","希斯仑生兰，兰生亚米拿达， ");
INSERT INTO cmncbs_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","亚米拿达生拿顺，拿顺生撒门， ");
INSERT INTO cmncbs_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","撒门生波阿斯，波阿斯生俄备得， ");
INSERT INTO cmncbs_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","俄备得生耶西，耶西生大卫。");
INSERT INTO cmncbs_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","有一个以法莲人名叫以利加拿，住在以法莲山区的拉玛·琐非城。他是苏弗的玄孙、托户的曾孙、以利户的孙子、耶罗罕的儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","他有两个妻子，一个叫哈娜，一个叫毗尼娜。毗尼娜有儿有女，哈娜却无儿无女。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","以利加拿每年都从家乡到示罗去敬拜万军之耶和华，献上祭物。当时以利的两个儿子何弗尼和非尼哈在那里做耶和华的祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","每逢献祭的日子，以利加拿就会把祭肉分给毗尼娜和她的儿女。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","但他会给哈娜双份祭肉，因为他爱哈娜，虽然耶和华使她不能生育。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","毗尼娜见耶和华使她不能生育，便常常刺激她、气她。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","年复一年都是这样。每年来到耶和华的殿时，毗尼娜总是惹她伤心哭泣，以致她吃不下饭。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","她的丈夫以利加拿对她说：“哈娜，你为什么哭？为什么不吃饭？为什么心里难过？有我不是比有十个儿子更好吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","一天，他们在示罗吃完饭后，哈娜站起来。当时，祭司以利正坐在耶和华殿门口的座位上。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","哈娜心中愁苦，一边向耶和华祷告一边伤心地哭泣。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","她向上帝许愿说：“万军之耶和华啊，如果你眷顾婢女的痛苦，不忘记婢女，赐给婢女一个儿子，我必让他终生事奉你，永不剃他的头。” ");
INSERT INTO cmncbs_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","哈娜在耶和华面前不住地祷告，以利注视着她的嘴唇。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","哈娜在心中默祷，只动嘴唇，不出声音，以利以为她喝醉了， ");
INSERT INTO cmncbs_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","便对她说：“你要醉到什么时候呢？醒醒酒吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","哈娜答道：“我主啊，我没有喝醉，我淡酒和烈酒都没有喝。我是心里非常愁苦，在耶和华面前倾诉心事。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","请不要以为我是堕落的女人，我充满悲伤和痛苦，所以一直在祷告。” ");
INSERT INTO cmncbs_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","以利说：“你安心地回去吧，愿以色列的上帝答应你的祈求。” ");
INSERT INTO cmncbs_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","哈娜说：“愿婢女在你面前蒙恩。”于是，她就去吃饭，不再愁容满面了。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","第二天，以利加拿一家清早起来敬拜耶和华，然后回到自己的家乡拉玛。以利加拿与哈娜同房，耶和华顾念哈娜， ");
INSERT INTO cmncbs_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","使她怀孕。她后来生了一个儿子，给孩子取名叫撒母耳，因为她说：“他是我向耶和华求来的。” ");
INSERT INTO cmncbs_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","第二年，以利加拿带全家人前往示罗，向耶和华献年祭并还所许的愿。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","哈娜没有跟他们同去，她告诉丈夫说：“孩子断奶以后，我会把他带去献给耶和华，让他永远住在那里。” ");
INSERT INTO cmncbs_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","以利加拿说：“就依你的意思吧。可以等孩子断了奶再去。愿耶和华成就祂的应许。”于是，她就留在家中哺养孩子，直到孩子断奶。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","孩子断奶以后，她就把年幼的孩子带到示罗耶和华的殿，并带去三头公牛、十公斤面粉和一袋酒。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","他们宰了一头公牛后，就把孩子带到以利面前。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","哈娜说：“我主啊，我敢在你面前起誓，我就是那一次站在你这里向耶和华祈求的妇人。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","我求耶和华赐给我这个孩子，祂应允了我的祈求。 ");
INSERT INTO cmncbs_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","现在，我将他献给耶和华，让他终身事奉耶和华。” 他便在那里敬拜耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","哈娜祷告说： “我的心因耶和华而欢喜， 我的角因耶和华而高举， 我的口向敌人夸耀， 我因耶和华的拯救而快乐。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","“耶和华圣洁无比， 独一无二， 没有磐石像我们的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","不要再骄横傲慢、口出狂言， 因为耶和华是无所不知的上帝， 祂衡量人的一切行为。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","勇士的弓被折断， 软弱的却有力量。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","素来丰衣足食的为糊口而当雇工， 本来食不果腹的却不再挨饿。 不育的妇人现在生了七个孩子， 儿女成群的妇人却孤独憔悴。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","耶和华掌管生死， 祂使人下到阴间，也使人起死回生。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","贫穷富足在于祂， 卑微高贵也在于祂。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","祂从灰尘中提拔穷苦的人， 从粪堆里提升贫贱的人， 使他们与王子同坐， 得享尊荣。 大地的根基属于耶和华， 祂在上面建立了世界。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","祂看顾祂圣民的脚步， 使恶人在黑暗中灭亡， 因为得胜不是靠人的勇力。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","跟耶和华对抗的人必被击溃， 祂必从天上用雷击打他。 祂必审判天下， 赐力量给祂所立的君王， 使受膏者的角高举。” ");
INSERT INTO cmncbs_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","以利加拿返回了拉玛，小撒母耳却留在了示罗，在祭司以利的带领下事奉耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","以利的两个儿子为人邪恶，不认识耶和华， ");
INSERT INTO cmncbs_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","对民众不守自己做祭司的职分。每当民众来献祭，还在煮祭肉的时候，他们的仆人便拿着三齿叉来， ");
INSERT INTO cmncbs_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","从罐里、鼎里、釜里或锅里插肉，把插上来的祭肉据为己有。他们这样对待所有到示罗来的以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","甚至在焚烧脂肪之前，祭司的仆人就来对献祭的人说：“把肉给祭司烤吧！他不要煮过的，只要生的。” ");
INSERT INTO cmncbs_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","如果献祭的人答道：“要先焚烧脂肪，之后你可以随便拿，”仆人便会说：“不，你现在就给我，不然我就要抢了。” ");
INSERT INTO cmncbs_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","在耶和华的眼中，这两个青年罪恶深重，因为他们轻视献给耶和华的祭物。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","那时年少的撒母耳穿着细麻布的以弗得，在耶和华面前事奉。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","他母亲每年都为他缝一件小外衣，在她和丈夫来献年祭时带给他。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","以利祝福以利加拿和他妻子，对他说：“愿耶和华让你妻子再给你生儿育女，代替她求来并献给耶和华的孩子。”他们就回家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","耶和华眷顾哈娜，她又生了三个儿子和两个女儿。年少的撒母耳在耶和华面前渐渐长大。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","以利年事已高，他听说两个儿子对待以色列人的恶行，以及他们与在会幕门口服侍的妇女行淫的事后， ");
INSERT INTO cmncbs_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","就对他们说：“你们为什么做这样的事？我从百姓口中听说了有关你们的恶行。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","我儿啊，不可这样，我听到在耶和华的子民中流传着你们的坏名声。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","人若得罪了别人，有上帝为他调解。但人若得罪了耶和华，谁能为他求情呢？”然而，他们不肯听从父亲的话，因为耶和华决意要杀他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","小撒母耳渐渐长大，日益受到耶和华和民众的喜爱。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","有一个上帝的仆人来见以利，对他说：“耶和华说，‘你的祖先在埃及被法老奴役的时候，我向他们显现。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","我在以色列各支派中选出你的祖先做我的祭司，在我的祭坛上献祭烧香，穿着以弗得事奉我。我把以色列人献的所有火祭都赐给你祖先家。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","你们为什么蔑视献给我的祭物和供物？你为什么把你的儿子看得比我还重要，拿我以色列子民所献的上好祭物来养肥自己？’ ");
INSERT INTO cmncbs_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","“所以，以色列的上帝耶和华宣告说，‘我曾经应许让你家族永远做我的祭司。’但现在耶和华宣布，‘这绝不可能了。尊重我的，我必尊重他；藐视我的，必遭藐视。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","看啊，时候将到，我要切断你和你家族的力量，你家族必没有一个老人。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","你在困苦中必以羡慕的眼光看着我赐福以色列人，你家中却永远没有一个老人。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","我不会把你家中的人从我坛前灭绝，但留下来的人必使你哭瞎双眼、伤心欲绝。你的子孙必盛年早逝。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","你的两个儿子何弗尼和非尼哈必死在同一天，这就是我言出必行的记号。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","我要为自己立一位忠心的祭司，他必照我的心意行事。我要使他的家族坚立，他必永远服侍我膏立的王。 ");
INSERT INTO cmncbs_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","那时，你家存留下来的人要在他面前下拜，乞讨银子和饼，并恳求说，请给我一个祭司的职位以便糊口！’” ");
INSERT INTO cmncbs_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","小撒母耳跟着以利事奉耶和华。那时候，耶和华的话语稀少，异象也不多。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","一天晚上，老眼昏花的以利正睡在自己的房里。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","上帝的灯还没有熄灭，撒母耳睡在耶和华的殿内，那里有上帝的约柜。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","耶和华呼唤撒母耳，撒母耳答道：“我在这里！” ");
INSERT INTO cmncbs_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","他跑到以利跟前，说：“我来了，你叫我吗？”以利说：“我没有叫你，你去睡吧。”于是，他就回去睡觉。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","耶和华又呼唤撒母耳，撒母耳起来到以利跟前，说：“我来了，你叫我吗？”以利答道：“孩子，我没有叫你，回去睡吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","那时，撒母耳还不认识耶和华，耶和华的话还没有向他显明。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","耶和华第三次呼唤他，撒母耳起来，到以利面前，说：“我来了，你叫我吗？”这时候，以利才明白原来是耶和华在呼唤这孩子。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","他就吩咐撒母耳说：“你回去睡吧，要是再呼唤你，你就说，‘耶和华啊，请吩咐，仆人恭听。’”于是，撒母耳就回去睡下。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","耶和华来站在那里，再次像刚才一样呼唤：“撒母耳！撒母耳！”撒母耳答道：“请吩咐，仆人恭听。” ");
INSERT INTO cmncbs_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","耶和华对撒母耳说：“我要在以色列做一件令人震惊的事。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","到时候，我要应验我说的有关以利家的一切预言。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","我对以利说过我要永远惩罚他家，因为他知道自己的儿子亵渎我，却没有约束他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","所以，我向以利家起誓说，‘靠祭物或礼物绝不能赎去以利家的罪恶。’” ");
INSERT INTO cmncbs_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","撒母耳在床上躺到天亮，然后起来打开耶和华的殿门。他不敢把异象告诉以利。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","以利叫他：“撒母耳，我的孩子。”撒母耳答道：“我在这里。” ");
INSERT INTO cmncbs_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","以利说：“耶和华对你说了什么？你不要向我隐瞒。如果你隐瞒一句，愿上帝重重地惩罚你。” ");
INSERT INTO cmncbs_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","撒母耳就一五一十地告诉了他。以利说：“祂是耶和华，祂看怎样好，就怎样行吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","撒母耳渐渐长大，耶和华与他同在，使他所说的话没有一句落空。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","从但到别示巴，全以色列的人都知道撒母耳被立为耶和华的先知。 ");
INSERT INTO cmncbs_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","耶和华继续在示罗显现，用自己的话启示撒母耳。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","撒母耳把耶和华的话传遍了以色列。 那时，以色列人去迎战非利士人，他们在以便以谢扎营，非利士人在亚弗扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","非利士人列阵与以色列人交战，大败以色列人，杀了他们约四千人。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","军队回营后，以色列的长老说：“耶和华今天为什么使我们败在非利士人手下？我们从示罗把耶和华的约柜抬来吧，让它与我们同去，好从仇敌手中救我们。” ");
INSERT INTO cmncbs_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","于是，他们派人去示罗，把那坐在基路伯天使上的万军之耶和华的约柜抬来。以利的两个儿子何弗尼和非尼哈也随上帝的约柜同来。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","以色列人看见耶和华的约柜到了营中，就高声欢呼，声音震动大地。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","非利士人听见了欢呼声就说：“希伯来人在营中欢呼什么？”后来他们知道是耶和华的约柜到了营中， ");
INSERT INTO cmncbs_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","就害怕起来，说：“有神明到了他们营中，我们大祸临头了，我们从来没有遇过这种事情！ ");
INSERT INTO cmncbs_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","我们大祸临头了！谁能从这些大能的神明手中救我们？在旷野用各种灾祸毁灭埃及人的就是这些神明。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","非利士人啊，要刚强，做大丈夫。不然，我们就会成为希伯来人的奴隶，像他们做我们的奴隶一样。我们要做大丈夫，奋力征战。” ");
INSERT INTO cmncbs_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","非利士人和以色列人交战，以色列人落败，纷纷逃回家中。他们伤亡惨重，损失了三万步兵。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","上帝的约柜被掳走了，以利的两个儿子何弗尼和非尼哈被杀身亡。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","当天有一个便雅悯人逃出了战场，他撕裂衣服，头蒙灰尘，来到示罗。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","以利正坐在路旁的座位上观望，因为他心里为上帝的约柜担忧。那个从战场回来的人进城报信后，全城的人都放声大哭。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","以利听见哭喊声，就问：“人们为何喊叫？”那人赶忙告诉他。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","那时，以利已经九十八岁，眼睛因为年老而失明。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","报信的人对以利说：“我今天是从战场逃回来的。”以利问：“我的孩子，情况怎么样？” ");
INSERT INTO cmncbs_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","报信的答道：“以色列人被非利士人击溃，伤亡惨重，你的两个儿子何弗尼和非尼哈都死了，上帝的约柜也被掳走了。” ");
INSERT INTO cmncbs_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","以利年老体胖，听到上帝的约柜被掳去，就从门边的座位上向后跌倒，颈断身亡。他做以色列的士师四十年。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","以利的儿媳妇、非尼哈的妻子当时怀孕在身，接近产期。她听说上帝的约柜被掳、公公和丈夫都死了，就突然阵痛，生下了孩子。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","在她弥留之际，身旁的妇人对她说：“不要怕，你生了一个男孩。”但她既不理会，也不回答。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","她给孩子取名叫以迦博，意思是：“荣耀离开以色列了。”这是因为上帝的约柜被掳走，她的公公和丈夫都死了。 ");
INSERT INTO cmncbs_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","她说：“荣耀离开了以色列，因为上帝的约柜已经被掳走了。” ");
INSERT INTO cmncbs_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","非利士人将掳来的上帝的约柜从以便以谢抬到亚实突城， ");
INSERT INTO cmncbs_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","把它抬进大衮庙，放在大衮神像旁边。 ");
INSERT INTO cmncbs_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","第二天早上，亚实突人起来，发现大衮神像倒在耶和华的约柜前，面伏于地，他们就把大衮神像扶起来，放回原处。 ");
INSERT INTO cmncbs_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","次日早上起来，他们又发现大衮神像倒在耶和华的约柜前，面伏于地，头和双手都在门槛处折断了，只剩下躯干。 ");
INSERT INTO cmncbs_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","因此，大衮的祭司和所有进亚实突的大衮庙的人至今都不踏庙的门槛。 ");
INSERT INTO cmncbs_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","耶和华出手重重地惩罚亚实突及附近村庄的居民，使他们恐惧，都患上毒疮。 ");
INSERT INTO cmncbs_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","亚实突人见此情形，就说：“以色列上帝的约柜不能留在我们这里，因为上帝重重地惩罚我们和我们的大衮神。” ");
INSERT INTO cmncbs_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","亚实突人派人召集非利士所有的首领，问他们：“我们如何处理以色列上帝的约柜？”他们答道：“把它送到迦特去。”于是，众人把以色列上帝的约柜送到迦特。 ");
INSERT INTO cmncbs_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","约柜抵达迦特后，耶和华出手攻击那城，使那里的男女老少都患了毒疮，全城惊恐不已。 ");
INSERT INTO cmncbs_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","于是，他们把约柜送往以革伦。以革伦人看见上帝的约柜到了，就惊叫道：“他们把以色列上帝的约柜带来，是要害死我们和我们的人民！” ");
INSERT INTO cmncbs_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","他们派人召集非利士的首领，说：“把以色列上帝的约柜送回原处吧，免得它杀害我们和我们的人民。”因为上帝重重地惩罚他们，全城都笼罩在死亡的恐惧中。 ");
INSERT INTO cmncbs_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","那些没有死的人都饱受毒疮的折磨，城中的哭喊声上达于天。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","耶和华的约柜在非利士人的地方停留了七个月。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","非利士人叫来他们的祭司和占卜者，问道：“我们该怎样处理耶和华的约柜呢？请告诉我们怎样把它送回原处？” ");
INSERT INTO cmncbs_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","他们答道：“你们若把以色列上帝的约柜送回去，不可空手送去，一定要向祂献上赔罪的礼物，这样你们就可以得到医治，也可以知道祂为什么惩罚你们。” ");
INSERT INTO cmncbs_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","非利士人问：“我们该送什么作赔罪的礼物呢？”他们答道：“你们要按非利士首领的数目，送五个金毒疮和五只金鼠，因为你们和你们的首领都遭受了同样的灾难。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","所以，你们要制作金毒疮和毁坏田地的老鼠的像，尊崇以色列的上帝，也许祂会放过你们、你们的神明及田地。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","你们为什么像法老和埃及人那样心里顽固呢？当上帝严厉地对待他们时，他们岂没有让以色列人离开埃及吗？ ");
INSERT INTO cmncbs_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","现在，你们快去准备一辆新车，把两头还在哺养小牛、从未负过轭的母牛套在车上，然后把小牛带回牛圈里。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","你们要把耶和华的约柜放在车上，旁边放箱子，里面装赔罪的金物，然后送这辆车上路。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","你们要留意观察，如果车朝以色列边境的伯·示麦去，这大灾难就是耶和华降给我们的。如果不朝那方向走，我们就知道不是祂惩罚我们，是偶然发生的。” ");
INSERT INTO cmncbs_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","于是，非利士人一一照做，他们牵来两头还在哺养小牛的母牛，把它们套在车上，把小牛关在圈里， ");
INSERT INTO cmncbs_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","然后把耶和华的约柜和装金鼠以及金毒疮的箱子放在车上。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","母牛边走边叫，不偏不离，径直朝伯·示麦走去。非利士的首领跟着它们一直来到伯·示麦的边界。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","当时，伯·示麦人正在山谷里收割麦子。他们抬头看见约柜，非常高兴。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","车子来到伯·示麦人约书亚的田间，在一块巨石旁边停下来。民众劈开车子，把两头母牛献给耶和华作燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","利未人抬下耶和华的约柜和装着金物的箱子，把它们放在巨石上。那天，伯·示麦人向耶和华献上了燔祭和其他祭物。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","那五个非利士首领看见了这一切后，就在当天回以革伦去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","非利士人献给耶和华的金毒疮是分别为亚实突、迦萨、亚实基伦、迦特和以革伦赔罪的。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","那五只金鼠是按着非利士五个首领的坚固城邑和村庄的数目献上的。那块安放耶和华约柜的巨石至今还在伯·示麦人约书亚的田间。 ");
INSERT INTO cmncbs_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","那一天，耶和华击杀了七十个伯·示麦人，因为他们擅自观看约柜里面。民众为此哀恸不已， ");
INSERT INTO cmncbs_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","伯·示麦人说：“谁能站立在这位圣洁的上帝耶和华面前呢？该把约柜送到谁那里呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","后来，他们就派使者到基列·耶琳的居民那里，说：“非利士人已经把耶和华的约柜送回来了，你们下来把它接到你们那里吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","基列·耶琳人就下来把耶和华的约柜抬到山上，放在亚比拿达的家里，特派他的儿子以利亚撒看守耶和华的约柜。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","约柜在基列·耶琳停留了二十年。那时，全体以色列人都痛悔地寻求耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","撒母耳对他们说：“如果你们全心归向耶和华，就要除掉你们中间那些外族的神明和亚斯她录神像，一心归向耶和华，单单事奉祂，祂必从非利士人手中救你们。” ");
INSERT INTO cmncbs_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","于是，他们除掉了巴力和亚斯她录神像，单单事奉耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","撒母耳又说：“你们全体以色列人到米斯巴来，我会为你们向耶和华祈求。” ");
INSERT INTO cmncbs_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","他们就在那里聚集，打水倒在耶和华面前，并在当天禁食。他们说：“我们得罪了耶和华。”于是，撒母耳在米斯巴做以色列人的士师。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","非利士人听说以色列人在米斯巴聚集，他们的首领就率领军队来攻打以色列人。以色列人听见消息后，非常害怕。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","他们对撒母耳说：“请你为我们不停地呼求我们的上帝耶和华，求祂从非利士人手中拯救我们。” ");
INSERT INTO cmncbs_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","撒母耳把一只还在吃奶的羊羔献给耶和华作全牲燔祭。他为以色列人呼求耶和华，耶和华垂听了他的祈求。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","撒母耳正在献燔祭的时候，非利士人前来攻打以色列人。那天，耶和华向非利士人发出雷霆之声，使他们陷入恐慌，败在了以色列人手下。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","以色列人从米斯巴一路追杀他们，直到伯·甲附近。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","撒母耳拿了一块石头放在米斯巴和善的中间，称之为以便以谢，说：“耶和华到如今都帮助我们。” ");
INSERT INTO cmncbs_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","这样非利士人被征服了，没有再侵犯以色列边境。在撒母耳有生之年，耶和华一直出手对付非利士人。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","以色列人收复了从以革伦到迦特之间被非利士人夺去的城邑，并夺回了这些城邑的周边地区。那时以色列人与亚摩利人和平共处。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","撒母耳一生做以色列人的士师。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","他每年都到伯特利、吉甲、米斯巴各地巡回，审理以色列人的案件。 ");
INSERT INTO cmncbs_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","之后，他才回到拉玛自己的家中，也在那里审理以色列人的案件，并为耶和华筑了一座祭坛。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","撒母耳在年老的时候立了他的儿子做以色列人的士师。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","他的长子是约珥，次子是亚比亚，他们在别示巴做士师。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","然而，他们没有效法自己的父亲，反而爱慕不义之财，贪赃枉法。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","于是，以色列的长老一起到拉玛去见撒母耳， ");
INSERT INTO cmncbs_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","说：“你年纪大了，你的儿子不效法你。现在求你为我们立一个王治理我们，像其他国家一样。” ");
INSERT INTO cmncbs_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","撒母耳听到他们要求立一个王治理他们，心中不悦，就向耶和华祷告。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","耶和华对撒母耳说：“你照他们所说的去做吧，因为他们不是拒绝你，而是拒绝我做他们的王。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","自从我带他们出埃及那天一直到今日，他们常常背弃我，去供奉其他神明。现在，他们也这样对待你。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","你就照他们所求的去做吧！但你要严厉地警告他们，让他们知道将来王会怎样管辖他们。” ");
INSERT INTO cmncbs_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","撒母耳就把耶和华的话转告给那些请求他立王的民众，说： ");
INSERT INTO cmncbs_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","“将来管辖你们的王会征用你们的儿子做他的战车兵、骑兵，要他们跑在他的战车前面。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","他会派一些人做千夫长、五十夫长，一些人为他耕种田地、收割庄稼，一些人制造兵器和战车的装备。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","他会把你们的女儿带走，要她们给他造香膏、煮饭和烤饼。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","他会夺去你们最好的田地、葡萄园和橄榄园，送给他的臣仆。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","他会从你们的粮食和葡萄园的出产中收取十分之一，送给他的官员和臣仆。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","他会征用你们的仆婢及最好的牛和驴来为他效劳。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","他会拿去你们羊群的十分之一，你们必做他的奴仆。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","那时你们会因所选之王的压迫而呼求耶和华，耶和华却不会垂听。” ");
INSERT INTO cmncbs_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","民众却不肯听从撒母耳的话。他们说：“不，我们想要一个王治理我们， ");
INSERT INTO cmncbs_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","这样我们就会像其他国家一样，有王来统治我们，率领我们，为我们作战。” ");
INSERT INTO cmncbs_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","撒母耳听后，就把民众这些话转告耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","耶和华对撒母耳说：“照他们说的去为他们立一个王吧。”于是，撒母耳对以色列人说：“你们各人回自己的城去吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","有一个便雅悯人名叫基士，很有威望，是亚斐亚的玄孙、比歌拉的曾孙、洗罗的孙子、亚别的儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","他的儿子扫罗年轻英俊，在以色列人中无人能比，高出其他人一个头。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","一天，基士丢失了几头驴，他就对儿子扫罗说：“你带一个仆人去找驴吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","他们找遍了以法莲的山区、沙利沙地区、沙琳地区和便雅悯地区，都找不着。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","最后，他们来到苏弗，扫罗对仆人说：“我们还是回家去吧，恐怕我父亲不再为驴担心，反而为我们担心。” ");
INSERT INTO cmncbs_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","但仆人答道：“且慢，这城里有一位上帝的仆人，很受人敬重，他所说的都会应验。我们去找他吧，也许他会告诉我们该到哪里去找驴。” ");
INSERT INTO cmncbs_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","扫罗答道：“如果去的话，我们有什么可以送给他呢？我们袋里的食物也吃完了，我们还有什么可以送给上帝的仆人呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","仆人说：“我这里还有三克银子，我们可以送给上帝的仆人，请他告诉我们去哪里找驴。” ");
INSERT INTO cmncbs_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","从前在以色列，如果人们要求问上帝，他们会说：“让我们去找先见吧。”当时“先知”被称为“先见”。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","扫罗说：“好主意，我们去吧。”于是，他们前往上帝仆人住的城。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","他们走上山坡，正要进城的时候，遇见一些少女出来打水，就问：“先见在这里吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","她们答道：“他在这里，就在你们前面。你们快去吧，他今天刚到城里来，因为今天人们在丘坛献祭。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","你们一进城，就会在他上丘坛吃祭物之前遇见他。因为他不来，人们不能吃，他要先为祭物祝谢后，人们才可以吃。你们现在上去吧，一定会遇见他。” ");
INSERT INTO cmncbs_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","他们就赶往城内，刚走进城，就看见撒母耳迎面而来，要上丘坛去。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","在扫罗来的前一天，耶和华已经启示撒母耳说： ");
INSERT INTO cmncbs_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“明天这个时候，我会从便雅悯境内差遣一个人到你这里，你要膏立他做我以色列子民的首领，他会从非利士人手中把我的子民拯救出来，因为我已听到我子民的呼求，我要施恩给他们。” ");
INSERT INTO cmncbs_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","撒母耳看见扫罗的时候，耶和华就对他说：“这就是我对你说的那个人，他将统治我的子民。” ");
INSERT INTO cmncbs_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","扫罗来到在城门口的撒母耳面前，问道：“请你告诉我先见住在哪里？” ");
INSERT INTO cmncbs_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","撒母耳答道：“我就是先见。你先上丘坛去，今天你要和我一起吃饭。明天早上我会送你上路，并把你想知道的事都告诉你。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","不要再挂念三天前丢失的驴了，已经找到了。以色列人所仰慕的人是谁呢？不是你和你父亲全家吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","扫罗答道：“我来自以色列最小的便雅悯支派，我的家族在便雅悯支派中最小，你何出此言？” ");
INSERT INTO cmncbs_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","撒母耳带着扫罗和他的仆人来到一个大厅，让他们在请来的三十位客人中坐上座。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","撒母耳对厨师说：“把我交给你的那份祭肉拿来。” ");
INSERT INTO cmncbs_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","厨师就拿来那块腿肉，摆在扫罗面前。撒母耳说：“这是为你留的，请吃吧。这是我在请客人时特意为你留的。”于是，扫罗和撒母耳一起吃饭。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","他们从丘坛下来，回到城里后，撒母耳把扫罗带到屋顶上谈话。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","黎明时分，撒母耳呼唤屋顶上的扫罗：“起来吧，我该送你上路了。”于是扫罗起床后，与撒母耳一起往外走。 ");
INSERT INTO cmncbs_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","他们来到城边的时候，撒母耳让扫罗吩咐仆人先走。仆人离去后，他对扫罗说：“你在这里留一会儿，我要把上帝的话告诉你。” ");
INSERT INTO cmncbs_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","撒母耳把一瓶膏油倒在扫罗的头上，亲吻他，说：“耶和华已经膏立你做祂子民的首领。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","你今天离开我以后，会在便雅悯境内的谢撒、靠近拉结的墓旁遇见两个人。他们会告诉你，你要找的驴已经找到，现在你父亲不再为驴担心，反为你担心，说，‘我该怎样找到我的儿子呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","你继续往前走，会在他泊的橡树那里遇见三个人。他们要到伯特利去敬拜上帝，一个牵着三只山羊羔，一个带着三个饼，一个拿着一皮袋酒。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","他们会问候你，送你两个饼，你要把饼收下。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","此后，你会去上帝的山，那里有非利士人的驻军。你一进城，就会遇见一群先知从丘坛下来，前面有人鼓瑟、敲鼓、吹笛、弹琴，先知们会说预言。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","耶和华的灵会突然降在你身上，你就会跟他们一起说预言，那时，你会变成另一个人。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","这些兆头临到你的时候，你就要见机行事，因为上帝与你同在。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","你先到吉甲去，在那里等我七天，我会到那里献燔祭和平安祭。我到了以后会告诉你怎么做。” ");
INSERT INTO cmncbs_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","扫罗转身离开撒母耳，上帝使他心灵焕然一新。撒母耳所说的兆头那天都应验了。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","扫罗和他的仆人来到上帝的山，遇见了一群先知。上帝的灵突然降在扫罗身上，他就在他们中间说起预言来。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","以前认识扫罗的人看见他跟先知一起说预言，就议论说：“基士的儿子怎么了？扫罗也做了先知吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","当地的一个人说：“他们的父亲是谁？”自此以后，“扫罗也做了先知吗”就成为一句谚语。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","扫罗说完预言以后，就去了丘坛。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","扫罗的叔叔问他和他的仆人：“你们到哪里去了？”扫罗答道：“我们去找驴，没找着，就去见撒母耳。” ");
INSERT INTO cmncbs_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","扫罗的叔叔说：“请把撒母耳对你们说的话告诉我。” ");
INSERT INTO cmncbs_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","扫罗答道：“他肯定地告诉我们驴已经找到了。”但扫罗没有把撒母耳提到的立王之事告诉叔叔。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","撒母耳把以色列人招聚到米斯巴耶和华那里， ");
INSERT INTO cmncbs_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","对他们说：“以色列的上帝耶和华这样说，‘我带你们出埃及，从埃及人和压迫你们的各国之人手中救出你们。’ ");
INSERT INTO cmncbs_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","但你们现在却背弃了拯救你们脱离一切灾难和困苦的上帝，竟然对祂说，‘我们要你立一位王来统治我们。’所以你们现在就按着支派宗族站在耶和华面前吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","撒母耳让以色列各支派来抽签，结果抽中了便雅悯支派。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","然后撒母耳让便雅悯支派的各宗族来抽，结果抽中了玛特利家族，最后又抽中了基士的儿子扫罗。众人找扫罗，却找不到他。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","他们便求问耶和华，说：“这人来了吗？”耶和华说：“他来了，躲在物品堆中。” ");
INSERT INTO cmncbs_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","他们就跑去把扫罗请来。扫罗站在百姓当中，高出众人一头。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","撒母耳对百姓说：“这就是耶和华为你们选的人。在以色列没有人能比得上他。”众人高呼：“愿王万岁！” ");
INSERT INTO cmncbs_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","撒母耳向百姓说明做君王的权利和责任，又把这些都记在册子上，放在耶和华面前，然后让百姓各自回家。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","扫罗返回基比亚自己的家时，有一群被上帝感动的勇士跟随他。 ");
INSERT INTO cmncbs_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","但有一些市井之徒说：“这人怎能救我们？”就鄙视他，没有送礼物给他，但扫罗没有说什么。 ");
INSERT INTO cmncbs_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","亚扪人拿辖率军上来围困基列·雅比，城内的居民对拿辖说：“你与我们立约吧！我们愿意服侍你。” ");
INSERT INTO cmncbs_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","亚扪人拿辖说：“好，但有一个条件，我要挖去你们每一个人的右眼，作为对全体以色列人的羞辱。” ");
INSERT INTO cmncbs_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","雅比的长老说：“请宽限我们七天，我们好派遣使者去以色列全境。要是没有人来营救我们，我们就向你投降。” ");
INSERT INTO cmncbs_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","雅比的使者来到扫罗的家乡基比亚，把他们的情况告诉众人，众人听了放声大哭。 ");
INSERT INTO cmncbs_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","那时扫罗刚好赶着牛从田间回来，便问道：“发生了什么事？为什么众人都在哭？”百姓把雅比的情况告诉了他。 ");
INSERT INTO cmncbs_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","扫罗听后，上帝的灵便突然降在他身上，他勃然大怒， ");
INSERT INTO cmncbs_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","牵来两头牛，把它们切成碎块，然后派使者把碎块分发到以色列全境，并且宣布：“谁拒绝跟随扫罗和撒母耳出战，他的牛就要被砍成这样。”耶和华使百姓充满恐惧，他们都同心合意地响应。 ");
INSERT INTO cmncbs_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","扫罗在比色统计以色列人，共有三十万，从犹大来的有三万。 ");
INSERT INTO cmncbs_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","他们让雅比的使者回去告诉基列·雅比人，说：“明天中午，你们必得拯救。”使者回去告诉雅比人，他们非常欢喜， ");
INSERT INTO cmncbs_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","便对亚扪人说：“明天我们会出来归顺你们，你们怎样对待我们都可以。” ");
INSERT INTO cmncbs_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","第二天，扫罗把以色列人分成三队，在黎明时分突袭亚扪人的军营，把他们杀得大败，直到中午才收兵。亚扪人的残兵四散奔逃，没有二人在一处的。 ");
INSERT INTO cmncbs_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","以色列人对撒母耳说：“是谁说扫罗不该做王？把他们带来，我们要处死他们。” ");
INSERT INTO cmncbs_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","扫罗却说：“今天不可杀人，因为今天耶和华拯救了以色列。” ");
INSERT INTO cmncbs_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","撒母耳对民众说：“来吧，我们到吉甲去，在那里重新立国。” ");
INSERT INTO cmncbs_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","于是，他们来到吉甲，在耶和华面前立扫罗为王，又向耶和华献上平安祭。扫罗和全体以色列人都非常欢喜。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","撒母耳对以色列人说：“看啊，我已照你们的要求为你们立了一个王。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","你们已经有君王了。我自幼带领你们，现在已年老发白，我的儿子也都在你们这里。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","如今我站在这里，你们只管在耶和华和祂膏立的王面前为我作证，我夺过谁的牛？抢过谁的驴？欺骗过谁？压迫过谁？收过谁的贿赂而徇私枉法？如果有的话，我一定偿还。” ");
INSERT INTO cmncbs_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","他们答道：“你没有欺骗、压迫过我们，也没有拿过任何人的东西。” ");
INSERT INTO cmncbs_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","撒母耳对他们说：“耶和华和祂所膏立的王今天为我作证，我没有拿过你们任何人的东西。”他们说：“是的，耶和华为证。” ");
INSERT INTO cmncbs_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","撒母耳继续说：“是耶和华派摩西和亚伦带领你们的祖先离开埃及。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","现在，你们都要站在耶和华面前，让我来提醒你们有关耶和华为你们和你们祖先所行的一切公义之事。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","从前，雅各曾迁到埃及，你们的祖先受到埃及人的压迫，向耶和华呼求，耶和华就差遣摩西和亚伦带他们出埃及，到这里居住。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","他们却忘记了他们的上帝耶和华，于是耶和华让他们落入夏琐的将军西西拉、非利士人和摩押王的手中，这些人便攻击他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","他们就向耶和华呼求，‘耶和华啊，我们犯了罪，我们背弃了你去供奉巴力和亚斯她录，现在求你从仇敌手中救我们，我们必事奉你。’ ");
INSERT INTO cmncbs_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","耶和华就派耶路·巴力、比但、耶弗他和撒母耳从周围的敌人手中救你们，使你们安然居住。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","可是你们看到亚扪王拿辖来攻击你们，就对我说，‘不行，我们要有一个王来统治我们。’其实你们的上帝耶和华就是你们的王。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","现在，你们所求所选的王在这里，耶和华为你们立了一位王。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","如果你们敬畏耶和华，事奉祂，听从祂的吩咐，不违背祂的命令，你们和统治你们的王都愿意跟从祂，一切都会顺利。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","如果你们不听从耶和华的话，违背祂的命令，祂就会像从前惩罚你们的祖先一样出手惩罚你们。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","现在你们站着留心看，耶和华就要在你们面前行一件大事。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","你们都知道收割麦子的时候不会下雨。现在，我要向耶和华祷告，求祂打雷降雨，好让你们知道，你们要求立王在耶和华眼中是多么大的罪。” ");
INSERT INTO cmncbs_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","于是，撒母耳向耶和华呼求，耶和华便在当天打雷降雨，民众非常害怕耶和华和撒母耳。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","他们求撒母耳，说：“求你为仆人们向你的上帝耶和华祈祷，免得我们死亡！因为我们要求立王是罪上加罪。” ");
INSERT INTO cmncbs_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","撒母耳说：“不要害怕，你们虽然做了这恶事，但不可离开耶和华，要全心全意地事奉祂。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","不要去追求其他虚无的假神，它们对你们毫无益处，也不能拯救你们。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","耶和华不会丢弃祂的子民，使自己的大名受损，祂乐意使你们做祂的子民。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","至于我，我会不断地为你们祈祷，免得我得罪耶和华。我会教导你们行善道、走正路。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","你们要单单敬畏耶和华，全心全意地事奉祂，想想祂为你们做了何等伟大的事。 ");
INSERT INTO cmncbs_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","可是，如果你们仍然继续行恶，你们和你们的王都必灭亡。” ");
INSERT INTO cmncbs_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","扫罗四十岁登基。他在统治以色列的第二年， ");
INSERT INTO cmncbs_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","从以色列人中选出三千人，亲自带领其中的两千人到密抹和伯特利山，另外一千人和约拿单留在便雅悯境内的基比亚。他把其余的人遣散回家。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","约拿单攻打迦巴的非利士驻军，非利士人听到了这消息。于是，扫罗在各地吹响号角，通告希伯来人。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","以色列众人听说扫罗攻打非利士人的驻军，并听说非利士人对以色列人恨之入骨，便响应扫罗的号召，聚集在吉甲。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","非利士人调兵遣将，要攻打以色列。他们有三万辆战车和六千骑兵，步兵多如海边的沙。大军来到伯·亚文以东的密抹，驻扎在那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","以色列人看见敌军压境，情势危急，纷纷躲进山洞、丛林、石穴、地洞和坑里。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","有些希伯来人过了约旦河，逃到迦得和基列。但扫罗仍然留在吉甲，跟随他的人都害怕得发抖。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","扫罗按着撒母耳所定的日期在吉甲等了七天，可是撒母耳还没有来。扫罗的军兵开始散去。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","于是，扫罗说：“你们把燔祭和平安祭带到我这里来。”他就献上了燔祭。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","扫罗刚把燔祭献完，撒母耳就来了，扫罗出去迎接他，向他问安。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","撒母耳对扫罗说：“你做的是什么事？”扫罗答道：“我看见民众不断离我而去，你到了约定的时候还没有来，而且非利士人就聚集在密抹。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","我想非利士人就要到吉甲来攻打我了，但我还没有向耶和华求助，我迫不得已，就献上燔祭了。” ");
INSERT INTO cmncbs_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","撒母耳说：“你真糊涂！你违背了你的上帝耶和华的命令。祂本来要使你的王位在以色列永远坚立， ");
INSERT INTO cmncbs_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","但现在你的王位不能长久了，耶和华已经找到一个合祂心意的人，要立他做百姓的君王。因为你没有遵守耶和华的命令。” ");
INSERT INTO cmncbs_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","撒母耳离开吉甲去便雅悯境内的基比亚。扫罗数了一下跟随他的人，约有六百人。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","扫罗和儿子约拿单及随从留在便雅悯境内的迦巴，非利士人则在密抹扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","非利士人分成三队施行突袭，一队前往书亚境内的俄弗拉， ");
INSERT INTO cmncbs_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","一队前往伯·和仑，一队前往边境地区，那里可以俯瞰旷野附近的洗波音谷。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","那时，以色列全境找不到一个铁匠，这是因为非利士人的禁令，防止希伯来人制造刀枪。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","以色列人都要到非利士的铁匠那里去磨锄、犁、斧和铲。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","磨锄或犁要花八克银子，磨三齿叉、斧头或赶畜棒要花四克银子。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","所以在交战的日子，除了扫罗和约拿单外，其他随从手上都没有刀枪。 ");
INSERT INTO cmncbs_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","当时非利士的一队防兵前往密抹的隘口驻守。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","一天，扫罗的儿子约拿单对为他拿兵器的年轻人说：“来吧，我们去非利士的驻军那里。”但他没有告诉父亲。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","那时扫罗正待在基比亚边界米矶仑的石榴树下，跟随他的大约有六百人， ");
INSERT INTO cmncbs_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","其中有穿着以弗得的祭司亚希亚，即亚希突的儿子。亚希突是示罗耶和华祭司以利的孙子，非尼哈的儿子，以迦博的哥哥。没有人留意到约拿单出去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","约拿单到非利士驻军那里需要经过一个隘口，隘口两边的山峰一个叫播薛，一个叫西尼， ");
INSERT INTO cmncbs_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","北面的山峰面对密抹，南面的山峰面对迦巴。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","约拿单对拿兵器的年轻人说：“我们去那些未受割礼之人的军营，也许耶和华会帮助我们。祂使人得胜不在于人数多少。” ");
INSERT INTO cmncbs_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","拿兵器的人答道：“就照你的意思，我会一心追随你。” ");
INSERT INTO cmncbs_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","约拿单说：“我们去他们那边，故意让他们发现。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","如果他们说，‘站住，等我们去你们那里！’我们就待在原地，不去他们那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","但如果他们说，‘你们来我们这里！’我们就去，因为那表示耶和华已经把他们交在我们手里了。” ");
INSERT INTO cmncbs_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","非利士的驻军看见二人走近，就说：“看！希伯来人从躲藏的洞里爬出来了！” ");
INSERT INTO cmncbs_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","驻军对约拿单和拿兵器的人大喊：“上来，我们要教训教训你们。”约拿单就对拿兵器的人说：“跟着我爬上去，耶和华已经把他们交在以色列人手里了。” ");
INSERT INTO cmncbs_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","于是，约拿单就爬上去击杀非利士人，拿兵器的人紧随其后，一同击杀非利士人。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","他们首次出击，在半亩大小的区域杀了约二十个非利士人。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","营房、田野的所有非利士人，包括驻军和突击队都非常恐慌。大地震动，众人恐惧万分。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","扫罗在便雅悯境内基比亚的哨兵看见非利士军队四散奔逃，溃不成军。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","扫罗对跟随他的人说：“你们查一查，看谁离开了军营？”结果发现约拿单和为他拿兵器的人不见了。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","扫罗对亚希亚说：“把上帝的约柜抬来。”那时上帝的约柜在以色列人那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","扫罗和祭司说话的时候，非利士人营里越来越混乱。扫罗对祭司说：“停手吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","他和跟随他的人聚集起来，冲入战场，发现非利士人正互相残杀，乱作一团。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","从前加入非利士军队的希伯来人现在也倒戈加入扫罗和约拿单的以色列军队。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","那些躲在以法莲山区的以色列人听说非利士人溃逃，都出来紧紧地追杀他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","耶和华在那天拯救了以色列人，战事一直蔓延到伯·亚文。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","那一天，以色列人很困乏，因为扫罗叫他们起誓：“谁在黄昏前，就是在向敌人报完仇以前吃任何东西，谁就要受咒诅。”于是，以色列人整天都没有进食。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","众人进入树林，见地上有蜂蜜。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","他们在树林中虽然看见有蜂蜜正在滴落，但没有人敢伸手取蜂蜜吃，因为他们都怕违背誓言。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","约拿单没有听见他父亲叫以色列人起誓，他伸出手中的杖蘸蜂房的蜜吃，立刻精神大振。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","有个士兵告诉约拿单，说：“你父亲曾叫众人郑重起誓，‘今天吃东西的人必受咒诅。’所以众人很疲惫。” ");
INSERT INTO cmncbs_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","约拿单说：“我父亲使大家受苦了。你们看，我只吃了少许蜂蜜，就精神大振， ");
INSERT INTO cmncbs_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","如果大家吃了从敌人那里夺来的食物，我们就会歼灭更多非利士人。” ");
INSERT INTO cmncbs_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","那天，以色列人追杀非利士人，从密抹一直追杀到亚雅仑，众人疲惫不堪。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","他们匆匆把夺来的牛、羊和牛犊在地上宰了，肉还带血就吃了。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","有人告诉扫罗，说：“众人吃了带血的肉，得罪耶和华了。”扫罗说：“你们犯罪了！现在把一块大石头滚到我这里来， ");
INSERT INTO cmncbs_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","再去吩咐大家把牛羊都带到这里来宰了吃，不可吃带血的肉得罪耶和华。”当晚，众人都把自己的牛羊带到那里宰杀。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","扫罗为耶和华筑了一座祭坛，这是他第一次为耶和华筑坛。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","他对以色列人说：“让我们连夜追赶非利士人，抢夺他们的财物，直到天亮，把他们全部歼灭。”众人答道：“就照你的意思。”但祭司说：“让我们先来求问上帝吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","于是，扫罗求问上帝，说：“我可以去追杀非利士人吗？你会把他们交在以色列人手里吗？”但耶和华那日没有回答他。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","扫罗说：“你们这些百姓的首领到这里来，我们要查出今天究竟谁犯了罪， ");
INSERT INTO cmncbs_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","我凭拯救以色列的永活的耶和华起誓，就是我儿子约拿单犯了罪，他也要死！”众人都默不作声。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","扫罗对以色列众人说：“你们站在这边，我和我的儿子约拿单站在那边。”众人答道：“就照你的意思。” ");
INSERT INTO cmncbs_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","扫罗向以色列的上帝耶和华祷告说：“请你把实情告诉我吧。”抽签的结果是约拿单和扫罗犯了罪，民众都是无辜的。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","扫罗和约拿单二人再抽签，结果抽出了约拿单。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","扫罗对约拿单说：“告诉我，你做了什么事？”约拿单说：“我确实用手中的杖蘸了一点蜂蜜吃，这样我就要死吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","扫罗说：“约拿单啊，你必须死。否则，愿上帝重重地惩罚我。” ");
INSERT INTO cmncbs_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","但众人对扫罗说：“今天约拿单给以色列人带来这么大的胜利，难道要他死吗？绝不可以！我们凭永活的耶和华起誓，绝不可动他一根头发，因为他今天的行动有上帝的帮助。”众人就这样救了约拿单的性命。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","扫罗便停止了追击，非利士人也回本地去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","扫罗统治以色列后，常常攻打四围的摩押人、亚扪人、以东人、琐巴的诸王和非利士人等仇敌，无往而不胜。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","他奋勇杀敌，打败了亚玛力人，从掠夺者手中救出以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","他的儿子是约拿单、亦施韦和麦基舒亚，长女叫米拉，次女叫米甲。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","他的妻子名叫亚希暖，是亚希玛斯的女儿。扫罗军队的元帅叫押尼珥，是他叔叔尼珥的儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","扫罗的父亲基士和押尼珥的父亲尼珥都是亚别的儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","扫罗一生常和非利士人激烈交战。他遇见英勇的壮士，都会征募到自己麾下。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","一天，撒母耳对扫罗说：“耶和华差遣我膏立你做祂以色列子民的王，所以你要听从祂的话。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","万军之耶和华说，‘我要惩罚亚玛力人，因为在以色列人离开埃及的时候，他们与以色列人为敌。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","你现在要去攻打他们，彻底消灭他们和他们拥有的一切，把男女老幼、牛羊骆驼和驴全部杀掉，一个不留。’” ");
INSERT INTO cmncbs_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","于是，扫罗在提拉因召集了二十万步兵，另有从犹大来的一万人。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","扫罗来到亚玛力的城池，在山谷里埋伏起来。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","他对基尼人说：“你们离开亚玛力人吧，免得我把你们也一起消灭，因为在以色列人离开埃及的时候，你们曾善待他们。”于是，基尼人离开了亚玛力人。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","扫罗攻打亚玛力人，从哈腓拉直打到埃及东面的书珥， ");
INSERT INTO cmncbs_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","生擒了亚玛力王亚甲，用刀杀尽了亚玛力人。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","扫罗和他的士兵却留下了亚甲和那些上好的牛羊、肥壮的牛犊和羊羔及一切美物，只毁灭了那些瘦弱无用的牲畜。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","那时，耶和华对撒母耳说： ");
INSERT INTO cmncbs_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“我后悔立扫罗为王，因为他离弃了我，不遵守我的命令。”撒母耳很气愤，整夜呼求耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","清早，撒母耳起来去见扫罗，有人告诉他扫罗已前往迦密山，在那里为自己立了纪念碑，然后去了吉甲。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","撒母耳到了扫罗那里后，扫罗说：“愿耶和华赐福给你，我已经遵守了耶和华的命令。” ");
INSERT INTO cmncbs_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","撒母耳说：“那么，我现在听见的牛羊叫声是从哪里来的？” ");
INSERT INTO cmncbs_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","扫罗答道：“这是众人从亚玛力人那里带回来的，他们留下了这些上好的牛羊要献给你的上帝耶和华，我们毁灭了其余的一切。” ");
INSERT INTO cmncbs_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","撒母耳对扫罗说：“住口！让我告诉你耶和华昨天晚上对我说的话。”扫罗答道：“请说。” ");
INSERT INTO cmncbs_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","撒母耳说：“你虽然从前觉得自己微不足道，但现在却做了以色列各支派的首领。耶和华膏立你做以色列的王。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","祂差遣你去攻打那些罪恶的亚玛力人，命你把他们全部消灭。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","你为何不听从祂的命令？你为何急于掠夺财物，做耶和华视为邪恶的事呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","扫罗答道：“我的确服从了耶和华的命令，照着耶和华的吩咐做了。我把亚玛力王亚甲带了回来，杀尽了其余的亚玛力人。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","士兵们却从本该毁灭的战利品中取了上好的牛羊，准备在吉甲奉献给你的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","撒母耳说： “耶和华喜欢燔祭和其他祭物， 岂如喜欢人们听从祂的话？ 顺服胜于献祭， 听从耶和华胜过向祂献上公羊的脂肪。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","叛逆不亚于行巫术的罪， 顽固不化无异于拜偶像。 你拒绝耶和华的命令， 祂也拒绝你做王。” ");
INSERT INTO cmncbs_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","扫罗对撒母耳说：“我犯罪了！我违背了耶和华的命令和你的指示。我因惧怕百姓，就听从了他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","现在求你赦免我的罪，跟我一起回去，我好敬拜耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","但撒母耳说：“我不会跟你回去，你既然拒绝遵行耶和华的命令，祂也拒绝你做以色列的王。” ");
INSERT INTO cmncbs_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","撒母耳转身离去，扫罗就抓住他外袍的衣边，结果衣边被撕下来了。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","撒母耳对他说：“耶和华今天已经从你身上撕下以色列国，赐给了一个比你好的人。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","以色列荣耀的上帝不说谎、也不改变心意，因为祂不是反复无常的世人。” ");
INSERT INTO cmncbs_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","扫罗说：“我犯了罪，但求你在以色列的长老和百姓面前尊重我，求你跟我回去，我好敬拜你的上帝耶和华。” ");
INSERT INTO cmncbs_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","于是，撒母耳跟扫罗一起回去，扫罗就敬拜耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","撒母耳说：“把亚玛力王亚甲带到我这里来。”亚甲若无其事地来到他面前，心想自己一定逃过一死了。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","但撒母耳对他说：“你的刀怎样使妇人失去儿女，你的母亲也要怎样失去她的儿子。”于是，撒母耳就在吉甲，在耶和华面前把亚甲杀死了。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","事后，撒母耳回到拉玛，扫罗也返回基比亚自己的家。 ");
INSERT INTO cmncbs_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","撒母耳一直到死没有再见扫罗，但他为扫罗哀伤。耶和华后悔立扫罗做以色列王。 ");
INSERT INTO cmncbs_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","耶和华对撒母耳说：“我已经拒绝让扫罗做以色列王了，你还要为他哀伤多久呢？把你的角盛满膏油，我要差遣你到伯利恒的耶西那里，我已选了他的一个儿子做王。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","撒母耳说：“我怎么可以去呢？扫罗知道了，一定会杀掉我。”耶和华说：“你带一头牛犊去，就说，‘我是来向耶和华献祭的。’ ");
INSERT INTO cmncbs_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","你要请耶西参加献祭，我会告诉你怎么做，我把谁指示给你，你就要为我膏立谁。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","撒母耳遵行耶和华的吩咐，他来到伯利恒，那城的长老都战战兢兢地出来迎接他，问道：“你是为平安而来吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","撒母耳答道：“是的，为平安而来，我是来向耶和华献祭的。你们要洁净自己，然后来和我一起献祭。”撒母耳为耶西及其众子行过洁净礼后，便邀请他们参加献祭。 ");
INSERT INTO cmncbs_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","耶西及其众子来了，撒母耳看见以利押，心里想：“这位肯定是耶和华要膏立的人。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","但耶和华对撒母耳说：“不要看他相貌堂堂、身材高大，我要选的不是他。耶和华不像世人那样看人，人看外表，耶和华看内心。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","耶西吩咐他的儿子亚比拿达从撒母耳面前走过，但撒母耳说：“这也不是耶和华拣选的人。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","耶西又叫沙玛从撒母耳面前走过，但撒母耳说：“这也不是耶和华拣选的人。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","耶西叫七个儿子一个一个从撒母耳面前走过，但撒母耳说他们都不是耶和华拣选的人。 ");
INSERT INTO cmncbs_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","撒母耳问耶西：“你的儿子全都到齐了吗？”耶西答道：“还有一个最小的，他正在田间放羊。”撒母耳对耶西说：“派人叫他回来，他不来，我们就不入座。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","耶西就派人去叫他回来。他面色红润，眉清目秀，相貌英俊。耶和华说：“就是他，起来膏立他吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","撒母耳就拿出盛膏油的角，当着他哥哥们的面膏立他。从那天起，耶和华的灵突然降在大卫身上。事后，撒母耳回拉玛去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","耶和华的灵离开了扫罗，有个邪灵从耶和华那里来折磨他。 ");
INSERT INTO cmncbs_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","扫罗的臣仆对他说：“现在有个邪灵从上帝那里来折磨你， ");
INSERT INTO cmncbs_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","你可以吩咐跟前的臣仆去找一个善于弹琴的人来。邪灵从上帝那里来到你身上的时候，他为你弹琴，你就舒畅了。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","扫罗说：“你们就为我找一个善于弹琴的人，带他到我这里来。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","其中有一个仆人说：“我见过伯利恒的耶西的一个儿子，他善于弹琴，英勇善战，谈吐合宜，相貌英俊，并且耶和华与他同在。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","扫罗便差遣使者去见耶西，说：“请让你放羊的儿子大卫到我这里来。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","耶西就把一些饼、一皮袋酒和一只山羊羔驮在驴背上，让儿子大卫带去送给扫罗。 ");
INSERT INTO cmncbs_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","大卫到了扫罗那里，做了他身边的侍臣。扫罗非常喜欢大卫，让大卫为他拿兵器。 ");
INSERT INTO cmncbs_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","扫罗派人去见耶西，说：“你就让大卫留在我的身边吧，因为我喜欢他。” ");
INSERT INTO cmncbs_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","每当有邪灵从上帝那里来到扫罗身上的时候，大卫就为他弹琴，扫罗便觉得舒畅，邪灵也离开了他。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","非利士人在犹大的梭哥招聚军队，准备作战。他们在梭哥和亚西加之间的以弗·大悯扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","扫罗和以色列人也聚集起来在以拉谷安营，摆好阵势准备迎战。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","双方的军队各占一座山对峙，中间隔着山谷。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","非利士营中有个名叫歌利亚的巨人出来讨战。他来自迦特，身高三米， ");
INSERT INTO cmncbs_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","头戴铜盔，身穿重达五十七公斤的铠甲， ");
INSERT INTO cmncbs_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","腿上有铜护膝，肩背铜戟。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","戟柄粗如织布机的轴，铁戟头重七公斤。有卫士拿着他的盾牌走在前面。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","他站在那里挑战以色列人，高喊：“你们为什么列阵打仗呢？我是非利士人，你们是扫罗的仆人，你们选一个人下来跟我一比高下。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","如果他打得过我，将我杀了，我们就做你们的奴隶。但如果我战胜他，把他杀了，你们就要做我们的奴隶，服侍我们。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","我今天向以色列军队骂阵，你们找一个人出来跟我一决高下吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","扫罗和所有以色列人听了非利士人的这些话，都吓得惊恐不已。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","大卫是以法他人耶西的儿子。扫罗执政期间，耶西已经年纪老迈，住在犹大的伯利恒，有八个儿子。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","他的三个儿子已经跟随扫罗去打仗了，他们是长子以利押、次子亚比拿达和三子沙玛。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","大卫年纪最小，他的三个哥哥跟随扫罗期间， ");
INSERT INTO cmncbs_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","他有时去扫罗的军营，有时回伯利恒为他父亲放羊。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","这非利士人早晚都出来骂阵，长达四十天。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","一天，耶西对大卫说：“你带上十公斤烤麦和十个饼，赶快到军营中送给你的哥哥们。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","再带十块奶饼送给他们的千夫长，看望一下他们，带个信儿回来。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","他们跟随扫罗率领的以色列军在以拉谷跟非利士人打仗。” ");
INSERT INTO cmncbs_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","大卫清早起来把羊交给一个牧人看顾，然后照父亲的吩咐带着食物出发了。他来到军营的时候，大军正呐喊着出战。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","以色列人与非利士人摆好阵势，两军对垒。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","大卫把带来的东西交给负责看守的人保管，自己跑到阵中去问候哥哥们。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","他们正在交谈的时候，非利士军中的迦特人歌利亚出来，像往常一样向以色列军骂阵，大卫都听见了。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","以色列人一看见歌利亚都竞相奔逃，极其害怕。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","以色列人彼此议论说：“看那个人！他是来向以色列军骂阵的。谁要能杀死他，王必有重赏，还会把女儿嫁给他为妻，并免去他父亲家在以色列应缴的赋税。” ");
INSERT INTO cmncbs_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","大卫问站在旁边的人：“如果有人杀了这非利士人，洗掉以色列人的羞辱，他会得到什么呢？这个未受割礼的非利士人是谁？竟敢向永活上帝的军队骂阵！” ");
INSERT INTO cmncbs_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","他们就把刚才的话一一告诉大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","大卫的长兄以利押听见他跟人说话，就愤怒地对他说：“你来这里做什么？你把旷野的那几只羊交给谁了？我知道你骄傲自大，心怀恶意，你来只是想看打仗。” ");
INSERT INTO cmncbs_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","大卫说：“我做错了什么？我问一下都不行吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","他又去问其他人同样的问题，得到了同样的答复。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","有人听见了大卫的话，就去告诉扫罗，扫罗便派人来召大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","大卫对扫罗说：“大家不要因这个非利士人而丧胆，让仆人去战他。” ");
INSERT INTO cmncbs_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","扫罗说：“你不能去，你年纪还小，他却是一个久经沙场的战士。” ");
INSERT INTO cmncbs_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","大卫说：“我一直替父亲放羊，有时候狮子或熊会从羊群中叼走羊， ");
INSERT INTO cmncbs_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","我会去追打它，把羊从它口中救出来。如果它起来攻击我，我就揪着它的胡子把它打死。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","我曾打死过狮子和熊。这未受割礼的非利士人竟敢向永活上帝的军队骂阵，他的下场也必像狮子和熊一样。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","耶和华曾经从狮子和熊的利爪下拯救我，祂也必从这非利士人手中拯救我。”扫罗对大卫说：“去吧，愿耶和华与你同在。” ");
INSERT INTO cmncbs_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","扫罗把自己的战袍给大卫穿上，又给他戴上自己的头盔，穿上自己的铠甲。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","大卫把刀挎在战袍上，试着走了几步，却不习惯这种装束，就对扫罗说：“我穿着这些无法走路，因为我不习惯。”他便摘下头盔，卸下铠甲， ");
INSERT INTO cmncbs_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","然后拿着杖，在溪里捡了五块光滑的石头放进牧人用的袋子，拿着投石器向歌利亚走去。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","歌利亚也迎着大卫走来，卫士拿着他的盾牌走在前面。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","歌利亚见大卫是个面色红润、相貌英俊的少年，就藐视他。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","他对大卫说：“你拿着棍子来战我，难道我是一条狗吗？”他就凭自己的神明咒诅大卫， ");
INSERT INTO cmncbs_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","又说：“你过来，我要把你的肉丢给天上的飞禽和地上的走兽。” ");
INSERT INTO cmncbs_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","大卫答道：“你是靠刀枪剑戟来攻击我，我是靠万军之耶和华的名，就是你所蔑视的以色列军队的上帝来迎战你。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","今天，耶和华必把你交在我手中，我必杀死你，砍掉你的头，用非利士军兵的尸体喂飞禽走兽，使普天下都知道以色列有上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","这里所有的人都必知道耶和华拯救人不靠刀枪，因为祂掌管战争的胜负。祂必把你们交在我们手中。” ");
INSERT INTO cmncbs_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","歌利亚迎面走来的时候，大卫就飞快地跑上去应战， ");
INSERT INTO cmncbs_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","他从袋里拿出一块石子用投石器猛力抛去，石子击中歌利亚的额头，嵌了进去，他迎面栽倒在地。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","大卫就这样不用刀剑，只用投石器和一块石子战胜了那个非利士人，杀死了他。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","大卫跑到那非利士人身边，从他刀鞘里拔出刀杀了他，并割下他的头颅。非利士人看见自己的英雄死了，纷纷逃跑。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","以色列人和犹大人乘势呐喊，追杀非利士人，直追到迦特和以革伦的城门。通往迦特和以革伦的沙拉音大道上到处是非利士人的尸体。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","以色列军队追杀非利士人回来，又掳掠了他们的营地。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","大卫把那非利士人的头颅带到耶路撒冷，把那人的兵器存放在自己的帐篷中。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","扫罗看见大卫出去迎战歌利亚，就问押尼珥元帅：“押尼珥啊，那少年是谁的儿子？”押尼珥答道：“王啊，我向你发誓，我真的不知道。” ");
INSERT INTO cmncbs_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","扫罗王说：“你去查查他是谁的儿子。” ");
INSERT INTO cmncbs_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","大卫杀了歌利亚回来，押尼珥就把他带到扫罗那里，他手上还拿着那非利士人的头颅。 ");
INSERT INTO cmncbs_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","扫罗问他：“年轻人，你是谁的儿子？”大卫答道：“我是你仆人伯利恒人耶西的儿子。” ");
INSERT INTO cmncbs_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","大卫与扫罗说完话后，约拿单与大卫情投意合，他像爱自己一样爱大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","从那天起，扫罗把大卫留在身边，不让他再回父亲那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","约拿单像爱自己一样爱大卫，他与大卫立了盟约， ");
INSERT INTO cmncbs_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","并把身上的外袍、战衣、刀、弓和腰带都送给大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","无论扫罗派大卫办什么事，他都表现出色。扫罗派他做军队的将领，民众和扫罗的臣仆都非常满意。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","大卫杀死了非利士人歌利亚，与众人归来时，妇女们击鼓弹琴、载歌载舞地从以色列各城出来迎接扫罗王。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","她们跳舞歌唱：“扫罗杀死千千，大卫杀死万万。” ");
INSERT INTO cmncbs_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","扫罗听了非常愤怒，对这话很反感，就说：“她们将万万归功给大卫，将千千归功给我，只剩我的王位没有给他了！” ");
INSERT INTO cmncbs_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","扫罗从此对大卫起了嫉妒之心。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","第二天，从上帝那里来的邪灵突然降在扫罗身上，他就在屋子里叫闹不停，大卫照常为他弹琴。扫罗当时手上拿着矛， ");
INSERT INTO cmncbs_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","他突然把矛投向大卫，心想：“我要把他刺透，钉在墙上。”他投了两次，大卫都躲过了。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","耶和华离开了扫罗与大卫同在，所以扫罗忌惮大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","他把大卫调离自己身边，立为千夫长，让他领兵作战。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","耶和华与大卫同在，因此他事事成功。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","扫罗看见大卫做事精明，就忌惮他。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","以色列人和犹大人都爱戴他，因为他带领他们作战。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","扫罗对大卫说：“我要把大女儿米拉嫁给你，但你要英勇作战，效忠于我，为耶和华争战。”扫罗心里想：“我不要亲自动手，我要借非利士人的手杀他。” ");
INSERT INTO cmncbs_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","大卫说：“我算什么？我的家族在以色列那么卑微，我怎么配做王的女婿呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","到了与大卫成婚的日子，扫罗却把米拉嫁给了米何拉人亚得列。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","扫罗的次女米甲爱上了大卫，扫罗知道了非常高兴。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","他心里想：“我把这个女儿给大卫，让他中圈套，好借非利士人的手杀掉他。”于是，他对大卫说：“你现在还有一次机会做我的女婿。” ");
INSERT INTO cmncbs_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","他又吩咐臣仆，说：“你们私底下告诉大卫，说王很欣赏他，群臣都爱戴他，劝他做王的女婿。” ");
INSERT INTO cmncbs_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","扫罗的臣仆把这话告诉了大卫，大卫却说：“做王的女婿岂是一件小事呢？我不过是个贫穷卑微的人。” ");
INSERT INTO cmncbs_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","臣仆把大卫这番话回报扫罗， ");
INSERT INTO cmncbs_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","扫罗说：“你们去告诉大卫，就说王只需要一百个非利士人的包皮作聘礼，好向他的敌人报仇。”扫罗想让大卫死在非利士人的手上。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","臣仆把这番话告诉了大卫，大卫欣然答应做王的女婿。期限到来之前， ");
INSERT INTO cmncbs_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","大卫和部下出去杀了二百个非利士人，把他们的包皮全部献给扫罗，好做王的女婿。扫罗便把女儿米甲嫁给了大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","扫罗知道耶和华与大卫同在，自己的女儿米甲也爱他， ");
INSERT INTO cmncbs_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","就更加忌惮大卫，终生与大卫为敌。 ");
INSERT INTO cmncbs_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","非利士人的将领常来进犯，大卫每次作战总比扫罗的其他臣仆出色，因而倍受尊重。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","扫罗吩咐他儿子约拿单和众臣仆去杀掉大卫。但约拿单非常喜爱大卫， ");
INSERT INTO cmncbs_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","便告诉他，说：“我父亲要杀你，明天早上你要小心，找个僻静的地方躲起来。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","我会出去和父亲站在你藏身的田间，跟他提你的事，然后把消息告诉你。” ");
INSERT INTO cmncbs_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","约拿单就在父亲面前替大卫说好话，他说：“王不要伤害大卫，他从来没有对不起王，他所做的使王大受益处。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","他冒着生命危险去杀非利士人，耶和华使以色列人大获全胜，当时你看见了，非常欢喜，现在为什么要犯罪，枉杀无辜的大卫呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","扫罗听了约拿单的话，就凭永活的耶和华起誓说：“我不杀大卫。” ");
INSERT INTO cmncbs_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","约拿单叫来大卫，把经过告诉他，带他去见扫罗，大卫又像以前一样伺候扫罗。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","后来，战事再度爆发，大卫领兵与非利士人交战，大败敌人，杀得他们四散溃逃。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","一天，扫罗手里拿着矛正坐在家中，从耶和华那里来的邪灵降临在扫罗身上。大卫正在弹琴， ");
INSERT INTO cmncbs_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","扫罗想用矛把大卫刺透，钉在墙上，大卫躲开了，矛插在了墙上。大卫当晚逃走了。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","扫罗派人去监视大卫的家，要在早上杀死他。大卫的妻子米甲警告他说：“你如果今晚不逃命，明早必死无疑。” ");
INSERT INTO cmncbs_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","于是，她从窗口把大卫缒下去，让他逃走了。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","然后她把家中的神像放在床上，头枕在山羊毛的枕头上，盖上衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","扫罗派人来捉拿大卫的时候，米甲说他病了。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","扫罗又派人去见大卫，并吩咐说：“把他连床一起抬来，我好杀他。” ");
INSERT INTO cmncbs_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","众人进去发现躺在床上的是一个神像，头枕在山羊毛的枕头上。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","扫罗问米甲：“你为什么欺骗我，让我的敌人逃走？”米甲答道：“他说如果我不让他逃走，就杀了我。” ");
INSERT INTO cmncbs_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","大卫逃到住在拉玛的撒母耳那里，把扫罗的所作所为告诉他。后来，他和撒母耳去拿约住了下来。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","扫罗听说大卫在拉玛的拿约， ");
INSERT INTO cmncbs_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","就派人去捉拿他。扫罗的人看到一群先知在说预言，撒母耳在当中带领他们。上帝的灵也临到扫罗的人，他们也说起预言来。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","扫罗听说后又派人去，派去的人也说起预言来。扫罗第三次派人去，派去的人同样说起预言来。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","最后扫罗亲自前往拉玛，走到西沽的大井，问撒母耳和大卫在哪里，有人说在拉玛的拿约。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","扫罗便去拉玛的拿约。上帝的灵临到扫罗，他就一边走一边说起预言来，一直到拉玛的拿约。 ");
INSERT INTO cmncbs_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","他脱下自己的衣服，在撒母耳面前说起预言来。他赤身躺了一天一夜。因此有句俗语说：“扫罗也在先知当中吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","大卫从拉玛的拿约逃出来去见约拿单，问他：“我做了什么？犯了什么罪？我什么地方对不起你父亲，他竟追杀我？” ");
INSERT INTO cmncbs_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","约拿单答道：“绝无此事，你不会死的！我父亲事无大小都会告诉我的，他不会瞒着我这件事，不会的。” ");
INSERT INTO cmncbs_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","大卫发誓说：“你父亲深知你恩待我，他为了不使你伤心，才瞒着你。但我凭永活的耶和华和你的性命起誓，我离死亡仅一步之遥！” ");
INSERT INTO cmncbs_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","约拿单说：“你有什么需要？我一定相助。” ");
INSERT INTO cmncbs_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","大卫答道：“明天是初一，我本该跟王一起用餐，请让我躲到田间，直到第三天晚上。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","如果你父亲问起我，你就说我恳求你允许我回到故乡伯利恒，因为我全家正在那里献年祭。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","如果你父亲说‘好吧’，仆人就平安无事了。如果他发怒，就表示他决意要杀我。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","请你善待仆人，因你与我在耶和华面前立了盟约。如果我有罪，就请你亲手杀了我，何必把我交给你父亲呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","约拿单答道：“我决不会这样做。我如果知道父亲决意要杀你，怎能不通知你呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","大卫说：“你父亲如果向你发怒，谁来告诉我呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","约拿单说：“我们一起到田野去吧。”于是，二人一起去了田野。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","约拿单对大卫说：“愿以色列的上帝耶和华作证，明天或后天这个时侯我就会打探到我父亲的意思，如果他善意待你，我会派人通知你。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","如果他有意杀你，而我却不告诉你让你安然逃走，愿耶和华重重地惩罚我。愿耶和华与你同在，像从前与我父亲同在一样。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","在我有生之年，请你照耶和华的慈爱恩待我，免我一死。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","在我死后，即使耶和华把你所有的仇敌都毁灭了，请你仍旧恩待我的后人。” ");
INSERT INTO cmncbs_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","于是，约拿单与大卫家立下盟约，说：“如果大卫不守盟约，愿耶和华借着仇敌惩罚他。” ");
INSERT INTO cmncbs_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","约拿单因为像爱自己一样爱大卫，便叫他再次起誓。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","约拿单说：“明天是初一，人们会注意到你缺席。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","到了后天，你要赶快去上次出事时躲藏的以色磐石那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","我会朝磐石的旁边射三箭，好像射靶子。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","然后，我会叫一个少年把箭拾回来。如果你听到我对他说，‘箭就在你旁边，把箭拾回来。’那就表示你可以回来了，我凭永活的耶和华起誓，你必平安无事。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","但如果我对少年说，‘箭就在你前面。’你就要离开，因为是耶和华要你离开。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","至于我们之间所立的约，耶和华永远为我们作证。” ");
INSERT INTO cmncbs_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","于是，大卫就躲到田野。初一到了，扫罗王入席吃饭， ");
INSERT INTO cmncbs_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","他照常坐在靠墙的位置，约拿单坐在对面，押尼珥坐在王的身边，大卫的位子空着。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","那一天，扫罗并没有说什么，他以为大卫可能遇到了使自己不洁净的事，不能赴宴。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","可是到了第二天，就是初二，大卫的座位还是空的，扫罗就问儿子约拿单：“耶西的儿子为什么这两天都不来赴宴呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","约拿单答道：“大卫恳求我让他回到伯利恒， ");
INSERT INTO cmncbs_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","因为他家要在城中献祭，他的哥哥要他去。他求我恩准他去见他的哥哥们。所以，他没有来参加王的宴席。” ");
INSERT INTO cmncbs_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","扫罗向约拿单发怒，对他说：“你这邪逆妇人养的！难道我不知道你是站在耶西的儿子那边吗？你这样做不但自取其辱，也使你母亲蒙羞。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","只要耶西的儿子活在世上，你和你的王位就不得安稳。你派人把他抓到我这里，他非死不可。” ");
INSERT INTO cmncbs_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","约拿单问：“为什么要杀他？他做了什么？” ");
INSERT INTO cmncbs_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","扫罗气得把矛掷向约拿单，想要杀他。约拿单知道父亲决意要杀大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","他怒气冲冲地离席，整天不肯进食，因为他看见父亲如此卑劣地对待大卫，心里非常难过。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","第二天早晨，约拿单按照和大卫的约定带着一个少年来到田野。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","约拿单对少年说：“你跑去把我射的箭拾回来。”少年就向前跑去，约拿单把箭射在他前面。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","少年跑到落箭之处的时候，约拿单就大声叫道：“箭不是在你前面吗？ ");
INSERT INTO cmncbs_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","快快去，不要耽延。”少年连忙把箭拾起来，回到主人那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","他不知道主人的用意，只有约拿单和大卫知道。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","约拿单把弓箭交给那少年，吩咐他带回城中。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","少年离开以后，大卫就从磐石南面出来，伏地拜了三拜。二人彼此亲吻，抱头痛哭，大卫更是泣不成声。 ");
INSERT INTO cmncbs_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","约拿单说：“我们已凭耶和华的名起誓，有耶和华在你我和你我的子孙之间永远为我们的盟约作证，你就安心去吧。”大卫便起身离开，约拿单也回城去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","大卫来到挪伯的祭司亚希米勒那里。亚希米勒战战兢兢地出来迎接他，问道：“你为什么独自一人，没有随从呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","大卫答道：“王差遣我来办一件事，他吩咐我不可把事情泄露给任何人。我已经吩咐部下在某处跟我会合。 ");
INSERT INTO cmncbs_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","现在你这里有什么吃的吗？请给我五个饼，或别的什么吃的。” ");
INSERT INTO cmncbs_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","祭司答道：“我们没有普通的饼，只有圣饼，你的部下如果没有亲近过女色，就可以吃。” ");
INSERT INTO cmncbs_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","大卫答道：“当然没有亲近过女色。每逢我们出来办事，即使是平常的任务，我的部下总是保持圣洁，何况这次是特别的任务。” ");
INSERT INTO cmncbs_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","于是，祭司把圣饼给他，因为那里没有别的饼，只有从耶和华的会幕里更换下来的供饼。 ");
INSERT INTO cmncbs_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","那天，扫罗的司牧长以东人多益碰巧在耶和华的会幕。 ");
INSERT INTO cmncbs_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","大卫问亚希米勒：“你这里有没有刀枪？因为王的事紧急，仓促间我连兵器也没有带。” ");
INSERT INTO cmncbs_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","祭司答道：“你在以拉谷杀的非利士人歌利亚的刀在这里，用布包着放在以弗得后面。你要就拿去吧，这里没有别的刀了。”大卫答道：“这刀再好不过了，把它给我吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","那日，大卫为了躲避扫罗，逃往迦特王亚吉那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","亚吉的臣仆对亚吉说：“这个大卫不是以色列的王吗？民众跳舞歌唱‘扫罗杀死千千，大卫杀死万万’，歌颂的不是他吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","大卫听到这些话，担心迦特王亚吉会加害于他， ");
INSERT INTO cmncbs_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","就在他们面前装作疯子，在城门上胡乱涂画，任由唾沫沿着胡子流下来。 ");
INSERT INTO cmncbs_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","亚吉对臣仆说：“你们看，这是个疯子，为什么把他带到我这里来？ ");
INSERT INTO cmncbs_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","我这里缺少疯子吗？你们怎么可以把这个家伙带到我家里，在我面前疯疯癫癫呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","大卫离开迦特，逃到亚杜兰洞。他的兄弟和亲属知道后，都来到他那里， ");
INSERT INTO cmncbs_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","所有受压迫的、负债的和心怀不满的人都纷纷来投奔他。大卫就做了他们的首领，跟随他的约有四百人。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","后来，大卫到摩押的米斯巴去，请求摩押王收留他的父母，直到他明白上帝给他的安排为止。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","大卫把父母留在了摩押王那里。在大卫住堡垒期间，他的父母一直住在摩押。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","迦得先知吩咐大卫离开堡垒回犹大去，大卫就动身前往哈列的树林。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","当时，扫罗正在基比亚的拉玛，坐在柳树下，手中拿着矛，臣仆侍立在左右。他得知大卫一行人的行踪后， ");
INSERT INTO cmncbs_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","就对左右的臣仆说：“便雅悯人啊，你们听着！难道耶西的儿子会给你们田地和葡萄园吗？他能立你们做千夫长和百夫长吗？ ");
INSERT INTO cmncbs_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","为什么你们一同谋害我？我的儿子跟耶西的儿子立约，没有人告诉我。就是今天我的儿子鼓动我的臣仆来谋害我，也没有人关心我，告诉我。” ");
INSERT INTO cmncbs_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","以东人多益正站在扫罗的臣仆中，他说：“我在挪伯亲眼看见耶西的儿子到了亚希突的儿子亚希米勒那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","亚希米勒为他求问耶和华，给他食物，还把非利士人歌利亚的刀给了他。” ");
INSERT INTO cmncbs_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","于是，扫罗派人把挪伯的祭司——亚希突的儿子亚希米勒及其家人都召来。他们都来到王面前。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","扫罗说：“亚希突的儿子，听着！”亚希米勒答道：“我主啊，我在这里。” ");
INSERT INTO cmncbs_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","扫罗说：“你为什么和耶西的儿子一同谋害我？你为什么把食物和刀给他，又为他求问耶和华，使他像今天这样背叛我，伺机害我呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","亚希米勒答道：“王的臣仆中有谁像大卫那样忠心呢？他是王的女婿，又是王的护卫长，在王室中受尊重。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","那也不是我第一次为他求问耶和华，求王不要因这事加罪于我或我的家人，因为仆人我对这事一无所知。” ");
INSERT INTO cmncbs_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","王却说：“亚希米勒啊，你和你全家都必死无疑！” ");
INSERT INTO cmncbs_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","他就命令身旁的护卫，说：“把这些耶和华的祭司杀掉，因为他们跟大卫同谋，明知道大卫在潜逃，却不来告诉我。”扫罗的臣仆不愿意下手杀害耶和华的祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","扫罗就对多益说：“你去把祭司杀掉！”以东人多益就杀了他们。那天，他下手杀了八十五个穿细麻布以弗得的祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","他又把祭司城挪伯的男女老少、牛羊和驴全部用刀杀掉。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","但是，亚希突之子亚希米勒有个儿子亚比亚他逃出去，投奔了大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","亚比亚他把扫罗屠杀耶和华祭司的事告诉了大卫， ");
INSERT INTO cmncbs_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","大卫说：“那天我见以东人多益在那里，就知道他一定会告诉扫罗。是我连累了你父亲一家。 ");
INSERT INTO cmncbs_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","你就放心留在我这里，不要害怕，想杀你的人，也想要杀我。你在我这里很安全。” ");
INSERT INTO cmncbs_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","一天，大卫得知非利士人正在攻打基伊拉，抢掠麦场， ");
INSERT INTO cmncbs_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","便求问耶和华：“我可以去攻打非利士人吗？”耶和华答道：“你可以去攻打非利士人，营救基伊拉。” ");
INSERT INTO cmncbs_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","大卫的部下却对他说：“我们在犹大这里尚且胆战心惊，何况去基伊拉攻打非利士军队呢！” ");
INSERT INTO cmncbs_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","大卫再求问耶和华，耶和华答道：“到基伊拉去吧，我一定把非利士人交在你手里。” ");
INSERT INTO cmncbs_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","于是，大卫和部下到基伊拉去攻打非利士人，大败敌人，夺取了他们的牲畜，救出基伊拉人。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","亚希米勒的儿子祭司亚比亚他到基伊拉投奔大卫时，把以弗得也带了去。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","扫罗得知大卫在基伊拉，就说：“这一次是上帝把他交在我手中了，因为他竟然自投网罗，进入有门有闩的城。” ");
INSERT INTO cmncbs_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","扫罗召集全军准备攻打基伊拉，围困大卫和他的部下。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","大卫知道了扫罗的计谋，便吩咐祭司亚比亚他把以弗得带来， ");
INSERT INTO cmncbs_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","然后说：“耶和华，以色列的上帝啊，仆人听说扫罗要来毁灭基伊拉城，因为我在这里。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","基伊拉的人会不会把我交给扫罗呢？扫罗是不是像我听说的那样要来这里呢？耶和华，以色列的上帝啊，求你告诉我。”耶和华说：“扫罗一定会来。” ");
INSERT INTO cmncbs_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","大卫又问耶和华：“基伊拉的人会不会把我和我的部下交给扫罗呢？”耶和华说：“他们一定会。” ");
INSERT INTO cmncbs_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","于是，大卫率领自己的六百部下离开基伊拉，到处流浪。扫罗得知大卫已经离开基伊拉，就不去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","大卫住在旷野的堡垒或西弗旷野的山区。扫罗天天搜捕大卫，但上帝没有把大卫交在他的手中。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","大卫在西弗旷野的何利沙得知扫罗要来杀他。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","扫罗的儿子约拿单去何利沙见大卫，鼓励大卫坚定地信靠上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","他对大卫说：“不要害怕，我父亲扫罗害不了你。你将做以色列的王，我将做你的宰相。我父亲也明白这一点。” ");
INSERT INTO cmncbs_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","二人在耶和华面前立了约。之后，大卫仍留在何利沙，约拿单则回家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","西弗人去基比亚见扫罗，说：“大卫就躲在我们那里，在旷野南面哈基拉山上何利沙的堡垒里。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","王啊，你随时都可以下来，我们一定把他交在王的手里。” ");
INSERT INTO cmncbs_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","扫罗说：“愿耶和华赐福给你们！因为你们体恤我。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","我听说他非常狡猾，你们再回去弄清楚他的行踪及谁在那里见过他， ");
INSERT INTO cmncbs_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","查明他的藏身之处，回来如实告诉我，然后我会与你们同去。如果他在犹大境内，我要搜遍千家万户，找到他。” ");
INSERT INTO cmncbs_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","于是，西弗人先回去了。当时大卫和他的部下在旷野南面的亚拉巴，即玛云旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","大卫听说扫罗和手下正在搜寻他，便率领部下前往玛云旷野的磐石，住在那里。扫罗得知后，便去玛云旷野追赶大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","扫罗在山这边走，大卫和他的部下在山那边走，急急忙忙地躲避扫罗。扫罗和他的手下四面包围过来，眼看就要抓住他们了。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","这时，扫罗的信使前来禀报，说非利士人前来犯境，请王速回。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","扫罗只好放弃追赶大卫，回师迎战非利士人。因此，那地方叫“脱险岩”。 ");
INSERT INTO cmncbs_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","后来，大卫从那里转移到隐·基底的堡垒里。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","扫罗追击非利士人回来，得知大卫在隐·基底的旷野， ");
INSERT INTO cmncbs_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","就率领三千以色列精兵去野羊岩附近搜索大卫和他的部下。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","他们来到路旁的一处羊圈，那里有一个山洞，扫罗进去大解。大卫和他的部下就躲在洞的深处。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","大卫的部下对大卫说：“耶和华说过要把你的仇敌交在你手中，任你处置，今天机会来了。”大卫就爬过去，偷偷割了扫罗外袍的一角。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","事后，大卫心里不安， ");
INSERT INTO cmncbs_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","他对部下说：“我不该做这样的事，我主是耶和华所膏立的王，我绝不出手伤害他，因为他是耶和华所膏立的。” ");
INSERT INTO cmncbs_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","大卫用这些话拦住他的部下，不让他们杀扫罗。 扫罗起来离开山洞走了， ");
INSERT INTO cmncbs_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","大卫随后也来到洞外，在后面喊扫罗：“我主我王啊！”扫罗回头一看，见大卫俯伏在地，向他下拜。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","大卫对扫罗说：“你为什么听信谗言，认为我要谋害你呢？ ");
INSERT INTO cmncbs_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","你现在亲眼看见了，刚才在山洞里，耶和华把你交在我手中，有人叫我杀你，我却不肯，因为你是耶和华所膏立的王，我不会动手伤害你。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","我父请看，你的这块袍子在我手中。我割下了你的袍角，没有杀你，现在你应该明白我并未图谋背叛你。我没有对不起你，你却要置我于死地。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","愿耶和华在你我之间判定是非，替我申冤，我却不会动手伤害你。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","俗语说，‘恶事出于恶人’，所以我不会动手伤害你。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","以色列王出来要捉拿谁呢？一条死狗吗？一只跳蚤吗？ ");
INSERT INTO cmncbs_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","愿耶和华做我们的审判官，在你我之间判定是非。愿耶和华鉴察，为我申冤，从你手中拯救我。” ");
INSERT INTO cmncbs_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","大卫说完了，扫罗问道：“我儿大卫啊！是你吗？”便放声大哭起来。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","扫罗对大卫说：“你比我公义，因为你善待我，我却恶待你。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","你今天使我明白你善待了我，耶和华把我交在你手中，你却没有下手杀我。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","有谁会让自己手中的仇敌平安离去呢？愿耶和华因你今日善待我而赐福你。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","我知道你必做王，以色列国必在你手中得到坚固。 ");
INSERT INTO cmncbs_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","现在请你凭耶和华向我起誓，你不会杀害我的子孙，灭绝我的后代。” ");
INSERT INTO cmncbs_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","大卫便向扫罗起誓。之后，扫罗回家了，大卫和部下也回堡垒去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","撒母耳死了，以色列人都聚在一起哀悼他，把他安葬在拉玛他自己的坟地里。之后，大卫到了巴兰的旷野。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","玛云有个富翁拥有三千只绵羊和一千只山羊，他的产业在迦密。当时他正在迦密剪羊毛。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","他名叫拿八，是迦勒族人，妻子名叫亚比该，既聪慧又漂亮。拿八粗暴凶恶。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","大卫在旷野得知拿八正在剪羊毛， ");
INSERT INTO cmncbs_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","就派十个部下到迦密去见拿八，吩咐他们以他的名义向拿八问安， ");
INSERT INTO cmncbs_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","对拿八说：“愿你和你全家平安，愿你一切顺利！ ");
INSERT INTO cmncbs_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","我听说你正在剪羊毛。你的牧人与我们在迦密的时候，我们没有欺负过他们，他们没有丢过任何东西。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","你问问你的仆人就知道了。请你恩待我的部下，因为今天是好日子，求你随手赏一点东西给仆人们和晚辈我。” ");
INSERT INTO cmncbs_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","大卫的部下就去把大卫的话告诉拿八，等候他的答复。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","拿八说：“大卫是谁？耶西的儿子是谁？这些日子有很多仆人逃离主人， ");
INSERT INTO cmncbs_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","我怎能把饼、水和为剪羊毛者预备的肉分给一群来历不明的人呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","大卫的部下回去把拿八的话禀告大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","大卫听了，就吩咐众人备刀，他自己也带了刀去拿八那里。大卫带了四百人去，留下二百人看守辎重。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","拿八的一个仆人告诉拿八的妻子亚比该说：“大卫从旷野派人来向我们主人问安，主人却辱骂他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","那些人对我们很好，从来不欺负我们。我们跟他们一起在田野的时候，从来没有丢过任何东西。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","我们在他们附近牧羊的时候，他们昼夜不断地保护我们。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","所以，请你赶快想个法子，不然主人和他全家恐怕都会大难临头。主人是个凶暴的人，没有人敢跟他说话。” ");
INSERT INTO cmncbs_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","亚比该连忙用驴驮上二百块饼、两皮袋酒、五只宰好了的羊、三十七升烤麦、一百块葡萄饼和二百块无花果饼， ");
INSERT INTO cmncbs_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","又吩咐仆人说：“你们先去吧！我随后就来。”她没有把这事告诉丈夫拿八。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","她骑着驴下山的时候，就看见大卫和他的部下迎面而来。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","大卫曾说：“我在旷野保护这人的羊群，使它们不致丢失，真是枉费功夫。他竟以怨报德。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","如果我让他家里一个男子活到明早，愿上帝重重地惩罚我！” ");
INSERT INTO cmncbs_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","亚比该看见大卫，连忙下驴俯伏下拜。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","她俯伏在大卫脚前说：“我主啊，我愿意承担一切罪过，请听婢女说。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","请不要理会拿八那个恶徒，他人如其名，是个名符其实的蠢人。当时婢女没有见到你派来的使者。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","我主啊，既然耶和华阻止你亲手杀人报仇，我就凭永活的耶和华和你的性命起誓，愿你的仇敌和伤害你的人都像拿八一样没有好下场。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","现在，请把婢女带来的礼物分给你的部下吧。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","请饶恕婢女的罪过，耶和华必使你的子孙世代做王，因为你是在为耶和华而战，愿你一生没有过错。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","你就是被人追杀，也会在你的上帝耶和华的保护下安然无恙。你敌人的性命却要像石头一样被耶和华用投石器抛出去。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_30","010_25_30","1SA","25","30","31","如果你现在没有杀人报仇，伤害无辜，到了耶和华照应许赐福给你、立你做以色列王的时候，你就不会心里不安了。我主啊，耶和华赐福给你的时候，求你不要忘了婢女。” ");
INSERT INTO cmncbs_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","大卫对亚比该说：“以色列的上帝耶和华当受称颂！祂今天派你来见我。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","你很有见识，你今天拦阻我亲手杀人复仇，值得称赞。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","我凭阻止我杀你的以色列的上帝——永活的耶和华起誓，若不是你赶来迎接我，拿八家中不会有一个男子活到明天早上。” ");
INSERT INTO cmncbs_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","大卫接受了亚比该的礼物，对她说：“安心回家吧，我答应你的请求。” ");
INSERT INTO cmncbs_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","她回到家时，拿八正在大摆宴席，排场如御宴。她见拿八心情愉快，喝得酩酊大醉，就什么也没告诉他，等第二天早上再说。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","次日清晨，拿八酒醒以后，他妻子把发生的一切告诉他，他吓得昏死过去，身体僵硬如石。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","过了十天，耶和华击打拿八，他就死了。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","大卫听见拿八的死讯，就说：“赞美耶和华！拿八羞辱我，祂为我申了冤，又阻止仆人行恶。祂使拿八得到了报应。”后来，大卫差遣使者去向亚比该求婚。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","他的使者就启程到迦密去向亚比该传达大卫的心意。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","亚比该听了，立刻俯伏在地上说：“婢女愿意效劳，为我主的仆人洗脚。” ");
INSERT INTO cmncbs_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","她连忙骑上驴，带了五个侍女，跟随大卫的使者前去，做了大卫的妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","大卫已经娶了耶斯列人亚希暖，她们二人就同做大卫的妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","扫罗已经把自己的女儿、大卫的妻子米甲嫁给了迦琳人拉亿的儿子帕提。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","西弗人到基比亚见扫罗，说：“大卫正躲在旷野附近的哈基拉山中。” ");
INSERT INTO cmncbs_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","扫罗就带领三千以色列精兵到西弗的旷野去追捕大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","他们在旷野附近路边的哈基拉山上扎营。大卫在旷野听说扫罗追来了， ");
INSERT INTO cmncbs_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","就派人去打探消息，得知扫罗的追兵果然已到。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","大卫来到扫罗的营地，看见了他和他的元帅尼珥的儿子押尼珥睡觉的地方，他睡在军营中间，其他人围绕着他扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","大卫问赫人亚希米勒和洗鲁雅的儿子约押的兄弟亚比筛：“谁愿意跟我到扫罗的营里？”亚比筛答道：“我愿意。” ");
INSERT INTO cmncbs_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","大卫和亚比筛就趁夜间走进扫罗的军营，发现扫罗正在熟睡，他的矛插在地上，靠近他的头，押尼珥和其他人睡在他周围。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","亚比筛对大卫说：“现在上帝把你的敌人交在你手中了，让我一矛把他钉在地上，决不用刺第二下。” ");
INSERT INTO cmncbs_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","大卫却说：“不要杀他，谁杀害耶和华所膏立的王，都难逃罪责。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","我凭永活的耶和华起誓，耶和华必亲手击杀他。他要么寿终而死，要么命丧沙场。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","我在耶和华面前绝不敢出手伤害祂所膏立的王。我们拿走他旁边的矛和水瓶吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","大卫拿上扫罗的矛和水瓶便同亚比筛离开了，没有人看见，没有人知道，他们都在沉睡，没有人醒来，因为耶和华使他们都熟睡了。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","大卫爬上营地对面的山坡，远远地站在山顶上，与他们相距很远。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","他呼喊扫罗的士兵和尼珥的儿子押尼珥：“押尼珥，你回答我！”押尼珥问道：“你是谁，竟敢在王面前喊叫？” ");
INSERT INTO cmncbs_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","大卫说：“你不是勇士吗？在以色列有谁比得上你呢？有人来刺杀你的王你的主，你为何没有保护他呢？ ");
INSERT INTO cmncbs_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","你失职了。我凭永活的耶和华起誓，你们都该死。因为你们没有保护你们的主——耶和华所膏立的王。你看看王头旁的矛和水瓶在哪里？” ");
INSERT INTO cmncbs_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","扫罗听出是大卫的声音，就说：“我儿大卫！是你吗？”大卫答道：“我主我王啊，是我。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","我主为什么又要追杀仆人呢？我做错了什么，犯了什么罪？ ");
INSERT INTO cmncbs_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","我主我王，请听仆人说，如果是耶和华使你与我作对，愿祂悦纳我献上的祭物；如果这是出于人的主意，愿他们在耶和华面前受咒诅。因为他们赶我离开耶和华所赐的产业，叫我去供奉其他神明。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","求你不要让我死在远离耶和华的异乡！以色列王为何要像在山上猎杀鹧鸪一样追捕一只跳蚤呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","扫罗说：“我犯罪了。我儿大卫，你回来吧，我不会再伤害你，因为你今日保存了我的性命。我真是糊涂，犯了大错。” ");
INSERT INTO cmncbs_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","大卫答道：“王的矛在这里，请派一个人来拿回去吧。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","耶和华奖赏公义、信实的人。今天耶和华把你交在我手中，但我不愿下手伤害耶和华所膏立的王。 ");
INSERT INTO cmncbs_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","我今天保存了你的性命，愿耶和华也保存我的性命，救我脱离一切患难。” ");
INSERT INTO cmncbs_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","扫罗对大卫说：“我儿大卫，愿你蒙福。你一定能建功立业，战胜仇敌。”于是，大卫起身离开，扫罗也回家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","大卫心里想：“终有一天，我会死在扫罗手里，我最好逃到非利士人那里。这样，扫罗就不会在以色列到处追捕我了，我便可以逃离他的手。” ");
INSERT INTO cmncbs_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","于是，大卫率领他的六百个随从去投靠玛俄的儿子迦特王亚吉。 ");
INSERT INTO cmncbs_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","他部下的家眷和他的两位妻子耶斯列人亚希暖和拿八的遗孀迦密人亚比该也跟他一同住在迦特王亚吉那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","扫罗听到这个消息，就不再追捕他了。 ");
INSERT INTO cmncbs_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","大卫对亚吉说：“如果你开恩，就让我到郊野的一个城邑去住吧，何必让仆人与王一同住在都城呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","亚吉当天把洗革拉赐给他，因此那地方至今仍属犹大王。 ");
INSERT INTO cmncbs_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","大卫在非利士人的地方共住了一年零四个月。 ");
INSERT INTO cmncbs_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","他率领部下袭击基述人、基色人和亚玛力人，这些人自古以来就住在远至书珥和埃及一带的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","大卫攻打那一带，杀死所有的人，抢走牛、羊、驴、骆驼和衣物，回去见亚吉。 ");
INSERT INTO cmncbs_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","当亚吉问：“你们今天攻打了哪里？”大卫会说：“攻打了犹大南部”，或说：“攻打了耶拉篾南部”，或说：“攻打了基尼南部。” ");
INSERT INTO cmncbs_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","大卫把那地方的人都杀掉，一个也不带到迦特，因为他害怕他们会泄露真相。大卫在非利士人那里居住的时候，常常这样做。 ");
INSERT INTO cmncbs_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","亚吉相信了大卫的话，心里想：“以色列人恨透了大卫，他必永远做我的仆人。” ");
INSERT INTO cmncbs_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","非利士人召集大军与以色列人交战。亚吉对大卫说：“你应该明白，你和部下要随我一起出战。” ");
INSERT INTO cmncbs_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","大卫答道：“仆人愿意效劳。”亚吉说：“很好！你就终生做我的护卫吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","那时撒母耳已经死了，以色列举国都为他哀悼，把他葬在他的家乡拉玛。当时，扫罗已把所有占卜和行巫术的都逐出了以色列。 ");
INSERT INTO cmncbs_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","非利士人集合起来，在书念扎营，扫罗率领以色列军队在基利波扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","扫罗看见非利士军队声势浩大，吓得胆战心惊， ");
INSERT INTO cmncbs_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","就求问耶和华，但耶和华没有借着梦、乌陵或先知回答他。 ");
INSERT INTO cmncbs_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","于是，扫罗命令臣仆找一个巫婆来，好求问她。臣仆在隐·多珥找到一个巫婆。 ");
INSERT INTO cmncbs_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","扫罗乔装打扮，由两个人陪同乘夜赶到那妇人家里，说：“请你用法术把我要求问的亡灵招上来吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","妇人对他说：“你知道扫罗铲除了国内占卜的和行巫术的，你为何来陷害我，置我于死地？” ");
INSERT INTO cmncbs_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","扫罗凭耶和华向妇人起誓，说：“我凭永活的耶和华起誓，你必不会因为此事而受到惩罚。” ");
INSERT INTO cmncbs_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","妇人问道：“你想让我招谁上来呢？”扫罗答道：“招撒母耳上来。” ");
INSERT INTO cmncbs_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","妇人看见了撒母耳，就惊叫起来，对扫罗说：“你是扫罗，你为什么骗我呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","扫罗王对她说：“不要害怕，你看见什么了？”妇人说：“我看见一个灵从地里上来。” ");
INSERT INTO cmncbs_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","扫罗说：“他是什么模样？”妇人说：“是个身披长袍的老人。”扫罗知道是撒母耳，便俯伏在地，向他下拜。 ");
INSERT INTO cmncbs_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","撒母耳对扫罗说：“你为什么打扰我，招我上来呢？”扫罗答道：“我深陷困境，非利士人与我们交战，上帝也撇弃了我，不再借着先知或梦来回答我。因此，我只好招你上来，好告诉我该怎么办。” ");
INSERT INTO cmncbs_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","撒母耳说：“既然耶和华已经离弃了你，与你为敌，你为什么还来问我？ ");
INSERT INTO cmncbs_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","耶和华应验了祂借着我所说的预言，祂已把你的国权夺去，交给了你的同胞大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","耶和华今天这样对待你，是因为你没有听从祂的吩咐，没有把祂憎恶的亚玛力人灭绝。 ");
INSERT INTO cmncbs_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","耶和华必把你和以色列人交在非利士人手里，明天你和你的儿子们必跟我在一起了。耶和华必把以色列的军队交在非利士人手里。” ");
INSERT INTO cmncbs_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","扫罗听了撒母耳的话，顿时吓得浑身僵直，倒在地上。他因一天一夜没有进食，已经毫无力气。 ");
INSERT INTO cmncbs_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","妇人到扫罗跟前，看见他惊恐万分，就对他说：“婢女冒着生命危险服从你的命令，照你的吩咐做了。 ");
INSERT INTO cmncbs_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","现在，请你听婢女的话，让我给你一些食物吃，你好有体力赶路。” ");
INSERT INTO cmncbs_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","扫罗不肯，说：“我不吃。”他的随从和妇人再三劝告，他才同意了，从地上起来坐到床上。 ");
INSERT INTO cmncbs_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","妇人连忙宰了家中一只小肥牛，又和面烤了无酵饼， ");
INSERT INTO cmncbs_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","摆在扫罗和他的随从面前，他们吃完后，当晚就离开了。 ");
INSERT INTO cmncbs_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","非利士人把全部军队聚集在亚弗，以色列军则在耶斯列水泉旁扎营。 ");
INSERT INTO cmncbs_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","非利士首领统率以百人和千人为单位的士兵向前推进，大卫和他的部下跟着亚吉走在队伍后面。 ");
INSERT INTO cmncbs_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","非利士人的官长说：“这些希伯来人在这里做什么？”亚吉告诉他们说：“这是以色列王扫罗的臣仆大卫，他追随我有一段日子了，自从他投奔我以来，我没发现他有什么过错。” ");
INSERT INTO cmncbs_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","他们却生气地说：“请送这个人回到你安置他的地方，他不可和我们一起去打仗，免得他在战场上倒戈。他提着我们的脑袋去重投故主岂不是最好的方法吗？ ");
INSERT INTO cmncbs_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","以前妇女们跳舞歌唱‘扫罗杀死千千，大卫杀死万万’，歌颂的不就是这个大卫吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","亚吉便叫大卫过来，对他说：“我凭永活的耶和华起誓，你一向忠心耿耿，自从你投奔我以来，我没发现你有什么过错，我很愿意你与我一同作战，只是众首领不赞成。 ");
INSERT INTO cmncbs_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","你安心地回去吧，免得他们不悦。” ");
INSERT INTO cmncbs_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","大卫说：“我究竟做错了什么？自从仆人投奔你以来，你发现仆人有什么过错？为什么不让我为我主我王杀敌呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","亚吉说：“你在我眼中就像上帝的天使一样好，只是非利士众官长反对你与我们一起出战。 ");
INSERT INTO cmncbs_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","明天一早，你就和从扫罗手下投奔你的人启程回去吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","于是，大卫和部下清早起来返回非利士，非利士军则前往耶斯列。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","第三天，大卫率领部下回到洗革拉的时候，发现亚玛力人袭击了南地和洗革拉，攻破了洗革拉城，把全城烧毁， ");
INSERT INTO cmncbs_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","并掳走了城内的妇女及所有老少，没有杀任何人。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","大卫和部下来到洗革拉城，看到城被烧毁，妻子儿女都被掳走了， ");
INSERT INTO cmncbs_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","便放声大哭，直哭得精疲力尽。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","大卫的两个妻子耶斯列人亚希暖和拿八的遗孀迦密人亚比该也一起被掳走了。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","跟随大卫的人因自己的儿女被掳去，心里很痛苦，商议要用石头打死大卫。大卫深陷困境，但他靠着他的上帝耶和华得到了力量。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","大卫吩咐亚希米勒的儿子亚比亚他祭司把以弗得拿来，亚比亚他就拿给他。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","大卫求问耶和华，说：“我该追赶敌人吗？我能追上他们吗？”耶和华答道：“追赶他们吧，你必能追上他们，救回一切。” ");
INSERT INTO cmncbs_vpl VALUES ("S130_9","010_30_9","1SA","30","9","10","于是，大卫率领六百名部下前去追赶，到了比梭溪，有二百人因为太累而不能过溪，就留在那里。大卫率领其余的四百人继续追赶。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","他们在田野遇见一个埃及人，就把他带到大卫那里。他们给他饼吃，给他水喝， ");
INSERT INTO cmncbs_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","还给他一块无花果饼和两个葡萄饼。他吃完后，恢复了体力，因为这人已经三天三夜没吃没喝了。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","大卫问他：“你是谁的仆人？你从哪里来？”他答道：“我是埃及人，是亚玛力人的奴仆。三天前，主人因为我患病把我撇弃了。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","我们袭击了基利提的南方，犹大地区和迦勒南部，还烧毁了洗革拉。” ");
INSERT INTO cmncbs_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","大卫又问他：“你可以领我去这些袭击者那里吗？”他答道：“你先凭上帝向我起誓，你不杀我，也不把我交给我的主人，我就带你去。” ");
INSERT INTO cmncbs_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","他带着大卫找到那里，见亚玛力人正散布在各处吃喝狂欢，因为他们从非利士和犹大抢夺了很多财物。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","大卫率领部下从黎明攻打他们，直到次日黄昏。除了四百个青年骑骆驼逃脱外，亚玛力人全军覆没。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","大卫夺回亚玛力人掳去的一切，包括他的两个妻子。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","他尽数夺回了被掳去的男女老少和财物， ");
INSERT INTO cmncbs_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","也夺了所有的牛羊。他的部下把这些牛羊赶到自己的牲畜前面，说：“这是大卫的战利品。” ");
INSERT INTO cmncbs_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","大卫回到留在比梭溪的那二百名因为太疲乏而没有同去的人那里，他们出来迎接大卫和众随从，大卫也上前问候他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","大卫随从中那些恶徒和无赖说：“他们没有跟我们一起去打仗，我们抢回来的东西不应分给他们，只让他们带走自己的妻子和儿女就好了。” ");
INSERT INTO cmncbs_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","大卫说：“弟兄们，这一切是耶和华赐给我们的，我们不可不分给他们，因为是耶和华保护我们，把敌人交在了我们手里。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","谁能接受你们的说法呢？上阵打仗的和看守装备的应该得到一样的待遇。” ");
INSERT INTO cmncbs_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","从那天开始，大卫就把这原则定为以色列的律例和典章，沿用至今。 ");
INSERT INTO cmncbs_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","大卫来到洗革拉，把部分战利品送给他的朋友犹大的长老们，说：“这些礼物是从耶和华的敌人那里夺来送给你们的。” ");
INSERT INTO cmncbs_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","大卫把礼物送给住在伯特利、南地的拉末、雅提珥、 ");
INSERT INTO cmncbs_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","亚罗珥、息末、以实提莫、 ");
INSERT INTO cmncbs_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","拉哈勒、耶拉篾和基尼各城、 ");
INSERT INTO cmncbs_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","何珥玛、歌拉珊、亚挞、 ");
INSERT INTO cmncbs_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","希伯仑以及他和部下所到之处的人。 ");
INSERT INTO cmncbs_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","非利士人与以色列人交战，以色列人败逃，许多人在基利波山被杀。 ");
INSERT INTO cmncbs_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","非利士人穷追扫罗及其众子，杀了扫罗的儿子约拿单、亚比拿达和麦基舒亚。 ");
INSERT INTO cmncbs_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","扫罗周围战事激烈，他被弓箭手发现后射成重伤， ");
INSERT INTO cmncbs_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","就对为他拿兵器的人说：“拔出你的刀来刺死我吧，免得那些未受割礼的人来刺杀和凌辱我。”但拿兵器的人非常害怕，不敢动手，扫罗就拿起刀来，伏刀自尽了。 ");
INSERT INTO cmncbs_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","拿兵器的人看见扫罗已死，也伏刀自尽了。 ");
INSERT INTO cmncbs_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","那一天，扫罗和他三个儿子，以及为他拿兵器的人和他的军队都死了。 ");
INSERT INTO cmncbs_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","平原一带和约旦河对面的以色列人见以色列军败逃、扫罗及其众子已死，都弃城而逃。于是，非利士人占据了那些城邑。 ");
INSERT INTO cmncbs_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","次日，非利士人来剥阵亡者的衣物，发现扫罗和他的三个儿子横尸基利波山， ");
INSERT INTO cmncbs_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","就割下扫罗的头颅，剥下他的盔甲，并派人去非利士全境，在他们偶像的庙里及民众中通告消息。 ");
INSERT INTO cmncbs_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","非利士人把扫罗的盔甲放在亚斯她录神庙里，把他的尸体钉在伯·珊城墙上。 ");
INSERT INTO cmncbs_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","基列·雅比人听见非利士人对扫罗的所作所为， ");
INSERT INTO cmncbs_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","他们所有的勇士就连夜赶到伯·珊，从墙上取下扫罗和他儿子们的尸体，运到雅比火化， ");
INSERT INTO cmncbs_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","把骨灰葬在雅比的柳树下，又为他们禁食了七天。");
INSERT INTO cmncbs_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","大卫战胜了亚玛力人之后便回到洗革拉，在那里住了两天。那时扫罗已经死了。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","第三天，有一个衣服撕裂、头蒙灰尘的人从扫罗军营中跑到大卫面前，俯伏下拜。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","大卫问他：“你从哪里来？”那人答道：“我是从以色列军营逃出来的。” ");
INSERT INTO cmncbs_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","大卫说：“请告诉我那边的情况。”他说：“以色列军溃逃，伤亡惨重，就连扫罗和他儿子约拿单都死了！” ");
INSERT INTO cmncbs_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","大卫又问报信的青年：“你怎么知道扫罗和他儿子约拿单死了？” ");
INSERT INTO cmncbs_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","青年说：“我偶然到基利波山，看见扫罗在那里倚枪而立，敌人的战车骑兵紧紧追来。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","他回头看到我，便呼唤我。我说，‘我在这里。’ ");
INSERT INTO cmncbs_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","他问我是什么人。我告诉他我是亚玛力人。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","扫罗说他痛苦不堪，却又死不掉，要我杀了他。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","我知道他身受重伤，必死无疑，就把他杀了，并取下他头上的王冠和臂上的镯子带来献给我主。” ");
INSERT INTO cmncbs_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","大卫就撕裂衣服，他的随从也撕裂衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","他们因扫罗、他的儿子约拿单和耶和华的子民以色列同胞阵亡而悲哀痛哭，禁食直到黄昏。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","大卫又问报信的青年：“你是哪里的人？”他答道：“我是寄居在以色列的亚玛力人。” ");
INSERT INTO cmncbs_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","大卫说：“你怎么敢下手杀耶和华所膏立的王？ ");
INSERT INTO cmncbs_vpl VALUES ("S21_15","011_1_15","2SA","1","15","16","你是咎由自取！因为你亲口承认自己杀了耶和华所膏立的王。”大卫随即命令一个年轻的随从杀死他，随从便杀死了他。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","大卫作了一首挽歌哀悼扫罗和他儿子约拿单， ");
INSERT INTO cmncbs_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","并吩咐人教导犹大人唱这首弓歌。这首歌记在《雅煞珥书》上，歌词说： ");
INSERT INTO cmncbs_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","“以色列啊， 你荣耀的王伏尸山上， 勇士竟然倒下！ ");
INSERT INTO cmncbs_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","不要在迦特宣告， 不要在亚实基伦的街上传扬， 免得非利士的妇女幸灾乐祸， 免得未受割礼之人的女子欢喜雀跃。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","“基利波山啊，愿你没有雨露， 你的田地不长献祭用的五谷， 因为那里有勇士锈污的盾牌， 扫罗的盾牌没有抹油。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","“约拿单的弓射敌无数， 扫罗的剑不杀强敌不收回。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","“扫罗和约拿单深受爱戴， 生死不分离。 他们比鹰更敏捷， 比狮子还强壮。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","“以色列的女子啊， 为扫罗哀哭吧！ 他曾使你们衣服华美， 穿金戴银。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","“勇士竟战死沙场！ 约拿单竟伏尸山上！ ");
INSERT INTO cmncbs_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","我的兄弟约拿单啊， 我为你悲伤， 你对我情深义重， 你对我的爱胜过女人的恋情。 ");
INSERT INTO cmncbs_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","“勇士竟然倒下！ 兵器竟然耗损！” ");
INSERT INTO cmncbs_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","这事以后，大卫求问耶和华：“我可以回到犹大的城邑吗？”耶和华说：“可以。”大卫又问：“我应该回到哪一座城呢？”耶和华说：“希伯仑。” ");
INSERT INTO cmncbs_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","大卫就带着他的两个妻子耶斯列人亚希暖和迦密人拿八的遗孀亚比该，一起上到希伯仑。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","他还把部下和他们的家属一起带去，住在希伯仑地区的城邑。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","犹大人到希伯仑膏立大卫做犹大支派的王。 大卫听说是基列·雅比人埋葬了扫罗， ");
INSERT INTO cmncbs_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","就派使者去告诉他们：“你们这样厚待你们的主人扫罗，把他安葬，愿耶和华赐福给你们！ ");
INSERT INTO cmncbs_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","愿耶和华以慈爱和信实待你们，我也会厚待你们，因为你们做了这事。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","现在你们的主扫罗已经死了，犹大支派已经膏立我做他们的王，你们要刚强勇敢。” ");
INSERT INTO cmncbs_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","那时，扫罗的元帅——尼珥的儿子押尼珥带着扫罗的儿子伊施·波设过河来到玛哈念， ");
INSERT INTO cmncbs_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","立他为王统治基列、亚书利、耶斯列、以法莲、便雅悯和以色列其余的地方。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","扫罗的儿子伊施·波设四十岁登基，统治以色列两年。犹大支派则跟随大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","大卫在希伯仑做王统治犹大支派七年半。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","有一次，尼珥的儿子押尼珥带领扫罗的儿子伊施·波设的军队，从玛哈念前往基遍。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","洗鲁雅的儿子约押带领大卫的军队出来，在基遍池与他们相遇。一方坐在池这边，一方坐在池那边。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","押尼珥对约押说：“让双方的青年起来，在我们面前较量一下吧。”约押说：“好啊。” ");
INSERT INTO cmncbs_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","于是，伊施·波设的便雅悯人和大卫的仆人双方都起身选了十二人出来， ");
INSERT INTO cmncbs_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","他们各自抓住对方的头发，用刀刺对方的肋旁，同归于尽。于是基遍的那个地方叫“刀田”。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","那天，两军恶战，押尼珥和以色列人被大卫的人马杀败。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","当时，洗鲁雅的三个儿子约押、亚比筛和亚撒黑都在场。亚撒黑跑得飞快如田野的鹿， ");
INSERT INTO cmncbs_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","他跟在押尼珥后面，不偏不离，穷追不舍。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","押尼珥回头问道：“你是亚撒黑吗？”亚撒黑说：“正是。” ");
INSERT INTO cmncbs_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","押尼珥说：“你离开我，去追赶别人，夺取他的兵器吧。”但亚撒黑还是穷追不舍。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","押尼珥又对他说：“别追我了，非逼我杀你吗？我若杀了你，还有何颜面见你哥哥约押呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","但亚撒黑还是不肯罢休。押尼珥就用枪柄刺入他的肚腹，穿透了他的后背，他便倒地身亡。众人赶到那里，都停了下来。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","但约押和亚比筛却继续追赶押尼珥。太阳落山时，他们追到了基亚附近的亚玛山，通往基遍旷野的路旁。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","便雅悯人在押尼珥的带领下聚集在一个山头上。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","押尼珥向约押喊道：“我们非要无休止地杀下去吗？难道你不知道这样下去必有苦果吗？你什么时候才命令你的人停止追杀自己的同胞呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","约押说：“我凭永活的上帝起誓，你要是不这样说，我们会一直追到天亮。” ");
INSERT INTO cmncbs_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","于是，约押吹响号角，所有的人便停止了战斗，不再追击以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","押尼珥和随从连夜赶路，穿过了亚拉巴，过了约旦河，第二天又马不停蹄地走了一个上午，回到玛哈念。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","约押追赶押尼珥回来后细点人数，发现除亚撒黑外大卫的军队还损失了十九个人。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","大卫的军队杀了三百六十个跟随押尼珥的便雅悯人。 ");
INSERT INTO cmncbs_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","约押和他的随从把亚撒黑送到伯利恒，葬在他父亲的坟墓里。然后，他们整夜赶路，黎明的时候回到了希伯仑。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","扫罗和大卫两家长期争战，大卫家的势力越来越强，扫罗家却日益衰微。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","大卫在希伯仑生的儿子有耶斯列人亚希暖所生的长子暗嫩， ");
INSERT INTO cmncbs_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","迦密人拿八的遗孀亚比该所生的次子基利押，基述王达买的女儿玛迦所生的三子押沙龙， ");
INSERT INTO cmncbs_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","哈及所生的四子亚多尼雅，亚比她所生的五子示法提雅， ");
INSERT INTO cmncbs_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","大卫的妻子以格拉所生的六子以特念。大卫的这些儿子都是在希伯仑生的。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","在扫罗和大卫两家争战期间，押尼珥在扫罗家权势日增。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","他跟扫罗的一个妃嫔、爱亚的女儿利斯巴通奸，伊施·波设问他：“你为什么睡我父亲的妃嫔呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","押尼珥听了非常愤怒，说：“难道我是犹大的走狗吗？我至今还这样厚待你父亲扫罗家和他的亲戚朋友，没有把你交给大卫，今天你竟为了这个女人来责备我！ ");
INSERT INTO cmncbs_vpl VALUES ("S23_9","011_3_9","2SA","3","9","10","倘若我不照着耶和华应许大卫的誓言，把扫罗的江山夺过来交给大卫，让他统治全以色列和犹大，从但到别示巴，愿耶和华重重地惩罚我！” ");
INSERT INTO cmncbs_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","伊施·波设一句话也不敢答，因为他害怕押尼珥。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","押尼珥派使者送信给大卫，说：“这是谁的土地呢？如果你与我立约，我必帮助你统一以色列。” ");
INSERT INTO cmncbs_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","大卫回答说：“好，我与你立约，但有一个要求：你一定要把扫罗的女儿米甲带来才能见我。” ");
INSERT INTO cmncbs_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","于是，大卫派使者去见扫罗的儿子伊施·波设说：“请把我的妻子米甲送回来，因为她是我用一百个非利士人的包皮作聘礼娶来的。” ");
INSERT INTO cmncbs_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","伊施·波设就派人把米甲从她丈夫、拉亿的儿子帕铁那里接回来。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","帕铁一路跟着米甲，边走边哭，一直到巴户琳。押尼珥对他说：“你回去吧！”他就回去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","押尼珥和以色列的长老商量说：“你们以前一直都希望大卫做你们的王， ");
INSERT INTO cmncbs_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","现在是时候了，因为耶和华曾说要借着祂仆人大卫的手，从非利士人和其他所有敌人手中拯救祂的以色列子民。” ");
INSERT INTO cmncbs_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","押尼珥也跟便雅悯人商谈，然后到希伯仑把以色列人和便雅悯人的愿望告诉大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","当时，他带了二十个人前往希伯仑见大卫，大卫就设宴款待他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","押尼珥对大卫说：“我要去招聚所有以色列人到我主我王这里，好跟你立约，你便可以如愿以偿，统治全以色列。”于是大卫为他送行，他就平安地回去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","大卫送押尼珥平安离开后不久，约押就率领大卫的军队袭敌归来，并带回许多战利品。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","约押率领全军回来后，有人告诉他：“尼珥的儿子押尼珥刚才来朝见王，王送他平安地离去了。” ");
INSERT INTO cmncbs_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","约押听后，就去见王，说：“你这做的是什么事？押尼珥来见你，你为什么放他走呢？ ");
INSERT INTO cmncbs_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","你要知道，尼珥的儿子押尼珥想来骗你，探听你的虚实。” ");
INSERT INTO cmncbs_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","约押从大卫那里出来，派使者去追押尼珥，他们在西拉井追上了他，把他带了回来。大卫对这件事一无所知。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","押尼珥回到希伯仑的时候，约押就把他带到城门的瓮洞，装作与他密谈，乘机用短剑刺入他的肚子，把他杀死了，为他兄弟亚撒黑报了仇。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","后来，大卫听到消息就说：“我和我的国在耶和华面前永远跟尼珥的儿子押尼珥的死无关。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","约押和他全家要承担这罪，愿他的后代永远有长疮的、患皮肤病的、拄拐杖的、被刀剑所杀的或挨饿的。” ");
INSERT INTO cmncbs_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","约押和他兄弟亚比筛之所以杀押尼珥，是因为押尼珥在基遍杀了他们的兄弟亚撒黑。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","大卫对约押和部下说：“你们要撕裂衣服，腰束麻布，在押尼珥棺前哭丧！”大卫王也跟在棺后送葬。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","他们就把押尼珥葬在希伯仑。大卫王和众人在墓旁大哭一场。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","大卫王哀悼押尼珥，说： “押尼珥啊！ 你怎能死得糊里糊涂呢？ ");
INSERT INTO cmncbs_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","你的手没有被捆， 你的脚没有被锁， 你是死在奸恶之人的手里啊！” 于是众人都为押尼珥哀哭。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","大卫整天没有进食，众人来劝他吃一点东西，但他起誓说：“我若在日落以前吃任何东西，愿上帝重重地惩罚我！” ");
INSERT INTO cmncbs_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","众人听见了，都很喜悦，王做的每一件事都令他们喜悦。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","那天全以色列的人都看出尼珥的儿子押尼珥的死与大卫无关。 ");
INSERT INTO cmncbs_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","大卫王对他的随从说：“你们难道不知道今天以色列损失了一位伟大的将领吗？ ");
INSERT INTO cmncbs_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","今天我虽然是被膏立的王，但仍势单力薄，无法对付洗鲁雅的两个儿子，愿耶和华报应他们的恶行。” ");
INSERT INTO cmncbs_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","扫罗的儿子伊施·波设听到押尼珥死在希伯仑，吓得手脚发软，整个以色列都震惊不已。 ");
INSERT INTO cmncbs_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","那时，扫罗的儿子有两个带兵的将领，一个叫巴拿，一个叫利甲，他们是来自比录的便雅悯人临门的儿子，比录被认为属于便雅悯支派。 ");
INSERT INTO cmncbs_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","原来的比录人逃到基他音，寄居在那里，直到今日。 ");
INSERT INTO cmncbs_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","扫罗的儿子约拿单有个儿子叫米非波设，双腿是瘸的。扫罗和约拿单在耶斯列阵亡的消息传来时，他才五岁。乳娘抱着他仓皇逃命，不慎把他掉在地上，摔瘸了腿。 ");
INSERT INTO cmncbs_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","一天，伊施·波设正在午睡，比录人临门的两个儿子利甲和巴拿来到他家。 ");
INSERT INTO cmncbs_vpl VALUES ("S24_6","011_4_6","2SA","4","6","7","他们装作是来取麦子，进入伊施·波设的寝室，趁他正躺在床上熟睡，用刀刺透他的肚子杀了他，割下他的首级，拿着连夜穿过亚拉巴逃跑了。 ");
INSERT INTO cmncbs_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","他们把伊施·波设的首级带到希伯仑献给大卫王，说：“这便是扫罗的儿子伊施·波设的首级。扫罗是你的仇敌，曾试图杀害你，今天耶和华为我主我王惩罚了扫罗和他的子孙。” ");
INSERT INTO cmncbs_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","大卫对比录人临门的儿子利甲及其兄弟巴拿说：“我凭救我脱离一切危难的永活的耶和华起誓， ");
INSERT INTO cmncbs_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","在洗革拉曾有人向我报信说扫罗死了，他以为是来报喜讯，我抓住他，把他杀了。那就是我给他的报酬。 ");
INSERT INTO cmncbs_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","更何况你们这些恶徒在这个无辜人的家里把他杀死在床上，我怎能不向你们讨这血债，把你们从世上除掉？” ");
INSERT INTO cmncbs_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","于是，大卫命令部下杀了他们，斩断他们的手脚，把尸体挂在希伯仑的池旁。他们把伊施·波设的头颅葬在希伯仑的押尼珥的坟墓里。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","以色列各支派都来希伯仑见大卫，对他说：“看啊，我们是你的骨肉同胞。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","从前扫罗做王的时候，率领以色列人出征打仗的是你，耶和华也曾应许让你做祂以色列子民的牧者和首领。” ");
INSERT INTO cmncbs_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","以色列的长老都到希伯仑见大卫王，大卫与他们在耶和华面前立约，他们膏立大卫做以色列的王。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","大卫三十岁登基，执政共四十年。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","他在希伯仑统治犹大七年半，在耶路撒冷统治以色列和犹大三十三年。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","大卫率领军队来到耶路撒冷，要攻打那里的耶布斯人。耶布斯人对大卫说：“你攻不进来，就连我们这里瞎眼的和瘸腿的都可以把你赶走。”他们以为大卫攻不进去。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","然而，大卫攻取了锡安的堡垒，即后来的大卫城。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","那天，大卫下令军队从地下水道爬进城去，攻打那些“瞎眼的和瘸腿的”，他憎恶这些耶布斯人。后来便有一句俗语：“瞎眼的和瘸腿的不得进殿！” ");
INSERT INTO cmncbs_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","大卫住在锡安的堡垒里，并称之为大卫城，他又从米罗向内兴建环城围墙。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","大卫日渐强盛，因为万军之上帝耶和华与他同在。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","泰尔王希兰差遣使者带着香柏木、木匠和石匠去为大卫建造宫殿。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","那时，大卫知道耶和华已立他做以色列王，并因祂以色列子民的缘故而使他国家兴旺。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","大卫从希伯仑迁到耶路撒冷以后，又选立妃嫔，生了更多儿女。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","他在耶路撒冷生的孩子有沙姆亚、朔罢、拿单、所罗门、 ");
INSERT INTO cmncbs_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","益辖、以利书亚、尼斐、雅非亚、 ");
INSERT INTO cmncbs_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","以利沙玛、以利雅大和以利法列。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","非利士人听说大卫已被膏立为以色列王，就全军出动，搜寻大卫。大卫听说后，便退到堡垒里。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","非利士人大军压境，散布在利乏音谷。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","大卫求问耶和华：“我可以去迎战非利士人吗？你会把他们交在我手里吗？”耶和华说：“去吧，我必把他们交在你手里。” ");
INSERT INTO cmncbs_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","大卫前往巴力·毗拉心，在那里打败了他们。他说：“耶和华像洪水决堤一样为我冲垮了仇敌。”因此那地方叫巴力·毗拉心。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","大卫和他的军队带走了非利士人所丢弃的神像。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","后来非利士人又卷土重来，散布在利乏音谷。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","大卫又求问耶和华，耶和华说：“你不要正面出击，要绕到他们后面，从桑林对面攻打他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","当你听见桑树梢上响起脚步声时，就要快速进攻，因为那表示耶和华已在你前头去攻击非利士的军队了。” ");
INSERT INTO cmncbs_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","大卫遵命而行，打败非利士人，从迦巴一直杀到基色。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","大卫又召集了三万名以色列精兵， ");
INSERT INTO cmncbs_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","率领他们到犹大的巴拉去接上帝的约柜。这约柜以坐在基路伯天使之间的万军之耶和华的名字命名。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","他们把上帝的约柜从坐落在山上的亚比拿达家抬出来，放在一辆新车上，由亚比拿达的两个儿子乌撒和亚希约赶车， ");
INSERT INTO cmncbs_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","亚希约走在约柜前面。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","大卫和全体以色列人在耶和华面前用琴、瑟、鼓、钹和锣奏乐，尽情歌舞。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","他们走到拿肯的麦场时，拉车的牛失蹄，乌撒就伸手去扶上帝的约柜。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","耶和华上帝便向他发怒，因他的不敬而击杀了他。他死在了约柜旁边。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","大卫因耶和华击杀乌撒而烦恼，就称那地方为毗列斯·乌撒，沿用至今。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","那天，大卫惧怕耶和华，就说：“耶和华的约柜怎能运到我这里？” ");
INSERT INTO cmncbs_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","他不愿把耶和华的约柜运进大卫城，而是把它运到迦特人俄别·以东家。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","耶和华的约柜在俄别·以东家存放了三个月，耶和华赐福给俄别·以东和他全家。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","大卫听说耶和华因为约柜而赐福给俄别·以东全家及其一切所有，就欢欢喜喜地去把上帝的约柜从俄别·以东家接进大卫城。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","这一次，抬耶和华约柜的人走了六步，大卫就献上公牛和肥犊为祭。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","大卫穿着细麻布的以弗得，在耶和华面前尽情跳舞。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","大卫和全体以色列人在欢呼声和号角声中把耶和华的约柜迎进大卫城。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","耶和华的约柜进大卫城的时候，扫罗的女儿米甲从窗户往外观看，见大卫在耶和华面前又跳又舞，心里就轻视他。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","众人把耶和华的约柜抬进去，安放在大卫所搭的帐幕里。大卫在耶和华面前献上燔祭和平安祭， ");
INSERT INTO cmncbs_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","然后奉万军之耶和华的名给民众祝福， ");
INSERT INTO cmncbs_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","还分给所有以色列人，不论男女，每人一个饼、一块肉和一个葡萄饼。众人就各自回家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","大卫回到家为自己的家人祝福，米甲出来迎接他，说：“今天以色列王好光彩呀！居然像个粗俗之人，在臣仆和婢女面前露体！” ");
INSERT INTO cmncbs_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","大卫对她说：“我是在耶和华面前跳舞。祂不用你父亲和你父亲家里的人，而是选立我来治理祂的以色列子民，所以我要在祂面前欢庆。 ");
INSERT INTO cmncbs_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","我要让自己更卑微，自视低贱，但你说的那些婢女会尊重我。” ");
INSERT INTO cmncbs_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","扫罗的女儿米甲终生都没有生育。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","大卫住在王宫里，耶和华使他安享太平，不受四围的仇敌侵扰。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","一天，王对拿单先知说：“你看，我住在香柏木建的王宫中，上帝的约柜却还在帐幕里。” ");
INSERT INTO cmncbs_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","拿单答道：“你有什么想法，就去做吧，因为耶和华与你同在。” ");
INSERT INTO cmncbs_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","当晚耶和华对拿单说： ");
INSERT INTO cmncbs_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“你去告诉我的仆人大卫，‘耶和华说，你要建造殿宇给我居住吗？ ");
INSERT INTO cmncbs_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","从我把以色列人带出埃及那天起，直到今天，我从未住过殿宇，一路上都住在帐幕里。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","在我与以色列人同行的日子，我从未责问任何我委派牧养我子民的士师，你为何不为我建香柏木的殿宇呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","“现在你要告诉我的仆人大卫，万军之耶和华说，‘你原本在草场牧羊，我召你来做我以色列子民的首领。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","无论你去哪里，我都与你同在，为你铲除所有仇敌。现在我要使你声名远扬，与世上的伟人齐名。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","我必为我的以色列子民预备一个地方，栽培他们，使他们住在自己的家园，不再受惊扰，不会像从前我设立士师治理他们的时候那样受恶人压迫。我必使你安定，免受仇敌的侵扰。我耶和华向你宣告，我必为你建立王朝。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","你离世与祖先同眠时，我必兴起你亲生的后裔接替你，使他的国稳固。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","他必为我的名建造殿宇，我必使他的国度王位永固。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","我要做他的父亲，他要做我的儿子。如果他犯了罪，我必用人的杖、世人的鞭子来惩治他， ");
INSERT INTO cmncbs_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","我的慈爱曾离开从你面前被废的扫罗，但我的慈爱必不离开他。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","你的家和你的国必在我面前永远坚立，你的王位必永远稳固。’” ");
INSERT INTO cmncbs_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","拿单就把所听到的启示全部告诉大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","于是，大卫王进去，在耶和华面前坐下，说：“主耶和华啊，我是谁？我的家算什么？你竟这样厚待我。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","主耶和华啊，在你眼中这还不够，你还说到仆人家的将来。主耶和华啊，你竟这样恩待世人！ ");
INSERT INTO cmncbs_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","主耶和华啊，大卫还能对你说什么呢？因为你深知你的仆人。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","你让仆人知道你凭自己的应许、按自己的心意成就这大事。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","主耶和华啊，你真伟大！我们从未听过有谁能与你相比，你是独一无二的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","世上哪个民族比得上你的以色列子民呢？你从埃及救赎他们，让他们做你的子民，又彰显你的大名，行伟大而可畏的事，把列国及其神明从你的以色列子民面前赶走。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","你让以色列人永远做你的子民，你耶和华做他们的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","“耶和华上帝啊，求你永远信守你对仆人和仆人家的应许，求你成就你的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","这样，你的名必永远被尊崇，人们必说，‘万军之耶和华是以色列的上帝。’你仆人大卫的家必在你面前坚立。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","以色列的上帝——万军之耶和华啊，因为你曾启示仆人，说要为仆人建立王朝，仆人才敢这样向你祈祷。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","主耶和华啊，唯有你是上帝，你的话真实可靠，你给了仆人美好的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","现在求你赐福给仆人家，使仆人家在你面前永续不断。主耶和华啊，这些都是你的应许，愿你永远赐福给仆人家。” ");
INSERT INTO cmncbs_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","后来大卫打败并征服了非利士人，夺取了他们的都城。 ");
INSERT INTO cmncbs_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","他又打败了摩押人，让他们并排躺在地上，然后用绳子去量，每两绳之内的人都要被杀掉，第三绳的人留下性命。从此，摩押人臣服于大卫，向他进贡。 ");
INSERT INTO cmncbs_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","利合的儿子琐巴王哈大底谢出来，要恢复他在幼发拉底河一带的势力，大卫打败了他， ");
INSERT INTO cmncbs_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","俘获一千七百名骑兵和两万名步兵，砍断拉战车的马匹的蹄筋，只留下够拉一百辆战车的马匹。 ");
INSERT INTO cmncbs_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","大马士革的亚兰人前来支援琐巴王哈大底谢，大卫杀了他们两万二千人， ");
INSERT INTO cmncbs_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","还在大马士革的亚兰境内驻军，亚兰人臣服于大卫，向他进贡。耶和华使大卫无往而不胜。 ");
INSERT INTO cmncbs_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","大卫夺走哈大底谢侍从的金盾牌，带回耶路撒冷， ");
INSERT INTO cmncbs_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","又从哈大底谢统治的比他和比罗他两座城中夺走大量的铜。 ");
INSERT INTO cmncbs_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","哈马王陀以听说大卫打败哈大底谢全军， ");
INSERT INTO cmncbs_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","就派儿子约兰带着许多金银铜器去朝见大卫王，向他请安，祝贺他打败了哈大底谢。因为陀以常常和哈大底谢交战。 ");
INSERT INTO cmncbs_vpl VALUES ("S28_11","011_8_11","2SA","8","11","12","大卫王把这些器皿和他征服亚兰人、摩押人、亚扪人、非利士人、亚玛力人，以及利合的儿子琐巴王哈大底谢时所得的金银都分别出来，奉献给耶和华。 ");
INSERT INTO cmncbs_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","大卫在盐谷杀了一万八千亚兰人归来后，声威大振。 ");
INSERT INTO cmncbs_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","他又在以东全境驻军，以东人都臣服于他。耶和华使他无往而不胜。 ");
INSERT INTO cmncbs_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","大卫治理全以色列，对百姓秉公行义。 ");
INSERT INTO cmncbs_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","那时，洗鲁雅的儿子约押做元帅；亚希律的儿子约沙法做史官； ");
INSERT INTO cmncbs_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","亚希突的儿子撒督和亚比亚他的儿子亚希米勒做祭司长；西莱雅做书记； ");
INSERT INTO cmncbs_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","耶何耶大的儿子比拿雅统管基利提人和比利提人。大卫的众子都做祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","大卫问：“扫罗一家还有什么人吗？我要因约拿单的缘故恩待他。” ");
INSERT INTO cmncbs_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","有人就去叫扫罗家一个名叫洗巴的仆人来见大卫，王问他：“你就是洗巴吗？”他说：“仆人正是洗巴。” ");
INSERT INTO cmncbs_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","王说：“扫罗家中还有什么人？我要以上帝的慈爱来待他。”洗巴答道：“约拿单还有一个儿子，是双脚残疾的。” ");
INSERT INTO cmncbs_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","王说：“他在哪里？”洗巴答道：“他住在罗·底巴，在亚米利的儿子玛吉家里。” ");
INSERT INTO cmncbs_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","于是，大卫王派人去罗·底巴把他从亚米利的儿子玛吉家里接来。 ");
INSERT INTO cmncbs_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","扫罗的孙子、约拿单的儿子米非波设来到大卫面前，向他俯伏叩拜。大卫说：“米非波设！”米非波设答道：“仆人在这里。” ");
INSERT INTO cmncbs_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","大卫说：“你不要害怕，我要因你父亲约拿单的缘故而恩待你。我要把你祖父扫罗所有的田地归还给你，你要常与我同席吃饭。” ");
INSERT INTO cmncbs_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","米非波设再次叩拜，说：“仆人算什么？不过像一条死狗罢了，你竟这样眷顾我！” ");
INSERT INTO cmncbs_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","王又把扫罗的仆人洗巴召来，对他说：“我已把扫罗全家的产业都赐给了你主人的孙子米非波设。 ");
INSERT INTO cmncbs_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","你和你的儿子及仆人要为米非波设种田，把出产拿来供养他。他还要常常与我同席吃饭。”洗巴有十五个儿子，二十个仆人。 ");
INSERT INTO cmncbs_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","洗巴对王说：“仆人必遵行我主我王的一切吩咐。”于是，米非波设像王子一样常与大卫同席吃饭。 ");
INSERT INTO cmncbs_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","米非波设有一个小儿子名叫米迦。洗巴家中的人都做了米非波设的仆人。 ");
INSERT INTO cmncbs_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","从此，双脚残废的米非波设就住在耶路撒冷，常常与王同席吃饭。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","后来，亚扪王死了，他儿子哈嫩继位。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","大卫说：“我要恩待拿辖的儿子哈嫩，就像他父亲曾经恩待我一样。”他便派臣仆去安慰丧父的哈嫩。大卫的臣仆来到亚扪境内， ");
INSERT INTO cmncbs_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","亚扪的官长却对哈嫩说：“大卫派人来安慰你，你以为他是来吊唁你父亲吗？他派臣仆来见你，不过是要探听虚实，想摧毁这城。” ");
INSERT INTO cmncbs_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","哈嫩便把大卫的臣仆抓起来，剃去他们一半胡须，从臀部割去他们下半身的衣服，然后放走他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","消息传到大卫那里，他就派人去迎接他们，因为他们倍受羞辱。王告诉他们留在耶利哥，等胡须长好了再回来。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","亚扪人知道得罪了大卫，便派人到伯·利合和琐巴招募了两万名亚兰步兵、玛迦王的一千人和一万二千名陀伯人。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","大卫听见消息后，就派约押率领全体勇士出战。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","亚扪人在城门前列阵，琐巴和利合的亚兰人、陀伯人以及玛迦人在郊野列阵。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","约押见自己腹背受敌，就从以色列军中挑选一些精兵列阵迎战亚兰人， ");
INSERT INTO cmncbs_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","把余下的军兵交给他的兄弟亚比筛带领，列阵迎战亚扪人。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","他对亚比筛说：“倘若我胜不过亚兰人，你便过来支援我；倘若你胜不过亚扪人，我便过去支援你。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","你要刚强，我们要为我们的人民和我们上帝的城邑奋勇作战。愿耶和华成全祂自己的旨意！” ");
INSERT INTO cmncbs_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","于是，约押率领军兵进攻亚兰人，亚兰人败逃。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","亚扪人见亚兰人败逃，便也从亚比筛面前逃回城去。约押就离开亚扪人，回师耶路撒冷。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","亚兰人见自己败给以色列人，便再次聚集起来。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","哈大底谢派人把幼发拉底河那边的亚兰人调到希兰来，由他的将军朔法率领。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","大卫听到消息后，就召集以色列全军，渡过约旦河，来到希兰。亚兰人列阵迎战大卫， ");
INSERT INTO cmncbs_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","结果又在以色列人面前败逃。大卫杀了七百名战车兵、四万骑兵，还杀了他们的将军朔法。 ");
INSERT INTO cmncbs_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","哈大底谢属下的诸王见自己败给以色列人，便向以色列人求和，臣服于他们。从此，亚兰人不敢再支援亚扪人了。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","第二年春天，诸王又要发动战争。大卫差遣约押率领众将领和以色列大军出征，自己却留在耶路撒冷。他们打败了亚扪人之后又围攻拉巴。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","一天黄昏，大卫从床上起来在王宫顶上散步，看见一个长得非常漂亮的女人在沐浴。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","大卫就派人去打听这个女人是谁，得知她是以连的女儿、赫人乌利亚的妻子拔示巴。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","大卫派使者把她接来，她来了，大卫就与她同寝，那时她的月经刚洁净。事后，她便回家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","拔示巴怀孕了，就派人去告诉大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","大卫便传信给约押，说：“你派赫人乌利亚来见我。”约押就派乌利亚去见大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","乌利亚来了，大卫问他有关约押、士兵和战争的情况， ");
INSERT INTO cmncbs_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","然后吩咐他回家休息。乌利亚离开王宫后，收到王送的一份礼物。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","但他跟王的其他仆人一同睡在王宫门口，没有回家。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","大卫得知乌利亚没有回家，便对他说：“你远道而来，为什么不回家休息呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","乌利亚答道：“约柜、以色列人和犹大人都在帐篷里，而我主约押及其军队也在田间扎营，我怎么可以回家吃喝，与妻子同房呢？我以王的性命起誓，我决不做这样的事！” ");
INSERT INTO cmncbs_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","大卫对乌利亚说：“你再住一天，明天我会派你回去。”于是乌利亚那日就留在耶路撒冷。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","第二天，大卫邀请他一同吃饭，把他灌醉了。可是到了晚上，乌利亚还是不肯回家，仍然跟王的其他士兵一同住宿。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","第二天早上，大卫给约押写了一封信，要乌利亚带去。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","大卫在信上吩咐约押：“你把乌利亚派到前线最险恶的地方，到时其他人都要撤退，好让敌人杀死他。” ");
INSERT INTO cmncbs_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","于是约押围攻城池时，便派乌利亚到他知道的最强悍的敌人那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","敌人出来迎战约押，大卫的军中有几位阵亡，赫人乌利亚也死了。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","约押就派人去向大卫禀告战争的详情， ");
INSERT INTO cmncbs_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","并叮嘱信使：“你向王禀告战情后， ");
INSERT INTO cmncbs_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","他若发怒责问你，‘为什么还冒死逼近城池呢？你们难道不知道敌人会从城墙上射箭吗？ ");
INSERT INTO cmncbs_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","难道你们不知道耶路·比设的儿子亚比米勒是谁杀的吗？一个妇人从城墙上扔下一块磨石，把他砸死在提备斯。你们为什么还要逼近城墙呢？’你就对王说，‘你的仆人赫人乌利亚也死了。’” ");
INSERT INTO cmncbs_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","于是，信使前来见大卫，照约押的吩咐向大卫禀告。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","他说：“敌军势力强大，在城外跟我们交战，但我们把他们追到城门口。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","敌军的弓箭手从城墙上射死了王的几个士兵，赫人乌利亚也死了。” ");
INSERT INTO cmncbs_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","大卫便对信使说：“你去告诉约押不要为这事难过，因为刀剑无情。让他只管竭力攻陷城池。要这样勉励约押。” ");
INSERT INTO cmncbs_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","拔示巴听到丈夫乌利亚的死讯之后就为他哭丧。 ");
INSERT INTO cmncbs_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","丧期过后，大卫便派人把她接进宫里，她就做了大卫的妻子，并给他生了个儿子。然而，大卫的所作所为令耶和华十分不悦。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","耶和华派拿单先知去见大卫。拿单对大卫说：“一座城里有两个人，一个富有，一个贫穷。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","富人拥有许多牛羊， ");
INSERT INTO cmncbs_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","穷人除了自己买来养活的一只母羊羔外，什么也没有。他让它跟自己的儿女一起长大。他吃什么，羊也吃什么，他喝什么，羊也喝什么，甚至让它睡在自己怀里，就像他女儿一样。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","一天，富人家中来了客人，他舍不得拿自己的牛羊款待客人，却宰了穷人的羊给客人吃。” ");
INSERT INTO cmncbs_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","大卫听后非常愤怒，对拿单说：“我凭永活的耶和华起誓，做这事的人实在该死！ ");
INSERT INTO cmncbs_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","他这样做真是没有半点怜悯之心，他必须偿还那穷人四倍！” ");
INSERT INTO cmncbs_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","拿单对大卫说：“那人就是你！以色列的上帝耶和华这样说，‘我膏立你做以色列的王，从扫罗手中救你， ");
INSERT INTO cmncbs_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","将你主人的家业和妻妾交给你，把以色列和犹大的国权赐给你。倘若还不够，我会再加倍地赐给你。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","你为什么蔑视我的命令，做出我视为可憎的事呢？你借亚扪人的刀杀了赫人乌利亚，把他的妻子据为己有。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","因为你藐视我，把赫人乌利亚的妻子据为己有，从今以后，杀戮流血的事必永不离开你的家。’ ");
INSERT INTO cmncbs_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","耶和华说，‘我要在你家中降下灾祸，我要当着你的面把你的妻妾交给你的近臣，他必在光天化日之下与她们行淫。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","你在暗地里做这恶事，我要让这样的恶事当着以色列人的面在光天化日之下临到你。’” ");
INSERT INTO cmncbs_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","大卫对拿单说：“我得罪了耶和华。”拿单说：“耶和华已经赦免了你的罪，使你不致死亡。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","但你做的丑事给了仇敌大肆亵渎耶和华的机会，所以你这个孩子必定死。” ");
INSERT INTO cmncbs_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","拿单说完，便回家去了。 耶和华击打乌利亚的妻子给大卫生的孩子，使他患重病。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","大卫为这孩子向上帝哀求，并且禁食，他进到里面，整夜躺在地上。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","宫里的老臣在旁边伺候，想要扶他起来，他却不肯，也不肯与他们一同吃饭。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","到了第七日，孩子死了。大卫的臣仆都不敢把这消息告诉他，因为他们心里想：“孩子还活着的时候，我们劝他，他尚且不听，若告诉他孩子死了，他会怎样折磨自己呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","大卫看见他们交头接耳，知道孩子死了，便问他们：“孩子死了？”他们答道：“是的，他死了。” ");
INSERT INTO cmncbs_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","大卫听后，便从地上起来，沐浴更衣，抹上香膏，然后到耶和华的殿去敬拜。他回宫以后，吩咐人摆上食物，自己开始用膳。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","他的臣仆诧异地问他：“你这是什么意思？孩子还活着的时候，你禁食、哀哭。孩子死了，你反倒起来进食。” ");
INSERT INTO cmncbs_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","大卫说：“不错，孩子活着的时候我禁食、哀哭，因为我想也许耶和华会向我开恩，让他活命。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","但现在他既然死了，我禁食又有什么用呢？能让他起死回生吗？我必去他那里，他却不能返回我这里了。” ");
INSERT INTO cmncbs_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","大卫安慰妻子拔示巴，与她同房，她便生了一个儿子。大卫给孩子取名叫所罗门。耶和华喜爱这孩子， ");
INSERT INTO cmncbs_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","祂差遣拿单先知去赐给他一个名字，叫耶底底亚，意思是耶和华喜爱他。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","那时，约押正攻打亚扪人的拉巴，占领了王城。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","他派使者去向大卫禀告说：“我攻打拉巴，已经占领了城的水源。 ");
INSERT INTO cmncbs_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","请你赶快带领其余的兵马前来围攻并占领这城，免得我攻取这城以后，人们用我的名字为这城命名。” ");
INSERT INTO cmncbs_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","于是，大卫便召集了所有的人去攻打拉巴，攻陷了那城， ");
INSERT INTO cmncbs_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","夺取了亚扪王头上的金冠。这金冠重达三十四公斤，上面还镶着宝石，人们将它戴在大卫头上。大卫从城里获得许多战利品， ");
INSERT INTO cmncbs_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","又把城里的人带出来，让他们从事锯木、耕田、砍树的工作，还让他们制作砖。他用同样的方式对待亚扪其他城邑的居民。之后，大卫和全军返回耶路撒冷。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","后来，大卫的儿子暗嫩爱上了美丽的她玛，她玛是大卫的儿子押沙龙的妹妹。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","她仍是处女，住在深宫里，暗嫩无法接近她，相思成病。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","暗嫩有一个朋友名叫约拿达，是大卫长兄示米亚的儿子，生性狡猾。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","他问暗嫩：“王子，你为什么一天比一天消沉？能告诉我吗？”暗嫩答道：“我爱上了我兄弟押沙龙的妹妹她玛。” ");
INSERT INTO cmncbs_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","约拿达说：“你回去躺在床上装病，你父亲来探望你的时候，你就请求他叫你妹妹她玛来，在你面前预备食物，请她亲手递给你吃。” ");
INSERT INTO cmncbs_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","暗嫩就躺在床上装病。王来看他的时候，他便对王说：“请你叫我妹妹她玛来这里，在我面前做两个饼，请她亲自递给我吃。” ");
INSERT INTO cmncbs_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","大卫便派人进宫对她玛说：“你去你哥哥暗嫩房里为他预备食物吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","她玛到了哥哥暗嫩的家，暗嫩正躺在床上装病。她拿了面团在他面前揉面做饼，把饼烤熟了。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","她拿着锅在他面前把饼倒出来，但暗嫩却不肯吃。暗嫩命令仆人：“你们全都出去吧！”仆人就都退下了。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","暗嫩对她玛说：“你把食物拿到我的卧房来，亲手递给我吃。”她玛便拿着饼进了她哥哥暗嫩的卧房里， ");
INSERT INTO cmncbs_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","上前给他吃，暗嫩却抓住她，说：“妹妹，与我同寝吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","她玛说：“哥哥，不要，不要玷污我！在以色列不应当发生这种事，不要做这种恶事。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","你这样叫我怎么见人呢？你在以色列也必遭人唾弃。你可以请求王，他会同意把我许配给你。” ");
INSERT INTO cmncbs_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","暗嫩却充耳不闻，因为他力气比她玛大，就把她强奸了。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","事后暗嫩非常憎恨她玛，对她的恨比以前对她的爱还强烈。他对她玛说：“你起来走吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","她玛哀求道：“不要这样对我！你赶我走是更大的恶行。”暗嫩却不听， ");
INSERT INTO cmncbs_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","他吩咐随从：“把这女人赶出去，随后锁上门。” ");
INSERT INTO cmncbs_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","他的随从就把她玛赶出去，随后锁上了门。那时，她玛穿着彩色的长衣，没有出嫁的公主都穿这种衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","她玛把灰尘撒在头上，撕破身上的彩衣，双手抱着头，一面走一面哭。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","她的哥哥押沙龙问她：“是不是你哥哥暗嫩污辱了你？妹妹，不要声张，他是你哥哥，不要把这件事放在心上。”于是她玛就忧忧郁郁地住在押沙龙家里。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","大卫王听见了这件事以后，非常生气。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","押沙龙好话坏话都没有对暗嫩说一句话，只是心里暗暗地恨他，因为他玷污了妹妹她玛。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","两年后，押沙龙的工人在以法莲附近的巴力·夏琐剪羊毛，押沙龙邀请王的众子去那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","他去见王，说：“工人正在为仆人剪羊毛，请王和众臣仆跟仆人一起去吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","王说：“我儿，我们不必都去打扰你。”押沙龙再三邀请，王还是推辞了，但他为押沙龙祝福。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","押沙龙说：“王若不去，请让我兄弟暗嫩跟我们去吧。”大卫说：“何必要他同去呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","但押沙龙再三恳求，王就让暗嫩和其他王子一同去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","押沙龙吩咐仆人说：“你们要留意，当暗嫩喝得正高兴的时候，我叫你们动手，你们就要杀他。不要害怕，要刚强勇敢！因为这是我的命令。” ");
INSERT INTO cmncbs_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","押沙龙的仆人就照命令把暗嫩杀了。王的众子都起来骑上骡子逃走了。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","他们还在路上的时候，有人禀告大卫说：“押沙龙把王子都杀了，无一幸免！” ");
INSERT INTO cmncbs_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","王便站起来撕裂衣服，躺在地上。众臣仆也都撕裂衣服，站在旁边。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","大卫的长兄示米亚的儿子约拿达说：“我主不要以为所有的王子都被杀了，其实只有暗嫩一人死了。自从暗嫩奸污押沙龙的妹妹她玛以来，押沙龙便决定要报仇了。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","所以，我主我王啊，不要相信这消息，不是所有的王子都死了，只有暗嫩一人死了。” ");
INSERT INTO cmncbs_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","此时，押沙龙已经逃走了。守望的人举目瞭望，见有一大群人从西面山坡的路上下来。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","约拿达对王说：“请看，王子们都回来了！正如仆人所言。” ");
INSERT INTO cmncbs_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","话刚说完，众王子已经来到他们跟前放声大哭，王和众臣仆也哀痛不已。 ");
INSERT INTO cmncbs_vpl VALUES ("S213_37","011_13_37","2SA","13","37","38","押沙龙逃到了亚米忽的儿子基述王达买那里，在那里住了三年。大卫王天天为他儿子暗嫩悲伤， ");
INSERT INTO cmncbs_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","后来心情恢复平静，开始想念押沙龙。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","洗鲁雅的儿子约押知道王想念押沙龙， ");
INSERT INTO cmncbs_vpl VALUES ("S214_2","011_14_2","2SA","14","2","2","就派人到提哥亚去召来一个聪明的妇人，对她说：“你假扮哀悼的人，穿上丧服，不要用油抹身，要装成为死者哀悼很久的妇人， ");
INSERT INTO cmncbs_vpl VALUES ("S214_3","011_14_3","2SA","14","3","3","然后到王那里，对他这样这样说。”约押把应该说的话都告诉妇人。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_4","011_14_4","2SA","14","4","4","提哥亚妇人来到王面前，俯伏在地上说：“王啊，求你救救我吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S214_5","011_14_5","2SA","14","5","5","王问她：“你有什么事？”妇人说：“婢女是个寡妇，丈夫死了。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_6","011_14_6","2SA","14","6","6","我本来有两个儿子，有一次他们在田间发生争执，当时没有人劝解，其中一个儿子被打死了。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_7","011_14_7","2SA","14","7","7","现在整个家族都起来反对婢女，说，‘把那打死亲兄弟的凶手交出来，我们要他以命偿命，除掉这个继承人。’他们要让我家断子绝孙，使婢女的丈夫既不能留名，也不能留后。” ");
INSERT INTO cmncbs_vpl VALUES ("S214_8","011_14_8","2SA","14","8","8","王说：“你回家去吧！我会为你作主。” ");
INSERT INTO cmncbs_vpl VALUES ("S214_9","011_14_9","2SA","14","9","9","提哥亚妇人说：“我主我王，愿罪过都落在婢女和婢女家族，跟王和王位无关。” ");
INSERT INTO cmncbs_vpl VALUES ("S214_10","011_14_10","2SA","14","10","10","王说：“若有人为难你，你就把他带来，他必不敢再找你的麻烦。” ");
INSERT INTO cmncbs_vpl VALUES ("S214_11","011_14_11","2SA","14","11","11","妇人说：“求王凭你的上帝耶和华起誓，不许报血仇者杀人，留我儿一命。”王说：“我凭永活的耶和华起誓，你的儿子必毫发无损。” ");
INSERT INTO cmncbs_vpl VALUES ("S214_12","011_14_12","2SA","14","12","12","妇人说：“求我主我王再容婢女说一句。”王说：“说吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S214_13","011_14_13","2SA","14","13","13","妇人说：“王怎么想出这样的事来针对上帝的子民呢？王刚才所说的话正表明王的不是了，因为王不让被流放的儿子回来。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_14","011_14_14","2SA","14","14","14","人都难免一死，就像覆水难收。然而，上帝不是要夺取人的性命，而是要设法使流亡的人重新回来。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_15","011_14_15","2SA","14","15","15","我向我主我王说出这番话，是因为人们恐吓我。我想，不如向王请命，也许王会成全婢女的心愿。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_16","011_14_16","2SA","14","16","16","有人要害我和我儿子的性命，叫我们不得承受上帝所赐的产业，也许王能从这人手中救我们。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_17","011_14_17","2SA","14","17","17","婢女想，我主我王的话必能安慰我，因为我主我王就像上帝的天使一样能明辨是非。愿王的上帝耶和华常与王同在！” ");
INSERT INTO cmncbs_vpl VALUES ("S214_18","011_14_18","2SA","14","18","18","王对妇人说：“我有一件事要问你，你要实实在在地回答我。”妇人说：“我主我王请说。” ");
INSERT INTO cmncbs_vpl VALUES ("S214_19","011_14_19","2SA","14","19","19","王说：“这是不是约押的主意？”妇人说：“我凭我主我王的性命起誓，王所说的一点不错，这些话是你臣仆约押吩咐婢女说的。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_20","011_14_20","2SA","14","20","20","他这样做是希望扭转局面。我主如上帝的天使一样有智慧，洞悉天下之事。” ");
INSERT INTO cmncbs_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","于是，王对约押说：“我答应你的请求，你去把年轻的押沙龙带回来吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","约押俯伏在地，叩谢王恩，说：“今天仆人在我主我王面前蒙了恩，因为王应允了仆人的请求。” ");
INSERT INTO cmncbs_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","约押便到基述把押沙龙接回耶路撒冷。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","王说：“让押沙龙回自己的家，不要让他来见我！”押沙龙便返回自己家中，没有朝见王。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","在整个以色列，没有人像押沙龙那样因相貌英俊而为人称道，他从头到脚毫无瑕疵。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","他的头发浓密，每年年终会很沉重，需要剪发，剪下的头发按王的重量标准约重两公斤。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","押沙龙有三儿一女，女儿名叫她玛，长得非常美丽。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","押沙龙在耶路撒冷住了两年，没有跟王见过面。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","他派人去请约押来，托他去求见王，但约押不肯来。第二次再请，他还是不肯来。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","押沙龙就吩咐仆人：“你们看，约押的田就在我的田旁边，他种了大麦，你们去放火把它烧了。”押沙龙的仆人便把麦田烧了。 ");
INSERT INTO cmncbs_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","约押便来到押沙龙家里，问他：“你为什么叫仆人放火烧我的田？” ");
INSERT INTO cmncbs_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","押沙龙答道：“我派人请你来，希望你替我去问王，‘我为什么要从基述回来呢？倒不如仍然留在那里。’现在我要见王，如果我有什么罪过，就让他杀了我吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","约押就去见王，把押沙龙的话告诉他，王便召见押沙龙。押沙龙来到王面前俯首叩拜，王就亲吻他。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","后来，押沙龙为自己备了车马，又派五十个人在他前面开道。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","他常常清早起来，站在城门的通道旁边。每当有人来找王审理争讼时，押沙龙便问他是从哪一座城来的，那人就会报上自己所属的支派。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","押沙龙会对他说：“你的申诉合情合理，可惜王没有派人来听你申诉。” ");
INSERT INTO cmncbs_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","他接着会说：“要是我被立为国中的审判官就好了！那样，任何人有争讼都可以来找我，我一定会为他主持公道。” ");
INSERT INTO cmncbs_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","每当有人要向他叩拜，他都伸手扶他，亲吻他。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","押沙龙这样对待每一个来向王申诉的以色列人，赢得了民心。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","过了四年，押沙龙对王说：“请让我到希伯仑去还我向耶和华许下的愿吧。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","仆人住在亚兰的基述时曾许愿，如果耶和华带领我回到耶路撒冷，我必在希伯仑敬拜祂。” ");
INSERT INTO cmncbs_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","王说：“你平安地去吧！”押沙龙就去了希伯仑。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","他派密使通知以色列各支派一听见号角的响声，便喊：“押沙龙在希伯仑做王了！” ");
INSERT INTO cmncbs_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","有二百人应邀随同押沙龙一起从耶路撒冷去希伯仑，他们对内情一无所知。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","押沙龙献祭的时候，还派人去把大卫的谋士亚希多弗从他的故乡基罗请来。反叛的势力大增，拥护押沙龙的民众越来越多。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","有人来禀告大卫：“以色列的民心都归向押沙龙了。” ");
INSERT INTO cmncbs_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","大卫便对在耶路撒冷跟随他的臣仆说：“我们赶快逃命吧！否则，我们都难逃押沙龙的追捕。我们要马上离开！免得他赶到残害我们，屠杀全城。” ");
INSERT INTO cmncbs_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","臣仆对王说：“臣等谨遵我主我王的决定。” ");
INSERT INTO cmncbs_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","于是王就带着全家逃命，只留下十个妃嫔看守宫殿。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","大卫王带着众民离开耶路撒冷，走到最后的那座房子时，停了下来。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","他的臣仆都从他身边过去了，包括基利提人、比利提人以及从迦特来的六百个随从。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","王问迦特人以太说：“你为什么要跟我们一起逃难呢？回去留在新王那里吧！你是流亡到这里的外族人。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","你刚来不久，我怎么可以叫你跟我们一同四处飘流呢？我甚至不知道往何处去。你还是和你的弟兄回去吧，愿耶和华以慈爱和信实待你！” ");
INSERT INTO cmncbs_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","以太却答道：“我凭永活的耶和华和我主我王的性命起誓，不管我王去哪里，仆人都要誓死追随到底！” ");
INSERT INTO cmncbs_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","大卫便对以太说：“那就继续前行吧！”于是，迦特人以太带着他的人及所有的家眷继续前行。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","众人离开时，当地的百姓都放声大哭。王带着所有的人过了汲沦溪，向旷野走去。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","祭司撒督、亚比亚他和抬上帝约柜的利未人都来了，他们把约柜放下，让城里出来的人先走过去。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","王对撒督说：“你把上帝的约柜抬回城去吧。耶和华若恩待我，必使我重返家园，重见约柜和会幕； ");
INSERT INTO cmncbs_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","但我若使祂不悦，也甘愿听凭祂的处置。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","你是个有先见之明的人，安心带着你的儿子亚希玛斯和亚比亚他的儿子约拿单回城吧。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","我会在旷野渡口那里等你们的消息。” ");
INSERT INTO cmncbs_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","于是，撒督和亚比亚他便把上帝的约柜抬回耶路撒冷，留了下来。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","大卫蒙着头，赤着脚登上橄榄山，边走边哭，他的随从也蒙着头，哭着走上山。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","有人告诉大卫，亚希多弗也叛变，投奔了押沙龙，大卫就祷告说：“耶和华啊，求你使亚希多弗的谋算都变得愚不可及。” ");
INSERT INTO cmncbs_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","大卫来到山顶敬拜上帝的地方，看见亚基人户筛撕破了衣服，头蒙灰尘前来迎接他。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","大卫对他说：“你跟我一同逃命，只会给我带来不便。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","你若回到城中，告诉押沙龙你愿意做他的臣仆，就像以前做我的臣仆一样，就可以帮我破坏亚希多弗的计谋。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","祭司撒督和亚比亚他都在那里，你在宫内听到什么消息就告诉他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","撒督的儿子亚希玛斯和亚比亚他的儿子约拿单也在那里，你听到什么消息，可以派他们传信给我。” ");
INSERT INTO cmncbs_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","于是，大卫的朋友户筛便回到城里。那时，押沙龙也进了耶路撒冷。 ");
INSERT INTO cmncbs_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","大卫刚越过了山顶，就看见米非波设的仆人洗巴牵着两头驴，驴背上驮着二百个面饼、一百个葡萄饼、一百个夏天的果饼和一皮袋酒来迎接他。 ");
INSERT INTO cmncbs_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","王问洗巴说：“你带这些来做什么？”洗巴说：“驴是给王的家眷骑的，饼和夏天的水果是给你的随从吃的，酒是供他们在旷野疲惫时喝的。” ");
INSERT INTO cmncbs_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","王又问他：“你主人的孙子米非波设在哪里？”洗巴说：“他在耶路撒冷，因为他相信现在以色列人会把他祖父的国归还给他。” ");
INSERT INTO cmncbs_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","王就对洗巴说：“米非波设的一切现在都归你了。”洗巴说：“我叩拜我主我王，愿我在你面前蒙恩。” ");
INSERT INTO cmncbs_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","大卫王来到巴户琳时，扫罗家族基拉的儿子示每出来向着大卫边走边骂， ");
INSERT INTO cmncbs_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","还朝大卫和他的臣仆扔石头，无视大卫身边的众多随从和勇士。 ");
INSERT INTO cmncbs_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","示每骂大卫：“滚吧！滚吧！你这个杀人凶手，你这个败类！ ");
INSERT INTO cmncbs_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","你杀扫罗的家人，夺他的王位，耶和华报应了你，把江山交给了你儿子押沙龙。你这杀人凶手是自食恶果！” ");
INSERT INTO cmncbs_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","洗鲁雅的儿子亚比筛对王说：“这死狗竟敢咒骂我主我王，让我过去砍掉他的头！” ");
INSERT INTO cmncbs_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","王却说：“洗鲁雅的儿子啊，不要管我的事。如果是耶和华叫他来咒骂我，谁能干涉他呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","大卫对亚比筛和他所有臣仆说：“我的亲生儿子尚且要取我的命，何况这个便雅悯人呢？由他去吧！让他咒骂吧！因为这是耶和华的意思。 ");
INSERT INTO cmncbs_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","也许耶和华会体察我的困苦，因我今天所受的咒骂而赐福给我。” ");
INSERT INTO cmncbs_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","于是，大卫和随从继续赶路，示每也沿着对面的山坡边走边骂，向他们扔石头，撒灰尘。 ");
INSERT INTO cmncbs_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","王和众人来到约旦河边时，疲惫不堪，便在那里歇息。 ");
INSERT INTO cmncbs_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","押沙龙和以色列众人进了耶路撒冷，亚希多弗也和他在一起。 ");
INSERT INTO cmncbs_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","大卫的朋友亚基人户筛去见押沙龙，对他说：“愿王万岁！愿王万岁！” ");
INSERT INTO cmncbs_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","押沙龙问户筛说：“这就是你对朋友的忠诚吗？你为什么不跟你的朋友去呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","户筛说：“我不去，谁是耶和华和全体以色列人民所拣选的，我就归属谁，留在谁那里。 ");
INSERT INTO cmncbs_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","再说，我应该服侍谁呢？难道不该服侍王的儿子吗？我要像服侍你父亲一样服侍你。” ");
INSERT INTO cmncbs_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","押沙龙问亚希多弗下一步应该怎么办。 ");
INSERT INTO cmncbs_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","亚希多弗说：“你父亲留下几个妃嫔看守宫殿，你要跟她们同寝，叫所有的以色列人知道你与父亲誓不两立，这样支持你的人会更坚定。” ");
INSERT INTO cmncbs_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","于是，他们便为押沙龙在殿顶盖了一座帐篷，他就当着所有以色列人的面与父亲的妃嫔同寝。 ");
INSERT INTO cmncbs_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","那时，亚希多弗出的主意如同是来自上帝的话，大卫曾对他言听计从，现在押沙龙也是一样。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","亚希多弗对押沙龙说：“请让我挑选一万二千人，今夜启程追赶大卫， ");
INSERT INTO cmncbs_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","趁他疲惫无力的时候袭击他，使他惊慌失措，他的随从必逃命。我只把王一个人杀掉， ");
INSERT INTO cmncbs_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","把他的部下全都带来归顺你。你寻索的人既然死了，跟随他的人必然会归顺你。这样，大家就平安无事了。” ");
INSERT INTO cmncbs_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","押沙龙和以色列的长老都赞成这个提议。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","押沙龙说：“召亚基人户筛进来，我们也听听他的意见。” ");
INSERT INTO cmncbs_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","户筛来了，押沙龙就把亚希多弗的建议告诉他，问他：“我们应该照亚希多弗的提议去做吗？如果不可行，说说你的看法吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","户筛答道：“亚希多弗这次的主意不好！ ");
INSERT INTO cmncbs_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","你知道你父亲和他的部下，他们都是勇士，现在他们就像丢了熊崽的母熊一样凶猛。况且你父亲是个身经百战的人，他一定不会跟部下睡在一处。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","他现在可能藏在山洞或某个地方。要是他袭击我们的人马，听见的人会说押沙龙的军队惨败了。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","那时候，你手下的人再胆量过人，也会胆战心惊。因为全以色列都知道你父亲是英雄，他的部下都是勇士。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","因此，我认为你应该把从但到别示巴的那多如海沙的以色列人都聚集起来，然后你亲自率领他们出征。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","这样不管在哪里找到大卫，我们就像露水一样铺天盖地地袭击他，让他全军覆没。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","如果大卫退进一座城里，我们以色列全军就拿绳索把那城拉到河谷，连一块石头都不留。” ");
INSERT INTO cmncbs_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","押沙龙和以色列众人都说：“亚基人户筛的主意比亚希多弗的好！”其实是耶和华决定破坏亚希多弗的巧计，好把灾祸降在押沙龙身上。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","户筛把亚希多弗和自己为押沙龙及以色列长老所提的建议告诉祭司撒督和亚比亚他， ");
INSERT INTO cmncbs_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","并说：“你们现在快派人去通知大卫，告诉他今晚不可在旷野的渡口过夜，务必要渡过约旦河，免得他和随从全军覆没。” ");
INSERT INTO cmncbs_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","当时，约拿单和亚希玛斯待在隐·罗结，不敢进城，怕被人看见。有一个婢女从城中出来给他们报信，他们便去通知大卫王。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","不料，有一个少年发现了他们，就去告诉押沙龙。他们二人急忙逃走，来到巴户琳的一户人家，藏到那家院子里的一口井内， ");
INSERT INTO cmncbs_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","那家的妇人用盖子盖上井口，然后在上面撒了一些麦子，没有人知道这件事。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","押沙龙的部下来到妇人家查问约拿单和亚希玛斯的下落，妇人说他们已经过河了。押沙龙的部下就去搜索，结果一无所获，就返回耶路撒冷。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","押沙龙的部下离开后，约拿单和亚希玛斯便从井里爬出来，去向大卫王报信，把亚希多弗的计谋告诉他，请他赶快渡过约旦河。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","大卫王和部下就动身过约旦河，在黎明之前，所有的人都过去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","亚希多弗见自己的提议不被接纳，便备上驴，启程回乡，安顿好家事以后，就自缢身亡了。他被安葬在他父亲的墓穴里。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","大卫来到玛哈念，押沙龙也率领以色列全军渡过了约旦河。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","押沙龙任命亚玛撒为元帅，代替约押的位置。亚玛撒是以实玛利人以特拉的儿子，他母亲是拿辖的女儿亚比该。亚比该与约押的母亲洗鲁雅是姊妹。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","押沙龙和以色列人在基列地区安营。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","大卫来到玛哈念后，得到亚扪族拉巴人拿辖的儿子朔比、罗·底巴人亚米利的儿子玛吉和基列的罗基琳人巴西莱的款待。 ");
INSERT INTO cmncbs_vpl VALUES ("S217_28","011_17_28","2SA","17","28","28","他们带来被褥、碗盆、瓦器、小麦、大麦、面粉、炒麦、豆子、扁豆、 ");
INSERT INTO cmncbs_vpl VALUES ("S217_29","011_17_29","2SA","17","29","29","蜂蜜、奶油、绵羊和奶酪，送给大卫和跟随他的人，因为他们想：“众人在旷野一定饥渴疲乏了。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","大卫召集军队，设立了千夫长和百夫长率领他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","他兵分三队，一队由约押率领，一队由洗鲁雅的儿子、约押的兄弟亚比筛率领，一队由迦特人以太率领。大卫对部下说：“我必与你们一同出战。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","他们却说：“你不要出战。因为如果我们败逃，敌方不会放在心上；即使我们一半人阵亡，敌方也不会放在心上。你一人比我们一万人更宝贵。你还是留在城中支援我们吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","王说：“你们认为怎样好，我就怎样做。”于是，大卫王站在城门旁边，军兵百人一队、千人一队地出城了。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","大卫王吩咐约押、亚比筛和以太说：“你们要看在我的份上对年轻的押沙龙手下留情。”全体的军兵都听见了大卫吩咐众将领的话。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","大卫的军队在以法莲的树林里跟以色列人交战。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","以色列人被大卫的部下打败，伤亡惨重，有两万人阵亡。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","战事蔓延到整个郊野，那天死在树林里的人比死在刀下的人还多。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","押沙龙碰巧遇见大卫的部下。他骑着骡子逃走，骡子从一棵大橡树的茂密枝条下经过，押沙龙的头发被树枝缠住，整个人吊在半空中，胯下的骡子也跑了。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","大卫的一个部下看见，就向约押禀告说：“我看见押沙龙正吊在橡树上。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","约押对那报信的说：“什么！你看见他吊在树上，为什么不把他杀掉呢？要是你把他杀了，我会赏你十块银子和一条腰带。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","他却答道：“就是你赏我一千块银子，我也不敢加害王的儿子啊！我们曾听见王吩咐你、亚比筛和以太不可伤害年轻的押沙龙。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","如果我胆敢杀死押沙龙，王迟早会查出真相，到时你就撒手不管了。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","约押说：“我不跟你浪费时间。”趁着押沙龙还吊在橡树上，他拿起三杆矛枪剌入了他的心脏。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","十个为约押拿兵器的年轻人围上去将押沙龙杀死。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","随后，约押吹起收兵的号角，军兵便停止追赶以色列人。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","他们把押沙龙的尸体扔在林中的一个坑里，在上面堆了一大堆石头。以色列人都各自逃回家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","押沙龙生前没有儿子为他留名，所以他曾在王谷立了一根石柱，以自己的名字命名，称为“押沙龙柱”，沿用至今。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","撒督的儿子亚希玛斯对约押说：“请让我跑回去向王禀告，让王知道耶和华已从仇敌手中救了他。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","但约押对他说：“你今天不要去报信，改天再报吧。你今天不要去，因为王的儿子死了。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","约押吩咐一个古实人：“你去把所看见的禀报给王。”那人就拜别了约押，马上跑回去报信。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","撒督的儿子亚希玛斯再次对约押说：“无论怎样，求你让我与古实人一同去吧！”约押说：“我的孩子，你何必要去呢？你报这个消息是不会得到赏赐的。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","他说：“无论怎样，我想跑去报信。”约押答应了。亚希玛斯沿平原的路跑，跑到了古实人的前面。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","那时，大卫正坐在内城门和外城门中间。有一个守望者爬上城门楼顶观望，看见一个人独自跑来。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","守望者就大声向王禀告。王说：“他若是独自一人，带来的一定是好消息。”那人越来越近了。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","这时候，守望者又看见另一个人跑来，就大声对守城门的说：“又有一个人独自跑来了！”王说：“他也一定是传好消息的。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","守望者又说：“从跑的姿势看，那跑在前面的人好像撒督的儿子亚希玛斯。”王说：“他是个好人，他一定带来了好消息。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","亚希玛斯高声对王说：“一切平安！”他在王面前俯伏叩拜，说：“你的上帝耶和华当受称颂，祂已经消灭了那些攻击我主我王的敌人。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","王问道：“年轻的押沙龙平安吗？”亚希玛斯答道：“约押派仆人来的时候，仆人看见一阵大骚动，但不知道是什么事。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","王说：“你先退到一边去。”亚希玛斯就退下，站在一边。 ");
INSERT INTO cmncbs_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","这时，古实人也到了，他说：“我有好消息向我主我王禀告，今日耶和华已经从一切反叛之人手中救了我主我王。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","王问古实人：“年轻的押沙龙平安吗？”古实人答道：“愿我主我王的仇敌和一切要加害我王的人，下场都与那青年一样。” ");
INSERT INTO cmncbs_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","王听了十分难过，就走上城门楼去痛哭，边走边说：“我儿押沙龙啊！我儿，我儿押沙龙啊！我恨不得可以替你死！押沙龙，我儿啊！我儿！” ");
INSERT INTO cmncbs_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","有人告诉约押，说：“王在为押沙龙哀伤痛哭。” ");
INSERT INTO cmncbs_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","士兵们听说王为押沙龙哀痛，胜利的欢腾顿时变为一片哀愁。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","那一天，众人都静悄悄地回城去，好像败兵一样羞愧。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","王仍掩面痛哭：“我儿押沙龙啊！押沙龙！我儿！我儿啊！” ");
INSERT INTO cmncbs_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","约押就进到屋里，对王说：“你的仆人们救了你和你妻妾儿女的性命，你今天却使他们感到羞愧。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","仇视你的人，你倒去爱他；那些爱你的人，你反憎恶他们。这表明我王的心中根本没有我们这些将领和部下。如今我明白了，要是死去的不是押沙龙而是我们，你就高兴了。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","你现在应该出去安抚士兵们。我凭耶和华起誓，如果你不这样做，今晚必无一人再追随你。那将是你一生所遭遇的最大灾难！” ");
INSERT INTO cmncbs_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","于是王出去坐在城门口，众人听说后，都来到他面前。这时，跟随押沙龙的以色列人都各自逃回家去了。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","以色列各支派的人都在纷纷议论：“王曾把我们从众仇敌和非利士人手中救出来。如今他为了躲避押沙龙而逃离本国。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","我们膏立为王的押沙龙已经死了，为什么无人说请王回来呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","大卫王派人去对祭司撒督和亚比亚他说：“你们去问犹大的长老，‘全以色列已经准备迎接王回宫，你们为什么迟迟没有反应？ ");
INSERT INTO cmncbs_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","你们是王的弟兄，是王的骨肉，为什么迟迟没有迎接王回宫？’ ");
INSERT INTO cmncbs_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","你们也要对亚玛撒说，‘你是我的骨肉，要是我不立你为元帅取代约押，愿上帝重重地处罚我。’” ");
INSERT INTO cmncbs_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","王的这番话打动了所有犹大人的心，他们派人去请王和王的臣仆回来。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","王便启程回宫。他来到约旦河时，犹大人都到吉甲来迎接他，要护送他过河。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","来自巴户琳的便雅悯人基拉的儿子示每也急忙跟着犹大人赶来迎接大卫王， ");
INSERT INTO cmncbs_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","有一千便雅悯人跟示每一起去迎接大卫王。扫罗的仆人洗巴带着十五个儿子和二十个仆人也赶到约旦河。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","他们渡到河对面帮助王的家眷过河，为王效劳。王正要过河的时候，基拉的儿子示每就俯伏在他面前， ");
INSERT INTO cmncbs_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","说：“求我主饶恕仆人的罪过！仆人在我主我王离开耶路撒冷时所犯的罪，求我王不要记在心上。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","仆人自知有罪，所以今天我是整个约瑟家族中第一个迎接我主我王的人。” ");
INSERT INTO cmncbs_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","洗鲁雅的儿子亚比筛说：“示每曾经咒骂耶和华所膏立的君王，难道不应该处死他吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","大卫说：“洗鲁雅的儿子，不要管我的事。你今天是在跟我作对。今天在以色列怎么可以处死人呢？难道我不知道今天我是以色列的王吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","于是大卫起誓不杀示每。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","扫罗的孙子米非波设也来迎接王。从王离开那天，直到大卫平安回来之日，他没有修过脚，没有剃过胡子，也没有洗过衣服。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","他到耶路撒冷来迎接王，王问他：“米非波设，当时你为什么不跟我一起走呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","米非波设答道：“我主我王，我是瘸腿的，我本想预备一头驴骑着与我王同去，是我的仆人洗巴欺骗了我。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","他在我主我王面前毁谤我。我主我王就像上帝的天使，请王定夺。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","我父全家在我主我王面前都是该死的，但王却让我与王同席吃饭，我还能向王要求什么呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","王对他说：“不要再提这事了，我决定让你和洗巴平分土地。” ");
INSERT INTO cmncbs_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","米非波设说：“把土地都给他吧，我主我王平安地回来就好了。” ");
INSERT INTO cmncbs_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","基列人巴西莱也从罗基琳下来护送王过约旦河，然后送王上路。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","那时，巴西莱已经是八十高龄了。王留在玛哈念的时候，他曾供应王食物，因为他非常富有。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","王对巴西莱说：“你跟我一同回耶路撒冷，我会照顾你。” ");
INSERT INTO cmncbs_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","巴西莱说：“我何必跟王一同去耶路撒冷呢？我还能活多久呢？ ");
INSERT INTO cmncbs_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","我已经八十岁了，美丑难分，食不知味，乐不辨音，何必为我主我王添麻烦呢？ ");
INSERT INTO cmncbs_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","仆人只不过是陪王过约旦河，王何必给我这么大的赏赐呢？ ");
INSERT INTO cmncbs_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","请准我回去，我好死在故乡，葬在父母的墓旁。这里有王的仆人金罕，让他跟我主我王一起去。你看怎么好，就怎么对待他吧。” ");
INSERT INTO cmncbs_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","王说：“金罕可以跟我去，我会照你的心愿待他。无论你有什么要求，我都会答应你。” ");
INSERT INTO cmncbs_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","王和众人过了约旦河以后，就亲吻巴西莱，为他祝福。巴西莱返回了家乡。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","王过河后，来到吉甲，金罕跟随着他。护送王的有犹大的士兵和半数的以色列士兵。 ");
INSERT INTO cmncbs_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","后来，所有的以色列人来见王，说：“为什么我们的弟兄犹大人偷偷地送王、王的家眷和王的部下渡河？” ");
INSERT INTO cmncbs_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","犹大人答道：“我们这样做是因为王是我们的亲族。你们为什么生气呢？难道我们吃了王的供应，得了什么礼物吗？” ");
INSERT INTO cmncbs_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","以色列人说：“但我们和王有十份的情分，我们在大卫身上比你们更有份。你们为什么轻视我们？难道不是我们首先提出要请王回来的吗？” 但犹大人的态度比以色列人还要强硬。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_1","011_20_1","2SA","20","1","1","有一个无赖名叫示巴，是便雅悯人比基利的儿子，当时刚好在吉甲。他吹响号角，大喊：“我们与大卫毫无关系，耶西儿子的产业没有我们的份。以色列人啊，各自回家去吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S220_2","011_20_2","2SA","20","2","2","于是，以色列人都离开了大卫，跟随了比基利的儿子示巴。但犹大人仍然紧紧跟随他们的王，从约旦河一直来到耶路撒冷。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_3","011_20_3","2SA","20","3","3","大卫回到耶路撒冷的宫里，把从前留下来看守王宫的十个妃嫔关进冷宫，供养她们，却不再和她们同房。她们像寡妇一样在软禁中度过余生。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_4","011_20_4","2SA","20","4","4","王对亚玛撒说：“你要在三天内招聚犹大人，跟他们一起来见我。” ");
INSERT INTO cmncbs_vpl VALUES ("S220_5","011_20_5","2SA","20","5","5","亚玛撒就去招聚犹大人，但他超过了王所定的期限。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_6","011_20_6","2SA","20","6","6","大卫对亚比筛说：“现在比基利的儿子示巴给我们带来的危害恐怕比押沙龙还要大。你带领我的部下去捉拿他，免得他占据了坚固的城池，得以逃脱。” ");
INSERT INTO cmncbs_vpl VALUES ("S220_7","011_20_7","2SA","20","7","7","于是，约押的部下和基利提人、比利提人，以及所有的勇士都跟随亚比筛离开耶路撒冷，去追赶比基利的儿子示巴。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_8","011_20_8","2SA","20","8","8","他们来到基遍的巨石旁，见亚玛撒迎面而来。约押当时身穿战袍，腰间佩刀，他迎上去的时候，刀从鞘中滑落出来。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_9","011_20_9","2SA","20","9","9","约押对亚玛撒说：“兄弟，你好吗？”他用右手抓住亚玛撒的胡子，亲吻他。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_10","011_20_10","2SA","20","10","10","亚玛撒毫无防备，被约押一刀刺入肚子，肚破肠流而死。然后，约押和他兄弟亚比筛继续追赶比基利的儿子示巴。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_11","011_20_11","2SA","20","11","11","约押的一个部下站在亚玛撒的尸体旁边说：“拥护约押和大卫的人来跟随约押吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S220_12","011_20_12","2SA","20","12","12","亚玛撒的尸体倒在路中间的血泊中。那人见众人驻足围观，便把尸体从路上拖到田里，扔了一件衣服盖上。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_13","011_20_13","2SA","20","13","13","尸体搬走以后，众人都跟随约押去追比基利的儿子示巴。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_14","011_20_14","2SA","20","14","14","示巴走遍以色列各支派，一直到伯·玛迦的亚比拉城。他的本族比利人都聚集起来跟随他。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_15","011_20_15","2SA","20","15","15","约押率大军来到伯·玛迦，把示巴围困在亚比拉城内，他们修筑攻城的高台，撞击城墙，要摧毁它。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_16","011_20_16","2SA","20","16","16","有一个聪明的妇人从城上喊：“请听我说！请听我说！请约押到这边来，我有话要对他说。” ");
INSERT INTO cmncbs_vpl VALUES ("S220_17","011_20_17","2SA","20","17","17","约押就走上前去，那妇人问道：“你是约押吗？”约押答道：“我就是。”妇人说：“请听婢女说几句。”约押说：“你说吧！” ");
INSERT INTO cmncbs_vpl VALUES ("S220_18","011_20_18","2SA","20","18","18","妇人说：“古时候人们常说，‘有事到亚比拉去请教，问题都会解决。’ ");
INSERT INTO cmncbs_vpl VALUES ("S220_19","011_20_19","2SA","20","19","19","我们这座城的人在以色列素来热爱和平、忠心耿耿，你却要毁灭这座大城。你为什么要吞掉耶和华的产业？” ");
INSERT INTO cmncbs_vpl VALUES ("S220_20","011_20_20","2SA","20","20","20","约押答道：“我根本不想吞掉或毁灭这城。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_21","011_20_21","2SA","20","21","21","事情不是这样。以法莲山区比基利的儿子示巴背叛大卫王，你们只要把他交出来，我就撤退。”那妇人说：“我们一定把他的首级从城上抛下来给你。” ");
INSERT INTO cmncbs_vpl VALUES ("S220_22","011_20_22","2SA","20","22","22","妇人把自己的良策告诉众人，他们便把比基利的儿子示巴的头割下来，抛给约押。约押就吹响号角令军队各自回家，自己回耶路撒冷见王。 ");
INSERT INTO cmncbs_vpl VALUES ("S220_23","011_20_23","2SA","20","23","23","约押负责统率以色列全军；耶何耶大的儿子比拿雅统管基利提人和比利提人； ");
INSERT INTO cmncbs_vpl VALUES ("S220_24","011_20_24","2SA","20","24","24","亚多兰管理服劳役的；亚希律的儿子约沙法做史官； ");
INSERT INTO cmncbs_vpl VALUES ("S220_25","011_20_25","2SA","20","25","25","示法做书记；撒督和亚比亚他做祭司； ");
INSERT INTO cmncbs_vpl VALUES ("S220_26","011_20_26","2SA","20","26","26","雅珥人以拉做大卫的祭司。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_1","011_21_1","2SA","21","1","1","在大卫执政期间，连续有三年饥荒，大卫就求问耶和华。耶和华说：“发生这饥荒是因为扫罗一家人的血债，他们杀害了基遍人。” ");
INSERT INTO cmncbs_vpl VALUES ("S221_2","011_21_2","2SA","21","2","2","原来基遍人不是以色列人，他们是亚摩利人的遗民。以色列人曾起誓不伤害他们，但扫罗为以色列人和犹大人发热心，试图铲除基遍人。大卫就召来基遍人， ");
INSERT INTO cmncbs_vpl VALUES ("S221_3","011_21_3","2SA","21","3","3","问他们：“我可以为你们做些什么？我该怎样赎罪，你们才愿意祝福耶和华的子民呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S221_4","011_21_4","2SA","21","4","4","基遍人答道：“金银不能解决我们和扫罗一家人的问题，我们也不想处死任何以色列人。”大卫说：“你们要我怎么办？” ");
INSERT INTO cmncbs_vpl VALUES ("S221_5","011_21_5","2SA","21","5","5","他们说：“扫罗曾试图灭绝我们，把我们从以色列境内铲除。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_6","011_21_6","2SA","21","6","6","请把他的七个子孙交给我们，我们好在耶和华面前把他们吊死在基比亚，就是耶和华选立扫罗的地方。”王说：“我必把他们交给你们。” ");
INSERT INTO cmncbs_vpl VALUES ("S221_7","011_21_7","2SA","21","7","7","大卫王因为与扫罗的儿子约拿单在耶和华面前起过誓，就没有把扫罗的孙子、约拿单的儿子米非波设交出来。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_8","011_21_8","2SA","21","8","8","他把爱亚的女儿利斯巴为扫罗所生的两个儿子亚摩尼、米非波设，以及扫罗女儿米拉为米何拉人巴西莱的儿子亚得列所生的五个儿子交给基遍人。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_9","011_21_9","2SA","21","9","9","基遍人在耶和华面前把他们七人吊死在山上。他们都一同死去，那时正好是收割大麦的时候。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_10","011_21_10","2SA","21","10","10","爱亚的女儿利斯巴取麻布为自己铺在磐石上。她白天不让飞鸟靠近，夜间不容野兽走近，从开始收割大麦，一直守到降下雨来。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_11","011_21_11","2SA","21","11","11","大卫知道扫罗的嫔妃——爱亚的女儿利斯巴的事以后， ");
INSERT INTO cmncbs_vpl VALUES ("S221_12","011_21_12","2SA","21","12","12","就去基列·雅比人那里把扫罗和约拿单的骸骨运来。从前非利士人在基利波杀死扫罗和约拿单，把他们的尸体挂在伯·珊的广场，后来基列·雅比人把尸体偷走了。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_13","011_21_13","2SA","21","13","13","大卫运回扫罗和约拿单的骸骨，又收殓了扫罗那七个子孙的骸骨。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_14","011_21_14","2SA","21","14","14","众人按照大卫的吩咐，把扫罗和约拿单的骸骨埋葬在扫罗父亲基士的墓里，在便雅悯境内的洗拉。此后，上帝垂听了人们为国家的祷告。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_15","011_21_15","2SA","21","15","15","非利士人又和以色列人交战，大卫亲自出征。在他十分疲倦的时候， ");
INSERT INTO cmncbs_vpl VALUES ("S221_16","011_21_16","2SA","21","16","16","一个名叫以实·比诺的巨人佩戴新刀，手拿三公斤半重的铜矛，冲上来要杀他。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_17","011_21_17","2SA","21","17","17","洗鲁雅的儿子亚比筛赶来救驾，杀死了非利士巨人。这事以后，大卫的部下向他起誓说：“你绝不可再跟我们一起出战，免得以色列的灯熄灭。” ");
INSERT INTO cmncbs_vpl VALUES ("S221_18","011_21_18","2SA","21","18","18","后来，以色列人与非利士人在歌伯交战，户沙人西比该杀了另一个非利士巨人撒弗。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_19","011_21_19","2SA","21","19","19","在歌伯与非利士人的另一次交战中，伯利恒人雅雷·俄珥金的儿子伊勒哈难杀了迦特人歌利亚。歌利亚的枪杆粗如织布机的轴。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_20","011_21_20","2SA","21","20","20","在迦特的一次交战中，有一个非利士巨人每只手和脚各有六个手指和脚趾，共二十四个手指和脚趾。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_21","011_21_21","2SA","21","21","21","他向以色列人骂阵，大卫的哥哥示米亚的儿子约拿单杀了他。 ");
INSERT INTO cmncbs_vpl VALUES ("S221_22","011_21_22","2SA","21","22","22","这四个迦特巨人的后裔都死在大卫和他的部下手里。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","耶和华从扫罗及所有仇敌手中拯救大卫那天，他向耶和华吟唱此诗： ");
INSERT INTO cmncbs_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","“耶和华是我的磐石， 我的堡垒，我的拯救者； ");
INSERT INTO cmncbs_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","我的上帝是庇护我的磐石， 是我的盾牌，是拯救我的力量， 是我的坚垒，我的避难所， 我的救主。 你救我脱离残暴之徒。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","我求告当受颂赞的耶和华， 祂便救我脱离仇敌。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","“死亡的波涛环绕我， 毁灭的狂流淹没我。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","阴间的绳索捆绑我， 死亡的网罗笼罩我。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","“我在苦难中呼求耶和华， 向我的上帝求助， 祂从殿中垂听我的呼求， 我的声音达到祂耳中。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_8","011_22_8","2SA","22","8","8","“祂一发怒，大地震动颤抖， 穹苍的根基摇晃。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_9","011_22_9","2SA","22","9","9","祂的鼻孔冒烟， 口喷烈焰和火炭。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_10","011_22_10","2SA","22","10","10","祂使穹苍低垂，亲自降临， 脚下踩着密云。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_11","011_22_11","2SA","22","11","11","祂乘着基路伯天使飞翔， 在风的翅膀上显现。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_12","011_22_12","2SA","22","12","12","祂藏身于黑暗中， 四围以密云作幔幕。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_13","011_22_13","2SA","22","13","13","祂面前的荣光中发出道道闪电。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_14","011_22_14","2SA","22","14","14","耶和华在天上打雷， 至高者发出声音。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_15","011_22_15","2SA","22","15","15","祂射出利箭驱散仇敌， 发出闪电击溃他们。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_16","011_22_16","2SA","22","16","16","耶和华斥责一声， 祂的鼻孔一吹气， 海底就显现， 大地也露出根基。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_17","011_22_17","2SA","22","17","17","“祂从高天伸手抓住我， 从大水中把我拉上来。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_18","011_22_18","2SA","22","18","18","祂救我脱离强敌， 脱离我无法战胜的仇敌。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_19","011_22_19","2SA","22","19","19","他们在我危难之时攻击我， 但耶和华扶持我。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_20","011_22_20","2SA","22","20","20","祂领我到宽阔之地； 祂搭救我，因为祂喜悦我。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","“耶和华因我公义而善待我， 因我清白而赏赐我。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","因为我遵行祂的道， 没有作恶背弃我的上帝。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","“我遵守祂的一切法令， 没有把祂的律例弃置一旁。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","我在祂面前纯全无过， 没有沾染罪恶。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","耶和华按我的公义， 照我在祂面前的清白奖赏我。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","“仁慈的人，你以仁慈待他； 纯全的人，你以纯全待他。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","纯洁的人，你以纯洁待他； 乖谬的人，你以计谋待他。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","你拯救谦卑的人， 鉴察、贬抑高傲的人。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","耶和华啊！你是我的明灯， 你使我的黑暗变为光明。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_30","011_22_30","2SA","22","30","30","我靠着你迎战敌军， 靠着我的上帝跃过墙垣。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","“上帝的道完美， 耶和华的话纯全， 祂是一切投靠祂之人的盾牌。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","除了耶和华，谁是上帝呢？ 除了我们的上帝，谁是磐石呢？ ");
INSERT INTO cmncbs_vpl VALUES ("S222_33","011_22_33","2SA","22","33","33","上帝是我的坚固堡垒， 祂使我行为纯全。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_34","011_22_34","2SA","22","34","34","祂使我的脚如母鹿的蹄， 稳踏在高处。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_35","011_22_35","2SA","22","35","35","祂训练我的手如何争战， 使我的臂膀能拉开铜弓。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","你是拯救我的盾牌， 你的垂顾使我强大。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_37","011_22_37","2SA","22","37","37","你使我脚下的道路宽阔， 不致滑倒。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_38","011_22_38","2SA","22","38","38","我追赶仇敌，击溃他们， 不消灭他们决不回头。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_39","011_22_39","2SA","22","39","39","我打垮他们， 使他们倒在我的脚下， 再也站不起来。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_40","011_22_40","2SA","22","40","40","你赐我征战的能力， 使我的仇敌降服在我脚下。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_41","011_22_41","2SA","22","41","41","你使我的仇敌败逃， 我歼灭了恨我的人。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_42","011_22_42","2SA","22","42","42","他们呼救，却无人拯救。 他们呼求耶和华，祂也不应允。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_43","011_22_43","2SA","22","43","43","我把他们打得粉碎，如同地上的灰尘， 压碎并践踏他们，如同街上的泥土。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_44","011_22_44","2SA","22","44","44","你救我脱离我百姓的攻击， 立我做列国的元首， 素不相识的民族也服侍我。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_45","011_22_45","2SA","22","45","45","外族人望风而降，对我俯首称臣。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_46","011_22_46","2SA","22","46","46","他们闻风丧胆， 战战兢兢地走出他们的城池。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_47","011_22_47","2SA","22","47","47","“耶和华永远活着， 我的磐石当受颂赞， 拯救我的磐石，我的上帝当受尊崇。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_48","011_22_48","2SA","22","48","48","祂是为我申冤的上帝， 祂使列邦臣服于我。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_49","011_22_49","2SA","22","49","49","祂救我脱离仇敌， 使我胜过强敌， 救我脱离残暴之徒。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_50","011_22_50","2SA","22","50","50","因此，耶和华啊， 我要在列邦中赞美你， 歌颂你的名。 ");
INSERT INTO cmncbs_vpl VALUES ("S222_51","011_22_51","2SA","22","51","51","你使你立的王大获全胜， 向你膏立的大卫及其后代广施慈爱， 直到永远。” ");
INSERT INTO cmncbs_vpl VALUES ("S223_1","011_23_1","2SA","23","1","1","耶西的儿子大卫是雅各的上帝膏立的王，他身居高位，在以色列能歌善咏。以下是他的遗言： ");
INSERT INTO cmncbs_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","“耶和华的灵借着我说话， 祂的言语在我口中。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_3","011_23_3","2SA","23","3","3","以色列的上帝告诉我， 以色列的磐石对我说， ‘以公义治理人民， 敬畏上帝的君王， ");
INSERT INTO cmncbs_vpl VALUES ("S223_4","011_23_4","2SA","23","4","4","就像旭日的光辉、 晴朗的早晨， 又像雨后的光芒， 使大地长出青草。’ ");
INSERT INTO cmncbs_vpl VALUES ("S223_5","011_23_5","2SA","23","5","5","我的家在上帝面前不正是如此吗？ 上帝与我立下永远的约， 这约稳妥可靠。 祂必拯救我，成全我的愿望。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_6","011_23_6","2SA","23","6","6","但恶人要像荆棘一样被丢弃， 没人用手拿起他们， ");
INSERT INTO cmncbs_vpl VALUES ("S223_7","011_23_7","2SA","23","7","7","人要拿铁器和长矛把他们收集起来焚毁。” ");
INSERT INTO cmncbs_vpl VALUES ("S223_8","011_23_8","2SA","23","8","8","以下是大卫的勇士：他革扪人约设·巴设，又称伊斯尼人亚底挪，是三勇士之首，曾在一次交战中杀掉八百敌人。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_9","011_23_9","2SA","23","9","9","其次是亚哈希人朵多的儿子以利亚撒，他是三勇士之一。有一次，以色列人和非利士人打仗，他跟随大卫向非利士人骂阵。以色列人都撤退了， ");
INSERT INTO cmncbs_vpl VALUES ("S223_10","011_23_10","2SA","23","10","10","他却坚守阵地，奋勇杀敌，直到手臂发麻，握刀的手无法松开。那天，耶和华使以色列人大获全胜。以色列军队回到以利亚撒那里来捡死人的财物。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_11","011_23_11","2SA","23","11","11","第三位勇士是哈拉人亚基的儿子沙玛。有一次非利士人聚集在一块长满扁豆的田中和以色列人打仗，以色列人都逃跑了， ");
INSERT INTO cmncbs_vpl VALUES ("S223_12","011_23_12","2SA","23","12","12","沙玛却站在田中间坚守麦田，击杀非利士人。耶和华使以色列人大获全胜。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_13","011_23_13","2SA","23","13","13","在收割的时候，非利士军队在利乏音谷扎营，三十位统领中有三位到亚杜兰洞见大卫。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_14","011_23_14","2SA","23","14","14","那时大卫留守在堡垒里，非利士人的驻军在伯利恒。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_15","011_23_15","2SA","23","15","15","大卫渴了，说：“但愿有人给我打些伯利恒城门旁的井水喝！” ");
INSERT INTO cmncbs_vpl VALUES ("S223_16","011_23_16","2SA","23","16","16","这三位勇士就冲过非利士人的营地，到伯利恒城门旁的井打水，带回来给大卫。大卫却不肯喝，他把水浇奠在耶和华面前， ");
INSERT INTO cmncbs_vpl VALUES ("S223_17","011_23_17","2SA","23","17","17","说：“耶和华啊！这三人冒死去打水，这些水就像是他们的血，我决不能喝！”因此，大卫不肯喝。这是三勇士的事迹。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_18","011_23_18","2SA","23","18","18","洗鲁雅的儿子、约押的兄弟亚比筛是这三位勇士的统领，他曾挥矛刺死三百人，在三勇士中出了名， ");
INSERT INTO cmncbs_vpl VALUES ("S223_19","011_23_19","2SA","23","19","19","最有声望，因此做了他们的统领，只是不及前三位勇士。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_20","011_23_20","2SA","23","20","20","甲薛人耶何耶大的儿子比拿雅是位勇士，做过非凡的事。他曾杀死摩押的两个勇猛战士，也曾在下雪天跳进坑中杀死一头狮子， ");
INSERT INTO cmncbs_vpl VALUES ("S223_21","011_23_21","2SA","23","21","21","还杀死了一个埃及勇士。当时埃及人拿着长矛，比拿雅拿着棍子迎战，他夺了对方的长矛，用那矛刺死了对方。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_22","011_23_22","2SA","23","22","22","这是耶何耶大的儿子比拿雅的事迹，他像那三位勇士一样赢得了名声。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_23","011_23_23","2SA","23","23","23","他比那三十勇士更有声望，只是不及前三位勇士。大卫派他做护卫长。 ");
INSERT INTO cmncbs_vpl VALUES ("S223_24","011_23_24","2SA","23","24","24","三十位勇士中有：约押的兄弟亚撒黑、伯利恒人朵多的儿子伊勒哈难、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_25","011_23_25","2SA","23","25","25","哈律人沙玛、哈律人以利加、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_26","011_23_26","2SA","23","26","26","帕勒提人希利斯、提哥亚人益吉的儿子以拉、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_27","011_23_27","2SA","23","27","27","亚拿突人亚比以谢、户沙人米本乃、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_28","011_23_28","2SA","23","28","28","亚哈希人撒们、尼陀法人玛哈莱、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_29","011_23_29","2SA","23","29","29","尼陀法人巴拿的儿子希立、便雅悯支派基比亚人利拜的儿子以太、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_30","011_23_30","2SA","23","30","30","比拉顿人比拿雅、迦实溪人希太、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_31","011_23_31","2SA","23","31","31","伯·亚拉巴人亚比亚本、巴鲁米人押斯玛弗、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_32","011_23_32","2SA","23","32","32","沙本人以利雅哈巴、雅善的儿子们、哈拉人沙玛的儿子约拿单、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_33","011_23_33","2SA","23","33","33","哈拉人沙拉的儿子亚希暗、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_34","011_23_34","2SA","23","34","34","玛迦人亚哈拜的儿子以利法列、基罗人亚希多弗的儿子以连、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_35","011_23_35","2SA","23","35","35","迦密人希斯莱、亚巴人帕莱、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_36","011_23_36","2SA","23","36","36","琐巴人拿单的儿子以甲、迦得人巴尼、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_37","011_23_37","2SA","23","37","37","亚扪人洗勒、为洗鲁雅的儿子约押拿兵器的比录人拿哈莱、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_38","011_23_38","2SA","23","38","38","以帖人以拉、以帖人迦立、 ");
INSERT INTO cmncbs_vpl VALUES ("S223_39","011_23_39","2SA","23","39","39","赫人乌利亚，共三十七名勇士。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_1","011_24_1","2SA","24","1","1","耶和华又向以色列人发怒，祂促使大卫来对付他们，让大卫统计以色列和犹大的人口。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_2","011_24_2","2SA","24","2","2","大卫对统领军队的约押说：“你去走遍以色列各支派，从但到别示巴，统计以色列和犹大的人口，让我知道国民的数目。” ");
INSERT INTO cmncbs_vpl VALUES ("S224_3","011_24_3","2SA","24","3","3","约押说：“我主我王，愿你的上帝耶和华使国民的人数比现在增加百倍，让你亲眼看到。但我主我王为什么要做这事呢？” ");
INSERT INTO cmncbs_vpl VALUES ("S224_4","011_24_4","2SA","24","4","4","但大卫不听约押和其他将领的规劝。他们只好去统计以色列的人数。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_5","011_24_5","2SA","24","5","5","他们过了约旦河，在谷中亚罗珥城南面安营，又经过迦得前往雅谢。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_6","011_24_6","2SA","24","6","6","然后，他们到基列、他停·合示地区、但·雅安，绕到西顿， ");
INSERT INTO cmncbs_vpl VALUES ("S224_7","011_24_7","2SA","24","7","7","再去泰尔的堡垒及希未人和迦南人的城邑。最后，他们到了犹大南部的别示巴。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_8","011_24_8","2SA","24","8","8","他们花了九个月零二十天的时间，走遍全国，最后回到耶路撒冷。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_9","011_24_9","2SA","24","9","9","约押把统计的人数奏告王：“以色列有八十万英勇的刀兵，犹大有五十万。” ");
INSERT INTO cmncbs_vpl VALUES ("S224_10","011_24_10","2SA","24","10","10","大卫统计了人口以后，内心不安，就对耶和华说：“我做这事犯了大罪。耶和华啊，求你赦免仆人的罪，我做了极其愚昧的事。” ");
INSERT INTO cmncbs_vpl VALUES ("S224_11","011_24_11","2SA","24","11","11","大卫第二天早上起来，耶和华对大卫的先见迦得先知说： ");
INSERT INTO cmncbs_vpl VALUES ("S224_12","011_24_12","2SA","24","12","12","“你去告诉大卫，耶和华说，‘我有三样灾祸，你可以选择让我降哪一样给你。’” ");
INSERT INTO cmncbs_vpl VALUES ("S224_13","011_24_13","2SA","24","13","13","迦得就来见大卫，对他说：“你愿意国内有七年饥荒呢？还是被敌人追杀三个月呢？还是国内发生三天瘟疫呢？请你考虑好后告诉我，我好回复那差我来的。” ");
INSERT INTO cmncbs_vpl VALUES ("S224_14","011_24_14","2SA","24","14","14","大卫说：“我实在为难！不过我宁愿落在耶和华的手中，也不愿落在人的手中，因为耶和华有极大的怜悯。” ");
INSERT INTO cmncbs_vpl VALUES ("S224_15","011_24_15","2SA","24","15","15","于是，耶和华在以色列降下瘟疫，从那天早晨一直持续到所定的时间，从但到别示巴共有七万人死亡。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_16","011_24_16","2SA","24","16","16","当天使准备伸手毁灭耶路撒冷的时候，耶和华心生怜悯，就对灭命天使说：“够了，住手吧！”当时，耶和华的天使正站在耶布斯人亚劳拿的麦场上。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_17","011_24_17","2SA","24","17","17","大卫看见灭命天使，就对耶和华说：“是我犯了罪，做了恶事，这些百姓有什么过错呢？愿你的手惩罚我和我的家族。” ");
INSERT INTO cmncbs_vpl VALUES ("S224_18","011_24_18","2SA","24","18","18","就在那天，迦得来见大卫，对他说：“你要去耶布斯人亚劳拿的麦场，在那里为耶和华建一座坛。” ");
INSERT INTO cmncbs_vpl VALUES ("S224_19","011_24_19","2SA","24","19","19","大卫就照耶和华借迦得所说的话去了麦场。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_20","011_24_20","2SA","24","20","20","亚劳拿看见王及他的臣仆来了，就上前俯伏在地，向王下拜， ");
INSERT INTO cmncbs_vpl VALUES ("S224_21","011_24_21","2SA","24","21","21","说：“我主我王到仆人这里有什么事？”大卫说：“我要买你的麦场，好在这里为耶和华筑一座坛，使民中的瘟疫止息。” ");
INSERT INTO cmncbs_vpl VALUES ("S224_22","011_24_22","2SA","24","22","22","亚劳拿说：“我主我王喜欢什么，就拿去献祭吧。这里有牛可以作燔祭，还有打麦的器具和牛轭可以作柴。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_23","011_24_23","2SA","24","23","23","王啊，仆人亚劳拿愿意把这一切都献给你，愿你的上帝耶和华悦纳你。” ");
INSERT INTO cmncbs_vpl VALUES ("S224_24","011_24_24","2SA","24","24","24","王却说：“不可，我一定要出钱买，我不要用白白得来之物作为燔祭献给我的上帝耶和华。”大卫就用十两银子买了亚劳拿的麦场和牛。 ");
INSERT INTO cmncbs_vpl VALUES ("S224_25","011_24_25","2SA","24","25","25","大卫在那里为耶和华建了一座坛，献上燔祭和平安祭，耶和华垂听了他的祷告，瘟疫就在以色列止住了。");
INSERT INTO cmncbs_vpl VALUES ("K11_1","012_1_1","1KI","1","1","1","大卫王年纪老迈，虽然盖了几层被子，仍然觉得冷。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_2","012_1_2","1KI","1","2","2","他的臣仆建议：“不如选一位少女进宫伺候、照顾我主我王，让她睡在王怀中给王取暖。” ");
INSERT INTO cmncbs_vpl VALUES ("K11_3","012_1_3","1KI","1","3","3","于是，他们在以色列全国寻找美貌女子，找到了一位名叫雅比莎的书念少女，把她带到王那里。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_4","012_1_4","1KI","1","4","4","这女子长得非常美丽，她照顾、伺候王，但王没有与她同房。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_5","012_1_5","1KI","1","5","5","那时，哈及的儿子亚多尼雅妄自尊大，说：“我必做王。”他为自己制备了车辆和骑兵，派五十人在前面开路。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_6","012_1_6","1KI","1","6","6","他父亲从不责问他：“你这是做什么？”他是押沙龙的弟弟，长得英俊非凡。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_7","012_1_7","1KI","1","7","7","亚多尼雅与洗鲁雅的儿子约押及祭司亚比亚他商议，二人都答应支持他。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_8","012_1_8","1KI","1","8","8","不过，撒督祭司、耶何耶大的儿子比拿雅、拿单先知、示每、利以和大卫的勇士却没有跟随他。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_9","012_1_9","1KI","1","9","9","一天，亚多尼雅在隐·罗结附近的琐希列磐石那里宰了牛羊和肥牛犊献祭，并邀请了众王子和犹大的群臣。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_10","012_1_10","1KI","1","10","10","可是他没有邀请拿单先知、比拿雅、大卫的勇士和他的兄弟所罗门。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_11","012_1_11","1KI","1","11","11","拿单对所罗门的母亲拔示巴说：“你没有听说吗？哈及的儿子亚多尼雅做王了，我们的主大卫还不知道。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_12","012_1_12","1KI","1","12","12","事到如今，我有一个主意，可以保住你和你儿子所罗门的性命。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_13","012_1_13","1KI","1","13","13","你去见大卫王，对他说，‘我主我王啊，你不是起誓说让臣妾的儿子所罗门继承王位，坐你的宝座吗？怎么现在亚多尼雅做了王呢？’ ");
INSERT INTO cmncbs_vpl VALUES ("K11_14","012_1_14","1KI","1","14","14","你跟王还在说话的时候，我会进去证实你的话。” ");
INSERT INTO cmncbs_vpl VALUES ("K11_15","012_1_15","1KI","1","15","15","拔示巴就进内室去见年迈的王，书念的少女雅比莎正在伺候他。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_16","012_1_16","1KI","1","16","16","拔示巴向王屈身下拜。王问道：“你有什么事吗？” ");
INSERT INTO cmncbs_vpl VALUES ("K11_17","012_1_17","1KI","1","17","17","拔示巴回答说：“我主啊，你曾经凭你的上帝耶和华起誓说让臣妾的儿子所罗门继承你的王位，坐你的宝座。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_18","012_1_18","1KI","1","18","18","但现在亚多尼雅已经称王了，我主我王还不知道。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_19","012_1_19","1KI","1","19","19","他宰了许多牛羊和肥牛犊献祭，邀请众王子、亚比亚他祭司和约押元帅，却没有邀请你的仆人所罗门。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_20","012_1_20","1KI","1","20","20","我主我王啊！以色列举国拭目以待，等你来指定谁坐在我主我王的宝座上继承王位。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_21","012_1_21","1KI","1","21","21","不然，到我主我王与祖先同眠之后，我和我儿所罗门必被定为罪人。” ");
INSERT INTO cmncbs_vpl VALUES ("K11_22","012_1_22","1KI","1","22","22","她与王正说话间，拿单先知进宫来了。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_23","012_1_23","1KI","1","23","23","有人奏告王，说：“拿单先知来了。”拿单来到王面前，俯伏在地， ");
INSERT INTO cmncbs_vpl VALUES ("K11_24","012_1_24","1KI","1","24","24","说：“我主我王啊，你已经宣布让亚多尼雅继承你的王位，坐你的宝座吗？ ");
INSERT INTO cmncbs_vpl VALUES ("K11_25","012_1_25","1KI","1","25","25","他今天宰了许多牛羊和肥犊献祭，宴请众王子、将领和亚比亚他祭司，他们正在他那里一边吃喝一边说，‘亚多尼雅王万岁！’ ");
INSERT INTO cmncbs_vpl VALUES ("K11_26","012_1_26","1KI","1","26","26","但他没有邀请臣仆我、撒督祭司、耶何耶大的儿子比拿雅和你的仆人所罗门。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_27","012_1_27","1KI","1","27","27","这是我主我王的旨意吗？王还没有对臣仆们说过谁坐在我主我王的宝座上继承王位。” ");
INSERT INTO cmncbs_vpl VALUES ("K11_28","012_1_28","1KI","1","28","28","于是，大卫王召见拔示巴。拔示巴立刻晋见，侍立在王面前。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_29","012_1_29","1KI","1","29","29","王起誓说：“我凭救我脱离一切苦难的永活的耶和华起誓， ");
INSERT INTO cmncbs_vpl VALUES ("K11_30","012_1_30","1KI","1","30","30","我今天必实现我凭以色列的上帝耶和华向你起的誓。你的儿子所罗门必继承王位，坐在我的宝座上。” ");
INSERT INTO cmncbs_vpl VALUES ("K11_31","012_1_31","1KI","1","31","31","拔示巴就向王俯伏下拜说：“我主大卫王万岁！” ");
INSERT INTO cmncbs_vpl VALUES ("K11_32","012_1_32","1KI","1","32","32","大卫王又召见撒督祭司、拿单先知和耶何耶大的儿子比拿雅。他们都来到王面前。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_33","012_1_33","1KI","1","33","33","王嘱咐道：“你们要率领我的随从，让我儿所罗门骑上我的骡子，护送他下到基训。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_34","012_1_34","1KI","1","34","34","撒督祭司和拿单先知要在那里膏立他为以色列王。你们要吹响号角，高喊，‘所罗门王万岁！’ ");
INSERT INTO cmncbs_vpl VALUES ("K11_35","012_1_35","1KI","1","35","35","然后，你们要随他回来，他要登基，继承我的王位。我已立他做以色列和犹大的君王了。” ");
INSERT INTO cmncbs_vpl VALUES ("K11_36","012_1_36","1KI","1","36","36","耶何耶大的儿子比拿雅说：“遵命！愿我主我王的上帝耶和华成全这事。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_37","012_1_37","1KI","1","37","37","耶和华怎样与我主我王同在，愿祂也照样与所罗门同在，使他的王权比我主大卫王的更强大。” ");
INSERT INTO cmncbs_vpl VALUES ("K11_38","012_1_38","1KI","1","38","38","于是，撒督祭司、拿单先知、耶何耶大的儿子比拿雅，以及基利提人和比利提人请所罗门骑上大卫王的骡子，护送他前往基训。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_39","012_1_39","1KI","1","39","39","撒督祭司从圣幕里拿来盛膏油的角，膏立所罗门为王。他们吹响号角，民众高声欢呼：“所罗门王万岁！” ");
INSERT INTO cmncbs_vpl VALUES ("K11_40","012_1_40","1KI","1","40","40","众人浩浩荡荡地随着所罗门回京，一路上吹笛欢呼，声音震动大地。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_41","012_1_41","1KI","1","41","41","亚多尼雅和他的众宾客刚刚饮宴完毕，听见了这声音。约押听见号角声，便问：“城里为什么如此喧闹？” ");
INSERT INTO cmncbs_vpl VALUES ("K11_42","012_1_42","1KI","1","42","42","就在这时候，亚比亚他祭司的儿子约拿单来了，亚多尼雅说：“进来！你是个忠勇的人，一定带来了好消息。” ");
INSERT INTO cmncbs_vpl VALUES ("K11_43","012_1_43","1KI","1","43","43","约拿单说：“我们的主大卫王已经立所罗门为王了。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_44","012_1_44","1KI","1","44","44","王派撒督祭司、拿单先知、耶何耶大的儿子比拿雅，以及基利提人和比利提人护送所罗门骑上王的骡子。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_45","012_1_45","1KI","1","45","45","撒督祭司和拿单先知在基训膏立他为王，他们一路上欢呼着回来了，全城轰动。你们听到的就是他们的声音。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_46","012_1_46","1KI","1","46","46","所罗门已经登基掌权， ");
INSERT INTO cmncbs_vpl VALUES ("K11_47","012_1_47","1KI","1","47","47","王的臣仆也来向我们的主大卫王道喜说，‘愿你的上帝使所罗门比你名声更大，使他的王权比你的更强大。’王在床上俯伏敬拜， ");
INSERT INTO cmncbs_vpl VALUES ("K11_48","012_1_48","1KI","1","48","48","说，‘以色列的上帝耶和华当受称颂，因为祂让我亲眼看见我的继承人今天登基。’” ");
INSERT INTO cmncbs_vpl VALUES ("K11_49","012_1_49","1KI","1","49","49","亚多尼雅的众宾客听后，吓得四散而去。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_50","012_1_50","1KI","1","50","50","亚多尼雅惧怕所罗门，就去抓住祭坛的角。 ");
INSERT INTO cmncbs_vpl VALUES ("K11_51","012_1_51","1KI","1","51","51","有人告诉所罗门：“亚多尼雅惧怕王，现在正抓住祭坛的角，要王今天起誓不要杀他。” ");
INSERT INTO cmncbs_vpl VALUES ("K11_52","012_1_52","1KI","1","52","52","所罗门说：“他若做个忠义的人，必毫发无损；他若作恶，必死无疑。” ");
INSERT INTO cmncbs_vpl VALUES ("K11_53","012_1_53","1KI","1","53","53","于是，所罗门王便派人去把亚多尼雅从祭坛上带下来。亚多尼雅前来向所罗门王俯伏下拜，所罗门对他说：“你回家去吧。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","大卫临终时，叮嘱他儿子所罗门说： ");
INSERT INTO cmncbs_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","“我要走世人都必走的那条路了。你要刚强，做大丈夫。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","你要遵从你的上帝耶和华的吩咐，遵行祂的道，照摩西的律法遵守上帝的律例、诫命、典章和法度。这样，你无论做什么、去哪里都必亨通， ");
INSERT INTO cmncbs_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","耶和华必成就给我的应许，祂对我说，‘如果你的子孙谨慎自守，全心全意地在我面前尽忠，你的以色列王朝必世代相传。’ ");
INSERT INTO cmncbs_vpl VALUES ("K12_5","012_2_5","1KI","2","5","5","“你知道洗鲁雅的儿子约押怎样对我，他杀了以色列的两名元帅尼珥的儿子押尼珥和益帖的儿子亚玛撒。他在太平的时候把他们当作战场的敌手杀害，腰带和鞋上沾满了他们的血。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_6","012_2_6","1KI","2","6","6","你要用智慧处置他，不可让他安享天年。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_7","012_2_7","1KI","2","7","7","“你要恩待基列人巴西莱的众子，让他们成为你的座上宾，因为我逃避你哥哥押沙龙的时候，他们曾接待我。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_8","012_2_8","1KI","2","8","8","“别放过巴户琳的便雅悯人基拉的儿子示每。我逃亡到玛哈念的时候，他曾用恶毒的话咒骂我。后来他到约旦河迎接我的时候，我曾凭耶和华起誓不杀他。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_9","012_2_9","1KI","2","9","9","但你不要放过他。你是个聪明人，知道该怎样处置他。你要让他白头落地，不得善终。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","大卫与祖先同眠后，葬在大卫城。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","他统治以色列四十年，他在希伯仑执政七年，在耶路撒冷执政三十三年。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","所罗门继承大卫的王位，江山稳固。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_13","012_2_13","1KI","2","13","13","一天，哈及的儿子亚多尼雅来见所罗门的母亲拔示巴，拔示巴问他：“你是为平安而来吗？”亚多尼雅说：“是为平安而来。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_14","012_2_14","1KI","2","14","14","又说：“我有事禀告。”拔示巴说：“你说吧。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_15","012_2_15","1KI","2","15","15","亚多尼雅说：“你知道，王位本该是我的，整个以色列原指望我做王。不料，王位归了我兄弟，因为这是上帝的旨意。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_16","012_2_16","1KI","2","16","16","现在我有一个请求，请你不要推辞。”拔示巴说：“你说吧。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_17","012_2_17","1KI","2","17","17","他说：“请你求所罗门王将那书念女子雅比莎赐我为妻，他不会拒绝你。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_18","012_2_18","1KI","2","18","18","拔示巴说：“好吧，我会为你向王请求。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_19","012_2_19","1KI","2","19","19","拔示巴就为亚多尼雅的事去见所罗门王，王离座迎接，向她下拜，然后坐回位上，命人在自己右边为她摆设座位。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_20","012_2_20","1KI","2","20","20","拔示巴说：“我有一件小事求你，请你不要推辞。”王说：“母亲请说，我必不推辞。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_21","012_2_21","1KI","2","21","21","拔示巴说：“请将书念女子雅比莎赐给你哥哥亚多尼雅为妻。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_22","012_2_22","1KI","2","22","22","所罗门王回答说：“为何只为亚多尼雅求书念女子雅比莎呢？你也为他求这国家吧！他是我哥哥，又有亚比亚他祭司和洗鲁雅的儿子约押支持。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_23","012_2_23","1KI","2","23","23","所罗门王就凭耶和华起誓说：“亚多尼雅若不为他这样的要求付出性命，愿上帝重重地惩罚我。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_24","012_2_24","1KI","2","24","24","耶和华让我稳稳地坐在父亲大卫的宝座上，照祂的应许为我建立了王朝，我凭永活的耶和华起誓，亚多尼雅今天必被处死。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_25","012_2_25","1KI","2","25","25","于是，所罗门王命令耶何耶大的儿子比拿雅杀死亚多尼雅。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_26","012_2_26","1KI","2","26","26","王对亚比亚他祭司说：“你回亚拿突的老家去吧。你本是该死的，但我念你在我父大卫面前抬过主耶和华的约柜，曾经与我父亲患难与共，才饶你一命。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_27","012_2_27","1KI","2","27","27","所罗门就罢免了亚比亚他的职位，不许他再做耶和华的祭司。这事应验了耶和华在示罗所说的有关以利家的预言。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_28","012_2_28","1KI","2","28","28","约押虽然没有支持押沙龙，但却支持了亚多尼雅。他听见风声，就逃进圣幕，抓住祭坛的角。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_29","012_2_29","1KI","2","29","29","有人把这消息告诉所罗门王，说约押已经逃进圣幕，躲在祭坛旁边。所罗门就派耶何耶大的儿子比拿雅去杀他。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_30","012_2_30","1KI","2","30","30","比拿雅来到耶和华的圣幕，对约押说：“王吩咐你出来！”约押却回答说：“不，我要死在这里。”比拿雅回去禀告王。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_31","012_2_31","1KI","2","31","31","王说：“你就照他的话成全他，埋葬他，把他滥杀无辜的罪从我和我父亲家清除。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_32","012_2_32","1KI","2","32","32","耶和华要让他血债血还。因为他背着我父亲杀了两名比他良善正直的人，即尼珥的儿子以色列元帅押尼珥和益帖的儿子犹大元帅亚玛撒。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_33","012_2_33","1KI","2","33","33","所以，杀这二人的血债必永远归到约押和他后代身上。愿耶和华的平安永远伴随大卫和他的后代、他的家、他的王位。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_34","012_2_34","1KI","2","34","34","耶何耶大的儿子比拿雅就去把约押杀死，葬在旷野约押自己的墓地。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_35","012_2_35","1KI","2","35","35","王委派耶何耶大的儿子比拿雅替代约押为元帅，命撒督祭司代替亚比亚他。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_36","012_2_36","1KI","2","36","36","王又派人将示每召来，对他说：“你要在耶路撒冷建屋居住，不得出城去其他地方。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_37","012_2_37","1KI","2","37","37","你哪天越过汲沦溪，哪天必死无疑，你的死是咎由自取。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_38","012_2_38","1KI","2","38","38","示每说：“好，仆人必照我主我王说的做。”示每就一直住在耶路撒冷。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_39","012_2_39","1KI","2","39","39","过了三年，示每的两个仆人逃到迦特王玛迦的儿子亚吉那里。示每知道后， ");
INSERT INTO cmncbs_vpl VALUES ("K12_40","012_2_40","1KI","2","40","40","就备上驴到迦特的亚吉那里找他的仆人，并把他们带了回来。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_41","012_2_41","1KI","2","41","41","所罗门听说示每从耶路撒冷前往迦特，已经返回， ");
INSERT INTO cmncbs_vpl VALUES ("K12_42","012_2_42","1KI","2","42","42","就派人召来示每，问道：“我不是叫你凭耶和华起誓不离开耶路撒冷吗？我警告过你，你哪天离开这里，哪天必死无疑。当时你也同意。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_43","012_2_43","1KI","2","43","43","现在你为何不守你向耶和华起的誓，不遵行我的命令？” ");
INSERT INTO cmncbs_vpl VALUES ("K12_44","012_2_44","1KI","2","44","44","王又说：“你以前如何恶待我父大卫，你自己心里明白，现在耶和华要追究你的罪行了。 ");
INSERT INTO cmncbs_vpl VALUES ("K12_45","012_2_45","1KI","2","45","45","但所罗门王必蒙祝福，大卫的王位必在耶和华面前必永远稳固。” ");
INSERT INTO cmncbs_vpl VALUES ("K12_46","012_2_46","1KI","2","46","46","于是，王命令耶何耶大的儿子比拿雅杀死示每。这样所罗门的江山得以稳固。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_1","012_3_1","1KI","3","1","1","所罗门娶了埃及法老的女儿，与法老联姻。他在自己的王宫、耶和华的殿和耶路撒冷的城墙完工之前，让她一直住在大卫城。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_2","012_3_2","1KI","3","2","2","那时候，用来尊崇耶和华之名的殿还没有建成，以色列人仍然在丘坛献祭。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","所罗门爱耶和华，遵行他父亲大卫的律例，只是仍然在丘坛献祭烧香。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","有一次，所罗门王上基遍献了一千头祭牲作燔祭，因为那里有最重要的丘坛。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","在基遍，耶和华晚上在梦中向所罗门显现，对他说：“你想要什么，只管向我求。” ");
INSERT INTO cmncbs_vpl VALUES ("K13_6","012_3_6","1KI","3","6","6","所罗门说：“你的仆人——我父大卫本着诚实、公义、正直的心在你面前行事，你就向他大施恩慈，并且一如既往地以厚恩待他，让他儿子今天继承他的王位。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","我的上帝耶和华啊，你让仆人继承我父大卫的王位，但仆人还年幼无知，不懂得如何治理国家。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","仆人住在你所拣选的子民中，这些子民多得不可胜数。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","求你赐我智慧治理你的子民，并能辨别是非；不然，谁能治理你这众多的子民呢？” ");
INSERT INTO cmncbs_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","主喜悦所罗门的祈求， ");
INSERT INTO cmncbs_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","对他说：“既然你不为自己求寿、求财富，也不求灭绝仇敌，只求有智慧秉公治理我的子民， ");
INSERT INTO cmncbs_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","我必应允你，赐给你空前绝后的智慧和悟性。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","你没有求富贵和尊荣，但我会一并赐给你，使你有生之年在列王中无人能比。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","你若像你父亲大卫一样遵行我的道，遵守我的律例和诫命，我必使你长寿。” ");
INSERT INTO cmncbs_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","所罗门醒来，发现是做了一个梦。他回到耶路撒冷，站在耶和华的约柜前献上燔祭和平安祭，又宴请群臣。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","一天，两个妓女到王面前告状。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","其中一个说：“我主啊，我跟这女人同住，我生了一个男孩，当时她也在场。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","我生产三天后，她也生了一个男孩。我们住在一起，除了我们二人，屋里没有别人。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","一天晚上，她不小心压死了自己的孩子。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","她半夜起来，趁我熟睡的时候抱走了我身边的孩子，放在她怀中，把她的死孩子放在我怀中。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","天快亮的时候，我起来给孩子喂奶，发现孩子死了。天亮后，我仔细察看孩子，发现孩子不是我生的。” ");
INSERT INTO cmncbs_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","另一个女人说：“不对！活孩子是我的，死孩子是你的。”第一个女人说：“不对！死孩子是你的，活孩子是我的。”两个女人在王面前争吵起来。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","王见她们二人都说活孩子是自己的，死孩子是对方的， ");
INSERT INTO cmncbs_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","就命人拿刀来。侍从把刀拿来后， ");
INSERT INTO cmncbs_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","王下令将那活孩子劈成两半，让她们各得一半。 ");
INSERT INTO cmncbs_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","活孩子的母亲心疼自己的孩子，就说：“我主啊，把孩子给她吧，千万不要杀他！”但另一个女人却说：“孩子不归我，也不归你，把他劈开吧！” ");
INSERT INTO cmncbs_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","王说：“不可杀这孩子，把他交给刚才为孩子求情的女人吧！她是孩子的母亲。” ");
INSERT INTO cmncbs_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","以色列人听见王这样断案，都敬畏他，因为他们知道他有上帝所赐的智慧，能够秉公断案。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_1","012_4_1","1KI","4","1","1","所罗门王统治以色列， ");
INSERT INTO cmncbs_vpl VALUES ("K14_2","012_4_2","1KI","4","2","2","以下是他的众臣仆：撒督的儿子亚撒利雅做祭司； ");
INSERT INTO cmncbs_vpl VALUES ("K14_3","012_4_3","1KI","4","3","3","示沙的儿子以利何烈和亚希亚做书记；亚希律的儿子约沙法做史官； ");
INSERT INTO cmncbs_vpl VALUES ("K14_4","012_4_4","1KI","4","4","4","耶何耶大的儿子比拿雅做元帅；撒督和亚比亚他做祭司长； ");
INSERT INTO cmncbs_vpl VALUES ("K14_5","012_4_5","1KI","4","5","5","拿单的儿子亚撒利雅掌管吏部；拿单的儿子撒布得祭司做所罗门王的顾问； ");
INSERT INTO cmncbs_vpl VALUES ("K14_6","012_4_6","1KI","4","6","6","亚希煞总管宫廷事务；亚比大的儿子亚多尼兰总管做劳役的。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_7","012_4_7","1KI","4","7","7","所罗门在以色列全国设立了十二个地方官，负责供给王及王室的需用，每年每人负责一个月。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_8","012_4_8","1KI","4","8","8","这十二个地方官是：便·户珥，负责以法莲山区； ");
INSERT INTO cmncbs_vpl VALUES ("K14_9","012_4_9","1KI","4","9","9","便·底甲，负责玛迦斯、沙宾、伯·示麦、以伦·伯·哈南； ");
INSERT INTO cmncbs_vpl VALUES ("K14_10","012_4_10","1KI","4","10","10","便·希悉，负责亚鲁泊，包括梭哥和希弗全境； ");
INSERT INTO cmncbs_vpl VALUES ("K14_11","012_4_11","1KI","4","11","11","所罗门女儿她法的丈夫便·亚比拿达，负责多珥高原； ");
INSERT INTO cmncbs_vpl VALUES ("K14_12","012_4_12","1KI","4","12","12","亚希律的儿子巴拿，负责他纳和米吉多，靠近撒拉他拿、耶斯列下边的伯·善全境，以及从伯·善到亚伯·米何拉，远至约缅； ");
INSERT INTO cmncbs_vpl VALUES ("K14_13","012_4_13","1KI","4","13","13","便·基别，负责基列的拉末和玛拿西子孙雅珥在基列的城邑，以及巴珊的亚珥歌伯地区有城墙和铜闩的大城六十座； ");
INSERT INTO cmncbs_vpl VALUES ("K14_14","012_4_14","1KI","4","14","14","易多的儿子亚希拿达，负责玛哈念； ");
INSERT INTO cmncbs_vpl VALUES ("K14_15","012_4_15","1KI","4","15","15","所罗门的另一个女儿巴实抹的丈夫亚希玛斯，负责拿弗他利； ");
INSERT INTO cmncbs_vpl VALUES ("K14_16","012_4_16","1KI","4","16","16","户筛的儿子巴拿，负责亚设和亚禄； ");
INSERT INTO cmncbs_vpl VALUES ("K14_17","012_4_17","1KI","4","17","17","帕路亚的儿子约沙法，负责以萨迦； ");
INSERT INTO cmncbs_vpl VALUES ("K14_18","012_4_18","1KI","4","18","18","以拉的儿子示每，负责便雅悯； ");
INSERT INTO cmncbs_vpl VALUES ("K14_19","012_4_19","1KI","4","19","19","乌利的儿子基别，独自负责从前属亚摩利王西宏和巴珊王噩的基列地区。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","犹大人和以色列人多如海沙，丰衣足食，生活幸福。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_21","012_4_21","1KI","4","21","21","所罗门统管列国，从幼发拉底河至非利士，直到埃及边界。所罗门在世的日子，列国都年年进贡称臣。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_22","012_4_22","1KI","4","22","22","所罗门每天的膳食用三千公斤细面粉、六千公斤粗面粉、 ");
INSERT INTO cmncbs_vpl VALUES ("K14_23","012_4_23","1KI","4","23","23","十头肥牛、二十头草场的牛、一百只羊，此外还有鹿、羚羊、狍子及肥禽。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_24","012_4_24","1KI","4","24","24","所罗门统治幼发拉底河西面所有的国家，从提弗萨直到迦萨，四境安宁。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_25","012_4_25","1KI","4","25","25","所罗门在世的时候，从但到别示巴的犹大人和以色列人都在自己的葡萄树和无花果树下安居。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_26","012_4_26","1KI","4","26","26","所罗门有四万个安置拉战车马匹的马厩和一万二千名骑兵。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_27","012_4_27","1KI","4","27","27","十二个地方官按月供给所罗门王及王室的需用，使他们一无所缺。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_28","012_4_28","1KI","4","28","28","他们也各按其份提供喂战车马等马匹用的大麦和干草。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_29","012_4_29","1KI","4","29","29","上帝赐予所罗门极大的智慧和悟性，以及如海边的沙一样浩博的学识。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_30","012_4_30","1KI","4","30","30","他的智慧高过东方人和埃及人的一切智慧， ");
INSERT INTO cmncbs_vpl VALUES ("K14_31","012_4_31","1KI","4","31","31","无人能比，胜过以斯拉人以探和玛曷的儿子希幔、甲各、达大的智慧。他名扬四周列国。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_32","012_4_32","1KI","4","32","32","所罗门写下箴言三千句，作诗歌一千零五首。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_33","012_4_33","1KI","4","33","33","他对飞禽走兽、草木鱼虫，从黎巴嫩的香柏树到长在墙上的牛膝草，都无所不知。 ");
INSERT INTO cmncbs_vpl VALUES ("K14_34","012_4_34","1KI","4","34","34","天下列王风闻所罗门的智慧，都纷纷遣使来求教。 ");
INSERT INTO cmncbs_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","泰尔王希兰素来与大卫修好，他听说以色列人膏立了所罗门继承大卫的王位，就派使者来见所罗门。 ");
INSERT INTO cmncbs_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","所罗门也传信给希兰，说： ");
INSERT INTO cmncbs_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","“你知道，我父大卫因周围战事连连，未能为他的上帝耶和华的名建殿，要等到耶和华使仇敌伏在他脚下后再建。 ");
INSERT INTO cmncbs_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","现在我的上帝耶和华使我四境太平，内外无患， ");
INSERT INTO cmncbs_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","我想为我的上帝耶和华建殿，因为耶和华曾对我父大卫说，‘我必使你的儿子继承你的王位，他必为我的名建殿。’ ");
INSERT INTO cmncbs_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","请你命人为我砍伐黎巴嫩的香柏木。我会派人帮助你的人，并按你的要求付你的人工钱。因为你知道，我们没有人像西顿人那样善于砍伐树木。” ");
INSERT INTO cmncbs_vpl VALUES ("K15_7","012_5_7","1KI","5","7","7","希兰听了所罗门的话后，非常高兴，说：“今天当赞美耶和华！祂赐给大卫一个有智慧的儿子治理这伟大的民族。” ");
INSERT INTO cmncbs_vpl VALUES ("K15_8","012_5_8","1KI","5","8","8","他派人回复所罗门说：“我已收到你派人带来的口信。我一定会照你的心愿提供香柏木和松木。 ");
INSERT INTO cmncbs_vpl VALUES ("K15_9","012_5_9","1KI","5","9","9","我的工人会将这些木料从黎巴嫩运到海边，扎成木筏，经海道运到你指定的地点。木筏拆散以后，你就可以点收了。你也要成全我的心愿，供应我家食粮。” ");
INSERT INTO cmncbs_vpl VALUES ("K15_10","012_5_10","1KI","5","10","10","于是，希兰供应所罗门需用的香柏木和松木， ");
INSERT INTO cmncbs_vpl VALUES ("K15_11","012_5_11","1KI","5","11","11","所罗门每年供应希兰四百四十万升麦子和四十四万升橄榄油。 ");
INSERT INTO cmncbs_vpl VALUES ("K15_12","012_5_12","1KI","5","12","12","耶和华照着应许赐给所罗门智慧。他跟希兰修好，缔结盟约。 ");
INSERT INTO cmncbs_vpl VALUES ("K15_13","012_5_13","1KI","5","13","13","所罗门王从以色列征集了三万劳工， ");
INSERT INTO cmncbs_vpl VALUES ("K15_14","012_5_14","1KI","5","14","14","派他们每月轮班到黎巴嫩工作，每班一万人，在黎巴嫩一个月，在家两个月。亚多尼兰做他们的总管。 ");
INSERT INTO cmncbs_vpl VALUES ("K15_15","012_5_15","1KI","5","15","15","所罗门又征用了七万名搬运工，八万名在山上凿石的匠人。 ");
INSERT INTO cmncbs_vpl VALUES ("K15_16","012_5_16","1KI","5","16","16","此外，他还派了三千三百名监工，监督工人做工。 ");
INSERT INTO cmncbs_vpl VALUES ("K15_17","012_5_17","1KI","5","17","17","他们按照王的命令在山上凿出珍贵的巨石，用来作殿的根基。 ");
INSERT INTO cmncbs_vpl VALUES ("K15_18","012_5_18","1KI","5","18","18","于是，所罗门和希兰的工匠及迦巴勒人凿好石头，备好木料，准备建殿。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","所罗门在做以色列王的第四年二月，即西弗月，开始为耶和华建殿。那时正是以色列人离开埃及后第四百八十年。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_2","012_6_2","1KI","6","2","2","所罗门王为耶和华建造的殿长二十七米，宽九米，高十三米半。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_3","012_6_3","1KI","6","3","3","殿前的门廊和殿一样宽九米，进深四米半。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_4","012_6_4","1KI","6","4","4","殿有格子窗户。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_5","012_6_5","1KI","6","5","5","靠殿墙、围着外殿和内殿又造了三层厢房， ");
INSERT INTO cmncbs_vpl VALUES ("K16_6","012_6_6","1KI","6","6","6","底层宽两米二，中层宽两米七，上层宽三米一。厢房的横梁都搭在殿墙突出的地方，免得插入殿墙。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_7","012_6_7","1KI","6","7","7","建殿的石头都在采石场凿好了，建殿的时候听不到锤子、斧头或其他铁器的响声。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_8","012_6_8","1KI","6","8","8","底层厢房的进口在殿的南面，沿着一道螺旋楼梯可以通到第二层和第三层。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_9","012_6_9","1KI","6","9","9","殿建成后，殿顶装上香柏木的梁木和木板。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_10","012_6_10","1KI","6","10","10","靠着殿墙所造的厢房每一层高两米二，用香柏木的梁木与殿墙接连起来。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","耶和华对所罗门说： ");
INSERT INTO cmncbs_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","“关于你所建的这殿，若你遵行我的律例，顺从我的典章，谨守我的一切诫命，我必实现我对你父亲大卫的应许。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","我必住在以色列人当中，不抛弃我的以色列子民。” ");
INSERT INTO cmncbs_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","所罗门建造的殿落成了。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_15","012_6_15","1KI","6","15","15","殿里的墙壁和天花板都铺上了香柏木，地面都铺上了松木板。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_16","012_6_16","1KI","6","16","16","在殿的后部，从地面至天花板用香柏木板隔出长九米的内殿，就是至圣所。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_17","012_6_17","1KI","6","17","17","在至圣所外面是外殿，长十八米。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_18","012_6_18","1KI","6","18","18","殿内全部铺上香柏木，不露一点石头，香柏木上刻着野瓜和花朵的图案。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_19","012_6_19","1KI","6","19","19","殿的至圣所用来安放耶和华的约柜。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_20","012_6_20","1KI","6","20","20","至圣所长、宽和高都是九米，里面全贴上纯金，香柏木造的祭坛也包上纯金。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_21","012_6_21","1KI","6","21","21","殿内全部贴上纯金，至圣所前面有金链拦着，至圣所内也都贴上纯金。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_22","012_6_22","1KI","6","22","22","殿内都贴上纯金，至圣所内的祭坛也都包上纯金。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_23","012_6_23","1KI","6","23","23","至圣所里面放着两个橄榄木造的基路伯天使，各高四米半， ");
INSERT INTO cmncbs_vpl VALUES ("K16_24","012_6_24","1KI","6","24","24","各有两个两米二长的翅膀，双翅展开，两翅尖相距四米半。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_25","012_6_25","1KI","6","25","25","两个基路伯的大小和形状一模一样， ");
INSERT INTO cmncbs_vpl VALUES ("K16_26","012_6_26","1KI","6","26","26","高度都是四米半。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_27","012_6_27","1KI","6","27","27","他将两个基路伯安在至圣所内，两个基路伯展开翅膀，各有一个翅膀在至圣所的中央相接，另一个翅膀的尖端触到墙壁。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_28","012_6_28","1KI","6","28","28","这两个基路伯天使也包上金。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_29","012_6_29","1KI","6","29","29","内殿和外殿的墙壁都刻上基路伯天使、棕树和花朵的图案， ");
INSERT INTO cmncbs_vpl VALUES ("K16_30","012_6_30","1KI","6","30","30","地板是铺金的。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_31","012_6_31","1KI","6","31","31","至圣所的门、门楣和门柱都是橄榄木造的，门柱呈五角形。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_32","012_6_32","1KI","6","32","32","两扇用橄榄木造的门上都刻着基路伯天使、棕树和花朵的图案，并包上金。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_33","012_6_33","1KI","6","33","33","外殿的四角形门柱也是用橄榄木造的， ");
INSERT INTO cmncbs_vpl VALUES ("K16_34","012_6_34","1KI","6","34","34","两扇门是松木造的，每一扇门都分为可折叠的两片， ");
INSERT INTO cmncbs_vpl VALUES ("K16_35","012_6_35","1KI","6","35","35","上面刻着基路伯天使、棕树和花朵的图案，并均匀地包上金。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_36","012_6_36","1KI","6","36","36","内院的墙是由三层凿好的石头和一层香柏木建的。 ");
INSERT INTO cmncbs_vpl VALUES ("K16_37","012_6_37","1KI","6","37","37","耶和华的殿在所罗门执政第四年的西弗月奠基， ");
INSERT INTO cmncbs_vpl VALUES ("K16_38","012_6_38","1KI","6","38","38","在他执政的第十一年的布勒月，即八月全部按规格建成，历经七年。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_1","012_7_1","1KI","7","1","1","所罗门用了十三年的时间为自己兴建王宫。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_2","012_7_2","1KI","7","2","2","他建造的黎巴嫩林宫长四十五米，宽二十二米半，高十三米半，有四行香柏木柱，柱子支撑着香柏木横梁。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_3","012_7_3","1KI","7","3","3","每一行木柱有十五根，共四十五根。殿顶铺香柏木板。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_4","012_7_4","1KI","7","4","4","宫殿有三排窗户，窗与窗相对； ");
INSERT INTO cmncbs_vpl VALUES ("K17_5","012_7_5","1KI","7","5","5","宫殿的门框和窗户都是方形的，三排窗户彼此相对。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_6","012_7_6","1KI","7","6","6","他又建了一座有柱子的廊子，长二十二米半，宽十三米半，前面还有带柱子的门廊和篷子。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_7","012_7_7","1KI","7","7","7","此外，他又建造了一个判案的公堂。堂内从地板到天花板都铺上了香柏木。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_8","012_7_8","1KI","7","8","8","所罗门的寝宫就在公堂后面的院内，建筑样式和公堂相同。所罗门又为所娶的法老之女造了一座与公堂相同的宫室。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_9","012_7_9","1KI","7","9","9","这些宫殿，从根基到墙顶，从外院到内殿用的都是上等的石头，按规格里外用锯切割整齐。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_10","012_7_10","1KI","7","10","10","根基用的是非常珍贵的石头，它们的体积巨大，有些甚至是长达三米半至四米半的巨石， ");
INSERT INTO cmncbs_vpl VALUES ("K17_11","012_7_11","1KI","7","11","11","上面是按照规格凿好的上等石头以及香柏木。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_12","012_7_12","1KI","7","12","12","大院周围的墙由三层凿好的石头和一层香柏木建成，正如耶和华殿的内院和殿廊的墙。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_13","012_7_13","1KI","7","13","13","所罗门王派人从泰尔把户兰召来。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_14","012_7_14","1KI","7","14","14","户兰是拿弗他利支派一个寡妇的儿子，父亲是泰尔的铜匠。户兰聪明伶俐，技术高超，擅长制造各种铜器。他前来朝见所罗门王，领命负责一切铜器工程。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_15","012_7_15","1KI","7","15","15","他铸造了两根铜柱，每根高八米，周长五米四， ");
INSERT INTO cmncbs_vpl VALUES ("K17_16","012_7_16","1KI","7","16","16","然后用铜铸造了两个高两米二的柱冠，安在柱顶上。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_17","012_7_17","1KI","7","17","17","每一个柱冠上装饰着七条链子织成的网， ");
INSERT INTO cmncbs_vpl VALUES ("K17_18","012_7_18","1KI","7","18","18","网周围环绕着两行石榴，用来遮盖柱冠。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_19","012_7_19","1KI","7","19","19","门廊的柱冠高一米八，形状像百合花。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_20","012_7_20","1KI","7","20","20","在每个柱冠靠近网子鼓起来的地方围着两行石榴，共二百个。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_21","012_7_21","1KI","7","21","21","他把两根柱子立在殿廊前，南边那根称为雅斤，北边那根称为波阿斯。 ");
INSERT INTO cmncbs_vpl VALUES ("K17_22","012_7_22","1KI","7","22","22","柱冠的形状像百合花。