﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmn2006_vpl;
CREATE TABLE cmn2006_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmn2006_vpl WRITE;
INSERT INTO cmn2006_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","太初，上帝创造了天地， ");
INSERT INTO cmn2006_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","大地一片混沌，空无一物，黑暗笼罩着渊面，上帝的灵在水面上运行。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","上帝说∶“要有光”， 光就出现了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","上帝看见光很好，就把光和黑暗分开。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","称光为“昼”，而称黑暗为“夜”。于是，就有了晨昏交替。这是第一天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","上帝说∶“在水之间要有穹苍把水分开。” ");
INSERT INTO cmn2006_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","于是，上帝造了穹苍，把水上下分开。一切就这样发生了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","上帝把穹苍叫作“天空”。晨昏交替，这是第二天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","上帝说∶“天下的水要聚集在一起，好让大地显露出来。”一切就这样发生了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","上帝把大地叫作“陆”，把聚集在一起的水叫作“海”。上帝看了，觉得很好。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","然后，上帝说∶“陆地上要生长各种各样的植物；果树要结有籽的果实，各种植物都要结籽。”于是，一切就这样完成了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","陆地上长出了各种各样的植物，有结种子的庄稼，有结果子的果树。上帝看了，觉得很好。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","晨昏交替，这是第三天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","上帝说∶“天空中要有光体来区分昼夜和作为划分时间和季节的标志， ");
INSERT INTO cmn2006_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","并且在天空中发光照亮大地。”于是，一切就这样完成了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","上帝造了两个大的光体，让其中较大的一个支配白天，另一个较小的支配黑夜。上帝又造了星星。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","上帝把这些光体（太阳，月亮，星星）安置在天空中，让它们照亮大地， ");
INSERT INTO cmn2006_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","支配昼夜，把光和黑暗分开。上帝看了，觉得很好。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","晨昏交替，这是第四天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","上帝说∶“水中要有众多的生物，空中要有飞鸟。” ");
INSERT INTO cmn2006_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","于是，上帝创造了巨大的海兽、各种各样的水生动物和各种各样的飞鸟。上帝看到那很好， ");
INSERT INTO cmn2006_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","就赐福给它们，让水生动物在水里繁殖，鸟在陆上衍生。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","晨昏交替，这是第五天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","上帝说∶“大地上要有各种各样的牲畜、爬虫和野兽。”于是，一切就这样发生了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","上帝创造了各种各样动物、牲畜和爬虫。上帝看了，觉得很好。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","上帝说∶“让我们照着自己的样子造人吧！让他们管理海里的鱼、空中的鸟和一切牲畜、野兽及爬虫。” ");
INSERT INTO cmn2006_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","于是，上帝按照自己的形象创造了人类，有男人，也有女人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","上帝赐福给他们，说∶“你们要生养众多的儿女，让他们遍布全世界，统治全世界，管理海中的鱼、空中的鸟以及大地上的所有走兽。” ");
INSERT INTO cmn2006_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","上帝又说∶“看哪，我把所有能结籽的作物和果实里有籽的果树都赐给了你们，你们可以由它们获得食物。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","我也把所有的绿色植物赐给所有的动物、飞鸟和爬虫当作食物。”于是，一切就这样发生了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","上帝看着他所创造的一切，觉得非常满意。晨昏交替，这是第六天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","天地和世间的万物就这样创造完毕。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","在第七天，上帝完成了创世的工作，休息了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","上帝赐福给第七天，规定这一天属他所有。他以这一天为圣日，以区别于其他日子，因为这一天是他完成创世的休息日。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","5","这就是主上帝创造天地的过程。主上帝创造世界的时候，大地上还没有草木丛林，因为主上帝还没有降雨，也没有人耕种土地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","但是，水从地下涌出，滋润着大地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","主上帝用地上的尘土造了一个“人”，然后，把生命之气吹入他的鼻孔，人就成了有生命的生物。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","接着，主上帝在东方造了伊甸园。把所造的人安置在里边。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","主上帝让地上长出各种各样美丽的树木，树上还结着美味可口的果子。生命之树和能使人分辨善恶的智慧之树长在园子的中间。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","一条河流过伊甸，灌溉着园子。这条河从那里分成四条支流流出去， ");
INSERT INTO cmn2006_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","一条叫比逊河，环绕哈腓拉全境， ");
INSERT INTO cmn2006_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","（那里出产上等的黄金、香料和宝石）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","第二条叫基训河，环绕古实全境。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","第三条叫底格里斯河，流经亚述东部。第四条叫幼发拉底河。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","主上帝把人带到伊甸园中，安置在那里，让他耕种和看守园子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","主上帝告诫那人，说∶“你可以随便吃园中所有树上的果子， ");
INSERT INTO cmn2006_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","但决不可以吃能辨别善恶的智慧之树的果子；一旦吃了你必死无疑。” ");
INSERT INTO cmn2006_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","主上帝又说∶“一个人独居不好，我要给他造个帮手作伴。” ");
INSERT INTO cmn2006_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","于是，主上帝用地上的尘土造了各种各样的飞禽走兽，把它们带到人的跟前，让人给它们起名字。人给每个动物起了名字；他开口叫它什么，它以后就叫什么名字，这个名字就定了下来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","他给牲畜和飞禽走兽都起了名，但是，没有一个适合作他的伴侣。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","于是，主上帝使人沉沉入睡。当他熟睡的时候，主上帝取下他的一根肋骨，然后再把皮肉重新合起来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","主上帝用这根从人身上取下的肋骨造了一个女人，把她带到人的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","这人说∶ “终于有了一个跟我一样的人！ 这是我的骨中骨，肉中肉； 她的骨由我而来，她的肉由我而来， 我要叫她‘女人’，因为她由男人而来。” ");
INSERT INTO cmn2006_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","因此，男人要离开自己的父母，与妻子相结合，成为一体。 ");
INSERT INTO cmn2006_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","那人和他的妻子都赤裸着身体，但他们并不感到羞耻。 ");
INSERT INTO cmn2006_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","蛇是主上帝所造的野兽中最狡猾的。 蛇问女人∶“上帝真的说过‘你们不可以吃园中任何树上的果子’了吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","女人对蛇说∶“我们可以吃园中任何树上的果子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","但是，上帝告诫过我们∶‘你们不能吃园子中间那棵树上的果子，甚至连碰也不能碰，否则，你们必死无疑。’” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","蛇对女人说∶“你们不一定会死吧！ ");
INSERT INTO cmn2006_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","上帝也知道，一旦你们吃了那棵树上的果子，你们的眼就会张开，你们就会变得象上帝一样能够区分善恶了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","女人看见那棵树上的果子又好吃又好看，还能给人智慧，就忍不住去摘了一些吃，还给了她丈夫一些，他也吃了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","吃完果子，他们的眼就开了，发现自己赤身露体；于是，他们把无花果树的叶子编在一起作缠腰布。 ");
INSERT INTO cmn2006_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","起凉风的时刻，他们听见主上帝在园中走动的声音，就躲开上帝，藏进园中的树丛之中。 ");
INSERT INTO cmn2006_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","主上帝唤出那人，说∶“你到哪里去了？” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","他回答说∶“我听见你在园中走动的声音，怕你看见我赤裸着身体，就躲了起来。” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","主上帝问∶“谁告诉你，你是赤裸着的呢？你是不是吃了我不许你们吃的果子？” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","那人答道∶“你赐给我作伴侣的那个女人给了我那棵树上的果子，我就吃了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","主上帝问那女人∶“你为什么要这样做呢？” 女人答道∶“是蛇引诱我，我就吃了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","主上帝对蛇说∶ “由于你作了这件事， 你要受到比所有的牲畜和野兽更多的诅咒。 你必须用肚皮爬行， 终生吃土。 ");
INSERT INTO cmn2006_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","你与女人彼此敌视， 你的后代与女人的后代也彼此敌视， 她的后代要踩你的头， 而你要咬他的脚后跟。” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","主上帝对女人说∶ “我要大大增加你怀孕的痛苦， 叫你分娩时伴随着剧烈的疼痛！ 你恋慕你的丈夫， 而你的丈夫要管辖着你。” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","主上帝对亚当说∶ “你听了你妻子的话， 偷吃了我告诫你不许吃的果子， 我将为你的缘故而诅咒土地， 你将终身劳苦才能由土地中得到你需要的粮食。 ");
INSERT INTO cmn2006_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","土地要长出荆棘杂草， 而你要吃田里的庄稼， ");
INSERT INTO cmn2006_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","你要汗流满面地劳作才能吃上饭， 直到死后归土， 因为你本来就是由尘土作成的， 所以你最终还要归于尘土。” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","亚当给他的妻子起名叫“夏娃”，因为她是全人类的母亲。 ");
INSERT INTO cmn2006_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","主上帝用兽皮作成衣服，给亚当和他的妻子穿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","接着，主上帝说∶“瞧，人类已经变得象我们一样能辨别善恶真假了，现在，他有可能去摘生命之树的果子吃，那他们就永生不死了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","于是，主上帝把亚当赶出了伊甸园，让他去耕种土地－而他就是由这地上的土造成的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","亚当和夏娃被逐出伊甸园之后，主上帝在伊甸园的东面安置了基路伯天使和发出火焰的四面转动的剑，守卫通向生命之树的道路。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","亚当与妻子夏娃同房，她怀了孕，生下了该隐。她说∶“由于主的帮助，我有了一个儿子。” ");
INSERT INTO cmn2006_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","后来，又生下了该隐的弟弟亚伯。亚伯是牧羊人，该隐是农夫。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","过了些日子，该隐带了些土产作祭物献给主， ");
INSERT INTO cmn2006_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","亚伯也带来了一些头胎生的羊的肥嫩的部位。主喜欢亚伯和他的祭物， ");
INSERT INTO cmn2006_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","却不喜欢该隐和他的祭物。为此，该隐既恼怒又悲伤。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","主对该隐说∶“你为什么要恼怒和悲伤呢？ ");
INSERT INTO cmn2006_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","你要是行事正当，我自然会接纳你；你要是行为失当，罪就潜伏在你的门前。罪要俘获你，而你一定要克服它。” ");
INSERT INTO cmn2006_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","该隐对他的弟弟亚伯说∶“我们到田野里去吧！”到了田里以后，该隐突然袭击他的弟弟亚伯，把他杀死了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","主问该隐∶“你的弟弟在哪里？”该隐答道∶“我不知道。难道我是负责照看我弟弟的吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","主说∶“你干了什么事？你弟弟的血从地下向我哭诉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","大地张开了口，吞下了从你手上流下的你弟弟的血，现在你受到大地的诅咒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","你耕种土地，土地却不再为你出产任何东西。你将无家可归，到处流浪。” ");
INSERT INTO cmn2006_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","该隐对主说∶“这惩罚太重了，我受不了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","你已经把我赶离了这块土地，我再见不到你了；我无家可归，四处流浪，见到我的人都会要杀我的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","主对他说∶“谁杀该隐，谁就要赔上七条命。”上帝在该隐身上作了记号，这样，遇到该隐的人就不会再杀他了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","于是，该隐离开了主，在伊甸东边名叫诺德的地方住了下来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","该隐与他的妻子同房，妻子怀孕，生下了以诺。该隐造了一座城，用他儿子以诺的名子给城命名。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","以诺的儿子叫以拿；以拿的儿子叫米户雅利；米户雅利的儿子叫玛土撒利；玛土撒利的儿子叫拉麦。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","拉麦娶了两个妻子，一个叫亚大，另一个叫洗拉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","亚大生了雅八，雅八是住帐篷牧养牲畜的人的祖先； ");
INSERT INTO cmn2006_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","雅八的弟弟叫犹八，犹八是弹琴吹笛人的祖师。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","洗拉生了土八该隐，土八该隐是制造铜铁利器的人的祖师。土八该隐的妹妹叫拿玛。 ");
INSERT INTO cmn2006_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","拉麦对他的两个妻子说∶ “亚大和洗拉，听我说！ 你们是我拉麦的妻子， 要仔细听我说的话。 我杀死了那伤害我的人， 杀死了那打伤我的少年； ");
INSERT INTO cmn2006_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","杀死该隐的人要赔上七条命， 而杀死我拉麦的人要赔上七十七条命！” ");
INSERT INTO cmn2006_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","亚当又与他的妻子同房，生下一个儿子，她给他起名叫塞特。她说∶“上帝又给了我一个儿子代替被该隐杀害的亚伯。” ");
INSERT INTO cmn2006_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","塞特生了一个儿子，起名叫以挪士。从这时起，人开始崇拜主。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","以下是亚当的家谱。上帝造人的时候是按照自己的形象造的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","他造了男人和女人。他赐福给他所造的人，并在创造人的那天把他命名为“亚当”。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","亚当130岁的时候生了一个儿子，跟他长得一模一样，起名叫塞特。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","亚当生了塞特以后又活了800年。在这期间，他又生了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","亚当死的时候是九百三十岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","塞特105岁的时候生了一个儿子，起名叫以挪士。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","塞特生了以挪士以后又活了807岁。在这期间，他又生了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","塞特死的时候是912岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","以挪士90岁的时候生了一个儿子，起名叫该南。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","以挪士生了该南以后又活了815岁。在这期间，他又生了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","以挪士死的时候是905岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","该南70岁的时候生了一个儿子，起名叫玛勒列。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","该南生了玛勒列以后又活了840岁。在这期间，他又生了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","该南死的时候是910岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","玛勒列65岁的时候生了一个儿子，起名叫雅列。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","玛勒列生了雅列以后又活了830岁，在这期间，他又生了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","玛勒列死的时候是895岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","雅列162岁的时候生了一个儿子，起名叫以诺。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","雅列生了以诺以后又活了800岁，在这期间，他又生了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","雅列死的时候是962岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","以诺65岁的时候生了一个儿子，起名叫玛土撒拉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","以诺生了玛土撒拉以后，又渡过了300年，深受上帝垂爱。在这期间，他又生了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","以诺在人世共桓留了365年。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","上帝把他接了去，他就消逝了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","玛土撒拉187岁的时候生了一个儿子，起名叫拉麦。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","玛土撒拉生了拉麦以后又活了782岁。在这期间，他又生了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","玛土撒拉死的时候是969岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","拉麦182岁的时候生了一个儿子， ");
INSERT INTO cmn2006_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","起名叫挪亚。拉麦说∶“上帝诅咒了土地，使得我们终年辛劳才得温饱。这个孩子会让我们在辛劳中得到安慰和歇息。” ");
INSERT INTO cmn2006_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","拉麦生了挪亚以后又活了595岁。在这期间，他又生了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","拉麦死的时候是777岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","挪亚500岁的时候生了三个儿子，分别起名叫闪、含和雅弗。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","大地上的人口在增加，生了很多女儿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","上帝的神灵们看见人的女儿容貌美丽，就选作妻子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","于是，主说∶“人体是血肉之躯，我的灵不能永远留在他们身上。他们的寿命最长不得超过120岁。” ");
INSERT INTO cmn2006_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","从那时起，开始有伟人出现在大地上，他们是上帝的神灵与人类女子交合生下的后代，是古代的英雄和名人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","主看见大地上的人类行事邪恶，他们心怀的每一个动机总是邪恶的， ");
INSERT INTO cmn2006_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","很后悔创造了人类，心中忧伤。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","于是，主说∶“我要把大地上我创造的人类、牲畜、爬虫和飞鸟都毁灭掉；我后悔当初创造了他们了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","但是，主喜爱挪亚。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","挪亚是个正直的人，是当时唯一的完人。他受到上帝的垂爱。以下是挪亚的家谱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","他有三个儿子－闪、含和雅弗。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","世界在上帝的眼里已经败坏，凶暴充斥大地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","上帝俯视大地，看见人类行为腐败，认为世界确实已经无可挽救了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","上帝对挪亚说∶“末日已经到了，我决定毁灭掉一切生命。人类使这世界充满了强暴，我要把人类和这个世界一起毁灭掉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","你要用柏木造一只方舟，方舟里要隔有房间，方舟的内外都要涂上柏油， ");
INSERT INTO cmn2006_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","方舟的尺寸是这样的∶长157米，宽26米，高15米， ");
INSERT INTO cmn2006_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","方舟要有窗户，窗户位于顶篷下方约半米。方舟的侧面要有门。方舟内要有上、中、下三层甲板。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","我要使洪水泛滥大地，毁灭天下所有的生灵。大地上的一切都要灭绝。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","但是，我要与你立约。你要和你的妻子、儿子和儿媳们一起进入方舟， ");
INSERT INTO cmn2006_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","你也要把各种动物雄雌成双地各带一对到方舟里，保全它们的生命。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","所有各种飞鸟、动物和爬虫各带一对。 ");
INSERT INTO cmn2006_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","要为你的家人和动物储备好各种食物。” ");
INSERT INTO cmn2006_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","挪亚遵照上帝的吩咐一一照办。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","主对挪亚说∶“你和你的全家要进到方舟里去，因为在这个时代只有你在我面前是正直的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","你要带七对洁净的动物进方舟，每对一公一母；不洁净的动物只带一对，也是一公一母； ");
INSERT INTO cmn2006_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","每种鸟类也带七对，每对一公一母，这样，就可以把全世界的物种存留下来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","七天以后，我要使天连续降大雨四十昼夜，把大地上我造的一切生命都消灭掉。” ");
INSERT INTO cmn2006_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","挪亚按照主的吩咐一一照办了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","挪亚600岁的时候，洪水在大地上泛滥。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","挪亚和他的妻子、儿子和儿媳们都进到方舟里躲避水灾。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","洁净的和不洁净的畜类、飞鸟和爬虫， ");
INSERT INTO cmn2006_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","都按照上帝给挪亚的命令，雌雄成对地到挪亚那里进入方舟之中。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","七天以后，洪水淹没了大地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","在挪亚600岁那年的二月十七日，所有地下的泉水都喷涌出来，天上的水闸打开了， ");
INSERT INTO cmn2006_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","倾盆大雨持续下了四十个昼夜。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","正是这一天，挪亚和他的三个儿子（闪、含、雅弗）、妻子以及儿媳们都进了方舟。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","各种野兽、牲畜、飞鸟和爬虫也都成对地跟着挪亚进入方舟。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","按照上帝给挪亚的命令，所有的动物都被雌雄成对地带进了方舟。然后，主替挪亚关上了门。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","洪水在大地上持续泛滥了四十天。洪水上涨，船高高地漂离地面； ");
INSERT INTO cmn2006_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","水势汹涌，方舟在水面上漂荡； ");
INSERT INTO cmn2006_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","水越涨越高，淹没了所有的高山； ");
INSERT INTO cmn2006_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","水继续上涨，水面比高山的山峰还要高出约8米。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","大地上的一切血肉之躯∶飞鸟、牲畜、野兽、爬虫以及人类全都死掉了， ");
INSERT INTO cmn2006_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","陆地上所有有气息的生灵都死掉了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","就这样，上帝消灭了大地上的一切活物，人、鸟、兽、虫，统统从大地上灭绝了，只有方舟中的挪亚和与他在一起的家人及动物活了下来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","洪水在大地上持续泛滥了150天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","上帝挂念挪亚和跟他一起在方舟里的所有飞禽走兽和牲畜，就让风吹拂大地。水势开始消退。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","水不再从地下涌出，天上的大雨也止住了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","水势渐渐消退；过了150天，洪水就基本消退了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","七月十七日，方舟搁在亚拉腊山上。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","水继续消退。到了十月一日，山峰开始显露出来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","又过了40天，挪亚打开方舟的窗户， ");
INSERT INTO cmn2006_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","放出一只乌鸦。乌鸦飞来飞去，一直飞到大地上的水都干了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","挪亚又放出一只鸽子，要它去看看水从大地上退净了没有。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","但是，遍地仍是水，鸽子找不到落脚的地方，就又飞了回来，挪亚伸出手去把鸽子接进方舟内。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","过了七天，挪亚又把鸽子从方舟里放出去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","黄昏时刻，鸽子飞了回来，嘴里衔着一片新鲜的橄榄叶子。于是，挪亚知道地上的水已经退净了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","又过了七天，他又把鸽子放了出去，这一次鸽子没有再飞回来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","挪亚601岁那年的一月一日，洪水从大地上消退尽净。挪亚打开方舟门张望，看见地面已经干了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","到二月二十七日，地面完全干了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","上帝对挪亚说∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“你和你的妻子、儿子和儿媳们都从方舟里出来吧， ");
INSERT INTO cmn2006_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","把跟你在一起的一切活物－走兽、牲畜、飞鸟和爬虫，都带出方舟来，让他们在大地上繁殖，遍及世界。” ");
INSERT INTO cmn2006_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","于是，挪亚带领妻子、儿子和儿媳们走出方舟， ");
INSERT INTO cmn2006_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","各种各类的动物、爬虫和飞鸟也都成群结队地出了方舟。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","挪亚为主建造了一座祭坛。他从各种洁净的动物和鸟类中选出一些，献在祭坛上作为烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","主闻到这些祭品的馨香气味，心里说∶“尽管人从小就心怀邪恶，我也决不再为了人的缘故而诅咒大地，决不再象这次一样毁灭我所造的所有生灵了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","只要大地存在一天，就一定有播种和收获，寒暑和冬夏；日夜交替，永不停息。” ");
INSERT INTO cmn2006_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","上帝赐福给挪亚和他的儿子们。上帝对他们说∶“你们要生育许多后代，遍布世界。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","大地上的一切动物、飞鸟、爬虫和海里的鱼都要畏惧你们，受你们的管辖。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","现在，我把这一切动物赐给你们作食物，就象从前把菜蔬赐给你们作食物一样。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","但是，你们不可以吃带血的肉，因为生命还没有离开肉体。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","谁害了人命，我就要处死谁。动物害了人命，要被处死；人害了人命，也要被处死。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","凡杀人的人，必被人所杀。因为我－上帝是按照自己的形象造人的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","你们要多多地生育，使子孙昌盛，遍布世界。” ");
INSERT INTO cmn2006_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","接着，上帝对挪亚和他的儿子们说： ");
INSERT INTO cmn2006_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","11","“我要与你们、你们的后代以及与你们共存在这世界上的所有动物－飞鸟、牲畜，即从方舟中出来的一切动物立约∶不再有洪水灭绝生命，不再有洪水毁坏大地。” ");
INSERT INTO cmn2006_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","上帝又说∶“我要作一个标记，作为我与你们及与你们在一起的所有生灵立约的永久标志， ");
INSERT INTO cmn2006_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","我使我的彩虹在云端出现，它就作为我与世界立约的标志。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","当天空铺上云彩，彩虹出现在云端的时候， ");
INSERT INTO cmn2006_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","我就会记起我与你们及所有的生灵立的约，水就不会再泛滥成灾毁灭生灵了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","彩虹显现在云端，我看见它就会记起我－上帝与地上一切生灵立的永世不变的约。” ");
INSERT INTO cmn2006_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","上帝对挪亚说∶“这就是我与世上一切生灵立约的标志。” ");
INSERT INTO cmn2006_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","与挪亚一同从方舟中出来的三个儿子是闪、含和雅弗。（含是迦南的父亲）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","挪亚这三个儿子的后裔遍布全世界。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","挪亚是农夫，是第一个培植葡萄园的人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","一天，挪亚喝酒喝醉了，光着身子躺在帐篷里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","含（迦南的父亲）看见父亲赤身露体，就出去告诉他的两个兄弟。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","闪和雅弗就拿了一件外套，搭在两人的肩膀上，倒退着走进去给父亲盖上，他们背着脸，没有看父亲的赤裸的身体。 ");
INSERT INTO cmn2006_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","挪亚酒醒以后，知道了小儿子的所作所为， ");
INSERT INTO cmn2006_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","就说∶ “迦南要受到诅咒， 要作他兄弟最下贱的奴仆。” ");
INSERT INTO cmn2006_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","挪亚又说∶ “赞颂主－闪的上帝！ 迦南要作闪的奴仆！ ");
INSERT INTO cmn2006_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","愿上帝使雅弗昌盛！ 愿他住在闪的帐篷里， 迦南作他的奴仆。” ");
INSERT INTO cmn2006_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","洪水以后，挪亚又活了350年， ");
INSERT INTO cmn2006_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","他死的时候是950岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","下面是挪亚的儿子闪、含和雅弗的家谱。洪水过后，挪亚的儿子们都生了儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","雅弗的儿子是歌篾、玛各、玛代、雅完、土巴、米设和提拉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","歌篾的后代是亚实基拿人、利法人和陀迦玛人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","雅完的后代是以利沙人、他施人、基提人和多单人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","地中海沿岸的民族就是由雅弗的后代组成的，他们按宗族形成各自的国家，各具自己的语言。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","含的儿子是古实、埃及、弗和迦南。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","古实的后代是西巴人、哈腓拉人、撒弗他人、拉玛人和撒弗提迦人。 拉玛人的后代是示巴人和底但人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","宁录是古实的后代。宁录是世界上的英雄之首， ");
INSERT INTO cmn2006_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","他在主面前是个英勇的猎人，所以，人们说∶“那人就象宁录一样，是主面前的英勇的猎人。” ");
INSERT INTO cmn2006_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","宁录在示拿地的巴比伦、以力和亚甲地方立国， ");
INSERT INTO cmn2006_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","他从这里向亚述扩张，建造了尼尼微城、利河伯城、迦拉城以及位于尼尼微和迦拉城之间的利鲜城，利鲜是个大城。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","埃及是路低人、亚拿米人、利哈比人、拿弗土希人、帕斯鲁细人、迦斯路西人和迦斐托人的祖先；迦斐托人是非利士人的祖先； ");
INSERT INTO cmn2006_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","迦南是西顿（长子）和赫的父亲， ");
INSERT INTO cmn2006_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","也是耶布斯人、亚摩利人、革迦撒人、 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","希未人、亚基人、西尼人、 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","亚瓦底人、洗玛利人和哈玛人的祖先。 迦南人的各部族后来分散到世界各地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","他们的地界从西顿向基拉耳方向延伸，远至迦萨；向所多玛、蛾摩拉、押玛和洗扁方向延伸，远至拉沙。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","以上是含的后代，他们形成各自的部落，各自立国，有各自的语言和领土。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","闪也有自己的后代（他是雅弗的长兄，是希伯子孙的祖先）， ");
INSERT INTO cmn2006_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","他的儿子是以拦、亚述、亚法撒、路德和亚兰。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","亚兰的后代是乌斯人、户勒人、基帖人和玛施人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","亚法撒是沙拉的父亲，沙拉是希伯的父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","希伯有两个儿子，长子叫法勒，因为人世从那时起开始分裂；他的弟弟叫约坍。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","约坍是亚摩答人、沙列人、哈萨玛非人、耶拉人、 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","哈多兰人、乌萨人、德拉人、 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","俄巴路人、亚比玛利人、示巴人、 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","阿斐人、哈腓拉人和约巴人的祖先。这些人都是约坍的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","他们住在从米沙绵亘到西发的东部山地里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","以上是闪的后代。他们形成各自的部落，各自立国，有各自的语言和领土。 ");
INSERT INTO cmn2006_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","以上是挪亚三个儿子的宗族渊源，是按照各世系各部族记录的。大洪水以后，这些部族分布到世界各地，各自立国。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","当时，世界上所有的人只有一种语言和相同的文字。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","他们从东方迁徙的时候，在示拿地发现了一片平原，就在那里定居下来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","他们互相商量说∶“来吧，让我们造些砖，把它们彻底烘干。”于是，他们用砖代替石头，用沥青代替灰泥。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","接着，他们又说∶“来吧，让我们建一座城市，建一座塔尖能通到天庭上的高塔，以此使我们扬名，免得被分散到世界各地。” ");
INSERT INTO cmn2006_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","主下来看到人们建筑的城市和塔。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","他说∶“瞧，他们形成一个民族，说一种语言。如今建城建塔，这仅仅是他们行事的开端，往后做起别的事情来，就没有做不成的了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","来吧，让我们下去，变乱他们的语言，让他们彼此不能理解。” ");
INSERT INTO cmn2006_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","于是，主把人们从那里分散到世界各地，人们就停止了建设这座城市。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","因此，这座城叫作巴别，因为主在这里搅乱了人们的语言，并从这里把人们分散到世界各地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","下面是闪的家谱。 大洪水后的第二年，闪100岁时生了亚法撒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","生了亚法撒以后，闪又活了500年，生育了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","亚法撒35岁时生了沙拉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","生了沙拉以后，亚法撒又活了403年，生育了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","沙拉30岁时生了希伯。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","生了希伯以后，沙拉又活了403年，生育了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","希伯34岁时生了法勒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","生了法勒以后，希伯又活了430年，生育了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","法勒30岁时生了拉吴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","生了拉吴以后，法勒又活了209年，生育了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","拉吴32岁时生了西鹿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","生了西鹿以后，拉吴又活了207年，生育了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","西鹿30岁时生了拿鹤。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","生了拿鹤以后，西鹿又活了200年，生育了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","拿鹤29岁时生了他拉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","生了他拉以后，拿鹤又活了119年，生育了许多子女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","他拉70岁时，已经生了亚伯兰、拿鹤和哈兰。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","下面是他拉的家谱。他拉是亚伯兰、拿鹤和哈兰的父亲。哈兰是罗得的父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","哈兰死在故乡巴比伦尼亚的吾珥的时候，他的父亲他拉还健在。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","亚伯兰和拿鹤都娶了妻。亚伯兰的妻子叫撒莱，拿鹤的妻子叫蜜迦；蜜迦和亦迦是哈兰的女儿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","撒莱不能生育，没有孩子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","他拉带着儿子亚伯兰、儿媳撒莱和孙子－哈兰的儿子罗得，离开巴比伦尼的吾珥城，往迦南地去。他们到了哈兰，就在那里定居下来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","他拉205岁的时候死在哈兰。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","主对亚伯兰说∶ “你要离开你的家乡、 亲族和你父亲的家， 到我所指示的地方去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","我要使你成为一个大国， 还要赐福给你， 使你名声昭著，受人敬重； 人们将因你而得福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","我要赐福给那些祝福你的人； 我要诅咒那侮蔑你的人； 世上万民都要因你而得福。” ");
INSERT INTO cmn2006_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","亚伯兰75岁的时候，遵照主的指示，离开了哈兰，继续迁往迦南地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","亚伯兰带着妻子撒莱、侄儿罗得和他们在哈兰的全部财物及奴仆离开哈兰向迦南进发，终于到达了迦南。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","亚伯兰穿过迦南地到了示剑的摩利，来到橡树那里（那时迦南人还住在那里）， ");
INSERT INTO cmn2006_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","主向亚伯兰显现，对他说∶“我要把这片土地赐给你的后代。”亚伯兰在那里为向他显现的主建造了一座祭坛。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","后来，亚伯兰迁徙到伯特利东部山地，在那里建立了营地。营地的西面是伯特利城，东面是艾城。亚伯兰在那里为主建了一座祭坛，并敬拜主。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","以后，他逐渐向南迁移。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","迦南地发生了严重的饥荒，亚伯兰不得不迁移到埃及暂时居住。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","就在他们要进入埃及之前，亚伯兰对他的妻子撒莱说∶“我知道你容貌美丽， ");
INSERT INTO cmn2006_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","埃及人看见了你，一定会说‘这是他的妻子’，他们会因此杀了我而留下你。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","让我们兄妹相称吧，这样，他们就会为了你的缘故而对我好，我也会由此免于一死。” ");
INSERT INTO cmn2006_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","亚伯兰一行人进入了埃及，埃及人果然觉得撒莱美丽出众。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","王的臣宰看见了她，就在王面前夸赞她的美貌。于是，撒莱被带进了王的宫中。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","王因此特别厚待亚伯兰，赐给他许多牛羊、公驴、母驴、仆婢和骆驼。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","主为了王带走亚伯兰的妻子撒莱的缘故，降灾于王和王室的人，使他们都染上可怕的疾病。 ");
INSERT INTO cmn2006_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","于是，王召见亚伯兰，问∶“你为什么对我这样做？为什么不告诉我她是你的妻子？ ");
INSERT INTO cmn2006_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","为什么说她是你的妹妹而使我娶了她？你的妻子就在这里，带她走吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","王命令左右将亚伯兰和他的妻子连同他所有的家产都送走了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","亚伯兰带着妻子和他的所有家产，与罗得一起离开了埃及，来到迦南南部。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","这时，亚伯兰很富有了，拥有许多牲畜和金银财宝。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","后来，他逐渐向伯特利迁移，来到他最初在伯特利城和艾城之间设立营地的地方。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","他曾在那里筑坛敬拜主。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","罗得与亚伯兰同行，也带着成群的牛羊和帐篷。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","他们的财产太多了，土地不够用，两个家族无法住在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","亚伯兰的牧人与罗得的牧人经常争吵。（那时，迦南人和比利洗人还住在那个地方。） ");
INSERT INTO cmn2006_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","于是，亚伯兰对罗得说∶“我们是至亲，不应该争吵，我们的牧人们也不该争吵。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","我们分手吧！全部土地都在你的眼前。如果你选右边的，我就要左边的；如果你选左边的，我就要右边的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","罗得向四周观看，看见约旦河谷水草滋润，一直伸展到琐珥，好象主的伊甸园，又象埃及的土地，（那时，主还没有毁灭所多玛城和蛾摩拉城。） ");
INSERT INTO cmn2006_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","于是，罗得选择了约旦河谷，往东迁移。他们就这样分手了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","亚伯兰住在迦南地。罗得住在河谷平原的城镇里，营地设在所多玛附近。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","所多玛人很邪恶，在主的面前是罪大恶极的人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","亚伯兰与罗得分手后，主对亚伯兰说∶“看吧，从你站着的地方向东、南、西、北极目远望， ");
INSERT INTO cmn2006_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","你目光所及之处我都要永久地赐给你和你的子孙后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","我要使你的子孙多得象地上的灰尘，谁能数得清地上的尘粒，谁才能数得清他们。 ");
INSERT INTO cmn2006_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","去吧！你去走遍整片土地，纵横往来；我要把这地全都赐给你。” ");
INSERT INTO cmn2006_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","于是，亚伯兰把营地移到希伯仑，在幔利的那棵橡树附近住了下来。他在那里为主建造了一座祭坛。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","那时，示拿王暗拉非、以拉撒王亚略、以拦王基大老玛和戈印王提达与所多玛王比拉、蛾摩拉王比沙、提玛王示纳、洗遍王善以别和比 拉 王 交 战（比拉也称琐珥）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","五王的军队在西汀谷会师（西汀谷就是现在的死海）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","他们曾臣服基大老玛十二年，但在第十三年举兵反叛。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","第十四年，基大老玛和他的盟国率军在亚特律加宁击败了利乏音人，在哈麦击败了苏西人，在沙微基列亭击败了以米人， ");
INSERT INTO cmn2006_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","在以东山地击败了何利人，并一直追击到荒漠边缘的伊勒巴兰。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","然后，他们回师安密巴（就是加低斯），征服了亚玛力全境，并击败了住在哈洗逊他玛的亚摩利人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","于是，所多玛王、蛾摩拉王、押玛王、洗遍王和比拉王率军在西汀谷会师， ");
INSERT INTO cmn2006_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","要与以拦王基大老玛、戈印王提达、示拿王暗拉非、以拉撒王亚略交战。这就是四王对五王之战。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","那时，西汀谷到处都是柏油坑。所多玛王和蛾摩拉王率军败退时，很多人掉进了柏油坑，其余的人都逃进了山里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","四王掠走了所多玛和蛾摩拉的所有财物和粮食。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","那时，亚伯兰的侄儿罗得正住在所多玛，他们也抓走了罗得，抢走了他的财物。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","一些逃出来的人跑来向希伯来人亚伯兰报告了这一切。当时，亚伯兰住在亚摩利人幔利的圣树附近。幔利和他的兄弟以实各和亚乃都是亚伯兰的盟友。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","亚伯兰听到他的侄儿被掳的消息，立即召集了318名训练有素的家丁，一直追到但。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","他趁着夜色率队分成几路进攻，击败了敌军，一直追击到大马士革以北的何巴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","他夺回了所有被掠走的财物，救出了罗得和他的财物以及被掳走的妇女和其他人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","亚伯兰打败了基大老玛及其盟军返回时，所多玛王来到沙微谷迎接他（沙微谷就是王谷）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","至高的上帝的祭司撒冷王麦基洗得带着饼和酒来迎接亚伯兰。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","他向亚伯兰祝福，说∶ “愿至高的上帝、天地的创造者赐福给你！ ");
INSERT INTO cmn2006_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","愿使你战胜敌人的至高的上帝受到赞颂！” 亚伯兰把战利品的十分之一送给了麦基洗得。 ");
INSERT INTO cmn2006_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","所多玛王对亚伯兰说∶“请把我的人口还给我，战利品归你。” ");
INSERT INTO cmn2006_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","亚伯兰对所多玛王说∶“我向天地的创造者、至高的上帝发誓， ");
INSERT INTO cmn2006_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","凡是你的东西，哪怕就是一根线、一根鞋带我都不要，免得你以后说∶‘我让亚伯兰发了财。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","我只要我的随从的食物；还有随我一起来的盟友亚乃、以实各和幔利，应该让他们得到他们应得的那一份。” ");
INSERT INTO cmn2006_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","这件事以后，主在异象中对亚伯兰说∶“亚伯兰，不要惧怕，我要保护你，要大大地奖励你。” ");
INSERT INTO cmn2006_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","亚伯兰回答∶“至高无上的主啊，我连个儿子都没有，你还赐给我什么呢？恐怕我的家业，要由大马色人以利以谢继承了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","亚伯兰接着又说∶“你没有给我儿子，只能让这个生在我家中的奴仆作我的继承人了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","主对他说∶“不，这个人不能作你的继承人，你自己的儿子才是你的继承人。” ");
INSERT INTO cmn2006_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","主领他到外面，说∶“望望天空，数数星星，你能数得清吗？”主又说∶“你的子孙后代必将多得象这天上的星星。” ");
INSERT INTO cmn2006_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","亚伯兰笃信主，主接受亚伯兰的忠诚，并以此为义。 ");
INSERT INTO cmn2006_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","主对他说∶“我是主，我带你离开迦勒底的吾珥，就是要把这片土地赐给你，作为你自己的产业。” ");
INSERT INTO cmn2006_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","亚伯兰问∶“至高无上的主啊，我怎么能知道我一定能得到这片土地呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","主吩咐他说∶“你带一只三岁大的母牛，一只三岁大的母山羊，一只三岁大的公绵羊，一只斑鸠和一只雏鸽到我这里来。” ");
INSERT INTO cmn2006_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","亚伯兰备好了这一切，把动物剖成两半，一半对一半相对摆好。只有鸟类没有剖开。 ");
INSERT INTO cmn2006_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","有鸷鸟扑下来，落在死畜上，亚伯兰把它们吓走了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","太阳西沉的时候，亚伯兰沉沉地睡着了。忽然，深沉得令人恐怖的黑暗笼罩了他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","主对他说∶“你要知道，你的子孙必将流落异乡，被人奴役受人虐待达400年之久。 ");
INSERT INTO cmn2006_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","但是，我一定要惩罚那奴役他们的国家。你的子孙以后会带着许多财富离开那个国家。 ");
INSERT INTO cmn2006_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","你自己将得高寿，安享天年。 ");
INSERT INTO cmn2006_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","你的子孙要过四代才能回到这里。因为到了那时亚摩利人才恶贯满盈，罪罚才会降临。” ");
INSERT INTO cmn2006_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","日落天黑，显现出冒烟的火炉和燃烧的火把，从那些肉块中间经过。 ");
INSERT INTO cmn2006_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","主在那一天与亚伯兰立约，对他说∶“我要把这块土地赐给你的后代，从埃及河直到幼发拉底河， ");
INSERT INTO cmn2006_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","包括基尼人、基尼洗人、甲摩尼人、 ");
INSERT INTO cmn2006_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","赫人、比利洗人、利乏音人、 ");
INSERT INTO cmn2006_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","亚摩利人、迦南人、革迦撒人和耶布斯人的大片土地。” ");
INSERT INTO cmn2006_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","亚伯兰的妻子撒莱没有生育子女。她有一个使女叫夏甲，是埃及人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","撒莱对亚伯兰说∶“既然主使我不能生育，你就把我的使女收房吧！或许她能替我生个儿子。” 亚伯兰听从了撒莱的话。 ");
INSERT INTO cmn2006_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","于是，撒莱就把她的埃及使女夏甲交给亚伯兰为妾。这时亚伯兰在迦南地已经住了十年。 ");
INSERT INTO cmn2006_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","亚伯兰与夏甲同房，夏甲怀了孕。夏甲发觉自己怀了孕，便不把主母放在眼里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","撒莱对亚伯兰说∶“都是因为你，她才敢对我不好。我把自己的使女给了你，她知道自己有了孕就瞧不起我。愿主在你我之间主持公道。” ");
INSERT INTO cmn2006_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","亚伯兰对她说∶“好，你的使女由你管束，你愿意怎么处置她就怎么处置好了。”于是，撒莱虐待夏甲，夏甲就逃走了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","主的天使在通往书珥的路上的一个水井旁看见了夏甲， ");
INSERT INTO cmn2006_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","对她说∶“夏甲，撒莱的使女，你从哪里来？要到哪里去？” 夏甲答道∶“我是从我的主母撒莱那里逃出来的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","主的天使对她说∶“回到你的主母那里去吧，要服她的管束。” ");
INSERT INTO cmn2006_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","主的天使又说∶ “我将使你的子孙多得数也数不清。 ");
INSERT INTO cmn2006_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","瞧，你已经怀孕了， 你会生个儿子， 你要给他起名叫以实玛利， 因为主听到了你的苦难。 ");
INSERT INTO cmn2006_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","你的儿子将象一头野驴， 他敌视所有的人， 所有的人也都与他为敌。 他毫无亲族之情。” ");
INSERT INTO cmn2006_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","夏甲称颂对她说话的主∶“你是洞察万事的上帝。” 她又说∶“我真的在这儿看见了看顾我的上帝了吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","因此，人们叫那口井为庇耳拉海莱。这口井至今仍在加低斯和巴列中间。 ");
INSERT INTO cmn2006_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","夏甲生下亚伯兰的儿子，亚伯兰给他起名叫以实玛利。 ");
INSERT INTO cmn2006_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","夏甲生下以实玛利的时候，亚伯兰86岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","亚伯兰99岁的时候，主向亚伯兰显现。对他说∶“我是全能的上帝。你要服从我，要作正直无瑕的人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","我要与你立约，使你的子孙极其昌盛。” ");
INSERT INTO cmn2006_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","亚伯兰俯伏在地上；上帝又对他说∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“这就是我与你立的约∶你将成为万国之父。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","从此以后，你的名字不再叫亚伯兰，要叫亚伯拉罕。因为我已经立你为万国之父。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","我将使你子孙昌盛，国度由你而立，君王由你而出。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","我要与你和你的子孙万代立约－一个永世长存的约，我允诺作你和你的子孙后代的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","我将把你现在寄居的整个迦南地赐给你和你的后代，作为你们永久的产业，我也是他们的上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","上帝对亚伯兰说∶“你和你的子孙后代要坚守与我立的约。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","这就是我要你和你的子孙后代坚守的约∶你们当中所有的男子都必须行割礼。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","你们都要受割礼，这是我与你们立约的标志。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","自今以后，你们所有的男子，你们世世代代的男子，包括在家里出生的和用银子向外国人买来的奴仆，在生下来的第八天都必须行割礼。即便他不是你的后代，也要受割礼， ");
INSERT INTO cmn2006_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","家生的和买来的奴仆也都必须行割礼。这样，我的约就立在你们的肉体上；这是永久立约的标记。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","凡未受割礼的男子都要从宗族中逐出去，因为他违背了我的约。” ");
INSERT INTO cmn2006_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","上帝对亚伯拉罕说∶“你的妻子撒莱不要再叫撒莱，要叫撒拉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","我要赐福给她，使她给你生一个儿子，我还要赐福给她，使她成为万国之母，万民之王将由她而出。” ");
INSERT INTO cmn2006_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","亚伯拉罕俯伏在地，却暗暗地笑，心里说∶“100岁的老人还能有孩子吗？撒莱已经90岁了，还能生孩子吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","于是，亚伯拉罕对上帝说∶“我想，就让以实玛利承受您的恩宠吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","上帝说∶“不，你的妻子撒拉会给你生个儿子的，你要给他起名叫以撒。我要向他和他的后代坚守我的永世不变的约。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","我也听到了你为以实玛利作的请求，我将赐福给他，使他子孙昌盛。他将作十二个酋长的父亲，我将使他的家族成为大国。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","但是，我要与你的儿子以撒坚守我的约。明年的这个时候，撒拉就会生下以撒。” ");
INSERT INTO cmn2006_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","上帝对亚伯拉罕说完了这些话，就飞升而去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","就在那一天，亚伯拉罕遵照上帝的命令，给他的儿子以实玛利和家族里所有的男子，包括那些家里出生的和买来的奴仆，施行割礼。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","亚伯拉罕行割礼的时候是99岁； ");
INSERT INTO cmn2006_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","以实玛利是13岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","所有家族中的所有男子，包括家生的和买来的奴仆都与亚伯拉罕和他的儿子以实玛利一起在那一天行了割礼。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","主在幔利的橡树那里向亚伯拉罕显现。那时正是一天中最热的时候，亚伯拉罕正坐在帐篷门口。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","他抬起头来，看见三个人站在面前，就赶紧从帐篷口跑过去迎接他们，俯伏在地， ");
INSERT INTO cmn2006_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","说∶“我主啊，请和我－你的仆人呆一段时候。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","我去打些水来给你们洗脚，请在树下休息休息。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","我再去拿点吃的东西，你们吃了恢复了精力好继续赶路。你们既然已经到了舍下，就让我这么做吧。” “就照你说的办吧！”那三个人回答说。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","于是，亚伯拉罕急忙跑进帐篷，对撒拉说∶“快点，拿一些上好的面粉，调好，做些饼。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","说完，他又跑到牛群那里，挑了一头又肥又嫩的小牛，交给仆人，让他赶快去准备。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","然后，亚伯拉罕把备好的奶油、牛奶和牛肉摆在他们的面前。他们吃喝的时候，亚伯拉罕就站在他们旁边的树下。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","他们问亚伯拉罕∶“你的妻子撒拉在哪里？” 他答道∶“她在帐篷里。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","三人中有一位说∶“明年的这个时候，我还要回到这里来，那时你的妻子撒拉必定生子。” 这时，撒拉正站在那人身后的帐篷门口听着。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","那时，亚伯拉罕和撒拉都很老了，撒拉的月经也早已停止了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","因此，撒拉暗自偷笑，说∶“我已经衰老了，丈夫也这么老了，还能有喜吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","主问亚伯拉罕∶“撒拉为什么要发笑？还说‘我这么老了，还能有孩子吗？’ ");
INSERT INTO cmn2006_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","难道主还有什么办不成的事吗？到明年这个时候，我必回到这里来，那时撒拉必定会生个儿子。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","撒拉心中害怕，否认说∶“我没有笑。” 主说∶“不对，你确实笑了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","然后，三个人就离开了那里，向所多玛俯视。亚伯拉罕陪着他们一起走，送他们上路。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","主自语道∶“我准备做的事要不要瞒着亚伯拉罕呢？ ");
INSERT INTO cmn2006_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","他的家族将要成为一个强大的国家，世上的万国都要因他而得福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","我拣选了他，就是要他训导他子孙和家族遵循主的指示，主持公道，伸张正义；这样，我－主就实现了我对亚伯拉罕的诺言。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","主说∶“对所多玛和蛾摩拉两座城的指控实在是太多了，他们真是恶贯满盈。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","我要下去看一看他们是不是真的象我听到的那样在胡作非为。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","于是，另外二人转身向所多玛走去，亚伯拉罕却仍旧站在主的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","亚伯拉罕走近主，说∶“主啊，您真的要把正直的人和有罪的人一起消灭吗？ ");
INSERT INTO cmn2006_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","如果城里有五十个正直的人，您还要毁灭那座城吗？您就不能为了这五十个住在城里的正直的人而宽恕全城吗？ ");
INSERT INTO cmn2006_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","请不要把正直的人跟有罪的人一起杀掉吧！否则，就是善恶不分了。您一定不会这样做的！世界的审判者难道不主持公道吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","主说∶“如果我在所多玛城里能找到五十个正直的人，我就为了他们饶恕全城的人。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","亚伯拉罕说∶“主啊！我虽然微不足道，却还是要大胆地向您祈求， ");
INSERT INTO cmn2006_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","如果城中只有四十五个正直的人，您会因为少了五个而毁灭全城吗？” 主说∶“如果能找到四十五个正直的人，我也不毁灭那城。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","亚伯拉罕又对主祈求∶“如果只找到四十人呢？” 主答道∶“为了这四十人，我也不毁灭那城。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","亚伯拉罕对主说∶“主啊！请不要对我生气，我还要祈求你；如果只有三十人呢？” 主说∶“如果能找到三十个正直的人，我也不毁灭那城。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","亚伯拉罕说∶“主啊！请宽恕我大胆地向你请求。如果只有二十个人呢？” 主说∶“只有二十个，我也不毁灭那城。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","亚伯拉罕说∶“主啊！请不要对我发怒。我只再请求这一次了。如果只有十个人呢？” 主说∶“为了这十个人，我也不毁灭那城。” ");
INSERT INTO cmn2006_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","主说完，转身离去了。亚伯拉罕也起身回家。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","黄昏时分，两位天使到了所多玛城。当时罗得正坐在城门口。罗得看见了他们，就起身去迎接，他俯伏在地， ");
INSERT INTO cmn2006_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","说“我主，请到舍下休息吧，洗洗脚，住一夜，明天一早好赶路。” 两位天使说∶“不啦，我们要在街上过夜。” ");
INSERT INTO cmn2006_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","但是，罗得再三恳请，他们这才走进他的屋子里。罗得为他们准备筵席，烤无酵饼，设宴招待。两位天使就吃了起来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","正当他们准备上床歇息时，所多玛城的所有男子，不分老幼，一起拥来包围了罗得的房子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","他们向罗得喊叫∶“今天晚上来你家的那两个人在哪里？把他们交出来，我们要跟他们睡觉！” ");
INSERT INTO cmn2006_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","罗得出去，随后把门关上， ");
INSERT INTO cmn2006_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","说∶“朋友们，千万不能干这种丧尽天良的事。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","我有两个女儿，还都是处女，我把她们交给你们，任凭你们随意处置。只是不可难为这两个客人。他们既来到我家，我就必须保护他们。” ");
INSERT INTO cmn2006_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","所多玛人却向罗得喊∶“滚开！”又说∶“这家伙不过是个外乡人，却想要教训我们！等着吧，我们要让你比那两个人更倒霉。”他们一拥而上围住罗得，又继续往前挤，要砸开屋门。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","这时，屋里的那两个人打开房门，伸出手来把罗得拉进屋里，随手关上了门。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","然后，他们使门外的所有人，不分老幼，全都瞎了双眼，摸不着房门。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","那两个人问罗得∶“这里还有你的亲人吗？带着你的女婿、儿子、女儿和其他亲人赶快离开这里吧， ");
INSERT INTO cmn2006_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","我们就要毁灭这座城了！主已经听到这座城是多么邪恶，特地派我们来毁灭这城。” ");
INSERT INTO cmn2006_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","于是，罗得出去对女婿说∶“起来！赶快离开这个地方。主要毁灭这城了。” 但是他的女婿们以为他是在开玩笑。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","黎明时分，天使催促罗得，说∶“起来！带着你的妻子和身边的两个女儿快走吧！不然就要与这城同归于尽了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","罗得犹豫不决；于是，那两人就拉着罗得和他妻子及两个女儿的手，把他们带到城外。因为主怜悯罗得，不忍看他一起被毁灭。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","到了城外，一位天使对罗得说∶“快逃命去吧！无论发生了什么事情都不要往后看，也不要停留在山谷里，你们要跑到山上去，不然的话，你们也会被一同毁灭。” ");
INSERT INTO cmn2006_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","罗得对他们说∶“主啊！请别这样。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","我－您的仆人，已经蒙受你莫大的恩典，保全了性命；只是恐怕我还没跑到山上灾祸就降临了，我还是活不成。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","你瞧，那里有个小镇，离这里不远，请让我到那里去避难吧！那只不过是一个小镇，如果你不毁灭那里的话，我就逃得性命了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","天使对他说∶“好，这事我也答应你。我不毁灭你说的这座小城。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","快点！快跑吧！我等你到了那小城再动手。”因此，那个小镇就叫作琐珥。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","太阳出来的时候，罗得逃到了琐珥小城。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","这时，主使燃烧的硫磺和火从天而降，落到所多玛城和蛾摩拉城。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","就这样，主毁灭了这两个城市和整个谷地，包括城中的所有居民和地上生长的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","罗得的妻子回头看了一眼，立刻就变成了一根盐柱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","亚伯拉罕清早起来，来到他曾在主面前站过的那个地方， ");
INSERT INTO cmn2006_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","俯视所多玛城和蛾摩拉城及整个平原。地面上烟雾升腾，好象是从大火炉里冒出来的烟。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","上帝挂念亚伯拉罕，这才使罗得在上帝毁灭他所住的那座城时免遭灭顶之灾。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","罗得不敢在琐珥住，他离开那里，和两个女儿搬到山上，住在一个山洞里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","大女儿对妹妹说∶“爸爸老了，这里又没有男子按世上的常规跟我们结婚。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","来吧！我们把爸爸用酒灌醉，然后跟他睡觉，这样就可以由爸爸延续我们家族的后代了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","那天晚上，她们用酒把父亲灌醉，大女儿跟父亲睡了觉。但是，罗得对女儿的来去一无所知。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","第二天，大女儿对妹妹说∶“昨晚我跟父亲睡了，今天晚上我们再把他灌醉，然后你去和他睡，这样，我们就可以由爸爸延续我们家族的后代了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","那天晚上，她们又把父亲灌醉，小女儿跟父亲睡了觉。罗得对女儿的来去仍是毫无知觉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","就这样，罗得的两个女儿都由父亲怀了孕。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","大女儿生了一个儿子，起名叫摩押，他就是今天摩押人的祖先。 ");
INSERT INTO cmn2006_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","小女儿也生了一个儿子，起名叫便亚米，他就是今天亚扪人的祖先。 ");
INSERT INTO cmn2006_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","亚伯拉罕从幔利向南地迁移，客居在加低斯和书珥中间的基拉耳。他在那里居住的时候， ");
INSERT INTO cmn2006_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","对外人介绍他的妻子撒拉∶“这是我的妹妹。”基拉耳王亚比米勒派人把她接了去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","夜里，上帝托梦给亚比米勒，对他说∶“你真该死！你带来的这个女人是别人的妻子。” ");
INSERT INTO cmn2006_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","那时，亚比米勒还没有亲近撒拉，他说∶“主啊！你会处死一个无辜的人吗？ ");
INSERT INTO cmn2006_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","亚伯拉罕确实对我说‘她是我妹妹’，撒拉自己也对我说∶‘他是我哥哥’，我做这件事问心无愧。” ");
INSERT INTO cmn2006_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","上帝在梦境中回答他∶“我也知道你做这事良心清白，所以才不让你得罪我，没有让你接近她。 ");
INSERT INTO cmn2006_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","现在，把这女子归还给她的丈夫。亚伯拉罕是先知，他会为你祈祷，使你免于一死。如果你不归还这女子，你和你的家族都必死无疑。” ");
INSERT INTO cmn2006_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","第二天清晨，亚比米勒召集所有的臣仆，把梦境讲给他们听，臣仆们都非常害怕。 ");
INSERT INTO cmn2006_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","亚比米勒召见亚伯拉罕，问他∶“你为什么要这样对待我们？我在什么地方得罪了你，你竟要陷我和我的王国于如此大罪之中？你不应该这样做。” ");
INSERT INTO cmn2006_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","亚比米勒又问亚伯拉罕∶“你是不是遭遇到了什么事才这样做？” ");
INSERT INTO cmn2006_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","亚伯拉罕答道∶“是的，我原以为这里的人不敬畏上帝，他们会为夺妻而杀害我。 ");
INSERT INTO cmn2006_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","而且，撒拉也确实是我同父异母的妹妹，后来作了我的妻子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","当上帝叫我离家流浪的时候，我对她说∶‘无论我们到了什么地方，你都要把我说成是你的哥哥，这就是你待我的恩情了。’” ");
INSERT INTO cmn2006_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","亚比米勒赐给亚伯拉罕许多羊、牛和男女奴仆，又把撒拉送还给他， ");
INSERT INTO cmn2006_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","对他说∶“看，我的土地随你挑选，你喜欢住在哪里就住在哪里。” ");
INSERT INTO cmn2006_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","接着，又对撒拉说∶“我给了你哥哥一千块银子，用来在全家族人面前为你的名誉做证，你是完全清白的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","亚伯拉罕向上帝祈祷，上帝就医好了亚比米勒的妻子和宫女，使她们又有了生育的能力。 ");
INSERT INTO cmn2006_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","当初，主曾为了亚比米勒带走亚伯拉罕的妻子撒拉的缘故，使亚比米勒宫中的女人都不能生育。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","主按照自己的诺言眷顾撒拉，兑现了他对撒拉的允诺。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","亚伯拉罕老年之时，撒拉怀了孕，到了上帝预言的时刻，果然给亚伯拉罕生下一个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","亚伯拉罕给撒拉生的这个儿子起名叫以撒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","以撒出生后的第八天，亚伯拉罕遵照上帝的规定，给儿子以撒行了割礼。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","以撒出生的时候，亚伯拉罕100岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","撒拉说∶“上帝给我带来欢笑，凡是听到这事的人都会和我共同欢笑。” ");
INSERT INTO cmn2006_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","她又说∶“谁能预先对亚伯拉罕说撒拉会养孩子呢？可我竟使他老年得子！” ");
INSERT INTO cmn2006_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","孩子渐渐长大，不再吃奶了。在他断奶的那一天，亚伯拉罕举行了一个盛大的宴会。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","撒拉看见埃及使女夏甲给亚伯拉罕生的儿子以实玛利和她的儿子以撒一起玩耍， ");
INSERT INTO cmn2006_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","就对亚伯拉罕说∶“把这婢女和她的孩子赶走！不能让这使女的儿子和我的儿子一同继承你的产业。” ");
INSERT INTO cmn2006_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","这使亚伯拉罕很为难，他为自己的儿子以实玛利忧心忡忡。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","上帝对亚伯拉罕说∶“别为你的儿子和使女夏甲发愁。照撒拉说的办吧！因为，只有以撒的后代才能承袭你的姓氏。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","我也会使使女夏甲的儿子成为一国，因为他也是你的后代。” ");
INSERT INTO cmn2006_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","第二天清晨，亚伯拉罕拿了一些干粮和一皮袋水交给夏甲。他把这些东西搭在夏甲的肩上，让她带着孩子上路了。她离开了那里，在别是巴的旷野里流浪。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","不久，水喝光了，她把孩子放在树丛下， ");
INSERT INTO cmn2006_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","自己走到大约一箭远的地方坐下，说∶“我不忍心亲眼看着孩子死去！”于是，她坐在远处，放声大哭。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","上帝听见了孩子的声音，天使从天上呼唤夏甲，对她说∶“你怎么了，夏甲？别害怕，上帝已经听见了孩子的哭声。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","起来！把孩子抱起来，紧紧地搂在怀里。我必使他的后代成为大国。” ");
INSERT INTO cmn2006_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","接着，上帝使夏甲的眼睛明亮了，她看到一口水井。夏甲走过去，将皮袋盛满了水，给孩子喝。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","上帝保佑孩子，他渐渐长大成人，成了弓箭手，在荒野里以射猎为生。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","以实玛利住在巴兰旷野里，他的母亲给他娶了一个埃及女子作妻子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","那个时期，亚比米勒和他的元帅非各对亚伯拉罕说∶“上帝在你所做的事情上处处与你同在； ");
INSERT INTO cmn2006_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","所以，你要在这里，在上帝的面前发誓：你永远不欺骗我和我的子孙后代。我一向恩待你，你也要恩待我和你寄居的这个国家。” ");
INSERT INTO cmn2006_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","亚伯拉罕说∶“我愿意发誓。” ");
INSERT INTO cmn2006_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","接着，亚伯拉罕向亚比米勒指责他的仆人霸占了水井。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","亚比米勒说∶“我确实不知道是谁干的这事。你以前没有告诉过我，我今天才知道这事。” ");
INSERT INTO cmn2006_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","亚伯拉罕送给亚比米勒一些牛羊，两人立了约。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","亚伯拉罕从羊群中分出七只小母羊放在一旁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","亚比米勒问∶“你把这七只小母羊放在一旁是什么意思？” ");
INSERT INTO cmn2006_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","亚伯拉罕说∶“请你接受这七只小母羊，作为是我挖了这口井的证明。” ");
INSERT INTO cmn2006_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","因此，那地方就叫作别是巴，因为他们两人在那里起了誓。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","就这样，亚伯拉罕与亚比米勒在别是巴立了约。然后，亚比米勒和他的元帅非各起身回非利士去了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","亚伯拉罕在别是巴种了一棵柳树，在那里敬拜主－永生的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","亚伯拉罕在非利士客居了很长时间。 ");
INSERT INTO cmn2006_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","这些事情以后，上帝要考验亚伯拉罕。 上帝呼唤他∶“亚伯拉罕！”亚伯拉罕答道∶“我在这里！” ");
INSERT INTO cmn2006_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","上帝说∶“带上你心爱的独生子以撒，到摩利亚地去，在我指示给你的山上把他当作烧化祭献给我。” ");
INSERT INTO cmn2006_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","亚伯拉罕清早起来，备好驴，劈好了献祭用的木柴，领着两个仆人和他的儿子以撒，带上劈柴，一起往上帝指定的那座山上去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","第三天，亚伯拉罕举目了望，看见了那个地方。 ");
INSERT INTO cmn2006_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","亚伯拉罕对两个仆人说∶“你们和驴子呆在这儿，我和孩子到那边去敬拜，然后就回到这里来。” ");
INSERT INTO cmn2006_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","亚伯拉罕让儿子以撒背着献祭用的木柴，自己手里拿着火种和刀，两人一同上山。 ");
INSERT INTO cmn2006_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","以撒叫∶“爸爸！”亚伯拉罕答道∶“孩子，我在这儿！”以撒说∶“火种和木柴都有了，可是献祭的羔羊在哪里呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","亚伯拉罕答道∶“孩子，上帝会亲自准备献祭用的羔羊的。” 父子二人继续往前走， ");
INSERT INTO cmn2006_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","登上了上帝指示给亚伯拉罕的那座山。亚伯拉罕在那儿筑起一座坛，把木柴摆放在祭坛上。然后，他把儿子以撒捆起来，放在祭坛上的木柴堆上。 ");
INSERT INTO cmn2006_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","正当亚伯拉罕伸手举刀要杀他的儿子时， ");
INSERT INTO cmn2006_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","主的天使从天上呼叫∶“亚伯拉罕，亚伯拉罕！”亚伯拉罕答道∶“我在这儿。” ");
INSERT INTO cmn2006_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","天使说∶“住手！不许伤害孩子！不许动他！现在我知道你是敬畏上帝的了。你没有把自己的独生儿子留着不给我。” ");
INSERT INTO cmn2006_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","亚伯拉罕抬头张望，看见树丛中有一只公羊，两只角被树丛绕住，就走过去把那只羊取了过来，代替儿子作了烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","因此，亚伯拉罕把那地方叫作“耶和华以勒”。至今人们仍然说∶“在主的山上，必有准备。” ");
INSERT INTO cmn2006_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","主的天使第二次从天上呼唤亚伯拉罕， ");
INSERT INTO cmn2006_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","说∶“主说∶‘我指着我的名起誓∶由于你没有留下自己的独生儿子不给我， ");
INSERT INTO cmn2006_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","我一定要赐福给你，使你的子孙后代多得像天上的星星和海边的沙粒，他们将征服和占领敌人的城邑； ");
INSERT INTO cmn2006_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","由于你对我的敬畏，世上的万国都将因你的后代而得福。’” ");
INSERT INTO cmn2006_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","亚伯拉罕回到仆人那里，他们动身一齐回到了亚伯拉罕的住处别是巴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","后来，亚伯拉罕听说密迦也给他的弟弟拿鹤生了几个儿子∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","长子乌斯，他的弟弟布斯、基母利－基母利是亚兰的父亲、 ");
INSERT INTO cmn2006_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","基薛、哈琐、必达、益拉和彼土利－ ");
INSERT INTO cmn2006_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","彼土利是利百加的父亲。密迦给亚伯拉罕的弟弟拿鹤生了这八个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","拿鹤的妾流玛也为拿鹤生了儿子∶提八、迦含、他辖和玛迦。 ");
INSERT INTO cmn2006_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","撒拉活了127岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","她死在迦南地的基列亚巴（即希伯伦）。亚伯拉罕赶到那里，痛哭流涕，为她举哀。 ");
INSERT INTO cmn2006_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","亚伯拉罕从妻子的灵前站起来，对当地的赫人说∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“我是寄居你们这儿的外族人，请卖一块坟地给我，好让我埋葬妻子。” ");
INSERT INTO cmn2006_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","赫人答道∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“请听我们说，先生。在我们这里，你是一位大贵人。请在我们最好的坟地上安葬你的妻子吧，我们大家都愿意给你坟地埋葬她。” ");
INSERT INTO cmn2006_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","亚伯拉罕起身向赫人下拜， ");
INSERT INTO cmn2006_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","对他们说∶“如果你们愿意让我在这里埋葬妻子，请向琐辖的儿子以弗仑转达我的意愿， ");
INSERT INTO cmn2006_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","让他把麦比拉洞卖给我，那洞就在他的田头上。请他当着你们的面把那块地按足价卖给我，好当坟地用。” ");
INSERT INTO cmn2006_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","当时，以弗仑正坐在赫人中间。赫人以弗仑当着在城门口出入的赫人的面答话，好让大家都能听到。他说∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“不，先生，请听我说。我当着大家的面，把那块田连同田间的洞一齐送给你，你就在那儿安葬你的妻子吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","亚伯拉罕向众人下拜， ");
INSERT INTO cmn2006_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","当着大家的面向以弗仑说∶“请务必听我说，我要买下这块田，请把钱收下，这样我就可以在那里安葬我的妻子了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","以弗仑说∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“先生，请听我说。那块地不过值400块银子，这在你我之间算不了什么。你就把妻子葬在那里吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","亚伯拉罕与以弗仑说妥之后，就按以弗仑在众人面前说出的价格，用当时商人通用的秤称了400块银子交给他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","就这样，以弗仑在幔利东面麦比拉的那块田和其中的洞连同田间及四周的树木都成了亚伯拉罕的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","这件事得到赫人和出入城门的人的承认。 ");
INSERT INTO cmn2006_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","买妥地之后，亚伯拉罕就在迦南地幔利（希伯伦）东面的麦比拉洞里安葬了妻子撒拉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","从赫人那里买来的位于迦南地希伯伦的那块田和其中的麦比拉洞就此成了亚伯拉罕家族的坟地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","亚伯拉罕年事已高，主处处赐福给他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","亚伯拉罕对最年长的仆人同时也是总管家说∶“把你的手放在我的臀部下面， ");
INSERT INTO cmn2006_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","我要你以主－主宰天地的上帝的名义向我发誓，决不让我的儿子娶那些和我生活在一起的迦南人的女儿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","你要回我的故乡去，回到我的亲戚身边，在那里为我的儿子以撒娶妻。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","仆人对他说∶“如果那个女子不愿跟我回到这里来，怎么办呢？我是不是应该带你的儿子回到故乡去呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","亚伯拉罕对他说∶“千万不要带我儿子回那里去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","主－天上的上帝带我离开父亲的家园、我的故乡时，曾向我许诺‘我要把这片土地赐给你的子孙后代’。他必派遣天使先你而行，你会在那里为我的儿子找到妻子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","如果那个女子不愿跟你回来，那就不算你违背誓言，不过千万不要把我的儿子带回到那里去。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","仆人把手放在他的主人亚伯拉罕的臀部下面，就这件事向他起了誓。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","仆人挑选了十头骆驼，驮着各种礼物动身前往美索不达米亚，来到拿鹤居住的城外。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","黄昏时刻，当女子们出来打水的时候，仆人让骆驼在城外的井旁趴了下来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","他说∶“主啊，我主人亚伯拉罕的上帝！求你善待我的主人亚伯拉罕，让我今天就成功吧！ ");
INSERT INTO cmn2006_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","现在我正站在泉水旁边，城里人家的女儿们正出来打水。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","我要对一个女孩子说∶‘请放下水罐，让我喝点水吧！’她如果说∶‘请喝吧，我还要给你的骆驼饮水呢！’那么她就将是你为你的仆人以撒选定的妻子。这样，我也就知道你对我的主人是仁爱和守信的了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","话还没有说完，利百加肩上扛着水罐，走了出来。她是彼土利的女儿；彼土利是亚伯拉罕的弟弟拿鹤与妻子密迦的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","利百加长得非常美丽动人，她是个处女，还没有男人亲近过她。她走到井边，把水罐打满了水，又走了回来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","仆人急忙迎上去说∶“请让我喝点你水罐里的水吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","利百加说∶“请喝吧，先生。”她立刻从肩上卸下水罐，用手托着送给他喝。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","他喝完后，利百加又说∶“我还要打水给你的骆驼喝，让它们统统喝个饱。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","她迅速地把水罐里的水倒进水槽里，又跑到井边，为他所有的骆驼打了水。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","仆人默默地注视着她，想要知道主是否已经让他此行的目的得以实现。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","骆驼一喝完水，仆人就拿出一枚重六克的金鼻环和两个各重六十克的金手镯，给少女戴上， ");
INSERT INTO cmn2006_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","对她说∶“请告诉我，你是谁家的女儿？你父亲家里有没有地方可以让我们过夜？” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","利百加答道∶“我的父亲彼土利是密迦与拿鹤的儿子，我是彼土利的女儿。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","接着又说∶“我家有许多粮草，也有让你们住宿的地方。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","听了这话，仆人低头向主敬拜， ");
INSERT INTO cmn2006_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","说∶“赞美主，我主人亚伯拉罕的上帝！他始终垂爱我主人，信守对我主人的诺言，一路指引着我来到我主人亲戚的家里。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","那少女跑回家里把这些事情告诉了母亲和家里的人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","利百加有个哥哥名叫拉班，他看见妹妹戴着金环和手镯，听到妹妹述说那个人对她说的话，急忙来到了井旁亚伯拉罕的仆人那里。仆人手里牵着骆驼，立在井旁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","拉班说∶“快进我家里来吧，你是主赐福的人，为什么还站在外面呢？我已经为你们准备好了住处，也有骆驼呆的地方。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","于是，仆人进了屋。拉班卸下骆驼身上的东西，给它们备了草料，还打来了水，让亚伯拉罕的仆人和他的随从们洗脚。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","然后为他摆好了饭菜。但是，那仆人却说∶“请等一下，让我说完了要说的话再吃饭。”拉班说∶“请讲吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","仆人说∶“我是亚伯拉罕的仆人； ");
INSERT INTO cmn2006_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","主赐福给我的主人，使他非常富有。主赐给他羊群、牛群、金银财宝、男女奴仆、骆驼和驴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","我的女主人撒拉老年时给他生了一个儿子，主人把所有家产都给了这个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","我的主人让我对他起誓，他对我说∶‘不要从我寄居的迦南地的迦南人家给我儿子娶妻， ");
INSERT INTO cmn2006_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","你一定要到我父亲的家园及我的亲族那里去为我的儿子娶妻。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","我对我的主人说∶‘如果那个女子不愿跟我回来怎么办呢？’ ");
INSERT INTO cmn2006_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","他说∶‘我敬拜主，主必定会派遣使者与你同行。他会使你此行成功。你会在我的亲族和我父亲的家园那里为我儿子娶到一个妻子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","只要你到了我亲族的家里，你就算履行了誓言。即使我的亲族不肯把那女子交给你，也不算你违背誓言。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","今天，我来到井边时，我说∶主啊，我主人亚伯拉罕的上帝！愿你使我此行成功。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","瞧，我现在正站在水井旁，让年轻姑娘出来打水吧！我要对她说∶‘请给我一点你水罐里的水喝。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","她如果说∶‘请喝吧！我还要打水给你的骆驼喝呢！’这女子就将是主为我主人的儿子选定的那个女子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","我在心里刚说完这些话，利百加就肩上扛着水罐出来了，她来到井边打水，我就对她说∶‘请给我一点水喝吧！’ ");
INSERT INTO cmn2006_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","她赶快从肩上拿下水罐，说∶‘请喝吧！我还要打水给你的骆驼喝呢！’我喝了水，她又打水给骆驼喝。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","于是，我问她∶‘你是谁的女儿？’她回答说∶‘我是密迦和拿鹤之子彼土利的女儿。’我给她挂上鼻环，戴上手镯， ");
INSERT INTO cmn2006_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","然后，我低头敬拜主，赞美主－我主人亚伯拉罕的上帝，他指引我顺利地为我主人的儿子找到了他亲族人家的女儿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","现在，如果你们愿意与我的主人坦诚相待，请告诉我；如果不愿意，也请告诉我，我好知道该怎么办。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","拉班与彼土利答道∶“这是主的旨意，我们不敢妄加评论。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","瞧！利百加就在这儿。你带她回去，让她按主的训示，做你主人的儿媳吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","亚伯拉罕的仆人听了他们的话，就俯伏在地敬拜主。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","当时，仆人拿出所有的金器银器和衣服送给利百加，也送给她哥哥和母亲许多贵重的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","然后，仆人和他的随从才开始吃喝，并在那里住了一夜。 第二天清早，仆人说∶“请让我回到我主人那里去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","利百加的哥哥和母亲却说∶“让女孩儿跟我们呆至少十天再走吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","仆人对他们说∶“请不要耽搁，主已经使我此行成功，请让我回到我主人那里去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","他们说∶“我们把女孩儿叫来，问问她想怎么办。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","他们把利百加叫来，对她说∶“你愿意现在就跟这个人走吗？”利百加答道∶“我愿意。” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","于是，家里人就打发利百加和她的奶妈以及使女跟着亚伯拉罕的仆人及其随从一起上路。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","临行时，家人为她祝福说∶ “我们的小妹妹啊， 愿你成为万民之母！ 愿你的子孙后代征服仇敌的城邑！” ");
INSERT INTO cmn2006_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","利百加和她的使女们骑上骆驼，跟在那仆人的后面。仆人就带着利百加上了路。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","这时，以撒已经从庇尔拉海莱迁到迦南南部居住。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","傍晚，以撒在田野里散步。他抬起头，看见骆驼队正走过来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","利百加远远看见了以撒，就从骆驼上下来， ");
INSERT INTO cmn2006_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","问那仆人说∶“那从田间向我们走来的人是谁？”仆人说∶“他就是我的主人。”利百加听见这话，就用围巾遮住了自己的脸。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","仆人把所作的一切都告诉了以撒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","以撒把利百加带进他母亲撒拉住过的帐篷，跟她成婚。利百加成了以撒的妻子，以撒很爱她。以撒自从母亲死后，心中充满了忧伤，利百加的到来使他得到了安慰。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","亚伯拉罕又娶一个妻子，名叫基土拉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","她生了心兰、约珊、米但、米甸、伊施巴和书亚六个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","约珊是示巴和底但的父亲。底但的后裔是亚述人、利都是人和利乌米人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","米甸的儿子是以法、以弗、哈诺、亚比大和以勒大。以上这些是基土拉的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","亚伯拉罕把所有的家产都给了以撒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","但是，他也把一些财产分给了其他妻妾生的儿子。他在世时就打发这些儿子去了东方，远远地离开了他的儿子以撒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","亚伯拉罕享年175岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","一生志得意满，高年而终，返归列祖。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","他的儿子以撒和以实玛利把他安葬在麦比拉洞里。这洞在幔利东边原先是赫人琐辖的儿子以弗仑的那块田地里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","这块地是亚伯拉罕向赫人买的，他和他的妻子撒拉都葬在这里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","亚伯拉罕死后，上帝赐福给他的儿子以撒。以撒住在庇耳拉海莱附近。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","下面是亚伯拉罕与埃及使女夏甲所生的儿子以实玛利的家谱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","他们的名字按出生次序是∶ 尼拜约、基达、亚德别、米比衫、 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","米施玛、度玛、玛撒、 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","哈大、提玛、伊突、拿非施和基底玛。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","以上是以实玛利的儿子，他们所住的村庄和营地都以他们各自的名字命名。他们是十二部族的酋长。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","以实玛利享年137岁，气绝而死，返归列祖。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","他的后代居住在从哈腓拉到埃及以东、通往亚述的书珥一带。他们时常袭击他兄弟的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","以下是亚伯拉罕的儿子以撒的家谱。 亚伯拉罕是以撒的父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","以撒40岁那年娶利百加为妻。利百加是巴旦亚兰地的亚兰人彼土利的女儿，拉班的妹妹。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","利百加没有生育，以撒替她向主祈祷。主应允了他的祈求，他的妻子利百加就怀了孕。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","她怀的是双胞胎，两个胎儿在她腹中相争。 她说∶“为什么这些痛苦要落在我身上呢？” 她去求问主， ");
INSERT INTO cmn2006_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","主答道∶ “两国在你的腹中， 两族在你腹中就彼此敌对， 一族比另一族更强悍， 将来大的要臣服小的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","她生产的时候到了，果然生了一对双胞胎。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","第一个出来的婴儿身体发红，浑身长毛，象穿了件毛衣，因此给他起名叫以扫； ");
INSERT INTO cmn2006_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","随后又生了他的弟弟，手抓着以扫的脚后跟，因此给他起名叫雅各。两个孩子出生的时候，以撒60岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","这对孪生兄弟渐渐长大。以扫成了技艺娴熟的猎人，喜欢在田野里奔跑；而雅各好静，喜欢呆在家里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","以撒喜欢以扫，因为他爱吃以扫打回来的野味；利百加则偏爱雅各。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","有一天，雅各在家里熬红豆粥。以扫从田野里回来，又渴又饿又累。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","以扫对雅各说∶“给我点红豆粥喝吧，我饿坏了。”（因此，人们也称他为以东）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","雅各说∶“行，可你得先把长子权卖给我。” ");
INSERT INTO cmn2006_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","以扫说∶“好啦！我都快饿死了，要这长子权还有什么用！” ");
INSERT INTO cmn2006_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","雅各说∶“你得先向我起誓，把长子权让给我。”以扫就发誓，把长子权卖给了雅各。 ");
INSERT INTO cmn2006_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","雅各拿了饼子和红豆粥给以扫。以扫吃喝过后，起身走了。 以扫竟如此轻看了长子的权利。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","在亚伯拉罕时代，当地有过一次饥荒。这时又有了一次饥荒。以撒到基拉耳投靠非利士王亚比米勒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","主向以撒显现，说∶“不要到埃及去，留在我要你住的这个地方。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","你就寄居在这里，我会与你同在，赐福给你。我要把这片土地赐给你和你的后代，我要履行我跟你父亲亚伯拉罕所立的约。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","我要使你的子孙后代多如天上的繁星，我要把所有这些土地都赐给你的子孙后代，世上万国将因他们而得福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","因为亚伯拉罕服从我，遵守我所有的律条、命令和法度，一切都按我吩咐的去做。” ");
INSERT INTO cmn2006_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","于是，以撒留在了基拉耳。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","当地人问起他的妻子，他说∶“她是我的妹妹。”他不敢承认利百加是他的妻子。他想∶“如果这地方的人知道利百加是我的妻子，就会抢走她而杀死我的。”因为利百加的容貌极其动人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","以撒在那里住了很久。 一天，非利士王亚比米勒从窗户往外看，看见以撒和利百加正在亲热。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","他把以撒召来，说∶“原来她是你的妻子！你为什么说是你的妹妹呢？” 以撒说∶“如果我说她是我的妻子，我怕我会因她而死。” ");
INSERT INTO cmn2006_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","亚比米勒说∶“你对我们做的是什么事？要是我的臣民中有人跟你妻子睡了觉，你就陷我们于大罪之中了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","亚比米勒向全国颁布命令∶“谁伤害了这个人和他的妻子，就处死谁！” ");
INSERT INTO cmn2006_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","以撒在当地种庄稼。那一年丰收百倍，因为主赐福给他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","以撒富了起来，他的财富不断增加，成了一个非常富有的人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","他拥有牛群、羊群和成群的奴仆，非利士人见了非常嫉妒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","他们把以撒的父亲亚伯拉罕在世时由他仆人挖的井全都塞住，用土填死。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","亚比米勒对以撒说∶“你离开我们吧，因为你已经比我们还要强盛了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","以撒离开了那儿，在基拉耳谷安下营地，住了下来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","亚伯拉罕在世时曾挖了一些井，非利士人在他死后把这些井填死了。以撒重新挖这些井，仍然沿用当初他父亲给井所起的名。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","以撒的仆人们在谷中挖井，挖成了一口活水井。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","但是，基拉耳的牧人们与以撒的牧人争吵，说∶“这水是我们的。”于是，以撒把这口井叫作埃色，因为他们跟他争吵。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","后来，以撒的仆人又挖了一口井，他们又来为这口井争吵，所以，以撒把这口井叫作西提拿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","他离开了那地方，重又挖了一口井，这次他们没有来吵闹，所以，他把这口井叫作利河伯，他说∶“主终于使我们有了存身之地，我们要在这块土地上繁盛起来。” ");
INSERT INTO cmn2006_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","以撒离开那里来到别是巴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","当天夜里，主向他显现，说∶“我是你父亲亚伯拉罕的上帝。不要害怕，我必与你同在，赐福给你。为了我的仆人亚伯拉罕，我要使你的子孙繁盛。” ");
INSERT INTO cmn2006_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","于是，以撒在那里筑了一座坛，敬拜主，并在那里安下营地。以撒的仆人们在那里又挖了一口井。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","亚比米勒带着他的军师亚户撒和元帅非各从基拉耳来见以撒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","以撒对他们说∶“你们恨我，把我驱逐出境，为什么又来见我？” ");
INSERT INTO cmn2006_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","他们答道∶“现在我们确知主与你同在；所以，我们认为，我们彼此应该发誓，订立条约。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","你要允诺我们∶你不伤害我们，正如我们从未伤害过你，一直厚待你，后来让你平安地离开我们一样。现在你得到主的赐福了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","以撒设宴款待他们，一同吃喝。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","第二天，他们一早就起来，彼此起了誓，然后，以撒与他们道别，送他们平安地离开了营地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","就在那一天，以撒的仆人来向他报告有关挖井的事。他们说∶“我们找到水了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","以撒把这口井叫作示巴。因此，这城至今仍叫作别是巴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","以扫40岁那年娶了赫人比利的女儿犹滴和赫人以伦的女儿芭实抹。以扫的这两个妻子常使以撒和利百加心中愁烦。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","以撒年老了，两眼昏花，看不见东西。他把他的长子以扫叫到跟前，说∶“我儿啊！” 以扫答道∶“我在这儿！” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","以撒说∶“你瞧，我已经老了，说不定哪一天就会死。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","现在你带上弓箭，到田野里去打些野味来， ");
INSERT INTO cmn2006_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","照我喜欢的口味烧好，拿给我吃，好让我在死以前为你祝福。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","以扫就去野外为父亲打野味。 以撒对儿子以扫说的话，全让利百加听见了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","以扫走后，利百加对小儿子雅各说∶“我听见你父亲对你哥哥以扫说∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘去打些野味来，照我喜爱的口味作好给我吃，我要在死以前在主的面前为你祝福。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","儿啊！你听着，照着我的话去做。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","你到羊群中挑两只肥嫩的小山羊来交给我，我照你父亲喜爱的口味作好， ");
INSERT INTO cmn2006_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","你拿去给你父亲吃，这样，他就会在死前为你祝福了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","雅各对他的妈妈说∶“我哥哥浑身都是毛，我身上却是溜光。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","万一父亲摸我，发现我骗他，我不但得不到祝福，反而会招来一顿诅咒。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","他母亲说∶“儿啊！让我替你承担诅咒，你只管照我说的去做好了。去把羊羔给我取来吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","于是，雅各把羊羔牵来，交给母亲。他母亲就照他父亲喜欢的口味烧好了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","然后，利百加把大儿子以扫留在家里的最好的衣服拿给小儿子雅各穿， ");
INSERT INTO cmn2006_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","又用山羊皮包在雅各的手上和颈项光滑的地方， ");
INSERT INTO cmn2006_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","把烧好的美味和烤好的饼交给他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","雅各走到父亲那里，叫了声∶“爸爸！”父亲说∶“我在这儿。儿啊，你是谁呀？” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","雅各答道∶“我是你的长子以扫啊，我已经按你的吩咐都作好了。请坐起来吃我打来的野味吧，吃完了好给我祝福。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","以撒问∶“孩子，你怎么这么快就打到野味了？” 雅各答道∶“是主－你的上帝给了我好运气。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","以撒对雅各说∶“孩子，你近前来，让我摸摸你；你真是我儿以扫吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","雅各走近父亲。以撒摸了他，说∶“听声音象是雅各的声音，可摸手却象是以扫的手。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","雅各的手上这时也象以扫一样布满了毛，父亲辨不出这是雅各。于是，就准备为他祝福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","以撒又再问∶“你真是我儿以扫吗？”雅各答道∶“是啊！” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","以撒说∶“孩子，把野味拿过来给我吃，吃完了我就给你祝福。”雅各把肉拿给父亲，他就吃了起来，雅各又递上酒，他也喝了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","吃喝完毕，以撒对雅各说∶“儿啊，你上前来亲亲我。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","雅各走上前来，亲吻了父亲。以撒闻到他衣服上的气味，于是就祝福他说∶ “我儿身上的香气如同蒙主赐福的土地发出的香气。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","愿上帝赐你甘霖沃土，五谷美酒享用不尽； ");
INSERT INTO cmn2006_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","愿万民服侍于你，万国朝拜于你； 愿你凌驾于众兄弟之上； 愿你母亲的儿子都俯伏在你的脚下； 凡诅咒你的，必受诅咒； 凡祝福你的，必定得福。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","以撒给雅各祝福完了；雅各刚刚离开，他的哥哥以扫就打猎归来了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","他也作了美味，拿给父亲，说∶“爸爸，请起来吃你儿子打来的野味吧，吃完好给我祝福。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","以撒问∶“你是谁？” 以扫答道∶“我是你的儿子，你的长子以扫。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","听了这话，以撒全身颤抖，说∶“在你没来之前，是谁得了野味，拿来给我吃的呢？我已经吃了他拿来的东西，并且为他祝福了，他将来必定得福。这福份将永远属于他了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","以扫听了父亲的话，放声痛哭，对父亲说∶“爸爸！求你也为我祝福！” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","以撒答道∶“你弟弟用诡计欺骗了我，夺去了你的福份。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","以扫说∶“是的，怪不得他的名字叫雅各。他这是第二次欺骗我了！他曾骗走了我的长子权，现在又夺去了我的福份。”接着，他问∶“爸爸，你没有留下一些可为我祝福的吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","以撒答道∶“我已经立他作你的主人，他的兄弟都要做他的仆人；我把五谷和美酒都赐给了他。儿啊！现在我还能为你做些什么呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","以扫又对父亲说∶“爸爸，你只有一样可祝的福吗？求你也为我祝福，爸爸！”说完又放声大哭。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","于是，以撒说∶ “你的生活中没有甘霖沃土， ");
INSERT INTO cmn2006_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","你必将倚靠刀剑度日， 又必须服侍你的弟弟。 但是，当你反抗他时， 必将摆脱他的辖制。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","以扫为父亲给雅各祝福而怀恨雅各，心里说∶“爸爸快要死了，居丧过后，我就要杀死雅各。” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","有人把以扫的计划告诉了利百加，利百加就打发人把她的小儿子雅各叫来，对他说∶“你哥哥以扫想要杀死你，报仇雪恨。 ");
INSERT INTO cmn2006_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","儿啊！照我的话去做，立刻动身逃到哈兰我兄弟拉班那里去， ");
INSERT INTO cmn2006_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","在那儿同他们住些日子， ");
INSERT INTO cmn2006_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","等将来你哥哥怒气消了，忘了你对他做过的事，我再打发人把你接回来。我为什么要在一天内失去你们两个人呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","于是，利百加对以撒说∶“这两个赫人女子把我烦透了，如果雅各也娶了这儿的赫人女子，那我还不如死了好！” ");
INSERT INTO cmn2006_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","以撒把雅各叫到跟前，给他祝福，吩咐他说∶“不要娶迦南女人； ");
INSERT INTO cmn2006_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","现在你就动身去巴旦亚兰，到你外祖父彼土利家里去，在你母舅拉班的女儿中选一个为妻。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","愿全能的上帝赐福给你，让你子孙昌盛，你将成为众多民族的始祖。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","愿上帝赐福给你和你的子孙后代，就象他赐福给亚伯拉罕一样，你将拥有你现在寄居的这块土地，也就是上帝当初赐给亚伯拉罕的土地。” ");
INSERT INTO cmn2006_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","就这样，以撒打发雅各上了路，到巴旦亚兰的拉班那里去。拉班是亚兰人彼土利的儿子，雅各和以扫的母亲利百加的哥哥。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","以扫见以撒给雅各祝福，打发他到巴旦亚兰去娶妻，又听到以撒给雅各祝福时吩咐他不可娶迦南女子为妻； ");
INSERT INTO cmn2006_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","雅各听从父母的话，到巴旦亚兰去了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","以扫这才明白，他父亲以撒不喜欢迦南女人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","于是，以扫到亚伯拉罕的儿子以实玛利那里，又娶了他的女儿玛哈拉为妻。玛哈拉是尼拜约的妹妹。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","雅各离开了别是巴，前往哈兰。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","夜幕降临时，他到了一个地方，就在那里过夜。他就地搬了一块石头，枕在头下，躺下去就进入了梦乡。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","梦境中，他看见一架梯子从地面直通到天上，许多上帝的天使在梯子上面上上下下， ");
INSERT INTO cmn2006_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","又看见主站在他身旁，对他说∶“我是主，是你祖先亚伯拉罕的上帝和你父亲以撒的上帝，我要把你躺卧着的这块土地赐给你和你的子孙后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","你的后代必将多如地上的尘粒，他们将遍布四面八方，世上的万族必因你和你的后代而得福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","我将与你同在，无论你走到哪里，我都会保佑你，并且将把你带回到这块土地上来；我决不离弃你，我将实现对你的所有允诺。” ");
INSERT INTO cmn2006_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","雅各从梦中醒来，说∶“主必定就在这地方，我竟不知道。” ");
INSERT INTO cmn2006_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","他心中畏惧，说∶“这真是个令人畏惧的地方！这里必定是上帝的居所，也是天庭的门户。” ");
INSERT INTO cmn2006_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","第二天一早，雅各起来，把枕在头下的石头立作柱子，在柱子上膏油，敬献上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","并给那地方起名叫伯特利；而那里先前叫作路斯。 ");
INSERT INTO cmn2006_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","雅各许愿说∶“如果上帝与我同在，保佑我旅途平安，赐给我衣食， ");
INSERT INTO cmn2006_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","并让我平安地回到父亲的家园，那么，主就是我的上帝， ");
INSERT INTO cmn2006_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","我立石柱的地方将成为敬拜上帝的圣所，我将把上帝赐给我的一切敬献十分之一给上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","雅各继续赶路，来到东方人的地界。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","他看见田野里有一口井，三群羊卧在井旁边。牧人们饮羊要用的这井的井口上盖着一块大石头。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","羊群到齐了之后，牧人们才推开井口上的石头，给羊群饮水。饮完之后，再把石头转回原处，盖在井口上。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","雅各问他们∶“弟兄们，请问你们从哪里来？” 他们回答∶“我们是从哈兰来的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","雅各又问∶“你们认识拿鹤的孙子拉班吗？” 他们答道∶“我们都认识他。” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","雅各问∶“他还好吧？” 他们答道∶“他很好；看，他的女儿拉结赶着羊群过来了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","雅各说∶“瞧，日头还高着呢，还不到赶羊入圈的时候，饮完羊群以后再去放牧一会儿吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","牧人们说∶“我们得等羊群都到齐了之后才能给羊饮水。那时，我们一起动手把井口上的石头推开，才能给羊饮水。” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","雅各正与牧人们说话的时候，拉结赶着她父亲的羊群走过来了。她是个牧羊女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","雅各一看见他母舅拉班的女儿拉结和他的羊群，就上前去推开了井口上的石头，给拉班的羊群饮水。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","随后，他吻了拉结，放声大哭。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","哭过之后，他告诉拉结∶他是她爸爸的外甥，是利百加的儿子。拉结跑回去告诉了父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","拉班听说他妹妹的儿子雅各来了，赶紧跑出来迎接，拥抱他，亲吻他，把他带回自己家里。雅各把一切经过都告诉了拉班。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","拉班说∶“你果真是我的骨肉之亲！”雅各在那里住了一个月。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","拉班对他说∶“怎么能因为你是我的至亲就让你白白地替我干活呢？告诉我，你要多少工钱？” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","拉班有两个女儿，大女儿名叫利亚，小女儿名叫拉结。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","利亚的眼睛没有神气，而拉结却生得身段窈窕，容貌俊秀。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","雅各爱上了拉结；他对拉班说∶“如果你答应把小女儿拉结嫁给我，我可以替你做七年工。” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","拉班说∶“对我来说，把她嫁给你比嫁给任何别的人都强。你就留在我这里吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","于是，雅各为了拉结替拉班做了七年工。因为他深爱着拉结，所以这七年对他来说似乎只是几天而已。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","七年之后，雅各对拉班说∶“把拉结嫁给我吧！期限已经到了，我可以和她同房了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","于是，拉班遍请当地居民，大摆筵席。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","但是，到了晚上，拉班却把大女儿利亚送到雅各的房里；雅各跟她同了房。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","拉班把使女悉帕陪送给利亚做使女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","第二天一早，雅各才发现是利亚。他去质问拉班∶“你为什么要这样对待我？我是为了拉结才替你做这七年工的。你为什么欺骗我？” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","拉班说∶“按这里的习俗，妹妹不能先于姐姐出嫁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","如果你肯再为我做七年工，等一周的新婚庆典之后，我就把小女儿也嫁给你。” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","雅各同意了。与利亚的一周婚典过后，拉班把小女儿拉结也嫁给了雅各， ");
INSERT INTO cmn2006_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","同时又把使女辟拉陪送给拉结作侍女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","雅各与拉结也同了房，并且爱拉结胜过爱利亚。他又替拉班做了七年工。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","主看见利亚被冷落，就使她能生育而拉结不能生育。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","利亚怀孕，生了个儿子，起名叫吕便。她说∶“主看到我的苦情，使我有了儿子，现在丈夫一定会爱我了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","以后利亚又怀孕，生了个儿子。她说∶“主听到我被冷落，所以又赐给我这个儿子。”她给孩子起名叫西缅。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","她又怀孕，生了个儿子。她说∶“这一下我丈夫一定会亲近我了，因为我给他生了三个儿子。”因此，她给这个孩子起名叫利未。 ");
INSERT INTO cmn2006_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","她又怀孕，生了个儿子。她说∶“这一次，我要赞美主！”因此，她给孩子起名叫犹大。此后，她停止了生育。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","拉结见自己没有给雅各生孩子，就妒嫉她姐姐，对雅各说∶“你给我孩子，不然的话我就寻死！” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","雅各对拉结很生气，说∶“难道我是上帝吗？是上帝使你不能生育的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","拉结说∶“瞧，我的使女辟拉在这里，你跟她睡觉，让她替我生孩子；这样，我就可以由她那里得到孩子了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","于是，拉结把使女辟拉给了丈夫作妾；雅各与她同房， ");
INSERT INTO cmn2006_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","她怀了孕，给雅各生了一个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","拉结说∶“上帝给我伸了冤，他垂听我的祈祷，赐给我一个儿子。”因此，她给孩子起名叫但。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","辟拉又怀孕，生了第二个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","拉结说∶“我跟姐姐相争，终于赢了。”于是，她给这个孩子起名叫拿弗他利。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","利亚见自己停止了生育，也把自己的使女悉帕送给丈夫作妾。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","悉帕给雅各生了一个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","利亚说∶“我真幸运！”因此，她给孩子起名叫迦得。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","利亚的使女给雅各生了第二个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","利亚说∶“我有福啊，众女子都会称赞我有福！”因此，她给孩子起名叫亚设。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","在收割小麦的季节，吕便在田野里找到一些催情果，带回来交给他的母亲利亚。拉结看见了，对利亚说∶“请把你儿子采的催情果给我一些吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","利亚说∶“你夺走了我的丈夫还不够，还要夺走我儿子的催情果吗？”拉结说∶“好吧，为了你儿子的催情果，今晚我把雅各让给你。” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","到了晚上，雅各从田里回来，利亚迎上去说∶“今晚你要跟我同房，我已经为你付出了我儿子的催情果了。” 当晚，雅各与利亚同房。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","上帝垂听利亚的祷告，使她怀了孕，给雅各生了第五个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","利亚说∶“上帝给了我报偿，因为我把自己的使女给了丈夫。”因此，她给孩子起名叫以萨迦。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","利亚又怀孕，给雅各生了第六个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","她说∶“上帝赐给我贵重的礼物，现在我丈夫一定会厚爱我，因为我给他生了六个儿子。”因此，她给孩子起名叫西布伦。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","后来，她又生了一个女儿，起名叫底拿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","上帝顾念拉结，垂听了她的祈祷，使她也能生育。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","她怀了孕，生了一个儿子，说∶“上帝为我雪耻了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","她给孩子起名叫约瑟。她说∶“愿主再给我增添一个儿子。” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","拉结生了约瑟之后，雅各对拉班说∶“请让我回故乡迦南地去吧， ");
INSERT INTO cmn2006_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","请准我带着妻儿一起回去，我为你做了这么多年的工，我的妻儿就算是我替你工作的报偿。请让我走吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","拉班答道∶“请听我说几句。我占卦算定，主是为了你才赐福给我的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","他接着又说∶“请告诉我，你要多少工钱，我一定照付不误。” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","雅各说∶“我是怎样为你工作的，你的牛群、羊群在我的看顾下是怎样繁殖起来的，你一清二楚。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","在我没到这里之前，你的牲畜少得可怜，现在，你牛羊成群；主因为我到了这里才赐福给你的。现在，我难道不该为自己的家业筹划了吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","拉班说∶“我该怎样酬答你呢？” 雅各说∶“什么你也不必给我，只要你能应承我一件事，我就可以继续看管你的羊群。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","今天，我要走遍你的羊群，把所有有斑点、有条纹的绵羊及黑色的羊羔，还有山羊里有斑点、有条纹的挑出来，将来这一等的羊就算是我的工钱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","这样，我就可以证明自己的诚实。以后你来检查我的工钱时，要是在我的羊群中发现没有斑点、没有条纹的山羊或不是黑色的绵羊，那就算是我偷的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","拉班说∶“好！就照你说的办吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","但是，就在当天，拉班把有斑点、有条纹的公山羊和有斑点、有条纹及杂有白色的母山羊以及所有黑色的绵羊都挑了出来，交给他的儿子们看管， ");
INSERT INTO cmn2006_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","带到远离雅各有三天路程的地方，而雅各仍留在当地照看拉班其余的羊群。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","雅各砍了一些白杨树、杏树和梧桐树的嫩枝，剥掉一部分树皮，使树枝显露出青白交错的纹理。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","然后，他把剥好的树枝插在羊群前面的饮水槽里，羊群来喝水时就在那里交配。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","羊在这种树枝前交配，生下的小羊都是有斑点、有条纹的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","雅各把这些有斑点、有条纹的羊从羊群中挑出来，不使自己的羊与拉班的羊混杂。雅各用这种方法繁殖自己的羊群，并把自己的羊群和拉班的羊群分开来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","当强壮的羊交配时，雅各就把那些花皮树枝插在它们面前的水槽里，让它们在那些树枝前交配。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","当瘦弱的羊交配时，就不插树枝。这样一来，瘦弱的羊都归了拉班，肥壮的羊都归了雅各。 ");
INSERT INTO cmn2006_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","于是，雅各越来越富，拥有了许多羊群、男女奴仆、骆驼和驴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","雅各听到拉班的儿子们说∶“雅各抢走了理应属于我们父亲的一切。他的所有财产都是靠我们父亲的家业才获得的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","雅各也发现拉班对他的态度与以前有些异样。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","主对雅各说∶“回到你祖先的土地和你的家人那里去吧，我必与你同在。” ");
INSERT INTO cmn2006_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","于是，雅各派人叫拉结和利亚到田野里他放羊的地方去， ");
INSERT INTO cmn2006_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","对她们说∶“我发觉你们的父亲对我不象从前那样友善了，但我父亲的上帝始终与我同在。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","你们也知道，我一直竭尽全力替他工作， ");
INSERT INTO cmn2006_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","可他却欺骗我，十次改了我的工钱；然而上帝却不容他损害我。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","如果他说∶‘有斑点的羊是你的工钱’，羊群就都生下有斑点的羊羔；如果他说∶‘有条纹的羊是你的工钱’，羊群就都生下有条纹的羊羔。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","“上帝就这样把你们父亲的羊群拿来赐给我了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","在羊群交配的季节，我做过一个梦，在梦中我看见交配的公羊都是有斑点、有条纹的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","天使在梦中呼唤我说‘雅各！’我答道∶‘我在这里！’ ");
INSERT INTO cmn2006_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","天使说∶‘你看一看，所有交配的公羊都是有斑点、有条纹的，因为我知道拉班对你所作的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","我就是伯特利的上帝，在那里，你曾在石柱上膏油敬拜我，向我许了愿。现在，你动身离开这里，回到你亲人们的家园去吧！’” ");
INSERT INTO cmn2006_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","拉结和利亚答道∶“在父亲家里，还有我们可得的份儿吗？还有我们的产业吗？ ");
INSERT INTO cmn2006_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","我们不是一直被他视为外人吗？他卖了我们，又吞没了我们的身价。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","所以，上帝从父亲手里夺走的财产是属于我们和我们子女的。现在，你就按照上帝所吩咐的去做吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","于是，雅各整顿好行装，让妻妾和孩子们骑上骆驼， ");
INSERT INTO cmn2006_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","赶着畜群，带着在巴旦亚兰挣得的所有财产，前往迦南地他父亲以撒那里去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","当时，拉班出去剪羊毛去了，拉结趁机偷了一些父亲的家族神像。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","雅各不辞而别，背着拉班悄悄地离开了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","他带着自己的一切匆匆离开那里，渡过幼发拉底河向基列山地进发。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","第三天，有人告诉拉班，雅各已经逃走了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","拉班带着族人，追了七天才在基列山地那里追上雅各。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","当天晚上，上帝托梦给拉班，警告他说∶“当心！不许威胁雅各！” ");
INSERT INTO cmn2006_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","拉班追上了雅各。雅各在山上扎营，拉班在基列山地扎营。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","拉班对雅各说∶“你为什么要这样做？你欺骗我，把我的女儿象俘虏一样带走！ ");
INSERT INTO cmn2006_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","你为什么要瞒着我偷偷地溜走？要是你事先告诉我，我会高高兴兴地送你走，用铃鼓、竖琴伴着歌唱欢送你。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","你不让我吻别我的外孙和女儿，你这样做真是蠢透了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","现在你落在我的手里，我本可以处置你，但是，昨夜你父亲的上帝对我说不许我威胁你。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","既然你思乡心切，一定要走，那就走吧！只是为什么要偷走我的家族神像呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","雅各答道∶“我不辞而别，是因为害怕你会把你的女儿从我手里夺走。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","你要是在谁身上发现了你的神像，就杀死他！让我们的亲戚们当场作证，你在我这里如果认出什么东西是你的，你尽管拿去。”雅各并不知道拉结偷了神像。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","于是，拉班开始搜查，他进了雅各、利亚和两个妾的帐篷，但什么也没找到。接着，他从利亚的帐篷出来，走进了拉结的帐篷。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","拉结偷了神像，把它们藏在骆驼的鞍子底下，自己坐在鞍子上。拉班找遍整个帐篷也没找到。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","拉结对父亲说∶“我主，请别生我的气。我正在经期，不便在你面前站起来。” 拉班搜了一遍，没有找到他的家族神像。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","雅各怒气冲冲地责问拉班∶“我到底犯了什么罪，犯了什么法，值得你这样追赶我？ ");
INSERT INTO cmn2006_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","你已经搜遍了我所有的一切，找到你家的东西了吗？把它们摆出来放在你我亲戚们的面前，让大家给我们两个评评理。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","我在你家里呆了二十年，你的母绵羊和母山羊没有掉过胎，你的公羊我没有吃过一只。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","羊被野兽咬死了，我没有带去给你看，而是自己赔偿；无论白天还是黑夜，羊被偷了，你都要我包赔。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","炎热的白天搞得我精疲力竭，寒冷的夜晚使我整夜不得安睡。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","我在你家呆了二十年；为娶你的两个女儿替你工作了十四年，为了羊群工作了六年，你又十次改了我的工钱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","要不是我祖先的上帝，就是亚伯拉罕的上帝和以撒的敬畏与我同在，你如今必定打发我空手而归了。但是，上帝看到了我的苦情和我的辛劳，就在昨天夜里，他谴责了你。” ");
INSERT INTO cmn2006_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","拉班答道∶“女儿是我的女儿，外孙是我的外孙，羊群也是我的羊群。你眼前的一切都是属于我的。但是，今天我该拿我的这两个女儿和她们的孩子怎么办呢？ ");
INSERT INTO cmn2006_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","这样吧，让我们两个立个约，还要以物为证。” ");
INSERT INTO cmn2006_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","于是，雅各搬来一块石头，立作柱子， ");
INSERT INTO cmn2006_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","又对亲属们说∶“你们往这儿堆石头吧！”大家搬来石头，堆成一个石堆。然后，大家在这堆石头旁边吃喝起来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","拉班把这地方叫作伊迦尔撒哈杜他，雅各把它叫作迦累得。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","拉班说∶“今天，这石堆就作为你我之间立约的见证。”因此，这个地方叫作迦累得， ");
INSERT INTO cmn2006_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","又叫作米斯巴。因为他又说∶“愿主监视你我之间的誓约。我们分手以后， ");
INSERT INTO cmn2006_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","如果你虐待我的女儿，或在她们之外另娶，即使没人得知，要记住，上帝在注视着我们。” ");
INSERT INTO cmn2006_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","拉班又对雅各说∶“看一看立在你我之间的这堆石头和这根石柱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","它们是我们的见证∶我决不越过它们去侵犯你，你也不能越过它们来伤害我。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","愿亚伯拉罕的上帝和拿鹤的上帝在你我之间主持公道。” 雅各指着父亲以撒所敬畏的上帝的名起了誓。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","然后，他在山上向上帝献了祭，又邀请亲族们一起吃饭，一起在山上过了夜。 ");
INSERT INTO cmn2006_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","第二天一大早，拉班吻别他的外孙和女儿们。他祝福他们，然后回家去了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","雅各一行继续赶路。上帝的天使在路上遇见了他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","雅各看见了他们，说∶“这是上帝的军营！”于是，他把那个地方叫作玛哈念。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","雅各派人先去以东地区见他的哥哥以扫， ");
INSERT INTO cmn2006_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","吩咐他们∶“你们转告我的主人以扫，就说他的仆人雅各向他敬禀∶‘我在拉班那里寄居了一段时间，直到现在才回来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","我现在有了牛群、羊群、驴群和男女奴仆，特地打发人预先前来报知您－我的主人，祈望得到您的欢心。’” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","使者见过了以扫，回来向雅各报告∶“我们到了您哥哥以扫那里，他带了400人正要来和您会面。” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","雅各忧虑不安。他把随行的人分成两队，牲畜也分成两队。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","他暗自思忖∶“如果以扫袭击第一队的话，剩下的第二队还可以趁机逃脱。” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","雅各祷告主∶“主啊！我的祖父亚伯拉罕的上帝！我的父亲以撒的上帝！是你吩咐我：‘回你自己的家园去吧！回你自己的亲族那里去吧！我要使你繁荣昌盛起来。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","我不配领受你向仆人所施予的这一切仁慈和信实。当年我渡过约旦河的时候，只有随身的一根手杖；如今我带着两大队人衣锦还乡。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","求你救我逃脱我哥哥以扫的手吧！我怕他来攻击我们，把我们妇孺老幼全都杀光。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","你曾应许过我∶‘我要使你繁荣昌盛，你的子孙后代要多得象海滩上的沙粒一样数不胜数。’” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","雅各在那里过了一夜。他从带来的牲畜中挑选了一部分作为献给哥哥以扫的礼物∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","母山羊200只，公山羊20只，母绵羊200只，公绵羊20只， ");
INSERT INTO cmn2006_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","哺乳的母骆驼30头，各带着吃奶的小骆驼；母牛40头，公牛10头；10只公驴和20只母驴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","他把这些牲畜一群一群地分开，每群派一个仆人管理。 雅各对仆人们说∶“你们在我的前头走，各个牲畜群之间要保持一定的距离。” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","他吩咐领先的那个仆人∶“如果我哥哥以扫遇见你，问起你的主人是谁？你往哪里去？这些牲畜是谁的？ ");
INSERT INTO cmn2006_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","你要这样回答∶‘这一切都是您的仆人雅各的，这些都是他敬献给您－我的主人以扫的礼物。请看！他就在我的后面，随后就到。’” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","雅各又依次吩咐那些随后跟进的仆人∶“你们见了以扫，都要这样回答。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","你们也要说∶‘请看！你的仆人雅各就在我们的后面。’” 雅各暗想∶“我要先用这些见面礼赢得他的欢心，然后再亲自和他会面。这样，也许他能宽恕我。” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","他让仆人押着礼物先走，自己留在营中过夜。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","当夜，雅各起身，打发妻妾和十一个孩子渡过了雅博河渡口， ");
INSERT INTO cmn2006_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","然后，又打发其余的人畜全都过了河。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","最后只剩下雅各一个人。忽然，一个人来跟他摔跤，两个人一直争斗到天快亮的时候。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","那人见胜不过他，就在雅各的大腿窝上打了一下，大腿就脱了臼。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","那个人说∶“天快亮了，放我走吧！” 雅各说∶“你不祝福我，我就不放你走！” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","那人问∶“你叫什么名字？” 雅各答道∶“我叫雅各。” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","那人说∶“你的名字不要再叫雅各了，要叫以色列。因为你与上帝和人搏斗都得胜了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","雅各问道∶“请告诉我，你叫什么名字？” 那个人答道∶“何必问我的名字？”说完，他就在那里为雅各祝了福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","雅各把这地方叫作毗努伊勒。他说∶“我面对面地见了上帝，竟依然活着！” ");
INSERT INTO cmn2006_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","雅各离开毗努伊勒的时候，天已经亮了。由于大腿脱了臼，他不得不跛着脚走路。 ");
INSERT INTO cmn2006_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","因此，以色列人至今不吃大腿窝的筋，因为雅各的大腿窝的筋曾被扭伤过。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","雅各向远处了望，看见以扫带领着400人迎上来，就把子女分别交给利亚、拉结和两个妾照看。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","他让两个妾带着他们的儿子走在前面，随后是利亚和她的儿女，拉结和约瑟走在最后边。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","雅各亲自走在最前面。他走近哥哥的时侯，接连七次俯伏在地上。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","以扫急步上前迎住他，两人拥抱亲吻，都落下了泪。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","以扫看到四周的妇人和孩子，就问雅各∶“跟你来的这些人都是谁呀？” 雅各答道∶“这些孩子都是上帝恩赐给我的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","两个妾带着她们的孩子上前，向以扫下拜， ");
INSERT INTO cmn2006_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","然后利亚带着她的儿女，拉结带着约瑟也依次上前向以扫行礼下拜。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","以扫又问∶“我先前遇见的那些人是怎么回事？” 雅各答道∶“那是我献给您的礼物。” ");
INSERT INTO cmn2006_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","以扫说∶“弟弟呀！我什么都不缺，还是你自己留着吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","雅各坚持说∶“不！请你一定要收下。如果您看得起我，就请收下礼物。您这样恩待我，我如今见到您就象见到了上帝一样。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","请收下我献上的这点薄礼；蒙上帝的恩赐，我现在已经应有尽有了。” 雅各再三恳求，以扫这才把礼物收下， ");
INSERT INTO cmn2006_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","以扫提议∶“我们就动身走吧！我走在你们的前面。” ");
INSERT INTO cmn2006_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","雅各答道∶“您看，我主，我的孩子们还小，这些吃奶的小牛小羊也需要我照料。如果再赶一天的路，恐怕这些牲畜都会累死。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","请您先行一步；我们在后面慢慢地跟着，牛羊和孩子们能走多快，我们就走多快。我们在以东再会吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","以扫说∶“那么我留下一些人来护送你。” 雅各答道∶“如果你不介意的话，那也不必了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","于是，以扫当天就动身返回以东。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","雅各却前往疏割，在那里盖了住房，为牲畜搭了棚，因此，他把这个地方叫做疏割。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","就这样，雅各从巴旦亚兰一路平安地回到了迦南地的示剑城，在城东安下营地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","他花100块银子向示剑的父亲、哈抹的后代买下了安营的那块地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","雅各在那里造了一座祭坛，命名为“伊利伊罗伊以色列”。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","2","底拿是雅各与利亚的女儿。一天，底拿出去找当地的女孩儿玩，被示剑看见了。示剑是当地首领希未人哈抹的儿子。他拉住底拿，强奸了她。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","示剑迷恋上了底拿，想要娶她为妻。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","他对父亲哈抹说∶“帮我想办法把她娶过来吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","雅各听到女儿被奸污的消息，默不作声，只等在田野里放牧牲畜的儿子们回来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","示剑的父亲哈抹前来见雅各为儿子求婚， ");
INSERT INTO cmn2006_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","正巧雅各的儿子们从地里刚刚回来。他们听到妹妹被人玷污的事，又痛心又恼怒，认为示剑奸污雅各的女儿就是对以色列家族的侮辱，是不能容忍的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","哈抹对他们说∶“我的儿子示剑爱上了你们家的女儿，请把她嫁给我的儿子吧！ ");
INSERT INTO cmn2006_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","让我们两族结为姻亲∶我们可以娶你们的女孩子；你们也可以娶我们的女孩子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","让我们住在一起吧！你们可以在我们境内随意居住、作买卖和购置产业。” ");
INSERT INTO cmn2006_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","示剑也亲自向底拿的父兄们恳求∶“求你们赏脸；无论你们提什么条件我都答应。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","无论多少聘礼我都乐意照付，只是求你们把底拿嫁给我。” ");
INSERT INTO cmn2006_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","雅各的儿子们因为示剑奸污了他们的妹妹底拿，假意哄骗示剑和他的父亲哈抹。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","他们说∶“我们不能把妹妹嫁给未受割礼的人，这对于我们是个耻辱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","除非你们答应我们的条件，象我们一样每个男子都接受割礼。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","只有这样，我们才同意跟你们通婚，居留在你们境内，和你们成为一族。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","如果你们不接受我们的条件，不接受割礼，我们就带走底拿离开这里。” ");
INSERT INTO cmn2006_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","哈抹和他的儿子示剑认为这些条件合情合理。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","示剑是家族中最受宠的人，他正热恋着雅各的女儿，立刻毫不犹豫地照着提议办了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","哈抹和他的儿子示剑来到城门口，对本地的居民说∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“这些人对我们很友善，让他们住在这儿自由往来吧！瞧！我们这儿地域宽阔，足可以容纳他们。我们可以娶他们的女孩子，他们也可以娶我们的女孩子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","但是他们提出一个条件，就是我们的男子必须象他们一样接受割礼。如果我们接受这个条件，他们就同意和我们住在一起成为一族。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","我们就同意这个条件吧！让他们和我们住在一起，他们的牲畜和财产不都成了我们的了吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","全城的居民都赞同哈抹和示剑的提议。于是，全城的男子都行了割礼。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","受割礼后的第三天，全城的男子还在割礼的疼痛中时，雅各的两个儿子－也就是底拿的亲哥哥西缅和利未带着刀剑进了城。他们大肆屠戮，杀光了全城的男子， ");
INSERT INTO cmn2006_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","哈抹和他的儿子示剑也死在刀下。他们从示剑的家里带走了底拿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","大屠杀以后，雅各其余的儿子们洗劫了全城，为妹妹遭受的污辱复仇。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","他们掠走了所有的羊群、牛群、驴以及城中和田野里的一切东西， ");
INSERT INTO cmn2006_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","还掠走了所有的贵重物品和妇女儿童。 ");
INSERT INTO cmn2006_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","雅各对西缅和利未说∶“你们给我闯下祸了！住在这儿的迦南人、比利洗人都会恨我；我们人少力薄，他们一旦联合起来攻击我们，我们家族就要灭亡了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","雅各的儿子们答道∶“无论如何，我们不能让自己的妹妹被人当作娼妓玩弄！” ");
INSERT INTO cmn2006_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","上帝对雅各说∶“你到伯特利去，就住在那儿。在那里为我建一座祭坛；我就是你逃避哥哥以扫时向你显现的上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","于是，雅各对家人和所有的随从说∶“把你们带着的那些异族神象丢掉；你们要洁净自己，换上干净的衣裳。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","我们要离开这里到伯特利去。我要在那里为上帝造一座祭坛。我在患难中时，他帮助了我；无论我到哪里，他始终与我同在。” ");
INSERT INTO cmn2006_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","人们把所有的异族神象和自己所戴的耳环都交给了雅各；雅各把这些东西埋在示剑附近的橡树下面。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","随后，他们动身出发了；上帝使周围城镇的人心怀疑惧，不敢追击他们。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","雅各带领人们来到迦南地的路斯（即伯特利）， ");
INSERT INTO cmn2006_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","在那里造了一座祭坛，并把那个地方叫作“伊勒伯特利”，因为雅各逃离他的哥哥时，上帝曾在那里亲身向他显现。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","利百加的奶妈底波拉在那儿死了，埋葬在伯特利南面的橡树下。因此那树叫作“亚伦巴古”。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","雅各从巴旦亚兰回来以后，上帝再次向他显现，给他祝福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","上帝对他说∶“你现在叫雅各。今后你不要叫雅各，要叫以色列。”就这样，上帝为雅各改名为以色列。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","上帝对他说∶“我是全能的上帝，我要赐给你众多的子孙。你的子孙将创立众多的国家，你将是众多君王的祖先。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","我要把赐给亚伯拉罕和以撒的土地赐给你和你的子孙后代。” ");
INSERT INTO cmn2006_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","说完，上帝飞升而去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","雅各在上帝向他显现讲话的地方立了一根石柱，在上面浇酒和橄榄油作为祭献。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","他把这个地方叫作伯特利。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","雅各带领他的家族从伯特利出发。在离以法他还有一段路程的地方，拉结的产期到了。她难产， ");
INSERT INTO cmn2006_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","在剧烈的阵痛中挣扎；接生婆安慰她∶“坚持住！你又得了一个儿子。” ");
INSERT INTO cmn2006_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","当她快要断气的时候，给孩子起名叫便俄尼；但雅各却给孩子起名叫便雅悯。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","拉结死了，葬在通往以法他（即伯利恒）的路旁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","雅各在拉结的墓前立了一块石碑，这墓碑至今仍然可见。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","雅各继续赶路，在以得塔的南面扎下营地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","雅各家族住在那里的时候，长子吕便跟父亲的妾辟拉在一起睡觉，这件事也传到雅各耳中。 雅各共有十二个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","利亚生的儿子是∶吕便（雅各的长子）、西缅、利未、犹大、以萨迦和西布伦。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","拉结生的儿子是∶约瑟和便雅悯。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","拉结的侍女辟拉生的儿子是∶但和拿弗他利。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","利亚的侍女悉帕生的儿子是∶迦得和亚设。 雅各的这些儿子都是在巴旦亚兰出生的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","雅各来到基列亚巴的幔利，基列亚巴就是希伯伦。他的父亲以撒正住在那里，那里是亚伯拉罕和以撒寄居的地方。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","以撒活了180岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","他享受高年，寿满而终。他的儿子以扫和雅各为他下了葬。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","以下是以扫的后代（以扫即以东）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","以扫娶了二个迦南女子为妻：赫人以伦的女儿亚大，希提人祭便的孙女－亚拿的女儿阿何利巴玛； ");
INSERT INTO cmn2006_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","又娶了以实玛利的女儿－尼拜约的妹妹芭实抹。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","以扫与亚大生了儿子以利法；与芭实抹生了流珥； ");
INSERT INTO cmn2006_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","与阿何利巴玛生了耶乌施、雅兰和可拉。以扫的这些儿子都是在迦南出生的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","后来，以扫带着他的妻妾儿女和全家族的人，携带着所有的牲畜和在迦南地的财物，离开了他的弟弟雅各迁居他方。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","他们两家的产业太多了，当地的牧场养活不了这么多的牲畜， ");
INSERT INTO cmn2006_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","所以，以扫便在西珥山地居住下来。以扫就是以东。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","以扫是居住在西珥山地的以东人的祖先。以下是以扫的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","以利法是以扫与亚大生的儿子。以利法生了六个儿子∶提幔、阿抹、洗玻、迦坦、基纳斯和亚玛力（亚玛力的母亲是以利法的妾亭纳）。 流珥是以扫与芭实抹生的儿子。流珥生了四个儿子∶拿哈、谢拉、沙玛和米撒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","阿何利巴玛是祭便的孙女、亚拿的女儿，以扫与她生了三个儿子∶耶乌施、雅兰和可拉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","以下是以扫后代的各个支派。 以扫的长子以利法的子孙分为提幔支派、阿抹支派、洗玻支派、基纳斯支派、 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","可拉支派、迦坦支派和亚玛力支派。这些支派都是以扫的妻子亚大的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","以扫的儿子流珥的子孙分为拿哈支派、谢拉支派、沙玛支派和米撒支派。这些支派是以扫的妻子芭实抹的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","耶乌施支派、雅兰支派和可拉支派是以扫的妻子阿何利巴玛的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","所有这些支派都是以扫（即以东）的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","以下是原先居住在以东地区的何利人西珥的后代∶他们是罗坍、朔巴、祭便、亚拿、底顺、以察和底珊各个支派。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","罗坍是何利宗族和希幔宗族的祖先。罗坍的妹妹叫亭纳。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","朔巴是亚勒文、玛拿辖、以巴禄、示玻和阿南各宗族的祖先。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","祭便是亚雅宗族和亚拿宗族的祖先（亚拿当年在旷野为父亲放驴时找到了温泉）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","亚拿是底顺的父亲；底顺是欣但、伊是班、益兰和基兰各宗族的祖先。亚拿的女儿叫阿何利巴玛。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","以察是辟罕、撒番和亚干各宗族的祖先。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","底珊是乌斯和亚兰宗族的祖先。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","以上是西珥地区何利人的各支派，包括∶罗坍、朔巴、祭便、亚拿、底顺、以察和底珊各个支派。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","在以色列王之前，以下诸王相继统治以东∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","比拉；他是比珥的儿子，建都于亭哈巴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","比拉死后，约巴继位；约巴是波斯拉人谢拉的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","约巴死后，户珊继位；户珊是提幔地人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","户珊死后，哈达继位；哈达是比达的儿子，建都于亚未得（他在摩押地击败了米甸人）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","哈达死后，桑拉继位；桑拉是玛士利加人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","桑拉死后，少罗继位；少罗是幼发拉底河流域的利河伯人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","少罗死后，巴勒哈南继位；巴勒哈南是亚革波的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","巴勒哈南死后，哈达继位；建都于巴乌。他的妻子米希他别是玛特列的女儿、米萨合的孙女。 ");
INSERT INTO cmn2006_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","以下是以东的各个支派:亭纳、亚勒瓦、耶帖、阿何利巴玛、以拉、比嫩、基纳斯、提幔、米比萨、玛基叠和以兰。各支派的居住地以其支派的名字命名。他们都是以扫的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","雅各住在他父亲住过的迦南地区。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","以下是雅各家族的事迹。 约瑟17岁的时候经常跟着哥哥们去放羊。他给辟拉和悉帕的儿子们当帮手，也常常把他们做的坏事告诉父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","以色列（雅各）老年得子，对约瑟特别钟爱，远胜过对其余的儿子；他为约瑟做了一件漂亮的长袍。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","约瑟的哥哥们看见父亲偏爱约瑟，又忌又恨，对弟弟冷言恶语。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","约瑟做过一个梦，他把梦讲给哥哥们听，惹得他们更加恨他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","约瑟说∶“你们听听我做的梦∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","我梦见我们一起在田里捆麦子；忽然，我捆的麦捆都笔直地站立起来，你们的麦捆都围绕着我的麦捆下拜。” ");
INSERT INTO cmn2006_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","他的哥哥们责问他∶“难道你要做我们的王吗？难道你真要统治我们吗？！”他们因为他的梦和他所说的话，更加恨他了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","不久，约瑟又做了一个梦，他又把梦讲给哥哥们听，说∶“我又做了一个梦，梦见太阳、月亮和十一颗星星一齐向我下拜。” ");
INSERT INTO cmn2006_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","他把梦也讲给父亲听。父亲责备他说∶“你做的这是什么梦？难道我和你妈妈，还有你的兄弟们，都要伏在地上向你下拜吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","约瑟的哥哥们忌恨他，他的父亲却把这件事记在心里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","有一天，约瑟的哥哥们到示剑为父亲放羊。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","雅各对约瑟说∶“你的哥哥们在示剑放羊，你到他们那里去看看。” 约瑟答道∶“好！我这就去。” ");
INSERT INTO cmn2006_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","雅各吩咐他∶“你去看看你的哥哥们和羊群是不是平安无事，回来告诉我。”他在希伯伦山谷送约瑟动身去示剑。 约瑟来到示剑， ");
INSERT INTO cmn2006_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","在野外迷了路。有个人见他在野外转来转去，就问他∶“你在找什么呀？” ");
INSERT INTO cmn2006_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","约瑟答道∶“我在找我的哥哥们，请告诉我他们在哪儿放羊好吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","那个人说∶“他们已经离开这儿了。我曾听见他们说‘咱们到多坍去吧！’”于是，约瑟前往多坍，在那里找到了他们。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","约瑟的哥哥们远远地看见约瑟来了；他们趁约瑟还没有走近之前，聚在一起策划要杀害他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","他们互相煽动，说∶“瞧！那做梦的来了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","我们杀了他吧！把他的尸体丢在井里，就说他被野兽吃掉了。看他的美梦怎么实现！” ");
INSERT INTO cmn2006_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","吕便听到他们的阴谋，想把约瑟救出来；他说∶“别杀他！ ");
INSERT INTO cmn2006_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","只把他丢到井里就行了，不要动手害他的性命。”吕便嘴上这样说，为的是好把约瑟从他们手里救出来，交给父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","约瑟刚刚走到哥哥们那里，他们就一拥而上，将他抓住，剥掉了他身上那件漂亮的外衣，把他扔进了一口枯井。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","他们坐下来吃饭，忽然远远望见从基列来了一队以实玛利人，他们的骆驼满载着香料、乳香和没药，正在向埃及进发。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","犹大对兄弟们说∶“我们杀害自己的弟弟，谎报他的死讯，有什么好处呢？ ");
INSERT INTO cmn2006_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","还不如把他卖给这伙以实玛利人。我们不要下手害他，他到底是我们的兄弟、我们的亲骨肉呀！”其余的兄弟也赞同他的主意。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","当那伙米甸商人经过那里时，他们把约瑟从井里拉上来，用20块银子的身价卖给了以实玛利人，这些人就把约瑟带往埃及去了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","吕便回到井边，发现约瑟不见了。他伤心地撕裂了自己的衣服， ");
INSERT INTO cmn2006_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","回去告诉他的兄弟们说∶“孩子不见了！怎么办呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","他们杀了一只公山羊，把约瑟的那件外衣染上羊血， ");
INSERT INTO cmn2006_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","然后一起回去见他们的父亲，说∶“我们捡到了这件外衣，不知道是不是约瑟的，请您看一看。” ");
INSERT INTO cmn2006_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","雅各立刻认了出来，说∶“这是我儿子的外衣！他一定是被野兽吃掉了！约瑟被野兽撕碎了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","他悲痛欲绝，撕裂了自己的衣服，腰间围上麻布，为儿子哀痛了好多天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","他的儿女们都来安慰他，但他一点儿也听不进去，说∶“我的儿子死了，我会一直伤心到死！”雅各一直为约瑟的死哀痛不已。 ");
INSERT INTO cmn2006_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","这时，那些米甸人已经把约瑟带到埃及，卖给了埃及王的侍卫长波提乏。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","在那期间，犹大离开了他的兄弟们，和一个名叫希拉的亚杜兰人住在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","他在那里结识了迦南人书亚的女儿，娶她为妻。婚后， ");
INSERT INTO cmn2006_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","生了一个儿子，取名叫珥。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","不久，她又怀了孕，生了第二个儿子，取名叫俄南。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","后来，她又生了第三个儿子，取名叫示拉。示拉出生的时候，犹大一家正住在基悉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","犹大为长子珥娶了一个名叫塔玛的女子为妻。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","珥的行为不端，得罪了主，被主取了性命。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","犹大对俄南说∶“你去跟你的嫂嫂同床吧，也好替你哥哥传宗接代，这是你做小叔的义务。” ");
INSERT INTO cmn2006_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","俄南知道将来生下来的孩子不属他的名下，所以每次与嫂嫂同床时，都故意把精液遗在地上，不愿意为哥哥生孩子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","他的作法得罪了主，也被主取了性命。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","犹大对儿媳塔玛说∶“你先回娘家去守寡吧，等我的儿子示拉长大成人再来娶你。”犹大心中生怕示拉会象他的两个哥哥一样暴亡。就这样，塔玛回了娘家。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","岁月流逝，犹大的妻子去世了。居丧期过了以后，犹大和他的朋友亚杜兰人希拉一起到亭拿去，那里有人在为他剪羊毛。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","有人告诉塔玛∶“喂！你公公要到亭拿去剪羊毛了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","塔玛脱下孀服，用面纱蒙上脸，穿戴齐整，坐到通往亭拿的必经之路－伊拿印城门口；她知道示拉已经长大成人，却迟迟不来娶她。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","16","犹大遇见了她，见她用面纱蒙着脸，以为她是个妓女，就走近路边对她说∶“来，跟我去睡觉吧！”全然不知道她就是自己的儿媳。 塔玛问∶“你跟我睡觉，给我什么好处呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","犹大说∶“我从羊群中挑一只小山羊送给你。” 塔玛答道∶“好吧！不过你得先留点东西作抵押才行。” ");
INSERT INTO cmn2006_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","犹大问∶“你要什么东西作抵押呢？” 塔玛说∶“把你的印章、印章带和手杖留下吧！” 犹大把这些东西交给了她，和她睡了觉。塔玛由此受了孕。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","事后，塔玛仍旧回到娘家，摘掉蒙在脸上的面纱，又穿上守寡的孀服。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","犹大托朋友希拉带着小山羊去找那女人换回抵押的东西，但是希拉却找不到她。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","他向当地人打听∶“伊拿印路旁的那个妓女哪儿去了？”人们回答他∶“这地方从来没有妓女。” ");
INSERT INTO cmn2006_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","希拉回来对犹大说∶“我找不到她。当地人说那地方从来没有妓女。” ");
INSERT INTO cmn2006_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","犹大说∶“算了，那些东西就算送给她吧，别让人家笑话我们。我的确想把这只小山羊送给她，可是找不到她，也没有办法。” ");
INSERT INTO cmn2006_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","三个月过去了。有人告诉犹大∶“你的儿媳塔玛当了娼妓，还怀了孕。” 犹大怒喝∶“把她拉出来，烧死她！” ");
INSERT INTO cmn2006_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","塔玛被拉出来时托人告诉她的公公∶“就是这些东西的主人使我怀的孕，看看吧！这印章，这印章带，还有这手杖，都是谁的？” ");
INSERT INTO cmn2006_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","犹大认出了这些东西，懊悔说∶“她是对的。我本该叫我的儿子示拉来娶她的。”从此，犹大再也没有与她同床。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","到了产期，才发现怀的是双胞胎。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","生产的时候，一个胎儿先伸出一只手来，接生婆在手上系了一根红线，说∶“这一个是先出生的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","不料他又把手缩了回去，他的兄弟却先出来了。接生婆说∶“你倒先抢着出来了！”于是，给这个孩子起名叫法勒斯。 ");
INSERT INTO cmn2006_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","接着，他的兄弟也生下来了，手上系着红线，因此，起名叫作谢拉。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","约瑟被以实玛利人带到埃及，卖给了埃及王的侍卫长波提乏。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","主与约瑟同在，使他事事顺利。他住在他的埃及主人的家里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","他的主人发现主处处与约瑟同在，他做的事没有一件不成功的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","约瑟深得主人的欢心，成了他的心腹侍从，管理着家务和主人的所有产业。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","自从约瑟接管了家务，主为了约瑟的缘故，也赐福给他主人一家，他家里和田里的一切都得到主的赐福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","波提乏把家中的一切都交给约瑟管理，主人回家只管吃饭，其他事一概不闻不问。 约瑟体魄健壮，英俊潇洒； ");
INSERT INTO cmn2006_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","不久，主人的妻子看上了他。她挑逗他，说∶“来，跟我睡觉吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","约瑟拒绝说∶“我的主人把所有家产都交给我掌管，事无大小任我处置，从不加干预。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","他把管家的大权都交给了我，没有一点保留；只除了你之外－因为你是他的妻子。我怎么能作这样背信弃义的事，得罪上帝呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","尽管女主人天天用言语勾引他，约瑟始终不为所动。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","一天，约瑟到屋里办事，正巧家仆们都不在。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","女主人扯住约瑟的衣服，说∶“来！跟我睡觉吧！”约瑟挣脱她，跑到外面，衣服却被女主人抓在手中。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","她见约瑟丢下衣服跑了出去， ");
INSERT INTO cmn2006_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","就把家仆们喊来，说∶“你们看哪！我丈夫带回来的那个希伯来人要侮辱我们。他刚才进我屋里，想要对我强行非礼，我喊叫起来； ");
INSERT INTO cmn2006_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","他听到我喊叫，就把衣服丢在我的身边跑了出去。” ");
INSERT INTO cmn2006_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","约瑟的主人回到家中，他的妻子把约瑟的衣服拿给他看， ");
INSERT INTO cmn2006_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","又把编造的故事讲了一遍，说∶“你带回来的那个希伯来奴才竟然闯到我的屋里要羞辱我， ");
INSERT INTO cmn2006_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","19","我喊叫起来，他才把衣服丢在我的身边跑掉了。这就是你的那个奴才干的好事！” 约瑟的主人听了妻子的述说，勃然大怒， ");
INSERT INTO cmn2006_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","立即喝令把约瑟抓了起来，关进了王室的监狱。约瑟就在那里坐牢。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","但是，主处处与约瑟同在，赐福给他；因此，监狱长很喜欢他， ");
INSERT INTO cmn2006_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","委派他管理全监狱的犯人和监狱里的各种事项。 ");
INSERT INTO cmn2006_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","主与约瑟同在，使他事事成功。约瑟把一切管理得井井有条，监狱长什么事都不用操心了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","不久，埃及王的司酒长和膳务长冒犯了国王。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","国王发了怒， ");
INSERT INTO cmn2006_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","把两人关进了侍卫长府内的监狱，约瑟也关在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","侍卫长让约瑟服侍他们；他们在监狱里过了很长一段时间。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","一天晚上，司酒长和膳务长各做了一个梦，梦境各不相同。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","第二天早晨，约瑟来看他们，发现他们心神不安。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","约瑟问∶“你们今天是不是有什么烦恼的事？” ");
INSERT INTO cmn2006_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","他们答道∶“我们俩各做了一个梦，可惜没有人能替我们园梦。” 约瑟说∶“只有求助上帝才能解梦。请把你们的梦告诉我吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","司酒长说∶“我梦见在我面前有一棵葡萄树， ");
INSERT INTO cmn2006_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","树上长着三个枝叉，树刚刚发芽就开花了，上头的葡萄也成熟了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","我手里端着国王的酒杯，摘了葡萄，把葡萄汁挤在酒杯里。然后把酒杯交到王的手中。” ");
INSERT INTO cmn2006_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","约瑟听了对司酒长说∶“这个梦的含意是这样的∶三根枝叉代表三天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","三天之内，王要赦免你，让你官复原职，你仍会为王端酒，和先前作他的司酒长时一样。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","不过，你出狱后请记得我，帮我个忙。请在王的面前替我讲讲情，放我出狱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","我实在是从希伯来人的地方被绑架来的，在这儿也没作过什么坏事该受罚坐牢。” ");
INSERT INTO cmn2006_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","膳务长见约瑟把梦解得很园满，也对约瑟说∶“我也做了一个梦，梦见自己头上顶着三筐白面包， ");
INSERT INTO cmn2006_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","最上面的一筐盛着给王吃的各种各样烤好的食物，可是鸟儿却在吃那筐里的食物。” ");
INSERT INTO cmn2006_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","约瑟答道∶“这个梦的含义是这样的∶三个筐代表三天； ");
INSERT INTO cmn2006_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","三天之内，王要吊起你的头，把你挂在木杆上，飞鸟要来吃你身上的肉。” ");
INSERT INTO cmn2006_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","到了第三天，正是王的生日。他为臣仆们举办了一个宴会。在全体臣仆面前，他把司酒长和膳务长提了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","司酒长恢复了原先的职务，依旧给王端酒， ");
INSERT INTO cmn2006_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","膳务长却被吊死了。一切都与约瑟预言的一模一样。 ");
INSERT INTO cmn2006_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","但是司酒长并没有记着约瑟，他把约瑟忘掉了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","二年以后，埃及王做了一个梦。他梦见自己站在尼罗河畔， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","看见七头肥壮的母牛从河里上来，在岸边吃草。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","接着，七头瘦弱的母牛也从河里上来，与先前那七头肥壮的母牛一同站在河边。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","这七头瘦弱的母牛吃掉了那七头肥壮的母牛；这时，王醒了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","接着王又睡着了，又做了一个梦∶梦见一棵麦子上长了七只饱满的麦穗， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","接着又长出七只干枯的、被东风吹得枯萎的麦穗。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","这七只枯萎的麦穗把那七只饱满的麦穗吞了下去。这时，王又醒了，方知这是一个梦。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","第二天早晨起来，王烦燥不安，派人召集埃及所有的术师和占星家，把梦告诉他们，但没有一个人能为王解梦。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","这时，司酒长对王说∶“今天我才记起了自己的过错。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","从前，陛下对臣属发怒，下令把膳务长和我投入侍卫长府内的监狱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","在同一天夜里，我和膳务长各做了一个梦，梦境各不相同。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","当时，一个希伯来青年和我们囚禁在一起。他原本是侍卫长的仆人。我们把梦告诉了他；他为我们解梦，把各人梦境的含义讲给我们听， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","后来全都应验了，与他预言的分毫不差∶陛下恢复了我的职位，而把膳务长送上了绞架。” ");
INSERT INTO cmn2006_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","王派人召见约瑟。人们急忙带他出狱。约瑟修了脸，换了衣服，前来谒见王。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","王说∶“我做了一个梦，无人能解。有人荐举你，说你善能解梦。” ");
INSERT INTO cmn2006_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","约瑟答道∶“陛下，不是我会解梦，而是上帝必定会给陛下吉祥的启示。” ");
INSERT INTO cmn2006_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","王说∶“我梦见自己站在尼罗河畔， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","忽然七头肥壮的母牛从河里上来，在岸边吃草。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","接着，又有七头瘦弱的、丑陋的母牛从河里上来。我在整个埃及从未见过这么丑陋的牛。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","这些瘦弱的、丑陋的牛吞吃了那七头肥壮的牛， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","但却依然瘦弱丑陋，看不出它们曾吞下了肥壮的牛。这时，我醒了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","接着我又做了一个梦∶梦见一棵麦子上长着七只饱满的麦穗， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","跟着又长出七只干枯的、被东风吹得枯萎的麦穗， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","这些干枯的麦穗把那七只饱满的麦穗吞了下去。我把这些梦讲给术师听，可是没有人能解悟这些梦的含意。” ");
INSERT INTO cmn2006_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","约瑟对王说∶“陛下的两个梦其实是一个，它们的含意是相同的，上帝已经把他要做的事预示了陛下。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","梦中那七头肥壮的母牛代表七年，那七只饱满的麦穗也代表七年；这一点的含意是相同的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","那七头瘦弱的、丑陋的母牛和那七只干枯的、被东风吹得枯萎的麦穗则代表七个荒年。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","正如我刚才奉告陛下的，上帝已经把他要做的事预示了陛下∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","埃及全境必将有七个丰年， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","接着是七个荒年。饥荒将使埃及全境颗粒无收， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","严重的饥荒使人再也记不起从前有过的丰年。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","陛下重复地做这两个梦，这表示上帝已决意实行他的计划，并且很快就要付诸实现。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“因此，建议陛下起用精明强干的人管理国政， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","并在全国各地指派官员，在七个丰年期间征收全国收成的五分之一。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","命令各地官员在将要来临的丰年期间征集粮食，在各城建立王室粮食储备，派人管理。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","在接踵而来的七个荒年期间，这些屯粮可以供应全国臣民，免得埃及被饥荒所灭。” ");
INSERT INTO cmn2006_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","王和他的臣僚们都赞同约瑟的见解。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","王对大臣们说∶“上帝的灵与约瑟同在，没有比他再合适的人选了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","王对约瑟说∶“上帝既然把这一切都指示给你，可见没有人象你这样精明强干而又有远见了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","我将委派你掌管国政，凡我臣民都要听从你的调遣，你的权力仅仅在我之下。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","现在，我任命你为埃及的首相。” ");
INSERT INTO cmn2006_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","王从手指上摘下戒玺，戴在约瑟的手指上，又亲自给约瑟穿上精致的麻纱外袍，挂上金项练。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","王又让约瑟出行时乘坐王室的副车，仆从在车前呼喝开道。就这样，约瑟就任埃及首相，治理全国。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","王对约瑟说∶“我身为君王；但在埃及全境，没有你的许可任何人不得擅作主张。” ");
INSERT INTO cmn2006_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","王又给约瑟赐名为撒发那特巴内亚，把安城的一个祭司波提菲拉的女儿亚西纳许配给他为妻。约瑟开始出巡埃及全境。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","约瑟三十岁时开始为埃及王效劳；他离开王宫，到埃及各地视察。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","在七个丰年期间，农业丰收， ");
INSERT INTO cmn2006_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","约瑟征集粮食，在各城镇建立粮食储备，囤集从周围征集来的粮食。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","他囤集了大量的粮食，多得象海滩上的沙粒无法计量。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","在荒年来临之前，他的妻子－安城的祭司波提菲拉的女儿亚西纳给他生了两个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","约瑟说∶“上帝使我忘记了所有的苦难和我父亲的家园。”因此，他给长子取名为玛拿西。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","又说∶“上帝使我在困苦之地子孙昌盛。”因此，给次子取名为以法莲。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","埃及国内连续七年的丰收年景结束了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","如同约瑟所预言的那样，连续七年的荒年接踵而来。虽然各地都闹饥荒，埃及国内却处处有存粮。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","当埃及各地受到饥荒的威胁时，人们纷纷向王求粮。王命令他们∶“你们去见约瑟，一切听从他的安排。” ");
INSERT INTO cmn2006_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","饥荒遍及各地，埃及的饥荒也越来越严重，约瑟打开所有的粮仓，把粮食卖给埃及人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","各地的人们都到埃及来向约瑟买粮，因为到处都在闹严重的饥荒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","雅各听说埃及有粮，就对儿子们说∶“你们为什么呆在这儿束手待毙，不去想点办法呢？ ");
INSERT INTO cmn2006_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","我听说埃及那儿有粮。你们到那儿去买些粮食回来吧，免得我们大家都饿死。” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","于是，约瑟的十个哥哥动身去埃及买粮。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","雅各没有让约瑟的亲弟弟便雅悯跟他们一起去，怕他遭到意外。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","饥荒已经蔓延到迦南地区，雅各的儿子们和许多人一起去埃及买粮。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","约瑟作埃及的首相，负责把粮食卖给各地来的人们。他的哥哥们来到他的面前，向他俯伏下拜。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","约瑟一眼就认出了他们，却假装不认识，厉声问道∶“你们是从那里来的？” 他们答道∶“我们是从迦南来买粮的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","约瑟认出了他的哥哥们，他们却没有认出他来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","约瑟想起以前自己做过的梦。 约瑟对他的哥哥们说∶“你们是探子。是来刺探我们虚实的！” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","他们答道∶“阁下，不是的，我们是来买粮的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","我们都是亲兄弟，是老实本分的人，不是探子。” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","约瑟故意说∶“不对！你们就是来刺探我们虚实的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","约瑟的哥哥们说∶“阁下，我们－你的仆人们一共是十二个弟兄，都是一父所生；我们的父亲住在迦南，最小的弟弟现在和父亲在一起，还有一个弟弟已经死了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","约瑟说∶“我再说一遍∶你们是探子！ ");
INSERT INTO cmn2006_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","我要考验考验你们。我指着王的性命发誓，除非你们把最小的那个弟弟带到这里来，否则就休想离开这儿！ ");
INSERT INTO cmn2006_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","你们派一个人回去把小弟弟领来，其余的人关在监狱里，以此检验你们所说的是不是实话。否则，我以王的性命发誓，你们就是探子！” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","他把他们监禁了三天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","第三天，约瑟对他们说∶“我是敬畏上帝的，你们照我的话去做，我就饶了你们的性命。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","如果你们真是诚实本分的人，就留下一个人在监狱里，其余的人可以回去，把买的粮食带回去分给饥饿的家人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","然后，把你们的小弟弟带来见我。这样就能证明你们讲的是实话，我就饶你们不死。” 他们答应了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","互相抱怨说∶“我们准是遭报应了！当初我们害了自己的亲弟弟，眼看着他受苦受难。他苦苦哀求，我们却不理不睬，现在该我们受罪了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","吕便对他们说∶“我劝过你们不要害那孩子，可你们就是不听；现在，得偿还这笔血债了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","他们不知道约瑟能听懂他们的话，因为约瑟跟他们说话时都有人翻译。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","约瑟听了他们的对话，转身离去，痛哭了一阵，又返回来拉出西缅，当着他们的面把他捆绑起来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","约瑟吩咐手下人把他哥哥们的袋子装满粮食，把钱放回各人的袋子里，又为他们准备好路途上的食物，一切都安排齐全。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","兄弟们把粮食驮在驴背上，动身回家。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","晚上宿营的时候，有人打开口袋，要拿些粮食喂驴，发现自己的钱就放在口袋里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","他把这事告诉他的兄弟们，说∶“我的钱又回来了！就在我的口袋里！”他们吓得心惊胆战，面面相觑，说∶“上帝为什么要这样对待我们呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","他们回到迦南地，见了父亲雅各，把事情的经过一五一十地告诉了他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","他们说∶“埃及首相对我们正言厉色，硬说我们是探子，把我们全都关进了监狱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","我们说∶‘我们不是探子，是老实本分的人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","我们十二个兄弟都是一父所生。有一个弟弟死了，最小的弟弟如今和父亲一起留在迦南。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","首相说∶‘我要看看你们是不是诚实的人。留下一人在这儿，其余的人把粮食带回去给家里挨饿的人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","然后，把最小的弟弟带到我这里来。这样，我才能相信你们是诚实的人，不是探子。我会释放你们的兄弟，还允许你们在这儿作生意。’” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","兄弟们把粮食倒出来的时候，发现各人的钱都在自己的口袋里。他们和他们的父亲看见这些钱，都很害怕。 ");
INSERT INTO cmn2006_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","雅各对他们说∶“你们要使我失掉所有的儿子了！约瑟完了，西缅也完了，你们又要带走便雅悯！所有不幸的事都降临到我的头上了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","吕便对父亲说∶“把便雅悯交给我吧，我保证把他带回来，如果带不回来，你就杀了我的那两个儿子。” ");
INSERT INTO cmn2006_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","雅各说∶“我不能让他跟你们去！他的亲哥哥死了，如今只剩下他孤零零的一个人。万一他在路上出了意外，那就是你们把白发苍苍、满怀悲哀的老父亲送下了地狱了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","迦南地的饥荒极其严重。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","雅各一家吃完了从埃及买回来的粮食。 雅各对儿子们说∶“你们再去买些粮食吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","犹大对父亲说∶“那个人严厉地警告我们∶‘你们要是不把你们的小弟弟带来，就别想来见我。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","你要是准许小弟弟和我们一道去，我们就去替你买粮。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","你要是不答应的话，我们也去不成。因为那个人说过如果小弟弟不和我们一道去，就不准我们去见他。” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","雅各说∶“你们为什么要这样害我？为什么要告诉那个人你们还有一个弟弟呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","他们答道∶“那个人仔仔细细地询问我们和我们家里的情况∶‘你们的父亲还在吗？你们还有别的兄弟没有？’我们也都一一据实回答。我们怎么知道他会要我们把小弟弟带去呢？” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","犹大对父亲说∶“把孩子交给我吧，我们立刻就出发去买粮，好让我们这一家老小，包括我们和你，还有我们的孩子，都不至饿死。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","我担保这孩子的安全，愿意负全部责任。如果我不能把他平安地带回来，情愿终生承受罪罚。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","要不是耽误，我们已经往返两次了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","雅各说∶“如果非这样不可的话，也只好听天由命了。你们带些本地上好的土产，如乳香、蜂蜜、香料、没药、榧子和杏仁等当作礼物送给那位首相， ");
INSERT INTO cmn2006_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","还要带上双倍的钱，把上次在袋子里发现的钱还给人家，那可能是弄错了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","你们带上小弟弟，赶快去见那个人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","愿全能的上帝使他大发慈悲，让便雅悯和西缅同你们一道回来。至于我，要是该丧子，也只好认了。” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","于是，他们带了礼物和双倍的钱，和便雅悯一道起身往埃及去见约瑟。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","约瑟看到便雅悯和他们一起来了，就吩咐管家∶“把这些人领到家里去。你去宰一头牲畜，备好筵席，我要和他们共进午餐。” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","管家遵命把他们都带到约瑟的家里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","约瑟的兄弟们被带进了屋，心里害怕，想∶“一定是为了上次口袋里的那些钱才把我们带到这儿来，或许他要袭击我们，抢走我们的驴，强迫我们做他的奴隶。” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","他们去见管家，在屋门口恭恭敬敬地对他说∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“先生，我们上次到这里来买过粮。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","可是，在回家的路上过夜歇息时发现自己的钱都还在自己的口袋里，分文不差。现在，我们把这些钱带了回来， ");
INSERT INTO cmn2006_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","又另带了这次买粮的钱。我们确实不知道上次是谁把钱放回我们的袋子里的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","管家安慰他们，说∶“你们不要疑虑，也不要害怕。你们的钱我早就收下了。你们口袋里的银子一定是你们的上帝－你们祖先的上帝赐给你们的财宝。” 随后，他把西缅带出来交给他们。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","管家把他们带进屋子，给他们打水，让他们洗脚，又叫人喂好他们的驴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","约瑟的哥哥们把礼物准备好，等候中午约瑟回来的时候献给他，他们已经得知约瑟要和他们一起吃午饭。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","约瑟回到家里，兄弟们献上礼物，一齐倒身下拜。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","约瑟问他们好，又问∶“你们向我提起过的老父亲，他可安好？还健在吧？” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","他们答道∶“是的，阁下，我们－您的仆人的老父亲很好，他还健在。” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","约瑟看见自己的同胞弟弟便雅悯，又问∶“这就是你们告诉过我的那个小弟弟吗？愿上帝赐福给你，我的孩子！” ");
INSERT INTO cmn2006_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","说完，约瑟急忙离开房间。他看见自己的弟弟已经长大成人，几乎克制不住自己的感情，险些当众哭了出来。他回到自己的房间，哭了一阵； ");
INSERT INTO cmn2006_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","他洗了脸再出来，抑制住自己的感情，吩咐开宴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","约瑟自己坐一席，他的兄弟们坐一席，陪宴的埃及人另有一席，因为埃及人极不愿意跟希伯来人同桌吃饭。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","约瑟让众兄弟面对着他坐席，按照长幼次序排定坐位，众兄弟愕然对望，不知这样安排是什么意思。 ");
INSERT INTO cmn2006_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","约瑟命令仆人把他桌上的食物分出来送给他的兄弟们，便雅悯的那一份比其他的兄弟多五倍。他们与约瑟欢宴畅饮，快乐非常。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","约瑟吩咐他的管家∶“你把他们的粮食袋子尽量装满，把各人的钱放回袋子里， ");
INSERT INTO cmn2006_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","再把我的银酒杯放在那个最年轻的希伯来人的袋子里。”管家照办了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","第二天一早，兄弟们赶着驴起身了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","他们刚出城不远，约瑟就吩咐管家说∶“你立刻去追这些人！追上以后就质问他们∶‘你们为什么以怨报德，偷走我主人的银酒杯？ ");
INSERT INTO cmn2006_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","这酒杯是他喝酒用的，也是占卦用的，你们闯下大祸了！’” ");
INSERT INTO cmn2006_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","管家追上了他们，把约瑟吩咐他的话说了一遍。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","他们答道∶“先生，你的话到底指什么呢？我们从来没做过这种事！ ");
INSERT INTO cmn2006_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","我们上次在袋子里发现了那些钱，这次还特地从迦南带回来，奉还给你们，怎么会偷你主人家的金银呢？ ");
INSERT INTO cmn2006_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","先生，如果你发现我们当中有谁藏着那个酒杯，就把谁处死，我们其余的人也情愿作你们的奴隶。” ");
INSERT INTO cmn2006_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","管家说∶“好吧，我同意。不过我只要那偷走酒杯的人做我们的奴隶，其余的人是无辜的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","大家很快把口袋从驴背上卸下来，打开口袋。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","管家从最年长的哥哥开始依个搜查，一直查到最年幼的便雅悯，结果在便雅悯的袋子里发现了酒杯。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","兄弟们悲痛地撕裂衣服，把口袋放在驴背上，和管家一起回到城里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","犹大和兄弟们到了约瑟家，约瑟还在那里，他们向他跪拜请罪。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","约瑟对他们说∶“你们竟然干出这种事！难道不知道象我这样有地位的人，能够占卜未知吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","犹大说∶“阁下，事已至此，我们也无话可说。人赃俱在，我们还能喊冤叫屈吗？上帝昭示了我们的罪！现在，我们和那偷走酒杯的人都是阁下的奴隶了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","约瑟说∶“不！我不是这个意思。我只要偷酒杯的人留下做我的奴隶，你们其余的人都可以平安地回到你们的父亲那里去。” ");
INSERT INTO cmn2006_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","犹大走上前去，向约瑟恳求说∶“阁下，请允许我－您的仆人陈述衷情。你的权势偕比王侯，求你不要对我－您的仆人发怒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","上次阁下曾经问我们∶‘你们是不是还有父亲或其他的兄弟？’ ");
INSERT INTO cmn2006_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","我们回答∶‘我们有一位年老的父亲和年幼的小弟弟，这个小弟弟是我们父亲年老的时候生的。他的同胞哥哥死了，他是他们生母留下来的唯一的孩子，所以，父亲格外疼爱他。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","阁下吩咐我们把他带来，让你亲眼看看， ");
INSERT INTO cmn2006_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","我们向阁下说过，这孩子不能离开他的父亲，要是他不在了，他的父亲一定会死的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","可是，阁下坚持说∶‘你们如果不把小弟弟带来，就不准再来见我！’ ");
INSERT INTO cmn2006_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“我们回去见了父亲，把阁下的话告诉了他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","后来，父亲要我们再来买粮， ");
INSERT INTO cmn2006_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","我们说∶‘如果小弟弟和我们同行，我们就去；小弟弟不去，我们就无法再见到那个人。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","父亲对我们说∶‘你们知道，我的妻子拉结只给我生了两个孩子， ");
INSERT INTO cmn2006_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","一个已经离我而去，至今也没有再见过他。我想他一定是被野兽撕碎了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","如今你们又要把这一个带走，万一他在路上出了意外，那就是你们把我这白发苍苍、满怀哀痛的老人送进坟墓了！’ ");
INSERT INTO cmn2006_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“阁下，我父亲的生命跟这孩子是连在一起的，如果我们不带这孩子回去， ");
INSERT INTO cmn2006_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","他见不到这孩子，一定会没命；那就是我们把自己的老父亲送进了坟墓了！ ");
INSERT INTO cmn2006_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","因此，我向父亲担保这孩子的平安。我说∶‘要是我不能把这孩子带回来交给你，情愿终生承担罪罚。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","所以，阁下，请允许我代替我的兄弟留在这里做阁下的奴隶，让这孩子和他的哥哥们一起回去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","要是这孩子不跟我回去，我怎么见我的父亲？我不忍心看父亲遭受苦难。” ");
INSERT INTO cmn2006_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","约瑟在侍从们的面前再也无法抑制自己的感情了。他命令侍从们全都离开。他向兄弟们表明了身份，没有一个外人在场。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","可是，埃及人听到了他号啕大哭的声音。消息传进了王宫。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","约瑟对他的兄弟们说∶“我就是约瑟！我们的父亲还健在？”他的兄弟们都被吓呆了，张口结舌，答不出话来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","约瑟请他们上前来，对他们说∶“我就是你们的兄弟约瑟。就是被你们卖到埃及的约瑟。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","你们不要为这件事忧虑和自责。是上帝差遣我先到这里来，为的是拯救大家的性命。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","这地方的饥荒已经持续了两年了，还有五年的时间既不能耕种也没有收成。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","上帝差我先到这里来，就是要保全大地上一些人的性命，用这种奇异的方法拯救你们。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","所以，是上帝把我送到这里来的，而不是你们；上帝使我成为王的王室重臣和埃及的首相，治理全国。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“你们赶快回去见父亲，就说他的儿子约瑟这样告诉他∶‘上帝已经让我做了埃及的首相。不要耽误，赶快到我这里来吧！ ");
INSERT INTO cmn2006_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","你可以带着你的儿女子孙、你的牛羊和所有的家产住在歌珊地区，离我很近， ");
INSERT INTO cmn2006_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","好让我奉养你。这样，你和你的家族都不致陷入困境；因为饥荒还要持续五年之久。’” ");
INSERT INTO cmn2006_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","约瑟又说∶“瞧！现在，你们和我的弟弟便雅悯都亲眼看见，这是我－约瑟亲口对你们说的这些话。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","告诉父亲我在埃及享有的荣华，也要告诉他你们在这里亲眼看到的一切。你们赶快把他接到这里来。” ");
INSERT INTO cmn2006_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","他和弟弟便雅悯抱头大哭； ");
INSERT INTO cmn2006_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","接着，他一面哭，一面拥抱每一个哥哥，亲吻他们；然后，兄弟们聚在一起说话。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","约瑟的兄弟们到来的消息传到王宫，王和他的臣属们都非常高兴。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","王对约瑟说∶“告诉你的兄弟们，让他们装好粮食，立刻回迦南去， ");
INSERT INTO cmn2006_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","把你父亲一家人都接到这儿来。我要把全埃及最好的土地赐给他们，让他们在这儿享受富足的生活。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","吩咐他们从埃及带着车辆回去，好让他们的妻儿跟他们的父亲一起坐车来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","不要顾惜丢在那边的产业，因为全埃及最好的东西都是他们的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","雅各的儿子们都一一照办。约瑟按王的吩咐给他们备好车辆，准备了路上吃的食物。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","又送给每人一套新衣服，但是给了便雅悯五套新衣服和三百块银子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","他又送给父亲十头公驴，驮着埃及最好的东西，另有十头母驴，驮着父亲路上用的粮食、面包和其他食品。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","约瑟送走了他的兄弟们，嘱咐他们在路上不要争吵。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","就这样，他们离开了埃及，回到迦南地来见父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","他们告诉父亲∶“约瑟还活着！他现在当了埃及的首相。”老父亲目瞪口呆，不肯相信。 ");
INSERT INTO cmn2006_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","但是，他听了约瑟转告他的话，又看到约瑟派来接他到埃及去的车辆，就不再怀疑。他又兴奋又激动， ");
INSERT INTO cmn2006_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","说∶“太好了！我儿约瑟还活着。趁我还活着，一定要去看看他。” ");
INSERT INTO cmn2006_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","雅各带着他的家产动身来到别是巴。他在那里向父亲以撒的上帝献祭。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","当夜，上帝托梦给他，向他讲话。 上帝喊他∶“雅各！雅各！”雅各回答∶“我在这里！” ");
INSERT INTO cmn2006_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","上帝说∶“我是上帝，是你父亲的上帝。你不要害怕到埃及去，我将使你的子孙后代在那里成为大国。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","我要亲自和你一起到埃及去，也要亲自把你的后代从那里带回来。你死的时候，约瑟会为你合眼。” ");
INSERT INTO cmn2006_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","雅各离开了别是巴。他的儿子们让父亲和他们的妻子儿女坐在埃及王派来的车辆上。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","雅各带领着所有的子孙，带着他们在迦南地的牲畜和家产，一起向埃及进发。他的儿子、孙子、女儿、孙女以及其它子女都跟他一齐来到埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","9","以下是跟雅各一起到埃及去的以色列人的名单∶ 雅各的长子吕便和他的儿子∶哈诺、法路、希斯伦和迦米。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","西缅和他的儿子∶耶母利、雅悯、阿辖、雅斤、琐辖和少罗（少罗的母亲是迦南人）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","利未和他的儿子∶革顺、哥辖和米拉利。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","犹大和他的儿子∶示拉、法勒斯和谢拉（犹大的另两个儿子珥和俄南死在迦南）。 法勒斯的儿子∶希斯伦和哈母勒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","以萨迦和他的儿子∶陀拉、普瓦、约伯和伸伦。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","西布伦和他的儿子∶西烈、以伦和雅利。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","以上是利亚在巴旦亚兰生的子孙。此外还有女儿底拿。利亚这一支的后代共有33人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","迦得和他的儿子∶洗非芸、哈基、书尼、以斯本、以利、亚罗底和亚列利。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","亚设和他的儿子∶音拿、亦施瓦、亦施韦、比利亚和他们的姐妹西拉。比利亚的儿子是希别和玛结。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","以上是悉帕的后代。悉帕是拉班送给女儿利亚的侍女。她为雅各生的子孙共16人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","雅各的妻子拉结为他生了两个儿子∶约瑟和便雅悯。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","约瑟的妻子亚西纳生了两个儿子∶玛拿西和以法莲。亚西纳是安城祭司波提菲拉的女儿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","便雅悯的儿子∶比拉、比结、亚实别、基拉、乃幔、以希、罗实、母平、户平和亚勒。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","以上是拉结生的子孙。拉结这一支的后代共14人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","但和他的儿子户伸。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","拿弗他利和他的儿子∶雅薛、沽尼、耶色和示冷。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","以上是辟拉的后代。辟拉是拉班送给女儿拉结的侍女。她为雅各生的子孙共7人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","跟雅各一起到埃及的直系子孙，不包括儿媳，共66人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","加上约瑟在埃及生的两个儿子，雅各家族初到埃及时的人口共70人。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","雅各派犹大先去见约瑟，约定在歌珊会面。雅各到了歌珊， ");
INSERT INTO cmn2006_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","约瑟驱车前来迎接父亲。他们见了面，约瑟抱着父亲大哭一场。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","雅各对约瑟说∶“我亲眼看见你还活着，死也瞑目了！” ");
INSERT INTO cmn2006_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","约瑟对他的兄弟们和他父亲家里其他的人说∶“我必须向王禀报：‘我的兄弟们和父亲一家人已经从迦南地搬到这里来了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","他们都是牧人，以放牧牲畜为生，他们把所有的羊群、牛群和财产都带到这里来了。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","王召见你们的时候，问起你们的职业， ");
INSERT INTO cmn2006_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","你们要这样回答∶‘陛下，我们的祖先以放牧牲畜为生。’这样，王就会让你们住在歌珊地区，因为埃及人不愿与放牧牲畜的人往来。” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","约瑟求见埃及王，向王禀报∶“臣的父亲和兄弟们从迦南地带着牛羊和所有的家产到这里来了；他们现在住在歌珊地。” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","接着，他把五个兄弟引见给王。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","王问他们∶“你们是做什么的？” 他们答道∶“陛下，我们祖祖辈辈以放牧牲畜为生。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","由于迦南地饥荒严重，没有了放牧羊群的草原，特前来寻求陛下的荫庇。请陛下容许我们住在歌珊地区。” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","王对约瑟说∶“你的父亲和兄弟们已经到这里了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","埃及的土地任由他们选择。让他们就住在歌珊地吧，那里是全国最好的地区。如果他们当中有堪用之才，就派他看管我的牲畜。” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","约瑟把父亲雅各引见给王，雅各给王祝福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","王问∶“老人家有多大年纪了？” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","雅各答道∶“我浪迹人世，已经有一百三十年了。这些岁月又短促又艰辛，远不及我祖先在世的年月。” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","雅各又给王祝福，然后退了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","约瑟遵照王的命令把父亲和兄弟们安置下来，把兰塞地给他们做为产业；那是埃及国中最好的地区。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","他又给父亲、他的兄弟们和他们的全家老小都配发了粮食。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","饥荒越发严重，到处都发生粮荒。埃及人和迦南人都饿得身体极度虚弱。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","约瑟把粮食卖给他们，把卖粮所得的钱交给王宫。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","不久，埃及人和迦南人的钱都用完了；埃及人找到约瑟，向他请求∶“我们的钱用光了，请再给我们些粮食吧，你竟忍心看我们在你面前饿死吗？” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","约瑟答道∶“你们的钱用光了，那就用牲畜换粮食吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","于是，人们带来他们的牛、羊、马、驴跟约瑟交换粮食。那一年，约瑟用粮食换取了人们的所有牲畜。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","第二年，人们又来见约瑟，说∶“阁下，我们向你禀告实情，我们的钱用光了，牲畜也都给了你了。现在，除了自己的身体和土地之外，我们真的一无所有了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","你能忍心看着我们土地荒芜，人却因饥饿而死吗？求你用粮食交换我们和我们的土地吧，让王拥有我们的土地，我们也情愿作王的奴隶，替他耕种。这样，我们既可以活下去，田地也不致荒废。” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","人们饥饿难忍，纷纷出卖土地；约瑟替王收买了全埃及的土地，把百姓从边境一端的城市里迁到边境的另一端；这样，全埃及的土地都属王所有， ");
INSERT INTO cmn2006_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","全埃及的人都成了王的奴隶。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","只有祭司的土地没有被收买，因为他们从王室领取固定的生活津贴，不必出卖自己的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","约瑟对埃及的百姓们说∶“我已经替王买下了你们和你们的土地；现在，我给你们种子，供你们耕种。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","收获的时节，你们要把收成的五分之一交纳给王室，其余的五分之四留作来年的种子和你们一家老小的口粮。” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","人们答道∶“阁下，您救了我们的命，只要您喜欢，我们情愿做王的奴隶。” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","约瑟制定了一条有关埃及土地的法令∶收成的五分之一要归王所有。这条法律至今依然有效。只有祭司的土地不属于王。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","以色列人在埃及的歌珊地住了下来。他们在那里置办产业，繁衍生息，人口大大增加。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","雅各在那里住了十七年，直至147岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","他将死的时候，派人把约瑟叫到床前，对他说∶“如果你真的爱我，就把手放在我的臀下，以你的真情和诚实向我起誓∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","当我与我祖我父同睡的时候，你要把我带出埃及，葬在他们所葬的地方。” 约瑟答道∶“我一定遵照你的话去做。” ");
INSERT INTO cmn2006_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","雅各说∶“向我发誓吧！”约瑟向他发了誓；雅各在床头上敬拜了上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","过了一段时间，约瑟得到禀报，说他的父亲病了。约瑟就带着他的两个儿子－玛拿西和以法莲，前去看望父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","雅各听说约瑟来看他，勉强从床上挣扎起来， ");
INSERT INTO cmn2006_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","对约瑟说∶“全能的上帝曾在迦南的路斯向我显现，给我祝福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","他对我说∶‘我要赐给你许许多多的子孙，要使你的家族人丁昌盛，你的后代将创建众多的国，我要把这块土地赐给你的后代，作为他们永久的产业。’ ");
INSERT INTO cmn2006_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","我来埃及之前，你在这里生了两个儿子，他们要归属在我的名下，就象吕便和西缅一样。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","你其余的子女则仍属你的名下，但是他们可以从以法莲和玛拿西的产业中分得一份土地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","我从巴旦亚兰往这里来的时候，你的母亲拉结在途中死了，那是在迦南地离以法他不远的地方，我伤心万分，当时把她葬在通往以法他的那条路的路旁。”（以法他就是伯利恒）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","雅各看见约瑟的两个儿子，问∶“他们是谁？” ");
INSERT INTO cmn2006_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","约瑟答道∶“他们是我的儿子，是我到埃及以后上帝赐给我的。” 雅各说∶“你把他们带到我跟前来，我要给他们祝福。” ");
INSERT INTO cmn2006_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","雅各年纪老了，眼睛昏花，约瑟就把孩子们领到他的跟前。雅各拥抱他们，亲吻他们。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","他对约瑟说∶“每向到今生还能见到你；上帝不但使我们父子团聚，竟还使我见到了我的孙儿们。” ");
INSERT INTO cmn2006_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","约瑟把孩子从雅各的膝上抱下来，自己俯伏在父亲的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","约瑟把两个孩子领到雅各面前；右手拉着以法莲，让以法莲站在雅各的左边；左手拉着玛拿西，让玛拿西站在雅各的右边。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","雅各却双手交叉，把右手放在弟弟以法莲的头上，左手放在哥哥玛拿西的头上；而玛拿西是长子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","他祝福约瑟，说∶ “愿我的祖先亚伯拉罕和以撒所敬拜的上帝， 愿终生为我牧者的上帝， ");
INSERT INTO cmn2006_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","愿把我拯救出苦海的天使们；请你们赐福给这些孩子吧！ 让我的名字和我的祖先亚伯拉罕和以撒的名字因他们的存在而永不湮灭； 愿他们子孙昌盛，遍布四方。” ");
INSERT INTO cmn2006_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","约瑟看见父亲把右手放在以法莲的头上，心中不高兴。他拿起父亲的右手，想把它移到玛拿西的头上。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","他对父亲说∶“爸爸，你弄错了，这一个才是长子，你应该把右手放在他的头上。” ");
INSERT INTO cmn2006_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","但是，雅各却拒绝这样做，说∶“儿啊，我知道，我知道；玛拿西的后代也要成为大族，他们也会十分强大，但他的弟弟比他更强大，他弟弟的后代将创建众多的国家。” ");
INSERT INTO cmn2006_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","那一天，雅各为两个孩子祝福，说∶“以色列人将用你们的名字为人祝福。他们要说∶ ‘愿上帝使你们象以法莲和玛拿西一样。’” 就这样，雅各使以法莲名列玛拿西之先。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","雅各又对约瑟说∶“你知道，我不久于人世了。但上帝将与你们同在，他将把你们带回到祖先的土地上去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","我给你的土地要比你的兄弟们多一份，那是我亲自用剑和弓从亚摩利人手中夺得的山地。” ");
INSERT INTO cmn2006_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","雅各把他的儿子们都召集到面前，对他们说∶“你们靠拢过来，我把你们将来要遇到的事讲给你们听。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","来吧，雅各的儿子们！ 你们要仔细听着你们的父亲以色列的话。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","吕便哪，你是我的长子， 是我成人后力量与精力的首次证明。 你是我最强壮、最引以自豪的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","但是你象洪水，无法控制， 你与父亲的妾同床， 玷污了你父亲的床榻， 所以，你不再居首位。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","西缅与利未是同胞弟兄， 他们以刀剑行凶。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","我不与他们同谋，不与他们共事； 他们杀人害命以泄愤，暴虐牲畜以取乐。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","他们暴躁忿怒，该受诅咒； 他们狂暴残忍，该受惩罚。 我要使他们分散在以色列人当中， 散居在以色列全境。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","犹大啊，你的弟兄们要赞颂你。 你的手要掐住仇敌的脖子， 你的兄弟们都要向你下拜。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","犹大象少壮的狮子， 傲立在他捕获的猎物上； 他象狮子伸直身子躺卧，没有人敢惊动他。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","犹大要永握王权，王杖不离他的两脚之间。 等到真正的国王到来， 万国要向他朝拜。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","他把驴拴在葡萄树上， 把小驴拴在最好的葡萄树上， 他在葡萄酒中洗涤衣服，在葡萄汁中洗涤长袍。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","他因饮酒而双眼发红， 他因喝奶而牙齿雪白。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","西布伦将住在海边， 他是船舶平安停泊的港口， 他的疆土延伸到西顿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","以萨迦象健壮的驴， 躺卧在畜栏之间。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","他喜欢舒适的憩息处所和肥美的土地； 他情愿为此屈身负重， 成为作苦工的奴隶。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","但象以色列的其余支派一样， 统领他自己的子民。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","他象路旁的蛇， 象隐在小径中的毒蛇， 它咬住马蹄，使骑手仰翻在地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","主啊！我期待着你的拯救！ ");
INSERT INTO cmn2006_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","迦得将受到仇敌的袭击， 他要返身攻击他们。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","亚设的物产丰富， 他向君王供奉珍馐美味。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","拿弗他利象无羁无绊的母鹿， 它生下可爱的小鹿。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","约瑟象泉水旁果实累累的果树， 他的枝条攀出墙头， ");
INSERT INTO cmn2006_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","弓箭手苦害他，向他射箭， ");
INSERT INTO cmn2006_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","但他的弓依然坚硬， 他的手臂依然敏捷； 因为以色列的牧者，以色列的磐石， 你的父亲雅各的大能的上帝赐你以力量。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","你父亲的上帝会帮助你， 全能的上帝会赐福给你； 他要把天地间的福泽全都赐给你， 要使你人丁兴旺，牛马成群。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","你父亲对你的祝福啊， 比我祖先的祝福更有力， 如同永世的峻岭一样绵长。 愿这一切福泽都降临在我儿约瑟－那与众兄弟迥然有别的人的头上。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","便雅悯象凶猛的豺狼， 他清晨吞食猎物，夜晚瓜分掠夺物。” ");
INSERT INTO cmn2006_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","这就是雅各对以色列的十二支派所说的话。他按照各人的福份，用适当的话为每一个儿子祝了福。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","雅各吩咐儿子们，说∶“我快要死了，你们要把我跟我的祖先葬在一起，就是赫人以弗仑田间的那个洞里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","这个洞位于迦南地幔利附近的麦比拉，是亚伯拉罕向赫人以弗仑买下来作坟地的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","亚伯拉罕和他的妻子撒拉葬在那里，以撒和他的妻子利百加也葬在那里；我也把利亚葬在了那里。 ");
INSERT INTO cmn2006_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","那块地和地里的那个洞是从赫人那里买过来的。” ");
INSERT INTO cmn2006_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","雅各向儿子们交代完这些话，把脚放回床上躺了下来，气绝身亡。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","约瑟伏在父亲身上痛哭，吻父亲的脸。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","接着，约瑟吩咐自己的侍从医生为父亲的遗体作防腐处理，医生们一一照办。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","他们按照常例，用了40天的时间做完了尸体防腐的工作。埃及人为雅各举哀70天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","过了哀悼期，约瑟对王的臣属们说∶“请把我的话转告王∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘我父亲曾要我起誓，要我把他归葬在迦南他为自己准备的坟墓里。所以，请恩准我去安葬我的父亲，事情一办完我就回来。’” ");
INSERT INTO cmn2006_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","王回旨∶“按照你的誓言去安葬你的父亲吧！” ");
INSERT INTO cmn2006_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","约瑟动身去为父亲下葬。王的所有臣属、王室的显贵以及全埃及的有声望的人都陪同约瑟一起去。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","约瑟的全家和他的兄弟们以及雅各的全家眷属都一齐前去，只把孩子们、羊群和牛群留在歌珊地。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","车辆和骑兵也随同前往，组成一列浩浩荡荡的队伍。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","他们来到约旦河东岸的亚达禾场，在那里号啕大哭，举哀七天。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","当地的迦南人看到亚达禾场的举哀场面，说∶“埃及人的哀悼多悲伤啊！”因此，这个地方叫做亚伯麦西（这个地方在约旦河东岸）。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","雅各的儿子们遵照父亲的吩咐， ");
INSERT INTO cmn2006_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","把他的遗体运到迦南地，安葬在幔利附近麦比拉田间的洞里，那块田是亚伯拉罕向赫人以弗仑买来作坟地的。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","安葬好父亲以后，约瑟和他的兄弟们以及所有来参加葬礼的人一起返回埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","父亲死后，约瑟的兄弟们心中惶恐，因为父亲已经不在了；他们想∶“如果约瑟怀恨我们，照我们从前对待他那样来报复我们，那怎么办？” ");
INSERT INTO cmn2006_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","他们请人告诉约瑟说∶“父亲临终前交代∶ ");
INSERT INTO cmn2006_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘告诉约瑟，他的哥哥们确实伤害过他，让他宽恕了他们的罪过吧！’我们都是父亲的上帝的仆人，求你赦免了我们的罪过吧！” 听到这些话，约瑟哭了。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","约瑟的哥哥们又亲自来见约瑟，俯伏在他面前，说∶“我们都是你的奴仆。” ");
INSERT INTO cmn2006_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","约瑟告诉他们∶“你们不要害怕。我不能取代上帝的位置，我没有惩罚你们的权力。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","你们本意是要害我，但是上帝却要由此演变出今天的局面，为的是要保存这许许多多人的性命。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","你们不用害怕，我一定照顾好你们和你们的子女。”他用慈爱的话安慰他们，让他们安心。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","约瑟和他父亲的家族继续住在埃及。约瑟活到110岁。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","他在世时见到了以法莲的儿子和孙子，又把玛吉的儿子，也就是玛拿西的孙子，归到自己的名下。 ");
INSERT INTO cmn2006_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","约瑟对他的族人们说∶“我快要死了，但是上帝一定会看顾你们，他会带你们离开这里，到他应许给亚伯拉罕、以撒和雅各的那块土地上去。” ");
INSERT INTO cmn2006_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","约瑟又让以色列的子孙们发誓，说∶“当上帝带你们离开这里的时候，你们一定要把我的骸骨一起带走。” ");
INSERT INTO cmn2006_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","约瑟死了，享年110岁。人们为他的遗体作了防腐处理，在埃及装殓入棺。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","雅各的儿子们带着家眷，与雅各一同来到埃及。他们的名字是∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","吕便、西缅、利未、犹大、 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","以萨迦、西布伦、便雅悯、 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","但、拿弗他利、迦得、亚设。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","他们都是雅各的直系子孙，总共七十人。约瑟已经在埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","后来，约瑟和他的兄弟们及其同辈人都相继去世。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","他们的后代繁衍众多，民力强盛，遍及埃及全国。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","后来，埃及一个新王即位。他对约瑟的事绩一无所知。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","他对埃及人说∶“以色列人的数量和力量都胜过了我们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","我们要想办法对付他们，不能让他们的人口继续增加。否则，一旦发生战争，他们有可能与敌人联合起来攻打我们，逃离我们的国土。” ");
INSERT INTO cmn2006_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","于是，埃及人派监工辖制他们，强迫他们服苦役，让他们为埃及王建造比东和兰塞这两座积货城。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","然而，埃及人越虐待以色列人，以色列人的人口增加得就越快，他们的人数越来越多，使埃及人深感不安。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","他们更加严酷地奴役以色列人， ");
INSERT INTO cmn2006_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","用繁重的劳动压迫他们，让他们和泥造砖，在田里干各种各样的活儿，使他们生活得极其艰难。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","埃及王又吩咐两个希伯来的接生婆－一个叫施弗拉，另一个叫普阿，说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“你们为希伯来妇女接生时，凡是男婴都必须弄死，只让女婴活下来。” ");
INSERT INTO cmn2006_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","但是，这两个接生婆敬畏上帝，不肯按照埃及王的吩咐去做。他们让男婴也活下来了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","埃及王把两个接生婆召来，责问她们∶“你们是怎么搞的？为什么男婴也都活了下来？” ");
INSERT INTO cmn2006_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","她们答道∶“希伯来的妇女不象埃及妇女，她们体格强健，我们还没有赶到，她们已经生产了。” ");
INSERT INTO cmn2006_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","这两个接生婆敬畏上帝，受到上帝的厚待，她们自己也都成家立业。以色列的人口继续增加，民力越发强盛。 ");
INSERT INTO cmn2006_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","终于，埃及王向全国发布了命令∶“希伯来人新生的男婴都必须扔到尼罗河里去，只准女婴活着。” ");
INSERT INTO cmn2006_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","一个利未人和他同族的一个女子结婚。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","妻子怀孕，生下一个儿子。她见这婴儿形容俊美，就把他藏了起来，一直藏了三个月。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","到了实在藏不下去的时候，她就拿了一个蒲草蓝子，涂上沥青和柏油，把孩子放在里面。然后把蓝子放在尼罗河边的芦苇丛里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","孩子的姐姐远远地站着，要看看会有什么事发生。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","国王的女儿到河边来洗澡，她的宫女们在岸边巡视；她看见了芦苇丛中的蓝子，就叫宫女去拿来。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","她打开蓝子，看到一个婴儿在哭，顿生怜悯之心，想∶“这一定是个希伯来人的婴儿。” ");
INSERT INTO cmn2006_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","孩子的姐姐对公主说∶“请问，要不要我去找一个希伯来女人来做他的奶妈？” ");
INSERT INTO cmn2006_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","公主说∶“好吧。”于是，那女孩儿就回去把婴儿的母亲叫了来。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","公主对她说∶“你把这孩子抱去，替我喂养，我会付你工钱的。”那女人就把孩子抱了回去抚养。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","孩子断奶后，母亲把他抱进宫里，交给了公主，公主把他收养作自己的儿子，取名叫摩西。她说∶“因为我是从水里把他拉上来的。” ");
INSERT INTO cmn2006_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","摩西长大了，常去探望他的以色列同胞，了解他们的艰难境遇。一次，他看见一个埃及人在殴打一个他的希伯来同胞。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","他四顾无人，就下手杀了那个埃及人，把尸首埋在沙土里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","第二天，摩西出去，看见两个希伯来人在打架，就对那恃强欺人的人说∶“你为什么要殴打自己的同胞呢？” ");
INSERT INTO cmn2006_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","那人说∶“谁立你为我们的首领和审判官了？你杀了那个埃及人，还要来杀我吗？”摩西心中惊骇，想∶“这事一定被人发觉了！” ");
INSERT INTO cmn2006_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","国王闻报此事，要杀摩西；摩西逃往米甸，在那里住了下来，躲避国王的追捕。 一天，摩西坐在一口井旁， ");
INSERT INTO cmn2006_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","米甸祭司的七个女儿来打水；她们把水槽灌满，要饮父亲的羊群。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","一群牧人过来要把她们赶走，这时，摩西挺身保护了她们，又替她们饮了羊。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","她们回到父亲流珥那里时，流珥问她们∶“今天你们怎么回来得这么早？” ");
INSERT INTO cmn2006_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","她们答道∶“一个埃及人救了我们，把欺负我们的牧人赶走了，还帮我们打水给羊喝。” ");
INSERT INTO cmn2006_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","流珥问∶“他在哪儿？为什么撇下他呢？请他来同我们一起吃饭吧！” ");
INSERT INTO cmn2006_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","摩西也愿意同流珥住在一起，流珥就把女儿西坡拉许配给摩西为妻。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","西坡拉生了一个儿子，取名为革舜。因为摩西说∶“我客居异乡，就给他取名革舜吧！” ");
INSERT INTO cmn2006_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","事隔多年以后，那个埃及王死了。以色列人仍旧在奴役的重压下艰辛度日，他们向上帝求助，他们不堪奴役的呼求上达于上帝那里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","上帝垂听他们的哀告，想起了与他们祖先亚伯拉罕、以撒和雅各立的约。 ");
INSERT INTO cmn2006_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","他顾念以色列人，也知道他们受奴役的苦情。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","摩西为他的岳父、米甸的祭司叶忒罗放羊。有一天，他赶着羊群到旷野的西面去，登上上帝的山－何烈山。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","在那里，一团火焰在荆棘丛中燃烧，主的天使向他显现。摩西看到荆棘着火，却没有被烧毁。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","他说∶“为什么荆棘着了火却没有烧毁呢？我得去看看这个怪现象。” ");
INSERT INTO cmn2006_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","主看见摩西走上前来，就从荆棘丛中呼唤他∶“摩西！摩西！”摩西答道∶“我在这儿！” ");
INSERT INTO cmn2006_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","上帝说；“不要再走近。脱掉你的鞋子，因为你所站的地方是圣洁的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","我是你祖先的上帝，是亚伯拉罕、以撒和雅各的上帝。”摩西遮住脸，不敢看上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","主说∶“我已经看到了我的子民在埃及所受的苦难，听到了他们不堪虐待的哀告。我知道他们的困苦。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","所以，我下来要把他们从埃及人的桎梏中解救出来，把他们领到那流奶与蜜的宽阔富饶之地去，就是迦南人、赫人、亚摩利人、比利洗人、希未人和耶布斯人居住的地方。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","我听到了我的子民的哀告，也看见了埃及人对他们的奴役。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","现在，我要派你去见埃及王，把我的子民－以色列人从埃及领出来。” ");
INSERT INTO cmn2006_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","摩西对上帝说∶“我是什么人？我怎么能去见埃及王把以色列人领出埃及呢？” ");
INSERT INTO cmn2006_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","上帝说∶“我将与你同在。当你领以色列人出了埃及以后，要在这座山上敬拜我。这就是我差遣你的证据。” ");
INSERT INTO cmn2006_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","摩西又说∶“我去见以色列人，对他们说∶‘你们祖先的上帝派我到你们这里来，’他们会问∶‘他叫什么名字？’我该怎样回答呢？” ");
INSERT INTO cmn2006_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","上帝说∶“我即是我。你对以色列人这样说，‘我是’派我到你们这里来的。” ");
INSERT INTO cmn2006_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","上帝对摩西说∶“你要告诉以色列人∶‘是耶和华，你们祖先的上帝，亚伯拉罕的上帝，以撒的上帝，雅各的上帝，派我到你们这里来的。’这是我永恒的名字，是我万世永存的称号。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“去吧，去召集以色列的长老们，告诉他们∶‘耶和华，你们祖先的上帝，亚伯拉罕、以撒和雅各的上帝，曾向我显现，他说∶“我已经注意到你们，已经看到你们在埃及的遭遇， ");
INSERT INTO cmn2006_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","决定把你们领出埃及，脱离苦难。我要领你们到一块流奶与蜜的地方去，就是迦南人、赫人、亚摩利人、比利洗人、希未人和耶布斯人居住的地方。”’ ");
INSERT INTO cmn2006_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“他们会听从你的话。然后，你要领以色列的长老们去见埃及王，对他说∶‘主－希伯来人的上帝向我们显现了。现在，请你准许我们走三天的路程到旷野里去，向主－我们的上帝献祭。’ ");
INSERT INTO cmn2006_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","但是我知道，甚至在强大的压力下，埃及王也不会放你们走的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","我要伸手在埃及人中间，用各种奇迹打击他们。这样，埃及王最终才会放你们走。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“你们离开那里的时候，我要让埃及人对这民族以礼相待，不会让你们空手离去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","每一个以色列妇女都要向她的埃及邻居和住在家里的客人索要金银和衣服。你们把这些东西给你们的儿女穿戴起来，这样，你们就带走了埃及人的财富。” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","摩西答道∶“如果以色列人不信任我，不听我的话，说∶‘主没有向你显现过’，我该怎么办呢？” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","主说∶“你手里拿的是什么东西？” 摩西回答∶“是一根手杖。” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","主说∶“你把它扔到地上。” 摩西把手杖扔到地上。手杖变成了一条蛇，摩西急忙跳开。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","主说∶“你伸手抓住它的尾巴。” 摩西伸手抓住蛇，蛇在他手中又变成手杖。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","主说∶“你可以行这个神迹，这样，他们就会相信，主－他们祖先的上帝，亚伯拉罕、以撒和雅各的上帝，曾向你显现过。” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","主又对摩西说∶“你把手伸到怀里去。” 摩西把手伸到怀里去。当他把手抽出来的时候，手上竟长了疥，片片如雪。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","主说∶“把手再伸到怀里去。” 摩西又把手伸到怀里去。这次把手抽出来，手已经复原如初。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","主说∶“如果他们不信任你，或不留意第一个神迹，这第二个神迹会使他们信服。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","如果他们对这两个神迹都不信服，仍然不肯听从你的话，你就去取一点尼罗河的水，泼在地上，你从河里取来的水就会在地上变成血。” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","摩西对主说∶“主啊，请你原谅，我一向不善言辞，就是你跟我讲话以后也没有改变。我是个笨口拙舌的人。” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","主说∶“谁给人口才？谁使人聋哑？谁使人目明？谁使人眼瞎？是我－主，是我主宰这一切。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","去吧，你开口讲话时我会与你同在，指教你应当怎样说话。” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","摩西还是说∶“主啊，请原谅，请你还是差遣别人去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","主对摩西发怒了，说∶“你不是有一个哥哥利未人亚伦吗？我知道他口才很好。他正要来找你，他见了你一定会欣喜非常。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","你把应当说的话告诉他，你们讲话的时候我会与你们同在，指教你们应当怎样做。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","他会替你向民众讲话，你以他当作口，他以你当作上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","你带上这根手杖，用它施行神迹。” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","摩西回到岳父叶忒罗那里，对他说∶“请准我回埃及探望我的亲戚们，不知他们是不是还活着。” 叶忒罗说∶“好吧，愿你一路平安。” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","主在米甸对摩西说∶“你回埃及去吧，那些要杀你的人都已经死了。” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","于是，摩西带上妻子和儿子，叫他们骑上驴，自己拿着上帝的杖，向埃及进发。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","主对摩西说∶“你回到埃及后，一定要在埃及王面前行我赐与你的各种神迹。但我要使埃及王的心刚硬冷酷，不放以色列人走。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","你要对埃及王说，主是这样说的∶‘以色列是我的长子， ");
INSERT INTO cmn2006_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","我要你放我的儿子去侍奉我，如果你不肯，我就杀掉你的长子。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","摩西在路上住宿的时候，主遇见了他，想要杀他。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","西坡拉拿一片火石当作刀，割掉了她儿子的包皮，用它碰摩西的脚，她对摩西说∶“你是我的血郎。”她这样说，是因为她得为儿子行割礼。因此，主没有杀摩西。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","主对亚伦说，“你到旷野去迎接摩西。”于是，亚伦动身往上帝的山去迎接摩西，亲吻他。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","摩西把主差遣他时所说的话和吩咐他要行的神迹都告诉了亚伦。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","摩西和亚伦一起去召集以色列的长老们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","亚伦把主吩咐摩西的话讲给他们听，又在民众面前行了神迹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","人们都信服了。他们听到主眷顾以色列人，了解他们的困苦，又亲眼见到主的神迹，都一齐俯伏在地，向主敬拜。 ");
INSERT INTO cmn2006_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","此后不久，摩西和亚伦去见埃及王，对他说∶“主－以色列的上帝是这样说的∶‘放我的子民走，让他们到旷野去守节敬拜我。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","埃及王说∶“主是谁？我为什么要服从他？为什么要放以色列人走？我不认识主，也不准以色列人走。” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","摩西和亚伦说∶“希伯来人的上帝曾向我们显现。请准许我们走三天的路程，到旷野里去向主－我们的上帝献祭，否则，他就要用瘟疫或战争来消灭我们。” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","埃及王说∶“摩西，亚伦！你们为什么不叫那些人专心工作？去干你们自己的事吧！ ");
INSERT INTO cmn2006_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","瞧，做工的人已经够多了，而你竟还要他们不干活儿！” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","当天，埃及王向以色列人的领班和埃及监工下令∶“不准再给以色列人做砖的草料， ");
INSERT INTO cmn2006_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","让他们自己去捡草， ");
INSERT INTO cmn2006_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","但做砖的定额与以前一样，不准减少。他们生性懒惰，这才是他们请求我让他们去向他们的上帝献祭的原因。 ");
INSERT INTO cmn2006_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","要加重他们的工作！让他们整天劳碌不堪，没有精力再去听信那些蛊惑的话。” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","埃及监工和以色列人的领班出来告诉以色列人∶“国王有令∶‘不再供给你们草料， ");
INSERT INTO cmn2006_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","你们必须自己去找草料，但砖的定额一块也不能减少。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","以色列人到埃及各地寻找碎秸当草料。 ");
INSERT INTO cmn2006_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","监工逼迫他们，说∶“你们每天都要交齐当天的数额，就象以前供给草料时一样。” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","监工还责打那些由埃及人指派的以色列人的领班，说∶“为什么昨天和今天你们都没有象以前一样完成做砖的定额？” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","领班们去求见国王，说∶“陛下，为什么要这样对待你的仆人呢？ ");
INSERT INTO cmn2006_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","不给我们草料，却只管催促我们做砖。现在，我们都挨了打，但这是您的属下的过错。” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","国王答道∶“你们太懒了！所以才请求我让你们去向主献祭。 ");
INSERT INTO cmn2006_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","快回去干活儿！不给草料你们也得如数做出砖来！” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","领班们知道他们得硬着头皮对以色列人说∶“你们不得减少每天的产量。” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","他们离开国王，看见摩西和亚伦两人正在等候他们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","他们对摩西和亚伦说∶“愿主鉴察你们，惩罚你们！你们使得国王和他的臣僚憎恨我们，这等于把杀我们的刀递在他们手里。” ");
INSERT INTO cmn2006_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","摩西回到主的面前，说∶“主啊，你为什么要降灾于这民族呢？为什么要差遣我做这些事呢？ ");
INSERT INTO cmn2006_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","我去见国王，以你的名义对他讲话，结果他却与这民族为难，而你一点都不救助他们！” ");
INSERT INTO cmn2006_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","主对摩西说∶“你就要看到我怎样处置埃及王了。我要迫使他放走以色列人，迫使他不得不把他们送出国境。” ");
INSERT INTO cmn2006_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","上帝又对摩西说∶“我是耶和华。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","我曾向亚伯拉罕、以撒和雅各显现为伊尔什旦（全能的上帝），但从未让他们知道我的名字是耶和华。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","我曾与他们立约，应许把他们寄居过的迦南地赐给他们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","现在，我又听到了以色列人在埃及人的奴役下发出的哀告，记起了我的约。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“因此，你要去告诉以色列人，对他们说∶‘我是主，我要把你们从埃及人的桎梏中解救出来，摆脱他们的奴役。我必用大能的手拯救你们，重重地处罚埃及人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","我要把你们当作我的子民，我是你们的上帝。你们将会知道，我就是带领你们摆脱埃及人压迫的主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","我要领你们到我曾应许赐给亚伯拉罕、以撒和雅各的那块土地上去，并把它赐给你们作为产业。我是主。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","摩西把这些话告诉以色列人。但是，以色列人不再听信摩西的话了，严酷的奴役已经使他们不堪忍受。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“去告诉埃及王，让他放以色列人离开埃及。” ");
INSERT INTO cmn2006_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","摩西回答说∶“连以色列人都不听我的话，国王会听从我吗？何况我又是个不善辞令的人。” ");
INSERT INTO cmn2006_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","于是，主把以色列人和埃及王的情况讲给摩西和亚伦听，命令他们把以色列人从埃及的国土上领出来。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","以下是他们宗族族长∶雅各的长子吕便的四个儿子∶哈诺、法路、希斯伦和迦米；他们构成吕便支派。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","西缅的六个儿子∶耶母利、雅悯、阿辖、雅斤、琐辖和少罗；他们构成西缅支派。少罗的母亲是迦南人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","以下是利未的三个儿子，按各自的世系是∶革顺、哥辖和米拉利。利未活了137岁。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","革顺有两个儿子∶立尼和示每，他们各立家业。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","哥辖有四个儿子∶暗兰、以斯哈、希伯伦和乌薛。哥辖活了133岁。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","米拉利有两个儿子∶抹利和母示。 以上是利未家族的世系。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","暗兰娶了自己的姑姑约基别为妻，她生了亚伦和摩西。暗兰活了137岁。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","以斯哈有三个儿子∶可拉、尼斐和细基利。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","乌薛有三个儿子∶米沙利、以利撒反和西提利。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","亚伦娶以利沙巴为妻；她是亚米拿达的女儿，拿顺的妹妹。她为亚伦生了四个儿子∶拿达、亚比户、以利亚撒和以他玛。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","可拉生了三个儿子∶亚惜、以利加拿和亚比亚撒。他们构成可拉宗族。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","亚伦的儿子以利亚撒娶了普铁的一个女儿为妻，她生了非尼哈。 以上是利未支派各宗族的渊源及其族长姓氏。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","主吩咐摩西和亚伦∶“把以色列人从埃及按军队的编制领出来！” ");
INSERT INTO cmn2006_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","而摩西和亚伦就向埃及王提出要求，要把以色列人领出埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","在埃及的时候， ");
INSERT INTO cmn2006_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","主曾对摩西说∶“我是主。去把我所说的一切都告诉埃及王。” ");
INSERT INTO cmn2006_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","摩西与主争辩说∶“我是个不善讲话的人，国王怎么会听我的话？” ");
INSERT INTO cmn2006_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","主说∶“你一定要明白，我将使你在国王的面前如同神明，而让你的哥哥亚伦作你的先知。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","你要把我吩咐你的一切都告诉你的哥哥亚伦，再由亚伦吩咐国王，这样，他就会放以色列人离开他的国土。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","但是，我会使国王顽固不化，以便我在埃及的土地上行诸多奇迹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","然而国王还是不肯听从你们的话，于是，我就施展我的力量重重地惩罚埃及人；然后，领着我的子民－也就是以色列人，井然有序地离开埃及的国土。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","当我伸手惩罚埃及人并把以色列人从他们中间领出来的时候，他们就会知道我是主。” ");
INSERT INTO cmn2006_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","摩西和亚伦遵照主的吩咐行事。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","他们向国王宣谕主的旨意的时候，摩西八十岁，亚伦八十三岁。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“如果国王要你们行神迹，你就吩咐亚伦把他的杖扔在国王面前，那根杖就会变成一条蛇。” ");
INSERT INTO cmn2006_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","于是，摩西和亚伦去见国王，并按主的吩咐行了神迹∶亚伦把杖扔在国王和他的大臣们面前，杖就变成了蛇。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","国王也召集了他的博士和术士们来行使法术。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","他们把各自的杖扔在地上，那些杖也都变成了蛇。但亚伦的杖吞吃了他们的杖。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","可是，正如主所预言的，国王仍然执迷不悟，不肯听从摩西和亚伦的话。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","主对摩西说∶“埃及王顽固不化，不肯放我的子民走。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","明天早上，他到尼罗河边去的时候，你去见他。带着那根变过蛇的杖，在河岸上等候他。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","你要对他说∶‘主－希伯来人的上帝派我来告诉你，要你放他的子民走，好让他们在旷野里敬拜他，但你一直不听。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","因此，主要用事实让你知道他是主。我用这根杖击打河水，水就会变成血， ");
INSERT INTO cmn2006_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","河里的鱼都要死光。尼罗河也会变得臭不可闻。埃及人都不能再喝河里的水了。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","主对摩西说∶“你告诉亚伦，要他用这根杖指遍埃及所有的河流、运河、池塘和一切蓄水之处，包括贮水的木器和石器，埃及将遍地是血。” ");
INSERT INTO cmn2006_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","摩西和亚伦按照主的吩咐行事。摩西当着国王和他大臣们的面举杖击打河水，河水立刻变成了血水。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","河里的鱼死了，河水变得腥臭，埃及人无法再喝河里的水。全埃及到处都是血。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","但埃及的巫师们也行使法术重演了一遍。正如主所预言的，国王仍执迷不悟，不肯听从摩西和亚伦的话。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","他起驾回宫，丝毫不把这件事放在心上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","全埃及的人不能再喝尼罗河的水，只得在河边掘地取水喝。 ");
INSERT INTO cmn2006_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","主击打河水后，灾难持续了七天。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","主对摩西说∶“你去见埃及王，告诉他主是这样说的∶‘放我的子民走，好让他们去敬拜我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","如果你不放他们走，我就要使你的国家青蛙成灾。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","尼罗河里将挤满青蛙，你的宫殿、卧室和床上，还有你的大臣和百姓的家里，到处都将爬满青蛙；它们跳进炉灶，爬进揉面盆， ");
INSERT INTO cmn2006_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","甚至跳到你和你的大臣及百姓们的身上。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","主对摩西说∶“告诉亚伦，让他伸出手杖指向所有的河流、运河和池塘，把青蛙召唤到全埃及的土地上。” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","于是亚伦伸杖指向所有的水面，青蛙都跳了出来，布满全埃及的地面。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","但埃及的巫师行使法术重演这一切，也使青蛙遍布埃及各地。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","埃及王召见摩西和亚伦，对他们说∶“请祈求主使这些青蛙离开我和我的臣民吧！我愿意放以色列人走，让他们去向主献祭。” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","摩西答道∶“请定一个时间吧！我将为你和你的臣民祈祷，让青蛙离开你和你的宫殿，只留在尼罗河里。” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","埃及王说∶“就在明天吧。”摩西对他说∶“可以照你的话办，好让你知道没有谁能比得上主－我们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","青蛙就会离开你和你的宫殿以及你的臣民，它们将只留在尼罗河里。” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","说完，摩西和亚伦离开了埃及王。摩西就主差来扰害埃及王的青蛙向主祷告， ");
INSERT INTO cmn2006_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","主按照摩西的请求做了。所有在屋子里、院子里和田野里的青蛙都死掉了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","埃及人把死青蛙一堆一堆地堆起来，全国臭不可闻。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","可是，正如主所预言的，埃及王见境遇有了松缓，就又强硬起来，不肯听从摩西和亚伦的话。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","主对摩西说∶“告诉亚伦，让他伸杖击打地上的尘土，使埃及地上的尘土都变成虱子。” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","摩西和亚伦按照主的吩咐行事。亚伦伸杖击打地上的尘土，埃及遍地的尘土都变成了虱子，爬在人和牲畜的身上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","埃及的巫师们也想作法变出虱子，却不成功，人和牲畜的身上仍然长满了虱子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","他们只得告诉国王∶“这件事是上帝做的！”可是，正如主所预言的，国王依然强硬，不肯听从摩西和亚伦的话。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","主对摩西说∶“明天一早，你到河边去见国王，告诉他主是这样说的∶‘放我的子民走，好让他们侍奉我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","如果你不放我的子民走，我就要用成群的苍蝇扰害你和你的臣民，你的宫殿里和所有埃及人家里将到处都是成群结队的苍蝇，哪儿有人哪儿就有成群的苍蝇。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","但是，那一天我要把我的子民居住的歌珊地与其他地方隔离开来，整个歌珊地一只苍蝇也不会有，好让你知道我－主就在这块土地上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","我要把我的子民和你的百姓区别开来。明天，这个神迹就会出现。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","于是，主行了这个神迹。苍蝇铺天盖地而来，飞满埃及全国。它们飞进国王的宫殿，也飞进大臣们的家中。整个埃及都遭受到苍蝇的扰害，眼看就要被苍蝇毁掉了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","国王召见摩西和亚伦，说∶“你们就在这里向你们的上帝献祭吧！” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","摩西答道∶“这样做不行。因为我们向上帝献的祭物是埃及人所厌恶的。如果我们当着他们的面用他们所厌恶的东西献祭，他们肯定会用石头打死我们！ ");
INSERT INTO cmn2006_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","我们必须走三天的路程到旷野里去，在那里按照主－我们的上帝的吩咐向他献祭。” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","国王说∶“我容许你们到旷野里去向主－你们的上帝献祭，只是不可走得太远。你们也为我祷告吧！” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","摩西答道∶“我离开陛下后立刻就向主祷告。明天，苍蝇就会离开你和你的臣民。只是请求陛下不要再言而无信，仍然不准许我们去向主献祭。” ");
INSERT INTO cmn2006_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","摩西离开了埃及王，向主祷告。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","主按照摩西的请求做了。他使苍蝇离开了埃及王和他的臣民，一只也没有剩下。 ");
INSERT INTO cmn2006_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","可是，这一次埃及王依然强硬如故，不放以色列人走。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","主对摩西说∶“你去见埃及王，告诉他希伯来人的上帝－主是这样说的∶‘放我的子民走，好让他们侍奉我。’ ");
INSERT INTO cmn2006_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","如果你仍然扣住以色列人不放， ");
INSERT INTO cmn2006_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","主就要降灾于你的牲畜，让所有的马、驴、骆驼和牛羊都害上极其严重的瘟疫死去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","但主会把以色列人的牲畜与埃及人的分开，以色列人的牲畜一只也不会死掉。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","主定了行这个神迹的时间，他说∶‘明天，我就要付诸施行。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","第二天，主施行了神迹。埃及人的牲畜都死了，而以色列人的牲畜一只也没有死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","国王派人去察看，发现以色列人的牲畜一只也没有死。可是他依然强硬，不肯放以色列人走。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","主对摩西和亚伦说∶“你们抓几把炉灰，让摩西当着国王的面扬向空中， ");
INSERT INTO cmn2006_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","这灰就会变成尘土，飘撒在埃及全境，落在全埃及的人和牲畜身上，使他们都生疱疮。” ");
INSERT INTO cmn2006_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","于是，摩西和亚伦拿了炉灰，来到国王面前；摩西把炉灰扬向空中，洒落在人和牲畜的身上，使他们都生了疱疮。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","埃及的巫师们也不能来见摩西了，因为他们也象其他埃及人一样都生了疱疮。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","可是，正如主对摩西讲过的那样，他使国王仍然执迷不悟，不肯听从摩西和亚伦的话。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","主对摩西说∶“你明天一早去见国王，告诉他主－希伯来人的上帝是这样说的∶‘放我的子民走，好让他们侍奉我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","这一次，我要把所有的灾难都降在你和你的臣民身上，你就会知道我在大地上无与伦比。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","我本可以施展大能降瘟疫于你和你的臣民，把你们从大地上灭绝掉， ");
INSERT INTO cmn2006_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","而我之所以让你存活，为的是要向你显示我的大能，好让我的名字传遍天下。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","可是你仍然对我的子民作威作福，不放他们走， ");
INSERT INTO cmn2006_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","所以，明天的这个时候，我要降下一场埃及前所未有的大雹灾。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","现在，把你们的牲畜赶到棚子里去，把田里的庄稼都收回来。凡是在田间不收回家的，统统要为冰雹所灭，而那些在露天里的人和牲畜也都将死于冰雹之下。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","国王的大臣中，有些人笃信主的话，急忙把奴仆和牲畜都带进屋里； ");
INSERT INTO cmn2006_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","而另一些人不把主的话放在心上，仍然让牲畜和奴仆呆在田野里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","主对摩西说∶“你举手向天，冰雹将降于埃及全境，击打在田野里的人、牲畜和庄稼上。” ");
INSERT INTO cmn2006_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","摩西举杖向天，主就降下雷霆与冰雹。大地上闪电交织，主把冰雹降到埃及的国土上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","冰雹中闪电络绎不断；这是埃及有史以来最大的雹灾。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","冰雹横扫埃及大地，砸向田野里的人畜和其他一切，庄稼倒伏了，所有的树木都被砸死了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","唯有以色列人居住的歌珊地没有冰雹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","埃及王召见摩西和亚伦，对他们说∶“这一次我知罪了！我和我的百姓都错了，主才是对的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","请向主祷告，求他把雷电和冰雹停下来吧！我愿意放你们走，你们不必再留在这里了。” ");
INSERT INTO cmn2006_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","摩西答道∶“我一出城就张开双手向主祈祷，雷电冰雹就会停息，这样，你就会知道世界属于主。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","但是，我知道你和你的臣民仍不敬畏主。” ");
INSERT INTO cmn2006_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","亚麻和大麦都被冰雹砸毁了，因为那时大麦已经出芽，亚麻也开了花。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","只有小麦和粗麦没有受损，因为它们成熟期晚。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","摩西离开国王，出了城，张开双手向主祷告；雷雨冰雹立刻停息了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","35","可是，正如主所预言的，埃及王见雷雨冰雹停息了，他和他的臣属们又顽固不化，不放以色列人走，又一次犯下了罪。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","主对摩西说∶“你去见埃及王。我使他和他的臣属们顽固不化，就是要在他们中间显现我的神迹， ");
INSERT INTO cmn2006_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","也要你告诉你的子孙后代，我在埃及人当中行了哪些神迹，又怎样置他们于股掌之上。我这样做，让你们都知道我是主。” ");
INSERT INTO cmn2006_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","于是，摩西和亚伦去见埃及王，对他说∶“主－希伯来人的上帝是这样说的∶‘你还要在我面前狂妄多久？放我的子民走，好让他们侍奉我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","如果你仍拒不放我的子民走，明天我就差蝗虫进入你的境内。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","它们将布满全国各处，密得连地面都看不见。它们将吃光冰雹没有毁掉的东西，吃光田里所有的树木， ");
INSERT INTO cmn2006_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","塞满你的宫殿和你的臣民的房子；你的祖先从未见过这样可怕的蝗灾。’”说完，摩西转身离开了国王。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","国王的臣仆们对国王说∶“这人还要为害我们多久？请陛下放了他们，让他们去敬拜主－他们的上帝吧！您难道不知道埃及已经快要被他们毁灭了吗？” ");
INSERT INTO cmn2006_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","于是，摩西和亚伦又被召回国王。国王对他们说∶“去吧，去侍奉主－你们的上帝吧，但究竟哪些人去呢？” ");
INSERT INTO cmn2006_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","摩西答道∶“我们全体民众不分老幼都要去，还要带上我们的儿女和牛羊牲畜一起去，因为我们必须全体为主守节。” ");
INSERT INTO cmn2006_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","埃及王说∶“但愿我放你们的妇孺儿童与你们一起去能使主真的与你们同在！显然，你们这是别有居心。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","不行！你们当中只有成年男子可以去，本来你们就是这样请求的。”说罢，埃及王命人将摩西和亚伦赶出了王宫。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","主对摩西说∶“举起手来，指向埃及全国，把蝗虫召来；蝗虫将遍布埃及全境，把冰雹过后剩下的一切植物统统吃光。” ");
INSERT INTO cmn2006_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","于是，摩西伸杖指向埃及全国，主使东风吹向埃及，整整吹了一天一夜，到了早晨，蝗虫乘着东风， ");
INSERT INTO cmn2006_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","铺天盖地而来，布满埃及各地。这是一场空前绝后的大蝗灾。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","它们吃光了雹灾过后残存的一切瓜果菜蔬，整个埃及大地上黑压压一片，见不到一点植被的绿色。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","国王急忙召见摩西和亚伦，说∶“我得罪了主－你们的上帝，也得罪了你们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","求你们再次饶恕我的罪过，请向主祷告，求他不要把这致命的灾难降在我的身上。” ");
INSERT INTO cmn2006_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","摩西离开国王，向主祈祷。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","主转换风向，刮起西风，强劲的西风卷起地上的蝗虫，吹入红海，埃及境内一只蝗虫也没有剩下。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","可是，主使埃及王仍然顽固不化，不放以色列人走。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","主对摩西说∶“你举手向天，我要让黑暗笼罩埃及；整个埃及将黑得伸手不见五指。” ");
INSERT INTO cmn2006_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","于是，摩西举手向天，浓重的黑暗立刻笼罩了埃及全境，一直持续了三天。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","在这三天之中，唯有以色列人的住处有光亮。埃及人全都处在伸手不见五指的黑暗之中，寸步难行，一连三天困在原处不能行动。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","埃及王召见摩西，说∶“去侍奉你们的上帝吧！你们的妇女儿童可以和你们一起去，但是你们的牛羊牲畜得留在这儿。” ");
INSERT INTO cmn2006_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","摩西答道∶“你得让我们有献牲祭和烧化祭的牲畜，我们才能向主献祭。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","我们的牲畜全都要带去，一蹄也不留！因为我们要从中挑选出一些牲畜敬献给主－我们的上帝；而只有到了那里以后我们才能知道用什么敬献给主。” ");
INSERT INTO cmn2006_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","主使埃及王仍然顽固不悟，不放以色列人走。 ");
INSERT INTO cmn2006_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","他喝斥摩西，说∶“滚出去！你要小心，别让我再看见你！你再见我的时候就是你的死期！” ");
INSERT INTO cmn2006_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","摩西答道∶“你说得一点不错，我不会再见你了！” ");
INSERT INTO cmn2006_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","主对摩西说∶“我要再次降灾于埃及王和他的臣民。然后，国王必定无条件地放你们离开这里。那时，将是他催逼你们离开此地。 ");
INSERT INTO cmn2006_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","告诉以色列人，叫他们不分男女都要到埃及邻居家去索要金银财物。” ");
INSERT INTO cmn2006_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","主要使埃及人亲眼见到以色列人受到主的恩宠，而摩西将受到埃及王的臣属和全埃及人的尊崇。 ");
INSERT INTO cmn2006_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","摩西对埃及王说∶“主是这样说的∶‘今天午夜，我要降临埃及人中间， ");
INSERT INTO cmn2006_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","击杀埃及土地上的每一个长子。所有的埃及人，上至手握王权的埃及王，下至推磨做工的婢女，他们的长子都要被处死；连牲畜的头胎也要处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","整个埃及将是一片号啕之声。这是空前绝后的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","但是，在以色列人中间，连狗也不会向人或牲畜吠一声。那样，你才会知道我－主就是要把埃及人和以色列人区分开来。’ ");
INSERT INTO cmn2006_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","那时，你的臣属们就会来找我，向我跪拜央求，说∶‘请走吧，请你和你的百姓们快离开这里吧！’直到那时，我才离开埃及。”说完，摩西怒气冲冲地离开了王宫。 ");
INSERT INTO cmn2006_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","主对摩西说∶“国王一定不会听从你们的话，这样，我就能在埃及行更多的神迹。” ");
INSERT INTO cmn2006_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","摩西和亚伦在国王面前行了许多神迹，但是主使埃及王执迷不悟，仍然不放以色列人离开他的国土。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","主在埃及曾对摩西和亚伦说过∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“这个月要作为月份的开始，作为你们一年的头一个月。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","告诉以色列的全体会众∶在这个月的初十日，每家的户主要为他家准备一只绵羊或山羊羔，每户一只； ");
INSERT INTO cmn2006_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","如果他家的人口太少，吃不了一整只羊羔，可以与人口相近的邻居家共用一只羊羔，按人口的多少和食量的大小分配。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","所选的羊羔应该是健康的一岁大的公羊，绵羊或山羊都可以， ");
INSERT INTO cmn2006_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","等到本月14日黄昏，以色列的会众们要把所选出的羊羔宰掉， ");
INSERT INTO cmn2006_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","取一些血涂在房子的门框和门楣上，然后，就在那间屋子里吃羊肉。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","那一晚，他们必须吃烤羊肉、苦菜和无酵饼。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","不可以吃生羊肉，也不可以用水煮了吃，头、腿和内脏都要烤了吃。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","不可以有剩余的留到第二天，剩余的一切都必须烧掉。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","你们吃羊羔的时候，应当腰束皮带，脚上穿鞋，手中执杖；要快快地吃。这是主的逾越节。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“那一夜，我要巡遍埃及国土，击杀所有埃及人的长子，也击杀牲畜的头胎，我要惩罚埃及所有的神明；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","门框上的血是你们所居住的房屋的记号。当我降祸于埃及时，看到这血，就越过你们的家，使你们免遭毁灭。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“这天将作为你们的纪念日，你们要在这天为主守节；这要立为永远的规例，世世代代流传下去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","在这七天里，你们只可以吃无酵饼。你们要在第一天清除掉家中所有的酵；凡在这七天之中吃了有酵食物的人，都要从以色列族中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","在第一天和第七天，你们要举行圣会；在这两天，除了预备饮食以外，不可以做任何工作。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“你们要守这无酵节；正是在这一天，我要率领你们各个家族井然有序地离开埃及。你们要在这天守节，作为永远的规例世世代代流传下去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","从正月十四日的晚上起，一直到正月二十一日的晚上，你们只可以吃无酵饼。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","在这七天之内，家中不准有酵；凡在这期间吃了有酵食物的人，无论是寄居的侨民还是本族人，都要从以色列的会众中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","你们不可吃有酵的食物，所有的居民都要在自己的住处吃无酵饼。” ");
INSERT INTO cmn2006_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","摩西召集以色列的所有长老，对他们说∶“你们每家要选一只绵羊羔或山羊羔，把它宰了，好守逾越节。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","然后，拿一把牛膝草，蘸上盆里的血，涂在门框和门楣上。任何人在天亮之前都不许出门。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","那一夜，主要巡遍埃及，降下灾祸；他看到门楣和门框上的血，就会越过那里，不让死亡使者进入你们的家击杀你们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“你们务必遵守这一诫命，并要立为规例传之子孙。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","你们进入主的应许之地以后，仍然要遵守这一礼仪。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","如果你们的后代问你们∶‘这个礼仪是什么意思？’ ");
INSERT INTO cmn2006_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","你们要这样回答∶‘这是献给主的逾越节的祭礼。他越过住在埃及的以色列人家的房屋。当主降祸于埃及的时候，保全了我们的家眷。’”以色列人俯伏在地，向主敬拜。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","他们分头散去，按照主对摩西和亚伦的吩咐行事。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","午夜，主击杀了所有埃及人的长子。上至手握王权的埃及王，下至监牢里的囚犯，所有埃及人的长子都被击杀了，连牲畜的头胎也被杀死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","那一夜，埃及王和他的臣仆以及全埃及的人都被惊动了。整个埃及一片号啕之声，因为埃及人家家都死了人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","当夜，埃及王召见摩西和亚伦，对他们说∶“快走吧！你们，还有那些以色列人，快离开我们吧！按你们的要求去敬拜主吧！ ");
INSERT INTO cmn2006_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","可以按你们的要求带走你们的牲畜；也请你们为我祝福。” ");
INSERT INTO cmn2006_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","埃及人催促以色列人赶紧上路，他们说∶“你们再不走，我们都要死光了。” ");
INSERT INTO cmn2006_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","以色列人把尚未发酵的面团收起来，把揉面盆用长袍包好，扛在肩上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","他们按照摩西的吩咐，向埃及人索要金器、银器和衣裳。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","主使埃及人善待以色列人，他们满足了以色列人的一切要求。就这样，以色列人带走了埃及人的财富。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","以色列人从兰塞向疏割进发。除去妇女儿童不计，光徒步的成年男子就有六十万人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","此外，随行的还有许多闲杂人等和成群的牛羊等牲畜。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","由于他们离开埃及过于仓促，来不及预备食物，沿途只能用从埃及带出来的生面团烘烤成无酵x饼充饥。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","以色列人在埃及共居留了四百三十年。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","四百三十年后的那一天，属主的各个家族井然有序地离开了埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","这一夜，主亲自看护他们，引领他们出了埃及。所以，从此以色列人看护每年的同一夜，以示尊敬主。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","主对摩西和亚伦说∶“守逾越节应当遵守这些典仪∶ “异族人不可以吃逾越节羔羊。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","至于买来的奴仆，受过割礼后可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","暂居此地的人或临时雇用的工人不可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“吃的时候要在一间单独的屋子里吃，不可以把肉带到屋外，也不可以折断羊的任何一根骨头。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","以色列的全体会众都要遵守这一典仪。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“如果有寄居在你们中间的异族人愿意向主守逾越节，那么他全家的男子都要先行割礼，然后才能容许他向主守节，受到象本族人一样的待遇。任何未受割礼的人都不准吃逾越节羔羊。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","无论本族人还是寄居的异族人都必须严守此例。” ");
INSERT INTO cmn2006_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","全体以色列人都遵照主对摩西和亚伦的吩咐行事。 ");
INSERT INTO cmn2006_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","就在这一天，主把以色列人以军队的阵容领出了埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“你们要把以色列人所有头胎所生的雄性，包括以色列人的长子和牲畜的头胎，都奉献给我；他们属于我。” ");
INSERT INTO cmn2006_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","摩西对以色列人说∶“你们要记住这一天，这是你们离开埃及摆脱奴役的日子；主用他的大能把你们领出了埃及。你们不可以在这天吃有酵的食物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","现在是亚笔月，你们是在这时节离开埃及的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","当主领你们进入迦南人、赫人、亚摩利人、希未人和耶布斯人的土地－也就是主向你们的祖先发誓要赐给你们的那块流奶与蜜的沃土之后，你们要在每年的这个月守这礼仪。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","七天之内，你们都要吃无酵饼；在第七天，你们要为主守节。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","这七天之内你们都要吃无酵饼，身边不准有任何有酵的食物，境内不准存放酵。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","你们每人都应告诉你们的孩子‘那是因为当我离开埃及时主为我所做的。’你们因此而为主守节。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","守这个节好比在你们手上做标志，在你们额上打印记，使你们时时牢记并传诵主的训诲；因为主用他的大能引领你们出了埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","你们每年要按时为主守这个节。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“将来，当主把你们领到迦南地，按照他向你和你的祖先所起的誓把那里赐给你们的时候， ");
INSERT INTO cmn2006_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","你们要把所有的头胎所生都献给主。牲畜生下的雄性头胎都要献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","头生的驴可以用绵羊或山羊代赎；如果不打算代赎，就要打断那头驴的颈项。你们要代赎你们的长子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“将来，你们的后代问你∶‘这是什么意思？’你要告诉他们∶‘主用他的大能把我们领出了埃及，使我们摆脱了奴役。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","埃及王曾顽固地不放我们走，因此，主击杀了所有埃及人的长子及头胎所生的牲畜。所以，我要把头胎生下的公牲畜献给主，并且要代赎我的长子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","这就象是在你的手上和额前打上了标记，以记念主用他的大能把我们领出了埃及。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","埃及王放以色列人走的时候，上帝没有领他们走途经非利士的近路。上帝想∶“恐怕我的子民走那条路遭遇到战事，他们或许会改变主意又返回埃及去。” ");
INSERT INTO cmn2006_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","所以，上帝领着以色列人绕道旷野，向红海进发。以色列人离开埃及时按作战需要进行了编制和装备。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","摩西带走了约瑟的骸骨。因为约瑟曾要以色列人起誓，说∶“上帝一定会来看顾你们；当上帝带领你们离开这里的时候，一定要带走我的骸骨。” ");
INSERT INTO cmn2006_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","以色列人离开了疏割，在旷野边缘地带的以倘扎营。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","白天，主在前面用云柱为他们指路，夜间，主用火柱照亮他们，使他们可以日夜兼程赶路。 ");
INSERT INTO cmn2006_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","白天的云柱，夜间的火柱，始终不离以色列人的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“你去告诉以色列人，让他们向后转，在密夺和红海之间靠近巴力洗分的比哈希录扎营。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","埃及王会以为以色列人在这一带迷了路，被沙漠困住了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","我要使他的心强硬起来，出兵追赶你们；那时，我要在埃及王和他的军队身上显示我的威严，好让埃及人知道我是主。”以色列人遵照主的吩咐行事。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","埃及王得悉以色列人已经逃走，他和他的臣属们又变了主意，说∶“放走以色列人，往后谁来服侍我们呢？我们干了件傻事！” ");
INSERT INTO cmn2006_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","于是，埃及王整顿车马，召集军队； ");
INSERT INTO cmn2006_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","率领600名精兵以及其他全部战车，每辆车上都配备了善战的兵士， ");
INSERT INTO cmn2006_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","前来追赶以色列人。主使埃及王心怀恼怒，因为以色列人竟然大摇大摆地出了埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","埃及王的马、战车、骑士和大队军马赶上了以色列人，在靠近巴力洗分的比哈希录的地方，直逼以色列人扎在红海边上的营地。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","以色列人远远望见埃及人追来，非常恐惧，就向主求救。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","他们埋怨摩西，说∶“你为什么把我们领出埃及呢？难道是怕埃及没有埋我们的坟地才叫我们到这旷野里来送死吗？！ ");
INSERT INTO cmn2006_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","我们在埃及时就告诉过你，我们宁愿留在那里伺侯埃及人，总比死在这旷野里强些。” ");
INSERT INTO cmn2006_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","摩西对众人说∶“不要怕！今天，你们会亲眼看到主赐与你们的救恩，你们将再也见不到眼前的这些埃及人了！ ");
INSERT INTO cmn2006_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","主将为你们争战，你们只管静观好了。” ");
INSERT INTO cmn2006_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","主对摩西说∶“你何必向我呼求？告诉以色列人只管前进好了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","现在，你，举起手杖，伸向大海；海水会分开，以色列人能够从干道上走过去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","我要使埃及王敢于继续追赶你们；那时，我就要向埃及王和他的大军，他的战车和骑士显示我的威严， ");
INSERT INTO cmn2006_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","当我使埃及王和他的全军一败涂地时，他们就会知道我是主。” ");
INSERT INTO cmn2006_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","原先在以色列人前面引路的上帝的天使移到以色列人的后面，云柱也从前面转到后面， ");
INSERT INTO cmn2006_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","停在埃及人和以色列人的军营之间，当黑暗来临时，云柱在此处，并照亮了夜晚。所以，整个夜晚双方不能接近。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","摩西伸杖指向大海，立时，主掀起强劲的东风，把海水吹退，海水向两旁分开，露出海底；风吹了整整一夜，海底形成一条干燥的通道。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","以色列人沿着干道走进海中，海水象两堵墙壁立在他们的两旁。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","埃及人追了上来，他们的马匹、战车和军兵也都尾随进入海中。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","破晓时分，主从火柱和云柱中间观看，埃及军队的阵形开始混乱， ");
INSERT INTO cmn2006_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","主使他们的战车轮子陷在泥淖之中，埃及人在泥水中艰难跋涉，说∶“撤退吧，不要和以色列人打了！主在帮着以色列人打我们！” ");
INSERT INTO cmn2006_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","主对摩西说∶“把手举出来，指向大海；海水将合拢，淹没那些埃及人和他们的战车、军兵。” ");
INSERT INTO cmn2006_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","于是，摩西伸杖指向大海；天亮的时候，海水恢复了原状，争相逃命的埃及人径直跑到水中。就这样，主把埃及人都趋散到海里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","海水向中间合拢时，淹没了所有尾追以色列人进入海中的战车和军兵，埃及王全军覆没，无一生还。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","但是，以色列人却安然走过海底的干地，海水壁立在他们的两旁。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","那一天，主把以色列人从埃及人的手中救了出来。以色列人目睹埃及人横尸岸边。 ");
INSERT INTO cmn2006_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","他们亲眼看到主用他的大能击败了埃及人，他们敬畏主，信赖主，也信服他的仆人摩西。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","摩西和以色列人向主献上这首歌∶ “我要歌颂主！ 他至高至尊，他把马和骑士一齐抛进海中。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","主是我的力量，是我讴歌的主题， 是他赐与我救恩。 他是我的上帝，我要赞颂他， 他是我祖先的上帝，我要尊崇他。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","主是战士，他的名字是耶和华。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","他把埃及王的战车和军队抛进海中，精兵猛将一齐葬身于红海。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","深沉的水吞没了他们，他们象石头一样沉下海底。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","主啊，你强有力的右手令人目瞪口呆， 主啊，你用右手把仇敌一扫而光。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","你显露出无上的威严，把敢于对抗你的人打翻在地。 你迸发怒火，毁灭他们就如同烧掉糠秕。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","你的鼻息使海水如垒，使急流壁立，使深海如平地。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","我的仇敌说∶ ‘我要追赶他们，抓住他们， 亲手降服他们； 我的剑下无一生还， 我要瓜分他们的财物，我的嗜战之欲得到了满足。’ ");
INSERT INTO cmn2006_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","主啊，你只吹一口气，海水就淹没了他们， 他们象铅一样没于深水之中。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","主啊，诸神中谁能与你相比？ 谁能象你至圣至荣，可颂可畏，施行奇迹？ ");
INSERT INTO cmn2006_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","你伸出右手，大地就吞没了他们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","你以不变的爱引导你所拯救的子民， 以你的大能把他们领到你的圣地。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","异族都闻听而惊慌失措，痛苦攫住了非利士人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","以东的族长害怕，摩押的首领战栗，所有的迦南人都失魂丧胆， ");
INSERT INTO cmn2006_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","恐怖和惊吓笼罩了他们； 主啊，由于你的大能， 他们目瞪口呆，眼睁睁看着你的子民走过， 眼睁睁看着你所创立的民族远去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","你把你的子民领到你自己的山上，安置在那里， 主啊，那里是你为自己营造的起居之地， 是你亲手创立的圣处。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","主啊，你永永远远是王！” ");
INSERT INTO cmn2006_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","以色列人从变为干地的海底走过红海，但当埃及王的人马车辆追踪而至时，主使海水恢复原状，淹没了他们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","亚伦的姐姐女先知米利暗手里拿着手鼓，众多妇女也都跟随着她，一面打鼓，一面跳舞。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","米利暗领着她们唱道∶ “赞美主；他至高至尊， 战马和驭手都被他扔进海里。” ");
INSERT INTO cmn2006_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","摩西率领以色列人离开红海，来到书珥旷野。他们在旷野里跋涉了三天，找不到一点水喝， ");
INSERT INTO cmn2006_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","一直走到玛拉才看见水，可是，那水是苦的，根本不能喝；因此，那个地方被叫做玛拉。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","人们纷纷抱怨摩西∶“我们喝什么呢？” ");
INSERT INTO cmn2006_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","摩西向主呼求，主指示给他一段木头；摩西把木头往水里一扔，那水立刻变甜了。在那里，主为以色列人制定了律例和典章，并在那里考验他们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","主说∶“如果你们真心服从我－你们的上帝，只做我认为正确的事，谨守我的诫命，遵行我的律例，我就不把降于埃及人的灾病降在你们的身上，我是医治你们的主。” ");
INSERT INTO cmn2006_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","他们来到以琳，那里有十二股泉水和七十棵棕树。他们就在水边安营。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","以色列的全体会众离开了以琳。在出埃及后的第二个月的十五日，来到以琳和西乃之间的寻旷野。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","在旷野里，以色列的会众向摩西和亚伦发怨言， ");
INSERT INTO cmn2006_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","说∶“我们还不如在埃及死在上帝的手里。那时候我们生活安定，还能放开肚皮吃肉和饼，你们把我们领到这旷野里，是要把我们都饿死啊！” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","主对摩西说∶“我将从天上给你们降下饼。以色列人每天必须出去捡当天所需的食物。我要用这个方法考验他们是否遵行我的律例。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","在第六天，他们必须捡足两天的食物，以备食用。” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","摩西和亚伦对以色列人说∶“今天晚上，你们就会知道是主把你们领出埃及的； ");
INSERT INTO cmn2006_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","明天早晨，你们会看见主的荣耀；因为他已经听到你们对他的怨言了。我们算什么？你们为什么要抱怨我们呢？” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","摩西又说∶“主会让你们晚上有肉吃，早上能饱餐；因为他听到你们对他的怨言了。我们算什么？你们埋怨我们，其实是在埋怨主！” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","摩西对亚伦说∶“你去告诉以色列的全体会众到主的面前来，因为主已经听到了他们的怨言。” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","亚伦向以色列会众讲话的时候，人们回头向旷野观望，看见主的光环在云端显现。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“我已经听到了以色列人的怨言。你告诉他们，晚上他们将有肉吃，早晨他们将能饱餐。这样，他们就会知道我是主，是他们的上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","傍晚，成群的鹌鹑飞来，将营地都遮盖住了。清晨，营地四周结满了露水， ");
INSERT INTO cmn2006_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","露水蒸发掉以后，野地上留下片片象霜一样薄薄的小东西。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","以色列人看见了，不知道是什么东西，互相询问∶“这是什么东西？” 摩西对他们说∶“这就是主赐给你们的饼。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","主是这样吩咐的∶拾取时要以食用量为准。各家按各家人口的多少拾取，每人可以收取两公升。” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","以色列人按照主的吩咐的出来收取，有的人拾得多些，有的人拾得少些。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","但是称量的时候，多拾的没有剩余，少拾的也不短缺。人人所拾取的恰恰就是他所需要的量。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","摩西对他们说∶“你们不可以把食物留到第二天早晨。” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","但是，有些人不听摩西的话，留下了一些食物。第二天早晨，这些食物都生了虫，而且发臭了。摩西对这些人非常生气。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","每天清晨，人人都按着自己的饭量出去拾取所需的食物，太阳一出来，气温升高，还没拾取那层东西就融化了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","到了第六天，他们拾取双倍的食物，每人四公升。会众的首领们来告诉摩西这件事， ");
INSERT INTO cmn2006_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","摩西对他们说∶“主是这样吩咐的∶明天是安息日，是为主守安息的圣日。今天，你们要把该烤该煮的食物都弄好，把剩下的留到明天早晨吃。” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","人们按照摩西的吩咐做了，把剩下的食物留到第二天，这些食物既没有生虫也没有发臭。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","摩西说∶“你们今天就吃这些食物，因为今天是主的安息日，你们在地里找不到食物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","在那六天里，你们都可以找到食物，只有这第七天什么也不会找到，因为这一天是主的安息日。” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","在第七天，有些人仍旧出去找食物，但是一点也找不到。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","主对摩西说∶“还要多久你们才肯认真遵从我的命令和律例？ ");
INSERT INTO cmn2006_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","要记住，我－主赐给你们安息日，因此才在第六天给你们两天的食物，就是要你们在第七天呆在家里，不准外出。” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","所以，以色列人在第七天都不工作。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","以色列人把这种食物叫作“吗哪”。这东西样子象芫荽子，呈白色，很好吃，如同掺蜜的薄饼。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","摩西说∶“主是这样吩咐的∶你们要把一些吗哪装在一个两公升的容器里留给你们的子孙后代，好让他们知道这是主把你们领出埃及时在旷野中赐给你们的食物。” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","摩西对亚伦说∶“拿一个罐子来，放进两公升吗哪，把它存放在主的面前，留给子孙后代。” ");
INSERT INTO cmn2006_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","亚伦按照主对摩西的吩咐行事。他把罐子放在约柜前面保存起来。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","以色列人吃了四十年吗哪，直到他们来到迦南，找到了一块能够定居在那里的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","当时的标准计量单位叫俄梅珥，一俄梅珥等于二十公升。 ");
INSERT INTO cmn2006_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","以色列会众按照主的吩咐离开了寻旷野，逐步迁移到利非订，在那里安下营地。可是，当地没有水源可供饮用。 ");
INSERT INTO cmn2006_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","人们又抱怨摩西，说∶“快给我们水喝吧！”摩西对他们说∶“你们为什么又来与我争吵？你们为什么要试探主呢？” ");
INSERT INTO cmn2006_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","人们口渴难忍，继续抱怨摩西，说∶“你为什么把我们领出埃及？难道就是要把我们和我们的儿女连同我们的牲畜一齐渴死吗？” ");
INSERT INTO cmn2006_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","摩西向主呼求，说∶“我该拿这些人怎么办？他们快要拿石头砸死我了！” ");
INSERT INTO cmn2006_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","主对摩西说∶“你拿着你先前击打过尼罗河水的那根手杖，带几个以色列人的首领，走在民众的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","我将在何烈的磐石那里站在你的面前。你用手杖击打磐石，水就会从磐石里冒出来供人饮用。”摩西当着以色列人首领的面按照主的吩咐做了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","他把这个地方叫做玛撒，又叫米利巴。因为以色列人在这里抱怨主，他们试探主，说∶“主真的和我们在一起吗？” ");
INSERT INTO cmn2006_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","亚玛力人来到利非订，要攻击以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","摩西对约书亚说∶“你去选出一些人来，准备与亚玛力人作战。明天，我要手持上帝的杖到山顶上观战。” ");
INSERT INTO cmn2006_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","约书亚按照摩西的指示与亚玛力人交战。摩西、亚伦和户珥在山顶上观战。 ");
INSERT INTO cmn2006_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","每当摩西举起手臂，以色列人就得胜，他一放下手臂，亚玛力人就占上风。 ");
INSERT INTO cmn2006_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","摩西的手臂酸了，亚伦和户珥搬来一块石头，让摩西坐在上面，两人一左一右扶住他的手臂。摩西始终举着手臂，直到日落。 ");
INSERT INTO cmn2006_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","就这样，约书亚重创了亚玛力人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","主对摩西说∶“你要把这次胜利记录下来，以备不忘。务必告诉约书亚，我要彻底毁灭亚玛力人。” ");
INSERT INTO cmn2006_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","摩西筑了一座祭坛，命名为“主是我的旗帜”。 ");
INSERT INTO cmn2006_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","他说∶“高举主的旗帜！主将世世代代与亚玛力人争战。” ");
INSERT INTO cmn2006_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","摩西的岳父米甸祭司叶忒罗听说了上帝为摩西和他的百姓所做的一切，知道主已经把以色列人领出埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","于是，他带着摩西送回家的妻子西坡拉和两个儿子动身来见摩西。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","一个儿子名叫革舜，因为摩西说∶“我是寄居他乡的外地人。” ");
INSERT INTO cmn2006_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","另一个儿子名叫以利以谢，因为摩西说∶“我父亲的上帝帮助了我，使我免遭埃及王的毒手。” ");
INSERT INTO cmn2006_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","叶忒罗带着摩西的妻子和他的两个儿子来到旷野，摩西的营地安在上帝的山上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","他叫人通报摩西∶“我是你的岳父叶忒罗，我带着你的妻子和两个儿子到这里来了。” ");
INSERT INTO cmn2006_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","摩西出来迎接岳父。他拜见岳父，与他亲吻，然后，互致问候，一起走进帐蓬。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","摩西向叶忒罗详述了主为拯救以色列人对埃及王和他的臣民所作的一切，又把以色列人沿途所遭遇到的艰险以及主对他们的救助，一一讲述给叶忒罗听。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","叶忒罗听到主把以色列人从埃及王手中解救出来时对以色列人施予的种种恩惠，欢欣非常。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","他说∶“赞美主！是他把你们从埃及王和他的臣民手中救了出来！ ");
INSERT INTO cmn2006_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","现在我知道主比所有的神明都更伟大；确实，在这件事上，埃及人对以色列人是极为傲慢无理的。” ");
INSERT INTO cmn2006_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","叶忒罗向上帝献上烧化祭和其他祭物。亚伦和以色列众首领都来到上帝的面前，与叶忒罗一齐进餐。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","第二天，摩西坐在民众中处理民事。人们站在那里等待着他，从早到晚络绎不绝。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","摩西的岳父看到这一切，问摩西∶“你在为百姓们忙些什么？为什么这么多人从早到晚站在这里排队等候你，而这里只有你一个人？” ");
INSERT INTO cmn2006_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","摩西答道∶“人们都来向我求问上帝的旨意。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","民间有了纠纷，就来找我评判是非，我就此把上帝的律法和律例讲授给他们。” ");
INSERT INTO cmn2006_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","摩西的岳父说∶“你的这种作法不高明。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","这工作对你来说太繁重了，你一个人承当不了，只会把你和你的百姓们都搞得疲惫不堪。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","听我说，我给你出个主意吧！愿上帝与你同在。你是上帝派在人间的使者，要在上帝的面前为百姓申述，求他裁判； ");
INSERT INTO cmn2006_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","要把上帝的律法教给百姓，指示他们如何处世为人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","你应该从民众中选拔一些精明可靠的人，派他们做千夫长、百夫长、五十夫长和十夫长；这些人必须是敬畏上帝、不受贿赂的人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","让他们随时为百姓裁决纠纷，小的纠纷自行处理，只把重要的案件呈送给你。这样，他们可以分担你的责任，使你轻松一些。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","如果你这样做－这是上帝命令你这样做的－你就能圆满地做好上帝吩咐你做的事，而百姓们也都能各安其所。” ");
INSERT INTO cmn2006_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","摩西认为岳父的话有道理，采纳了他的建议。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","他从全以色列选拔人材，派他们做千夫长、百夫长、五十夫长和十夫长，管理百姓， ");
INSERT INTO cmn2006_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","让他们随时为民众排解纠纷，小的事情自行处理，只把疑难的案件呈送摩西。 ");
INSERT INTO cmn2006_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","不久，摩西向叶忒罗道别，叶忒罗返回家乡。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","以色列人离开埃及后的第三个新月的那一天，来到西乃旷野。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","他们从利非订出发，来到西乃旷野，在旷野里安下营地。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","主从山上召唤摩西。摩西上了山，主对他说∶“你要告诉雅各的家族，告诉以色列人∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘你们已经亲眼看见我怎样对待埃及人了。我背着你们，就象母鹰把小鹰背在翅膀上一样，领你们离开埃及来到我这里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","如果你们真心服从我，守我的约，尽管全世界都属于我，但在世界各个民族中，只有你们是我所珍爱的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","你们要成为一个侍奉我的祭司的国度、一个圣洁的国度。’你要以这些话晓谕以色列人。” ");
INSERT INTO cmn2006_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","摩西下了山，召集以色列的长老们，把主吩咐他的话一一转告他们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","以色列人异口同声答道∶“我们一定遵从主的训示行事。”摩西把以色列人的话回复主。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","主对摩西说∶“我要在浓厚的云幕中降临到你那里，好让以色列人听到我与你的对话，这样，他们以后就会对你深信不疑了。”摩西把以色列人的话回复了主。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","主说∶“你去告诉以色列人，让他们在今天和明天洁净自己，换洗衣服， ");
INSERT INTO cmn2006_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","后天一切都要准备好。那一天，我要降临在西乃山，让所有的以色列人都能够看见我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","你要在山的四周划一条界线，告诫人们不可越界，也不可上山，即便碰一下也不行。无论是谁触碰了这座山都必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","死刑可用石头或箭执行，不可用手接触。无论是人还是牲畜，都不能让他们再活着。直到号角响起长音的时候，人们才可以到山脚下来。” ");
INSERT INTO cmn2006_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","摩西下了山，为人们行洁净礼，让他们换洗衣服。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","摩西吩咐他们∶“三天之内一切都要准备好；在这段时间内不可亲近女人。” ");
INSERT INTO cmn2006_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","第三天清晨，雷电交加，号声嘹亮，一朵浓云在山顶出现。营地里的人都战战兢兢。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","摩西带领人民出了营地，来到山脚下与上帝相见。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","主在火中降临在山顶，烟雾笼罩了整个西乃山，就象窑里冒出的浓烟；整座山在剧烈地震动。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","号角声越来越响；摩西向上帝讲话的时候，上帝用声音回答他。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","主降临在西乃山顶上，召摩西上到山顶，摩西迎上前去， ");
INSERT INTO cmn2006_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","主对他说∶“你下去警告人们，不可越界来看我，否则，会有许多人死亡。 ");
INSERT INTO cmn2006_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","祭司也必须先洁净自己才能走近我，否则，我也会出其不意地消灭他们。” ");
INSERT INTO cmn2006_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","摩西对主说∶“民众不会上山来；因为你曾亲自警告过我们，要我们在山的四周划定界线并以这座山为圣。” ");
INSERT INTO cmn2006_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","主对摩西说∶“你下去，把亚伦带上来。但祭司和百姓不可越过界线到我这里来，否则，我会出其不意地消灭他们。” ");
INSERT INTO cmn2006_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","摩西下了山，回到以色列人那里，把主的话告诉了他们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","上帝说了以下这一切∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“我是主－你们的上帝，是我把你们从埃及领出来，使你们摆脱了埃及人的奴役。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“除我以外，你们不可信仰别的神明。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“你们不可为自己造任何偶像，也不可仿造天地间和水中的万物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","你们决不可向任何偶像跪拜。我是主－你们的上帝；我是忌邪的上帝。我必降祸于罪人的子孙；恨我的人，我要追讨他们的罪，直到第三、四代子孙； ");
INSERT INTO cmn2006_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","爱我的、守我诫命的人，我要以慈爱待他们，直至子孙千代。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“不可滥用我－你们的上帝的名字；凡滥用我的名字的人，我要定他有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“要纪念安息日，守为圣日。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","在其余的六天里可以做工， ");
INSERT INTO cmn2006_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","第七天是属于我－你们的上帝的安息日。在安息日这天，无论是你自己、你的儿女、奴婢、牲畜，还是侨居的外族人都不可做工。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","因为，主在六天里创造了天地海洋和其中的万物，在第七天歇工休息了。所以，主赐福给第七天，定为圣日。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“要孝敬父母，这样，才能在我－你的上帝赐给你的土地上福寿绵长。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“不可杀人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“不可奸淫。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“不可偷窃。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“不可做假证陷害他人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“不可贪图别人的家产；也不可贪恋别人的妻子、奴婢、牛驴和其他东西。” ");
INSERT INTO cmn2006_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","人们听见雷声与号角声的轰鸣，看见闪电和笼罩山体的浓烟，都非常害怕，远远地站立着。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","他们对摩西说∶“请你向我们讲话吧！我们一定听从你的话。请不要让上帝直接对我们讲话，否则，我们都会死掉。” ");
INSERT INTO cmn2006_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","摩西对人们说∶“不要害怕；上帝的降临是要考验你们，好让你们敬畏他，不致犯罪。” ");
INSERT INTO cmn2006_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","人们依然远远地站着，只有摩西一人走近上帝所在的浓云。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","主吩咐摩西告诉以色列人∶“你们已经看见主怎样从天上向你们说话。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","你们不可为自己做任何金的或银的神像与我并列。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“你们要用土为我筑一座祭坛，作为烧化祭和平安祭，把牛羊供献在坛上。在我指定敬拜我的每一个地方，我都要到那里赐福给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","如果你们用石头为我筑祭坛，不可用凿过的石头。因为你用錾子凿石头的时候就把石头玷污了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","不可由台阶登上我的坛，以免你们登坛时露出下体。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“你要把下列典章公布于众∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“如果你买一个希伯来人做奴隶，他只须服侍你六年。到了第七年，他就可以恢复自由而不必付任何赎金。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","如果他是单身被买来的，那么他只能单身离去；如果他来的时候带着妻子，那么他的妻子可以与他一齐离去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","如果他的主人为他娶了妻，生了子女，那么他的妻子和儿女属主人所有，他只能一个人离去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“如果奴隶本人声明他爱他的主人和自己的妻子儿女，不愿自由离去， ");
INSERT INTO cmn2006_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","那么他的主人就必须带他到敬拜上帝的圣所，让他靠着门或门框站着，用钻在他的耳朵上钻一个孔，这样，他将终身服侍他的主人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“如果有人把自己的女儿卖为奴隶，她不能象男奴隶那样恢复自由。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","如果她的主人本意想纳她为妻，后来又不喜欢她，那么就要允许她赎身；她的主人既已对她失信，就不得再把她转卖给其它氏族。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","如果她的主人把她选给自己的儿子，就要象待自己的女儿一样待她。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","如果她的主人在她之外另娶，那么他不可拒绝她的衣食和性的权利。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","如果她的主人做不到这三点，她就可以自由离去而不必付赎身费。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“凡伤人至死的，必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","如果不是故意杀人，上帝允许此事发生，那么他可以逃避到我指定的地方去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","如果有人盛怒之下蓄意杀人，即便他逃到我的祭坛前，也要捉拿处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“凡欧打父母的，必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“凡拐带人口的，无论是把人卖了还是自己留下，都必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“凡咒骂父母的，必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“两人打架时，一方用石块或拳头打伤对方，被打的一方因伤卧床但并未致死， ");
INSERT INTO cmn2006_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","而且以后能够起床，扶杖出门行走，那么打人的一方可以不受刑罚，但是他必须赔偿对方在治疗期间蒙受的损失，并负责把他治好。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“凡用棍子欧打奴婢立时致死的，必须判罪。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","如果被打的奴隶过了一两天幸免于死，那么主人就不算有罪。因为奴隶是属于他的财产。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“如果有人打架时伤了孕妇，以致孕妇早产，但没有造成其他损害，那么打伤她的人必须受罚。赔偿的数目由孕妇的丈夫提出，经法官认可。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","如果孕妇还受到其他伤害，那人就得以命抵命， ");
INSERT INTO cmn2006_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","以眼还眼，以牙还牙，以手还手，以脚还脚， ");
INSERT INTO cmn2006_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","以烙还烙，以伤还伤，以打还打。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“如果有人打坏了男女奴仆的眼睛，那么他必须释放那个奴仆，作为对伤害眼睛的赔偿。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","如果他打掉了奴仆的牙齿，那么也必须释放那个奴仆，作为对他牙齿的赔偿。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“牛抵死了人，要用石头打死它，它的肉不可吃，牛的主人不算有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","如果牛常常抵伤人，它的主人屡次受警告而仍不把牛拴好，以致牛抵死了男人或女人，那么，牛要用石头打死，牛的主人也要处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","如果牛的主人被判以罚款抵命，那么他必须如数交纳罚金。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","牛抵死了男孩或女孩，也按上述方法处理。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","牛抵死了奴婢，牛的主人要给奴婢的主人三十块银子作为赔偿，牛要用石头打死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“如果有人打开井盖或挖了井而不把井口盖好，以致牛或驴跌了进去， ");
INSERT INTO cmn2006_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","他必须拿钱给牲畜的主人作为赔偿，跌死的牲畜归他所有。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“如果一头牛抵死了另一头牛，那么双方要把活牛卖掉，卖得的钱平分；死牛的肉也由双方平分。 ");
INSERT INTO cmn2006_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","如果那牛素来好斗，而它的主人却没有把它拴好，那么他必须赔偿对方一头活牛，而死牛归他所有。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“如果有人偷了一头牛或一只羊，无论宰了还是卖了，他都必须用五牛赔一牛，用四羊赔一羊。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“窃贼夜间破门行窃时被人家捉住杀死，杀死他的人不算有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","如果事情发生在白天，那么杀死他的人就犯有杀人罪。 “贼必须如数赔还所偷的东西。如果他一无所有，那就把他卖为奴隶，用他的身价偿还所偷的东西。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","如果被偷的牛、驴或羊被发现时还活着，他也得加倍偿还。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“如果有人在田里或葡萄园里放牧牛羊，而让他的牛羊在别人的田里或葡萄园里乱跑乱啃，他必须用自己出产的最好的谷物或葡萄赔偿对方。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“如果有人在田里放火烧荒，火由荆棘蔓延到别人的田里，烧毁了未收割的或已收割的庄稼或全部，那么放火的人必须赔偿对方的损失。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“托人保管的钱物被窃贼偷走后，如果贼被捉到了，要加倍索还； ");
INSERT INTO cmn2006_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","如果贼捉不到，受托人必须到敬拜上帝的圣所去，以裁决他是否侵吞了别人财物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“任何财物纠纷，无论是牛、驴、羊、衣服还是其它他俩声称丢失的东西，争执的双方要一齐到敬拜上帝的圣所去，上帝裁决有罪的一方要加倍偿还对方。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“如果托人看管的驴、牛、羊或其他牲畜或死或伤或被人牵走而无人作证， ");
INSERT INTO cmn2006_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","受托人要在主的面前向物主发誓，说明自己并未损害或侵吞别人的财产。物主必须认可，受托人不必作出赔偿。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","但是，如果牲畜是被偷走的，受托人就要赔偿物主。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","“如果牲畜是被野兽咬死的，受托人要把死畜带来作证，不必赔偿。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“如果有人借用别人的牲畜，物主不在场时牲畜或伤或死，借用的人都必须赔偿。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","如果物主在场，就不必赔偿。如果牲畜是租用的，由租金抵偿。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“如果有人诱奸了未定婚的处女，就必须付出聘礼，娶她为妻。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","如果女方的父亲坚决不肯把女儿嫁给他，那么他仍然必须付给女方相当于聘处女的聘金。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“行邪术的女人必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“兽淫的人必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“向主之外的其他神明献祭的人必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“不可虐待或欺压外侨；要记住，你们自己就曾寄居在埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“不可虐待寡妇或无父的孩子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","如果你们虐待他们，他们会向我呼求，我必垂听他们的呼声。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","那时，我会向你们发怒，使你们死于刀下，你们的妻子将成为寡妇，你们的子女将成为孤儿。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“如果你借钱给我的子民中的穷人，不可象放债的人一样向他索要利息。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","如果你拿了他的衣服作抵押，必须在日落之前还给他， ");
INSERT INTO cmn2006_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","因为这衣服是他唯一的蔽体御寒之物，没有它怎么睡觉呢？他向我呼求帮助，我必垂听他的呼声，因为我是仁慈的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“不可毁谤上帝，也不可诅咒民众的首领。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“丰收并有盈余后不要迟迟不向我献祭。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","“把你的长子献给我，同样，所有头生的牛羊也要献给我。它们出生后可以和它们的母亲在一起呆七天；到第八天，你们要把它献给我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","你们是我圣洁的子民，不可吃被野兽撕碎的牲畜的肉，那些肉要丢掉喂狗。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“不可散布流言蜚语；不可做伪证，与恶人同流合污。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“不可随声附和多数人作坏事，在诉讼中作证时不可为迎合多数人的好恶而歪曲事实。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“不可在诉讼中偏袒穷人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“遇见仇人走失的牛或驴，要牵回来交还给他。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","如果看见仇人的驴负重跌倒，要帮忙把驴拉起来，不可丢下不管。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“不可在诉讼上剥夺穷人的正当权利。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“不可诬告和屈杀正直无辜的人，因为我不会放过有罪的人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“不可收受贿赂，因为贿赂会混淆视听，冤屈无辜。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“不可欺压外侨；你们也曾寄居埃及，当能体味寄居他乡的心情。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“你们可以连续六年耕种土地，收获产物； ");
INSERT INTO cmn2006_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","但在第七年，你要让土地歇息，不耕不种；穷人可以来收聚地里的产物，剩下的让野兽吃掉。你的葡萄园和橄榄园也要照此办理。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“你们每周可以连续工作六天；第七天不可工作，好让你的奴仆和外族雇工有歇息和恢复精力的时间，同时也让你的牛和驴得以休息。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“你们要谨守我对你们所说的一切，不可拜异族神明，连他们的名字也不许在祷词和誓言中提及，更不可通过你们的口去传扬。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“每年要为我守三个节。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","在亚笔月内指定的时间，就是你们离开埃及的那个月，要照我的吩咐守无酵节。在节期的七天里，不可吃有酵的饼，不可空手来敬拜我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","在开始收割庄稼的时候要守收获节。在岁末收藏谷物的时侯要守收藏节。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","每逢这三个节期，你们所有的男子都必须敬拜主上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“以牲血向我献祭时，不可同时献上任何含酵的东西。我的节日的祭牲的脂油不可留到第二天早晨。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“要把初熟谷物的最好的部分送到我，主－你们的上帝的殿堂里。 “不可用母羊的奶煮小羊。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“我要派使者在你们的前面，沿途保护你们，把你们领到我为你们预备好的地方去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","他以我的名义而来，你们要尊重他，服从他，不可违背他的意愿；因为他不会宽恕叛逆的行为。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","但是，如果你们真心服从他，并且谨守我所说的一切，那么，我必与你们同仇敌忾。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","我的使者会先你们而行，领你们进入亚摩利人、赫人、比利洗人、迦南人、希未人和耶布斯人的土地，而我要消灭这些异族人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","你们不可跪拜或侍奉他们的神明，不可效法他们的作为；相反，你们要拆毁他们的神像，打碎他们的神柱。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“你们要侍奉我，主－你们的上帝；如果你们这样做，我一定赐福给你们，赐给你们食物和水，除掉你们的一切疾病。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","你们的妇女没有一个会流产或不育。我还要赐给你们长寿。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“凡你们所到之处，我必使对抗你们的人惊慌失措，闻风逃遁。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","我要用大黄蜂为你们开道，赶走你们前面的希未人、迦南人和赫人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","我不在一年之内赶尽他们，免得土地荒废野兽过多为害你们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","我要逐步地赶走他们，直到你们的人口增加并最终占有了这块土地。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“你们的边界将从红海直至非利士海，从旷野直至幼发拉底河。我将把那片土地上的居民交在你们的手中，你们要把他们驱逐出去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","你们不可与他们或他们的神明立约。 ");
INSERT INTO cmn2006_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","不可让他们住在你们境内，否则，他们会唆使你们得罪我。因为你们也许会去拜他们的神明，那将使你们陷于罪中。” ");
INSERT INTO cmn2006_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","主对摩西说∶“你和亚伦、拿答、亚比户以及七十位以色列首领上山到我这里来，在远处向我敬拜； ");
INSERT INTO cmn2006_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","然后，只有你一人可以到我跟前来，其余的人不许靠近。百姓不准随你一起上山。” ");
INSERT INTO cmn2006_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","摩西下山，向人民颁布了主的律例和训诫。全体民众同声回答∶“我们一定遵照主的吩咐行事。” ");
INSERT INTO cmn2006_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","摩西把主的命令一一写了下来。 第二天一早，摩西在山脚下筑了一座坛，并竖立了十二根石柱，分别代表以色列的十二支派。 ");
INSERT INTO cmn2006_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","他差遣一些年轻的以色列人用公牛向主献上烧化祭和平安祭。 ");
INSERT INTO cmn2006_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","摩西把公牛的血一半盛在盆里，一半洒向祭坛。 ");
INSERT INTO cmn2006_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","然后，向民众宣读了约书。以色列人说∶“我们愿意遵行主的一切命令。” ");
INSERT INTO cmn2006_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","摩西把盆里的血洒在民众的身上，说∶“这是主与你们立约的血，是关于这些诫命的。” ");
INSERT INTO cmn2006_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","摩西、亚伦、拿答、亚比户和七十位以色列首领一起上了山， ");
INSERT INTO cmn2006_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","他们看见了以色列的上帝。在他脚下，仿佛有一条用兰宝石铺成的大道，象澄碧的天空一样兰。 ");
INSERT INTO cmn2006_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","上帝没有伤害这些以色列人的首领。他们瞻仰了上帝；在那里又吃又喝。 ");
INSERT INTO cmn2006_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","主对摩西说∶“你上山到我这里来。留在这里，我要把写有我的律法和诫命的石版赐给你，你要用它们教导以色列人。” ");
INSERT INTO cmn2006_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","于是，摩西带着他的助手约书亚动身，登上上帝的山。 ");
INSERT INTO cmn2006_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","摩西对以色列的首领们说∶“你们在这里等候我们回来。亚伦和户珥留在你们这里，有纠纷可以找他们解决。” ");
INSERT INTO cmn2006_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","摩西上了山；云彩笼罩着山峰。 ");
INSERT INTO cmn2006_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","上帝的光环降临在西乃山上；云彩笼罩了西乃山六天。第七天，主从云彩中间召唤摩西。 ");
INSERT INTO cmn2006_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","在以色列人眼中，上帝的光环象一团烈火在山顶上熊熊燃烧。 ");
INSERT INTO cmn2006_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","摩西走进云里，登上圣山，在那里停留了四十昼夜。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“告诉以色列人，让他们献礼物给我。凡自愿献给我的礼物你们都可以收下。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","你们可以接受的礼物是∶金、银、铜； ");
INSERT INTO cmn2006_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","兰色、紫色和红色的毛线；麻纱；山羊毛； ");
INSERT INTO cmn2006_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","染红的公羊皮；精美的皮料；金合欢木； ");
INSERT INTO cmn2006_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","灯油；制作膏油和香的香料； ");
INSERT INTO cmn2006_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","红玛瑙和用来镶嵌在以弗得圣衣和胸牌上的其他宝石。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“以色列人要为我造一处圣所，好让我住在他们中间。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","圣幕和其中所有器具都要严格按照我指示的样式制作。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“要用金合欢木造约柜。柜长131公分，宽78公分，高78公分。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","要用纯金把柜的内外都包裹起来，周围镶上金边。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","要铸4个金环，安装在柜的四角，每边两个。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","用金合欢木做两根杠子，也用纯金包裹； ");
INSERT INTO cmn2006_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","杠子穿在柜两边的金环里，以便抬柜。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","杠子要留在环内，不可抽出来。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","把我将要赐给你的写有诫命的石版放入柜中。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“要用纯金造赎罪台。长131公分，宽78公分。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","要用金子锤出两个基路伯， ");
INSERT INTO cmn2006_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","分别安装在赎罪台的两端，使它们与赎罪台成为一体。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","基路伯要彼此相对，面向赎罪台，向上展开翅膀将赎罪台遮住。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","要把我赐给你的法版放在柜内，把赎罪台放在柜的上面。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","我要在那里与你相会，并从赎罪台上面的两个基路伯之间向你讲述我为以色列人制定的诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“要用金合欢木做一张桌子。长105公分，宽52公分，高78公分。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","桌子要用纯金包裹，并在四周镶上金边。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","桌子的四周要加上8公分宽的边缘，边缘也要镶上金边， ");
INSERT INTO cmn2006_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","要做四个金环，分别安装在桌子四角的四条桌腿上， ");
INSERT INTO cmn2006_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","环要靠近桌子的边缘，以便抬桌子的杠子穿入。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","抬桌的杠子要用金合欢木制成，也要用金包裹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","桌上的盘子、碟子、壶和奠酒用的杯都要用纯金制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","桌上要常年陈设供饼，献在我的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“要用纯金造一个灯台；灯台的底座和柱要用锤子锤出来，上面的花朵、花萼、花瓣也要用同一块金子锤出来，与灯台浑然一体。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","灯台两边伸出六根枝子，每边三根。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","每根枝子上要有三朵花，形状象杏花，有萼和瓣。六根枝子都要制成这种形状。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","灯台上还要有四朵花，形状象杏花，有萼有瓣。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","每对枝子的下部由灯柱伸出的地方有一个萼相接，三对枝子都是如此。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","花萼和枝子应与灯台连为一体，用一块纯金锤制出来。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“要为灯台做七盏灯，灯的位置要使灯光向前照射。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","灯台的蜡剪和烛盘也要用纯金制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","以上所有器具和灯台的制作需用34公斤纯金。 ");
INSERT INTO cmn2006_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","务必要按照我在山上指示你的样式制做这一切。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“要用十幅幔子做圣幕。这些幔子要用麻纱和兰色、紫色、深红色的毛线交织制成，上面要有精心刺绣的基路伯图案。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","每幅幔子长14米，宽2米；所有的幔子大小相同。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","每五幅幔子连在一起，成为一组， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","每组幔子的最末一幅的边缘上要用兰色的毛线缀上纽环， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","两幅幔子各缀50个纽环，两两对应， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","再做50个金钩，用钩子把两组幔子连在一起，圣幕就做成了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“要用山羊毛织十一幅幔子作圣幕的幕顶。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","每幅幔子长15米，宽2米；所有的幔子大小相同。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","把其中五幅幔子连在一起，成为一组；其余六幅连在一起，成为另一组；第六幅要摺成两层，垂在圣幕的正面。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","每组幔子的最末一幅的边缘上要各缀50个钮环， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","再做50个铜钩，用钩子钩住钮环，使两组幔子连成整块幕顶。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","余下的半幅幔子要垂在圣幕的背面。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","幕顶两边余下的52公分长的幔子要垂在圣幕的两边，把圣幕遮住。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","在幕顶上要再安置一个用染红的公羊皮制成的幕顶，在上面还要再安置一个用精美的皮料制成的幕顶，用做圣幕的外层顶盖。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“要用金合欢木作支撑圣幕的骨架。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","每根骨架高5米，宽78公分， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","骨架有两个榫头，用来彼此联接。所有的骨架形状相同。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","要在圣幕的南面立二十个骨架， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","下面安放四十个银底座，每个骨架下面安装两个底座，每个底座各支撑一个榫头。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","圣幕的北面也有二十个骨架和 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","四十个银底座，每根骨架下面也安放两个底座。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","在圣幕的后部，就是幕的西边，要立六个骨架， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","在圣幕后部的拐角处要立两个骨架， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","这两个骨架的底部要连在一起，顶端要用环箍住。两个拐角都要这样处理。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","总共需要8根骨架和16个银底座，每两个底座支撑一根骨架。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“要用金合欢木制做十五根横木；圣幕一侧的骨架上装五根， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","另一侧的骨架上也装五根，另外五根装在西侧，也就是圣幕后面的骨架上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","中央的横木要安在骨架的腰间，从一端通到另一端。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","骨架要用金子包裹，并装上金环，用以固定横木；横木也要用金包裹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","要按照我在山上指示给你的方式把圣幕竖立起来。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“要用麻纱和兰色、紫色、深红色的毛线制成帐幔，精心绣上基路伯的图案。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","把帐幔挂在四根用金合欢木制成的柱子上，柱子用金包裹，并装有金钩，安在四个银底座上， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","帐幔就垂挂在钩子上。约柜安放在帐幔的后面。这幅帐幔把圣所和至圣所隔离开来。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","赎罪台安放在至圣所内的约柜上面， ");
INSERT INTO cmn2006_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","桌子放在帐幔外圣幕的北面，灯台安在圣幕的南面，与桌子相对。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“要用麻纱和兰色、紫色、深红色的毛线制作一幅门帘，绣上图案，挂在圣幕的入口处。 ");
INSERT INTO cmn2006_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","在入口处要用金合欢木为门帘做五根柱子，用金包裹，并装上金钩，安在铜铸的底座上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“要用金合欢木造祭坛。坛是四方形的，长2.6米，宽2.6米，高1.5米。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","要在坛的拐角处分别作四只角，角要与坛联为一体，并用铜包裹整个坛体。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","要用铜制作收灰的桶、铲子、碗、叉子和火盆。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","要为祭坛做一个铜网，在网的四角安上铜环， ");
INSERT INTO cmn2006_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","铜网安放在祭坛底部框架的下面，向上延伸到祭坛的二分之一高度处。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","要用金合欢木为祭坛做杠子，用铜包裹， ");
INSERT INTO cmn2006_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","抬祭坛时，把杠子穿进祭坛两边的铜环里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","要用木板造祭坛；坛是中空的。要按照我在山上指示你的方法去做。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“要为圣幕造院子。院子的南面是用麻纱制成的帷幔，长52米， ");
INSERT INTO cmn2006_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","挂在二十根安在铜底座上的柱子上，帷幔由银杆上的银钩勾住，银杆安在柱子上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","院子的北面与南面相同，帷幔长52米，挂在二十根安在铜底座上的柱子上，柱子上的钩和杆也都是用银制成的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“院子西面的帷幔长26米，挂在十根带底座的柱子上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","院子的东面，也就是院子的正面，宽26米， ");
INSERT INTO cmn2006_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","门的两侧各有7.8米宽的帷幔，挂在三根带底座的柱子上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“院子的门前要有10.5米长的门帘，用麻纱和兰色、紫色、深红色的毛线制成，绣有图案，挂在四根带底座的柱子上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","院子四周的柱子要用银杆联接，柱子上的钩子要用银制成，底座用铜制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","院子长52米，宽26米，四周挂的帷幔高2.6米。帷幔要用麻纱制成，柱底座用铜制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","与圣幕有关的各种器具，包括立圣幕、运圣幕的用具和橛子以及围院子所用的橛子，都要用铜制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“吩咐以色列人把专为点灯而榨制的清橄榄油交给你，使灯常亮不熄。 ");
INSERT INTO cmn2006_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","在约柜前的帐幔之外，亚伦和他的子孙要让会幕里的灯在主的面前夜夜长明。以色列人和他们的子子孙孙必须永远谨守这诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“你要从以色列人当中选召你的哥哥亚伦和他的儿子拿答、亚比户、以利亚撒、以他玛，立他们作祭司来侍奉我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","要为亚伦制作圣服，使他显得庄严而华美。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","要吩咐那些我赐与技能的能工巧匠，让他们为亚伦缝制衣服，好让亚伦归圣，供职祭司来侍奉我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","吩咐他们为亚伦和他的儿子们制作胸牌、以弗得、外袍、内袍、织成礼冠和腰带，好让他们能担任我的祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","工匠们会从民众那里得到金线和兰色、紫色、深红色的毛线及麻纱。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“他们要用金线和兰色、紫色、深红色的毛线及麻纱精心绣制以弗得， ");
INSERT INTO cmn2006_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","以弗得应该有两条肩带，肩带要与以弗得的前后两片相连，以构成一件衣服。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","以弗得的带子也要用同样的材料精心制成，并要与以弗得连在一起，使它们成为一体。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“取两块红玛瑙，在上面刻上以色列十二个儿子的名字。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","按照他们出生的次序，在一块宝石上刻下六个儿子的名字，在另一块宝石上刻下其余六个儿子的名字。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","要象宝石匠刻印章一样把以色列的儿子们的名字刻在两块宝石上，再把宝石镶在金底托上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","然后，把它们安在以弗得的肩带上，代表以色列的十二儿子的名字。这样，当亚伦侍立于我的面前时，他的肩上就担着十二支派的名字，它们将使我记念我的子民。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","要用纯金做这两个底托， ");
INSERT INTO cmn2006_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","再做两条纯金的链子连在底托上，链子的形状要象绞成的绳子一样。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“要为大祭司特制一块用来推断上帝旨意的胸牌，与制作以弗得一样，胸牌要用金线和兰色、紫色、深红色的毛线及麻纱精工制作。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","胸牌呈正方形，叠成两层，每边长一揸（约二十三公分）。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","要在胸牌上面镶上四行宝石，第一行镶的是红宝石、红璧玺和红玉； ");
INSERT INTO cmn2006_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","第二行镶的是绿宝石、兰宝石和钻石； ");
INSERT INTO cmn2006_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","第三行镶的是紫玛瑙、白玛瑙和紫晶； ");
INSERT INTO cmn2006_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","第四行镶的是水苍玉、红玛瑙和碧玉。这些宝石都要镶在金底托上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","每块宝石上如同印章一样刻有一位以色列的儿子的名字，十二块宝石代表以色列的十二支派。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“要用纯金制作胸牌的链子，链子的形状应当象绞成的绳子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","要做两个金环安在胸牌的两端。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","把两条金链分别系在这两个金环上， ");
INSERT INTO cmn2006_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","金链的另外两端分别接在两个底托上，再把它们系在以弗得前面的肩带上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","再做两个金环，安在胸牌另外两端内侧挨近以弗得的边缘上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","还要做两个金环，安在以弗得前面两条肩带下方和带子上方靠近接缝之处。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","要用兰色的带子把胸牌上的环与以弗得的环系住，使胸牌贴在以弗得的带子上，不至与以弗得松开。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“亚伦进入圣所的时候，要把这刻有以色列十二支派名字的胸牌戴在胸前；这是在主面前的永久的记念物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","要把乌陵和土明放在胸牌里，当亚伦来见我的时侯，一定要把它们带在胸前。这样，亚伦在我面前时就时刻具有为以色列人推断我的意志的能力。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“以弗得的外袍应该完全是兰色的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","袍上要留一个领口，领口的周围要加织领边，就象铠甲的领口一样，以免破裂。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","袍子的底边上要饰有用兰色、紫色、深红色毛线做的石榴，间以纯金的小铃铛。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","亚伦供职的时候必须穿上这件袍子，这样，当他进入圣所来见我或从我面前退出时，我就能听到小铃的声音，使他不至被杀。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“要用纯金做一块牌子，按刻印章的方法在上面刻上‘圣化归主’的字样。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","要用兰色的带子把它系在礼冠的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","亚伦把它戴在头上，表明他已经承当了以色列人向主献祭时要赎的罪孽责任。亚伦要始终把它戴在额前，这样，我就会悦纳以色列人所献的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“要用麻纱制作内袍和礼冠，腰带上要绣花。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","也要为亚伦的儿子们制作内袍、腰带和礼冠，使他们显得庄严而华美。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","你要给你的哥哥亚伦和他的儿子们穿上圣服，为他们膏油，授以圣职，使他们归圣，立他们作祭司侍奉我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“要用麻纱为他们做裤子；裤子要从腰间直至大腿以遮掩下体。 ");
INSERT INTO cmn2006_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","亚伦和他的儿子们走进会幕或走近祭坛在圣处执礼时必须穿好，以免获罪而被杀。 “亚伦和他的后裔要永远谨守这一律例。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“你要按下述程序使亚伦和他的儿子们归圣，立他们为祭司来侍奉我。 “要取一头小公牛和两只公绵羊，都必须是没有残疾的； ");
INSERT INTO cmn2006_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","用最好的面粉制作无酵饼、调油无酵饼和涂油无酵薄饼。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","你把这些饼放在一只篮子里，连同那头小公牛和那两只公绵羊一起带来。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","你要把亚伦父子领到会幕的门前来，并用水给他们沐浴净身。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","然后，取来衣服，给亚伦穿上内袍、以弗得的外袍和以弗得，带上胸牌，束好以弗得上的华美的腰带。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","要替他戴上礼冠，并把圣冠加在礼冠上， ");
INSERT INTO cmn2006_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","再把膏油倒在他的头上，行膏立之礼。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","然后，把亚伦的儿子们带来，替他们穿上内袍， ");
INSERT INTO cmn2006_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","束上腰带，戴上礼冠。这样，亚伦和他的儿子们就按照永久不变的律法成为祭司。这就是授圣职于亚伦和他的儿子们的程序和规例。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“你要把那头小公牛牵到会幕前来，吩咐亚伦和他的儿子们把手按在牛的头上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","你要在会幕的门前当着我的面把牛杀掉。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","然后，用手指蘸一些牛血抹在祭坛上的四个角上，其余的血倒在坛脚那里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","要把包着内脏的脂肪、肝叶和带脂肪的两个腰子放到祭坛上烧化。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","而牛的皮、肉和其他部位要拿到营外烧掉。这是洁净祭。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“再牵过一只公绵羊来，吩咐亚伦和他的儿子们把手按在羊的头上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","然后，你杀掉羊，把血洒在祭坛壁上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","整只羊要切成碎块，内脏和四肢要洗净，然后，把它们与羊的头和碎肉一起 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","放到祭坛上烧化；这是献给主的烧化祭，是献给主的礼物，这香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“你再牵过另一只羊来，吩咐亚伦和他的儿子们把手按在羊的头上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","你把羊杀掉，拿一点血涂在亚伦和他儿子们的右耳垂、右手大姆指和右脚的大脚趾上。然后，把其余的血洒在祭坛壁上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","再从祭坛上取一些血和膏油洒在亚伦和他的儿子们的身上和衣服上，使亚伦和他的儿子们以及他们所穿的衣服圣化。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“要取下羊的脂肪－肥尾巴、包着内脏的脂肪，肝的最好部分，两个带脂肪的腰子－和右腿（这是承接圣职所献的羊）， ");
INSERT INTO cmn2006_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","再从那篮奉献给我的无酵饼里拿一块饼、一块调油饼和一块薄饼， ");
INSERT INTO cmn2006_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","把这些都交给亚伦和他的儿子们，让他们举起来作为举祭献给我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","然后，你把这些东西接过来，与献祭的羊一起放在祭坛上烧化。这是献给主的礼物，这香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","你从亚伦承接圣职时奉献的羊上取下胸肉，把它在我面前举起来，作为举祭献给我；这份祭肉归你所有。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“授圣职时作为举祭献给我的羊的胸肉和腿肉要归圣，这份肉归亚伦和他的儿子们所有。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","以色列人向我献平安祭时，祭牲的胸肉和腿肉永远归亚伦和他的子孙所有；那也是以色列人献给我的祭物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“亚伦死后，他的圣服要传给他的子孙，以便他们在受膏和接任圣职时穿用。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","亚伦的子孙中无论谁继承他作祭司，每逢进入会幕在圣所供职的时候，都要连续七天穿着这圣服。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“你要把授圣职时献祭的羊肉拿到圣化之处去煮。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","亚伦和他的儿子们要在会幕的门口吃这羊肉和篮子里的饼。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","只有他们可以吃这些授圣职时的赎罪之物，以便承接圣职，圣化归主。其他人不可以吃，因为这食物已经归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","如果这些肉和饼当天吃不完，第二天早上就得烧掉，不可以再吃，因为它们已经归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“你要按我的吩咐为亚伦和他的儿子们做这些事，就职祭司的典礼要持续七天。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","每天，还要献上一头公牛为赎罪礼作洁净祭；你要为坛行赎罪礼以洁净祭坛，用膏油涂抹祭坛，使它归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","你要连续洁净坛七天；七天之后，祭坛就为至圣。凡触碰祭坛的一切东西都将归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“你要每天在祭坛上献两只一岁大的羊羔， ");
INSERT INTO cmn2006_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","早晨一只，傍晚一只； ");
INSERT INTO cmn2006_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","早晨献第一只羊羔时，应同时献上一公斤用清油调和的细面粉，油的用量也是一公斤；另外，再献上一公升酒做为奠祭。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","傍晚献第二只羊羔时，要象早晨一样献上素祭和奠祭。这是献给主的食物，这香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“这是你们世世代代要按例在会幕门前献给我的烧化祭；那里也是我与你们相会，给你们训示的地方。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","我在那里与我的子民相会，我的荣耀将圣化会幕。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“我要使会幕和祭坛归圣，也要使亚伦和他的儿子们归圣，成为侍奉我的祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","我将住在以色列人中间，作他们的上帝， ");
INSERT INTO cmn2006_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","要让他们知道我是主，是他们的上帝，我把他们从埃及领出来，就是要住在他们中间。我是主，是他们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“你要用金合欢木造一座供烧香用的祭坛。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","坛是四方形的，长52公分，宽52公分，高105公分。坛上面的角要与坛连成一体。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","坛的顶端、侧面和坛上的角都要用纯金包裹，四周要镶上金边。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","还要做两个金环，安在坛两侧的金边下面，作为抬坛时穿杠之用。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","抬坛的杠子要用金合欢木制成，用金包裹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","香坛要放在约柜前的帐幔之外、赎罪台的前方，那里是我与你们相会的地方。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“每天早晨，亚伦要来整理灯具，在坛上烧芬芳的香。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","傍晚，他也必须来点灯焚香。这要成为你们世世代代奉献给主的常规的香祭。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","不可在坛上烧异样的香，不可在坛上献烧化祭或素祭，也不可献奠祭。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","亚伦要在坛的角上行一年一度的赎罪礼仪，用洁净祭牲的血在坛上行赎罪礼，世世代代不可中断。这坛在我面前归为至圣。” ");
INSERT INTO cmn2006_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“你核查以色列人口时，每个人都要向我交赎命金，以免在核查过程中遭逢祸灾。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","每个被登记的人要交纳半舍客勒银子作为献给我的礼物，银子用圣所的天平称量。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","每个二十岁以上登记在册的人都要向我献上这笔赎金。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","富人不多付，穷人不少付；这是你们为赎回自己的生命向主做的奉献。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","你要从以色列人那里收取这笔赎罪金。这些钱用来维持圣幕的费用。这是以色列人为赎回自己的生命付出的赎价，我会因此记念他们。” ");
INSERT INTO cmn2006_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“你要做一个供洗浴用的铜盆和一个铜盆座，把它放在会幕与祭坛中间，注满了水。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","亚伦和他的儿子们必须用这盆里的水洗净手脚。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","当他们进入会幕或走近祭坛献烧礼物时，必须用这盆里的水洗濯，以免被杀。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","他们必须洗过手脚才能免死；这是亚伦和他的子孙后代永远要谨守的规例。” ");
INSERT INTO cmn2006_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“取下述上等香料∶没药汁六公斤，香桂肉三公斤、香菖蒲三公斤、 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","桂皮六公斤，在这些香料中加入四公升的橄榄油， ");
INSERT INTO cmn2006_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","用调制香水的方法制成圣油。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","要用它膏会幕、约柜、 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","供桌和桌上的一切器具、灯台及其附设之物、香坛、 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","献烧化祭的坛及其应用器具、铜盆和盆座， ");
INSERT INTO cmn2006_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","使它们圣化，且归为至圣。凡触碰了它们的一切都要归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“你要用它膏亚伦和他的儿子们，使他们归圣，立他们作祭司来侍奉我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","你要告诫以色列人∶‘这是你们世世代代敬奉于我的圣膏油， ");
INSERT INTO cmn2006_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","不可把它倒在常人身上；不可用同样方式制作与它相似的油；因为它是圣油，你们要以它为圣物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","任何人配制同样的油或把它涂在未经认可的人身上，都必须将他从族中除名。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","主对摩西说∶“取同等份量的苏合香、香螺、白松香和纯乳香， ");
INSERT INTO cmn2006_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","把它们混合在一起，按调制香水的方法配制，再加上盐，使它纯净圣化， ");
INSERT INTO cmn2006_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","把其中一部分捣成细粉，带到会幕里，撒在约柜的前面；那里是我与你们相会的地方。这香是你们的至圣之物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","不可用相同的配方为自己制香；因为它是你们献给我的圣物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","任何人配制同样的香供自己享用都必须将他从族中除名。” ");
INSERT INTO cmn2006_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“看！我已经选召了犹大支派的比撒列，他是户珥的孙子、乌利的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","我的灵将降在他的身上；我将赐给他技能、聪明和才智，使他能胜任所有各种工作。 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","他能够作设计；能用金、银、铜制作各种器具； ");
INSERT INTO cmn2006_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","能雕刻可镶嵌的宝石；能雕刻木头；还能作其他各种精细的工艺。 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","我又从但支派中选召了亚希撒抹的儿子亚何利亚伯做他的助手。我也把技艺赐给了那些匠人，使他们能够制作我所吩咐的一切， ");
INSERT INTO cmn2006_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","包括∶会幕、约柜和赎罪台、会幕内的一切用具、 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","供桌和桌上的器具、纯金的灯台及其附属物、香坛、 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","献烧化祭的坛及其应用器具、盆和盆座、 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","亚伦和他的儿子们供职祭司时所穿的圣服、 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","圣油和供圣所使用的馨香的香。所有这一切他们都要按照我吩咐你的去做。 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“你要告诫以色列人∶‘无论如何，你们要谨守安息日，这是我与你们之间永久的凭证，只有这样你们才能记住，是我－主，选召了你们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","你们要谨守安息日，这是你们的圣日。无论谁亵渎了这天都必须处死。凡在这天做工的人都要从族中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","你们有六天可以做工，但第七天是完全休息的安息日；它是属于我的圣日。凡在安息日做工的人都必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","以色列人要世世代代谨守这一日，这是永世不变的约， ");
INSERT INTO cmn2006_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","是我与以色列人之间永久的凭证。因为我在六天内创造了天地，在第七天歇工恢复精神了。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","主在西乃山对摩西讲完这些话，就把两块石版交给了他，上面有上帝亲自用手指写下的诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","以色列人见摩西迟迟不下山，都聚集到亚伦跟前，要求道∶“给我们造些神明吧，好让它们在前面为我们引路。领我们出埃及的那个摩西不知道出了什么事。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","亚伦对他们说∶“把你们妻子儿女戴的金耳环摘下来交给我。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","以色列人都摘下自己的金耳环，交到亚伦那里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","亚伦把民众交来的金子熔了，铸成一头牛犊。人们欢呼说∶“以色列啊，这些就是把你领出埃及的神明！” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","亚伦见到这一切，就在金牛犊的前面筑了一座祭坛，向人民宣布∶“明天要为主守节。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","第二天早晨，人们献了烧化祭和平安祭，然后，坐下来大吃大喝，狂欢作乐。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","主对摩西说∶“你赶快下山去吧！你从埃及带出来的民众犯了大罪， ");
INSERT INTO cmn2006_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","背弃了我指引给他们的路，他们为自己铸了一头金牛犊，向它跪拜献祭。他们说这些是把他们领出埃及的神明。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","主又对摩西说∶“我了解他们，知道他们是顽固之民。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","我现在就要让他们在我的怒火之中彻底毁灭，你不要阻拦我。之后，我将使你和你的后裔成为一个伟大的民族。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","摩西恳求上帝，说∶“主啊，为什么要向你的子民动怒呢？他们是你用大能从埃及领出来的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","不要让埃及人毁谤你，说你居心不良，把他们从埃及领出来，就是想要在山里把他们杀死，从世上把他们彻底灭绝掉。求你息怒，求你回心转意，不要把灾祸降在你的子民身上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","求你记念你的仆人亚伯拉罕、以撒和雅各，你曾亲自发誓并应许他们，要使他们的子孙多如天上的星星，还要把你的应许之地赐给他们的子孙作为永久的基业。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","主这才改变心意，不再把灾祸降给以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","摩西转身下山，手里拿着两块法版，法版的两面都写着诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","上帝亲自做了这两块石版，并亲自在石版上写下他的诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","约书亚听见人们的呼喊声，对摩西说∶“营里有打仗的声音！” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","摩西说∶“不，这既不是打胜仗的欢呼，也不是打败仗的叫喊；我听见的，是唱歌的声音！” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","摩西走近营地，看到金牛犊和跳舞的人群，勃然大怒，把两块石版都扔在山脚下摔碎了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","摩西取过那个金牛犊，用火熔化了，磨成粉末，撒到水里，命令以色列人喝掉。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","他问亚伦∶“这些人对你做了什么，你竟使他们陷于如此重罪之中？” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","亚伦答道∶“请别生气。你知道这些人专心于作恶。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","他们对我说∶‘请为我们造些神明来带领我们吧！我们不知道那个把我们领出埃及的摩西出了什么事。’ ");
INSERT INTO cmn2006_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","我要他们把金饰物交给我。我把这些金子熔了，就铸成了这头牛犊。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","摩西看出亚伦纵容民众，以致他们放肆，成了仇敌的笑柄。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","于是，摩西站在营门前，说∶“追随上帝的人都到我这儿来！”所有的利未人都站到了摩西的身边。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","摩西吩咐他们∶“主－以色列的上帝是这样说的∶你们每个人要佩上剑，走遍营中各处，杀掉你们的兄弟、朋友和邻居。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","利未人遵命而行，当天杀死了大约三千人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","摩西对利未人说∶“今天，你们杀了自己的儿子或兄弟，把自己献给了主。主要因此而赐福给你们。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","第二天，摩西对人们说∶“你们犯下了大罪。我现在要再上山去见主，或许能为你们求得主的宽恕。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","摩西又来见主，说∶“主啊，这些人犯了重罪，他们用金子为自己制造神像。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","求你赦免他们的罪；如果你不肯宽恕他们，求你也把我从你的子民名册中除出去。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","主对摩西说∶“我只把那些得罪我的人除名。 ");
INSERT INTO cmn2006_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","现在你去吧，把人民带到我指示你的地方去。我将派天使先你而行。但当我降下罪罚的时候，我要惩办这些罪人。” ");
INSERT INTO cmn2006_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","主在人民中降下瘟疫，因为他们要求亚伦造了金牛偶像。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","主对摩西说∶“你和你从埃及领出来的人民要离开这里，到我应许过亚伯拉罕、以撒和雅各要赐给他们后代的那片土地上去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","我将派天使先你而行，并要赶走迦南人、亚摩利人、赫人、比利洗人、希未人和耶布斯人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","你要去的地方是流奶与蜜的富饶之地。我不跟你们同去；因为你们生性顽固，恐怕我会在路上杀掉你们。” ");
INSERT INTO cmn2006_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","人们听了这话都很悲伤，没有人再佩带饰品。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","主对摩西说∶“你告诉以色列人∶‘你们是顽固之民，如果我与你们同行，哪怕很短时间，我也可能杀掉你们。现在，你们要把身上的饰物都摘下来，我再决定怎样处置你们。’” ");
INSERT INTO cmn2006_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","就这样，以色列人离开西乃山后，不再佩带饰品。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","每次安营，摩西都把帐幕设在营外，与营地保持一定距离，把它称为“会幕”。凡向主求问的人都要出营到会幕那里去。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","每当摩西进入会幕，人们都起身站在自己的帐蓬口，望着摩西，直到他进入帐幕。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","摩西进入帐幕以后，云柱就降下来，停在帐幕的门口，主在云里向摩西讲话。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","每当人们看到云柱停在帐幕的门口，都起身在自己的帐蓬口俯伏下拜。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","主与摩西面对面地说话，就象朋友之间谈话一样。摩西返回营地时，总要把他的助手嫩的儿子约书亚留在帐幕里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","摩西对主说∶“你曾吩咐我，要我率领人民到你指示的地方去，但你没有告诉我你将派谁与我同往。你曾说过凭名字你了解我，也喜欢我； ");
INSERT INTO cmn2006_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","现在，如果我确实得到你的垂爱，求你把你的计划指示给我，使我能了解你的旨意，继续在你眼前蒙恩。求你记得这个民族是你的子民。” ");
INSERT INTO cmn2006_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","主答道∶“摩西啊，我会与你一同前往的，我会让你安心的。” ");
INSERT INTO cmn2006_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","摩西说∶“如果你不和我们一起去，求你不要叫我们离开这里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","如果你不与我们同往，别人怎么能知道我和你的子民已经在你眼前蒙恩呢？只有你的同在才能使我和你的子民有别于世上的其他民族。” ");
INSERT INTO cmn2006_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","主对摩西说∶“我答应你的请求；因为我喜欢你，凭名字你了解我。” ");
INSERT INTO cmn2006_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","摩西又说∶“主啊，求你让我看见你的荣耀。” ");
INSERT INTO cmn2006_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","主答道∶“我要让我所有的荣耀从你面前经过，也要在你面前宣称我的名－主。我垂爱我喜欢的人；我恩待我怜悯的人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","但是，我不能让你看见我的面容，因为看见我的人必死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","在我的旁边有一个地方，你可以站在那里的岩石上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","当我的荣耀经过的时候，我会把你放在岩洞中，用我的手遮掩你，直到我过去； ");
INSERT INTO cmn2006_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","然后，我移开我的手，你会看见我的背，但我的面容是不能看的。” ");
INSERT INTO cmn2006_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","主对摩西说∶“你要做两块象原先那样的石版；我要把被你摔碎的石版上的诫命写在这两块石版上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","明天早晨，你要把一切准备妥当，到西乃山的山顶上等着我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","任何人不准同你一起上来，整座山不准有人逗留，山下也不准有牛羊吃草。” ");
INSERT INTO cmn2006_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","摩西凿了两块和原先一样的石版，第二天一早，按照主的吩咐，手里拿着两块石版上了西乃山顶。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","主在云中降临，停在摩西站的地方，宣告主的名。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","主从摩西的面前经过，宣告说∶“我是主，是耶和华，是仁慈和怜悯的上帝；我不轻易发怒；我有不变的慈爱与信实。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","我的慈爱存留千秋万代。我赦免罪孽、过犯和罪恶，但我决不以有罪为无罪；我不取消所有的惩罚，直到第三、四代。” ");
INSERT INTO cmn2006_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","摩西连忙伏地敬拜， ");
INSERT INTO cmn2006_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","说∶“主啊，如果我在你眼前蒙恩，求你与我们同行。尽管这人民顽固，求你宽恕我们的过失和罪恶，接纳我们作为你的产业。” ");
INSERT INTO cmn2006_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","主说∶“现在，我与你们立约，我要当着你们全体人民的面行世上前所未见的奇迹。你们周围的民族都会看见我的业绩，因为我要为你们做的事令人敬畏。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","你们要谨守我今天颁布的诫命。我要赶走你们面前的亚摩利人、迦南人、赫人、比利洗人、希未人和耶布斯人。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","你们要谨慎，不可与你们所去之处的当地居民立约，否则你们将陷入罗网。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","相反，你们要拆毁他们的祭坛，打碎他们的神柱，砍倒他们的亚舍拉神像。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","不可向其他神明跪拜，因为我－主，是妒嫉的上帝，我的名就是妒嫉者。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“所以，你们决不可与当地居民立约。他们追随他们自己的神明，向它们献祭，也会邀你们参加他们的祭祀典礼，你们会吃他们的祭物， ");
INSERT INTO cmn2006_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","况且，如果你们为自己的儿子娶了他们的女儿为妻，她们也会追随她们自己的神明，进而诱惑你们的儿子和她们一起去拜她们的神明。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“不可为自己铸造偶像。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“要守无酵节。要遵照我的吩咐在亚笔月规定的日期内吃七天无酵饼；因为你们是在亚笔月里离开埃及的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“你们的长子和一切头生的公牲畜，无论是牛还是羊，都属于我； ");
INSERT INTO cmn2006_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","头生的驴可以用羊羔赎回；若不赎回，就要打断它的脖子。你们要赎回你们的长子。 “不可空手来见我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“你可以连续工作六天，但第七天必须歇工休息，即使是在播种和收割期内，也得歇工休息。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“在收割初熟的麦子的时候，要守七七节；在岁末储藏谷物的时候，要守收藏节， ");
INSERT INTO cmn2006_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","每年，你们的每一个男子要朝拜我三次；我是主，是以色列的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","我要赶走你面前的异族，扩展你的疆域；当你一年三次来朝拜我的时候，没有人敢窥伺你的国土。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“不可将祭物的血和有酵的东西同时献上。逾越节的祭物不可留到第二天早上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“要把初熟庄稼的最好的部分送到主－你们的上帝的居所里。 “不可用母羊的奶煮小羊。” ");
INSERT INTO cmn2006_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","主对摩西说∶“你要把这些话记下来，因为我要以此为据与你和以色列人立约。” ");
INSERT INTO cmn2006_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","摩西在上帝那里停留了四十昼夜，不吃不喝。 主把约的内容－十条诫命，写在两块石版上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","摩西拿着两块法版，走下西乃山，不知道自己的脸上因与主说过话而发了光。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","亚伦和以色列众人看见摩西脸上放光，不敢接近他。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","摩西召集以色列人。亚伦和会众的首领们首先向摩西聚拢过来，摩西对他们讲话， ");
INSERT INTO cmn2006_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","随后全体以色列人都来到摩西面前，摩西向他们颁布了主在西乃山向他讲述的所有诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","摩西向他们讲述完毕，就拿帕子蒙住自己的脸。 ");
INSERT INTO cmn2006_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","每当摩西进入圣幕与主对话时就把帕子揭下，出来以后把上帝的吩咐告诉以色列人； ");
INSERT INTO cmn2006_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","人们看见摩西的脸上放着光。讲述完毕摩西又用帕子蒙上脸，直到下一次进去与主对话时才摘下。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","摩西召集以色列全体会众，对他们说∶“主给你们的诫命是这样的∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","你们有六天可以做工，但第七天是圣安息日，要属于我。凡在这天做工的人必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","在安息日家中不可生火。” ");
INSERT INTO cmn2006_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","摩西对全体以色列会众说∶“主的诫命是这样的∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","你们要向主奉献礼物。可以自愿奉献的物品有∶金、银、铜、 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","兰色、紫色、深红色的毛线、麻纱、山羊毛、 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","染红的公羊皮、精美的皮料、金合欢木、 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","灯油、制作圣油和香的香料、 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","用来镶在以弗得圣衣和胸牌上的红玛瑙和其他宝石。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“你们当中的能工巧匠要来制作主所吩咐的一切器具∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","圣幕及其幕顶和外层的顶盖，圣幕的钩子、骨架、横木、柱子及底座， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","约柜及抬柜的杠子，赎罪台，遮掩约柜的帷幔， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","供桌和抬桌的杠子以及桌上的一切器具和桌上专用的供饼， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","灯台及其应用器具，灯油， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","香坛及抬坛的杠子，圣膏油，芬芳的香，圣幕入口的门帘， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","献烧化祭的坛及其铜网以及抬坛的杠子和应用器具，供洗浴用的盆和盆底座， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","围院子的帐幔及其柱子和柱底座，院子入口的门帘， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","立圣幕和围院子用的橛子和绳子， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","祭司在圣所供职时穿的特制圣服，也就是祭司亚伦和他的儿子们穿的圣服。” ");
INSERT INTO cmn2006_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","宣讲完毕，以色列全体会众都从摩西跟前退出； ");
INSERT INTO cmn2006_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","虔诚奉献的人都献上礼物，作为为主建造圣幕和其他设施以及制作圣衣之用。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","男男女女都自愿献上了胸针、耳环、戒指、项练和各种金饰品，作为奉献给主的金子， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","每人都能带来麻纱和兰色、紫色、深红色的毛线，山羊毛，染红的公羊皮或精美的皮料， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","每个想向主献银和铜的人都带来了它们，每个有可供各种用途的金合欢木的人也带来了它们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","技艺精巧的妇女们带来了亲手纺织的麻纱和兰色、紫色、深红色的毛线， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","她们也用山羊毛纺线。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","首领们带来了红玛瑙和其他可以镶嵌在以弗得圣衣和胸牌上的宝石， ");
INSERT INTO cmn2006_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","也带来了用于制香和用于点灯和制作圣膏油所需的香料和油。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","每一个以色列人，无论男女，都自愿向主献上了自愿祭，作为主藉摩西所吩咐要做的工程之需。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","摩西对以色列人说∶“主已经选召犹大支派的比撒列，他是户珥的孙子，乌利的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","上帝的灵降在他的身上，赐他以技巧、聪明和才智，使他能胜任各种工作。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","他能作设计；能用金、银、铜制作各种器具； ");
INSERT INTO cmn2006_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","能雕刻可镶嵌的宝石；能雕刻木器，能作各种精巧的工艺。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","主赐给他和但支派亚希撒抹的儿子亚何利亚伯以教导他人的能力。 ");
INSERT INTO cmn2006_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","他赐给他们各种技能，能够从事雕刻，图案设计，用兰色、紫色、深红色的毛线和麻纱刺绣，纺织各种布料等各种各样的工作。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“所以，主赐予比撒列、亚何利亚伯和其他技艺高超的匠人以才智和技巧，使他们明了主的旨意，知道如何进行营造圣幕的各项工程。” ");
INSERT INTO cmn2006_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","摩西召集比撒列、亚何利亚伯和其他所有蒙主赐与技能的工匠，吩咐开工。这些人都是志愿参加营造圣幕工程的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","他们从摩西那里领去了以色列人为营造圣幕所奉献的礼物。但是，每天早上人们仍然络译不绝地送来礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","负责各项营造圣幕工程的工匠们都放下手里的工作来见摩西， ");
INSERT INTO cmn2006_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","说∶“人们的奉献已经远远超过了主吩咐建造的工程所需要的了。” ");
INSERT INTO cmn2006_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","于是，摩西传令全营，叫人们不必再为圣幕作奉献了，民众这才不再送礼物来。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","因为人民奉献的礼物已经满足全部工程的需要，而且绰绰有余。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","技艺出众的工匠被选出来负责建造主的圣幕。他们制作了十幅帐幔；帐幔用麻纱和兰色、紫色、深红色的毛线制成，并精心绣上基路伯的图案。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","每幅帐幔长14.7米，宽2.1米，所有的帐幔大小相同。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","他们把五幅帐幔缝在一起成为一组，把另外五幅也缝在一起； ");
INSERT INTO cmn2006_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","在每组帐幔的最末一幅的边沿上用兰色的毛线缀上钮环， ");
INSERT INTO cmn2006_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","每幅上各有50个钮环；两幅帐幔上的钮环一一对应。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","他们又制作了50个金钩，把帐幔连接起来，形成整个圣幕。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","他们又用山羊毛织了十一幅幔子做圣幕的幕顶。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","每幅长15.7米，宽2.1米，所有的幔子大小相同。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","他们把五幅缝在一起成为一组，其余六幅缝在一起成为另一组。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","在每组的最末一幅幔子的边沿缀上50个钮环； ");
INSERT INTO cmn2006_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","又做了50个铜钩，把两组幔子连接成一体，形成整个幕顶。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","然后，用染红的公羊皮制成幕顶，又用精美的皮料制成外层顶盖。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","他们用金合欢木制作竖立圣幕的骨架。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","每个骨架高5.25米，宽78公分， ");
INSERT INTO cmn2006_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","有两个榫头，用来彼此连接。所有的骨架规格相同。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","圣幕的南面立二十个骨架， ");
INSERT INTO cmn2006_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","架底下有四十个银底座，每个骨架下有两个底座，分别支撑骨架的两个榫头。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","圣幕的北面也立有二十个骨架 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","和四十个银底座，每根骨架下有两个底座。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","圣幕的后面，也就是西面，立有六根骨架， ");
INSERT INTO cmn2006_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","后侧拐角处有两个骨架， ");
INSERT INTO cmn2006_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","骨架的下端连在一起，上端用一个园环箍在一起，两个拐角的作法相同。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","西面共有八根骨架和十六个银底座，每根骨架下有两个底座。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","他们又用金合欢木制作连接骨架的横木；圣幕一边的骨架上装五根， ");
INSERT INTO cmn2006_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","另一边的骨架上装五根，圣幕的后面，也就是西面的骨架上也装五根。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","中间的横木穿过骨架的中部，从圣幕的一边通到另一边。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","骨架用金包裹，并装上金环，用来安装横木。横木也用金包裹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","他们用兰色、紫色、深红色的毛线和麻纱制成帷幔，并精心绣上基路伯的图案。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","又用金合欢木做了四根挂帷幔用的柱子，也用金包裹，并装上金钩，为每根柱子铸了一个银底座。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","他们用兰色、紫色、深红色的毛线和麻纱为圣幕的入口做了一个门帘，上面饰有刺绣图案。 ");
INSERT INTO cmn2006_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","又为门帘做了五根有钩的柱子，柱子的顶端和柱上的杆子都用金包裹，柱子的下面有铜底座。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","比撒列用金合欢木制造约柜。柜长131公分，宽78公分，高78公分。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","约柜的内外都用纯金包裹，周围镶有金边。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","四个抬柜用的金环装在柜的四角，一边两个。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","他又用金合欢木造了抬柜的杠子，用金裹上， ");
INSERT INTO cmn2006_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","穿在柜两边的金环里。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","赎罪台用纯金制成，长131公分，宽78公分； ");
INSERT INTO cmn2006_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","又用金锤制出两个基路伯， ");
INSERT INTO cmn2006_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","分别装在赎罪台的两端，与赎罪台连成一体。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","两个基路伯面对着面，面对赎罪台向上展开翅膀，遮盖着赎罪台。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","他用金合欢木制作供桌。桌长105公分，宽52公分，高78公分。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","桌子用纯金包裹，周围镶有金边。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","桌面的四周装有8公分宽的边缘，边缘上也镶有金边。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","桌子四角的桌腿上装有四个金环； ");
INSERT INTO cmn2006_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","金环紧靠桌子的边缘，供抬桌的杠子穿过。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","又用金合欢木做了杠子，用金包裹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","桌上的盘子、碟子以及奠酒用的壶和杯等器具也都用纯金制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","他用纯金制作灯台。灯台的底座、柱及上面的花朵、花萼和花瓣都由同一块金子锤制出来， ");
INSERT INTO cmn2006_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","灯台的两侧伸出六根枝子，一边三根。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","每根枝子上有三朵花，形状如杏花，有萼有瓣。六根枝子的形状相同。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","灯台的柱上也有四朵花，形状象杏花，有萼有瓣。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","每对枝子的下面与灯柱相接的地方有一个萼，枝子和萼与灯台连成一体，六根枝子的作法相同。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","所有的枝子和萼与灯台都连成一体。整个灯台都是由纯金锤制的， ");
INSERT INTO cmn2006_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","又用纯金制作了蜡剪、蜡花盘和七个灯盏。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","制作灯台及应用器具共用纯金34公斤。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","他用金合欢木制作香坛。香坛是四方形的，长50公分，宽50公分，高100公分。拐角上的角与坛连成一体。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","坛顶、四个侧面及坛拐角上的角用纯金包裹。四周镶有金边。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","坛两侧的边沿下装有金环`，供抬坛的杠子穿过。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","杠子用金合欢木制成，用金包裹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","他用调制香水的方法制成圣膏油和纯净芬芳的香。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","比撒列用金合欢木制作献烧化祭的坛。坛是四方形的，长2.6米，宽2.6米，高1.5米。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","坛的四个拐角上有角，与坛连成一体，整个坛用铜包裹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","坛的一切应用器具∶盆、铲子、碗、叉和火盆都用铜制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","他为祭坛做了一个铜网，从底部托住祭坛并向上伸到坛的中部， ");
INSERT INTO cmn2006_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","又在铜网的四角装上四个铜环，供抬坛的杠子穿过。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","杠子用金合欢木制成，用铜包裹， ");
INSERT INTO cmn2006_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","穿在坛两侧的铜环里。坛体用木板围成，是中空的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","他用在圣幕门前侍立的女子的铜镜制作了铜盆和盆底座。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","他用麻纱制成的帷幔为圣幕围成院子。院子南面的帷幔长52米， ");
INSERT INTO cmn2006_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","挂在二十根带铜底座的柱子上，柱上钩子和横杆用银制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","院子的北面与南面相同，长度也是52米，有二十根带铜底座的柱子，柱上的钩子和横杆用银制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","院子的西面长26米，有十根带铜底座的柱子，柱上的钩子和横杆也用银制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","院子的东面，也就是院子的正面，宽26米， ");
INSERT INTO cmn2006_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","两侧各有长7.8米的帷幔和三根带铜底座的柱子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","围院子的帷幔都用麻纱制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","柱子的底座用铜制成，柱上的钩子和横杆用银制成，柱头也用银包裹。院子四周的柱子相互用银杆连接。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","院子的门帘用兰色、紫色、深红色的毛线和麻纱制成，上面绣以图案。门帘长10.5米，高2.6米，高度与院子的帷幔相同。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","门帘挂在四根带铜座的柱子上；柱上的钩子和横杆用银制成，柱头用银包裹。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","所有立圣幕和围院子用的橛子都用铜制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","以下是建造圣幕所耗用物资的清单。这是遵照摩西的命令，由祭司亚伦的儿子以他玛指导利未人核查统计的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","主对摩西所吩咐的一切由犹大支派户珥的孙子、乌利的儿子比撒列一一付诸实施。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","他的助手是但支派亚希撒抹的儿子亚何利亚伯，他是一个工艺家和设计师，并能用兰色、紫色、深红色的毛线织造图案，在麻纱上刺绣。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","用于建造圣所奉献的黄金1000多公斤。以圣所的天平称量为准。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","由登记在册的会众奉献的银子共3750公斤。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","二十岁以上登记在册的会众共六十万零三千五百五十人，每人交纳半舍客勒银子，以圣所的天平称量为准。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","3750公斤的银子用于制造圣所和帐幔的一百个银底座，每个底座重34公斤。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","余下的23公斤银子用于制作柱子上的钩子和横杆以及为柱头裹银。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","会众奉献的铜共2500公斤。 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","用于制造圣幕入口的底座、铜坛、坛上的铜网、坛的一切应用器具、 ");
INSERT INTO cmn2006_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","院子周围和院子入口的底座以及立圣幕和围院子所用的橛子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","他们按照主对摩西的吩咐，用兰色、紫色、深红色的毛线制作祭司供职时穿的华贵圣服，也为亚伦制作圣服。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","他们用金线，兰色、紫色、深红色的毛线和麻纱制作以弗得圣衣。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","他们把金子锤成薄片，剪成细条，用精巧的工艺与麻纱和兰色、紫色、深红色的毛线织在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","又为以弗得作了两条肩带，系在以弗得的两边肩上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","以弗得的饰带的制法与以弗得一样，也是用金线与麻纱和兰色、紫色、深红色的毛线制成，与以弗得圣衣连成一体。这是按照主对摩西的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","他们又把红玛瑙镶嵌在金底托上，以篆刻印章之法刻上以色列十二个儿子的名字。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","这两块宝石装在以弗得的两条肩带上，代表以色列的十二支派。这是按照主对摩西的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","他们精工制作胸牌。制作方法与制以弗得一样，也用金线和麻纱及兰色、紫色、深红色的毛线制作。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","胸牌是四方形的，叠成两层，长23公分，宽23公分。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","上面镶着四行宝石，第一行是红宝石、红璧玺和红玉； ");
INSERT INTO cmn2006_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","第二行是绿宝石、兰宝石和钻石； ");
INSERT INTO cmn2006_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","第三行是紫玛瑙、白玛瑙和紫晶； ");
INSERT INTO cmn2006_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","第四行是水苍玉、红玛瑙和碧玉。这些宝石都镶嵌在金底托上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","这些宝石上以篆刻印章之法刻上以色列十二个儿子的名字，十二块宝石代表以色列的十二支派。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","胸牌的链子用纯金制成，形状象绞成的绳子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","又做了两个金环和两个金底座，金环装在胸牌的两端。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","两条金链分别系住胸牌两端的金环， ");
INSERT INTO cmn2006_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","链子的另外两端固定在金底座里，再安在以弗得前面的肩带上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","再做两个金环装在胸牌另外两端靠近以弗得的内边沿上。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","他们又做了两个金环，装在以弗得前面肩带下面和饰带上方靠近接缝之处， ");
INSERT INTO cmn2006_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","再用兰色的带子把胸牌的环和以弗得的环系在一起，使胸牌紧贴在以弗得的饰带上，不至松脱。这是按照主对摩西的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","以弗得的外袍完全用兰色的毛线制成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","袍子的中央开有领口，领口周围有一圈领边，以免领口被撕裂。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","袍子的底边饰有用兰色、紫色、深红色毛线和麻纱做的石榴， ");
INSERT INTO cmn2006_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","26","间以纯金的小铃铛。这是按照主对摩西的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","又为亚伦和他的儿子们用麻纱制作内袍、 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","礼冠、裹头巾、裤子， ");
INSERT INTO cmn2006_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","用麻纱和兰色、紫色、深红色的毛线做腰带，饰以刺绣。这是按照主对摩西的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","他们用纯金做圣冠上的牌子。以篆刻印章之法在金牌上刻上“圣化归主”的字样， ");
INSERT INTO cmn2006_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","然后把它用兰色的带子系在礼冠前面。这是按照主对摩西的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","就这样，以色列人遵照主对摩西的吩咐，为主做好了圣幕－也就是会幕，一切有关工作都园满完成。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","他们把圣幕和圣幕的一切器具都带到摩西面前；有∶钩子、骨架、横木、柱子和底座、 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","用染红的羊皮做的顶盖和精美的皮料做的顶盖、遮掩约柜的帐幔、 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","约柜和抬柜的杠子、赎罪台、 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","供桌和桌上的用具、陈设饼、 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","纯金的灯台和摆列在上面的灯及应用器具、灯油、 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","金坛、圣膏油、芬芳的香、圣幕入口的门帘、 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","铜坛和坛上的铜网、坛的杠子和应用器具、铜盆和盆座、 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","围院子的帷幔、帷幔的柱子和底座、院子入口的门帘、绳子、橛子和圣幕－也就是会幕－中的一切应用器具。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","还有亚伦和他的儿子们供职祭司时穿的华贵的圣服。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","这一切都是按照主对摩西的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","摩西看见以色列人遵照主的命令园满地做好了这一切，就祝福他们。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“你要在正月初一日立起圣幕， ");
INSERT INTO cmn2006_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","把约柜安放在里面，用帐幔遮住。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","要把供桌搬进去，摆好桌上的陈设，也要把灯台搬进去安置好，点上灯。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","要把供香的金坛放在约柜前面，在圣幕的入口挂上门帘。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“把献烧化祭的祭坛安置在圣幕－也就是会幕－的门前， ");
INSERT INTO cmn2006_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","洗濯盆放在圣幕和祭坛之间，里面要注满水。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","要把院子周围的帷幔竖起来，在入口处挂上门帘。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“要用圣膏油涂抹圣幕和圣幕内的一切器具，使它们归圣； ");
INSERT INTO cmn2006_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","要涂抹献烧化祭的坛和坛上的一切器具，使它们成为至圣； ");
INSERT INTO cmn2006_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","也要涂抹洗濯盆和盆座，使它们归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“你要把亚伦和他的儿子们带到圣幕门口，让他们在那里沐浴。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","你要给亚伦穿上圣服，用圣膏油膏他，使他归圣；这样，他就可以做祭司侍奉我。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","你也要把他的儿子们带到圣幕门前，给他们穿上内袍， ");
INSERT INTO cmn2006_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","象膏他们的父亲一样膏他们，使他们归圣；这样，他们也可以做祭司侍奉我。这受膏圣礼将使亚伦的后代世世代代供职祭司。” ");
INSERT INTO cmn2006_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","摩西一切都按主的吩咐行事。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","在第二年的正月初一日，圣幕立起来了。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","摩西安设幕底座，竖起骨架，安上横木，立好柱子。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","又把圣幕的幕顶装上，安好外顶盖。这是按照主对他的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","摩西把法版放进约柜，把杠子穿在柜两旁的环里，安上赎罪台。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","然后，把约柜安放在圣幕中，挂起帐幔把柜遮掩住。这是按照主对他的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","摩西把供桌放在圣幕的北面，在约柜的帐幔之外。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","桌上摆着献给主的供饼。这是按照主对他的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","摩西把灯台放在供桌对面，圣幕的南面， ");
INSERT INTO cmn2006_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","在主的面前点上灯。这是按照主对他的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","摩西把金坛放在圣幕中约柜的帐幔前面。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","在坛上点着芬芳的香。这是按照主对他的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","然后，摩西在圣幕的入口挂上门帘。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","摩西把献烧化祭的坛安置在圣幕－也就是会幕－的门前，在坛上献上烧化祭和素祭。这是按照主对他的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","摩西把洗濯盆放在圣幕和祭坛之间，在里面注满了水。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","32","每当摩西和亚伦及亚伦的儿子们进入圣幕或接近祭坛时，都要在这里洗手和脚。这是按照主对他的吩咐做的。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","摩西在圣幕和祭坛周围围起院子，在入口挂上门帘。就这样，摩西把一切安排完毕。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","当时，云彩笼罩住会幕，主的荣耀充满了圣幕。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","这时，摩西不能进入圣幕，因为云彩停在圣幕上，主的荣耀充满幕内。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","在以色列人的行程中，每当云彩从圣幕升上去，他们就拔营上路； ");
INSERT INTO cmn2006_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","如果云彩停在圣幕上不动，他们也安营不动，直至云彩升上去以后才启程。 ");
INSERT INTO cmn2006_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","在旅途的每一个阶段，白天，以色列人支派都看见主的云彩在圣幕之上；夜间，他们都看见火在云彩中燃烧着。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","主从会幕里召唤摩西，对他说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“你晓喻以色列人∶‘你们当中有人向主献牲祭时，要从牛群或羊群中挑选。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","如果献上的是从牛群中挑选的烧化祭，祭牲必须是没有残疾的公牛。他必须把它带到圣幕的门口，使它能够蒙主悦纳。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","他要把手按在祭牲的头上，这样，蒙主悦纳的烧化祭就为他赎了罪。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","作为祭牲的公牛要在主的面前杀掉，亚伦宗族的祭司要把这牛的血洒在圣幕门口的祭坛周围，作为祭物献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","然后，要剥掉这牛的皮，把肉切成碎块。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","亚伦宗族的祭司要在祭坛上码上木柴，拨旺火， ");
INSERT INTO cmn2006_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","把切成块的牛肉以及牛的头和脂油投进祭坛上的火里。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","牛的内脏和后腿要先用水洗净，然后全部由祭司在祭坛上烧化。这是烧化祭，这悦人的香气是献给主的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","‘如果用绵羊或山羊献作烧化祭，必须是没有残疾的公羊。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","羊要在祭坛的北面，在主的面前杀掉，亚伦宗族的祭司要把这羊的血洒在祭坛的周围， ");
INSERT INTO cmn2006_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","然后，把羊肉切成块，再把这些肉以及羊的头和脂油都码放在祭坛上燃烧着的木柴上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","羊的内脏和后腿用水洗净后由祭司在祭坛上烧化祭献。这烧化祭的香味是主所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","‘如果用鸟类献作烧化祭，必须是斑鸠或雏鸽。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","祭司要把鸟拿到祭坛上，拧掉头，在祭坛上烧化。鸟的血要洒在祭坛旁， ");
INSERT INTO cmn2006_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","内脏要用尾巴上的羽毛清除干净，扔在祭坛东面倒灰的地方。 ");
INSERT INTO cmn2006_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","祭司要抓着鸟的两个翅膀，把鸟撕开，但不要撕成两半，然后码放在祭坛上燃烧着的木柴上，在祭坛上烧化。这是烧化祭，这悦人的香气是献给主的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","‘向主献素祭时，必须选用最好的面粉，浇上橄榄油，加上乳香， ");
INSERT INTO cmn2006_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","然后把这些交给亚伦宗族的祭司。祭司从其中抓出一把投入祭坛上的火里，作为全部祭物的象征献给主；这悦人的香气是献给主的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","素祭余下的部分归亚伦和他的家族所有，因为这是圣化归主的祭物中的至圣物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","‘向主献用烘炉烤制成的素祭时，要选用上好的面粉，制成调油的无酵厚饼和涂油的无酵薄饼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","向主献用平锅烘制的素祭时，要选用上好的面粉，调上油，做成无酵饼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","然后，把它弄碎，浇上油；这也是一种素祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","向主献用煎锅煎制的素祭时，要选用上好的面粉，用油煎熟。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","你们要把用这些方法制成的素祭献给主，要把它们交给祭司，由祭司奉献到祭坛上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","祭司从其中抓出一部分，象征全部祭物在祭坛上烧化。这悦人的香气是献给主的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","余下的祭物归亚伦和他的家族所有，因为这是圣化归主的祭物中的至圣物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","‘不可向主献上有酵的素祭，不可在祭坛上烧化任何含酵或含蜜的素祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","酵和蜜可以作为初熟的供物献给主，但不可烧化在祭坛上奉献。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","各种素祭都要用盐调和，你们决不可忽略上帝的约的盐。要把盐跟其他祭物一同献上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","‘向主献初熟的供物作为素祭时，要把初熟的新谷烘干，磨碎， ");
INSERT INTO cmn2006_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","浇上油，加上乳香，这也是一种素祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","祭司从其中抓出一部分，象征全部祭物烧化在祭坛上，作为礼品献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","‘用牲畜向主献平安祭时，无论是公是母，都必须是没有残疾的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","要把手按在祭牲的头上，在圣幕的门前把它杀掉，亚伦家族的祭司要把它的血洒在祭坛的周围。 ");
INSERT INTO cmn2006_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","4","祭司要把祭牲的一部分，包括包着内脏和内脏上的脂肪，两个腰子和腰子上的脂肪，以及肝的最好部分一并割下，作为火祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","亚伦的后代要把这些连同放在柴堆上的烧化祭一起烧化在祭坛上。这悦人的香气是献给主的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","‘用羊向主献作平安祭时，必须是没有残疾的公羊或母羊。 ");
INSERT INTO cmn2006_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","如果选用绵羊，要把羊带到主的面前， ");
INSERT INTO cmn2006_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","奉献者要用手按在它的头上，在圣幕门口把它杀掉，亚伦宗族的祭司要把它的血洒在祭坛旁。 ");
INSERT INTO cmn2006_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","要把祭牲的一部分，包括羊的脂肪，靠近尾骨附近的整条肥尾巴，包着内脏和内脏周围的脂肪， ");
INSERT INTO cmn2006_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","两个腰子和腰子上的脂肪，以及肝的最好部分一并割下， ");
INSERT INTO cmn2006_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","烧化在祭坛上，作为食祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","如果选用山羊，要把羊带到主的面前， ");
INSERT INTO cmn2006_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","奉献者要用手按在它的头上，在圣幕的门前把它杀掉，亚伦宗族的祭司要把它的血洒在祭坛旁。 ");
INSERT INTO cmn2006_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","要把祭牲的一部分，包括羊的脂肪，靠近尾骨附近的整条肥尾巴，包着内脏和内脏周围的脂肪， ");
INSERT INTO cmn2006_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","两个腰子和腰子上的脂肪，以及肝的最好部分一并割下， ");
INSERT INTO cmn2006_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","烧化在祭坛上，作为食祭献给主；这悦人的香气是献给主的礼物。祭牲的所有脂肪都属于主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","你们无论住在那里，都不可以吃脂肪和血，这是你们世世代代要永久遵守的律例。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“你晓喻以色列人∶‘如果有人无意间犯了罪，违犯了主的诫命，他必须遵守下述规定。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","如果犯罪的是大祭司，他因自己的罪而连累了民众，必须为自己的罪向主献上一头没有残疾的公牛作为赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","他要把牛牵到主的圣幕门前，用手按在它的头上，并在主的面前把它杀掉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","他要把一部分血拿进圣幕， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","用手指蘸着血，在至圣所的帷幔前弹洒七次， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","再把一些血抹在圣幕内主面前香坛的四只角上。其余的血倒在圣幕门口用于献烧化祭的祭坛的底座旁。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","他必须把这用作献赎罪祭的牛的全部脂肪割下，包括包着内脏的脂肪和内脏周围的脂肪， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","两只腰子和腰子上的脂肪，以及肝的最好部分一并割下， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","由祭司奉献到献烧化祭的祭坛上烧化；作法同献作平安祭的牛一样 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","这牛的皮、肉、头、腿、内脏和其他秽物， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","都要带到营外专为洁净而设的倒灰的地方，用木柴点火烧掉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","‘如果全体会众无意中犯了过错，即便自己全然不觉以致违犯了主的诫命，他们仍然有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","一旦发觉自己的罪，会众必须向主献上一头公牛作为赎罪祭。他们要把这牛带到圣幕门前， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","会众的长老们要用手按在它的头上，并在主的面前把它杀掉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","大祭司要把一部分血拿进圣幕， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","用手指蘸着血，在至圣所内主前面的帷幔前弹洒七次， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","再把一些血抹在主面前香坛的四只角上。其余的血倒在圣幕门口用于献烧化祭的祭坛的底座旁。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","他要割下这牛所有的脂肪，并在祭坛上烧化， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","程序同大祭司用牛献赎罪祭一样。这样，祭司就为会众行了赎罪礼，使他们得到赦免。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","然后，要把这牛的其余部分拿出营外烧掉，象烧前述献作赎罪祭的牛的方法一样。这是为会众献的赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","‘如果犯罪的是民众的首领，他无意中违犯了主的诫命， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","一旦自己发觉，必须向主献上一只没有残疾的公山羊作赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","他要用手按在这作赎罪祭的羊的头上，在宰杀烧化祭祭牲的地方把它杀掉。这也是一种赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","祭司要用手指蘸一些血抹在烧化祭祭坛的角上，其余的血要倒在祭坛底座的旁边。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","所有的脂肪都要投入祭坛上的火里烧掉，与献平安祭脂肪的方法一样。这样，祭司就为他行了赎罪礼，使他得到赦免。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","‘如果犯罪的是一般平民，他无意中违犯了主的诫命， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","一旦自己发觉，必须向主献上一只没有残疾的母山羊作赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","他要用手按在这作赎罪祭的羊的头上，在宰杀烧化祭祭牲的地方把它杀掉， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","祭司要用手指蘸一些血，抹在烧化祭祭坛的四只角上，其余的血倒在祭坛的底座旁边。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","他要把这羊的脂肪都取下来，与取平安祭祭牲脂肪的方法一样。祭司要把这些脂肪在祭坛上烧化，这悦人的香气是献给主的礼物。这样，祭司就为这人行了赎罪礼，使他得到赦免。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","如果他用绵羊作赎罪祭祭牲，必须是没有残疾的母绵羊。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","他要用手按在这羊的头上，在宰杀烧化祭祭牲的地方把它杀掉， ");
INSERT INTO cmn2006_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","祭司要用手指蘸一部分血，抹在烧化祭祭坛的四只角上，其余的血倒在祭坛底座的旁边。 ");
INSERT INTO cmn2006_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","祭司要取下羊的所有脂肪；与取平安祭祭牲脂肪的方法一样。祭司要将这些脂肪连同其他祭品一同在祭坛上烧化献给主。这样，祭司就为这人行了赎罪礼，使他得到赦免。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","‘如果有人目睹事件现场或了解事实真相却不出来作证，他因隐瞒证据而受到公众指责，这人就算有罪，要承受罪罚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","如果有人触摸了不洁净的东西，无论是不洁净的野兽的尸体还是不洁净的家畜或爬虫的尸体，自己却没有发觉，他因此而不洁净，就算有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","如果有人触碰了别人的秽物，无论沾染的是什么，尽管当时没有发觉，而他自己一旦发觉，就算有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","如果有人信口发誓，事后也忘却了，不论誓言是好是坏，自己一旦发觉，就算有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","人无论在哪一项上犯了罪都必须服罪。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","他必须向主献上一只母山羊或母绵羊作为赎罪祭为自己赎罪，祭司要为他行赎罪礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","‘如果他买不起羊，可以用两只斑鸠或雏鸽为自己赎罪。一只献作赎罪祭，另一只献作烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","他要把它们交给祭司，祭司要先把一只献作赎罪祭。他要拧断鸟的脖子，使鸟的头软弱无力，但不要拧下来， ");
INSERT INTO cmn2006_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","然后，把一些血弹洒在祭坛周围，其余的血倒在祭坛底座的旁边。这是赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","另一只鸟按照规定的礼仪献作烧化祭。这样，祭司就为这人行了赎罪礼，使他得到赦免。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","‘如果他买不起两只斑鸠或雏鸽，可以献上一公斤上好的面粉作为赎罪祭，面粉上不要浇油，也不要放乳香，因为这是赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","他要把面粉交给祭司；祭司从其中抓出一把作为全部祭物的象征，投入祭坛上的火里，作为火祭献给主。这是赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","这样，祭司就为这人行了赎罪礼，使他得到赦免。余下的面粉归祭司所有，和素祭的规定一样。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“如果有人无意中侵犯了主的圣物，他必须要向主献上一只没有残疾的公绵羊谢罪。羊的价值要与按照圣所标准决定的相当。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","他要为所侵犯的圣物作出赔偿，还要为他的罪多付出赔偿值的五分之一。他要把这些钱和用于赔偿的羊都交给祭司；祭司要用这羊为他行赎罪礼，使他得到赦免。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“如果有人违犯了主的诫命，自己却没有意识到已经犯了罪，他仍然要承受罪罚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","他必须按照估价把一只没有残疾的公绵羊交给祭司作为赎过祭，由祭司为他无意中犯的过错行赎罪礼，使他得到赦免。 ");
INSERT INTO cmn2006_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","这是赎过祭，因为他得罪了主。” ");
INSERT INTO cmn2006_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“如果有人亵渎主，在邻居托他保管的东西上起了不良之念，或是在交易中欺诈对方，或是抢人财物，或是欺压同胞， ");
INSERT INTO cmn2006_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","或是拾到别人遗失的东西却矢口否认，还赌咒发誓或做诸如此类欺心的事， ");
INSERT INTO cmn2006_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","如果他这样做他就有了罪，他要归还这些不义之财－无论是抢夺来的，欺诈来的，别人托他保管的，路上拾来的， ");
INSERT INTO cmn2006_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","还是赌过咒发过誓否认的，都要如数归还，还要再加上原价值的五分之一。他必须在服罪的当天把东西归还原主， ");
INSERT INTO cmn2006_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","并把一只与赔偿价值相当的没有残疾的公绵羊交给祭司作为献给主的赎过祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","祭司要在主的面前为他行赎罪礼，使他在获罪的事情上得到赦免。” ");
INSERT INTO cmn2006_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“你晓喻亚伦和他的后代，献烧化祭的条例是这样的∶‘烧化祭要投在祭坛上的火里，从晚上一直烧到早晨，祭坛上的火要始终燃烧着。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","祭司要穿上麻纱长袍和麻纱内裤，把祭坛上烧化祭的灰收集起来，倒在祭坛旁边， ");
INSERT INTO cmn2006_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","然后，他要脱掉这衣服，换上另外的衣服，把灰拿到营外的洁净之处。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","祭坛上的火要始终燃烧着，不可熄灭。祭司每天早晨要向火中加木柴，在火上码放烧化祭并烧化平安祭的脂肪， ");
INSERT INTO cmn2006_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","祭坛上的火要日夜不断地燃烧着，不可熄灭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","‘献素祭的条例是这样的∶亚伦的后代要在祭坛前向主献上素祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","祭司要从这加有油和乳香的上等面粉做成的素祭中抓出一把来，作为全部祭物的象征献给主，这悦人的香气是献给主的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","亚伦和他的后代可以吃剩下的祭物。他们要把这些祭物做成无酵饼，并且只能在圣所－圣幕的院子里吃。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","做饼的时候，不可搀酵，因为我已经把这些献给我的食祭赐给他们，作为他们的应得之份。它与赎罪祭和赎过祭一样，也是至圣之物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","亚伦后代中的男子都可以吃这祭物，因为这是他们世世代代由主的祭物分得的应得之份。凡触碰了这些祭物的，都要归圣。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“亚伦和他的后代要在被膏立为大祭司的那天，向主做这样的奉献∶用两升上等的面粉作为常例的素祭，早晚各献上二分之一。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","这素祭要放在铁枰里用油浸透，调拌均匀，烤熟，分成小块；这祭物的香味是主所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","亚伦宗族的祭司中被膏立为大祭司的人必须向主献上这份素祭。这是献给主的常例的祭，要完全烧化献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","所有由祭司奉献的素祭都要完全烧化，人不可以吃。” ");
INSERT INTO cmn2006_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“你晓喻亚伦和他的后代，献赎罪祭的条例是这样的∶‘要当着主的面在宰杀烧化祭祭牲的地方宰杀赎罪祭祭牲，因为这祭牲是至圣的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","主持祭礼的祭司要在圣所－圣幕的院子里吃这赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","凡触碰了这祭牲肉的东西都要归圣，凡被这祭牲血溅碰了的衣服都要在圣处洗涤， ");
INSERT INTO cmn2006_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","所有用来煮祭牲肉的瓦锅都必须摔碎，如果是铜锅，则必须用水擦洗干净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","所有祭司家族中的男子都可以吃这祭牲的肉，因为这祭牲是至圣的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","但是，如果带血的祭牲被拿进了圣幕用于在圣处行赎罪礼，这祭牲就不可以吃而必须烧化。’ ");
INSERT INTO cmn2006_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“以下是关于赎过祭的条例。这是至圣的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","要在宰杀烧化祭祭牲的地方宰杀赎过祭祭牲，要把它的血洒在祭坛的周围。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","所有的脂肪都要献给主∶肥尾巴、包着内脏的脂肪、 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","两个腰子和包在腰子上的脂肪，以及肝的最好部分要一并取下来， ");
INSERT INTO cmn2006_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","由祭司在祭坛上烧化，作为食祭献给主。这是赎过祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","所有祭司家族中的男子都可以吃这赎过祭。他们必须在圣所吃这赎过祭。这是至圣的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","与赎罪祭一样，赎过祭也属于主持祭礼的祭司。这一条例是相同的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","当祭司为某个人奉献烧化祭时，祭牲的皮归祭司所有； ");
INSERT INTO cmn2006_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","各种素祭－无论是炉子烘的，煎锅煎的，还是平锅烤的，都归主持祭礼的祭司所有。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","但是生的素祭，无论是调油的还是干的，要归亚伦宗族所有的祭司平均分配。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“以下是向主献平安祭的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","如果有人向主献平安祭感恩，除了祭牲外，还要献上无酵饼，也就是调油的圈饼、涂油的薄饼和用上等面粉浸油作成的饼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","此外，还要献上一些有酵的饼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","他要从这些祭物中各拿一份作为礼物献给主，这份礼物归那弹洒平安祭的血的祭司所有。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","“为感恩而献的平安祭要在奉献的当天吃掉，任何部分都不可留到第二天早晨。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","如果是为还愿或自愿向主献的祭，祭物可以在献祭的当天吃，剩下的也可以留到第二天再吃。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","如果还有剩余的，必须在第三天烧掉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","如果第三天还吃这祭肉，上帝就不接受他所献的祭，他所献的就不算作祭品，它是不洁净的，凡吃了的人都要承受罪罚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","接触了不洁净东西的祭肉不可以吃，必须用火烧掉，洁净的人可以吃其他祭肉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","不洁净的人如果吃了平安祭的肉，就必须把他从上帝的子民中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","如果有人接触了不洁净的东西，无论是人的秽物还是不洁净的动物或是不洁净的可憎之物，他又吃了这献给主的平安祭的肉，必须把他从主的子民中除名。” ");
INSERT INTO cmn2006_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“你晓喻以色列人∶‘你们不可吃牛、绵羊或山羊的脂肪。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","自然死去或被野兽咬死的动物的脂肪也不可吃，但可以用作其他用途。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","任何人吃了本应作为食祭献给主的牲畜的脂肪，必须把他从主的子民中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","你们无论住在哪里，都不可吃鸟或兽的血。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","凡吃这血的人，必须把他从主的子民中除名。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“你晓喻以色列人∶‘凡向主献平安祭的人必须把其中的一部分作为食祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","他必须亲自把主的食祭－脂肪和胸肉送来，胸肉作为举祭， ");
INSERT INTO cmn2006_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","脂肪由祭司在祭坛上烧化；胸肉归亚伦及其后代所有。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","33","平安祭的右后腿归主持奉献血和脂肪的祭司所有，作为他的应得之份。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","我接受了以色列人献给我的平安祭，把其中作为举祭的胸肉和作为自愿祭的后腿赐给了亚伦和他的后代，作为他们世世代代在色列人当中的应得之份。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","自亚伦和他的后代被膏立为主的祭司之日起，这就是他们从主的食祭中分得的应得之份。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","从膏立祭司的那天起，主就命令以色列人把这份祭物分给祭司，作为他们的应得之份。以色列人要永远遵守这一条例。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","以上是有关烧化祭、素祭、赎罪祭、赎过祭、平安祭和承接圣职时献祭的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","这些条例是主在西乃旷野命令以色列人向主献祭时，在西乃山上向摩西颁布的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“你带着亚伦和他的儿子们，再带上祭司的圣服、膏油、一头作为赎罪祭的公牛、两只公绵羊和一篮无酵饼， ");
INSERT INTO cmn2006_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","把全体会众都召集到圣幕的门口来。” ");
INSERT INTO cmn2006_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","摩西遵照主的吩咐行事，把全体会众召集到圣幕的门口。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","摩西对会众说∶“这是主的旨意。” ");
INSERT INTO cmn2006_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","摩西把亚伦和他的儿子们带上前来，让他们沐浴净身， ");
INSERT INTO cmn2006_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","然后，给亚伦穿上内袍，束上腰带，再穿上外袍，罩上以弗得，用一条华美的腰带束紧。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","接着，他把胸牌系在亚伦身上，把乌陵和土明放进胸牌的口袋里。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","然后，把礼冠戴在亚伦的头上，并把金牌－也就是圣冠－钉在礼冠的前面。这一切都是遵照主的命令做的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","摩西又用膏油涂抹圣幕和其中所有的陈设，使它们归圣， ");
INSERT INTO cmn2006_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","又用膏油向祭坛弹洒七次，并膏了祭坛和相应的用具以及洗涤盆和盆座，使它们归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","他又把圣膏油倒在亚伦的头上，膏他，使他归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","接着，摩西把亚伦的儿子们带上前来，给他们穿上内袍，束上腰带，戴上礼冠。这一切都是遵照主的命令做的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","然后，摩西牵过那头献作赎罪祭的公牛，让亚伦和他的儿子们用手按在这牛的头上， ");
INSERT INTO cmn2006_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","然后杀掉它。摩西用手指蘸着血，把血抹在祭坛的四只角上，使祭坛洁净，再把剩下的血倒在祭坛的底座上，使祭坛归圣。这样，祭司就可以在坛上行赎罪礼了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","摩西取下祭牲内脏上的脂肪、肝的最好部分、两个腰子和腰子上的脂肪，放在祭坛上烧化， ");
INSERT INTO cmn2006_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","并把这牛的其余部分，包括牛的皮、肉、和其他秽物都拿到营外烧掉。这一切都是按照主的命令做的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","然后，摩西牵过献作烧化祭的公绵羊，让亚伦和他的儿子们用手按在这羊的头上， ");
INSERT INTO cmn2006_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","然后杀掉它。摩西把血泼洒在祭坛的四周， ");
INSERT INTO cmn2006_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","把羊的肉切成块，连同羊的头和脂肪一起放在祭坛上烧化。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","再用水把羊的内脏和腿洗净，全部烧化在祭坛上。这烧化祭的香味是主所喜悦的。这是献给主的食祭。这一切都是遵照主的命令做的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","然后，摩西牵过第二只用于承接圣职礼仪的公绵羊，让亚伦和他的儿子们用手按在这羊的头上， ");
INSERT INTO cmn2006_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","然后把羊杀掉，取一点血涂在亚伦的右耳垂、右手的大拇指和右脚的大脚趾上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","再带过亚伦的儿子们，把血涂在他们的右耳垂、右手的大拇指和右脚的大脚趾上。其余的血则泼洒在祭坛的四周。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","摩西取下这羊的脂油，包括肥尾巴、内脏上的脂肪、肝的最好部分、两个腰子和腰子上的脂肪，及右后腿， ");
INSERT INTO cmn2006_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","再从供奉在主面前盛无酵饼的篮子里拿出一个无酵饼、一个油饼和一个薄饼，把它们放在羊的脂肪和右后腿的上面， ");
INSERT INTO cmn2006_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","让亚伦和他的儿子们用手托着这些祭品，作为举祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","摩西再把这些祭品接过来，放在祭坛上的烧化祭上面一同烧化。这是为承接圣职献的祭。这悦人的香气是献给主的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","摩西再拿过羊的胸肉，作为举祭献给主。这份胸肉是摩西的应得之份。这一切都是遵照主的命令行事。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","然后，摩西取一些膏油，又从祭坛上取了一些血，弹洒在亚伦和他的儿子们的身上及衣服上。使亚伦和他的儿子们以及他们所穿的衣服归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","摩西吩咐亚伦和他的儿子们∶“你们要按照主给我的命令，在圣幕的门口煮肉，并在那里吃这肉和用于承接圣职的无酵饼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","剩下的肉和饼必须烧掉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","七天之内，你们都不可走出圣幕，直到你们承接圣职的礼仪结束为止。因为承接圣职的礼仪要持续七天。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","今天所做的一切都是按照主的命令做的，以便为你们行赎罪礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","你们一定要遵守主的命令，在圣幕的门口停留七天七夜，否则，你们必死。这是主对我的命令。” ");
INSERT INTO cmn2006_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","亚伦和他的儿子们遵照主藉摩西的命令行事。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","第八天，摩西召集亚伦和他的儿子们及以色列的长老们， ");
INSERT INTO cmn2006_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","对亚伦说∶“你要用一头牛犊作为赎罪祭和一只公绵羊作为烧化祭献给主，这些祭牲必须是没有残疾的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","你要晓喻以色列人∶‘你们要用一只公山羊作为赎罪祭，用一头牛犊和一只绵羊羔，都必须是一岁大且没有残疾的，作为烧化祭， ");
INSERT INTO cmn2006_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","用一头公牛和一只公绵羊作为平安祭，以及用油调制的素祭献给主。因为主要在今天向你们显现。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","于是，全体会众按照摩西的吩咐带着祭品来到圣幕，站到主的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","摩西说∶“主命令你们做这一切，因为主的荣耀要向你们显现了！” ");
INSERT INTO cmn2006_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","摩西对亚伦说∶“你到祭坛前来，献上你的赎罪祭和烧化祭，为你自己和民众赎罪；再献上民众的祭品，为他们行赎罪礼。这是主的命令。” ");
INSERT INTO cmn2006_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","亚伦走到祭坛前，杀掉了作为他自己赎罪祭的牛犊， ");
INSERT INTO cmn2006_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","他的儿子们把血递给他，他用手指蘸上血，把血抹在祭坛的四只角上，剩下的血倒在祭坛的底座上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","接着，把这牛的脂肪、两个腰子和肝的最好部分烧化在祭坛上。这一切都是遵照主的命令行事。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","亚伦在营外烧掉了这牛的肉和皮。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","然后，亚伦杀掉了烧化祭祭牲。他的儿子们把血递给他，他把血泼洒在祭坛的四周。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","他的儿子们又把祭牲的头和切成块的祭肉递给他，他把它们放在祭坛上烧化。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","亚伦又用水把祭牲的内脏和腿洗净，放在祭坛上的烧化祭上面烧化。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","然后，亚伦开始为民众献祭。他牵过作为民众赎罪祭的公山羊，杀掉它，按照为自己献赎罪祭的方法献上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","接着，又按照规定献上了烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","他又拿过素祭，从其中抓出一把，和早晨常例的烧化祭一起放在祭坛上烧化。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","亚伦又杀掉作为民众平安祭的公牛和公绵羊，他的儿子们把血递给他，他把血泼洒在祭坛的四周。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","他的儿子们又把公牛和公绵羊的肥尾巴、包着内脏的脂肪、两个腰子、和肝的最好部分 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","摆在胸肉上递给他，他把脂肪放在祭坛上烧化， ");
INSERT INTO cmn2006_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","胸肉和右后腿则作为举祭献给主。这一切都是遵照主对摩西的命令行事。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","然后，亚伦向民众举起手，为他们祝福。献完赎罪祭、烧化祭和平安祭后，亚伦走下祭坛， ");
INSERT INTO cmn2006_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","和摩西一起走进圣幕。当他们走出圣幕向民众祝福时，主的荣耀突然向全体会众显现。 ");
INSERT INTO cmn2006_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","主降下天火，烧尽了祭坛上的烧化祭和脂油。民众见到这景象都欢呼起来，俯伏在地上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","亚伦的儿子拿答和亚比户各自拿着自己的香炉，放入香火，把这未经主认可的火献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","主降下天火，把他们烧死在主的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","摩西对亚伦说∶“这就是主曾宣喻的旨意∶‘侍奉我的人必须尊重我的神圣，所有的人都必须尊崇我。’”亚伦默然不语。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","摩西把乌薛的儿子米沙利和以利撒反叫来（乌薛是亚伦的叔叔），告诉他们∶“把你们亲属的尸体抬出圣所，放到营外去。” ");
INSERT INTO cmn2006_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","他们遵照摩西的命令，抓住尸体的袍子把他们抬到营外。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","摩西对亚伦和他的儿子以利亚撒和以他玛说∶“你们不可因这事悲痛而披头散发，撕裂衣服，否则你们必死，主也会迁怒于全体会众。但你们的亲属和全体以色列人可以为主降火烧死拿答和亚比户尽哀。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","你们不可走出圣幕，否则你们必死，因为主的膏油已经使你们归圣。”亚伦和他的儿子们遵照摩西的吩咐行事。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","主对亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“你和你的儿子们进入圣幕时不可喝酒，无论浓酒或淡酒都不可喝；否则你们必死。这是你们世世代代都要遵守的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","因为你们要辨别圣俗，区分洁净和不洁净之物， ");
INSERT INTO cmn2006_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","还要用主藉摩西颁给以色列人的律法去教导他们。” ");
INSERT INTO cmn2006_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","摩西吩咐亚伦和他剩下的两个儿子以利亚撒和以他玛∶“你们要将献给主的食祭里剩下的素祭做成无酵饼，并在祭坛的旁边吃掉它。因为这是至圣之物， ");
INSERT INTO cmn2006_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","是你和你的儿子在献给主的食祭中的应得之份，你们一定要在圣处吃掉它。这是主给我的命令。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","但是作为举祭的胸肉和作为特殊贡品的腿肉则可以在其他洁净的地方吃。你和你的儿女都可以吃。因为这是以色列人所献的平安祭中你们的应得之份。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","他们要在向主献上作为食祭的脂肪的同时向主献上作为举祭的胸肉和作为特殊贡品的腿肉，这是你和你的后代世世代代的应得之份。这是主的命令。” ");
INSERT INTO cmn2006_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","摩西查问那只作赎罪祭的公山羊，发现那羊已经烧化了。摩西对亚伦的另两个儿子以利亚撒和以他玛发怒，责问他们∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“你们为什么不在圣所吃掉这赎罪祭？这是至圣之物。上帝把它赐给你们，就是要用它在主的面前为会众行赎罪礼，好除去他们的罪。 ");
INSERT INTO cmn2006_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","既然这祭牲的血没有带进圣处，你们就应该按照我的命令在圣处吃掉祭肉。” ");
INSERT INTO cmn2006_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","亚伦答道∶“今天，他们向主献了赎罪祭和烧化祭，而我却遭了这样的灾。如果我今天吃了赎罪祭，主就会满意吗？” ");
INSERT INTO cmn2006_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","摩西听了也表示同意。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“你们晓喻以色列人∶‘以下是你们可以吃的陆地上的动物∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","凡反刍且脚蹄分瓣的动物都可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","但不可吃骆驼、獾子和兔子，这些是不洁净的动物；因为它们虽然反刍，脚蹄却不分瓣。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","猪也不可吃，因为它是不洁净的动物；尽管它脚蹄分瓣，但却不反刍； ");
INSERT INTO cmn2006_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","你们不可吃上述动物的肉，也不可触碰它们的尸体；因为它们是不洁净的动物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","‘以下是你们可以吃的水中的动物∶凡有鳍有鳞的鱼类，无论是海洋中的还是江河中的，你们都可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","但不可以吃没有鳍没有鳞的水生动物，对于你们，它们是可憎之物， ");
INSERT INTO cmn2006_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","并且今后始终是你们的可憎之物。你们不可吃这些动物的肉，也不可触碰它们的尸体， ");
INSERT INTO cmn2006_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","因为一切在水中游动的无鳍无鳞的动物都是你们的可憎之物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","‘以下的鸟类你们都不可吃，它们是可憎之物∶各类鹰、猫头鹰、鸢鹰、隼、鹫、兀鹰、乌鸦、驼鸟、海鸥、鹳鸟、苍鹭、鹈鹕、鹭鸶、戴胜、蝙蝠等。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","‘凡有翅膀用四足爬行的昆虫都是可憎之物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","22","但其中腿有关节可以蹦跳的昆虫，如蝗虫、蟋蟀、蚱蜢等，你们可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","其他有翅的四足昆虫都是可憎之物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","‘以下这些动物会使你们不洁净，凡触碰了不洁净动物及其尸体的人要不洁净到傍晚，凡拿了这些动物尸体任何一部分的人，必须洗涤衣服，但他仍然不洁净到傍晚∶一切脚蹄不分瓣、不反刍和有脚掌的四足动物都是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","以下这些爬行动物对你们是不洁净的∶鼹鼠、老鼠、田鼠、晰蜴等。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","凡触碰了这些动物尸体的人要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","它们的尸体掉在无论什么东西上面，不管是木制的，布制的，皮制的，羊毛制的，也不管是什么用途的，都要放到水里浸泡，但仍然要不洁净到傍晚，然后才算洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","如果它们掉到陶制的器皿里，这器皿里的东西就不洁净，你们必须砸碎这器皿。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","如果这器皿里的水倒在任何食物上，这食物就不洁净；如果用这器皿盛任何饮料，这饮料就不洁净； ");
INSERT INTO cmn2006_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","尸体的任何一部分掉到无论什么东西上，这东西就不洁净了，如果是烘炉或炉台，这炉子必须砸碎。它们不洁净了，并且以后对你们一直是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","尸体掉到水泉和水井中，虽然各种东西一触碰到它们就不洁净，但水泉和水井永远是洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","如果它们尸体的任何一部分掉在就要播撒的种子上，这种子依然是洁净的； ");
INSERT INTO cmn2006_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","但如果种子是浸在水里的，而它们的尸体掉在上面，这种子就不洁净了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","‘如果供人食用的动物死了，凡触摸了它的尸体的人要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","凡吃了它的肉的人必须洗涤衣服，但仍要不洁净到傍晚。凡拿了它的尸体任何一部分的人，必须洗涤衣服，但他仍不洁净到晚上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","‘所有的爬行动物都是可憎之物，你们绝不可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","无论是用肚皮爬的，用四只脚爬的，还是多足的爬虫都不可吃，它们都是可憎之物， ");
INSERT INTO cmn2006_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","你们不可因它们而玷污自己，使自己不洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","我是主，是你们的上帝，你们要使自己归圣，要保持圣洁；因为我是圣洁的。因此，你们不可因沾染任何爬行之物而使自己不洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","我是主，我把你们从埃及领出来，就是要作你们的上帝，所以，你们必须保持圣洁；因为我是圣洁的。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","以上是有关各种水陆动物、鸟类和爬虫的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","这些条例明确规定了洁净或不洁净、可吃或不可吃的动物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“你晓喻以色列人∶产妇如果生下男婴，她要不洁净七天，跟在月经期间不洁净一样。 ");
INSERT INTO cmn2006_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","第八天要给男婴行割礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","此后，产妇要再等三十三天，到流血停止才算洁净。在洁净期内，她不可触摸任何圣物，也不可进入圣所。 ");
INSERT INTO cmn2006_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","如果她生下女婴，要不洁净十四天，跟在月经期间不洁净一样。她要家居六十六天使产血洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“洁净期满之后，无论生的是男婴还是女婴，她都要用一只一岁大的羊羔作为烧化祭和一只雏鸽或斑鸠作为赎罪祭，带到圣幕门口交给祭司， ");
INSERT INTO cmn2006_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","由祭司把它们献给主，为她行洁净礼。这样，她在礼仪上就洁净了。这是有关妇女分娩的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","如果她买不起羊羔，可以用两只斑鸠或雏鸽代替，一只献作烧化祭，一只献作赎罪祭，由祭司为她行洁净礼，使她在礼仪上洁净。” ");
INSERT INTO cmn2006_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“人的皮肤上如果长了疖子、癣、或是发炎红肿，并且有变成恶性皮肤病的征侯，必须把他带到大祭司亚伦或亚伦家族的任何一个祭司那里， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","由祭司检查患处。如果患处的毛发变白，并且患处内陷，这就是恶性皮肤病的征侯，祭司要宣布这个人不洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","如果患处呈浅白色斑，但没有内陷，上面的毛发也没有变白，祭司就要把他隔离七天， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","在第七天再检查患处。如果患处没有扩大，外观也没有变化，祭司就要把他再隔离七天， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","在第七天再检查。如果症状消失了，也没有转移，祭司就要宣布这个人是洁净的。他所患的不过是癣。这人要洗涤衣服。这样，他就在礼仪上洁净了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","但是，在祭司经过检查宣布他洁净以后，如果患处再度蔓延，他必须回到祭司那里，由祭司重新检查。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","如果患处已经在皮肤上扩散，祭司就要宣布这个人不洁净。他患的是恶性皮肤病。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“如果有人患了恶性皮肤病，必须把他带到祭司那里检查。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","如果患处呈白色肿块，上面的毛发已经变白，且肿块已经溃烂露出瘀肉， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","这就是恶性皮肤病。祭司要宣布他不洁净，但不必再将他隔离，因为他已经被确定不洁净了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","如果皮肤上生了恶性皮肤病，并且扩散到全身，从头到脚凡祭司所看到的地方无处不有， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","这时，祭司就要检查他；如果病变确实已经长满全身，祭司就要宣布他为洁净。因为他全身都已变白了，所以在礼仪上是洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","但是，一旦患处溃烂露出瘀肉，他就是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","祭司要查看这瘀肉，宣布这人为不洁净；因为溃烂处的瘀肉是不洁净的，是恶性皮肤病的症状。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","过一段时间如果瘀肉又变白了，这人就要回到祭司那里重新检查。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","祭司如果看见患处确实变白了，就要宣布他为洁净。这人在礼仪上就是洁净的了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“如果有人皮肤上曾长过疮，已经好了， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","后来原患处又有肿块或带红点的浅白色斑，这人就要到祭司那里， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","由祭司检查患处。如果患处内陷，并且上面的毛发已经变白，祭司就要宣布这人为不洁净。这是由疮变成恶性皮肤病的症状。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","如果患处没有内陷，上面的毛发也没有变白，只是颜色变暗，祭司就要把他隔离七天以后再检查。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","如果患处扩散了，祭司就要宣布这人为不洁净。因为他患的是传染病。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","如果白斑既没有转移也没有扩散，那么只不过是疮的疤痕而已；祭司要宣布他为洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“如果有人皮肤上有烧伤，伤处的瘀肉呈白中带红点或浅白色斑， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","祭司就要检查他。如果白斑呈内陷状，且上面的毛发已经变白，这就是由烧伤变为恶性皮肤病的症状。祭司要宣布这人为不洁净；因为他所患的是恶性皮肤病。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","如果伤处没有内陷，上面的毛发也没有变白，只是颜色变暗，祭司就要把他隔离七天， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","在第七天再检查。如果白斑扩散了，祭司就要宣布这人为不洁净，这是恶性皮肤病的症状。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","如果色斑既没有转移也没有扩散，只是颜色变暗，那么只不过是烧伤的凸痕而已。祭司要宣布这人为洁净。因为那伤处只是烧伤的疤痕。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“如果男人或女人的头上或下巴上有了病变， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","祭司必须去查看。如果患处内陷，并且上面的毛发稀疏变黄，祭司就要宣布这人为不洁净；这是疥疮，是一种头部和下巴上的恶性皮肤病。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","如果患处没有内陷，但是上面没有黑色的毛发，祭司就要把这人隔离七天， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","在第七天再检查。如果病变没有扩散，上面也没有黄色的毛发，而且患处也没有内陷， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","这人就要剃掉病变区以外的毛发；祭司要把他再隔离七天。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","在第七天，祭司要再对病变区检查。如果患处没有内陷，病变也没有扩散，祭司就要宣布这人为洁净。这人要洗涤衣服；这样，他在礼仪上就洁净了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","如果在他被宣布为洁净后病变又扩散了， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","祭司就要重新检查他。如果经检查病变确实已经扩散，祭司就不必再找变黄的毛发，可以确定这人为不洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","如果病变的外观没有变化，上面还长出了黑色的毛发，那么表示病变已经痊愈了，这人已经洁净了。祭司要宣布这人为洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“如果男人或女人皮肤上长出许多白斑， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","祭司就要检查他或她。如果白斑呈暗白色，这只不过是皮疹。这人是洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“男人脱了发，秃了顶，但他仍是洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","即使仅是前额部分脱了发，他也仍然是洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","但是，如果头顶或前额光秃的部分出现带红点的白斑，这就是恶性皮肤病， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","祭司要查看他。如果这带红点的白斑确实象身体其他部位皮肤上的恶性皮肤病一样， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","这人患的就是恶性皮肤病，他就是不洁净的。祭司要宣布这人为不洁净。他的病变在头上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“患了恶性皮肤病的人必须穿撕裂的衣服，披散头发，蒙住上唇以上的脸部，还要大声喊叫∶‘我不洁净！我不洁净！’ ");
INSERT INTO cmn2006_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","这人在患病的整个期间都是不洁净的，必须独自住在营外。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","49","“如果在羊毛或麻纱的衣服上和衣料上或是皮革及皮革制品上出现绿色或红色的霉斑，必须把这会蔓延的霉斑交给祭司查看。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","祭司要查看这霉斑，要把这长霉斑的衣物隔离七天。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","在第七天，祭司要再检查衣物上的霉斑。如果霉斑在衣物上扩散了，这就是弥漫性的霉变。它是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","祭司要把这些有霉斑的衣服和皮革制品烧掉，因为这是弥漫性的霉变，必须用火烧掉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","祭司如果发现霉斑在衣服和皮革上没有扩散， ");
INSERT INTO cmn2006_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","就必须命令人们把这衣物洗净，然后再把它们隔离七天。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","七天之后，祭司要再检查这已洗去霉斑的衣物。如果霉斑又出现了，无论在衣物的正面或背面，即使外观没有改变，也没有扩散，它仍是不洁净的，你们必须把它烧掉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","如果霉斑变淡了，他就要把有霉斑的部分从衣料或皮革上撕下来。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","如果以后霉斑又出现了，这就是霉变蔓延了，必须把这有霉斑的衣物烧掉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","如果霉斑消失了，就要把这衣物再洗一次。这样，这衣物在礼仪上就洁净了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","以上是有关在羊毛或麻纱的衣服或衣料上或是皮革及皮革制品上发现霉斑的条例。是区分它们洁净或不洁净的依据。” ");
INSERT INTO cmn2006_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“以下是为恶性皮肤病人行洁净礼的有关条例。人们要带那人来见祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","祭司要出营来查看他，确认恶性皮肤病确实已经痊愈。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","然后，祭司要命人拿来两只洁净的野鸟，一块香柏木，一条红线和一株牛膝草， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","把其中一只鸟在盛满泉水的陶盆上杀掉， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","祭司本人要把另一只活鸟连同香柏木、红线和牛膝草一起浸在这鸟血里， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","向那求洁净的病人身上弹洒七次。然后，祭司就可以宣布这人已经洁净了。祭司要到野外放掉那只活鸟。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","被洁净的病人要洗涤衣服，剃掉所有的毛发，沐浴净身，这样，他在礼仪上就洁净了。他可以进入营地，但还要在自己的帐蓬外停留七天。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","在第七天，他要剃掉全身所有的毛发，包括头发、胡须、眉毛等一切毛发，洗涤衣服，沐浴净身，然后他就洁净了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“在第八天，他要带来两只没有残疾的公羊羔和一只一岁大的没有残疾的母羊羔，以及六升调油的上等面粉和三分之一升橄榄油。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","祭司要把他和这些祭品带到圣幕门前主的面前， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","然后，祭司要把作为赎过祭的公羊羔和三分之一升橄榄油一同作为举祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","羊羔要在宰杀赎罪祭和烧化祭的圣处杀掉；因为赎过祭与赎罪祭同样是至圣的，它归祭司所有。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","祭司要取一些赎过祭的血涂在被洁净人的右耳垂和右手的大拇指及右脚的大脚趾上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","再从献给主的三分之一升橄榄油里取出一些，倒在自己的左手手掌里。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","然后，祭司用右手的手指蘸左手手掌里的油，在主的面前弹洒七次。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","再用手掌里的油涂抹被洁净人已经涂过赎过祭血的右耳垂、右手的大拇指和右脚的大脚趾， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","手掌里剩余的油则涂在求洁净人的头上。这样，祭司就在主的面前为这人行了洁净礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","然后，祭司要献上赎罪祭，为求洁净人行洁净礼。接着，再把烧化祭的祭牲杀掉， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","把烧化祭和素祭献在祭坛上，为求洁净人行洁净礼。这样，求洁净人在礼仪上就洁净了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“如果求洁净人很穷，无力负担这么多的祭品，他可以只用一只公羊羔献作赎过祭，作为行洁净礼的举祭。再带来两升调油的上等面粉和三分之一升橄榄油， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","及两只斑鸠或鸽子，哪种力所能及就用哪种，一只鸟献作赎罪祭，另一只献作烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","他必须在行洁净礼的第八天把这些祭品带到圣幕的门前，在主的面前交给祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","祭司要把作为赎过祭的羊羔和三分之一升橄榄油一同作为举祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","献作赎过祭的羊羔要杀掉，祭司要取出一些血，涂在求洁净人的右耳垂、右手的大拇指和右脚的大脚趾上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","再向自己的左手手掌里倒一些橄榄油， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","用右手的手指蘸着左手手掌里的油，在主的面前弹洒七次， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","再把手掌里的一些油涂在求洁净人已经涂过赎过祭的血的右耳垂、右手大拇指和右脚的大脚趾上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","手掌里剩余的油则涂抹在求洁净人的头上，在主的面前为他赎罪。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","然后，祭司要献上那两只斑鸠或鸽子，哪种力所能及就用哪种， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","一只献作赎罪祭，一只献作烧化祭，与素祭一同献上。这样，祭司就在主的面前为他行了洁净礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","以上是恶性皮肤病人无力负担洁净礼仪的常例祭品时的有关条例。” ");
INSERT INTO cmn2006_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“当你们进入我赐给你们作为产业的迦南地时，我要使你们的一些房屋中发生霉变。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","那时，屋主必须去向祭司报告∶‘我的屋子里长出一些霉一样的东西！’ ");
INSERT INTO cmn2006_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","祭司要命人在他去查看霉变之前把屋子搬空，这样，屋子里原有的一切物品仍然是洁净的。然后，祭司要来检查屋子。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","他要仔细查看霉变的地方，如果墙上的霉变是一些红色或绿色的霉斑，并且已经蚀入墙壁， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","他就要走出屋子，把屋门锁闭七天， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","在第七天再来检查。如果墙上的霉变扩大了， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","他就要命人拆掉有霉斑的石头，把它们扔到城外专门设置的不洁之处。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","还要命人把墙皮全部刮掉，刮下来的墙皮也要扔到城外的不洁之处。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","然后，人们要用新的石头替补那些被拆掉的石头，再给墙抹上新的墙皮。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“这屋子如果经过拆换石头、刮换墙皮后又出现霉变， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","祭司就要再来查看。如果霉变现象扩大了，这就是侵蚀性的霉变，是不洁净之物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","这屋子必须拆掉，它的石头、木料和泥灰都必须扔到城外的不洁之处。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","在屋子锁闭期间，凡进过屋子的人都要不洁净到当天傍晚， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","凡在里面睡过觉或吃过东西的人都必须洗涤衣服。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“如果经过刮换墙皮之后，祭司来检查时没有发现有霉变扩散现象，祭司就可以宣布这房子为洁净；因为霉变已经消除了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","祭司要用两只鸟、一块香柏木、一条红线和一株牛膝草为房子行洁净礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","他要在盛满泉水的陶盆上杀掉其中一只鸟， ");
INSERT INTO cmn2006_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","然后用香柏木、红线、牛膝草和另一只活鸟蘸盆里的血和泉水，向这房子弹洒七次。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","这样，他就用鸟血、泉水、活鸟、香柏木、牛膝草和红线为房子行了洁净礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","然后，他要到城外的郊野，把活鸟放掉。他用这种方式为房子行了洁净礼，房子在礼仪上就洁净了。” ");
INSERT INTO cmn2006_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","以上是有关恶性皮肤病、疥疮、 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","衣物上或屋子里的霉变、 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","皮肤上的肿块、癣、斑块等的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","这些条例是鉴别洁净和不洁净的依据，是有关恶性皮肤病和霉变的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“你们晓喻以色列人∶‘男人的性器官如果有不正常的液体流出，他就是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","无论这漏症使他的性器官仍能正常排泄或是排泄困难，只要他身患漏症，他就是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","他躺过的床是不洁净的，他坐过的一切东西也都是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","凡触摸了他的床的人必须洗涤衣服，沐浴净身，但他仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","凡坐了他坐过的东西的人必须洗涤衣服，沐浴净身，但仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","凡接触了他身体的人必须洗涤衣服，沐浴净身，但仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","如果他把唾液吐到洁净人的身上，后者必须洗涤衣服，沐浴净身，但仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","他乘坐过的一切东西是不洁净的； ");
INSERT INTO cmn2006_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","凡触碰了他身下之物的人要不洁净到傍晚，凡拿了那些东西的人必须洗涤衣服，沐浴净身，但仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","如果他没有洗手就摸了别人，后者必须洗涤衣服，沐浴净身，但仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","被他触摸过的陶器都必须砸碎，被他触摸过的木器都必须用水冲洗。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","‘他的漏症痊愈以后，还要再等七天。他要洗涤衣服，在流动的水中沐浴净身，然后才算洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","在第八天，他要带两只斑鸠或鸽子到圣幕的门前来，在主的面前把它们交给祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","祭司要把其中一只献作赎罪祭，另一只献作烧化祭，这样，祭司就在主的面前为他行了洁净礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","‘男人如果遗精，他必须沐浴全身，但仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","凡被精液沾染的衣服和皮革都必须用水漂洗，但仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","男女性交后必须沐浴净身，但他们仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","‘女人在月经期间要不洁净七天。在这期间，凡接触了她的人都要不洁净到当天傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","她在经期内坐过或躺过的东西都是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","凡触摸了她的床的人必须洗涤衣服，沐浴净身，但仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","凡触碰了她坐过的东西的人必须洗涤衣服，沐浴净身，但仍然要不洁净到傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","凡触碰了放在她床上或坐位上的东西的人要不洁净到当天傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","男人如果与经期内的女人性交，他就要因这女人而不洁净七天；在这期间，他所躺过的床也是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","‘女人如果经期外多日流血或经血淋漓不尽，那么整个流血期间和在经期一样，她是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","只要流血不止，她所躺过的床就与月经期间躺的床一样是不洁净的；她所坐过的一切东西就与月经期间坐过的东西一样不洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","凡接触了这些东西的人也同样要不洁净；他必须洗涤衣服，沐浴净身，但仍然要不洁净到当天傍晚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","她的流血停止以后，必须再等七天才算洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","在第八天，她要带两只斑鸠或雏鸽到圣幕的门前来，把它们交给祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","祭司要把其中的一只献作赎罪祭，另一只献作烧化祭，这样，祭司就在主的面前为她行了洁净礼。’ ");
INSERT INTO cmn2006_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“你们一定要使以色列人远离使他们不洁净的事物，以免他们因玷污了我设在他们中间的圣幕而死亡。” ");
INSERT INTO cmn2006_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","以上是有关男人因患漏症和遗精而不洁净， ");
INSERT INTO cmn2006_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","女人因月经而不洁净，以及男女因不正常的遗漏而不洁净，男人与不洁净的女人性交而不洁净的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","亚伦的两个儿子因靠近主而死亡。他们死后， ");
INSERT INTO cmn2006_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","主对摩西说∶“你要吩咐你的哥哥亚伦，不可随意进入帷幔后面的至圣所，到约柜的施恩座前面来，否则他必死。因为施恩座之上是我在云中的显现之处。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","亚伦进入圣所必须遵守下述条例∶他要用一头公牛献作赎罪祭，一只公绵羊献作烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","他必须沐浴净身，贴身穿上麻纱做的内衣内裤，再穿上麻纱内袍，束上麻纱做的腰带，戴上麻纱做的礼冠，使自己圣服齐整； ");
INSERT INTO cmn2006_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","然后，他要从以色列会众那里取两只公山羊献作赎罪祭，一只公绵羊献作烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“亚伦要用公牛作为自己的赎罪祭，为自己和自己的家人行洁净礼， ");
INSERT INTO cmn2006_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","再把那两只公山羊牵到圣幕门口献给主， ");
INSERT INTO cmn2006_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","在主的面前给它们拈阄。一个阄归主，另一个阄归阿撒泻勒。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","亚伦要把拈阄归主的那只公山羊献作赎罪祭， ");
INSERT INTO cmn2006_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","而拈阄归阿撒泻勒的公山羊则要活着带到主的面前，然后把它放到旷野里去归给阿撒泻勒，以此为民众行赎罪礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“然后，亚伦要献上作为赎罪祭的公牛，为自己和家人行赎罪礼。他要亲手杀掉作为自己赎罪祭的这牛， ");
INSERT INTO cmn2006_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","然后才可以拿着盛满主面前祭坛上的火炭的香炉和两捧研成细末的香进入帷幔的后面。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","他要在主的面前把香放在火炭上，使缭绕的香烟遮住约柜上的施恩座，这样，他就不会死亡。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","他还要取一些公牛的血，用手指弹洒在施恩座的东侧；施恩座的前方也要弹洒七次。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“然后，亚伦要杀掉作为民众赎罪祭的公山羊，把羊血拿到帷幔的后面，弹洒在施恩座的上面和约柜的前面，和弹洒牛血的方式一样。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","这样，他就为至圣所行了洁净礼，使它不致被以色列人的种种不洁、叛逆行为和罪过所玷污。他还必须为圣幕行洁净礼，因为圣幕就座落在以色列人的种种不洁之中。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","在亚伦进入至圣所行洁净礼的整个期间，圣幕内不可有人。亚伦要在那里为自己和家人及全体以色列会众行赎罪礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","然后，他要从至圣所退出来，到主的祭坛前为它行洁净礼。他要取一些公牛血和山羊血，把它们涂在祭坛的四只角上。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","再用手指蘸着血，向祭坛上弹洒七次，洁净祭坛，这样，他就使祭坛超脱了以色列人的种种不洁而圣化归主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“亚伦为至圣所、会幕和祭坛行完赎罪礼之后，要把那只活的公山羊牵过来。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","他要用手按在这羊的头上，对着羊头承认以色列人种种故意犯的过错，他们的种种叛逆行为，包括了他们所有的罪过，把它们都归在这羊的头上，然后派专人把它牵走，放到旷野里去。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","这人在旷野里放掉羊，这样，这羊就把以色列人的一切罪都带走到无人居住的荒寂之地去了。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“然后，亚伦要进入圣幕，脱掉进至圣所时所穿的麻纱礼服，把它们放在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","他要在圣洁的地方沐浴净身，穿上日常便服，然后出来献上自己的和民众的烧化祭，为自己和民众行赎罪礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","他要把作为赎罪祭的脂肪放在祭坛上烧化。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","那放掉替罪羊的人必须洗涤衣服，沐浴净身，然后才可以进入营地。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","献作赎罪祭的公牛和公山羊的血已经拿入至圣所用于行洁净礼，它们的皮、肉和其他秽物都要拿到营外烧掉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","负责焚烧这祭牲的人必须在事后洗涤衣服，沐浴净身，然后才能进入营地。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“你们要永远遵守下列律法∶每年的七月初十日，你们必须禁食，不可做工，以色列人和寄居在你们中间的外族人都不可做工。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","祭司要在这天为你们行赎罪礼，使你们超脱你们的一切罪过，你们在主的面前又将是洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","对于你们，这是一个极其重要的安息之日。你们必须禁食，这是永久的戒律。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","受膏接任父职的大祭司要行下列赎罪礼∶他要穿上麻纱圣服， ");
INSERT INTO cmn2006_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","为至圣所、圣幕、祭坛、全体祭司和以色列会众行洁净礼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","这是你们要永远遵守的律法，以便你们可以每年一度为以色列人所犯的罪过行赎罪礼。” 亚伦遵照主对摩西的命令行事。 ");
INSERT INTO cmn2006_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“你晓喻亚伦和他的儿子们以及全体以色列人∶‘主告诫你们∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","凡以色列人宰杀了公牛、绵羊或山羊作为祭牲，无论是在营内还是营外， ");
INSERT INTO cmn2006_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","却没有把它带到圣幕的门前作为祭物献给主，他就犯了流血之罪，就要从他的族人之中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","因此，以色列人不可象以往那样在郊野设祭，他们必须把祭物带到主的圣幕门前来，在主的面前把它们交给祭司，作为平安祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","祭司要把血泼洒在圣幕门前主的祭坛上，把祭牲的脂肪烧化在祭坛上，这香味是主所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","他们不可再献祭给那使他们堕落的山羊鬼。这是他们世世代代要遵守的条例。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“你要告诫他们∶‘任何以色列人，或寄居在他们中间的外族人， ");
INSERT INTO cmn2006_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","如果随便在别处献烧化祭或其他祭品，却不把它们带到圣幕门前来献给主，他就要从他的族人中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","‘如果任何以色列人或寄居在他们中间的外族人吃血，我就要摒弃这人，他就要从他的族人中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","生命存在于血之中，所以我把血赐给你们，让你们把它倒在祭坛之上，为你们的生命赎罪。因为只有代表生命的血才能赎回生命。 ");
INSERT INTO cmn2006_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","13","因此，我要告诫以色列人∶任何人－无论是以色列人还是寄居的外族人，都不可吃血。如果有人猎取到可食用的野兽或鸟类，必须放尽它的血，并用土掩埋起来。 ");
INSERT INTO cmn2006_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","血是万物生命之源。我再次告诫以色列人∶你们不可吃任何动物的血，那就是它的生命。凡吃了血的人必从他的族人中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","如果有人吃了自毙的动物或被其他动物咬死的动物的肉，无论他是本族人还是外族人，都必须洗涤衣服，沐浴净身，但仍然要不洁净到当天傍晚，然后才算洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","如果他不洗衣服，也不沐浴净身，他就要承受罪罚。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“你晓喻以色列人∶‘我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","你们不可效法你们曾经居住过的埃及国的习俗，也不可效法我要领你们去的迦南地的习俗。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","你们要遵行我的律法，谨守我的诫命。我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","你们要遵行我的律法和诫命，凡顺从的人必因此而存活；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","‘不可与自己的近亲乱伦；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","不可与自己的母亲有性关系而侮辱了自己的父亲，此外，她是你的生身之母，你不可与她有性关系。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","不可与父亲的妻子有性关系而侮辱了自己的父亲； ");
INSERT INTO cmn2006_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","不可与亲姐妹、同父异母或同母异父的姐妹有性关系；无论她跟你一起长大或不在一起长大的，都不可有这种关系。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","不可与孙女或外孙女有性关系，这是侮辱你自己。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","不可与父亲的妻子的女儿有性关系，她是你的姐妹。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","不可与姑母有性关系，她是你父亲的近亲。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","不可与姨母有性关系，她是你母亲的近亲。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","不可与你父亲的兄弟的妻子有性关系，她是你的伯母；不可因此侮辱你父亲的兄弟。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","不可与儿媳有性关系，她是你儿子的妻子，不可与她有性关系。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","不可与兄弟的妻子有性关系，侮辱你的兄弟。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","不可与一个女人有性关系，又与她的女儿有性关系，你也不可娶她的孙女或外孙女，因为她们是近亲；这是邪恶的事。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","你的妻子还在世时，不可娶她的姐妹，也不可与她有性关系。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","‘不可与经期的女人性交，因为她是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","不可与邻居的妻子通奸，玷污你自己。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","不可把自己的儿女当作祭物烧献给异神摩洛，这会玷污你的上帝的名；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","男人不可与男人有性关系；这是上帝所厌恶的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","男女都不可与兽类有性关系，这是反自然的行为，是玷污自己。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","‘你们不可用上述行为玷污自己。因为我将要从你们面前赶走的异族人就是因为这些行为而玷污了自己。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","他们所居住的土地因此而不洁，我也将因他们的罪降罚于块土地，所以这土地将摒弃它的原住民。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","你们－无论是本族人还是寄居的外族人，一定要遵行我的律法和诫命，不可做那些上帝所憎恶的事。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","那里的原住民做了这一切可憎之事，玷污了土地。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","只要你们遵行主的律法，那土地就不会因受到玷污而摒弃你们，象它摒弃那些原住民一样。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","任何做了这可憎之事的人都要从他们的族人中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","所以，你们一定要谨守我的律法，不可效法原住民的恶习而使自己不洁净；我是主，是你们的上帝。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“你晓喻全体以色列人∶‘你们要保持圣洁，因为我－你们的上帝是圣洁的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","你们每个人都要尊敬父母，谨守我的安息日；我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","不可背离我去拜偶像；不可为你们自己铸造偶像；我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","‘你们向主献平安祭时，一定要遵守规定的礼仪，这样我才会接受你们的奉献。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","祭牲的肉必须在献祭的当天或第二天吃完，吃不完的必须在第三天烧掉， ");
INSERT INTO cmn2006_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","如果有人在第三天吃这祭肉，它就是不洁净的，我必不接纳。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","他要因他的罪承受罪罚，因为他玷污了属于主的圣物。必须把他从他的族人中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","‘收割庄稼的时候，不可割尽田边地角，也不可返回去捡遗落的谷穗； ");
INSERT INTO cmn2006_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","收葡萄的时候，不可摘尽所有的葡萄，也不可捡落在地上的葡萄；要把这些留给穷人和外族人。我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","‘不可偷盗；不可彼此欺诈撒谎； ");
INSERT INTO cmn2006_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","不可指着我的名发假誓，藐视你的上帝的圣名；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","‘不可欺压邻居；不可抢夺别人的东西；雇工的工钱不可拖延，必须当天付清。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","不可咒骂聋子；不可故意把东西放在瞎子的前面绊倒他；你们要尊崇你们的上帝；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","‘你们在审判中要主持正义。不可偏袒穷人，也不可偏袒权贵；要以公心裁决你的同胞。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","不可到处散布流言蜚语；不可危害邻居的健康和安全以牟利；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","‘不可怀恨你的邻居；如果他有不是之处，要向他坦诚指出，以免自己因怀恨他人而使自己有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","要对别人的冒犯宽厚为怀，不要以怨报怨。要爱人如爱己；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","‘你们要谨守我的律法。不可使不同类的牲畜交配；不可在一块田里播下两样种子；不可穿用两种原料织造的衣服。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","‘如果有人与已经定婚的女仆有了性关系，而她当时既没有被赎回也没有被释放为自由人，那么他们就要承受罪罚，但罪不至死；因为她还不是自由人。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","但是，这人必须带一只公绵羊到圣幕的门口来，作为赎过祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","祭司要用这羊为他行赎罪礼，使他超脱自己所犯的罪。然后他才会得到赦免。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","‘你们进入迦南地以后，无论栽种哪一种果树，头三年的果实都要当作不洁之物对待，不可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","第四年的果实要全部献给主归圣，以赞美主的恩惠。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","从第五年起，果实就归你们食用了。这样，你们的收成会越来越好。我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","‘你们不可吃带血的肉；不可占卦；不可行巫术； ");
INSERT INTO cmn2006_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","不可剃掉头周围的头发；不可修剪胡须； ");
INSERT INTO cmn2006_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","不可用刀划伤身体为死者致哀；不可纹身；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","‘不可使你的女儿沦为娼妓，以免这里的民众堕落，世风败坏。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","你们要谨守我的安息日，要敬重我的圣处；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","‘不可召鬼；不可扶乩；否则你们就玷污了自己。我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","‘你们要尊敬老年人，在他们面前要恭敬侍立；要敬畏你们的上帝；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","‘当外族人寄居在你们中间时，你们不可欺负他们。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","要象对待本族人一样对待他们，要象爱你自己一样爱护他们；因为你们也曾寄居在埃及。我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","‘你们在使用度、量、衡的时候，不可心怀不正。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","在计量粮食和酒、油一类的液体时，要使用公平的秤、尺和升斗类的量具。我是主，是你们的上帝。是我把你们领出了埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","你们一定要谨守我的一切律法和诫命，要遵行不误，我是主。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“你晓喻以色列人∶‘任何把自己的儿女祭献给摩洛的人，无论是以色列人还是寄居在以色列的外族人，都必须处死。会众要用石头打死他。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","我要摒弃这人，把他从他的族人中除名。因为他把自己的亲生子女献给摩洛的行为玷污了我的圣所，亵渎了我的名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","如果当地人对他的行为佯装不见，不处死他， ");
INSERT INTO cmn2006_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","我就要把这人从他的族人中除掉，也要除掉那些跟他一起出卖自己去拜摩洛的人。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","‘任何召鬼求卦的人都是对我不忠的人。我要摒弃他们，把他们从他的民众中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","你们要使自己圣洁，并且要始终保持圣洁。我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","你们一定要谨守我的律法，遵行不误。我是使你们归圣的主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","咒骂父母的人必须处死；他咒骂了自己的亲生父母，罪有应得。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","‘如果有人与他人之妻通奸，奸夫淫妇都必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","如果有人与他父亲的妻子通奸，他就侮辱了他的父亲，两人都必须处死。他们罪有应得。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","如果有人与儿媳通奸，两人都必须处死，他们犯了乱伦之罪，罪有应得。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","如果男人与男人有性关系，两人都必须处死。因为这是上帝所憎恶的事。他们罪有应得。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","如果有人同时娶了母女两人，就犯了大恶。三人都必须用火烧死，以杜绝你们当中的这种罪恶。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","16","凡有兽淫行为的人，无论男女都必须处死，同时也要杀掉那动物。他们罪有应得。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","‘如果有人娶了同父异母或同母异父的姐妹，彼此有了性关系，他们就做了可耻的事；必须在公众面前把他们公开除名。这人与自己的姐妹有了性关系，必须承受罪罚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","如果有人与经期内的女人性交，他就暴露了她的血源，而她也暴露了自己的血源，两人都要从他们各自的族人中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","不可与姑母或姨母发生性关系，这是近亲通奸，必须承受罪罚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","如果有人与伯母或叔母发生性关系，他就侮辱了他的伯父或叔父，他和他的伯母或叔母都要承受罪罚。他们将终生不育。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","如果有人娶了自己的兄嫂或弟媳，就犯了不洁之罪。他侮辱了自己的兄弟，他们将终生不育。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","‘你们一定要谨守我所有的律法和诫命，并遵行不误。这样，我要领你们去的那块土地就不会摒弃你们。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","你们不可效法我在你们面前驱赶走的那些异族人的习俗，他们犯了上述的罪，所以我憎恶他们。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","我对你们说过，你们将占有他们的土地，我将把它赐给你们作为你们的产业。这是一块流奶与蜜的富饶之地。我是主，是你们的上帝，我从众多的民族中拣选了你们， ");
INSERT INTO cmn2006_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","因此，你们一定要区分洁净与不洁净的动物和鸟类，不可吃我指定为不洁净的动物、鸟类和爬虫类，以免玷污自己。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","你们要为我保持圣洁，因为我是圣洁的，我是主。我从众多的民族中拣选了你们作为我的子民。 ");
INSERT INTO cmn2006_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","‘凡召鬼求卦的人，无论男女都必须处死；会众要用石头打死他们。他们罪有应得。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","主对摩西说∶“你要晓喻亚伦家族的祭司们∶‘祭司不可接近死去的亲属的尸体而玷污自己。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","但他的嫡亲－母亲、父亲、儿子、女儿和兄弟可以例外。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","他未出嫁的姐妹也可以例外，因为她还没有属于别的男人，他可以为她而不洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","但不可以为姻亲的死亡而玷污自己。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","祭司不可剃光秃；不可修剪胡须；不可用刀划身体； ");
INSERT INTO cmn2006_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","他们必须为他们的上帝保持圣洁，必须尊重他们上帝的名，因为他们是向主献食祭－他们的上帝的食物－的人，他们必须归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","他们不可娶有过淫行的女人，也不可娶离婚的女人，因为祭司必须为他的上帝保持圣洁。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","你们必须以他为圣，因为是他把食祭献给你们的上帝；他对于你们是圣洁的，因为我－使你们归圣的主，是圣洁的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","如果有祭司的女儿堕落为妓女，使自己不洁，她就玷污了她的父亲，必须把她烧死。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","‘头上受膏、身着大祭司圣服的大祭司不可因哀伤而披散头发，撕裂衣服。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","他不可接近死者，即便父母的遗体也不能例外，以免玷污自己。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","他不可离开圣处；不可使上帝的圣处不洁净，因为上帝的膏油已经使他圣化归主；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","他只可以娶处女； ");
INSERT INTO cmn2006_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","不可娶寡妇、离婚的女人或有过淫行的女人，他只能娶本族的处女。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","这样，他的后代就能保持洁净，因为我已经使他圣化归主。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“你晓喻亚伦∶‘你的后代中任何身体有缺陷的人不可到祭坛前来向他的上帝献食祭，这是你们世世代代要遵守的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","有以下身体缺陷的人都不可到祭坛前来∶瞎子，跛子，五官不正的，畸形的， ");
INSERT INTO cmn2006_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","手脚残废的， ");
INSERT INTO cmn2006_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","驼子，矮子，眼睛有毛病的，长疥的，疮口流脓的，阉人。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","祭司亚伦的后代中凡有身体缺陷的人都不可到祭坛前向我献食祭，因为残缺的人不能向上帝献食祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","这样的人可以吃献给我的祭物，无论是至圣的还是圣的都可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","但他决不可进入圣所，也不可靠近祭坛；不可因他的身体缺陷而玷污了我的圣处，因为我已经使这些地方圣化归主，我是主。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","摩西把这一切都告诉了亚伦和他的儿子们及全体以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“你告诫亚伦和他的儿子们，他们要尊重以色列人献给我的圣物，以免亵渎我的圣名；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","你要晓喻他们∶‘从现在起，你们的后代中凡在不洁净期间靠近或触摸了以色列人献给我的圣物的人，都要把他从面前除掉。（即解除他的祭司职务）这是你们世世代代要遵守的条例。我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","亚伦的后代中凡患有恶性皮肤病和漏症的人，在洁净以前都不可吃归圣的祭物。凡接触了被死尸污染过的东西、有过射精行为、 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","触碰了礼仪上不洁净的爬虫类，或接触过有任何不洁行为的人，那么，这个人就是不洁净的， ");
INSERT INTO cmn2006_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","他要在有上述不洁行为的当天不洁净到傍晚。在这期间，在沐浴净身之前他不可以吃圣祭物， ");
INSERT INTO cmn2006_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","直到太阳下山后才算洁净。然后，他就可以吃圣祭物了，因为这本是他的应得之份。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","祭司不可吃自毙的或被其他动物咬死的动物，以免玷污自己。我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","祭司必须谨守我的律例，以免因违犯条律而获罪致死。我是拣选他们归圣的主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","‘祭司家族以外的人不可吃圣祭物。来访的客人和祭司的雇工都不可吃圣祭物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","但祭司用钱买来的奴仆和家生的奴仆可以吃祭司分得的圣祭物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","祭司的女儿如果嫁给了非祭司的人，她就不可以再吃圣祭物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","但是，一旦她成了寡妇或离了婚，又没有子女，重新回到父家居住，她就可以吃她父亲分得的圣祭物。而任何祭司家族以外的人都不许吃这圣祭物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","如果有人无意中吃了圣祭物，他必须按原价再加上五分之一赔还祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","但祭司必须尊重以色列人献给主的圣祭物， ");
INSERT INTO cmn2006_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","他们不可让以色列人吃这圣祭物而导致他们受罚，因为我已经使这圣祭物归圣；我是主。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“你晓喻亚伦和他的儿子们以及全体以色列人∶‘任何以色列人或寄居在以色列的外族人向主献上烧化祭作为还愿的祭品或作为自愿献上的祭品时， ");
INSERT INTO cmn2006_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","祭牲必须是没有残疾的公牛、公绵羊或公山羊，这样，我才会接纳你们的奉献。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","你们不可献上任何有生理缺陷的动物，因为我不会接纳这样的祭品。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","如果有人向主献上平安祭还愿或作为自愿献上的祭品，必须是没有残疾和生理缺陷的祭牲。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","不可把瞎眼的、瘸腿的、残废的、或有癣、疥一类皮肤病的动物作为祭牲献给主。不可把这类祭牲献到祭坛上作为食祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","发育不全或畸形的公牛或羊羔可以献作自愿祭，但不能献作还愿祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","不可把睾丸损伤、压碎、被扯掉或骟除过的动物献给主，在你们境内不准发生这种事。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","不可将从外国人那里得到的这类畜牲作为食祭献给你们的上帝，因为它已经受过某些伤损，是不健全的动物。我不接受它们。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","主对摩西说 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“要让刚出生的小公牛、小绵羊或小山羊跟母牛或母羊在一起呆七天，在第八天或第八天以后，你们才可以把它作为食祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","不可在同一天宰杀母牛和它的小牛以及母羊和它的小羊。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","向主献感恩祭的时候，必须按照条例奉献，使它能蒙主悦纳。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","祭肉要在当天吃掉，不可留到第二天早晨。我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","你们要谨守我的律法，并遵行不误。我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","你们要尊崇我的圣名。以色列人要以我为神圣。我是拣选你们归圣的主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","是我把你们领出了埃及，作你们的上帝。我是主。” ");
INSERT INTO cmn2006_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“你晓喻以色列人∶‘以下是你们要宣布为圣会的主规定的节日。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","‘你们可以工作六天，但第七天是安息日，是完全休息的日子，也是举行圣会的日子。在这天不可做任何工作。无论你们住在哪里，安息日是属于主的。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","‘下列日子是主的固定节日，是你们要在规定日期举行的圣会。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","每年正月十四日，从黄昏开始就是主的逾越节。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","从正月十五日开始是无酵节。七天之内，你们只能吃无酵饼。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","在节期的第一天，你们要举行圣会。这天，你们不可做任何工作。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","要连续七天向主献上食祭。在第七天要举行圣会。在这天也不可做任何工作。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“你晓喻以色列人∶‘你们进入我赐给你们的土地以后，每次收割庄稼，必须把收割的第一捆谷物交给祭司， ");
INSERT INTO cmn2006_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","由祭司在安息日的第二天呈献给主，这样，主就会悦纳你们的祭献。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","献谷物的这天，你们要同时把一只一岁大没有残疾的公羊羔作为烧化祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","还要献上用四升半上等面粉调和橄榄油的素祭，这悦人的香气是献给主的礼物。此外，还要献上一公斤酒作为奠祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","新收成的谷物，无论是生的和烤熟的谷子还是用新谷做成的饼，都要等到向主献祭以后才可以吃。你们的后代，无论住在哪里，都要永远遵守这条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","‘从安息日的第二天，也就是把初熟的新谷作为举祭献给主的那一天算起， ");
INSERT INTO cmn2006_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","数到第五十天－也就是七个星期后的第七个安息日的第二天，你们要把新收的谷物作为祭物献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","你们要从家里带两块饼来作为举祭献给主。这两块饼用两公斤上等面粉加酵烤制而成，作为初熟的祭物献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","同时，还要献上七只一岁大的公羊羔、一头公牛和两只公绵羊，这些祭牲都不可有残疾。要把它们作为烧化祭跟素祭和奠祭一起献给主。这悦人的香气是献给主的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","你们还要向主献上一只公山羊作为赎罪祭，两只一岁大的羊羔作为平安祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","祭司要把这两只羊羔和初熟的谷物做成的饼一起作为举祭献给主。它们将圣化归主，属祭司所有。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","你们要在这天举行庆祝活动。这是你们的圣会，你们在这天不可做任何工作。你们的后代无论住在哪里，都要永远遵守这一条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","‘当你们收割庄稼的时候，不可割尽田边地角，也不可返回去捡落在地上的谷穗，这些要留给穷人和寄居的外族人。我是主，是你们的上帝。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“你晓喻以色列人∶‘每年的七月初一日是特设的安息日，你们要在这天吹号以志纪念，举行圣会。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","你们在这天不可做工，要向主献上食祭。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“每年的七月初十日是赎罪日。你们要举行圣会，禁食，并向主献上食祭。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","你们在这天不可做工，因为这天是为你们向主－你们的上帝行赎罪礼的日子。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","凡在这天不禁食的人都必从他的族人中除名， ");
INSERT INTO cmn2006_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","凡在这天做工的人都必从他的族人中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","你们在这天不可做工；你们无论住在哪里，都要世世代代永远遵守这一条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","这天是你们的安息日，你们要禁食，要从七月初九日的黄昏开始守节，直到第二天的黄昏。” ");
INSERT INTO cmn2006_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“你晓喻以色列人∶‘每年的七月十五日是住棚节。主的这个节日要持续七天。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","第一天你们要举行圣会，不可做任何工作。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","你们要连续七天向主献上食祭；第八天，你们要再举行圣会，并向主献上食祭。你们在这天不可工作，因为这天是举行圣会的日子。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","‘以上是主的固定节日。你们要在各个节期分别举行圣会，向主献上食祭，包括烧化祭、素祭、各种祭物和每天必需的奠祭， ");
INSERT INTO cmn2006_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","这些节日是安息日以外的节日；在这些节日所献的祭是还愿祭和自愿祭以外的奉献。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","‘收完庄稼以后，你们要从七月十五日起为主守节七天。第一天和第八天是圣安息日。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","在第一天，你们要从果树上摘下最好的果子，还要从河边折一些棕树枝、带叶的粗树枝和柳树枝来，在主－你们的上帝面前为他守节七天。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","每年的七月，你们都要欢庆主的这个节日，为他守节七天。你们要世世代代永远遵守这一条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","在节期内，所有的以色列人都要在临时搭起的棚子里住七天， ");
INSERT INTO cmn2006_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","好让你们的后代知道，当我把以色列人领出埃及的时候，我曾让他们住在临时的棚子里。我是主，是你们的上帝。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","摩西把有关主的节日的一切都告诉了以色列民众。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“你吩咐以色列人向你提供纯净的橄榄油作为灯油，好让灯按时点亮。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","每天晚上，亚伦要在圣幕中约柜的帷幔外边点亮灯，使它在主的面前一直亮到第二天早晨，这是你们世世代代要遵守的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","主前面的金灯台上的灯必须按时点亮。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“你要用上好的面粉烤制十二个饼，每个饼用面四升半。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","你把这些饼摆在主面前的纯金供桌上，摆成两排，每排六个， ");
INSERT INTO cmn2006_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","再在每排饼上撒上纯乳香，象征着把饼作为食祭献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","每个安息日都要按期摆设供饼，这是以色列人要永远遵守的约。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","这些供饼归亚伦和他的儿子们所有，他们要在洁净的地方吃这饼，因为它是至圣之物，是献给主的食祭中永远属于亚伦和他的儿子们的应得之份。” ");
INSERT INTO cmn2006_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","有一个人，他的父亲是埃及人，母亲是以色列但支派人底伯利的女儿示罗密。有一天，他在以色列人中间闲逛，在营里跟一个以色列人打了起来。在打斗中，他一边说着主的名一边诅咒。于是，人们把他带到摩西那里， ");
INSERT INTO cmn2006_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","拘禁起来。等候主的处理。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“你把那诅咒我的人带到营外，让所有听见他诅咒的人都用手按在他的头上，然后，全体会众要用石头把他打死。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","你要向以色列人宣布∶‘凡诅咒上帝的人必承受罪罚， ");
INSERT INTO cmn2006_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","亵渎主的人必被处死。全体会众要用石头打死他。凡诅咒上帝的人，无论是本族人还是寄居的外族人，都必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“杀人者偿命； ");
INSERT INTO cmn2006_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","杀了别人的牲畜必须赔还活畜。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","凡伤害他人的人要以其人之道还治其人之身∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","以骨还骨，以眼还眼，以牙还牙。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","弄死了别人的牲畜必须照样赔偿。杀人者必须偿命。 ");
INSERT INTO cmn2006_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","以上条例适用于你们全体，包括本族人和寄居的外族人。我是主，是你们的上帝。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","摩西向以色列人宣布了主的旨意。于是，以色列人执行主对摩西的命令，把那人带到营外，用石头打死了他。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","主在西乃山对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“你晓喻以色列人∶‘你们进入我赐给你们的土地之后，每七年要休耕一次，作为向主表示敬意的安息年。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","六年当中，你们可以耕田播种，修整葡萄园，收获土地的出产； ");
INSERT INTO cmn2006_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","但第七年要让土地完全休息，作为安息年献给主。你们在这一年不可耕作土地，也不可修整葡萄园。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","不可收割地里自生自长的庄稼，也不可收摘未经修剪的葡萄树自然结出的葡萄。这一年要让土地完全休息。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","但你们仍然可以吃土地在这年自然结出的果实，你们的男女奴仆、雇工、寄居的外族人， ");
INSERT INTO cmn2006_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","包括你们的牲畜和这块土地上的野兽都可以吃这块土地上的出产。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","‘每七个安息年，也就是每七七四十九年， ");
INSERT INTO cmn2006_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","你们要在七月初十日－也就是赎罪日，在全国各地吹响号角， ");
INSERT INTO cmn2006_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","尊第五十年为圣。你们要向全体民众宣布这一年是他们回归自由的日子，你们要把它称为禧年。每个人都将重新得到自己原有的财产，每个人都可以归回自己的本族。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","这第五十年是你们的禧年，你们在这一年不可耕作，也不可收获地里自生自长的庄稼和葡萄树上自然结出的葡萄。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","因为这一年是禧年，是你们的圣年。但你们可以吃土地自然结出的果实。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","‘每逢禧年，各人原有的财产都要归还本人。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","无论你把自己的产业卖给别人，还是从别人那里买产业，彼此都要以诚相待。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","你买别人的产业，价格要根据成交时距上次禧年的年数多少而定。对方把产业卖给你，价格也要依距下一禧年之间有收成的年数多少而定。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","剩下的年数越多，价格就越高，反之，价格就低。因为他卖给你的实际是收成的年数，而不是地产。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","不要彼此欺骗，要敬畏你们的上帝。我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","‘你们要谨守我的律法和诫命，并遵行不误，这样，你们就能在这块土地上无忧无虑地生活， ");
INSERT INTO cmn2006_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","土地会结出果实，会满足你们的需求，会让你们在它的上面平安度日。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","也许你们要问∶我们不种不收，靠什么在第七年度日呢？ ");
INSERT INTO cmn2006_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","我会在第六年赐福给你们，土地会产出足够三年吃的食粮。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","你们在第八年开始耕作的时候，剩下的存粮还可以一直吃到第九年的新粮入仓。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","‘土地不能被永久性地买卖；因为土地是属于我的，你们只不过是暂居在这土地上的过客。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","在你们的国境之内，必须承认赎地权。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","如果你们的族人因贫穷出卖土地，他的近亲必须来赎买出卖的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","如果他没有可赎买土地的近亲，而自己后来有了足够的经济能力可以赎回土地， ");
INSERT INTO cmn2006_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","那么，他就要计算土地卖出的年数，把剩余年数的价值还给买主，这样，土地就重新归他所有。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","如果他无力赎回自己的土地，这土地就仍旧归买主所有，直到禧年才归还他。在禧年，土地都要归还原主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","‘如果有人卖了城里的房子，他有权在一年之内赎回，但仅以一年为限。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","如果房子在一年之内没有赎回，将归买主及其后代永久所有。在禧年也不再归还原主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","但是，在没有城墙的小城镇和乡村里的房子则按照田产对待。它可以被随时赎回，而且在禧年要归还原主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","在利未人的城里，利未人对房子有永久赎回权。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","如果房主没能赎回房子，在禧年房子仍要归还给他。因为利未人城中的房子是利未人在以色列人中永久拥有的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","利未人城郊的牧场不可买卖，那是利未人永久的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","‘如果你的族人穷困潦倒，不能维持生计，你要象对待寄居的外族人一样帮助他们，好让他能在你们当中生活下去。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","你借钱或粮食给他，不可索取利息；要敬畏上帝，要让他能继续和你们一起生活， ");
INSERT INTO cmn2006_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","无论借给他钱或物都不可索取利息。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","我是主，是你们的上帝，我把你们领出埃及，就是要把迦南地赐给你们，并且做你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","‘如果你的族人因穷困而卖身给你，你不可把他当作奴仆看待。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","他只不过象一个雇工一样寄居在你那里，为你做工直到禧年。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","然后，他就可以带着子女离开，回到自己的本族，重新得到自己祖传的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","因为他们是侍奉我的人，是我把他们领出埃及，他们不准被卖而作奴隶。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","你不可虐待这卖身人；你要敬畏你的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","你的男女奴仆只能是外族人，你可以从邻国买， ");
INSERT INTO cmn2006_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","也可以从寄居在你们中间的外族人和他们在本地出生的子女中买。这些奴仆是你们的产业， ");
INSERT INTO cmn2006_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","你们可以把他们作为遗产传给你们的子孙后代。你们可以役使这些外族人作你们的奴仆，但不可以虐待卖身给你的族人，因为他是你的以色列同胞。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","‘如果某个寄居的外族人很富有，而你的一个族人却很贫穷，他把自己卖身给了这个外族人或他的家族。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","他卖身以后享有赎买权。他的兄弟、 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","叔伯、堂兄弟或其他近亲都可以赎回他。如果他自己以后有了钱，也可以为自己赎身。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","他和买他的人要计算他自卖身之日起至禧年的年数，他的身价要按年数而定，他与买主在一起的时间要按雇工计算。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","如果距禧年还很远，他就要按照剩余的年数按比例偿还对方买价中的大部分； ");
INSERT INTO cmn2006_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","如果距禧年只有不多几年了，赎价就相应减少。总而言之，赎价的多少全由年数而定。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","买主要把他当作长年雇用的工人一样看待，不可虐待他。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","如果他不能用这些方法赎回自己，他和他的子女等到禧年仍然要恢复自由。 ");
INSERT INTO cmn2006_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","因为我是至高者，以色列人是我的仆人，是属于我的。是我把他们领出了埃及。我是主，是你们的上帝。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","主说∶“你们不可为自己造偶像；不可在你们的国土上竖立雕像、柱像或雕塑的石柱去伏身崇拜。我是主，是你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","你们要守我的安息日，要尊重我的圣处；我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“如果你们谨守我的律法和诫命，并遵行不误， ");
INSERT INTO cmn2006_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","我就会适时给你们降下雨水，让土地长出庄稼，让果树结出果实， ");
INSERT INTO cmn2006_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","让收获的庄稼直到葡萄成熟的季节仍然收打不完，让果园里的葡萄直到播种的季节仍然采摘不尽；你们将丰衣足食，安居乐业。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","我将赐给你们和平，让你们高枕无忧。我将除掉你们土地上的害兽，也没有敌人犯境。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","你们将追赶仇敌，在战场上砍杀他们。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","你们将能以五当百，以百当万，你们的仇敌都必死于你们的刀下。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","我要赐福给你们，使你们子孙众多；我也必坚守与你们的约。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","你们收的粮食一年到头吃不尽，新粮又来替换旧粮。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","我将把我的居处安在你们中间，绝不离弃你们。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","我将与你们同在；我要做你们的上帝，你们要做我的子民。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","我是主，是你们的上帝。是我把你们领出了埃及，使你们不再作他们的奴隶。是我粉碎了你们身上的枷锁，使你们能扬眉吐气，昂首做人。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“但是，如果你们不顺从我，不守我的诫命， ");
INSERT INTO cmn2006_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","背离我的律法，厌弃我的条例，你们就违背了我的约， ");
INSERT INTO cmn2006_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","我就要降灾于你们∶我将使痨病和热病在你们中间流行，弄瞎你们的眼睛，吞噬你们的生命。你们播种却没有收获，因为你们的仇敌将攫取收成。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","我要敌对你们；你们必败于敌手，恨你们的人必统治你们。你们必心惊胆战，即便无人追赶，也会四散逃命。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","如果你们经历过这些灾难之后仍不顺从我，我就要按你们的罪加重七倍惩罚你们。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","我要摧毁你们引以为傲的国力，使你们四野干旱，颗粒无收。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","你们拼命干活，却徒劳无功；你们的土地不长庄稼，你们的果树不结果实。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","此后，如果你们仍然与我作对，不肯顺从我，我就要继续按你们的罪加重七倍惩罚你们。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","我要放出恶兽敌对你们，拉走你们的儿女，吃掉你们的牲畜，使你们人丁稀落，道途荒凉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“这些惩罚之后，如果你们仍然不服我的管教，继续与我对抗， ");
INSERT INTO cmn2006_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","我就要敌对你们。我要亲自按你们的罪加重七倍惩罚你们。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","我要使你们因背弃我的约而罹战乱，我要使你们为避难而聚居的城里瘟疫流行，我要把你们交到你们仇敌的手中。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","我要断绝你们的粮源；由于粮食稀少，十个女人只能在一个炉子上烘饼。她们按配额给你们发放食物，你们只能半饥半饱。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“经过这些惩罚之后，如果你们仍然抗拒我， ");
INSERT INTO cmn2006_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","我就要向你们发怒，按你们的罪加重七倍惩罚你们。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","你们的国土上将会饥馑遍地，你们不得不烹子而食。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","我将夷平你们的邱坛，砸碎你们的香坛，把你们的尸体丢在你们那些毫无生气的偶像上。我必摒弃你们， ");
INSERT INTO cmn2006_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","使你们的城市沦为废墟，使你们的圣处变为荒地；我也不再接纳你们的祭物。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","我要使你们的国土一片荒凉，连侵占它的仇敌也为之震惊！ ");
INSERT INTO cmn2006_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","我将使你们遭逢战乱，土地荒废，城市毁坏，让你们流离失所，星散于列国之中。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","这样，在你们流亡异国抛离故土期间，你们的土地将因荒废而享受安息。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","它要补偿你们在它上面生活时没有给予它的安息年。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","37","我要给你们在异国的遗民一颗惊恐的心，风声鹤唳也会使你们如临大敌，四散逃命。即使没有追兵，你们自己已经跌跌撞撞，乱作一团，根本无力抵御你们的仇敌。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","你们必死在异国他乡，被仇敌的土地所吞食。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","剩下的人也将因他们自己的罪和他们祖先的罪终将在他们仇敌的土地上消亡。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“但是，如果他们承认自己和祖先的罪，承认他们曾抗拒我，对我不忠， ");
INSERT INTO cmn2006_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","以致我敌对他们，把他们流放到仇敌的土地上。如果他们能为此谦卑地向我谢罪，甘愿承受罪罚， ");
INSERT INTO cmn2006_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","那么，我就会记起我与雅各、以撒和亚伯拉罕所立的约，也会记起你们的这块土地。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","因为这块土地将被他们所废弃，它将在他们不存在的时候，在被置于荒废无人的期间补偿自己的安息年；而你们这些幸存的人要因背弃我的律法和诫命而承受罪罚。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","尽管如此，当他们滞留在仇敌土地上的期间，我仍然不摒弃他们，不厌恶他们；我不会违背我的约，把他们完全灭绝。因为我是主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","我要为了他们而守我与他们祖先所立的约；我曾在列国的注目之下把他们的祖先领出埃及，就是要做他们的上帝。我是主。” ");
INSERT INTO cmn2006_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","以上是主在西乃山藉摩西颁给以色列人的律法、条例和训诫。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“你晓喻以色列人∶‘如果有人为了某人的身价向主许愿， ");
INSERT INTO cmn2006_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","要遵守下列价值规定∶按照圣所的称量，每个二十至六十岁的成年男子为五十块银子， ");
INSERT INTO cmn2006_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","成年女子为三十块银子； ");
INSERT INTO cmn2006_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","每个五至二十岁的少男为二十块银子，少女为十块银子； ");
INSERT INTO cmn2006_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","每个一个月大至五岁的男孩为五块银子，女孩为三块银子， ");
INSERT INTO cmn2006_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","每个六十岁以上的老年男子为十五块银子，老年女子为十块银子。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","如果许愿的人很穷，拿不出这么多钱还愿，他就要把他许愿归给主的人带到祭司那里，由祭司按照他的经济能力另定相应的身价。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","‘如果许愿归给主的是可以献作祭物的动物，这动物就要归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","许愿人不可用其他动物替换，无论是以好换坏或以坏换好都不可以。如果做了替换，那么两只动物都要归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","如果许愿归给主的是不能作为祭物献给主的不洁净动物，许愿人就要把那动物带到祭司那里， ");
INSERT INTO cmn2006_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","由祭司按照动物的好坏确定价格，祭司定多少就是多少。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","如果许愿人打算赎回那动物，他必须付出赎价，再加上五分之一。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","‘如果有人把自己的房子献给主，祭司要根据房子的好坏确定价格，然后，房子就具有了祭司评定的房价。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","如果房主以后打算赎回房子，他必须付出房价，再加上五分之一，然后房子才重新归他所有。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","‘如果有人把自己田地的一部分献给主，地价要由那块土地的播种量决定，可撒二十升大麦种的田值五十块银子。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","如果田地是在禧年献给主的，地价就是祭司所确定的价格。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","如果田地是在禧年以后奉献的，祭司就要根据距下一个禧年的年数多少相应降低地价。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","田地的主人要赎回土地时必须付出地价，再加上五分之一。然后，田地才重新归他所有。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","如果他没有去赎那田地，却把它转卖给了别人，他就不再享有赎地的权利。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","到了下一个禧年，这地就要作为永久献给主的土地归圣，成为祭司的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","如果有人把买来的土地献给主，那地本不是他祖传的产业， ");
INSERT INTO cmn2006_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","祭司就要按照从那时起到下一个禧年之间的年数按比例确定地价，他必须当天付清地价的钱，作为圣物归给主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","到了禧年，这地要归还原主或他的继承人。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","所有的银价都以圣所的计量为准。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","‘不可向主献上头胎的牛或羊，因为它们本已归主所有。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","但如果献的是不洁净动物的头胎所生，就要按照祭司确定的价格再加五分之一赎回；如果不赎回，祭司就要按确定的价格把它卖掉。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","‘凡完全献给主的一切奉献，无论是人、动物还是祖传的田地，既不可出卖，也不可赎回。它们是主的至圣物，只属于主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","完全献给主的人必须处死，不可赎回。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","‘土地的出产，无论是地里的庄稼还是树上的果实，其中的十分之一要圣化归主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","如果有人想赎回，必须付出规定的价格再加五分之一。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","在畜群中每十只一组计数，牧人杖下数到的第十只都要圣化归主。 ");
INSERT INTO cmn2006_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","主人不可检查这些畜牲的好坏，也不可调换。如果调换了牲畜，那么这两只牲畜都要圣化归主，不得赎回。’” ");
INSERT INTO cmn2006_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","以上是主在西乃山吩咐摩西颁给以色列人的命令。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","以色列人离开埃及后的第二年的二月初一日，主在西乃旷野上的圣幕里对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“你要按照宗族和家族对全体以色列人进行人口普查，按他们的首领列出所有成年男子的名单。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","你和亚伦要把所有20岁以上能够作战的男丁按照军队的方式编制成营，登记在册。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","每个支派要有一个族长来协助你们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","以下是协助你们工作的族长的名单∶ 吕便支派－示丢珥的儿子以利蓿； ");
INSERT INTO cmn2006_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","西缅支派－苏利沙代的儿子示路蔑； ");
INSERT INTO cmn2006_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","犹大支派－亚米拿达的儿子拿顺； ");
INSERT INTO cmn2006_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","以萨迦支派－苏押的儿子拿坦业； ");
INSERT INTO cmn2006_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","西布伦支派－希伦的儿子以利押； ");
INSERT INTO cmn2006_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","约瑟的后代∶ 以法莲支派－亚米忽的儿子以利沙玛； 玛拿西支派－比大蓿的儿子迦玛列； ");
INSERT INTO cmn2006_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","便雅悯支派－基多尼的儿子亚比但； ");
INSERT INTO cmn2006_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","但支派－亚米沙代的儿子亚希以谢； ");
INSERT INTO cmn2006_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","亚设支派－俄兰的儿子帕结； ");
INSERT INTO cmn2006_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","迦得支派－丢珥的儿子以利雅萨； ");
INSERT INTO cmn2006_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","拿弗他利支派－以南的儿子亚希拉。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","这些是从会众中选出的人，他们是他们祖辈各支派的首领，也是以色列军中的统领。” ");
INSERT INTO cmn2006_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","于是，摩西和亚伦带领这些被指派的人在二月初一日召集全体会众，按照宗族和家族登记了他们的世系，所有20岁以上的男子都分别登记在册。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","46","摩西遵照主的命令，在西乃旷野对以色列人进行了人口调查，他们的总人数如下∶ 吕便支派－46500人； 西缅支派－59300人； 迦得支派－45650人； 犹大支派－74600人； 以萨迦支派－54400人； 西布伦支派－57400人； 约瑟的后代∶ 以法莲支派－40500人； 玛拿西支派－32200人； 便雅悯支派－35400人； 但支派－62700人； 亚设支派－41500人； 拿弗他利支派－53400人。 以上是摩西和亚伦以及以色列的十二名首领进行人口清查的结果。这十二名首领代表了以色列的十二个支派。所有20岁以上能上阵作战的以色列男子都按家族登记在册，共计603550人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","利未人没有跟其他以色列支派一起登记。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","因为主曾对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“你不可以清点利未支派，不可以象对其他以色列人那样普查他们的人数。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","你要派利未人管理圣幕和一切有关用具。他们要负责搬运和保管圣幕和其中的用具，他们的营地要建在圣幕的四周。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","圣幕起行的时候，利未人要负责拆卸；圣幕停下的时候，利未人要把它支搭起来。任何其他走近圣幕的人都必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","其他的以色列人都在各自所属的旗帜下按照军队的编制扎营， ");
INSERT INTO cmn2006_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","但利未人必须在圣幕的四周安营并守卫约柜，以免我的怒气降到以色列会众的身上。” ");
INSERT INTO cmn2006_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","以色列人按照主对摩西的命令一一行事。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“以色列人要在各自所属的旗帜下，按照自己家族的旗号，环绕圣幕扎营。营地要与圣幕保持一定距离。” ");
INSERT INTO cmn2006_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","东边是犹大营区的旗帜。犹大人的首领是亚米拿达的儿子拿顺， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","他的部下计有74600人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","与犹大人相邻的是以萨迦营。以萨迦人的首领是苏押的儿子拿坦业， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","他的部下计有54400人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","依次是西布伦营。西布伦人的首领是希伦的儿子以利押， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","他的部下计有57400人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","犹大营区总计有186400人。他们是全营的第一队。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","南边是吕便营区的旗帜。吕便人的首领是示丢珥的儿子以利蓿， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","他的部下计有46500人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","与吕便人相邻的是西缅营。西缅人的首领是苏利沙代的儿子示路蔑， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","他的部下计有59300人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","依次是迦得营。迦得人的首领是丢珥的儿子以利雅萨， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","他的部下计有45650人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","吕便营区总计有151450人，他们是全营的第二队。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","圣幕和利未营在前面两队与后面两队的中间。他们按照各自扎营的顺序和旗号的位置行进。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","西边是以法莲营区的旗帜。以法莲人的首领是亚米忽的儿子以利沙玛， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","他的部下计有40500人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","与以法莲人相邻的是玛拿西营。玛拿西人的首领是比大蓿的儿子迦玛列， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","他的部下计有32200人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","依次是便雅悯营。便雅悯人的首领是基多尼的儿子亚比但， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","他的部下计有35400人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","以法莲营区总计有108100人。他们是全营的第三队。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","北边是但营区的旗帜。但人的首领是亚米沙代的儿子亚希以谢， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","他的部下计有62700人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","与但人相邻的是亚设营。亚设人的首领是俄兰的儿子帕结， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","他的部下计有41500人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","依次是拿弗他利营。拿弗他利人的首领是以南的儿子亚希拉， ");
INSERT INTO cmn2006_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","他的部下计有53400人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","但营区总计有157600人，他们是全营的最后一队。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","以上是按照军队编制以营为单位登记在册的以色列人，总计有603550人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","按照主对摩西的吩咐，利未人没有统计在其他以色列人之内。 ");
INSERT INTO cmn2006_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","就这样，以色列人遵照主对摩西的命令一一行事。以上是他们按各自旗号安营的布署，也是他们按照宗族和家族世系行军的阵容。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","主在西乃山对摩西讲话的当时，摩西和亚伦的家世如下∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","亚伦有四个儿子∶长子是拿答，其次是亚比户、以利亚撒、以他玛。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","他们都受膏立为祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","但是，拿答和亚比户在西乃旷野里向主献未经认可的火的时候被击杀了，他们没有后代。以利亚撒和以他玛在亚伦还活着的时候就已经供职祭司了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“你把利未支派领出来，派他们随侍祭司亚伦的左右。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","利未人要负责亚伦和全体会众在圣幕前的礼仪事项，要承担圣幕的繁重劳务， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","要保管圣幕的所有器具，以此为全体以色列人供奉圣职。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","你要把利未人派给亚伦和他的儿子们，他们是从全体以色列人中选出来专一侍奉亚伦的人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","你要派亚伦和他的儿子们供职祭司，他们要履行祭司的一切职责。任何其他企图接近圣物的人都要处死。” ");
INSERT INTO cmn2006_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“瞧，我拣选了利未人代替全体以色列人的长子，利未人要归属于我， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","因为所有的头胎所生都属于我。当我在埃及击杀所有的头胎所生时，我就使以色列的所有头胎所生，包括每户人家的长子和所有牲畜的头胎，都已经圣化归主。因此，利未人要归属于我；我是主。” ");
INSERT INTO cmn2006_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","主在西乃旷野上对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“你要按照家族和宗族世系清点利未人，要把每一个出生一个月以上的男子都登记下来。” ");
INSERT INTO cmn2006_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","于是，摩西按照主的命令对利未人进行了登记。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","利未的儿子是∶革顺、哥辖和米拉利， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","他们是各自宗族的祖先。 革顺宗族包括立尼家族和示每家族； ");
INSERT INTO cmn2006_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","哥辖宗族包括暗兰家族、以斯哈家族、希伯伦家族和乌薛家族； ");
INSERT INTO cmn2006_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","米拉利宗族包括抹利家族和母示家族。 以上是利未支派的家族和宗族世系渊源。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","立尼家族和示每家族是革顺的后代，属革顺宗族。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","革顺宗族出生一个月以上的男子总计有7500人， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","他们的营地扎在圣幕的西侧，也就是圣幕的后边。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","革顺人的首领是拉伊勒的儿子以利雅萨， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","他们的职责是保管圣幕、罩帐、会幕入口处的门帘、 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","围绕圣幕和祭坛的院子的帷幔、院子的入口处的门帘以及所有应用的绳子，还包括移动圣幕的劳务。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","暗兰家族、以斯哈家族、希伯伦家族和乌薛家族是哥辖的后代，属哥辖宗族。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","哥辖宗族出生一个月以上的男子总计有8300人， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","他们的营地扎在圣幕的南侧。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","哥辖人的首领是乌薛的儿子以利撒反， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","他们的职责是守护约柜，保管供桌、灯台、祭坛以及祭司在圣所执礼时所用的用具和圣所的门帘，还包括一切与这些有关的劳务。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","利未人的总首领是祭司亚伦的儿子以利亚撒，他负责监察守护圣所的人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","抹利家族和母示家族是米拉利的后代，属米拉利宗族。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","米拉利宗族出生一个月以上的男子总计有6200人， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","他们的营地扎在圣幕的北侧。米拉利人的首领是亚比亥的儿子苏列， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","他们的职责是保管圣幕的骨架、横木、柱子、底座，以及所有有关的器具，他们也要承担与这些有关的所有劳务， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","还要负责保管围院子的柱子、它们的底座以及橛子和绳子。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","摩西、亚伦和亚伦的儿子们的营地扎在圣幕的东侧，也就是圣幕的正前方。他们负有为全体以色列人守护圣处的职责。任何走近圣物的其他人都要被处死。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","摩西和亚伦遵照主的命令，对所有出生一个月以上的利未人按照宗族世系进行了登记，共计有22000人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","主对摩西说∶“你把所有出生一个月以上的以色列人长子登记下来，列出名单。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","我是主，利未人要归属于我，以代替以色列人的长子。利未人的牲畜也要用以代替以色列人牲畜的头胎所生。” ");
INSERT INTO cmn2006_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","于是，摩西遵照主的命令对所有以色列人的长子进行了登记。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","按照姓名登记在册的出生一个月以上的以色列人长子总计有22273人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“利未人要归属于我，以代替所有以色列人的长子，利未人的牲畜也要归属于我，以代替以色列人牲畜的头胎所生。利未人是属于我的，我是主。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","以色列人的长子比利未人多273人，你必须赎回他们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","按照圣所的秤称量，你要为每个人付五块银子。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","你要把银子交给亚伦和他的儿子们以赎回这273人。” ");
INSERT INTO cmn2006_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","于是，摩西用银子赎回了比利未人多出的这些人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","他按照圣所的称量，向以色列人的长子收取了1365块银子， ");
INSERT INTO cmn2006_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","并遵照主的命令交给了亚伦和他的儿子们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“你们要按照家族和宗族世系对利未人中的哥辖人进行人口普查。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","凡30岁至50岁之间适于在会幕中执礼的男人，都要登记在册。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","哥辖人的职责是搬运圣幕内的至圣物。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","当以色列人拔营起身的时候，亚伦和他的儿子们必须进入圣幕，取下约柜前的帷幔，盖在约柜上面。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","他们必须在上面盖上一块精美的皮料，再蒙上一块纯兰色的布，然后把约柜的杠子安好。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“他们要在圣桌上铺上一块兰布，把盘子、勺子、奠酒用的壶和杯陈列在桌子上。供饼要常年设在圣桌上， ");
INSERT INTO cmn2006_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","然后，用一块红布蒙在这些物品上，再盖上一块精美的皮料，再把供桌的杠子安好。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“他们要用一块兰布蒙住灯台、灯、灯花剪、蜡花盘和所有盛灯油的容器， ");
INSERT INTO cmn2006_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","然后，把灯台和所有应用器具用精美的皮料包好，放到抬架上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“他们要用一块兰布蒙在金祭坛上，再用精美的皮料把它盖住，然后，把杠子安好。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“他们要用兰布把圣所里的所有应用器具包起来，再用精美的皮料盖好，放到抬架上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“他们要除去祭坛上的灰烬，用紫色的布把祭坛蒙好。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","然后，把祭坛的所有应用器具－火盘、叉子、火铲、火盆，放在祭坛上，用精美的皮料把它们盖住，再把祭坛的杠子安好。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“拔营之前，等到亚伦和他的儿子们把圣物和所有器具包好之后，哥辖人才能进来搬运这些东西，以免因为触摸圣物而致死。哥辖人的职责是搬运圣幕内的所有这些器具， ");
INSERT INTO cmn2006_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","亚伦的儿子以利亚撒负责看守整个圣幕，以及香、灯油、日常的素祭、圣膏油，和圣幕内的全部圣物及其用具。” ");
INSERT INTO cmn2006_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“不要让哥辖宗族因接触或看见圣物而被从利未人中灭绝。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","当他们走近至圣物的时候，亚伦和他的儿子们要进去给他们每个人指派应该做的工作和要搬运的东西， ");
INSERT INTO cmn2006_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","使他们完全见不到圣物，免得他们被击杀。” ");
INSERT INTO cmn2006_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“你也要按照家族和宗族世系对革顺人进行人口普查。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","凡30岁至50岁之间适于在会幕中执礼的男人，都要登记在册。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“革顺人的职责是整装和搬运以下物品∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","圣幕的帷幔、会幕、幕顶、盖在幕顶上的精美的皮料、会幕的门帘、 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","围院子的帷幔、院子的门帘（院子是用来围圣幕和祭坛的）、绳子，以及有关的工具和应用器具；他们要承担与这些有关的所有劳务。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","革顺人所有的工作，即整装和搬运都必须在亚伦和他的儿子们的指导下进行。你要让他们负责保管好他们所搬运的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","以上是革顺人在圣幕中的职责。他们在亚伦的儿子以他玛的指导下工作。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“你要按照家族和宗族世系对米拉利人进行人口普查。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","凡30岁至50岁之间适于在会幕中执礼的男人，都要登记在册。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","米拉利人的职责是保管和搬运会幕的骨架、横木、柱子、底座、 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","院子四周的柱子及其底座、支搭帐幕的橛子和绳子，以及所有的应用器具。要指定每个人所保管和搬运的物品，并记下物品的名称。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","以上是米拉利人在圣幕中的职责。他们在祭司亚伦的儿子以他玛的指导下工作。” ");
INSERT INTO cmn2006_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","摩西、亚伦和会众的首领们按照家族和宗族世系对哥辖人进行了登记。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","凡30岁至50岁之间有资格在圣幕中执礼的男人都登记在册， ");
INSERT INTO cmn2006_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","总计有2750人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","这是哥辖宗族中由摩西和亚伦遵照主的命令所登记的可以在圣幕中执礼的人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","革顺人按照家族和宗族世系进行了登记。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","凡30岁至50岁之间有资格在圣幕中执礼的男人都登记在册， ");
INSERT INTO cmn2006_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","总计有2630人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","这是革顺宗族中由摩西和亚伦遵照主的命令所登记的可以在圣幕中执礼的人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","米拉利人按照家族和宗族世系进行了登记。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","凡30岁至50岁之间有资格在圣幕中执礼的男人都登记在册， ");
INSERT INTO cmn2006_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","总计有3200人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","这是米拉利宗族中由摩西和亚伦遵照主的命令所登记的可以在圣幕中执礼的人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","摩西、亚伦和以色列的众首领按照家族和宗族世系对利未人进行了登记。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","凡30岁至50岁之间有资格做与会幕有关的工作和搬运物品的男人都登记在册， ");
INSERT INTO cmn2006_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","总计有8580人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","摩西遵照主的命令，对所有的利未人进行了清点登记。每个利未人各司其责，专一负责一定的整装和搬运工作。这是主的意旨。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","主吩咐摩西∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“你要命令以色列人，把患有严重皮肤病和遗漏症的人以及任何因触碰尸体而不洁净的人都赶出营去。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","要把不洁净的男女都赶出营去，使他们不致玷污他们的营地，因为我就住在他们中间。” ");
INSERT INTO cmn2006_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","以色列人遵照主对摩西的命令行事，把不洁净的人赶出了营地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“你晓喻以色列人∶无论男女，如果损害他人，就是对主不忠，就有了罪。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","这类人必须承认自己所犯的罪，除如数赔还之外，还要再加上五分之一，赔还给他所损害的人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","如果那人已经死了，又没有可以接收赔偿的近亲，那么所赔还的钱就归于主，由祭司使用。此外，这人还要带一只公羊来，由祭司用以为他赎罪。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","以色列人带到祭司那里的神圣奉献都归祭司所有。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","也就是说，人们的神圣奉献都归祭司所有。不论人们带到祭司那里的是什么，都要归那祭司所有。” ");
INSERT INTO cmn2006_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“你晓喻以色列人∶假如妻子对丈夫不忠， ");
INSERT INTO cmn2006_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","与其他人发生了性关系，她的丈夫也没有察觉到，因为既没有证人，又没有当场捉奸，她自己又严守玷污了自己的秘密。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","在这种情形下，也许是丈夫怀疑妻子而妻子确实不贞，也许是丈夫怀疑妻子而妻子并未不贞。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","这时，丈夫必须把妻子带到祭司面前，同时带去两升大麦粉作为为妻子献的祭物。他不可以在上面浇油，也不可加乳香，因为这是疑忌的素祭，是彰显她的罪孽的素祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“祭司要把那女人领上前来，让她站在主的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","祭司要把圣水盛在瓦器里，再从圣幕的地板上取一点尘土，撒在水里。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","然后，祭司要叫那女人披散头发站在主的面前，把疑忌的丈夫所献的素祭，就是那彰显罪孽的素祭，放到她的手中，祭司手里要捧着能招致诅咒的苦水。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“祭司要让那女人发誓，对她说∶‘如果你没有与人通奸，没有在婚外堕落而玷污你自己，那么你就不会遭到这苦水带来的诅咒。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","但是，如果你确曾在婚外和别的男人通奸，玷污了你自己， ");
INSERT INTO cmn2006_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","那么，愿主使你的同胞用你的名字诅咒他人，愿主使你大腿消瘦，肚腹胀大， ");
INSERT INTO cmn2006_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","愿这水把诅咒带进你的身体，使你肚腹胀大，大腿消瘦。’那女人要回答∶‘阿们！阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“然后，祭司要把这些诅咒的话写在一卷书卷里，再用苦水碗里的水把这些字洗在苦水里。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","那女人要把这能招致诅咒的苦水喝下去，这苦水可能使她痛苦异常。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“在喝苦水之前，祭司要把那女人手中的素祭拿到祭坛前，在主的面前摇一摇， ");
INSERT INTO cmn2006_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","然后抓一把作为祭品的象征，放在祭坛上烧化。随后，祭司要让那女人喝下苦水。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","她喝下苦水后，如果她确曾背叛丈夫玷污过自己，这能招致诅咒的苦水将引起剧痛，她的肚腹要胀大，大腿要消瘦，她将在她的同胞中成为受诅咒的示例。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","如果她不曾玷污自己，她就不会遭到诅咒，仍然能够生育。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“这是有关猜忌一个女人在婚外堕落、玷污自己的法律。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","当丈夫猜疑妻子不贞时，他要把她领到主的面前，祭司要对她执行这条法律。 ");
INSERT INTO cmn2006_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","这样，丈夫就免于受罚，而堕落的女人要承当罪责。” ");
INSERT INTO cmn2006_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“你晓喻以色列人∶无论男女，如果许下做拿细耳人的特别愿，把自己献给主， ");
INSERT INTO cmn2006_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","就必须戒除酒及酒精类饮料，也不可喝酒类酿制的醋，不可喝葡萄汁，不可吃新鲜的葡萄或葡萄干。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","在做拿细耳人期间，不可吃葡萄做的任何食物，即使葡萄籽和葡萄皮也不可吃。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“在许愿做拿细耳人的整个期间，他是圣洁的，不许剃头；直到他把自己奉献给主的期满之前，他得任由头发和胡须长长。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“在把自己献给主的全部期间，他不可以到停放死人的地方去。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","即使是他的父亲或母亲或兄弟姐妹死了，他也不可以去，以免因此而不洁净，因为他的头发－献身给上帝的标志，就在他的头上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","在做拿细耳人的整个期间，他是圣化归主的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“如果在他作拿细耳人期间，身边突然有人死了，玷污了他已经圣化归上帝的头发，他就要在第七天剃掉头发和胡须；这是使他洁净的日子。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","第八天，他要带两只雏鸽或斑鸠，到主的圣幕门口，交给祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","祭司要献一只作赎罪祭，一只作烧化祭，为他行洁净礼，因为他受了死尸的玷污。当天，他要使自己的头发重新归圣， ");
INSERT INTO cmn2006_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","再次作为拿细耳人献身给主，并且要带一只一岁大的小羊来作赎愆祭。但以前的日子不能再算，因为他圣洁的头发已经被玷污了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“拿细耳人离俗的日期满了，要举行如下的礼仪∶他要到圣幕门口， ");
INSERT INTO cmn2006_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","把三只没有残疾的羊献给主；一只一岁大的没有残疾的公羊羔献作烧化祭，一只一岁大的没有残疾的母羊羔献作赎罪祭，一只没有残疾的公绵羊献作平安祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","此外，还要献上一篮无酵饼，包括用油调和上等面粉制作的无酵饼和涂油的无酵薄饼，以及常例的素祭和奠祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“祭司要把那人的赎罪祭和烧化祭献给主， ");
INSERT INTO cmn2006_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","而作为平安祭的公绵羊则必须与那篮无酵饼同时献上，还要献上常例的素祭和奠祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","然后，拿细耳人要在圣幕门口剃去离俗期间的头发，把它放在平安祭下的火中烧掉。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","拿细耳人剃完头发以后，祭司要取已煮熟的公绵羊的一条前腿，再从篮子里拿一块无酵饼和一块无酵薄饼，一起放到拿细耳人的手中。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","祭司要拿这些东西在主面前摇一下，作为摇祭献给主。这些东西与作为摇祭的胸肉和作为举祭的羊腿同为圣物归给祭司，然后，拿细耳人就可以喝酒了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","这是许愿做拿细耳人的人应该遵守的条例。除了他力所能及的其他东西之外，这是他为献身主而奉献的供物，他必须履行诺言。” ");
INSERT INTO cmn2006_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“你晓喻亚伦和他的儿子们∶‘你们要这样为以色列人祝福∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","愿主赐福给你，保佑你； ");
INSERT INTO cmn2006_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","愿主以慈爱待你，赐恩给你； ");
INSERT INTO cmn2006_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","愿主眷顾你，赐平安给你。’ ");
INSERT INTO cmn2006_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","这样，亚伦和他的儿子们就可以用我的名字为以色列人祝福，而我也会赐福给他们。” ");
INSERT INTO cmn2006_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","摩西立好圣幕的当天，他用油膏了圣幕及其中所有的设施和祭坛及其所有的应用器具，使它们圣化归主。他给它们膏完了油并圣化归主后， ");
INSERT INTO cmn2006_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","曾经主持人口普查的以色列的首领们，各家族的族长及各支派的首领们，都带来了供物。 ");
INSERT INTO cmn2006_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","他们向主献上六辆篷车和十二头公牛。每人一头公牛，每两人一辆篷车，他们把牛和车都带到圣幕前面。 ");
INSERT INTO cmn2006_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“你收下这些礼物，供圣幕的搬运劳务之用，把它们按照利未人的职责分派给他们。” ");
INSERT INTO cmn2006_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","于是，摩西收下了牛和车，并把它们分派给了利未人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","按工作所需，两辆车和四头牛给了革顺人； ");
INSERT INTO cmn2006_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","另四辆车和八头牛给了米拉利人。他们都在祭司亚伦的儿子以他玛的指挥下工作。 ");
INSERT INTO cmn2006_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","摩西没有给哥辖人车和牛，因为他们负责搬运的圣物必须用肩膀扛抬。 ");
INSERT INTO cmn2006_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","用圣油膏祭坛使它归圣的那天，首领们都在坛前献上各自的供物。 ");
INSERT INTO cmn2006_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","主对摩西说∶“让首领们为祭坛归圣献上他们的供物。每天要有一个首领来献供物。” ");
INSERT INTO cmn2006_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","第一天，由犹大支派的首领、亚米拿达的儿子拿顺奉献。第二天，由以萨迦支派的首领、苏押的儿子拿坦业奉献。第三天，由西布伦支派的首领、希伦的儿子以利押奉献。第四天，由吕便支派的首领、示丢珥的儿子以利蓿奉献。第五天，由西缅支派的首领、苏利沙代的儿子示路蔑奉献。第六天，由迦得支派的首领、丢珥的儿子以利雅萨奉献。第七天，由以法莲支派的首领、亚米忽的儿子以利沙玛奉献。第八天，由玛拿西支派的首领、比大蓿的儿子迦玛列奉献。第九天，由便雅悯支派的首领、基多尼的儿子亚比但奉献。第十天，由但支派的首领、亚米沙代的儿子亚希以谢奉献。第十一天，由亚设支派的首领、俄兰的儿子帕结奉献。第十二天，由拿弗他利支派的首领、以南的儿子亚希拉奉献。 每个首领所献的礼物完全相同∶一个银盘，重1.5公斤；一个银碗，重0.8公斤；均以圣所的称量为准；里面盛满用油调和的上等面粉作为素祭；一个金盂，重115克，里面装满着香；一头小公牛、一只公绵羊、一只一岁大的小公羊作烧化祭；一只公山羊作赎罪祭；两头公牛、五只公绵羊、五只公山羊、五只一岁大的小公羊作平安祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","为祭坛膏油归圣时以色列首领们所献的供物总数如下∶十二个银盘和十二个银碗，共重27.6公斤；十二个金盂，共重13.2公斤，里面都盛满着香；十二头公牛、十二只公绵羊、十二只一岁大的小公羊与所要求的素祭一同献作烧化祭；十二只公山羊献作赎罪祭；二十四头公牛、六十只公绵羊、六十只公山羊、六十只一岁大的小公羊献作平安祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","当摩西进入圣幕向上帝说话的时候，他听见从约柜的施恩座之上，在两个基路伯之间，传出对他说话的声音，那是上帝在对他讲话。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“你要告诉亚伦∶‘点灯的时候，七盏灯的灯光都要向灯台前照射。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","亚伦遵照主对摩西的吩咐行事。他把灯朝着灯台前面的方向安放，使灯光向前照射。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","按照主对摩西指示的样式，灯台是这样制作的：整个灯台，从底座直至上面的花朵，都用金子锤制而成。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“你把利未人跟其余的以色列人分离开来，洁净他们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","洁净的方法是这样的∶把洁净水洒在他们身上，叫他们剃刮全身，洗净衣服。这样，他们就洁净了自己。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","然后，他们必须从牛群中取一只公牛犊，带上用油调和的上等面粉作为同献的素祭，而你必须从牛群中另取一头公牛犊作为赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","然后，你要把利未人带到圣幕前，并召集以色列全体会众。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","利未人被奉献到我的面前之后，以色列人要把手按在他们的头上； ");
INSERT INTO cmn2006_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","亚伦要把他们作为以色列人的摇祭献在我的面前，这样，利未人就可以侍奉我了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“利未人要把手按在那两头公牛的头上，这两头公牛一头作为赎罪祭，另一头作为烧化祭献给主，它们将赎去利未人的罪。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","然后，你让利未人站到亚伦和他的儿子们的面前，把他们作为摇祭献给我。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","这样，你就把利未人从以色列人当中分离了出来，利未人要属于我。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“你把利未人洁净并作为摇祭奉献之后，他们就有资格在圣幕里执礼了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","他们是以色列人中完全归属于我的人，我拣选他们以代替以色列人的所有长子。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","我在埃及击杀所有的头胎所生的那一天，已经把以色列人的所有长子和所有牲畜的头胎分别圣化归我， ");
INSERT INTO cmn2006_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","现在，我要拣选利未人代替以色列人的所有长子。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","我要把以色列人中的利未人完全交给亚伦和他的儿子们，让他们为以色列人在会幕中执礼，为他们赎罪，以免他们走近圣处时遭到灾祸。” ");
INSERT INTO cmn2006_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","摩西、亚伦和以色列的全体会众遵照主对摩西的吩咐对利未人行事。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","利未人洁净了自己，洗净了衣服。亚伦把他们作为摇祭献给了主，又为他们行了洁净礼。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","主对摩西关于利未人的命令被一一照办。之后，利未人就在亚伦和他的儿子们的指导下在圣幕中执礼了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“每一个25岁以上的利未人男子都要为会幕效力， ");
INSERT INTO cmn2006_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","50岁时退休，不再做重体力劳务， ");
INSERT INTO cmn2006_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","但他可以协助他的同胞看守会幕。你要这样分配利未人的职责。这是有关利未人的制度。” ");
INSERT INTO cmn2006_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","以色列人离开埃及后的第二年的正月，主在西乃旷野对摩西说： ");
INSERT INTO cmn2006_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“以色列人要在规定的日期守逾越节。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","你们要在本月十四日的黄昏，遵照逾越节的所有规定和条例守节。” ");
INSERT INTO cmn2006_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","于是，摩西吩咐以色列人守逾越节。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","他们在正月十四日黄昏时分，在西乃旷野上遵照主对摩西的所有训诫守逾越节。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","但是，一些人因为接触了死尸而不洁净，不能在那天守逾越节。当天，他们找到摩西和亚伦， ");
INSERT INTO cmn2006_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","对摩西说∶“我们因为接触了死尸而不洁净，可是为什么不准我们与其他的以色列人一起在指定的日子向主奉献呢？” ");
INSERT INTO cmn2006_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","摩西对他们说∶“你们等候一下，让我听一下主关于你们的命令。” ");
INSERT INTO cmn2006_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“你告诉以色列人∶‘你们或你们的后代如果有人因接触了死尸而不洁净，或是远行在外，他们仍然可以守逾越节。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","他们应该在第二个月的十四日的黄昏时分守节。他们也要吃逾越节羊羔、无酵饼和苦菜， ");
INSERT INTO cmn2006_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","不可把食物留到第二天早晨，不可折断羊的骨头。要遵行守逾越节的一切律例。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","但是，如果有人是洁净的，也没有出外旅行，却不守逾越节，那么这个人就要从我的子民中除名，因为他没有在规定的日期向主奉献，他必承当自己的罪。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","如果寄居的外侨要守逾越节，他必须遵守逾越节的所有规定和条例。无论本地人还是外侨，遵守的律法是相同的。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","圣幕立起的当天，云彩就笼罩了圣幕，也就是存放约柜的帐幕。入夜，笼罩在圣幕上的云彩形状如火，直到清晨。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","天天如此。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","一旦云彩从圣幕上收上去，以色列人就启程出发；云彩一停住，以色列人就扎营不动。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","以色列人按照主的指示决定行止，云彩在圣幕上停多久，以色列人就安营多久， ");
INSERT INTO cmn2006_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","即使云彩在圣幕上停留很长时间，他们也遵从主的命令，安营不动。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","有时云彩在圣幕上只停留几天，他们就遵照主的指示停留几天； ");
INSERT INTO cmn2006_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","有时云彩在圣幕上仅仅停留一夜，清晨就收了上去，他们就随之起身。无论白天黑夜，只要云彩收上去，以色列人就拔营启程。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","无论是两天，一个月，或是更长的时间，只要云彩还停留在圣幕上，以色列人就安营不动，一旦云彩收上去，人们就启程。 ");
INSERT INTO cmn2006_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","他们遵从主藉摩西颁布的命令，按照主的指示扎营，也按照主的指示起行。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“你要用银锤出两只号筒，作为召集民众和通知拔营之用。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","两只号筒同时吹出长音的时候，全体会众要集合在圣幕门口，站到你的面前； ");
INSERT INTO cmn2006_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","如果只吹响一支号筒，以色列各宗族的首领们要集合到你的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“如果吹出的是短音，东边的营起行； ");
INSERT INTO cmn2006_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","第二次吹出短音的时候，南边的营起行；短音是出发的信号。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","但你召集会众的时候，一定要吹长音，不可吹短音。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","亚伦那些供职祭司的子孙负责吹号，这是你们世世代代永远要遵守的定例。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“当你们在自己的国土上抗击来犯的仇敌的时候，你们要用这两支号同时吹出短音，这样，主－你们的上帝就会记起你们，他会把你们从仇敌的手里救出来。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","在欢庆的日子－新月节和其他节日，你们献上烧化祭和平安祭的时候，要吹响号筒。这是上帝记念你们的特有方式；我是主，是你们的上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","以色列人离开埃及的第二年的二月二十日，停留在圣幕上面的云彩收了上去。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","于是，以色列人开始了他们的旅程，离开了西乃旷野。云彩来到巴兰旷野，停在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","这是他们遵照主藉摩西的吩咐，首次拔营起行。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","犹大营的队伍首先出发；犹大支派的指挥官是亚米拿达的儿子拿顺， ");
INSERT INTO cmn2006_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","以萨迦支派的指挥官是苏押的儿子拿坦业， ");
INSERT INTO cmn2006_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","西布伦支派的指挥官是希伦的儿子以利押。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","随后，拆下圣幕，由革顺和米拉利两宗族的人搬运上路。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","之后，吕便营地的各营依次出发。吕便支派的指挥官是示丢珥的儿子以利蓿， ");
INSERT INTO cmn2006_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","西缅支派的指挥官是苏利沙代的儿子示路蔑； ");
INSERT INTO cmn2006_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","迦得支派的指挥官是丢珥的儿子以利雅撒。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","然后，哥辖宗族的人扛抬着圣物出发。在他们到达新营地之前，圣幕要重新立好。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","之后，以法莲营地的各营依次出发。以法莲支派的指挥官是亚米忽的儿子以利沙玛， ");
INSERT INTO cmn2006_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","玛拿西支派的指挥官是比大蓿的儿子迦玛列， ");
INSERT INTO cmn2006_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","便雅悯支派的指挥官是基多尼的儿子亚比但。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","最后出发的是但营地的各营。他们是全营的后卫。但支派的指挥官是亚米沙代的儿子亚希以谢， ");
INSERT INTO cmn2006_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","亚设支派的指挥官是俄兰的儿子帕结， ");
INSERT INTO cmn2006_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","拿弗他利支派的指挥官是以南的儿子亚希拉。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","以上是以色列人各营依次行进的次序。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","以色列人启程后，摩西对他的岳父、米甸人流珥的儿子何巴说∶“我们现在要到主应许给我们的地方去。跟我们一起去吧，我们一定会好好待你，因为主已经应许要赐福给以色列人。” ");
INSERT INTO cmn2006_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","何巴答道∶“我不愿去，我要回我的故乡和本族人那里去。” ");
INSERT INTO cmn2006_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","摩西说∶“请不要离开我们。你熟悉旷野的情况，知道哪里可以安营，可以作我们的向导。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","如果你肯和我们一起去，我们一定与你共享主将赐给我们的一切恩惠。” ");
INSERT INTO cmn2006_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","以色列人离开了主的圣山，行进了三天，主的约柜一直在他们的前面，为他们寻找安营的地方。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","每天他们拔营启程的时候，主的云彩伴随在他们的上方。 ");
INSERT INTO cmn2006_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","每当约柜出营的时候，摩西就要说∶ “主啊，求你兴起！ 愿你的仇敌四散， 愿恨你的人从你面前逃遁！” ");
INSERT INTO cmn2006_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","每当约柜安顿下来时，摩西就要说∶ “主啊，求你回到以色列的千千万万人中间来！” ");
INSERT INTO cmn2006_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","民众在主的面前抱怨；主听见了，发了怒，降火在民众的中间，烧毁了营地外围的一部分。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","民众向摩西求救，摩西祷告主，火就熄了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","于是，他们把那地方叫做他备拉，因为主的火曾在那里在他们中间燃烧。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","民众中间爱闹事的人贪图口欲，以色列人也随声哄闹。他们说∶“谁能给我们肉吃呢？ ");
INSERT INTO cmn2006_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","记得在埃及的时候，不用花钱就能吃上鱼，还有黄瓜、西瓜、韭菜、洋葱、大蒜， ");
INSERT INTO cmn2006_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","而现在除了吗哪什么都没有！我们的身体都快枯干了！” ");
INSERT INTO cmn2006_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","（吗哪的形状象胡荽子，又象珍珠。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","每天晚上跟露水一同落在营地上。人们出去把它采回来，用磨磨细或用臼捣成粉，然后煮一煮，做成饼。它的味道象用油烤成的饼。） ");
INSERT INTO cmn2006_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","摩西听到民众都在各自的帐篷门口哭叫。主动了怒，摩西也心烦意乱。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","他对主说∶“你为什么把这些烦恼的事都交给你的仆人？你为什么对我不满，把这管理民众的重担加在我的身上？ ");
INSERT INTO cmn2006_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","难道这些百姓是我怀胎养育的吗？难道是我生了他们，以致于你要对我说∶‘把他们象婴儿一样抱在怀里，’一直抱到你应许给他们祖先的地方吗？ ");
INSERT INTO cmn2006_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","他们在我面前哭闹，说∶‘给我们肉吃！’我到哪里去找肉给这么多的人吃呢？ ");
INSERT INTO cmn2006_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","我一个人照看不了这么多人，这太难了！ ");
INSERT INTO cmn2006_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","如果你还是叫我做这些事，求你可怜我，不如把我杀了，也好让我不再烦恼。” ");
INSERT INTO cmn2006_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","主对摩西说∶“你为我从以色列的长老中召集七十人，他们是你所了解的民众的长者和首领，你领他们到会幕来，和你一同站在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","我要在那里降临，对你讲话，也要把降于你身上的灵分赐给他们，使他们与你共当管理民众的重任，这样，你就不致独力承担了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","你晓喻民众，要他们自洁，预备明天吃肉。因为他们在我的面前哭号，说∶‘谁能给我们肉吃？还不如在埃及好呢！’现在，主要给你们肉，你们要有肉吃了！ ");
INSERT INTO cmn2006_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","你们不是吃一天、二天、五天、十天或二十天， ");
INSERT INTO cmn2006_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","而是要吃整整一个月！直到肉从你们的鼻孔喷出来，一看到肉就恶心为止。这件事一定要发生，因为你们厌弃了住在你们中间的主，你们在他的面前哭号，说∶‘我们为什么要离开埃及呢？’” ");
INSERT INTO cmn2006_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","摩西对主说∶“和我在一起的民众有六十万人，而你竟说要给他们吃整整一个月的肉！ ");
INSERT INTO cmn2006_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","即便把所有的牛羊都宰掉，把海里的鱼都捕上来，也不够他们吃！” ");
INSERT INTO cmn2006_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","主对摩西说∶“难道主的能力是有止境的吗？你就要看到我的话能不能应验！” ");
INSERT INTO cmn2006_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","摩西走出圣幕，把主的话告诉了民众，又从以色列的长老中召集了七十人，叫他们站在圣幕的周围。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","主在云中降临，对摩西讲话，又把降在摩西身上的灵取出一部分，分赐给七十名长老。当灵降在他们身上的时候，他们就开始说预言，但他们没有长久预言的能力。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","其中有两个长老依然留在营里，一个叫伊利达，一个叫米达，他们没有到圣幕那里去。主的灵降在他们身上，于是，他们在营里象先知一样说起预言来。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","一个年轻人跑来告诉摩西∶“伊利达和米达在营里说预言哪！” ");
INSERT INTO cmn2006_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","摩西的助手嫩的儿子约书亚是摩西所拣选的人，他对摩西说∶“我主，请制止他们！” ");
INSERT INTO cmn2006_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","摩西对他说∶“你是为我的缘故在妒嫉吧？我情愿让主的子民都成为先知，愿主的灵降在所有人的身上。” ");
INSERT INTO cmn2006_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","随后，摩西和以色列的众长老返回营地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","主刮起风，把鹌鹑从海上吹过来，散落在营地四周。每一边有一天的路程那么长，把营地团团围住。落在地面上的鹌鹑足有一米厚。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","民众整整捉了一天一夜，第二天又捉了一整天，每人至少捉到2200升。他们把鹌鹑摊放在营地的周围。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","当他们还在大吃大嚼的时候，主对民众动了怒，在他们中间降下了可怕的瘟疫。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","因此，他们把那个地方叫做基博罗哈他瓦，因为他们在那里埋葬了贪欲的人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","民众从那里行进到哈洗禄，在那里扎下营地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","摩西娶了一个古实女子为妻，米利暗和亚伦因此对他不满， ");
INSERT INTO cmn2006_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","抨击他说∶“难道主只藉摩西讲话？他不是也藉我们传达旨意吗？”主听到了这些话。 ");
INSERT INTO cmn2006_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","摩西为人极其谦和，是当时世上最谦和的人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","主突然对摩西、亚伦和米利暗说∶“你们三个人到圣幕那里去。”三个人就去了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","主在云柱中降临到圣幕门口，呼叫说∶“亚伦！米利暗！”两人走上前来。 ");
INSERT INTO cmn2006_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","主说∶“你们听着！如果你们中间有主的先知，我会在异象中向他们启示我的意志，在梦中对他们讲话， ");
INSERT INTO cmn2006_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","而我对我的仆人摩西却不是这样。我把我的家业交托给他， ");
INSERT INTO cmn2006_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","面对面地对他说话，清清楚楚，不用隐语。他甚至看见过我的形象。你们怎么敢妄论我的仆人摩西？” ");
INSERT INTO cmn2006_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","主怀怒而去。 ");
INSERT INTO cmn2006_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","当云彩从圣幕上收上去的时候，米利暗的皮肤上突然长出象雪一样的白鳞片。亚伦回头看见米利暗长了皮肤病， ");
INSERT INTO cmn2006_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","对摩西说∶“我主啊，求你不要因我们的愚昧和罪孽惩罚我们吧！ ");
INSERT INTO cmn2006_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","不要让米利暗象一出母腹就烂掉一半的死胎。” ");
INSERT INTO cmn2006_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","摩西向主呼求，说∶“上帝啊，求你医治她！” ");
INSERT INTO cmn2006_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","主对摩西说∶“如果她的父亲唾弃她，难道她不该承受七天的羞辱吗？要把她在营外关锁七天，然后才可以领她回来。” ");
INSERT INTO cmn2006_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","于是，米利暗在营外被关锁了七天。在这期间，以色列人安营不动，直到把米利暗领了回来。 ");
INSERT INTO cmn2006_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","之后，以色列人离开了哈洗禄，来到巴兰旷野安下营地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","2","主对摩西说∶“你从十二支派中各选一名首领，派他们去侦察迦南地，那就是我要赐给以色列人的土地。” ");
INSERT INTO cmn2006_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","摩西遵照主的命令，从巴兰旷野派出十二名以色列首领。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","15","他们的名字如下∶ 吕便支派∶撒刻的儿子沙母亚； 西缅支派∶何利的儿子沙法； 犹大支派∶耶孚尼的儿子迦勒； 以萨迦支派∶约色的儿子以迦； 以法莲支派∶嫩的儿子何西阿； 便雅悯支派∶拉孚的儿子帕提； 西布伦支派∶梭底的儿子迦叠； 玛拿西支派（约瑟支派）∶稣西的儿子迦底； 但支派∶基玛利的儿子亚米利； 亚设支派∶米迦勒的儿子西帖； 拿弗他利支派∶缚西的儿子拿比； 迦得支派∶玛基的儿子臼利。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","以上是摩西派去侦察迦南地的人。（摩西把嫩的儿子何西阿改名为约书亚）。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","摩西派他们去侦察迦南地的时候吩咐他们∶“你们从这里北上，进入南地，然后进入山区。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","你们要查看那里的情况，包括民力的强弱，人数的多寡， ");
INSERT INTO cmn2006_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","土地的好坏，以及城市的设防情况， ");
INSERT INTO cmn2006_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","还要查看一下土地是不是肥沃，以及有没有树木森林。你们要尽你们所能带一些那里出产的果子回来。”（当时正是葡萄初熟的季节）。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","于是，他们出发北上，从寻旷野一直侦察到哈马隘口附近的利合。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","他们首先进入南地，来到希伯伦。那里住着亚希幔人、示筛人和挞买人，他们是亚衲人的后裔（希伯伦城比埃及的锁安城早建七年）。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","随后，他们来到以实各谷，在那里砍下一截挂着一大串葡萄的葡萄枝，两个人用杠子抬着，又带了一些石榴和无花果。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","因为以色列人在那里砍下一大串葡萄，因此这个地方叫做以实各谷。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","他们在迦南地侦察了四十天后， ");
INSERT INTO cmn2006_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","返回巴兰旷野的加低斯，向摩西、亚伦和以色列的全体会众报告侦察的结果，同时把带回来的果子给大家看。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","他们向摩西报告说∶“我们到了你派我们去侦察的那地方，那里果然是流奶与蜜的富饶之地。这就是那里出产的果子。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","但是，那里的居民很强悍，他们的城很大，设防严密；我们还在那里见到了亚衲人＊。 ");
INSERT INTO cmn2006_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","亚玛力人住在南地，赫人、耶布斯人和亚摩利人住在山区，迦南人住在地中海沿岸和约旦河边。” ");
INSERT INTO cmn2006_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","迦勒让摩西周围的人安静下来，说∶“我们肯定应该去占领那地方，我们有足够的力量征服它。” ");
INSERT INTO cmn2006_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","但是，那些和迦勒一起去侦察的人却说∶“不，我们不能去攻打那里的人，他们比我们强大。” ");
INSERT INTO cmn2006_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","他们的侦察报告令以色列人沮丧。他们说∶“我们侦察遍了那里，那是个吞食生命的地方。那里的人都高大魁伟， ");
INSERT INTO cmn2006_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","我们还见到了巨人亚衲的后裔。在他们眼里，我们简直象蚱蜢一样。对他们来说，我们就是如此。” ");
INSERT INTO cmn2006_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","当时，全体会众都骚动起来，大声喧闹。民众整夜哭号。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","他们抱怨摩西和亚伦，说∶“我们还不如死在埃及或死在这旷野里！ ");
INSERT INTO cmn2006_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","主为什么要把我们带到这里来，让我们在刀下丧命？我们的妻儿要沦为俘虏了！我们不如返回埃及去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","人们彼此商议，说∶“我们选个首领，回埃及去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","摩西和亚伦俯伏在会众的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","嫩的儿子约书亚和耶孚尼的儿子迦勒曾参与侦察，他们悲痛地撕破衣服， ");
INSERT INTO cmn2006_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","对以色列的全体会众说∶“我们侦察过的那块土地是一块非常美好的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","如果主喜欢我们，他一定会把我们领进这块土地，并且把这流奶与蜜的富饶之地赐给我们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","千万不要背叛主！不要害怕那里的人，我们会轻而易举地打败他们，因为他们无可庇荫，而主与我们同在；不要怕那些人。” ");
INSERT INTO cmn2006_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","会众威吓他们，要用石头打死他们俩人。就在这时，主的荣耀在圣幕中出现了，它向全体以色列人显现。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","主对摩西说∶“这些人还要藐视我多久？我已经在他们中间行了如此多的神迹，他们还要多久才肯归依我？ ");
INSERT INTO cmn2006_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","我要降下可怕的瘟疫毁灭他们，我要使你的后裔成为比他们更强大的国家。” ");
INSERT INTO cmn2006_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","摩西对主说∶“主啊，这些人是你用你的大能从埃及人当中领出来的，埃及人一定会听到你惩罚他们的消息， ");
INSERT INTO cmn2006_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","他们会告诉这里的当地人。主啊，这里的人已经听说你与这个民族同在；因为你，主，一直清清楚楚地向他们显现。你的云彩停在他们的头上；白天，你用云柱引导他们，夜间，你用火柱给他们指路，走在他们的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","现在，一旦你把他们灭绝，那些听说过你的列国会说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘主因为没能把这个民族领进他应许赐给他们的那块土地，就把他们在旷野上击杀了！’ ");
INSERT INTO cmn2006_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","主啊，你是至高者，求你显示大能；你曾说过∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘我不轻易发怒，我有着丰盛的爱，我赦免罪错和过失，但决不以有罪为无罪，我必追讨罪人的罪，直至第三、四代。’ ");
INSERT INTO cmn2006_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","主啊，求你以你不变的爱饶恕这些人的罪，正如他们离开埃及以后你一直宽恕他们一样。” ");
INSERT INTO cmn2006_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","主说∶“我会按照你的请求饶恕他们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","但是，我以我的永生和笼罩大地的荣耀起誓∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","这些人见过我的荣耀，见过我在埃及和旷野里行的神迹，但他们仍然试探了我十次，不听从我的话。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","他们不能进入我应许给他们祖先的土地。所有不敬畏我的人都不能进入这块土地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","但是，我的仆人迦勒与他们不同，他一心一意地追随我，因此，我要把他领到他曾到过的地方，他的子孙要拥有那块土地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","亚玛力人和迦南人现在正住在山谷中，所以，你们明天要离开这里，由通往红海的路返回旷野去。” ");
INSERT INTO cmn2006_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“这些邪恶的民众还要妄论我多久？我已经听到这些妄论我的以色列人的抱怨。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","告诉他们，主是这样说的∶‘我以我的永生发誓，我必按照你们妄论我的话对待你们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","你们必倒毙在旷野中，你们当中所有二十岁以上登记在册的人－那些曾妄论过我的人， ");
INSERT INTO cmn2006_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","将没有一个能进入我的应许之地；除了耶孚尼的儿子迦勒和嫩的儿子约书亚之外，没有一个人能住在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","你们说你们的子女会被人掳走，但我却要把他们领进那块土地，他们将拥有那块曾被你们弃绝的土地， ");
INSERT INTO cmn2006_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","而你们都将死在旷野中。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","“‘你们的后代要因你们的不忠而承受罪罚，他们要在旷野上流浪四十年，直到所有你们这些人全都死去。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","你们要承受四十年罪罚，一年相应于你们侦察迦南地的一天。那时，你们就会明白使我不快对你们意味着什么。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","我是主，我已经宣布∶所有这些纠集起来背叛我的邪恶的会众，都必死在旷野里。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","摩西派去侦察迦南地的那些人， ");
INSERT INTO cmn2006_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","就是那些带回涣散人心的坏消息而使民众妄论主的人，都按主的意志死在了瘟疫里， ");
INSERT INTO cmn2006_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","只有耶孚尼的儿子迦勒和嫩的儿子约书亚保住了性命。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","摩西向全体以色列人宣布完这些话后，民众都悲痛至极。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","人们清早起来，向山地的最高峰爬去，说∶“主啊，我们愿意到你的应许之地去，我们知罪了。” ");
INSERT INTO cmn2006_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","摩西说∶“你们为什么又要违背主的命令？你们不会成功。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","不要去攻打敌人，否则你们必被杀，因为主不与你们同在。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","亚玛力人和迦南人必在那里迎击你们，你们必死于刀下。你们不遵从主的命令，主不会与你们同在。” ");
INSERT INTO cmn2006_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","但他们却执意向山顶进攻，不顾主的约柜和摩西都依然留在营地里。 ");
INSERT INTO cmn2006_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","住在山地的亚玛力人和迦南人下山迎战，打败了以色列人，一直追击到何珥玛。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“你晓喻以色列人∶当你们进入主赐给你们的那块安身之地时， ");
INSERT INTO cmn2006_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","要用牛或羊向主献上烧化祭或还愿祭或平安祭或自愿祭，或其它常例的节日期间应献的祭，把悦人的馨香奉献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","同时要献上用2.2升上等面粉与1升橄榄油调和的素祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","“用羊羔献作烧化祭或平安祭时，要同时随每只羊羔献上1升酒作为奠祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","用公绵羊献祭时，要同时献上用4.4升上等面粉与1.3升橄榄油调和的素祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","还要献上1.3升的酒作为奠祭。这祭物的香味是主所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","用公牛犊献作烧化祭、还愿祭或平安祭时， ");
INSERT INTO cmn2006_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","要同时献上用6.6升上等面粉与2升橄榄油调和的素祭， ");
INSERT INTO cmn2006_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","还要献上2升酒作为奠祭。这祭物的香味是主所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","对每只奉献的公牛、公羊、绵羊羔或山羊羔，都要按上述规定行事。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","如果奉献的数量多，那么陪献的祭物就要相应增加。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“本地的以色列族人向主奉献时，都要这样办理。这祭物的香味是主所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","从现在起，寄居在你们中间的外族人如果向主奉献，他必须按照你们奉献的办法同样办理，这祭物的香味是主所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","以色列的会众和寄居在你们中间的外族人遵守同一规则，这是永不改变的规则，你们世世代代都要遵守。你们与寄居的侨民在主的面前是平等的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","你们与他们适用于同样的规则与条例。” ");
INSERT INTO cmn2006_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“你晓喻以色列人∶‘当你们到了我领你们去的地方， ");
INSERT INTO cmn2006_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","享用了当地的出产之后，你们要向我奉献。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","你们要用初熟的麦子作成的饼奉献给我，这与在打麦场上向我奉献是一样的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","你们世世代代都要把新麦的第一批面粉献给我。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","如果你们无意间违背了主颁给摩西的这些命令－ ");
INSERT INTO cmn2006_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","这是主藉摩西颁给你们的，要你们从主颁发它们之日起，世世代代遵行不误的命令－ ");
INSERT INTO cmn2006_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","如果这错误出于无意，而又不被会众所知，那么，全体会众要献上一只公牛犊作烧化祭，这祭物的香味是主所喜悦的，同时还要按照规章献上规定的素祭和奠祭，此外，还要献上一只公山羊作为赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","祭司要用这种方式为以色列会众行赎罪礼，使他们得到赦免。因为他们的过错是无意的，他们为此向我奉献了烧化祭和赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","以色列会众和寄居在他们中间的外侨同样都会得到赦免，因为他们都是无意之中犯了过错。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“‘如果有人无意间犯了罪，那人就必须献上一只一岁大的母山羊作为赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","祭司要在我的面前为他行赎罪礼，使他得到赦免。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","对于无意中犯罪的以色列人和寄居的外侨，要按同样的条例处理。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","但是，如果有人蓄意犯罪，那人就冒犯了我，他必从我的子民中被除名； ");
INSERT INTO cmn2006_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","因为他藐视主的话，违背我的命令，他必被剪除，罪罚要落在他的身上。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","以色列人还在旷野的时候，发现一个人在安息日捡柴。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","他们把捡柴人带到摩西、亚伦和全体会众那里， ");
INSERT INTO cmn2006_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","暂时拘禁起来，因为不知道该怎样处理。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","主对摩西说∶“这个人必须处死！全体会众要在营外用石头打死他。” ");
INSERT INTO cmn2006_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","于是，会众把那人带到营外，按照主对摩西的命令用石头打死了他。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“你晓喻以色列人∶他们要在衣服的边上缝上穗子，每根穗子上要接上一条兰色的带子，你们世世代代都要这样做。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","你们佩带这穗子，好让你们看见它就记起我的一切诫命，遵行我的诫命，不致随意妄行而背离了我。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","这样，你们就能因牢记和遵行我的诫命而成为我的圣洁的子民。 ");
INSERT INTO cmn2006_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","我是主，是你们的上帝，我把你们从埃及领出来，就是要做你们的上帝。我是主，是你们的上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","可拉是以斯哈的儿子，属利未支派的哥辖宗族。他与吕便支派中以利押的儿子大坍和亚比兰以及比勒的儿子安，伙同两百五十名由会众从以色列人中推选出来的知名首领，起来反对摩西。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","他们纠集起来，反对摩西和亚伦说∶“你们太过份了！全体会众都是属于主的，主与我们大家同在。你们为什么抬高自己，凌驾于主的会众之上？” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","摩西听到这些话，急忙俯伏在地上， ");
INSERT INTO cmn2006_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","对可拉和追随他的人说∶“明天早晨，主会显明谁是属于他的；主要使圣洁的人归于他，使他所拣选的人归于他。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","可拉啊，你和你的人明天拿上香炉， ");
INSERT INTO cmn2006_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","装上炭火和香，到主的面前来，主所拣选的人要归于主。你们这利未的子孙哪，你们越轨了！” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","摩西又对可拉说∶“你们这些利未人哪，听听我的话吧∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","以色列的上帝把你们从以色列会众中分别出来，让你们归于他，在主的圣幕中执礼，为会众服务，难道这还不够吗？ ");
INSERT INTO cmn2006_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","主已经使你和你的利未人同胞归于他，而你还想再得到祭司的职位！ ");
INSERT INTO cmn2006_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","为此，你和你的人竟起来反对主；亚伦算什么，你们何必埋怨他？” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","摩西派人去召大坍和亚比兰，他们说∶“我们不去！ ");
INSERT INTO cmn2006_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","你领我们离开了那流奶与蜜之地，要让我们死在这旷野里，难道还不够吗？现在，你还要做我们的主人管辖我们吗？ ");
INSERT INTO cmn2006_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","你既没有领我们到那流奶与蜜之地，也没有给我们田地和葡萄园作产业，你还想继续欺骗我们吗？我们不去！” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","摩西极其愤怒，对主说∶“主啊，求你不要接受他们的祭物。我没有拿过他们一头驴，也没有做过一点对不起他们的事。” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","摩西对可拉说∶“你和你的人明天要到主的面前来，亚伦也要到那里去。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","你们每个人都要带上自己的香炉，里面放上香，一共是两百五十个香炉。你和亚伦也要带上自己的香炉。” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","于是，人们都带上香炉，里面放上香，与摩西和亚伦一起来到圣幕的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","可拉把全体会众召集到会幕入口处，向摩西和亚伦发难。突然，主的荣耀向全体会众显现。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“你们站开，我要立刻消灭这些人。” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","摩西和亚伦俯伏在地上，说∶“上帝啊，你是驾驭万民之灵的上帝，难道你会为一人之罪而迁怒于所有的会众吗？” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“你告诉民众，要他们远离可拉、大坍和亚比兰的帐篷。” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","摩西起身，带领以色列的长老们走向大坍和亚比兰。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","摩西告诉民众∶“你们离开这些恶人的帐篷，不要触碰他们的任何东西，否则，你们会因他们的罪而被一起毁灭。” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","于是，民众离开了可拉、大坍和亚比兰的帐篷的周围。大坍和亚比兰带着他们的妻儿出来，站在帐篷门口。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","摩西对民众说∶“你们就会知道，是主差遣我来做这事的，不是出于我本人的意愿。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","如果这些人能象常人一样死去，或是他们将要经历的与常人无异，那就是主没有差遣我。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","但是，如果主行了一件前所未有的事－地要张开大口，吞下他们和属于他们的一切，把他们活活埋掉，你们就知道是他们侮慢了主。” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","摩西刚说完这些话，那些人脚下的地就突然裂开， ");
INSERT INTO cmn2006_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","把他们和他们的家眷以及所有追随可拉的人和他们的家产都吞了下去。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","他们和属于他们的一切都被活活埋了进去之后，大地又在他们的头上合拢。一瞬间，他们就从会众的眼前消失了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","民众听到他们的哭喊，都四散奔逃，说∶“别让地把我们也吞下去！” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","随即，主降火烧死了那正在献香的二百五十个人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“你吩咐祭司亚伦的儿子以利亚撒，要他把那些香炉从火上拿开，把炭撒到四周，因为香炉是归圣的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","把那些犯罪丧命的人的香炉取来，锤成薄片，盖在祭坛上，因为这香炉曾由他们供奉主，已经归圣。以色列人要以此为戒。” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","于是，以利亚撒取出那些被烧死的人的铜香炉，按照主藉摩西对他的吩咐锤成薄片，盖在祭坛上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","这是要使以色列人记住∶凡亚伦家族之外的人都没有资格走近祭坛向主献香，否则就会象可拉和他的追随者一样被消灭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","第二天，以色列会众抱怨摩西和亚伦∶“你们杀了主的子民了！” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","会众正要聚集起来攻击摩西和亚伦，他们转向圣幕，看见圣幕已经被云彩罩住：主的荣耀显现了！ ");
INSERT INTO cmn2006_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","摩西和亚伦来到圣幕前， ");
INSERT INTO cmn2006_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","主对摩西说： ");
INSERT INTO cmn2006_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“你们站开，我要立刻把这民众毁灭掉。”摩西和亚伦俯伏在地上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","摩西对亚伦说∶“你拿上香炉，把祭坛上的炭火放在里面，再放上香，赶快去为民众行赎罪礼！主已经对他们发怒了，瘟疫已经开始流行了！” ");
INSERT INTO cmn2006_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","亚伦按照摩西的吩咐拿着香炉跑进民众中间，发现瘟疫已经蔓延开了。亚伦把香放进香炉，为民众行赎罪礼。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","瘟疫停止了，亚伦站在活人和死人中间。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","除了因可拉而死的人之外，因瘟疫而死的人有14700人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","瘟疫停止后，亚伦又回到圣幕门口摩西那里。 ");
INSERT INTO cmn2006_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“你吩咐以色列人，从他们每一支派的首领那里取一根杖，共取十二根，手杖上要写上那首领的名字。 ");
INSERT INTO cmn2006_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","相应于每个支派的首领有一根手杖，亚伦的名字要写在利未支派的手杖上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","你要把这些手杖放在圣幕里，摆在约柜的前面，那里是我会见你们的地方。 ");
INSERT INTO cmn2006_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","我所拣选的人的手杖必定发芽；我要用这种方式平息以色列人对你们的怨言。” ");
INSERT INTO cmn2006_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","于是，摩西晓喻以色列人；以色列的首领们就给他送来十二根手杖，每根手杖代表每个支派的一个首领，亚伦的手杖也在这些手杖之中。 ");
INSERT INTO cmn2006_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","摩西把这些手杖放到圣幕之中。 ");
INSERT INTO cmn2006_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","第二天，摩西进入圣幕，发现利未支派亚伦的手杖已经发芽，长出了花苞，还开了花，结了杏！ ");
INSERT INTO cmn2006_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","摩西把所有的杖都从主的面前取出来，遍示以色列人。所有的首领都确认并领去了自己的杖。 ");
INSERT INTO cmn2006_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","主对摩西说∶“把亚伦的手杖放回到约柜的前面，把它作为警告叛逆者的标记，使他们不敢再发怨言，否则，他们必死！” ");
INSERT INTO cmn2006_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","摩西按照主的命令行事。 ");
INSERT INTO cmn2006_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","以色列人对摩西说∶“我们要死了！我们完了！全完了！ ");
INSERT INTO cmn2006_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","既然走近圣幕的人都不得活命，是不是我们都得死？” ");
INSERT INTO cmn2006_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","主对亚伦说∶“你和你的儿子们以及你所属的支派要对任何触犯圣所的罪责负责，而你和你的儿子们要承担一切亵渎祭司职责的罪责。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","你要带领你的亲族－利未支派的人，让他们与你在一起；当你和你的儿子们在圣幕前侍奉主时，他们要随侍在你们身边。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","他们要保护你，并守卫圣幕，但绝不可触摸圣所的器具和祭坛，以免他们和你们都被击杀。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","他们要跟你在一起，要履行守卫会幕的职责，包括有关圣幕的所有劳务，利未支派以外的人不可与你们在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“你们要守护圣处和祭坛，以免我对以色列人发怒。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","我亲自从以色列人当中拣选了你的亲族利未人，把他们赐给你们，让他们负责圣幕的所有劳务。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","但是，你和你的儿子们必须谨慎供职，要负责祭坛和至圣所的有关事务，要履行我交给你们的神圣的祭司职责，我把祭司的职位赐给你们，就是要你们侍奉我。任何利未支派以外的人走近圣物都必须处死。” ");
INSERT INTO cmn2006_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","主对亚伦说∶“我指派你管理献给我的祭物，包括以色列人归圣的礼物。我把这些赐给你和你的子孙，永远作为他们的应得之份。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","凡不在祭坛上烧掉而被留存的至圣物当中，所有的祭品，包括素祭、赎罪祭和赎愆祭，都归你们所有。对于你和你的子孙，这是至为神圣的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","你们要在极其圣洁的地方吃这些东西，每个男子都可以吃，你们要以此为圣。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","另外，以色列人献给我的其他特别供物也归你们所有。我把这些赐给你和你的子女，永远作为你们的应得之份。你家中每个洁净的人都可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","我把以色列人献给我的初熟之物赐给你们，包括上等的橄榄油、新酒和五谷。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","以色列人献给我的初熟的谷物归你们所有，你们家中每个洁净的人都可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","在以色列，所有完全归圣的奉献都归你们所有。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","以色列人献给我的长子和头胎的牲畜归你们所有，但长子要被赎出，不洁净的头胎牲畜也要被赎出。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","他（它）们要在一个月大的时候赎出，以圣所的称量为准付五块银子。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","但头胎的牛、绵羊或山羊不可赎回，它们要归圣，要把它们的血洒在祭坛上，要把它们的脂肪作为烧化祭献给我，这祭物的香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","这祭物的肉与摇祭的胸肉和右后腿一样同归你们所有。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","我要把以色列人献给我的圣物中的举祭都赐给你和你的子女，作为你们永远的应得之份。这是我与你和你的后代的永久的约。” ");
INSERT INTO cmn2006_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","主对亚伦说∶“以色列人的土地中没有你的份额，你也不能在以色列人中间拥有自己的产业，我就是你在以色列人中的份额和产业。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“以色列人把他们收获的十分之一献给我，我要把它赐给利未人，这是他们的应得之份，是他们承担圣幕劳务的报酬。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","从现在起，以色列人不可接近圣幕，否则将蒙罪受罚而死。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","只有利未人可以办圣幕的事务，他们要为任何触犯圣幕的罪责负责。这是你们世世代代要遵守的条例。利未人在以色列人中间不可拥有产业， ");
INSERT INTO cmn2006_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","因为我已经把以色列人献给我的这十分之一的奉献赐给了他们，作为他们的产业。所以，我对他们说，他们在以色列人中间没有自己的土地。” ");
INSERT INTO cmn2006_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“你晓喻利未人∶‘你们收到主赐给你们的应得之份，也就是以色列人献给我的十分之一的供物时，你们要把其中的十分之一献给我。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","这份祭物相当于用初熟的五谷和新酿的酒所献的祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","这样，你们也就把从以色列人那里得到的十分之一的供献奉献给了主。你们要把这献给主的祭物交给祭司亚伦， ");
INSERT INTO cmn2006_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","那应该是你们所得到的礼物中最好和最圣洁的部分。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","你们利未人把这最好的部分作为祭物献给我，相当于用初熟的谷物和新酿的酒所献的祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","之后，你和你的家人就可以在任何地方吃那其余的部分了，那是你们为圣幕工作的酬劳。 ");
INSERT INTO cmn2006_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","你们把那最好的部分献给了主，因此，你们不会为此而蒙受罪罚，但你们决不可以亵渎以色列人这圣洁的礼物，否则你们必死。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","主对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“你晓喻以色列人，要他们牵一头没有残疾、没有劳作过的红色母牛给你，这是主颁布的律例。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","你们要把这牛交给祭司以利亚撒，然后把牛带出营外，当着以利亚撒的面把牛宰掉。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","以利亚撒要用手指蘸着这牛的血，向圣幕的前方弹撒七次， ");
INSERT INTO cmn2006_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","这牛的皮、肉、血和内脏都要当着以利亚撒的面烧掉。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","祭司要把香柏木、牛膝草和一些红线丢进烧牛的火里。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","之后，祭司要洗涤衣服，沐浴净身，然后才能返回营地，但他直到晚上仍然是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","烧牛的人也要洗涤衣服，沐浴身体，但他直到晚上仍然是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","烧牛的灰要由一个洁净的人收取，放到营外一个洁净的地方。这灰要保存起来，用作为以色列会众调制洁净水之用。这是洁净祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","收灰的人要洗涤衣服，但他直到晚上仍然是不洁净的。这是以色列人和他们中间的外侨要永远遵守的条例。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“接触了死尸的人在七天之内都是不洁净的， ");
INSERT INTO cmn2006_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","他必须在第三天和第七天用母牛灰洁净自己，然后他就洁净了，否则，他就是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","凡接触了死尸的人，如果不洁净自己，他就是不洁净的，因为洁净水没有洒在他的身上，污秽还留在他的身上，他是不洁净的。他玷污了主的圣幕，必须从以色列人中除名。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“如果有人死在帐篷里，那么当时在帐篷里的人和走进帐篷的人在七天之内都是不洁净的，这是律例。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","帐篷内所有没有盖的容器也是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","凡在野外触摸了死尸－无论是被杀的还是自然死亡的，无论是死人的骨头还是坟墓－的人在七天之内都是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“为了使这些人再洁净，要取一些用洁净祭烧成的灰－就是红母牛的灰－放到容器里，加入净水， ");
INSERT INTO cmn2006_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","由一个洁净人拿一根牛膝草蘸着这水，洒在帐篷和帐篷里的所有容器和人的身上，也要洒在那些触摸了死人骨头、尸体、或坟墓的人的身上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","洁净人要在第三天和第七天用洁净水洒在不洁净的人身上。那不洁净的人要在第七天洗涤衣服，沐浴净身，等到晚上他就洁净了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“如果不洁净的人不洁净自己，没有洁净水洒在他的身上，他就是不洁净的，必须从会众中除名，因为他玷污了主的圣处。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","你们要世世代代遵守这条例。那洒洁净水的人必须洗涤衣服，凡接触了洁净水的人直到晚上都是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","不洁净的人碰过的一切都是不洁净的，接触了他的人直到晚上都是不洁净的。” ");
INSERT INTO cmn2006_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","正月，以色列会众来到寻旷野，在加低斯安营。米利暗死在那里，就安葬在当地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","会众没有水喝，对摩西和亚伦不满，他们聚集在一起， ");
INSERT INTO cmn2006_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","跟摩西吵闹，说∶“我们还不如当初跟我们那些死在主面前的弟兄们一起死掉的好！ ");
INSERT INTO cmn2006_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","你们为什么要把主的会众领到这旷野里来，让我们和我们的牲畜都死在这里？ ");
INSERT INTO cmn2006_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","为什么领我们离开埃及到这不毛之地来？这儿没有庄稼、无花果、葡萄或石榴，连水都没得喝！” ");
INSERT INTO cmn2006_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","摩西和亚伦离开会众，来到圣幕门前，俯伏在地上；主的荣耀向他们显现了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“你拿着杖，和你的哥哥亚伦一起召集会众，当着他们的面对岩石讲话，水就会从岩石里流出来，会众和他们的牲畜就有水喝了。” ");
INSERT INTO cmn2006_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","于是，摩西遵照主的命令拿起主面前的杖， ");
INSERT INTO cmn2006_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","然后和亚伦一起把全体会众召集到岩石前，对他们说∶“听着！你们这些背叛上帝的人！我们该叫这岩石流出水来给你们喝吗？” ");
INSERT INTO cmn2006_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","摩西举起杖，击打岩石两下，水立刻涌了出来，会众和牲畜都喝了水。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","主对摩西和亚伦说∶“你们在以色列人面前没有表现出足够的信心尊崇我的神圣，所以，你们不能带领民众进入我赐给他们的应许之地。” ");
INSERT INTO cmn2006_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","这股泉水因此叫做米利巴泉，因为以色列人在那里向主吵闹，主在那里向他们显明了自己的神圣。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","摩西从加低斯派使者去谒见以东王，对他说∶“陛下，你的兄弟以色列人向你致意；你知道我们经历的种种艰难。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","我们的祖先南下埃及，在那里住了很多年，后来，埃及人虐待我们的祖先和我们， ");
INSERT INTO cmn2006_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","我们就向主求救，主垂听我们的祈求，派来了天使，把我们领出了埃及。请看，我们现在到了你的边界加低斯城， ");
INSERT INTO cmn2006_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","请准许我们通过你的国土，我们只走大道，不穿越田地和葡萄园，也不喝井里的水，只从大道上直接通过你的国土。” ");
INSERT INTO cmn2006_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","但是，以东王对他们说∶“我不准你们穿过我的国土，否则，我就要与你们兵戎相见！” ");
INSERT INTO cmn2006_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","以色列人又说∶“我们只走大道，只求徒步过境，这实在是微不足道的事。如果我们或我们的牲畜喝了你们的水，我们会付钱的。” ");
INSERT INTO cmn2006_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","但以东王坚持不肯。他派出精锐大军攻击以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","由于以东人拒绝以色列人过境，以色列人就离开了那里。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","以色列的全体会众离开加低斯，来到何珥山。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","何珥山在以东的边界上。主在那里对摩西和亚伦说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“亚伦要归回到他的祖先那里去，他不能进入我赐给以色列人的应许之地，因为你们在米利巴泉违背了我的命令。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","你带着亚伦和他的儿子以利亚撒到何珥山上去。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","你要在那里脱下亚伦的圣服，给他的儿子以利亚撒穿上。然后，亚伦要应召死在那里。” ");
INSERT INTO cmn2006_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","摩西遵照主的命令行事。他们三人当着全体会众的面一起上了何珥山。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","摩西脱下亚伦的圣服，给他的儿子以利亚撒穿上。随后，亚伦就死在何珥山的山顶，摩西和以利亚撒下了山。 ");
INSERT INTO cmn2006_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","全体会众知道亚伦死了，为他举哀三十天。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","住在南地的迦南王亚拉得得悉以色列人取道亚他林前来，就去攻击他们，俘掳了一些人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","以色列人向主许愿，说∶“如果你把这个民族交在我们手里，我们就把他们的城邑全部奉献给你。” ");
INSERT INTO cmn2006_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","主垂听以色列人的祈求，把迦南人交在他们的手中。以色列人杀光了所有的迦南人，彻底毁灭了他们的城邑。所以，这地方叫做何珥玛。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","然后，以色列人离开何珥山，取道红海以绕过以东的国土。民众在路上不耐烦起来， ");
INSERT INTO cmn2006_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","他们抱怨上帝和摩西，说∶“你们为什么要让我们离开埃及到这旷野里来送死？这儿没吃没喝，我们再不愿吃这难吃的东西了！” ");
INSERT INTO cmn2006_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","主差遣毒蛇进入民众中间；许多以色列人被咬死了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","民众来见摩西，说∶“我们妄论主和你，我们知罪了。求你祷告主，求他让毒蛇离开我们吧！”于是，摩西为民众祷告。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","主对摩西说∶“你造一条火蛇，把它挂在柱子上，凡被毒蛇咬了的人一望见它就能康复。” ");
INSERT INTO cmn2006_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","摩西造了一条铜蛇，把它挂在柱子上，被蛇咬了的人望见这铜蛇，都康复如初。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","以色列人离开那里，来到阿伯安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","又从阿伯启程，在与摩押地东部接壤的旷野里的以耶亚巴琳安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","又从以耶亚巴琳启程，在撒烈谷安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","又从撒烈谷启程，在亚嫩河对岸的旷野安营。亚嫩河起源于亚摩利人境内，是摩押人和亚摩利人的界河。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","因此，《主的战记》上记载∶ “苏法的哇哈伯城和亚嫩河谷， ");
INSERT INTO cmn2006_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","以及延伸至亚珥城的河谷坡地，与摩押地接界。” ");
INSERT INTO cmn2006_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","他们又从那里启程，在比珥安营。主在那里对摩西说∶“你把民众召集起来，我要给他们水喝。” ");
INSERT INTO cmn2006_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","因此，以色列人唱道∶ “井啊，你要涌出水来！我们要为你歌唱。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","这是民众的首领挖的井， 是尊贵的人用笏和杖挖的井。” 然后，他们从旷野来到玛他拿安营， ");
INSERT INTO cmn2006_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","再从那里到拿哈列，再到巴末， ");
INSERT INTO cmn2006_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","再到摩押谷地，然后来到俯视旷野的毗斯迦山山顶。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","以色列人派使者去见亚摩利王西宏，说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“请准许我们通过你的国土。我们只走大道穿过你的国土，不进入你们的田地和葡萄园，也不喝你们井里的水。” ");
INSERT INTO cmn2006_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","但是西宏不准以色列人过境。他集结军队，开进旷野，在雅杂向以色列人进攻。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","以色列人击毙了西宏，占领了从亚嫩河到雅博河的全部亚摩利人国土，直至防务严密的亚扪人的边界。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","以色列人占领了亚摩利人的全部城市，包括希实本城及其周围的城镇，并在那里定居下来。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","希实本是亚摩利王西宏的都城；西宏曾攻打前摩押王，夺取了直至亚嫩河的全部摩押人的国土。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","因此诗人唱道∶ “你们到希实本来，愿西宏的城被重建！ ");
INSERT INTO cmn2006_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","火舌曾从希实本喷出， 烈焰曾从西宏的城腾起； 吞没了摩押的亚珥城， 毁灭了亚嫩河上游的山地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","摩押人哪，你们大难临头了！ 追随基抹的人啊，你们灭亡了！ 基抹使得他的儿子逃亡，他的女儿沦为亚摩利王西宏的俘虏。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","但是，我们打败了这些亚摩利人； 从希实本到底本，从那欣到米底巴附近的挪法， 我们把一切夷为平地。” ");
INSERT INTO cmn2006_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","以色列人就住在了亚摩利人原有的国土上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","摩西派人去侦察雅谢，并占领了雅谢及其周围的城镇，赶走了那里的亚摩利人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","然后，以色列人转而取道巴珊；巴珊王噩率全军在以得来迎战。 ");
INSERT INTO cmn2006_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","主对摩西说∶“不要怕他们，我已经把巴珊王、他的军队和他的国土都交在你的手里了！你要象处置希实本的亚摩利王西宏一样处置他们。” ");
INSERT INTO cmn2006_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","以色列人击毙了巴珊王噩，杀死了他的儿子，屠光了所有的亚摩利人，没有留下一个活口。随后，以色列人占领了巴珊全境。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","以色列人继续前进，在约旦河东岸的摩押平原上安营，与耶利哥城隔河相对。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","西拨的儿子巴勒见到了以色列人对亚摩利人所做的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","摩押人看见以色列人人多势众，对他们非常恐惧。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","他们对米甸的长老们说∶“瞧吧，这群人不久就会象公牛吃草一样把我们周围的一切一扫而光！”当时，巴勒是摩押王。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","比珥的儿子巴兰住在他本族人的境内、幼发拉底河边的毗夺；巴勒派使者去请巴兰，向他致意，说∶“从埃及出来了一族人，他们席卷而来，已经逼近我们身边。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","他们比我们强大，所以，请你为我们去诅咒他们，或许我们能因此而打败他们，把他们赶出去。我知道，凡你祝福的人必蒙福，凡你诅咒的人必遭祸。” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","摩押人和米甸的长老们带着聘礼来见巴兰，向他转达了巴勒的话。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","巴兰对他们说∶“请在这里住一夜，明天我就会把主启示我的话告诉你们。”于是摩押的首领们就留在巴兰那里过夜。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","上帝托梦给巴兰，问他∶“跟你在一起的是些什么人？” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","巴兰说∶“西拨的儿子摩押王巴勒派他们来见我，对我说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘有一族人从埃及席卷而来，请你来诅咒他们，这样，或许我能与他们抗衡，把他们赶走。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","上帝对巴兰说∶“你不可以随他们去，也不可以诅咒那些人，因为他们是蒙我赐福的。” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","巴兰清早起来，对巴勒派来的首领们说∶“你们回去吧，因为主不准我随你们同去。” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","首领们回禀巴勒，说∶“巴兰不肯随我们来。” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","巴勒又派了一批人去。这些人的人数比第一批更多，职位也更高。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","他们见到巴兰，对他说∶“西拨的儿子巴勒要我们告诉你∶‘请到我这里来，不要有任何顾虑。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","我会付给你丰厚的报酬，满足你的任何要求。来吧，请为我诅咒那些人。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","巴兰对他们说∶“即使巴勒把他充满金银的漂亮房屋给我，我也不敢违背主－我的上帝的旨意去做任何事，无论这事是大是小。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","请在这里住下来，让我看一看主还会有什么别的旨意。” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","当夜，主托梦给巴兰，对他说∶“既然这些人来求你和他们一起去，那就随他们一起去吧，但你只准按照我吩咐的去做。” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","于是，巴兰早上起来，备好驴，和摩押的首领们一同上了路。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","上帝因此发了怒；主的天使站在路上不准巴兰通过。当时，巴兰正骑着驴，两个仆人跟随左右。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","驴看见主的天使站在路的中央，手中拿着出鞘的剑，就离开大路，下到田里。巴兰打着驴，把它赶回到大路上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","主的天使又站在两个葡萄园之间的狭路上，两边都有石墙。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","驴看见了主的天使，就紧贴着墙根走，把巴兰的脚擦伤了。巴兰又打驴。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","天使再往前去，站在一个很窄的地方，左右没有一点回旋的余地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","这一次，驴看见天使就趴下了，巴兰发了怒，用手杖打驴。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","主使驴开口讲话，说∶“我犯了什么过错？你为什么三次打我？” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","巴兰说∶“你让我显得象个傻瓜，我恨不得现在手里就有刀宰了你！” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","驴说∶“你从小至今一直骑着我，我以前这样对待过你吗？”巴兰说∶“没有。” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","这时，主使巴兰看见主的天使站在路的中央，手中拿着出鞘的剑。巴兰赶紧俯伏在地上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","天使对他说∶“你为什么三次打你的驴？是我在这儿挡你的路，因为我不喜欢你去。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","这驴看见我，三次都避了开去。要不是它避开了我，刚才我已经杀了你，只让驴活着。” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","巴兰对天使说∶“我知罪了。我不知道是你在路上阻拦我。既然你不喜欢我去，我就回家去。” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","天使说∶“你跟这些人去吧！但只准说我吩咐你的话。”于是，巴兰跟摩押的首领们继续赶路。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","巴勒听说巴兰来了，就到界河－亚嫩河边的亚珥城来迎接他，这里是边界的最远端。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","巴勒对巴兰说∶“我第一次派人去请你，为什么没有来呢？难道以为我不会真心酬谢你吗？” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","巴兰答道∶“陛下，我已经来了，但我不能想说什么就说什么，我只能说上帝吩咐我说的话。” ");
INSERT INTO cmn2006_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","巴兰随同巴勒来到基列胡琐。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","巴勒杀牛宰羊，把肉送给巴兰和陪同他一起来的首领们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","第二天早晨，巴勒带巴兰上了巴莫巴力高地，巴兰可以从那里了望以色列人的部分营地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","巴兰对巴勒说∶“你在这儿为我造七座祭坛，预备好七头公牛和七只公羊。” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","巴勒照办了。他们在每座祭坛上献了一头公牛和一只公羊。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","巴兰对巴勒说∶“你站在你的烧化祭旁边，我要单独往前面去，或许主会接见我。无论他给我什么启示，我都一定告诉你。”巴兰一人上了山顶。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","上帝向巴兰降临。巴兰说∶“主啊，我已经造了七座祭坛，在每个祭坛上献了一头公牛和一只公羊。” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","主把应该说的话告诉了巴兰，吩咐他∶“这就是你回去要告诉巴勒的话。” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","于是，巴兰回来见巴勒，他正和全体摩押首领一同站在烧化祭的旁边。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","巴兰说出预言∶ “巴勒把我从亚兰领到这里，摩押王领我西出群山。 他说，‘来吧，为我诅咒雅各， 来吧，痛斥这些以色列人。’ ");
INSERT INTO cmn2006_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","然而，上帝没有诅咒的，我怎能诅咒？ 上帝没有斥责的，我怎能痛斥？ ");
INSERT INTO cmn2006_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","我从山顶上望得见以色列， 我从丘陵上望得见他们， 瞧，这是独居的民族，不把自己列在万民之中。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","谁能数得清以色列人，即便是他们的四分之一？ 他们多如灰尘。 我愿象义人一样死去， 象他们那样终了一生。” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","巴勒对巴兰说∶“你这是做什么？我带你到这里来是要你诅咒我的仇敌，而你竟祝福他们！” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","巴兰答道∶“我只能说主吩咐我说的话。” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","巴勒说∶“你跟我到另一个地方去，从那里你能看到更多的以色列人。但不是全部。请你在那里为我诅咒他们吧！” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","巴勒把巴兰带到毗斯迦山山顶上的琐腓田，在那里造了七座祭坛，在每个祭坛上献了一头公牛和一只公羊。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","巴兰对巴勒说∶“你站在你的烧化祭旁边，我到那边去迎见主。” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","主向巴兰降临，把应该说的话告诉了他，吩咐他说∶“这就是你回去要说的话。” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","巴兰回来见巴勒，他正和全体摩押首领一同站在烧化祭的旁边。巴勒问∶“主说了什么？” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","巴兰说出预言∶ “起来，西拨的儿子巴勒，你来听我要说的话。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","上帝不是撒谎的凡人，不是朝令夕改的俗夫。 他言出必随，从不食言。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","我奉命祝福； 上帝赐福给以色列人，我无法改变。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","他没有发现雅各的子孙中有罪责， 他没有看见以色列人中有奸恶。 主是以色列的上帝，他与他们同在。 他们赞颂主，拥戴他作王， ");
INSERT INTO cmn2006_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","上帝把他们领出埃及，使他们象野牛的角一样强壮。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","雅各从不观兆，以色列也不占卜， 凡上帝已经计划好的事情，都立即知会给了雅各，告诉了以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","他们如母狮纵身而起， 他们如公狮挺身而立， 它要吞下猎物的肉，要喝尽猎物的血， 否则，绝不罢休！” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","巴勒对巴兰说∶“你不诅咒他们，至少也不该祝福他们呀！” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","巴兰答道，“我不是告诉过你，我必须按照主的吩咐去做吗？” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","巴勒对巴兰说∶“来吧，我带你到另一个地方去。也许上帝会满意并允许你在那里诅咒他们。” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","巴勒把巴兰带到鸟瞰旷野的毗珥山山顶上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","巴兰对巴勒说∶“在这儿为我造七座祭坛，预备好七头公牛和七只公羊。” ");
INSERT INTO cmn2006_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","巴勒照办了，并在每座祭坛上献了一头公牛和一只公羊。 ");
INSERT INTO cmn2006_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","巴兰知道主要他祝福以色列，于是，他不再象以前那样去求预兆，而是转向旷野。 ");
INSERT INTO cmn2006_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","他向旷野了望，望见以色列人各按支派在那里安营。这时，上帝的灵降在巴兰身上， ");
INSERT INTO cmn2006_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","他说出预言∶ “这是比珥的儿子巴兰的预言， 是洞察未来的人的话， ");
INSERT INTO cmn2006_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","是听得到上帝说话的人得到的启示。 他在上帝的面前扑倒，但双眼睁着， 他看见全能的上帝显示的异象。 ");
INSERT INTO cmn2006_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","雅各的子孙啊，你们的帐篷多么壮观； 以色列的子孙啊，你们的营地多么华美！ ");
INSERT INTO cmn2006_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","它们象成排伸延的挺拔的棕树， 象河边的花园， 象主种植的沉香树， 象溪水边的香柏树。 ");
INSERT INTO cmn2006_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","他们享受充沛的雨露， 他们的种子播在滋润的土地里。 他们的王比亚甲更伟大， 他们的国强盛无比。 ");
INSERT INTO cmn2006_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","上帝把他们领出埃及，他们象野牛的角一样强壮。 他们要吞灭仇敌，压碎他们的骨头，折断他们的弓箭； ");
INSERT INTO cmn2006_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","他们象狮子一样躺卧， 谁敢去唤醒他们？ 祝福你的人必蒙福，诅咒你的人必遭祸。” ");
INSERT INTO cmn2006_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","巴勒发怒了，他猛一拍掌，对巴兰说∶“我叫你来是来诅咒我的仇敌的，可你竟三次为他们祝福！ ");
INSERT INTO cmn2006_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","你给我回去吧！我说过我要酬谢你，但是主不让你得到。” ");
INSERT INTO cmn2006_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","巴兰答道∶“难到我没有事先告诉过你的使者吗？ ");
INSERT INTO cmn2006_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","就是你把你宫中的金银都给我，我也不能违背主的意志，凭自己的心愿去做任何事。不论是好是坏，我只能按主的吩咐说话。 ");
INSERT INTO cmn2006_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","我马上就要回去了，来吧，让我把以色列人将要怎样对待你的人民告诉你。” ");
INSERT INTO cmn2006_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","巴兰说出预言∶ “这是比珥的儿子巴兰的预言，是洞察未来的人的话。 ");
INSERT INTO cmn2006_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","他扑倒在地，却睁着眼睛； 他能听见上帝的话，明白至高者的心意，看得见全能者显示的异象。 ");
INSERT INTO cmn2006_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","我不是看他们的现在，而是遥望他们的将来∶ 必有明星从雅各升起， 必有君王从以色列兴起。 他将击败摩押的首领，打碎塞特之子的头盖骨。 ");
INSERT INTO cmn2006_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","以色列将扬威四方； 以东的土地将成为他们的产业，他们的仇敌－西珥人的土地将成为他们的产业； ");
INSERT INTO cmn2006_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","以色列的君王要毁灭所有这些城中残存的人。” ");
INSERT INTO cmn2006_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","巴兰看见亚玛力人，说出预言∶ “亚玛力本为列国之首，但终必沦亡。” ");
INSERT INTO cmn2006_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","巴兰看见基尼人，说出预言∶ “你们的住处本是安全坚固的，象搭在峭壁上的窝， ");
INSERT INTO cmn2006_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","但你们这些基尼人终必覆灭，亚述人将把你们掳去。” ");
INSERT INTO cmn2006_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","巴兰又说出以下预言∶ “瞧吧！除非上帝裁决，谁能逃遁？ ");
INSERT INTO cmn2006_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","有船从基提而来， 他们必征服亚述和希伯，然而他们最终也必被毁灭。” ");
INSERT INTO cmn2006_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","说完，巴兰就动身回家，巴勒也自行回去了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","以色列人驻扎在什亭，有人与摩押女子行淫取乐。 ");
INSERT INTO cmn2006_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","摩押女子邀请以色列人参加他们的敬神庆典，以色列人吃了他们的祭物，拜了他们的神明。 ");
INSERT INTO cmn2006_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","就这样，以色列人开始拜巴力毗珥。 主向以色列人发怒， ");
INSERT INTO cmn2006_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","对摩西说∶“你把以色列的首领们都公开吊死在我的面前，才能平息我的怒气。” ");
INSERT INTO cmn2006_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","摩西对以色列的法官们说∶“你们要杀掉你们各自支派里拜了异神毗珥巴力的人。” ");
INSERT INTO cmn2006_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","正在这时，一个以色列人当着摩西和全体会众的面把一个米甸女子带到他的族人那里。当时，摩西和以色列会众正在圣幕门口哀哭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","祭司亚伦的孙子、以利亚撒的儿子非尼哈看见了，就离开会众，拿起一支矛， ");
INSERT INTO cmn2006_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","跟着那人进了他的帐篷，用矛把那以色列人和那米甸女人一起刺透了腹部。随后，以色列人中间的瘟疫停止了， ");
INSERT INTO cmn2006_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","有两万四千人死于瘟疫。 ");
INSERT INTO cmn2006_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“非尼哈把以色列人从我的愤怒中拯救了出来，他怒我之所怒，因此，我不再因怒而毁灭以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","你告诉非尼哈，为了他所做的这一切，我要与他立平安的约∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","他和他的后代将永远任职祭司，因为他曾为他的上帝挺身而出，为以色列人赎了罪。” ");
INSERT INTO cmn2006_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","与米甸女子一起被杀的那以色列人叫心利，是撒路的儿子，他是西缅支派的一个族长。 ");
INSERT INTO cmn2006_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","那米甸女子叫歌斯比，她的父亲苏珥是米甸一个家族的部落首领。 ");
INSERT INTO cmn2006_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“你要攻打米甸人，要消灭他们， ");
INSERT INTO cmn2006_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","因为他们与你们为敌，在毗珥用诡计陷害你们，又用歌斯比－那在瘟疫猖獗时被杀死的女子诱惑你们。” ");
INSERT INTO cmn2006_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","瘟疫停止后，主对摩西和亚伦的儿子以利亚撒说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“你们要对以色列全体会众进行人口普查，按家族把二十岁以上能够作战的男子都登记在册。” ");
INSERT INTO cmn2006_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","摩西和祭司以利亚撒把以色列会众集合在耶利哥对岸约旦河边的摩押平原上，向他们宣布∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“现在要进行人口普查，每个二十岁以上的男子都要登记在册，就象以色列人离开埃及以后主命令以色列人进行的人口普查一样。” ");
INSERT INTO cmn2006_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","吕便支派（吕便是以色列的长子）包括： 哈诺宗族、 法路宗族、 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","希斯伦宗族、 迦米宗族； ");
INSERT INTO cmn2006_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","这是吕便支派的各宗族，登记在册的人数共43730人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","法路的儿子是以利押； ");
INSERT INTO cmn2006_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","以利押的儿子是尼母利、大坍和亚比兰。大坍和亚比兰被会众推选为首领，但他们追随可拉，反对摩西和亚伦，背叛了主。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","于是，地张开大口，吞下了他们和可拉一党，其余二百五十人同时被火烧死。他们的下场被以色列人引为儆戒。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","但是可拉的儿子们并没有死。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","西缅支派包括： 尼母利宗族、 雅悯宗族、 雅斤宗族、 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","谢拉宗族、 扫罗宗族； ");
INSERT INTO cmn2006_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","这是西缅支派的各宗族，登记在册的人数共22200人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","迦得支派包括： 洗分宗族、 哈基宗族、 书尼宗族、 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","阿斯尼宗族、 以利宗族、 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","亚律宗族、 亚列利宗族； ");
INSERT INTO cmn2006_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","这是迦得支派的各宗族，登记在册的人数共40500人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","21","犹大支派包括： 示拉宗族、 法勒斯宗族、 谢拉宗族， 以及法勒斯的后裔希斯伦宗族、哈母勒宗族（犹大的其他两个儿子珥和俄南已经死在迦南）。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","这是犹大支派的各宗族，登记在册的人数共76500人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","以萨迦支派包括： 陀拉宗族、 普瓦宗族、 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","雅述宗族、 伸伦宗族； ");
INSERT INTO cmn2006_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","这是以萨迦支派的各宗族，登记在册的人数共64300人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","西布伦支派包括： 西烈宗族、 以伦宗族、 雅利宗族； ");
INSERT INTO cmn2006_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","这是西布伦支派的各宗族，登记在册的人数共60500人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","约瑟的后代分为玛拿西支派和以法莲支派。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","玛拿西支派包括∶ 玛吉宗族（玛吉是基列的父亲）、 基列宗族， ");
INSERT INTO cmn2006_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","32","以及基列的后裔伊以谢宗族、希勒宗族、亚斯烈宗族、示剑宗族、示米大宗族、希弗宗族。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","希弗的儿子是西罗非哈，他没有儿子只有女儿。她们的名字是玛拉、挪阿、曷拉、密迦和得撒。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","这是玛拿西支派的各宗族，登记在册的人数共52700人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","以法莲支派包括： 书提拉宗族、 比结宗族、 他罕宗族， ");
INSERT INTO cmn2006_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","以及书提拉的后裔以兰宗族。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","这是以法莲支派的各宗族，登记在册的人数共32500人。以上两支派是约瑟的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","便雅悯支派包括： 比拉宗族、 亚实别宗族、 亚希兰宗族、 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","书反宗族、 户反宗族， ");
INSERT INTO cmn2006_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","以及比拉的后裔亚勒宗族、乃幔宗族。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","这是便雅悯支派的各宗族，登记在册的人数共45600人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","但支派∶只有书含宗族， ");
INSERT INTO cmn2006_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","全宗族登记在册的人数共64400人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","亚设支派包括： 音拿宗族、 亦施韦宗族、 比利亚宗族， ");
INSERT INTO cmn2006_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","以及比利亚的后裔希别宗族、玛结宗族。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","（亚设的女儿是西拉）。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","这是亚设支派的各宗族，登记在册的人数共53400人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","拿弗他利支派包括： 雅薛宗族、 沽尼宗族、 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","耶色宗族、 示冷宗族， ");
INSERT INTO cmn2006_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","这是拿弗他利支派的各宗族，登记在册的人数共45400人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","以色列人登记在册的总人数共601730人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“你要按各支派登记的人数把土地分给以色列人， ");
INSERT INTO cmn2006_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","人数多的多分，人数少的少分，以登记在册的人数为准。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","你要用拈阄的方法分地，各支派都要分得土地，各以其祖先的名字命名。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","各家族无论大小都要分得土地；你要用拈阄的方法主持分地。” ");
INSERT INTO cmn2006_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","利未支派包括： 革顺宗族、 哥辖宗族、 米拉利宗族， ");
INSERT INTO cmn2006_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","还有立尼宗族、 希伯伦宗族、 玛利宗族、 母示宗族、 可拉宗族。 哥辖生暗兰。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","暗兰的妻子叫约基别，是利未的后代，她出生在埃及。她为暗兰生了亚伦、摩西和米利暗。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","亚伦的儿子是拿答、亚比户、以利亚撒和以他玛。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","拿答和亚比户因为献凡火死在上帝的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","出生一个月以上的利未男子共有23000人，他们跟其余的以色列人分开登记，因为他们不跟其他以色列人一样分得产业。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","以上是摩西和祭司以利亚撒在耶利哥对岸约旦河边的摩押平原上清点的以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","在这些人当中，没有一个当年摩西和亚伦在西乃旷野进行人口普查时清点过的以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","因为主说过∶“他们要死在旷野里。”因此，除了耶孚尼的儿子迦勒和嫩的儿子约书亚以外，没有一个人存活下来。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","约瑟生玛拿西；玛拿西生玛吉；玛吉生基列；基列生希弗；希弗生西罗非哈。西罗非哈的女儿是玛拉、挪阿、曷拉、密迦、得撒。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","西罗非哈的女儿们来到圣幕门口，站在摩西、祭司以利亚撒及众首领和全体会众面前，说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“我们的父亲死在旷野。他没有追随可拉一党反对主；他死，是因为他自己的罪。他没有留下儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","难道我们父亲的姓氏因为他没有儿子就要从以色列中除去吗？请在与我们父亲的兄弟相等的基础上分给我们一份土地吧！” ");
INSERT INTO cmn2006_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","摩 西 把 这 件 事呈给主。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","主说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“西罗非哈的女儿们的要求是正当的。你要在与她们父亲的兄弟相等的基础上分给她们土地，她们可以把那份土地传给自己的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","你晓喻以色列人∶如果有人身后无子，他的应得之份要分给他的女儿们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","如果他没有女儿，则由他的兄弟继承。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","如果他也没有兄弟，则由他的叔伯继承。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","如果他连叔伯也没有，就要把他的应得之份分给他族中的近亲，由那人继承。这要定为以色列人的律例。我是主；是我这样命令你的。” ");
INSERT INTO cmn2006_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","主对摩西说∶“你要到亚巴琳山上去，从那里遥望我要赐给以色列人的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","你看过以后，就要和你的哥哥亚伦一样归回先祖， ");
INSERT INTO cmn2006_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","因为你们在寻旷野里违背了我的命令。当会众与我争吵的时候，你们没有在他们面前用水维护我的神圣；这水就是寻旷野里加低斯附近的米利巴泉。” ");
INSERT INTO cmn2006_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","摩西对主说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“主啊，你是掌管万民之灵的上帝，求你立一个人作会众的领袖， ");
INSERT INTO cmn2006_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","让他统率民众征战，带领他们跋涉，好使你的子民不致象无人照看的羊群。” ");
INSERT INTO cmn2006_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","主对摩西说∶“嫩的儿子约书亚的身上有我的灵。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","你要把他带到祭司以利亚撒和全体会众面前，当着他们的面把手按在他的头上，宣告他是你的继承人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","你要分给他一部分权力，好让以色列人服从他。 ");
INSERT INTO cmn2006_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","他要站在祭司以利亚撒面前，而以利亚撒要用乌陵和土明为他求问主的旨意。他和以色列的全体会众都要遵照我的命令或出战或收兵。” ");
INSERT INTO cmn2006_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","摩西遵照主的命令行事。他把约书亚带到祭司以利亚撒和全体会众的面前，让他站在那里， ");
INSERT INTO cmn2006_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","然后，按照主的命令，把手按在约书亚的头上，宣告他是自己的继承人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“你晓喻以色列人：‘你们要谨慎，要按时向我献上我所喜悦的馨香的火祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","每天要献上两只一岁大没有残疾的公羊羔， ");
INSERT INTO cmn2006_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","早晨献一只，傍晚献一只， ");
INSERT INTO cmn2006_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","同时要献上用1升油调和2.2升上等面粉作的素祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","这是每天常例的烧化祭，是在西乃山首次献给我的火祭，这祭物的香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","还要随同每只羊羔献上1升酒作为奠祭，用醇酒浇奠圣所里的主。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","傍晚，要献上第二只羊羔，同时要象早晨一样献上素祭和奠祭；这祭物的香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘在安息日，要献上两只一岁大没有残疾的公羊羔，同时要献上相应的奠祭和4.4升用油调和上等面粉做的素祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","在安息日，除了要献上安息日的烧化祭外，还要献上常例的烧化祭及其奠祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘每月的初一日，要献上两头小公牛、一只公羊和七只一岁大的公羊羔作为烧化祭。这些祭牲应该是没有残疾的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","随同每只公牛要献上6.6升用油调和的上等面粉做的素祭，每只公羊要用4.4升素祭， ");
INSERT INTO cmn2006_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","每只羊羔要用2.2升素祭。这是献给我的烧化祭，是献给我作为食物的礼物，这祭物的香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","每只公牛要用2升酒作伴随奠祭，每只公羊用1.5升，每只羊羔用1升。这是每月初一日要献的烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","除了常例的烧化祭和奠祭外，每次还要献上一只公山羊作赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘正月十四日是主的逾越节。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","从正月十五日起，要为我守节，要连续七天吃无酵饼。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","在节期的第一天，你们要举行圣会，不可做任何工作， ");
INSERT INTO cmn2006_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","要向我献上两只公牛犊、一只公羊和七只一岁大的羊羔作为烧化祭，这些祭牲应该是没有残疾的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","要随同祭牲献上用油调和上等面粉做的素祭，每头公牛犊用6.6升，每只公羊用4.4升， ");
INSERT INTO cmn2006_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","每只羊羔用2.2升。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","此外，还要献上一只公山羊作赎罪祭为你们赎罪。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","24","在节期的七天之内，除了常例的烧化祭外，每天你们都要按这种方式重复向我献上烧化祭和奠祭，这祭物的香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","在节期的第七天，你们也要举行圣会，不可做任何工作。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘在七七收获节，你们要献上初熟的谷物。你们要举行圣会，不可做任何工作。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","你们要献上两头公牛犊、一只公羊和七只一岁大的公羊羔， ");
INSERT INTO cmn2006_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","同时，要献上用油调和上等面粉作的素祭。每头公牛犊用6.6升，每只公羊用4.4升， ");
INSERT INTO cmn2006_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","每只羊羔用2.2升。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","此外，还要献上一只公山羊为你们赎罪。 ");
INSERT INTO cmn2006_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","这些祭牲应该是没有残疾的。这是你们在常例的烧化祭和素祭之外要献的烧化祭及其奠祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“‘你们要在七月初一日举行圣会，不可做任何工作。你们要在那天吹响号筒， ");
INSERT INTO cmn2006_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","要向我献上一头公牛犊、一只公羊和七只一岁大的公羊羔作为烧化祭。这些祭牲应该是没有残疾的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","同时，要献上用油调和上等面粉做的素祭，每头公牛用6.6升，每只公羊用4.4升， ");
INSERT INTO cmn2006_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","每只羊羔用2.2升。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","此外，还要献上一只公山羊作赎罪祭为你们赎罪。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","这是除每月初一日的烧化祭、素祭和每天常例的烧化祭、素祭及其相应的奠祭以外要献的祭。这祭物的香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“‘你们要在七月初十日举行圣会，在这天，你们要禁食，不可做任何工作。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","你们要向我献上一头公牛犊、一只公羊和七只一岁大的公羊羔作为烧化祭。这些祭牲应该是没有残疾的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","同时，要献上用油调和上等面粉做的素祭。每头公牛用6.6升，每只公羊用4.4升， ");
INSERT INTO cmn2006_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","每只羊羔用2.2升， ");
INSERT INTO cmn2006_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","此外，还要献上一只公山羊作赎罪祭。这是除了为赎罪而献的祭和每天常例的烧化祭及素祭、其相应的奠祭以外要献的祭。这祭物的香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“‘你们要在七月十五日举行圣会，不可做任何工作。要为主守节七天。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","在这一天，你们要献上十三头公牛犊、二只公羊和十四只一岁大的公羊羔作为烧化祭，这些祭牲应该是没有残疾的。这是献作食物的礼物，这祭物的香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","同时，要献上用油调和上等面粉做的素祭，每头公牛用6.6升，每只公羊用4.4升， ");
INSERT INTO cmn2006_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","每只羊羔用2.2升。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","此外，还要献上一只公山羊作赎罪祭。这是除每天常例的烧化祭、素祭及相应的奠祭以外要献的祭。这祭物的香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","34","“‘从第二天起到第七天，除奉献的公牛犊逐天递减一头外，每天都要献上与第一天相同的祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","第八天，你们要举行圣会，不可做任何工作。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","你们要献上一头公牛，一只公羊和七只一岁大的公羊羔作为烧化祭，这些祭牲应该是没有残疾的。这是献作食物的礼物，这祭物的香味是我所喜悦的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","同时，要献上与每头公牛、每只公羊和每只羊羔相应的素祭和奠祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","此外，也要献上一只公山羊作赎罪祭。这是在每天常例的烧化祭、素祭及其相应的奠祭以外要献的祭。 ");
INSERT INTO cmn2006_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","以上是你们在为许愿和还愿所献的祭以外，在各个节日要向我献的烧化祭、素祭、奠祭和平安祭。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","摩西把主的吩咐一一告诉以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","摩西对以色列各支派的首领们说∶“主是这样吩咐的∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","‘如果有人向主许愿或是发誓，必须言出必行，不可食言。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","‘年轻女子还在父亲家里生活时许了愿或发了誓， ");
INSERT INTO cmn2006_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","如果她的父亲对此默认，她就要履行诺言。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","如果她的父亲听到后反对，她就不必遵守。主会宽恕她，因为她的父亲不准她这样做。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","‘假如她在婚前许了愿，不管是有意的还是无意的， ");
INSERT INTO cmn2006_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","如果她的丈夫在他知道的当天无所表示，她就要履行诺言。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","但如果她的丈夫在他知道的当天表示反对，废止了她的誓言或无意许诺，主会宽恕她。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","‘寡妇或离婚的女人所许的愿或发的誓都必须遵守。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","已婚的女人许了愿， ");
INSERT INTO cmn2006_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","如果她的丈夫知道后不表示反对，她就要履行诺言。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","如果她的丈夫在听说它们的当天废止了它们，那么她的一切许诺就都无效了。因为她的丈夫已经废止了这些诺言，主会宽恕她。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","‘丈夫可以承认或废止妻子许下的愿。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","如果丈夫知道了妻子所许的愿之后未作表示，那么她就要履行诺言，因为她的丈夫在他听到的当天默认了她许的愿。 ");
INSERT INTO cmn2006_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","如果她的丈夫在听到的那天之后的某个时候才废止这些诺言，那么他就要承受他的妻子应该承受的罪罚。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","这是丈夫与妻子，父亲与未嫁女儿之间要遵守的律例，是主颁给摩西的律例。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“你要惩罚米甸人，要让他们为对以色列人的所作所为付出代价。做完这件事以后，你就要离开人世，归回你的祖先。” ");
INSERT INTO cmn2006_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","于是，摩西命令民众∶“你们要派人备战，要去攻打米甸人，为主复仇。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","每个支派要派出一千人。” ");
INSERT INTO cmn2006_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","以色列各营各派出一千人，总兵力为一万二千人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","摩西派他们和祭司以利亚撒的儿子非尼哈一起出征。非尼哈随军带着圣物和发布信号的银号。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","他们按照主对摩西的命令攻击米甸人，杀死了所有的成年男子， ");
INSERT INTO cmn2006_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","包括五个米甸王∶以未、利金、苏珥、户珥、利巴。比珥的儿子巴兰也死于军中。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","以色列人俘虏了米甸人的妇女和儿童，抢走了他们的牲畜，掠走了他们的所有财物， ");
INSERT INTO cmn2006_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","烧毁了他们所有的城镇和营地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","以色列人带着战利品－包括人和牲畜， ");
INSERT INTO cmn2006_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","回到耶利哥对岸约旦河边摩押平原上的营地，把战利品交给摩西、祭司以利亚撒和以色列会众。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","摩西、以利亚撒和以色列的全体首领出营迎接他们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","摩西对从战场归来的军官们－即千夫长和百夫长－非常恼怒， ");
INSERT INTO cmn2006_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","说∶“你们为什么让这些女人活着？ ");
INSERT INTO cmn2006_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","就是她们听从巴兰的话，在毗珥引诱民众犯罪，背叛了主，致使瘟疫降在主的子民身上。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","现在，你们要杀掉所有的男孩和所有与男人性交过的女人， ");
INSERT INTO cmn2006_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","但可以为你们自己留下所有的处女。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","你们要在营外呆七天，你们或你们的俘虏中所有杀过人的人或接触过死尸的人都要在第三天和第七天洁净自己， ");
INSERT INTO cmn2006_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","也要洁净每一件衣服，以及所有用皮革、山羊毛和木头制造的东西。” ");
INSERT INTO cmn2006_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","祭司以利亚撒对参战的军人们说∶“主吩咐摩西的律例是这样的∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","金、银、铜、铁、锡、铅等火烧不坏的东西，必须经过火才算洁净，然而，仍然要用水洒在上面去洁净它。而其它不能用火烧的东西则要用水洗过才算洁净。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","在第七天，你们要洗涤衣服，洁净自己，然后，你们才可以进入营地。” ");
INSERT INTO cmn2006_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“你和以利亚撒以及会众的族长们要一起清点战利品，包括人和牲畜。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","然后，把战利品平分成两半，一半给出征的士兵，另一半给其余的会众。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","要从分给军队的那一半中－包括人和牲畜，抽出五百分之一归给主， ");
INSERT INTO cmn2006_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","把这些交给祭司以利亚撒作为献给主的奉献。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","要从分给以色列会众的那一半中－包括人和牲畜，抽出五十分之一，交给照管主的圣幕的利未人。” ");
INSERT INTO cmn2006_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","摩西和祭司以利亚撒遵照主的命令行事。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","兵士们掠来的战利品如下∶675000只羊，72000头牛；61000头驴；32000名处女。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","40","出征的军队所得的一半如下∶337500只羊，其中675只归给主；36000头牛，其中72头归给主；30500头驴，其中61头归给主；16000名处女，其中32名归给主。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","按照主的命令，摩西把归给主的奉献交给祭司以利亚撒。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","会众得到的那一半与军队得到的一样，也是337500只羊，36000头牛，30500头驴和16000名处女。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","按照主的命令，摩西把其中的五十分之一给了照管圣幕的利未人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","军队的各级军官－千夫长和百夫长－来见摩西， ");
INSERT INTO cmn2006_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","对他说∶“我们是你的仆人，我们已经清点了各自的部下，无一阵亡。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","现在，我们把所有夺来的臂镯、手镯、戒指、耳环、项琏都献给主，作为我们生命的赎价。” ");
INSERT INTO cmn2006_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","摩西和祭司以利亚撒收下了军官们献上的各种金饰品， ");
INSERT INTO cmn2006_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","约有两百多公斤重。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","兵士们都各自夺有战利品。 ");
INSERT INTO cmn2006_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","摩西和祭司以利亚撒把军官们献的金器带到圣幕，作为以色列人的纪念物献给主。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","吕便支派和迦得支派的牲畜很多。他们看见雅谢地和基列地适合放牧牲畜， ");
INSERT INTO cmn2006_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","就去见摩西和祭司以利亚撒及会众的首领们，说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“我们是你们的仆人，我们有很多牲畜。主为以色列会众征服了亚他禄、底本、雅谢、宁拉、希实本、以利亚利、示班、尼波、比稳等地区，那里是放牧牲畜的好地方。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","求你们把这块地给我们，作为我们的产业，不要叫我们到约旦河那边去。” ");
INSERT INTO cmn2006_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","摩西对他们说∶“难道你们要在这里住下来，而让你们的同胞去拼杀吗？ ");
INSERT INTO cmn2006_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","那里是主赐给以色列人的土地，你们为什么要涣散以色列人去那里的决心呢？ ");
INSERT INTO cmn2006_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","你们的祖先也曾象你们这样说过。当年，我从加底斯巴尼亚派他们去侦察那里， ");
INSERT INTO cmn2006_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","他们到了以实各谷，看见了那块土地，但是他们却使以色列人丧失了进入主赐给他们的那块土地的勇气。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","主因此在那天发怒，发誓说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘所有二十岁以上从埃及出来的人都不能进入我应许给亚伯拉罕、以撒和雅各的那块土地，因为他们没有一心跟从我； ");
INSERT INTO cmn2006_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","只有耶孚尼的儿子迦勒和嫩的儿子约书亚除外，因为他们一直一心一意地追随我。’ ");
INSERT INTO cmn2006_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","主一怒而使以色列人在旷野里流浪了四十年，直到所有那些冒犯主的人都死光了为止。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","现在，你们这些罪人哪，你们继承了父业，竟要加重主对以色列的怒气吗？ ");
INSERT INTO cmn2006_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","如果你们背叛主，他就会更长久地把以色列丢弃在旷野里，那样一来，你们就毁掉了这个民族了。” ");
INSERT INTO cmn2006_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","17","吕便支派和迦得支派的人走近摩西，对他说∶“首先，请准许我们在这儿为我们的牲畜盖好圈棚，并为我们的妻儿建起坚固的城池，让她们住进去，因为这里还有本地人。然后，我们就集合起来，作我们以色列兄弟的前驱，直到把他们带到他们的应得之地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","等到所有的人都有了应得之地作自己的产业之后，我们再返回自己的家园。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","我们不再跟他们在约旦河彼岸同受产业，因为我们已经接受了约旦河东岸的这份产业了。” ");
INSERT INTO cmn2006_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","摩西对他们说∶“如果你们能象你们所说的那样，按照主的旨意整装出征， ");
INSERT INTO cmn2006_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","派出所有能召集到的人为你们渡河参战，直到主击败了他的仇敌， ");
INSERT INTO cmn2006_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","征服了那块土地为止，那么，你们就算对主和以色列尽了你们应尽的义务，主会认可这块土地归你们作为产业。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","但是，如果你们违背诺言，你们就得罪了主，必定要为此承受罪罚。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","现在，去为你们的妻儿营造城镇，为牲畜搭盖圈棚，做你们所说过的一切吧！” ");
INSERT INTO cmn2006_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","迦得支派和吕便支派的人说∶“阁下，我们是你的仆人，一定遵照你的命令去做。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","我们的妻儿和牲畜留在基列地， ");
INSERT INTO cmn2006_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","而所有战士都将在主的面前渡过约旦河，按照你－我们的主人的命令参战。” ");
INSERT INTO cmn2006_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","摩西就这件事通报祭司以利亚撒、嫩的儿子约书亚和各支派的族长， ");
INSERT INTO cmn2006_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","对他们说∶“如果迦得支派和吕便支派的战士和你们一起在主的面前渡过约旦河参战，共同征服那块土地，那么，你们要把基列地给他们作为产业。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","如果他们不肯和你们同去，那么他们就只能在迦南地和你们一起接受产业。” ");
INSERT INTO cmn2006_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","迦得支派和吕便支派的人说∶“主吩咐我们－你的仆人做什么，我们就做什么。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","我们所有的战士都将在主的面前渡河进入迦南地作战，但我们的产业将在约旦河的那一边。” ");
INSERT INTO cmn2006_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","于是，摩西把亚摩利王西宏和巴珊王噩的国土，包括所有的城市及其周围的村镇，全部分给了迦得支派、吕便支派和玛拿西半支派。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","迦得支派重建了底本、亚他禄、亚罗珥、 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","亚他禄朔反、雅谢、约比哈、 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","伯宁拉、伯哈兰诸城，加固了城防，又为牲畜搭盖了圈棚。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","吕便支派重建了希实本、以利亚利、基列亭、 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","尼波、巴力免、西比玛诸城；尼波城和巴力免城是重新命名的，其余的城仍然沿用原先的名字。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","玛拿西的儿子玛吉侵入基列，占领了它，赶走了当地的亚摩利人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","于是，摩西把基列地给了玛吉宗族，他们就定居在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","玛拿西的儿子睚珥占领了基列地的村庄，把它们命名为“睚珥村”。 ");
INSERT INTO cmn2006_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","挪巴占领了基纳及其周围的村镇，以自己的名字命名为挪巴。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","以下是以色列人在摩西和亚伦的带领下，以军队的编制离开埃及后的行军路程。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","摩西遵照主的命令把沿途的扎营地一一记录下来。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","正月十五日，也就是逾越节的第二天，以色列人当着全体埃及人的面昂然离开了埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","那时，埃及人正忙于埋葬他们被主击杀的长子－主以此惩戒了埃及人的神明。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","以色列人离开兰塞，在疏割安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","由疏割启程，在旷野边缘的以倘安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","由以倘启程，返回巴力洗分东面的比哈希禄，在密夺附近安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","由比哈希禄启程，取道红海到书珥旷野，又在伊坦旷野里走了三天的路程，在玛拉安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","由玛拉启程，在以琳安营，那里有十二股泉水和七十棵棕树； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","由以琳启程，在红海附近安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","由红海启程，在寻旷野安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","由寻旷野启程，在脱加安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","由脱加启程，在亚禄安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","由亚禄启程，在利非订安营，他们在那里没有找到水喝； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","由利非订启程，在西乃旷野安营； ");
INSERT INTO cmn2006_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","36","从西乃旷野到寻旷野，他们沿途在以下各地安营∶基博罗哈他瓦、哈洗禄、利提玛、临门帕烈、立拿、勒撒、基希拉他、沙斐山、哈拉大、玛吉希录、他哈、他拉、密加、哈摩拿、摩西录、比尼亚干、曷哈及甲、约巴他、阿博拿、以旬迦别、寻旷野；寻旷野就是加底斯。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","他们离开加底斯，来到以东边境上的何珥山， ");
INSERT INTO cmn2006_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","祭司亚伦遵照主的命令登上何珥山，就死在这里。这是以色列人离开埃及四十年后的五月初一日。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","亚伦享年123岁。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","在南地立国的迦南王亚拉得得悉以色列人远道而来－ ");
INSERT INTO cmn2006_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","49","他们从何珥山启程，沿途在下述各地安营∶撒摩拿、普嫩、阿伯、摩押边界上的以耶亚巴琳、底本迦得、亚门低比拉太音、尼波附近的亚巴琳山，最后来到耶利哥对岸约旦河边的摩押平原，在摩押平原上沿河岸从伯耶施末到亚伯什亭扎下营地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","主在耶利哥对岸约旦河边的摩押平原上对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“你晓喻以色列人∶‘当你们渡过约旦河进入迦南地之后， ");
INSERT INTO cmn2006_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","要赶走当地的居民，要毁掉他们的一切石雕和铸造的偶像，要夷平他们的邱坛。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","然后，你们要占领那里，在那里定居下来，因为我已经把那里赐给了你们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","你们要按照家族的大小拈阄分地，人多的多分，人少的少分，应得之地由拈阄的结果决定，要按照支派接受应得之地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","但是，如果你们不驱赶当地的居民，他们就会象你们眼中的刺，胁下的棘；他们会在你们的居住之地扰害你们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","那时，我就会象以往怎样对待他们一样对待你们。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“你晓喻以色列人∶‘你们进入迦南地后，整个迦南地的疆土都将归你们作为产业。 ");
INSERT INTO cmn2006_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","南部边界从寻旷野沿着以东的边界延伸，东起死海的南端， ");
INSERT INTO cmn2006_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","南至亚克拉滨隘口，穿过寻旷野，至加底斯巴尼亚，再到哈萨亚达，穿过押扪， ");
INSERT INTO cmn2006_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","转向埃及河，到地中海为止。 ");
INSERT INTO cmn2006_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","西部以地中海为界。 ");
INSERT INTO cmn2006_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","北部边界从地中海延伸到何珥山， ");
INSERT INTO cmn2006_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","再到哈马隘口，然后延伸到西达达， ");
INSERT INTO cmn2006_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","再到西斐仑，至哈萨以难为止。 ");
INSERT INTO cmn2006_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","东部边界从哈萨以难延伸到示番， ");
INSERT INTO cmn2006_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","然后向南延伸到亚延东边的利比拉，再到加利利湖东岸的丘陵地带， ");
INSERT INTO cmn2006_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","沿约旦河南至死海为止。以上是你们将拥有的土地的疆界。’” ");
INSERT INTO cmn2006_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","于是，摩西传达了主的命令，向以色列人宣布∶“这就是你们要拈阄瓜分的土地。主命令把它分给九个半支派， ");
INSERT INTO cmn2006_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","因为吕便支派、迦得支派和玛拿西半支派已经按照家族世系分得了产业， ");
INSERT INTO cmn2006_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","这两个半支派已经在耶利哥对岸的约旦河东岸得到了他们的应得之份。” ");
INSERT INTO cmn2006_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“祭司以利亚撒和嫩的儿子约书亚要为你们主持分地， ");
INSERT INTO cmn2006_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","还要从每个支派中选派一名首领协助他们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","这些人是∶ 犹大支派－耶孚尼的儿子迦勒； ");
INSERT INTO cmn2006_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","西缅支派－亚米忽的儿子示母利； ");
INSERT INTO cmn2006_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","便雅悯支派－基斯伦的儿子以利达； ");
INSERT INTO cmn2006_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","但支派－约利的儿子布基； ");
INSERT INTO cmn2006_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","24","约瑟的后代： 玛拿西支派－以弗的儿子汉聂； 以法莲支派－拾弗但的儿子基母利； ");
INSERT INTO cmn2006_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","西布伦支派－帕纳的儿子以利撒番； ");
INSERT INTO cmn2006_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","以萨迦支派－阿散的儿子帕铁； ");
INSERT INTO cmn2006_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","亚设支派－示罗米的儿子亚希忽； ");
INSERT INTO cmn2006_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","拿弗他利支派－亚米忽的儿子比大黑。” ");
INSERT INTO cmn2006_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","以上是主选派为以色列人分配迦南地的人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","主在耶利哥对岸约旦河边的摩押平原对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“你吩咐以色列人，要他们从所得到的产业中分一部分城镇及其周围的牧场给利未人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","这些城镇要归利未人居住，城郊的牧场要归他们牧养牲畜。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","5","从城墙的四围各自向外延伸四百五十米作为城郊的牧地，即以城为中心，东南西北四周每边各长九百米；这是他们城镇的牧场。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","除了你们要分给利未人的四十二座城以外，还要再给他们六座城作为庇护城，好让那些误伤人命的人可以逃到那里去寻求庇护。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","这样，你们一共要给利未人四十八座城，每座城的城郊都要有相应的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","各支派要根据分得产业的多少分出一部分城来给利未人，产业多的多出，产业少的少出。” ");
INSERT INTO cmn2006_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“你吩咐以色列人，让他们渡过约旦河进入迦南地以后， ");
INSERT INTO cmn2006_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","要为自己选定庇护城，好让那些因过失杀人的人可以逃到那里去寻求庇护， ");
INSERT INTO cmn2006_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","躲避死者的亲属前来寻仇，使他不致在未经全体会众公审前被杀。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","他们要选定六座城作为庇护城， ");
INSERT INTO cmn2006_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","三座在约旦河东岸，三座在约旦河西岸的迦南地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","任何误伤人命的人，无论是以色列人还是寄居的外侨，都可以逃到这六座城去寻求庇护。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“如果有人用铁器打人而致死，他就犯了故意杀人的罪，必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","18","如果有人用可以致人死命的石块或木器打人而致死，他也犯了故意杀人的罪，必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","死者的亲属要亲自处死凶手；一旦发现他，就要把他置于死地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","如果有人因嫌怨故意把人摔倒而致死，或扔东西砸死了那人， ");
INSERT INTO cmn2006_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","或动手打死了那人，他就犯了故意杀人的罪，必须处死。死者的亲属一旦发现他，就要把他置于死地。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“但是，如果有人无意而不是出于仇恨推倒了对方，或无意间扔东西砸了人， ");
INSERT INTO cmn2006_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","或是在没有看见对方的情况下扔可以致人死命的石头，砸了他人并至死亡，而这人并非他的仇敌，他也无意要伤害他， ");
INSERT INTO cmn2006_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","这时，会众就要依据这些律例为杀人者和死者的亲属裁决。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","要把杀人者送回他逃往的庇护城里，使他不致被寻仇者所杀。他必须住在那里，直至现任大祭司去世。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“但是，如果他在这期间离开了庇护城， ");
INSERT INTO cmn2006_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","被死者的亲属发现，那么死者的亲属就可以杀死他而不必承担杀人的罪责。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","因为他本该住在庇护城里，直到现任的大祭司死后才能返回家乡。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","这是你们世世代代要遵守的法律。无论住在哪里，你们都要遵行不误。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“如果有人被控杀人，必须要有人证才可以判处死刑。但在只有一个人证的情况下不可以判处死刑。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","被判处死罪的人必须伏法，不准用钱赎命。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","住在庇护城里的人不准用钱赎身以获准在大祭司死前移居别处， ");
INSERT INTO cmn2006_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","否则，杀人者就玷污了你们住的这块土地；因为被杀人者玷污的土地是无物可赎的－除非是杀人者的血。 ");
INSERT INTO cmn2006_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","你们决不可玷污你们所住的这块土地，因为我就住在你们中间，我是主。” ");
INSERT INTO cmn2006_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","基列是玛吉的儿子、玛拿西的孙子、约瑟的重孙。基列宗族的族长们来见摩西和众首领－以色列各家族的族长们， ");
INSERT INTO cmn2006_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","说∶“先生，主命令你们用拈阄的方法把地分给以色列人，还命令你们把我们亲属西罗非哈的应得之份分给他的女儿们。 ");
INSERT INTO cmn2006_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","可是，如果她们嫁给其他以色列支派的人，她们的那一份产业就要从我们祖传的产业中减除，加到她们所嫁的那个支派的产业里，这样一来，我们拈阄所得的产业就有一部分要被带走了。 ");
INSERT INTO cmn2006_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","到了以色列人的禧年，她们的产业就要归她们所嫁的那个支派所有，我们就失去了这一份土地。” ");
INSERT INTO cmn2006_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","于是，摩西遵照主的训示向以色列人颁布命令，说∶“约瑟后裔的话是对的。 ");
INSERT INTO cmn2006_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","主对西罗非哈的女儿们的命令是这样的∶她们可以自由择配，但只能嫁给本支派的人。 ");
INSERT INTO cmn2006_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","每个以色列人的产业必须留在本支派内，不可以转到其他支派去。 ");
INSERT INTO cmn2006_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","在以色列的各支派中，任何继承了产业的女子必须嫁给本支派的人，以便以色列人能世代相传祖宗的基业， ");
INSERT INTO cmn2006_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","不致转入其他支派；每个支派都要守住自己的产业。” ");
INSERT INTO cmn2006_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","西罗非哈的女儿们遵照主的吩咐行事。 ");
INSERT INTO cmn2006_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","玛拉、得撒、曷拉、密迦、挪阿都嫁给了她们的堂兄弟， ");
INSERT INTO cmn2006_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","在玛拿西支派内成婚；因此，她们的产业依然留在同宗的支派内。 ");
INSERT INTO cmn2006_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","以上是主在耶利哥对岸约旦河边的摩押平原上藉摩西颁给以色列人的诫命和律例。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","以下记载的是摩西在约旦河东岸的旷野里对全体以色列人所说的话，这些话是摩西在座落于巴兰旷野与陀弗、拉班、哈洗录、底撒哈诸城之间的疏弗城对面的约旦河谷中说的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","从何烈山经由西珥山到加低斯巴尼亚需要十一天的旅程。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","以色列人出埃及后的第四十年的十一月一日，摩西按照主的命令晓喻以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","那时，摩西已经击败了统治希实本的亚摩利王西宏和统治亚斯他录及以得来的巴珊王噩， ");
INSERT INTO cmn2006_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","他决定在约旦河东岸的摩押地详细讲解主的律法。 摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“主－我们的上帝在何烈山曾对我们说∶‘你们在这山已经住得够久了， ");
INSERT INTO cmn2006_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","现在，你们要启程前往亚摩利人占据的山地及其附近所有地区，即约旦谷、丘陵地带、西部高原、南地和地中海沿岸，也就是迦南地、黎巴嫩直至幼发拉底河流域的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","看，我就要把这块土地赐给你们了，去占领这块土地吧！主以誓言应许过你们的祖先－亚伯拉罕、以撒和雅各，要把它赐给他们和他们的后代。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“那时，我对你们说过∶‘我独自一人 担 当 不 起 管理你们的 重 任， ");
INSERT INTO cmn2006_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","主－你们的上帝使你们壮大起来。今天，你们的人口多如天上的繁星。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","愿主－你们祖先的上帝使你们的人口再增加千倍，按照他对你们的应许赐福给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","但是，我一个人无法承担起管理你们事务和为你们排解纠纷的责任。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","因此，你们要为各支派推选出一些有智慧、有才干、有经验的人来，由我委派他们做你们的首领。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","“你们回答说∶‘你说的办法很好，就这样办吧！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","“于是，我把各支派推选出的这些精明干练的人集合起来，委派他们做各个支派的千夫长、百夫长、五十夫长、十夫长和其他长官来管理你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“当时，我告诫你们的法官∶‘你们要为你们的同胞排解纠纷。无论是邻里纠纷还是牵涉外侨的讼案，都要秉公审理， ");
INSERT INTO cmn2006_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","不可徇私偏袒，无论当事人贵贱贫富，都要公平地听取他们的申诉。你们不要怕任何人，因为你们是在替上帝主持审判。如果你们遇到确实难于处理的案件，可以呈送到我这里来，由我亲自处理。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","当时，我把所有该做的事都指示了你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“我们遵从主－我们上帝的命令，从何烈山启程，经过你们亲眼目睹的那片可怕的大旷野，向亚摩利人占据的山地进发，到了加低斯巴尼亚。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","我对你们说∶‘现在，你们已经到了亚摩利人占据的山地，这里就是主－我们的上帝要赐给我们的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","看哪，主－你们的上帝已经把这块土地交给了你们。你们要遵照主－你们祖先的上帝对你们的应许去占领这块土地，不要害怕，不要畏缩不前。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“你们都来到我的面前，对我说∶‘让我们派人先去侦察一下，叫他们回来报告该走的路线和可以攻占的城镇。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“我认为这主意很好，就从每个支派各挑选一人，一共选出十二个人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","他们进入山区，到了以实各谷，对那一地区进行了侦察。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","他们采集了当地的果子，带回来给我们看，并向我们报告了那里的情况。他们说∶‘主－我们的上帝要赐给我们的那块土地是一块肥美的土地。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“但你们却不肯进占那块土地，违背了主－你们的上帝的旨意。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","你们在帐蓬里发怨言，说∶‘主恨我们！他把我们领出埃及，就是要把我们交给亚摩利人，让他们杀死我们！ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","我们怎么能到那里去！探子们的报告已经把我们吓坏了！他们说，那里的居民比我们高大，城又大又坚固，城墙高得顶天。我们还在那里看见了亚衲族的巨人！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“我对你们说∶‘不要惊恐，也不要怕他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","31","因为主－你们的上帝将在你们的前面为你们争战，就象他在埃及和在旷野里为你们所做的一样。你们亲眼看见了主－你们的上帝怎样象父亲带领自己的儿子一样，把你们一路护送到这里的。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","“但是，你们在这件事上就是不肯信靠主－你们的上帝！ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","是他在路上为你们寻找安营之地，夜间他在火里，白天他在云里，为你们指明应当走的路。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“主听见了你们的怨言，非常愤怒，他发誓说∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘这邪恶的一代谁也不能看到我应许赐给你们祖先的那肥美之地！ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","只有耶孚尼的儿子迦勒可以看到它，我将把他足迹所及之处都赐给他和他的子孙，因为他一心一意跟随着主。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","“由于你们的缘故，主对我发怒，说∶‘就是你也不能进入那块土地， ");
INSERT INTO cmn2006_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","但你的助手、嫩的儿子约书亚可以到那里去。你要鼓起他的勇气，因为他将率领以色列人占领那块土地，并把它做为他们自己的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","只有你们那些今天还不辨是非的孩子才能到达那里，据有那块土地。你们以为他们会被人掳去，而我恰恰要把那块土地赐给他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","现在，你们要转回头，沿着去红海的路回到旷野里去！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“你们答道∶‘我们得罪了主；现在，我们情愿遵从主－我们上帝的命令，去攻打那里！’于是，你们整装备战，以为可以轻易攻上山去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“主对我说∶‘你警告他们不要去进攻，因为我不与他们同在；他们如果不听我的警告，必将死在敌人的刀下。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","“我把主的话告诉你们，你们却不肯听。你们不顾主的警告，擅自向山地进军。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","占据山地的亚摩利人蜂拥出战，攻击你们，追杀你们，从西珥一直追到何珥玛。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","你们败退回来，在主的面前哭求；然而主不理睬你们，不听你们的求告。 ");
INSERT INTO cmn2006_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","就这样，你们在加低斯度过了一段漫长的日子。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“此后，遵照主给我的命令，我们转而沿着去红海的路向旷野进发。我们沿西珥山地绕行了许多天。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","后来，主对我说∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘你们已经沿山地绕行够久了，现在应该转向北去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","你要吩咐你的人民∶“你们的亲族－以扫的后代，就住在西珥，你们要越过他们的边界。虽然他们畏惧你们，你们也要格外谨慎， ");
INSERT INTO cmn2006_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","不要跟他们发生争端；因为我已经把西珥山地赐给以扫作为他的产业，不会再把他们的任何土地赐给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","你们要向他们买粮吃，甚至也要买水喝； ");
INSERT INTO cmn2006_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","而在以往四十年里，主－你们的上帝一直与你们同在，他在这大旷野里照看你们，在你们所做的每一件事上都赐福给你们，使你们一无所缺。”’ ");
INSERT INTO cmn2006_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“就这样，我们沿着从约旦谷通往以拉他和以旬迦别的路，越过我们的亲族－住在西珥的以扫的后代的领地，转而沿着通往摩押旷野的路前进。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","“主对我说∶‘你们不要打扰摩押人，也不要跟他们发生争端。因为我已经把亚珥赐给了罗得的后代作为他们的产业，不会再把他们的任何土地赐给你们。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","（以米人以前曾住在亚珥，他们人数众多，非常强悍，身材象亚衲人一样高大。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","他们跟亚衲人一样被称为利乏音人，但摩押人称他们为以米人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","何利人以前也住在西珥；以扫的后代赶走了他们，消灭了他们，在他们的土地上定居下来，就象后来以色列人从主赐给他们的土地上赶走原先的居民一样。） ");
INSERT INTO cmn2006_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“主说∶‘去吧，越过撒烈溪去！’于是，我们越过了撒烈溪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","我们从离开加低斯巴尼亚直到越过撒烈溪，一共用了三十八年的时间。在这段时间里，当年在加低斯巴尼亚不信靠上帝的整整一代将士都已经死尽，正如主对他们发的誓一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","主不断地敌对他们，直到把他们从营中完全清除掉为止。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“当所有这些将士都从以色列人中死尽以后， ");
INSERT INTO cmn2006_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","主对我说∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘现在，你们要由亚珥城越过摩押边境。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","当你们接近亚扪人的时候，不要向他们寻衅，也不要跟他们发生争端；因为我已经把亚扪人的土地赐给了罗得的后代作为他们的产业，不会再把他们的任何土地赐给你们。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","（这块土地也叫利乏音地，因为以前利乏音人曾经住在那里，亚扪人叫他们散送冥人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","他们人数众多，非常强悍，身材也象亚衲人一样高大。但是主为亚扪人消灭了他们，让亚扪人夺取了他们的土地，并在那里定居下来， ");
INSERT INTO cmn2006_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","正如主为住在西珥的以扫的后代消灭了何利人，让以扫的后代夺取了他们的土地，在那里一直居住到现在一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","同样，迦斐托的迦斐托人消灭了住在迦萨附近的亚卫人，夺取了他们的土地，并在那里定居下来。） ");
INSERT INTO cmn2006_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“主说：‘去吧，越过亚嫩河去！我已经把希实本的亚摩利王西宏交在你们的手中。你们要攻打他，夺取他的国土。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","从现在起，我要使你们以死亡和恐怖横行天下，人们听到你们的风声都会吓得浑身发抖！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“我从东部旷野派使者去见希实本王西宏，倡议和解，对他说∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘请准许我们经过你的领土。我们只在大路上行进，决不偏离大路左右。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","我们用银子向你买东西吃，买水喝，只希望你能准许我们徒步穿过你的国境， ");
INSERT INTO cmn2006_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","就象住在西珥的以扫的后代和住在亚珥的摩押人接待我们那样，好让我们渡过约旦河，到主－我们的上帝赐给我们的地方去。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","“但是，希实本王西宏拒绝我们穿越他的领土。这是因为主－你们的上帝使他顽梗不化，好把他交在你们的手中，正如今天的情形一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","“于是，主对我说∶‘看！我已经把西宏和他的国土都交给你了！去占领这块土地吧，把它据为你们自己的产业。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“西宏率众在雅杂城跟我们会战。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","主－我们的上帝把他交给了我们。我们杀死了西宏和他的儿子们，消灭了他的军队， ");
INSERT INTO cmn2006_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","占领了所有的城市，杀光了城里的男女老幼，没有留下一个活口， ");
INSERT INTO cmn2006_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","只留下了牲畜和从城中掠得的财物作为战利品。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","主－我们的上帝把所有的城都交给了我们，从亚嫩谷边缘的亚罗珥，包括谷中的城，直至基列一带，所有的城全被我们攻下。 ");
INSERT INTO cmn2006_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","但遵照主－我们的上帝的命令，你们没有接近亚扪人的领土，包括雅博河流域和山区的诸城。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“随后，我们转而向巴珊进发。巴珊王噩率众在以得来跟我们会战。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","主对我说∶‘不要怕他们，我已经把巴珊噩王和他的臣民、他的国土都交在你的手中，你要象对待希实本的亚摩利王西宏一样对待他。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“主－我们的上帝把巴珊王噩和他的军队交在我们的手中，我们把他们杀得一个不剩。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","我们攻占了巴珊王国在亚珥歌伯地区的所有六十座城，连一个村镇都没能从我们的手下逃脱。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","这些城都是设防城，有高大的城墙、城门和铁的门闩。此外，还有许多没有城墙的城镇。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","我们象对待希实本王西宏一样，彻底毁灭了这一切。我们夷平了他们的城市，杀光了城中的男女老幼， ");
INSERT INTO cmn2006_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","只留下牲畜和从城中掠得的财物作为战利品。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“就这样，我们占领了约旦河东岸两个亚摩利王从亚嫩谷直到黑门山的国土。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","（西顿人叫黑门山“西连”，而亚摩利人叫它“示尼珥”。） ");
INSERT INTO cmn2006_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","包括高原上的所有城镇、基列全境、巴珊全境，直至噩王朝在巴珊地区的撒迦城和以得来城。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","巴珊王噩是最后一个利乏音人。（他有一个铁制的床，长四米，宽两米。这床现在依然存放在亚扪人的拉巴城里。） ");
INSERT INTO cmn2006_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“我们夺取了这片土地后，把它归为自己的产业。从亚嫩谷边缘的亚罗珥起，我把基列山区的一半及其城镇分给了吕便人和迦得人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","基列的其余地区和噩王国内的巴珊全境则分给了玛拿西半支派（即整个亚珥歌伯地区，也就是巴珊地区在噩王国内的部分，又叫利乏音地）。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","玛拿西支派的睚珥占领了直至基述人和玛迦人边界的整个亚珥歌伯地区，他以自己的名字命名这里的巴珊城镇，这些城镇至今仍然叫做睚珥城。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","“我把基列分给了玛吉； ");
INSERT INTO cmn2006_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","把从基列到亚嫩谷，以谷的中部为界，直到跟亚扪人交界的雅博河的这一地区分给了吕便人和迦得人； ");
INSERT INTO cmn2006_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","其西部边界是亚拉巴和约旦河，从加利利湖到毗斯迦山以西的死海。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“当时，我曾命令你们∶‘主－你们的上帝已经把这块土地赐给了你们，作为你们自己的产业。你们全体应召而来的战士要整装备战，做你们的同胞－以色列人的先锋，渡过约旦河， ");
INSERT INTO cmn2006_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","只有你们的妻儿和牲畜可以留在我分给你们的城镇里（我知道你们有很多牲畜）。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","直到主象把安宁赐给你们一样把安宁也赐给了你们的同胞，使他们占有了主－你们的上帝要赐给他们的约旦河彼岸的土地，那时，你们才可以返回我分给你们的土地去。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","“然后，我指示约书亚，说∶‘你已经亲眼看见主－你的上帝对这两个王所做的一切。主将以同样的方式处置你即将进占的所有王国。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","不要畏惧他们，因为主－你们的上帝将为你们而战。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“当时，我向主祈求∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘至高的主啊，你才刚刚开始向我－你的仆人显示你的大能和伟大。天地间没有任何其他神明能象你那样行事，能有你那样大能的作为。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","主啊！求你让我越过约旦河，看一看那块美好的土地，看一看那壮丽的山地和黎巴嫩的山山水水。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","“但是，由于你们的缘故，主向我发怒，不听我的祈求。他对我说∶‘够了，别再跟我提这件事了！ ");
INSERT INTO cmn2006_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","你到毗斯迦山的山顶上去吧！从那里向四面眺望，你可以看见这一切，但是你不能过约旦河。 ");
INSERT INTO cmn2006_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","你要指导约书亚，坚定他的信心，鼓起他的勇气，因为他将率领人民渡河，让他们去占领你所看到的那块土地。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","“就这样，我们停留在伯毗珥对面的山谷里。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“以色列人哪，你们要听从我现在教导你们的律法和条例，这样你们才能生存，才能进入并占领主－你们祖先的上帝赐给你们的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","你们不可增删我给你们的任何命令，这样你们才能守住我颁给你们的主－你们的上帝的诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","“你们都看见了主在巴力毗珥的作为，看见了主－你们的上帝怎样消灭了你们中间那些追随异神巴力毗珥的人， ");
INSERT INTO cmn2006_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","而你们这些信靠主－你们的上帝的人至今依然活着。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“看！我已经象当年主－我的上帝教导我一样，把他的律法和条例都教给了你们，好让你们能在将要进占的土地上遵行这一切。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","你们务必要谨守这些律法，因为它们将是你们有别于其他民族的聪明和智慧的见证。那些人听到这些律法，一定会说∶‘这真是一个充满聪明和智慧的伟大的民族。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","“哪一个大国跟它的神明能象主－我们的上帝跟我们那样如此接近，我们可以随时向他呼求？ ");
INSERT INTO cmn2006_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","哪一个大国的律法和条例能象我今天教给你们的那样公正？ ");
INSERT INTO cmn2006_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","你们要谨慎自重，在你们的有生之年不可忘记你们曾经亲眼目睹的一切，不可将它们淡忘。你们一定要把这一切传于你们的子子孙孙。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","你们不可忘记当年你们在何烈山站在主－你们的上帝的面前时看到的一切。当时，主对我说∶‘你把民众集合到我面前来，我要让他们听听我的话，好让他们懂得终生敬畏我，并以此教导他们的子孙。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","你们都来了，站在山脚下。山上火焰冲天，云迷雾绕，幽暗重重。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","主从火中向你们讲话了，你们听得见说话的声音，却看不见任何形象，空中只传来一个声音。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","主向你们宣布了他的约的条款，也就是《十诫》，命令你们遵守它，并把这十条诫命写在两块石版上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","当时，主命令我把这些律法和条例教给你们，好让你们在即将渡过约旦河进占的那块土地上切实遵行。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“主在何烈山上从火中向你们讲话时，没有让你们看见任何形象，就是要你们格外谨慎， ");
INSERT INTO cmn2006_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","18","不可为自己造任何形象的偶像－无论是男身还是女身，无论是飞禽走兽还是地上的爬虫或水中的游鱼，以免你们因此犯罪而毁灭了你们自己。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","你们要格外谨慎，免得在观望天空中主－你们的上帝为万民摆设的日月星辰时受到诱惑，侍奉它们，向它们跪拜。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","主拣选了你们，把你们从象熔铁炉一样的埃及领了出来，就是要让你们做他的子民，就象今天这样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","“由于你们的缘故，主对我发怒，他发誓不许我越过约旦河，不许我进入那块主－你们的上帝将赐给你们作为产业的肥美之地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","我将死在这里。我不能渡过约旦河，但你们将渡过约旦河去占领那块富饶的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","你们要谨慎，不要忘记了主－你们的上帝跟你们所立的约，不要为自己造主－你们的上帝所禁止的任何形状的偶像， ");
INSERT INTO cmn2006_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","因为主－你们的上帝是炽烈的火焰，他是妒嫉的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“当你们在那里长久居住下来，有了子孙以后，如果你们行为堕落，造了任何形状的偶像，做了主所憎恶的事而惹他发怒， ");
INSERT INTO cmn2006_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","那么，今天我要让天地作证诅咒你们∶你们将不能在那块你们即将渡河进占的土地上长久居住，而很快被完全毁灭。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","主将把你们驱赶到列国之中，只有少数人能在被主送去的地方存活下来。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","在那里，你们要向人手制作的神像跪拜，这些用石头和木头做成的神像，既不能看也不能听，不会吃东西也不会闻气味。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","在那里，你们一定会寻求主－你们的上帝。如果你们专心一意地寻求，你们就会找到他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","将来，当你们遭受苦难的时候，你们终将会回到主－你们的上帝的身边去聆听他的声音。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","因为主－你们的上帝是仁慈的上帝，他不会丢下你们，也不会毁灭你们；他不会忘记以自己的誓言与你们祖先立下的约。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“早在你们出生以前，追溯到上帝在地上初创人类的时候，查遍全世界，有谁见过或听说过这样伟大的事？ ");
INSERT INTO cmn2006_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","哪一个民族能象你们一样，听见上帝在火中说话的声音而依然活着？ ");
INSERT INTO cmn2006_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","哪一个神明能象主－你们的上帝在埃及为你们所做的那样，用他的大能力，用他对民众的考验，用他显露的征兆和施行的神迹，用战争，用他那令人可畏的作为，亲手把一个民族从另一个国家中解救出来？ ");
INSERT INTO cmn2006_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","显现在你们面前的这一切就是要让你们知道，只有主才是真正的上帝，除他以外，再没有别的神。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","主让你们听见他从天上发出的声音，让你们看见他在地上的伟大的火并听见他在火中说的话，就是要以此来教导你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","“他喜爱你们的祖先，因此，他拣选了他们的后代，并以自己的大能亲自把你们领出埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","他这样做就是要赶走你们面前那些比你们强大的民族，把你们领进他们的国土，并把这土地赐给你们作为你们的产业，正如今天你们见到的情形一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","“所以，你们现在应当牢牢记住主是天地间真正的上帝，此外没有别的神。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","你们要谨守我今天教导你们的主的一切条例和诫命，这样，你们和你们的后代才能繁荣，才能长久居住在主－你们的上帝要赐给你们作为永久产业的这块土地上。” ");
INSERT INTO cmn2006_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","摩西在约旦河东岸指定三座城作为庇护城。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","如果有人误伤人命而并非跟被害人有宿怨，那么，这人可以逃到其中任何一座城中去避难。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","这三座城是∶属于吕便支派的旷野高原上的比悉城；属于迦得支派的基列的拉末城；属于玛拿西支派的巴珊的哥兰城。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","以上是摩西对以色列人的教诲。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","46","当以色列人出了埃及，来到约旦河彼岸，击败了统治希实本的亚摩利王西宏以后，在西宏王国境内的伯毗珥城对面的山谷中，摩西向以色列人颁布了以下律法、条例和规定。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","当时，以色列人已经占领了约旦河东岸两个亚摩利王－亚摩利王西宏和巴珊王噩的国土。 ");
INSERT INTO cmn2006_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","这片土地起自亚嫩谷边缘的亚罗珥，直至西连山（即黑门山）， ");
INSERT INTO cmn2006_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","还包括约旦河东岸南至死海、东至毗斯迦山山脚的整个约旦河谷。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","摩西把全体以色列人召集起来，对他们说∶“以色列人哪，你们要留心听取我今天向你们颁布的律法和条例。你们要认真研习并切实遵守这些律法和条例。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","主－我们的上帝跟我们在何烈山立了约， ");
INSERT INTO cmn2006_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","这是他跟我们这些今天还活着的人立的约，而不是跟我们的祖先立约。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","主曾在何烈山上从火中面对面地向你们讲话； ");
INSERT INTO cmn2006_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","那时，我站在主和你们中间，把主说的话告诉你们，因为你们怕那火，没有上山。主说∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","‘我是主－你们的上帝，你们在埃及受人奴役，是我把你们从那里领了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“‘除我以外，你们不可有别的神。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“‘你们不可模仿天上、地上或水里的任何形像为自己造任何偶像； ");
INSERT INTO cmn2006_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","你们不可侍奉这些偶像，向它们跪拜。因为我是主－你们的上帝，我是妒嫉的上帝。我追讨恨我的人的罪，惩罚他们，直到他们的第三、四代子孙。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","但我向爱我和谨守我的诫命的人显示我的不变的爱，直到他们的千代子孙。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“‘你们不可滥用主－你们的上帝的名，因为主一定会惩罚滥用他的名的人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“‘你们要遵照主－你们的上帝的命令，谨守安息日为圣日。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","你们每周有六天可以工作，处理日常事务， ");
INSERT INTO cmn2006_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","但第七天是属于主－你们的上帝的安息日。在这一天，你们和你们的儿女、男女奴仆、寄居在你们中间的外族人，以及你们的牛、驴和其他牲畜都不可做工，好让你们的男女奴仆可以跟你一样休息。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","要记住，你们也曾在埃及做过奴隶，是主－你们的上帝用他的大能力把你们从那里领出来的，因此，主－你们的上帝命令你们必须守安息日。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“‘你们要遵照主－你们的上帝的命令，尊敬你们的父母，这样，你们才能长久居住在主－你们的上帝赐给你们的土地上，并且事事顺利。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“‘不可蓄谋杀人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“‘不可通奸。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“‘不可偷盗。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“‘不可做伪证陷害他人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“‘不可恋慕别人的妻子；不可想望别人的房产、田地、男女奴仆、牛、驴或其他一切属于别人的东西。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“主在何烈山上从火焰和浓云密雾中向你们全体会众大声宣布了这些诫命。除此以外他一无所言。主把这些诫命写在两块石版上，交给了我。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","“当时，整座山都着了火，你们听得见从幽暗中发出的声音。你们各支派的首领和长老们都来见我， ");
INSERT INTO cmn2006_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","对我说∶‘主－我们的上帝向我们显示了他的荣耀和威严，我们也听见了他从火中说话的声音。今天，我们亲眼看到，人能够听到上帝对他说话而依然不死。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","然而，我们为什么要冒死的危险呢？这大火肯定会吞灭我们。如果我们再听主－我们的上帝说话，我们一定会死。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","有谁象我们一样，听见活生生的上帝从火中说话而依然活着？ ");
INSERT INTO cmn2006_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","请你去聆听主－我们的上帝要说的一切，然后把主－我们的上帝告诉你的话转告我们，我们一定遵从照办。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“你们对我说的话，主都听见了。主对我说∶‘我听见了这些人对你说的话。他们说得很好， ");
INSERT INTO cmn2006_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","我希望他们常怀敬畏我的心，谨守我的所有诫命，这样，他们和他们的子孙就会永远事事顺利。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","你去告诉他们∶“回到你们的帐蓬里去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","但你要呆在我这里；我将把所有的律法、条例和诫命告诉你，由你传授给他们，好让他们在我将赐给他们的土地上遵照执行。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","“所以，你们必须谨守主－你们的上帝的诫命，不可有丝毫疏忽大意。 ");
INSERT INTO cmn2006_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","你们必须按照主－你们的上帝的诫命生活，这样，你们才能存活，事事顺利，并长久居住在你们即将要占领的土地上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“主－你们的上帝命令我把这些律法、条例和诫命传授给你们，就是要让你们在即将渡河进占的土地上遵行这些律法、条例和诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","你们和你们的子孙要终生敬畏主－你们的上帝，谨守我传授给你们的一切律法和诫命，这样，你们才能长久居住在那块土地上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","听着，以色列人！你们要认真遵行所有这些法度。只有这样，你们才能事事顺利，才能象主－你们祖先的上帝应许你们的那样，成为那里一个人口众多的民族，定居在那块流奶与蜜的土地之上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“以色列人哪，你们听着！主是我们的上帝，是至高者！ ");
INSERT INTO cmn2006_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","你们要尽心、尽情、尽力爱主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","要时刻铭记我今天传授给你们的这些诫命， ");
INSERT INTO cmn2006_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","要用这些诫命教导你们的子孙；无论你们居家还是外出，躺着还是站着，都要时时温习这些诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","你们要把这些诫命写下来，当作标记系在手上，当作头巾戴在额上； ");
INSERT INTO cmn2006_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","也要把它们写在家里的门框上和大门上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“主－你们的上帝会把你们领进他应许你们的祖先亚伯拉罕、以撒和雅各要赐给你们的那块土地，那里巨大繁荣的城市不是你们建造的， ");
INSERT INTO cmn2006_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","满屋的好东西不是你们积存的，水井不是你们挖的，葡萄园和橄榄园不是你们培植的。当你们在那里饱享这一切而心满意足的时候， ");
INSERT INTO cmn2006_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","你们要格外当心，不可忘记主；你们曾在埃及沦为奴隶，是主把你们从那里领了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","你们要敬畏主－你们的上帝，你们只可以侍奉他，奉他的名发誓， ");
INSERT INTO cmn2006_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","决不可追随周围邻国的其他神明。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","因为主－你们的上帝是妒嫉的上帝，他就在你们中间。你们要当心，以免主－你们的上帝向你们发怒，把你们从大地上消灭掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“不可试探主－你们的上帝，象你们从前在玛撒试探他那样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","你们要谨守主－你们的上帝颁给你们的律法、条例和诫命， ");
INSERT INTO cmn2006_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","要做主认为正确和满意的事。只有这样，你们才能事事顺利，才能进占主应许给你们祖先的那块肥美之地， ");
INSERT INTO cmn2006_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","才能象主应许的那样赶走你们面前的所有仇敌。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“将来，当你们的子孙问你们∶‘主－我们的上帝颁给你们的这些律法、条例和诫命有什么意义呢？’ ");
INSERT INTO cmn2006_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","那时，你们要告诉他们∶‘我们曾经在埃及做埃及王的奴隶，是主用他的大能把我们领出了埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","我们亲眼看见主施行大而可畏的神迹惩罚埃及、埃及王和他的整个家族。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","他领我们离开那里，把我们带到他应许给我们祖先的那块土地上，并把它赐给我们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","主命令我们遵守所有这些律法，要我们以此敬畏主－我们的上帝。这样做使我们一直受益，并使我们存活至今。 ");
INSERT INTO cmn2006_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","只要我们按照主的吩咐谨守他颁给我们的这一切诫命，主－我们的上帝就会喜爱我们。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“当主－你们的上帝把你们领进你们即将进占的那块土地的时候，他将赶走你们面前七个比你们强大的民族－赫人、革迦撒人、亚摩利人、迦南人、比利洗人、希未人和耶布斯人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","当主－你们的上帝把他们交到你们手里的时候，你们要击败他们，彻底消灭他们，不可跟他们订立和约，不可对他们稍示怜悯。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","你们不可与他们通婚；你们的女儿不可嫁给他们的儿子，你们的儿子也不可娶他们的女儿。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","因为他们会使你们的子女背弃主而去侍奉其他神明，主会因此而对你们发怒，很快把你们灭绝掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","“你们要这样对待这些异族人∶拆毁他们的祭坛，打碎他们的柱像，砍倒亚舍拉神像，烧掉他们的偶像。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","因为你们是属于主－你们的上帝的圣洁的民族，是主－你们的上帝从世界所有民族中拣选出来做他珍爱的子民的民族。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","主爱你们，拣选你们，并非因为你们人数最多，相反，你们是世界上最小的民族， ");
INSERT INTO cmn2006_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","而是因为主喜爱你们，是因为他要信守他对你们祖先的应许。因此，他以他的大能把你们从埃及领了出来，从埃及王的奴役之下解救了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","“所以，你们要明白，主－你们的上帝是唯一的上帝，信实的上帝。对于爱他并谨守他的诫命的人，他信守他的约，以不变的爱对待他们，直到千代。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","但对于恨他的人，他惩罚他们，毫不犹豫地消灭他们，使他们本人受到报应。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","所以，你们要谨守我今天颁给你们的这些律法、条例和诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“只要你们遵行这一切，主－你们的上帝必定信守跟你们订立的约，按照他对你们祖先的应许以不变的爱对待你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","他会爱你们，赐福给你们，增加你们的人口，使你们子孙昌盛，出产丰足；他将赐给你们五谷、新酒和橄榄油，使你们牛羊产下牛犊和羊羔；他将在他应许你们祖先要赐给你们的土地上把这一切福泽都赐给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","你们将要领受的福泽超过了世上的一切民族。无论你们的男女或是你们的牲畜都没有不生育的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","主将使一切疾病离开你们，你们经受过的那些在埃及发生过的可怕的疾病决不会加在你们身上，它们只会加在那些恨你们的人的身上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","你们要消灭所有那些主－你们的上帝交在你们手里的民族，不要怜悯他们。你们不可拜他们的神明，因为那将是使你们堕落的陷阱。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“你们也许会暗想∶‘这些民族比我们强大得多，我们能把它们赶走吗？’ ");
INSERT INTO cmn2006_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","不要怕他们，你们要记着主－你们的上帝是怎样处置埃及王和所有的埃及人的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","要记住你们曾亲眼看到的大审判，要记住主施行的神迹奇事，要记住主－你们的上帝把你们领出埃及的大能力。主－你们的上帝将用同样的方式处置所有那些使你们感到畏惧的民族。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","主－你们的上帝还将差遣大黄蜂攻击他们，直到那些残存下来躲避你们的人全都被杀得一个不剩。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","不要怕他们，因为主－你们的上帝与你们同在，他是大而可畏的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","主－你们的上帝将逐步把你们面前的这些民族赶走，你们不可能一下子就把他们全部消灭。否则，野兽会增加很多，以致危害了你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","主－你们的上帝将把这些民族交到你们手里，他将使他们惊慌纷乱，直至被完全消灭。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","主将把他们的王交在你们手中，你们要杀掉他们，让他们被世界彻底遗忘掉。没有人能够抗拒你们，而你们将把他们全部消灭掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","“你们要烧掉他们的偶像。你们不可贪图这些偶像身上的金银，把这些金银据为己有，否则，你们将因此而陷于灾难。因为这是主－你们的上帝所厌恶的东西。 ");
INSERT INTO cmn2006_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","你们不可将任何这类偶像带回家里，否则，你们将会象这偶像一样被完全毁灭。你们要憎恨这些偶像，厌恶这些偶像，因为它们只会被完全毁灭掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“你们要谨守我今天颁给你们的全部诫命，好让你们能够生存，人口不断增加，并能够进占主应许你们祖先的那块土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","你们要记住在过去的四十年里主－你们的上帝领着你们在旷野里流浪的全部旅程。他以此使你们谦卑，考验你们，了解你们的心志，知道你们是否遵守他的诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","主熬炼你们，让你们挨饿，然后给你们吗哪吃，那是你们和你们的祖先都从未见过的东西。他这样做是要让你们懂得，人的生存不仅仅靠食物，而且要靠主所说的每一句话。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","在这四十年中，你们的衣服没有穿破，你们的脚也没有走肿。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","要记住，主－你们的上帝是在管教你们，就象一位父亲管教他的儿子一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","“所以，你们要侍奉他，敬畏他，要遵守主－你们的上帝的诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","主－你们的上帝将把你们领进一块丰饶之地，那里有溪流和泉水，地下水从山谷里和山岗上喷涌流出； ");
INSERT INTO cmn2006_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","那里有小麦和大麦，葡萄树，无花果树和石榴树，有橄榄油和蜂蜜； ");
INSERT INTO cmn2006_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","你们在那里将应有尽有，食物充沛。那里的石头是铁，那里的山能挖出铜。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","当你们享用你们想往的各种食物时，你们要感谢主－你们的上帝赐给了你们这样一块美好的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“所以，你们要当心，不要忘记主－你们的上帝，不要违背我今天颁给你们的他的律法、条例和诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","当你们吃得饱饱的时候，当你们盖起舒适的房子住在里面的时候， ");
INSERT INTO cmn2006_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","当你的牛羊、金银和其他财物越来越多的时候， ");
INSERT INTO cmn2006_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","你要当心，不要因此就骄傲起来，忘记了把你们从奴役之地的埃及领出来的主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","是主把你们领进了那片可怕的大旷野，那里毒蛇和蝎子横行，是一片干旱无水的土地。是主使坚硬的岩石为你们流出泉水； ");
INSERT INTO cmn2006_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","是主在旷野里给你们吗哪充饥，那是你们祖先不曾见过的食物。他以这一切考验你们，使你们谦卑，最终是要使你们兴盛起来。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","所以，你们千万不要认为∶‘我是靠自己的能力得到这些财富的！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","要记住主－你们的上帝，是他赐给了你们获得财富的能力，他这样做是为了信守向你的祖先起誓所立的约，正如他今天所做的一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","“如果你们忘记了主－你们的上帝，转而去追随别的神明，侍奉它们，向它们跪拜，那么，我今天要警告你们∶你们必将消亡， ");
INSERT INTO cmn2006_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","就象你们进入这块土地时主在你们面前消灭掉的那些民族一样，你们也要同样被消灭掉。因为你们背弃了主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","“以色列人哪，你们听着！你们今天就要渡过约旦河去攻击那里的各个民族了！他们比你们强大，城池宽阔，城墙高耸入云。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","那里的居民是亚衲族人，他们又高大又强悍，这你们已经知道，而且，你们也听人说过∶‘谁能跟亚衲人抗衡？’ ");
INSERT INTO cmn2006_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","但今天，你们可以确确实实地知道，主－你们的上帝将在你们的前面越过约旦河，象烈火一样吞噬那些民族。当你们前进的时候，他将驱赶他们，使你们能按照他的应许迅速地把他们赶出去并彻底消灭掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“当主－你们的上帝赶走了你们面前的这些民族时，你们不要以为∶‘我们是优秀的民族，所以主才让我们进占了这块土地。’不！主把这些民族赶走，是因为他们自己的邪恶， ");
INSERT INTO cmn2006_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","而不是因为你们行为正直，心地诚实。主－你们的上帝为了这些民族的邪恶才把他们从你们的前面赶走，而让你们去占有他们的土地。他这样做也是为了信守向你们的祖先－亚伯拉罕、以撒和雅各许下的诺言。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","你们应当明白，主－你们的上帝并非因为你们秉性优秀才把这块富饶之地赐给你们，事实上，你们是顽固的愚民。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“你们要记住，别忘了你们曾在旷野上激怒主－你们的上帝。自从你们离开埃及那天直到现在，你们不断地背叛他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","你们曾在何烈山使主如此震怒，他几乎要灭绝掉你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","当时，我上山去接受石版，那是主跟你们立约的版。我不吃不喝，在山上整整停留了四十昼夜。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","主给了我两块石版，上面有上帝亲自用手指写下的全部诫命，就是你们集合在何烈山下那天主从火中向你们所说的话。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","“过了四十昼夜，主把两块石版－就是约版，交给了我。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","主对我说∶‘起来！赶快下山去吧！你从埃及领出来的民众已经堕落了！他们这么快就背离了我的命令，竟然为自己铸造了偶像！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","“主又对我说∶‘我观察了这个民族，他们确实是顽固的愚民。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","不要阻止我，我要彻底灭绝他们，让他们永远被这个世界遗忘！我将使你和你的家族成为比他们更强大、人口更多的民族。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","“我转身下了山，手里拿着那两块约版。山还在燃烧着。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","我看见你们冒犯了主－你们的上帝。你们这样快就背弃了主对你们的命令，为自己铸造了一个牛犊偶像。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","我两手抓起约版，扔了下去，当着你们的面把它们摔得粉碎。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","我象以往一样，俯伏在主的面前，整整四十昼夜不吃不喝；我这样做是因为你们犯了罪，做了主认为邪恶的事，激怒了主。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","我惧怕主的烈怒，因为主已经震怒到要毁灭你们。然而，主当时仍然垂听了我的祈祷。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","主对亚伦非常愤怒，几乎要杀了他！我也为亚伦祈祷。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","然后，我把你们铸造的那罪恶的东西－就是那牛犊扔到火里，又把它打碎，全部磨成象尘土一样细的粉末，撒在从山上流下来的溪水里。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","“在他备拉、玛撒和基博罗哈他瓦的时候，你们也曾激怒主。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","主曾命令你们从加底斯巴尼亚出发，说∶‘去，占领我赐给你们的那块土地！’而你们竟拒绝服从主－你们的上帝的命令。你们不信靠他，不听从他的命令。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","自从我认识你们以来，你们不断地背叛主。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","“我在主的面前俯伏了四十昼夜，因为主说他要灭绝你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","我向主祈祷说∶‘至高的主啊，求你不要消灭你的子民。他们是你自己的产业；你曾用你的大能救赎他们，你曾以你的力量把他们领出埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","求你记念你的仆人亚伯拉罕、以撒和雅各，不要计较这民众的顽固、邪恶和罪过。 ");
INSERT INTO cmn2006_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","否则，埃及人会说∶“主无法把他们带到他应许给他们的地方，而且他也恨他们，所以，他才把他们领出来，好在旷野里杀死他们。” ");
INSERT INTO cmn2006_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","主啊，他们是你的子民，是你用大能力从埃及领出来的属于你自己的产业。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","“那时，主对我说∶‘你再去凿两块石版来，要和先前的一样。然后上山来见我。再做一个木柜。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","我要把被你摔碎的那两块石版上所写的诫命写在这两块石版上。然后，你要把它们放在木柜里。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","“于是，我用金合欢木造了一个木柜，又按照原先的样子凿了两块石版。然后，我就手拿着这两块石版上了山。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","主把上次写的内容－也就是你们聚集在何烈山下那天主从火中向你们颁布的十条诫命，重新写在这两块石版上，把石版交给了我。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","我转身下了山，把石版放进做好的木柜里。按照主给我的命令，这两块石版至今一直放在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","（以色列人从亚干人的井那里出发，来到摩西拉。亚伦就死在那里，葬在那里。他的儿子以利亚撒继承了他的职位，做了祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","以色列人从那里出发，到了谷歌大，又从谷歌大到了溪水纵横的约巴他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","那时，主指命利未支派的人抬主的约柜，在他的跟前侍奉他，并奉他的名为人民祝福；利未支派的人至今仍然担任这些职务。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","因此，利未支派不象其他支派那样有自己的一份土地，主－你们的上帝应许他们∶主就是他们的产业。） ");
INSERT INTO cmn2006_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","“我象上次一样，在山上又停留了四十昼夜。主再一次垂听了我的祈祷，答应不消灭你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","主对我说∶‘去吧，你去带领这民众，好让他们能进占我向他们祖先立誓要赐给他们的那块土地。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“以色列人哪，主－你们的上帝向你们索取过什么？他只要你们敬畏主－你们的上帝，按照他的教诲生活，全心全意地爱他，侍奉他， ");
INSERT INTO cmn2006_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","并为了你们自身的幸福，谨守我今天向你们颁布的主的这些律法和诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","“看吧！天地和其中的万物，甚至天外之天，都属于主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","然而，主仍然眷顾你们的祖先，他爱他们，因此，他从各民族里拣选了你们－你们祖先的后代，至今，你们依然是他的子民。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","“把你们的全部身心都献给主吧，不要再顽固了。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","主－你们的上帝是万神之神，万主之主，他是伟大的、全能的、可畏的上帝。他公正无私，不接受贿赂。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","他为孤儿寡妇主持公道，他爱护寄居在我们中间的外侨，让他们有饭吃，有衣穿。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","你们也要爱护外侨，因为你们也曾寄居在埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","“你们要敬畏主－你们的上帝，要侍奉他，忠于他，只奉他的名发誓。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","他是你们的上帝，是你们应当赞颂的至高者，你们亲眼看见了他为你们所做的这一切伟大而可畏的事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","你们的祖先当年初到埃及时只有七十人，而现在，主－你们的上帝已经使你们多如天上的繁星。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","“你们要爱主－你们的上帝，要永远遵行他的律法、条例和诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","要知道，你们的后代既不了解也没有领受过主－你们的上帝的管教；他们没有见过他的伟大，他的大能力， ");
INSERT INTO cmn2006_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","他在埃及向埃及王和他的国家施行的神迹， ");
INSERT INTO cmn2006_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","以及他怎样处置埃及的军队和他们的战马及战车－当他们追击你们的时候，他怎样使红海的波涛淹没他们，把他们彻底消灭； ");
INSERT INTO cmn2006_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","在你们到这里之前，他怎样在旷野里照看你们， ");
INSERT INTO cmn2006_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","怎样处置吕便人以利押的儿子大坍和亚比兰－大地在以色列人中间裂开，把他们和他们的家族、帐蓬、以及属于他们的一切生灵都吞了下去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","只有你们亲眼看见了主做的这一切大事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","“因此，你们要遵守我今天颁布给你们的所有诫命，这样，你们才能有足够的力量去进占那块你们即将渡过约旦河去占领的土地， ");
INSERT INTO cmn2006_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","才能在主应许赐给你们祖先和他们后代的那块流奶与蜜的土地上长久居住下去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","你们将要进占的那块土地不象你们离开的埃及。在埃及，你们要播种，要象浇菜园一样脚踏水车去灌溉庄稼， ");
INSERT INTO cmn2006_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","而你们即将渡河进占的那块土地有山有谷，土地有天上的雨水浇灌， ");
INSERT INTO cmn2006_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","是主－你们的上帝眷顾的地方。主－你们的上帝终年都在看顾那块土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","“主说∶‘只要你们谨守我今天颁布给你们的诫命，爱主－你们的上帝，全心全意地侍奉我， ");
INSERT INTO cmn2006_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","我就会适时为你们的土地降下春霖秋雨，你们将收获五谷、新酒和橄榄油； ");
INSERT INTO cmn2006_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","我也会使野外长出青草，供给你们的牲畜。你们会吃得饱饱的，心满意足。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","“你们要当心，不要受诱惑而去侍奉其他神明，向它们跪拜。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","否则，主会因此对你们发怒，他会关闭天空，不再降雨，土地将不再长庄稼，你们将会很快在主赐给你们的这块美好的土地上灭亡。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","“你们要永远记住我的这些话，要把它们当作标记系在手上，当作头巾戴在额前。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","无论你们居家还是外出，躺着还是站着，你们都要时时温习这些诫命，并用它们教导你们的儿女。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","你们要把这些诫命写在家里的门框上和城门上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","只有这样，你们和你们的子女才能在主应许赐给你们祖先的这块土地上天长地久，永远居住下去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","“只要你们谨守我颁布给你们的全部诫命，爱主－你们的上帝，按照他规定的方式生活，紧紧地追随他， ");
INSERT INTO cmn2006_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","那么，主就将赶走你们面前所有这些民族，你们就能占有这些比你们强大的民族的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","你们足迹所及之处都将属你们所有。你们的疆土将南起旷野，北至黎巴嫩，东起幼发拉底河，西至地中海。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","你们所到之处，主－你们的上帝将按照他的应许使所有的人对你们惊惧有加，没有人能跟你们抗衡。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“看吧，今天我把祝福和诅咒摆在你们面前，由你们选择。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","如果你们遵守我今天颁布给你们的主－你们的上帝的诫命，你们就能得到祝福； ");
INSERT INTO cmn2006_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","如果你们不守主－你们的上帝的诫命，不按我今天吩咐你们的方式生活，而去追随别的你们一向不认识的神明，那么，你们就要受到诅咒。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","“当主－你们的上帝把你们领进那块你们即将进占的土地之后，你们要在基利心山宣布祝福的话，在以巴路山宣布咒诅的话。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","你们知道，这两座山在约旦河彼岸以西，座落在占据约旦河谷的迦南人的土地上，距吉甲附近的摩利橡树不远。 ");
INSERT INTO cmn2006_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","你们就要跨过约旦河去进占主－你们的上帝赐给你们的那块土地了！当你们占据了那里并在那里定居下来以后， ");
INSERT INTO cmn2006_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","你们一定要谨守我今天颁布给你们的所有律法和诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","“以下是你们在主－你们祖先的上帝赐给你们作为产业的土地上要谨守的律法和条例。只要你们在这块土地上生存一天，你们就要遵行这些律法和条例。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","“你们占领了那些民族的土地后，要彻底摧毁他们设在高山上、丘陵上和绿树下的所有拜神场所。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","你们要拆毁他们的祭坛，打碎他们的神柱，烧掉亚舍拉柱像，把他们神明的偶像砍成碎片，使他们邪神的名字从此在那里绝迹。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","“你们不可用他们那种方式敬拜主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","主－你们的上帝从你们各支派中选择哪里作为奉他的名的居所，你们就要到哪里去敬拜他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","你们的烧化祭、各类祭物、什一捐、举祭、还愿祭、自愿祭以及头生的牛羊都必须带到那里去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","你们和你们的家人要到那里去，在主－你们的上帝面前吃喝，享受你们辛劳得来的好东西，因为主－你们的上帝赐福给了你。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","“当那一天到来的时侯，你们不可象现在这样各人随着自己的意思敬拜。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","你们现在这样做，是因为你们还没有进入主－你们的上帝赐给你们得以安居的那块土地， ");
INSERT INTO cmn2006_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","你们不久就要渡过约旦河，定居在主－你们的上帝赐给你们的土地上，主会使你们不受四邻仇敌的侵扰，生活在安宁之中。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","那时，你们要按照我的吩咐，带上烧化祭、各类祭物、什一捐、各种供品和还愿祭，到主选定的奉他的名的居所去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","你们要和你们的儿女、男女仆人以及住在你们城里的利未人一起在主－你们的上帝面前尽情欢乐，因为利未人没有自己的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","你们要谨慎，不可随处献烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","你们只能在主从你们某一支派中选定的地方献烧化祭，在那里做我命令你们做的一切事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","“你们随时可以在你们住的所有城镇里宰杀牲畜，吃它们的肉，尽情享受主－你们的上帝赐给你们的恩惠。洁净和不洁净的人都可以吃，就象吃羚羊和野鹿一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","但你们不可吃血，要把血象泼水一样倒在地上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","“不可在你们各自的城镇里吃献给主的祭物－五谷、新酒和橄榄油的什一捐，头胎生的牛羊，还愿祭，自愿祭和各类供品。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","你们只能在主－你们的上帝选定的地方，在主的面前吃这些祭物。你们要和你们的儿女、男女仆人以及住在你们城里的利未人一起在主－你们的上帝面前享用这些你们用辛劳得来的好东西。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","你们要注意，只要你们还居住在自己的土地上，就不可以忽视利未人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","21","“当主－你们的上帝按照他的应许扩展了你们的疆界之后，如果主选定奉他的名的地方离你很远，而你想吃肉，说∶‘我想吃肉了。’那么，你就可以按照我吩咐的方式在你们自己的城镇里宰杀主赐给你们的牛羊，随心所欲地吃肉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","洁净的和不洁净的人都可以吃，就象吃羚羊和野鹿一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","但你们绝不可吃血，因为生命存在于血中；不可以吃还存在生命的肉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","你们要象倒水一样把血倒在地上，而绝不可吃掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","你们不可以吃血，这样你们和你们的儿女才会蒙福；因为你们做了主所赞许的事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","“然而，你们必须把献给主的圣物和还愿祭带到主选定的地方去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","烧化祭要连肉带血一起献在主－你们的上帝的祭坛上；其他祭牲的血要倒在主－你们上帝的祭坛上，而肉你们可以吃掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","你们要谨守我今天颁布给你们的所有诫命，这样，你们就做了主－你们的上帝所赞许的事，你们和你们的子孙就会永远蒙福。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","“主－你们的上帝将消灭你们即将去攻击的那些民族。当你们赶走了他们，在他们的土地上定居下来以后， ");
INSERT INTO cmn2006_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","千万不要仿效这些已经被消灭的民族的习俗，以免陷于他们的堕落行为之中。也不可问及他们的神，说∶‘这些民族是怎样拜神的？我也要照样做。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","你们不可用他们的方式侍奉主－你们的上帝，因为他们为他们的神做尽了主所憎恶的邪恶的事。他们甚至把自己的儿女用火烧死，做为祭物献给他们的神。 ");
INSERT INTO cmn2006_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","“你们要谨慎，要遵行我吩咐你们的每一件事，不许有增删改动。” ");
INSERT INTO cmn2006_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","2","“或许有先知或解梦人来向你演示征兆或奇事，对你说∶‘我们去追随其他神明吧！’－那些神都是你一向不认识的－‘我们一起去侍奉他们吧！’即使他预言的这些征兆或奇事应验了， ");
INSERT INTO cmn2006_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","你们也不可听信这些先知或解梦人的话。这是主－你们的上帝在考验你们，看你们是不是全心全意地爱主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","你们要追随主－你们的上帝，要敬畏他，遵守他的诫命；要服从他，侍奉他，忠于他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","那先知或解梦人要被处死，因为他引诱你们背叛领你们出埃及、救你们摆脱奴役的主－你们的上帝，蛊惑你们偏离主－你们的上帝指引给你们的路。你们必须杀死他，以除掉你们中间的邪恶。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","“如果你的同胞弟兄或是你同父或同母的弟兄、你的儿女、你的爱妻或你的密友偷偷地怂恿你，说∶‘我们去侍奉别的神吧！’那是些你和你的祖先一向不认识的神， ");
INSERT INTO cmn2006_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","是你们周围其他民族所拜的神。这些民族有的远在天边，有的就在你们近旁。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","你不可随声附和，不可听从这个人的话！你不可姑息这个人，不可怜惜他，也不可庇护他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","你必须杀死这个人；你要第一个动手，然后，其他人要和你一起杀死他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","你们要向他扔石头，直到把他打死。因为他想引诱你们背离领你们出埃及、救你们摆脱奴役的主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","这样，以色列人听说这件事以后就会心怀畏惧，没有人再敢在你们中间做这种邪恶的事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","13","“如果你们听说在主－你们的上帝赐给你们居住的某个城里出了恶人，他们带领城里的居民背离了上帝，扬言说∶‘我们要去侍奉你们一向不认识的别的神明！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","这时，你们要彻底查究这件事。如果事情属实，这种邪恶的事确实在你们中间发生了， ");
INSERT INTO cmn2006_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","你们就要杀光这城里的居民和牲畜，彻底毁掉这座城里的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","你们要把城里所有的财物收集起来，堆在广场上，然后放火把那城和城里的财物都烧掉，作为烧化祭献给主－你们的上帝。这座城要永远废掉，不可重建。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","你们不可把任何应当毁掉的东西据为己有。 ");
INSERT INTO cmn2006_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","只要你们服从主－你们的上帝，遵守我今天颁给你们的主的所有诫命，做他所赞许的事，主的怒气就会平息，他会赐给你们仁受和怜悯，使你们的民族人口昌盛，实现他对你们祖先的应许。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","“你们是主－你们的上帝的儿女。你们不可用割伤身体、剃光前额的方式哀悼死者。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","因为，你们是属于主－你们的上帝的圣洁的民众，是主从世上万民中间拣选出来的他的珍爱的子民。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","“你们不可吃主所憎恶的任何东西。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","你们可以吃的动物有∶牛、绵羊、山羊、 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","鹿、羚羊、狍子、野山羊、野绵羊、麋鹿、岩羊。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","凡脚蹄分为两瓣且又反刍的动物，你们都可以吃， ");
INSERT INTO cmn2006_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","但只有脚蹄分瓣或只有反刍的动物，如骆驼、兔子、獾，你们不可以吃；因为它们虽然反刍，脚蹄却不分瓣，它们对于你们是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","你们也不可以吃猪，因为它虽然脚蹄分瓣，却不反刍，它对于你们也是不洁净的。你们不可以吃这些动物的肉，也不可以触碰它们的尸体。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","“水中的生物凡有鳞有鳍的你们都可以吃， ");
INSERT INTO cmn2006_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","但没有鳍没有鳞的不可以吃，因为它们对于你们是不洁净的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","“你们可以吃洁净的鸟类。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","18","不可以吃的鸟类有∶鹰、黑雕、秃鹰、兀鹰、其它各类鹰、各类乌鸦、猫头鹰、短耳鹰、长耳鹰、小鹰、鹈鹕、鸬鹚、鹳、鹭鸶、鱼鹰、任鸟、蝙蝠等。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","“凡有翅膀的昆虫对于你们是不洁净的，不可以吃。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","但你们可以吃所有洁净的飞禽。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","“你们不可以吃自然死去的动物，但可以把它送给住在你们城里的外侨吃或卖给外族人，因为你们是属于主－你们的上帝的圣洁的民众。 “你们不可用母羊的奶煮小羊吃。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","“你们要从每年的收成中拿出十分之一来， ");
INSERT INTO cmn2006_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","带到主－你们的上帝所选定的奉他的名的居所去，在他的面前吃所献的那十分之一的五谷、新酒、橄榄油和头生的牛羊，好让你们学会始终敬畏主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","如果路途太远，你们不能把主－你们的上帝赐给你们的那些东西运到主－你们的上帝选定奉他的名的地方去， ");
INSERT INTO cmn2006_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","那么，你可以把它们换成钱，然后带着钱到主－你们的上帝选定的地方去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","你们可以按自己的意愿用这钱买牛、羊、酒或其他你喜欢的东西，然后，和你的家人一起在主－你们的上帝的面前享用这些东西。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","你们不可忘记住在你们城里的利未人，因为他们没有自己的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","“每隔三年，你们要从当年的收成里取出十分之一，储存在你们各自的城里， ");
INSERT INTO cmn2006_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","供没有自己产业的利未人和你们中间的外侨及孤儿寡妇吃用。这样，主－你们的上帝就会在你们所做的一切事上赐福给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","“每七年的最后一年，你们要豁免债务。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","具体作法如下∶凡借钱给其他以色列人的债主必须取消债务，不得向他的同胞讨债，因为为荣耀主而取消债务的时间到了。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","你们可以追讨外国人的债，但你们的同胞无论欠了你们什么，都必须免除。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","5","然而，只要你们服从主－你们的上帝，遵行我今天颁布给你们的所有诫命，你们中间就不会有穷人。因为主会在他将要赐给你们作为产业的土地上重重地赐福给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","主－你们的上帝将按照他的应许赐福给你们，你们会有钱借给众国，而无须向他们借债。你们将管辖列国，但没有一个国家能支配你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","“在主－你们的上帝将要赐给你们的土地上，无论在哪一座城里，如果你们中间有困苦的同胞，你们不可自私而不去帮助他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","你们要慷慨解囊，把他所需要的一切借给他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","你们决不可心存邪念，想∶‘豁免债务的第七年快到了，’于是便对你的穷同胞白眼相加，不借给他东西。你的穷同胞会因此向主控诉你，主会认定你有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","你要慷慨施与予，不可心存不悦；主－你们的上帝会因你的善行在你所做的一切事上赐福给你。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","在你们居住的土地上总会有贫苦的同胞，因此我命令你们，你们必须对他们慷慨相助。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","“如果某个希伯来人卖身给你，无论男女，他将服侍你六年。到了第七年，你必须还他自由。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","你释放他的时候，不可叫他两手空空地离开。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","你要慷慨地送给他羊、粮食和酒，就象主－你的上帝赐福给你一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","要记住你们也曾在埃及做过奴隶，是主救赎了你们，因此，我今天才这样命令你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","“如果你的奴隶爱你和你的家庭，跟你一直相处得很好，他对你说∶‘我不愿离开你，’ ");
INSERT INTO cmn2006_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","那么，你就要让他把耳朵贴在你家的门上，然后你要用锥子在他的耳垂上穿一个洞，这样，他就终身是你的奴隶了。对待女奴的方法相同。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","释放奴隶的时候不要心里不情愿。他服侍了你六年，只不过耗费了你雇工需付工资的一半。而主－你的上帝会因此而在一切事情上赐福给你。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","“你们要把头生的公牛和公羊分离出来，献给主－你们的上帝。不可用头生的公牛干活儿，也不可剪头生公羊的羊毛。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","每年，你们和你们的家人要到主选定敬拜他的地方去，在主－你们的上帝的面前吃这些牛和羊的肉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","不过，如果这些牛羊有残疾，或是跛脚，或是瞎眼，或是有其他严重的缺陷，那么，你们就不能把它们作为祭物献给主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","你们可以在自己居住的城里把它们吃掉，洁净的和不洁净的人都可以吃，就象吃羚羊和野鹿一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","但不可吃它们的血，你们要把血象倒水一样倒在地上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","“要守亚笔月，要庆祝逾越节，以表达对主－你们的上帝的敬意，因为主－你们的上帝在亚笔月的一个夜晚把你们领出了埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","你们要从牛群或羊群中挑选一只牲畜，带到主选定奉他的名的居所去，作为逾越节的牲祭献给主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","“你们吃祭牲肉的时候，不可一同吃任何带酵的东西。你们要连续七天吃无酵饼（这饼叫做“苦难饼”）。当年你们在匆忙之中离开埃及的时候，吃的就是这种饼。你们今天吃这种饼，就是要让你们在有生之年永远记住你们离开埃及的那一天。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","“七天之内，你们全境之内不准有酵。你们第一天傍晚宰杀的牲畜的肉不准留到第二天早晨。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","你们不可在主－你们的上帝赐给你们的各个城里献逾越节的牲祭， ");
INSERT INTO cmn2006_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","而必须到主选定奉他的名的居所去，在傍晚日落时分－那是你们离开埃及的时刻，献上逾越节的牲祭。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","你们要在主－你们的上帝选定的地方煮祭肉，吃祭肉，直到第二天早晨，你们才可以动身回家。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","你们要连续六天吃无酵饼。在第七天，你们不可做工；你们要在这天举行专门的聚会向主－你们的上帝致敬。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","“从你们开始收割的那一天算起，七周之后， ");
INSERT INTO cmn2006_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","11","你们要为主守七七节。你们要按照主－你们的上帝对你们赐福的多少，带上相应数量的自愿祭，到主选定奉他的名的居所去，跟你们的儿女、男女仆人、以及住在你们城中的利未人和住在你们中间的外侨、孤儿、寡妇，一起欢聚在主－你们的上帝的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","要记住你们也曾在埃及做过奴隶。你们务必切实遵守所有这些条例。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","“你们收藏完毕打好的庄稼和新酿的酒之后，要守七天住棚节。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","在节期期间，你们要和你们的儿女、男女奴仆，以及住在你们城里的利未人、外侨、孤儿、寡妇一起欢聚， ");
INSERT INTO cmn2006_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","在主选定的地方守七天住棚节，以表示对主－你们的上帝的敬意。因为主－你们的上帝将在你们所做的一切事上赐福给你们，他会赐给你们丰收，让你们欢天喜地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","“你们的成年男子必须每年三次去主选定的地方敬拜主－你们的上帝。这三次是∶逾越节、七七节、住棚节。任何人都不准空着手去敬拜主。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","每个人都必须按照主－你们的上帝对他赐福的多少量力而行，带去相应数量的礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","“你们要在主－你们的上帝要赐给你们的城镇里为各支派任命法官和其他官员，这些人必须秉公执法。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","“你们不可徇私，不可受贿。因为贿赂能使本来明理的人辨不清是非，使本来正直的人不再仗义执言。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","公正！只有公正才是你们的追求。只有这样，你们才能生存下去，才能占领主－你们的上帝即将赐给你们的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","“你们不可在你们将为主－你们的上帝建的祭坛旁竖立任何类似亚舍拉柱像一类的木柱， ");
INSERT INTO cmn2006_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","也不可竖立石柱。因为主－你们的上帝憎恶这些东西。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","“你们不可向主－你们的上帝献上残疾的或有其他缺陷的牛羊作为祭牲，因为那是主－你们的上帝所厌恶的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","在主－你们的上帝赐给你们的城镇里，如果你们中间有人－无论是男是女－冒犯了主，你们的上帝，不守他的约， ");
INSERT INTO cmn2006_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","去侍奉跪拜别的神明，或拜太阳，或拜月亮，或拜星辰，那决不是我所吩咐的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","一旦你们得到报告，了解了情况，必须彻底查究。如果情况属实，这种邪恶的事确实在以色列发生了， ");
INSERT INTO cmn2006_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","那么，你们就要把做这件邪恶事的男人或女人拉到城门口，用石头把他打死。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","但是，处死这个人必须至少有两至三个人作证，不可只凭一个证人就处死他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","证人要先动手向他扔石头，然后，其他人一齐动手，把他打死。你们要用这种方式除去你们中间的邪恶。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","“如果某些案件难于裁断，如人命案，争讼案，各类伤害案或是其他发生在你们城中的纠纷案件，那么，你们要到主－你们的上帝选定的地方去， ");
INSERT INTO cmn2006_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","把它们提交给当时的利未人祭司和现任的法官，请他们裁断。他们将会告诉你们该案件的裁定结果。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","你们必须严格按照他们在主选定的地方告诉你们的话去做，遵从他们的一切指示。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","你们必须将他们给你们的指示和通知你们的有关决定付诸实施，不可有丝毫背离删改。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","凡举止傲慢、拒不服从祭司－在主，你们的上帝面前侍立供职的人－和法官的人，都必须处死。你们要用这种方式除去以色列人中间的邪恶， ");
INSERT INTO cmn2006_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","好让民众听到这件事以后心怀畏惧，没有人再敢狂傲行事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","“当你们进占了主－你们的上帝要赐给你们的土地并在那里定居下来以后，你们或许会说∶‘我们也象周围的列国那样立一位王来治理我们吧！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","你们要记住，必须立一位主－你们的上帝所拣选的人来治理你们。你们要从自己的同胞中选立君王，决不可立外族人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","而且，被选立的君王不可为自己搜罗马匹，更不可为了给自己弄到更多的马匹而派人回埃及去买马，因为主告诫过你们∶‘你们决不可再走那条回头路。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","他不可为自己广置妃嫔，否则他就会背离主的意愿；也不可为自己广积金银，贪图财富。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","他登基之后，一定要按照利未人祭司保存的律法书为自己抄录一份， ");
INSERT INTO cmn2006_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","带在身边，终生研读，学习怎样敬畏主－他的上帝，怎样谨守律法和条例所规定的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","这样，他就不会自以为比他的同胞优越而或多或少违背主的诫命，他和他的后代也就能长久统治以色列。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","“利未人祭司，其实也就是整个利未支派，将不象其他以色列人一样拥有自己的一份土地。他们以献给主的祭物和自己的应得之份为生。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","利未支派在自己的同胞中间没有自己的产业。主就是他们的产业，这是主对他们的应许。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","“民众献上的牲祭，无论是牛还是羊，它们的前腿、两颚、肚子要归祭司所有，这是祭司的应得之份。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","你们要把初收的五谷、新酒、橄榄油和初次剪下的羊毛交给他们， ");
INSERT INTO cmn2006_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","因为主－你们的上帝从你们各支派中拣选了利未和他的子孙作为祭司永远侍奉他，奉他的名宣布福音。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","如果某个利未人离开他在以色列居住的城镇，随便什么时候来到主选定的地方， ");
INSERT INTO cmn2006_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","他可以象当地侍奉主的那些利未人同胞一样奉主－他的上帝的名侍奉主。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","他将得到跟其他利未人同样的份额。此外，他仍然可以得到自己家族的应得之份。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“你们进入主－你们的上帝要赐给你们的土地之后，不可仿效这些民族的邪恶习俗， ");
INSERT INTO cmn2006_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","不可把自己的儿女当作祭物放在祭坛上烧死；不可占卜、观兆、行巫术， ");
INSERT INTO cmn2006_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","使符咒、求鬼魂、问亡灵。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","凡做这类事的人都是主－你们的上帝所厌恶的。正是由于这些邪恶的行为，主－你们的上帝才要把这些民族赶出你们面前的这块土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","所以，你们一定要绝对忠实于主－你们的上帝 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","“这些即将被你们赶走的民族听信巫师和占卜者的话，而主－你们的上帝不准你们效法他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","他会从你们的同胞中兴起一位象我一样的先知，把他派给你们，你们要听从他的话。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","这也是你们聚集在何烈山那天对主－你们的上帝的请求。当时，你们说∶‘不要让我们再听见主－我们的上帝的声音，不要让我们再看见这大火吧，否则，我们准得死了！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","“于是，主对我说∶‘他们的话是对的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","我要从他们的同胞中间兴起一位象你一样的先知，把他派给他们。我把要说的话告诉他，他再把我吩咐他的一切告诉他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","谁不听从他奉我的名所说的话，我就要亲自惩罚谁。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","“如果有先知擅敢假借我的名说我并未吩咐他说的话，或者以别神的名义说预言，这个先知将必死无疑。 ");
INSERT INTO cmn2006_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","也许你们要想∶‘我们怎么能知道哪些话不是主吩咐他的呢？’ ");
INSERT INTO cmn2006_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","如果有先知自称他奉主的名说话，而事情并没有发生，他的话没有实现，那么，他所说的话就不是出自主，只代表他自己，你们不必怕他说的话。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","“当主－你们的上帝毁灭了他要赐给你们的土地上的其他民族，让你们赶走了他们并在他们的城镇和家园里定居下来以后， ");
INSERT INTO cmn2006_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","你们要从主－你们的上帝赐给你们的这块土地上划出三座城来。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","你们要先量好距离，把主－你们的上帝赐给你们作为产业的这块土地分成三部分，在每部分中选择一座城，并修好通往它们的路，好让杀了人的人能够逃到那里去避难。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","“以下是杀人者到那里避难的条例。如果他与被害人毫无宿怨，失手杀了他； ");
INSERT INTO cmn2006_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","举例说，某人跟他的邻居一起到森林里去伐木，当他举起斧头砍树的时候，斧头脱了把，击中了他的邻居，把他打死了。这时，他可以逃到这三座城的任何一个里去避难。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","但如果到这些城的路途太远，死者的亲属就有可能追上抓住他，在狂怒之下把他杀死，尽管他跟被害人素来无仇，罪不当死。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","所以，我命令你们必须设立三座城。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","9","“如果你们谨守我今天颁布给你们的这一切，爱主－你们的上帝，一直按照他要求的方式生活，主－你们的上帝就会按照他对你们祖先的应许扩大你们的领土，把他应许赐给你们祖先的土地全部都赐给你们，到那时，你们必须再增加三座城。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","这样，在主－你们的上帝赐给你们作为产业的土地上就不会有无辜的人被杀，而你们也不致因造成无辜人的屈死而获罪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","“但是，如果某人仇恨另一个人，暗地里伺机袭击他，杀死了他，然后逃进了其中的一座城。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","他本城的长老就要派人去把他押回来，交给死者的亲属，把他处死， ");
INSERT INTO cmn2006_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","决不可姑息。你们一定要从以色列中除掉杀害无辜者的罪恶，只有这样，你们才能事事顺利。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","“不可在主－你们的上帝即将赐给你们的土地上挪动邻居原始设定的划分产业的标志。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","“只凭一个证人不足以定罪；至少要有两至三个证人才能定罪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","“如果有人心怀歹意做伪证，指控他人冒犯了上帝， ");
INSERT INTO cmn2006_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","这两个争讼的人就要到主的面前，请求祭司和当时在任的法官裁决。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","法官必须详细查究，如果发现证人做了伪证陷害他的同胞， ");
INSERT INTO cmn2006_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","你们必须按他本想加给他同胞的罪名制裁他，从你们中间除掉这种邪恶的事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","21","你们对这种人不必怜悯，要以命抵命，以眼还眼，以牙还牙，以手还手，以脚还脚。这样，其他人听到裁决就会心怀畏惧，没有人再敢在你们中间做这种邪恶的事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","“当你们出征跟敌人交战，看见他们的战车、战马和军队多于你们的时候，你们不要畏惧他们，因为领你们出埃及的主－你们的上帝与你们同在。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","“在你们投入战斗之前，祭司要站到军队的前面， ");
INSERT INTO cmn2006_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","对全体战士说∶‘以色列人哪，你们听着！今天，你们就要去跟你们的仇敌作战了！不要畏缩，不要害怕，不要惊慌，不要被他们吓倒！ ");
INSERT INTO cmn2006_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","因为主－你们的上帝将跟你们一同出战，他将为你们去打击你们的仇敌，他会拯救你们。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","“然后，长官要向战士们宣布∶‘凡造了新房还没有行奉献礼的可以回去，以免他一旦阵亡，别人奉献了他的房子； ");
INSERT INTO cmn2006_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","凡栽了葡萄园还没有受益的可以回去，以免他一旦阵亡，别人坐享其成； ");
INSERT INTO cmn2006_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","凡订了婚还没有迎娶的可以回去，以免他一旦阵亡，别人娶了他的未婚妻。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","“然后，长官还要对他的部队说∶‘凡心虚怯战的都可以回去，不要影响别人的士气。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","宣布完毕以后，他们才可以指命各指挥官带领军队出战。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","“当你们逼近一座城市向它进攻的时候，一定要先给对方一个归降的机会。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","如果对方接受了你们的和平建议，开城归降，那么城里所有的人都要服苦役，为你们做工。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","如果对方拒不投降，跟你们兵戎相见，那么，你们就要围困那座城。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","当主－你们的上帝把这座城交到你们手里以后，你们要杀光城里的所有男人， ");
INSERT INTO cmn2006_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","但可以为自己留下其中的妇女、儿童、牲畜和其他东西，归自己享用。你们仇敌的这些东西是主－你们的上帝赐给你们的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","对于距离你们要定居的地方很远的城市，你们都要这样处置。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","但对于主－你们的上帝要赐给你们作为产业的那些民族的城市，你们必须不留一个活口。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","“你们要遵照主－你们的上帝的命令，彻底消灭赫人、亚摩利人、迦南人、比利洗人、希未人、耶布斯人， ");
INSERT INTO cmn2006_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","免得他们把他们拜神的种种恶习传给你们，使你们得罪主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","“当你们长期围攻某城以图攻取的时候，不可砍掉该城周围的果树。你们可以吃树上的果子，但不可以把树砍倒，因为树木不是你们的敌人，不应该毁坏它们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","但是，你们可以砍其他不结果子的树种。你们可以伐倒这些树，用它们制作攻城器具，攻打跟你们交战的城池，直至把城攻下。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","“在主－你们的上帝要赐给你们作为产业的土地上，如果发现有人被谋杀，抛尸野外，却不知道凶手是谁， ");
INSERT INTO cmn2006_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","那么，你们的长老和法官必须到现场去，测量从尸体到周围各个城镇的距离。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","距离最近的那座城的长老要选一头没有驾过轭干活儿的小母牛， ");
INSERT INTO cmn2006_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","把它牵到一个长年有溪水流淌并且从来没有耕种过的山谷里，在那里打断它的脖子。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","利未族的祭司也必须到场，因为主－你们的上帝拣选了他们，让他们侍奉他，奉他的名祝福，并由他们负责裁决各种争讼和伤害案件。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","距离最近的那座城的所有长老都必须在被打断脖子的小母牛的身体上方洗净手， ");
INSERT INTO cmn2006_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","然后要祷告说∶‘我们没有杀这个人，也没有看见这件事是怎样发生的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","主啊，求你饶恕你所救赎的以色列子民，不要因这无辜者被谋杀而责怪他们。’这样，他们就不会因这流血的罪而受到责罚。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","而你们由于做了主所赞许的事，也就除掉了你们中间谋害无辜者的罪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","“你们跟仇敌作战的时候，主让你们打了胜仗，抓了俘虏。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","你在战俘中发现一个美丽的女子，被她所吸引，想要娶她为妻。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","那么，你要把她带回你的家中，让她剃掉头发，剪掉指甲， ");
INSERT INTO cmn2006_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","脱去战俘的衣服，留在你的家里为她的父母哀哭一个月。然后，你才可以跟她成婚，与她同床，而她则成为你的妻子。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","假如后来你不喜欢她了，那么，你必须还她自由，放她去她愿意去的任何地方，而不可以象对待奴隶一样对待她，把她卖掉，因为你已经强迫她跟你有了性关系。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","“假如有人有两个妻子，他宠爱其中的一个，嫌弃另一个。两个妻子都给他生了儿子，而长子恰恰是他嫌弃的那个妻子生的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","到了给儿子们分家产的时候，他不可把他宠爱的妻子的儿子立为长子，置于他所嫌弃的妻子所生的长子之上； ");
INSERT INTO cmn2006_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","他必须承认他嫌弃的妻子的儿子为长子，分给他双份家产。因为长子是他作为父亲身份的首次证明，长子权应当属于他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","“假如有人有个顽劣忤逆的儿子，虽然屡经惩戒，仍然不服父母管教， ");
INSERT INTO cmn2006_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","他的父母就要把他带到城门口本城的长老们那里， ");
INSERT INTO cmn2006_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","对长老们说∶‘我们的这个儿子顽劣忤逆，不服我们的管教，整天贪食好酒。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","城里的人要一起用石头打死他。你们要用这种方式除去你们中间的恶人，以此儆戒所有的以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","“如果有人犯了死罪，处死后被吊在木柱上， ");
INSERT INTO cmn2006_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","你们不可让尸体留在木柱上过夜，而必须当天埋掉，因为悬挂在木柱上的尸体是受上帝诅咒的。你们不可玷污主－你们的上帝要赐给你们作为产业的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","“你们不可看见你们以色列同胞走失的牛羊而不管。你们要把它们牵回来，还给你们的以色列同胞。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","如果失主的住处离你们很远，你也不认识他，那么，你可以把牲畜牵回家去，留在你那里，等失主来找时再还给他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","你们见到你们同胞丢失的驴或衣服或其他别的东西，都要同样处理，不可以袖手不管。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","“你们不可看见你们以色列同胞的驴或牛跌倒在路上而不管。你们要帮助主人把牲畜拉起来。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","“女人不可以穿男装，男人也不可以穿女装，因为凡有这种行为的人都是主－你们的上帝所厌恶的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","“如果你们在树上或地上碰见一个鸟巢，巢里有雏鸟和鸟蛋，母鸟正在孵蛋或哺育小鸟，你们不可将母鸟和小鸟一起都拿走。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","你们只可以拿走小鸟，而要放掉母鸟。这样，你们就会一生顺利，得享高寿。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","“你们造新房的时候，一定要在房顶的四周造上矮围墙，这样，即使有人从房顶上跌了下去，你们也不会因此而获罪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","“不可在葡萄园中又种别的作物；否则，葡萄园中出产的谷物和葡萄都要归圣。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","“不可用牛和驴一起耕地； ");
INSERT INTO cmn2006_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","“不可穿用羊毛和麻纱混合织成的衣服； ");
INSERT INTO cmn2006_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","“外袍的四角要缝上穗子。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","“有人娶了一个女子，跟她有了性关系。后来，他嫌弃她了， ");
INSERT INTO cmn2006_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","就当众指责她，说她行为不端，说∶‘我是娶了这个女人，可是当我跟她同房的时候，发现她不是处女。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","这时，这年轻女子的父母要带着她贞洁的证据去城门口见本城的长老们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","她的父亲要对长老们说∶‘我把我的女儿嫁给这个人为妻，可是现在他嫌弃她了， ");
INSERT INTO cmn2006_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","还指控她行为不端，说∶“我早就发现你的女儿不是处女。”请看，这儿就是我女儿贞洁的证据。’随后，他要在本城长老们的面前展开她新婚之夜染血的床单。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","这时，本城的长老要拿住那人鞭打他， ");
INSERT INTO cmn2006_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","还要罚他一百块银子，把钱交给这年轻女子的父亲，因为他侮辱了以色列的处女。她仍然是他的妻子，并且他终生不能离弃她。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","“但是，如果这人的指控是真实的，这年轻女子没有证明自己贞洁的证据， ");
INSERT INTO cmn2006_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","那么，长老们就要把她带到她父亲家的门前，由本城的男子用石头打死她，因为她婚前住在父亲家里时就跟别人有了性关系，在以色列做了可耻的事。你们要用这种方式除掉你们中间这种邪恶的事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","“如果有人跟别人的妻子通奸，被人发现，两个人都必须处死；你们要用这种方式除掉以色列中的这类邪恶。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","“如果有人在城里遇见一个已经订婚的处女，奸污了她， ");
INSERT INTO cmn2006_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","那么，你们要把两人都带到城门口去，用石头打死他们。那年轻女子该死，是因为她虽在城里却没有尖叫呼救；那人该死，是因为他玷污了别人的妻子。你们要用这种方式除去你们中间的这类邪恶。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","“但是，如果那人是在野外遇见了那已经订婚的年轻女子，强奸了她，那么，只有那男子该处死， ");
INSERT INTO cmn2006_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","而这年轻女子并没有犯该死的罪，你们不可对她有任何伤害。这种情况就象有人袭击并杀死他人一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","他是在野外遇见这已经订婚的年轻女子的，她或许曾尖叫呼救过，但没有人救她。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","“如果有人遇见一个没有订婚的处女，强奸了她；被人抓住后， ");
INSERT INTO cmn2006_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","这男人必须给这年轻女子的父亲五十块银子娶她为妻，并且终生不得离弃她。因为他玷污了她。 ");
INSERT INTO cmn2006_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","“不可娶父亲的前妻，羞辱自己的父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","“睾丸受伤的人或阉人不得加入主的会众。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","“私生子不得加入主的会众；他们的子孙均不得加入主的会众，即便下传到第十代也是如此。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","“亚扪人或摩押人不得加入主的会众，他们的子孙均不得加入主的会众，即便下传到第十代也是如此。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","因为当你们出埃及的时候，他们不但不供给你们旅途所需的粮食和水，反而从座落在美索不达米亚西北的毗夺城雇了比珥的儿子巴兰来诅咒你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","但是，主－你们的上帝不听巴兰的话，反而把他的诅咒转为祝福，因为主－你们的上帝爱你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","只要你们还活在这个世上，你们就不要企图帮助他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","“不可嫌弃以东人，因为他们是你们的亲族；不可鄙视埃及人，因为你们曾在他们的国家寄居。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","他们的第三代子孙可以加入主的会众。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","“你们在外出征战期间，要远避任何可能使你们不洁净的事物。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","你们中间如果有人因夜间梦遗而不洁净，他必须离开营地，留在营外。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","傍晚时分，他必须沐浴净身，直到太阳落山以后才能返回营里。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","“你们在营外还必须有一个作厕所的地方。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","在你们的装备中要有一把锹，当你们出营上厕所时，要先用锹在地上挖一个洞，便溺后必须掩盖好。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","因为主－你们的上帝就在你们的营中与你们同行，他要拯救你们，要帮助你们打败你们的仇敌。所以，你们的营地必须保持圣洁，以免他因为看见你们中间的可厌之物而离弃你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","“你们不可把逃到你们那里的奴隶遣还给他的主人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","他可以在你们当中任何一个他喜欢的城镇里选择一个地方，跟你们住在一起，你们不可虐待他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","“以色列的妇女不准做妓女，以色列的男子也不准做男妓； ");
INSERT INTO cmn2006_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","不准把用这种方式得来的钱带到主－你们的上帝的圣殿里去向主还愿，因为男妓和女妓都是主－你们的上帝所厌恶的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","“你们借钱、粮食、或任何其他东西给你们的以色列同胞，都不可计算利息。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","借给外族人的可以计息，但借给以色列同胞的则不可计息。这样，主－你们的上帝才会在你们即将进占的土地上事事赐福给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","“如果你们向主－你们的上帝许了愿，不要迟迟不还愿。因为主－你们的上帝必定要向你们追讨所许下的愿，那时，你们就会因没有及时还愿而获罪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","不向主许愿不算有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","但你们必须信守自己许诺要做的事，要象你们自己亲口向主－你们的上帝自愿许下的愿一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","“经过别人的葡萄园时，可以随意吃园中的葡萄，但不可以把葡萄装在蓝子里带走； ");
INSERT INTO cmn2006_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","经过别人的田时，可以用手摘穗子吃，但不可以用镰刀割下来带走。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","“如果有人娶了一个女子为妻，后来发现她做了令人厌恶的事，不再喜欢她，给她写了休书，叫她离开； ");
INSERT INTO cmn2006_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","如果她离开他以后又嫁了一个人， ");
INSERT INTO cmn2006_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","而这第二个丈夫也不喜欢她，写了休书叫她离开；或者第二个丈夫死了； ");
INSERT INTO cmn2006_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","无论哪一种情况，第一个打发她走的丈夫不可再跟她结婚。因为对于她的前夫来说，她已经不洁净了。主憎恶这种事情。你们不可将这种罪过带进主－你们的上帝要赐给你们作为产业的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","“新婚的人不可从军，也不可担任公职，他要在家中无拘无束地住一年，好让新婚的妻子快乐。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","“不可拿欠债人的磨盘作抵押，即使只是上一半磨盘也不行，因为这等于夺走了他的生计。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","“凡绑架自己的以色列同胞，强迫他做奴隶或把他贩卖为奴的人，一旦发现必须处死。你们一定要除掉你们中间的这类邪恶。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","“染上恶性皮肤病之后，必须极其谨慎地遵从利未人祭司给你们的一切指导，严格按照我吩咐他们的话去做。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","要记住主－你们的上帝在你们出埃及后的旅途中是怎样对待米利暗的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","“你们无论借给别人什么，都不可以进他的家去拿作抵押的东西。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","你要站在门外等着，由借债人出来把抵押物交给你。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","如果有人很穷，你们不可把他给你们当作借债抵押品的衣服留下过夜， ");
INSERT INTO cmn2006_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","必须在当天太阳下山之前还给他，好让他能够穿上衣服睡觉。他会因此祝福你们，主－你们的上帝也会赞许你们的作法。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","“不可占贫苦无助的雇工的便宜，无论他是你们的以色列同胞还是寄居在你们国内某个城里的外族人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","你们必须在当天太阳落山之前付清工资；因为他很穷，要靠他的工资维持生计。如果你们不这样做，他会向主控告你们，你们会因此而获罪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","“父母不因子女的罪被处死，子女也不因父母的罪被处死；各人只承当自己的死罪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","“不可剥夺住在你们中间的外族人和孤儿的权益；不可拿寡妇的衣服作抵押； ");
INSERT INTO cmn2006_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","要记住你们自己也曾在埃及做过奴隶，是主－你们的上帝把你们从那里解救出来。因此，我命令你们，一定要这样对待孤苦无助的人∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","“你们在田里收割的时候，一定不可回去取忘在地里的庄稼，它要留给外族人、孤儿和寡妇。你们这样做，主－你们的上帝会在你们所做的一切事情上赐福给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","你们从树上往下打橄榄的时候，不可以回去打留在枝上的橄榄，剩下的橄榄要留给外族人和孤儿寡妇。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","摘葡萄的时候，不可回去再摘剩下的；剩下的葡萄要留给外族人和孤儿寡妇。 ");
INSERT INTO cmn2006_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","要记住，你们也曾在埃及做过奴隶；因此，我命令你们，一定要这样对待贫苦无助的人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","“当两个人发生纠纷的时候，他们要到法庭上去解决。法官要为他们裁决，宣布其中一人无罪而另一人有罪。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","如果有罪的人该受鞭刑，法官要命令他趴在地上，当面按他应该受责的次数鞭打他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","但鞭打的次数最多不能超过四十下，否则，你们的同胞就是在公开受辱。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","“牛在场上碾谷的时侯，不可罩住它的嘴不让它吃东西。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","“如果兄弟在一起生活，其中一个人死了，没有留下子嗣，那么，死者的遗孀不得嫁给夫家家族以外的人。她丈夫的兄弟应该娶她，跟她行夫妻之礼，尽其做小叔的义务。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","婚后她生的第一个儿子要归在已故兄弟的名下，使他的姓氏不致在以色列湮灭。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","如果死者的兄弟不肯娶她，那么，她就要到城门口去见本城的长老，告诉他们∶‘我丈夫的兄弟不肯尽做小叔的义务替他的兄弟在以色列中立嗣。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","本城的长老们要把那兄弟召来，跟他谈话。如果他坚持说∶‘我不愿娶她。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","他兄弟的妻子就要走到他面前，当着长老们的面脱掉他脚上的鞋，并向他的脸上吐唾沫，说∶‘对不肯替兄弟立嗣的人就要这样对待他！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","他的家从此要在以色列中被称做‘被脱鞋人之家。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","“如果两个人打架，其中一个人的妻子为了援救挨打的丈夫，伸手去抓另一个人的生殖器， ");
INSERT INTO cmn2006_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","那么，你们必须砍掉她的手，不可存丝毫恻隐之心。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","“你们的身上不可带有一重一轻的两套砝码； ");
INSERT INTO cmn2006_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","你们的家里不可保存一大一小的两种量具； ");
INSERT INTO cmn2006_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","你们只可以使用计量准确、诚实无欺的砝码和量具，只有这样，你们才能在主－你们的上帝要赐给你们的土地上长久生活下去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","凡行为诡诈，使用假砝码和假量具的人都是主－你们的上帝所厌恶的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","“要记住亚玛力人在你们出埃及后的旅途上是怎样对待你们的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","当时你们疲惫不堪；他们跟你们遭遇，从背后袭击你们，截杀了所有落在后面的人。这些亚玛力人不敬畏上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","当主－你们的上帝在他要赐给你们作为产业的土地上赐给你们四境平安以后，你们一定要把亚玛力人从世界上彻底消灭掉！千万不要忘记！ ");
INSERT INTO cmn2006_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","“你们进占了主－你们的上帝要赐给你们作为产业的土地并在那里定居下来以后， ");
INSERT INTO cmn2006_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","要把从主－你们的上帝赐给你们的土地上收获的各种初熟的土产取出一部分，装进篮子，带到主－你们的上帝选定的荣耀他的名的地方去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","你们要去见当值的祭司，对他说∶‘今天，我来告诉主－你的上帝，我已经到了主向我们祖先发誓要赐给我们的土地上了。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","“祭司要从你手中接过篮子，把它放在主－你们的上帝的祭坛前。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","然后，你要在主－你们的上帝面前祈祷∶‘我的先祖原先是个流浪的亚兰人。后来，他去了埃及，寄居在那里，那时他的家族人口很少。后来，他的家族在那里发展成了人数众多的强大的家族。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","埃及人对我们暴虐视事，折磨我们，强迫我们做苦工。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","因此，我们向主－我们祖先的上帝求告。主垂听了我们的祷告，看见了我们的痛苦、艰辛和所遭受的迫害。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","于是，主施行神迹，以他的大能力和令人恐怖的作为把我们领出了埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","他把我们带到这里，把这块流奶与蜜的土地赐给了我们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","主啊，现在我把你赐给我的这块土地上初次收获的出产给你带来了。’ “然后，你们要把篮子放到主－你们的上帝的面前，并向主－你们的上帝跪拜。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","你们要为主－你们的上帝赐给你们和你们家人的所有这一切好东西而欢乐，也要邀请住在你们中间的利未人和外族人一起庆祝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","“每隔三年，你们要从当年的收成中提取出十分之一，把它们送给利未人、寄居的外族人，以及孤儿和寡妇，使他们在你们的各个城镇中都能吃得饱饱的。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","然后，你们要祷告主－你们的上帝，说∶‘我已经遵照你的命令，把收成中的神圣部分从家里拿了出来，送给了利未人、寄居的外族人和孤儿寡妇。我没有违背也没有忘记你的任何诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","我没有在哀伤的时候吃过这圣物，没有在不洁净的时候触碰过它们，也没有用它给死者当过供品。我一直服从你，遵守你给我的一切命令。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","主啊，求你从天上圣洁的居所看顾我们，赐福给你的以色列子民，也赐福给你应许我们的祖先赐给我们的这块流奶与蜜的土地。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","“今天，主－你们的上帝命令你们遵行他的一切律法和条例，你们务必要全心全意地遵守它们； ");
INSERT INTO cmn2006_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","今天，你们要与主立约∶主是你们的上帝，你们要按照他要求的方式去生活，听从他的教诲，遵守他的一切律法、条例和诫命； ");
INSERT INTO cmn2006_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","今天，主也要与你们立约∶他将按照他的应许承认你们做他珍爱的子民，而你们必须遵行他的一切诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","他使你们得到的赞颂、声望和荣耀将远胜于他所造的任何其他民族，你们必定会按照他的应许，成为主－你们的上帝的圣洁的子民。” ");
INSERT INTO cmn2006_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","摩西和以色列的长老们告诫民众说∶“你们一定要遵守我今天向你们颁布的一切命令。 ");
INSERT INTO cmn2006_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","你们在渡过约旦河进入主－你们的上帝赐给你们的土地的当天，要竖立起一些大石，涂上白灰， ");
INSERT INTO cmn2006_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","并在渡河之后立即把全部律法条文都写在上面。这样你们就能按照主－你们祖先的上帝的应许，进入主－你们的上帝要赐给你们的那块流奶与蜜的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","“你们渡过约旦河之后，要把我今天吩咐你们准备的这些石头竖立在巴路山上，并涂上石灰， ");
INSERT INTO cmn2006_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","还要在那里用未经铁器錾凿过的石块为主－你们的上帝建造一座祭坛。 ");
INSERT INTO cmn2006_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","你们一定要用没有凿过的石头建造主－你们的上帝的祭坛，并在上面向主－你们的上帝献上烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","你们也要在那里献平安祭，吃祭牲的肉，在主－你们的上帝面前尽情欢乐。 ");
INSERT INTO cmn2006_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","你们要把这部律法的全部条文都写在你们竖立的石头上，使它们便于阅读。” ");
INSERT INTO cmn2006_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","接着，摩西和利未支派的祭司们对全体以色列人说∶“以色列人哪，你们要静下心来听着！今天，你们已经成了主－你们的上帝的子民。 ");
INSERT INTO cmn2006_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","你们必须服从主－你们的上帝，遵行我今天向你们颁布的他的全部条例和诫命。” ");
INSERT INTO cmn2006_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","当天，摩西还向民众发布了如下命令∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","“你们渡过约旦河以后，西缅、利未、犹大、以萨迦、约瑟、便雅悯支派的人要站在基利心山上为民众祝福， ");
INSERT INTO cmn2006_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","吕便、迦得、亚设、西布伦、但、拿弗他利支派的人要站在以巴路山上宣布诅咒； ");
INSERT INTO cmn2006_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","“利未人要向全体以色列人大声宣布∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","‘凡制作主所憎恶的偶像，无论是雕刻的还是铸造的人工制品，并偷偷供奉膜拜的人，必受诅咒！’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“利未人说∶‘凡不孝敬父母的人，必受诅咒！’全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“利未人说∶‘凡挪移邻居界碑的人，必受诅咒！’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“利未人说∶‘凡故意领盲人走错路的人，必受诅咒！’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“利未人说∶‘凡不公正对待寄居的外族人和孤儿寡妇的人，必受诅咒！’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“利未人说∶‘凡跟父亲的妻妾发生性关系的人，必受诅咒！因为他侮辱了他的父亲。’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“利未人说∶‘凡有兽淫行为的人，必受诅咒！’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“利未人说∶‘凡跟自己的嫡亲姐妹或非嫡亲姐妹发生性关系的人，必受诅咒！’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“利未人说∶‘凡跟岳母发生性关系的人，必受诅咒！’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“利未人说∶‘凡暗地杀人的人，必受诅咒！’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“利未人说∶‘凡收受贿赂杀害无辜的人，必受诅咒！’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","利未人说∶‘凡不守本律法、不循本律例的人，必受诅咒！’ “全体民众要回答∶‘阿们！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","“只要你们真心服从主－你们的上帝，谨守我今天颁布给你们的他的全部诫命，那么，主－你们的上帝就会使你们凌驾于世上的万国之上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","只要你们顺从主－你们的上帝，一切福泽都将降临在你们身上∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","“主将赐福给你们的城市和乡村； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","“主将赐福给你们，使你们多子多孙； “主将赐福给你们的土地，使你们五谷丰登； “主将赐福给你们的牛羊，使牛犊遍地，羊羔成群； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","“主将赐福给你们的篮子和揉面盆，使它们时时不空； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","“主将赐福给你们，使你们出入平安； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","“主将让你们击败来犯的仇敌；他们从一条路来攻击你们，却要向七条路上奔逃； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","“主将使你们的谷仓充满，他将在你们所做的一切事情上赐福给你们，他的赐福将在他要赐给你们的那块土地上降临在你们身上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","只要你们遵守主－你们的上帝的诫命，按照他要求的方式生活，那么，主一定会按照他对你们的应许，使你们成为他的圣洁的子民。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","那时，世上的万民看见你们是蒙主应许的民族，他们会因此而畏惧你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","“主将使你们在他应许你们的祖先要赐给你们的土地上繁荣起来，使你们子孙昌盛、牛羊成群、五谷丰登。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","主将为你们打开天上储满祝福的库府，适时给你们的田地降下雨水，赐福给你们所做的一切事情。你们将向列国出借钱财，而不必向别国借贷； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","你们将居人之上，而不必仰人鼻息；你们将独占首位，而不会屈身事人。只要你们谨守我今天颁布给你们的主－你们的上帝的诫命，遵行不误， ");
INSERT INTO cmn2006_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","不违背我吩咐你们的任何话，不去追随侍奉别的神明，那么这一切都会实现。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","“但是，如果你们不顺从主－你们的上帝，不切实遵守我今天向你们颁布的他的全部诫命和条例，那么，一切诅咒必将落到你们的身上∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","“主将诅咒你们的城市和乡村； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","“主将诅咒你们的篮子和揉面盆，让它们无物可盛； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","“主将诅咒你们，让你们子孙寥寥，庄稼歉收，牛羊稀少； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","“主将使你们出入遭难，事事受诅咒； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","“主将把诅咒、动乱加在你们的身上，使你们事事不顺利，直至你们很快被灭绝掉。因为你们行为邪恶，离弃了主； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","主要把可怕的疾病加在你们身上，把你们从将要进占的土地上消灭掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","主要用恶病、热病、毒疮和热风、旱灾、霉病惩罚你们，让它们缠扰你们，直至你们彻底被灭绝掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","你们头上的天将象铜一样滴雨皆无，你们脚下的地将如铁一样板结干硬。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","主将遣下风沙代替雨水，让它肆虐在你们的土地上，直至把你们全部消灭掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","“主要让你们的仇敌打败你们。你们从一条路上出发作战，却要向七条路上奔逃。世上的万民听到你们遭遇的厄运都悚然怀惧。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","你们的尸体将成为飞禽走兽的口中之食，没有人能赶走它们； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","“主将使你们身上长满无药可医的毒疮、肿瘤和疥疮，就象当年埃及人的遭遇一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","主要惩罚你们，使你们变疯、变瞎、变傻， ");
INSERT INTO cmn2006_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","你们白天走路就象盲人在黑暗中胡乱摸索，你们所做的事都一败涂地。你们不断地受迫害，受掳掠，没有一个人会来救你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","“你们聘了妻，别人却奸污了她；你们造了房，别人却住了进去；你们培植了葡萄园，别人却坐享其成。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","你们眼看着自己的牛被宰杀，却吃不到它的肉；你们眼看着自己的驴被拉走，却再也不见它被送回来；你们的羊群被仇敌抢走，却没有人来援救你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","“你们的儿女被异族掳走，你们只能每天眼巴巴地盼望，却束手无策。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","“跟你们素不相识的民族要来收获你们的出产，享受你们辛勤劳动的果实，而你们则要终生受人虐待。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","你们举目所见的一切都要使你们发疯！ ");
INSERT INTO cmn2006_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","主要使你们的膝盖上，双腿上，从头到脚都长满痛苦不堪的毒疮，无法治愈。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","“主要把你们和你们选立的君王放逐到你们祖先所不知道的外乡异邦去，你们要在那里侍奉木头和石头做的神明。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","主要把你们放逐到列国之中，那里的人民对你们遭受的厄运难以置信，他们要嘲弄你们，拿你们当做笑柄。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","“你们种得多，却收得少，因为蝗虫将要吃掉庄稼； ");
INSERT INTO cmn2006_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","你们培植了葡萄园，辛勤劳作，却收不到葡萄，喝不到新酒，因为虫子要吃掉葡萄。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","你们在境内栽满橄榄树，却没有橄榄油用，因为橄榄都将落地烂掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","你们有儿有女，却无力把他们留在身边，因为他们要被掳走。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","蝗虫要吃光你们所有的庄稼和树木。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","寄居在你们中间的外族人将日益强大，而你们将日渐衰微。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","你们要向他们借贷，自己却无力借贷给他们；他们将成为人上人，而你们将无足轻重。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","“这一切灾难都要降临到你们身上，这一切诅咒都要紧紧地追随着你们，缠扰着你们，直到你们全部灭亡；因为你没有顺从主－你们的上帝，没有遵守他的诫命和条例。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","这些使世人瞠目结舌的诅咒表明了主－你们的上帝对你们和你们子孙的永久的审判。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","“由于你们没有因主对你们的丰盛赐福而以快乐和感激的心侍奉主， ");
INSERT INTO cmn2006_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","所以，主要把重轭加在你们的颈上；他要派遣你们的仇敌攻打你们，使你们忍饥受渴，赤身露体，一无所有，直到灭亡。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","“主将从遥远的天边兴起一个民族，你们听不懂他们的语言，这个民族将象从高空疾冲而下的鹰一样攻击你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","这是一个残酷无情的民族，它不顾恤老年人，也不怜悯幼小的儿童。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","它要吞下你们的幼畜和田间的出产，把你们的粮食、新酒、橄榄油、牛犊、羊羔一扫而光，直到把你们灭绝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","“它将围攻主－你们的上帝赐给你们的土地上的一切城市，摧毁你们所倚赖的高大坚固的城墙。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","当你们的仇敌围困你们，使你们陷入绝境的时候，你们将不得不吃掉自己的儿女，那是主－你们的上帝赐给你们的亲生骨肉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","“甚至最仁慈宽容的男人也会对他的兄弟、他的爱妻、他仅存的儿女吝啬， ");
INSERT INTO cmn2006_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","不肯把正在吃着的自己儿女的肉分给他们，因为他再也没有别的东西了！ ");
INSERT INTO cmn2006_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","“最优雅、最溺爱儿女、连路都不愿走的女人也会对自己心爱的丈夫和儿女变得同样残忍， ");
INSERT INTO cmn2006_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","当你们的仇敌围困了你们的城市，使你们陷入绝境的时候，她也要因一无所有而偷偷地吃自己的婴儿和胞衣，不肯分一点给别人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","“如果你们不遵守这律法书中所记载的全部条文，不敬畏主－你们的上帝荣耀而可畏的名， ");
INSERT INTO cmn2006_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","那么，主就要把可怕的灾难降到你们和你们子孙后代的身上，这是一些严重的、长年不愈的、痛苦不堪的疾病。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","主将把当年加在埃及人身上的所有疾病都加到你们身上，这些令你们心悸的疾病将紧紧缠住你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","主还要把这律法书中没有记载的各种疾病加在你们的身上，直到把你们消灭掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","尽管你们曾经象天上的星星一样多，但只有极少的人能够幸存下来。因为你们没有顺从主－你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","“主曾经决心要使你们繁荣，使你们的人口日益昌盛；同样，他也将发自内心要毁灭你们，把你们从你们即将进占的土地上彻底消灭掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","主将把你们放逐到世界各地的各个民族之中，你们要在那里侍奉你们祖先从来不曾拜过的异神，那是些木头和石头造的神明。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","“你们在列国之中没有安宁，没有自己的立足之地，主在那里给予你们的，只是一颗颤栗的心、一双哭干的眼睛和一个嘶哑的喉咙。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","你们的生命时时处在危险之中；你们日夜忧虑，不知道能不能活得下去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","由于内心的恐慌和举目所见的一切，你们早晨说∶‘快点到晚上吧！’到了晚上，你们又说∶‘快点到早晨吧！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","主将把你们装上船，循着我曾应允你们永不再见的路送回埃及去。在那里，你们的男男女女即使想卖身给仇敌作奴隶，也没有人买。” ");
INSERT INTO cmn2006_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","以下是主命令摩西在摩押地跟以色列人立约的内容。这是他跟他们在何烈山所立的约之外立的约。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","摩西召集全体以色列人，对他们说∶“你们亲眼看见了主在埃及对埃及王和他的臣仆以及整个王国所做的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","你们看见了主降下的可怕的灾祸和他所行的神迹奇事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","但是直到今天，你们仍然没有理解所发生的一切，主还没有赐给你们真正明白所闻所见的确切意义的能力。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","主说∶‘我在旷野里引导你们四十年之久，在这期间，你们身上的衣服和脚上的鞋都没有穿破， ");
INSERT INTO cmn2006_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","你们没有吃世间的普通饮食，没有吃饼，也没有喝甜酒或清酒。这是因为我一直在照看你们。我这样做，就是要让你们知道，我是主，是你们的上帝。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","“你们到了这里以后，希实本王西宏和巴珊王噩出兵攻打我们；我们打败了他们， ");
INSERT INTO cmn2006_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","占领了他们的领土，把土地分给了吕便支派、迦得支派和玛拿西半支派作为他们的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","你们一定要谨守这约中的所有规定，这样，你们才能在所有的事情上都取得成功。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","11","“今天，你们各支派的首领、长老、官员和全体以色列人以及你们的妇女儿童和住在你们中间为你们劈柴挑水的外族人，都站在主－你们的上帝面前； ");
INSERT INTO cmn2006_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","你们到这里来，就是要研讨主－你们的上帝将要跟你们立的约，并接受这约中对于违约者的诅咒， ");
INSERT INTO cmn2006_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","这样，主就会按照他对你们和你们的祖先－亚伯拉罕、以撒、雅各的应许，接受你们作他的子民，而他也会做你们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","主不只单单跟你们立了约，起了誓， ");
INSERT INTO cmn2006_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","他也跟今天和我们一起站在主－我们的上帝面前的人以及那些今天没有跟我们站在一起的我们的子孙后代立下了同样的约和誓言。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","你们还记得我们在埃及是怎样生活的；你们还记得我们怎样通过沿途的国家； ");
INSERT INTO cmn2006_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","你们亲眼看见了他们那些令人憎恶的东西，他们中间那些用木头、石头和金银制成的偶像。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","要注意防止你们中间某个男人或女人、或某个家族、或某个支派背弃主－我们的上帝去侍奉那些国家的神明，要注意防止在你们中间出现这样的人，他象一个树根，会长成一棵又苦又毒的树。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","“这样的人听到今天诅咒的话，他或许会暗自庆幸∶‘我虽然固执己见，还是会诸事平安。’然而，结果必然酿成大祸。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","主绝不会宽恕他；主的怒气和妒意会一起向他发作，律法书中记载的各种诅咒都将降在他的身上，主将把他的名字从世界上彻底抹掉。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","主会把他从以色列的各支派中隔离出来，按照记载在律法书上的约中的一切诅咒惩罚他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","23","“将来，你们的子孙和来自远方的外族人看见这块土地遭受的灾祸和主加给这块土地上的人的疾病－遍地是燃烧的硫磺和盐、不能耕种、寸草不生，就象主在愤怒中毁灭的所多玛城、蛾摩拉城、押玛城和洗扁城， ");
INSERT INTO cmn2006_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","“他们和列国的人不禁要问∶‘主为什么要这样大发烈怒？他为什么要这样对待这块土地？’ ");
INSERT INTO cmn2006_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","回答是∶‘因为他们背弃了主－他们祖先的上帝领他们出埃及时跟他们所立的约。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","他们离弃主去侍奉别的神明，去拜那些他们从不认识的神明，那是主禁止他们做的事情。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","所以，主的怒气向这块土地发作，他把律法书上所记载的一切诅咒都降到了这块土地上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","在烈怒中，他把他们从他们的土地上抓了起来，丢到了别处；至今他们还在那里。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","“有些事情主－我们的上帝秘而不宣，但有些事情他永久地昭示给了我们和我们的子孙，好让我们遵行这律法的一切规定。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","一切祝福与诅咒都应验在你们身上的时候，如果你们在主－你们的上帝迫使你们去的列国之中想起这一切， ");
INSERT INTO cmn2006_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","回到主－你们的上帝的身边，按照我今天对你们和你们子孙的吩咐，全心全意地服从他， ");
INSERT INTO cmn2006_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","那么，主－你们的上帝就会恢复你们旧日的状况，怜悯你们，把你们从他放逐你们去的列国之中召集起来， ");
INSERT INTO cmn2006_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","即使你们被放逐到地角天边，主－你们的上帝也会把你们从那里领回来， ");
INSERT INTO cmn2006_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","让你们重新占据你们祖先曾经拥有的土地，而且比你们的祖先更繁荣昌盛。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","主－你们的上帝要除掉你们和你们后代心里的污秽，好让你们以全部身心去爱主－你们的上帝，这样，你们就可以生存下去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","“主－你们的上帝要把所有这些诅咒加在你们的仇敌和那些恨你们、迫害你们的人身上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","那时，你们会重新顺从主，遵从我今天颁布给你们的主的全部诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","10","只要你们服从主－你们的上帝，遵守这律法书上记载的他的所有诫命和条例，一心一意地追随他，主－你们的上帝就会使你们在所做的一切事情上都获得极大的成功，你们将有许多子孙，你们的牲畜将繁衍众多，你们的土地将产出丰硕的物产。主必将再次使你们繁荣起来，就象他当年使你们的祖先繁荣起来一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","“我今天颁布给你们的诫命决没有强人所难，使你们难于遵行。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","这诫命不在天上，你们不必说∶‘谁能上天替我们把它取回来，好让我们能了解它，遵行它呢？’ ");
INSERT INTO cmn2006_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","这诫命也不在大海的那一边，你们不必说∶‘谁能渡海去替我们把它取回来，好让我们能了解它，遵行它呢？’ ");
INSERT INTO cmn2006_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","这诫命就在你们的身边，它就在你们的口中和你们的心里，所以，你们完全可以做得到。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“看吧，我今天把生死祸福都摆在你们面前，由你们选择。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","如果你们遵行我今天颁布给你们的主－你们的上帝的诫命，爱主－你们的上帝，按他要求的方式生活，谨守他的律法、条例和诫命，那么，你们就能够生存下去，并且人口越来越多。主－你们的上帝会在你们即将进占的土地上赐福给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","但是，如果你们背离主，不服从他，反而受诱惑去拜别的神明， ");
INSERT INTO cmn2006_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","那么，我今天要警告你们，你们一定会被消灭，绝不能长久生活在你们即将渡过约旦河进占的那块土地上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","“今天，我召唤天地作证，让你们在生和死、祝福和诅咒之间作出选择。选择生吧！好让你们和你们的后代能够生存下去。 ");
INSERT INTO cmn2006_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","要爱主－你们的上帝；要服从他，紧紧地追随他。你们这样做才能获得生命，才能长久生活在他应许赐给你们祖先－亚伯拉罕、以撒和雅各的土地上。” ");
INSERT INTO cmn2006_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","摩西向全体以色列人讲完这些话以后， ");
INSERT INTO cmn2006_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","又对他们说∶“我现在已经一百二十岁了，不能继续带领你们了。而且，主也告诉过我∶‘你不能渡过约旦河。’ ");
INSERT INTO cmn2006_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","主－你们的上帝将带领你们渡过约旦河，消灭你们面前的各个民族，让你们占有他们的土地。按照主的吩咐，约书亚将是继续领导你们的人选。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","“主将处置你们面前的各个民族，就象他当年灭掉亚摩利王西宏和噩及其国土时一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","主将帮助你们击败这些民族，你们必须按照我的命令处置他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","你们要坚强，要有信心，不要畏缩，不要被他们吓倒，因为主－你们的上帝会随同你们一起出征。他不会忘掉你们或丢弃你们。” ");
INSERT INTO cmn2006_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","摩西又把约书亚召来，当着全体以色列人的面对他说∶“你要坚强，要有信心，因为你要带领民众进入主应许他们的祖先要赐给他们的土地，并把它分配给他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","主将在你的前面带领你，他必与你同在。他不会忘记你或丢弃你。你不要害怕，不要畏缩不前。” ");
INSERT INTO cmn2006_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","摩西把这部律法写了下来，交给了抬约柜的利未人祭司和全体以色列长老， ");
INSERT INTO cmn2006_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","并命令他们∶“每七年一次，也就是在债务豁免年那一年住棚节期间的指定时间， ");
INSERT INTO cmn2006_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","当全体以色列人到主－你们的上帝选定的地方敬拜主的时候，你们要当众向全体以色列人朗读这律法。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","你们要把以色列人的男女老幼和寄居在你们城里的外族人都召集起来，让他们都能听到主的律法，好让他们学会敬畏主－你们的上帝，谨守律法的规定， ");
INSERT INTO cmn2006_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","这样，他们那些不了解律法的子孙后代就能有机会听到律法。在你们的有生之年，你们要在你们即将渡过约旦河进占的土地上始终学习敬畏主－你们的上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","主对摩西说∶“你不久就要离开人世了。你把约书亚召来，跟他一起到会幕前来，我要对他有所指示。”于是，摩西和约书亚来到会幕前。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","主在云柱中显现，云柱停留在会幕门口的上方。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","主对摩西说∶“你不久于人世了。你死之后，民众很快就会象妓女一样去追随他们即将进入的那块土地上的异族神明。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","那时，我会对他们发烈怒，丢弃他们，不再帮助他们。他们将被消灭，许多灾难将降到他们身上。到了那时，他们就会说∶‘我们遭了这么多难，是因为我们的上帝不与我们同在了！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","由于他们行事邪恶，背弃我而去拜别的神明，我在那时将拒绝帮助他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","“现在，你们一定要记下这首诗歌，把它教给以色列人，让他们记在心里，使这首诗歌成为我指责他们的见证。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","当我按照我对他们祖先的应许，把他们领进那块流奶与蜜的土地之后，他们将应有尽有，吃得身肥体胖，然后，他们就会背弃我去侍奉别的神明，违背我的约。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","当诸多灾难降在他们身上的时候，这首歌将作证指责他们。这首歌不会被他们的后代忘记。虽然今天我还没有把他们领进我应许赐给他们的土地，但是我已经知道了他们所怀的意念。” ");
INSERT INTO cmn2006_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","当天，摩西写下了这首诗歌，并把它传给了以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","随后，主指示嫩的儿子约书亚，说∶“你要坚强，要有信心，因为你将要带领以色列人去征服我应许赐给他们的土地，我将与你同在。” ");
INSERT INTO cmn2006_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","摩西把律法的全文都写在一本书上；写完以后， ");
INSERT INTO cmn2006_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","他吩咐负责抬约柜的利未人∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“你们把这教诲书拿去，放在主－你们的上帝的约柜旁边，它将作为指控你们的见证留在那里， ");
INSERT INTO cmn2006_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","因为我知道你们是顽固的和叛逆的民众。看，我还活着和你们在一起，你们就不断地背叛主了！我死后，你们肯定会更叛逆。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","把各支派的长老和官员们都带到我这里来吧！我要把这些话讲给他们听，让天地作证指责他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","我知道我死后你们会彻底堕落，绝不会按照我吩咐你们的方式生活。将来，灾难必定落在你们的身上，因为你们必定会做主所憎恶的事，并因此而触怒主。” ");
INSERT INTO cmn2006_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","然后，摩西向以色列全体会众朗读了这首诗歌： ");
INSERT INTO cmn2006_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","“诸天哪，请侧耳听我诉说； 大地啊，请听我的谈论。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","愿我的教诲淋漓如雨，愿我的话语滴落如露； 象细雨降在新草上，象甘霖洒在嫩芽中。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","我要宣扬主的名， 你们要赞美我们上帝的伟大。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","主是磐石，他的成就完美无缺，他的作为无不公正。 他是信实的上帝，从不失信，正直而公平。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","但你们不配作他的儿女； 你们一直对他不忠，是狡诈邪僻的一群人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","愚昧无知的民众啊，难道你们竟这样回报主？ 他是你们的父亲，是你们的创造者； 他造就了你们，使你们立于世界民族之林。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","你们要记住以往的年代，要追忆逝去的岁月； 你们询问父辈，他会讲给你听； 你们请教长老，他们会为你述说往事。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","当至高者将土地赐给列国的时候，他按照天使的数目划分人类，设立疆界。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","但主自己的份是他的子民，雅各是他的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","主在狂风四起的荒野上找到他的子民雅各；他护卫他们，照顾他们，象爱护自己眼中的瞳人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","象老鹰把雏鸟赶离巢窝而自己紧随幼子翱翔， 主展开翅膀，保护他们，把他们背在自己的两翼之上； ");
INSERT INTO cmn2006_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","主独自引领雅各，没有一个异神在旁。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","他把雅各置于山地之巅，用当地的出产养育他。 他使岩石流出蜂蜜，使坚石流出橄榄油； ");
INSERT INTO cmn2006_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","牛的油， 羊的奶， 肥壮的羊羔， 巴珊的绵羊和山羊， 上好的麦子， 葡萄汁酿的酒， 他把这一切都赐给了他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","然而，耶书伦却变得象公牛一样肥壮而不驯。 你们吃肥了，养胖了，饱食终日，就离弃了创造你们的上帝，轻慢曾经救护你们的磐石。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","你们以异神激起他的妒火， 以可憎的偶像煽动他的怒气。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","你们向根本不是神的精灵献祭， 向你们从不认识的神明献祭， 那都是些新近兴起的、你的祖先从不知道的神。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","你们忘记了养育你们的主，忘记了赐给你们生命的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","主看见了这一切， 不愿再与他的儿女同在，因为他被他们激怒了。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","他说∶ ‘我不再帮助他们， 我要等着看他们的结局。 他们是叛逆的民众，是不忠实的儿女。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","他们以非神的东西激起我的嫉火， 以毫无用处的偶像煽动我的怒气， 因此，我也要以不是我的子民的人激起他们的嫉火， 以愚昧的民族煽动他们的怒气。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","我的愤怒将燃起大火，烧透阴间，烧尽大地和大地上的出产，烧毁群山的根基。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","我将把重重灾难加在他们身上，把所有的箭都射向他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","他们将因饥饿而虚弱，因恶病而死亡； 我将派遣野兽去袭击他们，毒蛇去咬伤他们； ");
INSERT INTO cmn2006_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","他们将在大街上被刀剑所杀，在卧室里被恐怖夺走性命； 少男和少女死于非命，即使婴儿和老人也不能幸免。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","我本想把他们消灭，从世上抹掉他们的名， ");
INSERT INTO cmn2006_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","但我不愿让他们的仇敌惹我不快，让他们的仇人误以为∶“我们是靠自己的力量赢得了胜利，跟主毫无关系。”’ ");
INSERT INTO cmn2006_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","以色列的仇敌是毫无见识的民族，他们浑噩无知； ");
INSERT INTO cmn2006_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","但愿他们能有智慧，那么他们就会明晓事理，就会明白发生在他们身上的这一切的原因。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","为什么一个人能使千人溃不成军？ 为什么两个人能使万人望风而逃？ 只有他们的磐石出卖他们，主丢弃他们， 才会有这种事发生。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","因为我们仇敌的磐石无法跟我们的磐石相比，他们的守护者不能跟我们的守护者相提并论。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","因为他们的葡萄树来自所多玛，生自蛾摩拉，结出葡萄是有毒的，挂下的果实是苦的， ");
INSERT INTO cmn2006_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","酿出的酒象毒蛇的汁液。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","“主说∶ ‘我记下对他们的惩罚，存在我的库房里。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","我要惩罚他们，报应他们，很快他们就会立足不稳。 他们遭难的日子临近了，他们的厄运就要降临了！’ ");
INSERT INTO cmn2006_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","主要为他的子民主持公道； 他看见他的仆人失势，没有君王或救援者去拯救，孤立无助，他怜悯他们。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","他要问他们∶ ‘你们的神明在哪儿？ 你们倚为保障的磐石在哪儿？ ");
INSERT INTO cmn2006_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","那些饱享你们牲祭和奠祭的神明在哪儿？ 让他们来帮你们吧！ 让他们给你们提供荫庇吧！ ");
INSERT INTO cmn2006_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","你们要知道， 只有我是上帝，除我以外没有别的上帝！ 我可以使人死，也可以使人活； 我能伤害人，但也医治人； 没有人能逃脱我的掌握。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","我举手向天，发出这样的誓言∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","“我指着我的永生发誓，我将磨快闪亮的剑，执行审判； 我要惩罚我的仇敌，报复恨我的人。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","我的箭要滴下被杀被掳的人的血，我的剑要砍下仇敌的首领的人头。”’ ");
INSERT INTO cmn2006_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","列国啊，你们要赞美主的子民， 因为主将惩罚杀害他仆人的人！ 他要向他的仇敌复仇，他要为他的土地和他的子民行洁净礼。” ");
INSERT INTO cmn2006_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","摩西向全体以色列人朗读了这首诗的全文，嫩的儿子约书亚跟在摩西的身边。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","摩西向全体以色列人讲完以上这些以后， ");
INSERT INTO cmn2006_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","又对他们说∶“你们要切记我今天向你们庄重宣布的一切。它是指责你们的见证，你们要把它作为诫命传给你们的子孙，好让他们谨守这律法的一切规定。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","它对于你们绝不是无足轻重的事情，它就是你们的生命。只要你们遵行它，你们就能够在那块你们即将渡过约旦河据为你们自己产业的土地上长久生活下去。” ");
INSERT INTO cmn2006_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","当天，主对摩西说∶ ");
INSERT INTO cmn2006_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“你到耶利哥城对面摩押地的亚巴琳山区去，登上尼波山，从那里眺望我要赐给以色列人作为产业的迦南地。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","你将死在你登上的那座山上，归回你的祖先，就象你的哥哥亚伦死在何珥山上一样。 ");
INSERT INTO cmn2006_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","由于在寻旷野上的加低斯城附近的米利巴泉那里，你曾对我不忠，没有在以色列人中间尊我为圣， ");
INSERT INTO cmn2006_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","所以，你只能从远处眺望，却不能进入我要赐给以色列人的那块土地。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","以下是神人摩西在去世以前对以色列人的祝福。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","“主从西乃而来， 象太阳为我们从西珥升起； 他从巴兰山发出光辉，千万名天使跟随着他； 他的右边是他大能的士兵。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","他爱他的子民，把他的圣徒托在手中； 他们坐在他的脚下，聆听他的教诲。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","摩西传给我们的律法是雅各会众的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","当以色列各支派的首领聚会的时候，主将在耶书仑中为王。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","对于吕便支派，摩西说∶ “愿吕便永存不灭，但要让他人口稀少。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","对于犹大支派，摩西说∶ “主啊，愿你垂听犹大的祈祷， 引导他平安归回自己的民族中间。 他用自己的双手捍卫了自己的事业，愿你帮助他们跟他们的仇敌争战。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","对于利未支派，摩西说∶ “主啊，求你把土明赐给利未，把乌陵赐给忠于你的人。 你在玛撒考验他，在米利巴泉旁鞭策他。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","他对你比对自己的父母、亲眷、子女更忠诚， 一心只遵行你的诫命，守护你的约。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","他们会把你的律法教给雅各， 把你的训诲传给以色列人。 他们会把香奉到你的面前，把烧化祭献到你的祭坛上。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","主啊， 求你赐给他力量，悦纳他所做的一切。 求你除掉他们的仇敌和恨他们的人，使他们从此一蹶不起。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","对于便雅悯支派，摩西说∶ “主所爱的人将安然憩息在他的身边， 他自始至终保护他们，并居住在他的山麓之间。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","对于约瑟的后代，摩西说∶ “愿主赐福给约瑟的土地； 从天上降下雨露，从地下涌出泉水。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","愿太阳送给他们丰美的果实，月月都有上等的出产； ");
INSERT INTO cmn2006_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","愿古老的大小山冈送给他们最珍贵的礼物， ");
INSERT INTO cmn2006_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","愿大地为他们献出宝藏； 愿显现在燃烧的荆棘丛中的主的恩泽降在他们的头上。 愿这一切祝福都归于约瑟，那众兄弟之中的王者。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","约瑟象头胎的公牛一样威严，他的角是野牛的角； 他以它们抵触万国，直至地角天边－它们是玛拿西数以千计的人，是以法莲数以万计的人。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","对于西布伦支派和以萨迦支派，摩西说∶ “西布伦啊，愿你外出得福； 以萨迦啊，愿你居家欢喜； ");
INSERT INTO cmn2006_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","他们要把外族人召到他们的山上，在那里献上应献的祭。 因为他们从海上得到了财富，从沙滩里得到了宝藏。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","对于迦得支派，摩西说∶ “赞美归于那扩张迦得土地的人； 他象狮子静伏等待，突然撕裂猎物的臂膀和头颅。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","他为自己取得了最好的部分，那是为领袖保留的那一份。 迦得将出任军队的各级长官，与以色列人共同维护主认为正义和公正的事。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","对于但支派，摩西说∶ “但象从巴珊冲出的幼狮。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","对于拿弗他利支派，摩西说∶ “拿弗他利享有主的厚赐， 到处可见主的赐福， 愿他占有加利利湖及其以南地区。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","对于亚设支派，摩西说∶ “亚设是众子中得福最多的人； 愿他在众兄弟中受宠， 愿他用橄榄油洗足， ");
INSERT INTO cmn2006_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","愿他的城门有铜锁铁闩， 愿他在有生之年永远强盛。” ");
INSERT INTO cmn2006_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","“耶书伦啊，没有别的神明能跟你的上帝相比∶ 他显露威仪，驾云跨越天空来拯救你。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","永恒的上帝是你安全的居所，他的臂膀始终支持你。 他宣布说∶‘毁灭吧！’就赶走了你面前的仇敌。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","因此，以色列得以生活在平安之中， 雅各得以安然住在盛产五谷与新酒的土地上，那里的天也会滴下甘露。 ");
INSERT INTO cmn2006_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","以色列啊，你是有福的！ 谁能比得上你这蒙主拯救的民族？ 主是保护你的盾，是赐你胜利的剑。 你的仇敌畏惧你们，而你将把他们踏在脚下。” ");
INSERT INTO cmn2006_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","摩西从摩押平原登上了耶利哥城对面尼波山的毗斯迦山峰。主把整个地区都指给摩西看∶从基列到但； ");
INSERT INTO cmn2006_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","整个拿弗他利地区；以法莲和玛拿西地区；犹大全境至地中海西岸； ");
INSERT INTO cmn2006_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","南地和平原地带－耶利哥谷和棕树城－直至琐珥。 ");
INSERT INTO cmn2006_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","主对摩西说∶“这就是我向亚伯拉罕、以撒和雅各应许的土地。我说过∶‘我要把这块土地赐给你们的子孙。’我已经让你亲眼看见了这块土地，但你不能到那里去。” ");
INSERT INTO cmn2006_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","正如主所说，主的仆人摩西死在摩押地的尼波山。 ");
INSERT INTO cmn2006_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","主把他埋在伯比珥对面的摩押地山谷中，至今没有人知道埋葬他的确切地方。 ");
INSERT INTO cmn2006_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","摩西死的时候一百二十岁，仍然视力不衰，脸上没有皱纹。 ");
INSERT INTO cmn2006_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","以色列人在摩押平原为摩西举哀三十天。他们留在摩押地的约旦谷，直至传统居丧期满。 ");
INSERT INTO cmn2006_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","嫩的儿子约书亚充满智慧，因为摩西曾把手按在他的头上，指定他作新的领袖。以色列人遵照主对摩西的命令听命于约书亚。 ");
INSERT INTO cmn2006_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","但在以色列，再也没有任何一个先知能象摩西那样跟主面对面地相见； ");
INSERT INTO cmn2006_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","没有人能象摩西奉主的派遣在埃及向埃及王、他的臣仆以及他的王国所做的那样施行神迹奇事， ");
INSERT INTO cmn2006_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","也没有人能象摩西那样在全体以色列人面前做出那大而可畏之举。 ");
INSERT INTO cmn2006_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","约书亚是摩西的助手、嫩的儿子。主的仆人摩西死后，主对约书亚说∶ ");
INSERT INTO cmn2006_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“我的仆人摩西死了，你和这个民族所有的人要作好准备，跨过约旦河，到我要赐给你们－以色列人的土地上去。 ");
INSERT INTO cmn2006_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","你们足迹所及之处，我都赐给你们，这是我对摩西的允诺。 ");
INSERT INTO cmn2006_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","从旷野和这黎巴嫩之地远至幼发拉底河，包括赫人的全部地域，西至地中海，都将是你们的领地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","在你有生之年，没有人能与你抗衡。我将与你同在，绝不离弃你，就象当年与摩西同在一样。 ");
INSERT INTO cmn2006_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","“约书亚啊！你要坚强，你要勇敢！你要率领你的人民去征服我向他们祖先许诺赐给他们的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","只要你意志坚定，行动果敢，谨守我的仆人摩西告诫你的一切律法，不忽视其中任何一部分，你将事事成功。 ");
INSERT INTO cmn2006_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","只要你时刻诵读、日夜研想这律法书，谨守书中的一切律条，你就会诸事顺利。 ");
INSERT INTO cmn2006_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","你要记住我的训示∶要坚强，要勇敢！不要畏惧，不要沮丧。我－主，你的上帝将处处与你同在。” ");
INSERT INTO cmn2006_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","11","于是，约书亚吩咐首领们走遍全营发布命令∶“你们要准备好食物。三天之内，你们就要渡过约旦河，进占主－你们的上帝赐给你们的土地。” ");
INSERT INTO cmn2006_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","约书亚对吕便人、迦得人和玛拿西半支派的人说∶ ");
INSERT INTO cmn2006_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“你们要记住上帝的仆人摩西给你们的训示∶‘主－你们的上帝要给你们一块休养生息之地，’就是你们眼前的这块土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","你们的妻子、儿女和牲畜将留在约旦河东岸摩西给你们的这块土地上，但你们要拿起武器，作你们以色列兄弟和全体战士的先锋，与他们协同作战， ");
INSERT INTO cmn2006_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","直到他们征服了主－你们的上帝赐给他们的土地，象你们一样有了自己的休养生息之地为止。那时，你们才可以回到约旦河东岸，回到主的仆人摩西分给你们的土地上。” ");
INSERT INTO cmn2006_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","人们答道∶“你吩咐我们做什么，我们就做什么；你差遣我们到哪里去，我们就到哪里去； ");
INSERT INTO cmn2006_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","我们将象服从摩西一样服从你的一切命令。愿主－你的上帝与你同在，就象他曾与摩西同在一样。 ");
INSERT INTO cmn2006_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","谁违抗你的命令，不服你的指挥，就处死他！愿你坚强，愿你勇往直前！” ");
INSERT INTO cmn2006_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","约书亚从什亭暗暗地派两个人作探子，吩咐他们说∶“你们去迦南地侦察一下，特别要查探耶利哥城的虚实。” 探子出发了，来到一个名叫喇合的妓女家里，就在那里过夜。 ");
INSERT INTO cmn2006_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","有人给耶利哥王报信说∶“今天晚上以色列人来窥探这里了。” ");
INSERT INTO cmn2006_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","耶利哥王派人对喇合说∶“快把到你这里来的人交出来！他们是来刺探我们虚实的。” ");
INSERT INTO cmn2006_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","喇合早已把两人藏了起来。她对来人说∶“确实有两个人来过这儿，但我不知道他们是从哪儿来的。 ");
INSERT INTO cmn2006_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","天黑要关城门的时候他们就走了，我也不清楚他们究竟是往哪儿去了。你们赶快去追吧，会追上他们的。” ");
INSERT INTO cmn2006_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","（实际上，她早已把他们带到房顶上，藏在堆放在那里的散开的麻秸中。） ");
INSERT INTO cmn2006_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","于是，追兵就沿着约旦大道，一直朝约旦河渡口追了下去。追兵刚刚出城，城门就关了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","两个探子临睡觉前，喇合上房顶去见他们， ");
INSERT INTO cmn2006_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","说∶“我知道主已经把这地方赐给了你们，你们使我们全城人惊恐不安。 ");
INSERT INTO cmn2006_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","我们听说过，当你们离开埃及时，主曾使你们面前的红海干涸；我们也听说了你们怎样杀了约旦河东岸的两个国王－西宏和噩。 ");
INSERT INTO cmn2006_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","这些传闻吓得我们心惊胆战，没有一个人胆敢与你们抗争。因为，主－你们的上帝是天地间真正的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","现在，请你们以主的名义向我发誓∶我恩待你们，你们以后也要恩待我的全家。请给我一个切实的保证， ");
INSERT INTO cmn2006_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","你们将保全我的父母、兄弟姐妹以及他们的家属的性命，使我们免于一死。” ");
INSERT INTO cmn2006_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","那两人答道∶“如果你不泄露我们的身份，我们愿意起誓。当主把这块土地赐给我们时，我们将以真诚和善意对待你。如果我们失信，愿上帝取走我们的性命。” ");
INSERT INTO cmn2006_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","喇合的房子就盖在城墙上；她用一根绳子将那两人从窗口缒下去， ");
INSERT INTO cmn2006_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","对他们说∶“逃到山里去吧，这样追捕的人就发现不了你们了。你们在那儿躲三天，等追兵回了城，你们就可以上路了。” ");
INSERT INTO cmn2006_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","18","那两人对她说∶“你一定要照我们说的去做，否则，我们就不再对你让我们起的誓负责。当我们来到这里时，你一定要把这根红线绳系在你放我们逃走的那个窗户上。你要把你的父母、兄弟和全家人都聚集在你家里， ");
INSERT INTO cmn2006_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","如果有人在你家中被伤害，那是我们的罪责；如果有人离开你家上了街，他就要为自己的死负责，与我们无关。 ");
INSERT INTO cmn2006_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","此外，如果你泄露了我们的身份，我们也不再受誓言的约束。” ");
INSERT INTO cmn2006_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","她说∶“好，就这么办吧！”她送走了他们，然后，把红线绳系在了窗户上。 ");
INSERT INTO cmn2006_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","两个探子离开那里，到山里躲了起来，他们在山里躲了三天。追兵沿路搜索，一无所获，返回了耶利哥城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","两个探子下了山，渡过约旦河，去见约书亚，向他报告了所发生的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","他们对约书亚说∶“上帝果然把那地方赐给我们了，那里的人对我们恐惧万分。” ");
INSERT INTO cmn2006_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","第二天早晨，约书亚和所有的以色列人早早地起来，从什亭拔营出发。他们来到约旦河岸，扎下营地准备渡河。 ");
INSERT INTO cmn2006_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","三天以后，首领们走遍营中， ");
INSERT INTO cmn2006_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","向人们传令说∶“你们看见利未族的祭司抬着主－你们的上帝的约柜前进时，就一起拔营，跟着它前进。 ");
INSERT INTO cmn2006_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","但是，要跟它保持一千英尺的距离，不要太靠近。你们没有到过这里，跟随着约柜，你们就知道该怎么走了。” ");
INSERT INTO cmn2006_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","约书亚吩咐人们∶“你们要洁净自己；明天，主就要在你们当中显示奇迹了！” ");
INSERT INTO cmn2006_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","第二天，约书亚对祭司们说∶“你们抬着约柜走在前面。”祭司们抬起约柜，走在人群的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","主对约书亚说∶“今天，我要使你在全体以色列人的眼里成为至上至尊的人。要让他们知道，我与你同在就象我以前与摩西同在一样。 ");
INSERT INTO cmn2006_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","你要吩咐抬约柜的祭司们，当他们到达约旦河边时要走进河里，在河水中站着不动。” ");
INSERT INTO cmn2006_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","于是，约书亚召集民众，说∶“来吧！听听主－你们的上帝的旨意。 ");
INSERT INTO cmn2006_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","11","瞧吧！世界的主宰－主的约柜就要在你们前面进入约旦河了！你们马上就能知道，活生生的上帝与你们同在！他将彻底赶走并击败你们面前的迦南人、赫人、希未人、比利洗人、革迦撒人、亚摩利人和耶布斯人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","现在，你们要从以色列的十二支派中各选出一个人来，听候吩咐。 ");
INSERT INTO cmn2006_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","当祭司们抬着世界的主宰－主的约柜踏进约旦河的河水时，从上游流下来的河水将会停止流动，象被堤坝挡住一样竖立起来，形成一堵水墙。” ");
INSERT INTO cmn2006_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","人们拔营动身，准备渡约旦河。抬着约柜的祭司走在人群的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","抬约柜的祭司的脚刚刚踏进河水，收获季节漫过两岸的河水立即停止了流动， ");
INSERT INTO cmn2006_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","上游的河水在远至撒拉旦附近的亚当城那里形成一堵水墙，下游流向死海的水完全断绝。人们在耶利哥附近渡过了约旦河。 ");
INSERT INTO cmn2006_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","抬约柜的祭司稳稳地站在河中央，以色列民众陆续越过干涸的河床向对岸走去，全体民众都渡过了约旦河。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","全体民众都渡过了约旦河以后，主对约书亚说∶ ");
INSERT INTO cmn2006_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“从你的人民中挑选出十二个人来，每个支派选一个人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","吩咐他们在约旦河中央祭司们站立的地方取十二块石头，带着它们一起过河，把它们放在你今夜宿营的地方。” ");
INSERT INTO cmn2006_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","于是，约书亚召集他从各支派挑选出来的十二个人， ");
INSERT INTO cmn2006_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","对他们说∶“你们到约旦河的中央去，在主－你们的上帝的约柜前每人取一块石头，扛在肩上。每块石头代表一个以色列支派。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","这些石头将给你们留作标记。将来，你们的后代问起你们这些石头是纪念什么的， ");
INSERT INTO cmn2006_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","你们要告诉他们∶‘在主的约柜前，约旦河曾经断流；当它过约旦河时，河水曾停止流动。’这些石头将提醒以色列人永远记住这件事情。” ");
INSERT INTO cmn2006_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","以色列人遵从上帝对约书亚的训示，按照约书亚的吩咐从约旦河中取了十二块石头，每块石头代表一个以色列支派。他们把这些石头带到宿营地，放在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","（约书亚也在约旦河中央祭司们抬着约柜站立的地方立了十二块石头，这些石头至今还在那里。） ");
INSERT INTO cmn2006_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","祭司们抬着约柜一直站立在约旦河中央，直到人们完成了主指示约书亚要他们做的一切；这一切也是摩西告诫约书亚要去做的。民众匆匆地渡过了约旦河。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","全体民众都过了河之后，祭司们抬着约柜越过人群，仍然走在队伍的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","吕便、迦得两个支派和玛拿西半支派的战士，做好了战斗准备，按照摩西的训示走在其他以色列人的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","大约四万名全副戎装的战士在主的约柜前过了河，来到耶利哥平原，准备作战。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","那一天，主使约书亚成为全体以色列人至上至尊的领袖，与摩西一样，终生受到以色列人的崇敬。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","主对约书亚说∶ ");
INSERT INTO cmn2006_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“让抬着约柜的祭司们上岸来吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","于是，约书亚吩咐祭司们从约旦河上来。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","祭司们的脚刚一踏上河岸，河水又开始涌流，象原先一样漫过两岸。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","正月初十那天，人们过了约旦河，在耶利哥东面的吉甲扎营。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","约书亚把从约旦河取来的十二块石头立在吉甲， ");
INSERT INTO cmn2006_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","对以色列人说∶“将来，你们的后代问他们的父辈‘这些石头意味着什么？’ ");
INSERT INTO cmn2006_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","你们要告诉你们的后代∶‘以色列人曾经走过干涸的约旦河河床’， ");
INSERT INTO cmn2006_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","主－你们的上帝使你们面前的河水干涸，让你们安然渡河；就象他当年使红海干涸，让我们走过去一样。 ");
INSERT INTO cmn2006_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","世上的万民都会由此知道主无所不能；而你们要永远敬畏主。” ");
INSERT INTO cmn2006_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","约旦河西岸的亚摩利诸王和地中海沿岸的迦南诸王听说主使约旦河干涸好让以色列人渡河，无不胆气尽丧，对以色列人恐惧万分。 ");
INSERT INTO cmn2006_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","这时，主对约书亚说∶“你要用火石磨成刀，再次为以色列人行割礼。” ");
INSERT INTO cmn2006_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","于是，约书亚造了火石刀，在叫作割礼山的地方给以色列人行割礼。 ");
INSERT INTO cmn2006_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","7","以色列人离开埃及时，所有的男人都受过割礼。这些战士在旷野里流浪了四十年，都已经死于旷野的旅途之中，因为他们曾违背主的意志，主发誓不让他们看见他向他们祖先所应许的要赐给他们的那块流奶与蜜之地。主使他们的后代长大成人，接替他们的父辈。他们的后代在长年的流浪生涯中没有施行过割礼，是未经割礼的一代。所以，约书亚为他们施行了割礼。 ");
INSERT INTO cmn2006_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","行完割礼以后，全体民众都留在营地里等伤口痊愈。 ");
INSERT INTO cmn2006_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","主对约书亚说∶“今天，我洗刷掉了你们在埃及蒙受的耻辱。”因此，这个地方至今叫作吉甲。 ");
INSERT INTO cmn2006_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","以色列人在吉甲宿营时，于当月十四日的晚上在耶利哥平原守逾越节。 ");
INSERT INTO cmn2006_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","就在第二天，他们第一次吃了当地的出产∶无酵饼和烤谷子。 ");
INSERT INTO cmn2006_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","从那天起，玛哪停止降下，以色列人不再吃玛哪了。那一年，他们吃的是迦南地出产的粮食。 ");
INSERT INTO cmn2006_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","接近耶利哥城时，约书亚忽然看见一个人站在他的面前，手里拿着一柄出鞘的剑。约书亚迎上去，问∶“你是帮助我们的，还是帮助我们的仇敌的？” ");
INSERT INTO cmn2006_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","那人答道∶“都不是！我是来统帅主的军队的。” 约书亚俯伏在地，向他敬拜，说∶“主啊！你对你的仆人有什么吩咐？” ");
INSERT INTO cmn2006_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","那人－主的军队的统帅对他说∶“脱下你的鞋！因为你站的地方是圣洁的。”约书亚照办了。 了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","由于以色列人的逼近，耶利哥城门紧闭，戒备森严，不准任何人出入。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","主对约书亚说∶“我已经把耶利哥城、耶利哥王及其善战的兵士都交在你手里了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","你要统率军队每天绕城一周，连续进行六天。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","你要派七个祭司，拿着羊角做的号角，走在约柜的前面。在第七天，你们要绕城七周，七个祭司要吹响号角。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","当他们吹出一声长音时，你们就一齐高声呐喊，耶利哥城墙就会倒塌，这时全军就可以长驱入城了。” ");
INSERT INTO cmn2006_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","嫩的儿子约书亚把祭司们召集在一起，对他们说∶“你们抬着约柜，让七个人拿着羊角做的号角走在主的约柜的前面。” ");
INSERT INTO cmn2006_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","他又对军队发布命令∶“出发！绕城行进！部队在约柜前方开道！” ");
INSERT INTO cmn2006_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","七个祭司拿着羊角号角出发了，同时吹响了号角，约柜跟在他们后面行进， ");
INSERT INTO cmn2006_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","整装的战士在吹着号角的祭司们前面开道，后卫部队跟在约柜的后面，一路号角之声不绝。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","约书亚告诫人们∶“不许喧哗！不许弄出声音！不许说话！直到我命令你们喊叫时，你们才可以呐喊。” ");
INSERT INTO cmn2006_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","约书亚命令手下人抬着约柜，绕城一周，然后就回营歇息。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","第二天一早，仍是祭司们抬着约柜， ");
INSERT INTO cmn2006_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","七个拿着公羊角号角的祭司走在约柜前面，一路吹着号角。整装的战士在他们前面开路，后卫部队跟在约柜后面，一路号角之声不绝。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","第二天仍是绕城一周，然后回营休息。天天如此，一共持续了六天。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","到第七天，刚刚拂晓，他们就起来了，队伍依照先前的样子绕城行进，只是这天连续绕了七次。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","在绕第七次时，祭司们刚吹出一声长音，约书亚就命令部队∶“呐喊！主已经把这座城交给你们了！ ");
INSERT INTO cmn2006_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","这座城和城里的一切都必须毁掉，它们要作为祭物献给主。但是要留下妓女喇合和她一家人的性命，因为她藏匿过我们的探子。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","不要心怀贪欲，千万不要拿那些应当作为祭物必须毁灭的东西，否则，就会给以色列全营带来灭顶之灾。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","金、银和铜铁器皿都要圣化归主，放入主的宝库。” ");
INSERT INTO cmn2006_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","人们齐声应答。祭司们吹起号角，众人随着号角声，一齐发出震耳欲聋的呐喊，耶利哥城墙轰然倒塌。部队蜂拥而入，占领了城市。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","他们屠杀了全城的男女老幼，也杀光了所有的牛、羊和驴。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","约书亚对那两个探子说∶“你们到那妓女家里去，按照你们的誓言把她和她家里的人都带出来。” ");
INSERT INTO cmn2006_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","两个探子进了城，把喇合和她的父母、兄弟及其余的亲眷都带出城来，安置在以色列人的营地外面。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","血洗耶利哥全城以后，以色列人放火烧城，毁灭了城中的一切，只把金、银和铜铁器皿带了出来，放入主的宝库。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","约书亚只保全了妓女喇合和她全家人的性命，因为她藏匿过约书亚派去侦察耶利哥城的探子。喇合和她的家人至今仍住在以色列人中间。 ");
INSERT INTO cmn2006_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","当时，约书亚发出誓言∶ “愿上帝诅咒那想重建耶利哥城的人； 奠立城基的人将丧失长子， 建造城门的人将丧失幼儿。” ");
INSERT INTO cmn2006_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","主与约书亚同在，使他声威远震。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","以色列人没有信守主关于不准私拿必须毁灭的物品的旨意，因为亚干拿了一些本该毁灭的物品。亚干是迦米的儿子、撒底的孙子，属于犹大支派的谢拉宗族。主因此迁怒于以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","约书亚从耶利哥派人潜入伯特利东边靠近伯亚文的艾城去窥探虚实。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","探子们侦察完毕，回来向约书亚报告，说；“艾城人少，兵力薄弱，只要二、三千人去就足以取胜，不必全军出动。” ");
INSERT INTO cmn2006_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","以色列人出动了大约三千人去攻打艾城，结果被艾城人杀得大败而逃。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","艾城人乘胜追击，从城门口一直追到示巴琳，在下坡的地方杀死了三十六人。以色列人士气沮丧。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","约书亚撕裂衣服，同长老们一起把灰撒在头上，在约柜前俯伏在地，直到晚上。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","约书亚说∶“至高无上的主啊！你为什么要把我们领过约旦河，让亚摩利人毁灭我们呢？如果是这样，还不如把我们留在约旦河的那边，我们也知足了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","主啊！现在以色列人已经被仇敌杀败，我还能说什么呢？ ");
INSERT INTO cmn2006_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","迦南人和所有这里的人听到我们败退的消息，就会来包围我们，剿灭我们，那时，你该怎样维护你的尊严呢？” ");
INSERT INTO cmn2006_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","主对约书亚说∶“站起来！你为什么要伏在地上？ ");
INSERT INTO cmn2006_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","以色列人犯了大罪，他们违背了我的意志，拿了我命令他们必须毁灭的东西。他们私拿这些东西，行为诡诈，又把那些东西据为己有。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","因此，以色列人抵挡不住仇敌的进攻，他们受到诅咒注定要失败。如果你们不毁灭你们中间那些我吩咐你们必须毁灭的东西，我将不再与你们同在。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","“去对你的人民说，让他们洁净自己，明天到我面前来。因为我－主，以色列的上帝要对他们说∶‘以色列人哪！你们拿了我吩咐你们必须毁灭的东西，如果你们不除掉这些东西，你们就无法对抗仇敌。’ ");
INSERT INTO cmn2006_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","“明天早晨，你们要按支派一支派一支派地到我面前来；我召哪一支派，那一支派就要按宗族一宗族一宗族地上前来；我召哪一宗族，那一宗族就要按家族一家族一家族地上前来；我召哪一家族，那家族就要一个人一个人地上前来。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","拿了该毁灭的物品的人要被烧死，属于他的一切东西也要用火烧掉。因为他违背了我的约，在以色列人中间做了卑劣的事。” ");
INSERT INTO cmn2006_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","第二天一早，约书亚把以色列人按支派带上前来，犹大支派被点中了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","犹大各宗族依次上前，谢拉宗族被点中了。谢拉各家族依次上前，撒底家族被点中了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","然后，约书亚把撒底家族的人一个一个地带上前来。撒底的孙子、迦米的儿子亚干被点中了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","约书亚对亚干说∶“孩子，要敬畏主－以色列的上帝，要向他坦白你的罪过。告诉我，你都干了些什么，不要隐瞒我。” ");
INSERT INTO cmn2006_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","亚干答道∶“是的，我在主－以色列的上帝面前犯了罪。事情是这样的∶ ");
INSERT INTO cmn2006_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","在战利品中，我看见一件很漂亮的巴比伦外衣，还有2.3公斤的银子和一根重约0.6公斤的金条。我贪图这些东西，就拿走了。这些东西都埋在我的帐篷底下，银子放在最下边。” ");
INSERT INTO cmn2006_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","约书亚派人到帐篷里去查看。人们跑到那里，果然发现那些东西藏在帐篷底下，银子放在最下面。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","他们把那些东西从帐篷里拿出来，带到约书亚和全体以色列人那里，摊放在主的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","于是，约书亚和以色列民众把谢拉的儿子亚干和那些银子、外衣、金条、他的儿女和牲畜以及他的一切东西都带到亚割谷。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","约书亚说∶“你为什么要给我们带来灾难？现在，主要降灾给你了！”接着，人们用石头打死了亚干和他的家人，烧毁了他所有的东西，又向这些东西掷石头。 ");
INSERT INTO cmn2006_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","然后，以色列人在亚干的尸体上堆起了一个大石堆。这石堆至今仍在那里。主这才息了怒气。这地方至今叫做亚割谷。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","主对约书亚说∶“不要畏惧，也不要沮丧；现在，你率领全军去攻打艾城。我把艾城和艾城王以及他的臣民和国土都交在你手中， ");
INSERT INTO cmn2006_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","你要象对待耶利哥城和耶利哥王那样处置艾城和艾城王，只是这次你们可以为自己留下财物和牲畜。你要在城后设下伏兵，伺机突袭艾城。” ");
INSERT INTO cmn2006_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","于是，约书亚整顿部队，率领全军准备进击艾城。他选派了三万名精兵夜间出发， ");
INSERT INTO cmn2006_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","命令他们∶“注意！你们要埋伏在城后，不要离城太远，全军要处于戒备状态，随时准备发起进攻。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","我将率兵进逼艾城，他们出城迎战时，我们就象上次一样败退。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","他们一定会追赶我们，认为我们象上次一样溃不成军了。我们诱他们远离艾城，当我们败退时， ");
INSERT INTO cmn2006_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","你们要突击并占领艾城。主－你们的上帝会把它交在你们的手里。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","占领艾城后，你们要遵照主的旨意，放火烧城。这是我的命令！” ");
INSERT INTO cmn2006_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","部队按照约书亚的命令出发，在艾城以西、伯特利和艾城之间的地方埋伏下来。约书亚则与其他部队在营地过夜。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","第二天早晨，约书亚集合部队，与以色列的长老们一起，率军向艾城进发。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","他们逼近艾城，在艾城以北扎下营。营地与艾城之间隔着一个山谷。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","约书亚派了大约五千人埋伏在艾城以西、艾城和伯特利之间。以色列人的主力驻扎在城北，伏兵在城西。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","当夜，约书亚率军进入山谷。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","清晨，艾城王望见约书亚的军队，就集合所有的部下急速出城，在约旦谷迎战约书亚，全然不知城后设有伏兵。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","约书亚和他的部队佯装战败，向旷野败逃。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","艾城人倾城而出，追赶他们。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","艾城和伯特利城的人都出来追击以色列人，城中无人留守，城门洞开。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","主对约书亚说∶“把你手中的矛指向艾城，我要把这城赐给你。”于是，约书亚向艾城方向举起手中的矛。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","立时，伏兵尽起，冲入城中，立刻放火烧城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","艾城人回头望见城中烟火冲天，往旷野败退的以色列人也返身再战，向他们发起攻击，顿时乱作一团。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","约书亚和他的部队看见伏兵占领了艾城，城中烟火飞腾，趁机回转身来，面对追赶他们的艾城人杀了过去， ");
INSERT INTO cmn2006_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","已经攻占艾城的以色列人也出城夹击。艾城人腹背受敌，被以色列人团团围住，溃不成军。以色列人把他们杀得一个不剩，没有一个人逃脱或幸免。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","艾城王被活捉，带到约书亚的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","以色列人杀光了在旷野上和田野里追击他们的所有艾城人，然后全军进占艾城，杀光了城中的所有居民。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","那一天，艾城所有的人全被杀光，男女共计一万二千人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","约书亚一直举着他的矛，直至艾城的全部居民都被杀光，才放下手来。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","以色列人按照主对约书亚的训示，留下了牲畜和财物。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","然后，约书亚把艾城付之一炬，至今艾城仍是一片凄凉的废墟。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","他把艾城王吊死在树上，直到傍晚太阳西沉时才命人把尸体取下来，丢在城门口，又在上面堆了一个大石堆，这石堆至今依然可见。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","然后，约书亚在以巴路山为主－以色列的上帝造了一座祭坛。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","祭坛是按照主的仆人摩西指示以色列人的方法建造的，正如摩西律法书中所记载的那样∶“祭坛要用未经铁器削凿过的整块石头建成。”他们在上面向主献上烧化祭，也献上平安祭。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","约书亚当着以色列人的面，把摩西律法刻在石头上。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","全体以色列人和他们的长老、首领、法官以及寄居的外族人站在约柜两旁，面对抬着约柜的利未人祭司，一半人对着基利心山，另一半人对着以巴路山，按照主的仆人摩西所吩咐的仪式接受对以色列人的祝福。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","约书亚按照律法书的条文宣读了全部律法，包括祝福和诅咒。 ");
INSERT INTO cmn2006_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","在全体以色列人－包括妇女、儿童和寄居的外族人面前，约书亚一字不漏地宣读了摩西律法。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","居住在约旦河西岸的诸王，即分布在约旦河西岸的山地、西部丘陵地带以及远至黎巴嫩山麓和地中海沿岸一带的赫人、亚摩利人、迦南人、比利洗人、希未人和耶布斯人的诸王听到约书亚和以色列人在约旦河西岸连破二城的消息， ");
INSERT INTO cmn2006_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","决定联合起来，共同对付约书亚和以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","但是，基遍人听到这些消息， ");
INSERT INTO cmn2006_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","5","却决定施展诡计。他们乔装改扮，身上穿着旧衣服，脚上穿着补过的鞋，驴背上驮着缝补过的旧皮酒袋和旧口袋，口袋里装着干巴巴发了霉的饼子， ");
INSERT INTO cmn2006_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","到吉甲营地来见约书亚。 他们对约书亚和以色列人说∶“我们是从远方来的，求你和我们立约。” ");
INSERT INTO cmn2006_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","以色列人对他们说∶“说不定你们就住在附近，我们怎么能与你们立约呢？” ");
INSERT INTO cmn2006_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","这些希未人对约书亚说∶“我们是你的仆人呀！” 约书亚问他们∶“你们到底是什么人？从哪里来？” ");
INSERT INTO cmn2006_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","他们回答说∶“我们是你的仆人，仰慕主－你的上帝的声名，专程从遥远的国度赶来。我们听说了主的圣名和他在埃及显现的神迹， ");
INSERT INTO cmn2006_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","也听说了他对约旦河东岸的两个亚摩利王－希实本的西宏王和亚斯他录的巴珊王噩所作的处置。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","于是，我们那地方的长老和居民对我们说∶‘带上干粮，去迎接以色列人吧！告诉他们我们是他们的仆人，求他们与我们立约。’ ");
INSERT INTO cmn2006_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","“瞧瞧这些饼子！我们临来的时候，饼子还是烫手的，看哪，现在都成这模样了，干巴巴的，发了霉了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","再看看这些酒袋！我们盛酒的时候还是崭新的，现在已经破了。我们长途跋涉，衣服和鞋子都破烂不堪了。” ");
INSERT INTO cmn2006_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","以色列人信以为真，收下了他们的一些食物，却没有求问上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","约书亚与他们立了约，友好相待，答应不杀他们。以色列的首领们也与他们盟了誓。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","立约之后的第三天，以色列人才知道他们就住在附近。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","于是，以色列人向他们的住地进发，第三天到了他们居住的城镇，就是基遍、基非拉、比录和基列耶琳。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","由于会众的首领曾以主－以色列的上帝的名义向他们起过誓，所以以色列人不能去杀他们。民众埋怨这些首领。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","首领们向会众解释说∶“我们曾以主－以色列的上帝的名义向他们发过誓，因此，我们现在不能再伤害他们。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","我们要容许他们活着，这样，主才不会因为我们违背与他们的誓约而迁怒于我们。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","让他们活命吧！”于是，按照以色列首领的吩咐，他们成了为以色列人劈柴挑水的人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","约书亚把基遍人召来，问他们∶“你们为什么要欺骗我们，说你们是从遥远的国度来的呢？其实你们就住在我们的附近。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","你们将为此受到诅咒∶你们要永远作以色列人的奴仆，为我们上帝的居所劈柴挑水。” ");
INSERT INTO cmn2006_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","他们回答约书亚说∶“我们知道主－你们的上帝曾吩咐他的仆人摩西把这块土地全部赐给你们，并要你们杀掉这块土地上的所有居民。我们忧心忡忡，害怕被杀，就欺骗了你们。 ");
INSERT INTO cmn2006_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","现在，我们在你们手里，听凭你们处置吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","约书亚保全了他们的性命，使他们免于被以色列人所杀， ");
INSERT INTO cmn2006_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","但同时罚他们为以色列人劈柴挑水，也在主选中的地方为祭坛劈柴挑水，世世代代做以色列人的奴仆，直至今天。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","耶路撒冷王亚多尼洗德听说约书亚攻取了艾城，象以前处置耶利哥城和耶利哥王一样，彻底摧毁了艾城，杀了艾城王。他同时得悉基遍人已经与以色列人订了和平条约，而他们就住在耶路撒冷附近。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","耶路撒冷人非常害怕。基遍与其他诸王的都城一样，是一座大城，甚至比艾城还要大，而且，基遍人个个英勇善战。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","因此，亚多尼洗德派人传话给希伯仑王何咸、耶末王比兰、拉吉王雅非亚和伊矶伦王底璧，说∶ ");
INSERT INTO cmn2006_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“请起兵帮助我攻打基遍，他们已经与约书亚和以色列人签订和约了！” ");
INSERT INTO cmn2006_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","于是，耶路撒冷王、希伯仑王、耶末王、拉吉王和伊矶伦王五个亚摩利王联合起来，组成联军围攻基遍。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","基遍人急忙派人送信给在吉甲营地的约书亚，说∶“亚摩利山地的诸王一起来攻打我们了！请别抛弃你的仆人，立刻起兵来援救我们吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","约书亚立刻率领全军，包括最精锐的部队，从吉甲出发。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","主对约书亚说∶“不要怕他们，我已经把他们交在你手中了。他们都不是你的对手。” ");
INSERT INTO cmn2006_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","约书亚率军从吉甲连夜奔袭亚摩利人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","主使亚摩利人在以色列人的攻击面前惊慌失措，在基遍被以色列人杀得大败，四散奔逃。以色列人沿着通向伯和仑的路追击他们，一路追杀，直到亚西加和玛基大。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","当亚摩利人从伯和仑往亚西加溃退时，遭到主从天上降下来的大冰雹的打击，被冰雹砸死的人比被以色列人杀死的还要多。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","就在主使约书亚战胜亚摩利人的那一天，约书亚在以色列人面前向主祷告∶ “日头啊，你要停在基遍； 月亮啊，你要止在亚雅仑谷。” ");
INSERT INTO cmn2006_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","于是，亘古未有的奇观出现了－日头停留，月亮止住。这一天，太阳挂在空中的时间特别长，足足延长了一昼夜之久，直到以色列人打败了仇敌。这件事记载在雅煞珥书上。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","主这样地听从人的祷告，这是空前绝后的一次。因为，主在为以色列而战！ ");
INSERT INTO cmn2006_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","战后，约书亚率军返回吉甲营地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","五个亚摩利王逃脱后，躲在玛基大的一个山洞里。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","有人报告约书亚∶“那五王已经找到了，都藏在玛基大洞里。” ");
INSERT INTO cmn2006_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","约书亚命令道∶“用石块堵住洞口！派人在那里监视着他们。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","但你们不要停留，要继续追击敌人，不要让他们逃回城里。主－你们的上帝已经把他们交在你们手里了。” ");
INSERT INTO cmn2006_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","约书亚率以色列人将敌军斩杀殆尽，只有少数人逃回了设防坚固的城里。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","然后，以色列全军平安地返回约书亚的玛基大大营。从此，再没有人敢对以色列人稍有不满之词。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","约书亚下令∶“打开洞口！把那五王带来见我！” ");
INSERT INTO cmn2006_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","兵士们打开洞口，把耶路撒冷王、希伯伦王、耶末王、拉吉王和伊矶伦王从洞里拖了出来，押到约书亚的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","五王带到以后，约书亚把全体以色列人集合起来，吩咐随他出战的军官们∶“你们近前来，把脚踩在这些国王的脖子上！”军官们上前，用脚踩住五王的脖子。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","约书亚对军官们说∶“你们不要畏缩惧怕，要坚强！要充满信心！因为，主将要使一切与你们抗争之敌都象这五王一样被你们踩在脚下！” ");
INSERT INTO cmn2006_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","说完，约书亚下令杀了五王，把他们的尸体挂在五棵树上示众， ");
INSERT INTO cmn2006_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","直到傍晚太阳西下时，才命人从树上放下来，丢在他们藏身的洞里，然后，用大石头堵住洞口。这些大石头至今依然可见。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","就在那一天，约书亚占领了玛基大，杀死了玛基大王和所有的玛基大人，城中的生灵无一幸存。他对玛基大王的处置与对耶利哥王一样。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","然后，约书亚率军从玛基大出发，攻击立拿。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","主把立拿和立拿王交在以色列人手里。全城人无一幸存。立拿王的下场与耶利哥王一样。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","约书亚又率军从立拿出发，去围攻拉吉。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","主把拉吉交在以色列人手中。第二天以色列人就攻陷了拉吉，象在立拿一样杀光了全城所有的人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","基色王何兰率军援助拉吉，被约书亚击败，全军覆没。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","接着，约书亚率军从拉吉出发，围攻伊矶伦。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","当天以色列人就攻陷伊矶伦，如同在拉吉一样杀光了所有的伊矶伦人和城中的一切生灵。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","约书亚又率军从伊矶伦出发，进击希伯伦。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","他们攻占了希伯伦，杀死了希伯伦王，希伯伦城及其所辖诸城中的所有居民和生灵无一幸存。如同在伊矶伦一样，约书亚彻底毁灭了希伯伦城中的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","然后，约书亚回师进攻底璧，攻占了底璧城及其所辖城镇， ");
INSERT INTO cmn2006_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","俘虏了底璧王。如同处置希伯伦和立拿一样，约书亚彻底血洗了底璧，没有留下一个人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","至此，约书亚征服了整个地区∶包括山地、南部地区、西部丘陵地带和东边的坡地。他击败了这一地区的诸王，杀光了所有的居民。这一切都是按照主－以色列的上帝的意志行事。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","约书亚扫荡敌军，从加低斯巴尼亚直到迦萨，从整个歌珊地区直到基遍。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","他一战而俘获诸王，吞并其疆土；这是因为主－以色列的上帝在为以色列而战。 ");
INSERT INTO cmn2006_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","于是，约书亚率军凯旋吉甲大营。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","3","夏琐王耶宾听到以色列人征战的消息，派人传檄玛顿王约巴、伸仑王、押煞王和北部山区、加利利湖南面的约旦谷、西部丘陵地带和多珥一带的诸王以及东西部的迦南人、山地的亚摩利人、赫人、比利洗人、耶布斯人和居住在黑门山山麓米斯巴地的希未人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","诸王尽起倾国之兵，兵士多得象海滩上的沙粒，并拥有大量的马匹和战车。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","诸王在约定地点会合后，在米伦溪扎营，准备迎战约书亚。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","主 对 约 书 亚 说∶“不 要 惧 怕 他们！明天的这个时刻，我将替以色列击杀他们。你要砍断他们的马蹄，烧掉他们的战车。” ");
INSERT INTO cmn2006_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","于是，约书亚率全军突袭米伦溪的敌军。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","主把他们交在以色列人手里。他们打击敌军，一路追杀，北至米斯利弗玛音和西顿，东至米斯巴谷，杀得敌人无一幸免。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","约书亚遵照主的吩咐行事，砍断了敌军的马蹄，烧毁了敌军的战车。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","然后，约书亚回师攻占了夏琐，斩杀了夏琐王。夏琐曾一直是反以色列盟军的盟主国。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","约书亚彻底毁灭了夏琐城的一切，没有一个人侥幸活命；然后烧毁了夏琐城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","约书亚占领了诸王的都城，俘虏并杀死诸王及城中的所有人口，一切都是遵照主的仆人－摩西的吩咐行事。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","但是，这一次除了烧毁夏琐城外，以色列军队没有烧掉任何一座山地城市。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","他们杀光了城中的所有人口，掠走了所有的贵重物品和牲畜。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","约书亚这样做是遵照摩西的吩咐行事，而摩西传达的是主的旨意。约书亚所做的一切都是遵照主对摩西的训示。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","约书亚征服了那一带的所有土地，包括山地、南部地区、歌珊全境、西部丘陵地带、约旦河谷及以色列山地和丘陵地带， ");
INSERT INTO cmn2006_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","囊括了从以东附近的哈拉山远至黑门山南部黎巴嫩谷的巴力迦得的广大地区。约书亚俘虏并斩杀了所有这一地区的诸王。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","他与他们长年争战， ");
INSERT INTO cmn2006_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","除了基遍的希未人外，没有跟任何一个城订立和约，以色列人用战争征服了他们。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","主使这些人决心与以色列人作对，好使他们被彻底毁灭，被毫不留情地灭绝掉。这是主对摩西的训示。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","当时，约书亚歼灭了亚衲人。他们分布在山区地带，即希伯仑、底璧、亚拿伯以及犹大和以色列山区。约书亚彻底毁灭了他们和他们的城镇， ");
INSERT INTO cmn2006_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","在以色列境内没有留下一个亚衲人，只有少量亚衲人残存在迦萨、迦特和亚实突地区。 ");
INSERT INTO cmn2006_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","约书亚遵照主对摩西的训示征服了这一地区，他按照支派把土地分给以色列人，作为他们永久的产业。从此，这一地区的战乱平息了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","以下是摩西率领以色列人击败的诸王。 约旦河东岸从亚嫩谷直到黑门山，包括约旦河谷东部的土地都被以色列人占领。 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","他们击败了两个王，其中一个是建都于希实本的亚摩利王西宏。他的国土起自亚嫩谷边缘的亚罗珥，包括亚嫩谷中部和半个基列，远至亚扪边界的雅博河。 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","约旦河谷东部从加利利湖至死海（即盐海）东边的伯耶西末，南至比斯迦山山麓也属亚摩利王西宏统辖。 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","巴珊王噩的国土也被以色列人占领。他在亚斯他禄和以得来立国，是最后一个利乏音人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","他的国土包括黑门山、撒迦和巴珊全境，与基述和玛迦接壤，还包括基列的一半，与希实本王西宏的国土接界。 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","主的仆人摩西率领以色列人击败了这两个王，把他们的疆土分给了吕便支派、迦得支派和玛拿西半支派作为产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","以下是约书亚和以色列人在约旦河西岸击败的诸王。这一地区包括黎巴嫩谷的巴力迦得直到以东附近的哈拉山（约书亚把土地按照支派宗族分给以色列人，作为他们的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","包括山地、西部丘陵地带、约旦河谷、东部的坡地、南部地区和旷野，即原属赫人、亚摩利人、迦南人、比利洗人、希未人和耶布斯人的地域。）。 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","以下是被约书亚击败的诸王∶ 耶利哥王、伯特利附近的艾城王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","耶路撒冷王、希伯伦王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","耶末王、拉吉王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","伊矶伦王、基色王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","底璧王、基德王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","何珥玛王、亚拉得王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","立拿王、亚杜兰王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","玛基大王、伯特利王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","他普亚王、希弗王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","亚弗王、拉沙仑王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","玛顿王、夏琐王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","伸仑米仑王、押煞王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","他纳王、米吉多王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","基低斯王、迦密的约念王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","多珥的多珥王、吉甲的戈印王、 ");
INSERT INTO cmn2006_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","得撒王， 共三十一个王。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","约书亚年事已高，主对他说∶“你老了；但是，还有许多地方没有征服。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","这些地方是非利士和基述全境， ");
INSERT INTO cmn2006_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","包括从埃及以东的西曷河北至以革伦的疆界，这一地区属迦南人统辖，即五个非利士王－迦萨王、亚实突王、亚实基伦王、迦特王和以革伦王的国土及南部亚卫人的全部地域， ");
INSERT INTO cmn2006_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","以及迦南人的所有地域。此外，从西顿人的米亚拉至亚摩利人边界上的亚弗之间的地域， ");
INSERT INTO cmn2006_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","迦巴勒人的所有地域，黎巴嫩东部从黑门山南麓的巴力迦得直至哈马隘口的所有地域，也要一一征服。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","至于居住在从黎巴嫩至米斯利弗玛音之间山地的所有西顿人，我要亲自替以色列人赶走他们。你只管按我的吩咐把土地拈阄分给以色列人，作为他们的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","现在，你就把这块土地分给九个支派和玛拿西半个支派，作为他们的产业吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","上帝的仆人摩西已经把约旦河东岸的土地分给了吕便支派、迦得支派和玛拿西半个支派。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","10","他们的土地从亚嫩谷边缘的亚罗珥起始，包括亚嫩谷中部的城邑、整个米底巴高原直至底本以及曾由希实本的亚摩利王西宏统治的诸城，远至亚扪边界； ");
INSERT INTO cmn2006_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","也包括了基列、基述、玛迦、整个黑门山和巴珊全境直至撒迦， ");
INSERT INTO cmn2006_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","以及在亚斯他禄和以得来立国的巴珊王噩－最后一个利乏音人的全部国土。摩西击败了这一地区的诸王，把他们赶出了原来的国土。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","以色列人没有驱赶基述人和玛迦人，他们至今仍然生活在以色列境内。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","摩西没有分土地给利未人，主－以色列的上帝应允他们∶献给他的祭物就是他们的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","摩西给吕便支派各宗族分配了土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","他们的地域包括亚嫩谷边缘的亚罗珥、谷中的城邑以及米底巴附近的全部高原； ");
INSERT INTO cmn2006_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","还包括希实本及希实本高原上的底本、巴末巴力、伯巴力勉、 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","雅杂、基底莫、米法押、 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","基列亭、西比玛、亚嫩谷山丘上的细列哈沙辖、 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","伯比珥和伯耶西末诸城以及毗斯迦山的坡地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","他们的土地包括了高原上的所有城邑和在希实本立国的亚摩利王西宏的全部国土。摩西击败了西宏，也击败了西宏王在米甸地区的首领－以未、利金、苏珥、户珥和利巴。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","比珥的儿子、术士巴兰也被以色列人所杀。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","吕便支派西部以约旦河为界。这一地区的所有城镇及附属的村庄都分给了吕便支派各宗族，作为他们的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","摩西给迦得支派各宗族分配了土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","他们的地域包括雅谢、基列所有的城以及亚扪人的一半领土，直至拉巴以东的亚罗珥； ");
INSERT INTO cmn2006_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","27","还包括了从希实本至拉抹米斯巴和比多宁、从玛哈念至底璧边界的地域以及谷中的伯亚兰、伯宁拉、疏割和撒分，即希实本王西宏的其余国土，西至约旦河，北至加利利湖。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","这一地区的全部城镇和土地分给了迦得支派各宗族，作为他们的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","摩西给玛拿西半支派分配了土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","他们的地域从玛哈念穿越巴珊全境，即巴珊王噩的全部国土以及睚珥在巴珊的所有城镇，共计六十座城镇， ");
INSERT INTO cmn2006_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","还包括半个基列和巴珊王噩的两座大城－亚斯他禄和以得来。这些土地分给了玛拿西半支派的各宗族，作为他们的产业，这半个支派是玛拿西的儿子玛吉的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","以上是摩西在约旦河东岸耶利哥城以东的摩押平原分给以色列人的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","他没有分土地给利未支派，供职主－以色列的上帝就是他们的产业，这是上帝对他们的许诺。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","以下是以色列人在迦南地分得的作为他们产业的土地。祭司以利亚撒和嫩的儿子约书亚以及以色列各支派的宗族首领把土地分给人民。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","他们遵照主对摩西的训示，拈阄决定把产业分给了九个支派和玛拿西半支派。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","4","摩西已经把约旦河东岸的土地分给了吕便支派、迦得支派及玛拿西半支派作为产业；（约瑟的后代分成两个支派－玛拿西和以法莲。）摩西没有分给利未人任何土地，但他们有城可住，有田野可以牧养牲畜。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","以色列人遵照上帝对摩西的训示分配了土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","犹大支派的人去吉甲见约书亚。基尼洗人耶孚尼的儿子迦勒对约书亚说∶“你应当记得主在加低斯巴尼亚对圣人摩西讲的关于你和我的事。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","我四十岁的时候，主的仆人摩西派我从加低斯巴尼亚到这里侦察，回去以后，我如实向他作了报告。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","跟我一起去侦察的人的报告使得人们士气低落，而我始终坚信主－我的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","就在那一天，摩西起誓说∶‘你足迹所及之处，必将成为你和你的子孙的永久产业；因为你一心侍奉主－我的上帝。’ ");
INSERT INTO cmn2006_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","瞧！从主对摩西说那些话到现在，蒙他的允诺，我又活过了四十五年，这期间以色列人一直在旷野流浪。我现在85岁了， ");
INSERT INTO cmn2006_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","依然象当年摩西派我出去的时候一样健壮，一样有力，还可以出入征战。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","现在，请把主当年应许我的那块山地给我吧！那天你也听到了这一切；那里有亚衲人，有宽大坚固的城堡，或许主会与我同在，我将蒙他的应许把那些人赶出去。” ");
INSERT INTO cmn2006_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","于是，约书亚给他祝福，把希伯伦城给了他，作为他的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","因此，希伯伦至今仍然属于基尼洗人耶孚尼的儿子迦勒的后代，因为他一心侍奉主－以色列的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","（在这以前，希伯伦叫亚巴。亚巴是亚衲族中最杰出的人。）从此，这里四境平安，战争平息了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","犹大支派各宗族分得的土地向南伸展到以东的边界，直达寻旷野的最南端。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","南部边界从死海（盐海）南端起始， ");
INSERT INTO cmn2006_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","往南经过亚克拉滨隘口，绕过寻，又从加低斯巴尼亚的南部往北，经过希斯仑，直到亚达珥，再转向甲加， ");
INSERT INTO cmn2006_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","直到押扪，再沿着埃及边界的河流到地中海为止。这是犹大支派的南部边界。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","东部边界是死海，直至约旦河口。 北部边界从约旦河口起始， ");
INSERT INTO cmn2006_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","延伸至伯曷拉，北至伯亚拉巴，直到波罕石（波罕是吕便的儿子）， ");
INSERT INTO cmn2006_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","再从亚割谷到底璧，往北转向吉甲，吉甲与南端的亚都冥隘口遥遥相对；再延伸到隐士麦泉，至隐罗结为止， ");
INSERT INTO cmn2006_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","再沿着欣嫩谷到达南坡的耶布斯城，即耶路撒冷；从这里再上至欣嫩谷以西、利乏音谷北端的山顶， ");
INSERT INTO cmn2006_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","然后，转向尼弗多亚泉，直到以弗伦山附近的城镇，再转向巴拉（即基列耶琳）， ");
INSERT INTO cmn2006_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","绕过巴拉西部，到达以东山区，再经过耶琳山北麓（即基撒伦山）下到伯示麦，经过亭纳， ");
INSERT INTO cmn2006_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","伸向以革伦北坡，再转向施基伦，经巴拉山沿着河谷到雅比聂，直到地中海为止。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","西部边界是地中海的海岸线。这是犹大人的地界。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","约书亚按照主的训示把犹大人的一份土地－基列亚巴，即希伯伦城，分给了耶孚尼的儿子迦勒。（亚巴是亚衲人的祖先。） ");
INSERT INTO cmn2006_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","迦勒赶走了亚衲的三支后裔，即示筛族、亚希幔族和挞买族。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","他又从那里进攻底璧。（底璧以前叫做基列西弗。） ");
INSERT INTO cmn2006_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","迦勒说∶“谁能攻下基列西弗，我就把女儿押撒嫁给谁。” ");
INSERT INTO cmn2006_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","迦勒的弟弟基纳斯的儿子俄陀聂攻下了城，迦勒就把女儿押撒嫁给了他。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","结婚那天，俄陀聂怂恿押撒向她父亲要一块田地。她下了驴，迦勒问她∶“你想要什么呢？” ");
INSERT INTO cmn2006_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","她说∶“求你祝福我。既然你把我嫁到干旱的南方，求你把水泉也给我吧！”于是，迦勒把上泉和下泉都给了她。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","下面是犹大支派各宗族所得的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","南部靠近以东边界的城镇如下∶ 甲薛、以得、雅姑珥、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","基拿、底摩拿、亚大达、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","基底斯、夏琐、以提楠、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","西弗、提链、比亚绿、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","夏琐哈大他、加略希斯仑（即夏琐）、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","亚曼、示玛、摩拉大、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","哈萨迦大、黑实门、伯帕列、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","哈萨书亚、别是巴、比斯约他、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","巴拉、以因、以森、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","伊勒多腊、基失、何珥玛、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","洗革拉、麦玛拿、三撒拿、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","利巴勿、实欣、亚因和临门，共二十九座城及其所辖的村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","以下是在西部丘陵地带的城镇∶ 以实陶、琐拉、亚实拿、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","撒挪亚、隐干宁、他普亚、以楠、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","耶末、亚杜兰、梭哥、亚西加、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","沙拉音、亚底他音和基底拉（即基底罗他音），共十四座城及其所辖的村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","此外，还有以下城镇∶ 洗楠、哈大沙，麦大迦得、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","底连、米斯巴、约帖、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","拉吉、波斯加、伊矶伦、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","迦本、拉幔、基提利、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","基低罗、伯大衮、拿玛和玛基大，共十六座城及其所辖的村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","立拿、以帖、亚珊、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","益弗他、亚实拿、尼悉、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","基伊拉、亚革悉和玛利沙，共九座城及其所辖村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","还有以革伦及其所辖城镇和村庄； ");
INSERT INTO cmn2006_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","以革伦以西，亚实突附近的所有城镇及其所辖村庄； ");
INSERT INTO cmn2006_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","亚实突和迦萨二城及其所辖的村庄；其土地一直延伸到埃及边界的河流和地中海沿岸。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","以下是山地地区的城镇∶ 沙密、雅提珥、梭哥、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","大拿、基列萨拿（即底璧）、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","亚拿伯、以实提莫、亚念、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","歌珊、何伦和基罗，共十一座城及其所辖的村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","亚拉、度玛、以珊、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","雅农、伯他普亚、亚非加、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","宏他、基列亚巴（即希伯仑）和洗珥，共九座城及其所辖村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","玛云、迦密、西弗、淤他、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","耶斯列、约甸、撒挪亚、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","该隐、基比亚和亭纳，共十座城及其所辖村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","哈忽、伯夙、基突、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","玛腊、伯亚诺和伊勒提君，共六座城及其所辖村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","基列巴力（即基列耶琳）和拉巴二座城及其所辖村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","以下是旷野地带的城镇∶ 伯亚拉巴、密丁、西迦迦、 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","匿珊、盐城和隐基底，共六座城及其所辖村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","犹大人没能把耶路撒冷城里的耶布斯人赶走，因此，耶布斯人至今仍然与犹大人一起住在耶路撒冷。 ");
INSERT INTO cmn2006_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","约瑟的后代分得的土地从耶利哥泉以东靠近耶利哥城的约旦河起始，由耶利哥往北进入旷野到伯特利山地， ");
INSERT INTO cmn2006_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","再从伯特利（路斯）经过亚基人居住的亚他绿， ");
INSERT INTO cmn2006_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","往西与押利提人的疆土接界，远至下伯和仑地区，到达基色，通到地中海为止。 ");
INSERT INTO cmn2006_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","这一地区作为约瑟的后裔－以法莲支派和西玛拿西支派的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","以法莲支派各宗族产业的地界如下∶东部边界从亚他绿亚达到上伯和仑， ");
INSERT INTO cmn2006_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","再到地中海；北边是密米他，向东转到他纳示罗直至雅挪哈的东边， ");
INSERT INTO cmn2006_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","再从雅挪哈延伸至亚他绿和拿拉，到达耶利哥，至约旦河为止； ");
INSERT INTO cmn2006_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","又从他普亚西至加拿河，到地中海为止。以上是以法莲支派各宗族的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","此外，玛拿西境内的一些城镇及其所辖村庄也分给了以法莲人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","以法莲人赶不走居住在基色的迦南人，所以，迦南人至今仍与以法莲人住在一起，但他们被迫做以法莲人的奴隶。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","玛拿西支派也分到了土地。玛拿西是约瑟的长子。玛吉是玛拿西的长子、基列的父亲，由于他作战勇敢，约旦河东岸的基列和巴珊已归属他的名下。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","因此，这一次就把土地分给了玛拿西支派的其余宗族－亚比以谢、希勒、亚斯列、示剑、希弗和示米大，他们是约瑟的儿子玛拿西的男性后裔。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","然而，西罗非哈没有儿子，只有女儿。西罗非哈是希弗的儿子，基列的孙子，玛吉的曾孙，玛拿西的玄孙。他的女儿们的名字是∶玛拉、挪阿、曷拉、密迦和得撒。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","她们来到祭司以利亚撒和嫩的儿子约书亚及众首领的面前，说∶“主曾吩咐摩西要象对待男性亲族一样也给我们一份土地作为产业。”于是，遵照主的吩咐，她们也象她们的男性亲族一样得到了一份产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","因此，除了约旦河东岸的基列和巴珊外，玛拿西支派分得了十份土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","玛拿西的男女后裔都分得了一份产业。（基列地分给了玛拿西的其余后代。） ");
INSERT INTO cmn2006_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","玛拿西支派的地界从亚设延伸至与示剑遥相对应的密米他，南至隐他普亚人的地界。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","他普亚周围的土地属于玛拿西人，但是，建在玛拿西边界上的他普亚城属于以法莲人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","玛拿西支派的地界由那里再往南到加拿河，沿加拿河北岸至地中海。加拿河以南的城镇虽然在玛拿西境内，但属于以法莲人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","以法莲在加拿河以南；玛拿西在加拿河以北，西邻地中海，北部和东部分别与亚设和以萨迦接界。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","以萨迦和亚设境内的伯善和以伯莲二城及其所辖的村庄，还有多珥、隐多珥、他纳和米吉多四城及其所辖的村庄，都属于玛拿西人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","但是玛拿西人没有能够占有这些城，迦南人仍然住在这里。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","以色列人强盛了以后，他们也没有把迦南人完全赶走，只是强迫他们为自己做工。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","约瑟的后代对约书亚说∶“为什么你只分给我们一份土地作产业呢？主赐福给我们，我们的人很多呀！” ");
INSERT INTO cmn2006_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","约书亚对他们说∶“如果你们人数众多，以法莲山地容纳不下你们，你们就到比利洗人和利乏音人的森林里去开垦土地吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","他们说∶“山地对我们来说还是不够大，而且住在耶斯列平原和伯善及其周围村镇平原地带的迦南人都拥有铁车。” ");
INSERT INTO cmn2006_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","约书亚对约瑟后代，即以法莲和西玛拿西支派的人说∶“你们是个人口众多的大族，你们的力量很强大，不应该只拥有一份土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","山地要属你们所有，虽然是林区，但你们可以开垦，进而拥有全部地区。迦南人尽管拥有铁车，实力强盛，你们也会把他们赶出去的。” ");
INSERT INTO cmn2006_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","示罗地区已经在以色列人的掌握之中。全体以色列会众在这里聚会，设立了会幕。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","还有七个以色列支派没有分到土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","约书亚对以色列人说∶“你们这些懒惰的胆小鬼还要等多久才去占领主－你们的上帝赐给你们的土地呢？ ");
INSERT INTO cmn2006_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","现在，每一支派选出三个人到我这里来，我要派他们去勘察整个地区，按各支派应得的地界绘制地图，然后回来见我。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","这块土地要分成七份。犹大仍然保有南方的土地，约瑟家族也仍保有北方的土地，迦得、吕便和玛拿西半支派已经得到了主的仆人摩西分给他们的约旦河东岸的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","你们要绘好这七个地区的地图，带到这儿来交给我，我要在主－我们的上帝面前为你们拈阄分地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","但是利未人不能象你们一样分得土地，因为，供职上帝就是他们的产业。” ");
INSERT INTO cmn2006_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","于是，人们出发去勘察地界，绘制地图。约书亚吩咐他们∶“你们要走遍整个地区，绘好地图带回来给我，我要在示罗这里，按照主的意志为你们拈阄。” ");
INSERT INTO cmn2006_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","人们动身走遍了整个地区，按城镇分布绘成七份地图，返回示罗营地来见约书亚。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","约书亚在示罗地当着主的面为他们拈阄，把土地按支派分给了以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","第一份土地分给了便雅悯支派的各宗族。他们的土地在犹大支派和约瑟支派之间。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","北部边界起自约旦河，至耶利哥以北的坡地，往西经过山地直至伯亚文旷野， ");
INSERT INTO cmn2006_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","再向南延伸到路斯的南坡（路斯又叫伯特利），直至座落在下伯和仑南面山上的亚他绿亚达， ");
INSERT INTO cmn2006_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","再绕过山的西边，南至犹大支派的基列巴力城（即基列耶琳城）为止，这是西部边界。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","南部的边界从基列耶琳的边缘起始，延伸至尼弗多亚泉， ");
INSERT INTO cmn2006_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","往南到利乏音谷北端的山脚下，与欣嫩谷遥相对应，再向南经过欣嫩谷到耶布斯山南麓，至隐罗结， ");
INSERT INTO cmn2006_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","又转向北，到隐示麦，再到亚都冥隘口对面的基利禄，至波罕石（波罕是吕便的儿子）， ");
INSERT INTO cmn2006_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","经过俯瞰约旦河谷的北坡，进入约旦河谷， ");
INSERT INTO cmn2006_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","再经过伯曷拉北麓，到约旦河流入死海的入口处为止。这是南部边界。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","东部边界是约旦河。 以上是便雅悯支派各宗族分得的产业的地界。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","以下是属于便雅悯支派各宗族的城镇∶ 耶利哥、伯曷拉、伊麦基悉、 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","伯亚拉巴、洗玛脸、伯特利、 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","亚文、巴拉、俄弗拉、 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","基法拉摩尼、俄弗尼和迦巴，共十二座城及其所辖村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","还有基遍、拉玛、比禄、 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","米斯巴、基非拉、摩撒、 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","利坚、伊利比勒、他拉拉、 ");
INSERT INTO cmn2006_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","洗拉、以利弗、耶布斯（即耶路撒冷）、基比亚和基列，共十四座城及其所辖村庄。 以上是便雅悯支派各宗族分得的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","西缅支派按宗族拈出第二阄。他们所得的产业在犹大支派境内。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","以下是他们的产业∶ 别是巴（或示巴）、摩拉大、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","哈萨书亚、巴拉、以森、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","伊利多拉、比土力，何珥玛， ");
INSERT INTO cmn2006_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","洗革拉、伯玛加博、哈萨苏撒、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","伯力巴勿和沙鲁险，共十三座城及其所辖的村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","还有亚因、利门、以帖和亚珊四座城及其所辖的村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","此外，远至南部的巴拉比珥（拉玛）城周围的所有村庄也包括在内。以上是西缅支派各宗族分得的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","因为犹大支派分得的土地过多，其中一部分就分给了西缅支派。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","西布伦支派按宗族拈出第三阄。 他们的地界远至撒立， ");
INSERT INTO cmn2006_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","再由撒立西至玛拉拉，直到大巴设和约念以东的河流。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","再由撒立起始，东至吉斯绿他泊的边界，再到大比拉，又往北到雅非亚， ");
INSERT INTO cmn2006_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","再从那里往东到迦特希弗和以特加汛，经过临门转向尼亚， ");
INSERT INTO cmn2006_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","又绕过尼亚的北边，转向哈拿顿，直至伊弗他伊勒谷为止。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","还包括加他、拿哈拉、伸仑、以大拉和伯利恒等十二座城及其所辖的村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","以上是西布伦支派各宗族分得的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","以萨迦支派按宗族拈出第四阄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","他们的土地包括∶耶斯列、基苏律、书念、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","哈弗连、示按、亚拿哈拉、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","拉璧、基善、亚别、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","利篾、隐干宁、隐哈大和伯帕薛。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","他们的地界延伸到他泊、沙哈洗玛、伯示麦直至约旦河，共十六座城及其所辖的村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","以上是以萨迦支派各宗族分得的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","亚设支派按宗族拈得第五阄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","他们的土地包括∶黑甲、哈利、比田、押煞、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","亚拉米勒、亚末和米沙勒。 西部边界延伸到迦密和希曷立衲， ");
INSERT INTO cmn2006_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","东至伯大衮，与西布仑和伊弗他伊勒谷相接，北至伯以墨和尼业，再往北到迦步勒、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","义伯仑、利合、哈门、加拿直到西顿， ");
INSERT INTO cmn2006_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","再转向拉玛，直至推罗城堡，然后转向何萨，直到地中海。他们的土地还包括玛黑拉、亚革悉、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","乌玛、亚弗、利合等二十二座城以及所辖的村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","以上是亚设支派各宗族分得的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","拿弗他利支派按宗族拈出第六阄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","他们的地界从希利弗附近撒拿音的橡树那里经亚大米尼吉和雅比聂延伸到拉共，直到约旦河， ");
INSERT INTO cmn2006_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","又向西转向亚斯纳他泊，再到户割，南至西布伦，西至亚设，东至约旦河。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","设防城有∶西丁、侧耳、哈末、拉甲、基尼烈、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","亚大玛、拉玛、夏琐、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","基低斯、以得来、隐夏琐、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","以利稳、密大伊勒、和琏、伯亚纳和伯示麦，共十九座城及其所辖的村庄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","以上是拿弗他利支派各宗族分得的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","但支派按宗族拈出第七阄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","他们的土地包括∶琐拉、以实陶、伊珥示麦、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","沙拉宾、亚雅仑、伊提拉、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","以伦、亭拿他、以革伦、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","伊利提基、基比顿、巴拉、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","伊胡得、比尼比拉、迦特临门、 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","美耶昆、拉昆和约帕附近的地区。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","由于居住在这块土地上的对手势力强大，但人没能占领这一地区，因而他们前去攻击利善，占领了它，杀掉了所有的利善人，将它据为己有，并在那里定居下来，用祖先但的名字把它改名为但。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","以上是但支派各宗族分得的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","以色列人按地界分配好了产业以后，从他们的产业中给嫩的儿子约书亚分了一份产业， ");
INSERT INTO cmn2006_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","他们遵照主的吩咐，把他所要求的城给了他，即以法莲山地的亭拿西拉。约书亚重建了亭拿西拉城，在那里定居下来。 ");
INSERT INTO cmn2006_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","以上是祭司以利亚撒和嫩的儿子约书亚以及以色列各支派、各宗族的首领们在示罗地的会幕前，当着主的面拈阄分配的产业。至此，以色列人完成了疆土的划分。 ");
INSERT INTO cmn2006_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","主吩咐约书亚， ");
INSERT INTO cmn2006_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","说∶“去告诉以色列人，叫他们按照我藉摩西传达给他们的命令，选择一些城市作为他们自己的庇护城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","凡失手误伤人命的人可以逃到那里去，这些城就作为他们躲避寻仇人的庇护所。 ");
INSERT INTO cmn2006_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","当他逃到其中的一座城时，必须站在城门口，向该城的长老们说明事情的经过。长老们要让他进城，给他安排地方让他住下来。 ");
INSERT INTO cmn2006_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","如果寻仇的人追来，城里的人不可以把他交出去，因为他是误伤人命，而非积有夙怨。 ");
INSERT INTO cmn2006_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","他可以住在城里，等候公开的审判，直到当时供职的大祭司死了以后才可以返回逃离的家乡。” ");
INSERT INTO cmn2006_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","于是，以色列人指定拿弗他利山地上加利利的基低斯城、以法莲山地的示剑城和犹大山地的希伯仑城作为庇护城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","在约旦河东岸，以色列人指定吕便境内耶利哥以东高原上旷野地带的比悉城、迦得境内基列的拉末城和玛拿西境内巴珊的哥兰城作为庇护城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","这些城是为所有以色列人和寄居的侨民设立的，任何误伤人命的人都可以逃到那里去，等候公开审判，而不致被寻仇的人所杀。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","在迦南地的示罗，利未各家族的族长们去见祭司以利亚撒、嫩的儿子约书亚和以色列各支派、各家族的首领们， ");
INSERT INTO cmn2006_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","说∶“主曾藉着摩西吩咐过，要给我们城居住，要让我们有牧地放牧牲畜。” ");
INSERT INTO cmn2006_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","于是，以色列人遵照主的吩咐，从他们自己的土地中分出一些城镇和牧地给利未人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","利未支派的哥辖宗族首先分得城镇。祭司亚伦家族的后代从犹大、西缅和便雅悯支派分得十三座城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","哥辖宗族的其他家族从以法莲、但和西玛拿西支派分得十座城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","革顺宗族从以萨迦、亚设、拿弗他利和东玛拿西支派分得十三座城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","米拉利宗族从吕便、迦得和西布伦支派分得十二座城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","以色列人按照主藉摩西传达的命令，用拈阄的办法把这些城镇和牧地分给了利未人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","10","以下这些城是从犹大支派和西缅支派分出来给亚伦的后代的。亚伦家族属于利未支派的哥辖宗族，他们首先拈得了阄。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","他们得到了基列亚巴（亚巴是亚衲人的祖先），即希伯仑及其周围的牧地，位于犹大山地， ");
INSERT INTO cmn2006_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","但隶属于希伯仑城的田地和村庄已经分给了耶孚尼的儿子迦勒作为他的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","祭司亚伦的后代分得了希伯仑城（庇护城之一）及其所辖的牧地，还分得了以下诸城∶立拿、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","雅提珥、以实提莫、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","何仑、底璧、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","亚因、淤他和伯示麦，一共九座原属于犹大和西缅支派的城镇及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","他们还从便雅悯支派得到基遍、迦巴、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","亚拿突和亚勒们四座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","祭司亚伦的后代一共分得了十三座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","利未支派哥辖宗族的其余家族拈阄，从以法莲分得四座城∶ ");
INSERT INTO cmn2006_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","以法莲山地的示剑城（庇护城之一）、基色城、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","基伯先城和伯和伦四座城以及它们周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","从但支派分得四座城∶伊利提基、基比顿、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","亚雅仑和迦特临门四座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","从玛拿西半支派分得二座城∶他纳和迦特临门二座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","哥辖宗族的其余各家族一共分得了十座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","利未支派的革顺宗族从玛拿西半支派分得两座城∶巴珊的哥兰（庇护城之一）和比施提拉二座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","从以萨迦分得四座城∶基善、大比拉、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","耶末和隐干宁四座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","从亚设分得四座城∶米沙勒、押顿、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","黑甲和利合四座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","从拿弗他利分得三座城∶加利利的基底斯（庇护城之一）、哈末多珥和加珥坦三座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","革顺宗族各家族总共分得了十三座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","利未支派的米拉利宗族分得的城镇如下∶ 从西布伦分得四座城∶约念、加珥他、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","丁拿和拿哈拉四座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","从吕便分得四座城∶比悉、雅杂、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","基底莫和米法押四座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","从迦得分得四座城∶基列的拉末（庇护城之一）、玛哈念、 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","希实本和雅谢四座城及其周围的牧地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","米拉利宗族拈阄总共分得了十二座城。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","利未人在以色列人的地界中共保有四十八座城， ");
INSERT INTO cmn2006_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","每座城都有隶属于它的牧地。以上是利未支派分得的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","就这样，主按照他对以色列人祖先的许诺，把全部土地赐给了以色列人。他们占领了这些地方，并在那里定居下来。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","主按照他对他们祖先的许诺，赐给他们全境太平，他们的仇敌没有一个能对抗他们，因为主把所有的仇敌都交到了他们的手中。 ");
INSERT INTO cmn2006_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","主应许以色列人的诺言没有一个落空，所有的诺言都实现了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","约书亚召集吕便、迦得和东玛拿西支派的人， ");
INSERT INTO cmn2006_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","对他们说∶“你们完全遵从了主的仆人摩西对你们的命令，也听从了我的一切吩咐。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","至今为止，你们谨守着主－你们的上帝的训示，从未离弃过你们的以色列同胞。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","现在，主－你们的上帝已经按照他的允诺，赐给了你们以色列同胞休养生息之地，你们可以回自己的家园去了。回到上帝的仆人摩西分给你们的在约旦河东岸的土地去吧！ ");
INSERT INTO cmn2006_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","要谨守主的仆人摩西颁给你们的律法，要爱主－你们的上帝，要遵循他的指引，服从他的诫命，要忠于他，要全心全意地侍奉他。” ");
INSERT INTO cmn2006_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","8","约书亚祝福他们，送他们上路返回自己的家乡。分手时，约书亚对他们说∶“你们带着大量的财富，成群的牛羊，还有金、银、铜、铁和衣服，满载而归。你们要和你们的同胞分享从仇敌那里夺来的战利品。”（摩西已经在巴珊给玛拿西半支派分了土地，约书亚把约旦河西岸的土地分给了玛拿西另一半支派和其他支派）。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","于是，吕便、迦得和东玛拿西支派的人在迦南地的示罗与其他以色列人分手，返回自己的领地基列，就是主藉着摩西命令他们去征服的那块土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","吕便、迦得和玛拿西半支派的人来到迦南地约旦河附近的基利绿，在约旦河畔建造了一座宏伟的祭坛。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","有人告诉以色列其他支派的人，说∶“看！吕便、迦得和东玛拿西支派的人在以色列人这边约旦河附近的迦南边界上的基利绿建了一座祭坛！” ");
INSERT INTO cmn2006_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","以色列人听到这个消息，一齐聚集到示罗，准备攻打他们。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","以色列人派祭司以利亚撒的儿子非尼哈到基列去见吕便、迦得和东玛拿西支派的人。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","十个以色列支派各派一个首领跟随同往。这些首领都是以色列各宗族的族长。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","他们到了基列，见到了吕便、迦得和东玛拿西的人，对他们说∶ ");
INSERT INTO cmn2006_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“主的全体会众说∶‘你们为什么要背叛以色列的上帝，不遵循他的指引，另筑祭坛悖逆主呢？ ");
INSERT INTO cmn2006_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","难道我们在毗珥犯的罪还不够吗？瘟疫降于主的会众，我们至今也没有洗净这罪孽。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","现在，你们竟然要背离主！你们今天背叛主，明天他就会迁怒于全体以色列会众。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","要是嫌你们的土地不洁净，你们就过来吧，到主的圣幕所在的地方来，从我们的产业里分一份土地给你们。但是，千万不要背叛主，也不要背叛我们，不要在主－我们的上帝的祭坛之外为自己另筑祭坛。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","谢拉的后代亚干违背了主的命令，没有毁掉应当毁灭的东西，结果主的惩罚降于全体以色列会众，许多人因亚干的罪而跟他一起丧了命。’” ");
INSERT INTO cmn2006_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","吕便、迦得和东玛拿西支派的人答道∶ ");
INSERT INTO cmn2006_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“主是万神之上帝！主是万神之上帝！他洞悉一切；也要让以色列人都知道我们为什么这样做。如果我们背叛主，违背他的意志，就把我们处死吧！ ");
INSERT INTO cmn2006_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","如果我们不遵循主的指引，为自己另造祭坛，在上面献烧化祭、素祭或平安祭，愿主亲自惩罚我们！ ");
INSERT INTO cmn2006_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","确实，我们是因为有所畏惧才造了这座祭坛的。我们想，将来，你们的子孙或许会对我们的子孙说∶‘你们跟主－以色列的上帝有什么关系？ ");
INSERT INTO cmn2006_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","主使约旦河作为我们跟你们吕便人和迦得人之间的界限，你们跟主没有关系！’这样，你们的子孙恐怕会使我们的子孙不再敬畏主了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","所以，我们说∶‘来吧，让我们自己造一座祭坛，’不是为了献烧化祭或祭物， ");
INSERT INTO cmn2006_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","而是作为我们和你们之间以及我们后代之间的信物，证明我们也在主的祭坛上献烧化祭、祭物和平安祭敬拜主。这样，将来你们的子孙就不能对我们的子孙说‘你们跟主没有关系’了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","假如他们将来对我们或我们的子孙说这些话，我们就会回答∶‘看看吧！这是我们祖先按照主的祭坛仿造的坛，它不是用来献烧化祭或祭物的，而是你我之间的见证。’ ");
INSERT INTO cmn2006_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","“我们今天不会悖逆主，将来也永远不会背离主。除了主的圣幕前的祭坛外，我们决不会另造祭坛，在上面献烧化祭、素祭或其他祭物。” ");
INSERT INTO cmn2006_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","祭司非尼哈和与他一起来的会众首领，即各宗族的族长们听了吕便、迦得和东玛拿西人的话，都很满意。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","祭司以利亚撒的儿子非尼哈对他们说∶“现在，我们知道主仍与我们同在，因为你们在这件事上并没有违背主的意志，你们救了以色列人，使他们不至受到主的惩罚。” ");
INSERT INTO cmn2006_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","非尼哈和首领们离开基列地的吕便人和迦得人，返回迦南地向以色列人报告。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","以色列人都很满意，他们赞颂上帝，不再提起要攻打吕便人和迦得人并摧毁他们居住地的事了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","吕便人和迦得人给坛命名∶“我们之间的见证，主即上帝！” ");
INSERT INTO cmn2006_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","主使以色列人不受四境仇敌的骚扰，过了很长一段时间太平无事的生活。 ");
INSERT INTO cmn2006_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","这时，约书亚已经很老了。他把所有的以色列长老、首领、审判官和官长召集到面前，对他们说∶“我已经很老了， ");
INSERT INTO cmn2006_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","你们都已经亲眼看到，主－你们的上帝为了你们对其他各个国家所作的一切，主－你们的上帝一直为你们而战。 ");
INSERT INTO cmn2006_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","看！我已经把东起约旦河，西至地中海地区所有尚未征服的和已经征服的各国的土地分给了你们，作为各支派的永久产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","主－你们的上帝将亲自为你们扫清前进的道路，赶走你们面前的仇敌，你们要遵照主－你们的上帝的许诺，占有他们的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“你们要坚强，要谨守摩西律法书中的一切规定，千万不可背离它们。 ");
INSERT INTO cmn2006_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","你们不可以与留在你们中间的异族混杂，不可以提及他们的神明或以那些神明起誓，不可以侍奉异族的神明或向它们跪拜。 ");
INSERT INTO cmn2006_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","你们一直忠心侍奉主－你们的上帝，今后也要一如继往。 ");
INSERT INTO cmn2006_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“主驱赶走了你们面前的那些强大的民族，使你们至今所向无敌。 ");
INSERT INTO cmn2006_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","你们一个人能够击败一千人，这是因为主－你们的上帝在为你们争战。这是他的允诺！ ");
INSERT INTO cmn2006_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","所以，千万要谨慎，要爱主－你们的上帝！ ");
INSERT INTO cmn2006_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","“如果你们背离主，与留在你们中间的异族混杂，跟他们通婚，彼此往来， ");
INSERT INTO cmn2006_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","那么，主－你们的上帝将不再驱赶你们面前的这些民族，而他们就会象罗网，象陷井，象肋上的鞭，眼中的刺；他们将毒害你们，使你们所有的人从主－你们的上帝赐给你们的这块美好的土地上灭绝！ ");
INSERT INTO cmn2006_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“现在，我快要死了；你们清清楚楚地知道，主－你们的上帝对你们的所有允诺都实现了，没有一件落空。 ");
INSERT INTO cmn2006_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","主－你们的上帝能实现应许给你们的种种福泽，他也能降给你们种种灾祸，把你们从主－你们的上帝赐给你们的这块美好的土地上毁灭掉。 ");
INSERT INTO cmn2006_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","如果你们违背主－你们的上帝吩咐你们要恪守的约，如果你们去侍奉膜拜其他的神明，主就会对你们发怒，使你们很快就从他赐给你们的土地上灭绝！” ");
INSERT INTO cmn2006_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","约书亚把以色列各支派召集到示剑。他召集了长老、首领、审判官和官长，让他们站在上帝的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","约书亚对全体以色列人说∶“主－以色列的上帝是这样说的∶‘很久以前，你们的祖先－包括亚伯拉罕和拿鹤的父亲他拉，住在幼发拉底河彼岸，他们侍奉别的神明。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","后来，我把你们的祖先亚伯拉罕带过河来，领着他走遍了迦南地，赐给他许多子孙。我把以撒赐给他， ");
INSERT INTO cmn2006_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","又把雅各和以扫赐给以撒。我把以东的山地赐给了以扫；而雅各和他的子孙却到埃及去了。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","于是，我派出摩西和亚伦，又降大灾祸于埃及，终于把你们带了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","“‘我把你们的祖先带出埃及后，领你们来到红海。埃及人派出战车和骑兵一直追到红海。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","你们的祖先向我呼救，于是，我用黑暗把他们与埃及人隔开，又用海水淹没了埃及人，消灭了他们。你们都目睹了我对埃及的处置。 “‘以后，你们在旷野里生活了很长一段时间， ");
INSERT INTO cmn2006_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","我又把你们带到了约旦河东岸亚摩利人的土地上。亚摩利人与你们交战；我把他们交到你们的手里，在你们的面前毁灭了他们，使你们占有了他们的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","“‘以后，摩押王巴勒（西拨的儿子）攻打以色列人，派人召来比珥的儿子巴兰来诅咒你们。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","我不理会巴兰的话；结果，他反而祝福你们。就这样，我把你们从巴勒的手中救了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“‘当你们横渡约旦河向耶利哥前进时，耶利哥人攻击你们，亚摩利人、比利洗人、迦南人、赫人、革迦撒人、希未人和耶布斯人也群起攻击你们。我把他们交在你们手中； ");
INSERT INTO cmn2006_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","我使黄蜂群为你们开路，赶走了与你们对敌的两个亚摩利王，没有用你们的一刀一箭。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","我赐给你们的土地不是你们用劳动得来的，我赐给你们的城邑不是你们自己建造的。现在，你们安居在这里，吃着别人种的葡萄和橄榄。’ ");
INSERT INTO cmn2006_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“所以，你们要敬畏主，要全心全意地侍奉他，要摒弃你们祖先在幼发拉底河彼岸和埃及侍奉的其他神明，要专心侍奉主。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","如果你们不愿意侍奉主，那么，今天必须决定，你们要侍奉的是谁。是你们祖先在幼发拉底河彼岸侍奉的神明，还是你们现在居住的土地上的亚摩利人的神明？至于我和我的家人，我们要侍奉主。” ");
INSERT INTO cmn2006_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","人们答道∶“我们永远不离弃主去侍奉别的神明， ");
INSERT INTO cmn2006_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","因为主－我们的上帝曾把我们和我们的祖先领出饱受奴役的埃及，我们亲眼看见了他创造的种种奇迹。在我们途经所有那些国家的漫长旅程中，他始终庇护着我们， ");
INSERT INTO cmn2006_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","是主为我们赶走了所有住在这里的亚摩利人。所以，我们也要侍奉主，他就是我们的上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","约书亚对人们说∶“你们不能侍奉主。因为他是圣洁的上帝，是妒嫉的上帝，他不能容忍你们的背叛和你们的罪过。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","如果你们背弃主去侍奉异族的神明，他将转而降灾祸于你们，把你们灭绝。尽管他曾赐福于你们，他也一样能向你们降下灾祸。” ");
INSERT INTO cmn2006_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","人们对约书亚说∶“不！我们一定要侍奉主。” ");
INSERT INTO cmn2006_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","约书亚对人们说∶“你们要为自己作证，证明你们决定要侍奉主。” 人们说∶“我们愿意作证。” ");
INSERT INTO cmn2006_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","约书亚说∶“现在，你们要摒弃你们中间的异族神明，全心全意地侍奉主－以色列的上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","人们答道∶“我们一定侍奉主－我们的上帝，听从他的吩咐。” ");
INSERT INTO cmn2006_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","在那一天，约书亚与民众立约，在示剑为他们订立了律法典章。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","约书亚把这些律法典章都写进了上帝的律法书，然后在主的圣殿前的橡树下竖立了一块大石头。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","约书亚对全体以色列人说∶“看！这块石头就是我们的见证，它听到了主对我们所说的一切。如果你们背弃你们的上帝，这块石头就是指控你们的证物。” ");
INSERT INTO cmn2006_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","然后，约书亚让人们返回各自的家园。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","嗣后，主的仆人、嫩的儿子约书亚死了，享年110岁。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","他被安葬在迦实山以北以法莲山地的亭拿西拉，那里是他的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","约书亚在世的日子，以色列人侍奉主；约书亚死后，那些亲眼看见过主为以色列人所作的一切的长老们还在世的时候，以色列人依然侍奉主。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","以色列人把约瑟的骸骨从埃及带了出来，安葬在示剑，就是雅各从前用一百块银子向哈抹的后代－示剑的父亲买的那块地，这块地是约瑟家族的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","亚伦的儿子以利亚撒也死了，埋葬在基比亚，那是他的儿子非尼哈在以法莲山地分得的产业。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","约书亚死后，以色列人求问主∶“我们当中哪一个支派应该先去攻打迦南人呢？” ");
INSERT INTO cmn2006_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","主答道∶“犹大人要先去。我已经把那块土地交在犹大人的手里了。” ");
INSERT INTO cmn2006_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","犹大支派的人对他们的亲族西缅支派的人说∶“跟我们一起去征服那块分给我们的土地吧！让我们一起攻打迦南人；以后，我们也和你们一起去征服分配给你们的土地。”于是，西缅人和犹大人一起出发了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","他们发起攻击；主把迦南人和比利洗人交在他们的手里，他们在比色杀了一万人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","在那里，他们与亚多尼比色发生遭遇战，击败了迦南人和比利洗人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","亚多尼比色败逃，他们追击他，俘虏了他，砍断了他手上的大拇指和脚上的大脚趾。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","亚多尼比色说∶“七十个王曾被我砍掉了手上的大拇指和脚上的大脚趾，在我的桌子下捡东西吃。现在，上帝照着我的作法报应我了！”他被带到耶路撒冷，死在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","犹大人攻占了耶路撒冷，杀光了城里的居民，又放火烧了城。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","随后，他们又南下攻击住在山地、南部旷野和西部丘陵地带的迦南人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","犹大人还攻打住在希伯伦的迦南人（希伯伦以前叫基列亚巴），击败了示筛、亚西幔和挞买族人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","犹大人从希伯伦出发进攻底璧（底璧以前叫基列西弗）。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","迦勒说∶“谁攻下基列西弗，我就把女儿押撒嫁给谁为妻。” ");
INSERT INTO cmn2006_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","俄陀聂攻下了城，迦勒把女儿押撒嫁给了他。俄陀聂是迦勒的弟弟基纳斯的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","结婚那天，俄陀聂怂恿押撒向她父亲要一块田地。押撒下了驴，迦勒问她∶“你要什么？” ");
INSERT INTO cmn2006_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","押撒说∶“请为我祝福吧！既然你把我嫁到了干旱的南部，求你把水泉给了我吧！”于是，迦勒把上泉和下泉给了她。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","基尼人是摩西的岳父的后代。他们和犹大人一起离开棕树城（即耶利哥城），来到亚拉得附近的犹大南部旷野，一起住在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","犹大人与西缅人一起击败了住在洗法城的迦南人，毁灭了整座城。因此，这座城叫做何珥玛。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","犹大人还占领了迦萨、亚实基伦和以革伦以及它们所辖的地区。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","主与他们同在；他们占领了山区，但是没有能驱逐走平原地区的迦南人，因为这些人都拥有铁甲战车。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","迦勒按照摩西的应许得到了希伯伦城，他赶走了亚衲后代的三个部族。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","便雅悯人没有驱逐住在耶路撒冷的耶布斯人，所以耶布斯人至今仍与便雅悯人一起住在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","约瑟家族也出发去攻打伯特利城。主与他们同在； ");
INSERT INTO cmn2006_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","他们派探子到伯特利城窥探虚实（伯特利城以前叫路斯）。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","探子们看见一个人从城里出来，就对他说∶“请告诉我们进城的路，我们一定会恩待你的。” ");
INSERT INTO cmn2006_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","那人把进城的路告诉了他们。约瑟家族进了城，杀死了城里的所有居民，只留下了那人和他的家人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","后来，那人到了赫人的地方，在那里建了一座城，命名为路斯，这个名字一直沿用到现在。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","玛拿西支派没有把住在伯善、他纳、多珥、以伯莲、米吉多及其附近村庄里的居民驱逐出去，迦南人继续住在那里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","以色列人强盛了以后，只是强迫迦南人做苦役，并没有再驱逐他们。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","以法莲支派没有把住在基色的迦南人驱逐出去，迦南人继续跟他们住在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","西布伦支派没有把住在基伦和拿哈拉的居民驱逐出去，迦南人继续住在那里，受西布伦人的奴役。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","亚设支派没有把住在亚柯、西顿、亚黑拉、亚革悉、黑巴、亚弗革和利合的居民驱逐出去， ");
INSERT INTO cmn2006_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","他们与当地的迦南人住在一起，没有把他们赶出去。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","拿弗他利支派没有把住在伯示麦和伯亚纳的居民驱逐出去。他们与当地的迦南人住在一起，强迫他们服苦役。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","亚摩利人把但人逼回山地，不容许他们进入平原地区。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","亚摩利人继续住在希烈山、亚雅伦和沙宾；但是，约瑟家族强盛以后征服了他们，强迫他们服苦役。 ");
INSERT INTO cmn2006_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","亚摩利人的边界由亚克拉滨隘口至西拉并向北延伸至山区。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","主的天使从吉甲来到波金，对以色列人说∶“我把你们领出埃及，来到我应许赐给你们祖先的这块土地上。我曾经说过∶‘我决不违背我与你们立的约， ");
INSERT INTO cmn2006_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","你们也决不可与当地人立约；你们要拆毁他们的祭坛。’可是，你们没有服从我的命令。看看你们都做了些什么事！ ");
INSERT INTO cmn2006_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","因此，我要告诉你们，我不再驱赶你们面前的异族人，他们将成为你们的劲敌，他们的神明将张网捕获你们。” ");
INSERT INTO cmn2006_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","主的天使说完这些话，全体以色列人全都号啕大哭起来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","因此，这个地方叫作波金。以色列人在那里向主献祭。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","约书亚遣散了以色列各支派的民众以后，各个支派分别去占据自己分得的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","约书亚在世的时候，以色列人侍奉主；约书亚死后，那些亲眼看见过主为以色列所行神迹的长老们还在世的时候，以色列人依然侍奉主。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","主的仆人、嫩的儿子约书亚一百一十岁的时候死了， ");
INSERT INTO cmn2006_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","他被安葬在自己的领地里，也就是迦实山以北以法莲山地的亭拿西拉。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","后来，与约书亚同时代的人都死了，下一代的人不认识主，也不了解主曾为以色列所作的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","他们开始拜巴力，做了上帝认为邪恶的事。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","他们背弃了把他们领出埃及的主—他们祖先的上帝；他们崇拜邻邦的异神，侍奉他们，从而激怒了主。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","他们背弃主，侍奉巴力和亚斯他录， ");
INSERT INTO cmn2006_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","因此，主对以色列发怒，把他们交在盗贼的手中使他们饱受劫掠，又把他们交在四周仇敌的手中使他们抵挡不住敌人的攻击。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","每次出战，主都按照自己的誓言降灾于他们，使他们苦不堪言。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","后来，主使士师兴起，让他们把以色列人从仇敌手中解救出来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","然而，以色列人竟连士师的话也不听，仍一意追随异族神明，崇拜它们。他们的祖先一直遵行主的命令，而这新一代以色列人却很快地背离了祖先的道路，不再象他们的祖先一样敬畏主。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","每当主为他们兴起士师，主就与士师同在。他因他们受苦受难的哀声而动了恻隐之心，在士师秉政的年代里救他们脱离仇敌之手。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","可是，一旦那士师死了，他们就又故态复萌，追随、侍奉和膜拜异族神明，比上一代人为之更甚，丝毫不肯悔改他们顽劣的作为。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","于是，主向以色列人发怒，说∶“既然他们违背了我命令他们祖先遵守的约，不听从我的话， ");
INSERT INTO cmn2006_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","我也不再把约书亚死时还存留在这片土地上的外族人赶出去。 ");
INSERT INTO cmn2006_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","我要用他们来考验以色列人，看看他们肯不肯象他们的祖先一样遵行我的道路。” ");
INSERT INTO cmn2006_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","因此，主准许那些异族留在这片土地上，没有马上驱逐他们，也没有把他们交在约书亚手中。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","主允许一些异族留在这片土地上，要考验那些没有经历过迦南战事的以色列人， ");
INSERT INTO cmn2006_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","他要让那些从未上过战场的以色列人的后代通晓战争。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","以下是主留下的外族人∶非利士的五个首领；所有的迦南人；西顿人；住在巴力黑门山至哈马隘口之间的黎巴嫩山地里的希未人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","主留下这些异族是要考验以色列人，看他们是否服从主藉摩西颁布给他们祖先的诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","就这样，以色列人混居在迦南人、赫人、亚摩利人、比利洗人、希未人和耶布斯人中间， ");
INSERT INTO cmn2006_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","娶他们的女儿为妻，也将自己的女儿嫁给他们的儿子，并崇拜他们的神明。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","在上帝眼里，以色列人做了恶，他们忘记了主—他们的上帝，而去拜巴力和亚舍拉。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","因此，主对以色列人发怒，把他们交在美索不达米亚王古珊利萨田的手中。他们服侍了古珊利萨田八年。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","以色列人向主呼求，主就兴起了一位拯救者来援救他们，这个人就是俄陀聂，他是迦勒的弟弟基纳斯的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","主的灵降临在他的身上，他做了以色列的士师，领兵出征。主把古珊利萨田王交在他的手中，使他打败了古珊利萨田王。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","国中享了四十年太平，直至俄陀聂死去。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","在上帝眼里，以色列人又做了恶。因此，主使摩押王伊矶伦强盛起来，敌对以色列。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","他联合亚扪人和亚玛力人进犯以色列，打败了以色列人，占领了棕树城（即耶利哥）。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","以色列人服侍了伊矶伦十八年。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","以色列人向主呼求，主就兴起了一位拯救者来援救他们。这个人就是以笏，他是便雅悯人基拉的儿子，能用左手格斗。以色列人派以笏向摩押王伊矶伦进贡。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","以笏打了一把半米长的两刃的剑，把它绑在右腿的裹腿里，藏在衣服里面。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","然后，他向摩押王伊矶伦献上贡品（伊矶伦极其肥胖）。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","献完贡品后，以笏把抬礼物的人都打发走了， ");
INSERT INTO cmn2006_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","自己却从吉甲附近的采石场那里转了回来，向伊矶伦说∶“陛下，我有一件机密的事要向你禀报。” 王说∶“肃静！”侍从们都退了出去， ");
INSERT INTO cmn2006_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","只剩下伊矶伦王独自一人坐在高台的宝座上。以笏走上前去，对他说∶“我给您带来了上帝的旨意。”伊矶伦王从坐位上站起来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","这时，以笏伸左手拨出右腿上的剑，一剑刺进了伊矶伦王的肚子， ");
INSERT INTO cmn2006_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","连剑柄都刺了进去，剑被肥肉夹住，秽物都喷了出来。以笏没有把剑从伊矶伦王的肚子上拨出来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","以笏关上高台的门，并从里面上了锁，然后从下面的厕所里出去了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","以笏刚离开接见大厅不久，伊矶伦的侍从们进来了，他们看见楼门锁着，以为王在里面大解。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","他们等了很久，仍不见楼门打开，感觉有些不妙。他们拿钥匙开了门，发现他们的主人已经死在地板上。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","就在侍从们等候的时候，以笏已经经过采石场逃回西伊拉。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","他到了西伊拉以后，在以法莲山地吹号召集以色列人，率领他们下山， ");
INSERT INTO cmn2006_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","命令他们说∶“跟我来！主已经把你们的仇敌摩押人交在你们的手里了！” 以色列人跟随着他，封锁了约旦河通向摩押的渡口，不准任何人渡河。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","那一战，他们消灭了大约一万名摩押精兵，无一逃脱。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","以色列人在那天战胜了摩押人。国内又享了八十年太平。 ");
INSERT INTO cmn2006_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","以笏以后，亚拿的儿子珊迦做了士师。他用一根赶牛的棍子打死了六百个非利士人，解救了以色列。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","以笏死后，以色列人又做了主认为邪恶的事情， ");
INSERT INTO cmn2006_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","于是，主把他们交在迦南王耶宾的手里。耶宾在夏琐立国，他的领兵元帅是西西拉，驻扎在夏罗设。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","耶宾王拥有900辆铁车，他残暴地压迫以色列人达二十年之久。以色列人向主呼救。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","当时，底波拉是以色列的士师。她是一位女先知，是拉比多的妻子。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","在以法莲山地拉玛和伯特利之间有一棵棕树，她常常坐在那棵棕树下，以色列人都到那里去请她主持公道。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","她派人到拿弗他利的基低斯把亚比挪庵的儿子巴拉召来，对他说∶“主—以色列的上帝吩咐你，‘你率领一万名拿弗他利人和西布伦人到他泊山去， ");
INSERT INTO cmn2006_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","我要使耶宾的元帅西西拉率领他的军队和战车在基顺河与你交战，并把他们交在你的手里。’” ");
INSERT INTO cmn2006_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","巴拉答道∶“如果你跟我一起去，我就去；如果你不去，我也不去。” ");
INSERT INTO cmn2006_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","底波拉说∶“我一定和你同去。但是你这样做将得不到荣耀，因为主将把西西拉交在一个女人的手中。” 于是，底波拉起身与巴拉一起前往基低斯。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","巴拉把拿弗他利人和西布伦人召集到基低斯，有一万人跟随他和底波拉一起出征。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","那时，基尼人希百离开了其他的基尼人，在基低斯附近撒拿音的橡树旁建立了营地。基尼人是摩西的岳父何巴的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","西西拉得悉巴拉已经到了他泊山， ");
INSERT INTO cmn2006_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","就率领所有的900辆铁甲战车和全部军队从夏罗设向基顺河推进。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","底波拉对巴拉说∶“进攻吧！主已经把西西拉交在你的手里。他已经先你而行了！”巴拉率领一万人冲下他泊山。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","主使西西拉和他的铁车及其全军在巴拉的攻势面前不知所措，陷入溃乱，西西拉下了战车徒步逃跑。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","巴拉追击西西拉的铁车和溃军，一直追到夏罗设。西西拉全军覆没，无一幸免。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","西西拉徒步逃到基尼人希百的妻子雅亿的帐篷前，因为夏琐王耶宾与希百家族关系友好。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","雅亿出来迎接他，对他说∶“阁下，请进来吧！请到我这里来，不要害怕。”西西拉跟着雅亿进了帐篷，雅亿用毯子把他盖住。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","西西拉说∶“请给我点水喝吧，我渴坏了。”雅亿打开盛奶的皮袋，让他喝奶，然后，又用毯子把他盖好。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","西西拉又对雅亿说∶“请你站在帐篷门口，如果有人来问这里有没有外人，你就说没有。” ");
INSERT INTO cmn2006_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","西西拉疲倦已极，倒头就沉沉入睡了。这时，雅亿拿了一个钉帐篷的木橛子和一把锤子，悄悄地走到西西拉的身边，把木橛子打进他的太阳穴，一直钉到地上。西西拉就这样死了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","正在这时，巴拉追寻西西拉来到这里，雅亿出去迎接他，对他说∶“来吧，我要给你看看你正在寻找的人。” 巴拉随她走进帐篷，看到西西拉死在地上，一根木橛子穿过了他的太阳穴。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","就在那一天，上帝为以色列人打败了迦南王耶宾。 ");
INSERT INTO cmn2006_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","此后，以色列人越来越强大，他们的势力压倒了迦南王耶宾，最终彻底消灭了他。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","在那一天，底波拉和亚比挪庵的儿子巴拉唱道∶ ");
INSERT INTO cmn2006_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","赞美主！ 以色列人决心战斗，人民自愿从军， ");
INSERT INTO cmn2006_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","显贵们啊，你们要侧耳； 君王们啊，你们要倾听。 我要弹琴歌唱， 歌颂主—以色列的上帝！ ");
INSERT INTO cmn2006_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","主啊！你来自西珥山， 你从以东地走来； 大地震动，暴雨倾盆， 云层倾倒着雨水， ");
INSERT INTO cmn2006_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","群山在西乃山的至高者、主—以色列的上帝面前震撼摇动。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","在亚拿之子珊迦的时代， 在雅亿的年代， 商旅断绝， 行人绕道而行。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","以色列武备弛惫，军士懈怠，直到你兴起； 底波拉啊， 你来作以色列的母亲！ ");
INSERT INTO cmn2006_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","每当以色列人追随新的神明， 争战就临到城门。 在四万以色列人当中， 看不见甲胄，看不见枪矛， 没有一个俨装以待的人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","我的心向着以色列的领袖， 他们与人民在一起， 自愿献身于战争。 赞美主！ ");
INSERT INTO cmn2006_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","你们，无论是骑着白色的驴、坐着昂贵的毯子、还是路旁的行人， 都要好好想一想！ ");
INSERT INTO cmn2006_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","水井旁传来乐师的歌唱， 他们在传扬主的胜利，他的以色列子民的胜利∶主的大军已经兵临城门！ ");
INSERT INTO cmn2006_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","底波拉啊！醒来！醒来！ 你要放声而歌； 巴拉啊！ 亚比挪庵的儿子，你要奋起， 擒住你的仇敌！ ");
INSERT INTO cmn2006_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","这些为数不多的遗民与强敌争斗； 但有主的大军降临，为我打击敌人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","以法莲人从亚玛力山地来， 跟随在便雅悯支派的后面； 将帅来自玛吉， 官长出于西布伦。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","以萨迦的首领与底波拉在一起， 他们是巴拉的后盾， 按照他的命令进入谷地。 然而，在吕便支派， 英勇善战的战士却在自行其是。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","为什么你们逗留在羊群中间， 听那牧羊的笛声？ 在吕便支派里， 人们举棋不定。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","迦得支派留在约旦河彼岸的家园里， 但支派依然在他们的船上！ 亚设支派安居在海岸边的营地里， 他们的营地设在港口旁。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","然而，西布伦人却在沙场舍命冲杀， 拿弗他利人也象他们一样在高地上出生入死。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","在米吉多溪旁的他纳， 诸王前来争战； 迦南的诸王来争战， 却没有得到掳掠的银钱。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","流星从天上参战， 掠过天空攻击西西拉。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","基顺河啊，古老的基顺河！ 愿你把他们席卷而去。 我的灵啊， 要奋力前进！ ");
INSERT INTO cmn2006_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","骏马飞驰，蹄声如雷。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","主的天使说∶ “要诅咒米罗斯， 要严厉地诅咒那里的居民， 因为他们没有来帮助主， 不来帮他打击仇敌。” ");
INSERT INTO cmn2006_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","基尼人希百的妻子雅亿， 在妇女中最受赞美， 在主妇中最受称颂。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","西西拉向她求水， 她用贵重的碗为他端来凝乳。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","她左手拿着钉帐篷的木橛子， 右手拿着工匠的锤子； 她猛击西西拉， 打碎了他的头， 穿透了他的太阳穴。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","西西拉在她的脚下颓然倒地； 他曲身僵卧， 就地死去。 ");
INSERT INTO cmn2006_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","西西拉的母亲临窗眺望， 她在窗槛的后面呼唤着∶ “为什么他的战车迟迟不归？ 为什么听不到他战马的蹄声？” ");
INSERT INTO cmn2006_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","那最聪明的宫女回答她， 其实是在自言自语∶ ");
INSERT INTO cmn2006_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","“他们一定是在搜寻和瓜分战利品， 一个兵士配给一两个女人； 西西拉得到了彩衣， 那绵绣的彩衣色彩绚烂， 披在项颈上格外美丽。” ");
INSERT INTO cmn2006_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","主啊， 愿你的仇敌都象这一样被灭亡， 愿爱你的人象旭日初升，充满生机。 就这样，国内又享了四十年太平。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","以色列人又做了主认为邪恶的事情，主把他们交在米甸人手中长达七年。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","米甸人比以色列人强大，以色列人不得不住在山洞里或山地的角落里以躲避米甸人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","每当以色列人种了庄稼，米甸人、亚玛力人和东部人就来攻打他们， ");
INSERT INTO cmn2006_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","这些外族人在以色列人的土地上建立营地，毁坏庄稼，他们的势力扩张到南部迦萨一带。他们抢走了所有的羊、牛和驴等牲畜，不给以色列人留下一点赖以生存的东西。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","他们多得象蝗虫，带着牲畜和家人及数不清的骆驼蜂拥而来，闯进以色列人境内，毁坏了他们的家园。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","以色列人被米甸人弄得民穷财尽，就向主呼求。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","以色列人受米甸人的压迫而向主呼求， ");
INSERT INTO cmn2006_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","于是，主派遣了一个先知到他们那里，向他们传达主的旨意∶“主—以色列的上帝是这样说的∶‘我曾亲自带领你们离开埃及，使你们脱离了奴隶的桎梏。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","我把你们从埃及人手中解救了出来，同样也把你们从这块土地上的仇敌手中解救了出来；我把他们从你们的面前赶走，把他们的土地赐给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","我曾告诫你们∶我是主—你们的上帝，你们现在住在亚摩利人的土地上，但是不可拜他们的神明。然而，你们没有遵行我的训诫。’” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","主的天使来到俄弗拉，坐在亚比以谢族人约阿施的橡树下。约阿施的儿子基甸正在酿酒池中打麦子，好把它藏起来不让米甸人发现。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","主的天使向基甸显现，对他说∶“大能的勇士啊，主与你同在！” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","基甸答道∶“先生，要是主与我们同在，为什么这些苦难还要降到我们身上？我们的祖先告诉过我们主怎样把他们带出埃及，现在，那些奇迹在哪里呢？主丢弃了我们，把我们交在米甸人的手里了。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","主转向基甸，对他说∶“你要尽你的力量把以色列人从米甸人手中解救出来，我亲自派遣你去。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","基甸答道∶“主啊，我怎样才能解救以色列呢？我属于玛拿西支派中最弱小的宗族，而我又是宗族里最无足轻重的人。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","主说∶“有我与你同在，你将击败米甸人，如同打倒一个人那样容易。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","基甸又说∶“如果我确实蒙受你的恩宠，求你给我一个征兆，我知道与我讲话的就是主。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","请不要离开这里，等我带些礼物来献给你。” 主说∶“我会等你回来。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","基甸回到家里，煮了一只山羊羔，又用十公斤面粉做了无酵饼。他把肉放在篮子里，把汤盛在壶里，然后，把这些东西都带到橡树下面，献给天使。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","上帝的天使吩咐他∶“把肉和无酵饼放在这块大石头上，把汤倒在上面。”基甸照办了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","天使伸出手中的杖，用杖尖触了肉和无酵饼，立时，火焰从大石头中喷了出来，将肉和无酵饼烧得一干二净。随后，天使就不见了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","基甸这才意识到那是主的天使，他惊恐地说∶“不好了！至高的主啊，我竟面对面地看见了你的天使。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","主说∶“放心吧，不要害怕，你不会死。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","于是，基甸在那里为主建了一座祭坛，命名为“主赐平安”。这座祭坛至今仍在亚比以谢族的俄弗拉。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","当天夜里，主吩咐基甸∶“把你父亲的公牛牵来，就是那头七岁大的第二头牛。你要拆毁你父亲为巴力筑的祭坛，砍断坛边的亚舍拉木柱。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","然后，在这高地上为主—你的上帝建一座规范齐整的祭坛，用你砍倒的亚舍拉木柱当柴，把第二头公牛献作烧化祭。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","基甸带了十个仆人，遵照主的吩咐去做。但是，他对家里的人和城里的居民心存疑惧，不敢在白天公然行事，只在夜间把事情做完了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","第二天早晨，城里的居民起来，愕然发现巴力的祭坛被拆毁了，坛旁的亚舍拉木柱也被砍倒了；而第二头公牛献在了新筑的祭坛上。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","他们互相询问∶“这是谁干的事？”经过一番查询，有人告诉他们∶“这是约阿施的儿子基甸干的。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","于是，人们逼问约阿施，说∶“把你的儿子交出来！我们要杀死他！他拆毁了巴力的祭坛，还砍倒了坛旁的亚舍拉木柱。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","约阿施对围着他的人们说∶“你们想为巴力争辩吗？你们想护卫他吗？谁要为他争辩，就把谁立刻杀掉！如果巴力真的是神，就让他自己出来为自己争辩吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","那一天，约阿施把基甸叫做耶路巴力，因为约阿施说∶“让巴力与他争辩吧，是他拆毁了巴力的坛。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","当时，全部米甸人、亚玛力人和东部部族的人集结在一起，渡过约旦河，在耶斯列谷扎下营寨。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","主的灵降临到基甸的身上，他吹起号角，把亚比以谢族人召集到他的麾下， ");
INSERT INTO cmn2006_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","又传檄玛拿西全境和亚设支派、西布伦支派和拿弗他利支派；他们纷纷前来与他会合。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","基甸向上帝祈祷，说∶“如果你真的象你说过的那样要藉我的手拯救以色列， ");
INSERT INTO cmn2006_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","那么，我就把一团羊毛放在打麦场上；如果早晨只有羊毛上有露水，而别处都是干的，我就确信你确实如你所说的要藉我的手来拯救以色列。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","结果事情与基甸所祈祷的分毫不差。第二天，基甸一大早起来，他挤了挤羊毛，竟挤出了满满一碗水。 ");
INSERT INTO cmn2006_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","基甸又向上帝祈祷，说∶“请别对我发怒，容我再说一次∶请让我再用羊毛做一次试验。这一次只让羊毛是干的，而别的地方都有露水。” ");
INSERT INTO cmn2006_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","当晚，上帝办了这件事，打麦场上布满了露水，唯有羊毛是干的。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","耶路巴力（即基甸）率领他的人马清早启程，在哈律泉附近扎营。米甸人的营地在他们北面的谷中，靠近摩利冈。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","主对基甸说∶“跟随你的人太多了，我不能就这样把米甸人交在他们的手中。否则他们会在我的面前夸耀，说他们是靠自己的力量解救了自己。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","你要向人们这样宣告∶‘凡是胆怯和惧怕争战的，可以及早离开基列山回去。’”有二万二千人散去了，一万人留了下来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","主对基甸说∶“人还是太多。你把他们领到水边去，我在那儿替你把他们分开。我说这个人可以跟你去，他就可以去；我说这个人不可以跟你去，他就不可以去。” ");
INSERT INTO cmn2006_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","基甸把留下的人带到水边。主对基甸说∶“凡是象狗那样用舌头舔水喝的，让他们站在一旁；跟那些跪着喝水的分开来。” ");
INSERT INTO cmn2006_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","结果，有三百人用手捧着水舔，其余的人都跪着喝水。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","主对基甸说∶“我只用这三百个舔水喝的人拯救你们，让其余的人都回家去。我要把米甸人交在你的手中。” ");
INSERT INTO cmn2006_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","于是，这三百人接管了食物和号角，其余的人都被遣散回家，基甸只留下这三百人。米甸人的营地就在他们下面的谷中。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","当天夜里，主命令基甸∶“立刻起来！冲下去攻打米甸人的营地，我已经把他们交在你的手中了！ ");
INSERT INTO cmn2006_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","11","如果你还心怀疑虑不肯贸然出战，那就先带着你的仆人普拉到敌营里去听听米甸人在说些什么，然后，你就有勇气去攻打他们了。” 基甸带着仆人普拉来到敌营的前哨。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","米甸人、亚玛力人和东部部族的人象成群的蝗虫一样遍布谷中，他们的骆驼多得象海边的沙粒。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","基甸潜近营地，听见一个人对他的同伴讲他做的梦。那个人说∶“我做了一个梦，梦见一块大麦饼滚进米甸营中，它撞到帐篷上，帐篷被撞得底朝天摊在地上。” ");
INSERT INTO cmn2006_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","那同伴答道∶“那不是别的，是以色列人基甸的刀啊！他是约阿施的儿子，上帝把米甸人和我们全军都交在他的手里了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","基甸听到他们讲梦和解梦以后，跪下来敬拜上帝。他返回以色列营地，传下命令∶“赶快起来！主已经把米甸军队交在你们手里了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","他把这三百人分成三队，每个人发给一支号角和一个空瓶子，瓶子里藏着火把。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","他命令他们∶“你们要看着我行事；到达敌营外围的时候，我怎样做你们就怎样做。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","我和我这一队人吹响号角以后，你们也要在敌营周围吹响号角，还要高声呐喊∶‘为了主！为了基甸！’” ");
INSERT INTO cmn2006_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","基甸和他率领的一百人在午夜时分到了敌营的外围。卫兵刚刚换完岗，基甸和他的手下人就吹响号角，打碎手中的瓶子。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","三队人一齐吹响号角，打碎手中的瓶子，他们左手举着火把，右手拿着号角，一边吹号，一边高声呐喊∶“主的剑！基甸的剑！” ");
INSERT INTO cmn2006_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","他们在敌营周围守住各人的岗位。整个营地一片混乱，人们仓惶喊叫，四下奔逃。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","当基甸的人吹响了全部三百只号角时，主使米甸全军自相砍杀。他们往西利拉方向奔逃，一直逃到伯哈示他和他巴附近的亚伯米何拉。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","拿弗他利、亚设和全玛拿西的人都被召集起来追击米甸人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","基甸派人走遍以法莲山地各处，吩咐他们∶“下来攻打米甸人，把守住约旦河各处的渡口，一直到伯巴拉，不要让米甸人渡河。”以法莲人集结起来，封锁了约旦河各处的渡口，一直到伯巴拉。 ");
INSERT INTO cmn2006_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","他们俘虏了米甸人的两个首领—俄立和西伊伯，在俄立岗杀了俄立，在西伊伯榨酒池那里杀了西伊伯。他们继续追击米甸人，并且把俄立和西伊伯的头颅带过约旦河交给了基甸。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","以法莲人抱怨基甸说∶“你去打米甸人，为什么不招呼我们同去呢？为什么这样对待我们？”他们对基甸很不满。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","3","基甸答道∶“我所做的这一切怎么能与你们相比？上帝已经把米甸人的首领俄立和西伊伯交在你们手里了。你们以法莲人摘剩下的葡萄，不是强过我们亚比以谢人所摘的葡萄么？我所做的怎么能与你们相比？”听到基甸的这些话，他们也就释然了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","基甸率领三百名部下渡过约旦河，尽管人马困乏，仍然继续追击敌人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","他对疏割人说∶“请给我的士兵一些面包吧！他们太累了。我还要去追击米甸王西巴和撒慕拿。” ");
INSERT INTO cmn2006_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","不料，疏割的首领们却说∶“你还没有抓住西巴和撒慕拿，我们为什么要供给你的军队？” ");
INSERT INTO cmn2006_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","基甸说∶“你们要为此付出代价。等到主把西巴和撒慕拿交到我的手中以后，我要用旷野上的荆棘抽打你们。” ");
INSERT INTO cmn2006_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","基甸继续前进，来到毗努伊勒，向那里的人提出同样的要求，毗努伊勒人的回答与疏割人一样。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","基甸对他们说∶“等我得胜归来的时候，我要拆毁这座城堡。” ");
INSERT INTO cmn2006_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","西巴和撒慕拿与他们的军队呆在加各城里，只剩下东部部族的一万五千名兵士，十二万训练有素的战士已经阵亡。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","基甸沿着挪巴和约比哈东面游牧人的路前进，突击敌军。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","西巴和撒慕拿逃跑了，基甸追击他们，俘虏了这两个米甸王，并击溃了他们的全部军队。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","基甸从战场归来经过希列斯隘口的时候， ");
INSERT INTO cmn2006_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","捉住了一个疏割青年。基甸审讯他，让他列出了疏割的首领和长老们的名单，一共77人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","基甸来到疏割，对疏割人说∶“这儿就是西巴和撒慕拿！你们曾嘲弄我，说∶‘是不是你已经把西巴和撒慕拿捉到了，所以我们得供给你的军队？’” ");
INSERT INTO cmn2006_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","他用旷野里的荆棘鞭打疏割的长老们，教训了疏割人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","接着，他又拆毁了毗努伊勒城堡，杀光了城里的男人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","基甸问西巴和撒慕拿∶“你们在他泊杀死的是些什么样的人？” 他们答道∶“他们每个人都很象你，个个都象王子。” ");
INSERT INTO cmn2006_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","基甸说∶“他们都是我的同胞兄弟。我指着活生生的主起誓，要不是你们杀害了他们，我也不会杀死你们。” ");
INSERT INTO cmn2006_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","他喝令他的长子益帖∶“去！把他们杀掉！”益帖还是个孩子，他有些害怕，不敢拔刀下手。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","西巴和撒慕拿对基甸说∶“你自己动手吧！你才有这力量。”基甸杀了他们，拿走了他们骆驼脖子上的月亮圈。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","以色列人对基甸说∶“你把我们从米甸人手中救了出来，请你做我们的首领吧！让你和你的子孙都做我们的首领。” ");
INSERT INTO cmn2006_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","基甸对他们说∶“我不做你们的首领，我的子孙也不做你们的首领；主要统领你们。” ");
INSERT INTO cmn2006_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","他又说∶“我只要求你们做一件事，请你们把夺来的耳环交给我。”（因为敌军是以实玛利人，都戴金耳环。） ");
INSERT INTO cmn2006_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","人们答道∶“我们愿意给你。”他们摊开一件外衣，每个人都把夺来的耳环丢在上面。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","基甸收集了大约二十公斤重的金耳环，此外还有米甸诸王穿戴的月环、耳坠和紫色的衣服以及骆驼项上的项圈。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","基甸用这些金子铸成了一个以弗得，竖立在家乡俄弗拉。以色列人对上帝不忠，都到那里崇拜它。这件事为基甸和他的家族伏下了祸根。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","米甸人被以色列人征服，不敢再生事端。国内又享四十年太平，直到基甸去世。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","耶路巴力（即基甸）回到自己的家里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","他的妻妾很多，为他生了七十个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","他在示剑也有一个妾，生了一个儿子，基甸给这个儿子起名叫亚比米勒。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","基甸高寿而终，葬在他父亲约阿施的墓地里；墓地座落于亚比以谢族的俄弗拉。 ");
INSERT INTO cmn2006_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","基甸一死，以色列人又背弃上帝去拜巴力。他们把巴力比利士奉为自己的神明， ");
INSERT INTO cmn2006_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","不再敬拜主—曾把他们从周围的仇敌手中解救出来的上帝， ");
INSERT INTO cmn2006_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","也不因基甸为以色列人做过的好事而善待他的家。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","基甸的儿子亚比米勒去示剑见他的母舅们，他对他们和他外祖父全家人说∶ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","“你们去问问示剑的权贵们，他们是打算服侍耶路巴力的所有七十个儿子还是只向一人俯首称臣？要记住，我—亚比米勒是你们的亲骨肉。” ");
INSERT INTO cmn2006_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","他的母舅们向示剑的权贵们转达了他的话。示剑人决定拥戴亚比米勒，因为他是他们的亲戚。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","他们从巴力比利士的庙里拿了七十块银子交给亚比米勒；他用这些银子雇了一群流氓跟随左右。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","他闯进俄弗拉他父亲的家里，把耶路巴力的七十个儿子—也是他的兄弟—都杀死在一块石头上。只有最小的儿子约坦藏了起来，幸免于难。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","随后，示剑的权贵们和米罗人集合起来，他们来到示剑的橡树旁的柱子那里，立亚比米勒为王。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","约坦听到这个消息，他爬上基利心山，站在山顶上大声呼喊∶“示剑的权贵们哪，你们要听听我的话！愿上帝也倾听你们的陈述。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","“树木们要立一个王。它们对橄榄树说∶‘你做我们的王吧！’ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","橄榄树答道∶‘难道要我停止生产供奉神明和使人荣耀的橄榄油，而去在你们众树之上飘摇吗？’ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","“它们对无花果树说∶‘你做我们的王吧！’ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","无花果树答道∶‘难道要我停止结出甜美的果子，而去在你们众树之上飘摇吗？’ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","“它们对葡萄树说∶‘你做我们的王吧！’ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","葡萄树答道∶‘难道要我停止产出神明和人喜爱的酒，而去在你们众树之上飘摇吗？’ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","“于是，树木们一起对荆棘丛说∶‘你来做我们的王吧！’ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","荆棘丛答道∶‘如果你们真心立我为王，就来投靠在我的荫下吧，让我来保护你们；如果你们心意不诚，荆棘丛就会起火，连黎巴嫩的香柏树一齐烧光。’ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","“现在，你们是否真心立亚比米勒为王？你们是否公正地对待耶路巴力，按他的功绩善待他的家人？ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","我的父亲曾为你们征战，他出生入死，把你们从米甸人的手中解救出来， ");
INSERT INTO cmn2006_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","而今天，你们竟然背叛了我父亲的家族，把他的七十个儿子一起杀死在一块大石头上！你们把我父亲侍妾的儿子亚比米勒立为示剑的王，只因为他是你们的亲戚； ");
INSERT INTO cmn2006_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","今天，如果你们以诚意对待耶路巴力和他的家族，我愿你们和亚比米勒都快乐； ");
INSERT INTO cmn2006_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","但是，如果你们所行不义，愿火从亚比米勒发出，烧尽你们示剑的权贵和米罗人；也愿火从你们发出，把亚比米勒烧死。” ");
INSERT INTO cmn2006_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","随后，约坦逃到了比珥，在那里住了下来，躲避他的哥哥亚比米勒。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","亚比米勒统治了以色列三年。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","但是，上帝使亚比米勒与示剑的权贵们不和，他们转而背叛了亚比米勒。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","这就是要让耶路巴力的七十个儿子所受的残害和他们所流的血报应在他们的兄弟亚比米勒身上，因为是他杀害了他们；同时也要报应在示剑的权贵们身上，因为是他们怂恿他杀害了他的兄弟们。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","示剑的权贵们在山顶上设下埋伏，要杀亚比米勒。他们抢劫从那里经过的每一个人。有人把这件事报告了亚比米勒。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","以别的儿子迦勒和他的弟兄来到示剑。示剑的权贵们很信任他。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","他们到葡萄园采葡萄，酿酒，设摆宴筵；他们进神庙，在那里又吃又喝，咒骂亚比米勒。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","迦勒说∶“亚比米勒是谁？我们示剑人又是谁？为什么我们要服侍他？他不过是耶路巴力的儿子罢了！西布勒也不过是他的帮手。我们应该服侍哈抹的后代，他才是示剑人的祖先！为什么要服侍亚比米勒？ ");
INSERT INTO cmn2006_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","要是这里的人归我统率，我就除掉亚比米勒！我要告诉他∶‘整顿你的队伍，出来接战吧！’” ");
INSERT INTO cmn2006_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","示剑城的首领西布勒听到以别的儿子迦勒的话，非常恼怒。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","他派人到亚鲁玛向亚比米勒报告∶“以别的儿子迦勒和他的兄弟们到了示剑，煽动城里的人反对你。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","你要连夜起兵埋伏在野外， ");
INSERT INTO cmn2006_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","明天天一亮就突袭这座城。迦勒率队出去迎战时，你要狠狠地揍他。” ");
INSERT INTO cmn2006_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","于是，亚比米勒趁夜率军出发，他把全军分成四队，埋伏在示剑城外。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","清晨，亚比米勒和他的军队一看见迦勒出现在城门口，就从埋伏的地方冲了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","迦勒看见了，对西布勒说∶“看！有人从山上下来了！” 西布勒答道∶“不，你把山的阴影看成人了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","迦勒又说∶“看！有人从山坡上下来了，还有一队人从占卦的橡树那里过来了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","西布勒对他说∶“你说过，‘亚比米勒算什么，’叫我们不要服侍他。现在，你嘲笑的人就在眼前！你夸下的海口在哪儿？出去迎战吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","迦勒率领示剑的首领们出去与亚比米勒交战。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","亚比米勒攻击迦勒；迦勒大败而逃，伤亡的人一直堆到城门口。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","亚比米勒返回亚鲁玛。西布勒把迦勒和他的兄弟都赶出了示剑，不准他们再呆在城里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","第二天，城里的居民要到田里去，有人报告了亚比米勒。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","亚比米勒集结起部队，把他们分成三队，埋伏在田野里。他望见人们出了城，就冲出来攻击他们。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","亚比米勒率领一队人冲过去扼住了城门的通路，其他两队人向田野里的人群冲杀。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","整整一天，亚比米勒都在攻城。他终于把城攻下，杀光了城里的所有居民。随后，他又把城拆毁，把盐撒在废墟上。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","示剑堡的首领们得到消息，躲进了巴力比利士庙的地堡里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","有人把这件事报告了亚比米勒。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","于是，亚比米勒带着部下上了撒扪山。他拿斧子砍下一根大树枝，扛在肩上，命令部下也迅速照着他的样子做。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","每个人都砍了一捆树枝，跟随着亚比米勒把树枝都堆放在地堡周围，然后放火烧了地堡。就这样，示剑堡的人也都死了，男女约有一千人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","随后，亚比米勒前去围攻提备斯，攻占了它。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","城里有一座塔，非常坚固。全城的男女居民和首领们都逃进塔里，他们把塔门关牢，登上塔顶。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","亚比米勒攻打这塔，直逼塔下；他接近塔门，要放火烧塔。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","不料，塔上有一个妇人搬起一块上磨石抛了下来，正落在亚比米勒的头上，把他的头盖骨打碎了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","亚比米勒急忙叫替他拿兵器的年轻侍卫过来，对他说∶“你拔刀杀了我吧！免得人家说我死于一个妇人之手！”侍卫遵命拔刀刺下，亚比米勒就此身亡。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","以色列人看见亚比米勒死了，纷纷散去。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","就这样，上帝使亚比米勒对他父亲做的恶事得了报应，因为他杀害了自己的七十个兄弟。 ");
INSERT INTO cmn2006_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","上帝也使示剑人为自己的罪恶受到报应。耶路巴力的儿子约坦的诅咒在他们身上都应验了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","亚比米勒死后，陀拉出来解救以色列人。他是朵多的孙子，普瓦的儿子，是以萨迦支派人，住在以法莲山地的沙密。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","他做了二十三年以色列士师。死后葬在沙密。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","陀拉死后，睚珥兴起。他是基列人，做了二十二年以色列士师。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","他有三十个儿子，他们骑三十匹驴。他们在基列地有三十座城（这些城至今仍叫做哈倭特睚珥）。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","睚珥死后葬在加门。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","以色列人又做了主认为邪恶的事情。他们拜巴力和亚斯他录以及亚兰、西顿、摩押、亚扪和非利士的神明。他们背弃了主，不再敬拜他。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","主对以色列人发怒，把他们交在非利士人和亚扪人的手中。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","这些人欺压住在约旦河东岸亚摩利人境内的基列地的以色列人达十八年之久。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","亚扪人还渡过约旦河，攻打犹大、便雅悯和以法莲支派。以色列人的处境极其艰难。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","于是，以色列人向主呼求，说∶“主啊！我们得罪你了；因为我们背弃了自己的上帝而去拜巴力了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","主对以色列人说∶“从前，埃及人、亚摩利人、亚扪人、非利士人、 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","西顿人、亚玛力人和马云人欺压你们，你们向我求告，难道我没有把你们从他们的手中解救出来吗？ ");
INSERT INTO cmn2006_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","可是你们还是背弃我去侍奉别的神明。所以，我不再救你们了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","去求告你们所侍奉的那些神明吧！让他们在你们遭难的时候解救你们吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","以色列人向主求告，说∶“我们犯了大罪！随你怎样处置都行，只是求你今天解救我们吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","他们除掉了他们中间的异族神明，又重新侍奉主。以色列人的苦难使主心中担忧。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","亚扪人在基列扎营备战。以色列人也集结起来，在米斯巴扎营。 ");
INSERT INTO cmn2006_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","基列人的首领们彼此议定∶谁能统领这场与亚扪人之战，谁就做全基列人的首领。 领。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","基列人耶弗他具有非凡的军事才能。他是基列的儿子，他的母亲是个妓女。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","基列的妻子也生了儿子。基列嫡出的儿子们长大成人后，把耶弗他赶出了家门。他们对他说∶“你不能继承我们父亲的家产，因为你是别的女人生的。” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","耶弗他被迫离家来到陀伯居住，躲避他的兄弟们。在那里，一些游民聚集在他的周围，不离他的左右。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","过了些日子，亚扪人向以色列人开战。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","战端一开，基列的长老们就到陀伯去请耶弗他回来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","他们对耶弗他说∶“请你回来做我们的统帅吧，这样我们才能战胜亚扪人。” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","耶弗他说∶“从前不是你们恨我、逼我离开我父亲家的吗？现在你们遭了难，找我干什么？” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","基列的长老们答道∶“正是因为遭了难，我们现在才来找你，请你同我们一起去对抗亚扪人，还要请你做我们全基列人的首领。” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","耶弗他对长老们说∶“你们要我回去与亚扪人作战，如果主使我打败他们，我就要做你们的首领。” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","基列的长老们说∶“主为我们作证，我们一定遵从你的意志。” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","于是，耶弗他与长老们一起回到基列；基列人拥立他做全基列的首领和统帅。耶弗他在米斯巴把自己对长老们说过的话重又陈明在主的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","耶弗他派使者到亚扪王那里，对他说∶“你与我有什么相干，竟来侵犯我们的土地？” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","亚扪王对使者说∶“当年以色列人离开埃及以后，他们占据了我的土地。这片土地包括从亚嫩河直到雅博河和约旦河的地域。现在，你们把这块土地好好地还给我吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","耶弗他又派使者去见亚扪王。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","使者对亚扪王说∶“耶弗他要我转告你∶‘以色列人并没有侵占摩押人或亚扪人的土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","他们当初离开埃及以后，经过旷野到红海，然后来到加低斯。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","当时，以色列人派使者去见以东王，请求他准许他们经过他的领土，但是以东王不肯。以色列人又派使者去见摩押王，他也不准以色列人穿越他的国境。于是，以色列人不得不留在加低斯。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","“‘后来，他们穿过旷野，绕过以东和摩押的领土，来到摩押的东边，在亚嫩河的对岸扎营。他们并没有进入摩押的领土，因为亚嫩河就是摩押的边界。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","以色列人派使者去见亚摩利王西宏，就是希实本王，请求他准许他们经过他的领土回到以色列人自己的土地上去。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","但是，西宏不信任他们，他不但不准以色列人穿越他的国土，反而集结军队在雅杂扎营，攻打以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","主—以色列的上帝把西宏和他的军队都交在以色列人手中；他们打败了亚摩利人，占领了他们的全部土地。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","这块土地包括从亚嫩河至雅博河、从旷野至约旦河的地域。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","“‘主—以色列的上帝为他的子民以色列人赶走了亚摩利人，你们竟要来赶走以色列人吗？ ");
INSERT INTO cmn2006_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","你们的神明基抹给你们的土地，你们可以拥有；主—我们的上帝为我们征战所得的一切，我们也要守住。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","难道你比西拨的儿子摩押王巴勒还强大吗？他从来没有向以色列人寻衅，也从来没有攻打过我们。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","“‘在希实本和亚罗珥及其它们周围的村镇，在亚嫩河沿岸的所有城镇里，以色列人已经居住了三百年了，在那些年月里，你们为什么不去收回这块土地？ ");
INSERT INTO cmn2006_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","我没有得罪过你，你却要把战祸横加在我的头上。今天，让主—审判者在以色列人和亚摩利人之间评判是非吧！’” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","但是，亚扪王根本不理睬耶弗他转告他的话。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","于是，主的灵降临在耶弗他的身上，他经过基列和玛拿西前往基列地的米斯巴，从那里出发偷袭亚扪人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","耶弗他向主许愿，说∶“主啊，如果你把亚扪人交在我的手里， ");
INSERT INTO cmn2006_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","当我凯旋归来之时，一定把第一个从我家门里出来迎接我的人当做烧化祭献给你。” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","随后，耶弗他向亚扪人发起攻击。主把亚扪人交在他的手中； ");
INSERT INTO cmn2006_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","他攻击他们，从亚罗珥到米匿直至亚备勒基拉明，攻占了二十座城池，沉重地打击了亚扪人。就这样，亚扪人被以色列人制伏了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","耶弗他回到米斯巴自己家的时候，他的独生女儿拿着手铃跳着舞出来迎接他。他没有儿子，只有这唯一的一个女儿。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","耶弗他见了她，悲痛地撕裂衣服，说∶“女儿啊，你还不如杀了我！你使我万分心痛！我已经向主许了愿，不能改变了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","他的女儿说∶“父亲，你已经向主许了愿，就照你许的愿对待我吧，因为主已经在你仇敌亚扪人身上为你报了仇了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","接着她又对父亲说∶“我只要求一件事∶请给我两个月的时间，我要到山上去，要在山林里漫游，要和我的女伴们为我终为处女而哀哭。” ");
INSERT INTO cmn2006_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","耶弗他答应了，让她离开两个月。她和女伴们一起到山上去，在那里为她还没有出嫁就死而哀哭。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","两月期满，她回到父亲那里，耶弗他照他所许的愿，把她献为烧化祭。他的女儿至死还是童贞之身。 ");
INSERT INTO cmn2006_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","此后，在以色列形成一个风俗∶每年以色列女子都要离家四天，去记念基列人耶弗他的女儿，为她哀伤。 ");
INSERT INTO cmn2006_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","以法莲人结队渡过约旦河，来到撒分，对耶弗他说∶“你去攻打亚扪人，为什么不招呼我们同去？现在，我们要烧毁你的房子！” ");
INSERT INTO cmn2006_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","耶弗他对他们说∶“我和我的同胞与亚扪人浴血苦战的时候，我曾征召你们，但你们不肯相援。 ");
INSERT INTO cmn2006_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","我看到靠你们救援无望，就向亚扪人舍命冲杀，而主把他们交到了我的手中。现在，你们竟然还要来攻打我？” ");
INSERT INTO cmn2006_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","耶弗他召集全基列的人与以法莲人交战，打败了以法莲人。以法莲人曾说∶“你们这些住在以法莲和玛拿西土地上的基列人不过是些倚靠以法莲偷生的人。” ");
INSERT INTO cmn2006_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","基列人封锁了约旦河的渡口，不准以法莲人渡河。如果有以法莲的败兵要渡河，基列人就问他∶“你是以法莲人吗？”他如果说∶“不是”， ");
INSERT INTO cmn2006_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","他们就对他说∶“你说示播列”。以法莲人发音不准，把示播列说成“西播列”；基列人就抓住他，在约旦河渡口把他杀掉。当时，有四万两千名以法莲人被杀。 ");
INSERT INTO cmn2006_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","耶弗他做了六年以色列士师，死后葬在家乡基列。 ");
INSERT INTO cmn2006_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","耶弗他死后，以比赞做以色列的士师。他是伯利恒人， ");
INSERT INTO cmn2006_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","有三十个儿子和三十个女儿。他把女儿嫁给别的宗族，从别的宗族为儿子娶妻。以比赞做了七年以色列士师， ");
INSERT INTO cmn2006_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","死后葬在伯利恒。 ");
INSERT INTO cmn2006_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","以比赞死后，以伦做以色列的士师。他是西布伦人。以伦做了十年以色列士师， ");
INSERT INTO cmn2006_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","死后葬在西布伦境内的亚雅伦。 ");
INSERT INTO cmn2006_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","以伦死后，押顿做以色列的士师。他是比拉顿人希列的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","他有四十个儿子，三十个孙子；他们骑着七十头驴。押顿做了八年以色列士师， ");
INSERT INTO cmn2006_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","死后葬在以法莲的比拉顿，位于亚玛力人的山地里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","以色列人又做了主认为邪恶的事情，主把他们交在非利士人手中，达四十年之久。 ");
INSERT INTO cmn2006_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","有一个但族人，名叫玛挪亚，住在琐拉城。他的妻子一直没有生育。 ");
INSERT INTO cmn2006_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","主的天使向他的妻子显现，说∶“你一直没有生育，如今你要怀孕生子了！ ");
INSERT INTO cmn2006_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","5","你现在实际上已经怀孕了，不久就会生下一个儿子；儿子出生以后，你不要用剃刀给他剃头。这孩子在出生前就归上帝作拿细耳人，他就是将来把以色列人从非利士人手里解救出来的人。因此，你应该注意∶不可喝烈酒或淡酒，也不可吃不洁净的东西。” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","女人回去告诉丈夫∶“有一个神人到我这儿来了！他的外貌象上帝的天使，令人害怕。我没有问他从哪儿来，他也没有告诉我他的名字。 ");
INSERT INTO cmn2006_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","他对我说∶‘你已经怀孕了，不久就要生一个儿子。所以，不可喝烈酒或淡酒，也不可吃不洁净的东西。因为这孩子还在母腹中时就已献身于上帝，他要终身作拿细耳人。’” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","玛挪亚向主祈祷，说∶“主啊，求你让我们再见一见你差遣的神人吧，让他教给我们怎样教养这个快要出生的孩子。” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","上帝听见了玛挪亚的祈祷。上帝的天使又来到那女人的面前。她正独自一人坐在田野里，她的丈夫玛挪亚不在她的身边。 ");
INSERT INTO cmn2006_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","她赶快跑去告诉丈夫，说∶“快看！那天来找我的那个人又向我显现了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","玛挪亚起身跟着妻子去见那人，对他说∶“你就是向我妻子说过话的那个人吗？” 那人答道∶“是的。” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","玛挪亚又问∶“如果你的话当真，我们该怎样教养这孩子？他应当干些什么？” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","主的天使说∶“你的妻子必须谨守我告诉过她的一切。 ");
INSERT INTO cmn2006_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","她不可吃任何葡萄做的东西，不可喝烈酒或淡酒，也不可吃不洁净的东西，她一定要遵守我所吩咐的一切。” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","16","玛挪亚不知道他是主的天使，挽留他说∶“请不要走，我们烧一只小山羊给你吃吧！” 天使说∶“我即便留下来，也不会吃你们的食物。不过要是你要准备烧化祭，就把它献给主吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","玛挪亚又对天使说∶“请问你的名字？等你的话应验了，我们好报答你。” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","天使答道∶“何必问我的名字呢？那是神秘莫测的。” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","于是，玛挪亚拿来一只小山羊和一些素祭，放在石头上献给主—创造奇迹的至高者。玛挪亚和妻子站在一旁观看。 ");
INSERT INTO cmn2006_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","21","火焰从祭坛上升起，主的天使当着玛挪亚和他妻子的面在火焰中飞升了。玛挪亚这才知道那人原来是主的天使，便和妻子一起俯伏在地上。从那以后，主的天使不再向他们显现。 ");
INSERT INTO cmn2006_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","玛挪亚对妻子说∶“我们竟看见了上帝，准是要死了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","他的妻子说∶“主要是想处死我们，就不会接受我们的烧化祭和素祭了。他也不会向我们显示这一切，并且在这个时候告诉我们这些话。” ");
INSERT INTO cmn2006_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","后来，玛挪亚的妻子生了一个儿子，起名叫参孙。孩子渐渐长大，主保佑着他。 ");
INSERT INTO cmn2006_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","他到了玛哈尼但城以后，主的灵降临到他的身上。玛哈尼但在琐拉和以实陶之间。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","参孙到亭拿去，在那里遇见一个非利士女子。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","他回家告诉父母，说∶“我在亭拿遇见一个非利士女子，请把她娶来作我的妻子吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","他的父母对他说∶“难道我们本族同胞中没有一个女子合你的心意，一定要到那些不受割礼的非利士人中间去娶妻吗？” 参孙坚持说∶“我觉得她对我很合适，请把她娶来吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","他的父母并不知道这是主的意志。当时，非利士人统治着以色列，主在制造机会敌对非利士人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","于是，参孙和父母一起到亭拿去。当他们经过亭拿的葡萄园时，忽然一只少壮的狮子咆哮着扑向参孙。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","主的灵以巨能降临在参孙身上，他赤手空拳地撕裂了那只狮子，如同撕裂一只羔羊一样。参孙没有把这件事告诉父母。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","参孙去见那个女子，与她讲话，很喜欢她。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","过了几天，参孙回来娶她。途中，他转道去看那只被他杀死的狮子，竟在狮子的尸体里发现了一群蜜蜂和蜂蜜。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","他把蜂蜜挖出来，放在手里，一边走，一边吃。到了父母那里，他把蜂蜜给了他们，他们也吃了。但是，参孙没有告诉他们这蜂蜜是从死狮身上取出来的。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","参孙的父亲到了那女子的家里；参孙按照当地年轻人的习惯，在那里大摆宴席。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","当地人见到参孙，派了三十个人作陪。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","参孙对客人们说∶“我给你们说个谜语吧，你们要是能在这七天的婚宴期间猜出来，我给你们每人一件细麻布衣服和一套礼服； ");
INSERT INTO cmn2006_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","如果猜不中，你们每人就得给我一件细麻布衣服和一套礼服。” 那些人说∶“你把谜语说出来让我们听听。” ");
INSERT INTO cmn2006_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","参孙说∶ “吃的出自吃者， 甜的出自强者。” 一连三天，他们都猜不出来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","到了第四天，他们对参孙的妻子说∶“你去诓哄你的丈夫，把谜底探出来告诉我们，不然，我们就要放火烧你父亲的全家，连你也一起烧死！难道你们请我们到这里来，是要我们破财吗？” ");
INSERT INTO cmn2006_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","于是，参孙的妻子就伏在他身上啼哭，说∶“你给我的同胞出谜语，却不把谜底告诉我！可见你是恨我，不是爱我！”参孙说∶“我连自己的父母都没告诉，怎么能告诉你呢？” ");
INSERT INTO cmn2006_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","婚宴期间，她一直缠着他哭闹。到了第七天，参孙经不住妻子的纠缠唠叨，把谜底告诉了她。她又把谜底告诉了她的族人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","第七天太阳还没有落山，城里的人去见参孙，说∶“有什么比蜜更甜？有什么比狮子更强？” 参孙说∶“如果不用我的小母牛耕地，你们绝对猜不出谜底来！” ");
INSERT INTO cmn2006_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","主的灵以巨能降临在参孙身上，他到亚实基伦那里杀死了三十个人，把他们的衣服扒下来，拿回来交给了那些猜中谜语的人。参孙一怒之下回了父亲的家， ");
INSERT INTO cmn2006_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","他的妻子便嫁给了他的伴郎—他曾是他的知己好友。 ");
INSERT INTO cmn2006_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","过了些日子，正是割麦子的季节，参孙牵着一只山羊羔去看望妻子。参孙要进妻子的卧房，但他的岳父不准他进去， ");
INSERT INTO cmn2006_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","说∶“我想你一定非常恨她，就把她嫁给了你的伴郎。她的妹妹不是比她更漂亮么，你可以娶来代替她。” ");
INSERT INTO cmn2006_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","参孙说∶“这回我可要加害非利士人了；这不算罪过。” ");
INSERT INTO cmn2006_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","参孙去捉了三百只狐狸，把它们的尾巴一对一对地捆在一起，又把火把拴在两条尾巴中间， ");
INSERT INTO cmn2006_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","然后，点着火把，把狐狸放进非利士人的田里。就这样，他把割好的和还没收割的庄稼都烧掉了，连葡萄园和橄榄园也烧掉了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","非利士人问∶“这是谁干的？”有人说∶“这是参孙干的。他是亭拿人的女婿。他干这事是因为他的岳父把他的妻子嫁给了他的伴郎。”非利士人拥进他岳父家里，放火烧死了他的妻子和他的岳父。 ");
INSERT INTO cmn2006_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","参孙对他们说∶“你们既然这样做，我发誓，不报此仇绝不罢休！” ");
INSERT INTO cmn2006_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","他大肆屠杀非利士人，许多人死在他的手下。然后，他来到以坦，住在一个岩洞里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","非利士人来到犹大扎营，攻打利希城。 ");
INSERT INTO cmn2006_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","犹大人问∶“你们为什么来攻打我们？” 非利士人说∶“我们来捉参孙，我们要以牙还牙！” ");
INSERT INTO cmn2006_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","于是，三千名犹大人来到以坦的岩洞里，他们对参孙说∶“难道你不知道我们受非利士人的辖治吗？你这样干叫我们怎么办？” 参孙说∶“他们怎样对待我，我也要怎样回报他们！” ");
INSERT INTO cmn2006_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","他们说∶“我们到这里来，是要把你绑上交给非利士人。” 参孙说∶“你们得向我发誓，你们自己不下手害我。” ");
INSERT INTO cmn2006_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","他们说∶“我们决不杀你，我们只是把你绑起来交给他们。”说完，他们用两根新绳子把参孙绑了起来，带出了岩洞。 ");
INSERT INTO cmn2006_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","参孙被带到利希，非利士人都跑来看他，高兴得大喊大叫。这时，主的灵以巨能降临在参孙身上，捆绑他手臂的绑绳如同经火烧一般，一节一节从他手臂上脱落下来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","他看见一块还没干的驴腮骨，伸手拿了起来，用它打死了一千人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","参孙说∶ “我用一根驴腮骨使他们尸首成堆； 我用一根驴腮骨击杀了一千人。” ");
INSERT INTO cmn2006_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","说完，他把驴腮骨扔了出去。那个地方因此叫做拉末利希。 ");
INSERT INTO cmn2006_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","他口渴难忍，向主呼求，说∶“主啊，你使你的仆人大获全胜，现在，难道要他因口渴而死、落在那些不受割礼的人手里吗？” ");
INSERT INTO cmn2006_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","于是，上帝使利希的洼地裂开，泉水涌了出来。参孙喝足了泉水，精神振作起来，身体也复原了。因此，这个水泉叫做隐哈歌利，至今仍在利希。 ");
INSERT INTO cmn2006_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","在非利士人统治期间，参孙作了二十年以色列士师。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","有一天，参孙到迦萨去，在那里遇见了一个妓女，就跟她睡觉。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","有人报告迦萨人，说∶“参孙到这里来了！”加萨人包围了那个地方，彻夜悄无声息地埋伏在城门口，打算等天一亮就动手杀死参孙。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","参孙睡到半夜就起来了，他抓住城门和两根门柱，把它们连同门栓一起从城墙上拉了下来，然后，把这些东西扛上肩，一直扛到希伯伦前面的山顶上。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","后来，参孙在梭烈谷爱上一个女人，名叫大利拉。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","非利士的首领们来找大利拉，对她说∶“你想办法哄骗他，探清楚为什么他的力气那么大；我们怎样才能制伏他，绑住他，使他就范。如果你能探出来，我们每人给你一千一百块银子。” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","于是，大利拉对参孙说∶“求你告诉我，你为什么力气这么大？怎样才能绑住你，使你就范呢？” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","参孙答道∶“要是他们用七根还没干的新绞索绑住我，我就跟平常人一样软弱无力了。” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","非利士首领们把七根还没干的新绞索交给大利拉，她就用这些绳子把参孙绑了起来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","她早已让人预先藏在内室里等着。她喊∶“参孙哪，非利士人捉你来了！”参孙猛力一挣，那绞索就象麻线碰到了火，一下子就断了。他们还是不知道参孙的力气是从哪里来的。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","大利拉对参孙说∶“你愚弄我，向我撒谎！现在求你告诉我，怎样才能把你绑住？” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","参孙说∶“要是他们用从来没使过的新绳子捆绑我，我就跟平常人一样无力了。” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","于是，大利拉拿新绳子捆绑他，然后喊∶“参孙哪，非利士人捉你来了！”事先已有人埋伏在内室里等候着。参孙又挣断手臂上的绳子，如同挣断一根细线一样。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","大利拉对参孙说∶“你还是在愚弄我，欺骗我！告诉我怎样才能绑住你？” 参孙说∶“要是你把我头上的七条发绺编进织布机里，再把织布机用橛子钉牢，我就象平常人一样无力了。” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","参孙睡觉时，大利拉把他头上的七绺发绺编进织布机，再用橛子钉牢织布机，她又喊∶“参孙哪，非利士人捉你来了！”参孙醒了，一下子把橛子、织布机和机上的梭子都拔了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","大利拉对参孙说∶“你根本不信任我，还说爱我！你骗了我三次了，一直不肯告诉我你为什么有那么大的力气。” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","就这样，大利拉天天问他，纠缠他，逼着他回答；他被她缠得烦透了， ");
INSERT INTO cmn2006_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","终于把秘密全盘告诉了她。参孙说∶“我从来没有剃过头发，因为我在出生以前就被上帝选中作拿细耳人。如果我的头发被剪掉了，我就会失去力量，跟平常人一样软弱无力。” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","大利拉知道参孙已经把全部秘密告诉了她，于是，她派人去告诉非利士的首领们，说∶“来吧！这次他把秘密都告诉我了！”非利士的首领们带着银子来了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","大利拉哄参孙枕着她的大腿睡着了以后，就叫人剪掉参孙头上的七条发绺。然后，她开始折磨他，因为他已经失去了力量。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","她喊∶“参孙哪，非利士人捉你来了！”参孙醒了，心想∶“我只要象从前一样挣一下就能脱身。”他不知道主已经离开他了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","非利士人抓住他，把他的两只眼睛挖了出来，将他解往迦萨，用铜链子锁住他，让他在监狱里推磨。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","然而，他的头发被剃掉之后，又渐渐长出来了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","非利士的首领们聚在一起庆祝，向他们的神明大衮献大祭。他们说∶“我们的神明把仇敌参孙交在我们手里了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","非利士的百姓们看见参孙，就赞美他们的神，说∶“我们的神明把那毁了我们的地、杀了我们许多人的仇敌交在我们手里了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","他们兴高彩烈，说∶“叫参孙来，让他给我们耍把戏看！”他们把参孙从监狱里带了出来，叫他在众人面前耍把戏。当他们让参孙站到两根柱子中间的时候， ");
INSERT INTO cmn2006_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","参孙对牵着他的手的小僮说∶“求你让我扶着庙堂的柱子，我要在上面靠一靠。” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","当时，大衮庙里挤满了男男女女，非利士的众首领也都在场，屋顶上还有大约三千名男女在观看参孙耍把戏。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","参孙向主祷告∶“至高的主啊，求你眷念我，求你最后一次赐予我力量；上帝啊，我要一举报非利士人剜目之仇！” ");
INSERT INTO cmn2006_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","参孙紧紧抵住支撑庙堂中间的那两根柱子，一手抵住一根， ");
INSERT INTO cmn2006_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","大吼一声∶“让我与非利士人同归于尽吧！”他用尽全部力量向外推，大衮庙倒塌了，非利士的首领们和庙内众人与参孙一起，全被压死在里面。就这样，参孙死时所杀的非利士人比他一生所杀的还要多。 ");
INSERT INTO cmn2006_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","参孙的兄弟和他的家人取回他的尸体，葬在琐拉和以实陶之间他父亲玛挪亚的墓地里。参孙作了二十年以色列士师。 ");
INSERT INTO cmn2006_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","一个名叫米迦的人住在以法莲山地。 ");
INSERT INTO cmn2006_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","他对母亲说∶“有人偷了你一千一百块银子，我听见你诅咒那小偷。其实，那银子是我拿的，现在就在我这儿，我把它们还给你。” 他母亲说∶“儿啊，愿主赐福给你！” ");
INSERT INTO cmn2006_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","米迦把银子还给了母亲。他母亲说∶“我替我儿把这些银子全部献给主，好铸造一个神像；我把它们依旧还给你。” ");
INSERT INTO cmn2006_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","他母亲拿了200块银子交给银匠，铸成一个神像。米迦把神像安放在家里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","米迦有一个神堂，他又造了一个以弗得和一些家族神像，指定他的一个儿子充当祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","当时，以色列没有国王，人们各行其是。 ");
INSERT INTO cmn2006_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","有一个年轻的利未人寄居在犹大的伯利恒城。 ");
INSERT INTO cmn2006_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","他离开那里，想找别的地方住。他来到以法莲山地，途中经过米迦的家。 ");
INSERT INTO cmn2006_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","米迦问他∶“你从哪儿来？” 他答道∶“我是利未人，从犹大的伯利恒来，我想找个地方居住。” ");
INSERT INTO cmn2006_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","米迦说；“你就住在我们这儿吧！做我的祭司，为我掌管神堂。我供给你衣食，每年还给你十块银子。” ");
INSERT INTO cmn2006_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","利未人同意了，住进了他的家。米迦待他如同自己的儿子一样。 ");
INSERT INTO cmn2006_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","米迦指派他担当祭司，他就住在了米迦的家里。 ");
INSERT INTO cmn2006_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","米迦说；“我知道主一定会赐福给我，因为我有利未人作祭司了。” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","那时，以色列没有国王。在以色列众支派中但支派还没有得到土地，他们还在寻找可以居住的地方。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","但人从全族中选出五名勇士，派他们离开琐拉和以实陶去探察土地，吩咐他们∶“你们出去探察一下。” 他们进入以法莲山地，来到米迦的家，就在那里借宿。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","在米迦家里，他们听出那年轻的利未人的口音，就去问他∶“是谁带你到这儿来的？你在这儿做什么？” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","他回答他们说米迦是如此这般安排的，聘他作他的祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","他们又对他说∶“请你求问上帝，我们此行的目的能不能成功？” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","祭司答道∶“你们放心地去吧，主会眷顾你们的使命的。” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","于是，这五个人离开了。他们来到拉亿城，发现那里的居民生活安宁，习俗与西顿人一样；这些人生活平静，无忧无虑，没有行事邪恶的人，也没有暴虐的统治者。他们离西顿人很远，跟任何人都没有往来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","这五个人回到琐拉和以实陶，他们的族人问他们∶“你们有什么发现？” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","他们答道∶“来吧，我们去攻打拉亿。我们已经探察过了，那里确实是个好地方。不要在这里无所事事地呆着，赶快去占领那块土地吧！ ");
INSERT INTO cmn2006_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","你们到了那里，就会发现那里的居民毫无戒备；那是一片广阔的土地，物产丰富，应有尽有，上帝已经把它交在你们手中了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","六百名全副武装的但人从琐拉和以实陶出发， ");
INSERT INTO cmn2006_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","前往犹大的基列耶琳扎营，因此，那个地方至今仍叫做但营，位于基列耶琳西面。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","他们从那里向以法莲山地进发，来到米迦的家。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","那五个侦察过拉亿的人对同伴说∶“你们知道吗？这儿有一个以弗得、一些家族偶像和一尊用银子铸成的神像。好好想一想你们该怎么办吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","于是，他们离开原路，来到米迦的家。他们走进那年轻的利未人房里，向他问好。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","六百名全副武装的但人在大门口站着。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","那五个人走了进去，拿走了以弗得、家族偶像和那尊银铸的神像。祭司和那六百名武装的士兵一同站在大门口。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","当那些人到米迦的屋里搬偶像、以弗得、家族神像和那尊银铸的神像时，祭司问他们∶“你们要干什么？” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","他们答道∶“捂住嘴，别作声！和我们一起走吧，做我们的祭司和神庙的主持人吧！做一个以色列支派的祭司难道不比做一个家族的祭司更好吗？” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","祭司很高兴，就带着以弗得、家族偶像和其它偶像跟但人一起走了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","他们返回原路，继续赶路，儿童、牲畜和家产在队伍的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","他们离开米迦家很远了，米迦才召集邻居出来追赶。他们追上了但人， ");
INSERT INTO cmn2006_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","喊住他们；但人转过身来，问米迦∶“你召集人来要干什么？” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","米迦说∶“你们夺走了我造的神像，带走了我的祭司，我什么都没有了，你们还问我要干什么！” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","但人说∶“你别再说了，不然，这些性情暴躁的人会攻击你，你和你的家人就全都没命了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","但人继续走他们的路；米迦见他们的势力比自己大得多，只好转身回家。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","但人带着米迦的神像和祭司来到拉亿，打破了当地人平静安宁的生活。但人屠杀他们，又放火烧了城。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","拉亿离西顿很远，他们又没有与亚扪人结盟，所以，没有人来援救他们。拉亿城位于伯利合附近的谷中，但人重新筑了城，在那里居住下来， ");
INSERT INTO cmn2006_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","他们用以色列之子—他们的祖先但的名字把城命名为但城，拉亿则是那座城原先的名字。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","但人把偶像安置好，由约拿单担任祭司，约拿单是革舜的儿子，摩西的孙子。在但人被掳以前，约拿单的子孙一直担任但人的祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","就这样，当上帝的圣幕停留在示罗的期间，但人一直供奉着米迦造的神像。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","以色列还没有王的那段时期，有一个利未人寄居在以法莲山地的偏远地区。他在犹大的伯利恒娶了一个妾。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","他的妾与他吵嘴，一气之下回到伯利恒的娘家住了四个月。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","后来，她的丈夫动身去找她，想劝她回来。他带了一个仆人和两匹驴上路了。他到了岳父的家里，他的岳父一见就热情地欢迎他， ");
INSERT INTO cmn2006_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","挽留他住下来。他在那里住了三天，大家一起吃喝住宿。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","第四天早上，他们一早起来，准备动身，他的岳父说∶“先吃点东西吧！有了力气才好赶路。” ");
INSERT INTO cmn2006_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","于是，两人坐下吃喝起来。他岳父说∶“请接受我的心意再住一宿吧，好好散散心。” ");
INSERT INTO cmn2006_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","那人起身要走，他的岳父又劝他留下，于是他又住了一夜。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","第 五天早上，他一早起来准备动身，他的岳父说∶“先吃点东西吧！”他俩又坐下来吃喝，一直到太阳偏西。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","那人带着妾和仆人又要走，他岳父说∶“你看！太阳偏西了，再住一晚吧！天就要黑了，不如在这里畅畅快快地住一宿，明天一早启程回家。” ");
INSERT INTO cmn2006_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","但那人不愿再留下来，带着他的妾和仆人以及两匹驮满东西的驴动身上路了。 他来到耶布斯（即耶路撒冷）附近的一个地方。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","这时，天几乎完全黑了，他的仆人对他说∶“我们就到耶布斯城住一夜吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","他不同意，说∶“我们不能在不是以色列人居住的城镇里过夜，我们到基比亚去吧， ");
INSERT INTO cmn2006_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","我们再往前走，赶到基比亚或者拉玛过夜。” ");
INSERT INTO cmn2006_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","他们继续赶路；当他们来到便雅悯境内的基比亚城时，天完全黑了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","于是，他们停了下来，进了基比亚城，打算在那里过夜。他们在广场上坐下来，但是没有人邀请他们到家里过夜。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","这时，有一个老人从田里干活回来，路过那里。他是以法莲山地的人，正寄居在基比亚（当地的居民都是便雅悯人）。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","他看见广场上有过路人在歇息，就上前问∶“你们从哪儿来？要到哪儿去？” ");
INSERT INTO cmn2006_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","那利未人答道∶“我们刚从犹大的伯利恒来，要到以法莲山地那边去。我原是以法莲山地的人，到犹大的伯利恒去，现在正要回家，可是没有地方投宿， ");
INSERT INTO cmn2006_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","我们自己有喂驴的草料，也有我和我的妾以及我的仆人吃的面包和酒，什么也不缺。” ");
INSERT INTO cmn2006_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","那老人说∶“请到我家来吧！我会照顾你们一切的，不要在广场上过夜了。” ");
INSERT INTO cmn2006_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","他把他们领到家里，替他们喂上驴，又让他们洗脚吃饭。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","正当他们轻松自在的时候，城中的一些恶棍围住了房子，连连砸门，对老人—也是房主说∶“把到你家来的那个男人交出来！我们要跟他性交！” ");
INSERT INTO cmn2006_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","老人到门外对他们说∶“朋友们，不能这样，不能干这种下流勾当！这人既然已经进了我的家门，就不能对他做这种丧尽天良的丑事。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","我有个女儿，还是个处女，这人的妾也在这里。我把她们交给你们，任凭你们随意处置吧，只是不可对这人做这种丧尽天良的丑事。” ");
INSERT INTO cmn2006_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","可是他们根本不睬。那个利未人只好把他的妾推出门外交给他们。他们强奸她，整夜不停地污辱她，直到天快亮才放她走。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","天快亮的时候，这女人刚回到她丈夫的门前就一头栽倒在地上，俯卧在那里直到天亮。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","早晨，她的丈夫起来准备赶路，刚一开门，发现他的妾躺在房门前，双手抓着门槛。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","他说∶“起来，我们走吧！”但是没有回音—她已经死了。 他把她的尸体放在驴背上，起身回家。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","回到家以后，他拿了一把刀，把他的妾的尸身切成十二块，分送到以色列境内各地。 ");
INSERT INTO cmn2006_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","看到这情景的人都说∶“自从以色列人离开埃及以来，从来没有发生过这一类的事！这女人死得太惨了。一定要仔细考虑一下，商量应当怎么办。” ");
INSERT INTO cmn2006_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","全体以色列人—从但到别是巴，包括基列，都不约而同地聚集在米斯巴。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","以色列各支派的首领都出席了这一上帝的子民的聚会。步兵有四十万人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","便雅悯人得悉以色列人已经到了米斯巴。 以色列人问∶“告诉我们，这件邪恶的事是怎样发生的？” ");
INSERT INTO cmn2006_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","那个利未人，也就是被害女子的丈夫，答道∶“我和我的妾到便雅悯境内的基比亚过夜； ");
INSERT INTO cmn2006_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","那天晚上，基比亚人包围了我的房子，想要杀死我；后来，他们又把我的妾强奸致死。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","我把她的尸身切成一块一块的，分送给以色列境内各地，好让人们知道这些人在以色列人中间犯下了如此邪恶和丧尽天良的罪行。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","你们今天在场的都是以色列人，现在，拿出你们的见解来吧！” ");
INSERT INTO cmn2006_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","所有的人都一齐站起来，说∶“今天，无论是住帐篷的还是住房子的都不要回家。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","我们现在就要对基比亚采取行动。我们要拈阄决定去攻打基比亚人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","在以色列各支派中，我们要每百人选十人、每千人选百人、每万人选千人供应军粮，其余的人都去讨伐基比亚人，惩罚他们在以色列人中干的这种丧尽天良的丑行。” ");
INSERT INTO cmn2006_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","全体以色列人同仇敌忾，集结起来攻打基比亚城。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","以色列各支派派使者传谕全体便雅悯人，说∶“你们犯了十恶不赦的大罪！ ");
INSERT INTO cmn2006_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","赶快把基比亚那伙歹徒交出来！我们要处死他们，好从以色列中翦除邪恶！” 可是便雅悯人不仅不听从他们以色列同胞的话， ");
INSERT INTO cmn2006_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","反而从各地聚集到基比亚城，准备同以色列人作战。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","当天，便雅悯人从各城召集了二万六千名兵士，此外，基比亚人也点出七百名训练有素的兵士。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","全军拥有七百名擅用左手的兵士，他们能甩石伤人，毫发不差。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","而便雅悯支派以外的以色列人则征集了四十万人，都是能征惯战的兵士。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","以色列人到伯特利求问上帝∶“我们哪一支派应该先去攻打便雅悯人呢？” 主说∶“犹大支派先去。” ");
INSERT INTO cmn2006_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","第二天早上，以色列人出发，在基比亚城的对面扎营。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","以色列人在基比亚城下摆开阵势，向便雅悯人挑战。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","便雅悯人出城应战。那天，便雅悯人杀死了两万两千名以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","23","以色列人来到主的面前整日哭号，他们求问主∶“我们要不要再去攻打我们的同胞便雅悯人？”主说∶“去攻打他们。” 以色列人恢复了勇气，又在前一天交战的地方摆下阵势， ");
INSERT INTO cmn2006_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","攻打便雅悯人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","便雅悯人出城应战，又杀死了一万八千余名训练有素的以色列士兵。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","这一次，以色列全军一起来到伯特利，坐在主的面前哭号，整整一天不吃不喝。他们向主献上了烧化祭和平安祭。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","27","当时，上帝的约柜在那里， ");
INSERT INTO cmn2006_vpl VALUES ("JG20_28","008_20_28","JDG","20","28","28","非尼哈担当祭司，侍立在约柜前；非尼哈是以利亚撒的儿子，亚伦的孙子。以色列人求问主∶“我们应该再去攻打便雅悯人呢，还是就此休战？” 主说∶“去吧，明天我要把他们交在你们的手中。” ");
INSERT INTO cmn2006_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","这一次，以色列人在基比亚城周围布下埋伏。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","第三天，以色列人又向便雅悯人挑战。他们象以前一样在基比亚城下摆开阵势。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","便雅悯人出城应战，被以色列人诱离了城池。他们像以前一样，在通往伯特利和基比亚大路上的空旷地带杀死了大约三十名以色列人， ");
INSERT INTO cmn2006_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","自以为可以象以前一样击败以色列人。 但以色列人早已商议好，他们佯装败退，把便雅悯人诱离城池，引到了大路上。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","以色列人都退到巴力他玛，重整队伍；这时，埋伏在基比亚周围的伏兵突然冲出， ");
INSERT INTO cmn2006_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","一万名以色列精兵直扑基比亚城，战斗极其惨烈。便雅悯人还不知道大祸已经临头。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","那一天，主把便雅悯人交在以色列人手中，二万五千一百名训练有素的便雅悯兵士被消灭。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","便雅悯人这才意识到自己已经失败了。 以色列人从便雅悯人面前撤退，而将破城的任务委于设在基比亚城周围的伏兵。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","伏兵冲进基比亚城后，迅即展开，用剑杀光了全城所有的人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","以色列人事先与伏兵约定∶伏兵得手后举烟为号， ");
INSERT INTO cmn2006_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","以色列人即回身接战。 便雅悯人向以色列人发起攻击后，杀死了大约三十名以色列人。他们自鸣得意∶“我们又象以前一样把他们彻底打垮了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","这时，烟柱从基比亚城上空升起，这是伏兵得手的信号。便雅悯人回头看时，全城已是烟气冲天。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","以色列人转身冲杀；便雅悯人知道大势已去，乱作一团。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","便雅悯人转身拼命向旷野逃跑，想摆脱以色列人；但以色列人紧追不舍，闯进城里的伏兵也出来夹攻， ");
INSERT INTO cmn2006_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","他们包围了便雅悯人，向他们进逼，不给他们喘息的时机，在远至基比亚以东的一个地方将他们彻底击溃， ");
INSERT INTO cmn2006_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","一万八千名勇猛的便雅悯兵士被杀。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","其余的便雅悯人转向旷野的临门岩逃去，又有五千人在路上被杀。以色列人继续追击剩下的人，一直追到基顿，又杀死二千人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","那一天，共有二万五千名便雅悯人被杀，他们都是能征惯战的勇士。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","只有六百名男子逃到旷野的临门岩，在那里躲了四个月。 ");
INSERT INTO cmn2006_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","以色列人又转回去攻打其余的便雅悯人，他们杀光了各座城里所有的人和牲畜，又放火烧毁了所有的城。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","以色列人在米斯巴曾起誓说∶“今后我们绝不把女儿嫁给便雅悯人。” ");
INSERT INTO cmn2006_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","以色列人再次来到伯特利，整日坐在上帝的面前，悲痛地放声大哭， ");
INSERT INTO cmn2006_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","说∶“主啊，以色列的上帝，为什么在以色列中会发生这种事？现在，以色列要少掉一个支派了！” ");
INSERT INTO cmn2006_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","第二天，以色列人一早起来，在那里筑了一座祭坛，献上了烧化祭和平安祭。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","他们又问∶“在米斯巴集会时，以色列各支派中都有哪些人没有到主的面前集合？”他们曾发下重誓∶凡是没去米斯巴向主求告的人，都必须处死。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","以色列人为他们的便雅悯同胞痛悔，说∶“如今，以色列缺了一个支派了！ ");
INSERT INTO cmn2006_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","既然我们以主的名义发过誓，不把我们的女儿嫁给便雅悯人；那么我们怎样才能为剩下的那些便雅悯人找到妻子呢？” ");
INSERT INTO cmn2006_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","他们查问以色列各支派中哪些人没到米斯巴来参加聚会，结果查出住在基列的雅比人一个也没有到。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","因为点名的时候，没有一个基列雅比人在场。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","于是，会众派出一万二千名兵士，命令他们∶“你们到基列雅比去，把那里的人不分老幼妇孺统统杀光！ ");
INSERT INTO cmn2006_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","你们把那里的男人和已婚妇女统统杀掉，只把那些处女留下来。”兵士们照办了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","他们找到了400名年轻的处女，把她们带到迦南的示罗营地。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","然后，全体会众派人去见那些在临门岩的便雅悯人，同他们讲和。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","便雅悯人回来后，以色列人把那些免于一死的基列雅比女子配给他们为妻，可是还不够。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","会众为便雅悯人难过，因为主使以色列缺了一个支派，不完整了。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","会众的长老们说∶“便雅悯的女人都被杀光了，我们该怎样为那些剩下的人找妻子呢？ ");
INSERT INTO cmn2006_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","这些便雅悯人的宗嗣不能断绝，免得以色列缺少一个支派， ");
INSERT INTO cmn2006_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","可是我们又不能把自己的女儿嫁给他们。”原来以色列人曾发过誓，诅咒了把女儿嫁给便雅悯人的人。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","20","于是，以色列人吩咐便雅悯人说∶“瞧！在示罗有一年一度的赞美主的节日，那地方在伯特利以北、利波拿以南；位于伯特利和示剑之间大路的东边。你们到那儿的葡萄园里躲起来， ");
INSERT INTO cmn2006_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","看见示罗女子在年会中出来跳舞时，就从葡萄园中冲出来，每人抢一个作妻子，带回便雅悯地去。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","她们的父兄如果来与我们争论，我们会对他们说∶‘请看在我们的情面上恩待他们吧！他们不是从战场上把她们掳来做妻子的，你们也没有自愿把女儿嫁给他们，因此，不算你们违背誓言，你们没有罪。’” ");
INSERT INTO cmn2006_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","便雅悯人照计而行。他们每人从跳舞的女孩子中各抢一个，带回自己的家乡。他们重建了城镇，居住下来。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","以色列人也都各归自己的支派，各自返回自己的领地。 ");
INSERT INTO cmn2006_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","当时，以色列没有国王，人人都自行其是。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","在士师时代，犹大遭遇了一场饥荒。一个名叫以利米勒的人带着他的妻子和两个儿子，离开了伯利恒，迁往摩押暂住。他的妻子名叫拿俄米，一个儿子叫玛伦，另一个叫基连。他们是犹大伯利恒的以法他人。他们到了摩押，在那里住了下来。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","后来，拿俄米的丈夫以利米勒死了，丢下了拿俄米和她的两个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","两个儿子后来都娶了摩押女子为妻，一个叫俄珥巴，另一个叫路得。他们在摩押住了大约十年。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","后来，玛伦和基连也相继去世。只剩下拿俄米孓然一身，没有丈夫也没有儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","拿俄米在摩押听说主在犹大赐粮食救助他的子民，就准备和她的两个儿媳离开摩押。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","于是，他们离开了住过的地方，动身上了返回犹大的大路。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","拿俄米对两个儿媳说∶“你们都回自己的娘家去吧！愿主象你们善待我和你们已故的丈夫一样善待你们。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","愿主保佑你们再找到丈夫，成立一个美满的家。”拿俄米吻了儿媳们，她们都痛哭起来。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","儿媳们说∶“可是我们想跟你一起回你的家乡去。” ");
INSERT INTO cmn2006_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","拿俄米说∶“不，孩子们，回你们自己的家乡去吧！为什么要和我一起走呢？我再也没有儿子可以做你们的丈夫了。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","回去吧，孩子们！我太老了，不能再嫁人了，就算我能再结婚，就算我今夜就怀胎生子也没有用。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","难道要你们一直等着他们长大成人吗？难道你们应该忍受长期独居的痛苦吗？不！绝不可以！孩子们，我现在的境遇比你们还要苦得多；主确实已经抛弃我了！” ");
INSERT INTO cmn2006_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","三个女人又抱头痛哭。俄珥巴吻别了拿俄米离去了，但是路得坚持和婆婆一起留下来。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","拿俄米说∶“瞧，你嫂子已经回她自己的家族和她信仰的神那里去了，你也回去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","路得说∶“请别强迫我离开你，让我跟你在一起吧！你到哪里，我也到哪里；你在哪里住，我也在哪里住；你的同胞就是我的同胞，你的上帝就是我的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","你死在哪里，我也死在哪里；那里就是我的葬身之地！我发誓，只有死才能把我们分开！如果我违背了誓言，愿主惩罚我。” ");
INSERT INTO cmn2006_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","拿俄米见路得执意要和她在一起，就不再劝她了。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","拿俄米和路得终于来到了伯利恒城。她们进了城，全城的人都非常惊讶，女人们说∶“这不是拿俄米吗？” ");
INSERT INTO cmn2006_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","拿俄米对大家说∶“请不要叫我拿俄米吧，全能的上帝使我的生活这样凄惨，还是叫我玛拉更好。 ");
INSERT INTO cmn2006_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","当年我离开这里时应有尽有，如今主使我两手空空地回来！主亲自惩罚了我，全能的上帝加给了我这么多的灾难，你们为什么还要叫我‘拿俄米’呢？” ");
INSERT INTO cmn2006_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","就这样，拿俄米和儿媳－摩押女子路得从摩押山地回到了家乡。她们回到伯利恒的时候，正是开始收割大麦的季节。 ");
INSERT INTO cmn2006_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","拿俄米的夫家有一个近亲，名叫波阿斯，他是以利米勒家族中一个有地位的人。 ");
INSERT INTO cmn2006_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","一天，路得对拿俄米说∶“我想到田里去，也许能碰到一个善良的人，能让我在他的田里拾落下的庄稼。” 拿俄米说∶“好吧，孩子，你去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","路得来到田间，打算跟在割大麦的工人们后面拾落下的麦穗。这块田恰巧是以利米勒的族人波阿斯的田。 ");
INSERT INTO cmn2006_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","不久，波阿斯从伯利恒城来到田里。他问候工人们∶“主与你们同在！” 工人们答道∶“愿主赐福给你！” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","然后，波阿斯问当监工的仆人∶“那个年轻女子是谁家的呀？” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","仆人答道∶“她就是跟拿俄米一起从摩押回来的那个摩押女子。 ");
INSERT INTO cmn2006_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","她今天一清早就来了，请求我能否让她跟在收麦子的工人们的后面拾麦穗。她从清早一直站到现在等候着，简直就是住在了这儿，把城里的家都丢下了。” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","波阿斯对路得说∶“听我说，孩子，就在我的田里拾麦穗吧，不必再去别处了，你就呆在这儿，跟我的女工们在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","她们去哪块地收割你就去哪儿。我会去吩咐那些年轻的男工，不许他们骚扰你。你要是渴了，就到我的工人们灌好的水壶去倒水喝好了。” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","路得向波阿斯深深鞠躬，说∶“您竟然还会注意到我，真让我吃惊！我是个外乡人，可您却对我这么好！” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","波阿斯答道∶“我早就听说过你在丈夫死后尽心服侍婆婆的事。你离别了自己的父母和家乡，陪伴着婆婆到这陌生的地方来。 ");
INSERT INTO cmn2006_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","愿主为你的这一切孝行赏赐你，你一定会得到主－以色列的上帝的重重赐福，你所投靠的主会象鸟儿把它的幼雏放在翅膀底下一样保佑你的。” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","路得说∶“先生，你以善待我。虽然我还比不上您的一个婢女，可是您却说了这么多感人的话来安慰我。” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","吃午饭的时候，波阿斯招呼路得说∶“到这儿来，尝尝我们的面包。蘸着醋吃吧！” 于是，路得和工人们一起坐了下来。波阿斯给了她一些烤熟的干粮。路得吃得饱饱的，还有剩余。 ");
INSERT INTO cmn2006_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","吃完饭，路得又起身去拾麦穗。 波阿斯吩咐他的仆人们说∶“她就是到麦垛里去拾麦穗也不要阻拦她。 ");
INSERT INTO cmn2006_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","你们在田里多丢下一些整个的麦穗，让她拾起来容易些。记住，不许欺吓她！” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","就这样，路得继续在田里拾麦穗，一直拾到天黑。她把拾来的麦穗打了出来，差不多有22升。 ");
INSERT INTO cmn2006_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","她把打好的麦子背回城里给婆婆看，又拿出吃午饭时留下来的干粮给婆婆吃。 ");
INSERT INTO cmn2006_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","拿俄米问她∶“你今天去哪儿了？在哪儿拾的麦穗？愿上帝赐福给那格外关照你的人！”路得把事情的经过都告诉了婆婆，说∶“我今天跟着干活的那个人叫波阿斯。” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","拿俄米对儿媳说∶“愿主赐福给他；主无论对活着的人还是已经故去的死者都是始终怀着仁爱之情的。”拿俄米又告诉她∶“波阿斯是我们的至亲，是我们的保护人之一。” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","路得又说∶“他还告诉我∶‘直到全部庄稼收割完之前，你就一直和我的女工们在一起吧！’” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","拿俄米说∶“孩子，这样很好。你跟他的女工们在一起，就不必到别的田里受人欺负了。” ");
INSERT INTO cmn2006_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","在整个收割大麦和小麦期间，路得一直跟波阿斯的女工们在一起。同时，路得继续跟婆婆住在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","一天，拿俄米对路得说∶“孩子，我得为你找个好归宿。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","波阿斯，就是你一直跟他的使女在一起的那个人，是我们的至亲。今天夜里，他要到打谷场上簸（大）麦子。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","你去沐浴梳妆，抹上香膏，穿上最好的衣服，然后到打谷场去，但不要让波阿斯在吃喝完毕躺下休息之前认出你来。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","你要记住他睡觉的地方，等他睡着了，你就掀开他脚上的被子，躺在那里。他会告诉你该怎样做的。” ");
INSERT INTO cmn2006_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","路得答道∶“婆婆，你怎样吩咐，我就怎样做。” ");
INSERT INTO cmn2006_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","于是，路得按照婆婆的吩咐来到打谷场上。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","波阿斯吃喝完毕，心情愉快，到麦垛旁躺下睡了。路得悄悄地走过去，掀开被子，躺在他的脚边。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","到了半夜，波阿斯忽然醒了，他翻了个身，惊奇地发现脚边躺着一个女人。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","波阿斯问∶“你是谁？” 路得答道∶“我是你的婢女路得。请用你的衣角遮盖我，因为你是我的保护人。” ");
INSERT INTO cmn2006_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","波阿斯说∶“孩子，愿主赐福给你！你现在的善举比你以往所做的更令人钦敬！那些或穷或富的年轻人，容貌俊美，你都不跟从，而是来到我这里。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","孩子，别怕，无论你要求什么我都答应你。城里的人都知道你是个贤慧的女子。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","不错，我确实是你的保护人之一，但是还有一个人比我跟你的血缘关系更近。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","今天你就留在这里吧，明早，我们看他愿意不愿意救赎你。如果他愿意，那很好，就让他来帮助你；如果他不愿意，我指着活生生的上帝发誓，我一定尽我的义务。你就在这里躺到天明吧！” ");
INSERT INTO cmn2006_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","路得在那里一直躺到拂晓。黎明之前人影朦胧的时候，路得就起来了，波阿斯自言自语说∶“不能让任何人知道她来过打谷场。” ");
INSERT INTO cmn2006_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","又对她说∶“你脱下外衣，把它撑开。” 路得撑开外衣，波阿斯倒进大约二十公斤大麦，又帮她扛在肩上。随后，波阿斯就回城去了。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","路得见了婆婆，拿俄米问她∶“怎么样了，孩子？”路得把波阿斯所做的一切都告诉了婆婆。 ");
INSERT INTO cmn2006_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","又说∶“他还说∶‘你不可以空着手回去见你的婆婆。’所以又给了我这么多大麦。” ");
INSERT INTO cmn2006_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","拿俄米说∶“孩子，我们就坐下来等着消息吧，波阿斯今天就会把事情安排妥当的。” ");
INSERT INTO cmn2006_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","波阿斯来到城门口公众集会的地方，坐在那里。一会儿，波阿斯所说的另一个至亲走过来，波阿斯喊他，说∶“先生，请到这里来坐一下。”那人走过来坐下。 ");
INSERT INTO cmn2006_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","波阿斯又请了城里的十位长老一起坐下。 ");
INSERT INTO cmn2006_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","波阿斯对那位至亲说∶“拿俄米从摩押回来了，她准备卖掉我们族人以利米勒的那块地， ");
INSERT INTO cmn2006_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","我想和你谈谈这件事，看你是不是想当着本地的长老和在座的人的面买下那块地；如果你打算买，就由你买下；如果你不打算买，也请告诉我。因为你在亲族中排在第一位，然后才是我。” 那位至亲说∶“我愿意买这块地。” ");
INSERT INTO cmn2006_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","波阿斯说∶“如果你向拿俄米买那块地，你也要娶死者的遗孀摩押女子路得为妻，作为交易的一部分，好把这块地保留在已故人的名下。” ");
INSERT INTO cmn2006_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","那位至亲说∶“如果这样的话我就不买了，我不能因为赎买这块地而危及自己的产业。这块地可以由你来买。” ");
INSERT INTO cmn2006_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","那时，以色列人做交易或赎买土地，都以脱鞋交给对方为证，这在当时的以色列是取得公众认可的程序。 ");
INSERT INTO cmn2006_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","于是，那位至亲脱下鞋，对波阿斯说∶“由你来买吧！” ");
INSERT INTO cmn2006_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","波阿斯对长老们和所有在场的人说∶“今天，你们都是证人，我从拿俄米手中买下属于以利米勒和他的两个儿子基连、玛伦的全部财产。同时， ");
INSERT INTO cmn2006_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","我也娶玛伦的遗孀摩押女子路得为妻，把这些产业仍然保留在已故人的名下，好让他的姓氏不至在他的本族中和他的家乡断绝。今天，你们都是见证人。” ");
INSERT INTO cmn2006_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","长老们和当时在城门口附近的公众集会场所的人都说∶“我们愿意作证。愿主使这女子进入你的家，使你成为以法他的大族，扬名伯利恒，就象当年拉结和利亚使以色列的家族繁荣一样。 ");
INSERT INTO cmn2006_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","愿主藉这年轻女子赐给你的后裔所创的家业就象塔玛和犹大的后裔法勒斯所创的家业一样昌盛。” ");
INSERT INTO cmn2006_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","波阿斯娶了路得。主使她怀孕，生了一个儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","城里的妇女们对拿俄米说∶“赞美主！他赐给你了这个孩子，使你有了依靠。愿他在以色列族中发扬光大他的姓氏。 ");
INSERT INTO cmn2006_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","他是你晚年的安慰和倚靠。他的母亲是你的儿媳，她爱你，为你生了这孩子，她比七个儿子还要好。” ");
INSERT INTO cmn2006_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","拿俄米把孩子抱在怀里，作了孩子的养母。 ");
INSERT INTO cmn2006_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","邻居的妇女给孩子取名叫俄备得。她们说∶“拿俄米又有孩子啦！”俄备得是耶西的父亲；耶西就是大卫王的父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","以下是法勒斯的世系家谱∶法勒斯生希斯仑； ");
INSERT INTO cmn2006_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","希斯仑生兰；兰生亚米拿达； ");
INSERT INTO cmn2006_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","亚米拿达生拿顺；拿顺生撒门； ");
INSERT INTO cmn2006_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","撒门生波阿斯；波阿斯生俄备得； ");
INSERT INTO cmn2006_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","俄备得生耶西；耶西生大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","在以法莲山区的拉玛城有一个名叫以利加拿的以法莲人，他是苏弗的元孙、托户的曾孙、以利户的孙子、耶罗罕的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","他有两个妻子，一个叫哈拿，另一个叫比尼拿。比尼拿有儿有女，哈拿没有。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","以利加拿每年都从拉玛到示罗去敬拜全能的主，献上祭品。以利的两个儿子－何弗尼和非尼哈在那里做主的祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","每逢献祭的日子，以利加拿都要把祭肉分给妻子比尼拿和她生的儿女各一份。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","但他给哈拿的却是双份，因为他爱哈拿；尽管主阻止哈拿生育。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","由于主没有让哈拿生育，她的对头比尼拿就不断地找岔子气她。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","这种情形持续了好多年。每逢哈拿到主的居所来的时候，她的对头比尼拿就气得她吃不下饭，光掉眼泪。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","她的丈夫以利加拿对她说∶“哈拿，你何必这样伤心哭泣，不吃东西呢？有我难道不比有十个儿子还强吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","有一次，他们在示拿吃喝完毕以后，哈拿站了起来。当时，祭司以利正坐在圣所门柱旁边的一把椅子上。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","满心愁苦的哈拿哀哀痛哭，向主祈祷。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","她向主许愿，说∶“全能的主啊，求你垂顾你的婢女的痛苦，求你眷念我，不要忘记我，你的仆人！如果你赐给我一个儿子，我愿把他终身献给你，他将永远不剃头发。” ");
INSERT INTO cmn2006_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","哈拿不停地向主祷告；以利注目看她的嘴唇。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","哈拿在心中默祷，只见嘴唇动，却不出声音。以利以为她喝醉了， ");
INSERT INTO cmn2006_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","就对她说∶“你还醉得不够吗？别再喝了！” ");
INSERT INTO cmn2006_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","哈拿答道∶“不，先生，淡酒烈酒我都没有喝；我是个深深陷入痛苦的女人，我正在向主倾吐我的苦情。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","请别拿我当不正经的女人看待，我这样一直祷告，是因为我实在太苦恼、太痛苦了！” ");
INSERT INTO cmn2006_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","以利答道∶“好好地回去吧，愿以色列的上帝把你所祈求的赐给你。” ");
INSERT INTO cmn2006_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","哈拿答道∶“愿你的仆人得到你的恩宠。”然后，她起身去吃了些东西，不再满面愁容了。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","第二天一早，他们起来敬拜了主，然后就动身回了拉玛。 以利加拿跟妻子哈拿同房；主顾念哈拿， ");
INSERT INTO cmn2006_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","使她怀了孕。哈拿怀孕日期满足，生了一个儿子。她给他起名叫撒母耳，说∶“因为他是我从主那里求来的。” ");
INSERT INTO cmn2006_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","当以利加拿又带全家去示罗向主献年祭和还愿时， ");
INSERT INTO cmn2006_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","哈拿没有去。她对丈夫说∶“等孩子断了奶我再把他呈献给主吧！他将永远留在那里。” ");
INSERT INTO cmn2006_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","以利加拿说∶“随你的意吧！就留在这里等儿子断奶好了，但愿主能肯定他的话。”于是，她就留在家里哺育孩子，直到断了奶。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","孩子断奶以后，哈拿带着幼小的孩子到主在示罗的居处去，同时还带去了一头三岁的公牛、22升面粉和一皮袋酒。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","他们宰了公牛，领着孩子来见以利。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","哈拿对他说∶“先生，我向你发誓，我就是从前站在你旁边向主祈祷的那个女人。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","我向主祈求这个孩子，他就把我所祈求的赐给了我。 ");
INSERT INTO cmn2006_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","所以，我现在来把他献给主；他要终生属于主。”于是她敬拜主，并把孩子留在了那里。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","哈拿祷告说∶ “我的心因主而充满喜乐， 我的角因主而得以高举， 我向仇敌夸耀， 我为你的救恩而欢欣。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","主是唯一的圣者，你无可比拟； 没有磐石能跟我们的上帝相比。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","不要喋喋不休地高谈阔论，也不要口吐狂言， 因为主是洞悉一切的上帝， 人的行为由他衡量。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","勇士的弓被折断， 素来衰弱的人反而充满力量； ");
INSERT INTO cmn2006_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","一向富足的人如今为佣求食， 曾经挨饿的人如今却发了福； 不育的女人生了七个孩子， 多子的母亲却无依无靠，孤苦零仃。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","主能使人死，也能使人活； 能使人沉沦阴间，也能使人起死回生。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","主能使人贫穷，也能使人富贵； 能使人卑微，也能使人平步青云。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","他从尘土里抬举贫寒的人， 从灰堆里提拔穷困的人； 他使他们与王子同座，位列上宾； 因为大地的根基是属于主的； 是他在上面建立了世界。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","主护卫他圣徒的脚步， 而邪恶的人必消失在黑暗中； 人仅仅依靠自己的力量是不能取胜的。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","反对主的人必定一败涂地， 主要从天上用雷轰他们； 他要审判全世界。 他把力量赐给他所立的王， 他必高举受膏者的角。” ");
INSERT INTO cmn2006_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","祈祷以后，哈拿动身回拉玛去了，孩子则留在祭司以利的手下侍奉主。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","以利的儿子都是品行不端的人。他们不尊重主。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","当时，他们是这样对待民众的∶每逢有人献祭，煮祭肉的时候，他们的仆人就带着三齿叉来， ");
INSERT INTO cmn2006_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","往煮肉的罐里、或釜里、或锅里一插，插上来的肉就归他们所有；他们对所有到示罗来的以色列人都是这样。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","甚至在烧献脂肪之前，他们的仆人就跑来对献祭的人说∶“把肉给祭司，他要去烤；不要煮过的肉，只要生的。” ");
INSERT INTO cmn2006_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","如果那人回答∶“得先烧献脂肪，然后你再随意拿吧！”那仆人就会说∶“不，现在就得给！如果不给，我就要抢了！” ");
INSERT INTO cmn2006_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","在主的眼里，这两个年轻人的罪是非常严重的，因为他们藐视主的祭物。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","那时，撒母耳还是个孩子，穿着麻纱的以弗得圣服侍奉主。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","他母亲每年为他做一件小袍子，在跟丈夫来献年祭的时候带给他。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","以利祝福以利加拿和他的妻子，说∶“愿主藉着这个女人再赐给你们子女，让他们代替她从主那里求来又献给主的这一个儿子。”朝拜完毕，他们就回家去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","主眷顾哈拿，她又生了三个儿子和两个女儿。在这期间，小撒母耳在主的面前渐渐长大。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","以利很老了，他听说了两个儿子对待以色列人的行为，又听说他们跟在会幕门口伺候的女人睡觉， ");
INSERT INTO cmn2006_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","就对他们说∶“你们为什么要做这种事？我听见人们都在议论你们做的这些坏事。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","我儿啊，不要再做这类事了！民众对你们议论纷纷，这可不是件好事情。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","人得罪了人，或许上帝会为他调停；但他如果得罪了主，谁能为他求情呢？”然而，他的儿子们不听他的告诫，因为主想要把他们置于死地。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","小撒母耳渐渐长大，主和周围的人都喜爱他。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","有神人来见以利，对他说∶“主是这样说的∶‘你的祖先在埃及做法老的奴隶时，难道我没有向他们显现吗？ ");
INSERT INTO cmn2006_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","我从以色列众支派中拣选了你们的祖先做我的祭司，让他们在我的祭坛上烧香献祭，在我的面前穿以弗得，又把以色列人献的火祭都赐给他们。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","为什么你们藐视我规定的献给我的居所的祭物？为什么你看重你的儿子甚于敬重我，竟用我的以色列子民献给我的祭物中的最好部分去养肥你们自己？’ ");
INSERT INTO cmn2006_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","“因此，主－以色列的上帝宣布∶‘我曾应许你和你祖先的宗族将永远侍立在我的跟前。但现在，我－主宣布∶这一切全都作废！我会看重敬重我的人，也会轻视藐视我的人。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","时候就要到了！我要使你家族里的人个个短命夭亡，再没有一个老年人， ");
INSERT INTO cmn2006_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","在以色列人蒙福的时候，你的家族却要在我的居所里败落，永远不会再有人活到老年。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","我没有从我的祭坛前除掉的人，只不过留下来让你心中忧伤，哭瞎双眼。你的后代都将命丧刀下。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","你的两个儿子何弗尼和非尼哈的遭遇就是明证∶他们将在同一天死去。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","我要为自己再立一个忠心的祭司，他将按照我的心意行事。我要使他的家族兴盛，他将永远侍立在我的受膏者面前。 ");
INSERT INTO cmn2006_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","那时，你家族中零落的人都会去向他乞求一块银子或一块饼，恳求说∶求你在祭司里给我安排个活儿吧，好让我能有口饭吃。’” ");
INSERT INTO cmn2006_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","小撒母耳在以利的教导下侍奉主。那一时期，主的话很少，也不常有默示。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","一天晚上，老眼昏花的以利在自己的地方睡觉， ");
INSERT INTO cmn2006_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","撒母耳睡在安放上帝约柜的圣幕里。这时，上帝跟前的灯还没有熄灭； ");
INSERT INTO cmn2006_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","主召唤撒母耳。撒母耳答道∶“我在这儿！” ");
INSERT INTO cmn2006_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","他跑到以利那里，说∶“你喊我吗？我在这儿！”以利说∶“我没喊你，回去睡吧！”撒母耳就回去躺下了。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","主又呼唤∶“撒母耳！”撒母耳又起来去见以利，说∶“你喊我吗？我在这儿！”以利答道∶“我的儿，我没有叫你。回去睡吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","那时，撒母耳还不认识主，因为主还没有向他说过话。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","主第三次召唤撒母耳。撒母耳再起来，到以利那里，说∶“你又叫我了，我在这儿。”以利这才明白是主在呼唤这孩子。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","他告诉撒母耳∶“你仍去睡吧！如果这声音再叫你，你就说∶‘主啊，请说吧！你的仆人在听着！’”撒母耳又回去躺下了。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","主来了，站在那里，象前几次一样呼唤∶“撒母耳！撒母耳！”撒母耳答道∶“请说吧，你的仆人在听着。” ");
INSERT INTO cmn2006_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","主对撒母耳说∶“不久，我要在以色列人中做一件事情，让听到的人都如同焦雷震耳。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","那时，我要把对以利家族的一切指控－自始至终的一切－都应验在以利身上。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","我告诉过他，我要审判他的家族，因为他知道他的儿子们藐视上帝，却没有阻止他们。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","为此我对以利家族起誓∶‘以利家族的罪不得用祭物和祭牲赎去。’” ");
INSERT INTO cmn2006_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","撒母耳睡到天亮，起来开了主的屋门，他不敢把这异象告诉以利。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","以利叫他∶“撒母耳，我的孩子。” 撒母耳答道∶“我在这儿。” ");
INSERT INTO cmn2006_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","以利问∶“他对你说了什么？不要瞒我。如果你对我隐瞒一句，愿主重重地处罚你！” ");
INSERT INTO cmn2006_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","于是，撒母耳把一切都毫不隐瞒地告诉了以利。 以利说∶“他是主，愿他按照自己的意志办吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","撒母耳渐渐长大成人；主跟他同在，使他说的每一句话都不落空。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","从但到别是巴的所有以色列人都承认撒母耳是主所立的先知，真实可信。 ");
INSERT INTO cmn2006_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","主继续在示罗显现，给撒母耳默示。撒母耳再把主的话传给全体以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","以色列人出战非利士人。以色列人在以便以谢安营；非利士人在亚弗安营。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","非利士人向以色列人列阵挑战。两军交战，以色列人败绩，几乎有四千人横尸疆场。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","败兵退回营地，以色列的长老们说∶“主怎么会让我们今天败在非利士人的面前？我们去示罗把主的约柜抬来吧，让它与我们同在，把我们从仇敌的手里拯救出来。” ");
INSERT INTO cmn2006_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","于是他们派人到示罗去，把设座于两个基路伯之间的全能的主的约柜抬了回来。以利的两个儿子何弗尼和非尼哈也随同上帝的约柜一起来了。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","主的约柜进入营地的时候，全体以色列人都大声欢呼，大地为之震动。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","非利士人听到喊声，都互相问∶“希伯来人营中的喊声是怎么回事？”当他们知道主的约柜已经到了营中， ");
INSERT INTO cmn2006_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","都非常害怕，说∶“神到他们的营里来了！我们遭殃了！过去从来没有过这种事！ ");
INSERT INTO cmn2006_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","我们肯定完了！谁能把我们从这些大能的神手里救出来呢？在旷野里用各种灾难打击埃及人的，就是这些神啊！ ");
INSERT INTO cmn2006_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","非利士人哪，鼓起勇气，拿出大丈夫的气概来！否则你们就得臣服希伯来人，就象他们过去听命于你们一样。拿出大丈夫的气概去拚杀吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","非利士人发动进攻，以色列人被打垮了，纷纷逃回各自的家乡。伤亡惨重，有三万多名以色列步兵被杀。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","上帝的约柜被掳走，以利的两个儿子何弗尼和非尼哈也都死了。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","一个便雅悯人当天从战场逃回示罗，衣着破烂、头上蒙满灰尘。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","他进城的时候，以利正坐在道旁的椅子上观望，心里为上帝的约柜担忧。那人把战败的消息带进城，顿时全城大哗。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","以利听到喧闹的声音，问∶“什么事这么喧嚷？” 那人急忙来到以利跟前。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","当时，以利已经九十八岁了，两眼呆滞，什么也看不见。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","那人告诉以利∶“我今天刚从战场上逃回来。” 以利问他∶“情况怎么样，孩子？” ");
INSERT INTO cmn2006_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","那人说∶“以色列人被非利士人打垮了，我们的军队损失惨重。你的儿子何弗尼和非尼哈都死了，上帝的约柜也被抢走了！” ");
INSERT INTO cmn2006_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","那人刚一提到约柜，以利就从城门旁他的座位上仰面倒了下去。他年纪大了，身体又胖，一下子就跌断了脖子，死了。以利治理以色列共四十年。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","以利的儿媳、非尼哈的妻子正怀着孕，快到产期了。她听说上帝的约柜被抢走了，她的公公和丈夫也都死了，就突然阵痛发作，生下孩子，却没有能熬过分娩的剧痛。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","她临死的时候，在旁边照顾他的女人们对他说∶“别绝望，你生了一个儿子。”可是她理也不理。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","她给孩子起名叫以迦博，说∶“荣耀离开以色列了！”她是指上帝的约柜被抢走了，她的公公和丈夫也都死了。 ");
INSERT INTO cmn2006_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","她说∶“荣耀已经离开了以色列，因为上帝的约柜已经被抢走了。” ");
INSERT INTO cmn2006_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","非利士人抢走了上帝的约柜，把它从便以谢运到亚实突城， ");
INSERT INTO cmn2006_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","抬进大衮庙，安放在大衮神像旁。 ");
INSERT INTO cmn2006_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","第二天一早，亚实突人发现大衮神像脸朝地倒在主的约柜前面。他们把它抬起来，放回原处。 ");
INSERT INTO cmn2006_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","次日清早起来，又看见大衮神像倒在主的约柜前，脸伏在地上，并且头和两手都断开了，撂在门槛上，只剩下神像残体。 ");
INSERT INTO cmn2006_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","这就是为什么至今大衮神的祭司和所有到亚实突去大衮神庙朝拜的人都不踏大衮庙的门槛。 ");
INSERT INTO cmn2006_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","主的手重重地压在亚实突和周围地区人民的身上，他惩罚他们，用毒疮折磨他们。 ");
INSERT INTO cmn2006_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","亚实突人见到这种情形，就说∶“不能让约柜再留在我们这里，因为以色列的上帝在惩罚我们和我们的大衮神了。” ");
INSERT INTO cmn2006_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","他们把非利士的首领都请了来，问他们∶“我们该拿以色列上帝的约柜怎么办？” 首领们答道∶“把它运到迦特城去吧！”于是，人们把约柜运到迦特城。 ");
INSERT INTO cmn2006_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","约柜运到迦特城以后，主又惩罚那城，使全城陷入极度恐慌之中。他折磨那里的人，使他们不分老幼都长了毒疮。 ");
INSERT INTO cmn2006_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","人们又把约柜运到以革伦。 约柜刚要进城，以革伦人就都叫起来∶“他们把以色列上帝的约柜运到我们这里来，是要害死我们和我们的家人啊！” ");
INSERT INTO cmn2006_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","他们把非利士人的首领都请了来，对他们说∶“把以色列上帝的约柜送回它原来的地方去吧！别让它要了我们和我们家人的命。” 由于上帝已经在重重地惩罚他们，全城充满死的恐怖， ");
INSERT INTO cmn2006_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","没有死的人也都长了毒疮，全城哭声震天。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","主的约柜在非利士人的土地上停留了七个月。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","非利士人把祭司和占卜者召来，问他们∶“我们该拿主的约柜怎么办？请告诉我们该怎样把它送回原处？” ");
INSERT INTO cmn2006_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","祭司和占卜者答道∶“如果你们要归还以色列上帝的约柜，不可以空手送它回去，而必须向主献上赎罪祭。然后，你们的病就会痊愈，并且知道主为什么一直惩罚你们。” ");
INSERT INTO cmn2006_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","非利士人问∶“我们应该献上什么样的赎罪祭呢？” 他们答道∶“要按照非利士人首领的数目，做五个金毒疮和五个金老鼠，因为你们的首领和你们一样都染上了瘟疫。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","你们一定要做这些毒疮的模型和正在国内肆虐的老鼠的模型，以表示你们对以色列的上帝的敬畏。或许，他会因此不再惩罚你们和你们的神明以及你们的国土。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","为什么要象埃及王和埃及人那样顽固不化呢？等主严厉地惩治了他们，他们不还是得放走以色列人，让他们上路走人吗？ ");
INSERT INTO cmn2006_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","“现在，去准备好一辆新车和两头刚刚生过小牛的、从来没有负过轭的母牛，把母牛套在车上，把小牛赶回牛栏。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","把主的约柜放在车上，旁边放一个箱子，里面放上你们准备献给主作为赎罪祭的金模型。然后，让牛拉着车走。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","你们要注意观察。如果车径直朝本土的伯示麦方向去，那么这灾难就是主加给我们的；如果车不朝那里走，那么，我们就知道主并没有降灾，这灾难只是巧合罢了。” ");
INSERT INTO cmn2006_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","非利士人按照他们说的做了。他们选了两头刚生过牛犊的母牛套在车上，把小牛关在栏里， ");
INSERT INTO cmn2006_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","把主的约柜和装有金老鼠和金毒疮模型的箱子放到车上。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","母牛径直朝伯示麦方向走去，沿着路一边走一边叫，既不偏左也不偏右。非利士人的首领们跟着牛车，一直到伯示麦的边界。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","伯示麦人正在谷里收割麦子，猛然间抬头看见了约柜，都欢喜异常。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","车子走到伯示麦人约书亚的田间，停在一块大石旁。人们把车子劈碎了当作木柴，将两只母牛作为烧化祭献给了主。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","利未人把主的约柜和装金物的箱子从车上搬下来，安放在大石上。那一天，伯示麦人向主献了烧化祭和其他牲祭。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","五个非利士人首领观看了这一切，当天就回以革伦去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","非利士人献给主的五个金毒疮模型，分别作为亚实突、迦萨、亚实基伦、迦特、以革伦的赎罪祭。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","金老鼠的数目则依照五个非利士首领辖下城市的数目，这些城都是设防城，周围有附属的村镇。安放主的约柜的那块大石头，至今还在伯示麦人约书亚的田里，它是这件事的见证。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","主击杀了七十个伯示麦人，因为他们窥视了主的约柜。当地居民为了主对他们的沉重打击哀伤不已。 ");
INSERT INTO cmn2006_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","他们问∶“谁能在主－这神圣的上帝面前侍立呢？我们该把约柜送到谁那里去呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","他们派人去见基列耶琳人，对他们说∶“非利士人已经把约柜送回来了，请来把它接到你们那里去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","于是，基列耶琳人把约柜接了去。他们把约柜放在座落在小山上的亚比拿达家里，并为他的儿子以利亚撒行了归圣礼，让他守护主的约柜。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","主的约柜在基列耶琳停留了长达约二十年之久。 在这段时期内，以色列人一直在哀伤中寻求主。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","撒母耳对全体以色列人说∶“如果你们真心想回到主的身边，那么，你们必须弃绝异族神明和亚斯他录，专心只侍奉主，主会把你们从非利士人的手中解救出来。” ");
INSERT INTO cmn2006_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","于是，以色列人弃绝了巴力诸神和亚斯他录，只侍奉主。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","撒母耳又说∶“把以色列人都召集到米斯巴来，我要在那里为你们向主祷告。” ");
INSERT INTO cmn2006_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","全体以色列人聚集到米斯巴后，他们打来水，浇在主的面前，并在当天禁食，向主认罪，说∶“我们得罪主了。”撒母耳在米斯巴就任以色列士师。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","非利士人听说以色列人在米斯巴聚会，就来攻打他们。以色列人得到消息，心里很害怕。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","他们对撒母耳说∶“请为我们向主－我们的上帝呼求吧，一刻也不要停，他会把我们从非利士人的手里救出来。” ");
INSERT INTO cmn2006_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","撒母耳取来一只吃奶的羊羔，作为全牲烧化祭献给了主。他以以色列的名义向主呼求，主应许了他的祷告。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","就在撒母耳向主献烧化祭的时候，非利士人逼近了，向以色列人挑战。那天，主用霹雳轰击非利士人，使他们乱作一团，不得不从以色列人面前败退。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","以色列人冲出米斯巴追击非利士人，沿路击杀他们，一直追过伯甲。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","撒母耳在米斯巴和善之间立了一块石头，命名叫以便以谢，他说∶“主至今一直在帮助我们。” ");
INSERT INTO cmn2006_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","非利士人就此被制服，再也没有侵犯过以色列人的领土。至撒母耳寿终，主一直跟非利士人作对。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","以色列人收复了从以革伦到迦特之间曾被非利士人夺去的城镇及其周围地区，并跟亚摩利人实现了和平。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","撒母耳终生任以色列的士师。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","他每年都要巡视伯特利、吉甲、米斯巴，在这些地方审理案件。 ");
INSERT INTO cmn2006_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","但每次出巡以后，他都要回到家乡拉玛。在那里，他也为以色列人排解纠纷，还为主建了一座祭坛。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","撒母耳年老了，立他的儿子作以色列的士师。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","他的长子叫约珥，次子叫亚比雅，都在别是巴作士师。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","他们不按父亲的榜样办事，只顾贪图不义之财，索要贿赂，不主持正义。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","于是，以色列的长老们都聚集到拉玛来见撒母耳， ");
INSERT INTO cmn2006_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","对他说∶“你老了，你的儿子又不按你的榜样办事。请为我们立一位王吧，就象其他国家一样，让王来治理我们。” ");
INSERT INTO cmn2006_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","他们刚一提出“让王来治理我们”，撒母耳就很不高兴。他为此向主祷告。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","主说∶“就按民众说的办吧！他们不是厌弃你，而是厌弃我，不要我作他们的王。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","自从我把他们领出埃及以来，他们常常离弃我去侍奉别的神。他们今天对你所做的，正跟他们往常的行为一样。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","你现在可以顺从他们，但是，你要郑重地警告他们，让他们明白将来统治他们的王会怎样对待他们。” ");
INSERT INTO cmn2006_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","撒母耳把主的话转告了要求立王的人民。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","他说∶“统治你们的王将会这样对待你们∶他会带走你们的儿子，让他们在车兵和马兵中服役，在战车前冲锋； ");
INSERT INTO cmn2006_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","他会指派一些人做千夫长和五十夫长，其他人为他种田、收割，制造武器和战车的装备。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","他要让你们的女儿为他制香水，做饭，烤饼； ");
INSERT INTO cmn2006_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","他将拿走你们最好的田地、葡萄园、橄榄园，把它们赐给他的朝臣； ");
INSERT INTO cmn2006_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","他将征收你们收成的粮食和葡萄的十分之一，赐给他的大臣和仆从； ");
INSERT INTO cmn2006_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","他将征用你们的男女奴仆和最好的牛和驴， ");
INSERT INTO cmn2006_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","他将取走你们羊群的十分之一，而你们自己则成为他的奴隶。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","到那时候，你们会呼求，想从你们自己选立的王手中解脱出来，但主不会垂听你们的祷告。” ");
INSERT INTO cmn2006_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","民众不肯听撒母耳的话。他们说∶“不，我们要王来治理我们。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","我们要象其他国家那样，有王治理我们，统率我们出征作战。” ");
INSERT INTO cmn2006_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","撒母耳听了，把这些话告诉了主。 ");
INSERT INTO cmn2006_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","主答道∶“按他们的意思办吧，给他们立一个王。” 于是，撒母耳告诉以色列人∶“你们都各回各的城去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","有一个名叫基士的便雅悯人，他是亚斐亚的元孙、比歌拉的曾孙、洗罗的孙子、亚别的儿子，是便雅悯支派的知名人物。 ");
INSERT INTO cmn2006_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","他有一个儿子，名叫扫罗，是个与众不同的英俊的年轻人，比其他人都高出一头。 ");
INSERT INTO cmn2006_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","扫罗的父亲基士丢了几头驴，他吩咐扫罗∶“你带上一个仆人去找驴吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","他们走遍以法莲山区和沙利沙地区，也没有找到驴。他们继续到沙琳地区找，驴不在那儿；又到便雅悯地区去找，还是找不到。 ");
INSERT INTO cmn2006_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","到了苏弗，扫罗对他的仆人说∶“我们回去吧！否则，恐怕我父亲不再想驴，而要为我们担心了。” ");
INSERT INTO cmn2006_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","仆人却说∶“瞧，这城里有一位极受人尊崇的神人，他说的话没有不应验的。我们到那儿去吧，也许他能告诉我们该怎么办。” ");
INSERT INTO cmn2006_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","扫罗说∶“我们去，能拿什么东西给他呢？我们袋子里的干粮已经吃光了，没有礼物可以送给他。我们还有什么没有？” ");
INSERT INTO cmn2006_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","仆人答道∶“我还有一个小银币可以送他，他会告诉我们该怎么办。” ");
INSERT INTO cmn2006_vpl VALUES ("S19_9","010_9_9","1SA","9","9","11","扫罗说∶“好，那我们就去吧！”于是，他们动身到圣人住的那座城去。他们上了山，正要进城的时候，遇见几个姑娘出来打水。他们就问∶“先见在这儿吗？”（当时，在以色列，先知被称为先见。如果有人要求问上帝，就说∶“我们去见先见吧！”） ");
INSERT INTO cmn2006_vpl VALUES ("S19_12","010_9_12","1SA","9","12","13","姑娘们答道∶“他在这儿，他是在你们之前到的。快去吧！他今天刚到我们城里来，因为今天民众要在丘坛上献祭。民众必须等他来为祭物祝福以后，才可以吃东西。你们现在就去吧，在他上丘坛吃祭物之前，你们一进城就可以找到他，然后，应邀而来的客人就要吃东西了，你们现在去一定可以找到他。” ");
INSERT INTO cmn2006_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","两人继续赶路，快要进城的时候，正碰上撒母耳迎面走来，要到邱坛上去。 ");
INSERT INTO cmn2006_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","在扫罗到这里的前一天，主已经指示撒母耳∶ ");
INSERT INTO cmn2006_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“明天的这个时候，我会差一个人从便雅悯地到你这里来。你要膏他，立他作我的以色列子民的王，他会把我的子民从非利士人的手中解救出来，因为我听见了我的子民的哀告，我要看顾他们。” ");
INSERT INTO cmn2006_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","撒母耳一看见扫罗，主就告诉他∶“这就是我对你说的那个人，他将治理我的子民。” ");
INSERT INTO cmn2006_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","扫罗在城门口碰上撒母耳，问∶“请问，先见住在那里？” ");
INSERT INTO cmn2006_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","撒母耳答道∶“我就是先见。你先到丘坛去吧，今天你跟我一起吃饭；明天早晨，我会回答你心中所有的疑虑，然后送你上路。 ");
INSERT INTO cmn2006_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","别为你三天前丢的驴担心，它们已经找到了。以色列人所渴求的，其实是你和你父亲的家族。” ");
INSERT INTO cmn2006_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","扫罗答道∶“我是便雅悯人，属于以色列最小的支派，我的家族又是其中最微不足道的一支。为什么对我说这些呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","撒母耳把扫罗和他的仆人领进大厅，安排在客席的首位，一共大约有三十位客人。 ");
INSERT INTO cmn2006_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","撒母耳对厨师说∶“把我交给你特别留在一边的那块肉拿来。” ");
INSERT INTO cmn2006_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","厨师把那块腿肉拿来，摆在扫罗面前。撒母耳说∶“这是特意为你留的，吃吧！我邀请客人，就是要在这个场合把这肉给你。”那天，扫罗跟撒母耳一起吃了饭。 ");
INSERT INTO cmn2006_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","从丘坛回到城里后，撒母耳在自己家的屋顶上为扫罗备好了床，扫罗就睡在屋顶上。 ");
INSERT INTO cmn2006_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","天快亮的时候，撒母耳到房顶上叫扫罗∶“收拾好东西，我送你们上路。”扫罗收拾好东西，和撒母耳一起动身上路。 ");
INSERT INTO cmn2006_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","他们到了城边，撒母耳对扫罗说∶“叫你的仆人先走吧！”仆人走后，撒母耳说∶“你在这里停一下，我要把上帝的旨意告诉你。” ");
INSERT INTO cmn2006_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","撒母耳拿出一瓶油，倒在扫罗的头上，亲吻他，对他说∶“主膏立你作他子民的王， ");
INSERT INTO cmn2006_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","你今天离开我以后，会在便雅悯边界上的泄撒、靠近拉结墓的地方遇见两个人。他们会告诉你∶‘你要找的驴已经找到了。你父亲现在想的不是驴，而是担心你，他不断问人∶“我该为儿子怎么办？”’ ");
INSERT INTO cmn2006_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","“你从那里继续往前走，到他泊的大橡树那里，你会遇见三个去伯特利朝拜上帝的人。其中一个人带着三只小山羊，另一个人带着三个面包，还有一个人带着一皮袋酒。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","他们会问侯你，给你两个面包，你要收下来。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","然后，你要到上帝的基比亚去，那里有非利士人的一个要塞。当你走近那城的时候，你会遇见一群从邱坛上下来的先知，他们讲说预言，有人在前面打鼓、吹笛、弹奏竖琴和七弦琴。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","那时，主的灵将在你的身上显现出能力；你将跟他们一起讲说预言，变成一个完全不同的人。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","一旦这些征兆实现以后，你就可以做你想做的任何事。因为上帝将与你同在。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","你要在我之前先到吉甲去，我肯定要到那里去献烧化祭和平安祭，跟你会面，但你要等七天，等我去找你，告诉你应该怎样做。” ");
INSERT INTO cmn2006_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","就在扫罗转身离别撒母耳的这一刻起，上帝赐给他一颗全新的心。当天，撒母耳预言的征兆都实现了。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","当扫罗和他的仆人到达基比亚时，一群先知正好迎上他。上帝的灵在他的身上显现出能力，他也和他们一起讲说预言。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","从前认识他的人看见他跟先知们一起讲说预言，都互相打听∶“基士的儿子怎么啦？扫罗也成了先知了吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","一个当地人说∶“否则谁来做他们的父呢？”于是，流传下一句俗语∶“扫罗也成了先知了吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","扫罗说完预言，登上丘坛。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","扫罗的叔叔问扫罗和他的仆人∶“你们到哪儿去了？” 扫罗答道∶“我们找驴啊！驴找不到，我们就到撒母耳那里去了。” ");
INSERT INTO cmn2006_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","扫罗的叔叔说∶“告诉我，撒母耳对你们说了些什么？” ");
INSERT INTO cmn2006_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","扫罗答道∶“他肯定地告诉我们，驴已经找到了。”却没有告诉叔叔撒母耳说的有关作王的事。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","撒母耳把全体以色列人都召到米斯巴的上帝面前， ");
INSERT INTO cmn2006_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","对他们说∶“主－以色列的上帝是这样说的∶‘我把以色列人领出埃及，把你们从埃及人和欺压你们的国家手里解救出来。’ ");
INSERT INTO cmn2006_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","但你们现在却厌弃救你们脱离苦难的上帝，说∶‘求你立一个王来治理我们。’既然这样，你们就按照支派和宗族站到主的面前来吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","撒母耳把所有的支派都带上来；便雅悯支派被选中了。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","他把便雅悯支派的各宗族依次带上来，玛特利宗族被选中了；最后，基士的儿子扫罗被选中了。 人们到处找扫罗，却找不到他。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","于是，他们求问主，说∶“这人到这儿来了吗？” 主说∶“他来了，就在货堆的后面。” ");
INSERT INTO cmn2006_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","人们跑去把扫罗领了出来；他站在人群中间，比别的人都高出一头。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","撒母耳对全体民众说∶“看见主拣选的这个人了吗？没有一个人能跟他相比。” 民众大声欢呼∶“愿王万岁！” ");
INSERT INTO cmn2006_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","撒母耳向民众讲解了国法，并记录成书，放在主的面前。然后，撒母耳解散了民众，让他们各回家乡。 ");
INSERT INTO cmn2006_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","扫罗也返回基比亚的家，一些被上帝感动的勇士簇拥着他； ");
INSERT INTO cmn2006_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","但也有一些好生是非的人说∶“这人怎么能救我们？”他们瞧不起扫罗，也不向他送礼。扫罗并不理会。 亚扪王拿辖伤害了迦得和吕便支派。拿辖剜了每一个人的右眼。他不许任何人帮助他们。亚扪王拿辖剜了住在约旦河以东地区的每一个以色列人的右眼。但是7000名以色列从亚扪人那里逃到了基列雅比城。 ");
INSERT INTO cmn2006_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","亚扪人拿辖率军围攻基列境内的雅比城。雅比人对拿辖说∶“我们情愿立约，向你称臣。” ");
INSERT INTO cmn2006_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","拿辖却答道∶“要想跟我立约，除非让我把你们所有人的右眼都挖出来！我要羞辱所有的以色列人！” ");
INSERT INTO cmn2006_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","雅比城的长老们说∶“请给我们七天时间，我们派使者到以色列各地去求援；如果没有人来援救我们，我们就向你投降。” ");
INSERT INTO cmn2006_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","使者到了扫罗住的基比亚，向民众说明了这些情况，人们都号啕大哭起来。 ");
INSERT INTO cmn2006_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","这时，扫罗正从田里赶牛回来，他问∶“大家都怎么了？为什么痛哭流涕？” 人们把雅比城使者说的话对他重复了一遍。 ");
INSERT INTO cmn2006_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","扫罗听了这些话，异常愤怒，上帝的灵在他的身上显现出能力； ");
INSERT INTO cmn2006_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","他牵出一对牛，把它们砍成碎块，命令使者将这些碎肉遍示全以色列，宣称∶“谁敢不听从扫罗和撒母耳的命令，他的牛就要象这样被砍成碎块！” 主使民众畏惧；他们不约而同地行动起来。 ");
INSERT INTO cmn2006_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","扫罗在比色整编民众，有三十万以色列人，三万犹大人。 ");
INSERT INTO cmn2006_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","他们告诉雅比城的使者∶“回去告诉雅比人，明天中午以前，你们就能得救。” 使者回去把消息报告给雅比人，他们欣喜异常。 ");
INSERT INTO cmn2006_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","于是，他们对亚扪人说∶“我们明天投降，你们可以随心所欲地处置我们。” ");
INSERT INTO cmn2006_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","第二天，扫罗把他的部队分成三队，在晨更时分突进亚扪人的营地，直杀到中午。侥幸活命的残兵都四散逃走，各自逃命去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","人们对撒母耳说∶“谁说过‘扫罗能做我们的王吗？’这样的话？把他们交给我们，我们要杀掉他们！” ");
INSERT INTO cmn2006_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","扫罗说∶“今天不应该处死人，因为主在今天救了以色列。” ");
INSERT INTO cmn2006_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","撒母耳对民众说∶“来吧，大家都到吉甲去，我们要在那里再次确立王权。” ");
INSERT INTO cmn2006_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","全体民众都来到吉甲，在主的面前立扫罗为王。他们在那里向主献上了平安祭，扫罗和全体以色列人一同举行了盛大庆典。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","撒母耳对全体以色列人说∶“我顺从了你们的请求，为你们立了一个王来治理你们。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","现在，有王做你们的领袖；至于我，我已经年老发白，但我的儿子们还跟你们在一起。我从青年时代直到今天一直是你们的领袖。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","现在，我站在这里，你们可以在主和他的受膏者面前作证指控我。我夺过别人的牛和驴吗？我欺压过谁吗？我收过贿赂而枉法徇私吗？如果我做过这类事，我愿还以公道。” ");
INSERT INTO cmn2006_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","人们答道∶“你没有欺压过我们，也没有从我们任何人手里拿走过东西。” ");
INSERT INTO cmn2006_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","撒母耳说∶“今天，主和他的受膏者作证，你们在我手里找不到任何把柄。”民众答道∶“主是见证。” ");
INSERT INTO cmn2006_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","撒母耳继续对民众说∶“是主拣选了摩西和亚伦，并把你们的祖先领出了埃及。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","现在，你们要站在这儿，我要用主对你们和你们祖先的种种义举来指控你们。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","雅各到了埃及以后，你们的祖先向主求助，主就派摩西和亚伦把你们的祖先领出了埃及，安顿在这地方。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","但他们却忘了主－他们的上帝；于是，他把他们交在夏琐的统帅西西拉、非利士人和摩押王的手里，派这些人去攻打他们。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","他们向主呼求，说∶‘我们离弃了你去侍奉巴力和亚斯他录，我们有罪了，求你把我们从仇敌手里救出来，我们一定侍奉你。’ ");
INSERT INTO cmn2006_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","于是，主派出耶路巴力、巴拉、耶弗他和我－撒母耳，把你们从四周仇敌的手里救出来，让你们过上平安日子。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","“然而，你们看见亚扪人拿辖王来攻击你们，就对我说∶‘我们要一个王来治理我们。’其实主－你们的上帝就是你们的王。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","现在，你们所选立的王就在这里。你们要一个王，看吧，主已经为你们立王了。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","如果你们敬畏主，侍奉他，服从他，不违背他的诫命，你们和你们的王都对他忠诚，他就会拯救你们； ");
INSERT INTO cmn2006_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","如果你们不服从主，不守他的诫命，那么，他就要跟你们敌对，就象对待你们的祖先一样。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","“现在，你们站在那里别动！亲眼看一看主要做的一件大事。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","现在不是收麦子的季节吗？我将求告主，求他降下雷和雨。你们会明白，你们要求立王，在主的眼里是一件多么邪恶的事！” ");
INSERT INTO cmn2006_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","撒母耳向主求告；当天，主就降下了雷和雨。民众对主和撒母耳满怀畏惧， ");
INSERT INTO cmn2006_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","他们对撒母耳说∶“求你为你的仆人们向主－你的上帝祈祷，别让我们死掉。我们要求立王是罪上加罪了。” ");
INSERT INTO cmn2006_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","撒母耳说∶“别怕，虽然你们做了这邪恶的事，但不要背离主，要一心一意地侍奉他。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","不要去追随那些毫无用处的偶像，它们对你们毫无益处，也救不了你们，因为它们本来就一无所能。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","主既然愿意让你们做他的子民，他必然会为他至大的名而不丢弃你们。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","至于我，我决不会不为你们祈祷而得罪主。我会教导你们什么是善良和正义之路。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","你们一定要敬畏主，要专心一意地侍奉他，要记住他为你们做的伟大的事。 ");
INSERT INTO cmn2006_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","但是，如果你们顽固作恶，你们和你们的王都将被毁灭。” ");
INSERT INTO cmn2006_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","扫罗三十岁登基，在位四十二年。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","扫罗从以色列人中选出三千人，二千人留在密抹和伯特利山区由他亲自率领，一千人跟随约拿单驻扎在便雅悯的基比亚，其余的人则遣散回家。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","约拿单攻击非利士人在迦巴的要塞，消息传到非利士人那里。扫罗命人在全国各地吹号，下令说∶“要让所有的希伯来人都听见！” ");
INSERT INTO cmn2006_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","于是，全体以色列人都得到消息∶“扫罗已经向非利士人的要塞发起攻击，以色列人已经成了非利士人的死敌！”人民应召到吉甲跟扫罗会合。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","非利士人集结军队向以色列进攻，有三千辆战车、六千名骑兵，士兵多得象海滩上的砂粒。他们进军伯亚文东面的密抹，在那里扎下营。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","以色列人见形势危急，军队处境艰难，于是纷纷躲进岩洞、丛林、石穴和坑里等隐密处， ");
INSERT INTO cmn2006_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","有些人甚至渡过约旦河，逃到迦得和基列去了。扫罗仍然留在吉甲，身边的人都惊慌不定。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","按照撒母耳规定的时间，扫罗在吉甲等了七天，但撒母耳并没有到。扫罗的部下逐渐散去。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","于是，扫罗下令∶“把烧化祭和平安祭带到我这里来！”扫罗自己献了全烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","扫罗刚刚献完祭，撒母耳就到了。扫罗出去迎接他。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","撒母耳责问他∶“你怎么能这样做？”扫罗答道∶“你没有按约定的时间来，而非利士人正在密抹集结，我的部下已经涣散。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","我想∶‘非利士人很快就会进兵吉甲向我进攻，而我却还没有求得主的垂顾。’所以，我不得不自己献了全烧化祭。” ");
INSERT INTO cmn2006_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","撒母耳说∶“你做了糊涂事了！你没有遵守主－你的上帝给你的命令。如果你遵守，主本会使你的王朝永远统治以色列。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","可是现在，你的王朝不会持久了；主已经找到另一个合他心意的人，指命他作他子民的领袖，因为你没有遵从主的命令。” ");
INSERT INTO cmn2006_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","随后，撒母耳离开了吉甲，前往便雅悯的基比亚。 扫罗查点了他的部下，约有六百人。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","扫罗和他的儿子约拿单统领部下驻扎在便雅悯地区的迦巴；非利士人扎营在米斯巴。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","非利士人分三路出击∶一路往书亚的俄弗拉， ");
INSERT INTO cmn2006_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","一路直奔伯和仑，另一路前往旷野对面俯瞰洗波音谷的边境地区。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","那时，在以色列境内找不到一个铁匠；非利士人说∶“不然，这些希伯来人会制造刀剑枪矛的！” ");
INSERT INTO cmn2006_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","以色列人必须去非利士找人磨锄、犁、斧头、铲。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","磨锄和犁要两块银子，磨叉子、斧头和修刺棒要一块银子。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","因此，上阵那天，除了扫罗和约拿单以外，没有一个人手中有刀矛一类的武器。 ");
INSERT INTO cmn2006_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","非利士人的一路人马已经开到密抹隘口。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","一天，扫罗的儿子约拿单对拿他兵器的年轻人说∶“来，我们到非利士人的防地那边去。”但他没有告诉他的父亲。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","扫罗当时正扎营在基比亚郊外米矶伦的一棵大石榴树下，身边有大约六百人， ");
INSERT INTO cmn2006_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","其中有亚希突的儿子亚希亚，他穿着以弗得。亚希突是以迦博的兄弟，他是非尼哈的儿子，以利的孙子。以利曾在示罗做主的祭司。没有人知道约拿单离开了营地。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","要到非利士人的防地必须经过一座隘口。隘口两侧各有一座陡崖，一座叫播薛，另一座叫西尼； ");
INSERT INTO cmn2006_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","北边的那座朝向密抹，南边的那座朝向迦巴。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","约拿单对拿兵器的年轻人说∶“来，我们到那些不受割礼的人的营地去，或许主会替我们动手。无论人多人少，什么都阻挡不了主实行拯救。” ");
INSERT INTO cmn2006_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","拿兵器的兵答道∶“按你的计划行事吧！你只管去做，我一定全力支持你。” ");
INSERT INTO cmn2006_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","约拿单说∶“这样吧，我们径直朝非利士人走去，故意让他们看见我们。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","如果他们说∶‘站住！等我们过去！’我们就停在原地，不去惹他们； ");
INSERT INTO cmn2006_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","如果他们说∶‘过来吧！’我们就过去，因为那是主把他们交在我们手里的征兆。” ");
INSERT INTO cmn2006_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","两人故意让非利士人的哨兵看见。非利士人说∶“瞧，希伯来人从他们藏身的洞里爬出来了！” ");
INSERT INTO cmn2006_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","哨卡里的人对约拿单和为他扛兵器的兵喊∶“过来吧！我们要教训教训你们！” 约拿单对拿兵器的兵说∶“跟我过去；主已经把他们交在以色列人的手里了！” ");
INSERT INTO cmn2006_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","约拿单手脚并用，攀上隘口，拿兵器的兵紧跟在他的后面。约拿单击倒非利士人，拿兵器的兵就跟上杀掉他们。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","首次攻击，约拿单和拿兵器的兵就在大约半亩地之内杀死了差不多二十人。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","恐怖笼罩了非利士人全军；无论是驻在营区的部队还是驻在野外的部队，无论是警戒部队还是突击部队，全都一片惊慌。大地在颤抖－这是主降下的恐怖！ ");
INSERT INTO cmn2006_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","在便雅悯的基比亚，扫罗的了望哨发现敌军四散奔逃， ");
INSERT INTO cmn2006_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","扫罗命令部下∶“集合部队，看看谁离开了营地？” 人们集合部队，发现约拿单和拿兵器的兵不在。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","扫罗吩咐亚希亚∶“把上帝的约柜抬来！”（当时约柜在以色列人那里。） ");
INSERT INTO cmn2006_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","正当扫罗向祭司下指示时，非利士营中越来越混乱了，于是扫罗吩咐祭司∶“不必再抬约柜了！” ");
INSERT INTO cmn2006_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","扫罗集合全军出击，发现非利士人已经完全混乱，彼此砍杀。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","那些先前跟非利士人在一起并随军前来的希伯来人都投向扫罗和约拿单手下的以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","躲在以法莲山区的以色列人听说非利士人逃走了，也都出来参战，猛追非利士人。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","就这样，主在那天拯救了以色列人，战事一直延续到伯亚文。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","那天，以色列人极其困乏，因为扫罗曾让人们起誓，说∶“在我向敌人报完仇之前，如果谁在傍晚之前吃东西，谁就要受诅咒！”所以，全军没有一个人敢吃东西。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","军士们进入树林，看见地上有蜂蜜。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","他们看见蜂蜜从树上流下来，却没有一个人敢取来吃，因为大家都害怕所立的誓。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","约拿单没有听见他父亲给民众立下的誓言，他伸出手杖，用杖头插进蜂窝，蘸了一点蜂蜜，放进嘴里。立刻，他的眼前就明亮了。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","一个士兵告诉他∶“你父亲用严厉的誓言约束部队，说∶‘谁今天敢吃东西，谁就要受诅咒！’所以现在战士们都饿得发昏了！” ");
INSERT INTO cmn2006_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","约拿单说∶“我父亲误了大事了！看，我只吃了一点蜂蜜，眼前就明亮了。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","如果战士们吃一点缴获来的东西，战况本来还会好得多，杀死的非利士人本来还会更多！” ");
INSERT INTO cmn2006_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","那天，以色列人打败了非利士人，从密抹一直打到亚雅仑，个个筋疲力尽； ");
INSERT INTO cmn2006_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","他们从战利品中牵出牛羊和牛犊，就地杀了，连血一起吃了下去。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","有人向扫罗报告∶“民众吃了带血的肉，得罪主了！” 扫罗说∶“你们背信了！快滚一块大石头到我这里来吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","扫罗又说∶“你们到民众中间去，告诉他们∶‘你们所有的人都必须把牛牵到我这里来，在这儿宰杀，在这儿吃肉；不可吃带血的肉以致得罪主。’”当天晚上，人们都把牛牵到那里去宰杀。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","扫罗为主建了一座祭坛；这是扫罗第一次为主建坛。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","扫罗说∶“我们要连夜去追非利士人，掳掠他们，一直要追到天亮，把他们杀得一个不剩！” 人们答道∶“按你的意志办吧！” 但祭司说∶“我们先要求问一下主。” ");
INSERT INTO cmn2006_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","于是，扫罗向上帝求问∶“我该不该去追非利士人？你会把他们交在以色列人的手里吗？”可是，上帝那天没有回答。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","扫罗下令∶“所有的军官都到这里集合，查查今天有没有犯罪行为。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","我指着拯救以色列人生命的主发誓，即使我的儿子约拿单有罪，也一定处死他！”但没有一个人作声。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","于是，扫罗对全体以色列人说∶“你们站在那边，我和我的儿子约拿单站在这边。” 人们答道∶“你看怎么好就怎么办吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","扫罗向主－以色列的上帝祷告∶“请把真情告诉我吧！” 结果约拿单和扫罗被抽中，与民众无关。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","扫罗说∶“让我和我儿约拿单拈阄吧！”结果约拿单被抽中了。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","扫罗问约拿单∶“告诉我，你做了什么事？” 约拿单答道∶“我只不过用手杖头沾了一点蜂蜜吃，就得死吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","扫罗说∶“约拿单啊，如果你不死，愿上帝重重地处罚我！” ");
INSERT INTO cmn2006_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","民众对扫罗说∶“约拿单为以色列带来了这样巨大的胜利，难道还要处死他吗？决不能！我们指着活生生的上帝发誓，连他的一根头发也不许碰掉到地上！因为他今天是在上帝的帮助下做这一切的。”就这样，民众救了约拿单，使他免于一死。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","扫罗不再追击非利士人；非利士人也撤回本土。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","扫罗巩固了以色列的王位以后，不断对周围的仇敌用兵；他跟摩押人、亚扪人、以东人、琐巴诸王及非利士人交战，所向无敌。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","他作战勇敢，击败了亚玛力人，把以色列人从掳掠他们的人手里解救了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","扫罗的儿子是约拿单、亦施韦、麦基舒亚；他的长女叫米拉，次女叫米甲。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","他的妻子叫亚希暖，是亚希玛斯的女儿。军队的元帅是他叔叔尼珥的儿子押尼珥。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","扫罗的父亲基士和押尼珥的父亲尼珥都是亚别的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","扫罗一生跟非利士人常有激烈的战争，他一发现能人或勇士，就招来当他身边的亲兵保护他。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","撒母耳对扫罗说∶“主派我来膏立你作他的以色列子民的王，所以，你要听从主的吩咐。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","全能的主是这样说的∶‘我要惩罚亚玛力人。因为以色列人出埃及的时候，亚玛力人曾经拦路袭击他们。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","现在，你们去攻打亚玛力人，彻底毁灭他们的一切。不要放过他们，要把他们的男女老幼和牛羊、骆驼、驴统统杀光。’” ");
INSERT INTO cmn2006_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","于是，扫罗把民众召集到提拉因，共有二十万步兵，另有一万犹大人。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","扫罗率军到了亚玛力城，在山谷中设下埋伏。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","然后，扫罗告诉基尼人∶“离开亚玛力人吧，免得我把你们跟亚玛力人一起毁灭掉，因为当年以色列人离开埃及的时候，你们曾善待过他们。”于是基尼人离开了亚玛力人。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","扫罗向亚玛力人发动攻击，从哈腓拉一直打到埃及东面的书珥， ");
INSERT INTO cmn2006_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","生擒了亚玛力王亚甲，杀光了他手下的人。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","但是，扫罗和他的军队留下了亚甲的性命，也没有杀掉那些上等的牛羊和肥壮的牛犊与羊羔－凡是好东西都留了下来。他们不愿把东西全都毁掉，毁掉的只是那些没用的东西和瘦弱的牲畜。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","主给撒母耳默示，说∶ ");
INSERT INTO cmn2006_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“我后悔立扫罗做王了；他已经背弃了我，不执行我的命令。”撒母耳很忧虑，整夜向主求告。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","第二天早晨，撒母耳起来去见扫罗，人们告诉他∶“扫罗已经到迦密去了，他在那里为自己竖了一座纪念碑，然后转道到吉甲去了。” ");
INSERT INTO cmn2006_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","撒母耳赶上扫罗；扫罗对他说∶“愿主赐福给你！我已经执行了主的命令。” ");
INSERT INTO cmn2006_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","撒母耳问∶“那么，我听见的这牛羊的叫声是怎么回事？” ");
INSERT INTO cmn2006_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","扫罗答道∶“这是兵士们从亚玛力人那里夺来的。他们把最好的牛羊留下来，准备献给主－你的上帝，其余的我们都杀掉了。” ");
INSERT INTO cmn2006_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","撒母耳说∶“住嘴！让我告诉你昨天夜里主是怎样对我说的吧！” 扫罗说∶“请告诉我。” ");
INSERT INTO cmn2006_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","撒母耳说∶“当初连你自己都自认卑微，后来不是成了以色列各支派的领袖了吗？是主膏立你做了以色列的王。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","他派你去执行使命，说∶‘去！把这些邪恶的亚玛力人彻底毁灭！你向他们开战，把他们扫荡一空！’ ");
INSERT INTO cmn2006_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","你为什么不服从主的命令？为什么要掳掠战利品，做主所憎恶的事？” ");
INSERT INTO cmn2006_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","扫罗答道∶“可我确实遵照主的命令做了，执行了主给我的使命。我彻底消灭了亚玛力人，俘虏了亚甲王。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","我的兵士从战利品中保留了最好的牛羊是为了献给上帝，他们想把它们带回吉甲来献给主－你的上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","撒母耳说∶“主喜欢什么？烧化祭和牲祭还是服从他的命令？顺从比祭物更好，服从命令比绵羊的脂油更重要。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","违命跟占卦一样有罪，顽固和随心所欲如同膜拜偶像一样有罪。由于你违背了主的旨意，他不再要你作王了。” ");
INSERT INTO cmn2006_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","扫罗说∶“我有罪了；我违背了主的命令和你的指示。我不敢得罪民众，对他们让了步。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","求你宽恕我的罪，跟我一起回去吧，好让我能敬拜主。” ");
INSERT INTO cmn2006_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","撒母耳说∶“我不能跟你一起回去。你背弃了主的命令，主已经不再承认你是以色列的王！” ");
INSERT INTO cmn2006_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","撒母耳转身要走；扫罗抓住他长袍的衣襟，衣襟撕裂了。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","撒母耳说∶“主今天断绝了以色列国跟你的关系，把它赐给了你的一个同胞－一个比你更好的人。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","主是以色列的荣耀，他言出必行，不会改变主意；他不是没有主见的世人。” ");
INSERT INTO cmn2006_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","扫罗答道∶“我有罪了；可是，求你在民众的长老和以色列人面前维护我的尊严。请跟我一起回去吧！我好去敬拜主－你的上帝。” ");
INSERT INTO cmn2006_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","于是，撒母耳跟扫罗一起回去；扫罗敬拜了主。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","撒母耳说∶“把亚玛力王亚甲带到我这里来！” 亚甲满心高兴地来了，心想∶“这下肯定不会死了！” ");
INSERT INTO cmn2006_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","撒母耳说∶“你的剑曾使许多母亲丧失儿女，所以，你的母亲也要成为她们之中的一个。”撒母耳在吉甲当着主的面处死了亚甲王。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","随后，撒母耳前往拉玛，扫罗则回到家乡基比亚。 ");
INSERT INTO cmn2006_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","撒母耳从那天起直到死，再也没有见过扫罗，但他一直为扫罗悲伤，因为主后悔立扫罗做以色列的王了。 ");
INSERT INTO cmn2006_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","主对撒母耳说∶“既然我已经厌弃扫罗做以色列的王，你还要为扫罗再悲伤吗？你把角里装满油，然后上路；我要派你到伯利恒人耶西那里去，我已经选了他的一个儿子做王。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","撒母耳说∶“我怎么能去呢？扫罗听到消息一定会杀死我的。” 主说∶“你带上一头小母牛去，就说∶‘我是来向主献祭的。’ ");
INSERT INTO cmn2006_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","你请耶西来吃祭肉，我那时会指示你应当怎样做。你要膏立我指示给你的人。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","撒母耳按照主的吩咐行事。他到了伯利恒，城里的长老们诚惶诚恐地来迎接他。他们问∶“你是为平安而来的吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","撒母耳答道∶“是的，我是为平安而来。我是来向主献祭的。你们都要洁净自己，来跟我一起吃祭肉。”他为耶西和他的儿子们行了洁净礼，邀请他们来吃祭肉。 ");
INSERT INTO cmn2006_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","耶西和他的儿子们到了以后，撒母耳见到以利押，心里想∶“主要膏立的人一定正站在他的面前。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","主却对撒母耳说∶“不要看他的外貌和高大的身材，我拣选的不是他。主不象世人那样看待事物，世人只注重外表，而主看重的是内心。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","耶西叫亚比拿达进来，让他从撒母耳面前走过，撒母耳说∶“主也没有选他。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","耶西叫沙玛过来，撒母耳说∶“主也不选这一个。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","耶西把七个儿子一个个都带来给撒母耳看，撒母耳对耶西说∶“他们都不是主拣选的人。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","他问耶西∶“你的儿子都在这儿吗？” 耶西答道∶“还有一个最小的，正在放羊。” 撒母耳说∶“你派人把他叫回来；在他回来之前，我们不能坐下来吃祭肉。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","于是耶西派人把小儿子叫了回来。他满面红光，容貌清秀，身材健美。 主说∶“来膏他吧！他就是我选定的人。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","撒母耳拿出盛油的角，当着众兄弟的面膏了他。从那天起，主的灵在大卫的身上显现出能力。撒母耳起身回拉玛去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","主的灵离开了扫罗；来自主的恶魔的灵开始折磨他。 ");
INSERT INTO cmn2006_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","扫罗的侍从们对他说∶“上帝差遣恶魔的灵来折磨你了。 ");
INSERT INTO cmn2006_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","请陛下下令让臣仆们去找一个能弹竖琴的人来。当上帝遣来的恶魔的灵附在你的身上时，就让这人弹起琴来，这样你会好受些。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","于是，扫罗命令他的臣仆∶“去找一个弹琴能手，把他带到我这里来！” ");
INSERT INTO cmn2006_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","一个仆从答道∶“我见过伯利恒人耶西的一个儿子弹琴弹得很好。他口才好，相貌英俊，还是个英勇的战士，主与他同在。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","于是，扫罗派使者去见耶西，对他说∶“请让你放羊的那个儿子大卫到我这里来。” ");
INSERT INTO cmn2006_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","耶西把饼、一皮袋酒和一只小山羊驮在驴背上，让大卫带着去见扫罗。 ");
INSERT INTO cmn2006_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","大卫就到扫罗那里服侍他。扫罗很喜欢大卫，就让他为自己拿兵器。 ");
INSERT INTO cmn2006_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","扫罗派人传话给耶西∶“我很喜欢大卫，就让他留在这里吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","此后，每当上帝遣来的精灵附在扫罗身上的时候，大卫就拿起他的竖琴来弹，恶魔的灵就离开扫罗，他顿时觉得舒适畅快。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","非利士人集结在犹大的梭哥整军备战，在梭哥和亚西加之间的以弗大悯扎下营寨。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","扫罗率领以色列人在以拉谷扎营，摆开阵势迎战非利士人。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","非利士人和以色列人各占据了一座小山，隔着山谷对峙。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","从非利士人营中出来一个名叫歌利亚的迦特人勇士。他身高超过2.7米， ");
INSERT INTO cmn2006_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","头戴铜盔，身上的铜铠甲差不多有57公斤重， ");
INSERT INTO cmn2006_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","穿着铜护腿甲，背插铜戟， ");
INSERT INTO cmn2006_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","枪杆粗如织布机轴，铁枪头重达七公斤。有人在前面替他拿盾牌。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","歌利亚站下，向以色列人的军队高喊∶“你们出来列阵不是想打仗吗？我就是非利士人！你们不是扫罗的部下吗？挑个人出来跟我见个高低吧！ ");
INSERT INTO cmn2006_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","如果他能跟我格斗，把我杀死，我们就臣服你们；但是，如果我赢了他，把他杀死，你们就得向我们称臣，服侍我们。” ");
INSERT INTO cmn2006_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","这个非利士人又说∶“今天，我向你们以色列军队挑战！派个人出来，让我们打个痛快！” ");
INSERT INTO cmn2006_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","扫罗和全体以色列人听了他的话，又惊又怕。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","大卫是犹大伯利恒城以法他人耶西的儿子。耶西有八个儿子。扫罗作王的时候，耶西已经很老了。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","耶西的大儿子以利押、二儿子亚比拿达、三儿子沙玛都在扫罗的军中服役。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","大卫是最小的一个。三个哥哥都随扫罗出征， ");
INSERT INTO cmn2006_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","只有大卫不时离开扫罗回伯利恒去照看父亲的羊群。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","一连四十天，歌利亚每天早晚都到营门前挑战。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","一天，耶西对儿子大卫说∶“你带上这十公斤烤好的谷子和十个饼，赶到军营里去送给你的哥哥们， ");
INSERT INTO cmn2006_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","再带上这十块乳酪送给他们的长官。看看你的哥哥们好不好，向他们要点信物带回来。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","他们现在正跟着扫罗王和全体以色列人在以拉谷跟非利士人打仗。” ");
INSERT INTO cmn2006_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","第二天一早，大卫把羊群托给别的牧人照看，自己打点好行装，按照耶西的吩咐出发了。他到达军营的时候，正赶上军队列阵，呐喊出战。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","以色列人和非利士人面对面摆好阵势。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","大卫把自己的东西交给军需官保管，自己跑到阵前去看望他的哥哥们。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","正当他跟哥哥们说话的时候，非利士人的迦特勇士歌利亚又象往常一样出阵挑战了，大卫听到了歌利亚骂阵的声音。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","以色列人一看见歌利亚，全都惊慌失措地纷纷躲避， ");
INSERT INTO cmn2006_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","说∶“看见这个天天出阵的人了吗？他又出来向以色列人挑战了！谁要是能杀死这个人，王会重重地赏他，还要把女儿嫁给他为妻，并免除他家在以色列应交的税。” ");
INSERT INTO cmn2006_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","大卫问身边的人∶“如果有人杀掉这非利士人，洗雪以色列的羞辱，会得到什么奖赏？这不受割礼的非利士人是谁，竟敢向活生生的上帝的军队挑战？” ");
INSERT INTO cmn2006_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","人们把说过的话向他重复一遍，告诉他∶“这就是杀死歌利亚的人能得到的奖赏。” ");
INSERT INTO cmn2006_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","大卫的长兄以利押听见大卫跟别人说话，很不高兴，责问他∶“你跑到这儿来干什么？旷野里的那几只羊丢给谁了？我知道你多不听话，也知道你心中的鬼主意。你到这儿来就是为了看打仗的。” ");
INSERT INTO cmn2006_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","大卫说∶“我做错什么了？难道还不许我说话吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","他转身跑到别人那里，又提出同样的问题。别人也给了他同样的回答。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","大卫的话传到扫罗那里，扫罗派人把他找了去。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","大卫对扫罗说∶“别让这个非利士人挫了我们的锐气，你的仆人愿意跟他打上一仗。” ");
INSERT INTO cmn2006_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","扫罗答道∶“你哪有力气去跟这个非利士人见仗；你还只不过是个孩子，而他自幼就是军人！” ");
INSERT INTO cmn2006_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","大卫对扫罗说∶“你的仆人一直在给父亲放羊，有时来了狮子，有时来了熊，它们从羊群里叼走我的羊， ");
INSERT INTO cmn2006_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","我就追赶它，跟它搏斗，从它的嘴里救回我的羊，有时它向我扑来，我就揪住它的胡子，把它打死。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","你的仆人曾经打死过狮子和熊，这个不受割礼的人也会象它们一样，因为他竟然向活生生的上帝的军队挑战！ ");
INSERT INTO cmn2006_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","主曾经把我从狮子和熊的利爪下救出来，他也一定会把我从这个非利士人的手中救出来！” 于是，扫罗对他说∶“那就去吧！愿主与你同在。” ");
INSERT INTO cmn2006_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","扫罗给大卫披上自己的战袍，穿上自己的铠甲，戴上自己的头盔。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","大卫佩上剑，试着走了走，因为他对这些装备还不习惯。他对扫罗说∶“我穿上这些就没法出去了，我对它们还不习惯。”他把这些东西都脱掉了， ");
INSERT INTO cmn2006_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","拿起自己的牧杖，从河里选了五块光滑的石头，放进自己牧羊用的袋子里，手里拿着甩石机，向非利士人迎上去。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","那非利士人也走近大卫，替他拿盾牌的人走在他的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","他打量大卫，见他不过是个孩子，红扑扑的脸，眉清目秀，从心里瞧不起他。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","他对大卫说∶“你怎么拿根杖来见我，难道我是狗吗？”他指着自己的神明诅咒大卫， ");
INSERT INTO cmn2006_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","又说∶“来吧，我要用你的肉喂天上的鸟和地上的兽！” ");
INSERT INTO cmn2006_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","大卫对他说∶“你打我，是用刀、矛、戟；我打你，是奉全能的主－以色列军队的上帝的名；你是在向他宣战！ ");
INSERT INTO cmn2006_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","今天，主将把你交在我的手里，我要把你打翻在地，割下你的头！今天，我要把非利士军队的尸体丢给空中的鸟和地上的兽，让全世界都知道以色列有一位上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","所有今天在场的人都将懂得∶主不用刀枪实行拯救，因为战争的胜负全在于主；他一定会把你们全都交到我们手里。” ");
INSERT INTO cmn2006_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","趁着歌利亚接近大卫预备动手的时候，大卫迅速向阵前跑去迎战歌利亚。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","他伸手从袋子里拿出一块石头，甩了出去，正中歌利亚的前额。石块陷进歌利亚的前额，他仆倒在地上。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","就这样，大卫没有动刀，只用甩石机和一块石头就大获全胜，把歌利亚打倒在地，杀死了他。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","大卫跑上去踏住歌利亚，伸手握住那非利士人佩剑的剑柄，把剑抽了出来，杀死了他，割下了他的头。非利士人看见他们的勇士死了，转身就逃。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","以色列人和犹大人呐喊着冲过来，追杀非利士人，一直追到迦特和以革伦城下。非利士人的尸体布满通向迦特和以革伦的沙拉音大路。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","以色列人追击非利士人收兵回来，洗劫了非利士人的营地。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","大卫把歌利亚的人头带回耶路撒冷，把他的武器留在自己的帐蓬里。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","扫罗观看大卫出战歌利亚的时候，他问元帅押尼珥∶“押尼珥，那个年轻人是谁的儿子？” 押尼珥答道∶“陛下，我向你起誓，我确实不知道。” ");
INSERT INTO cmn2006_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","扫罗下令∶“去查查这个年轻人是谁的儿子！” ");
INSERT INTO cmn2006_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","大卫刚杀死歌利亚归来，押尼珥就把他带到扫罗面前；大卫手里还提着歌利亚的人头。 ");
INSERT INTO cmn2006_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","扫罗问他∶“你是谁的儿子？” 大卫答道∶“我是你的仆人－伯利恒人耶西的儿子。” ");
INSERT INTO cmn2006_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","大卫跟扫罗谈过话以后，约拿单跟大卫成了密友，他爱大卫，如同爱自己的生命。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","从那天起，扫罗就把大卫留在身边，没有让他回家。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","约拿单爱大卫，如同爱自己的生命，他与大卫盟约立誓， ");
INSERT INTO cmn2006_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","又脱下自己穿的战袍，连同自己的盔甲、宝剑、弓和腰带，都赠给了大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","无论扫罗派下什么任务，大卫都能出色地完成。因此，扫罗任命他为全军的统帅。民众和扫罗自己的官员对此都很高兴。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","大卫杀死歌利亚后，军队凯旋归来，以色列所有城镇的妇女都出来迎接扫罗王。她们载歌载舞，弹起七弦琴，敲起铃鼓， ");
INSERT INTO cmn2006_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","边跳边唱∶ “扫罗杀敌千千， 大卫杀敌万万！” ");
INSERT INTO cmn2006_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","扫罗很不高兴，这歌词使他感到恼怒。他想∶“他们给大卫万万，只给我千千，只差没让他作王了！” ");
INSERT INTO cmn2006_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","从那时起，扫罗开始嫉恨大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","第二天，上帝派来的恶魔的灵猛烈地附在扫罗身上。他在屋子里胡言乱语；大卫象往常一样弹着竖琴。扫罗握住一支矛， ");
INSERT INTO cmn2006_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","心想∶“我要把大卫钉在墙上！”他把矛向大卫掷去，两次大卫都躲开了。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","扫罗对大卫心存惧意；因为主离开了扫罗而与大卫同在。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","因此，扫罗把大卫从身边调开，派他做千夫长。大卫领兵征战， ");
INSERT INTO cmn2006_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","无往不利，因为主与他同在。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","扫罗看见大卫事事成功，就更加忌恨他。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","但以色列和犹大的民众都爱戴大卫，因为是他率领他们作战。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","扫罗对大卫说∶“这是我的大女儿米拉。只要你为我奋勇杀敌，为主而战，我就把她嫁给你。”扫罗暗想∶“我不亲手害他，让非利士人收拾他吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","大卫对扫罗说∶“我是什么人？我的家族和世系在以色列算得上什么？我怎敢做王的女婿？” ");
INSERT INTO cmn2006_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","到了米拉该跟大卫成婚的时候，扫罗却把她嫁给了米何拉人亚利列。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","扫罗的另一个女儿米甲爱上了大卫。扫罗听说后很高兴， ");
INSERT INTO cmn2006_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","心想∶“把她嫁给大卫，用她作圈套，大卫就会死在非利士人的手里！”扫罗又对大卫说∶“你还有机会做我的女婿。” ");
INSERT INTO cmn2006_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","扫罗吩咐侍从∶“你们私下里去对大卫说∶‘瞧！王很喜欢你，他的臣属也都爱戴你。去做王的女婿吧！’” ");
INSERT INTO cmn2006_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","这些人按照扫罗的话劝说大卫。大卫却说∶“你们以为做王的女婿是件小事吗？要知道我不过是个默默无闻的穷人罢了。” ");
INSERT INTO cmn2006_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","扫罗的侍从们把大卫的话转告扫罗； ");
INSERT INTO cmn2006_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","扫罗答道∶“告诉大卫∶‘王只要一百个非利士人的包皮，以渲泄他对仇敌的仇恨，别的什么聘礼也不要。’”扫罗其实是要藉非利士人的手杀死大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","侍从把这些话告诉了大卫；大卫很高兴，表示愿意做王的女婿。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","在规定的时间之前，大卫带领部下杀死了两百个非利士人，他割下他们的包皮，全数交给扫罗王，一心要成为王的女婿。 扫罗王不得不把女儿米甲嫁给大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","扫罗见主与大卫同在，又见女儿米甲爱大卫， ");
INSERT INTO cmn2006_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","就更忌恨大卫，一直跟他作对。 ");
INSERT INTO cmn2006_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","非利士人的首领继续与以色列人交战。每逢非利士人来犯，在出战的众将官中，大卫的战绩最为辉煌。大卫的声名大振。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","扫罗吩咐儿子约拿单和侍从们除掉大卫。约拿单跟大卫很要好， ");
INSERT INTO cmn2006_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","就去告诉大卫∶“我父亲扫罗要寻机杀害你。明天早晨你要提防，找个地方躲起来。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","我会跟我的父亲到野外你藏身的地方去；我要跟他谈你的事情，如果有什么情况，我一定通知你。” ");
INSERT INTO cmn2006_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","约拿单在父亲扫罗面前替大卫说好话，说∶“父王，请不要冤屈你的仆人大卫。他从来没有做过对不起你的事，相反，他所做的事都对王大有裨益。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","他曾冒着生命危险杀死了非利士人歌利亚；这是主为以色列赢得的巨大的胜利。你亲眼看到这一切，也曾为之而鼓舞。为什么要冤屈象大卫这样一个无辜的人，毫无缘由地要杀害他呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","扫罗听从了约拿单的话，发誓说∶“我指着活生生的主发誓，决不杀害大卫。” ");
INSERT INTO cmn2006_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","约拿单把大卫叫来，把谈话的内容都告诉了他，又带他去见扫罗。于是，大卫又象从前一样留在扫罗的身边。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","战端又启，大卫出战非利士人。他猛击非利士人，把他们打得大败而逃。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","主差来的恶魔的灵又附在扫罗身上；当时扫罗正坐在屋子里，手中握着矛；大卫弹着琴。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","扫罗又想用矛把大卫钉在墙上；大卫躲开了，矛刺进了墙里。当夜，大卫逃走了。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","扫罗派人到大卫的住所去监视，准备在清晨杀死他。大卫的妻子米甲警告大卫说∶“你今晚不逃，明天一定会被杀死。” ");
INSERT INTO cmn2006_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","米甲让大卫从窗口缒下去逃走了， ");
INSERT INTO cmn2006_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","随后，她把一尊偶像放在床上，头部放上些山羊毛，然后蒙上衣服。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","扫罗派人去捉拿大卫，米甲说∶“他病了。” ");
INSERT INTO cmn2006_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","扫罗派人回来，让他们非见大卫不可，并吩咐他们∶“把他连床一起抬来，我要杀死他！” ");
INSERT INTO cmn2006_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","人们进到屋里，发现床上只是一尊偶像，头部放着一些山羊毛。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","扫罗问米甲∶“你为什么要欺骗我，放我的仇敌逃走？” 米甲答道∶“他说∶‘让我走，不然我就杀死你！’” ");
INSERT INTO cmn2006_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","大卫逃出来以后，到拉玛去见撒母耳，告诉他扫罗对他所做的一切。他和撒母耳到拿约住了下来。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","消息传到扫罗那里∶“大卫在拉玛的拿约。” ");
INSERT INTO cmn2006_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","他又派人去捉拿大卫。然而，当他派去的人看见撒母耳站在那里领着一群先知演说预言的时候，主的灵突然降到他们身上；他们也跟着说起预言来。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","扫罗听说了这件事，又派了更多的人去，结果他们也跟着说预言。扫罗再次派人去，他们还是跟着说预言。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","最后，扫罗亲自到拉玛去，到了西沽的大井。他向人打听∶“撒母耳和大卫在哪儿？” 人们告诉他∶“在拉玛的拿约。” ");
INSERT INTO cmn2006_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","他动身前往拿约。上帝的灵也降在他的身上，他一路走一路说预言，直到拉玛的拿约。 ");
INSERT INTO cmn2006_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","他在撒母耳面前脱掉衣服，也说起预言来，光着身子躺了整整一天一夜。 这就是俗语流传说“扫罗也算先知吗？”的来由。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","大卫从拉玛的约拿逃走，去见约拿单，向他询问∶“我究竟做错了什么事？犯了什么罪？我究竟在哪儿得罪了你父亲，使得他非要我的命不可？” ");
INSERT INTO cmn2006_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","约拿单答道∶“不，你决不会死！我父亲无论做大事小事，都不瞒着我，这件事又何必瞒着我呢？决不会的。” ");
INSERT INTO cmn2006_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","大卫发誓说∶“你父亲很清楚你对我好，他一定暗自想过∶‘不能让约拿单知道这件事，不然他会伤心的。’我指着活生生的主对你发誓，我离死只不过一步之遥。” ");
INSERT INTO cmn2006_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","约拿单对大卫说∶“你打算让我怎么办？我一定为你去做。” ");
INSERT INTO cmn2006_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","大卫说∶“看，明天是新月节，我本该陪王一起吃饭；但我想躲到野外去，直到后天晚上。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","如果你父亲问到我，请告诉他∶‘大卫恳求我准许他赶回伯利恒的老家，因为那里正在为他们整个宗族献年祭。’ ");
INSERT INTO cmn2006_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","如果他说∶‘好吧！’那我就平安无事了；如果他大发脾气，你就知道他是决心要害我了。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","至于你，求你对你的仆人仁慈为怀，因为你曾跟他在主的面前盟誓立约。如果我有罪，你就亲自杀了我好了，何必把我交给你的父亲？” ");
INSERT INTO cmn2006_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","约拿单答道∶“别胡思乱想！我只要稍微觉察我父亲有加害你的意图，会不告诉你吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","大卫又问∶“如果你父亲厉声申斥你，谁能来通知我呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","约拿单说∶“来，我们到野外去吧！”他们一起来到野外。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","约拿单对大卫说∶“让主－以色列的上帝为我们作证。后天的这个时候以前，我一定要探明我父亲的意图！如果我父亲对你并无恶意，我会派人来告诉你，让你心中有数； ");
INSERT INTO cmn2006_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","如果他有心加害你，而我却不告诉你，让你平安离去，愿主重重地惩罚我！愿主与你同在，就象他曾经与我的父亲同在一样。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","在我的有生之年，你要象主一样始终以不变的仁爱待我，使我免遭杀身之祸； ");
INSERT INTO cmn2006_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","在我身后，即使主剪除世界上你的一切仇敌之时，你也不要断绝了对我家人的恩义。” ");
INSERT INTO cmn2006_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","于是，约拿单跟大卫家族立约，说∶“愿主藉大卫家族的仇敌追讨背约的罪。” ");
INSERT INTO cmn2006_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","约拿单要大卫重新发誓爱他，因为他爱大卫就象爱他自己一样。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","然后，约拿单对大卫说∶“明天是新月节，你的座位空着，别人一定会注意到； ");
INSERT INTO cmn2006_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","后天傍晚时分，你到上次避难藏身的地方去，在以色磐石那里等着。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","我假装射什么东西，向磐石旁连发三箭， ");
INSERT INTO cmn2006_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","然后派一小僮去拾箭，如果我说∶‘看，箭就在你这边，拾回来吧！’那时，你就可以出来；我指着活生生的上帝发誓，你平安无事，毫无危险； ");
INSERT INTO cmn2006_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","如果我对小僮说∶‘看！箭在你的前头。’你就得离开这里，因为主已经差你离开此地。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","要记住你我之间的约定，主永远是我们的证人。” ");
INSERT INTO cmn2006_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","于是，大卫躲到野外。 新月节那天，扫罗王用膳， ");
INSERT INTO cmn2006_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","照常坐在靠墙的座位上，约拿单坐在对面，押尼珥坐在扫罗旁边，大卫的座位空着。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","那天扫罗没说什么，他想∶“大卫一定碰上了什么使他不洁净的事，准是不洁净了。” ");
INSERT INTO cmn2006_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","但到了第二天，大卫的座位依然空着。扫罗问他的儿子约拿单∶“耶西的儿子为什么今天和昨天都没有来吃饭？” ");
INSERT INTO cmn2006_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","约拿单答道∶“大卫恳求我准许他回伯利恒去。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","他说∶‘请让我去吧！我家要在城里献祭，我的哥哥们叫我一定要在场。如果你对我好，就请让我回去看看我的家人吧！’所以大卫没有来赴王的席。” ");
INSERT INTO cmn2006_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","扫罗对约拿单大发雷霆，说∶“你这愚顽的贱女人生的孩子！你以为我不知道你偏袒耶西的儿子吗？你丢你自己和你母亲的脸！ ");
INSERT INTO cmn2006_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","只要耶西的儿子还在这世界上活着，你和你的王位都别想存在。去派人把他带来见我，他非死不可！” ");
INSERT INTO cmn2006_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","约拿单问他父亲∶“为什么一定要把他置于死地？他做错了什么事？” ");
INSERT INTO cmn2006_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","扫罗却用矛向约拿单掷来，要杀死他。约拿单这才知道他的父亲确实想害大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","约拿单怒气冲冲地从桌边站起来，在初二那天整整一天没吃饭。他很气愤，因为扫罗侮辱他，并且还要杀大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","第二天一早，约拿单来到野外跟大卫会面，随身带来一个小僮。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","约拿单吩咐小僮∶“去把我射的箭找回来。”小僮向前跑去，约拿单搭上一支箭射到小僮的前头。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","小僮跑到箭落下的地方，约拿单在后边喊∶“箭不是还在前面吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","他又高喊∶“快！快走！别停着不动！”小僮拾起箭，拿回来交给主人， ");
INSERT INTO cmn2006_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","根本不知道是怎么一回事，只有约拿单和大卫心里明白。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","约拿单把兵器交给小僮，对他说∶“去，先把它们送回城里去。” ");
INSERT INTO cmn2006_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","小僮走后，大卫从磐石南面站起来，对着约拿单双膝跪下，叩了三个头。两人互相亲吻，抱头痛哭，大卫哭得尤为悲恸。 ");
INSERT INTO cmn2006_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","约拿单对大卫说∶“平安地去吧！我们已经指着主的名立誓要彼此友好下去；主是你我的见证人，也将永远是你我后代之间的见证人。” ");
INSERT INTO cmn2006_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","随后，大卫离开了，约拿单也返回城里。 ");
INSERT INTO cmn2006_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","大卫到了挪伯，来见祭司亚希米勒。亚希米勒诚惶诚恐地迎接他，问∶“怎么只你一个人？没有人跟你一起来？” ");
INSERT INTO cmn2006_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","大卫答道∶“我是奉王命专程到这里来的，王吩咐我∶‘不要让任何人知道你的使命和你接受的指示。’至于我的部下，我已经吩咐他们在某地跟我会面。 ");
INSERT INTO cmn2006_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","你现在手边有什么吃的东西？给我五个饼，或者别的什么都行。” ");
INSERT INTO cmn2006_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","祭司答道∶“我眼下没有普通的饼，只有一些圣饼，但只有没碰过女人的人才可以吃。” ");
INSERT INTO cmn2006_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","大卫答道∶“我们一旦出来执行任务，绝对不近女色，即使执行一般任务，我们也保持身体洁净，何况今天！” ");
INSERT INTO cmn2006_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","于是，祭司把供饼给了他；当时只有从主的面前用热供饼替换下来的这些供饼。 ");
INSERT INTO cmn2006_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","那天，扫罗的一个臣属正巧有事滞留在那里；他是以东人多益，是扫罗的畜牧长。 ");
INSERT INTO cmn2006_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","大卫问亚希米勒∶“你这里有矛或剑一类的兵器没有？王命急迫，我连自己的剑或别的兵器都没带。” ");
INSERT INTO cmn2006_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","祭司答道∶“你在以拉谷杀死的那个非利士人歌利亚的剑就在这儿，用布裹着，就在以弗得的后面。你要的话就拿去好了，这儿只有这把剑。” 大卫说∶“没有比它更好的了，把它给我吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","当天，大卫从扫罗那里逃走，来投迦特王亚吉。 ");
INSERT INTO cmn2006_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","亚吉的臣属对王说∶“这不是当世之王大卫吗？他不就是以色列人跳舞时唱的‘扫罗杀敌千千，大卫杀敌万万’的那个大卫吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","大卫听到这些话，心里很怕迦特王亚吉， ");
INSERT INTO cmn2006_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","于是就在他们面前装疯。跟他们在一起时，他疯疯颠颠，在城门上乱涂乱画，口水一直挂到胡子上。 ");
INSERT INTO cmn2006_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","亚吉对臣属们说∶“看这个人！他是个疯子！干吗把他带到我这儿来？ ");
INSERT INTO cmn2006_vpl VALUES ("S121_16","010_21_16","1SA","21","16","16","难道我这儿缺少疯子，要你们带这家伙到我面前来撒疯吗？不许这疯子再进我的宫门！” ");
INSERT INTO cmn2006_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","大卫离开迦特城，逃到亚杜兰洞。他的兄弟们和家人听到消息，也都投奔到他那里。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","穷困无助的、负债累累的和对现状不满的人都聚集到他身边，拥戴他作首领。他手下大约有四百人。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","大卫从那里出发，前往摩押的米斯巴去见摩押王，对他说∶“不知陛下能不能让我的父母住在这里，等我知道了上帝的旨意再做打算？” ");
INSERT INTO cmn2006_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","就这样，大卫把父母安置在摩押王那里；大卫在亚杜兰要塞的整个期间，他的父母一直住在摩押王那里。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","先知迦得对大卫说∶“不要再留在山寨里了，到犹大去吧！”于是，大卫动身前往哈列森林。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","有人向扫罗报告，发现了大卫及其部下。扫罗手中握矛，坐在基比亚一座小山上的一棵柳树下，臣仆侍立在他的周围。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","扫罗对众人说∶“听着，便雅悯人！耶西的儿子会把田地和葡萄园赐给你们每一个人吗？他会对你们每一个人都委以千夫长或百夫长的官职吗？ ");
INSERT INTO cmn2006_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","难道这就是你们阴谋反对我的原因？我的儿子跟耶西的儿子结盟，却没有一个人向我报告。你们当中没有一个人关心我；我的儿子至今还在煽动我的部下伺机谋害我，可是没有一个人向我举报！” ");
INSERT INTO cmn2006_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","以东人多益当时正跟扫罗的其他臣属侍立在旁边，他上前说∶“我曾在挪伯看见耶西的儿子去找亚希突的儿子亚希米勒。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","亚希米勒为他向主求问，还给了他给养和非利士人歌利亚的那把剑。” ");
INSERT INTO cmn2006_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","扫罗派人把亚希米勒和他的家族全都带来见他；他们都是挪伯的祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","扫罗说∶“听着，亚希突的儿子！” 亚希米勒答道∶“请吩咐，陛下。” ");
INSERT INTO cmn2006_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","扫罗说∶“你为什么跟耶西的儿子勾结起来反对我？为什么给他饼，给他剑，还为他求问上帝，使他得以背叛我，并至今还在伺机害我？” ");
INSERT INTO cmn2006_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","亚希米勒答道∶“大卫是陛下最忠心的臣子；他是陛下的女婿，又是陛下的侍卫长，是王室的贵臣，谁能跟他相比？ ");
INSERT INTO cmn2006_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","我是第一次为他求问上帝吗？不是！请王不要错怪我或我家族的任何人，因为我们确实毫不知情。” ");
INSERT INTO cmn2006_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","王说∶“你们都该死！你－亚希米勒，和你的整个家族！” ");
INSERT INTO cmn2006_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","王命令身边的卫士∶“把这些主的祭司都推出去杀掉！他们跟大卫是一党！他们明知大卫在逃，却不来报告我！” 但王的臣属不愿动手杀主的祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","于是，王命令多益∶“你把这些祭司推出去杀掉！”以东人多益就动手把他们杀害了。那一天，多益杀了八十五名身穿麻纱以弗得的人。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","他还屠杀了祭司城挪伯，杀光了城里的男人、女人、婴儿、幼儿和牛、羊、驴等牲畜。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","只有亚希米勒的一个儿子亚比亚他逃了出来，前去投奔大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","他告诉大卫，扫罗怎样杀害了主的祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","大卫说∶“那天我看见多益在那里，就知道他一定会去向扫罗报告。你家族的死，我有责任。 ");
INSERT INTO cmn2006_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","留下来跟我在一起吧，不要怕，要杀害你的人也正是要杀害我的人，你跟我在一起会安全的。” ");
INSERT INTO cmn2006_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","有人报告大卫∶“非利士人正在攻打基伊拉，抢掠新收成的谷物。” ");
INSERT INTO cmn2006_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","大卫求问主∶“我该不该去攻打非利士人？” 主回答说∶“去吧，攻打这些非利士人，把基伊拉城解救出来。” ");
INSERT INTO cmn2006_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","可是，大卫的部下却对大卫说∶“我们在犹大这里尚且提心吊胆，何况再去基伊拉跟非利士人的军队开战！” ");
INSERT INTO cmn2006_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","大卫再次求问主；主答复他∶“到基伊拉去，我会把非利士人交在你的手里。” ");
INSERT INTO cmn2006_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","于是，大卫率领部下前往基伊拉攻打非利士人，抢走了他们的牲畜。非利士人损失惨重，基伊拉城得救了。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","当时，亚希米勒的儿子亚比亚他逃往基伊拉投奔大卫时，把以弗得也随身一起带了去。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","扫罗听说大卫进了基伊拉城，说∶“上帝把他交给我了！大卫跑到一个有门有闩的城里去，他是作茧自缚了！” ");
INSERT INTO cmn2006_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","扫罗命令全军备战，准备向基伊拉进发，围攻大卫和他的部下。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","大卫得到扫罗准备向他进攻的消息，就对祭司亚比亚他说∶“请把以弗得带到这里来。” ");
INSERT INTO cmn2006_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","大卫祈祷说∶“主啊，以色列的上帝，你的仆人已经得到确切消息，扫罗要到基伊拉城来，他会为了我的缘故毁灭这座城。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","基伊拉人会把我交给扫罗吗？扫罗会象你仆人听说的那样到这里来吗？主啊，以色列的上帝，求你指示你的仆人！” 主说∶“他会来。” ");
INSERT INTO cmn2006_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","大卫又问∶“基伊拉人会把我和我的部下交给扫罗吗？” 主说∶“他们会。” ");
INSERT INTO cmn2006_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","于是，大卫和他的大约六百名部下离开了基伊拉城，游荡不定。扫罗听说大卫逃离了基伊拉城，就不再向基伊拉城进兵。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","大卫有时住在旷野的营寨里，有时住在西弗旷野的山上。扫罗天天追拿他，但上帝不让他落在扫罗手里。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","大卫住在西弗旷野的哈列，得知扫罗已经出发，要来取他的性命。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","扫罗的儿子约拿单到哈列来见大卫，帮助他从上帝那里寻求力量。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","约拿单对大卫说∶“不要怕，我父亲扫罗伤害不了你。你将来必定是以色列之王，而我将在你之下，甚至我父亲扫罗也很明白这一点。” ");
INSERT INTO cmn2006_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","两个人又在主的面前盟了誓。约拿单回去了，大卫继续留在哈列。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","西弗人到基比亚去见扫罗，说∶“大卫不是躲在我们旷野南部哈基拉山上哈列的营寨里吗？ ");
INSERT INTO cmn2006_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","陛下，你什么时候愿意来，我们负责把他交给你。” ");
INSERT INTO cmn2006_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","扫罗说∶“愿主为了你们对我的这番好意赐福给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","去做好准备吧！查清楚他经常去什么地方，谁在那里看见过他。听说他非常狡猾， ");
INSERT INTO cmn2006_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","查清他的所有藏身之处，给我带一份准确的情报回来，然后我跟你们一起去捉拿他。只要他还在这个地区，我就是搜遍犹大的所有部落，也要把他搜出来！” ");
INSERT INTO cmn2006_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","这些人在扫罗之前动身赶回西弗。当时，大卫和他的部下住在犹大南部的亚拉巴，在玛云旷野中。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","扫罗率兵搜索；大卫听到风声，逃进玛云旷野，藏在磐石附近。扫罗得到消息，追进了玛云旷野。 ");
INSERT INTO cmn2006_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","扫罗沿着山的一侧行军，大卫和他的部下在山的另一侧急行，想要摆脱扫罗的追击。正当扫罗和他的军队接近了大卫和他的部下，快要抓到他们的时候， ");
INSERT INTO cmn2006_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","一个信使来见扫罗，报告说∶“请急速回兵！非利士人袭击我们的国土了！” ");
INSERT INTO cmn2006_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","扫罗停止追赶大卫，回兵迎击非利士人。因此，这个地方叫做“逃离岩。” ");
INSERT INTO cmn2006_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","大卫从那里北上，住在隐基底的营寨中。 ");
INSERT INTO cmn2006_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","扫罗驱逐非利士人归来，有人向他报告∶“大卫在隐基底旷野。” ");
INSERT INTO cmn2006_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","扫罗率领三千名以色列最精锐的部队，到“野山羊岩”附近搜寻大卫和他的部下。 ");
INSERT INTO cmn2006_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","他来到路旁羊圈附近，进一个山洞里去解手，恰巧大卫和他的部下正躲在山洞的深处。 ");
INSERT INTO cmn2006_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","大卫的部下对大卫说∶“主对你说过∶‘我必把你的仇敌交在你的手里，任你处置。’这日子现在到了！” 大卫毫无声息地爬过来，割下了扫罗袍子的一角。 ");
INSERT INTO cmn2006_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","事后，大卫因割下了扫罗的衣襟而心中自责， ");
INSERT INTO cmn2006_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","他对部下说∶“主禁止我对我的主人有这类举动；我不可以伤害他，因为他是主的受膏者。” ");
INSERT INTO cmn2006_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","大卫用这些话劝阻自己的部下，不许他们伤害扫罗。 扫罗出了山洞，正要上路， ");
INSERT INTO cmn2006_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","大卫从山洞里出来，喊住扫罗∶“国王陛下！” 扫罗转回头，看见大卫正倒身下拜。 ");
INSERT INTO cmn2006_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","大卫对扫罗说∶“陛下为什么要听信别人说‘大卫想要害你’呢？ ");
INSERT INTO cmn2006_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","今天，你亲眼所见，主在山洞里把你交在了我的手中。有人劝我杀掉你，但我却放过了你；我说∶‘我不能加害我的主人，他是主的受膏者。’ ");
INSERT INTO cmn2006_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","看哪，父王，看看我手中你的袍角！我割下了你的袍角，却没有伤害你。现在陛下该明白了，我没有恶意叛逆之罪。我没有得罪过陛下，陛下却一直追捕我，要取我的性命。 ");
INSERT INTO cmn2006_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","愿主在你我之间判定是非，洗雪你对我的冤屈，但我决不亲手加害你。 ");
INSERT INTO cmn2006_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","俗语说∶‘恶人行恶，’我决不会碰你一下！ ");
INSERT INTO cmn2006_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","以色列王出兵是为了谁呢？陛下要追赶的又是什么人呢？不过是一条死狗，一只跳蚤罢了！ ");
INSERT INTO cmn2006_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","愿主做我们的审判者，在我们之间施行审判。愿主详察我的申诉，主持公道；愿他为我辩冤，救我脱离你的手。” ");
INSERT INTO cmn2006_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","大卫说完，扫罗问他∶“大卫，我的儿，这是你在说话吗？”他大哭起来， ");
INSERT INTO cmn2006_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","又说∶“你比我正派，一直对我很好，而我却以怨报德。 ");
INSERT INTO cmn2006_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","你刚才所说的一切表明了你对我的善意，主把我交在你的手里，你却没有杀我。 ");
INSERT INTO cmn2006_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","如果一个人遇上他的仇敌，会让他平安无事地走吗？愿主为你今天对我所做的一切赐福给你！ ");
INSERT INTO cmn2006_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","我知道你将来必定作王，以色列王国必定在你手中兴起。 ");
INSERT INTO cmn2006_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","现在，我要你指着主对我起誓，你决不除灭我的后代，不使我的姓氏从我的家族里抹去。” ");
INSERT INTO cmn2006_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","大卫向扫罗起了誓。随后，扫罗撤兵回去了，大卫和他的部下返回营寨。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","撒母耳死了，全体以色列人为他聚会举哀，把他安葬在他的家乡拉玛。此后，大卫移住在巴兰旷野。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_2","010_25_2","1SA","25","2","3","玛云有一个迦勒人，名叫拿八，他在迦密经营产业，非常富有，拥有三千只绵羊和一千只山羊。他的妻子名叫亚比该，聪明美貌，但她的丈夫拿八却是一个粗暴自私的人。当时，拿八正在迦密剪羊毛。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","大卫在旷野里听说拿八正在剪羊毛， ");
INSERT INTO cmn2006_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","就派出十个年轻人，吩咐他们∶“你们到迦密城去见拿八，以我的名义向他致意。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","对他说∶‘祝你长寿！祝你和你一家都身体安康！愿你的一切都平安无恙！ ");
INSERT INTO cmn2006_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","我听说现在正是剪羊毛的季节，你的牧人一向跟我们在一起，我们从没有欺负过他们。他们在迦密的整个期间没有丢失过任何东西。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","你问问你自己的仆人，他们会告诉你。因此，请你接待我的这几位年轻人，因为我们的节期到了；请随意赐给你的仆人和晚辈大卫一点什么东西。’” ");
INSERT INTO cmn2006_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","大卫的部下到了那里，以大卫的名义向拿八致意，等待回音。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","拿八却答复他们∶“谁是大卫？耶西的儿子是什么人？近来这地方背主逃跑的奴仆很多， ");
INSERT INTO cmn2006_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","为什么我要把为剪羊毛人预备的饼、水和肉送给那些不知从哪里冒出来的人？” ");
INSERT INTO cmn2006_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","大卫的部下转身就回去了。他们见了大卫，一字不漏地向大卫做了报告。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","大卫喝令部下∶“佩上剑！”众人都佩上了剑。大卫自己也佩上剑，带领四百人出发，留下二百人看守东西。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","拿八的一个仆人对拿八的妻子亚比该说∶“大卫派人从旷野到这里来问候我们的主人，他却侮辱了他们。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","这些人对我们确实很好，从不欺负我们。我们在野外时一直跟他们在一起，从来没丢过任何东西。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","我们在他们附近放羊的时候，他们象一堵墙一样日日夜夜护卫着我们。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","请想想现在你该怎么办？我们的主人和他的全家已经大难临头。他又是这样一个蛮横的人，谁的话也不听！” ");
INSERT INTO cmn2006_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","亚比该急忙准备好两百块饼，两皮袋酒，五只收拾齐整的羊，大约三十五升烤熟的麦子，一百串葡萄干，还有两百块无花果饼。她把这些都驮在驴背上， ");
INSERT INTO cmn2006_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","吩咐仆人∶“你先走一步，我随后就来。”这一切她都没有告诉她的丈夫。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","亚比该骑着驴刚走进山谷，正碰上大卫带着人从对面下来，亚比该连忙迎上他们。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","大卫本来是这样想的∶“我在旷野保护这家伙的财产，不让他蒙受一点损失，真是徒劳无益，他竟然以怨报德！ ");
INSERT INTO cmn2006_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","如果到明天早晨之前我还让他家有一个男人活着，愿主重重地惩罚我！” ");
INSERT INTO cmn2006_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","亚比该一看见大卫，急忙下了驴，俯伏在大卫面前。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","她伏在大卫的脚下，说∶“阁下，请让我一人承当罪责吧！求你允许奴婢陈述衷情，听一听我要说的话。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","请阁下不要理睬拿八那个蠢人，他名叫拿八，他本人就象他的名字一样，是个名符其实的蠢东西。但我－你的奴婢并没有看见阁下派去的人。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","主既然不愿让你亲手复仇而杀人流血，我愿指着活生生的上帝向阁下立誓∶让你的仇敌和所有想加害阁下的人都落得跟拿八一样的下场。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","请把奴婢带来献给阁下的这些礼物分送给你的部下， ");
INSERT INTO cmn2006_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","请饶恕你婢女的过失；主必将为阁下建立一代万世不朽的王朝，因为你一直在为主而战。愿你终生无过失可言。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","即使有人想加害你，你的生命也必蒙主－你的上帝的重重护卫，而你仇敌的生命将被主抛弃，就象从甩石器上抛出的石头。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_30","010_25_30","1SA","25","30","31","当主按照他的应许为阁下成就一切好事，立阁下为以色列之王的时候，阁下将不会因无谓的杀人流血或亲手复仇而心中不安。主使阁下大功告成的时候，求你不要忘记奴婢。” ");
INSERT INTO cmn2006_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","大卫对亚比该说∶“赞美主－以色列的上帝！他今天差你来见我。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","为了你过人的见识，为了你没有让我今天亲手复仇，杀人流血，愿主赐福给你！ ");
INSERT INTO cmn2006_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","如果不是你这样快地来见我，我指着阻止我伤害你的活生生的上帝起誓，在明天天亮之前，拿八家的男人将一个不剩！” ");
INSERT INTO cmn2006_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","大卫接受了亚比该带来的礼物，对她说∶“平安地回去吧！我听你的话，也答应你的请求。” ");
INSERT INTO cmn2006_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","亚比该回到拿八那里，见他正在家中举行象王室一样豪华的盛宴。拿八得意忘形，喝得烂醉。亚比该当夜什么也没有告诉他。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","第二天早晨，拿八酒醒了，亚比该把事情的前后经过都告诉了他。拿八吓得魂不附体，象块石头一样呆呆立着。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","主惩罚拿八；过了十天，拿八就死了。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","大卫听说拿八死了，说∶“赞美主，他既为我报了拿八侮辱我的仇，又使我没有行凶，也使拿八的恶行受到报应。”大卫随即派人去向亚比该求婚。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","大卫的仆人到了迦密，对亚比该说∶“大卫派我们来，想接你去跟他成婚。” ");
INSERT INTO cmn2006_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","亚比该俯伏在地上，说∶“你的婢女在这儿；她随时准备服侍你，并为阁下的仆人洗脚。” ");
INSERT INTO cmn2006_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","亚比该随即骑上驴，带着五个婢女，跟大卫的仆人一起来到大卫那里。亚比该成了大卫的妻子。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","大卫先前已经娶了耶斯列人亚希暖为妻；他现在共有两个妻子。 ");
INSERT INTO cmn2006_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","而扫罗这时已经把他的女儿米甲，也就是大卫的妻子，嫁给了迦琳人拉亿的儿子帕提。 ");
INSERT INTO cmn2006_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","西弗人到基比亚来见扫罗，说∶“大卫现在正藏在旷野对面的哈基拉山上！” ");
INSERT INTO cmn2006_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","于是，扫罗带领三千名以色列精兵来到西弗旷野搜寻大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","扫罗在旷野对面哈基拉山的路旁扎下营寨，这时大卫还停留在旷野里。他听说扫罗已经跟踪而来， ");
INSERT INTO cmn2006_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","就派出哨探去侦察，得知扫罗果然到了。 ");
INSERT INTO cmn2006_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","大卫立即动身前往扫罗的营地，查明了扫罗和元帅－尼珥的儿子押尼珥的安歇之处。扫罗睡在营中，周围驻扎着军队。 ");
INSERT INTO cmn2006_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","大卫问赫人亚希米勒和洗璐雅的儿子、约押的兄弟亚比筛∶“你们两人谁愿意跟我潜入扫罗的营中去？” 亚比筛答道∶“我愿意跟你去。” ");
INSERT INTO cmn2006_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","大卫和亚比筛趁着夜色潜入军营，发现扫罗正在营中沉睡，他的矛就插在头旁边的地上，押尼珥和士兵们躺在他的周围。 ");
INSERT INTO cmn2006_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","亚比筛对大卫说∶“今天，上帝把你的仇敌交在你的手里了！我一下就能用矛把他钉在地上，用不着第二下。” ");
INSERT INTO cmn2006_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","大卫却对亚比筛说∶“别杀他！谁能杀主膏立的人而无罪？ ");
INSERT INTO cmn2006_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","我指着活生生的上帝起誓，主会亲自惩罚他的。他或者会寿终而亡，或者会战死沙场。 ");
INSERT INTO cmn2006_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","但主不准我亲手加害他的受膏者。我们拿了他头边的矛和水罐就走吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","于是，大卫拿走了扫罗头旁边的矛和水罐，离开了军营。没有人看见，也没有人知道这件事，人们全都酣然大睡，连一个醒来的人也没有；是主使他们沉睡不醒。 ");
INSERT INTO cmn2006_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","大卫越过山谷，站在远处的山顶上，跟扫罗的军营拉开距离， ");
INSERT INTO cmn2006_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","然后，高声向扫罗的军队和押尼珥喊∶“押尼珥，你怎么不答话？” 押尼珥问∶“你是谁？竟敢向王喊叫？” ");
INSERT INTO cmn2006_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","大卫说∶“在以色列，你不是无人能比的勇士吗？为什么保护不了你的国王陛下？有人已经进过你的营，要杀你的国王陛下。 ");
INSERT INTO cmn2006_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","你的表现实在不佳！我指着活生生的主起誓，你和你的部下都该死！你们没有保护好你们的主人－主的受膏者。向周围看看，王头旁边的矛和水罐哪儿去了？” ");
INSERT INTO cmn2006_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","扫罗认出了大卫的声音，说∶“是你说话吗，我儿大卫？” 大卫答道∶“是我，陛下！” ");
INSERT INTO cmn2006_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","接着他又说∶“陛下为什么要追逼你的仆人呢？我做了什么错事？犯了什么罪？ ");
INSERT INTO cmn2006_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","陛下，请听听仆人的陈述。如果是主使你仇视我，我愿把我的生命作为祭物献给主；如果是人在策划这一切，愿上帝诅咒他们。他们把我赶出了主的土地，不容我在那里立足，说∶‘走开！去拜别的神明吧！’ ");
INSERT INTO cmn2006_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","别让我的血洒在远离主的土地上吧！以色列之王竟要出来搜寻一只跳蚤，就象人上山就为打一只鹧鸪一样吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","扫罗答道∶“我有罪了。回来吧，我儿大卫，你这样爱惜我的生命，我再也不会伤害你了。我真象个傻瓜，真糊涂极了！” ");
INSERT INTO cmn2006_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","大卫说∶“这是陛下的矛，请派人来取回去吧！ ");
INSERT INTO cmn2006_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","主奖赏正直和忠信的人。今天，主把你交在我的手里，但我没有伤害主的受膏者。 ");
INSERT INTO cmn2006_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","愿主象我保全你的性命一样保全我，救我脱离一切灾难。” ");
INSERT INTO cmn2006_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","扫罗对大卫说∶“愿主赐福给你，我儿大卫；你将来必定能举大事，成大器。” 大卫离开了那里，扫罗也回去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","大卫心想∶“总有一天我会死在扫罗手里，看来最好还是逃到非利士人那里去。那样，扫罗就不会在以色列境内到处搜寻我了，我也就逃脱他的手了。” ");
INSERT INTO cmn2006_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","大卫带领六百名部下离开当地，前去投奔迦特王－玛俄的儿子亚吉。 ");
INSERT INTO cmn2006_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","大卫和部下都带着家眷，在迦特城住了下来。大卫带着两个妻子，一个是耶斯列人亚希暖，另一个是拿八的寡妇迦密人亚比该。 ");
INSERT INTO cmn2006_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","扫罗听说大卫已经逃到迦特，也就不再搜寻他了。 ");
INSERT INTO cmn2006_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","大卫对亚吉说∶“如果陛下恩准，请赐给我一座边远小城容身。仆人怎能跟王同住京城呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","当天，亚吉王把洗革拉城赐给了大卫，从那时起，洗革拉隶就归犹大王所有。 ");
INSERT INTO cmn2006_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","大卫在非利士住了一年零四个月。 ");
INSERT INTO cmn2006_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","大卫率领部下袭击基述人、基色人和亚玛力人；他们祖祖辈辈生活在那里，居住的地域一直延伸到书珥和埃及一带。 ");
INSERT INTO cmn2006_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","他每攻陷一地，就杀光那里的男男女女，掳走他们的牛、羊、驴、骆驼，抢走他们的衣服，然后回到亚吉王那里。 ");
INSERT INTO cmn2006_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","每当亚吉王问∶“这次你上哪儿打仗去了？”大卫就回答说∶“上犹大南部去了，”或“上耶拉篾的南部去了，”或“上基尼人的南部去了。” ");
INSERT INTO cmn2006_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","他从不留下一个男女活口带回迦特，他想∶“这些人有可能泄露我们的实情，说∶‘大卫实际上干的是这些事！’”大卫在非利士期间一直是这样活动的。 ");
INSERT INTO cmn2006_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","亚吉王对大卫深信不疑，暗自想∶“大卫已经被本族的以色列人所痛恨，他一定会死心塌地做我的臣子了。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","在那一时期里，非利士人曾集结军队，准备攻打以色列人。亚吉王对大卫说∶“你应该明白，你和你的部下都要随我出征。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","大卫答道∶“那陛下就能亲眼看看仆人的能力了。” 亚吉王说∶“好啊，果真如此，我就委任你终身做我的侍卫长。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","撒母耳这时已经死了，全体以色列人为他举哀，把他安葬在自己的封邑拉玛城。扫罗赶走了国内所有的占卜者和巫师。 ");
INSERT INTO cmn2006_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","非利士人集结在书念扎营；扫罗召集以色列人在基利波扎营。 ");
INSERT INTO cmn2006_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","扫罗望见非利士军队，心里非常害怕， ");
INSERT INTO cmn2006_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","就向主求问，但主既不藉梦默示他，也不藉乌陵和先知回答他。 ");
INSERT INTO cmn2006_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","于是，扫罗吩咐侍从∶“给我找个巫婆来！我要问问她。” 侍从们答道∶“在隐多珥就有一个。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","扫罗乔装改扮，换了衣服，趁着夜色带着两个随从去见那女人。扫罗对她说∶“请把我告诉你的人召上来，为我向他的亡魂求问。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","那女人答道∶“你应该知道扫罗王怎样除掉国内所有的占卜者和巫师，你为什么要陷害我，把我往死路上推呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","扫罗指着主向那女人起誓，说∶“我指着活生生的主起誓，你决不会因此获罪。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","那女人问∶“你要我召谁？” 扫罗答道∶“召撒母耳。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","那女人看见撒母耳，惊叫起来，对扫罗说∶“你为什么要骗我？你就是扫罗。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","扫罗对她说∶“不要怕。你看见了什么？” 那女人答道∶“我看见一个亡魂从地里升起来。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","扫罗问∶“他长得什么样？” 那女人答道∶“是一个老人，穿着长袍。” 扫罗知道那就是撒母耳，急忙倒身下拜。 ");
INSERT INTO cmn2006_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","撒母耳问扫罗∶“你为什么事烦扰我，把我召上来？” 扫罗答道∶“我大祸临头了！非利士人要来攻打我，而上帝又离开了我；他不再藉先知和梦默示我，所以我才请你上来，告诉我该怎么办。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","撒母耳答道∶“主已经离弃了你，视你为仇敌，你何必还来求问我？ ");
INSERT INTO cmn2006_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","主只不过做了他藉我宣布过的一切。主已经把王国从你的手中夺了过来，赐给了你的一个同胞，他就是大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","由于你没有服从主，没有渲泄他对亚玛力人的烈怒，所以主今天这样对待你， ");
INSERT INTO cmn2006_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","他要把你和以色列人都交给非利士人。明天，你和你的儿子们就要跟我在一起了，主也把以色列军队交给了非利士人。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","扫罗被撒母耳的话吓呆了，立时直挺挺地倒在地上。他已经一天一夜没有吃东西，一点力气也没有了。 ");
INSERT INTO cmn2006_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","那女人走到扫罗跟前，见他吓坏了，就对他说∶“奴婢听从你的命令，不顾性命做了你吩咐的事。 ");
INSERT INTO cmn2006_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","现在，也请你听从奴婢的话，让我做点东西给你吃，你吃了东西才能有力气上路。” ");
INSERT INTO cmn2006_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","扫罗不肯，说∶“我不吃。”他的部下跟那女人一起劝他，最后，他听从了，从地上起来，坐到床上。 ");
INSERT INTO cmn2006_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","那女人家里有一头肥牛犊，她赶紧把它宰了，又拿出面粉，揉成面团，烘了些无酵饼。 ");
INSERT INTO cmn2006_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","她把食物摆到扫罗和他的随从面前，让他们吃。他们当夜就离开了。 ");
INSERT INTO cmn2006_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","非利士人在亚弗集结了他们所有的军队；以色列人在耶斯列谷的溪边扎营。 ");
INSERT INTO cmn2006_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","非利士人的首领们率领军队以每百人或千人为单位依次前进，大卫带领部下跟着亚吉王走在全军的最后面。 ");
INSERT INTO cmn2006_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","非利士的将领们问∶“这些希伯来人是怎么回事？” 亚吉对他们说∶“这就是大卫。他以前是以色列王扫罗的将官，来投靠我已经有一年多了。从他跟扫罗分手到现在为止，我看不出他有什么不对头的地方。” ");
INSERT INTO cmn2006_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","非利士的将领们很不高兴，对亚吉王说∶“让他回去吧，回你给他的那座城去，不能让他跟我们一起上阵，说不定他会在交战的时候倒戈打我们。他要向旧主邀宠，还有比拿我们的人头去更好的事吗？ ");
INSERT INTO cmn2006_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","以色列人跳舞时所唱的‘扫罗杀敌千千，大卫杀敌万万，’说的不就是这个大卫吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","亚吉王把大卫召来，对他说∶“我指着活生生的上帝发誓，你一直是忠诚可靠的，我很愿意让你在我的军中效力，从你投奔我那时起直到现在，我找不出你有什么过错。但是，将领们不信任你。 ");
INSERT INTO cmn2006_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","所以，你还是平平安安地回去吧，别惹得非利士将领们心中不快。” ");
INSERT INTO cmn2006_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","大卫答道∶“可我做了什么错事？从我投奔你直到如今，你的仆人有没有任何可指责之处？为什么不让我去打国王陛下的仇敌呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","亚吉答道∶“我知道你象上帝的天使一样令人放心；但非利士的将领们说∶‘不能让他跟我们一起上阵！’ ");
INSERT INTO cmn2006_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","明天一早，你和你的部下，也就是你旧日主人的臣属，天一亮就回去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","第二天一早，大卫带领部下返回非利士；非利士人继续向耶斯列进军。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","三天后，大卫和他的部下回到洗革拉。亚玛力人在这期间袭击了南地和洗革拉，他们攻陷了洗革拉，烧毁了城池， ");
INSERT INTO cmn2006_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","掳走了妇女、老人和幼童，亚玛力人没有杀这些人，却把他们都带走了。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","大卫和部下回到洗革拉，发现城已经被烧毁，他们的妻子儿女也已都被亚玛力人掳走， ");
INSERT INTO cmn2006_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","都大哭起来，直哭得声嘶力竭。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","大卫的两个妻子－耶斯列人亚希暖和拿八的遗孀亚比该也都被掳走了。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","大卫紧张不安；他的部下失去了子女，人人心痛欲碎，威胁说要用石头打死大卫。但大卫在主－他的上帝那里找到了力量。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","大卫对亚希米勒的儿子亚比亚他祭司说∶“把以弗得带到我这里来！”亚比亚他把以弗得带到大卫面前， ");
INSERT INTO cmn2006_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","大卫求问主∶“我该不该去追这些暴徒？我能追上他们吗？” 主答应他说∶“去追他们；你一定能追上他们，把被抢走的一切夺回来。” ");
INSERT INTO cmn2006_vpl VALUES ("S130_9","010_30_9","1SA","30","9","10","大卫率领六百名部下前往比梭溪，二百人过于劳累，无法渡河，不得不留了下来。大卫率领其余四百人继续追击。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","人们在野外发现了一个埃及人，把他带来见大卫。人们给他东西吃，给他水喝， ");
INSERT INTO cmn2006_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","又给了他一块无花果饼和两个葡萄饼吃。他已经三天三夜没有吃喝了，吃完东西以后，他的力气恢复了。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","大卫问他∶“你是谁的人？从哪儿来的？” 他答道∶“我是埃及人，是亚玛力人的奴隶。三天前我生了病，我的主人就把我扔在这里。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","我们袭击了基利提人的南部地区和犹大的领地以及迦勒南部地区，还烧毁了洗革拉城。” ");
INSERT INTO cmn2006_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","大卫问他∶“你愿不愿意领我们去追这些暴徒？” 他答道∶“如果你指着上帝的名发誓不杀我，也不把我交还给我的主人，我就领你们去。” ");
INSERT INTO cmn2006_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","他领着大卫追上了他们；他们正四散在野外，又吃又喝，狂欢作乐，为从非利士和犹大掳得大批战利品而得意洋洋。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","大卫趁着暮色攻击他们，一直打到第二天傍晚，除了四百名骑着骆驼的人逃走以外，没有一个人逃脱。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","大卫夺回了被亚玛力人抢走的一切，包括他的两个妻子， ");
INSERT INTO cmn2006_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","其他男女老少和所有被掳走的物资，全都一件不少地又夺了回来。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","他的部下赶着大卫夺回来的牛群和羊群走在辎重的前面，说∶“这些都是大卫的战利品！” ");
INSERT INTO cmn2006_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","大卫跟那二百个因过度疲乏无法随军出战而留在比梭溪边的人会合。他们出营迎接大卫和随他出战的人。大卫带领部下走近他们，向他们致意。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","随大卫出征的队伍中有些心地阴险和专生是非的人，他们说∶“这些人没有跟我们一起去，没有权利分享我们夺回来的东西，让他们各人领了自己的妻子儿女就走吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","大卫说∶“弟兄们，你们不可以这样处理主赐给我们的东西。主庇护我们，把侵犯我们的人交在我们的手里， ");
INSERT INTO cmn2006_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","谁能同意你们的话？留下来看守供应品的人应该跟外出作战的人分得同样的份额，所有的东西都应该平分。” ");
INSERT INTO cmn2006_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","从那时起，大卫定下了这一条例，以色列人至今一直遵守它。 ");
INSERT INTO cmn2006_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","大卫回到洗革拉，把一些战利品送给他的朋友－犹大的长老们，并说∶“这是送给你们的礼物，是从主的敌人那里夺来的。” ");
INSERT INTO cmn2006_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","他还送礼给伯特利人、南部地区的拉末人、雅提珥人， ");
INSERT INTO cmn2006_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","亚罗珥人、息末人、以实提莫人、 ");
INSERT INTO cmn2006_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","拉哈勒人、耶拉蔑人、基尼人、 ");
INSERT INTO cmn2006_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","何珥玛人、歌拉珊人、亚挞人、 ");
INSERT INTO cmn2006_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","希伯仑人、以及他和部下经常来往的各个地区的人。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","非利士人向以色列人进攻；以色列人败了，很多人在基利波山被杀。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","非利士人紧紧地追赶扫罗和他的儿子们，杀死了约拿单、亚比拿达和麦基舒亚。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","扫罗的周围战斗惨烈；他被敌人的箭射中，受了致命伤。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","扫罗对拿兵器的兵说∶“拔出剑来刺死我！不要让那些不受割礼的家伙杀我、凌辱我。”但拿兵器的兵心中害怕，不敢杀他；扫罗拔出自己的剑来，伏剑而死。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","拿兵器的兵见扫罗死了，也拔剑自杀，跟扫罗死在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","扫罗和他的三个儿子以及拿兵器的兵就这样死了；那天，扫罗的军队全军覆没。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","住在山谷附近和约旦河对岸的以色列人见以色列军队败了，扫罗和他的儿子们都已阵亡，纷纷弃城而逃。非利士人进占了这些城。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","第二天，非利士人来剥战死者的衣服，发现扫罗和他的三个儿子躺在基利波山上。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","他们割下扫罗的头，剥下他的甲胄，派人到非利士各地遍告民众和庙里的偶像。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","他们把扫罗的甲胄放在亚斯他录神庙中，把他的尸体悬挂在伯珊城的城墙上。 ");
INSERT INTO cmn2006_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","基列雅比人听到非利士人对扫罗的所做所为， ");
INSERT INTO cmn2006_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","他们中间的勇士连夜赶往伯珊，从城墙上放下扫罗和他儿子们的尸体，运回雅比。他们在雅比焚化了扫罗和他儿子们的尸体， ");
INSERT INTO cmn2006_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","把遗骸安葬在一棵柳树下，并禁食了七天。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","大卫打败亚玛力人回来，在洗革拉休整了两天，这时，扫罗已经阵亡。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","第三天，一个衣衫褴褛、满面灰尘的人从扫罗营中赶来见大卫，向大卫倒身下拜。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","大卫问∶“你从哪儿来？” 他答道∶“我是从以色列人营中逃出来的。” ");
INSERT INTO cmn2006_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","大卫急问∶“发生了什么事？快告诉我。” 他答道∶“以色列人败了，很多人被杀，扫罗和他的儿子约拿单也都死了。” ");
INSERT INTO cmn2006_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","大卫追问前来报信的人∶“你怎么知道扫罗和他的儿子约拿单已经死了？” ");
INSERT INTO cmn2006_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","那人答道∶“我当时正在基利波山上，看见扫罗拄着矛，敌人的战车和骑兵眼看就要追上他了。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","他转身看见我，就叫住我，我说：‘我能帮你些什么？’ ");
INSERT INTO cmn2006_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","他问我：‘你是谁？’我答道：‘我是亚玛力人。’ ");
INSERT INTO cmn2006_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","他就对我说：‘过来杀了我吧！我注定要死了，可就是迟迟不死。’ ");
INSERT INTO cmn2006_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","我知道他重伤之后反正活不了，于是就过去杀死了他，摘下他头上的王冠和手臂上的镯子，带来献给阁下。” ");
INSERT INTO cmn2006_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","大卫和全体部下都悲痛地撕裂衣服， ");
INSERT INTO cmn2006_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","失声痛哭，并一直禁食到晚上，为扫罗、他的儿子约拿单、主的军队和以色列人志哀，因为他们都已经命丧疆场。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","大卫问那个前来报信的人∶“你是哪里人？”他答道∶“我是寄居在你们这里的亚玛力人的后代。” ");
INSERT INTO cmn2006_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","大卫说∶“你怎么竟敢动手杀害主的受膏者？” ");
INSERT INTO cmn2006_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","他喝令一名部下∶“把他砍了！”他的部下就杀死了那人。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","大卫曾对那亚玛力人说∶“你的血要溅在你自己的头颅上。当你说：‘我杀死了主的受膏者’的时候，你自己的嘴就作证定了你的罪。” ");
INSERT INTO cmn2006_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","大卫为扫罗和他的儿子约拿单作了一首挽歌， ");
INSERT INTO cmn2006_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","并下令把它教给全体犹大人，这就是《弓之歌》。这首歌记载在《雅煞珥书》上∶ ");
INSERT INTO cmn2006_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","“以色列啊， 你的荣耀长眠在你的高山之上， 英勇的战士竟倒下了！ ");
INSERT INTO cmn2006_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","不要告诉迦特， 不要让这消息在亚实基伦的街市上传告； 不要让非利士人兴高采烈， 不要让那些不受割礼的人因此欢乐。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","基利波的群山啊， 愿你无雨无露，愿你的土地没有出产可作供物； 因为英雄的盾牌在这里被玷污了， 扫罗的盾牌再也不会被油擦亮了。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","约拿单的弓曾使敌人鲜血飞溅， 扫罗的剑曾使强者血肉横飞。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","扫罗和约拿单啊， 活着，他们受人敬爱；死了，他们也不分开。 他们比鹰更迅猛，比狮子更强壮。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","以色列的女儿啊，你们要为扫罗哀哭， 他曾使你们穿红挂紫， 他曾使你们金银满身。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","英勇的战士竟倒在战场上； 约拿单竟被害了， 躺在你们的山上。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","约拿单，我的兄弟啊， 你对我情深意厚，我为你哀伤！ 你给我的爱何等美妙，胜过了异性的爱情。 ");
INSERT INTO cmn2006_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","英雄竟倒下了！ 战场上从此没有勇士了！” ");
INSERT INTO cmn2006_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","过了不久，大卫求问主∶“我可不可以到犹大的城里去？” 主说∶“去吧！” 大卫问∶“我应该去哪座城呢？” 主答道∶“去希伯仑。” ");
INSERT INTO cmn2006_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","于是，大卫带上两个妻子－耶斯列人亚希暖和迦密人拿八的遗孀亚比该，一起到希伯仑去。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","大卫的部下也带着家眷随大卫一起到了希伯仑，住在希伯仑城及其周围的村镇里。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","犹大人都聚集到希伯仑，在那里膏立大卫为犹大王。 大卫听说是雅比基列人安葬了扫罗， ");
INSERT INTO cmn2006_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","就派使者去见他们，对他们说∶“你们安葬了自己的主人扫罗，足见你们的忠心，愿主赐福给你们。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","主会向你们显示他的仁爱和信实，我也同样要为此厚待你们。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","你们要坚强，要勇敢！你们的故主扫罗虽然死了，但犹大人已经膏立我作他们的王。” ");
INSERT INTO cmn2006_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","与此同时，扫罗军队的统帅、尼珥的儿子押尼珥带着扫罗的儿子伊施波设到了玛哈念， ");
INSERT INTO cmn2006_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","在那里立他为王，据有基列、亚书、耶斯列、以法莲、便雅悯和整个以色列。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","扫罗的儿子伊施波设四十岁即位以色列王，在位二年。而犹大人则拥戴大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","大卫在希伯仑统治犹大七年半。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","尼珥的儿子押尼珥带领扫罗的儿子伊施波设的部下从玛哈念来到基遍， ");
INSERT INTO cmn2006_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","洗鲁雅的儿子约押带领大卫的部下来到基遍池边迎战。两队人隔池相峙。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","押尼珥对约押说∶“我们各派几个年轻人，让他们就在我们面前一对一地较量一下！” 约押答道∶“好，就这么办！” ");
INSERT INTO cmn2006_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","于是，双方各派出人来，伊施波设和便雅悯方面十二个人，大卫方面十二人。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","每个人都扭住对手的头，用短剑刺进对方的胁侧，双方一起倒了下去。因此，基遍的那个地方被叫做“剑场”。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","战斗非常激烈，押尼珥和以色列人被大卫的部下打败了。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","那天，洗鲁雅的三个儿子约押、亚比筛、亚撒黑都在场。亚撒黑跑起来象野鹿一样快， ");
INSERT INTO cmn2006_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","他径直朝押尼珥追了下去。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","押尼珥回头看了看，问他∶“你是亚撒黑吗？” 亚撒黑答道∶“是我。” ");
INSERT INTO cmn2006_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","押尼珥说∶“别追我了！去追别的人，缴他的东西吧！”但亚撒黑还是穷追不舍。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","押尼珥再次警告他∶“不要追我！非要我杀你不可吗？杀了你，我还有什么面目去见你的哥哥约押？” ");
INSERT INTO cmn2006_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","亚撒黑仍然不肯停步。于是，押尼珥用矛尾刺入亚撒黑的腹部，直透后背，亚撒黑当场倒地毙命。 其他人追到亚撒黑倒毙的地方也都止步不追了。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","约押和亚比筛继续追赶押尼珥，太阳快要落山的时候，他们来到基亚附近通往基便旷野的大道旁的亚玛山。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","便雅悯人集合起来支援押尼珥，他们整顿队伍，占据了山顶。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","押尼珥向约珥喊话说∶“我们要永远打下去吗？你不知道到头来只会使我们两败俱伤吗？你还不告诉你的部下，不要再追他们的同胞吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","约押答道∶“我指着活生生的上帝起誓，如果你不说刚才那番话，我的人会追你们一直追到明天早晨。” ");
INSERT INTO cmn2006_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","约押吹号收兵，不再追击以色列人，战斗停止了。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","押尼珥带领部下连夜行军，穿过亚拉巴，渡过约旦河，经毕伦回到玛哈念。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","约押收兵回来，集合队伍；除亚撒黑之外，还少了十九个人， ");
INSERT INTO cmn2006_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","但大卫的部下杀死了三百六十名由押尼珥率领的便雅悯人。 ");
INSERT INTO cmn2006_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","他们收殓了亚撒黑的尸体，安葬在伯利恒他的家族墓地里。随后，约押带领部下连夜行军，在破晓前回到希伯仑。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","扫罗家族和大卫家族长年争战不息。大卫家族越来越强大，而扫罗家族日渐衰落。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_2","011_3_2","2SA","3","2","5","大卫在希伯仑生了六个儿子，按长幼排序如下： 暗嫩－耶斯利人亚希暖所生； 基利押－迦密人拿八的遗孀亚比该所生； 押沙龙－基述王达买的女儿玛迦所生； 亚多尼亚－哈及所生； 示法提雅－亚比他所生； 以特念－以格拉所生。 以上是大卫在希伯仑期间所生的儿子。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","在扫罗家族和大卫家族的战争中，押尼珥巩固了自己在扫罗王朝中的地位。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","扫罗以前有一个妃子，名叫利斯巴，是爱亚的女儿。 一天，伊施波设责问押尼珥∶“你为什么跟我父亲的妃子睡觉？” ");
INSERT INTO cmn2006_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","押尼珥对伊施波设的责问非常恼怒，说∶“难道我是个只知咬犹大人的狗头吗？即便是今天，我仍然对你父亲扫罗和他的家族亲朋忠心耿耿，我没有把你交给大卫，你反而为了一个女人来斥责我！ ");
INSERT INTO cmn2006_vpl VALUES ("S23_9","011_3_9","2SA","3","9","10","如果我不按照主对大卫的应许，废去扫罗王朝，拥立大卫王朝，使他统治从但到别是巴的全部以色列和犹大的领土，愿主重重地惩罚我！” ");
INSERT INTO cmn2006_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","伊施波设惧怕押尼珥，不敢再说一句话。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","押尼珥私下派人去见大卫，说∶“谁应为一国之主？请与我立约，瞧吧，我会竭尽全力让以色列人归顺你。” ");
INSERT INTO cmn2006_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","大卫说∶“好吧，我可以跟你立约。但有一个条件，你再来的时候，如果不把扫罗的女儿米甲一起带来，就别想见我。” ");
INSERT INTO cmn2006_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","随后，大卫派使者去见伊施波设，提出要求∶“你要把我的妻子米甲还给我！她是我用一百个非利士人的包皮换来的。” ");
INSERT INTO cmn2006_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","伊施波设命人把米甲从她的丈夫、拉亿的儿子帕铁那里带来。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","她的丈夫跟着她，一边走一边哭，一直跟到巴户琳。押尼珥对他说∶“你回去吧！”他只得回去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","押尼珥跟以色列的长老们商议，说∶“你们久已希望大卫作你们的王， ");
INSERT INTO cmn2006_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","现在时机到了！主曾应许大卫说：‘我要藉我的仆人大卫把我的以色列子民从非利士人和他们其他仇敌的手中解救出来。’” ");
INSERT INTO cmn2006_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","押尼珥又亲自游说便雅悯人。然后，他来到希伯仑，向大卫禀报以色列人和全体便雅悯人的意愿。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","押尼珥带领二十名部下到希伯仑来见大卫，大卫设宴招待他和他的部下。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","押尼珥对大卫说∶“我愿立即回去招集全体以色列人，让他们跟陛下立约，使陛下可以按照心愿统治想要统治的一切地方。”于是，大卫送押尼珥平安上路。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","这时，约押和大卫的部下正好作战归来，带回大量的战利品。大卫已经送押尼珥平安上路，他已经不在希伯仑了。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","约押率领部下回到希伯仑，有人告诉他：尼珥的儿子押尼珥已经来见过王，并且王已经送他平安离去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","约押来见王，说∶“你都做了些什么？瞧，押尼珥来见你，你怎么能让他走？现在他逃掉了！ ");
INSERT INTO cmn2006_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","你要明白，尼珥的儿子押尼珥是来欺骗你的；他来察看你的动静，好查清你的一举一动。” ");
INSERT INTO cmn2006_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","约押离开大卫，派人去追赶押尼珥，把他从西拉井带了回来。大卫不知道这件事。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","押尼珥回到希伯仑后，约押把他带到城门洞里，假装要跟他商谈机密，用短剑刺进他的腹部，杀死了他，报了他兄弟亚撒黑被杀之仇。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","事情过后，大卫得到消息，他说∶“主知道我和我的王国对于尼珥的儿子押尼珥的死是完全无辜的。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","愿他的死报应在约押和他的家族身上。愿约押的家族总有人或生麻疯，或患漏症，或只能架拐行路，或死于刀剑之下，或缺衣少食。” ");
INSERT INTO cmn2006_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","就这样，约押和他的兄弟亚比筛害死了押尼珥，因为他曾在基遍之战中杀死了他们的兄弟亚撒黑。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","大卫命令约押和他的部下∶“你们都撕裂衣服，穿上麻衣，为押尼珥引葬举哀。”大卫王亲自跟在棺后为押尼珥送葬。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","押尼珥葬在希伯仑。王在押尼珥墓前放声大哭，所有的人都落了泪。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","王为押尼珥唱了一首挽歌： “押尼珥为何竟死得象无知之人一样？ ");
INSERT INTO cmn2006_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","你的双手没有被捆， 你的双脚没有被绑； 但你却倒下了， 跟死在奸徒手下的人没有两样！” 人们又为押尼珥痛哭。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","人们都劝大卫吃些东西，当时正是白天；大卫发誓说∶“如果我在太阳落山之前吃饼或其他东西，愿上帝重重地惩罚我！” ");
INSERT INTO cmn2006_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","人们听了王的话都很高兴；王的一言一行他们都很满意。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","当天，全体以色列人都知道了王并没有参与谋杀尼珥的儿子押尼珥。 ");
INSERT INTO cmn2006_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","王又对部下说∶“你们有没有意识到以色列今天失去了一位高尚而伟大的人？ ");
INSERT INTO cmn2006_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","我现在虽然受膏为王却还心慈手软，洗鲁雅的这两个儿子太强横了，愿主按照作恶者的恶行报应他们！” ");
INSERT INTO cmn2006_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","扫罗的儿子伊施波设听说押尼珥在希伯仑被杀，吓得魂飞魄散，其他以色列人也都惶惶不安。 ");
INSERT INTO cmn2006_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","伊施波设手下有两个带兵的将领，一个叫巴拿，另一个叫利甲，他们是便雅悯支派比录人临门的儿子。（比录隶属于便雅悯， ");
INSERT INTO cmn2006_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","原先的比录人已经逃往基他音，并在那里一直寄居到现在。） ");
INSERT INTO cmn2006_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","扫罗的儿子约拿单有一个双腿残废的儿子，名叫米非波设。扫罗和约拿单的死讯从耶斯列传来的时候，他才五岁。他的奶妈抱着他逃跑，慌忙中把他跌在地上，从此瘸了腿。 ");
INSERT INTO cmn2006_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","比录人临门的儿子利甲和巴拿去见伊施波设，正午时分到了伊施波设的住所；当时伊施波设正在午睡。 ");
INSERT INTO cmn2006_vpl VALUES ("S24_6","011_4_6","2SA","4","6","7","他们假装要取麦子，进了内室，趁伊施波设睡觉时用短剑刺进他的腹部，杀死了他。然后，他们割下伊施波设的头，连夜取道亚拉巴， ");
INSERT INTO cmn2006_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","带着伊施波设的头到希伯仑来见大卫。他们对大卫王说∶“这儿就是陛下的仇敌扫罗的儿子伊施波设的首级；扫罗曾想要陛下的性命，今天，主为陛下向他和他的后裔复了仇。” ");
INSERT INTO cmn2006_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","大卫对比录人临门的儿子巴拿和他的兄弟利甲说∶“我指着救我脱离一切灾难的活生生的主发誓， ");
INSERT INTO cmn2006_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","在洗革拉的时候，有一个人向我报告‘扫罗死了，’自以为带来了喜讯；我抓住他，把他处死了，那就是他报信的酬报， ");
INSERT INTO cmn2006_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","何况恶徒在无辜人自己的屋子里把他杀死在自己的床上！难道我不应该向你们讨还血债，把你们从世界上除掉吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","大卫命令部下把他们杀了，砍断了他们的手脚，把尸体吊在希伯仑的池旁。然后，把伊施波设的头葬在希伯仑押尼珥的墓地里。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","以色列各支派都到希伯仑来见大卫，对他说∶“我们都是你的骨肉同胞。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","当初扫罗执掌王权的时候，就是你率领以色列人出入征战的。主曾应许你：‘你要牧养我的以色列子民，要治理他们。’” ");
INSERT INTO cmn2006_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","以色列的长老们都到希伯仑来见大卫王，与大卫王在主的面前立约，膏立他为以色列之王。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","大卫三十岁登基，在位四十年。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","在希伯仑统治犹大七年半，在耶路撒冷统治全以色列和犹大三十三年。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","大卫王率领部下向耶路撒冷进军，准备攻打住在那里的耶布斯人。耶布斯人对大卫说∶“你永远也进不了这城；就连瞎子和瘸子都能打退你！” ");
INSERT INTO cmn2006_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","然而，大卫却攻取了锡安堡，也就是大卫城。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","大卫在那天说过∶“谁想打耶布斯人，谁就得从水道里上去接近这些大卫所憎恶的‘瞎子和瘸子’。”因此，俗语流传说∶“瞎子和瘸子登不上殿堂。” ");
INSERT INTO cmn2006_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","随后，大卫住进了城堡，并将它命名为“大卫城”，又在米罗以内修建了环城城墙。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","大卫一天比一天强盛，因为主－全能的上帝与他同在。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","推罗王希兰派使者带着香柏木和石匠、木匠去见大卫，为大卫起造王宫。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","大卫知道主为了自己子民的缘故而立他为以色列之王，并使他的王国强盛。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","大卫离开希伯仑后，在耶路撒冷又立了许多后妃，生了许多儿女。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","在耶路撒冷生的儿子是：沙母亚、朔罢、拿单、所罗门、 ");
INSERT INTO cmn2006_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","益辖、以利书亚、尼斐、雅非亚、 ");
INSERT INTO cmn2006_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","以利沙玛、以利雅大、以利法列。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","非利士人听说大卫已经被膏立为以色列王，倾全军来向大卫索战。大卫得到消息，进入要塞。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","非利士人到达以后，沿利乏音谷展开。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","大卫求问主∶“我该不该去攻打非利士人？你会把他们交给我吗？” 主答道∶“去吧，我一定把非利士人交给你。” ");
INSERT INTO cmn2006_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","于是，大卫出兵巴力比拉心，打败了非利士人。大卫说∶“主势如洪水，冲垮了我面前的仇敌。”所以，那地方被叫做“巴力比拉心”。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","非利士人把偶像丢弃在那里，大卫和他的部下把它们清除掉了。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","非利士人又一次进兵利乏音谷。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","大卫求问主，主说∶“不要正面交锋；迂回到他们后面去，从桑树林前面向他们攻击。 ");
INSERT INTO cmn2006_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","你一听到桑树林的树稍上有脚步声，那就是主已经在你之前去打击非利士军队了，你要立即出兵。” ");
INSERT INTO cmn2006_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","大卫按照主的命令行事，打垮了非利士人，从迦巴一直追杀到基色。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","大卫又召集三万名以色列精兵， ");
INSERT INTO cmn2006_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","率领他们到犹大的巴拉去，要从那里迎回主上帝的约柜，也就是奉全能的主的名的柜，主就设座于柜顶的两基路伯之上。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","他们把约柜放在一辆新车上，从山上亚比拿达的家里运出来，亚比拿达的两个儿子－乌撒和亚希约引导装载约柜的车， ");
INSERT INTO cmn2006_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","亚希约走在车的前面。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","大卫和全体以色列人都在主的面前尽情欢乐，唱着歌，弹起竖琴、七弦琴，打起铃鼓、响板、铙钹。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","他们来到拿康的打麦场时，拉车的牛绊了一下，乌撒伸手扶住约柜。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","主为了乌撒的不敬举动向他发怒，击杀了他；他死在约柜的旁边。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","大卫因为主向乌撒发怒而心中郁闷，因此，那地方至今一直叫做比列斯乌撒。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","那天，大卫对主心存惧意，说∶“我怎么敢把约柜运到我这里来？” ");
INSERT INTO cmn2006_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","他不愿让约柜运进大卫城跟他在一起；转而把约柜送到迦特人俄别以东的家里。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","约柜在俄别以东家里停留了三个月，主赐福给俄别以东和他的整个家族。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","大卫王得到报告∶“由于约柜的缘故，主赐福给俄别以东的整个家族和属于他的一切。”于是，大卫王就高高兴兴地把约柜从俄别以东家里接往大卫城中。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","抬约柜的人每走六步，大卫就献上了一只公牛和一只肥牛犊， ");
INSERT INTO cmn2006_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","大卫身穿一件麻纱以弗得，在主的面前尽力跳舞。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","就这样，大卫和全体以色列人一起在欢呼声和号声中迎进主的约柜。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","主的约柜运进大卫城的时候，扫罗的女儿米甲从窗户里向外观看，看见大卫王在主的面前跳跃舞蹈，从心里看不起他。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","人们把约柜抬到大卫预备好的帐蓬里安置好，大卫向主献上了烧化祭和平安祭。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","献祭完毕以后，大卫奉全能的主的名祝福人民， ");
INSERT INTO cmn2006_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","并发给全体以色列人不分男女每人一块饼、一块会期饼和一个葡萄饼。人们都各自回家去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","大卫回家去为自己的家人祝福，扫罗的女儿米甲出来迎接他，说∶“以色列王今天在你臣仆的婢女面前象个下贱人一样解衣露体，真是威严有加啊！” ");
INSERT INTO cmn2006_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","大卫答道∶“那是在主的面前；主拣选了我而不是你父亲或他家族里的其他人，他立我做主的子民的领袖，治理以色列，我要为主而起舞。 ");
INSERT INTO cmn2006_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","我还要做比这更卑微的事，使自己变得更谦卑，而你提到的那些婢女却会尊敬我。” ");
INSERT INTO cmn2006_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","扫罗的女儿米甲终生没有生育子女。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","王安居在宫中，主赐给他四境平安。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","王对先知拿单说∶“瞧，我现在住在香柏木的宫殿里，上帝的约柜却还留在帐蓬里。” ");
INSERT INTO cmn2006_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","拿单答道∶“你有什么想法就去做吧！因为主与你同在。” ");
INSERT INTO cmn2006_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","当夜，主默示拿单，说∶ ");
INSERT INTO cmn2006_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“你去告诉我的仆人大卫，‘主是这样说的：你不是为我建造居所的人选。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","我自把以色列人领出埃及起直到今天，从来没有住过殿宇。我一直住在帐幕里，从一个地方搬到另一个地方。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","无论我随以色列人走到哪里，可曾对任何一个我命令他牧养我以色列子民的首领说过∶“你为什么不为我建造一座香柏木的居所？”’ ");
INSERT INTO cmn2006_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","“现在，你去告诉我的仆人大卫，‘全能的主是这样说的：我把你从放羊的牧场上召来，立你做我的以色列子民的领袖。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","在过去的岁月里，无论你到哪里，我都一直与你同在，除掉了你所有的仇敌；将来，我还要使你声威赫赫，跟世上最伟大的人物齐名。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","我要给我的以色列子民选定一个地方，把他们安置在那里，让他们拥有自已的家园，不再颠沛流离，恶人再不能象我选立士师治理我的以色列子民时代那样欺压他们。我将赐给你安宁，让你不再受任何仇敌的骚扰。’ “‘主晓喻你，他要亲自坚立你的王室， ");
INSERT INTO cmn2006_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","当你寿满而终返归列祖之后，我要选立你的后代继承你的王位，他必是你的亲骨血，而我必坚立他的王国， ");
INSERT INTO cmn2006_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","他才是为我的名建造殿宇的人，我将使他的王权千秋永存。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","我要做他的父亲，他要做我的儿子，如果他做了错事，我会藉世人的杖去惩罚他，藉世人施加的痛苦去鞭笞他。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","但是，我不会收回对他的爱，象我为你废掉扫罗收回了对他的爱一样。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","你的家族和你的王国将永远在我的庇护之下，你的王权将千秋永存。’” ");
INSERT INTO cmn2006_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","拿单把主的默示都告诉了大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","于是，大卫来到主的面前，坐下祈祷： “至高的主啊，我算得了什么？我的家族又算得了什么？你竟给我这样的厚爱？ ");
INSERT INTO cmn2006_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","至高的主啊，你似乎觉得这还不够，又应许了你仆人家室的未来。至高的主啊，你惯常这样对待世人吗？ ");
INSERT INTO cmn2006_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","对你，我还能再说些什么？至高的主啊，你了解你的仆人。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","为了你应许过的话，出于你的意志，你做了这伟大的事业，并将它明示给你的仆人。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","至高的主啊，你多么伟大！没有谁能跟你相比。我们一向知道，除了你，没有别的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","世上哪一个民族能跟你的以色列子民相比？你亲自把他们从埃及救出来，让他们做你的子民；你为他们驱逐列国赶走异神，施行大而可畏神迹，显露了你的威名。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","你拣选以色列永远作你的子民，而你，主啊，你做他们的上帝。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","主上帝啊！求你永远信守你对你的仆人和他家族的应许，履行你的诺言， ");
INSERT INTO cmn2006_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","好让你的名永受尊崇。那时，人们会赞颂：‘全能的主是掌管以色列的上帝！’而你的仆人大卫的家族将在你面前坚立。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","全能的主啊，以色列的上帝，你启示你的仆人说：‘我必坚立你的王室’，因此，你的仆人才敢这样大胆地向你祷告。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","至高的主啊，你是上帝！你的话真实可信，你应许把这福泽赐给你的仆人。 ");
INSERT INTO cmn2006_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","求你现在就赐福给你仆人的全家，让这福泽在你的面前代代相传；因为你－至高的主，已经应许，你仆人的家族将永远承受你的恩宠。” ");
INSERT INTO cmn2006_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","不久，大卫打败了非利士人，征服了他们，夺取了非利士人控制的大片土地。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","大卫还打败了摩押人。他让他们躺在地上，用一根长绳量他们，每量三次，前两次量到的人都被处死，只让第三次被量到的人留下来。摩押人被迫向大卫称臣进贡。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","利合的儿子、琐巴王哈大底谢出兵，想要夺回对幼发拉底河流域的控制权。大卫打败了他， ");
INSERT INTO cmn2006_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","俘掳了战车一千辆，车兵七千人，步兵两万人。大卫只留下够拉一百辆战车的马，其余的马都被砍断了蹄筋。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","大马士革的亚兰人驰援琐巴王哈大底谢，被大卫消灭了两万两千人。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","大卫向大马士革的亚兰王国派驻军队，亚兰人被迫向大卫称臣进贡。主使大卫无往不胜。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","大卫缴获了哈大底谢的将领们的金盾牌，带回耶路撒冷。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","又从哈大底谢辖下的比他城和比罗他城夺取了大量的铜。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_9","011_8_9","2SA","8","9","10","哈大底谢跟哈马王一直处于敌国状态，哈马王陀以听说大卫打垮了哈大底谢全军，就派儿子约兰去见大卫王，向他致意，祝贺他的胜利，并带去了各种金器、银器、铜器。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_11","011_8_11","2SA","8","11","12","大卫王把这些器皿连同他征服以东人、摩押人、亚扪人、非利士人、亚玛力人以后掠得的金银，以及从利合的儿子琐巴王哈大底谢那里缴获的战利品，都献给了主。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","大卫在盐谷歼灭了一万八千名以东人，归来以后声威更加显赫。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","大卫向以东全境派驻了军队，所有的以东人都向大卫称臣。主使大卫无往不胜。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","大卫统治全以色列，以公正和正义治理人民。 ");
INSERT INTO cmn2006_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","洗鲁雅的儿子约押统帅军队；亚希律的儿子约沙法任史官； ");
INSERT INTO cmn2006_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","亚希突的儿子撒督和亚比亚他的儿子亚希米勒任祭司；西莱雅任书记官； ");
INSERT INTO cmn2006_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","耶何耶大的儿子比拿雅统辖基利提人和比利提人；大卫的儿子们都供职祭司。 司。 ");
INSERT INTO cmn2006_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","大卫问∶“扫罗家族还有没有人剩下？如果有，我要为了约拿单的缘故善待他们。” ");
INSERT INTO cmn2006_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","扫罗家族以前有一个仆人，名叫洗巴，人们带他去见大卫。王问他∶“你是洗巴吗？”他答道∶“是的，陛下。” ");
INSERT INTO cmn2006_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","王问∶“扫罗家族难道就没有一个人剩下来，让我可以把上帝的慈爱显示给他吗？” 洗巴答道∶“约拿单还有一个儿子，可他的两条脚都瘸了。” ");
INSERT INTO cmn2006_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","王问∶“他现在在哪儿？” 洗巴答道∶“他现在在罗底巴地方，亚米利的儿子玛吉的家里。” ");
INSERT INTO cmn2006_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","于是，大卫王派人把他从罗底巴亚米利的儿子玛吉家里接了来。 ");
INSERT INTO cmn2006_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","扫罗的孙子、约拿单的儿子米非波设见了大卫，倒身下拜。大卫叫他∶“米非波设！”他答道∶“臣在。” ");
INSERT INTO cmn2006_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","大卫对他说∶“别害怕，为了你父亲约拿单的缘故，我一定会厚待你。我要把你祖父扫罗的土地都赐还给你，你要经常来跟我一起吃饭。” ");
INSERT INTO cmn2006_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","米非波设向大卫叩拜，说∶“臣不过如一条死狗，竟蒙陛下如此恩待！” ");
INSERT INTO cmn2006_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","王又召见扫罗的旧日仆人洗巴，吩咐他说∶“我已经把你主人扫罗和他家族的一切都赐给了你主人的孙子米非波设。 ");
INSERT INTO cmn2006_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","你和你的儿子们以及你的仆人们要为他种地，收庄稼，使你主人的孙子衣食无缺，而米非波设本人要时常到这里跟我一起吃饭。”（洗巴有十五个儿子，二十个仆人。） ");
INSERT INTO cmn2006_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","洗巴答道∶“臣遵命照办。”米非波设跟王一起吃了饭，就象王的儿子一样。 ");
INSERT INTO cmn2006_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","米非波设有一个小儿子，名叫米迦。洗巴家里的人都成了米非波设的仆人。 ");
INSERT INTO cmn2006_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","米非波设在耶路撒冷住了下来，他定期去跟王一起吃饭。米非波设是个两腿残废的人。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","不久，亚扪王拿辖死了，他的儿子哈嫩继位。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","大卫想∶“我要对哈嫩表示友好，就象他父亲生前对我友好一样。”因此，大卫派了一个代表团前往吊唁，对哈嫩表示慰问。 大卫的人刚到达亚扪国土， ");
INSERT INTO cmn2006_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","亚扪的贵族们就对他们的主人哈嫩说∶“你以为大卫派这些人来是吊唁先王，慰问你的吗？谁知道大卫是不是派他们来踏勘城池，刺探虚实，图谋颠覆的？” ");
INSERT INTO cmn2006_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","哈嫩逮捕了大卫的使者，把每个人都剃掉半边胡须，割掉下半截衣服，然后驱逐出境。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","大卫得到消息，派人去见这些受了奇耻大辱的使者，对他们说∶“你们先留在耶利哥吧，等胡须长长了再回来。” ");
INSERT INTO cmn2006_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","亚扪人知道他们已经跟大卫结怨，就从伯利合和琐巴雇佣了两万名亚兰步兵，从陀伯雇佣了一万两千人，又从玛迦王那里雇佣了一千人。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","大卫得到消息，派约押率领全军出战。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","亚扪人出兵，在城门口摆开阵势，伯利合和琐巴的亚兰军队和陀伯及玛迦的军队各自在郊外布阵。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","约押见自己腹背受敌，就派出以色列最精锐的部队对抗亚兰人， ");
INSERT INTO cmn2006_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","其他部队则交给他的弟弟亚比筛统领，命令他们对付亚扪人。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","约押说∶“如果亚兰人占了我的上风，你们就过来援救我；如果你们抵挡不住亚扪人，我就去援救你们。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","拿出勇气来，为我们的人民，我们的城市，我们的上帝去拼杀吧！主会按照他的意愿行事的。” ");
INSERT INTO cmn2006_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","约押带领军队进攻亚兰人；亚兰人败退了。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","亚扪人看见亚兰人已经溃退，也败给了亚比筛，退回城里。约押也收兵返回耶路撒冷。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","亚兰人见自己败给了以色列人，就重新集结军队。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","哈大底谢王命人把幼发拉底河彼岸的军队调来，由哈大底谢的元帅朔法率领，进驻希兰。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","大卫得到消息，调集全部以色列军队，渡过约旦河，开往希兰。亚兰人摆开阵势迎战大卫王。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","大卫击溃了亚兰人，杀死了七百名车兵和四万名步兵，敌军统帅朔法也被当场击毙。 ");
INSERT INTO cmn2006_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","哈大底谢附属国的诸王见自己已经败给了以色列人，就跟以色列人讲和，归附以色列人。从此，亚兰人再也不敢帮亚扪人。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","第二年春天，正当列王争战之际，大卫派约押率领诸将领和以色列全军攻打亚扪人，围困了拉巴城。大卫自己则留在耶路撒冷。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","一天傍晚，大卫起床后在宫殿的屋顶平台上散步，望见一个女人正在沐浴，那女人十分美丽。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","大卫派人去查明她是谁，那人回报说∶“她叫拔示巴，是以连的女儿、赫人乌利亚的妻子。” ");
INSERT INTO cmn2006_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","大卫就派人去接她。拔示巴来见大卫，大卫跟她一起睡了觉。（那时，拔示巴的月经刚刚洁净）。事后，拔示巴回家去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","不久，她发觉自己怀了孕，就派人送信给大卫，告诉他∶“我怀孕了。” ");
INSERT INTO cmn2006_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","大卫派人通知约押∶“叫赫人乌利亚到我这里来！”约押派乌利亚去见大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","乌利亚到了以后，大卫问了问约押和部队的情况，又问了问战况进展， ");
INSERT INTO cmn2006_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","然后对他说∶“你回家团聚一下吧！”乌利亚离开了王宫，王又派人给他送来一份礼物。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","可是，乌利亚没有回家，他跟其他臣仆一起睡在王宫门前。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","有人报告大卫∶“乌利亚没有回家。”王问乌利亚∶“你刚从远方回来，为什么不回家休息一下？” ");
INSERT INTO cmn2006_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","乌利亚答道∶“主的约柜和以色列人及犹大人都呆在帐蓬里，我的上司约押和陛下的战士们都在露天宿营，我怎敢回家吃喝，拥妻而卧？我向陛下发誓，我决不会做这样的事！” ");
INSERT INTO cmn2006_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","大卫对他说∶“你在这儿再呆一天吧，明天我派你回去。” 乌利亚在耶路撒冷又停留了一天。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","大卫请他赴宴，又吃又喝，把他灌醉了。可到了晚上，乌利亚又跑回来，仍旧跟其他臣仆一起睡在自己的毯子上，依然没有回家。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","第二天一早，大卫写了一封信，让乌利亚带给约押。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","大卫在信中命令∶“把乌利亚派到前线战斗最激烈的地方去，然后，你们撤退，让他战死！” ");
INSERT INTO cmn2006_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","于是，约押攻城的时候，故意把乌利亚派到敌军兵力最强的地方去。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","城里的敌军出城攻击约押，大卫的一些部下战死了，赫人乌利亚也在其中。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","约押派人向大卫详细呈报战况； ");
INSERT INTO cmn2006_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","他指示使者∶“你向王汇报完整个战事经过之后， ");
INSERT INTO cmn2006_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","王可能会发怒，责问你：‘为什么你们打仗时靠城那么近？难道不知道敌军会从城墙上射箭吗？ ");
INSERT INTO cmn2006_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","是谁杀死了耶路比设的儿子亚比米勒？还不是一个妇女从城墙上扔下一块磨盘石，打在他的头上，使他死在提备斯？你们为什么靠城墙这么近？’如果他这样问你，你就回答说：‘陛下的臣仆赫人乌利亚也死了。’” ");
INSERT INTO cmn2006_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","使者到了大卫那里，按照约押吩咐的话奏告大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","他对大卫说∶“敌军占了我们的上风，他们冲出城来跟我们在野外交战，但我们把他们赶回到城门口。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","敌军射手从城墙上放箭，陛下的一些部下阵亡了，赫人乌利亚也死了。” ");
INSERT INTO cmn2006_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","大卫对使者说∶“你告诉约押：‘不必因此烦恼，刀剑无情，生死难以预料。加紧攻城，打下它。’你用这话去鼓励约押。” ");
INSERT INTO cmn2006_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","乌利亚的妻子听说丈夫死了，哀伤不已。 ");
INSERT INTO cmn2006_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","居丧期满之后，大卫把她接到宫中。拔示巴就此成了大卫的妻子，给他生下一个儿子。主对大卫做的这件事十分不悦。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","主差遣拿单去见大卫。拿单见了大卫，对他说∶“在一座城里有两个人，一贫一富。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","那个富人有很多牛羊， ");
INSERT INTO cmn2006_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","而那个穷人除了一只从小买来的母羊羔外一无所有。他喂养它，让它呆在自己身边，跟自己的儿女一起长大。他把自己的食物分给小羊吃，让它喝自己杯子里的水，睡在自己的怀里，就象是他的女儿。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","有一天，富人家里来了客人，他舍不得从自己的牛羊群中拿一只去招待来访的客人，却抢走了穷人的母羊羔，用它招待自己的客人。” ");
INSERT INTO cmn2006_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","大卫对那富人非常愤恨，对拿单说∶“我指着活生生的主起誓，做这事的人该死！ ");
INSERT INTO cmn2006_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","他竟然做出这种事，毫无怜恤之心；他应该偿还羊羔所值的四倍！” ");
INSERT INTO cmn2006_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","拿单对大卫说∶“你就是那富人！主－以色列的上帝是这样说的：‘我把你从扫罗的手中解救出来，膏立你为以色列之王。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","我把你故主的基业赐给了你，把他的嫔妃交到你的怀里，把以色列人和犹大人都赐给了你。如果这一切还不够，我本来还会给你更多的赏赐。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","可是，你为什么要藐视主的话，做他所憎恶的事？你谋害了乌利亚，把他的妻子据为己有。你藉亚扪人的刀杀死了他！ ");
INSERT INTO cmn2006_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","因此，你的家族难逃刀兵之灾，因为你藐视我，抢了赫人乌利亚的妻子。’ ");
INSERT INTO cmn2006_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","主又说：‘看吧！我要使你自己家族内部作乱危害你，我要当着你的面把你的嫔妃交给你最亲密的人，让他跟她们在光天化日之下睡觉。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","你干这事是偷偷摸摸干的，我却要在光天化日之下，当着全体以色列人的面做这件事！’” ");
INSERT INTO cmn2006_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","大卫对拿单说∶“我得罪主了！” 拿单答道∶“主已经免去了你的罪，你不会因此而死。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","但是，你做这件事极大地侮慢了主，你生下的儿子必死。” ");
INSERT INTO cmn2006_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","说完，拿单就回家去了。 主把灾祸降在乌利亚的妻子给大卫生的儿子身上，使他害了病。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","大卫为了孩子向上帝恳求，他禁食，把自己关在房间里，整夜躺在地上。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","家族中的长老们站在他身边，劝他从地上起来，他不听，也不吃他们拿来的东西。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","到第七天，孩子死了，大卫的侍从们不敢把孩子的死讯告诉他，他们想∶“孩子活着的时候我们跟他说话他都不理，怎么能再告诉他孩子死了的事？说不定他会做出什么绝望的举动来。” ");
INSERT INTO cmn2006_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","大卫觉察侍从们在交头接耳，猜到孩子已经死了，就问∶“是不是孩子死了？”人们答道∶“是的，孩子死了。” ");
INSERT INTO cmn2006_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","大卫听了以后，就从地上起来，梳洗、沐浴、换衣服，然后到圣殿中向主敬拜。随后，他回到家里，让侍从们摆上饭来。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","侍从们问他∶“你这番举动是什么意思？孩子活着的时候，你禁食痛哭；现在孩子死了，你反倒起来吃东西了！” ");
INSERT INTO cmn2006_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","大卫答道∶“孩子活着的时候我禁食痛哭，因为我想：‘说不定主会对我宽大为怀，让孩子活下来。’ ");
INSERT INTO cmn2006_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","现在孩子死了，我何必再禁食？我能够让他死而复生吗？我终究要到他那里去，他却不可能再回到我这里来了！” ");
INSERT INTO cmn2006_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","大卫安慰妻子拔示巴，他去看她，跟她同房。她又生了一个儿子，他们给他起名叫所罗门。主爱这孩子， ");
INSERT INTO cmn2006_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","吩咐先知拿单给他起名叫耶底底亚，因为主喜爱他。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","与此同时，约押攻打亚扪人的拉巴城，已经占领了禁城。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","他派人去向大卫报告∶“我攻打拉巴，已经控制了它的水源。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","请陛下带兵来攻取这城。否则，我攻下了这城，这城就会以我的名字命名了。” ");
INSERT INTO cmn2006_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","于是，大卫调集全军前去攻占了拉巴城。 ");
INSERT INTO cmn2006_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","他缴获了亚扪王的王冠。王冠由32公斤黄金制成，上面镶满了宝石；人们把王冠戴在大卫的头上。大卫从城中掠走了大量的战利品， ");
INSERT INTO cmn2006_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","又把城里的人押出城外，强迫他们用锯、铁耙、斧子做工，或在砖窑里做工。大卫用同样的方式对待所有的亚扪人城镇。随后，大卫率领全军返回耶路撒冷。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","大卫的儿子押沙龙有一个妹妹，名叫塔玛，长得美貌动人，大卫的另一个儿子暗嫩爱上了她。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","暗嫩为了塔玛憔悴成疾。塔玛还是个处女，暗嫩难以对她有所举动。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","暗嫩有个朋友，名叫约拿达，他是大卫的哥哥示米亚的儿子，为人极其狡诈。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","他问暗嫩∶“殿下为什么一天比一天憔悴？可不可以告诉我？” 暗嫩对他说∶“我爱上了塔玛；她是我异母兄弟押沙龙的妹妹。” ");
INSERT INTO cmn2006_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","约拿达说∶“你躺在床上装病吧，你父亲来看你的时候，你对他说：‘我想让我妹妹塔玛来做东西给我吃。让她就在我的眼前做；我要看着她做，然后让她亲手拿给我吃。’” ");
INSERT INTO cmn2006_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","于是暗嫩躺在床上装病。王来探看他，他对王说∶“请让我的妹妹塔玛到这儿来吧，让她就在我的眼前替我做饼，我要她亲手拿给我吃。” ");
INSERT INTO cmn2006_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","于是大卫派人到宫里告诉塔玛∶“你到你哥哥暗嫩那里去，给他做点东西吃。” ");
INSERT INTO cmn2006_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","塔玛来到暗嫩房里；暗嫩正躺在床上。塔玛就在暗嫩的眼前揉面、做饼，然后拿去烤。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","她取下烤盘，拿饼给暗嫩吃。他却不肯吃，说∶“叫其他人都走开！”人们都离开了。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","暗嫩对塔玛说∶“你把饼拿到我卧房里来，我要你亲手喂我吃。”塔玛拿着烤好的饼进了她哥哥暗嫩的卧房。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","她拿饼给他吃，他却搂住她，说∶“妹妹，跟我睡觉吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","塔玛说∶“别这样，哥哥，别强迫我。在以色列不允许有这样的事，别做这种丑事。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","我以后怎么办？到哪儿去除掉我的耻辱？你以后又该如何？你会被以色列人看作邪恶而愚蠢的人。去向王说明吧，他一定不会阻止我嫁给你。” ");
INSERT INTO cmn2006_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","可是暗嫩不听；他恃仗力气大，把她强奸了。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","事过之后，暗嫩又极其厌恶她；其程度比爱她时更甚。他对塔玛说∶“起来！滚出去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","塔玛答道∶“不！你现在赶我走，这罪比你刚才对我所犯的更大！” 暗嫩不理睬她， ");
INSERT INTO cmn2006_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","他叫来贴身仆从，说∶“把这女人从这里赶出去！闩上大门！” ");
INSERT INTO cmn2006_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","仆从把塔玛推出门外，闩上了大门。塔玛当时穿着未婚公主穿的彩衣； ");
INSERT INTO cmn2006_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","她撕裂彩衣，把灰撒在头上，用手抱着头一边走一边放声痛哭。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","她的胞兄押沙龙问她∶“是不是你哥哥暗嫩和你在一起了？别哭了，妹妹，他是你的异母哥哥，别把这事放在心上。”塔玛孤孤单单地住在哥哥押沙龙的家里。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","大卫王知道了这件事，非常恼怒。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","押沙龙并不和暗嫩说好说歹，但是他恨他，因为暗嫩玷污了他的妹妹塔玛。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","两年以后，押沙龙在靠近以法莲边界的巴力夏琐雇人剪羊毛，邀请众王子到那里去。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","押沙龙去见王，说∶“臣请人来剪羊毛，特请陛下和众大臣与臣同往。” ");
INSERT INTO cmn2006_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","王答道∶“我儿，我们都不必去了，我们只会给你增添麻烦。”王坚持不肯去，只是为押沙龙祝福。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","押沙龙说∶“如果王一定不肯去，请让我的哥哥暗嫩跟我们一起去吧！” 王问∶“何必要他跟你一起去呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","但押沙龙再三坚持，王就派暗嫩和其他王子跟押沙龙一起去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","押沙龙命令部下∶“听着！暗嫩饮酒正酣的时候，我对你们说：‘干掉暗嫩！’你们就杀死他。别怕，这不是我给你们的命令吗？你们只管放手大胆地干好了。” ");
INSERT INTO cmn2006_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","押沙龙的部下按照他的命令杀死了暗嫩。其他王子都骑上骡子逃了。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","众王子还在路上的时候，大卫得到报告∶“押沙龙杀了众王子，一个也没有留下！” ");
INSERT INTO cmn2006_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","王惊立起来，撕裂衣服，躺倒在地上。众侍从也都撕裂衣服，站在一旁。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","大卫的哥哥示米亚的儿子约拿达说∶“陛下不必以为众王子都已遇害；只不过暗嫩一人被杀。自从暗嫩奸污押沙龙的妹妹塔玛以后，押沙龙就立意要杀他。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","陛下不必为众王子都已遇害的消息担忧；只有暗嫩一人被杀。” ");
INSERT INTO cmn2006_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","押沙龙当时就逃走了。这时，哨兵发现西面的大道上许多人正沿着山坡走下来，急忙向王报告∶“我看见何罗念方向的山坡上有人。” ");
INSERT INTO cmn2006_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","约拿达对王说∶“瞧，众王子回来了；事情跟臣预料的一样。” ");
INSERT INTO cmn2006_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","他刚说完，众王子就进来了，他们放声大哭；王和众臣仆也都痛哭失声。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_37","011_13_37","2SA","13","37","37","押沙龙逃到亚米忽的儿子、基述王达买那里。大卫天天为他的儿子哀痛。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_38","011_13_38","2SA","13","38","38","押沙龙逃到基述，在那里住了三年。 ");
INSERT INTO cmn2006_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","大卫渐渐接受了暗嫩已死的这个事实，他对押沙龙的恼怒也渐渐平复了。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","洗鲁雅的儿子约押知道王心中想念押沙龙， ");
INSERT INTO cmn2006_vpl VALUES ("S214_2","011_14_2","2SA","14","2","2","于是，他派人到提哥亚找来一个聪明的女人，对她说∶“你假装居丧，穿上丧服，不要涂任何化妆品，就象一个已经为死者哀伤很久了的女人。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_3","011_14_3","2SA","14","3","3","然后，你去见王，把这些话说给他听。”约押把该说的话教给了那女人。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_4","011_14_4","2SA","14","4","4","提哥亚来的那女人去见王，俯伏在地上向王跪拜，说∶“陛下啊，请帮帮我！” ");
INSERT INTO cmn2006_vpl VALUES ("S214_5","011_14_5","2SA","14","5","5","王问她∶“你有什么为难的事？” 她答道∶“我是个寡妇，丈夫死了。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_6","011_14_6","2SA","14","6","6","奴婢有两个儿子，有一天他们在田里打了起来，当场没有旁的人去劝开他们，结果一个儿子把另一个杀死了。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_7","011_14_7","2SA","14","7","7","现在整个宗族都跟奴婢作对，他们说：‘把那个杀死兄弟的人交出来！我们要把他治死，即便断宗绝嗣也要为被他杀死的兄弟抵命！’他们要扑灭我残留的这唯一的火种，使我丈夫的姓氏和他的后代都从此断绝了。” ");
INSERT INTO cmn2006_vpl VALUES ("S214_8","011_14_8","2SA","14","8","8","王对那女人说∶“你回家去吧，我会亲自下令为你处理这件事的。” ");
INSERT INTO cmn2006_vpl VALUES ("S214_9","011_14_9","2SA","14","9","9","那提哥亚女人又说∶“陛下啊，愿罪责落在我和我的家族的身上，王和王手中的权力是无可指责的。” ");
INSERT INTO cmn2006_vpl VALUES ("S214_10","011_14_10","2SA","14","10","10","王答道∶“如果有人对你再说什么，把他带来见我好了，他不会再打扰你。” ");
INSERT INTO cmn2006_vpl VALUES ("S214_11","011_14_11","2SA","14","11","11","她说∶“愿陛下向主－你的上帝祈求，不要让复仇者施行毁灭，这样，我的儿子就不至于死了。” 大卫说∶“我指着存在的上帝发誓，你儿子连一根头发也不会掉。” ");
INSERT INTO cmn2006_vpl VALUES ("S214_12","011_14_12","2SA","14","12","12","那女人说∶“请允许奴婢再进一言。” 王答道∶“说吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S214_13","011_14_13","2SA","14","13","13","那女人说∶“既然如此，陛下为什么要用同样的方式对待上帝的子民呢？陛下不让自己被放逐的儿子回来，那么陛下刚才的这番话，岂不是给自己定了罪？ ");
INSERT INTO cmn2006_vpl VALUES ("S214_14","011_14_14","2SA","14","14","14","我们都会死的，就象泼水难收一样，但上帝并不愿取走人的性命，相反，他设法使被放逐的人不至同他疏远。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_15","011_14_15","2SA","14","15","15","我现在到这里对陛下说这番话，是因为世人使我感到害怕。奴婢想：‘我要去向王诉说，或许王能应允奴婢的请求， ");
INSERT INTO cmn2006_vpl VALUES ("S214_16","011_14_16","2SA","14","16","16","愿意把我和我儿子从那些想把我们从上帝赐给我们的产业上除掉的人手中解救出来。’ ");
INSERT INTO cmn2006_vpl VALUES ("S214_17","011_14_17","2SA","14","17","17","现在，我要说：‘愿陛下的话能给我带来安宁，因为陛下象上帝的天使一样明辨是非。愿主－你的上帝与你同在。” ");
INSERT INTO cmn2006_vpl VALUES ("S214_18","011_14_18","2SA","14","18","18","王对那女人说∶“我问你的话你要如实回答我。” 那女人答道∶“请陛下问吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S214_19","011_14_19","2SA","14","19","19","王问∶“这一切是不是都是约押教给你的？” 那女人答道∶“我愿指着陛下的生命发誓，王的话一点儿不错。正是你的臣仆约押教给奴婢这些话，让我这样做的。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_20","011_14_20","2SA","14","20","20","约押这样做，是想要挽回这件事。陛下果然如主上帝的天使一样充满智慧，洞察世上的一切事情。” ");
INSERT INTO cmn2006_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","王对约押说∶“很好，我愿意这样办。你去把那年轻人押沙龙叫回来吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","约押匍伏在地上向王叩拜，祝福王，说∶“臣仆今日果然在陛下面前蒙恩，因为王应允了臣仆所请。” ");
INSERT INTO cmn2006_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","约押前往基述，把押沙龙带回耶路撒冷。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","不料王却说∶“让他回自己家吧，不要来见我。”于是押沙龙回到自己家中，没能面见大卫王。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","全以色列没有一个人象押沙龙那样相貌英俊，从头到脚没有一点缺憾。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","他每到年底剪发一次，不然头发就长得太重了，每次剪头发时都要称一称，剪下的头发用标准皇秤去称，竟有两公斤重。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","押沙龙有三个儿子和一个女儿。女儿名叫塔玛，出落得非常美丽。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","押沙龙在耶路撒冷住了两年，没有见过大卫王的面。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","押沙龙派人去请约押，想托他去见王，但约押不来；押沙龙再次派人去请，约押还是不肯来。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","押沙龙对仆从说∶“看，约押的田跟我的田紧挨着，他的田里种着大麦，你们去那里放上把火。”仆从们就去放火烧田。 ");
INSERT INTO cmn2006_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","约押果然来到押沙龙家里，质问他∶“你的仆从为什么放火烧我的田？” ");
INSERT INTO cmn2006_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","押沙龙对约押说∶“我派人去请你来，想托你去问王：‘何必把我从基述召回来呢？我倒不如留在那里好。’我想面见王，如果我有罪，就请王把我处死好了。” ");
INSERT INTO cmn2006_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","约押觐见王，把这番话告诉了王。王随即召见押沙龙；押沙龙进宫叩拜王，王亲吻了他。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","此后，押沙龙为自己备了车马，又派五十个人在前面开道。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","他常常很早起来，站在通往城门口的大道旁。遇到有人碰到不平的事要求王解决，押沙龙就叫住他，问∶“你是哪里人？”那人答道∶“我是以色列某个支派的人。” ");
INSERT INTO cmn2006_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","押沙龙就对他说∶“瞧，你的要求是正当合理的，可惜没有人代表王听你申诉。” ");
INSERT INTO cmn2006_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","然后又加上一句∶“如果我是法官该多好！那样，所有受屈的人或诉讼的人都可以来找我，我一定会还他公道。” ");
INSERT INTO cmn2006_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","遇到有人走近他向他躬身致敬，押沙龙就伸出双手扶住他，跟他亲吻。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","押沙龙对所有前来求王裁断是非的人都这样做，赢得了民心。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","第四年的年底，押沙龙禀奏王∶“请准许我到希伯仑去还我向主许下的愿。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","臣住在亚兰基述时曾许下愿：‘如果主能送我回耶路撒冷，我就要回希伯仑来敬拜他。’” ");
INSERT INTO cmn2006_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","王对他说∶“你安心去吧！” 押沙龙去了希伯仑。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","他随即派密使到以色列的各个支派去游说，说∶“你们一听到号声，就高喊：‘押沙龙在希伯仑做王了！’” ");
INSERT INTO cmn2006_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","两百人随同押沙龙一起从耶路撒冷去了希伯仑，他们是以客人的身份受邀前往的，跟押沙龙毫无牵涉，对内幕一无所知。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","押沙龙献祭的时候，还派人到基罗城把大卫王的顾问亚希多弗从家乡请来，叛逆的声势越来越大，押沙龙的追随者越来越多。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","有人向大卫报告∶“以色列的民心已经归附押沙龙！” ");
INSERT INTO cmn2006_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","大卫对跟他一起在耶路撒冷的众大臣说∶“我们得离开这里，否则，我们一个人也别想逃过押沙龙！我们必须立即动身；不然，他会突然来抓住我们，加害我们，杀光全城的人！” ");
INSERT INTO cmn2006_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","众大臣答道∶“我主陛下怎样吩咐，我们就怎样做。” ");
INSERT INTO cmn2006_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","王带领整个王室出走，只留下十个妃嫔守看王宫。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","民众都随王出走，在离城不远的一个地方暂作停留。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","王的部下和全体基利提人、比利提人从王的面前经过，还有六百名从迦特随王而来的迦特人。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","王对迦特人以太说∶“你们何必再跟随我们呢？回去留在新王押沙龙那里吧！你们是外族人，是从家乡到这里避难的。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","你们才来不久，我自己还行踪不定，怎么能让你们跟着我们一起到处漂泊？带着你的同胞回去吧，愿主的仁爱和信实与你们同在。” ");
INSERT INTO cmn2006_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","以太答道∶“我指着活生生的主向陛下发誓，无论陛下到哪里，你的仆人都将跟你同生共死。” ");
INSERT INTO cmn2006_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","大卫说∶“好，那就走吧！”迦特人以太带领全体族人和他们的家眷继续前进。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","民众离去的时候，田野里一片哭声。王过了汲沦溪，带领民众向旷野行进。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","当时，撒督也在那里，带领利未人抬着约柜。他们放下约柜，由亚比亚他献祭，等待民众全部撤离城市。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","王对撒督说∶“你带着约柜回城去吧！如果主还喜爱我，他会把我带回来，让我重新见到约柜和他的居所。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","如果他说：‘我不喜欢你了’，我也作好了准备，就让他按他的意愿处置我吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","王又对祭司撒督说∶“你不是先知吗？安心回城去吧，带上你的儿子亚希玛斯和亚比亚他的儿子约拿单。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","我在旷野的渡口那里等你的消息。” ");
INSERT INTO cmn2006_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","于是撒督和亚比他带着约柜返回耶路撒冷，留在城里。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","大卫继续前进，上了橄榄山；他蒙着头，赤着脚，一边上山一边哭。人们跟着他，也都蒙着头，一边上山一边哭。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","有人报告大卫∶“亚希多弗参与了押沙龙的叛乱！” 大卫祷告说∶“主啊，让亚希多弗的计谋都落空吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","大卫登上山顶，那里是人民日常敬拜主的地方。亚基人户筛穿着撕裂的长袍，头上蒙着灰，在那里迎接大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","大卫对户筛说∶“你跟我走反而会拖累我， ");
INSERT INTO cmn2006_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","你不如回到城里去，对押沙龙说：‘陛下，我愿做你的仆人；我曾是你父亲的臣仆，现在，我愿做你的仆人。’那样，你就可以帮助我挫败亚希多弗的计谋。 ");
INSERT INTO cmn2006_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","祭司撒督和亚比亚他不是也跟你在一起吗？你把王宫里的动静告诉他们， ");
INSERT INTO cmn2006_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","他们的儿子－撒督的儿子亚希玛斯和亚比亚他的儿子约拿单跟他们在一起，让他们把你得到的消息带给我。” ");
INSERT INTO cmn2006_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","于是，大卫的朋友户筛返回耶路撒冷，押沙龙也同时入城。 ");
INSERT INTO cmn2006_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","大卫刚过山顶不远，碰见米非波设的仆人洗巴等候在那里迎接他，洗巴牵着两头备好鞍的驴，驴背上驮着两百个饼，一百个葡萄饼，一百个无花果饼和一皮袋酒。 ");
INSERT INTO cmn2006_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","王问洗巴∶“你带这些东西来做什么？” 洗巴答道∶“驴是给王的眷属骑的，饼是给王的部下吃的，酒是让在旷野中疲惫不堪的人恢复精力的。” ");
INSERT INTO cmn2006_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","王又问∶“你主人的孙子在哪儿？” 洗巴答道∶“他在耶路撒冷。他是这样想的：‘以色列人今天一定会把我祖父的王国归还给我了。’” ");
INSERT INTO cmn2006_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","大卫对洗巴说∶“从现在起，凡属米非波设的一切都归你了。” 洗巴答道∶“卑臣叩首，愿我永蒙陛下恩典。” ");
INSERT INTO cmn2006_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","大卫王来到巴户琳，见一个人从城里出来。他是基拉的儿子示每，跟扫罗同族。他一边走，一边咒骂， ");
INSERT INTO cmn2006_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","不顾大卫王的军队和王身边的贴身侍卫，向大卫和侍从大臣扔石头。 ");
INSERT INTO cmn2006_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","他边骂边喊∶“滚开！滚开！你这无赖，你这杀人的凶手！ ");
INSERT INTO cmn2006_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","你杀害了扫罗全家，篡夺了他的王位，现在，主为这一切报应你了！主已经把你和王国交给了你的儿子押沙龙，你完蛋了！你这杀人凶手！” ");
INSERT INTO cmn2006_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","洗鲁雅的儿子亚比筛对王说∶“这条死狗怎么敢骂陛下？我去把他的头割下来！” ");
INSERT INTO cmn2006_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","王却说∶“这跟你们有什么关系，洗鲁雅的儿子？如果他咒骂我是因为主吩咐他∶‘去诅咒大卫’，那么，谁又能问：‘你怎么敢这样做？’” ");
INSERT INTO cmn2006_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","大卫又对亚比筛和众大臣说∶“我自己的亲生儿子尚且要取我的性命，何况这些便雅悯人！不要管他，让他去骂吧，是主吩咐他这样做的。 ");
INSERT INTO cmn2006_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","或许主会看见我现在的苦难，并为了我今天承受的咒骂而赐福给我。” ");
INSERT INTO cmn2006_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","大卫和他的部下沿着大路继续前进，示每则在对面的山坡上一边走一边骂，还向大卫扬土、扔石头。 ");
INSERT INTO cmn2006_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","王和随行的人们到了目的地时都累极了，就在那里休息。 ");
INSERT INTO cmn2006_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","这时押沙龙和其他以色列人已经进入耶路撒冷，亚希多弗也在其中。 ");
INSERT INTO cmn2006_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","大卫的朋友、亚基人户筛去见押沙龙，对他说∶“陛下万岁！陛下万岁！” ");
INSERT INTO cmn2006_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","押沙龙问户筛∶“这就是你对你朋友的友情吗？你为什么不跟着你朋友一起走？” ");
INSERT INTO cmn2006_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","户筛答道∶“不然，我只追随蒙主所拣选、为全体以色列人所拥戴的人，我只跟他在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","况且，我服侍的是谁？难道我不该服侍王的儿子吗？我以前怎样服侍你的父亲，也一定怎样服侍你。” ");
INSERT INTO cmn2006_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","押沙龙对亚希多弗说∶“给我们出出主意，我们该怎样办才好？” ");
INSERT INTO cmn2006_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","亚希多弗答道∶“你去跟你父亲留下看守宫殿的嫔妃们睡觉，这样一来，以色列人都知道你已经成了你父亲的死敌，跟随你的人就会更死心塌地了。” ");
INSERT INTO cmn2006_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","于是，人们在王宫屋顶的平台上支起帐蓬，押沙龙当着以色列人的面公然跟他父亲的嫔妃睡觉。 ");
INSERT INTO cmn2006_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","那亚希多弗料事如神，大卫和押沙龙都对亚希多弗言听计从。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","亚希多弗对押沙龙说∶“我挑选一万二千人，今夜就去追击大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","我要趁他疲惫不堪、士气低落的时候攻击他，狠狠地打击他，跟随他的人就会四散溃逃。我只杀王一人， ");
INSERT INTO cmn2006_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","把其他人召抚到你这里来。你要找的人一死，众人就会归附你，大家都平安无事了。” ");
INSERT INTO cmn2006_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","押沙龙和以色列的长老们都觉得这计策不错。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","押沙龙又说∶“把亚基人户筛召来，我们再听听他的主意。” ");
INSERT INTO cmn2006_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","户筛来了，押沙龙对他说∶“亚希多弗给我们出了这条计，我们该不该依计而行？如果你以为不可，让我们听听你的高见。” ");
INSERT INTO cmn2006_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","户筛对押沙龙说∶“亚希多弗这次的计策不见得高明。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","你知道，你父亲和他的部下都英勇善战，象被抢走了熊崽的母熊一样凶猛，此外，你父亲本人是个经验老道的将才，他不会夜间跟部队住在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","即便现在说不定他正隐蔽在山洞里或别的什么地方。一旦他先声夺人攻打你的部队，得到消息的人就会说：‘押沙龙的军队被杀败了！’ ");
INSERT INTO cmn2006_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","那时，即使猛如雄狮的勇士也会吓得浑身发软，因为以色列人都知道你父亲是个英雄，他的部下也都勇猛过人。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","因此，我建议：从但到别是巴，把多如海沙一样的以色列人都召集起来，由你亲自率领出征。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","大卫在哪里出现，我们就要在那里象盖满大地的露水一样压倒他，他和他的部下都休想活命。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","即便他躲进城里，全体以色列人也能带着绳子去把那城拉下山谷，连一块小石子也不剩！” ");
INSERT INTO cmn2006_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","押沙龙和其他以色列人说∶“户筛的计策比亚希多弗的好。”主立意要阻挠亚希多弗的良谋，为的是要降祸给押沙龙。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","户筛告诉祭司撒督和亚比亚他∶“亚希多弗向押沙龙和以色列众长老献计要如此如此，而我设法使他们这般这般。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","现在，要立即向大卫王报讯，告诉他：‘不要在旷野的渡口过夜，立即渡河，否则，王和随行的人必遭歼灭！’” ");
INSERT INTO cmn2006_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","约拿单和亚希玛斯留在隐罗结，他们不敢进城，恐怕被人发现。一个婢女来通知他们，要他们去给大卫王报讯。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","一个年轻人看见了他们，报告了押沙龙。两人迅速离开那里，躲到一个巴户琳人的家里。那人家的院子里有一口井，他们就爬下井， ");
INSERT INTO cmn2006_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","那人的妻子用被子抖开来，盖住井口，又在上面撒上麦子，什么人也看不出来。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","押沙龙派来的人进到屋里，问那女人∶“约拿单和亚希玛斯在哪里？” 那女人答道∶“他们早过河了。”来人搜查了一番，什么也没有发现，就返回耶路撒冷。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","他们走后，两人爬出井来，去向大卫王报信。他们告诉大卫∶“亚希多弗如此定计要害你，你们赶快动身渡河！” ");
INSERT INTO cmn2006_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","大卫和全体随从立即渡河。拂晓之前，所有的人都渡过了约旦河。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","亚希多弗见自己的计策不被采纳，就给驴备好鞍，动身回到自己的老家。他安排好家事，然后就上吊自杀了，人们把他埋在他家族的墓地里。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","大卫到了玛哈念，押沙龙带领以色列人也渡过了约旦河。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","押沙龙任命亚玛撒为元帅，代替约押。亚玛撒是以实玛利人益帖的儿子。益帖的妻子亚比该是拿辖的女儿，她和约押的母亲洗鲁雅是亲姐妹。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","押沙龙和以色列人在基列一带扎下营寨。 ");
INSERT INTO cmn2006_vpl VALUES ("S217_27","011_17_27","2SA","17","27","29","大卫到了玛哈念以后，亚扪的拉巴人拿辖的儿子朔比、罗底巴人亚米利的儿子玛吉、基列的罗基琳人巴西莱送来被褥、锅碗和各种炊具，还送来了小麦、大麦、面粉、烤好的谷子、豆类、蜂蜜、奶油、绵羊和牛奶酪，供大卫和他的部下食用。他们说∶“人们在旷野里一定又饥又渴，疲惫不堪了。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","大卫集合起所有跟随他的人，任命了千夫长和百夫长。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","大卫派军队出战，三分之一由约押统辖，三分之一由约押的弟弟亚比筛统辖，三分之一由迦特人以太统辖。 王对部下说∶“我要亲自率领你们出战。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","部下们说∶“陛下决不可出战；如果我们打了败仗，他们不会在乎，即使我们一半人都死了，他们也不会在意。可是，你一个人顶得上我们一万人，陛下还是留在城里观阵吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","王说∶“你们认为怎样好就怎样办吧！”王站在城门口，军队每百人和千人为一队，经过他的面前开出城去。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","王命令约押、亚比筛和以太∶“为了我，你们要对那年轻人押沙龙以礼相待。”全军都听到了王向各级将官发布的有关押沙龙的命令。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","军队开进野外，与以色列人相遇，战斗在以法莲森林里展开。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","以色列军队被大卫的军队打败了，伤亡惨重，共有二万人阵亡。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","战斗遍及整个山野，死于森林地带的人比死于格斗的人还要多。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","押沙龙跟大卫的部下相遇；他正骑着骡子，从一棵枝叶茂密的大橡树下经过，树枝缠住了他的头发，胯下的骡子却照直向前窜，他被挂到半空中。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","一个人看见这情景，跑去报告约押∶“我刚才看见押沙龙挂在一棵大橡树上了！” ");
INSERT INTO cmn2006_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","约押问报信的人∶“什么！你看见他了？为什么不当场杀了他？我会奖给你十块银子和一条武士带。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","那人答道∶“即使给我一千块银子，我也不敢动手杀害王的儿子。我们都听见了王给你和亚比筛、以太的命令：‘为了我，务必保全那年轻人押沙龙的性命。’ ");
INSERT INTO cmn2006_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","等我违命杀了他－什么事都瞒不过王－你就会在一边袖手旁观了。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","约押说∶“我可不想就这样等着你。”他拿起三支矛，趁押沙龙还挂在橡树上挣扎，把三支矛都掷进押沙龙的胸膛。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","约押的十名侍卫围上来，杀死了押沙龙。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","随后，约押吹号收兵，让部队停止追击以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","他们把押沙龙的尸体放下来，扔进森林里的一个大坑里，在上面堆起一大堆石头。与此同时，以色列人都纷纷逃回自己的家乡。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","押沙龙生前曾在王谷为自己立碑留念，说∶“我没有儿子继承我的姓氏。”他以自己的名字为碑命名，至今这碑仍叫做押沙龙碑。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","撒督的儿子亚希玛斯对约押说∶“我去把消息报告给王吧！主已经把他从仇敌的手中救出来了。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","约押说∶“今天去报信的不应该是你；你改个时间再去吧，只是不要在今天；因为王的儿子今天死了。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","随后，约押吩咐一个古示人∶“你去向王报告你亲眼所见的一切。”古示人向约押躬身致敬，随即跑去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","亚希玛斯又对约押说∶“不管怎样，请一定让我跟在这古示人的后面去报信。” 约押答道∶“孩子，你为什么一定要去？你带去的消息不会给你带来什么好处。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","亚希玛斯说∶“不管怎样，我一定要去。” 于是约押说∶“那你就去吧！”亚希玛斯沿着平原跑去，不久就赶过了那古示人。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","这时，大卫正坐在内外城门中间，了望哨沿着城墙爬到城楼的顶上了望。他向远处了望，看见一个人跑来， ");
INSERT INTO cmn2006_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","就大声向王报告。 王说∶“如果他是独自一人，那就是报好消息的。” 那人越跑越近。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","了望哨又看见一个人跑来，就向下面的守门人喊∶“瞧！又有一个人跑来了！” 王说∶“他一定也是送好消息来的。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","了望哨说∶“跑在前面的那个人好象是撒督的儿子亚希玛斯。” 王说∶“他是个好人，他一定是送好消息来的。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","亚希玛斯向王喊∶“一切顺利！”他俯伏在地上，向王叩拜，说∶“赞美主－你的上帝！他除掉了反叛陛下的人。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","王问∶“那年轻人押沙龙还好吧？” 亚希玛斯答道∶“约押派臣仆出发时，我只见异常混乱，却不知道是什么事。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","王说∶“退下去吧！”亚希玛斯退到一旁站着。 ");
INSERT INTO cmn2006_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","随后，古示人到了，对王说∶“陛下，好消息！主今天已经把你从所有敌对你的人手中救出来了！” ");
INSERT INTO cmn2006_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","王问那古示人∶“那年轻人押沙龙还好吧？” 古示人答道∶“愿陛下的仇敌和所有胆敢危害你的人都跟那年轻人一样。” ");
INSERT INTO cmn2006_vpl VALUES ("S218_33","011_18_33","2SA","18","33","33","王大惊失色，他走进城楼上的房间放声痛哭，一路上边走边说∶“我儿押沙龙啊，我的儿子！我儿押沙龙啊，我恨不得替你去死！押沙龙啊，我的孩子，我的孩子！” ");
INSERT INTO cmn2006_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","有人告诉约押∶“王在为押沙龙伤心痛哭哪！” ");
INSERT INTO cmn2006_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","那一天，胜利的欢乐变成哀伤，因为消息传遍了全军∶“王在为他的儿子悲伤。” ");
INSERT INTO cmn2006_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","人们象打了败仗逃回羞于见人一样悄悄地溜回城里。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","王蒙着脸，大声哭着说∶“我儿押沙龙啊！押沙龙，我的孩子，我的孩子！” ");
INSERT INTO cmn2006_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","约押进宫去见王，说∶“陛下，你今天羞辱了你的全体战士，是他们救了你、你的儿女和你的后妃的性命， ");
INSERT INTO cmn2006_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","你却爱那恨你的人，恨那爱你的人，明明不把你的将士放在心上。我看得很明白，如果今天押沙龙还活着，而我们都死了，你就高兴了。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","出去安抚你的将士吧！我指着主发誓，如果你不去，今天天黑以前，一个人也不会再留在你这里，那将是你前所未有的大灾难。” ");
INSERT INTO cmn2006_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","王站起来，在城门口设下座位。人们互相传告∶“王正坐在城门口哪！”所有的人都来朝见王。 这时，以色列人已经逃回自己的家乡。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","各支派的人都议论纷纷，说∶“王曾把我们从各个仇敌的手中救出来，又把我们从非利士人的手中救出来，现在，他由于押沙龙的缘故而离开了国土。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","我们曾膏立押沙龙为王，但他已经战死了，既然如此，我们为什么不把王请回来呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","大卫王派人传话给祭司撒督和亚他比亚，说∶“你们告诉犹大的长老们：‘以色列各地要迎王驾回宫的议论都已经传到王的居所，为什么你们要落在别人后面？ ");
INSERT INTO cmn2006_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","你们是我的同胞，是我的亲骨肉，为什么要落在别人后面请王回宫呢？’ ");
INSERT INTO cmn2006_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","你们还要告诉亚玛撒说：‘你不是我的嫡亲吗？从现在起，如果不是你取代约押做军队的统帅，愿上帝重重地惩罚我！’” ");
INSERT INTO cmn2006_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","大卫赢得了所有犹大人拥护，他们派人送信给王，说∶“你和你的部下都回来吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","于是王踏上归途，来到约旦河边。这时，犹大人已经来到吉甲，准备去迎接王过约旦河。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","巴户琳的便雅悯人基拉的儿子示每也急忙跟犹大人一起来迎接大卫王， ");
INSERT INTO cmn2006_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","跟他一起来的有一千名便雅悯人，还有扫罗旧日的家臣洗巴和他的十五个儿子，二十名仆人。他们急急忙忙来到约旦河边王的住地， ");
INSERT INTO cmn2006_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","在渡口过河迎接王的眷属，满足王的一切心愿。 基拉的儿子示每刚渡过河就扑倒在王的跟前， ");
INSERT INTO cmn2006_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","说∶“求陛下不要治我的罪，不要记着你的仆人在陛下离开耶路撒冷时所犯的过错。求陛下不要把这件事放在心上。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","仆人我知罪了，所以我今天在约瑟家族中第一个来迎接王。” ");
INSERT INTO cmn2006_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","洗鲁雅的儿子亚比筛说∶“难道示每不该处死吗？他曾经咒骂主的受膏者。” ");
INSERT INTO cmn2006_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","大卫答道∶“这跟你有什么相干，洗鲁雅的儿子？今天你要对抗我吗？一个以色列人也不会被处死！难道我不知道我是现今的以色列之王吗？” ");
INSERT INTO cmn2006_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","王对示每说∶“你不会死。”王发誓允他不死。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","扫罗的孙子米非波设也来迎接王。从王出走直到王平安返回的整个期间，他没有修过脚，剃过胡须，也没有洗过衣服。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","他从耶路撒冷来见王，王问他∶“米非波设，你当初为什么不跟我一起走？” ");
INSERT INTO cmn2006_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","米非波设答道∶“陛下，我是个瘸腿的人，我曾吩咐我的仆人洗巴备驴，我好骑着跟陛下一起走，但他欺骗了我， ");
INSERT INTO cmn2006_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","还向陛下诬告我。陛下象上帝的天使一样明察是非，请陛下随意办吧！ ");
INSERT INTO cmn2006_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","我祖父的后代本该在陛下面前俯首受死，是陛下在王的餐桌前给了臣一席之地，我还有什么权利再求王的恩典？” ");
INSERT INTO cmn2006_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","王对他说∶“不必再说了；我决定让你和洗巴平分田产。” ");
INSERT INTO cmn2006_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","米非波设说∶“既然王已经平安回来，就让洗巴把一切都拿去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","基列人巴西莱也从罗基琳来见王，要跟王一起渡河，送王上路。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","巴西莱当时已经是八十岁的老人了，他很富有，王住在玛哈念期间他曾向王提供给养。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","王对他说∶“和我一起过河，到耶路撒冷去吧！我要终生供养你。” ");
INSERT INTO cmn2006_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","巴西莱答道∶“我还能活多久，何必再跟陛下到耶路撒冷去呢？ ");
INSERT INTO cmn2006_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","我现在八十岁了，已经辨不出好坏，尝不出饮食的滋味，听不出男女的歌声，何必让臣再成为陛下的累赘呢？ ");
INSERT INTO cmn2006_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","臣只能送王过河走一小段路，王何必赐臣这样的恩典？ ");
INSERT INTO cmn2006_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","请准我终老故乡，守着父母双亲的坟墓。瞧，陛下的仆人金罕将跟陛下一起去，听凭陛下驱使。” ");
INSERT INTO cmn2006_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","王说∶“我会带他走，按照你的意愿看顾他；无论你有什么心愿，我都会答应你。” ");
INSERT INTO cmn2006_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","人们都渡过了约旦河，随后，王也过了河。王亲吻巴西莱，为他祝福，巴西莱就回去了。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","王过了河，来到吉甲；金罕随王一起过了河。犹大的全部军队和以色列的半数军队接王渡河。 ");
INSERT INTO cmn2006_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","后来，以色列人来见王，对王说∶“为什么我们的同胞犹大人要偷偷地把王接走，送王和王的眷属及王的部下过河呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","犹大人答复以色列人∶“王是我们的近亲，所以我们才这样做，你们何必对此不满？我们吃了王什么？王又赏赐了我们什么？” ");
INSERT INTO cmn2006_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","以色列人说∶“我们跟王有十倍的情份，对大卫王，我们更有发言权。你们为什么藐视我们？难道不是我们首先倡议迎回王驾吗？”不料犹大人的答复比以色列人更强硬。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_1","011_20_1","2SA","20","1","1","有一个专门无事生非的便雅悯人，名叫示巴，他是比基利的儿子，当时正好也在吉甲。示巴吹着号，大声喊叫说： “大卫跟我们有什么相干！耶西的儿子给过我们什么好处！以色列人哪，各人回各人的家去吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S220_2","011_20_2","2SA","20","2","2","以色列人都离开大卫，跟着示巴走了。但犹大人依然留在大卫身边，从约旦河一直来到耶路撒冷。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_3","011_20_3","2SA","20","3","3","大卫回到耶路撒冷的王宫后，把出走时留下看守王宫的十个嫔妃禁闭起来，他供养她们，但不再与她们亲近。她们终生住在冷宫里，过着象寡妇一样孤单凄清的生活。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_4","011_20_4","2SA","20","4","4","王吩咐亚玛撒∶“你在三天之内把犹大人召集到我这里来，你要跟他们一起回来。” ");
INSERT INTO cmn2006_vpl VALUES ("S220_5","011_20_5","2SA","20","5","5","亚玛撒去召集犹大人，但延误了王规定的日期。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_6","011_20_6","2SA","20","6","6","大卫王对亚比筛说∶“比基利的儿子示巴对我们的危害可能会比押沙龙更大。你带领我的部队去追他吧！不然，他会占据设防城逃避我们。” ");
INSERT INTO cmn2006_vpl VALUES ("S220_7","011_20_7","2SA","20","7","7","亚比筛率领约押的部下、基利提人、比利提人和所有的勇士从耶路撒冷出发，追击比基利的儿子示巴。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_8","011_20_8","2SA","20","8","8","他们到达基遍的大磐石时，亚玛撒前来迎接他们。约押穿着战袍，束着腰带，腰带上佩着一把带鞘的匕首。他走上前来，匕首也出了鞘。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_9","011_20_9","2SA","20","9","9","约押问候亚玛撒∶“你可好，兄弟？”他用右手握住亚玛撒的胡子，假装要跟他亲吻。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_10","011_20_10","2SA","20","10","10","亚玛撒对约押手中的匕首毫无防备，约押把匕首猛刺进亚玛撒的肚子，顿时肠子流了满地，没有再刺第二下，亚玛撒就死了。 约押和他的兄弟亚比筛继续追击比基利的儿子示巴。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_11","011_20_11","2SA","20","11","11","约押的一名部下站在亚玛撒的尸身旁喊∶“谁拥护约押，谁站在大卫王一边，谁就应该听从约押的命令！” ");
INSERT INTO cmn2006_vpl VALUES ("S220_12","011_20_12","2SA","20","12","12","亚玛撒的尸身倒在路中央的血泊里，那人见部队都停步不前，就把尸体从路中央拖到田里，扔了件衣服把它盖住。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_13","011_20_13","2SA","20","13","13","亚玛撒的尸身移开以后，人们继续跟着约押去追比基利的儿子示巴。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_14","011_20_14","2SA","20","14","14","示巴走遍以色列各支派，一直到亚伯伯玛迦，又穿过比利人的地区；那里的人都集合在他身边，听从他的指挥。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_15","011_20_15","2SA","20","15","15","约押率领全军到亚伯伯玛迦围攻示巴，他们造了一座高及城墙的攻城土坡，正对着外城的防御工事。正当他们试图撞倒城墙时， ");
INSERT INTO cmn2006_vpl VALUES ("S220_16","011_20_16","2SA","20","16","16","一个聪明的女子从城上喊∶“听着！听着！请让约押到这里来，我有话对他讲。” ");
INSERT INTO cmn2006_vpl VALUES ("S220_17","011_20_17","2SA","20","17","17","约押来了；她问∶“你是约押吗？” 约押答道∶“是我。” 她说∶“请听婢女的话。” 约押说∶“我在听着。” ");
INSERT INTO cmn2006_vpl VALUES ("S220_18","011_20_18","2SA","20","18","18","她继续说∶“古人说：‘到亚伯去求教吧！’然后事情就定妥了。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_19","011_20_19","2SA","20","19","19","我们在以色列素来以和平和忠信著称，你们是在毁灭以色列的一个重要的城市。你们为什么要毁灭主的产业呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S220_20","011_20_20","2SA","20","20","20","约押答道∶“我绝没有这个意思。我不想毁灭这城， ");
INSERT INTO cmn2006_vpl VALUES ("S220_21","011_20_21","2SA","20","21","21","那不是我们的意图。有一个从以法莲山区来的人，名叫示巴，他是比基利的儿子；他煽动叛乱，反对大卫王。把这人交出来，我立即退兵。” 那女子对约押说∶“我们会把他的头从城上扔给你的。” ");
INSERT INTO cmn2006_vpl VALUES ("S220_22","011_20_22","2SA","20","22","22","她向城里的人献上妙计，人们割下比基利的儿子示巴的头，扔给约押。约押吹起号，他的部下就离开城各自撤回，约押也回耶路撒冷去见王。 ");
INSERT INTO cmn2006_vpl VALUES ("S220_23","011_20_23","2SA","20","23","23","约押统辖以色列的全部军队；耶何耶大的儿子比拿雅统领基利提人和比利提人； ");
INSERT INTO cmn2006_vpl VALUES ("S220_24","011_20_24","2SA","20","24","24","亚多兰总管服苦役的人；亚希律的儿子约沙法任史官； ");
INSERT INTO cmn2006_vpl VALUES ("S220_25","011_20_25","2SA","20","25","25","示法任王室书记；撒督和亚比亚他担任祭司； ");
INSERT INTO cmn2006_vpl VALUES ("S220_26","011_20_26","2SA","20","26","26","睚珥人以拉任大卫的私人祭司。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_1","011_21_1","2SA","21","1","1","大卫在位期间曾有过一次连续三年的饥荒。大卫求问主，主说∶“这次饥荒是因为扫罗和他血债累累的家族，因为扫罗曾杀害基遍人。” ");
INSERT INTO cmn2006_vpl VALUES ("S221_2","011_21_2","2SA","21","2","2","（基遍人不属于以色列人，他们是亚摩利人的遗民，以色列人曾跟他们立约，不再迫害他们，但扫罗偏爱以色列人和犹大人，想要除灭他们。）大卫召来基遍人谈话， ");
INSERT INTO cmn2006_vpl VALUES ("S221_3","011_21_3","2SA","21","3","3","他问他们∶“我能为你们做些什么？我怎样补偿才能使你们为主的产业祝福呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S221_4","011_21_4","2SA","21","4","4","基遍人答道∶“我们既不想向扫罗和他的家族要求金银，也不愿意看到任何以色列人因此而死。” 大卫问∶“那么，你们要求我做什么呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S221_5","011_21_5","2SA","21","5","5","基遍人回奏王∶“那个谋害我们，要灭绝我们，使我们大量死亡，在以色列几乎没有立足之地的人， ");
INSERT INTO cmn2006_vpl VALUES ("S221_6","011_21_6","2SA","21","6","6","请把他的七名子孙交给我们，我们要在主拣选扫罗的基比亚，把他们吊死在主的面前示众。” 王说∶“我会把他们交给你们的。” ");
INSERT INTO cmn2006_vpl VALUES ("S221_7","011_21_7","2SA","21","7","7","但王留下了扫罗的孙子、约拿单的儿子米非波设，因为大卫曾跟约拿单在主的面前立过约。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_8","011_21_8","2SA","21","8","9","王把爱雅的女儿利斯巴给扫罗生的两个儿子亚摩尼和米非波设以及扫罗的女儿米拉给米何拉人巴西莱的儿子亚得列生的五个儿子交给了基遍人。基遍人在主的面前把他们吊死在一座小山上，七个人死在一起，他们死的时候正是开始收割大麦的第一天。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_10","011_21_10","2SA","21","10","10","爱雅的女儿利斯巴用麻布张在岩石间，自己住在里边，从开始收割大麦直到天降秋雨的时节，白天不让飞鸟停在尸体上，夜间不让野兽靠近。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_11","011_21_11","2SA","21","11","11","有人把扫罗的妃子、爱雅的女儿利斯巴的事告诉了大卫； ");
INSERT INTO cmn2006_vpl VALUES ("S221_12","011_21_12","2SA","21","12","12","大卫就到基列雅比人那里把扫罗和他的儿子约拿单的骸骨运了回来。（非利土人在基利波杀死扫罗后把他们的尸身吊在伯珊广场上，基列雅比人把尸身从那里偷偷地运了回来。） ");
INSERT INTO cmn2006_vpl VALUES ("S221_13","011_21_13","2SA","21","13","13","大卫运回扫罗和他儿子约拿单的骸骨，又收敛了被吊死的那七个人。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_14","011_21_14","2SA","21","14","14","人们把扫罗和他儿子约拿单的骸骨葬在便雅悯境内的洗拉、扫罗的父亲基士的墓地里。一切按照王的命令行事。由此，上帝垂听为这块土地做的祈祷。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_15","011_21_15","2SA","21","15","15","非利士人和以色列之间又爆发战争。大卫率领部下跟非利士人作战，打得精疲力尽， ");
INSERT INTO cmn2006_vpl VALUES ("S221_16","011_21_16","2SA","21","16","16","有一个名叫以实比诺的巨人的后代，佩着新剑，铜矛的矛头有三公斤半重，扬言要杀死大卫。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_17","011_21_17","2SA","21","17","17","洗鲁雅的儿子亚比筛过来援救大卫，杀死了那个非利士人。大卫的部下恳求大卫，说∶“你绝不可再跟我们一起上阵，以色列的明灯不可就此熄掉。” ");
INSERT INTO cmn2006_vpl VALUES ("S221_18","011_21_18","2SA","21","18","18","后来，跟非利士人又在歌伯发生战争。户沙人西比该杀死了另一个巨人的后代撒弗。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_19","011_21_19","2SA","21","19","19","在歌伯跟非利士人的另一场战争中，伯利恒人雅雷俄珥金的儿子伊勒哈难杀死了迦特人歌利亚；这个人的矛象织布机的轴那么粗。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_20","011_21_20","2SA","21","20","20","在迦特的一次战争中，有一个双手和双脚各长六个指头－一共二十四个指头－的巨人，他也是巨人的后代。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_21","011_21_21","2SA","21","21","21","他向以色列人骂阵时，大卫的哥哥示米亚的儿子约拿单杀死了他。 ");
INSERT INTO cmn2006_vpl VALUES ("S221_22","011_21_22","2SA","21","22","22","以上四个人都是迦特巨人的后代，他们都死在大卫和他部下的手里。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","主把大卫从扫罗和其他仇敌手里救了出来；大卫向主吟唱了这首颂歌： ");
INSERT INTO cmn2006_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","“主是我的磐石，是我的堡垒和我的拯救者； ");
INSERT INTO cmn2006_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","我的上帝是我避难的磐石，是我的盾牌和拯救我的角。 他是我的堡垒，是我的避难之地和我的救主， 把我从狂暴之徒的手中救了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","主是应该受赞颂的， 我向他呼求，他就救我脱离了仇敌。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","死亡的浪涛曾经环绕着我， 毁灭的急流曾经盖顶而来； ");
INSERT INTO cmn2006_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","阴间的绳索曾经把我紧紧缠住； 致命的陷井曾经横在我的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","我在困境中向主呼求，向我的上帝求助。 他在圣殿中听到了我的声音，我的呼求传进他的耳中。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_8","011_22_8","2SA","22","8","8","大地震颤，天的根基在摇动，天地一齐颤抖； 因为上帝发怒了！ ");
INSERT INTO cmn2006_vpl VALUES ("S222_9","011_22_9","2SA","22","9","9","他的鼻孔冒出浓烟， 他的口中喷出烈焰和燃烧的火炭。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_10","011_22_10","2SA","22","10","10","他拉开天幕，亲自降临， 黑云踏在他的脚下。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_11","011_22_11","2SA","22","11","11","他乘着基路伯飞行，藉着风的翅膀急驰。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_12","011_22_12","2SA","22","12","12","他以黑暗为华盖， 身边环绕着浓密的雨云； ");
INSERT INTO cmn2006_vpl VALUES ("S222_13","011_22_13","2SA","22","13","13","他发出光辉，如同燃烧的光芒； ");
INSERT INTO cmn2006_vpl VALUES ("S222_14","011_22_14","2SA","22","14","14","主从天上用雷声说话，至高者的声音在回荡， ");
INSERT INTO cmn2006_vpl VALUES ("S222_15","011_22_15","2SA","22","15","15","他射出箭， 击溃了我的仇敌； 电光闪耀， 是他挥洒它们。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_16","011_22_16","2SA","22","16","16","他开口斥责， 他的鼻息使海底暴露，使大地的根基裸露。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_17","011_22_17","2SA","22","17","17","他从高天伸下手来抓住我， 把我从深水之中拉了出来。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_18","011_22_18","2SA","22","18","18","他救我脱离了强敌之手，这些仇敌的力量远胜于我； ");
INSERT INTO cmn2006_vpl VALUES ("S222_19","011_22_19","2SA","22","19","19","他们在我遭难的日子攻击我，但主是我的倚靠。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_20","011_22_20","2SA","22","20","20","他拯救我，把我领到宽阔之地， 因为他喜爱我。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","主因我的正直厚待我， 因我双手的洁净奖赏我。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","因为我一直遵行主的路， 从没有背离过我的上帝，做过邪恶的事。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","他的律法时刻在我的眼前， 我从没有违背过他的诫命。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","在他面前，我始终无可指摘，远离罪恶。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","主因我的正直、我的纯洁奖赏了我。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","对信实的人，你待他以信实； 对完美的人，你还他以完美； ");
INSERT INTO cmn2006_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","对纯洁的人，你向他展示纯洁； 对狡诈的人，你以狡诈敌对他。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","你拯救卑微的人， 你检视傲慢的人，并剥夺他们的权势。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","主啊， 你是我的明灯， 你的光驱散了我的黑暗。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_30","011_22_30","2SA","22","30","30","有了你的帮助，我能冲决敌军； 我的上帝与我同在，我能攀越高城。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","主上帝的路是至善至美的， 主的话是完美无瑕的。 他是一面盾牌，庇护所有投靠他的人。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","除了主以外，谁能做上帝？ 除了我们的上帝之外，谁能做我们的磐石？ ");
INSERT INTO cmn2006_vpl VALUES ("S222_33","011_22_33","2SA","22","33","33","是上帝给了我力量，使我一路平安。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_34","011_22_34","2SA","22","34","34","他使我的脚快如奔鹿，使我稳立在高山之巅； ");
INSERT INTO cmn2006_vpl VALUES ("S222_35","011_22_35","2SA","22","35","35","他教我争战的本领，我的臂膀能拉开铜弓。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","你把胜利之盾赐给了我； 你俯身临世，立我为尊。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_37","011_22_37","2SA","22","37","37","你拓宽我脚下的路，使我不致跌倒。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_38","011_22_38","2SA","22","38","38","我追赶仇敌，打垮他们， 不消灭他们决不回头； ");
INSERT INTO cmn2006_vpl VALUES ("S222_39","011_22_39","2SA","22","39","39","我彻底粉碎了他们， 使他们仆倒在我的脚下，无法再起。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_40","011_22_40","2SA","22","40","40","你赐给我争战的力量， 使我的仇敌拜伏在我的脚下， ");
INSERT INTO cmn2006_vpl VALUES ("S222_41","011_22_41","2SA","22","41","41","你使我的仇敌转身奔逃，让我消灭那恨我的人。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_42","011_22_42","2SA","22","42","42","他们呼号求救，但无人来救； 他们向主呼求，但他不回答。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_43","011_22_43","2SA","22","43","43","我把他们打得粉身碎骨，如同地上的灰尘； 我猛击他们，就象践踏街上的泥土。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_44","011_22_44","2SA","22","44","44","你把我从自己人的攻击中解救出来，仍然立我做列国的领袖； 跟我素无交往的民族向我称臣。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_45","011_22_45","2SA","22","45","45","外邦异族对我曲意逢迎。 他们望风归顺， ");
INSERT INTO cmn2006_vpl VALUES ("S222_46","011_22_46","2SA","22","46","46","全都吓破了胆，战栗地走出他们的营垒。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_47","011_22_47","2SA","22","47","47","主永生不死！ 赞颂归于我的磐石！ 要尊崇我的上帝—我的磐石，我的拯救者！ ");
INSERT INTO cmn2006_vpl VALUES ("S222_48","011_22_48","2SA","22","48","48","他是为我复仇的上帝， 使我凌驾于列国之上； ");
INSERT INTO cmn2006_vpl VALUES ("S222_49","011_22_49","2SA","22","49","49","不再受仇敌的箝制。 你使我制伏恨我的人， 你救我脱离暴徒之手。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_50","011_22_50","2SA","22","50","50","主啊， 我要为此在列国之中颂扬你，歌唱赞美你的名。 ");
INSERT INTO cmn2006_vpl VALUES ("S222_51","011_22_51","2SA","22","51","51","他把胜利赐给他选立的君王， 他永远向他的受膏者－大卫和他的后裔显示不变的爱。” ");
INSERT INTO cmn2006_vpl VALUES ("S223_1","011_23_1","2SA","23","1","1","以下是大卫的遗言；也是耶西的儿子大卫、至高者所推崇的人、雅各的上帝的受膏者、以色列受人爱戴的歌者留下的圣言： ");
INSERT INTO cmn2006_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","“主的灵藉我发言，他的话在我的舌上。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_3","011_23_3","2SA","23","3","3","以色列的上帝－以色列的磐石晓喻我： ‘那以正义治理人民的人， 就是以敬畏上帝执掌王权的人； ");
INSERT INTO cmn2006_vpl VALUES ("S223_4","011_23_4","2SA","23","4","4","他宛如晴朗无云的清晨里旭日初升的晨曦， 宛如使大地一片青绿的雨后的晴光。’ ");
INSERT INTO cmn2006_vpl VALUES ("S223_5","011_23_5","2SA","23","5","5","上帝对我的家族不正是如此吗？ 不正是他跟我立了永久的约，安排并确认了一切吗？ 不是他赐给我救恩，成就了我的所有愿望吗？ ");
INSERT INTO cmn2006_vpl VALUES ("S223_6","011_23_6","2SA","23","6","6","恶人都将象荆棘一样被扔到一旁， 不是用手去拔， ");
INSERT INTO cmn2006_vpl VALUES ("S223_7","011_23_7","2SA","23","7","7","而是用铁器和枪杆； 它们必被就地烧光。” ");
INSERT INTO cmn2006_vpl VALUES ("S223_8","011_23_8","2SA","23","8","8","以下是大卫手下勇士的名单： 他革扪人约设巴设；他是三勇士的首领，曾在一次遭遇战中持矛力杀八百人。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_9","011_23_9","2SA","23","9","9","其次是亚合人朵多的儿子以利亚撒；他是三勇士之一，曾跟随大卫向进犯的非利士人挑战；以色列人后撤了， ");
INSERT INTO cmn2006_vpl VALUES ("S223_10","011_23_10","2SA","23","10","10","但他坚守不退，杀非利士人直杀得手臂酸软，手粘住了剑柄。那天，主使以色列人大胜，后撤的军队又返回来跟以利亚撒会合，但他们所做的只是剥光尸体上的衣甲。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_11","011_23_11","2SA","23","11","11","再其次是哈拉人亚基的儿子沙玛；有一次，非利士人集结在某地，当地有一块长满红豆的田，以色列军队溃退了， ");
INSERT INTO cmn2006_vpl VALUES ("S223_12","011_23_12","2SA","23","12","12","只有沙玛坚守在田中间，力战不退，砍杀非利士人。那天，主使以色列人大胜。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_13","011_23_13","2SA","23","13","13","在收割季节，三十勇士中的三个人到亚杜兰洞去见大卫。当时，一队非利士人正驻扎在利乏音谷， ");
INSERT INTO cmn2006_vpl VALUES ("S223_14","011_23_14","2SA","23","14","14","并在伯利恒城里派驻了军队，大卫则据守在堡垒里。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_15","011_23_15","2SA","23","15","15","大卫想喝水，说∶“要是有人能从伯利恒城门口的井里给我取点水来喝该多好啊！” ");
INSERT INTO cmn2006_vpl VALUES ("S223_16","011_23_16","2SA","23","16","16","三个勇士冲过非利士人的防线，从伯利恒城门口旁的井里打了水，带回来献给大卫。大卫却不肯喝；他把水浇奠在主的面前， ");
INSERT INTO cmn2006_vpl VALUES ("S223_17","011_23_17","2SA","23","17","17","说∶“主啊，这不是冒死前住的战士的血吗？我怎么敢喝！”大卫终于没有喝这水。这是三勇士的事迹。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_18","011_23_18","2SA","23","18","18","洗鲁雅的儿子约押的弟弟亚比筛是这三勇士的首领，他曾用矛杀死三百人，但没有列在三勇士之内。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_19","011_23_19","2SA","23","19","19","尽管他没有列名在三勇士之内，但他比三勇士更受尊崇，被任命为他们的指挥官。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_20","011_23_20","2SA","23","20","20","耶何耶大的儿子比拿雅是甲薛的著名勇士，战功赫赫，他曾杀死两名最出名的摩押勇士，还曾在雪天下到陷井里杀死过一只狮子。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_21","011_23_21","2SA","23","21","21","他还杀死过一个身材魁伟的埃及人。尽管那埃及人手中拿着矛，比拿雅只拿着一根木棍跟他搏斗，他夺过那埃及人的矛，用那矛刺死了他。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_22","011_23_22","2SA","23","22","22","这是耶何耶大的儿子比拿雅的事迹。他也没有列在三勇士之内。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_23","011_23_23","2SA","23","23","23","虽然没有名列三勇士之内，但他比三十勇士更受尊崇。大卫任命他为侍卫长。 ");
INSERT INTO cmn2006_vpl VALUES ("S223_24","011_23_24","2SA","23","24","24","三十勇士是： 亚撒黑－约押的弟弟； 伊勒哈难－伯利恒人朵多的儿子； ");
INSERT INTO cmn2006_vpl VALUES ("S223_25","011_23_25","2SA","23","25","25","沙玛－哈律人； 以利加－哈律人； ");
INSERT INTO cmn2006_vpl VALUES ("S223_26","011_23_26","2SA","23","26","26","希利斯－帕勒提人； 以拉－提哥亚人益吉的儿子； ");
INSERT INTO cmn2006_vpl VALUES ("S223_27","011_23_27","2SA","23","27","27","亚比以谢－亚拿实人； 米本乃－户沙人， ");
INSERT INTO cmn2006_vpl VALUES ("S223_28","011_23_28","2SA","23","28","28","撒们－亚合人； 玛哈莱－尼陀法人； ");
INSERT INTO cmn2006_vpl VALUES ("S223_29","011_23_29","2SA","23","29","29","希立－尼陀法人巴拿的儿子； 以太－便雅悯支派基比亚人利拜的儿子； ");
INSERT INTO cmn2006_vpl VALUES ("S223_30","011_23_30","2SA","23","30","30","比拿雅－比拉顿人； 希太－迦实谷人； ");
INSERT INTO cmn2006_vpl VALUES ("S223_31","011_23_31","2SA","23","31","31","亚比亚本－亚拉巴人； 押斯玛弗－巴鲁米人； ");
INSERT INTO cmn2006_vpl VALUES ("S223_32","011_23_32","2SA","23","32","32","以利雅哈巴－沙本人； 雅善的儿子们； 约拿单； ");
INSERT INTO cmn2006_vpl VALUES ("S223_33","011_23_33","2SA","23","33","33","沙玛－哈拉人； 亚希暗－哈拉人沙拉的儿子； ");
INSERT INTO cmn2006_vpl VALUES ("S223_34","011_23_34","2SA","23","34","34","以利法列－玛迦人亚哈拜的儿子； 以连－基罗人亚希多弗的儿子； ");
INSERT INTO cmn2006_vpl VALUES ("S223_35","011_23_35","2SA","23","35","35","希斯莱－迦密人； 帕莱－亚巴人； ");
INSERT INTO cmn2006_vpl VALUES ("S223_36","011_23_36","2SA","23","36","36","以甲－琐巴人拿单的儿子； 巴尼－迦得人； ");
INSERT INTO cmn2006_vpl VALUES ("S223_37","011_23_37","2SA","23","37","37","洗勒－亚扪人； 拿哈莱－比录人，洗鲁雅的儿子约押的兵器官； ");
INSERT INTO cmn2006_vpl VALUES ("S223_38","011_23_38","2SA","23","38","38","以拉－以帖人； 迦立－以帖人； ");
INSERT INTO cmn2006_vpl VALUES ("S223_39","011_23_39","2SA","23","39","39","乌利亚－赫人。共三十七人。 ");
INSERT INTO cmn2006_vpl VALUES ("S224_1","011_24_1","2SA","24","1","1","主又对以色列人发怒，使大卫跟他们作对。主说∶“你去查清以色列和犹大的人数。” ");
INSERT INTO cmn2006_vpl VALUES ("S224_2","011_24_2","2SA","24","2","2","于是，王吩咐约押和他部下的军官们∶“你们去出巡从但到别是巴的以色列各个支派，登记能出征作战的人，我要知道他们到底有多少。” ");
INSERT INTO cmn2006_vpl VALUES ("S224_3","011_24_3","2SA","24","3","3","约押答道∶“愿主－你的上帝使你的部下比现在增多百倍，也愿陛下能亲眼看见这一切实现；又何必去做这样的事呢？” ");
INSERT INTO cmn2006_vpl VALUES ("S224_4","011_24_4","2SA","24","4","4","然而王命难违，约押和军官们辞别王去登记能入伍作战的以色列人。 ");
INSERT INTO cmn2006_vpl VALUES ("S224_5","011_24_5","2SA","24","5","5","渡过约旦河以后，他们在山谷南面的亚罗珥城附近宿营，然后穿过迦得，前往雅谢， ");
INSERT INTO cmn2006_vpl VALUES ("S224_6","011_24_6","2SA","24","6","6","再往基列和他亭合示地区，再到但雅安，然后绕到西顿， ");
INSERT INTO cmn2006_vpl VALUES ("S224_7","011_24_7","2SA","24","7","7","再前往推罗堡和希未人及迦南人的城镇，最后到达犹大南部的别是巴。 ");
INSERT INTO cmn2006_vpl VALUES ("S224_8","011_24_8","2SA","24","8","8","他们走遍全国，历时九个月零二十天，然后回到耶路撒冷。 ");
INSERT INTO cmn2006_vpl VALUES ("S224_9","011_24_9","2SA","24","9","9","约押向王报告了能持刀上阵作战的人数，以色列有八十万能持刀上阵的壮丁，而犹大有五十万人。 ");
INSERT INTO cmn2006_vpl VALUES ("S224_10","011_24_10","2SA","24","10","10","大卫清查了能入伍作战的人之后，心中不安，向主祷告说∶“我做这件事犯了大罪。主啊，求你免去你仆人的罪。我做了一件愚蠢至极的事！” ");
INSERT INTO cmn2006_vpl VALUES ("S224_11","011_24_11","2SA","24","11","11","第二天早晨大卫起床之前，主默示大卫的先知迦得说∶ ");
INSERT INTO cmn2006_vpl VALUES ("S224_12","011_24_12","2SA","24","12","12","“你去告诉大卫：‘主是这样说的：我给你三个选择，你可以选其中的一个，我要用它来惩罚你。’” ");
INSERT INTO cmn2006_vpl VALUES ("S224_13","011_24_13","2SA","24","13","13","迦得去见大卫，对他说∶“你要国内七年的饥荒？还是三个月被敌军追得狼狈而逃？或是国内三天的瘟疫？你好好想一想，然后告诉我该怎样回复我的差遣者。” ");
INSERT INTO cmn2006_vpl VALUES ("S224_14","011_24_14","2SA","24","14","14","大卫对迦得说∶“我苦恼极了。让我们落在主的手里吧，因为主有丰盛的怜悯；不要让我们落在世人的手里。” ");
INSERT INTO cmn2006_vpl VALUES ("S224_15","011_24_15","2SA","24","15","15","从那天清晨起，主在选定的时间内向以色列人降下瘟疫，从但到别是巴有七万人死亡。 ");
INSERT INTO cmn2006_vpl VALUES ("S224_16","011_24_16","2SA","24","16","16","当天使正要伸手毁灭耶路撒冷时，主对造成的灾难感到悲伤，就对惩罚民众的天使说∶“够了！住手吧！”主的天使当时正在耶布斯人亚劳拿的打谷场上。 ");
INSERT INTO cmn2006_vpl VALUES ("S224_17","011_24_17","2SA","24","17","17","大卫看见了击杀民众的天使，就向主祷告说∶“我才是那做了错事的罪人，他们做了什么？他们不过是你的羊，让惩罚落在我和我的家族身上吧！” ");
INSERT INTO cmn2006_vpl VALUES ("S224_18","011_24_18","2SA","24","18","18","就在那天，迦得去见大卫，对他说∶“你到耶布斯人亚劳拿的打谷场上去为主建一座祭坛。” ");
INSERT INTO cmn2006_vpl VALUES ("S224_19","011_24_19","2SA","24","19","19","大卫按照主藉迦得给他的命令行事，来到亚劳拿的打谷场。 ");
INSERT INTO cmn2006_vpl VALUES ("S224_20","011_24_20","2SA","24","20","20","亚劳拿往下望，看见王带领部下向他走来，急忙迎上去，向王伏地叩拜。 ");
INSERT INTO cmn2006_vpl VALUES ("S224_21","011_24_21","2SA","24","21","21","亚劳拿问∶“不知陛下到仆人这里来有什么事？” 大卫答道∶“我想买你的打谷场，好为主建一座祭坛，这样，蔓延在人民中间的瘟疫就会停止了。” ");
INSERT INTO cmn2006_vpl VALUES ("S224_22","011_24_22","2SA","24","22","22","亚劳拿对大卫说∶“陛下，这里凡是你喜欢的，都可以拿去献给主。这儿有公牛可以做烧化祭，有打麦子的枷板和套牛的轭可以充作木柴。 ");
INSERT INTO cmn2006_vpl VALUES ("S224_23","011_24_23","2SA","24","23","23","亚劳拿愿把这一切都送给陛下。”接着亚劳拿又说∶“愿主－你的上帝悦纳你的祭献。” ");
INSERT INTO cmn2006_vpl VALUES ("S224_24","011_24_24","2SA","24","24","24","王答道∶“不，我一定要付钱买；我不能向主－我的上帝献上平白得来的烧化祭。” 于是大卫用五十块银子买下了打谷场和牛， ");
INSERT INTO cmn2006_vpl VALUES ("S224_25","011_24_25","2SA","24","25","25","在那里为主建了一座祭坛，并献上了烧化祭和平安祭。主垂听了大卫为国家所做的祷告，以色列人中间的瘟疫停止了。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_1","012_1_1","1KI","1","1","1","大卫王年事已高，虽然盖着被，仍感觉冷。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_2","012_1_2","1KI","1","2","2","于是，臣仆们向王禀告∶“请容臣等为陛下寻找一年少处女，让她照料陛下，与陛下同榻而卧，好让我主陛下能感觉暖和。” ");
INSERT INTO cmn2006_vpl VALUES ("K11_3","012_1_3","1KI","1","3","3","他们在全以色列遍求美貌少女，最后，选定书念人亚比煞，把她进献给王。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_4","012_1_4","1KI","1","4","4","亚比煞极其美貌动人，她照料王，侍奉王，但王并没有临幸她。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_5","012_1_5","1KI","1","5","5","当时，亚多尼雅（他的母亲是哈及）妄自尊大，说∶“我必作王！”他自备了车马，出行时有五十人为他开道。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_6","012_1_6","1KI","1","6","6","（他父亲从不问他∶“你这是要干什么？”也从不约束他。他相貌又英俊，是在押沙龙之后出生的。） ");
INSERT INTO cmn2006_vpl VALUES ("K11_7","012_1_7","1KI","1","7","7","亚多尼雅找洗鲁雅的儿子约押和祭司亚比亚他议事，他们表示支持他。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_8","012_1_8","1KI","1","8","8","但祭司撒督、耶何耶大的儿子比拿雅、先知拿单、示每、利以和大卫王的亲兵都不支持亚多尼雅。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_9","012_1_9","1KI","1","9","10","随后，亚多尼雅在隐罗结附近的琐希列磐石那里宰杀牛羊肥犊献祭，遍请诸王子－也就是他的兄弟－和在朝中任职的犹大人，惟独没有请先知拿单、比拿雅、大卫王的亲兵和他的弟弟所罗门。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_11","012_1_11","1KI","1","11","11","拿单对所罗门的母亲拔示巴说∶“你没有听说哈及的儿子亚多尼雅已经在我主大卫不知情的情况下自立为王吗？ ");
INSERT INTO cmn2006_vpl VALUES ("K11_12","012_1_12","1KI","1","12","12","让我指点你怎样保全你自己和你儿子所罗门的性命吧！ ");
INSERT INTO cmn2006_vpl VALUES ("K11_13","012_1_13","1KI","1","13","13","你去见王，对他说：‘陛下不是曾应允奴婢说∶“你的儿子所罗门必继位为王，坐在我的宝座之上”吗？现在亚多尼雅怎么成了王了呢？’ ");
INSERT INTO cmn2006_vpl VALUES ("K11_14","012_1_14","1KI","1","14","14","你跟王说话的时候，我会进去证实你所说的一切。” ");
INSERT INTO cmn2006_vpl VALUES ("K11_15","012_1_15","1KI","1","15","15","于是拔示巴起身去王的寝宫见王。王已经很老了，亚比煞正在照料他。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_16","012_1_16","1KI","1","16","16","拔示巴向王屈身下拜，王问∶“你有什么事吗？” ");
INSERT INTO cmn2006_vpl VALUES ("K11_17","012_1_17","1KI","1","17","17","拔示巴说∶“陛下啊，你曾指着主－你的上帝向奴婢起誓说：‘你的儿子所罗门必继位为王，坐在我的宝座之上。’ ");
INSERT INTO cmn2006_vpl VALUES ("K11_18","012_1_18","1KI","1","18","18","但现在亚多尼雅却突然成了王，而你，陛下却对此一无所知。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_19","012_1_19","1KI","1","19","19","亚多尼雅宰了许多牛羊肥犊献祭，遍请众王子和祭司亚比亚他、元帅约押，惟独没有请王的臣下所罗门。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_20","012_1_20","1KI","1","20","20","陛下啊，以色列民众都在关注你向他们宣布，谁将在陛下之后坐在你的宝座之上。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_21","012_1_21","1KI","1","21","21","不然，一旦陛下归于列祖之后，我和我的儿子必形同罪人了。” ");
INSERT INTO cmn2006_vpl VALUES ("K11_22","012_1_22","1KI","1","22","22","正当拔示巴与王说话的时候，先知拿单到了。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_23","012_1_23","1KI","1","23","23","有人向王禀奏∶“先知拿单来了。”拿单谒见王，俯伏于地， ");
INSERT INTO cmn2006_vpl VALUES ("K11_24","012_1_24","1KI","1","24","24","说∶“陛下当真说过：‘亚多尼雅当继我为王，坐于我的宝座之上’吗？ ");
INSERT INTO cmn2006_vpl VALUES ("K11_25","012_1_25","1KI","1","25","25","他今天外出，宰了许多牛羊肥犊献祭，遍请了众王子和将领，还请了祭司亚比亚他。他们现在正跟亚多尼雅一齐又吃又喝，还说什么：‘亚多尼雅王万岁！’ ");
INSERT INTO cmn2006_vpl VALUES ("K11_26","012_1_26","1KI","1","26","26","只有我，你的仆人，还有祭司撒督、耶何耶大的儿子比拿雅，王的臣下所罗门不在被邀之列。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_27","012_1_27","1KI","1","27","27","这事果真是陛下所为，不让臣等知道谁当在陛下百年之后坐于宝座之上吗？” ");
INSERT INTO cmn2006_vpl VALUES ("K11_28","012_1_28","1KI","1","28","28","大卫王吩咐∶“召拔示巴！”拔示巴进来，侍立在王的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_29","012_1_29","1KI","1","29","29","大卫王发誓说∶“我指着救我脱离一切苦难的活生生的主发誓， ");
INSERT INTO cmn2006_vpl VALUES ("K11_30","012_1_30","1KI","1","30","30","今天我就履行在主－以色列的上帝面前对你许下的诺言：‘你的儿子所罗门必将继位为王，他必代我坐于我的宝座之上。。” ");
INSERT INTO cmn2006_vpl VALUES ("K11_31","012_1_31","1KI","1","31","31","拔示巴拜伏在地，说∶“愿我主大卫万岁！” ");
INSERT INTO cmn2006_vpl VALUES ("K11_32","012_1_32","1KI","1","32","32","大卫王又吩咐∶“召祭司撒督、先知拿单、耶何耶大的儿子比拿雅！” 他们应召来到王的面前。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_33","012_1_33","1KI","1","33","33","王对他们说∶“你们率领我的部下，让我的儿子所罗门骑我的骡子，护送他到基训泉去， ");
INSERT INTO cmn2006_vpl VALUES ("K11_34","012_1_34","1KI","1","34","34","让祭司撒督和先知拿单在那里膏他为王。你们要吹号高呼：‘所罗门王万岁！’ ");
INSERT INTO cmn2006_vpl VALUES ("K11_35","012_1_35","1KI","1","35","35","然后随他回来，让他坐在我的宝座之上，代我为王。我已经立他为以色列和犹大之王。” ");
INSERT INTO cmn2006_vpl VALUES ("K11_36","012_1_36","1KI","1","36","36","耶何耶大的儿子比拿雅答道∶“阿们！但愿如此！愿主－我主陛下的上帝成全此事。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_37","012_1_37","1KI","1","37","37","愿主－我主陛下的上帝与所罗门同在，就象他始终与陛下同在一样，使所罗门的王国比我主大卫王陛下的王国更强大。” ");
INSERT INTO cmn2006_vpl VALUES ("K11_38","012_1_38","1KI","1","38","38","就这样，祭司撒督、先知拿单、耶何耶大的儿子比拿雅和基利提人、比利提人一齐簇拥所罗门骑上大卫王的骡子，将他护送到基训。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_39","012_1_39","1KI","1","39","39","祭司撒督从帐幕中取出盛膏油的角，膏了所罗门。随后人们吹起号，一齐高呼∶“所罗门王万岁！” ");
INSERT INTO cmn2006_vpl VALUES ("K11_40","012_1_40","1KI","1","40","40","人们簇拥着他，一边吹笛一边兴高彩烈地大声呼喊，连大地都被震动了。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_41","012_1_41","1KI","1","41","41","亚多尼雅和宾客们饮宴方毕就听到了喧闹声。约押听到号声，说∶“城里怎么这样喧闹？” ");
INSERT INTO cmn2006_vpl VALUES ("K11_42","012_1_42","1KI","1","42","42","话还没说完，祭司亚比亚他的儿子约拿单到了。 亚多尼雅说∶“来吧，象你这样可敬的人一定是带好消息来的。” ");
INSERT INTO cmn2006_vpl VALUES ("K11_43","012_1_43","1KI","1","43","43","“全完了！”约拿单答道∶“大卫王陛下已经立所罗门为王了！ ");
INSERT INTO cmn2006_vpl VALUES ("K11_44","012_1_44","1KI","1","44","44","王差遣祭司撒督、先知拿单、耶何耶大的儿子比拿雅和基利提人、比利提人去拥立所罗门，让所罗门骑上王的骡子， ");
INSERT INTO cmn2006_vpl VALUES ("K11_45","012_1_45","1KI","1","45","45","祭司撒督已经在基训膏所罗门为王，他们已经从那里欢呼归来，所以城里才这样喧闹；这就是你们听到的声音。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_46","012_1_46","1KI","1","46","46","所罗门现在已经即位， ");
INSERT INTO cmn2006_vpl VALUES ("K11_47","012_1_47","1KI","1","47","47","朝臣都赶来向大卫王陛下道贺，说：‘愿上帝使所罗门比你更名闻遐迩，让他的王国比你的更强大。’王在床上伏身敬拜主， ");
INSERT INTO cmn2006_vpl VALUES ("K11_48","012_1_48","1KI","1","48","48","还不停地祈祷：‘赞美主－以色列的上帝，他让我的后代坐上我的宝座，还让我亲眼看到了这一切。’” ");
INSERT INTO cmn2006_vpl VALUES ("K11_49","012_1_49","1KI","1","49","49","亚多尼雅的宾客们听了，吓得一哄而散。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_50","012_1_50","1KI","1","50","50","亚比尼雅对所罗门心怀畏惧，就跑去抓住祭坛的角。 ");
INSERT INTO cmn2006_vpl VALUES ("K11_51","012_1_51","1KI","1","51","51","有人向所罗门禀报∶“亚多尼雅害怕所罗门王，他抓住祭坛的角，说：‘请所罗门王向我起誓，他决不杀他的仆人。’” ");
INSERT INTO cmn2006_vpl VALUES ("K11_52","012_1_52","1KI","1","52","52","所罗门王说∶“如果他行为可敬，连一根头发也不会掉；如果他心术不正，就必死无疑。” ");
INSERT INTO cmn2006_vpl VALUES ("K11_53","012_1_53","1KI","1","53","53","所罗门王派人把亚多尼雅从祭坛上带下来；亚多尼雅来参拜所罗门王，所罗门对他说∶“你回家去吧。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","大卫的死期临近了，他告诫他的儿子所罗门说∶ ");
INSERT INTO cmn2006_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","“我就要走那人人都必走的路了，你要刚强，要充满勇气， ");
INSERT INTO cmn2006_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","要牢记主－你的上帝的训诫，要遵循主所指引的路，要按照摩西律法书上的规定谨守他的律例、诫命、典章和法度，这样你就会事事顺利，无往不胜； ");
INSERT INTO cmn2006_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","主就一定会信守他对我的应许：‘只要你的子孙谨慎自己的行为，专心一志地走我指引的路，你就不愁以色列的宝座后继无人。’ ");
INSERT INTO cmn2006_vpl VALUES ("K12_5","012_2_5","1KI","2","5","5","“你也知道洗鲁雅的儿子约押怎样对待我和以色列的两位元帅－尼珥的儿子押尼珥和益帖的儿子亚玛撒的。他杀害了他们，在太平时期报复在战争期间所流的血，这血染红了他的腰带和脚上的鞋。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_6","012_2_6","1KI","2","6","6","你要运用你的智慧，不要让他白头终老，安然谢世。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_7","012_2_7","1KI","2","7","7","“但你要善待基列人巴西莱的儿子们，要让他们与你同桌进餐。当我逃避你的哥哥押沙龙的时候，他们曾竭诚接待过我。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_8","012_2_8","1KI","2","8","8","“还有便雅悯人示每，他现在就在你的身边，当年去玛哈念的时候，他曾用恶毒的语言咒骂我，后来却又到约旦河来迎接我；当时我指着主对他起誓说：‘我决不杀你。’ ");
INSERT INTO cmn2006_vpl VALUES ("K12_9","012_2_9","1KI","2","9","9","但你不要就以为他无罪了，你是个聪明人，知道应该怎样对待他，即使他的头发白了，也要让他流着血下阴间。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","大卫返归列祖，葬在大卫城。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","大卫统治以色列四十年－在希伯伦七年，在耶路撒冷三十三年。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","所罗门继承了父亲大卫的王位，建立起巩固的政权。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_13","012_2_13","1KI","2","13","13","哈及的儿子亚多尼雅谒见所罗门的母亲拔示巴。拔示巴问∶“没有什么麻烦事吧？” 亚多尼雅答道∶“没有。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_14","012_2_14","1KI","2","14","14","接着又说∶“我有点事想求你。” 拔示巴说∶“你说吧。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_15","012_2_15","1KI","2","15","15","亚多尼雅说∶“你知道王位本该是属于我的，以色列人也都盼望我做王，不料事情起了变化，王位归了我兄弟，这是主的意志。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_16","012_2_16","1KI","2","16","16","现在，我有一件事求你，请你不要推辞。” 拔示巴说∶“你说吧！” ");
INSERT INTO cmn2006_vpl VALUES ("K12_17","012_2_17","1KI","2","17","17","亚多尼雅说∶“请让所罗门王把亚比煞赐给我为妻，他一定不会拒绝你的。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_18","012_2_18","1KI","2","18","18","拔示巴说∶“好吧，我一定替你说这件事。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_19","012_2_19","1KI","2","19","19","拔示巴去见所罗门王说亚多尼雅的事。王起身迎接，向她下拜，然后回到座位上，命人为母后设一座位，拔示巴便在王的右边坐下。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_20","012_2_20","1KI","2","20","20","拔示巴说∶“我有一件小事求你，希望你不要拒绝。” 王答道∶“请母亲说，我决不拒绝。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_21","012_2_21","1KI","2","21","21","拔示巴说∶“请你把书念姑娘亚比煞赐给你哥哥亚多尼雅为妻吧！” ");
INSERT INTO cmn2006_vpl VALUES ("K12_22","012_2_22","1KI","2","22","22","所罗门王对母亲说∶“何必只为他求亚比煞为妻呢？也可以为他求王位呀！他到底是我的哥哥，何况还有祭司亚比亚他和洗鲁雅的儿子约押辅佐！” ");
INSERT INTO cmn2006_vpl VALUES ("K12_23","012_2_23","1KI","2","23","23","所罗门王指着主发誓说∶“如果亚多尼雅不为他的请求付出生命的话，愿上帝重重地惩罚我！ ");
INSERT INTO cmn2006_vpl VALUES ("K12_24","012_2_24","1KI","2","24","24","主选定了我，把我安置在我父亲大卫王的宝座之上，并按照他的应许为我建起一代王朝，我指着活生生的主发誓，今天一定要处死亚多尼雅！” ");
INSERT INTO cmn2006_vpl VALUES ("K12_25","012_2_25","1KI","2","25","25","所罗门王命令耶何耶大的儿子比拿雅处死了亚多尼雅。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_26","012_2_26","1KI","2","26","26","所罗门王对祭司亚比亚他说∶“你回亚拿突你自己的庄园去吧！你本来难逃一死，但你曾在我的父王大卫时代抬过至高的主的圣柜，又与我的父亲共渡患难，所以我今天不杀你。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_27","012_2_27","1KI","2","27","27","所罗门革除了亚比亚他的祭司职位，应验了主在示罗所说的有关以利家族的话。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_28","012_2_28","1KI","2","28","28","约押虽然没有依附押沙龙，却是亚多尼雅的同谋。他得到消息，就逃进主的帐幕，抓住祭坛的角。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_29","012_2_29","1KI","2","29","29","所罗门王得到禀报∶约押逃进了主的帐幕，就在祭坛旁边。所罗门王命令耶何耶大的儿子比拿雅∶“去杀掉他！” ");
INSERT INTO cmn2006_vpl VALUES ("K12_30","012_2_30","1KI","2","30","30","比拿雅走进主的帐幕，对约押说∶“王命令你出来！” 约押说∶“不，我要死在这里！” 比拿雅回禀王∶“约押是如此这般回答我的。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_31","012_2_31","1KI","2","31","31","王说∶“你就照他说的办，把他杀死埋掉，从此，约押杀害无辜的罪与我和我父亲的家族无关了。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_32","012_2_32","1KI","2","32","32","这是主对他杀人害命的报应。约押在我父亲不知情的情况下杀了两个人，一个是以色列元帅、尼珥的儿子押尼珥，另一个是犹大元帅、益帖的儿子亚玛撒，他们都是正直的人，比约押好得多。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_33","012_2_33","1KI","2","33","33","杀害这两个人的罪将永远落在约押和他后代的头上，而降于大卫和他的后代、他的家族、他的王国的将是来自主的永久的安宁。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_34","012_2_34","1KI","2","34","34","耶何耶大的儿子比拿雅进去杀死了约押，把他的尸体葬在旷野中他自己的庄园里。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_35","012_2_35","1KI","2","35","35","王任命耶何耶大的儿子比拿雅取代约押的元帅职位，祭司撒督取代亚比亚他。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_36","012_2_36","1KI","2","36","36","王命人将示每召来，对他说∶“你只许在耶路撒冷起造房屋，住在这里，不许往别处去。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_37","012_2_37","1KI","2","37","37","你要明白，哪天你离开耶路撒冷越过汲沦溪，哪天就是你的死期，你的血就要溅在你自己的头上。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_38","012_2_38","1KI","2","38","38","示每答道∶“陛下圣明，仆人一定遵从王命。”示每在耶路撒冷过了很长一段日子。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_39","012_2_39","1KI","2","39","39","三年过去了，示每有两个奴隶逃到迦特王玛迦的儿子亚吉那里去了。有人告诉示每∶“你的奴隶现在就在迦特。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_40","012_2_40","1KI","2","40","40","听到这消息，示每就备上驴，去迦特找到他的奴隶，把他们从迦特带了回来。 ");
INSERT INTO cmn2006_vpl VALUES ("K12_41","012_2_41","1KI","2","41","41","所罗门听说示每离开耶路撒冷去了迦特又回来了， ");
INSERT INTO cmn2006_vpl VALUES ("K12_42","012_2_42","1KI","2","42","42","就召见示每，对他说∶“我不是让你指着主起过誓，还警告过你：‘你要明白，哪天你离开耶路撒冷到别处去，哪天就是你的死期’吗？你当时也对我说过：‘我一定遵从王命。’ ");
INSERT INTO cmn2006_vpl VALUES ("K12_43","012_2_43","1KI","2","43","43","现在你为什么不遵守你指着主起的誓和我给你的命令呢？” ");
INSERT INTO cmn2006_vpl VALUES ("K12_44","012_2_44","1KI","2","44","44","接着，王又对示每说∶“你自己心里也明白你对我父王大卫做过的坏事，现在主要按照你的恶行报应你了， ");
INSERT INTO cmn2006_vpl VALUES ("K12_45","012_2_45","1KI","2","45","45","但所罗门王将永远蒙福，大卫王的宝座将在主的面前万世永存。” ");
INSERT INTO cmn2006_vpl VALUES ("K12_46","012_2_46","1KI","2","46","46","随后，王命令耶何耶大的儿子比拿雅去处死示每，比拿雅就去砍杀了示每。就这样，所罗门巩固了他的王位。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_1","012_3_1","1KI","3","1","1","所罗门与埃及王结盟，娶了埃及王的女儿为妻，但直到造完了自己的王宫和主的圣殿以及环绕耶路撒冷的城墙后，所罗门才把她接进大卫城。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_2","012_3_2","1KI","3","2","2","当时人们仍然在邱坛上献牲祭，因为还没有一座奉主的名而建的殿宇。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","所罗门爱主，处处遵循父亲大卫定下的一切规定，只是他当时也在邱坛上焚香献祭。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","所罗门王去基遍献祭，因为那里的邱坛最为显要。所罗门王献上了一千只祭牲作烧化祭。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","夜间，主在梦中向他显现，对他说∶“你可以向我请求你想要的任何东西。” ");
INSERT INTO cmn2006_vpl VALUES ("K13_6","012_3_6","1KI","3","6","6","所罗门答道∶“你的仆人、我的父亲忠心于你，而且为人正直、公平，你就对他大施恩宠，并由此赐给他一个儿子，让他今天坐在他的宝座之上，使这恩宠至今犹在。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","主啊，我的上帝，你如今让仆人继承我的父亲大卫为王，但我还太年轻，不知道怎样履行我的职责。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","你的仆人现在跟你的选民在一起，这是一个伟大的民族，人数多得数不清。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","因此，求你赐给仆人一颗睿智的心，好让我能明辨是非，引导你的子民。不然，谁能有能力管理你这为数众多的子民呢？” ");
INSERT INTO cmn2006_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","所罗门的请求使主非常喜悦。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","上帝对他说∶“你不为自己求富贵长寿，不求剪除你的仇敌，只求为主持正义所需的智慧， ");
INSERT INTO cmn2006_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","我一定应你所求，赐给你一颗睿智而聪慧的心。前人没有一个能比得上你，今后也没有人能跟你相比。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","你没有请求的东西我也要赐给你－无论是财富还是荣耀。在你的有生之年，没有任何一位君王能跟你相比。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","只要你象你父亲大卫一样遵循我指引的路，谨守我的律法和诫命，我一定赐你长寿。” ");
INSERT INTO cmn2006_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","所罗门醒了，原来是个梦。他返回耶路撒冷，在主的约柜前献上了烧化祭和平安祭。随后设宴招待群臣。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","一天，有两个妓女求见王。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","一个说∶“陛下，这个女人和我住在一个屋子里，我们同住的时候，我生了一个孩子。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","我生孩子后的第三天，她也生了一个孩子。我们跟别人没有来往，只有我们两个人住在一起。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","夜里，这女人睡觉的时候把孩子压死了， ");
INSERT INTO cmn2006_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","她半夜起来趁我熟睡的时候，从我身边抱走了我的孩子，把他搂在自己怀里，却把死孩子放到我的怀里。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","第二天早晨，我起来要给孩子喂奶，却发现孩子死了！我借着晨光细看孩子，发现这不是我的孩子。” ");
INSERT INTO cmn2006_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","另一个女人说∶“你说的不对！活孩子是我的，死孩子才是你的。” 第一个女人说∶“不，活孩子是我的，死孩子是你的。”两个人在王的面前争论不休。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","王说∶“这个说：‘活孩子是我的，死孩子是你的，’那个说：‘不，活孩子是我的，死孩子是你的。’” ");
INSERT INTO cmn2006_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","王下令∶“拿刀来！”有人拿来一把刀。 ");
INSERT INTO cmn2006_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","王说∶“把活孩子劈成两半，给她们每人一半。” ");
INSERT INTO cmn2006_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","活孩子的母亲心里痛惜孩子，急忙对王说∶“陛下啊，就把活孩子给了她吧，别杀孩子！” 另一个女人却说∶“你我都别想得到他，把他劈成两半吧！” ");
INSERT INTO cmn2006_vpl VALUE