﻿USE sofia;
DROP TABLE IF EXISTS sofia.cmn_ncvt_vpl;
CREATE TABLE cmn_ncvt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cmn_ncvt_vpl WRITE;
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","起初，　神創造天地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","地是空虛混沌；深淵上一片黑暗；　神的靈運行在水面上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","神說：“要有光！”就有了光。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","神看光是好的，他就把光暗分開了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","神稱光為晝，稱暗為夜。有晚上，有早晨；這是第一日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","神說：“眾水之間要有穹蒼，把水和水分開！”事就這樣成了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","神造了穹蒼，把穹蒼以下的水和穹蒼以上的水分開了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","神稱穹蒼為天。有晚上，有早晨；這是第二日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","神說：“天下的水要聚在一處，使旱地露出來！”事就這樣成了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","神稱旱地為地，稱水的聚處為海。　神看這是好的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","神說：“地上要長出青草、結種子的蔬菜和結果子的樹木，各從其類，在地上的果子都包著核！”事就這樣成了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","於是，地上長出了青草和結種子的蔬菜，各從其類；又長出結果子的樹木，各從其類，果子都包著核。　神看這是好的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","有晚上，有早晨；這是第三日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","神說：“在天上穹蒼中，要有光體來分晝夜；這些光體要作為記號，定節令、日子和年歲； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","它們要在天上穹蒼中發光，照耀地上！”事就這樣成了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","於是，　神造了兩個大光體，大的管晝，小的管夜；又造了星星。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","神把這些光體安放在天上穹蒼中，照耀地上， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","管晝夜，分光暗。　神看這是好的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","有晚上，有早晨；這是第四日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","神說：“水要滋長生物；地上和天空之中，要有雀鳥飛翔！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","於是，　神創造了大魚和在水中滋生各種能活動的生物，各從其類；又創造了各種有翅膀的飛鳥，各從其類。　神看這是好的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","神就賜福給牠們，說：“要繁殖增多，充滿海洋；雀鳥也要在地上增多！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","有晚上，有早晨；這是第五日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","神說：“地上要生出活物來，各從其類；牲畜、昆蟲和地上的野獸，各從其類！”事就這樣成了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","於是，　神造了地上的野獸，各從其類；牲畜，各從其類；地上的各種昆蟲，各從其類。　神看這是好的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","神說：“我們要照著我們的形象，按著我們的樣式造人；使他們管理海裡的魚、空中的鳥、地上的牲畜，以及全地，和地上所有爬行的生物！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","於是，　神照著自己的形象創造人；就是照著他的形象創造了人；他所創造的有男有女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","神就賜福給他們，對他們說：“要繁殖增多，充滿這地，征服它；也要管理海裡的魚、空中的鳥和地上爬行的所有生物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","神說：“看哪！我把全地上結種子的各樣蔬菜，和一切果樹上有種子的果子，都賜給你們作食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","至於地上的各種野獸，空中的各種飛鳥，和地上爬行有生命的各種活物，我把一切青草蔬菜賜給牠們作食物。”事就這樣成了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","神看他所造的一切都很好。有晚上，有早晨；這是第六日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","這樣，天地萬物都造齊了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","第七日，　神完成了他所作的工；在第七日　神歇了他所作的一切工。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","神賜福第七日，把它分別為聖，因為在這一日，　神停了他一切所創造的工，歇息了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","這是創造天地的起源：耶和華　神造天地的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","原野上還沒有樹木，田間的蔬菜還沒有長起來，因為耶和華　神還沒有降雨在地上，也沒有人耕種土地； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","不過有霧氣從地面上升，滋潤全地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","耶和華　神用地上的塵土造成人形，把生氣吹進他的鼻孔裡，那人就成了有生命的活人，名叫亞當。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","耶和華　神在東方的伊甸，栽了一個園子，把他所造的人放在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","耶和華　神使各樣的樹從地上長起來，能悅人的眼目，也好作食物。園子中間又有生命樹，和知善惡樹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","有一條河從伊甸流出來，灌溉那園子；從那裡分支，成了四道河的源頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","第一道河名叫比遜，就是環繞哈腓拉全地的，在那裡有金子； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","那地的金子是好的；在那裡也有紅玉和瑪瑙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","第二道河名叫基訓，就是環繞古實全地的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","第三道河名叫底格里斯河（“底格里斯河”原文作“希底結”），就是流向亞述東邊的。第四道河就是幼發拉底河（“幼發拉底河”原文作“伯拉河”）。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","耶和華　神把那人安置在伊甸園裡，叫他耕種和看守那園子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","耶和華　神吩咐那人說：“園中各樣樹上的果子，你都可以吃； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","只是那知善惡樹的果子，你不可吃；因為你吃的時候，你必要死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","耶和華　神說：“那人獨居不好，我要為他造個和他相配的幫手。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","耶和華　神用泥土造了野地的各樣野獸，和空中的各樣飛鳥，把牠們都帶到那人面前，看他給牠們叫甚麼名字；那人怎樣叫各樣有生命的活物，那就是牠的名字。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","那人就給各樣牲畜、空中的雀鳥，和野地的各樣走獸起了名字；只是那人沒有遇見一個和他相配的幫手。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","耶和華　神使那人沉睡。他熟睡的時候，耶和華　神取了他的一根肋骨，又使肉在原處復合。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","然後，耶和華　神用從那人身上所取的肋骨，造了一個女人，帶她到那人面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","那人說：“這是我骨中的骨，肉中的肉；她當稱為女人，因她是從男人身上取出來的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","因此人要離開父母，和妻子連合，二人成為一體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","那時，夫妻二人赤身露體，彼此都不覺得羞恥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","在耶和華　神所造野地所有的活物中，蛇是最狡猾的。蛇對女人說：“　神真的說過，你們不可吃園中任何樹上的果子嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","女人對蛇說：“園中樹上的果子，我們都可以吃； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","只有園中那棵樹上的果子，　神曾經說過：‘你們不可吃，也不可摸，免得你們死。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","蛇對女人說：“你們決不會死； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","因為　神知道你們吃那果子的時候，你們的眼睛就開了；你們會像　神一樣，能知道善惡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","於是，女人見那棵樹的果子好作食物，又悅人的眼目，而且討人喜愛，能使人有智慧，就摘下果子來吃了；又給了和她在一起的丈夫，他也吃了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","二人的眼睛就開了，才知道自己是赤身露體的。於是把無花果樹的葉子編縫起來，為自己做裙子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","天起涼風的時候，那人和他的妻子聽見耶和華　神在園中行走的聲音，就藏在園子的樹林中，躲避耶和華　神的面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","耶和華　神呼喚那人，對他說：“你在哪裡？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","他回答：“我在園中聽見你的聲音，就害怕；因為我赤身露體，就藏了起來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","耶和華　神說：“誰告訴你，你是赤身露體呢？難道你吃了我吩咐你不可吃的那樹上的果子嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","那人說：“你所賜給我、和我在一起的那女人，她把樹上的果子給我，我就吃了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","耶和華　神對女人說：“你作了甚麼事呢？”女人說：“那蛇欺哄我，我就吃了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","耶和華　神對蛇說：“因為你作了這事，就必在所有的牲畜和田野的活物中受咒詛；你要用肚子行走，一生都吃泥土。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","我要使你和女人彼此為仇，你的後裔和女人的後裔，也彼此為仇，女人的後裔要傷你的頭，你要傷他的腳跟。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","耶和華　神對女人說：“我要大大增加你懷胎的痛苦，你必在痛苦中生產兒女；你要戀慕你的丈夫，他卻要管轄你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","耶和華　神又對亞當說：“因為你聽從了你妻子的話，吃了我吩咐你不可吃的那樹上的果子；地就必因你的緣故受咒詛；你必終生勞苦，才能從地裡得吃的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","地要給你長出荊棘和蒺藜來；你也要吃田間的蔬菜； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","你必汗流滿面，才有飯吃，直到你歸回地土，因為你是從地土取出來的；你既然是塵土，就要歸回塵土。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","亞當給他的妻子起名叫夏娃，因為她是眾生之母。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","耶和華　神為亞當和他的妻子做了皮衣，給他們穿上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","耶和華　神說：“那人和我們中間的一個相似，能知善惡；現在恐怕他伸出手來，摘取生命樹上的果子吃，就永遠活著。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","耶和華　神就把他趕出伊甸園，去耕種他自己也是從那裡出來的地土。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","於是把亞當驅逐出去，又派基路伯在伊甸園的東邊，拿著旋轉發火燄的劍，把守到生命樹去的路。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","亞當和他的妻子夏娃同房，夏娃就懷孕，生了該隱，就說：“藉著耶和華的幫助，我得了一個男兒。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","她又生了該隱的弟弟亞伯。亞伯是牧羊的，該隱是種地的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","有一天，該隱把地裡的出產拿來，當作禮物獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","亞伯也把自己羊群中一些頭生的，和羊的脂油拿來獻上。耶和華看中了亞伯和他的禮物； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","只是沒有看中該隱和他的禮物。該隱就非常忿怒，垂頭喪氣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","耶和華對該隱說：“你為甚麼忿怒呢？你為甚麼垂頭喪氣呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","你若行得好，豈不可以抬起頭來嗎？你若行得不好，罪就伏在門口了；它要纏住你，你卻要制伏它。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","該隱對他的弟弟亞伯說：“我們到田間去吧。”他們正在田間的時候，該隱就起來襲擊他的弟弟亞伯，把他殺了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","耶和華問該隱：“你的弟弟亞伯在哪裡？”他回答：“我不知道；難道我是看守我弟弟的嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","耶和華說：“你作了甚麼事呢？你弟弟的血有聲音從地裡向我呼叫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","地開了口，從你手裡接受了你弟弟的血，現在你要從這地受咒詛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","你種地，地也不再給你效力；你必在地上流離失所。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","該隱對耶和華說：“我的刑罰太重，過於我所能擔當。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","看哪，今日你趕逐我離開這地，以致我要躲避你的面；我必在地上流離失所，遇見我的，都要殺我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","耶和華對該隱說：“絕不會這樣，殺該隱的，必遭報七倍。”耶和華就給該隱立了一個記號，免得遇見他的人擊殺他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","於是該隱從耶和華面前出去，住在伊甸東邊的挪得地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","該隱和妻子同房，她就懷孕，生了以諾。該隱建造了一座城，就按著他兒子的名，給那城叫作以諾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","以諾生以拿，以拿生米戶雅利，米戶雅利生瑪土撒利，瑪土撒利生拉麥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","拉麥娶了兩個妻子，一個名叫亞大，另一個名叫洗拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","亞大生雅八，雅八就是居住帳棚、牧養牲畜的人的鼻祖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","雅八的兄弟名叫猶八；猶八是所有彈琴吹簫的人的鼻祖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","洗拉也生了土八．該隱，就是打造各種銅鐵器具的匠人；土八．該隱的妹妹是拿瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","拉麥對他的兩個妻子說：“亞大和洗拉，要聽我的聲音；拉麥的妻子，聆聽我的話：壯年人傷我，我必殺他；青年人損我，我必害他； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","人若殺該隱，要遭報七倍；人若殺拉麥，必遭報七十個七倍！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","亞當又和妻子同房，她就生了一個兒子，給他起名叫塞特，因為她說：“　神給我立了另一個後裔代替亞伯，因為該隱殺了他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","塞特也生了一個兒子，就給他起名叫以挪士。那時人才開始呼求耶和華的名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","以下是亞當後代的記錄。　神創造人的時候，是按著自己的樣式造的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","他創造了一男一女。在創造他們的時候，　神賜福給他們，稱他們為人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","亞當一百三十歲的時候，生了一個兒子，樣式和形象都和自己相似，就給他起名叫塞特。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","亞當生塞特以後，還活了八百年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","亞當共活了九百三十歲，就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","塞特一百零五歲的時候，生了以挪士。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","塞特生以挪士以後，還活了八百零七年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","塞特共活了九百一十二歲，就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","以挪士九十歲的時候，生了該南。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","以挪士生該南以後，還活了八百一十五年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","以挪士共活了九百零五歲，就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","該南七十歲的時候，生了瑪勒列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","該南生瑪勒列以後，還活了八百四十年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","該南共活了九百一十歲，就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","瑪勒列六十五歲的時候，生了雅列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","瑪勒列生雅列以後，還活了八百三十年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","瑪勒列共活了八百九十五歲，就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","雅列一百六十二歲的時候，生了以諾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","雅列生以諾以後，還活了八百年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","雅列共活了九百六十二歲，就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","以諾六十五歲的時候，生了瑪土撒拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","以諾生瑪土撒拉以後，和　神同行三百年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","以諾共活了三百六十五歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","以諾和　神同行，所以　神把他取去，他就不在了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","瑪土撒拉一百八十七歲的時候，生了拉麥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","瑪土撒拉生拉麥以後，還活了七百八十二年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","瑪土撒拉共活了九百六十九歲，就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","拉麥一百八十二歲的時候，生了一個兒子， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","就給他起名叫挪亞，說：“這兒子必使我們從地上的操作和手中的勞苦得著安慰，因為耶和華曾經咒詛這地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","拉麥生挪亞以後，還活了五百九十五年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","拉麥共活了七百七十七歲，就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","挪亞五百歲的時候，就生了閃、含和雅弗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","人在地上開始增多，又生養女兒的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","神的眾子看見人的女子美麗，就隨意挑選，娶作妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","耶和華說：“人既然是屬肉體的，我的靈就不永遠住在他裡面，但他的日子還有一百二十年。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","在那些日子，有巨人在地上；　神的兒子和人的女子結合，就生了上古英武有名的人物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","耶和華看見人在地上的罪惡很大，終日心裡思念的，盡都是邪惡的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","於是，耶和華後悔造人在地上，心中憂傷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","耶和華說：“我要把我創造的人，從地上消滅；無論是人或牲畜，是昆蟲或是天空的飛鳥，我都要消滅，因為我後悔造了他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","只有挪亞在耶和華眼前蒙恩。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","以下是挪亞的後代。挪亞是個義人，是當時一個完全人。挪亞和　神同行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","挪亞生了三個兒子，就是閃、含、雅弗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","當時，世界在　神面前敗壞了，地上滿了強暴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","神觀看大地，看見世界已經敗壞了；全人類在地上所行的都是敗壞的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","神對挪亞說：“在我面前全人類的盡頭已經來到，因為地上由於他們的緣故滿了強暴。看哪，我要把他們和世界一起毀滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","你要用歌斐木做一艘方舟。方舟裡面要做一些艙房；方舟的內外都要塗上瀝青。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","你要這樣做方舟：方舟要長一百三十三公尺，寬二十二公尺，高十三公尺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","方舟上面四周要做透光口，高四十四公寸；方舟的門要開在旁邊；方舟要分為上中下三層建造。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","看哪，我要使洪水臨到地上，消滅天下的生物，就是有生氣的活物；在地上的都必定要死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","我要和你立約。你可以進入方舟；你和你的兒子、妻子和兒媳，都可以和你一同進入方舟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","所有的活物，你要把每樣一對，就是一公一母，帶進方舟，好和你一同保全生命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","飛鳥各從其類，牲畜各從其類，地上所有爬行的動物，各從其類，每樣一對，都要到你那裡來，好保全生命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","你要拿各種可吃的食物，積存起來，好作你和牠們的食物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","挪亞就這樣作了；　神吩咐他的，他都照樣作了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","耶和華對挪亞說：“你和你全家都要進入方舟，因為在這世代中，我見只有你在我面前是個義人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","潔淨的牲畜，你要各帶七公七母；不潔淨的牲畜，你要各帶一公一母； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","空中的飛鳥，也要各帶七公七母，以便傳種，活在全地上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","因為再過七天，我就要一連四十晝夜降雨在地上，我把所造的一切生物都從地上除滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","挪亞就照著耶和華吩咐他的一切作了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","洪水臨到地上的時候，挪亞剛好是六百歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","挪亞帶著他的兒子、妻子和兒媳一同進了方舟，躲避洪水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","潔淨的牲畜和不潔淨的牲畜，飛鳥和各種在地上爬行的動物， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","都是一公一母、一對一對來到挪亞那裡，進入方舟，是照著　神吩咐挪亞的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","那七天一過，洪水就臨到地上了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","挪亞六百歲那一年，二月十七日那一天，所有大淵的泉源都裂開了，天上的窗戶都敞開了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","大雨傾盆下在地上，一連四十晝夜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","就在那一天，挪亞帶著他的兒子閃、含、雅弗，以及他的妻子和三個兒媳，一同進了方舟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","他們一家，所有走獸各從其類，所有牲畜各從其類，所有在地上爬行的動物各從其類，所有有羽有翼的飛禽各從其類， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","有生命、有氣息的，都是一對一對來到挪亞那裡，進入方舟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","那些進去的，都是有生命的，一公一母進去，是照著　神吩咐挪亞的。耶和華跟著就把方舟關起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","洪水就臨到地上四十天；水不斷上漲，把方舟升起，於是方舟就從地上浮起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","水勢甚大，在地上大大上漲，方舟就在水面上漂來漂去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","水勢在地面上越來越大，天下所有的高山都被淹沒了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","水勢浩大，比眾山高出七公尺，山嶺都被淹沒了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","凡有生命仍在地上行動的，無論是飛鳥或是牲畜，走獸或是在地上滋生的各樣小生物，以及所有的人都死了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","仍在陸地上，鼻孔裡有氣息的生靈都死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","耶和華把地上的所有生物，從人類到牲畜，爬行動物，以及空中的飛鳥都除滅了；於是，這一切都從地上消滅了。只留下挪亞和那些與挪亞一同在方舟裡的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","水勢浩大，在地上共一百五十天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","神顧念挪亞和所有與他一同在方舟裡的走獸和牲畜；　神使風吹過大地，水就漸漸退了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","深淵的泉源和天上的窗戶，都關閉起來；天降的大雨也止住了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","水從地上不斷退去，過了一百五十天，水就消退了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","七月十七日，方舟停在亞拉臘山上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","水繼續消退，直到十月；到了十月初一，山頂都露出來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","過了四十天，挪亞開了他所做的方舟的窗戶， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","放了一隻烏鴉出去。地上的水還沒有乾，那烏鴉就一直飛來飛去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","他又放了一隻鴿子出去，要看看水從地上退了沒有。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","因為遍地都是水，那鴿子找不著歇腳的地方，就回到挪亞的方舟那裡；於是，挪亞伸出手去，把鴿子接進方舟裡來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","他再等了七天，又把鴿子從方舟裡放出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","到了黃昏的時候，鴿子回到挪亞那裡，嘴裡叼著一塊新摘下來的橄欖樹葉，挪亞就知道地上的水已經退了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","挪亞再等了七天，又把鴿子放出去，鴿子就再沒有回到他那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","到挪亞六百零一歲的時候，就在正月初一，地上的水都乾了；挪亞移開方舟的蓋看看，見地面已經乾了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","到了二月二十七日，大地就都乾了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","神告訴挪亞說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“你要從方舟出來，你和你的妻子、兒子，以及兒媳都要和你一同出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","所有和你在一起有生命的活物：飛鳥、牲畜和一切在地上爬行的動物，你都要帶出來，使牠們可以在地上滋生、繁殖，也可以在地上增多。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","於是，挪亞出來了，他的兒子、妻子和兒媳都與他一同出來了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","各樣走獸、牲畜、飛禽和各樣在地上爬行的動物，各從自己的族類，都出了方舟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","挪亞給耶和華築了一座祭壇，拿各樣潔淨的牲畜和飛禽，獻在祭壇上作為燔祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","耶和華聞了那馨香的氣味，就心裡說：“我必不再因人的緣故咒詛這地（因為人從小時開始心中所想的都是邪惡的）；我也必不再照著我作過的，擊殺各樣的活物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","大地尚存之日，播種、收割，寒暑、冬夏、白晝和黑夜必然循環不息。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","神賜福給挪亞和他的兒子，對他們說：“你們要繁殖增多，充滿大地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","地上各樣的走獸，空中各樣的飛鳥，甚至地上各樣爬行的動物，和海裡各樣的魚類，都要對你們驚恐懼怕；這一切都已經交在你們手裡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","所有活著的動物都可以作你們的食物，我把這一切都賜給你們，好像我把青菜賜給了你們一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","唯獨帶著生命的肉，就是帶著血的肉，你們卻不可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","流你們的血、害你們生命的，我必向他們追償；無論是走獸或人類，甚至各人自己的兄弟，我必要他償命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","流人血的，人也必流他的血；因為　神造人，是按著他自己的形象。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","你們要繁殖增多；要在地上滋生、增多。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","神告訴挪亞和與他在一起的兒子說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“看哪，我現在與你們和你們的後裔立約， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","並且與所有跟你們在一起有生命的活物立約，包括飛鳥、牲畜和所有地上的走獸，就是與從方舟裡出來的立約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","我要與你們立約：凡有生命的必不再被洪水除滅，再沒有洪水來毀滅大地了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","神說：“這就是我與你們，與一切跟你們同在有生命的活物所立之約的記號，直到萬代； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","我把天虹放在雲彩中，作我與大地立約的記號。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","我使雲彩遮蓋大地時，天虹出現雲彩中， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","我就記念我與你們和一切有生命的活物所立的約：水不再成為洪水，來毀滅凡有生命的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","天虹在雲彩中出現，我看見了就記念我與地上一切有生命的活物，所立的永約。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","神對挪亞說：“這就是我與地上凡有生命的立約的記號。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","挪亞的兒子，從方舟裡出來的，就是閃、含、雅弗；含是迦南的父親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","這三個人是挪亞的兒子，全地的人都是從這些人播散開來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","挪亞作起農夫來，栽種葡萄園。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","他喝酒，喝醉了，就在帳棚裡光著身子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","迦南的父親含看見了自己父親的下體，就去告訴在外面的兩個兄弟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","於是，閃和雅弗二人拿了件外衣，搭在自己的肩膀上，倒退著進去，蓋上他們父親的下體；因為他們背著臉，所以沒有看見他們父親的下體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","挪亞酒醒以後，知道小兒子對他所作的事， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","就說：“迦南應當受咒詛，他必給自己的兄弟，作奴僕的奴僕。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","又說：“耶和華，閃的　神，是應當稱頌的；願迦南作他的奴僕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","願　神使雅弗擴展，使雅弗住在閃的帳棚裡；願迦南作他的奴僕。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","洪水以後，挪亞又活了三百五十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","挪亞共活了九百五十歲，就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","以下是挪亞的兒子閃、含、雅弗的後代。洪水以後，他們都生了兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","雅弗的兒子是歌篾、瑪各、瑪代、雅完、土巴、米設、提拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","歌篾的兒子是亞實基拿、利法、陀迦瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","雅完的兒子是以利沙、他施，基提人和多單人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","這些人的後裔分散居住在沿海的土地和島嶼上。各人隨著自己的方言、宗族，住在自己的國土中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","含的兒子是古實、埃及、弗和迦南。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","古實的兒子是西巴、哈腓拉、撒弗他、拉瑪和撒弗提迦。拉瑪的兒子是示巴和底但。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","古實又生寧錄；寧錄是世上第一位英雄。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","他在耶和華面前是個英勇的獵人；因此有句俗語說：“就像寧錄一樣，在耶和華面前是個英勇的獵人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","他開始建國是在示拿地的巴別、以力、亞甲和甲尼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","他從那地出來，到亞述去，建造了尼尼微、利河伯城、迦拉， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","和尼尼微與迦拉之間的利鮮，就是那大城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","埃及生路低人，亞拿米人、利哈比人、拿弗土希人、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","帕斯魯細人、迦斯路希人和迦斐託人；從迦斐託出來的有非利士人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","迦南生了長子西頓，又生赫， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","以及耶布斯人、亞摩利人、革迦撒人、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","希未人、亞基人、西尼人、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","亞瓦底人、洗瑪利人、哈馬人，後來迦南人的宗族分散了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","迦南人的境界是從西頓伸向基拉耳，直到迦薩；又伸向所多瑪、蛾摩拉、押瑪、洗扁，直到拉沙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","這些人都是含的子孫，隨著自己的宗族、方言，住在自己的國土中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","雅弗的哥哥閃，就是希伯所有子孫的祖宗，他也生了孩子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","閃的兒子是以攔、亞述、亞法撒、路德和亞蘭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","亞蘭的兒子是烏斯、戶勒、基帖、瑪施。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","亞法撒生沙拉，沙拉生希伯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","希伯生了兩個兒子，一個名叫法勒，因為他在世的時候，世人就分散了；法勒的兄弟名叫約坍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","約坍生亞摩答、沙列、哈薩瑪非、耶拉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","哈多蘭、烏薩、德拉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","俄巴路、亞比瑪利、示巴、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","阿斐、哈腓拉、約巴，這些人都是約坍的兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","他們居住的地方，是從米沙伸向西發，直到東邊的山地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","這都是閃的子孫，隨著自己的宗族、方言，住在自己的國土中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","這些宗族都是挪亞的子孫，按著他們的族系住在列國中。洪水以後，地上的列國都是從這些宗族分出來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","那時，全世界只有一種語言，大家說同樣的話語。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","他們向東遷移的時候，在示拿地發現一塊平原，就住在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","他們彼此說：“來，我們做磚，把磚燒透吧！”他們就把磚當作石頭，又把石漆當作灰泥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","他們又說：“來，我們建一座城，造一座塔，塔頂要通天。我們要為自己立名，免得分散在全地上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","耶和華下來，要看看世人建造的城和塔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","耶和華說：“看哪，他們同是一個民族，有一樣的語言，他們一開始就作這事，以後他們所要作的一切，就沒有可以攔阻他們的了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","來，我們下去，在那裡混亂他們的語言，使他們聽不懂對方的話。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","於是，耶和華把他們從那裡分散到全地上，他們就停止建造那城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","因此，那城的名就叫巴別，因為耶和華在那裡混亂了全地所有的人的語言，又從那裡把他們分散在全地上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","以下是閃的後代。洪水以後兩年，閃一百歲的時候，生了亞法撒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","閃生亞法撒以後，又活了五百年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","亞法撒活到三十五歲，就生了沙拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","亞法撒生沙拉以後，又活了四百零三年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","沙拉活到三十歲，就生了希伯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","沙拉生希伯以後，又活了四百零三年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","希伯活到三十四歲，就生了法勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","希伯生法勒以後，又活了四百三十年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","法勒活到三十歲，就生了拉吳。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","法勒生拉吳以後，又活了二百零九年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","拉吳活到三十二歲，就生了西鹿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","拉吳生西鹿以後，又活了二百零七年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","西鹿活到三十歲，就生了拿鶴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","西鹿生拿鶴以後，又活了二百年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","拿鶴活到二十九歲，就生了他拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","拿鶴生他拉以後，又活了一百一十九年，並且生了其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","他拉活到七十歲，就生了亞伯蘭、拿鶴和哈蘭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","以下是他拉的後代：他拉生亞伯蘭、拿鶴和哈蘭；哈蘭生羅得。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","哈蘭在他父親他拉之前，死在他出生之地，就是迦勒底的吾珥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","亞伯蘭和拿鶴都娶了妻子；亞伯蘭的妻子名叫撒萊；拿鶴的妻子名叫密迦，是哈蘭的女兒；哈蘭是密迦和亦迦的父親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","撒萊不能生育，沒有孩子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","他拉帶著他的兒子亞伯蘭和他的孫子，就是哈蘭的兒子羅得，以及他的媳婦亞伯蘭的妻子撒萊，一同出了迦勒底的吾珥，要到迦南地去；他們到了哈蘭，就住在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","他拉死在哈蘭；他的壽數共二百零五歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","耶和華對亞伯蘭說：“你要離開本地、本族、父家，到我指示你的地方去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","我必使你成為大國，賜福給你，使你的名為大，你也必使別人得福， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","給你祝福的，我必賜福給他；咒詛你的，我必咒詛他；地上的萬族，都必因你得福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","亞伯蘭就照著耶和華吩咐他的去了；羅得也和他同去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","亞伯蘭離開哈蘭的時候，已經七十五歲。亞伯蘭帶著他的妻子撒萊和姪兒羅得以及他們在哈蘭所積蓄的一切財物，和所獲得的人口，一同出來，要到迦南地去。後來他們到了迦南地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","亞伯蘭穿過那地，到了示劍的地方，摩利的橡樹那裡。當時，迦南人住在那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","耶和華向亞伯蘭顯現，說：“我要把這地賜給你的後裔。”亞伯蘭就在那裡為向他顯現的耶和華築了一座祭壇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","後來他從那裡遷到伯特利東邊的山地，搭起帳棚。西邊是伯特利，東邊是艾城；他在那裡也為耶和華築了一座祭壇，呼求耶和華的名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","亞伯蘭又起程，漸漸移到南地去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","當時，那地發生饑荒，亞伯蘭就下到埃及去，要在那裡寄居；因為那地的饑荒十分嚴重。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","快要到達埃及的時候，亞伯蘭對他的妻子撒萊說：“看哪，我知道你是個美貌的女人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","埃及人看見你的時候，必會說：‘這是他的妻子’，他們就會殺我，卻叫你活著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","請你說你是我的妹妹，使我因你的緣故可以平安無事，我的性命也可以因你的緣故得以保全。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","果然，亞伯蘭進入埃及的時候，埃及人就注視那女人，因為她十分美麗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","法老的一些大臣看見了撒萊，就在法老面前稱讚她；於是那女人被帶進法老的宮裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","亞伯蘭因這女人的緣故就被優待，得了許多牛羊、公驢、母驢、僕婢和駱駝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","耶和華因為亞伯蘭的妻子撒萊的緣故，就用嚴重的災病打擊法老和他的全家。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","於是，法老把亞伯蘭召了來，對他說：“你向我作的是甚麼？你為甚麼不告訴我她是你的妻子呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","你為甚麼說她是你的妹妹，以致我娶了她作妻子呢？現在，你的妻子在這裡，帶她走吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","法老吩咐臣僕，他們就把亞伯蘭和他的妻子，以及他所有的一切都送走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","亞伯蘭帶著妻子和所有的一切，以及羅得，一同從埃及上到南地去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","亞伯蘭有很多牲畜和金銀。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","他從南地一站一站往前走，到伯特利去；到伯特利和艾城中間，就是他從前支搭帳棚的地方， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","也是他築頭一座祭壇的地方，亞伯蘭就在那裡求告耶和華的名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","和亞伯蘭同行的羅得，也有羊群、牛群和帳棚。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","那地容不下他們住在一起；因為他們的財物很多，所以他們再也不能住在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","牧養亞伯蘭牲畜的和牧養羅得牲畜的，起了紛爭；當時迦南人和比利洗人還住在那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","亞伯蘭就對羅得說：“你我之間，切不可紛爭；你的牧人和我的牧人之間，也不可紛爭，因為我們是至親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","全地不都是在你面前嗎？請你離開我吧！你若向左，我就向右；你若向右，我就向左。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","羅得舉目，看見約旦河整個平原，直到瑣珥，都有水灌溉；在耶和華毀滅所多瑪和蛾摩拉之前，這地好像耶和華的園子，也像埃及地一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","羅得選擇了約旦河整個平原，於是向東移動，他們就彼此分開了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","亞伯蘭住在迦南地；羅得住在平原的城市中，漸漸挪移帳棚，直到所多瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","在耶和華看來，所多瑪人是罪大惡極的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","羅得離開亞伯蘭以後，耶和華對亞伯蘭說：“你要舉目，從你所在的地方向東南西北觀看。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","你看見的地方，我都要賜給你和你的後裔，直到永遠。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","我要使你的後裔好像地上灰塵那麼多；若能數算地上的灰塵，才能數算你的後裔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","你起來，縱橫走遍這地，因為我必把這地賜給你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","於是，亞伯蘭漸漸挪移帳棚，來到希伯崙幔利的橡樹附近，在那裡居住，也在那裡為耶和華築了一座祭壇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","當暗拉非作示拿王，亞略作以拉撒王，基大老瑪作以攔王，提達作戈印王的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","他們興兵攻打所多瑪王比拉、蛾摩拉王比沙、押瑪王示納、洗扁王善以別和比拉王。比拉就是瑣珥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","這五王在西訂谷會合。西訂谷就是鹽海。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","他們服事了基大老瑪已經有十二年，到第十三年就背叛了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","第十四年基大老瑪和同盟的王都來了，在亞特律．加寧擊敗了利乏音人，在哈麥擊敗了蘇西人，在沙微．基列亭擊敗了以米人， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","在何利人的西珥山擊敗了何利人，一直追擊到靠近曠野的伊勒．巴蘭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","然後轉到安．密巴，就是加低斯，攻佔了亞瑪力人全部的領土，也擊敗了住在哈洗遜．他瑪的亞摩利人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","於是所多瑪王、蛾摩拉王、押瑪王、洗扁王和比拉王（比拉就是瑣珥）都出來，在西訂谷列陣，與他們交戰； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","就是與以攔王基大老瑪、戈印王提達、示拿王暗拉非、以拉撒王亞略交戰，就是四王與五王交戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","西訂谷有許多漆坑。所多瑪王和蛾摩拉王逃跑的時候，都掉在坑裡，其餘的人都向著山上逃跑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","四王就把所多瑪和蛾摩拉所有的財物，以及一切糧食都拿走， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","連亞伯蘭的姪兒羅得和羅得的財物也帶走了。當時，羅得住在所多瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","有一個逃出來的人，跑來告訴希伯來人亞伯蘭。那時，亞伯蘭住在亞摩利人幔利的橡樹那裡。幔利和以實各，以及亞乃，都是兄弟；他們都是亞伯蘭的盟友。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","亞伯蘭一聽見姪兒被人擄去，就抽調他家裡生養的精練壯丁三百一十八人，一直追到但。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","亞伯蘭和他的僕人漏夜分隊攻擊他們，結果擊敗了他們，又追趕他們直到大馬士革北面的何把， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","將一切財物都奪回來，也把他的姪兒羅得和羅得的財物，以及婦女和族人，都奪了回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","亞伯蘭擊敗了基大老瑪和與他聯盟的王回來的時候，所多瑪王出來，在沙微谷迎接他。沙微谷就是帝王谷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","撒冷王麥基洗德也帶著餅和酒出來；他是至高　神的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","他給亞伯蘭祝福，說：“願創造天地的主、至高的　神，賜福給亞伯蘭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","把敵人交在你手裡的至高的　神，是應當稱頌的！”亞伯蘭就把所得的一切，拿出十分之一來，給了麥基洗德。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","所多瑪王對亞伯蘭說：“請你把人交給我，至於財物，你拿去吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","亞伯蘭對所多瑪王說：“我已經向創造天地的主、至高的　神耶和華舉手起誓； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","凡是你的東西，就是一根線，一條鞋帶，我也不拿，免得你說：‘我使亞伯蘭發了財。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","我甚麼都不要，除了僕人吃掉的以外，但與我同行的亞乃、以實各、幔利所應得的分，讓他們拿去吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","這些事以後，耶和華的話在異象中臨到亞伯蘭說：“亞伯蘭，你不要懼怕，我是你的盾牌；你的賞賜是很大的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","亞伯蘭說：“主耶和華啊，我一向都沒有孩子，你還能賜給我甚麼呢？這樣，承受我家業的，就是大馬士革人以利以謝了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","亞伯蘭又說：“你既然沒有給我後裔，那生在我家中的人，就是我的繼承人了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","耶和華的話又臨到亞伯蘭說：“這人必不會作你的繼承人；你親生的才會是你的繼承人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","於是領他到外面去，說：“你向天觀看，數點眾星，看你能不能把它們數得清楚。”又對他說：“你的後裔將要這樣眾多。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","亞伯蘭信耶和華，耶和華就以此算為他的義了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","耶和華又對亞伯蘭說：“我是耶和華，曾經把你從迦勒底的吾珥領出來，為要把這地賜給你作產業。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","亞伯蘭說：“主耶和華啊，我憑甚麼能知道我必得這地為業呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","耶和華對他說：“你給我拿一頭三歲的母牛，一隻三歲的母山羊，一隻三歲的公綿羊，一隻斑鳩和一隻雛鴿。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","亞伯蘭就把這一切拿了來，每樣都從當中劈開，一半一半相對擺列；只是鳥卻沒有劈開。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","有鷙鳥下來，落在這些屍骸上，亞伯蘭就把牠們嚇走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","日落的時候，亞伯蘭沉沉地睡著了，忽然有可怕的大黑暗落在他身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","耶和華對亞伯蘭說：“你要確實地知道，你的後裔必在外地寄居，也必服事那地的人，那地的人苦待他們四百年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","他們所要服事的那國，我要親自懲罰。後來他們必帶著很多財物，從那裡出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","你必得享長壽，被人埋葬，平平安安地回到你列祖那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","到了第四代，他們必回到這裡，因為亞摩利人的罪孽還沒有滿盈。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","日落天黑的時候，忽然有冒煙的爐和燒著的火把，從那些肉塊中經過。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","就在那時候，耶和華與亞伯蘭立約說：“我已經把這地賜給你的後裔了，就是從埃及河直到幼發拉底河之地； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","就是基尼人、基尼洗人、甲摩尼人、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","赫人、比利洗人、利乏音人、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","亞摩利人、迦南人、革迦撒人、耶布斯人之地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","亞伯蘭的妻子撒萊，沒有為他生孩子。撒萊卻有一個婢女，是埃及人，名叫夏甲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","撒萊對亞伯蘭說：“請看，耶和華使我不能生育，求你去親近我的婢女，或者我可以從她得孩子。”亞伯蘭就聽從了撒萊的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","亞伯蘭在迦南地住滿了十年，他的妻子撒萊，把自己的婢女埃及人夏甲，給了她的丈夫亞伯蘭為妾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","亞伯蘭與夏甲親近，夏甲就懷了孕。夏甲見自己有了孕，就輕看她的主母。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","撒萊對亞伯蘭說：“我因你受屈；我把我的婢女送到你的懷中，她見自己有了孕，就輕看我。願耶和華在你我之間主持公道。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","亞伯蘭對撒萊說：“你的婢女在你手中，你看怎樣好，就怎樣待她吧。”於是撒萊虐待夏甲，她就從撒萊面前逃走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","耶和華的使者在曠野的水泉旁邊，就是在到書珥路上的水旁邊，遇到了她， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","就問她：“撒萊的婢女夏甲啊，你從哪裡來？要到哪裡去？”夏甲回答：“我從我的主母撒萊面前逃出來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","耶和華的使者對她說：“回到你主母那裡去，服在她的手下！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","耶和華的使者又對她說：“我必使你的後裔人丁興旺，多到不可勝數。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","耶和華的使者再對她說：“看哪，你已經懷了孕，你要生一個兒子；你要給他起名叫以實瑪利，因為耶和華聽見了你的苦情。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","他將來為人，必像野驢。他的手要攻打人，人的手也要攻打他。他必住在眾兄弟的東面。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","於是，夏甲給那對她說話的耶和華，起名叫“你是看顧人的　神”，因為她說：“在這裡我不是也看見了那位看顧人的嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","因此，這井名叫庇耳．拉海．萊，是在加低斯和巴列之間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","夏甲給亞伯蘭生了一個兒子，亞伯蘭就給夏甲所生的兒子，起名叫以實瑪利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","亞伯蘭八十六歲的時候，夏甲給他生了以實瑪利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","亞伯蘭九十九歲的時候，耶和華向他顯現，對他說：“我是全能的　神，你要在我面前行事為人；你要作完全人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","我要與你立約，要使你的後裔人丁興旺。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","於是亞伯蘭俯伏在地，　神又告訴他，說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","看哪，這就是我和你所立的約：你要作多國的父。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","你的名不要再叫亞伯蘭，要叫亞伯拉罕，因為我已經立了你作萬國的父。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","我要使你極其昌盛，國度因你而立，君王必從你而出。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","我要與你，和你世世代代的後裔，堅立我的約，成為永遠的約，使我作你和你的後裔的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","我要把你現在寄居的地，就是迦南全地，賜給你和你的後裔，作永遠的產業，我也要作他們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","神又對亞伯拉罕說：“你和你世世代代的後裔都要謹守我的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","我與你和你的後裔所立的這約，是你們應當謹守的，就是你們所有的男子，都要受割禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","你們都要割去身上的包皮，這就是我與你們立約的記號了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","你們中間世世代代所有的男子，無論是在家裡生的，或是用銀子從不是屬你後裔的外族人買來的，生下來第八日都要受割禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","在你家裡生的，和你用銀子買來的，都一定要受割禮。這樣，我的約就刻在你們身上，作永遠的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","但不受割禮的男子，就是沒有割去身上的包皮的，那人必從民中剪除，因為他違背了我的約。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","神又對亞伯拉罕說：“至於你的妻子撒萊，不要再叫她的名撒萊，要叫撒拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","我必賜福給她，也必使她為你生一個兒子；我要賜福給她，她也要作多國的母，萬族的君王必從她而出。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","亞伯拉罕就俯伏在地，笑了起來，心裡說：“一百歲的人，還能生孩子嗎？撒拉已經九十歲了，還能生育嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","亞伯拉罕對　神說：“願以實瑪利能在你面前活著！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","神說：“你的妻子撒拉，真的要為你生一個兒子，你要給他起名叫以撒，我要與他堅立我的約，作他後裔的永約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","至於以實瑪利，我也應允你。看哪，我已經賜福給他；我必使他昌盛，子孫極其眾多；他必生十二個族長；我也必使他成為大國。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","但我的約是要和以撒堅立的。這以撒，就是明年這時候，撒拉要為你生的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","神和亞伯拉罕說完了話，就離開他上升去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","就在那一天，亞伯拉罕照著　神吩咐他的，給他兒子以實瑪利，和他家裡所有的男子，無論是在家裡生的，或是用銀子買來的，都割去了他們身上的包皮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","亞伯拉罕九十九歲的時候，割去了他身上的包皮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","他的兒子以實瑪利十三歲的時候，割去了他身上的包皮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","就在那一天，亞伯拉罕和他的兒子以實瑪利，都受了割禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","亞伯拉罕家裡所有的男人，無論是在家裡生的，或是用銀子從外族人買來的，都與他一同受了割禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","耶和華在幔利橡樹那裡，向亞伯拉罕顯現。那時，是一天中最熱的時候，亞伯拉罕正坐在帳棚門口； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","他舉目觀看，忽然看見三個人在他對面站著；亞伯拉罕看見了，就從帳棚門口跑去迎接他們，俯伏在地， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","說：“我主啊，我若在你眼前蒙恩，求你不要離開你的僕人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","讓我叫人拿點水來，你們可以洗洗腳，然後在樹下歇一歇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","讓我拿點餅來給你們吃，使你們可以恢復精力，然後再走，因為你們既然到了僕人這裡來，就應該這樣。”他們說：“就照著你所說的去作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","亞伯拉罕趕快進帳棚，到撒拉那裡，說：“你快拿三斗細麵調和，作些餅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","亞伯拉罕又跑到牛群裡，牽了一頭又嫩又好的牛犢，交給僕人；僕人就趕快去預備。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","亞伯拉罕又拿了乳酪、奶和預備好的牛犢肉來，擺在他們面前。他們吃的時候，亞伯拉罕在樹下侍候他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","他們問亞伯拉罕：“你的妻子撒拉在哪裡？”他回答：“在帳棚裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","其中一位說：“到明年這個時候，我必回到你這裡來。那時，你的妻子撒拉必生一個兒子。”撒拉在那人後面的帳棚門口，也聽見了這話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","當時，亞伯拉罕和撒拉都老了，撒拉的月經也停止了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","撒拉心裡暗笑，說：“現在我已經衰老了，我的丈夫也老了，我還有房事的樂趣嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","耶和華對亞伯拉罕說：“撒拉為甚麼暗笑說：‘我已經老了，真的還能生育嗎？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","耶和華豈有難成的事嗎？到明年這個時候，我要回到你這裡來，那時，撒拉必生一個兒子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","撒拉害怕起來，就否認，說：“我沒有笑。”但那位說：“不，你實在笑了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","三人就從那裡起身，向著所多瑪觀望。亞伯拉罕與他們同行，要送他們一程。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","耶和華說：“我要作的事，豈可瞞著亞伯拉罕呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","亞伯拉罕必要成為強大興盛的國，地上的萬國，都必因他得福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","我揀選了他，是要他吩咐子孫，和他的家屬，遵守我耶和華的道，秉公行義，好叫我耶和華應許亞伯拉罕的話都可實現。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","耶和華說：“控告所多瑪和蛾摩拉的聲音甚大，他們的罪惡極重。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","我現在要下去，看看他們所行的，是不是全像那聲聞於我的控告；如果不是，我也會知道的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","其中二人從那裡動身，向所多瑪走去，亞伯拉罕卻仍然站在耶和華面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","亞伯拉罕上前說：“你真的要把義人和惡人一同除滅嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","假如城中有五十個義人，你還真的要除滅那地方，不為城裡的五十個義人而赦免那地方嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","你絕不會作這樣的事：把義人與惡人一同殺死，把義人和惡人一樣看待，你絕不會這樣！審判全地的主，豈可不行公義嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","耶和華說：“我若在所多瑪城中找到五十個義人，我就因他們的緣故，赦免那地方所有的人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","亞伯拉罕回答，說：“我雖然是灰塵，還大膽地對我主說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","假如這五十個義人中缺少了五個，你會因為缺少了五個就毀滅全城嗎？”他說：“我若在那裡找到四十五個，我也不會毀滅那城。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","亞伯拉罕再問他說：“假如在那裡找到四十個呢？”他回答：“我因這四十個的緣故，也不這樣作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","亞伯拉罕說：“請我主不要動怒，容我再問：‘假如在那裡找到三十個呢？’”他回答：“我若在那裡找到三十個，也不這樣作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","亞伯拉罕說：“我再大膽地對我主說，假如在那裡找到二十個呢？”他回答：“我因這二十個的緣故，也不毀滅那城。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","亞伯拉罕說：“請我主不要動怒，容我問這最後的一次，假如在那裡找到十個呢？”他回答：“我因這十個的緣故，也不毀滅那城。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","耶和華與亞伯拉罕說完了話，就走了；亞伯拉罕也回到自己的地方去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","黃昏的時候，那兩位天使到了所多瑪，當時羅得正坐在所多瑪的城門口。羅得一看見他們，就起來迎接他們，俯伏在地， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","說：“我主啊，請你們到僕人的家裡住一夜，洗洗你們的腳，清早起來再趕路。”他們回答：“不，我們要在街上過夜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","但由於羅得再三的請求，他們才肯跟他回去，進了他的家。羅得為他們預備了筵席，烤了無酵餅，他們就吃了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","他們還沒有躺下睡覺，那城裡的人，就是所多瑪的男人，無論是年輕的或是年老的，都從各處來圍住羅得的房子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","他們呼喚羅得，對他說：“今晚到你這裡來的人在哪裡？把他們帶出來，我們要與他們同房。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","羅得出來，隨手把門關上，到門口眾人那裡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","說：“我的弟兄們，請不要作惡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","看哪，我有兩個女兒，是還沒有和男人同房的，讓我把她們帶出來，你們高興怎樣待她們，就怎樣行吧！只是這兩個人，因為他們是到舍下來的，你們不可向他們作甚麼。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","眾人卻說：“滾開！”又說：“一個來這裡寄居的人，竟作起審判官來；現在我們要害你，比害他們還要厲害。”眾人就向羅得極力擁擠，他們衝前要打破房門。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","那兩個人卻伸出手來，把羅得拉進屋裡去，並把門關上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","然後擊打那些門外的人，使他們無論老少，都眼目昏眩，以致找不到門口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","那二人對羅得說：“你這裡還有甚麼人沒有？無論是女婿、兒女，或是城中所有屬你的人，都要把他們從這地方帶走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","我們快要毀滅這地方了，因為控告他們的聲音在耶和華面前實在很大，所以耶和華派我們來毀滅這地方。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","於是羅得出去，告訴娶了他女兒的女婿說：“你們起來離開這地方；因為耶和華就要毀滅這城。”但是他的女婿以為他在開玩笑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","天快亮的時候，兩位天使催促羅得說：“起來，帶你的妻子，和你這裡的兩個女兒出去，免得你因這城的罪孽被除滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","羅得還在猶豫不決的時候，二人因為耶和華寬容羅得，就拉著羅得的手，和他妻子的手，以及他兩個女兒的手，把他們帶出來，安置在城外。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","二人把他們帶出來以後，其中一位說：“逃命吧，不要回頭看，也不可留在這片平原上，要逃到山上去，免得你被除滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","羅得對他們說：“我主啊！請不要這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","看哪，你僕人既然在你眼前蒙恩，你又向我大施慈愛，救活我的性命；可是我還逃不到山上，恐怕這災禍就追上了我，我就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","看哪，這座城很近，可以逃到那裡，那只是一座小城，請讓我逃到那裡去。那不是一座小城嗎？這樣我就可以活命了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","有一位天使對他說：“這事我也答應你，你所說的這城，我必不傾覆。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","你趕快逃到那裡去，因為你還沒有到達那裡，我就不能作甚麼。”因此那城名叫瑣珥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","羅得到達瑣珥的時候，太陽已經從地面升上來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","當時，耶和華就使硫磺與火，從天上耶和華那裡降與所多瑪和蛾摩拉； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","把那些城和全平原，以及城中所有的居民，連地上生長的，都毀滅了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","羅得的妻子向後一望，就變成了鹽柱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","亞伯拉罕清早起來，到他從前站在耶和華面前的地方， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","向所多瑪和蛾摩拉，以及平原全地觀望。不料，看見那地有煙上升，好像燒窯的煙一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","神毀滅那平原上的眾城，傾覆羅得所住過的眾城的時候，　神記念亞伯拉罕，把羅得從傾覆中救出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","羅得因為怕住在瑣珥，就與他的兩個女兒，一同離開瑣珥上了山，住在那裡；他和兩個女兒住在一個洞裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","大女兒對小女兒說：“我們的爸爸已經老了，這地又沒有男人可以按著世上的常規進來與我們親近。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","來吧，我們可以叫父親喝酒，然後與他同睡，這樣我們可以藉著父親保全後裔。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","當夜，她們叫父親喝酒，大女兒就進去與父親同睡，她甚麼時候躺下，甚麼時候起來，她父親都不知道。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","第二天，大女兒對小女兒說：“昨夜我與父親同睡了，今夜我們再叫父親喝酒，你可以進去與他同睡，這樣我們可以藉著父親保全後裔。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","當夜，她們又叫父親喝酒，小女兒就起來，與父親同睡；她甚麼時候躺下，甚麼時候起來，她父親都不知道。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","這樣，羅得的兩個女兒，都從她們的父親懷了孕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","大女兒生了一個兒子，給他起名叫摩押，就是現在摩押人的始祖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","小女兒也生了一個兒子，給他起名叫便．亞米，就是現在亞捫人的始祖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","亞伯拉罕從那裡遷到南地，就住在加低斯和書珥中間。亞伯拉罕寄居在基拉耳的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","曾經提到他的妻子撒拉說：“她是我的妹妹。”於是基拉耳王亞比米勒派人來把撒拉取了去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","當夜，　神在夢中來到亞比米勒那裡，對他說：“你該死，因為你接來的那女人，是個有夫之婦。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","亞比米勒還沒有親近撒拉，所以他說：“我主啊，連正義的人你也要殺害嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","那人豈不是對我說：‘她是我的妹妹’嗎？就是那女人自己也說：‘他是我的哥哥’。我作這事，是手潔心清的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","神在夢中對他說：“我也知道你作這事，是問心無愧的，所以我也阻止你，免得你得罪我。因此我不容許你接觸她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","現在你要把那人的妻子還給他，因為他是先知，他要為你禱告，你才可以存活。你若不還給他，你當知道，你和所有屬你的，都死定了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","亞比米勒清早起來，召了他的眾臣僕來，把這一切都說給他們聽，以致他們都很懼怕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","亞比米勒把亞伯拉罕召了來，對他說：“你為甚麼向我們這樣行呢？我在甚麼事上得罪了你，以致你給我和我的國帶來這個大罪呢？你對我作了不應該作的事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","亞比米勒又對亞伯拉罕說：“你為了甚麼緣故要這樣作呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","亞伯拉罕回答：“因為我以為這地方必定沒有敬畏　神的人，他們會因我妻子的緣故殺我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","何況她也實在是我的妹妹；她原是我同父異母的妹妹，後來作了我的妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","神叫我離開我父家，在外飄流的時候，我對她說：‘我們無論到甚麼地方去，你都要對人說：“他是我的哥哥。”這就是你待我的恩情了。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","亞比米勒取了些牛羊、僕婢，送給亞伯拉罕，又把亞伯拉罕的妻子撒拉還給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","亞比米勒說：“看哪，我的國土都在你面前，你喜歡哪裡，就住在哪裡吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","他又對撒拉說：“看哪，我給了你哥哥一千銀子，作你在全家人面前的遮羞錢。這樣，你在眾人面前就算清白了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","亞伯拉罕禱告　神，　神就醫好了亞比米勒和他的妻子，以及他的眾婢女，使她們能生育。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","因為耶和華為了亞伯拉罕妻子撒拉的緣故，曾經使亞比米勒家中所有的婦女，都不能生育。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","耶和華照著以前所說的，眷顧撒拉；耶和華按著他的應許，給撒拉作成。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","亞伯拉罕年老的時候，撒拉懷了孕，到了　神應許的日期，就給亞伯拉罕生了一個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","亞伯拉罕給撒拉為他所生的兒子，起名叫以撒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","亞伯拉罕的兒子以撒生下來第八天，亞伯拉罕就照著　神吩咐他的，給以撒行了割禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","他兒子以撒出生的時候，亞伯拉罕正一百歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","撒拉說：“　神使我歡笑，凡聽見的，也必為我歡笑。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","又說：“誰能告訴亞伯拉罕，撒拉要乳養兒女呢？在他年老的時候，我竟給他生了一個兒子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","孩子漸漸長大，就斷了奶。以撒斷奶的那天，亞伯拉罕擺設盛大的筵席。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","撒拉看見那埃及人夏甲給亞伯拉罕所生的兒子在嬉戲，就對亞伯拉罕說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","“把這婢女和她的兒子趕出去，因為這婢女的兒子不能和我的兒子以撒一同承受產業。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","亞伯拉罕因他的兒子而非常煩惱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","神對亞伯拉罕說：“不要因這童子和你的婢女而煩惱。撒拉對你說的話，你都要聽從；因為以撒生的，才可以稱為你的後裔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","至於這婢女的兒子，我也要使他成為一國，因為他也是你的後裔。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","亞伯拉罕清早起來，拿餅和一皮袋水，給了夏甲，放在她的肩膀上，又把孩子交給她，就打發她離開。夏甲走了，在別是巴的曠野飄蕩。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","皮袋裡的水用盡了，夏甲就把孩子撇在一棵小樹底下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","然後自己走開，在離開約有一箭之遠的地方，相對而坐，說：“我不忍眼看孩子死去。”就相對坐著，放聲大哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","神聽見了童子的聲音，他的使者就從天上呼叫夏甲，對她說：“夏甲啊，你為甚麼這樣呢？不要害怕，因為孩子在那裡所發的聲音　神已經聽見了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","起來，扶起孩子，盡力保護他；因為我要使他成為大國。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","神開了夏甲的眼睛，她就看見一口水井。她去把皮袋盛滿了水，就給孩子喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","神與孩子同在，他漸漸長大，住在曠野，成了個弓箭手。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","他住在巴蘭的曠野，他的母親從埃及地給他娶了一個妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","那時，亞比米勒和他的軍長非各對亞伯拉罕說：“在你所作的一切事上，　神都與你同在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","現在你要在這裡指著　神對我起誓，你不會以詭詐待我和我的子子孫孫。我怎樣恩待了你，你也要怎樣恩待我和你寄居的地方。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","亞伯拉罕回答：“我願意起誓。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","亞伯拉罕因亞比米勒的僕人強佔了一口水井，就指責亞比米勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","亞比米勒說：“誰作了這事，我不知道，你都沒有告訴我；我現在才聽見。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","於是亞伯拉罕牽了牛羊來，送給亞比米勒，二人就彼此立約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","亞伯拉罕把羊群中的七隻母羊羔，放在另外一處。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","亞比米勒問亞伯拉罕：“你把這七隻母羊羔放在另外一處，是甚麼意思呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","亞伯拉罕回答：“意思就是：你從我手裡接受這七隻母羊羔，好作我挖了這口井的證據。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","因此那地方名叫別是巴，因為他們二人在那裡起了誓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","他們在別是巴立約以後，亞比米勒和他的軍長非各，就起程回非利士地去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","亞伯拉罕在別是巴栽了一棵垂絲柳樹，就在那裡求告耶和華永活的　神的名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","亞伯拉罕在非利士人的地方寄居了許多日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","這些事以後，　神試驗亞伯拉罕，對他說：“亞伯拉罕啊！”他回答：“我在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","神說：“帶著你的兒子，就是你所愛的獨生子以撒，到摩利亞地去，在我所要指示你的一座山上，把他獻為燔祭。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","亞伯拉罕清早起來，預備好了驢，帶著兩個童僕和自己的兒子以撒，也劈好了獻燔祭用的柴，就起程到　神指示他的地方去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","第三日，亞伯拉罕舉目觀望，遠遠地看見了那地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","亞伯拉罕對他的童僕說：“你們和驢留在這裡，我與孩子要到那邊去敬拜，然後回到你們這裡來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","亞伯拉罕把獻燔祭的柴，放在他兒子以撒的身上，自己手裡拿著火與刀。他們二人一起向前走的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","以撒問他父親亞伯拉罕說：“爸爸！”亞伯拉罕回答：“我兒！有甚麼事？”以撒說：“你看，火與柴都有了，可是獻燔祭用的羊羔在哪裡呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","亞伯拉罕回答：“我兒，　神自己必親自預備獻燔祭用的羊羔。”於是二人繼續一起前行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","他們到了　神指示的地方，亞伯拉罕就在那裡築了一座祭壇，擺好了柴，捆綁了自己的兒子以撒，就把他放在祭壇的柴上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","亞伯拉罕伸手拿刀，要宰殺自己的兒子的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","耶和華的使者從天上呼叫亞伯拉罕，說：“亞伯拉罕，亞伯拉罕！”亞伯拉罕回答：“我在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","天使說：“不可在這孩子身上下手，一點也不可害他；現在我知道你是敬畏　神的了，因為你沒有留下你的獨生子不給我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","亞伯拉罕舉目觀望，看見一隻公綿羊，兩角扣在稠密的小樹叢中；亞伯拉罕就去取了那隻公綿羊，把牠獻為燔祭，代替自己的兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","亞伯拉罕給那地方起名叫“耶和華以勒”。直到今日，人還說：“在耶和華的山上必有預備。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","耶和華的使者第二次從天上呼叫亞伯拉罕， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","說：“耶和華說：‘我指著自己起誓，你既然作了這事，沒有留下你的獨生子， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","我必定賜福給你，必使你的後裔繁多，像天上的星，海邊的沙；你的後裔必佔領仇敵的城門。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","地上萬國都要因你的後裔得福，因為你聽從了我的話。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","亞伯拉罕回到他的童僕那裡；他們就起程，一起到別是巴去了；亞伯拉罕就住在別是巴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","這些事以後，有人告訴亞伯拉罕說：“密迦也給你的兄弟拿鶴生了幾個兒子； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","長子是烏斯，他的弟弟是布斯，和亞蘭的父親基母利； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","還有基薛、哈瑣、必達、益拉和彼土利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","（彼土利生了利百加。）”這八個人，都是密迦給亞伯拉罕的兄弟拿鶴生的兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","拿鶴的妾名叫流瑪。她也生了提八、迦含、他轄和瑪迦。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","撒拉享壽一百二十七歲，這是撒拉一生的歲數。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","撒拉死在迦南地的基列．亞巴，就是希伯崙；亞伯拉罕為撒拉哀慟哭號。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","亞伯拉罕從死者面前起來，對赫人說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“我是在你們中間寄居的外族人，求你們在你們中間給我一塊墳地作產業，使我可以埋葬我死了的人，使她不露在我面前。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","赫人回答亞伯拉罕，說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“我主請聽，你在我們中間是一位尊貴的王子，你可以在我們最好的墳地裡埋葬你死了的人，我們必沒有人阻止你在他的墳地埋葬你死了的人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","於是，亞伯拉罕起來，向當地的赫人下拜， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","對他們說：“你們若有意使我埋葬我死了的人，使她不露在我的眼前，就請聽我的話，為我請求瑣轄的兒子以弗崙， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","叫他把他所擁有的，田頭上那麥比拉洞賣給我。他可以按著十足的價銀賣給我，使我在你們中間有產業作墳地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","那時，以弗崙正坐在赫人中間。於是，赫人以弗崙就回答亞伯拉罕，所有來到城門口的赫人都聽見他說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“我主，不要這樣，請聽我說，這塊田我送給你，連其中的洞我也送給你。我在我的族人眼前送給你，讓你可以埋葬你死了的人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","亞伯拉罕就在當地的人面前下拜， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","然後在當地的人面前對以弗崙說：“請聽我說，如果你願意，我必定把地的價銀給你，請你收下吧，讓我可以在那裡埋葬我死了的人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","以弗崙回答亞伯拉罕，對他說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“我主，請聽我說，一塊值四百塊（四千五百克）銀子的田地，在你我之間，算得甚麼呢？你埋葬你死了的人吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","亞伯拉罕同意以弗崙說的價銀，就照著他在赫人面前所說的，拿商人通用的銀子，稱了四百塊（四千五百克）銀子給以弗崙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","於是，以弗崙在麥比拉，在幔利前面的那塊地，包括那塊田和其中的洞，田中和四周所有的樹木， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","都在赫人眼前，就是在所有來到城門口的赫人眼前，歸給亞伯拉罕作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","這事以後，亞伯拉罕把自己的妻子撒拉埋在迦南地，幔利前面麥比拉田間的洞裡。幔利就是希伯崙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","這樣，那塊田和田中的洞，就從赫人歸給了亞伯拉罕為產業作墳地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","亞伯拉罕老邁了，年事已高，耶和華在一切事上都賜福給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","亞伯拉罕對他家中，管理所有產業的老僕人說：“請把你的手放在我的大腿底下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","我要你指著耶和華天地的　神起誓，不可從我現在居住的迦南人中，為我的兒子娶他們的女子為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","你卻要到我的故鄉、我的親族那裡去，為我的兒子以撒娶妻。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","僕人問亞伯拉罕：“如果那女子不願跟我到這地方來，我必須把你的兒子帶回你原出之地去嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","亞伯拉罕對他說：“你要謹慎，切不可帶我的兒子回到那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","耶和華天上的　神，就是領我離開我的父家和我親族之地，曾經對我說話，又向我起誓的那位說：‘我必把這地賜給你的後裔。’他必在你前面差派他的使者，你就可以從那裡為我的兒子娶妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","如果那女子不願跟你來，我叫你所起的這誓就與你無關了。只是不可帶我的兒子回到那裡去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","於是，僕人把手放在他主人亞伯拉罕的大腿下，為這事向亞伯拉罕起誓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","那僕人從他主人的駱駝裡取了十匹駱駝，帶著主人各樣的美物，起程往兩河之間的亞蘭去，到了拿鶴的城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","黃昏時分，女人出來打水的時候，那僕人就叫駱駝跪在城外的水井旁邊， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","然後禱告說：“耶和華我主人亞伯拉罕的　神啊，求你今日使我遇見好機會，施慈愛給我的主人亞伯拉罕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","我現在站在水泉旁邊，城內居民的女兒正出來打水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","我對哪一個少女說：‘請你放下水瓶來，讓我喝點水。’如果她回答：‘請喝，我也給你的駱駝喝。’願那少女就作你選定給你僕人以撒的妻子。這樣，我就知道你施慈愛給我的主人了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","話還沒有說完，不料，利百加肩頭上扛著水瓶出來了。利百加是彼土利所生的。彼土利是亞伯拉罕兄弟拿鶴的妻子密迦的兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","那少女容貌非常美麗，還是個處女，沒有男人親近過她。她下到水泉那裡，打滿了水瓶，又上來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","僕人就跑去迎著她，說：“請你把瓶裡的水給我喝一點。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","那少女回答：“我主請喝。”就急忙把水瓶拿下來，托在手上給他喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","他喝足了，少女就說：“我也要為你的駱駝打水，直到牠們都喝足了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","於是急忙把水瓶裡的水倒在槽裡，又跑到井旁去打水，給他所有的駱駝打上水來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","那人一句話也不說，只注視著她，要知道耶和華使他的道路亨通不亨通。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","駱駝喝足了，那人就拿出一個重近六克的金鼻環，戴在她的鼻子上，又拿出兩個重一百一十四克的金手鐲，套在她的手上， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","然後問她：“請你告訴我，你是誰的女兒？你父親的家裡有地方給我們住宿沒有？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","她回答：“我是密迦給拿鶴所生的兒子彼土利的女兒。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","她又說：“我們有很多糧草和飼料，也有住宿的地方。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","那人就跪下敬拜耶和華， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","說：“耶和華我主人亞伯拉罕的　神是應當稱頌的，因為他不斷以慈愛和信實待我的主人；耶和華也一路引導我，到了我主人的兄弟家裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","那少女就跑回去，把這些事都告訴了她母親家裡的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","利百加有一個哥哥，名叫拉班。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","他看見了妹妹的鼻環和手上的手鐲，又聽見了妹妹利百加說：“那人對我這樣這樣說”，就跑去見外面水泉旁邊的那人。他來到那人跟前的時候，見他仍然站在駱駝旁邊的水泉那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","拉班說：“你這蒙耶和華賜福的，請進來吧，為甚麼站在外面呢？我已經收拾好了房間，也為駱駝預備了地方。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","那人就進了拉班的家。拉班卸了駱駝，拿糧草和飼料給駱駝吃，又拿水給那人和與他同來的人洗腳。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","然後在他面前擺上食物，但那人說：“除非等我說完了我的事，我不會吃。”拉班說：“請說。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","那人說：“我是亞伯拉罕的僕人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","耶和華厚厚地賜福我主人，他就昌大起來；耶和華又賜給他羊群、牛群、金銀、僕婢、駱駝和驢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","我主人的妻子撒拉年老的時候，給我主人生了一個兒子。我主人也把他一切所有的都給了這個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","我主人要我起誓，說：‘你不可從我現在居住的迦南地中，為我的兒子娶迦南的女子為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","你要到我的父家，和我的族人那裡去，為我的兒子娶一個妻子。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","我問我主人：‘如果那女子不願跟我回來呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","他回答：‘我行事為人都在他面前的耶和華，必差派他的使者與你同去，使你的道路亨通，你就可以從我的族人和我的父家，給我的兒子娶一個妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","只要你到了我的族人那裡去，我叫你起的誓就與你無關；他們若不把女子交給你，我叫你起的誓也與你無關。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","我今天到了水泉那裡，就說：‘耶和華我主人亞伯拉罕的　神啊，你若叫我所走的道路亨通， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","那麼，我現在站在水泉旁邊，但願有一個少女出來打水，我要對她說：“請你把瓶裡的水給我喝一點。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","她若對我說：“你請喝，我還要打水給你的駱駝喝。”願那女子就作耶和華給我主人的兒子所選定的妻子。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","我心裡的話還沒有說完，利百加就肩頭扛著水瓶出來了，她下到水泉那裡去打水；我就對她說：‘請給我水喝。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","她急忙從肩上拿下水瓶來，說：‘請喝，我還要給你的駱駝喝。’我喝了，她也打水給我的駱駝喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","於是我問她，說：‘你是誰的女兒？’她回答：‘我是密迦給拿鶴所生的兒子彼土利的女兒。’我就把鼻環戴在她的鼻子上，把手鐲套在她的兩手上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","然後我跪下敬拜耶和華，稱頌耶和華我主人亞伯拉罕的　神，因為他引導我走恰當的路，使我得到我主人的兄弟的孫女，作我主人的兒子的妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","現在你們若願意以慈愛和信實待我的主人，就請告訴我。如果不願意，也請你們告訴我；使我可以知道怎樣行。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","拉班和彼土利回答，說：“這事既然出於耶和華，我們就不能對你說好說歹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","看哪，利百加就在你面前，你可以把她帶去，照著耶和華所說的，作你主人兒子的妻子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","亞伯拉罕的僕人聽到了他們這些話，就俯伏在地敬拜耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","那僕人拿出金器、銀器和衣服送給利百加，又把貴重的禮物送給她的哥哥和她的母親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","然後，僕人和與他同來的人才吃喝，並且住了一夜。他們早晨起來，僕人就說：“請打發我回到我主人那裡去吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","利百加的哥哥和母親說：“讓這女孩子和我們同住多幾天，或是十天，然後她可以離去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","僕人回答他們：“你們不要挽留我，耶和華既然使我的道路亨通，就請打發我回到我主人那裡去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","他們說：“我們可以把那女孩子叫來，問問她的意思。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","他們把利百加叫了來，問她：“你願意與這人同去嗎？”她回答：“我願意去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","於是，他們把自己的妹妹利百加，她的乳母和亞伯拉罕的僕人，以及同來的人，都打發走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","他們給利百加祝福，對她說：“我們的妹妹啊，願你作千萬人之母；願你的後裔，佔領仇敵的城門。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","利百加和她的眾使女就起來，騎上駱駝，跟著那人走；那僕人就帶著利百加走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","那時，以撒剛從庇耳．拉海．萊回來，他原本是住在南地的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","黃昏的時候，以撒出來田間默想。他舉目觀看，忽然看見來了些駱駝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","利百加舉目觀看，看見了以撒，就下了駱駝， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","問那僕人：“在田間走來迎接我們的這人是誰？”僕人回答：“他是我的主人。”利百加就拿面紗蒙在面上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","僕人把所作的一切事，都告訴以撒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","以撒領利百加進了他母親撒拉的帳棚，並且娶了她。利百加就作了以撒的妻子。以撒愛利百加。以撒自從他母親去世後，這才得了安慰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","亞伯拉罕又娶了一個妻子，名叫基土拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","基土拉給他生了心蘭、約珊、米但、米甸、伊施巴和書亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","約珊生了示巴和底但，而底但的子孫是亞書利人、利都示人和利烏米人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","米甸的兒子是以法、以弗、哈諾、亞比大和以勒大。這些人都是基土拉的子孫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","亞伯拉罕把自己一切所有的都給了以撒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","亞伯拉罕把禮物分給他庶出的眾子，在自己還活著的時候，就打發他們離開他的兒子以撒，向東面行，往東方的地去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","亞伯拉罕一生的年日是一百七十五歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","亞伯拉罕壽高年老，享盡天年，氣絕而死，歸到他的先人那裡去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","他的兒子以撒和以實瑪利把他埋葬在麥比拉洞裡。這洞是在幔利前面，赫人瑣轄的兒子以弗崙的田間， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","就是亞伯拉罕從赫人那裡買來的那塊田。亞伯拉罕和他的妻子撒拉都埋葬在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","亞伯拉罕死後，　神賜福給他的兒子以撒；那時，以撒住在庇耳．拉海．萊附近。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","以下是撒拉的婢女埃及人夏甲，給亞伯拉罕所生的兒子以實瑪利的後代。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","以實瑪利的眾子，按著他們的家譜，名字如下：以實瑪利的長子是尼拜約，其次是基達、押德別、米比衫、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","米施瑪、度瑪、瑪撒、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","哈達、提瑪、伊突、拿非施和基底瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","這些都是以實瑪利的兒子。他們的村莊和營地都按著他們的名字命名；他們作了十二族的族長。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","以實瑪利一生的歲數，是一百三十七歲；他氣絕而死，歸到他的先人那裡去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","他的子孫住在哈腓拉直到埃及東面的書珥，通往亞述的道上。以實瑪利卻住在自己眾兄弟的東面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","以下是亞伯拉罕的兒子以撒的後代。亞伯拉罕生以撒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","以撒娶利百加為妻的時候，正四十歲。利百加是巴旦．亞蘭地、亞蘭人彼土利的女兒，是亞蘭人拉班的妹妹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","以撒因為自己的妻子不生育，就為她懇求耶和華。耶和華應允了他，他的妻子利百加就懷了孕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","雙胎在她腹中彼此碰撞，她就說：“若是這樣，我為甚麼活著呢？”她就去求問耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","耶和華回答她：“兩國在你肚裡，兩族從你腹中要分出來；將來這族必強過那族，大的要服事小的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","到了生產的時候，她肚腹中果然是一對雙生子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","先出來的，全身赤紅有毛，像毛衣一樣，他們就給他起名叫以掃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","隨後，他的弟弟也出來了，他的手抓住以掃的腳跟，因此就給他起名叫雅各。利百加生下兩個兒子的時候，以撒年正六十歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","兩個孩子漸漸長大；以掃善於打獵，喜歡生活在田野；雅各為人安靜，常常住在帳棚裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","以撒愛以掃，因為他常吃以掃的野味；利百加卻愛雅各。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","有一次，雅各正在煮豆湯的時候，以掃從田野回來，疲乏得很。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","以掃對雅各說：“求你把這紅豆湯給我喝吧，因為我疲乏得很。”因此，以掃的名字又叫以東。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","雅各說：“你要先把你的長子名分賣給我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","以掃說：“我快要死了，這長子名分對我有甚麼益處呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","雅各說：“你先向我起誓吧。”以掃就向他起了誓，把自己的長子名分賣給雅各。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","於是，雅各把餅和紅豆湯給了以掃；以掃吃了，喝了，就起來走了。以掃就這樣輕看了他的長子名分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","從前在亞伯拉罕的時候，曾經有過一次饑荒，現在那地又有饑荒，以撒就到基拉耳去，到非利士人的王亞比米勒那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","耶和華向以撒顯現，說：“你不要下到埃及去，要住在我所指示你的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","你要寄居在這地，我必與你同在，必賜福給你，因為我要把這全地都賜給你和你的後裔，履行我向你父親亞伯拉罕所起的誓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","我必使你的後裔增多，好像天上的星那樣多；我必把這全地都賜給你的後裔；地上的萬國都必因你的後裔得福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","這是因為亞伯拉罕聽從了我的話，遵守了我的吩咐、我的命令、我的條例和我的律法。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","於是，以撒就住在基拉耳。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","那地方的人問起他的妻子，他就回答：“她是我的妹妹。”因為他不敢說：“她是我的妻子。”他心裡想：“恐怕這地方的人，因利百加的緣故把我殺了，因為她容貌美麗。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","以撒在那裡住了很久。有一天，非利士人的王亞比米勒從窗戶裡向外觀望，看見以撒正在愛撫他的妻子利百加。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","亞比米勒於是把以撒召了來，對他說：“你看，她實在是你的妻子，你怎麼說是你的妹妹呢？”以撒回答他：“因為我心裡想：‘恐怕我因她的緣故喪命。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","亞比米勒說：“你向我們作的是甚麼事呢？人民中間險些有人與你的妻子同睡，那你就把我們陷在罪惡裡了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","於是，亞比米勒吩咐全國人民，說：“凡是觸犯這人或是他的妻子的，必被處死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","以撒在那裡耕種，那一年豐收百倍， 耶和華實在賜福給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","他就日漸昌大，越來越富有，成了個大富翁。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","他擁有羊群、牛群和很多僕人，非利士人就嫉妒他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","他父親亞伯拉罕在世的時候，所有由他父親僕人挖的井，非利士人都塞住了，填滿了土。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","亞比米勒對以撒說：“你離開我們去吧，因為你比我們強大得多了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","以撒於是離開那裡，在基拉耳谷支搭帳棚，住在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","他父親亞伯拉罕在世的時候，僕人所挖的水井，在亞伯拉罕死後都被非利士人塞住了。以撒重新挖掘這些井，仍然照著他父親所起的名字叫它們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","以撒的僕人在山谷裡挖井，在那裡挖得一口活水井。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","基拉耳的牧人與以撒的牧人爭鬧起來，說：“這水是我們的。”以撒就給那井起名叫埃色，因為他們與他相爭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","以撒的僕人又挖了另一口井，他們又為這井爭鬧起來，因此以撒給這井起名叫西提拿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","以撒離開那裡，又挖了另一口井；他們不再為這井爭鬧了，他就給那井起名利河伯，因為他說：“現在耶和華給我們寬闊的地方，我們必在這裡繁盛起來了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","以撒從那裡上到別是巴去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","那天晚上，耶和華向他顯現，說：“我是你父親亞伯拉罕的　神；你不要怕，因為我與你同在；我必為了我僕人亞伯拉罕的緣故，賜福給你，使你的後裔增多。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","以撒就在那裡築了一座祭壇，呼求耶和華的名；又在那裡支搭帳棚；以撒的僕人也在那裡挖了一口井。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","亞比米勒和他的朋友亞戶撒，以及他的軍長非各，從基拉耳來到以撒那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","以撒問他們：“你們既然恨我，把我從你們中間趕出來，為甚麼又到我這裡來呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","他們回答：“我們實在看見耶和華與你同在，因此我們想：‘不如我們雙方起誓。’讓我們與你立約吧； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","你不要傷害我們，正如我們從來沒有觸犯你，只有善待你，讓你平平安安地離開。現在你是蒙耶和華賜福的了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","以撒就為他們擺設筵席，他們就一起吃喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","第二天，他們清早起來，彼此起誓；以撒就送他們走，他們平平安安地離開他走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","那一天，以撒的僕人來把他們挖井的事告訴他，說：“我們找到水了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","以撒就給那井起名叫示巴，因此那城名叫別示巴，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","以掃四十歲的時候，娶了赫人比利的女兒猶滴，和赫人以倫的女兒巴實抹為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","她們二人常使以撒和利百加傷心難過。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","以撒年老，眼睛昏花，看不見東西了；他把他的大兒子以掃叫了來，對他說：“我兒啊！”以掃回答他：“我在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","以撒說：“現在我已經老了，不知道甚麼時候會死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","你現在拿你打獵的用具，就是你的箭囊和弓，出到田野去為我打獵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","照我所喜歡的，給我預備美味的食物，拿來給我吃；好讓我在未死以前給你祝福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","以撒對他兒子以掃說話的時候，利百加也聽見。以掃到田野去打獵，要帶些野味回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","利百加就對她兒子雅各說：“我聽見你父親對你的哥哥以掃這樣說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘你去為我打些獵物回來，給我預備美味的食物，讓我吃了，在我未死以前可以在耶和華面前給你祝福。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","我兒啊，現在你要聽我的話，照著我吩咐你的去作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","你快到羊群那裡去，給我牽兩隻肥嫩的小山羊來，我要照你父親所喜歡的，給他預備美味的食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","然後你要拿去給你父親吃，好讓他在未死以前給你祝福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","雅各對他的母親利百加說：“但是哥哥以掃渾身是毛，而我卻是個皮膚光滑的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","萬一我父親摸著我，必以為我是騙子，那時我就必自招咒詛，而不是祝福了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","他母親對他說：“我兒啊，願你所招的咒詛歸到我身上吧，你只管聽我的話，去把羊牽來給我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","他就去把羊羔牽來，交給他母親，他母親就照他父親所喜歡的，預備美味的食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","利百加又把大兒子以掃留在家裡最好的衣服拿來，給她小兒子雅各穿上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","又用小山羊的皮，包在雅各的手上和他頸上光滑的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","然後，她把自己所預備美味的食物和餅，放在她兒子雅各的手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","雅各來到他父親那裡，說：“我父啊！”以撒說：“我在這裡，我兒啊，你是誰？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","雅各對他父親說：“我就是你的長子以掃，你吩咐我作的，我已經照樣作了。請坐起來，吃我的獵物，好給我祝福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","以撒問他的兒子：“我兒啊，你怎麼這樣快就獵到了呢？”雅各回答：“因為耶和華你的　神叫我碰著好機會。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","以撒對雅各說：“我兒啊，你上前來，讓我摸摸你，看看你是不是我的兒子以掃。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","雅各就走近他父親以撒身邊，以撒摸著他，說：“聲音是雅各的聲音，手卻是以掃的手。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","以撒認不出他來，因為他的手上有毛，好像他哥哥以掃的手一樣，於是給他祝福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","以撒問：“你真是我的兒子以掃嗎？”他回答：“我是。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","以撒說：“把食物遞給我，好讓我吃我兒子的獵物，我就給你祝福。”雅各把食物遞給他，他就吃了；又拿酒給他，他也喝了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","他父親以撒對他說：“我兒啊，你上前來，和我親嘴。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","他就上前和父親親嘴；他父親一聞到他衣服的香氣，就給他祝福，說：“看哪，我兒子的香氣，好像蒙耶和華賜福的田地所發出的香氣一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","願　神賜給你天上的甘露，地上的沃土，以及大量五穀和美酒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","願萬民服事你，願萬族向你下拜，願你作你兄弟的主人，願你母親的子孫向你下拜。咒詛你的，願他受咒詛；給你祝福的，願他蒙福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","以撒給雅各祝福完了，雅各剛剛從他父親以撒那裡出來的時候，他哥哥以掃就打獵回來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","他也預備了美味的食物，拿來給他父親，對他說：“請我父起來，吃你兒子的獵物，好給我祝福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","他父親以撒問他：“你是誰？”他回答：“我就是你的長子以掃。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","以撒就大大地戰兢起來，說：“那麼，剛才去打獵又拿獵物給我的是誰呢？在你未來以先，我已經吃了，又給他祝福了；他將來必定蒙福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","以掃聽了他父親的話，就非常痛心，放聲大哭，對他父親說：“我父啊，求你也給我祝福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","以撒說：“你弟弟已經前來，用詭計把你的祝福奪去了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","以掃說：“他名叫雅各不是很對嗎？因為他欺騙了我兩次。從前他奪去我的長子名分，現在他又奪去我的祝福。”以掃又說：“你再沒有祝福留給我嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","以撒回答以掃，說：“我已經立他作你的主人，又把他所有的兄弟給了他作僕人，並且把五穀和美酒供給他了。我兒啊，我還可以為你作甚麼呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","以掃問他的父親：“我父啊，你只有一個祝福嗎？我父啊，求你也給我祝福。”以掃就放聲大哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","他父親以撒回答他，說：“你住的地方必遠離地上的沃土，遠離天上的甘露。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","你必依靠刀劍生活，你必服事你的弟弟；到你自由的時候，你必從你的頸項上掙脫他的軛。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","以掃因為他父親給雅各所祝的福，就懷恨雅各；以掃心裡想：“為我父親守喪的時候近了，到時我必殺我的弟弟雅各。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","有人把利百加大兒子以掃所說的話告訴了利百加，她就派人把她小兒子雅各叫了來，對他說：“你哥哥以掃想要殺你，報仇雪恨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","我兒啊，現在你要聽我的話；起來，逃到哈蘭我哥哥拉班那裡去吧。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","與他住些時日，等到你哥哥的怒氣消了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","你哥哥對你消了怒氣，忘記了你對他所作的事，我就派人去把你從那裡接回來。我何必在一日之內喪失你們兩個呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","利百加對以撒說：“我因為這些赫人女子，連性命都厭惡了。如果雅各也從這地的女子中，娶了像這樣的赫人女子為妻，那我活著還有甚麼意思呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","以撒把雅各叫了來，給他祝福，並且吩咐他，說：“你不可娶迦南的女子為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","起來，到巴旦．亞蘭你外祖父彼土利的家裡去，在那裡娶你舅父拉班的一個女兒為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","願全能的　神賜福給你，使你繁殖增多，成為大族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","願　神把應許給亞伯拉罕的福，賜給你和你的後裔，使你可以得著你寄居的地為業，就是　神賜給亞伯拉罕的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","於是，以撒打發雅各去了，雅各就往巴旦．亞蘭去，到了亞蘭人彼土利的兒子拉班那裡。拉班就是雅各和以掃的母親利百加的哥哥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","以掃見以撒給雅各祝福，又打發他到巴旦．亞蘭去，在那裡娶妻；又見以撒給雅各祝福的時候，吩咐他說：“你不可娶迦南的女子為妻”； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","又見雅各聽從了他父母的話，到巴旦．亞蘭去了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","以掃就看出，他父親以撒不喜歡迦南的女子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","於是，以掃到以實瑪利那裡去，在他兩個妻子以外，娶了瑪哈拉為妻。瑪哈拉就是亞伯拉罕的兒子以實瑪利的女兒，尼拜約的妹妹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","雅各離開別是巴，到哈蘭去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","來到一個地方，就在那裡過夜，因為太陽已經落了。他拾起那地方的一塊石頭，把它放在頭底下作枕頭，就在那裡躺下睡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","他作了一個夢，夢見一個梯子立在地上，梯頂直通到天，　神的眾使者在梯子上下往來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","耶和華站在梯子上，說：“我是耶和華你祖父亞伯拉罕的　神，也是以撒的　神，我要把你現在躺著的這塊地賜給你和你的後裔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","你的後裔必像地面的灰塵那麼多；你必向東、南、西、北擴展；地上的萬族必因你和你的後裔得福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","我與你同在，你無論到哪裡去，我必看顧你；我必領你回到這地方來，因為我必不離棄你，直到我實現了我對你所應許的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","雅各一覺醒來，說：“耶和華確實在這地方，我竟不知道！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","他就懼怕起來，說：“這地方多麼可畏啊，這不是別的地方，而是　神的殿，是天的門。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","雅各清早起來，把他曾經放在頭底下作枕頭的那塊石頭，立作石柱，在柱上澆了油。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","他就給那地方起名叫伯特利，但那城起初名叫路斯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","於是雅各許了一個願說：“如果　神與我同在，在我所走的路上看顧我，賜我食物吃，給我衣服穿， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","使我可以平平安安地回到我的父家，我就必定以耶和華為我的　神， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","我立作石柱的那塊石頭，必作　神的殿；你賜給我的一切，我必把十分之一獻給你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","雅各繼續前行，到了東方人的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","他看見田間有一口井；有三群羊躺臥在井旁，因為人都是用那井裡的水給羊群喝；井口上有一塊大石頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","當所有羊群都到齊了，牧人就把井口的石頭輥開，取水給羊群喝，然後把石頭放回井口原處。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","雅各問這些牧人：“弟兄們，你們是哪裡來的？”他們回答：“我們是從哈蘭來的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","他問他們：“你們認識拿鶴的孫子拉班嗎？”他們回答：“我們認識。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","雅各又問他們：“他平安嗎？”他們回答：“平安。你看，他的女兒拉結領著羊群來了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","雅各說：“現在太陽還高，不是牲畜聚集的時候；你們取水給羊群喝，再去牧放吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","他們回答：“我們不能這樣作，必須等到所有的羊群都到齊了，有人把井口的石頭輥開，我們才可以取水給羊群喝。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","雅各還跟他們說話的時候，拉結領著她父親的羊群來了。拉結原來是個牧羊女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","雅各看見了舅父拉班的女兒拉結，和舅父拉班的羊群，就上前來，把井口的石頭輥開，取水給舅父拉班的羊群喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","雅各和拉結親嘴，就放聲大哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","雅各告訴拉結，自己是她父親的外甥，是利百加的兒子。拉結就跑去告訴她的父親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","拉班聽見了關於外甥雅各的消息，就跑去迎接他，擁抱他，和他親嘴，帶他到自己的家裡。雅各就把一切經過都告訴拉班。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","拉班對雅各說：“你實在是我的骨肉。”雅各就與拉班同住了一個月。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","拉班對雅各說：“你因為是我的外甥，就要白白地服事我嗎？告訴我，你要甚麼報酬？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","拉班有兩個女兒；大的名叫利亞，小的名叫拉結。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","利亞的眼睛雖然可愛，拉結卻生得身材美麗，樣貌娟秀。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","雅各愛拉結，所以對拉班說：“我願為你的小女兒拉結服事你七年。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","拉班說：“我把她給你，比給別人更好，你就與我同住吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","於是，雅各為拉結服事了拉班七年；他就看這七年好像幾天一樣，因為他愛拉結。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","雅各對拉班說：“期限到了，請把我的妻子給我，好讓我與她親近。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","拉班就擺設筵席，邀請了那地方所有的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","到了晚上，拉班把自己的女兒利亞帶來給雅各，雅各就與她親近。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","拉班又把自己的婢女悉帕給了女兒利亞作婢女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","到了早晨，雅各才看出原來是利亞，就對拉班說：“你向我作的是甚麼事呢？我服事你，不是為了拉結的緣故嗎？你為甚麼欺騙我呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","拉班回答：“大女兒還沒有出嫁，就先把小女兒嫁出去，我們這地方是沒有這規矩的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","你與大女兒七天的慶典過了以後，我們也把小女兒給你，只是你要再服事我七年。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","於是雅各這樣作了。他與利亞七天的慶典過了以後，拉班就把自己的女兒拉結給雅各為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","拉班又把自己的婢女辟拉給了女兒拉結作婢女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","雅各也與拉結親近，並且愛拉結勝過愛利亞；於是他再服事了拉班七年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","耶和華見利亞失寵，就使她生育，拉結卻不生育。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","利亞懷孕，生了一個兒子，就給他起名叫流本，因為她說：“耶和華看見了我的苦情，現在我的丈夫必愛我了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","她又懷孕，生了一個兒子，就說：“耶和華因為聽見我失寵，所以又賜給我這個兒子。”於是給他起名叫西緬。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","她又懷孕，生了一個兒子，就說：“這一次，我的丈夫要依戀我了，因為我已經給他生了三個兒子。”因此給孩子起名叫利未。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","她又懷孕，生了一個兒子，就說：“這一次，我要讚美耶和華了。”因此給孩子起名叫猶大。這樣，她才停止了生育。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","拉結見自己沒有給雅各生孩子，就嫉妒她的姊姊，對雅各說：“你要給我兒子，不然，我要死了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","雅各就向拉結生氣，說：“使你不能生育的是　神，我能代替他嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","拉結說：“我的婢女辟拉在這裡，你可以與她親近，使她生子歸我，我就可以從她得到孩子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","於是，拉結把自己的婢女辟拉給了雅各為妾，雅各就與她親近。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","辟拉懷孕，給雅各生了一個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","拉結說：“　神為我伸了冤，也垂聽了我的聲音，賜給我一個兒子。”所以給他起名叫但。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","拉結的使女辟拉又懷孕，給雅各生了第二個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","拉結說：“我與姊姊大大地相爭，我得勝了。”於是給孩子起名叫拿弗他利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","利亞見自己停止生育，就把她的婢女悉帕給了雅各為妾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","利亞的婢女悉帕給雅各生了一個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","利亞說：“我真幸運。”給他起名叫迦得。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","利亞的婢女悉帕又給雅各生了第二個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","利亞說：“我真有福氣，眾女子都要稱我是有福的。”於是給孩子起名叫亞設。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","到了收割麥子的時候，流本出去，在田間找到了一些風茄，就拿來給他母親利亞。拉結對利亞說：“請你把你兒子的風茄分一些給我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","利亞回答拉結：“你奪去了我的丈夫，還算小事嗎？你還要奪去我兒子的風茄嗎？”拉結說：“好吧，今夜就讓他與你同睡，來交換你兒子的風茄。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","到了晚上，雅各從田間回來，利亞出去迎接他，說：“你要與我親近，因為我實在用我兒子的風茄把你雇下了。”那一夜，雅各就與利亞同睡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","神垂聽了利亞的禱告，利亞就懷孕，給雅各生了第五個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","利亞說：“　神給了我酬報，因為我把我的婢女給了我的丈夫。”於是給孩子起名叫以薩迦。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","利亞又懷孕，給雅各生了第六個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","利亞說：“　神把美好的禮物送了給我，這一次我的丈夫要抬舉我了，因為我給他生了六個兒子。”於是給孩子起名叫西布倫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","後來利亞又生了一個女兒，給她起名叫底拿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","神顧念拉結，垂聽了她的禱告，使她能生育。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","拉結就懷孕，生了一個兒子，說：“　神把我的恥辱除去了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","於是給孩子起名叫約瑟，說：“願耶和華再給我一個兒子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","拉結生了約瑟以後，雅各對拉班說：“請你讓我走吧，我好回到自己的地方，自己的故鄉去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","請你把我服事你所得的妻子和兒女都給我，讓我回去；我怎樣服事了你，你是知道的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","拉班對他說：“我若蒙你賞臉，請你不要走，因為我得了神旨，知道耶和華賜福給我，是因你的緣故。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","他又說：“請你定你的工資吧，我必給你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","雅各對拉班說：“我怎樣服事了你，你的牲畜在我手裡情形怎樣，你是知道的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","我沒來以前，你所有的很少，現在卻大大地增加了；耶和華隨著我的腳蹤賜福給你。現在，我甚麼時候才能興家立業呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","拉班問：“我該給你甚麼？”雅各回答：“你甚麼也不必給我；只要你答應我這一件事，我就繼續牧放看守你的羊群。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","今天我要走遍你的羊群，凡有斑點的羊、黑色的綿羊和有斑點的山羊，都挑出來，作為我的工資。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","日後你來查看我的工資的時候，我好對你證明我的公道。凡在我手裡沒有斑點的山羊，或不是黑色的綿羊，都算是我偷來的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","拉班回答：“好吧，就照你的話去作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","當日，拉班把有條紋和有斑點的公山羊、有斑點和有白紋的母山羊，以及所有黑色的綿羊，都挑出來交在自己的眾子手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","又使自己和雅各之間相距有三天的路程。雅各就牧放拉班其餘的羊群。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","雅各拿楊樹、杏樹和楓樹的嫩枝子，把樹皮剝成白色的條紋，使枝子露出白的部分來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","然後把剝了皮的枝子插在水溝和水槽裡，枝子正對著來喝水的羊群。羊群來喝水的時候，就彼此交配。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","羊群對著枝子交配，就生下有條紋和有斑點的小羊來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","雅各把羊羔分別出來，使拉班的羊，對著這些有條紋的和所有黑色的羊。他為自己另組羊群，不把牠們放在拉班的羊群中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","到了肥壯的羊群要交配的時候，雅各就在羊群的面前把枝子插在水溝裡，使牠們在枝子中間彼此交配。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","但當瘦弱的羊群交配的時候，雅各就不插枝子。這樣，瘦弱的就歸拉班，肥壯的就歸雅各。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","於是，雅各變成非常富有，擁有很多羊群、僕婢、駱駝和驢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","雅各聽見拉班的眾子談論，說：“雅各把我們父親所有的都奪去了，他這一切財物，都是從我們父親的財產那裡得來的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","雅各也注意到拉班的臉色，對自己不像從前那樣了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","那時，耶和華對雅各說：“你要回到你列祖之地，到你的親族那裡去，我必與你同在。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","雅各就派人把拉結和利亞叫到田間的羊群那裡去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","對她們說：“我注意到你們父親的臉色，對我不像從前那樣了；但是我父親的　神與我同在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","我盡了我的力量來服事你們的父親，這是你們知道的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","你們的父親卻欺騙了我，十次更改了我的工資；但　神不容許他傷害我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","如果他說：‘有斑點的算是你的工資’，羊群所生的全部都有斑點；如果他說：‘有條紋的算是你的工資’，羊群所生的全部有條紋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","這樣，　神把你們父親的牲畜奪來，賜給我了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","有一次，羊群交配的時候，我在夢中舉目觀看，看見爬在母羊身上的公山羊，都是有條紋、有斑點和有花斑的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","神的使者在夢中對我說：‘雅各。’我說：‘我在這裡。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","他說：‘你舉目觀看，所有爬在母羊身上的公山羊，都是有條紋、有斑點和有花斑的，因為拉班向你所作的一切，我都看見了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","我就是伯特利的　神，你曾經在那裡用油膏過石柱，又在那裡向我許過願。現在你要起程，離開這地，回到你的親族那裡去吧。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","拉結和利亞回答雅各，說：“在我們父親的家裡，我們還有可得的分和產業嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","他不是把我們看作外人嗎？因為他把我們賣了，吞沒了我們的身價。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","神從我們父親奪回來的一切財物，都是屬於我們和我們的兒女的。現在　神吩咐你的一切，你只管作吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","於是雅各起來，叫他的兒女和妻子們都騎上駱駝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","又趕著他所有的牲畜，帶著他所得的一切財物，就是他在巴旦．亞蘭所得的一切牲畜，要到迦南地，他父親以撒那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","當時拉班剪羊毛去了，拉結就偷了他父親的神像。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","雅各瞞著亞蘭人拉班，沒有告訴拉班他將要逃走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","於是，雅各帶著他所有的一切逃走了。他起程渡過了大河，面對著基列山走去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","到了第三天，有人告訴拉班說雅各逃走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","拉班就帶著自己的眾兄弟追趕他，追了七日的路程，才在基列山把他們追上了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","當天晚上，　神在夢中來到亞蘭人拉班那裡，對他說：“你要小心，不可與雅各說甚麼。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","拉班追上了雅各。當時雅各已經在山上支搭了帳棚；拉班和他的眾兄弟，也在基列山上支搭了帳棚。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","拉班對雅各說：“你作的是甚麼事呢？你瞞著我，把我的女兒們當作戰俘一樣帶走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","你為甚麼暗中逃走，瞞著我不讓我知道，使我可以歡歡喜喜地唱歌、擊鼓、彈琴給你送行呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","你又不讓我與我的外孫和女兒親嘴。你所作的太糊塗了！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","我本來有能力可以傷害你，但昨天晚上，你們父親的　神對我說：‘你要小心，不可與雅各說甚麼。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","現在你既然渴想你的父家，一定要回去，為甚麼又偷我的神像呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","雅各回答拉班，說：“我逃走，是因為我害怕，我心裡想：恐怕你會把你的女兒們從我的手中搶走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","至於你的神像，你在誰身上搜出來，那人就不該活著；你當著我們眾兄弟面前查一查，如果在我這裡有甚麼東西是你的，你只管拿去。”原來雅各不知拉結偷了神像。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","拉班進了雅各的帳棚、利亞的帳棚和兩個婢女的帳棚，都沒有搜出甚麼，於是從利亞的帳棚出來，進了拉結的帳棚。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","拉結已經把神像放在駱駝的鞍下，自己坐在上面。拉班搜遍了帳棚，但沒有搜出甚麼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","拉結對她父親說：“求我主不要生氣，我不能在你面前起來，因為我正有女人的經期。”這樣，拉班徹底搜查了，也搜不出那神像來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","雅各就生氣，與拉班爭吵起來。雅各責問拉班說：“我到底有甚麼過犯，有甚麼罪惡，你竟這樣急速地追趕我呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","你已經搜遍了我所有的家具，你有找到你家的東西沒有？可以把它放在這裡，在你我的眾兄弟面前，讓他們可以在你我中間判斷一下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","這二十年來，我與你在一起；你的母綿羊和母山羊沒掉過胎，你羊群中的公羊，我沒有吃過。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","被野獸撕裂的，我沒有給你帶回來，都是由我自己賠償；無論白天偷去的，或是黑夜偷的，你都要我負責。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","我白天受盡炎熱，黑夜受盡寒霜，不能入睡；我經常是這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","我這二十年在你的家裡，為你的兩個女兒服事了你十四年；為你的羊群服事了你六年；你又十次改了我的工資。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","如果不是我父親的　神，就是亞伯拉罕的　神，以撒所敬畏的　神，與我同在，你現在必定打發我空手回去。但　神看見了我的苦情和我手中的辛勞，所以他昨天晚上責備了你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","拉班回答雅各，說：“這些女兒是我的女兒；這些孩子是我的孩子；這些羊群也是我的羊群。其實你眼所見的一切都是我的。但我今日向我的女兒和她們所生的孩子，能作甚麼呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","來吧，現在我和你可以立約，作為你我之間的證據。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","雅各就拿了一塊石頭，立作石柱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","雅各又對自己的眾兄弟說：“你們把石頭堆聚起來。”他們就把石頭拿來，堆成了一堆。他們又在石堆旁邊吃喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","拉班稱那石堆為伊迦爾．撒哈杜他，雅各卻稱那石堆為迦累得。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","拉班說：“今天這堆石頭是你我之間的證據。”因此它名叫迦累得， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","又名叫米斯巴，因為拉班說：“我們彼此分離以後，願耶和華在你我中間鑒察。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","你若苦待我的女兒，或在我的女兒以外，另娶妻子，雖然沒有人在我們中間作證，但你要注意，　神就是你我之間的見證人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","拉班又對雅各說：“你看這堆石頭，看我在你我之間所豎立的石柱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","這堆石頭就是證據，這石柱也是證據：我決不越過這石堆到你那裡去，你也決不可越過這石堆和石柱，到我這裡來害我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","但願亞伯拉罕的　神、拿鶴的　神，就是他們父親的　神，在我們中間判斷。”雅各就指著他父親以撒所敬畏的　神起誓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","雅各又在山上獻祭，叫了自己的眾兄弟來吃飯。他們吃了飯，就在山上過夜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","拉班清早起來，與他的外孫和女兒親嘴，給他們祝福。然後拉班離開那裡，回自己的地方去了。（本節在《馬索拉抄本》為32:1） ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","雅各繼續他的路程，　神的眾使者遇見他。（本節在《馬索拉抄本》為32:2） ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","雅各看見他們，就說：“這是　神的軍隊。”於是給那地方起名叫瑪哈念。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","雅各先派使者到西珥地，就是以東的地區，他的哥哥以掃那裡去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","吩咐他們說：“你們要對我主以掃這樣說：‘你的僕人雅各這樣說：我在拉班那裡寄居，一直到現在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","我擁有牛、驢、羊群、僕婢，現在派人來報告我主，希望得到你的歡心。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","使者回到雅各那裡說：“我們到了你哥哥以掃那裡，他帶著四百人，正迎著你來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","雅各感到非常懼怕和焦慮，就把隨行的人、羊群、牛群和駱駝，分成兩隊， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","心裡想：“即使以掃來擊殺這一隊，餘下的一隊還可以逃脫。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","雅各說：“耶和華，我祖亞伯拉罕的　神，我父以撒的　神啊，你曾經對我說過：‘回到你自己的故鄉，到你的親族那裡去，我必厚待你。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","你向你僕人所施的一切慈愛和信實，我實在不配得。從前我只拿著我的手杖過這約旦河；現在我卻擁有這兩隊人馬了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","求你救我脫離我哥哥以掃的手，因為我怕他來擊殺我，連母親和孩子也擊殺了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","你曾經說過：‘我必厚待你，使你的後裔好像海邊的沙一樣，多到不可勝數。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","那天晚上，雅各在那裡過夜。然後從他所擁有的牲畜中，取出一部分，作為給他哥哥以掃的禮物， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","就是母山羊二百隻、公山羊二十隻、母綿羊二百隻、公綿羊二十隻、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","哺乳的母駱駝三十匹，各帶著駒子，母牛四十頭、公牛十頭、母驢二十頭、公驢十頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","雅各把這些分成一隊一隊，交在僕人的手裡，又對僕人說：“你們先過去，每隊之間要留一段距離。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","他又吩咐走在最前的僕人說：“我哥哥以掃遇見你的時候，如果問你：‘你的主人是誰？你要到哪裡去？在你前面的這些牲畜是誰的？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","你就要回答：‘是你僕人雅各的，是送給我主以掃的禮物，他自己也在我們後面。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","他又吩咐第二個、第三個和所有跟在隊伍後面的人說：“你們遇見以掃的時候，都要這樣對他說。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","你們還要說：‘你的僕人雅各在我們後面。’”因為他心裡想：“我先送禮物去，藉此與他和解，然後再與他見面，或者他會原諒我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","於是禮物先過去了；那天晚上雅各在營中過夜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","雅各那夜起來，帶著他的兩個妻子、兩個婢女和十一個孩子，都過了雅博渡口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","他帶著他們，先打發他們過河，然後又打發他所有的都過去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","只留下雅各一人，有一個人來與他摔角，直到天快亮的時候。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","那人見自己不能勝過他，就在他的大腿窩上打了一下。於是，雅各與那人摔角的時候，大腿窩脫了節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","那人說：“天快亮了，讓我走吧。”雅各說：“如果你不給我祝福，我就不讓你走。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","那人問他：“你叫甚麼名字？”他回答：“雅各。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","那人說：“你的名字不要再叫雅各，要叫以色列，因為你與　神與人較力，都得了勝。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","雅各問他，說：“請把你的名告訴我。”那人回答：“為甚麼問我的名呢？”他就在那裡給雅各祝福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","於是，雅各給那地方起名叫毗努伊勒，意思說：“我面對面看見了　神，我的性命仍得保全。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","雅各經過毗努伊勒的時候，太陽剛剛出來，照在他身上。他因為大腿的傷，跛腳行走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","因此，以色列人直到現在都不吃大腿窩上的筋，因為那人在雅各的大腿窩上的筋打了一下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","雅各舉目觀看，見以掃帶著四百人來了；他就把孩子分開三隊，交給利亞、拉結和兩個婢女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","他叫兩個婢女和她們的孩子走在前頭，利亞和她的孩子跟著，拉結和約瑟走在最後。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","他自己卻走在他們前面，七次俯伏在地，直到走近他哥哥跟前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","以掃跑來迎接他，擁抱他，伏在他頸項上，與他親嘴；兩個人都哭了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","以掃舉目觀看，看見婦人和孩子，就問：“這些與你同來的人是誰？”雅各回答：“是　神賜給你僕人的孩子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","於是，兩個婢女和她們的孩子上前下拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","利亞和她的孩子也上前下拜，隨後，約瑟和拉結也上前下拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","以掃又問：“我遇見的這一群牲畜，是甚麼意思呢？”雅各回答：“是要討我主喜悅的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","以掃說：“弟弟啊，我已經很富有了，你的仍歸你吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","雅各說：“請不要這樣，我若得你的喜悅，就求你從我手裡收下這些禮物吧；因為我看見了你的面，就好像見了　神的面；你實在恩待了我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","請你收下我帶來給你的禮物，因為　神施恩給我，我甚麼都有了。”雅各再三懇求他，他才收下了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","以掃說：“我們起程前行吧，我和你一起走。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","雅各對他說：“我主知道孩子們還年幼嬌嫩；牛羊也正在乳養的時候，需要我的照顧；如果要催趕牠們走一天的路，恐怕所有牲畜都要死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","請我主在僕人前頭先行；我要照著在我面前群畜和孩子們的速度，慢慢前行，直走到西珥我主那裡去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","以掃說：“讓我把跟隨我的人留幾個在你這裡吧。”雅各說：“為甚麼要這樣呢？只要我得我主的喜悅就是了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","於是，以掃在那一天回西珥去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","雅各卻起程到疏割去，在那裡為自己建造了一座房子，又為牲畜搭了些草棚，因此給那地方起名叫疏割。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","雅各從巴旦．亞蘭回來的時候，平平安安地到了迦南地的示劍城，在城的對面支搭了帳棚。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","他支搭帳棚的那塊地，是他用一百塊銀子向示劍的父親哈抹的子孫買來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","在那裡雅各建了一座壇，給它起名叫伊利．伊羅伊．以色列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","利亞給雅各所生的女兒底拿，出去要看看當地的女子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","當地的首長，希未人哈抹的兒子示劍，看見她，就拉住她，把她強姦，污辱了她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","示劍的心戀慕雅各的女兒底拿，他深愛這少女，就用甜言蜜語安慰她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","示劍對他父親哈抹說：“求你為我聘這女子為妻。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","雅各聽見示劍姦污了他的女兒底拿；但那時他的兒子正在田間看守他的牲畜，所以他沒有作聲，只等他們回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","示劍的父親哈抹出來見雅各，要與他商議。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","雅各的兒子聽見了這事，就從田間回來；各人都感到非常悲痛和忿怒，因為示劍在以色列中作了醜事，就是把雅各的女兒姦污了，這是不應該作的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","哈抹與他們商議說：“我兒子示劍的心依戀你們家的女兒，請你們把她給我的兒子為妻吧。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","你們與我們可以彼此結親；你們可以把女兒嫁給我們，也可以娶我們的女兒為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","這樣，你們可以與我們同住；這地就擺在你們面前，只管在其中居住，來往作買賣，購置產業吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","示劍對底拿的父親和她的兄弟說：“但願我得你們的喜悅，無論你們要甚麼，我必給你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","任由你們向我要多重的聘金和多大的禮物，我必照你們所說的給你們，只要你們把這少女給我為妻就是了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","雅各的眾子，因為示劍姦污了他們的妹妹底拿，就用欺詐的話回答示劍和他父親哈抹， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","對他們說：“我們不能把妹妹給一個沒有受割禮的人為妻，因為那是我們的恥辱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","只有一個條件，我們才可以答允你們，就是你們當中所有的男子都受割禮，像我們一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","我們就可以把女兒嫁給你們，也可以娶你們的女兒為妻；我們可以與你們同住，大家成為一族人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","但如果你們不肯聽從我們受割禮，我就要把我們家的女兒帶走了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","哈抹和他兒子示劍覺得他們的提議很好。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","那少年就立刻照著去作，因為他喜愛雅各的女兒；他在他父親的全家中又是最受尊敬的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","哈抹和他兒子示劍來到自己的城的門口，對城裡的人說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“這些人與我們和平相處，不如讓他們在這地居住，來往作買賣吧。這地兩邊都很寬闊，可以容納他們；我們可以娶他們的女兒為妻，也可以把我們的女兒嫁給他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","但是只有一個條件，這些人才應允與我們同住，大家成為一族人，就是我們中間所有的男子都受割禮，好像他們受了割禮一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","這樣他們的牲畜、財產和所有的牲口，不都要歸我們所有嗎？只要我們應允他們的條件，他們就與我們同住了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","所有從城門出入的人，都聽從了哈抹和他兒子示劍的話。於是，所有從城門出入的男子，都受了割禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","到了第三天，他們正在疼痛的時候，雅各的兩個兒子，就是底拿的哥哥西緬和利未拿著刀劍，趁著他們想不到的時候，進了那城，把所有的男子都殺了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","又用刀劍殺了哈抹和他兒子示劍，然後從示劍的家裡把底拿帶走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","雅各的兒子因為他們的妹妹被人姦污了，就來到被殺的人那裡，搶掠那城， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","奪去他們的羊群、牛群和驢，以及城裡和田間所有的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","又把他們所有的財物、孩子和婦女都擄去。屋裡所有的東西，都搶掠一空。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","雅各對西緬和利未說：“你們連累了我，使我在這地的居民，就是在迦南人和比利洗人中間，成了可憎的人。我們人數不多，如果他們聯合起來對付我，攻擊我，我和我的家就必滅絕了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","他們回答說：“他怎可以待我們的妹妹好像妓女一樣呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","神對雅各說：“起來，上伯特利去，住在那裡；你要在那裡築一座壇給　神，就是從前你逃避你哥哥以掃的時候，向你顯現的那一位。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","雅各就對他的家人，和所有與他在一起的人說：“你們要除去你們中間外族人的神像，你們要潔淨自己，更換你們的衣服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","我們要起程，上伯特利去；我要在那裡給　神築一座祭壇，他就是在我遭患難的時候應允我的呼求，在我所行的路上與我同行的那一位。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","他們就把自己手中所有外族人的神像，和自己耳朵上的環子，都交給雅各；雅各把這些東西埋在示劍附近的橡樹底下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","他們出發了，　神使周圍的城市都非常懼怕，他們就不追趕雅各的兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","於是雅各和與他在一起的人，到了迦南地的路斯，就是伯特利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","他在那裡築了一座壇，就稱那地方為伊勒．伯特利，因為他逃避他哥哥的時候，　神曾經在那裡向他顯現。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","利百加的乳母底波拉死了，葬在伯特利下邊的橡樹底下，所以給那棵樹起名叫亞倫．巴古。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","雅各從巴旦．亞蘭回來以後，　神再次向他顯現，賜福給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","神對他說：“你的名原是雅各，但以後不要再叫雅各，以色列才是你的名。”這樣，　神給他改名叫以色列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","神對他說：“我是全能的　神，你要繁殖增多，必有一大國從你而生，又必有很多君王從你而出。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","我賜給亞伯拉罕和以撒的地，我要賜給你，我也要把這地賜給你的後裔。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","神從與雅各談話的地方，離開他上升去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","雅各就在　神與他談話的地方，立了一根石柱；在柱上澆了奠祭和油。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","雅各給　神與他談話的地方起名叫伯特利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","他們從伯特利起程，離以法他還有一段路程的時候，拉結產期到了；但她遇到難產。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","她正在極辛苦的時候，接生婆對她說：“不要怕，你這次又得了一個兒子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","拉結快要死了，正要斷氣的時候，她給她兒子起名叫便．俄尼；他的父親卻叫他便雅憫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","拉結死了，葬在通往以法他的路旁。以法他就是伯利恆。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","雅各在她的墳墓上立了一根柱子，就是拉結的墓碑，到今天還在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","以色列又起程前行，在以得臺那邊支搭了帳棚。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","以色列在那地居住的時候，流本竟去與他父親的妾辟拉同睡；這事以色列也聽見了。雅各共有十二個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","利亞的兒子有：雅各的長子流本，以及西緬、利未、猶大、以薩迦和西布倫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","拉結的兒子有：約瑟和便雅憫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","拉結的婢女辟拉的兒子有：但和拿弗他利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","利亞的婢女悉帕的兒子有：迦得和亞設。這些都是雅各在巴旦．亞蘭所生的兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","雅各來到基列．亞巴的幔利他父親以撒那裡，基列．亞巴就是希伯崙，是亞伯拉罕和以撒寄居過的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","以撒一生的年日共一百八十歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","以撒年紀老邁，享盡天年，就氣絕而死，歸到他的親族那裡去了；他兒子以掃和雅各把他葬了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","以下是以掃的後代（以掃就是以東）： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","以掃娶了迦南的女子為妻，就是赫人以倫的女兒亞大，和希未人祭便的孫女，亞拿的女兒阿何利巴瑪； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","又娶了以實瑪利的女兒、尼拜約的妹妹巴實抹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","亞大給以掃生了以利法；巴實抹生了流珥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","阿何利巴瑪生了耶烏施、雅蘭和可拉。這些都是以掃的兒子，是在迦南地生的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","以掃帶著他的眾妻子、兒女和家中所有的人，以及他的牲畜、所有的牲口和他在迦南地所得的一切財產，離開他的弟弟雅各到別的地方去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","因為他們都有很多財物，所以不能住在一起；又因他們牲畜很多的緣故，他們寄居的地方也容不下他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","於是，以掃住在西珥山上。以掃就是以東。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","以下是西珥山以東人的始祖以掃的後代： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","這些是以掃眾子的名稱：以利法是以掃的妻子亞大的兒子，流珥是以掃的妻子巴實抹的兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","以利法的兒子是提幔、阿抹、洗玻、迦坦和基納斯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","亭納是以掃的兒子以利法的妾；她給以利法生了亞瑪力。以上這些人是以掃的妻子亞大的子孫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","流珥的兒子是拿哈、謝拉、沙瑪和米撒。這些人是以掃的妻子巴實抹的子孫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","以下是祭便的孫女、亞拿的女兒、以掃的妻子阿何利巴瑪的兒子：她給以掃生了耶烏施、雅蘭和可拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","以下是以掃子孫中的族長：以掃的長子以利法的子孫中，有提幔族長、阿抹族長、洗玻族長、基納斯族長、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","可拉族長、迦坦族長、亞瑪力族長。這些人是以東地以利法的族長，都是亞大的子孫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","以掃的兒子流珥的子孫中，有拿哈族長、謝拉族長、沙瑪族長和米撒族長。這些人是以東地流珥的族長，都是以掃的妻子巴實抹的子孫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","以掃的妻子阿何利巴瑪的子孫中，有耶烏施族長、雅蘭族長和可拉族長。這些人是亞拿的女兒、以掃的妻子阿何利巴瑪的族長。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","以上這些人就是以掃的子孫和他們的族長。以掃就是以東。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","以下是那地原有的居民，何利人西珥的兒子：羅坍、朔巴、祭便、亞拿、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","底順、以察和底珊。這些人是以東地何利人西珥子孫中的族長。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","羅坍的兒子是何利和希幔；羅坍的妹妹是亭納。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","朔巴的兒子是亞勒文、瑪拿轄、以巴錄、示玻和阿南。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","祭便的兒子是亞雅和亞拿。當年在曠野牧放他父親祭便的驢，發現了溫泉的，就是亞拿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","亞拿的兒子是底順；亞拿的女兒是阿何利巴瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","底順的兒子是欣但、伊是班、益蘭和基蘭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","以察的兒子是辟罕、撒番和亞干。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","底珊的兒子是烏斯和亞蘭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","以下是何利人的族長：羅坍族長、朔巴族長、祭便族長、亞拿族長、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","底順族長、以察族長、底珊族長。這些都是何利人的族長，在西珥地按著他們的宗族作族長的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","以色列人還沒有君王統治之前，在以東地作王的記在下面： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","比珥的兒子比拉在以東作王，他的京城名叫亭哈巴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","比拉死後，波斯拉人謝拉的兒子約巴接替他作王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","約巴死後，從提幔地來的戶珊接替他作王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","戶珊死後，比達的兒子哈達接替他作王；這哈達就是在摩押原野上擊敗了米甸人的；他的京城名叫亞未得。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","哈達死後，瑪士利加人桑拉接替他作王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","桑拉死後，大河邊的利河伯人掃羅接替他作王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","掃羅死後，亞革波的兒子巴勒．哈南接替他作王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","亞革波的兒子巴勒．哈南死後，哈達接替他作王；他的京城名叫巴烏；他的妻子名叫米希他別，是米．薩合的孫女、瑪特列的女兒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","以下是以掃所出族長的名字（他們是按著自己的家族和住處命名的）：亭納族長、亞勒瓦族長、耶帖族長、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","阿何利巴瑪族長、以拉族長、比嫩族長、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","基納斯族長、提幔族長、米比薩族長、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","瑪基疊族長和以蘭族長。這些都是以東人的族長，在所得作為產業的地上，按著他們的住處作族長。以東的始祖就是以掃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","雅各住在他父親寄居的地方，就是迦南地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","雅各的歷史記在下面：約瑟十七歲的時候，與他的哥哥們一同牧羊。他是個孩童，與他父親的妾，辟拉和悉帕的眾子，常在一起。約瑟把他們的惡行報告給父親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","以色列愛約瑟過於愛其他的兒子，因為約瑟是他年老時生的。他給約瑟做了一件彩色長衣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","約瑟的哥哥們見父親愛約瑟過於愛他們，就恨約瑟，不能與他和和氣氣地說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","約瑟作了一個夢，把夢告訴哥哥們，他們就越發恨他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","約瑟對他們說：“請聽我所作的這個夢： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","我們正在田間捆麥子，我的麥捆忽然站立起來，你們的麥捆都來圍著我的下拜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","他的哥哥們對他說：“你真的要作我們的王嗎？真的要管轄我們嗎？”他們就為了約瑟的夢和他的話，越發恨他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","後來約瑟又作了一個夢，也把夢向哥哥們述說了。他說：“我又作了一個夢，我夢見太陽、月亮和十一顆星向我下拜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","約瑟把夢向他父親和哥哥們述說了，他父親就斥責他，說：“你所作的這夢是甚麼夢呢？我和你母親，以及你的兄弟，真的要來俯伏在地向你下拜嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","他哥哥們都嫉妒他，他父親卻把這事記在心裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","約瑟的哥哥們去了示劍，牧放他們父親的羊群。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","以色列對約瑟說：“你的哥哥們不是在示劍牧放羊群嗎？來吧，我要派你到他們那裡去。”約瑟回答他：“我在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","以色列對他說：“你去看看你的哥哥們是不是平安，羊群是不是平安，就回來告訴我。”於是打發他離開希伯崙谷，他就到示劍去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","有人遇見約瑟在田間迷了路，就問他說：“你找甚麼？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","他回答：“我正在找我的哥哥們，請你告訴我他們在哪裡牧放羊群。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","那人說：“他們已經離開了這裡；我聽見他們說：‘我們要到多坍去。’”於是約瑟去追尋哥哥們，結果在多坍找到了他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","他們遠遠就看見了他；趁他還沒有走近，大家就謀害他，要把他殺死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","他們彼此說：“看哪，那作夢的人來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","來吧，我們把他殺了，丟在一個枯井裡，就說有猛獸把他吃了。我們要看看他的夢將來要怎麼樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","流本聽見了，要救約瑟脫離他們的手。他說：“我們不可取他的性命。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","流本又對他們說：“不可流他的血，可以把他丟在這曠野的枯井裡，不可下手害他。”流本的意思是要救他脫離他們的手，把他帶回去給他的父親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","約瑟到了哥哥們那裡，他們就脫去他的外衣，就是他穿在身上的那件彩衣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","他們拿住約瑟，把他丟在枯井裡。那井是空的，裡面沒有水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","他們坐下吃飯，舉目觀看，見有一群以實瑪利人從基列來。他們的駱駝載著香料、乳香和沒藥，要帶下埃及去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","猶大對他的眾兄弟說：“我們殺了我們的兄弟，把他的血隱藏起來，究竟有甚麼益處呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","我們不如把他賣給以實瑪利人，不要下手害他，因為他是我們的兄弟，我們的骨肉。”眾兄弟就聽從了他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","有些米甸的商人經過那裡，約瑟的哥哥們就把約瑟從枯井裡拉上來，以二十塊銀子把他賣給以實瑪利人。以實瑪利人就把約瑟帶到埃及去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","流本回到枯井那裡，見約瑟不在井裡，就撕裂自己的衣服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","他回到兄弟們那裡去，說：“孩子不見了，我可到哪裡去呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","於是，他們宰了一隻公山羊，把約瑟的長衣蘸在血裡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","然後打發人把彩衣送到他們父親那裡，說：“這是我們找到的。請你認一認，是你兒子的長衣不是？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","他認出這件長衣，就說：“是我兒子的長衣，有猛獸把他吃了。約瑟真的被撕碎了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","雅各就撕裂自己的衣服，腰束麻布，為他兒子哀悼了很多日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","他所有的兒女都起來安慰他，他卻不肯接受他們的安慰，說：“我要悲悲哀哀地下到陰間，到我的兒子那裡去。”約瑟的父親就為他哀哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","米甸人後來把約瑟賣到埃及去，賣給法老的一個臣宰，軍長波提乏。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","那時，猶大離開他的眾兄弟下去，到一個亞杜蘭人的家裡居住，那人名叫希拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","猶大在那裡看見迦南人書亞的女兒，就娶了她，與她親近。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","她就懷了孕，生了一個兒子，猶大給他起名叫珥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","她又懷孕，生了一個兒子，給他起名叫俄南。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","她再懷孕，又生了一個兒子，就給他起名叫示拉。她生示拉的時候，猶大正在基悉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","猶大為自己的長子珥娶妻，名叫他瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","猶大的長子珥，在耶和華眼中是個惡人，所以耶和華取去他的性命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","於是猶大對俄南說：“你去與你哥哥的妻子親近，向她盡你作弟弟的本分，替你的哥哥立後。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","俄南知道生下來的孩子不會歸自己，所以每次與哥哥的妻子親近的時候，都遺精在地上，免得替自己的哥哥立後。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","俄南所作的，在耶和華眼中是件惡事，所以耶和華也取去他的性命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","於是，猶大對他的媳婦他瑪說：“你回到你父親家裡去守寡，等我的兒子示拉長大。”因為他心裡想：“恐怕示拉也像他兩個哥哥一樣死去。”他瑪就回去，住在她父親的家裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","過了很多日子，猶大的妻子，書亞的女兒死了。守喪的時間過了以後，猶大就和他的朋友亞杜蘭人希拉上亭拿去，到替他羊群剪毛的人那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","有人告訴他瑪說：“你的公公現在上亭拿去剪羊毛。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","他瑪見示拉已經長大了，還沒有娶她為妻，就脫去守寡的衣服，用帕子蒙臉，遮蔽自己，坐在亭拿路上，伊拿印的城門口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","猶大看見她，以為她是個妓女，因為她蒙著臉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","猶大就過到她那邊去，說：“來吧，讓我與你親近。”原來他不知道她就是自己的媳婦。他瑪說：“你與我親近要給我甚麼呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","猶大說：“我從羊群中拿一隻小山羊送給你。”他瑪說：“在你沒有送來以前，你可以留些東西作為保證嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","猶大問：“你要我給你甚麼作保證呢？”他瑪回答：“你的印戒，連同印的帶子，以及你手裡的杖。”猶大就給了她，與她親近，她就從猶大懷了孕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","他瑪起來走了，脫去帕子，再穿上守寡的衣服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","猶大託自己的朋友亞杜蘭人，把一隻小山羊送去，要從那女人手中取回保證物，卻找不著她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","希拉問那地方的人說：“伊拿印路旁的妓女在哪裡呢？”他們回答：“這裡是沒有妓女的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","那人回去見猶大，說：“我找不著她，並且那地的人都說：‘這裡是沒有妓女的。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","猶大說：“那些東西任她拿去吧，免得我們被人嗤笑。我已經把這小山羊送了去，可是你找不著她。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","大約過了三個月，有人告訴猶大說：“你的媳婦他瑪作了妓女，並且因此懷了孕。”猶大說：“把她拉出來，燒死她。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","他瑪被拉出來的時候，派人去見她的公公說：“這些東西是誰的，我就是從誰懷了孕。”她又說：“請你認一認，這印戒、印的帶子和手杖是誰的？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","猶大認出那些東西，就說：“她比我更有理，因為我沒有把她給我的兒子示拉為妻。”從此猶大就不再與她親近了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","到了他瑪將要生產的時候，腹中竟是一對雙胎。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","她正在生產的時候，一個孩子伸出一隻手來。接生婆拿了一根朱紅線，繫在他的手上，說：“這一個是先出生的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","他把手收回去的時候，他的哥哥就出來了。接生婆說：“你為甚麼搶著出來呢？”因此，給他起名叫法勒斯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","接著，手上繫著一根朱紅線的弟弟也出來了。因此，給他起名叫謝拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","約瑟被帶下埃及去了。有一個埃及人，是法老的臣宰，軍長波提乏，從那些帶約瑟下來的以實瑪利人手裡買了他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","耶和華與約瑟同在，約瑟就事事順利，住在他主人埃及人的家裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","他的主人見耶和華與他同在，又見耶和華使他手裡所作的盡都順利， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","約瑟就得主人的歡心，服事他的主人。他主人指派他管理他的家，把自己所有的一切都交在他手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","自從主人指派約瑟管理他的家，和他所有的一切，耶和華就因約瑟的緣故，賜福給那埃及人的家。他家裡和田間所有的一切，都蒙耶和華賜福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","波提乏把自己所有的一切，都交在約瑟的手裡。除了自己所吃的飯以外，其他的事他一概不管。約瑟生來體格壯健，容貌俊美。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","這些事以後，約瑟主人的妻子以目傳情給約瑟，說：“與我同睡吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","約瑟不肯，對他主人的妻子說：“你看，家中的事我主人一概不管；他把他所有的一切，都交在我的手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","在這家裡沒有比我大的。除你以外，我主人沒有留下一樣不交給我，因為你是他的妻子。我怎可以作這極惡的事，得罪　神呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","她雖然天天對約瑟這樣說，約瑟卻不聽從她，不肯與她同睡，也不與她在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","有一天，約瑟到屋裡辦事，家裡的人沒有一個在屋裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","婦人就抓住約瑟的衣服，說：“與我同睡吧。”約瑟把自己的衣服留在婦人的手裡，跑到外面去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","婦人見約瑟把衣服留在她手裡，跑到外面去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","就把家裡的人都叫了來，對他們說：“你們看，我丈夫帶回家來的希伯來人想調戲我。他進到我這裡來，要與我同睡，我就大聲呼叫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","他一聽見我高聲呼叫，就把衣服留在我身邊，跑到外面去了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","婦人把約瑟的衣服放在她身邊，等她的主人回家。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","她又用同樣的話對他說：“你帶回家來的希伯來人，竟進到這裡來，要調戲我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","我高聲呼叫，他就把衣服留在我身邊，跑到外面去了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","約瑟的主人聽了他妻子對他所說的話，說：“你的僕人就是這樣對待我。”他就非常生氣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","於是，約瑟的主人拿住約瑟，把他關在監裡，就是王的囚犯被監禁的地方；約瑟就在那裡坐監。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","但是，耶和華與約瑟同在，向他施慈愛，使他得到監獄長的歡心。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","因此，監獄長把監裡所有的囚犯都交在約瑟手裡；他們在那裡所作的一切事務，都由約瑟負責處理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","凡交在約瑟手裡的事務，監獄長一概不聞不問；因為耶和華與約瑟同在，使他所作的盡都順利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","這些事以後，埃及王的酒政和膳長，得罪了他們的主人埃及王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","法老就惱怒酒政和膳長這兩個臣宰， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","把他們關在軍長府內的監房裡，就是約瑟被囚禁的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","軍長把他們交給約瑟，約瑟就侍候他們。他們在監房裡過了好些日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","他們二人，就是被關在監裡的埃及王的酒政和膳長，同一夜各作了一個夢，二人的夢各有不同的解釋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","到了早晨，約瑟進去到他們那裡，見他們神色不安， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","就問法老的兩個臣宰，就是與他一同關在他主人府內的監房裡的，說：“今天你們的臉色為甚麼這樣難看呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","他們回答他：“我們各人作了一個夢，但沒有人能夠解釋。”約瑟對他們說：“解夢不是出於　神嗎？請把夢告訴我吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","酒政就把自己的夢告訴約瑟，對他說：“在夢裡我看見我面前有一棵葡萄樹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","葡萄樹上有三根枝子；樹一發芽，就開了花，上頭的葡萄都成熟了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","法老的杯在我手裡，我拿了葡萄擠在法老的杯中，把杯遞在法老的手裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","約瑟對他說：“這夢的解釋是這樣：三根枝子就是三天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","三天之內，法老必使你抬起頭來，恢復你原來的職位；你仍要把杯遞在法老的手裡，好像先前作他的酒政時一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","不過，你一切順利的時候，求你記念我，施恩給我，在法老面前提拔我，救我脫離這監獄。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","我實在是從希伯來人之地被拐來；就是在這裡，我也沒有作過甚麼事該被關在監牢裡的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","膳長見夢解得好，就對約瑟說：“我也作了一個夢，在夢裡我看見自己頭上有三籃白餅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","最上面的籃子裡，有為法老烤的各種食物，但飛鳥來吃我頭上籃子裡的食物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","約瑟回答：“這夢的解釋是這樣：三個籃子就是三天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","三天之內，法老必砍下你的頭來，把你掛在木頭上，必有飛鳥來吃你身上的肉。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","到了第三日，就是法老的生日，他為臣僕擺設筵席，在他們面前把酒政和膳長提出監來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","恢復了酒政原來的職位，叫他可以把杯遞在法老的手中； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","法老卻把膳長掛起來，正如約瑟給他們的解釋一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","但是酒政並不記念約瑟，竟把他忘記了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","過了兩年，法老作了一個夢，夢見自己站在河邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","有七頭母牛從河裡上來，又健美又肥壯，在蘆葦中吃草。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","接著，又有另外七頭母牛從河裡上來，又醜陋又瘦弱，站在岸上其他母牛旁邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","這些醜陋瘦弱的母牛，竟把那些健美肥壯的母牛吃掉，法老就醒了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","他又睡著，作了第二個夢，夢見一根麥莖，長出七個麥穗，又肥壯又美好。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","接著，又長出七個麥穗，又乾瘦又被東風吹焦了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","這些乾瘦的麥穗，竟把那七個又肥壯又飽滿的麥穗吞下去，法老就醒了，原來是一個夢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","到了早晨，法老心裡煩亂，就派人去把埃及所有的術士和智慧人都召了來；法老把自己的夢告訴他們，但是沒有人能替法老解夢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","那時酒政告訴法老說：“我今日想起了我的過錯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","從前法老惱怒臣僕，把我和膳長關在軍長府的監房裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","我們二人在同一夜都作了夢；我們的夢各有不同的解釋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","在那裡有一個希伯來的少年人與我們在一起，他是軍長的僕人，我們把夢告訴了他，他就替我們解夢，各人的夢有不同的解釋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","結果，事情都照著他給我們的解釋實現了：我恢復了原職，膳長卻被掛起來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","法老於是派人去召約瑟。他們就急忙把約瑟從監裡帶出來。他剃了頭、刮了臉、換了衣服，就進去見法老。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","法老對約瑟說：“我作了一個夢，沒有人能夠解釋。我聽見人說，你聽了夢，就能解釋。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","約瑟回答法老，說：“解夢不在於我，但　神必給法老一個吉祥的解答。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","法老告訴約瑟：“在夢裡我看見我站在河邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","有七頭母牛從河裡上來，又肥壯又健美，在蘆葦中吃草。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","接著，又有另外七頭母牛上來，又軟弱又消瘦又十分醜陋，在埃及全地我沒有見過這樣醜陋的牛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","這又消瘦又醜陋的母牛，竟把先前七頭肥壯的母牛吃掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","牠們吃了以後，卻看不出牠們是吃掉了肥牛，因為牠們醜陋的樣子仍是與先前一樣。我就醒了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","在夢裡我又看見一根麥莖，長出七個麥穗，又飽滿又美好。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","接著，又長出了七個麥穗，又枯乾又乾瘦又被東風吹焦了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","這些乾瘦的麥穗，竟把那七個美好的麥穗吞下去。我把夢告訴了術士，但是沒有人能替我解答。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","約瑟對法老說：“法老的夢都是同一個意思，　神已經把所要作的事告訴法老了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","七頭美好的母牛是七年，七個美好的麥穗也是七年；兩個夢都是同一個意思。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","那接著上來的七頭又消瘦又醜陋的母牛是七年，那七個不結實、被東風吹焦了的麥穗也是七年，都是七年饑荒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","這就是我對法老所說：　神要作的事，他已經向法老顯明了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","看哪，埃及全地必有七年大豐收。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","接著又必有七年饑荒；甚至埃及地所有的豐收都被人忘記了，饑荒必把這地毀滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","因為接著而來的饑荒太嚴重了，使人不覺得這地有過豐收。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","至於法老兩次作夢，是因為　神已經命定這事，並且要快快地實行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","因此，法老要找一個有見識有智慧的人，派他管理埃及地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","法老要這樣行，在國中指派官員，當七年豐收的時候，徵收埃及地出產的五分之一。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","又叫他們把將要來的七個豐年的糧食收集起來，積蓄五穀歸在法老的手下，收在各城裡作糧食。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","這些糧食要儲存起來，可以應付將來埃及地的七年饑荒，免得這地被饑荒所滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","法老和他的臣僕，都贊同這件事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","於是法老對臣僕說：“像這樣的人，有　神的靈在他裡面，我們怎能找得著呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","法老對約瑟說：“　神既然把這事指示了你，就再沒有人像你這樣有見識有智慧了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","你可以掌管我的家，我的人民都要聽從你的話；只有在王位上我比你大。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","法老又對約瑟說：“你看，我任命你治理埃及全地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","於是，法老脫下他手上打印的戒指，戴在約瑟的手上；給他穿上細麻的衣服，把金頸鍊掛在他的頸項上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","又叫約瑟坐在他的副車，有人在他前面喊著：“跪下。”這樣，法老任命了約瑟治理埃及全地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","法老對約瑟說：“我是法老，但在埃及全地，如果沒有你的許可，沒有人可以隨意作事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","法老給約瑟起名叫撒發那忒．巴內亞，又把安城的祭司波提非拉的女兒亞西納，給約瑟為妻。約瑟出去巡行埃及全地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","約瑟侍立在埃及王法老面前的時候，年三十歲。約瑟從法老面前出來，遍行埃及全地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","在七個豐年的時候，地裡的出產非常豐盛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","約瑟把埃及七個豐年的一切糧食都收集起來，把糧食存放在城中；各城周圍田地所出的糧食，也存放在各城中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","約瑟積蓄了極多的五穀，好像海沙那樣多，甚至他不再記下數量，因為實在無法計算。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","在荒年還沒有來到以前，約瑟生了兩個兒子，是安城的祭司波提非拉的女兒亞西納給約瑟生的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","約瑟給長子起名叫瑪拿西，因為他說：“　神使我忘記我所有的困苦，以及我父的全家。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","他給次子起名叫以法蓮，因為他說：“　神使我在受苦之地繁盛起來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","埃及地的七年豐收一結束， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","七年饑荒就隨著來了，正像約瑟所說的一樣。各地都有饑荒，只有埃及全地仍有糧食， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","等到埃及全地也要挨餓的時候，人民就向法老求糧。法老對所有的埃及人說：“你們到約瑟那裡去，他吩咐你們甚麼，你們就作甚麼。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","當時饑荒遍及全國，約瑟就開了所有的糧倉，把糧食賣給埃及人，因為埃及地的饑荒非常嚴重。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","各地的人都到埃及去，向約瑟買糧，因為各地的饑荒都非常嚴重。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","雅各見埃及有糧食，就對兒子們說：“你們為甚麼彼此對望呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","他又說：“我聽說埃及有糧食，你們下到那裡去，給我們買些糧食，使我們可以活下去，不至餓死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","於是，約瑟的十個哥哥就下去了，要從埃及買五穀。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","但雅各並沒有打發約瑟的弟弟便雅憫與哥哥們同去，因為雅各說：“恐怕他會遇到災害。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","以色列的眾子也在前來買糧的人群中，因為迦南地也有饑荒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","當時治理埃及地的官長是約瑟，賣糧給那地所有的人民的就是他。所以，約瑟的哥哥們來俯伏在地向他下拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","約瑟看見他的哥哥們，就認得他們，可是他裝作陌生人，對他們說嚴厲的話，問他們：“你們是哪裡來的？”他們回答：“我們是迦南地來買糧食的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","約瑟認得他的哥哥們，他們卻不認得他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","約瑟想起從前所作關於他們的兩個夢，就對他們說：“你們是間諜，是來偵察本地的虛實。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","他們對他說：“我主啊，不是這樣，僕人們實在是來買糧食的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","我們都是一個人的兒子，是誠實人；僕人們並不是間諜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","約瑟對他們說：“不是的，你們實在是來偵察本地的虛實。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","他們說：“僕人們本是兄弟十二人，我們都是迦南地一個人的兒子。最小的現在與我們的父親在一起，還有一個不在了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","約瑟對他們說：“我剛才對你們說：‘你們是間諜。’這話實在不錯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","我要這樣試試你們：我指著法老的性命起誓，如果你們最小的弟弟不到這裡來，你們就決不得離開這裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","你們可以派你們中間一個人回去，把你們的弟弟帶來；其餘的人都要囚禁起來，好證明你們的話真實不真實。如果不真實，我指著法老的性命起誓，你們就是間諜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","於是，約瑟把他們收在監房裡三天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","到了第三天，約瑟對他們說：“我是敬畏　神的，你們要這樣作，就可以活著； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","如果你們是誠實人，就叫你們兄弟中一個人囚禁在監裡，你們其餘的人可以帶著糧食回去，解救你們家人的饑荒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","然後把你們最小的弟弟帶到我這裡來，這樣，就可以證明你們的話是真實的，你們就不必死了。”他們就照樣作了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","他們彼此說：“我們在對待弟弟的事上實在有罪。他向我們求情的時候，我們看見他心裡的痛苦，卻不肯聽他，所以這次苦難臨到我們身上了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","流本回答他們，說：“我不是對你們說過：‘不要傷害那孩子’嗎？可是你們不肯聽，現在流他血的罪要向我們追討。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","他們不知道約瑟聽得明白，因為他們中間有人當傳譯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","約瑟轉身離開他們，哭了一陣，又回到他們那裡，與他們說話。然後從他們中間拉出西緬來，在他們眼前把他捆綁起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","約瑟吩咐人把五穀裝滿他們的袋，把他們的銀子放回各人的布袋裡；又給他們路上用的食物。一切就照樣辦了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","他們把糧食馱在他們的驢上，離開那裡去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","到了住宿的地方，他們其中的一個人打開了布袋，要拿飼料餵驢的時候，才發現自己的銀子還在袋口那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","於是對兄弟們說：“我的銀子都歸還了。你們看，就在我的布袋裡。”他們就心裡驚慌，彼此戰戰兢兢地說：“　神向我們作的是甚麼呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","他們回到迦南地他們的父親雅各那裡，把他們遭遇的一切事都告訴了他，說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“那地的主人對我們說了一些嚴厲的話，把我們當作偵察那地的間諜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","我們對他說：‘我們是誠實人，並不是間諜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","我們本是兄弟十二人，都是一個父親的兒子；有一個不在了，最小的現在與我們的父親一起在迦南地。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","那地的主人對我們說：‘我用這個辦法就可以知道你們是不是誠實人：你們兄弟中要留下一人在我這裡，其餘的人可以帶著糧食回去，解救你們家人的饑荒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","然後把你們最小的弟弟帶到我這裡來，我就知道你們不是間諜，而是誠實人了。這樣，我就把你們的兄弟交還給你們，你們也可以在這地自由來往。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","後來他們倒布袋的時候，不料各人的銀包仍然在各人的布袋裡。他們和他們的父親看見了銀包，就都懼怕起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","他們的父親雅各對他們說：“你們總是使我喪失兒子：約瑟沒有了，西緬也沒有了，你們還要把便雅憫帶走；每一件事都是針對我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","流本對他父親說：“如果我不把他帶回來給你，你可以殺死我的兩個兒子；只管把他交給我吧，我必把他帶回來給你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","雅各說：“我的兒子不可與你們一同下去，因為他的哥哥死了，只剩下他一個；如果他在你們所走的路上遇到不幸，你們就使我這白髮老人愁愁苦苦地下陰間去了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","那地的饑荒十分嚴重。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","他們把從埃及帶回來的糧食都吃完了。他們的父親就對他們說：“你們再去替我們買些糧食回來吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","猶大對他說：“那人認真地警告我們說：‘如果你們的弟弟不與你們一起來，你們就不得見我的面。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","如果你讓我們的弟弟與我們同去，我們就下去替你買糧食。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","如果你不讓他去，我們也不下去，因為那人對我們說：‘如果你們的弟弟不與你們一起來，你們就不得見我的面。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","以色列說：“你們為甚麼這樣害我，告訴那人你們還有個弟弟呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","他們回答：“那人確實查問有關我們和我們親屬的事，說：‘你們的父親還活著嗎？你們還有其他的兄弟嗎？’我們就照著這些話回答他。我們怎麼知道他會說：‘你們必要把你們的弟弟帶下來’呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","猶大對他父親以色列說：“你若打發那孩子與我同去，我們就立刻起程，好叫我們和你，以及我們的孩子都可以存活，不至餓死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","我願意親自擔保他的安全，你可以從我手裡追回他。如果我不把他帶回來給你，交在你面前，我願終生承擔這罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","要不是我們耽延，現在第二次也回來了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","他們的父親以色列對他們說：“如果必須如此，你們就這樣作：你們把本地最好的出產放在袋裡，帶下去給那人作禮物，就是一點乳香、一點蜂蜜、香料、沒藥、粟子和杏仁。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","你們手裡要多帶一倍銀子，因為你們要把那放回在你們袋口裡的銀子帶回去，那可能是弄錯了的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","你們帶著你們的弟弟，起程再到那人那裡去吧。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","願全能的　神使那人憐憫你們，給你們釋放你們那個兄弟和便雅憫。至於我，如果要喪失兒子，就喪失了吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","於是，他們帶著這些禮物，手裡拿著多一倍的銀子，並且帶著便雅憫，起程下到埃及去，站在約瑟面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","約瑟見便雅憫與他們同來，就對管家說：“把這些人帶到我家裡，要宰殺牲畜，預備筵席，因為在正午的時候，這些人要與我一起吃飯。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","管家就照著約瑟所吩咐的去作，把這些人帶到約瑟的家裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","他們因為被領到約瑟的家裡，就害怕起來，說：“我們被領到這裡來，必定是為了頭一次放回在我們袋裡的銀子，現在他們想攻擊我們，制伏我們，逼我們作奴僕，又奪去我們的驢。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","他們於是走近約瑟的管家，在屋門口與他說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","他們說：“先生啊，我們頭一次下來，實在是要買糧食的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","後來我們來到住宿的地方，打開布袋的時候，不料各人的銀子仍然在各人的袋口裡，分文不少；現在我們手裡又帶回來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","我們手裡又另外帶來銀子，是買糧食用的。我們不知道頭一次誰把我們的銀子放在我們的布袋裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","管家說：“你們可以放心，不要害怕，是你們的　神，你們父親的　神，把財寶賜給你們，放在你們的布袋裡。你們的銀子我早已收到了。”接著他把西緬帶出來交給他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","管家把他們領到約瑟的家裡，給他們水洗腳，又給他們飼料餵驢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","於是，他們預備好了禮物，等候約瑟中午到來，因為他們聽說他們要在那裡吃飯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","約瑟回到家裡，他們就把手中的禮物帶進屋裡送給他，又俯伏在地向他下拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","約瑟先向他們問安，然後又問：“你們的父親，就是你們所說的那老人家平安嗎？他還在嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","他們回答：“你僕人我們的父親平安，他還在。”於是他們低頭下拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","約瑟舉目觀看，看見自己同母所生的弟弟便雅憫，就問：“這就是你們向我提過那最小的弟弟嗎？”又說：“我兒啊，願　神賜恩給你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","約瑟愛弟弟之情激動起來，就急忙去找個可哭的地方。於是他進了自己的內室，在那裡哭了一陣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","他洗了面，然後出來，抑制著自己的感情，吩咐人說：“開飯吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","他們就給約瑟單獨擺了一席，給那些人另外擺了一席，又給那些與約瑟一同吃飯的埃及人擺了一席，因為埃及人不能與希伯來人一同吃飯，這是埃及人所厭惡的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","約瑟使眾兄弟在他面前排列坐下，都是照著他們長幼的次序。眾兄弟就彼此對望，驚奇不已。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","約瑟拿起自己面前的食物，分給他們，但是便雅憫分得的食物，比別人多五倍。他們就與約瑟一同喝酒宴樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","約瑟吩咐管家說：“把糧食裝滿這些人的布袋，要盡他們所能攜帶的，又把各人的銀子放在他們的袋口； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","把我的銀杯，放在最小的袋口，連同他買糧食的銀子放進去。”管家就照著約瑟吩咐的話去作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","早晨天一亮，那些人和他們的驢子都被打發走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","他們出了城，走了不遠，約瑟就對管家說：“起來，追趕那些人；追上了，就對他們說：‘你為甚麼以惡報善呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","這不是我主人喝酒和占卜用的杯嗎？你們所作的，實在不對。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","管家追上了他們，就對他們說了這些話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","他們對管家說：“我主為甚麼說這樣的話呢？你的僕人絕不會作這樣的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","你看，我們從前在袋口發現的銀子，尚且從迦南地帶來還給你，我們又怎會從你主人的家裡偷取金銀呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","在你僕人當中，無論在誰那裡搜出來，誰就要死，我們也要作我主的奴僕。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","管家說：“現在就照你們的話作吧，只是在誰那裡搜出來，誰就要作我的奴僕，其餘的人都沒有罪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","於是，他們急忙把自己的布袋卸在地上，各人打開自己的布袋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","管家就搜查，從最大的開始，查到最小的。那杯竟在便雅憫的布袋裡搜出來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","他們就撕裂自己的衣服，各人又把擔子馱在驢上，回城去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","猶大和他的兄弟來到約瑟的家裡，那時約瑟還在那裡；他們就在他面前俯伏在地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","約瑟對他們說：“你們所作的是甚麼事呢？你們不知道像我這樣的人必能占卜嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","猶大說：“我們對我主可以說甚麼呢？我們還有甚麼可說的呢？我們怎能證明自己是清白的呢？　神已經查出你僕人們的罪孽了。看哪，我們和那在他手裡搜出杯來的，都是我主的奴僕了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","約瑟說：“我絕不能這樣作。在誰的手裡搜出杯來，誰就要作我的奴僕；你們其餘的人，可以平平安安地上你們父親那裡去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","猶大走近約瑟身邊，說：“我主啊，求你容許僕人說一句話給我主聽，請不要向僕人發烈怒，因為你好像法老一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","我主曾經問僕人們說：‘你們還有父親或其他兄弟沒有？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","我們曾經回答我主：‘我們還有年老的父親和最小的弟弟，是他年老時所生的。他的哥哥死了，他母親只剩下他一個孩子，他父親非常愛他。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","你就對僕人們說：‘把他帶下來到我這裡，我要親眼看看他。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","我們對我主說：‘那孩子是不能離開他父親的；如果離開了，他父親必定死。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","你對僕人們說：‘如果你們最小的弟弟不與你們一同下來，你們就不得見我的面。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","於是，我們上到你僕人我們的父親那裡，就把我主的話告訴了他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","後來我們的父親說：‘你們再去替我們買些糧食回來吧。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","我們就說：‘我們不能下去，如果有我們最小的弟弟與我們同去，我們就下去；因為我們最小的弟弟不與我們同去，我們就不得見那人的面。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","你僕人我的父親對我們說：‘你們知道我的妻子只給我生了兩個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","一個已經離開我去了，我想他必定是被野獸撕碎了；直到現在，我也沒有見過他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","現在你們又要把這個從我面前帶去，如果他遇到不幸，你們就使我這個白髮老人，悲悲慘慘地下陰間去了。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","我父親的命與這孩子的命，是相連在一起的。現在我回到你僕人我的父親那裡，如果沒有孩子與我們在一起， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","他一見沒有孩子，就必定死；這樣，你僕人們就使你僕人我們的父親，這個白髮老人，愁愁苦苦地下陰間去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","因為僕人曾經向父親擔保這孩子的安全，說：‘如果我不把他帶回來交還給你，我就在父親面前終生承擔這罪。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","現在求你容許僕人留下，代替這孩子作我主的奴僕，讓這孩子與他的哥哥們一同上去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","因為如果孩子沒有與我同去，我怎能上去見我的父親呢？恐怕我會看見災禍臨到我父親身上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","約瑟在所有侍立在他左右的人面前，不能自制，就喊叫說：“叫各人都離開我出去。”這樣，約瑟向他的兄弟們表白自己身分的時候，沒有別人在場。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","於是他放聲大哭，埃及人聽到了；法老一家也聽聞這事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","約瑟對他的兄弟們說：“我就是約瑟，我的父親還在嗎？”他的兄弟們不能回答他，因為他們在約瑟面前都非常驚惶。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","約瑟對他的兄弟們說：“請你們上前來。”他們就上前去。他說：“我就是被你們賣到埃及的弟弟約瑟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","現在你們不要因為把我賣到這裡來，而自憂自責。這原是　神差派我在你們以先來這裡，為要保全性命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","現在這地的饑荒已經有兩年了，還有五年不能耕種，也沒有收成。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","神差派我在你們以先來這裡，為要給你們在地上留下餘種，大大施行拯救，保全你們的性命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","這樣看來，差派我到這裡來的，不是你們，而是　神。他立我作法老之父，作他全家之主，又作全埃及地的首相。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","你們要趕快上到我父親那裡去，對他說：‘你的兒子約瑟這樣說：　神立我作了全埃及的主；請你下到我這裡來，不要耽延。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","你和你的眾兒孫、牛羊，以及你一切所有的，都可以住在歌珊地，與我相近。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","我要在那裡供養你，因為還有五年的饑荒，免得你和你的家人，以及你一切所有的，都陷入窮困裡。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","看哪，你們和我弟弟便雅憫都親眼看見，是我親口對你們說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","你們也要把我在埃及的一切尊榮，和你們所看見的一切，都告訴我的父親，又要趕快把我的父親接到這裡來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","於是，約瑟伏在他弟弟便雅憫的頸項上，哭起來了；便雅憫也伏在約瑟的頸項上哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","他又與眾兄弟親嘴，擁抱著他們哭。然後，他的兄弟們就跟他說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","消息傳到法老的家裡，說：“約瑟的兄弟們來了。”法老和他的臣僕都很高興。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","法老對約瑟說：“你要對你的兄弟們說：‘你們要這樣作：使你們的牲口載滿貨物，起程到迦南地去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","把你們的父親和家人都接到我這裡來；我要把埃及地美好的產物賜給你們，你們也可以吃這地肥美的食物。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","現在我再吩咐你對他們說：‘你們要這樣作：從埃及地帶些車輛回去，用來接你們的孩子和妻子，並且把你們的父親接來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","不要顧惜你們的家具，因為埃及全地美好的產物都是你們的。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","以色列的兒子們就照樣作了。約瑟照著法老所吩咐的，給了他們一些車輛和路上用的食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","又給了他們各人一套新衣服，但是給便雅憫三千四百二十克銀子和五套衣服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","約瑟送去給他父親的，有公驢十頭，載著埃及美好的產物，以及母驢十頭，載著五穀、餅和給他父親在路上用的食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","於是，約瑟打發他的兄弟們回去，他們走的時候，約瑟對他們說：“你們在路上不要爭吵。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","他們離開埃及，上到迦南地他們父親雅各那裡去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","告訴他，說：“約瑟還在，並且作了埃及全地的首相。”雅各的心冷淡麻木，因為他不相信他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","他們就把約瑟對他們所說的一切話，都告訴了他。他們的父親雅各看見了約瑟派來接他的車輛，心才甦醒過來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","以色列說：“夠了！約瑟我的兒子還在；在我還沒有死以前，我要去看看他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","以色列帶著他所有的一切起程，到了別是巴，就向他父親以撒的　神獻祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","神在夜間的異象中對以色列說：“雅各，雅各。”雅各說：“我在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","神說：“我是　神，就是你父親的　神；你不要怕下埃及去，因為我必使你在那裡成為大國。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","我要親自與你一同下到埃及去，也必把你帶上來。約瑟要親手合上你的眼給你送終。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","雅各就從別是巴起程。以色列的眾子，用法老為雅各送來的車輛，接載他們的父親雅各，以及他們的孩子和妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","他們又帶著牲畜，和他們在迦南地所得的財物，來到埃及。這樣，雅各和他所有的子孫，都一同來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","雅各把他的眾兒子、孫子、女兒、孫女和他所有的後裔，都一同帶到埃及去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","來到埃及的以色列人，就是雅各和他的子孫，名單記在下面：雅各的長子是流本。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","流本的兒子是哈諾、法路、希斯崙和迦米。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","西緬的兒子是耶母利、雅憫、阿轄、雅斤、瑣轄和迦南女子所生的掃羅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","利未的兒子是革順、哥轄和米拉利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","猶大的兒子是珥、俄南、示拉、法勒斯和謝拉，但是珥和俄南都在迦南地死了。法勒斯的兒子是希斯倫和哈母勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","以薩迦的兒子是陀拉、普瓦、喲伯和伸崙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","西布倫的兒子是西烈、以倫和雅利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","以上這些人是利亞在巴旦．亞蘭給雅各生的兒子，另外還有女兒底拿。這些子孫一共三十三人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","迦得的兒子是洗非芸、哈基、書尼、以斯本、以利、亞羅底和亞列利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","亞設的兒子是音拿、亦施瓦、亦施韋和比利亞，還有他們的姊妹西拉。比利亞的兒子是希別和瑪結。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","以上這些人是拉班給女兒利亞作婢女的悉帕給雅各生的子孫，一共十六人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","雅各的妻子拉結，生了約瑟和便雅憫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","約瑟在埃及地生了瑪拿西和以法蓮，就是安城的祭司波提非拉的女兒亞西納給約瑟生的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","便雅憫的兒子是比拉、比結、亞實別、基拉、乃幔、以希、羅實、母平、戶平和亞勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","以上這些人是拉結給雅各生的子孫，一共十四人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","但的兒子是戶伸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","拿弗他利的兒子是雅薛、沽尼、耶色和示冷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","以上這些人是拉班給女兒拉結作婢女的辟拉給雅各生的子孫，一共七人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","所有從雅各所生、與雅各一同來到埃及的人，除了他的兒婦之外，一共六十六人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","另外還有約瑟在埃及所生的兩個兒子。雅各家來到埃及的所有成員，一共七十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","雅各派猶大先到約瑟那裡去，請約瑟指教他去歌珊的路。於是他們來到歌珊地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","約瑟預備了車，上去歌珊迎接他的父親以色列。約瑟一看見他，就伏在他的頸項上，在他的頸項上哭了很久。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","以色列對約瑟說：“這一次我看見了你的面，知道你還在，我死了也甘心。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","約瑟對他的兄弟們和他的父家說：“我要上去告訴法老，對他說：‘我在迦南地的兄弟們和我的父家，都到我這裡來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","這些人都是牧羊人，以牧養牲畜為生。他們把自己的牛羊和一切所有的，都帶來了。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","法老召見你們的時候，如果問你們：‘你們是作甚麼的？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","你們就要回答：‘僕人們從幼年直到現在，都是以牧養牲畜為生。我們和我們的祖先都是一樣。’這樣，你們就可以住在歌珊地，因為埃及人厭惡所有牧羊的人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","約瑟進去稟告法老，說：“我的父親和兄弟們，帶著他們的牛羊和他們所有的一切，都從迦南地來了，現在就在歌珊地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","約瑟從他所有的兄弟當中，挑選了五個人，把他們帶到法老面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","法老問約瑟的兄弟們說：“你們是作甚麼的？”他們回答法老：“僕人們是牧羊人，我們和我們的祖先都是一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","他們又對法老說：“我們來是要在這地寄居，因為迦南地的饑荒嚴重，你僕人們的羊群沒有草吃，所以，現在求你容許你僕人住在歌珊地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","法老對約瑟說：“你的父親和兄弟們到你這裡來了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","埃及地都在你面前，你只管叫你的父親和兄弟們住在這地最好的地方，他們可以住在歌珊地。你如果知道他們中間有能幹的人，可以派他們看管我的牲畜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","約瑟把他父親雅各帶到法老面前，雅各就給法老祝福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","法老問雅各：“你有多大年紀了？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","雅各回答法老：“我寄居在世的年日是一百三十歲。我一生的年日又少又苦，不及我祖先寄居在世的年日。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","雅各又給法老祝福，然後離開法老出去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","約瑟照著法老的吩咐安置他的父親和兄弟們，把蘭塞地，就是埃及地最好的地方，給他們作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","約瑟照著孩子的數目，用糧食供養他的父親、兄弟們，以及父親的家人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","那時，遍地都沒有糧食，因為饑荒非常嚴重。埃及地和迦南地的人，因為饑荒的緣故都餓昏了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","約瑟收集了埃及地和迦南地所有的銀子，就是眾人買糧的銀子；約瑟就把那些銀子交到法老的王宮去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","埃及地和迦南地的銀子都用盡了，埃及眾人就來到約瑟那裡，說：“銀子已用完了。求你給我們糧食吧，我們為甚麼要餓死在你面前呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","約瑟回答：“如果銀子用完了，可以把你們的牲畜給我，我就把糧食給你們，交換你們的牲畜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","於是，他們把牲畜帶到約瑟那裡，約瑟就把糧食給他們，交換他們的馬匹、羊群、牛群和驢。那一年，約瑟就用糧食交換他們所有的牲畜，來養活他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","那一年過後，第二年他們又來到約瑟那裡，對他說：“我們不向我主隱瞞，我們的銀子都用盡了，牲畜也歸了我主；在我主面前，除了我們的身體和田地以外，甚麼也沒有剩下了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","為甚麼我們和我們的田地要在你面前消滅呢？求你用糧食買我們和我們的田地，我們和田地就必為法老效勞了。又求你給我們穀種，使我們可以活著，不至死亡，田地也不至荒蕪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","於是，約瑟為法老買了埃及所有的田地，因為埃及人遭遇了嚴重的饑荒，各人都賣了自己的田地。這樣，那地就都歸法老所有。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","至於人民，約瑟把他們遷到城市裡去（“約瑟把他們遷到城市裡去”有古卷及古譯本作“使他們成了奴僕”），從埃及境內的一端，直到另一端。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","只有祭司的田地，約瑟沒有買，因為祭司有從法老所得的糧餉；他們可以吃法老所給的糧餉，所以沒有賣自己的田地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","約瑟對人民說：“看哪，我今日為法老買了你們和你們的田地。這裡有穀種給你們，你們可以種地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","到了收割的時候，你們要把五分之一給法老，其餘四分可以歸你們自己，作田裡的種子，又作你們以及你們家人和孩子的食物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","他們說：“你救了我們；願我們在我主面前得蒙喜悅，我們就作法老的奴僕。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","於是，約瑟為埃及的田地立了一個法例，直到今日還有效，就是五分之一歸給法老；只有祭司的田地不歸給法老。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","以色列人住在埃及國的歌珊地，他們在那裡置業繁殖，人數非常眾多。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","雅各在埃及地住了十七年；他一生的壽數是一百四十七歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","以色列的死期快到了，就把他兒子約瑟叫了來，對他說：“如果我在你面前蒙你喜悅，請你把手放在我的大腿底下起誓，要以慈愛和誠實對待我，不要把我埋葬在埃及。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","我與我的祖先同睡的時候，你要把我從埃及帶出去，埋葬在他們的墓地裡。”約瑟說：“我必照著你的話去作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","雅各說：“你要向我起誓。”約瑟就向他起了誓，於是以色列靠著床頭（“靠著床頭”有古譯本作“倚著杖頭”﹝參來11:21﹞）敬拜　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","這些事以後，有人對約瑟說：“你的父親病了。”約瑟就帶著兩個兒子瑪拿西和以法蓮同去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","有人告訴雅各，說：“你的兒子約瑟到你這裡來了。”以色列就勉強在床上坐起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","雅各對約瑟說：“全能的　神曾經在迦南地的路斯向我顯現，賜福給我， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","對我說：‘我必使你繁殖增多，成為一大族；我必把這地賜給你的後裔，作永遠的產業。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","我未到埃及見你之前，你在埃及地生了兩個兒子，現在他們算是我的；以法蓮和瑪拿西是我的，好像流本和西緬是我的一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","你在他們以後所生的子孫，都是你的；不過，在繼承產業的事上，他們可以歸在他們哥哥的名下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","至於我，我從巴旦回來的時候，在迦南地的路上，那裡到以法他還有一段路程，拉結就死在我身邊；我在那裡把她埋葬在以法他的路旁。以法他就是伯利恆。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","以色列看見約瑟的兒子，就問：“他們是誰？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","約瑟回答父親：“他們是我的兒子，是　神在這裡賜給我的。”以色列說：“把他們領到我這裡來，我要給他們祝福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","以色列因為年老，眼睛昏花，看不清楚。約瑟領他們到他跟前去，他就與他們親嘴，擁抱他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","以色列對約瑟說：“我想不到可以看見你的面，現在　神竟使我見到你的後裔。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","約瑟把兩個兒子從以色列膝上抱下來，自己臉伏在地下拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","約瑟領著他們兩個到以色列的跟前，以法蓮在約瑟的右邊對著以色列的左邊；瑪拿西在約瑟的左邊對著以色列的右邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","但是，以色列兩手交叉，右手按在次子以法蓮的頭上，左手按在長子瑪拿西的頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","要祝福約瑟，說：“願我祖亞伯拉罕和以撒所侍候的　神，一生牧養我直到今日的　神， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","那救我脫離一切禍患的使者，賜福給這兩個童子。願我的名，我祖亞伯拉罕和以撒的名，藉著他們得以流傳；願他們在地上生養眾多。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","約瑟見他父親把右手按在以法蓮的頭上，心裡就不高興，於是拿住他父親的手，要從以法蓮的頭上移到瑪拿西的頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","約瑟對他父親說：“爸爸啊，不是這樣，這個才是長子，請你把右手按在他的頭上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","他父親卻不肯，說：“我知道，我兒啊，我知道，他也要成為一族，也要強大；只是他弟弟比他還要強大，他的後裔要成為多族。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","那一天，以色列給他們祝福，說：“以色列人要用你的名祝福人，說：‘願　神使你像以法蓮和瑪拿西一樣。’”於是，以色列立以法蓮在瑪拿西之上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","以色列又對約瑟說：“看哪，我快要死了，但是　神必與你們同在，必領你們回到你們祖先的土地去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","現在我把從前用刀和弓，從亞摩利人手中奪過來的那塊山地賜給你，使你比眾兄弟多得一份。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","雅各把他的眾子叫來，說：“你們要聚集在一起，我要把你們日後必遇到的事告訴你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","雅各的兒子們哪，你們要一起來聽；要聽你們父親以色列的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","流本哪，你是我的長子，是我的力量，是我的初生子；你大有尊榮，權力超眾； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","但是你放縱情慾，好像水沸騰一樣，你必不能居首位；因為你上了你父親的床；上了我的榻，然後把它玷污了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","西緬和利未是兄弟；他們的刀劍是強暴的武器。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","我的靈啊，不可加入他們的陰謀；我的心啊，不可參與他們的集會，因為他們在怒中殺人，任意砍斷牛的腿筋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","他們的怒氣可咒，因為非常暴烈；他們的烈怒可詛，因為十分兇猛；我要把他們分散在雅各家；把他們散居在以色列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","猶大啊，你的兄弟們要稱讚你；你的手必壓住仇敵的頸項；你父親的眾子必向你下拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","猶大是隻小獅子；我兒啊，你獵取了食物就上到洞穴去。他屈身伏臥，好像公獅，又像母獅，誰敢驚動他呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","權杖必不離開猶大，王圭必不離他兩腳之間，直到細羅（“細羅”有古譯本作“屬他的那位”）來到，萬族都要臣服他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","猶大把自己的驢駒拴在葡萄樹旁，把自己的小驢繫在上等的葡萄樹旁；他在葡萄酒中洗淨自己的衣服，在血紅的葡萄汁中洗衣袍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","他因飲酒而雙眼發紅，他因喝奶而牙齒雪白。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","西布倫必在沿海地帶居住，他必成為船隻停泊的港口，他的邊界必伸到西頓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","以薩迦是一頭粗壯的驢，伏臥在羊圈（“羊圈”原文意思不詳，或譯：“重馱”）之間； ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","他看安居為美，他看肥地為佳，他屈肩負重，成了服苦的奴僕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","但要審判自己的人民，作以色列的一個支派。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","但要作路上的蛇，道中的毒蛇，他要咬傷馬蹄，使騎馬的人向後墜落。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","耶和華啊，我向來等候你的拯救。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","迦得必被侵略者追逼，他卻要追逼他們的腳跟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","至於亞設，他的食物必定肥美，他有美食可以供奉君王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","拿弗他利是隻得釋放的母鹿，發出優美的言語。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","約瑟是一根結果子的樹枝，是一根泉旁結果子的樹枝，他的枝條蔓延出牆外。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","弓箭手把他苦害，向他射箭敵對他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","但他的弓依然堅硬，他的手臂仍舊敏捷，這是出於雅各的大能者之手；出於以色列的牧者，以色列的磐石。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","是你父親的　神幫助你，是那全能者賜給你；他把從天上來的福，地下深淵蘊藏著的福，哺乳和生育的福，都賜給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","你父親的祝福，勝過我祖先的祝福（“勝過我祖先的祝福”有古譯本作“勝過亙古的山岡”），勝過永遠山嶺上的美物。願這些福都降在約瑟的頭上，降在兄弟中作王子的那一位頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","便雅憫是隻撕掠的豺狼，早晨吞吃他的獵物，晚上瓜分他的擄物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","這些就是以色列的十二支派；以上是他們父親對他們所說的話，是按著各人的福分給他們所祝的福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","雅各又囑咐他們，對他們說：“我快要歸到我的親族那裡去，你們要把我埋葬在赫人以弗崙田間的洞裡，與我的祖先在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","這個洞在迦南地，在幔利前面的麥比拉的田間。那地方原是亞伯拉罕向赫人以弗崙買下來作墳地的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","他們在那裡埋葬了亞伯拉罕和他的妻子撒拉；又在那裡埋葬了以撒和他的妻子利百加；我也在那裡埋葬了利亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","那塊田和田間的洞，是向赫人買來的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","雅各對他的眾子囑咐完了，就把雙腳收回床上，氣絕而死，歸到他的親族那裡去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","約瑟伏在他父親的臉上，為他哀哭，與他親嘴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","約瑟吩咐臣僕中作醫生的，用香料包殮了他的父親。他們就用香料包殮了以色列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","這事足足費了四十天，因為用香料包殮屍體是需要這樣長的時間。埃及人為他哀哭了七十天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","為他哀哭的日子過了，約瑟就對法老家裡的人說：“我若在你們面前得蒙喜悅，請你們代我稟告法老說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘我父親曾經叫我起誓，說：“看哪，我快要死了；你要把我埋葬在迦南地，在我為自己所掘的墳墓裡。”現在求你讓我上去，埋葬我的父親，之後我必定回來。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","法老說：“你可以上去，照著你父親叫你起的誓，把他埋葬。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","於是，約瑟上去埋葬他的父親。與他一同上去的，有法老所有的臣僕，法老家中的長老，和埃及地所有的長老， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","還有約瑟的全家，他的兄弟們和他父親的家人；他們把孩子和牛羊留在歌珊地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","又有車輛和馬兵與他一同上去，成了一大隊行列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","他們到了約旦河東岸的亞達禾場，就在那裡大大地哀悼痛哭。約瑟為他父親舉哀七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","住在那地的迦南人看見了亞達禾場的哀悼，就說：“這是埃及人一場非常傷痛的哀悼。”因此，在約旦河東岸的那地方名叫亞伯．麥西。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","雅各的眾子就照著父親囑咐他們的去作， ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","把雅各運到迦南地，葬在麥比拉田間的洞裡。那地方在幔利的前面，是亞伯拉罕向赫人以弗崙買下來作墳地的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","約瑟埋葬了他父親以後，就和他的眾兄弟，以及所有與他一同上去埋葬他父親的人都回埃及去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","約瑟的哥哥們看見父親死了，就說：“或者約瑟仍然會懷恨我們，要報復我們從前向他所作的一切惡事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","他們就打發人到約瑟那裡，說：“你父親未死以前曾經囑咐說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘你們要對約瑟這樣說：從前你的哥哥們惡待你，求你饒恕他們的過犯和罪惡。現在求你饒恕你父親　神之僕人的過犯。’”約瑟聽見這話就哭了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","他的哥哥們也親自來了，俯伏在他面前，說：“看哪，我們是你的奴僕。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","約瑟對他們說：“你們不要害怕，我怎能代替　神呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","從前你們有意要害我，但　神有美好的意思在其中，為要成就今日的光景，使許多人的性命得以保全。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","現在你們不要害怕，我必供養你們和你們的孩子。”於是約瑟用仁慈的話安慰他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","約瑟和他父親的家人，都住在埃及。約瑟活了一百一十歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","約瑟見到以法蓮的第三代子孫；瑪拿西的兒子瑪吉的眾子，也歸在約瑟的膝下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","約瑟對他的兄弟們說：“我快要死了，但　神必定眷顧你們，領你們從這地上到他起誓應許給亞伯拉罕、以撒、雅各之地去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","約瑟又叫以色列的子孫起誓，說：“　神必定眷顧你們，那時你們要把我的骸骨從這裡帶上去應許之地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","約瑟死了，享壽一百一十歲。人用香料把他包殮了，放在棺材裡，停在埃及。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","以色列的眾子，各人帶著家眷和雅各一同來到埃及。他們的名字是： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","流本、西緬、利未、猶大、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","以薩迦、西布倫、便雅憫、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","但、拿弗他利、迦得、亞設。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","他們全是雅各所生的，共有七十人；那時約瑟已經在埃及了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","後來，約瑟和他所有的兄弟，以及那一代的人都死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","以色列人生養繁殖眾多，人數增加，極其強盛，遍滿了那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","那時，有一位不認識約瑟的新王興起來，統治埃及。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","他對自己的人民說：“看哪，以色列民比我們眾多強盛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","來吧，我們要用巧計對付他們，恐怕他們增多起來，一旦發生戰爭，他們就與我們的仇敵聯合，攻擊我們，並且離開這地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","於是，他們指派督工管轄他們，加重他們的重擔苦害他們，他們為法老建造兩座貯貨城，就是比東和蘭塞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","但是，埃及人越苦害他們，他們就越發增多，越發繁殖。埃及人就懼怕以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","於是，埃及人嚴嚴地使以色列人作苦工。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","埃及人使他們因作苦工而覺得命苦，他們要和泥、做磚、作田間各樣的工；這一切苦工，埃及人都嚴嚴地驅使以色列人去作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","埃及王吩咐兩個希伯來接生婦，一個名叫施弗拉，一個名叫普阿， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","說：“你們給希伯來婦人接生的時候，要看著她們臨盆；若是男孩，你們要殺死他；若是女孩，她就可以活著。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","但是，接生婦卻敬畏　神，不照著埃及王吩咐她們的去作，竟讓男孩活著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","於是，埃及王把接生婦叫了來，對她們說：“你們為甚麼作這事，讓男孩活著呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","接生婦回答法老：“希伯來婦人與埃及婦人不同；她們很有活力，接生婦還沒有來到，她們已經生產了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","神恩待接生婦；以色列民增多起來，而且非常強盛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","接生婦因為敬畏　神，　神就為她們建立家室。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","法老吩咐他的眾民說：“凡是希伯來人所生的男孩，你們都要把他投在河裡；凡是女孩，就讓她活著。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","有一個利未家的人去娶了一個利未女子為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","那女人懷孕，生了一個兒子；見他俊美，就把他藏了三個月。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","直到她不能把他再藏了，就拿一個蒲草箱來，塗上瀝青和石漆；把孩子放在裡面，把箱子放在河邊的蘆葦叢中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","孩子的姊姊遠遠地站著，要知道孩子究竟怎樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","那時，法老的女兒下到河邊去洗澡；她的使女們在河邊行走；她看見了在蘆葦中的箱子，就打發自己的使女去把箱子拿過來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","她打開了，就看見那孩子；看哪，孩子哭了，她就憐憫他，說：“這是希伯來人的一個孩子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","孩子的姊姊對法老的女兒說：“我去從希伯來婦人中給你請一個奶媽來，為你乳養這個孩子可以嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","法老的女兒回答：“你去吧。”童女就去把孩子的母親請了來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","法老的女兒對她說：“你把這孩子抱去，替我乳養他，我必給你工錢。”婦人就抱了孩子去乳養他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","孩子長大了，婦人把他帶到法老的女兒那裡，他就作了法老女兒的兒子。她給孩子起名叫摩西，說：“因為我把他從水裡拉出來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","過了些日子，摩西長大了，有一次，他出去到他的同胞那裡去，看見他們的重擔，又看見一個埃及人打他的一個同胞希伯來人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","摩西左右觀望，見沒有人，就把那埃及人擊殺了，埋藏在沙土裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","第二天他又出去，看見兩個希伯來人彼此爭鬥著，就對那欺負人的說：“你為甚麼打你同族的人呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","那人回答：“誰立了你作我們的領袖和審判官呢？難道你想殺我，好像殺那個埃及人一樣嗎？”摩西就懼怕起來，心裡想：“這事必定給人知道了！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","法老聽見這事，就設法要殺摩西；摩西躲避法老，就往米甸地去居住；有一天他坐在井旁。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","米甸的祭司有七個女兒，她們來打水，打滿了水槽，要給父親的羊群喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","有些牧人來了，把她們趕走；摩西卻起來，救了她們，也給她們的羊群喝水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","她們回到父親流珥那裡，父親問：“今天你們為甚麼趕著回來呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","她們說：“有一個埃及人救我們脫離了牧羊人的手，而且還為我們打水給羊群喝。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","父親對眾女兒說：“他在哪裡？你們為甚麼撇下那人呢？去請他來吃飯。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","摩西樂意和那人同住；那人把自己的女兒西坡拉給了摩西作妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","西坡拉生了一個兒子，摩西給他起名叫革舜，因為他說：“我在異地作了客旅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","過了很久，埃及王死了。以色列人在捆鎖中歎息，他們就呼求，在捆鎖中的呼求達到　神那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","神聽見他們的呼聲，就記念他與亞伯拉罕、以撒、雅各所立的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","神看顧以色列人，也關注他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","那時，摩西正在牧放他岳父米甸祭司葉忒羅的羊群。有一次，他把羊群領到曠野的盡頭去，到了　神的山，就是何烈山。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","耶和華的使者從荊棘叢裡的火燄中向摩西顯現。摩西觀看，看見荊棘被火燒著，卻沒有燒毀。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","摩西說：“我要到那邊去，看看這大異象，這荊棘為甚麼燒不掉？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","耶和華見摩西要到那邊去觀看，　神就從荊棘叢裡呼叫他，說：“摩西，摩西。”摩西說：“我在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","耶和華說：“不可過到這裡來；要把你腳上的鞋脫掉，因為你所站的地方是聖地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","又說：“我是你父親的　神、亞伯拉罕的　神、以撒的　神、雅各的　神。”摩西因為怕見　神，就把自己的臉蒙住了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","耶和華說：“我的子民在埃及所受的痛苦，我實在看見了；他們因受督工的轄制所發的呼聲，我也聽見了；他們的痛苦，我是知道的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","所以我下來，要救他們脫離埃及人的手，領他們脫離那地，到美好寬闊之地，到流奶與蜜之地，就是到迦南人、赫人、亞摩利人、比利洗人、希未人和耶布斯人的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","現在以色列人的呼聲已經達到我的面前，我也看見了埃及人對他們所施的壓迫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","所以現在你來，我要派你到法老那裡去，使你可以把我的人民以色列人從埃及領出來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","摩西對　神說：“我是誰，竟能到法老那裡去，把以色列人從埃及領出來呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","神回答：“我必與你同在；你把人民從埃及領出來的時候，你們要在這山上事奉　神；這就是我派你去的憑據。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","摩西對　神說：“我到以色列人那裡，對他們說：‘你們祖宗的　神差遣我到你們這裡來’，他們必問我：‘他叫甚麼名字？’我要對他們說甚麼呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","神回答摩西：“我是‘自有永有者’。”又說：“你要對以色列人這樣說：‘那自有者派我到你們這裡來。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","神又對摩西說：“你要對以色列人這樣說：‘耶和華你們祖宗的　神，就是亞伯拉罕的　神、以撒的　神、雅各的　神，差遣我到你們這裡來；這就是我永久的名字，也是世世代代中我被記念的名字。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","你去召集以色列的長老，對他們說：‘耶和華你們祖宗的　神，就是亞伯拉罕的　神、以撒的　神、雅各的　神，向我顯現，說：“我實在眷顧了你們，和鑒察了你們在埃及所遭遇的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","我也曾說：“我要把你們從埃及的痛苦中領出來，到迦南人、赫人、亞摩利人、比利洗人、希未人、耶布斯人之地去，就是到流奶與蜜之地去。”’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","他們必聽你的話；你和以色列的長老要到埃及王那裡去，對他說：‘耶和華希伯來人的　神遇見了我們。現在求你讓我們走三天的路程到曠野去，好獻祭給耶和華我們的　神。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","我也知道，如果不施行大能的手，埃及王決不會讓你們走的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","因此，我要伸手，用我在埃及快要施行的一切異能，擊打埃及；然後他才會讓你們離去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","我必叫這民在埃及人的眼前蒙恩。因此你們離去的時候，就不至於空手而去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","但每個婦女要向她鄰居的婦女，和寄居在她家中的婦女索取銀器、金器和衣服，要給你們的兒女穿戴；這樣，你們就把埃及人的財物掠奪了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","摩西回答：“看哪，他們必不信我，也不聽我的話；因為他們必說：‘耶和華並沒有向你顯現。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","耶和華問摩西：“那在你手裡的是甚麼？”他說：“是手杖。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","耶和華說：“把它丟在地上。”摩西把它一丟在地上，它就變了蛇；摩西就逃跑，離開了牠。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","耶和華對摩西說：“伸出你的手來，捉住蛇的尾巴。”摩西就伸出手來，緊握著牠，牠在摩西的掌中又變回了手杖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“這樣就使他們相信耶和華他們祖宗的　神，就是亞伯拉罕的　神、以撒的　神、雅各的　神曾向你顯現了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","耶和華又再對摩西說：“現在把你的手放進懷裡。”摩西就把手放進懷裡；等他把手抽出來的時候，手就長滿了痲風，像雪那樣白。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","耶和華說：“把你的手再放進懷裡。”摩西就把手再放進懷裡；等他把手從懷裡抽出來的時候，手就恢復過來，像身上別處的肉一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","耶和華又說：“如果他們不信你，也不聽從頭一個神蹟的話，他們必信隨後來的神蹟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","如果連這兩個神蹟他們也不信，也不聽你的話，你就從河裡取些水，倒在旱地上；你從河裡取來的水就必在旱地上變成血。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","摩西對耶和華說：“主啊，我不是個會說話的人；以前不是，自從你對僕人說話以後也不是；因為我本是拙口笨舌的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","耶和華對他說：“誰造人的口呢？誰使人口啞、耳聾、眼明、眼瞎呢？不是我耶和華嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","現在去吧，我必賜你口才，指教你當說的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","摩西說：“主啊，請你差派你願意差派的人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","耶和華向摩西發怒，說：“不是有你的哥哥利未人亞倫嗎？我知道他是有口才的；他現在出來要迎接你。他看見了你，心裡就快樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","你要對他說話，把你要說的話放在他的口裡；我必與你的口同在，也與他的口同在；我必指教你們當行的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","他要替你向人民說話，他要作你的口，你要作他的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","這手杖你要拿在手裡，用來行神蹟。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","於是，摩西起程回到他岳父葉忒羅那裡，對他說：“請你容我離開這裡，回到我在埃及的同胞那裡，看看他們是否還在。”葉忒羅對摩西說：“你可以平平安安地去吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","耶和華在米甸對摩西說：“你要起程，回到埃及去，因為那些尋索你命的人都死了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","摩西就帶著他的妻子和孩子，讓他們騎在驢上，向著埃及地回去了；摩西手裡拿著　神的杖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","耶和華對摩西說：“你起程回到埃及去的時候，要留意我交在你手裡的一切奇事，把它們行在法老面前；我卻要使他的心剛硬，他就不讓人民離開。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","你要對法老說：‘耶和華這樣說：以色列是我的長子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","我曾對你說，要讓我的兒子離開這裡，好叫他事奉我。你還是拒絕讓他離開，看哪！我必殺你的長子。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","在路上住宿的地方，耶和華遇見了摩西，就想要殺他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","西坡拉就拿了一把石刀，把她兒子的包皮割下來，把它丟到摩西的腳上，說：“你真是我的血郎了！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","這樣，耶和華才放了他。那時西坡拉說：“你是血郎，是因為割禮的緣故。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","耶和華對亞倫說：“你到曠野去迎接摩西。”他就去了；他在　神的山遇見了摩西，就和他親嘴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","摩西把耶和華派他所說的一切話，和吩咐他所行的一切神蹟都告訴了亞倫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","摩西和亞倫就去召集以色列人的長老。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","亞倫把耶和華對摩西所說的一切話都說了一遍，並且在人民的眼前行了這些神蹟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","人民就相信了；他們聽見耶和華眷顧以色列人，也鑒察了他們的痛苦，就俯伏敬拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","後來，摩西和亞倫去對法老說：“耶和華以色列的　神這樣說：讓我的人民離開這裡，叫他們可以在曠野向我守節。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","法老回答：“耶和華是誰，我要聽他的話，讓以色列人離開呢？我不認識耶和華，也不讓以色列人離開。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","他們說：“希伯來人的　神遇見了我們；求你讓我們走三天的路程到曠野去，獻祭給耶和華我們的　神，免得他用瘟疫或刀劍擊殺我們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","埃及王對他們說：“摩西、亞倫哪，你們為甚麼使人民懶惰不作工呢？去挑你們的擔子吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","法老又說：“你看，現在這地的民很多，你們竟叫他們歇下擔子？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","就在那天，法老吩咐眾民的督工和首領說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“你們不要像往日一樣再把草給人民做磚，叫他們自己去撿草。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","他們往日做磚的數量，你們還是向他們要，一點也不可減少，因為他們是懶惰的，所以他們才呼喊說：‘讓我們去獻祭給我們的　神。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","你們要把更重的工作加在這些人的身上，好使他們專心作工，不聽謊言。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","眾民的督工和首領出來，告訴人民說：“法老這樣說：‘我不再給你們草。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","你們自己能在哪裡找到草，就到哪裡去撿吧，但你們的工作一點也不可減少。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","於是，人民就分散到埃及全地，去拾禾秸作草。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","督工們催著說：“你們的工作，每天的本分，要在當天完成，像以前有草的時候一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","法老的督工責打他們派定的以色列人的首領，說：“你們昨天今天為甚麼沒有做完指定要你們做的磚，像往日一樣呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","以色列人的首領就來，向法老呼求說：“你為甚麼這樣待你的僕人呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","沒有草給你的僕人，但他們對我們說：‘你們做磚吧！’看哪，你的僕人受了責打，其實這是你自己人民的錯。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","法老說：“你們確實是懶惰的，所以你們才說：‘讓我們去獻祭給耶和華。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","現在你們去作工吧；草是不給你們的，磚卻要如數交上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","以色列人的首領因有命令說：“你們每天本分要做的磚數不可減少”，就知道自己有禍了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","他們從法老那裡出來的時候，遇見摩西和亞倫，正在站著等候他們， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","就對他們說：“願耶和華鑒察你們，審判你們，因為你們使我們的香氣在法老眼前和他的臣僕眼前都發臭了，把刀放在他們的手裡來殺我們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","摩西回到耶和華那裡，說：“主啊！你為甚麼苦待這人民呢？為甚麼差派我呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","自從我到法老那裡，奉你的名說話以來，他就苦待這人民，你一點也沒有拯救你自己的人民。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","耶和華對摩西說：“你現在必看見我要向法老行的事；因為我施展大能的手，他必讓他們離去；我施展大能的手，他必把他們從自己的地趕出去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","神告訴摩西說：“我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","我曾向亞伯拉罕、以撒、雅各顯現為全能的　神，至於我的名字‘耶和華’，他們是不認識的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","我不但與他們確立了我的約，要把迦南地，就是他們作客寄居之地賜給他們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","而且我也聽見了以色列人因埃及人所加的奴役而發的哀聲，就記念我的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","所以，你要對以色列人說：‘我是耶和華，我要把你們從埃及人的重擔底下救出來；我要拯救你們脫離他們的奴役；我要用伸出來的膀臂，並藉著嚴厲的刑罰來救贖你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","我要以你們作我的人民，我也要作你們的　神；你們要知道我是耶和華你們的　神，是把你們從埃及人的重擔底下救出來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","我舉手起誓要給亞伯拉罕、以撒、雅各的地，我必領你們進去；我也必把那地賜給你們作產業；我是耶和華。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","摩西這樣告訴以色列人，只是他們因為心裡愁煩和苦工的緣故，就不肯聽摩西的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","耶和華告訴摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“你要告訴埃及王法老，叫他讓以色列人離開他的地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","摩西在耶和華面前說：“看哪，以色列人尚且不肯聽我的話，法老又怎會聽我的話呢？因為我是個拙口笨舌的人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","耶和華吩咐摩西和亞倫，命令他們到以色列人和埃及王法老那裡去，把以色列人從埃及地領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","他們各家族首領的名字記在下面：以色列的長子流本的兒子是哈諾、法路、希斯倫、迦米；這些是流本的各家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","西緬的兒子是耶母利、雅憫、阿轄、雅斤、瑣轄和迦南女子的兒子掃羅；這些是西緬的各家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","利未眾子的名字按著他們的世代記在下面，就是革順、哥轄、米拉利。利未一生的歲數是一百三十七歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","革順的兒子，按著他們的家族，是立尼、示每。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","哥轄的兒子是暗蘭、以斯哈、希伯倫、烏薛。哥轄一生的歲數是一百三十三歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","米拉利的兒子是抹利和母示。按著他們的世代，這些是利未的家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","暗蘭娶了自己的姑母約基別為妻；約基別給他生了亞倫和摩西；暗蘭一生的歲數是一百三十七歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","以斯哈的兒子是可拉、尼斐、細基利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","烏薛的兒子是米沙利、以利撒反、西提利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","亞倫娶了亞米拿達的女兒拿順的妹妹以利沙巴作妻子；她給亞倫生了拿答、亞比戶、以利亞撒、以他瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","可拉的兒子是亞惜、以利加拿、亞比亞撒；這些是可拉的各家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","亞倫的兒子以利亞撒娶了普鐵的一個女兒為妻；她給以利亞撒生了非尼哈。按照他們的家族，這些就是利未人的各首領。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","這亞倫和摩西，耶和華曾經對他們說過：“你們要按著他們的軍隊，把以色列人從埃及地領出來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","那對埃及王法老說要把以色列人從埃及領出來的，就是這摩西和亞倫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","耶和華在埃及地對摩西說話的日子， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","耶和華告訴摩西說：“我是耶和華，你要把我對你所說的一切話都告訴埃及王法老。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","摩西在耶和華面前說：“你看，我是個拙口笨舌的人，法老怎肯聽我呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","耶和華對摩西說：“看哪，我使你在法老面前好像　神一樣；你哥哥亞倫要作你的先知。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","我吩咐你的一切，你都要說；你哥哥亞倫要告訴法老，法老就讓以色列人離開他的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","我要使法老心硬，我也要在埃及地加增我的神蹟奇事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","可是法老不聽你們的話，我必下手擊打埃及；藉著嚴厲的刑罰把我的軍隊，我的人民以色列人，從埃及地領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","我向埃及伸手，把以色列人從他們中間領出來的時候，埃及人就必知道我是耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","摩西和亞倫這樣行了；耶和華怎樣吩咐摩西和亞倫，他們就照樣行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","摩西和亞倫與法老說話的時候，摩西八十歲，亞倫八十三歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","耶和華告訴摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“如果法老告訴你們說：‘你們行件奇事吧’，你就要對亞倫說：‘拿你的手杖來，把它丟在法老面前，它就會變作蛇。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","摩西和亞倫就進到法老那裡，照著耶和華吩咐他們的行了；亞倫把手杖丟在法老和法老的臣僕面前，手杖就變了蛇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","於是，法老也把智慧人和行法術的人召了來；他們本是埃及的術士，也用他們的巫術照樣行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","他們各人都丟下自己的手杖，手杖就變了蛇；亞倫的手杖卻吞了他們的手杖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","法老心裡剛硬，不肯聽他們的話，就像耶和華所說的一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","耶和華對摩西說：“法老心裡固執，拒絕讓人民離去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","明天早晨你要到法老那裡去。看哪，法老出來到水邊去的時候，你要站在河邊迎見他；那變過蛇的手杖，你要拿在手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","你要對法老說：‘耶和華希伯來人的　神差我到你這裡來，說：“讓我的人民離開這裡，好使他們可以在曠野事奉我”，你看，直到現在你還是不聽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","耶和華這樣說：“看哪，我要用我手裡的杖擊打河中的水，水就必變成血；因此你就知道我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","河中的魚必死亡，河水也必發臭，埃及人就必厭惡喝這河裡的水。”’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","耶和華對摩西說：“你要對亞倫說：‘拿你的手杖來，把你的手伸在埃及的眾水之上，就是在他們的江、河、池和所有水塘之上，使水都變成血。因此，在埃及全地，連木器石器中都必有血。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","摩西和亞倫就這樣行了，就像耶和華所吩咐的；亞倫在法老面前和法老的臣僕面前舉起手杖，擊打河裡的水，河裡的水就都變了血。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","河裡的魚死了，河水發臭了，埃及人也不能喝這河裡的水了；在埃及，全地都有血。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","埃及的術士也用他們的巫術這樣行了；可是法老卻心裡剛硬，不肯聽摩西和亞倫，就像耶和華所說的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","法老轉身回到宮裡去，也不把這事放在心上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","所有的埃及人都在河的周圍掘地，要得水喝，因為他們不能喝這河裡的水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","耶和華擊打尼羅河以後，滿了七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","耶和華對摩西說：“你到法老那裡去，對他說：‘耶和華這樣說：“讓我的人民離開這裡，使他們可以事奉我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","如果你拒絕讓他們離開這裡，看哪，我必用青蛙擊打你的全境。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","河裡必滋生青蛙；青蛙必上來，進到你的宮殿和臥房裡去，跳上你的床，進你臣僕的房屋，跳上你人民的身上，進你的爐子和摶麵盆。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","青蛙也必跳上你、你的人民和臣僕的身上。”’”（本章第1 4節在《馬索拉抄本》為7:26 29） ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","耶和華對摩西說：“你要對亞倫說把手中的杖伸在江、河、池之上，使青蛙上到埃及地來。”（本節在《馬索拉抄本》為8:1） ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","亞倫把手一伸在埃及的眾水之上，青蛙就上來了，並且遮蓋了埃及地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","眾術士也用他們的巫術照樣行了，使青蛙上了埃及地來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","法老把摩西和亞倫召了來，說：“請你們懇求耶和華，好叫他使青蛙離開我和我的人民，我就必讓這人民離開這裡，使他們可以向耶和華獻祭。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","摩西回答法老：“請指示，我要在甚麼時候為你和你的臣僕，以及你的人民，懇求耶和華除滅青蛙，使青蛙離開你和你的宮殿，只留在河裡呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","法老說：“明天。”摩西回答：“就照著你的話行吧，好叫你知道沒有神像耶和華我們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","青蛙必離開你和你的宮殿、你的臣僕和你的人民，只留在河裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","於是，摩西和亞倫離開法老走了出來；摩西為了耶和華加在法老身上青蛙的災害向耶和華呼求。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","耶和華就照著摩西的話行了；在房屋裡、院子裡和田野中的青蛙都死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","有人把青蛙一堆一堆積聚起來，那地就發臭了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","法老一見災禍平息了，就心裡剛硬，不肯聽他們的話，就像耶和華所說的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","耶和華對摩西說：“你要對亞倫說：‘伸出你的手杖，擊打地上的塵土，使塵土在埃及全地都變成虱子。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","他們就這樣行了；亞倫伸出手中的杖，擊打地上的塵土，就在人身上和牲畜身上有了虱子；埃及全地所有地上的塵土都變成了虱子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","眾術士也用他們的巫術照樣行，要生出虱子來，卻不能辦到；所以在人身上和牲畜身上都有虱子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","眾術士就對法老說：“這是　神的手指頭。”法老卻心裡剛硬，不肯聽摩西和亞倫，就像耶和華所說的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","耶和華對摩西說：“你要清早起來，站在法老面前；看哪，法老到水邊來的時候，你要對他說：‘耶和華這樣說：你要讓我的人民離開這裡，使他們可以事奉我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","如果你不讓我的人民離開這裡，看哪，我必叫蒼蠅落在你和你臣僕，以及人民的身上，進到你的宮殿；埃及人的房屋都必充滿蒼蠅，他們所在的地方也是這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","那日，我必把我人民居住的地方歌珊分別出來，使那裡沒有蒼蠅，為要使你知道在全地上只有我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","我必把我的人民和你的人民分別出來，明天必有這神蹟。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","耶和華就這樣行了；無數的蒼蠅進了法老的宮殿和他臣僕的房屋，並且遍布埃及全地；那地就因為蒼蠅的緣故毀壞了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","法老把摩西和亞倫召了來，對他們說：“你們去，在這地獻祭給你們的　神吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","摩西回答：“決不可以這樣行，因為我們要把埃及人看為可憎的祭物獻給耶和華我們的　神；如果我們把埃及人看為可憎的祭物在他們眼前獻上，難道他們不拿石頭打死我們嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","我們要走三天的路程進到曠野，好照著耶和華吩咐我們的，向耶和華我們的　神獻祭。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","法老回答：“我必讓你們離開這裡，你們可以在曠野獻祭給耶和華你們的　神，只是你們不可走得太遠；請你們為我祈禱。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","摩西說：“看哪，我要離開你出去，祈求耶和華，使蒼蠅明天可以離開法老和法老的臣僕，以及法老的人民，只是不可再行欺騙，不讓以色列人離開這裡去獻祭給耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","於是，摩西從法老那裡出來，去祈求耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","耶和華就照著摩西的話行了，使蒼蠅離開了法老和他的臣僕，以及他的人民，連一隻也沒有留下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","可是，這一次法老還是心裡剛硬，不肯讓以色列人離開。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","耶和華對摩西說：“你要到法老那裡去，對他說：‘耶和華希伯來人的　神這樣說：“讓我的人民離開這裡，使他們可以事奉我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","如果你拒絕他們離開這裡，仍然強留他們， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","看哪，耶和華的手必用嚴重的瘟疫加在你田間的牲畜身上，加在馬、驢、駱駝、牛群、羊群身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","耶和華必把以色列的牲畜和埃及人的牲畜分別出來；所有屬於以色列人的，一隻也不死去。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","耶和華就定了時候，說：“明天耶和華必在此地行這事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","第二天，耶和華就行了這事，埃及人全部的牲畜都死了；可是屬於以色列人的牲畜，一隻也沒有死去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","法老派人去看，果然看見屬於以色列人的牲畜，連一隻也沒有死去。法老的心還是剛硬，不肯讓以色列人離開。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","耶和華對摩西和亞倫說：“你們要兩手拿滿爐灰，摩西要在法老眼前把爐灰向天上揚起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","這爐灰必在埃及全地變為微塵，在埃及全地的人和牲畜身上就必生出疹病和膿瘡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","摩西和亞倫取了爐灰，站在法老面前；摩西把爐灰向天上揚起來，人和牲畜身上就生出了疹病和膿瘡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","眾術士因為生了瘡的緣故，不能站在摩西的面前；因為眾術士和所有埃及人身上都生了瘡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","耶和華使法老心裡剛硬，他就不肯聽摩西和亞倫的話，就像耶和華對摩西所說的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","耶和華對摩西說：“你要清早起來，站在法老面前，對他說：‘耶和華希伯來人的　神這樣說：“讓我的人民離開這裡，使他們可以事奉我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","因為這一次我要降下我的一切災禍，打擊你和你的臣僕及人民，為要使你知道在全地上沒有神像我的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","如果我現在伸手用瘟疫擊打你和你的人民，你就早已從地上消滅了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","然而我使你存留，是為了使你看見我的能力，並且在全地上傳講我的名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","你仍然向我的人民自高，不讓他們離開嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","看哪，明天大約這個時候，我必降下極重的冰雹，在埃及自建國以來，直到現在，未曾有過這樣的冰雹的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","所以，你現在要派人去，把你的牲畜和田間所有屬於你的，都收聚到安全的地方；因為凡在田間發現的人和牲畜而不收回家裡去的，冰雹必落在他們身上，他們就必死亡。”’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","法老的臣僕中有懼怕耶和華這話的，就叫他的僕人和牲畜進屋裡來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","但那不把耶和華這話放在心上的，卻把他的僕人和牲畜留在田裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","耶和華對摩西說：“你要向天伸杖，使埃及全地都有冰雹，落在人身上、在牲畜身上和埃及地田間所有的蔬菜上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","摩西把手杖向天一伸，耶和華就打雷（“打雷”原文作“　神的聲音”）下雹，有火落在地上；耶和華使冰雹降在埃及地上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","那時有了冰雹，冰雹與火混雜在一起，十分嚴重；埃及全地自從建國以來，未曾有過這樣的冰雹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","在埃及全地，冰雹把田間的一切，連人和牲畜都擊打了；冰雹又把田間的一切蔬菜擊打了，也把田間的一切樹木打斷了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","只有在以色列人所在的歌珊地，沒有冰雹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","於是，法老把摩西和亞倫召了來，對他們說：“這一次我犯了罪了；耶和華是公義的，我和我的人民是有罪的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","請你們祈求耶和華吧，因為這雷聲和冰雹已經夠了；我決意讓你們離開，你們不可再留在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","摩西回答法老：“我一出城，就必向耶和華伸手禱告，雷聲就必止住，也不再有冰雹了，好使你知道大地是屬於耶和華的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","至於你和你的臣僕，我知道你們在耶和華　神的面前還是沒有懼怕的心。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","那時，麻和大麥被冰雹擊打了，因為大麥已經吐穗，麻也開了花。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","只是小麥和粗麥卻沒有被擊打，因為它們還沒有長成。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","摩西離開法老出城去了，就向耶和華伸手禱告，雷聲和冰雹就止住了，雨也不再傾倒在地上了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","法老看見雨水、冰雹和雷聲都止住了，就更加犯罪，他和他的臣僕都心裡剛硬。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","法老的心剛硬，不肯讓以色列人離開，就像耶和華藉著摩西所說的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","耶和華對摩西說：“你要到法老那裡去，因為我已經使他的心和他臣僕的心剛硬，為要在他們中間顯出我這些神蹟； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","並且要你把愚弄埃及人的事，和我在他們中間顯出的神蹟，都講給你的子孫聽；使你們知道我是耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","摩西和亞倫就到法老那裡去，對他說：“耶和華希伯來人的　神這樣說：‘你拒絕在我面前謙卑要到幾時呢？讓我的人民離開吧，使他們可以事奉我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","如果你拒絕讓我的人民離開，看哪！明天我要使蝗蟲進入你的境界； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","蝗蟲必遮蓋地面，甚至人不能看見地；蝗蟲必吃盡那避過災難餘剩的，那沒有受冰雹擊打，剩下留給你們的；牠們也必吃盡田間給你們生長起來的一切樹木。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","蝗蟲必充滿了你的宮殿，你所有臣僕的房屋，和所有埃及人的房屋；這是你祖宗和你祖宗的祖宗自從在世以來，直到今日，所沒有見過的。’”摩西就轉身，離開法老出去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","法老的臣僕對法老說：“這人成為我們的網羅要到幾時呢？讓這些人離開吧，使他們可以事奉耶和華他們的　神；埃及已經毀滅了，你還不知道嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","於是，摩西和亞倫被召回來到法老那裡。法老對他們說：“你們去事奉耶和華你們的　神吧，但那些要去的是誰呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","摩西回答：“我們要和我們年少的與年老的同去，要和我們的兒女同去，也要和我們的羊群與牛群同去，因為我們必須向耶和華守節。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","法老對他們說：“我讓你們和你們的孩子離開的時候，願耶和華與你們同在；你們要謹慎，因為有禍患在你們面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","不可以這樣，只有你們的男子可以去事奉耶和華，因為這原是你們要求的。”於是把他們從法老面前趕出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","耶和華對摩西說：“你要向埃及地伸手，使蝗蟲上埃及地來，吃盡地上所有的蔬菜，就是受冰雹擊打後留下的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","摩西就向埃及地伸杖，整整的一日一夜，耶和華把東風吹在地上；到了早晨，東風把蝗蟲吹來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","蝗蟲上到埃及全地來，停留在埃及全境。牠們非常眾多，以前沒有像這樣多的蝗蟲，以後也沒有。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","蝗蟲遮蓋了整個地面，以致大地都變黑了。牠們吃盡了地上一切蔬菜，和樹上所有的果子，就是受冰雹擊打後留下來的。這樣，在埃及全地，無論是樹木，或田間的蔬菜，連一點青的也沒有留下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","於是，法老急忙把摩西和亞倫召了來，說：“我得罪了耶和華你們的　神，也得罪了你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","現在求你只這一次赦免我的罪，也請你們求告耶和華你們的　神，使這一次的死亡離開我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","摩西就離開法老出來，祈求耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","耶和華轉了非常強大的西風，把蝗蟲吹起來了，投進紅海裡；在埃及全境，連一隻蝗蟲也沒留下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","但是耶和華使法老的心剛硬，以致法老不肯讓以色列人離開。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","耶和華對摩西說：“你要向天舉手，使黑暗臨到埃及地，這黑暗是可以觸摸的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","摩西向天伸手，幽暗就臨到埃及全地三天之久。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","三天之內，人彼此不能看見，誰也不能起來離開自己的地方；但是在所有以色列人居住的地方都有亮光。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","法老就把摩西召了來，說：“你們去事奉耶和華吧，你們的孩子也可以與你們同去；只是要把你們的羊群和牛群留下來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","摩西回答：“你也要把獻祭用的祭物和燔祭交給我們，使我們可以獻給耶和華我們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","我們的牲畜也要與我們同去，連一隻也不留下；因為我們要從牠們當中取出一些來事奉耶和華我們的　神；我們沒有到達之前，還不知道要用甚麼事奉耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","但耶和華使法老心裡剛硬，因此他不願意讓他們離開。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","法老對摩西說：“你離開我去吧，你要小心，不要再見我的面；因為你再見我面的時候，你必定死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","摩西回答：“你說對了，我不再見你的面了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","耶和華對摩西說：“我再使一種災禍臨到法老和埃及，然後法老他必讓你們離開這裡。他讓你們離開的時候，必全部趕逐你們離開這地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","現在你要告訴人民，叫他們男女各人向自己的鄰舍索取銀器金器。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","耶和華使人民在埃及人眼前蒙恩，同時摩西在埃及地，在法老臣僕的眼前和人民的眼前都成了偉大的人物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","摩西說：“耶和華這樣說：‘大約半夜的時候，我要出去巡行埃及地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","在埃及地所有頭生的都必死亡，就是從坐王位的法老的長子，直到推磨的婢女的長子，以及一切頭生的牲畜都必死亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","在埃及全地必有大哀號；這樣的哀號從前未曾有過，以後也必再沒有。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","但是對於所有的以色列人，無論是人或是牲畜，連狗也不敢向他們叫吠；為要使你們知道耶和華是把埃及人和以色列人分別出來的’。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","你所有的臣僕都必下到我這裡來，向我下跪說：‘你和所有跟從你的人民都出去吧’，然後我才出去。”於是摩西氣忿忿地離開法老出去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","耶和華對摩西說：“法老必不聽你們的話，好使我的神蹟在埃及地加增起來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","摩西和亞倫在法老面前行了這一切神蹟；但耶和華使法老的心剛硬，所以他不肯讓以色列人離開他的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","耶和華在埃及地告訴摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“你們要以本月為正月，為一年的第一個月。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","你們要告訴以色列全體會眾說：本月初十，他們各人要按著父家取羊羔，一家一隻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","如果一家的人太少，吃不了一隻羊羔，家長就要和靠近他家的鄰居按著人數共取一隻。你們預備羊羔的時候，要按著各人的食量計算。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","你們的羊羔要毫無殘疾，一歲以內的公羊；你們可以從綿羊或山羊裡取。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","你們要把羊羔留到本月十四日，在黃昏的時候，以色列全體會眾要把羊羔宰殺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","他們要取點血，塗在吃羊羔的房屋兩邊的門柱和門楣上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","當那一夜，你們要吃羊羔的肉，肉要用火烤了，和無酵餅與苦菜一同吃， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","不可吃生的，也不可用水煮；只可吃用火烤的。頭、腿和內臟都一起吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","你們一點也不可留到早晨；如果有一點留到早晨，就要用火燒掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","你們要這樣吃羊羔：腰間束上帶，腳上穿著鞋，手中拿著杖，快速地吃；這是耶和華的逾越節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","因為在那一夜我要走遍埃及地，把埃及地所有頭生的，無論是人或是牲畜，都要殺掉；我也要審判埃及的一切神祇，我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","這血要在你們居住的房屋上作你們的記號；我擊打埃及地的時候，一看見這血，就越過你們去，災禍必不臨到你們身上毀滅你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","這一日必作你們的記念日；你們要守這日為耶和華的節；你們要世世代代守這節日作永遠的定例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“你們要吃無酵餅七天；可是第一天就要把酵從你們的家中除去；因為從第一日起直到第七日，凡吃有酵之物的，那人必從以色列中被除滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","第一日你們要有聖會，第七日你們也要有聖會；這兩日之內，除了預備各人所要吃的以外，一切工作都不可作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","你們要守無酵節，因為就在這一天，我把你們的軍隊從埃及地領出來；所以你們要世世代代守這一日作為永遠的定例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","從正月十四日晚上起，直到本月二十一日晚上止，你們要吃無酵餅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","七日之內在你們的家中不可有酵；因為凡吃有酵之物的，無論是外國人或是本地人，那人必從以色列的會眾中被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","凡是有酵的，你們都不可吃；在你們一切居住的地方，你們都要吃無酵餅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","於是，摩西把以色列的眾長老召了來，對他們說：“你們要按著家族自己選取羊羔，把這逾越節的羊羔宰殺了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","要拿一把牛膝草，蘸在盆中的血裡，然後把盆裡的血塗在門楣上和兩邊的門柱上；你們誰也不可出自己的房門，直到早晨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","因為耶和華要走遍各處擊打埃及人；他一看見門楣和兩邊的門柱上有血，就越過那門，不讓那毀滅者進入你們的房屋來擊殺你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","這教訓你們必須遵守，作為你和你的子孫永遠的定例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","日後，你們進了耶和華應許賜給你們的那地的時候，就必須守這敬拜之禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","日後，如果你們的子孫問你們：‘你們這敬拜之禮有甚麼意思？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","你們就要回答：‘這是獻給耶和華逾越節的祭。耶和華擊殺埃及人的時候，越過了在埃及的以色列人的房屋，救了我們的家。’”於是人民低頭敬拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","以色列人就去行了；耶和華怎樣吩咐摩西和亞倫，以色列人就照樣行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","到了半夜，耶和華把埃及地所有的長子，就是從坐王位的法老的長子，直到監牢裡遭囚禁的人的長子，以及所有頭生的牲畜，都擊殺了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","在那一夜，法老本人和他所有的臣僕，以及全埃及的人都起來了；在埃及有極大的哀號，因為沒有一家不死人的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","夜裡，法老把摩西和亞倫召了來，說：“你們和以色列人都起來，離開我的人民出去，照著你們所說的，去事奉耶和華吧； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","也照著你們所說的，連羊群牛群都帶著走吧，並且要為我祝福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","埃及人催促以色列人，要他們趕快離開此地，因為他們說：“我們都要死了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","以色列人就拿了沒有發過酵的生麵，用衣服把摶麵盆綁好，扛在肩頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","以色列人照著摩西的話行了，他們向埃及人索取銀器金器和衣服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","耶和華使以色列人在埃及人眼前蒙恩，埃及人就給了他們所要求的。這樣，他們就奪去了埃及人的財物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","以色列人從蘭塞起行到疏割去，除了小孩子以外，步行的男人約有六十萬。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","又有混雜多族的一群人和他們一同上去；他們還帶著羊群牛群和無數的牲畜同去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","他們把從埃及帶出來的生麵烘成了無酵的圓餅。這生麵原是沒有發過酵的，因為他們被驅逐離開埃及，所以不能停留，也沒有為自己預備食糧。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","以色列人住在埃及的時間共有四百三十年之久。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","就在四百三十年屆滿的那一天，耶和華的全軍都從埃及地出來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","這是向耶和華守的一夜，因為耶和華把他們從埃及地領出來，所以這一夜是所有以色列人世世代代向耶和華守的一夜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","耶和華對摩西和亞倫說：“逾越節的定例是這樣，凡是外族人都不可以吃羊羔的肉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","但是各人用銀子買回來的奴僕，如果你給他行了割禮，他就可以吃了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","寄居和受雇的都不可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","必須在同一間房子裡吃，你不可把一點肉從房子裡帶到外面；羊羔的骨頭，一根也不可折斷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","以色列全體會眾都要守這逾越節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","如果有外族人寄居在你們中間，也願向耶和華守逾越節，他所有的男子都要受割禮，然後他才可以前來守逾越節；他就必像本地人一樣，但所有未受割禮的人都不可以吃這羊羔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","本地人和寄居在你們中間的外族人，都同屬一例。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","所有以色列人都奉行了；耶和華怎樣吩咐摩西和亞倫，他們就怎樣行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","就在這一天，耶和華按著他們的軍隊，把以色列人從埃及地領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","耶和華告訴摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“在以色列人中，你要把所有頭生的都分別為聖歸我；無論是人或是牲畜，凡是頭生的都是我的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","摩西對人民說：“你們要記念這一天，就是從埃及為奴之家出來的這一天，因為耶和華用大能的手把你們從這裡領出來；所以有酵之物都不可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","你們是在亞筆月這一日出來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","日後耶和華領你進到迦南人、赫人、亞摩利人、希未人、耶布斯人之地，就是他向你的列祖起誓要賜給你的那流奶與蜜之地，那時你要在這月守這敬拜之禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","你要吃無酵餅七日，第七日要向耶和華守節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","七日之中你要吃無酵餅；在你四境之內，不可見有發過酵之物在你面前，也不可見有酵在你那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","在那日，你要告訴你的兒子說：‘這是因為耶和華在我從埃及出來的時候為我所行的事。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","這要在你的手上作記號，在你額上作記念，好使耶和華的律法常在你的口中，因為耶和華曾用大能的手把你從埃及領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","所以，你要年年按著定期遵守這定例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“日後，耶和華照著他向你和你的列祖所起的誓，把你領進迦南人之地，把這地賜給你之後， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","你要把所有頭生的奉獻給耶和華，也要把你一切牲畜中所有頭生的小牲口奉獻給耶和華；公的都屬耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","凡是頭生的驢，你要用羊羔代贖；如果你不代贖，就要打斷牠的頸項；凡是你兒子中頭生的人，你都要代贖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","日後你的兒子若是問你們：‘這是甚麼意思？’你就要回答他：‘耶和華曾經用大能的手把我們從埃及為奴之家領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","那時法老心裡剛硬，不讓我們離開，耶和華就把埃及地所有頭生的，無論是人或是牲畜都殺了；所以，我把所有頭生的公牲口都獻給耶和華為祭；但我所有頭生的兒子，卻都要代贖回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","這要在你的手上作記號，在你的額上作頭帶；因為耶和華曾用大能的手把我們從埃及領出來。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","法老讓人民離開的時候，雖然非利士的路很近，　神卻不領他們從那裡走，因為　神說：“恐怕百姓看見戰爭而後悔，就回埃及去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","所以　神領人民繞道而行，走曠野的路到紅海去；以色列人從埃及地上來的時候，都帶著兵器。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","摩西帶了約瑟的骸骨同去，因為約瑟曾經叫以色列人嚴肅地起誓，說：“　神必定眷顧你們；你們要把我的骸骨從這裡也一同帶去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","他們從疏割起程，在曠野邊界的以倘安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","耶和華在他們前面行，日間用雲柱領他們的路，夜間用火柱光照他們，使他們日夜都可以行走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","日間雲柱，夜間火柱，都不離開眾民的面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","耶和華告訴摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“你要吩咐以色列人轉回過來，在比．哈希錄前，密奪和海之間安營；你們要在巴力．洗分前，對著巴力．洗分，靠近海邊的地方安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","法老必論到以色列人的事，說：‘他們在這地走迷了路，曠野把他們困住了。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","我要使法老的心剛硬，他就必追趕他們；這樣，我就可以在法老身上和他的全軍身上得到榮耀，埃及人就必知道我是耶和華。”於是以色列人就這樣行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","有人告訴埃及王說：“以色列人逃走了。”法老和他的臣僕對以色列人的心就改變了，他們說：“我們讓以色列人離開，不再服事我們，我們作了甚麼事呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","法老就預備他的馬車，帶著他的人民一同去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","並且帶著六百輛特選的馬車和埃及所有的馬車，每輛馬車上都有馬車長。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","耶和華使埃及王法老的心剛硬，法老就追趕以色列人；因為以色列是靠著耶和華高舉的手出來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","埃及人追趕他們，法老所有的馬匹、戰車和他的馬兵與軍隊，就在海邊，靠近比．哈希錄，對著巴力．洗分他們安營的地方追上了他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","法老走近的時候，以色列人舉目觀看，看見埃及人正追趕過來，就非常懼怕，向耶和華呼求。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","他們對摩西說：“難道埃及沒有墳墓，你要把我們帶來死在曠野嗎？你為甚麼這樣待我們，把我們從埃及領出來呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","我們在埃及的時候，不是對你說過：‘不要管我們，我們要服事埃及人’這話嗎？因為服事埃及人比死在曠野還好。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","摩西對人民說：“不要懼怕，要站著，觀看耶和華今天為你們施行的拯救；因為你們今天看見的埃及人，必永遠不再看見了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","耶和華必為你們爭戰，你們必須安靜，不要作聲。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","耶和華對摩西說：“你為甚麼向我呼求呢？吩咐以色列人往前走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","你要把你的杖舉起來，向海伸手，把海分開，叫以色列人下到海中走乾地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","看哪，我要使埃及人的心剛硬，他們就必跟著以色列人下去；這樣，我必在法老和他的全軍身上，以及他的馬車和馬兵身上得到榮耀。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","我在法老身上，以及他的馬車和馬兵身上得到榮耀的時候，埃及人就知道我是耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","在以色列營前行走的　神的使者，轉到他們後面去；雲柱也從他們前面轉過去，立在他們後面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","雲柱來到埃及營和以色列營中間；雲柱一邊是黑暗的，一邊卻光照著黑夜。這樣整夜彼此都不能接近。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","摩西向海伸手，耶和華就用極強的東風，一夜之間使海水退去；他使海變成乾地，海水也分開了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","以色列人下到海中走乾地，水在他們的左右作了牆垣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","埃及人追趕過來，法老所有的馬匹、馬車和馬兵，都跟著以色列人下到海中去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","到了晨更的時候，耶和華透過雲柱火柱向下觀看埃及人的軍兵，並且使埃及人的軍兵大起混亂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","又使他們的車輪脫落，行駛困難，因此埃及人說：“我們從以色列人面前逃跑吧，因為耶和華為他們爭戰，攻擊埃及人了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","耶和華對摩西說：“你要向海伸手，使水回流到埃及人身上，流到他們的戰車和馬兵身上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","摩西就向海伸手，到了天亮的時候，海水流回原處；埃及人逆流逃跑的時候，耶和華就把他們投在海中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","海水一回流，就淹沒了馬車、馬兵和那些跟著以色列人下海去的法老的全軍，連一個也沒有餘下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","以色列人卻在海中走乾地，水在他們的左右作了牆垣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","這樣，耶和華就在那一天把以色列人從埃及人的手裡拯救了出來；以色列人看見埃及人都死在海邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","以色列人看見耶和華向埃及人所顯大能的手，就敬畏耶和華，又信服耶和華和他的僕人摩西。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","那時，摩西和以色列人向耶和華唱了以下這首歌，說：“我要向耶和華歌唱，因為他高高地被高舉起來；他把馬匹和騎馬的投在海中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","耶和華是我的力量，我的詩歌，也成了我的拯救；這是我的　神，我要讚美他；他是我父的　神，我要尊崇他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","耶和華是戰士，他的名是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","他把法老的馬車和軍兵都投在海裡，法老特選的官長都沉在紅海中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","波濤淹沒了他們，他們好像石頭墜到深海。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","耶和華啊，你的右手滿有榮耀和能力；耶和華啊，你的右手擊碎了仇敵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","你以莫大的威榮，毀滅了那些起來攻擊你的人；你發出烈怒，把他們燒滅像燒禾秸一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","你鼻孔中的氣一發，海水就堆聚起來；水流直立像堤壩，深淵凝結於海心。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","仇敵說：‘我要追趕，我要追上，我要均分擄物；我要在他們身上得到滿足；我要拔出刀來，親手趕絕他們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","你用風一吹，海就把他們淹沒，他們就像鉛一樣沉在大水之中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","耶和華啊，萬神之中有誰像你呢？有誰像你榮耀聖潔，可頌可畏，施行奇事呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","你伸出右手，地就吞沒他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","你憑著慈愛，帶領了你買贖的人民；你憑著能力，引導了他們到你的聖所。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","萬民聽見，就必戰抖；疼痛恐懼抓住了非利士的居民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","那時，以東的族長驚惶，摩押的英雄被戰兢抓住，所有迦南的居民都膽戰心寒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","恐懼戰兢臨到他們身上；因著你大能的手臂，他們像石頭一樣寂然不動；直到你的人民過去，耶和華啊，直到你買贖的人民過去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","你要把他們領進去，栽種在你產業的山上，耶和華啊，就是在你為自己預備的住處；主啊，就是在你手建立的聖所上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","耶和華必作王，直到永永遠遠。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","因為法老的馬匹、戰車和馬兵進到海中去的時候，耶和華使海水回流到他們身上；以色列人卻在海中走乾地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","亞倫的姊姊女先知米利暗，手裡拿著鼓；所有的婦女都跟著她出來，擊鼓跳舞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","米利暗應和著她們說：“你們要向耶和華歌唱，因為他高高地被高舉起來，他把馬匹和騎馬的投在海中。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","摩西命以色列人從紅海起程，到書珥曠野去；他們在曠野走了三天，找不著水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","後來到了瑪拉，瑪拉的水卻不能喝，因為水苦。因此，那地名叫瑪拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","人民就向摩西發怨言，說：“我們喝甚麼呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","摩西向耶和華呼叫，耶和華就向他指示一棵樹；他把樹丟進水裡，水就變甜了。耶和華在那裡為他們立了律例和典章，也在那裡試驗了他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","耶和華又說：“如果你留意聽耶和華你　神的聲音，行他眼中看為正的事，側耳聽他的誡命，遵守他的一切律例；這樣，我決不把加在埃及人身上的一切疾病加在你們身上，因為我是醫治你的耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","後來他們到了以琳，那裡有十二股水泉，七十棵棕樹。他們就在那裡靠近水邊的地方安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","以色列全體會眾從以琳起行，在出埃及以後第二個月十五日，來到以琳和西奈中間汛的曠野那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","以色列全體會眾在曠野都向摩西和亞倫發怨言； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","以色列人對他們說：“我們寧願在埃及地坐在肉鍋旁邊，吃飯吃到飽的時候，死在耶和華的手裡！你們倒把我們領出來，到這曠野，是要叫這全體會眾餓死啊！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","耶和華對摩西說：“看哪，我要把糧食從天上降給你們；人民可以出去，每天收取當天的分量，我好試驗他們是否遵行我的律法。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","到第六天，他們把收進來的預備好，比每天收取的多一倍。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","摩西和亞倫對以色列眾人說：“今晚你們必定知道是耶和華把你們從埃及地領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","明早你們必定看見耶和華的榮耀，因為耶和華聽見了你們向他所發的怨言了。我們算甚麼，你們竟向我們發怨言呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","摩西又說：“耶和華晚上必給你們肉吃，早晨必給你們食物吃飽，因為耶和華聽見了你們埋怨他所說的怨言了。我們算甚麼？你們的怨言不是向我們發的，而是向耶和華發的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","摩西對亞倫說：“你要對以色列全體會眾說：‘你們走近耶和華面前，因為他已經聽見了你們的怨言了。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","亞倫對以色列全體會眾說話的時候，他們向著曠野觀望，看見耶和華的榮耀在雲中顯現出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","耶和華吩咐摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“以色列人的怨言，我已經聽見了。你告訴他們說：‘黃昏的時候你們必吃肉，早晨的時候必有食物吃飽；這樣，你們就知道我耶和華是你們的　神了。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","到了晚上，有鵪鶉飛上來，把營都遮蓋了；到了早晨，營的四周有一層露水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","露水上升以後，就見野地上有細小鱗狀的東西，像小白霜一樣細小的東西。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","以色列人看見了，就彼此對問說：“這是甚麼？”原來他們不知道那是甚麼。摩西對他們說：“這就是耶和華賜給你們吃的食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","耶和華吩咐的話是這樣的：‘你們要按著各人的食量收取，按著你們的人數為帳幕裡的人收取，一人兩公升。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","以色列人就這樣行了；有的多收、有的少收。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","他們用升斗衡量的時候，多收的沒有剩餘，少收的也不缺乏；各人按著自己的食量收取。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","摩西對他們說：“誰也不可把一些留到早晨。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","他們卻不聽摩西的話，有人把一些留到早晨，就生蟲發臭了。摩西就向他們發怒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","他們每天早晨都按著各人的食量去收取；太陽一發熱，就融化了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","到第六日，他們收取了兩倍的食物，每人四公升；會眾的首領都來告訴摩西。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","摩西對他們說：“耶和華這樣說：‘明天是安息日，是向耶和華守的聖安息日。你們要烤的，就烤吧；要煮的，就煮吧；所有餘剩的要自己保存著，直留到早晨。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","他們就照著摩西吩咐的，把餘剩的留到早晨；竟然不發臭，裡頭也沒有生蟲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","摩西說：“今天吃這個吧，因為今天是向耶和華守的安息日，今日你們在田野裡必找不著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","六天你們可以收取，但第七天是安息日，在那一天甚麼都沒有了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","第七天民間有人出去收取，可是甚麼也找不著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","耶和華對摩西說：“你們拒絕遵守我的誡命和律法，要到幾時呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","你們看，耶和華把安息日賜給了你們，所以第六日他賜給你們兩天的食物；第七天你們各人要住在家裡，誰都不可離開自己的地方。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","於是人民在第七天都安息了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","以色列家給這食物起名叫“嗎哪”，它像芫荽的種子，色白，味道像攙蜜的薄餅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","摩西說：“耶和華吩咐的話是這樣：要把滿兩公升的嗎哪保留起來給你們的後代，好讓他們可以看見當日我把你們從埃及地領出來的時候，在曠野給你們吃的食物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","摩西對亞倫說：“拿一個罐子來，裝滿兩公升嗎哪，存放在耶和華面前，保留起來給你們的後代。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","亞倫就照著耶和華吩咐摩西的，把嗎哪存留在法櫃前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","以色列人吃嗎哪共四十年，直到進了有人居住的地方為止；他們吃嗎哪，直到進入迦南地的邊界為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","兩公升就是當時的標準量器的十分之一。（“兩公升就是當時的標準量器的十分之一”原文作“一俄梅珥就是一伊法的十分之一”） ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","以色列全體會眾都照著耶和華的吩咐，一站一站，從汛的曠野起程，在利非訂安營。在那裡人民沒有水喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","因此人民與摩西爭吵，說：“給我們水喝吧。”摩西對他們說：“你們為甚麼與我爭吵呢？你們為甚麼試探耶和華呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","人民在那裡渴望得水喝，就向摩西發怨言，說：“你為甚麼把我們從埃及領上來，使我們和我們的兒女，以及我們的牲畜都渴死呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","摩西向耶和華呼求，說：“我要怎樣對待這人民呢？他們幾乎要用石頭打死我了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","耶和華回答摩西：“你要到人民的面前，要帶著以色列的幾個長老和你一起，手裡要拿著你先前擊打河水的杖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","看哪，我必在何烈山那裡的磐石上站在你面前；你要擊打磐石，就必有水從磐石流出來，使人民可以喝。”摩西就在以色列的長老眼前這樣行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","他給那地方起名叫瑪撒，又叫米利巴，因為以色列人在那裡爭吵，又因為他們試探耶和華，說：“耶和華是不是在我們中間呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","那時亞瑪力人來了，在利非訂和以色列人爭戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","摩西對約書亞說：“你要為我們選出人來，出去和亞瑪力人爭戰；明天我要站在山頂上，手裡拿著　神的杖。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","於是，約書亞照著摩西吩咐他的行了，去和亞瑪力人爭戰；摩西、亞倫和戶珥都上了山頂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","摩西舉起手來的時候，以色列人就得勝；摩西把手放下來的時候，亞瑪力人就得勝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","可是摩西的兩手疲乏了，他們就搬塊石頭來，放在摩西下面，他就坐在上面；亞倫和戶珥，一邊一個，扶著摩西的兩手；這樣，他的兩手就穩住，直到日落的時候。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","約書亞用刀打敗了亞瑪力王和他的人民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","耶和華對摩西說：“我要把亞瑪力的名號從天下完全抹掉；你要把話寫在書上作記念，也要告訴約書亞。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","摩西築了一座祭壇，給它起名叫“耶和華尼西”。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","摩西又說：“向耶和華的旌旗舉手，耶和華必世世代代和亞瑪力人爭戰。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","摩西的岳父，米甸祭司葉忒羅，聽見了　神為摩西和他自己的人民以色列所行的一切，就是耶和華怎樣把以色列人從埃及領出來的事， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","他就帶著摩西的妻子西坡拉，摩西從前送了她回去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","又帶著西坡拉的兩個兒子，一個名叫革舜，因為摩西說：“我在異地作了客旅”； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","一個名叫以利以謝，因為他說：“我父親的　神是我的幫助，救我脫離了法老的刀。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","摩西的岳父葉忒羅，和摩西的妻子與兩個兒子，來到曠野摩西那裡，就是到　神的山，摩西安營的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","葉忒羅叫人告訴摩西說：“你的岳父葉忒羅來見你，你的妻子和兩個兒子也一同來了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","摩西出來迎接他的岳父，向他下拜，與他親嘴，彼此問候，然後一起進了帳棚。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","摩西把耶和華為以色列的緣故，向法老和埃及人所作的一切，以及路上遭遇的一切困難，並且耶和華怎樣拯救他們，都向他的岳父述說。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","葉忒羅因為耶和華為以色列人所行的美事，就是拯救他們脫離埃及人的手，就非常喜樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","葉忒羅說：“耶和華是應當稱頌的，他拯救了你們脫離埃及人的手和法老的手；他也把這人民從埃及人的手下拯救出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","現在我知道耶和華為至大，超乎萬神之上，因為這在埃及人以狂傲的態度對以色列人的事上已經證明了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","摩西的岳父葉忒羅把燔祭和幾樣祭品拿來獻給　神；亞倫和所有以色列的長老都來到　神面前，與摩西的岳父一同吃飯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","次日，摩西坐著審判人民的案件；人民從早到晚都站在摩西的身旁。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","摩西的岳父看見了摩西向人民所行的一切，就說：“你向人民作的是甚麼呢？你為甚麼獨自坐著審判，所有的人民卻從早到晚都站在你的身旁呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","摩西回答他岳父：“因為人民到我這裡來求問　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","他們有事件的時候，就到我這裡來，我就在雙方之間施行審判，使他們認識　神的條例和律法。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","摩西的岳父對摩西說：“你這樣作不好。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","你必疲乏不堪；不但你自己，連與你在一起的人民也必疲乏不堪，因為這事太重，你不能獨自一人去作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","現在你要聽我的話，我要給你出個主意，願　神與你同在；你要代替人民到　神面前，把他們的事件帶到　神那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","又要把規例和律法教導他們，使他們知道他們當走的路，應作的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","你要從人民中間選出有才能的人，就是敬畏　神、忠實可信、恨惡不義之財的人，設立他們作千夫長、百夫長、五十夫長、十夫長，去管理人民， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","使他們隨時可以審判人民的案件；所有大事件，他們要帶到你這裡來；所有小事件，他們可以自己審判。這樣，你就輕省些，他們也可以和你一同分擔此事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","你若是這樣行，　神也這樣吩咐你，你就能站立得住，所有的人民也都能平平安安地歸回自己的地方。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","於是，摩西聽從他岳父的話，照著他所說的行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","摩西從全體以色列人中選出了有才能的人，立他們作人民的首領，作千夫長、百夫長、五十夫長、十夫長。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","他們隨時審判人民的案件；有困難的事件，他們就帶到摩西那裡；所有小事件，由他們自己審判。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","後來，摩西給他的岳父送行，他就回自己的地方去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","以色列人從埃及地出來以後，滿了三個月的那一天，就來到西奈的曠野。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","他們從利非訂起行，來到西奈的曠野，就在曠野安營；以色列人在那座山前安了營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","摩西上到　神那裡去，耶和華從山上呼喚他，說：“你要這樣告訴雅各家，吩咐以色列人說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘我向埃及人所行的，你們都看見了；也看見了我怎樣像鷹一樣把你們背在翅膀上，帶領你們到我這裡來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","現在你們若是實在聽我的話，遵守我的約，你們就必在萬民中作屬我的產業，因為全地都是我的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","你們要歸我作君尊的祭司和聖潔的國民。’這些話你都要對以色列人說。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","摩西去把人民的長老召了來，把耶和華吩咐他的這一切話都擺在他們面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","人民都一致地回答，說：“凡是耶和華吩咐的，我們都要遵行。”摩西就去把人民的話回覆耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","耶和華對摩西說：“看哪，我要在密雲中降臨到你那裡，為要使人民在我與你說話的時候可以聽見，也可以永遠信你。”於是，摩西把人民的話告訴了耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","耶和華對摩西說：“你到人民那裡去，要他們今天明天分別為聖，又要他們洗淨自己的衣服； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","第三天，他們要準備好了，因為第三天耶和華要在全體人民眼前降臨在西奈山。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","你要在山的周圍給人民定界限，說：‘你們要謹慎，不可上山來，也不可觸摸山腳；凡是觸摸著那山的，必要把他處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","不可用手觸摸他，必須用石頭把他打死，或用箭射透；無論是牲畜，是人，都不得生存。’當號角聲拖長的時候，你們才可以上到山上來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","摩西從山上下來到人民那裡去，使人民分別為聖，他們就把自己的衣服洗淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","他對人民說：“第三天，你們要預備好了；不可親近女人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","到了第三天早晨的時候，山上有雷聲、閃電和密雲，並且角聲非常強大，以致所有在營中的人民都顫抖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","摩西率領人民出營去迎接　神，他們都站在山下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","西奈全山冒煙，因為耶和華在火中降臨到山上；山的煙向上升，好像火窯的煙一樣。全山猛烈震動。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","角聲越來越大，大到極點的時候，摩西就說話，　神用雷聲回答摩西。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","耶和華降臨在西奈山上，就是降臨到山頂上；耶和華呼召摩西上山頂，他就上去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","耶和華對摩西說：“你下去警告人民，不可闖過來，到我這裡觀看，免得他們中間有很多人滅亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","又叫那些親近耶和華的祭司分別為聖，恐怕耶和華忽然擊殺他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","摩西對耶和華說：“人民不能上西奈山，因為你曾經警告我們，說：‘要給山定界限，也要把山分別為聖。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","耶和華對他說：“下去吧，你要和亞倫一起再上來，只是祭司和人民都不可闖過來，上到我這裡，恐怕我忽然擊殺他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","於是，摩西下到人民那裡告訴他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","神吩咐以下這一切話，說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“我是耶和華你的　神，曾經把你從埃及地，從為奴之家領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“除我以外，你不可有別的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“不可為自己做偶像，也不可做天上、地下和地底下水中各物的形象。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","不可跪拜它們，也不可事奉它們，因為我耶和華你們的　神是忌邪的　神；恨惡我的，我必追討他們的罪，從父親到兒子，直到三四代。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","愛我和遵守我誡命的，我必向他們施慈愛，直到千代。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“不可妄稱耶和華你　神的名，因為妄稱耶和華的名的，耶和華必不以他為無罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“要記念安息日，守為聖日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","六日要勞碌，作你一切工作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","但第七日是耶和華你的　神的安息日；這一日，你和你的兒女，你的僕婢和牲畜，以及住在你城裡的寄居者，不可作任何的工。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","因為耶和華在六日之內造天、地、海和其中的萬物，第七日就歇息了；所以耶和華賜福安息日，定為聖日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“要孝敬父母，使你在耶和華你的　神賜給你的地上得享長壽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“不可殺人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“不可姦淫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“不可偷盜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“不可作假證供陷害你的鄰舍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“不可貪愛你鄰舍的房屋；不可貪愛你鄰舍的妻子、僕婢、牛驢和他的任何東西。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","全體人民都看見打雷、閃電、角聲和冒著煙的山；人民看見了，就顫抖，遠遠地站著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","他們對摩西說：“求你和我們說話吧，我們必定聽你的話，不可讓　神和我們說話，恐怕我們死亡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","摩西回答人民：“不要懼怕，因為　神降臨是要試驗你們，叫你們常常敬畏他，不至犯罪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","於是，人民遠遠地站著，摩西卻走近　神所在的幽暗之中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","耶和華對摩西說：“你要對以色列人這樣說：‘你們親自看見我從天上和你們說話了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","你們不可做銀的神像和金的神像和我相比，你們決不可為自己做這些神像。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","你要為我築一座土壇，把你的燔祭、平安祭和牛羊獻在壇上；在我使人記念我名的地方，我都必到你那裡去賜福你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","你若是為我築一座石壇，不可用鑿過的石頭來建築，因為你在石頭上一動用工具，就把壇污穢了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","你上我的壇，不可用梯級，免得在壇上露出你的下體來。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“你要在眾民面前訂立的典章是這樣的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","如果你買希伯來人作奴僕，他要服事你六年；到第七年他可以自由出去，不必補償甚麼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","他若是單身來，就可以單身出去；他若是有婦之夫，他的妻子就可以和他同去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","他的主人若是給他妻子，妻子又給他生了兒女，那麼妻子和兒女都要歸給主人，他自己要單獨出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","如果那奴僕明明說：‘我愛我的主人和我的妻子兒女，不願意自由出去。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","他的主人就要把他帶到審判官（“審判官”原文作“　神”）那裡，又要把他帶到門前，或是門柱旁；他的主人要用錐子刺穿他的耳朵，他就要永遠服事他的主人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","如果有人把女兒賣作婢女，婢女不可像男僕那樣出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","如果主人選定她歸自己，以後又不喜歡她，就要准她贖身；主人沒有權力可以把她賣給外族人，因為主人曾經欺騙了她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","如果主人選定她歸自己的兒子，就必須照著待女兒的規矩待她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","如果他另娶一個妻子，那麼，對她的飲食、衣著和性的需要，仍然不可減少。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","如果他不向她行這三樣，她就可以自由出去，不必補償甚麼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“打人以致把人打死的，必要把那人處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","人若不是蓄意殺人，而是　神交在他手中的，我就給你設立一個地方，他可以逃到那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","若有人任意待他的鄰舍，用詭計把他殺了，你要把他從我的祭壇那裡拿去處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“打父母的，必要把那人處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“拐帶人口的，無論是把人賣了，或是還留在他手中，必要把那人處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","咒罵父母的，必要把那人處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“如果人彼此爭論，一個用石頭或拳頭打另一個，但他還沒有死，不過要躺在床上， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","以後，他若是能起來，能扶杖出外行走，那打他的就可算無罪，但要賠償他停工的損失，並且要把他完全醫好。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“如果有人用棍打他的奴僕或婢女，以致死在他的手下，他必須受刑罰； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","但如果他還活一兩天，那人就不必受刑罰，因為那奴僕是他的財產。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“如果人彼此爭鬥，擊傷了懷孕的婦人，以致流產，但沒有別的損害，那傷害她的必須按照婦人的丈夫要求的，和照著審判官斷定的，繳納罰款。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","如果有別的損害，你就要以命償命， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","以眼還眼，以牙還牙，以手還手，以腳還腳， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","以烙還烙，以傷還傷，以打還打。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“如果有人擊打他奴僕的一隻眼，或婢女的一隻眼，把眼打壞了，就要因他的眼的緣故讓他自由離去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","如果有人打落了他奴僕的一隻牙，或婢女的一隻牙，就要因他的牙的緣故讓他自由離去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“如果牛觸了男人或女人，以致死亡，那牛必須用石頭打死，只是不可吃牛的肉；牛的主人卻不必受刑罰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","如果那牛以前常常觸人，牛主也曾經受過警告，他仍然不把牛拴好，以致觸死了男人或是女人，就要用石頭把那牛打死，牛主也必要處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","如果給他提出贖金，他就必須照著提出的數量全數繳付贖命金。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","牛無論觸了人的兒子，或是觸了人的女兒，都必須照著這定例辦理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","如果牛觸了人的奴僕，或是婢女，必須把三百四十克銀子給他的主人，那牛也必須用石頭打死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“如果有人把井敞開，或是有人挖了井，而不把井口遮蓋，以致有牛或驢掉進裡面， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","井主要賠償，要把銀子還給牛主或驢主，死的牲畜可以歸自己。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“如果有人的牛傷了他鄰舍的牛，以致死亡，他們要把活牛賣了，平分銀子，也要平分死牛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","如果人知道那牛以前常常觸人，牛主竟不把牛拴好，他必須賠償，以牛還牛，死的可以歸自己。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“如果人偷了牛或是羊，無論是宰了或是賣了，他必須賠償，以五牛還一牛，以四羊還一羊。（本節在《馬索拉抄本》為21:37） ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“竊賊挖窟窿入屋的時候，如果被人發現，把他打了，以致打死，打死人的就沒有流人血的罪。（本節在《馬索拉抄本》為22:1） ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","如果太陽出來了，他就有流人血的罪。竊賊必須賠償，如果他一無所有，就要賣身，還他所偷之物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","所偷之物，無論是牛、是驢，或是羊，如果發現在他手中仍然活著，他必須雙倍償還。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","如果有人在田間或葡萄園裡放牲畜吃草，任由牲畜到別人的田裡去吃草，就必須拿自己田間最好的，或自己葡萄園中最好的賠償。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“如果火燒起來，燒著了荊棘，以致把別人堆積的禾捆、豎立的莊稼，或是田園都燒盡了，那點火的必須賠償。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“如果人把銀子或家中物件交給鄰舍看守，這些東西從那人的家被偷去；如果把竊賊抓到了，竊賊就要雙倍償還。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","如果找不到竊賊，那家主必要到審判官（“審判官”原文作“　神”）那裡，查明他有沒有下手拿去鄰舍的財物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","任何爭訟的案件，無論是為了牛、驢、羊、衣服，或是甚麼遺失了的東西，如果一方說：‘這是我的’，這樣，雙方的案件就要帶到審判官（“審判官”原文作“　神”）面前，審判官定誰有罪，誰就要雙倍償還給他的鄰舍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“如果人把驢、牛、羊，或是任何牲畜交給鄰舍看守，牲畜死亡、受傷，或是被趕去，又沒有人看見， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","兩人必須在耶和華面前起誓，表明他沒有下手拿去鄰舍的財物；如果物主接受那誓言，看守的人就不必賠償。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","如果牲畜真的從看守的人那裡被偷去，他就要賠償給物主。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","如果真的被野獸撕碎了，看守的人就要把被撕碎的帶來作證據，這樣，他就不必賠償。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“如果人向鄰舍借甚麼，所借的無論是受了傷，或是死了，物主不在場，借的人就必須償還。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","如果物主在場，他就不必償還；若是雇來的，也不必償還，因為他為雇價來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“如果人引誘還沒有許配人的處女，與她同寢，他必須交出聘禮，娶她為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","如果處女的父親堅決不肯把女兒嫁給他，他就要按照處女的聘禮，交出聘銀來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“不可讓行巫術的女人活著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“凡與牲畜同寢的，那人必須處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“除了獨一的耶和華以外，還獻祭給別神的，那人必須滅絕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","不可欺負寄居的，也不可壓迫他，因為你們在埃及地也作過寄居的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","不可苦待任何孤兒寡婦。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","如果你們真的苦待他們，他們一向我呼求，我必定聽他們的呼求， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","並且我要發怒，用刀殺死你們，使你們的妻子成為寡婦，你們的兒女成為孤兒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“如果你借錢給我的人民，就是與你們在一起的窮人，你對待他們不可像放債的人一樣，不可在他們身上取利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","如果你拿了鄰居的衣服作抵押，必須在日落之前歸還給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","因為這是他唯一的鋪蓋，是他蔽體的衣服；如果沒有了它，他拿甚麼睡覺呢？如果他向我呼求，我必應允，因為我是滿有恩惠的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“不可咒罵　神，也不可咒詛你人民的領袖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","要把你豐收的五穀和初榨的新酒獻上，不可遲延；要把你頭生的兒子獻給我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","對於牛羊頭生的，你也要這樣作；七天之內，可以和母的在一起，第八天就要把牠獻給我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","你們要歸我作聖潔的人；因此田間被野獸撕碎的肉，你們不可以吃，要把它丟給狗吃。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“不可傳播謠言，也不可與惡人攜手作假見證。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","不可隨眾行惡，不可在訴訟的事上隨眾說歪曲正義的話； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","也不可在訴訟的事上偏護窮人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“如果你遇見你仇敵的牛或是驢走迷了路，就應該把牠牽回來給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","如果你看見恨你的人的驢伏在重擔之下，不可走開不理牠，你應該與驢主一同卸下重擔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","不可在窮人訴訟的事上歪曲正義。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","要遠離虛假的事；不可殺無辜和正義的人，因為我決不以惡人為義人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","不可受賄賂，因為賄賂能使明眼人變瞎，又能歪曲義人的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","不可壓迫寄居的，因為你們在埃及地也作過寄居的，知道寄居者的心情。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“六年之內你要耕種田地，收取地的出產； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","但是第七年，你要讓地歇息，不耕不種，使你民間的窮人可以有吃的；他們吃剩的，田間的野獸可以吃；你的葡萄園和橄欖園，也要這樣作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","六日之內，你要作你的工；但第七日你要安息，好使你的牛和驢可以歇息，並且使你婢女的兒子和寄居的也可以有時間喘息一下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","我對你們所說的一切，你們都要小心謹守，你們不可提別神的名，也不可讓人從你的口中聽到。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“每年三次，你要為我守節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","你要守無酵節，要照我吩咐的，在亞筆月內所定的日期，吃無酵餅七天，因為你是在這個月從埃及出來的。你們不可空手朝見我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","又要守收割節，就是收在田間你勞碌耕種所得初熟之物的節；也要在年底守收藏節，就是在田間收集你勞碌所得之物的時候。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","一年三次，你所有的男丁都要朝見主耶和華的面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“你不可把我祭牲的血和有酵的餅一同獻上；也不可把我節日祭牲的脂油留過夜到早晨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","要把你地上最上好的初熟之物帶到耶和華你　神的殿中。不可用山羊羔母的奶去煮山羊羔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“看哪，我在你面前差派使者，好在路上保護你，領你到我預備的地方去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","你們在他面前要謹慎，要聽他的話，不可違背他；不然，他必不赦免你們的過犯，因為他是奉我的名來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","如果你實在聽他的話，遵行我吩咐的一切，我就要作你仇敵的仇敵，作你敵人的敵人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","我的使者必在你前面走，領你到亞摩利人、赫人、比利洗人、迦南人、希未人、耶布斯人那裡去；我要把他們除掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","你不可跪拜他們的神像，也不可事奉它們，不可作他們所作的，不可模仿他們的行為，卻要把神像完全拆毀，打碎他們的柱像。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","你們要事奉耶和華你們的　神，他就必賜福你的糧和你的水，我也必從你們中間除去疾病。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","在你的境內，必沒有流產和不育的婦女；我必使你一生的壽數滿足。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","我必在你面前展露我的威嚴；凡你所到的地方，我必使那裡的人民慌亂，又使你所有的仇敵都轉背而逃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","我必在你面前打發大黃蜂，把希未人、迦南人、赫人，都從你面前驅逐出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","我不在一年之內把他們從你面前驅逐出去，恐怕這地變為荒涼，又恐怕田野間的走獸多起來害你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","我要漸漸地把他們從你面前驅逐出去，等到你的人數增多起來，承受那地為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","我要限定你的境界，從紅海直到非利士海，從曠野直到大河。我要把那地的居民交在你手中，你要把他們從你面前驅逐出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","不可與他們和他們的神立約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","不可讓他們住在你的境內，恐怕他們使你得罪我；如果你事奉他們的神，這必成為你的網羅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","耶和華對摩西說：“你要上到耶和華這裡來。你自己、亞倫、拿答、亞比戶和以色列長老中的七十人都要上來，你們要遠遠下拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","只有摩西一人可以走近耶和華，他們卻不可以親近；人民也不可和摩西一同上來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","摩西下來，把耶和華的一切話和一切典章都向人民講述；人民都同聲回答，說：“耶和華吩咐的一切話，我們都必遵行。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","摩西把耶和華的一切話都記下了；清早起來，在山下築了一座祭壇，按著以色列十二支派立了十二根柱子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","又派了以色列人中的青年人去獻燔祭，又向耶和華殺牛獻為平安祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","摩西取了一半的血，盛在盆中；又取了另一半的血，灑在祭壇上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","他又把約書拿過來，念給人民聽；他們說：“耶和華吩咐的一切話，我們都必遵行和聽從。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","摩西就取了血來，灑在人民的身上，說：“看哪，這是立約的血，這約是耶和華按著這一切話與你們立的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","隨後，摩西、亞倫、拿答、亞比戶和以色列長老中的七十人都上了山。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","他們看見了以色列的　神；在　神的腳下有好像藍寶石一樣晶瑩的鋪路，好像天色一般明亮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","他不伸手攻擊以色列人中的顯貴；他們看見　神，並且又吃又喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","耶和華對摩西說：“你要上山到我這裡來，要住在這裡；我要把石版，就是我所寫的律法和誡命賜給你，使你可以教導人民。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","於是，摩西和他的侍從約書亞起來；摩西就上到　神的山那裡去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","但摩西對長老說：“你們要在這裡等候我們，直到我們再回到你們那裡來。看哪！這裡有亞倫和戶珥與你們在一起，誰有訴訟的案件，都可以到他們那裡去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","摩西上到山上，有雲彩把山遮蓋著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","耶和華的榮耀停在西奈山上，雲彩把山遮蓋了六天；第七天，耶和華從雲彩中呼喚摩西。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","耶和華榮耀的景象，在以色列人眼前，好像在山頂上出現烈火。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","摩西進入雲彩中，上到山上去；摩西在山上四十晝夜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“你要告訴以色列民，叫他們給我送禮物來，所有心裡樂意奉獻的人，你們就可以收下他們給我的禮物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","以下是你們要從他們收取的禮物：金、銀、銅、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","藍色紫色朱紅色線、細麻、山羊毛、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","染紅的公羊皮、海狗皮、皂莢木、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","燈油、膏油的香料和焚香用的香料， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","綠柱玉寶石和鑲嵌在以弗得和胸牌上的寶石。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","他們要為我建造聖所，使我可以在他們中間居住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","按著我指示你建造會幕和一切器具的樣式，你們要照樣建造。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“他們要用皂莢木做一個櫃，長一百一十公分，寬六十六公分，高六十六公分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","你要用純金包櫃，內外都要包上；櫃上的四圍要做金邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","你要鑄造四個金環，安放在櫃的四腳上，兩個環在這邊，兩個環在那邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","你要用皂莢木做幾根櫃槓，並要用金包裹起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","你要把櫃槓穿在櫃旁的環中，以便用槓抬櫃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","櫃槓要常留在櫃的環中，不可抽出環外。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","你要把我賜給你的法版放在櫃裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","你要用純金做施恩座，長一百一十公分，寬六十六公分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","你要用黃金錘成兩個基路伯，放在施恩座的兩端。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","這端做個基路伯，那端做個基路伯，二基路伯要與施恩座連在一起製造，在施恩座的兩端。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","二基路伯要在上面展開雙翼，遮掩施恩座，基路伯的臉要彼此相對，他們的臉要朝著施恩座。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","你要把施恩座安放在櫃頂，又要把我賜給你的法版放在櫃裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","我要在那裡和你相會，也要從施恩座上面，從二基路伯之間，告訴你一切我命令你傳給以色列人的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“你要用皂莢木做一張桌子，長八十八公分，寬四十四公分，高六十六公分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","你要用純金包桌子，桌子的四圍要做金邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","你要給桌子的四圍做七十五公釐寬的框邊，框邊上的四圍要做金邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","你要做四個金環，把金環安放在桌子的四角上，就是在桌子的四腳上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","環子要靠近框邊，用來穿桌槓，以便抬桌子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","你要用皂莢木做幾根桌槓，又要用金包裹起來，桌子要用桌槓來抬。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","你要做桌子上的盤子、碟子、酒杯和奠酒用的瓶，這些你要用純金製造。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","你又要在桌子上，在我面前，常常擺放陳設餅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“你要用純金做一個燈臺，那燈臺你要用鎚錘成；燈臺的座、幹、杯、球、花，都要與燈臺連在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","燈臺的兩邊伸出六個枝子；一邊有三個燈臺枝子，另一邊也有三個燈臺枝子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","在第一個枝子上有三個杯，形狀像杏花，有球、有花；在另外一個枝子也有三個杯，形狀像杏花，有球、有花。從燈臺伸出的六個枝子，都是這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","燈臺上有四個杯，形狀像杏花，有球、有花。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","每兩個枝子的下面有球和燈臺相連，從燈臺伸出來的六個枝子，都是這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","球和枝子都要與燈臺連在一起，都是從一塊純金錘成的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","你要做燈臺上的七個燈盞，這些燈盞要放在燈臺之上，使燈光照亮對面的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","燈臺上的燈剪和燈花盆，也是要純金做的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","要用三十五公斤純金做燈臺和一切器具。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","你要留心照著在山上指示你的樣式去做。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“你要用十幅幔子來做會幕；幔子要用撚的細麻、藍色紫色朱紅色線做成，並要用巧工繡上基路伯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","每幅幔子要長十二公尺，寬兩公尺，每幅幔子都要一樣的尺寸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","其中五幅幔子要彼此相連，另外五幅幔子也要彼此相連。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","其中一組相連的幔子最後一幅的邊上，你要做藍色的鈕扣；在另一組相連的幔子最後一幅的邊上，你也要這樣做。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","在這幅幔子上，你要做五十個鈕扣；在另一組幔子最後一幅的邊上，你也要做五十個鈕扣，這些鈕扣要彼此相對。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","你要做五十個金鉤，又要用鉤使幔子相連起來，成為一整個會幕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“你要用山羊毛做幔子，作會幕上面的帳棚，你要做十一幅幔子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","每幅幔子要長十三公尺，寬兩公尺，十一幅幔子都要一樣的尺寸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","你要把五幅幔子連在一起，又把另外六幅幔子連在一起，你要在帳棚前面把第六幅幔子摺疊起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","在這一組相連的幔子最後一幅的邊上，你要做五十個鈕扣；在另一組相連的幔子最後一幅的邊上，也要做五十個鈕扣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","你又要做五十個銅鉤，把鉤穿進鈕扣中，使帳棚連起來，成為一整個帳棚。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","帳棚的幔子多出的那部分，即垂下來的半幅幔子，要垂在會幕的後面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","帳棚幔子多出的長度，要這邊五十公分，那邊五十公分，並且要在會幕的兩邊，遮蓋會幕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","你又要用染紅的公羊皮做帳棚的頂蓋，在上面再蓋上海狗皮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“你要用皂莢木做會幕的豎板， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","每塊板要長四公尺，寬六十六公分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","每塊木板要有兩個榫頭，彼此連接，會幕的一切木板你都要這樣做。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","你要給會幕做木板；給南邊，就是向南的一面，做二十塊木板， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","在這二十塊板底下，你要做四十個銀插座；每塊木板底下有兩個插座連接它的兩個榫頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","你也要給會幕的另一邊，就是北面，做二十塊木板， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","和四十個銀插座。這塊木板底下有兩個插座，那塊木板底下也有兩個插座。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","給會幕的後面，就是西面，你要做六塊木板。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","在會幕後面的兩角上，你要做兩塊木板。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","木板的下截是要雙的，一直連到上面的第一環那裡，都是要雙的。兩塊都要這樣做，要成為兩隻角。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","所以要有八塊木板，和十六個銀插座，這塊木板底下有兩個插座，那塊木板底下也有兩個插座。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“你要用皂莢木做橫閂，為會幕這邊的木板做五個橫閂， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","為會幕那邊的木板也做五個橫閂，又為會幕的後邊，即西邊的木板，也做五個橫閂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","木板中部的中閂，要從這一端通到那一端， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","木板要包金，你也要做板上的金環，用來穿上橫閂，橫閂也要包金。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","你要照著在山上指示你的樣式立起會幕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“你要用藍色紫色朱紅色線和撚的細麻做幔幕，並且要用巧工繡上基路伯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","你要把幔幕掛在四根包金的皂莢木柱子上，柱上有金鉤，柱腳安在四個銀插座上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","你要把幔幕掛在鉤子上，把法櫃抬進幔幕裡面，這幔幕要給你們把聖所和至聖所分開。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","你要把施恩座安在至聖所內的法櫃上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","你要把桌子放在幔幕外，把燈臺放在會幕的南邊，與桌子相對；把桌子安在北面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“你要給帳幕的門口做塊簾子，要用藍色紫色朱紅色線和撚的細麻編織而成。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","你又要用皂莢木為簾子做五根柱子，柱子要包金，柱上有金鉤，你也要為柱腳鑄造五個銅插座。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“你要用皂莢木做祭壇，這壇要四方的：長兩公尺兩公寸，寬兩公尺兩公寸，高一公尺三公寸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","要在祭壇的四拐角做四個角，角要與祭壇連在一塊，祭壇要包上銅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","要做盆，用來收去祭壇上的灰，又要做鏟、盤、肉叉和火鼎；祭壇上的一切器具，你都要用銅來做。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","要為壇做一個銅網，網的四拐角上要做四個銅環。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","要把網安在祭壇下面的圍腰板之下，使網從下面直達到祭壇的半腰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","又要為祭壇做槓，就是皂莢木的槓，要包上銅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","槓要穿在祭壇的環子裡，抬祭壇的時候，槓就在祭壇的兩邊； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","你要用木板做祭壇，祭壇是空心的。你要照著在山上指示你的去做。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“你要做會幕的院子。在南面，即向南的一面，要用撚的細麻為院子做帷幔，每邊長四十四公尺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","帷幔的柱子要二十根，銅插座二十個。柱子上的鉤子和桁子都是銀的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","北面也是一樣，要有四十四公尺長的帷幔，帷幔的柱子二十根，銅插座二十個，柱子上的鉤子和桁子都是銀的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","院子的西面，也要有帷幔，寬二十二公尺。帷幔的柱子十根，插座十個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","院子的東面，要有二十二公尺寬。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","門一面的帷幔要六公尺六公寸，帷幔的柱子三根，插座三個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","門另一面的帷幔也要六公尺六公寸，帷幔的柱子三根，插座三個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","院子的大門要有門簾，長九公尺，是用藍色紫色朱紅色線和撚的細麻，用刺繡的手工織成，柱子四根，插座四個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","院子周圍一切柱子，都要用銀桁子相連起來。柱子上的鉤子是銀的，插座是銅的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","院子要長四十四公尺，寬二十二公尺，高兩公尺兩公寸；帷幔是細麻撚的，插座是銅的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","會幕中為禮拜用的一切器具和釘子，以及院子裡的一切釘子，都是銅的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“你要吩咐以色列民把打成的純橄欖油拿來給你，是為點燈用的，使燈常常點著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","在會幕中法櫃前的幔子外，亞倫和他的子孫，從晚上到早晨，要常在耶和華面前料理這燈。這要作以色列人世世代代的定例。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“你要從以色列人中使你的哥哥亞倫和他的眾子，就是亞倫和他的眾子：拿答、亞比戶、以利亞撒、以他瑪，都一同來到你面前，作事奉我的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","你要為你哥哥亞倫做聖衣，使他有榮耀，有華美。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","你又要吩咐所有心中有智慧的，就是我用智慧的靈充滿的，給亞倫做衣服，使他成聖，作事奉我的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","這些就是他們要做的衣服：胸牌、以弗得、長外袍、雜色內袍、禮冠、腰帶。他們要為你哥哥亞倫和他的眾子做聖衣，使他們作事奉我的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","他們要拿金線、藍色紫色朱紅色線和細麻去做。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“他們要拿金線、藍色紫色朱紅色線和撚的細麻，用巧工來做以弗得。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","以弗得要有兩條肩帶，連接著兩端，好使它相連在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","以弗得上面的帶子，它的巧工要和以弗得一樣，用來束上以弗得，要用金線、藍色紫色朱紅色線和撚的細麻做成。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","你要取兩塊紅寶石，把以色列眾子的名字刻在上面， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","六個名字在一塊寶石上，其餘六個名字在另一塊寶石上，都是照著他們出生的次序。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","好像寶石雕刻匠刻印章一樣，你要把以色列眾子的名字刻在這兩塊寶石上，要把它們鑲嵌在金槽中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","你要把這兩塊寶石安放在以弗得的肩帶上，作以色列民的記念石。亞倫在耶和華面前，用兩肩擔當他們的名字，作為記念。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","你要做金槽， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","和兩條純金的鍊子，像做繩子一樣擰成，把這像繩子一樣的鍊子放置在二槽上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“你要用巧工做一個作判斷用的胸牌，像以弗得的做法一樣，要用金線、藍色紫色朱紅色線和撚的細麻做成。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","胸牌要四方的，雙層的，長二十二公分，寬二十二公分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","你要在胸牌上面鑲上四行寶石：第一行是紅寶石、黃玉、翡翠； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","第二行是紫寶石、藍寶石、金鋼石； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","第三行是黃瑪瑙、白瑪瑙、紫晶； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","第四行是水蒼玉、紅瑪瑙、碧玉。這些寶石都是鑲在金槽裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","按著以色列眾子的名字，這些寶石要有十二塊；按著他們的名字刻印章，按他們的名字各代表十二個支派。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","你要在胸牌上做純金的鍊子，像做繩子一樣擰成。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","你要在胸牌上做兩個金環，把這兩個金環安在胸牌的兩端之上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","你要把那兩條金鍊子穿在胸牌兩端的兩個環子裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","你又要把那兩條鍊子的另兩端接在兩槽上，連在以弗得前面的肩帶上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","你又要做兩個金環，安在胸牌下邊的兩端，就是靠近以弗得裡面的邊緣上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","你又要做兩個金環，把它們安在以弗得前面兩條肩帶的下面，靠近相接的地方，在以弗得巧工織成的帶子上面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","你要用紫藍色細線把胸牌的環子繫在以弗得的環子上，使胸牌貼在以弗得巧工織成的帶子上，免得胸牌從以弗得上脫下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","亞倫進入聖所的時候，要把作決斷用的胸牌，上面有以色列眾子的名字，帶在胸前，在耶和華面前常作記念。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","你要把烏陵和土明放在作決斷用的胸牌裡。亞倫進入耶和華面前的時候，它們要帶在胸前；這樣，亞倫就在耶和華面前常常把以色列眾子的決斷帶在胸前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“你要做以弗得的長外袍，全件要紫藍色。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","在長外袍的正中，頭部的地方，要有一個領口，領口的周圍要有領邊，是用紡織的細工織成，如同戰袍的領口一樣，免得長外袍破裂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","在長外袍下襬的周圍，你要用藍色紫色朱紅色線做石榴，在長外袍下襬周圍的石榴中間，要綴上金鈴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","在長外袍下襬的周圍綴上一個金鈴、一個石榴、一個金鈴、一個石榴， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","長外袍要穿在亞倫的身上，好作事奉。他進入聖所到耶和華面前，以及出來的時候，他的聲音必被聽見，免得他死亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“你要用精金做一面牌子，在牌上像刻印章般刻著：‘歸耶和華為聖’。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","你要用一條紫藍色細線把牌子繫住，好使它安在禮冠上，就是在禮冠的前面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","這牌要在亞倫的額上，亞倫要擔當干犯聖物的罪過，這些聖物是以色列人在一切聖禮物上分別為聖的；這牌要常在亞倫的額上，好使他們在耶和華面前可以得蒙悅納。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","你要用細麻線編織雜色內袍，用細麻布做禮冠，又用刺繡的手工做腰帶。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“你也要為亞倫的兒子做內袍，為他們做腰帶，又為他們做頭巾，使他們有榮耀，有華美。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","你要把這些給你哥哥亞倫和他的兒子們穿上，又要膏抹他們，按立他們，把他們分別為聖，好使他們可以作我的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","你要給他們做白麻布褲子，遮蓋裸體，褲子遮蓋腰間，直到大腿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","亞倫和他兒子進入會幕，或走近祭壇，在聖所裡事奉的時候，都必須穿上褲子，免得他們擔當罪過而死。這要給亞倫和他的後裔作永遠的條例。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“你要把他們分別為聖，使他們作我的祭司，就必須這樣作：取一頭小公牛和兩隻沒有殘疾的公綿羊， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","以及無酵餅、調油的無酵餅和抹油的無酵薄餅。這些你都要用細麥麵來做。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","你要把這些餅放在籃子裡，用籃子把餅帶來獻上，又把小公牛和兩隻綿羊牽來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","你要把亞倫和他兒子們帶到會幕門口，用水給他們洗身。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","你要拿衣服來，給亞倫穿上雜色內袍、以弗得的長外袍、以弗得和胸牌，又束上巧工織成的以弗得的帶子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","你要把禮冠戴在他頭上，又把聖冠放在禮冠上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","你要把膏油拿來，倒在他頭上，膏立他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","你也要把他的兒子帶來，給他們穿上雜色內袍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","要給亞倫和他兒子束上腰帶，包上頭巾；這樣，他們就按永遠的定例，得了祭司的職分。你又要把亞倫和他兒子們分別為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“你要把公牛帶到會幕來獻上，亞倫和他兒子們要按手在公牛的頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","你要在耶和華面前，在會幕門口，宰殺那公牛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","你要取些公牛的血，用你的指頭抹在祭壇的角上，把其餘的血都倒在祭壇腳前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","你要把一切遮蓋內臟的脂油、肝葉、兩個腰子和腰子上的脂油，都取出來，把它們焚燒在祭壇上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","至於公牛的肉、皮和糞，你都要在營外用火焚化。因為這是贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“你要把一隻公綿羊牽來，亞倫和他兒子們要按手在這公綿羊的頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","你要宰殺這公綿羊，取些羊血，灑在祭壇的周圍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","你要把公綿羊切成塊子，再把內臟和羊腿洗淨，放在肉塊和羊頭上面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","你要把整隻公綿羊焚燒在祭壇上；這是獻給耶和華的燔祭，是獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“你要把另一隻公綿羊也牽來，亞倫和他兒子們要按手在這公綿羊的頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","你要宰殺這公綿羊，取些血，抹在亞倫的右耳垂上，以及他兒子們的右耳垂上，又抹在他們右手的大拇指上，和他們右腳的大拇趾上；並且要把血灑在祭壇的周圍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","你要從壇上取一點血，也取一點膏油，彈在亞倫身上和他的衣服上，並且要彈在他兒子的身上和他們的衣服上。這樣，他和他的衣服，他兒子和他們的衣服就都一同成聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","你要從這公綿羊身上取出脂油和肥尾巴，遮蓋內臟的脂油和肝葉、兩個腰子和腰子上的脂油，以及右腿，因為這是授聖職的時候，所要獻的公綿羊， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","你要從擺在耶和華面前載無酵餅的籃子裡取一個圓餅、一個油餅和一個薄餅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","你要把這一切都放在亞倫和他兒子的手上；你要在耶和華面前把他們搖動作搖祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","你要從他們手中接過來，向著祭壇把這些東西燒在燔祭之上，在耶和華面前作馨香之氣，這是獻給耶和華的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“你要取亞倫授聖職的時候，所獻的公綿羊的胸，在耶和華面前把它搖動作搖祭，這就是你的分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","那作搖祭的胸和舉祭的腿，你都要使它們成聖，就是亞倫和他兒子授聖職的時候，所獻的公綿羊，被搖過被舉過的部分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","這要作為亞倫和他兒子們從以色列人所得的分，作為永遠的定例，因為這是舉祭。這舉祭要從以色列人的平安祭中分別出來，歸給耶和華作舉祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“亞倫的聖衣要傳給他的子孫，要穿著受膏，也要穿著受聖職。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","亞倫的子孫中，凡是接替他作祭司的，每逢進入會幕在聖所裡事奉的時候，都要穿聖衣七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“你要把授聖職的時候所獻的公綿羊取來，在聖潔的地方燒牠的肉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","亞倫和他的兒子要在會幕的門口吃這公綿羊的肉和籃子裡的餅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","他們要吃那些用來贖罪的東西，好使他們可以接受聖職，可以成聖；只是外人不可吃，因為這些東西是聖物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","授聖職的時候所獻的肉和餅，如果有一點留到早晨，你要把留下的用火燒了，不可吃，因為這是聖物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“這樣，你要照我吩咐你的，向亞倫和他的兒子行接受聖職的禮七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","你要每天獻公牛一頭作贖罪祭，用來贖罪；你為祭壇行贖罪祭的時候，你要潔淨祭壇。而且你要用膏抹祭壇，使祭壇成聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","你要為祭壇行贖罪祭七天，也要使它成聖，這樣，祭壇就成為至聖；一切觸著祭壇的東西，都要成聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“這就是你要獻在祭壇的：每天兩隻一歲的羊羔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","第一隻羊你要在早晨獻上；第二隻在傍晚的時候獻上， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","和這一隻羊同獻的，要用一公斤細麵與一公升榨成的油混和，又要用一公升酒作奠祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","那另一隻羊你要在傍晚的時候獻上，照著早晨的素祭和它的奠祭一樣辦理，作馨香之氣，作獻給耶和華的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","這要作你們世世代代常獻的燔祭，獻在會幕的門口，耶和華的面前，我要在那裡與你們相會，在那裡和你們說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","我要在那裡與以色列人相會，會幕就會因我的榮耀被尊為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","我要使會幕和祭壇成聖，也要使亞倫和他的兒子成聖，作祭司事奉我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","我要住在以色列人中間，我也要作他們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","他們必知道我是耶和華他們的　神，就是從埃及地把他們領出來的，為要住在他們中間。我是耶和華他們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“你要做一座燒香的壇，你要用皂莢木做這座壇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","壇要四方的：長四十五公分，寬四十五公分，高九十公分。壇的四角要與壇接連在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","你要用純金把壇包裹，壇頂、壇的四邊和壇的四角都要包裹，你要給壇的四圍做金牙邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","在壇的兩旁金牙邊以下你要做兩個金環，兩邊都有，用來穿木槓的地方，以便抬壇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","你要用皂莢木做木槓，要用金把它們包裹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","你要把壇放在法櫃前面的幔幕前，面對著法櫃上的施恩座，就是我與你相會的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","亞倫要在壇上燒香料做的香，每天早晨整理燈的時候，要燒這香。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","傍晚，亞倫點燈的時候，也要燒這香，在耶和華面前作你們世世代代不斷的香。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","在這壇上，你們不可獻上凡香、燔祭、素祭，也不可在這壇上澆奠祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","亞倫每年一次要在壇的四角上行贖罪禮，每一次他都要用贖罪祭牲的血在壇上行贖罪禮；你們世世代代都要這樣行，這壇要歸耶和華為至聖。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“你要照著以色列人被數點的數目登記人數；你數點的時候，他們各人要為自己的性命把贖價歸給耶和華，免得你數點的時候，他們中間有災病。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","以下就是他們當繳納的；凡是屬於那些被數點的人的，每人要照著聖所的標準獻銀子六克；這六克銀子是歸給耶和華的禮物。這重量是聖所用的標準重量（“這重量是聖所用的標準重量”原文作“一舍客勒是二十季拉”）。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","凡是屬於那些被數點的人，自二十歲以上的，要把禮物獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","富有的人不可多出，貧窮的也不可少出。各人要納六克銀子，作禮物獻給耶和華，好為你們的性命作贖價。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","你要從以色列人收取這贖銀，指定作會幕事奉的使用，好使它在耶和華面前為以色列人作個記念，也贖回你們的性命。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“你要做一個銅盆和一個銅座，用來洗濯。你要把盆放在會幕和祭壇之間，並且要把水放在盆中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","亞倫和他的兒子要在盆裡洗手洗腳。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","他們進會幕的時候，或是走近祭壇敬拜，給耶和華焚燒火祭的時候，都要用水洗濯，免得死亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","他們要洗手洗腳，免得死亡。這要作他們永遠的定例，就是作亞倫和他的後裔世世代代永遠的定例。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“你要取最上等的香料，就是流質的沒藥六公升，香玉桂是沒藥的一半，就是三公斤，香昌蒲三公斤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","玉桂皮六公斤，都要按著聖所的標準重量，又橄欖油四公斤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","你要把這些材料製成聖膏油，就是照著香膏配製師的方法配製成的香膏，是要作為聖膏油的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","你要用這膏油抹會幕和法櫃， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","桌子和桌子的所有器具，燈臺和燈臺的器具，以及香壇， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","燔祭壇和壇上的所有器具，盆和盆座； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","你要使它們成聖，使它們成為至聖；凡是觸著它們的，都要成聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","你也要膏抹亞倫和他的兒子，好使他們成聖，作我的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","你要告訴以色列人說：‘你們世世代代要把這油歸我為聖膏油。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","不可倒在常人的身上，也不可照著這配製的分量製相似的膏油；這膏油是聖的，你們也要以它為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","無論誰配製相似的膏油，或把這膏油抹在外人的身上，這人就一定要從他的族人中被剪除。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","耶和華對摩西說：“你要取芬芳的香料，就是蘇合香、香錠、白松香；這芬芳的香料和純淨的乳香，各樣都要分量相等。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","你要照著香膏配製師的方法，用這些加上鹽調和製成香，是清淨聖潔的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","你要取一部分香，把它研成碎末，放在會幕裡法櫃前，就是我要與你相會的地方。你們要以這香為至聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","你所製的香，你們不可按著它的分量為自己配製；你要以這香為聖歸給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","無論誰製香和這香相似，為要聞香的味道的，這人就一定要從他的族人中被剪除。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“看哪，猶大支派中戶珥的孫子，烏利的兒子比撒列，我已經提名召他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","我也用　神的靈充滿了他，使他有智慧，有聰明，有知識，有能力作各樣的手工， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","可以設計巧工，可以用金、銀、銅製造各物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","又可以雕刻寶石，鑲嵌寶石；可以雕刻木頭，製造各樣巧工。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","看哪，我已經指派但支派中亞希撒抹的兒子亞何利亞伯和他同工；所有心裡有智慧的人，我也把智慧賜給他們，使他們可以作我吩咐你的一切工作， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","就是會幕、法櫃和櫃上的施恩座，以及會幕中一切的器具、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","桌子和桌子上的器具，純金的燈臺和燈臺上的一切器具、香壇、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","燔祭壇和壇上的一切器具、洗濯盆和盆座、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","彩衣和亞倫祭司的聖衣，以及他兒子們供祭司職分的衣服、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","膏油和聖所使用的芬芳的香，他們都要照著我吩咐你的一切去作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“你要吩咐以色列人說：你們務要守我的安息日，因為這是你我之間世世代代的記號，使你們知道我耶和華是把你們分別為聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","所以你們應該守安息日，因為這是你們的聖日；凡是違反這日的，必要把他處死；凡是在這日工作的，那人必要從他的族人中被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","六日可以工作，但第七日是歇工的安息日，是歸耶和華為聖的，凡是在這安息日工作的，必須把那人處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","所以，以色列人要守安息日，他們世世代代要遵行安息日的規例，作為永遠的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","這是我和以色列人中間永遠的記號，因為六日之內耶和華創造了天地，但第七日就歇了工休息了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","耶和華在西奈山上與摩西說完了話，就把兩塊法版交給他，是　神用指頭寫的石版。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","人民見摩西遲遲不下山，就聚集到亞倫那裡去，對他說：“起來，為我們做神像可以走在我們前頭領路，因為那摩西，就是把我們從埃及地領出來的那個人，我們不知道他遭遇了甚麼事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","亞倫對他們說：“把你們妻子和兒女戴在耳上的金環摘下來，送來給我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","全體人民就把他們耳上的金耳環都摘下來，送來給亞倫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","亞倫從他們手中接過來，用雕刻的工具雕刻，鑄造了一個牛像；他們就說：“以色列啊，這就是你們的神，就是把你從埃及地領出來的那位。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","亞倫看見了，就在牛像面前築了一座祭壇，並且宣告，說：“明日是耶和華的節日。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","次日清早，人民起來，就獻上了燔祭，也帶來了平安祭；然後他們坐下吃喝，起來玩樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","耶和華對摩西說：“你下山去吧，因為你的人民，就是你從埃及地領出來的，已經敗壞了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","他們很快就偏離了我吩咐他們的道路，為自己鑄造了一個牛像，向它跪拜，向它獻祭，說：‘以色列啊，這就是你的神，就是把你從埃及地領出來的那位。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","耶和華對摩西說：“我看這人民，真是硬著頸項的人民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","現在，你且由得我，讓我向他們發烈怒，把他們消滅；我要使你成為大國。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","摩西就懇求耶和華他的　神施恩，說：“耶和華啊，你為甚麼向你的人民發烈怒呢？這人民是你用大能和全能的手從埃及地領出來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","為甚麼讓埃及人議論，說：‘把他們領出來是出於惡意的，要在山上殺死他們，在地上消滅他們’呢？求你回心轉意，不發烈怒；求你改變初衷，不降禍給你的人民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","求你記念你的僕人亞伯拉罕、以撒、雅各；你曾經指著自己向他們起誓，說：‘我必使你的後裔增多，好像天上的星一樣；我必把我應許的這全地賜給你的後裔，他們必永遠承受這地作產業。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","於是，耶和華改變初衷，不把他所說的禍降在他的人民身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","摩西轉身，從山上下來，手裡拿著兩塊法版；法版是兩面寫的，這面和那面都寫著字。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","法版是　神的工作，字是　神寫的，刻在法版上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","約書亞聽見人民呼喊的聲音的時候，就對摩西說：“營裡有戰爭的聲音。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","摩西回答：“這不是戰勝的呼聲，也不是戰敗的呼聲；我聽見的是歌唱的聲音。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","摩西走近營前的時候，看見了那牛犢，又看見了有人唱歌跳舞，他就發烈怒，把兩塊法版從他的手中摔掉，在山下把它們摔碎了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","又把他們所做的那牛犢拿過來，用火焚燒，磨到粉碎，撒在水面上，讓以色列人喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","摩西對亞倫說：“這人民向你作了甚麼，你竟使他們陷在大罪裡呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","亞倫回答：“求我主不要發烈怒，你知道這人民傾向罪惡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","他們對我說：‘給我們做神像，可以在我們前面引路，因為那摩西，就是把我們從埃及地領出來的那個人，我們不知道他遭遇了甚麼事。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","我對他們說：‘凡是有金子的，都可以摘下來’，他們就給了我；我把它丟在火裡，這牛犢就出來了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","摩西看見人民放肆原來是亞倫縱容他們，使他們成為那些起來與他們為敵的人的笑柄， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","就站在營門中，說：“凡是屬耶和華的，都可以到我這裡來。”於是，所有利未的子孫都到他那裡聚集。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","摩西對他們說：“耶和華以色列的　神這樣說：‘你們各人要把自己的劍佩在大腿上，在營中往來行走，從這門到那門；你們各人要殺自己的兄弟、鄰舍和親人。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","利未的子孫照著摩西的話作了；那一天，人民中被殺的約有三千人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","摩西說：“今天你們要奉獻自己歸耶和華為聖，因為各人犧牲了自己的兒子和兄弟，好使耶和華今天賜福給你們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","第二天，摩西對人民說：“你們犯了大罪，現在我要上耶和華那裡去，或者我可以為你們贖罪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","於是，摩西回到耶和華那裡，說：“唉，這人民犯了大罪，為自己做了金神像。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","現在，如果你肯赦免他們的罪，那就好了；如果不肯，求你從你所寫的冊上把我塗抹吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","耶和華對摩西說：“誰得罪了我，我就要從我的冊上把誰塗抹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","現在你去吧，領這人民到我吩咐你的地方去。看哪，我的使者必在你前面引路；只是在我追討的日子，我必追討他們的罪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","耶和華擊殺人民是因為他們敬拜亞倫做的牛犢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","耶和華對摩西說：“你和你從埃及地領出來的人民要離開這裡，上我曾經起誓應許給亞伯拉罕、以撒、雅各的地去，我曾應許：‘我要把這地賜給你的後裔。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","我要差派使者在你前面；我要把迦南人、亞摩利人、赫人、比利洗人、希未人、耶布斯人趕出去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","你們要上那流奶與蜜的地方去；我不與你們一同上去，因為你們是硬著頸項的人民，免得我在路上把你們消滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","人民一聽見這凶信，就悲傷起來，也沒有人穿戴裝飾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","耶和華對摩西說：“你要對以色列人說：‘你們是硬著頸項的民；我若是霎時間與你們同行，我會把你們消滅的；所以，現在你們要把你們身上的裝飾脫下來，使我知道我要怎樣處置你們。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","於是，以色列人從何烈山以後，就把身上的裝飾脫下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","摩西一向把會幕支搭在營外，離營遠些；摩西稱它為會幕。凡是尋求耶和華的，就出到營外的會幕那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","摩西出營到會幕去的時候，全體的人民都起來，各人站在自己帳幕的門口，望著摩西，直到他進了會幕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","摩西進會幕的時候，就有雲柱降下來，停在會幕門口上面；耶和華就與摩西談話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","全體的人民看見了雲柱停在會幕門口上面，就都起來，各人在自己帳幕的門口下拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","耶和華與摩西面對面說話，好像人對朋友說話一樣。然後，摩西回到營裡去，只有他的侍從，一個少年人，就是嫩的兒子約書亞，不離開會幕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","摩西對耶和華說：“看，你吩咐我說：‘把這百姓領上去’，可是你卻沒有讓我知道你要差派誰與我同去；只是你曾經說過：‘我按著你的名字認識你，你在我眼前也蒙了恩。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","現在我若是在你眼前蒙恩，求你把你的道路指示我，使我可以認識你，可以在你眼前蒙恩；也求你想到這民族是你的人民。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","耶和華說：“我必親自與你同去，也必給你安息。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","摩西對他說：“你若是不親自與我們同去，就不要把我們從這裡領上去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","人在甚麼事上可以知道我和你的人民在你眼前蒙恩呢？不是因為你與我們同去，使我和你的人民可以和地上所有的人有分別嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","耶和華對摩西說：“你所說的這件事我也要作，因為你在我眼前蒙恩，並且我按著你的名字認識了你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","摩西說：“求你給我看看你的榮耀。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","耶和華說：“我要使我的一切美善都在你面前經過，並且要把我的名字耶和華在你面前宣告出來；我要恩待誰，就恩待誰；我要憐憫誰，就憐憫誰。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","他又說：“你不能看我的臉，因為沒有人看見了我還能活著。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","耶和華說：“看哪，我這裡有個地方，你要站在磐石上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","我的榮耀經過的時候，我要把你放在磐石隙中，我要用我的手掌遮蓋你，直到我過去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","然後，我要收回我的手掌，你就會看見我的背後，卻不能看見我的臉。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","耶和華對摩西說：“你要鑿出兩塊石版，好像先前的一樣，我要把先前寫在你摔碎了的石版上的字寫在這兩塊石版上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","早晨之前，你要預備好了；到早晨的時候，你要上到西奈山來，在山頂上站在我面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","誰也不准同你一起上來，整個山都不准有人出現，也不准牛羊在這山前吃草。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","摩西就鑿了兩塊石版，好像先前的一樣。他一早起來，照著耶和華吩咐他的，上到西奈山去，手裡拿著兩塊石版。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","耶和華在雲彩中降下來，與摩西一同站在那裡，並且宣告耶和華的名字。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","耶和華在摩西面前經過，並且宣告說：“耶和華，耶和華，是有憐憫有恩典的　神，不輕易發怒，並且有豐盛的慈愛和誠實， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","為千千萬萬人留下慈愛，赦免罪孽、過犯和罪惡。一定要清除罪，追討罪孽自父及子至孫，直到三四代。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","摩西急忙俯首在地敬拜， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","說：“主啊，我若是在你眼前蒙恩，求我主與我們同行，因為這是硬著頸項的人民。又求你赦免我們的罪孽和我們的罪惡，把我們當作你的產業。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","耶和華說：“看哪，我要立約，我要在你全體的人民面前作奇妙的事，是在全地萬國中沒有行過的。在你四周的萬民都必看見耶和華的作為，因為我向你所行的是可畏懼的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","我今天吩咐你的，你務要遵守。看哪，我要把亞摩利人、迦南人、赫人、比利洗人、希未人、耶布斯人，從你面前趕逐出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","你要小心，不可與你所去的那地的居民立約，恐怕這事在你中間成為陷阱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","他們的祭壇你們卻要拆毀，他們的柱像你們要打碎，他們的亞舍拉你們要砍下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","你不可敬拜別的神，因為耶和華是忌邪的　神，他名為忌邪者。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","恐怕你與那地的居民立約，他們隨從自己的神行邪淫，給自己的神獻祭的時候，有人叫你，你就吃他的祭物； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","又恐怕你給你的兒子娶他們的女兒為妻，他們的女兒隨從自己的神行邪淫的時候，使你的兒子也隨從她們的神行邪淫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","你不可為自己鑄造神像。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“你要守除酵節，要照著我吩咐你的，在亞筆月內所定的時期吃無酵餅七天，因為你是在亞筆月從埃及出來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","凡是頭胎的都是我的；你的牲畜中，無論是牛或羊，凡是公的和頭生的，都是我的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","頭生的驢，你要用羊代贖，如果不代贖，就要打斷牠的頸項。你所有頭胎的兒子，你都要代贖出來。沒有人可以空手見我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“你六日要工作，但第七天你要休息，在耕種和收割的時候，也要休息。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","在收割初熟麥子的時候，你要守七七節；在年底，你要過收割節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","你所有的男子，都要一年三次去見主耶和華以色列的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","我要把列國從你面前趕出去，擴張你的境界；你一年三次上去面見耶和華你的　神的時候，必沒有人貪圖你的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“你不可把我祭物的血和有酵的餅一同獻上，逾越節的祭物也不可留到早晨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","你要把你地裡最早生產的初熟之物送到耶和華你的　神的殿裡。不可用羊羔母的奶去煮羊羔。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","耶和華對摩西說：“你要把這些話寫上，因為我是按著這些話與你和以色列人立約的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","摩西在那裡與耶和華在一起共四十晝夜，不吃飯，也不喝水。他把這約的話寫在兩塊版上，這就是十誡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","摩西從西奈山下來的時候，手裡拿著兩塊法版；摩西從山上下來的時候，不知道自己的臉皮因為與耶和華談過話而發光。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","亞倫和全體以色列人看見了摩西，見他臉上發光，就害怕接近他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","摩西叫他們過來，於是，亞倫和會眾中所有的首領才回到摩西那裡去，摩西就與他們談話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","以後，全體以色列人都近前來，摩西就把耶和華在西奈山上與他所說的一切話都吩咐他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","摩西和他們說完了話，就用帕子蒙上自己的臉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","每逢摩西進到耶和華面前與他談話的時候，就把帕子揭去，直到他出來。他出來了，就把耶和華吩咐他的對以色列人說。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","以色列人看見摩西的臉，見他的臉皮發光。摩西再用帕子蒙上自己的臉，直到他進去和耶和華說話為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","摩西召集了以色列全體會眾，對他們說：“這就是耶和華吩咐的話，要你們遵行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","六日要工作，但第七日是你們的聖日，要歸耶和華為休息的安息日。凡是在這日工作的，必須把他處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","在安息日，不可在你們任何的住處生火。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","摩西告訴以色列全體會眾說：“耶和華吩咐的是這樣，他說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘你們要從你們中間拿禮物來給耶和華，凡是甘心樂意的，都可以把耶和華的禮物帶來，就是金、銀、銅、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","藍色紫色朱紅色線、細麻、山羊毛、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","染紅的公羊皮、海狗皮、皂莢木、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","燈油，以及作膏油和芬芳的香的香料、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","紅瑪瑙寶石，以及可以鑲嵌在以弗得和胸牌上的寶石。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“‘你們中間凡是心裡有智慧的都要來，做耶和華吩咐的一切， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","就是做帳幕、帳幕的棚罩、帳幕的蓋、鉤子、木板、橫閂、柱子、帳幕的座、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","櫃、櫃槓、施恩座、遮蓋至聖所的幔子、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","桌子、桌子的槓、桌子的一切器具、陳設餅、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","燈臺、燈臺的器具、燈盞、燈油、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","香壇、香壇的槓、膏油、芬芳的香、帳幕門口的門簾、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","燔祭壇、壇的銅網、壇槓、壇的一切器具、洗濯盆、盆座、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","院子的帷子、帷子的柱子、帷子的座、院子的門簾、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","帳幕的釘子、院子的釘子，以及這兩處的繩子、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","在聖所供職用的彩衣、祭司亞倫的聖衣和他兒子供祭司職用的衣服。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","以色列全體會眾從摩西面前離去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","凡是心裡受感、靈裡樂意的，都來了；他們把耶和華的禮物都帶來了，用作會幕的工程和會幕中的一切使用，又用來做聖衣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","凡是甘心樂意的，不論男女，都來了，把金針、耳環、戒指、手釧和各樣的金器都送來。他們各人都把金子作禮物呈獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","凡是有藍色紫色朱紅色線、細麻、山羊毛、染紅的公羊皮、海狗皮的，都送了來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","凡是奉獻銀子和銅為禮物的，都帶了來作耶和華的禮物；凡是有皂莢木可以用作工程上任何使用的，都帶了來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","凡是心中有智慧的婦女都親手紡織，把所紡的藍色紫色朱紅色線都帶了來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","凡是有心意又有智慧的婦女，都紡山羊毛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","首領把紅瑪瑙寶石，以及可以鑲嵌在以弗得和胸牌上的寶石都帶了來； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","又帶來了香料、點燈用的油、膏油、芬芳的香。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","以色列人無論男女，凡是甘心樂意為作耶和華藉摩西吩咐的一切工程的，都把自願奉獻的禮物帶了來獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","摩西對以色列人說：“看哪，猶大支派中戶珥的孫子、烏利的兒子比撒列，耶和華已經提名召他， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","又用　神的靈充滿他，使他有智慧，有聰明，有知識，有作一切巧工的技能。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","能巧設圖案，用金、銀、銅製造各物； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","又能雕刻寶石，用來鑲嵌；又能雕刻木頭，用來製造各種巧工。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","耶和華又賜給他和但支派中亞希撒抹的兒子亞何利亞伯，心裡有教導人的恩賜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","耶和華又用智慧充滿他們的心，使他們能作各種工作，雕刻的工，設圖案的工，用藍色紫色朱紅色線和細麻刺繡的工，以及編織的工。他們能作各種工程，也能巧設圖案。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","比撒列和亞何利亞伯，以及心裡有智慧的，就是蒙耶和華賜與智慧與聰明，使他們知道怎樣製造供聖所使用的一切工程的人，都照著耶和華吩咐的一切去作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","於是，摩西把比撒列和亞何利亞伯，以及心裡有智慧的，就是蒙耶和華賜他們心裡有智慧的人，凡是心裡受感要前來作這工的人，都召了來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","他們當著摩西面前，接收了以色列人為供聖所使用的工程帶來的一切禮物。他們天天早晨還把自願奉獻的禮物帶到摩西那裡來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","凡是作聖所一切工的智慧人，各人都放下自己所作的工，來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","他們告訴摩西：“人民帶來的太多，超過耶和華吩咐所作工程使用的需要。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","於是摩西下令，他們就在營中宣告，說：“無論男女都不必再為聖所的工程奉獻甚麼禮物。”這樣，人民才被攔阻，不送甚麼禮物來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","因為所有的材料夠作一切工程，而且有餘。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","在作這工程的人中，凡是心裡有智慧的，用十幅幔子作帳幕；這些幔子是用撚的細麻、藍色紫色朱紅色線做的，並且用設計的巧工繡上基路伯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","每一幅幔子長十二公尺，每一幅幔子寬兩公尺，所有的幔子都是一樣的尺寸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","他把五幅幔子一一相連；也使另外五幅幔子一一相連。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","在第一組相連的幔子末幅的邊緣上，他做藍色的鈕扣；在另一組相連的幔子末幅的邊緣上，他也照樣作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","在這一幅幔子上，他做了五十個鈕扣；在第二幅相連的幔子的邊緣上，他也做了五十個鈕扣，這些鈕扣都彼此相對。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","又做了五十個金鉤，用鉤子使幔子彼此相連。這樣就成了一個帳幕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","他又用山羊毛做了幔子，作為帳幕上的罩棚，共做了十一幅幔子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","每一幅幔子長十三公尺，寬兩公尺，十一幅幔子都是一樣的尺寸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","他把五幅幔子相連在一起，又把另外六幅幔子相連在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","在第一組相連的幔子末幅的邊緣上，做了五十個鈕扣；在第二組相連的幔子末幅的邊緣上，也做了五十個鈕扣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","又做了五十個銅鉤，使罩棚相連，可以成為一個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","用染紅的公羊皮做了罩棚的蓋，又用海狗皮做蓋，放在罩棚的蓋上面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","他替帳幕用皂莢木做了豎板。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","每塊板長四公尺，寬六十六公分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","每塊板有兩個榫頭，彼此相連接；帳幕一切木板，他都這樣做。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","他為帳幕做板，給南邊，就是向南的方向做了二十塊板。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","在這二十塊板底下，做了四十個銀座；這塊板底下的兩個銀座用來連接板的兩個榫頭，那塊板底下的兩個銀座用來連接它的兩個榫頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","他為帳幕的第二邊，就是北面，也做了二十塊板， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","和四十個銀座；這一塊板底下有兩個銀座，那一塊板底下也有兩個銀座。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","帳幕的後面，就是西面，做了六塊板。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","他替帳幕後面兩個角上做了兩塊板。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","板的下截是雙的，直到上面的第一個環才接合完整；他把兩塊板都這樣做了，形成兩個角。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","所以共有八塊板，十六個銀座。每一塊板底下都有兩個銀座。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","他又用皂莢木做了橫閂，替帳幕這一邊的板做了五個橫閂， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","替帳幕第二邊的板也做了五個橫閂，替帳幕後面，就是西面的板也做了五個橫閂， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","他又做了中間的橫閂，穿過板腰，從這一端穿到那一端。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","他用金子把板包裹，也做了板上的金環，用作穿橫閂的地方，並且也用金子把橫閂包裹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","他用藍色紫色朱紅色線和撚的細麻做了一幅幔幕，用巧設的圖案手工繡上基路伯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","他替幔幕做了四根皂莢木柱子，用金子包裹，柱釘是金的，又替柱子鑄造四個銀座。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","又用藍色紫色朱紅色線和撚的細麻，用繡花的手工做成帳幕的門簾； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","又為門簾做了五根柱子和柱子上的釘子，用金子把柱頂和橫杆包裹。但那五個座是銅的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","比撒列用皂莢木做了一個櫃，長一百一十公分，寬六十六公分，高六十六公分， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","用純金把櫃裡外都包裹了，替櫃的四周做了金牙邊， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","又鑄造了四個金環，安放在櫃的四腳上，這一邊兩個環，那一邊兩個環。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","又用皂莢木做了兩根櫃槓，包上黃金。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","把槓穿在櫃旁的環內，可以抬櫃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","又用純金做施恩座，長一百一十公分，寬六十六公分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","又用黃金做了兩個基路伯，是從施恩座的兩端用鎚錘成的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","這端一個基路伯，那端一個基路伯；他在施恩座的兩端做了兩個基路伯，和施恩座連在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","兩個基路伯高展著翅膀，用它們的翅膀遮掩著施恩座，它們的臉彼此相對；基路伯的臉都對著施恩座。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","他又用皂莢木做了一張桌子，長八十八公分，寬四十四公分，高六十六公分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","用純金把桌子包裹，替桌子的四周做了金牙邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","又替桌子的四周做了七十五公釐寬的框子；框子的四周又做了金牙邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","又替桌子鑄造四個金環，把環子安放在桌子四腳的四角上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","環子靠近框子，是穿槓的地方，可以抬桌子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","又用皂莢木做了兩根槓，用金子把槓包裹，可以抬桌子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","又用純金做桌子的器皿，就是盤子、碟子、碗和奠酒用的杯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","他用純金做了一個燈臺，他用鎚錘成燈臺；燈臺的座和幹，跟杯、球、花，都是連在一起的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","燈臺的兩邊伸出六個枝子，這一邊有三個燈臺枝子，那一邊也有三個燈臺枝子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","在這一個枝子有三個杯，形狀好像杏花，有球、有花；在那一個枝子上也有三個杯，形狀好像杏花，有球、有花。從燈臺那裡伸出來的六個枝子都是這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","燈臺上有四個杯，形狀好像杏花，有球、有花； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","從燈臺伸出的每兩個枝子以下都有一個球，燈臺的六個枝子都是這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","這些球和枝子都是連在一起的，全都是一塊純金錘成的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","又用純金做燈臺的七個燈盞、燭剪和蠟花盤碟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","他用了三十五公斤純金做燈臺和燈臺的一切器具。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","他用皂莢木做了一座香壇，長四十四公分，寬四十四公分，是正方形的，高八十八公分；壇的四角是與壇連在一起的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","又用純金把壇包裹，壇頂、壇的四邊和壇的四角都包裹，又替壇做了金牙邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","又替壇做了兩個金環，安放在牙邊以下，壇的兩側，就是壇的兩旁，作穿槓的地方，用來抬壇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","用皂莢木做了兩根槓，用金包裹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","又按著製香料者的製法，製聖膏油以及芬芳的純香。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","他用皂莢木做燔祭壇，長兩公尺兩公寸，寬兩公尺兩公寸，成正方形，高一公尺三公寸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","在壇的四個拐角做了四隻角，角是與壇連在一起的；又用銅把壇包裹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","又做壇上的一切器具，就是盆、鏟、盤、肉叉和火盆；壇上的一切器具都是用銅做的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","又替壇做一個銅網，放在壇的圍腰板以下，向下直到壇的半腰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","又鑄造四個環，放在銅網的四端之上，用作抬壇的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","他用皂莢木做兩根槓，用銅包裹， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","把槓穿在壇兩側的環裡，用來抬壇；壇是用木板做的，是空的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","他用銅做洗濯盆，又用銅做盆座，是用那些在會幕門口服事的婦女的銅鏡做成的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","他又做院子；南面，就是向南的方向，用撚的細麻做院子的幔幕，共四十四公尺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","幔幕的柱子有二十根，柱座有二十個，是銅做的；柱鉤和橫柱閂是銀做的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","北面，有幔幕四十四公尺，幔幕的柱子有二十根，柱座有二十個，是銅做的；柱鉤和橫柱閂是銀做的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","西面，有幔幕二十二公尺，幔幕的柱子有十根，柱座有十個；柱鉤和橫柱閂是銀做的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","東面，就是日出的方向，有幔幕二十二公尺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","門口這一邊有幔幕六公尺六公寸；幔幕的柱子有三根，柱座有三個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","門口那一邊也是這樣。院子門口的兩邊各有幔幕六公尺六公寸；幔幕的柱子有三根，柱座有三個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","院子周圍的一切幔幕都是用撚的細麻做的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","柱座是銅做的，柱鉤和橫柱閂是銀做的，柱頂是用銀包裹的；院子的一切柱子都是用銀橫閂相連起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","院子的門簾，是用藍色紫色朱紅色線和撚的細麻，以及刺繡的手工做成的；長九公尺，以寬度來說，兩公尺高，與院子的幔幕相配。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","幔幕的柱子有四根，柱座有四個，是銅做的；柱鉤是銀做的，柱頂和橫柱閂是用銀包裹的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","帳幕的一切釘子和院子四周的一切釘子，都是銅做的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","這是帳幕（就是法櫃的帳幕）內利未人使用的物件的總數，是照著摩西的吩咐，經亞倫祭司的兒子以他瑪的手計算的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","凡是耶和華吩咐摩西的，猶大支派戶珥的孫子、烏利的兒子比撒列都做了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","與他同工的，有但支派亞希撒抹的兒子亞何利亞伯，是個雕刻匠、圖案設計家，以及能用藍色紫色朱紅色線和細麻刺繡的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","用來建造聖所整個工程使用的一切黃金，就是獻作禮物的金子，按照聖所的標準，共有一千公斤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","會眾中被數點的人所出的銀子，按照聖所的標準，共有三千四百三十公斤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","凡是按著次序被數點的人，從二十歲以上的，有六十萬三千五百五十人，按著聖所的標準，每人納銀六克。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","他用這三千四百公斤銀子鑄造聖所的柱座，和幔子的柱座；一百個柱座用了三千四百公斤銀子，三十四公斤銀子做一個柱座。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","他用三十公斤銀子做柱鉤，包裹柱頂，以及為柱頂做橫柱閂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","獻作禮物的銅有二千四百二十五公斤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","他用這些銅做會幕門口的柱座、銅壇和壇上的銅網，以及壇上的一切器具、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","院子四周的柱座、院子門口的柱座、帳幕的一切釘子和院子四周的一切釘子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","他們用藍色紫色朱紅色線做彩衣，在聖所供職時穿著；又照著耶和華吩咐摩西的，為亞倫做聖衣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","又用金線、藍色紫色朱紅色線和撚的細麻做以弗得。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","他們把金子錘成薄片，剪成細線，用巧工織在藍色紫色朱紅色線和細麻之中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","又為以弗得做相連的肩帶，把以弗得的兩端連接起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","上面的帶子，做法好像以弗得一樣，與以弗得連在一起，都用金線、藍色紫色朱紅色線和撚的細麻做的，是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","他們預備了兩塊紅瑪瑙寶石，鑲嵌在金槽裡，又用刻圖章的方法刻上以色列眾子的名字， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","把這兩塊寶石放在以弗得的兩條肩帶上，作以色列人的記念石，是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","他又用巧設的圖案手工做胸牌，像做以弗得一樣，用金線、藍色紫色朱紅色線和撚的細麻做的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","胸牌是正方形的；他們把胸牌做成雙層，長二十二公分，寬二十二公分，是雙層的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","又把四行寶石鑲在上面，一行是紅寶石、黃玉、翡翠，這是第一行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","第二行是紫寶石、藍寶石、金鋼石。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","第三行是黃瑪瑙、白瑪瑙、紫晶。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","第四行是水蒼玉、紅瑪瑙、碧玉；這些寶石都是鑲在金槽裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","這些寶石代表以色列眾子的名字，共有十二塊；用刻圖章的方法，每塊刻上一個名字，十二塊代表十二個支派。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","又在胸牌上用純金做鍊子，像擰繩子一般做成。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","又做兩個金槽和兩個金環，把兩個金環安放在胸牌的兩端， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","把那兩條金繩穿在胸牌兩端的環子裡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","又把金繩的另兩端接在兩槽上，再把它們連在以弗得前面的肩帶上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","他又做兩個金環，安放在胸牌的兩端，在胸牌的兩邊，就是在以弗得裡面的邊上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","他又做兩個金環，安放在以弗得前面兩條肩帶的下邊，靠近相連的地方，在以巧工做成的以弗得的肩帶上面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","他們用藍色細帶子把胸牌繫住，就是把胸牌的環子和以弗得的環子繫在一起，使胸牌可以貼在以巧工織成的以弗得的帶子上，免得胸牌從以弗得上脫落，這是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","又做以弗得的外袍，是織成的，全件是藍色的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","在外袍的中間有一領口，如同戰袍的領口，領口的周圍有領邊，免得領口破裂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","又在外袍的底邊上，用藍色紫色朱紅色線和撚的細麻做石榴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","他又用純金做鈴鐺，把金鈴安放在石榴中間，就是安放在外袍周圍底邊上的石榴中間： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","一個金鈴，一個石榴，一個金鈴，一個石榴，在外袍周圍的底邊上，在供職時穿用；都是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","他又用織成的細麻布替亞倫和他的兒子做內袍， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","並且用細麻做禮冠，用細麻做頭巾，用撚的細麻做細麻布褲子， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","以及用撚的細麻和藍色紫色朱紅色線，用刺繡的手工做腰帶；都是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","他們用純金做聖冠上的牌子，又用刻圖章的方法，在上面刻著“歸耶和華為聖”的字樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","又用一條藍色細帶子把牌子繫住，繫在禮冠的上面，都是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","於是，帳幕，就是會幕的一切工程都完成了；凡是耶和華吩咐摩西的，以色列人都照著作了；這樣，他們就作完了會幕的一切工程。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","他們把帳幕、會幕和會幕的一切器具都帶到摩西那裡，就是鉤子、木板、橫閂、柱子、柱座、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","染紅公山羊皮的蓋、海狗皮的蓋和遮蓋至聖所的幔子、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","法櫃、櫃槓和施恩座， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","桌子、桌子上的一切器具和陳設餅， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","純金的燈臺與燈盞，就是擺列在燈臺上的燈盞和燈臺上的一切器具，以及點燈用的油； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","金壇、膏油、芬芳的香和會幕的門簾； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","銅壇、壇上的銅網、壇槓、壇上的一切器具、洗濯盆和盆座； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","院子的幔幕、柱子、柱座、院子的門簾、繩子、釘子和帳幕，以及會幕一切使用的器具； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","在聖所供職用的彩衣、祭司亞倫的聖衣和他兒子供祭司職的衣服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","這一切工作，耶和華怎樣吩咐摩西，以色列人就怎樣作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","摩西查看了一切工作，見他們所作的，完全是耶和華吩咐的，就給他們祝福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","耶和華告訴摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“正月初一日，你要把會幕的帳幕豎立起來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","把法櫃安放在裡面，用幔子把法櫃遮蓋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","把桌子搬進去，擺上陳設物；把燈臺也搬進去，把燈臺上的燈盞點著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","把燒香用的金壇安放在法櫃前，掛上帳幕的門簾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","把燔祭壇安放在會幕的帳幕門口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","把洗濯盆安放在會幕和祭壇的中間，把水盛在盆裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","又在周圍豎立院子的幔幕，把院子的門簾掛上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","你要拿膏油來，抹帳幕和其中的一切器具，使帳幕和帳幕的一切器具成聖，就必成聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","又要抹燔祭壇和壇上的一切器具，使壇成聖，壇就必成為至聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","要抹洗濯盆和盆座，使它成聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","要把亞倫和他的眾子帶到會幕的門口來，用水給他們洗身。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","要把聖衣給亞倫穿上，又膏抹他，使他成聖，可以作我的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","你要把亞倫的兒子帶來，給他們穿上內袍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","要膏抹他們好像膏抹他們的父親一樣，使他們可以作祭司服事我；他們的膏抹使他們世世代代永遠當祭司之職。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","摩西就這樣作了；凡是耶和華吩咐他的，他都作了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","第二年正月初一日，帳幕就豎立起來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","摩西豎立起帳幕，安上柱座，放上木板，安上橫閂，豎立柱子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","把罩棚鋪在帳幕上面，又把罩棚的上蓋放在上面；都是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","摩西拿了法版，放在櫃裡，把槓穿在櫃的兩旁，把施恩座安放在約櫃上面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","把約櫃抬進帳幕裡去，掛上遮蓋至聖所的幔子，把法櫃遮蓋著，是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","又把桌子安放在會幕裡，放在帳幕的北面，幔子的外面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","在桌子上把陳設餅擺在耶和華面前，都是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","摩西把燈臺設立在會幕裡，在帳幕的南面，與桌子相對。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","在耶和華面前把燈盞點著，是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","把金壇安設在會幕裡，幔子的前面； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","在壇上焚燒芬芳的香，是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","又掛上帳幕的門簾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","把燔祭壇安放在會幕的帳幕門口，把燔祭和素祭獻在壇上；是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","又把洗濯盆安放在會幕與祭壇之間，盆裡盛水，作洗濯之用； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","摩西、亞倫和亞倫的兒子，可以在這盆裡洗手洗腳。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","每逢他們走進會幕，或是走近祭壇的時候，就要先洗濯；是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","摩西在帳幕和祭壇的周圍，豎立起院子的幔幕，又掛上院子的門簾。這樣摩西就完成了工程。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","當時，有雲彩遮蓋會幕，耶和華的榮耀充滿了帳幕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","摩西不能進入會幕，因為雲彩停在會幕上面，並且耶和華的榮耀充滿著帳幕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","在以色列人所有的旅程中是這樣的：每逢雲彩從帳幕收上去的時候，他們就起程； ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","雲彩若是不收上去，他們就不起程，直到雲彩收上去的日子為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","因為以色列人所有的旅程中，日間有耶和華的雲彩在帳幕上，夜間雲中有火，顯在以色列全家的眼前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","耶和華呼叫摩西，從會幕裡對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“你要告訴以色列人說：如果你們中間有人把供物獻給耶和華，就要從牛群羊群中獻家畜為供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","他的供物若是獻牛作燔祭，就要把一頭沒有殘疾的公牛，牽到會幕門口，就可以在耶和華面前蒙悅納。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","他要按手在燔祭牲的頭上，燔祭就蒙悅納，可以為他贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","他要在耶和華面前宰殺那公牛，亞倫子孫作祭司的，要奉上血，潑在會幕門口祭壇的四周。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","那人要剝去燔祭牲的皮，把燔祭牲切成塊子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","亞倫子孫作祭司的，要把炭火放在祭壇上，把柴排列在火上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","亞倫子孫作祭司的，要把肉塊和頭，以及脂肪，排列在祭壇炭火上的木柴上面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","那人又要用水洗淨內臟和腿；祭司就把這一切全獻在祭壇上焚燒，作為燔祭，就是獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“人的供物若是獻羊作燔祭，不論是綿羊或是山羊，總要獻一隻沒有殘疾的公羊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","他要在耶和華面前，在祭壇的北面，把羊宰殺；亞倫子孫作祭司的，要把羊血潑在祭壇的四周。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","那人要把燔祭牲切成塊子；祭司就把肉塊、頭和脂肪，排列在祭壇炭火上的木柴上面； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","那人又要用水洗淨內臟和腿，祭司就把這一切全獻在祭壇上焚燒，作為燔祭，就是獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“人若是獻鳥類為燔祭作耶和華的供物，就要獻斑鳩或雛鴿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","祭司要把鳥帶到祭壇那裡，扭下牠的頭來，焚燒在祭壇上；又把鳥血擠出來，流在祭壇的壁上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","又要除掉鳥的嗉囊和髒物，丟在祭壇東邊，倒灰的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","然後要拿著兩個翅膀把鳥撕裂，只是不可撕斷。祭司要把牠放在祭壇，在炭火上的木柴上面焚燒，作為燔祭，就是獻給耶和華馨香的火祭。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“如果有人獻素祭為供物給耶和華，他的供物要用細麵；他要澆上油，加上乳香， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","帶到亞倫子孫作祭司的那裡，祭司就從其中取出一把澆了油的細麵，連同所有的乳香，作供物的象徵，焚燒在祭壇上，這是獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","祭餘剩的，要歸給亞倫和他的子孫；這是獻給耶和華的火祭中至聖之物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“如果你獻爐裡烤的物作素祭的供物，就要用細麵調油所做的無酵餅，或是抹上油的無酵薄餅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","你的供物若是用煎盤上做的物作素祭，就要用調油的無酵細麵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","你要把它擘成碎塊，澆上油；這是素祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","你若是用淺鍋中煎的物作素祭的供物，就要用細麵調油做成。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","你要把這些東西做好，作獻給耶和華的素祭，奉給祭司，讓他帶到祭壇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","祭司要從素祭中舉起象徵的部分，焚燒在祭壇上，作獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","素祭餘剩的，要歸給亞倫和他的子孫；這是獻給耶和華的火祭中至聖之物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“你們獻給耶和華的一切素祭，都不可發酵，因為任何酵與蜜，你們都不可焚燒作獻給耶和華的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","你們可以把它們獻給耶和華作初熟的供物；只是不可燒在祭壇上，作馨香的祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","你獻作素祭的一切供物，都要用鹽調和；在你的素祭上，不可缺少你　神立約的鹽；你的一切供物，都要用鹽調和獻上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“如果你把初熟之物作素祭獻給耶和華，就要獻上烘過的新麥穗，就是碾過的新穀粒，作素祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","你要澆上油，加上乳香，這是素祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","祭司要把供物的象徵部分，就是一部分碾過的麥粒和油，連同所有的乳香，一起焚燒，作獻給耶和華的火祭。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“人的供物若是作平安祭，如果獻的是牛，必須在耶和華面前獻一頭沒有殘疾的公牛或母牛； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","他要按手在他的供物的頭上，在會幕門口宰殺牠；亞倫子孫作祭司的，要把血潑在祭壇的四周。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","他要從平安祭中奉上獻給耶和華的火祭，就是把遮蓋內臟的脂肪，和內臟上的一切脂肪， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","兩腎和腎上近腰旁的脂肪，和腎旁的肝葉，一起取下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","亞倫的子孫要把這些放在祭壇炭火上的木柴上面，在燔祭上焚燒，作獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","人若是獻羊作平安祭的供物給耶和華，必須獻一隻沒有殘疾的公羊或母羊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","他獻的供物若是一隻綿羊羔，他要把牠牽到耶和華面前， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","按手在他的供物的頭上，在會幕門口宰殺牠；亞倫的子孫要把羊血潑在祭壇的四周。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","他要從平安祭中奉上獻給耶和華的火祭，就是把羊的脂肪，從靠近脊骨的地方取下來的整條肥尾巴，遮蓋內臟的脂肪和在內臟上的一切脂肪， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","兩腎和腎上近腰的脂肪，和腎旁的肝葉，一起取下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","祭司把這些焚燒在祭壇上，是獻給耶和華作食物的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“人的供物若是一隻山羊，就要把羊牽到耶和華面前， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","按手在羊頭上，然後在會幕門口宰殺牠；亞倫的子孫要把血潑在祭壇的四周， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","他要從供物中奉上獻給耶和華的火祭，就是把遮蓋內臟的脂肪和內臟上的脂肪， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","兩腎和腎上近腰的脂肪，和腎旁的肝葉，都要一起取下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","祭司把這些焚燒在祭壇上，獻給耶和華為食物作馨香的火祭。一切脂肪都是屬於耶和華的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","任何脂肪和血你們都不可吃。這是你們在一切住處一條世代永存的律例。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“你要告訴以色列人說：如果有人在耶和華吩咐不可行的事上無意犯了罪，他必須遵行以下條例中的一樣： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“如果受膏的祭司犯了罪，使人民陷在罪裡，他就要為自己所犯的罪，獻一頭沒有殘疾的公牛給耶和華作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","他要把公牛牽到耶和華面前，在會幕門口，按手在公牛頭上，然後在耶和華面前宰殺那公牛， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","受膏的祭司要取一些公牛的血，帶到會幕那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","祭司要把指頭蘸在血裡，在耶和華面前向著聖所的幔子，彈血七次。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","然後祭司要用血抹會幕裡耶和華面前的香壇的四角；至於其餘的牛血，都要倒在會幕門口的燔祭壇腳那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","他要取出贖罪祭的公牛所有的脂肪，就是遮蓋內臟的脂肪和內臟上的一切脂肪， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","兩腎和腎上近腰的脂肪，和腎旁的肝葉，都一起取下來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","正如從平安祭的公牛取出來的一樣。祭司要把這些焚燒在燔祭壇上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","至於公牛的皮和所有的肉，連頭帶腿，以及內臟和糞， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","就是整頭公牛，要搬到營外潔淨的地方，倒壇灰的地方，放在柴上用火焚燒，就在倒壇灰的地方焚燒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“如果以色列全體會眾無意犯罪，是隱而未現、會眾看不出來的，但他們行了一件耶和華吩咐不可行的事，他們就有罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","當發覺他們犯了罪的時候，會眾就要獻一頭公牛作贖罪祭，把牠牽到會幕前面； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","會眾的長老要在耶和華面前按手在公牛的頭上，然後在耶和華面前宰殺那公牛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","受膏的祭司要把公牛的一些血，帶到會幕那裡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","祭司要把指頭蘸在血裡，在耶和華面前，向著幔子，彈血七次； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","然後用血抹會幕裡耶和華面前的壇角；至於其餘的牛血，都要倒在會幕門口的燔祭壇腳那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","他要取出公牛所有的脂肪，焚燒在祭壇上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","處理這公牛與處理大祭司的贖罪祭公牛一樣，要按同一條例執行。祭司為他們贖了罪，他們就蒙赦免。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","他要把這公牛搬到營外焚燒，好像焚燒前一頭公牛一樣，這是會眾的贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“如果領袖無意犯了罪，行了一件耶和華他的　神吩咐不可行的事，他就有罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","他一發覺犯了罪，就要牽一隻沒有殘疾的公山羊羔作供物， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","要按手在山羊的頭上，然後在宰燔祭牲的地方，在耶和華面前宰殺牠，這是贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","祭司要用指頭取贖罪祭牲的一些血，抹燔祭壇的四角，其餘的血要倒在燔祭壇腳那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","公羊所有的脂肪，都要焚燒在祭壇上，好像平安祭的脂肪一樣；祭司為他贖了罪，他就蒙赦免。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“如果那地的居民中有人無意犯了罪，行了一件耶和華吩咐不可行的事，他就有罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","他一發覺犯了罪，就要為自己所犯的罪，牽一隻沒有殘疾的母山羊作供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","他要按手在贖罪祭牲的頭上，然後在宰燔祭牲的地方，宰殺贖罪祭牲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","祭司要用指頭取一些羊血，抹燔祭壇的四角，其餘的血都要倒在祭壇腳那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","母山羊所有的脂肪都要取出來，好像取出平安祭牲的脂肪一樣；然後祭司要把這些焚燒在祭壇上，獻給耶和華作馨香的祭。祭司為他贖了罪，他就蒙赦免。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“如果人獻一隻綿羊羔作贖罪祭的供物，就要牽一隻沒有殘疾的母羊； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","他要按手在贖罪祭牲的頭上，然後在宰燔祭牲的地方宰殺牠，作為贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","祭司要用指頭取一些贖罪祭牲的血，抹燔祭壇的四角，其餘的羊血，都要倒在祭壇腳那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","羊所有的脂肪都要取出來，好像取出平安祭綿羊羔的脂肪一樣；祭司要把這些放在祭壇耶和華的火祭上面焚燒，祭司為他所犯的罪行贖罪，他就蒙赦免。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“如果有人犯罪：他聽見發誓的聲音（“發誓的聲音”或譯：“傳召作證的聲音”，或“發咒語的聲音”）；他本是證人，卻不肯把看見或知道的說出來，他就要擔當自己的罪責。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","或人摸了甚麼不潔淨的東西，無論是不潔淨野獸的屍體，或是不潔淨牲畜的屍體，或是不潔淨昆蟲的屍體，當時並不留意，他因為成了不潔淨，就有罪了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","或有人摸了人的污穢，他沒有留意玷污了甚麼污穢；他一知道，就有罪了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","或有人嘴唇輕率發誓，無論是出於惡意或是出於好意，他沒有留意起了甚麼誓；他一知道，就有罪了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","如果他在任何一件事上犯了罪，就要承認自己所犯的罪； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","他要為所犯的罪，把贖愆祭帶到耶和華面前當作贖罪祭，就是羊群中的母羊，或綿羊羔或山羊；祭司就為他的罪行贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“他的經濟能力若是不夠獻一隻羊，他就要為所犯的罪，帶兩隻斑鳩或兩隻雛鴿到耶和華面前作贖愆祭，一隻作贖罪祭，一隻作燔祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","他要把牠們帶到祭司那裡，祭司就要先獻上作為贖罪祭的一隻，把鳥的頭從頸項上扭斷，只是不可撕斷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","然後他要把贖罪祭牲的一些血，彈在祭壇旁邊，其餘的血要在祭壇腳那裡擠出來；這是贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","第二隻作為燔祭的鳥，要按照燔祭的規則獻上，祭司為他的罪行贖罪，他就蒙赦免。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“他的經濟能力若是不夠獻兩隻斑鳩或兩隻雛鴿，就要為所犯的罪，帶來一公斤的細麵作贖罪祭的供物；供物不可澆上油，也不可加上乳香，因為這是贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","他要把供物帶到祭司那裡，祭司從其中取出一把，作為象徵，放在祭壇耶和華的火祭上面焚燒；這是贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","祭司為他所犯的任何一樣罪贖罪，他就蒙赦免。其餘的祭物要歸給祭司，好像素祭一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“如果有人在耶和華的聖物上不忠實，無意犯了罪，他就要依照你按著聖所衡量銀子標準所估的銀價，把他的贖愆祭牲，就是羊群中一隻沒有殘疾的公綿羊，牽到耶和華面前作贖愆祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","他要補償他在聖物上所虧欠的，另加五分之一，交給祭司；祭司要用贖愆祭的公綿羊為他贖罪，他就蒙赦免。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“如果有人犯了罪，行了一件耶和華吩咐不可行的事；他雖然不清楚，仍是有罪，他就要擔當自己的罪責。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","他要依照你的估價，從羊群中把一隻沒有殘疾的公綿羊牽來，給祭司作贖愆祭。祭司為他贖罪，那不清楚的無心之失，就蒙赦免。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","這是贖愆祭，他在耶和華面前實在有罪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“如果有人犯罪，對耶和華不忠實，在人寄存給他的物上或抵押品上欺騙自己的同伴，或是搶奪，或是欺壓自己的同胞， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","或是拾去人遺失的東西，卻欺騙人，起假誓，行了任何一件人常犯的罪， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","他犯了罪，有了罪，就應歸還他所搶奪的，或是欺壓得來的，或是別人寄存在他那裡的，或是他拾去的失物， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","或是他因起假誓所得的任何東西；在賠過的時候，他除了按原數償還外，必須另外加上五分之一，交給原主； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","還要照著你的估價，把贖愆祭牲，就是從羊群中取一隻沒有殘疾的公綿羊，牽到耶和華面前，給祭司作贖愆祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","祭司在耶和華面前，為他所行的任何一件過失贖罪，他就蒙赦免。”（本章第1 7節在《馬索拉抄本》為5:20 26） ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","耶和華對摩西說：（本節在《馬索拉抄本》為6:1） ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“你要吩咐亞倫和他的子孫說：燔祭的律例是這樣：燔祭要放在祭壇的柴上，通宵達旦；祭壇上的火，必須一直燒著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","祭司要穿上細麻布外袍，又把細麻布褲子穿在身上；他要把祭壇上燔祭燒成的灰收起來，放在祭壇旁邊； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","然後脫去這些衣服，穿上別的衣服，把灰拿出營外潔淨的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","祭壇上的火，應常常燒著，不可熄滅；每天早晨，祭司要在上面燒柴，把燔祭排列在壇上，又在上面焚燒平安祭的脂肪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","火必須不斷在祭壇上燒著，不可熄滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“素祭的律例是這樣：亞倫的子孫要在耶和華面前的祭壇前獻素祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","從其中取出一把作素祭的細麵、油，和在素祭上所有的乳香，焚燒在祭壇上獻給耶和華為馨香的祭，作供物的象徵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","亞倫和他的子孫要吃剩餘的祭物，在聖潔的地方作無酵餅吃；他們要在會幕的院子裡吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","烤餅的時候，不可加酵。這是我從獻給我的火祭中，賜給他們的分，是至聖的，與贖罪祭和贖愆祭一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","亞倫的子孫中的男丁，都要從獻給耶和華的火祭中吃這些祭物；這是你們世世代代永遠的律例。人接觸過這些祭物，必成為聖。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“亞倫和他的子孫，在受膏的日子要獻給耶和華的供物，就是一公斤的細麵，作常獻的素祭，早晨獻一半，晚上獻一半。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","你要把這些細麵在煎盤上用油調和作餅，烘（“烘”一詞原意不明，有譯本作“擘成塊”）好了，你就拿進來；將擘成碎塊的素祭獻上，獻給耶和華為馨香的祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","亞倫的子孫繼承他作受膏立的祭司的，都要獻這素祭，把它完全焚燒，獻給耶和華，作永遠的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","凡是祭司獻的素祭都要完全焚燒，不可以吃。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“你要告訴亞倫和他的兒子：贖罪祭的律例是這樣：贖罪祭牲應在宰殺燔祭牲的地方，在耶和華面前宰殺，這是至聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","獻這贖罪祭的祭司要吃這祭牲；在會幕院子裡的聖潔地方吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","接觸過這祭肉的，必成為聖。沾了祭牲的血，必須清理；血濺在衣服上，應該在聖潔的地方洗淨， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","煮祭物的瓦器卻要打碎；如果煮祭物的是銅器，只需用水沖洗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","祭司家中的男丁，都可以吃祭肉；這是至聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","但是任何贖罪祭，如果它的血帶進了會幕在聖所內進行贖罪，祭肉就不可吃；必須用火燒盡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“贖愆祭的律例是這樣：這祭是至聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","人在甚麼地方宰殺燔祭牲，就要在那裡宰殺贖愆祭牲，牠的血要潑在祭壇的四周。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","祭司要把祭牲的一切脂肪都獻上，就是肥尾巴和遮蓋內臟的脂肪， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","以及兩個腎、腎上近腰旁的脂肪和腎旁的肝葉，一起取下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","然後把這些焚燒在祭壇上，作獻給耶和華的火祭，這是贖愆祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","祭司家中的男丁，都可以吃祭牲的肉，要在聖潔的地方吃；這是至聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","贖罪祭怎樣，贖愆祭也怎樣；兩個祭的律例相同； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","祭物要歸主持贖罪的祭司，祭司替人獻燔祭，祭牲的皮要歸獻燔祭的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","一切在爐裡烤的，或在淺鍋裡或在煎盤上做的素祭，都要歸給那獻祭的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","一切用油調和，或是乾的素祭，都要歸給亞倫所有的子孫，大家均分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“獻給耶和華的平安祭的律例是這樣： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","人若是為感恩獻祭，就要用調油的無酵餅和抹了油的無酵薄餅，以及用油調和了細麵做的餅，與感恩祭一同獻上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","他要把他的供物，連同有酵的餅，跟那為感恩而獻的平安祭，一起獻上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","他要從各物中，取出一個餅作為舉祭，獻給耶和華，歸給那潑平安祭牲之血的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","“為感恩而獻的平安祭的肉，只能在獻祭那日吃，一點也不可留到早晨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","他獻的供物若是還願祭，或是甘心祭，獻祭那日可以吃；剩下的，第二天也可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","還剩下的祭肉，到了第三天，就要用火燒掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","如果在第三天吃平安祭的肉，必不蒙悅納，他獻上的也不再算為祭，因為祭肉已經成為不潔；吃這肉的人，必擔當自己的罪責。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“祭肉若是接觸了任何不潔，就不可以吃，要用火燒掉。潔淨的人才可以吃祭肉； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","身上不潔淨的人吃了獻與耶和華的平安祭的祭肉，那人必從自己的族人中被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","人若是摸了任何不潔，或是人的污穢，或是牲畜的污穢，或是任何不潔淨的可憎之物，然後吃獻給耶和華的平安祭的肉，那人必從自己的族人中被剪除。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“你要告訴以色列人說：所有公牛、綿羊或是山羊的脂肪，你們都不可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","自死的或被野獸撕裂的動物的脂肪，可以作別的用途，只是你們決不可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","因為無論何人吃了獻給耶和華為火祭的牲畜的脂肪，那吃的人就必從自己的族人中被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","在你們的一切住處，任何血，無論是飛鳥或是牲畜的，你們都不可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","無論誰吃了甚麼血，那人必從自己的族人中被剪除。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“你要告訴以色列人：向耶和華獻平安祭的，必須從他的平安祭中取出奉給耶和華的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","親手把獻給耶和華的火祭帶來，就是把脂肪連胸帶來，在耶和華面前搖一搖，作為搖祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","祭司要把脂肪焚燒在祭壇上，胸歸給亞倫和他的子孫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","你們要從平安祭牲中，拿右後腿來作舉祭，奉給祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","亞倫的子孫中，誰獻平安祭牲的血和脂肪，右後腿就歸給他，是他的分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","因為我從以色列人的平安祭中，取出了這搖祭的胸和舉祭的後腿，給亞倫祭司和他的子孫，成為以色列人中永遠的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","“這是亞倫和他子孫，從奉獻他們作耶和華的祭司那日開始，受膏立應得的分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","就是耶和華膏立他們的時候，命令以色列人給他們的。這是世世代代永遠的律例。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","以上關於燔祭、素祭、贖罪祭、贖愆祭、承受聖職祭和平安祭的律例， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","都是耶和華在西奈山吩咐摩西的，就是他在西奈的曠野吩咐以色列人，把他們的供物獻給耶和華的時候所說的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“你要把亞倫和他的兒子，連同聖衣、膏油、贖罪祭的一頭公牛、兩隻公綿羊，一籃無酵餅都帶來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","又要召集全體會眾到會幕門口那裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","於是摩西照著耶和華命令他的去行，會眾就聚集到會幕門口那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","摩西對會眾說：“這是耶和華吩咐我作的事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","摩西領亞倫和他的兒子來，用水給他們洗身。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","然後給亞倫穿上內袍，束上腰帶，穿上外袍，又加上以弗得，用巧工織成的以弗得帶子束上，把以弗得繫在他身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","又給他佩上胸牌，把烏陵和土明放在胸牌裡面， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","把禮冠戴在他頭上；在禮冠前面安上金牌，就是聖冠，都是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","摩西取膏油，抹了帳幕和其中所有的東西，使它們分別為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","又七次彈膏油在祭壇上，膏抹祭壇和祭壇的一切器皿，以及洗濯盆和盆座，使它們分別為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","然後把膏油倒在亞倫的頭上，膏立他，使他分別為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","摩西把亞倫的兒子帶來，給他們穿上內袍，束上腰帶，包上裹頭巾，都是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","他把贖罪祭的公牛牽來；亞倫和他的兒子按手在贖罪祭的公牛的頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","摩西就宰殺公牛，取了血，用指頭抹祭壇四角的周圍，潔淨祭壇，其餘的血倒在祭壇腳那裡，使祭壇成聖，為壇贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","摩西取出內臟上所有的脂肪、腎旁的肝葉、兩個腎和腎上的脂肪，焚燒在祭壇上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","至於那公牛，牠的皮、肉和糞，都要在營外用火燒掉，都是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","摩西把燔祭的公綿羊牽來，亞倫和他的兒子按手在公綿羊的頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","摩西就宰殺公綿羊，把血潑在祭壇的四周。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","摩西把公綿羊切成塊子以後，就把頭、肉塊和脂肪都焚燒了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","又用水洗淨了內臟和腿之後，摩西就把整個公綿羊焚燒在祭壇上；這是燔祭，是獻給耶和華馨香的火祭，都是耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","他又把第二隻公綿羊牽來，就是承受聖職所獻的公綿羊；亞倫和他的兒子按手在公綿羊的頭上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","摩西宰殺了羊，取了一些羊血，抹在亞倫的右耳垂上和右手的大拇指上，以及右腳的大拇趾上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","又把亞倫的兒子帶來，摩西也把血抹在他們的右耳垂上和右手的大拇指上，以及右腳的大拇趾上；其餘的血則潑在祭壇的四周。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","然後他取出脂肪、肥尾巴、內臟上所有的脂肪、腎旁的肝葉、兩個腎、腎上的脂肪和右後腿； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","又從在耶和華面前的無酵餅籃子裡，取出一個無酵餅、一個油餅和一個薄餅，都放在脂肪和右後腿上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","他把這一切都放在亞倫手上和他兒子手上，在耶和華面前搖一搖作為搖祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","然後，摩西從他們的手上接過來，焚燒在祭壇的燔祭上；這些是承受聖職祭，是獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","摩西取了祭牲的胸，在耶和華面前把它搖一搖作搖祭；這是承受聖職祭的公綿羊中，歸給摩西的分，都是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","摩西拿了一些膏油和祭壇上的血，彈在亞倫和他的衣服上，以及他兒子和他們的衣服上；這樣就使亞倫和他的衣服，他的兒子和他們的衣服都分別為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","摩西對亞倫和他的兒子說：“你們要在會幕門口煮祭肉，也在那裡吃祭肉和承受聖職祭籃子裡的餅，照著我的吩咐，亞倫和他的兒子要吃這些。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","剩下來的肉和餅，你們要用火燒掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","七天之內，你們不可出會幕的門口，直到你們承受聖職禮的日子滿了，因為主要用這七天使你們承受聖職（“使你們承受聖職”原文作“他充滿你們的手”）。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","今天所行的，是照耶和華的吩咐而行，為你們贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","七天之內，你們晝夜都住在會幕門口，遵守耶和華的吩咐，免得你們死亡，因為耶和華是這樣吩咐我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","於是亞倫和他的兒子行了耶和華藉著摩西吩咐的一切事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","到了第八天，摩西把亞倫和他的兒子，以及以色列的眾長老都召了來； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","摩西對亞倫說：“你要取一頭公牛犢來作贖罪祭，一隻公綿羊作燔祭，兩樣都要沒有殘疾的；獻在耶和華的面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","你也要告訴以色列人：你們要取一隻公山羊作贖罪祭，又取一頭一歲的牛犢和一隻一歲的綿羊羔作燔祭，兩樣都要沒有殘疾的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","又取一頭公牛和一隻公綿羊作平安祭，宰獻在耶和華面前；又取用油調和的素祭，因為今天耶和華要向你們顯現。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","於是他們把摩西所吩咐的，帶到會幕前面；全體會眾都走近來，站在耶和華的面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","摩西說：“這是耶和華吩咐你們的事，你們要照著行，耶和華的榮耀就要向你們顯現。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","然後摩西對亞倫說：“走到祭壇那裡，獻上你的贖罪祭和燔祭，為自己和人民贖罪；又獻上人民的供物，按著耶和華的吩咐，為他們贖罪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","於是亞倫走近祭壇，宰殺那為自己獻的贖罪祭牛犢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","亞倫的兒子奉上血，他就把手指蘸在血裡，抹在祭壇的四角上，把剩下的血倒在祭壇腳那裡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","贖罪祭牲的脂肪、腎和肝葉，他都焚燒在祭壇上，都是照著耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","至於肉和皮，卻在營外用火燒掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","亞倫宰殺了燔祭牲，他的兒子把血遞給他，潑在祭壇的周圍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","他們跟著把燔祭牲一塊一塊連頭遞給他，焚燒在祭壇上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","亞倫又洗淨了內臟和腿，在祭壇的燔祭上焚燒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","他把人民的供物獻上，又把那為人民作贖罪祭的公山羊牽來，宰殺了，獻為贖罪祭，和先前獻的一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","然後他按著規則獻上燔祭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","又獻上素祭，從其中取了滿滿的一把，在祭壇上焚燒。這是在早晨的燔祭以外的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","亞倫又宰殺了那為人民作平安祭的公牛和公綿羊；亞倫的兒子把血遞給他，潑在祭壇的周圍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","他們又把公牛和公綿羊的脂肪、肥尾巴、遮蓋內臟的脂肪、兩個腎和肝葉， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","都放在胸上，亞倫就把脂肪在祭壇上焚燒； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","至於胸和右後腿，亞倫拿來作搖祭，在耶和華面前搖一搖；都是照著摩西吩咐的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","亞倫向眾人舉起手，為他們祝福；他獻了贖罪祭、燔祭和平安祭，就下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","摩西和亞倫進了會幕，出來就為眾人祝福；耶和華的榮耀向眾民顯現。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","有火從耶和華面前出來，燒盡了祭壇上的燔祭和脂肪；眾民看見了，就大聲歡呼，俯伏在地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","亞倫的兒子拿答和亞比戶各拿著自己的香爐，盛上火，加上香，在耶和華面前獻上平常的火，是耶和華沒有命令他們獻的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","那時有火從耶和華面前出來，把他們燒滅，他們就死在耶和華面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","於是摩西對亞倫說：“這就是耶和華曾經告訴我們的，他說：‘在親近我的人中，我要顯為聖，在眾人面前，我要得榮耀。’”亞倫就默然無語。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","摩西把亞倫叔父烏薛的兒子米沙利和以利撒反召了來，對他們說：“你們上前來，把你們的兄弟從聖所前抬到營外去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","於是二人走近來，照著摩西的吩咐，把他們連同他們的衣服抬到營外去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","摩西對亞倫和他的兒子以利亞撒和以他瑪說：“你們不要披頭散髮，不可撕裂你們的衣服，免得你們死亡，又免得耶和華向全體會眾發怒。你們的親族，以色列全家，卻要為耶和華所燒死的人哀哭（“要為耶和華……哀哭”或譯：“要為耶和華所燃起的焚燒哀哭”）。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","你們也不可走出會幕的門口，免得你們死亡，因為耶和華的膏油在你們身上。”他們就照著摩西的話行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","耶和華對亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“你和你的兒子一起進會幕的時候，淡酒烈酒都不可喝，免得你們死亡，這要作你們世世代代永遠的律例； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","使你們可以把聖的和俗的，潔淨的和不潔淨的，分辨清楚； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","可以把耶和華藉著摩西告訴以色列人的一切律例，教訓他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","摩西對亞倫和他剩下的兒子以利亞撒和以他瑪說：“獻給耶和華的火祭中剩下的素祭，你們要拿來在祭壇旁邊作無酵餅吃，因為這是至聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","你們要在聖潔的地方吃，在獻與耶和華的火祭中，這是你和你兒子的分，因為耶和華是這樣吩咐我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","至於作搖祭的胸和作舉祭的後腿，你們也要在潔淨的地方吃，你和你的兒女要一起吃，這是從以色列人獻的平安祭中，給你和你兒子的分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","至於作舉祭的後腿，作搖祭的胸，他們要與火祭的脂肪一同帶來，當作搖祭，在耶和華面前搖一搖。這都要歸給你和與你在一起的兒子，當作永遠的律例，都是照著耶和華所吩咐的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","那時，摩西急切地尋找那作贖罪祭的公山羊，發現已經燒了；他就向亞倫剩下的兒子以利亞撒和以他瑪發怒，說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“這贖罪祭是至聖的，耶和華又把祭肉給你們，要叫你們擔當會眾的罪孽，在耶和華面前為他們贖罪，你們為甚麼沒有在聖潔的地方吃呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","這祭牲的血既然沒有帶進聖所裡去，你們就應該照著我所吩咐的，在聖所裡吃這祭肉。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","亞倫對摩西說：“今天他們在耶和華面前已經獻了贖罪祭和燔祭，而且有這樣的災禍臨到我；如果今天我吃了贖罪祭的祭肉，耶和華怎能看為美好呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","摩西聽了，也覺得合理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“你們要告訴以色列人：地上所有的走獸中，你們可以吃的動物，就是這些： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","分蹄有趾而且反芻的走獸，你們都可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","但你們不可吃下列反芻，或分蹄的走獸動物：駱駝，因為牠反芻卻不分蹄，你們應以為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","石獾（本章動物名字多不能確定。“石獾”傳統翻譯作“沙番”或“山鼠”），因為牠反芻卻不分蹄，你們應以為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","兔子，因為牠反芻卻不分蹄，你們應以為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","豬，因為牠分蹄有趾卻不反芻，你們應以為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","這些走獸的肉你們不可吃，牠們的屍體你們不可摸，你們應視為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“水中所有的活物你們可以吃的，就是這些：凡是在水中，有翅有鱗的，不論是在海裡或是河裡的，你們都可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","在水中游動或生存在水中的活物，無論是在海裡或是河裡，若是沒有翅和鱗的，你們都要當作可憎之物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","牠們是你們憎惡之物；牠們的肉，你們不可吃；牠們的屍體，你們要憎惡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","所有在水裡沒有翅和鱗的活物，你們都要當作可憎之物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“在鳥類中，你們要憎惡，也不可吃這些雀鳥：兀鷹（雀鳥的名字中文翻譯還未統一，牠們的學名多不能確定）、鵰、鷲、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","鳶、獵鷹等隼類， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","所有烏鴉類， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","鴕鳥、貓頭鷹、海鷗、蒼鷺等鷹類。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","鴟鶚、鸕鶿、大鴟梟、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","白鷺、塘鵝、鴇、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","鸛、紅鶴等鷺鷥類，戴勝和蝙蝠。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“凡有翅膀、四足爬行的生物，你們都要當作可憎之物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","但在所有有翅膀、四足爬行的生物中，如果有足有腿，能在地上蹦跳的，你們都可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","在昆蟲中，你們可以吃這些：蝗蟲類、螞蚱類、蟋蟀類和蚱蜢類。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","但是其他所有有翅膀四足的生物，你們都要當作可憎之物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“以下事物，會使你們成為不潔：觸摸動物屍體的，就不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","拾起牠們的屍體的，就要洗淨自己的衣服，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","所有分蹄卻無趾的、不反芻的走獸，你們應以為不潔淨，觸摸牠們的，就不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","所有用四足行走的動物中，用腳掌行走的，你們應以為不潔淨，觸摸牠們屍體的，都不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","拾起牠們屍體的，就要洗淨自己的衣服，並且不潔淨到晚上。以上這些你們應以為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“在地上爬行的生物中，你們應以為不潔淨的是這些：鼬鼠、鼫鼠、蜥蜴這一類， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","以及壁虎、龍子、守宮、蛇醫、變色龍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","在所有爬行的生物中，你們應以這些為不潔淨；牠們死了以後，觸摸牠們的，都不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","牠們當中死了的，掉在甚麼東西上，無論是木器或是衣服，皮子或是布袋等任何器具，都成為不潔淨，要放在水中。但仍不潔淨到晚上，以後就真潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","牠們當中死了的，掉在甚麼瓦器裡，其中不論是甚麼，都成為不潔淨，你們要把瓦器打碎。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","瓦器的水若是滴在任何食物上，食物就成了不潔淨，若是滴在裝了飲料的器皿裡，飲料也成為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","牠們屍體的任何部分掉在甚麼東西上，那東西就不潔淨，無論是爐或是鍋，都成為不潔淨，應該打碎；你們應以這些為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","但是水源和儲水池仍算是潔淨的。只有觸摸水中屍體的，才是不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","牠們屍體的一部分掉在要播種的種子上，種子還是潔淨的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","但是，如果種子已經澆了水，牠們屍體的一部分才掉在種子上面，你們應以這種子為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“一隻你們可以吃的走獸死了，誰摸了牠的屍體，就不潔淨到晚上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","誰吃了牠的屍體，就要洗淨自己的衣服，並且不潔淨到晚上；誰拾起這屍體，也要洗淨自己的衣服，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“所有在地上爬行的動物，都是可憎之物，都不可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","凡是用肚子，或用四足或是多足在地上爬行的動物，你們都不可吃，因為牠們是可憎之物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","你們不可因任何爬行的動物使自己成為可憎的，也不可因牠們玷污自己，以致不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","因為我是耶和華你們的　神，所以你們要使自己成為聖潔。你們要分別為聖，因為我是聖潔的。你們不可因在地上爬行的任何動物玷污自己， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","因為我是耶和華，曾把你們從埃及地領上來，為要作你們的　神；你們要分別為聖，因為我是聖潔的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","以上就是有關走獸、飛禽、所有在水中游行的動物，和所有在地上爬行的動物的律例， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","為要把不潔淨的和潔淨的，可吃的生物和不可吃的生物，分別出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“你要告訴以色列人：如果有婦人懷孕，生了男孩，她就不潔淨七天，好像患病污穢的日子不潔淨一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","第八天男嬰要受割禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","婦人潔淨產血的時期要住在家三十三天；得潔淨的日子未滿之前，她不可觸摸任何聖物，也不可進入聖潔的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","如果她生了女孩，就不潔淨十四天，像月經污穢的日子一樣；婦人潔淨產血的時期，要住在家裡六十六天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“潔淨的日子滿了，不論是為男孩或是為女孩，她都要用一隻一歲的綿羊羔作燔祭，一隻雛鴿，或一隻斑鳩作贖罪祭，帶到會幕門口那裡，交給祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","祭司把供物獻在耶和華面前，為她贖罪，她的血就潔淨了。以上是生育男女的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","她的經濟能力若是不夠獻一隻羊羔，她可以拿兩隻斑鳩，或是兩隻雛鴿，一隻作燔祭，一隻作贖罪祭；祭司要為她贖罪，她就潔淨了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“如果有人在皮肉上生了瘤，或癬，或火斑，後來皮肉變成了大痲風病症（本章病名多不能確定它們的學名。傳統翻譯作“痲風”的希伯來字，本章用來形容不同的皮膚病症），就要把他帶到一個作祭司的亞倫子孫那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","祭司要察看皮肉上的病症；如果患處的毛已經變白（“變白”或譯：“較其他皮肉色澤顯然為深”），病症的現象又深透皮下的肉，就是大痲風病症，祭司發現這樣，就要宣布他為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","火斑若是在他的皮肉上發白，但沒有深透皮膚的現象，上面的毛也沒有變白，祭司就要把患者隔離七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","到了第七天，祭司要察看他，如果看見病情止住了，皮上的患處沒有蔓延，祭司還要把他再隔離七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","到了第七天，祭司要再察看他；如果看見患處色澤變淡，也沒有在皮上蔓延，祭司就要宣布他為潔淨，這不過是癬；他洗淨衣服，就得潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","但是祭司察看，宣布他潔淨以後，癬若是在皮上蔓延，他就要再次給祭司察看。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","祭司要察看他；如果發現癬在皮上蔓延了，祭司就要宣布他為不潔淨；這是大痲風。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“如果有人感染到大痲風，就要帶他到祭司那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","祭司要察看，如果發現皮上有白色浮腫，毛已經變白，患處的肉紅腫， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","這就是皮肉上的潛伏性痲風病發作，祭司要宣布他為不潔淨；不必隔離觀察，因為他已經不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","如果祭司認為痲風病已在皮上蔓延，從頭到腳遮滿了患病者全身的皮， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","那麼祭司就要察看；如果看見痲風布滿了他的全身，祭司就要宣布那患病者為潔淨；因為全身變白，就算是潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","但他身上甚麼時候出現紅腫的肉，他就成為不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","祭司發現那紅腫的肉，就要宣布他為不潔淨；紅腫的肉原來是不潔淨的，是痲風病。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","但紅腫的肉若是再復原，又變成白，他就要到祭司那裡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","祭司要察看；如果看見患處變白了，祭司就要宣布那患病者為潔淨的；他就潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“人若是在皮肉上生了瘡，已經醫好了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","但在長瘡之處又起了白色浮腫，或是白中帶紅的火斑，他就要給祭司察看。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","祭司要察看；如果發現有深透皮膚的現象，上面的毛也變白了，祭司就要宣布他為不潔淨；這就是在瘡中發作出來的痲風病。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","但如果祭司察看病情，看見上面沒有白毛，也沒有深透皮膚，只是發暗而已，祭司就要把他隔離七天； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","如果在皮膚上蔓延，祭司就要宣布他為不潔淨；這就是痲風病。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","火斑若是在原處止住，沒有蔓延，就是瘡的疤痕，祭司就要宣布他為潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“如果人的皮肉發炎，發炎紅腫的肉成了火斑，白中帶紅，或是純白， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","祭司就要察看病情；如果發現火斑中的毛變白了，又有深透皮膚的現象，這就是從發炎發作出來的痲風病。祭司就要宣布他為不潔淨；這是痲風病。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","但如果祭司察看病情，看見火斑中沒有白毛，也沒有深透皮膚，只是發暗而已，祭司就要把他隔離七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","到了第七天，祭司要察看；火斑若是在皮上蔓延，祭司就要宣布他為不潔淨，這是痲風病。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","火斑若是在原處止住，沒有在皮上蔓延，只是發暗而已，這是發炎腫瘤，祭司就要宣布他為潔淨，因為這只是發炎的疤痕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“無論男女，如果在頭上或是鬍鬚上受到感染， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","祭司要察看那病；如果發現有深透皮膚的現象，而且還有黃色細毛，祭司就要宣布他為不潔淨，這是癩痢，是頭上或是鬍鬚上的痲風病。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","祭司察看癩痢的患處；如果看見沒有深透皮膚的現象，那裡也沒有黑毛，祭司就要把那患癩痢的人隔離七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","到了第七天，祭司要察看患處；如果看見癩痢沒有蔓延，那裡也沒有黃毛，癩痢也沒有深透皮膚的現象， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","那人就要剃去鬚髮，患癩痢的地方卻不可剃；祭司要把那患癩痢的人再隔離七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","到了第七天，祭司要再察看那癩痢；如果看見癩痢在皮上沒有蔓延，也沒有深透皮膚的現象，祭司就要宣布他為潔淨；他洗淨衣服，就潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","但是他得潔淨以後，癩痢若是在皮上蔓延， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","祭司就要察看；如果發現癩痢在皮上蔓延，祭司不必找黃毛，他已經不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","如果祭司認為，癩痢已經止住，那裡也長了黑毛；癩痢已經痊愈，那人就潔淨了，祭司要宣布他為潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“無論男女，皮肉上若是起了斑點，白色的斑點， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","祭司就要察看；如果發現斑點在皮肉上呈灰白色，這是皮膚出疹，那人是潔淨的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“人的頭髮若是掉下了，只不過是禿頭，還是潔淨的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","人的頭頂上若是掉下了頭髮，只不過是禿額，他還是潔淨的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","但是頭頂禿處或是額前禿處，若有白中帶紅的病症，這就是痲風病，在他的頭頂禿處或是額前處發作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","祭司就要察看，如果發現在他頭頂禿處或是額前禿處，有白中帶紅的浮腫病症，像皮肉上痲風病的現象， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","那人就是患了痲風病，就不潔淨；祭司要宣布他為不潔淨，那人頭上染了痲風。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“身上患有痲風病的人，要撕裂自己的衣服，披頭散髮，遮蓋上唇喊叫：‘不潔淨！不潔淨！’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","在他患病的日子裡，他是不潔淨的；他既然不潔淨，就要獨居，住在營外。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“染了痲風病的衣服，無論是羊毛衣服或是麻布衣服； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","不論是編結的或是紡織的；是麻布的或是羊毛的；是皮子或是皮子做成的任何物件； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","病症若是在衣服或皮子、編結物或紡織物，或任何皮子做成的器具上發綠或發紅，那就是發霉（“發霉”與“惡性皮膚病”是同一希伯來字）的現象，要給祭司察看。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","祭司要察看那現象，把染了病症之物隔離七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","到了第七天，祭司要察看那病症；如果那病症在衣服、編結物、紡織物、皮子，或是任何皮子做成的物件上蔓延，這就是頑惡的霉，那件物件就不潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","染上病症的衣服，無論是編結的或是紡織的，是羊毛或是麻布，或任何皮子做的物件，都要燒掉。因為那是頑惡的霉，所以要用火燒掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“但如果祭司察看病症，在衣服、編結物、紡織物，或是皮子做的任何物件上，沒有蔓延， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","祭司就要吩咐人把它洗淨，然後再隔離七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","洗淨以後，祭司要察看；如果看見那病症沒有轉變，雖然沒有蔓延，那物件仍是不潔淨；要用火把它燒掉，因為裡外都腐蝕了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“但如果祭司察看的時候，看見它洗淨以後，色澤暗淡了，就要把那部分從衣服或是皮子、編結物或紡織物上撕下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","如果病症再出現在剩下的衣服、編結物、紡織物或任何皮子做的物件上，那就是病症仍然發作，染了病症的物件，要用火燒掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","如果病症離開了，經過洗淨，剩下的衣服，無論編結的或是紡織的，或任何皮子做的物件，只要再洗一次，就潔淨了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","以上是與羊毛衣服或是麻布衣服、編結的或紡織的或任何皮子做的物件有關的發霉律例，可以斷定潔淨，或是不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“患痲風病的人得潔淨的日子，應守的律例如下：人要帶他去見祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","祭司要出到營外去察看，祭司若是看見患病的人身上的痲風病已經好了， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","就要吩咐人為那求潔淨的人，拿兩隻潔淨的活鳥、香柏木、朱紅色線和牛膝草來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","祭司要吩咐人用瓦器盛活水，把一隻鳥宰殺在上面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","至於那隻活鳥，祭司要把牠與香柏木、朱紅色線和牛膝草一起拿來，把這些物品和活鳥一同蘸於那在活水上宰殺的鳥血中， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","然後向那患痲風病求潔淨的人身上彈七次，就可以宣布他潔淨；又讓那隻活鳥飛到田野去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","那得潔淨的人要洗自己的衣服，剃去身上所有的毛髮，用水洗澡，就潔淨了；然後他可以進營，只是還要在自己的帳幕外住七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","第七天，他要把身上一切的毛髮都剃去；頭髮、鬍鬚、眉毛和身上一切的毛髮都剃去；又要洗衣服，用水洗身，就潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“第八天，他要取兩隻沒有殘疾的公羊羔和一隻沒有殘疾一歲的母羊羔，又要把調油的細麵三公斤作素祭，以及三分之一公升油一同取來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","行潔淨禮的祭司領那求潔淨的人拿著這些祭物站在會幕門口，耶和華的面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","祭司取一隻公羊羔，獻作贖愆祭，取三分之一公升油一同獻上；祭司把這兩樣當作搖祭，在耶和華面前搖一搖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","他要在聖潔的地方，就是宰殺贖罪祭牲和燔祭牲的地方，宰殺那隻公羊羔，因為贖愆祭牲，像贖罪祭牲一樣，是至聖的，要歸祭司； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","祭司要取些贖愆祭牲的血，抹在得潔淨的人的右耳垂上和右手的大拇指上，以及右腳的大拇趾上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","祭司又從那三分之一公升油中，取出一點來，倒在自己的左掌裡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","把右手的一個指頭，蘸在左掌的油裡，在耶和華面前用指頭把油彈七次。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","然後祭司要把手中剩下的油，抹在那得潔淨的人的右耳垂上和右手的大拇指上，以及右腳的大拇趾上，就是抹在贖愆祭牲的血上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","祭司要把手中剩下的油，抹在那得潔淨的人的頭上；祭司在耶和華面前為他贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","祭司要獻贖罪祭，為那得潔淨的人贖罪，使他脫離污穢，然後宰殺燔祭牲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","祭司要把燔祭和素祭獻在祭壇上，為他贖罪，他就潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“但如果他貧窮，經濟能力不足，他只要拿一隻公綿羊羔作贖愆祭，搖一搖為他贖罪；要把調油的細麵一公斤作素祭，和三分之一公升的油一同拿來； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","又要按他的經濟能力，拿兩隻斑鳩或是兩隻雛鴿，一隻作贖罪祭，一隻作燔祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","第八天，他為了自己得潔淨，要把這些祭物帶到會幕門口，耶和華面前，交給祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","祭司要取那隻作贖愆祭的公羊羔和那三分之一公升油；祭司把這些，在耶和華面前搖一搖當作搖祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","然後宰殺作贖愆祭的公羊羔，取一些贖愆祭牲的血，抹在那得潔淨的人的右耳垂上和右手的大拇指上，以及右腳的大拇趾上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","祭司要把一些油倒在自己的左掌裡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","用右手的一個指頭把左掌中的油，在耶和華面前彈七次。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","祭司又要把手中的油，抹在那得潔淨的人的右耳垂上和右手的大拇指上，以及右腳的大拇趾上，就是抹了贖愆祭牲的血的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","祭司把手中剩下的油，抹在那得潔淨的人的頭上，在耶和華面前為他贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","那人就要按著自己的經濟能力獻上一隻斑鳩，或是一隻雛鴿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","他要按著自己的經濟能力，獻上一隻作贖罪祭，一隻作燔祭，連同素祭一同獻上。祭司要在耶和華面前，為求潔淨的人贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","這是關於患了痲風病，但經濟能力不足夠預備正常潔淨禮祭物的人，應守的律例。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","耶和華對摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“你們進了我賜給你們作產業的迦南地的時候，我給你們作產業之地的房屋，如果發霉， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","房主就要去告訴祭司：‘據我看來，房屋中似乎染了病症。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","祭司進去察看病症之前，要先吩咐人把房屋搬空，免得房屋裡的一切都成了不潔；然後祭司才進去，察看那房屋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","他要察看那病症，如果發現在房屋的牆上有發綠或是發紅的腐蝕斑紋，而且有深透入牆的現象； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","祭司就要從房屋裡出來，到房門外去，把房屋隔離七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","第七天，祭司要回來察看，如果發現病症在房屋的牆上蔓延， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","祭司就要吩咐人把染有病症的石頭挖出來，扔在城外不潔淨的地方， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","要刮淨房屋裡面的四周，把刮下來的灰泥倒在城外不潔淨的地方； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","拿別的石頭放進去代替挖出來的石頭，然後用別的灰泥粉刷房屋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“如果挖出石頭，刮了房屋，粉刷了牆以後，病症再次在房屋裡出現， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","祭司就要進去察看；如果發現病症在房屋裡有蔓延的現象，這就是房屋裡頑惡的發霉現象，那房屋就不潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","要把房屋拆毀，把房屋裡的石頭、木頭，以及所有的灰泥都搬到城外不潔淨的地方去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","在房屋被關閉的期間，進去的人必不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","在房屋裡睡覺的人，要洗淨自己的衣服；在房屋裡吃飯的人，也要洗淨自己的衣服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“房屋粉刷以後，祭司進去察看，如果看見病症在房屋裡沒有蔓延，祭司就要宣布那房屋為潔淨，因為已經復原了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","為了潔淨那房屋，祭司要拿兩隻鳥、香柏木、朱紅色線和牛膝草； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","把一隻鳥，在盛著活水的瓦器上宰殺； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","然後拿香柏木、牛膝草、朱紅色線和那隻活鳥，都一同蘸在被宰殺的鳥血和活水中，向房屋彈七次。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","他就用鳥血、活水、活鳥、香柏木、牛膝草和朱紅色線，潔淨了那房屋； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","然後讓那隻活鳥飛到城外的田野裡去；他為房屋贖罪，房屋就潔淨了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","以上是有關各種痲風病、癬疥、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","衣服和房屋發霉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","腫瘤、瘡癬和火斑的律例； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","指示人知道甚麼時候不潔淨，甚麼時候潔淨。這是痲風病的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“你們要告訴以色列人，對他們說：如果男子的下體有異常排泄，他的排泄物是不潔淨的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","這異常排泄就使他不潔淨；無論下體仍有排泄流出，或是下體的排泄已經止住了，他都是不潔淨的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","有異常排泄的人睡過的床，都是不潔淨的；他坐過的家具，都必不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","誰觸摸他的床，都要洗淨自己的衣服，用水洗澡，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","誰坐了有異常排泄的人所坐過的家具，要洗淨自己的衣服，用水洗澡，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","觸摸了有異常排泄的人的身體，就要洗淨自己的衣服，用水洗澡，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","有異常排泄症的人，若是吐唾沫在潔淨的人身上，那人就要潔淨自己的衣服，用水洗澡，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","有異常排泄的人坐過的鞍，都不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","誰觸摸他身下任何東西，都不潔淨到晚上；拿了這些東西的，要洗淨自己的衣服，用水洗澡，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","誰觸摸有異常排泄的人，而沒有洗手，就要洗淨自己的衣服，用水洗澡，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","有異常排泄的人摸過的瓦器，必須打碎；他摸過的任何木器，都要用水洗淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“有異常排泄的人痊愈的時候，就要為自己得潔淨計算七天，洗淨自己的衣服，用活水洗身，就潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","第八天，他要帶兩隻斑鳩或是兩隻雛鴿，來到耶和華面前，在會幕門口交給祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","祭司要把牠們獻上，一隻作贖罪祭，一隻作燔祭；祭司因那人的異常排泄，要在耶和華面前為他贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“人若是遺精，就要用水把全身洗淨，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","無論是衣服或是皮革，被精液染污，都要用水洗淨，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","至於女人，男人若是與她同睡性交，兩人都要用水洗澡，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“如果女人身上排泄的是經血，她必污穢七天；摸她的，都不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","在她污穢的時期，她躺過的東西，都不潔淨；她坐過的東西，也都不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","觸摸她的床的，都要洗淨自己的衣服，用水洗澡，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","觸摸她坐過的任何家具，都要洗淨自己的衣服，用水洗澡，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","在女人的床上，或是在她坐過的家具上，如果有別的東西，人摸了它，就不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","男人若是與那女人同睡，染上她的污穢，就不潔淨七天；他躺過的床都不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“女人若是在月經污穢期以外，血漏多日；或是月經污穢期過長，患有血漏症；她在這些血漏的日子是不潔淨的，好像她在月經污穢的日子不潔淨一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","她在血漏症的日子躺過的床，都像她在月經污穢時的床一樣；她所坐過的家具，都不潔淨，像月經污穢的時候一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","觸摸這些東西的，都不潔淨；要洗淨自己的衣服，用水洗澡，並且不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","女人的血漏若是潔淨了，她要計算七天，然後就潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","第八天，她要拿兩隻斑鳩或兩隻雛鴿，帶到會幕門口，交給祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","祭司要獻一隻作贖罪祭，一隻作燔祭；祭司要在耶和華面前，因那婦人血漏的不潔，為她贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“你們要這樣叫以色列人遠離他們的不潔，免得他們玷污我在他們中間的會幕，他們就因自己的不潔而死亡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","以上是關於因為異常排泄和遺精，成為不潔淨， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","以及患病污穢的婦女和患血漏的男女，還有男人與不潔淨的女人同睡的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","亞倫的兩個兒子走近耶和華面前而死亡以後，耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“你要告訴你的哥哥亞倫，不可隨時進入聖所的幔子裡面，到約櫃上的施恩座，免得他死亡，因為我在施恩座上的彩雲中顯現。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","亞倫進入聖所時要帶一頭公牛犢作贖罪祭，一隻公綿羊作燔祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","他要穿上細麻布的聖內袍，也要把細麻布的褲子穿在身上，腰束細麻布的帶子，頭戴細麻布禮冠；這些就是聖衣。他要先用水洗身，然後才穿上聖衣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","他要從以色列的會眾中，取兩隻公山羊作贖罪祭，一隻公綿羊作燔祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","亞倫為自己的罪獻上作贖罪祭的公牛，為自己和家人贖罪， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","然後把兩隻公山羊牽來，放在會幕門口，耶和華的面前； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","亞倫要為這兩隻山羊抽籤：一籤歸耶和華，另一籤歸阿撒瀉勒（“阿撒瀉勒”是希伯來文音譯，這字原意不能確定）。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","亞倫要把那抽籤歸耶和華的山羊，獻作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","至於那抽籤歸阿撒瀉勒的山羊，卻要活活地擺在耶和華面前，用來贖罪，然後叫人把牠送到曠野，歸阿撒瀉勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“亞倫要先為自己獻上作贖罪祭的公牛，為自己和家人贖罪，他要把那為自己作贖罪祭的公牛宰殺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","從耶和華面前的祭壇上，拿一個盛滿火炭的香爐，又拿一捧搗細的芬芳香料，帶進幔子裡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","在耶和華面前把香放在火上，使香的煙雲遮掩約櫃上的施恩座，免得他死亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","他要取些公牛的血，用指頭彈在施恩座的東面，再用指頭在施恩座的前面，彈血七次。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“然後他要宰殺那為人民作贖罪祭的公山羊，把血帶進幔子裡，彈羊血在施恩座的上面和施恩座的前面，好像彈公牛的血一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","他要為聖所贖罪，使聖所脫離以色列人的不潔和他們的過犯，就是他們的一切罪孽。然後他又要為會幕同樣的贖罪。因為會幕和他們在一起，在他們的不潔中間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","他進入至聖所贖罪的時候，會幕裡不可有人；直到他為自己和家人，以及以色列全體會眾，贖了罪出來為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","他出來，就到耶和華面前的祭壇那裡，為壇贖罪。他要取一點公牛的血和山羊的血，抹祭壇的四角。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","又用指頭向祭壇彈血七次，潔淨祭壇，使它分別為聖，脫離以色列人的不潔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“亞倫為聖所、會幕和祭壇贖了罪以後，就要把那隻活山羊獻上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","亞倫兩手按在那隻活山羊頭上，承認以色列人的一切罪孽和他們的過犯，就是他們一切罪孽。把它們都歸在那山羊的頭上；然後經由已預定的人，把羊送到曠野裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","那隻山羊就擔當他們的一切罪孽，把它們帶到一個完全隔離的地；所以那人要把那隻山羊送到曠野裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“亞倫要進會幕，把他進聖所時所穿的細麻布衣服脫下，放在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","然後在聖潔的地方用水洗身，穿回自己的衣服出來，把自己的燔祭和眾民的燔祭獻上，為自己和眾民贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","贖罪祭牲的脂肪，他要焚燒在祭壇上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","那送走歸阿撒瀉勒的山羊的人，要洗淨自己的衣服，用水洗身，然後才可以進到營裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","那作贖罪祭的公牛和作贖罪祭的公山羊，牠們的血既然被帶進去為聖所贖罪，牠們的身體就要搬出營外去；牠們的皮、肉和糞都要用火燒掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","那燒祭牲的人要洗淨自己的衣服，用水洗身，然後才可以進營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“每逢七月十日，你們要刻苦己心，無論是本地人，或是寄居在你們中間的外人，甚麼的工，你們都不可作，這要作你們永遠的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","因為在這一天，他要為你們贖罪，使你們潔淨，脫離你們一切罪孽，使你們在耶和華面前成為潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","這是完全休歇的安息，你們要刻苦己心。這是永遠的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","那被膏立，承受聖職，接替他父親作祭司的，要穿上細麻布衣服，就是聖潔的衣服，進行贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","他要為至聖所贖罪，又為會幕和祭壇贖罪，以及為祭司們和全體會眾贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","每年一次，要因以色列人一切的罪，為他們贖罪。這是你們永遠的律例。”於是亞倫照著耶和華吩咐摩西的去行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“你要告訴亞倫和他的兒子，以及以色列人，對他們說：這是耶和華的吩咐： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","以色列家的任何人，不論在營內，或在營外，宰殺公牛、綿羊或山羊， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","而不牽到會幕門口，耶和華的帳幕面前，獻給耶和華作供物，流血的罪就要歸到那人身上；他既然流了牲畜的血，就必從自己的族人中被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","這條例的目的是要以色列人把他們慣常在田野裡宰殺的祭牲，帶去給耶和華，到會幕門口交給祭司，好像獻給耶和華作平安祭那樣宰殺牲畜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","祭司要把血潑在會幕門口耶和華的祭壇上，把脂肪焚燒，獻給耶和華作馨香的祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","他們不可再殺祭牲，獻給那些山羊，就是他們所隨從行邪淫的鬼神。這要作他們世世代代永遠的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“你要對他們說：以色列家的任何人，或是在你們中間寄居的外人，獻燔祭或是平安祭的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","如果不牽到會幕門口，把牠獻給耶和華，那人就必從自己的族人中被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“以色列家的任何人，或是在你們中間寄居的外人，如果吃了任何血，我必向那吃血的人變臉，把他從自己的族人中剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","因為動物的生命是在血裡，我指定這祭壇上的血代替你們的生命，因為血裡有生命，所以能代贖生命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","所以我對以色列人說：你們中間任何人都不可吃血，在你們中間寄居的外人也不可吃血。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","任何以色列人，或是在你們中間寄居的外人中，有人打獵得了可以吃的禽獸，總要放盡牠的血，用泥土掩蓋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","“因為所有動物的生命就在牠們的血中，所以我對以色列人說：任何動物的血，你們都不可吃；因為所有動物的血，就是牠的生命；吃血的，必被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","吃了自死的，或是被野獸撕裂的動物，無論是本地人或是寄居的，都要洗淨自己的衣服，用水洗澡，並且不潔淨到晚上，以後他才算潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","但是，如果他不洗淨衣服，也不洗身，他就要擔當自己的罪責。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“你要告訴以色列人，對他們說：我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","你們從前住過的埃及地，那裡的居民的行為，你們不可隨從；我要領你們到的迦南地，那裡的居民的行為，你們也不可仿效。你們不可跟隨他們的風俗行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","你們要遵行我的典章，謹守我的律例，要遵照奉行；我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","所以你們要謹守我的律例和典章；人應該遵行這些，按照它們生活，我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“你們任何人都不可親近骨肉之親，揭露她的下體；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","你不可揭露你父親的下體，就是你母親的下體；她是你的母親，你不可揭露她的下體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","你父親的妻子的下體，你不可揭露；那本是你父親的下體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","你姊妹的下體，無論是異母同父的，或是異父同母的，是在家裡生的，或是在外面生的，你都不可揭露她們的下體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","你的孫女，或是你的外孫女的下體，你都不可揭露，因為她們的下體就是你自己的下體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","你的繼母為你父親所生的女兒的下體，是你的妹妹，你不可揭露她的下體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","你不可揭露你姑母的下體；她是你父親的骨肉之親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","你不可揭露你姨母的下體；她是你母親的骨肉之親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","你不可揭露你叔伯的下體，不可親近他的妻子，她本是你的嬸母。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","你不可揭露你兒媳的下體；她是你兒子的妻子，你不可揭露她的下體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","你不可揭露你兄弟妻子的下體；那本是你兄弟的下體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","你不可揭露一個婦人的下體，又揭露她女兒的下體；不可娶她的孫女，或是她的外孫女，揭露她的下體；她們是骨肉之親，這是醜惡的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","妻子還活著的時候，你不可另娶她的姊妹，作她的情敵，揭露她的下體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“在污穢不潔中的婦女，你不可親近她，揭露她的下體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","你不可與你同伴的妻子私通，因她而玷污自己。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","你不可把你的兒子（“兒子”原文作“種子”或“精子”）獻給摩洛，也不可褻瀆你　神的名；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","你不可與男人同睡交合，像與女人同睡交合一樣，這是可憎的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","你不可與任何走獸同睡交合，因牠而玷污自己；女人也不可站在走獸面前，與牠交合；這是逆性的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“你們不可讓這些事的任何一件玷污自己，因為我將要從你們面前趕出去的各族，就是被這些事玷污了自己。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","連地也被玷污，所以我追討那地的罪孽，那地就把居民吐出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","所以，你們要謹守我的律例和典章；這一切可憎的事，無論是本地人或是在你們中間寄居的外人，一件都不可作 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","（因為在你們以前住在那地的人，行了這一切可憎的事，就玷污了自己）； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","免得你們玷污那地，那地就把你們吐出去，像吐出了在你們以前的各民族一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","無論甚麼人，行了一件這些可憎的事，必從自己的族人中被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","所以你們要謹守我的吩咐，免得你們行那些可憎的風俗，就是你們以前的人所行的，玷污了自己。我是耶和華你們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“你要告訴以色列全體會眾，對他們說：你們要分別為聖，因為我耶和華你們的　神是聖潔的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","各人要孝敬父母，也要謹守我的安息日；我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","你們不可轉向偶像，也不可為自己鑄造神像；我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“如果你們獻平安祭給耶和華，要使你們所獻的蒙悅納。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","祭牲的肉，要在你們獻的那一天和第二天吃；如果有剩下的，到了第三天，就要用火燒掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","如果在第三天吃平安祭肉，這祭肉已經成為不潔淨，不蒙悅納。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","那吃祭肉的人，要擔當自己的罪責，因為他褻瀆了耶和華的聖物；那人必從自己的族人中被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“你們收割莊稼的時候，不可把角落的穀物都割盡，也不可拾取收割時遺下的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","不可把你葡萄園的果子都摘盡，也不可拾取你葡萄園中掉下的；要把它們留給窮人和寄居的外人；我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“你們不可偷竊，不可欺騙，不可彼此說謊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","不可奉我的名起假誓，褻瀆你　神的名；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“不可欺壓你的鄰舍，也不可搶奪他的東西；雇工的工錢，不可扣留在你那裡到早晨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","不可咒罵聾子，也不可把絆腳石放在瞎子面前；卻要敬畏你的　神；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“你們審判的時候，不可行不義；不可偏袒窮人，也不可偏幫有權勢的人；只要按著公義審判你的鄰舍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","你不可在你的族人中，到處搬弄是非，也不可危害你的鄰舍；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“你不可心裡恨你的兄弟；應坦誠責備你的鄰舍，免得你因他擔當罪過。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","不可報復，也不可向你的族人懷恨，卻要愛你的鄰舍好像愛自己；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“你們要謹守我的律例。不可使你的牲畜與不同類的交合；在你的田裡不可撒兩種不同類的種子；兩樣料子作成的衣服，你不可穿在身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","如果人與女子同睡交合，而那女子是個婢女，已經許配了人，但還沒有贖身，或是還沒有得著自由，就應受懲罰，但不可把二人處死，因為婢女還沒有得著自由。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","那人要把他的贖愆祭，就是一隻作贖愆祭的公綿羊，帶到會幕門口，耶和華面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","祭司要用那隻作贖愆祭的公綿羊，在耶和華面前，為他所犯的罪贖罪，他所犯的罪必蒙赦免。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“你們進了那地，栽種了各樣可作食物的果樹的時候，你們要視初結的果子為不潔淨，好像未受割禮的人。頭三年的果子，你們不可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","第四年所結的一切果子，應分別為聖，是作稱頌耶和華的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","到了第五年，你們才吃樹上所結的果子，你們這樣作，你們的生產就必增加；我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“你們不可吃帶血的東西，不可占卜，不可算命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","不可剃兩邊的頭髮，鬍鬚的周圍也不可刮掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","不可為死人的緣故，割傷你們的身體，也不可在你們的身上刺花紋；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“不可辱沒你的女兒，使她作娼妓，免得這地淫亂，充滿醜惡的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","你們要謹守我的安息日，敬畏我的聖所；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“你們不可轉向那些交鬼的和行法術的；不可求問他們，玷污自己；我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“在白髮的人面前，你要起立；要尊敬老年人，又要敬畏你的　神；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“如果有外人在你們的地方，與你們一起寄居，你們不可欺負他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","與你們一起寄居的外人，要看他像你們中間的本地人一樣；你要愛他好像愛自己，因為你們在埃及地也曾作過寄居的人；我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“你們審判的時候，在度、量、衡上，都不可偏差。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","要用公正的天平，公正的法碼，公正的升斗，公正的容器；我是耶和華你們的　神，就是曾把你們從埃及地領出來的那位。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","你們要謹守遵行我的一切律例和一切典章；我是耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“你要對以色列人說：任何以色列人，或是在以色列中寄居的外人，把自己的兒子獻給摩洛，必要把他處死；本地的人要用石頭把他打死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","我也要向那人變臉，把他從他的族人中剪除，因為他把自己的兒子獻給摩洛，玷污了我的聖所，褻瀆了我的聖名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","如果有人把他的兒子獻給摩洛，而本地的人掩目不看，不把他處死， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","我就要向那人和他的家族變臉，把他和所有跟隨他與摩洛行邪淫的人，都從他們的族人中剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“如果有人轉向交鬼的和行法術的，隨從他們行淫，我必向那人變臉，把他從他的族人中剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","所以你們要使自己成為聖潔。你們要分別為聖，因為我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","你們要謹守遵行我的律例，我是使你們分別為聖的耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“咒罵自己父母的，必要把他處死；他咒罵自己的父母，必須承擔流血的罪責。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“如果有人與別人的妻子通姦，就是與鄰舍的妻子通姦，姦夫和淫婦都要處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","如果有人與父親的妻子同睡，就是揭露了他父親的下體，必要把他們二人處死；他們必須承擔流血的罪責。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","如果有人與兒媳同睡，必要把他們二人處死；他們犯了亂倫的罪，必須承擔流血的罪責。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","如果有人與男人同睡，像與女人同睡一樣，他們二人行了可憎的事，必要把他們處死，他們必須承擔流血的罪責。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","如果有人娶妻，又娶岳母，就是行了醜惡的事，要把他們三人用火燒死，好使你們中間不再有醜惡的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","如果有人與走獸同睡，必要把他處死，也要殺死那走獸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","女人若是親近任何走獸，與牠交合，你們要殺了那女人和走獸；必要把他們處死；他們必須承擔流血的罪責。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“如果有人娶了自己的姊妹，無論是異母同父的，或是異父同母的，他見了她的下體，她也見了他的下體，這是可恥的事；他們二人必要從自己族人的眼前被剪除。他揭露了自己姊妹的下體，必須擔當自己的罪孽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","如果有人與患血漏病的婦人同睡，揭露了她的下體，就揭露了她的血源，婦人也揭露了她自己的血源，他們二人必要從自己的族人中被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","你不可揭露姨母，或是姑母的下體，因為這是揭露了骨肉之親的下體；這樣作的人要擔當自己的罪孽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","如果有人與叔伯的妻子同睡，就是揭露了叔伯的下體，這樣作的人要擔當自己的罪；他們必無子女而死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","如果有人娶了兄弟的妻子為妻，這是污穢的事，揭露了自己兄弟的下體；這樣作的人必無子女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“所以你們要謹守遵行我的一切律例和一切典章，免得我將要領你們進去居住的那地，把你們吐出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","我從你們面前逐出的各民族，你們不可隨從他們的風俗；因為他們行了這一切事，所以我厭惡他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","但我對你們說過，你們要承受他們的土地；我要把這流奶與蜜之地，賜給你們作產業。我是耶和華你們的　神，把你們從萬民中分別出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","所以你們要把潔淨的和不潔淨的走獸，潔淨的和不潔淨的飛禽分別出來；你們不可因著那些我為你們分別出來，不潔淨的走獸、飛禽，或任何在地上爬行的動物，使自己成為可憎惡的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","你們要歸我為聖，因為我耶和華是聖潔的，我把你們從萬民中分別出來，使你們歸我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“無論男女，是交鬼的或是行法術的，必要把他們處死，要用石頭打死他們；他們必須承擔流血的罪責。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","耶和華對摩西說：“你要告訴亞倫子孫作祭司的，對他們說：祭司不可在自己的族人中因死人玷污自己， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","除非骨肉至親，例如父母、兒女、兄弟， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","或是仍是處女，未曾出嫁的姊妹等至親，祭司才可以玷污自己。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","祭司不可為了姻親而玷污，褻瀆自己的聖職（全句或譯：“祭司既為族人的首領，就不可從俗玷污”）。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","祭司不可剃光頭髮，鬍鬚的周圍不可剃掉，也不可紋身。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","他們要成為聖，歸向他們的　神，不可褻瀆他們　神的名，因為他們奉獻耶和華的火祭，他們　神的食物，所以他們要成為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","祭司不可娶被玷辱了的妓女為妻，也不可娶被丈夫離棄的女人為妻；因為祭司是歸他的　神為聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","所以你要使他分別為聖，因為他把食物獻給你的　神；你要以他為聖，因為我耶和華使你們分別為聖的，是聖潔的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","如果祭司的女兒羞辱自己去作妓女，就是羞辱了自己的父親；她必須用火燒死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“在兄弟中作大祭司的，頭上倒了膏油，又受了聖職，得以穿著聖衣，就不可披頭散髮，也不可撕裂衣服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","不可走近死屍，也不可為了父母玷污自己。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","他不可走出聖所，也不可褻瀆他　神的聖所，因為他　神膏立了他，使他分別為聖，我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","他要娶處女為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","寡婦、被休的婦人、受玷辱的妓女，他都不可以娶；他只可以娶自己族人中的處女為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","不可在自己的族人中，羞辱他的後裔，因為我是使他們分別為聖的耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“你要告訴亞倫：你世世代代的後裔中，有殘疾的，就不可走近來獻他　神的食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","因為有殘疾的，無論是瞎眼、瘸腿、五官不正、畸形、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","斷腳斷手的、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","駝背、矮小、眼睛有毛病、長癬、生疹，或是腎子損壞的，都不可走近來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","亞倫祭司的後裔中，有殘疾的，都不可上前來獻耶和華的火祭；他既有殘疾，就不可上前來獻他的　神的食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","他　神的食物，無論是至聖的或是聖的，他都可以吃； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","只因他有殘疾，他就不可進到幔子前，也不可上前到我的祭壇那裡，免得褻瀆我的聖所；我是使他們分別為聖的耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","於是摩西告訴亞倫和亞倫的兒子，以及所有以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“你要告訴亞倫和他的兒子，叫他們謹慎處理以色列人分別為聖歸給我的聖物，免得他們褻瀆我的聖名；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","你要對他們說：你們世世代代的後裔中，若是不潔淨，卻接近以色列人分別為聖歸耶和華的聖物，那人必從我面前被剪除；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","亞倫的後裔中，患了痲風病，或是血漏症的，都不可吃聖物，直到他潔淨了；觸摸了任何屍體的不潔或遺精的人， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","或是觸摸了任何使他玷污的爬蟲，或是摸了使他成為不潔淨的人（不論那人有甚麼不潔淨）， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","摸了這些的人，必不潔淨到晚上；如果他不用水洗身，就不可吃聖物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","日落之後，他就潔淨了，可以吃聖物，因為那是他的食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","自死的或是野獸撕裂的動物，他都不可吃，免得玷污自己；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","他們要謹守我的命令，免得他們因褻瀆，擔罪而死；我是使他們分別為聖的耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“所有外族人都不可吃聖物；寄居在祭司家裡的人或是受雇的雇工，都不可吃聖物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","但是祭司用自己銀子買來的僕人，就可以吃聖物；生在祭司家裡的人，他們可以吃他的食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","祭司的女兒若是嫁給外族人，就不可吃舉祭的聖物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","但祭司的女兒若是寡婦，或是被休的，而且沒有孩子，又回到自己的父家，像她年輕的時候一樣，她就可以吃她父親的食物；只是任何外族人都不可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","人若是誤吃了聖物，就要加上五分之一，與聖物一起交給祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","祭司不可褻瀆以色列人獻上給耶和華的聖物， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","免得他們因吃了聖物而擔當罪孽過犯；因為我是使他們分別為聖的耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“你要告訴亞倫和亞倫的兒子，以及所有以色列人，對他們說：任何以色列家的人，或是在以色列中寄居的外人，奉獻供物的時候，無論是為還願，或是甘心獻給耶和華的燔祭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","就要把沒有殘疾的公牛，或公綿羊，或公山羊獻上，才蒙悅納。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","有殘疾的，你們都不可獻上，因為這是不蒙悅納的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","人若是為了還願，或是甘心把牛羊獻給耶和華作平安祭，總要獻上一隻完全、沒有任何瑕疵的祭物，才蒙悅納。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","瞎眼、折傷、殘廢、傷口潰瘍、長癬或生疹的牲畜，你們都不可獻給耶和華，不可把這些當作火祭放在祭壇上獻給耶和華， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","無論是公牛或是綿羊羔，如果肢體畸形或有缺陷的，你可以作甘心祭獻上；如果作還願祭獻上，就不蒙悅納。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","內臟損傷、壓碎、破裂，或割掉的，你們都不可獻與耶和華；在你們將來居住的地方，你們不可行這樣的事； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","也不可從外人手裡接受這一類的牲畜，作你們　神的食物；因為這些都有損壞，有殘疾，必不蒙悅納。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“公牛或是綿羊或是山羊生下來以後，七天要與牠的母親在一起，從第八天開始，牠就可以蒙悅納，作獻給耶和華火祭的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","無論是牛或羊，你們都不可在同一日之內宰殺母和子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","如果你們獻感恩祭給耶和華，要獻得可蒙悅納。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","祭肉要當天吃完，一點都不可留到早晨；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","你們要謹守遵行我的誡命；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","你們不可褻瀆我的聖名，我在以色列人中間要被尊為聖；我是使你們分別為聖的耶和華， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","曾把你們從埃及地領出來，要作你們的　神；我是耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“你要告訴以色列人，對他們說：我指定的節日，就是耶和華指定的節日，你們應當召集聖會。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“六日要工作，但第七日是完全休歇的安息日，應當有聖會；甚麼工你們都不可作；在你們的一切住處，這日是歸耶和華的安息日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“以下是耶和華的節日，你們在這些指定的日期要召集聖會。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“正月十四日黃昏的時候，是耶和華的逾越節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","這月十五日是耶和華的無酵節；你們要吃無酵餅七日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","第一天應當有聖會，甚麼勞碌的工你們都不可作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","這七天你們要每天獻火祭給耶和華；第七日應當有聖會，甚麼勞碌的工你們都不可作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“你要告訴以色列人，對他們說：你們到了我賜給你們的地，收割莊稼的時候，要把初熟莊稼的一捆帶到祭司那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","他要在耶和華面前搖禾捆，在安息日的次日把它搖一搖，使你們蒙悅納。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","你們搖禾捆的時候，要把一隻一歲、沒有瑕疵的公綿羊作燔祭獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","同獻的素祭，是調油的細麵兩公斤，獻給耶和華作馨香的火祭；同獻的奠祭，是一公斤酒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","無論是餅，是烘過的穀粒，或是新穗子，你們都不可吃，直等到你們把　神的供物帶來的那天，才可以吃；這要在你們的一切住處，作世世代代永遠的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“你們要從安息日的次日，把禾捆帶來作搖祭那日起，計算整整七個星期； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","到第七個星期的次日，共計五十天；那天你們要獻新的素祭給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","要從你們的住處把兩個餅帶來作搖祭，每個是用細麵兩公斤，加酵烤成的，當作初熟之物獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","你們要把一歲、沒有瑕疵的綿羊羔七隻，公牛犢一頭，公綿羊兩隻，作獻給耶和華的燔祭，牠們和同獻的素祭、奠祭，是獻給耶和華作馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","你們又要獻一隻公山羊作贖罪祭，兩隻一歲的公綿羊作平安祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","祭司要把這些祭物與初熟祭的餅，一同作搖祭，在耶和華面前搖一搖，這些是耶和華的聖物，應歸給祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","在這一天你們要宣布，這是你們的聖會，甚麼勞碌的工你們都不可作。這要在你們一切住處，作世世代代永遠的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“你們收割你們的莊稼的時候，不可把角落的穀物割盡，也不可拾取你收割時遺下的；把它們留給窮人和寄居的外人；我是耶和華你們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“你要告訴以色列人：七月初一，你們必須完全休歇，要吹號筒作記念，應當有聖會。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","甚麼勞碌的工你們都不可作；你們要獻火祭給耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“七月初十是贖罪日；你們應當有聖會，要刻苦己心，獻火祭給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","在這一天，甚麼工你們都不可作，因為這是贖罪日，要在耶和華你們的　神面前為你們贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","在這一天，不刻苦己心的人，必從他的族人中被剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","在這一天，作甚麼工的人，我必把他從自己的族人中間消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","甚麼工你們都不可作，這要在你們的一切住處作世世代代永遠的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","這是你們完全休歇的安息日，並要刻苦己心；從這月初九晚上，到次日晚上，你們要守安息日。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“你要告訴以色列人：七月十五日是住棚節，要在耶和華面前守這七天的節期。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","第一天應當有聖會；甚麼勞碌的工你們都不可作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","這七天你們每天都要獻火祭給耶和華；第八天應當有聖會，要獻火祭給耶和華，這是集會的日子，甚麼勞碌的工都不可作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“以上是耶和華的節日，你們應當召集聖會，照著每日的規定獻火祭給耶和華，就是燔祭、素祭、平安祭和奠祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","此外，還有耶和華的安息日，你們的供物，你們的一切還願祭和甘心獻的祭，這些是你們當獻給耶和華的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“又在七月十五日，你們收了那地的出產以後，要守耶和華的節七日，第一天要完全休歇，第八天也要完全休歇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","第一天你們要拿果樹的美果、棕樹枝、茂密的大樹枝和溪邊的楊柳枝，在耶和華你們的　神面前歡樂七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","你們每年七月，要守耶和華這七天的節期，這是你們世世代代永遠的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","你們要住在棚裡七天；以色列所有的本地人都要住在棚裡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","好叫你們世世代代知道，我領以色列人出埃及地的時候，曾經使他們住在棚裡；我是耶和華你們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","於是摩西把耶和華指定的節日告訴了以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“你要吩咐以色列人，把點燈用的榨成的純淨橄欖油，拿來給你，使燈火長燃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","在會幕中法櫃的幔子外，亞倫要使這燈在耶和華面前通宵達旦地長燃；這是你們世世代代永遠的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","亞倫要不斷地在耶和華面前，整理純金燈臺上的燈。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“你要取細麵烤成十二個餅，每一個餅用兩公斤細麵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","你要把餅擺列成兩排，每排六個，放在耶和華面前精金的桌子上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","把純乳香放在每排餅上，象徵這些餅作獻給耶和華的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","每一個安息日，亞倫都要把餅擺在耶和華面前，不可間斷，這是以色列人永遠的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","這餅要歸給亞倫和他的子孫，他們要在聖潔的地方吃，因為這是至聖的，在獻給耶和華的火祭中，他永遠的分。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","有一個以色列婦人的兒子，父親是埃及人，在以色列人中間出入；這以色列婦人的兒子在營裡和一個以色列人爭吵； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","這以色列婦人的兒子褻瀆耶和華的名，咒詛耶和華的名，人就把他帶到摩西那裡。（他母親名叫示羅密，是但支派底伯利的女兒。） ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","他們拘留看守那人，等候耶和華給他們的指示。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“把那咒詛聖名的人拉出營外，聽見的人都按手在他頭上。然後全體會眾要扔石頭打死他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","你要告訴以色列人：咒詛　神的，必擔當自己的罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","褻瀆耶和華聖名的人，必被處死，全體會眾要扔石頭打他；不論是寄居的外人或是本地人，如果褻瀆聖名，必被處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","打死人的，必被處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","打死牲畜的，必要賠償牲畜，以命償命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","如果有人使他的同伴傷殘；他怎樣待人，人也必怎樣待他； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","以傷還傷，以眼還眼，以牙還牙；他怎樣使人傷殘，人也必怎樣使他傷殘。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","打死牲畜的，必要賠償牲畜；打死人的，必被處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","無論是寄居的或是本地人，你們都應一律對待，因為我是耶和華你們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","於是摩西告訴了以色列人，他們就把那咒詛聖名的人帶出營外，扔石頭打死他。以色列人遵行了耶和華給摩西的吩咐。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","耶和華在西奈山對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“你要告訴以色列人，對他們說：你們到了我賜給你們的那地以後，地要守耶和華的安息。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","六年之內，你要耕種田地；六年之內，你要修剪葡萄園，收藏地的出產； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","但是第七年，地要完全休歇，享受耶和華的安息；你不可耕種田地，也不可修剪葡萄園。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","你收割以後自然生長的莊稼，你不可收割；沒有修剪的葡萄樹果子，你也不可採摘；這一年，地要完全休歇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","地在安息年的自然出產，是給你們作食物；就是給你，你的僕婢、雇工和寄居的，就是與你們一起居住的人； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","甚至你的牲畜，以及你那地的走獸，都以安息年的出產作食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“你又要為自己計算七個安息年，就是七個七年，你經過了七個安息年，四十九年的日子以後， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","在七月初十，你要吹角，在贖罪日，角聲要響遍你的全地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","你們要把第五十年分別為聖，向全地所有居民宣布自由；這一年是你們的禧年，你們各人要歸回自己的地業，歸回自己的父家。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","第五十年是你們的禧年；這一年你們不可耕種，也不可收割自然生長的，也不可採摘沒有修剪的葡萄樹果子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","因為這是禧年，你們要當作聖年；你們可以吃地裡的出產。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“在這禧年中，你們各人要歸回自己的地業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","如果你賣甚麼給鄰舍，或是從鄰舍的手裡買甚麼，你們不可欺負對方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","你要按照下一個禧年以前還剩餘的年數向鄰舍買；他也要按照這年數可得的出產價值賣給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","年數多，你付的買價就要增多。年數少，你付的買價就要減少。因為他是按出產的數值賣給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","你們不可欺負對方，卻要敬畏你的　神，因為我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“所以你們要遵行我的律例，謹守我的典章，遵照奉行，就可以在那地安然居住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","地必生產果實，你們就可以吃飽，在那地安然居住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","如果你們問：在第七年我們不耕種，也不收藏我們的出產，我們吃甚麼呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","在第六年，我必命我的福臨到你們，地就會生產足夠三年食用的出產。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","第八年你們耕種時，仍有舊糧吃；直到第九年，收成新糧的時候，你還有舊糧可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“地不可永遠賣掉，因為地是我的；你們在我面前不過是寄居的和客旅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","在你們所得為業的全地，你們應該讓人有贖地的權利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","如果你的兄弟貧窮，賣了部分地業，他的至親可以來，把兄弟所賣的贖回。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","如果沒有代贖人，而他自己的經濟能力改善，足夠把地贖回， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","他就要計算賣地的年數，把餘剩年數的出產數值還給那買主，他就可以收回自己的地業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","如果他沒有足夠的能力為自己收回賣了的地，他所賣的就要存在買主的手裡，直到禧年；到了禧年，買主必須把地歸還，賣地的人可以收回自己的地業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“如果有人賣了一所城內的住宅，在賣了以後的一整年之內，他有贖回的權利；在這些日子以內，他隨時可贖回。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","如果滿了一年期不贖回，那所城內的房屋，就要確定歸買主世世代代為業；就算到了禧年，買主也不必交出退還。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","但房屋在四圍沒有城牆的村莊裡，就要算為鄉下的田地一樣，是可以贖回的；到了禧年，買主要交出退還。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","至於利未人的城，就是他們所得為業的城，其中的房屋，利未人有隨時可以贖回的權利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","如果一個利未人在他所得為業的城裡，沒有贖回已經賣了的房屋，到了禧年，買主仍要交出退還；因為利未人城裡的房屋，是他們在以色列人中的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","只是他們城郊之地不可出賣，因為是他們永遠的地業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“如果你的兄弟貧窮，在你那裡手頭拮据，你要資助他，使他可以與你一同生活，像旅客寄居的一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","你不可向他收取高利，卻要敬畏你的　神，使你的兄弟可以與你一同生活。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","你借錢給他，不可向他取利息；借糧給他，也不可要他多還。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","我是耶和華你們的　神，曾經把你們從埃及地領出來，要把迦南地賜給你們，而且要作你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“你的兄弟在你那裡若是貧窮了，賣身給你，你不可逼他作奴僕的工作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","他在你那裡要像雇工和寄居的一樣；他要服事你直到禧年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","到了禧年，他和他的兒女要離開你，歸回他本家，歸回自己祖宗的地業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","因為他們是我的僕人，是我從埃及地領出來的，他們不可以賣作奴僕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","你不可嚴嚴地轄制他，卻要敬畏你的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","至於你需要的僕婢，可以來自你們四圍的列國，你們可以從他們中間購買奴婢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","你們也可以從那些與你們住在一起的外人的兒女中，或是從他們的家族中，就是那些與你們在一起，在你們境內所生的，購買奴婢；他們要作你們的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","你們要把他們留給你們的子孫作永遠的產業，你們要從他們中間取奴僕；只是你們的兄弟以色列人，你們卻不可苛刻管轄。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“在你中間寄居的外人或是客旅若是富足起來，你的兄弟在他那裡卻漸漸窮乏，把自己賣給住在你那裡寄居的外人或客旅的家族， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","賣了自己以後，他仍有贖回的權利；他兄弟中的任何一個都可以贖他； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","他的叔伯或是他叔伯的兒子可以贖他，他家族中的骨肉至親也可以贖他；如果他自己的經濟能力改善，也可以自贖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","他要與買主計算，從賣身那一年起，直到禧年為止；照著年數的多少，按雇工的工價計算贖銀。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","如果賣身時還有很多年才到禧年，他就要按著年數，照他賣身的價銀按比例償還他的贖價。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","如果距離禧年只有幾年，他就按著年數，與買主計算，按雇工的工價，償還他的贖價。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","買主要像每年雇用的工人那樣待他。不可在你眼前苛刻地管轄他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","如果他不在這些年間把自己贖回，到了禧年，也可以和他的兒女一同離去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","因為以色列人都是屬我的僕人；他們是我的僕人，是我把他們從埃及地領了出來的；我是耶和華你們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“你們不可為自己做偶像，不可為自己立雕像或神柱，也不可在你們的境內安置石像，向它跪拜；因為我是耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","你們要遵守我的安息日；敬畏我的聖所；我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","你們遵行我的律例，謹守我的誡命，遵照奉行， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","我就按時給你們降下雨露，使地生出土產，田野的樹木也結果實。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","你們打禾，必打到摘葡萄的時候，摘葡萄必摘到撒種的時候；你們吃食物，吃得飽足，在你們的境內安然居住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","我必使你們境內太平；你們睡覺，沒有人驚嚇你們；我使惡獸在境內絕跡；刀劍也不經過你們的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","你們必追趕仇敵，他們必在你們面前倒在刀下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","你們五個人必追趕一百人，一百人必追趕一萬人；你們的仇敵必在你們面前倒在刀下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","我眷顧你們，使你們繁殖增多，也必堅立我與你們所立的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","你們吃久藏的舊糧，要挪出舊糧，騰空給新糧。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","我必在你們中間安置我的居所，我的心也不厭棄你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","我要在你們中間行走；我要作你們的　神，你們要作我的子民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","我是耶和華你們的　神，曾經把你們從埃及地領出來，使你們不再作他們的奴僕；我折斷了你們所負的軛，使你們挺身昂首地行走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“但如果你們不聽從我，不遵行這一切誡命； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","如果你們棄絕我的律例，你們的心厭棄我的典章，不遵行我的一切誡命，違背我的約， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","我就要這樣待你們：我必命驚慌臨到你們，癆病熱病使你們眼目昏花，心靈憔悴；你們必徒然撒種，因為你們的仇敵必吃盡你們的出產。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","我向你們變臉，你們就敗在仇敵面前；恨惡你們的要管轄你們；雖然沒有人追趕，你們仍然逃跑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","經過這些以後，如果你們還不聽從我，我就要因你們的罪加重七倍管教你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","我必粉碎你們誇耀的力量；我要使你們的天像鐵，你們的地像銅； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","你們的氣力徒然用盡；你們的地不出產，境內的樹也不結果實。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“如果你們行事為人與我的心意相違，不肯聽從我，我就要按著你們的罪，使災禍加重七倍地臨到你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","打發野地的走獸到你們中間，奪去你們的兒女，殘害你們的牲畜，減少你們的人口，使你們的道路荒涼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“但如果你們經過這些事仍然不歸向我，行事仍與我的心意相違， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","我也要與你們作對，按著你們的罪，再加重七倍擊打你們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","使刀劍臨到你們，報復背約的仇；聚集你們到城裡，好使我打發瘟疫在你們中間，把你們交在仇敵的手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","我斷絕你們的糧食來源以後，十個女人要共用一個爐子給你們烤餅，她們配給定量的餅給你們；你們要吃，卻吃不飽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“如果你們經過這事，還是不聽從我，行事仍與我的心意相違， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","我就必發烈怒，與你們作對；我要按著你們的罪，再加重七倍管教你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","你們要吃自己兒子的肉，女兒的肉也要吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","我必毀壞你們的邱壇，砍倒你們的香壇，把你們的屍體扔在你們仆倒的偶像上面；我的心必厭棄你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","我必使你們的城市變為荒場，使你們的聖所荒涼；我也不聞你們馨香的祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","我要使地荒涼，連住在那裡的仇敵也驚奇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","我要把你們分散在萬國中，我又拔出刀來追趕你們；你們的地成為荒涼，你們的城市變成荒場。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“當那地荒涼，你們又住在仇敵之地的時候，地就享受安息；那地要休歇，享受安息。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","因為你們居住在那裡的時候，地不能在你們的安息年中享受安息，唯有在荒涼的日子，才可享安息。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","至於你們剩下的人，我必使他們在仇敵之地膽戰心驚；風吹落葉也會嚇跑他們；他們必逃跑，好像逃避刀劍一樣；雖然無人追趕，他們卻跌倒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","雖然無人追趕，他們卻像面臨刀劍，彼此撞跌；你們在仇敵面前，不能站立得住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","你們要在萬國中滅亡；仇敵之地必吞滅你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","你們剩下的人，必因自己的罪孽在仇敵之地消滅，也因犯了祖先的罪孽日漸衰弱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“那時他們就會承認自己的罪孽和他們祖先的罪孽，就是他們對我不忠的過犯，又承認因為行事與我的心意相違， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","以致我也與他們作對，把他們帶到他們的仇敵之地。如果他們未受割禮的心這樣謙卑下來，情願接受他們罪孽的刑罰， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","我就記念我與雅各所立的約，記念我與以撒所立的約，與亞伯拉罕所立的約；我也記念這地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","他們會離開這地，地在荒涼無人的時候，就可以享受安息，同時他們要接受他們罪孽的刑罰，因為他們棄絕了我的典章，他們的心厭棄了我的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","雖然這樣，他們住在仇敵之地的時候，我還是不棄絕他們，也不厭棄他們，不把他們滅絕，我不會違背我與他們所立的約；因為我是耶和華他們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","因為他們的緣故，我要記念我與他們祖先所立的約；他們的祖先是我在列國眼前，從埃及地領出來的，為要作他們的　神；我是耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","這些是耶和華在西奈山，藉著摩西頒布他和以色列人之間的律例、典章和法則。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“你要告訴以色列人，對他們說：如果人許特別的願，獻身給耶和華，就要依照你的估價獻身價。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","你應該這樣估價：從二十歲到六十歲的男人，你要按著聖所衡量銀子的標準，估價五百五十克銀子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","如果是女人，你要估價三百四十二克銀子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","如果是五歲到二十歲，男子的估價是二百二十八克銀子，女子是一百一十四克銀子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","如果是一個月到五歲，男子的估價是五十七克銀子，女子是三十四克銀子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","如果是六十歲以上，男子的估價是一百七十一克銀子，女子是一百一十四克銀子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","那人若是貧窮，不能支付你估定的價，就要把他帶到祭司面前，讓祭司估定他的價；祭司就按著許願的人的經濟能力，估定他的價。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","如果所許的是可以獻給耶和華為供物的牲畜，獻給耶和華的任何牲畜，都要分別為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","不可更換，也不可代替；無論是好的換壞的，或是壞的換好的，都不可以。如果人一定要以另一隻牲畜代替以前所許的牲畜獻上，那麼以前所許的和用來交換的，都要分別為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","所許的若是不潔淨的牲畜，人不能把牠獻給耶和華為供物，就是把牲畜牽到祭司面前； ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","祭司要按牲畜的好壞估價；祭司估價多少，就是多少。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","如果他一定要把牲畜贖回，就要按你的估價，多付五分之一。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“如果有人把房屋分別為聖獻給耶和華，祭司要按房屋的好壞估價，祭司估價多少，就定它價值多少。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","把自己房屋分別為聖的人，如果要贖回房屋，就要按你估定的價銀，多加五分之一，房屋才可以歸他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“如果有人把自己產業的一部分，分別為聖獻給耶和華，你的估價要根據那地的撒種量：每撒大麥二十公斤，估價五百七十克銀子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","如果他從禧年起，把自己的田地分別為聖，就要按照你的估價定那田地的價值。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","如果他在禧年以後，把自己的田地分別為聖，祭司就要照著到下一個禧年所剩餘的年數，給他計算價銀，然後從你的估價減去這價銀。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","把自己田地分別為聖的人，如果一定要贖回田地，就要按你的估價，多付五分之一，田地才可以歸他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","如果他不贖回田地，而賣給別人，他就再也不能贖回田地了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","到了禧年，買主就要交出那地歸耶和華為聖，像永屬耶和華的聖地一樣，歸祭司為產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","如果人把買來的田地，不是自己承受為業的田地，分別為聖獻給耶和華， ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","祭司就要按照你的估價，給他計算，直到禧年為止；價值多少，他必須當天付給你估定的價銀，表示把那地獻給耶和華為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","到了禧年，那地要歸還賣主，就是歸還那承受那地為業的原主。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","你的一切估價，都要照著聖所衡量銀子的標準。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“唯獨牲畜的頭一胎，無論是牛或是羊，既然頭一胎是屬於耶和華的，人就不能再把牠分別為聖，因為這本是耶和華的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","但如果是不潔淨的牲畜，他就要按照你的估價，加上五分之一把牠贖回；如果不贖回，就要按照你的估價賣掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“一切永屬耶和華的聖物，就是人永獻給耶和華的物，無論是人或是牲畜，或是他承受作產業的田地，都不可以變賣，也不可以贖回；一切永獻之物都是歸耶和華為至聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","如果有人永獻牲畜作永屬耶和華的聖物，就不可贖回；必須把牠殺死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“地上的一切，無論是地上的種子或是樹上的果子，十分之一是耶和華的，是歸給耶和華為聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","如果人一定要贖回這十分之一，除物價以外，還要加上五分之一。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","牛群和羊群的十分之一，就是一切從牧人杖下經過的，每第十隻都是歸耶和華為聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","人不可理會是好或是壞，也不可把牠更換；如果一定要更換，本來的與更換的，都要分別為聖，不能贖回。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","以上這些就是耶和華在西奈山，為以色列人吩咐摩西的律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","以色列人出埃及地以後，第二年二月一日，耶和華在西奈的曠野，在會幕裡對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“你們要把以色列全體會眾，按著他們的宗族、父家，根據人名數目，統計人口；所有男丁，都要按著人口登記。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","在以色列中，凡是二十歲以上，能出去打仗的，你和亞倫要按著他們的隊伍數點他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","每一個支派要有一人幫助你們；他們每一個都是他父家的首領。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","以下就是幫助你們的人的名字：屬流本支派的，有示丟珥的兒子以利蓿； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","屬西緬支派的，有蘇利沙代的兒子示路蔑； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","屬猶大支派的，有亞米拿達的兒子拿順； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","屬以薩迦支派的，有蘇押的兒子拿坦業； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","屬西布倫支派的，有希倫的兒子以利押； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","約瑟的子孫中，屬以法蓮支派的，有亞米忽的兒子以利沙瑪；屬瑪拿西支派的，有比大蓿的兒子迦瑪列； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","屬便雅憫支派的，有基多尼的兒子亞比但。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","屬但支派的，有亞米沙代的兒子亞希以謝； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","屬亞設支派的，有俄蘭的兒子帕結； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","屬迦得支派的，有丟珥的兒子以利雅薩； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","屬拿弗他利支派的，有以南的兒子亞希拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","這些人是從會眾中選出來，都是他們宗族支派的領袖；他們是以色列的族長。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","於是，摩西和亞倫帶著這些提名指定的人， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","在二月一日召集了全體會眾；他們就照著他們的宗族，按照他們的父家，根據人名數目，二十歲以上的，都按著人口一一登記了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","耶和華怎樣吩咐摩西，摩西就怎樣在西奈的曠野數點了他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","以色列的長子，流本子孫的後代，照著宗族、父家，根據人名數目，按著人口，二十歲以上，能出去打仗的男丁，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","流本支派被數點的，共有四萬六千五百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","西緬子孫的後代，照著宗族、父家，根據人名數目，按著人口，二十歲以上，能出去打仗的男丁，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","西緬支派被數點的，共有五萬九千三百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","迦得子孫的後代，照著他們的宗族、父家，根據人名數目，二十歲以上，凡是能出去打仗的，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","迦得支派被數點的，共有四萬五千六百五十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","猶大子孫的後代，照著他們的宗族、父家，根據人名數目，二十歲以上，凡是能出去打仗的，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","猶大支派被數點的，共有七萬四千六百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","以薩迦子孫的後代，照著他們的宗族、父家，根據人名數目，二十歲以上，凡是能出去打仗的，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","以薩迦支派被數點的，共有五萬四千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","西布倫子孫的後代，照著他們的宗族、父家，根據人名數目，二十歲以上，凡是能出去打仗的，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","西布倫支派被數點的，共有五萬七千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","約瑟的兒子，以法蓮子孫的後代，照著他們的宗族、父家，根據人名數目，二十歲以上，凡是能出去打仗的，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","以法蓮支派被數點的，共有四萬零五百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","瑪拿西子孫的後代，照著他們的宗族、父家，根據人名數目，二十歲以上，凡是能出去打仗的，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","瑪拿西支派被數點的，共有三萬二千二百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","便雅憫子孫的後代，照著他們的宗族、父家，根據人名數目，二十歲以上，凡是能出去打仗的，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","便雅憫支派被數點的，共有三萬五千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","但子孫的後代，照著他們的宗族、父家，根據人名數目，二十歲以上，凡是能出去打仗的，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","但支派被數點的，共有六萬二千七百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","亞設子孫的後代，照著宗族、父家，根據人名數目，二十歲以上，凡是能出去打仗的，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","亞設支派被數點的，共有四萬一千五百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","拿弗他利子孫的後代，照著他們的宗族、父家，根據人名數目，二十歲以上，凡是能出去打仗的，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","拿弗他利支派被數點的，共有五萬三千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","以上就是被數點的人數，是摩西和亞倫，以及以色列的首領十二人（每父家一人）所數點的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","這樣，在以色列中，按著父家，二十歲以上，凡是能出去打仗的以色列人，都登記了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","被數點的，共有六十萬零三千五百五十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","只有利未人沒有按著他們家族的支派，數點在其中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","因為耶和華曾對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“只有利未支派，你不可數點，也不可把他們的總數列入以色列人中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","只要派利未人管理法櫃的帳幕，和其中的一切器具，以及一切屬於帳幕的事物；他們要抬帳幕和其中的一切器具；他們要辦理帳幕的事，在帳幕四周安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","帳幕要起行的時候，利未人要把它拆卸下來；帳幕要支搭的時候，利未人要把它豎立起來；如果有外人走近，必須處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","以色列人安營，要依照他們的隊伍，各歸本營，各歸本旗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","但利未人要在法櫃帳幕的四周安營，免得　神的忿怒臨到以色列的會眾；利未人要負看守法櫃的帳幕的責任。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","以色列人就這樣行了，耶和華怎樣吩咐摩西，他們就怎樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“以色列人要各歸自己的旗下，在自己父家的旗號下安營；他們要在會幕四周稍遠的地方安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","在東方向著日出之地，按著隊伍安營的，是猶大營的旗號；猶大人的領袖是亞米拿達的兒子拿順。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","他的隊伍被數點的，共有七萬四千六百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","在他旁邊安營的，是以薩迦支派；以薩迦人的領袖是蘇押的兒子拿坦業， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","他的隊伍被數點的，共有五萬四千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","又有西布倫支派；西布倫人的領袖是希倫的兒子以利押。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","他的隊伍被數點的，共有五萬七千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","凡是屬猶大營，按著隊伍被數點的，共有十八萬六千四百人；他們要首先出發。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“在南方，按著隊伍，是流本營的旗號；流本人的領袖是示丟珥的兒子以利蓿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","他的隊伍被數點的，共有四萬六千五百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","在他旁邊安營的，是西緬支派；西緬人的領袖是蘇利沙代的兒子示路蔑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","他的隊伍被數點的，共有五萬九千三百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","又有迦得支派；迦得人的領袖是丟珥的兒子以利雅薩。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","他的隊伍被數點的，共有四萬五千六百五十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","凡是屬流本營，按著隊伍被數點的，共有十五萬一千四百五十人；他們要作第二隊起行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“會幕和利未人的營要在眾營中間前行；他們怎樣安營，就怎樣出發前行；各按本位，各歸本旗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“在西方，按著隊伍，是以法蓮營的旗號；以法蓮人的領袖是亞米忽的兒子以利沙瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","他的隊伍被數點的，共有四萬零五百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","在他旁邊的，是瑪拿西支派，瑪拿西人的領袖是比大蓿的兒子迦瑪列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","他的隊伍被數點的，共有三萬二千二百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","又有便雅憫支派；便雅憫人的領袖是基多尼的兒子亞比但。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","他的隊伍被數點的，共有三萬五千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","凡是屬以法蓮營，按著隊伍被數點的，共有十萬零八千一百人；他們要作第三隊起行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“在北方，按著隊伍，是但營的旗號；但人的領袖是亞米沙代的兒子亞希以謝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","他的隊伍被數點的，共有六萬二千七百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","在他旁邊安營的，是亞設支派；亞設人的領袖是俄蘭的兒子帕結。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","他的隊伍被數點的，共有四萬一千五百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","又有拿弗他利支派；拿弗他利人的領袖是以南的兒子亞希拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","他的隊伍被數點的，共有五萬三千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","凡是屬但營被數點的，共有十五萬七千六百人；他們要隨著自己的旗號，最後起行。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","以上是照著他們的父家被數點的以色列人；所有按著他們的隊伍在眾營中被數點的，共有六十萬零三千五百五十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","只有利未人沒有數點在以色列人中，這是耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","以色列人就照著耶和華吩咐摩西的一切行了，他們隨著自己的旗號安營，各人按著自己的宗族和父家起行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","耶和華在西奈山上與摩西說話的日子，亞倫和摩西的後代如下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","亞倫的兒子的名字如下：長子是拿答，還有亞比戶、以利亞撒、以他瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","這就是亞倫的兒子的名字，他們是受膏的祭司，是摩西叫他們承受聖職擔任祭司的職分的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","拿答和亞比戶在西奈曠野把凡火獻在耶和華面前的時候，死在耶和華面前；他們沒有兒子；以利亞撒和以他瑪，就在他們的父親亞倫面前，擔任祭司的職分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“你要叫利未支派近前來，使他們站在亞倫祭司面前，可以服事他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","他們要替亞倫和全體會眾，在會幕前盡上本分，辦理帳幕的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","他們又要看守管理會幕裡的一切器具，也要替以色列人盡上本分，辦理帳幕的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","你要把利未人派給亞倫和他的兒子，因為他們是從以色列人中選出來完全給他的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","你要委派亞倫和他的兒子，使他們謹守自己祭司的職分；外人走近，必被治死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","耶和華告訴摩西： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“看哪，我從以色列人中，揀選了利未人，代替以色列人所有頭生的，就是他們的長子，所以利未人要歸我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","因為所有頭生的，都是我的；我在埃及地擊殺所有頭生的那天，就把以色列中所有頭生的，無論人畜，都分別為聖歸我；他們要歸我，我是耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","耶和華在西奈曠野對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“你要照著利未人的父家、宗族，數點他們；所有男丁，一個月以上的，你都要數點。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","於是，摩西照著耶和華的命令，就是耶和華吩咐他的，數點了利未人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","利未眾子的名字是：革順、哥轄、米拉利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","革順兒子的名字，按著宗族，是立尼和示每。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","哥轄的兒子，按著宗族，是暗蘭、以斯哈、希伯倫、烏薛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","米拉利的兒子，按著宗族，是抹利、母示。這些人按著他們的父家，都是利未人的宗族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","屬革順的，有立尼家族和示每家族；這是革順人的家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","根據所有男丁的數目，一個月以上，被數點的，共有七千五百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","革順人的家族，要在帳幕的後面，就是西方安營； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","革順人家族的領袖是拉伊勒的兒子以利雅薩。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","革順的子孫在會幕中的職分，是看守帳幕、罩棚、罩棚的頂蓋和會幕門口的簾子， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","還有院子的帳幕、院子門口的簾子（院子是環繞帳幕和祭壇的），以及院子使用的一切繩子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","屬哥轄的，有暗蘭家族、以斯哈家族、希伯倫家族和烏薛家族；這是哥轄人的家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","根據所有男丁的數目，一個月以上的，共有八千六百人；他們要盡看守聖所的職分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","哥轄子孫的家族要在帳幕的南方安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","哥轄家族的領袖是烏薛的兒子以利撒反。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","他們的職分是管理約櫃、桌子、燈臺、兩座壇，以及他們在聖所內使用的器具、簾子和帳幕裡使用的一切東西。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","亞倫祭司的兒子以利亞撒要作利未人眾領袖中的領袖，要監察那些盡看守聖所職分的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","屬米拉利的，有抹利家族和母示家族；這些是米拉利的家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","根據所有男丁的數目，一個月以上，被數點的，共有六千二百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","米拉利二家族的領袖，是亞比亥的兒子蘇列；他們要在帳幕的北方安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","米拉利子孫的職分，是看守帳幕的木板、門閂、柱子、插座、一切器具，以及負責一切有關的事務， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","還有看守院子四周的柱子、插座、橛子和繩子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","在帳幕前面東邊，就是在會幕向日出的方向安營的，是摩西、亞倫和亞倫的兒子；他們代替以色列人應盡的職責，看守聖所；外人近前來，必被治死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","摩西和亞倫照著耶和華的命令，數點了所有的利未人；按著家族，凡是男丁，一個月以上被數點的，共有二萬二千人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","耶和華對摩西說：“以色列人中所有頭生的男子，一個月以上的，你都要數點；登記他們的姓名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","我是耶和華，你要把利未人歸我，代替以色列人所有頭生的；也要把利未人的牲畜歸我，代替以色列人中一切頭生的牲畜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","摩西就照著耶和華吩咐他的，把以色列人所有頭生的都數點了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","根據人名的數目，一個月以上，凡是頭生的男子，被數點的，共有二萬二千二百七十三個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“你要揀選利未人代替以色列人所有頭生的，也要揀選利未人的牲畜代替以色列人的牲畜；利未人要歸我，我是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","至於那超過利未人總數的二百七十三個，需要贖回的以色列人的長子， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","你要每人收取贖銀五十七克，要按照人數，根據聖所的秤收取，就是按照聖所的標準重量（“就是按照聖所的標準重量”，原文作“一舍客勒是二十季拉”）。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","你要把那超額人數的贖銀，交給亞倫和他的兒子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","於是，摩西就從那些被利未人贖回以外的人收取贖銀； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","從頭生的以色列人收取的銀子，根據聖所的秤，共有六百八十二公斤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","摩西照著耶和華的吩咐，把這贖銀交給了亞倫和他的兒子，正如耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“你要從利未人中，登記哥轄子孫的總數，照著他們的家族、父家， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","從三十歲以上，直到五十歲，能進來供職，在會幕裡工作的，你都要登記。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","哥轄子孫在會幕裡的工作就是管理至聖之物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","起營出發的時候，亞倫和他的兒子要進去，把遮蓋至聖所的幔子卸下來，用來遮蓋約櫃； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","又把海狗皮罩蓋在上面，再鋪上純藍色的布，然後把槓穿上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","在陳設餅的桌子上，他們要鋪上藍色布，把盤子、碟子、杯和奠酒的爵擺在上面，桌子上也必須有常獻餅； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","在這些物件上面，他們要鋪上朱紅色布，再蓋上海狗皮罩，然後把槓穿上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","他們要拿藍色布，把燈臺和燈臺上的燈盞、剪子、蠟花盤，以及為燈臺所用一切盛油的器具遮蓋起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","他們又要把燈臺和燈臺的一切器具，都包在海狗皮裡，然後放在抬架上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","在金壇上面，他們要鋪上藍色布，再蓋上海狗皮罩，然後把槓穿上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","他們又要把聖所裡供職使用的一切器具，都包在藍色布裡，再蓋上海狗皮罩，然後放在抬架上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","他們要清除壇上的灰，把紫色布鋪在壇上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","又要把在壇上供職使用的一切器具，就是火鼎、肉叉、鏟子、盤子，都擺在上面；再蓋上海狗皮罩，然後穿上槓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","全營出發的時候，亞倫和他的兒子，把聖所和聖所的一切器具遮蓋完了以後，哥轄的子孫就要來抬；只是他們不可觸摸聖物，免得他們死亡。會幕裡這些物件是哥轄的子孫應當抬的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","亞倫祭司的兒子以利亞撒的職務是看管點燈的油、芬芳的香、常獻的素祭和膏油，也要看管整個帳幕和其中所有的一切，以及聖所和聖所的器具。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","耶和華對摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“你們不可把哥轄家族的派系從利未人中剪除； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","他們接近至聖之物的時候，亞倫和他的兒子要進去，指定他們各人當辦的和當抬的工作；你們要這樣待他們，好讓他們活著，不至死亡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","只是他們連片刻也不可進去觀看聖物，免得他們死亡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“你也要登記革順子孫的總數，照著他們的父家、家族， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","從三十歲以上，直到五十歲，能進來供職，在會幕裡工作的，你都要數點。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","革順人的家庭所作的事和所抬的物如下： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","他們要抬帳幕的幔子、會幕和會幕的蓋，以及蓋在上面的海狗皮罩和會幕的門簾、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","院子的帷子、院子的門簾（院子是圍繞帳幕和祭壇的）、繩子，以及一切使用的器具；有關這些器具所當作的，他們都要辦理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","革順的子孫所有的任務，他們在一切當抬的和當辦的事上，都要照著亞倫和他兒子的吩咐；他們當抬的，你們都要把職務分派給他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","這是革順子孫的家族在會幕裡所辦的事；他們的職務要受亞倫祭司的兒子以他瑪的管理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“米拉利的子孫，你也要照著他們的宗族，按著他們的家室數點他們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","從三十歲以上，直到五十歲，能進來供職，在會幕裡工作的，你都要數點。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","他們在會幕裡的一切事奉，他們的職務，就是抬帳幕的木板、橫閂、柱子和插座、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","院子四周的柱子、插座、橛子、繩子、一切用具和使用的東西；他們當抬的器具，你們要按著名字一一指定。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","這是米拉利子孫的家族在會幕裡所辦的一切事務，都受亞倫祭司的兒子以他瑪的管理。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","摩西、亞倫和會眾的領袖們，把哥轄的子孫，按著他們的宗族和父家， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","從三十歲以上，直到五十歲，能進來供職，在會幕裡工作的，都數點了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","按著宗族，他們被數點的，共有二千七百五十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","這是哥轄家族被數點的人數，是所有在會幕裡辦事的人數，就是摩西和亞倫，照著耶和華藉摩西吩咐數點的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","革順的子孫，按著他們的宗族和父家被數點的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","從三十歲以上，直到五十歲，能進去供職，在會幕裡工作的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","按著他們的宗族和父家，被數點的人數，共有二千六百三十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","這些是革順子孫的家族被數點的人數，是一切在會幕裡辦事的，就是摩西和亞倫照著耶和華的吩咐數點的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","米拉利的子孫，按著宗族和父家， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","從三十歲以上，直到五十歲，能進去供職，在會幕裡工作的，都數點了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","按著宗族，他們被數點的，共有三千二百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","這些是米拉利子孫的家族被數點的人數，就是摩西和亞倫，照著耶和華的吩咐數點的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","被數點的利未人，就是摩西和亞倫，以及以色列的眾領袖，按著宗族和家室數點的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","從三十歲以上，直到五十歲，可以進去供職，在會幕裡作抬物件的工作的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","他們的人數，共有八千五百八十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","照著耶和華藉摩西吩咐的，把他們數點，各人按著自己所辦的事和所抬的物件被數點，正如耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“你要吩咐以色列人，把所有患痲風病的，患漏症的，以及因接觸死人而不潔的，都送出營外； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","無論男女，你們都要送出去；你們要把他們送出營外，免得他們玷污自己的營，這營就是我居住的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","以色列人就這樣行了，把他們送出營外；耶和華怎樣吩咐摩西，以色列人就怎樣行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“你要對以色列人說：無論男女，如果犯了人所犯的任何罪，以致得罪耶和華，那人就有了罪； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","他要承認自己所犯的罪，把虧負人的損失，原數賠償之外，另外加上五分之一，給予他虧負的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","如果那人沒有近親可以把所虧負的賠償給他，所虧負的，就要還給耶和華，就是歸給祭司，此外還要獻上為他贖罪的代罪公綿羊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","以色列人的一切聖物中，奉給祭司為舉祭的，都要歸給祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","各人所獻的聖物，要歸給祭司；人無論獻給祭司甚麼，都要歸給祭司。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“你要告訴以色列人說：無論甚麼人，如果他的妻子背離丈夫，對他不忠， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","有人和她同寢，事情瞞過了丈夫，沒有被查出，沒有見證人指證她，犯罪時也沒有被人捉住； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","如果她的丈夫生了疑心，疑忌妻子，而妻子實在是被玷污了；又或者丈夫生了疑心，疑忌妻子，而妻子並沒有被玷污， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","這人就要把妻子帶到祭司那裡，又要為她帶來供物，就是大麥麵一公斤，不可澆上油，也不可加上乳香，因為這是疑忌的素祭，是思念的素祭，使人思念罪孽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“祭司要使那婦人走進來，站在耶和華面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","祭司要把聖水盛在瓦器裡，又從帳幕的地面取些塵土，撒在水中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","祭司要使那婦人站在耶和華面前，鬆開她的頭髮，把思念的素祭，就是疑忌的素祭，放在她的手中，祭司的手裡要拿著使人招致咒詛的苦水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","祭司要叫那婦人起誓，對她說：‘如果沒有人與你同寢，作妻子時沒有背棄丈夫被人玷污，你就免受這使人招致咒詛的苦水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","但是，如果你作妻子時背棄了丈夫，被人玷污了；如果你在你的丈夫以外，曾與別的男人同寢’， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","這樣，祭司就要叫那婦人發咒起誓，繼續對她說：‘耶和華要使你的大腿消瘦，肚腹腫脹；願耶和華叫你在你的族人中成為咒詛和起誓的話柄； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","願這招致咒詛的水進入你的腹中，使你的肚腹腫脹，大腿消瘦。’那婦人要說：‘阿們、阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“祭司要把這些咒詛的話寫在卷上，又把所寫的字洗在苦水裡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","又要叫那婦人喝這招致咒詛的苦水，這招致咒詛的水要進入她裡面，就引起痛苦。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","祭司要從這婦人的手中取過那疑忌的素祭，把素祭在耶和華面前搖一搖，然後帶到祭壇那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","祭司要從素祭中取出一把來，作為記念，放在祭壇上焚燒，然後才叫婦人喝這水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","祭司叫她喝了這水以後，如果她被人玷污，對自己的丈夫不忠，這招致咒詛的水就必進入她裡面，引起痛苦；她的肚腹必腫脹，大腿必消瘦；那婦人就要在她的族人中成為咒詛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","但是，如果這婦人沒有被玷污，而是貞潔的，就不致受害，並且要懷孕生子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“這是關於疑忌的律例：妻子在自己丈夫的權下，如果背離丈夫，被人玷污了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","或是人生了疑忌的心，疑忌自己的妻子，他就要叫那婦人站在耶和華的面前，祭司要對她執行這法例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","這樣，男人可以免罪，婦人就要擔當自己的罪孽。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“你要告訴以色列人，對他們說：‘無論男女，如果許了特別的願，就是拿細耳人的願，就要離俗歸耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","他要戒除淡酒和濃酒；淡酒作的醋和濃酒作的醋，他都不可喝；不可喝任何葡萄汁，也不可吃鮮葡萄或乾葡萄。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","在他離俗的日子，葡萄樹上出產的，無論是葡萄核或是葡萄，都不可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“‘在他許願離俗的日子，不可用剃刀剃頭；他要聖潔，直到他離俗歸耶和華的日子滿了，他要由他的頭髮長長。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“‘在他離俗歸耶和華的日子，不可走近死人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","他的父母、兄弟或是姊妹，死了的時候，他不可因他們玷污自己，因為離俗歸他　神的記號，在他的頭上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","在他離俗的日子，他都是歸耶和華為聖的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“‘如果在他身旁，突然有人死了，以致他離俗的頭被玷污了，他就要在得潔淨的日子剃頭，就是在第七日剃頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","第八天，他要把兩隻斑鳩，或是兩隻雛鴿，帶到會幕門口交給祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","祭司要獻一隻作贖罪祭，一隻作燔祭，為他贖那因死人而玷污的罪；他要在當天使他的頭成為聖潔， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","使他重新離俗歸耶和華的日子，又要帶一隻一歲的公羊羔來作贖愆祭；以前的日子無效，因為他的離俗被玷污了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“‘拿細耳人的律例是這樣：離俗的人的日子滿了那天，人要把他帶到會幕的門口； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","他要把供物獻給耶和華，就是獻一隻完全沒有殘疾、一歲的公羊羔作燔祭，一隻完全沒有殘疾、一歲的母羊羔作贖罪祭，一隻完全沒有殘疾的公綿羊作平安祭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","一籃無酵調油的細麵餅和抹油的無酵薄餅，以及同獻的素祭和奠祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","祭司要在耶和華面前獻上這些供物，又要獻上他的贖罪祭和燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","他又要把那隻公綿羊和那一籃無酵餅，獻給耶和華作平安祭；祭司也要把同獻的素祭和奠祭獻上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","拿細耳人要在會幕門口剃他離俗的頭，把他離俗的頭髮拿去，放在平安祭下的火上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","拿細耳人剃去了自己離俗的頭髮以後，祭司就要取那煮過的公綿羊的一條前腿，又要從籃子裡取一個無酵餅和一個無酵薄餅，都放在拿細耳人的手上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","祭司要把這些作為搖祭，在耶和華面前搖一搖；這些作搖祭獻上的胸和作舉祭的腿，同為聖物歸給祭司；然後拿細耳人才可以喝酒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“‘許願的拿細耳人的律例是這樣：他獻給耶和華的供物是照著他離俗的願，不是根據他手上所得的；他怎樣許願，就當怎樣照著離俗的律例而行。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“你要告訴亞倫和他的兒子說：‘你們要這樣為以色列人祝福，對他們說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","願耶和華賜福你，保護你； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","願耶和華使他的臉光照你，賜恩給你； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","願耶和華敞臉垂顧你，賜你平安。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","他們要這樣奉我的名為以色列人祝福，我也要為他們祝福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","摩西豎立了帳幕的那天，就用膏抹它，使它成聖；又把其中的一切器具、祭壇和祭壇的一切器具，都用膏抹了，使它們成聖； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","以色列的眾領袖，就是他們父家的首領，都來奉獻；就是眾支派的領袖，是管理那些被數點的人的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","他們把自己的供物帶到耶和華的面前，就是六輛篷車和十二頭公牛，每兩個領袖奉獻一輛篷車，每個領袖奉獻一頭公牛；他們把這些都送到帳幕的面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“你要把這些收下，好作會幕事務的使用；你要把這些交給利未人，要按照各人所辦的事務給他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","於是摩西收下了車和牛，交給利未人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","他按著革順子孫所辦的事務，把兩輛車和四頭牛交給他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","又按著米拉利子孫所辦的事務，把四輛車和八頭牛交給他們；他們都受亞倫祭司的兒子以他瑪的管理； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","但是沒有分給哥轄的子孫，因為他們所辦的事是聖所的事，是要用肩頭抬的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","用膏抹祭壇的日子，眾領袖都獻上奉獻祭壇的禮物；眾領袖把自己的供物獻在祭壇前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","耶和華對摩西說：“眾領袖要獻上自己奉獻祭壇的供物，每天要有一位領袖來獻上供物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","頭一天獻上供物的，是猶大支派的亞米拿達的兒子拿順。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是亞米拿達的兒子拿順的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","第二天來獻的，是以薩迦的領袖，蘇押的兒子拿坦業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","他獻上的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是蘇押的兒子拿坦業的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","第三天來獻的，是西布倫子孫的領袖，希倫的兒子以利押。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是希倫的兒子以利押的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","第四天來獻的，是流本子孫的領袖，示丟珥的兒子以利蓿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是示丟珥的兒子以利蓿的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","第五天來獻的，是西緬子孫的領袖，蘇利沙代的兒子示路蔑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是蘇利沙代的兒子示路蔑的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","第六天來獻的，是迦得子孫的領袖，丟珥的兒子以利雅薩。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這就是丟珥的兒子以利雅薩的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","第七天來獻的，是以法蓮子孫的領袖，亞米忽的兒子以利沙瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是亞米忽的兒子以利沙瑪的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","第八天來獻的，是瑪拿西子孫的領袖，比大蓿的兒子迦瑪列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是比大蓿的兒子迦瑪列的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","第九天來獻供物的，是便雅憫子孫的領袖，基多尼的兒子亞比但。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是基多尼的兒子亞比但的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","第十天來獻的，是但子孫的領袖，亞米沙代的兒子亞希以謝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是亞米沙代的兒子亞希以謝的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","第十一天來獻的，是亞設子孫的領袖，俄蘭的兒子帕結。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","一隻公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是俄蘭的兒子帕結的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","第十二天來獻的，是拿弗他利子孫的領袖，以南的兒子亞希拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","他的供物是一個銀盤，重一公斤半，一個銀碗，重八百克，都是按聖所的秤；這兩樣都盛滿調油的細麵作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","一個金盂，重一百一十克，盛滿了香； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","一頭公牛犢、一隻公綿羊、一隻一歲的公羊羔，作燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","一頭公山羊作贖罪祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","作平安祭的，是兩頭公牛、五隻公綿羊、五隻公山羊、五隻一歲的公羊羔；這是以南的兒子亞希拉的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","用膏抹祭壇的日子，以色列的眾領袖獻上奉獻祭壇的供物，共有銀盤十二個、銀碗十二個、金盂十二個， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","每個銀盤重一公斤半，每個銀碗重八百克；一切器皿的銀子，按聖所的秤，共有二十七公斤零六百克； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","金盂十二個，盛滿了香，按聖所的秤，每個金盂重一百一十克；這些金盂的金子，共有一公斤零三百二十克； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","作燔祭的牲畜，共有公牛犢十二頭、公綿羊十二隻、一歲的公羊羔十二隻，還有同獻的素祭，以及作贖罪祭的公山羊十二隻； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","作平安祭的牲畜，共有公牛二十四頭、公綿羊六十隻、公山羊六十隻、一歲的公羊羔六十隻；這就是用膏抹祭壇以後，所獻上奉獻祭壇的供物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","摩西進入會幕要與耶和華說話的時候，就聽見法櫃的施恩座上，二基路伯中間，有與他說話的聲音，是耶和華與他說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“你要告訴亞倫：‘你點燈的時候，七盞燈都要照向燈臺的前面。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","亞倫就這樣行了；他把燈臺上的燈都點著了，使光照向燈臺的前面，正如耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","這燈臺的做法是這樣：是用金子錘出來的，從座到花都是錘出來的。摩西製造燈臺，是照著耶和華指示的樣式做的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“你要從以色列人中間選出利未人，潔淨他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","你潔淨他們當這樣行：要把除罪水灑在他們身上，又叫他們用剃刀剃全身；把衣服洗淨，潔淨自己。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","然後，叫他們取一頭公牛犢和同獻的素祭，就是用油調和的細麵；你要另取一頭公牛犢，作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","你要把利未人帶到會幕前面，又要召集以色列的全體會眾； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","你要把利未人帶到耶和華面前，以色列人要按手在他們身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","亞倫要把利未人獻在耶和華面前，作以色列人中的搖祭，使他們辦理耶和華的事務。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","利未人要按手在那兩頭牛的頭上；你要把一隻作贖罪祭，一隻作燔祭，獻給耶和華，為利未人贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","你又要叫利未人站在亞倫和他的兒子們面前，把他們作搖祭獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","“這樣，你要把利未人從以色列人中分別出來，利未人就要歸我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","以後，利未人可以進去辦理會幕的事；你要潔淨他們，把他們作搖祭獻上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","因為他們是以色列人中完全獻給我的；我選出了他們歸我，是代替以色列人中所有頭生的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","因為以色列人中所有頭生的，連人帶畜都是我的；我在埃及地擊殺所有頭生的那一天，就把他們分別為聖歸我了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","我選出了利未人，代替以色列人中所有頭生的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","我從以色列人中，把利未人賜給亞倫和他的眾子，在會幕裡辦理以色列人的事務，又為以色列人贖罪，免得他們走近聖所的時候，就有災禍臨到他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","摩西、亞倫和以色列的全體會眾，就向利未人這樣行了；耶和華指著利未人吩咐摩西的，以色列人都照樣向他們行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","於是利未人潔淨了自己，把衣服洗淨；亞倫把他們作搖祭獻在耶和華面前；亞倫又為他們贖罪，潔淨他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","然後，利未人才進去，在亞倫和他的眾子面前，在會幕裡辦理他們的事務；耶和華指著利未人怎樣吩咐摩西，以色列人就怎樣向他們行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“關於利未人的職責是這樣：從二十五歲以上的，要進來辦理會幕裡的事務； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","到了五十歲，就要停止辦理事務，不再辦事； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","只要在會幕裡幫助自己的兄弟，盡忠職守，事務卻不必辦理了。關於利未人的職守，你要這樣向他們行。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","以色列人出埃及地以後，第二年正月，耶和華在西奈曠野吩咐摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“以色列人要在指定的時間守逾越節， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","就是本月十四日，黃昏的時候，你們要在指定的時間守這節，要照著這節的一切律例和一切典章而行。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","於是，摩西吩咐以色列人要守逾越節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","他們就在正月十四日，黃昏的時候，在西奈曠野守了逾越節；耶和華怎樣吩咐了摩西，以色列人就怎樣行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","有幾個人因為觸著死人而不潔淨，以致他們不能在那一天守逾越節；當日他們來到摩西和亞倫面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","這些人對摩西說：“我們雖然因為接觸死人而不潔淨，為甚麼我們被拒絕，不能在以色列人中，在指定的時間獻耶和華的供物呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","摩西對他們說：“你們且等候，我要去聽耶和華對你們有甚麼吩咐。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“你要告訴以色列人說：你們或你們的後代中，如果有人因為接觸死人而成為不潔淨，或因到遠方旅行，他還要向耶和華守逾越節； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","他們要在二月十四日，黃昏的時候，守逾越節，同時要吃無酵餅和苦菜； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","一點也不留到早晨，羊羔的骨頭，一根也不可折斷；他們要照著逾越節的一切律例守節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","但那潔淨的，又不在路上旅行的人，如果忽略守逾越節，那人就要從自己的民中被剪除，因為他沒有在指定的時間內獻上耶和華的供物，那人必擔當自己的罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","如果有外人寄居在你們中間，想要向耶和華守逾越節，他就必須照著逾越節的條例和典章而行；不論是外人或是本地人，只有一樣的條例。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","在豎立帳幕的那一天，有雲彩遮蓋著帳幕，就是法櫃的帳幕；到了晚上，雲彩在帳幕上，形狀像火，直到早晨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","常常是這樣：白天有雲彩遮蓋帳幕，夜間雲彩形狀像火。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","雲彩甚麼時候從會幕上收去，以色列人就起行；雲彩在甚麼地方停住，以色列人就在那裡安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","以色列人照著耶和華的吩咐起行，也照著耶和華的吩咐安營；雲彩在帳幕上停留多久，他們就安營多久。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","如果雲彩多日停留在帳幕上，以色列人就遵守耶和華的吩咐，不起行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","有時雲彩停留在帳幕上只有幾天，他們就照著耶和華的吩咐安營；也照著耶和華的吩咐起行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","有時雲彩從晚上到早晨停住；到了早晨，雲彩一收上去，他們就起行；有時雲彩從白晝到晚上都停住；雲彩一收上去，他們就起行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","雲彩停留在帳幕上不論有多久，或兩天、或一月、或一年，以色列人就安營，不起行；雲彩一收上去，他們就起行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","他們照著耶和華的吩咐安營，也照著耶和華的吩咐起行。他們遵守耶和華吩咐的，就是照著耶和華藉摩西吩咐的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“你要用銀子作兩枝號，要錘出來的，可以用來召集會眾，也可以叫會眾拔營起行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","吹號的時候，全體會眾都要到你那裡，聚集在會幕的門口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","如果單吹一枝，眾領袖，就是以色列的族長，都要到你那裡聚集。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","你們吹大聲的時候，那在東邊的營，都要起行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","你們第二次吹大聲的時候，那在南邊的營，都要起行；他們要起行，必須吹大聲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","但召集會眾的時候，你們要吹號，卻不要吹大聲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","亞倫的子孫作祭司的要作吹號的；這要作你們世世代代永遠的條例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","你們在本地與欺壓你們的仇敵作戰的時候，就要吹大聲，使你們在耶和華你們的　神面前得蒙記念，也得拯救脫離你們的仇敵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","此外，在你們快樂的日子和指定的節期，以及月朔，你們獻燔祭和平安祭的時候，也要吹號，這都要在你們的　神面前替你們作為記念；我是耶和華你們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","第二年二月二十日，雲彩從法櫃的帳幕收上去的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","以色列人就從西奈曠野按站起行；雲彩在巴蘭曠野停住了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","這是他們第一次照著耶和華藉摩西吩咐他們的起程。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","猶大營的旗號，按著他們的隊伍，首先起行；統領隊伍的，是亞米拿達的兒子拿順。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","統領以薩迦支派隊伍的，是蘇押的兒子拿坦業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","統領西布倫支派隊伍的，是希倫的兒子以利押。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","帳幕拆下來以後，革順的子孫和米拉利的子孫，就抬著帳幕起行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","流本營的旗號，按著他們的隊伍起行；統領隊伍的，是示丟珥的兒子以利蓿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","統領西緬支派的，是蘇利沙代的兒子示路蔑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","統領迦得支派隊伍的，是丟珥的兒子以利雅薩。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","哥轄人抬著聖物起行；他們到達之前，人已經把帳幕豎立起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","以法蓮營的旗號，按著他們的隊伍起行；統領隊伍的，是亞米忽的兒子以利沙瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","統領瑪拿西支派隊伍的，是比大蓿的兒子迦瑪列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","統領便雅憫支派隊伍的，是基多尼的兒子亞比但。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","但營的旗號，作眾營的後隊，按著他們的隊伍起行；統領隊伍的，是亞米沙代的兒子亞希以謝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","統領亞設支派隊伍的，是俄蘭的兒子帕結。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","統領拿弗他利支派隊伍的，是以南的兒子亞希拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","這是以色列人起行的時候，按著他們的隊伍起行的次序。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","摩西對自己的岳父米甸人流珥的兒子何巴說：“我們要起行到耶和華應許的地方去，他曾說：‘我要把那地賜給你們’，現在求你與我們同去，我們必善待你，因為耶和華對以色列已經應許福樂。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","何巴對摩西說：“我不去，我要歸回我本地本族那裡去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","摩西說：“求你不要離開我們，因為你知道我們應怎樣在曠野安營，你可以作我們的眼目。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","如果你與我們同去，將來耶和華用甚麼好處待我們，我們也必用甚麼好處待你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","以色列人從耶和華的山起行，行了三天的路程，耶和華的約櫃在他們前面行了三天的路程，為他們尋找安息的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","他們拔營起行的時候，日間總有耶和華的雲彩在他們上頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","約櫃起行的時候，摩西就說：“耶和華啊，求你起來，願你的仇敵四散；願恨你的人從你面前逃跑。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","約櫃停住的時候，他就說：“耶和華啊，求你歸來，回到以色列的千萬人中。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","人民發怨言，惡聲達到耶和華的耳中；耶和華聽見了，就發烈怒；耶和華的火就在他們中間焚燒，燒毀了營地的邊界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","人民向摩西呼求，摩西懇求耶和華，火就熄了， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","就稱那地方作他備拉，因為耶和華的火曾在他們中間焚燒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","他們中間的閒雜人起了貪慾，甚至連以色列人也哭著說：“誰給我們肉吃呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","我們記得在埃及的時候，可以不花錢吃魚，還有黃瓜、西瓜、韭菜、蔥和蒜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","現在我們的心都枯乾了；除了這嗎哪以外，在我們眼前，甚麼都沒有。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","這嗎哪仿佛芫荽子，又好像珍珠。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","人民走來走去，把嗎哪拾起來，或用磨磨碎，或用臼搗碎，或用鍋煮，或做成餅，它的滋味好像油餅的滋味。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","夜間露水降在營上的時候，嗎哪也隨著降下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","摩西聽見人民都在各人的帳棚門口哀哭，耶和華就大發烈怒，摩西也不高興。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","摩西對耶和華說：“你為甚麼苦待你的僕人，為甚麼我沒有在你面前蒙恩呢？竟把管理這人民的重擔全放在我身上呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","這人民豈是我懷的胎，豈是我生的嗎？你竟對我說：‘把他們抱在懷裡，像養育之父抱吃奶的孩子，直抱到你起誓應許給他們們列祖的地方去。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","我從哪裡得肉給這人民吃呢？因為他們都向我哭著說：‘你給我們肉吃吧！’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","我不能獨自擔當管理這人民的責任，因為實在太重了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","你既然這樣待我，如果我在你面前蒙恩，求你把我殺了，免得我看見自己的苦楚。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","耶和華對摩西說：“你要從以色列的長老中為我召聚七十個人，就是你認識的民間的長老和官長，領他們到會幕那裡，叫他們與你一同站在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","我要在那裡降臨，與你說話，也要把在你身上的靈，分給他們，他們就與你一同擔當管理人民的責任，免得你獨自擔當。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","你要對人民說：‘你們應當自潔，預備明天可以吃肉，因為你們哭著向耶和華說：“誰給我們肉吃呢？”所以耶和華必給你們肉吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","你們不是吃一天兩天，不是吃五天十天，也不是吃二十天， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","而是吃一個整月，直到肉從你們的鼻孔裡噴出來，成為你們厭惡的東西；因為你們輕視了住在你們中間的耶和華，在他面前哭著說：“我們為甚麼出埃及呢？”’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","摩西說：“這與我同住的人，能行的男人就有六十萬，你還說：‘我要給他們肉吃，使他們可以吃一個整月。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","難道把羊群和牛群都給他們宰了，就夠他們吃嗎？或是把海裡所有的魚都給他們聚了來，就夠他們吃嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","耶和華對摩西說：“耶和華的手臂縮短了嗎？現在你要看看我的話應驗不應驗。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","於是摩西出來，把耶和華的話告訴人民，又從民間的長老中召聚了七十個人來，使他們站在會幕的周圍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","耶和華在雲中降臨，對摩西說話，把摩西身上的靈，分給那七十個長老；靈停在他們身上的時候，他們就說預言，以後卻沒有再說。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","那時還有兩個人留在營裡；一個名叫伊利達，一個名叫米達；靈也停在他們身上。他們原是在被錄取的人中，卻沒有到會幕那裡去；他們就在營裡說預言。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","有個少年人跑來，告訴摩西：“伊利達和米達在營中說預言。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","摩西的侍從，嫩的兒子約書亞，就是摩西所揀選的，回答說：“我主，摩西，請你制止他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","摩西對他說：“你為我的緣故嫉妒嗎？但願耶和華的人民都是先知，但願耶和華把他的靈降在他們身上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","於是摩西和以色列的長老，都回營去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","有風從耶和華那裡吹起，把鵪鶉由海面颳來，散落在營地；鵪鶉在營的四周，這邊約有一天的路程，那邊約有一天的路程，離地面約有一公尺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","人民起來，那一天終日終夜，並次日一整天，都在捕捉鵪鶉，最少的也捕捉了約二千公升；他們都擺在營地的四周。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","肉在他們牙齒之間，還沒有嚼爛，耶和華的怒氣就向人民發作，用極重的災禍擊打他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","於是那地方名叫基博羅．哈他瓦，因為他們在那裡埋葬起了貪慾的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","人民從基博羅．哈他瓦起行，到哈洗錄去，就住在哈洗錄。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","米利暗和亞倫，為了摩西所娶的古實女子的緣故，就出言反對摩西，因為他娶了一個古實女子為妻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","他們說：“難道耶和華單單與摩西說話，不也與我們說話嗎？”這話耶和華聽見了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","摩西為人十分謙和，勝過世上所有的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","耶和華忽然對摩西、亞倫和米利暗說：“你們三個人都出來，到會幕那裡去。”他們三個人就出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","耶和華在雲柱中降臨，停在會幕門口，呼召亞倫和米利暗；他們二人就前去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","耶和華說：“現在你們要聽我的話，如果你們中間有先知，我耶和華必在異象中向他顯現，在夢中與他說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","可是，對我的僕人摩西卻不是這樣，他是在我全家忠心的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","我要與他面對面說話，是親自說的，不是用謎語；他必看見耶和華的形象，你們出言反對我的僕人摩西，為甚麼不懼怕呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","耶和華向他們發怒，就走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","雲彩從會幕上離開，米利暗就長了大痲風，像雪那樣白；亞倫轉身過來看米利暗，見她長了大痲風。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","亞倫就對摩西說：“我主啊，求你不要因我們行事愚昧所犯的罪，就把這罪加在我們身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","求你不要叫她像個死胎，一出母腹，肉就半腐爛了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","於是摩西向耶和華哀求，說：“　神啊，求你醫好她。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","耶和華對摩西說：“如果她的父親吐唾沫在她臉上，她不是要蒙羞七天嗎？現在把她關在營外七天，然後才讓她回來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","於是米利暗被關在營外七天；人民沒有啟程，直到把米利暗接回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","然後，人民從哈洗錄起行，在巴蘭的曠野安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“你要派人窺探我賜給以色列人的迦南地；按著父家所屬的支派，每支派要派一個人，個個都必須是他們的領袖。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","摩西就照著耶和華的吩咐，從巴蘭的曠野派他們去了；他們都是以色列人的領袖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","以下是他們的名字：屬流本支派的是撒刻的兒子沙母亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","屬西緬支派的是何利的兒子沙法。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","屬猶大支派的是耶孚尼的兒子迦勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","屬以薩迦支派的是約色的兒子以迦。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","屬以法蓮支派的是嫩的兒子何西亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","屬便雅憫支派的是拉孚的兒子帕提。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","屬西布倫支派的是梭底的兒子迦疊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","屬約瑟支派的，就是屬瑪拿西支派的，是蘇西的兒子迦底。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","屬但支派的是基瑪利的兒子亞米利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","屬亞設支派的是米迦勒的兒子西帖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","屬拿弗他利支派的是瓦縛西的兒子拿比。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","屬迦得支派的是瑪基的兒子臼利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","以上是摩西派去窺探那地的人的名字。摩西稱嫩的兒子何西亞為約書亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","摩西派他們去窺探迦南地，對他們說：“你們要從這裡上南地，然後上山地去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","看看那地怎樣，住在那裡的人是強是弱，是多是少； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","看看他們住的地怎樣，是好是壞；看看他們所住的城鎮怎樣，是營地，還是城堡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","看看那地怎樣，是肥沃還是貧瘠，那裡有樹木沒有。你們要壯膽，把那地的果子帶些回來。”那時正是葡萄初熟的時候。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","他們上去窺探了那地，從尋的曠野到利合，直到哈瑪關口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","他們上到南地，到了希伯崙，在那裡有亞衲族人的後裔亞希幔、示篩、撻買。原來希伯崙城比埃及的瑣安城早建七年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","他們來到以實各谷，從那裡砍下了一根葡萄枝子，上頭只有一掛葡萄，兩個人用槓抬著回來；他們也帶了些石榴和無花果回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","因為以色列人從那裡砍來的那掛葡萄，所以那地方叫作以實各谷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","四十天以後，他們窺探那地完畢，就回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","他們來到了巴蘭曠野的加低斯，見摩西、亞倫和以色列的全體會眾，向摩西、亞倫及全體會眾報告，又把那地的果子給他們看。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","他們告訴摩西：“我們到了你派我們去的那地，果然是流奶與蜜的地，這就是那地的果子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","只是住在那地的人強壯，城又堅固又十分高大，並且我們在那裡也看見了亞衲族人的後裔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","有亞瑪力人住在南地；赫人、耶布斯人、亞摩利人住在山地；迦南人住在海邊和約旦河沿岸。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","迦勒在摩西面前使眾人鎮靜，說：“我們立刻上去，佔領那地吧！因為我們必能得勝。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","但是，那些與他同去的人卻說：“我們不能上去攻擊那民，因為他們比我們強。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","那些探子就他們窺探之地向以色列人報惡信，說：“我們經過要窺探的地方，是個吞吃居民的地方；我們在那裡看見的人，個個都高大。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","在那裡我們看見了巨人，就是亞衲人的子孫，是巨人的後裔；我們看自己好像是蚱蜢，他們看我們也是這樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","當時，全體會眾大聲喧嚷；那夜眾民都哭號。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","以色列人向摩西和亞倫發怨言；全體會眾都對他們說：“但願我們早死在埃及地，或死在這曠野。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","耶和華為甚麼把我們領到這地來，死在刀劍之下呢？我們的妻子和孩子要被擄掠。我們回埃及去，豈不更好嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","於是他們彼此說：“我們另立一個首領，回埃及去吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","摩西和亞倫就俯伏在以色列全體會眾面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","窺探那地的人中，有嫩的兒子約書亞和耶孚尼的兒子迦勒；他們撕裂衣服， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","對以色列全體會眾說：“我們去窺探的那地，是十分美好的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","耶和華若是喜悅我們，就必把我們領進那地，把那地賜給我們，那地原是流奶與蜜的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","只要你們不背叛耶和華，就不必怕那地的人，因為他們是我們的食物；蔭庇他們的，已經離開他們了，耶和華卻與我們同在；不要怕他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","全體會眾都說要用石頭打死他們二人。這時，耶和華的榮光在會幕中向以色列眾人顯現。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","耶和華對摩西說：“這民藐視我要到幾時呢？我雖然在他們中間行了這些神蹟，他們還是不信我要到幾時呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","我要用瘟疫擊殺他們，除滅他們；我要使你成為大國，比他們還強。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","摩西對耶和華說：“這樣埃及人必聽見這事，因為你曾用大能，把這民從他們中間領上來； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","埃及人也必告訴那地的居民。那地的居民也曾聽見你耶和華是在這人民中間，你耶和華曾面對面的向人顯現，你的雲彩常停在他們上面；日間你在雲柱中，夜間你在火柱中，走在他們前面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","現在如果你把這人民殺死，像殺死一人，那些聽見你名聲的萬國就必議論說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘因為耶和華不能把這民領進他向他們起誓應許的地，所以在曠野把他們殺了。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","現在求主大發能力，照著你說過的話： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘耶和華不輕易發怒，且有豐盛的慈愛；他赦免罪孽和過犯；絕不以有罪的為無罪，必追討罪孽，自父到子，直到三四代。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","求你照著你的大慈愛，饒恕這人民的罪孽，好像你從埃及直到現在，常赦免這人民一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","耶和華說：“我就照著你的話，赦免他們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","但是，我指著我的永生起誓，全地要被耶和華的榮耀充滿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","這些見過我的榮耀，和我在埃及與曠野所行的神蹟的人，仍然試探了我這十次，不聽從我的話； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","他們決不得看見我向他們的祖宗起誓應許之地；藐視我的，一個也不能看見那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","但是我的僕人迦勒，因他另有一個心志，專心跟從我，我必把他領進他去過的那地；他的子孫也必得著那地為業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","現在亞瑪力人和迦南人住在山谷中，明天你們要回轉，從到紅海路上，起行到曠野去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","耶和華吩咐摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“這惡會眾向我發怨言要到幾時呢？以色列人向我所發的怨言，我都聽見了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","你要對他們說：‘耶和華說，我指著我的永生起誓，我必照著你們所說給我聽的，對待你們： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","你們的屍體必倒在這曠野；你們中間被數點過的，就是按著你們的數目，從二十歲以上，向我發過怨言的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","都不得進入我起誓給你們居住的那地；只有耶孚尼的兒子迦勒和嫩的兒子約書亞才可以進去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","但是你們的孩子，就是你們所說他們必被擄掠的，我要把他們領進去，他們必得著你們厭棄的那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","至於你們，你們的屍體必倒在這曠野。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","你們的兒女必在曠野飄流四十年，擔當你們背信之罪，直到你們的屍體在曠野都滅盡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","照著你們窺探那地的日數共四十天，一天算一年，你們要擔當罪孽四十年，你們就知道我為甚麼與你們作對。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","我耶和華已經說了，我必要這樣對待這聚集反抗我的惡會眾；他們要在這曠野滅盡，在這裡死亡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","摩西派去窺探那地的人回來，因為帶回有關那地的惡信，以致全體會眾都向摩西發怨言， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","這些帶回有關那地的惡信的人，都遭受瘟疫死在耶和華面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","只有嫩的兒子約書亞和耶孚尼的兒子迦勒，仍然活著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","摩西把這些話告訴以色列眾人，他們就非常悲哀。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","他們清早起來，上山頂去，說：“我們在這裡；我們要上耶和華應許的地方去，因為我們犯了罪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","摩西說：“你們為甚麼又違背耶和華的命令呢？這事必不能成功。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","你們不要上去，因為耶和華不在你們中間，免得你們在仇敵面前被殺敗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","因為亞瑪力人和迦南人都在那裡，在你們面前，你們必倒在刀下；因為你們轉離不跟隨耶和華，耶和華不與你們同在。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","他們卻擅自上山頂去，但是耶和華的約櫃和摩西並沒有離開營地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","於是，亞瑪力人和住在那山上的迦南人就下來，擊殺他們，粉碎他們，直到何珥瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“你要告訴以色列人：你們進入我賜給你們居住之地的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","如果要從牛群或羊群，拿牛羊作火祭獻給耶和華，無論是燔祭，或是其他的祭，為要還特許的願，或是作甘心的祭，或是在你們的節期獻上的，都要獻給耶和華作為馨香的祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","那獻供物的，要把一公斤細麵和一公斤油調和作素祭，獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","此外，無論是燔祭或是別的祭，為每隻綿羊羔你要一同獻上一公升作奠祭的酒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","或是為每隻公綿羊，你要一同獻上兩公斤細麵，用一公升半油調和作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","你也要用一公升半酒作奠祭，獻給耶和華作馨香的祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","你若是預備公牛犢作燔祭，或是別的祭，為要還特許的願，或是作平安祭，獻給耶和華， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","就要把三公斤細麵，用兩公升油調和作素祭，和公牛犢一同獻上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","也要用兩公升酒作奠祭，獻給耶和華為馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“獻一頭公牛，或一隻公綿羊，或一隻綿羊羔，或一隻山羊羔，都要這樣辦理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","照著你們預備的數目，每隻都要這樣辦理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","本地人獻馨香的火祭給耶和華，都要這樣辦理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","如果有外人與你們同住，或有人世世代代住在你們中間的，要獻馨香的火祭給耶和華；你們怎樣辦理，他也要怎樣辦理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","至於全眾，無論是你們，或是與你們同住的外人，都一樣的規例，作你們世世代代永遠的規例；在耶和華面前，你們怎樣，寄居的人也怎樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","你們和住在你們中間的外人，都只有一樣的法規，一樣的典章。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“你要告訴以色列人：你們到了我領你們進去的那地， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","吃那地的糧食的時候，就要把舉祭獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","你們要用初熟的麥麵作餅當舉祭獻上，你們獻時，好像獻上禾場的舉祭一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","你們世世代代要把初熟的麥麵作舉祭獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“如果你們作錯了事，沒有守耶和華吩咐摩西的這一切命令， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","就是耶和華藉摩西吩咐你們的一切事，從耶和華吩咐的那一天起，直到你們的世世代代； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","如果有無心之失，是會眾不知道的，全體會眾就要把一頭公牛犢作燔祭，作為獻給耶和華馨香的祭，並且照著規章把素祭和奠祭一同獻上，又獻一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","祭司要為以色列全體會眾贖罪，他們就必蒙赦免；因為這是無心之失，他們又因自己的無心之失，把供物，就是獻給耶和華的火祭和贖罪祭，一起奉到耶和華面前， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","以色列全體會眾和寄居在他們中間的外人，就必蒙赦免，因為全體人民都犯了無心之失。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“如果一個人誤犯了罪，他就要獻一隻一歲的母山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","祭司要在耶和華面前為那誤犯的人贖罪，因為他犯罪是出於無心；祭司為他贖罪，他就必蒙赦免。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","對於犯了無心之失的人，無論是本地人或是寄居在他們中間的外人，都有一樣的法例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","但那膽大妄為的人，無論是本地人或是寄居的，若是褻瀆了耶和華，那人總要從民間剪除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","因為他藐視耶和華的話，違犯耶和華的命令，那人必被剪除；他的罪孽要歸到他身上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","以色列人在曠野的時候，有一個人在安息日撿柴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","遇見他撿柴的人，就把他帶到摩西、亞倫和全體會眾那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","他們把他收在監裡，因為要怎樣辦他，還未明朗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","耶和華對摩西說：“那人必須處死，全體會眾要在營外用石頭把他打死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","於是全體會眾把他拉出營外，用石頭把他打死，正如耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“你要告訴以色列人，叫他們世世代代在自己衣服的邊上作繸子，又在繸子上，釘上一根藍色的細帶子； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","這要作你們的繸子，叫你們一看見，就記得耶和華的一切命令，並且遵行；不隨從自己的心意和眼目亂跑，像你們素常亂跑行淫一樣， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","好使你們記得，並且遵行我的一切命令，又使你們成為聖潔，歸給你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","我是耶和華你們的　神，曾把你們從埃及地領出來，為要作你們的　神；我是耶和華你們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","利未的曾孫、哥轄的孫子、以斯哈的兒子可拉，和流本子孫中以利押的兒子大坍、亞比蘭，與比勒的兒子安，帶著人來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","反抗摩西，還有以色列人中的二百五十個人，就是會眾的領袖；會眾中被選出有名望的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","他們聚集起來反抗摩西和亞倫，對他們說：“你們太過分了，全體會眾個個都是聖潔的，耶和華也在他們中間，你們為甚麼高抬自己，超過耶和華的會眾呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","摩西聽見了，就臉伏於地， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","對可拉和他的同黨說：“到了早晨，耶和華就要使人知道誰是屬他的；誰是聖潔的，就叫誰親近他；誰是他揀選的，就叫誰親近他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","你們要這樣作：可拉和你的同黨，你們要拿香爐來； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","明天你們要在耶和華面前，把火盛在爐中，把香放在上面；耶和華揀選誰，誰就是聖潔的，你們利未人太過分了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","摩西又對可拉說：“利未人哪，請聽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","以色列的　神把你們從以色列會眾中分別出來，使你們親近他，辦理耶和華帳幕的事務，又站在會眾面前替他們供職； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","耶和華又使你和你所有的兄弟，就是利未的子孫，一同親近他，這在你們看來是小事嗎？你們還要尋求祭司職分嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","所以你和你的同黨聚集起來反抗耶和華；亞倫算甚麼呢？你們竟向他發怨言。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","摩西派人去把以利押的兒子大坍和亞比蘭叫來；他們說：“我們不上去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","你把我們從流奶與蜜的地帶上來，要在曠野殺死我們，這算小事嗎？你還要自立為王管轄我們嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","況且你沒有把我們領到流奶與蜜的地，也沒有把田地和葡萄園給我們作產業。難道你要把這些人的眼睛剜出來嗎？我們不上去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","於是摩西大怒，對耶和華說：“求你不要悅納他們的禮物，我沒有奪過他們一頭驢，也沒有害過他們一個人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","摩西對可拉說：“明天你和你的同黨，以及亞倫，都要站在耶和華面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","你們各人要拿著自己的香爐，把香盛在上面；你們各人要把自己的香爐帶到耶和華面前，共二百五十個香爐；你和亞倫也各人拿著自己的香爐。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","於是，他們各人拿著自己的香爐，盛上火，加上香，與摩西和亞倫一同站在會幕門口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","可拉召聚了全體會眾到會幕門口，來攻擊摩西和亞倫，耶和華的榮光就向全體會眾顯現。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","耶和華對摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“你們要離開這會眾，我好在眨眼間把他們吞滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","摩西和亞倫就俯伏在地，說：“　神啊，萬人之靈的　神啊，一人犯罪，你就要向全體會眾發怒嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“你要吩咐會眾說：‘你們要離開可拉、大坍、亞比蘭帳幕的四周。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","於是摩西起來，到大坍和亞比蘭那裡去；以色列的長老也隨著他去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","摩西告訴會眾：“你們要遠離這些惡人的帳幕，凡是他們的東西，你們都不可摸，免得你們因他們的一切罪惡同遭毀滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","於是，眾人離開了可拉、大坍、亞比蘭帳幕的四周；大坍、亞比蘭就帶著妻子、兒女和小孩出來，站在自己的帳幕門口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","摩西說：“由此你們可以知道，我作這一切事，是耶和華派我作的，並不是出於我自己的心意。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","如果這些人死亡像一般人死亡一樣，或是他們所遭遇的像一般人的遭遇一樣，那麼就不是耶和華派我來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","如果耶和華作一件新事，使地開口，把他們和他們所有的都吞下去，叫他們活活地下到陰間，這樣你們就知道這些人是藐視耶和華了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","摩西說完了這一切話，他們腳下的地就裂開。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","地開了口，把他們和他們的家眷，以及一切屬可拉的人和財物，都吞了下去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","這樣，他們和一切屬他們的，都活活地下到陰間，地在他們上面合閉，他們就從會眾中滅亡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","在他們四周的以色列眾人，聽見他們的呼叫，就都逃跑，說：“恐怕地也把我們吞下去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","又有火從耶和華那裡出來，把那獻香的二百五十個人吞滅了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“你要吩咐亞倫祭司的兒子以利亞撒，叫他把那些香爐從火中拾起來，把火撒在別處，因為那些香爐是聖的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","那些自害己命的人的香爐也是聖的，你們要把它們錘成薄片，用來包蓋祭壇；那些香爐本是他們在耶和華面前獻過的，所以已經成為聖的，並且可以給以色列作鑒戒。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","於是，以利亞撒祭司把被火焚燒的人獻過的銅香爐拿起來，叫人錘成薄片，用來包蓋祭壇， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","給以色列人作鑒戒，叫不是亞倫子孫的外人，不可近前來，在耶和華面前燒香，免得他像可拉和他的同黨有一樣的遭遇；這是照著耶和華藉摩西吩咐以利亞撒的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","第二天，以色列全體會眾都向摩西和亞倫發怨言，說：“你們害死了耶和華的子民。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","會眾聚集攻擊摩西和亞倫的時候，他們轉身向會幕觀看，見有雲彩遮蓋會幕，耶和華的榮光顯現出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","摩西和亞倫就來到會幕前面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","耶和華吩咐摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“你們要離開這會眾，我好在眨眼間把他們消滅。”他們二人就俯伏在地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","摩西對亞倫說：“你要拿著香爐，把壇上的火盛在裡頭，又加上香，快快帶到會眾那裡去，為他們贖罪，因為有震怒從耶和華面前出來，瘟疫已經開始了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","亞倫照著摩西吩咐的把香爐拿來，跑到會眾中間，果然，瘟疫已經在人民中間開始了；他就加上香，為人民贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","他站在死人與活人中間，瘟疫就止住了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","除了因可拉事件死亡的以外，因瘟疫死亡的有一萬四千七百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","亞倫回到會幕門口摩西那裡，瘟疫已經止住了。（本章第36 50節在《馬索拉抄本》為17:1 15） ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","耶和華對摩西說：（本節在《馬索拉抄本》為17:16） ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“你要吩咐以色列人，要從他們手中取杖，按著父家每支派一根，從他們所有的領袖，按著他們的父家，共取十二根杖，你要把各人的名字寫在各人的杖上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","又要把亞倫的名字寫在利未的杖上，因為照著他們父家各族長必有一根杖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","你要把這些杖放在會幕裡約櫃前，就是我和你們相會的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","我揀選的那人，他的杖必發芽；這樣，我就必使以色列人向你們所發的怨言止息，不再達到我耳中。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","於是摩西吩咐以色列人，他們所有的領袖都把杖交給他，按著他們的父家，每個領袖一根杖，共有十二根杖；亞倫的杖也在其中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","摩西就把杖放在約櫃的會幕裡，在耶和華面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","第二天，摩西進約櫃的會幕去，不料，利未家亞倫的杖已經發了芽，生了花苞，開了花，結了熟杏。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","摩西就把所有的杖，從耶和華面前帶出來，給以色列眾人看；他們看見了，各人就把自己的杖拿了去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","耶和華對摩西說：“把亞倫的杖放回約櫃前，給那些背叛的人留作證據，這樣你就使他們向我發的怨言止息，免得他們死亡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","摩西就這樣行了，耶和華怎樣吩咐他，他就怎樣行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","以色列人對摩西說：“我們要死了，我們滅亡了，我們都滅亡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","走近耶和華帳幕的，都必定死；難道我們都要死嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","耶和華對亞倫說：“你和你的兒子，以及你父家的人，要與你一同擔當干犯聖所的罪孽，你和你的兒子要與你一同擔當干犯祭司職任的罪孽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","你要帶著你的親族利未支派的人，就是你祖宗支派的人，與你一同前來，使他們與你聯合，並且服事你；只是你和你的兒子要與你一同在約櫃的會幕前供職。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","他們要守你所吩咐的，和會幕裡的一切事，只是不可走近聖所的器具和祭壇，免得他們和你們都死亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","他們要與你聯合，也要守會幕的本分，辦理會幕的一切事務；只是外人不可走近你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","你們要看守聖所和祭壇，免得震怒再臨到以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","我已經把你們的親族利未人，從以色列人中揀選出來，給你們作禮物獻與耶和華，為要辦理會幕的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","你和你的兒子，要與你一同守你們祭司的職分，辦理一切屬祭壇和幔子內的事；你們要這樣供職。我把祭司的職分賜給你們作服事我的賞賜；外人若是近前來，必被處死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","耶和華對亞倫說：“我已經把保留歸我的舉祭，就是以色列人一切分別為聖的物，都賜給你和你的子孫，作為永遠應得的分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","以色列人所獻一切不經過火、至聖的供物，就是一切素祭、一切贖罪祭和一切贖愆祭，都要作至聖的物，歸給你和你的子孫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","你要在至聖的地方吃，凡是男的都可以吃；你要以此物為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","以色列人禮物中的舉祭，與他們的搖祭，都是你的；我已經給了你和你的兒女，作為永遠應得的分；在你家中潔淨的人都可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","最好的油、最好的新酒和五穀，就是以色列人獻給耶和華的初熟的物，我都賜給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","從他們地上帶來給耶和華的初熟的物，都要歸給你們；在你家中潔淨的人，都可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","以色列中一切永獻的物，都必歸給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","有血肉生命頭生的，無論是人或是牲畜，就是他們獻給耶和華的，都必歸給你；只是人類頭生的，你總要贖出來；不潔淨牲畜頭生的，也要贖出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","關於他們的贖價，一個月以上的，你要照你估定的價，按著聖所的秤，就是按照聖所的標準重量（“就是按照聖所的標準重量”，原文作“一舍客勒是二十季拉”），用五十七克銀子贖出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","只是頭生的牛、頭生的綿羊，或是頭生的山羊，你不可贖出來；牠們都是聖的。你要把牠們的血灑在祭壇上，把牠們的脂油焚燒，作為獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","牠們的肉卻要歸給你，像搖過的胸和右腿要歸給你一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","以色列人奉獻給耶和華聖物中的舉祭，我都賜給了你和與你在一起的兒女，作永遠應得的分；這是在耶和華面前給你和與你在一起的後裔作永遠的鹽約。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","耶和華對亞倫說：“你在以色列人的地不可有產業，在他們中間也不可有分；在以色列人中間，我就是你的分，是你的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“至於利未的子孫，我已經把以色列中所有的十分之一，賜給了他們作產業，這是為酬報他們在會幕裡辦理的事務。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","從今以後，以色列人不可走近會幕，免得他們負罪而死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","唯獨利未人要辦理會幕的事，要擔當他們的罪孽，這要作你們世世代代永遠的條例；在以色列人中，他們不可有產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","因為以色列人獻給耶和華為舉祭的十分之一，我已經賜給了利未人作產業；所以我對他們說：在以色列人中，他們不可有產業。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“你要告訴利未人：你們既然從以色列人手中，取得了我賜給你們作產業的十分之一，你們就要從這十分之一中，取出十分之一，獻給耶和華作為舉祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","這要算為你們的舉祭，好像禾場上的五穀，又像榨酒池中的酒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","這樣，你們也要把從以色列人取得的十分之一，作舉祭獻給耶和華；你們要把獻給耶和華的舉祭，歸給亞倫祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","從你們得的一切禮物中，要把最好的，分別為聖，獻給耶和華為舉祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","所以你要對利未人說：‘如果你們把最好的獻上，這就算為你們禾場上的糧和榨酒池中的酒了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","你們和你們的家人，隨處都可以吃，因為這是你們的工價，是你們在會幕裡辦事的報酬。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","如果你們把最好的獻上，就不致因此擔罪。以色列人的聖物，你們不可褻瀆，免得你們死亡。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","耶和華對摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“耶和華所定的律法是這樣說：你要吩咐以色列人，把一頭完全、沒有殘疾、未曾負過軛的紅母牛，牽到你這裡來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","你們要把牛交給以利亞撒祭司，他就要把牛牽到營外，在他面前把牛宰了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","以利亞撒祭司要用指頭蘸牛血，向會幕前面灑七次。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","然後，在他面前把牛焚燒，牛的皮、肉、血和糞，都要焚燒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","祭司要把香柏木、牛膝草、朱紅色線，都丟在燒牛的火中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","祭司要洗自己的衣服，並用水洗身，然後才可以進營；但祭司必不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","那燒牛的人也要用水洗自己的衣服，並用水洗身，也必不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","要由一個潔淨的人收起母牛的灰，安放在營外潔淨的地方，為以色列會眾留作除污穢的水，這是除罪的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","那收起牛灰的人，要洗自己的衣服，必不潔淨到晚上。這要給以色列人和寄居在他們中間的外人，作永遠的定例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“摸了任何死屍的，必不潔淨七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","那人在第三天要用這樣除污穢的水潔淨自己，到第七天他就潔淨了；如果他在第三天不潔淨自己，到第七天他就不潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","任何人摸了死屍，而不潔淨自己的，就玷污了耶和華的帳幕，這人必要從以色列中剪除，因為這除污穢的水沒有灑在他身上，所以他必不潔淨；他的不潔還留在他身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“如果人在會幕裡死了，條例是這樣的：進這會幕的和一切在會幕裡的，都必不潔淨七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","一切敞口的器皿，就是沒有蓋上蓋的，都是不潔淨的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","在田間摸了被刀殺死的，或是自己死的屍體，或是人的骨頭，或是墳墓，就必不潔淨七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","人要為這不潔淨的人，拿些燒成的除罪灰，放在器皿裡，倒上活水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","要由一個潔淨的人，拿牛膝草蘸在這水裡，把水灑在會幕上和一切器皿，以及在那裡的眾人身上，又灑在摸了骨頭，或是摸了被殺死的，或是摸了墳墓的人身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","第三天和第七天，那潔淨的人要灑水在不潔淨的人身上，這樣到第七天就使他潔淨；他要洗自己的衣服，用水洗身，到晚上就潔淨了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“但那污穢而不潔淨自己的，那人必從會眾中被剪除，因為他玷污了耶和華的聖所；除污穢的水沒有灑在他身上，他是不潔淨的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","這要給你們作永遠的定例。那灑了除污穢水的人，要洗自己的衣服；那摸了除污穢水的，必不潔淨到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","不潔淨的人摸過的一切，必不潔淨；摸了這物的人，也必不潔淨到晚上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","正月間，以色列全體會眾到了尋的曠野，就住在加低斯；米利暗死在那裡，也埋葬在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","會眾沒有水喝，就聚集攻擊摩西和亞倫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","人民與摩西爭鬧，說：“但願我們的兄弟在耶和華面前死去的時候，我們也一同死去！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","你們為甚麼把耶和華的會眾領到這曠野來，使我們和我們的牲畜都死在這裡呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","你們為甚麼使我們出埃及，領我們到這壞地方來呢？這裡不能撒種，沒有無花果樹、葡萄樹、石榴樹，也沒有水喝。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","摩西和亞倫於是離開會眾，來到會幕門口，俯伏在地；耶和華的榮光向他們顯現。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“你要拿著杖，和你的哥哥亞倫聚集會眾，在他們眼前，吩咐磐石；這樣你就可以使磐石流出水來，給會眾和他們的牲畜喝。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","於是，摩西照著耶和華吩咐他的，從耶和華面前拿了杖去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","摩西和亞倫聚集了會眾到磐石面前；摩西對他們說：“悖逆的人哪，你們要聽，我們為你們使水從磐石中流出來嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","摩西舉手，用杖擊打磐石兩次，就有很多水流出來，會眾和他們的牲畜都喝了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","耶和華對摩西和亞倫說：“因為你們不信我，不在以色列人眼前尊我為聖，所以你們必不得領這會眾進入我賜給他們的地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","這就是米利巴水，因為以色列人在那裡與耶和華爭鬧，耶和華在他們中間顯為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","摩西從加低斯派使者去見以東王說：“你的兄弟以色列這樣說：你知道我們遭遇的一切困難， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","就是我們的列祖下到埃及去，我們在埃及住了很多日子；埃及人惡待我們和我們的列祖； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","我們向耶和華呼求，他就聽了我們的聲音，派使者把我們從埃及領出來；現在我們就在你邊界上的城加低斯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","求你容我們從你的地經過；我們不走過田地和葡萄園，也不喝井裡的水，我們只走大路，不偏左也不偏右，直到走過了你的境地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","以東王對使者說：“你不可從我這裡經過，免得我帶著刀出來攻擊你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","以色列人對他說：“我們要走大路上去，我們和牲畜若是喝了你的水，我必照價付你；不求別的事，只求你容我們步行經過。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","以東王說：“你不可經過。”他就率領很多人出來，要用強硬的手攻擊以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","這樣，以東王不肯讓以色列人從他的境內經過，以色列人就離開他去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","以色列全體會眾從加低斯起行，到了何珥山。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","耶和華在以東地邊界的何珥山對摩西和亞倫說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“亞倫要歸到他本族人那裡去，他必不得進入我賜給以色列人的那地，因為在米利巴水的事上，你們違背了我的吩咐。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","你要帶著亞倫和他的兒子以利亞撒，一同上何珥山去； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","把亞倫的衣服脫下來，給他兒子以利亞撒穿上；亞倫就歸到他本族人那裡去，死在山上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","摩西就照著耶和華吩咐的行了，三人當著全體會眾的眼前上了何珥山。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","摩西把亞倫的衣服脫下來，給他的兒子以利亞撒穿上；亞倫就死在山頂那裡。於是，摩西和以利亞撒從山上下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","全體會眾見亞倫死了，以色列全家就為亞倫哀哭了三十天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","住在南地的迦南人亞拉得王，聽說以色列人從亞他林路來，就與以色列人交戰，擄了他們幾個人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","於是以色列人向耶和華許願，說：“如果你把這民交在我手裡，我就必把他們的城盡行毀滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","耶和華聽了以色列人的祈求，就把迦南人交給他們，於是他們把迦南人和他們的城盡行毀滅；那地方的名就叫何珥瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","他們從何珥山沿著到紅海的路起行，要繞過以東地；眾民因為這條路，心裡煩躁， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","就反抗　神和摩西，說：“你們為甚麼把我們從埃及領上來，使我們死在曠野呢？這裡沒有糧食，又沒有水，我們的心厭惡這淡薄的食物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","於是耶和華打發火蛇進入人民中間；蛇咬他們，許多以色列人就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","人民來見摩西，說：“我們有罪了，因為我們出惡言攻擊耶和華和你；求你向耶和華禱告，叫這些蛇離開我們。”於是摩西為眾人禱告。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","耶和華對摩西說：“你要做一條火蛇，掛在杆上；被咬的，一看這蛇，就必得存活。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","摩西就做了一條銅蛇，掛在杆上；被蛇咬了的人，一望這銅蛇，就活了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","以色列人又起行，在阿伯安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","再從阿伯起行，在以耶．亞巴琳安營，就是摩押對面的曠野，向日出之地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","他們又從那裡起行，在撒烈谷安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","又從那裡起行，在亞嫩河那邊安營；這亞嫩河是在曠野，從亞摩利人的境內流出來；原來亞嫩河就是摩押的邊界，在摩押與亞摩利人之間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","因此，在耶和華的戰書上記著：“在蘇法的哇哈伯，和亞嫩河的河谷， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","以及河谷的斜坡，這斜坡伸展到亞珥城的地方，就是靠近摩押邊境的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","以色列人又從那裡到了比珥（“比珥”意即“井”）；從前耶和華對摩西說：“你要聚集眾民，我好把水給他們喝”，說的就是這個井。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","那時，以色列人就唱了這首歌，說：“井啊，湧上水來。你們要向這井歌唱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","這井是領袖挖掘的，是民間的尊貴人，用圭用杖挖掘的。”以色列人從曠野到了瑪他拿， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","從瑪他拿到拿哈列，從拿哈列到巴末， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","從巴末到摩押地的谷，又到了俯瞰荒野的毗斯迦山頂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","以色列人派使者去見亞摩利人的王西宏說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“求你容我們從你的地經過；我們不偏入田間和葡萄園，也不喝井裡的水；我們只走大路，直到過了你的境界。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","西宏不容以色列人從他的境界經過，反而聚集了自己的人民，出到曠野去攻擊以色列人，西宏到了雅雜，與以色列人交戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","以色列人用刀擊殺了他，佔領了他的地，從亞嫩河到雅博河，直到亞捫人那裡，因為雅謝是亞捫人的邊界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","以色列人奪取了這一切城，也住在亞摩利人的各城，就是希實本，與屬於希實本的一切村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","這希實本是亞摩利人的王西宏的京城；西宏曾經與摩押以前的王交戰，從他手中奪去了所有的地，直到亞嫩河。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","因此詩人說：“你們來到希實本！願西宏的城被重建，願西宏的城堅立。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","因為有火從希實本發出，有火燄從西宏的城冒出，吞滅了摩押的亞珥，燒毀了亞嫩河的高岡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","摩押啊，你有禍了，基抹的民哪，你們滅亡了；基抹使自己的男子逃亡，使自己的女子被擄，交給了亞摩利人的王西宏。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","我們射擊他們，希實本就毀滅，直到底本。我們使地荒涼，直到挪法，挪法直伸到米底巴。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","這樣，以色列人就住在亞摩利人的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","摩西派人去窺探雅謝，以色列人就佔領了雅謝的村鎮，把那裡的亞摩利人趕走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","以色列人回頭，沿著到巴珊的路上走；巴珊王噩和他的眾民都出來迎著以色列人，在以得來與他們交戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","耶和華對摩西說：“不要怕他，因為我已經把他和他的眾民，以及他的地都交在你手裡；你要待他，像從前待那住在希實本的亞摩利人的王西宏一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","於是，他們殺了噩和他的兒子，以及他的眾民，沒有留下一個，就佔領了他的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","以色列人起行，在摩押平原安營，就是在約旦河東邊，耶利哥的對面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","以色列人向亞摩利人所行的一切事，西撥的兒子巴勒都看見了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","摩押人十分懼怕這民，因為他們眾多；摩押人因以色列人的緣故，十分恐慌。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","摩押人對米甸的長老說：“現在這群人要吞併我們四周的一切，好像牛吞吃田間的草一樣。”那時西撥的兒子巴勒，作摩押王； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","他就派使者到比珥的兒子巴蘭那裡去，就是到大河的毗奪，亞捫人的地那裡，去叫巴蘭來，說：“你看，有一個民族從埃及出來，遮滿了全地，如今住在我的對面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","現在請你來，替我咒詛這民，因為他們比我強盛，或者我能夠擊敗他們，把他們從這地趕出去；因為我知道你給誰祝福，誰就得福；你咒詛誰，誰就受咒詛。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","摩押的長老和米甸的長老，手裡帶著禮金去了；他們到了巴蘭那裡，把巴勒的話告訴他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","巴蘭對他們說：“今夜你們留在這裡，我必照著耶和華吩咐我的話答覆你們。”於是，摩押的領袖就與巴蘭同住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","神來到巴蘭那裡，說：“與你在一起的這些人是誰？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","巴蘭對　神說：“是摩押王西撥的兒子巴勒派到我這裡來的人，他們說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘你看，從埃及出來的民族，遮滿了全地；現在請你來，替我咒詛他們，或者我能夠戰勝他們，把他們趕走。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","神對巴蘭說：“你不可與他們同去，也不可咒詛那民，因為他們是蒙福的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","巴蘭早晨起來，對巴勒的領袖說：“你們回本地去吧，因為耶和華不准我與你們同去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","摩押的領袖起來，回到巴勒那裡，說：“巴蘭不肯與我們同來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","於是，巴勒又派比先前更多、更尊貴的領袖去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","他們來到巴蘭那裡，對他說：“西撥的兒子巴勒這樣說：‘求你不要推辭不到我這裡來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","因為我必使你大得尊榮；你向我說甚麼，我都照辦；只求你替我咒詛這民。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","巴蘭回答巴勒的臣僕說：“巴勒就算把他滿屋的金銀給我，但我不論作大事小事，也不能越過耶和華我　神的命令。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","現在請你們今夜也住在這裡，等我得知耶和華還要向我說甚麼。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","當夜，　神來到巴蘭那裡，對他說：“這些人既然來請你，你就起程與他們同去，但是你只要遵行我吩咐你的事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","巴蘭早晨起來，備上驢，與摩押的領袖一同去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","神因為巴蘭去就發怒；耶和華的使者站在路上敵擋他。那時他騎著驢，有兩個僕人同行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","驢看見了耶和華的使者站在路上，手裡拿著拔出來的刀，就轉離正路，走入田中去；巴蘭就打驢，要叫牠轉回路上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","耶和華的使者站在葡萄園間的窄路上，兩邊都有圍牆。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","驢看見了耶和華的使者，就緊擠在牆上，把巴蘭的腳擠傷了，巴蘭又打驢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","耶和華的使者又往前行，站在狹窄之處，左右都沒有轉身的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","驢看見了耶和華的使者，就臥在巴蘭身下；巴蘭大怒，就用自己的杖打驢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","耶和華開了驢的口，驢就對巴蘭說：“我向你作了甚麼，你竟打我這三次呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","巴蘭對驢說：“因為你作弄我。但願我手中有刀，現在就把你殺死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","驢對巴蘭說：“我不是你從起初一直所騎的驢嗎？我以前曾向你這樣行過嗎？”巴蘭說：“沒有。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","那時，耶和華開了巴蘭的眼睛，他就看見耶和華的使者站在路上，手裡拿著拔出來的刀，巴蘭就低頭俯伏在地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","耶和華的使者對他說：“你為甚麼這三次打你的驢呢？看哪，是我來敵擋你，因為你走的路在我面前邪僻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","驢看見了我，就三次從我面前轉開；驢若是沒有從我面前轉開，我早已把你殺了，而留牠活著。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","巴蘭對耶和華的使者說：“我有罪了，我不知道是你站在路上阻擋我；現在你若是不喜歡我去，我就回去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","耶和華的使者對巴蘭說：“你與這些人同去吧，但是你只要說我吩咐你的話。”於是巴蘭與巴勒的領袖一同去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","巴勒聽見巴蘭來了，就出去到摩押的京城迎接他；這城是在亞嫩河旁，在邊界的盡頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","巴勒對巴蘭說：“我不是急切地派人到你那裡去請你嗎？你為甚麼不到我這裡來呢？難道我不能使你得尊榮嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","巴蘭對巴勒說：“看哪，我已經來到你這裡，現在我怎能說甚麼呢？　神把甚麼話放在我口裡，我就說甚麼。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","巴蘭與巴勒同行，來到基列．胡瑣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","巴勒宰了牛羊，送給巴蘭和與他在一起的領袖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","到了早晨，巴勒帶著巴蘭上了巴力的高岡；巴蘭就從那裡觀看以色列民的邊界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","巴蘭對巴勒說：“你要在這裡給我築七座祭壇，給我預備七頭公牛，七隻公綿羊。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","巴勒照著巴蘭吩咐的行了；巴勒和巴蘭在每座祭壇上獻一頭公牛和一隻公綿羊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","巴蘭對巴勒說：“你要站在你的燔祭旁邊，我要往前去，或者耶和華會來迎見我；他指示我甚麼，我必告訴你。”於是巴蘭上了一塊高地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","神迎見巴蘭；巴蘭對　神說：“我已經預備了七座祭壇，在各座祭壇上獻了一頭公牛和一隻公綿羊。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","耶和華把話傳給巴蘭，又說：“你要回到巴勒那裡去，要這樣這樣說。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","他就回到巴勒那裡，見他和摩押所有的領袖都站在燔祭旁邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","巴蘭就作歌，說：“巴勒把我從亞蘭領出來，摩押王引我出東山，說：‘來吧，為我咒罵雅各，來啊，咒罵以色列。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","神沒有咒詛的，我怎能咒詛呢？耶和華沒有咒罵的，我怎能咒罵呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","我從高峰觀看他們，從山上眺望他們；這是獨居的民族，不列在萬國之中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","誰能數算雅各的灰塵？誰能計算以色列的四分之一呢？願我的死像正直人的死，願我之終如正直人之終。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","巴勒對巴蘭說：“你向我作的是甚麼事呢？我領你來咒詛我的仇敵，你反倒給他們祝福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","巴蘭回答，說：“耶和華傳給我的話，我怎能不謹慎說呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","巴勒對巴蘭說：“請你與我到另一個地方去，從那裡你可以看見他們；不過你不能看見他們全部，只能看見他們邊界的一部分；在那裡你要為我咒詛他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","於是巴勒帶巴蘭到了瑣腓田，上了毗斯迦山頂，築了七座祭壇，在每座祭壇上獻了一頭公牛和一隻公綿羊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","巴蘭對巴勒說：“你要在這裡站在你的燔祭旁邊，等我到那邊去迎見耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","耶和華見了巴蘭，把話傳給他，說：“你回到巴勒那裡去，要這樣這樣說。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","巴蘭回到巴勒那裡，見他站在自己的燔祭旁邊，摩押的領袖也與他在那裡。巴勒問巴蘭：“耶和華說了甚麼話呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","巴蘭作歌，說：“巴勒啊，要起來聽；西撥的兒子啊，側耳聽我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","神不是人，必不致說謊，也不是人子，必不致後悔。他說話，怎能不作？他發言，怎能不作成？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","我奉命來祝福；　神要賜福，我不能改變。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","在雅各中不見罪孽，在以色列中也不見患難；耶和華他們的　神與他們同在，有君王歡呼的聲音在他們中間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","領他們出埃及的　神，對他們有如野牛的角。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","在雅各中沒有觀兆的，在以色列中也沒有占卜；到了適當的時候，必有話對雅各和以色列說：‘　神為他們行了何等的大事！’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","這民族起來有如母獅，挺身好像公獅；不吃下獵物，不喝被殺的人的血，決不臥下。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","巴勒對巴蘭說：“你一點不要咒詛他們，也不要祝福他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","巴蘭回答巴勒說：“我不是告訴過你說：‘耶和華吩咐我的，我都必要遵行’嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","巴勒對巴蘭說：“你來，我領你到另一個地方去，或者　神喜歡你，你就可以在那裡為我咒詛他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","於是，巴勒領巴蘭到了俯視曠野的毗珥山頂去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","巴蘭對巴勒說：“你要在這裡給我築七座祭壇，也要為我預備七頭公牛和七隻公綿羊。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","巴勒就照著巴蘭所說的行了，在每座祭壇上，獻上一頭公牛和一隻公綿羊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","巴蘭見耶和華喜歡賜福以色列，就不再像前兩次一樣去求觀兆的方法，卻面向曠野。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","巴蘭舉目，看見以色列人按著支派居住，　神的靈就臨到他身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","他就作歌，說：“比珥的兒子巴蘭說：‘有眼光的人說， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","得聽　神的話語、得見全能者的異象、身體仆倒而眼目睜開的人說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","雅各啊，你的會幕多麼佳美；以色列啊，你的帳幕多麼美好！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","像擴展的棕林，如河邊的園子，似耶和華栽種的沉香樹，又像水旁的香柏樹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","必有水從他的桶中流出來，他的後裔必在多水之處；他的王必超過亞甲，他的國度必被高舉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","領他出埃及的　神，對他好像野牛的角；他要吞吃敵國，打碎他們的骨頭，用箭射透他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","他蹲伏躺下，好像公獅，又像母獅，誰敢使他起立呢？給你祝福的，願他蒙福；咒詛你的，願他受咒詛。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","巴勒向巴蘭生氣，就拍起手；巴勒對巴蘭說：“我請你來咒詛我的敵人，如今你反倒祝福他們這三次。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","現在你逃回你的地方去吧；我說過我要大大地使你得尊榮，但是耶和華阻止你使你不得尊榮。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","巴蘭對巴勒說：“我不是告訴了你派來的使者說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘就算巴勒把滿屋的金銀給我，我也不能越過耶和華的命令，隨自己的心意行好行歹’嗎？耶和華說甚麼，我就說甚麼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","現在我要回我本族去了；你來，我要告訴你這個民族日後要怎樣待你的人民。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","他就作歌，說：“比珥的兒子巴蘭說：‘開著眼的人說， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","那得聽　神的話語、明白至高者的知識、得見全能者的異象、身體仆倒而眼目睜開的人說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","我看見他，卻不是現在；我望見他，卻不是近處；必有一星從雅各而出，必有一杖從以色列興起；他必打碎摩押的額角，粉碎一切舍特人的頭頂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","他必得以東作產業，又得仇敵之地西珥作產業；只有以色列人成為強壯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","有一位從雅各而出的必掌大權，他要除滅城中餘下的人。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","巴蘭看見了亞瑪力，就作歌，說：“亞瑪力原是列國之首，他的結局卻是滅亡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","巴蘭看見了基尼人，就作歌，說：“你的居所堅固，你的窩巢建在磐石中； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","但基尼必被毀滅；亞述要到幾時才把你擄去呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","巴蘭又作歌，說：“哀哉，　神決定這事，誰能得活呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","必有船從基提而來，苦害亞述，苦害希伯；他卻要滅亡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","於是巴蘭起來，回自己的地方去；巴勒也回去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","以色列人住在什亭，人民與摩押的女子行起淫亂來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","那些女子叫以色列人來，一同給她們的神獻祭，以色列人也吃了她們的祭物，跪拜她們的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","以色列人與巴力．毗珥連合，耶和華就向以色列人發怒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","耶和華對摩西說：“把人民的首領都捉來，在我耶和華面前對著太陽把他們懸掛起來，好使耶和華的烈怒可以轉消，不向以色列人發作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","於是摩西對以色列的審判官說：“你們各人要把與巴力．毗珥連合的人都殺了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","摩西和以色列全體會眾在會幕門口哭泣的時候，以色列人中有一個人來，當著他們的面帶了一個米甸女子到自己的兄弟那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","亞倫祭司的孫子、以利亞撒的兒子非尼哈看見了，就從會眾中起來，手裡拿著槍， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","跟著那以色列人，進入臥室，把他們兩人刺透，就是刺透那以色列人和那女子。槍刺進了那女子的肚腹。這樣，在以色列人中的瘟疫才止住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","那時因瘟疫而死的，共有二萬四千人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“亞倫祭司的孫子、以利亞撒的兒子非尼哈，使我的烈怒稍消，不向以色列人發作，因為他在他們中間以我忌邪的心為心，使我不因我忌邪的心把他們消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","因此你要說：‘現在我把平安之約賜給他， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","要給他和他的後裔作為永遠擔當祭司職分的約，因為他為他的　神有忌邪的心，為以色列人贖罪。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","那被殺的以色列人，就是與那米甸女子一同被殺的人，名叫心利，是撒路的兒子，是西緬支派中一個家族的領袖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","那被殺的米甸女子，名叫哥斯比，是蘇珥的女兒；這蘇珥是米甸一個家族的族長。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“你要擾害米甸人，打擊他們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","因為他們用詭計擾害你們；在毗珥的事上，和他們的姊妹，米甸領袖的女兒哥斯比的事上，用詭計欺騙了你們。”這哥斯比在瘟疫的日子，因毗珥的事被殺了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","瘟疫以後，耶和華對摩西和亞倫的兒子以利亞撒說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“你們要把以色列會眾，從二十歲以上，在以色列中能出去打仗的，按著他們的父家，計算數目。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","於是，摩西和以利亞撒祭司在摩押曠野，就是在耶利哥附近的約旦河邊，告訴他們： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“從二十歲以上的，你們都要登記數目。”這是照著耶和華吩咐摩西的。從埃及地出來的以色列人計有： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","以色列的長子流本：流本的子孫，屬哈諾的，有哈諾家族；屬法路的，有法路家族； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","屬希斯倫的，有希斯倫家族；屬迦米的，有迦米家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","這些是流本的家族；他們被數點的，共有四萬三千七百三十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","法路的兒子是以利押； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","以利押的兒子是尼母利、大坍、亞比蘭。這大坍和亞比蘭原是從會眾中選拔出來的，他們和可拉一黨的人一起與耶和華爭吵，也與摩西和亞倫爭吵的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","地開了口，把他們和可拉吞了下去；可拉與他的同黨都死了，那時有火吞滅了二百五十個人，他們成了警戒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","但是，可拉的子孫卻沒有死亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","西緬子孫，按著家族，屬尼母利的，有尼母利家族；屬雅憫的，有雅憫家族；屬雅斤的，有雅斤家族； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","屬謝拉的，有謝拉家族；屬掃羅的，有掃羅家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","這些就是西緬的各家族，共有二萬二千二百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","迦得子孫，按著家族，屬洗分的，有洗分家族；屬哈基的，有哈基家族；屬書尼的，有書尼家族； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","屬阿斯尼的，有阿斯尼家族；屬以利的，有以利家族； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","屬亞律的，有亞律家族；屬亞列利的，有亞列利家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","這些就是迦得子孫的各家族，按著他們各家族被數點的，共有四萬零五百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","猶大的兒子是珥和俄南；這珥和俄南都死在迦南地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","猶大子孫，按著家族，屬示拉的，有示拉家族；屬謝拉的，有謝拉家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","法勒斯的子孫，屬希斯崙的，有希斯崙家族；屬哈母勒的，有哈母勒家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","這些就是猶大的各家族，按著他們各家族被數點的，共有七萬六千五百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","以薩迦的子孫，按著家族，屬陀拉的，有陀拉家族；屬普瓦的，有普瓦家族； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","屬雅述的，有雅述家族；屬伸崙的，有伸崙家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","這些就是以薩迦的各家族，按著他們各家族被數點的，共有六萬四千三百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","西布倫的子孫，按著家族，屬西烈的，有西烈家族；屬以倫的，有以倫家族；屬雅利的，有雅利家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","這些就是西布倫的各家族，按著他們各家族被數點的，共有六萬零五百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","約瑟的兒子，按著家族，有瑪拿西和以法蓮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","瑪拿西的子孫，屬瑪吉的，有瑪吉家族；瑪吉生基列；屬基列的，有基列家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","以下就是基列的子孫：屬伊以謝的，有伊以謝家族；屬希勒的，有希勒家族； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","屬亞斯列的，有亞斯列家族；屬示劍的，有示劍家族； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","屬示米大的，有示米大家族；屬希弗的，有希弗家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","希弗的兒子西羅非哈沒有兒子，只有女兒；西羅非哈的女兒名叫瑪拉、挪阿、曷拉、密迦、得撒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","這些就是瑪拿西的各家族，他們被數點的，共有五萬二千七百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","以下就是以法蓮的子孫：按著家族，屬書提拉的，有書提拉家族；屬比結的，有比結家族；屬他罕的，有他罕家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","書提拉的子孫，屬以蘭的，有以蘭家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","這些就是以法蓮子孫的各家族，按著他們各家族被數點的，共有三萬二千五百人。按著他們的家族，這些都是約瑟的子孫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","便雅憫的子孫，按著家族，屬比拉的，有比拉家族；屬亞實別的，有亞實別家族；屬亞希蘭的，有亞希蘭家族； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","屬書反的，有書反家族；屬戶反的，有戶反家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","比拉的眾子是亞勒、乃幔；屬亞勒的，有亞勒家族；屬乃幔的，有乃幔家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","這些就是便雅憫的子孫，按著他們的家族，他們被數點的，共有四萬五千六百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","以下是但的子孫：按著家族，屬書含的，有書含家族；按著家族，這些就是但的各家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","書含所有的家族，被數點的，共有六萬四千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","亞設的子孫，按著他們的家族，屬音拿的，有音拿家族；屬亦施葦的，有亦施葦家族；屬比利亞的，有比利亞家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","比利亞的子孫，屬希別的，有希別家族；屬瑪結的，有瑪結家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","亞設的女兒名叫西拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","這些就是亞設子孫的各家族，按著他們各家族被數點的，共有五萬三千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","拿弗他利的子孫，按著家族，屬雅薛的，有雅薛家族；屬沽尼的，有沽尼家族； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","屬耶色的，有耶色家族；屬示冷的，有示冷家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","這些就是拿弗他利的各家族，按著他們各家族被數點的，共有四萬五千四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","以上就是以色列人被數點的，共有六十萬零一千七百三十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“你要按著人名數目把地分配給他們作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","人數多的，你要把產業多分給他們；人數少的，你要把產業少分給他們；要按著數點的人數，把產業分給各人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","雖然這樣，地還是要藉著抽籤分配；他們要按著自己父家支派的名字，承受產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","你要按著所抽的籤，照著人數的多少，把產業分配給他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","以下是按著家族被數點的利未人：屬革順的，有革順家族；屬哥轄的，有哥轄家族；屬米拉利的，有米拉利家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","這些就是利未的各家族：有立尼家族、希伯倫家族、瑪利家族、母示家族、可拉家族。哥轄生暗蘭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","暗蘭的妻子，名叫約基別，是利未的女兒，是利未在埃及所生的；她給暗蘭生了亞倫、摩西和他們的姊姊米利暗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","亞倫生拿答、亞比戶、以利亞撒、以他瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","拿答和亞比戶在耶和華面前獻凡火的時候，死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","利未人中，從一個月以上被數點的所有男丁，共有二萬三千人。在以色列人中沒有數點他們，因為在以色列人中，沒有把產業分給他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","以上的人就是被摩西和以利亞撒祭司數點的；他們是在摩押平原，耶利哥對面約旦河邊數點以色列人的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","這些人中間，沒有一個是摩西和亞倫祭司從前在西奈曠野數點以色列人的時候，數點過的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","因為耶和華論到他們曾經說過：“他們必死在曠野。”所以除了耶孚尼的兒子迦勒和嫩的兒子約書亞以外，連一個也沒有剩下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","屬約瑟的兒子瑪拿西的各家族，有瑪拿西的玄孫、瑪吉的曾孫、基列的孫子、希弗的兒子西羅非哈的女兒，名叫瑪拉、挪阿、曷拉、密迦、得撒；她們前來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","站在會幕門口，在摩西和以利亞撒祭司、眾領袖和全體會眾面前，說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“我們的父親死在曠野，他並不是在那聚集攻擊耶和華的人之中，不屬可拉一黨的人；他死在自己的罪中，只是他沒有兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","為甚麼因為我們的父親沒有兒子，就把他的名從他的家族中除掉呢？求你在我們父親的兄弟中，給我們產業。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","於是摩西就把她們的案件呈到耶和華面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“西羅非哈的女兒說得有理，你一定要在她們父親的兄弟中，給她們產業，要把她們父親的產業給她們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","你也要告訴以色列人說：‘一個人死時，如果沒有兒子，就要使他的產業歸給他的女兒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","如果他沒有女兒，就要把他的產業給他的兄弟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","如果他沒有兄弟，就要把他的產業給他父系的兄弟。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","如果他父親沒有兄弟，你們就要把他的產業給他家族中最近的親屬，那人就要得他的產業。這要作以色列人的律例、典章，是照著耶和華吩咐摩西的。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","耶和華吩咐摩西說：“你要上這亞巴琳山去，看看我賜給以色列人的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","看了以後，你也必歸到你的本族那裡去，像你哥哥亞倫歸去一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","因為在尋的曠野，會眾爭鬧的時候，你們違背了我的命令，沒有在湧水之地，在會眾眼前尊我為聖。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","摩西對耶和華說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“願耶和華萬人之靈的　神，立一個人治理會眾， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","可以在他們面前出入；帶領他們出入，免得耶和華的會眾好像沒有牧人的羊一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","耶和華對摩西說：“你要揀選嫩的兒子約書亞，他心裡有聖靈，你要按手在他頭上， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","叫他站在以利亞撒祭司和全體會眾面前，當他們的面委派他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","你要把你的尊榮給他幾分，好叫以色列全體會眾都聽從他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","他要站在以利亞撒祭司面前，以利亞撒要藉著烏陵的判斷，在耶和華面前為他求問；他和以色列眾人，就是全體會眾，都要按著以利亞撒的命令出入。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","於是，摩西照著耶和華吩咐他的去行；他把約書亞領來，叫他站在以利亞撒祭司和全體會眾面前， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","按手在他頭上，委派他，是照著耶和華藉摩西吩咐的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“你要吩咐以色列人說：‘你們應獻給我的供物，就是獻給我作馨香的火祭的食物，要按著日期獻給我。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","你又要對他們說：‘你們要獻給耶和華的火祭是這樣：沒有殘疾、一歲的公羊羔，每天兩隻，作為常獻的燔祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","早晨要獻一隻，黃昏獻一隻； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","也要獻一公斤細麵，用搗成的油一公升調和，作為素祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","這就是常獻的燔祭，是在西奈山規定，作為獻給耶和華馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","為每隻公羊羔，要同獻一公升作奠祭的酒；你要在聖所中把醇酒獻給耶和華作奠祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","晚上你要獻上另一隻公羊羔，要照著早晨的素祭，和同獻的奠祭獻上，作馨香的火祭獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘在安息日，要獻兩隻沒有殘疾、一歲的公羊羔，也要獻兩公斤細麵，用油調和作素祭；還有同獻的奠祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","這是安息日獻的燔祭；在那常獻的燔祭和同獻的奠祭以外。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘每月第一日，你們要把燔祭獻給耶和華，就是兩頭公牛犢、一隻公綿羊、七隻沒有殘疾一歲的公羊羔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","為每頭公牛，要獻三公斤細麵，用油調和作素祭；為每隻公綿羊，要獻兩公斤細麵，用油調和作素祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","為每隻公羊羔，要獻一公斤細麵，用油調和作素祭；這是馨香的燔祭，是獻給耶和華的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","每頭公牛要獻酒兩公升作奠祭，每隻公綿羊獻酒一公升半，每隻公羊羔獻酒一公升。這是每月當獻的燔祭，一年之中每個月都要這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","又要把一隻公山羊作贖罪祭獻給耶和華，在那常獻的燔祭和同獻的奠祭以外。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘正月十四日，是耶和華的逾越節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","這月十五日是節期；要吃無酵餅七日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","第一日要有聖會，甚麼勞碌的工都不可作， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","只要獻火祭給耶和華作燔祭，就是兩頭公牛犢、一隻公綿羊和七隻一歲的公羊羔，都要完全沒有殘疾的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","同獻的素祭，是用油調和的細麵，為每頭公牛犢要獻三公斤；為每隻公綿羊要獻兩公斤； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","為那七隻公羊羔，每隻要獻一公斤； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","還要獻一隻公山羊作贖罪祭，為你們贖罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","除了早晨的燔祭，就是常獻的燔祭以外，還要把這些祭物獻上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","一連七日，每日都要獻上這樣的祭物，給耶和華作馨香火祭的食物，是在常獻的燔祭和同獻的素祭以外的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","第七日你們要有聖會，甚麼勞碌的工都不可作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘在初熟日，即七七節那一天，你們把新素祭獻給耶和華的時候，要有聖會，甚麼勞碌的工都不可作， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","只要把燔祭作為馨香的祭獻給耶和華，就是兩頭公牛犢、一隻公綿羊、七隻一歲的公羊羔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","同獻的素祭，是用油調和的細麵，為每頭公牛要獻三公斤；為每隻公綿羊，要獻兩公斤； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","為那七隻公羊羔，每隻要獻一公斤； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","還要獻一隻公山羊，為你們贖罪； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","除了常獻的燔祭以外，你們還要獻上這些祭物和同獻的奠祭，都要沒有殘疾的。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“‘七月第一日，你們要有聖會；甚麼勞碌的工都不可作。這是你們吹角的日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","你們要把燔祭作馨香的祭獻給耶和華，就是一頭公牛犢、一隻公綿羊、七隻一歲沒有殘疾的公羊羔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","同獻的素祭，是用油調和的細麵，為每頭公牛要獻上三公斤；為每隻公綿羊要獻上兩公斤； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","為那七隻公羊羔，每隻要獻一公斤； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","還要獻一隻公山羊作贖罪祭，為你們贖罪； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","在月初的燔祭和同獻的素祭、常獻的燔祭和同獻的素祭，以及照例同獻的奠祭以外，還要獻上這些給耶和華作馨香的火祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“‘在七月十日，你們要有聖會，刻苦己心，甚麼都不可作， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","只要把燔祭作馨香的祭獻給耶和華，就是一頭公牛犢、一隻公綿羊、七隻一歲沒有殘疾的公羊羔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","同獻的素祭，是用油調和的細麵，為每頭公牛要獻三公斤；為每隻公綿羊要獻兩公斤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","為那七隻公羊羔，每隻要獻一公斤； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","在為贖罪的贖罪祭、常獻的燔祭和同獻的素祭，以及同獻的奠祭以外，還要獻一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“‘七月十五日，你們要有聖會；甚麼勞碌的工都不可作，要向耶和華守節七天； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","你們要給耶和華獻燔祭，作馨香的火祭，就是十三頭公牛犢、兩隻公綿羊、十四隻一歲沒有殘疾的公羊羔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","同獻的素祭，是用油調和的細麵，為那十三頭公牛，每隻要獻三公斤；為那兩隻公綿羊，每隻要獻兩公斤； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","為那十四隻公羊羔，每隻要獻一公斤； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","在常獻的燔祭和同獻的素祭，以及同獻的奠祭以外，還要獻一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“‘第二日，要獻公牛犢十二頭、公綿羊兩隻、一歲沒有殘疾的公羊羔十四隻， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","並且為公牛、公綿羊和公羊羔，按著數目，照著規例，獻上同獻的素祭和同獻的奠祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","在常獻的燔祭和同獻的素祭，以及同獻的奠祭以外，還要獻一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“‘第三日，要獻公牛十一頭、公綿羊兩隻、一歲沒有殘疾的公羊羔十四隻； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","並且為公牛、公綿羊和公羊羔，按著數目，照著規例，獻上同獻的素祭和同獻的奠祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","在常獻的燔祭和同獻的素祭，以及同獻的奠祭以外，還要獻一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“‘第四日，要獻公牛十頭、公綿羊兩隻、一歲沒有殘疾的公羊羔十四隻； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","並且為公牛、公綿羊和公羊羔，按著數目，照著規例，獻上同獻的素祭和同獻的奠祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","在常獻的燔祭和同獻的素祭，以及同獻的奠祭以外，還要獻一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“‘第五日，要獻公牛九頭、公綿羊兩隻、一歲沒有殘疾的公羊羔十四隻； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","並且為公牛、公綿羊和公羊羔，按著數目，照著規例，獻上同獻的素祭和同獻的奠祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","在常獻的燔祭和同獻的素祭，以及同獻的奠祭以外，還要獻上一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“‘第六日，要獻公牛八頭、公綿羊兩隻、一歲沒有殘疾的公羊羔十四隻； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","並且為公牛、公綿羊和公羊羔，按著數目，照著規例，獻上同獻的素祭和同獻的奠祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","在常獻的燔祭和同獻的素祭，以及同獻的奠祭以外，還要獻上一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“‘第七日，要獻公牛七頭、公綿羊兩隻、一歲沒有殘疾的公羊羔十四隻； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","並且為公牛、公綿羊和公羊羔，按著數目，照著規例，獻上同獻的素祭和同獻的奠祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","在常獻的燔祭和同獻的素祭，以及同獻的奠祭以外，還要獻上一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“‘第八日，你們要有盛會；甚麼勞碌的工都不可作， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","只要給耶和華獻燔祭，作馨香的火祭，就是公牛一頭、公綿羊一隻、一歲沒有殘疾的公羊羔七隻； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","並且為公牛、公綿羊和公羊羔，按著數目，照著規例，獻上同獻的素祭和同獻的奠祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","在常獻的燔祭和同獻的素祭，以及同獻的奠祭以外，還要獻一隻公山羊作贖罪祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“‘在那些為還願或是甘心所獻，作你們的燔祭、素祭、奠祭，或是平安祭的以外，這些是在你們規定的時期內，要獻給耶和華的祭物。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","於是，摩西照著耶和華吩咐他的一切話，對以色列人說了。（本節在《馬索拉抄本》為30:1） ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","摩西告訴以色列人眾支派的領袖：“這是耶和華吩咐的話：（本節在《馬索拉抄本》為30:2） ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","如果人向耶和華許願，或是起誓要約束自己，就不可食言，總要照著自己口裡所出的一切話行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","女子年幼還在父家的時候，如果向耶和華許願要約束自己， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","她父親若是聽見她所許的願和約束自己的話，卻對她默不作聲，她所許的一切願和所說約束自己的話，就為有效。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","但是她父親聽見的時候，如果阻止她，她所許的願和所說約束自己的話，就都為無效；耶和華也必赦免她，因為她父親阻止她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“如果她已嫁了丈夫，她許願或嘴裡說冒失話約束自己的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","她丈夫聽見了，但在聽見的時候，默不作聲，她所許的願和約束自己的話，就為有效。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","但是她丈夫聽見的時候，如果阻止她，就算廢了她所許的願和她嘴裡所說約束自己的冒失話；耶和華也必赦免她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“寡婦，或是離了婚的婦人所許的願，就是她所說約束自己的一切話，都為有效。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","如果她在丈夫家裡許了願，或用誓言約束自己， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","她丈夫聽見了，卻默不作聲，也沒有阻止她，她所許的願和所說一切約束自己的話，就為有效。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","但是她丈夫聽見的時候，如果把這兩樣都廢了，婦人口中所說一切關於許願的話和約束自己的話，都必無效；她丈夫已經把這兩樣都廢了，耶和華也必赦免她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","“婦人所許的願和刻苦約束自己所起的誓，她丈夫都可以確立，也可以廢去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","如果她丈夫天天向她默不作聲，那就算是確立她所許的願和所說約束自己的一切話；因為丈夫在聽見的日子，向她默不作聲，就使這兩樣生效。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","但是，如果丈夫聽了很久以後，才把這兩樣完全廢去，他就要擔當妻子的罪孽。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","以上是耶和華吩咐摩西的條例，是關於丈夫與妻子，父親與女兒，女兒年幼在父家的時候的條例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“你要在米甸人身上報以色列人的仇，然後要歸到你本族那裡去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","摩西對人民說：“要從你們中間使一些人武裝起來去作戰，攻擊米甸人，好在米甸人身上為耶和華報仇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","你們要從以色列眾支派中每支派打發一千人去打仗。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","於是從以色列千萬人中，每支派選出一千人，共有一萬二千人，都武裝起來去打仗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","摩西就打發每支派的一千人去打仗，並且派遣以利亞撒祭司的兒子非尼哈與他們一同去，非尼哈手裡拿著聖所的器皿和吹大聲的號筒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","他們就照著耶和華吩咐摩西的，去與米甸人作戰，殺死了所有的男人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","在那些被殺的人以外，還殺了米甸的五個王，就是以未、利金、蘇珥、戶珥和利巴；又用刀殺了比珥的兒子巴蘭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","以色列人擄了米甸人的婦女、孩子；又擄掠了他們所有的牲畜、羊群和財物； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","並用火燒了他們所住地方的一切城市和營寨； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","把一切奪來的和擄掠的，連人帶牲畜都帶走； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","他們把俘擄的人和擄來的，以及奪來的東西，都帶到摩押平原，約旦河邊，和耶利哥相對的營地那裡，交給摩西和以利亞撒祭司，以及以色列的會眾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","摩西和以利亞撒祭司，以及會眾所有的領袖，都出到營外迎接他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","摩西對作戰回來的軍官，就是對千夫長和百夫長發怒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","摩西對他們說：“你們讓這些婦女存活嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","看哪，這些婦女因巴蘭的計謀，使以色列人在毗珥的事上，得罪耶和華，以致瘟疫臨到耶和華的會眾身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","現在你們要把所有的男孩都殺了，也要殺死所有與男人發生過關係的婦人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","但女孩子中，沒有與男人發生過關係的，你們都可以讓她們活著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","你們要在營外駐紮七天，殺過人的和摸過死屍的，第三日和第七日都要潔淨自己，你們和你們擄來的人都要這樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","你們也要潔淨一切衣服、皮具、山羊毛織的物和木器。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","以利亞撒祭司對打仗回來的兵丁說：“這是耶和華吩咐摩西的律例： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","金、銀、銅、鐵、錫、鉛， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","能夠經火的東西，你們都要使它經火，就算是潔淨了，但還要用除污水潔淨它；不能經火的，你們要使它經過水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","第七日，你們要洗衣服，就為潔淨；然後才可以進營。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“你和以利亞撒祭司，以及會眾的各族長，要計算俘擄的人和掠得的牲畜的總數。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","你要把掠奪得的分為兩半，一半給出去打仗的人，一半給全體會眾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","你又要從出去打仗的人所得的，無論是人、牛、驢，或羊群之中，抽出五百分之一作貢物奉給耶和華； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","你們要從他們那一半中抽出，交給以利亞撒祭司，作耶和華的舉祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","從以色列人那一半中，無論是人、牛、驢、羊群，或是各樣牲畜，都要抽出五十分之一，交給負責看守耶和華帳幕的利未人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","於是，摩西和以利亞撒祭司照著耶和華吩咐摩西的行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","掠得的東西，就是打仗的人所擄掠剩下來的，共有羊六十七萬五千隻， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","牛七萬二千頭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","驢六萬一千頭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","沒有與男人發生過關係的婦人三萬二千人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","出去打仗的人的分，就是他們所得的那一半，羊共有三十三萬七千五百隻； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","這些羊群中，歸耶和華作貢物的，有六百七十五隻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","牛三萬六千頭，歸耶和華為貢物的，有七十二隻。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","驢三萬零五百頭，歸耶和華為貢物的有六十一匹。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","人口一萬六千，歸給耶和華作貢物的，有三十二人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","摩西照著耶和華吩咐他的，把貢物，就是耶和華的舉祭，交給以利亞撒祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","以色列人所得的那一半，就是摩西從打仗的人取來分給他們的 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","（屬於會眾的那一半，有羊三十三萬七千五百隻， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","牛三萬六千頭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","驢三萬零五百頭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","人口一萬六千）； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","摩西照著耶和華吩咐他的，從屬於以色列人的那一半，無論是人口或是牲畜，都抽出五十分之一，交給負責看守耶和華帳幕的利未人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","統領萬軍的軍長、千夫長和百夫長，都來見摩西， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","對摩西說：“你僕人手下作戰的士兵，已經計算總數，沒有缺少一人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","現在我們把耶和華的供物，都送來了，就是我們各人所得的金器、腳鍊子、鐲子、打印戒指、耳環、手釧，好在耶和華面前，為我們自己贖罪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","摩西和以利亞撒祭司就收了他們的金子，就是各樣金子做成的器皿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","千夫長和百夫長獻給耶和華為舉祭的一切金子，共有兩百多公斤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","士兵都各自奪取了財物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","摩西和以利亞撒祭司就從千夫長和百夫長手中收了金子，把它帶進會幕裡去，在耶和華面前作以色列人的記念。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","流本子孫和迦得子孫的牲畜極其眾多；他們看見雅謝地和基列地都是可牧放牲畜的地方， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","就來對摩西和以利亞撒祭司，以及會眾的首領說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“亞大錄、底本、雅謝、寧拉、希實本、以利亞利、示班、尼波、比穩， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","就是耶和華在以色列會眾面前攻取的地，是可牧放牲畜的地，你僕人也有牲畜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","他們又說：“如果我們在你眼前蒙恩，求你把這地給你的僕人作產業，不要叫我們過約旦河。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","摩西對迦得子孫和流本子孫說：“難道你們的兄弟去打仗，你們卻坐在這裡嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","你們為甚麼使以色列人灰心，不過河到耶和華賜給他們的地那裡去呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","我從前從加低斯．巴尼亞派你們的先祖去窺探那地的時候，他們也是這樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","他們上到以實各谷，看了那地，就使以色列人灰心，不進耶和華賜給他們的地那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","當日耶和華的怒氣發作，就起誓說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘從埃及上來二十歲以上的人，必不得看見我對亞伯拉罕、以撒、雅各起誓應許的地，因為他們沒有專心跟從我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","唯獨基尼洗人耶孚尼的兒子迦勒，和嫩的兒子約書亞可以看見，因為他們專心跟從耶和華。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","耶和華的怒氣向以色列人發作，使他們在曠野飄流了四十年，等到在耶和華眼前行惡的那一代都滅盡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","現在，你們這些罪人的族類，也來接替你們的先祖，增添耶和華對以色列的烈怒！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","如果你們轉離，不跟從他，他再要把以色列人撇在曠野，這樣，你們就要把整個民族都毀滅了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","兩支派的人走到摩西跟前，對他說：“我們要在這裡給我們的牲畜築羊圈，給我們的孩子建城邑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","我們自己卻要武裝起來，行在以色列人前頭上陣，直到把他們領到他們自己的地方，但我們的孩子因為這地居民的緣故，要住在堅固的城裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","我們決不回家，直等到以色列人各自承受了產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","我們不與他們在約旦河西邊之地同受產業，因為我們的產業是坐落在約旦河東邊。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","摩西對他們說：“如果你們這樣行，在耶和華面前武裝起來去作戰， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","你們所有武裝起來的人，都要在耶和華面前過約旦河，直到他把他的仇敵從自己面前趕出去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","直到那地在耶和華面前被征服了，然後才回家，這樣你們對耶和華和對以色列就算無罪，這地也可以在耶和華面前歸你們作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","如果你們不這樣行，就得罪了耶和華；你們要知道你們的罪必追上你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","現在你們只管照你們口中所出的話去行，為你們的孩子建城，為你們的羊群築圈。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","迦得子孫和流本子孫告訴摩西：“你僕人必照著我主吩咐的去行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","我們的孩子、妻子、羊群和所有的牲畜，都要留在基列的各城； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","但你的僕人，所有武裝起來預備打仗的，都要照著我主所說的，在耶和華面前過去作戰。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","於是，摩西為了他們，囑咐以利亞撒祭司和嫩的兒子約書亞，以及以色列眾支派的族長， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","對他們說：“迦得的子孫和流本的子孫，所有武裝起來，在耶和華面前預備去作戰的人，如果與你們一同過約旦河，那地在你們面前被征服了，你們就要把基列地給他們作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","他們若是不武裝起來，與你們一同過去，他們就要在迦南地在你們中間同得產業。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","迦得的子孫和流本的子孫回答，說：“耶和華怎樣吩咐僕人，我們就怎樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","我們要武裝起來，在耶和華面前過河，到迦南地去；只是約旦河這邊的地方，要歸我們作產業。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","於是摩西把亞摩利王西宏的國，和巴珊王噩的國，連那地，和境內城市，以及那地周圍的城市，都給了迦得的子孫、流本的子孫和約瑟的兒子瑪拿西的半個支派。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","迦得的子孫修築了底本、亞他錄、亞羅珥、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","亞他錄．朔反、雅謝、約比哈、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","伯．寧拉、伯．哈蘭這些堅固的城市和羊圈。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","流本的子孫修築了希實本、以利亞利、基列亭、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","尼波、巴力．免（以上的名字是改了的）、西比瑪；又為他們修築的城市起了別的名字。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","瑪拿西的兒子瑪吉的子孫到基列去，攻取了那地，把住在那裡的亞摩利人趕走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","摩西把基列給了瑪拿西的兒子瑪吉，瑪吉就住在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","瑪拿西的兒子睚珥，去攻取了亞摩利人的村莊，就把這些村莊叫作哈倭特．睚珥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","挪巴去攻取了基納和基納的小村鎮，就用自己的名字叫基納為挪巴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","以下是以色列人按著他們的隊伍，在摩西和亞倫的手下，從埃及地出來以後所行的路程。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","摩西照著耶和華的命令，把他們出發的路程記下來，他們出發的路程是這樣： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","一月十五日，就是逾越節的次日，以色列人從蘭塞起行，在所有埃及人眼前昂然無懼地出去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","那時，埃及人正在埋葬他們的長子，就是耶和華在他們中間擊殺的，耶和華也對他們的神施行審判。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","以色列人從蘭塞起行，在疏割安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","從疏割起行，在曠野邊界的以倘安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","從以倘起行，轉到比哈．希錄，是在巴力．洗分前面，就在密奪對面安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","從比哈．希錄起行，經過了海來到曠野，又在伊坦曠野走了三天的路程，就在瑪拉安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","從瑪拉起行，來到以琳；在以琳有十二股水泉，七十棵棕樹；他們就在那裡安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","從以琳起行，在紅海邊安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","從紅海起行，在汛的曠野安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","從汛的曠野起行，在脫加安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","從脫加起行，在亞錄安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","從亞錄起行，在利非訂安營，在那裡眾民沒有水喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","從利非訂起行，在西奈的曠野安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","從西奈的曠野起行，在基博羅．哈他瓦安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","從基博羅．哈他瓦起行，在哈洗錄安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","從哈洗錄起行，在利提瑪安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","從利提瑪起行，在臨門．帕烈安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","從臨門．帕烈起行，在立拿安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","從立拿起行，在勒撒安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","從勒撒起行，在基希拉他安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","從基希拉他起行，在沙斐山安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","從沙斐山起行，在哈拉大安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","從哈拉大起行，在瑪吉希錄安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","從瑪吉希錄起行，在他哈安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","從他哈起行，在他拉安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","從他拉起行，在密加安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","從密加起行，在哈摩拿安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","從哈摩拿起行，在摩西錄安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","從摩西錄起行，在比尼．亞干安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","從比尼．亞干起行，在曷．哈及甲安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","從曷．哈及甲起行，在約巴他安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","從約巴他起行，在阿博拿安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","從阿博拿起行，在以旬．迦別安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","從以旬．迦別起行，在尋的曠野安營，尋就是加低斯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","從加低斯起行，在以東地邊界上的何珥山安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","以色列人從埃及地出來以後四十年，五月一日，亞倫祭司照著耶和華的吩咐，上了何珥山，就死在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","亞倫死在何珥山上的時候，是一百二十三歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","那時，住在迦南地南方的迦南人亞拉得王，聽說以色列人來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","以色列人從何珥山起行，在撒摩拿安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","從撒摩拿起行，在普嫩安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","從普嫩起行，在阿伯安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","從阿伯起行，在摩押邊境的以耶．亞巴琳安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","從以耶．亞巴琳起行，在底本．迦得安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","從底本．迦得起行，在亞門．低比拉太音安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","從亞門．低比拉太音起行，在尼波前面的亞巴琳山安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","從亞巴琳山起行，在耶利哥對面，約旦河邊的摩押平原安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","他們在摩押平原，沿著約旦河邊安營，從帕．耶施末直到亞伯．什亭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","耶和華在摩押平原約旦河邊，耶利哥對面對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“你要吩咐以色列說：‘你們過約旦河到了迦南地的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","就要把所有的居民從你們面前趕出去，毀壞他們的一切雕像，以及一切鑄像，又拆毀他們的一切邱壇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","你們要佔領那地，住在那裡，因為我已經把那地賜給你們作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","你們要按著家族抽籤承受那地作產業；人多的，要把產業多分給他們；人少的，要把產業少分給他們；抽籤抽出那地歸誰，就歸誰；你們要按著宗族支派承受產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","如果你們不把那地的居民從你們面前趕出去，所留下的人就必成為你們眼中的刺，肋旁的荊棘，在你們所住的地方擾害你們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","並且我原計劃怎樣待他們，也要怎樣待你們。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“你要吩咐以色列人說：‘你們進了迦南地的時候，歸你們作產業的迦南地及它的四境就是以下這些地區。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","你們南面的地區要從尋的曠野，貼著以東邊界；你們的南界要從鹽海東面的盡頭起； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","你們的邊界要轉到亞克拉濱坡的南邊，經過尋，直達加低斯．巴尼亞的南邊，又出到哈薩．亞達，過到押們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","你們的邊界要從押們轉到埃及河，直達到海。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“‘西界方面，你們有大海和海岸；這要作你們的西界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“‘你們的北界如下：從大海起畫界，直到何珥山； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","從何珥山起畫界，直到哈馬口，使邊界直到西達達； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","這邊界再伸到西斐崙，直到哈薩．以難；這要作你們的北界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“‘你們要從哈薩．以難，畫到示番為東界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","這邊界要從示番下到亞延東面的利比拉；這邊界要繼續伸展直達基尼烈湖的東邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","這邊界要下到約旦河，直到鹽海。這要作你們的土地四周的邊界。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","摩西吩咐以色列人說：“這就是你們要抽籤承受為業之地，是耶和華吩咐給九個半支派的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","因為流本子孫的支派和迦得子孫的支派，按著父家已經取得了產業，瑪拿西的半個支派也取得了產業； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","這兩個半支派已經在耶利哥對面，約旦河東岸，向日出之地得了產業。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“這是要把地業分配給你們的人的名字：以利亞撒祭司和嫩的兒子約書亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","你們又要從每支派中選出一個領袖，來幫助分配地業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","這些人的名字是：猶大支派有耶孚尼的兒子迦勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","西緬子孫的支派有亞米忽的兒子示母利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","便雅憫支派有基斯倫的兒子以利達。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","但子孫的支派有一個領袖，是約利的兒子布基。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","約瑟的後裔，瑪拿西子孫的支派有一個領袖，是以弗的兒子漢聶。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","以法蓮子孫的支派有一個領袖，是拾弗但的兒子基母利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","西布倫子孫的支派有一個領袖，是帕納的兒子以利撒番。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","以薩迦子孫的支派有一個領袖，是阿散的兒子帕鐵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","亞設子孫的支派有一個領袖，是示羅米的兒子亞希忽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","拿弗他利子孫的支派有一個領袖，是亞米忽的兒子比大黑。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","這些人，就是耶和華所吩咐，把產業分給迦南地的以色列人的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","耶和華在耶利哥對面，約旦河邊的摩押平原，對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“你要吩咐以色列人，叫他們從所得為業的地中，把一些城給利未人居住，也把這些城周圍的郊區給利未人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","這些城要歸他們居住，城的郊區可以牧放他們的牛羊和一切牲畜，也可以存放他們的財物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“你們給利未人的城郊，要從城牆起，周圍向外量四百五十公尺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","你們又要從城外，向東面量九百公尺，向南面量九百公尺，向西面量九百公尺，向北面量九百公尺，城在中間；這要歸給他們作城外的郊區。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","你們分給利未人的城，其中要有六座避難城，讓誤殺人的可以逃到那裡去，此外還要給他們四十二座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","這樣，你們所要給利未人的城，共為四十八座，連城帶城郊都要給他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","從以色列人所得的地業中，你們要把一些城給利未人，人多的就要多給，人少的就要少給；每個支派要照著自己承受的產業，把城分給利未人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“你要吩咐以色列人說：‘你們過約旦河，進到迦南地的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","就要選擇幾座城，給你們作避難城，讓誤殺人的，就是無心殺死人的，可以逃到那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","它們可以作你們逃避報仇者的避難城，使誤殺人的不至於死，直到他站在會眾面前受審判。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","你們指定的城，要給你們作六座避難城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","在約旦河東面，你們要分出三座城；在迦南地，你們也要分出三座城，都要作避難城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","這六座城要給以色列人和外族人，以及他們中間居住的人作避難城，使無心殺人的人，都可以逃到那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“‘如果人用鐵器打人，以致把人打死，他就是故意殺人的；故意殺人的必被處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","如果人手裡拿著可以打死人的石頭打人，以致把人打死，他就是故意殺人的；故意殺人的必被處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","如果人手裡拿著可以打死人的木器打人，以致把人打死，他就是故意殺人的；故意殺人的必被處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","報血仇的，要親自把那故意殺人的殺死；一遇見他，就可以殺死他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","如果人因懷恨把人推倒，或是埋伏著向人扔東西，以致把人打死； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","或者因仇恨用手打人，以致把人打死；那打人的，必被處死，因為他是故意殺人的；報血仇的一遇見兇手，就可以殺死他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“‘但是，如果人沒有仇恨，忽然把人推倒，或是無意向人投擲甚麼器皿， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","或是因為沒有看見，用任何可以打死人的石頭，扔在人身上，以致把人打死，他本來與他無仇，也無意害他； ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","這樣，會眾就要照著典章，在打死人的和報血仇的人中間施行裁判。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","會眾要把誤殺人的，從報血仇的人手中救出來；他要住在城中，直到受膏的大祭司死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","但誤殺人的，若是出了他逃進的避難城的境界， ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","報血仇的在避難城境外遇著他，把他殺了，報血仇的就沒有犯流人血的罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","因為那誤殺人的應該住在避難城中，直到大祭司死了；大祭司死了以後，那誤殺人的才可以回到他自己地業去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“‘這在你們一切居住的地方，要作你們世世代代的律例典章。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","殺人的，要憑著幾個見證人的口供，才可以把他處死；如果只有一個見證人，就不能指證把人處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","犯了死罪，故意殺人的，你們不可收取贖價代他贖命，因為他必被處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","逃到避難城的人，你們也不可收取他的贖價，使他在大祭司未死以前回到本地居住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","這樣，你們就沒有玷污你們居住的地，因為血能玷污地；在地上如果有流人血的，除非流那故意殺人者的血，那地的血就不能得贖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","你們不可玷污你所住的地，就是我居住的地，因為我耶和華是居住在以色列人中間的。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","約瑟後裔的家族中，有瑪拿西的孫子、瑪吉的兒子基列的子孫，他們族中的首領都前來，在摩西面前，在各家族作首領的領袖面前，和在以色列人面前說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“耶和華曾經吩咐我主要憑抽籤把地分給以色列人為業；我主也受了耶和華的吩咐，要把我們兄弟西羅非哈的產業分給他的眾女兒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","但是，如果她們嫁給以色列中別的支派的人，她們的產業就必從我們祖宗的產業中被取去，加在他們丈夫支派的產業上；這樣，我們抽籤所得的產業就失去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","到了以色列人的禧年，她們的產業就要加在她們丈夫支派的產業上；這樣，她們的產業就要從我們祖宗支派的產業中被拿去了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","摩西照著耶和華的話，吩咐以色列說：“約瑟支派的人說得對。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","論到西羅非哈的眾女兒，耶和華吩咐的話是這樣：‘她們可以隨意嫁自己喜歡的人，但是，只能嫁給同族同支派的人作妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","這樣，以色列人的產業，就不會從一個支派轉到另一個支派去；因為以色列人要各自守住自己祖宗支派的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","從以色列支派中得了產業的女子，要嫁給自己祖宗支派的人作妻子，好使以色列人可以各自承受自己祖宗的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","這樣，以色列人的產業，就不會從一個支派轉到另一個支派去；因為以色列人的支派要各自守住自己的產業。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","耶和華怎樣吩咐摩西，西羅非哈的眾女兒就怎樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","西羅非哈的女兒瑪拉、得撒、曷拉、密迦、挪阿，都嫁給了自己叔伯的兒子作妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","她們嫁給了約瑟的兒子瑪拿西子孫家族的人作妻子；她們的產業仍然留在自己的支派中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","這是耶和華在耶利哥對面，約旦河邊的摩押平原，藉著摩西向以色列人吩咐的命令和典章。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","以下是摩西在約旦河東的曠野，疏弗對面的亞拉巴，就是在巴蘭和陀弗、拉班、哈洗錄、底撒哈之間，向以色列人所說的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","從何烈山經過西珥山的路，到達加低斯．巴尼亞，共有十一天的路程。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","出埃及以後第四十年十一月一日，摩西照著耶和華吩咐他一切關於以色列人的話，都告訴了他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","當時，他已經擊敗了住在希實本的亞摩利人的王西宏，和住在亞斯他錄與以得來的巴珊王噩。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","摩西在約旦河東的摩押地，開始講解這律法，說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“耶和華我們的　神，在何烈山告訴我們：‘你們在這山上住夠了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","現在你們要轉回，起程到亞摩利人的山地去，到那些住在亞拉巴、山地、低地、南地、沿海一帶、迦南人的地、黎巴嫩，直到大河，就是幼發拉底河一帶的地方去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","看哪，我把這地擺在你面前，你們要進去，佔領這地為業，就是耶和華向你們列祖亞伯拉罕、以撒、雅各起誓應許給他們和他們的後裔的地。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“那時，我曾經對你們說：‘你們的重擔，我獨自一人無法擔當。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","耶和華你們的　神使你們多起來；你們看，你們今日像天上的星那樣多。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","願耶和華你們列祖的　神，使你們比現在更多千倍，又照著他應許你們的話，賜福給你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","我獨自一人怎能擔得起你們的重擔、責任和你們爭訟的事呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","你們要按著支派選出一些有智慧、有見識、有經驗的人，我就立他們作你們的首領。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","你們回答我，說：‘你吩咐我們作的事很好。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","我就選出你們眾支派中的領袖，就是有智慧有經驗的人；按著你們的支派，立他們作管理你們的首領，就是作千夫長、百夫長、五十夫長、十夫長和其他官長。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","“那時，我吩咐你們的審判官，說：‘你們在兄弟中聽訟，無論是兄弟彼此訴訟，或是與同居的外地人訴訟，都要按著公義審判。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","審判的時候，不可偏袒人；無論貴賤尊卑，都要一樣地聽訟；不可怕人的情面，因為審判是屬於　神的；如果你們遇見難斷的案件，可以呈到我這裡來，讓我審斷。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","那時，我把你們當作的一切事，都吩咐了你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“我們照著耶和華我們的　神吩咐我們的，從何烈山起行，走過你們所見那大而可怕的曠野，沿著到亞摩利人山地的路而行；後來到了加低斯．巴尼亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","我對你們說：‘你們已經到了亞摩利人的山地，就是耶和華我們的　神賜給我們的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","看哪，耶和華你的　神已經把這地擺在你面前；你要照著耶和華你列祖的　神告訴你的上去，佔領那地；不要害怕，也不要驚惶。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","你們眾人都走到我這裡來，說：‘我們要先派些人去，替我們窺探那地，然後把我們上去該走哪一條路，該進哪些城，向我們回報。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","這話我很同意，就從你們中間選了十二個人，每支派一人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","於是他們轉身出發，上了山地，到了以實各谷，窺探那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","他們手裡拿著那地的果子，帶下來到我們這裡，並且向我們回報，說：‘耶和華我們的　神要賜給我們的地是美地。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“但你們不肯上去，竟違背了耶和華你們的　神的吩咐； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","你們在帳幕裡抱怨，說：‘耶和華因為恨我們，所以把我們從埃及地領出來，要把我們交在亞摩利人手中，消滅我們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","我們上哪裡去呢？我們的兄弟使我們心灰意冷，說：那地的人比我們高大；他們的城邑又大又堅固，高聳入天；我們在那裡還看見有亞衲族的人。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","我就對你們說：‘不要驚恐，不要害怕他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","耶和華你們的　神，就是那走在你們前面的那一位，他必為你們作戰，好像他在埃及，在你們面前，為你們所行的一切一樣， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","並且在曠野裡，你們也看見了耶和華你們的　神，怎樣在你們所行的一切路上，背負你們，好像人背負自己的兒子一樣，直到你們來到了這地方。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","雖然這樣，你們還是不信耶和華你們的　神； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","他在路上走在你們前面，為你們尋找安營的地方；夜間用火柱，日間用雲彩，指示你們當走的路。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“耶和華聽見了你們說話的聲音，就惱怒，起誓說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘這個邪惡世代的人，連一個也不能看見我起誓應許賜給他們列祖的美地； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","只有耶孚尼的兒子迦勒可以看見；並且我要把他踏過的地賜給他和他的子孫，因為他專心跟從了我耶和華。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","因為你們的緣故，耶和華也向我發怒，說：‘你也不能進入那地； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","但是站在你面前侍候你的嫩的兒子約書亞，他可以進到那裡去；你要鼓勵他，因為他要使以色列人承受那地為業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","還有你們的小孩子，你們說要被擄掠的，和你們的兒女，就是今天還不知道善惡的，他們都要進入那地；我要把那地賜給他們，他們要佔領那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","至於你們，你們要轉回，經往紅海的路，起程到曠野裡去。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“那時你們回答我，說：‘我們得罪了耶和華；現在我們願意照著耶和華我們　神的一切吩咐，上去作戰。’於是你們都預備了兵器，輕率地上山去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","耶和華對我說：‘你要對他們說：“你們不要上去，也不要作戰，因為我不在你們中間，免得你們在仇敵面前被擊敗。”’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","我就告訴你們，你們卻不聽從，竟違背耶和華的吩咐，擅自上山去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","住在那山上的亞摩利人，就出來攻擊你們，好像蜂群一樣追趕你們，在西珥擊殺你們，直到何珥瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","你們就回來，在耶和華面前哭，但耶和華不聽你們的聲音，也不向你們側耳。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","於是你們在加低斯住了許多日子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“以後，我們照著耶和華吩咐我的，回轉過來，沿著往紅海的路起程到曠野去；我們在西珥山繞行了很多日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","耶和華對我說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘你們繞行這山的日子已經夠了；現在要轉向北去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","你要吩咐人民說：“你們的兄弟以掃的子孫，住在西珥，你們現在要經過他們的境界；他們必懼怕你們，所以你們要十分謹慎。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","不要與他們爭執；他們的地，連腳掌那麼大的一塊，我都不給你們，因為我已經把西珥山賜給以掃作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","你們要用銀子向他們買食物吃；也要用銀子向他們買水喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","因為耶和華你的　神，對於你手裡所作的一切事，都已經賜福給你；他也知道你怎樣走這大曠野；這四十年來，耶和華你們的　神常與你同在，使你毫無缺乏。”’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“於是我們離開我們住在西珥的兄弟以掃的子孫，繼續前行；沿著亞拉巴的路，到了以拉他和以旬．迦別，然後轉向摩押曠野的路去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","耶和華對我說：‘你不可敵視摩押人，也不可與他們爭戰；他們的地我不賜給你作產業，因為我已經把亞珥賜給了羅得的子孫作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","（以前有以米人住在那裡，這族人人數眾多，身體高大，像亞衲族人一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","這以米人，像亞衲族人一樣，也算為利乏音人；但摩押人稱他們為以米人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","以前何利人也住在西珥，但以掃的子孫佔領了他們的產業，消滅了他們，住在他們那裡，就像以色列在耶和華賜給他們作產業的地上所行的一樣。） ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","現在你們要起來，過撒烈溪。’於是我們過了撒烈溪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","自從我們離開加低斯．巴尼亞，直到過了撒烈溪的日子，共有三十八年，等到那世代的戰士都從營中滅絕為止，正像耶和華向他們所起的誓一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","耶和華的手攻擊了他們，把他們從營中除滅，直到滅盡為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“所有戰士都從民中死盡以後， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","耶和華就對我說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘你今天要經過摩押的境界亞珥； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","你走近亞捫人面前的時候，不可敵視他們，也不可與他們爭執；亞捫人的地我不賜給你們作產業，因為我已經把那地賜給了羅得的子孫作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","（那地也算為利乏音人的地，以前利乏音人住在那裡，但亞捫人稱他們為散送冥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","這族人人數眾多，身體高大，像亞衲族人一樣；但耶和華從亞捫人面前消滅了他們，亞捫人就佔領了他們的地業，住在那裡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","好像耶和華從前為住在西珥的以掃的子孫所作的一樣，就是把何利人從他們面前消滅，他們就佔領了他們的地業，住在他們那裡，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","還有亞衛人，原先住在迦薩附近的各村莊裡，有從迦斐託出來的迦斐託人把他們消滅了，住在他們那裡。） ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","現在你要起來，出發，過亞嫩谷；看哪，我已經把亞摩利人希實本王西宏和他的土地，交在你的手裡了；你要開始佔領那地作產業，與他爭戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","就在今天，我要使天下萬民聽見你的消息都驚慌懼怕，而且因你的緣故發抖疼痛。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“我從基底莫的曠野，派使者到希實本王西宏那裡去，用和平的話說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘求你讓我從你的地經過；我只走大道，不偏左也不偏右。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","你可以按著價錢把食物賣給我吃，也可以按著價錢把水賣給我喝；只要讓我步行過去就是了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","好像住在西珥的以掃子孫，和住在西珥的摩押人待我一樣，等我過約旦河，進到耶和華我們的　神賜給我們的地去。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","但是希實本王西宏不肯讓我們從他那裡經過，因為耶和華我們的　神使他的心意頑固，使他的心剛硬，為要把他交在你的手裡，像今日一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","耶和華對我說：‘看哪，我已經把西宏和他的地交給你了，你可以佔領他的地作產業。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“那時西宏和他所有的人民都出來，攻擊我們，在雅雜與我們作戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","耶和華我們的　神把他交給了我們，我們就把他、他的兒子們和他所有的人民都擊殺了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","那時我們奪取了他所有的城邑，把每一座城，連男帶女，以及小孩子都全部毀滅，沒有留下一個存活的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","只留下我們掠為己有的牲畜，和我們奪取城邑所得的戰利品。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","從亞嫩谷旁邊的亞羅珥和谷中的城，直到基列，沒有一座城太高，是我們不能攻下的；耶和華我們的　神把這一切都交給我們了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","只有亞捫人的地，雅博河一帶的地方，和山地的城市，以及耶和華我們的　神吩咐我們不可去的地方，我們都沒有走近。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“後來我們回轉過來，沿著到巴珊的路上去；巴珊王噩和他的眾民，都出來迎著我們，在以得來與我們作戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","耶和華對我說：‘你不要怕他，因為我已經把他和他的眾民，以及他的土地，都交在你的手裡；你要待他，像從前你待希實本的亞摩利人的王西宏一樣。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","於是耶和華我們的　神也把巴珊王噩和他的眾民都交在我們的手裡；我們擊殺了他們，沒有留下一個存活的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","那時，我們掠奪了他所有的城；在巴珊王噩的國土裡，亞珥歌的全境，共有六十座城，沒有一座城不被我們所奪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","這些城都是以高牆作堡壘，有城門，有門閂；此外，還有很多沒有城牆的鄉村。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","我們把這些都滅盡，像從前我們待希實本王西宏一樣，把各城中的男女和小孩子都滅盡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","只有城中所有的牲畜和奪得的財物，都掠為己有。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","那時，我們從約旦河東亞摩利人的兩個王手裡，把從亞嫩谷直到黑門山的地奪了過來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","（西頓人稱黑門山為西連，亞摩利人卻稱它為示尼珥。） ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","就是奪了平原上所有的城市，基列全境和巴珊全境，直到撒迦和以得來，這都是巴珊王噩國內的城市。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","（利乏音人的餘民中，只留下巴珊王噩一人；看哪，他的床是鐵的，長四公尺，寬兩公尺，這是按一般的尺寸量度，現在不是還在亞捫人的拉巴嗎？） ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“那時，我們佔領了那地，從亞嫩谷旁邊的亞羅珥起，我把基列山地的一半和其中的城市，都給了流本人和迦得人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","基列其餘的地方和巴珊全境，就是噩王的國土，我都給了瑪拿西半個支派。亞珥歌全境就是巴珊全境，這叫作利乏音人的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","瑪拿西的兒子睚珥，佔了亞珥歌全境，直到基述人和瑪迦人的邊界，就按著自己的名字稱巴珊全境為哈倭特．睚珥，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","我又把基列給了瑪吉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","從基列到亞嫩谷，以谷的中心為界，直到亞捫人邊界的雅博河，我都給了流本人和迦得人； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","又把亞拉巴，和以約旦河為界，從基尼烈直到亞拉巴海，就是鹽海，在毗斯迦山坡下東邊的地方，都給了他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“那時，我吩咐你們：‘耶和華你們的　神，已經把這地賜給你們作產業了；你們所有的戰士，都要預備好，在你們的兄弟以色列人面前過河去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","只有你們的妻子、小孩子和牲畜，可以留在我賜給你們的城裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","直到耶和華使你們的兄弟，像你們一樣得了安身的地方；他們也佔領了耶和華你們的　神在約旦河西賜給他們的地，然後你們各人才可以回到我賜給你們作產業的地去。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","那時，我吩咐約書亞：‘你親眼看見了耶和華你們的　神向這兩個王所行的一切；耶和華也必向你正要去的各國照樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","你們不要怕他們，因為耶和華你們的　神要為你們作戰。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“那時，我懇求耶和華，說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘主耶和華啊，你已經把你的偉大和你有能力的手顯給你的僕人看；在天上地下，哪一個神能有像你所作的工作，能有像你所行的奇事呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","求你讓我過去，看看約旦河西的美地，就是那美好的山地和黎巴嫩。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","但耶和華為了你們的緣故，向我發怒，不聽我的懇求；耶和華對我說：‘罷了，不要向我再提這事了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","你要上毗斯迦山頂去，舉目向東、南、西、北，親眼觀看，因為你不能過這約旦河。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","你卻要吩咐約書亞，堅固他，鼓勵他，因為他要在這人民前面過河去，使他們承受你看見的這地。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","於是我們住在伯．毗珥對面的谷中。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“以色列人哪，現在你們要聽我向來教訓你們遵行的律例和典章，使你們可以活著，可以進去得著耶和華你們列祖的　神賜給你們的地作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","我吩咐你們的話，你們不可增加，也不可減少，好使你們遵守我吩咐你們的，就是耶和華你們的　神的命令。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","耶和華因巴力．毗珥的事所行的，你們都親眼看見了；所有跟隨巴力．毗珥的人，耶和華你們的　神都從你們中間消滅了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","只有你們緊緊倚靠耶和華你們的　神的人，今日全都活著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","看哪，我照著耶和華我的　神吩咐我的，把律例和典章教訓你們，好讓你們在將要進去得為業的地上遵行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","所以你們要謹守遵行，因為在萬民的眼中看來，這就是你們的智慧和聰明；他們一聽見這一切律例，就必定說：‘這大國的人真是有智慧，有聰明啊。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","哪一個大國的人有神與他們這樣親近，像耶和華我們的　神，在我們每次呼求他的時候，與我們親近一樣呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","又哪一個大國有這樣公義的律例和典章，像我今日在你面前頒布的這一切律法呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“你只要自己謹慎，又要謹守你的心思，免得你忘了你親眼看見的事，又免得這些事在你有生之日離開你的心；總要把這些事傳給你的子子孫孫， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","免得你忘了你在何烈山，站在耶和華你們的　神面前的那天。那時耶和華對我說：‘你要為我召集眾民，我要叫他們聽我的話，使他們在那地上生活的日子，可以學習敬畏我，又可以教訓自己的兒女。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","那時，你們走前來，站在山下；山上有火燒著，火燄沖天，又有黑暗、密雲和幽暗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","耶和華從火中對你們說話；你們只聽見聲音，卻沒有看見形象；只有聲音， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","把他的約，就是他吩咐你們遵守的那十條誡命，向你們宣布出來；又把它們寫在兩塊石版上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","那時，耶和華也吩咐我把律例和典章教訓你們，使你們在將要過去得為業的地上遵行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“所以你們要特別小心，謹慎自己，因為耶和華在何烈山從火中對你們說話的那一天，你們沒有看見甚麼形象； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","恐怕你們敗壞自己，為自己製造偶像，製造任何神像的形象，無論是男像或是女像， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","或是地上各種走獸的像，或是飛翔在空中各類有翅膀的雀鳥的像， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","或是地上各種爬行動物的像，或是地底下水裡各樣魚類的像。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","又恐怕你抬頭望天，看見日、月、星，就是天上萬象的時候，就被勾引，去敬拜和事奉它們，那原是耶和華你們的　神分給天下萬民享用的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","耶和華卻把你們從埃及，從鐵爐那裡領出來，作他自己的產業，自己的人民，像今日一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","耶和華又因你們的緣故，向我發怒，並且起誓不讓我過約旦河，也不容我進入耶和華你的　神賜給你作產業的那美地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","我只有死在此地，不得過約旦河；你們卻可以過去，取得那美地作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","你們要自己謹慎，免得你們忘記了耶和華你們的　神與你們所立的約，你們就為自己製造偶像，製造任何神像的形象，就是耶和華你的　神吩咐你不可作的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","因為耶和華你的　神是烈火，是忌邪的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“你們生子生孫，在那地住久了的時候，如果你們敗壞自己，製造偶像，製造任何神像的形象，行耶和華你的　神看為惡的事，惹他發怒， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","我今日就呼天喚地向你們作證，你們必在過約旦河取得為業的地上迅速滅亡；你們必不能在那地長久生存，必全被消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","耶和華必使你們分散在萬民中；在耶和華要領你們所到的萬國中，你們剩下的人數必不多。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","在那裡你們必事奉人手所做的神，就是用木頭石頭做成的，不能看、不能聽、不能吃、不能聞的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","但你們在那裡必尋求耶和華你的　神；如果你一心一意尋找他，就必尋見。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","日後，你落在患難中，這些事都臨到你身上的時候，你必歸向耶和華你的　神，聽從他的話； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","因為耶和華你的　神原是滿有憐憫的　神，他必不丟棄你，不毀滅你，也不忘記他起誓與你的列祖所立的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“你問問在你以前過去的日子，自從　神創造人在地上以來，從天這邊到天那邊，有沒有人行過這樣的大事，聽過像這樣的事呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","有沒有一個民族聽見　神在火中說話的聲音，像你聽見的一樣，還能活著呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","有沒有一位神嘗試藉著試驗、神蹟、奇事、戰爭、大能的手和伸出來的膀臂，以及大而可畏的事，把一國的人民從別的國中領出來，像耶和華你們的　神在埃及，在你們面前為你們所作的一切事呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","這是要顯明給你看，使你知道，只有耶和華是　神；除了他以外，再沒有別的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","他從天上使你聽見他的聲音，為要教導你；又在地上使你看見他的大火，並且叫你聽到他從火中所說的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","因為他愛你的列祖，所以才揀選了他們的後裔，用大能親自把你從埃及領出來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","為要把比你大比你強的民族，從你面前趕走，然後領你進去，把他們的地賜給你作產業，像今日一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","所以今天你要知道，也要記在心裡；天上地下，只有耶和華是　神；除他以外，再沒有別的神了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","你要遵守我今日吩咐你的律例和誡命，使你和你的子孫得享福樂，也使你在耶和華你的　神賜給你的那地上得享長壽。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","那時，摩西在約旦河東，日出的方向，把三座城分別出來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","讓那些素無仇恨、無心誤殺人的，可以逃到那裡去；逃到這三座城的一座去的，都可以活著： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","為流本人，分出了在曠野平原的比悉；為迦得人，分出了基列的拉末；為瑪拿西人，分出了巴珊的哥蘭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","以下是摩西在以色列人面前所立的律法， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","就是摩西在以色列人出埃及以後，對他們所說的法度、律例和典章； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","地點是在約旦河東，伯．毗珥對面的谷中，就是住在希實本的亞摩利人的王西宏的地。這西宏是摩西和以色列人出埃及後擊殺的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","他們佔領了他的地和巴珊王噩的地，就是兩個亞摩利人的王，是住在約旦河東，日出的方向的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","從亞嫩谷邊的亞羅珥，直到西雲山，西雲山就是黑門山； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","還有約旦河東的亞拉巴全地，直到亞拉巴海，就是毗斯迦的山坡下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","摩西把以色列人都召了來，對他們說：“以色列人哪，我今日講給你們聽的律例和典章，你們要聽從，要學習，要謹慎遵行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","耶和華我們的　神在何烈山與我們立了約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","這約，耶和華不是與我們的列祖立的，而是與我們今日在這裡還活著的人立的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","耶和華在山上，從火中，面對面的與你們說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","那時，我站在耶和華和你們中間，要把耶和華的話告訴你們；你們因為懼怕那火，所以沒有上到山上來，耶和華說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“‘我是耶和華你的　神，曾經把你從埃及地，從為奴之家領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“‘除我以外，你不可有別的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“‘你不可為自己做偶像，也不可做天上、地下和地底下水中各物的形象。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","不可跪拜它們，也不可事奉它們，因為我耶和華你們的　神是忌邪的　神；恨惡我的，我必追討他們的罪，從父親到兒子，直到三四代。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","愛我和遵守我誡命的，我必向他們施慈愛，直到千代。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“‘不可妄稱耶和華你　神的名，因為妄稱耶和華的名的，耶和華必不以他為無罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“‘要遵守安息日為聖日，照著耶和華你　神吩咐你的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","六日要勞碌，作你一切工作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","但第七日是屬於耶和華你　神的安息日；這一日，你和你的兒女、僕婢、牛驢和一切牲畜，以及你城裡的寄居者，不可作任何的工，好使你的僕婢可以和你一樣享受安息。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","你要記住：你在埃及地作過奴僕；耶和華你的　神用大能的手和伸出來的膀臂，把你從那裡領出來，因此耶和華你的　神吩咐你要守安息日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“‘要孝敬父母，照著耶和華你的　神吩咐你的，使你可以得享長壽，也使你在耶和華你的　神賜給你的地上，得享福樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“‘不可殺人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“‘不可姦淫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“‘不可偷盜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“‘不可作假證供陷害你的鄰舍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“‘不可貪愛你鄰舍的妻子；不可貪圖你鄰舍的房屋、田地、僕婢、牛驢和你鄰舍的任何東西。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“這些話就是耶和華在山上，從火中、密雲中、幽暗裡，大聲對你們全體會眾所說的，並沒有加添甚麼；他把這些話寫在兩塊石版上，交給了我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","那時山上被火燒著，你們聽見有聲音從黑暗中發出來的時候，你們各支派的首領和你們的長老，都走到我這裡來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","說：‘看哪，耶和華我們的　神把他的榮耀和偉大顯給我們看，我們又聽見他從火中發出來的聲音；今日我們看見了　神與人說話，而人還能活著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","現在這大火快要吞滅我們了，我們為甚麼要冒死呢？如果我們再聽見耶和華我們　神的聲音，我們就必死亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","因為有血肉生命的人，有誰像我們一樣，聽見永活的　神從火中說話的聲音，還能活著呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","現在求你走前去，聽聽耶和華我們的　神要說的一切話；然後你要把耶和華我們的　神對你所說的一切話，都告訴我們；我們就必聽從，也必遵行。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“你們對我說話的時候，耶和華聽見了你們說話的聲音；耶和華就對我說：‘這人民對你所說的話，我都聽見了；他們所說的都很好。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","但願他們常常存著這樣的心，敬畏我，遵守我的一切誡命，使他們和他們的子孫永享福樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","你去對他們說：“你們回到自己的帳棚裡去吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","至於你，你要站在我這裡；我要把一切誡命、律例、典章，都告訴你；你要教導他們，使他們在我賜給他們作產業的地上遵行。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","所以，你們要照著耶和華你們的　神吩咐你們的，謹守遵行，不可偏離左右。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","你們要走在耶和華你們的　神吩咐你們走的路上，使你們可以活著，可以享福，並且使你在將要佔領為業的地上，可以長久居住。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“以下是耶和華你們的　神吩咐我教導你們的誡命、律例、典章，使你們在將要過去佔領為業的地上遵行， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","好叫你和你的子子孫孫一生一世敬畏耶和華你的　神，遵守他的一切律例、誡命，就是我吩咐你的，使你的日子可以長久。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","以色列啊，你要聽從，就謹守遵行，使你在流奶與蜜的地可以享福，人數大大增多，像耶和華你列祖的　神應許你的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“以色列啊，你要聽，耶和華我們的　神是獨一的耶和華； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","你要全心、全性、全力愛耶和華你的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","我今日吩咐你的這些話，都要記在你的心上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","你要把這些話不斷地教訓你的兒女，無論你坐在家裡，或行在路上，或躺下，或起來的時候，都要談論。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","你也要把這些話繫在手上作記號，戴在額上作頭帶。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","又要寫在你房屋的門柱上和城門上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“耶和華你的　神領你進入他向你列祖亞伯拉罕、以撒、雅各起誓應許給你的地；那裡有不是你建造的，又高大又美麗的城市， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","有裝滿各樣美物的房子，不是你裝滿的；有鑿成的水池，不是你鑿成的；還有葡萄園和橄欖園，不是你栽種的；你可以吃，並且吃得飽足。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","那時，你要謹慎，免得你忘記了耶和華，就是把你從埃及地，從為奴之家領出來的那一位。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","你要敬畏耶和華你的　神，要事奉他，奉他的名起誓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","不可隨從別的神，就是你們周圍各民族的神； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","因為在你們中間的耶和華你們的　神，是忌邪的　神，恐怕耶和華你的　神向你發怒，就把你從這地上消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“你們不可試探耶和華你們的　神，像你們在瑪撒試探他一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","要謹慎遵守耶和華你們的　神吩咐你的誡命、法度和律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","耶和華看為正為好的事，你都要去行，使你可以享福，並且可以進去佔領耶和華向你的列祖起誓應許的那美地， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","照著耶和華說過的，把你所有的仇敵從你面前趕逐出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“日後，如果你的兒子問你：‘耶和華我們的　神吩咐的這法度、律例和典章，有甚麼意思呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","你就要對你的兒子說：‘我們在埃及曾經作過法老的奴僕，耶和華卻用大能把我們從埃及領了出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","耶和華在我們眼前，把又偉大又厲害的神蹟奇事行在埃及、法老和他全家的身上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","卻把我們從那裡領出來，為要領我們進入他向我們列祖起誓應許的地，要把這地賜給我們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","耶和華又吩咐我們遵行這一切律例，敬畏耶和華我們的　神，使我們常常得享福樂，使我們的生命得著保全，像今日一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","我們在耶和華我們的　神面前，如果照著他吩咐我們的，謹守遵行這一切誡命，這就是我們的義了。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“耶和華你的　神領你進入你要去得為業的地，從你面前趕走許多民族，就是赫人、革迦撒人、亞摩利人、迦南人、比利洗人、希未人、耶布斯人，共七個比你又大又強的民族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","耶和華你的　神把他們交給你，你打敗了他們的時候，你要完全毀滅他們，不可與他們立約，也不可恩待他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","不可與他們通婚，不可把你的女兒嫁給他們的兒子，也不可為你的兒子娶他們的女兒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","因為他必使你的兒子離開我，去事奉別的神，以致耶和華向你們發烈怒，就快快地把你們消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","你們卻要這樣待他們：拆毀他們的祭壇，打碎他們的神柱，砍下他們的亞舍拉，用火焚燒他們的雕像。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","“因為你是歸耶和華你的　神作聖潔的子民的；耶和華你的　神從地上的萬族中，揀選了你作他自己的產業，自己的子民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","耶和華喜愛你們，揀選你們，並不是因為你們的人數比別的民族多，其實你們的人數在萬族中是最少的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","而是因為耶和華對你們的愛，又因為他遵守他向你們的列祖所起的誓，他才用大能的手把你們領出來，把你們從為奴之家，從埃及王法老的手裡拯救出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","所以你要知道耶和華你的　神，他是　神，是信實可靠的　神；他向愛他和守他誡命的人，守約並且施慈愛，直到千代。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","但向恨他的人，卻要當面報應他們，把他們滅盡；恨他的，他都要當面報應他，決不遲延。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","所以你要謹守遵行我今日吩咐你的誡命、律例和典章。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“如果你們聽從這些典章，並且謹守遵行這一切，耶和華你的　神就必照著他向你的列祖所起的誓，向你守約並且施慈愛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","他必愛你，賜福與你，使你人數增多，也必在他向你的列祖起誓應許給你的地上，賜福與你身所生的，你地所產的，使你的五穀、酒、油，以及牛犢和羊羔增產。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","你必蒙福勝過萬民；在你中間沒有不能生育的男女，也沒有不能生殖的牲畜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","耶和華必使一切病症離開你；你所知埃及各種的惡疾，他決不加在你身上，卻加在一切恨你的人身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","耶和華你的　神交給你的所有民族，你都要把他們消滅；你的眼不可憐惜他們；你也不可事奉他們的神，因為這必成為你的網羅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“如果你心裡說：‘這些國的人比我多，我怎能把他們趕出去呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","你不要怕他們，只要牢牢地記住，耶和華你的　神向法老和全埃及所行的事， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","就是你親眼看見的大試驗、神蹟、奇事、大能的手和伸出來的膀臂，這都是耶和華你的　神領你出來的時候使用的；耶和華你的　神也必照樣待你懼怕的所有民族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","耶和華你的　神還要打發大黃蜂飛到他們中間，直到那些殘存躲藏起來的人，都從你面前消滅為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","你不要因他們驚慌，因為耶和華你的　神是在你們中間，他是大而可畏的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","耶和華你的　神必把這些國的民，從你面前漸漸趕出去；你不可以把他們迅速地滅盡，恐怕田間的野獸多起來害你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","耶和華你的　神必把他們交在你面前，使他們大起擾亂，直到他們全被消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","他也必把他們的君王交在你的手中，你必使他們的名從天下消滅；必沒有一人能在你面前站立得住，直到你把他們都消滅了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","他們的神像，你們要用火焚燒；神像上的金銀，你不可貪愛，也不可據為己有，免得你因此陷入網羅；因為這是耶和華你的　神厭惡的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","可厭惡的物，你不可帶進家裡去，免得你與那物一樣成了當毀滅的；你要非常憎恨它，十分厭惡它，因為這是當毀滅的物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“我今日吩咐你的一切誡命，你們要謹守遵行，使你們可以存活，人數增加，並且可以進去得著耶和華向你們的列祖起誓應許的那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","你也要記念耶和華你的　神這四十年在曠野引導你的一切路程，為要使你受苦，要試煉你，要知道你心裡怎樣，看看你肯守他的誡命不肯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","他使你受苦，任你飢餓，把你和你的列祖不認識的嗎哪賜給你吃，使你知道人活著，不是單靠食物，更要靠耶和華口裡所出的一切話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","這四十年來，你身上的衣服沒有穿破，你的腳也沒有腫起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","因此你心裡要明白，耶和華你的　神管教你，好像人管教他的兒子一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","所以你要謹守耶和華你的　神的誡命，遵行他的道路，敬畏他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","因為耶和華你的　神快要領你進入那美地；那地有河流，有泉，有源，水從谷中和山上流出來； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","那地有小麥、大麥、葡萄樹、無花果樹、石榴樹；那地有橄欖樹、油和蜜； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","你在那地必不缺乏食物，在那裡你必一無所缺；那地的石頭就是鐵；從那裡的山上，你可以挖出銅來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","你吃飽了，就要稱頌耶和華你的　神，因為他把那美地賜了給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“你要自己謹慎，免得忘記耶和華你的　神，不守他的誡命、典章、律例，就是我今日吩咐你的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","恐怕你吃飽了，建造美好的房屋居住， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","你的牛羊加多，你的金銀增添，你所有的一切都增加了， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","那時，你就心高氣傲，忘記了耶和華你的　神，就是把你從埃及地，從為奴之家領出來的那一位。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","他引導你走過那大而可畏的曠野，那裡有火蛇，有蠍子，有乾旱無水之地；他曾經為你使水從堅硬的磐石中流出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","他在曠野把你的列祖不認識的嗎哪賜給你吃，是要使你受苦，要試煉你，使你終久得到福樂； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","恐怕你心裡說：‘這財富是我的力量，是我手的能力使我得著的。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","你要記念耶和華你的　神，因為得財富的能力是他賜給你的，為要堅定他向你的列祖起誓所立的約，像今天一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","如果將來你真的忘記了耶和華你的　神，去隨從別的神，事奉和敬拜他們，你們必定滅亡，這是我今日警告你們的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","耶和華從你們面前怎樣使萬國的民滅亡，你們也必照樣滅亡，因為你們沒有聽從耶和華你們　神的話。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","“以色列啊，你要聽，你今日快要過約旦河，進去趕出比你又大又強的列國，佔領堅固、高得頂天的城市。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","那地的民族又高又大，就是亞衲族的人，是你知道的，你也聽過有人指著他們說：‘誰能在亞衲族人面前站立得住呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","所以今日你要知道，耶和華你的　神要像烈火一樣在你面前過去；他要消滅他們，他要在你面前把他們征服；這樣你就可以照著耶和華吩咐你的，把他們趕走，使他們迅速滅亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","耶和華你的　神把這些國的民從你面前驅逐出去以後，你心裡不要說：‘耶和華把我領進來取得這地，是因著我的義。’其實耶和華從你面前把這些國的民趕出去，是因著他們的惡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","你進去取得他們的地，並不是因著你的義，也不是因著你心裡的正直，而是因著這些國的民的惡，耶和華你的　神才把他們從你面前趕出去，為要實踐他向你的列祖亞伯拉罕、以撒、雅各，起誓應許的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","你要知道，耶和華你的　神把這美地賜給你作產業，並不是因著你的義；你本來是頑固的民族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“你要記住，不可忘記，你在曠野怎樣惹耶和華你的　神發怒；自從你出了埃及地的那天起，直到你們來到這地方，你們常是反抗耶和華的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","你們在何烈山又惹耶和華發怒，以致耶和華向你們發怒，要滅絕你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","那時，我上了山，要領受石版，就是耶和華與你們立約的石版；那時我在山上住了四十晝夜，不吃不喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","耶和華把那兩塊石版交給了我，是　神用手指寫的；石版上所寫的，是耶和華在大會之日，在山上從火中對你們所說的一切話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","過了四十晝夜，耶和華把那兩塊石版，就是約版，交給了我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","耶和華對我說：‘你起來，從這裡趕快下去，因為你從埃及領出來的人已經敗壞了，他們很快就偏離了我吩咐他們走的道路，為自己鑄造了偶像。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","“耶和華又對我說：‘你看這民族真是一個頑固的民族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","你不要管我，我要消滅他們，把他們的名字從天下除去；我要使你成為一個比他們更強更大的國。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","於是我轉身，從山上下來，山上有火燒著；我手中拿著兩塊約版。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","我觀看，見你們自己鑄造了牛犢，很快就離開了耶和華吩咐你們走的道路。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","我拿著那兩塊石版，從我兩手中扔下去，在你們眼前摔碎了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","為了你們所犯的一切罪，作了耶和華看為惡的事，惹他發怒，我就像先前那樣，俯伏在耶和華面前，四十晝夜，不吃不喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","因為耶和華向你們大發烈怒，要消滅你們，我就很懼怕；但是那一次耶和華也聽了我的懇求。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","耶和華也向亞倫發怒，要消滅他；那時候我也為亞倫祈禱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","我把你們的罪，就是你們鑄造的牛犢，拿去用火燒了，又把它搗碎，磨成細粉，像灰塵一樣；我把這灰塵撒在從山上流下來的溪水中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","“後來你們在他備拉、瑪撒、基博羅．哈他瓦，又惹耶和華發怒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","耶和華打發你們離開加低斯．巴尼亞，說：‘你們上去得我賜給你們作產業的地。’那時你們竟違背耶和華你們的　神的命令，不相信他，不聽從他的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","自從我認識了你們那一天起，你們就常常悖逆耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","“因為耶和華說要消滅你們，我就俯伏在耶和華面前，共俯伏了四十晝夜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","我祈求耶和華，說：‘主耶和華啊，求你不要毀滅你的子民，你的產業，就是你藉著你的大能救贖，藉著你有力的手從埃及領出來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","求你記念你的僕人亞伯拉罕、以撒、雅各；不要看這民族的頑固、邪惡和罪過， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","免得你領我們從那裡出來的那地的人說：“耶和華因為不能把他們領進他應許的地，又因為恨他們，所以才把他們領出來，要在曠野殺死他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","但是，他們是你的子民，是你的產業，又是你藉著大能和伸出來的膀臂領出來的。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","“那時，耶和華對我說：‘你要鑿出兩塊石版，和先前的一樣，然後上山到我這裡來；又要做一個木櫃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","我要把你摔碎的先前那兩塊版上的話，寫在這兩塊版上；你要把它們放在櫃中。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","於是我用皂莢木做了一個櫃，又鑿出了兩塊石版，和先前的一樣；然後我手裡拿著這兩塊石版，上山去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","耶和華把先前所寫的，就是在集會的日子，在山上從火中告訴你們的十誡，都寫在這兩塊版上；耶和華把石版交給了我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","於是我轉身從山上下來，把石版放在我所做的櫃中，照著耶和華吩咐我的，現在石版還放在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","“以色列人從比羅比尼．亞干起程，到了摩西拉。亞倫在那裡死了，也埋葬在那裡；他的兒子以利亞撒接替他供祭司的職分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","他們從那裡起程，到了谷歌大，又從谷歌大到約巴他，就是多溪水的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","那時，耶和華把利未支派分別出來，叫他們抬耶和華的約櫃，侍立在耶和華面前事奉他，並且奉他的名祝福，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","所以利未人在兄弟中無分無業；照著耶和華你的　神應許他的，耶和華自己就是他的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","“我又像以前那樣，在山上停留了四十晝夜；那一次耶和華也聽了我的呼求，他不願把你毀滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","耶和華對我說：‘你起來，走在人民的前面，使他們可以進去，得著我向他們列祖起誓賜給他們的那地。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“以色列啊，現在耶和華你的　神向你要的是甚麼呢？只要你敬畏耶和華你的　神，行在他的一切道路上，愛他，一心一意事奉耶和華你的　神， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","遵守耶和華的誡命和律例，就是我今日吩咐你的，為要叫你得福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","看哪，天和天上的天，地和地上的一切都是屬於耶和華你的　神的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","但耶和華只喜悅你的列祖，愛他們；他從萬民中揀選了他們的後裔，就是你們，像今日一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","所以你們要給你們的心行割禮，不可再頑固。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","因為耶和華你們的　神，他是萬神之神、萬主之主、偉大有力和可畏的　神；他不徇情面，也不受賄賂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","他為孤兒寡婦伸張正義，又把衣食給寄居的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","所以你們要愛寄居的人，因為你們在埃及地也作過寄居的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","你要敬畏耶和華你的　神，事奉他，依靠他，奉他的名起誓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","他是你當頌讚的；他是你的　神，他為你作了那些大而可畏的事，就是你親眼見過的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","你的列祖下到埃及的時候，一共不過七十人，現在耶和華你的　神卻使你的人數像天上的星那麼多了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","“所以你要愛耶和華你的　神，常常遵守他的吩咐、律例、典章和誡命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","今日你們要知道，我並不是與你們的兒女說話，因為他們不知道，也沒有見過耶和華你們的　神的管教、偉大有力的手和伸出來的膀臂， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","以及他在埃及向埃及王法老和法老的全國所行的神蹟和作為； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","他們也沒有見過他怎樣對待埃及的軍隊、馬匹和車輛；他們追趕你們的時候，耶和華怎樣使紅海的水淹沒了他們，把他們滅絕，這事一直傳到今日； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","並且耶和華在曠野怎樣待你們，直到你們來到了這個地方； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","也沒有見過他怎樣對待流本的子孫以利押的兒子大坍、亞比蘭；大地怎樣在全體以色列人中間裂開了，把他們和他們的家人、帳棚，以及與他們在一起一切有生命之物都吞下去； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","只有你們親眼看見了耶和華所作的一切偉大的作為。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","“所以你們要遵守我今日吩咐你的一切誡命，使你們堅強起來，可以進去得著你們將要過去得的那地， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","又使你們在耶和華向你們的列祖起誓應許賜給他們和他們後裔的地上，就是流奶與蜜的地，可以長久居住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","因為你要進去得的那地，並不像你出來的埃及地；在那裡你撒了種，還要用腳灌溉，像菜園一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","但你們要過去得為業的地，卻是一個有山有谷的地，有天上雨水滋潤的地， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","就是耶和華你的　神眷顧的地；從歲首到年終，耶和華你的　神的眼目常常眷顧這地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","“如果你們留心聽我今日吩咐你們的誡命，愛耶和華你們的　神，一心一意事奉他， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","他必按時降雨在你們的地上，就是降秋雨和春雨，使你們可以豐收五穀、新酒和新油。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","他也必使田野為你的牲畜長出青草來，你也可以吃得飽足。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","你們要謹慎，免得你們的心受迷惑，你們就偏離了我，去事奉別的神，並且敬拜它們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","叫耶和華的怒氣向你發作，就把天封閉，不降下雨水，地也不生出土產，使你們從耶和華賜給你們的美地上，快快地滅亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","“所以你們要把我這些話放在心裡，存在意念中；要繫在手上作記號，戴在額上作頭帶。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","你們也要把這些話教訓你們的兒女，無論你是坐在家裡，行在路上，躺下，或是起來，都要講論。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","你要把這些話寫在你房屋的門柱上和城門上， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","為要叫你們和你們的子孫的日子，在耶和華向你們列祖起誓應許給他們的地上，可以增多，像天覆地的年日那樣多。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","如果你們殷勤謹守遵行我吩咐你們的這一切誡命，愛耶和華你們的　神，行他的一切道路，又緊緊地依靠他， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","耶和華就必從你們面前把這些國民都趕出去，你們就必佔領比你們大比你們強的國民的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","你們腳掌所踏的地，都必屬於你們；從曠野到黎巴嫩，從幼發拉底河直到西海，都要作你們的境界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","必沒有一人能在你們面前站立得住；耶和華你們的　神，必照著他對你們所說的，使害怕和驚懼你們的心臨到你們將要踏足之地的居民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“看哪，我今日把祝福和咒詛都擺在你們面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","如果你們聽從耶和華你們的　神的誡命，就是我今日吩咐你們的，你們就必蒙賜福； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","如果你們不聽從耶和華你們的　神的誡命，偏離了我今日吩咐你們要走的道路，去隨從你們素來不認識的別神，你們就必受咒詛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","耶和華你的　神領你進入你要佔領為業之地以後，你就要把祝福擺在基利心山上，把咒詛擺在以巴路山上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","這兩座山不是在約旦河西、日落的地方，在住亞拉巴的迦南人之地，與吉甲相對，靠近摩利橡樹那裡嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","現在你們快要過約旦河，進去得耶和華你們的　神要賜給你們為業之地；你們取得了那地，就住在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","你們要謹守遵行我今日在你們的面前頒布的一切律例和典章。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","“你們活在地上的一切日子，在耶和華你列祖的　神賜給你作產業的地上，要謹守遵行的律例和典章，就是這些： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","你們要把你們趕走的列國的人事奉神的地方，無論是在高山上，在山岡上，或是在各青翠樹下，都要完全毀壞； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","也要拆毀他們的祭壇，打碎他們的神柱；用火焚燒他們的亞舍拉，砍倒他們的神的雕像，並且把他們的名字從這地方除滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","你們不可像他們那樣事奉耶和華你的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","耶和華你們的　神從你們各支派中，選擇了甚麼地方作立他名的居所，你們就當到那裡求問他； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","把你們的燔祭和其他的祭物、十分之一的禮物和手中的貢獻、還願祭和甘心祭，以及牛群羊群中頭生的，都要帶到那裡去； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","在那裡，就是在耶和華你們的　神面前，你們和你們的家人都可以吃；並且要因你們手所作的一切事，都蒙耶和華你的　神賜福而歡樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","我們今日在這裡所行的，是行各人看為正的事，你們將來不可以這樣行； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","因為你們現在還沒有到耶和華你的　神賜給你的安息地和產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","但是你們過了約旦河，住在耶和華你們的　神使你們承受為業的地，又使你們太平，脫離你們周圍的所有仇敵，安居樂業， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","那時，你要把我吩咐你們的燔祭和其他的祭物、十分之一的禮物和手中的貢獻，以及你們向耶和華許願要獻的最美的一切還願祭，都要帶到耶和華你們的　神選擇作為立他名的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","你們和你們的兒女、僕婢，以及住在你們城裡的利未人，都要在耶和華你們的　神面前歡樂，因為利未人在你們中間無分無業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","你要自己謹慎，不可在你看見的任何地方獻上你的燔祭； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","只要在耶和華從你的一個支派中揀選的地方，在那裡獻上你的燔祭，在那裡行我吩咐你的一切事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","“不過在你的各城裡，你都可以照著耶和華你的　神賜給你的福分，隨意殺牲吃肉。不潔淨的人和潔淨的人都可以吃，像吃羚羊和鹿的肉一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","只有血，你們不可吃；要倒在地上，像倒水一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","你的五穀、新酒和新油的十分之一，你牛群羊群中頭生的和你所許一切還願的祭、你甘心獻的祭和你手中的貢獻，都不可在你的城裡吃； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","你只要在耶和華你的　神面前，和在耶和華你的　神選擇的地方吃，你和你的兒女、僕婢，以及在你城裡的利未人，都可以吃；你也要因你手所作的一切事在耶和華你的　神面前歡樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","你要自己謹慎，你在你那地上的日子，永不可丟棄利未人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","“耶和華你的　神，照著他應許你的，擴張了你的境界的時候，如果你因心裡渴想吃肉，說：‘我想吃肉。’那麼，你就可以隨意吃肉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","耶和華你的　神選擇作立他名的地方，如果離開你太遠，你就可以照著我吩咐你的，把耶和華賜給你的牛羊取些宰殺了，可以在你的城裡隨意地吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","你吃那肉，好像人吃羚羊和鹿的肉一樣；不潔淨的人和潔淨的人都可以一起吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","只是你要心意堅定，不可吃血，因為血就是生命；你不可把生命和肉一起吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","你不可吃血，要倒在地上，像倒水一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","你不可吃血，好使你和你的子子孫孫得享福樂，因為你行了耶和華看為正的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","只是你要把你應有的聖物和你的還願祭，都帶到耶和華選擇的地方去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","把你的燔祭、肉和血，都獻在耶和華你的　神的祭壇上；其他的祭的血，要倒在耶和華你的　神的祭壇上；至於那肉，你卻可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","你要謹慎聽從我吩咐你的這一切話，好使你和你的子子孫孫永遠得享福樂，因為你行了耶和華看為好為正的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","“耶和華你的　神把你將要進去趕走的列國的民，從你的面前除滅以後，你就得著他們的地，住在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","那時，你要自己謹慎，不可在他們從你的面前被消滅以後，隨從他們的惡俗而陷入網羅，也不可求問他們的神，說：‘這些國的人怎樣事奉他們的神，我也要這樣行。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","你不可向耶和華你的　神這樣行，因為耶和華恨惡的一切可厭惡的事，他們都向他們的神行了，甚至把自己的兒女用火焚燒，獻給他們的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","“我吩咐你們的一切話，你們都要謹守遵行，不可加添，也不可減少。”（本節在《馬索拉抄本》為13:1） ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","“你們中間如果有先知，或作夢的人興起來，給你顯示神蹟或奇事；（本節在《馬索拉抄本》為13:2） ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","他告訴你的神蹟和奇事應驗了，以致他對你說：‘我們去隨從別的、你不認識的神，事奉他們吧。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","你不可聽從那先知或作夢的人的話；因為耶和華你們的　神試驗你們，要知道你們是不是一心一意愛耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","你們要順從耶和華你們的　神，敬畏他，遵守他的誡命，聽從他的話，事奉他，緊靠他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","至於那先知，或作夢的人，你們要把他處死，因為他說了叛逆的話，叛逆了那領你們出埃及地，救贖你脫離為奴之家的耶和華你們的　神，要你離棄耶和華你的　神吩咐你走的道路。這樣你就把那惡從你們中間除掉了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","“你的同母兄弟或你的兒女，你懷中的妻子或視你如自己性命的朋友，如果暗中引誘你，說：‘我們去事奉別的神吧。’就是你和你的列祖向來不認識的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","是你們周圍各族的神，無論是離你近的，或是離你遠的神；從地這邊直到地那邊的神， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","你都不可依從他，也不可聽從他；你的眼不可顧惜他，你不可憐憫他，也不可袒護他； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","總要把他殺死，你要先向他動手，然後全民才動手打死他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","你要用石頭打死他，因為他要使你離棄那領你出埃及地，脫離為奴之家的耶和華你的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","這樣，全以色列聽見了，必然害怕，就不會再在你們中間行這樣的惡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","“在耶和華你的　神賜給你居住的一座城中，如果你聽說 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","有些匪徒從你中間出來，把本城的居民引離，說：‘我們去事奉別的神吧。’那些神是你們素來不認識的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","你就要調查、研究，仔細訪問，如果的確有這可厭惡的事行在你們中間， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","你就要用刀劍把那城裡的居民殺掉，把那城和城裡的一切，以及牲畜，都用刀劍完全毀滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","並且把從城裡掠奪的一切戰利品，都要收集在那城的廣場上，用火把城和在城裡掠奪的一切戰利品焚燒，獻給耶和華你的　神；那城就要永遠成為廢墟，不可再建造。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","那當毀滅的物，一點也不可留在你手中，好使耶和華轉意不發烈怒，反而向你施恩，憐憫你，照著他向你的列祖所起的誓，使你的人數增多； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","只要你聽從耶和華你的　神的話，遵守我今日吩咐你的一切誡命，實行耶和華你的　神看為正的事，就必這樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","“你們是耶和華你們的　神的兒女，不可為了死人割傷自己的身體，也不可使你們的額上光禿； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","因為你是屬於耶和華你的　神的聖潔子民；耶和華從地上的萬民中揀選了你們，特作他自己的子民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","“可厭惡之物，你都不可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","你們可以吃的牲畜是以下這些：牛、綿羊、山羊、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","鹿、羚羊、赤鹿、野山羊、麋鹿、野羊、野鹿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","在走獸中，分蹄成兩蹄趾，又反芻的走獸，你們都可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","但是那些反芻或分蹄的走獸中，你們不可吃的有：駱駝、兔子和石獾，因為牠們反芻卻不分蹄，就對你們不潔淨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","至於豬，因為牠分蹄卻不反芻，就對你們不潔淨。牠們的肉，你們不可吃；牠們的屍體，你們不可觸摸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","“在水中，你們可以吃的，有以下這些：有鰭有鱗的，你們都可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","有鰭沒有鱗的，你們都不可吃；這是對你們不潔淨的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","“潔淨的鳥類，你們都可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","你們不可吃的鳥類有以下這些：鷹、狗頭鷹、紅頭鷹、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","鳶、隼、黑隼，以及這一類的鳥； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","烏鴉和這一類的鳥； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","駝鳥、夜鷹、海鷹、雀鷹，以及這一類的鳥； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","小貓頭鷹、貓頭鷹、角鴟、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","小梟、禿鵰、魚鷹、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","鸛、鷺，以及這一類的鳥；戴勝和蝙蝠。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","有翅膀的昆蟲，對你們都不潔淨，你們都不可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","潔淨的鳥類，你們都可以吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","“自死的動物，你們都不可吃；可以送給你城裡的寄居者吃，或是賣給外族人吃，因為你是歸耶和華為聖的子民；不可用山羊羔母的奶煮山羊羔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","“你要把你撒種所產的，就是田地每年所出的，獻上十分之一。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","又要把你的五穀、新酒和新油的十分之一，以及你牛群羊群中頭生的，在耶和華你的　神面前吃，就是在他選擇作他名的居所的地方吃，好使你可以學習常常敬畏耶和華你的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","耶和華你的　神賜福與你的時候，耶和華你的　神選擇要立為他名的地方，如果離你太遠，那路又太長，使你不能把供物帶到那裡去； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","你就可以換成銀子，把銀子拿在手裡，到耶和華你的　神選擇的地方去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","你可以用這銀子隨意買牛羊、清酒和烈酒；你心想要的，都可以買；在那裡，你和你的家人，都要在耶和華你的　神面前吃喝歡樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","住在你城裡的利未人，你不可丟棄他，因為他在你們中間無分無業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","“每三年之末，你要把那一年的全部出產的十分之一取出來，積存在你的城裡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","這樣，利未人（因為他在你們中間無分無業），以及在你城裡的寄居者和孤兒寡婦，就可以來，吃得飽足；好叫耶和華你的　神，在你手所作的一切事上，賜福給你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","“每七年的最後一年，你要施行豁免。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","豁免的方式是這樣：債主都要把借給鄰舍的一切豁免了，不可向鄰舍和兄弟追討，因為耶和華的豁免年已經宣告了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","如果借給外族人，你可以向他追討，但借給你的兄弟，無論你借的是甚麼，你都要豁免。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","在你中間必沒有窮人，因為在耶和華你的　神賜給你作產業的地上，耶和華必大大賜福給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","只要你留心聽從耶和華你的　神的話，謹守遵行我今日吩咐你的一切誡命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","因為耶和華你的　神，必照著他應許你的，賜福給你；你必借貸給許多國的民，卻不會向他們借貸；你必統治許多國的民，他們卻不會統治你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","“但是在耶和華你的　神賜給你的地上，無論哪一座城裡，在你中間如果有一個窮人，又是你的兄弟，你對這窮苦的兄弟不可硬著心腸，也不可袖手不理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","你一定要向他伸手，照著他缺乏的借給他，補足他的缺乏。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","你要自己謹慎，不可心裡起惡念，說：‘第七年的豁免年近了’，你就冷眼對待你窮苦的兄弟，甚麼都不給他，以致他因你求告耶和華，你就有罪了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","你必須給他，給他的時候，你不要心裡難受，因為為了這事，耶和華你的　神必在你一切工作上，和你所辦的一切事上，賜福給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","既然在地上必有窮人存在，所以我吩咐你說：‘你總要向你地上的困苦和貧窮的兄弟大伸援助之手。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","“你的兄弟，無論是希伯來男人，或是希伯來女人，如果賣身給你，要服事你六年；到第七年，就要讓他離開你得自由。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","你使他自由離開的時候，不可讓他空手而去； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","要從你的羊群、禾場、榨酒池中，多多地供給他；耶和華你的　神怎樣賜福給你，你也要怎樣分給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","你要記得你在埃及地作過奴僕，耶和華你的　神救贖了你；因此我今日吩咐你這件事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","如果他對你說：‘我不願離開你。’他說這話是因為他愛你和你的家，又因為他喜歡和你相處， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","那麼，你就要拿錐子，把他的耳朵在門上刺透，他就永遠作你的奴僕；對待你的婢女，你也要這樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","你使他自由離開你的時候，不要為難，因為他服事了你六年，應得雇工雙倍的工資；這樣，耶和華你的　神必在你所作的一切事上，賜福給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","“你的牛群羊群中所生，是頭生雄性的，你都要把牠分別為聖歸給耶和華你的　神。你的牛群中頭生的，你不可用牠去耕田；你的羊群中頭生的，你不可給牠剪毛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","你和你的家人，年年要在耶和華選擇的地方，在耶和華你的　神面前，吃這頭生的牲畜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","這頭生的，如果有甚麼殘疾，像瘸腿或是瞎眼，無論有任何嚴重的殘疾，你都不可獻給耶和華你的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","你可以在家裡吃，不潔淨的人和潔淨的人都一樣可以吃，像吃羚羊和鹿一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","只是不可吃牠的血；要把血倒在地上，像倒水一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","“你要守亞筆月，向耶和華你的　神守逾越節，因為耶和華你的　神在亞筆月的一個晚上，把你從埃及地領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","你要在耶和華選擇立為他名的居所的地方，把羊和牛作逾越節的祭牲獻給耶和華你的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","你吃這祭的時候，不可和有酵的餅一同吃；七日之內，你要吃無酵餅，就是困苦餅，因為你是急急忙忙從埃及地出來的，好使你一生的年日都可以記念你從埃及地出來的日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","七天之內，在你的全境不可見有酵。第一天晚上你獻的祭肉，一點也不可剩下，留到早晨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","你不能在耶和華你的　神賜給你的任何一座城裡，宰殺逾越節的祭牲； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","只能在耶和華你的　神選擇作他名的居所的地方，晚上日落的時候，就是你出埃及的時刻，宰殺逾越節的祭牲； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","你要在耶和華你的　神選擇的地方，把祭肉煮了吃；到了早晨，你才可以回到家裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","六日之內你要吃無酵餅；到了第七日，要向耶和華你的　神守聖會；甚麼工都不可作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","“你要計算七個七日，從開鐮收割禾稼的時候算起，共計七個七日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","你要向耶和華你的　神舉行七七節，照著耶和華你的　神賜福你的，盡你所能的獻上你手裡的甘心祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","你和你的兒女、僕婢，以及在你城裡的利未人、在你們中間的寄居者、孤兒和寡婦，都要在耶和華你的　神選擇作他名的居所的地方歡樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","你也要記得你在埃及作過奴僕；你要謹守遵行這些律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","“你從禾場上和榨酒池裡收藏了出產以後，就要舉行住棚節七日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","在這節期以內，你和你的兒女、僕婢，以及住在你城裡的利未人、寄居者、孤兒和寡婦，都要歡樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","你要在耶和華選擇的地方，向耶和華你的　神守節七日，因為耶和華你的　神，要在你一切土產上，和你手所作的一切事上，賜福給你，你就滿有歡樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","每年三次，就是在除酵節、七七節、住棚節，你所有的男丁都要在耶和華選擇的地方，朝見耶和華你的　神；但不可空手朝見耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","各人要按手中的力量，照著耶和華你的　神賜你的福，奉獻禮物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","“在耶和華你的　神賜給你的各城裡，你要按著各支派設立審判官和官長；他們要按著公義的判斷審判人民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","不可屈枉正直，不可徇人的情面，不可收受賄賂，因為賄賂能使智慧人的眼變瞎，也能使義人的話顛倒過來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","你要追求公正公義，好使你能存活，並且能承受耶和華你的　神賜給你的地作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","“在你為耶和華你的　神築的祭壇旁邊，不可栽種甚麼樹木，作亞舍拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","也不可為自己豎立神柱，這是耶和華你的　神所恨惡的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","“有殘疾，或有甚麼缺點的牛羊，都不可獻給耶和華你的　神，因為這是耶和華你的　神所憎惡的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","“在你中間，就是耶和華你的　神賜給你的任何一座城裡，如果發現有人，無論是男是女，行耶和華你的　神眼中看為惡的事，違犯了他的約， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","去事奉別的神，並且敬拜它們，敬拜太陽或月亮，或任何天象，是我耶和華沒有吩咐的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","有人告訴你，你也聽見了，就要好好調查；如果確有這些事，真的在以色列中行了這可憎可厭的事； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","你就要把那個行了這惡事的男人或女人帶出來，到城門那裡去，用石頭把他們打死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","憑著兩個或三個見證人的口供，就可以把那該死的人處死；只是憑著一個見證人的口供，卻不可以把人處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","見證人要先下手，然後眾民也下手，把他處死。這樣，你就把那惡從你中間除掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","“在你的城裡如果有甚麼爭訟的事：或是流血，或是訴訟，或是毆打，是你很難處決的案件，你就要起來，上到耶和華你的　神選擇的地方， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","去見利未支派的祭司和當時的審判官，詢問他們，他們就必指示你們怎樣判斷這案件。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","你要照著他們從耶和華選擇的那地方，向你指示的話去行；他們指教你的，你都要謹守遵行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","你要按著他們指教你的律法，和照著他們告訴你的判斷去行；他們告訴你的話，你不可偏左或偏右。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","如果有人擅自行事，不聽從祭司，就是侍立在那裡事奉耶和華你的　神的，或是不聽從審判官，那人就必須處死；這樣，你就可以把這惡從以色列中肅清了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","眾民都會聽見，而且懼怕，也不再擅自行事了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","“你進了耶和華你的　神賜給你的地，佔領了那地，居住在那裡的時候，如果你說：‘我要立一位君王治理我，像我四圍的列國一樣。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","你總要立耶和華你的　神揀選的人作君王管理你；你要從你的兄弟中立一位作你的君王；不可立你的兄弟以外的人作王管理你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","只是君王不可為自己加添馬匹，也不可使人民回埃及去，為要加添馬匹，因為耶和華曾經對你們說過：‘你們不可再回到那條路去。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","他也不可為自己加添妃嬪，恐怕他的心偏離了耶和華；也不可為自己積蓄極多的金錢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","“他登上了國位的時候，就要把利未支派的祭司面前的律法書，為自己抄錄一份副本。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","那份副本要常在他身邊，他一生的年日都要誦讀，好學習敬畏耶和華他的　神，謹守遵行這律法書上的一切話和這些律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","這樣，他的心就不會高傲，輕看自己的兄弟，也不會偏左偏右，離了這誡命；好使他和他的子孫在以色列中，在他的國位上，可以日子長久。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","“利未支派的祭司和利未整個支派，在以色列中，必無分無業；他們所吃的，是獻給耶和華的火祭和他們應得的一份。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","利未人在兄弟中必沒有產業，耶和華就是他們的產業，正如耶和華應許他們的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","“祭司從人民應得的分是這樣：人無論是獻牛或是獻羊，要把前腿、兩腮和胃給祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","你也要把初熟的五穀、新酒、新油和初剪的羊毛給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","因為耶和華你的　神從你的各支派中把他揀選出來，使他和他的子孫，可以常常奉耶和華的名侍立供祭司的職。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","“如果有住在以色列中任何一座城裡的利未人，離開了那裡，一心一意到耶和華選擇的地方去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","他就可以奉耶和華他的　神的名供職，像他的眾兄弟利未人在那裡侍立在耶和華面前一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","除了他從父家承受的產業以外，他還可以得著和他的兄弟相等分量的祭物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“你到了耶和華你的　神要賜給你的那地的時候，那些外族人可厭可惡的事，你不可學習去行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","在你中間不可有人把自己的兒女獻作火祭，也不可有占卜的、算命的、用法術的、行邪術的、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","念咒的、問鬼的、行巫術的、過陰的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","因為行這些事的，都是耶和華厭惡的；就是因為這些可厭可惡的事的緣故，耶和華你的　神才把他們從你的面前趕走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","你要在耶和華你的　神面前作完全人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","“因為你要趕走的那些民族，都聽從算命的和占卜的；至於你，耶和華你的　神卻不容許你這樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","“耶和華你的　神要從你中間，就是從你的眾兄弟中間，給你興起一位先知來，像我一樣；你們要聽從他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","這正是你在何烈山開大會的日子，求耶和華你的　神的一切話，說：‘不要讓我再聽見耶和華我的　神的聲音了；也不要讓我再看見這大火了，免得我死亡。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","耶和華對我說：‘他們所說的都很好。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","我要從他們的兄弟中間，給他們興起一位先知，像你一樣；我要把我的話放在他口裡，他必把我吩咐他們的一切話都對他們說。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","如果有人不聽從他奉我的名所說的話，我必親自追討那人的罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","“‘不過，如果有先知擅自奉我的名，說我沒有吩咐他說的話，或是奉別神的名說話，那先知就必須處死。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","如果你心裡說：‘耶和華沒有說過的話，我們怎能知道呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","一位先知奉耶和華的名說話，如果那話不成就，也不應驗，這話就不是耶和華說的；是那先知擅自說的，你不要怕他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","“耶和華你的　神把列國的民剪除了，耶和華你的　神把他們的地賜給了你，你趕走了那些國民，住在他們的城市和房屋以後， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","你就要在耶和華你的　神賜給你得為業的地上，為自己分別三座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","你要為自己預備道路，又要把耶和華你的　神給你作產業的地分為三區，使誤殺人的可以逃到那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","“誤殺人的逃到那裡，就可以存活，規例是這樣：無意殺了人，彼此又素無仇恨的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","譬如他和鄰舍同進森林砍伐樹木，他手裡揮著斧子砍伐樹木的時候，斧頭竟脫了把，落在鄰舍身上，以致那人死了，他就可以逃到這些城中的一座去，這樣他就可以活命， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","免得報血仇的，心中怒火如焚的時候，追趕那誤殺人的，因為路途長遠，就追上了他，把他殺死；其實他沒有該死的罪，因為他和那人素無仇恨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","因此我吩咐你：‘你要為自己分別三座城。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","如果耶和華你的　神照著他向你列祖起過的誓，擴張你的境界，把他應許賜給你列祖的全地，都賜給了你， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","如果你謹守遵行我今日吩咐你的這一切誡命，愛耶和華你的　神，常常行他的道路，你就要在這三座城以外，再加添三座城； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","免得無辜人的血，流在耶和華你的　神要賜給你作產業的地上，以致流人血的罪歸在你身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","“但是，如果有人恨他的鄰舍，埋伏著等他，起來攻擊他，把他殺死了，然後逃到這些城中的一座； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","他本城的長老要派人去，把他從那裡帶出來，交在報血仇的人手中，好把他處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","你的眼睛不可顧惜他，卻要把流無辜人的血的罪從以色列中除掉，好使你平安無事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","“在耶和華你的　神要賜給你承受為業的地上，不可挪移你鄰舍的地界，因為那是先人立定的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","“人無論有甚麼過錯，或是犯了甚麼罪惡，不可憑著一個見證人的指證，總要憑著兩個見證人的口供，或是三個見證人的口供，才可以確定。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","如果有強橫的見證人起來，指證某人作惡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","那麼，兩個彼此爭訟的人，就要站在耶和華面前，和當時在職的祭司與審判官面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","審判官要仔細查問；如果見證人是個假證人，作假見證陷害自己的兄弟， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","你們就要像他想怎樣對待自己的兄弟一樣對待他，這樣，你就把那惡從你們中間除掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","其餘的人聽見了，就必害怕，不敢再在你中間行這樣的惡事了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","你的眼睛不可顧惜，要以命償命，以眼還眼，以牙還牙，以手還手，以腳還腳。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","“你出去和你的仇敵作戰的時候，看見馬匹、車輛和比你多的人群，你不要怕他們，因為那把你們從埃及地領上來的耶和華你的　神，與你同在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","你們快要上戰場的時候，祭司要上前來，對人民說話， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","對他們說：‘以色列人哪，你們要聽，你們今日快要和仇敵作戰，你們不要膽怯，不要懼怕，不要驚慌，不要因他們的緣故戰兢； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","因為耶和華你們的　神和你們同去，要為你們攻打你們的仇敵，要拯救你們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","官長也要對人民宣告：‘誰建造了新房屋，還沒有行過奉獻禮的，他可以回家去，恐怕他死在戰場上，別人去為他的房屋行奉獻禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","誰栽種了葡萄園，還沒有享用過它的果子的，他可以回家去，恐怕他死在戰場上，別人去享用它的果子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","誰與女子訂了婚，還沒有迎娶的，他可以回家去，恐怕他死在戰場上，別人去娶了她。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","官長又要對人民宣告：‘誰是懼怕、膽怯的，他可以回家去，恐怕他使他兄弟的心融化，像他的心一樣。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","官長對人民講完了話，就要指派軍官統率他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","“你臨近一座城，要攻打那城的時候，要先向那城提和議。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","如果那城以和平的話回答你，給你開門，城裡所有的人都要給你作苦工，服事你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","如果那城不肯與你言和，卻要與你作戰，你就要圍困那城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","耶和華你的　神把城交在你手裡的時候，你要用利刃殺盡城裡所有的男丁。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","只有婦人、小孩子、牲畜和城裡所有的一切，就是一切戰利品，你都可以據為己有，你的仇敵的戰利品，你都可以吃用，因為這是耶和華你的　神賜給你的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","離開你很遠的各城，不是屬於這些國民的城，你都要這樣對待他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","只是在耶和華你的　神賜給你作產業的這些國民的城市裡，凡有氣息的，連一個你也不可讓他活著； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","只要照著耶和華你的　神吩咐你的，把赫人、亞摩利人、迦南人、比利洗人、希未人、耶布斯人，完全滅絕； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","免得他們教導你們學習一切可憎的事，就是他們對自己的神所行的事，以致他們得罪耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","“如果你圍困一座城，很久才能攻取佔領它，你就不可揮斧破壞那裡的樹木；因為你可以吃樹上的果子，卻不可以砍伐樹木。難道田間的樹木是人，可以被你圍困的嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","只有你知道不結果子的樹木，你才可以毀壞砍伐，用來建造圍城的設備，攻擊那與你作戰的城，直到把它攻下為止。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","“在耶和華你的　神賜給你作產業的地上，如果發現有被殺的人，倒臥在田野，又不知道是誰殺死他的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","這樣，你的長老和審判官就要出去，量一下從被殺的人那裡到四周城市的距離。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","看看哪一座城離那被殺的人最近，那城的長老就要從牛群中取一隻母牛犢，就是還沒有耕過地、沒有負過軛的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","那城的長老要把母牛犢牽下去，到一個有活水長流的山谷，就是未曾耕種過、未曾撒過種的地方，在那裡要打折母牛犢的頸項。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","利未支派的祭司的子孫要上前來，因為耶和華你的　神揀選了他們事奉他，奉耶和華的名祝福。一切爭訟和一切毆打的事，都要憑他們的話決定。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","那城所有的長老，就是離那被殺的人最近的，都要在山谷中，在被折斷頸項的母牛犢以上洗手。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","他們要聲明，說：‘我們的手未曾流過這人的血，我們的眼也未曾看見這事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","耶和華啊，求你赦免你的子民以色列，就是你救贖的，不要使流無辜人的血的罪歸在你的子民以色列中間。’這樣，他們流人血的罪就得到赦免了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","如果你行耶和華看為正的事，就可以從你中間除掉流無辜人的血的罪了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","“你出去和仇敵作戰的時候，耶和華你的　神把他們交在你手裡，你就把他們擄了去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","如果你在被擄的人中看見了容貌美好的女子，就戀慕她，要娶她作妻子， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","那麼，你可以把她帶進你的家裡；她要剃頭修甲， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","脫去被擄時所穿的衣服，住在你家裡，為自己的父母哀哭一個月，然後你才可以親近她；你作她的丈夫，她作你的妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","如果將來你不喜歡她，就要讓她隨意離去，決不可為了錢把她出賣，也不可以她為奴，因為你已經污辱了她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","“如果人有兩個妻子，一個是他喜愛的，一個是他不喜愛的，兩個都給他生了兒子；但長子是他不喜愛的妻子生的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","到了他把所有的產業分給兒子承受的日子，他不可把他喜愛的妻子的兒子立為長子，排在他不喜愛的妻子的兒子以上，他才是長子； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","卻要承認他不喜愛的妻子的兒子為長子，把所有的產業分兩分給他，因為這兒子是他強壯有力的時候所生的頭生子，長子的權利本是屬於他的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","“如果人有忤逆倔強的兒子，不聽從父母的話；父母管教他以後，他還是不聽從； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","他的父母就要捉住他，把他帶到當地的城門，去見本城的長老， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","對本城的長老說：‘我們這個兒子忤逆倔強，不聽從我們的話，是個貪食好酒的人。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","全城的人就要用石頭打死他；這樣，你就把那惡從你們中間除掉。以色列眾人聽見了，就都懼怕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","“如果人犯了該死的罪，被處死以後，你就把他掛在木頭上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","他的屍體不可留在樹上過夜，必須在當日把他埋葬，因為被掛在木頭上的，是受　神咒詛的；這樣，你就不至於玷污耶和華你的　神賜給你作產業的地了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","“如果你看見你兄弟的牛或羊走迷了，你不可不理，總要把牠們牽回你的兄弟那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","如果你的兄弟離你很遠，或是你不認識他，你就要把牠牽到你家中，留在你那裡，等到你的兄弟來尋找牠，你就還給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","對他的驢，你要這樣行；對你的兄弟失去而被你找到的任何東西，你都要這樣行，不可不理。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","如果你看見你兄弟的驢或牛跌倒在路上，你不可不理，總要幫助他把牠們拉起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","“婦女不可穿男子的服裝；男子也不可穿婦人的衣服；因為這樣作的人，都是耶和華你的　神厭惡的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","“如果你在路上遇見鳥窩，或是在樹上，或是在地上；裡面有雛鳥，或是有蛋；母鳥伏在雛鳥身上，或在蛋上；你不可連母帶子一起取去； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","總要讓母鳥飛去，只可以取子；這樣你就可以得著好處，得享長壽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","“如果你建造新房屋，要在屋頂上作欄杆；免得有人從那裡跌下來，流血的罪就歸到你家。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","“不可把兩樣的種子撒在你的葡萄園裡，免得你所種的全部收成和葡萄園的出產，都要充公分別為聖歸給聖殿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","你不可用牛和驢一同耕地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","不可穿羊毛和細麻混合織成的布料。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","“你要在所披的外衣上，四邊做繸子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","“如果人娶妻，和她同房之後，就恨她， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","捏造可恥的事毀謗她，破壞她的名譽，說：‘我娶了這個女子，和她親近的時候，發現她沒有貞潔的憑據。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","那少女的父母就要把那少女的貞潔憑據拿出來，帶到城門去見本城的長老。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","少女的父親要對長老說：‘我把我的女兒給這人作妻子，他卻恨她， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","捏造可恥的事毀謗她，說：“我發現你的女兒沒有貞潔的憑據。”其實這就是我女兒的憑據。’於是，他們就把衣服鋪在那城的長老面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","那城的長老要把那人捉住，懲罰他， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","罰他一千一百四十克銀子，交給那少女的父親，因為他破壞了一個以色列處女的名譽；那少女仍要作他的妻子，終生不能休她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","但如果這事是真的，少女沒有貞潔的憑據， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","就要把那少女帶到她父家的門口，本城的人要用石頭把她打死，因為她在以色列中作了醜事，在她父家行了淫亂；這樣，你就把那惡從你們中間除去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","“如果發現有人和有夫之婦同寢，就要把姦夫淫婦二人都處死；這樣，你就把那惡從以色列中除掉了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","“如果有個少女，本來是處女，已經許配了人，有人在城裡遇見了她，和她同寢， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","你們就要把他們二人帶到當地的城門口，用石頭打死他們。那少女該死，是因為她雖在城裡，卻沒有呼叫；那男人該死，是因為他玷污了鄰舍的妻子；這樣，你就把那惡從你們中間除掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","如果有人在田間遇見了已經許配人的少女，拉住她，和她同寢，只要把那和她同寢的人處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","但你不可對付那少女，她並沒有該死的罪。這件事就像一個人忽然起來攻擊自己的鄰舍，你把他殺了一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","因為那人在田間遇見那少女，那已經許配人的少女呼叫了，卻沒有人救她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","“如果有人遇見一個少女，原是處女，還沒有許配過人，就抓住她，和她同寢，又被人發現， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","那和她同寢的人就要把五百七十克銀子給那少女的父親，那少女要歸作他的妻子，因為他玷污了她；他終生不能休她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","“人不可娶父親的妻子，也不可揭開父親的衣襟。”（本節在《馬索拉抄本》為23:1） ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","“睾丸受傷的，或生殖器被割除的，不可進耶和華的會。（本節在《馬索拉抄本》為23:2） ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","私生子不可進耶和華的會；他的後代直到第十代，也不可進耶和華的會。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","亞捫人或摩押人不可進耶和華的會；他們的後代直到第十代，也永遠不可進耶和華的會。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","因為你們出埃及的時候，他們沒有拿食物和水在路上迎接你們，又因為他們從兩河之間的亞蘭的毗奪雇了比珥的兒子巴蘭，來攻擊你，咒詛你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","但耶和華你的　神不願聽從巴蘭；耶和華你的　神使咒詛的話變為你的祝福，因為耶和華你的　神愛你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","你一生一世永不可尋求他們的平安和他們的福樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","“你不可厭惡以東人，因為他是你的兄弟；不可厭惡埃及人，因為你在他的地上作過寄居的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","他們所生的子孫到了第三代，就可以進耶和華的會。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","“你出兵安營攻打仇敵的時候，要謹守自己，遠避一切惡事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","“如果你們中間有人因為夜間偶然夢遺而不潔淨，就要出到營外去，不可進入營中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","到了黃昏的時候，他要用水洗澡；日落了，他才可以進入營中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","你在營外要有廁所，你可以出到那裡去便溺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","在你的器械中，要有一把鍬；你在外面便溺以後，可以用來鏟土，轉身把糞便掩蓋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","因為耶和華你的　神常在你的營中行走，要拯救你，要把你的仇敵交在你的面前；所以你的營要聖潔，免得他看見你那裡有污穢的東西，就離開你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","“如果一個奴僕離開了他的主人，逃到你那裡來，你不可把他送交他的主人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","他要在你中間和你同住，住在他自己選擇的地方，住在他喜歡的城市，你不可欺負他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","“以色列的女子中不可有廟妓，以色列的男子中不可有男廟妓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","妓女所得的酬金，或男妓所得的代價，你不可帶入耶和華你的　神的殿裡還任何的願，因為這兩樣都是耶和華你的　神厭惡的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","你借給你兄弟的銀錢、食物，或是任何可以生利的東西，都不可取利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","借給外族人，你倒可以取利；只是借給你的兄弟，你就不可取利；好使耶和華你的　神，在你要去得為業的地上，和你手裡所辦的一切事上，賜福給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","“如果你向耶和華你的　神許了願，就不可遲延還願，因為耶和華你的　神必向你追討，那時你就有罪了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","如果你不許願，你倒沒有罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","你嘴裡說出來的，你要謹守；你親口應許的甘心祭，就是你向耶和華你的　神許的願，你要實行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","“你進了你鄰舍的葡萄園，你可以隨意吃飽葡萄，只是不可裝在你的器皿裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","你進了你鄰舍的麥田，你可以用手摘麥穗，只是不可在你鄰舍的麥田裡揮動鐮刀。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","“人娶了妻子，得著她以後，如果發現她有醜事，以致不喜悅她，他就可以給她寫休書，交在她手裡，叫她離開夫家； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","她離開夫家以後，就可以去再嫁別人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","如果後夫又恨她，也給她寫休書，交在她手裡，叫她離開他的家；或者娶她為妻的後夫死了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","那麼，叫她離開的前夫，不可在她受了污辱以後，再娶她為妻，因為這在耶和華面前是可厭可惡的事；你不可使耶和華你的　神賜給你作產業的土地蒙受罪污。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","“如果人娶了新婦，不可從軍出征，也不可派他擔任甚麼公務，他可以在家賦閒一年，使他所娶的妻子快樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","“不可拿人的磨，或是上磨石作抵押，因為這等於拿人的生命作抵押。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","“如果發現有人拐帶了以色列人的一個兄弟，把他當作奴隸看待，或是把他賣了，那拐帶人的就要處死；這樣，你就把那惡從你中間除掉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","“在大痲風的災病上，你要謹慎自己，照利未支派的祭司指教你們的一切，認真地謹守遵行；我怎樣吩咐了他們，你們就要怎樣謹守遵行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","你當記得你們出了埃及，在路上的時候，耶和華你的　神向米利暗所行的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","“如果你借東西給你的鄰舍，不論所借的是甚麼，總不可走進他的家裡去拿抵押。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","你要站在外面，等那向你借貸的人把抵押拿出來給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","他若是個窮人，你不可留他的抵押過夜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","到了日落的時候，你要把抵押品還給他，好使他可以用自己的衣服蓋著睡覺，他就給你祝福，這在耶和華你的　神面前，就算是你的義了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","“困苦貧窮的雇工，無論是你的兄弟，或是寄居在你的地上你的城裡的，你都不可欺壓他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","你要當日給他工錢，不可等到日落，因為他貧窮，把心放在工錢上，免得他對你不滿而呼求耶和華，你就有罪了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","“不可因兒子的罪處死父親，也不可因父親的罪處死兒子；各人要因自己的罪被處死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","“你不可向寄居的和孤兒屈枉正直，也不可拿寡婦的衣服作抵押。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","你要記住你在埃及作過奴僕，耶和華你的　神把你從那裡救贖出來；所以我吩咐你要遵行這話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","“你在田間收割莊稼的時候，如果遺留一捆在田裡，就不可再回去拾取，要留給寄居的、孤兒和寡婦；好使耶和華你的　神，在你手裡所辦的一切事上，賜福給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","你打橄欖樹以後，枝上剩下的不可再打，要留給寄居的、孤兒和寡婦。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","你收取葡萄園的葡萄以後，剩下的不可再摘，要留給寄居的、孤兒和寡婦。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","你要記住你在埃及作過奴僕，所以我吩咐你遵行這話。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","“如果人與人之間有爭訟的事，就上法庭去；審判官審判他們的時候，要定義人有理，定惡人有罪； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","如果有罪的人應受責打，審判官就要叫他伏下，當面按著他的罪，照著數目責打他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","只可打他四十下，不可再多；恐怕你多打了他，過了這數目，你的兄弟就在你眼前受辱了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","“牛在踹穀的時候，不可籠住牠的嘴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","“兄弟住在一起，他們中間如果有一個死了，沒有留下兒子，死者的妻子就不可出嫁外人；她丈夫的兄弟要向她盡兄弟的本分，娶她為妻，和她同房。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","她所生的長子要歸亡兄的名下，免得他的名字從以色列中被塗抹了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","那人如果不喜歡娶他兄弟的妻子，他兄弟的妻子就要到城門去見長老，說：‘我丈夫的兄弟不肯在以色列中為自己的哥哥立名，不肯對我盡兄弟的本分。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","本城的長老就要把那人叫來，對他說明；如果他堅持說：‘我不樂意娶她’， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","他哥哥的妻子就要當著長老的面前，走到那人跟前，脫去他腳上的鞋子，吐唾沫在他的臉上，說：‘那不為自己哥哥建立家室的，人人都要這樣對待他。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","從此，在以色列中他的名字必稱為‘脫鞋者之家’。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","“有兩個人在一起打鬥，如果其中一人的妻子走前來，要救她的丈夫脫離那打她丈夫的人的手，就伸手抓住那人的下體， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","你就要砍掉那婦人的手；你的眼不可顧惜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","“你袋裡不可有兩樣不同的法碼，一大一小； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","你家裡不可有兩樣不同的升斗，一大一小。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","你要有準確公正的法碼，你要有準確公正的升斗，好使你在耶和華你的　神賜給你的地上，得享長壽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","因為所有行這些事的，就是行不義的事的，都是耶和華你的　神厭惡的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","“你要記住你們出了埃及以後，亞瑪力人在路上怎樣對待你； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","怎樣在路上遇見了你，趁你疲倦困乏的時候，攻擊你後方所有軟弱無力的人，並不敬畏　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","所以耶和華你的　神使你脫離四圍所有的仇敵，在耶和華你的　神賜給你作產業的地上，得享太平的時候，你務要把亞瑪力這名號從天下塗抹，不可忘記。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","“將來，你進了耶和華你的　神賜給你作產業的地，佔領那地，並且住在那裡以後， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","就要從耶和華你的　神賜給你的地上，把地上各種初熟果子取些來，放在籃子裡，到耶和華你的　神選擇立為他名的居所的地方， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","去見當時作祭司的，對他說：‘我今日向耶和華你的　神表明，我已經來到了耶和華向我們的列祖起誓應許要賜給我們的地。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","祭司就要從你手裡接過籃子，放在耶和華你的　神的祭壇前面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","然後你要在耶和華你的　神面前說：‘我的祖先原是個飄泊流亡的亞蘭人；他下到埃及，在那裡寄居；他人數稀少，在那裡卻成了又大又強、人數又多的國。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","埃及人惡待我們，苦害我們，把苦工加在我們身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","於是我們向耶和華我們列祖的　神呼求，耶和華聽見了我們的聲音，看見了我們所受的困苦、勞碌和壓迫， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","耶和華就用大能的手和伸出來的膀臂，以及大而可畏的事、神蹟和奇事，把我們從埃及領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","把我們領進這地方，把這地賜給我們，就是流奶與蜜的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","耶和華啊，現在你看，我把你賜給我的土地的初熟果子帶了來。’隨後你要把籃子放在耶和華你的　神面前，在耶和華你的　神面前下拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","你和利未人，以及住在你們中間的外族人，都要因耶和華你的　神賜給你和你的家的一切好處而歡樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","“每逢第三年，就是十分獻一之年，你把一切出產的十分之一完全取出，分給利未人、寄居的和孤兒寡婦，使他們在你的城中吃飽了以後， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","你就要在耶和華你的　神面前說：‘我已經把聖物從家裡除去了，也分給了利未人、寄居的和孤兒寡婦，都照著你吩咐我的一切誡命；你的命令我都沒有違背，也沒有忘記。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","我守喪的時候，沒有吃這聖物；我不潔的時候，沒有把它除去，也沒有把它送給死人；我聽從了耶和華我的　神的話，都照著你吩咐我的一切行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","求你從天上你聖潔的居所垂看，賜福給你的子民以色列，和你賜給我們的土地，就是你向我們的列祖起誓應許的那流奶與蜜的地。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","“耶和華你的　神今日吩咐你遵行這些律例和典章，所以你要一心一意謹守遵行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","你今日承認了耶和華是你的　神，要遵行他的道，謹守他的律例、誡命和典章，聽從他的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","耶和華今日照著他應許你的，也承認了你是他珍貴的子民，使你謹守他的一切誡命； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","他又使你得稱讚、名譽和尊貴，超過他所造的列國之上，並且照著他說過的使你作聖潔的子民，歸於耶和華你的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","摩西和以色列的長老吩咐人民：“你們要遵守我今日吩咐你們的一切誡命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","將來你們過約旦河，到了耶和華你的　神賜給你的土地的那一天，你要立起幾塊大石頭，墁上石灰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","你過河以後，要把這律法的一切話都寫在石頭上面，使你可以進入耶和華你的　神賜給你的土地，就是流奶與蜜的地，正如耶和華你列祖的　神應許你的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","所以，將來你們過了約旦河，就要在以巴路山上，照著我今日吩咐你們的，把這些石頭立起來，墁上石灰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","在那裡你要為耶和華你的　神築一座石壇，在石頭上你不可動鐵器。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","你要用沒有鑿過的整塊石頭築耶和華你的　神的壇；在壇上你要獻上燔祭給耶和華你的　神； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","又要獻上平安祭，並且在那裡吃喝；也要在耶和華你的　神面前歡樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","你要把這律法的一切話，都清清楚楚寫在石頭上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","摩西和利未支派的祭司對以色列眾人說：“以色列啊，要默默靜聽；今日你已經成為耶和華你的　神的子民了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","所以你要聽從耶和華你的　神的話，遵行他的誡命和律例，就是我今日吩咐你的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","那天摩西又吩咐人民： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","“你們過了約旦河以後，西緬、利未、猶大、以薩迦、約瑟、便雅憫等支派的人，要站在基利心山上為人民祝福； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","流本、迦得、亞設、西布倫、但、拿弗他利等支派的人，要站在以巴路山上宣布咒詛的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","利未人要向以色列眾人大聲說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","“‘製造耶和華厭惡的雕像或鑄像，工人手中做的，並且在暗處設立的，那人必受咒詛。’眾民都要應聲說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“‘輕慢父母的，必受咒詛。’眾民都要說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“‘移動鄰舍地界的，必受咒詛。’眾民都要說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“‘使瞎子走錯路的，必受咒詛。’眾民都要說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“‘對寄居的和孤兒寡婦屈枉正直的，必受咒詛。’眾民都要說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“‘和父親的妻子同寢的，必受咒詛，因為他揭開了他父親的衣襟。’眾民都要說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“‘和任何野獸同寢的，必受咒詛。’眾民都要說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“‘和同父異母，或是同母異父的姊妹同寢的，必受咒詛。’眾民都要說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“‘和岳母同寢的，必受咒詛。’眾民都要說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“‘暗中殺害鄰舍的，必受咒詛。’眾民都要說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“‘接受賄賂殺人，流無辜人的血的，必受咒詛。’眾民都要說：‘阿們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","“‘不堅守這律法的話去遵行的，必受咒詛。’眾民都要說：‘阿們。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","“如果你實在聽從耶和華你的　神的話，謹守遵行他的一切誡命，就是我今日吩咐你的，耶和華你的　神必使你超過地上所有的民族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","如果你聽從耶和華你的　神的話，以下這一切福氣必臨到你身上，必把你追上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","你在城裡必蒙福，在田間也必蒙福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","你身所生的、土地所出的、牲畜所出的、牛生殖的和羊所產的，都必蒙福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","你的籃子和你的摶麵盆，都必蒙福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","你出必蒙福，你入也必蒙福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","“那起來攻擊你的仇敵，耶和華必使他們在你面前被擊敗；他們從一條路出來攻擊你，必在你面前從七條路逃跑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","在你的倉房裡和你手所辦的一切事上，耶和華必吩咐福氣臨到你；在耶和華你的　神賜給你的地上，他必賜福給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","如果你謹守耶和華你的　神的誡命，遵守他的道路，耶和華就必照著他向你起過的誓，立你作他自己的聖民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","地上萬民見你被稱為耶和華名下的人，就必懼怕你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","在耶和華向你列祖起誓應許要賜給你的土地上，他必使你身上所生的、牲畜所產的、土地所出的，都豐富有餘。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","耶和華必為你打開他天上的寶庫，按時降雨在你的地上，在你手裡所作的一切事上賜福給你；你要借貸給許多國的民，卻不會向人借貸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","耶和華必使你作頭不作尾，居上不居下，只要你聽從耶和華你的　神的誡命，就是我今日吩咐你的，謹守遵行； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","不可偏離我今日吩咐你的一切話，不偏左也不偏右，以致去隨從和事奉別的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","“但是，如果你不聽從耶和華你　神的話，不謹守遵行我今日吩咐你的一切誡命和律例，以下這一切咒詛就必臨到你身上，把你趕上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","你在城裡必受咒詛，在田間也必受咒詛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","你的籃子和摶麵盆都必受咒詛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","你身所生的、土地所出的、牛生殖的和羊所產的，都必受咒詛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","你出必受咒詛，你入也必受咒詛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","“耶和華必在你手所作的一切事上，使咒詛、紛亂和責備臨到你身上，直到你被消滅，速速地滅亡，因為你行惡，離棄了我的緣故。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","耶和華必使瘟疫隨著你，直到他把你從你進去得為業的地上滅絕了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","耶和華必用癆病、熱病、炎症、瘧疾、乾旱、旱風和霉爛打擊你；它們必追趕你，直到你滅亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","你頭上的天必變成銅，你腳下的地必變成鐵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","耶和華必使你地上的雨水變為飛沙塵土，從天上下到你身上，直到你被消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","耶和華必使你在仇敵面前被擊敗；你從一條路出去攻擊他們，必在他們面前從七條路逃跑；你必成為天下萬國驚駭的對象。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","你的屍體必成為空中的飛鳥和地上的走獸的食物；必沒有人來把牠們嚇走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","“耶和華必用埃及人的瘡、痔漏、牛皮癬、紅疹打擊你，這是你不能醫治的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","耶和華必用癲狂、眼瞎、心亂打擊你； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","你必在中午的時候摸索，好像瞎子在黑暗中摸索一樣；你的道路必不亨通；你必日日受欺壓、被搶奪，沒有人拯救你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","你和女子訂了婚，別人必和她同寢；你建造房屋，必不得住在裡面；你栽種葡萄園，必不得享用它的果子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","你的牛在你眼前被宰了，你必不得吃牠的肉；你的驢從你面前被搶奪了，必不歸還給你；你的羊群交給了你的仇敵，必沒有人拯救。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","你的兒女必被交給別國的民，你必親眼看見，日日為他們焦慮；你必無能為力。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","你土地的出產和你勞碌得來的一切，都必被你不認識的民族吃盡；你必常常受壓迫和壓制； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","你因親眼看見的，必要瘋狂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","耶和華必用毒瘡打擊你的雙膝和雙腿，由踵至頂，使你無法醫治。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","耶和華必把你和你所立統治你的君王，領到你和你的列祖都不認識的國那裡去；在那裡你必事奉別的神，就是木頭石頭所做的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","在耶和華要領你去的各民族中，你必成為使人驚駭、使人嘲笑和諷刺的對象。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","“你帶到田間的種子雖然很多，但收進來的卻很少，因為蝗蟲把它吞吃了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","你栽種修理葡萄園，必不得收葡萄，也不得喝葡萄酒，因為蟲子把它吃盡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","你全境必有橄欖樹，卻沒有油抹身，因為你的橄欖還未成熟就脫落了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","你必生兒養女，卻不是屬你的，因為他們都要被擄去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","你所有的樹木和你土地的出產，都必被害蟲吃光。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","住在你中間的寄居者必漸漸高升，比你高而又高；你必漸漸下降，低而又低。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","他要借給你，你卻不能借給他；他必作頭，你必作尾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","這一切咒詛必臨到你，必追趕你，必把你追上，直到你被消滅，因為你不聽從耶和華你的　神的話，沒有遵守他吩咐你的誡命和律例。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","這些咒詛必在你和你的後裔身上成為異蹟和奇事，直到永遠。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","因為你在這樣富足的時候，沒有以歡樂和高興的心來事奉耶和華你的　神， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","所以你必在飢餓、乾渴、赤身露體和缺乏之中，去事奉耶和華派來攻擊你的仇敵；他必把鐵軛放在你的頸項上，直到把你消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","“耶和華必從遠方，從地極把一國的民帶來，像鷹一般飛來攻擊你；這民的語言你不會聽； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","這民臉無羞恥，不顧老年人的情面，也不恩待青年人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","他們必吞吃你牲畜所生的和你土地所產的，直到把你消滅；必不給你留下五穀、新酒和油、幼小的牛，以及肥嫩的羊，直到使你滅亡為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","他們必把你圍困在你的各城裡，直到在你的全境內你所倚靠高大和堅固的城牆都被攻陷；他們必把你圍困在耶和華你的　神賜給你的全地的各城裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","你在仇敵圍困和窘迫你的時候，要吃你身所生的，就是吃耶和華你的　神賜給你的兒女的肉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","你們中間溫柔嫩弱的男人，必敵視自己的兄弟、懷中的妻子和餘剩的兒女； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","甚至在你的仇敵圍困和窘迫你在各城裡的時候，他要吃自己兒女的肉，卻不肯分給他們任何人，因為他沒有甚麼剩下的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","你們中間溫柔嬌嫩的婦人，素來因為溫柔嬌嫩不肯把腳掌踏在地上，現在必敵視自己懷中的丈夫和自己的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","她暗中把自己兩腿之間出來的嬰孩，和自己生的兒女吃掉，因為在你的仇敵圍困和窘迫你在各城裡的時候，她甚麼都沒有了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","“如果你不謹守遵行寫在這書上的這律法的一切話，不敬畏這榮耀和可畏的名，就是耶和華你的　神， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","耶和華就必使你和你的後裔遭受奇災，就是大而長久的災，毒而長久的病。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","他必使你懼怕的埃及人的各種疾病都臨到你身上，緊緊地纏著你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","又把這律法書上沒有記載的各樣災病，都降在你身上，直到你被消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","你們以前雖然像天上的星那麼多，現在剩下的人數卻寥寥可數，因為你不聽從耶和華你的　神的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","先前耶和華怎樣喜歡你們得好處，使你們人數眾多，將來也必怎樣喜歡你們滅亡，把你們消滅；你們必從要進去得為業的地上被拔除。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","耶和華必使你分散在萬民中，從地的這邊到地的那邊；在那裡你要事奉你和你的列祖不認識的別的神，就是木頭和石頭做的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","在那些國中，你必不得安息，也沒有腳掌歇息的地方；耶和華卻必使你在那裡心中發顫，眼目憔悴，精神頹廢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","你未來的生命必懸而不定；你必晝夜恐懼，生命難保。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","因你心裡的懼怕驚恐和你眼中看見的景象，早晨你必說：‘但願現在是晚上！’晚上你必說：‘但願現在是早晨！’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","耶和華必用船把你送回埃及去，走我曾經告訴你，你不得再見的那條路；在那裡你們必賣身給你的仇敵作奴僕和作婢女，卻沒有人買。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","這些是耶和華在摩押地，吩咐摩西與以色列人所立的約的話，是耶和華和他們在何烈山所立的約以外的。（本節在《馬索拉抄本》為28:69） ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","摩西把以色列眾人召了來，對他們說：“耶和華在埃及地，在你們面前，向法老和他的眾臣僕，以及他的全國所行的一切，你們都看見了，（本節在《馬索拉抄本》為29:1） ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","就是你親眼見過的大試驗和神蹟，以及那些大奇事； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","但是直到今日，耶和華還沒有給你們一顆能明白的心，能看見的眼睛，能聽見的耳朵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","我在曠野四十年之久領導你們；你們身上的衣服沒有穿破，腳上的鞋也沒有穿壞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","飯你們沒有吃，清酒或烈酒你們沒有喝，這是要使你們知道耶和華是你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","你們來到了這地方，希實本王西宏和巴珊王噩就出來，與我們交戰，我們擊敗了他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","奪取了他們的地，分給流本人、迦得人和瑪拿西半個支派作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","所以你們要謹守這約的話，並且遵行，好使你們在所行的一切事上都亨通。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","“今日你們全都站在耶和華你們的　神面前；你們的首領、族長、長老、官長和以色列所有的男子， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","你們的小孩、妻子和在你營中的寄居者，以及為你們劈柴挑水的人，都站在耶和華你們的　神面前， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","為要叫你遵守耶和華你的　神今日與你所立的約，和他向你所起的誓； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","這樣，他今日可以立你作他的子民，他可以作你的　神，正如他曾經對你說過的，又對你的列祖亞伯拉罕、以撒、雅各起過誓的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","“我不但與你們立這約，起這誓； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","而且也與那些今日和我們在這裡，一同站在耶和華我們的　神面前的人，以及那些今日不與我們同在這裡的人立這約，起這誓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","你們清楚知道我們怎樣在埃及地住過，怎樣從列國中經過； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","你們也見過他們的可憎之物，和他們那裡那些木、石、金、銀的偶像。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","恐怕你們中間有男人或女人，家族或支派，今日心裡偏離了耶和華我們的　神，去事奉那些國的神，又恐怕你們中間有惡根，生出毒草和苦堇來； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","如果人聽了這咒詛的話，心裡仍然自誇說：‘我雖然照著頑梗的心而行，使好人和惡人一起滅亡，我還有平安。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","耶和華必不肯饒恕他；耶和華的怒氣和憤恨必向這人發作，這書上所寫的一切咒詛都要降在那人身上，耶和華也必從天下塗抹他的名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","耶和華必照著寫在這律法書上的約的一切咒詛，把他從以色列眾支派中分別出來，使他遭受災禍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","“後代的人，就是你們以後興起來的子孫，和從遠方來的外族人，看見了這地的災難和耶和華降與這地的疾病， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","又看見了遍地有硫磺，有鹽鹵，有火燒，沒有播種，沒有出產，寸草不生，好像耶和華在烈怒和怒火中毀滅的所多瑪、蛾摩拉、押瑪、洗扁一樣， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","看見了這些的人和萬國的人都要問：‘耶和華為甚麼向這地這樣行呢？為甚麼大發烈怒呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","人就必回答：‘是因為他們離棄了耶和華他們列祖的　神的約，就是耶和華把他們從埃及地領出來的時候，與他們所立的； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","去事奉別的神，向他們叩拜，就是他們不認識的神，也是耶和華沒有給他們指定要拜的神； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","所以耶和華向這地大發烈怒，把這書上所寫的一切咒詛都降在這地上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","於是耶和華在烈怒、忿怒和大怒中，把他們從他們的地土拔出來，丟在別的地方，像今天一樣。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","“奧祕的事，是屬於耶和華我們的　神的，只有顯露的事，是永遠屬於我們和我們子孫的，好叫我們遵行這律法上的一切話。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","“當這一切事，就是我擺在你面前的祝福和咒詛，都臨到你身上的時候，你在耶和華你的　神趕逐你去的萬國中，你心裡必回想這些話， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","你和你的子孫必一心一意歸向耶和華你的　神，照著我今日吩咐你的一切聽從他的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","那時，耶和華你的　神就必使你這被擄的人回歸，他必憐憫你；耶和華你的　神必從你被分散到的萬民中，把你再召集回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","你被趕逐的人，就是在天涯海角，耶和華你的　神也必從那裡把你召集回來，從那裡把你帶回。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","耶和華你的　神必領你進入你列祖所得之地，使你可以得著這地；他必善待你，他也必使你的人數增多，勝過你的列祖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","耶和華你的　神必把你心裡和你後裔心裡的污穢除掉，要你一心一意愛耶和華你的　神，使你可以存活。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","耶和華你的　神必把這一切咒詛，加在你的仇敵和恨惡你、逼迫你的人身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","你卻要再聽從耶和華的話，遵行他的一切誡命，就是我今日吩咐你的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","耶和華你的　神必使你手裡所辦的一切事、你身所生的、牲畜所出的、地土所產的，都豐盛有餘，因為耶和華必再喜悅你，使你得福，像從前喜悅你的列祖一樣； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","只要你聽從耶和華你的　神的話，謹守這律法書上所寫的誡命和律例；只要你一心一意回轉歸向耶和華你的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","“其實我今日吩咐你的這誡命，對你並不太難，離你也不太遠。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","這誡命不是在天上，以致你說：‘誰替我們上到天上去，為我們取下來，使我們聽見，就可以遵行呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","也不是在海外，以致你說：‘誰替我們過海去，為我們取回來，使我們聽見，就可以遵行呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","其實這話離你很近，就在你口裡，也在你心裡，使你可以遵行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“你看，我今日把生命和福樂，死亡與災禍，都擺在你的面前了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","如果你聽從耶和華你的　神的誡命，就是我今日吩咐你的；愛耶和華你的　神，行他的道路，謹守他的誡命、律例、典章，使你可以存活，人數增多，耶和華你的　神就必在你要進去得為業的地上賜福給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","但是，如果你的心偏離了，不肯聽從，卻被人勾引，去敬拜和事奉別的神； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","我今日鄭重地告訴你們，你們必要滅亡；在你過約旦河，進去得為業的地上，你的年日必不長久。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","我今日呼天喚地向你們作證，我把生與死，福與禍，都擺在你面前了；所以你要選擇生命，好讓你和你的後裔都可以活著， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","愛耶和華你的　神，聽從他的話，緊靠他，因為那就是你的生命，你的長壽；這樣，你才能在耶和華向你的列祖亞伯拉罕、以撒、雅各起誓應許要賜給他們的地上居住。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","摩西又把這些話告訴以色列眾人， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","對他們說：“我現今一百二十歲，不能再照常出入了；耶和華也曾對我說：你必不得過這約旦河。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","耶和華你的　神要親自領你們過去，從你們面前消滅這些國的民，使你們得著他們的地，照著耶和華說過的，約書亞要親自領你們過去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","耶和華對待他們，必好像從前對待他消滅的亞摩利人的兩個王西宏和噩，以及他們的國一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","耶和華必把他們交給你們，你們照著我吩咐你們的一切命令對待他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","你們要堅強勇敢；不要害怕，也不要因他們畏懼，因為耶和華你的　神與你同去；他決不撇下你，也不離棄你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","摩西把約書亞召了來，在以色列眾人面前對他說：“你要堅強勇敢，因為你要和這人民一同進入耶和華向他們的列祖起誓，應許要賜給他們的地；你也要使他們得著那地為業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","耶和華親自在你前頭行，與你同在；他決不撇下你，也不離棄你；你不要害怕，也不要驚慌。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","摩西把這律法寫好了，就交給抬耶和華約櫃的利未支派的祭司子孫，和以色列的眾長老。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","摩西吩咐他們：“每逢七年的最後一年，就是在豁免年的定期，住棚節期間， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","以色列眾人來到耶和華你的　神選擇的地方朝見他的時候，你要在以色列眾人面前把這律法宣讀給他們聽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","你要召集人民、男人、女人、孩子，以及你城裡的寄居者，叫他們可以聽見，叫他們可以學習，好敬畏耶和華你們的　神，謹守遵行這律法的一切話， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","也叫他們還不認識這律法的兒女可以聽見，使他們在你們過約旦河去得為業的地上生活的時候，一生學習敬畏耶和華你們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","耶和華對摩西說：“看哪，你的死期臨近了；你要把約書亞召來，你們二人要站在會幕裡，我好吩咐他。”於是摩西和約書亞前去，一同站在會幕裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","耶和華在會幕裡，在雲柱中顯現，這雲柱停在會幕的門口上面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","耶和華對摩西說：“看哪，你快要和你的列祖長眠了；這人民要起來，在他們所要去的地方，在那地的人中，與外族人的神行邪淫，離棄我，破壞我與他們所立的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","到了那日，我必向他們大發烈怒，離棄他們，掩面不顧他們，他們就必被吞滅，並且遭遇很多災禍和患難。到了那日，他們必說：‘我們遭遇這些災禍，不是因為我們的　神不在我們中間嗎？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","到了那日，因為他們偏向了別的神，和所作的一切惡事，我必掩面不顧他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","所以，現在你們要為自己寫下這首詩歌來，教導以色列人，放在他們口中，使這首詩歌成為我反對他們的見證。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","因為我把他們領進了我向他們的列祖起誓應許的地，就是流奶與蜜的地，他們在那裡吃飽了，發胖了，就必偏向別的神，事奉他們，藐視我，破壞我的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","他們遭遇許多災禍和患難的時候，這首詩歌就必在他們面前作證，因為這首詩歌必不會從他們後裔的口中忘記。其實，我還未領他們進入我起誓應許之地以先，他們今日心裡所懷的意念，我都知道了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","摩西就在那一天寫下了這首詩歌，教導以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","耶和華吩咐嫩的兒子約書亞，說：“你當堅強勇敢，因為你要領以色列人進我向他們起誓應許的地，我必與你同在。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","摩西把這律法的話寫在書上，直到寫完了， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","摩西就吩咐抬耶和華約櫃的利未人說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“你們要把這律法書，放在耶和華你們的　神的約櫃旁，可以在那裡作反對你們的見證， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","因為我知道你們的悖逆和硬頸。看哪，我今日還活著與你們同在的時候，你們尚且悖逆耶和華，何況我死了以後呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","你們要把你們各支派的眾長老和官長都召集到我這裡來，我好把這些話說給他們聽，並且呼天喚地對他們作證。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","因為我知道我死了以後，你們必完全敗壞，偏離我吩咐你們的道路；在末後的日子必有災禍臨到你們身上，因為你們必行耶和華看為惡的事，以你們手所作的事，惹他發怒。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","於是摩西把這首詩歌的話，都說給以色列的全體會眾聽，直到說完了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","“天哪，留心吧，我要說話；地啊，聆聽我口中的言語。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","我的教訓下降如雨，我的言語滴落如露，像細雨落在青草上，像甘霖降在蔬菜上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","因為我要宣告耶和華的名；你們要尊崇我們的　神的偉大。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","他是磐石，他的作為完全，因為他一切所行的全都公平；他是誠實無偽的　神，又公義，又正直。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","這世代向他行事敗壞，就不是他的兒女，滿有弊病，這實在是個乖僻彎曲的世代。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","愚昧無知的人民哪，你們這樣報答耶和華嗎？他不是你的父，不是把你買回來的嗎？他造了你，建立了你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","你要回想古時的日子，思念歷代以來的年月；問你的父親，他必告訴你；問你的長者，他們必對你說。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","至高者把地業賜給列國的時候，把人類分開的時候，就照著以色列子孫的數目，立定了萬民的境界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","但耶和華的分就是他的子民，他的產業就是雅各。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","耶和華在曠野之地遇見了他，在荒涼之地和野獸吼叫的荒野，遇見了他，就環繞他，看顧他，保護他，好像保護自己眼中的瞳人一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","又像老鷹攪動巢窩，飛翔在雛鷹之上，搧展翅膀，接取雛鷹，背在自己的兩翼之上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","耶和華獨自領導了他，並沒有外族人的神與他同在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","耶和華使他乘駕地的高處，得吃田間的土產；又使他從巖石中吸蜜，從堅固的磐石中取油。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","也吃牛酪和羊乳，羊羔的脂肪，巴珊的公牛和公山羊，以及上好的麥子；也喝了葡萄汁釀成的酒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","但耶書崙肥胖了，就踢跳，‘你肥胖了，你粗壯了，你飽滿了，’他離棄了造他的　神，輕看了救他的磐石。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","他們以外族人的神激動了　神的憤恨，以可憎之事惹起了他的怒氣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","他們獻祭給鬼魔（他們不是神），就是他們從來不認識的神，是近來新興的，是你們的列祖所不懼怕的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","你輕忽了生你的磐石，你忘記了產你的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","因為他的兒女激怒了　神，耶和華看見了，就棄絕了他們， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","說：‘我必掩面不顧他們，要看看他們的結局怎樣；因為他們是乖曲的一代，心裡沒有信實的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","他們以不是神的神激動了我的憤恨，以虛無之物惹動了我的怒氣；我也以不是子民的人激動他們的憤恨，以愚昧的國民惹動他們的怒氣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","因為在我的怒中有火燃燒起來，燒到陰間的深處，把大地和地的出產盡都吞滅，連山的根基也燒著了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","我要把災禍加在他們身上，把我的箭向他們射盡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","他們必因饑荒消瘦，被熱病和毒症消滅；我也要打發野獸用牙齒咬他們，和土中的蛇類用毒液害他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","外有刀劍，內有驚恐，使人喪亡，使少男少女，嬰孩和白髮老人，盡都喪亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","我原想：“我要把他們分散到各處，把他們的名號都從人間除滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","但我懼怕仇人激動我，恐怕敵人誤會了，又恐怕他們說：“是我們的手高舉了，並不是耶和華作了這一切事。”’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","因為他們是缺乏計謀的國，他們心中沒有見識。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","如果你們有智慧，就可以明白這事，認清自己將來的結局了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","如果不是他們的磐石把他們出賣了，如果不是耶和華把他們交出來，一人怎能追趕一千人，二人怎能使萬人逃跑呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","連我們的仇敵也自己斷定，他們的磐石不像我們的磐石。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","因為他們的葡萄樹，是所多瑪的葡萄樹所出的，是蛾摩拉的田地所生的；他們的葡萄是毒葡萄，每一掛都是苦的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","他們的酒是大蛇的毒液，是虺蛇的劇毒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","這不是貯藏在我這裡，封閉在我的寶庫中嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","等到他們失足的時候，我要伸冤報應；因為他們遭遇災難的日子近了，那預備要臨到他們身上的事，必快快臨到。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","耶和華要為自己的子民伸冤，為自己的僕人難過，因為耶和華看見他們的能力已經消逝，為奴的或自由的都沒有剩下一人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","他必說：‘他們的神在哪裡呢？他們投靠的磐石在哪裡呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","就是向來吃他們祭牲脂肪的，喝他們奠祭之酒的神在哪裡呢？讓他們興起來幫助你們吧，願他們保護你們吧！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","現在你們要知道，只有我是那一位，除我以外，並沒有別的神；我使人死，也使人活；我打傷，我也醫治；沒有人可以從我的手裡搶救出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","我向天舉手說：我活到永永遠遠； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","如果我磨亮了我的刀劍，如果我掌握了審判權，就必向我的仇敵伸冤，必向恨我的人報應。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","我要使我的箭飲血飲醉，就是被殺的人和被擄的人的血；我的刀劍要吃肉，就是吃仇敵長髮首領的肉。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","列國啊，你們當與耶和華的子民一同歡呼，因為他要伸他僕人流血的冤，他要向他的仇人報復，他要救贖他的地和他的子民。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","摩西和嫩的兒子約書亞前來，把這首詩歌的一切話都說給人民聽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","摩西向以色列眾人說完了這一切話， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","就對他們說：“我今日警告你們的一切話，你們都要放在心上，好吩咐你們的子孫謹守遵行這律法上的一切話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","因為這不是空洞、與你們無關重要的事，而是你們的生命；藉著這事，你們在過約旦河去得為業的地上，才可以日子長久。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","就在那一天，耶和華對摩西說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“你要上這亞巴琳山去，就是尼波山，在耶利哥對面的摩押地，觀看我賜給以色列人為業的迦南地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","你必死在你登上的山上，歸到你的族人那裡去，像你的哥哥亞倫死在何珥山上，歸到他的族人那裡去一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","因為你們在尋的曠野，在加低斯米利巴水邊，在以色列人中間悖逆我，在以色列人中間沒有尊我為聖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","我賜給以色列人的地，你可以從對面觀看，卻不得進去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","這是神人摩西，在死前給以色列人所祝的福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","他說：“耶和華從西奈而來，從西珥光照他們，從巴蘭山射出光輝，在千萬聖者中來臨，從他的右手有烈火的律法。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","他實在愛人民，他的眾聖者都在你的手裡；他們坐在你的腳前，各自領受你的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","摩西把律法吩咐我們，作為雅各會眾的基業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","人民的眾首領，以色列的各支派，一同會合的時候，耶和華就在耶書崙作王了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","願流本生存，不致死亡，願他的人數不致稀少。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","論到猶大，他這樣說：“耶和華啊，求你垂聽猶大的聲音，領他歸回自己的族人那裡；他曾用手為自己奮鬥，願你幫助他抵擋仇敵。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","論到利未，他說：“耶和華啊，願你的土明和烏陵屬於倚靠你的利未人，就是你在瑪撒試驗過的，在米利巴水邊與他們爭論過的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","利未人論到自己的父母說：‘我沒有看顧他們’；他不承認自己的兄弟，也不認識自己的兒女；因為他們謹守你的話，持守你的約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","他們要把你的典章教訓雅各，把你的律法教訓以色列；他們要把香焚在你面前，把全牲的燔祭獻在你的祭壇上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","耶和華啊，求你賜福他的能力，悅納他手中的作為；那些起來攻擊他和恨他的人，願你刺透他們的腰，使他們不能再起來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","論到便雅憫，他說：“耶和華所愛的，必在耶和華身邊安然居住；耶和華終日庇護他，也必住在他的兩肩之間。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","論到約瑟，他說：“願他的地蒙耶和華賜福，得著從天上而來的上好之物，以及蘊藏在地裡的泉水； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","得著從太陽而來的上好之物，每月所產的佳果； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","得著從太古之山而來的上品，從永遠之嶺而來的上好之物； ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","得著從地所出的上好之物，和其中所充滿的；得著那住在荊棘中的耶和華的恩寵；願這些都臨到約瑟的頭上，就是臨到那在兄弟中作王子的人的頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","他頭生的公牛大有威嚴；他的兩角是野牛的角，用來牴觸萬民，直到地極；這角是以法蓮的萬萬，那角是瑪拿西的千千。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","論到西布倫，他說：“西布倫啊，你出外的時候，要喜樂；以薩迦啊，你在帳棚裡的時候，也要喜樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","他們要把萬民召到山上來，在那裡要獻上公義的祭；因為他們要吸取海洋的豐富，沙土中埋藏著的寶藏。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","論到迦得，他說：“那使迦得擴張的，是應該稱頌的，迦得蹲下如母獅，他撕裂膀臂，連頭頂也撕裂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","他為自己選擇了頭一份，因為在那裡有指揮者的分存留著；他與人民的眾首領一同來，他施行耶和華的公義，以及與以色列有關的典章。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","論到但，他說：“但是隻幼獅，從巴珊跳出來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","論到拿弗他利，他說：“拿弗他利啊，你飽受恩寵，滿得耶和華的福，可以取得西方和南方為業。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","論到亞設，他說：“願亞設蒙福，勝過眾子，願他得兄弟的喜悅；願他把腳蘸在油中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","你的門閂是銅的，是鐵的，你的日子怎樣，你的力量也必怎樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","沒有人像耶書崙的　神，為了幫助你，他乘駕諸天，在他的威嚴中，他騰空行雲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","亙古的　神是你的居所；他永久的膀臂在你以下。他把仇敵從你面前趕出去，他發令說：‘毀滅吧！’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","所以以色列可以安然居住，雅各的本源，獨處在產五穀新酒之地；他的天也滴下甘露。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","以色列啊，你是有福的；有誰像你呢？你這蒙耶和華拯救的子民，他是幫助你的盾牌，他是你威嚴的刀劍。你的仇敵必向你屈服；你必踐踏他們的背脊。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","摩西從摩押平原上了尼波山，就是上了耶利哥對面的毗斯迦山頂。耶和華把全地指給他看，就是把基列直到但， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","拿弗他利全地，以法蓮和瑪拿西之地，猶大全地，直到西海， ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","南地和那平原，就是棕樹城耶利哥的盆地，直到瑣珥，都指給他看。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","耶和華對他說：“這就是我曾經向亞伯拉罕、以撒、雅各起誓應許之地，說：‘我要把這地賜給你的後裔。’現在我讓你親眼看見了，可是你不能過到那邊去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","於是耶和華的僕人摩西，照著耶和華所說的，死在摩押地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","耶和華把他埋葬在摩押地，伯．毗珥對面的山谷裡，只是直到今日還沒有人知道埋葬他的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","摩西死的時候，已經一百二十歲；他的眼睛沒有昏花，他的精力也沒有衰退。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","以色列人在摩押平原為摩西哀哭了三十日；然後為摩西守喪哀哭的日子就滿了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","嫩的兒子約書亞，因為摩西曾經按手在他身上，就充滿了智慧的靈；以色列人就聽從他，照著耶和華吩咐摩西的去行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","以後在以色列中，再沒有興起一位先知像摩西一樣的；他是耶和華面對面所認識的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","耶和華差遣他在埃及地，向法老和他的一切臣僕，以及他的全地行了一切神蹟和奇事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","摩西又在以色列眾人眼前行了一切大能的事，和一切大而可畏的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","耶和華的僕人摩西死了以後，耶和華吩咐摩西的侍從，嫩的兒子約書亞，說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“我的僕人摩西死了；現在你要起來，和全體人民過這約旦河，到我現在要賜給他們以色列人的地去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","你們腳掌踏過的每一處地方，我都照著我應許摩西的賜給你們了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","從曠野和這黎巴嫩，直到大河，就是幼發拉底河，赫人的全地，以至大海日落的地方，就是你們的疆界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","你一生的日子必沒有一人能在你面前立得住；我怎樣與摩西同在，也必照樣與你同在；我決不離開你，也不離棄你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","你要堅強勇敢，因為你必使這人民得著我曾經向他們列祖起誓，要賜給他們的那地作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","你只要堅強，十分勇敢，謹守遵行我僕人摩西吩咐你的一切律法，不可偏離左右，好使你無論到哪裡去，都可以亨通。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","這律法書不可離開你的口，要晝夜默誦，好使你謹守遵行書中所記的一切；這樣，你的道路就必順利，你必一路亨通。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","我不是吩咐過你要堅強勇敢嗎？所以，你不要懼怕，也不要驚慌；因為你無論到哪裡去，耶和華你的　神必與你同在。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","於是約書亞吩咐人民的官長說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“你們要走遍營中，吩咐人民說：‘你們要預備糧食，因為三天之內，你們要過這約旦河，進去得耶和華你們的　神要賜給你們作產業的地。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","約書亞又對流本人、迦得人和瑪拿西半個支派的人說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“你們要記住耶和華的僕人摩西吩咐你們的話：‘耶和華你們的　神賜你們安息，他必把這地賜給你們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","你們的妻子、孩子和牲畜，都可以留在約旦河東邊、摩西賜給你們的地上；但你們所有英勇的戰士，都要拿起武器，在你們的兄弟前面過河去，幫助他們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","等到耶和華使你們的兄弟可以和你們一樣安居，同樣得著耶和華你們的　神要賜給他們作產業的地，你們才可以回到你們所得的地，以它作你們的產業，就是耶和華的僕人摩西在約旦河東邊日出之地賜給你們的地方。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","他們回答約書亞，說：“你吩咐我們的一切，我們都必遵行；無論你差派我們到哪裡去，我們都一定去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","我們從前怎樣凡事聽從摩西，現在也必照樣聽從你；唯願耶和華你的　神與你同在，像與摩西同在一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","無論誰違背你的話，不聽從你吩咐他的一切命令，那人必要處死。你只管堅強勇敢。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","於是，嫩的兒子約書亞從什亭祕密地差派兩個探子，對他們說：“你們去窺探那地和耶利哥。”二人去了，來到一個名叫喇合的妓女家中，就在那裡住宿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","有人向耶利哥王報告：“今夜從以色列人那裡有人進來，要窺探這地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","耶利哥王派人到喇合那裡，說：“把那些來到你這裡，進了你家中的人帶出來，因為他們來是要窺探全地的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","但那女人已把那兩個人藏起來，還這樣回答王：“不錯，那些人到過我這裡來，但是，我不知道他們是從哪裡來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","天黑、城門快要關的時候，那些人出去了；我不知道他們到哪裡去。你們快去追趕，必可以追上他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","其實她領他們上了屋頂，把他們藏在堆放在屋頂的麻秸裡面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","那些人就沿著往約旦河的路上追趕他們，直到渡口；追趕的人一出城，城門就關上了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","兩個探子還沒有躺下睡覺，那女人就上屋頂到他們那裡去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","對他們二人說：“我知道耶和華已經把這地賜給你們了，你們使我們十分害怕，這地所有的居民都在你們面前膽戰心驚。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","因為我們聽見你們從埃及出來的時候，耶和華怎樣使紅海的水在你們面前乾了，以及你們怎樣對待約旦河東亞摩利人的兩個王西宏和噩，把他們完全消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","我們聽見了，就都心裡驚怕；沒有一人再有勇氣在你們面前站立；因為耶和華你們的　神是天上、也是地上的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","現在求你們指著耶和華向我起誓：我既然恩待了你們，你們也要恩待我的父家，並且給我一個確實的憑據， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","放過我的父母、兄弟姊妹和他們所有的一切，救我們的命不致死亡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","兩個探子就對她說：“如果你不洩漏我們這次行動，我們願以性命作你們的保證；耶和華把這地賜給我們的時候，我們必定以慈愛和誠實待你們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","於是，那女人用繩子把二人從窗戶縋下去，因為她的房屋是在城牆上，她就住在城牆上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","她對他們二人說：“你們要到山上去，免得追趕的人遇上你們；你們要在那裡躲藏三天，等追趕的人回城，然後你們才可以走你們的路。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","他們二人對她說：“如果你不遵照我們的話行，你叫我們起的誓就與我們無關了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","你要留意，我們再到這地方的時候，你要把這條朱紅色線繫在你縋我們下去的窗戶上；你也要把你的父母、兄弟和你父的全家，都聚集在你的屋裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","任何人走出你家門，到外面去的，他的血就必歸到他自己的頭上，與我們無關；任何人同你在屋裡的，如果有人下手加害他，他的血就歸到我們頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","如果你洩漏了我們這次的行動，那麼，你叫我們起的誓就與我們無關了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","那女人回答：“照你們的話，就這樣吧。”於是打發他們二人走了。他們走了以後，她就把朱紅色線繫在窗戶上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","二人離去，上到山上，在那裡住了三天，等追趕的人回城去了；追趕的人一路搜尋他們，卻找不著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","二人於是下山回去，過了約旦河，回到嫩的兒子約書亞那裡，把他們遭遇的一切事向他報告。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","他們又對約書亞說：“耶和華真的把那地全交在我們手裡了；那地所有的居民都在我們面前膽戰心驚。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","約書亞清早起來，和全體以色列人從什亭出發，來到約旦河，在那裡住宿，等候過河。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","過了三天，官長走遍營中， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","吩咐人民說：“你們看見耶和華你們的　神的約櫃，又看見抬約櫃的利未支派的祭司的時候，就要從你們所住的地方出發，跟在約櫃後面走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","只是你們和約櫃之間應有一段距離，相隔約一公里，不可走近約櫃，好使你們知道你們應走的路，因為這條路你們以前沒有走過。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","約書亞對人民說：“你們要自潔，因為明天耶和華要在你們中間行奇事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","約書亞又吩咐祭司說：“你們要抬起約櫃，在人民前面過河去。”於是他們抬起約櫃，走在人民的前面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","耶和華對約書亞說：“今天起，我要使你在以色列眾人眼中成為尊大，這樣他們就知道我怎樣與摩西同在，也必照樣與你同在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","你要吩咐抬著約櫃的祭司說：‘你們到了約旦河水邊的時候，要站在約旦河中。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","約書亞對以色列人說：“你們走近這裡來，聆聽耶和華你們的　神的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","11","約書亞說：“看哪，全地之主的約櫃必在你們前面過約旦河，你們因此就知道永活的　神是在你們中間，他必把迦南人、赫人、希未人、比利洗人、革迦撒人、亞摩利人和耶布斯人，從你們面前驅逐出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","現在你們要從以色列眾支派中選十二個人，每支派一人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","抬全地之主耶和華約櫃的祭司的腳掌一踏進約旦河水裡，約旦河的水必被截斷，那從上游流下來的水必立起成壘。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","人民離開帳棚出發，要過約旦河的時候，抬約櫃的祭司在人民的前面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","抬約櫃的祭司來到約旦河，他們的腳碰到水邊的時候（原來約旦河水在收割的日子，常是漲過兩岸的）， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","水就停住了，那從上游流下來的水立起成壘，在很遠的地方，就是在撒拉但旁邊的亞當城那裡停住；那往下流入亞拉巴海，就是鹽海的水完全被截斷；於是人民就在耶利哥的對面過了河。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","抬耶和華約櫃的祭司在約旦河中間的乾地上站住，等以色列眾人都在乾地上走過去，直到全國的人都完全走過了約旦河為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","全國的人都完全過了約旦河以後，耶和華就吩咐約書亞說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“你要從人民中選十二個人，每支派一人， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","吩咐他們說：‘你們要從這裡，就是約旦河中間，祭司的腳所站的地方，取十二塊石頭，把它們帶過來，放在你們今夜要住宿的地方。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","於是，約書亞把他從以色列人中挑選的十二個人，每支派一人，都召了來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","約書亞對他們說：“你們走到約旦河中間，在耶和華你們的　神的約櫃前面，按著以色列十二支派的數目，每人拿起一塊石頭，扛在自己的肩上； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","這可以在你們中間作記號；如果日後你們的子孫問你們，說：‘這些石頭對你們有甚麼意思？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","你們就可以告訴他們：‘這是因為約旦河的水在耶和華的約櫃前被截斷了；約櫃過約旦河的時候，約旦河的水被截斷了。所以這些石頭要給以色列人作記念，直到永遠。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","以色列人就照著約書亞吩咐的行了；他們照著耶和華吩咐約書亞的，按著以色列十二支派的數目，從約旦河中間取了十二塊石頭，把它們帶過去，到他們住宿的地方，就放在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","約書亞又在約旦河中間，在抬約櫃的祭司的腳所站的地方，豎立十二塊石頭；那些石頭到今日還在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","抬約櫃的祭司站在約旦河中間，直到耶和華吩咐約書亞告訴人民的一切事，就是照著摩西吩咐約書亞的一切事，都辦完了，人民就急忙過去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","全體人民都過了河以後，耶和華的約櫃和祭司才在人民的面前過去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","流本人、迦得人和瑪拿西半個支派的人，都照著摩西吩咐他們的，拿起武器，在以色列人前面過河去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","他們約有四萬人，都裝備好，預備打仗，在耶和華面前走過去，來到耶利哥的平原，等候作戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","那一天耶和華使約書亞在以色列眾人眼中成為尊大；在他一生的日子，人民敬畏他，好像敬畏摩西一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","耶和華吩咐約書亞說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“吩咐抬約櫃的祭司從約旦河上來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","於是約書亞吩咐祭司說：“你們從約旦河上來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","抬耶和華約櫃的祭司從約旦河中間上來的時候，祭司的腳掌一提起來踏在乾地上，約旦河的水就流回原處，像以前一樣漲過兩岸。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","正月初十，人民從約旦河上來以後，就在吉甲，在耶利哥的東邊安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","約書亞把他們從約旦河取來的那十二塊石頭，豎立在吉甲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","約書亞對以色列人說：“如果日後你們的子孫問他們的父親說：‘這些石頭是甚麼意思？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","那時，你們就要告訴你們的子孫，說：‘以色列人曾經在乾地上走過了這約旦河。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","因為耶和華你們的　神在你們面前使約旦河的水乾了，直到你們都過了河，好像耶和華你們的　神從前對紅海所行的，在我們面前使紅海乾了，直到我們都過了河一樣； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","好使地上萬民都認識耶和華的手，是有能力的手，也要使你們永遠敬畏耶和華你們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","在約旦河西，亞摩利人的眾王和靠近海邊迦南人的眾王，聽見耶和華怎樣使約旦河的水在以色列人面前乾了，直到他們都過河去，他們都心裡驚怕，因以色列人的緣故，勇氣全失。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","那時，耶和華對約書亞說：“你要製造火石刀，第二次給以色列人行割禮。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","約書亞就製造了火石刀，在包皮山那裡給以色列人行了割禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","約書亞給以色列人行割禮的原因是這樣：所有從埃及出來的人民，就是所有能作戰的男丁，出埃及以後，都死在曠野的路上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","因為所有從埃及出來的人民都受過割禮；唯有從埃及出來以後，所有在曠野的路上出生的人民，都沒有受過割禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","以色列人在曠野走了四十年，直到全國的人，就是從埃及出來能作戰的男丁，都滅盡了，因為他們不聽耶和華的話；耶和華曾經向他們起誓，必不容許他們看見耶和華向他們列祖起誓要賜給我們的地，就是流奶與蜜的地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","他們的子孫，就是耶和華興起來代替他們的，約書亞給他們行了割禮；這些人是未受割禮的人，因為他們在路上沒有受過割禮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","全國的人受了割禮之後，都住在營中自己的地方，直到痊愈。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","耶和華對約書亞說：“我今日把埃及的恥辱從你們身上輥去了。”因此，那地方名叫吉甲（“吉甲”意即“輥”），直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","以色列人在吉甲安營；正月十四日晚上，他們在耶利哥的平原守逾越節。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","逾越節後次日，他們吃了那地的出產；就在那一天，吃了無酵餅和烘的穀物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","他們吃了那地的出產之後，第二天嗎哪就停止降下；以色列人不再有嗎哪了；那一年他們卻吃迦南地的出產。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","約書亞走近耶利哥的時候，抬頭觀看，看見一個人站在他對面，手裡拿著拔出來的刀。約書亞走到他那裡，對他說：“你是我們的人，還是我們的仇敵呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","那人回答：“不是的；我現在來是作耶和華軍隊的元帥。”約書亞就臉伏在地，向他下拜，對他說：“我主有甚麼事要吩咐僕人呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","耶和華軍隊的元帥對約書亞說：“把你腳上的鞋脫下來，因為你站的地方是聖地。”約書亞就照著行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","耶利哥的城門因以色列人的緣故，就緊緊地關閉，沒有人出入。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","耶和華對約書亞說：“看，我已經把耶利哥和耶利哥的王，以及英勇的戰士，都交在你的手中了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","你們所有能作戰的男丁要圍繞這城，一天圍繞一次，六天都要這樣行； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","並派七個祭司拿著七個羊角，走在約櫃的前面；到第七天，你們要繞城七次，祭司也要吹角。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","當羊角吹起長號，你們聽見角聲的時候，全體人民要大聲呼喊，那時城牆就必塌陷；你們各人要向前直衝。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","於是嫩的兒子約書亞把祭司召了來，對他們說：“你們要抬起約櫃；並派七個祭司拿著七個羊角，走在耶和華約櫃的前面。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","他又對人民說：“你們前去繞城吧，拿武器的人要走在耶和華約櫃的前面。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","約書亞吩咐人民以後，七個祭司拿著七個羊角，走在耶和華的前面，並且吹角，耶和華的約櫃在他們後面跟著走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","拿武器的人走在吹角的祭司前面，在約櫃後面也有防衛的隊伍跟著走，祭司一面走，一面吹角。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","約書亞吩咐人民說：“你們不可呼喊，不可讓人聽見你們的聲音，連一句話也不可出口，等到我吩咐你們‘呼喊’的那天，你們才可以呼喊。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","這樣，耶和華的約櫃繞城而行，圍繞了一次，眾人就回到營中，在營裡住宿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","約書亞清早起來，祭司又抬起耶和華的約櫃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","拿著七個羊角的七位祭司，走在耶和華的約櫃前面；一面走，一面吹角；拿武器的人走在他們前面，在耶和華的約櫃後面也有防衛的隊伍跟著走；祭司一面走，一面吹角。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","第二日，眾人又繞城一次，然後回到營裡去；六日他們都是這樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","到了第七日，清早黎明的時候，他們起來，以同樣的方式繞城七次；只有這一日，他們繞城七次。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","到了第七次，祭司吹角的時候，約書亞就對人民說：“你們呼喊吧，因為耶和華已經把這城賜給你們了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","這城要完全毀滅，城和城中的一切都歸耶和華；只有妓女喇合，和所有與她在家中的都可以存活，因為她收藏了我們派去的使者。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","不過你們要謹慎，不可取那當毀滅的物，恐怕你們貪心，取了那當毀滅的物，就使以色列營成為當毀滅的，使以色列營遭遇災禍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","可是，所有的金銀和銅鐵的器皿，都要歸耶和華為聖，存入耶和華的庫房中。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","於是人民呼喊，祭司也吹角。人民聽見角聲的時候，就大聲呼喊，城牆就塌陷了；於是，人民衝入城中，人人向前，把城攻取。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","他們把城中的一切，無論男女老幼、牛羊和驢，都用刀殺盡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","約書亞對窺探那地的兩個人說：“你們進那妓女的家裡去，照著你們向她所起的誓，把那女人和她所有的一切，都從家裡帶出來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","那兩個年輕密探就進去，把喇合和她的父母、兄弟、她所有的一切，以及她所有的親屬，都領出來，安置在以色列的營外。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","眾人把城和城中的一切都用火燒了；只有金銀和銅鐵的器皿都放入耶和華聖所的庫房裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","約書亞卻放過妓女喇合和她的父家，以及她所有的一切；她住在以色列中，直到今日，因為她收藏了約書亞派去窺探耶利哥的使者。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","那時，約書亞要人民起誓，說：“起來重建這耶利哥城的，那人在耶和華面前是可咒可詛的；他立地基的時候必喪長子；他安城門的時候必失幼子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","耶和華與約書亞同在；約書亞的名聲傳遍全地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","以色列人在那當毀滅的物上犯了不忠實的罪；因為猶大支派中，謝拉的曾孫、撒底的孫子、迦米的兒子亞干，取了當毀滅的物，耶和華就向以色列人發怒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","那時，約書亞從耶利哥派人到伯特利東邊，靠近伯．亞文的艾城去，吩咐他們說：“你們上去窺探那地。”那些人就上去，窺探艾城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","他們回來，對約書亞說：“不需要全體人民都上去；只要大約二三千人就可以上去攻打艾城了；不必勞動全體人民都上那裡去，因為那裡的人很少。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","於是人民中約有三千人上那裡去，但他們竟在艾城的人面前逃跑了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","艾城的人擊殺了他們約三十六人；從城門前追趕他們，一直追到示巴琳；在山坡上把他們擊潰；人民的心就極其驚怕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","約書亞就撕裂自己的衣服，和以色列人的長老，在耶和華的約櫃前，一同俯伏在地，直到晚上，也把塵土撒在頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","約書亞說：“唉！主耶和華啊，你為甚麼領這人民過約旦河，為要把我們交在亞摩利人的手中，使我們滅亡呢？我們寧願住在約旦河那邊倒好。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","主啊！以色列人既然在仇敵面前轉身逃跑，我還有甚麼可說的呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","迦南人和這地所有的居民聽見了，就必圍困我們，把我們的名字從這世上剪除，那時你為你的大名要怎樣行呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","耶和華對約書亞說：“你起來，為甚麼這樣臉伏在地呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","以色列人犯了罪，違背了我吩咐他們的約定，因為他們取了那當毀滅的物，他們偷竊，並且說謊，又把那當毀滅的物放在自己的物件中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","所以，以色列人在他們的仇敵面前站立不住，在他們的仇敵面前轉身逃跑，因為他們成了當毀滅的。如果你們不把那當毀滅的物從你們中間除掉，我就必不再與你們同在了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","你起來，要人民自潔，對他們說：‘你們要自潔，預備明天；因為耶和華以色列的　神這樣說：以色列啊！你們中間有那當毀滅的物；除非你們把那當毀滅的物從你們中間除去，你們在仇敵的面前就不能站立得住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","到了早晨，你們要按著支派前來，耶和華抽籤抽中的支派，要按著宗族前來；耶和華抽籤抽中的宗族，要按著家庭前來；耶和華抽籤抽中的家庭，男丁要一個一個前來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","如果那藏有當毀滅的物的人被抽籤抽中了，他和他所有的一切都要用火焚燒；因為他違背了耶和華的約，又因為他在以色列中作了愚昧的事。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","約書亞清早起來，要以色列人按著支派前來；結果，猶大支派被抽籤抽中了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","他要猶大宗族前來，結果，謝拉的家族被抽籤抽中了；他要謝拉家族的男丁一個一個前來，結果，撒底被抽籤抽中了； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","他要撒底家中的男丁一個一個前來，結果，亞干被抽籤抽中了，亞干是迦米的兒子、撒底的孫子、謝拉的曾孫，是屬於猶大支派的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","約書亞對亞干說：“我兒，我勸你把榮耀歸給耶和華以色列的　神，向他認罪，告訴我你作了甚麼事，不可向我隱瞞。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","亞干回答約書亞，說：“我實在得罪了耶和華以色列的　神；我作過的事是這樣的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","我在戰利品中，看見了一件美麗的示拿衣服、二千二百八十克銀子，和一條重五百七十克的金條；我因貪愛這些物件，就把它們拿去了；現在埋藏在我帳棚的地裡，銀子在底下。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","約書亞就派人跑到亞干的帳棚裡，果然見到東西埋藏在那裡，銀子在底下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","他們就把東西從帳棚中拿出來，帶到約書亞和以色列人那裡，擺在耶和華面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","約書亞和全體以色列人一起把謝拉的曾孫亞干和那銀子、那件衣服、那金條，以及亞干的兒女、牛、驢、羊、帳棚和他所有的一切，都帶上亞割谷去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","約書亞說：“你為甚麼給我們招惹災禍呢？今天耶和華必使你遭受災禍。”於是全體以色列人用石頭把他打死。他們用石頭打死他們以後，就把一切用火燒了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","眾人又在亞干身上堆起了一大堆石頭，這堆石頭一直存到今日；於是耶和華就回心轉意，不發烈怒。因此那地方名叫亞割谷，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","耶和華對約書亞說：“你不要懼怕，也不要驚慌，你只管帶領所有能作戰的人，起來上艾城去；你看，我已經把艾城的王和他的人民、城市、土地都交在你手裡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","你怎樣對待耶利哥和耶利哥的王，也要照樣對待艾城和艾城的王；只是城中的戰利品和牲畜，你們可以據為己有；你要在城後面設下攻城的伏兵。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","於是，約書亞和所有能作戰的人都起來上艾城去；約書亞選了三萬英勇的戰士，漏夜派他們出去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","吩咐他們說：“你們注意，要在城後面埋伏攻城；不可離城太遠，人人都要作好準備。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","我和所有與我一起的人，要向城推進。城裡的人像前一次出來攻擊我們的時候，我們就在他們面前逃跑； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","他們必定出來追趕我們，我們就把他們引出城來，因為他們必定說：‘這些人像前一次一樣在我們面前逃跑了。’所以我們要在他們面前逃跑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","那時你們就要從埋伏的地方起來，佔領那城，因為耶和華你們的　神必把城交在你們的手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","你們佔領了城以後，就要放火燒城；要照著耶和華的話行事；你們要謹慎，我已經吩咐你們了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","約書亞差派他們去了，他們就上到埋伏的地方去，住在伯特利和艾城的中間，就是在艾城的西邊。那一夜，約書亞卻在人民中間住宿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","約書亞清早起來，召集人民上艾城去，他和以色列的長老走在人民的前面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","所有與他在一起的戰士都上去，迫近艾城，在城的北面安營；在約書亞和艾城中間有一個山谷， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","約書亞挑了大約五千人，要他們埋伏在伯特利和艾城中間，就是艾城的西面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","於是他們把眾民，就是在城北的全軍和在城西的伏兵都布置好了。那一夜，約書亞走進了山谷之中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","艾城的王看見了這情形，就和艾城的人急忙在清早起來，按著所定的時候出到亞拉巴，要與以色列人交戰；王卻不知道在城後面有伏兵要攻擊他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","約書亞和以色列人在他們面前裝敗，沿著通往曠野的路逃跑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","城裡的眾民都被召集，去追趕他們；艾城的人追趕約書亞的時候，就都被誘離城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","艾城和伯特利城沒有留下一個人不出來追趕以色列人；他們撇下了敞開的城門，去追趕以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","耶和華對約書亞說：“你向著艾城伸出你手中的短槍，因為我要把城交在你手裡。”約書亞就向著艾城伸出他手裡的短槍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","他一伸手，伏兵就從埋伏的地方急忙起來，衝進城去，把城奪取，並連忙放火燒城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","艾城的人轉身觀看，看見城裡濃煙沖天，就全身乏力，不能逃跑；往曠野逃跑的以色列人就轉過來攻擊追趕他們的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","約書亞和以色列人看見伏兵已經奪取了城，又看見城中濃煙上升，就轉回，擊殺艾城的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","伏兵也出城攻擊艾城的人；艾城的人就被困在以色列人中間，前後受敵；於是以色列人把他們擊殺，沒有留下一個，也沒有一個逃脫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","他們活捉了艾城的王，把他解到約書亞那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","以色列人在田間、在曠野，殺盡了所有追趕他們的艾城的居民，艾城的人全部倒在刀下，直到完全消滅；接著，以色列眾人回到艾城，用刀擊殺了城中的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","那一天被殺的人，連男帶女，共有一萬二千人，就是艾城所有的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","約書亞沒有收回伸出短槍的手，直到把艾城的居民都消滅為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","只有那城裡的牲畜和戰利品，以色列人照著耶和華吩咐約書亞的話，都據為己有。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","約書亞燒了艾城，使城永遠成為廢堆，一片荒涼，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","他又把艾城的王懸在樹上，直到黃昏的時候；日落的時候，約書亞吩咐人把屍體從樹上拿下來，丟在城門口那裡，又在屍體上堆起了一大堆石頭，這堆石頭一直存到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","那時，約書亞在以巴路山上，為耶和華以色列的　神築了一座祭壇， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","是照著耶和華的僕人摩西吩咐以色列人的，照著摩西律法書上所寫的，用未經過鐵器打鑿的整塊石塊築成的一座祭壇；在這祭壇之上，眾人向耶和華獻燔祭，也獻平安祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","約書亞在那裡，當著以色列人面前，把摩西所寫的摩西律法抄寫在石頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","全體以色列人和他們的長老、官長，以及審判官，都站在約櫃的兩旁，在抬耶和華約櫃的利未支派的祭司前面；無論是寄居的，或是本地人，一半對著基利心山，一半對著以巴路山；正如耶和華的僕人摩西以前所吩咐的，好為以色列民祝福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","然後，約書亞宣讀律法上一切祝福和咒詛的話，全都照著律法書上所寫的一切。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","摩西吩咐的一切話，約書亞在以色列全體會眾和婦女、小孩，以及在他們中間來往的寄居者面前，沒有一句不向他們宣讀出來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","在約旦河西，住在山上、高原和對著黎巴嫩山大海沿岸所有的王，就是赫人、亞摩利人、迦南人、比利洗人、希未人、耶布斯人的王，聽見了這些事的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","就聚集起來，同心協力地要與約書亞和以色列人交戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","基遍的居民聽見了約書亞向耶利哥和艾城所行的事， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","就施詭計，假冒使者而來，把舊的布袋和破裂又修補過的舊皮酒袋馱在驢上， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","腳上穿著補過的舊鞋，身穿舊衣服，所帶的食物又乾又碎。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","他們去到吉甲營中約書亞那裡，對約書亞和以色列人說：“我們是從遠地來的，現在求你們和我們立約。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","以色列人對這些希未人說：“你們也許是這地的居民，若是這樣，我們怎樣和你們立約呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","他們對約書亞說：“我們是你的僕人。”約書亞問他們：“你們是甚麼人？是從哪裡來的？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","他們回答約書亞：“你的僕人為了耶和華你　神的名從很遠的地方而來，因為我們聽見了他的名聲和他在埃及所行的一切事， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","以及他對約旦河東亞摩利人的兩個王，就是希實本王西宏和在亞斯他錄的巴珊王噩，所行的一切事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","所以我們的長老和我們本國所有的居民對我們說：‘你們手裡要帶著旅途用的乾糧，去迎見以色列人，對他們說：我們是你們的僕人，現在求你們和我們立約。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","我們出門到你們這裡來的時候，從家裡帶出來作乾糧的這餅還是熱的；看哪，現在都又乾又碎了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","這些皮酒袋，我們盛酒的時候，還是新的；你看，現在都破裂了。我們這些衣服和鞋因路途遙遠，都穿舊了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","以色列人取了他們一些食物，卻沒有求問耶和華的旨意。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","於是約書亞與他們議和，和他們立約，容他們存活；會眾的首領也向他們起了誓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","以色列人和他們立約之後，過了三天，才聽見他們是自己的近鄰，是住在這地的居民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","於是，以色列人起程，第三日就到了他們的城市；他們的城市就是基遍、基非拉、比錄、基列．耶琳。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","以色列人沒有擊殺他們，因為會眾的首領曾經指著耶和華以色列的　神向他們起了誓，全體會眾就都向首領發怨言。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","眾首領對全體會眾說：“我們曾經指著耶和華以色列的　神向他們起了誓，現在我們不能傷害他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","我們要這樣待他們，就是容他們存活，免得　神的忿怒因我們向他們所起的誓，臨到我們身上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","眾首領又對會眾說：“要讓他們存活。”於是他們就給全體會眾作了劈柴打水的人，這是按照眾首領對他們的吩咐。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","約書亞把他們召了來，質問他們：“你們為甚麼欺騙我們說：‘我們離你們很遠’，其實你們卻是住在這地的？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","現在你們要受到咒詛，你們中間必不斷有人作奴僕，為我　神的聖所作劈柴打水的人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","他們回答約書亞，說：“因為你的僕人確實地聽見，耶和華你的　神曾經吩咐他的僕人摩西，要把這整片土地賜給你們，並且要在你們面前把這地上所有的居民都消滅，因此，我們因你們的緣故，很怕喪命，才行了這事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","現在，你看，我們都在你的手裡，你看怎樣處置我們算為好、算為對，就怎樣行吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","約書亞就這樣處置他們，救了他們脫離以色列人的手，以色列人就沒有殺他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","在那一天，約書亞指派他們在耶和華選擇的地方，為會眾和耶和華的祭壇作劈柴打水的人，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","耶路撒冷王亞多尼．洗德聽見約書亞佔領了艾城，把城完全毀滅，約書亞怎樣對待耶利哥和耶利哥的王，也照樣對待艾城和艾城的王；又聽見基遍的居民已經與以色列人議和，並可以住在這地， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","他們就非常懼怕。因為基遍是大城，好像一座王城；又因為基遍比艾城大，城裡所有的人都是勇士。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","因此，耶路撒冷王亞多尼．洗德派人到希伯崙王何咸、耶末王毗蘭、拉吉王雅非亞和伊磯倫王底璧那裡去，對他們說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“求你們上我這裡來幫助我，我們好攻打基遍，因為基遍已經與約書亞和以色列人議和了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","於是亞摩利人的那五個王，就是耶路撒冷王、希伯崙王、耶末王、拉吉王和伊磯倫王，聯合起來，帶著他們所有的軍隊上去，在基遍的對面安營，攻打基遍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","基遍人就派人到吉甲營中約書亞那裡去，說：“不可丟棄你的僕人，求你快快上我們這裡來拯救我們、幫助我們；因為住在山地的亞摩利人所有的王都集合起來攻擊我們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","於是約書亞和所有能作戰的人，以及所有英勇的戰士，都一起從吉甲上去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","耶和華對約書亞說：“你不要怕他們，因為我已經把他們交在你手裡了；他們必沒有一人能在你面前站立得住。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","於是約書亞乘夜從吉甲上去，突然來到他們那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","耶和華使他們在以色列人面前潰亂，約書亞在基遍大大地擊殺他們，沿著伯．和崙的上坡路追趕他們，擊打他們，直到亞西加和瑪基大。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","他們從以色列人面前逃跑，正在下伯．和崙斜坡的時候，耶和華從天上降大冰雹在他們身上，一直到亞西加，打死他們；被冰雹打死的，比以色列人用刀殺死的還多。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","那時，就是耶和華把亞摩利人交給以色列人的時候，約書亞在以色列人面前對耶和華說：“太陽啊，停在基遍；月亮啊，停在亞雅崙谷。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","於是太陽停住，月亮站住，直到以色列人在仇敵的身上報了仇。這事不是寫在《雅煞珥書》上嗎？太陽在天空中站住，不急速下落，約有一整天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","在這日以前或這日以後，耶和華聽人的禱告，沒有像這日一樣的，因為耶和華為以色列作戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","後來，約書亞和眾以色列人回到吉甲營那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","那五個王逃跑了，躲藏在瑪基大洞裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","有人告訴約書亞，說：“那五個王已經找到了，都躲藏在瑪基大洞裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","約書亞說：“你們把幾塊大石頭輥到洞口那裡去，並派人到洞口去看守他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","你們卻不可站著，要追趕你們的仇敵，從後面擊殺他們，不可讓他們逃進自己的城中，因為耶和華你們的　神已經把他們交在你們的手裡了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","約書亞和以色列人把他們殺得慘敗，直到把他們滅絕為止，那些逃脫的人都逃進設防的城裡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","眾以色列人都平平安安回到瑪基大營中約書亞那裡。沒有人敢說話攻擊以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","約書亞說：“你們打開洞口，把那五個王從洞裡拉出來，帶到我這裡來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","眾人就照著執行，他們把那五個王，就是耶路撒冷王、希伯崙王、耶末王、拉吉王和伊磯倫王，從洞裡拉出來，帶到約書亞那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","眾人把那五個王帶到約書亞那裡去的時候，約書亞把所有的以色列人都召了來，對那些與他同去作戰的軍長說：“你們走前來，把腳踏在這些王的頸項上。”他們就走前來，把腳踏在那些王的頸項上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","約書亞對他們說：“你們不要懼怕，不要驚慌；總要堅強勇敢，因為耶和華必這樣對待你們要攻打的所有仇敵。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","隨後，約書亞把那五個王殺死，懸在五棵樹上；他們就懸在樹上，直到晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","到了日落的時候，約書亞吩咐人把他們從樹上取下來，丟在他們躲藏過的洞裡，把幾塊大石頭放在洞口；這些石頭一直存到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","在那天，約書亞佔領了瑪基大，用刀擊殺了那城的人和那城的王，把城中所有的人完全毀滅，不容一人逃脫；他對待瑪基大王就像對待耶利哥王一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","約書亞和跟他在一起的眾以色列人從瑪基大往立拿去，攻打立拿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","耶和華把立拿和立拿的王也交在以色列人手裡，約書亞用刀攻擊那城，殺了城裡所有的人，不容一人逃脫；他對待立拿王就像對待耶利哥王一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","約書亞和跟他在一起的眾以色列人從立拿往拉吉去，對著拉吉安營，攻打這城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","耶和華把拉吉交在以色列人手裡，第二天約書亞就佔領了拉吉，用刀攻擊那城，殺了城中所有的人，跟他對立拿所行的一切一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","那時，基色王荷蘭上來幫助拉吉，約書亞就把他和他的人民都擊殺了，沒有留下一人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","約書亞和與他在一起的眾以色列人從拉吉往伊磯倫去，對著伊磯倫安營，攻打這城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","那一天，他們佔領了這城，用刀攻擊那城，殺了城中所有的人；那一天約書亞把他們完全毀滅，跟他對拉吉所行的一切一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","約書亞和與他在一起的眾以色列人從伊磯倫上希伯崙去，攻打這城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","他們佔領了這城，用刀攻擊這城，殺了這城的王，又攻擊屬於這城的城鎮，殺了城中所有的人，不容一人逃脫，跟他對伊磯倫所行的一切一樣，把這城和城中所有的人完全毀滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","約書亞和與他在一起的眾以色列人回到了底璧，攻打這城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","約書亞佔領了這城，抓住這城的王，又佔領了屬於這城的一切城鎮；以色列人用刀擊殺他們，把城中所有的人都毀滅了；約書亞不容一人逃脫，他怎樣對待希伯崙，也照樣對待底璧和底璧的王；也好像他對待立拿和立拿的王一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","這樣，約書亞擊殺了全地的人，就是山地、南地、高原和山坡的人，以及那些地方所有的王，不容一人逃脫；約書亞照著耶和華以色列的　神的吩咐，把有氣息的都完全毀滅了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","約書亞從加低斯．巴尼亞擊殺他們，直到迦薩，又從歌珊全地擊殺他們，直到基遍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","約書亞在這一次戰役中擊敗了這些王和佔領了他們的地，是因為耶和華以色列的　神為以色列作戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","於是約書亞和與他在一起的眾以色列人回到吉甲營中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","夏瑣王耶賓一聽見這些事，就派人去見瑪頓王約巴、伸崙王、押煞王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","以及住在北方山地、基尼烈南邊的亞拉巴高原和西邊多珥高地的眾王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","又去見在東方和西方的迦南人，住在山地的亞摩利人、赫人、比利洗人和耶布斯人，以及米斯巴地黑門山下的希未人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","這些王與他們所有的軍隊都一同出來，人數眾多，好像海邊的沙，還有很多馬匹和車輛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","這些王都聯合起來，來到米倫水邊，在那裡一起安營，要與以色列人作戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","耶和華對約書亞說：“你不要因他們懼怕，因為明天這個時候，我必使他們全數在以色列人面前被殺；你要砍斷他們的馬蹄筋，焚燒他們的車輛。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","於是約書亞和所有與他在一起能作戰的人，在米倫水邊突然迫近，攻打他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","耶和華把他們交在以色列人手裡，以色列人就擊殺他們，追趕他們直到西頓大城、米斯利弗．瑪音，以及在東邊的米斯巴谷；以色列人擊殺他們，沒有留下一個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","約書亞照著耶和華吩咐他的對待他們；他砍斷了他們的馬蹄筋，用火燒了他們的車輛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","那時，約書亞轉回來，佔領了夏瑣，用刀擊殺了夏瑣王，因為夏瑣在這些國中素來是為首的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","以色列人用刀擊殺了城中所有的人，把他們完全毀滅；有氣息的一個也沒有留下；約書亞又放火燒了夏瑣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","約書亞奪取了那些王的一切城鎮，又擒獲那些城鎮所有的王；他用刀擊殺了他們，把一切完全毀滅，正如耶和華僕人摩西所吩咐的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","至於那些立在土丘上的城，除了夏瑣以外，以色列人都沒有焚燒；約書亞只燒了夏瑣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","那些城所有的戰利品和牲畜，以色列人都據為己有；只是把所有的人都用刀擊殺了，直到把他們殺盡；有氣息的，他們沒有留下一個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","耶和華怎樣吩咐他的僕人摩西，摩西就怎樣吩咐約書亞，約書亞也照樣行了；耶和華吩咐摩西的一切，約書亞沒有一樣不辦妥的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","這樣，約書亞奪取了那整個地區，就是山地、整個南地、歌珊全地、高原、亞拉巴、以色列山地和山地的高原； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","從延伸至西珥的哈拉山，直到黑門山下黎巴嫩谷的巴力．迦得；約書亞擒獲了那些地方所有的王，把他們都殺死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","約書亞和這些王作戰了很多的日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","除了住在基遍的希未人以外，沒有一座城與以色列人議和的；所有其他的城都是以色列人作戰奪取的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","因為這是出於耶和華的旨意，他使他們心裡剛硬，要與以色列人交戰，好把他們完全毀滅，使他們不蒙憐憫，卻要被消滅，正如耶和華吩咐摩西的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","那時約書亞來了，把在山地、希伯崙、底璧、亞拿伯、整個猶大山地、整個以色列山地所有的亞衲族人都剪除了。約書亞把他們與他們的城鎮都完全毀滅了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","在以色列人的境內，沒有留下一個亞衲族人，只在迦薩、迦特和亞實突還有餘下的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","這樣，約書亞照著耶和華吩咐摩西的一切話，奪取了那全地；於是，約書亞按著以色列的支派把地分給他們作產業。全地也就止息了戰爭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","以色列人在約旦河東向日出之地擊殺了那地的兩個王，佔領了他們的地，就是從亞嫩谷直到黑門山，和東邊的亞拉巴全境。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","這兩個王，一個是住在希實本的亞摩利人的王西宏；他管轄的地區，是從亞嫩谷旁的亞羅珥起，包括山谷中部和基列的一半，直到雅博河，就是亞捫人的境界； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","東邊有亞拉巴，上至基尼烈海，下至亞拉巴海，就是鹽海，東邊是往伯．耶西末的路；南邊直到毗斯迦的山麓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","另一個是巴珊王噩，他是利乏音人的餘民，住在亞斯他錄和以得來； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","他管轄的地區，是黑門山、撒迦、巴珊全地，直到基述人和瑪迦人的境界，還有基列的一半，直到希實本王西宏的境界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","耶和華的僕人摩西和以色列人把這兩個王擊殺了。耶和華的僕人摩西把地分給流本人、迦得人和瑪拿西半個支派的人作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","以下是約書亞和以色列人在約旦河西，從黎巴嫩谷的巴力．迦得，直到延伸至西珥的哈拉山等地，所擊殺的眾王；約書亞把那地分給以色列各支派作產業； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","就是赫人、亞摩利人、迦南人、比利洗人、希未人、耶布斯人所住的山地、高原、亞拉巴、山坡、曠野和南地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","他們的王，一個是耶利哥王，一個是伯特利旁邊的艾城王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","一個是耶路撒冷王，一個是希伯崙王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","一個是耶末王，一個是拉吉王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","一個是伊磯倫王，一個是基色王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","一個是底璧王，一個是基德王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","一個是何珥瑪王，一個是亞拉得王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","一個是立拿王，一個是亞杜蘭王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","一個是瑪基大王，一個是伯特利王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","一個是他普亞王，一個是希弗王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","一個是亞弗王，一個是拉沙崙王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","一個是瑪頓王，一個是夏瑣王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","一個是伸崙．米崙王，一個是押煞王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","一個是他納王，一個是米吉多王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","一個是基低斯王，一個是靠近迦密的約念王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","一個是多珥山地的多珥王，一個是吉甲的戈印王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","一個是得撒王，共計三十一個王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","約書亞老了，年紀不小；耶和華對他說：“你已經老了，年紀不小；還有很多的地有待征服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","還剩下來的地，就是非利士人的全境和基述人的全地， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","從埃及東面的西曷河，向北直到以革倫的境界（這都算是迦南人的地方），由五個非利士人的首領管轄的迦薩人、亞實突人、亞實基倫人、迦特人、以革倫人的地方；並且有亞衛人， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","他們是在南方，以及迦南人全境和屬西頓人的米亞拉，直到亞弗和亞摩利人的境界； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","還有迦巴勒人的地和東面的黎巴嫩全境，從黑門山下的巴力．迦得，直到哈馬口； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","從黎巴嫩直到米斯利弗．瑪音，所有住在山地的居民，就是所有的西頓人，我必在以色列人面前把他們趕出去。你只要照著我吩咐你的，把這地抽籤分給以色列人作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","現在你要把這地分給九個支派和瑪拿西半個支派作產業。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","瑪拿西另半個支派，跟流本人和迦得人，已經得了摩西在約旦河東賜給他們的產業，是照著耶和華的僕人摩西賜給他們的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","就是從亞嫩谷邊的亞羅珥和谷中間的城，以及米底巴的整片平原，直到底本； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","還有在希實本作王的亞摩利人的王西宏所有的城鎮，直到亞捫人的境界； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","又有基列地、基述人和瑪迦人的境界，以及整個黑門山、巴珊全地，直到撒迦； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","另有巴珊王噩的全國，他在亞斯他錄和以得來作王；他是利乏音人留下的餘民。這些地方的人，摩西都把他們擊殺了，趕走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","以色列人卻沒有趕走基述人和瑪迦人；因此，基述人和瑪迦人住在以色列人中間，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","只有利未支派，摩西沒有把產業給他們；他們的產業就是獻給耶和華以色列的　神的火祭，正如耶和華對他們所說的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","摩西按著流本支派的家族，把產業給了他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","他們的境界是從亞嫩谷邊的亞羅珥起，包括谷中間的城、靠近米底巴的整片平原、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","希實本和平原上屬希實本所有的城、底本、巴末．巴力、伯．巴力．勉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","雅雜、基底莫、米法押、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","基列亭、西比瑪、谷中山地上的細列哈．沙轄、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","伯．毗珥、毗斯迦山坡、伯．耶西末、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","平原上所有的城和亞摩利人的王西宏的全國。這西宏曾經在希實本作王，摩西把他和米甸的首領以未、利金、蘇珥、戶珥和利巴都擊殺了。這些都是西宏的王侯，住在那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","在以色列人所殺的人中，比珥的兒子占卜者巴蘭也被他們用刀所殺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","流本人領土的疆界是約旦河，這就是流本人按著家族得著的產業所包括的眾城，和屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","摩西按著迦得支派的家族把產業分給迦得支派。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","他們的境界包括雅謝和基列所有的城，以及亞捫人的一半土地，直到拉巴前面的亞羅珥； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","從希實本直到拉抹．米斯巴和比多寧，又從瑪哈念直到底璧的境界； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","還有在谷中的伯．亞蘭、伯．寧拉、疏割、撒分，就是希實本王西宏國中的餘地，以約旦河作疆界，直到基尼烈海的底端，都在約旦河東。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","這就是迦得人按著家族得著的產業所包括的城鎮，和屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","摩西把產業分給瑪拿西半個支派，是按著瑪拿西半個支派的家族分給他們的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","他們的境界是從瑪哈念起，包括巴珊全地、巴珊王噩的全國，並且在巴珊的睚珥的所有村落，共六十座城， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","還有基列的一半和亞斯他錄、以得來，就是在巴珊，噩的王國的兩座城，都是按著家族分給瑪拿西的兒子瑪吉的孫子，就是分給瑪吉的一半孫子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","以上這些地方是摩西在約旦河東，耶利哥對面的摩押平原所分配的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","可是利未支派，摩西卻沒有把產業分給他們，因為耶和華以色列的　神就是他們的產業，正如耶和華對他們所說的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","以下這些地方是以色列人在迦南地分得的產業，就是以利亞撒祭司和嫩的兒子約書亞，以及以色列人各支派的族長分給他們的， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","是照著耶和華藉著摩西所吩咐的，以抽籤的方法把產業分給九個半支派。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","因為摩西在約旦河東已經把產業分給了那兩個半支派；卻沒有把產業分給他們中間的利未人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","因為約瑟的子孫成了兩個支派，就是瑪拿西和以法蓮，因此以色列人沒有把地業分給在那地的利未人，只給他們一些城市居住，還有城市的郊野，可以牧放他們的牲畜，安置他們的財產。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","耶和華怎樣吩咐摩西，以色列人就照樣行，把地分配了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","猶大人來到吉甲約書亞那裡，基尼洗人耶孚尼的兒子迦勒對約書亞說：“耶和華在加低斯．巴尼亞對神人摩西所說關於你和我的話，你是知道的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","耶和華的僕人摩西從加低斯．巴尼亞派我去窺探這地的時候，我正四十歲；我照著我心裡所想的向他報告。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","可是，與我一同上去的眾兄弟卻使人民的心驚懼，我卻完全順從耶和華我的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","那天摩西起誓說：‘你的腳踏過的地都必歸你和你的子孫作產業，直到永遠，因為你完全順從耶和華我的　神。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","現在你看，自從耶和華對摩西說了這話以後，耶和華照著所應許的，使我活了這四十五年，就是以色列人在曠野行走的時期；現在你看，我今日已經是八十五歲了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","今日我還是強壯，像摩西派我去的那天一樣；無論是作戰，或是出入，那時我的力量怎樣，現在我的力量還是怎樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","現在求你把耶和華那日所應許的這山地賜給我；因為那天你也曾聽見那裡有亞衲人，又有寬大堅固的城；但耶和華與我同在，我就可以把他們趕出去，正如耶和華所應許的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","於是約書亞給迦勒祝福，把希伯崙賜給了耶孚尼的兒子迦勒作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","因此，希伯崙成了基尼洗人耶孚尼的兒子迦勒的產業，直到今日；因為他完全順從耶和華以色列的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","希伯崙從前名叫基列．亞巴；亞巴是亞衲人中最偉大的人。全地也就止息了戰爭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","猶大支派按著家族抽籤所得的地業，是極南的部分，達到以東的邊境，去到南邊尋的曠野。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","他們南方的疆界是從鹽海的極南部分起，就是從南邊的海灣起； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","伸到亞克拉濱山坡的南邊，經過尋，上到加低斯．巴尼亞的南邊，又經過希斯崙，再上到亞達珥，繞過甲加， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","經過押們，伸展到埃及河，疆界直通到海；這就是他們南方的疆界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","東方的疆界是從鹽海直到約旦河口。北方的疆界是從約旦河口的海灣起， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","上到伯．曷拉，經過伯．亞拉巴的北邊，再上到流本的兒子波罕的磐石那裡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","又從亞割谷上到底璧，再北轉到河的南邊亞都冥山坡對面的吉甲去；又經過隱．示麥水泉，直通到隱．羅結； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","再上到欣嫩子谷，到達耶布斯南面的山坡，耶布斯就是耶路撒冷；又上到欣嫩子谷西邊的山頂，就是在利乏音的北端； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","又從山頂轉到尼弗多亞的水泉，伸展到以弗崙山的眾城；又轉到巴拉，巴拉就是基列．耶琳； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","又從巴拉向西繞到西珥山，經過耶琳山坡的北邊，耶琳就是基撒崙；又下到伯．示麥，經過亭納； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","伸展到以革倫北面的山坡，轉到施基崙，經過巴拉山，伸展到雅比聶，直通到海為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","西方的疆界就是大海和海岸。這是猶大人按著家族所得四圍的境界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","約書亞照著耶和華所吩咐的，把猶大人的一份地業，就是基列．亞巴，分給了耶孚尼的兒子迦勒；亞巴是亞衲人的祖先。基列．亞巴就是希伯崙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","迦勒把亞衲人的三個子孫，就是示篩、亞希幔、撻買，從那裡趕出去；他們是亞衲人的後代。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","他又從那裡上去攻擊底璧的居民；底璧從前名叫基列．西弗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","迦勒說：“誰能攻打基列．西弗，把基列．西弗奪取，我就把我的女兒押撒給他作妻子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","迦勒的兄弟基納斯的兒子俄陀聶奪取了那城，迦勒就把女兒押撒給他作妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","押撒出嫁的時候，慫恿丈夫向她父親求一塊田地；押撒一下驢，迦勒問她：“你要甚麼？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","她回答：“求你給我祝福；你既然把南地給了我，求你也把水泉給我。”她父親就把上泉和下泉都給了她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","以下是猶大支派按著家族所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","猶大支派極南邊的眾城，接近以東邊界的，有：甲薛、以得、雅姑珥、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","基拿、底摩拿、亞大達、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","基低斯、夏瑣、以提楠、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","西弗、提鍊、比亞綠、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","夏瑣．哈大他、加略．希斯崙（加略．希斯崙就是夏瑣）、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","亞曼、示瑪、摩拉大、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","哈薩．迦大、黑實門、伯．帕列、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","哈薩．書亞、別是巴、比斯約他、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","巴拉、以因、以森、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","伊勒多臘、基失、何珥瑪、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","洗革拉、麥連拿、三撒拿、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","利巴勿、實忻、亞因、臨門，共二十九座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","在高原有以實陶、瑣拉、亞實拿、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","撒挪亞、隱．干寧、他普亞、以楠、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","耶末、亞杜蘭、梭哥、亞西加、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","沙拉音、亞底他音、基底拉、基底羅他音，共十四座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","又有洗楠、哈大沙、麥大．迦得、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","底連、米斯巴、約帖、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","拉吉、波斯加、伊磯倫、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","迦本、拉幔、基提利、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","基低羅、伯．大袞、拿瑪、瑪基大，共十六座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","又有立拿、以帖、亞珊、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","益弗他、亞實拿、尼悉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","基伊拉、亞革悉、瑪利沙，共九座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","又有以革倫，和屬於以革倫的市鎮村莊； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","從以革倫直到海，所有靠近亞實突的城和屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","亞實突和屬於亞實突的市鎮村莊；迦薩和屬於迦薩的市鎮村莊；直到埃及小河和大海沿岸的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","在山地有沙密、雅提珥、梭哥、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","大拿、基列．薩拿（基列．薩拿就是底璧）、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","亞拿伯、以實提莫、亞念、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","歌珊、何倫、基羅，共十一座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","又有亞拉、度瑪、以珊、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","雅農、伯．他普亞、亞非加、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","宏他、基列．亞巴（基列．亞巴就是希伯崙）、洗珥，共九座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","又有瑪雲、迦密、西弗、淤他、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","耶斯列、約甸、撒挪亞、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","該隱、基比亞、亭納，共十座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","又有哈忽、伯．夙、基突、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","瑪臘、伯．亞諾、伊勒提君，共六座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","又有基列．巴力（基列．巴力就是基列．耶琳）、拉巴，共兩座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","在曠野有伯．亞拉巴、密丁、西迦迦、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","匿珊、鹽城、隱．基底，共六座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","至於住在耶路撒冷的耶布斯人，猶大人不能把他們趕走；所以耶布斯人在耶路撒冷與猶大人同住，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","約瑟的子孫抽籤所得的地業，是從靠近耶利哥的約旦河起，到耶利哥東邊的水泉，經過從耶利哥上去的曠野，進到在山地的伯特利； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","又從伯特利到路斯，經過亞基人的境界亞他綠， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","又向西下到押利提人的境界，去到下伯．和崙和基色的境界，直通到海。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","約瑟的兒子瑪拿西和以法蓮，也得了他們的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","以下是以法蓮人按著家族所得的境界：他們的產業在東方的疆界，是亞他綠．亞達，直到上伯．和崙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","向西伸展到北面的密米他，又向東繞到他納．示羅，經過雅挪哈的東邊； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","從雅挪哈下到亞他綠，又到拿拉，和耶利哥接壤，伸展到約旦河； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","又從他普亞向西行，到加拿河，直通到海；這就是以法蓮支派按著家族所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","此外在瑪拿西人的產業中，還有些城鎮分給以法蓮人的，這些城鎮都包括屬於它們的村莊在內。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","可是他們沒有把住在基色的迦南人趕走，於是迦南人住在以法蓮中間，直到今日，成了作苦工的奴僕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","瑪拿西是約瑟的長子，他的支派抽籤所得的地業記在下面；至於瑪拿西的長子，基列的父親瑪吉，因為是個戰士，所以得到基列和巴珊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","瑪拿西其餘的子孫按著家族抽籤分地，包括亞比以謝的子孫、希勒的子孫、亞斯列的子孫、示劍的子孫、希弗的子孫、示米大的子孫；這些都是約瑟的兒子瑪拿西子孫中男丁的各家族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","瑪拿西的玄孫、瑪吉的曾孫、基列的孫子、希弗的兒子西羅非哈沒有兒子，只有女兒；他女兒們的名字是瑪拉、挪阿、曷拉、密迦、得撒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","她們來到以利亞撒祭司和嫩的兒子約書亞，以及眾首領的面前，說：“耶和華曾經吩咐摩西，在我們的兄弟中把產業分給我們。”於是約書亞照著耶和華所吩咐的，在她們的叔伯中間，把產業分給她們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","這樣，除了約旦河東的基列和巴珊地之外，還有十份地業歸屬瑪拿西。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","因為瑪拿西的孫女，在瑪拿西的孩子中，也得了產業；基列地是屬於瑪拿西其餘的子孫的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","瑪拿西的疆界，是從亞設起，到示劍東面的密米他；又向南走，到隱．他普亞的居民那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","（他普亞地是屬於瑪拿西的，但是在瑪拿西疆界上的他普亞城，卻是屬於以法蓮的子孫的。） ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","瑪拿西的疆界又下到加拿河，在加拿河的南邊，瑪拿西的眾城鎮中，有這些城鎮是屬於以法蓮的。瑪拿西的疆界，從河的北面起，直通到海。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","南面是屬於以法蓮的，北面是屬於瑪拿西的；瑪拿西在西邊的疆界就是海，北面與亞設相接，東面和以薩迦相連； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","在以薩迦和亞設的境內，伯．善和屬於伯．善的市鎮，以伯蓮和屬於以伯蓮的市鎮，多珥的居民和屬於多珥的市鎮，都屬於瑪拿西；還有三處山區，就是：隱．多珥的居民和屬於隱．多珥的市鎮，他衲的居民和屬於他衲的市鎮，米吉多的居民和屬於米吉多的市鎮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","可是瑪拿西的子孫卻不能把這些城的居民趕走，迦南人決意住在那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","以色列人強盛以後，就迫使迦南人作苦工，卻沒有把他們完全趕出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","約瑟的子孫對約書亞說：“耶和華這樣賜福我們，我們族大人多，你為甚麼只給我們抽一份籤，分一份地作產業呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","約書亞對他們說：“如果你們族大人多，又嫌以法蓮山地過於窄小，就可以上森林區去，在比利洗人和利乏音人之地那裡自己砍伐樹木。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","約瑟的子孫回答：“那山地容不下我們，並且住在谷地的所有迦南人，就是住在伯．善和屬於伯．善的市鎮的人，以及住在耶列斯谷的人，都有鐵車。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","約書亞對約瑟家，就是對以法蓮人和瑪拿西人說：“你們族大人多，勢力強大，不可以只抽一份地業； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","山地也要歸給你們，那裡雖然是森林，你們可以砍伐，開闢的土地都歸給你們；迦南人雖然擁有鐵車，勢力強大，你們也能把他們趕出去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","以色列全體會眾聚集在示羅，把會幕豎立在那裡，因為那地在他們面前被征服了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","以色列人其餘的七個支派還沒有得著產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","約書亞對以色列人說：“耶和華你們列祖的　神賜給你們的地，你們遲遲不去佔領，要到幾時呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","你們每支派要選出三個人，我要派他們去；他們要起程走遍那地，把各支派的產業描繪下來，然後回到我這裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","他們要把地業分作七份，猶大留在南方他們的境界內；約瑟家留在北方他們的境界內。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","你們要把地劃分七份，然後把圖樣拿給我；我要在這裡，在耶和華我們的　神面前，為你們抽籤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","利未人在你們中間沒有業分，因為耶和華祭司的職分就是他們的產業。迦得支派、流本支派和瑪拿西半個支派，已經在約旦河東得了產業，就是耶和華的僕人摩西分給他們的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","那些人起程前去的時候，約書亞吩咐那些前去繪畫那地的人說：“你們要去，走遍那地，繪畫地形，然後回到我這裡來，我要在示羅這裡，在耶和華面前，為你們抽籤。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","那些人就去了，走遍那地，並繪畫下來，把眾城分作七份記在冊子上，然後回到示羅營中約書亞那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","約書亞就在示羅，在耶和華面前為他們抽籤；約書亞在那裡按著他們的支派把地分給以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","便雅憫支派按著家族抽了籤；他們抽籤所得的境界，是在猶大子孫和約瑟子孫中間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","他們的疆界，北邊是從約旦河起，向上到耶利哥的北邊，又向西上到山地，直到伯．亞文的曠野。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","又從那裡向南經過路斯，路斯就是伯特利，再下到亞他綠．亞達，靠近下伯．和崙南邊的山地； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","又從那裡伸延，繞到西邊再向南，從伯．和崙南邊對面的山起，直到猶大人的城基列．巴力，基列．巴力就是基列．耶琳；這是西方的疆界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","南方的疆界是從基列．耶琳的邊緣起，向西伸展，去到尼弗多亞的水泉； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","又下到欣嫩子谷前面的山邊，就是利乏音谷北面的山；再下到欣嫩谷，去到耶布斯人的南邊，又下去隱．羅結； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","再轉向北，伸展至隱．示麥，去到亞都冥斜坡對面的基利錄，又下到流本的兒子波罕的磐石那裡； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","又經過亞拉巴對面山坡的北邊，直下到亞拉巴； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","又經過伯．曷拉的北邊，直通到鹽海的北灣，約旦河的南端；這是南方的疆界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","東方的疆界是約旦河。這就是便雅憫各家族所得的產業四圍的疆界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","便雅憫支派按著家族所得的城就是：耶利哥、伯．曷拉、伊麥．基悉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","伯．亞拉巴、洗瑪蓮、伯特利、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","亞文、巴拉、俄弗拉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","基法．阿摩尼、俄弗尼、迦巴，共十二座城，還有屬於這些城的村莊； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","又有基遍、拉瑪、比錄、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","米斯巴、基非拉、摩撒、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","利堅、伊利毗勒、他拉拉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","洗拉、以利弗、耶布斯（耶布斯就是耶路撒冷）、基比亞、基列，共十四座城，還有屬於這些城的村莊。這就是便雅憫人按著家族所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","為西緬，就是為西緬支派，按著家族抽出第二籤；他們的產業是在猶大人的產業中間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","他們所得的產業有別是巴、示巴、摩拉大、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","哈薩．書亞、巴拉、以森、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","伊利多拉、比土力、何珥瑪、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","洗革拉、伯．瑪加博、哈薩．蘇撒、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","伯．利巴勿、沙魯險，共十三座城，還有屬於這些城的村莊； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","又有亞因、利門、以帖、亞珊，共四座城，還有屬於這些城的村莊； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","以及這些城周圍所有的村莊，直到巴拉．比珥，就是南地的拉瑪。這就是西緬支派按著家族所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","西緬人的產業是從猶大人的地業中得來的；因為猶大人的分過大，所以西緬人在猶大人的產業中得了他們的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","為西布倫人，按著家族抽出第三籤；他們產業的境界去到撒立； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","他們的疆界再向西上到瑪拉拉，直達大巴設，再去到約念前面的河； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","又從撒立向東轉到日出的方向，去到吉斯綠．他泊的境界，又伸展到他比拉，上到雅非亞； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","又從那裡往東面日出的方向，經過迦特．希弗，到以特．加汛、臨門，再伸展到尼亞； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","又繞過尼亞的北面，到哈拿頓，直通到伊弗他．伊勒谷； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","還有加他、拿哈拉、伸崙、以大拉、伯利恆，共有十二座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","這些城和屬於這些城的村莊，就是西布倫人按著家族所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","為以薩迦，就是為以薩迦人，按著家族抽出第四籤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","他們的境界包括耶斯列、基蘇律、書念、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","哈弗連、示按、亞拿哈拉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","拉璧、基善、亞別、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","利蔑、隱．干寧、隱．哈大、伯．帕薛， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","又達到他泊、沙哈洗瑪、伯．示麥，直通到約旦河，共十六座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","這些城和屬於這些城的村莊，就是以薩迦支派按著家族所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","為亞設支派，按著家族抽出第五籤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","他們的境界包括黑甲、哈利、比田、押煞、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","亞拉米勒、亞末、米沙勒，向西直達迦密和希曷．立納； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","又轉往日出的方向，到伯．大袞，延伸到細步綸，向北去到伊弗他．伊勒谷、伯．以墨和尼業，又伸展到迦布勒的左邊， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","到義伯崙、利合、哈們、加拿，直到西頓大城； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","又轉到拉瑪，直到設防的城推羅；再轉到何薩，直通到海岸靠近亞革悉的地區； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","又有烏瑪、亞弗、利合，共二十二座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","這些城和屬於這些城的村莊，就是亞設支派按著家族所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","為拿弗他利人抽出第六籤，就是拿弗他利人按著家族所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","他們的疆界，是從希利弗，從撒拿音的橡樹林，從亞大米．尼吉和雅比聶起，去到拉共，直通到約旦河； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","又向西轉到亞斯納．他泊，從那裡伸展到戶割，南邊達到西布倫，西邊達到亞設，東邊達到約旦河那裡的猶大。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","設防的城有西丁、側耳、哈末、拉甲、基尼烈、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","亞大瑪、拉瑪、夏瑣、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","基低斯、以得來、隱．夏瑣、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","以利穩、密大．伊勒、和璉、伯．亞納、伯．示麥，共十九座城，還有屬於這些城的村莊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","這些城和屬於這些城的村莊，就是拿弗他利支派按著家族所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","為但支派，按著家族抽出第七籤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","他們產業的境界包括：瑣拉、以實陶、伊珥．示麥、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","沙拉賓、亞雅崙、伊提拉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","以倫、亭拿他、以革倫、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","伊利提基、基比頓、巴拉、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","伊胡得、比尼．比拉、迦特．臨門、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","美．耶昆、拉昆和約帕對面的地區。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","但人未能控制他們的境界，因此他們就上去攻打利善，奪取那城，用刀擊殺了城中的人；他們佔領利善，就住在城中，以他們祖先但的名字，把利善改名為但。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","這些城和屬於這些城的村莊，就是但支派按著家族所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","以色列人按著疆界把地分完了之後，就在他們中間把產業分給嫩的兒子約書亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","他們照著耶和華所吩咐的，把約書亞所要的城，就是以法蓮山地的亭拿．西拉，給了他；約書亞就修建那城，住在城中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","以上就是以利亞撒祭司和嫩的兒子約書亞，以及以色列人各支派的族長，在示羅會幕的門口，在耶和華面前，藉著抽籤所分的產業。這樣，他們就完成了分地的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","耶和華對約書亞說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“你要告訴以色列人：‘你們要照著我藉著摩西命令你們的，為自己設立避難城， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","好使那出於錯誤、並非蓄意殺人的，可以逃到那裡去；這些城要成為你們逃避報血仇的人的避難所。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","那殺人的要逃到這些城中的一座，站在城門口，把自己的事情向城中的眾長老述說，長老就要把他接入城中，到他們那裡，並要給他地方，使他可以住在他們中間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","如果報血仇的人追趕他，長老不可把他交在報血仇的人手裡，因為他並非蓄意殺人，他以前與他並沒有仇恨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","那殺人的要住在那城裡，直到他站在會眾面前受審；等到當時的大祭司死了，才可以回到本城本家，回到他逃出來的城那裡。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","於是以色列人在拿弗他利山地，把加利利的基低斯分別出來；在以法蓮山地，把示劍分別出來；在猶大山地，把基列．亞巴分別出來，基列．亞巴就是希伯崙； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","又在約旦河東，耶利哥的東面，從流本支派中，指定在曠野平原上的比悉；從迦得支派中，指定在基列的拉末；從瑪拿西支派中，指定在巴珊的哥蘭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","這些都是為所有的以色列人，和在他們中間寄居的外族人所指定的城，讓誤殺人的可以逃到那裡，不致死在報血仇的人手裡，直到他站在會眾面前受審為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","那時，利未人的眾族長來到以利亞撒祭司和嫩的兒子約書亞，以及以色列眾支派的族長那裡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","在迦南地的示羅對他們說：“耶和華曾經藉著摩西吩咐要給我們城市居住，和城的郊野可以牧放我們的牲畜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","於是以色列人照著耶和華所吩咐的，從自己的產業中，把以下這些城市和城的郊野，給了利未人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","首先為哥轄家族抽出籤來：利未支派亞倫祭司的子孫，從猶大支派、西緬支派和便雅憫支派，抽籤得了十三座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","哥轄其餘的子孫，從以法蓮支派的家族、但支派和瑪拿西半個支派，抽籤得了十座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","革順的子孫，從以薩迦支派的家族、亞設支派、拿弗他利支派和在巴珊的瑪拿西半個支派，抽籤得了十三座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","米拉利的子孫，按著家族，從流本支派、迦得支派和西布倫支派，得了十二座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","以色列人照著耶和華吩咐摩西的，藉著抽籤，把這些城市和城的郊野分給利未人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","他們從猶大支派和西緬支派中，把以下這些有提名的城分了 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","給利未支派、哥轄家族中亞倫的子孫，因為第一籤是他們的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","以色列人把猶大山地的基列．亞巴，和它四圍的郊野，給了他們；亞巴是亞衲族的祖宗，基列．亞巴就是希伯崙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","屬於那城的田地和村莊，他們卻給了耶孚尼的兒子迦勒作產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","以色列人把誤殺人者的避難城希伯崙，和希伯崙的郊野，又把立拿和立拿的郊野給了亞倫祭司的子孫， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","還有雅提珥和雅提珥的郊野，以實提莫和以實提莫的郊野， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","何崙和何崙的郊野，底璧和底璧的郊野， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","亞因和亞因的郊野，淤他和淤他的郊野，伯．示麥和伯．示麥的郊野，共九座城，都是從這兩個支派分出來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","又從便雅憫支派中，分給他們基遍和基遍的郊野，迦巴和迦巴的郊野， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","亞拿突和亞拿突的郊野，亞勒們和亞勒們的郊野，共四座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","亞倫子孫眾祭司所有的城，共十三座，還有這些城的郊野。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","利未支派哥轄子孫的家族，就是哥轄其餘的子孫，抽籤所得的城是從以法蓮支派中分出來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","以色列人把誤殺人者的避難城，就是在以法蓮山地的示劍和示劍的郊野，給了他們；又把基色和基色的郊野，給了他們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","又有基伯先和基伯先的郊野，伯．和崙和伯．和崙的郊野，共四座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","又從但支派中，給了他們伊利提基和伊利提基的郊野，基比頓和基比頓的郊野， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","亞雅崙和亞雅崙的郊野，迦特．臨門和迦特．臨門的郊野，共四座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","又從瑪拿西半個支派中，給了他們他納和他納的郊野，迦特．臨門和迦特．臨門的郊野，共兩座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","哥轄子孫其餘的家族所有的城共十座，還有這些城的郊野。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","以色列人又從瑪拿西半個支派中，把誤殺人者的避難城，就是在巴珊的哥蘭，和哥蘭的郊野，給了利未人的家族中革順的子孫；又給了他們比．施提拉和比．施提拉的郊野，共兩座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","又從以薩迦支派中，給了他們基善和基善的郊野，大比拉和大比拉的郊野， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","耶末和耶末的郊野，隱．干寧和隱．干寧的郊野，共四座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","又從亞設支派中，給了他們米沙勒和米沙勒的郊野，押頓和押頓的郊野， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","黑甲和黑甲的郊野，利合和利合的郊野，共四座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","以色列人又從拿弗他利支派中，把誤殺人者的避難城，就是在加利利的基低斯和基低斯的郊野，給了他們；又給他們哈末．多珥和哈末．多珥的郊野，加珥但和加珥但的郊野，共三座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","革順人按著家族所有的城共十三座，還有這些城的郊野。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","其餘的利未人，米拉利的子孫的家族，從西布倫支派中分得約念和約念的郊野，加珥他和加珥他的郊野， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","丁拿和丁拿的郊野，拿哈拉和拿哈拉的郊野，共四座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","又從流本支派中，給了他們比悉和比悉的郊野，雅雜和雅雜的郊野， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","基底莫和基底莫的郊野，米法押和米法押的郊野，共四座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","以色列人又從迦得支派中，把誤殺人者的避難城，就是在基列的拉末和拉末的郊野，給了他們；又給他們瑪哈念和瑪哈念的郊野， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","希實本和希實本的郊野，雅謝和雅謝的郊野，共四座城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","利未人其餘的家族，就是米拉利的子孫，按著家族抽籤所得的城，共有十二座。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","在以色列人的地業中，利未人所得的城共四十八座，還有這些城的郊野。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","這些城周圍都有自己的郊野，每一座都是這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","這樣，耶和華就把他從前起誓要賜給他們列祖的全地給了以色列人；以色列人佔領了那地，就定居下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","耶和華照著他向他們列祖起誓所說的一切話，使他們四境平靜；他們所有的仇敵，沒有一人能在他們面前站立得住；耶和華把他們所有的仇敵都交在他們手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","耶和華向以色列家應許賜福的話，沒有一句落空，都應驗了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","那時，約書亞把流本人、迦得人和瑪拿西半個支派的人召了來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","對他們說：“耶和華的僕人摩西吩咐你們的一切，你們都遵守了；我吩咐你們的一切，你們也都聽從了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","這許多日子以來，你們一直沒有撇棄你們的兄弟，直到今日；耶和華你們的　神吩咐你們的命令，你們也遵守了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","現在耶和華你們的　神，照著他應許的，已經使你們兄弟得享平安；現在你們可以返回自己家裡，回到耶和華的僕人摩西在約旦河東賜給你們作產業的地方去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","只是你們要謹慎遵守耶和華的僕人摩西吩咐你們的誡命和律法，愛耶和華你們的　神，遵行他的一切道路，謹守他的誡命，緊緊倚靠他，一心一意事奉他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","於是約書亞給他們祝福，打發他們回去，他們就回自己的家裡去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","摩西在巴珊已經把產業分給了瑪拿西半個支派；至於另外半個支派，約書亞在約旦河西他們的兄弟中間，也把產業分給了他們。約書亞打發他們回家去的時候，給他們祝福， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","對他們說：“你們帶著許多財物，許多牲畜和金、銀、銅、鐵，以及許多衣服，回自己的家去吧；也要把你們從仇敵奪得的戰利品與你們的兄弟同分。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","於是流本人、迦得人和瑪拿西半個支派的人，從迦南地的示羅起程，離開以色列人，回到他們所得的產業基列地去，就是照著耶和華藉著摩西所吩咐，賜給他們的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","流本人、迦得人和瑪拿西半個支派的人，來到迦南地靠近約旦河的地區，就在約旦河邊那裡築了一座祭壇，那壇十分壯觀。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","以色列人聽見了這事，就說：“看哪，流本人、迦得人和瑪拿西半個支派的人，在迦南地邊境，靠近約旦河的地區，以色列人境內，築了一座壇。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","以色列人聽見了這事，以色列全體會眾就聚集在示羅，要上去討伐他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","以色列人派以利亞撒祭司的兒子非尼哈，到基列地去見流本人、迦得人和瑪拿西半個支派的人； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","又派十個首領與非尼哈同去，每一個都代表以色列的支派家族；他們是全體以色列各家族的領袖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","他們去到基列地，流本人、迦得人和瑪拿西半個支派的人那裡，對他們說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“耶和華的全體會眾這樣說：‘你們作的是甚麼事？竟對以色列的　神不忠，今日轉離不跟從耶和華，為自己築了一座壇，背叛了耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","從前拜毗珥的罪孽，我們還以為是小事嗎？雖然有災疫臨到耶和華的會眾，直到今日我們還沒有洗淨這罪呢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","你們今日竟轉離不跟從耶和華嗎？今日你們既然背叛耶和華，明日他必向以色列全體會眾發怒了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","如果你們認為所得的地業不潔淨，你們可以過到耶和華的地業，就是耶和華的帳幕居住的地方，在我們中間得地業；只是不可背叛耶和華，也不可背叛我們，在耶和華我們的　神的壇以外，為自己築另一座壇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","從前謝拉的曾孫亞干，不是在當毀滅的物上犯了不忠的罪，以致　神的忿怒臨到以色列全體會眾嗎？因他的罪孽而死的，還不只他一人呢！’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","於是流本人、迦得人和瑪拿西半個支派的人回答以色列的統領說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“大能者　神耶和華！大能者　神耶和華，他是知道的，願以色列也知道；如果我們存心背叛，或是對耶和華不忠，今日就不要放過我們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","我們若是為自己築壇，轉離不跟從耶和華，或是把燔祭、素祭和平安祭獻在壇上，願耶和華親自追究我們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","我們作這事，實在是有理由的，因為顧慮將來你們的子孫對我們的子孫說：‘你們與耶和華以色列的　神有甚麼關係呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","流本人和迦得人啊，耶和華定了約旦河作我們和你們中間的疆界；你們與耶和華無分了。’這樣，你們的子孫就使我們的子孫不再敬畏耶和華了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","“因此我們說：‘我們築一座壇吧，不是為了獻燔祭，也不是為了獻別的祭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","而是為了在你們和我們中間，也在我們的後代中間作證據，使我們也可以在耶和華面前用燔祭、別的祭和平安祭事奉耶和華，免得你們的子孫將來對我們的子孫說：你們與耶和華無分了。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","因此我們說：‘將來有人對我們，或是對我們的後代這樣說，我們就可以回答：你們看我們列祖所築的壇，是耶和華的祭壇的模式，這並不是用來獻燔祭，也不是用來獻別的祭，而是在我們和你們中間作證據。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","我們決沒有背叛耶和華的意思，今日要轉離不跟從耶和華，在耶和華我們的　神的帳幕前的祭壇以外，另築一座壇，為了獻燔祭、素祭和別的祭。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","非尼哈祭司和會眾的領袖，以及與祭司同來的以色列的統領，聽了流本人、迦得人和瑪拿西人說的話，都很滿意。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","以利亞撒祭司的兒子非尼哈對流本人、迦得人和瑪拿西人說：“今天我們知道耶和華是在我們中間的，因為你們並沒有對耶和華不忠；現在你們已經救了以色列人脫離耶和華的手。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","以利亞撒祭司的兒子非尼哈和眾領袖離開了流本人和迦得人，從基列地回到迦南地以色列人那裡，把這事向他們報告。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","以色列人對這事都很滿意，就稱頌　神，不再說要上去討伐流本人和迦得人，毀滅他們所住的地方了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","流本人和迦得人給那壇起名叫證壇，因為他們說：“這壇在我們中間證明耶和華是　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","耶和華使以色列人得享平安，不受四圍仇敵的騷擾，已經有一段很長的日子；約書亞已經老了，年紀不小了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","約書亞就把全體以色列人、他們的長老、首領、審判官和官長，都召了來，對他們說：“我已經老了，年紀不小了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","耶和華你們的　神，因你們的緣故，向那些國家所行的一切事，你們都親眼看見了；因為耶和華你們的　神為你們作戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","你們看，剩下來的這些國家，連同我剪除的列國，從約旦河起，直到日落之處的大海，我都按著你們各支派，用抽籤的方式，分給你們作產業了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","耶和華你們的　神必把他們從你們面前趕出去，驅逐他們離開你們，你們就必得著他們的地作產業，正如耶和華你們的　神所應許的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","所以你們要十分堅強，謹守遵行寫在摩西律法書上的一切話，使你們不偏向左，不偏向右； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","使你們不與你們中間剩下的這些國家的人來往；他們的神的名字，你們不可提，不可指著他們起誓，不可事奉他們，也不可敬拜他們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","只要照著你們一直以來所行的，緊緊倚靠耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","因為耶和華已經把又大又強的列國從你們面前趕出去；至於你們，直到今日，還沒有一人能在你們面前站立得住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","你們一人可以追趕千人，因為耶和華你們的　神，照著他應許你們的，為你們作戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","你們自己要十分謹慎，愛耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","如果你們轉離耶和華，與你們中間剩下的這些國家的餘民聯絡，和他們通婚，互相來往， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","你們就必知道，耶和華你們的　神必不再把這些國家從你們面前趕出去；他們必要成為你們的網羅和陷阱，肋下的鞭和眼中的刺，直到你們從耶和華你們的　神賜給你們的這美地上滅亡為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“看哪，我今天要走世人必經的路了。你們清清楚楚（“清清楚楚”原文作“一心一意”）知道耶和華你們的　神應許賜福給你們的話，沒有一句落空；完全應驗在你們身上，沒有一句落空。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","耶和華你們的　神應許你們的一切福氣怎樣臨到你們身上，耶和華也必照樣使各樣的災禍臨到你們身上，直到把你們從耶和華你們的　神賜給你們的這美地上消滅為止。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","如果你們違背了耶和華你們的　神吩咐你們遵守的約，去事奉別的神，敬拜他們，耶和華必向你們大發烈怒，使你們從他賜給你們的美地上迅速滅亡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","約書亞在示劍召集以色列各支派，又把以色列的長老、首領、審判官和官長都召了來，他們就站在　神面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","約書亞對眾民說：“耶和華以色列的　神這樣說：‘古時你們的列祖，就是亞伯拉罕和拿鶴的父親他拉，住在大河那邊；他們事奉別的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","我把你們的祖先亞伯拉罕，從大河那邊帶來，領他走遍迦南地，使他的後裔增多，把以撒賜給他； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","又把雅各和以掃賜給以撒，把西珥山賜給以掃作產業；雅各和他的子孫卻下到埃及去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","我差派了摩西和亞倫，藉著我在埃及所行的神蹟，用災疫擊打埃及，然後把你們領出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","我領你們的列祖離開埃及，他們去到海邊；埃及人帶著戰車和馬兵，追趕你們的列祖直到紅海。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","你們的列祖呼求耶和華，他就以黑暗隔開你們和埃及人，又使海水復流淹沒了他們；我在埃及所行的事，你們都親眼見過；你們在曠野也住了許多日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","我領你們到了住在約旦河東的亞摩利人的地，他們和你們爭戰，我把他們交在你們手裡，你們就得了他們的地作產業；我也在你們面前把他們消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","那時摩押王西撥的兒子巴勒起來攻擊以色列人；他派人把比珥的兒子巴蘭召了來，咒詛你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","我不肯聽巴蘭的話，結果他反而一而再祝福你們；這樣，我就救了你們脫離他的手。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","你們過了約旦河，來到耶利哥；耶利哥的居民與你們作戰，還有亞摩利人、比利洗人、迦南人、赫人、革迦撒人、希未人、耶布斯人，也跟你們作戰；我把他們都交在你們手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","我派了黃蜂飛在你們前面，把亞摩利人的兩個王從你們面前趕走，並不是用你的刀，也不是用你的弓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","我賜給你們的土地，不是你們勞苦開墾的；我賜給你們的城市，不是你們建造的，你們卻住在城中；你們享用的葡萄園和橄欖園，也不是你們栽種的。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“現在你們要敬畏耶和華，真誠地按著真理事奉他，把你們列祖在大河那邊和在埃及事奉的神除掉，去事奉耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","如果你們認為事奉耶和華不好，那麼今日你們就可以選擇你們所要事奉的：是你們列祖在大河那邊事奉的神呢，還是你們現在所住亞摩利人之地的神呢？至於我和父家，我們必事奉耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","眾民回答：“我們絕對不會離棄耶和華，去事奉別的神； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","因為耶和華我們的　神把我們和我們的列祖，從埃及地為奴的家領出來，並且在我們眼前行了那些偉大的神蹟；又在我們所行的一切路上，和我們經過的一切民族中間，他都保護了我們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","耶和華又把所有的民族和住在這地的亞摩利人，都從我們面前趕走；所以我們必事奉耶和華，因為他是我們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","約書亞對眾民說：“你們不能事奉耶和華，因為他是聖潔的　神；他是嫉妒的　神，他必不赦免你們的過犯和罪惡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","如果你們離棄耶和華，去事奉外族人的神，那麼在耶和華賜福給你們之後，他必轉而降禍與你們，把你們消滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","眾民對約書亞說：“不，我們必定事奉耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","約書亞對眾民說：“你們選擇了耶和華，要事奉他，你們為自己作證吧。”他們說：“我們願意作證。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","約書亞說：“現在你們要除掉在你們中間外族人的神，一心歸向耶和華以色列的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","眾民對約書亞說：“我們必事奉耶和華我們的　神，必聽從他的話。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","那一天，約書亞就與眾民立約，在示劍為他們訂立律例和典章。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","約書亞把這些話都寫在　神的律法書上；又拿一塊大石頭，立在耶和華聖所旁邊的橡樹下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","約書亞對全體人民說：“看哪，這塊石頭可以向我們作證，因為它聽見了耶和華對我們所說的一切話；所以這塊石頭要向你們作證，免得你們否認你們的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","於是約書亞打發眾民各自回到自己的地業去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","這些事以後，耶和華的僕人、嫩的兒子約書亞死了，那時他是一百一十歲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","以色列人把他埋葬在他自己地業的境內，就是在以法蓮山地上的亭拿．西拉，在迦實山的北邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","約書亞在世的日子，和約書亞死後，那些知道耶和華為以色列人所行的一切事的長老還在世的日子，以色列人都事奉耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","以色列人從埃及帶出來的約瑟骸骨，葬在示劍的一塊田裡；這塊田是雅各從前用一百塊銀子向示劍的父親哈抹的子孫那裡買來的；這塊田就成了約瑟子孫的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","亞倫的兒子以利亞撒也死了；以色列人就把他埋葬在基比亞，就是他兒子非尼哈在以法蓮山地所得的產業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","約書亞死後，以色列人求問耶和華說：“誰要為我們首先去攻打迦南人，與他們作戰呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","耶和華回答：“猶大要先上去，看哪，我已經把那地交在他手中。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","猶大對自己的兄弟西緬說：“請你與我一同上我抽籤所得的地業去，我們好與迦南人交戰；以後我也與你一同到你抽籤所得的地業去。”於是西緬與他一同去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","猶大上去了；耶和華就把迦南人和比利洗人交在他們手中；他們在比色擊殺了一萬人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","他們在那裡遇見了比色王，就與他交戰，擊殺了迦南人和比利洗人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","比色王逃跑；他們追趕他，把他捉住，砍去了他手腳的大拇指。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","比色王說：“從前有七十個王，手腳的大拇指都被我砍去，在我的桌子底下拾取食物；現在　神照著我所行的，報應我了。”於是他們把他帶到耶路撒冷，後來他就死在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","猶大人攻打耶路撒冷，把城佔領，用刀擊殺了城中的居民，又放火燒城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","後來，猶大人下去，與住在山地、南地和高原的迦南人交戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","猶大人又去攻擊住在希伯崙的迦南人，殺了示篩、亞希幔和撻買；希伯崙從前名叫基列．亞巴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","他們從那裡又去攻擊底璧的居民；底璧從前名叫基列．西弗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","迦勒說：“誰能攻打基列．西弗，把城攻取，我就把我的女兒押撒給他作妻子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","迦勒的弟弟基納斯的兒子俄陀聶攻取了那城，迦勒就把自己的女兒押撒給他作妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","押撒出嫁的時候，她勸俄陀聶向她父親求一塊田；押撒一下驢，迦勒就對她說：“你要甚麼？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","她回答：“請你給我一份禮物；你既然把我安置在南地，求你也把水泉賜給我。”迦勒就把上泉和下泉都給了她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","摩西岳父的子孫基尼人，和猶大人一同離開棕樹城，上到亞拉得以南的猶大曠野去，住在那裡的人民中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","猶大與他的兄弟西緬同去，擊殺了住在洗法的迦南人，把那城完全毀滅。那城的名字就叫何珥瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","猶大又攻取了迦薩和迦薩的四境，亞實基倫和亞實基倫的四境，以革倫和以革倫的四境。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","耶和華與猶大同在，猶大就佔領了山地；但不能趕走平原的居民，因為他們有鐵車。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","猶大照著摩西的吩咐，把希伯崙給了迦勒；迦勒就從那裡趕走亞衲子孫的三族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","便雅憫人沒有趕走住在耶路撒冷的耶布斯人，所以耶布斯人與便雅憫人一同住在耶路撒冷，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","約瑟家也上去攻打伯特利；耶和華與他們同在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","約瑟家派人去窺探伯特利。那城從前的名字叫路斯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","窺探的人看見一個人從城裡出來，就對他說：“請你把進城的路指示我們，我們必恩待你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","那人把進城的路指示了他們，他們就用刀擊殺了那城的居民，卻把那人和他的全家都放走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","那人到赫人之地去了，築了一座城，給它起名叫路斯；直到今日那城還叫這名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","瑪拿西沒有趕走伯．善和屬於伯．善的鄉村的居民，他納和屬於他納的鄉村的居民，多珥和屬於多珥的鄉村的居民，以伯蓮和屬於以伯蓮的鄉村的居民，米吉多和屬於米吉多的鄉村的居民；迦南人決意住在那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","到以色列強盛了，就迫使迦南人作苦工，但沒有把他們完全趕走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","以法蓮也沒有把住在基色的迦南人趕走，於是迦南人還住在基色，在以法蓮中間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","西布倫沒有把基倫的居民和拿哈拉的居民趕走；於是迦南人還住在西布倫中間，成了作苦工的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","亞設沒有把亞柯的居民和西頓的居民趕走，也沒有把亞黑拉、亞革悉、黑巴、亞弗革和利合的居民趕走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","於是亞設人住在當地的居民迦南人中間，因為他們沒有把他們趕走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","拿弗他利沒有把伯．示麥的居民和伯．亞納的居民趕走；於是他們就住在當地的居民迦南人中間；伯．示麥和伯．亞納的居民成了給他們作苦工的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","亞摩利人強迫但人退回山地上，不容他們下到平原來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","亞摩利人決意住在希烈山、亞雅倫和沙賓；但約瑟家的勢力強大以後，他們就成了作苦工的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","亞摩利人的境界，是從亞克拉濱山坡，從西拉直上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","耶和華的使者從吉甲上到波金來，說：“我曾經把你們從埃及領上來，帶你們到我向你們列祖起誓應許的地方；我曾說過：‘我永不廢棄我與你們所立的約； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","你們不可與這地的居民立約，要拆毀他們的祭壇。’你們竟沒有聽從我的話；你們作的是甚麼呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","因此我又說：‘我必不把他們從你們面前趕走，他們要作你們的敵人，他們的神要作你們的網羅。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","耶和華的使者對以色列眾人說這些話的時候，眾人就放聲大哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","於是給那地方起名叫波金；他們在那裡向耶和華獻祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","約書亞遣散了眾人，以色列人就各歸自己承受的地業，要佔有那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","約書亞在世的時候，以及他去世以後，那些見過耶和華為以色列人所行的大事的眾長老還在的日子，眾人都事奉耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","耶和華的僕人，嫩的兒子約書亞，在一百一十歲的時候就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","以色列人把他埋葬在他地業的境內，就是以法蓮山地，在迦實山北面的亭拿．希烈。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","那一代的人都歸到他們的列祖那裡以後，有另一代的人興起來了；他們不認識耶和華，也不知道耶和華為以色列人所行的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","以色列人行了耶和華看為惡的事，去事奉眾巴力； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","他們離棄了領他們出埃及的耶和華、他們列祖的　神，去跟從別的神，就是他們周圍各族的神，敬拜他們，惹耶和華發怒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","他們離棄了耶和華，去事奉巴力和亞斯他錄。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","耶和華的怒氣向以色列人發作，就把他們交在搶掠的人手中，他們就搶掠他們；他又把他們完全交在他們四圍的仇敵手中，以致他們在仇敵面前再不能站立得住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","他們無論去哪裡，耶和華的手總是加害他們，好像耶和華說過的，又像耶和華對他們起誓過的；他們就非常困苦。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","耶和華興起了士師，士師就拯救他們脫離搶掠他們的人的手。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","但他們連士師也不聽從，竟與別的神行了姦淫，敬拜他們；他們迅速偏離了他們列祖所行、聽從耶和華命令的道路，他們沒有照樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","耶和華為他們興起士師的時候，耶和華就與那士師同在；那士師在世的日子，耶和華總是拯救他們脫離仇敵的手；因為他們在壓迫和苦害他們的人底下發出哀聲，耶和華就憐憫他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","可是士師死了以後，他們就轉而行惡，比他們的列祖更厲害，去隨從別的神，事奉和敬拜他們，總不放棄他們的惡行和頑梗的行徑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","於是耶和華的怒氣向以色列人發作，說：“因為這國的人違背我吩咐他們列祖的約，不聽從我的話， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","因此，約書亞死後仍剩下來的列國，我也不再從他們面前趕走， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","為要藉著他們試驗以色列人，看他們肯不肯謹守遵行耶和華的道路，像他們的列祖一樣謹守。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","這樣，耶和華留下這些國的民，不迅速把他們趕走，也不把他們交在約書亞手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","這些國的人是耶和華留下的，為要藉著他們來試驗以色列人，就是所有沒有經驗過迦南任何戰爭的人； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","好使以色列人的後代，那些以前沒有經驗過這些戰爭的人，知道學習爭戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","他留下的就是非利士人的五個首領，和所有迦南人、西頓人，以及住在黎巴嫩山上的希未人，從巴力．黑門山直到哈馬口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","他們留在那裡，為要藉著他們試驗以色列人，要知道他們是否聽從耶和華藉摩西吩咐他們列祖的誡命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","以色列人就住在迦南人、赫人、亞摩利人、比利洗人、希未人、耶布斯人中間； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","他們娶他們的女兒作妻子，也把自己的女兒嫁給他們的兒子，並且事奉他們的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","以色列人行了耶和華看為惡的事，忘記了耶和華他們的　神，去事奉眾巴力和亞舍拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","因此，耶和華的怒氣向以色列人發作，把他們完全交在兩河之間的亞蘭王古珊．利薩田的手中；以色列人服事了古珊．利薩田八年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","以色列人向耶和華哀求的時候，耶和華就為以色列人興起一位拯救者拯救他們，就是迦勒的弟弟基納斯的兒子俄陀聶。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","耶和華的靈臨到他身上，他就治理以色列人；他出去作戰，耶和華把亞蘭王古珊．利薩田交在他手中，他的能力就勝過了古珊．利薩田。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","於是國中太平了四十年。後來基納斯的兒子俄陀聶死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","以色列人又行了耶和華看為惡的事，耶和華就使摩押王伊磯倫強盛起來，欺壓以色列人，因為他們行了耶和華看為惡的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","伊磯倫集合了亞捫人和亞瑪力人，前來擊敗了以色列人，佔領了棕樹城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","於是以色列人服事了摩押王伊磯倫十八年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","以色列人向耶和華哀求的時候，耶和華就為他們興起一位拯救者，就是便雅憫人基拉的兒子以笏，是一個用左手的人。以色列人派他把貢物送給摩押王伊磯倫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","以笏做了一把兩刃的劍，長半公尺，縛在右腿上，在衣服底下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","他把貢物呈獻給摩押王伊磯倫；伊磯倫原是個非常肥胖的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","以笏獻完了貢物，就把抬貢物的眾人打發走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","自己卻從靠近吉甲的眾雕像那裡回來，說：“王啊，我有一件機密的事要對你說。”王說：“暫不要說。”侍立左右的人都離開他出去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","以笏來到王那裡；王獨自一人坐在涼樓上。以笏說：“我有　神的話要告訴你。”王就從座位上站起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","以笏就伸出左手，從右腿上拔出劍來，刺入王的腹中； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","連劍柄與劍身都刺進去了，肥肉把劍身夾住，因此他沒有把劍從王的肚腹裡拔出來；接著他就從窗戶爬了出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","以笏出到走廊，把涼樓上的門關起來，上了鎖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","以笏出來以後，王的僕人才來到；他們看見涼樓上的門鎖著，就說：“王一定是在涼樓上大解。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","他們等到發慌了，見他還不打開涼樓的門，就拿鑰匙來開；不料，看見他們的主人早已倒在地上死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","他們耽延的時候，以笏已經逃跑了；他經過眾雕像那裡，逃到西伊拉去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","他去到以後，就在以法蓮山地吹角；以色列人與他一同從山地上下來，他走在他們前頭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","對他們說：“你們跟隨我，因為耶和華已經把你們的仇敵摩押人交在你們手中。”他們就跟隨他下去，攻取約旦河的渡口，攔截摩押人，不讓一個過去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","那時他們擊殺了約有一萬摩押人，都是強壯的、勇猛的人，沒有一人逃脫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","這樣，從那天起，摩押就在以色列人的手下被制伏了，於是國中太平了八十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","以笏之後，有亞拿的兒子珊迦；他用趕牛棒擊殺了六百非利士人；他也拯救了以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","以笏死後，以色列人又行了耶和華看為惡的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","因此耶和華把他們交在迦南王耶賓手中，耶賓那時在夏瑣作王；他的軍長西西拉，住在夏羅設歌印。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","耶賓王有鐵車九百輛，他極力欺壓以色列人二十年，以色列人就哀求耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","有一位女先知底波拉，是拉比多的妻子，那時正治理以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","她常坐在以法蓮山地，拉瑪和伯特利之間那棵底波拉棕樹下；以色列人都上到她那裡去聽判斷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","底波拉派人去從拿弗他利的基低斯，把亞比挪菴的兒子巴拉召了來，對他說：“耶和華以色列的　神不是曾吩咐你說：‘你去向他泊山進軍，從拿弗他利人和西布倫人中率領一萬人與你同去嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","我必引耶賓的軍長西西拉，和他的車輛與全軍，到基順河往你那裡去；我必把他們交在你手裡。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","巴拉對她說：“如果你與我同去，我就去；如果你不與我同去，我就不去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","底波拉回答：“我必與你同去，只是你這次行程就沒有光榮；因為耶和華要把西西拉交在一個婦人手裡。”於是底波拉起來，與巴拉一同到基低斯去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","巴拉就召集西布倫人和拿弗他利人到基低斯；與他一同步行上去的有一萬人，底波拉也與他一同上去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","摩西的岳父何巴的子孫基尼人希伯，曾經離開基尼族人，到靠近基低斯的撒拿音的橡樹旁，支搭帳棚居住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","有人告訴西西拉，亞比挪菴的兒子巴拉已經上了他泊山； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","西西拉就召集他所有的車輛，就是九百輛鐵車，和與他在一起的眾人，都從夏羅設歌印出來，到基順河那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","底波拉對巴拉說：“你起來吧，因為今日就是耶和華把西西拉交在你手裡的日子；耶和華不是在你前面出戰嗎？”於是巴拉和跟隨他的一萬人從他泊山下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","耶和華用刀使西西拉和所有的車輛與全軍，都在巴拉面前潰亂；西西拉下了車，步行逃跑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","巴拉追趕西西拉的車輛和軍隊，直到夏羅設歌印；西西拉的全軍都倒在刀下，連一個也沒有留下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","只有西西拉步行逃跑，到了基尼人希伯的妻子雅億的帳棚那裡；因為夏瑣王耶賓與基尼人希伯的家友好。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","雅億出來迎接西西拉，對他說：“請我主轉過來，到我這裡，不要懼怕。”西西拉就轉到她那裡去，就是轉到她的帳棚裡去；雅億就用毛氈遮蓋他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","西西拉對雅億說：“請給我一點水喝，因為我渴了。”雅億就打開盛奶的皮袋，給他喝了，再把他蓋著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","西西拉又對雅億說：“請你站在帳棚門口，如果有人來問你：‘這裡有人嗎？’你就要回答：‘沒有。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","希伯的妻子雅億取了一根帳棚的橛子，手裡拿著鎚子，靜悄悄地走到西西拉那裡，把橛子釘在他的太陽穴裡，直釘入地裡；因為西西拉疲乏熟睡，就這樣死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","那時，巴拉追趕西西拉，雅億出來迎接他，對他說：“來吧，我給你看你尋找的人。”他就進到她那裡去；看見西西拉已經仆倒，死了；橛子還在他的太陽穴裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","這樣，　神就在那一天，在以色列人面前，制伏了迦南王耶賓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","以色列人的勢力日漸強盛，勝過迦南王耶賓，終於把迦南王耶賓除滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","那一天，底波拉和亞比挪菴的兒子巴拉唱起歌來說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","“你們要稱頌耶和華，因為以色列中有勇士，因為有人民自願從軍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","君王啊，你們要聽；官長啊，你們要側耳傾聽；至於我，我要向耶和華歌唱；我要歌頌耶和華以色列的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","耶和華啊，你從西珥出發的時候，你從以東地行走的日子，地震天漏，密雲也滴下雨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","群山在耶和華面前震動；這西奈山在耶和華以色列的　神面前也是這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","在亞拿的兒子珊迦的時候，在雅億的日子，大道無人行走，行路的人繞道而行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","以色列中的農村消失了，消失了，直到我底波拉興起，直到我以色列的母親興起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","以色列人選擇了新的神，戰爭就臨近城門；那時四萬以色列人中，竟不見有一面盾牌、一枝長矛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","我的心傾向以色列的官長，他們在民中甘願犧牲自己；你們要稱頌耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","騎白驢的，坐錦墊的，和路上的行人，你們都要歌唱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","在打水的地方分開羊群的人發聲，在那裡人必歌頌耶和華公義的作為，就是他在以色列中的農村所行公義的作為；那時，耶和華的子民下到城門口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","興起，興起，底波拉！興起，興起，唱歌吧！興起，巴拉！亞比挪菴的兒子，擄掠你的俘虜吧！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","那時餘剩的貴胄下來；耶和華帶著勇士下到我這裡來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","他們出自以法蓮，他們的根在亞瑪力人之地；有便雅憫在你的族人中跟隨你，有官長從瑪吉下來；有持著數點民數之權杖的，從西布倫出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","以薩迦的領袖與底波拉在一起；以薩迦怎樣，巴拉也怎樣；他們都步行下到山谷去。在流本的眾溪旁，有心懷大志的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","你為甚麼坐在羊圈之中，聽呼喚群畜的笛聲呢？在流本的眾溪旁，有心懷大志的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","基列人在約旦河東邊居住；但人為甚麼居留在船上呢？亞設人在海岸坐著，在港灣居住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","西布倫人是敢死的民族；拿弗他利人在田野的高處，奮不顧身。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","眾王都來爭戰；那時迦南眾王爭戰，在米吉多水亭的他納爭戰，卻沒有取得銀錢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","眾星從天上爭戰，從它們的軌道與西西拉交戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","基順河的急流把他們沖沒，古河的急流、基順河的急流，我的心哪，你要努力踐踏。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","那時馬蹄沓沓，勇士急奔飛馳。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","耶和華的使者說：‘你們要咒詛米羅斯，大大咒詛其中的居民；因為他們不來幫助耶和華，不帶領勇士幫助耶和華。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","願基尼人希伯的妻子雅億，比眾婦女更有福氣，比住在帳棚的婦女更有福氣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","西西拉求水，雅億給了奶；用珍貴的盤子奉上乳酪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","她伸手拿著帳棚的橛子，右手拿著匠人的鎚子，擊打西西拉，打破他的頭，粉碎他的頭顱，貫穿他的鬢角。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","西西拉在雅億腳前屈身、仆倒、躺臥，在雅億腳前屈身、仆倒；他在那裡屈身，就在那裡仆倒死亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","西西拉的母親從窗戶裡向外觀望，從窗櫺中呼叫說：‘他的戰車為甚麼遲遲不來呢？車輪為甚麼行得緩慢呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","聰明的宮女回答她；她也自己回答說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","‘莫非他們正在分戰利品？每個勇士分得一兩個女子；西西拉得了彩衣作戰利品，得了一兩件繡花的彩衣作戰利品，為我的頸項，得著繡花的彩衣作戰利品嗎？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","耶和華啊，願你所有的仇敵都這樣滅亡；願愛他的人像太陽出現，大有能力。”於是國中太平了四十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","以色列人又行了耶和華看為惡的事；耶和華就把他們交在米甸人手裡七年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","米甸人的勢力勝過以色列人；以色列人因米甸人的緣故，就為自己在山上挖穴、挖洞，建營寨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","每逢以色列人撒種以後，米甸人、亞瑪力人和東方人都上來，欺壓他們； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","對著他們安營，毀壞那地的出產，直到迦薩一帶，他們沒有留下牛、羊和驢，沒有給以色列人留下一點養生之物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","因為他們帶著牲畜和帳棚上來，像蝗蟲那麼多；他們來的人和駱駝無數，進入境內，毀壞全地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","以色列人在米甸人面前，落到極卑微的地步，他們就哀求耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","以色列人因米甸人的緣故，向耶和華呼求的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","耶和華就差派一位先知到以色列人那裡，對他們說：“耶和華以色列的　神這樣說：‘我曾經把你們從埃及領上來，領你們出了為奴之家； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","我曾經把你們從埃及人的手拯救出來，拯救你們脫離所有欺壓你們的人的手，把他們從你們面前趕走，把他們的地賜給你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","我又對你們說：我是耶和華你們的　神；你們住在亞摩利人的地，不可敬畏他們的神。但你們沒有聽從我的話。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","耶和華的使者來到，坐在俄弗拉，一棵屬於亞比以謝族人約阿施的橡樹下；約阿施的兒子基甸正在壓酒池裡打麥子，為要躲避米甸人的搶奪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","耶和華的使者向基甸顯現，對他說：“大能的勇士啊，耶和華與你同在。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","基甸回答他，說：“唉，我的主，如果耶和華與我們同在，我們怎會遭遇這一切事呢？我們的列祖向我們講述的，耶和華的一切奇事在哪裡呢？他們曾說：‘耶和華不是把我們從埃及領上來嗎？’現在他卻拋棄了我們，把我們交在米甸人手中！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","耶和華轉向基甸，對他說：“你靠著你這能力，去拯救以色列人脫離米甸人的手吧；我不是差派了你嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","基甸對他說：“唉，我主啊，我憑著甚麼拯救以色列人呢？看哪，我的家族在瑪拿西支派中是最卑微的，我在我的父家是最年輕的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","耶和華對他說：“因為我必與你同在，你就必擊打米甸人，像擊打一人一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","基甸又對他說：“如果我在你眼前蒙恩，求你給我一個憑據，證實是你與我說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","求你不要離開這裡，等我回來，把我的禮物帶來，擺在你面前。”他回答：“我必等你回來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","基甸去預備了一隻山羊羔，和十公斤麵粉做的無酵餅，把肉放在籃子裡，把湯盛在鍋中，帶到橡樹之下，獻上給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","神的使者對基甸說：“把肉和無酵餅拿出來，擺在這塊磐石上，把湯倒出來。”他就這樣行了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","耶和華的使者伸出手中的杖，杖頭一觸著肉和無酵餅，就有火從磐石中上來，把肉和無酵餅都燒盡了；耶和華的使者就從基甸的眼前消失了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","基甸看出他是耶和華的使者，就說：“哀哉，我主耶和華啊，因為我面對面看見了耶和華的使者。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","耶和華對他說：“你放心好了，不要怕，你必不會死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","基甸就在那裡給耶和華築了一座祭壇，稱為耶和華沙龍；直到今日，這壇還在亞比以謝族的俄弗拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","當夜，耶和華對基甸說：“取你父親的牛和另一頭七歲大的牛來，拆毀你父親的巴力祭壇，砍下壇旁的亞舍拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","在這堅固的地方上面，你要整整齊齊為耶和華你的　神築一座祭壇，拿第二頭牛作燔祭，用你砍下來的亞舍拉作柴。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","基甸就從他的僕人中選出了十個人，照著耶和華告訴他的行了；但因為害怕他的父家和城裡的人，就不敢在日間行事，只好在晚上作了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","城裡的人清早起來，見巴力的祭壇已被拆毀，壇旁的亞舍拉也被砍下來，並且看見那第二頭牛獻在新築的祭壇上的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","就彼此說：“誰作了這事呢？”他們追查尋訪之後，就說：“是約阿施的兒子基甸作的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","城裡的人對約阿施說：“把你的兒子領出來，把他處死，因為他拆毀了巴力的祭壇，砍下了壇旁的亞舍拉。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","約阿施對所有站著攻擊他的人說：“你們要為巴力辯護嗎？或是你們要救他呢？誰為他辯護，到早晨就必死亡。巴力若是神，有人拆毀了他的祭壇，就讓他為自己辯護吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","因此，當日基甸被稱為耶路．巴力，意思說：他拆毀了巴力的祭壇，讓巴力與他爭辯吧。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","那時，米甸人、亞瑪力人和東方人，都聚集起來，過了河，在耶斯列平原安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","耶和華的靈降在基甸身上，他就吹角；亞比以謝族都應召來跟從他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","他派使者到瑪拿西全地去，瑪拿西人也都應召來跟從他；他又派使者到亞設、西布倫、拿弗他利去，他們也都上來與他們會合。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","基甸對　神說：“如果你按著你所說的，要藉著我的手拯救以色列人； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","看哪，我要把一團新剪的羊毛放在禾場上；露水若是單單落在羊毛上，而全地都是乾的，我就知道你要照著你所說的，藉著我的手拯救以色列了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","第二天，基甸清早起來，情形果然是這樣；他把羊毛一擠，就從羊毛中擠出一滿盆的露水來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","基甸又對　神說：“求你不要向我發怒，我要再說這一次；求你讓我把羊毛再試一試，但願單單羊毛是乾的，而全地都有露水。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","那一夜，　神也這樣行了；單單羊毛是乾的，全地都有露水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","耶路．巴力，就是基甸，和所有與他在一起的人，清早起來，在哈律泉旁安營；米甸營就在他們的北面，靠近摩利山岡的平原上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","耶和華對基甸說：“與你在一起的人太多，我不能把米甸人交在你們手中，免得以色列人向我自誇：‘是我們自己的手救了我們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","現在你要向眾民宣告：‘害怕戰慄的，可以回去，離開基列山。’”於是眾民中有二萬二千人回去，只剩下一萬人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","耶和華對基甸說：“人還是太多，你要領他們下到水旁去，我要在那裡為你試驗他們。我指著誰對你說：‘這人可以與你同去’，他就可以與你同去；我指著誰對你說：‘這人不可以與你同去’，他就不可以與你同去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","於是基甸帶他們下到水邊去；耶和華對基甸說：“用舌頭舔水，像狗舔水的，你要把他們安置在一處；屈膝跪下喝水的，也要把他們安置在一處。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","用手捧到嘴邊舔水的，總數共有三百人；其餘的人都屈膝跪下喝水。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","耶和華對基甸說：“我要用這舔水的三百人拯救你們，把米甸人交在你們的手裡，所有其他的人都可以各回自己的地方去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","於是眾民手裡拿著食物和號角；所有其他的以色列人，基甸都打發他們各回自己的帳棚去，只留下這三百人。當時米甸營就在他們下面的平原裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","當夜，耶和華對基甸說：“起來，下去攻營，因為我已經把他們交在你手裡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","如果你害怕一人下去，可以帶著你的童僕普拉一同下到營地那裡去； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","你要聽聽他們說甚麼，然後你的手就必堅強起來，有膽量下去攻營了。”於是基甸帶著他的童僕普拉一同下去，到營中駐軍的邊緣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","那時米甸人、亞瑪力人和所有的東方人，都散布在平原上，好像蝗蟲那麼多；他們的駱駝無數，好像海邊的沙那麼多。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","基甸到了，就聽見一個人正在把他的夢告訴他的同伴，說：“我作了一個夢，夢見一個大麥餅滾入米甸營中，到了帳幕，把帳幕撞倒，帳幕就翻轉朝上了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","他的同伴回答：“這不是別的，這是以色列人約阿施的兒子基甸的刀；　神已經把米甸和全營交在他手中了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","基甸聽見了這夢的敘述和夢的講解，就敬拜　神；然後返回以色列營中，說：“起來，因為耶和華已經把米甸的軍隊交在你們手裡了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","於是他把三百人分作三隊，把角和空瓶交在各人手裡，又把火把放在瓶裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","然後對他們說：“你們要看著我，也要照樣行事。注意！我到了營的邊緣，我怎樣行事，你們也要怎樣行事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","我和所有與我在一起的人吹角的時候，你們也要在全營的四周吹角，喊叫說：‘為耶和華！為基甸！’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","基甸和所有與他在一起的一百人，在半夜三更的起初，換更的時候，來到了營的邊緣，就吹起角來，打破手中的瓦瓶。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","三隊的人就都吹角，打破瓦瓶，左手緊握著火把，右手緊握著角不住地吹，並且喊叫說：“耶和華和基甸的刀！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","他們在營的四周各站在自己的位置；全營的人都亂跑，他們一面叫喊，一面逃跑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","三百人吹那三百枝角的時候，耶和華使全營的人用刀互相擊殺，然後他們向著西利拉逃到伯．哈示他，直到靠近他巴的亞伯．米何拉河邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","以色列人就從拿弗他利、亞設和瑪拿西全地被召來，追趕米甸人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","基甸派遣了使者走遍以法蓮山地，說：“你們要下來迎戰米甸人，在他們前面把守約旦河的渡口，直到伯．巴拉。”於是以法蓮的人都被召來，把守約旦河的渡口，直到伯．巴拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","他們捉住了米甸人的兩個首領：俄立和西伊伯；把俄立殺在俄立磐石上，把西伊伯殺在西伊伯榨酒池那裡；然後追趕米甸人，又把俄立和西伊伯的人頭帶到約旦河對岸，基甸那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","以法蓮人對基甸說：“你去與米甸人爭戰的時候，沒有召我們同去，你為甚麼這樣待我們呢？”他們就與他激烈地爭辯起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","基甸對他們說：“我所行的怎能比得上你們呢？在以法蓮拾取剩下的葡萄，不是比在亞比以謝收摘的葡萄更好嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","神已經把米甸人的兩個首領：俄立和西伊伯，交在你們的手裡了；我所行的怎能與你們相比呢？”基甸說了這話，他們的怒氣就平息了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","基甸來到約旦河，就過了河；他和與他在一起的三百人雖然都很疲乏，仍然追趕敵人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","基甸對疏割人說：“求你們把幾個餅給跟隨我的人吃，因為他們疲乏了，我還要繼續追趕米甸人和兩個王西巴和撒慕拿。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","疏割人的首領回答：“西巴和撒慕拿現在不是已經在你的手裡嗎？我們應該把餅送給你的軍隊吃嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","基甸說：“好吧，耶和華把西巴和撒慕拿交在我手裡的時候，我就必用野地的荊棘鞭打你們的身體。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","基甸從那裡上到毗努伊勒，也向他們說了同樣的話；毗努伊勒人回答他也像疏割人回答的一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","他亦對毗努伊勒人說：“我平平安安回來的時候，我必拆毀這座望樓。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","那時，西巴和撒慕拿正在加各，與他們在一起的軍隊約有一萬五千人，就是東方人全營剩下的，因為有十二萬持刀的已經倒下了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","基甸就從挪巴和約比哈東面，順著住帳棚的人的路上去；在敵軍以為安全而不戒備的時候，擊敗了敵軍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","西巴和撒慕拿逃跑；基甸追趕他們，捉住了米甸人的兩個王西巴和撒慕拿，使全軍都驚惶。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","約阿施的兒子基甸從戰場沿著希列斯的山坡回來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","捉住了疏割人中的一個青年人，查問他；他就把疏割的首領和長老的名字寫給他，共七十七人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","基甸到了疏割人那裡，就說：“你看，西巴和撒慕拿，你們為了他們曾經譏笑我說：‘西巴和撒慕拿現在不是在你的手裡嗎？我們應該把餅送給你那些疲乏的人吃嗎？’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","於是拿住那城的長老，又拿起野地的荊棘，用荊棘把疏割人教訓了一頓； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","又拆毀了毗努伊勒的望樓，殺死了那城裡的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","基甸問西巴和撒慕拿：“你們在他泊山上所殺的人，是甚麼模樣的人？”他們回答：“他們像你一樣，每一個都像王子的模樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","基甸說：“他們是我的兄弟，是我母親的兒子；我指著永活的耶和華起誓，如果你們從前讓他們存活，我現在就不殺你們了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","於是對他的長子益帖說：“起來，把他們殺了吧。”但是那孩子不敢拔刀，只是害怕，因為他還是個孩子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","西巴和撒慕拿說：“你親自起來殺我們吧；因為人怎樣，他的力量也怎樣。”於是基甸起來，把西巴和撒慕拿殺了，拿了他們駱駝頸項上的月牙圈。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","以色列人對基甸說：“你既然拯救我們脫離了米甸人的手，求你和你的子孫統治我們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","基甸回答他們：“我不統治你們，我的子孫也不統治你們，唯有耶和華統治你們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","基甸又對他們說：“我有一個要求：請把你們各人奪得的耳環給我。”原來敵人都戴金耳環，因為他們是以實瑪利人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","他們回答：“我們願意給你。”於是鋪開一件外衣，各人把奪得的耳環丟在上面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","基甸所要的金耳環，共重約二十公斤金子，此外還有米甸王身上的月牙圈、耳墜和紫紅色的衣服，另外還有駱駝頸項上的鍊子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","基甸用這些金子做了一個以弗得，安置在他的城俄弗拉；後來以色列眾人都在那裡隨從以弗得行了邪淫，因此這就成了基甸和他全家的網羅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","這樣，米甸人在以色列人面前就被制伏了，不能再抬起頭來；基甸在世的日子，國中太平了四十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","約阿施的兒子耶路．巴力回去，住在自己家裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","基甸有七十個兒子，都是他親生的，因為他有很多妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","他在示劍的妾，也給他生了一個兒子，他給他起名叫亞比米勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","約阿施的兒子基甸壽數滿足而死，埋葬在亞比以謝族的俄弗拉，在他父親約阿施的墳墓裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","基甸死了以後，以色列人又轉去隨從眾巴力，行邪淫，並且以巴力．比利土作他們的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","以色列人忘記了耶和華他們的　神，就是曾經拯救他們脫離四圍仇敵之手的那位； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","也沒有照著基甸向以色列人所施的一切恩惠，恩待耶路．巴力，就是基甸的家。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","耶路．巴力的兒子亞比米勒，到示劍去見他的眾母舅，對他們和他母親的全體族人說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","“請你們給示劍的眾人說：‘是耶路．巴力的眾子七十人都統治你們好呢？還是一個人統治你們好呢？’你們也要記得我是你們的骨肉。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","他的眾母舅就把這一切話為他說給示劍的眾人聽；他們的心都傾向亞比米勒，因為他們說：“他本是我們的親族。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","他們就從巴力．比利土的廟裡，取了八百克銀子給亞比米勒，亞比米勒用這些銀子雇了一些無賴流氓，那些人就跟隨了他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","他回到俄弗拉他父親的家，把自己的兄弟，耶路．巴力的眾子七十人，都殺在一塊石頭上；只剩下耶路．巴力的小兒子約坦，因為他藏了起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","示劍的眾人和伯特米羅人都聚集起來，到示劍橡樹旁的望樓那裡，立亞比米勒為王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","有人把這事告訴了約坦，約坦就去，站在基利心山頂上，高聲向他們呼喊，說：“示劍人哪，你們要聽我的話，　神也就聽你們的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","有一次，眾樹要去膏立一個王統治它們，就對橄欖樹說：‘請你作王統治我們吧。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","橄欖樹對它們說：‘我怎可以放棄生產人用來榮耀　神和尊崇人的油，飄搖在眾樹之上呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","眾樹對無花果樹說：‘請你來作王統治我們吧。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","無花果樹對它們說：‘我怎可以放棄結出我的甜美果子，飄搖在眾樹之上呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","眾樹對葡萄樹說：‘請你來作王統治我們吧。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","葡萄樹對它們說：‘我怎可以放棄生產那使　神和世人都喜樂的新酒，飄搖在眾樹之上呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","於是眾樹都對荊棘說：‘請你來作王統治我們吧。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","荊棘對眾樹說：‘如果你們真誠地膏立我作王統治你們，就要來，投靠在我的蔭下；否則，火必從荊棘裡出來，吞滅黎巴嫩的香柏樹。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","“現在你們立亞比米勒為王，你們若是誠實和正直，如果你們善待耶路．巴力和他的家，照著他手所作的待他； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","我父親從前冒死為你們爭戰，把你們從米甸人手中救了出來； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","今日你們竟起來攻擊我的父家，在一塊石頭上殺了他七十個兒子，又立了他的婢女所生的兒子亞比米勒作示劍人的王，因為他原是你們的親族。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","今日你們若是按著誠實和正直待耶路．巴力和他的家，你們就可以因亞比米勒得喜樂，亞比米勒也可以因你們得喜樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","若不是這樣，願火從亞比米勒出來，吞滅示劍人和伯特米羅人；又願火從示劍人和伯特米羅人出來，吞滅亞比米勒。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","接著約坦就逃跑了；他逃到比珥去，住在那裡，躲避他的兄弟亞比米勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","亞比米勒治理以色列人三年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","神差派邪惡的靈來到亞比米勒與示劍人中間，示劍人就背棄了亞比米勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","這是要報復對耶路．巴力七十個兒子的暴行，把流他們血的罪歸到他們的兄弟亞比米勒身上，就是那殺害他們的；也歸到示劍人身上，就是那些幫助亞比米勒去殺他自己的兄弟的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","示劍人在山頂上設下埋伏，路過他們那裡的，他們都劫掠；有人把這事告訴亞比米勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","那時，以別的兒子迦勒與他的兄弟都來了，到示劍去，示劍人竟信任他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","他們出到田間去，收取葡萄，榨酒，舉行慶祝會，進入他們的神廟吃喝，並且咒詛亞比米勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","以別的兒子迦勒說：“亞比米勒是誰？示劍是誰？竟要我們服事他呢？他不是耶路．巴力的兒子嗎？他的副官不是西布勒嗎？你們要服事示劍的始祖哈抹的後人啊；我們為甚麼要服事亞比米勒呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","但願這些人民都歸在我手下，我好把亞比米勒除掉。”迦勒又對亞比米勒說：“增添你的軍隊出來吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","那城的首長西布勒聽了以別的兒子迦勒的話，他的怒氣就發作， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","祕密差派使者去見亞比米勒，說：“以別的兒子迦勒和他的兄弟已經到了示劍，他們正在煽動那城的人反叛你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","現在，你和與你在一起的人，要在夜間起來，在野地埋伏。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","到了早晨，太陽出來的時候，你就要起來攻城；你要注意，迦勒和與他在一起的人出來對抗你的時候，你就把握機會對付他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","於是亞比米勒和與他在一起的人，都在夜間起來，分作四隊，埋伏著等候示劍人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","以別的兒子迦勒出去，站在城門口；亞比米勒和與他在一起的人，從埋伏的地方起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","迦勒看見了那些人，就對西布勒說：“你看，有人從山頂上下來。”西布勒說：“你看見山的影子以為是人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","迦勒又說：“看哪，有人從高地下來，又有一隊從米惡尼尼橡樹的路徑而來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","西布勒對他說：“你曾經說過：‘亞比米勒是誰，竟要我們服事他呢？’現在你說這話的嘴在哪裡呢？這不是你輕視的人嗎？現在請你出去與他們交戰吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","於是迦勒在示劍人面前出去，與亞比米勒爭戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","亞比米勒追趕迦勒，迦勒在他面前逃跑，直到城門口，有很多受傷的人仆倒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","亞比米勒住在亞魯瑪；西布勒把迦勒和他的兄弟趕走，不許他們住在示劍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","次日，城中眾人出到田間去，有人把這事告訴亞比米勒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","亞比米勒就把他的人分作三隊，埋伏在田間；他在那裡觀看，見有人從城裡出來，就起來攻擊他們，把他們擊殺了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","亞比米勒和與他在一起的一隊人忽然衝過去，站在城門口；其他兩隊人也衝出來攻打所有在田間的人，把他們擊殺了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","那一天，亞比米勒整天攻打那城，把城攻下了，殺了城中的眾人；把城拆毀，又撒上鹽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","示劍樓的眾人聽見了這事，就逃入伊勒．比利土廟的地穴裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","有人告訴亞比米勒，說：“示劍樓所有的人都聚集在一起。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","亞比米勒和與他在一起的人都上了撒們山；亞比米勒手裡拿著斧子，砍下一根樹枝，拿起來放在自己的肩頭上，然後對與他在一起的人說：“你們看我作甚麼，你們也要趕快照樣作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","於是眾人也各自砍下一根樹枝，跟隨著亞比米勒，把樹枝放在地穴上，放火燒了地穴，以致示劍樓的人都死了，男女約有一千人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","後來亞比米勒到提備斯去，安營攻打提備斯，攻取了那城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","城中有一座堅固的城樓；那城所有的人，無論男女，都逃到那裡去，關上門，上了樓頂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","亞比米勒到了城樓前，攻打城樓；他走近城樓門口，要用火焚燒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","有一個婦人把一塊上磨石拋在亞比米勒的頭上，打破了他的頭蓋骨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","他急忙呼喊替他拿兵器的少年人，對他說：“拔出你的刀來，把我殺死吧。免得人講論我說：‘他被一個婦人所殺。’”於是那少年人把他刺透，他就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","以色列人看見亞比米勒死了，就各回自己的地方去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","這樣，　神報應了亞比米勒向他父親所行的惡事，就是他殺了自己的兄弟七十個人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","神也把示劍人的一切惡事，都報應在他們的頭上；耶路．巴力的兒子約坦的咒詛，也歸到他們身上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","亞比米勒之後，有以薩迦人朵多的孫子，普瓦的兒子陀拉，興起拯救以色列人；他住在以法蓮山地的沙密。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","陀拉治理以色列人二十三年，就死了，埋葬在沙密。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","在他之後，有基列人睚珥興起治理以色列人二十二年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","他有三十個兒子，騎著三十頭驢駒；他們有三十座城，叫作哈倭特．睚珥，直到今日都是在基列地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","睚珥死了以後，就埋葬在加們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","以色列人又行了耶和華看為惡的事，服事眾巴力和亞斯他錄，以及亞蘭的神、西頓的神、摩押的神、亞捫人的神、非利士人的神；他們離棄了耶和華，不再服事他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","耶和華的怒氣向以色列人發作，就把他們交在非利士人的手中和亞捫人的手中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","從那一年起，他們就迫害欺壓以色列人，就是所有在約旦河東邊，住在亞摩利人之地的以色列人，共十八年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","亞捫人又渡過約旦河去攻打猶大、便雅憫和以法蓮家，以色列人就非常困苦。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","以色列人向耶和華哀求，說：“我們得罪了你，因為我們離棄了我們的　神，服事眾巴力。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","耶和華對以色列人說：“我不是曾經拯救你們脫離埃及人、亞摩利人、亞捫人和非利士人嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","西頓人、亞瑪力人、馬雲人也都壓迫你們；你們向我哀求，我也拯救你們脫離他們的手。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","你們竟離棄了我，服事別的神，因此我不再拯救你們了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","你們去向你們揀選的神呼求吧！讓他們在你們遭遇患難的時候拯救你們吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","以色列人對耶和華說：“我們犯了罪了，你任意對待我們吧；只求你今日拯救我們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","以色列人就從他們中間除去外族人的神，事奉耶和華；耶和華的心因以色列人所受的患難，就很著急。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","當時亞捫人聚集起來，在基列安營；以色列人也聚集，在米斯巴安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","基列的人民和眾領袖彼此說：“誰先去攻打亞捫人，誰就可以作基列所有居民的首領。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","基列人耶弗他是個英勇的戰士；他是個妓女的兒子；耶弗他是基列所生的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","基列的妻子也給他生了幾個兒子。他妻子的兒子長大了，就把耶弗他趕出去，對他說：“你不可以在我們的父家繼承產業，因為你是另一個婦人的兒子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","耶弗他就從他的兄弟面前逃跑，住在陀伯地；有些無賴聚集到他那裡，與他一起出入。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","過了些日子，亞捫人與以色列人爭戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","亞捫人與以色列人爭戰的時候，基列的眾長老就去，把耶弗他從陀伯請回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","他們對耶弗他說：“請你來作我們的統帥，我們好攻打亞捫人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","耶弗他對基列的長老說：“從前你們不是恨我，趕逐我離開我的父家嗎？現在你們遭遇患難的時候，為甚麼到我這裡來呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","基列的長老對耶弗他說：“現在我們回到你這裡來，是要你與我們一同回去，與亞捫人爭戰，你要作我們基列所有居民的首領。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","耶弗他對基列的長老說：“如果你們帶我回去，攻打亞捫人，耶和華把他們交在我面前，那麼我就可以作你們的首領嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","基列的長老對耶弗他說：“有耶和華在我們中間作證，我們必定照著你的話行。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","於是耶弗他與基列的長老一同回去了，眾人就立耶弗他作他們的首領，作他們的統帥；耶弗他在米斯巴，在耶和華面前，把自己的一切話都說了出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","耶弗他派遣使者去見亞捫人的王，說：“我跟你有甚麼關係呢？你竟到我這裡來攻打我的土地呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","亞捫人的王對耶弗他的使者說：“因以色列人從埃及上來的時候，奪了我的土地，從亞嫩河到雅博河，直到約旦河；現在你要把它和和平平地交還。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","耶弗他又再派使者去見亞捫人的王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","對他說：“耶弗他這樣說：‘以色列人並沒有奪取過摩押地和亞捫人的土地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","以色列人從埃及上來的時候，是走過曠野到紅海，到了加低斯； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","就派遣使者去見以東王，說：求你讓我們經過你的領土。以東王卻不答應；又派遣使者去見摩押王，摩押王也不肯；以色列人就住在加低斯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","以後，他們走過曠野，繞過以東地和摩押地，到了摩押地的東邊，在亞嫩河那邊安營；他們並沒有進入摩押境內，因為亞嫩河是摩押的邊界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","以色列人又派遣使者去見亞摩利人的王西宏，就是希實本王，對他說：求你讓我們經過你的領土，到我們自己的地方去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","西宏卻不信任以色列人，不讓他們經過他的境界；西宏聚集了他所有的人民，在雅雜安營，與以色列人爭戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","耶和華以色列的　神，把西宏和他所有的人民都交在以色列人手中，以色列人擊殺了他們，奪取了住在那地的亞摩利人的全地， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","佔領了亞摩利人四周的境界，從亞嫩河到雅博河，從曠野直到約旦河。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","現在耶和華以色列的　神，已經把亞摩利人從他的子民以色列人面前趕走了，你竟要佔有這地嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","你不是應佔有你的神基抹要你佔有的地嗎？我們不是應佔有耶和華我們的　神，從我們面前趕走的人的一切地嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","現在難道你比摩押王西撥的兒子巴勒還強嗎？他曾經與以色列人爭競嗎？或是與以色列人交戰過嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","以色列人住在希實本和屬希實本的村鎮，亞羅珥和亞羅珥的村鎮，以及亞嫩河沿岸的一切城市，已經有三百年了；在這時期內，你們為甚麼沒有奪回這些地方呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","我沒有得罪你，你竟惡待我，攻打我；願審判者耶和華今日在以色列人和亞捫人中間，判斷是非。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","但亞捫人的王不聽從耶弗他差派人去對他所說的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","那時耶和華的靈臨到耶弗他身上，他就經過基列和瑪拿西，經過基列的米斯巴，又從基列的米斯巴去到亞捫人那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","耶弗他向耶和華許願，說：“如果你真的把亞捫人交在我手裡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","我從亞捫人那裡平平安安回來的時候，無論誰先從我的家門出來迎接我，他就必歸耶和華，我也必把他當作燔祭。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","於是耶弗他去到亞捫人那裡攻打他們，耶和華把他們交在他手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","於是他從亞羅珥開始擊殺他們，去到米匿，直到亞備勒．基拉明，共二十座城，是一場大擊殺；這樣，亞捫人就在以色列人面前被制伏了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","耶弗他回米斯巴去，到了自己的家，不料，他的女兒拿著鼓、跳著舞，出來迎接他；她是耶弗他的獨生女，除她以外，耶弗他沒有其他的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","耶弗他看見了她，就撕裂自己的衣服，說：“啊！我的女兒啊，你真使我憂愁，你叫我太作難了；因為我已經向耶和華開過口許願，我不能收回。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","她對他說：“我的父親啊，你既然向耶和華開過口許了願，就照著你口裡所說的向我行吧！因為耶和華已經在你的仇敵亞捫人身上，為你報了仇。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","她又對自己的父親說：“請你准我這件事吧：給我兩個月時間，讓我和我的同伴去漫遊山間，為我的童貞哀哭。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","耶弗他說：“你去吧！”就讓她離去兩個月；她就帶著她的同伴去了，在山上為她的童貞哀哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","兩個月後，她回到她的父親那裡，她父親就照他所許的願向她行了。她沒有與男人同過房。以後，在以色列中有個慣例： ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","以色列的女子年年都去哀悼基列人耶弗他的女兒，每年四日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","以法蓮人聚集起來，過河到了撒分，對耶弗他說：“你過去攻打亞捫人的時候，為甚麼沒有召我們與你同去呢？我們要用火燒掉你和你的房屋。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","耶弗他對他們說：“我和我的人民跟亞捫人激烈爭戰的時候，我曾經呼求你們，你們卻沒有來救我們脫離他們的手。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","我見你們不來拯救我，我就拚命上去攻擊亞捫人，耶和華就把他們交在我的手裡。你們今日為甚麼上我這裡來攻打我呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","於是耶弗他召集了基列所有的人，與以法蓮人爭戰；基列人擊殺了以法蓮人，因為以法蓮人曾經說過：“你們基列人在以法蓮和瑪拿西中間，不過是以法蓮逃亡的人罷了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","基列人佔領約旦河的各渡口，不容以法蓮人過去。如果以法蓮逃亡的人說：“讓我過去吧。”基列人就問他：“你是以法蓮人嗎？”如果他說：“不是。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","基列人就對他說：“請說‘示播列’。”以法蓮人因為發不出準確的字音，就說成“西播列”；基列人就把他捉住，在約旦河的渡口那裡殺了；那時以法蓮人死了四萬二千人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","耶弗他治理以色列人共六年；基列人耶弗他死了以後，埋葬在基列的一座城裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","耶弗他之後，有伯利恆人以比讚治理以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","他有三十個兒子，三十個女兒；女兒都嫁到外面去，又給他的兒子從外面娶了三十個女子作妻子。他治理以色列人共七年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","以比讚死了，就埋葬在伯利恆。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","以比讚之後，有西布倫人以倫，治理以色列人共十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","西布倫人以倫死了以後，就埋葬在西布倫地的亞雅崙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","以倫之後，有比拉頓人希列的兒子押頓治理以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","他有四十個兒子，三十個孫子，騎著七十頭驢駒；押頓治理以色列人共八年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","比拉頓人希列的兒子押頓死了，埋葬在以法蓮地，就是在亞瑪力人的山地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","以色列人又行了耶和華看為惡的事，耶和華就把他們交在非利士人手中四十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","那時有一個瑣拉人，是屬於但支派的，名叫瑪挪亞；他的妻子不能生育，沒有孩子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","耶和華的使者向那婦人顯現，對她說：“你向來不能生育，沒有孩子，現在你必要懷孕，生一個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","現在你要謹慎，清酒或烈酒都不可喝，各樣不潔的東西也不可吃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","看哪！你必懷孕，生一個兒子；不可用剃刀剃他的頭，這孩子從在母腹開始就歸　神作拿細耳人；他必拯救以色列人脫離非利士人的手。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","婦人就回去，告訴她的丈夫說：“有一位神人到我這裡來，他的容貌像　神使者的容貌，非常可畏，我沒有問他從哪裡來，他也沒有告訴我他的名字。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","他對我說：‘你必要懷孕，生一個兒子；現在清酒或烈酒你都不可喝，各樣不潔的東西你也不可吃，因為這孩子從在母腹開始，一直到死，都必歸耶和華作拿細耳人。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","瑪挪亞就懇求耶和華，說：“啊，主啊，求你叫你派來的神人再到我們這裡吧！好指教我們要怎樣對待將要生下來的孩子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","神聽了瑪挪亞的聲音。婦人正坐在田間的時候，　神的使者又來到她那裡，她的丈夫瑪挪亞卻沒有與她在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","婦人急忙跑去告訴丈夫，對他說：“那天到我這裡來的那人，又向我顯現了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","瑪挪亞起來，跟著他的妻子出去，來到那人跟前，問他：“你就是向這個婦人說過話的人嗎？”他回答：“我就是。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","瑪挪亞說：“你的話應驗的時候，這孩子的生活方式怎樣？他要作甚麼呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","耶和華的使者對瑪挪亞說：“我對婦人所說的一切話，她都要謹守。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","從葡萄樹所產的，她都不可吃；清酒或烈酒，她都不可喝；各樣不潔的東西，她也不可吃；我吩咐她的，她都要謹守。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","瑪挪亞對耶和華的使者說：“請留下，好讓我為你預備一隻山羊羔。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","耶和華的使者對瑪挪亞說：“你雖然要我留下，我卻不吃你的食物；如果你預備燔祭，就當獻給耶和華。”原來瑪挪亞還不知道他是耶和華的使者。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","瑪挪亞問耶和華的使者：“你叫甚麼名字？到你的話應驗的時候，我們好把尊榮歸你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","耶和華的使者對他說：“你為甚麼問我的名字呢？我的名是奇妙的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","瑪挪亞取了一隻山羊羔和素祭，在磐石上獻與那行奇事的耶和華；瑪挪亞和他的妻子一直在觀看。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","火燄從祭壇上往天升起的時候，耶和華的使者在祭壇上的火燄中也升上去了；瑪挪亞和他的妻子看見了，就俯伏在地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","耶和華的使者沒有再向瑪挪亞和他的妻子顯現，那時瑪挪亞才知道他是耶和華的使者。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","瑪挪亞對他的妻子說：“我們必定要死，因為我們看見了　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","他的妻子卻對他說：“如果耶和華有意要殺我們，就必不從我們的手裡接納燔祭和素祭，也必不會把這一切事指示我們，更不會在這個時候向我們宣布這些事啊。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","後來那婦人生了一個兒子，她就給他起名叫參孫；孩子漸漸長大了，耶和華賜福給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","在瑪哈尼．但（“瑪哈尼．但”意即“但的軍營”），就是在瑣拉和以實陶中間，耶和華的靈開始感動參孫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","參孫下到亭拿，在亭拿看見了一個女子，是一個非利士人的女兒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","參孫上來告訴他的父母，說：“我在亭拿看見一個女子，是一個非利士人的女兒；現在請你們把她娶來給我作妻子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","他的父母對他說：“在你兄弟的女兒中，或是在你所有的族人中，難道沒有一個女子，以致你要去從那些未受割禮的非利士人中娶妻呢？”參孫對他的父親說：“請你把她娶來給我，因為我看中她。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","他的父母卻不知道這事是出於耶和華，因為他正在找機會攻擊非利士人。那時非利士人正統治著以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","參孫跟他的父母下到亭拿去，到了亭拿的葡萄園；忽然見一隻少壯獅子向他吼叫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","耶和華的靈大大感動參孫，他雖然手裡沒有武器，竟把獅子撕裂，像人撕裂山羊羔一樣；他沒有把他所作的這事告訴他的父母。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","參孫下去，和那女子說話，就看中了她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","過了些日子，參孫回去迎娶那女子，他轉向一旁去看看那隻死了的獅子；看見有一群蜂子和一些蜂蜜在獅子的屍體內。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","他刮了些蜂蜜，放在手裡，就走了；他一面走，一面吃，直走到他的父母那裡去；他又把蜂蜜給了他們，他們也吃了；但是他沒有告訴他們這蜂蜜是從獅子的屍體內刮下來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","參孫的父親下去見那女子，參孫在那裡擺設了筵席，因為青年人都慣常這樣行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","眾人看見參孫，就請了三十個人陪伴他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","參孫對他們說：“現在讓我給你們出一個謎語，你們在七天婚宴之內，如果能猜出來，把它的意思清楚告訴我，我就給你們三十件內衣、三十套衣服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","如果你們不能告訴我，你們就要給我三十件內衣、三十套衣服。”他們對他說：“請你把謎語說給我們聽。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","參孫對他們說：“可吃的從吃者出來；甜的從強者出來。”他們過了三日都不能說出謎語的意思。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","到了第四天，他們對參孫的妻子說：“你要引誘你的丈夫，使他把謎語的意思告訴我們，否則我們用火燒你和你的父家。難道你們請了我們來，是要奪取我們所有的嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","參孫的妻子在丈夫面前哭哭啼啼，說：“你只是恨我，不是愛我；你給我的族人設謎語，卻沒有把謎語的意思告訴我。”參孫對她說：“連我父母我都沒有告訴，怎能告訴你呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","在那七天婚宴期內，她在丈夫跟前常常哭哭啼啼；到了第七天，因為她催逼著參孫，參孫才告訴她；於是她把謎語的意思告訴她的族人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","到了第七天太陽未落以前，城裡的人就對參孫說：“有甚麼比蜂蜜還甜呢？有甚麼比獅子還強呢？”參孫對他們說：“你們若不是用我的母牛犢耕田，你們就不會猜出我的謎語的意思來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","耶和華的靈大大感動參孫，參孫就下到亞實基倫，擊殺了他們中間三十個人，拿了剝下來的衣服，把三十套衣服給了那些把謎語的意思說出來的人；參孫怒氣沖沖地上自己的父家去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","參孫的妻子卻歸了一個陪伴參孫的人，就是作過他伴郎的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","過了些日子，到收割麥子的時候，參孫帶著一隻山羊羔去看他的妻子；他心裡說：“我要進內室去見我的妻子。”但是他妻子的父親不讓他進去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","她父親說：“我以為你非常恨她，所以我把她給了你的一個同伴；她的妹妹不是比她更美麗嗎？你可以娶來代替她啊。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","參孫對他們說：“這次如果我加害非利士人，就可以不必負責了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","於是參孫去捉了三百隻狐狸，又拿了火把來，把狐狸尾巴對尾巴縛在一起，又把一枝火把插在兩條尾巴中間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","他點著了火把，就放狐狸進入非利士人的禾田裡，把堆積的禾捆，和未割的禾稼，以及橄欖園都燒了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","非利士人問：“這是誰作的呢？”有人回答：“是亭拿人的女婿參孫作的，因為他岳父把他的妻子給了他的同伴。”於是非利士人上去，放火燒了那女子和她的父親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","參孫對他們說：“你們既然這樣行，我必在你們身上報仇，然後才肯罷休。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","參孫擊打他們，連腿帶腰都砍斷了，那是一場極大的殺戮；然後他下去，住在以坦磐石的穴中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","非利士人上去，在猶大安營，在利希散開。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","猶大人說：“你們為甚麼上來攻打我們呢？”他們說：“我們上來是要捆綁參孫，要報復他向我們所行的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","於是有三千猶大人下到以坦磐石的穴中去，對參孫說：“非利士人統治我們，你不知道嗎？你為甚麼向我們行這事呢？”參孫對他們說：“他們怎樣待我，我也怎樣待他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","猶大人對他說：“我們下來要捆綁你，把你交在非利士人手裡。”參孫對他們說：“你們要向我發誓，你們不親自殺害我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","他們告訴他說：“我們不會殺害你，我們只要把你捆綁住，交在非利士人手裡，我們決不殺死你。”於是他們用兩條新繩子把參孫捆綁起來，從磐石的穴裡把他帶上來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","參孫來到利希，非利士人就吶喊著出來迎接他，耶和華的靈大大臨到參孫身上，他臂上的繩子就像被火燒的麻一樣，他的捆綁都從他的手上落下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","他找著一塊新鮮的驢腮骨，就伸手拾起來，擊殺了一千人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","參孫說：“我用驢腮骨殺人成堆；我用驢腮骨擊殺了一千人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","說完了，就把那腮骨從手裡拋出去，因此那地方就叫拉末．利希（“拉末．利希”意即“腮骨的山”）。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","參孫非常口渴，就呼求耶和華說：“你既然藉著你僕人的手施行這麼大的拯救，現在我怎可以渴死，落在未受割禮的人手中呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","於是　神在利希使一窪地裂開，就有水從那裡湧出來；參孫喝了，就恢復精神，活力充足；因此那泉名叫隱．哈歌利（“隱．哈歌利”意即“呼求者之泉”），那泉直到今日還在利希。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","在非利士人統治的日子，參孫治理以色列人二十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","參孫往迦薩去，在那裡看見一個妓女，就進去與她親近。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","有人告訴迦薩人說：“參孫到這裡來了。”他們就把他圍住，整夜在城門口埋伏著，整夜默不作聲，心裡說：“等到早晨天亮，我們才殺他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","參孫睡到半夜，就在半夜起來，抓緊城門的門扇和兩邊門柱，把它們與門閂一起拔起來，放在自己的肩頭上，扛到希伯崙對面的山頂去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","後來參孫在梭烈谷又愛上了一個婦人，名叫大利拉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","非利士人的領袖上到婦人那裡去，對她說：“請你引誘他，看看他因甚麼緣故有這樣大的力氣，我們用甚麼方法才能勝過他，把他捆綁，好制伏他；我們每人就給你十二公斤銀子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","大利拉對參孫說：“求你告訴我，你因甚麼緣故有這樣大的力氣，要用甚麼方法才能捆綁你，好把你制伏。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","參孫對她說：“如果人用七條未乾的青繩子捆綁我，我就會軟弱無力，像平常人一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","於是非利士人的領袖把七條未乾的青繩子，帶上來給那婦人，她就用那些繩子把參孫捆綁起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","有人埋伏在她的內室裡等候著；她對參孫說：“參孫哪，非利士人上來捉你了！”參孫就掙斷繩子，像麻線被火燒斷一樣。這樣，他力氣的由來，還是沒有人知道。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","大利拉對參孫說：“你作弄我，向我說謊；現在求你告訴我，用甚麼東西才能把你捆綁。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","參孫對她說：“如果人用從未使用過的新繩子把我緊緊地捆綁起來，我就軟弱無力，像平常人一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","於是大利拉把新繩子拿了來，把參孫捆綁了，對他說：“參孫哪，非利士人上來捉你了！”當時有人埋伏在她的內室裡等候著。參孫把繩子從手臂上掙斷下來，像掙斷一根線一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","大利拉對參孫說：“到現在你還是作弄我，向我說謊；求你告訴我，人怎樣才能捆綁你。”參孫對她說：“如果你把我頭上的七條髮辮與織布機上的緯線編織在一起就可以了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","於是大利拉把他的髮辮與織布機上的緯線同織在一起，再用木橛釘緊，對參孫說：“參孫哪，非利士人上來捉你了！”參孫從睡夢中醒來，竟把織布機上的木橛，和緯線都拔了出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","大利拉對參孫說：“你既然對我不真心，你怎能說：‘我愛你’？你這三次作弄我，沒有告訴我你這麼大的力氣是哪裡來的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","大利拉天天用話逼他，催他，以致他的心煩得要死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","參孫就把他心中的一切告訴了她，對她說：“向來沒有人用剃刀剃過我的頭，因為我自出母胎就歸　神作拿細耳人，如果人剃去我的頭髮，我的力氣就離開了我，我就軟弱無力，像所有人一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","大利拉見參孫把心中的一切都告訴了她，就派人去請非利士人的領袖來，說：“這一次你們上來吧！因為他已經把心中的一切都告訴了我。”於是非利士人的領袖上到婦人那裡，手裡帶著銀子上去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","大利拉使參孫睡在自己的膝上，又叫了一個人來，把參孫頭上的七條髮辮都剃去；大利拉就克制了他，因他的力氣離開了他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","大利拉說：“參孫哪，非利士人上來捉你了！”參孫從睡夢中醒來，心裡說：“我要像前幾次一樣掙扎出去，必能脫身。”但他不知道耶和華已經離開他了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","非利士人把他捉住，剜去了他的眼睛，帶他下到迦薩，用銅鍊捆綁著他，他就在監牢裡推磨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","但是他的頭髮被剃去以後，又開始生長起來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","非利士人的領袖聚集起來，要給他們的神大袞獻大祭，並且歡樂慶祝；他們說：“我們的神把我們的仇敵參孫交在我們手中了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","眾人看見了參孫，就讚美他們的神，說：“我們的神把我們的仇敵，就是那毀壞我們的地，又殺死我們很多人的，交在我們手中了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","他們心裡正在高興的時候，就說：“叫參孫來，給我們耍耍把戲。”於是有人把參孫從監牢裡叫出來；參孫就在他們面前耍把戲，他們又把他放在兩根柱子中間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","參孫對拉著他手的童子說：“請你讓我摸摸支撐著這廟宇的柱子，我要在柱子上靠一靠。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","那時房子裡滿了男男女女，非利士人的領袖也在那裡；在房子的平頂上約有三千男女，都在觀看參孫耍把戲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","參孫呼求耶和華，說：“主耶和華啊，求你記念我；　神啊，求你加強我這一次的力量，只這一次罷了，使我盡一次在非利士人身上報那剜我雙眼的仇！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","參孫就抱住那支撐著房子中間的兩根柱子，右手抱一根，左手抱一根。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","然後參孫說：“讓我與非利士人同歸於盡吧！”於是盡力屈身，房子就倒塌，壓在眾領袖和房子裡所有的人身上。這樣，參孫死的時候殺死的人，比他活著的時候殺死的人還多。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","參孫的眾兄弟和他父親的全家都下來，收殮他的屍體，把他抬上去，埋葬在瑣拉和以實陶之間，在他父親瑪挪亞的墳墓裡。參孫治理了以色列人二十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","以法蓮山地有一個人，名叫米迦。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","他對自己的母親說：“你那十二公斤銀子被人拿去了，關於這事你曾說了咒詛的話，我也親自聽見了。看哪！那些銀子在我這裡，是我拿去了。”他母親說：“願我兒蒙耶和華賜福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","米迦就把那十二公斤銀子歸還給他母親；他母親說：“我把這些銀子從我手中分別為聖，為我的兒子歸給耶和華，好做一個雕像，一個鑄像；現在，我要還給你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","米迦把銀子還給他母親以後，他母親取出二千三百克銀子交給銀匠，製造一個雕像和一個鑄像，都放在米迦的家裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","米迦這人有一間神廟，又製造以弗得和家中的神像，並且立了他的一個兒子作祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","在那些日子，以色列中沒有王，各人都行自己看為對的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","有一個猶大伯利恆的青年人，是屬猶大家族的；他本是個利未人，在那裡寄居。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","這人離開猶大的伯利恆城，要找一個可以寄居的地方；途中，他到了以法蓮山地，米迦的家那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","米迦問他：“你是從哪裡來的？”他回答米迦：“我是個利未人，是從猶大的伯利恆來的，我來要找一個可以寄居的地方。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","米迦對他說：“你與我住在一起吧，作我的師父和祭司；我每年給你一百一十四克銀子、一套衣服和食用。”利未人就進了米迦的家。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","他同意與那人同住；那人看待這青年人好像自己的一個兒子一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","米迦立了這利未青年作他的祭司，住在米迦的家裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","米迦說：“現在我知道耶和華必善待我，因為有一個利未人作我的祭司。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","在那些日子，以色列中沒有王。那時，但支派還在尋找可居住的地業，因為直到那一天，在以色列的眾支派中，但支派仍沒有得著地業。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","於是但人從瑣拉和以實陶，差派他們家族中的五個勇士，去窺探查察那地，對他們說：“你們去查察那地吧。”他們來到以法蓮山地，進了米迦的家，就在那裡住宿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","他們在米迦的家附近，認出那青年利未人的口音來，就過去他那裡問他：“誰帶你到這裡來？你在這裡作甚麼？你在這裡有甚麼？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","他回答他們：“米迦如此這般待我；他雇了我，我就作了他的祭司。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","他們對他說：“請你求問　神，使我們知道我們要走的道路是否順利。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","祭司對他們說：“你們平安地去吧，你們要走的道路是蒙耶和華悅納的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","於是那五個人離開了，來到拉億，看見那裡的人民安然居住，好像西頓人一樣，生活平靜安穩；在那地又沒有人掌權，使他們受屈辱；他們離西頓人也很遠，也沒有與別人來往。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","他們回到瑣拉和以實陶自己的族人那裡去；族人問他們：“你們有甚麼話說？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","他們回答：“起來，我們上去攻擊他們吧。因為我們已經看過那地，見那地十分美好，你們還靜坐不動嗎？不可再遲延，要趕快去取得那地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","你們到了那裡的時候，你們必遇見安然居住的人民；那地的兩邊寬闊，　神已經把那地交在你們手裡；那地百物俱全，一無所缺。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","於是但人的家族中有六百人，帶著兵器從那裡出發，就是從瑣拉和以實陶出發。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","他們上去，在猶大的基列．耶琳安營；因此人把那地方叫作瑪哈尼．但（“瑪哈尼．但”意即“但的軍營”），直到現在；這地方是在基列．耶琳的西邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","他們從那裡經過，往以法蓮山地去，來到米迦的家。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","從前去窺探拉億地的五個人，對他們的族人說：“這些屋子裡有以弗得、神像、雕像和鑄像，你們知道嗎？現在你們要考慮一下應該怎樣行。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","於是他們五人轉身，進入米迦的家，來到那青年利未人的屋裡，向他問安。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","那六百但人，帶著兵器，都站在門口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","從前去窺探那地的五個人上前，進入裡面，把雕像、以弗得、神像和鑄像都拿去了；祭司和帶著兵器的六百人都站在門口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","當那五個人進了米迦的家，拿走雕像、以弗得、神像和鑄像的時候，祭司就問他們：“你們作甚麼呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","他們回答他：“不要出聲，用手掩著你的嘴，跟我們走吧，好作我們的師父和祭司。你作一家的祭司好呢？還是作以色列中一個支派一個家族的祭司好呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","祭司心裡高興，就拿著以弗得、神像和雕像，來到眾人中間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","他們就轉身離去，把婦孺和牲畜，以及財物，都放在前面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","他們離開米迦的家很遠的時候，在米迦的家附近各家的人，都被召集出來，去追趕但人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","他們呼叫但人；但人轉過臉來，問米迦：“你召集了這麼多人出來作甚麼？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","米迦回答：“你們把我所做的神像和我的祭司都帶走了，我還有甚麼呢？你們怎麼還問我：‘你作甚麼’呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","但人對米迦說：“不要再讓我們聽見你的聲音，恐怕有暴躁的人攻擊你們，以致你和你全家盡都喪失性命。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","但人繼續走他們的路；米迦見他們比自己強，就轉身回自己的家去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","但人把米迦所做的神像和他的祭司都帶走，他們來到拉億，去到平靜安居的人民那裡，就用刀劍擊殺了他們，又用火燒了那城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","沒有人搭救，因為離西頓很遠，他們又與別人沒有來往。這城位於靠近伯．利合的山谷中。但人重建那城，住在其中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","按著他們的祖宗，以色列所生的兒子但的名字，給那城起名叫但；其實那城原先的名字叫拉億。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","但人就為自己把那雕像立起來；摩西的孫子、革順的兒子約拿單和他的子孫，都作了但支派的祭司，直到那地遭受擄掠的日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","神的殿在示羅有多少日子，但人為自己設立米迦所做的雕像也有多少日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","在以色列中沒有王的日子，有一個利未人寄居在以法蓮山地的偏遠地區；他從猶大的伯利恆給自己娶了一個女子作妾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","他的妾背夫行淫，離開丈夫，回到猶大的伯利恆她父親的家那裡去了，在那裡住了四個月的日子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","她的丈夫起來，帶著一個僕人和兩頭驢去追她，用話打動她的心，叫她回來。她把丈夫帶到自己父家，那少女的父親見了那人，就歡歡喜喜迎接他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","那人的岳父，就是女子的父親，強留那人，那人就與他同住了三天；他們一起吃喝，在那裡住宿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","到了第四天，他們清早起來，那人起身要走；那女子的父親對女婿說：“請吃點餅增添心力，然後再走。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","於是二人坐下，一起吃喝；女子的父親對那人說：“請你答應再過一夜，暢快你的心。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","那人起來要走，他的岳父強留他，他又在那裡過了一夜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","到了第五天，他清早起來要走；那女子的父親說：“請吃點餅增添心力，等到日頭西斜再走吧。”於是他們耽延，直到日頭西斜；二人一同吃飯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","那人和他的妾，以及他的僕人起來要走的時候，他的岳父，就是那女子的父親，對他說：“看哪，天快晚了！請再住一夜。看哪，日頭西斜了！請在這裡再住一夜，暢快你的心；明天可以清早起來，上路回家去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","那人不願再住一夜，就帶著自己的妾和兩頭備好了的驢，起來走了，來到耶布斯對面；耶布斯就是耶路撒冷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","他們走近耶布斯的時候，日頭快要落了；僕人對主人說：“來，讓我們轉到這耶布斯人的城去，好在那裡住宿。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","主人對他說：“我們不可轉到這座不是以色列人居住的外族人的城裡去，我們過到基比亞去吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","又對他的僕人說：“來吧，我們可以到這些地方其中一個去投宿，或在基比亞或在拉瑪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","於是他們走路過去；他們走近便雅憫人的基比亞的時候，日頭已經落了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","他們從那裡轉身，要進基比亞去住宿；他們進去，坐在城裡的廣場上，因為沒有人接待他們到家裡去住宿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","到晚上，有一個老年人從田間工作回來；那人原是以法蓮山地的人，寄居在基比亞；那地方的人卻是便雅憫人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","那老年人舉目，看見那個旅客在城裡的廣場上，就問他：“你要到哪裡去？你從哪裡來？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","利未人回答他：“我們是從猶大的伯利恆過來的，要到以法蓮山地的偏遠地區去，我原是那地方的人；我去過猶大的伯利恆，現在我要到我的家去（“到我的家去”原文作“到耶和華的殿去”），但沒有人接待我到家裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","其實我有糧草、有飼料，可以餵驢；我和我的妾，以及與你的僕人在一起的那個青年人，都有餅和酒吃喝，一無所缺。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","那老年人說：“願你平安，你所缺乏的，由我負責好了；只是不可在廣場上過夜。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","於是把他領到自己的家裡，用飼料餵了驢，他們洗了腳，就吃喝起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","他們心裡正暢快的時候，忽然城裡有些無賴之徒，圍繞房子，不住地敲門，對老房主說：“把進入你家的那個人帶出來，我們要與他交合。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","那房主出來見他們，對他們說：“我的眾兄弟啊，不可這樣，請你們不要作惡；這人既然進了我的家，你們就不要作這羞恥的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","這裡有我的女兒，還是處女，並且有這人的妾，我把她們領出來，讓你們污辱她們；你們看怎樣好，就怎樣待她們吧。只是對這個人，你們卻不要作這羞恥的事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","那些人卻不肯聽從他的話，那人就抓住自己的妾，拉出外邊去交給他們，他們就與她交合，整夜污辱她；直到早晨，天色破曉的時候，才放她走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","天快亮的時候，那女子回到留她主人住宿的那人的房子門口，就仆倒在那裡，直到天亮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","到早晨，她的主人起來，開了房門，出去要上路的時候，就看見那婦人，就是他的妾，仆倒在門口，她的雙手搭在門檻上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","他對那婦人說：“起來，我們走吧！”可是卻沒有回答。那人就把她馱在驢上，起程回自己的地方去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","他到了家裡，就拿起刀來，抓住自己的妾，把她的肢體切成十二塊，叫人送到以色列的全境去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","看見的人都說：“自從以色列人從埃及地上來的日子，直到今日，這樣的事並沒有發生過，也沒有看見過；你們要思想，要商議，要討論。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","於是以色列眾人都出來，從但到別是巴，以及基列地的眾人，都在米斯巴耶和華面前聚集起來如同一人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","全民的領袖，就是以色列眾支派的領袖，都站在　神子民的會中；拿刀的步兵共有四十萬人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","（以色列人上到米斯巴來，便雅憫人聽見了。）以色列人說：“這件惡事是怎樣發生的？你們說吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","那利未人，就是被害的婦人的丈夫，回答說：“我和我的妾到了便雅憫的基比亞，要在那裡住宿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","基比亞人民起來攻擊我，在夜間包圍我住的房子攻擊我，有意殺害我；他們把我的妾污辱致死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","我就把我的妾切成塊子，送到以色列的各地業，因為基比亞人在以色列中行了極羞恥的惡事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","以色列人哪，你們都要說出你們的意見，也要在這裡提出你們的對策。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","於是眾人都起來如同一人，說：“我們當中誰都不回自己的帳棚，誰都不回自己的家。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","現在我們要這樣對待基比亞人：我們要照著所抽的籤上去攻打他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","我們要從以色列各支派中，每百人抽取十人，每千人抽取百人，每萬人抽取千人，好為人民運送糧食；等他們到了便雅憫的基比亞的時候，就可以照著他們在以色列中所行的一切羞恥的事懲罰他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","於是以色列眾人彼此聯合，如同一人，聚集起來攻擊那城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","以色列各支派打發人到便雅憫的各家去，說：“你們中間怎麼發生了這樣的惡事呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","現在你們要把那些人，基比亞的無賴之徒，交出來，我們好處死他們，從以色列中除掉這惡。”只是便雅憫人卻不肯聽從他們的兄弟以色列人的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","便雅憫人從各城出來聚集，往基比亞去，要與以色列人交戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","那時便雅憫人，從各城裡被數點的，共有二萬六千拿刀的，另外被數點的，還有基比亞的居民，共有七百精兵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","在這些人中，還有七百精兵是善用左手的，個個都能用機弦拋石，毫髮不差。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","除了便雅憫人以外，以色列人被數點的，共有四十萬拿刀的，個個都是戰士。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","以色列人就起來，上伯特利去求問　神，說：“我們之中誰應首先上去，與便雅憫人交戰呢？”耶和華說：“猶大應首先上去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","以色列人早晨起來，對著基比亞安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","以色列人出來，要與便雅憫人交戰；以色列人在基比亞面前列陣等待他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","便雅憫人從基比亞出來，那一天使二萬二千以色列人倒地身亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","眾民，就是以色列人，都奮勇起來，又在頭一天列陣的地方列陣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","事前，以色列人上伯特利去，在耶和華面前哀哭直到晚上，然後求問耶和華，說：“我們再去與我們的兄弟便雅憫人交戰，可以不可以？”耶和華說：“你們可以上去攻打他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","第二天，以色列人就前去攻打便雅憫人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","便雅憫人第二天也從基比亞出來，迎戰以色列人，又使一萬八千以色列人倒地身亡，都是拿刀的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","以色列眾人，就是全體人民，又上到伯特利，坐在耶和華面前哀哭，那日禁食直到晚上，然後在耶和華面前獻上燔祭和平安祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","27","那時，　神的約櫃在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_28","008_20_28","JDG","20","28","28","那時，亞倫的孫子、以利亞撒的兒子非尼哈，侍立在約櫃前供職。以色列人求問耶和華，說：“我們應再出去與我們的兄弟便雅憫人交戰呢？還是休戰呢？”耶和華說：“你們應上去，因為明天我必把他們交在你們手中。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","以色列人在基比亞四周設下伏兵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","第三天，以色列人又上去攻打便雅憫人，在基比亞前面列陣，像前兩次一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","便雅憫人也出來迎敵，他們被引出城外，在兩條大路上，一條通往伯特利，一條通往基比亞，像前兩次一樣，動手殺敵，在田間殺死以色列人約有三十個。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","便雅憫人說：“他們仍像前一次一樣，敗在我們面前了。”以色列人卻說：“我們逃跑吧，引他們離開城市出到大路上來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","以色列眾人都從自己的地方起來，在巴力．他瑪列陣；以色列的伏兵，從基比亞西邊埋伏的地方衝出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","全以色列中的精兵，有一萬人前來攻打基比亞，戰爭非常激烈；便雅憫人還不知道災禍快要臨到他們的身上了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","耶和華在以色列人面前擊敗了便雅憫人；那天以色列人消滅便雅憫人，共二萬五千一百名，都是拿刀的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","這樣，便雅憫人就看出自己被擊敗了。原來以色列人倚靠在基比亞前面設下的伏兵，就對便雅憫人詐敗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","伏兵急忙衝入基比亞，用刀擊殺了全城的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","以色列人與伏兵預先約定，就是從城裡放火，以煙氣上升為號。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","以色列人在戰場上撤退的時候，便雅憫人就動手殺人，刺死以色列人約三十個，心裡說：“他們真的像頭一次戰陣一樣，在我們面前被擊敗了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","當煙柱信號從城中上升的時候，便雅憫人就轉身觀看，只見全城煙火沖天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","那時，以色列人又轉身回來，便雅憫人就非常驚慌，因為看見災禍臨到自己身上了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","他們在以色列人面前轉身，向曠野的路上逃走，戰爭卻緊隨著他們；那些從各城裡出來的人也在他們中間消滅他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","以色列人包圍了便雅憫人，追趕他們，在他們歇息之地，直到基比亞對面日出之處，踐踏他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","便雅憫人中倒斃的共有一萬八千人，全都是勇士。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","其餘的人轉身，向著曠野逃跑，到了臨門的磐石那裡；以色列人在大路上除滅了他們五千人，追趕他們直到基頓，又擊殺了他們二千人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","所以那一天便雅憫人倒斃的，共有二萬五千人，都是拿刀的，全部是勇士。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","剩下的六百人轉身，向著曠野逃跑，到了臨門的磐石那裡，就在臨門的磐石那裡住了四個月。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","以色列人又回到便雅憫人那裡，把全城的人和牲畜，以及一切遇見的，都用刀殺盡；又把他們碰見的一切城市放火燒毀了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","以色列人在米斯巴曾經起誓說：“我們中間不可有人把自己的女兒嫁給便雅憫人作妻子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","眾人來到伯特利，在那裡坐在　神面前直到晚上，放聲大哭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","說：“耶和華以色列的　神啊，今日以色列中缺少了一個支派，為甚麼在以色列中發生這事呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","次日，眾人清早起來，在那裡築了一座祭壇，獻上燔祭和平安祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","以色列人彼此說：“以色列各支派中，誰沒有與會眾上到耶和華面前來呢？”因為他們曾經起過很嚴厲的誓，說：“不上米斯巴到耶和華面前的，必把他處死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","以色列人為他們的兄弟便雅憫難過，說：“今天以色列中有一個支派被剪除了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","我們曾經指著耶和華起過誓，必不把我們的女兒給便雅憫人作妻子，那麼現在我們當怎樣辦理，使他們剩下的人有妻子呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_8","008_21_8","JDG","21","8","8","他們又彼此問：“以色列各支派中，有誰沒有上米斯巴到耶和華面前來的呢？”他們就發現基列．雅比中沒有一人去到營中會眾那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_9","008_21_9","JDG","21","9","9","眾人被數點的時候，就發現基列．雅比的居民中沒有一人在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_10","008_21_10","JDG","21","10","10","因此會眾從勇士中差派一萬二千人到那裡去，吩咐他們說：“你們去用刀擊殺基列．雅比的居民，連婦女與孩子都要殺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_11","008_21_11","JDG","21","11","11","你們要這樣行，你們要把所有的男子，和所有與男子同過房的女子，完全毀滅。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_12","008_21_12","JDG","21","12","12","他們在基列．雅比的居民中，找到了四百個未曾與人同房，也未曾與男子同寢的年輕少女，就把她們帶到迦南地的示羅營那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_13","008_21_13","JDG","21","13","13","全體會眾又派人到臨門的磐石那裡，對便雅憫人說話，向他們宣告和平。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_14","008_21_14","JDG","21","14","14","那時便雅憫人回來了，以色列人就把他們保留的基列．雅比的女子給他們作妻子，但還是不夠。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_15","008_21_15","JDG","21","15","15","眾人為便雅憫人難過，因為耶和華使以色列眾支派中有了缺口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_16","008_21_16","JDG","21","16","16","會眾中的長老說：“便雅憫的女子既然都被除滅了，我們應怎樣行，使那些餘下的人有妻子呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_17","008_21_17","JDG","21","17","17","又說：“便雅憫逃脫的人應有地業，免得有個支派從以色列中被消滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_18","008_21_18","JDG","21","18","18","但是我們不能把我們自己的女兒給他們作妻子。”因為以色列人曾經起誓說：“把女兒給便雅憫人作妻子的，是可咒詛的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_19","008_21_19","JDG","21","19","19","他們又說：“看哪，每年在示羅都舉行耶和華的節期；示羅就是在伯特利的北面，從伯特利上示劍的大路的東面，在利波拿的南面。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_20","008_21_20","JDG","21","20","20","於是他們吩咐便雅憫人說：“你們去在葡萄園中設下埋伏； ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_21","008_21_21","JDG","21","21","21","在那裡觀看，示羅的女子出來跳舞的時候，你們就從葡萄園出來，從示羅的女子中，各搶一個作妻子，然後回便雅憫地去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_22","008_21_22","JDG","21","22","22","如果她們的父親或是兄弟來與我們爭論，我們就對他們說：‘求你們恩待他們吧，因為我們在戰場上沒有給他們留下女子作妻子，而且這次又不是你們把女兒給他們；若是你們給的，你們就有罪了。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_23","008_21_23","JDG","21","23","23","於是便雅憫人照樣行了：按著他們的數目，從跳舞的女子中強搶她們作妻子，然後離開那裡，回到自己的地業去，重建城市，住在其中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_24","008_21_24","JDG","21","24","24","那時，以色列人離開那裡，各人回到自己的支派和自己的家族去；他們離開那裡，各人回到自己的地業去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","在那些日子，以色列中沒有王，各人都行自己看為對的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","在士師統治期間，國內發生了饑荒。有一個人帶著妻子和兩個兒子，從猶大的伯利恆前往摩押地去，寄居在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","這個人名叫以利米勒，妻子名叫拿俄米，兩個兒子叫瑪倫和基連，都是猶大伯利恆的以法他人。他們到了摩押地，就在那裡住下來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","後來拿俄米的丈夫以利米勒去世了，留下她和兩個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","他們娶了摩押女子作妻子，一個名叫俄耳巴，一個名叫路得。他們在那裡住了約有十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","後來，瑪倫和基連二人也死了，留下拿俄米，既沒有了兩個兒子，又沒有了丈夫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","拿俄米還在摩押地的時候，因為聽說耶和華眷顧他的子民，賜糧食給他們，就帶著兩個媳婦動身從摩押地回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","她離開居住的地方，兩個媳婦也隨她出發，要回到猶大地去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","拿俄米對兩個媳婦說：“去吧，你們還是各自回娘家吧。願耶和華恩待你們，像你們善待已死的人和我一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","願耶和華使你們各人有機會再嫁（“有機會再嫁”原文作“在丈夫家裡”），找到歸宿。”跟著親吻她們，她們就發聲大哭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","說：“不，我們一定要跟你一起回到你同胞那裡去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","拿俄米說：“我女兒啊，你們回去吧，為甚麼要跟我去呢？我肚子裡還有兒子作你們的丈夫嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","走吧，我女兒啊，你們回去吧，因為我太老，不能嫁人了，就算我說我還有希望今天晚上有個丈夫，又生兒子， ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","你們可以等到他們長大嗎？你們可以為他們守節而不嫁人嗎？不行，我女兒啊，我為你們非常難過，因為耶和華伸手對付我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","她們又放聲大哭。俄耳巴就和婆婆吻別，路得卻捨不得離開拿俄米。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","拿俄米說：“你看，你嫂嫂已經回到她同胞和她的神那裡去了。你也跟著嫂嫂回去吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","路得說：“請不要逼我離開你回去，不跟從你。你到哪裡去，我也要到哪裡去；你在哪裡過夜，我也要在哪裡過夜；你的同胞就是我的同胞，你的　神就是我的　神； ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","你死在哪裡，我也要死在哪裡，葬在哪裡。除非死亡把你我分離；如果我離開你，願耶和華加倍懲罰我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","拿俄米看路得堅決要跟她走，就不再多費唇舌了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","她們雙雙上路，來到伯利恆。她們到達的時候，全城都因她們的緣故騷動起來。婦女們說：“這是拿俄米嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","拿俄米對她們說：“不要叫我拿俄米，叫我瑪拉吧，因為全能者使我吃盡了苦頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","我滿滿地出去，耶和華卻使我空空地回來，你們為甚麼還叫我拿俄米呢？耶和華折磨我，全能者加害於我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","拿俄米就這樣回來了。她媳婦摩押女子路得隨著她從摩押地回來。她們到達伯利恆，正是開始收割大麥的時候。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","拿俄米的丈夫以利米勒有個同族的親戚，名叫波阿斯，是個大財主。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","摩押女子路得對拿俄米說：“讓我到田裡去，我在誰的眼前蒙恩，我就跟在誰的背後撿麥穗。”拿俄米說：“女兒啊，你儘管去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","路得就去了，來到田裡，在收割的人背後撿麥穗。她恰巧來到以利米勒同族的人波阿斯那塊田。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","波阿斯剛好從伯利恆來，對收割的人說：“願耶和華與你們同在。”他們回答：“願耶和華賜福與你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","波阿斯問那監督收割的僕人：“那是誰家的姑娘呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","監督收割的僕人回答：“她是跟拿俄米從摩押地回來的摩押女子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","她說：‘請讓我撿一點麥穗吧。讓我跟在收割的人背後，在禾捆堆中撿些零碎的穗子。’於是她來了。除了在房子裡休息了一會兒之外，從早晨到現在一直都留在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","波阿斯對路得說：“女兒啊，聽我說，不要到別人田裡去撿麥穗，也不要離開這裡，要常常與我的女傭人在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","你看他們在哪塊田裡收割，就跟著女傭人去。我不是已經吩咐僕人不可欺負你嗎？假如你渴了，就到水缸那裡去，喝僕人打來的水。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","路得就俯伏在地叩拜，對他說：“我是個外族人，為甚麼會在你眼前蒙恩，蒙你關照呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","波阿斯回答她說：“自從你丈夫去世以後，你對婆婆所行的，和你怎樣離開父母與出生之地，來到素來不認識的人中間，這一切我都知道得很清楚了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","願耶和華照你所作的報答你；你來投靠在耶和華以色列　神的翅膀下，願他充充足足酬報你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","路得說：“主人啊，但願我在你眼前蒙恩，雖然我連你的婢女都不是，你還是安慰我，對我這麼好。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","到了吃飯的時候，波阿斯對路得說：“你過來，吃一點餅吧，拿餅塊蘸在醋裡。”路得就在收割的人旁邊坐下來。波阿斯把一些烘好的麥穗遞給她，她吃飽了，還有剩下的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","她再起來去撿麥穗的時候，波阿斯吩咐僕人說：“就算她在禾捆堆中撿麥穗，也不可以辱罵她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","甚至要故意為她從禾捆中抽些出來，留給她去撿，千萬不可責備她。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","路得就這樣在田裡撿麥穗，直到傍晚。她把撿來的麥穗打了，約有二十二公升大麥， ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","然後帶回城裡去。路得把撿來的麥子拿給婆婆看，把吃剩的給了婆婆。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","婆婆問她：“你今天在哪裡撿麥穗？在哪裡工作呢？願那關照你的人蒙福。”路得就告訴婆婆她在誰那裡工作，說：“我今天在一個名叫波阿斯的人那裡工作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","拿俄米對媳婦說：“願不斷施慈愛給活人和死人的耶和華賜福給他。”拿俄米又對她說：“這個人是我們的親人，有買贖權的一位近親。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","摩押女子路得說：“他還告訴我：‘緊跟著我的僕人撿麥穗，直到全部收割完畢。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","拿俄米對媳婦路得說：“我女兒啊，這樣才好，要與他的女傭人一起去，免得在別人的田裡遭受敵視。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","她就緊跟著波阿斯的女傭人撿麥穗，直到大麥和小麥都收割好了。路得一直與婆婆住在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","路得的婆婆拿俄米對她說：“女兒啊，我不是應當為你找個歸宿，使你得到幸福嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","你常常和他的女傭人在一起的波阿斯不是我們的親戚嗎？他今天晚上要在禾場上簸大麥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","你洗個澡，抹上香膏，穿上斗篷，就下到禾場去。不過，那個人還沒有吃喝完畢，別讓他認出你來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","等到他躺下來，你要弄清楚他所躺的地方，進去掀露他的腳，然後躺下去。他就會告訴你該作甚麼。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","路得對她說：“你吩咐的，我就去作。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","於是，她下到禾場去，照著婆婆吩咐的一切去作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","波阿斯吃喝完了，心裡舒暢，就去躺在麥堆的旁邊。路得悄悄地來，掀露他的腳，躺臥下去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","到了夜半，波阿斯驚醒過來，一翻身就看到一個女子躺在他的腳邊， ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","就說：“你是誰？”她回答：“我是你的婢女路得，請用你的衣襟遮蓋你的婢女，因為你是我的有買贖權的近親。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","波阿斯說：“我女兒，願你蒙耶和華賜福。你末後表現的愛心比起初更大，因為年輕人無論貧富，你都沒有跟從。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","我女兒，現在你不要怕，你所說的，我一定去作。本城的人都知道你是個賢慧的女人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","不錯，我是你那有買贖權的近親，可惜還有一個有買贖權的近親比我更親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","今晚你就在這裡過夜，明早如果他肯盡買贖你的本分，好，就由他來履行；假如他不願意這樣作，我指著永活的耶和華起誓，我一定盡買贖你的本分。你只管躺到天亮吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","路得躺在波阿斯腳邊直到早晨。因為波阿斯說過不可以讓人知道有女人來過禾場，路得就趁天色未明，人們彼此無法辨認的時候就起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","他又說：“拿你所披的外衣來，把它打開。”她打開了，他就量了六簸箕大麥，放在她的肩上。路得就進城去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","到她婆婆那裡，婆婆就問：“我女兒，怎樣了？”路得就把那人對她所作的一切都告訴了婆婆， ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","又說：“他給我這六簸箕大麥，對我說：‘不要空手去見你婆婆。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","拿俄米說：“我女兒，你儘管安靜等候，直到你知道事情怎樣了結，因為那人今天不把事情辦妥，絕不歇息。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","波阿斯去到城門，坐在那裡，波阿斯所說那個有買贖權的近親剛巧路過那裡。波阿斯說：“喂，老兄，過來坐一下吧。”他就過去坐下來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","波阿斯又邀請城裡的十個長老，對他們說：“請坐在這裡。”他們就坐下來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","他對那個有買贖權的近親說：“從摩押地回來的拿俄米，現在要賣我們族兄以利米勒的那塊地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","我想把這一件事告訴你，請你在眾民的長老，還有在座的各位面前，把它買下來吧。如果你肯贖就贖，假如不肯，就說出來，讓我知道；因為除了你當贖它以外，我是第一候補。”那人說：“我肯贖。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","波阿斯說：“你從拿俄米手中買下那塊地的時候，你也得娶（“娶”原文作“買”）已死的人的妻子摩押女子路得，使已死的人的名字留在他的產業上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","那有買贖權的近親說：“那我就不能贖它了，只怕損害了我的產業。你可以贖我當贖的，因為我沒有辦法贖了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","從前在以色列，無論買贖或是交易，決定甚麼事，當事人就要脫鞋給對方。這是以色列中作證的方式。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","那有買贖權的近親對波阿斯說：“你自己買下來吧。”就把鞋脫下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","波阿斯對長老和眾人說：“今天你們都是見證人，所有屬於以利米勒、基連和瑪倫的，我都從拿俄米手中買下來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","我也娶了（“娶了”原文作“買了”）瑪倫的妻子摩押女子路得作妻子，使已死的人的名字留在他的產業上，免得他的名字在本族本鄉中除掉。今天你們都是見證人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","聚集在城門的眾人和長老都說：“我們都是見證人。願耶和華使進你家的這女人，像建立以色列家的拉結和利亞二人一樣。願你在以法他顯大，在伯利恆揚名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","願耶和華從這少婦賜你後裔，使你的家像他瑪從猶大所生法勒斯的家一般。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","於是波阿斯娶了路得作妻子，與她親近。耶和華使她懷孕生了一個兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","婦女對拿俄米說：“耶和華是應當稱頌的，因為他今天沒有斷絕你有買贖權的近親，願他在以色列中揚名。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","他必甦醒你的生命，養你的老，因為他是愛你的媳婦所生的；有她比有七個兒子更好。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","拿俄米把孩子接過來，抱在懷中，作他的保姆。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","鄰近的婦女要給他起名字，說：“拿俄米生了孩子了。”就給他起名叫俄備得；這俄備得是耶西的父親，耶西是大衛的父親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","以下是法勒斯的後代：法勒斯生希斯崙， ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","希斯崙生蘭，蘭生亞米拿達， ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","亞米拿達生拿順，拿順生撒門， ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","撒門生波阿斯，波阿斯生俄備得， ");
INSERT INTO cmn_ncvt_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","俄備得生耶西，耶西生大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","在以法蓮山地的拉瑪．瑣非，有一個以法蓮人名叫以利加拿，是耶羅罕的兒子、以利戶的孫子、託戶的曾孫、蘇弗的玄孫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","他有兩個妻子，一個名叫哈拿，另一個名叫毗尼拿。毗尼拿有孩子，哈拿卻沒有孩子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","這人每年都從他的本城上示羅去敬拜，獻祭給萬軍之耶和華。在示羅有以利的兩個兒子，何弗尼和非尼哈，作耶和華的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","以利加拿在獻祭的那天，就把祭肉分給妻子毗尼拿和她所有的兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","但他當面只分給哈拿一份；他雖然愛哈拿，耶和華卻使哈拿不能懷孕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","因為耶和華使哈拿不能懷孕，她的對頭就盡力刺激她，使她苦惱。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","年年都是這樣；每逢她上耶和華殿的時候，毗尼拿總是刺激哈拿，使她哭泣，吃不下飯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","她的丈夫以利加拿對她說：“哈拿，你為甚麼哭泣？為甚麼不吃飯，為甚麼心裡難過呢？你有我不是比有十個兒子更好嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","哈拿在示羅吃喝完了，就起來。（那時以利祭司在耶和華殿的門柱旁邊，坐在椅子上。） ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","她心裡愁苦，就向耶和華禱告，流淚痛哭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","並且許願，說：“萬軍之耶和華啊，你若是看顧使女的困苦，記念我，不忘記你的使女，賜給使女一個兒子，我就必把他一生獻給耶和華，不剃他的頭。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","哈拿向耶和華禱告了很久，以利一直在注視她的嘴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","原來哈拿是在心中訴說，只見她的嘴唇在動，卻聽不見她的聲音，因此以利以為她是個喝醉了的女人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","以利就對她說：“你要醉到幾時呢？快快醒過來吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","哈拿回答：“我主啊，不是的。我是個心靈愁苦的婦人，淡酒烈酒都沒有喝，只不過在耶和華面前傾吐我的心意。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","不要把你的使女看作不檢點的女子，我因為極度愁苦和激動，才一直傾訴到現在。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","以利回答：“平平安安回去吧！願以色列的　神把你所求的賜給你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","哈拿說：“願你的婢女在你眼前蒙恩！”於是這婦人回去，並且吃飯，臉上再沒有愁容。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","第二天，他們清早起來，在耶和華面前敬拜，然後回到他們的家鄉拉瑪，回到自己的家裡去。以利加拿和妻子哈拿同房；耶和華顧念哈拿， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","她就懷孕；時候到了，就生了一個兒子，哈拿給他起名叫撒母耳，因為她說：“他是我從耶和華那裡求來的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","以利加拿和他全家都上示羅去，向耶和華獻年祭和還所許的願； ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","哈拿卻沒有上去，因為她對丈夫說：“等孩子斷了奶，我才帶他去朝見耶和華。他要永遠住在那裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","她丈夫以利加拿對她說：“你看怎樣好，就怎樣作吧。你可以留在這裡，等到你給孩子斷了奶，但願耶和華實現他的話。”於是哈拿留在家裡乳養孩子，直到給他斷了奶。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","她給孩子斷了奶之後，就帶他一同上去，又帶了一頭三歲的公牛、十公斤麵和一皮袋酒。她把孩子帶到示羅耶和華的殿那裡；那時孩子還很小。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","他們宰了公牛以後，就帶孩子到以利那裡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","婦人說：“我主啊，我敢指著我主的性命起誓，我就是從前在這裡站在你旁邊，向耶和華禱告的那個婦人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","那時我祈求為要得這孩子，耶和華已經把我向他所求的賜給我了， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","所以我現在把他獻給耶和華，他的一生是屬於耶和華的。”於是他就在那裡敬拜耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","哈拿禱告說：“我的心因耶和華喜樂，我的角因耶和華高舉，我的口向仇敵大大誇耀，因為我以你的救恩為樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","沒有人像耶和華那麼聖潔，因為除你以外沒有別的神，也沒有磐石像我們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","你們不要多說驕傲的話，也不要口出狂妄之言，因為耶和華是全知的　神，人的一切行為他都鑒察。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","勇士的弓都被折斷，跌倒的人卻以力量束腰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","飽足的，要勞碌覓食，飢餓的，不再飢餓；不能生育的，生了七個兒女，有過許多兒女的，反倒衰微。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","耶和華使人死，也使人活；使人下陰間，也使人從陰間上來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","耶和華使人貧窮，也使人富足；使人降卑，也使人升高。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","他從灰塵中抬舉貧寒的人，從糞堆中提拔窮乏的人，使他們與顯貴同坐，承受尊貴的座位。大地的柱子屬於耶和華，他把全地安放在柱子上面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","耶和華必保護虔誠人的腳步，卻使惡人在黑暗中滅亡，因為人得勝不是靠著力量。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","至高者在天上打雷，耶和華必打碎與他作對的人。耶和華要審判地的四極，卻要賜力量給他所立的王，高舉他膏立之人的角。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","後來，以利加拿回拉瑪自己的家去。那孩子卻留在以利祭司面前事奉耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","以利的兩個兒子是無賴，不尊重耶和華， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","也不理會當時祭司待人民的規矩。有人獻祭，在煮肉的時候，祭司的僕人就來，手裡拿著三齒的叉， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","把叉子插入煎盤裡，或鼎裡，或釜裡，或鍋裡，叉子插上來的，祭司都拿去。所有到示羅來的以色列人，祭司都是這樣待他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","還有，在焚燒脂油以前，祭司的僕人就來，對獻祭的人說：“把祭肉交給祭司燒烤吧，因為他不會向你要煮過的肉，單要生的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","如果那人對僕人說：“必須先把脂油焚燒了，然後你才可以隨意去拿。”他就說：“不可以，你現在就要給我，否則我就搶去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","這樣，那兩個青年人在耶和華面前所犯的罪很大，因為他們藐視獻給耶和華的祭物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","那時，撒母耳還是個孩童，束著細麻布的以弗得，在耶和華面前事奉。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","撒母耳的母親每年為他做一件小外袍，她和丈夫一同上來獻年祭的時候，就帶來給他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","以利給以利加拿和他的妻子祝福，說：“願耶和華從這婦人身上還給你後裔，代替你獻給耶和華的孩子。”他們就回自己的地方去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","耶和華眷顧哈拿，她再懷孕，先後生了三個兒子和兩個女兒。那孩子撒母耳在耶和華面前，漸漸長大。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","以利已經老了，聽見自己的兒子對待以色列人的一切事，又聽見他們與在會幕門口侍應的婦女同寢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","以利就對他們說：“你們為甚麼作這些事？我親自從眾民那裡聽見了你們的惡行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","我兒啊，不要這樣，因為我聽見的消息很不好，你們使耶和華的子民違背律法。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","如果有人得罪人，有官長（“官長”原文作“　神”）懲罰他；如果有人得罪耶和華，有誰為他求情呢？”他們卻不聽父親的話，因為耶和華有意要殺他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","那孩子撒母耳的身量，耶和華和眾人對他的喜愛，都不斷增長。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","有一位神人來見以利，對他說：“耶和華這樣說：‘你父家在埃及法老家為奴的時候，我不是向他們顯現嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","我不是從以色列眾支派中，選出他們作我的祭司，上我的壇燒香，在我面前穿以弗得嗎？我不是把以色列人所獻的火祭，都賜給了你的父家嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","你們為甚麼還以妒羨的眼光，輕視我所吩咐要獻上的祭牲和禮物呢？你為甚麼尊重你的兒子過於尊重我，用我子民以色列所獻一切最好的禮物自肥呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","因此，耶和華以色列的　神說：‘我曾說：你的家和你的父家，必永遠行在我面前。’現在耶和華卻說：‘我決不容你們這樣行了，因為尊重我的，我必尊重他；藐視我的，必受到輕視。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","日子快到了，我要砍下你和你父親的膀臂，使你家中再沒有有權勢的長者。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","我賜給以色列人的一切福分，你必像一個對頭，以嫉妒的眼光來看；而在你的家中，必永遠再沒有有權勢的長者。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","我必不從我的祭壇那裡滅絕你家的人，免得你的眼睛昏花，心靈憂傷，但所有你家中增添的人都必像世人一樣死去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","你的兩個兒子何弗尼和非尼哈所要遭遇的事，是給你的一個證據：他們二人必同日而死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","我要為自己興起一位忠心的祭司，他必依照我的心意行事；我要為他建立一個穩固的家，他一生必行在我的受膏者面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","你家中剩下的人，都要來向他下拜；求一個銀幣，一塊餅，也要說：求你容我參與祭司的職務，使我可以有點餅吃。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","那孩子撒母耳在以利面前事奉耶和華，在那些日子，耶和華的言語稀少，異象也不常有。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","有一天，以利躺臥在自己的地方，他的眼睛早已昏花，不能看得清楚了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","神的燈還沒有熄滅，撒母耳躺臥在耶和華的殿中，就是安放　神約櫃的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","耶和華呼喚撒母耳，他說：“我在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","他就跑到以利那裡，說：“你呼喚我，我在這裡。”以利說：“我沒有呼喚你，回去睡吧。”他就回去睡了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","耶和華再次呼喚撒母耳，他就起來走到以利那裡，說：“你呼喚我，我在這裡。”以利說：“我兒，我沒有呼喚你，回去睡吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","那時撒母耳還沒有認識耶和華，因為耶和華的話還沒有向他啟示。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","耶和華第三次呼喚撒母耳，他又起來，走到以利那裡，說：“你呼喚我，我在這裡。”以利就明白是耶和華呼喚這孩子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","因此以利對撒母耳說：“去睡吧！如果他呼喚你，你就說：‘耶和華啊！請說，僕人敬聽。’”於是撒母耳回去，仍然睡在自己的地方。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","耶和華又來站著，像前幾次一樣呼喚：“撒母耳，撒母耳！”他回答：“請說！僕人敬聽。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","耶和華對撒母耳說：“看哪！我要在以色列中行一件事，聽見的人，都必耳鳴； ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","在那日，我必在以利身上徹底實現我論到他的家所說的一切話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","我曾告訴他：‘我必按著他所知道的罪孽永遠處罰他的家。這罪就是他的兒子自招咒詛，他也不責備他們。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","所以我向以利家起了誓：‘以利家的罪孽永遠不能用祭物或供物來買贖。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","撒母耳睡到天亮，他就開了耶和華殿的門。但撒母耳不敢把異象告訴以利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","以利呼喚撒母耳，說：“我兒撒母耳！”他回答：“我在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","以利說：“耶和華對你說了甚麼話呢？你不要向我隱瞞，他對你所說的一切話，如果你向我隱瞞一句，願　神對付你，並且加倍對付你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","於是撒母耳把一切話都告訴了以利，一句也沒有隱瞞。以利說：“他是耶和華，他看怎麼好，就怎麼行吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","撒母耳漸漸長大，耶和華與他同在，使他所說的一切話，沒有一句落空。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","從但到別是巴，以色列人都知道撒母耳被耶和華確立為先知。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","耶和華又在示羅顯現，因為耶和華在示羅藉著他的話向撒母耳啟示自己。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","撒母耳的話傳遍了以色列。那時，以色列人出去迎戰非利士人，他們靠近以便以謝安營，非利士人卻在亞弗安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","非利士人列陣，要與以色列人交戰。戰事展開後，以色列人敗在非利士人面前，非利士人在戰場上殺了約四千人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","軍隊回到營裡，以色列的長老說：“今天耶和華為甚麼在非利士人面前擊敗我們呢？我們要把耶和華的約櫃從示羅抬到我們這裡來。約櫃一到我們中間，就會拯救我們脫離仇敵的手。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","於是他們派人到示羅去，從那裡把坐在二基路伯中間萬軍之耶和華的約櫃抬來；以利的兩個兒子，何弗尼和非尼哈，也與　神的約櫃一同來了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","耶和華的約櫃來到營中的時候，以色列眾人就大聲歡呼，大地也迴聲響應。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","非利士人聽見了歡呼的聲音，就問：“在希伯來人的營中為甚麼有這樣大聲的歡呼呢？”後來才知道耶和華的約櫃來到了營中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","非利士人就害怕起來，他們說：“有神來到他們的營中了。”又說：“我們有禍了！因為從來沒有這樣的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","我們有禍了！從前在曠野用各樣災禍擊打埃及人的，就是這些神。誰能救我們脫離這些大能之神的手呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","非利士人哪！你們要剛強，要作大丈夫，免得你們作希伯來人的奴僕，好像他們作過你們的奴僕一樣；你們要作大丈夫，作戰吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","於是非利士人起來作戰，以色列人就被擊敗，各人都往自己的帳棚逃跑。這是一場大屠殺，以色列人中有三萬步兵陣亡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","神的約櫃也被搶去，以利的兩個兒子何弗尼和非尼哈也死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","有一個便雅憫人跑離戰場，衣服撕裂，頭蒙塵土，當天來到示羅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","他來到的時候，以利正在路旁坐在自己的椅子上觀望，因為他為　神的約櫃擔憂戰慄。那人進城裡報信，全城的人就都喊叫起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","以利聽見喊叫的聲音，就問：“這喧嚷的聲音是甚麼意思呢？”那人急忙前來，向以利報告。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","那時以利九十八歲了，眼睛發直，不能看見。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","那人告訴以利：“我是從戰場上來的，今天從戰場上逃回來。”以利問：“我兒，事情怎麼樣？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","報信的人回答，說：“以色列人在非利士人面前逃跑，傷亡慘重，你兩個兒子何弗尼和非尼哈也都死了，民中被殺的甚多，　神的約櫃也被搶去了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","因為以利年老體重，報信的人一提到　神的約櫃，以利就從椅子上往後跌倒在門旁，頸骨折斷而死。以利治理了以色列四十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","以利的媳婦，非尼哈的妻子懷了孕，產期近了；她一聽見　神的約櫃被搶去，以及她公公和丈夫都死了的消息，就忽然感到疼痛，曲身生產了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","她快要死的時候，站在旁邊的婦女們對她說：“不要怕，你生了一個兒子！”她卻不回答，也不理會。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","她給孩子起名叫以迦博，說：“榮耀已經離開以色列了。”這是因為　神的約櫃被搶去，又因為她的公公和丈夫都死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","她說：“榮耀已經離開了以色列，因為　神的約櫃被搶去了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","非利士人搶去了　神的約櫃，就把它從以便以謝運到亞實突。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","非利士人搶去　神的約櫃，把它抬進大袞廟，放在大袞神像的旁邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","第二天清早，亞實突人起來，看見大袞神像仆倒在地，俯伏在耶和華的約櫃面前。他們就把大袞神像豎立起來，放回原處。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","再次日早晨，他們起來的時候，看見大袞神像又仆倒在地，俯伏在耶和華的約櫃面前，大袞的頭和雙手也都在門檻上折斷了，只剩下大袞的身體。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","因此大袞的祭司和所有進亞實突大袞廟的人，都不踏大袞廟的門檻，直到現在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","耶和華的手重重地壓在亞實突人身上，敗壞他們，用痔瘡擊打亞實突和亞實突四境的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","亞實突人看見這種情形，就說：“以色列　神的約櫃不可再留在我們這裡，因為他的手重重地加在我們和我們的神大袞身上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","他們就派人去召集非利士人各城的首領前來，問他們：“我們要怎樣處理以色列　神的約櫃呢？”他們回答：“把以色列　神的約櫃運到迦特去吧。”他們就把它運到迦特去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","運到那裡以後，耶和華的手攻擊那城，引起很大的恐慌。他擊打全城的人，不分老幼，使痔瘡在他們中間蔓延。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","於是他們把　神的約櫃送到以革倫。　神的約櫃到了以革倫的時候，以革倫人就喊叫：“他們把以色列　神的約櫃運到我們這裡來，是要殺害我們和我們的人啊！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","於是他們派人去召集非利士人各城的首領前來，對他們說：“請把以色列　神的約櫃送回原處，免得它殺害我們和我們的人民。”死亡的恐慌籠罩全城，因為　神的手重重地壓在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","沒有死的人都遭受痔瘡的打擊；那城的哀聲，上達於天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","耶和華的約櫃在非利士人的地方有七個月之久。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","非利士人把眾祭司和占卜的都召了來，問他們：“我們應該怎樣處理耶和華的約櫃呢？請告訴我們，要怎樣才能把它送回原處呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","他們回答：“你們把以色列　神的約櫃送回去的時候，不可空空地把它送回去，卻要償還賠罪的禮物，這樣，你們就可以得著醫治，也可以知道，為甚麼他的手沒有離開你們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","非利士人問：“我們應當償給他甚麼作賠罪的禮物呢？”他們回答：“要按照非利士人各城首領的數目，用五個金痔瘡和五隻金老鼠作賠罪的禮物，因為你們所有的人和你們各城的首領所遭遇的，都是一樣的災禍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","所以你們要做痔瘡的像和毀壞田地的老鼠的像，還要把榮耀歸給以色列的　神。也許他會向你們、你們的神和你們的田地手下留情。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","你們為甚麼要硬著心，像以前埃及人和法老那樣呢？　神嚴嚴地對付他們以後，他們不是放走了以色列人，以色列人不是真的離開了嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","現在你們要預備一輛新車和兩頭仍在乳養小牛、未曾負過軛的母牛，把牠們緊緊套在車上，把小牛從牠們身邊帶回棚裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","你們要把耶和華的約櫃搬來，放在車上，把那些償給他作賠罪禮物的金器放在盒子裡，放置在約櫃旁邊，然後把它送上路，讓它自己走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","你們要留意看，如果它是走向自己的境界，往伯．示麥去，那麼就是耶和華降這大災給我們；如果不是這樣，我們就知道，不是他的手攻擊我們，我們遭遇的不過是偶然的事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","非利士人就照著去行。他們牽來兩頭還在乳養小牛的母牛，把牠們緊緊套在車上，把小牛關在棚裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","他們又把耶和華的約櫃，裝金老鼠和痔瘡像的盒子，都放在車上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","牛向著伯．示麥的路上直奔，如同走在一條大路上，一面走一面叫，不偏左也不偏右。非利士各城的首領在後面跟著走，直到伯．示麥的邊界。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","那時，伯．示麥人正在谷中收割麥子，他們舉目觀看，看見了約櫃，就歡歡喜喜迎見約櫃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","牛車到了伯．示麥人約書亞的田間，就停在那裡；那裡有一塊大石，他們把做那車的木料劈開，又把那兩隻母牛作燔祭獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","利未人把耶和華的約櫃，與它一同送來裝有金器的盒子，都搬了下來，放在大石上；那一天，伯．示麥人向耶和華獻上燔祭，又獻上其他的祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","非利士人的五個首領看見了，當天就回以革倫去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","這些金痔瘡，就是非利士人償給耶和華作賠罪的禮物的，一個是為亞實突，一個是為迦薩，一個是為亞實基倫，一個是為迦特，一個是為以革倫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","金老鼠的數目是按照非利士人五個首領所有的城市的數目，包括設防城和鄉村。他們安放耶和華約櫃的那塊大石，直到現在還是在伯．示麥人約書亞的田間，是一個證物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","耶和華因為伯．示麥人偷窺他的約櫃，就擊殺他們；他擊殺了七十人（“七十人”大多數抄本都作“五萬零七十人”，少數抄本作“七十人”）。眾人因為耶和華用大災擊殺他們，就哀哭起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","伯．示麥人說：“在耶和華這位聖潔的　神面前，誰能站立得住呢？他可以從我們這裡上到哪裡去呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","於是他們派遣使者到基列．耶琳的居民那裡去，對他們說：“非利士人把耶和華的約櫃送回來了。你們下來把它接到你們那裡去吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","基列．耶琳人就前來，把耶和華的約櫃抬上去；他們把它抬到山上亞比拿達的家中，又把他的兒子以利亞撒分別為聖，看守耶和華的約櫃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","約櫃停留在基列．耶琳很久，有二十年之久，以色列全家都痛悔尋求耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","於是撒母耳對以色列全家說：“如果你們一心歸向耶和華，就當把外族的神和亞斯他錄從你們中間除掉，專心歸向耶和華，單單事奉他，他必救你們脫離非利士人的手。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","以色列人就除掉眾巴力和亞斯他錄，單單事奉耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","撒母耳又說：“你們要把以色列眾人都聚集在米斯巴，我好為你們向耶和華禱告。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","於是，他們聚集在米斯巴，打了水，澆奠在耶和華面前；當日他們禁食，並且在那裡說：“我們得罪了耶和華。”撒母耳就在米斯巴治理以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","非利士人聽見以色列人集合在米斯巴，各城的領袖就上來攻打以色列人；以色列人聽見了，都害怕起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","以色列人對撒母耳說：“請你不要靜默，為我們呼求耶和華我們的　神吧，好叫他拯救我們脫離非利士人的手。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","撒母耳就牽來一隻還在吃奶的羊羔，把牠作全牲的燔祭獻給耶和華，又為以色列人向耶和華呼求，耶和華就應允他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","撒母耳正在獻上燔祭的時候，非利士人前來要與以色列人爭戰。當天，耶和華發出極大的雷聲，攻擊非利士人，使他們潰亂，他們就在以色列人面前被擊敗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","於是以色列人從米斯巴出去，追趕非利士人，擊殺他們，直到伯．甲的下邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","撒母耳搬來了一塊石頭，把它豎立在米斯巴和善之間，給這塊石頭起名叫以便以謝，說：“直到現在，耶和華都幫助我們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","這樣，非利士人就被制伏了，不再侵犯以色列的境界。撒母耳在世的日子，耶和華的手一直攻擊非利士人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","非利士人從以色列人奪得的城市，自以革倫直到迦特，都歸還以色列人；屬於這些城市的四境，以色列人也從非利士人手中奪回。那時，以色列人和亞摩利人和平相處。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","撒母耳終生作以色列人的士師。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","他每年都巡迴伯特利、吉甲和米斯巴，在這些地方治理以色列人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","然後，他回到拉瑪，因為他的家在那裡。他也在那裡治理以色列人，並且在那裡為耶和華築了一座祭壇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","撒母耳年老的時候，立了他的兒子作以色列人的士師。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","他的長子名叫約珥，次子名叫亞比亞，都在別是巴作士師。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","兩個兒子都沒有行撒母耳的道路，反而轉去追求不義之財，收受賄賂，屈枉正直。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","於是以色列所有的長老都集合起來，到拉瑪去見撒母耳， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","對他說：“你老了，看哪，你的兒子不行你的道路，現在求你為我們立一個王治理我們，好像列國一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","他們說“求你為我們立一個王治理我們”這件事，使撒母耳很不高興，他就禱告耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","耶和華對撒母耳說：“眾民對你所說的一切，你只管聽從，因為他們不是厭棄你，而是厭棄我，不要我作他們的王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","自從我把他們從埃及領上來的那天起，直到現在，他們怎樣離開我，事奉別的神，他們對我所行的一切，也照樣對你行。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","現在你只管聽從他們的話，但必須鄭重警告他們，告訴他們那要統治他們的王要怎樣治理他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","於是，撒母耳把耶和華所講的一切話都告訴那些向他要求一個王的民眾， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","說：“那要統治你們的王將這樣治理你們：他必徵用你們的兒子，派他們作他的戰車兵、騎兵、在車前奔走的前鋒， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","又派他們作千夫長、五十夫長，替他耕田、收他的莊稼、替他製造作戰的武器和戰車上的裝備。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","他必徵用你們的女兒作配香膏的、燒飯的和烤餅的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","他必奪去你們最好的田地、葡萄園和橄欖園，賜給自己的臣僕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","你們撒種所得的和葡萄園所出的，他都徵收十分之一，賜給他的太監和臣僕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","他又必徵收你們的僕婢、最精壯的青年和驢，替他工作。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","你們的羊群，他要徵收十分之一；連你們自己也作他的奴僕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","到時，你們必因你們為自己揀選的王而哀求，那時耶和華卻不應允你們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","眾民竟不肯聽從撒母耳的話，說：“不，我們要一個王治理我們， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","讓我們也像列國一樣，有自己的王治理我們，帥領我們出征，為我們作戰。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","撒母耳聽了眾民的一切話，就向耶和華複述。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","耶和華對撒母耳說：“你只管聽從他們的話，為他們立一個王。”於是撒母耳對以色列人說：“你們各人回自己的城去吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","有一個便雅憫人，名叫基士，是亞別的兒子。亞別是洗羅的兒子，洗羅是比歌拉的兒子，比歌拉是亞斐亞的兒子。（這便雅憫人是個大財主。） ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","他有一個兒子，名叫掃羅，既年輕又英俊；在以色列人中，沒有一個能比他更英俊的。他比人高出一個頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","掃羅的父親基士有幾頭母驢走失了，他就對他的兒子掃羅說：“你帶一個僕人，動身去尋找母驢吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","掃羅走遍以法蓮山地，又走遍沙利沙地，但他們都沒有找到。他們又走遍沙琳地，母驢也不在那裡；又走遍便雅憫地，還是找不到。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","他們到了蘇弗地，掃羅對跟隨他的僕人說：“來，我們回去吧，恐怕我父親不為母驢掛心，反而為我們擔憂了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","僕人對他說：“看哪，這城裡有一位神人，很受人敬重，他所說的，都必應驗。現在，我們到他那裡去吧，也許他會告訴我們當走的路。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","掃羅對僕人說：“如果我們去，有甚麼可以送給那人呢？因為我們袋裡的食物都已經用盡了，也沒有禮物可以送給那神人，我們還有甚麼呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","僕人回答掃羅：“看哪！我手裡有三克銀子，可以送給那神人，請他告訴我們應該走的路。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","從前在以色列中，有人去求問　神的時候，就這樣說：“來，我們去見先見吧。”因為今天稱為先知的，從前稱為先見。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","掃羅對僕人說：“你說的好。來，我們去吧！”於是他們到那神人所住的城裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","他們正上山坡要進城的時候，就遇見幾個少女出來打水。他們就問那些少女：“先見在這裡嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","那些少女回答他們說：“在這裡！他就在你們前面，現在快去吧！他今天正到這城裡來，因為今天在邱壇上，人民有獻祭的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","你們一進城，在他登上邱壇吃祭物之前，必遇見他。因為他未到，眾人不能先吃，他必先為祭物祝謝，然後客人才可以吃。現在你們上去吧！今天，你們必可遇見他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","於是二人上那城去；他們正進城的時候，撒母耳就迎著他們出來，要上邱壇去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","原來，在掃羅來到的前一天，耶和華已經啟示撒母耳說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“明天大約這個時候，我要差派一個人從便雅憫地到你那裡去，你要膏立他作我子民以色列人的領袖。他要拯救我的子民脫離非利士人的手。我眷顧了我的子民，因為他們的哀求已經達到我這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","撒母耳看見了掃羅，耶和華就對撒母耳說：“你看，這就是我對你所說的那人，他要統治我的子民。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","掃羅在城門口，走近撒母耳跟前，說：“請告訴我先見的家在哪裡？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","撒母耳回答掃羅：“我就是先見，請你在我前面上邱壇去。今天你們要與我一同吃飯，明天早晨我就送你回去。你心裡的一切事，我都會告訴你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","至於你前三天失了的母驢，你不必為牠們擔心，因為都已經找到了。以色列眾人所渴求的是誰呢？不是你和你的父家嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","掃羅回答：“我不是以色列眾支派中最微小的便雅憫人嗎？我的家族不是便雅憫支派的家族中最微小的嗎？你為甚麼對我說這樣的話呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","撒母耳把掃羅和掃羅的僕人領進了客廳，使他們坐在客人中的首位；那裡約有三十人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","撒母耳對廚師說：“我交給你，吩咐你存放好的那一份祭肉，現在可以拿來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","廚師就把那條腿肉拿上來，擺在掃羅面前。撒母耳說：“這是為你留下的，現在擺在你面前，請吃吧！因為這是我邀請眾人的時候，特地為這時刻保留的。”於是，當天掃羅就與撒母耳一同吃飯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","他們從邱壇下來，進到城裡；撒母耳和掃羅在房頂上說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","他們清早起來；天快亮的時候，撒母耳在房頂上呼叫掃羅說：“起來吧，我要送你回去。”掃羅就起來。於是，他與撒母耳二人一起到外面去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","他們下到城邊的時候，撒母耳對掃羅說：“吩咐你的僕人先走。（僕人就先走了。）你暫且留在這裡，我好把　神的話講給你聽。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","撒母耳拿了一瓶膏油，倒在掃羅的頭上，又與他親嘴，說：“耶和華不是已經膏立你作他產業的領袖嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","今天你離開我以後，在便雅憫境內的泄撒，靠近拉結墳墓的旁邊，必遇見兩個人。他們會對你說：‘你去尋找的那幾頭母驢已經找到了。現在你父親放下了母驢的事，反而為你擔憂，說：我為我的兒子要怎麼辦呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","你要從那裡再往前去，直到他泊的橡樹那裡，必遇見三個上伯特利去敬拜　神的人，一個帶著三隻山羊羔，一個帶著三個餅，一個帶著一皮袋酒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","他們必向你問安，並且給你兩個餅，你要從他們手中接過來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","然後，你要到　神的山去，那裡有非利士人的駐軍。你進城的時候，會遇見一班先知從邱壇上下來。在他們前面有鼓瑟的、打鼓的、吹笛的、彈琴的。他們都受感說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","耶和華的靈必大大感動你，你就要與他們一同受感說話，變成另一個人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","這些徵兆臨到你的時候，你就可以見機行事，因為　神與你同在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","你要在我以先下到吉甲去，我也要下到你那裡去獻燔祭和平安祭。你要等候七天，等我到了你那裡，指示你所當行的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","掃羅轉身離開撒母耳的時候，　神就改變了他，賜給他一顆新心。那一天，這一切徵兆都實現了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","掃羅到了那山，有一班先知迎面而來。　神的靈大大感動他，他就在他們中間受感說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","所有以前認識掃羅的人，看見他和他們一起受感說話，就彼此說：“基士的兒子怎麼啦！掃羅也列在先知中間嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","那裡有一個人回答：“這些人的父親是誰呢？”因此，後來有句俗語說：“掃羅也列在先知中間嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","掃羅受感說話完了以後，就到邱壇去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","掃羅的叔叔問掃羅和他的僕人說：“你們到哪裡去了？”他回答：“找母驢去。我們找不到，就去見撒母耳。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","掃羅的叔叔說：“你把撒母耳對你們所說的話告訴我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","掃羅對他叔叔說：“他清楚地告訴我們，母驢已經找到了。”至於撒母耳所說有關王國的事，掃羅卻沒有告訴他的叔叔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","撒母耳召集眾民到米斯巴耶和華那裡， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","對他們說：“耶和華以色列的　神這樣說：‘我把你們以色列人從埃及帶上來，我救你們脫離埃及人的手，又救你們脫離所有欺壓你們的列國人的手。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","你們今天卻離棄了那位拯救你們脫離一切災難和困苦的　神，竟對他說：‘求你立一個王統治我們。’現在你們要按著你們的支派和家族，站在耶和華面前。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","撒母耳使以色列眾支派都近前來，抽籤抽中了便雅憫支派； ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","他又使便雅憫支派按著家族近前來，抽籤抽中了馬特利；再抽籤抽中了基士的兒子掃羅。眾人尋找他，卻找不到。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","於是他們求問耶和華：“那人到這裡來了沒有？”耶和華說：“他躲在那些物件中。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","他們就跑過去，把他從那裡領出來；他站在眾人中間，比眾人都高出一個頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","撒母耳對眾民說：“你們看見耶和華所揀選的人沒有？在眾人中沒有一個可與他相比。”眾人就大聲歡呼：“願王萬歲！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","撒母耳把國法對眾人述說了，又記在書上，存放在耶和華面前，然後遣散眾人，各回自己的家去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","掃羅也回基比亞自己的家裡去了，有一些勇士與他一起回去；他們的心都被　神感動。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","但是有些流氓說：“這人怎能拯救我們呢？”就藐視他，也沒有送他禮物。掃羅卻沒有說甚麼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","亞捫人拿轄上來，安營攻擊基列．雅比。所有的雅比人都對拿轄說：“你與我們立約，我們就服事你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","亞捫人拿轄對他們說：“這是我與你們立約的條件：我要剜出你們各人的右眼，用來羞辱以色列眾人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","雅比的長老對他說：“請你寬限我們七天，好讓我們派遣使者到以色列的全境去；如果沒有人拯救我們，我們就出來向你投降。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","使者到了掃羅住的基比亞，把這些話說給眾民聽，眾民就都放聲大哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","那時，掃羅正從田裡趕牛回來，問說：“甚麼事啊？為甚麼人都在哭呢？”於是有人把雅比人的話告訴他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","掃羅聽了這些話，　神的靈大大感動他，他就非常忿怒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","他牽來一對牛，把牠們切成碎塊，交給使者，送到以色列的全境去，說：“不出來跟從掃羅和撒母耳的，他的牛也必受到這樣的對待。”因眾民懼怕耶和華，他們就都出來，如同一人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","掃羅在比色數點他們。以色列人共有三十萬，猶大人有三萬。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","掃羅對前來的使者說：“你們要這樣對基列．雅比人說：‘明天中午，你們必得拯救。’”使者回去告訴基列．雅比人，他們就歡喜了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","雅比人對亞捫人說：“明天我們出來向你們投降，你們看怎麼好，就怎麼待我們吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","第二天，掃羅把眾人分成三隊。在晨更的時候，他們進了亞捫人的營中，擊殺他們，直到中午；殘餘的人都星散了，他們中間沒有兩個人留在一起的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","眾民對撒母耳說：“那說‘掃羅怎能作我們的王’的是誰呢？把那些人交出來，我們好殺死他們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","掃羅說：“今天不可以殺人，因為今天是耶和華在以色列中施行拯救的日子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","撒母耳對眾民說：“來吧，我們往吉甲去，好在那裡重新建立王國。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","眾民就都到吉甲去，在那裡在耶和華面前立掃羅為王，又在那裡在耶和華面前獻平安祭。掃羅和以色列眾民都在那裡，非常歡喜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","撒母耳對以色列人說：“看哪！我已經聽從了你們向我所說的一切話，為你們立了一個王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","現在，有這王領導你們。至於我，我已經年老髮白，我的兒子也都在你們那裡；我自幼年直到今日都領導你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","看哪，我在這裡！你們只管在耶和華面前，以及在他的受膏者面前，作證指控我：我奪過誰的牛？搶過誰的驢？欺負過誰？虐待過誰？從誰手裡受過賄賂，以致我的眼睛因此被蒙住呢？如果有，我必償還給你們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","他們回答：“你沒有欺負過我們，沒有虐待過我們，也沒有從誰手裡取過甚麼東西。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","撒母耳對他們說：“今天耶和華在你們中間作見證，他的膏立者也作見證；你們在我手裡沒有找到甚麼。”他們說：“願他作證。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","撒母耳對人民說：“從前選立摩西和亞倫，又把你們的列祖從埃及地領上來的，是耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","現在你們要站住，我要在耶和華面前與你們講論耶和華向你們的列祖所行一切公義的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","從前雅各到了埃及，後來你們的列祖哀求耶和華，耶和華就差遣摩西和亞倫去把你們的列祖從埃及領出來，又使他們在這地方居住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","他們卻忘記了耶和華他們的　神，　神就把他們交在夏瑣的將軍西西拉的手中，以及非利士人和摩押王的手中，於是這些人常常攻打他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","他們就哀求耶和華，說：‘我們犯了罪，因為我們背棄了耶和華，又去服事巴力和亞斯他錄。現在求你救我們脫離仇敵的手，我們就必事奉你。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","於是耶和華差遣耶路．巴力、比但、耶弗他、撒母耳，救你們脫離四圍仇敵的手，你們才可以安然居住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","可是，你們看到亞捫王拿轄來攻擊你們，就對我說：‘不行，我們要有一個王來統治我們。’其實，耶和華你們的　神是你們的王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","現在，你們所揀選、所要求的王在這裡。看哪！耶和華已經立了一個王統治你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","如果你們敬畏耶和華，事奉他，聽從他的話，不違背他的命令，你們和統治你們的王就必跟從耶和華你們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","但是，如果你們不聽從耶和華的話，違背他的命令，耶和華的手就必攻擊你們，好像攻擊你們的列祖一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","現在你們要站著，看耶和華在你們眼前將要施行的這件大事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","現今不是收割麥子的時候嗎？我要向耶和華呼求，他就會打雷降雨，你們就可以知道，又可以看見，你們為自己要求立王的事，在耶和華看來，是行了極大的惡事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","於是撒母耳向耶和華呼求，耶和華就在那天打雷降雨，眾民就非常懼怕耶和華和撒母耳。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","眾民對撒母耳說：“求你為僕人向耶和華你的　神禱告，免得我們死亡，因為我們為自己要求立王的事，是在我們的一切罪上又增加了這一件惡事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","撒母耳對人民說：“不要懼怕！雖然你們行了這一切惡事，只是不可偏離不跟隨耶和華，總要一心事奉他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","不可偏離耶和華，去追隨那些空虛的偶像，因為它們本是空虛的，對人沒有甚麼益處，也不能救人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","耶和華為了自己的大名的緣故，必不丟棄他的子民，因為他喜歡使你們作他的子民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","至於我，我決不停止為你們禱告，以致得罪耶和華；我要把善道正路教導你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","你們只要敬畏耶和華，誠實全心事奉他，因為你們已經看過他為你們所作的是何等大的事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","如果你們繼續行惡，你們和你們的王就必一同滅亡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","掃羅登基的時候年三十歲，作了以色列王四十二年（原文缺完整的年數，這裡是按《七十士譯本》加上的）。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","他從以色列人中為自己揀選了三千人；兩千人和掃羅一同駐在密抹和伯特利山，一千人與約拿單一同駐在便雅憫的基比亞。其餘的人，掃羅都遣散他們各回自己的家去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","約拿單攻打非利士人在迦巴的駐軍，非利士人聽見了；掃羅就在全地吹角，說：“讓希伯來人都聽見。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","以色列眾人聽說掃羅攻打了非利士人的駐軍，又聽說非利士人憎恨以色列人，就應召在吉甲跟隨掃羅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","非利士人聚集起來，要與以色列人交戰，他們有戰車三千（“三千”原文作“三萬”，這裡參考一些《七十士譯本》的抄本及敘利亞譯本翻譯）輛、騎兵六千人、步兵像海邊的沙那麼多。他們上來，在伯．亞文東邊的密抹安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","以色列人看見自己情況危急，處境窘迫，眾人就藏在山洞、巖穴、地洞裡和地坑之中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","有些希伯來人渡過了約旦河，逃到迦得和基列地。但是掃羅仍然留在吉甲，跟隨他的眾人都恐懼戰兢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","掃羅照著撒母耳所定的日期等了七天，但撒母耳還沒有來到吉甲，眾人就離開掃羅散去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","掃羅說：“你們把燔祭和平安祭帶到我這裡來。”他就獻上燔祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","他剛剛獻完了燔祭，撒母耳就來到了；掃羅出去迎接他，向他問安。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","撒母耳說：“你作了甚麼事？”掃羅回答：“因為我看見眾民都離開我散去了，你又沒有照所定的日子來到，而非利士人正在密抹聚集起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","我心裡想：‘非利士人現在就要下到吉甲來攻打我，我卻還沒有向耶和華求恩。’所以我就勉強自己把燔祭獻上了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","撒母耳對掃羅說：“你作了糊塗事了！你沒有謹守耶和華你的　神吩咐你的命令。如果你謹守，耶和華就必在以色列中堅立你的王位，直到永遠。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","但現在你的王位必不長久，耶和華已經為自己找到一個合他心意的人，立他作自己子民的領袖，因為你沒有謹守耶和華所吩咐你的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","於是撒母耳動身，從吉甲上便雅憫的基比亞去；掃羅數點跟隨他的人，約有六百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","掃羅和他的兒子約拿單，以及跟隨他們的人都停留在便雅憫的迦巴，非利士人卻在密抹安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","有突擊隊從非利士人的營裡出來，分成三隊，一隊往俄弗拉向書亞地去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","一隊往伯．和崙去，一隊往洗波音谷對面的境界向曠野去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","那時，以色列全地找不到一個鐵匠，因為非利士人說：“恐怕希伯來人製造刀劍或槍矛。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","以色列眾人要磨鋤頭、犁頭、斧頭和鏟子，就各自下到非利士人那裡去磨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","磨鋤頭或犁頭的價錢是七克銀子，磨三齒叉、斧頭或刺棒的價錢是四克銀子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","所以，到了爭戰的時候，跟隨掃羅和約拿單的眾民，沒有一個手裡有刀或槍的，只有掃羅和他的兒子約拿單有刀槍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","有一隊非利士人的駐軍出到密抹的隘口去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","有一天，掃羅的兒子約拿單對替他拿武器的僕人說：“來！我們過到非利士人的駐軍那邊去吧。”但他沒有告訴父親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","那時掃羅在基比亞的邊界，坐在米磯崙的石榴樹下，跟隨他的約有六百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","其中有亞希突的兒子亞希亞帶著以弗得；亞希突是以迦博的哥哥，非尼哈的兒子，以利的孫子。以利從前在示羅作耶和華的祭司。約拿單去了，眾人都不知道。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","約拿單設法要經過那個隘口到非利士人的駐軍那裡去，隘口的兩邊各有一個山峰，一個名叫播薛，另一個名叫西尼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","一個高峰向北，與密抹相對，另一個向南，與迦巴相對。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","約拿單對替他拿武器的僕人說：“來！我們過到這些未受割禮的人的駐軍那裡去，也許耶和華會為我們動工，因為不論人多或人少，都不能妨礙耶和華施行拯救。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","替他拿武器的僕人對他說：“照你的心意作吧！去吧，我必與你同心。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","約拿單說：“我們要過到那些人那裡去，讓他們看見我們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","如果他們對我們這樣說：‘你們站住！等我們到你們那裡去。’我們就站在原地，不上他們那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","如果他們對我們這樣說：‘你們上到我們這裡來吧！’我們就上去，這就是我們的憑據，因為耶和華已經把他們交在我們的手裡了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","他們二人就讓非利士人的駐軍看見。非利士人說：“看哪！有希伯來人從他們躲藏的洞裡出來了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","駐軍中有人應聲對約拿單和替他拿武器的人說：“你們上我們這裡來吧！我們有一件事要告訴你們。”約拿單對替他拿武器的人說：“你跟我上去，因為耶和華已經把他們交在以色列人的手裡了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","約拿單手腳並用地爬了上去，替他拿武器的人跟著他。非利士人在約拿單面前倒下，替他拿武器的也跟在後面把他們殺死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","約拿單和替他拿武器的第一次殺敵，約殺死了二十人，都是在四分之一公頃的範圍內殺的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","於是在營房裡，在田野中和在眾人中間，都有恐慌，駐軍和突擊隊也都恐懼，地也震動，這是從　神而來的恐懼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","在便雅憫的基比亞，掃羅的瞭望兵看見非利士人的大軍潰敗，四處逃竄。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","於是掃羅對跟隨他的眾民說：“你們數點一下，看看誰從我們這裡出去了。”他們一數點，就發現約拿單和替他拿武器的不在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","掃羅對亞希亞說：“把　神的約櫃運來！”因為那時　神的約櫃在以色列人那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","掃羅正對祭司說話的時候，非利士營中的騷亂越來越大，掃羅就對祭司說：“住手吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","掃羅和所有跟隨他的人就聚集起來，到了戰場，就看見非利士人用刀互相擊殺，十分混亂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","那些從前歸順非利士人的希伯來人，就是混雜在營裡與非利士人一起上來的，現在也轉過來，與那些跟從掃羅和約拿單的以色列人在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","那些躲藏在以法蓮山地的以色列眾人一聽見非利士人逃跑，也就在戰場上緊緊追趕他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","那一天，耶和華拯救了以色列人。戰爭伸展到伯．亞文。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","那一天，以色列人處境很窘迫，因為掃羅叫眾人起誓說：“不等到晚上，不等到我向敵人報了仇，就吃食物的，那人必受咒詛。”所以眾民都沒有嘗過食物。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","眾人進了樹林，林中地上有蜂蜜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","他們進了樹林，看見有蜂蜜流出來，卻沒有人敢伸手取蜜入口，因為眾人都害怕所起的誓。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","約拿單沒有聽見他父親叫眾民所起的誓，所以伸出手中的杖，用杖頭蘸在蜂房裡，轉手送進口裡，他的眼睛就明亮了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","眾民中有一個人說：“你父親曾經叫眾人嚴嚴地起誓說：‘今天吃食物的，那人必受咒詛。’所以眾人都疲乏了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","約拿單說：“我父親連累了這地的人。你們看！我嘗了這一點蜂蜜以後，我的眼睛就明亮了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","今天眾民若是隨意吃了從他們的仇敵奪得的東西，不是更好嗎？如今被擊殺的非利士人，不是更多嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","那一天，他們擊殺非利士人，從密抹直到亞雅崙；眾人都非常疲乏了， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","就急忙搶奪戰利品；他們捉住了羊、牛或牛犢，就地宰殺，帶著血一起吃了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","有人告訴掃羅說：“眾民吃了帶著血的肉，得罪耶和華了。”他說：“你們作了不忠的事了，立刻把一塊大石頭滾到我這裡來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","掃羅又說：“你們分散到眾人中去，對他們說：‘你們各人要把自己的牛羊帶到我面前來，在這裡宰了吃；不可吃帶著血的肉，得罪耶和華。’”於是當天晚上，眾人都各把自己的牛羊帶到那裡宰了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","掃羅為耶和華築了一座祭壇，這是他初次為耶和華築的祭壇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","掃羅說：“我們趁著晚上下去追趕非利士人，搶掠他們，直到天亮，不讓他們留下一人。”他們說：“你看怎麼好，就怎麼行吧！”但祭司說：“我們先在這裡親近　神！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","掃羅求問　神：“我可以下去追趕非利士人嗎？你把他們交在以色列人的手裡嗎？”那天　神沒有回答他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","掃羅說：“民間的眾領袖啊，你們都要走近這裡來；你們要查看今天我們犯了甚麼罪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","我指著拯救以色列、永活的耶和華起誓，即使是我的兒子約拿單犯了罪，他也一定要死。”眾人中沒有一人回答他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","於是掃羅對以色列眾人說：“你們站在這裡，我和我的兒子約拿單站在那邊。”眾民回答掃羅：“你看怎麼好，就怎麼行吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","掃羅禱告耶和華以色列的　神說：“求你指示實情！”於是抽籤，抽中了約拿單和掃羅；眾民都沒事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","掃羅說：“你們再抽籤，看是我，或是我的兒子約拿單。”結果抽中約拿單。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","掃羅對約拿單說：“告訴我，你作了甚麼事？”約拿單告訴他：“我用我手中的杖頭嘗了一點蜂蜜。我在這裡，我願意死！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","掃羅說：“約拿單啊！你必定要死，否則，願　神加倍懲罰我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","眾民對掃羅說：“約拿單在以色列人中行了這樣大的拯救，難道一定要他死嗎？絕對不可以！我們指著永活的耶和華起誓，連他一根頭髮也不可落在地上，因為他今天是與　神一同作工。”這樣，眾民救了約拿單，使他免了一死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","掃羅上去，不再追趕非利士人；非利士人也回到自己的地方去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","掃羅取得了以色列的王國以後，常常攻打四圍的一切仇敵，就是摩押人、亞捫人、以東人、瑣巴眾王和非利士人，他無論往哪裡去，都得到勝利。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","掃羅行事勇敢，擊敗了亞瑪力人，把以色列人從搶掠他們的人手中救了出來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","掃羅的兒子是約拿單、亦施韋和麥基舒亞。他的兩個女兒，長女名叫米拉，次女名叫米甲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","掃羅的妻子名叫亞希暖，是亞希瑪斯的女兒。掃羅軍隊的元帥名叫押尼珥，是尼珥的兒子，尼珥是掃羅的叔叔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","掃羅的父親基士和押尼珥的父親尼珥都是亞別的兒子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","掃羅的一生常常與非利士人有猛烈的爭戰。每逢掃羅看見任何勇士或有能力的人，就都招募歸他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","撒母耳對掃羅說：“耶和華差遣我膏立你作他子民以色列的王，所以現在你要聽耶和華的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","萬軍之耶和華這樣說：‘以色列人從埃及上來的時候，亞瑪力人對他們所行的，在路上攻擊他們的事，我必要懲罰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","現在你要去攻打亞瑪力人，徹底毀滅他們所有的一切，不可憐惜他們。無論男女、孩童，或吃奶的嬰兒，牛羊、駱駝、驢子，都要殺死。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","於是掃羅招聚眾人，在提拉因數點他們，共有步兵二十萬，另有猶大人一萬。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","掃羅到了亞瑪力人的城市，就在山谷中設下伏兵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","掃羅又對基尼人說：“你們走吧！離開亞瑪力人下去吧！免得我把你們與他們一同消滅。因為以色列眾人從埃及上來的時候，你們曾經以慈愛待他們。”於是基尼人離開亞瑪力人去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","掃羅擊殺亞瑪力人，從哈腓拉直到埃及東的書珥， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","生擒了亞瑪力人的王亞甲，用刀殺滅了所有人民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","但掃羅和眾人憐惜亞甲，也愛惜上好的牛羊、肥牛犢、羊羔和一切美好的東西。他們不願徹底毀滅這些；凡是卑賤的、沒有價值的，他們就徹底毀滅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","耶和華的話臨到撒母耳說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“我後悔立了掃羅為王，因為他已經離去不跟隨我，也不執行我的命令了。”撒母耳非常忿怒，整夜哀求耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","撒母耳清早起來，要在早晨去見掃羅；有人告訴撒母耳：“掃羅到了迦密，在那裡為自己立了一座紀念碑，然後轉身下到吉甲去了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","撒母耳到了掃羅那裡，掃羅對他說：“願耶和華賜福給你！我已經執行了耶和華的命令。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","撒母耳說：“我耳中聽見有羊叫牛鳴的聲音，到底是甚麼呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","掃羅回答：“這是眾民從亞瑪力人那裡帶來的，因為他們愛惜這些上好的牛羊，要獻給耶和華你的　神為祭；其餘的，我們都已經徹底毀滅了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","撒母耳對掃羅說：“住口吧！讓我把耶和華昨天晚上對我所說的話告訴你。”掃羅對他說：“請說。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","撒母耳說：“從前你雖然自以為微小，不是作了以色列眾支派的首領嗎？耶和華膏立了你作以色列的王， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","差遣你去，說：‘你去徹底毀滅那些犯罪的亞瑪力人，攻打他們，直到把他們全部毀滅。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","你為甚麼沒有聽從耶和華的話，急於奪取戰利品，作了耶和華看為惡的事呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","掃羅回答撒母耳：“我實在聽從了耶和華的話，行了耶和華差遣我行的路；我把亞瑪力人的王亞甲帶了回來，又把亞瑪力人都徹底毀滅了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","可是眾民卻從那些戰利品中，取了應當毀滅之物中上好的牛羊，要在吉甲獻給耶和華你的　神為祭。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","撒母耳說：“耶和華喜悅燔祭和平安祭，豈像喜悅人聽從耶和華的話呢？聽從勝過獻祭，聽命勝過公羊的脂油。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","因為悖逆與行邪術的罪相同，頑梗與拜虛無偶像一樣，因為你棄絕了耶和華的話，耶和華也棄絕了你作王。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","於是掃羅對撒母耳說：“我犯了罪了，我違背了耶和華的命令和你的話，因為我害怕眾人，聽從了他們的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","現在求你赦免我的罪，與我一同回去，我好敬拜耶和華。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","撒母耳回答掃羅：“我不與你一同回去，因為你棄絕了耶和華的話，耶和華也棄絕你作以色列的王。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","撒母耳轉身要走，掃羅拉著他外袍的衣邊，衣邊就撕裂了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","撒母耳就對他說：“今天耶和華把以色列國從你身上撕裂，賜給比你更好的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","以色列的大能者必不說謊，也不後悔。因為他不是世人，他決不後悔。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","掃羅說：“我犯了罪了，但是求你在我人民的長老面前和以色列人面前給我面子，與我一同回去，我好敬拜耶和華你的　神。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","於是撒母耳跟著掃羅回去，掃羅就敬拜耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","隨後撒母耳說：“把亞瑪力人的王亞甲帶到我這裡來！”亞甲歡歡喜喜走到他面前，心裡說：“死亡的痛苦必定過去了！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","撒母耳說：“你的刀怎樣使婦人喪子，你的母親在婦人中也要怎樣喪子。”於是撒母耳在吉甲，在耶和華面前把亞甲斬成碎塊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","後來撒母耳回拉瑪去，掃羅也上他所住的基比亞自己的家去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","撒母耳直到死的日子，再沒有看見掃羅。撒母耳為掃羅悲傷，因為耶和華後悔立了掃羅作以色列的王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","耶和華對撒母耳說：“你為掃羅悲哀要到幾時呢？我已經棄絕他作以色列的王了。你把膏油盛滿了角，然後去吧！我要差派你到伯利恆人耶西那裡去，因為我在他的眾子中，已經預定了一個為我作王。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","撒母耳說：“我怎能去呢？掃羅聽見了，必定殺我。”耶和華說：“你可以帶一頭母牛犢去，就說：‘我來是要向耶和華獻祭。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","你要請耶西參加獻祭的筵席，我就會指示你當作的。我指示你的那人，你要為我膏立他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","於是撒母耳照著耶和華的話去行。他到了伯利恆的時候，城裡的長老就都戰戰兢兢地出來迎接他，說：“你是為平安來的嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","他回答：“是為平安來的。我來是要向耶和華獻祭。你們要自潔，與我一同參加獻祭的筵席。”撒母耳使耶西和他的兒子自潔，邀請他們來參加獻祭的筵席。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","他們來到的時候，撒母耳看見以利押，就心裡想：“在耶和華面前的這位，必是他所要膏立的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","但耶和華對撒母耳說：“不要看他的外貌和他高大的身材，因為我不揀選他。耶和華看人不像人看人，人是看外表，耶和華是看內心。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","耶西叫亞比拿達在撒母耳面前經過，撒母耳說：“這也不是耶和華所揀選的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","耶西又叫沙瑪經過。撒母耳說：“耶和華也不揀選這個。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","耶西叫他的七個兒子都在撒母耳面前經過。但撒母耳對耶西說：“這些都不是耶和華所揀選的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","撒母耳問耶西：“孩子們全都在這裡嗎？”耶西回答：“還有一個最小的，正在牧羊。”撒母耳對耶西說：“你派人去把他帶回來，因為他沒有來到以前，我們決不入席。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","耶西就派人去把大衛帶回來。他面色紅潤，眼目清秀，外貌英俊。耶和華說：“就是這一個，你起來膏立他吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","撒母耳就拿起盛油的角，在他的兄長中膏立他。從那天起，耶和華的靈就大大感動大衛。後來撒母耳動身往拉瑪去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","耶和華的靈離開了掃羅。有惡鬼從耶和華那裡來驚擾他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","掃羅的臣僕對他說：“看哪！有惡鬼從　神那裡來驚擾你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","願我們的主吩咐你面前的臣僕，去尋找一位善於彈琴的人；從　神那裡來的靈臨到你身上的時候，他可以彈琴，你就好了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","掃羅對他的臣僕說：“你們可以為我找一個善於彈琴的人，帶到我這裡來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","有一個僕人回答：“我見過伯利恆人耶西的一個兒子，他善於彈琴，是個大能的勇士，又是個戰士，談吐合宜，容貌俊美，耶和華也與他同在。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","於是掃羅派遣使者去見耶西，說：“請你叫你放羊的兒子大衛到我這裡來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","耶西就牽來一頭驢子，馱上餅、一皮袋酒和一隻山羊羔，交給他的兒子大衛送給掃羅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","大衛到了掃羅那裡，就侍立在他面前。掃羅很愛他，他就作了替掃羅拿武器的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","掃羅再派人到耶西那裡去，說：“請你讓大衛侍立在我面前吧，因為我喜歡他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","每逢從　神那裡來的惡鬼臨到掃羅身上的時候，大衛就拿起琴來彈奏，掃羅就舒服暢快，惡鬼也離開了他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","非利士人聚集他們的軍隊作戰。他們聚集在屬猶大的梭哥，在梭哥和亞西加之間的以弗．大憫安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","掃羅和以色列人也聚集起來，在以拉谷安營；他們列出戰陣，要迎戰非利士人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","非利士人站在這邊山上，以色列人站在那邊山上，中間有山谷分隔。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","有一個挑戰的人從非利士人的軍營中出來，名叫歌利亞，是迦特人，身高三公尺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","他頭戴銅盔，身穿鎧甲，鎧甲的銅重五十七公斤。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","他的腿上有銅護膝，兩肩之間背著一根銅槍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","另外，他手上拿著矛，矛桿有織布的機軸那麼粗，矛頭的鐵重七公斤。還有一個拿大盾牌的人在他前面走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","歌利亞站著，向著以色列人的軍隊喊叫，對他們說：“你們為甚麼出來這裡擺列戰陣呢？我不是非利士人嗎？你們不是掃羅的僕人嗎？你們自己挑選一個人，叫他下到我這裡來吧。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","如果他能與我決鬥，擊殺了我，我們就作你們的奴僕；但是，如果我能勝過他，擊殺了他，你們就作我們的奴僕，服事我們。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","那非利士人又說：“今天我向以色列人的軍隊罵陣。你們派一個人出來，我們可以決鬥！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","掃羅和以色列眾人聽見了那非利士人所說的這些話，就都驚惶，非常害怕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","大衛是猶大伯利恆的以法他人耶西的兒子；耶西有八個兒子。在掃羅的日子，耶西已經年紀老邁了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","耶西的三個大兒子跟隨了掃羅去作戰。去了作戰的這三個兒子的名字是：長子以利押、次子亞比拿達、三子沙瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","大衛是最小的，那三個年長的都跟隨掃羅去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","大衛有時離開掃羅，回到伯利恆牧放他父親的羊群。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","那非利士人每天早晚都近前來，站著罵陣，一連有四十天之久。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","有一天，耶西對他的兒子大衛說：“你拿這十公斤烘了的穀子和這十個餅去給你的哥哥們；你要跑到營裡去給你的哥哥們， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","又拿這十塊乳酪去給他們的千夫長，看看你的哥哥們平安不平安，把他們的家書帶回來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","掃羅和大衛的哥哥們，以及以色列眾人都在以拉谷與非利士人作戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","大衛清早起來，把羊群託給一個看守的人，就照著耶西所吩咐他的，帶著食物去了。他來到軍營中的時候，軍隊正出去列陣，吶喊助陣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","以色列人和非利士人都擺列陣勢，互相對峙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","大衛把身上的東西留在看守物件的人手中，跑到戰陣上去，向他的哥哥們問安。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","大衛正與他們說話的時候，那個討戰的人，就是迦特的非利士人，名叫歌利亞，從非利士人陣中上來；他說的又是同樣的那些話，大衛都聽見了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","所有的以色列人一看見那人，就都從他面前逃跑，非常害怕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","以色列人彼此說：“這個上來的人你們看見了嗎？他上來是要向以色列人罵陣的。如果有人能擊殺他，王必賞賜他大財富，把自己的女兒給他作妻子，並且使他的父家在以色列中免納稅，免服役。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","大衛問站在他旁邊的人說：“如果有人擊殺這個非利士人，除去以色列人的恥辱，那人會得到怎麼的對待呢？這未受割禮的非利士人是誰呢？竟敢向永活的　神的軍隊罵陣？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","於是眾民用以上的那些話回答他說：“如果有人能擊殺他，那人必得這樣的對待。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","大衛與那些人說話的時候，他的大哥以利押聽見了，就向大衛發怒，說：“你為甚麼下這裡來呢？在曠野的那幾隻羊你託了給誰呢？我知道你的驕傲和你心裡的惡意。你下來是要看打仗。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","大衛說：“我現在作了甚麼事呢？不是只說了一句話嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","大衛離開他的哥哥，轉向另一個人，問同樣的問題。眾民還是用先前的話回答他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","有人聽見大衛所說的這些話，就告訴掃羅；掃羅就派人去把大衛接來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","大衛對掃羅說：“大家都不要因這非利士人喪膽，你的僕人要去與這非利士人決鬥。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","掃羅對大衛說：“你不能去與這非利士人決鬥，因為你年紀還輕，那人從小就作戰士。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","大衛對掃羅說：“你僕人是為父親放羊的，有時獅子或熊來了，從羊群中抓去一隻小羊， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","我就出去追趕牠，擊打牠，從牠的嘴裡把小羊救出來。如果牠起來攻擊我，我就揪住牠的鬍鬚，擊打牠，把牠殺死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","你僕人不但擊殺過獅子，也擊殺過熊。這個未受割禮的非利士人也必像一隻獅子或熊一樣，因為他向永活的　神的軍隊罵陣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","大衛又說：“那曾救我脫離獅爪和熊掌的耶和華，也必救我脫離這非利士人的手。”於是掃羅對大衛說：“你去吧！願耶和華與你同在。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","掃羅把自己的戰袍給大衛穿上，把銅盔戴在他的頭上，又給他穿上鎧甲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","大衛把刀佩帶在戰袍上。因為他以前沒有穿過，現在試著走一下。大衛對掃羅說：“穿戴著這些東西，我不能走動，因為我從前沒有穿過。”大衛就把這些裝備從身上脫下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","他手中拿著自己的杖，又從溪裡挑選了五塊光滑的石子，放在口袋裡，就是牧人用的那種袋子，手裡又拿著甩石的機弦，就向那非利士人走近去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","那非利士人也向著大衛慢慢走過來，拿大盾牌的人在他前面走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","那非利士人觀看，看見了大衛，就藐視他，因為他年紀還輕，面色紅潤，外貌英俊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","那非利士人對大衛說：“難道我是一條狗嗎？你竟拿杖來攻擊我。”於是指著自己的神咒詛大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","那非利士人又對大衛說：“你到我這裡來吧！我要把你的肉給空中的飛鳥和田野的走獸吃。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","大衛回答那非利士人：“你來攻擊我是靠刀、靠槍，但我來攻擊你是靠萬軍之耶和華的名；萬軍之耶和華就是你所辱罵的以色列軍隊的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","今天耶和華要把你交在我手裡，我必擊殺你，砍下你的頭。今天我還要把非利士人軍隊的屍體給空中的飛鳥和地上的野獸吃。這樣，全地的人就都知道以色列中有一位　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","也使這些人群都知道，耶和華拯救人不是靠刀，不是靠槍，因為戰爭的勝敗在於耶和華，他必把你們交在我們的手裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","那非利士人起身，迎著大衛慢慢走過來；大衛也趕快往陣上跑去，迎戰那非利士人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","大衛伸手入口袋裡，從裡面拿出了一塊石子來，用機弦甩去，擊中了那非利士人的前額；石子穿入前額裡面，他就仆倒，面伏於地。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","這樣，大衛用機弦和一塊石子勝過了那非利士人。大衛擊殺了那非利士人，但他手中沒有刀。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","大衛跑過去，站在那非利士人的身邊，拿起他的刀來，把刀從鞘中拔出來，殺死他，又用刀砍下他的頭。非利士人看見他們的勇士死了，就都逃跑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","以色列人和猶大人就起來，高聲吶喊，追趕非利士人，直到迦特的入口和以革倫的城門。被刺死的非利士人都倒在沙拉音的路上，直到迦特和以革倫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","以色列人窮追非利士人回來以後，就搶掠他們的營房。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","大衛拿起那非利士人的頭，把它帶到耶路撒冷去，卻把那人的武器放在自己的帳棚裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","掃羅看見大衛出去迎戰那非利士人，就問元帥押尼珥：“押尼珥啊，這個年輕人是誰的兒子？”押尼珥回答：“我敢指著王起誓，我不知道。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","王說：“你去問問這個少年是誰的兒子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","大衛擊殺了那非利士人回來的時候，押尼珥迎接他，把他帶到掃羅面前，大衛手中還拿著那非利士人的頭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","掃羅問他：“年輕人啊，你是誰的兒子？”大衛回答：“我是你僕人伯利恆人耶西的兒子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","大衛對掃羅說完了話，約拿單的心和大衛的心就深相契合。約拿單愛大衛如同愛自己的命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","從那天起，掃羅就把大衛留下來，不讓他回到父家去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","約拿單與大衛立盟約，因為他愛大衛如同愛自己的命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","約拿單把自己身上的外袍脫下來給大衛，又把自己的戰衣、刀、弓和腰帶都給了他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","掃羅無論差派大衛到哪裡去，他都去，並且凡事亨通。於是掃羅立他作軍兵的將領。所有的人民和掃羅的臣僕都非常高興。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","大衛擊殺了那非利士人，與眾人一同回來的時候，婦女們從以色列各城裡出來，唱歌、跳舞、打鼓、歡呼、擊磬迎接掃羅王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","婦女們跳舞、歌唱，說：“掃羅殺死千千！大衛殺死萬萬！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","掃羅非常惱怒，不喜歡這話，就說：“他們給大衛萬萬，只給我千千，就只剩下王位沒給他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","從那天起，掃羅就妒忌大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","第二天，從　神那裡來的惡鬼降在掃羅身上，他就在家中胡言亂語。大衛照常彈琴，掃羅手裡拿著槍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","掃羅把槍擲過去，心裡說：“我要把大衛刺在牆上。”大衛兩次避開了他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","掃羅懼怕大衛，因為耶和華與大衛同在，卻離開了掃羅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","因此掃羅使大衛離開自己，立他作千夫長，大衛就領導眾民出入。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","大衛所行的一切都亨通，因為耶和華與他同在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","掃羅看見大衛所行的十分亨通，就怕他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","但是所有的以色列人和猶大人都愛大衛，因為他領導他們出入。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","掃羅對大衛說：“我的大女兒米拉在這裡。我要把她賜給你作妻子；只要你作我的勇士，為耶和華爭戰。”原來掃羅心裡說：“我不好親手害他，讓非利士人害他吧。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","大衛回答掃羅：“我是誰？我是甚麼身分？我父家在以色列人中算得甚麼？我怎麼作王的女婿呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","到了掃羅的女兒米拉該嫁給大衛的時候，掃羅卻把她給了米何拉人亞得列作妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","掃羅的女兒米甲愛大衛。有人把這事告訴掃羅，掃羅就歡喜， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","心裡想：“我要把米甲給大衛，利用米甲作他的陷阱，好讓非利士人的手害他。”於是掃羅對大衛說：“你今天可以第二次作我的女婿。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","掃羅吩咐他的臣僕：“你們要私下對大衛說：‘王喜歡你，他的臣僕也都愛你，現在你要作王的女婿！’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","於是掃羅的臣僕把這些話說給大衛聽。大衛說：“你們以為作王的女婿是一件小事嗎？我是個貧窮卑微的人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","掃羅的臣僕把大衛所說的這些話都報告了掃羅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","掃羅說：“你們要對大衛這樣說：‘王不要甚麼聘禮，只要一百個非利士人的包皮，好在王的仇敵身上報仇。’”掃羅企圖使大衛死在非利士人的手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","掃羅的臣僕把這些話告訴了大衛，大衛就樂意作王的女婿。在日期未滿之時， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","大衛和跟隨他的人就起身出去，在非利士人中擊殺了二百人，把他們的包皮帶回來，滿數交給王，要作王的女婿。於是掃羅把他的女兒米甲給大衛作妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","掃羅看見耶和華與大衛同在，又知道自己的女兒米甲也愛大衛， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","就更怕大衛，常常與他為敵。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","非利士人的領袖常常出征，每逢他們出征，大衛作事都比掃羅所有的臣僕所作的更亨通，所以他的名字極為人尊重。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","掃羅吩咐他的兒子約拿單和他所有的臣僕要把大衛殺死，但掃羅的兒子約拿單非常喜愛大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","約拿單告訴大衛：“我父親掃羅正設法要殺死你。所以明天早晨你要小心，留在隱密的地方裡，躲藏起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","我會出去，到你藏身的那塊田那裡，站在我父親旁邊，和他談論你的事。我看看情形怎樣，然後告訴你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","約拿單向父親掃羅替大衛說好話，說：“王不要得罪你的僕人大衛，因為他沒有得罪你；並且他所作的，對你大有好處。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","他冒著生命的危險擊殺了那非利士人，耶和華為以色列人施行了大拯救，那時你看見了，也很歡喜。現在你為甚麼要犯罪，無緣無故殺死大衛，流無辜人的血呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","掃羅聽了約拿單的話，就起誓，說：“我指著永活的耶和華起誓，大衛必不會被殺死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","約拿單叫大衛來，把這一切話都告訴他；約拿單把大衛帶到掃羅那裡，他就像以前一樣，侍候在掃羅面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","後來，又有戰事；大衛出去與非利士人交戰，大敗他們，他們就在大衛面前逃跑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","從耶和華那裡來的惡鬼又臨到掃羅身上；那時掃羅坐在屋裡，手裡拿著槍。大衛正在彈琴， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","掃羅就想用槍刺殺大衛，把他刺在牆上，但大衛從掃羅面前躲開了，他的槍刺在牆上。那天晚上大衛逃跑，就逃脫了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","掃羅派人到大衛家裡去監視他，要在第二天早晨殺死他。大衛的妻子米甲告訴他說：“今天晚上你若不逃命，明天就會被殺死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","於是米甲從窗口把大衛縋下去，大衛就離開那裡逃走，逃脫了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","米甲把家中的一尊神像拿來，放在床上，把頭枕在用山羊毛弄成的枕頭上，再用衣服蓋著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","掃羅派人來捉拿大衛，米甲說：“他病了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","掃羅又派人去看大衛說：“你們把他連床一起抬到我這裡來，我好殺死他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","奉派的人進去，看見床上有一尊家中的神像，頭枕在用山羊毛弄成的枕頭上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","掃羅問米甲：“你為甚麼這樣欺騙我，放了我的仇敵，讓他逃走呢？”米甲回答掃羅：“他對我說：‘放我走！否則我要殺死你。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","大衛逃跑，逃脫了，來到拉瑪見撒母耳，把掃羅對他所作的一切都告訴了撒母耳。然後他和撒母耳去拿約，住在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","有人告訴掃羅：“大衛住在拉瑪的拿約。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","於是掃羅派人去捉大衛。派去的人看見一群先知正在受感說話，撒母耳站著帶領他們。那時，　神的靈也臨到掃羅的使者身上，他們都受感說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","有人把這事告訴了掃羅，他就再派別的人去，這些人也受感說話。掃羅第三次派人去，他們也受感說話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","後來，掃羅也親自到拉瑪去，到了西沽的大井，就問人，說：“撒母耳和大衛在哪裡？”有一個人回答：“在拉瑪的拿約。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","掃羅就從那裡往拉瑪的拿約去。　神的靈也臨到他身上，他一面走，一面受感說話，直到他到了拉瑪的拿約。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","他脫掉了自己的衣服，也在撒母耳面前受感說話。那一日，他整天整夜赤著身子躺著，因此有一句俗語說：“掃羅也列在先知中嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","大衛從拉瑪的拿約逃走，來見約拿單，說：“我作了甚麼？我有甚麼罪孽？我在你父親面前犯了甚麼罪，他竟尋索我的性命呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","約拿單對他說：“絕對沒有這事，你必不會死。我父親作事，無論大小，沒有不讓我知道的，為甚麼這事他偏要隱瞞我呢？不會這樣的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","大衛再起誓說：“你父親一定知道我在你眼中蒙恩，就心裡想：‘不要讓約拿單知道這事，免得他傷心。’可是，我指著永活的耶和華，又指著你的性命起誓，我離死只差一步。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","約拿單對大衛說：“你心裡想要甚麼，我必為你作成。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","大衛就對約拿單說：“你看，明天是初一，我本該與王一同坐席。但是，求你容我去藏在田裡，直到後天晚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","如果你父親不見我在座，你就說：‘大衛懇求我讓他趕回他的本城伯利恆去，因為他全家在那裡有獻年祭的事。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","如果你父親這樣說：‘好！’那麼僕人就平安無事了；如果他大大發怒，你就知道，他決意要害我了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","求你以慈愛待僕人，因為你曾與僕人在耶和華面前立盟約。如果我有罪孽，你就親手把我殺死，為甚麼要把我交給你父親呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","約拿單說：“絕對沒有這事，如果我知道我父親決意要害你，我會不告訴你嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","大衛對約拿單說：“如果你父親嚴厲地回答你，誰來告訴我呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","約拿單對大衛說：“你來，我們出到田裡去吧！”他們二人就出到田裡去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","約拿單對大衛說：“願耶和華以色列的　神作證，明天或後天約在這個時候，我探出了我父親的意思，如果他對你有好感，那時我會不派人來告訴你嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","假如我父親有意要害你，我若是不告訴你，不讓你走，不使你平平安安地離去，願耶和華加倍懲罰我。願耶和華與你同在，好像從前與我父親同在一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","我活著的時候，求你以耶和華的慈愛待我，使我不致於死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","我死了以後，耶和華從地上一一剪除大衛的仇敵的時候，你也不可向我的家永遠斷絕你的慈愛。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","於是約拿單與大衛家立盟約，說：“願耶和華藉大衛仇敵的手追討違背盟約的罪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","約拿單由於愛大衛，就使大衛再起誓；他愛大衛如同愛自己的命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","約拿單對大衛說：“明天是初一，因為你的座位空著，人必注意到你不在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","到後天，你要趕快下去，到你以前出事那天藏身的地方，在以色磐石旁邊等候。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","我要向磐石旁邊射三支箭，好像射箭靶一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","然後，我要派一個僕人去，說：‘你去把箭找回來。’如果我對那僕人說：‘看哪！箭在你的後面，把箭拿回來。’你就可以回來，因為我指著永活的耶和華起誓，你必平安無事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","如果我對僕人說：‘看哪！箭在你的前面。’你就要離去，因為是耶和華打發你去的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","至於你我之間所說的這事，有耶和華永遠在你我之間作證。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","於是大衛在田裡藏起來。到了初一，王坐席吃飯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","王照常坐在他的座位上，就是靠牆的座位，約拿單坐在對面，押尼珥坐在掃羅旁邊，大衛的座位卻空著。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","那天掃羅沒有說甚麼，因為他心裡想：“這是恰巧的事，或許大衛沾染了不潔，還沒有得到潔淨。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","次日，就是初二，大衛的座位仍是空著。於是掃羅問他的兒子約拿單：“為甚麼耶西的兒子昨天今天都沒有來吃飯呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","約拿單回答掃羅：“大衛懇切地求我讓他回伯利恆去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","他說：‘求你讓我去，因為我們的家在城裡有獻祭的事，我哥哥吩咐我去。所以，我若是在你眼前蒙恩，求你讓我離開，看看我的哥哥們。’因此，大衛沒有來赴王的筵席。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","於是掃羅向約拿單發怒，對他說：“你這邪僻悖逆婦人所生的，我豈不知道你喜悅耶西的兒子，自取羞辱，也羞辱生你的母親嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","因為只要耶西的兒子還活在這世上，你和你的國就不能穩固。現在，你要派人去把他抓到我這裡來，因為他是該死的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","約拿單回答他父親掃羅說：“為甚麼要把他處死呢？他作了甚麼事呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","掃羅向著約拿單把槍擲過去，要刺殺他。約拿單就知道，他父親已經決意要殺死大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","約拿單怒氣沖沖地從席間退去，初二這天，他沒有吃飯；因為他父親羞辱了大衛，他就為大衛擔憂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","到了早晨，約拿單照著與大衛約定的時候，出到田裡去，有一個小童與他在一起。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","他對那童僕說：“你跑去，把我所射的箭找回來。”那童僕跑去的時候，約拿單就把箭射到他前面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","那童僕到了約拿單的箭射到的地方，約拿單就在那童僕的背後喊叫：“箭不是在你的前面嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","約拿單又在那童僕的背後喊叫：“趕快跑去！不要停留！”那童僕就把箭拾起來，回到他主人那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","那童僕一點也不知道這是甚麼意思，只有約拿單和大衛知道。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","約拿單把自己的武器交給他的童僕，對他說：“你帶回城裡去吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","那童僕一離去，大衛就從石堆的南邊起來，臉伏於地，叩拜了三次。二人互相親嘴，相對哭泣，大衛哭得更悲痛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","約拿單對大衛說：“你平平安安走吧！我們二人曾指著耶和華的名起誓說：‘願耶和華在你我之間，也在我的後裔和你的後裔之間作證，直到永遠。’”大衛就起身離開，約拿單也回城裡去了（“大衛就起身離開，約拿單也回城裡去了。”在《馬索拉抄本》為21:1）。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","大衛到了挪伯祭司亞希米勒那裡，亞希米勒戰戰兢兢地迎接大衛，對他說：“你為甚麼獨自一人，沒有人跟隨你呢？”（本節在《馬索拉抄本》為21:2） ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","大衛對亞希米勒祭司說：“王吩咐我作一件事，對我說：‘我差派你，吩咐你去辦的這事，你不要讓任何人知道，我已經指示我的僕人在某地會面。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","現在你手中有甚麼？求你給我五個餅，或是別的食物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","祭司回答大衛：“我手中沒有普通的餅，只有聖餅。只有那些沒有親近過女人的年輕人，才可以吃的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","大衛回答祭司說：“像以往我出征的時候一樣，這次我們出征前，確實沒有親近女人。雖然這是一次普通的任務，眾僕人的器皿還是清潔的，何況今天這些器皿更加是清潔的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","於是祭司把聖餅給他，因為在那裡沒有別的餅，只有陳設餅，就是那些剛從耶和華面前拿下來，為要換上熱的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","那天有一個掃羅的臣僕在那裡，留在耶和華面前。他名叫多益，是以東人，是掃羅牧羊人中的領袖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","大衛問亞希米勒：“你手下有槍有刀沒有？因為王的事很急迫，所以我手裡連刀劍或其他武器都沒有帶來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","祭司回答：“有一把刀，是你從前在以拉谷擊殺的那非利士人歌利亞的刀。這刀用布包著，放在以弗得後面，你若是要拿去自用，就拿去吧，因為這裡除了這刀以外，再沒有別的武器了。”大衛說：“沒有比這更好的刀了，請你給我吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","那一天大衛起來，從掃羅面前逃走，到了迦特王亞吉那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","亞吉的臣僕對亞吉說：“這不是那地的王大衛嗎？那裡的婦女不是指著他跳舞歌唱說：‘掃羅殺死千千，大衛殺死萬萬’嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","大衛把這些話記在心裡，他非常怕迦特王亞吉， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","就在眾人面前假裝神智不健全，在他們手下裝瘋，在城門的門扇上胡亂塗寫，又讓唾沫流到鬍鬚上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","亞吉就對他的臣僕說：“你們看，這個人瘋了，你們為甚麼把他帶到我這裡來呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","難道我缺少瘋子嗎？你們竟把這人帶來我面前發瘋。這人怎可以進我的家呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","大衛離開那裡，逃到亞杜蘭洞。他哥哥們和他父親的全家聽到了，就都下到他那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","凡是受窘迫的、負債的、心裡不滿的，都聚集到大衛那裡，他就成了他們的領袖。那時，跟從他的約有四百人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","大衛從那裡到摩押的米斯巴去，對摩押王說：“求你容許我父母來住在你們這裡，直到我知道　神要為我作甚麼。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","於是大衛把他們留在摩押王那裡。大衛住在山寨的日子有多久，他父母也與摩押王同住多久。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","迦得先知對大衛說：“你不要留在山寨，要到猶大地去。”大衛就離開那裡，往哈列的森林去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","掃羅聽見發現了大衛和跟從他的人的行蹤。那時掃羅在基比亞坐在山上一棵垂柳樹下，手中拿著槍，眾臣僕侍立在他周圍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","掃羅就對侍立在他周圍的臣僕說：“便雅憫人哪，你們要聽！耶西的兒子能把田地和葡萄園賜給你們各人嗎？他能立你們各人作千夫長、作百夫長嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","你們竟都同謀陷害我。我的兒子與耶西的兒子立盟約的時候，沒有人告訴我；我的兒子挑唆我的臣僕陷害我，就像今天一樣，你們中間也沒有人關心我，告訴我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","那時以東人多益與掃羅的臣僕侍立在那裡，他回答說：“我曾看見耶西的兒子到了挪伯亞希突的兒子亞希米勒那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","亞希米勒為他求問耶和華，給他糧食，又把非利士人歌利亞的刀給他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","掃羅就派人去把亞希突的兒子，亞希米勒祭司和他父親的全家，就是在挪伯的眾祭司，都召了來；他們眾人都來見王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","掃羅說：“亞希突的兒子啊！你要聽。”他回答：“我主啊！我在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","掃羅對他說：“你為甚麼與耶西的兒子合謀陷害我？把食物和刀給他，又為他求問　神，使他起來陷害我，就像今天一樣呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","亞希米勒回答王說：“在你所有的臣僕中，有誰像大衛那樣忠心呢？他是王的女婿，又是你的衛隊的隊長，並且在你朝中是受敬重的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","我豈是今天才開始為他求問　神的呢？絕對不是。請王不要歸罪於我和我父的全家，因為這整件事無論大小，我都不知道。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","王說：“亞希米勒啊！你和你父的全家都是該死的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","王就對侍立在他周圍的衛兵說：“你們轉過去，把耶和華的祭司殺死，因為他們與大衛攜手，又因為他們知道大衛逃跑，也不告訴我。”但王的臣僕不願下手殺害耶和華的祭司。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","於是王對多益說：“你轉過去把祭司擊殺。”以東人多益就轉過去把祭司擊殺了。那一天，他殺了八十五個穿以弗得的人， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","又用刀擊殺了祭司城挪伯，無論男女，孩童或吃奶的嬰兒，牛驢或羊，都用刀殺盡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","亞希突的兒子亞希米勒有一個兒子，名叫亞比亞他，逃過了大難，就逃去跟隨大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","亞比亞他把掃羅殺害耶和華祭司的事告訴了大衛， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","大衛就對亞比亞他說：“那一天我見以東人多益在那裡，就知道他必定會告訴掃羅。你父全家每個人的死，我都有責任。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","你可以住在我這裡。不要懼怕，因為那尋索你命的，正在尋索我的命，你與我在一起就可保安全。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","有人告訴大衛：“看哪，非利士人正在攻打基伊拉，並且搶掠禾場。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","大衛就求問耶和華說：“我可以去擊打這些非利士人嗎？”耶和華對大衛說：“你可以去擊打非利士人，拯救基伊拉。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","跟隨大衛的人對他說：“看哪，我們在猶大地這裡尚且懼怕，何況到基伊拉去攻打非利士人的軍兵呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","於是大衛再求問耶和華。耶和華回答他說：“你只管起來，下到基伊拉去，因為我必把非利士人交在你的手裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","大衛和跟隨他的人就到基伊拉去，與非利士人爭戰，擄走了他們的牲畜，又在他們中間殺戮多人。這樣，大衛拯救了基伊拉的居民。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","亞希米勒的兒子亞比亞他逃到基伊拉去見大衛的時候，是手裡帶著以弗得下來的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","有人告訴掃羅，大衛到了基伊拉，掃羅就說：“　神把他交在我的手中了，因為他進了一座有門有閂的城，把自己關閉起來了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","於是掃羅召集眾人去爭戰，要下到基伊拉去，圍困大衛和跟隨他的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","大衛知道掃羅設計害他，就對亞比亞他祭司說：“把以弗得拿來！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","大衛說：“耶和華以色列的　神啊！你僕人確實聽見了掃羅想要到基伊拉來，為了我的緣故要毀滅這城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","基伊拉人會把我交在掃羅的手裡嗎？掃羅會照著你僕人所聽到的下來嗎？耶和華以色列的　神啊！求你告訴你僕人。”耶和華說：“他必下來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","大衛又說：“基伊拉人會把我和跟隨我的人交在掃羅手裡嗎？”耶和華說：“他們必把你們交出來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","大衛和跟從他的人，約有六百人，就起身離開基伊拉，到處漂泊。有人告訴掃羅，大衛已經逃離了基伊拉，掃羅就不出去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","大衛住在曠野的山寨裡，又住在亞弗曠野的山裡。掃羅天天尋索大衛，　神卻不把大衛交在他手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","大衛懼怕，因為掃羅出來尋索他的命。那時大衛住在西弗曠野的何列斯那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_16","010_23_16","1SA","23","16","16","掃羅的兒子約拿單起身，到何列斯去見大衛，鼓勵他，使他靠　神堅強起來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_17","010_23_17","1SA","23","17","17","對他說：“你不要懼怕！我父親掃羅的手必不能害你。你必要作以色列的王，我要在你以下位居第二，這事連我父親掃羅也知道了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","於是他們二人在耶和華面前立了約。大衛仍住在何列斯，約拿單卻回自己的家去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","西弗人上到基比亞去見掃羅，說：“大衛不是在我們這裡的何列斯的山寨，就是在曠野南邊的哈基拉山上藏著嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","王啊，現在請下來，請你隨著你的心願下來，我們必親自把他交在王的手裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","掃羅說：“願耶和華賜福你們，因為你們關心我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","你們要去再確實查看他腳蹤所到的地方，有誰看見他在那裡，因為有人對我說，他非常狡猾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","你們要去查看他所有藏身的地方，確定以後再回來見我，我就與你們同去；如果他在本地，我必從猶大的千門萬戶中把他搜出來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","於是西弗人起身，在掃羅以先到西弗去了。那時大衛和跟隨他的人卻在瑪雲曠野，就是在荒野南邊的亞拉巴。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","掃羅和跟隨他的人去尋找大衛。有人告訴大衛，他就下到磐石那裡，留在瑪雲曠野。掃羅聽見了，就在瑪雲曠野追趕大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","掃羅在山這邊走，大衛和跟隨他的人卻在山那邊走。大衛匆匆忙忙逃避掃羅，掃羅和跟隨他的人卻四面包圍大衛和跟隨他的人，要把他們捉住。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","那時忽有使者來見掃羅說：“請你趕快回去，因為非利士人來突擊這地。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","於是掃羅不再追趕大衛，回去迎戰非利士人。因此這地方被稱為西拉．哈瑪希羅結。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","大衛從那裡上去，住在隱．基底的山寨裡。（本節在《馬索拉抄本》為24:1） ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","掃羅追趕非利士人回來的時候，有人告訴他說：“看哪，大衛在隱．基底的曠野。”（本節在《馬索拉抄本》為24:2） ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","掃羅就從以色列人中選出三千精兵，帶領他們到野羊磐石去搜索大衛和跟隨他的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","到了路旁的羊圈，那裡有一個洞，掃羅進去大解；那時，大衛和跟隨他的人正坐在洞裡的深處。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","跟隨大衛的人對他說：“耶和華曾應許你說：‘我要把你的仇敵交在你的手裡，你可以隨意待他。’看哪！今天就是時候了。”於是大衛起來，悄悄地割下掃羅外袍的衣邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","事後，大衛為了割下掃羅的衣邊，心中自責， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","就對跟隨他的人說：“我在耶和華面前絕對不能這樣對待我主耶和華的受膏者，我絕對不能動手攻擊他，因為他是耶和華的受膏者。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","大衛用這些話阻止了跟隨他的人，不讓他們起來攻擊掃羅。掃羅起來，出了山洞，繼續走他的路去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","隨後，大衛也起來，離開了山洞，在掃羅背後呼叫，說：“我主！我王！”掃羅回頭向後看的時候，大衛就臉伏於地，向他叩拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","大衛對掃羅說：“你為甚麼聽信人的話，說：‘大衛想要害你’呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","現在你親眼看到，今天耶和華在山洞裡，把你交在我手裡。有人叫我殺你，我卻愛惜你。我說：‘我不敢下手傷害我主，因為他是耶和華的受膏者。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","我父啊，請看，你外袍的衣邊在我手中。我割下了你外袍的衣邊，卻沒有殺你。你從此可以知道，也可以看出我手中沒有邪惡，也沒有過犯。我雖然沒有得罪你，你卻要獵取我的性命。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","願耶和華在你我之間判斷是非；願耶和華在你身上為我伸冤。我的手卻不敢傷害你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","正如古時的格言：‘惡事出於惡人。’所以，我的手不敢傷害你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","以色列的王出去追捕誰呢？你現在追趕誰呢？不過是追趕一條死狗，一隻跳蚤吧了！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","願耶和華在你我中間施行審判，斷定是非；願他鑒察，為我的案件伸冤，救我脫離你的手。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","大衛對掃羅說完了這些話，掃羅就說：“我兒大衛啊，這是你的聲音嗎？”於是掃羅放聲大哭， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","對大衛說：“你比我公義，因為你以良善待我，我卻以惡待你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","今天你所作的說明了你以良善待我，因為耶和華把我交在你手裡，你卻沒有殺我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","如果人遇見仇敵，怎會讓他平平安安離去呢？願耶和華因你今天對我所作的報答你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","現在我知道你必要作王，以色列的王國必在你手裡堅立起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","現在你要指著耶和華向我起誓，不剪除我的後裔，也不從我父家消滅我的名。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","於是大衛向掃羅起誓，掃羅就回自己的家去了，大衛和跟隨他的人也上山寨去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","撒母耳死了，以色列眾人都聚集起來，為他哀哭，把他埋葬在拉瑪他自己的家裡。大衛起身，下到巴蘭的曠野去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_2","010_25_2","1SA","25","2","2","在瑪雲有一個人，他的產業在迦密。他是一個很富有的人，有綿羊三千隻，山羊一千隻，那時他正在迦密剪羊毛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_3","010_25_3","1SA","25","3","3","那人名叫拿八，他的妻子名叫亞比該。這女人既聰明，又美麗。但那男人為人粗暴，又行事兇惡。他是個迦密族的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","大衛在曠野聽說拿八正在剪羊毛， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","就差派十個僕人，對他們說：“你們上迦密去見拿八，以我的名義向他問安。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","你們要這樣說：‘願你長壽！願你平安！願你的家平安！願你所有的一切都平安！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","現在我聽說有人為你剪羊毛。你的牧人與我們在一起的時候，我們都沒有侮辱他們；他們在迦密的日子，也從沒有遺失過甚麼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","你可以問問你的僕人，他們必會告訴你。願我派來的這些僕人在你眼前蒙恩，因為我們是在好日子來的，請你把手中所有的，隨便賞賜一點給你的僕人和你的兒子大衛。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","大衛的僕人到了，就以大衛的名義，把這些話都對拿八說了，然後等候答覆。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","拿八回答大衛的僕人說：“大衛是誰？耶西的兒子是誰？現在離開主人逃走的僕人太多了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","我怎能把我的餅、我的水，和我為剪羊毛的人宰殺的肉，給那些我不知道從哪裡來的人呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","於是大衛的僕人轉回原路，回去了。他們到了以後，就把這一切話都告訴大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","大衛對跟隨他的人說：“你們各人都佩上刀。”他們各人就佩上自己的刀，大衛也佩上自己的刀。跟隨大衛上去的約有四百人，有二百人留下來看守器具。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","拿八的一個僕人告訴拿八的妻子亞比該說：“大衛從曠野派遣使者來向我們的主人問候，主人卻辱罵了他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","但是，那些人對我們很好。我們在田野與他們往來的時候，他們都沒有侮辱我們，我們也從沒有遺失過甚麼。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","我們與他們在一起牧羊的日子，他們日夜都作保護我們的牆。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","現在，你要想一想，看看你該怎麼辦，因為災禍必定臨到我們的主人和他的全家。他是一個性情兇惡的人，沒有人敢對他說話。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","亞比該急忙拿了兩百個餅、兩皮袋酒、五隻預備好了的羊、十七公斤烘好了的穗子、一百個葡萄餅、兩百個無花果餅，都馱在驢背上， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","然後對她的僕人說：“你們先去，我隨著你們來。”這事她卻沒有告訴她的丈夫拿八。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","亞比該騎著驢，正從山坡下來，忽見大衛和跟隨他的人也正從對面迎著她走下來，亞比該就與他相遇了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","大衛曾經說過：“我在曠野看守這人一切所有的，使他一切所有的一樣也沒有失落，實在是白費心機了。他竟然對我以惡報善。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","如果我讓這人一切所有的，就是一個男丁，留到明天早晨，　神怎樣懲罰大衛的仇敵，願他也怎樣加倍懲罰我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","亞比該見了大衛，就急忙從驢背下來，俯伏在大衛面前，臉伏於地，向他叩拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","她又俯伏在大衛的腳前，說：“我王啊，願這罪孽歸我。求你容婢女向你講話，求你聽婢女所說的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","請我主不要把這個性情兇惡的人拿八放在心上。因為他的名字怎樣，他的為人也怎樣。他名叫拿八，他也真是愚笨。我主派來的僕人，你的婢女並沒有看見。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","我主啊，現在我指著永活的耶和華，又在你面前起誓，耶和華既然阻止了你流人的血，又阻止了你親手報仇，願你的仇敵和那些謀害我主的人，都像拿八一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","現在，請把你婢女給我主帶來的這禮物，賜給跟隨我主的僕人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","求你饒恕你婢女的過犯。耶和華必為我主建立一個堅固的家，因為我主為耶和華爭戰；在你一生的日子裡，在你身上也找不到甚麼過錯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","雖然有人起來追趕你，尋索你的命，我主的性命必得保全在耶和華你的　神生命的囊中。至於你仇敵的命，耶和華卻要甩去，像從甩石機甩出去一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","將來耶和華照著他應許的一切善待了你，立了你作以色列的領袖的時候， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","我主就不致因為無緣無故流人的血或親自報仇而良心不安，心裡有愧了。耶和華恩待了我主以後，求你記念你的婢女。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","大衛對亞比該說：“耶和華以色列的　神是應當稱頌的！他今天差派你來迎接我。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","你的智慧和你的為人也是應當稱讚的，因為你今天阻止了我流人的血，又阻止了我親手報仇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","我指著那攔阻了我加害你的永活的耶和華以色列的　神起誓，如果你不及時來迎見我，到明天早晨，拿八所有的男丁必不留一個。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","大衛從亞比該手中接受了她帶來給他的東西，就對她說：“你平平安安回家去吧！你看，我已經聽了你的話，也答應了你的請求。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","亞比該到了拿八那裡，他正在家中擺設筵席，好像帝王的筵席一樣。拿八心裡暢快，喝得爛醉如泥，所以無論大事小事亞比該都沒有告訴他，直到第二天早晨。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","到了早晨，拿八酒醒了，他的妻子才把這些事告訴他，他就嚇得魂不附體，立刻中風癱瘓了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","大約過了十天，耶和華擊打拿八，他就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","大衛聽見拿八死了，就說：“耶和華是應當稱頌的，因為他為我伸了拿八羞辱我的冤，又阻止了僕人行惡，也使拿八的惡歸到他自己的頭上。”於是大衛派人去對亞比該說要娶她作他的妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","大衛的僕人到了迦密去見亞比該，對她說：“大衛差派我們到你這裡來，要娶你作他的妻子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","亞比該就起來，面伏於地叩拜，說：“婢女願意作女僕，洗我主人的腳！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","亞比該急忙起來，騎上驢，帶著五個跟隨她的女僕，跟從大衛的使者去了，就作了大衛的妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","大衛先娶了耶斯列人亞希暖，她們二人都作了他的妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","掃羅已經把他的女兒米甲，就是大衛的妻子，賜給了迦琳人拉億的兒子帕提作妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","西弗人基比亞來見掃羅，說：“大衛不是在曠野前面的哈基拉山中躲藏起來嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","掃羅就動身，下到西弗曠野去，跟隨他的有三千以色列精兵，要在西弗的曠野尋索大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","那時，掃羅在曠野前面的哈基拉山的路旁安營，大衛仍然住在曠野。大衛看見掃羅來到曠野追尋他， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","就派出探子，知道掃羅已經到了納康。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","大衛起來，來到掃羅安營的地方，看見掃羅和他的元帥，尼珥的兒子押尼珥睡臥的地方。掃羅睡在軍營的中央，眾人都在他的周圍安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","大衛問赫人亞希米勒和洗魯雅的兒子約押的兄弟亞比篩，說：“誰願與我一起下到掃羅的營裡去呢？”亞比篩回答：“我願與你一起下去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","於是大衛和亞比篩趁著夜裡到了眾軍那裡。掃羅正躺在軍營的中央睡著了，他的矛插在頭旁的地上；押尼珥和眾軍都躺在他的周圍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","亞比篩對大衛說：“今天　神把你的仇敵交在你手裡了。現在求你容我用矛把他刺透在地上，一刺就夠，不必再刺。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","大衛卻對亞比篩說：“不可殺死他，因為有誰伸手傷害耶和華的受膏者而無罪呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","大衛說：“我指著永活的耶和華起誓，他或被耶和華擊打，或死期到了，或下到戰場陣亡了， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","我在耶和華面前，絕對不敢伸手傷害耶和華的受膏者。現在，你可以把掃羅頭旁的矛和水袋拿來，我們就走吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","於是大衛從掃羅的頭旁拿了矛和水袋，他們二人就走了。沒有人看見，沒有人知道，也沒有人醒來。他們都睡著了，因為耶和華使他們沉睡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","然後大衛過到另一邊去，遠遠地站在山頂上，兩者之間的距離很遠。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","大衛呼叫眾人和尼珥的兒子押尼珥說：“押尼珥啊，你不答話嗎？”押尼珥回答說：“你是誰，竟敢呼叫王？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","大衛對押尼珥說：“你不是一個男子漢嗎？以色列人中有誰能與你相比呢？眾民中有一個人來要殺害王你的主，你為甚麼沒有保護王你的主呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","你所作的這事不好。我指著永活的耶和華起誓，你們都是該死的，因為你們沒有保護你的主，就是耶和華的受膏者。現在你看看王頭旁的矛和水袋在哪裡？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","掃羅認出是大衛的聲音，就說：“我兒大衛啊！這是你的聲音嗎？”大衛說：“我主我王啊！是我的聲音。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","又說：“我主為甚麼這樣追趕僕人呢？我作了甚麼？我手裡犯了甚麼過錯？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","現在求我主我王聽你僕人的話。如果是耶和華激動你攻擊我，願耶和華收納祭物；如果是人激動你，願他們在耶和華面前受咒詛，因為他們今天把我趕出來，不容我在耶和華的產業上有分，說：‘你去服事別的神吧！’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","現在，求王不要讓我的血流在遠離耶和華的地上，因為以色列王出來尋索我的性命，就像人在山中獵取一隻鷓鴣一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","掃羅說：“我有罪了，我兒大衛啊，你回來吧！因為今天你看我的命為寶貴，我必不再害你。看哪！我作了糊塗事了，並且錯得很厲害。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","大衛回答說：“看哪！王的矛在這裡，可以叫一個僕人過來拿去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","耶和華必按著各人的公義和信實報答他；今天耶和華把你交在我手裡，我卻不願伸手傷害耶和華的受膏者。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","看哪，我今天怎樣看重你的命，願耶和華也怎樣看重我的命，並且救我脫離一切患難。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","掃羅對大衛說：“我兒大衛啊，願你得福，你必作成你所要作的，也必得勝。”於是大衛離去了，掃羅也回自己的地方去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","大衛心裡說：“總有一天，我會死在掃羅的手裡，我倒不如逃奔到非利士人的國土，掃羅對我就會死心，不再在以色列全境尋索我，我就可以逃脫他的手了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","於是大衛起來，和跟隨他的六百人都越過邊界，到迦特王瑪俄的兒子亞吉那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","大衛和跟隨他的人，以及他們各人的家眷，都與亞吉一同住在迦特。大衛的兩個妻子，就是耶斯列人亞希暖和作過拿八妻子的迦密人亞比該也都住在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","有人告訴掃羅，大衛已經逃到迦特去了，掃羅就不再尋索他了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","大衛對亞吉說：“我若是在你眼前蒙恩，求你在這地的城市中，給我一個地方，讓我住在那裡。為甚麼要你的僕人與你一同住在王城呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","那天，亞吉就把洗革拉賜給大衛，因此，洗革拉直到今日還是屬猶大王的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","大衛在非利士人的鄉鎮居住的日子，共有一年零四個月。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","大衛和跟隨他的人上去襲擊基述人、基色人和亞瑪力人，這些人自古以來就是這地的居民，居於書珥到埃及地之間。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","大衛攻打那地，無論男女，都不讓一人存活，又擄走了牛、羊、驢子、駱駝和衣服，然後回來，到亞吉那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","亞吉問：“你們今天襲擊了甚麼地方呢？”大衛回答：“我們襲擊了猶大的南方，耶拉蔑的南部，和基尼的南方。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","無論男女，大衛都不讓一人活著帶到迦特來，他說：“恐怕他們把我們的事告訴別人，說：‘大衛作了這樣的事，他住在非利士人鄉鎮的日子，常常這樣作。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","亞吉相信了大衛，心裡說：“他在自己的族人以色列中留下了臭名，他必永遠作我的僕人了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","那時，非利士人聚集他們的軍隊，要與以色列人爭戰。亞吉對大衛說：“你要清楚知道，你和跟隨你的人都要在軍隊中與我一同出征。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","大衛回答亞吉說：“僕人所能作的事你都知道。”於是亞吉對大衛說：“好吧，我要立你永遠作我的護衛長。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","那時，撒母耳死了，以色列眾人都為他哀哭，把他埋葬在拉瑪他自己的城裡。掃羅曾經把交鬼的和行巫術的，都從國中除去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","非利士人聚集起來，來到書念安營；掃羅也聚集以色列眾人，在基利波安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","掃羅看見了非利士人的軍隊，就懼怕，他的心大大發抖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","掃羅求問耶和華，耶和華卻沒有藉著夢，或烏陵，或先知回答他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","於是掃羅對他的臣僕說：“你們要為我尋找一個能交鬼的女人，我好去求問她。”他的臣僕回答他說：“在隱．多珥有一個能交鬼的女人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","於是掃羅改裝易服，帶著兩個人與他一同去了。他們夜裡到了那女人那裡。掃羅說：“請你用交鬼的法術，把我所告訴你的那人為我招上來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","那女人回答他：“你是知道掃羅所作的，他已經把交鬼的和行巫術的，都從國中剪除了，你為甚麼要陷害我的命，使我死呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","掃羅指著耶和華起誓說：“我指著永活的耶和華起誓，你必不因這事受懲罰。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","那女人問：“我要為你招誰上來呢？”掃羅回答：“為我招撒母耳上來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","那女人看見了撒母耳，就大聲呼叫。那女人對掃羅說：“你為甚麼欺騙我？你就是掃羅！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","王對她說：“不要懼怕。你看見了甚麼？”那女人回答掃羅：“我看見有神靈從地裡上來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","掃羅問她：“他的容貌怎樣？”她回答：“上來的是一個身披外袍的老人。”掃羅知道那人是撒母耳，就臉伏於地向他叩拜。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","撒母耳對掃羅說：“你為甚麼攪擾我，把我招上來呢？”掃羅說：“我非常苦惱，非利士人正在攻打我，　神又離開了我，不再藉著先知或異夢回答我。所以我請你上來，指示我應該怎樣行。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","撒母耳說：“耶和華既然離開了你，又成了你的敵人，你為甚麼還問我呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","耶和華已經照著他藉我所說的話行了，他把王國從你手中奪去，賜給別人，就是大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","因為你沒有聽從耶和華的話，沒有執行他對亞瑪力人所懷的烈怒，所以今天耶和華向你行了這樣的事， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","並且耶和華必把以色列和你一起都交在非利士人手裡；明天你和你的兒子們都要和我一起了。耶和華必把以色列的軍隊交在非利士人手裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","掃羅立刻全身仆倒在地上，他因撒母耳的話，非常懼怕，又因為他已經一日一夜沒有吃飯，所以一點氣力也沒有。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","那女人來到掃羅面前，見他非常驚慌，就對他說：“你看，婢女聽從了你的話；我冒著生命危險，聽從了你對我所說的話。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","現在求你也聽從婢女的話，允許我在你面前擺上一點食物。你吃了，身體就有氣力，可以走路。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","掃羅不肯，說：“我不吃。”可是他的臣僕和那女人再三勸他，他才聽從了他們的話，從地上起來，坐在床上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","那女人的家裡有一頭肥牛犢，她急忙把牠宰了，又拿點麵粉，搓好了，烤成無酵餅， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","送到掃羅和他臣僕的面前；他們吃了以後，當夜就起身離去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","非利士人把他們所有的軍隊都聚集在亞弗，以色列人卻在耶斯列的泉旁安營。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","非利士人的首領各率領百人或千人前進；大衛和跟隨他的人也跟在亞吉的後面前進。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","非利士人的領袖說：“這些希伯來人在這裡作甚麼？”亞吉對非利士人的領袖說：“這人不是以色列王掃羅的臣僕大衛嗎？他已經在我這裡有好些年日了。自從他降服我的一天，直到今日，我未曾發現他有甚麼過錯。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","非利士人的領袖向亞吉發怒，對他說：“你叫這人回去，好讓他回到你為他安排的地方去。他不可與我們一同下戰場，免得他在戰場上成為我們的對頭。這人可用甚麼去得他主人的歡心呢？豈不是用我們這些人的頭嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","這人不就是大衛嗎？從前以色列的婦女向他歌唱跳舞說：‘掃羅殺死千千，大衛殺死萬萬！’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","亞吉把大衛叫來，對他說：“我指著永活的耶和華說，你是正直的人，你與我在軍中出入，我感到很滿意，因為自從你到我這裡來的那一天，直到今日，我未曾在你身上找到甚麼過失；只是各首領不喜歡你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","現在，你可以回去，平平安安走吧！不要行非利士人的首領看為惡的事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","大衛對亞吉說：“我作了甚麼呢？自從我來到你面前的那一天，直到今日，你在僕人身上找到甚麼，使我不能與我主我王的仇敵爭戰呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","亞吉回答大衛，說：“我知道你在我眼中是個好人，像　神的使者一樣；只是非利士人的領袖曾經說過：‘他不可與我們一同上戰場。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","所以明天早晨，你和跟你來的人，就是你主人的僕人都要清早起來。你們明天早晨都要早起，天一亮你們就要離開。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","於是大衛和跟隨他的人清早起來，一早就離開，回到非利士人的地去。非利士人也上耶斯列去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","第三天，大衛和跟隨他的人到了洗革拉。那時亞瑪力人襲擊了南地和洗革拉。他們攻破了洗革拉，又放火焚燒。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","他們把婦女和城裡所有的人，無論大小都擄走了。他們沒有殺人，都帶著他們從原路回去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","大衛和跟隨他的人到了那城，看見城已經被火燒毀，他們的妻子、兒女都被擄走了， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","就放聲大哭，直哭到沒有力氣再哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","大衛的兩個妻子，耶斯列人亞希暖和作過拿八妻子的迦密人亞比該，也都被擄去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","大衛處境非常困難，因為眾人都為自己的兒女心中苦惱，說要用石頭打死大衛；但大衛靠著耶和華他的　神堅強起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","大衛對亞希米勒的兒子、亞比亞他祭司說：“請你把以弗得帶到我這裡來。”亞比亞他就把以弗得帶到大衛那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","大衛求問耶和華說：“我可以追趕這群匪徒嗎？我可以追上他們嗎？”耶和華回答他：“你可以追趕，你必定追上，也必定把一切救回來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","於是大衛和跟隨他的六百人出發。他們到了比梭溪，有些跟不上的就留在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","有二百人太疲乏，不能渡過比梭溪，就留在那裡，大衛和四百人繼續追趕。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","他們在田野裡遇見一個埃及人，就把他帶到大衛那裡。他們給他飯吃，又給他水喝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","又給他一塊無花果餅，兩個葡萄餅。他吃了，精神就恢復過來，因為他已經三天三夜沒有吃東西，沒有喝水了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","大衛問他：“你是屬誰的？你從哪裡來？”他回答：“我是個埃及的青年人，是亞瑪力人的奴僕。因為我三天前病了，我的主人就把我丟棄了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","我們侵襲了基利提的南方和屬猶大地的南方，以及迦勒地的南方，又用火燒了洗革拉。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","大衛對他說：“你願意帶我下到那一群匪徒那裡嗎？”他回答：“如果你指著　神向我起誓，不殺死我，也不把我交在我主人手裡，我就帶你下到那一群匪徒那裡去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","他帶大衛下去。匪徒們都分散在各處，正在吃喝、跳舞，因為他們從非利士地和猶大地搶來的戰利品很多。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","大衛擊殺他們，從黃昏直到次日的晚上。除了四百個騎駱駝的年輕人逃跑了以外，他們當中一個人也沒有逃脫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","亞瑪力人搶去的一切，大衛都救回來了，也救回了他的兩個妻子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","無論大小，不分男女，無論是他們搶來的，或是被人擄去的，大衛都奪回來，沒有失落一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","大衛奪了所有的羊群和牛群，跟從大衛的人把牠們趕到原有的群畜面前，說：“這是大衛的戰利品。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","大衛來到那二百人那裡，那些人因太疲乏不能跟隨大衛去，而留在比梭溪旁；他們出來迎接大衛和跟隨他的眾人。大衛接近眾人的時候，就向他們問安。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","與大衛一起去的那些人中，有些惡人和流氓說：“他們沒有和我們一起去，我們就不把奪回來的戰利品分給他們，只把他們各人的妻子和兒子還給他們，讓他們領回去就是了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","大衛說：“兄弟們，耶和華賜給我們的，你們不可以這樣作。他保護了我們，又把那些攻擊我們的匪徒交在我們手裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","這事誰要聽從你們呢？下戰場的得多少，留守武器的也得多少，應當大家平分。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","從那天起，大衛定此為以色列的律例典章，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","大衛到了洗革拉，就從戰利品中取一部分送給他的朋友、猶大的長老，說：“看哪，這是從耶和華的仇敵那裡得來的戰利品，送給你們作禮物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","他送禮物給在伯特利的、在南地拉末的、在雅提珥的、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","在亞羅珥的、在息末的、在以實提莫的、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","在拉哈勒的、在耶拉蔑各城的、在基尼各城的、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","在何珥瑪的、在歌拉珊的、在亞撻的、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","在希伯崙的人，又送給一切大衛及其跟隨者所到過之地的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","非利士人與以色列人交戰。以色列人從非利士人面前逃跑，有很多人在基利波山上倒斃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","非利士人緊緊追趕掃羅和他的眾子，擊殺了掃羅的兒子約拿單、亞比拿達和麥基舒亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","戰爭激烈，掃羅受到猛烈的攻擊，弓箭手發現了他，射箭的人射中了他，他的傷勢嚴重； ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","掃羅就對替他拿兵器的人說：“拔出你的刀來，把我刺透，免得這些未受割禮的人來把我刺透，戲弄我。”但替他拿兵器的人不肯這樣作，因為他非常害怕。於是掃羅拿過刀來，自己伏在刀上死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","替他拿兵器的人看見掃羅死了，他也伏在自己的刀上，與掃羅一起死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","這樣，掃羅和他的三個兒子，以及替他拿兵器的人，還有所有跟隨他的人，都在那一天一同死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","在山谷那邊，和約旦河那邊的以色列人，看見以色列人逃跑，掃羅和他的兒子都死了，他們就棄城逃跑。非利士人就來住在城中。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","第二天，非利士人來剝那些被殺的人的衣物的時候，發現掃羅和他的三個兒子都倒斃在基利波山上， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","就砍下他的頭，解下他的兵器，又派人到非利士地的各處，去向他們的偶像的廟和人民報信。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","他們把掃羅的兵器放在亞斯他錄的廟裡，又把他的屍體釘在伯．珊的城牆上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","基列．雅比的居民聽見非利士人向掃羅所行的事， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","所有的勇士就動身，走了一整夜，把掃羅的屍體和他三個兒子的屍體都從伯．珊的城牆上取下來，帶回雅比，在那裡把他們燒了， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","又把他們的骸骨埋葬在雅比的垂柳樹下，並且禁食七天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","掃羅死後，大衛殺退了亞瑪力人回來，就在洗革拉住了兩天。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","第三天，忽然有一個人從掃羅的營回來，衣服撕裂，頭上蒙灰。這人一來到大衛面前，就俯伏在地上叩拜他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","大衛問他：“你從哪裡來？”他對他說：“我是從以色列的營中逃出來的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","大衛又問他：“情況怎麼樣？請你告訴我！”他回答：“眾人都逃離戰場，他們中間不但有許多人倒地陣亡，連掃羅和他的兒子約拿單也死了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","於是，大衛問那向他報信的年輕人：“你怎麼知道掃羅和他的兒子死了呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","那個向大衛報信的年輕人回答：“我剛巧在基利波山，看見掃羅靠在自己的矛槍上，又見有戰車和馬兵緊緊地追趕他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","他回頭看到我，就呼喚我。我說：‘我在這裡。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","他問我：‘你是誰？’我回答他：‘我是亞瑪力人。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","於是他對我說：‘請你站到我身邊來，把我殺死，因為痛苦抓住我，我卻還死不了。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","我就站到他身邊去，把他殺了，因為我知道他一倒下，就不能再活了。我摘下他頭上的王冠，取下他臂上的手鐲，帶到這裡來奉給我主。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","大衛就抓住自己的衣服，把它們全都撕裂。所有與他在一起的人也都是這樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","他們為了掃羅、他的兒子約拿單、耶和華的子民和以色列家的緣故悲哀、哭泣、禁食直到晚上，因為他們已經倒斃在刀下。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","大衛問那向他報信的年輕人：“你是哪裡的人？”他回答：“我是個寄居這地的亞瑪力人的兒子。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","大衛對他說：“你伸手毀滅耶和華的受膏者，怎麼還不懼怕呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","於是大衛叫了一個年輕人來，說：“你上前去，砍倒他。”那年輕人擊殺他，他就死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","大衛對他說：“你流人血的罪要歸到自己的頭上，因為你親口作證指控自己說：‘我殺了耶和華的受膏者。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_17","011_1_17","2SA","1","17","17","大衛為掃羅和他的兒子約拿單作了這首哀歌。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_18","011_1_18","2SA","1","18","18","他又吩咐要把這首“弓歌”教導猶大人。（這首歌記錄在《雅煞珥書》上。） ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","“以色列啊！尊榮的人都在高處被殺，勇士怎麼都已仆倒！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","你們不要在迦特報道，不要在亞實基倫的街上宣揚，免得非利士的女子歡喜，免得未受割禮之人的女子快樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","基利波的群山啊！願雨露都不降在你們上面，願你們的田地不產供物。因為勇士的盾牌在那裡玷污，掃羅的盾牌沒有用油抹亮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","不見被殺者的血、勇士的脂油，約拿單的弓不縮回，掃羅的劍也不空空返回。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","掃羅和約拿單，生時相親相愛，死時也不分離。他們比鷹還快速，比獅子更勇猛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","以色列的女子啊！你們要為掃羅哭泣，他曾給你們穿上紫色豪華的衣服，又給你們的外衣加上金飾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","勇士怎麼會在戰陣上倒斃，約拿單在高處被刺死！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","我的兄弟約拿單啊！我為你悲痛，你是我最好的朋友，你對我的愛情遠超過婦女的愛情。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","勇士怎麼會倒斃！爭戰的武器怎麼會毀滅！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","這事以後，大衛求問耶和華說：“我可以上猶大的一座城去嗎？”耶和華回答：“你上去吧。”大衛又問：“我應該上到哪裡去呢？”他回答：“上希伯崙去！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","於是大衛帶著他的兩個妻子，一個是耶斯列人亞希暖，一個是作過迦密人拿八妻子的亞比該，上到那裡去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","大衛也把與他在一起的人，和他們各人的家眷都帶上去。他們就在希伯崙的城鎮裡住下來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","於是猶大人來到希伯崙，在那裡膏立了大衛作王，統治猶大家。有人報告大衛說：“埋葬掃羅的是基列．雅比人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_5","011_2_5","2SA","2","5","5","大衛就差派使者到基列．雅比人那裡去，對他們說：“願耶和華賜福給你們，因為你們厚待了你們的主掃羅，把他埋葬了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_6","011_2_6","2SA","2","6","6","你們既作了這事，現在就願耶和華以慈愛和誠實待你們，我也要善待你們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","現在你們要堅強，要作勇敢的人，因為你們的主掃羅已經死了；猶大家已經膏立了我作他們的王了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","當時，掃羅的元帥尼珥的兒子押尼珥已經領著掃羅的兒子伊施波設，把他帶過河到瑪哈念去， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","並且立了他作王，統治基列、亞書利、耶斯列、以法蓮、便雅憫和以色列眾人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","掃羅的兒子伊施波設作以色列王的時候，已經四十歲；他作王共兩年。猶大家卻追隨大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","大衛在希伯崙作王統治猶大家的時候共有七年零六個月。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","尼珥的兒子押尼珥帶著掃羅的兒子伊施波設的僕從，離開瑪哈念，到基遍去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","洗魯雅的兒子約押和大衛的臣僕也出來，在基遍的水池旁邊與他們會面。大家都坐下，一隊在水池這邊，一隊在水池那邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","押尼珥對約押說：“讓年輕人起來，在我們面前比比武。”約押說：“好！叫他們起來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","他們就起來，按著人數走過去：屬便雅憫，就是屬掃羅的兒子伊施波設的，有十二人；屬大衛臣僕的也有十二人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","他們各人都緊緊抓住對手的頭，用刀刺進對手的肋旁，於是他們全都倒斃。所以在基遍那地方就叫作希利甲．哈素林。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","那天的戰事非常激烈，結果押尼珥和以色列人敗在大衛的臣僕面前。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","洗魯雅的三個兒子約押、亞比篩和亞撒黑都在那裡。亞撒黑的腿輕快如野地的羚羊一般。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","亞撒黑追趕押尼珥，緊緊地跟著他，不偏左，也不偏右。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","押尼珥往後瞧著，說：“你是亞撒黑嗎？”他回答：“我正是。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","押尼珥對他說：“你或轉左或轉右，抓住一個年輕人，奪去他的武器吧！”可是亞撒黑不願意離開不追趕他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","押尼珥再一次對亞撒黑說：“你離開，別追趕我！我為甚麼要把你砍倒在地上呢？以後怎麼還有臉見你的哥哥約押呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","亞撒黑不肯離開，所以押尼珥就用槍的尾端刺入了他的肚子，槍從他的背後穿出。亞撒黑仆倒在那裡，當場死了。所有來到亞撒黑倒斃的地方的人，都站住不動。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","約押和亞比篩卻繼續追趕押尼珥。日落的時候，他們來到亞瑪山，就在通往基遍曠野的路旁，基亞的對面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","便雅憫人集結在押尼珥後面，站在一座山頭上，列成一個隊伍。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","押尼珥對約押喊叫，說：“刀劍要不停地殺人嗎？你不知道結局是痛苦的嗎？你要等到甚麼時候才吩咐人民轉去，不追趕自己的兄弟呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","約押說：“我指著永活的　神起誓，如果你們沒有說過比武的話，大家必在早晨的時候離去，不再追趕自己的兄弟。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","於是約押吹響號角，眾人就站住，不再追趕以色列人，也不再打仗了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","押尼珥和屬他的人，整夜走過亞拉巴，渡過約旦河，又走過畢倫，才回到瑪哈念。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","約押追趕押尼珥回來，集合所有人的時候，發現在大衛的臣僕中，除了亞撒黑以外，還少了十九個人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","但大衛的臣僕擊殺便雅憫人和跟隨押尼珥的人，共有三百六十人死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","他們把亞撒黑抬回去，埋葬在伯利恆他父親的墳墓裡。約押和屬他的人走了一整夜，天亮的時候才回到希伯崙。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","掃羅家和大衛家之間的戰爭相持很久。大衛家逐漸興盛，掃羅家卻日趨衰微。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","大衛在希伯崙生了幾個兒子：他的長子暗嫩，是耶斯列人亞希暖所生的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","次子基利押，是作過迦密人拿八的妻子亞比該所生的。三子押沙龍，是基述王達買的女兒瑪迦所生的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","四子亞多尼雅，是哈及所生的。五子示法提雅，是亞比他所生的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","六子以特念，是大衛妻子以格拉所生的。這些兒子都是大衛在希伯崙所生的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","當掃羅家和大衛家交戰的時候，押尼珥在掃羅家的權勢日漸強大。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","掃羅有一個妃子，名叫利斯巴，是愛亞的女兒。伊施波設對押尼珥說：“你為甚麼親近我父親的妃子呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","押尼珥因伊施波設的話非常忿怒，說：“我是猶大的狗頭嗎？今天我厚待你的父親掃羅家、他的兄弟和他的朋友，沒有把你交在大衛的手中；可是，今天你竟為了這女人的事來找我的錯！ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_9","011_3_9","2SA","3","9","10","我若不按著耶和華向大衛所起誓應許的去行：廢去掃羅家的王國，建立大衛的王位，使他統治以色列和猶大，從但直到別是巴，願　神降罰押尼珥，重重地降罰他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","伊施波設因為懼怕押尼珥，就連一句話也不敢回答他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","押尼珥差派使者代表他去見大衛，說：“這地是屬誰的呢？”又說：“你與我立約，我就必幫助你，使全以色列都歸順你。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","大衛說：“好！我與你立約。不過，我要求你一件事：你來見我面的時候，首先要把掃羅的女兒米甲帶來，否則你必不得見我的面。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","後來，大衛差派使者去見掃羅的兒子伊施波設，說：“請你把我的妻子米甲還給我，她是我從前用一百個非利士人的包皮聘下的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","於是伊施波設派人去，把米甲從拉億的兒子她丈夫帕鐵那裡接回來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","米甲的丈夫與她一起去，跟在她後面，一邊走、一邊哭，一直跟到巴戶琳。押尼珥對他說：“你去吧！回去吧！”他只好回去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","押尼珥與以色列的長老商議說：“從前你們希望大衛作你們的王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","現在可以實現了！因為耶和華曾經論到大衛說：‘我要藉著我的僕人大衛的手，把我的子民以色列從非利士人和他們所有敵人的手中拯救出來。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","押尼珥也把這話說給便雅憫人聽，然後又去希伯崙，把以色列人和便雅憫全都同意的一切事說給大衛聽。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","押尼珥帶著二十個人，來到希伯崙見大衛的時候，大衛就為押尼珥和與他同來的人擺設筵席。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","後來，押尼珥對大衛說：“讓我去把以色列眾人召集到我主我王這裡來，好叫他們與你立約，這樣你就可以照著自己的心願統治所有的人。”於是大衛打發押尼珥回去，他就平平安安地走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","那時，大衛的臣僕和約押攻擊敵人回來，帶回許多的戰利品。當時，押尼珥不在希伯崙大衛那裡，因為大衛已經打發他離去，他也平平安安地走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","約押和跟隨他的全軍一到達，就有人告訴約押，尼珥的兒子押尼珥曾經來見過王。王打發他離去，他已經平平安安地走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","約押進去見王，說：“你作了甚麼事？尼珥的兒子押尼珥來見你，你為甚麼把他送走？現在他已經平平安安地走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","你認識尼珥的兒子押尼珥，他來是要欺騙你，是要了解你的起居行動和你所作的一切事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","約押從大衛那裡出來，就差派使者去追趕押尼珥，使者從西拉的水井那裡把他帶回來。可是，大衛一點都不知道。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","押尼珥回到了希伯崙，約押就拉他到城門旁邊與他密談。約押就在那裡刺透他的肚子，他就死了。這樣，他替自己的兄弟亞撒黑報了血仇。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","事後大衛聽到了，就說：“關於尼珥的兒子押尼珥的血案，我和我的國家，在耶和華面前永遠是無辜的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","願這流人血的罪歸到約押的頭上和他父親的全家！又願約押家不斷有患血漏病的、長痲風的、拿拐杖的、倒斃在劍下的和缺乏糧食的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","因押尼珥在基遍的戰場上，殺死了他們的兄弟亞撒黑，約押和他的兄弟亞比篩就殺了押尼珥。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","大衛對約押和與他在一起的眾人說：“你們要撕裂衣服，腰束麻布，在押尼珥面前哀哭！”大衛王也走在棺木後面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","他們把押尼珥埋葬在希伯崙。王在押尼珥的墓旁放聲大哭，眾人也都哭了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","王又為押尼珥作了哀歌，說：“難道押尼珥死去，要像愚妄的人死去一樣嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","你的手沒有被繩索綁住，你的腳也沒有被銅鍊鎖住，你倒斃，好像人在暴徒面前倒斃一樣！”於是，眾民又為押尼珥哀哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","還在白天的時候，眾人都來勸大衛吃點飯；大衛起誓說：“我若在日落以前吃飯或吃甚麼東西，願　神降罰我，重重地降罰我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","眾人看見了，就都喜悅。王所作的一切，他們都很喜悅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","那一天眾人和全以色列都知道，殺死尼珥的兒子押尼珥，並不是出於王的意思。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","王對他的臣僕說：“你們不知道今天在以色列中，有一位將領和偉人倒斃了嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","今天我雖然受膏為王，但我還是幼弱的。洗魯雅的兩個兒子太強了，非我所能應付。願耶和華照著惡人所行的惡，報應惡人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","掃羅的兒子伊施波設聽見押尼珥在希伯崙死了，就怕得手都發軟，以色列眾人也都驚惶失措。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","掃羅的兒子伊施波設有兩個統率突擊隊的將領，一個名叫巴拿，一個名叫利甲，他們是便雅憫支派比錄人臨門的兒子。（比錄也算是便雅憫的一部分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","比錄人原先逃到基他音，就在那裡寄居，直到今日。） ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","掃羅的兒子約拿單有一個兒子，雙腿都跛了。掃羅和約拿單死亡的消息從耶斯列傳到的時候，他才五歲。他的乳母抱著他逃跑。乳母在慌忙中逃跑，孩子掉了下來，腿就瘸了。他的名字叫米非波設。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","比錄人臨門的兒子利甲和巴拿出去，約在正午炎熱的時候，來到了伊施波設的家。伊施波設正在睡午覺。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_6","011_4_6","2SA","4","6","6","他們進了屋裡，假裝要拿麥子，就刺透伊施波設的肚腹，然後利甲和他的兄弟巴拿都逃脫了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_7","011_4_7","2SA","4","7","7","他們進屋子的時候，伊施波設正在自己的臥室裡躺在床上，他們刺透他，把他殺死，然後割下他的頭，拿著頭顱在亞拉巴的路上走了一夜， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","把伊施波設的頭帶到希伯崙去見大衛，對王說：“你的仇敵掃羅過去常常尋索你的命。看哪！這是他兒子伊施波設的頭。今天耶和華在掃羅和他後裔的身上為我主我王報了仇了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","大衛回答比錄人臨門的兒子利甲和他的兄弟巴拿，說：“我指著那曾救贖我的命脫離一切患難的永活的耶和華起誓： ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","從前有人向我報信說：‘看哪！掃羅死了。’他自以為是報好消息，我卻抓住他，把他殺在洗革拉，這就是我給他作報好消息的酬報。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","何況惡人在義人的家裡，把義人殺在床上。現在我怎能不從你們手中追討流他血的罪，把你們從這世上除滅呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","於是，大衛吩咐年輕人把他們殺了，並且砍斷他們的手腳，把身體掛在希伯崙的水池旁邊；卻把伊施波設的頭拿去，埋葬在希伯崙押尼珥的墳墓裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","以色列眾支派都到希伯崙來見大衛，說：“看哪！我們都是你的骨肉至親。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","從前掃羅作我們的王的時候，領導以色列人行動的是你。耶和華也曾對你說：‘你要牧養我的子民以色列，要作以色列的領袖。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","以色列的眾長老都到希伯崙來見王。大衛王在希伯崙耶和華面前與他們立約，他們就膏立大衛作以色列的王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","大衛登基的時候是三十歲，在位共四十年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","他在希伯崙作猶大的王七年零六個月；在耶路撒冷作全以色列和猶大的王三十三年。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","大衛和隨從他的人到了耶路撒冷，要攻打住在那地的耶布斯人。耶布斯人對大衛說：“你不能進這裡來，這些瞎眼的、跛腳的就能把你抵擋住。”他們心裡想：“大衛決不能進那裡去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","大衛卻攻取了錫安的保障，就是大衛的城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","那一天大衛說：“攻打耶布斯人的，要把大衛心中恨惡的‘瞎子’和‘瘸子’丟進水溝裡。”因此有句俗語說：“瞎眼的或瘸腿的，都不能進殿裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","後來大衛住在保障裡，稱保障為“大衛的城”。大衛又從米羅向裡面周圍築牆。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","大衛漸漸強大，因為耶和華萬軍的　神與他同在。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","推羅王希蘭差派使者來見大衛，又送來香柏木、木匠和石匠，他們就給大衛建造宮殿。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","大衛就知道耶和華已經立他作以色列的王，又因自己的子民以色列的緣故，使他的國興盛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","大衛離開希伯崙後，在耶路撒冷又娶了多位妃嬪，並且生了很多兒女。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","以下這些就是他在耶路撒冷所生的孩子的名字：沙母亞、朔罷、拿單、所羅門、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","益轄、以利書亞、尼斐、雅非亞、 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","以利沙瑪、以利雅大、以利法列。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","非利士人聽見有人膏立了大衛作王統治以色列人，就全體上來搜尋大衛。大衛聽見了，就下到保障去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","非利士人來到，散布在利乏音谷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","大衛求問耶和華說：“我可以上去攻打非利士人嗎？你會把他們交在我手裡嗎？”耶和華對大衛說：“你可以上去，我必把非利士人交在你手裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","於是大衛來到巴力．毗拉心，在那裡擊敗了非利士人，說：“耶和華在我面前沖破我的敵人，好像洪水沖破堤岸一般。”因此他給那地方起名叫巴力．毗拉心。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","非利士人把他們的神像遺棄在那裡，大衛和跟隨他的人就把它們拿走了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","非利士人又上來，散布在利乏音谷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","大衛又求問耶和華，耶和華說：“你不要直接上去，要繞到他們後面，從桑林對面攻打他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","你一聽到桑林樹梢上有腳步的聲音，就要趕快行動，因為那時耶和華已經在你前面出去擊殺非利士人的軍隊了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","於是大衛照著耶和華所吩咐他的去作，擊殺非利士人，從迦巴直到基色。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","大衛又聚集以色列中所有揀選出來的三萬人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","大衛和與他在一起的眾人起程前去，要從巴拉．猶大把　神的約櫃運來，這約櫃的名稱是以坐在二基路伯之上萬軍之耶和華的名字而起的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_3","011_6_3","2SA","6","3","3","他們把　神的約櫃從山岡上亞比拿達的家裡抬出來，安放在一輛新車上；亞比拿達的兩個兒子，烏撒和亞希約趕著這輛新車， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_4","011_6_4","2SA","6","4","4","車上有　神的約櫃。亞希約走在約櫃的前面。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","大衛和以色列全家在耶和華面前用各種松木製造的樂器，就是用琴、瑟、鼓、鈸、鑼，作樂跳舞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","他們到了拿艮的打禾場的時候，因為牛幾乎絆倒，烏撒就伸手扶住　神的約櫃。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","耶和華的怒氣向烏撒發作；　神因這錯誤的舉動，就當場擊殺他，他就死在　神的約櫃旁邊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","大衛因為耶和華擊殺了烏撒，就很生氣，因此稱那地方為毗列斯．烏撒，直到今日。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","那一天，大衛懼怕耶和華，說：“耶和華的約櫃怎可以到我這裡來呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","於是大衛不肯把耶和華的約櫃運進大衛的城到他那裡去，卻轉運到迦特人俄別．以東的家裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","耶和華的約櫃在迦特人俄別．以東的家停留了三個月，耶和華賜福給俄別．以東和他的全家。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","有人告訴大衛王：“耶和華因為　神的約櫃的緣故，賜福給俄別．以東的家和一切屬他的。”大衛就去，歡歡喜喜把　神的約櫃從俄別．以東的家中抬上大衛的城裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","那些抬耶和華的約櫃的人走了六步，大衛就獻一頭公牛和一隻肥畜為祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","大衛束著細麻布的以弗得，在耶和華面前極力跳舞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","這樣，大衛和以色列全家，以歡呼和角聲，把耶和華的約櫃抬了上來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","耶和華的約櫃運進大衛城的時候，掃羅的女兒米甲從窗戶往外觀看，看見大衛王在耶和華面前跳躍舞蹈，心裡就鄙視他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","他們把耶和華的約櫃抬進去，安放在帳棚裡它自己的地方，就是安放在大衛給它支搭的帳棚裡，大衛就在耶和華面前獻上燔祭和平安祭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","大衛獻完了燔祭和平安祭，就奉萬軍之耶和華的名給人民祝福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","又分給眾人，就是分給以色列全體群眾，無論男女，每人一個餅、一個棗餅、一個葡萄乾餅；然後眾人就各歸各家去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","大衛回去要給自己的家人祝福。掃羅的女兒米甲出來迎見大衛，說：“以色列王今天多麼榮耀啊！他今天竟在眾臣僕的婢女眼前，赤身露體，就像一個卑賤的人露體一樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","大衛對米甲說：“我是在耶和華面前跳舞；耶和華揀選了我，使我高過你父親和他的全家，立我作耶和華的子民以色列的領袖，所以我要在耶和華面前跳舞作樂。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","我還要比今天這樣更卑賤，我要自視卑微。至於你所說的那些婢女，她們倒要尊重我。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","掃羅的女兒米甲，一直到她死的日子，都沒有生育。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","那時，王住在自己的宮中，耶和華使他安享太平，不受周圍仇敵的侵擾。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","王對拿單先知說：“你看！我自己住在香柏木的宮裡，耶和華的約櫃卻停在帳幕內。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","拿單對王說：“你可以照著你心所想的一切去作，因為耶和華與你同在。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","那天晚上，耶和華的話臨到拿單說： ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“你去對我的僕人大衛說：耶和華這樣說：‘你要建造一座殿宇給我居住嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","因為自從我把以色列人從埃及帶上來的那天起，直到今日，我都沒有住過殿宇。我一直都住在帳棚和會幕裡，到處漂泊。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","我與以色列眾人一起走過的地方，我可曾對以色列的一個支派的官長，就是我所吩咐要牧養我子民以色列的，說：你們為甚麼不給我建造一座香柏木的殿宇呢？’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","現在你要對我的僕人大衛這樣說：‘萬軍之耶和華這樣說：我把你從牧場中、從照顧羊群的工作中揀選出來，使你作我子民以色列的領袖， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","你無論到哪裡去，我都與你同在；我必在你面前剪除你所有的仇敵。我要使你得享大名，像世上那些偉人的名一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","我要為我的子民以色列選定一個地方，不再受騷擾；惡人也不能再像以前那樣苦待他們， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","像我立了士師治理我的子民以色列的那天以來那樣。我要使你安享太平，不受你所有的仇敵侵擾。耶和華向你宣告，耶和華要親自為你建立一個朝代。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","到了你的壽數滿足，你與你的列祖一起長眠的時候，我必興起你親生的後裔接替你，並且我要堅固他的國。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","他必為我的名建造一座殿宇，我要永遠堅固他的國位。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","我要作他的父親，他要作我的兒子，他若是犯了罪，我要用人的刑杖、用世人的鞭子糾正他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","但我的慈愛必不離開他，像離開在你面前的掃羅一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","你的家和你的王國，也必在我的面前永遠堅定，你的王位也必永遠堅立。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","拿單按著這一切話，又照著全部的默示，都對大衛說了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","於是，大衛王進去，坐在耶和華面前，說：“主耶和華啊！我是誰，我的家又算甚麼，你竟帶領我到這地步？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","主耶和華啊，這在你眼中還看為小事，你也說到你僕人的家未來的事。主耶和華啊，這豈是人常遇到的事嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","主耶和華啊，你認識你的僕人，大衛還有甚麼話可以對你說呢？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","你因自己應許的緣故，又按照自己的心意，行了這大事，為要使你僕人明白。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","主耶和華啊，因此，你是偉大的！按照我們耳朵所聽見的，沒有像你的，除了你以外，再沒有別的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","世上有哪一個國家像你的子民以色列呢？　神曾親自救贖他們，使他們作自己的子民，又為他自己立名，為他們作了大事，為你的地作了可畏的事；在你的子民面前，就是你從埃及救贖出來歸你自己的子民面前，趕出了列國的人和他們的神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","你為自己堅立了你的子民以色列，使他們永遠作你的子民；耶和華啊，你也作了他們的　神。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","耶和華　神啊！你所應許關於你僕人和他的家的話，現在求你永遠堅守，並且照著你所說的去行吧； ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","這樣，你的名必永遠為大，以致人要說：‘萬軍之耶和華是以色列的　神。’你僕人大衛的家也必在你面前得堅立。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","萬軍之耶和華以色列的　神啊！因為你曾啟示你的僕人說：‘我要為你建立家室。’所以你的僕人才敢來向你作這樣的禱告。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","主耶和華啊！你是　神；你的話是真實可信的。你向你僕人應許了這美好的福分。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","現在求你樂意賜福給你僕人的家，使它在你面前可以永遠存在。主耶和華啊！因為你曾經這樣應許，願你僕人的家因你的賜福永遠蒙福。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","這事以後，大衛攻打非利士人，制伏了他們。大衛從非利士人手中取得了京城的控制權。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","他又擊敗摩押人，使他們躺在地上，用繩子量他們，把量兩繩的殺死，讓量一繩的存活。這樣，摩押人就臣服大衛，給他進貢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","瑣巴王利合的兒子哈大底謝，往幼發拉底河去要奪回他統治這河的勢力的時候，大衛就攻打他。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","大衛從他那裡擄獲了騎兵一千七百，步兵二萬；除了留下足夠拉一百輛鐵車的馬以外，大衛把其他所有拉戰車的馬都砍斷蹄筋。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","大馬士革的亞蘭人來協助瑣巴王哈大底謝，大衛就擊殺了亞蘭人二萬二千。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","於是大衛在大馬士革的亞蘭地駐軍。這樣亞蘭人就臣服大衛，給他進貢。大衛無論到甚麼地方去，耶和華都使他得勝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","大衛奪取了哈大底謝臣僕所拿的金盾牌，帶回耶路撒冷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","大衛王又從哈大底謝的兩座城比他和比羅他奪取了大量的銅。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","哈馬王陀以聽見大衛打敗了哈大底謝的全軍， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","就差派他的兒子約蘭去見大衛王，向他問安，祝賀他，因為大衛和哈大底謝爭戰，竟擊敗了他。原來陀以常常與哈大底謝爭戰。約蘭手裡還帶著一些銀器、金器和銅器。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","大衛王也把這些器皿，連同他從他征服的各國得來的金銀都一起分別為聖，獻給耶和華。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","就是從以東、摩押、亞捫人、非利士人、亞瑪力人所得來的，以及從瑣巴王利合的兒子哈大底謝獲得的戰利品。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","大衛在鹽谷擊殺了一萬八千以東人回來以後，就大有名聲。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","他又在以東設立防軍；他在以東各地都設立防軍，所有以東人就都臣服大衛。大衛無論到甚麼地方去，耶和華都使他得勝。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","大衛作王統治全以色列，以公平和正義對待所有的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","洗魯雅的兒子約押作軍隊的統帥，亞希律的兒子約沙法作史官， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","亞希突的兒子撒督和亞比亞他的兒子亞希米勒作祭司長，西萊雅作書記， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","耶何耶大的兒子比拿雅統管基利提人和比利提人；大衛的眾子都作領袖。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","大衛問：“掃羅家還有剩下的人沒有？我要因約拿單的緣故，以慈愛待他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","掃羅家有一個僕人，名叫洗巴。有人叫他來見大衛；王問他：“你是洗巴嗎？”他回答：“僕人正是。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","王又問：“掃羅家還有人沒有？我要以　神的慈愛待他。”洗巴回答王說：“還有約拿單的一個兒子，他雙腳殘廢了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","王又問他說：“他在哪裡？”洗巴回答王說：“他在羅．底巴亞米利的兒子瑪吉家裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","於是大衛王派人去把他從羅．底巴亞米利的兒子瑪吉家裡接來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","掃羅的孫子，約拿單的兒子米非波設來到大衛面前，俯伏叩拜。大衛說：“米非波設！”他回答：“僕人在這裡。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","大衛對他說：“你不要怕，我必因你父親約拿單的緣故，以慈愛待你，把你祖父掃羅所有的田地都歸還給你；你也可以常常與我同席吃飯。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","米非波設再叩拜說：“僕人算甚麼？你竟然眷顧我這個像條死狗的人！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","王把掃羅的僕人洗巴召來，對他說：“我已經把屬於掃羅，以及他全家所有的一切，給了你主人的孫子。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","你和你的兒子，以及你的僕人，都要替他耕種田地；你要把所收穫的拿來，供他食用。米非波設要常常與我同席吃飯。”洗巴有十五個兒子，二十個僕人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","洗巴對王說：“我主我王吩咐僕人的一切，僕人都必遵行。”於是米非波設與王同桌吃飯，像是王的一個兒子一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","米非波設有一個小兒子，名叫米迦。住在洗巴家裡的人，都作了米非波設的僕人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","這樣，米非波設住在耶路撒冷，常常與王同席吃飯。可是他的雙腿都是瘸的。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","後來，亞捫人的王死了，他的兒子哈嫩繼承他作王。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","大衛說：“我要恩待拿轄的兒子哈嫩，像他父親恩待我一樣。”於是大衛差派自己的臣僕，為他喪父的事安慰他。大衛的臣僕到了亞捫人境內時， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","亞捫人的眾領袖對他們的主哈嫩說：“大衛差派這些慰問的人到你這裡來，你以為他是尊敬你父親嗎？他派遣臣僕到你這裡來，不是為了要窺探這城，偵察清楚，然後把城傾覆嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","於是哈嫩拿住大衛的臣僕，把他們的鬍鬚剃去一半，又把他們的外袍割去半截，露出臀部，然後才放他們走。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","有人告訴大衛，他就派人去迎接他們，因為他們非常羞恥。王就說：“你們可以住在耶利哥，等到你們的鬍鬚長長了才回來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","亞捫人知道大衛憎惡他們，就派人去招募伯．利合的亞蘭人和瑣巴的亞蘭人，步兵二萬，瑪迦王的人一千，陀伯人一萬二千。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","大衛聽見了，就差派約押和全體勇士出去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","亞捫人出來，在城門前擺陣，瑣巴和利合的亞蘭人，陀伯人和瑪迦人，也分別在郊野擺陣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","約押看見自己前後受敵，就從以色列所有的精兵中，挑選一部分出來，使他們擺陣去迎戰亞蘭人， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","他把其餘的人交在他兄弟亞比篩手下，使他們擺陣去迎戰亞捫人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","約押對亞比篩說：“如果亞蘭人比我強，你就來幫助我。如果亞捫人比你強，我就去幫助你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","你要剛強；為了我們的人民和我們　神的眾城鎮，我們要剛強！願耶和華成全他看為美的事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","於是約押和與他在一起的人前進，攻擊亞蘭人；亞蘭人在約押面前逃跑。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","亞捫人看見亞蘭人逃跑，他們也在亞比篩面前逃跑，逃進城裡去了。約押就從亞捫人那裡回來，回到耶路撒冷去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","亞蘭人見自己被以色列人擊敗，就再聚集起來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","哈大底謝差遣人把幼發拉底河那邊的亞蘭人調來。他們來到了希蘭，由哈大底謝的將軍朔法率領他們。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","有人告訴了大衛，他就聚集所有的以色列人，渡過約旦河，來到了希蘭。亞蘭人擺好了陣迎擊大衛，與他交戰。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","亞蘭人卻在以色列人面前逃跑。大衛殺了亞蘭七百名駕駛戰車的軍兵，四萬騎兵。又擊殺了亞蘭軍隊的將軍朔法，他就死在那裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","所有臣服於哈大底謝的王看見自己被以色列人打敗，就與以色列人議和，臣服於他們。於是亞蘭人害怕，不敢再幫助亞捫人了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","過了年，在列王出征的時候，大衛派遣約押和自己的臣僕，以及以色列眾軍一同出征。他們殲滅了亞捫人，並且包圍了拉巴。大衛卻留在耶路撒冷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","有一天近黃昏的時候，大衛從床上起來，在王宮的平頂上散步。他從平頂上看見一個婦人在洗澡；這婦人容貌美麗。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","大衛派人去查問那婦人是誰。有人說：“這不是以連的女兒、赫人烏利亞的妻子拔示巴嗎？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","於是大衛差派使者去把她接來。她來到大衛那裡，大衛就與她同房。那時她的月經剛得潔淨。事後，她就回家去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","後來那婦人懷了孕，就打發人去告訴大衛，說：“我懷孕了！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","大衛派人到約押那裡，說：“你打發赫人烏利亞到我這裡來。”約押就打發烏利亞去見大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","烏利亞來到大衛那裡，大衛就問約押和士兵可好，又問戰場上的情形怎樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","大衛對烏利亞說：“你回家去，洗洗腳吧！”烏利亞就離開了王宮。隨後王的一份禮物也跟著送去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","烏利亞卻和他主人的臣僕一同睡在王宮門外，沒有回到自己家裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","有人告訴大衛說：“烏利亞沒有下到自己家裡去。”大衛就問烏利亞：“你不是從遠路回來嗎？為甚麼不下到自己家裡去呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","烏利亞回答大衛說：“約櫃、以色列人和猶大人都住在棚裡，我主人約押和我主人的臣僕都在野地安營，我怎能回家吃喝，與妻子同睡呢？我指著王和王的生命發誓：我絕不敢作這樣的事。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","大衛對烏利亞說：“你今天還留在這裡，明天我才打發你去。”那一天，烏利亞就留在耶路撒冷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","次日，大衛召了烏利亞來，叫烏利亞與他一起吃喝，使他喝醉。到了晚上，烏利亞出去，與他主人的臣僕一同睡在自己的床鋪上，還是沒有下到自己家裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","到了早晨，大衛寫了一封給約押的信，交烏利亞親手帶去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","他在信裡寫著說：“要把烏利亞派到戰鬥最猛烈的前線去，然後你們就退到他後邊，讓他被擊殺。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","那時，約押正在圍城，他知道哪裡有強悍的守軍，就派烏利亞到那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","城裡的人出來，與約押交戰。大衛的僕人中有一些倒斃了，赫人烏利亞也死了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","於是，約押派人去把戰事的一切情形都報告大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","他又吩咐那使者說：“你把戰事的一切情形對王說完了以後， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","王若是大怒，責問你：‘你們為甚麼那樣靠近那城爭戰呢？你們不知道敵人會從城牆上射箭下來嗎？ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","從前擊殺了耶路．比設的兒子亞比米勒的是誰呢？不是一個婦人從城牆上把一塊磨石丟在他身上，他就死在提備斯嗎？你們為甚麼靠近城牆呢？’你就回答：‘王的僕人赫人烏利亞也死了。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","於是那使者去了；他一來到，就把約押差遣他所要說的一切都報告了大衛。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","那使者又對大衛說：“那些人比我們強，他們出到曠野攻打我們，我們把他們趕回城門口。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","那時射手從城牆上射王的僕人；王的僕人中有些陣亡了，你的僕人赫人烏利亞也死了。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","大衛對那使者說：“你要對約押這樣說：‘不要為這件事難過，因為刀劍有時吞滅這人，有時吞滅那人。你只要加緊攻打這城，把城毀滅。’你要這樣鼓勵他。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","烏利亞的妻子聽到丈夫烏利亞死了，就為他哀哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","守喪期一過，大衛就派人去把拔示巴接到宮裡，她就作了大衛的妻子，給大衛生了一個兒子。大衛所作的這事，耶和華看為惡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","耶和華差派拿單去見大衛。於是拿單來到大衛那裡，對他說：“在一座城裡有兩個人，一個富有，一個貧窮。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","那富有的有極多牛羊， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","那貧窮的除了買來養的一隻母羊羔以外，甚麼也沒有。那小羊在他家裡和他的兒女一同長大，小羊吃他的食物，喝他杯中的飲料，睡在他的懷裡，就像他的女兒一樣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","有一個旅客來到富翁那裡，他捨不得從自己的牛群羊群中取一頭出來，款待到他那裡來的旅客，卻取了那窮人的母羊羔，款待到他那裡來的客人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","大衛就非常惱怒那人，對拿單說：“我指著永活的耶和華起誓，作這事的人該死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","他必須四倍賠償這羊羔，因為他作了這事，又因他沒有憐憫的心。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","拿單對大衛說：“你就是那人！耶和華以色列的　神這樣說：‘我膏立了你作以色列的王，把你從掃羅的手裡救了出來， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","把你主人的家賜給你，把你主人的妻妾交在你懷裡，又把以色列和猶大家賜給你。你若是還以為太少，我還可以多多加給你。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","你為甚麼藐視耶和華的話，行他看為惡的事呢？你用刀擊殺了赫人烏利亞，娶了他的妻子作你的妻子，你藉著亞捫人的刀殺了烏利亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","所以，從今以後，刀劍必不離開你的家，因為你藐視了我，娶了赫人烏利亞的妻子作你的妻子。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","耶和華這樣說：‘看哪！我必從你家中興起禍患攻擊你；我要在你的眼前把你的妃嬪拿去賜給別人。他要在光天化日之下與她們同床。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","你在暗中行了這事，我卻要在所有以色列人面前，在光天化日之下行這事報應你。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","大衛對拿單說：“我得罪了耶和華了。”拿單對大衛說：“耶和華已經除去了你的罪，你必不至於死。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","只是因為你作了這事，使耶和華的仇敵大得褻瀆的機會，所以你所生的兒子必定死。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","於是拿單回自己的家去了。耶和華擊打烏利亞的妻子給大衛所生的孩子，他就害了重病。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","大衛為那孩子懇求　神，並且禁食。他進房裡去，終夜躺在地上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","他家中的老侍從站在他旁邊，要把他從地上扶起來，他卻不肯，也不與他們一起吃飯。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","到了第七天，孩子死了。大衛的臣僕不敢告訴他孩子死了，因為他們說：“看哪，孩子還活著的時候，我們勸他，他尚且不聽我們的話。現在我們怎麼能告訴他孩子已經死了呢？他會傷心欲絕的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","大衛看見他的臣僕彼此低聲耳語，就知道孩子已經死了。他問臣僕說：“孩子死了嗎？”他們回答：“死了！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","於是大衛從地上起來，洗澡，抹膏，更換衣服，進耶和華的殿去敬拜，然後回到自己的宮裡去，吩咐人給他擺上飯，他就吃了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","臣僕問他：“你為甚麼這樣作呢？孩子還活著的時候，你為他禁食哭泣；孩子死了，你倒起來吃飯！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","他回答：“孩子還活著的時候，我禁食哭泣，因為我想：‘也許耶和華憐憫我，讓孩子可以活著。’ ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","現在他死了，我為甚麼還要禁食呢？我還能使他回來嗎？我要到他那裡去，他卻不能回到我這裡來。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","大衛安慰他的妻子拔示巴，進到她那裡去，與她同睡。她生了一個兒子，大衛給他起名叫所羅門；耶和華也喜愛他， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","就差派拿單先知去，照著耶和華的吩咐，給他起名叫耶底底亞。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","那時，約押正在攻打亞捫人的拉巴，攻取了王城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","約押派遣使者去見大衛，說：“我攻打拉巴，已經攻取了水城。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","現在，請你聚集其餘的人民，安營攻打這城，把城攻取；免得我攻取了這城，人就以我的名字來叫這城。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","於是大衛聚集所有的人民，向拉巴進軍；攻打那城，把它攻取了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","大衛從他們的王的頭上奪取了王冠。王冠的金子重三十五公斤，上面嵌有寶石，人把這冠冕戴在大衛的頭上。大衛又從這城裡帶走了許多戰利品， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","又把那城裡的人民帶出去，使他們用鋸子、鐵耙、鐵斧作工，或使他們在磚窯服役。大衛對待亞捫各城的居民都是這樣。後來，大衛和眾人都回耶路撒冷去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","大衛的兒子押沙龍有一個美麗的妹妹，名叫他瑪；大衛的兒子暗嫩愛上了她。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","暗嫩為了他妹妹他瑪的緣故，因愛成病。因為他瑪還是處女，所以暗嫩看來很難對她採取甚麼行動。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","暗嫩有一個朋友，名叫約拿達，是大衛的哥哥示米亞的兒子。約拿達是一個非常狡猾的人。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","他問暗嫩說：“王子啊！你為甚麼一天比一天瘦弱呢？你可以告訴我嗎？”暗嫩說：“我愛上了我兄弟押沙龍的妹妹他瑪。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","約拿達對他說：“你可以躺在床上裝病。你父親來看你的時候，你就對他說：‘求你叫我的妹妹他瑪來，把食物遞給我吃；叫她在我眼前預備食物，好使我可以看見，也可以從她的手中取食。’” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","於是暗嫩躺著裝病。王來看他，暗嫩對王說：“求你叫我的妹妹他瑪來，叫她在我眼前給我做兩個餅，我可以從她的手裡拿過來吃。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","大衛就派人到宮裡去對他瑪說：“你到你哥哥暗嫩的屋裡去，為他預備食物。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","他瑪就到她哥哥暗嫩的屋裡去；暗嫩正躺著。他瑪取了點麵，把麵和好，就在暗嫩面前做餅，並且把餅烤熟了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","她拿過鍋來，在他面前把餅倒出來，暗嫩卻不肯吃，他說：“叫眾人離開我出去！”眾人就都離開他出去了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","暗嫩對他瑪說：“把食物帶到臥房來，我好從你的手裡拿過來吃。”他瑪拿著她做好的餅，進了臥房，到她哥哥暗嫩那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","他瑪上到他面前，給他吃的時候，暗嫩卻拉住她，對她說：“妹妹，來與我同寢吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","他瑪對他說：“不要！哥哥！不要污辱我！在以色列中不可作這樣的事。你不要作這醜事。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","至於我，我到哪裡除去我的恥辱呢？至於你，你在以色列中也會成了一個愚妄的人。現在請你去對王說，他必不會禁止我歸你的。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","但暗嫩不肯聽她的話，他又比他瑪有力，就污辱了她，與她同寢。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","事後，暗嫩非常恨她；他對他瑪的恨比以前對她的愛更大，所以暗嫩對她說：“你起來！走吧！” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","他瑪卻對他說：“我的哥哥啊，不！你趕我出去的這罪比你剛才與我所行的罪更大了。”但是暗嫩不肯聽她的話， ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","就叫了侍候他的僕人來，說：“把這女人從我面前趕到外面去，然後把門鎖上。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","那時他瑪身上穿著長袖彩衣，因為未嫁的公主都是這樣穿的。那侍候暗嫩的僕人把她趕到外面去，隨後把門鎖上。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","他瑪把塵土撒在自己的頭上，撕裂身上的長袖彩衣，又把一隻手放在頭上，一邊行走一邊哭叫。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","她哥哥押沙龍問她：“是不是你哥哥暗嫩與你親近了？我妹妹啊，你現在不要作聲，他是你的哥哥，你不要把這事放在心上。”於是他瑪孤單淒涼地住在她哥哥押沙龍的家裡。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","大衛王聽見了這一切事，就非常生氣。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","押沙龍甚麼話都沒有對暗嫩說。押沙龍恨暗嫩，因為暗嫩污辱了他的妹妹他瑪。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","兩年以後，在以法蓮邊界的巴力．夏瑣，押沙龍雇了人為他剪羊毛，押沙龍邀請王所有的兒子到那裡去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","押沙龍去見王說：“看哪！現在你的僕人雇了人剪羊毛；請王和王的臣僕與我一同去。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","王對押沙龍說：“不！我兒，我們不必都去，免得我們成為你的重擔。”押沙龍再三勉強王去，王還是不肯去，只是為他祝福。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","押沙龍說：“王若是不去，求王讓我的哥哥暗嫩與我一同去。”王問他：“為甚麼要他與你一同去呢？” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","押沙龍再三求王，王就派暗嫩和王所有的兒子與他一同去。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","押沙龍吩咐他的僕人說：“你們注意！暗嫩酒酣耳熱的時候，我對你們說：‘擊殺暗嫩！’你們就把他殺死。不要懼怕，這不是我吩咐你們的嗎？你們要堅強，作勇敢的人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","押沙龍的僕人就照押沙龍所吩咐的，向暗嫩行了。王所有的兒子就起來，各人騎上自己的騾子逃跑了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","他們還在路上的時候，有消息傳到大衛那裡，說：“押沙龍殺了王所有的兒子，沒有剩下一個。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","王就起來，撕裂衣服，躺在地上。侍立在他身旁的所有臣僕，也都撕裂衣服。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","大衛的哥哥示米亞的兒子約拿達說：“我主不要以為所有的年輕人、王的兒子都被殺死了。其實死的只有暗嫩一人；自從暗嫩污辱了押沙龍的妹妹他瑪那一天起，押沙龍就定意要殺死他了。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","現在我主我王不要把這事放在心上，以為王所有的兒子都死了。其實死的只有暗嫩一人。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","押沙龍逃走了。守望的年輕人舉目觀看，看見許多人從後面山坡旁邊的路而來。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","約拿達對王說：“看哪！王的兒子都回來了。正如你僕人所說的，事情果然是這樣。” ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","他剛說完了，王的眾子就都來到了，他們都放聲大哭；王和他所有的臣僕也都號咷痛哭。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_37","011_13_37","2SA","13","37","37","押沙龍逃亡，走到基述王亞米忽的兒子達買那裡去了。大衛天天為他的兒子哀傷。 ");
INSERT INTO cmn_ncvt_vpl VALUES ("S213_38","011_13_38